﻿USE sofia;
DROP TABLE IF EXISTS sofia.ntr_vpl;
CREATE TABLE ntr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ntr_vpl WRITE;
INSERT INTO ntr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Gyoo Defidi na Aberaham be naanabii Yesu Kristo duuluŋ man balaŋ yaa. ");
INSERT INTO ntr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberaham lolana Asiki ");
INSERT INTO ntr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Gyuda lolana Peresi na Sera baŋ ");
INSERT INTO ntr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram lolana Aminadabo ");
INSERT INTO ntr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimɔn na ɔ wɛɛle Rahabo lolana Boase ");
INSERT INTO ntr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Gyese mɔ lolana gyoo Defidi te gyoo Defidi mɔ lolana Solomɔn. Solomɔn ɔ naa yɛna Yuria lialo ŋon gyoo Defidi ba mo yala nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomɔn mɔ lolana Rehoboam ");
INSERT INTO ntr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa lolana Gyehosafate ");
INSERT INTO ntr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yusia lolana Gyotam ");
INSERT INTO ntr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia lolana Manase ");
INSERT INTO ntr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Gyosia lolana Gyekonia na ɔ naabia debaŋ keŋ bɔɔ kyaŋ Iseraetena yoo man mo gyu Babilɔn tɛɛle man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba ke kyaŋ Iseraetena gyu Babilɔn tɛɛle man wɔle nɛ ");
INSERT INTO ntr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeli lolana Abiudi ");
INSERT INTO ntr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔ lolana Sadoki ");
INSERT INTO ntr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi mɔ lolana Eliasa ");
INSERT INTO ntr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Gyekɔpo mɔ lolana Gyosɛfo. ");
INSERT INTO ntr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mena dɔɔ lee Aberaham dɔɔ kelii gyoo Defidi dɔɔ yɛɛ kalola kegyakaare kufu anaara. Te lee gyoo Defidi dɔɔ kelii debaŋ keŋ bɔɔ kyaŋ Iseraetena gyu Babilɔn nɛ yɛɛ kalola kegyakaare kufu anaara. Te lee debaŋ keŋ bɔɔ kyaa Babilɔn kelii debaŋ keŋ bɔɔ lola Kristo mɔ nɛ yɛɛ kalola kegyakaare kufu anaara. ");
INSERT INTO ntr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo kalola wose man nombia yaa. Gyosɛfo na Yesu ɔ naa Mɛɛre yakowɔ see nyi baa yala dɔŋa. Mɔna Gyosɛfo ta kpeo ta e ya, te Wurubuarɛ feliŋ yela Mɛɛre kyaŋa fulu. ");
INSERT INTO ntr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na Gyosɛfo yɛɛ walaŋ ŋon ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman, te ɔ bɛɛ gyae nyi waa do Mɛɛre desɛŋ balaŋ man dɔɔ ya nɛ, ɔ yɛɛ wa agyueŋ nyi waa yo bɛɛ e keŋ ŋolo na ŋolo ba gyem ya. ");
INSERT INTO ntr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Debaŋ keŋ Gyosɛfo na mo mena agyueŋ kei nɛ, te de Gbeŋgyoo Wurubuarɛ kpilale ŋolo kaa lese ɔ wose wola e dosɛɛ man, te ɔ yako e nyiaa, “Defidi ɔ naanabii Gyosɛfo, na yee Mɛɛre ke yala ya. Nawolo nyi Wurubuarɛ feliŋ yele la te ɔ kyaŋa fulu kei. ");
INSERT INTO ntr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Waa lola bu baale na n ka do e yele nyi Yesu. Nawolo nyi ŋon ne gyae la waa lese ɔ balaŋ lee be nombiakumɛɛ man.” ");
INSERT INTO ntr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kɛŋa pou kɔŋawɔ mena, na kpene keŋ de Gbeŋgyoo Wurubuarɛ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Yesaya dɔɔ yako see nɛ ke kɔŋ mena ampaŋ. Nombia ŋenaŋ yɛna nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Alebu ŋon ɔ te doo ta na baale see ya nɛ waa kyaŋ fulu na waa lola bu baale na baa baake e nyi Imanuɛle.” Keŋ nawolo nyi “Wurubuarɛ kyaa de man.” ");
INSERT INTO ntr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mena dɔɔ Gyosɛfo kefoŋ nɛ, ɔ moo Mɛɛre yala ŋgba mena keŋ de Gbeŋgyoo Wurubuarɛ kpilale ŋon be yako e nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mɔna ŋon na Mɛɛre te doo ŋgba alo na baale nɛ ya kaboena ɔ lola bu baale. Te Gyosɛfo doo e yele nyi Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ba lola Yesu bo Bɛtelɛhɛm donɔɔ keŋ ke kyaa Gyudia tɛɛle man nɛ man. Debaŋ kenaŋ na gyoo Herode ne diina gyoori. Be ka lola Yesu nɛ, te di weeya ala ya te siakaralatena baale baŋ ba gyeŋ kyolobiise wose man nombia nɛ lee weese dɛɛlee yenaŋ kɔŋ Gyerusalɛm donɔɔ man, ");
INSERT INTO ntr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","kaa bɔɔse balaŋ nyiaa, “Aleŋ te ba lola bu ŋon waa kaa bese Gyudatena gyoo nɛ? Da te naa kyolobii ŋolo weese dɛɛlee yenaŋ keŋ na wola daa nyi be ta lola e, mena dɔɔ te de kɔŋawɔ de kaa som e.” ");
INSERT INTO ntr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Gyoo Herode na baŋ pou be kyaa Gyerusalɛm donɔɔ man ke nyii nombia kɛŋa nɛ, takaa wɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mena dɔɔ gyoo Herode baake Gyudatena saese kegyiise na ba mmaraa wolala pou yilaa te ɔ bɔɔse wɔ nyiaa, “Aleŋ te baa lola nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Keŋte be tiranɔɔ fa e nyiaa, “Bɛtelɛhɛm donɔɔ keŋ ke kyaa Gyudia tɛɛle man nɛ.” Nawolo nyi Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo yakowɔ see lee Bɛtelɛhɛm wose man nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Wurubuarɛ kpa, “Ɛmɛɛ Bɛtelɛhɛmtena baŋ ɛ kyaa Gyudia tɛɛle man nɛ ɛ yɛɛ gyoorobiawɔ. Nawolo nyi ɛ man te gyoo dinaa ŋon waa kɛɛ me balaŋ Iseraetena dɔɔ nɛ waa lee.” ");
INSERT INTO ntr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mena dɔɔ gyoo Herode moo Siakaralatena baŋ lee yenaŋ, te ɔ bɔɔse wɔ na waa gyeŋ debaŋ kitii keŋ kyolobii ŋon ba lee. ");
INSERT INTO ntr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Be ke tiranɔɔ fa e taŋ nɛ, ɔ yako wɔ nyiaa, “Ɛ gyu na ɛ ke kɛo bu ŋon nideli. Akpaa ɛ naa e na ɛ bese kaa yako maŋ, na maŋ mɔ ke gyu ka som e.” Keŋte ɔ lɔɔ wɔ gbɛɛ te be laŋa Bɛtelɛhɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Be ke nyii gyoo ŋon nɔɔwoya taŋ nɛ, ba korowɔ mo be gbɛɛ bee gyu. Te kyolobii ŋon bɔɔ naa weese dɛɛlee yenaŋ nɛ, tɛɛwɔ be siaman menɛɛ te ke ka seŋawɔ botɔɔ keŋ bu ŋon doo nɛ adido. ");
INSERT INTO ntr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba kena kyolobii ŋon mena nɛ, yɛɛ wɔ gyoŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Be ke gyu ka gyoo dekpaŋalaŋ keŋ man nɛ, be naa bu ŋon na ɔ naa Mɛɛre keŋte ba buŋawɔ som bu ŋon. Be gyuusu ba akpose te ba lese kɔba yayam, na oliifi na adudo kyɛɛ bu ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kenaŋ wɔle nɛ, Wurubuarɛ faree wɔ dosɛɛ man nyi be na bese gyu ka mo gyoo Herode gyaŋ bela ya, mena dɔɔ ba moo gbɛɛ wɔle kpoo man gyu be dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Siakaralatena baŋ ke laŋ wɔle nɛ, de Gbeŋgyoo Wurubuarɛ kpilale ŋolo kaa lese ɔ wose wola Gyosɛfo dosɛɛ man te ɔ yako e nyiaa, “Koro mo bu ŋon na ɔ naa na ɛ ke yeu gyu Igyipite tɛɛle man, na ɛ ke kyaa botɔɔ kelii debaŋ keŋ maa yako ŋon nyi yaa koro botɔɔ. Nawolo nyi gyoo Herode waa kɛo bu ŋon waa ko.” ");
INSERT INTO ntr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mena dɔɔ Gyosɛfo korowɔ nelim kenaŋ te ɔ moo bu ŋon na ɔ naa te be yeuwɔ gyu Igyipite tɛɛle man, ");
INSERT INTO ntr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","te be kyaawɔ botɔɔ kaboena gyoo Herode yeŋawɔ. Kɛŋa pou kɔŋawɔ mena na kpene keŋ de Gbeŋgyoo be tɛɛ ɔ dekpeŋkpeŋgyɔɔre dɔɔ yako see nɛ ke kɔŋ mena ampaŋ. Ɔ yakowɔ nyiaa, “Igyipite tɛɛle man te ma lese me bu lee.” ");
INSERT INTO ntr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gyoo Herode kena nyi Siakaralatena baŋ ta mo adao di ɔ dɔɔ, keŋ be ta bese kɔŋ kaa mo ɔ gyaŋ bela ya nɛ ɔ gyeŋa baŋ nideli. Keŋte ɔ kpila ɔ yoonɔɔtena nyi baa gyu Bɛtelɛhɛm donɔɔ man, na ke donɔɔsebia ŋan benaa na ke nɛ, na baa koe bia baala baŋ pou be ta bee ta kela kulutooneŋ ala ya nɛ, nawolo nyi mena debaŋ kenaŋ man te Siakaralatena baŋ yako e nyi be naa kyolobii ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kei yele la kpene keŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyeremia be yako see nɛ kɔŋawɔ ampaŋ. Ɔ yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“De nyii yeesa na kewii na kayeyɛɛ dinaa Rama tɛɛle man. Rahɛle ne wii ɔ bia te ɔ te bɛɛ nyi be na kyɔlɛɛ e ya, nawolo nyi ɔ bia pou te munu.” ");
INSERT INTO ntr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gyoo Herode yeŋ wɔle nɛ, Wurubuarɛ kpilale ŋolo kaa lese ɔ wose wola Gyosɛfo dosɛɛ man Igyipite tɛɛle man te ɔ yako e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Koro na n ka mo bu ŋon na ɔ naa, na ɛ ka bese gyu Iserae tɛɛle man. Nawolo nyi balaŋ baŋ nafɔ bɛɛ gyae bu ŋon baa ko nɛ ta yekee.” ");
INSERT INTO ntr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mena dɔɔ Gyosɛfo desina ɔ wose, te ɔ moo bu ŋon na ɔ naa te be laŋa Iserae tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mɔna Gyosɛfo ke nyii nyi gyoo Herode bu Akelɔse kyaa la ɔ kya nawɔɔ man ɔ ne di gyoori Gyudia tɛɛle dɔɔ nɛ, ɔ yee botɔɔ ke gyu. Te keŋ Wurubuarɛ be faree e dosɛɛ man dɔɔ nɛ, ɔ kpasewɔ gyu Galelia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te ɔ gyuuwɔ ke kyaa donɔɔ keŋ bɛɛ baake ke nyi Nasarɛte nɛ man. Kei yela kpene keŋ Wurubuarɛ be tɛɛ wa akpeŋkpeŋgyɔɔra dɔɔ yako see nɛ, kɔŋawɔ ampaŋ. Be yakowɔ nyiaa, “Baa baake e nyi Nasarɛte baale.” ");
INSERT INTO ntr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Debaŋ kenaŋ man nɛ, Gyɔn Wurubuarɛ loŋsɔɔre kɔŋawɔ ɔ ne kolosi Wurubuarɛ nombia Gyudia depampaa dinaa keŋ man. Ɔ yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ɛ kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man na ɛ ke kɔŋ Wurubuarɛ gyaŋ, nawolo nyi Wurubuarɛ gyoori keŋ ta benaa.” ");
INSERT INTO ntr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Gyɔn kei yɛna ŋon Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya be yako ɔ wose man nombia nyiaa, “Ŋolo ne fae yeesa depampaa dinaa keŋ man nyiaa, ɛ desina de Gbeŋgyoo gbɛɛneŋ. Ɛ yela ɔ gbɛɛneŋ pou ka tenee.” ");
INSERT INTO ntr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kurumɔɔ tɔne te ba moowɔ ŋara Gyɔn kegba, te wonembu tɔne te ɔ moowɔ yɛɛ abɔsɔɔ kpaŋ ɔ teŋa man. Akpataana na teebɔɔ yɛna ɔ weenɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Balaŋ lee Gyerusalɛm donɔɔ man na Gyudia tɛɛlese man, na donɔɔse ŋan ŋe kyaa Gyɔɔdan boo keŋ yenaase nɛ kɔŋ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bɛɛ kaa tɔlɛɛ be nombiakumɛɛ ŋan pou bɔɔ yɛɛ nɛ fa e, na ɔ te sɔ wɔ Wurubuarɛ loŋ Gyɔɔdan boo keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Gyɔn kena balaŋ burum baŋ bɔɔ lee Farasiitena na Sadukiitena akpii ŋan man kɔŋ ɔ gyaŋ nyi waa sɔ wɔ Wurubuarɛ loŋ nɛ ɔ bɔɔse wɔ nyiaa, “Kyoa, ɛmɛɛ baŋ ɛ dana nombiakumɛɛ ŋgba doma nɛ. Amɔte faree na ŋon nyi yaa yeu lee Wurubuarɛ deŋele kewɔŋ keŋ gyae ke kɔŋ balaŋ dɔɔ nɛ man?” ");
INSERT INTO ntr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ɛ yɛɛ nombia kpaakpaa ŋan nawolo nyi ɛ te kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man kɔŋ Wurubuarɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ɛ na yɛɛ ya agyueŋ nyi keŋ ɛ yɛɛ Aberaham ɔ naanasewɔ dɔɔ te Wurubuarɛ lɛɛ ŋon ya. Mɛɛ yako ŋon ɛ ke nyii nyiaa, Wurubuarɛ waa tale yela boya adoŋ kɛŋa ka bese naanase fa Aberaham. ");
INSERT INTO ntr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ɛ kɛɛ, Wurubuarɛ taŋ desina ɔ debeŋa see waa tuŋii daase lɔ. Mena dɔɔ daŋ kamasɛ keŋ ke bɛɛ se bia kpaakpaa ya na, waa tuŋ ke lɔ na baa keretii ke do boalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Keŋte Gyɔn besewɔ yako wɔ nyiaa, maŋ dɔɔ loŋ te me dana mɛɛ sɔ ŋon Wurubuarɛ loŋ na kawola nyi ɛ te kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man kɔŋ Wurubuarɛ gyaŋ. Mɔna maŋ wɔle na ŋon ɔ kela maŋ nɛ waa kɔŋ, keŋ maŋ tekaboe gba nyi maa tela ɔtenate nkyokotase gba ya. Ŋon dɔɔ, Wurubuarɛ feliŋ na boalaŋ te waa mo sɔ ŋon Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔ dana ɔ pampaa ɔ nyiŋmaa man waa mo feefu wa amɔla na waa lese amɔla bia ŋan do ɔ kpee man, na waa kuu wura ŋan ka do boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gyɔn kɛɛ sɔ balaŋ Wurubuarɛ loŋ keŋ nɛ, te Yesu leewɔ Galelia tɛɛle man kɔŋ Gyɔɔdan boo nɔɔman nyi Gyɔn waa sɔ e Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mɔna Gyɔn gyaewɔ waa yɛɛ na Yesu ke kyɛɛkee wa agyueŋ. Keŋte ɔ bɔɔse Yesu nyiaa, “Nyaŋ te kaboena nyi nya sɔ maŋ Wurubuarɛ loŋ. Weera te nyaŋ besewɔ kɔŋ me gyaŋ nyi maŋ maa sɔ neŋ Wurubuarɛ loŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Keŋte Yesu tiranɔɔ fa Gyɔn nyiaa, “Debaŋ kei man nɛ, nyaŋ yɛɛ ke mena. De yɛɛ nnɛ na, Wurubuarɛ kegyaebii yaa dɛɛ yɛɛ baa.” Keŋte Gyɔn mɔ sɛɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gyɔn ke sɔ Yesu Wurubuarɛ loŋ taŋ, te Yesu ka mo waa lee loŋ keŋ man pɛ, te adido torowɔ. Keŋte ɔ naa Wurubuarɛ feliŋ ŋon moo duwuluŋ dinɔɔ tisi kaa gyakaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Botɔɔ te be nyii Wurubuarɛ kolosiwɔ lee adido yako nyiaa, “Kei yɛna me bu ŋon mɛɛ gyae lee me konɔɔ man, te ɔ na gyoo me sia nideli.” ");
INSERT INTO ntr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Keŋte Wurubuarɛ feliŋ ŋon yela Yesu gyuu depampaa dinaa daale man. Botɔɔ te ɔbɔnsam kɛɛse e kɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu ke bake ɔ nɔɔ weeya sɔŋola (40) nelim na ka weese wɔle nɛ, tanam kyaŋa e nideli. ");
INSERT INTO ntr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Botɔɔ te ɔbɔnsam kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, “Akpaa nyaŋ yɛna Wurubuarɛ bu ŋon na, yela boya kɛŋa ka bese weenɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Keŋte Yesu tiranɔɔ fa e nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see ne yako daa nyiaa, ‘Na weenɛɛ ŋaageŋ ne faa na walaŋ nyeedoŋ ya, mɔna Wurubuarɛ nɔɔwoya kamasɛ mɔ ne fa walaŋ nyeedoŋ.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Botɔɔ te ɔbɔnsam moo Yesu gyu Gyerusalɛm donɔɔ man, te ɔ moo e gyu Wurubuarɛ ɔsom deni dinaa keŋ nyeeman adido adido, ");
INSERT INTO ntr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","te ɔ yako e nyiaa, “Akpaa nyaŋ yɛna Wurubuarɛ bu ŋon na, fuŋ n wose lee kɛbo ke lɔ tɛɛle man, nawolo nyi Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako daa nyiaa, ‘Nyaŋ dɔɔ Wurubuarɛ waa kpila ɔ kpilala, na be kaa gyee neŋ nideli, na baa kɔlee neŋ keŋ nyi n be gyae n ka mo n nae gyɔ na boe koraŋ gba ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Keŋte Yesu tiranɔɔ fa e nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see na bese yako daa nyiaa, ‘Na kɛɛse n Gbeŋgyoo Wurubuarɛ ŋon kɛɛ ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Botɔɔ te ɔbɔnsam besewɔ mo Yesu gyu bula dinaa daale nyee dɔɔ, te ɔ wola e tɛɛle kei dɔɔ gyoorobiiri na ka kyeo pou. ");
INSERT INTO ntr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Keŋte ɔ yako Yesu nyiaa, “Akpaa n buŋ me nawɔɔ tɛɛ som maŋ na, maa mo abɔɔ kɛŋa pou fa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Keŋte Yesu yako e nyiaa, “Ɔbɔnsam ta lee me siaman, nawolo nyi Wurubuarɛ nombia aŋmaraseŋ see ne yako daa nyiaa, de Gbeŋgyoo Wurubuarɛ waageŋ te kaboena nyi dee buŋ e na dɛɛ som e.” ");
INSERT INTO ntr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Botɔɔ te ɔbɔnsam leewɔ Yesu gyaŋ laŋ, te Wurubuarɛ kpilala kɔŋawɔ kaa kɛɛ ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu ke nyii nyi ba te kyaŋ Gyɔn Wurubuarɛ loŋsɔɔre ŋon tɔ deni nɛ, te ɔ besewɔ gyu Galelia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yesu ka lee Nasarɛte donɔɔ man nɛ, ɔ gyuuwɔ ke kyaa Kapanum donɔɔ man. Donɔɔ kei kyaa Galelia depaa nɔɔman, te ka benaa na Sebulɔn na Nafitali tɛɛlese. ");
INSERT INTO ntr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kei yela kpene keŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya be yako see lee tɛɛle kenaŋ wose man nɛ kɔŋawɔ ampaŋ. Yesaya yakowɔ see nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ɛmɛɛ balaŋ baŋ ɛ kyaa Sebulɔn na Nafitali tɛɛlese ŋan ŋe kyaa benaa na Galelia depaa, botɔɔ keŋ balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ boe nɛ, na Gyɔɔdan boo diŋgyiŋ nɛ, ɛ tei kɛbo. ");
INSERT INTO ntr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Balaŋ baŋ be doo ditiŋtɛɛ man nɛ te naa keŋmaŋee dinaa daale. Balaŋ baŋ mɔ be kyaa botɔɔ keŋ yeŋ ne di gyoori nɛ, keŋmaŋee te kɔŋ fa wɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lee debaŋ kenaŋ te Yesu fiasɛɛ ɔ ne kolosi Wurubuarɛ nombia nyiaa, “Ɛ kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man na ɛ ke kɔŋ Wurubuarɛ gyaŋ, nawolo nyi Wurubuarɛ gyoori keŋ ta benaa.” ");
INSERT INTO ntr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wee daale Yesu keta Galelia boo nɔɔ nɔɔ nɛ, ɔ naa Simɔn ŋon ɔ yele daale bela yɛna Pita nɛ, na ɔ naabu Anderiase na bɛɛ lɔ asawu boo keŋ man, nawolo nyi be yɛɛ kpɛɛ kyaŋarawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Keŋte Yesu yako wɔ nyiaa, “Ɛ kaa sila maŋ, na maa yela ɛ ke yilaa balaŋ fa maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Debokenaŋ man te be tinaa ba asawuse ŋan yela te be kaa sila Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ɔ ke gyu ɔ siaman kyomii nɛ, ɔ naa Sebedeo bia Gyemisi na ɔ naabu Gyɔn na baŋ na be kya Sebedeo doo degbele man bee desina ba asawuse te Yesu baake wɔ, ");
INSERT INTO ntr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","debokenaŋ man te be tinaa degbele keŋ na be kya yela, te be sila Yesu laŋ. ");
INSERT INTO ntr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Keŋte Yesu kila Galelia tɛɛle keŋ pou, na ɔ na wola wɔ Gyudatena ɔsom denɛɛ man. Ɔ kolosi Wurubuarɛ nombia kpaakpaa lee Wurubuarɛ gyoori keŋ wose man, te ɔ kyɔɔ kaweese kpookpoo balaŋ wose man. ");
INSERT INTO ntr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mena dɔɔ Yesu yele leewɔ Siria tɛɛle keŋ dɔɔ pou. Keŋte balaŋ moo kaweesetena kpookpoo, ŋgba baŋ bɛɛ wee keleuleuse na ɔtakasese na baŋ ba yenaase ba yekee nɛ kɔna e, te ɔ kyɔɔ wɔ te ɔ gberaa feliŋkumɛɛ lee baale mɔ man. ");
INSERT INTO ntr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mena dɔɔ balaŋ burum lee Galelia, na Dekapolise tɛɛle man na Gyerusalɛm donɔɔ man na Gyudia tɛɛle man, na Gyɔɔdan diŋgyiŋ kaa sila e. ");
INSERT INTO ntr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu kena balaŋ burum baŋ nɛ, ɔ gyeŋa bula daale gyu ke kyaa ke dɔɔ. Keŋte ɔ kaseela baŋ kɔŋawɔ kaa kyaa kilisi e. ");
INSERT INTO ntr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Botɔɔ te ɔ gyuusu ɔ nɔɔ ɔ na wola wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ɛmɛɛ baŋ ɛ ba mo ɛ wose pou lɔ Wurubuarɛ dɔɔ nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ te Wurubuarɛ gyoori keŋ yɛɛ ɛ wui. ");
INSERT INTO ntr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɛmɛɛ baŋ ɛ ne di walaŋsa nɛ ɛmɛɛ na nyeebam, nawolo nyi Wurubuarɛ waa kyɔlɛɛ ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɛmɛɛ baŋ ɛ ne yɔkɔse ɛ wose nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ te tɛɛle kei gyae kaa bese ɛ wui. ");
INSERT INTO ntr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɛmɛɛ baŋ ɛ loo gyakaa nideli nyi ɛ ke yɛɛ kpene keŋ tenɛɛ Wurubuarɛ siaman nɛ ɛmɛɛ na nyeebam, nawolo nyi Wurubuarɛ waa fa ŋon abɔɔ ŋan ɛ ne gyae lee ɛ konɔɔ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɛmɛɛ baŋ ɛ ne wii balaŋ waraŋase nɛ ɛmɛɛ na nyeebam, nawolo nyi Wurubuarɛ waa wii ɛmɛɛ mɔ waraŋase. ");
INSERT INTO ntr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɛmɛɛ baŋ dukum kamasɛ be doo ɛ konɔɔse man ya nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ ne gyae la ɛ kena Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɛmɛɛ baŋ ɛ ne yele wosefɛɛreŋ ne kɔŋ balaŋ nsana nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ te baa baake nyi Wurubuarɛ bia. ");
INSERT INTO ntr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɛmɛɛ baŋ bɛɛ naase ŋon diyem nyi ɛ ne yɛɛ kpene keŋ tenɛɛ Wurubuarɛ siaman dɔɔ nɛ, ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ te Wurubuarɛ gyoori keŋ yɛɛ ɛ wui.” ");
INSERT INTO ntr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ɛmɛɛ baŋ balaŋ na tee ŋon te bɛɛ naase ŋon diyem te bɛɛ kɛrɛɛ ɛ nɔɔse yako nombiakumɛɛ gyakaa ɛ dɔɔ, nawolo nyi keŋ e silana maŋ dɔɔ nɛ, ɛmɛɛ na nyeebam. ");
INSERT INTO ntr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ɛ yela ke yɛɛ ŋon gyoŋ nideli, nawolo nyi kom keŋ Wurubuarɛ waa tɔ ŋon adido nɛ ka boe. Mena keŋ bɛɛ naase ŋon diyem nɛ, mena ke te be naase Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ bɔɔ kyaa pɛte ɛ be kɔŋ nɛ diyem.” ");
INSERT INTO ntr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ɛ yɛɛ ŋgba yabia nɛ fa balaŋ tɛɛle kei dɔɔ. Mɔna akpaa yabia gyoŋ keŋ da lee ke man na, n be gyae n ke tale yela ka ke yɛɛ gyoŋ bela ya. Dekɔŋ mena na yabia kenaŋ be dei fa kolo na kolo ke yɛɛ bela ya. Bee fuŋ ke bo leki, na balaŋ ke sakatee ke laŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ɛ yɛɛ ŋgba keŋmaŋee nɛ fa balaŋ tɛɛle kei dɔɔ. Donɔɔ keŋ ke gyakaa bula dɔɔ nɛ bɛɛ weese ya. ");
INSERT INTO ntr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ŋolo bɛɛ kyaŋee kanea na waa mo kolo wuu ke dɔɔ ya, mɔna ɔ na mo ke bo gyakaa kolo dɔɔ adido, na ke nyiŋ naa fa balaŋ baŋ pou be kyaa dekpaŋalaŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mena mɔ te ɛ yela balaŋ kena ɛ keŋmaŋee keŋ. Kei ne gyae la ke yela balaŋ kena ɛ nombia kpaakpaa ŋan ɛ ne yɛɛ nɛ, na baa nyiŋ lese ɛ kya ŋon ɔ kyaa adido nɛ yele.” ");
INSERT INTO ntr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ na gyueŋ nyi me kɔŋae me kaa bɛɛ Wurubuarɛ mmaraase, yaa nombia ŋan Wurubuarɛ akpeŋkpeŋgyɔɔra be yako see nɛ ya. Ma te kɔŋ nyi me kaa bɛɛ ŋa ya, mɔna me kɔŋae na maa yela nombia ŋenaŋ pou ke kɔŋ ŋgba ba ke yako see nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, adido na tɛɛle kei pou nyiŋa te wɔlɛɛ ta ya nɛ, mmaraase ŋan man dokoloŋ, yaa keŋmarasebii dokoloŋ kooŋ gba be gyae ka feefo lee ŋe man ya, kelii debaŋ keŋ nombia ŋenaŋ pou gyae ke kɔŋ, ŋgba mena keŋ bɔɔ yako see nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mena dɔɔ walaŋ kamasɛ ŋon ɔ bɛɛ nyi ɔ be di Wurubuarɛ mmaraase kɛŋa man kamasɛ dɔɔ ya, te ɔ wola balaŋ mɔ nyi be na di ŋe dɔɔ ya nɛ, na mena walaŋ ŋonaŋ waa yɛɛ walaŋ kemaasabii Wurubuarɛ gyoori keŋ man. Mɔna walaŋ kamasɛ ŋon ɔ di Wurubuarɛ mmaraase ŋan kamasɛ dɔɔ, te ɔ wola balaŋ mɔ nyi baa di ŋe dɔɔ nɛ, baa baake e nyi walaŋ kegyia Wurubuarɛ gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyiaa, akpaa ɛ gbɛɛneŋ ta tenee Wurubuarɛ siaman kela Gyudatena mmaraa wolala baŋ, na Farasiitena dikpii keŋ balaŋ ya nɛ, ɛ be gyae ɛ ka gyoo Wurubuarɛ gyoori keŋ man ya.” ");
INSERT INTO ntr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Keŋte Yesu besewɔ yako wɔ nyi, “Ɛ nyii Wurubuarɛ nombia yakowɔ nyiaa, beneŋ beneŋ keŋ na, Wurubuarɛ yako de naanaɔ nyi, ‘Ɛ na ko walaŋ ya, te walaŋ kamasɛ ŋon ɔ ko walaŋ na, maa bu e fɔɔ.’ ");
INSERT INTO ntr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mɔna maŋ ne yako ŋon baa nyiaa, ‘Walaŋ kamasɛ ŋon ɔ gyeŋ baŋ do ɔ dɔɔ na baa bu e fɔɔ, te walaŋ kamasɛ ŋon ɔ tee ɔ dɔɔ nyi ɔ yɛɛ ohuhoo e na, baa mo e gyu kegyiise siaman na be kaa di ɔ nombia. Te walaŋ kamasɛ ŋon ɔ baake ɔ dɔɔ nyi Diyiŋte na, ɔtenate benaa na boalaŋ man kagyoo.’ ");
INSERT INTO ntr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mena dɔɔ nyi akpaa nyaŋ ŋon n mo kolo kɔŋ Wurubuarɛ kedeesa boe keŋ tɛɛ n kaa deesi, te n tɔɔse nyi ɛmɛɛ na ŋolo dana nombia na, ");
INSERT INTO ntr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tina nya abɔɔ ŋan yela kedeesa boe keŋ tɛɛ botɔɔ, na n ke gyu n dɔɔ ŋon gyaŋ na ɛ kaa desina ya nsana, pɛna n kaa mo nya abɔɔ ŋan deesi fa Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nyi akpaa ŋolo de samenaa neŋ na, yɛɛ kakyeŋ na ɛ ke desina ya nsana pɛna nombia kedi wee keŋ kelii. Na mena ya wee kenaŋ de lii na, waa mo neŋ ka do nombiadiiri ŋon nyiŋmaa man, na ŋon mɔ ka mo neŋ ka do kotɔtɔɔtena nyiŋmaa man, na baa mo neŋ ketɔ deni. ");
INSERT INTO ntr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ampaŋ yaa mɛɛ yako neŋ n ke nyii nyiaa, n be gyae n ka lee deni kenaŋ man ya, kaboena n ke tɔ kom keŋ pou baa do neŋ nɛ taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ nyii Wurubuarɛ nombia yakowɔ nyi alo na baale de yala dɔŋa na, ŋolo na lee ɔ dɔɔ wɔle ya. ");
INSERT INTO ntr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mɔna maŋ ne yako ŋon baa nyi walaŋ kamasɛ ŋon ɔ kɛɛ alo te ɔ gyakaa e loo na, ɔtenate te yɛɛ dukum Wurubuarɛ siaman. Nawolo nyi Wurubuarɛ siaman na ɔ gyae e baa. ");
INSERT INTO ntr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Akpaa n dunoluŋ sibii ne yele la te n ne yɛɛ dukum na kulu ke leki. Dei nyi nya lee kadeŋ na n ke kyaa Wurubuarɛ gyaŋ kela nyi baa mo n dibiliŋ pou ka do boalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te akpaa nyi n dunoluŋ baam ne yele la te n ne yɛɛ dukum na kara ke leki. Dei nyi nya lee kadeŋ na n ke kyaa Wurubuarɛ gyaŋ kela nyi baa mo n dibiliŋ pou ka do boalaŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Keŋte Yesu besewɔ yako wɔ nyiaa “Ɛ nyii Wurubuarɛ nombia yakowɔ nyiaa, ‘Walaŋ kamasɛ ŋon waa bɛɛ ɔ wɛɛle na, kaboena nyi waa fa e tɔne na kawola nyi ɔ te bɛɛ e.’ ");
INSERT INTO ntr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mɔna maŋ ne yako ŋon baa nyi akpaa alo te gyae baala ya te ɔ baale de bɛɛ e na, ɔ te yeli alo ŋon te wɔlɛɛ yale mmaraase Wurubuarɛ siaman. Te nyaŋ ŋon mɔ n yala alo ŋon ɔ baale be bɛɛ e na, Wurubuarɛ siaman na n gyae ŋolo wɛɛle baa.” ");
INSERT INTO ntr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ nyiiwɔ Wurubuarɛ nombia besewɔ yako gyaŋgba keŋ nyiaa, walaŋ kamasɛ ŋon ɔ kaŋ ntam fa de Gbeŋgyoo Wurubuarɛ na, waa yɛɛ kakyeŋ na waa di ke dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mɔna maŋ ne yako ŋon baa nyiaa, ɛ na kaŋ ntam korakora gba ya. Ɛ na kaŋ adido ntam ya, nawolo nyi botɔɔ te Wurubuarɛ kyaa ɔ ne di gyoori balaŋ pou dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ɛ na kaŋ tɛɛle mɔ ntam ya, nawolo nyi botɔɔ yɛna Wurubuarɛ nae dɛɛ see. Ɛ na kaŋ Gyerusalɛm donɔɔ mɔ ntam ya, nawolo nyi keŋ yɛna gyoo dinaa ŋon donɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ɛ na kaŋ ɛ nyee ntam ya, nawolo nyi ŋolo be gyae waa tale yela ɔ nyeenyɔɔse dokoloŋ ke biri yaa ka wolose ya. ");
INSERT INTO ntr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nombii keŋ kaboena nyi nya sɛɛ ‘Ayi’ na sɛɛ nyi ‘Ayi’ te keŋ kaboena nyi nya bɛɛ nyi ‘Koa’ na, bɛɛ nyi ‘Koa.’ Nombii da lee kɛŋa wɔle na, lee walaŋkum ŋon gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Keŋte Yesu besewɔ yako nyiaa, “Ɛ nyii Wurubuarɛ nombia yakowɔ nyiaa, akpaa n dɔɔ de yɛlɛɛ n sibii na nyaŋ mɔ yɛlɛɛ ɔ wui tɔ kom. Te akpaa n dɔɔ de kulu n keli na, nyaŋ mɔ kulu ɔ wui tɔ kom. ");
INSERT INTO ntr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mɔna maŋ ne yako ŋon baa nyiaa, akpaa ŋolo de yɛɛ neŋ nombiikum na, nyaŋ na mo nombiikum tɔ e kom ya. Te akpaa ŋolo da ŋmera neŋ n dunoluŋ lakaa man na, besena n demena mɔ wui kpu e. ");
INSERT INTO ntr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nyi ŋolo de samenaa neŋ nyi waa lɛo n kegba wurikyim na, kpee n kegba atetate keŋ mɔ kpu e. ");
INSERT INTO ntr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Akpaa ŋolo da ŋere neŋ nyi ɛmɛɛ na e ke ta nawɔɔtɔɔse kufu na, sɛɛ na ɛmɛɛ na e ke ta nawɔɔtɔɔse sao. ");
INSERT INTO ntr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akpaa ŋolo da sola neŋ kolo na fa e, te akpaa ŋolo de kɔŋ ɔ kaa paa n kolo na, na bɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Keŋte Yesu besewɔ yako nyiaa, “Ɛ nyii Wurubuarɛ nombia yakowɔ nyiaa, gyae n dɔɔ na n ke kɔla ŋon ɔ ne kɔla neŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mɔna maŋ ne yako ŋon baa nyiaa, ɛ gyae balaŋ baŋ bɛɛ kɔla ŋon nɛ, na ɛ ke fane fa baŋ bɛɛ naase ŋon diyem nɛ, ");
INSERT INTO ntr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","na kawola nyi ɛ yɛɛ ɛ kya ŋon ɔ kyaa adido nɛ bia gbagbawɔ. Nawolo nyi ɔ ne yele weese ne gyɔɔ fa balaŋ kumɛɛ na balaŋ kpaakpaa pou, te ɔ ne yele ɔga ne ŋɛɛ fa balaŋ baŋ be gbɛɛneŋ tenɛɛ ɔ siaman, na baŋ be gbɛɛneŋ ba tenɛɛ ɔ siaman ya nɛ pou. ");
INSERT INTO ntr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyi akpaa ɛ ne gyae balaŋ baŋ bɛɛ gyae ŋon nɛ baageŋ bo na, ɛ na gyueŋ nyi ɛ ke nyiŋ kolo kpaakpaa lee Wurubuarɛ gyaŋ ya, nawolo nyi nombiakumɛɛyɛɛra mɔ koraŋ ne gyae baŋ bɛɛ gyae wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te akpaa ɛ do ɛ gyoona baageŋ nɔɔ na, woŋ te ɛ ne yɛɛ kela balaŋ akaŋ baŋ? Na mena te balaŋ baŋ bɔɔ gyeŋ Wurubuarɛ ya nɛ mɔ ne yɛɛ yee? ");
INSERT INTO ntr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mena dɔɔ ɛ yɛɛ balaŋ kpaakpaa keŋ nombiikum kamasɛ na doo ɛ man ya kelii ɔto, ŋgba ɛ kya ŋon ɔ kyaa adido nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Keŋte Yesu besewɔ yako wɔ nyiaa “Ɛ kɛɛ nideli nyi ɛ be yɛɛ deeli balaŋ man, na baa nyiŋ naa ŋon ya. Akpaa ɛ yɛɛ mena na, ɛ be gyae ɛ ke nyiŋ kom ketɔ kamasɛ lee ɛ kya ŋon ɔ kyaa adido nɛ gyaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mena dɔɔ akpaa ɛ yɛɛ deeli fa diyemte ŋolo na, ɛ na mo ke gyɔ dekpeŋkpeŋ ŋgba mena keŋ balaŋ baŋ bɛɛ beo ba wose nɛ ne yɛɛ Gyudatena ɔsom denɛɛ na abɔnterese man, na balaŋ kenyiŋ kɛlɛɛ wɔ nɛ ya. Ampaŋ yaa mɛɛ yako ŋon nyiaa, be taŋ nyiŋ ba kom ketɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mɔna akpaa n yɛɛ deeli fa diyemte ŋolo na, na yele n dɔɔ kpaakpaa gba koraŋ ke nyii ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yela kedoo walaŋ ŋon n be yɛɛ deeli keŋ fa e nɛ, ɛmɛɛ na e ɛ bala nsana. Dekɔŋ mena na, n kya Wurubuarɛ ŋon ɔ ne naa kpene keŋ n be yɛɛ weese nɛ, waa tɔ neŋ kom.” ");
INSERT INTO ntr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Keŋte Yesu yako wɔ nyi, “Akpaa ɛ ne fane nɛ, ɛ na yɛɛ ŋgba mena keŋ balaŋ baŋ bɛɛ beo ba wose ne yɛɛ nɛ ya. Nawolo nyi bɛɛ gyae Gyudatena ɔsom denɛɛ man, na abɔnterese man keta seŋee fane na balaŋ kenyiŋ naa wɔ. Ampaŋ yaa mɛɛ yako ŋon nyi be taŋ tɔ wɔ ba kom pou. ");
INSERT INTO ntr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mɔna akpaa ɛ ne gyae ɛ ke fane na, ɛ gyu ɛ denɛɛ man na ɛ ketɔ disim na ɛ ke fane fa ɛ kya ŋon ɛ bɛɛ naa e na ɛ sia fonɛɛ ya nɛ. Akpaa ɛ yɛɛ mena na, ɛ kya ŋon ɔ ne naa kpene keŋ ɛ be yɛɛ weese nɛ, waa tɔ ŋon kom. ");
INSERT INTO ntr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Akpaa ɛ ne fane na, ɛ na kolosi nɔɔwoya burum ŋan ŋɔɔ taŋ tɔnɔɔ, ŋgba mena keŋ balaŋ baŋ bɔɔ gyeŋ Wurubuarɛ ya ne yɛɛ nɛ ya. Baŋ gyeŋ nyi akpaa be kolosi nɔɔwoya burum na, te Wurubuarɛ waa nyii wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mena dɔɔ ɛ na yɛɛ ŋgba be kɛɛ yɛɛ nɛ ya, nawolo nyi ɛ kya Wurubuarɛ wulaa ɔ gyeŋ kpene keŋ ne hia ŋon koraŋ gba pɛte ɛ ne bɔɔse e.” ");
INSERT INTO ntr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ɛ ne gyae ɛ ke fane na, ɛ yako nyiaa, ‘De kya ŋon n kyaa adido, dɛɛ fane nyi balaŋ pou baa lese n yele. ");
INSERT INTO ntr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lese n gyoori debɔɔ, yela baa yɛɛ n kegyaebii tɛɛle dɔɔ, ŋgba mena keŋ bɛɛ yɛɛ adido nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fa daa gyɛŋ wee kei weenɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mo de nombiakumɛɛ kyɛɛ daa, ŋgba mena keŋ daa mɔ na mo kyɛɛ balaŋ baŋ bɛɛ yɛɛ nombiakumɛɛ tia daa nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na yele dɛɛ yala kekɛɛsekɛɛ man ya. Mɔna lese daa lee walaŋkum ŋon nyiŋmaa man.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nawolo nyi akpaa ɛ mo balaŋ nombiakumɛɛ kyɛɛ wɔ na, ɛ kya ŋon ɔ kyaa adido nɛ mɔ waa mo ɛmɛɛ mɔ ɛ nombiakumɛɛ kyɛɛ ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mɔna akpaa ɛ ta mo balaŋ nombiakumɛɛ kyɛɛ wɔ ya na, ɛ kya ŋon ɔ kyaa adido nɛ mɔ be gyae waa mo ɛmɛɛ mɔ wui nombiakumɛɛ kyɛɛ ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Keŋte Yesu besewɔ yako wɔ nyi, “Akpaa ɛ ne bake ɛ nɔɔ nɛ, ɛ na nyaŋe ɛ sia ŋgba mena keŋ balaŋ baŋ bɛɛ beo ba wose nɛ ne yɛɛ nɛ ya. Bɛɛ nyaŋe be sia na balaŋ ke nyiŋ naa nyi bɛɛ bake be nɔɔ. Ampaŋ yaa mɛɛ yako ŋon nyi be taŋ nyiŋ ba kom ketɔ. ");
INSERT INTO ntr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mɔna akpaa n bake n nɔɔ nɛ, faafo n sia na n ke tiu nuŋ na n ke fulaa n nyee. ");
INSERT INTO ntr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","N yɛɛ mena na balaŋ ba gyem nyi n ne bake n nɔɔ ya. Mɔna n kya ŋon n bɛɛ naa e na n sia fonɛɛ ya, te ɔ ne naa kpene kamasɛ keŋ n ne yɛɛ weese nɛ waa tɔ neŋ kom.” ");
INSERT INTO ntr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ na gyae abɔɔ see tɛɛle kei dɔɔ fa ɛ wose ya. Nawolo nyi tɛɛle kei dɔɔ na, paapaase na kandorɔse gyae ke tale wɔlɛɛ ŋa, yaa ŋmɛɛlatena mɔ baa tale kaa ŋmɛɛle ŋa. ");
INSERT INTO ntr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mɔna ɛ gyae abɔɔ see ɛ wose Wurubuarɛ man, botɔɔ keŋ paapaase na kandorɔse be wɔlɛɛ ŋa ya, te ŋmɛɛlatena mɔ be gyae baa tale gyu ke ŋmɛɛle ŋa ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nawolo nyi botɔɔ keŋ nya abɔɔ kpaakpaa doo nɛ, botɔɔ mɔ te n loo gyakaa.” ");
INSERT INTO ntr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Keŋte Yesu besewɔ yako wɔ nyiaa, “Sia yɛɛ ŋgba kanea nɛ fa deniwalaŋ wose. N sia dei na n wose pou doo keŋmaŋee man. ");
INSERT INTO ntr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mɔna n sia de wɔlɛɛ na, n wose pou doo ditiŋtɛɛ tuum man. Nyi akpaa kanea keŋ doo n man nɛ da gyoo ditiŋtɛɛ na, kenaŋ na ditiŋtɛɛ dinaa ta gyoo neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Walaŋ be kyaa keŋ waa tale som gbeŋgyoona bala ya. Dekɔŋ mena na, waa kɔla ŋolo na waa gyae ŋolo nombia, yaa waa som ŋolo nideli kela ŋolo. Ɛ be gyae ɛ ke tale som Wurubuarɛ na kɔba bom ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mena dɔɔ te mɛɛ yako ŋon nyiaa, ɛ na yeyɛɛ na ɛ kekyaa man kedi na kenyɔɔ, na abɔɔ ŋan ɛ ka do ya. Nyeedoŋ ne hia kela weenɛɛ, te deniwalaŋ wose mɔ ne hia kela abɔɔ ŋan waa do. ");
INSERT INTO ntr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ɛ kɛɛ gyebuse, bɔɔ ne duu abɔɔ ya te bɔɔ ne kɔɔ ya te bɔɔ dana kpeese yaa denɛɛ ŋan man baa see weenɛɛ ya. Mɔna ɛ kya ŋon ɔ kyaa adido nɛ ne fa wɔ weenɛɛ. Kaboena ya gyeŋ nyi, ɛ wose ne hia kela gyebuse. ");
INSERT INTO ntr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɛ man woŋti te lee ɔ kayeyɛɛ man nɛ, waa tale mo debaŋ dokoloŋ kooŋ pɛ kpu na ɔ weeya ŋan Wurubuarɛ be fa e nɛ? ");
INSERT INTO ntr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Woŋ dɔɔ te ɛ na yeyɛɛ na abɔɔ ŋan ɛ ka do. Ɛ kɛɛ mena keŋ kyeŋkyeŋkɔɔse na bee, ŋe bɛɛ yɛɛ tom ya te ŋe bɛɛ loo kanyaŋse mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mɔna mɛɛ yako ŋon ɛ ke nyii nyiaa, Gyoo Solomɔn gba na ɔ wosekenyiŋ koraŋ nɛ, ɔ te nyiŋ kyeŋkyeŋkɔɔse kɛŋa man dokoloŋ kyeo ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Weera dɔɔ te ɛ bɛɛ lɛɛ Wurubuarɛ di nideli ya. Nyi akpaa mena te Wurubuarɛ ne mia ŋalese ŋan ɛ kena ŋa gyɛŋ kyoo na be ta too ŋa na, kenaŋ na ɛ tɔɔse nyi Wurubuarɛ waa mia ŋon kela ŋalese ŋenaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mena dɔɔ ɛ na yeyɛɛ na kpene keŋ ɛ ke di, yaa kpene keŋ ɛ ke nyɔɔ yaa kpene keŋ ɛ ka do nɛ dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nawolo nyi mena abɔɔ kɛŋa te tɛɛle kei dɔɔ balaŋ baŋ bɔɔ gyeŋ Wurubuarɛ ya nɛ sia ne yɛɛ ŋe dɔɔ, mɔna ɛ kya Wurubuarɛ gyeŋ nyi mena abɔɔ kɛŋa ne hia ɛmɛɛ mɔ. ");
INSERT INTO ntr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mena dɔɔ ɛ taŋgbɛɛ mo ɛ loo pou gyakaa Wurubuarɛ gyoori keŋ na ɔ gbɛɛneŋ ŋan tenɛɛ nɛ dɔɔ. Nyi akpaa ɛ yɛɛ mena na, Wurubuarɛ waa mo abɔɔ akaŋ ŋan pou kpu ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mena dɔɔ ɛ na yeyɛɛ na kyoo wui nombia ya, te ɛ na mo gyɛŋ wui nombia kpu kyoo wui man ya. Nawolo nyi wee kamasɛ na ke wui nombia.” ");
INSERT INTO ntr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ na yɛɛ ɛ wose balaŋ nombiadiira na ɛ ke bu wɔ fɔɔ ya, na Wurubuarɛ mɔ be di ɛ nombia na waa bu ŋon fɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nawolo nyi gbɛɛ keŋ man ɛ ka mo di ɛ tebia nombia na, mena mɔ te Wurubuarɛ waa mo di ɛ nombia. Nombii keŋ ɛ ka mo yɛɛ ɛ tebia nɛ, keŋ ke te Wurubuarɛ mɔ waa mo yɛɛ ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Weera dɔɔ te n ne naa woŋsilibii keŋ doo n dɔɔ sibii man, te n be famenɛ na daakpee keŋ doo nyaŋ gbagba n sibii man ya? ");
INSERT INTO ntr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sena te n ke tale yako n dɔɔ nyi, ‘Me dɔɔ yela maa lese woŋsilibii lee n sibii man, keŋ nyaŋ gbagba be famenɛ na daakpee keŋ doo n sibii man ya?’ ");
INSERT INTO ntr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nyaŋ walaŋ ŋon n na beo n wose, kaboena nyi nya taŋgbɛɛ lese daakpee keŋ doo n sibii man nɛ, pɛna n kena nideli na n ka lese woŋsilibii keŋ doo n dɔɔ sibii man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ɛ na mo kpene keŋ ke yɛɛ kolo kpaakpaa ke Wurubuarɛ siaman nɛ fa babaase ya, na mena ya na baa besena bo kɔŋ ɛ dɔɔ na baa doŋee ŋon. Ɛ na mo ɛ kegyaŋase kpaakpaa nyiŋan mɔ fuŋ lɔ kekuiriise ya, na mena ya na baa sakatee ŋa bo.” ");
INSERT INTO ntr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ sola Wurubuarɛ kolo na ɛ nyiŋmaa gyae ke kaŋ ke. Ɛ kɛo kolo lee ɔ gyaŋ na ɛ ke nyiŋ ke, te ɛ gyɔ e disim na waa toro fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nawolo nyi walaŋ kamasɛ ŋon ɔ bɔɔse e kolo na ɔ nyiŋmaa ne kaŋ ke. Ŋon ɔ gyae kolo lee ɔ gyaŋ na ɔ ne nyiŋ ke, te ŋon mɔ ɔ gyɔ e disim na waa toro fa e. ");
INSERT INTO ntr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ɛ man woŋti kyaa la keŋ nyi ɔ bu da sola e weenɛɛ na waa mo boe fa e? ");
INSERT INTO ntr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yaa ɛ man woŋti kyaa la keŋ nyi ɔ bu da sola e kpebii na waa mo dom fa e? ");
INSERT INTO ntr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Akpaa ɛmɛɛ baŋ ɛ yɛɛ nombiakumɛɛyɛɛrawɔ koraŋ gyeŋ abɔɔ kpaakpaa ka mo fa ɛ bia na, de yaa sena te ɛ kya ŋon ɔ kyaa adido nɛ be gyae waa mo abɔɔ kpaakpaa ŋan kela kɛŋa nɛ fa baŋ bɛɛ sola e nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wurubuarɛ mmaraase na Wurubuarɛ akpeŋkpeŋgyɔɔra nombia ŋan pou bɔɔ wolo nɛ ŋa nyee yɛna nyi, kpene keŋ n ne gyae nyi balaŋ baa yɛɛ fa neŋ na, keŋ te kaboena nyi nyaŋ mɔ nya yɛɛ fa wɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ yɛɛ kakyeŋ na ɛ ka mo denanɔɔ bɔbɔɔkyee keŋ man gyoo Wurubuarɛ man. Nawolo nyi denanɔɔ keŋ ka keerɛɛ te ke gbɛɛnaa fɛlɛɛ te ke dɔɔ keta be taŋ baŋ ya nɛ, na mo balaŋ bo gyu kayeyɛɛ keŋ be taŋ ɔto ya nɛ man. Mɔna ke man te balaŋ burum dɔŋɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Te denanɔɔ bɔbɔɔkyee keŋ ke gbɛɛnaa yɛɛ peperee te ke dɔɔ keta dana baŋ nɛ, na moona balaŋ gyu nyeedoŋ keŋ be taŋ ɔto ya nɛ man. Mɔna balaŋ baŋ bɛɛ naa ke te bɛɛ moo ke man gyoo nɛ, be ta boo ya.” ");
INSERT INTO ntr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ kɛɛ ɛ wose man nideli lee akɛrɛɛ akpeŋkpeŋgyɔɔra baŋ wose man. Akpaa be kɔŋ ɛ gyaŋ na, bɛɛ yɔkɔse ba wose ŋgba namense nɛ mɔna be konɔɔse man na be yɛɛ ŋgba gbougbouse nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Be nombia ŋan bɛɛ yɛɛ nɛ te ɛ ka mo gyeŋ wɔ. Ŋolo bɛɛ kɔ mango bia lee akutu daŋ man ya, mena mɔ te bɔɔ ne kɔ apaŋ lee abotoo woŋse man ya. ");
INSERT INTO ntr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mena mɔ te daŋ kpaakpaate kamasɛ na se bia kpaakpaa, te daŋ kum mɔ na see bia kumɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Daŋ kpaakpaate be gyae ke tale see bia kumɛɛ ya, te daŋ kum mɔ be gyae ke tale see bia kpaakpaa ya. ");
INSERT INTO ntr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Daŋ kamasɛ keŋ bɛɛ se bia kpaakpaa ya nɛ, bɛɛ kara ke na be ta mo do boalaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mena dɔɔ nombia ŋan balaŋ benaŋ ne yɛɛ nɛ, te ɛ ka mo gyeŋ wɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Na walaŋ kamasɛ ŋon ɔ ne baake maŋ nyi ‘Me Gbeŋgyoo, me Gbeŋgyoo’ nɛ, ne gyae la waa gyoo Wurubuarɛ gyoori keŋ man ya. Mɔna walaŋ ŋon ɔ ne yɛɛ kpene keŋ me kya ŋon ɔ kyaa adido ne gyae nɛ, ŋon waageŋ ne gyae la waa gyoo Wurubuarɛ gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nombia kedi wee dinaa keŋ man nɛ, balaŋ burum baa kaa yako nyiaa, ‘De Gbeŋgyoo, na n yele man te de kolosi Wurubuarɛ nombia yee? Yaa na n yele te da moowɔ gegi feliŋkumɛɛ lee balaŋ man yee? Na n yele te da moowɔ yɛɛ gyakoloŋ nombia na nombia dinaana yee?’ ");
INSERT INTO ntr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Botɔɔ te maa toro yako wɔ nyiaa, ‘Mɔɔ gyeŋ ŋon ya, ɛ lee me siaman. Ɛmɛɛ nombiakumɛɛyɛɛra!’ ” ");
INSERT INTO ntr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Keŋte Yesu besewɔ yako wɔ nyiaa, “Mena dɔɔ walaŋ kamasɛ ŋon ɔ ne nyii me nɔɔwoya kɛŋa te ɔ ne di ŋe dɔɔ nɛ, ɔ yɛɛ ŋgba siakaralate ŋon ɔ be baŋ ɔ deni gyakaa boe dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɔga ŋɛɛwɔ te booneŋ wuuwɔ te feliŋ dinaa gyɔɔ deni keŋ, mɔna ka te yale ya. Nawolo nyi ɔ see ka mokɔɔ gyakaa boe dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mɔna walaŋ kamasɛ ŋon ɔ ne nyii me nɔɔwoya kɛŋa te ɔ bee di ŋe dɔɔ ya nɛ, ɔ yɛɛ ŋgba diyiŋte ŋon ɔ be ma ɔ deni gyakaa aŋasa dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɔga ŋɛɛwɔ te booneŋ wuuwɔ te feliŋ dinaa gyɔɔ deni keŋ te ka leewɔ yala worom tekerii pou.” ");
INSERT INTO ntr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu ke yako nombia kɛŋa taŋ nɛ, ɔ kawola keŋ doo balaŋ dikpii keŋ nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nawolo nyi ɔ wolawɔ ŋgba walaŋ ŋon ɔ dana doŋ nombia ŋan dɔɔ nɛ, be yɛɛ ŋgba mena keŋ ba mmaraa wolala baŋ na wolo nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu ke tisi lee bula keŋ dɔɔ kɔŋ nɛ, balaŋ burum kaa sila e. ");
INSERT INTO ntr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Keŋte akuŋtuŋte ŋolo kaa buŋawɔ ɔ nawɔɔ tɛɛ waase e nyiaa, “Me Gbeŋgyoo, akpaa n ne gyae na nyaŋ ke tale kyɔ maŋ me kawee.” ");
INSERT INTO ntr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Botɔɔ te Yesu tenee ɔ nyiŋmaa tina e te ɔ yako e nyiaa, “Mɛɛ gyae, n kawee dɛɛ taŋ.” Debokenaŋ man te balee ŋon kawee taŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Keŋte Yesu tɔɔ e kiiŋ nyi, “Na yele walaŋ na walaŋ ke nyii ya, mɔna mo n wose gyu kawola Wurubuarɛ sae ŋon, na n ke deesi fa Wurubuarɛ ŋgba mena keŋ Mosesi ba wola ŋon nɛ, na ke di adansɛɛ fa walaŋ kamasɛ nyi n kawee te taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu ke gyu ka gyoo Kapanum donɔɔ man nɛ, Romantena yoonɔɔtena kegyia ŋolo kɔŋawɔ kaa waase nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Me Gbeŋgyoo lɛɛ maŋ, nawolo nyi me tobaale te tekerii ɔ doo deni man ɔ ne naa diyem nideli.” ");
INSERT INTO ntr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Keŋte Yesu yako e nyiaa, “Maa kɔŋ na me kaa kyɔ e ɔ kawee.” ");
INSERT INTO ntr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Botɔɔ te yoonɔɔtena kegyia ŋon yako e nyiaa, “Me gbeŋgyoo, na haa n wose ya. Nawolo nyi ma tekaboe nyi nya kɔŋ me dɛɛ ya. Mena dɔɔ nyaŋ betaa gyuusu n nɔɔ faree kawee keŋ, me tobaale ŋon waa koro. ");
INSERT INTO ntr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nawolo nyi maŋ gbagba mɔ yɛɛ walaŋ ŋon me doo baale tɛɛ, te yoonɔɔtena mɔ doo me tɛɛ. Me yako ŋolo nyi waa gyu yenaŋ daale na ɔ ne gyu, te me yako ŋolo nyi waa kɔŋ na ɔ ne kɔŋ. Kpene kamasɛ keŋ me yako be man ŋolo nyi waa yɛɛ na, keŋ te ɔ ne yɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ke nyii nɔɔwoya kɛŋa nɛ, doo ɔ nɔɔ te ɔ yako balaŋ dikpii keŋ be silana e nɛ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyiaa, Iserae tɛɛle kei dɔɔ pou nɛ ma te naa ta walaŋ ŋon ɔ ne lɛɛ Wurubuarɛ di ŋgba balee kei nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mɛɛ yako ŋon ɛ ke nyii nyiaa, balaŋ burum baa lee weese dɛɛlee na weese dɛɛyalae kɔŋ, na baŋ na Aberaham na Asiki na Gyekɔpo kaa kyaa Wurubuarɛ gyoori keŋ man na baa di bom. ");
INSERT INTO ntr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Te ɛmɛɛ Gyudatena baŋ nafɔ kaboena nyi yaa kyaa Wurubuarɛ gyoori keŋ man nɛ, baa lese ŋon debɔɔ ka see ditiŋtɛɛ keŋ man. Botɔɔ te ɛ ke kyaŋ ɛ nyeeya wii nideli. ");
INSERT INTO ntr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Keŋte Yesu yako yoonɔɔtena kegyia ŋon nyiaa “Ta gyu dɛɛ, mena keŋ n be lɛɛ maŋ di nɛ dɔɔ gyae ke kɔŋ mena fa neŋ.” Debokenaŋ man te ɔ tobaale ŋon kawee taŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kenaŋ wɔle te Yesu korowɔ gyu Pita dɛɛ. Ɔ ke gyu nɛ, na Pita wa awu doo ɔ na wee kpaŋalaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Keŋte Yesu kyaŋa e ɔ nyiŋmaa man te kpaŋalaŋ keŋ taŋawɔ. Keŋte ɔ korowɔ kɛɛ be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kelii balinɔɔ nɛ, ba moo balaŋ baŋ feliŋkumɛɛ doo be man nɛ kɔŋ Yesu gyaŋ. Ɔ moo nombii dokoloŋ kooŋ bo gegi feliŋkumɛɛ ŋan pou, te ɔ kyɔɔ kaweesetena baŋ mɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɔ ke yɛɛ kei yela nombia ŋan Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya be yako see nɛ kɔŋawɔ ampaŋ. Yesaya yakowɔ nyiaa, “Ŋon lɛɛ na de kaweese pou, te ɔ moo de kaale mɔ seele.” ");
INSERT INTO ntr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu kena nyi balaŋ burum te kilisi e nɛ, ɔ yako ɔ kaseela baŋ nyi baa toŋ gyu boo keŋ diŋgyiŋ. ");
INSERT INTO ntr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Keŋte Wurubuarɛ mmaraa wolale ŋolo kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, “De Gbeŋgyoo, yenaŋ kamasɛ keŋ n ke gyu na, maa sila neŋ gyu.” ");
INSERT INTO ntr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Keŋte Yesu yako e nyiaa, “Nyanyase dana bɔɔneŋ te gyebuse mɔ dana asaase, mɔna Deniwalaŋ Bu ŋon be taŋ botɔɔ keŋ waa mo ɔ nyee teeli ya.” ");
INSERT INTO ntr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Botɔɔ te Yesu silala baŋ man ŋolo mɔ yako e nyiaa, “Me gbeŋgyoo, yela maa taŋgbɛɛ gyu kewuu me kya pɛna me kaa sila neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Keŋte Yesu yako e nyiaa, “Sila maŋ, na n ke yela woya kewuu ba woya.” ");
INSERT INTO ntr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Botɔɔ te Yesu gyoowɔ degbele man, te ɔ kaseela baŋ mɔ gyoowɔ kpu na e. ");
INSERT INTO ntr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Karatetee dokoloŋ te feliŋ dinaa daale korowɔ ne gyɔɔ loŋ keŋ dɔɔ, te gyɔɔ loŋ do degbele keŋ man. Debaŋ kenaŋ na Yesu te doo dosoroŋ. ");
INSERT INTO ntr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mena dɔɔ Yesu kaseela baŋ gyuuwɔ ke gyuusu e yako e nyiaa, “De Gbeŋgyoo lɛɛ daa, dɛɛ gyae dɛɛ munu.” ");
INSERT INTO ntr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Keŋte Yesu yako wɔ nyiaa, “Ɛmɛɛ dɔɔ ɛ kelɛɛdi ta boo ya. Weera dɔɔ te ɛ dana gyakoloŋ mena?” Botɔɔ te ɔ korowɔ te ɔ fae feliŋ keŋ na loŋ keŋ te ŋe yɛɛwɔ yididi. ");
INSERT INTO ntr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Balaŋ baŋ wose yeŋa wɔ te be bɔɔse dɔŋa nyiaa, “Walaŋ woŋti yɛna kei, te feliŋ na loŋ koraŋ ne nyii e nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ka toŋ gyu boo keŋ diŋgyiŋ Gadaratena tɛɛle man nɛ, baala bala baale leewɔ amuseese man kɔŋ kaa gyaŋee na e. Na feliŋkumɛɛ doo balaŋ kɛwɔ man, te ba wose dana gyakoloŋ. Mena dɔɔ ŋolo bɛɛ tale mo gbɛɛ kenaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba kena Yesu nɛ be fae yeesa nedoŋ nyiaa, “Wurubuarɛ Bu, woŋ te n ne gyae de gyaŋ? N kɔŋae n kaa naase daa diyem pɛna debaŋ keŋ kelii?” ");
INSERT INTO ntr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Debaŋ kenaŋ na, kekuiriise dikpii dinaa daale seŋɛɛ botɔɔ yenaŋ bee dii. ");
INSERT INTO ntr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Keŋte feliŋkumɛɛ ŋan waase Yesu nyiaa, “Akpaa n ke gegi daa na, yela de kaa gyoo kekuiriise dikpii kei man.” ");
INSERT INTO ntr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Keŋte Yesu yako feliŋkumɛɛ ŋan nyiaa, “Ɛ lee ta.” Mena dɔɔ feliŋkumɛɛ ŋan leewɔ balaŋ baŋ man gyu ka gyoo kekuiriise baŋ man, te be dikpii keŋ pou yeuwɔ tisi bula kyoloŋkyoloŋ keŋ gyu ka gyoo loŋ keŋ man te be munuwɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Keŋte balaŋ baŋ bɛɛ kɛɛ kekuiriise baŋ dɔɔ nɛ, yeuwɔ gyu donɔɔ man te be yako nombia ŋan be kɔŋ nɛ pou na kpene keŋ be kɔŋ balaŋ baŋ feliŋkumɛɛ doo be man dɔɔ nɛ fa balaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mena dɔɔ donɔɔ keŋ man balaŋ pou leewɔ kɔŋ kaa gyaŋee na Yesu. Ba kena e nɛ, be waase e nyi waa lee be tɛɛle dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu gyoowɔ degbele man te ɔ toŋa boo keŋ gyu ŋon gbagba ɔ donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Keŋte balaŋ baale seele yenaŋ dayeŋasate ŋolo ɔ dofoŋoŋ dɔɔ kɔŋ Yesu gyaŋ. Yesu kena mena keŋ balaŋ baŋ be lɛɛ e di nɛ, ɔ yako kaweete ŋon nyiaa, “Me bu, nyiŋ konɔɔ. Me ta mo n nombiakumɛɛ kyɛɛ neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Botɔɔ te Wurubuarɛ mmaraa wolala baŋ be kyaa botɔɔ nɛ ŋorokoteewɔ nyiaa, “Balee kei ne kolosi mmusuo nombia.” ");
INSERT INTO ntr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Na Yesu gyeŋ kpene keŋ bɛɛ gyueŋ ba nyeeya man nɛ te ɔ bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ na gyueŋ nombiakumɛɛ ɛ nyeeya man? ");
INSERT INTO ntr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nombia kɛŋa man woŋti woɛla na keyako? ‘Me ta mo n dukum kyɛɛ neŋ, yaa koro seŋ na n ke ta?’ ");
INSERT INTO ntr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mɔna mɛɛ gyae ɛ ka gyeŋ nyi, maŋ Deniwalaŋ Bu dana doŋ tɛɛle kei dɔɔ nyi maa mo dukum kyɛɛ.” Mena dɔɔ ɔ yako kaweete ŋon nyiaa, “Koro seŋ, gate n dofoŋoŋ na n ke ta gyu n dɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Keŋte balee ŋon korowɔ seŋ te ɔ laŋa ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Balaŋ dikpii keŋ kena nombia kɛŋa nɛ, doo be nɔɔ te ba lese Wurubuarɛ ŋon ɔ ba mo mena doŋ kei fa balaŋ nɛ yele. ");
INSERT INTO ntr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ka lee botɔɔ ɔ ne lam nɛ, ɔ naa balee ŋon bɛɛ baake e nyi Mateo nɛ, na ɔ kyaa ɔ lempoo dɛɛlɛe man. Te Yesu yako e nyiaa, “Koro sila maŋ” Keŋte Mateo korowɔ sila e. ");
INSERT INTO ntr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wee daale Yesu ke kyaa Mateo dɛɛ ɔ ne dii nɛ, lempoolɛɛra na nombiakumɛɛyɛɛra burum kɔŋawɔ kaa di bom na Yesu na ɔ kaseela baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasiitena baŋ kena mena nɛ be bɔɔse Yesu kaseela baŋ nyiaa, “Weera dɔɔ te ɛ Gbeŋgyoo ŋon ne dii bom na lempoolɛɛra na nombiakumɛɛyɛɛra?” ");
INSERT INTO ntr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ke nyii nombia kɛŋa nɛ ɔ yako wɔ nyiaa, “Kaweesetena te kaboena nyi baa kyɔ wɔ kawee. Balaŋ baŋ bɔɔ na wee ya nɛ dɔɔ, bɔɔ ne hia kawee kekyɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mɔna ɛ gyu na ɛ kaa gyueŋ kpene keŋ Wurubuarɛ nombii aŋmaraseŋ see kei na wolo nɛ man. Be ŋmarasewɔ nyiaa, Wurubuarɛ kpa, ‘Na kedeesa te maŋ Wurubuarɛ ne gyae lee ɛ gyaŋ ya. Keŋ mɛɛ gyae yɛna nyi yaa wii dɔŋa waraŋase.’ Ma te kɔŋ nyi me kaa baake balaŋ baŋ be gbɛɛneŋ wulaa tenɛɛ Wurubuarɛ siaman nɛ ya, mɔna me kɔŋae me kaa baake nombiakumɛɛyɛɛra.” ");
INSERT INTO ntr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wee daale nɛ, Gyɔn Wurubuarɛ loŋsɔɔre ŋon kaseela kɔŋawɔ kaa bɔɔse Yesu nyiaa, “Weera dɔɔ te daa na Farasiitena ne bake de nɔɔ, te n kaseela baŋ dɔɔ baŋ bɛɛ bake be nɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Sena te balaŋ baŋ be kyaa alowɔletɛɛ nɛ baa wii walaŋsa keŋ alowɔle baale kyaa be gyaŋ? Mɔna debaŋ daale gyae kekɔŋ keŋ baa mo alowɔle baale ŋon lee be gyaŋ. Mena debaŋ kenaŋ man na baa bake be nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ŋolo bɛɛ kara kanyaŋ wɔle mo taa kakyeŋgbelaa keŋ ba yem nɛ ya. Akpaa ɔ yɛɛ mena na, kanyaŋ wɔle keŋ gyae ke wɔŋee bene keŋ tirii na bɔɔ keŋ ke wolose kpu. ");
INSERT INTO ntr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mena mɔ te ŋolo bɛɛ mo soloŋ wɔle do wonembu tɔne ogele bene man ya. Ɔ yɛɛ mena na, soloŋ wɔle keŋ gyae ke yela wonembu tɔne ogele keŋ ke bɛɛ, na soloŋ keŋ ke leki na wonembu tɔne ogele keŋ ke wɔlɛɛ. Mena dɔɔ kaboena bo nyi baa mo soloŋ wɔle do wonembu tɔne ogele wɔle man, na ŋe popou be nyiŋ wɔlɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu kɛɛ kolosi nombia kɛŋa fa wɔ nɛ, Gyudatena ɔsom kegyia ŋolo kaa buŋawɔ ɔ nawɔɔ tɛɛ sola e nyiaa, “Me bu alebu ta yem debokeiman. Mɔna kɔŋ na n kaa mo n nyiŋmaa gyakaa ɔ dɔɔ, na waa nyiŋ nyeedoŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mena dɔɔ Yesu korowɔ sila e, te ɔ kaseela baŋ mɔ sila e gyu. ");
INSERT INTO ntr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Botɔɔ na te alo ŋolo ŋon fatabo ne gyɔ e kulutooneŋ kufu ala nɛ, moowɔ Yesu wɔle te ɔ moo ɔ nyiŋmaa tina Yesu kegba nɔɔbii. ");
INSERT INTO ntr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nawolo nyi alo ŋon yakowɔ ɔ nyeeman nyiaa, “Akpaa me nyiŋ tina ɔ kegba koraŋ na, me kawee gyae ke taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Keŋte Yesu gɛɛsewɔ kɛɛ te ɔ naa alo ŋon te ɔ yako e nyiaa, “Me bu yela n wɔe ke fɛɛ neŋ. N kelɛɛ maŋ di dɔɔ te n nyiŋa kawee kekyɔ.” Debokenaŋ man te alo ŋon kawee taŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu ke gyu ka gyoo Gyudatena ɔsom kegyia ŋon dɛɛ, te ɔ kena baŋ bɛɛ wola kefereese na baŋ bee wii lia ŋan tɛɛ nɛ, ");
INSERT INTO ntr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ɔ yako wɔ nyiaa, “Ɛ popou ɛ lee. Nawolo nyi alebu ŋon ta yeŋa ta ya, ɔ doo dosoroŋ bo.” Keŋte balaŋ baŋ pou boŋo Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Balaŋ baŋ ka lee debɔɔ man nɛ, Yesu gyuuwɔ deni keŋ man woo ŋon doo nɛ, te ɔ kyaŋa e ɔ nyiŋmaa man te alebu ŋon foŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mena nombia kɛŋa yaaseewɔ tɛɛle kenaŋ dɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ka lee botɔɔ ɔ ne gyu nɛ, siayɛlɛɛsatena bala baale sila e na bɛɛ fae yeesa baake nyiaa. “Gyoo Defidi ɔ naanabii, wii de waraŋase.” ");
INSERT INTO ntr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ke gyu ka gyoo dekpaŋalaŋ man nɛ, siayɛlɛɛsatena baŋ kɔŋawɔ ɔ gyaŋ te ɔ bɔɔse wɔ nyiaa, “Ɛ ne lɛɛ maŋ di nyi maa tale gyuusu ɛ sia?” Keŋte be tiranɔɔ fa e nyi, “Ayi de Gbeŋgyoo.” ");
INSERT INTO ntr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Keŋte Yesu moo ɔ nyiŋmaa tina be sia te ɔ yako wɔ nyiaa, “Mena keŋ ɛ be lɛɛ di nɛ, dɛɛkɔŋ mena fa ŋon.” Keŋte be sia gyuusuwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Botɔɔ te Yesu faree wɔ nideli nyi, “Ɛ na yele ŋolo na ŋolo ke nyii nombia kɛŋa ya.” ");
INSERT INTO ntr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mɔna baŋ moo ɔ wose man nombia kpeŋkpeleŋ fa balaŋ tɛɛle kenaŋ pou dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Be ka lee botɔɔ bee gyu nɛ, ba moo walaŋ ŋon feliŋkum doo ɔ man te ɔ bɛɛ tale kolosi ya nɛ kɔŋ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu ke gegi feliŋkum keŋ lee balee ŋon man nɛ, te ɔ kolosiwɔ. Balaŋ dikpii keŋ kena mena nɛ, nombia ŋan doo be nɔɔ te be yakowɔ nyiaa, “Da te naa ta mena nombia kɛŋa see Iserae tɛɛle kei dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mɔna Farasiitena baŋ yakowɔ nyiaa, “Feliŋkumɛɛ pou gyoo ŋon doŋ yaa ɔ na mo gegi feliŋkumɛɛ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Keŋte Yesu tɛɛwɔ kila donɔɔse na akuraase ŋan pou man, na ɔ na wola wɔ Gyudatena ɔsom denɛɛ man. Ɔ ne kolosi Wurubuarɛ gyoori keŋ nombia kpaakpaa fa wɔ, te ɔ kyɔɔ kaweese kpookpoo kamasɛ mɔ. ");
INSERT INTO ntr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ɔ kena balaŋ dikpii keŋ nɛ, be nombia yɛɛ e waraŋase. Nawolo nyi bɛɛ yeyɛɛ te bɔɔ dana walaŋ ŋon waa lɛɛ wɔ ya. Be nombia yɛɛ ŋgba namense baŋ bɔɔ dana gbeŋgyoo ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Botɔɔ te ɔ yako ɔ kaseela baŋ nyiaa, “Wɔɔman abɔɔ ŋan boe na kekɛrɛɛ, mɔna tomyɛɛra baŋ ta boo ya. ");
INSERT INTO ntr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mena dɔɔ ɛ fane fa wɔɔte ŋon, na waa lese balaŋ ke kɔŋ ɔ wɔɔ keŋ man kaa yɛɛ tom.” ");
INSERT INTO ntr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu baake ɔ kaseela kufu bala baŋ kɔŋ ɔ gyaŋ, te ɔ faa wɔ doŋ keŋ baa mo gegi feliŋkumɛɛ lee balaŋ man, na baa kyɔ kaweese kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kpilala kufu bala baŋ yela yaa. Gyaŋgbate ŋon yɛna Simɔn, ŋon ɔ yele daale mɔ yɛna nyi Pita nɛ, na ɔ naabu Anderiase, na Sebedeo bu Gyemisi na ɔ naabu Gyɔn, ");
INSERT INTO ntr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na Filipo na Batolomeo na Tomase na Mateo ŋon nafɔ ɔ yɛɛ lempoolɛɛre e nɛ, na Alfeose bu Gyemisi na Tadeose, ");
INSERT INTO ntr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na Simɔn ŋon ɔ ne gyae ɔ balaŋ nideli nɛ, na Gyudase Isekarɔte ŋon waa kaa lese Yesu fa nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mena kpilala kufu bala kɛwɔ te Yesu kpilawɔ te ɔ faree wɔ nyiaa, “Ɛ na gyu balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ gyaŋ ya, te ɛ na gyu Samariatena mɔ donɔɔ kamasɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mɔna ɛ taŋgbɛɛ gyu Iseraetena baŋ gyaŋ. Be yɛɛ ŋgba namense baŋ bɔɔ yoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɛ gyu na ɛ kolosi Wurubuarɛ nombia fa wɔ nyiaa, ‘Wurubuarɛ gyoori keŋ ta benaa.’ ");
INSERT INTO ntr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɛ kyɔ kaweesetena na ɛ ke gyuusu balaŋ baŋ bɔɔ yekee nɛ, na ɛ ke kyɔ baŋ bɛɛ wee kawee yayam nɛ, na ɛ ke gegi feliŋkumɛɛ lee balaŋ man. Ba moo mena doŋ kei fa ŋon bo yakaa keŋ ɛ te tɔ kom ya, mena dɔɔ ɛmɛɛ mɔ ɛ mo fa wɔ yakaa keŋ ɛ na lɛɛ wɔ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ɛ na mo kɔba na kɔba tela ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ɛ na mo akpo ya, te ɛ na mo kegba alate yaa nkyokota alate yaa gbutu alate tela ya. Nawolo nyi kaboena nyi baa tɔ tomyɛɛre kamasɛ kom. ");
INSERT INTO ntr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Donɔɔ yaa akuraa kamasɛ keŋ man ɛ gyoo nɛ, ɛ taŋgbɛɛ bɔɔse walaŋ ŋon ɔ kaboena te waa lɛɛ ŋon nɛ dɔɔ, na ɛ ke kyaa ɔ gyaŋ kaboena e ka mo lee donɔɔ kenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ɛ gyoo dekpaŋalaŋ kenaŋ man nɛ, ɛ do dekpaŋalaŋmantena baŋ nɔɔ nyiaa, Wurubuarɛ wosefɛɛreŋ dɛɛ kyaa ɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nyi akpaa dekpaŋalaŋmantena benaŋ de lɛɛ ŋon nideli na, ɛ sola Wurubuarɛ wosefɛɛreŋ fa wɔ. Te akpaa ba te lɛɛ ŋon nideli ya na, ɛ yela wosefɛɛreŋ keŋ ka bese kɔŋ ɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mɔna donɔɔ yaa akuraa kamasɛ keŋ ke man balaŋ de bɛɛ ba te lɛɛ ŋon ya, yaa be te nyii ɛ nombia ŋan ya nɛ, nyi akpaa ɛ na lee botɔɔ na ɛ kpiisi ɛ nawɔɔ aŋasa lɔ wɔ, na kawola nyi be ta fom Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ampaŋ yaa mɛɛ yako ŋon nyi wee keŋ Wurubuarɛ waa di balaŋ nombia nɛ, waa naase mena balaŋ benaŋ diyem kela Sodom na Gomoratena diyem keŋ bɔɔ naa kaalaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ɛ kɛɛ, mee kpila ŋon baa ŋgba namense nɛ, nyi yaa gyu gbougbouse man. Mena dɔɔ ɛ yela ɛ sia ke kara ŋgba doma nɛ, na ɛ ke yɔkɔse ɛ wose ŋgba awuluŋna nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mena dɔɔ ɛ kɛɛ ɛ wose man nideli lee balaŋ wose man. Nawolo nyi baa mo ŋon gyu kegyiise siaman na baa di ɛ nombia, na baa tuku ŋon bɔ ɔsom denɛɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lee maŋ dɔɔ, baa mo ŋon gyu tɛɛle kegyiise na gyooneŋ siaman. Kei gyae ke yela ɛ ke nyiŋ gbɛɛ kolosi Wurubuarɛ nombia ŋan fa wɔ, na baŋ ba te yɛɛ Gyudatenawɔ ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mɔna nyi akpaa be kyaŋ ŋon ka seŋ be siaman nɛ, ɛ na wɔlɛɛ na kpene keŋ ɛ ke yako, na mena keŋ ɛ ke yako ke ya. Debaŋ kenaŋ de lii nɛ, Wurubuarɛ waa wola ŋon kpene keŋ ɛ ke yako. ");
INSERT INTO ntr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nawolo nyi na ɛmɛɛ ne gyae la ɛ ke kolosi ya. Wurubuarɛ feliŋ ŋon ne gyae la waa ta ɛ dɔɔ kolosi. ");
INSERT INTO ntr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mena debaŋ kenaŋ nɛ, naa lolo bia baa lese dɔŋa fa yeŋ. Kya waa lese ɔ bu fa yeŋ, te bia mɔ baa koro seŋ ba lolala nyeeya dɔɔ na baa lese wɔ fa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lee maŋ dɔɔ balaŋ pou baa kɔla ŋon. Mɔna walaŋ ŋon ɔ yɛɛ kakyeŋ seŋ keŋkeŋ ɔ kelɛɛdi man kelii ɔto nɛ, Wurubuarɛ waa lɛɛ ɔ nyee. ");
INSERT INTO ntr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nyi akpaa be naase ŋon diyem donɔɔ daale man na, ɛ yeu gyu donɔɔ wɔle man. Ampaŋ yaa mɛɛ yako ŋon nyiaa, ɛ be gyae ɛ ke yɛɛ tom Iserae donɔɔse ŋan man pou taŋ, pɛte maŋ Deniwalaŋ Bu ŋon maa bese kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Walaŋ ŋon ɔ ne kasee abɔɔ nɛ ɔ ba kela ŋon ɔ na wola e nɛ ya, te gbeŋi mɔ ba kela ɔ gbeŋgyoo ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kaboena nyi kaseele waa yɛɛ ŋgba ɔ wolale nɛ, na gbeŋi mɔ ke yɛɛ ŋgba ɔ gbeŋgyoo nɛ. Te akpaa bɛɛ baake dekpaŋalaŋte ŋon nyi ŋon yɛna feliŋkumɛɛ gyoo Bɛlisɛbu na, woŋ dɔɔ te bɔɔ mo yela kumɛɛ gyakaa ɔ dekpaŋalaŋmantena baŋ dɔɔ ya? ");
INSERT INTO ntr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Mena dɔɔ ɛ na yee wɔ ya. Nawolo nyi kolo be kyaa keŋ bɔɔ wuu ke dɔɔ keŋ nyi bɔɔ gyae baa gyuusu ke ya, te nombia aweeseŋ ŋaale mɔ be kyaa keŋ be gyae ka lee debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nombii kamasɛ keŋ me yako ŋon nelim na ɛ yako ke weeseteŋteŋ, te nombii kamasɛ keŋ me kolosi ke adadawoya man do ɛ deŋela man na, ɛ mo ke gyɔ dekpeŋkpeŋ. ");
INSERT INTO ntr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɛ na yee balaŋ baŋ baa tale ko deniwalaŋ kaageŋ bo, mɔna bɔɔ tale yɛɛ kolo kpu bela nɛ ya. Mɔna ɛ yee Wurubuarɛ ŋon ɔ ko walaŋ taŋ na, ɔ dana doŋ nyi waa fuŋ e na ɔ woo pou ka do boalaŋ keŋ bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Akpelee koya yɛɛ aŋmoŋ? Na kaperɛ te bɛɛ yɔɔ akpeleese bala yee? Mɔna akpaa Wurubuarɛ te fa gbɛɛ ya na, be man dokoloŋ gba be gyae waa yala yeŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɛ nyeenyɔɔse koraŋ nɛ, Wurubuarɛ gyeŋ ŋe yaanɔɔle. ");
INSERT INTO ntr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mena dɔɔ ɛ na yee ya, nawolo nyi ɛ dana tɔnɔɔ kela akpeleese burum. ");
INSERT INTO ntr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ɛ man walaŋ kamasɛ ŋon ɔ lɛɛ man do denibalaŋ siaman nyi me yɛɛ ɔ Gbeŋgyoo e nɛ, maŋ mɔ maa lɛɛ e do me kya ŋon ɔ kyaa adido nɛ siaman. ");
INSERT INTO ntr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mɔna walaŋ kamasɛ ŋon ɔ te lɛɛ maŋ do denibalaŋ siaman nyi me yɛɛ ɔ Gbeŋgyoo e ya nɛ, maŋ mɔ maa bɛɛ e me kya ŋon ɔ kyaa adido nɛ siaman. ");
INSERT INTO ntr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Keŋte Yesu yako wɔ nyiaa, ɛ na gyueŋ nyi wosefɛɛreŋ yaa ma moowɔ kɔŋ tɛɛle kei dɔɔ ya. Koa, na wosefɛɛreŋ ya, mɔna yoo te ma moowɔ kɔŋ, ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see ne yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bia baala baa koro seŋ tia be kyaɔ, na bia alebia mɔ ka koro seŋ tia be naɔ, na bia ala mɔ ka koro seŋ tia ba awuna. ");
INSERT INTO ntr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Walaŋ dekpaŋalaŋ man balaŋ gbagba ne gyae la baa kɔla e. ");
INSERT INTO ntr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Akpaa ŋolo ne kɔŋ me gyaŋ ɔ kaa sila maŋ te ɔ ne gyae ɔ kya yaa ɔ naa kela maŋ na, ɔ tekaboena nyi waa yɛɛ me kaseele ya. Te walaŋ ŋon mɔ ɔ ne gyae ɔ bu tobaale yaa ɔ bu alebu kela maŋ na, ɔ tekaboena nyi waa yɛɛ me kaseele ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te walaŋ kamasɛ ŋon ɔ ta mo ɔ ɔpaŋdaŋ keŋ ka seŋɛɛ fa kaale na yeŋ nɛ na waa sila maŋ ya na, ɔ tekaboena nyi waa yɛɛ me kaseele ya. ");
INSERT INTO ntr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Walaŋ kamasɛ ŋon ɔ mo ŋon gbagba doŋ ɔ ne kɛo ɔ nyeedoŋ nɛ, ke gyae ka lee ɔ nyiŋmaa man. Mɔna walaŋ kamasɛ ŋon ɔ mo ɔ wose fa yeŋ lee maŋ dɔɔ nɛ, waa bese nyiŋ ɔ nyeedoŋ keŋ. ");
INSERT INTO ntr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Walaŋ kamasɛ ŋon ɔ lɛɛ ŋon na maŋ yaa ɔ lɛɛwɔ, te ŋon ɔ lɛɛ maŋ na Wurubuarɛ ŋon ɔ be kpila maŋ nɛ yaa ɔ lɛɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Walaŋ kamasɛ ŋon ɔ lɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre, nyi keŋ ɔ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e dɔɔ nɛ, Wurubuarɛ dekpeŋkpeŋgyɔɔre kom te Wurubuarɛ waa mo tɔ walaŋ ŋonaŋ. Te walaŋ kamasɛ ŋon ɔ lɛɛ walaŋ ŋon ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nyi keŋ ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman dɔɔ nɛ, walaŋ ŋon ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nɛ kom te Wurubuarɛ waa mo tɔ walaŋ ŋonaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Walaŋ kamasɛ ŋon ɔ fa balaŋ kɛwɔ man ŋolo loŋ defɛɛsa leenɔɔ tɔɔ nyi keŋ ɔ yɛɛ me kaseele e dɔɔ nɛ, Wurubuarɛ waa tɔ e kom.” ");
INSERT INTO ntr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ke kolosi nombia kɛŋa fa ɔ kaseela kufu bala baŋ taŋ nɛ, ɔ leewɔ botɔɔ gyu donɔɔse akaŋ ŋan kyaa Galelia tɛɛle man nɛ ke kolosi Wurubuarɛ nombia fa wɔ, te ɔ wola wɔ ŋe man nideli. ");
INSERT INTO ntr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mena debaŋ kenaŋ na ba te kyaŋ Gyɔn Wurubuarɛ loŋsɔɔre tɔ deni. Ɔ ke nyii kpene keŋ Yesu ne yɛɛ nɛ, ɔ kpila ɔ kaseela nyi ");
INSERT INTO ntr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","baa gyu ke bɔɔse Yesu nyiaa, “Nyaŋ yɛna walaŋ ŋon Wurubuarɛ be yako see nyi nyaŋ ke kɔŋ nɛ yaa, dɛɛ kɛɛ walaŋ wɔle gbɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Be ke gyu ke bɔɔse Yesu nɛ te ɔ tiranɔɔ fa wɔ nyiaa, “Ɛ bese gyu ke yako Gyɔn kpene keŋ ɛ be nyii na ɛ deŋela, na ŋan ɛ be naa na ɛ sia. ");
INSERT INTO ntr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Siayɛlɛɛsatena ne naa, ɔtakasese ne tɛɛ, baŋ bɛɛ wee kawee yayam nɛ kaweese te taŋ, te deŋela atɔɔsatena ne nyii. Woya ne foŋii, te bɛɛ yako Wurubuarɛ nombia ŋan mɔ fa ayematena. ");
INSERT INTO ntr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Walaŋ kamasɛ ŋon ɔ bɛɛ lɛɛ maŋ aŋmaareŋ nyi maŋ yɛna ŋon Wurubuarɛ be kpili ya nɛ, ŋon na nyeebam.” ");
INSERT INTO ntr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gyɔn kpilala baŋ ka bese bee gyu nɛ, Yesu kolosi Gyɔn wose man nombia fa balaŋ dikpii keŋ te ɔ bɔɔse wɔ nyiaa, “Ɛ ke gyu Gyɔn gyaŋ depampaa dinaa keŋ man nɛ, woŋ te ɛ gyaewɔ nyi ɛ kena? Ŋale keŋ feliŋ ne gyɔ ke wosi nɛ? ");
INSERT INTO ntr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Akpaa na keŋ ya na, woŋ te ɛ gyuuwɔ ɛ kaa kɛɛ? Walaŋ ŋon ɔ doona abɔɔ kpaakpaa nyiŋan yaa? Baŋ bee mia mena nɛ, ne kyaa bo gyooneŋ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɛ yako maŋ maa nyii, woŋ te nafɔ ɛ gyuuwɔ nyi ɛ kaa kɛɛ? Wurubuarɛ dekpeŋkpeŋgyɔɔre? Ampaŋ yaa mɛɛ yako ŋon nyi, ŋon ɛ be naa nɛ gba kela Wurubuarɛ dekpeŋkpeŋgyɔɔre. ");
INSERT INTO ntr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nawolo nyi Gyɔn kei yɛna ŋon bɔɔ yako ɔ wose man nombia Wurubuarɛ nombia aŋmaraseŋ see man nɛ nyiaa, ‘Wurubuarɛ kpa, mee kpila me kpilale ke ta n siaman, ŋon ne gyae la waa desina n gbɛɛ fa neŋ.’ ");
INSERT INTO ntr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Keŋte Yesu besewɔ yako wɔ nyiaa, mɛɛ yako ŋon ɛ ke nyii nyiaa, balaŋ baŋ bɔɔ lolo tɛɛle kei dɔɔ nɛ, ŋolo be kyaa keŋ nyi ɔ kela Gyɔn Wurubuarɛ loŋsɔɔre ya. Mɔna Wurubuarɛ gyoori keŋ man nɛ, walaŋ ŋon ɔ yɛɛ kemaasa e koraŋ nɛ, ɔ kela Gyɔn kei. ");
INSERT INTO ntr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Leenaŋ Gyɔn Wurubuarɛ loŋsɔɔre debaŋ kaa lii na gyɛŋ kei nɛ, balaŋ na mo kale na doŋ nombia bo gyaŋee na Wurubuarɛ gyoori keŋ nombia ŋan, te balaŋ baŋ mɔ bɛɛ gyae ke nɛ, na mo siadoŋ bo baa gyoo ke man. ");
INSERT INTO ntr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nawolo nyi Wurubuarɛ akpeŋkpeŋgyɔɔra, na Wurubuarɛ mmaraase ŋan pou kolosi Wurubuarɛ gyoori keŋ wose man nombia, pɛte Gyɔn Wurubuarɛ loŋsɔɔre kɔŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Akpaa ɛ ke sɛɛ lɛɛ mena nombia kɛŋa di na, ŋon Gyɔn yɛna Elia ŋon Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo be yako see nyi waa bese kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nyaŋ ŋon n dana deŋela anenyiiŋ dei na, tei. ");
INSERT INTO ntr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Keŋte Yesu bɔɔse wɔ nyiaa, woŋ te maa mo gyɛŋ wee kei balaŋ maa na? Sena te be wɔɛ? Be yɛɛ ŋgba bia kyaa la abɔntere man bee yoi nɛ, na bɛɛ fae yeesa yako dɔŋa nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","De kpee alowɔle nɔɔneŋse fa ŋon mɔna ɛ te sɔe ya! De kpee lia nɔɔneŋse mɔ fa ŋon, mɔna ɛ te wii ya. ");
INSERT INTO ntr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gyɔn Wurubuarɛ loŋsɔɔre ŋon kɔŋawɔ na ɔ ne kyaa bake ɔ nɔɔ. Ɔ te nyɔɔ soloŋ kamasɛ ya te ɛ kpa nyi ‘Feliŋkumɛɛ doola ɔ man.’ ");
INSERT INTO ntr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Maŋ Deniwalaŋ Bu ŋon kɔŋawɔ mee dii mɛɛ nyɔɔ, te ɛ kpa nyi, ‘Ɛ kɛɛ balee kei. Ɔ yɛɛ kedikumte na soloŋnyɔɔre e. Ɔ gyoona yɛna lempoolɛɛra na nombiakumɛɛyɛɛra.’ Mɔna walaŋ ŋon ɔ dana Wurubuarɛ nyansa nɛ, ɔ tom na wola la.” ");
INSERT INTO ntr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Donɔɔse ŋan man Yesu be yɛɛ gyakoloŋ nombia nɛ, ŋe man balaŋ burum te lɛɛ e di na baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man, na baa kɔŋ Wurubuarɛ gyaŋ ya. Keŋte Yesu kolosiwɔ tia wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ɛmɛɛ Korasintena na Bɛtesaidatena, ɛ laako! Nawolo nyi gyakoloŋ nombia ŋan Wurubuarɛ be yɛɛ ɛ gyaŋ nɛ, nyi akpaa beŋ yɛɛ ŋa Tae na Sidɔn donɔɔse man na nafɔ beŋ te wulaa do titere abɔɔ kyaa mo tɔŋ buraa ba wose, na kawola nyi ba te kyɛɛkee ba agyueŋ lee be gbɛɛneŋ kumɛɛ man kɔŋ Wurubuarɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mɔna mɛɛ yako ŋon ɛ ke nyii nyiaa, wee keŋ Wurubuarɛ waa kaa di balaŋ nombia nɛ, waa wii Taetena na Sidɔntena waraŋase kela ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te nɛnɛɛ ɛmɛɛ Kapanumtena, ɛ gyeŋ nyi Wurubuarɛ waa kɛlɛɛ ŋon gyina ŋon adido? Koa, waa yɔkɔse ŋon, na waa mo ŋon do boalaŋ keŋ bɛɛ yem ya nɛ man, na ɛ kena diyem kekpaakekpaa. Nafɔ gyakoloŋ nombia ŋan mɔɔ yɛɛ ɛ man yaa meŋ yɛɛwɔ Sodom donɔɔ man nɛ, nafɔ gyɛŋ ke deŋ sɛɛ ke kyaa. ");
INSERT INTO ntr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mɔna mɛɛ yako ŋon ɛ ke nyii nyi wee keŋ Wurubuarɛ waa kaa di balaŋ pou nombia nɛ, waa wii Sodomtena waraŋase kela ŋon.” ");
INSERT INTO ntr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mena debaŋ kenaŋ man te Yesu fanewɔ nyiaa, “Me kya, adido na ateta pou Gbeŋgyoo, mɛɛ fa neŋ karaŋ nawolo nyi n ta mo abɔɔ kɛŋa weese nyansatena na baŋ ba gyeŋ nombia nɛ, te n lese ŋa wola balaŋ baŋ be dinɔɔ yɛɛ ŋgba bia nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Taata, ma gyeŋ nyi kei yɛna nyaŋ gbagba n kegyaebii.” ");
INSERT INTO ntr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Botɔɔ te Yesu yako balaŋ baŋ nyiaa, “Me kya ta mo kpene kamasɛ do maŋ me nyiŋmaa man. Ŋolo ba gyeŋ maŋ ɔ bu ŋon ya, me kya waageŋ kooŋ gyeŋa na maŋ. Ŋolo mɔ ba gyeŋ kya ŋon ya, maŋ ɔ bu ŋon na baŋ maa lese me kya ŋon wola wɔ nɛ, baageŋ ne gyae la baa gyeŋ e.” ");
INSERT INTO ntr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Keŋte Yesu besewɔ yako nyiaa, “Ɛmɛɛ baŋ ɛ seelena kasolɔse yuŋnyiŋan te ne takaa ŋon nɛ, ɛ kɔŋ me gyaŋ na maa yela ɛ ke fɛɛfo. ");
INSERT INTO ntr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɛ kɔŋ na daa na ŋon ke yɛɛ nɔɔdokoloŋ na ɛ ke kasee maŋ, na ɛ ke nyiŋ wosefɛɛreŋ. Nawolo nyi ma woɛ, te ma te yɔkɔse ma wose mɔ lee me konɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nawolo nyi gbɛɛ keŋ dɔɔ maa mo ŋon ta nɛ, be taŋ baŋ ya te kasolɔ keŋ maa bake seele ŋon nɛ, be gyae ke yɛɛ ŋon yuŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te di weeya ala ya nɛ, Yesu na ɔ kaseela gyuuwɔ ka mo wɔɔ daale man. Na weenɛɛ ŋan seŋɛɛ wɔɔ kenaŋ man nɛ yɛɛ ŋgba kefaa nɛ. Tanam kyaŋa ɔ kaseela baŋ te ba kpera ŋaale posaa bɛɛ tao. Na wee kenaŋ yɛɛ Gyudatena kefɛɛfowee ke. ");
INSERT INTO ntr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasiitena baŋ kena mena nɛ be yako Yesu nyiaa, “Kɛɛ! N kaseela ne yɛɛ kpene keŋ da mmaraa bɛɛ fa gbɛɛ nyi dɛɛ yɛɛ da kefɛɛfowee ya.” ");
INSERT INTO ntr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Botɔɔ te Yesu mɔ bɔɔse wɔ nyiaa, “Ɛ te kala ta lee Wurubuarɛ nombia aŋmaraseŋ see ŋan man kpene keŋ gyoo Defidi be yɛɛ debaŋ keŋ tanam be kyaŋ ŋon na ɔ balaŋ baŋ nɛ yee? ");
INSERT INTO ntr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ɔ gyoowɔ Wurubuarɛ ɔsom deni dinaa keŋ man te ɔ ka moo weenɛɛ ŋan bɔɔ mo deesi fa Wurubuarɛ, keŋ nafɔ tekaboena nyi walaŋ ŋon ɔ te yɛɛ Wurubuarɛ sae e ya waa di ya nɛ, te ɔ diiwɔ te ɔ moo ŋaale mɔ fa ɔ balaŋ baŋ be silana e nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yaa ɛ ta bese ta kala lee Wurubuarɛ mmaraa tɔne keŋ man nyi, saese baŋ be kyaa Wurubuarɛ ɔsom deni dinaa keŋ man nɛ, deesiwɔ fa Wurubuarɛ kefɛɛfowee keŋ mɔna ŋolo te bu wɔ fɔɔ nyi ba te walaa ke yee? ");
INSERT INTO ntr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ampaŋ yaa mɛɛ yako ŋon nyiaa, walaŋ ŋon ɔ kela Wurubuarɛ ɔsom deni dinaa keŋ nɛ kyaa kɛbo. ");
INSERT INTO ntr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wurubuarɛ yakowɔ ɔ nombia aŋmaraseŋ see man nyiaa, ‘Mɛɛ gyae bo nyi yaa wii balaŋ waraŋase, na kedeesa te mɛɛ gyae ya. Nyi yeŋ nyii nombia kɛŋa man nɛ, nafɔ ɛ be gyae ɛ ke bu balaŋ baŋ be nombia dei nɛ fɔɔ ya.’ ");
INSERT INTO ntr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nawolo nyi maŋ Deniwalaŋ Bu ŋon yɛna kefɛɛfowee keŋ gbeŋgyoo.” ");
INSERT INTO ntr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ka lee botɔɔ nɛ, ɔ gyuuwɔ Gyudatena ɔsom deni man. ");
INSERT INTO ntr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na balee ŋolo kyaa botɔɔ keŋ ɔ baam ba yem. Lee mena keŋ bɛɛ gyae gbɛɛ na baa mo nombiikum seele Yesu dɔɔ nɛ, be bɔɔse e nyi da mmaraa ne fa daa gbɛɛ nyi dɛɛ kyɔ walaŋ kawee da kefɛɛfowee? ");
INSERT INTO ntr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Keŋte Yesu bɔɔse wɔ nyiaa, “Ɛ man woŋti te akpaa ɔ dana nam dokoloŋ te ɔ yale gyoo bɔɔ man kefɛɛfowee na, waa bɛɛ nyi ɔ ba lese e ya? ");
INSERT INTO ntr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Deniwalaŋ kela nam. Mena dɔɔ gbɛɛ doo nyi dɛɛ yɛɛ deeli kefɛɛfowee.” ");
INSERT INTO ntr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Botɔɔ te Yesu yako balee ŋon nyiaa, “Tenee n baam keŋ.” Keŋte balee ŋon mɔ tenee ke, te ɔ baam keŋ yɛɛ doŋ ŋgba alate keŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lee mena dɔɔ Farasiitena baŋ leewɔ gyu kebake, lee gbɛɛ keŋ man baa mo na baa ko Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu kena mena nɛ, ɔ wɔŋa ɔ wose lee yenaŋ. Balaŋ burum sila e te ɔ kyɔɔ be man kaweesetena baŋ pou, ");
INSERT INTO ntr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mɔna ɔ faree wɔ nyi be na yako ɔ wose man nombia fa ŋolo na ŋolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kei yele la Wurubuarɛ nombia ŋan ɔ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Yesaya dɔɔ yako nɛ kɔŋawɔ ampaŋ. Yesaya yakowɔ nyiaa, Wurubuarɛ kpa ");
INSERT INTO ntr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kei yɛna me tobaale ŋon mɔɔ lese e, ŋon te mɛɛ gyae te me sia na gye ɔ dɔɔ. Maa mo me feliŋ do ɔ man, na waa yako debiise pou nyi debaŋ keŋ maa lɛɛ ba nyee nɛ te lii. ");
INSERT INTO ntr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ be gyae waa ta gyae kale yaa waa ta fae yeesa na abɔnterese na balaŋ ke nyii ya. ");
INSERT INTO ntr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Waa nyiŋ konɔɔ fa baŋ be nombia dana waraŋase nɛ, te ɔ be gyae waa yɛɛ baŋ bɔɔ taŋ doŋ mɔ nɛ akpanyaŋnyaŋ ya. Debaŋ kamasɛ na waa nyiŋ konɔɔ fa mena balaŋ kɛwɔ dinɔɔ, keŋ nyi ɔ be gyae waa yɛɛ kolo na ba wose keyɔkɔse wɔ ya mo kelii debaŋ keŋ baa nyiŋ nyeekelɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te debiise balaŋ pou baa mo be loo gyakaa ɔ dɔɔ bo.” ");
INSERT INTO ntr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wee daale ba moo walaŋ ŋon feliŋkum doo ɔ man, te ɔ sia be yɛlɛɛ te ɔ bɛɛ tale kolosi mɔ ya nɛ kɔŋ Yesu gyaŋ. Keŋte Yesu kyɔɔ e te ɔ kolosiwɔ te ɔ sia mɔ gyuusuwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nombia kɛŋa doo balaŋ baŋ pou nɔɔ te be bɔɔse dɔŋa nyiaa, “Na kei yɛna gyoo Defidi ɔ naanabii ŋon baa yaa?” ");
INSERT INTO ntr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mɔna Farasiitena baŋ kenyii nombia kɛŋa nɛ be yakowɔ nyiaa, “Feliŋkumɛɛ pou gyoo Bɛlisɛbu faa na balee kei doŋ te ɔ ne tale gegi feliŋkumɛɛ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mɔna Yesu gyeŋ kpene keŋ bɛɛ gyueŋ nɛ te ɔ yako wɔ nyiaa, “Tɛɛle kamasɛ keŋ ke man balaŋ de kpase ba wose kpookpoo bee yoo na dɔŋa na, tɛɛle kenaŋ be gyae ke de ya. Mena mɔ te donɔɔ yaa dekpaŋalaŋ daale man balaŋ de kpase ba wose kpookpoo bee yoo na dɔŋa na, dekpaŋalaŋ kenaŋ ne yɛlɛɛ bo. ");
INSERT INTO ntr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Akpaa nyi ba mo ɔbɔnsam doŋ gegi feliŋkumɛɛ nɛ, na keŋ nawolo baa nyi ɔ gyoori keŋ man balaŋ te kpase ba wose kpookpoo bee yoo na dɔŋa. Dekɔŋ mena na, sena te ɔ gyoori keŋ gyae ke tale seŋ? ");
INSERT INTO ntr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Akpaa nyi Bɛlisɛbu doŋ te mɛɛ mo gegi feliŋkumɛɛ na, amɔte doŋ yaa ɛ balaŋ baŋ mɔ na mo gegi feliŋkumɛɛ? Mena na ɛmɛɛ gbagba ɛ balaŋ ne gyae la baa bu ŋon fɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Te akpaa Wurubuarɛ doŋ te mɛɛ mo gegi feliŋkumɛɛ na, kenaŋ na ɛ wulaa gyeŋ nyi Wurubuarɛ gyoori keŋ taŋ kekɔŋ ɛ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Keŋte Yesu besewɔ yako wɔ nyiaa, “Sena te ŋolo waa tale gyu doŋte ŋolo dɛɛ na ɔ kaa mo ɔ kolo, keŋ nyi ɔ te di doŋte ŋon dɔɔ ya? Nyi akpaa ɔ di doŋte ŋon dɔɔ te ɔ bake e see nɛ, kenaŋ na waa tale kuu wa abɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Walaŋ kamasɛ ŋon ɔ be kpuɛ na maŋ ya nɛ na ɔ ne kɔla maŋ, te walaŋ kamasɛ ŋon mɔ ɔ bɛɛ kyɔ maŋ na dee yilaa balaŋ fa Wurubuarɛ ya nɛ, na ɔ ne yaasee wɔ bo. ");
INSERT INTO ntr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyiaa, Wurubuarɛ waa mo balaŋ nombiakumɛɛ na mmusuo nombia ŋan bɛɛ yako nɛ pou kyɛɛ wɔ, mɔna walaŋ ŋon waa mo mmusuo nombia gyakaa Wurubuarɛ feliŋ ŋon dɔɔ nɛ, Wurubuarɛ be gyae waa mo kyɛɛ e korakora ya. ");
INSERT INTO ntr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Walaŋ kamasɛ ŋon ɔ kolosi nombiikum tia maŋ Deniwalaŋ Bu ŋon nɛ, Wurubuarɛ waa mo kyɛɛ e. Mɔna walaŋ kamasɛ ŋon waa kolosi nombiikum tia Wurubuarɛ feliŋ ŋon nɛ, Wurubuarɛ be gyae waa mo kyɛɛ e gyɛŋ yaa kyoo ya. ");
INSERT INTO ntr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","N kɛɛ daŋ dɔɔ nideli te ke de nyiŋ doŋ nɛ, kɛɛ se bia kpaakpaa. Te akpaa n te kɛɛ ke dɔɔ nideli ya te kawee de kyaŋ ke na, kɛɛ se bia kumɛɛ bo. Nawolo nyi daŋ kamasɛ nɛ, ke bia te bɛɛ mo gyeŋ ke dinɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɛmɛɛ baŋ ɛ dana nombiakumɛɛ ŋgba doma nɛ, sena te ɛmɛɛ balaŋ kumɛɛ kɛwɔ ɛ ke tale kolosi nombia kpaakpaa? Nawolo nyi kpene kamasɛ keŋ be wulu walaŋ konɔɔ man nɛ, keŋ na lee la ɔ nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mena ke te denibalaŋ mɔ doo. Walaŋ kpaakpaate kamasɛ na lese abɔɔ kpaakpaa ŋan doo ɔ konɔɔ man nɛ wola, te walaŋkum kamasɛ mɔ na lese nombiakumɛɛ ŋan doo ɔ konɔɔ man nɛ wola. ");
INSERT INTO ntr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyiaa, nombiikum kamasɛ keŋ gyae ka lee walaŋ kamasɛ nɔɔman nɛ, wee keŋ Wurubuarɛ waa di balaŋ pou nombia tɛɛle kei dɔɔ nɛ, ɔtenate waa seŋ Wurubuarɛ siaman na waa tira ke nɔɔ fa e. ");
INSERT INTO ntr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nawolo nyi walaŋ kamasɛ nɔɔwoya te baa mo di ɔ nombia, na baa naa nyi ɔ dii deŋele, yaa ɔ dii fɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Botɔɔ te Farasiitena na mmaraa wolala baŋ baale yako Yesu nyiaa, “De Gbeŋgyoo, dɛɛ gyae n ke yɛɛ gyakoloŋ nombia wola daa.” ");
INSERT INTO ntr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛmɛɛ gyɛŋ wee kei balaŋ, ɛ yɛɛ nombiakumɛɛyɛɛrawɔ te ɛ be yee Wurubuarɛ ya. Ɛ ne gyae nyi maa yɛɛ gyakoloŋ nombia na ɛ kena, mɔna mɔɔ gyae maa yɛɛ gyakoloŋ nombii kamasɛ kpu na keŋ be kɔŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyona dɔɔ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mena keŋ Gyona be doo kpebii dinaa ŋon tɔɔman weeya atooro nelim na ka weese nɛ, mena te maŋ Deniwalaŋ Bu ŋon mɔ maa doo tɛɛle tɔɔman weeya atooro nelim na ka weese. ");
INSERT INTO ntr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wee keŋ Wurubuarɛ waa di balaŋ nombia nɛ, Niniwetena baa koro seŋ na baa bu gyɛŋ wee kei balaŋ fɔɔ, nawolo nyi debaŋ keŋ Gyona be kolosi Wurubuarɛ nombia ŋan fa wɔ nɛ, be kyɛɛkeewɔ lee be gbɛɛneŋ kumɛɛ man te be kɔŋawɔ Wurubuarɛ gyaŋ. Mɛɛ yako ŋon baa nyiaa, walaŋ ŋon ɔ kela Gyona nɛ kyaa kɛbo. ");
INSERT INTO ntr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mena mɔ te wee keŋ Wurubuarɛ waa di balaŋ nombia nɛ, Seba gyoo ŋon ɔ yɛɛ alo e te ɔ ba lee ata yenaŋ nɛ, waa koro seŋ na waa bu gyɛŋ wee kei balaŋ fɔɔ. Nawolo nyi ɔ ke nyii Solomɔn nyansa nombia ŋan nɛ, ɔ tɛɛwɔ leenaŋ tɛɛle ɔto kɔŋ kaa nyii ŋa. Mɛɛ yako ŋon baa nyiaa, walaŋ ŋon ɔ kela gyoo Solomɔn ŋonaŋ nɛ kyaa kɛbo.” ");
INSERT INTO ntr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Keŋte Yesu yako wɔ nyiaa, “Feliŋkum da lee walaŋ man nɛ ɔ ne tɛɛ kila kɛo tɛɛle awolɛɛ ɔ ne gyae dekyae, mɔna ɔ bee nyim ya. ");
INSERT INTO ntr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Akpaa ɔ te nyiŋ dekyae ya na ɔ ne yako ɔ wose nyiaa, maa bese gyu ma dekyae bene keŋ mɔɔ lee nɛ man. Akpaa ɔ kɔŋ kaa naa nyi ba te gbee botɔɔ desina ke nideli keŋ nyi ayimɛɛ kamasɛ be doo ya nɛ, ");
INSERT INTO ntr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ɔ na bese gyu ka mo feliŋkumɛɛ nyetooro, ŋan ŋe dana nombiakumɛɛ kela e nɛ kpu na ɔ wose na be kaa kyaa walaŋ ŋonaŋ man. Dekɔŋ mena na, walaŋ ŋonaŋ dinɔɔ na bese wɔlɛɛ kela ɔ kekyaa gyaŋgba keŋ. Mena ne gyae la ke kɔŋ gyɛŋ wee kei balaŋ kumɛɛ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ke gyakaa ɔ ne kolosi fa balaŋ baŋ nɛ, ɔ naa na ɔ naabia kɔŋawɔ kaa seŋ debɔɔ man keŋ bɛɛ gyae gbɛɛ baa kolosi na e. ");
INSERT INTO ntr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Botɔɔ te ŋolo yako Yesu nyiaa, “N naa na n naabia seŋɛɛ debɔɔ man bɛɛ gyae baa naa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Keŋte Yesu bɔɔse wɔ nyiaa, “Amɔte yɛna me naa, te bomɔ yɛna me naabia?” ");
INSERT INTO ntr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Keŋte ɔ tenee ɔ nyiŋmaa wola ɔ kaseela baŋ te ɔ yakowɔ nyiaa, “Kɛwɔ yɛna me naa na me naabia. ");
INSERT INTO ntr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nawolo nyi walaŋ kamasɛ ŋon ɔ ne yɛɛ me kya ŋon ɔ kyaa adido nɛ kegyaebii na, ŋon yɛna me naabu na me deesi na me naa.” ");
INSERT INTO ntr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mena wee kenaŋ nɛ, Yesu leewɔ dekpaŋalaŋ keŋ man ɔ kyaa nɛ gyu ke kyaa boo nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Keŋte balaŋ burum kaa yilaawɔ kilisi e. Mena dɔɔ ɔ gyoowɔ ke kyaa degbele man, na balaŋ baŋ mɔ pou seŋɛɛ dekeŋkeŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Botɔɔ te ɔ yako wɔ nombia burum aduya man nyiaa, “Wɔɔfarale ŋolo gyuuwɔ ke ŋmatee abɔɔ bia ŋgba amɔla nɛ ɔ wɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɔ kɛɛ ŋmatee abɔɔ bia ŋan nɛ, ŋaale yalawɔ wɔɔ keŋ gbɛɛneŋ man te gyebuse kaa tɔɔsee ŋa di. ");
INSERT INTO ntr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ŋaale mɔ yalawɔ kpanaŋse dɔɔ te ŋe tuuwɔ, mɔna tɛɛle ta boo botɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mena dɔɔ ɔga kaa seŋawɔ na, te ŋa botowɔ. Te keŋ ŋe te nyiŋ lila burum dɔɔ ya nɛ, ŋe popou yekeewɔ. ");
INSERT INTO ntr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bia ŋan ŋaale mɔ yalawɔ kpalamse man te ŋe tuuwɔ, te kpalamse ŋan mɔ tuuwɔ milii ŋa mena dɔɔ ŋe te nyiŋ ŋa wose ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Abɔɔ bia ŋan ŋaale mɔ yalawɔ tɛɛle kpaakpaa dɔɔ te ŋe tuuwɔ bee, te ŋa see bia burum. Ŋaale see sɔŋonoŋ (100), te ŋaale mɔ see sɔŋotooro (60), te ŋaale mɔ see saonakufu (30).” ");
INSERT INTO ntr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Keŋte Yesu yako wɔ nyiaa, “Ŋon ɔ dana deŋela waa nyii na, waa tei nideli.” ");
INSERT INTO ntr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Keŋte Yesu kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa bɔɔse e nyiaa, “Weera n ne kolosi fa balaŋ baŋ aduya man?” ");
INSERT INTO ntr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛmɛɛ dɔɔ Wurubuarɛ ta toro ya agyueŋse na ɛ ka gyeŋ nombia ŋan weesɛɛ lee ɔ gyoori keŋ wose man, mɔna na balaŋ pou ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nawolo nyi walaŋ kamasɛ ŋon ɔ gyeŋ Wurubuarɛ gyoori keŋ nombia aweeseŋ ŋan man na, ŋon te Wurubuarɛ waa toro wa agyueŋ na waa gyeŋ kpu. Te walaŋ kamasɛ ŋon ɔ ba gyeŋ kolo lee Wurubuarɛ gyoori keŋ nombia aweeseŋ ŋan man ya na, kyomii keŋ ɔ na gyueŋ nyi ɔ gyeŋ koraŋ nɛ, Wurubuarɛ waa lɛo ke lee ɔ nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Keŋ dɔɔ te mee kolosi fa wɔ aduya man yɛna nyiaa, Bɛɛ kɛo kɛo mɔna bɔɔ ne naa kolo ya. Bɛɛ tei tei, mɔna bɔɔ ne nyii nombia ŋenaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nombia akɔŋaŋ balaŋ kɛwɔ dɔɔ yela Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya nombia ŋan ɔ be yako see nɛ kɔŋawɔ ampaŋ. Yesaya yakowɔ nyiaa, “Balaŋ kɛwɔ baa tei tei, mɔna bɔɔ gyae baa nyii nombia ŋenaŋ man ya. Te baa kɛo kɛo, mɔna bɔɔ gyae baa naa kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nawolo nyi mena balaŋ kɛwɔ dana konɔɔyuŋ, te be dana deŋela tae. Ba te kyaŋ be sia wuu na bɔɔ nyiŋ naa ya. Nawolo nyi akpaa be sia ne naa te ba deŋela mɔ ne nyii na, keŋte baa nyii nombia ŋan man na baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa kɔŋ me gyaŋ, na maa mo be nombiakumɛɛ kyɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mɔna ɛmɛɛ dɔɔ ɛ te yɛɛ nyeebam, nawolo nyi ɛ sia ne naa te ɛ deŋela mɔ ne nyii. ");
INSERT INTO ntr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ampaŋ yaa mɛɛ yako nyiaa, Wurubuarɛ akpeŋkpeŋgyɔɔra na Wurubuarɛ balaŋ baŋ be gbɛɛneŋ tenɛɛ ɔ siaman baŋ bɔɔ kyaa kaalaŋ nɛ, gyaewɔ nyi baa naa kpene keŋ ɛ ne naa nɛ, mɔna ba te naa ya. Te be gyaewɔ nyi baa nyii kpene keŋ ɛ ne nyii nɛ, mɔna be te nyii ya.” ");
INSERT INTO ntr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Keŋte Yesu yako wɔ nyiaa, “Nɛnɛɛ ɛ tei na ɛ ke nyii wɔɔfarale ŋon dudu keŋ asɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Abɔɔ bia ŋan be yale wɔɔ keŋ gbɛɛneŋ man nɛ, seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ gyoori keŋ wose man nombia, te ɔbɔnsam ne kɔŋ kaa ŋmɛɛle ŋa lee be konɔɔse man, na bɔɔ nyiŋ nyii asɛɛ ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bia ŋan be yale kpanaŋse dɔɔ nɛ, seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan, te bɛɛ lɛɛ ŋa na gyoŋ debokenaŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mɔna keŋ Wurubuarɛ nombia ŋan te nyiŋ lila be man dɔɔ ya nɛ, bɔɔ ne tale seŋ keŋkeŋ kelii ɔto ya. Mena dɔɔ akpaa de kɔŋ nyi Wurubuarɛ nombia ŋan dɔɔ te bɛɛ naase wɔ diyem na, be ta bese be wɔle bileŋ. ");
INSERT INTO ntr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bia ŋan be yale kpalamse man nɛ, seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan, te tɛɛle kei dɔɔ nombia, na kɔba kegyae beiŋ, na tɛɛle kei dɔɔ abɔɔ akaŋ ŋan kegyae da gyoo be man nɛ, na bee yeli baa bee Kristo man ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Abɔɔ bia ŋan be yale tɛɛle kpaakpaa dɔɔ nɛ, seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan te bɛɛ lɛɛ ŋa do konɔɔ kpaakpaa man, te bɛɛ tela ŋa nideli te bɛɛ yɛɛ kakyeŋ di ŋe dɔɔ nɛ. Mena dɔɔ nombia ŋan ne yeli bɛɛ yɛɛ abɔɔ kpaakpaa ŋgba ŋan ŋɔɔ se bia sɔŋonoŋ (100), na sɔŋotooro (60), na saonakufu (30) nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Keŋte Yesu besewɔ gyɔ dudu wɔle fa wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba mena keŋ balee ŋolo be gyu ke ŋmatee abɔɔ bia kpaakpaa nyiŋan ɔ wɔɔman nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mɔna nelim balaŋ pou kedokii nɛ, ɔ kɔlare kɔŋawɔ kaa ŋmatee ŋalese kumɛɛ bom na abɔɔ bia ŋan te ɔ laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Abɔɔ bia ŋan ketu se bia nɛ, te ŋalese kumɛɛ ŋan mɔ lese ŋa wose debɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Botɔɔ te wɔɔte ŋon tewulɛɛ kɔŋawɔ kaa bɔɔse e nyiaa, “De gbeŋgyoo, na abɔɔ bia kpaakpaa nyiŋan te n ŋmateewɔ n wɔɔ keŋ man yee? Te aleŋ yaa ŋalese kumɛɛ kɛŋa leewɔ?” ");
INSERT INTO ntr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Keŋte balee ŋon yakowɔ nyiaa, “Me kɔlare ŋolo kaa yɛɛ laa mena nɛ.” Botɔɔ te ɔ tewulɛɛ baŋ bɔɔse e nyiaa, “N ne gyae nyi dee gyu ke kulii ŋalese kumɛɛ ŋan?” ");
INSERT INTO ntr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Keŋte balee ŋon tiranɔɔ fa wɔ nyiaa, “Koa ɛ yela ŋe ka seŋ, na mena ya nɛ, akpaa ɛ gyu ɛ ne kulii ŋalese kumɛɛ ŋan nɛ, ɛ te kɛɛ nideli ya na ɛ ka kulii abɔɔ bia kpaakpaa ŋan mɔ kpu na ŋa. ");
INSERT INTO ntr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mena dɔɔ ɛ yela ŋe popou ka seŋ kelii kekɛrɛɛ tɛɛ. Debaŋ kenaŋ nɛ, maa yako baŋ baa kɛrɛɛ ŋa nɛ nyiaa, ɛ taŋgbɛɛ kulii ŋalese kumɛɛ ŋan pɛ, na ɛ ke bake ŋa kaboese man na ɛ ka too ŋa. Kenaŋ wɔle na ɛ ke yilaa abɔɔ bia kpaakpaa ŋan pou ka do me kpeese man.” ");
INSERT INTO ntr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Keŋte Yesu besewɔ gyɔ dudu wɔle fa wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba daŋ daale bii peperee keŋ ke yɛɛ ŋgba kpeli bii, keŋ balee ŋolo ba mo ke duu ɔ wɔɔman nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Daŋbii kei yɛna bii peperee daasebia pou man. Mɔna nyi akpaa ke da bee na, kɛɛ bee bese daŋ dinaa keŋ nyi gyebuse ne kɔŋ kaa loo ba asaase do ke tombia man.” ");
INSERT INTO ntr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Keŋte Yesu besewɔ gyɔ dudu fa wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba tee keŋ alo ŋolo ba mo kyakale bodobodo biliŋ tasa dinaa man, kaboena biliŋ keŋ pou korowɔ wuku nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aduya man te Yesu kolosiwɔ fa balaŋ dikpii keŋ pou. Ɔ te kolosi nombii daale fa ŋolo keŋ ɔ te gyɔ dudu ya. ");
INSERT INTO ntr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kei yele la Wurubuarɛ nombia ŋan ɔ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Yesaya dɔɔ yako see nɛ kɔŋawɔ ampaŋ. Ɔ yakowɔ nyiaa, “Aduya man te maa kolosi fa wɔ na maa yako wɔ nombia aweeseŋ ŋan bɔɔ gyeŋ ya, leenaŋ tɛɛle kewalaŋ tɛɛ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Keŋte Yesu lɔɔ balaŋ dikpii keŋ gbɛɛ te ɔ gyuuwɔ dekpaŋalaŋ man. Ɔ kaseela baŋ kɔŋawɔ ɔ gyaŋ te be yako e nyiaa, “Wola daa dudu keŋ n be gyɔɔ lee ŋalese kumɛɛ ŋan ŋɔɔ tuu wɔɔ keŋ man nɛ asɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Walaŋ ŋon ɔ be duu abɔɔ bia kpaakpaa ŋan nɛ yɛna maŋ Deniwalaŋ Bu ŋon, ");
INSERT INTO ntr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","wɔɔ keŋ yɛna tɛɛle kei pou. Abɔɔ bia kpaakpaa ŋan yɛna Wurubuarɛ gyoori keŋ man bia baŋ. Ŋalese kumɛɛ ŋan yɛna ɔbɔnsam ŋon bia. ");
INSERT INTO ntr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te walaŋkum ŋon ɔ be duu ŋalese kumɛɛ ŋan yɛna ɔbɔnsam ŋon. Kekɛrɛɛ tɛɛ keŋ yɛna debaŋ ɔtomante keŋ. Baŋ baa kɛrɛɛ nɛ yɛna Wurubuarɛ kpilala baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mena keŋ bɔɔ yilaa ŋalese kumɛɛ ŋan te bɔɔ too ŋa nɛ, mena ne gyae la ke kɔŋ debaŋ ɔtomante keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Maŋ Deniwalaŋ Bu ŋon maa kpila me kpilala lee adido na be kaa yilaa kpene kamasɛ keŋ ne yeli walaŋ ne yɛɛ dukum nɛ, na nombiakumɛɛyɛɛra pou lee me gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wurubuarɛ kpilala baŋ baa fuŋ balaŋ kumɛɛ baŋ do boalaŋ degyapaa keŋ man. Botɔɔ te baa fae yeesa na baa tao be kela. ");
INSERT INTO ntr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mɔna baŋ be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nɛ, baa ŋalakee ŋgba weese nɛ be kya ŋon gyoori keŋ man. Baŋ be dana deŋela anenyiiŋ dei na, baa tei nideli.” ");
INSERT INTO ntr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Keŋte Yesu besewɔ yako wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba kolo kpaakpaate keŋ ke dana koya doŋ te bɔɔ mo weese tɛɛle daale man nɛ. Balee ŋolo ke gyu kena ke nɛ, te ɔ desina ke weese nideli. Ke yɛɛ e gyoŋ gbaa mena dɔɔ ɔ gyuuwɔ ka mo kpene kamasɛ keŋ ɔ dana nɛ yɔɔ, te ɔ moowɔ ke lɛɛ tɛɛle kenaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu besewɔ yako wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba kebudiiri ŋon ɔ dɔŋ ɔ ne gyae kegyaŋase kpaakpaa nyiŋan waa lɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɔ ke gyu ke nyiŋ kegyaŋa kpaakpaate nɛ, ɔ gyuuwɔ ke yɔɔ kpene kamasɛ keŋ ɔ dana nɛ, te ɔ moowɔ ke lɛɛ ke.” ");
INSERT INTO ntr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu besewɔ yako wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba asawu lɔɔra baŋ bɔɔ fuŋ ba asawu do loŋ man te bɔɔ kyaŋ kpebia kpookpoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ba kena nyi asawu keŋ te wulu nɛ, be wɔŋee ke kɔŋ dekeŋkeŋ dɔɔ. Be tisiwɔ kyaa te be tɔɔsee kpebia kpaakpaa nyibaŋ do be doŋase man, te be fuŋii akumɛɛ baŋ pou leki. ");
INSERT INTO ntr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mena ne gyae la ke kɔŋ wee ɔtomante keŋ man. Wurubuarɛ kpilala baŋ baa kɔŋ kaa lese balaŋ kumɛɛ baŋ lee balaŋ kpaakpaa baŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na baa fuŋ balaŋ kumɛɛ baŋ do boalaŋ keŋ ke bɛɛ yem ya nɛ man. Botɔɔ te baa fae yeesa na baa tao be kela.” ");
INSERT INTO ntr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Keŋte Yesu bɔɔse wɔ nyiaa, “Ɛ nyii nombia kɛŋa pou asɛɛ?” Te be sɛɛwɔ nyi “Ayi.” ");
INSERT INTO ntr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Keŋte Yesu yako wɔ nyiaa, “Nombii kei nawolo baa nyiaa, mmaraa wolale kamasɛ ŋon ɔ be kasee Wurubuarɛ gyoori keŋ nombia gyeŋ ŋa nɛ, ɔ yɛɛ ŋgba dekpaŋalaŋ kegyia ŋon ɔ ne kyaa lese wa abɔɔ wɔlɛɛ na benɛɛ lee wa abɔɔ dɛɛsee man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu ke gyɔ aduya kɛŋa taŋ nɛ, ɔ leewɔ botɔɔ laŋ. ");
INSERT INTO ntr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ɔ ke gyu ka gyoo ɔ dɛɛ nɛ, ɔ gyuuwɔ ka wola wɔ Wurubuarɛ nombia bɔ ɔsom deni man, te ɔ kawola keŋ doo be popou nɔɔ, keŋte be bɔɔse dɔŋa nyiaa, “Aleŋ yaa ɔ nyiŋa nombia kagyeŋ kei, na doŋ keŋ ɔ na mo yɛɛ gyakoloŋ nombia na nombia dinaana kɛŋa lee?” ");
INSERT INTO ntr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na kapenta ŋon bu yaa yee? Na ɔ naa yɛna Mɛɛre yee, na ɔ naabia yɛna Gyemisi na Gyosɛfo na Simɔn na Gyuda yee? ");
INSERT INTO ntr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na daa na ɔ desina kyaa la kɛbo yee? Aleŋ kitii yaa ɔ nyiŋa mena doŋ kei lee? ");
INSERT INTO ntr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mena dɔɔ ba te lɛɛ e ya. Keŋte Yesu yako wɔ nyiaa, “Balaŋ ne bu Wurubuarɛ dekpeŋkpeŋgyɔɔre yenaŋ kamasɛ, mɔna ŋon gbagba ɔ donɔɔ man balaŋ, na ɔ dekpaŋalaŋmantena bee buu na e ya.” ");
INSERT INTO ntr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te keŋ ba te lɛɛ Yesu di dɔɔ ya nɛ, ɔ te yɛɛ gyakoloŋ nombia burum ɔ dɛɛ botɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mena debaŋ kenaŋ man te gyoo Herode ŋon ɔ ne kɛɛ Galelia tɛɛle dɔɔ nɛ, nyii Yesu wose man nombia. ");
INSERT INTO ntr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Keŋte ɔ yako ɔ tewulɛɛ nyiaa, gyae ke yɛɛ Gyɔn Wurubuarɛ loŋsɔɔre ŋon bese la foŋ lee yeŋ man kɔŋ nɛ. Mena dɔɔ te ɔ ne tale yɛɛ gyakoloŋ nombia nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nawolo nyi gyoo Herode gbagba yele la be kyaŋa Gyɔn te be bake e, te ba moo e ke tɔ deni lee ɔ kegyia Filipo wɛɛle Herodia dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kpene keŋ dɔɔ gyoo Herode be yɛɛ mena yɛna nyi, Gyɔn yako e nyi gbɛɛ be doo nyi waa mo ɔ kegyia Filipo wɛɛle Herodia yala ya. ");
INSERT INTO ntr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gyoo Herode gyaewɔ nyi nafɔ waa ko Gyɔn mɔna ɔ ne yee Gyudatena baŋ, nawolo nyi bɛɛ lɛɛ Gyɔn di nyi ɔ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e. ");
INSERT INTO ntr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wee daale gyoo Herode kee di ɔ kalolawee nɛ, Herodia bu alebu kɔŋawɔ kaa sɔe balaŋ baŋ pou siaman, te yɛɛ gyoo Herode kyeo. ");
INSERT INTO ntr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mena dɔɔ gyoo Herode kaŋa ntam yako alebu ŋon nyiaa, “Kpene kamasɛ keŋ n gyae nyi maa fa neŋ na, yako na maa fa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Keŋte alebu ŋon ɔ naa feefuwɔ do ɔ bu nyi waa yako nyiaa, “Mɛɛ gyae n ke kara Gyɔn Wurubuarɛ loŋsɔɔre nyee do tasa taŋtaŋalaŋ man fa maŋ debokeiman.” ");
INSERT INTO ntr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nombia ŋan takaa gyoo ŋon, mɔna ntam keŋ ɔ be kam na balaŋ baŋ bɔɔ yilaa botɔɔ dɔɔ nɛ, ɔ yela be yɛɛ alebu ŋon kegyaebii fa e. ");
INSERT INTO ntr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mena dɔɔ ɔ yela be gyuuwɔ ke kara Gyɔn nyee deni keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Keŋte ba moo Gyɔn nyee keŋ do tasa taŋtaŋalaŋ man kɔna alebu ŋon, te ɔ moo ke gyina ɔ naa. ");
INSERT INTO ntr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kenaŋ wɔle te Gyɔn kaseela gyuuwɔ ka mo Gyɔn woo ŋon ke wuu, te be gyuuwɔ ke yako Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ke nyii Gyɔn Wurubuarɛ loŋsɔɔre yeŋ nɛ, ɔ gyoowɔ debgele man laŋ yenaŋ daale gyu ke kyaa waageŋ kooŋ. Balaŋ dikpii keŋ ke nyii nyi ɔ te lam nɛ, te ba leewɔ be donɔɔse man, mo na be nawɔɔ sila e. ");
INSERT INTO ntr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu ke tisi lee degbele keŋ man, te ɔ kena balaŋ dikpii keŋ nɛ, be nombia yɛɛ e waraŋase te ɔ kyɔɔ kaweesetena baŋ pou bɔɔ sila wɔ gyu nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ke lii balinɔɔ nɛ, Yesu kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, “De Gbeŋgyoo, tɛɛ ne yuu te kɛbo mɔ yɛɛ ŋale nsana ke. Lɔ balaŋ baŋ gbɛɛ, na baa gyu akuraase ŋan benaa nɛ man na be kaa gyae kolo lɛɛ di.” ");
INSERT INTO ntr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Keŋte Yesu yako wɔ nyiaa, “Tekaboena nyi baa ta ya. Ɛmɛɛ gbagba ɛ gyae kolo fa wɔ na baa di.” ");
INSERT INTO ntr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Botɔɔ te ɔ kaseela baŋ yako e nyiaa, “Bodobodose abiliŋ anoŋ na kpebia bala pɛ te de dana.” ");
INSERT INTO ntr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Keŋte Yesu yako wɔ nyiaa, “Ɛ mo ŋa kɔna maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Te ɔ yela balaŋ baŋ tisiwɔ kyakee tɛɛle man. Keŋte Yesu moo bodobodose anoŋ na kpebia bala baŋ, te ɔ gyinaa ɔ nyee adido te ɔ fanewɔ do Wurubuarɛ nɔɔ, te ɔ kɛrɛɛ ŋa te ɔ moo ŋa fa ɔ kpilala baŋ, te baŋ mɔ moowɔ kpɛlɛɛ balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Balaŋ baŋ pou diiwɔ baa, te be tɔɔsee weenɛɛ buruburu akaŋ ŋan na, be nyiŋa doŋase kufu ala (12). ");
INSERT INTO ntr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Balaŋ baŋ bɔɔ di weenɛɛ ŋan nɛ, be yaanɔɔle gyae ke yɛɛ ŋgba baala kakpoŋse banoŋ (5000) nɛ. Ba te kala ala na bia kpu ya. ");
INSERT INTO ntr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Debokenaŋ man te Yesu yela ɔ kaseela baŋ gyoowɔ degbele man kyaŋ gbɛɛ gyu boo keŋ diŋgyiŋ na waa nyiŋ lɔ balaŋ baŋ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yesu ke lɔ balaŋ baŋ gbɛɛ taŋ nɛ, ɔ gyuuwɔ bula dɔɔ waageŋ ɔ kaa fane. Kelii balinɔɔ nɛ, na Yesu waageŋ kaa la botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Debaŋ kenaŋ na degbele keŋ te lii lem, na feliŋ dinaa daale mɔ ne gyɔɔ degbele keŋ wosi loŋ keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tɛɛ kɛɛ bee kena nɛ, Yesu tɛɛwɔ loŋ keŋ dɔɔ ɔ ne gyu ɔ kaseela baŋ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ɔ kaseela baŋ kena e ɔ dɔŋɛɛ loŋ keŋ dɔɔ ɔ ne kɔŋ nɛ, be wɔe lɔɔ wɔ gbaa. Keŋte be kpa “Ɔ yɛɛ woo e,” te be fae yeesa nawolo nyi gyakoloŋ te kyaŋ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Debokenaŋ man te Yesu kolosiwɔ fa wɔ nyi, “Ɛ nyiŋ konɔɔ, ɛ na yee ya, maŋ e.” ");
INSERT INTO ntr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Botɔɔ te Pita yako e nyiaa, “Me Gbeŋgyoo, akpaa nyaŋ e na, yela maa ta loŋ keŋ dɔɔ kɔŋ n gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Keŋte Yesu yako e nyiaa, “Kɔŋ” te Pita leewɔ degbele keŋ man ta loŋ keŋ dɔɔ ɔ ne gyu Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mɔna Pita kena mena keŋ feliŋ keŋ ne gyɔɔ loŋ keŋ dɔɔ nɛ, gyakoloŋ gyoo e te ɔ fiasɛɛ ɔ na gyoo loŋ keŋ man. Keŋte ɔ fae yeesa nyiaa, “Me Gbeŋgyoo, lɛɛ maŋ!” ");
INSERT INTO ntr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Debokenaŋ man te Yesu tenee ɔ nyiŋmaa kyaŋ e te ɔ yako e nyiaa, “Baale, n kelɛɛdi ta boo ya. Weera dɔɔ te n lɛɛ maŋ aŋmaareŋ n konɔɔ man?” ");
INSERT INTO ntr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesu na Pita ka gyeŋ gyoo degbele keŋ man nɛ, te feliŋ keŋ tinaa kegyɔ yela. ");
INSERT INTO ntr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Botɔɔ te baŋ be doo degbele keŋ man nɛ, korowɔ buŋ Yesu nawɔɔtɛɛ te be yako e nyiaa, “Nyaŋ yɛna Wurubuarɛ bu ŋon ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Be ka toŋ boo keŋ nɛ, be gyuuwɔ kelii tɛɛle keŋ bɛɛ baake ke Genesareti nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Balaŋ baŋ be kyaa tɛɛle kenaŋ dɔɔ ka gyeŋ nyi Yesu ŋonaŋ nɛ, be kpiliiwɔ gyu ke yako donɔɔse ŋan pou kyaa botɔɔ yenaŋ nɛ. Mena dɔɔ balaŋ moo be kaweesetena pou kɔŋ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Keŋte be waase e nyi waa yela kaweesetena baŋ ka mo be nyiŋmaase tina ɔ kegba nɔɔbii paŋpaŋ bo gba. Te baŋ pou bɔɔ tina ɔ kegba keŋ nɛ, wose yɛɛ wɔ doŋ. ");
INSERT INTO ntr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Keŋte Farasiitena na Gyudatena mmaraa wolala baŋ baale korowɔ lee Gyerusalɛm donɔɔ man gyu ke bɔɔse Yesu nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Weera dɔɔ te n kaseela baŋ bee di da beneŋ amanberɛse dɔɔ ya? Nawolo nyi bɔɔ ne faafo be nyiŋmaase ŋgba mena keŋ da beneŋ amanberɛse nawolo nɛ pɛte baa di ya!” ");
INSERT INTO ntr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Weera dɔɔ te ɛmɛɛ mɔ, lee ɛ beneŋ amanberɛse dɔɔ te ɛ bee di Wurubuarɛ mmaraase dɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nawolo nyi Wurubuarɛ yakowɔ nyiaa, “Bu n kya na n naa, te nyaŋ ŋon n falaa n kya yaa n naa na, kaboena nyi baa ko neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mɔna ɛmɛɛ ne yako nyiaa, “Akpaa ŋolo de yako ɔ kya yaa ɔ naa nyi, ‘Kpene keŋ nafɔ me dana maa fa neŋ nɛ, yɛɛ Wurubuarɛ wui.’ ");
INSERT INTO ntr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mena dɔɔ be kaboena nyi ɔtenate waa mo kpene kenaŋ fa ɔ lolala ya. Nnɛ na ɛ ne yako baa nyi ɔtenate na bu ɔ kya na ɔ naa na waa yɛɛ kpene keŋ kaboena nyi waa yɛɛ fa wɔ nɛ ya. Kei nawolo baa nyi lee ɛ beneŋ amanberɛse dɔɔ, ɛ te bɛɛ kpene keŋ Wurubuarɛ kpa yaa yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɛmɛɛ baŋ ɛ na beo ɛ wose, Wurubuarɛ nombia ŋan ɔ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Yesaya dɔɔ yako see lee ɛ wose man nɛ yɛɛ ampaŋ. Ɔ yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Balaŋ kɛwɔ na mo be nɔɔ bo yako nyi bee bu maŋ, mɔna be konɔɔse man na, bɔɔ na mo maŋ yɛɛ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bɛɛ som maŋ bo yakaa, nawolo nyi mmaraase ŋan denibalaŋ gbagba be kyaa yɛɛ nɛ, ŋan te bɛɛ mo wola balaŋ beo wɔ nyi ŋe yɛɛ maŋ Wurubuarɛ mmaraase ŋa.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Keŋte Yesu besewɔ baake balaŋ baŋ pou kɔŋ ɔ gyaŋ te ɔ yako wɔ nyiaa, “Ɛ popou ɛ tei me gyaŋ, na ɛ ke nyii nombia kɛŋa man nideli. ");
INSERT INTO ntr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na kpene keŋ na gyoo walaŋ nɔɔman nɛ ne yɛɛ na e ayimɛɛ ya, mɔna kpene keŋ na lee ɔ nɔɔman nɛ, keŋ ne yɛɛ na e ayimɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Keŋte Yesu kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa bɔɔse nyiaa, “Ŋgba n gyeŋ nyi debaŋ keŋ Farasiitena baŋ be nyii nombia ŋan na, te yɛɛ wɔ gyoŋ ya?” ");
INSERT INTO ntr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Daŋ kamasɛ keŋ ka te yɛɛ nyi me kya ŋon ɔ kyaa adido nɛ duu na ke ya na, waa kulu ke na ke lila pou ke leki. ");
INSERT INTO ntr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ɛ tina Farasiitena benaŋ yela botɔɔ, be yɛɛ ŋgba siayɛlɛɛsatena baŋ bɛɛ wola siayɛlɛɛsatena gbɛɛ nɛ. Akpaa siayɛlɛɛsate na wola siayɛlɛɛsate gbɛɛ nɛ, be bala pou baa kaa yala bɔɔ man bo.” ");
INSERT INTO ntr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Botɔɔ te Pita yako e nyiaa, “De Gbeŋgyoo, lese dudu kei asɛɛ fa daa.” ");
INSERT INTO ntr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Keŋte Yesu bɔɔse ɔ kaseela baŋ nyiaa, “Keŋ dɔɔ ɛmɛɛ mɔ nyeeya ta yem? ");
INSERT INTO ntr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Keŋ dɔɔ ɛ ba gyeŋ nyi kpene kamasɛ keŋ da gyoo walaŋ nɔɔman na, ne gyu ka gyoo ɔ dubulu man na ke ta bese lee ɔ wose man yee? ");
INSERT INTO ntr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mɔna nombii kamasɛ keŋ na lee walaŋ nɔɔman nɛ, na lee bo ɔ konɔɔ man, te keŋ ne yɛɛ na e ayimɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nawolo nyi walaŋ konɔɔ man te nombiakumɛɛ ŋgba, balaŋ kako, na yale kewɔlɛɛ na kafoŋ na ŋmɛɛleŋ na balaŋ nɔɔ kekɛrɛɛ na balaŋ yela kewɔlɛɛ na lee. ");
INSERT INTO ntr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mena abɔɔ kɛŋa ne yɛɛ na walaŋ ayimɛɛ, mɔna akpaa ŋolo te faafo ɔ nyiŋmaase pɛte waa di ya nɛ, ke bɛɛ yɛɛ e ayimɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ka lee botɔɔ nɛ, ɔ wɔŋa ɔ wose lee botɔɔ gyu Tae na Sidɔn donɔɔse ŋan yenaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Keŋte Kaanan alo ŋolo leewɔ botɔɔ yenaŋ kɔŋ Yesu gyaŋ kaa wii fa e nyiaa, “Me Gbeŋgyoo, gyoo Defidi ɔ naanabii, wii me waraŋase! Feliŋkum doo me bu alebubii man, te kɛɛ naase e diyem nideli.” ");
INSERT INTO ntr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mɔna Yesu te yako daale ya. Mena dɔɔ ɔ kaseela baŋ waase e nyiaa, “Lɔ alo ŋon gbɛɛ na waa ta, nawolo nyi ɔ ne fae yeesa tɔ daa deŋela.” ");
INSERT INTO ntr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Keŋte Yesu yako alo ŋon nyiaa, “Iseraetena baŋ bɔɔ yoo Wurubuarɛ gbɛɛ nɛ baageŋ gyaŋ te Wurubuarɛ kpila maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mɔna alo ŋon kɔŋawɔ kaa buŋ Yesu nawɔɔ tɛɛ waase e nyiaa, “Me Gbeŋgyoo, lɛɛ maŋ!” ");
INSERT INTO ntr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Keŋte Yesu yako alo ŋon nyiaa, “Tekaboena nyi baa mo bia weenɛɛ fa babaase ya.” ");
INSERT INTO ntr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Botɔɔ te alo ŋon mɔ sɛɛwɔ nyiaa, “Ayi, me Gbeŋgyoo, doo mena, mɔna babaase baa tale fiu weenɛɛ ŋan be gbeŋgyoo ne dii te ŋɛɛ yale tɛɛle man nɛ di.” ");
INSERT INTO ntr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Keŋte Yesu yako alo ŋon nyiaa, “Alo n kelɛɛdi boe. Kpene keŋ n ne gyae nɛ, dɛɛkɔŋ mena fa neŋ.” Debokenaŋ man te ɔ bu ŋon kawee taŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ka lee botɔɔ nɛ, te ɔ tɛɛwɔ na Galelia boo keŋ nɔɔ nɔɔ. Keŋte ɔ gyuuwɔ ka gyeŋ bulabii daale gyu ke kyaa ke dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Balaŋ burum moo be kaweesetena kɔŋ ɔ gyaŋ. Kaweese ŋgba baŋ be nawɔɔ ba yekee, na baŋ be sia be yɛlɛɛ na ɔtakasese na omumuuse na kaweese kpookpoo nɛ. Keŋte Yesu kyɔɔ be popou. ");
INSERT INTO ntr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Balaŋ baŋ kena nyi baŋ be nawɔɔ ba yekee ne tɛɛ, te omumuuse ne kolosi te ɔtakasese wose ne yɛɛ wɔ doŋ, te siayɛlɛɛsatena sia ne naa nɛ, doo be nɔɔ. Keŋte ba lese Iseraetena Wurubuarɛ ŋon yele. ");
INSERT INTO ntr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Keŋte Yesu baake ɔ kaseela baŋ kɔŋ ɔ gyaŋ te ɔ yako wɔ nyiaa, “Balaŋ kɛwɔ nombia dana maŋ waraŋase, nawolo nyi gyɛŋ weeya kpaakpaa atooro yaa ŋgba be kyaa me gyaŋ te be te dii ta kolo ya nɛ. Mɔɔ ne gyae maa lɔ wɔ gbɛɛ na tanam ya, nawolo nyi be sia de kaa biri wɔ gbɛɛnaa man.” ");
INSERT INTO ntr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Botɔɔ te ɔ kaseela baŋ bɔɔse e nyiaa, “Aleŋ yaa dee nyiŋ weenɛɛ fa balaŋ burum kɛwɔ ŋale nsana kɛbo?” ");
INSERT INTO ntr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Keŋte Yesu bɔɔse wɔ nyiaa, “Bodobodose aŋmoŋ te ɛ dana?” Te be tiranɔɔ fa e nyi, “Bodobodose nyetooro na kpebia buruburu akalansɛɛ baale te de dana.” ");
INSERT INTO ntr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Keŋte Yesu yela balaŋ baŋ tisiwɔ kyakee tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɔ moo bodobodose nyetooro ŋan, na kpebia baŋ te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ kɛrɛɛ ŋa mo fa ɔ kaseela baŋ. Keŋte ɔ kaseela baŋ mɔ moo ŋa kpɛlɛɛ balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Balaŋ baŋ pou diiwɔ baa. Te ɔ kaseela baŋ tɔɔsee buruburu akaŋ ŋan na, be nyiŋa doŋase nyetooro. ");
INSERT INTO ntr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Balaŋ baŋ bɔɔ di weenɛɛ ŋan nɛ, be yaanɔɔle yɛɛ baala kakpoŋse banaara (4000). Ba te kala ala na bia kpu ya. ");
INSERT INTO ntr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu ke lɔ balaŋ baŋ gbɛɛ taŋ nɛ, ɔ gyoowɔ degbele man te ɔ gyuu tɛɛle keŋ bɛɛ baake ke nyi Magadan nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wee daale nɛ, Farasiitena na Sadukiitena kɔŋawɔ Yesu gyaŋ kaa teese e ɔ nɔɔman nyi waa yɛɛ gyakoloŋ nombia wola wɔ, na kawola nyi ɔ lee Wurubuarɛ gyaŋ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “De lii balinɔɔ te ŋɔma yasɛɛ na ɛ ne tale naa yako nyi, tɛɛ de naa na weese waa gyɔ. ");
INSERT INTO ntr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te nebo mɔ na, ɛ ne tale kɛɛ ŋɔma dinɔɔ yako nyi gyɛŋ ɔga waa ŋɛɛ. Ɛ ne tale kɛɛ ŋɔma na ɛ kawola kpene keŋ gyae ke kɔŋ. Mɔna nombia ŋan ne yɛɛ debaŋ kei man nɛ, ɛ bɛɛ tale wola ŋe man ya. ");
INSERT INTO ntr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɛmɛɛ gyɛŋ wee kei balaŋ, ɛ yɛɛ balaŋ kumɛɛwɔ te ɛ bee yee Wurubuarɛ ya. Ɛ ne gyae nyi maa yɛɛ gyakoloŋ nombia ɛ kena, mɔna mɔɔ gyae maa yɛɛ gyakoloŋ nombia kamasɛ wola ŋon kpu na ŋan be kɔŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyona dɔɔ nɛ ya.” Keŋte Yesu leewɔ be gyaŋ laŋ tina wɔ yela. ");
INSERT INTO ntr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu na ɔ kaseela ka toŋ gyu boo keŋ diŋgyiŋ nɛ, ɔ kaseela baŋ wolee bodobodo ka mo bo. ");
INSERT INTO ntr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Keŋte Yesu faree wɔ nyiaa, ɛ kɛɛ ɛ wose man nideli lee Farasiitena na Sadukiitena wose man. Nawolo nyi be dinɔɔ yɛɛ ŋgba tee keŋ bɛɛ mo do bodobodo man te kɛɛ koro nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mena dɔɔ ɔ kaseela baŋ bɔɔse dɔŋa nyiaa, “Keŋ de ta mo bodobodo kɔŋ dɔɔ ya te ɔ ne yako mena nombia kɛŋa yaa?” ");
INSERT INTO ntr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na Yesu ta gyeŋ kpene keŋ bee kolosi na dɔŋa nɛ te ɔ yako wɔ nyiaa, “Ɛ kelɛɛdi ta boo ya. Weera dɔɔ te ɛ ne kolosi nyi ɛ ta mo bodobodo tela ya? ");
INSERT INTO ntr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mena dɔɔ ɛ sɛɛ ɛ te nyii ta me nombia man yee? Ɛ bɛɛ tɔɔse bodobodose anoŋ ŋan mɔɔ kɛrɛɛ fa balaŋ kakpoŋse banoŋ, na ŋan bɔɔ dii kaase te ɛ be tɔɔsee wulu doŋase nɛ yee? ");
INSERT INTO ntr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yaa ɛ bɛɛ tɔɔse bodobodose nyetooro ŋan balaŋ kakpoŋse banaara be dii, na ŋan bɔɔ dii kaase te ɛ be tɔɔsee wulu doŋase nɛ yee? ");
INSERT INTO ntr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Weera dɔɔ te ɛ ta gyem nyi na bodobodo wose man nombia yaa mee kolosi fa ŋon ya? Mɔna ɛ kɛɛ ɛ wose man nideli lee Farasiitena na Sadukiitena wose man. Be dinɔɔ yɛɛ ŋgba tee keŋ bɛɛ mo do bodobodo man te kɛɛ koro nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Botɔɔ te ɔ kaseela baŋ gyeŋawɔ nyi, na tee keŋ ne yeli bodobodo na koro nɛ yaa ɔ ne yako wɔ nyi baa kɛɛ ba wose man nideli na ke ya. Mɔna Farasiitena na Sadukiitena nombia ŋan bɛɛ wolo nɛ yaa ɔ ne yako wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu na ɔ kaseela baŋ ka gyoo Kaesaria Filipi tɛɛle man nɛ, ɔ bɔɔse ɔ kaseela baŋ nyiaa, “Balaŋ ne kolosi ma wose man nombia na be kpa maŋ Deniwalaŋ Bu ŋon yɛna amɔ?” ");
INSERT INTO ntr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Keŋte ɔ kaseela baŋ tiranɔɔ nyiaa, “Balaŋ baale kpa nyaŋ yɛna Gyɔn Wurubuarɛ loŋsɔɔre ŋon. Baale mɔ kpa nyaŋ yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre Elia, te baale mɔ kpa nyaŋ yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyeremia, yaa Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ man ŋolo.” ");
INSERT INTO ntr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Ɛmɛɛ mɔ de? Ɛ kpa maŋ Deniwalaŋ Bu ŋon yɛna amɔ?” ");
INSERT INTO ntr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Botɔɔ te Simɔn Pita tiranɔɔ nyiaa, “Nyaŋ yɛna Kristo, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. Wurubuarɛ ŋon ɔ kyaa kekpaakekpaa nɛ Bu.” ");
INSERT INTO ntr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Keŋte Yesu yako e nyiaa, “Gyona bu Simɔn, nyaŋ na nyeebam, nawolo nyi na deniwalaŋ lese na nombia kɛŋa wola neŋ ya, mɔna me kya ŋon ɔ kyaa adido nɛ lese na ŋa wola neŋ. ");
INSERT INTO ntr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mena dɔɔ mɛɛ yako neŋ nyiaa, nyaŋ yɛna Pita, te n yele kenaŋ asɛɛ yɛna nyi boe. Nyaŋ boe kei dɔɔ te maa baake me balaŋ pou yilaa. Te yeŋ gba koraŋ be gyae ke tale di be dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Maa mo Wurubuarɛ gyoori keŋ safowaase do n nyiŋmaa man. Kpene kamasɛ keŋ nyaŋ ke gyɔ ke dowoe tɛɛle kei dɔɔ nɛ, baa gyɔ ke dowoe adido, te kpene kamasɛ keŋ nyaŋ ke booli ke tɛɛle kei dɔɔ nɛ, baa booli ke adido mɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Keŋte Yesu faree ɔ kaseela baŋ nyi, be na yako walaŋ kamasɛ nyi ŋon yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lee debaŋ kenaŋ pou nɛ, Yesu fiasɛɛ ɔ na lese nombia ŋan asɛɛ fa ɔ kaseela baŋ nyiaa, “Kaboena nyi maa gyu Gyerusalɛm donɔɔ man, na me kaa naa diyem nideli Gyudatena kegyiise na Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ nyiŋmaa man. Baa ko maŋ, mɔna weeya atoorote keŋ man na, Wurubuarɛ waa gyuusu maŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Botɔɔ te Pita moo Yesu lee yenaŋ te ɔ tɔɔ e nyi, “Me Gbeŋgyoo, na yako mena ya. Wurubuarɛ dɛɛ mo kɛŋa gyu lem. Kɛŋa na kɔŋ n dɔɔ korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Botɔɔ te Yesu gɛɛsewɔ kɛɛ Pita te ɔ yako e nyiaa, “Ɔbɔnsam, ta lee me gyaŋ! N ne gyae n ke tɔ maŋ gbɛɛ. Nawolo nyi na Wurubuarɛ kegyaebii te n na gyueŋ ya, mɔna denibalaŋ kegyaebii te n na gyueŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Akpaa ŋolo ne gyae waa sila maŋ na, ɔ na yɛɛ kpene keŋ ŋon gbagba ne gyae ya, mɔna waa mo ɔ ɔpaŋdaŋ keŋ seele, na waa sila maŋ wee kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nawolo nyi walaŋ kamasɛ ŋon ɔ ne gyae waa lɛɛ ŋon gbagba nyeedoŋ na, ke gyae ka lee ɔ nyiŋmaa man. Mɔna walaŋ kamasɛ ŋon ɔ nyeedoŋ da lee ɔ nyiŋmaa man lee maŋ Yesu na me nombia dɔɔ nɛ, waa bese nyiŋ ke. ");
INSERT INTO ntr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Akpaa ŋolo de nyiŋ tɛɛle kei dɔɔ abɔɔ pou te ɔ nyeedoŋ da lee ɔ nyiŋmaa man na, woŋ tɔnɔɔ te waa nyiŋ? Yaa woŋ te walaŋ waa tale mo kyɛɛkee na ɔ nyeedoŋ? ");
INSERT INTO ntr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maŋ Deniwalaŋ Bu ŋon na me kpilala dɛɛ lee adido kɔŋ me kya Wurubuarɛ gyoorobiiri man, na me kaa tɔ walaŋ kamasɛ kom lee ɔ tom keŋ ɔ be yɛɛ nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, baale seŋɛɛ ɛ man kɛbo keŋ bɔɔ gyae baa yeŋ ya, kelii debaŋ keŋ maŋ Deniwalaŋ Bu ŋon maa lese ma wose wola me gyoorobiiri man.” ");
INSERT INTO ntr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Weeya looro wɔle nɛ, Yesu moo Pita na Gyemisi na ŋon Gyemisi ɔ naabu Gyɔn kpu na ɔ wose te be gyuuwɔ bula dinaa daale dɔɔ baageŋ. ");
INSERT INTO ntr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Be ka seŋ botɔɔ nɛ, karatetee dokoloŋ te Yesu wose kyɛɛkeewɔ be siaman. Na ɔ sia gbɛɛ ne ŋalakee ŋgba weese nɛ, te wa abɔɔ ŋan ɔ doona nɛ bese abɔɔ wolomɛɛ futututu na ŋɛɛ ŋalakee polɛpolɛpolɛ. ");
INSERT INTO ntr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Debokenaŋ man te Mosesi na Elia kaa bɛɛwɔ lee be dɔɔ, te be kolosiwɔ na Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Keŋte Pita yako Yesu nyiaa, “De Gbeŋgyoo, dei ŋgba daa mɔ be kɔŋ kɛbo nɛ. Nyi akpaa n ne gyae na, yela dɛɛ baŋ kefɛɛse atooro kɛbo. N wui daale, Mosesi wui daale te Elia mɔ wui daale.” ");
INSERT INTO ntr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ke gyakaa ɔ ne kolosi nɛ, te ŋɔma ŋɛlɛɛŋɛlɛɛ ŋaale kaa wuuwɔ be dɔɔ. Keŋte be nyii nɔɔwoya ŋaale lee ŋɔma ŋan man nyiaa, “Kei yɛna me bu ŋon mɛɛ gyae e lee me konɔɔ man te ɔ na gyoo me sia, ɛ nyii e.” ");
INSERT INTO ntr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ɔ kaseela baŋ ke nyii nɔɔwoya kɛŋa nɛ, gyakoloŋ gyoo wɔ te be tisiwɔ buŋii tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Keŋte Yesu kaa mo ɔ nyiŋmaa tina wɔ te ɔ yako wɔ nyiaa, “Ɛ koro, ɛ na yee ya.” ");
INSERT INTO ntr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Be ka koro gyina be sia nɛ, ba te naa ŋolo kpu na Yesu ya. ");
INSERT INTO ntr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Be ke tisi lee bula keŋ dɔɔ bɛɛ kɔŋ nɛ Yesu tɔɔ wɔ kiiŋ nyiaa, “Ɛ na yako walaŋ na walaŋ kpene keŋ ɛ be naa nɛ ya, kelii debaŋ keŋ Wurubuarɛ waa gyuusu maŋ Deniwalaŋ Bu ŋon lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Keŋte ɔ kaseela baŋ bɔɔse e nyiaa, “Weera dɔɔ te Gyudatena mmaraa wolala baŋ ne yako nyi, kaboena nyi Elia waa taŋgbɛɛ kɔŋ pɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ ke kɔŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Keŋte Yesu yako wɔ nyiaa, “Ke doo mena nyi Elia waa taŋgbɛɛ nyeelɛɛre ŋon kɔŋ na ɔ kaa desina kpene kamasɛ see ŋgba ŋa kedoobii nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mɔna mɛɛ yako ŋon baa nyi Elia taŋ wulaa kɔŋ laŋ mɔna balaŋ ta gyeŋ e ya, te be yɛɛ e kpene kamasɛ keŋ bɛɛ gyae. Mena mɔ te maŋ Deniwalaŋ Bu ŋon maa naa diyem be nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Botɔɔ te ɔ kaseela baŋ gyeŋawɔ nyiaa, Gyɔn Wurubuarɛ loŋsɔɔre ŋon wose man nombia yaa ɔ ne yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ba ke kɔŋ kaa gyoo balaŋ burum baŋ man nɛ, balee ŋolo kaa tisiwɔ buŋ Yesu nawɔɔtɛɛ, ");
INSERT INTO ntr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","te ɔ yako e nyiaa, “Me Gbeŋgyoo, wii me bu kei waraŋase fa maŋ. Ɔ na wee keleuleuse, te ɔ ne naa diyem nideli mɔ. Ne kyaa kuu e lɔ boalaŋ yaa loŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma moo e kɔŋ n kaseela baŋ gyaŋ, mɔna ba te tale kyɔ e ya.” ");
INSERT INTO ntr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Botɔɔ te Yesu yako wɔ nyiaa, “Ao! Ɛmɛɛ gyɛŋ balaŋ baŋ ɛ bɛɛ lɛɛ maŋ di ya, te ɛ yɛɛ balaŋ kumɛɛwɔ. Weeya aŋmoŋ te kaboena nyi maa kyaa ɛ gyaŋ, na maa nyiŋ konɔɔ fa ŋon?” Keŋte ɔ yako balee ŋon nyiaa, “Mo n bu ŋon kɔna maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Keŋte Yesu fae feliŋkum keŋ te ka leewɔ bu ŋon man, te ɔ kawee taŋawɔ debokenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kenaŋ wɔle te Yesu kaseela baŋ gyuuwɔ ɔ gyaŋ, te be baake e lee yenaŋ bɔɔse e nyiaa, “Weera dɔɔ te daa te tale gegi feliŋkum keŋ lee bu ŋon man ya?” ");
INSERT INTO ntr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Nawolo nyi ɛ kelɛɛdi ta boo ya. Mɛɛ yako ŋon ɛ ke nyii nyiaa, nyi akpaa ɛ kelɛɛdi yɛɛ peperee ŋgba kefaabii koraŋ nɛ, nafɔ ɛ ke tale yako bula kei nyiaa, ‘Kulu lee kɛbo ke yala nnɛ’ te ke gyae ke kɔŋ mena. Te kolo be kyaa keŋ nyi ɛ be gyae ɛ ke tale yɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mɔna mena feliŋkumɛɛ kɛŋa dinɔɔ dɔɔ nɛ, kefane na nɔɔkebake kaageŋ te n ke tale mo gegi ŋa. ");
INSERT INTO ntr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Debaŋ keŋ be popou be kɔŋ kaa gyaŋee Galelia tɛɛle man nɛ, Yesu yako ɔ kaseela baŋ nyiaa, “Baa lese maŋ Deniwalaŋ Bu ŋon fa balaŋ, ");
INSERT INTO ntr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na baa ko maŋ, mɔna weeya atoorote keŋ nɛ, Wurubuarɛ waa gyuusu maŋ lee yeŋ man.” Botɔɔ te dekɔkɔrɔkɔɔ kyaŋa ɔ kaseela baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na ɔ kaseela baŋ ke kɔŋ kaa gyoo Kapanum donɔɔ man nɛ, balaŋ baŋ bɛɛ lɛɛ lempoo Wurubuarɛ ɔsom deni dinaa keŋ man nɛ, kɔŋawɔ kaa bɔɔse Pita nyiaa, “Ɛ gbeŋgyoo ŋon bɛɛ tɔ Wurubuarɛ ɔsom deni dinaa lempoo keŋ yee?” ");
INSERT INTO ntr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Keŋte Pita tiranɔɔ fa wɔ nyiaa, ɔ ne tɔɔ. Pita ke kɔŋ kaa gyoo dekpaŋalaŋ man pɛ nɛ, Yesu taŋgbɛɛ la kolosi na e te ɔ bɔɔse e nyiaa, “Simɔn, sena yɛna nya agyueŋ? Balaŋ bomɔ gyaŋ te tɛɛle kei dɔɔ gyooneŋ ne lɛɛ lempoo lee? Donɔɔsetena gyaŋ yaa ŋɔɔla gyaŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Te Pita tiranɔɔ nyiaa, “Ŋɔɔla gyaŋ te bɛɛ lɛɛ.” Keŋte Yesu yako e nyiaa, “Akpaa mena na donɔɔsetena te nyiŋ ba wose. ");
INSERT INTO ntr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mɔna keŋ dɔɔ ne gyae nyi daa na wɔ ke yala dɔŋa dɔɔ ya nɛ, mo n darawaa na n ke gyu boo man ke lɔ. Kpebii gyaŋgbate ŋon n ke kyaŋ nɛ, n wola ɔ nɔɔ na n kena kɔba keŋ gyae ka yee daa na neŋ wui lempoo keŋ ketɔ. Lese ke na n ka mo gyina wɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mena debaŋ kenaŋ man nɛ, Yesu kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa bɔɔse e nyiaa, “Amɔte yɛna walaŋ kegyia Wurubuarɛ gyoori keŋ man?” ");
INSERT INTO ntr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Keŋte Yesu baake biikyaabii ŋolo kaa seŋ be siaman, ");
INSERT INTO ntr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","te ɔ yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, akpaa ɛ te kyɛɛkee ɛ dinɔɔ na ɛ ke yɔkɔse ɛ wose yɛɛ ŋgba bia ya nɛ, ɛ be gyae ɛ ka gyoo Wurubuarɛ gyoori keŋ man ya.” ");
INSERT INTO ntr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mena dɔɔ walaŋ kamasɛ ŋon ɔ yɔkɔse ɔ wose ŋgba biikyaabii kei nɛ, ŋon yɛna walaŋ kegyia Wurubuarɛ gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te walaŋ kamasɛ ŋon ɔ lɛɛ biikyaabii kei dinɔɔ ma yele man na, maŋ yaa ɔ lɛɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mɔna walaŋ kamasɛ ŋon ɔ yeli bia buruburu kɛwɔ baŋ bɔɔ lɛɛ maŋ di nɛ man ŋolo de yɛɛ dukum nɛ, kenaŋ na nyi akpaa ba mo boe dinaa dinaa kpaŋ ɔ wɔŋe man, te be fuŋ e do ɛpo man na dei kela. ");
INSERT INTO ntr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ɛmɛɛ balaŋ baŋ ɛ kyaa tɛɛle kei dɔɔ nɛ ɛ laako lee abɔɔ ŋan ne yeli balaŋ ne yɛɛ dukum nɛ dɔɔ. Kaboena nyi mena abɔɔ kɛŋa dɛɛ kɔŋ, mɔna nyaŋ walaŋ ŋon ŋe gyae ke ta n dɔɔ kɔŋ nɛ nyaa laako. ");
INSERT INTO ntr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nyi akpaa n nyiŋmaa yaa n nae ne yele la te n ne yɛɛ dukum na kara ke leki. Nawolo nyi, dei nyi nya lee kadeŋ na n ka gyoo Wurubuarɛ gyoori keŋ man, kela nyi baa mo neŋ nyiŋmaase ala yaa nawɔɔ ala ka do boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te akpaa nyi n sibii ne yele la te n ne yɛɛ dukum na kulu ke leki. Dei nyi nya mo sibii dokoloŋ gyoo Wurubuarɛ gyoori keŋ man, kela nyi baa mo neŋ na n sia ala ka do boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Keŋte Yesu besewɔ yako wɔ nyiaa, ɛ kɛɛ nideli nyi ɛ be kɛɛ balaŋ kɛwɔ baŋ bɔɔ lɛɛ maŋ di te bɔɔ yɔkɔse ba wose ŋgba bia nɛ nyi be man ŋolo yɛɛ walaŋ yakaate e ya. Mɛɛ yako ŋon baa ɛ ke nyii nyiaa, mena balaŋ kɛwɔ dana Wurubuarɛ kpilala baŋ ba seŋɛɛ me kya Wurubuarɛ ŋon ɔ kyaa adido nɛ siaman, bɛɛ fane fa wɔ debaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maŋ Deniwalaŋ Bu ŋon kɔŋae me kaa lɛɛ baŋ bɔɔ yoo Wurubuarɛ gbɛɛ man nɛ nyee. ");
INSERT INTO ntr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Keŋte Yesu bɔɔse wɔ nyiaa, sena te ɛ na gyueŋ lee nombia kɛŋa man? Akpaa ŋolo dana namense sɔŋonoŋ (100) te be man dokoloŋ da yoo na woŋ te ɔ ne yɛɛ? Ɔ be gyae waa tina sɔŋonaara na kufu kadaale (99) baŋ yela bula dɔɔ botɔɔ, na waa ta kɛo ŋon ɔ ba yoo nɛ kaboena waa naa e yee? ");
INSERT INTO ntr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ampaŋ yaa mɛɛ yako ŋon nyi akpaa ɔ naa e na, ɔ sia na gye ɔ dɔɔ nideli kela sɔŋonaara na kufu kadaale baŋ be ta yoo ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mena mɔ te ɛ kya ŋon ɔ kyaa adido nɛ, bɛɛ gyae nyi balaŋ baŋ bɔɔ lɛɛ maŋ di nɛ, be man ŋolo dɛɛ yo ya. ");
INSERT INTO ntr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Keŋte Yesu besewɔ yako wɔ nyiaa, akpaa n dɔɔ Kristo baale de yɛɛ neŋ nombiikum na, gyu ɔ gyaŋ na n kaa bɔɔse e. Mɔna yela ka ke yɛɛ ɛmɛɛ na e ɛ bala nombia. Akpaa ɔ nyii neŋ na, n te tale baa besena e kɔŋ gbɛɛ kpaakpaate dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mɔna nyi akpaa ɔ te nyii neŋ ya na, mo Kristo baale dokoloŋ yaa balaŋ bala kpu na n wose na ɛ ke gyu ɔ gyaŋ. Kei gyae ke yela n ke nyiŋ adansɛɛtena bala yaa batooro nombia ŋenaŋ man, ŋgba mena keŋ Wurubuarɛ nombia ne yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akpaa ɔ bɛɛ ɔ te nyii ŋon ya nɛ, kenaŋ na baake e n tebia Kristotena dikpii keŋ gyaŋ. Te akpaa ɔ bɛɛ ɔ te nyii baŋ mɔ ya nɛ, kenaŋ na kɛɛ e nyi ɔ yɛɛ walaŋ ŋon ɔ ba gyeŋ Wurubuarɛ ya, yaa ɔ yɛɛ dukumyɛɛre e. ");
INSERT INTO ntr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, kpene kamasɛ keŋ ɛ gyɔ ke dowoe tɛɛle kei dɔɔ nɛ, na ba te gyɔ ke dowoe adido, te kpene kamasɛ keŋ ɛ booli ke tɛɛle kei dɔɔ nɛ, na ba te booli ke adido mɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Te mɛɛ yako ŋon baa bela nyiaa, kpene kamasɛ keŋ ɛ man balaŋ bala de yɛɛ nɔɔdokoloŋ seŋ ke dɔɔ fane tɛɛle kei dɔɔ na, me kya ŋon ɔ kyaa adido nɛ waa yɛɛ ke fa ŋon.” ");
INSERT INTO ntr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nawolo nyi botɔɔ keŋ balaŋ bala yaa balaŋ batooro de gyaŋee ma yele man na, me kpuɛ na wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Keŋte Pita kɔŋawɔ Yesu gyaŋ kaa bɔɔse e nyiaa, “Me Gbeŋgyoo, betaboŋmon te me dɔɔ de yɛɛ nombiikum me dɔɔ na te maa mo kyɛɛ e? Maa mo kyɛɛ e betabonyetooro?” ");
INSERT INTO ntr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Keŋte Yesu tiranɔɔ fa e nyiaa, “Koa, na betabonyetooro ya, mɔna betabosɔŋotooro na kufu akpeŋ nyetooro (70 x 7).” ");
INSERT INTO ntr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Keŋte ɔ yako wɔ nyiaa, “Nnɛ te Wurubuarɛ gyoori keŋ doo. Ke yɛɛ ŋgba gyoo ŋon ɔ ne gyae nyi ŋon na ɔ tewulɛɛ ke kyaa, na baa kɛɛ koma ŋan be dana e nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Be ka beta fiasɛɛ bɛɛ gyoo ŋe man nɛ, te ba moo tobaale ŋon ɔ dana e kom kɔba na nsendee ya nɛ kɔna e. ");
INSERT INTO ntr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Keŋ tobaale ŋon te nyiŋ kɔba keŋ waa tɔ ya dɔɔ nɛ, ɔ gbeŋgyoo ŋon yako wɔ nyi baa mo ŋon na ɔ wɛɛle na ɔ bia na wa abɔɔ ŋan pou ɔ dana nɛ ke yɔɔ, na baa mo kaa tɔ kom keŋ. ");
INSERT INTO ntr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Keŋte ɔ tobaale ŋon tisiwɔ buŋ ɔ nawɔɔ tɛɛ waase e nyiaa, ‘Nyiŋ konɔɔ fa maŋ, maa tɔ neŋ kom keŋ pou.’ ");
INSERT INTO ntr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Botɔɔ te ɔ nombia yɛɛ ɔ gbeŋgyoo ŋon waraŋase, te ɔ moo kom keŋ pou kyɛɛ e te ɔ tina e yela nyi waa ta. ");
INSERT INTO ntr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mɔna mena tobaale ŋonaŋ ka lee botɔɔ nɛ, ɔ ke gyaŋee na ɔ dɔɔ ŋolo ŋon ɔ dana e kom bii daale nɛ. Botɔɔ te tobaale ŋon lɔɔwɔ kyaŋ ɔ dɔɔ ŋon wɔŋe man te ɔ yako e nyiaa, ‘Tɔ maŋ ma kom keŋ pou n dana maŋ nɛ?’ ");
INSERT INTO ntr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Keŋte ɔ dɔɔ ŋon mɔ tisiwɔ buŋ ɔ nawɔɔ tɛɛ waase e nyiaa, ‘Me dɔɔ nyiŋ konɔɔ fa maŋ maa tɔ neŋ n kom keŋ pou.’ ");
INSERT INTO ntr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mɔna tobaale ŋon bɛe, te ɔ yela ba moo ɔ dɔɔ ŋon ketɔ deni nyi waa doo botɔɔ, kelii debaŋ keŋ waa tɔ e ɔ kom keŋ pou. ");
INSERT INTO ntr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tewulɛɛ akaŋ baŋ kena mena nɛ takaa wɔ nideli, keŋte be gyuuwɔ ke tɔlɛɛ nombia ŋan pou fa be gbeŋgyoo ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Botɔɔ te be gbeŋgyoo ŋon baake tobaale ŋon te ɔ yako e nyiaa, ‘N yɛɛ walaŋkum ŋolo e. Nyaŋ waase maŋ te ma moo n kom keŋ n dana maŋ nɛ pou kyɛɛ neŋ. ");
INSERT INTO ntr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Woŋ dɔɔ te nyaŋ mɔ n te wii n dɔɔ ŋon waraŋase, ŋgba mena keŋ maŋ be wii neŋ nɛ ya?’ ");
INSERT INTO ntr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mena dɔɔ ɔ gbeŋgyoo ŋon gyeŋa baŋ, te ɔ yela ba moo tobaale ŋon ketɔ deni na waa naa diyem kelii debaŋ keŋ, ŋon mɔ waa tɔ ɔ koma ŋan ɔ dana e nɛ pou. ");
INSERT INTO ntr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mena dɔɔ ɛmɛɛ baŋ ɛ ta mo ɛ tebia nombiakumɛɛ kyɛɛ wɔ lee ɛ konɔɔse man ya nɛ, mena te me kya ŋon ɔ kyaa adido nɛ waa yɛɛ ŋon.” ");
INSERT INTO ntr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu kekolosi nombia kɛŋa pou taŋ nɛ, ɔ leewɔ Galelia tɛɛle man gyu Gyudia tɛɛle man, Gyɔɔdan boo keŋ diŋgyiŋ. ");
INSERT INTO ntr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Balaŋ burum sila e gyu botɔɔ te ɔ kyɔɔ wɔ be kaweese pou. ");
INSERT INTO ntr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Keŋte Farasiitena baale kɔŋawɔ be kaa teese ɔ nɔɔman te be bɔɔse e nyiaa, “Da mmaraa ne fa daa gbɛɛ nyi ŋolo waa tale bɛɛ ɔ wɛɛle lee nombii kamasɛ dɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ te kala ta Wurubuarɛ nombia aŋmaraseŋ see ŋan nyi, lee kewalaŋ keŋ na, Wurubuarɛ yɛɛ alo na baale bo, ");
INSERT INTO ntr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","te ɔ yakowɔ nyiaa, ‘Lee kei dɔɔ nɛ baale waa tina ɔ kya na ɔ naa yela, na waa mo ɔ wose mataa na ɔ wɛɛle, na be balaŋ bala ka bese walaŋ dokoloŋ yee?’ ");
INSERT INTO ntr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mena dɔɔ be ta tekaa yɛɛ balaŋ bala bela ya, mɔna be ta bese walaŋ dokoloŋ. Mena dɔɔ kpene keŋ Wurubuarɛ ba mo bom yɛɛ ke dokoloŋ nɛ, ŋolo na ŋolo na kpase ke man ya.” ");
INSERT INTO ntr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Keŋte Farasiitena baŋ bɔɔse Yesu nyiaa, “Nyi akpaa mena te doo na, weera dɔɔ te de naana Mosesi yɛɛ mmaraa see nyi, baale waa tale ŋmarase yale kebɛɛ tɔne fa ɔ wɛɛle na waa bɛɛ e?” ");
INSERT INTO ntr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ konɔɔyuŋ dɔɔ te de naana Mosesi fa ŋon mena gbɛɛ kenaŋ. Mɔna lee kewalaŋ keŋ na, be doo mena ya. ");
INSERT INTO ntr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mena dɔɔ mɛɛ yako ŋon baa nyiaa, nyi akpaa na alo lee ɔ baale wɔle bo ya, te ɔ baale de bɛɛ e gyu ke yala alo wɔle nɛ, Wurubuarɛ siaman na ɔtenate gyae ŋolo wɛɛle baa.” ");
INSERT INTO ntr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Keŋte Yesu kaseela baŋ yako e nyiaa, “Nyi akpaa nnɛ te yale wose man nombia doo na, kenaŋ na walaŋ te yale koraŋ ya na dei.” ");
INSERT INTO ntr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Keŋte Yesu yako wɔ nyiaa, “Nombia ŋan mɛɛ yako ŋon nɛ, na walaŋ kamasɛ ne gyae la waa tale lɛɛ ŋa do ya, gyisɛ balaŋ baŋ Wurubuarɛ ba mo mena bɛrɛɛ kenaŋ boele wɔ nɛ baageŋ. ");
INSERT INTO ntr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Balaŋ baale kyaa keŋ nyi bɔɔ gyae baa tale yala ala ya, nawolo nyi mena te ba lola wɔ. Balaŋ baale mɔ dɔɔ, balaŋ yɛɛ na wɔ keŋ nyi bɔɔ gyae baa tale yala ala ya. Balaŋ baale mɔ dɔɔ, Wurubuarɛ gyoori keŋ dɔɔ te baŋ gbagba bɛɛwɔ nyi bɔɔ yale ya. Walaŋ kamasɛ ŋon waa tale lɛɛ nombia kɛŋa do na, waa lɛɛ ŋa do.” ");
INSERT INTO ntr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Keŋte balaŋ baale moo bia kɔŋ Yesu gyaŋ nyi waa mo ɔ nyiŋmaa gyakaa be dɔɔ na waa fane fa wɔ. Mɔna ɔ kaseela baŋ kena mena nɛ, be ŋmanyaŋ balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kena mena nɛ ɔ yako wɔ nyiaa, “Ɛ yela bia baŋ ke kɔŋ me gyaŋ. Ɛ na tɔ wɔ gbɛɛ ya, nawolo nyi Wurubuarɛ gyoori keŋ yɛɛ balaŋ baŋ bɛɛ yɔkɔse ba wose ŋgba bia kɛwɔ dinɔɔ nɛ wui.” ");
INSERT INTO ntr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu ka mo ɔ nyiŋmaa gyakaa bia baŋ dɔɔ taŋ nɛ, te ɔ leewɔ botɔɔ laŋ. ");
INSERT INTO ntr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wee daale nɛ tobaale ŋolo kaa bɔɔse Yesu nyiaa, “De Gbeŋgyoo, woŋ deeli yaa maa yɛɛ na maa nyiŋ nyeedoŋ kekpaa keŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Botɔɔ te Yesu bɔɔse e nyiaa, “Weera te n ne bɔɔse maŋ lee deeli keyɛɛ wose man. Wurubuarɛ waageŋ dei la. Mena dɔɔ nyi akpaa n ne gyae n ke nyiŋ nyeedoŋ kekpaa keŋ nɛ, kenaŋ na kaboena nyi nya di Wurubuarɛ mmaraase ŋan dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Botɔɔ te tobaale ŋon bɔɔse Yesu nyiaa, “Mmaraase ŋemɔ?” Keŋte Yesu tiranɔɔ fa e nyiaa, “Na ko walaŋ ya, na lee n wɛɛle yaa n baale wɔle ya, na ŋmɛɛle ya, na kara n dɔɔ nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bu n kya na n naa, na n ke gyae n tebia ŋgba mena keŋ n ne gyae nyaŋ gbagba n wose nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Keŋte tobaale ŋon yakowɔ nyiaa, “Me wulaa mee di mmaraase kɛŋa pou dɔɔ. Woŋ kaa la nyi maa yɛɛ bela?” ");
INSERT INTO ntr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Botɔɔ te Yesu yako e nyiaa, “Nyi akpaa n ne gyae n ke de kelii ɔto na, gyu ke yɔɔ nya abɔɔ ŋan pou n dana nɛ, na n ka mo kɔba keŋ kpɛlɛɛ ayematena na n ke kɔŋ kaa sila maŋ. N yɛɛ mena na, n ke nyiŋ abɔɔ kpaakpaa see n wose Wurubuarɛ gyaŋ adido.” ");
INSERT INTO ntr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tobaale ŋon ke nyii nombia kɛŋa nɛ, ɔ moo waraŋase lee botɔɔ nawolo nyi ɔ dana kɔba na nsendee ya. ");
INSERT INTO ntr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, gyae ke yɛɛ doŋ fa baŋ be dana kɔba nɛ nyi baa gyoo Wurubuarɛ gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mɛɛ yako ŋon bela nyiaa, gyae ke yɛɛ doŋ fa baŋ be dana kɔba nɛ nyi baa gyoo Wurubuarɛ gyoori keŋ man, kela nyi kurumɔɔ ka gyoo ŋarale bɔɔ man lee.” ");
INSERT INTO ntr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu kaseela baŋ ke nyii nombia kɛŋa nɛ doo be nɔɔ te be bɔɔse e nyiaa, “Nyi nnɛ te doo na, amɔte ne gyae la waa nyiŋ nyeekelɛɛ baa?” ");
INSERT INTO ntr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Keŋte Yesu kɛɛ wɔ te ɔ yako wɔ nyiaa, “Denibalaŋ gyaŋ na ŋolo be tale yɛɛ nombii kei ya, mɔna kpene kamasɛ be kyaa keŋ Wurubuarɛ be tale yɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Botɔɔ te Pita bɔɔse Yesu nyiaa, “De Gbeŋgyoo! Daa dɔɔ de te tina kpene kamasɛ keŋ de dana nɛ yela, te de dɔŋɛɛ de silana neŋ. Woŋ yaa dee nyiŋ baa?” ");
INSERT INTO ntr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Keŋte Yesu yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, debaŋ keŋ kpene kamasɛ de kaa bese wɔle te maŋ Deniwalaŋ Bu ŋon de kyaa me gyooro gbeli keŋ dɔɔ me gyoorobiiri man nɛ, ɛmɛɛ baŋ ɛ be sila maŋ nɛ ɛ ke kyaa gyooro gbelɛɛ kufu ala dɔɔ, na ɛ ke di Iseraetena akpaŋalaŋse kufu ala ŋan balaŋ nombia. ");
INSERT INTO ntr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Te ɛ man walaŋ kamasɛ ŋon ɔ be tina ɔ dekpaŋalaŋ yaa ɔ naabia yaa ɔ deesina, yaa ɔ kya yaa ɔ naa yaa ɔ bia yaa ɔ tɛɛlese yela lee maŋ dɔɔ nɛ, waa bese nyiŋ ŋa akpeŋ sɔŋonoŋ (100) kpu, na waa bese nyiŋ nyeedoŋ kekpaa keŋ mɔ. ");
INSERT INTO ntr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mɔna balaŋ burum baŋ be yɛɛ siamantenawɔ nɛ, baa kaa bese wɔle nyibaŋ, na balaŋ burum baŋ be yɛɛ wɔle nyibaŋwɔ nɛ kaa bese siamantena.” ");
INSERT INTO ntr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Keŋte Yesu gyɔɔ dudu lese nombia ŋan ɔ be yako nɛ man wola wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba wɔɔfarale ŋon, ɔ ba koro nebo nebo fuu gyu ɔ ne gyae paasetena na be kaa yɛɛ tom ɔ wɔɔman nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Balee ŋon na paasetena baŋ pou ke sɛɛ wee dokoloŋ koya dɔɔ nɛ, ɔ moo wɔ gyu ɔ wɔɔ keŋ man nyi ba ke yɛɛ tom. ");
INSERT INTO ntr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kegyɔ debaŋ kadaale nɛ, ɔ leewɔ gyu abɔntere man te ɔ kenaa tewulɛɛ baale mɔ seŋɛɛ yakaa bɔɔ ne yɛɛ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Keŋte ɔ yako wɔ nyiaa ‘Ɛmɛɛ mɔ ɛ gyu me wɔɔ keŋ man ke yɛɛ tom. Maa tɔ ŋon kom keŋ kaboena nyi maa tɔ ŋon nɛ.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mena dɔɔ baŋ mɔ gyuuwɔ ɔ wɔɔ keŋ man. Weese ka seŋ dɛɛ, na ɔ ke gɛɛse nɛ, ɔ besewɔ ka mo balaŋ gyu ɔ wɔɔ keŋ man bela. ");
INSERT INTO ntr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ke lii balinɔɔ weese ŋgba debaŋ anoŋ nɛ, ɔ besewɔ gyu kena balaŋ baale mɔ seŋɛɛ yakaa. Keŋte ɔ bɔɔse wɔ nyiaa, “Weera te gyɛŋ pou ɛ seŋɛɛ kɛbo yakaa ɛ bɛɛ yɛɛ kolo ya?” ");
INSERT INTO ntr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Keŋte balaŋ baŋ tiranɔɔ nyiaa, “Nawolo nyi ŋolo te fa daa tom dɛɛ yɛɛ ya.” Botɔɔ te balee ŋon yako wɔ nyiaa, “Kenaŋ na ɛmɛɛ mɔ ɛ gyu ke yɛɛ tom me wɔɔman.” ");
INSERT INTO ntr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ke lii balinɔɔ nɛ, wɔɔte ŋon yako ɔ tewulɛɛ baŋ man kegyia ŋon nyiaa, “Baake paasetena baŋ na n ke tɔ wɔ kom. Taŋgbɛɛ tɔ baŋ bɔɔ dɔɔ wɔle gyu wɔɔ keŋ man nɛ kom, pɛna n kaa tɔ baŋ bɔɔ taŋgbɛɛ gyu nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Balaŋ baŋ bɔɔ dɔɔ wɔle gyu wɔɔ keŋ man balinɔɔ weese nɛ kɔŋawɔ, te be tɔɔ wɔ kom ŋgba mena keŋ wɔɔte ŋon be yako nyi waa tɔ gyaŋgba nyibaŋ baŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mena dɔɔ baŋ bɔɔ taŋgbɛɛ gyu wɔɔ keŋ man lee nebo nebo nɛ kɔŋawɔ na, ba agyueŋ yɛna nyi baŋ baa nyiŋ kela be tebia baŋ. Mɔna be tɔɔ baŋ mɔ man walaŋ kamasɛ kom ŋgba wɔle nyibaŋ baŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba ke lɛɛ be kɔbase taŋ nɛ, be fiasɛɛ bɛɛ kolosi tia wɔɔte ŋon nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Balaŋ kɛwɔ baŋ bɔɔ kɔŋ wɔle wɔle kei nɛ, yɛɛ tom bo debaŋ dokoloŋ kooŋ. Mɔna daa dɔɔ da seŋawɔ weese kpalala kei man leenaŋ nebo kaa lii balinɔɔ kei. Kenaŋ wɔle koraŋ na, n besewɔ tɔ de popou kom kyɛɛkyɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Botɔɔ te wɔɔte ŋon tiranɔɔ fa be man ŋolo nyiaa, “Me gyoo, me ta ŋere neŋ do ya na. Ŋgba daa na neŋ kolosiwɔ see nyi n yɛɛ tom wee dibiliŋ na, nnɛ te maa tɔ neŋ kom. ");
INSERT INTO ntr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mo n kɔba na n ke ta gyu n dɛɛ. Maŋ gbagba gyae la nyi maa tɔ baŋ bɔɔ dɔɔ wɔle kɔŋ nɛ kom ŋgba mena keŋ mɔɔ tɔ neŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Me dana gbɛɛ keŋ nyi maa mo maŋ gbagba me kɔba yɛɛ kpene keŋ mɛɛ gyae. Keŋ me dana wɔe dɔɔ te na wee neŋ nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Keŋte Yesu yako wɔ nyiaa, “Mena mɔ te wɔle nyibaŋ baa kaa bese gyaŋgba nyibaŋ, na gyaŋgba nyibaŋ mɔ kaa bese wɔle nyibaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Wee daale Yesu kee gyu Gyerusalɛm donɔɔ man nɛ, ɔ baake ɔ kaseela kufu bala baŋ lee yenaŋ te ɔ yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Dee gyu Gyerusalɛm donɔɔ man baa. Baa lese maŋ Deniwalaŋ Bu ŋon fa Wurubuarɛ saese kegyiise na Gyudatena mmaraa wola baŋ, na baa di me nombia bu maŋ fɔɔ nyi baa ko maŋ. ");
INSERT INTO ntr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Baa mo maŋ do balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ nyiŋmaa man na baa kulu maŋ, na baa tuku maŋ na baa gyɔ maŋ sakaa ɔpaŋdaŋ dɔɔ na maa yeŋ. Mɔna weeya atoorote na, Wurubuarɛ waa gyuusu maŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Keŋte Sebedeo bia, Gyemisi na Gyɔn be naa moo wɔ kɔŋ Yesu gyaŋ te ɔ buŋawɔ ɔ nawɔɔ tɛɛ sola e nyi waa kyɔ e na nombii daale. ");
INSERT INTO ntr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Keŋte Yesu bɔɔse e nyiaa, “Woŋ te n ne gyae nyi maa yɛɛ fa neŋ?” Te alo ŋon tiranɔɔ fa Yesu nyiaa, “Mɛɛ gyae nyi n ke fa me bia bala kɛwɔ gbɛɛ, na ŋolo ke kyaa n dunoluŋ dɔɔ, na ŋolo mɔ ke kyaa n demena dɔɔ n gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ ba gyeŋ kpene ɛ na solo nɛ ya. Ɛ ke tale naa diyem keŋ maa naa nɛ?” Keŋte be tiranɔɔ fa e nyi, “Ayi, dɛɛ tale.” ");
INSERT INTO ntr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Te Yesu yako wɔ nyiaa, “Ɛ ke tale naa diyem keŋ maa naa nɛ, mɔna mɔɔ taŋ doŋ keŋ maa lese walaŋ ŋon waa kyaa ma dunoluŋ yaa ma demena dɔɔ ya. Mena akyaese kɛŋa doe fa balaŋ baŋ me kya gbagba be desina see wɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu kaseela kufu akaŋ baŋ ke nyii mena nombia kɛŋa nɛ, ba gyeŋa baŋ Gyemisi na Gyɔn dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Botɔɔ te Yesu baake ɔ kaseela baŋ pou yilaa te ɔ yako wɔ nyiaa, “Ɛ gyeŋ nyi tɛɛle kei dɔɔ gyooneŋ ne di gyoori bo be balaŋ dɔɔ, te be kegyiise baŋ mɔ dana doŋ be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mɔna ɛmɛɛ dɔɔ, na mena te kaboena nyi dɛɛ doo ɛ man ya. Ɛ man walaŋ kamasɛ ŋon ɔ ne gyae nyi waa bese ɛ kegyia nɛ, kaboena nyi waa bese ɛ kegbetibii. ");
INSERT INTO ntr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te ɛ man walaŋ kamasɛ ŋon ɔ ne gyae nyi waa bese ɛ siamante nɛ, kaboena nyi waa bese ɛ popou ɛ kegbetibii. ");
INSERT INTO ntr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mena mɔ te maŋ Deniwalaŋ Bu ŋon te kɔŋ nyi balaŋ baa som maŋ ya, mɔna me kɔŋae me kaa som balaŋ, na maa yeŋ lɛɛ balaŋ burum nyee.” ");
INSERT INTO ntr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na ɔ kaseela baŋ kɛɛ lee Gyeriko donɔɔ man nɛ, balaŋ burum sila wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na siayɛlɛɛsatena bala baale kyaa gbɛɛnaa nɔɔman botɔɔ. Be ke nyii nyi Yesu ne laŋa laa nɛ, be gyinaa be nɔɔ baake nyiaa “De Gbeŋgyoo, gyoo Defidi ɔ naanabii, wii de waraŋase.” ");
INSERT INTO ntr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Keŋte balaŋ baŋ ŋmanyaŋ wɔ nyi baa wu be nɔɔ. Mɔna nɛnɛɛ gba te be desina fae yeesa nedoŋ nyiaa, “De Gbeŋgyoo, gyoo Defidi ɔ naanabii, wii de waraŋase.” ");
INSERT INTO ntr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Botɔɔ te Yesu dɔɔwɔ seŋ te ɔ baake wɔ bɔɔse wɔ nyiaa, “Woŋ te ɛ ne gyae nyi maa yɛɛ fa ŋon?” ");
INSERT INTO ntr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Keŋte be tiranɔɔ nyiaa, “De Gbeŋgyoo, dɛɛ gyae de sia ke gyuusu.” ");
INSERT INTO ntr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Botɔɔ te Yesu wii be waraŋase, te ɔ moo ɔ nyiŋmaa tinaa be sia. Debokenaŋ man te be sia gyuusuwɔ, te be sila Yesu laŋ. ");
INSERT INTO ntr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na ɔ kaseela ka benaa Gyerusalɛm donɔɔ, te be kelii Bɛtifagi donɔɔ keŋ ke kyaa oliifi bula keŋ dɔɔ nɛ, ɔ kpila ɔ kaseela bala, ");
INSERT INTO ntr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","te ɔ yako wɔ nyiaa, “Ɛ gyu donɔɔ keŋ kyaa ɛ siaman nɛ man. Ɛ gyoo ke man pɛ nɛ, ɛ kena afurum kpaŋɛɛ na ɔ bu seŋɛɛ ɔ gyaŋ. Ɛ booli wɔ na ɛ ka mo wɔ kɔna maŋ. ");
INSERT INTO ntr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Akpaa ŋolo de bɔɔse ŋon nombii daale nɛ, ɛ yako e nyiaa, ‘De Gbeŋgyoo Yesu ne gyae na wɔ.’ Ɛ yako mena nɛ, waa tina wɔ yela fa ŋon debokenaŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mena nombia kɛŋa pou kɔŋawɔ mena, te yela Wurubuarɛ nombia aŋmaraseŋ see ŋan ɔ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre dɔɔ yako nɛ, kɔŋawɔ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ɔ yakowɔ nyiaa, “Ɛ yako Gyerusalɛmtena nyiaa, ‘Ɛ kɛɛ! Ɛ gyoo ne kɔŋ ɛ gyaŋ. Ɔ te yɔkɔse ɔ wose, te ɔ kyaa afurum dɔɔ. Ɔ kyae afurum bu dɔɔ ɔ ne kɔŋ.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Keŋte Yesu kaseela baŋ gyuuwɔ ke yɛɛ ŋgba mena keŋ ɔ be yako wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba moo afurum ŋon na ɔ bu kɔŋ, te ba moo be kanyaŋse gyakaa be dɔɔ, te Yesu gyeŋawɔ kyaa. ");
INSERT INTO ntr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Balaŋ burum fɛlɛɛ be kanyaŋse lɔ gbɛɛnaa keŋ man, te baale mɔ kɛrɛɛ daase tombia na ŋe faareŋse lɔ gbɛɛnaa man fa e. ");
INSERT INTO ntr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Balaŋ burum baŋ be dɔŋɛɛ Yesu siaman, na baŋ be dɔŋɛɛ ɔ wɔle nɛ pou fiasɛɛ bɛɛ fae yeesa nyiaa, “Gyoo Defidi ɔ naanabii, lɛɛ daa! Ɛ fa dɛɛ lese walaŋ ŋon ɔ ne kɔŋ de Gbeŋgyoo Wurubuarɛ yele man nɛ yele. Wurubuarɛ ŋon n kyaa adido, lɛɛ daa!” ");
INSERT INTO ntr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu ke kɔŋ kaa gyoo Gyerusalɛm donɔɔ man nɛ, donɔɔ keŋ pou siŋiiwɔ te be bɔɔse dɔŋa nyiaa, “Walaŋ woŋti yɛna kei?” ");
INSERT INTO ntr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Keŋte balaŋ baŋ tiranɔɔ nyiaa, “Kei yɛna Yesu, Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon ɔ ba lee Nasarɛte donɔɔ keŋ ke kyaa Galelia tɛɛle man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu gyuu Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man, te ɔ kenaawɔ nyi balaŋ ne di kebu botɔɔ. Keŋte ɔ gegi balaŋ baŋ bɛɛ yɔɔ abɔɔ na baŋ bɛɛ lɛɛ abɔɔ botɔɔ nɛ pou. Ɔ besenaa balaŋ baŋ bɛɛ yɛlɛɛ kɔba nɛ tebuluse buŋii, te ɔ tɛɛse balaŋ baŋ bɛɛ yɔɔ awuluŋna nɛ mɔ gbelɛɛ lɔ. ");
INSERT INTO ntr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Keŋte ɔ yako wɔ nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see ne yako daa nyiaa, Wurubuarɛ kpa, ‘Me deni gyae ke yɛɛ botɔɔ keŋ baa fane,’ mɔna ɛmɛɛ ta besena ke yɛɛ ŋmɛɛlatena dɛɛgyaŋee.” ");
INSERT INTO ntr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Siayɛlɛɛsatena na ɔtakasese kɔŋawɔ ɔ gyaŋ Wurubuarɛ ɔsom deni dinaa keŋ man botɔɔ, te ɔ kyɔɔ wɔ be kaweese pou. ");
INSERT INTO ntr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mɔna saese kegyiise na mmaraa wola baŋ kena gyakoloŋ nombia ŋan Yesu be yɛɛ, na mena keŋ bia ne fae yeesa Wurubuarɛ ɔsom deni dinaa keŋ man nyiaa, “Gyoo Defidi ɔ naanabii lɛɛ daa” nɛ, ba gyeŋa baŋ Yesu dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Keŋte be bɔɔse Yesu nyiaa, “N ne nyii nombia ŋan bia baŋ ne yako?” Te Yesu tiranɔɔ fa wɔ nyiaa, “Ayi, mee nyii.” Keŋte ɔ bɔɔse wɔ nyiaa, “Ɛ te kala ta na ɛ kena kpene keŋ Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nɛ yee? Ba te ŋmarase see nyiaa, ‘Bia buruburu na kyokyoose te n lesewɔ see nyi baa lese n yele’ ” ");
INSERT INTO ntr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Keŋte Yesu leewɔ be gyaŋ donɔɔ keŋ man, te ɔ gyuuwɔ Bɛtani donɔɔ man, te ɔ doowɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tɛɛ kena nebo nebo fuu keŋ Yesu ba bese ɔ wɔle ɔ ne kɔŋ Gyerusalɛm donɔɔ man nɛ, na tanam na ko e. ");
INSERT INTO ntr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Botɔɔ te ɔ naa fiigi daŋ daale seŋɛɛ gbɛɛnaa nɔɔman, te ɔ kpasewɔ gyu ke tɛɛ nyi mberem waa nyiŋ ke bia ŋaale di. Mɔna ɔ te nyiŋ bii dokoloŋ na dokoloŋ ya. Ke yɛɛ faareŋse wolowolo bo. Botɔɔ te Yesu falaa daŋ kenaŋ nyiaa, “N be gyae n ka tekaa se bii na bii bela ya.” Debokenaŋ man te fiigi daŋ keŋ botowɔ. ");
INSERT INTO ntr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ɔ kaseela baŋ kena mena nɛ, doo be nɔɔ te be bɔɔse e nyiaa, “Kɔŋaa sena te fiigi daŋ keŋ botowɔ karatetee dokoloŋ mena?” ");
INSERT INTO ntr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Keŋte Yesu yako wɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, akpaa ɛ lɛɛ maŋ di nideli te ɛ te lɛɛ aŋmaareŋ ya nɛ, na kpene keŋ be kɔŋ fiigi daŋ kei dɔɔ nɛ kaageŋ te ɛ ke tale yɛɛ ya. Mɔna ɛ ke tale yako bula kei koraŋ nyiaa, ‘Koro ke yala ɛpo man’ te ke gyae ke kɔŋ mena. ");
INSERT INTO ntr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nyi akpaa ɛ lɛɛ maŋ di nɛ, kpene kamasɛ keŋ ɛ ke fane bɔɔse Wurubuarɛ nɛ, ɛ nyiŋmaa gyae ke kaŋ ke.” ");
INSERT INTO ntr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Keŋte Yesu besewɔ kɔŋ Wurubuarɛ ɔsom deni dinaa keŋ man, te ɔ kɛɛ wola wɔ Wurubuarɛ nombia ŋan nɛ, saese kegyiise na donɔɔ kegyiise kɔŋawɔ ɔ gyaŋ kaa bɔɔse e nyiaa, “Doŋ woŋti yaa n dana n ne yɛɛ mena abɔɔ kɛŋa pou? Amɔte faa na neŋ mena doŋ kenaŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Maŋ mɔ ne gyae maa bɔɔse ŋon nombii dokoloŋ. Nyi akpaa ɛ tiranɔɔ fa maŋ nɛ kenaŋ na maŋ mɔ maa wola ŋon doŋ keŋ me dana mɛɛ yɛɛ mena abɔɔ kɛŋa pou. ");
INSERT INTO ntr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gyɔn Wurubuarɛ loŋkesɔ keŋ ɔ be sɔ balaŋ nɛ, ka lee aleŋ? Ka lee Wurubuarɛ gyaŋ yaa balaŋ gyaŋ?” Botɔɔ te ba gyoo nombia ŋan man te be bɔɔse dɔŋa nyiaa, “Woŋ te dɛɛ yako? ‘Akpaa de yako nyi ka lee Wurubuarɛ gyaŋ na, waa bɔɔse daa nyi woŋ dɔɔ te da te lɛɛ Gyɔn nombia ŋan di ya?’ ");
INSERT INTO ntr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te akpaa de yako nyi ka lee balaŋ gyaŋ na, dee yee balaŋ burum kɛwɔ mɔ. Nawolo nyi be popou ne lɛɛ di nideli nyi Gyɔn yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e.” ");
INSERT INTO ntr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mena dɔɔ be tiranɔɔ fa Yesu nyiaa, “Dɔɔ gyeŋ ya.” Keŋte Yesu mɔ yako wɔ nyiaa, “Akpaa mena na, maŋ mɔ ba wola ŋon me doŋ keŋ da lee ya.” ");
INSERT INTO ntr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Keŋte Yesu besewɔ gyɔ dudu fa wɔ nyiaa, “Balee ŋolo kyaawɔ keŋ ɔ dana bia baala bala. Wee daale nɛ, ɔ gyuu ɔ bu kegyia ŋon gyaŋ ke yako e nyiaa, ‘Me bu, mɛɛ gyae nyi gyɛŋ n ke gyu me wɔɔman ke yɛɛ tom fa maŋ.’ ");
INSERT INTO ntr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Keŋte ɔ bu ŋon yako e nyiaa, mɔɔ gyae maa gyu ya, mɔna wɔle wɔle nɛ, ɔ kaa kyɛɛkee wa agyueŋ te ɔ gyuuwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Keŋte balee ŋon gyuuwɔ ɔ bu kemaasa ŋon gyaŋ ke yako ŋon mɔ mena ke. Ɔ bu kemaasa ŋon sɛɛwɔ nyi, ‘Yoo taata me nyiiwɔ, maa gyu,’ mɔna ɔ te gyu ya. ");
INSERT INTO ntr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Botɔɔ te Yesu yako wɔ nyiaa, ɛ wola maŋ ya agyueŋ. Bia bala kɛwɔ man na, woŋti yɛɛna ɔ kya ŋon kegyaebii? Te balaŋ baŋ tiranɔɔ fae e nyiaa, ‘Bu kegyia ŋon.’ Keŋte Yesu yako wɔ nyiaa, ‘Mɛɛ yako ŋon ɛ ke nyii nyiaa, lempoolɛɛra na kafoŋtena te taŋgbɛɛ ŋon bɛɛ gyoo Wurubuarɛ gyoori keŋ man.’ ");
INSERT INTO ntr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nawolo nyi Gyɔn Wurubuarɛ loŋsɔɔre ŋon kɔŋawɔ kaa wola ŋon gbɛɛ kpaakpaate keŋ ɛ ka mo, mɔna ɛ te lɛɛ e di ya. Lempoolɛɛra na kafoŋtena baŋ dɔɔ, be lɛɛ e di. Kenaŋ wɔle ɛ kena mena koraŋ nɛ, ɛ te kyɛɛkee ya agyueŋ na ɛ ke lɛɛ e di ya.” ");
INSERT INTO ntr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ nyii dudu daale bela. Wɔɔfarale ŋolo fara wɔɔ te ɔ duu daasebia ŋaale ŋan ŋe yɛɛ ŋgba akutuse te bɛɛ baake ŋa nyi gerepo nɛ. Ɔ dii abaŋ kilisi wɔɔ keŋ, te ɔ wula bɔɔ keŋ baa sara daasebia ŋan ke man na baa lese ŋa loŋ lee ŋe man nɛ. Te ɔ baŋa deni dɔɔloŋ dɔɔloŋ daale, keŋ walaŋ ke kyaa ke man na waa gyee wɔɔ kenaŋ. Te ɔ moo wɔɔ keŋ do paasetena baale nyiŋmaa man nyi baa kɛɛ ke dɔɔ, te ɔ korowɔ laŋ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Debaŋ kelii nyi baa kɔ daasebia ŋan nɛ, ɔ kpila ɔ tewulɛɛ gyu paasetena baŋ gyaŋ nyi baa fa e ɔ wui nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Botɔɔ te paasetena baŋ kyaŋa ɔ tewulɛɛ baŋ, te be tuku ŋolo te ba koo ŋolo te be fuŋii ŋolo mɔ boya. ");
INSERT INTO ntr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Keŋte wɔɔte ŋon besewɔ kpila ɔ tewulɛɛ baŋ ba boe kela gyaŋgba nyibaŋ baŋ gyu paasetena baŋ gyaŋ, mɔna be yɛɛ baŋ mɔ mena ke. ");
INSERT INTO ntr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kenaŋ wɔle nɛ, wɔɔte ŋon kpila ŋon gbagba ɔ bu te ɔ yakowɔ nyiaa, ‘Mberem ŋon na baa bu e.’ ");
INSERT INTO ntr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mɔna paasetena baŋ kena ɔ bu ŋon nɛ be yako dɔŋa nyiaa, ‘Kei yɛna bu ŋon waa kaa di ɔ kya abɔɔ ŋan. Ɛ yela dɛɛ ko e na abɔɔ ŋan nafɔ waa di nɛ ka bese de wui!’ ");
INSERT INTO ntr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mena dɔɔ be wɔŋee e lee wɔɔ keŋ man ka ko. ");
INSERT INTO ntr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Botɔɔ te Yesu bɔɔse wɔ nyiaa, Mena dɔɔ wee keŋ wɔɔte ŋon de kɔŋ na, woŋ te waa yɛɛ paasetena baŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Keŋte be tiranɔɔ fa e nyiaa, “Waa koe mena balaŋ kumɛɛ benaŋ pou, na waa mo wɔɔ keŋ do paasetena wɔlɛɛ baŋ debaŋ de lii na, baa fa e ɔ wui nɔɔ nɛ nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Ɛ te kala ta Wurubuarɛ nombia aŋmaraseŋ see ŋan na ɛ kena kpene keŋ ne yako nɛ yee? Be ŋmarasewɔ see nyiaa, ‘Boe keŋ deni mmaraa baŋ be bɛɛ nɛ, keŋ kaa bese na mokɔɔ kasee boe keŋ ne yeli deni keŋ ne yɛɛ doŋ. De Gbeŋgyoo Wurubuarɛ yɛɛ la te kɔŋawɔ mena, te ke yɛɛ kpene keŋ ke dana gyakoloŋ de siaman’ ” ");
INSERT INTO ntr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Keŋte Yesu besewɔ yako wɔ nyiaa, “Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyiaa, Wurubuarɛ waa lɛo ɔ gyoori keŋ lee ɛ gyaŋ, na waa mo fa balaŋ baŋ baa yɛɛ ɔ kegyaebii nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Walaŋ kamasɛ ŋon ɔ yale mena boe kei dɔɔ na, gyae ke keretii e kpetekpetekpete. Te nyaŋ walaŋ kamasɛ ŋon mɔ boe keŋ de yale n dɔɔ na, nyaŋ ke pɛtɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Saese kegyiise na Farasiitena baŋ ke nyii Yesu aduya kɛŋa nɛ, ba gyeŋawɔ nyi ba wose man nombia yaa ɔ ne yako. ");
INSERT INTO ntr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mena dɔɔ be gyae gbɛɛ keŋ baa mo kyaŋ e, mɔna be yee balaŋ dikpii keŋ. Nawolo nyi bɛɛ lɛɛ di nideli nyi Yesu yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e. ");
INSERT INTO ntr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu besewɔ kolosi fa balaŋ baŋ aduya man nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Wurubuarɛ gyoori keŋ yɛɛ ŋgba gyoo ŋon ɔ ba do kesaa fa ɔ bu ŋon ɔ ba kpeo alo nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Keŋte ɔ kpila ɔ tewulɛɛ nyiaa, baa gyu ke baake balaŋ baŋ ɔ be lɔ yele baake wɔ nɛ nyi baa kɔŋ na be kaa di, mɔna be bɛe ba te kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mena dɔɔ ɔ besewɔ kpila ɔ tewulɛɛ wɔlɛɛ baale bela nyiaa, ɛ gyu ke yako balaŋ baŋ mɔɔ lɔ yele baake wɔ nɛ nyiaa, ‘Ɛ kɔŋ, ma te taŋ kpene kamasɛ. Be ta koe me nunkyue baala na me wonembia baŋ be dana nuŋ nɛ, te ba te yɛɛ kpene kamasɛ mɔ taŋ. Ɛ kɔŋ alowɔle keŋ tɛɛ na ɛ kaa di.’ ");
INSERT INTO ntr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mɔna balaŋ baŋ ɔ be lɔ yele baake nɛ ta mo ɔ nombia ŋan yɛɛ kolo ya. Kei da koro na ɔ te laŋ ɔ wɔɔ, kei mɔ da koro na ɔ te laŋ ɔ tom man. ");
INSERT INTO ntr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Balaŋ akaŋ baŋ kyaŋa gyoo ŋon tewulɛɛ baŋ, te be tuku wɔ te ba koe wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mena dɔɔ gyoo ŋon gyeŋa baŋ nideli te ɔ kpila ɔ yoonɔɔtena te be ka koe balaŋ baŋ bɔɔ koe ɔ tewulɛɛ baŋ nɛ, te ba too be donɔɔ keŋ mɔ. ");
INSERT INTO ntr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Keŋte gyoo ŋon baake ɔ tewulɛɛ baŋ bɔɔ kaa nɛ te ɔ yako wɔ nyiaa, ‘Ba te saa ma alowɔle weenɛɛ ŋan taŋ, mɔna balaŋ baŋ mɔɔ lɔ yele baake wɔ nɛ, ba tekaboena nyi baa kɔŋ kaa di ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mena dɔɔ ɛ ŋere gyoo donɔɔ keŋ abɔnterese man, na ɛ ke baake walaŋ kamasɛ ŋon ɛ kena nɛ, nyi waa kɔŋ alowɔle keŋ tɛɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mena dɔɔ ɔ tewulɛɛ baŋ gyoowɔ donɔɔ keŋ man te be baake balaŋ baŋ pou bɔɔ naa nɛ. Be baake balaŋ kpaakpaa nyibaŋ na balaŋ kumɛɛ pou, te balaŋ kaa wulu alowɔle dekpaŋalaŋ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mɔna gyoo ŋon ke kɔŋ kaa gyoo dekpaŋalaŋ keŋ man ɔ kaa kɛɛ balaŋ baŋ pou bɔɔ baake nɛ, ɔ naa baale ŋolo kyaa be man keŋ ɔ ba doona alowɔletɛɛ kegba keŋ kaboena nyi walaŋ kamasɛ waa do nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Keŋte gyoo ŋon bɔɔse e nyiaa, ‘Me gyoo, sena te n yɛɛwɔ kɔŋ kɛbo keŋ n ba doona alowɔletɛɛ kegba ya?’ Mɔna baale ŋon te tale tiranɔɔ fa e ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Botɔɔ te gyoo ŋon yako ɔ tewulɛɛ baŋ nyi, ‘Ɛ bake e ɔ nyiŋmaase na ɔ nawɔɔ, na ɛ ke fuŋ e leki ditiŋtɛɛ man. Botɔɔ te waa kyaŋ ɔ nyee wii na waa naa diyem nideli.’ ");
INSERT INTO ntr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Keŋte Yesu yako wɔ nyiaa, Wurubuarɛ baake balaŋ burum, mɔna balaŋ kyomii te ɔ lesewɔ lee be man.” ");
INSERT INTO ntr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Keŋte Farasiitena baŋ korowɔ lee yenaŋ gyu ke bake Yesu nyeeman, mena keŋ baa kaa teese ɔ nɔɔman na baa mo ŋon gbagba ɔ nɔɔwoya kyaŋ e. ");
INSERT INTO ntr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mena dɔɔ be kpila be kaseela baŋ man baale kpu na gyoo Herode balaŋ gyu Yesu gyaŋ. Keŋte be yako e nyiaa, “De Gbeŋgyoo, da gyeŋ nyi n nombia doo na ŋe gbɛɛ, te n na wola balaŋ Wurubuarɛ gbɛɛneŋ kpaakpaa ŋan bo na anokoare. Da gyeŋ nyi ŋolo be tale beo neŋ ya, nawolo nyi n bɛɛ kɛɛ balaŋ siaman ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mena dɔɔ yako daa nya agyueŋ. Dei nyi dɛɛ tɔ lempoo fa Romantena gyoo dinaa ŋon, yaa de na tɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mɔna Yesu kena ba agyueŋ kumɛɛ ŋan nɛ ɔ yako wɔ nyiaa, “Ɛmɛɛ baŋ ɛ na beo ɛ wose, woŋ dɔɔ te ɛ ne gyae ɛ ka teese me nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɛ mo kɔbabii keŋ ɛ na mo tɔ lempoo nɛ kɔŋ maa kɛɛ.” Keŋte ba moo kɔbabii keŋ daale kɔna e. ");
INSERT INTO ntr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Keŋte ɔ bɔɔse wɔ nyiaa, “Amɔte nyee na ɔ yele gyakaa la ke dɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Botɔɔ te be tiranɔɔ nyiaa, “Romantena gyoo dinaa ŋon.” Mena dɔɔ Yesu yako wɔ nyiaa, “Mena na kpene keŋ yɛɛ Gyoo dinaa ŋon wui na ɛ mo fa e, te kpene keŋ yɛɛ Wurubuarɛ mɔ wui na ɛ mo fa e.” ");
INSERT INTO ntr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Be ke nyii Yesu nɔɔwoya kɛŋa nɛ, doo be nɔɔ. Mena dɔɔ be laŋawɔ tina e yela. ");
INSERT INTO ntr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mena wee kenaŋ ke nɛ, Sadukiitena baŋ bɛɛ yako nyi yeŋ wɔle kefoŋ be kyaa ya nɛ kɔŋawɔ Yesu gyaŋ kaa bɔɔse e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“De Gbeŋgyoo, de naana Mosesi ŋmarase mmaraa kei fa daa nyi, akpaa ŋolo da yem tina ɔ wɛɛle yela te be ta lolo bia ya na, kaboena nyi ɔ naabu waa yala lialo ŋon na baa lola bia ɔ kegyia ŋon yele man. ");
INSERT INTO ntr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kɔŋawɔ nyi naa bia nyetooro baale kyaawɔ te kegyia ŋon yala alo te ɔ yeŋawɔ. Mɔna keŋ be ta lola bia dɔɔ ya nɛ, te balate ŋon mɔ yala alo ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ɔ naabu balate na batoorote mɔ yeŋawɔ yela alo ŋon mena keŋ be ta lola bia ya. Balaŋ nyetooro kɛwɔ pou yala alo kei te ba yekeewɔ, mɔna be man ŋolo na alo ŋon ta lolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kenaŋ wɔle nɛ, te alo ŋon mɔ yeŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mena dɔɔ wee keŋ Wurubuarɛ waa gyuusu balaŋ baŋ pou bɔɔ yem nɛ lee yeŋ man na, baala nyetooro kɛwɔ baŋ bɔɔ yala alo kei gyaŋee nɛ, be man woŋti te alo ŋon waa yɛɛ ɔ wɛɛle?” ");
INSERT INTO ntr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ ta yoo, nawolo nyi ɛ ba gyeŋ Wurubuarɛ nombia aŋmaraseŋ see ŋan ya, te ɛ ba gyeŋ Wurubuarɛ doŋ mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nawolo nyi wee keŋ Wurubuarɛ waa gyuusu balaŋ lee yeŋ man nɛ, baala be gyae baa yala ya, te bɔɔ gyae baa mo ala mɔ fa yale ya. Be popou baa yɛɛ ŋgba Wurubuarɛ kpilala baŋ be kyaa adido nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɛ te kala ta Wurubuarɛ nombia aŋmaraseŋ see ŋan, na ɛ kena kpene keŋ Wurubuarɛ be yako lee kefoŋ lee yeŋ man wose man nombia yee? Ɔ yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Maŋ yɛna Aberaham na Asiki na Gyekɔpo Wurubuarɛ.’ Wurubuarɛ te yɛɛ woya Wurubuarɛ e ya, mɔna ɔ yɛɛ balaŋ baŋ be kyaa na be sia nɛ Wurubuarɛ e.” ");
INSERT INTO ntr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Balaŋ dikpii keŋ ke nyii nombia kɛŋa nɛ, ɔ kawola keŋ doo be nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farasiitena baŋ ke nyii nyi Yesu ta mo ɔ nyansa di Sadukiitena baŋ dɔɔ nɛ, be popou kaa gyaŋeewɔ debodokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Keŋte be maŋ ŋolo ŋon ɔ yɛɛ mmaraa wolale e nɛ, kɔŋawɔ ɔ kaa teese Yesu nɔɔman te ɔ bɔɔse e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“De Gbeŋgyoo, Wurubuarɛ mmaraase ŋan pou na, woŋti kela la?” ");
INSERT INTO ntr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Botɔɔ te Yesu tiranɔɔ fa e nyiaa, “ ‘Mo n konɔɔ pou na n wose pou na nya agyueŋ pou gyae n Gbeŋgyoo Wurubuarɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kei yɛna mmaraa siamante na keŋ ka kela ŋe popou. ");
INSERT INTO ntr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Alate keŋ mɔ yɛɛ ŋgba gyaŋgbate keŋ nɛ. Keŋ yɛna nyi, ‘Gyae n dɔɔ ŋgba nyaŋ gbagba n wose nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesi mmaraase ŋan pou na Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ pou nombia ŋan bɔɔ wolo nɛ, seŋae mmaraase ala kɛŋa dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasiitena baŋ ke yilaa debodokoloŋ nɛ, Yesu bɔɔse wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sena te ɛ na gyueŋ lee nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ wose man? Ɔ yɛɛ amɔte ɔ naanabii e?” Keŋte be tiranɔɔ nyiaa, “Ɔ yɛɛ gyoo Defidi ɔ naanabii e.” ");
INSERT INTO ntr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Keŋte Yesu bɔɔse wɔ nyiaa, “Akpaa mena na, weera dɔɔ te Wurubuarɛ feliŋ ŋon yela gyoo Defidi baake nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ nyi me ‘Gbeŋgyoo?’ Gyoo Defidi yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘De Gbeŋgyoo Wurubuarɛ ŋon yako me Gbeŋgyoo nyi, tisi kyaa me dunoluŋ dɔɔ, kelii debaŋ keŋ maa mo n kɔlala baŋ do n tɛɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Akpaa nyi gyoo Defidi baake nyeelɛɛre ŋon nyi ɔ ‘Gbeŋgyoo’ na, kenaŋ na sena te nyeelɛɛre ŋon waa bese gyoo Defidi ɔ naanabii?” ");
INSERT INTO ntr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Be man ŋolo te tale tiranɔɔ fa Yesu ya. Te lee mena wee kenaŋ ne gyu mɔ na, ŋolo te tale gyɔ ɔ konɔɔ bɔɔse e nombii daale bela ya. ");
INSERT INTO ntr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Keŋte Yesu kolosiwɔ fa balaŋ dikpii keŋ na ɔ kaseela baŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Gyudatena mmaraa wolala na Farasiitena baŋ yɛna balaŋ baŋ be dana gbɛɛ nyii baa tale lese Wurubuarɛ mmaraase ŋan man. ");
INSERT INTO ntr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mena dɔɔ kaboena nyi yaa tei wɔ, na ɛ ke sila kpene kamasɛ keŋ bɛɛ wola ŋon nɛ. Mɔna ɛ na yɛɛ kpene keŋ bɛɛ yɛɛ nɛ ya, nawolo nyi bɔɔ ne di be kawola keŋ dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bɛɛ bake kasolɔse ŋan kela balaŋ nɛ yere wɔ, mɔna baŋ gbagba bɛɛ sɛɛ yɛɛ kolo kyomii kyɔ wɔ na baa tale seele be kasolɔse ŋenaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kpene kamasɛ keŋ bɛɛ yɛɛ nɛ, bɛɛ yɛɛ bo na balaŋ ke nyiŋ naa wɔ. Wonembu tɔne adakaasebia ŋan bɛɛ yɛɛ te bɛɛ ŋmarase Wurubuarɛ nombia do ŋe man te bɛɛ mo mataa be tirinɔɔse na be baamense dɔɔ nɛ, bee yeli be wui ŋan na keeree. Te ŋmeeseŋ ŋan bɛɛ mo gbili ba kegba wurikyimse ŋan nɔɔsebia te ŋee wuluŋu nɛ, bee yeli be wui ne yɛɛ dɔɔloŋ dɔɔloŋ. ");
INSERT INTO ntr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bɛɛ gyae akyaese kpaakpaa be dɛɛgyaŋee di gyoŋ, na Gyudatena ɔsom denɛɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bɛɛ gyae nyi balaŋ ke buŋii do wɔ nɔɔ balaŋ dɛɛgyaŋee man, te bɛɛ gyae mɔ nyi balaŋ ke baake wɔ nyi ‘Wolala.’ ");
INSERT INTO ntr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mɔna ɛmɛɛ dɔɔ, ɛ na yele baa baake ŋon nyi ‘Wolala’ ya, nawolo nyi ɛ popou dana wolale dokoloŋ kooŋ bo, te ɛ yɛɛ walaŋ dokoloŋ mɔ biawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te ɛ na baake ŋolo mɔ tɛɛle kei dɔɔ nyi ɛ ‘Kya’ ya, nawolo nyi ɛ dana kya dokoloŋ kooŋ bo. Ŋon yɛna ŋon ɔ kyaa adido nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mena ke te ɛ na yele baa baake ɛ man ŋolo nyi ‘Siamante’ ya, nawolo nyi ɛ dana siamante dokoloŋ bo. Ŋon yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Walaŋ ŋon ɔ yɛɛ kegyia e ɛ man nɛ, waa bese ɛ kegbetibii. ");
INSERT INTO ntr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Walaŋ ŋon ɔ gyina ɔ wose adido na, Wurubuarɛ waa yɔkɔse e, te ŋon ɔ yɔkɔse ɔ wose na, Wurubuarɛ waa gyina adido. ");
INSERT INTO ntr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako. Nawolo nyi ɛ ne tɔ balaŋ gbɛɛ nyi be na gyoo Wurubuarɛ gyoori keŋ man ya. Ɛmɛɛ gbagba bɛɛ gyoo ke man ya, mɔna baŋ bɛɛ yɛɛ kakyeŋ baa gyoo ke man mɔ nɛ, ɛ bɛɛ fa wɔ gbɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako. Nawolo nyi ɛ na beo liala lɛo ba abɔɔ ŋan be dana nɛ. Ɛ ne fane kyare na ɛ ka mo beo balaŋ nyi ɛ yɛɛ balaŋ kpaakpaawɔ. Mena dɔɔ Wurubuarɛ waa wɔŋ ɛ deŋela nideli kela walaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako. Nawolo nyi ɛ na mo ɛpo dɔɔ, kila tɛɛle dɔɔ pou nyi ɛ ke nyiŋ walaŋ dokoloŋ na ɔ kaa sila Wurubuarɛ. Mɔna akpaa ɛ nyiŋ walaŋ ŋonaŋ na, ɛ ne yeli ɔ dinɔɔ na bese wɔlɛɛ koraŋ keŋ nyi diyem keŋ waa naa boalaŋ man nɛ, kela ɛmɛɛ gbagba wui betabola. ");
INSERT INTO ntr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ɛmɛɛ siayɛlɛɛsatena baŋ ɛ na wola balaŋ gbɛɛ nɛ, ɛ laako nawolo nyi ɛ kpa akpaa ŋolo de kaŋ Wurubuarɛ ɔsom deni dinaa keŋ ntam na ka te yɛɛ kolo ya, mɔna akpaa ŋolo de kaŋ kɔba yayam abɔɔ ŋan doo Wurubuarɛ ɔsom deni dinaa keŋ man ntam na, kaboena nyi waa di ntam kenaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ɛmɛɛ siayɛlɛɛsatena ayiŋtena, woŋti kela na ke dɔɔ? Kɔba yayam abɔɔ ŋan yaa Wurubuarɛ ɔsom deni dinaa keŋ ne yele kɔba abɔɔ ŋan na bese Wurubuarɛ wui nɛ? ");
INSERT INTO ntr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɛ na bese yako nyi, akpaa ŋolo de kaŋ Wurubuarɛ kedeesa boe keŋ ntam na te yɛɛ kolo ya, mɔna akpaa ɔ kaŋ abɔɔ ŋan gyakaa kedeesa boe keŋ dɔɔ nɛ ntam na, kaboena nyi waa di ntam keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ɛmɛɛ siayɛlɛɛsatena, woŋti kela na ke dɔɔ? Abɔɔ ŋan gyakaa kedeesa boe keŋ dɔɔ nɛ, yaa kedeesa boe keŋ ne yele kedeesa abɔɔ ŋan na bese Wurubuarɛ wui nɛ? ");
INSERT INTO ntr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lee mena dɔɔ walaŋ kamasɛ ŋon ɔ kaŋ Wurubuarɛ kedeesa boe keŋ ntam na, nawolo baa nyi ɔ te kaŋ abɔɔ ŋan pou gyakaa ke dɔɔ nɛ ntam. ");
INSERT INTO ntr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te walaŋ ŋon ɔ kaŋ Wurubuarɛ ɔsom deni dinaa keŋ ntam na, nawolo baa nyi ɔ te kaŋ keŋ na Wurubuarɛ ŋon ɔ kyaa ke man nɛ ntam. ");
INSERT INTO ntr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mena mɔ te walaŋ ŋon ɔ kaŋ adido ntam na, nawolo baa nyi ɔ te kaŋ Wurubuarɛ gyoorogbeli keŋ, na Wurubuarɛ ŋon ɔ kyaa ke dɔɔ nɛ ntam. ");
INSERT INTO ntr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako. Nawolo nyi ɛ na mo ɛ wɔɔman abɔɔ buruburu gba kufu man dekpeŋ dokoloŋ fa Wurubuarɛ, mɔna ɛ te tina kpene keŋ ne hia nyi yaa yɛɛ mmaraa keŋ man nɛ yela. Ɛ bee di nombia na ŋe gbɛɛ ya, te ɛ bee wii balaŋ waraŋase ya, te ɛ bee di anokoare mɔ ya. Nafɔ kaboena nyi yaa yɛɛ mena abɔɔ kɛŋa pou, na ɛ ka bese fa ɛ wɔɔman abɔɔ buruburu ŋan kufu man dekpeŋ dokoloŋ bela kpu. ");
INSERT INTO ntr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ɛmɛɛ siayɛlɛɛsatena baŋ ɛ dɔŋ balaŋ siaman. Ɛ ne tale kyɔsee lese wonembia buruburu lee ɛ soloŋse man, mɔna ɛ ne lilii wonembia dinaana. ");
INSERT INTO ntr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako. Nawolo nyi ɛ ne faafo ɛ leenɔɔse na ɛ nyefalɛɛ wɔle bo, mɔna ŋe man dana ayimɛɛ. Nawolo nyi abɔɔ ŋan doo ŋe man nɛ, anibiri na doŋ te ɛ na mo ŋere balaŋ lɛo ŋa. ");
INSERT INTO ntr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɛmɛɛ Farasiitena siayɛlɛɛsatena, ɛ taŋgbɛɛ faafo ɛ leenɔɔse na ɛ nyefalɛɛ ŋan tɔɔman na, ŋe wɔle mɔ gyae ka lee. ");
INSERT INTO ntr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako! Nawolo nyi ɛ yɛɛ ŋgba yebɔɔse ŋan bɔɔ mo kolo wolom gyilaa ŋe wɔle na ke yɛɛ kyeo nɛ. Mɔna ŋe tɔɔman na, denibalaŋ ŋɔɔ na ba wosenaane adalɛɛ te wulu ŋe man. ");
INSERT INTO ntr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mena ke te ɛmɛɛ mɔ doo. Balaŋ siaman na ɛ ne yɛɛ ɛ wose ŋgba ɛ yɛɛ balaŋ kpaakpaawɔ nɛ, mɔna balaŋ kabeo na nombiakumɛɛ te wulu ɛ konɔɔse man. ");
INSERT INTO ntr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ɛmɛɛ mmaraa wolala na Farasiitena baŋ ɛ na beo ɛ wose, ɛ laako. Nawolo nyi ɛ ne ma Wurubuarɛ akpeŋkpeŋgyɔɔra na balaŋ baŋ be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nɛ yebɔɔse nideli, na ŋa ke yɛɛ kyeo. ");
INSERT INTO ntr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te ɛ ne yako nyi, ‘Daa deŋ kyaa la de naanaɔ debaŋ keŋ nɛ, nafɔ deŋ te kpuu na wɔ na baa koe Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ ya.’ ");
INSERT INTO ntr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mena dɔɔ ɛ nɔɔwoya kɛŋa nawola la nyi, ɛ te sɛɛ nyi balaŋ baŋ bɔɔ koe Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ nɛ, ɛ yɛɛ be duuluŋ man balaŋwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɛ betaa kyaŋ nombiakumɛɛ ŋan ɛ naanaɔ be yɛɛ nɛ man, na ɛ ke yɛɛ ŋa kelii ɔto. ");
INSERT INTO ntr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ɛ dana nombiakumɛɛ ŋgba doma nɛ. Ɛ be gyae ɛ ke tale yeu lee Wurubuarɛ nyiŋmaa man, keŋ nyi ɔ be bu ŋon fɔɔ na waa yela ɛ ka gyoo boalaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mɛɛ yako ŋon baa ɛ ke nyii nyiaa, maa kpila Wurubuarɛ akpeŋkpeŋgyɔɔra na siakaralatena na wolala ɛ gyaŋ. Ɛ ka ko be man baale na ɛ ke gyɔ be man baale ɔpaŋdaŋ dɔɔ, na ɛ ke tuku be man baale yɔ ɔsom denɛɛ man na ɛ ke gegi wɔ na donɔɔse. ");
INSERT INTO ntr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Keŋ ɛ ba koe balaŋ baŋ be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman, lee Abɛle dɔɔ kelii Berekia bu Sakaria ŋon ɛ ba koo kedeesa boe keŋ na Wurubuarɛ ɔsom deni dinaa keŋ nsana nsana dɔɔ nɛ, Wurubuarɛ waa wɔŋ ɛ deŋela nideli. ");
INSERT INTO ntr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mɛɛ yako ŋon ɛ ke nyii nyiaa, kɛŋa pou deŋele kewɔŋ gyae ke kɔŋ ɛmɛɛ gyɛŋ wee kei balaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Gyerusalɛmtena! O Gyerusalɛmtena! Ɛmɛɛ koona Wurubuarɛ akpeŋkpeŋgyɔɔra, te ɛ fuŋii balaŋ baŋ Wurubuarɛ be kpilii ɛ gyaŋ nɛ boya. Ma te yɛɛ kakyeŋ nyi maa yilaa ŋon do me tɛɛ, ŋgba mena keŋ kegyim talabo ne fɛlɛɛ ɔ beŋkelɛɛ wuu ɔ bia dɔɔ nɛ, mɔna ɛ te fa maŋ gbɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɛ kɛɛ, Wurubuarɛ ta lese ɔ sia lee ɛ donɔɔ keŋ dɔɔ. Ka seŋɛɛ bo yakaa. ");
INSERT INTO ntr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mena dɔɔ mɛɛ yako ŋon ɛ ke nyi nyiaa, ɛ be gyae ɛ ka tekaa naa maŋ bela ya, kelii debaŋ keŋ ɛ ke yako nyiaa ‘Walaŋ ŋon ɔ ne kɔŋ de Gbeŋgyoo Wurubuarɛ yele man nɛ, ŋon na nyeebam.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ka lee Wurubuarɛ ɔsom deni dinaa keŋ man ɔ ne gyu nɛ, ɔ kaseela baŋ wɔŋa wa agyueŋ kɔŋ denɛɛ ŋan seŋɛɛ botɔɔ nɛ kyeo dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Keŋte ɔ tiranɔɔ fa wɔ nyiaa, “Ŋgba ɛ ne naa abɔɔ kɛŋa pou. Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, baa tekerii ŋe popou lɔ keŋ nyi ɛ be gyae ɛ kena boe na boe gyakaa ke dɔɔ dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Keŋte Yesu gyuuwɔ ke kyaa oliifi bula keŋ dɔɔ. Botɔɔ te ɔ kaseela baŋ baageŋ korowɔ gyu ɔ gyaŋ te be bɔɔse e nyiaa, “De Gbeŋgyoo yako daa, debaŋ woŋti te kɛŋa pou gyae ke kɔŋ. Woŋ te dɛɛ mo gyeŋ nyi n kabese kɔŋ, na debaŋ ɔtomante keŋ ta benaa?” ");
INSERT INTO ntr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ kɛɛ ɛ wose dɔɔ nideli keŋ nyi ŋolo ba beo ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nawolo nyi balaŋ burum baa kɔŋ ma yele man, na be kaa mo ba wose nyi baŋ yɛna maŋ nyeelɛɛre ŋon, na baa beo balaŋ burum na baa yo gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɛ nyii yoo nombia na, ɛ na yele ɛ wɔe ke lɔ ŋon ya. Nawolo nyi kaboena nyi nombia kɛŋa pou dɛɛkɔŋ, mɔna kɛŋa bɛɛ wolo nyi ɔto keŋ te lii ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tɛɛlese baa koro seŋ tia dɔŋa, na gyooneŋ mɔ ka koro seŋ tia dɔŋa. Tanam dinaa gyae ke yala, te tɛɛle mɔ gyae kewosi yenaase burum. ");
INSERT INTO ntr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kɛŋa pou yɛɛ yaa ŋgba fulute kadoŋee kewalaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lee maŋ dɔɔ balaŋ pou baa kɔla ŋon, na baa kyaŋee ŋon na baa naase ŋon diyem na baa koe ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Debaŋ kenaŋ man te balaŋ burum baa tina maŋ kelɛɛdi yela. Baa kɔla dɔŋa, na baa lese dɔŋa fa. ");
INSERT INTO ntr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Akɛrɛɛ akpeŋkpeŋgyɔɔra baa kɔŋ, na be kaa beo balaŋ burum. ");
INSERT INTO ntr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Keŋ nombiakumɛɛ keyɛɛ gyae ka bo dɔɔ, balaŋ burum balaŋ kegyae nɔɔ gyae ke yɔkɔse. ");
INSERT INTO ntr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mɔna walaŋ ŋon ɔ yɛɛ kakyeŋ seŋ keŋkeŋ kelii ɔto na, Wurubuarɛ waa lɛɛ ɔ nyee. ");
INSERT INTO ntr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Baa yako nombia kpaakpaa lee Wurubuarɛ gyoori keŋ wose man fa tɛɛle kei dɔɔ balaŋ pou, na debiise pou balaŋ ke nyii, pɛte ɔto keŋ ke kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Akpaa ɛ naa mmusuo nombii Wurubuarɛ ɔsom deni dinaa keŋ man, ŋgba mena keŋ Wurubuarɛ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Daniɛle dɔɔ kolosi see lee ka wose man nɛ, na kaboena nyi walaŋ kamasɛ ŋon waa kala mena nɔɔwoya ŋenaŋ na, waa yɛɛ kakyeŋ na waa nyii ŋe man nideli. ");
INSERT INTO ntr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","De kɔŋ mena na, balaŋ baŋ be kyaa Gyudia tɛɛle man nɛ, baa yeu gyu bulase dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nyi akpaa ŋolo kyaa ɔ deni nyee dɔɔ na, ɔ na tisi kɔŋ tɛɛle man nyi ɔ kaa mo ɔ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te akpaa ŋolo mɔ kyaa wɔɔman na, ɔ na bese gyu dɛɛ nyi ɔ kaa mo ɔ kegba ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Weeya ŋenaŋ man na, fulɛɛtena na talabose baa laako. ");
INSERT INTO ntr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mena dɔɔ ɛ fane fa Wurubuarɛ nyi, ɛ keyeu wee kenaŋ na kɔŋ waaretɛɛ yaa kefɛɛfowee ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nawolo nyi debaŋ kenaŋ wui kayeyɛɛ gyae ka bo kela ŋan pou be kɔŋ kaalaŋ, leenaŋ debaŋ keŋ Wurubuarɛ be yɛɛ tɛɛle kei kaa lii gyɛŋ wee kei nɛ. Te kaale kenaŋ dinɔɔ be gyae ka tekaa kɔŋ wee daale wee daale bela ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mɔna Wurubuarɛ taŋ wula kɔkee kayeyɛɛ weeya kɛŋa. Na waa yɛɛ mena ya nɛ, nafɔ ŋolo na ŋolo be gyae waa ka ya. Mɔna lee ɔ balaŋ baŋ ɔ ba lese see dɔɔ nɛ, te waa kɔkee weeya ŋenaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Debaŋ kenaŋ de lii te ŋolo de yako ŋon nyi ‘Ɛ kɛɛ Kristo ŋon kyaa kɛbo yaa ɔ kyaa yenaŋ daale na, ɛ na lɛɛ ke di ya.’ ");
INSERT INTO ntr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nawolo nyi balaŋ baa dii akɛrɛɛ nyi baŋ yɛna maŋ Kristo ŋon, te baale mɔ baa dii akɛrɛɛ nyi be yɛɛ Wurubuarɛ akpeŋkpeŋgyɔɔrawɔ. Baa yɛɛ gyakoloŋ nombia na nombia dinaana, na akpaa be tale nyiŋ gbɛɛ koraŋ na, baa mo beo Wurubuarɛ balaŋ baŋ ɔ ba lese see nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mɔna ɛmɛɛ dɔɔ, me te wulaa yako ŋon nombia kɛŋa pɛna debaŋ keŋ ke kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mena dɔɔ akpaa ŋolo de yako ŋon nyi, ɛ kɛɛ ɔ kyaa depampaa dinaa keŋ man na, ɛ na gyu botɔɔ ya. Te akpaa be yako ŋon nyi, ɔ te kɔŋ ɔ yoɛ yenaŋ daale na, ɛ na lɛɛ di. ");
INSERT INTO ntr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nawolo nyi maŋ Deniwalaŋ Bu ŋon kekɔŋ gyae ke yɛɛ bo ŋgba mena keŋ ɔga ne ŋmaale lee weese dɛɛlee man, te balaŋ pou ne naa ke ɔ dɛɛyalae man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Botɔɔ keŋ kolo punta doo na, botɔɔ te bapɛtɛɛna mɔ ne yilaa. ");
INSERT INTO ntr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Weeya ŋenaŋ man kaale kɛŋa pou wɔle nɛ, be gyae ke di weeya ala ya weese waa gyoo ditiŋtɛɛ, te gyaalaŋ mɔ be gyae waa wolose ya. Kyolobiise baa lee adido kaa yala. Te abɔɔ ŋan pou ŋe kyaa adido nɛ, gyae ke wosi. ");
INSERT INTO ntr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Debaŋ kenaŋ nɛ, balaŋ baa naa kolo adido keŋ gyae kawola nyi, maŋ Deniwalaŋ Bu ŋon kekɔŋ te lii. Te tɛɛle kei dɔɔ balaŋ pou baa wii walaŋsa. Baa naa maŋ Deniwalaŋ Bu ŋon ta mo doŋ na gyoorobiiri lee ŋɔma man adido mɛɛ kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ba wola kaberɛ dinaa keŋ na, maŋ Deniwalaŋ Bu ŋon maa kpila me kpilala lee adido kɔŋ tɛɛle kei dɔɔ, na be kaa yilaa me balaŋ baŋ mɔɔ lese see nɛ lee tɛɛle kei dɔɔ yenaase kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Keŋte Yesu besewɔ yako wɔ nyiaa, ɛ kɛɛ fiigi daŋ na ɛ ke kasee kolo lee ka wose man. Akpaa ɛ naa ŋgba ke tombia da potee faareŋse wɔlɛɛ nɛ, na ɛ gyeŋ nyi awuluŋtɛɛ ta benaa. ");
INSERT INTO ntr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mena mɔ te akpaa ɛ naa mena nombia kɛŋa pou ne kɔŋ na, ɛ gyeŋ nyi maŋ Deniwalaŋ Bu ŋon kekɔŋ ta benaa taŋ. ");
INSERT INTO ntr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ampaŋ yaa mɛɛ yako ŋon nyi balaŋ baŋ be kyaa gyɛŋ kei nɛ, be duuluŋ be gyae ke munu taŋ ya, pɛte nombia kɛŋa kekɔŋ. ");
INSERT INTO ntr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adido na tɛɛle kei pou gyae ke gyu ɔto, mɔna me nɔɔwoya dɔɔ ŋan gyae ke kyaa kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Keŋte Yesu besewɔ yako wɔ nyiaa, ŋolo ba gyeŋ wee na debaŋ keŋ kɛŋa pou gyae ke kɔŋ ya. Wurubuarɛ kpilala baŋ be kyaa adido, na maŋ Deniwalaŋ Bu ŋon koraŋ ba gyeŋ ya. Gyisɛ me kya ŋon ɔ kyaa adido nɛ waageŋ gyeŋa la. ");
INSERT INTO ntr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mena keŋ be kɔŋ Nowa debaŋ keŋ nɛ, mena te maŋ Deniwalaŋ Bu ŋon mɔ kabese kɔŋ gyae ke yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Weeya ŋenaŋ man pɛte loŋ keŋ ke kɔŋ kaa wɔlɛɛ tɛɛle nɛ, na balaŋ ne dii na bɛɛ nyɔɔ. Baala ne yala ala na bɛɛ mo ala mɔ fa yale, kelii wee keŋ Nowa ba gyoo adakaa dinaa keŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Be ta gyeŋ kpene keŋ ne kɔŋ ya, kelii debaŋ keŋ loŋ be kaa waale kuu wɔ pou laŋ nɛ. Mena te maŋ Deniwalaŋ Bu ŋon ke kɔŋ gyae ke yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Debaŋ kenaŋ man na, baala bala baa kyaa wɔɔman bɛɛ yɛɛ tom. Wurubuarɛ waa mo ŋolo tina ŋolo yela. ");
INSERT INTO ntr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ala bala baa seŋ bɛɛ naŋ abɔɔ. Wurubuarɛ waa mo ŋolo tina ŋolo yela. ");
INSERT INTO ntr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mena dɔɔ ɛ doo ɛ wose dɔɔ, nawolo nyi ɛ ba gyeŋ wee keŋ ɛ gbeŋgyoo ŋon waa kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ɛ tɔɔse nyiaa, nyi dekpaŋalaŋte deŋ gyeŋ debaŋ keŋ ŋmɛɛlate waa kɔŋ kaa ŋmɛɛle e nɛ, nafɔ waa deke ɔ dekpaŋalaŋ keŋ nyi ŋmɛɛlate be nyiŋ gbɛɛ kaa gyoo kuu wa abɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mena dɔɔ ɛmɛɛ mɔ ɛ doo ɛ wose, nawolo nyi maŋ Deniwalaŋ Bu ŋon mɔ maa kɔŋ debaŋ keŋ ɛ loo be gyakaa ya. ");
INSERT INTO ntr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Keŋte ɔ besewɔ bɔɔse wɔ nyiaa, amɔte yɛna tobaale ŋon ɔ sia be kare te ɔ ne di ɔ gbeŋgyoo mmaraase dɔɔ? Ŋon yɛna tobaale ŋon ɔ gbeŋgyoo waa mo ɔ tebia akaŋ baŋ do ɔ nyiŋmaa man nyi waa kɛɛ be dɔɔ, na waa fa wɔ weenɛɛ debaŋ keŋ kaboena nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Akpaa tobaale ŋonaŋ seŋɛɛ ɔ tom man ɔ ne yɛɛ ke nideli mena, te ɔ gbeŋgyoo ŋon de kɔŋ kaa naa e na, ŋon na nyeebam. ");
INSERT INTO ntr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mɛɛ yako ŋon ɛ ke nyii nyiaa, mena tobaale ŋonaŋ ɔ gbeŋgyoo waa mo wa abɔɔ pou do e ɔ nyiŋmaa man nyi waa kɛɛ ŋe dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mɔna akpaa nyi tobaale ŋonaŋ yɛɛ tobaale kum e, te ɔ yɛɛ wa agyueŋ nyi ɔ gbeŋgyoo be gyae waa kɔŋ bileŋ ya, ");
INSERT INTO ntr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","te ɔ gyoo ɔ tebia akaŋ baŋ ketuku, te ŋon na soloŋ nyɔɔra ne dii bɛɛ nyɔɔ na, ");
INSERT INTO ntr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ɔ gbeŋgyoo ŋon waa kaa lee ɔ dɔɔ wee keŋ ɔ loo be gyakaa ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɔ gbeŋgyoo ŋon de kɔŋ kaa naa e mena na, waa wɔŋ ɔ deŋele nideli na waa gegi e lee ɔ gyaŋ, na waa yela ɔ kaa kyaa balaŋ baŋ bɛɛ beo ba wose nɛ gyaŋ. Botɔɔ te waa kyaŋ ɔ nyee wii na waa tao ɔ kela.” ");
INSERT INTO ntr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu besewɔ gyɔ dudu fa wɔ nyiaa, “Weeya ŋenaŋ man na Wurubuarɛ gyoori keŋ gyae ke yɛɛ ŋgba, alebia kufu baŋ bɔɔ koro mo be kanease be kaa gyaŋee na alowɔle baale nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Be man banoŋ yɛɛ ayiŋtenawɔ, te banoŋ mɔ yɛɛ siakaralatenawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ayiŋtena baŋ ka mo be kanease na, be ta gyem na baa mo nuŋse tela kpu na ŋan doo be kanease man nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mɔna siakaralatena baŋ dɔɔ, baŋ moo nuŋ do porontiase man tela kpu na ŋan doo be kanease man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Alowɔle baale ŋon te kɔŋ bileŋ ya, mena dɔɔ alebia baŋ pou moowɔ bee deŋeli te be doo dosoroŋ. ");
INSERT INTO ntr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ke lii tɛɛ nsana nɛ te akelelee yalawɔ nyiaa, ‘Alowɔle baale ŋon te kɔŋ! Ɛ lee kaa gyaŋee na e!’ ");
INSERT INTO ntr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Keŋte alebia kufu baŋ pou korowɔ te be gyinaa be kanea ŋmeeseŋ ŋan. ");
INSERT INTO ntr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Botɔɔ te ayiŋtena baŋ yako siakaralatena baŋ nyiaa, ‘De kanease na yekee, mena dɔɔ ɛ fa daa ɛ nuŋse ŋan kyomii.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Keŋte siakaralatena baŋ yako wɔ nyiaa, ‘Koa de nuŋse ŋan be gyae ka yee dɛɛ fa ŋon ya.’ Mena dɔɔ ɛ gyu donɔɔ man na ɛ kaa gyae ŋaale lɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mɔna debaŋ keŋ ayiŋtena baŋ be lam be kaa lɛɛ nuŋse ŋan nɛ te alowɔle baale ŋon kaa gyoowɔ. Alebia banoŋ baŋ bɔɔ desina ba wose see nɛ, gyoowɔ alowɔle nɔɔkedi deni keŋ man, te be kyaŋa disim keŋ tɔ. ");
INSERT INTO ntr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kenaŋ wɔle te alebia akaŋ baŋ mɔ kɔŋawɔ kaa gyoo. Keŋte be fae yeesa baake nyi, ‘De Gbeŋgyoo toro daa.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Keŋte alowɔle baale ŋon yako wɔ nyiaa, ‘Mɛɛ yako ŋon ɛ ke nyii nyiaa mɔɔ gyeŋ ŋon ya.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Botɔɔ te Yesu yako ɔ kaseela baŋ nyiaa, ‘Ɛ doo ɛ wose dɔɔ nideli, nawolo nyi ɛ ba gyeŋ wee yaa debaŋ keŋ maŋ Deniwalaŋ Bu ŋon maa bese kɔŋ ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu besewɔ gyɔ dudu fa wɔ nyiaa, “Debaŋ kenaŋ man na Wurubuarɛ gyoori keŋ gyae ke yɛɛ ŋgba balee ŋon ɔ ne gyae waa gyu gbɛɛ, te ɔ be baake ɔ tewulɛɛ te ɔ be kpɛlɛɛ wa abɔɔ do wɔ be nyiŋmaa man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔ faa walaŋ kamasɛ ŋgba mena keŋ waa tale tela nɛ. Ɔ faa ŋolo kɔba kakpoŋse anoŋ (5,000) te ɔ faa ŋolo kakpoŋse ala (2,000) te ɔ faa ŋolo mɔ kakpoŋ dokoloŋ (1,000). Keŋte ɔ korowɔ laŋ ɔ gbɛɛ keŋ. ");
INSERT INTO ntr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tobaale ŋon ɔ be fa e kakpoŋse anoŋ nɛ, korowɔ debokenaŋ man te ɔ moo kɔba keŋ ke yɛɛ tom te ɔ nyiŋa kakpoŋse anoŋ kpu bela. ");
INSERT INTO ntr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mena mɔ te ŋon ɔ be fa e kakpoŋse ala nɛ, nyiŋa kakpoŋse ala bela kpu. ");
INSERT INTO ntr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mɔna tobaale ŋon bɔɔ fa e kakpoŋ dokoloŋ nɛ, korowɔ ke wula bɔɔ te ɔ moo ɔ gbeŋgyoo kɔba keŋ kewuu. ");
INSERT INTO ntr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Be gbeŋgyoo ŋon kyaawɔ botɔɔ kyare pɛte ɔ kɔŋawɔ. Ɔ ke kɔŋ nɛ te ɔ baake ɔ tewulɛɛ baŋ gyaŋee nyi baa gyoo be kɔbase ŋan man. ");
INSERT INTO ntr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tobaale ŋon ɔ be fa e kɔba kakpoŋse anoŋ nɛ, moo kakpoŋse kufu kɔŋ te ɔ yako ɔ gbeŋgyoo ŋon nyiaa, kɛɛ kakpoŋse anoŋ te n faa maŋ mɔna me ta bese nyiŋ kakpoŋse anoŋ kpu bela. ");
INSERT INTO ntr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Keŋte ɔ gbeŋgyoo ŋon yako e nyiaa, ‘Ao baale kpaakpaa anokoarete, karaŋ na keyɛɛ. N te di anokoare lee kyomii maa moo fa neŋ kei man, mena dɔɔ maa mo abɔɔ burum do n nyiŋmaa man. Kɔŋ na dee di gyoŋ keŋ mee dii nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tobaale ŋon ɔ be fa e kɔba kakpoŋse ala nɛ mɔ kɔŋawɔ kaa yako e nyiaa, ‘Me gbeŋgyoo, n faa maŋ kakpoŋse ala, mɔna me te nyiŋ kakpoŋse ala kpu bela.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Keŋte ɔ gbeŋgyoo ŋon yako e nyiaa, ‘Tobaale kpaakpaa anokoarete, karaŋ na ke yɛɛ. N te di anokoare lee kyomii maa moo fa neŋ kei man, mena dɔɔ maa mo abɔɔ burum do n nyiŋmaa man. Kɔŋ na dee di gyoŋ keŋ mee dii nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tobaale ŋon ɔ be fa e kakpoŋ dokoloŋ nɛ mɔ kɔŋawɔ te ɔ yako ɔ gbeŋgyoo ŋon nyiaa, ‘Me gbeŋgyoo, ma gyeŋ nyi n nombia dana doŋ te botɔɔ keŋ n te duu kolo mɔ ya nɛ, botɔɔ te n ne kɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Me yee neŋ mena dɔɔ ma moo n kɔba keŋ ka weese bɔɔ man. Kɛɛ, n kɔba yaa, lɛɛ n woni.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Keŋte ɔ gbeŋgyoo ŋon yako e nyiaa, ‘N yɛɛ tobaale kum na kebɔŋalete e. N gyeŋ nyi mɛɛ kɔ abɔɔ botɔɔ keŋ me te duu ya, te mee yilaa abɔɔ botɔɔ keŋ ma te ŋmatee ya na, ");
INSERT INTO ntr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","weera n ta moo me kɔba ka see maŋ kɔba dɛɛsee man ya. Nafɔ ma ke kɔŋ kei na, ŋgba maa gyu ke lɛɛ keŋ na ka loŋ. Keŋte ɔ yako ɔ tewulɛɛ baŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ɛ lɛo kɔba keŋ lee ɔ gyaŋ na ɛ ka mo kpu ŋon ɔ be nyiŋ kakpoŋse kufu nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nawolo nyi walaŋ ŋon ɔ dana kolo na baa kpu e na waa nyiŋ burum, te ŋon ɔ be dana ya na, kyomii keŋ koraŋ ɔ dana nɛ baa lɛo ke lee ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mena dɔɔ ɛ fuŋ tobaale ohuhoo kei ŋon ɔ be dana tɔnɔɔ ya nɛ leki ditiŋtɛɛ keŋ man. Botɔɔ te waa kyaŋ ɔ nyee wii na waa tao ɔ kela.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Keŋte Yesu besewɔ yako wɔ nyiaa, “Debaŋ keŋ maŋ Deniwalaŋ Bu ŋon maa bese kɔŋ na, daa na Wurubuarɛ kpilala ne gyae la dɛɛ kɔŋ. Maa kɔŋ me gyoorobiiri man kaa kyaa me gyooro gbeli keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tɛɛle kei balaŋ pou baa kaa yilaa me gyaŋ, na maa kpase be man akpeŋ ala ŋgba mena keŋ wonembia kɛɛlere ne kpase asoose lee namense man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Maa mo namense baŋ see me dunoluŋ dɔɔ, na maa mo asoose baŋ see ma demena dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Botɔɔ te maŋ gyoo ŋon maa yako baŋ be kyaa ma dunoluŋ dɔɔ nɛ nyiaa, ‘Ɛmɛɛ baŋ me kya be hiraa ŋon. Ɛ kɔŋ kaa kyaa Wurubuarɛ gyoori keŋ ɔ be wulaa desina see ŋon leenaŋ debaŋ keŋ ɔ be yɛɛ tɛɛle kei nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nawolo nyi debaŋ keŋ tanam na ko maŋ na, ɛ faa maŋ weenɛɛ me diiwɔ. Debaŋ keŋ loŋboaneŋ na ko maŋ na ɛ faa maŋ loŋ me nyɔɔwɔ. Debaŋ keŋ me yɛɛ ŋɔɔle e na, ɛ lɛɛ maŋ gyu ya akpaŋalaŋse man, ");
INSERT INTO ntr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","debaŋ keŋ me dɔŋɛɛ diteŋteli na, ɛ faa maŋ abɔɔ ma doowɔ. Debaŋ keŋ mɛɛ wee na ɛ kaa kɛɛ me dɔɔ, debaŋ keŋ bɔɔ kyaŋ maŋ ketɔ deni na, ɛ ka doo maŋ nɔɔ.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Keŋte mena balaŋ kɛwɔ baŋ be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nɛ, baa bɔɔse gyoo ŋon nyiaa, ‘De gbeŋgyoo, woromɔ te de naa neŋ nyi tanam na ko neŋ te de faa neŋ weenɛɛ, yaa loŋboaneŋ na ko neŋ te de faa neŋ loŋ n nyɔɔwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Woromɔ te de naa neŋ nyi n yɛɛ ŋɔɔle te de lɛɛ neŋ gyu da akpaŋalaŋse man, yaa n dɔŋɛɛ diteŋteli te de faa neŋ abɔɔ n doowɔ? ");
INSERT INTO ntr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Woromɔ te de naa neŋ nyi n na wee, yaa ba te kyaŋ neŋ ketɔ deni te de kaa doo neŋ nɔɔ?’ ");
INSERT INTO ntr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Botɔɔ te maŋ gyoo ŋon maa tiranɔɔ fa wɔ nyiaa, ‘Ampaŋ yaa mɛɛ yako ŋon nyiaa, kpene kamasɛ keŋ ɛ be yɛɛ fa me balaŋ kɛwɔ man kemaasabii koraŋ na, maŋ yaa ɛ yɛɛwɔ fa!’ ");
INSERT INTO ntr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Botɔɔ te maa yako baŋ be kyaa ma demena dɔɔ nɛ nyiaa, ‘Ɛ seŋ lee me gyaŋ, ɛmɛɛ baŋ Wurubuarɛ be falaa ŋon nyi ya gyu ka gyoo boalaŋ degyapaa keŋ ɔ be desina see fa ɔbɔnsam na ɔ kpilala baŋ nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nawolo nyi tanam koo maŋ na, ɛ te fa maŋ weenɛɛ ya, loŋboaneŋ koo maŋ na ɛ te fa maŋ loŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Debaŋ keŋ me yɛɛ ŋɔɔle e na ɛ ta mo maŋ gyu ya akpaŋalaŋse man ya. Me tɛɛwɔ diteŋteli na, ɛ te fa maŋ kolo maa do ya. Ma weewɔ mɔna ɛ te kaa do maŋ nɔɔ ya, te be kyaŋa maŋ ketɔ deni, mɔna ɛ te kaa do maŋ nɔɔ ya.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Botɔɔ te balaŋ baŋ baa bɔɔse maŋ gyoo ŋon nyiaa, ‘De gbeŋgyoo woromɔ te de naa neŋ nyi tanam na ko neŋ, yaa loŋboaneŋ na ko neŋ, yaa n yɛɛ ŋɔɔle e yaa n dɔŋ diteŋteli yaa n weewɔ yaa be kyaŋa neŋ ketɔ deni te da te kyɔ neŋ ya?’ ");
INSERT INTO ntr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Keŋte maa tiranɔɔ fa wɔ nyiaa, ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, ‘Kpene keŋ ɛ be bɛɛ ɛ te yɛɛ fa me balaŋ kɛwɔ man kemaasabii koraŋ ya nɛ, na maŋ yaa ɛ bɛɛwɔ ɛ te yɛɛ fa ya.’ ");
INSERT INTO ntr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Botɔɔ te baa mo balaŋ benaŋ gyu botɔɔ keŋ baa naa diyem kekpaakekpaa nɛ, mɔna balaŋ baŋ be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nɛ dɔɔ, baa nyiŋ nyeedoŋ kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu kawola abɔɔ kɛŋa pou taŋ nɛ, ɔ yako ɔ kaseela baŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ŋgba ɛ gyeŋ nyi teka weeya ala na nyeekelɛɛwee kedi keŋ te lii. Debaŋ kenaŋ man te baa lese maŋ Deniwalaŋ Bu ŋon fa na baa gyɔ maŋ sakaa ɔpaŋdaŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Debaŋ kenaŋ man te Wurubuarɛ saese kegyiise na Gyudatena kegyiise gyuuwɔ ke gyaŋee saese pou kegyia Kaifase dekpaŋalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Keŋte be bakewɔ nyi baa yo kyaŋ Yesu na baa ko e. ");
INSERT INTO ntr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mɔna be yakowɔ nyi, “Tekaboena nyi dɛɛ ko e nyeekelɛɛwee kedi kei man ya, na mena ya na balaŋ baŋ baa yela donɔɔ keŋ ke siŋii.” ");
INSERT INTO ntr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kenaŋ wɔle na te Yesu gyuuwɔ Simɔn ŋon nafɔ ɔ na wee kawee yayam nɛ dɛɛ Bɛtani donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ɔ kekyaa botɔɔ nɛ, te alo ŋolo kɔŋawɔ ɔ gyaŋ na ɔ dana nuŋ ofoŋofoŋte keŋ ke dana koyadoŋ nɛ porontia tɔɔ. Keŋte ɔ toosi nuŋ keŋ woli Yesu nyeeman. ");
INSERT INTO ntr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ɔ kaseela baŋ kena kpene keŋ alo ŋon be yɛɛ nɛ, yɛɛ wɔ baŋ te be yakowɔ nyiaa, “Weera dɔɔ te ɔ ne wɔlɛɛ nuŋ kei mena.” ");
INSERT INTO ntr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Nafɔ beŋ yɔɔ nuŋ kei na, baa nyiŋ kɔba burum na baa mo fa ayematena.” ");
INSERT INTO ntr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na Yesu gyeŋ nombia ŋan bɛɛ gyueŋ nɛ te ɔ bɔɔse wɔ nyiaa, “Weera te ɛ ne kale na alo ŋon mena? Nombii kpaakpaa yaa ɔ yɛɛwɔ fa maŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ayematena dɔɔ be kyaa ɛ gyaŋ debaŋ kamasɛ, mɔna maŋ dɔɔ mɔɔ gyae maa kyaa ɛ gyaŋ debaŋ kamasɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mena keŋ ɔ be kyɛɛkee nuŋ kei woli maŋ nɛ, kei nawolo baa nyi ɔ te desina maŋ fa me kewuu. ");
INSERT INTO ntr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, tɛɛle kei dɔɔ yenaŋ kamasɛ keŋ baa kolosi Wurubuarɛ nombia kpaakpaa ŋan nɛ, baa yako alo kei nombii waa ayɛɛŋ kei na baa mo tɔɔse e.” ");
INSERT INTO ntr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kenaŋ wɔle nɛ, ɔ kaseela kufu bala baŋ man ŋolo, ŋon bɛɛ baake e nyi Gyudase Isekarɔte nɛ, korowɔ gyu saese kegyiise baŋ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Keŋte ɔ ke bɔɔse wɔ nyiaa, “Akpaa ma lese Yesu fa ŋon na, woŋ te ɛ ke fa maŋ?” Botɔɔ te be tiranɔɔ fa e nyi dɛɛ fa neŋ kɔba wolom bia sao na kufu (30) Te be kala kɔba keŋ do e ɔ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lee debaŋ kenaŋ te Gyudase fiasɛɛ ɔ ne gyae gbɛɛ keŋ waa mo lese Yesu fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nyeekelɛɛwee kedi wee gyaŋgbate keŋ bee di bodobodo keŋ tee be doo ke man ya nɛ, Yesu kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa bɔɔse e nyiaa, “Aleŋ te n ne gyae nyi de kaa desina see fa nyeekelɛɛwee weenɛɛ kedi keŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Keŋte ɔ yako wɔ nyiaa, “Ɛ gyu balee ŋolo gyaŋ Gyerusalɛm donɔɔ keŋ man na ɛ kaa yako e nyiaa, ‘De Gbeŋgyoo ŋon kpa ma debaŋ keŋ te lii, te n dekpaŋalaŋ man te ɔ ne gyae nyi ŋon na daa ɔ kaseela baŋ kaa di nyeekelɛɛ weenɛɛ ŋan.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Keŋte ɔ kaseela baŋ gyuuwɔ ke yɛɛ ŋgba mena keŋ ɔ be yako wɔ nɛ te be desina nyeekelɛɛ weenɛɛ ŋan see. ");
INSERT INTO ntr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kelii balinɔɔ nɛ, Yesu na ɔ kaseela kufu bala baŋ gyuuwɔ ke kyaa weenɛɛ ŋan dedii man. ");
INSERT INTO ntr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba ke kyaa bee dii nɛ Yesu yako ɔ kaseela baŋ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyi, ɛ man ŋolo waa lese maŋ fa.” ");
INSERT INTO ntr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lee nombia ŋan ɔ be yako wɔ nɛ dɔɔ, dekɔkɔrɔkɔɔ kyaŋa ɔ kaseela baŋ pou te be fiasɛɛ bɛɛ bɔɔse e dokoloŋ dokoloŋ nyiaa, “De gbeŋgyoo, maŋ yaa amɔte?” ");
INSERT INTO ntr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Walaŋ ŋon daa na e kyaa dɛɛ do nyiŋmaa nyefale dokoloŋ kei man nɛ, ŋon ne gyae la waa lese maŋ fa. ");
INSERT INTO ntr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Maŋ Deniwalaŋ Bu ŋon maa yeŋ ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see ne yako lee ma wose man nɛ, mɔna ŋon waa lese maŋ fa nɛ waa laako. Nafɔ beŋ ta lola walaŋ ŋonaŋ ya na, dei.” ");
INSERT INTO ntr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Keŋte Gyudase ŋon waa kaa lese Yesu fa nɛ mɔ bɔɔse e nyiaa, “Me Gbeŋgyoo, maŋ yaa amɔte?” Te Yesu tiranɔɔ fa e nyiaa, “Mena yaa nyaŋ gbagba yakowɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Be kee dii nɛ, Yesu moo bodobodo te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ kara ke mo fa ɔ kaseela baŋ. Keŋte ɔ yako wɔ nyiaa, “Ɛ lɛɛ di, kei yɛna ma wosenaane keŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kenaŋ wɔle te ɔ moo leenɔɔ keŋ te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ moo ke fa ɔ kaseela baŋ. Keŋte ɔ yako wɔ nyiaa “Ɛ popou ɛ lɛɛ nyɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Kei yɛna me fatabo keŋ Wurubuarɛ ba mo tɔ ŋon na ɔ balaŋ nɔɔkebakesee keŋ nɔɔ. Kei yɛna fatabo keŋ gyae ke kyɛɛkee leki, na Wurubuarɛ ka mo balaŋ burum nombiakumɛɛ kyɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ampaŋ yaa mɛɛ yako ŋon nyi mɔɔ gyae maa tekaa nyɔɔ soloŋ kei bela ya, kelii wee keŋ daa na ŋon dɛɛ nyɔɔ soloŋ wɔle me kya Wurubuarɛ gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kenaŋ wɔle nɛ, be kpee nɔɔneŋ lese Wurubuarɛ yele te ba leewɔ laŋ oliifi bula keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Gyɛŋ nelim kei nɛ ɛ popou ɛ ke yeu yela maŋ. Nawolo nyi Wurubuarɛ yakowɔ ɔ nombia aŋmaraseŋ see ŋan man lee ma wose man nyiaa, ‘Maa gyɔ namensekɛɛlere ŋon lɔ, na ɔ namense baŋ pou ke yaasee.’ ");
INSERT INTO ntr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mɔna me fom lee yeŋ man na, maa kyaŋ ŋon gbɛɛ gyu Galelia tɛɛle man.” ");
INSERT INTO ntr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Keŋte Pita yako e nyiaa, “Akpaa be popou de yeu tina neŋ yela koraŋ na, maŋ dɔɔ mɔɔ gyae maa tina neŋ yela korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Botɔɔ te Yesu yako Pita nyiaa, “Ampaŋ yaa mɛɛ yako neŋ nyi gyɛŋ nelim kei pɛte kegyim kelɔ woya nɛ, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Keŋte Pita tiranɔɔ fa e nyiaa, “Akpaa nyi ke yɛɛ yeŋ ke koraŋ na, mɔɔ gyae maa bɛɛ neŋ korakora ya.” Te ɔ kaseela akaŋ baŋ pou mɔ yakowɔ mena. ");
INSERT INTO ntr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kenaŋ wɔle nɛ, Yesu na ɔ kaseela baŋ gyuu yenaŋ daale keŋ bɛɛ baake botɔɔ nyi Gɛkyɛmane nɛ. Keŋte ɔ yako wɔ nyiaa, “Ɛ kyaa kɛbo, mee gyu siaman me kaa fane maa kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Keŋte ɔ moo Pita na Sebedeo bia bala baŋ kpu na ɔ wose. Botɔɔ te dekɔkɔrɔkɔɔ kyaŋa e keŋ nyi ɔ bɛɛ gyeŋ mena keŋ waa yɛɛ ɔ wose ya. ");
INSERT INTO ntr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Keŋte ɔ yako wɔ nyiaa, “Dekɔkɔrɔkɔɔ te kyaŋ maŋ gbaa keŋ nyi ne gyae ka ko maŋ. Ɛ kyaa kɛbo na ɛ ka deke.” ");
INSERT INTO ntr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Botɔɔ te Yesu tuuwɔ gyu siaman kyomii te ɔ tisiwɔ buŋ wuluŋu ɔ nyee te ɔ fanewɔ fa Wurubuarɛ nyiaa, “Taata, akpaa nyi gyae ke de na, yela mena kayeyɛɛ kei ke laŋ me dɔɔ. Mɔna na maŋ kegyaebii ya. Yɛɛ kpene keŋ nyaŋ gbagba ne gyae.” ");
INSERT INTO ntr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesu ka bese kɔŋ ɔ kaseela baŋ gyaŋ nɛ, ɔ kaa naawɔ nyi ba te doo dosoroŋ. Keŋte ɔ bɔɔse Pita nyiaa, “Mena dɔɔ ɛ te tale deke debaŋ dokoloŋ kooŋ keŋ nyi ɛ be doo yee?” ");
INSERT INTO ntr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Keŋte ɔ besewɔ yako wɔ nyiaa, “Ɛ deke na ɛ ke fane, na ɛ be nyiŋ ka gyoo kekɛɛsekɛɛ man ya. Nawolo nyi ma gyeŋ nyi ɛ konɔɔse man na ɛ ne gyae ɛ ke yɛɛ ma kegyaebii, mɔna ɛ wosenaane betaŋ mena doŋ kenaŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Keŋte Yesu besewɔ lee ɔ kaseela baŋ gyaŋ bolate gyu ke fane nyiaa, “Taata, nyi be gyae ke de nyi mena kayeyɛɛ kei ka lee me dɔɔ ya nɛ, kenaŋ na yɛɛ nyaŋ gbagba n kegyaebii” ");
INSERT INTO ntr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu ka bese kɔŋ nɛ, ɔ kaa naawɔ nyi ɔ kaseela baŋ sɛɛ be dokɛɛ, nawolo nyi dosoroŋ doo be siaman. ");
INSERT INTO ntr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Keŋte ɔ besewɔ lee be gyaŋ gyu ɔ kaa fane botoorote. Te ɔ fanewɔ yako nombii dokoloŋ kenaŋ ke bela. ");
INSERT INTO ntr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Keŋte ɔ besewɔ kɔŋ ɔ kaseela baŋ gyaŋ te ɔ kaa bɔɔse wɔ nyiaa, “Ɛ sɛɛ ɛ doo ɛ ne fɛɛfo? Ɛ kɛɛ, debaŋ keŋ te lii. Be ta lese maŋ Deniwalaŋ Bu ŋon do balaŋ kumɛɛ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ɛ koro dee gyu, ɛ kɛɛ walaŋ ŋon waa lese maŋ fa nɛ te tuŋ daa taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ke gyakaa ɔ ne kolosi nɛ, ɔ kaseela kufu bala baŋ maŋ ŋolo ŋon bɛɛ baake e nyi Gyudase nɛ kaa leewɔ botɔɔ. Ŋon na balaŋ dikpii keŋ bɔɔ lee saese kegyiise na donɔɔ kegyiise gyaŋ nɛ kɔŋala. Na be man baale dana yoosilase na akpokpose. ");
INSERT INTO ntr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gyudase ŋon waa kaa lese Yesu fa nɛ taŋ wulaa yako balaŋ baŋ nyiaa, “Walaŋ ŋon maa kaa pukaa e nɛ, ŋon yɛna walaŋ ŋon ɛ ne gyae nɛ. Ɛ kyaŋ e.” ");
INSERT INTO ntr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mena dɔɔ Gyudase tɛɛwɔ teeŋ gyu Yesu gyaŋ te ɔ baake e nyi “De Gbeŋgyoo, te ɔ pukaa e doo e nɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Keŋte Yesu yako e nyiaa, “Me gyoo, yɛɛ kpene keŋ dɔɔ n be kɔŋ kɛbo nɛ.” Botɔɔ te balaŋ baŋ kaa tɔɔ Yesu do te be kyaŋa e. ");
INSERT INTO ntr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Botɔɔ te Yesu kaseela baŋ maŋ ŋolo lese ɔ yoosila, te ɔ moowɔ kara saese pou kegyia ŋon tobaale deŋele lese ke lɔ. ");
INSERT INTO ntr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Keŋte Yesu yako ɔ kaseele ŋon nyiaa, “Mo n yoosila keŋ do ke bɔɔlee man. Nawolo nyi walaŋ kamasɛ ŋon ɔ ne wɔŋ yoosila na, waa yeŋ bo yoosila nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","N ba gyeŋ nyi maa tale sola me kya na waa yela ɔ kpilala kakpoŋkakpoŋse ka lee adido kɔŋ debokeiman kaa yoo lɛɛ maŋ yee? ");
INSERT INTO ntr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mɔna akpaa me yɛɛ mena na, sena te Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nyi, kaboena nyi mena nombia kɛŋa dɛɛkɔŋ nɛ, gyae ke yɛɛ ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Keŋte Yesu bɔɔse balaŋ dikpii keŋ bɔɔ kɔŋ be kaa kyaŋ e nɛ nyiaa, “Me yɛɛ walaŋkum e te ɛ moo yoosilase na akpokpose ɛ ne kɔŋ ɛ kaa kyaŋ maŋ? Wee kamasɛ na mɛɛ kyaa Wurubuarɛ ɔsom deni dinaa man wola ŋon Wurubuarɛ nombia, mɔna ɛ te kyaŋ maŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mɔna kɛŋa pou kɔŋae mena na nombia ŋan Wurubuarɛ akpeŋkpeŋgyɔɔra be ŋmarase see nɛ ke kɔŋ mena.” Botɔɔ te ɔ kaseela baŋ pou korowɔ yeu tina e yela. ");
INSERT INTO ntr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Balaŋ baŋ bɔɔ kyaŋ Yesu nɛ moo e gyu saese pou kegyia Kaifase dekpaŋalaŋ man, botɔɔ keŋ mmaraa wolala na donɔɔ kegyiise pou be gyaŋee nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita sila Yesu wɔle wɔle menɛɛ kelii saese kegyia ŋon dekpaŋalaŋ man. Ɔ gyoowɔ ke man te ɔ gyuuwɔ ke kyaa tewulɛɛ baŋ bee gyee dekpaŋalaŋ keŋ nɛ gyaŋ, na waa naa kpene gyae ke kɔŋ Yesu dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Saese kegyiise na donɔɔ kegyiise baŋ pou bɔɔ gyaŋee botɔɔ nɛ, ne gyae nombii keŋ baa mo gyakaa Yesu dɔɔ na baa nyiŋ gbɛɛ ko e. ");
INSERT INTO ntr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Balaŋ burum kɔŋawɔ kaa kɛrɛɛ Yesu nɔɔse, mɔna be te nyiŋ nombiikum keŋ baa mo gyakaa ɔ dɔɔ ya. Wɔle wɔle na te baala bala baale kɔŋawɔ kaa yako nyi, ");
INSERT INTO ntr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“De nyiiwɔ balee kei yakowɔ nyi ‘Waa tale tekerii Wurubuarɛ ɔsom deni dinaa kei lɔ, na waa mo weeya atooro ma ke bela.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Botɔɔ te saese kegyia ŋon korowɔ seŋ te ɔ bɔɔse Yesu nyiaa, “Nombia ŋan bɛɛ mo gyakaa n dɔɔ nɛ, n be tale tira ŋe nɔɔ yee?” ");
INSERT INTO ntr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mɔna Yesu te gyuusu ɔ nɔɔ ya. Keŋte saese kegyia ŋon yako Yesu nyiaa, “Ma te kɛɛ Wurubuarɛ ŋon ɔ kyaa kekpaakekpaa nɛ nae fa neŋ, akpaa nyaŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ, ŋon ɔ yɛɛ Wurubuarɛ bu dokoloŋ kooŋ ŋon e na, yako daa” ");
INSERT INTO ntr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Keŋte Yesu tiranɔɔ fa e nyiaa, “Keŋ yaa n yakowɔ nɛ. Mɔna mɛɛ yako ɛ popou ɛ ke nyii nyiaa, wee daale nɛ ɛ kena maŋ Deniwalaŋ Bu ŋon kyaa Wurubuarɛ doŋ pou gbeŋgyoo ŋon dunoluŋ dɔɔ, na ɛ ka bese naa maŋ na me ta lee ŋɔma man adido mɛɛ kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Saese kegyia ŋon ke nyii nombia kɛŋa nɛ, ɔ kyaŋa ɔ kegba tirii (Keŋ nawolo nyi nombia ŋan ta wee e gbaa) te ɔ yakowɔ nyiaa, “Ɔ te kolosi mmusuo nombia! Woŋ nombii yaa dɛɛ gyae dɛɛ tekaa nyii kpu bela? Nɛnɛɛ ɛmɛɛ gbagba ɛ nyii mmusuo nombia ŋan ɔ be kolosi nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sena yɛna ya agyueŋ lee nombia kɛŋa man?” Keŋte be tiranɔɔ nyi, “Ɔ kaboena yeŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Keŋte be tɔɔ nɔɔloŋse woli ɔ siagbɛɛ te be takee e akɔtase. Baale mɔ ŋmeree e ɔ lakaase man, ");
INSERT INTO ntr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","te be yako e nyiaa “Wurubuarɛ dekpeŋkpeŋgyɔɔre Kristo, wola daa ŋon ɔ be gyɔ neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Debaŋ kenaŋ na Pita kyaa dekpaŋalaŋ keŋ man. Keŋte saese kegyia ŋon alebu ŋolo kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, “Nyaŋ mɔ n kpuɛ na Yesu ŋon ɔ ba lee Galelia tɛɛle man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Keŋte Pita lɛɛ aŋmaareŋ balaŋ baŋ pou siaman botɔɔ nyiaa, “Mɔɔ gyeŋ nombia ŋan n ne yako nɛ man korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Te ɔ leewɔ gyu dekpaŋalaŋ keŋ denanɔɔ man. Botɔɔ te alebubii ŋolo mɔ besewɔ naa e te ɔ yako ɔ tebia baŋ be kyaa botɔɔ nɛ nyiaa, “Balee kei mɔ kpuɛ na Yesu ŋon ɔ ba lee Nasarɛte donɔɔ man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Keŋte Pita besewɔ lɛɛ aŋmaareŋ te ɔ kaŋa ntam nyiaa, “Mɔɔ gyeŋ balee kei korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te kyare ya nɛ, balaŋ baŋ be kyaa botɔɔ nɛ kɔŋawɔ Pita gyaŋ kaa yako e nyiaa, “Kei dɔɔ ke yɛɛ ampaŋ ke kaeŋ nyi nyaŋ mɔ n kpuɛ na balee kei. N kekolosi koraŋ nawolo nyi n yɛɛ be man ŋolo e.” ");
INSERT INTO ntr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Botɔɔ te Pita fiasɛɛ ɔ ne falaa ɔ wose te ɔ kaŋa ntam nyiaa, “Mɔɔ gyeŋ balee kei korakora ya.” Debokenaŋ man te kegyim lɔɔ woya. ");
INSERT INTO ntr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Keŋte Pita tɔɔse nombia ŋan Yesu be yako e nyiaa, “Pɛte kegyim ke lɔ woya na, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ ya” nɛ. Te Pita leewɔ debɔɔman ke kyaŋ ɔ nyee wii. ");
INSERT INTO ntr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tɛɛ kena nebo nebo fuu nɛ, saese kegyiise na donɔɔ kegyiise baŋ gyaŋeewɔ te be yakowɔ sɛɛ dɔŋa nyi baa ko Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mena dɔɔ be bake e te ba moo e gyu ka do Pilato ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man nɛ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gyudase ŋon ɔ ba lese Yesu fa kena nyi be te bu Yesu fɔɔ nyi baa ko e nɛ, takaa e nideli te ɔ kyɛɛkee wa agyueŋ. Mena dɔɔ ɔ besena kɔba keŋ ɔ be lɛɛ Yesu nyeeman nɛ gyina kegyiise baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Keŋte ɔ yako wɔ nyiaa, “Ma te yɛɛ nombiakumɛɛ ŋgba mɔɔ lese walaŋ ŋon dukum kamasɛ be doo ɔ man ya fa ŋon nɛ.” Te kegyiise baŋ mɔ tiranɔɔ fa e nyiaa, daa be famenɛ na ŋenaŋ ya. Ŋe yɛɛ nyaŋ gbagba n nombia ŋa. ");
INSERT INTO ntr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Botɔɔ te Gyudase fuŋa kɔba keŋ lɔ wɔ Wurubuarɛ ɔsom deni dinaa keŋ man, te ɔ gyuuwɔ kado ɔ wose ŋmeleŋ. ");
INSERT INTO ntr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Keŋte saese kegyiise baŋ tɔɔsee kɔba ŋan te be yakowɔ nyiaa, “Da mmaraa bɛɛ fa daa gbɛɛ nyi dɛɛ mo kɔba kei kyakale na dɔ ɔsom deni kɔba man ya. Nawolo nyi kɔba keŋ dana ayimɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Keŋte kegyiise baŋ moo ba nyeeya baŋ na dɔŋa te be sɛɛwɔ nyi, baa mo kɔba kenaŋ ke lɛɛ tɛɛle saabuse maare ŋolo gyaŋ, na baa kyaa wuu ŋɔɔla botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mena dɔɔ kaa lii naŋ gyɛŋ nɛ, bɛɛ baake tɛɛle kenaŋ bo nyi fatabo tɛɛle. ");
INSERT INTO ntr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kɛŋa pou yela Wurubuarɛ nombia ŋan ɔ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Gyeremia dɔɔ yako see nɛ kɔŋawɔ mena. Ɔ yakowɔ nyiaa, “Ba moo kɔba wolom bia sao na kufu 30 ŋan ŋe yɛɛ koya keŋ Iseraetena be dii ɔ nyeeman nɛ, ");
INSERT INTO ntr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ke lɛɛ tɛɛle saabuse maare gyaŋ ŋgba mena keŋ de Gbeŋgyoo Wurubuarɛ ba wola maŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Keŋte ba moo Yesu kaa seŋ Pilato ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man nɛ siaman. Te Pilato bɔɔse e nyiaa, “Nyaŋ yɛna Gyudatena gyoo ŋon?” Te Yesu tiranɔɔ fa e nyiaa, “Keŋ yaa n yakowɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mɔna debaŋ keŋ saese kegyiise na donɔɔ kegyiise ba mo nombia gyakaa Yesu dɔɔ nɛ, ɔ te gyuusu ɔ nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Botɔɔ te Pilato bɔɔse Yesu nyiaa, “Nombia burum kɛŋa bɛɛ mo gyakaa n dɔɔ nɛ, n bee nyii yee?” ");
INSERT INTO ntr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mɔna Yesu bɛe ɔ te gyuusu ɔ nɔɔ yako nombii dokoloŋ kooŋ gba ya. Nombii kei doo Pilato nɔɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gyudatena nyeekelɛɛwee kedi wee kamasɛ nɛ, kaboena nyi Pilato ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man nɛ, waa tina balaŋ baŋ bɔɔ kyam tɔ deni nɛ man dokoloŋ, ŋon balaŋ benaŋ gbagba ne gyae nɛ yela fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mena debaŋ kenaŋ na Barabase ŋon ɔ yɛɛ nombiakumɛɛyɛɛre e, te balaŋ pou be nyii ɔ nombia nɛ doo deni man. ");
INSERT INTO ntr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Balaŋ dikpii keŋ ke kɔŋ kaa yilaa nɛ Pilato bɔɔse wɔ nyiaa, “Balaŋ bala kɛwɔ man na be man woŋti te ɛ ne gyae nyi maa tina yela fa ŋon. Barabase yaa Yesu ŋon bɛɛ baake e nyi Kristo nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nawolo nyi na Pilato gyeŋ nyi, keŋ balaŋ baŋ ne kɔla Yesu dɔɔ te ba lese e fa. ");
INSERT INTO ntr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato kekyaa ɔ ne di nombia ŋan nɛ, ɔ wɛɛle kpilawɔ kaa yako e nyiaa, “Lese n nyiŋmaase lee mena walaŋ ŋon nombiikum kamasɛ be doo ɔ man ya nɛ nombia man. Nawolo nyi nelim me doosi dosɛɛ ŋaale lee ɔ wose man na, yɛɛ maŋ gyakoloŋ te me naa diyem nideli.” ");
INSERT INTO ntr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mɔna Wurubuarɛ saese kegyiise na kegyiise akaŋ baŋ feefuwɔ do balaŋ dikpii keŋ nyi, baa sola Pilato na waa tina Barabase yela na baa ko Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Keŋte Pilato besewɔ bɔɔse balaŋ baŋ nyiaa, “Balaŋ bala kɛwɔ man na, be man woŋti te ɛ ne gyae nyi maa tina e yela?” Te be tiranɔɔ fa nyiaa, “Tina Barabase yela fa daa.” ");
INSERT INTO ntr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Keŋte Pilato besewɔ bɔɔse wɔ nyiaa, “Kenaŋ na sena te maa yɛɛ Yesu ŋon bɛɛ baake nyi Kristo nɛ?” Botɔɔ te be popou yakowɔ nyi, “Yela baa gyɔ e sakaa ɔpaŋdaŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Keŋte Pilato bɔɔse wɔ nyiaa, “Woŋ dukum te ɔ yɛɛwɔ?” Mɔna be sɛɛ bɛɛ fae yeesa nedoŋ nyiaa, “Yela baa gyɔ e sakaa ɔpaŋdaŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato kena nyi balaŋ baŋ nɔɔwoya na kela e te ɔ be gyae waa tale yɛɛ kolo lee Yesu wose man ya nɛ, ɔ kyee loŋ faafo ɔ nyiŋmaase balaŋ dikpii keŋ siaman te ɔ yako wɔ nyiaa, “Maŋ nyiŋmaa be doo balee kei yeŋ man korakora ya. Ke yɛɛ ɛmɛɛ gbagba ɛ nombia ŋa.” ");
INSERT INTO ntr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Keŋte balaŋ baŋ pou sɛɛwɔ yako nyiaa, “Deŋele kewɔŋ keŋ gyae ke kɔŋ lee ɔ kako wose man nɛ, dɛɛkɔŋ daa na de bia dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mena dɔɔ Pilato tinaa Barabase yela fa wɔ, te ɔ yela ba ŋmeree Yesu dambiise te ɔ moo e fa yoonɔɔtena baŋ nyi baa gyu ke gyɔ e sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Keŋte Pilato yoonɔɔtena baŋ moo Yesu gyu ŋon Pilato dekpaŋalaŋ man, te be baake yoonɔɔtena akaŋ baŋ pou kaa gyaŋee kilisi Yesu. ");
INSERT INTO ntr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Be kyaŋa ɔ kegbase kpee te ba moo kegba yayam wurikyim daale ŋgba ŋan Romantena gyooneŋ na doo nɛ do e. ");
INSERT INTO ntr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Keŋte ba moo sɔɔse loo gyooro kotɔtɔɔ wuu e, te ba moo gbutu do e ɔ dunoluŋ nyiŋmaa man na bɛɛ buŋ ɔ siaman kulu e nyiaa, “Gyudatena gyoo nyaŋ na ke yɛɛ. N nyee dɛɛ wolose.” ");
INSERT INTO ntr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Be tɔɔ nɔɔloŋse woli e, te be lɛo ɔ gbutu keŋ mo ŋmeree e ɔ nyee man. ");
INSERT INTO ntr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Be ke kulu e taŋ nɛ, te ba kpee kegba yayam keŋ bɔɔ mo do nɛ te ba moo ŋon gbagba wui abɔɔ do e. Te ba moo lee be kaa gyɔ e sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Be ka lee debɔɔ man bee gyu nɛ, te be gyaŋee na balee ŋolo ŋon ɔ ba lee Kirene te bɛɛ baake e nyi Simɔn nɛ. Keŋte ba ŋere e nyi waa lɛɛ Yesu ɔpaŋdaŋ keŋ seele. ");
INSERT INTO ntr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Keŋte be gyuuwɔ ka gyoo botɔɔ keŋ bɛɛ baake nyi “Golgata,” keŋ nawolo nyi Nyeepookoo dɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Botɔɔ te ba moo tee ŋaŋte daale mo kyakale na soloŋ fa Yesu nyi waa nyɔɔ. Mɔna ɔ ke daa ke kɛɛ nɛ te ɔ bɛɛwɔ nyi ɔ be nyɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba ke gyɔ e sakaa ɔpaŋdaŋ dɔɔ nɛ, te be kpɛlɛɛ ɔ kegbase buŋii te be lɔɔ boe ŋe dɔɔ na baa naa keŋ walaŋ kamasɛ waa nyiŋ. ");
INSERT INTO ntr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kenaŋ wɔle nɛ, te be kyaawɔ botɔɔ bɛɛ deke e. ");
INSERT INTO ntr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Keŋte be ŋmarase nombii keŋ dɔɔ bɔɔ gyɔ e ɔpaŋdaŋ dɔɔ nɛ mataa ɔ nyee gbɛɛ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Botɔɔ te be gyɔɔ ŋmɛɛlatena bala baale sakaa ɔpaŋdaase dɔɔ kpu na Yesu. Ŋolo sakaa ɔ dunoluŋ dɔɔ te ŋolo mɔ sakaa ɔ demena dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na balaŋ baŋ bɛɛ lam botɔɔ nɛ na tee e na bee kpiisi ba nyeeya, ");
INSERT INTO ntr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na bɛɛ yako e nyiaa, “Nyaŋ ŋon n kpa n ke tekerii Wurubuarɛ ɔsom deni dinaa keŋ na n ka mo weeya atooro ma ke nɛ, lɛɛ n wose na dɛɛ kɛɛ. Akpaa nyaŋ yɛna Wurubuarɛ bu ŋon na, lɛɛ n wose na n ke tisi lee ɔpaŋdaŋ keŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mena mɔ te saese kegyiise na mmaraa wolala na donɔɔ kegyiise baŋ mɔ kulu e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ɔ ne lɛɛ balaŋ nyee, mɔna ɔ be tale lɛɛ ŋon gbagba wose ya. Ŋgba n kpa nyaŋ yɛna Iseraetena gyoo ŋon, tisi lee daŋ keŋ dɔɔ na dɛɛ lɛɛ neŋ di. ");
INSERT INTO ntr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔ na mo ɔ wose lɔ Wurubuarɛ dɔɔ te ɔ ne yako nyi, ‘Ŋon yɛna Wurubuarɛ bu. Akpaa Wurubuarɛ ne gyae e na, ɛ yela dɛɛ kɛɛ nyi waa lɛɛ e.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mena mɔ te nombiakumɛɛyɛɛra baŋ bɔɔ gyɔɔ wɔ sakaa ɔpaŋdaase dɔɔ kpu na e nɛ mɔ kulu e. ");
INSERT INTO ntr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lee weese kaseŋ dɛɛ kelii ɔ ke gɛɛse nɛ, ditiŋtɛɛ kaa lɛɛ tɛɛle keŋ dɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Debaŋ kenaŋ nɛ, te Yesu fae yeesa keŋkeŋ nyiaa, “Eli, Eli lama sabatani?” Keŋ nawolo nyi, “Me Wurubuarɛ me Wurubuarɛ, weera te n lese n sia yela maŋ?” ");
INSERT INTO ntr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Balaŋ baŋ ba seŋɛɛ botɔɔ ke nyii mena nɛ be yakowɔ nyiaa, “Ɛ nyii, ɔ ne baake Elaegya.” ");
INSERT INTO ntr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Debokenaŋ man te be man ŋolo yeuwɔ ka mo kolo ŋgba kokyaa keŋ gyae ke tale lɛɛ loŋ nɛ do soloŋ denyaŋesa daale man, te ɔ moo ke tooso na daŋ te ɔ gyinaa ke adido fa Yesu nyi waa nyɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Keŋte balaŋ akaŋ baŋ yakowɔ nyiaa, “Ɛ yela dɛɛ kɛɛ nyi Elaegya waa kɔŋ kaa lɛɛ e?” ");
INSERT INTO ntr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Keŋte Yesu besewɔ fae yeesa keŋkeŋ te ɔ kara weesi. ");
INSERT INTO ntr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kekɔŋ mena nɛ, kanyaŋ keŋ bɔɔ mo kpase Wurubuarɛ ɔsom deni dinaa keŋ man nɛ bɛɛsewɔ kyɛɛkyɛɛ ala lee adido kaa lii ka mokɔɔ man. Tɛɛle wosiwɔ, te boya dinaana mɔ yɛlɛɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yebɔɔse gyuusuwɔ te Wurubuarɛ gyuusu ɔ balaŋ baŋ be gbɛɛneŋ tenɛɛ ɔ siaman te bɔɔ yekee nɛ, man balaŋ burum lee ba yebɔɔse man. ");
INSERT INTO ntr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu kefoŋ lee yeŋ man nɛ, Wurubuarɛ balaŋ baŋ bɔɔ foŋii lee ba yebɔɔse man nɛ, gyuu Gyerusalɛm donɔɔ man ka lese ba wose wola balaŋ burum. ");
INSERT INTO ntr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Romantena yoonɔɔtena siamante ŋon na baŋ ba seŋɛɛ bɛɛ gyee Yesu nɛ kena tɛɛle kewosi na gyakoloŋ nombia ŋan be yɛɛ pou nɛ, ba wose yeŋa wɔ te be yakowɔ nyiaa, “Balee kei yɛna Wurubuarɛ bu ŋon ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na ala burum baale mɔ seŋɛɛ yenaŋ botɔɔ lemlem bɛɛ kɛɛ. Be wulaa be silana Yesu leenaŋ Galelia donɔɔ man bɛɛ kɛɛ ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ala benaŋ man baale yɛna Mɛɛre ŋon ɔ ba lee Magedala nɛ, na Gyemisi na Gyosɛfo be naa Mɛɛre, na Sebedeo bia baŋ be naa. ");
INSERT INTO ntr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kelii balinɔɔ nɛ kɔbate ŋolo ŋon bɛɛ baake e nyi Gyosɛfo, ŋon ɔ ba lee Arimatia donɔɔ man nɛ kɔŋawɔ botɔɔ. Na ŋon mɔ yɛɛ Yesu silala baŋ man ŋolo e. ");
INSERT INTO ntr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɔ gyuu Pilato gyaŋ ka sola e nyi waa fa e gbɛɛ na waa mo Yesu woo ŋon ke wuu. Keŋte Pilato sɛɛwɔ nyi baa moo Yesu woo ŋon fa e. ");
INSERT INTO ntr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Keŋte Gyosɛfo moo woo ŋon, te ɔ moo akaralɛɛ wɔle wɔle daale milii e. ");
INSERT INTO ntr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te ɔ moo e ke wuu boe bɔɔ wɔle keŋ ŋon Gyosɛfo gbagba be kare see ɔ wose nɛ man. Keŋte ɔ biliŋi boe dinaa daale tɔ yebɔɔ keŋ nɔɔ te ɔ laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Mɛɛre ŋon ɔ ba lee Magedala nɛ, na Mɛɛre balate ŋon baŋɛɛ botɔɔ be sia tee na yebɔɔ keŋ. ");
INSERT INTO ntr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tɛɛ kena keŋ ke yɛɛ Gyudatena kefɛɛfowee ke nɛ, Wurubuarɛ saese kegyiise na Farasiitena baŋ gyuuwɔ ke gyaŋee Pilato dekpaŋalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Keŋte be yako Pilato nyiaa, “Kegyia dɛɛ tɔɔse nyi Yesu dekarate ŋon ke kyaa keŋ nɛ ɔ yakowɔ nyiaa, weeya atoorote wɔle na waa foŋ lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mena dɔɔ yela be kaa deke yebɔɔ keŋ na baa gyee ke nideli kelii weeya atoorote keŋ. Na mena ya na ɔ kaseela baŋ baa yo gyu ke ŋmɛɛle e lese na baa yako nyi, ɔ foŋae lee yeŋ man. Na mena ya na, dekara alate kei gyae ka kela gyaŋgba te keŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Keŋte Pilato yako wɔ nyiaa, ɛ lese ɛmɛɛ gbagba ɛ balaŋ na baa gyu ka deke yebɔɔ keŋ nideli fa ŋon ŋgba mena keŋ baa tale nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mena dɔɔ be gyuuwɔ ke desina yebɔɔ keŋ tɔ nideli keŋ nyi ŋolo na ŋolo be tale tɛɛse boe keŋ lee ke nɔɔ man ya. Keŋte ba lese balaŋ nyi baa gyee yebɔɔ keŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gyudatena kefɛɛfowee wɔle tɛɛ kena nebo nebo fuu nɛ, Mɛɛre ŋon ɔ ba lee Magedala na Mɛɛre balate ŋon korowɔ gyu botɔɔ keŋ bɔɔ wuu Yesu nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Debaŋ kenaŋ nɛ tɛɛle wosiwɔ nawolo nyi de Gbeŋgyoo Wurubuarɛ kpilale te tisi lee adido kɔŋ kaa biliŋi boe keŋ see yenaŋ, te ɔ tisiwɔ kyaa ke dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na Wurubuarɛ kpilale ŋon ne ŋalakee ŋgba ɔga keŋmaale nɛ, te ɔ kegba wolosɛɛ futututu ŋgba akaralɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Balaŋ baŋ bɛɛ deke yebɔɔ keŋ kena Wurubuarɛ kpilale ŋon nɛ, gyakoloŋ gyoo wɔ nideli te be dɔɔwɔ ba seŋɛɛ botɔɔ ŋgba woya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Keŋte Wurubuarɛ kpilale ŋon yako ala baŋ nyiaa, “Ɛ na yee ya, ma gyeŋ nyi Yesu ŋon bɔɔ gyɔɔ sakaa ɔpaŋdaŋ dɔɔ nɛ yaa ɛ ne kɛo. ");
INSERT INTO ntr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ be kyaa kɛbo ya. Ɔ te fom lee woya man ŋgba mena keŋ ɔ be yako see nɛ. Ɛ kɔŋ kaa kɛɛ ɔ dedoi man, ");
INSERT INTO ntr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","na ɛ ke ta bileŋbileŋ ke yako ɔ kaseela baŋ nyiaa ‘Ɔ te fom lee woya man te ɔ te kyaŋ ŋon gbɛɛ ɔ ne gyu Galelia tɛɛle man. Botɔɔ te ɛ kena e. Kei yɛna nombii keŋ me dana maa yako ŋon.’ ” ");
INSERT INTO ntr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Keŋte ala baŋ moo gyakoloŋ yeu lee yebɔɔ keŋ gyaŋ. Mɔna yɛɛ wɔ gyoŋ te be yeuwɔ gyu be kaa yako ɔ kaseela baŋ. ");
INSERT INTO ntr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Karatetee dokoloŋ te Yesu gyaŋee na ala baŋ te ɔ doo wɔ nɔɔ nyiaa, “Wurubuarɛ waa fa ŋon wosefɛɛreŋ.” Keŋte ala baŋ tuuwɔ benaa e te be tisiwɔ buŋ kyaŋ ɔ nawɔɔ som e. ");
INSERT INTO ntr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Keŋte Yesu yako wɔ nyiaa, “Ɛ na yee ya, ɛ gyu ke yako me tebia baŋ nyiaa, baa gyu Galelia tɛɛle man. Botɔɔ te baa naa maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Debaŋ keŋ ala baŋ ne gyuu nɛ, yoonɔɔtena baŋ bee gyee yebɔɔ keŋ nɛ man baale gyuuwɔ donɔɔ man ke yako Wurubuarɛ saese kegyiise kpene kamasɛ keŋ be kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Botɔɔ te Wurubuarɛ saese kegyiise na donɔɔ kegyiise baŋ gyaŋeewɔ, te be bakewɔ te be faa yoonɔɔtena baŋ bɛɛ deke yebɔɔ keŋ nɛ kɔba burum daale, ");
INSERT INTO ntr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na baa yako nyi nelim ba ke doo na, te Yesu kaseela baŋ kɔŋawɔ kaa ŋmɛɛle ɔ woo ŋon. ");
INSERT INTO ntr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te be yako wɔ nyi akpaa Pilato de nyii nombia kɛŋa na, daa dee gyu kekolosi na e na dɛɛ lese ŋon lee nombia man. ");
INSERT INTO ntr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mena dɔɔ yoonɔɔtena baŋ lɛɛ kɔba keŋ te be gyuuwɔ ke yɛɛ ŋgba mena keŋ kegyiise baŋ be yako wɔ nɛ. Mena nombia kɛŋa te yaasee Gyudatena tɛɛle man kaa lii na gyɛŋ. ");
INSERT INTO ntr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mena dɔɔ Yesu kaseela kufu daale akaŋ baŋ gyuuwɔ Galelia tɛɛle man, te be gyuu bula keŋ dɔɔ Yesu ba wola wɔ nyi baa gyu nɛ. ");
INSERT INTO ntr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Botɔɔ te Yesu ka lese ɔ wose wola wɔ te be buŋawɔ som e, mɔna be man baale te lɛɛ di ya. ");
INSERT INTO ntr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Keŋte Yesu tuuwɔ benaa wɔ te ɔ yako wɔ nyiaa, “Wurubuarɛ te fa maŋ doŋ adido na tɛɛle kei pou dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mena dɔɔ ɛ gyu tɛɛle kei pou dɔɔ na ɛ kaa wola balaŋ na baa bese me kaseela. Ɛ sɔ wɔ Wurubuarɛ loŋ lee Wurubuarɛ kya ŋon na ɔ Bu ŋon na ɔ Feliŋ ŋon yele man. ");
INSERT INTO ntr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na ɛ ka wola wɔ na baa di kpene kamasɛ keŋ mɔɔ faree ŋon nɛ dɔɔ. Te mɛɛ yako ŋon ɛ ke nyii nyiaa, me kpuɛ na ŋon debaŋ kamasɛ kelii tɛɛle kei ɔto.”");
INSERT INTO ntr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wurubuarɛ bu Yesu Kristo nombia kpaakpaa ŋan kewalaŋ yaa. ");
INSERT INTO ntr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wurubuarɛ kpila tobaale ŋon bɛɛ baake nyi Gyɔn nɛ nyi waa kyaŋ Yesu gbɛɛ kɔŋ, ŋgba mena keŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon bɛɛ baake e nyi Yesaya be yako Wurubuarɛ nombia aŋmaraseŋ see ŋan man nɛ. Ɔ yakowɔ nyiaa, “Kɛɛ! Mee kpila me kpilale na waa ta n siaman. Ŋon ne gyae la waa desina n gbɛɛneŋ see neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya besewɔ yako Gyɔn wose man nombia Wurubuarɛ nombia aŋmaraseŋ see ŋan man bela nyiaa, “Ŋolo ne fae yeesa depampaa dinaa keŋ man nyiaa, ‘Ɛ desina de Gbeŋgyoo gbɛɛnaa, na ɛ ke yela ɔ gbɛɛneŋ pou ka tenee.’ ” ");
INSERT INTO ntr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mena dɔɔ kɔŋawɔ ampaŋ nyiaa, Gyɔn ŋon ɔ ne sɔ balaŋ Wurubuarɛ loŋ nɛ kyaawɔ depampaa dinaa keŋ man. Na ɔ ne kolosi fa balaŋ nyi baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa kɔŋ Wurubuarɛ gyaŋ, na baa sɔ wɔ Wurubuarɛ loŋ na Wurubuarɛ ka mo be nombiakumɛɛ kyɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mena dɔɔ balaŋ burum leewɔ Gyudia tɛɛlese pou man, na Gyerusalɛm donɔɔ man gyu ketɔlɛɛ be nombiakumɛɛ ŋan bɛɛ yɛɛ nɛ fa Gyɔn, te ɔ sɔɔ wɔ Wurubuarɛ loŋ Gyɔɔdan boo man. ");
INSERT INTO ntr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na kurumɔɔ tɔne te ba moowɔ ŋara Gyɔn kegba, te wonembu tɔne te ɔ moowɔ yɛɛ abɔsɔɔ kpaŋ ɔ teŋa man. Akpataana na teebɔɔ yɛna ɔ weenɛɛ ŋan ɔ ne dii. ");
INSERT INTO ntr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Keŋte Gyɔn yako balaŋ baŋ nyiaa, “Walaŋ ŋolo dɔŋ me wɔle ɔ ne kɔŋ keŋ ɔ kela maŋ. Maŋ tekaboena nyi maa buŋ booli ɔtenate nkyokota ŋmeeseŋ gba ya. ");
INSERT INTO ntr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Maŋ dɔɔ loŋ te maŋ dana mɛɛ sɔ ŋon Wurubuarɛ loŋ, mɔna akpaa ŋon de kɔŋ na Wurubuarɛ feliŋ te waa mo sɔ ŋon Wurubuarɛ loŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gyɔn kɛɛ sɔ balaŋ Wurubuarɛ loŋ nɛ, te Yesu leewɔ Nasarɛte donɔɔ keŋ ke kyaa Galelia tɛɛle man nɛ kɔŋ, te Gyɔn sɔɔ e Wurubuarɛ loŋ Gyɔɔdan boo man. ");
INSERT INTO ntr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu ka mo waa lee loŋ keŋ man nɛ, karatetee dokoloŋ te ɔ naawɔ na adido ta toro, te Wurubuarɛ feliŋ ŋon moo duwuluŋ dinɔɔ tisi lee adido kaa gyakaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Botɔɔ te be nyii woya ŋaale kolosiwɔ lee adido yako nyiaa, “Nyaŋ yɛna me bu ŋon mɛɛ gyae lee me konɔɔ man, te n na gyoo me sia nideli.” ");
INSERT INTO ntr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Debokenaŋ man te Wurubuarɛ feliŋ ŋon yela Yesu gyuuwɔ depampaa dinaa daale man. ");
INSERT INTO ntr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu kyaawɔ depampaa kenaŋ man weeya sɔŋola (40). Ɔ kekyaa botɔɔ nɛ, te ɔbɔnsam kɔŋawɔ kaa kɛɛse e kɛɛse e kina. Na Yesu kyae ŋale man wonembia man, te Wurubuarɛ kpilala leewɔ adido kɔŋ kaa kɛɛ ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Te di weeya ala ya te be kyaŋa Gyɔn tɔ deni. Ba ke kyaŋ e tɔ deni wɔle nɛ, Yesu kɔŋawɔ Galelia tɛɛle dɔɔ ɔ ne kolosi Wurubuarɛ nombia kpaakpaa ŋan fa balaŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Debaŋ keŋ te lii, te Wurubuarɛ gyoori keŋ mɔ ta benaa. Ɛ kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man kɔŋ Wurubuarɛ gyaŋ, na ɛ ke lɛɛ nombia kpaakpaa ŋan di!” ");
INSERT INTO ntr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Keŋte Yesu gyuuwɔ ka mo Galelia boo nɔɔman. Botɔɔ te ɔ naa Simɔn na ɔ naabu Anderiase na bɛɛ lɔ asawuse boo keŋ man, nawolo nyi be yɛɛ kpɛɛ kyaŋarawɔ. ");
INSERT INTO ntr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Keŋte Yesu yako wɔ nyiaa, “Ɛ kaa sila maŋ, na maa yela ɛ ke yilaa balaŋ fa maŋ ŋgba mena keŋ ɛ ne kyaŋ kpɛɛ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Debokenaŋ man te be tinaa ba asawuse ŋan yela, te be kaa sila Yesu. ");
INSERT INTO ntr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔ ke gyu ɔ siaman kyomii nɛ, ɔ naa Sebedeo bia Gyemisi na ɔ naabu Gyɔn na be doo ba degbele man bee desina ba asawuse. ");
INSERT INTO ntr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Debokenaŋ man te Yesu baake wɔ, te be tinaa be kya Sebedeo na be paasetena baŋ pou yela degbele keŋ man te be kaa sila Yesu. ");
INSERT INTO ntr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Keŋte be gyuuwɔ Kapanum donɔɔ man. Te Gyudatena kefɛɛfowee kelii nɛ, Yesu gyuuwɔ bɔ ɔsom deni man ɔ kaa wola wɔ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yesu kawola keŋ doo balaŋ baŋ pou nɔɔ. Nawolo nyi ɔ ne gyɔ ɔ konɔɔ wola ŋgba walaŋ ŋon ɔ dana doŋ nombia ŋan ɔ na wolo nɛ dɔɔ nɛ. Ɔ kawola keŋ te yɛɛ ŋgba Gyudatena mmaraa wolala baŋ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Debaŋ kenaŋ na balee ŋolo kyaa bɔ ɔsom deni man botɔɔ keŋ feliŋkum doo ɔ man. Karatetee dokoloŋ te ɔ fae yeesa keŋkeŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nyaŋ Yesu Nasarɛte baale, woŋ yaa n ne gyae de gyaŋ? N kɔŋae n kaa wɔlɛɛ daa? Ma gyeŋ neŋ nyi nyaŋ yɛna Wurubuarɛ walaŋ ŋon ayimɛɛ be doo n man ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Botɔɔ te Yesu faree feliŋkum keŋ nyiaa, “Wu n nɔɔ, na n ka lee ɔ man.” ");
INSERT INTO ntr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Keŋte feliŋkum keŋ wosi balee ŋon nideli, te ke fae yeesa keŋkeŋ te ka leewɔ ɔ man laŋ. ");
INSERT INTO ntr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nombii kei doo balaŋ baŋ pou nɔɔ te be bɔɔse dɔŋa nyiaa, “Woŋ nombii yaa? Kawola wɔle? Ɔ dana doŋ feliŋkumɛɛ dɔɔ, keŋ nyi ɔ ne kolosi fa ŋa na ŋee nyii ɔ dei.” ");
INSERT INTO ntr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mena dɔɔ Yesu wose man nombia yaaseewɔ gyu Galelia tɛɛle man na ka yenaase pou. ");
INSERT INTO ntr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Be ka lee bɔ ɔsom deni keŋ man pɛ, te baŋ na Gyemisi na Gyɔn gyuuwɔ Simɔn na Anderiase dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Be ke gyu na Simɔn wa awu doo ɔ na wee kpaŋalaŋ, keŋte be yako Yesu. ");
INSERT INTO ntr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Botɔɔ te Yesu gyuuwɔ alo ŋon gyaŋ, te ɔ kyaŋa e ɔ nyiŋmaa man gate e kyaase. Debokenaŋ man te alo ŋon kawee keŋ taŋawɔ, te ɔ kɛɛ be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mena wee kenaŋ balinɔɔ weese kagyoo nɛ, balaŋ moo be kaweesetena na baŋ pou feliŋkumɛɛ doo be man nɛ kɔŋ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Keŋte donɔɔ keŋ man balaŋ pou kɔŋawɔ kaa wuu dekpaŋalaŋ keŋ denanɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Te Yesu kyɔɔ balaŋ burum be kaweese kpookpoo pou. Ɔ gegi feliŋkumɛɛ burum mɔ lee balaŋ man keŋ ɔ te fa ŋa gbɛɛ nyi ŋe dee kolosi ya, nawolo nyi ŋa gyeŋ walaŋ ŋon dinɔɔ Yesu yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ke tɛɛ kena nebo nebo fuu nɛ, Yesu karatɛɛwɔ lee dekpaŋalaŋ man gyu yenaŋ daale keŋ botɔɔ yɛɛ yididi nɛ, te ɔ ke fanewɔ fa Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Keŋte Simɔn na ɔ tebia baŋ gyuuwɔ bɛɛ kɛo e. ");
INSERT INTO ntr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba kena e nɛ te be yako e nyiaa, “Balaŋ baŋ pou ne kɛo neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ yela dee gyu donɔɔse ŋan ŋe kyaa siaman nɛ man, na me kaa kolosi Wurubuarɛ nombia ŋan botɔɔ mɔ. Nawolo nyi keŋ dɔɔ te me kɔŋawɔ tɛɛle kei dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mena dɔɔ ɔ tɛɛwɔ kila Galelia tɛɛle pou dɔɔ, te ɔ kolosi Wurubuarɛ nombia ŋan fa wɔ bɔ ɔsom denɛɛ man pou, te ɔ gegi feliŋkumɛɛ lee balaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Te akuŋtuŋte ŋolo kaa buŋawɔ ɔ doona dɔɔ Yesu nawɔɔtɛɛ waase e nyiaa, “Me Gbeŋgyoo, akpaa n ne gyae na n ke tale kyɔ maŋ me kawee kei.” ");
INSERT INTO ntr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Botɔɔ nɛ, ɔ nombia yɛɛ Yesu waraŋase te ɔ moo ɔ nyiŋmaa gyakaa ɔ dɔɔ yako e nyiaa, “Mɛɛ gyae, n kawee dɛɛ taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Debokenaŋ man te ɔ kawee keŋ taŋawɔ, te ɔ nyiŋa ɔ wose. ");
INSERT INTO ntr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pɛ Yesu ke lɔ balee ŋon gbɛɛ nɛ, ɔ faree e nideli nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kɛɛ nyi walaŋ na walaŋ na nyii kpene keŋ be kɔŋ nɛ ya. Mɔna mo n wose gyu kawola Wurubuarɛ sae ŋon, na n ketɔ kedeesa abɔɔ ŋan de naana Mosesi ba wolo nyi yaa tɔ nɛ. Kei gyae ke yela walaŋ kamasɛ kena nyi n kawee keŋ te taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mɔna balee ŋon ka lee debɔɔ man pɛ te ɔ gyoo nombia ŋan dekpeŋkpeŋ kegyɔ, te walaŋ kamasɛ nyiiwɔ. Lee mena dɔɔ Yesu te tale gyoo donɔɔ kamasɛ man na balaŋ kena e ya. Ɔ ne gyu bo ke kyaa donɔɔ keŋ nɔɔman, botɔɔ keŋ balaŋ be gyae baa naa e ya nɛ. Mɔ keŋ koraŋ na, balaŋ na lee yenaŋ kamasɛ kɔŋ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Weeya akalansɛɛ ŋaale wɔle nɛ, Yesu besewɔ gyu Kapanum donɔɔ man te balaŋ nyiiwɔ nyi ɔ te kɔŋ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Keŋte balaŋ burum kaa wuuwɔ botɔɔ, keŋ nyi nae daseŋae be doo ya. Mena dɔɔ gbɛɛ be doo keŋ ŋolo waa mo gyoo dekpaŋalaŋ keŋ man gba ya. Te Yesu kolosi Wurubuarɛ nombia fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Keŋte balaŋ banaara baale seele ɔtakase ŋolo bɛɛ kɔŋ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Keŋ balaŋ boe dɔɔ be te nyiŋ gbɛɛ mo e ta denanɔɔ man ya. Mena dɔɔ ba gyeŋa deni keŋ man Yesu kyaa nɛ nyee dɔɔ te be wolee yenaŋ daale, te be tisinaa kaweete ŋon na ɔ dofoŋoŋ keŋ pou dɛɛdɛɛ see Yesu siaman. ");
INSERT INTO ntr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu kena mena keŋ balaŋ baŋ be lɛɛ e di nɛ, ɔ yako kaweete ŋon nyiaa, “Me bu, me ta mo n nombiakumɛɛ kyɛɛ neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Botɔɔ te Gyudatena mmaraa wolala baŋ be kyaa botɔɔ nɛ yakowɔ ba nyeeya man nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Weera dɔɔ te balee kei ne kolosi mena? Ɔ te kolosi mmusuo nombia. Lee Wurubuarɛ wɔle na, amɔte kyaa la keŋ waa tale mo dukum kyɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Debokenaŋ man te Yesu gyeŋa kpene keŋ bɛɛ gyueŋ nɛ te ɔ yako wɔ nyiaa, “Woŋ dɔɔ te ɛ na gyueŋ kɛŋa ɛ nyeeya man? ");
INSERT INTO ntr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nombia kɛŋa man woŋti woɛla na keyako fa ɔtakase ŋon? ‘Me ta mo n dukum kyɛɛ neŋ,’ yaa ‘Koro seŋ na n ka mo n dofoŋoŋ na n ke ta?’ ");
INSERT INTO ntr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mɔna mɛɛ gyae ɛ ka gyeŋ nyi, Maŋ Deniwalaŋ Bu dana doŋ tɛɛle kei dɔɔ nyi maa mo dukum kyɛɛ.” Mena dɔɔ ɔ yako kaweete ŋon nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Koro seŋ. Gate n dofoŋoŋ, na n ke ta gyu n dɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Debokenaŋ man te kaweete ŋon korowɔ seŋ ɔ nawɔɔ dɔɔ, te ɔ gate ɔ dofoŋoŋ keŋ dɔɔ ɔ doo nɛ, te ɔ leewɔ laŋ ɔ dɛɛ balaŋ baŋ pou siaman. Nombia kɛŋa doo balaŋ baŋ pou nɔɔ te ba lese Wurubuarɛ yele yako nyiaa, “Da te naa ta mena nombia kɛŋa dinɔɔ see ya.” ");
INSERT INTO ntr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kenaŋ wɔle te Yesu besewɔ gyu Galelia boo nɔɔman, te balaŋ burum kɔŋawɔ ɔ gyaŋ te ɔ wola wɔ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ɔ ke ta ɔ ne lam nɛ, ɔ naa Alfeose bu Lewi ŋon ɔ yɛɛ lempoolɛɛre e nɛ, na ɔ kyaa ɔ lempoo delɛe man. Te Yesu yako e nyiaa, “Sila maŋ.” Keŋte Lewi korowɔ sila e. ");
INSERT INTO ntr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kenaŋ wɔle nɛ, Lewi baake Yesu na ɔ kaseela baŋ gyu ɔ dɛɛ be kaa di. Lempoolɛɛra na nombiakumɛɛyɛɛra burum sila Yesu na ɔ kaseela baŋ gyu botɔɔ, te baŋ na wɔ pou ke diiwɔ bom. ");
INSERT INTO ntr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Gyudatena mmaraa wolala baŋ bɔɔ lee Farasiitena dikpii keŋ man kena ŋgba Yesu ne dii bom na lempoolɛɛra na nombiakumɛɛyɛɛra nɛ be bɔɔse ɔ kaseela baŋ nyiaa, “Weera dɔɔ te Yesu ne dii bom na lempoolɛɛra na nombiakumɛɛyɛɛra?” ");
INSERT INTO ntr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu kenyii mena nɛ te ɔ yako wɔ nyiaa, “Kaweesetena te kaboena nyi baa kyɔ wɔ kawee. Balaŋ baŋ bɔɔ na wee ya nɛ, dɔɔ bɔɔ ne hia kawee kekyɔ ya. Ma te kɔŋ nyi me kaa baake balaŋ baŋ be gbɛɛneŋ wulaa tenɛɛ Wurubuarɛ siaman nɛ ya. Mɔna me kɔŋae na me kaa baake balaŋ baŋ be yɛɛ nombiakumɛɛyɛɛrawɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wee daale balaŋ baale naawɔ na Gyɔn Wurubuarɛ loŋsɔɔre silala na Farasiitena ne bake be nɔɔ. Keŋte be bɔɔse Yesu nyiaa, “Weera dɔɔ te Gyɔn Wurubuarɛ loŋsɔɔre silala na Farasiitena ne bake be nɔɔ, te nyaŋ wui kɛwɔ dɔɔ bɔɔ ne bake be nɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Sena te balaŋ baŋ be kyaa alowɔletɛɛ nɛ baa tale bake be nɔɔ keŋ alowɔle baale kyaa be gyaŋ? Alowɔle baale nyiŋa ɔ kyaa be gyaŋ nɛ, bɔɔ gyae baa tale bake be nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mɔna debaŋ daale gyae kekɔŋ keŋ baa mo alowɔle baale ŋon lee be gyaŋ. Mena wee kenaŋ man te baa bake be nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ŋolo bɛɛ kara kanyaŋ wɔle mo taa kakyeŋgbelaa keŋ ba yem nɛ bɔɔ ya. Akpaa ɔ yɛɛ mena nɛ, kanyaŋ wɔle keŋ gyae ke tao kakyeŋgbelaa keŋ wolose ke bɔɔ keŋ yɛɛ ke dinaa. ");
INSERT INTO ntr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mena mɔ te ŋolo bɛɛ mo soloŋ wɔle do wonembu tɔne ogele bene man ya. Akpaa ɔ yɛɛ mena na soloŋ keŋ gyae ke tao tɔne keŋ lii, na soloŋ keŋ na wonembu tɔne ogele keŋ pou ke wɔlɛɛ. Bɛɛ mo soloŋ wɔle bo do wonembu tɔne ogele wɔle man.” ");
INSERT INTO ntr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kelii Gyudatena kefɛɛfowee nɛ, Yesu na ɔ kaseela baŋ gyuuwɔ ka mo wɔɔ daale man. Na weenɛɛ ŋan seŋɛɛ wɔɔ kenaŋ man nɛ yɛɛ ŋgba kefaa nɛ. Keŋte ba kpera ŋaale posaa bɛɛ tao. ");
INSERT INTO ntr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Keŋte Farasiitena bɔɔse Yesu nyiaa, “Weera te n kaseela baŋ ne yɛɛ kpene keŋ dɛɛ kɔle nɛ da kefɛɛfowee?” ");
INSERT INTO ntr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ te kala ta lee Wurubuarɛ tɔne keŋ man kpene keŋ de naana Defidi be yɛɛ debaŋ keŋ tanam be kyaŋ ŋon na ɔ tebia, te ba wose be kyaŋ wɔ nɛ yee? ");
INSERT INTO ntr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Debaŋ keŋ Abiata yɛɛ Wurubuarɛ sae kegyia e nɛ, de naana Defidi gyoowɔ Wurubuarɛ ɔsom deni dinaa keŋ man, te ɔ dii bodobodo keŋ bɔɔ mo deesi fa Wurubuarɛ keŋ ŋolo be dana gbɛɛ waa di ke kpu na Wurubuarɛ saese ya nɛ. Keŋte ɔ moo ŋaale mɔ fa ɔ tebia baŋ be kpuɛ na e nɛ, te baŋ mɔ diiwɔ.” ");
INSERT INTO ntr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Te Yesu torowɔ yako wɔ nyiaa, “Wurubuarɛ yɛɛ kefɛɛfowee bo fa walaŋ. Ɔ te yɛɛ walaŋ fa kefɛɛfowee ya. ");
INSERT INTO ntr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mena dɔɔ maŋ Deniwalaŋ Bu ŋon yɛna kefɛɛfowee keŋ gba Gbeŋgyoo.” ");
INSERT INTO ntr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wee daale Yesu besewɔ gyu Gyudatena ɔsom deni man. Ɔ ke gyu nɛ, na baam dayeŋasate ŋolo kyaa botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na balaŋ baŋ baale na deke Yesu nyi waa kyɔ balee ŋon kawee ba kefɛɛfowee keŋ, na baa nyiŋ mo nombia gyakaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Keŋte Yesu yako baam dayeŋasate ŋon nyiaa, “Lee kaa seŋ siaman kɛbo.” ");
INSERT INTO ntr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Woŋ te da mmaraa ne fa gbɛɛ nyi dɛɛ yɛɛ kefɛɛfowee? Da mmaraa ne fa daa gbɛɛ nyi dɛɛ yɛɛ kolo kpaakpaa yaa dɛɛ yɛɛ kolo kum? Dɛɛ lɛɛ walaŋ nyee yaa, dee yela waa yeŋ?” Botɔɔ na, ŋolo te tale gyuusu ɔ nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Te Yesu kɛɛ wɔ pou gyaŋee baŋ man, te takaa e nideli lee ba deŋele doŋ keŋ dɔɔ. Keŋte ɔ yako kaweete ŋon nyiaa, “Tenee n baam.” Botɔɔ te balee ŋon tenee ɔ baam keŋ, te kawee keŋ taŋawɔ te ɔ baam keŋ yɛɛ doŋ. ");
INSERT INTO ntr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mena dɔɔ Farasiitena na Herode silala leewɔ be kaa bake mena keŋ baa mo ko Yesu. ");
INSERT INTO ntr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kenaŋ wɔle te Yesu na ɔ kaseela baŋ wɔŋa ba wose lee botɔɔ gyu Galelia boo nɔɔman, te balaŋ burum baŋ bɔɔ lee Galelia nɛ sila e gyu botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Be ke nyii kpene keŋ ɔ ne yɛɛ nɛ, balaŋ burum leewɔ Gyerusalɛm na Idumia donɔɔse na tɛɛle keŋ ke kyaa Gyɔɔdan boo diŋgyiŋ nɛ, na donɔɔse ŋan be kilisi Tae na Sidɔn nɛ man kɔŋ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Balaŋ baŋ booroŋ dɔɔ ɔ yako ɔ kaseela baŋ nyi baa gyae degbele fa e, na balaŋ baŋ be nyiŋ tɔ e do ya. ");
INSERT INTO ntr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nawolo nyi ɔ te kyɔ balaŋ burum kaweese, mena dɔɔ baŋ be sɛɛ be dana kaweese nɛ te kaa wuu ɔ dɔɔ keŋ bɛɛ gyae baa mo be nyiŋmaase tina e. ");
INSERT INTO ntr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te akpaa balaŋ baŋ feliŋkum doo be man nɛ de naa e na, bɛɛ buŋii ɔ nawɔɔtɛɛ na bɛɛ fae yeesa nyiaa, “Nyaŋ yɛna Wurubuarɛ bu ŋon.” ");
INSERT INTO ntr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Keŋte Yesu faree wɔ nyi, be na yela balaŋ ka gyeŋ walaŋ ŋon dinɔɔ ɔ yɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Keŋte Yesu gyeŋa bula daale, te ɔ baake balaŋ baŋ ɔ ne gyae nɛ te be kaa yilaawɔ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Te ɔ lese balaŋ baŋ man baala kufu bala, te ɔ baake wɔ ɔ kpilala nyi baa kpu na e na waa kpilii wɔ na baa ta yako Wurubuarɛ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na waa fa wɔ doŋ na baa gberaa feliŋkumɛɛ lee balaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Baala kufu bala baŋ Yesu ba lese nɛ yela yaa, Simɔn te ɔ doo e yele nyi Pita, na ");
INSERT INTO ntr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeo bu Gyemisi na ɔ naabu Gyɔn, te ɔ besewɔ do wɔ yela nyi Boanegesi. Yele kei nawolo nyi bɛɛ yɛɛ nombia bo yakaa yakaa na doŋ ŋgba ɔga kefae nɛ, ");
INSERT INTO ntr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Anderiase na Filipo na Batolomeo na Mateo na Tomase na Alfeose bu Gyemisi na Tadeose na Kaanan baale Simɔn ŋon ɔ ne gyae ɔ balaŋ nideli nɛ, ");
INSERT INTO ntr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Gyudase Isekarɔte ŋon ɔ ba lese Yesu fa nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ka lese ɔ kpilala baŋ taŋ nɛ te ɔ gyuuwɔ ɔ dɛɛ. Keŋte balaŋ burum kɔŋawɔ kaa wuu ɔ dɔɔ, keŋ ŋon na ɔ kaseela bee nyiŋ gbɛɛ baa di weenɛɛ paŋpaŋ gba ya. ");
INSERT INTO ntr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɔ loŋtona kenyii mena nɛ be gyuuwɔ be kaa kyaŋ e gyu dɛɛ, nawolo nyi na balaŋ baŋ kpa ɔ nyee ne wɔlɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Botɔɔ te Gyudatena mmaraa wolala baŋ bɔɔ lee Gyerusalɛm donɔɔ man kɔŋ botɔɔ nɛ yakowɔ nyiaa, “Feliŋkumɛɛ pou gyoo ŋon bɛɛ baake e nyi Bɛlisɛbu nɛ doola Yesu man. Ŋon faa na e doŋ te ɔ na mo gberaa feliŋkumɛɛ lee balaŋ man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Keŋte Yesu baake balaŋ baŋ kɔŋ ɔ gyaŋ yako wɔ aduya man nyiaa, “Sena te ɔbɔnsam waa tale gegi ɔ wose? ");
INSERT INTO ntr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Akpaa tɛɛle daale man balaŋ de kpase ba wose bee yoo na dɔŋa nɛ, tɛɛle kenaŋ be gyae ke seŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mena mɔ te akpaa dekpaŋalaŋ daale man balaŋ de kpase ba wose bee yoo na dɔŋa nɛ, dekpaŋalaŋ kenaŋ mɔ be gyae ke tale seŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te akpaa ɔbɔnsam na ɔ tewulɛɛ de kpase ba wose kpookpoo te ba koro seŋ tia dɔŋa na, ɔ be gyae waa tale seŋ ya. Na ɔ gyoori keŋ ɔto kenaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Keŋte Yesu besewɔ yako wɔ nyiaa, ŋolo be tale gyu doŋte ŋolo dɛɛ na ɔ kaa mo ɔ kolo, keŋ nyi ɔ te di doŋte ŋon dɔɔ ya. Nyi akpaa ɔ di doŋte ŋon dɔɔ te ɔ bake e see nɛ, kenaŋ na waa tale kuu wa abɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mɛɛ yako ŋon anokoare baa ɛ ke nyii nyiaa, Wurubuarɛ waa tale mo balaŋ pou nombiakumɛɛ na mmusuo nombia ŋan bɛɛ yɛɛ nɛ kyɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mɔna walaŋ ŋon waa kolosi mmusuo nombia tia Wurubuarɛ feliŋ ŋon nɛ, ɔ be gyae waa mo kyɛɛ ɔtenate korakora ya. Nawolo nyi walaŋ ŋonaŋ te yɛɛ nombiakumɛɛ ŋan ŋe doo kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Keŋ dɔɔ te Yesu be yako nombia kɛŋa yɛna nyiaa, na balaŋ ne yako nyi feliŋkum doo la ɔ man. ");
INSERT INTO ntr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Keŋte Yesu ɔ naa na ɔ naabia kɔŋawɔ kaa seŋ debɔɔman kpila nyi baa baake e fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na balaŋ burum kyaa kilisi e te be yako e nyiaa, “Kɛɛ, n naa na n naabia seŋɛɛ debɔɔman bɛɛ gyae neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Bomɔ yɛna me naa na me naabia?” ");
INSERT INTO ntr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Keŋte ɔ kɛɛ baŋ be kyaa kilisi e nɛ gyaŋee te ɔ yakowɔ nyiaa, “Kɛɛ, me naa na me naabia yɛna kɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Walaŋ kamasɛ ŋon ɔ ne yɛɛ Wurubuarɛ kegyaebii nɛ, ŋon yɛna me naabu na me deesi na me naa.” ");
INSERT INTO ntr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wee daale Yesu besewɔ ɔ na wola Wurubuarɛ nombia Galelia boo nɔɔman. Te mena keŋ balaŋ burum be kaa wuu ɔ dɔɔ dɔɔ nɛ, ɔ gyoowɔ ke kyaa degbele man gyu loŋ keŋ dɔɔ na balaŋ akaŋ baŋ pou seŋɛɛ dekeŋkeŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Botɔɔ te ɔ wola wɔ nombia aduya man. ");
INSERT INTO ntr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Te ɔ yako wɔ nyiaa, “Ɛ tei kɛbo, wɔɔfarale ŋolo gyuuwɔ ke ŋmatee abɔɔbia ŋgba amɔla nɛ ɔ wɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɔ kɛɛ ŋmatee ŋa nɛ, ŋaale yalawɔ gbɛɛneŋbia ŋan doo wɔɔ keŋ man nɛ man, te gyebuse kaa tɔɔsee ŋa di. ");
INSERT INTO ntr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ŋaale mɔ yalawɔ kpanaŋse dɔɔ te ŋe tuuwɔ, mɔna tɛɛle ta boo botɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mena dɔɔ ɔga kaa seŋawɔ na te ŋa botowɔ. Te keŋ ŋe te nyiŋ lila burum dɔɔ ya nɛ, ŋe popou yekeewɔ. ");
INSERT INTO ntr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bia ŋan ŋaale mɔ yalawɔ kpalamse man te ŋe tuuwɔ, te kpalamse ŋan mɔ tuuwɔ milii ŋa. Mena dɔɔ ŋe te nyiŋ ŋa wose se bia ya. ");
INSERT INTO ntr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Abɔɔbia ŋan ŋaale mɔ yalawɔ tɛɛle kpaakpaa dɔɔ te ŋe tuuwɔ bee, te ŋa see bia burum. Ŋaale see bia sao na kufu (30), te ŋaale mɔ see bia sɔŋotooro (60), te ŋaale mɔ see bia sɔŋonoŋ (100).” ");
INSERT INTO ntr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Keŋte Yesu yako wɔ nyiaa, “Ŋon ɔ dana deŋela waa nyii na, waa tei nideli.” ");
INSERT INTO ntr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Keka Yesu waageŋ nɛ, ɔ kaseela kufu bala baŋ na balaŋ baŋ be kyaa botɔɔ kpu na wɔ nɛ yako e nyi waa wola wɔ dudu keŋ asɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Keŋte Yesu yako wɔ nyiaa, “Ɛmɛɛ dɔɔ Wurubuarɛ ta toro ya agyueŋse na ɛ ka gyeŋ nombia ŋan weesɛɛ lee ɔ gyoori keŋ wose man. Mɔna balaŋ baŋ bɔɔ kpuɛ na ŋon ya nɛ dɔɔ, aduya man te baa kolosi fa wɔ, ");
INSERT INTO ntr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","na ke yela, ‘Baa kɛo kɛo mɔna bɔɔ gyae baa naa kolo ya, te baa tei tei mɔna bɔɔ gyae baa nyii nombia ŋenaŋ man ya. Na mena ya nɛ, baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man, na Wurubuarɛ ka mo be nombiakumɛɛ kyɛɛ wɔ.’ ” ");
INSERT INTO ntr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Keŋte Yesu yako wɔ nyiaa, “Akpaa ɛ bee nyii dudu kei asɛɛ ya na, sena te ɛ ke yɛɛ na ɛ ke nyii aduya akaŋ man? ");
INSERT INTO ntr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Abɔɔbia ŋan wɔɔfarale ŋon be ŋmatee nɛ seŋɛɛ fa Wurubuarɛ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Balaŋ baale yɛɛ ŋgba bia ŋan be yale wɔɔ keŋ gbɛɛneŋbia man nɛ. Be nyii Wurubuarɛ nombia ŋan pɛ, na ɔbɔnsam te kɔŋ kaa lese ŋa lee be konɔɔse man. ");
INSERT INTO ntr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Balaŋ baale mɔ yɛɛ ŋgba bia ŋan be yale kpanaŋse dɔɔ nɛ. Be nyii Wurubuarɛ nombia ŋan na, bɛɛ lɛɛ ŋa na gyoŋ debokenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mɔna keŋ Wurubuarɛ nombia ŋan te nyiŋ lila be man dɔɔ ya nɛ, bɔɔ ne tale seŋ keŋkeŋ kelii ɔto ya. Mena dɔɔ akpaa de kɔŋ nyi Wurubuarɛ nombia ŋan dɔɔ te bɛɛ naase wɔ diyem na, be ta bese be wɔle bileŋ. ");
INSERT INTO ntr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Balaŋ baale mɔ yɛɛ ŋgba bia ŋan be yale kpalamse man nɛ. Bee nyii Wurubuarɛ nombia ŋan, ");
INSERT INTO ntr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mɔna akpaa tɛɛle kei dɔɔ nombia na kɔba kegyae beiŋ, na tɛɛle kei dɔɔ abɔɔ akaŋ ŋan kegyae da gyoo be man nɛ, na bee yele baa bee Kristo man ya. ");
INSERT INTO ntr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Balaŋ baale mɔ yɛɛ ŋgba bia ŋan be yale tɛɛle kpaakpaa dɔɔ nɛ. Bee nyii Wurubuarɛ nombia ŋan te bɛɛ lɛɛ ŋa do konɔɔ kpaakpaa man, te bɛɛ tela ŋa nideli te bɛɛ yɛɛ kakyeŋ di ŋe dɔɔ. Mena dɔɔ nombia ŋan ne yele bɛɛ yɛɛ abɔɔ kpaakpaa ŋgba ŋan ŋɔɔ se bia sao na kufu (30) na sɔŋotooro (60), na sɔŋonoŋ (100), nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Keŋte Yesu yako wɔ nyiaa, “Ŋolo bɛɛ kyaŋee kanea na waa mo kolo wuu ke dɔɔ yaa waa mo ke do mpa ateta ya. Mɔna ɔ na mo ke bo gyakaa kolo dɔɔ adido. ");
INSERT INTO ntr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nawolo nyi kolo ba weesɛɛ keŋ be gyae ka lee debɔɔ ya, te kolo mɔ be wuɛ keŋ nyi be gyae ka lee debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Walaŋ ŋon ɔ dana deŋele anenyiiŋ dei nɛ, waa see deŋele na waa tei.” ");
INSERT INTO ntr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Keŋte Yesu yako wɔ bela nyiaa, “Ɛ kɛɛ ɛ wose nideli lee nombia ŋan ɛ ne nyii nɛ man. Nawolo nyi kpene keŋ n mo yɛɛ n dɔɔ nɛ, keŋ ke te Wurubuarɛ mɔ waa mo yɛɛ neŋ, te waa yɛɛ neŋ gba kela mena keŋ n ba mo yɛɛ n dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nyaŋ ŋon n dana kolo na Wurubuarɛ waa kpu neŋ na n ke nyiŋ kpu. Te nyaŋ ŋon n be dana kolo ya na, kyomii keŋ n na gyueŋ nyi n dana koraŋ nɛ, Wurubuarɛ waa lɛo ke lee n nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu besewɔ gyɔ dudu fa wɔ nyiaa, “Wurubuarɛ gyoori keŋ yɛɛ ŋgba mena keŋ walaŋ ne ŋmatee abɔɔbia ŋaale ŋgba amɔla ɔ wɔɔman nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nelim na ka weese ɔ doo te ɔ fom na abɔɔbia ŋan ne tuu na ŋɛɛ bee, mɔna ŋon gbagba ba gyeŋ mena keŋ ne yɛɛ pɛte ŋɛɛ bee ya. ");
INSERT INTO ntr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tɛɛle keŋ gbagba ne yele la te bia ŋan ne tuu. Ne taŋgbɛɛ yɛɛ faareŋse na te fulu, pɛte kaa yɛɛ bia. ");
INSERT INTO ntr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Amɔla bia ŋan de yɛɛ pɛ, na wɔɔte ŋon ta mo ɔ sakawa gyu ke kara ŋa, nawolo nyi amɔla ŋan kekara debaŋ te lii.” ");
INSERT INTO ntr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu besewɔ bɔɔse wɔ nyiaa, “Woŋ te dɛɛ mo Wurubuarɛ gyoori keŋ maa na? Yaa dudu woŋti te dɛɛ gyɔ na dɛɛ mo lese ke man? ");
INSERT INTO ntr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wurubuarɛ gyoori keŋ yɛɛ ŋgba daŋbii peperee daale keŋ bɛɛ baake nyi Mastade nɛ. Wɔɔ man abɔɔ ŋan bee duu pou nɛ, daŋbii kei yɛna ŋe man kemaasa. ");
INSERT INTO ntr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mɔna nyi akpaa be duu ke nɛ, kɛɛ bee bese kolo dinaa kela daasebia akaŋ ŋan pou, keŋ nyi gyebuse ne kɔŋ kaa loo ba asaase do ke tombia man.” ");
INSERT INTO ntr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aduya burum ŋgba kei dinɔɔ nɛ te Yesu moowɔ kolosi Wurubuarɛ nombia fa balaŋ baŋ, ŋgba mena keŋ baa tale nyii ŋe man nideli nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔ te kolosi nombii yakaa fa wɔ keŋ ɔ te gyɔ dudu ya. Mɔ nyi akpaa de ka ŋon na ɔ kaseela baŋ baageŋ nɛ, ɔ na lese aduya ŋan pou man wola wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mena wee kenaŋ balinɔɔ nɛ, Yesu yako ɔ kaseela baŋ nyiaa, “Ɛ yela dɛɛ toŋ gyu boo keŋ diŋgyiŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Keŋte be tinaa balaŋ dikpii keŋ yela, te ŋon na ɔ kaseela baŋ gyoowɔ degbele man te be laŋawɔ. Na agbelese ŋaale mɔ silana wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Be kee gyu na te feliŋ dinaa daale korowɔ ne gyɔɔ, te gyɔɔ loŋ do degbele keŋ man te ke yela ke munu. ");
INSERT INTO ntr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Debaŋ kenaŋ na Yesu te doo dosoroŋ degbele keŋ wɔle mo ɔ nyee gyakaa keputu dɔɔ. Keŋte ɔ kaseela baŋ ke gyuusu e bɔɔse e nyiaa, “De Gbeŋgyoo, n be famenɛ ŋgba dɛɛ gyae dee munu yee?” ");
INSERT INTO ntr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Botɔɔ te Yesu korowɔ te ɔ fae feliŋ keŋ te ɔ yako loŋ keŋ nyiaa, “Yɛɛ yididi!” Keŋte feliŋ keŋ tinaa kegyɔ yela, te loŋ keŋ mɔ yɛɛwɔ yididi. ");
INSERT INTO ntr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Keŋte Yesu bɔɔse ɔ kaseela baŋ nyiaa, “Woŋ dɔɔ te ɛ dana gyakoloŋ mena? Ɛ sɛɛ ɛ te lɛɛ ta maŋ di yee?” ");
INSERT INTO ntr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Gyakoloŋ kyaŋa ɔ kaseela baŋ te be bɔɔse dɔŋa nyiaa, “Walaŋ woŋti yaa kei, te feliŋ na loŋ gba ne nyii ɔ dei nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kenaŋ wɔle te Yesu na ɔ kaseela baŋ toŋa boo keŋ gyu Gerasenetena tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu ka lee degbele keŋ man pɛ te balee ŋolo ŋon feliŋkum doo ɔ man nɛ, leewɔ amusee man kɔŋ kaa gyaŋee na e. ");
INSERT INTO ntr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na mena balee ŋonaŋ kyae amusee man botɔɔ, te ŋolo na ŋolo bɛɛ tekaa tale kyaŋ e do agbaraagbaraa bela ya. ");
INSERT INTO ntr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nawolo nyi nafɔ bɛɛ mo agbaraagbaraa do e ɔ nyiŋmaase na ɔ nawɔɔ man, mɔna ɔ ne tirii ŋa pou leki. Te ŋolo be dana doŋ keŋ waa tale yɔkɔse e ya. ");
INSERT INTO ntr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nelim na ka weese na ɔ dɔŋ amusee man na bulase dɔɔ botɔɔ ɔ ne fae yeesa, na ɔ na mo boya kɛrɛɛ ɔ wose. ");
INSERT INTO ntr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Balee ŋonaŋ kena Yesu ne kɔŋ lemlem nɛ, te ɔ yeuwɔ ke buŋ ɔ siaman. ");
INSERT INTO ntr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Botɔɔ te Yesu fae feliŋkum keŋ nyi waa lee balee ŋon man. Keŋte balee ŋon fae yeesa keŋkeŋ nyiaa, “Yesu, Wurubuarɛ Adidote Bu, woŋ te n ne gyae me gyaŋ? Mɛɛ mo Wurubuarɛ mɛɛ doo neŋ teree nyi, na naase maŋ diyem ya.” ");
INSERT INTO ntr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Te Yesu bɔɔse balee ŋon nyi, “N yele yɛna sena?” Te ɔ yako e nyi, “Ma yele yɛna dikpii, nawolo nyi da boe.” ");
INSERT INTO ntr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Keŋte balee ŋon waase Yesu agbaatee agbaatee nyi, ɔ na gegi feliŋkumɛɛ ŋan lee depuŋ kenaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kekɔŋ mena na kekuiriise dikpii daale seŋɛɛ bula keŋ teŋa man bee dii. ");
INSERT INTO ntr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Keŋte feliŋkumɛɛ ŋan doo Yesu teree nyi, “Waaseda, fa daa gbɛɛ na de kaa gyoo kekuiriise kɛwɔ man.” ");
INSERT INTO ntr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Botɔɔ te Yesu sɛɛwɔ te ba leewɔ ka gyoo kekuiriise baŋ man. Kekuiriise baŋ baa yɛɛ ŋgba kakpoŋse ala nɛ, te be yeuwɔ tisi dekeŋkeŋ kyoloŋkyoloŋ keŋ gyu ka gyoo loŋ man, te be popou munuwɔ. ");
INSERT INTO ntr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mena dɔɔ balaŋ baŋ bɛɛ kɛɛ kekuiriise baŋ dɔɔ nɛ yeuwɔ, te be gyuuwɔ ke yako kpene keŋ be kɔŋ nɛ fa balaŋ baŋ be kyaa donɔɔ keŋ man nɛ na akuraase ŋan man pou. Keŋte balaŋ kɔŋawɔ kaa kɛɛ kpene keŋ be kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mena dɔɔ te kyare ya te balaŋ kɔŋawɔ Yesu gyaŋ te be naa walaŋ ŋon nafɔ feliŋkumɛɛ doo ɔ man nɛ baŋɛɛ, na ɔ doona wa abɔɔ na ɔ diteŋ keŋ te taŋ. Ba kena nyi balee ŋon diteŋ te taŋ nɛ, gyakoloŋ gyoo wɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Botɔɔ te balaŋ baŋ bɔɔ naa kpene keŋ be kɔŋ balee ŋon feliŋkumɛɛ doo ɔ man na kekuiriise baŋ dɔɔ nɛ, yako nombia ŋan pou be kɔŋ nɛ fa balaŋ akaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Keŋte balaŋ baŋ waase Yesu nyi waa lee be tɛɛle dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ka mo waa gyoo degbele man nɛ, balee ŋon ɔ be kyɔ e nɛ waase e nyi waa sila e. ");
INSERT INTO ntr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mɔna Yesu te sɛɛ ya te ɔ yako e nyiaa, “Ta gyu n dɛɛ, na n kaa yako n loŋtona kpene keŋ n Gbeŋgyoo be yɛɛ fa neŋ, na mena keŋ ɔ be wii n waraŋase nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mena dɔɔ balee ŋon laŋawɔ, te ɔ gyuuwɔ donɔɔse kufu ŋan ŋe kyaa dupuŋ kenaŋ man nɛ ɔ ne yako kpene keŋ Yesu be yɛɛ fa e nɛ. Te gyakoloŋ gyoo balaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kenaŋ wɔle te Yesu besewɔ gyoo degbele man toŋ boo keŋ gyu diŋgyiŋ. Keŋte balaŋ burum kɔŋawɔ kaa wuu ɔ dɔɔ boo nɔɔman botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Keŋte Gyudatena ɔsom deni man kegyia ŋon bɛɛ baake e nyi Gyariose nɛ kɔŋawɔ botɔɔ. Ɔ kena Yesu nɛ, ɔ ke buŋawɔ ɔ nawɔɔ tɛɛ, ");
INSERT INTO ntr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","te ɔ waase e nideli nyiaa, “Me bu alebubii ne gyae waa yeŋ. Kɔŋ na n kaa mo n nyiŋmaa gyakaa ɔ dɔɔ na waa nyiŋ nyeedoŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mena dɔɔ Yesu sila e laŋ. Be kee gyu na balaŋ burum silana wɔ, na bɛɛ soko e. ");
INSERT INTO ntr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na alo ŋolo kyaa keŋ fatabo ne gyɔ e kulutooneŋ kufu ala yaa. ");
INSERT INTO ntr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɔ te naa diyem nideli teeneŋtena nyiŋmaa man, te ɔ wɔlɛɛ ɔ kɔba keŋ pou ɔ dana nɛ nyi waa nyiŋ kawee kekyɔ. Mɔna ɔ kawee keŋ na bese bo yɛɛ doŋ kpu. ");
INSERT INTO ntr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Alo ŋon ke nyii Yesu wose man nombia nɛ, ɔ gyoowɔ balaŋ baŋ man kaa sila Yesu te ɔ yakowɔ ɔ nyeeman nyiaa, “Akpaa me nyiŋ mo me nyiŋmaa tina ɔ kegba koraŋ na, me kawee gyae ke taŋ.” Keŋte ɔ ŋereketee ɔ wose do balaŋ baŋ man ka seŋ Yesu wɔle, te ɔ moo ɔ nyiŋmaa tina ɔ kegba. ");
INSERT INTO ntr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Karatetee dokoloŋ te fatabo keŋ ne gyɔ e nɛ karawɔ, te ɔ naawɔ ɔ wose man nyi ɔ kawee te taŋ. ");
INSERT INTO ntr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Debokenaŋ man te Yesu naawɔ nyi doŋ daale ta lee ɔ man. Keŋte ɔ besenawɔ kɛɛ balaŋ baŋ gyaŋee te ɔ bɔɔse wɔ nyiaa, “Amɔte tinaa na ma kegba?” ");
INSERT INTO ntr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Botɔɔ te ɔ kaseela baŋ yako e nyiaa, “Nyaŋ gbagba n naa mena keŋ balaŋ be wuu n dɔɔ, na n na bese bɔɔse nyi ‘Amɔte tinaa na maŋ?’ ” ");
INSERT INTO ntr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mɔna Yesu gyakaa ɔ ne kɛo nyi waa naa walaŋ ŋon ɔ be tina ɔ kegba nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Alo ŋon kena mena keŋ ɔ wose be yɛɛ e nɛ, ɔ moo gyakoloŋ na wose keseree kaa buŋ Yesu nawɔɔtɛɛ te ɔ yako e kpene keŋ be kɔŋ nɛ pou. ");
INSERT INTO ntr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Botɔɔ te Yesu yako e nyiaa, “Me bu, n kelɛɛ maŋ di dɔɔ te n nyiŋa kawee kekyɔ. Ta wosefɛɛreŋ man, nawolo nyi n kaale keŋ pou te taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ka seŋ botɔɔ ɔ ne kolosi nɛ, baale leewɔ Gyudatena ɔsom deni man kegyia Gyariose ŋon dɛɛ kaa yako e nyiaa, “N bu alebu ŋon ta yem. Weera te n ne naase de Gbeŋgyoo ŋon diyem bela” ");
INSERT INTO ntr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mɔ Yesu ta mo balaŋ baŋ nombia ŋan bɔɔ kaa yako ŋon nɛ yɛɛ kolo ya. Mena dɔɔ ɔ yako ɔsom deni man kegyia ŋon nyiaa, “Na yee ya, nyaŋ lɛɛ maŋ di.” ");
INSERT INTO ntr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mena dɔɔ Yesu te yela ŋolo ke sila e kpu na Pita na Gyemisi, na Gyemisi ɔ naabu Gyɔn baageŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Be ka benaa Gyudatena ɔsom deni man kegyia Gyariose ŋon dɛɛ nɛ, Yesu nyiiwɔ na balaŋ ne wii na bɛɛ fae yeesa keŋkeŋ. ");
INSERT INTO ntr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu ka gyoo dekpaŋalaŋ keŋ man nɛ te ɔ bɔɔse balaŋ baŋ nyiaa, “Weera te ɛ ne wii te ɛ ne fae yeesa? Bu ŋon ta yeŋa ta ya, ɔ doo dosoroŋ bo.” ");
INSERT INTO ntr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Botɔɔ te balaŋ baŋ boŋo Yesu. Keŋte ɔ gegi balaŋ baŋ pou lee te ɔ moo bu ŋon ɔ kya na ɔ naa, na ɔ kaseela batooro baŋ be silana e nɛ, te be gyuuwɔ deni keŋ man woo ŋon doo nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Keŋte ɔ kyaŋa bu ŋon nyiŋmaa man te ɔ yako e nyiaa, “Talita kumi!” Kei nawolo nyi, “Alebubii, me kpa koro.” ");
INSERT INTO ntr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Karatetee dokoloŋ te alebu ŋon korowɔ seŋ ɔ ne tɛɛ. Keŋte gyakoloŋ gyoo wɔ nideli. Na bu ŋon te di kulutooneŋ kufu ala. ");
INSERT INTO ntr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Botɔɔ te Yesu faree wɔ nideli nyi be na yeli walaŋ na walaŋ ke nyii nombii kei ya. Te ɔ yako wɔ nyi baa gyae kolo fa bu ŋon ke di. ");
INSERT INTO ntr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kenaŋ wɔle te Yesu na ɔ kaseela baŋ lee botɔɔ gyu ŋon gbagba ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Gyudatena kefɛɛfowee kelii nɛ, ɔ korowɔ gyu bɔ ɔsom deni man ɔ na wola wɔ Wurubuarɛ nombia. Ɔ nombia ŋan ɔ na wolo nɛ doo balaŋ baŋ pou nɔɔ te be bɔɔsewɔ nyiaa, “Aleŋ yaa balee kei nyiŋa abɔɔ kɛŋa pou lee? Aleŋ yaa ɔ nyiŋa mena nyansa kei lee? Kɛɛ gyakoloŋ nombia ŋan ɔ ne yɛɛ? ");
INSERT INTO ntr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na kapenta ŋon yaa yee? Na ɔ naa yɛna Mɛɛre yee? Na ɔ naabia yɛna Gyemisi na Gyosɛfo na Simɔn na Gyuda yee? Na daa na ɔ desina kyaa la kɛbo yee?” Mena dɔɔ ba te lɛɛ e do ya. ");
INSERT INTO ntr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Botɔɔ te Yesu yako wɔ nyiaa, “Balaŋ ne bu Wurubuarɛ dekpeŋkpeŋgyɔɔre yenaŋ kamasɛ, mɔna ŋon gbagba ɔ donɔɔ man balaŋ, na ɔ loŋtona na ɔ dekpaŋalaŋmantena bee buu na e ya.” ");
INSERT INTO ntr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mena dɔɔ Yesu te tale yɛɛ gyakoloŋ nombia burum ɔ dɛɛ botɔɔ ya. Ɔ moo ɔ nyiŋmaa bo gyakaa balaŋ kyomii baale bo dɔɔ, te ɔ kyɔɔ wɔ be kaweese. ");
INSERT INTO ntr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu wose yeŋa e ŋgba mena keŋ ɔ balaŋ gbagba te lɛɛ e di ya nɛ dɔɔ. Keŋte ɔ leewɔ donɔɔ keŋ man, ta kila akuraase ŋan man ɔ na wola wɔ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Te Yesu baake ɔ kaseela kufu bala baŋ te ɔ kpilii wɔ bala bala. Te ɔ fa wɔ doŋ keŋ baa mo di feliŋkumɛɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Keŋte ɔ yako wɔ nyiaa, “Ɛ na mo kolo tela kpu na ɛ gbutuse ya. Ɛ na mo weenɛɛ, yaa akpo yaa kɔba tela ya. ");
INSERT INTO ntr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɛ do nkyokotase, mɔna ɛ na mo kegbase tela kpu ya. ");
INSERT INTO ntr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɛ gyu donɔɔ daale man te dekpaŋalaŋ keŋ man be lɛɛ ŋon nɛ, ɛ kyaa botɔɔ kaboena ɛ ka mo lee donɔɔ kenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te akpaa ɛ gyu yenaŋ daale te ba te lɛɛ ŋon yaa be te nyii ŋon ya nɛ, ɛ lee botɔɔ na ɛ kpiisi ya nkyokotase aŋasa lɔ wɔ na ke di adansɛɛ tia wɔ nyi Wurubuarɛ be gyae waa tina wɔ yela ya.” ");
INSERT INTO ntr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mena dɔɔ be gyuuwɔ kekolosi Wurubuarɛ nombia ŋan fa balaŋ, nyi baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man kɔŋ Wurubuarɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Be gegi feliŋkumɛɛ burum lee balaŋ man, te ba moo nuŋ fee kaweesetena burum te ba wose yɛɛ wɔ doŋ. ");
INSERT INTO ntr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Abɔɔ ŋan pou Yesu be yɛɛ nɛ, yela ɔ yele yaaseewɔ gyu yenaŋ kamasɛ te gyoo Herode mɔ nyiiwɔ. Be ke nyii Yesu yele nɛ, na baale kpa “Gyɔn Wurubuarɛ loŋsɔɔre ŋon ɔ ba yem nɛ yaa Wurubuarɛ gyuusuwɔ lee yeŋ man, mena dɔɔ te ɔ nyiŋa doŋ ɔ ne yɛɛ gyakoloŋ nombia na nombia dinaana kɛŋa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baale mɔ kpa, “Ŋon yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre Elia,” te baale mɔ kpa “Ɔ yɛɛ gyaŋgba Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ bɔɔ kyaa kaalaŋ nɛ man ŋolo e.” ");
INSERT INTO ntr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gyoo Herode kenyii mena nɛ ɔ yakowɔ nyiaa, “Gyɔn ŋon mɔɔ kara ɔ nyee nɛ bese la foŋ nɛ!” ");
INSERT INTO ntr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nawolo nyi na Gyɔn gyakaa ɔ ne yako gyoo Herode nyi, “Gbɛɛ be doo nyi waa mo ɔ kegyia Filipo wɛɛle yala ŋgba mena keŋ ɔ be yɛɛ nɛ ya.” Mena dɔɔ gyoo Herode gbagba yela be kyaŋa Gyɔn te ba doo e agbaraagbaraase mo e ketɔ deni. ");
INSERT INTO ntr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nombii kei dɔɔ Herodia moo Gyɔn do ɔ tɔɔ man, te ɔ gyae gbɛɛ keŋ waa mo ko e mɔna ɔ bɛɛ tale ya. ");
INSERT INTO ntr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nawolo nyi gyoo Herode gyeŋ nyi Gyɔn yɛɛ walaŋ ŋon ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman, te ɔ ta mo ɔ wose mɔ fa Wurubuarɛ. Mena dɔɔ gyoo Herode na weese Gyɔn keŋ nyi nombiikum daale be yɛɛ e ya. Debaŋ kamasɛ keŋ gyoo Herode de nyii Gyɔn nɔɔwoya na bɛɛ seŋ e nideli ya, mɔna ɔ ne gyae nyi waa tei e. ");
INSERT INTO ntr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kɛŋa pou wɔle nɛ, gbɛɛ kaa torowɔ fa Herodia. Nawolo nyi Gyoo Herode kee di ɔ kalolawee nɛ, ɔ baake ɔ kegyiise na ɔ yoonɔɔtena kegyiise na Galeliatena baŋ ba wose dana obuo nɛ, nyi be kaa di wee keŋ kyɔ e. ");
INSERT INTO ntr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba ke gyaŋee keŋ nɛ, Herodia bu alebu kɔŋawɔ kaa sɔe te yɛɛ gyoo Herode na balaŋ baŋ pou kyeo. Botɔɔ te gyoo Herode yako alebu ŋon nyiaa, “Yako maŋ kpene kamasɛ keŋ n ne gyae, na maa fa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Keŋte gyoo Herode kaŋa ntam kpu fa bu ŋon nyiaa, “Kpene kamasɛ keŋ n bɔɔse maŋ na maa fa neŋ. Akpaa me gyoori koraŋ te n ne gyae na, maa kpase ke man fa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Botɔɔ te alebu ŋon leewɔ yenaŋ gyu ke bɔɔse ɔ naa nyiaa, “Nna, woŋ te maa bɔɔse?” Botɔɔ te ɔ naa yako e nyiaa, “Yako nyi n ne gyae Gyɔn Wurubuarɛ loŋsɔɔre ŋon nyee.” ");
INSERT INTO ntr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Debokenaŋ man te alebu ŋon barasewɔ gyu gyoo Herode gyaŋ ke yako e nyiaa, “Mɛɛ gyae n ke kara Gyɔn Wurubuarɛ loŋsɔɔre nyee do tasa taŋtaŋalaŋ man fa maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nombii kei takaa gyoo Herode nideli, mɔna ntam keŋ ɔ be kam ŋɔɔla baŋ siaman dɔɔ nɛ, ɔ te tale bɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mena dɔɔ debokenaŋ man te ɔ kpila ɔ balaŋ baŋ bɛɛ kɛrɛɛ balaŋ nyeeya nɛ man ŋolo nyi, waa gyu ke kara Gyɔn nyee kɔna e. Keŋte balee ŋon gyuu deni keŋ man Gyɔn doo nɛ ka lese e kara ɔ nyee. ");
INSERT INTO ntr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Keŋte ɔ moo ke do tasa taŋtaŋalaŋ man kɔna gyoo Herode te ɔ moowɔ fa alebu ŋon, te ŋon mɔ moo ke fa ɔ naa. ");
INSERT INTO ntr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gyɔn kaseela baŋ kenyii ɔ yeŋ nɛ, be gyuuwɔ ka mo e ke wuu. ");
INSERT INTO ntr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu kpilala kufu bala baŋ ɔ be kpilii nɛ besewɔ kɔŋ kaa yako e nombia ŋan pou bɔɔ yɛɛ, na ŋan pou bɔɔ wola balaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na mena keŋ balaŋ na gyem tisi be dɔɔ beiŋ dɔɔ nɛ, be te nyiŋ gbɛɛ baa di weenɛɛ gba ya. Mena dɔɔ Yesu yako wɔ nyiaa, “Ɛ yela dɛɛ wɔŋ da wose lee yenaŋ gyu botɔɔ keŋ balaŋ be kyaa ya nɛ, na ɛ kaa fɛɛfo.” ");
INSERT INTO ntr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Keŋte ba gyoowɔ degbele man te be laŋa botɔɔ keŋ balaŋ be kyaa ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mɔ be kee gyu nɛ, balaŋ burum naa wɔ te ba gyeŋawɔ nyi baŋ benaŋ. Mena dɔɔ balaŋ leewɔ donɔɔse ŋan man pou yeu gyu ka gyoo botɔɔ keŋ bee gyu nɛ, pɛte Yesu na ɔ kaseela baŋ kaa gyoowɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu ke tisi lee degbele keŋ man na ɔ kena balaŋ burum baŋ nɛ, be nombia yɛɛ e waraŋase. Nawolo nyi na be yɛɛ ŋgba namense baŋ bɔɔ dana gbeŋgyoo ya nɛ. Mena dɔɔ ɔ fiasɛɛ ɔ na wola wɔ abɔɔ burum. ");
INSERT INTO ntr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mena debaŋ kenaŋ na te lii balinɔɔ, mena dɔɔ ɔ kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, “Kɛbo yɛɛ ŋale nsana ke, te tɛɛ mɔ te yuu. ");
INSERT INTO ntr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lɔ balaŋ baŋ gbɛɛ na baa gyu donɔɔse na akuraase ŋan ŋa benaa nɛ man, na be kaa gyae kolo lɛɛ di.” ");
INSERT INTO ntr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mɔ Yesu yako wɔ nyiaa, “Ɛmɛɛ gbagba ɛ gyae kolo fa wɔ na baa di.” Keŋte be bɔɔse e nyiaa, “Da mo tomyɛɛre kulutoo dokoloŋ kɔba lɛɛ weenɛɛ koraŋ na, gyae ka yee balaŋ burum kɛwɔ pou?” ");
INSERT INTO ntr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Botɔɔ te Yesu mɔ bɔɔse wɔ nyiaa, “Bodobodose aŋmoŋ te ɛ dana? Ɛ gyu ke kɛɛ.” Be ke gyu ke kɛɛ nɛ te be kaa yako e nyiaa, “Bodobodose abiliŋ anoŋ na kpebia bala pɛ te de dana.” ");
INSERT INTO ntr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Keŋte Yesu yako ɔ kaseela baŋ nyi baa yela balaŋ baŋ ke kyakee akpii akpii ŋalese nalaŋ ŋan dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mena dɔɔ balaŋ baŋ kyakeewɔ akpii akpii. Akpii ŋaale yɛɛ balaŋ sɔŋonoŋ (100) te ŋaale mɔ yɛɛ balaŋ sɔŋola na kufu (50). ");
INSERT INTO ntr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Botɔɔ te Yesu moo bodobodose anoŋ na kpebia bala baŋ, te ɔ gyinaa ɔ nyee kɛɛ adido te ɔ fanewɔ do Wurubuarɛ nɔɔ. Te ɔ kɛrɛɛ ŋa fa ɔ kaseela baŋ nyi baa kpɛlɛɛ fa balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Balaŋ baŋ pou diiwɔ baa ba kegyaebii. ");
INSERT INTO ntr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Be ke di taŋ nɛ, ɔ kaseela baŋ tɔɔsee bodobodose na kpebia buruburu ŋan bɔɔ dii kaase na, be nyiŋa doŋase kufu ala (12). ");
INSERT INTO ntr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Balaŋ baŋ bɔɔ di weenɛɛ ŋan nɛ, be man baala baageŋ yɛɛ balaŋ kakpoŋse banoŋ (5000). ");
INSERT INTO ntr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Debokenaŋ man te Yesu yela ɔ kaseela baŋ gyoowɔ degbele man kyaŋ gbɛɛ bee gyu Bɛtesaida donɔɔ keŋ ke kyaa boo keŋ diŋgyiŋ nɛ, na ŋon ke lɔ balaŋ baŋ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ɔ ke lɔ balaŋ baŋ gbɛɛ taŋ nɛ, ɔ gyuuwɔ bula dɔɔ ɔ kaa fane. ");
INSERT INTO ntr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kelii balinɔɔ nɛ, na degbele keŋ te lii boo keŋ nsana nsana, te kaa Yesu waageŋ boo keŋ diŋgyiŋ. ");
INSERT INTO ntr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Botɔɔ te Yesu kɛɛwɔ na feliŋ ne gyɔɔ gyaŋee na ɔ kaseela baŋ, mena dɔɔ bɛɛ kaa na degbele keŋ kesaa. Keŋte ɔ karatɛɛwɔ ta loŋ keŋ dɔɔ gyu be gyaŋ, te ɔ yɛɛwɔ ŋgba ɔ ne gbaa wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ɔ kaseela baŋ kena e ɔ dɔŋ loŋ keŋ dɔɔ ɔ ne kɔŋ nɛ, na ba gyeŋ nyi ɔ yɛɛ woo e te be fae yeesa. ");
INSERT INTO ntr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nawolo nyi be popou naa e te gyakoloŋ kyaŋa wɔ. Debokenaŋ man te Yesu kolosiwɔ na wɔ nyi, “Ɛ nyiŋ konɔɔ! Ɛ na yee ya! Maŋ e.” ");
INSERT INTO ntr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Botɔɔ te ɔ gyoowɔ kyaa degbele keŋ man kpu na wɔ, te feliŋ ŋon nɔɔ yɔkɔsewɔ. Nombia kɛŋa doo ɔ kaseela baŋ nɔɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yesu ka mo bodobodose anoŋ kpala balaŋ kakpoŋse banoŋ baŋ nɛ, ɔ kaseela baŋ te nyii ka asɛɛ ya, nawolo nyi na be sɛɛ be ta gyeŋa walaŋ ŋon dinɔɔ Yesu yɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Keŋte ba toŋa boo keŋ gyu Genesareti tɛɛle man, te be kpaŋa ba degbele keŋ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Be ka betaa lee degbele keŋ man pɛ, te balaŋ naa Yesu te ba gyeŋawɔ nyi ŋon ŋonaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mena dɔɔ balaŋ yekiiwɔ lee tɛɛle kenaŋ yenaŋ kamasɛ man kɔŋ ɔ gyaŋ. Yenaŋ kamasɛ keŋ be nyii nyi Yesu kyaa na, bɛɛ kɔŋ na ba seele be kaweesetena ba afoŋoŋse dɔɔ bɛɛ kɔŋ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te akuraase yaa donɔɔse kamasɛ ŋan man Yesu de gyu nɛ, balaŋ na mo be kaweesetena kaa see abɔntere man, na ba te waase e nyi waa yela kaweesetena baŋ ka mo be nyiŋmaase tina ɔ kegba nɔɔbii paŋpaŋ bo gba. Te baŋ pou bɔɔ tina ɔ kegba keŋ nɛ, wose yɛɛ wɔ doŋ. ");
INSERT INTO ntr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wee daale nɛ, Farasiitena na Gyudatena mmaraa wolala baale baŋ bɔɔ lee Gyerusalɛm donɔɔ man nɛ, kaa yilaawɔ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Botɔɔ te be naawɔ nyi, ɔ kaseela baŋ baale te faafo be nyiŋmaase ŋgba mena keŋ ba beneŋ amanberɛse na wola wɔ nɛ ya pɛte bee dii. ");
INSERT INTO ntr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nawolo nyi Farasiitena na Gyudatena baŋ pou bee tina ba beneŋ amanberɛse ŋan yela ya. Mena dɔɔ nyi akpaa ba te faafo be nyiŋmaase ŋgba mena keŋ be naanaɔ be yako see ya na bɔɔ ne dii ya. ");
INSERT INTO ntr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mena ke mɔ te akpaa ba lee kebu man kɔŋ na, bɛɛ saase ba wose pɛte baa di weenɛɛ. Ba beneŋ amanberɛse boe nideli. Be dana gbɛɛneŋ ŋan bɛɛ mo saase ba leenɔɔse na tasase na osuŋse mɔ. ");
INSERT INTO ntr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mena dɔɔ Farasiitena na Gyudatena mmaraa wolala baŋ bɔɔse Yesu nyiaa, “Weera dɔɔ te n kaseela baŋ bee di da beneŋ amanberɛse dɔɔ ya? Nawolo nyi bɔɔ ne faafo be nyiŋmaase ŋgba mena keŋ da beneŋ amanberɛ nawolo nɛ pɛ baa di ya!” ");
INSERT INTO ntr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ ne yɛɛ ɛ wose ŋgba ɛ yɛɛ balaŋ kpaakpaawɔ nɛ, mɔna ɛ na beo ɛ wose bo. Ɛ nombia ŋan Wurubuarɛ be tɛɛ ɔ dekpeŋkpeŋgyɔɔre Yesaya dɔɔ yako ɔ nombia aŋmaraseŋ see ŋan man nɛ yɛɛ ampaŋ. Ɔ yakowɔ nyiaa, ‘Wurubuarɛ kpa, balaŋ kɛwɔ dana be nɔɔ bo bɛɛ yako nyi bee bu maŋ, mɔna be konɔɔse man na bɔɔ na mo maŋ yɛɛ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bɛɛ som maŋ bo yakaa, nawolo nyi mmaraase ŋan denibalaŋ be yɛɛ nɛ te be dana bɛɛ wola balaŋ nombia.’ ");
INSERT INTO ntr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ɛ te tina Wurubuarɛ mmaraase ŋan yela, te ɛ dana ɛ beneŋ amanberɛse ŋan balaŋ na wolo nɛ man.” ");
INSERT INTO ntr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ gyeŋ adao gbɛɛneŋ ŋan ɛ na mo bɛɛ Wurubuarɛ nombia ŋan, na ɛ ke nyiŋ di ɛ beneŋ amanberɛse ŋan dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nawolo nyi gyaŋgba keŋ de naana Mosesi yakowɔ Wurubuarɛ mmaraase ŋan man nyiaa, ‘Bu n kya na naa, te walaŋ kamasɛ ŋon ɔ kolosi nombiakumɛɛ tia ɔ kya yaa ɔ naa na, kaboena nyi baa ko e.’ ");
INSERT INTO ntr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mɔna ɛmɛɛ ne yako nyiaa, ‘Akpaa ŋolo de yako ɔ kya yaa ɔ naa nyi, “Kpene keŋ nafɔ me dana maa mo kyɔ neŋ nɛ yɛɛ Koriban ke.” ’ (Koriban kei nawolo nyi, kpene keŋ yɛɛ Wurubuarɛ wui). ");
INSERT INTO ntr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Dekɔŋ mena na, ɛ bɛɛ tekaa fa ɔtenate gbɛɛ waa yɛɛ kolo fa ɔ kya yaa ɔ naa ya. ");
INSERT INTO ntr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mena yaa ɛ na mo ɛ beneŋ amanberɛse ŋan wɔlɛɛ Wurubuarɛ nombia ŋan, te ɛ yɛɛ ŋa see ɛ bia mɔ. Te ɛ ne yɛɛ nombia burum ŋan ŋe yɛɛ ŋgba kɛŋa dinɔɔ nɛ kpu.” ");
INSERT INTO ntr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kenaŋ wɔle nɛ, Yesu besewɔ baake balaŋ baŋ pou kaa yilaa ɔ gyaŋ te ɔ yako wɔ nyiaa, “Ɛ popou ɛ tei maŋ, na ɛ ke nyii nombia kɛŋa man nideli. ");
INSERT INTO ntr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kolo be kyaa keŋ ke da lee yenaŋ gyoo walaŋ wose man na, ke gyae ke tale yɛɛ e ayimɛɛ ya. Mɔna kpene keŋ na lee walaŋ man kɔŋ nɛ, keŋ ne yɛɛ na e ayimɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Walaŋ kamasɛ ŋon ɔ dana deŋele anenyiiŋ dei nɛ, waa see deŋele na waa nyii.” ");
INSERT INTO ntr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu ka lee balaŋ baŋ man gyu dekpaŋalaŋ man nɛ, ɔ kaseela baŋ bɔɔse e dudu keŋ asɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Botɔɔ te ɔ bɔɔse wɔ nyiaa, “Mena dɔɔ ɛmɛɛ mɔ bee nyii nombia asɛɛ yee? Ɛ ba gyeŋ nyi kpene kamasɛ keŋ na lee yenaŋ gyoo walaŋ wose man na, ke bɛɛ yɛɛ e ayimɛɛ yee? ");
INSERT INTO ntr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɛ ba gyeŋ nyi na ɔ konɔɔ man te ŋee gyu ka gyoo yee? Ŋee gyu bo ka gyoo ɔ dubulu man, na ta lee ɔ wose man.” Yesu ke yako kei nɛ, na ɔ nawolo baa nyi weenɛɛ kamasɛ dei na kedi. ");
INSERT INTO ntr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Keŋte Yesu yako wɔ nyiaa, “Kpene kamasɛ keŋ na lee walaŋ konɔɔ man nɛ, keŋ ne yɛɛ na e ayimɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nawolo nyi walaŋ konɔɔ man te nombiakumɛɛ pou na lee. Mena abɔɔ kɛŋa ŋaale yɛna, kafoŋ na ŋmɛɛleŋ na balaŋ kako na yale kewɔlɛɛ, ");
INSERT INTO ntr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na sibii na nombiakumɛɛ keyɛɛ, na kabeo na kewɔlɛɛ nombia na balaŋ kekɔla, na nombiakumɛɛ ka mo gyakaa balaŋ dɔɔ, na wose kegate adido na diyiŋ nombia. ");
INSERT INTO ntr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nombiakumɛɛ kɛŋa pou na lee bo walaŋ konɔɔ man, te ŋan ne yɛɛ na e ayimɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lee botɔɔ te Yesu korowɔ gyu Tae na Sidɔn donɔɔse ŋan ŋe yɛɛ Iseraetena donɔɔse ŋa nɛ yenaŋ. Te ɔ ka gyoowɔ dekpaŋalaŋ daale man keŋ ɔ te gyae nyi ŋolo ka gyeŋ nyi ɔ kyaa botɔɔ ya, mɔna balaŋ naa e. ");
INSERT INTO ntr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Te alo ŋolo ŋon feliŋkum doo ɔ bu alebubii man ka betaa nyii nyi Yesu kyaa botɔɔ nɛ, te ɔ kaa buŋawɔ ɔ nawɔɔ tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na alo ŋonaŋ yɛɛ Giriki alo e, te ba lola e bo Fonisia keŋ ke kyaa Siria tɛɛle man nɛ. Keŋte ɔ sola Yesu nyi waa gegi feliŋkum keŋ lee ɔ bu ŋon man. ");
INSERT INTO ntr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Botɔɔ te Yesu bɔɔse e nyiaa, “Nyi n dana bia na, n ke sɛɛ mo be weenɛɛ fa babaase? Koa, n ke taŋgbɛɛ mo weenɛɛ ŋan fa bia kedi pɛ. Te akpaa be dii kaase na, pɛna na n ka mo fa babaase.” ");
INSERT INTO ntr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Keŋte alo ŋon mɔ yako e nyiaa, “Ayi, me Gbeŋgyoo, doo mena. Mɔ babaase baa tale fiu weenɛɛ ŋan bia ne dii te ŋɛɛ yale tɛɛle man nɛ di.” ");
INSERT INTO ntr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Botɔɔ te Yesu yako alo ŋon nyiaa, “Nɔɔ keŋ n be tiri fa maŋ nɛ dɔɔ ta, feliŋkum keŋ ta lee n bu alebubii ŋon man.” ");
INSERT INTO ntr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Alo ŋon ka lee botɔɔ gyu ɔ dɛɛ nɛ, te ɔ kenaawɔ nyi ɔ bu ŋon doo mpa dɔɔ na feliŋkum keŋ ta lee ɔ man. ");
INSERT INTO ntr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ka lee Tae donɔɔ man nɛ, ɔ tɛɛwɔ Sidɔn donɔɔ man ka lee Galelia boo nɔɔ nɔɔ kɔŋ donɔɔse kufu ŋaale tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Keŋte balaŋ baale moo balee ŋolo ŋon ɔ deŋela be tɔɔ te ɔ bɛɛ tale kolosi nideli ya nɛ kɔŋ Yesu gyaŋ. Te ba sola e nyi waa mo ɔ nyiŋmaa gyakaa ɔ dɔɔ, na waa kyɔ e ɔ kawee. ");
INSERT INTO ntr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Botɔɔ te Yesu moo kaweete ŋon lee balaŋ baŋ man gyu yenaŋ. Te ɔ moo ɔ nyiŋmaasebia do kaweete ŋon deŋela man, te ɔ tɔɔ nɔɔloŋ mo tina ɔ laakem. ");
INSERT INTO ntr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te Yesu kɛɛ adido te ɔ lee weesɛɛ te ɔ yako e nyiaa, “Efata!” Keŋ nawolo nyi toro! ");
INSERT INTO ntr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Debokenaŋ man te ɔ deŋela torowɔ te ɔ laakem booliwɔ, te ɔ talewɔ kolosi nideli. ");
INSERT INTO ntr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Keŋte Yesu faree balaŋ baŋ nideli nyi be na yako walaŋ kamasɛ ya. Mɔna keŋ na ɔ ke faree wɔ koraŋ nɛ, keŋ gba te be yela balaŋ nyiiwɔ beiŋ. ");
INSERT INTO ntr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Balaŋ baŋ wose yeŋawɔ nideli te be yakowɔ nyiaa, “Yesu te yɛɛ kpene kamasɛ nideli. Ɔ te yela deŋela atɔɔsatena ne nyii dei, te omumuuse mɔ ne kolosi.” ");
INSERT INTO ntr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Debaŋ daale bela nɛ, balaŋ burum baale besewɔ kɔŋ kaa yilaa Yesu gyaŋ. Na bɔɔ dana kolo baa di ya, te Yesu baake ɔ kaseela baŋ kɔŋ ɔ gyaŋ yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Balaŋ kɛwɔ nombia dana maŋ waraŋase. Nawolo nyi gyɛŋ weeya kpaakpaa atooro yaa ŋgba be kyaa me gyaŋ, te kolo be doo baa di ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nyi akpaa me lɔ wɔ gbɛɛ na tanam na, be sia gyae kaa biri wɔ gbɛɛnaa man. Nawolo nyi be man baale lee lemlem” ");
INSERT INTO ntr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Botɔɔ te ɔ kaseela baŋ bɔɔse e nyiaa, “Aleŋ te walaŋ waa nyiŋ weenɛɛ depampaa kei dɔɔ na ka yee mena balaŋ burum kɛwɔ?” ");
INSERT INTO ntr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Keŋte Yesu bɔɔse wɔ nyiaa, “Bodobodose aŋmoŋ te ɛ dana?” Te be yako e nyi be dana bodobodose nyetooro. ");
INSERT INTO ntr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Te Yesu yela balaŋ baŋ kyakeewɔ tɛɛle man, te ɔ moo bodobodose nyetooro ŋan te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ kɛrɛɛ ŋa mo fa ɔ kaseela baŋ nyi baa mo kpɛlɛɛ balaŋ baŋ. Keŋte baŋ mɔ moo ŋa kpɛlɛɛ balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na ɔ kaseela baŋ dana kpebia kyomii baale mɔ. Te Yesu moo kpebia baŋ mɔ te ɔ fanewɔ fa Wurubuarɛ karaŋ te ɔ moo ŋa fa wɔ nyi baa mo kpɛlɛɛ fa balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Balaŋ baŋ pou diiwɔ baa nideli. Kenaŋ wɔle te ɔ kaseela baŋ tɔɔsee buruburu akaŋ ŋan na, be nyiŋa doŋatɔɔse nyetooro. ");
INSERT INTO ntr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Balaŋ baŋ bɔɔ di weenɛɛ ŋan nɛ, be man baala yɛɛ balaŋ kakpoŋse banaara (4000). Yesu ke lɔ balaŋ baŋ gbɛɛ nɛ, ");
INSERT INTO ntr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","te ŋon na ɔ kaseela baŋ gyoowɔ degbele man gyu Dalimanuta tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Keŋte Farasiitena baale kɔŋawɔ Yesu gyaŋ bɛɛ bɔɔse e nombia na baa mo teese ɔ nɔɔ man. Be yako e nyi waa yɛɛ gyakoloŋ nombia na kawola nyi ɔ lee Wurubuarɛ gyaŋ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Botɔɔ te Yesu lee weesɛɛ ɔ man te ɔ yako wɔ nyiaa, “Woŋ dɔɔ te ɛmɛɛ gyɛŋ wee kei balaŋ ne gyae nyi maa yɛɛ gyakoloŋ nombia wola ŋon? Ampaŋ yaa mɛɛ yako ŋon nyiaa, mɔɔ gyae maa yɛɛ gyakoloŋ nombia wola ŋon ya.” ");
INSERT INTO ntr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Keŋte Yesu leewɔ balaŋ baŋ gyaŋ, te ɔ moo degbele toŋ gyu boo keŋ diŋgyiŋ. ");
INSERT INTO ntr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu na ɔ kaseela baŋ kee gyu nɛ, na ɔ kaseela baŋ te wolee be ta mo bodobodo ŋaale tela kpu na dokoloŋ keŋ doo ba degbele keŋ man nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Te Yesu faree ɔ kaseela baŋ nyiaa, “Ɛ kɛɛ ɛ wose man nideli lee Farasiitena na Herodetena wose man. Nawolo nyi be dinɔɔ yɛɛ ŋgba tee keŋ bɛɛ mo do bodobodo man te kɛɛ koro nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Botɔɔ te ɔ kaseela baŋ yako dɔŋa nyiaa, “Keŋ de ta mo bodobodo tela ya dɔɔ te ɔ ne yako mena nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu ka gyeŋ kpene keŋ bɛɛ yako nɛ te ɔ bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ ne kolosi nyi ɛ ta mo bodobodo tela ya? Mena dɔɔ ɛ ta gyeŋa ta nombia man yee? Ya agyueŋse man ta toro ta yee? ");
INSERT INTO ntr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ɛ dana sia nɛ, ɛ bɛɛ naa yee? Te ɛ dana deŋela mɔ nɛ, ɛ bee nyii nombia yee? Ɛ bɛɛ tɔɔse nombia yee? ");
INSERT INTO ntr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Debaŋ keŋ mɔɔ kɛrɛɛ bodobodose anoŋ ŋan kpɛlɛɛ balaŋ kakpoŋse banoŋ baŋ te bɔɔ dii baa nɛ, doŋatɔɔse aŋmoŋ te ɛ tɔɔsee buruburu akaŋ ŋan wulu?” Keŋte be tiranɔɔ nyi, “Doŋatɔɔse kufu ala.” ");
INSERT INTO ntr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Te Yesu besewɔ bɔɔse wɔ nyiaa, “Debaŋ keŋ mɔ kɛrɛɛ bodobodose nyetooro ŋan kpɛlɛɛ balaŋ kakpoŋse banaara (4000) baŋ te bɔɔ dii baa nɛ, doŋatɔɔse aŋmoŋ te ɛ tɔɔsee buruburu akaŋ ŋan wulu?” Keŋte be tiranɔɔ nyi, “Doŋatɔɔse nyetooro.” ");
INSERT INTO ntr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Botɔɔ te Yesu bɔɔse wɔ nyi, “Ɛ sɛɛ ɛ te nyii ta nombia ŋan man yee?” ");
INSERT INTO ntr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu na ɔ kaseela baŋ ke kɔŋ Bɛtesaida donɔɔ man nɛ, te balaŋ baale moo siayɛlɛɛsate ŋolo kɔŋ ɔ gyaŋ te ba waase e nyi waa mo ɔ nyiŋmaa tina e na ɔ sia ke gyuusu. ");
INSERT INTO ntr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Botɔɔ te Yesu kyaŋa siayɛlɛɛsate ŋon nyiŋmaa man te ɔ moo e lee donɔɔ keŋ man, te ɔ tɔɔ nɔɔloŋ woli ɔ sia te ɔ moo ɔ nyiŋmaa gyakaa ɔ dɔɔ te ɔ bɔɔse e nyiaa, “N ne naa kolo?” ");
INSERT INTO ntr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Keŋte balee ŋon gyinaa ɔ sia kɛɛ adido te ɔ yakowɔ nyiaa, “Mɛɛ naa balaŋ, mɔna be yɛɛ ŋgba daase ne tɛɛ la nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Te Yesu besewɔ mo ɔ nyiŋmaa tina balee ŋon sia bela. Keŋte ɔ sia gyuusuwɔ, te ɔ naa kpene kamasɛ nideli. ");
INSERT INTO ntr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Botɔɔ te Yesu lɔɔ balee ŋon gbɛɛ te ɔ faree e nyiaa, “Na bese gyu donɔɔ keŋ man bela ya. Ta gyu n dɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kenaŋ wɔle te Yesu na ɔ kaseela baŋ gyuu donɔɔse ŋan ŋe kyaa benaa na Kaesaria Filipi donɔɔ keŋ nɛ. Be kee gyu keŋ nɛ te ɔ bɔɔse ɔ kaseela baŋ nyiaa, “Balaŋ ne kolosi ma wose man nombia na, be kpa maŋ yɛna amɔ?” ");
INSERT INTO ntr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Botɔɔ te ɔ kaseela baŋ tiranɔɔ nyi, “Baale kpa nyaŋ yɛna Gyɔn Wurubuarɛ loŋsɔɔre ŋon, baale mɔ kpa nyaŋ yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre Elia, te baale mɔ kpa n yɛɛ Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ man ŋolo e.” ");
INSERT INTO ntr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Keŋte Yesu bɔɔse wɔ nyiaa, “Ɛmɛɛ mɔ de? Ɛ kpa maŋ yɛna amɔ?” Botɔɔ te Pita tiranɔɔ nyiaa, “Nyaŋ yɛna Kristo, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ” ");
INSERT INTO ntr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Botɔɔ te Yesu faree wɔ nyi be na yako ɔ wose man nombia fa ŋolo na ŋolo ya. ");
INSERT INTO ntr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kenaŋ wɔle te Yesu fiasɛɛ ɔ na wola ɔ kaseela baŋ nombia nyiaa, “Kaboena nyi maŋ Deniwalaŋ Bu ŋon maa naa diyem nideli, na Gyudatena kegyiise na Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ ke bɛɛ maŋ nyi na maŋ yɛna nyeelɛɛre ŋon ya. Baa ko maŋ, mɔ weeya atoorote keŋ na maa foŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ka toro nombia kɛŋa yako fa ɔ kaseela baŋ nɛ, te Pita moo e lee yenaŋ te ɔ faree e nyi ɔ na kolosi mena ya. ");
INSERT INTO ntr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Botɔɔ te Yesu gɛɛsewɔ kɛɛ ɔ kaseela baŋ te ɔ fae Pita nyiaa, “Ta lee me gyaŋ, ɔbɔnsam! Na Wurubuarɛ kegyaebii te n na gyueŋ ya, mɔna denibalaŋ kegyaebii te n na gyueŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Keŋte Yesu baake balaŋ dikpii keŋ na ɔ kaseela baŋ kɔŋ ɔ gyaŋ te ɔ yako wɔ nyiaa, “Akpaa ŋolo ne gyae waa sila maŋ na ɔ na yɛɛ kpene keŋ ŋon gbagba ne gyae ya. Mɔna waa mo ɔ ɔpaŋdaŋ keŋ seele, na waa sila maŋ. ");
INSERT INTO ntr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nawolo nyi walaŋ kamasɛ ŋon ɔ ne gyae waa lɛɛ ŋon gbagba nyeedoŋ na, ke gyae ka lee ɔ nyiŋmaa man. Te walaŋ kamasɛ ŋon ɔ nyeedoŋ da lee ɔ nyiŋmaa man lee maŋ Yesu na me nombia dɔɔ nɛ, waa bese nyiŋ ke. ");
INSERT INTO ntr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Akpaa ŋolo de nyiŋ tɛɛle kei dɔɔ abɔɔ pou te ɔ nyeedoŋ da lee ɔ nyiŋmaa man na, woŋ tɔnɔɔ te waa nyiŋ? ");
INSERT INTO ntr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yaa woŋ te walaŋ waa tale mo kyɛɛkee na ɔ nyeedoŋ? ");
INSERT INTO ntr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Akpaa maŋ Yesu na me nombia de yɛɛ ŋolo desɛŋ gyɛŋ wee kei balaŋ baŋ bɔɔ besena be wɔle tee Wurubuarɛ te be yɛɛ nombiakumɛɛyɛɛrawɔ nɛ siaman na, kenaŋ na wee keŋ maŋ Deniwalaŋ Bu ŋon maa bese kɔŋ daa na me kya Wurubuarɛ na Wurubuarɛ kpilala baŋ gyoorobiiri man nɛ, walaŋ ŋonaŋ mɔ nombia gyae ke yɛɛ maŋ desɛŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyi ɛ man baale kyaa kɛbo kei keŋ bɔɔ gyae baa yeŋ ya, kelii debaŋ keŋ baa naa Wurubuarɛ gyoori keŋ nyi ka seŋɛɛ na ke doŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Weeya looro wɔle nɛ, Yesu moo Pita na Gyemisi na Gyɔn kpu na ɔ wose te be gyuuwɔ bula dinaa daale dɔɔ baŋ baageŋ. Botɔɔ te Yesu wose kyɛɛkeewɔ be siaman. ");
INSERT INTO ntr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wa abɔɔ ŋan ɔ doona nɛ bese abɔɔ wolomɛɛ pareparepare, na ŋɛɛ ŋalakee polɛpolɛpolɛ. Ŋa wolosewɔ keŋ nyi, ŋolo be kyaa tɛɛle kei dɔɔ keŋ waa tale faafo kolo na ke ka lee mena ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Keŋte Mosesi na Elia kaa bɛɛwɔ lee be dɔɔ, te be kolosiwɔ na Yesu. ");
INSERT INTO ntr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Botɔɔ te Pita yako Yesu nyiaa, “De Gbeŋgyoo, dei ŋgba daa mɔ be kɔŋ kɛbo nɛ. Yela dɛɛ baŋ kefɛɛse atooro kɛbo. N wui daale, Mosesi wui daale te Elia mɔ wui daale.” ");
INSERT INTO ntr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Na Pita ta gyeŋ kpene waa yako ya, nawolo nyi gyakoloŋ te kyaŋ wɔ gbaa. ");
INSERT INTO ntr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Botɔɔ te ŋɔma kaa wuu be dɔɔ, te be nyii nɔɔwoya ŋaale ŋɔma keŋ man nyiaa, “Kei yɛna me bu ŋon mɛɛ gyae e. Ɛ nyii e.” ");
INSERT INTO ntr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Debokenaŋ man ɔ kaseela batooro baŋ besewɔ kɛɛ na, ba te naa walaŋ kamasɛ kpu na Yesu ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Be ke tisi bula keŋ bɛɛ kɔŋ nɛ Yesu faree wɔ nyi, “Mɔɔ ne gyae nyi ɛ ke yako ŋolo na ŋolo kpene keŋ ɛ be naa nɛ ya, kelii debaŋ keŋ maŋ Deniwalaŋ Bu ŋon maa foŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mena dɔɔ nombia ŋan dɔɔwɔ ba nyeeya man na bɛɛ bɔɔse dɔŋa nyiaa, kefoŋ lee yeŋ man kei na wolo baa nyi sena? ");
INSERT INTO ntr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Keŋte be bɔɔse Yesu nyiaa, “Weera dɔɔ te Gyudatena mmaraa wolala baŋ ne yako nyi, kaboena nyi Elia waa kyaŋ gbɛɛ kɔŋ pɛna Kristo ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ ke kɔŋ?” ");
INSERT INTO ntr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Te Yesu tiranɔɔ fa wɔ nyiaa, “Ke yɛɛ ampaŋ nyi Elia waa taŋgbɛɛ nyeelɛɛre ŋon kɔŋ, na ɔ kaa desina kpene kamasɛ see nideli. Wurubuarɛ nombia aŋmaraseŋ see ŋan besewɔ yako yenaŋ daale lee Deniwalaŋ Bu ŋon wose man nyiaa, kaboena nyi waa naa diyem nideli na baa bɛɛ e nyi na ŋon yɛna nyeelɛɛre ŋon ya. Weera dɔɔ te be ŋmarase mena nombia kɛŋa? ");
INSERT INTO ntr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mɔ mɛɛ yako ŋon baa nyiaa, Elia taŋ kekɔŋ te balaŋ yɛɛ e kpene kamasɛ keŋ be gyae ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see be yako lee ɔ wose man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ba ke kɔŋ ɔ kaseela akaŋ baŋ gyaŋ nɛ, be naa balaŋ burum te yilaa kilisi wɔ. Na Gyudatena mmaraa wolala baŋ, na ɔ kaseela baŋ ne wɔŋee nombia ŋaale. ");
INSERT INTO ntr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Balaŋ baŋ pou ke gyɔ sibii naa Yesu nɛ, doo be nɔɔ te be yeuwɔ ke gyaŋee na e te ba doo e nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Botɔɔ te Yesu bɔɔse ɔ kaseela baŋ nyiaa, “Woŋ nombia yaa ɛmɛɛ na wɔ ne wɔŋee?” ");
INSERT INTO ntr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Keŋte balaŋ baŋ man ŋolo tiranɔɔ nyiaa, “De Gbeŋgyoo, ma moo me bu tobaale ŋon feliŋkum doo ɔ man, te keŋ dɔɔ ɔ bɛɛ tale kolosi ya nɛ baa kɔna neŋ nyi nya kyɔ. ");
INSERT INTO ntr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Debaŋ kamasɛ keŋ ka de kɔŋ ɔ dɔɔ nɛ, ne fuŋ e lɔ tɛɛle man. Afofose na lee ɔ nɔɔman, na ɔ ne tao ɔ kela na ɔ te kem. Me yako n kaseela baŋ nyi baa gegi feliŋkum keŋ lee ɔ man, mɔna ba te tale ya.” ");
INSERT INTO ntr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Botɔɔ te Yesu yako wɔ nyiaa, “Ao! Ɛmɛɛ gyɛŋ balaŋ baŋ ɛ bɛɛ lɛɛ Wurubuarɛ di ya. Weeya aŋmoŋ yaa ɛ ne gyae nyi maa nyiŋ konɔɔ kyaa ɛ gyaŋ, pɛna ɛ ke lɛɛ maŋ di? Ɛ mo bu ŋon kɔna maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mena dɔɔ ba moo tobaale ŋon kɔna Yesu. Feliŋkum keŋ kena Yesu nɛ, debokenaŋ man te ke yela bu ŋon keŋawɔ ŋgba keleuleuse kyaŋa na e nɛ. Bu ŋon leewɔ yala tɛɛle man, na ɔ ne biliŋi gyu kɔŋ, na afofose na lee ɔ nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Botɔɔ te Yesu bɔɔse bu ŋon ɔ kya nyiaa, “Weeya aŋmoŋ yaa ŋgba kawee kei ba gyoo e nɛ?” Keŋte balee ŋon tiranɔɔ nyiaa, “Lee naŋ ɔ biatɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kawee keŋ ne tale fuŋ e do boalaŋ yaa loŋ man yeŋ yeŋ wui. Nyi akpaa n ke tale yɛɛ kolo na, wii de waraŋase na n ke kyɔ daa.” ");
INSERT INTO ntr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Keŋte Yesu bɔɔse e nyi, “N ne bɔɔse maŋ nyi maa tale nɛ, nafɔ nyaŋ gbagba nyaŋ ke tale, nyi akpaa n lɛɛ maŋ di na. Nawolo nyi walaŋ kamasɛ ŋon ɔ ne lɛɛ Wurubuarɛ di nɛ, kpene kamasɛ ne dee fa e.” ");
INSERT INTO ntr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Debokenaŋ man te bu ŋon ɔ kya fae yeesa yako nyiaa, “Mɛɛ lɛɛ di. Kyɔ maŋ na maa lɛɛ neŋ di kpu nideli.” ");
INSERT INTO ntr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu kena nyi balaŋ te yeu bɛɛ kɔŋ botɔɔ nɛ, ɔ faree feliŋkum keŋ nyiaa, “Nyaŋ deŋela atɔɔsa na omumuu feliŋkum, mɛɛ yako ŋon nyi ɛ lee ɔ man. Lee gyɛŋ ne gyu, ɛ na tekaa kaa gyoo ɔ man bela ya.” ");
INSERT INTO ntr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Botɔɔ te feliŋkum keŋ fae yeesa te ke wosi bu ŋon nideli ŋgba keleuleu weere nɛ, te ka leewɔ ɔ man laŋ. Na bu ŋon doo tɛɛle man ŋgba ɔ yeŋae nɛ, mena dɔɔ balaŋ burum kpa ɔ ta yem. ");
INSERT INTO ntr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Keŋte Yesu kyaŋa bu nyiŋmaa man gate e seŋ ɔ nawɔɔ dɔɔ, te ɔ seŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kenaŋ wɔle Yesu ka gyoo deni man nɛ, ɔ kaseela baŋ bɔɔse e deni man nyiaa, “Woŋ dɔɔ te daa te tale gegi feliŋkum keŋ lee bu ŋon man ya?” ");
INSERT INTO ntr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Botɔɔ te Yesu yako wɔ nyiaa, “Nyi akpaa ɛ te fane fa Wurubuarɛ nideli ya nɛ, ɛ be gyae ɛ ke tale gegi mena feliŋkum kei dinɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Be ka lee botɔɔ nɛ, be tɛɛwɔ na Galelia tɛɛle man. Na Yesu te gyae nyi walaŋ kamasɛ ka gyeŋ botɔɔ keŋ be kyaa ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nawolo nyi na ɔ na wola ɔ kaseela baŋ nombia. Keŋte ɔ yako wɔ nyiaa, “Baa lese maŋ Deniwalaŋ Bu ŋon fa balaŋ na baa ko, mɔ weeya atoorote keŋ nɛ maa foŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mɔna ɔ kaseela baŋ te nyii keŋ ɔ be yako nɛ man ya, te be yee mena keŋ baa bɔɔse e nombia ŋenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kenaŋ wɔle te be kɔŋawɔ Kapanum donɔɔ man. Be ke gyu dɛɛ nɛ te ɔ bɔɔse ɔ kaseela baŋ nyiaa, “Woŋ aŋmaareŋ yaa ɛ ne lɛɛ gbɛɛnaa man nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mɔna be man ŋolo te tale kolosi ya. Nawolo nyi gbɛɛnaa man nɛ na bɛɛ lɛɛ aŋmaareŋ nyi be man woŋti kela na ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Botɔɔ te Yesu tisiwɔ kyaa te ɔ baake ɔ kaseela kufu bala baŋ yako wɔ nyiaa, “Akpaa ŋolo ne gyae nyi waa yɛɛ siamante nɛ, kaboena nyi waa yɔkɔse ɔ wose ŋgba biikyaa nɛ, na waa som ɛ popou.” ");
INSERT INTO ntr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Botɔɔ te ɔ moo biikyaabii ŋolo kaa seŋ ba nsana, te ɔ pukaa e te ɔ yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Walaŋ kamasɛ ŋon ɔ lɛɛ biikyaabii kei dinɔɔ ma yele man na ɔ te lɛɛ maŋ, te ŋon ɔ lɛɛ maŋ na ɔ te lɛɛ ŋon ɔ be kpila maŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Botɔɔ te Gyɔn yako Yesu nyiaa, “De Gbeŋgyoo, de naa balee ŋolo na ɔ ne gegi feliŋkumɛɛ lee n yele man te de tɔɔ e, nawolo nyi ɔ be kpuɛ de man ya.” ");
INSERT INTO ntr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Keŋte Yesu yako wɔ nyiaa, “Ɛ na tɔ e gbɛɛ ya. Nawolo nyi ŋolo be kyaa keŋ waa mo ma yele yɛɛ gyakoloŋ nombia, na waa bese kolosi ma wose man nombiikum debokenaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nawolo nyi walaŋ kamasɛ ŋon ɔ bee yoo na daa ya nɛ, na ɔ kpuɛ na daa. ");
INSERT INTO ntr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ampaŋ yaa mɛɛ yako ŋon nyiaa, walaŋ kamasɛ ŋon ɔ fa ŋon loŋ leenɔɔ tɔɔ nyi keŋ ɛ yɛɛ maŋ Kristo balaŋwɔ dɔɔ nɛ, Wurubuarɛ waa tɔ ɔtenate kom.” ");
INSERT INTO ntr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Walaŋ kamasɛ ŋon ɔ yeli bia buruburu kɛwɔ baŋ bɔɔ lɛɛ maŋ di nɛ man ŋolo de yɛɛ dukum nɛ, kenaŋ na nyi akpaa ba mo boe dinaa dinaa kpaŋ ɔ wɔŋe man, te be fuŋ e do ɛpo man na dei kela. ");
INSERT INTO ntr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nyi akpaa n nyiŋmaa ne yele la te n ne yɛɛ dukum na, kara ke leki. Nawolo nyi dei nyi nya lee kadeŋ na n gyoo Wurubuarɛ gyoori keŋ man, kela keŋ n ka mo nyiŋmaase ala ka gyoo boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nawolo nyi feelɛɛ baŋ bɛɛ gyoo balaŋ botɔɔ nɛ bɔɔ na yem ya, te boalaŋ keŋ mɔ bɛɛ yem korakora ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te akpaa n nae ne yele la te n ne yɛɛ dukum na kara ke leki. Nawolo nyi dei nyi nya mo nae dokoloŋ gyoo Wurubuarɛ gyoori keŋ man, kela nyi baa mo neŋ na n nawɔɔ ala ka do boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nawolo nyi feelɛɛ baŋ bɛɛ gyoo balaŋ botɔɔ nɛ bɔɔ na yem ya, te boalaŋ keŋ mɔ bɛɛ yem korakora ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te akpaa n sibii ne yele la te n ne yɛɛ dukum na kulu ke leki. Nawolo nyi dei nyi nya mo sibii dokoloŋ gyoo Wurubuarɛ gyoori keŋ man, kela nyi baa mo neŋ na n sia ala ka do boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nawolo nyi feelɛɛ baŋ bɛɛ gyoo balaŋ botɔɔ nɛ bɔɔ na yem ya, te boalaŋ keŋ mɔ bɛɛ yem korakora ya. ");
INSERT INTO ntr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wurubuarɛ waa mo boalaŋ desina walaŋ kamasɛ, ŋgba mena keŋ bɛɛ mo yabia do kolo man te ke bɛɛ wɔlɛɛ ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yabia dei, mɔna akpaa ka gyoŋ da lee ke man na, sena te ɛ ke yɛɛ na ka gyoŋ keŋ ka bese kaa gyoo ke man bela? Ɛ yela ɛ nombia ayɛɛsa ke yɛɛ gyoŋ ŋgba yabia nɛ, na ɛ ke kyaa na dɔŋa wosefɛɛreŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ka lee botɔɔ nɛ, ɔ gyuuwɔ Gyudia tɛɛle keŋ ke kyaa Gyɔɔdan boo keŋ diŋgyiŋ nɛ. Balaŋ burum besewɔ kaa wuu ɔ dɔɔ botɔɔ, te ɔ wola wɔ nombia ŋgba mena keŋ ɔ ne kyaa wola wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Keŋte Farasiitena baale kɔŋawɔ be kaa teese ɔ nɔɔman te be bɔɔse e nyiaa, “Da mmaraa ne fa daa gbɛɛ nyi ŋolo waa tale bɛɛ ɔ wɛɛle?” ");
INSERT INTO ntr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Sena te de naana Mosesi yako ŋon nyi yaa yɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Keŋte be yako e nyi, “De naana Mosesi faa gbɛɛ nyi baale waa tale ŋmarase yale kebɛɛ tɔne keŋ nawolo nyi ɔ te bɛɛ ɔ wɛɛle nɛ, pɛna waa bɛɛ e” ");
INSERT INTO ntr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Te Yesu yako wɔ nyiaa, “Ɛ konɔɔyuŋ dɔɔ te Mosesi yɛɛ mena mmaraa kenaŋ fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nawolo nyi lee kewalaŋ keŋ nɛ, ‘Alo na baale te Wurubuarɛ yɛɛwɔ.’ ");
INSERT INTO ntr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Lee kei dɔɔ baale waa tina ɔ kya na ɔ naa yela na ŋon na ɔ wɛɛle kaa bom, ");
INSERT INTO ntr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na ŋon na ɔ wɛɛle ka bese walaŋ dokoloŋ.’ Mena dɔɔ be ta tekaa yɛɛ kpookpoo ya, mɔna be ta bese walaŋ dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lee mena dɔɔ kpene keŋ Wurubuarɛ ba mo bom yɛɛ ke dokoloŋ nɛ, ŋolo na ŋolo na kpase ke man ya.” ");
INSERT INTO ntr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Be ke gyu kagyoo deni man bela nɛ, Yesu kaseela baŋ bɔɔse e nombia kɛŋa man. ");
INSERT INTO ntr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Keŋte ɔ tiranɔɔ fa wɔ nyiaa, “Nyi akpaa baale de bɛɛ ɔ wɛɛle te ɔ ke yala alo wɔle nɛ, na yɛɛ yaa ŋgba ɔ lee ɔ wɛɛle ŋon wɔle baa nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te akpaa alo mɔ de bɛɛ ɔ baale te ɔ ke yala baale wɔle nɛ, na yɛɛ yaa ŋgba ŋon mɔ lee ɔ baale wɔle baa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Botɔɔ te balaŋ moo bia kɔŋ Yesu gyaŋ nyi waa mo ɔ nyiŋmaa gyakaa be dɔɔ. Mɔna ɔ kaseela baŋ ŋmanyaŋ balaŋ baŋ bɔɔ mo bia baŋ kɔŋ nɛ bo. ");
INSERT INTO ntr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu kena mena nɛ, te yɛɛ e gyoŋ ya te ɔ yako wɔ nyiaa, “Ɛ yela bia baŋ kekɔŋ me gyaŋ, ɛ na tɔ wɔ gbɛɛ ya. Nawolo nyi Wurubuarɛ gyoori keŋ yɛɛ balaŋ baŋ bɛɛ yɔkɔse ba wose ŋgba bia kɛwɔ dinɔɔ nɛ wui. ");
INSERT INTO ntr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ampaŋ yaa mɛɛ yako ŋon nyiaa, walaŋ kamasɛ ŋon ɔ te yɔkɔse ɔ wose do Wurubuarɛ tɛɛ ŋgba biikyaa e ya nɛ, ɔ be gyae waa gyoo Wurubuarɛ gyoori keŋ man korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Keŋte Yesu kyaŋa bia baŋ nyiŋmaa man te ɔ moo ɔ nyiŋmaa gyakaa be dɔɔ, te ɔ hiraa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu ka mo gbɛɛ ɔ ne gyu nɛ, tobaale ŋolo yeuwɔ kaa buŋ ɔ nawɔɔtɛɛ te ɔ bɔɔse e nyiaa, “Me Gbeŋgyoo kpaakpaa, woŋ te kaboena nyi maa yɛɛ na maa nyiŋ nyeedoŋ kekpaa?” ");
INSERT INTO ntr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Botɔɔ te Yesu bɔɔse e nyiaa, “Woŋ dɔɔ te n ne baake maŋ walaŋ kpaakpaa? Lee Wurubuarɛ wɔle nɛ, walaŋ kamasɛ be kyaa keŋ ɔ yɛɛ walaŋ kpaakpaate e ya.” ");
INSERT INTO ntr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ŋgba n gyeŋ Wurubuarɛ mmaraase ŋan ne yako nyi, “Na ko walaŋ ya, na lee n baale yaa n wɛɛle wɔle ya, na ŋmɛɛle ya, na kara n dɔɔ nɔɔ ya, na ŋere ŋolo do ya, bu n kya na n naa nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Keŋte balee ŋon mɔ yakowɔ nyiaa “Me Gbeŋgyoo, me wulaa mee di mmaraase kɛŋa pou dɔɔ leenaŋ me biatɛɛ” ");
INSERT INTO ntr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Botɔɔ te Yesu kɛɛ ɔ siaman yididi, na ɔ ne gyae ɔ nombia, mena dɔɔ ɔ yako e nyiaa, “Ta bese ka neŋ kolo dokoloŋ n ke yɛɛ. Gyu ke yɔɔ nya abɔɔ ŋan pou n dana nɛ, na n ka mo kɔba keŋ kpɛlɛɛ ayematena, na n ke kɔŋ kaa sila maŋ. N yɛɛ mena na, n ke nyiŋ abɔɔ kpaakpaa see n wose Wurubuarɛ gyaŋ adido.” ");
INSERT INTO ntr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tobaale ŋon ke nyii nombia kɛŋa nɛ, ɔ moo waraŋase lee botɔɔ nawolo nyi na ɔ dana ɔ wose nideli. ");
INSERT INTO ntr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Keŋte Yesu kɛɛ balaŋ baŋ gyaŋee te ɔ yako ɔ kaseela baŋ nyiaa, “Dana doŋ fa balaŋ baŋ be dana ba wose nideli nɛ, nyi baa gyoo Wurubuarɛ gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɔ kaseela baŋ ke nyii nombia kɛŋa nɛ, doo be nɔɔ. Te Yesu besewɔ yako wɔ nyiaa, “Me bia, ŋgba ɛ naa mena keŋ gyae ke yɛɛ doŋ fa balaŋ baŋ be dana ba wose nideli nɛ, nyi baa gyoo Wurubuarɛ gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gyae ke yɛɛ doŋ fa balaŋ baŋ be dana ba wose nideli nɛ nyi baa gyoo Wurubuarɛ gyoori keŋ man, kela nyi kurumɔɔ ka gyoo ŋarale bɔɔ man lee.” ");
INSERT INTO ntr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɔ kaseela baŋ ke nyii nombia kɛŋa nɛ, besewɔ doo be nɔɔ nideli te be bɔɔse dɔŋa nyiaa, “Nyi nnɛ te doo na, amɔte ne gyae la waa nyiŋ nyeekelɛɛ baa?” ");
INSERT INTO ntr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Te Yesu kɛɛ wɔ yididi yako wɔ nyiaa, “Balaŋ gyaŋ na dana doŋ, mɔna Wurubuarɛ gyaŋ na be dana doŋ ya. Nawolo nyi Wurubuarɛ gyaŋ na, kpene kamasɛ gyae ke tale kɔŋ mena.” ");
INSERT INTO ntr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Botɔɔ te Pita yako Yesu nyiaa, “De Gbeŋgyoo, daa mɔ te tina kpene kamasɛ keŋ de dana nɛ yela, te de silana neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Keŋte Yesu tiranɔɔ fa e nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyiaa, ɛ man ŋolo be kyaa keŋ ɔ be tina ɔ dekpaŋalaŋ yaa ɔ naabia yaa ɔ desina, yaa ɔ kya yaa ɔ naa yaa ɔ bia yaa ɔ tɛɛlese yela lee maŋ na nyeekelɛɛ nombia ŋan dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","te ɔ be gyae waa bese nyiŋ akpaŋalaŋse na naabia na desina na naa na kya na bia na tɛɛlese akpeŋ sɔŋonoŋ (100) kpu gyɛŋ weeya kɛŋa man ya. Mɔ kayeyɛɛ gyae ke kɔŋ ɔ dɔɔ, na balaŋ kekɔla e kpu. Te kenaŋ wɔle na, waa nyiŋ nyeedoŋ kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mɔ balaŋ burum baŋ be yɛɛ siamantenawɔ nɛ baa kaa bese wɔle nyibaŋ, na wɔle nyibaŋ kaa bese siamantena.” ");
INSERT INTO ntr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lee botɔɔ te Yesu na ɔ kaseela baŋ moo gbɛɛ bee gyu Gyerusalɛm donɔɔ man, na Yesu dɔŋɛɛ la be siaman. Be kee gyu nɛ, ɔ kaseela baŋ wose yeŋa wɔ, te gyakoloŋ mɔ kyaŋa balaŋ baŋ be silana wɔ nɛ. Keŋte ɔ baake ɔ kaseela kufu bala baŋ lee yenaŋ te ɔ yako wɔ kpene keŋ gyae ke kɔŋ ɔ dɔɔ nɛ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ɛ kɛɛ! Dee gyu Gyerusalɛm donɔɔ man baa. Baa lese maŋ Deniwalaŋ Bu ŋon fa Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ. Baa di me nombia na baa bu maŋ fɔɔ nyi baa ko maŋ, na baa mo maŋ do balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Baa kulu maŋ na baa tɔ nɔɔloŋ woli maŋ, na baa ŋmeree maŋ dambiise na baa ko maŋ. Mɔna weeya atooro wɔle na, maa foŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kenaŋ wɔle nɛ, Sebedeo bia Gyemisi na Gyɔn kɔŋawɔ Yesu gyaŋ kaa yako e nyiaa, “De Gbeŋgyoo, dɛɛ gyae nyi kpene kamasɛ keŋ de bɔɔse neŋ na, n ke yɛɛ ke fa daa.” ");
INSERT INTO ntr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Botɔɔ te Yesu bɔɔse wɔ nyi, “Woŋ te ɛ ne gyae nyi maa yɛɛ fa ŋon?” ");
INSERT INTO ntr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Keŋte be yako e nyiaa, “Dɛɛ gyae nyi de man ŋolo ke kyaa n dunoluŋ dɔɔ, na ŋolo mɔ ke kyaa n demena dɔɔ n gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ ba gyeŋ kpene keŋ ɛ ne bɔɔse nɛ ya. Ɛ ke tale nyiŋ konɔɔ naa diyem keŋ maa naa nɛ, yaa ɛ ke tale gyoo kayeyɛɛ keŋ man maa gyoo nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Keŋte be tiranɔɔ fa e nyi, “Ayi, dɛɛ tale.” Te Yesu yako wɔ nyiaa, “Ɛ ke tale naa diyem keŋ maa naa, na ɛ ka gyoo kayeyɛɛ keŋ maa gyoo nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mɔna mɔɔ taŋ doŋ keŋ maa lese walaŋ ŋon waa kyaa ma dunoluŋ yaa ma demena dɔɔ ya. Mena akyaese kɛŋa doe fa balaŋ baŋ me kya Wurubuarɛ gbagba be desina see wɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu kaseela kufu akaŋ baŋ kenyii nombia kɛŋa nɛ, ba gyeŋa baŋ Gyemisi na Gyɔn dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Botɔɔ te Yesu baake ɔ kaseela baŋ pou yilaa te ɔ yako wɔ nyiaa, “Ɛ gyeŋ nyi tɛɛle kei dɔɔ gyooneŋ ne di gyoori bo be balaŋ dɔɔ, te be kegyiise baŋ mɔ dana doŋ be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mɔ ɛmɛɛ dɔɔ, na mena te kaboena nyi dɛɛ doo ɛ man ya. Ɛ man walaŋ kamasɛ ŋon ɔ ne gyae nyi waa bese ɛ kegyia nɛ, kaboena nyi waa bese ɛ kegbetibii. ");
INSERT INTO ntr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te ɛ man walaŋ kamasɛ ŋon ɔ ne gyae nyi waa bese ɛ siamante nɛ, kaboena nyi waa bese ɛ popou ɛ kegbetibii. ");
INSERT INTO ntr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nawolo nyi maŋ Deniwalaŋ Bu ŋon te kɔŋ nyi balaŋ baa som maŋ ya, mɔna me kɔŋae me kaa som balaŋ, na maa yeŋ mo ma nyeedoŋ lɛɛ balaŋ burum nyee.” ");
INSERT INTO ntr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kenaŋ wɔle te Yesu na ɔ kaseela baŋ gyuuwɔ Gyeriko donɔɔ man. Ŋon na ɔ kaseela na balaŋ burum baŋ ka lee botɔɔ bee gyu nɛ, be naa Timeo bu Batimeo ŋon ɔ sia be yɛlɛɛ nɛ na ɔ kyaa gbɛɛnaa nɔɔman ɔ na solee abɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Balee ŋon kenyii nyi Yesu Nasarɛte baale ŋon ne kɔŋ nɛ, ɔ fae yeesa yako nyiaa, “Yesu, gyoo Defidi ɔ naanabii, wii me waraŋase.” ");
INSERT INTO ntr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Keŋte balaŋ baŋ man burum too be nɔɔ gyakaa ɔ dɔɔ nyi waa wu ɔ nɔɔ. Mɔna nɛnɛɛ gba te ɔ ne fae yeesa keŋkeŋ nyiaa, “Gyoo Defidi ɔ naanabii, wii me waraŋase.” ");
INSERT INTO ntr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Botɔɔ te Yesu seŋawɔ yako wɔ nyi, “Ɛ baake e fa maŋ.” Te be baake siayɛlɛɛsate ŋon yako e nyiaa, “Yela ke yɛɛ neŋ gyoŋ na n ka koro seŋ. Ɔ ne baake neŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Botɔɔ te ɔ fuŋa ɔ kegba wurikyim lɔ yenaŋ, te ɔ toŋawɔ seŋ ta kɔŋ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Keŋte Yesu bɔɔse e nyiaa, “Woŋ te n ne gyae nyi maa yɛɛ fa neŋ?” Botɔɔ te siayɛlɛɛsate ŋon yako e nyiaa, “Me Gbeŋgyoo, mɛɛ gyae me sia ke gyuusu” ");
INSERT INTO ntr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Botɔɔ te Yesu yako e nyiaa, “Ta, n ke lɛɛ maŋ di dɔɔ n kawee te taŋ.” Debokenaŋ man te ɔ sia gyuusuwɔ, te ɔ sila Yesu laŋ. ");
INSERT INTO ntr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Keŋte Yesu na ɔ kaseela baŋ korowɔ mo gbɛɛ bee gyu Gyerusalɛm donɔɔ man. Be kelii Bɛtifagi na Bɛtani donɔɔse ŋan ŋe kyaa oliifi bula keŋ teŋa man nɛ, ɔ kpila ɔ kaseela baŋ man bala nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ɛ gyu donɔɔ keŋ ke kyaa ɛ siaman nɛ man. Ɛ betaa ɛ na gyoo ke man pɛ nɛ, ɛ kena afurum bu ŋolo kpaŋɛɛ keŋ ŋolo te kyaa ta ɔ dɔɔ see ya. Ɛ booli e na ɛ ka mo e kɔna maŋ. ");
INSERT INTO ntr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Akpaa ŋolo de bɔɔse ŋon nyi, Weera dɔɔ te ɛ ne booli e na? Ɛ yako e nyiaa, De Gbeŋgyoo ne gyae na e, mɔna be gyae ke kyare ya waa besena e kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Keŋte be gyuuwɔ kena afurum bu ŋon kpaŋɛɛ denanɔɔ man benaa na gbɛɛ te be booli e. ");
INSERT INTO ntr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Be kɛɛ booli e nɛ, balaŋ baŋ ba seŋɛɛ botɔɔ nɛ bɔɔse wɔ nyiaa, “Woŋ yaa ɛ ne booli e ɛ ke yɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Botɔɔ te be tiranɔɔ ŋgba mena keŋ Yesu be yako wɔ nɛ, te balaŋ baŋ yela ba moo e laŋ. ");
INSERT INTO ntr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Keŋte ba moo e kɔna Yesu te ba moo be kanyaŋse gyakaa ɔ dɔɔ, te Yesu gyeŋawɔ kyaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Botɔɔ te balaŋ burum moo be kanyaŋse na ba kegbase ŋaale lɔ gbɛɛnaa man, te baale mɔ moo faareŋse ŋan bɔɔ kɛrɛɛ lee ŋale man nɛ lɔ gbɛɛnaa man. ");
INSERT INTO ntr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na balaŋ baŋ be dɔŋɛɛ Yesu siaman na baŋ be dɔŋ ɔ wɔle nɛ ne fae yeesa kɛlɛɛ e akelegyi yako nyiaa, “Wurubuarɛ waa hiraa walaŋ ŋon ɔ ne kɔŋ De Gbeŋgyoo yele man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","De naana Defidi gyoori keŋ bese la kɛɛ kɔŋ. Wurubuarɛ dee yela ka kekɔŋ. Mena dɔɔ ɛ yela dɛɛ lese Wurubuarɛ ŋon ɔ kyaa adido nɛ yele.” ");
INSERT INTO ntr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kelii Gyerusalɛm donɔɔ man nɛ, ɔ gyoo Wurubuarɛ ɔsom deni dinaa keŋ man te ɔ kɛɛ abɔɔ ŋan pou gyaŋee. Na tɛɛ te lam dɔɔ, ŋon na ɔ kaseela kufu bala baŋ gyuu Bɛtani donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tɛɛ kena keŋ Yesu na ɔ kaseela baŋ ba lee Bɛtani bɛɛ kɔŋ Gyerusalɛm donɔɔ man nɛ tanam kyaŋa e. ");
INSERT INTO ntr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Keŋte ɔ naa fiigi daŋ daale lemlem keŋ faareŋse doo ke man, te ɔ tuuwɔ benaa ke nyi waa nyiŋ ke bia di. Ɔ ke gyu ke gyaŋ na ke yɛɛ faareŋse bo keŋ bia be doo ke man ya. Nawolo nyi na te lii ta debaŋ keŋ fiigi daase na see ya. ");
INSERT INTO ntr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Botɔɔ te ɔ falaa daŋ keŋ nyiaa, “Lee gyɛŋ ne gyu n be gyae n ka tekaa se bia na ŋolo ke di ya.” Te ɔ kaseela baŋ nyii kpene keŋ ɔ be yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Be kelii Gyerusalɛm donɔɔ man nɛ, ɔ gyuuwɔ Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man. Ɔ ke gyu botɔɔ nɛ, na balaŋ baŋ ta mo botɔɔ besena kebu dedii. Keŋte ɔ gegi balaŋ baŋ bɛɛ yɔɔ abɔɔ na baŋ bɛɛ lɛɛ abɔɔ botɔɔ nɛ. Ɔ besena baŋ bɛɛ yɛlɛɛ kɔbase nɛ tebuluse buŋii, te ɔ tɛɛse baŋ bɛɛ yɔɔ awuluŋna nɛ gbelɛɛ mɔ lɔ. ");
INSERT INTO ntr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te ɔ te fa ŋolo gbɛɛ waa seele kolo aneyɔɔŋ kaalaŋ Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Botɔɔ te ɔ bɔɔse balaŋ baŋ nyiaa, “Ɛ te kala ta Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nyi, Wurubuarɛ kpa, ‘Me deni gyae ke yɛɛ botɔɔ keŋ tɛɛle kei dɔɔ balaŋ pou baa kɔŋ kaa fane, mɔna ɛmɛɛ ta besena ke yɛɛ ŋmɛɛlatena dɛɛgyaŋee.’ ” ");
INSERT INTO ntr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Saese kegyiise na Gyudatena mmaraa wolala baŋ ke nyii kpene keŋ ɔ be yako nɛ, be gyae gbɛɛ keŋ baa mo koe e. Mɔna gyakoloŋ gyoo wɔ, nawolo nyi ɔ kawola keŋ te yeli balaŋ baŋ pou wose ta yeŋ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kelii balinɔɔ nɛ, te ba leewɔ Gyerusalɛm donɔɔ man laŋ. ");
INSERT INTO ntr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tɛɛ kena nebo keŋ be dɔŋ bee gyu nɛ, be naawɔ nyi fiigi daŋ keŋ Yesu be falaa ke nɛ ta yem leenaŋ ke lila man. ");
INSERT INTO ntr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Botɔɔ te Pita tɔɔse kpene keŋ Yesu be yako nɛ te ɔ yako e nyiaa, “Me Gbeŋgyoo, kɛɛ! Fiigi daŋ keŋ n be falaa ke nɛ ta yem.” ");
INSERT INTO ntr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Keŋte Yesu yako wɔ nyiaa, “Ɛ lɛɛ Wurubuarɛ di. ");
INSERT INTO ntr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ampaŋ yaa mɛɛ yako ŋon nyiaa, walaŋ kamasɛ ŋon waa yako bula kei nyi, ‘Kulu lee kɛbo ka gyoo ɛpo man’ te ɔ te lɛɛ ɔ wose aŋmaareŋ ya, te ɔ lɛɛ di nyi kpene keŋ ɔ be yako nɛ gyae ke kɔŋ mena fa e nɛ, ke gyae ke kɔŋ mena fa ɔtenate. ");
INSERT INTO ntr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mena dɔɔ mɛɛ yako ŋon nyiaa, kpene kamasɛ keŋ ɛ fane nyi Wurubuarɛ waa yɛɛ fa ŋon nɛ, ɛ lɛɛ di nyi ɛ te wulaa nyiŋ ke, te ɛ ke nyiŋ ke mɔ. ");
INSERT INTO ntr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te akpaa n seŋɛɛ n ne fane fa Wurubuarɛ, te n tɔɔse nyi ŋolo nombia doo n konɔɔ man nɛ, kaboena nyi nya mo ɔtenate nombiakumɛɛ kyɛɛ e, na n kya Wurubuarɛ ŋon ɔ kyaa adido mɔ ke nyiŋ mo n wui nombiakumɛɛ kyɛɛ neŋ. ");
INSERT INTO ntr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mɔna akpaa ɛ ta mo ɛ tebia nombiakumɛɛ kyɛɛ wɔ ya nɛ, ɛ kya ŋon ɔ kyaa adido mɔ be gyae waa mo ɛ wui nombiakumɛɛ kyɛɛ ŋon ya.” ");
INSERT INTO ntr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Keŋte Yesu na ɔ kaseela baŋ besewɔ kɔŋ Gyerusalɛm donɔɔ man. Te Yesu ke ta Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man ɔ ne lam nɛ, Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala na Gyudatena kegyiise kɔŋawɔ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Te be bɔɔse e nyiaa, “Doŋ woŋti yaa n dana n ne yɛɛ mena abɔɔ kɛŋa pou? Amɔte faa na neŋ mena doŋ kenaŋ?” ");
INSERT INTO ntr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Maŋ mɔ ne gyae maa bɔɔse ŋon nombii dokoloŋ. Nyi akpaa ɛ tiranɔɔ fa maŋ nɛ, kenaŋ na maa wola ŋon doŋ keŋ me dana mɛɛ yɛɛ mena abɔɔ kɛŋa pou. ");
INSERT INTO ntr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gyɔn Wurubuarɛ loŋkesɔ keŋ ɔ be sɔ balaŋ nɛ, ka lee Wurubuarɛ gyaŋ yaa ka lee balaŋ gyaŋ? Ɛ tiranɔɔ fa maŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Botɔɔ te ba gyoo nombia ŋan man te be bɔɔse dɔŋa nyiaa, “Akpaa de yako nyi ka lee Wurubuarɛ gyaŋ na waa bɔɔse daa nyi, ‘Kenaŋ na woŋ dɔɔ te da te lɛɛ Gyɔn nombia ŋan di ya?’ ");
INSERT INTO ntr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te akpaa de yako nyi ‘Ka lee balaŋ gyaŋ’ na, dee yee balaŋ burum kɛwɔ mɔ. Nawolo nyi be popou ne lɛɛ di nideli nyi Gyɔn yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e.” ");
INSERT INTO ntr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mena dɔɔ be tiranɔɔ fa Yesu nyiaa, “Dɔɔ gyeŋ ya.” Keŋte Yesu mɔ yako wɔ nyiaa, “Akpaa mena na maŋ mɔ ba wola ŋon me doŋ keŋ me dana mɛɛ yɛɛ tom nɛ dalee ya.” ");
INSERT INTO ntr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Keŋte Yesu besewɔ kolosi nombia burum fa wɔ aduya man, te ɔ gyɔɔ dudu fa wɔ nyiaa, “Wɔɔfarale ŋolo fara wɔɔ te ɔ duu daasebia ŋaale ŋan ŋe yɛɛ ŋgba akutuse te bɛɛ baake ŋa nyi gerepo nɛ ke man. Ɔ dii abaŋ kilisi wɔɔ keŋ, te ɔ wula bɔɔ keŋ baa sara daasebia ŋan ke man na baa lese ŋa loŋ lee ŋe man nɛ. Te ɔ baŋa deni dɔɔloŋ dɔɔloŋ daale keŋ walaŋ ke kyaa ke man na waa gyee wɔɔ kenaŋ. Te ɔ moo wɔɔ keŋ do paasetena baale nyiŋmaa man nyi baa kɛɛ ke dɔɔ, te ɔ korowɔ laŋ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Debaŋ kelii nyi baa kɔ daasebia ŋan nɛ, balee ŋon kpila ɔ tobaale ŋolo gyu paasetena baŋ gyaŋ nyi baa fa e ɔ wui nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mɔna paasetena baŋ kyaŋa ɔ tobaale ŋon, te be tuku e te be yela ɔ laŋawɔ nyiŋmaase kufu nawɔɔ kufu. ");
INSERT INTO ntr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Keŋte wɔɔte ŋon besewɔ kpila ɔ tobaale ŋolo bela gyu paasetena baŋ gyaŋ. Mɔna be tuku ŋon mɔ do e gyamɛɛ ɔ nyee man, te ba doo e desɛŋ. ");
INSERT INTO ntr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kenaŋ wɔle wɔɔte ŋon besewɔ kpila ɔ tobaale ŋolo bela, mɔna paasetena baŋ koo e bo. Ɔ kpila tewulɛɛ burum, mɔna be tuku baale te ba koe baale. ");
INSERT INTO ntr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Walaŋ ŋon ɔ be kaa keŋ wɔɔte ŋon waa kpila yɛna, ŋon gbagba bu dokoloŋ kooŋ ŋon ɔ bɛɛ sɛɛ ɔ dɔɔ ya nɛ. Wɔle wɔle nɛ, ɔ kaa kpila ŋon mɔ gyu paasetena baŋ gyaŋ te ɔ yakowɔ nyiaa, ‘Mberem me bu na, baa bu e.’ ");
INSERT INTO ntr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mɔ paasetena baŋ kena ɔ bu ŋon nɛ be yako dɔŋa nyiaa, ‘Kei yɛna bu ŋon waa kaa di ɔ kya abɔɔ ŋan. Ɛ yela dɛɛ ko e, na abɔɔ ŋan nafɔ waa di nɛ ka bese de wui!’ ");
INSERT INTO ntr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mena dɔɔ be kyaŋa bu ŋon ko, te be wɔŋee e lee wɔɔ keŋ man ke leki.” ");
INSERT INTO ntr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Woŋ te wɔɔte ŋon waa yɛɛ? Waa kɔŋ kaa koe mena paasetena benaŋ, na waa mo wɔɔ keŋ do paasetena wɔlɛɛ nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Te ɔ besewɔ bɔɔse wɔ nyiaa, “Ɛ te kala ta Wurubuarɛ nombia aŋmaraseŋ see ŋan na ɛ kena kpene keŋ ne yako nɛ yee? Be ŋmarasewɔ nyiaa, ‘Boe keŋ deni maara baŋ be bɛɛ nɛ, keŋ kaa bese na mokɔɔ kasee boe keŋ ne yeli deni keŋ ne yɛɛ doŋ. ");
INSERT INTO ntr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","De Gbeŋgyoo Wurubuarɛ yɛɛ la te kɔŋawɔ mena, te ke yɛɛ kpene keŋ ke dana gyakoloŋ de siaman’ ” Saese kegyiise na Farasiitena baŋ ke nyii Yesu aduya kɛŋa nɛ, ba gyeŋawɔ nyi ba wose man nombia yaa ɔ ne yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Botɔɔ te Gyudatena kegyiise baŋ gyae gbɛɛ baa kyaŋ Yesu, nawolo nyi be naawɔ nyi baŋ dɔɔ te ɔ gyɔɔ dudu kei. Mɔna bee yee balaŋ baŋ, mena dɔɔ be tinaa e yela te be laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kenaŋ wɔle te Gyudatena kegyiise baŋ gyuuwɔ ke kpila gyoo Herode balaŋ baale, na Farasiitena baŋ baale nyi baa kɔŋ kaa teese Yesu nɔɔman na baa nyiŋ gbɛɛ kyaŋ e. ");
INSERT INTO ntr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baŋ mɔ kɔŋawɔ ɔ gyaŋ kaa bɔɔse e nyiaa, “De Gbeŋgyoo, da gyeŋ nyi n bee di dekara ya, te n be famenɛ na kpene keŋ balaŋ ne yako nɛ ya. N bɛɛ kɛɛ walaŋ siaman ya, te n na wola Wurubuarɛ gbɛɛneŋ kpaakpaa ŋan ŋe gbɛɛ dɔɔ. Dei nyi dɛɛ tɔ lempoo fa Romantena gyoo dinaa Kaesa, yaa de na tɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mɔ Yesu kena ba agyueŋ kumɛɛ ŋan nɛ ɔ yako wɔ nyiaa, “Ɛmɛɛ baŋ ɛ na beo ɛ wose, woŋ dɔɔ te ɛ ne gyae ɛ ka teese me nɔɔman. Ɛ mo kɔbabii keŋ kɔŋ maa kɛɛ” ");
INSERT INTO ntr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Keŋte ba moo kɔbabii dokoloŋ kɔna e. Botɔɔ te ɔ bɔɔse wɔ nyiaa, “Amɔte nyee na ɔ yele gyakaa la ke dɔɔ?” Te be yako e nyi gyoo dinaa Kaesa wui. ");
INSERT INTO ntr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Keŋte Yesu yako wɔ nyiaa, “Kpene keŋ yɛɛ gyoo Kaesa wui na ɛ mo fa e, te kpene keŋ mɔ yɛɛ Wurubuarɛ wui nɛ, ɛ mo ke fa e.” Botɔɔ te gyakoloŋ gyoo balaŋ baŋ lee nɔɔ keŋ Yesu be tiri fa wɔ nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kenaŋ wɔle te Sadukiitena baŋ bɔɔ ne lɛɛ di nyi walaŋ da yem na waa bese foŋ ya nɛ, man baale kɔŋawɔ Yesu gyaŋ kaa bɔɔse e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“De Gbeŋgyoo, de naana Mosesi ŋmarase mmaraa fa daa nyi, akpaa walaŋ da yem tina ɔ wɛɛle yela te be ta lola bia ya na, ɔ naabu waa yala lialo ŋon na baa lola bia ɔ kegyia ŋon yele man. ");
INSERT INTO ntr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kɔŋawɔ nyi balee ŋolo bia baala nyetooro baale kyaawɔ, te be kegyia ŋon yala alo keŋ be ta lola bia ya te ɔ yeŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Balate ŋon mɔ yala alo ŋonaŋ te ŋon mɔ yeŋawɔ keŋ be ta lola bia ya. Batoorote ŋon mɔ mena. ");
INSERT INTO ntr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mena mɔ te akaŋ baŋ mɔ pou yala alo ŋonaŋ, mɔna be ta lolo ya. Te kyare ya, te alo ŋon mɔ yeŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mena dɔɔ wee keŋ Wurubuarɛ waa gyuusu balaŋ baŋ pou bɔɔ yem nɛ lee yeŋ man na, baala nyetooro kɛwɔ baŋ bɔɔ yala alo kei gyaŋee nɛ, be man woŋti te alo ŋon waa yɛɛ ɔ wɛɛle?” ");
INSERT INTO ntr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ ta yoo, nawolo nyi ɛ ba gyeŋ Wurubuarɛ nombia aŋmaraseŋ see ŋan ya, te ɛ ba gyeŋ Wurubuarɛ doŋ keŋ mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wee keŋ Wurubuarɛ waa gyuusu balaŋ lee yeŋ man nɛ, baala be gyae baa yala ya, te bɔɔ gyae baa mo ala mɔ fa yale ya. Be popou baa yɛɛ bo ŋgba Wurubuarɛ kpilala baŋ be kyaa adido nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lee kefoŋ lee yeŋ man wose man nombia na, ɛ te kala ta de naana Mosesi tɔne man mena keŋ Wurubuarɛ be kolosi na ŋon Mosesi depoŋfa keŋ ne kpaa nɛ man yee? Ɔ yakowɔ nyiaa, ‘Maŋ yɛna Aberaham na Asiki na Gyekɔpo Wurubuarɛ.’ Wurubuarɛ keyako kei nɛ, na nawolo baa nyi ɔ siaman na balaŋ kɛwɔ sɛɛ be kyaa ");
INSERT INTO ntr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wurubuarɛ te yɛɛ woya Wurubuarɛ e ya, ɔ yɛɛ balaŋ baŋ be kyaa na be sia nɛ Wurubuarɛ e. Mena dɔɔ ɛ ta yoo nideli ŋgba ɛ ne yako nyi yeŋ wɔle kefoŋ be kyaa ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Botɔɔ te Gyudatena mmaraa wolala baŋ man ŋolo kɔŋawɔ botɔɔ. Ɔ ke kɔŋ kaa nyii mena keŋ bɛɛ wɔŋee nombia ŋan, na ɔ kena nyi Yesu ke tiranɔɔ fa wɔ nideli nɛ ɔ bɔɔse e nyiaa, “Wurubuarɛ mmaraase ŋan pou na, woŋti yɛna keŋ ne hia kela?” ");
INSERT INTO ntr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Botɔɔ te Yesu tiranɔɔ fa e nyiaa, “Iseraetena pou ɛ nyii, ‘De Gbeŋgyoo Wurubuarɛ ŋon yɛɛ dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mena dɔɔ kaboena nyi nya mo n konɔɔ pou na nya agyueŋ pou na n doŋ pou gyae n Gbeŋgyoo Wurubuarɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Alate keŋ mɔ yɛna nyi, ‘Gyae n dɔɔ ŋgba nyaŋ gbagba n wose nɛ.’ Mmaraa daale be kyaa keŋ kela kɛŋa ya.” ");
INSERT INTO ntr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Keŋte Gyudatena mmaraa wolale ŋon yako Yesu nyiaa, “De Gbeŋgyoo, ampaŋ yaa n yakowɔ nyi Wurubuarɛ yɛɛ dokoloŋ, te ŋolo be kyaa kpu na e ya. ");
INSERT INTO ntr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te n besewɔ yako nyi kaboena nyi walaŋ waa mo ɔ konɔɔ pou na ɔ doŋ pou na wa agyueŋ pou gyae Wurubuarɛ, na waa bese gyae ɔ dɔɔ ŋgba ŋon gbagba nɛ. Mmaraase kɛŋa dɔɔ kedi dei kela keŋ walaŋ ka mo abɔɔ ke deesi fa Wurubuarɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu kena nyi Gyudatena mmaraa wolale ŋon te tiranɔɔ nideli nɛ ɔ yako e nyiaa, “Ɛmɛɛ na Wurubuarɛ gyoori keŋ nsana be dana lem ya.” Lee kei wɔle nɛ, ŋolo te tale gyɔ ɔ konɔɔ bɔɔse e nombii daale bela ya. ");
INSERT INTO ntr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu ke gyakaa ɔ na wolo Gyudatena ɔsom deni dinaa keŋ dekpaŋalaŋ man nɛ ɔ bɔɔse wɔ nyiaa, “Sena dɔɔ te Gyudatena mmaraa wolala baŋ ne tale yako nyi, Kristo ŋon Wurubuarɛ ba lese nɛ yɛɛ gyoo Defidi ɔ naanabii e? ");
INSERT INTO ntr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nawolo nyi Wurubuarɛ feliŋ ŋon yela gyoo Defidi gbagba yakowɔ nyiaa, ‘Me Gbeŋgyoo Wurubuarɛ yako me Gbeŋgyoo nyi, Tisi kyaa me dunoluŋ dɔɔ, kelii debaŋ keŋ maa mo n kɔlala pou do n tɛɛ.’ ");
INSERT INTO ntr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Te akpaa nyi gyoo Defidi baake nyeelɛɛre ŋon nyi ɔ ‘Gbeŋgyoo’ na, kenaŋ na sena te nyeelɛɛre ŋon waa bese gyoo Defidi ɔ naanabii?” Keŋte yɛɛ balaŋ baŋ pou bɔɔ gyaŋee bee tei nɛ gyoŋ. ");
INSERT INTO ntr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu kɛɛ wolo nɛ ɔ faree wɔ nyiaa, “Ɛ kɛɛ ɛ wose nideli na Gyudatena mmaraa wolala baŋ. Bɛɛ gyae kegbase dɔɔloŋ nyiŋan kado na be dɔŋ na kebu agantaŋ man, na balaŋ kenyiŋ do wɔ nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Akpaa be gyaŋee Gyudatena ɔsom denɛɛ man, na botɔɔse ŋan bɛɛ gyaŋee di be nɔɔ nɛ, na bɛɛ gyae akyaese kpaakpaa baa kyaa. ");
INSERT INTO ntr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɛɛ beo liala lɛo ba abɔɔ kamasɛ ŋan be dana nɛ. Te bɛɛ fane balaŋ man kyare mo wola ba wose. Wurubuarɛ waa wɔŋ mena balaŋ benaŋ dinɔɔ deŋela nideli.” ");
INSERT INTO ntr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ke gyu ka gyoo Wurubuarɛ ɔsom deni dinaa keŋ man nɛ, ɔ ke kyaawɔ yenaŋ mo ɔ sia tee adakaa keŋ bɛɛ do kɔba ke man nɛ. Te ɔ gyinaa ɔ sia ɔ ne kɛɛ mena keŋ balaŋ na mo kɔba kaa do adakaa keŋ man. Balaŋ baŋ be dana kɔba nɛ, moo kɔba burum kaa do adakaa keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Keŋte lialo diyemte ŋolo moo kɔbabia ala, ŋan ŋe gyae ke yɛɛ ŋgba kotoku dokoloŋ nɛ kaa do adakaa keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Botɔɔ te Yesu baake ɔ kaseela baŋ gyaŋee te ɔ yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyi lialo diyemte kei ta do kɔba kela balaŋ akaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nawolo nyi balaŋ baŋ pou lese kɔba kyomii bo lee burum ŋan be dana nɛ man kaa do. Mɔ lialo diyemte kei dɔɔ, keŋ na ɔ diyem koraŋ nɛ kpene kamasɛ keŋ ɔ dana nɛ yaa ɔ moowɔ kaa do nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu kɛɛ lee Gyudatena ɔsom deni dinaa keŋ man nɛ, ɔ kaseela baŋ man ŋolo yako e nyiaa, “De Gbeŋgyoo, kɛɛ boya ŋan bɔɔ mo ma deni kei, na deni keŋ mɔ kyeo!” ");
INSERT INTO ntr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Botɔɔ te Yesu mɔ yako wɔ nyiaa, “Ŋgba ɛ ne naa denɛɛ dinaana kɛŋa? Baa tekerii ŋe popou lɔ keŋ nyi ɛ be gyae ɛ kena boe na boe gyakaa ke dɔɔ dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Keŋte Yesu gyuuwɔ ke kyaa oliifi bula keŋ dɔɔ, te ɔ moo ɔ sia tee Wurubuarɛ ɔsom deni dinaa keŋ. Ɔ kekyaa botɔɔ te Pita na Gyemisi na Gyɔn na Anderiase baageŋ kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wola daa debaŋ keŋ nombia kɛŋa pou gyae ke kɔŋ. Woŋ te dɛɛ mo naa nyi kɛŋa pou gyae ke kɔŋ?” ");
INSERT INTO ntr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ kɛɛ ɛ wose man nideli, na ŋolo ba beo ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Balaŋ burum baa kɔŋ ma yele man na be kaa yako nyi, ‘Baŋ yɛna maŋ Nyeelɛɛre ŋon,’ na baa beo balaŋ burum na baa yo gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Akpaa ɛ nyii yoo na yoose nombia nɛ, ɛ na yeli ɛ wɔe ke lɔ ŋon ya. Kaboena nyi mena abɔɔ kɛŋa pou dɛɛkɔŋ mena, mɔna kei bɛɛ wolo nyi debaŋ ɔtomante keŋ te lii ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tɛɛlese baa koro seŋ tia dɔŋa, na gyooneŋ mɔ ka koro seŋ tia dɔŋa. Tɛɛle gyae ke wosi yenaase burum, te tanam mɔ gyae ke yala tɛɛle dɔɔ. Mɔna kɛŋa pou yɛɛ yaa ŋgba fulute kadoŋee kewalaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mena dɔɔ ɛ kɛɛ ɛ wose dɔɔ nideli, nawolo nyi baa mo ŋon gyina donɔɔ kegyiise na baa tuku ŋon Gyudatena ɔsom denɛɛ man. Lee maŋ dɔɔ, baa mo ŋon gyu tɛɛle kegyiise na gyooneŋ siaman. Kei gyae ke yela ɛ ke nyiŋ gbɛɛ kolosi Wurubuarɛ nombia ŋan fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mɔna kaboena nyi me silala baa taŋgbɛɛ kolosi Wurubuarɛ nombia kpaakpaa ŋan fa tɛɛle kei dɔɔ balaŋ pou pɛ. ");
INSERT INTO ntr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nyi akpaa be kyaŋ ŋon gyu nombia dedii man nɛ, ɛ na wɔlɛɛ na kpene keŋ ɛ keyako ya. Kpene keŋ Wurubuarɛ waa mo do ɛ nɔɔse man debaŋ kenaŋ nɛ, keŋ te kaboena nyi yaa yako. Nawolo nyi na ɛmɛɛ ne gyae la ɛ kekolosi ya, mɔna Wurubuarɛ feliŋ ŋon ne gyae la waa kolosi fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naa lolo bia baa lese dɔŋa fa yeŋ, na kya mɔ ka lese ɔ bu fa yeŋ. Bia baa koro seŋ tia ba lolala, na baa lese wɔ fa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Maŋ dɔɔ balaŋ pou baa kɔla ŋon. Mɔ walaŋ ŋon ɔ kyaŋ ɔ wose seŋ keŋkeŋ kelii ɔto nɛ, Wurubuarɛ waa lɛɛ ɔ nyee. ");
INSERT INTO ntr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nyi akpaa ɛ naa kpene keŋ bɛɛ kɔle te ke dana duwaare nɛ de kaa seŋ botɔɔ keŋ tekaboena nyi ke dɛɛ seŋ ya nɛ, (kaboena nyi walaŋ kamasɛ ŋon ɔ ne kala tɔne kei nɛ, waa yɛɛ kakyeŋ na waa nyii ke man). Dekɔŋ mena na, balaŋ baŋ be kyaa Gyudia tɛɛle dɔɔ nɛ, baa yeu gyu bulase dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nyi akpaa ŋolo kyaa ɔ deni nyee dɔɔ na, ɔ na tisi kɔŋ tɛɛle man nyi ɔ kaa mo ɔ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te akpaa ŋolo mɔ kyaa wɔɔman na, ɔ na bese gyu dɛɛ nyi ɔ ka mo ɔ kegba ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mena weeya ŋenaŋ man nɛ, fulɛɛtena na talabose baa laako. ");
INSERT INTO ntr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mena dɔɔ ɛ fane fa Wurubuarɛ nyi, mena nombia kɛŋa naa kɔŋ waaretɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nawolo nyi weeya ŋenaŋ man nɛ, balaŋ baa naa diyem keŋ leenaŋ debaŋ keŋ Wurubuarɛ be yɛɛ tɛɛle kei kaa lii na gyɛŋ nɛ, mena diyem kenaŋ te kɔŋa ta see ya, te ke dinɔɔ mɔ be gyae kekɔŋ mɔ see ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na Wurubuarɛ ke kɔkee kayeyɛɛ weeya kɛŋa ya nɛ, nafɔ ŋolo na ŋolo be gyae waa ka ya. Mɔna lee ɔ balaŋ baŋ ɔ ba lese see nɛ dɔɔ, te ɔ kɔkee weeya ŋenaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Debaŋ kenaŋ de lii te ŋolo de yako ŋon nyi ‘Ɛ kɛɛ Kristo ŋon kyaa kɛbo, yaa ɔ kyaa yenaŋ daale na’ ɛ na lɛɛ ke di ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nawolo nyi balaŋ baa dii akɛrɛɛ nyi baŋ yɛna maŋ Kristo ŋon, te baale mɔ baa dii akɛrɛɛ nyi be yɛɛ Wurubuarɛ akpeŋkpeŋgyɔɔrawɔ. Baa yɛɛ gyakoloŋ nombia na nombia dinaana, te akpaa be tale nyiŋ gbɛɛ koraŋ na, baa mo beo Wurubuarɛ balaŋ baŋ ɔ ba lese see nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mɔna ɛmɛɛ dɔɔ ɛ doo ɛ wose dɔɔ, nawolo nyi me taŋ wulaa yako ŋon nombia kɛŋa.” ");
INSERT INTO ntr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Weeya ŋenaŋ man kayeyɛɛ kɛŋa pou wɔle na weese waa gyoo ditiŋtɛɛ, te gyaalaŋ mɔ be gyae waa wolose ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kyolobiise baa lee adido kaa yala. Te abɔɔ ŋan pou ŋe kyaa adido nɛ, gyae ke wosi. ");
INSERT INTO ntr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Debaŋ kenaŋ nɛ, balaŋ baa naa maŋ Deniwalaŋ Bu ŋon ta mo doŋ na gyoorobiiri lee ŋɔma man adido mɛɛ kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te maa kpila me kpilala lee adido na be kaa yilaa me balaŋ baŋ Wurubuarɛ ba lese wɔ see tɛɛle kei dɔɔ yenaŋ kamasɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ kɛɛ fiigi daŋ na ɛ ke kasee kolo lee ka wose man. Akpaa ɛ naa ŋgba ke tombia da potee faareŋse wɔlɛɛ nɛ, na ɛ gyeŋ nyi awuluŋtɛɛ ta benaa baa. ");
INSERT INTO ntr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mena mɔ te akpaa ɛ naa mena nombia kɛŋa ne kɔŋ na, ɛ gyeŋ nyi maŋ Deniwalaŋ Bu ŋon kekɔŋ ta benaa taŋ. ");
INSERT INTO ntr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ampaŋ yaa mɛɛ yako ŋon nyi balaŋ baŋ be kyaa gyɛŋ kei nɛ, be duuluŋ be gyae ke munu taŋ ya, pɛte nombia kɛŋa kekɔŋ. ");
INSERT INTO ntr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adido na tɛɛle kei pou gyae ke gyu ɔto, mɔna me nɔɔwoya dɔɔ ŋan gyae ke kyaa kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ŋolo ba gyeŋ wee na debaŋ keŋ kɛŋa pou gyae ke kɔŋ ya. Wurubuarɛ kpilala baŋ be kyaa adido, na maŋ Deniwalaŋ Bu ŋon koraŋ ba gyeŋ ya. Gyisɛ me kya ŋon ɔ kyaa adido nɛ waageŋ gyeŋa la. ");
INSERT INTO ntr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mena dɔɔ ɛ kɛɛ nideli na ɛ ke desina ɛ wose see, nawolo nyi ɛ ba gyeŋ wee keŋ debaŋ kenaŋ gyae ke kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ke yɛɛ ŋgba walaŋ ŋon ɔ ba koro ɔ ne gyu gbɛɛ, te ɔ ba mo ɔ dekpaŋalaŋ do ɔ tewulɛɛ nyiŋmaa man nɛ. Ɔ faa be man walaŋ kamasɛ tom keŋ waa yɛɛ, te ɔ yako ŋon ɔ na deke denanɔɔ keŋ nɛ nyi waa deke ke nideli. ");
INSERT INTO ntr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mena dɔɔ ɛmɛɛ mɔ ɛ doo ɛ wose dɔɔ, nawolo nyi ɛ ba gyeŋ wee keŋ dekpaŋalaŋte ŋon waa kɔŋ ya. Waa tale kɔŋ balinɔɔ yaa tɛɛnsana, yaa kegyim kɛɛ lɔ woya, yaa nebo nebo. ");
INSERT INTO ntr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɛ doo ɛ wose dɔɔ na ɔ be kɔŋ kaa futaa ŋon nyi ɛ doo dosoroŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nombii kei mɛɛ yako ŋon nɛ, mɛɛ yako baa fa balaŋ pou. Ɛ doo ɛ wose dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Keka weeya ala na Gyudatena nyeekelɛɛwee dinaa keŋ kedi kelii nɛ, Wurubuarɛ saese kegyiise baŋ na Gyudatena mmaraa wolala gyae gbɛɛ keŋ baa mo adao gbɛɛneŋ kyaŋ Yesu na baa ko e. ");
INSERT INTO ntr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Keŋte be yakowɔ nyi, “Ɛ na fa dɛɛ kyaŋ e nyeekelɛɛwee dinaa kei kedi man ya, na mena ya na balaŋ baŋ baa yela donɔɔ keŋ ke siŋii.” ");
INSERT INTO ntr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ke kyaa Bɛtani donɔɔ man nɛ, ɔ gyuuwɔ Simɔn ŋon nafɔ ɔ na wee kawee yayam nɛ dɛɛ ɔ kaa di. Te alo ŋolo kɔŋawɔ botɔɔ na ɔ dana nuŋ ofoŋofoŋte keŋ ke dana koyadoŋ nɛ porontia tɔɔ. Botɔɔ te ɔ toro ke te ɔ toosi nuŋ keŋ woli Yesu nyeeman. ");
INSERT INTO ntr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te balaŋ baŋ be kyaa botɔɔ nɛ baale gyeŋa baŋ bɔɔse dɔŋa nyiaa, “Weera dɔɔ te ɔ wɔlɛɛ nuŋ kei mena. ");
INSERT INTO ntr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nafɔ baa tale yɔɔ nuŋ kei kela tomyɛɛre kulutoo dokoloŋ kɔba, na waa mo ke fa ayematena.” Botɔɔ te ba too be nɔɔ gyakaa alo dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Keŋte Yesu yako wɔ nyiaa, “Ɛ yela e, weera dɔɔ te ɛ ne kale na alo ŋon mena e? Ɔ te yɛɛ kolo kpaakpaa fa maŋ. ");
INSERT INTO ntr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ayematena dɔɔ, baa kyaa ɛ gyaŋ debaŋ kamasɛ. Te debaŋ kamasɛ keŋ ɛ gyae na, ɛ ke tale yɛɛ deeli fa wɔ. Mɔna maŋ dɔɔ, mɔɔ gyae maa kyaa ɛ gyaŋ kelii ɔto ya. ");
INSERT INTO ntr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɔ te yɛɛ kpene keŋ waa tale. Ɔ te taŋgbɛɛ kyɛɛkee nuŋ woli maŋ, na kawola nyi ɔ te desina maŋ fa me ke wuu pɛna maa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, tɛɛle kei dɔɔ yenaŋ kamasɛ keŋ baa kolosi Wurubuarɛ nombia kpaakpaa ŋan nɛ, baa yako kpene keŋ alo kei be yɛɛ nɛ na baa mo tɔɔse e.” ");
INSERT INTO ntr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Keŋte Gyudase Isekarɔte ŋon ɔ yɛɛ Yesu kaseela kufu bala baŋ man ŋolo e nɛ, gyuuwɔ Wurubuarɛ saese kegyiise baŋ gyaŋ nyi waa lese Yesu fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Be ke nyii mena nɛ, yɛɛ wɔ gyoŋ te be yakowɔ see nyi baa fa e kɔba. Lee botɔɔ te Gyudase Isekarɔte kɛo gbɛɛ keŋ waa mo lese e fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nyeekelɛɛwee kedi wee gyaŋgbate keŋ bee di bodobodo keŋ tee be doo ke man ya, te bɛɛ ko Nyeekelɛɛwee kedi nambu ŋon kelii nɛ, Yesu kaseela baŋ kɔŋawɔ ɔ gyaŋ kaa bɔɔse e nyiaa, “Aleŋ te n ne gyae nyi de kaa desina see fa nyeekelɛɛwee dinaa weenɛɛ ŋan?” ");
INSERT INTO ntr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Botɔɔ te ɔ kpila ɔ kaseela baŋ bala te ɔ yako wɔ nyiaa, “Ɛ gyu Gyerusalɛm donɔɔ man. Ɛ ne gyu na ɛ ke gyaŋee na balee ŋolo seele na loŋ na ogele. Ɛ sila e. ");
INSERT INTO ntr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dekpaŋalaŋ keŋ man waa gyoo nɛ, ɛ yako dekpaŋalaŋte ŋon nyi, De Gbeŋgyoo ŋon kpa dɛɛ bɔɔse neŋ nyiaa, ‘Aleŋ te ŋɔɔla deni keŋ daa na me kaseela baŋ dɛɛ kaa di nyeekelɛɛwee dinaa weenɛɛ ŋan nɛ kyaa?’ ");
INSERT INTO ntr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Balee ŋonaŋ waa wola ŋon abansoro deni dinaa daale keŋ ke kyaa adido te bɔɔ desina ke man nideli nɛ. Ɛ desina botɔɔ na de kaa di weenɛɛ ŋan.” ");
INSERT INTO ntr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ɔ kaseela baŋ ke gyu kelii donɔɔ keŋ man nɛ, be naa kpene kamasɛ keŋ Yesu be yako wɔ nɛ pɛpɛɛpɛ, te be desina nyeekelɛɛ weenɛɛ ŋan see botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kelii balinɔɔ nɛ, Yesu na ɔ kaseela kufu bala baŋ kɔŋawɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba ke kyaa bee dii nɛ, te Yesu yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyi ɛmɛɛ baŋ daa na ŋon kyaa dee dii nɛ, ɛ man ŋolo waa lese maŋ fa.” ");
INSERT INTO ntr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Botɔɔ te dekɔkɔrɔkɔɔ kyaŋa ɔ kaseela baŋ, te be bɔɔse Yesu dokoloŋ dokoloŋ nyiaa, “De Gbeŋgyoo, maŋ yaa amɔte?” ");
INSERT INTO ntr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Te Yesu yako wɔ nyiaa, “Ɛmɛɛ kufubala kɛwɔ man ŋolo ŋon daa na e na do de nyiŋmaa nyefale dokoloŋ kei man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Maŋ Deniwalaŋ Bu ŋon maa yeŋ ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see ne yako lee ma wose man nɛ, mɔna walaŋ ŋon waa lese maŋ fa nɛ waa laako. Nyi beŋ ta lola walaŋ ŋonaŋ ya na, nafɔ dei.” ");
INSERT INTO ntr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesu na ɔ kaseela baŋ kee dii nɛ, ɔ moo bodobodo te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ kara ke mo fa ɔ kaseela baŋ. Keŋte ɔ yako wɔ nyiaa, “Ɛ lɛɛ di, kei yɛna ma wosenaane keŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kenaŋ wɔle te ɔ moo leenɔɔ keŋ soloŋ doo ke man nɛ te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ moo ke fa ɔ kaseela baŋ. Keŋte be popou nyɔɔwɔ lee ke man. ");
INSERT INTO ntr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Botɔɔ te ɔ yako wɔ nyiaa “Kei yɛna me fatabo keŋ Wurubuarɛ be kyɛɛkee leki na waa mo tɔ nɔɔkebakesee wɔle keŋ nɔɔ. Kei ne gyae la ke yela na Wurubuarɛ ka mo balaŋ burum nombiakumɛɛ kyɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ampaŋ yaa mɛɛ yako ŋon nyiaa, mɔɔ gyae maa tekaa nyɔɔ soloŋ kei bela ya, kelii wee keŋ maa bese nyɔɔ ke wɔle Wurubuarɛ gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba ke kpee nɔɔneŋ lese Wurubuarɛ yele nɛ, te ba leewɔ donɔɔ keŋ man gyu oliifi bula keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ popou ɛ ke yeu tina maŋ yela. Nawolo nyi Wurubuarɛ yakowɔ ɔ nombia aŋmaraseŋ see ŋan man lee ma wose man nyiaa, ‘Maa gyɔ namensekɛɛlere ŋon lɔ, na ɔ namense baŋ pou ke yaasee.’ ");
INSERT INTO ntr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mɔna me fom lee yeŋ man na, maa kyaŋ ŋon gbɛɛ gyu Galelia tɛɛle man.” ");
INSERT INTO ntr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Keŋte Pita yako e nyiaa, “Akpaa be popou de yeu tina neŋ yela koraŋ na, maŋ dɔɔ mɔɔ gyae maa tina neŋ yela korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Botɔɔ te Yesu yako Pita nyiaa, “Ampaŋ yaa mɛɛ yako neŋ nyi gyɛŋ nelim kei pɛte kegyim kelɔ woya betabola nɛ, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Keŋte Pita yakowɔ seŋ ke dɔɔ keŋkeŋ nyiaa, “Akpaa nyi ke yɛɛ yeŋ ke koraŋ na, mɔɔ gyae maa bɛɛ nyi mɔɔ gyeŋ neŋ korakora ya.” Te ɔ kaseela akaŋ baŋ pou mɔ yakowɔ mena. ");
INSERT INTO ntr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu na ɔ kaseela baŋ kelii botɔɔ keŋ bɛɛ baake nyi Gɛkyɛmane nɛ ɔ yako wɔ nyiaa, “Ɛ kyaa kɛbo na me kaa fane.” ");
INSERT INTO ntr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Te ɔ moo Pita na Gyemisi na Gyɔn sila ɔ wose. Botɔɔ te nombia takaa e nideli, keŋ nyi ɔ bɛɛ gyeŋ mena keŋ waa yɛɛ ɔ wose ya. ");
INSERT INTO ntr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Te ɔ yako ɔ kaseela baŋ nyiaa, “Nombia ne takaa maŋ nideli keŋ mɛɛ gyae maa yeŋ. Ɛ kyaa kɛbo, ɛ na doo ya.” ");
INSERT INTO ntr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Keŋte ɔ gyuuwɔ ɔ siaman kyomii te ɔ tisiwɔ buŋ te ɔ fanewɔ fa Wurubuarɛ nyi, akpaa ɔ ne gyae na waa yela kaale kei ke laŋ ɔ nyee dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Te ɔ yakowɔ nyi, “Me kya, kpene kamasɛ be taŋ neŋ doŋ ya. Lese kaale kei me dɔɔ. Mɔ na yɛɛ kpene keŋ maŋ ne gyae ya. Yɛɛ kpene keŋ nyaŋ gbagba ne gyae.” ");
INSERT INTO ntr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɔ ka bese kɔŋ nɛ, ɔ kaa naawɔ na ba te doo te ɔ gyuusu wɔ bɔɔse Simɔn Pita nyiaa, “Simɔn, ɛ te doo? Ɛ te tale kyaa na ɛ ka deke debaŋ dokoloŋ kooŋ keŋ nyi ɛ be doo yee? ");
INSERT INTO ntr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ɛ na doo ya, ɛ fane na ɛ be nyiŋ gyoo kekɛɛsekɛɛ man ya. Ma gyeŋ nyi ɛ konɔɔse man na ɛ ne gyae ɛ ke yɛɛ ma kegyaebii, mɔna ɛ wosenaane man na ɛ be taŋ mena doŋ kenaŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Keŋte Yesu besewɔ gyu ke fane yako nombii dokoloŋ kenaŋ bela. ");
INSERT INTO ntr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɔ ka bese kɔŋ be gyaŋ na be sɛɛ be doo, nawolo nyi dosoroŋ doo be siaman te be ta gyeŋ kpene keŋ baa yako ya. ");
INSERT INTO ntr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Keŋte Yesu besewɔ kɔŋ be gyaŋ betabotoorote te ɔ bɔɔse wɔ nyi, “Ɛ sɛɛ ɛ gyakaa dosoroŋ kei dɔɔ ɛ ne fɛɛfo? Tekaboe mena, debaŋ keŋ te lii. Be ta lese maŋ Deniwalaŋ Bu ŋon fa nombiakumɛɛyɛɛra. ");
INSERT INTO ntr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ɛ koro dee gyu de kaa gyaŋee na wɔ. Ŋon ɔ na lese maŋ waa fa nɛ te tuŋ daa taŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ke gyakaa ɔ ne kolosi nɛ, Gyudase ŋon ɔ yɛɛ kaseela kufu bala baŋ man ŋolo e nɛ, kaa bɛɛwɔ lee be dɔɔ. Na balaŋ dikpii keŋ be dana yoosilase na akpokpose, na Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ Gyudatena kegyiise ba lese do na e nɛ silana e. ");
INSERT INTO ntr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na Gyudase ŋon ɔ ba lese e fa nɛ taŋ taŋgbɛɛ yako balaŋ baŋ nyiaa, “Walaŋ ŋon maa pukaa e nɛ ŋon ŋonaŋ, ɛ kyaŋ e keŋkeŋ na ɛ ka mo e ta.” ");
INSERT INTO ntr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gyudase ka betaa lii Yesu gyaŋ nɛ, ɔ baake e nyi, “Me Gbeŋgyoo,” te ɔ pukaa e. ");
INSERT INTO ntr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Botɔɔ te balaŋ baŋ kyaŋa e. ");
INSERT INTO ntr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Keŋte Yesu kaseela baŋ man ŋolo ŋon ɔ seŋɛɛ botɔɔ nɛ lese ɔ yoosila kara Wurubuarɛ saese kegyia ŋon tobaale deŋele lese ke lɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Me yɛɛ walaŋkum e te ɛ moo yoosilase na akpokpose ɛ ne kɔŋ ɛ kaa kyaŋ maŋ? ");
INSERT INTO ntr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wee kamasɛ keŋ me kyaa ɛ gyaŋ Wurubuarɛ ɔsom deni dinaa keŋ man mɛɛ wola ŋon nɛ, ɛ te kyaŋ maŋ ya. Mɔna nombia kɛŋa pou kɔŋae, na ke yela Wurubuarɛ nombia aŋmaraseŋ see ŋan ke kɔŋ mena.” ");
INSERT INTO ntr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Keŋte Yesu kaseela baŋ pou yeuwɔ tina e yela. ");
INSERT INTO ntr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na tobaale ŋolo ŋon ɔ wuuna kanyaŋbii nɛ silana Yesu. Be ka mo baa kyaŋ e nɛ, ");
INSERT INTO ntr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","te ɔ leewɔ be nyiŋmaa man yeu diteŋteli tina ɔ kanyaŋbii keŋ yela. ");
INSERT INTO ntr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Keŋte ba moo Yesu gyu Wurubuarɛ saese kegyia ŋon gyaŋ, te Wurubuarɛ saese kegyiise baŋ pou na Gyudatena mmaraa wolala, na Gyudatena kegyiise kaa gyaŋeewɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Pita silana Yesu wɔle wɔle lemlem gyu Wurubuarɛ saese kegyia ŋon dekpaŋalaŋ man. Botɔɔ te Pita gyuuwɔ ke kyaa kotɔtɔɔtena baŋ bee gyee dekpaŋalaŋ keŋ nɛ gyaŋ bee woli boalaŋ. ");
INSERT INTO ntr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na Wurubuarɛ saese kegyiise, na Gyudatena kegyiise akaŋ baŋ ne kɛo nombii keŋ baa mo gyakaa ɔ dɔɔ na baa nyiŋ gbɛɛ ko e, mɔ be te nyim ya. ");
INSERT INTO ntr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Balaŋ burum kɔŋawɔ kaa kɛrɛɛ ɔ nɔɔse, mɔna be nɔɔwoya ŋan te kyaa na dɔŋa ya. ");
INSERT INTO ntr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Te baale korowɔ kɛrɛɛ ɔ nɔɔse nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“De te nyii nyi ɔ kpa waa tekerii Wurubuarɛ ɔsom deni dinaa keŋ balaŋ be maa nɛ, te weeya atooro wɔle na waa ma wɔle keŋ te yɛɛ walaŋ maa na ke ya.” ");
INSERT INTO ntr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Baŋ mɔ nombia ŋan bɔɔ kaa yako nɛ, te kyaa na dɔŋa ya. ");
INSERT INTO ntr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Botɔɔ te Wurubuarɛ saese kegyia ŋon korowɔ seŋ kebu keŋ nsana nsana te ɔ bɔɔse Yesu nyiaa, “N be tiranɔɔ yee? Woŋ dɔɔ te balaŋ kɛwɔ ne kɛrɛɛ n nɔɔse, te n be tiranɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mɔ Yesu te gyuusu ɔ nɔɔ ya. Botɔɔ te Wurubuarɛ saese kegyia ŋon bɔɔse e nyi, “Nyaŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi nyaŋ ke kɔŋ nɛ? Nyaŋ yɛna Wurubuarɛ ŋon kaboena nyi baa lese ɔ yele nɛ bu dokoloŋ ŋon?” ");
INSERT INTO ntr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Keŋte Yesu tiranɔɔ nyi, “Ayi, maŋ ŋonaŋ. Ɛ kena maŋ Deniwalaŋ Bu ŋon kyaa Wurubuarɛ doŋte ŋon dunoluŋ dɔɔ. Na ɛ ka bese naa maŋ na me dɔŋ ŋɔma man adido mɛɛ kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Botɔɔ te Wurubuarɛ saese kegyia ŋon tirii ŋon gbagba kegba te ɔ bɔɔse wɔ nyiaa, “Woŋ adansɛɛ yaa dɛɛ gyae dee nyii bela?” ");
INSERT INTO ntr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɛ te nyii mmusuo nombia ŋan ɔ be yako yee? Sena yaa ɛ na gyueŋ lee ke man? Te kegyiise baŋ pou too be nɔɔ gyakaa ɔ dɔɔ bu e fɔɔ nyi, “Kaboena nyi baa ko e.” ");
INSERT INTO ntr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Keŋte balaŋ baŋ baale fiasɛɛ bɛɛ tɔ nɔɔloŋ woli e, te be wuu ɔ sia na bɛɛ takee e akɔtase. Te be bɔɔse e nyi, “Wurubuarɛ dekpeŋkpeŋgyɔɔre, wola daa ŋon ɔ be gyɔ neŋ.” Keŋte ba moo e fa kotɔtɔɔtena baŋ te baŋ mɔ ke tuku e. ");
INSERT INTO ntr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ke kyaa dekpaŋalaŋ keŋ man nɛ, Wurubuarɛ saese kegyia ŋon alebu ŋolo kɔŋawɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ɔ kena Pita kyaa ɔ ne woli boalaŋ nɛ, ɔ kɛɛ e yididi te ɔ yako e nyiaa, “Nyaŋ mɔ n kpuɛ na Yesu Nasarɛte baale ŋon.” ");
INSERT INTO ntr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mɔ Pita lɛɛ aŋmaareŋ te ɔ yako e nyi, “Mɔɔ gyeŋ kpene keŋ n ne yako nɛ man korakora ya.” Botɔɔ te Pita leewɔ gyu denanɔɔ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Alebu ŋon ka bese naa Pita botɔɔ nɛ ɔ yako balaŋ baŋ ba seŋɛɛ botɔɔ nɛ nyiaa, “Balee kei mɔ kpuɛ na wɔ.” ");
INSERT INTO ntr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mɔ Pita besewɔ bɛɛ ke bela. Kenaŋ wɔle nɛ, balaŋ baŋ ba seŋɛɛ botɔɔ nɛ besewɔ yako Pita nyiaa, “Ke yɛɛ ampaŋ nyi n kpuɛ na wɔ, nawolo nyi n yɛɛ Galelia baale e.” ");
INSERT INTO ntr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Botɔɔ te Pita moo nɔɔdoŋ kolosi te ɔ kaŋa ntam kpu nyiaa, “Mɔɔ gyeŋ balee kei ŋon ɛ ne kolosi ɔ wose man nombia nɛ korakora ya” ");
INSERT INTO ntr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Debokenaŋ man te kegyim lɔɔ woya betabolate. Keŋte Pita tɔɔse nombia ŋan Yesu be yako e nɛ nyiaa, “Pɛ kegyim kelɔ woya betabola na, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ ya.” Keŋte ɔ yɛlɛɛwɔ do ɔ ne wii. ");
INSERT INTO ntr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tɛɛ kena nebo nebo fuu nɛ, saese kegyiise na donɔɔ kegyiise na Gyudatena mmaraa wolala gyaŋeewɔ te be bake Yesu nyeeman. Mena dɔɔ be bake e te ba moo e gyu ka do Pilato ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man nɛ, nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Keŋte Pilato bɔɔse e nyiaa, “Nyaŋ yɛna Gyudatena gyoo ŋon?” Te Yesu tiranɔɔ nyi, “Mena yaa n yakowɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te Gyudatena saese kegyiise baŋ kɛrɛɛ ɔ nɔɔse mo nombia burum gyakaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Keŋte Pilato bɔɔse e nyi, “Be ta mo nombia kɛŋa bɛɛ gyakaa n dɔɔ na, n ba lese n nɔɔse yee?” ");
INSERT INTO ntr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Botɔɔ te nombia ŋan doo gyoo Pilato nɔɔ, nawolo nyi Yesu te yako daale ya. ");
INSERT INTO ntr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gyudatena nyeekelɛɛwee kedi kamasɛ nɛ, kaboena nyi Pilato waa tina balaŋ baŋ bɔɔ kyam tɔ deni nɛ man dokoloŋ, ŋon balaŋ benaŋ gbagba ne gyae nɛ yela fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mena debaŋ kenaŋ na ba te kyaŋ Barabase tɔ deni. Barabase kei kpuɛ balaŋ baŋ bɔɔ koro seŋ tia gyoo dinaa, te bɔɔ ko balaŋ nɛ man. ");
INSERT INTO ntr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Botɔɔ te balaŋ dikpii keŋ kɔŋa Pilato gyaŋ nyi waa yɛɛ kpene keŋ ɔ ne taŋ yɛɛ debaŋ kamasɛ nɛ fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te Pilato bɔɔse wɔ nyiaa, “Ɛ ne gyae nyi maa lese Gyudatena gyoo ŋon fa ŋon?” ");
INSERT INTO ntr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Keŋ dɔɔ Pilato be bɔɔse mena yɛna nyi, ɔ gyeŋ nyi saese kegyiise baŋ ne kɔla Yesu dɔɔ te ba lese e fa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mɔ Wurubuarɛ saese kegyiise baŋ feefuwɔ do balaŋ dikpii keŋ nyi, baa yako Pilato nyi waa lese Barabase fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Botɔɔ te Pilato bɔɔse wɔ nyi, “Sena te ɛ ne gyae maa yɛɛ walaŋ ŋon ɛ ne baake e nyi Gyudatena gyoo nɛ?” ");
INSERT INTO ntr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Te balaŋ dikpii keŋ fae yeesa nyi, “Yela baa gyɔ e nyeelabia sakaa ɔpaŋdaŋ dɔɔ na waa yeŋ” ");
INSERT INTO ntr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Keŋte Pilato bɔɔse wɔ nyiaa, “Woŋ dukum te ɔ yɛɛwɔ?” Mɔna be gyakaa bo bɛɛ fae yeesa keŋkeŋ nyi, “Gyɔ e nyeelabia sakaa ɔpaŋdaŋ dɔɔ” ");
INSERT INTO ntr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Keŋ Pilato ne gyae mena keŋ be wɔe ke fɛɛ wɔ dɔɔ ɔ lese Barabase fa wɔ, te ɔ yela ɔ yoonɔɔtena tuku Yesu te ɔ moo e fa nyi baa gyu ke gyɔ e nyeelabia sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Keŋte yoonɔɔtena baŋ moo Yesu gyu Pilato dekpaŋalaŋ man botɔɔ keŋ bee di nombia nɛ, te be baake be tebia yoonɔɔtena akaŋ baŋ pou gyaŋee. ");
INSERT INTO ntr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te ba moo kegba yayam do e, te ba moo sɔɔse loo gyooro kotɔtɔɔ wuu e. ");
INSERT INTO ntr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na bee kulu e nyiaa, “Gyudatena gyoo, n nyee dɛɛ wolose” ");
INSERT INTO ntr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Botɔɔ na be gyakaa bɛɛ mo daŋ ŋmeree e ɔ nyeeman, na bɛɛ tɔ nɔɔloŋ woli e na bɛɛ buŋ ɔ nawɔɔtɛɛ kulu e. ");
INSERT INTO ntr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Be ke kulu e taŋ nɛ, ba kpee kegba yayam keŋ te ba moo ŋon gbagba wui keŋ do e. Te ba moo e lee be kaa gyɔ e sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Be ka lee donɔɔ keŋ man bee gyu nɛ, te be gyaŋee na Simɔn ŋon ɔ ba lee Kirene donɔɔ man nɛ na ɔ ne kɔŋ. Simɔn kei bia yɛna Alɛkesanda na Rufuse. Keŋte ba ŋere e nyi waa lɛɛ Yesu ɔpaŋdaŋ keŋ seele. ");
INSERT INTO ntr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Te ba moo Yesu gyu botɔɔ keŋ bɛɛ baake nyi “Golgata” keŋ nawolo nyi “Nyeepookoo” dɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Keŋte ba moo tee keŋ bɛɛ baake nyi mɛɛrɛ nɛ kyakale soloŋ man fa Yesu nyi waa nyɔɔ, mɔna ɔ te nyɔɔ ke ya. ");
INSERT INTO ntr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ba ke gyɔ e sakaa ɔpaŋdaŋ dɔɔ nɛ, te be kpɛlɛɛ ɔ kegbase buŋii te be lɔɔ boe ŋe dɔɔ, na baa naa keŋ walaŋ kamasɛ waa nyiŋ. ");
INSERT INTO ntr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gyae ke yɛɛ ŋgba nebo weese debaŋ atoorote man nɛ, te be gyɔɔ Yesu sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Keŋte be ŋmarase dukum keŋ be kpa ɔ be yɛɛ nɛ mataa ɔ nyee gbɛɛ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Botɔɔ te be gyɔɔ ŋmɛɛlatena bala baale mɔ sakaa ɔpaŋdaase dɔɔ kpu na Yesu. Ŋolo sakaa ɔ dunoluŋ dɔɔ, te ŋolo mɔ sakaa ɔ demena dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kei yela Wurubuarɛ nombia aŋmaraseŋ see ŋan kɔŋawɔ mena. Nombia ŋenaŋ yɛna nyi, “Be ta mo e kpu na nombiakumɛɛyɛɛra.” ");
INSERT INTO ntr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na balaŋ baŋ bɛɛ lam botɔɔ nɛ, na tee e na bee kpiisi ba nyeeya yako nyiaa, “Nyaŋ ŋon n kpa n ke tekerii Wurubuarɛ ɔsom deni dinaa keŋ na n ka mo weeya atooro maa ke nɛ, ");
INSERT INTO ntr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","lɛɛ n wose na n ke tisi lee ɔpaŋdaŋ keŋ dɔɔ na dɛɛ kɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mena mɔ te Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ mɔ kulu e. Te be yako dɔŋa nyiaa, “Ɔ ne tale lɛɛ baale nyee, mɔna ɔ be tale lɛɛ ŋon gbagba nyee ya.” ");
INSERT INTO ntr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nyi akpaa ŋon yɛna nyeedoŋ Gbeŋgyoo na Iseraetena gyoo ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ, kenaŋ na waa lɛɛ ɔ wose lee ɔpaŋdaŋ keŋ dɔɔ na dɛɛ naa na dɛɛ lɛɛ e di. Te balaŋ bala baŋ bɔɔ gyɔ wɔ sakaa ɔpaŋdaase dɔɔ kpu na e nɛ mɔ tee e mena. ");
INSERT INTO ntr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Weese ka seŋ dɛɛ nɛ, ditiŋtɛɛ kaa lɛɛ tɛɛle keŋ dɔɔ pou kelii ɔ ke gɛɛse. ");
INSERT INTO ntr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te weese ke gɛɛse kenaŋ nɛ Yesu fae yeesa keŋkeŋ nyiaa, “Eli, Eli, lama sabatani?” Keŋ nawolo nyi, “Me Wurubuarɛ, Me Wurubuarɛ, weera te n lese n sia yela maŋ?” ");
INSERT INTO ntr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Balaŋ baŋ ba seŋɛɛ botɔɔ ke nyii mena nɛ be yakowɔ nyiaa, “Ɛ nyii, ɔ ne baake Elaegya.” ");
INSERT INTO ntr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Debokenaŋ man te be man ŋolo yeuwɔ ka mo kolo ŋgba kokyaa keŋ gyae ke tale lɛɛ loŋ nɛ do soloŋ denyaŋesa daale man, te ɔ moo ke tooso na daŋ te ɔ gyinaa ke adido fa Yesu nyi waa nyɔɔ. Keŋte ɔ yakowɔ nyiaa, “Ɛ seŋ dɛɛ kɛɛ nyi Elaegya waa kɔŋ kaa lese e lee ɔpaŋdaŋ keŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Botɔɔ te Yesu besewɔ fae yeesa keŋkeŋ, te ɔ kara weesi. ");
INSERT INTO ntr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kekɔŋ mena nɛ, kanyaŋ keŋ bɔɔ mo kpase Wurubuarɛ ɔsom deni dinaa keŋ man nɛ bɛɛsewɔ kyɛɛkyɛɛ ala lee adido kaa lii ka mokɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yoonɔɔtena kegyia ŋon ɔ seŋɛɛ botɔɔ kena Yesu ke fae yeesa kara weesi nɛ, ɔ yakowɔ nyiaa, “Balee kei yɛna Wurubuarɛ bu ŋon ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na ala baale seŋɛɛ lemlem bɛɛ kɛɛ. Ala benaŋ man baale yɛna Mɛɛre ŋon ɔ ba lee Magedala nɛ, na Gyemisi kemaasa na Gyose be naa Mɛɛre na Salome. ");
INSERT INTO ntr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ala kɛwɔ silana Yesu kɛɛ ɔ dɔɔ debaŋ keŋ ɔ kya Galelia nɛ. Na ala burum baŋ bɔɔ sila e kɔŋ Gyerusalɛm donɔɔ man nɛ mɔ seŋɛɛ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na wee kenaŋ yɛɛ wee keŋ Gyudatena na mo desina ba wose fa ba kefɛɛfowee keŋ kedi. Ke lii balinɔɔ nɛ, ");
INSERT INTO ntr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","balee ŋon bɛɛ baake e nyi Gyosɛfo ŋon ɔ ba lee Arimatia donɔɔ man nɛ gyɔɔ ɔ konɔɔ gyu Pilato gyaŋ ka sola e nyi waa mo Yesu woo ŋon fa e ɔ kaa wuu. Gyosɛfo kei yɛɛ donɔɔ kegyia ŋolo e, te ŋon mɔ ne gyeki Wurubuarɛ gyoori keŋ. ");
INSERT INTO ntr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ke nyii nyi Yesu ta yem nɛ, yɛɛ e gyakoloŋ. Mena dɔɔ ɔ baake ɔ yoonɔɔtena kegyia ŋon bɔɔse e nyiaa, “Yesu ŋon wulaa yeŋawɔ?” ");
INSERT INTO ntr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ɔ ke nyii lee yoonɔɔtena kegyia ŋon nɔɔman nyi ke yɛɛ ampaŋ nɛ, ɔ faa Gyosɛfo ŋon gbɛɛ nyi waa gyu ka mo woo ŋon. ");
INSERT INTO ntr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mena dɔɔ Gyosɛfo gyuuwɔ ke lɛɛ akaralɛɛ te ɔ lese woo ŋon lee ɔpaŋdaŋ keŋ dɔɔ te ɔ moo akaralɛɛ keŋ milii e. Keŋte ɔ moo e ke wuu yebɔɔ keŋ bɔɔ kare boe daale man nɛ man. Te ɔ biliŋi boe dinaa daale tɔ yebɔɔ keŋ nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Mɛɛre ŋon ɔ ba lee Magedala nɛ, na Gyose ɔ naa Mɛɛre seŋɛɛ botɔɔ. Mena dɔɔ be naa botɔɔ keŋ bɔɔ wuu e nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gyudatena kefɛɛfowee keŋ ke taŋ nɛ, Mɛɛre ŋon ɔ ba lee Magedala na Gyemisi ɔ naa Mɛɛre na Salome, lɛɛ abɔɔ ofoŋ nyiŋan be kaa buraa Yesu woo ŋon. ");
INSERT INTO ntr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kosida nebo nebo weese ke bɛɛ nɛ, ala baŋ korowɔ bee gyu yebɔɔ keŋ tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Be kee gyu na bɛɛ bɔɔse dɔŋa nyiaa, “Amɔte ne gyae la waa biliŋi boe keŋ lee yebɔɔ keŋ nɔɔman fa daa?” ");
INSERT INTO ntr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mɔ be ke gyina be sia kɛɛ na, be naawɔ nyi be te biliŋi boe dinaa dinaa keŋ lee yebɔɔ keŋ nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Be ka mo baa gyoo yebɔɔ keŋ man nɛ, te be naa tobaale ŋolo na ɔ doona kegba wolom wurikyim na ɔ baŋɛɛ dunoluŋ dɔɔ te be ŋeŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Botɔɔ te ɔ yako ala baŋ nyiaa, “Ɛ na ŋeŋii ya. Ma gyeŋ nyi Yesu ŋon ɔ ba lee Nasarɛte, ŋon bɔɔ gyɔ e sakaa ɔpaŋdaŋ dɔɔ nɛ yaa ɛ ne kɛo. Ɔ te fom. Ɔ be kyaa kɛbo ya. Ɛ kɛɛ botɔɔ keŋ ɔ be doo nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mena dɔɔ ɛ gyu ke yako ɔ kaseela baŋ na Pita nyiaa, ‘Ɔ te kyaŋ ŋon gbɛɛ ɔ ne gyu Galelia donɔɔ man. Botɔɔ te ɛ kena e ŋgba mena keŋ ɔ be yako ŋon nɛ.’ ” ");
INSERT INTO ntr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Keŋte ala baŋ leewɔ yebɔɔ keŋ man bileŋ, nawolo nyi gyakoloŋ ta gyoo wɔ te ba wose mɔ ta yeŋ wɔ. Te ba te yako ŋolo mɔ kolo ya, nawolo nyi bee yee. ");
INSERT INTO ntr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu kefoŋ lee yeŋ man Kosida nebo nebo fuu keŋ nɛ, ɔ taŋgbɛɛwɔ lese ɔ wose wola Mɛɛre ŋon ɔ ba lee Magedala nɛ. Mɛɛre kei te Yesu gegi feliŋkumɛɛ nyetooro lee ɔ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mena dɔɔ ŋon mɔ gyuuwɔ ke yako balaŋ baŋ be silana Yesu nɛ. Ɔ ke gyu na be kyaa bee wii na bee di walaŋsa. ");
INSERT INTO ntr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Keŋ na be ke nyii nyi Yesu te fom te Mɛɛre naa e koraŋ nɛ, ba te lɛɛ di ya. ");
INSERT INTO ntr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kenaŋ wɔle nɛ, Yesu lese ɔ wose dinɔɔ wɔle daale man wola ɔ kaseela bala baale debaŋ keŋ bee gyu donɔɔ daale man nɛ. ");
INSERT INTO ntr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Keŋte baŋ mɔ besewɔ kɔŋ kaa yako be tebia akaŋ baŋ. Mɔ baŋ mɔ te lɛɛ wɔ di ya. ");
INSERT INTO ntr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kɛŋa pou wɔle nɛ, ɔ kaseela kufu daale baŋ yilaawɔ bee dii te Yesu besewɔ kaa lese ɔ wose wola wɔ. Keŋte ɔ gyeŋa baŋ do wɔ lee mena keŋ balaŋ be kɔŋ kaa yako wɔ nyi ɔ te fom, te ba lɛɛ wɔ di ya nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ gyu tɛɛle kei pou dɔɔ na ɛ kaa kolosi Wurubuarɛ nombia ŋan fa balaŋ pou. ");
INSERT INTO ntr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Walaŋ kamasɛ ŋon ɔ lɛɛ nombia ŋan di te be sɔ e Wurubuarɛ loŋ na, waa nyiŋ nyeedoŋ. Mɔ walaŋ kamasɛ ŋon ɔ te lɛɛ nombia ŋan di ya nɛ, Wurubuarɛ waa bu e fɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Balaŋ baŋ baa lɛɛ maŋ di nɛ, baa yɛɛ gyakoloŋ nombia kɛŋa. Baa gberaa feliŋkumɛɛ lee balaŋ man lee ma yele man, na baa kolosi deise wɔlɛɛ kpookpoo ŋan bɔɔ gyeŋ ya. ");
INSERT INTO ntr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nyi akpaa be gate doma na be nyiŋmaase yaa be nyɔɔ teekum daale koraŋ na, be gyae ke yɛɛ wɔ kolo ya. Baa mo be nyiŋmaase gyakaa kaweesetena dɔɔ, na ba wose ke yɛɛ wɔ doŋ.” ");
INSERT INTO ntr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","De Gbeŋgyoo Yesu kekolosi fa wɔ taŋ nɛ, Wurubuarɛ moo e gyu adido te ɔ ke kyaawɔ Wurubuarɛ dunoluŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesu kaseela baŋ ka lee botɔɔ nɛ, be gyuuwɔ tɛɛle kei pou dɔɔ kekolosi Wurubuarɛ nombia ŋan. Te de Gbeŋgyoo seŋawɔ be wɔle te be yɛɛ gyakoloŋ nombia, na kawola nyi Wurubuarɛ nombia ŋan yɛɛ ampaŋ.");
INSERT INTO ntr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kegyia kpaakpaa Teyofilose, balaŋ burum te yɛɛ kakyeŋ ŋmarase nombia ŋan be kɔŋ de gyaŋ kɛbo lee Yesu Kristo wose man nɛ see. ");
INSERT INTO ntr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nombia ŋan bɔɔ ŋmarase nɛ, mena nombia ŋenaŋ ke te baŋ bɔɔ mo be sia naa ŋa leenaŋ kewalaŋ, te bɔɔ kolosi de Gbeŋgyoo Yesu Kristo wose man nombia fa daa nɛ yakowɔ. ");
INSERT INTO ntr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kegyia Teyofilose, lee mena dɔɔ maŋ gbagba gyoo nombia kɛŋa man nideli leenaŋ ŋa kewalaŋ keŋ na, me naawɔ nyi kaboena nyi maa tɔlɛɛ ŋa kekɔŋ bii dokoloŋ dokoloŋ fa neŋ, ");
INSERT INTO ntr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","na n ke nyiŋ gyeŋ nyi nombia ŋan pou bɔɔ wola neŋ nɛ yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Debaŋ keŋ gyoo Herode ne di gyoori Gyudia tɛɛle man nɛ, na Wurubuarɛ sae ŋolo kyaa keŋ bɛɛ baake e nyi Sakaria. Na ɔ kpuɛ Abigya saere dikpii man, te ɔ wɛɛle Elisabɛte mɔ lee Wurubuarɛ sae Aarɔn duuluŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaria na ɔ wɛɛle gbɛɛneŋ tenɛɛ Wurubuarɛ siaman. Te bee di de Gbeŋgyoo Wurubuarɛ mmaraase na ɔ nombia ŋan pou dɔɔ nideli keŋ ba wose man be dana nombiikum daale ya. ");
INSERT INTO ntr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mɔna bɔɔ taŋ bu ya nawolo nyi Elisabɛte yɛɛ ɔlamanbo e, te ŋon na ɔ baale Sakaria mɔ pou te ŋmɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wee daale nɛ, kaa liiwɔ Sakaria saese dikpii keŋ dɔɔ nyi baa gyu Wurubuarɛ ɔsom deni dinaa keŋ man ke fa Wurubuarɛ kedi. ");
INSERT INTO ntr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Be lɔɔ boe ŋgba mena keŋ ba amanberɛ na wolo nɛ, te yalawɔ Sakaria dɔɔ nyi waa gyu Wurubuarɛ ɔsom deni dinaa keŋ man ɔ kaa too oliifi. ");
INSERT INTO ntr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Debaŋ keŋ ɔ ba gyoo Wurubuarɛ ɔsom deni dinaa keŋ man ɔ kaa too oliifi nɛ, na balaŋ dikpii keŋ pou kyaa debɔɔ man bɛɛ fane. ");
INSERT INTO ntr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakaria kɛɛ too oliifi keŋ nɛ, botɔɔ te Wurubuarɛ kpilale kɔŋawɔ ɔ gyaŋ kaa seŋ kedeesa boe keŋ ɔ na too oliifi ke dɔɔ nɛ dunoluŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria kena e nɛ, ɔ wɔe lɔɔ e te gyakoloŋ gyoo e. ");
INSERT INTO ntr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Keŋte Wurubuarɛ kpilale ŋon yako e nyiaa, “Sakaria na yee ya, Wurubuarɛ te nyii n kefane mena dɔɔ n wɛɛle Elisabɛte waa lola bu baale fa neŋ, na n ka do e yele nyi Gyɔn. ");
INSERT INTO ntr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ba lola bu ŋon na, gyae ke yɛɛ neŋ gyoŋ nideli te balaŋ burum mɔ sia gyae ka gye ɔ dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","nawolo nyi bu ŋon waa yɛɛ walaŋ dinaa Wurubuarɛ siaman, mena dɔɔ ɔ na mo soloŋ na soloŋ daa ɔ nɔɔ ya. Wurubuarɛ waa mo ɔ feliŋ do ɔ man leenaŋ ɔ naa tɔɔman pɛna baa lola e. ");
INSERT INTO ntr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te waa kyɛɛkee Iseraetena balaŋ burum agyueŋ kɔŋ be Gbeŋgyoo Wurubuarɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wurubuarɛ waa mo ɔ feliŋ do ɔ man, na waa fa e doŋ ŋgba mena keŋ ɔ be fa ɔ dekpeŋkpeŋgyɔɔre Elia nɛ. Waa ta de Gbeŋgyoo ŋon siaman na waa desina kyaɔ na be bia nsana, te balaŋ baŋ bɔɔ ne bu Wurubuarɛ ya nɛ, waa besena wɔ kɔŋ gbɛɛ kpaakpaate keŋ dɔɔ na waa desina de Gbeŋgyoo balaŋ see e.” ");
INSERT INTO ntr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Botɔɔ te Sakaria bɔɔse Wurubuarɛ kpilale ŋon nyiaa, “Sena te maa yɛɛ na maa naa nyi nombia kɛŋa yɛɛ ampaŋ? Nawolo nyi daa na me wɛɛle pou te ŋmɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Keŋte Wurubuarɛ kpilale ŋon tiranɔɔ fa e nyiaa, “Maŋ yɛna Gaberɛle, Wurubuarɛ kpilale ŋon ma seŋɛɛ ɔ siaman debaŋ kamasɛ. Ŋon kpila na maŋ nyi me kaa yako neŋ mena nombia kpaakpaa kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nombia ŋan mɔɔ yako neŋ nɛ, gyae kekɔŋ ŋgba mena keŋ mɔɔ yako see nɛ. Mɔna keŋ n te lɛɛ me nombia kɛŋa di ya dɔɔ nɛ, n be gyae n ke tale kolosi ya kaboena nombia ŋan mɛɛ yako neŋ nɛ kekɔŋ ampaŋ debaŋ keŋ mɔɔ see neŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Debaŋ kenaŋ pou man na, balaŋ baŋ kyaa debɔɔ man bɛɛ daa Sakaria, na bɛɛ gyueŋ kpene keŋ dɔɔ ɔ be dɔɔ Wurubuarɛ ɔsom deni dinaa keŋ man mena. ");
INSERT INTO ntr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Debaŋ keŋ ɔ ba lee kɔŋ balaŋ baŋ gyaŋ nɛ, ɔ te tale kolosi na wɔ ya, mena dɔɔ ba gyeŋawɔ nyi ɔ te naa kalesewola daale Wurubuarɛ ɔsom deni dinaa keŋ man. Ɔ nyiŋmaase te ɔ moowɔ kolosi na wɔ, nawolo nyi ɔ ta bese omumuu. ");
INSERT INTO ntr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Debaŋ keŋ ɔ be yɛɛ ɔ saere tom keŋ taŋ nɛ, te ɔ besewɔ gyu ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nombia kɛŋa kekɔŋ wɔle nɛ, te kyare ya te ɔ wɛɛle Elisabɛte kyaŋa fulu, te ɔ weese ɔ wose gyaalaŋna banoŋ keŋ ɔ bɛɛ lee debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Keŋte ɔ yakowɔ nyiaa, “De Gbeŋgyoo Wurubuarɛ te wii me waraŋase ŋgba ɔ ba lese desɛŋ dinaa kei lee me dɔɔ balaŋ siaman nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabɛte fulu keŋ ke di gyaalaŋna looro nɛ, Wurubuarɛ kpila ɔ kpilale Gaberɛle gyu Nasarɛte keŋ kyaa Galelia tɛɛle dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ɔ kpila e gyu alebu ŋolo ŋon ɔ te doo ta na baale ya nɛ gyaŋ. Ɔ yele yɛna Mɛɛre. Mɛɛre kei na Gyosɛfo ŋon ɔ ba lee gyoo Defidi duuluŋ man nɛ bake la see nyi baa yala dɔŋa nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Keŋte Wurubuarɛ kpilale ŋon gyuuwɔ ke yako e nyiaa, “Mɛɛre nyaŋ na nyeebam, nawolo nyi Wurubuarɛ kpuɛ na neŋ, te ɔ nyiŋmaa gyakaa n dɔɔ nideli.” ");
INSERT INTO ntr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɛɛre kenyii nɔɔwoya kɛŋa nɛ, ɔ wose gbirisi e nawolo nyi ɔ te nyii nombia ŋan man nideli ya. ");
INSERT INTO ntr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Keŋte Wurubuarɛ kpilale ŋon yako e nyiaa, “Mɛɛre na yee ya, Wurubuarɛ ta mo ɔ bɛrɛɛ boele neŋ. ");
INSERT INTO ntr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nyaŋ ke kyaŋ fulu na n ka lola bu baale na n ka do e yele nyi Yesu. ");
INSERT INTO ntr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Waa yɛɛ walaŋ dinaa Wurubuarɛ siaman, na baa baake e nyi Wurubuarɛ Kpatakpere ŋon bu. De Gbeŋgyoo Wurubuarɛ waa yela waa di gyoori ŋgba ɔ naana Defidi nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Waa di gyoori Gyekɔpo duuluŋ man balaŋ dɔɔ kekpaakekpaa, te ɔ gyoori kenaŋ betaŋ ɔto ya.” ");
INSERT INTO ntr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Botɔɔ te Mɛɛre bɔɔse Wurubuarɛ kpilale ŋon nyiaa, “Sena te nombia kɛŋa gyae ke tale kɔŋ mena, debaŋ keŋ mɔɔ gyeŋ baale na baale ya?” ");
INSERT INTO ntr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Keŋte Wurubuarɛ kpilale ŋon tiranɔɔ fa e nyiaa, “Wurubuarɛ feliŋ ŋon gyae kekɔŋ kaa gyoo n man, na Wurubuarɛ Kpatakpere ŋon ka mo ɔ doŋ keŋ do n man na n ke kyaŋ fulu. Mena dɔɔ bu ŋon nyaŋ ka lola nɛ, waa yɛɛ bu ŋon ayimɛɛ be doo ɔ man ya, te baa baake e nyi Wurubuarɛ bu. ");
INSERT INTO ntr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kɛɛ! N loŋto Elisabɛte ŋon be kpa ɔ yɛɛ ɔlamanbo e te ɔ be ŋmɛɛ koraŋ mɔ nɛ, te kyaŋ fulu gyaalaŋna looro yaa. ");
INSERT INTO ntr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nawolo nyi kpene kamasɛ be kyaa keŋ nyi Wurubuarɛ be gyae waa tale yɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Keŋte Mɛɛre yakowɔ nyiaa, “Ma nyee tesɛɛ bo na Wurubuarɛ. Ŋan pou n be yako maŋ nɛ dɛɛkɔŋ mena.” Keŋte Wurubuarɛ kpilale ŋon laŋawɔ yela e. ");
INSERT INTO ntr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Weeya akalansɛɛ ŋaale wɔle nɛ, Mɛɛre desina ɔ wose te ɔ gyuu Sakaria na ɔ wɛɛle Elisabɛte gyaŋ Gyudia tɛɛle man. Na donɔɔ keŋ man be kyaa nɛ, gyakae bulase dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ɔ ka gyoo donɔɔ keŋ man nɛ, ɔ gyuuwɔ Sakaria dɛɛ te ɔ doo Elisabɛte nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Debaŋ keŋ Elisabɛte be nyii Mɛɛre nɔɔ kado keŋ nɛ, ɔ bu ŋon wosi ɔ wose ɔ tɔɔman, te Wurubuarɛ feliŋ ŋon kaa gyoowɔ Elisabɛte man nideli. ");
INSERT INTO ntr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Keŋte Elisabɛte nyaŋeewɔ fae yeesa nyiaa, “Nyaŋ yɛna alo ŋon Wurubuarɛ ba mo ɔ nyiŋmaa gyakaa n dɔɔ nideli ala pou man, te ɔ ta mo ɔ nyiŋmaa gyakaa n bu ŋon nyaŋ ka lola nɛ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Woŋ nombia dinaana yaa Wurubuarɛ yɛɛwɔ fa maŋ nɛ, nyi me Gbeŋgyoo ɔ naa waa kɔŋ kaa do maŋ nɔɔ? ");
INSERT INTO ntr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nawolo nyi me ka betaa nyii n nɔɔ kado pɛ, te me bu ŋon ɔ doo me tɔɔman nɛ nyaŋeewɔ wosi ɔ wose. ");
INSERT INTO ntr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wurubuarɛ te hiraa neŋ, ŋgba n be lɛɛdi nyi de Gbeŋgyoo nombia ŋan ɔ be yako nɛ, gyae kekɔŋ mena fa neŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Keŋte Mɛɛre yakowɔ nyiaa, “Mɛɛ lese de Gbeŋgyoo yele lee me konɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wurubuarɛ yɛna ma nyeelɛɛre, mena dɔɔ te mɛɛ nyaŋee, ");
INSERT INTO ntr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","nawolo nyi ɔ te tɔɔse maŋ wa alebu kei dinɔɔ, ŋon nafɔ bɔɔ ne kala maŋ do balaŋ man ya nɛ. Lee nɛnɛɛ ne gyuu nɛ, walaŋ kamasɛ waa baake maŋ nyi, alo ŋon Wurubuarɛ be hiraa e. ");
INSERT INTO ntr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nawolo nyi Wurubuarɛ Kpatakpere ŋon te yɛɛ nombia dinaana fa maŋ. Ɔ yɛɛ Wurubuarɛ ŋon ayimɛɛ be doo ɔ man ya. ");
INSERT INTO ntr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Deniwalaŋ duuluŋ kamasɛ man nɛ, ɔ ne wii baŋ pou bee yee e nɛ waraŋase. ");
INSERT INTO ntr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɔ ta mo ɔ doŋ yɛɛ gyakoloŋ nombia, te ɔ yaasee balaŋ baŋ bee gyina ba wose nɛ na be nombia ŋan pou bɛɛ gyueŋ ba nyeeya man nɛ lee ɔ siaman. ");
INSERT INTO ntr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɔ te yɔkɔse gyooneŋ dinaana tɛɛle man, te ɔ gyinaa balaŋ baŋ bɛɛ yɔkɔse ba wose nɛ adido. ");
INSERT INTO ntr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɔ te yeli baŋ tanam na ko wɔ nɛ te nyiŋ abɔɔ kpaakpaa, te ɔ yela baŋ be dana kɔba nɛ laŋawɔ nyiŋmaase kufu nawɔɔ kufu. ");
INSERT INTO ntr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɔ te di ntam keŋ ɔ be kaŋ fa de naanaɔ nɛ dɔɔ, te ɔ kɔŋawɔ kaa kyɔ ɔ tewulɛɛ Iseraetena, ");
INSERT INTO ntr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ŋgba mena keŋ ɔ be yako see nyi, waa wii Aberaham na ɔ duuluŋ man balaŋ pou waraŋase kekpaakekpaa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɛɛre kyaawɔ Elisabɛte gyaŋ ŋgba gyaalaŋna batooro nɛ, te ɔ besewɔ gyu ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Debaŋ keŋ Elisabɛte kalola be lii nɛ, ɔ lola bu baale. ");
INSERT INTO ntr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Balaŋ baŋ be kyaa benaa na e, na ɔ loŋtona nyii mena keŋ de Gbeŋgyoo be wii ɔ waraŋase nideli nɛ, be popou nyaŋeewɔ kpu na e. ");
INSERT INTO ntr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bu ŋon kedi weeya gyanaara nɛ, be kɔŋawɔ be kaa kara ɔ baala wose na baa mo ɔ kya Sakaria yele do e, ");
INSERT INTO ntr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","mɔna ɔ naa bɛɛwɔ te ɔ kpa “Baa baake e nyi Gyɔn.” ");
INSERT INTO ntr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Keŋte balaŋ baŋ yako e nyiaa, “Yele kei te yɛɛ n dekpaŋalaŋ man yele ya.” ");
INSERT INTO ntr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Botɔɔ te ba moo be nyiŋmaase kolosi na ɔ kya bɔɔse e yele keŋ ɔ ne gyae nyi baa mo do ɔ bu ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Keŋte Sakaria yako wɔ nyiaa baa fa e kolo waa ŋmarase ke dɔɔ, te ɔ ŋmarasewɔ nyi, “Ɔ yele yɛna Gyɔn.” Nombii kei yɛɛ be popou gyakoloŋ. ");
INSERT INTO ntr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Debokenaŋ man te Sakaria nɔɔ gyuusuwɔ te ɔ fiasɛɛ kolosi lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Keŋte gyakoloŋ gyoo be tebia baŋ pou, te nombia ŋenaŋ yaaseewɔ gyu Gyudia tɛɛle man donɔɔse ŋan ŋe kyaa bulase dɔɔ nɛ pou man. ");
INSERT INTO ntr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Walaŋ kamasɛ ŋon ɔ be nyii nombii kei nɛ bɔɔse ɔ wose nyiaa, “Walaŋ woŋti dinɔɔ yaa bu kei waa kaa yɛɛ baa?” Nawolo nyi be naawɔ nyi, de Gbeŋgyoo Wurubuarɛ nyiŋmaa gyakaa ɔ dɔɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wurubuarɛ moo ɔ feliŋ ŋon do Gyɔn ɔ kya Sakaria man, te ɔ kolosi Wurubuarɛ nombia see nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“De Gbeŋgyoo Wurubuarɛ, dɛɛ lese n yele nawolo nyi n te kɔŋ kaa lɛɛ n balaŋ Iseraetena nyee. ");
INSERT INTO ntr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","N te fa daa nyeelɛɛre dinaa ŋolo, ŋon ɔ ba lee n tobaale Defidi duuluŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ŋgba mena keŋ n be tɛɛ nya akpeŋkpeŋgyɔɔra baŋ ayimɛɛ be doo be man ya nɛ dɔɔ kolosi see nɛ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","waa lɛɛ daa lee de kɔlala, na baŋ bɔɔ ne naa de sia laŋ ya nɛ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","N yakowɔ nyi nyaŋ ke wii de naanaɔ waraŋase, na n ke tɔɔse nɔɔkebakesee keŋ ɛmɛɛ na wɔ be bake see nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","N kaŋa ntam fa de naana Aberaham, te ɛmɛɛ na e bakewɔ see nyi, ");
INSERT INTO ntr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","n ka lese daa lee de kɔlala nyiŋmaase man, na ke yela dɛɛ tale gyɔ de konɔɔ som neŋ keŋ dɔɔ yee gyakoloŋ ya, ");
INSERT INTO ntr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na dɛɛ yɛɛ balaŋ baŋ be gbɛɛneŋ tenɛɛ n siaman, na baŋ ba wose betaŋ ayimɛɛ ya kelii debaŋ keŋ dɛɛ yeŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakaria ke yako kɛŋa pou taŋ nɛ te ɔ kolosiwɔ fa bu ŋon nyiaa, nɛnɛɛ nyaŋ me bu Gyɔn, baa baake neŋ nyi Wurubuarɛ Kpatakpere ŋon dekpeŋkpeŋgyɔɔre, nawolo nyi nyaŋ keta de Gbeŋgyoo ŋon siaman na n ke desina ɔ gbɛɛneŋ fa e. ");
INSERT INTO ntr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na n ke yela ɔ balaŋ ka gyeŋ nyi ba sola Wurubuarɛ te ɔ mo be nombiakumɛɛ kyɛɛ wɔ na, baa nyiŋ nyeekelɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nawolo nyi Wurubuarɛ yɛɛ waraŋasete e, te ɔ te kpila nyeelɛɛre ŋon nyi waa kɔŋ kaa lɛɛ da nyee. Ɔ kekɔŋ gyae ke yɛɛ ŋgba keŋmaŋee nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","keŋmaŋee kei gyae ka lee adido kɔŋ baŋ pou be kyaa ditiŋtɛɛ man na yeŋ gbɛɛneŋ man nɛ dɔɔ, na kawola daa gbɛɛ kpaakpaa keŋ dɛɛ ta wosefɛɛreŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Keŋte bu ŋon beewɔ te de Gbeŋgyoo Wurubuarɛ moo ɔ feliŋ ŋon do ɔ man te ɔ nyiŋa doŋ. Ɔ kyaawɔ depampaa dinaa man kaboena wee keŋ ɔ ba lese ɔ wose debɔɔ wola Iseraetena nɛ liiwɔ. ");
INSERT INTO ntr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Debaŋ kenaŋ man te Roman gyoo dinaa ŋon bɛɛ baake e Agustuse nɛ, faa mmaraa nyi baa kala balaŋ baŋ pou be kyaa ɔ tɛɛle man nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kei yɛna balaŋ kekala gyaŋgbate, debaŋ keŋ Kireniuse kyaa Romantena gyoo dinaa nawɔɔ man Siria tɛɛle man nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lee mmaraa keŋ gyoo ŋon be faa dɔɔ, walaŋ kamasɛ gyuu ɔ dɛɛ ɔ kaa ŋmarase ɔ yele. ");
INSERT INTO ntr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Keŋte Gyosɛfo mɔ lee Nasarɛte keŋ kyaa Galelia tɛɛle man nɛ, gyu Bɛtelɛhɛm keŋ ke kyaa Gyudia tɛɛle man nɛ. Bɛtelɛhɛm donɔɔ kei man te ba lola gyoo Defidi. Gyosɛfo gyuu botɔɔ nawolo nyi ɔ lee gyoo Defidi duuluŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ŋon na Mɛɛre ŋon, ŋon na e be yako see nyi baa yala dɔŋa nɛ, gyuu la be kaa ŋmarase ba yela. Debaŋ kenaŋ man na Mɛɛre dana fulu. ");
INSERT INTO ntr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ba kekyaa Bɛtelɛhɛm botɔɔ nɛ te kadoŋee kyaŋa Mɛɛre. ");
INSERT INTO ntr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Keŋ be te nyiŋ deni ŋɔɔla dasoe keŋ man ya dɔɔ, be gyue ka gyoo wonembia dedoi man. Botɔɔ te ɔ lola ɔ bu baale gyaŋgbate te ɔ mo kakyeŋgbelaase milii e mo e doosi adakaa keŋ wonembia ne dii ke man nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Debaŋ kenaŋ man na, namensekɛɛlera baale kyaa ŋale man benaa na botɔɔ yenaŋ bee gyee be namense nelim kenaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Botɔɔ te de Gbeŋgyoo Wurubuarɛ kpilale ŋolo kaa bɛɛwɔ lee be dɔɔ te de Gbeŋgyoo Wurubuarɛ gyoorobiiri keŋ ŋalakeewɔ kilisi wɔ, keŋte gyakoloŋ gyoo wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Keŋte Wurubuarɛ kpilale ŋon yako wɔ nyiaa, “Ɛ naa yee ya! Ɛ kɛɛ! Me ta mo nombia kpaakpaa ŋaale mɛɛ kɔna ŋon. Nombia kɛŋa gyae ke yɛɛ balaŋ pou gyoŋ. ");
INSERT INTO ntr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nawolo nyi gyɛŋ wee kei nɛ, be ta lola ɛ nyeelɛɛre fa ŋon gyoo Defidi donɔɔ Bɛtelɛhɛm man. Ŋon yɛna de Gbeŋgyoo Kristo, (walaŋ ŋon Wurubuarɛ be yako see nyi waa kaa lɛɛ ɔ balaŋ nyee nɛ). ");
INSERT INTO ntr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kpene keŋ gyae kawola nyi nombia ŋan mɛɛ yako nɛ yɛɛ ampaŋ yɛna nyi, ɛ kena kyokyoo ŋon doo adakaa keŋ wonembia ne dii ke man nɛ man, na be ta mo kakyeŋgbelaase milii e.” ");
INSERT INTO ntr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Debokenaŋ man te Wurubuarɛ kpilala burum baale kɔŋawɔ kaa kpu na kpilale gyaŋgbate ŋon, te be kpee nɔɔneŋ lese Wurubuarɛ yele nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wurubuarɛ ŋon n kyaa adido, n gyoorobiiri kaboena neŋ. N wosefɛɛreŋ dɛɛkɔŋ balaŋ baŋ bɛɛ gyoo n sia tɛɛle kei dɔɔ nɛ man.” ");
INSERT INTO ntr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wurubuarɛ kpilala baŋ ka bese lee be gyaŋ gyu adido nɛ, namensekɛɛlera baŋ yako dɔŋa nyiaa, “Ɛ fa dee gyu Bɛtelɛhɛm, na de kaa kɛɛ kpene keŋ be kɔŋ te de Gbeŋgyoo Wurubuarɛ ba lese wola daa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mena dɔɔ be yɛɛwɔ bileŋ te be gyuuwɔ te ba ke naa Mɛɛre na Gyosɛfo na kyokyoo ŋon, na ɔ doo adakaa keŋ wonembia ne dii ke man nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Namensekɛɛlera baŋ kena kyokyoo ŋon nɛ, be yako wɔ mena keŋ Wurubuarɛ kpilale ŋon be kolosi kyokyoo ŋon wose man nombia fa wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nombia ŋan namensekɛɛlera baŋ be yako nɛ, yela balaŋ baŋ pou bɔɔ nyii ŋa nɛ wose gbirisi wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mɔna Mɛɛre kyaŋa nombia kɛŋa pou do ɔ konɔɔ man, na ɔ na gyueŋ ŋe man nideli. ");
INSERT INTO ntr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Namensekɛɛlera baŋ besewɔ laŋ, na bee kpee nɔɔneŋ lese Wurubuarɛ yele lee ŋan pou bɔɔ nyii te bɔɔ naa nɛ dɔɔ, nawolo nyi nombia ŋan pou bɔɔ nyii te bɔɔ naa nɛ, kyaawɔ na ŋan Wurubuarɛ kpilale ŋon be yako wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Weeya gyanaarate keŋ kelii nyi baa kara bu ŋon baala wose nɛ, ba doo e yele nyi Yesu. Mena yele kei te Wurubuarɛ kpilale ŋon yakowɔ nyi baa baake e pɛte Mɛɛre kyaŋa ɔ fulu. ");
INSERT INTO ntr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Debaŋ keŋ ba ayimɛɛ kegberaa weeya ŋan be gyaŋee ŋgba mena keŋ Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see nawolo nɛ, Gyosɛfo na Mɛɛre moo Yesu gyu Gyerusalɛm donɔɔ man be kaa do de Gbeŋgyoo Wurubuarɛ nyiŋmaa man, ");
INSERT INTO ntr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","nawolo nyi de Gbeŋgyoo Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see nɛ ne yako nyiaa, “Bu baale kamasɛ ŋon ɔ naa waa taŋgbɛɛ lola na, baa mo e ka do de Gbeŋgyoo Wurubuarɛ nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Keŋte Gyosɛfo na Mɛɛre gyuuwɔ ke deesi fa Wurubuarɛ ŋgba mena keŋ Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see ne yako nɛ nyiaa, “Baa mo donɔɔ man yaa ŋale man awuluŋna bala deesi nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Debaŋ kenaŋ na balee ŋolo kyaa Gyerusalɛm donɔɔ man keŋ ɔ yele yɛna Simeɔn. Ɔ yɛɛ walaŋ ŋon ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman te ɔ ne yee Wurubuarɛ. Wurubuarɛ feliŋ doo ɔ man te ɔ ne daa wee keŋ Wurubuarɛ waa kaa lɛɛ Iseraetena nyee nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wurubuarɛ feliŋ ŋon lese la wola e nyi, waa naa nyeelɛɛre ŋon de Gbeŋgyoo Wurubuarɛ be yako see nyi waa kɔŋ nɛ pɛna ŋon Simeɔn ka yeŋ. ");
INSERT INTO ntr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Wurubuarɛ feliŋ ŋon yela Simeɔn gyuu Wurubuarɛ ɔsom deni dinaa keŋ man. Gyosɛfo na Mɛɛre ka mo be bu Yesu ŋon kɔŋ be kaa do de Gbeŋgyoo Wurubuarɛ nyiŋmaa man, ŋgba mena keŋ Wurubuarɛ mmaraase ŋan ne yako nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","te Simeɔn tee ɔ nyiŋmaase lɛɛ bu ŋon te ɔ lese Wurubuarɛ yele nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“De Gbeŋgyoo Wurubuarɛ, nombii keŋ n be yako see nɛ n te di ke dɔɔ. Mena dɔɔ nyaŋ ke tale lɔ n tobaale gbɛɛ wosefɛɛreŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nawolo nyi maŋ gbagba ta mo me sibii naa nyeelɛɛre ŋon n be kpili nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","n kpila e nyi waa kɔŋ na balaŋ pou kena e. ");
INSERT INTO ntr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ŋon yɛna keŋmaŋee keŋ gyae ke yela baŋ bɔɔ yɛɛ Iseraetenawɔ ya nɛ, kena n gbɛɛneŋ na baa lese n balaŋ Iseraetena yele.” ");
INSERT INTO ntr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeɔn nɔɔwoya ŋan ɔ be yako lee be bu ŋon wose man nɛ, doo bu ŋon ɔ kya na ɔ naa nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Keŋte Simeɔn fanewɔ fa wɔ nyi Wurubuarɛ waa hiraa wɔ te ɔ yako bu ŋon ɔ naa Mɛɛre nyiaa, “Wurubuarɛ lese na bu kei. Iseraetena burum baŋ baa bɛɛ e na baa naa diyem, te baŋ mɔ baa lɛɛ e di na baa nyiŋ nyeedoŋ. Bu kei waa yɛɛ Wurubuarɛ gbagba tobaale, mɔna balaŋ baa koro seŋ tia e, ");
INSERT INTO ntr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na ka lese ŋan balaŋ burum na gyueŋ nɛ pou debɔɔ. Te nyaŋ Mɛɛre n kena diyem ŋgba sila te ba moowɔ sɔɔ neŋ n konɔɔ man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Alo kegyia ŋolo kyaawɔ ŋon bɛɛ baake e nyi Ana. Ɔ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e te ɔ kya yele yɛna Fanuwɛli. Fanuwɛli kei lee Asa dekpaŋalaŋ man. Ana kei yalawɔ te ŋon na ɔ baale kyaawɔ kulutooneŋ nyetooro, te ɔ baale yeŋawɔ yela e. ");
INSERT INTO ntr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Te ɔ kyaawɔ lialo man kulutooneŋ sɔŋonaara na anaara (84). Nelim na ka weese pou na ɔ kyae Wurubuarɛ ɔsom deni dinaa keŋ man ɔ ne bake ɔ nɔɔ fane. ");
INSERT INTO ntr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeɔn kɛɛ kolosi nɛ, te ŋon Ana mɔ kɔŋawɔ. Ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ kolosiwɔ lee bu ŋon wose man fa balaŋ baŋ bɛɛ daa nyeelɛɛre ŋon waa kɔŋ kaa lese Gyerusalɛmtena lee ba diyem man nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gyosɛfo na Mɛɛre keyɛɛ kpene kamasɛ taŋ ŋgba mena keŋ de Gbeŋgyoo Wurubuarɛ mmaraase ŋan nawolo nɛ, ba besewɔ gyu be dɛɛ Nasarɛte keŋ kyaa Galelia tɛɛle man nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bu ŋon beewɔ yɛɛ doŋ te ɔ sia karawɔ nideli, te Wurubuarɛ moo ɔ bɛrɛɛ boele e. ");
INSERT INTO ntr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kulutoo kamasɛ nɛ, Yesu ɔ kya na ɔ naa ne gyu Gyerusalɛm ke di ba nyeekelɛɛwee dinaa keŋ. ");
INSERT INTO ntr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu ke di kulutooneŋ kufu ala nɛ, be gyuu Gyerusalɛm be kaa di ba nyeekelɛɛwee dinaa kei ŋgba mena keŋ bɛɛ taŋ gyu nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Be ke di wee keŋ taŋ bese bee gyu nɛ, Yesu dɔɔwɔ Gyerusalɛm botɔɔ mɔna ɔ kya na ɔ naa ta gyem ya. ");
INSERT INTO ntr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Na baŋ gyeŋ nyi ɔ kpuɛ na be balaŋ dikpii keŋ mena dɔɔ be tɛɛwɔ wee debiliŋ pou, pɛte ba gyoo e kekɛo be tebia na ba loŋtona man. ");
INSERT INTO ntr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Keŋ ba te naa e ya dɔɔ, ba besewɔ gyu Gyerusalɛm donɔɔ man be kaa kɛo e. ");
INSERT INTO ntr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ka weeya atoorote te ba ke naa e Wurubuarɛ ɔsom deni dinaa keŋ man na ŋon na Gyudatena mmaraa wolala baŋ kyaa la. Ɔ ne tei be nombia, na ŋon mɔ ne bɔɔse wɔ nombia. ");
INSERT INTO ntr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mena keŋ ɔ ne nyii nombia ŋan asɛɛ na mena keŋ ɔ ne tira ŋe nɔɔ fa wɔ nɛ, doo baŋ pou be tei nɛ nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ɔ kya na ɔ naa ke gyu kena e botɔɔ nɛ, ba wose gbirisi wɔ. Keŋte ɔ naa bɔɔse e nyiaa, “Me bu, weera te n yɛɛ daa mena? Kɛɛ, daa na n kya sia te yɛɛ, de dɔŋɛɛ dɛɛ kɛo neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ ne kɛo maŋ? Ɛ ba gyeŋ nyi kaboena nyi maa kyaa me kya dɛɛ yee?” ");
INSERT INTO ntr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mɔna ɔ kya na ɔ naa te nyii kpene keŋ ɔ be yako wɔ nɛ asɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Botɔɔ te Yesu korowɔ sila wɔ gyu Nasarɛte donɔɔ man, te ɔ nyii ɔ kya na ɔ naa dei. Ɔ naa moo nombia kɛŋa pou do ɔ konɔɔ man, na ɔ na gyueŋ ŋe man nideli. ");
INSERT INTO ntr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu beewɔ nideli te ɔ sia karawɔ kpu, te ɔ gyoo Wurubuarɛ na balaŋ pou sia. ");
INSERT INTO ntr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Debaŋ keŋ Sakaria bu Gyɔn sɛɛ ɔ kyaa depampaa dinaa keŋ man nɛ, Wurubuarɛ kolosiwɔ fa e nyi waa gyu kekolosi Wurubuarɛ nombia fa balaŋ. Debaŋ kenaŋ na gyoo dinaa Kaesa Tiberiuse ke di gyoori Roman tɛɛle dɔɔ kulutooneŋ kufu anoŋte man kenaŋ, na Pɔntiɔse Pilato ne diina gyoori Gyudia tɛɛle dɔɔ. Herode mɔ ne diina gyoori Galelia tɛɛle dɔɔ, te ɔ naabu Filipo mɔ ne diina gyoori Iturea na Tirakonitise tɛɛlese dɔɔ, te Lisaniase mɔ ne di gyoori Abilene tɛɛle dɔɔ. Na Ana na Kaifase mɔ yɛna Wurubuarɛ saese kegyiise Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Keŋte Gyɔn tɛɛwɔ donɔɔse ŋan ŋe kyaa Gyɔɔdan boo nɔɔman nɛ pou dɔɔ ɔ ne kolosi nyiaa, “Ɛ kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man na ɛ ke kɔŋ Wurubuarɛ gyaŋ, na waa mo ɛ nombiakumɛɛ pou kyɛɛ ŋon.” ");
INSERT INTO ntr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ŋgba mena keŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon bɛɛ baake nyi Yesaya be ŋmarase ɔ tɔne man lee Gyɔn wose man nɛ nyiaa, “Ŋolo ne fae yeesa depampaa dinaa man nyiaa, ɛ desina de Gbeŋgyoo gbɛɛneŋ, na ɛ ke yela ɔ gbɛɛneŋ pou ka tenee. ");
INSERT INTO ntr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ɛ tɔ boŋobii kamasɛ na ɛ ke yɛlɛɛ bulase na bulasebia pou, na ŋa ke doo kyɛɛkyɛɛ. Ɛ tenee gbɛɛneŋ ŋan be gokii nɛ, na ɛ ke kyalase gbɛɛneŋ ŋan ŋa be kyalasɛɛ ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kɛŋa pou wɔle na, balaŋ pou baa naa nyeelɛɛre ŋon Wurubuarɛ ba lese nyi ɔ kaa lɛɛ daa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Balaŋ burum kɔŋawɔ Gyɔn gyaŋ nyi waa sɔ wɔ Wurubuarɛ loŋ te ɔ bɔɔse wɔ nyiaa, “Ɛmɛɛ baŋ ɛ dana nombiakumɛɛ ŋgba doma nɛ, amɔte faree na ŋon nyi yaa yeu lee Wurubuarɛ baŋ dinaa keŋ gyae kekɔŋ balaŋ dɔɔ nɛ man? ");
INSERT INTO ntr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ɛ yɛɛ nombia kpaakpaa ŋan nawolo nyi ɛ te kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man nɛ. Ɛ na yɛɛ ya agyueŋ nyi keŋ ɛ yɛɛ Aberaham ɔ naanasewɔ dɔɔ te Wurubuarɛ lɛɛ ŋon ya. Mɛɛ yako ŋon nyi Wurubuarɛ waa tale yela boya adoŋ kɛŋa ka bese naanase fa Aberaham. ");
INSERT INTO ntr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wurubuarɛ te desina ɔ debeŋa see waa tuŋii daase lɔ, mena dɔɔ daŋ kamasɛ keŋ bɛɛ se bia kpaakpaa ya na, waa tuŋ ke lɔ na baa keretii ke do boalaŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Botɔɔ te balaŋ dikpii keŋ bɔɔse Gyɔn nyiaa, “Akpaa mena na, woŋ te kaboena nyi dɛɛ yɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Keŋte Gyɔn tiranɔɔ fa wɔ nyiaa, “Nyaŋ ŋon n dana kegbase ala na, mo dokoloŋ fa ŋon ɔ be taŋ ya nɛ, te nyaŋ ŋon mɔ n dana weenɛɛ na, fa ŋon ɔ be taŋ ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lempoolɛɛra baale mɔ kɔŋawɔ nyi Gyɔn dɛɛ sɔ wɔ Wurubuarɛ loŋ te be bɔɔse e nyiaa, “De Gbeŋgyoo, woŋ te kaboena nyi daa mɔ dɛɛ yɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Keŋte Gyɔn tiranɔɔ fa wɔ nyiaa, “Ɛ na lɛɛ kɔba kela keŋ kaboena nyi yaa lɛɛ nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yoonɔɔtena baale mɔ bɔɔse e nyiaa, “Daa mɔ de? Woŋ te kaboena nyi dɛɛ yɛɛ?” Keŋte Gyɔn yako wɔ nyiaa, “Ɛ na mo siadoŋ lɛo ŋolo kɔba ya, yaa ɛ na mo nombiakumɛɛ gyakaa ŋolo dɔɔ ya. Ɛ yela kɔba keŋ bɛɛ tɔ ŋon nɛ ka gyoo ɛ sia.” ");
INSERT INTO ntr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lee mena keŋ balaŋ baŋ ne daa nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ dɔɔ nɛ, walaŋ kamasɛ yɛɛ wa agyueŋ nyi Gyɔn yɛna nyeelɛɛre ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Keŋte Gyɔn tiranɔɔ fa be popou nyiaa, “Maŋ dɔɔ loŋ te mɛɛ mo sɔ ŋon Wurubuarɛ loŋ, mɔna ŋon ɔ kela maŋ nɛ waa kɔŋ keŋ maŋ tekaboe gba nyi maa buŋ booli ɔ nkyokota ŋmeeseŋ koraŋ gba ya. Ŋon dɔɔ Wurubuarɛ feliŋ na boalaŋ, te waa mo sɔ ŋon Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔ dana ɔ pampaa ɔ nyiŋmaa man waa mo feefu wa amɔla, na waa lese amɔla bia ŋan do ɔ kpee man, na waa kuu wura ŋan ka do boalaŋ keŋ bɛɛ yem ya nɛ man.” ");
INSERT INTO ntr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Keŋte Gyɔn tɛɛwɔ gbɛɛneŋ burum dɔɔ kolosi Wurubuarɛ nombia fa wɔ, te ɔ doo wɔ kakyeŋ nyi baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gyɔn lese nombiakumɛɛ burum ŋan Herode ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man be yɛɛ nɛ si e, na mena keŋ ɔ be lɛo ŋon gbagba ɔ kegyia wɛɛle Herodia yala nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Te nombiikum keŋ Herode be yɛɛ tɔ nɔɔ koraŋ yɛna nyi, ɔ yela be kyaŋa Gyɔn ke tɔ deni. ");
INSERT INTO ntr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Gyɔn ke sɔ balaŋ dikpii keŋ Wurubuarɛ loŋ taŋ nɛ, ɔ sɔɔ Yesu mɔ Wurubuarɛ loŋ. Ɔ ke sɔ e taŋ na te Yesu moowɔ ɔ ne fane. Botɔɔ te adido torowɔ, ");
INSERT INTO ntr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","keŋte Wurubuarɛ feliŋ ŋon moo duwuluŋ dinɔɔ te ɔ kaa gyakaawɔ Yesu dɔɔ. Botɔɔ te be nyii nɔɔwoya ŋaale lee adido nyiaa, “Nyaŋ yɛna me bu ŋon mɛɛ gyae neŋ lee me konɔɔ man, te n na gyoo me sia nideli.” ");
INSERT INTO ntr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Debaŋ keŋ Yesu be fi ɔ tom keyɛɛ asɛɛ nɛ, na ɔ te di ŋgba kulutooneŋ sao na kufu nɛ, na balaŋ na gyueŋ nyi Yesu yɛɛ Gyosɛfo bu dalolasa e. ");
INSERT INTO ntr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mɔ ɔ kya yɛna Matati, ");
INSERT INTO ntr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Gyosɛfo ɔ kya yɛna Matatia, ");
INSERT INTO ntr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ɔ kya yɛna Maati ");
INSERT INTO ntr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Gyoda ɔ kya yɛna Gyoana ");
INSERT INTO ntr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mɔ ɔ kya yɛna Mɛliki ");
INSERT INTO ntr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ɔ kya yɛna Gyosua ");
INSERT INTO ntr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ɔ kya yɛna Simeɔn ");
INSERT INTO ntr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ɔ kya yɛna Melea ");
INSERT INTO ntr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Defidi ɔ kya yɛna Gyese ");
INSERT INTO ntr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔn ɔ kya yɛna Aminadabo ");
INSERT INTO ntr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Gyuda ɔ kya yɛna Gyekɔpo ");
INSERT INTO ntr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahɔ mɔ ɔ kya yɛna Serugi ");
INSERT INTO ntr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sɛla ɔ kya yɛna Kainan ");
INSERT INTO ntr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛke ɔ kya yɛna Metusala ");
INSERT INTO ntr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan mɔ ɔ kya yɛna Enose ");
INSERT INTO ntr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ka lee Gyɔɔdan boo keŋ man nɛ, na Wurubuarɛ feliŋ doo ɔ man nideli. Te Wurubuarɛ feliŋ ŋon yela Yesu gyuu depampaa dinaa daale man, ");
INSERT INTO ntr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","botɔɔ te ɔbɔnsam kaa kɛɛse e weeya sɔŋola. Weeya ŋenaŋ man pou na ɔ ta mo kolo daa ɔ nɔɔ ya. Te weeya ŋenaŋ kesi nɛ, tanam kyaŋa e nideli. ");
INSERT INTO ntr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Botɔɔ te ɔbɔnsam yako e nyiaa, “Akpaa nyaŋ yɛna Wurubuarɛ bu ŋon na, yela boe kei ka bese weenɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Keŋte Yesu tiranɔɔ fa e nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see ne yako daa nyiaa, na weenɛɛ kaageŋ ne gyae la ke fa walaŋ nyeedoŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Botɔɔ te ɔbɔnsam moo Yesu gyu bula dinaa daale nyee dɔɔ, te ɔ lese tɛɛle kei dɔɔ gyoorobiiri pou wola e karatetee dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Keŋte ɔ yako Yesu nyiaa, “Maa mo gyoorobiiri na abɔɔ nya anaŋ kɛŋa pou doŋ do n nyiŋmaa man na n ke di ŋe dɔɔ. Nawolo nyi be ta mo ŋe popou fa maŋ, mena dɔɔ maa tale mo ŋa fa walaŋ kamasɛ ŋon mɛɛ gyae. ");
INSERT INTO ntr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mena dɔɔ nyi akpaa n buŋ me nawɔɔtɛɛ som maŋ na, abɔɔ kɛŋa pou gyae ka bese n wui.” ");
INSERT INTO ntr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Keŋte Yesu tiranɔɔ fa e nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see ne yako daa nyiaa, De Gbeŋgyoo Wurubuarɛ waageŋ te kaboena nyi nya buŋ na n ka som e.” ");
INSERT INTO ntr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Botɔɔ te ɔbɔnsam moo Yesu gyu Gyerusalɛm donɔɔ man te ɔ mo e gyu Wurubuarɛ ɔsom deni dinaa keŋ nyee man adido adido te ɔ yako e nyiaa, “Akpaa nyaŋ yɛna Wurubuarɛ bu ŋon na, fuŋ n wose lee kɛbo ke lɔ tɛɛle man, ");
INSERT INTO ntr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","nawolo nyi Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako daa nyi, ‘Nyaŋ dɔɔ Wurubuarɛ waa kpila ɔ kpilala na be kaa gyee neŋ nideli, ");
INSERT INTO ntr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na baa kɔlee neŋ keŋ nyi, n be gyae n ka mo n nae gyɔ na boe koraŋ gba ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Keŋte Yesu tiranɔɔ fa e nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see na bese yako daa nyiaa, ‘Na kɛɛse n Gbeŋgyoo Wurubuarɛ ŋon kɛɛ ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Debaŋ keŋ ɔbɔnsam be kɛɛse e kina taŋ nɛ, ɔ tinaa Yesu yela pɛ kelii debaŋ keŋ waa bese nyiŋ gbɛɛ wɔle bela. ");
INSERT INTO ntr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wurubuarɛ feliŋ ŋon yela Yesu besewɔ gyu Galelia tɛɛle man, te ɔ wose man nombia yaaseewɔ tɛɛle kenaŋ pou dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu tɛɛwɔ wola Gyudatena ɔsom denɛɛ man, te walaŋ kamasɛ kɛlɛɛ e. ");
INSERT INTO ntr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu gyuuwɔ Nasarɛte botɔɔ keŋ bɔɔ kɛɛle e nɛ, te Gyudatena kefɛɛfowee kelii nɛ, ɔ gyuuwɔ Gyudatena ɔsom deni man ŋgba mena keŋ ɔ ne taŋ yɛɛ nɛ. Keŋte ɔ korowɔ seŋ nyi waa kala Wurubuarɛ nombia ŋan, ");
INSERT INTO ntr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","botɔɔ te ba moo Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya tɔne fa e. Ɔ gyuusu tɔne keŋ te ɔ kala botɔɔ keŋ bɔɔ ŋmarase nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“De Gbeŋgyoo Wurubuarɛ feliŋ doo me man, nawolo nyi ɔ ta lese maŋ see nyi maa kolosi ɔ nombia kpaakpaa ŋan fa ayematena. Ɔ te kpila maŋ nyi maa yako yoo gbeŋa nyi Wurubuarɛ waa lese wɔ lee be gbeŋiri man, na maa yako siayɛlɛɛsatena nyi be sia gyae ke gyuusu, na baŋ mɔ bee wuritii wɔ nɛ ke nyiŋ ba wose, ");
INSERT INTO ntr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na maa yela balaŋ pou ka gyeŋ nyi, debaŋ keŋ de Gbeŋgyoo Wurubuarɛ waa kaa lɛɛ ɔ balaŋ nyee nɛ ta benaa.” ");
INSERT INTO ntr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Keŋte Yesu bɔɔ tɔne keŋ te ɔ besena ke fa tobaale ŋon ɔ ba mo ke fa e nɛ, te ɔ tisiwɔ kyaa. Balaŋ baŋ pou be kyaa bɔ ɔsom deni keŋ man nɛ, fɛɛ be sia bɛɛ kɛɛ e nɛ fee. ");
INSERT INTO ntr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Botɔɔ te Yesu yako wɔ nyiaa, “Gyɛŋ wee kei nɛ, Wurubuarɛ nombia ma akalaŋ kɛŋa te kɔŋ mena ɛmɛɛ gbagba ɛ siaman ŋgba mena keŋ ɛ be nyii mɔɔ kale nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nombia kpaakpaa ŋan Yesu be yako nɛ, doo balaŋ baŋ pou bɔɔ gyaŋee botɔɔ nɛ nɔɔ te be kɛlɛɛ e. Keŋte be bɔɔse dɔŋa nyiaa, “Na Gyosɛfo bu ŋon yaa yee?” ");
INSERT INTO ntr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Keŋte Yesu yako wɔ nyiaa, “Ma gyeŋ nyi ɛ ke gyɔ maŋ dudu kei nyi ‘Nyaŋ ŋon n ne kyɔ balaŋ nɛ, kyɔ n wose na dɛɛ kɛɛ.’ Te ɛ ka bese yako maŋ nyi, ‘Gyakoloŋ nombia ŋan dɔɔ nyii n be yɛɛ Kapanum donɔɔ man nɛ, yɛɛ ŋa nyaŋ gbagba n donɔɔ man kɛbo mɔ na dɛɛ kɛɛ.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu besewɔ yako wɔ kpu nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyi Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo be kyaa keŋ bɛɛ lɛɛ e ŋon gbagba ɔ dɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ampaŋ yaa mɛɛ yako ŋon nyi, debaŋ keŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Elia be kyaa nɛ, na liala burum kyaa Iserae tɛɛle dɔɔ, mɔna debaŋ keŋ ɔga ba sem kulutooneŋ atooro na yaale, te tanam dinaa be yale tɛɛle keŋ pou dɔɔ nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Wurubuarɛ te kpila Elia nyi waa gyu ke kyɔ be man ŋolo ya. Ɔ kpila e bo gyu lialo ŋon ɔ te yɛɛ Iserae alo e ya, te ɔ kyaa Sarefate donɔɔ keŋ kyaa Sidɔn tɛɛle man nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wurubuarɛ dekpeŋkpeŋgyɔɔre Elisa mɔ ke kyaa nɛ, na akuŋtuŋtena burum kyaa Iserae tɛɛle dɔɔ mɔna Wurubuarɛ te kyɔ be man ŋolo ya. Siria baale Naaman ŋon waageŋ te ɔ kyɔɔwɔ. ");
INSERT INTO ntr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Balaŋ baŋ pou be kyaa Gyudatena ɔsom deni keŋ man kenyii nombia kɛŋa nɛ, ba gyeŋa baŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Botɔɔ te balaŋ baŋ korowɔ gyu ke kyaŋ Yesu wɔŋee e lee donɔɔ keŋ man, te ba moo e gyu bula keŋ dɔɔ donɔɔ keŋ gyakaa nɛ nyee man, nyi baa fuŋ e ke lɔ delɔkɔtɔɔ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mɔna Yesu moowɔ balaŋ baŋ pou nsana nsana te ɔ laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu gyuuwɔ Kapanum donɔɔ keŋ ke kyaa Galelia tɛɛle man nɛ man. Te Gyudatena kefɛɛfowee kelii na, ɔ gyuuwɔ ka wola wɔ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yesu kawola keŋ doo balaŋ baŋ pou nɔɔ, nawolo nyi ɔ ne gyɔ ɔ konɔɔ wola ŋgba walaŋ ŋon ɔ dana doŋ nombia ŋan ɔ na wolo nɛ dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na balee ŋolo kyaa Gyudatena ɔsom deni keŋ man keŋ feliŋkum doo ɔ man. Ɔ fae yeesa keŋkeŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nyaŋ Yesu Nasarɛte baale, woŋ yaa n ne gyae de gyaŋ? N kɔŋae n kaa wɔlɛɛ daa? Ma gyeŋ neŋ nyi nyaŋ yɛna Wurubuarɛ walaŋ ŋon ayimɛɛ be doo n man ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Botɔɔ te Yesu yase ɔ sia yako feliŋkum keŋ nyiaa, “Wu n nɔɔ, na n ka lee ɔ man.” Keŋte feliŋkum keŋ fuŋa balee ŋon lɔ balaŋ baŋ pou siaman te ka leewɔ ɔ man laŋ, mɔna balee ŋon te gooli ya. ");
INSERT INTO ntr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nombii kei doo balaŋ baŋ pou nɔɔ te be bɔɔse dɔŋa nyiaa, “Woŋ kawola yɛna kei? Ɔ na mo doŋ kolosi fa feliŋkumɛɛ na ŋɛɛ lee balaŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Keŋte Yesu wose man nombia yaaseewɔ gyu debiise ŋan ŋa benaa na botɔɔ nɛ pou man. ");
INSERT INTO ntr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu ka lee Gyudatena ɔsom deni keŋ man na, te ɔ gyuuwɔ Simɔn dɛɛ. Ɔ ke gyu botɔɔ na Simɔn wa awu doo ɔ na wee kpaŋalaŋ. Keŋte be waase Yesu nyi waa kyɔ e kawee fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Botɔɔ te ɔ ka seŋawɔ alo ŋon yenaŋ te ɔ fae kpaŋalaŋ keŋ, te ɔ kawee keŋ taŋawɔ. Debokenaŋ man te alo ŋon korowɔ kyaa te ɔ kɛɛ be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kelii balinɔɔ nɛ, balaŋ burum moo kaweesetena baŋ bɛɛ wee kaweese kpookpoo nɛ kɔŋ Yesu gyaŋ, te ɔ moo ɔ nyiŋmaa gyakaa kaweete kamasɛ dɔɔ te ɔ kyɔɔ wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Feliŋkumɛɛ mɔ leewɔ balaŋ burum man na ŋɛɛ fae yeesa nyi, “Nyaŋ yɛna Wurubuarɛ bu ŋon.” Mɔna ɔ fae ŋa keŋ ɔ te fa ŋa gbɛɛ ŋa ke kolosi ya, nawolo nyi ŋa gyeŋ nyi ŋon yɛna Kristo, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tɛɛ kena nɛ, Yesu wɔŋa ɔ wose lee yenaŋ. Botɔɔ na balaŋ baŋ te fiasɛɛ bɛɛ kɛo e. Ba kena e nɛ, ba te fa e gbɛɛ waa lee be gyaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mɔna ɔ yako wɔ nyiaa, “Kaboena nyi maa kolosi Wurubuarɛ gyoori keŋ wose man nombia kpaakpaa ŋan fa donɔɔse akaŋ ŋan mɔ, nawolo nyi keŋ dɔɔ te Wurubuarɛ kpila maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mena dɔɔ Yesu tɛɛwɔ kolosi Wurubuarɛ nombia Gyudatena ɔsom denɛɛ man Galelia tɛɛle dɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wee daale Yesu ka seŋ Genesareti boo nɔɔman nɛ, balaŋ burum kaa yilaawɔ kilisi e bee nyii Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Keŋte ɔ naa agbelese ala boo keŋ nɔɔman, na kpɛɛ kyaŋara baŋ ta lee bɛɛ faafo ba asawuse. ");
INSERT INTO ntr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu gyoowɔ degbele keŋ daale man, keŋ ke yɛɛ Simɔn wui nɛ. Te ɔ yako e nyi waa tɛɛse e gyu loŋ keŋ man kyomii. Yesu kyaawɔ degbele keŋ man botɔɔ te ɔ wola balaŋ dikpii keŋ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ɔ kekolosi taŋ nɛ, ɔ yako Simɔn nyiaa, “Ɛ saa gyu loŋ keŋ nsana nsana botɔɔ keŋ dana siiliŋ nɛ, na ɛ ke lɔ ya asawuse ŋan na ɛ ke kyaŋ kpɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Botɔɔ te Simɔn tiranɔɔ nyiaa, “De Gbeŋgyoo, da te yɛɛ tom nelim pou da te kyaŋ kolo ya! Mɔna keŋ nyaŋ be yako dɔɔ, dɛɛ lɔ da asawuse.” ");
INSERT INTO ntr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba ke lɔ ba asawuse ŋan nɛ, be kyaŋa kpɛɛ burum keŋ nyi ba asawuse ŋan ne lɛɛ gbɛɛ ŋe ke tirii. ");
INSERT INTO ntr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mena dɔɔ be baake be tebia baŋ be doo degbele daale man nɛ nyi be kaa kyɔ wɔ. Ba kekɔŋ nɛ, be kaa lese kpɛɛ wulu agbelese ala ŋan pou keŋ nyi, ŋe lɛɛ gbɛɛ nafɔ ŋe ke munu. ");
INSERT INTO ntr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔn Pita kena kpene keŋ be kɔŋ nɛ, ɔ buŋawɔ ɔ doona dɔɔ Yesu siaman yako e nyiaa, “Lee me gyaŋ, me Gbeŋgyoo! Me yɛɛ nombiakumɛɛyɛɛre e.” ");
INSERT INTO ntr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nawolo nyi lee kpɛɛ burum baŋ bɔɔ kyam nɛ dɔɔ, doo ŋon na ɔ tebia baŋ pou nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mena mɔ te doo ɔ tebia Sebedeo bia Gyemisi na Gyɔn baŋ baŋ na wɔ ne yɛɛ tom nɛ nɔɔ. Botɔɔ te Yesu yako Simɔn nyiaa, “Na yee ya, lee gyɛŋ ne gyu nɛ, balaŋ te maa yela n ke kyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mena dɔɔ ba ke saa ba agbelese ŋan kɔŋ dekeŋkeŋ dɔɔ nɛ, be tinaa kpene kamasɛ yela botɔɔ te be sila Yesu laŋ. ");
INSERT INTO ntr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu kekyaa donɔɔse ŋan daale man nɛ, balee ŋolo kɔŋawɔ keŋ kaweeyayam te di ɔ wose pou. Ɔ kena Yesu nɛ, ɔ kaa buŋawɔ ɔ nawɔɔtɛɛ waase e nyiaa, “Me Gbeŋgyoo, akpaa n ne gyae na nyaŋ ke tale kyɔ maŋ kawee.” ");
INSERT INTO ntr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Botɔɔ te Yesu tenee ɔ nyiŋmaa tina e te ɔ yako nyiaa, “Mɛɛ gyae, n kawee dɛɛ taŋ.” Debokenaŋ man te balee ŋon kawee taŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Keŋte Yesu tɔɔ e kiiŋ nyi, “Na yeli walaŋ na walaŋ ke nyii ya, mɔna mo n wose gyu kawola Wurubuarɛ sae ŋon, na n ke deesi ŋgba mena keŋ Mosesi ba wola ŋon nɛ, na kedi adansɛɛ fa walaŋ kamasɛ nyi n kawee te taŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mɔna nɛnɛɛ gba te Yesu wose man nombia yaaseewɔ gyu yenaŋ kamasɛ, te balaŋ burum kɔŋawɔ be kaa nyii e na waa kyɔ wɔ be kaweese. ");
INSERT INTO ntr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mɔna Yesu ne kyaa wɔŋ ɔ wose lee yenaŋ gyu kefane. ");
INSERT INTO ntr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wee daale Yesu kɛɛ wolo nɛ, na Farasiitena na Gyudatena mmaraa wolala baŋ bɔɔ lee Galelia na Gyudia tɛɛlese man, na Gyerusalɛm donɔɔ man nɛ, baale kyaa botɔɔ. Debaŋ kenaŋ na, de Gbeŋgyoo Wurubuarɛ doŋ doo Yesu man keŋ waa tale mo kyɔ kaweese. ");
INSERT INTO ntr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Te balaŋ baale seele walaŋ ŋon ɔ yenaŋ ba yem nɛ dofoŋoŋ dɔɔ kɔŋ, na bɛɛ gyae gbɛɛ na baa mo e gyoo dekpaŋalaŋ keŋ man ka see Yesu siaman, ");
INSERT INTO ntr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mɔna be te nyiŋ gbɛɛ mo e ta denanɔɔ man ya, nawolo nyi balaŋ boe. Mena dɔɔ ba gyeŋawɔ gyu deni keŋ nyee dɔɔ te be wolee yenaŋ daale, te be tisinaa e na ɔ dofoŋoŋ keŋ pou dɛɛdɛɛ see Yesu siaman balaŋ baŋ nsana nsana. ");
INSERT INTO ntr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu kena mena keŋ bɔɔ lɛɛ e di nɛ, ɔ yako kaweete ŋon nyiaa, “Me gyoo, me ta mo n nombiakumɛɛ pou kyɛɛ neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Botɔɔ te Gyudatena mmaraa wolala na Farasiitena baŋ fiasɛɛ bɛɛ bɔɔse dɔŋa nyiaa, “Walaŋ woŋti yaa kei te ɔ na mo ɔ wose kɛɛse na Wurubuarɛ mena? Lee Wurubuarɛ wɔle na amɔ kyaa la keŋ waa tale mo dukum kyɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na Yesu gyeŋ kpene keŋ bɛɛ gyueŋ nɛ te ɔ bɔɔse wɔ nyiaa, “Woŋ dɔɔ te ɛ na gyueŋ kɛŋa ɛ nyeeya man? ");
INSERT INTO ntr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nombia kɛŋa man woŋti woɛla na keyako? ‘Me ta mo n dukum kyɛɛ neŋ,’ yaa ‘Koro seŋ na n ke ta?’ ");
INSERT INTO ntr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mɔna mɛɛ gyae ɛ ka gyeŋ nyi maŋ Deniwalaŋ Bu dana doŋ tɛɛle kei dɔɔ nyi maa mo dukum kyɛɛ. Mena dɔɔ ɔ yako kaweete ŋon nyiaa, Koro seŋ, gate n dofoŋoŋ na n ke ta gyu n dɛɛ!” ");
INSERT INTO ntr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Debokenaŋ man te kaweete ŋon korowɔ seŋ ɔ nawɔɔ dɔɔ be siaman te ɔ gate ɔ dofoŋoŋ keŋ dɔɔ ɔ doo nɛ, te ɔ laŋa ɔ dɛɛ. Ɔ ne gyu na ɔ na lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nombia kɛŋa doo balaŋ baŋ pou nɔɔ nideli te ba lese Wurubuarɛ yele. “Gyakoloŋ gyoo wɔ te be yakowɔ nyiaa, gyɛŋ dɔɔ da te naa nombia ŋan te kɔŋa ta see ya.” ");
INSERT INTO ntr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nombia kɛŋa wɔle nɛ Yesu leewɔ te ɔ ke naa lempoolɛɛre ŋolo ŋon bɛɛ baake e nyi Lewi nɛ, na ɔ kyaa ɔ lempoo delɛe man. Keŋte Yesu yako e nyiaa, “Koro sila maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Debokenaŋ man te Lewi tinaa kpene kamasɛ yela te ɔ korowɔ sila Yesu. ");
INSERT INTO ntr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Keŋte Lewi moo Yesu gyu ŋon Lewi dɛɛ te ɔ ke saa e weenɛɛ ampaŋ ampaŋ. Lempoolɛɛra burum na balaŋ yakaa nyibaŋ kɔŋawɔ kaa di bom na wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Botɔɔ te Farasiitena na Gyudatena mmaraa wolala baŋ bɔɔ lee Farasiitena dikpii keŋ man nɛ ŋorokoteewɔ bɔɔse Yesu kaseela baŋ nyiaa, “Weera dɔɔ te ɛmɛɛ na lempoolɛɛra na nombiakumɛɛyɛɛra ne dii te ɛ ne nyɔɔ bom?” ");
INSERT INTO ntr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Kaweesetena te kaboena nyi baa kyɔ wɔ kawee. Baŋ bɔɔ na wee ya nɛ dɔɔ, bɔɔ ne hia kawee kekyɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma te kɔŋ nyi me kaa baake balaŋ baŋ be gbɛɛneŋ wulaa tenɛɛ Wurubuarɛ siaman nɛ ya, mɔna me kɔŋae me kaa baake nombiakumɛɛyɛɛra na baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa kɔŋ Wurubuarɛ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Keŋte be yako Yesu nyiaa, “Gyɔn Wurubuarɛ loŋsɔɔre ŋon silala ne kyaa bake be nɔɔ fane, te mena mɔ yaa Farasiitena silala mɔ ne yɛɛ. Mɔna nyaŋ wui kɛwɔ dɔɔ bee dii bɛɛ nyɔɔ debaŋ kamasɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ ke tale yela balaŋ baŋ be kyaa alowɔletɛɛ nɛ ke bake be nɔɔ keŋ alowɔle baale kyaa be gyaŋ? ");
INSERT INTO ntr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mɔna debaŋ daale gyae kekɔŋ keŋ baa mo alowɔle baale ŋon lee be gyaŋ. Mena weeya ŋenaŋ man te baa bake be nɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Keŋte Yesu gyɔɔ wɔ dudu kei nyiaa, “Ŋolo bɛɛ kara kanyaŋ wɔle mo taa kakyeŋgbelaa keŋ ba yem nɛ ya. Akpaa ɔ yɛɛ mena na ɔ te wɔlɛɛ kanyaŋ wɔle keŋ, nawolo nyi kanyaŋ wɔle keŋ be gyae ke kyaa na bene keŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mena mɔ te ŋolo bɛɛ mo soloŋ wɔle do wonembu tɔne ogele bene man ya. Ɔ yɛɛ mena na soloŋ wɔle keŋ gyae ke tao wonembu tɔne ogele keŋ lii na soloŋ keŋ ke leki, na wonembu tɔne ogele keŋ mɔ ke wɔlɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mena dɔɔ kaboena bo nyi baa mo soloŋ wɔle do wonembu tɔne ogele wɔle man. ");
INSERT INTO ntr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Te ŋolo be kyaa keŋ nyi ɔ nyɔɔ soloŋ apaesa na, waa yako nyi ɔ ne gyae ntoŋkum waa nyɔɔ bela ya. Nawolo nyi ɔ ne yako nyi apaesate keŋ yɛna kpaakpaate.” ");
INSERT INTO ntr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gyudatena kefɛɛfowee daale nɛ, Yesu na ɔ kaseela gyuuwɔ ka mo wɔɔ daale man. Na weenɛɛ ŋan seŋɛɛ wɔɔ keŋ man nɛ yɛɛ ŋgba kefaa nɛ. Keŋte ɔ kaseela baŋ kpera ŋaale posaa bɛɛ tao. ");
INSERT INTO ntr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Keŋte Farasiitena baale naa wɔ te be bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ ne yɛɛ kpene keŋ da mmaraa bɛɛ fa gbɛɛ nyi baa yɛɛ da kefɛɛfowee ya nɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ te kala ta lee Wurubuarɛ tɔne man kpene keŋ gyoo Defidi be yɛɛ debaŋ keŋ tanam be kyaŋ ŋon na ɔ balaŋ baŋ yee? ");
INSERT INTO ntr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ɔ gyuuwɔ Wurubuarɛ ɔsom deni dinaa keŋ man te ɔ ka moo weenɛɛ ŋan bɔɔ mo deesi fa Wurubuarɛ, keŋ nafɔ tekaboena nyi walaŋ ŋon ɔ te yɛɛ Wurubuarɛ sae e ya waa di ya nɛ, te ɔ diiwɔ te ɔ moo ŋaale mɔ fa ɔ balaŋ baŋ be silana e nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Keŋte Yesu yako wɔ nyiaa, “Maŋ Deniwalaŋ Bu ŋon yɛna kefɛɛfowee keŋ Gbeŋgyoo.” ");
INSERT INTO ntr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gyudatena kefɛɛfowee daale bela nɛ, Yesu gyuu Gyudatena ɔsom deni man ɔ na wola wɔ. Na baale ŋolo kyaa botɔɔ keŋ ɔ dunoluŋ baam ba yem. ");
INSERT INTO ntr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Gyudatena mmaraa wolala na Farasiitena baale gyae gbɛɛ keŋ baa mo nombiikum daale seele Yesu na baa nyiŋ kyaŋ e, mena dɔɔ ba deke e na baa kɛɛ nyi waa kyɔ ŋolo kawee Gyudatena kefɛɛfowee keŋ. ");
INSERT INTO ntr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mɔna na Yesu gyeŋ kpene keŋ bɛɛ gyueŋ te ɔ yako baam dayeŋasate ŋon nyiaa, “Koro seŋ na n ke kɔŋ kaa seŋ balaŋ kɛwɔ pou siaman.” Keŋte balee ŋon korowɔ kaa seŋ be siaman. ");
INSERT INTO ntr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Woŋ te da mmaraa ne fa gbɛɛ nyi dɛɛ yɛɛ kefɛɛfowee keŋ? Da mmaraa ne fa daa gbɛɛ nyi dɛɛ yɛɛ kolo kpaakpaa yaa dɛɛ yɛɛ kolo kum? Dɛɛ lɛɛ walaŋ nyee yaa dee yela waa yeŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Keŋte Yesu kɛɛ wɔ pou gyaŋee te ɔ yako balee ŋon nyiaa, “Tenee n baam.” Balee ŋon tenee ɔ baam keŋ te kawee keŋ taŋawɔ te ɔ baam keŋ yɛɛ doŋ. ");
INSERT INTO ntr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Botɔɔ te kegyiise baŋ gyeŋa baŋ nideli, te be fiasɛɛ bɛɛ gyueŋ kpene keŋ baa mo yɛɛ Yesu. ");
INSERT INTO ntr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Debaŋ kenaŋ man wee daale nɛ Yesu gyuuwɔ bula dɔɔ ɔ kaa fane, te ɔ fanewɔ fa Wurubuarɛ nelim kenaŋ pou. ");
INSERT INTO ntr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tɛɛ kena nɛ ɔ baake ɔ kaseela kɔŋ ɔ gyaŋ te ɔ lese baala kufu bala lee be man nyi baa yɛɛ ɔ kpilala. ");
INSERT INTO ntr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Baala kufu bala baŋ Yesu ba lese nɛ yela yɛna Simɔn, ŋon Yesu ba do e yele nyi Pita nɛ, na ɔ naabu Anderiase na Gyemisi na Gyɔn na Filipo na Batolomeo na ");
INSERT INTO ntr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo na Tomase na Alfeose bu Gyemisi na Simɔn ŋon ɔ ne gyae ɔ balaŋ nideli nɛ ");
INSERT INTO ntr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Gyemisi bu Gyudase na Gyudase Isekarɔte ŋon waa kaa lese Yesu fa nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu na ɔ kpilala baŋ ka lee bulabii keŋ dɔɔ kɔŋ detaŋgya man nɛ, ɔ kaseela burum na balaŋ dikpii burum baŋ bɔɔ lee Gyudia tɛɛle dɔɔ na Gyerusalɛm donɔɔ man na Tae na Sidɔn donɔɔse ŋan kyaa ɛpo nɔɔman nɛ kɔŋawɔ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Be kɔŋawɔ be kaa nyii Wurubuarɛ nombia na waa kyɔ wɔ be kaweese. Baŋ feliŋkumɛɛ ne haa wɔ nɛ, ɔ kyɔɔ baŋ mɔ. ");
INSERT INTO ntr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na balaŋ baŋ pou ne gyae nyi baa tina e, nawolo nyi doŋ na lee ɔ man na ne kyɔ wɔ be kaweese pou. ");
INSERT INTO ntr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu gyinaa ɔ sia kɛɛ ɔ kaseela baŋ te ɔ yako wɔ nyiaa, “Ɛmɛɛ baŋ ɛ yɛɛ ayematenawɔ nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ te Wurubuarɛ gyoori keŋ yɛɛ ɛ wui. ");
INSERT INTO ntr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɛmɛɛ baŋ tanam dana ŋon debokeiman nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ ne gyaela ɛ kaa baa. Ɛmɛɛ baŋ ɛ ne wii debokeiman nɛ ɛmɛɛ na nyeebam, nawolo nyi ɛmɛɛ ne gyaela ɛ kaa boŋo. ");
INSERT INTO ntr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Ɛmɛɛ baŋ balaŋ ne kɔla ŋon te bɔɔ ne lɛɛ ŋon do ba wose man ya te bɛɛ tee ŋon, te bɛɛ baake ŋon nyi balaŋ kumɛɛ lee maŋ Deniwalaŋ Bu ŋon dɔɔ nɛ ɛmɛɛ na nyeebam. Mena ke te be naanaɔ mɔ naase Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ diyem. Dekɔŋ mena na ɛ yela ɛ sia ka gye na ɛ ke nyaŋee nideli, nawolo nyi kom keŋ Wurubuarɛ waa tɔ ŋon adido nɛ te yɛɛ nsendee ya. ");
INSERT INTO ntr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mɔna ɛmɛɛ baŋ ɛ dana kɔba nɛ ɛ laako, nawolo nyi ɛ taŋ ke di ɛ gyoŋ pou taŋ tɛɛle kei dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ɛmɛɛ baŋ ɛ be dii baa debaŋ kei nɛ ɛ laako, nawolo nyi tanam gyae kaa ko ŋon. Ɛmɛɛ baŋ ɛ na boŋo debaŋ kei nɛ ɛ laako, nawolo nyi yaa kaa wii na ɛ ke di walaŋsa. ");
INSERT INTO ntr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ɛmɛɛ baŋ balaŋ pou ne kolosi ɛ wose man nombia kpaakpaa nɛ ɛ laako, nawolo nyi mena mɔ te be kyaɔ yɛɛ balaŋ baŋ bɔɔ dii akɛrɛɛ nyi be yɛɛ Wurubuarɛ akpeŋkpeŋgyɔɔrawɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ɛmɛɛ baŋ ɛ ne tei maŋ nɛ mɛɛ yako ŋon na ɛ ke nyii nyiaa, ɛ gyae balaŋ baŋ bɛɛ kɔla ŋon nɛ na ɛ ke yɛɛ deeli fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɛ sola Wurubuarɛ na waa hiraa baŋ bɛɛ falaa ŋon nɛ, na ɛ kefane fa baŋ bɛɛ naase ŋon diyem nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Akpaa ŋolo de gyɔ n lakaa man na besena alate keŋ mɔ fa e. Mena mɔ te akpaa ŋolo da mo n kegba wurikyim na mo atetate keŋ mɔ kpu e. ");
INSERT INTO ntr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Akpaa ŋolo da sola neŋ kolo na fa e te akpaa ŋolo da mo n kolo na, na gyu ke bɔɔse ke dɔɔ bela ya. ");
INSERT INTO ntr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kpene keŋ n ne gyae nyi walaŋ waa yɛɛ fa neŋ nɛ nyaŋ mɔ yɛɛ ke fa e. ");
INSERT INTO ntr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Akpaa ɛ ne gyae balaŋ baŋ bɛɛ gyae ŋon nɛ baageŋ bo na, ɛ na gyueŋ nyi ɛ ke nyiŋ kolo kpaakpaa lee Wurubuarɛ gyaŋ ya, nawolo nyi nombiakumɛɛyɛɛra mɔ koraŋ ne gyae baŋ bɛɛ gyae wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Akpaa ɛ yɛɛ deeli fa baŋ bɛɛ yɛɛ deeli fa ŋon nɛ baageŋ na, ɛ na gyueŋ nyi ɛ ke nyiŋ kolo kpaakpaa lee Wurubuarɛ gyaŋ ya. Nawolo nyi nombiakumɛɛyɛɛra mɔ koraŋ ne yɛɛ mena. ");
INSERT INTO ntr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te akpaa ɛ pakee abɔɔ fa balaŋ baŋ ɛ gyeŋ nyi baa nyiŋ tɔ ŋon na, ɛ na gyueŋ nyi ɛ ke nyiŋ kolo kpaakpaa lee Wurubuarɛ gyaŋ ya. Nawolo nyi nombiakumɛɛyɛɛra koraŋ ne pakee abɔɔ fa be tebia baŋ ba gyeŋ nyi baa nyiŋ pou tɔ wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mɔna ɛ gyae baŋ bɛɛ kɔla ŋon nɛ na ɛ ke yɛɛ deeli fa wɔ. Ɛ paa wɔ kolo na ɛ lese ɛ loo lee ke dɔɔ. Ɛ yɛɛ mena na, Wurubuarɛ waa tɔ ŋon kom nideli te ɛ ka bese Wurubuarɛ ŋon kpene kamasɛ doo ɔ tɛɛ nɛ bia. Nawolo nyi ɔ dana wɔe fa baŋ kolo bɛɛ gyoo be sia ya, na baŋ be dana nyeemandoŋ nɛ pou. ");
INSERT INTO ntr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ɛ wii balaŋ waraŋase ŋgba mena keŋ ɛ kya Wurubuarɛ ne wii balaŋ waraŋase nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ɛ na mo ɛ wose yɛɛ balaŋ nombiadiira na ɛ ke bu wɔ fɔɔ, na Wurubuarɛ mɔ be nyiŋ di ɛ nombia na waa bu ŋon fɔɔ ya. Ɛ mo balaŋ nombiakumɛɛ kyɛɛ wɔ, na Wurubuarɛ mɔ ka mo ɛ nombiakumɛɛ kyɛɛ ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ɛ yɛɛ deeli fa balaŋ na Wurubuarɛ mɔ ke yɛɛ deeli fa ŋon. Ɛ yɛɛ mena na, kpene keŋ Wurubuarɛ waa fa ŋon nɛ te yɛɛ nsendee ya. Waa nyiŋ konɔɔ maa ke nideli na ke wulu gba leki, na waa mo do ɛ nyiŋmaa man. Nawolo nyi mena keŋ ɛ ke maa fa ɛ tebia nɛ, mena ke te Wurubuarɛ mɔ waa maa fa ŋon.” ");
INSERT INTO ntr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Botɔɔ te Yesu gyɔɔ wɔ dudu kei nyiaa, “Siayɛlɛɛsate waa tale wola ɔ dɔɔ siayɛlɛɛsate gbɛɛ? Akpaa ɔ yɛɛ mena na, be balaŋ bala pou be gyae be kaa gyoo bɔɔ man yee? ");
INSERT INTO ntr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaseele bɛɛ kela ɔ gbeŋgyoo ya, mɔna kaseele kamasɛ ŋon ɔ kasee tom nideli nɛ waa yɛɛ ŋgba ɔ gbeŋgyoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Weera dɔɔ te n ne naa woŋsilibii keŋ doo n dɔɔ sibii man, te n be famenɛ na daakpee keŋ doo nyaŋ gbagba n sibii man ya? ");
INSERT INTO ntr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sena te n ke tale yako n dɔɔ nyi, ‘Me dɔɔ, yela maa lese woŋsilibii lee n sibii man,’ keŋ nyaŋ gbagba be famenɛ na daakpee keŋ doo n sibii man ya? Nyaŋ walaŋ ŋon n na beo n wose, kaboena nyi nya taŋgbɛɛ lese daakpee keŋ doo n sibii man nɛ, pɛna n kena nideli lese woŋsilibii keŋ doo n dɔɔ sibii man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Daŋ kpaakpaate kamasɛ bɛɛ se bia kumɛɛ ya, mena mɔ te daŋ kum bɛɛ se bia kpaakpaa ya. ");
INSERT INTO ntr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Daŋ kamasɛ nɛ, ke bia te bɛɛ mo gyeŋ ke. Bɔɔ ne kɔ akutu bia lee mango daŋ man ya, mena mɔ te bɔɔ ne kɔ apaŋ lee abotoo woŋse man ya. ");
INSERT INTO ntr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mena ke te denibalaŋ mɔ doo. Walaŋ kpaakpaate kamasɛ na lese abɔɔ kpaakpaa ŋan doo ɔ konɔɔ man nɛ wola, te walaŋkum kamasɛ mɔ na lese nombiakumɛɛ ŋan doo ɔ konɔɔ man nɛ wola. Kpene kamasɛ keŋ be wulu walaŋ konɔɔ man nɛ, keŋ na lee la ɔ nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Keŋte Yesu bɔɔse wɔ nyiaa, “Woŋ dɔɔ te ɛ ne baake maŋ nyi, ‘Ɛ Gbeŋgyoo,’ te ɛ bɛɛ yɛɛ kpene keŋ mɔɔ yako ŋon nyi yaa yɛɛ nɛ ya? ");
INSERT INTO ntr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Walaŋ kamasɛ ŋon ɔ ne kɔŋ me gyaŋ te ɔ ne nyii me nɔɔwoya te ɔ ne di ŋe dɔɔ nɛ, maa wola ŋon mena keŋ ɔ dinɔɔ doo. ");
INSERT INTO ntr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɔ yɛɛ ŋgba walaŋ ŋon ɔ ne ma deni te ɔ be wula bɔɔ te ɔ ba see ka mokɔɔ nideli boe dɔɔ nɛ. Keŋte boo wuuwɔ kaa mo ke dɔɔ mɔna ka te yale ya, nawolo nyi ɔ see ka mokɔɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mɔna walaŋ ŋon ɔ ne nyii me nɔɔwoya te ɔ bee di ŋe dɔɔ ya nɛ, ɔ yɛɛ ŋgba walaŋ ŋon ɔ be ma deni te ɔ ta see ka mokɔɔ nideli ya nɛ. Boo wuuwɔ kaa mo ke dɔɔ, te ke yalawɔ tekerii pou keŋ n be naa ka mokɔɔ gba ya.” ");
INSERT INTO ntr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu kekolosi nombia kɛŋa fa balaŋ baŋ taŋ nɛ, ɔ gyuu Kapanum donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Donɔɔ kenaŋ man na, Romantena yoonɔɔtena kegyia ŋolo kyaa na ɔ dana tobaale ŋolo ŋon ɔ bɛɛ sɛɛ ɔ dɔɔ ya. Te kawee kaa gyɔɔ mena tobaale kei yeŋ yeŋ. ");
INSERT INTO ntr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yoonɔɔtena kegyia kei ke nyii Yesu nkaŋ nɛ, ɔ kpila Gyudatena kegyiise baale gyu ɔ gyaŋ nyi waa kɔŋ kaa kyɔ ɔ tobaale ŋon fa e. ");
INSERT INTO ntr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Keŋte Gyudatena kegyiise baŋ kɔŋawɔ Yesu gyaŋ kaa waase e nideli nyiaa, “Yɛɛ kakyeŋ na n ke kyɔ balee kei fa daa, ");
INSERT INTO ntr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nawolo nyi ɔ ne gyae de tɛɛle kei deeli, te ŋon gba maana dɔ ɔsom deni fa daa.” ");
INSERT INTO ntr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mena dɔɔ Yesu sila wɔ gyu. Ɔ ka benaa yoonɔɔtena kegyia ŋon dɛɛ nɛ, ɔ kpila ɔ gyoona gyu keyako Yesu nyiaa, “Me Gbeŋgyoo, na haa n wose ya nawolo nyi ma tekaboena nyi nya kɔŋ me dɛɛ ya, ");
INSERT INTO ntr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","mena ke te ma gyeŋ nyi maŋ gbagba mɔ tekaboena nyi maa kɔŋ n gyaŋ ya. Mena dɔɔ nyaŋ yako nombii dokoloŋ bo, me tobaale ŋon waa koro. ");
INSERT INTO ntr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nawolo nyi maŋ gbagba mɔ yɛɛ walaŋ ŋon me doo baale tɛɛ, te yoonɔɔtena mɔ doo me tɛɛ. Me yako ŋolo nyi waa gyu yenaŋ daale na ɔ ne gyu, te me yako ŋolo nyi waa kɔŋ na ɔ ne kɔŋ. Kpene kamasɛ keŋ me yako be man ŋolo nyi waa yɛɛ na, keŋ te ɔ ne yɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ke nyii nɔɔwoya kɛŋa nɛ, doo ɔ nɔɔ te ɔ gɛɛsewɔ kɛɛ balaŋ dikpii keŋ be silana e nɛ te ɔ yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyiaa, Iserae tɛɛle kei dɔɔ pou nɛ ma te naa ta walaŋ ŋon ɔ ne lɛɛ Wurubuarɛ di ŋgba balee kei nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Keŋte yoonɔɔtena kegyia ŋon kpilala baŋ besewɔ gyu be dɛɛ. Be gyuuwɔ na ɔ tobaale ŋon ta koro. ");
INSERT INTO ntr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kei wɔle nɛ Yesu gyuu donɔɔ keŋ bɛɛ baake ke nyi Nai nɛ man. Ɔ kaseela baŋ na balaŋ burum sila e gyu botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesu ka betaa benaa donɔɔ keŋ nɔɔman nɛ, te ɔ naa ba seelena woo ŋolo bɛɛ kɔŋ be kaa wuu. Na woo ŋonaŋ waageŋ yɛna bu baale ŋon ɔ naa ba lolo te ɔ naa ŋon mɔ yɛɛ lialo e. Na donɔɔtena baŋ burum silana alo ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","De Gbeŋgyoo Yesu kena alo ŋon nɛ waraŋase kyaŋa e te ɔ yako e nyiaa, “Alo na wii ya.” ");
INSERT INTO ntr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Botɔɔ te Yesu gyuuwɔ ke tina woo ŋon, te baŋ ba seelena e nɛ seŋawɔ. Keŋte Yesu yakowɔ nyiaa, “Tobaale, koro.” ");
INSERT INTO ntr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Keŋte woo ŋon korowɔ kyaa te ɔ fiasɛɛ ɔ ne kolosi, te Yesu besena e fa ɔ naa. ");
INSERT INTO ntr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nombia kɛŋa yɛɛ walaŋ kamasɛ gyakoloŋ te ba lese Wurubuarɛ yele yako nyiaa, “Wurubuarɛ dekpeŋkpeŋgyɔɔre dinaa ŋolo te kaa bɛɛ lee de gyaŋ,” te ba besewɔ yako nyiaa “Wurubuarɛ te kɔŋ kaa kyɔ ɔ balaŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu wose man nombia kɛŋa yaaseewɔ Gyudia tɛɛle dɔɔ pou na tɛɛlese ŋan pou benaa na botɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gyɔn Wurubuarɛ loŋsɔɔre kaseela gyuuwɔ keyako e abɔɔ ŋan pou Yesu be yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Keŋte Gyɔn kpila ɔ kaseela bala baale nyi baa gyu ke bɔɔse de Gbeŋgyoo Yesu nyiaa, “Nyaŋ yɛna walaŋ ŋon Wurubuarɛ be yako see nyi nyaŋ kekɔŋ nɛ yaa dɛɛ kɛɛ walaŋ wɔle gbɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Gyɔn kaseela baŋ ke gyu Yesu gyaŋ nɛ be yako e nyiaa, “Gyɔn Wurubuarɛ loŋsɔɔre ŋon kpila na daa n gyaŋ nyi de kaa bɔɔse neŋ nyiaa, ‘Nyaŋ yɛna walaŋ ŋon Wurubuarɛ be yako see nyi nyaŋ kekɔŋ nɛ yaa dɛɛ kɛɛ walaŋ wɔle siaman?’ ” ");
INSERT INTO ntr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Debaŋ kenaŋ man na Yesu te kyɔ balaŋ burum kaweese lese wɔ lee be kayeyɛɛ man. Ɔ gegi feliŋkumɛɛ lee baale mɔ man, te ɔ kyɔɔ siayɛlɛɛsatena burum mɔ. ");
INSERT INTO ntr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mena dɔɔ Yesu tiranɔɔ fa Gyɔn kpilala baŋ nyiaa, “Ɛ bese gyu keyako Gyɔn kpene keŋ ɛ be naa na ɛ sia, na ŋan ɛ be nyii na ɛ deŋela. Siayɛlɛɛsatena ne naa, ɔtakasese ne tɛɛ, baŋ bɛɛ wee kawee yayam nɛ kaweese te taŋ, te deŋele atɔɔsatena ne nyii. Woya ne foŋii, te bɛɛ yako Wurubuarɛ nombia ŋan mɔ fa ayematena. ");
INSERT INTO ntr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Walaŋ kamasɛ ŋon ɔ bɛɛ lɛɛ maŋ aŋmaareŋ nyi maŋ yɛna ŋon Wurubuarɛ be kpili ya nɛ, ŋon na nyeebam.” ");
INSERT INTO ntr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gyɔn kpilala baŋ ka bese laŋ nɛ, Yesu kolosi Gyɔn wose man nombia fa balaŋ dikpii keŋ te ɔ bɔɔse wɔ nyiaa, “Ɛ ke gyu Gyɔn gyaŋ depampaa dinaa keŋ man nɛ, woŋ te ɛ gyaewɔ nyi ɛ kena? Ŋale keŋ feliŋ ne gyɔ ke wosi nɛ? ");
INSERT INTO ntr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Akpaa na keŋ ya na, woŋ te ɛ gyuuwɔ ɛ kaa kɛɛ? Walaŋ ŋon ɔ doona abɔɔ kpaakpaa nyiŋan yaa? Baŋ bee mia mena te bee di gyoŋ nɛ ne kyaa bo gyooneŋ akpaŋalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ɛ yako maŋ maa nyii, woŋ te nafɔ ɛ gyuuwɔ nyi ɛ kaa kɛɛ? Wurubuarɛ dekpeŋkpeŋgyɔɔre? Ampaŋ yaa mɛɛ yako ŋon nyi, ŋon ɛ be naa nɛ gba kela Wurubuarɛ dekpeŋkpeŋgyɔɔre. ");
INSERT INTO ntr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nawolo nyi Gyɔn yɛna Wurubuarɛ kpilale ŋon Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nyiaa, Wurubuarɛ kpa, ‘Mee kpila me kpilale keta n siaman, ŋon ne gyae la waa desina n gbɛɛ fa neŋ.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Keŋte Yesu besewɔ yako wɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, balaŋ baŋ bɔɔ lolo tɛɛle kei dɔɔ nɛ, ŋolo be kyaa keŋ nyi ɔ kela Gyɔn ya. Mɔna Wurubuarɛ gyoori keŋ man nɛ, walaŋ ŋon ɔ yɛɛ kamasɛ e koraŋ nɛ ɔ kela Gyɔn ŋonaŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Debaŋ keŋ balaŋ baŋ pou na lempoolɛɛra be nyii nombia kɛŋa nɛ, be lɛɛwɔ do nyi Wurubuarɛ gbɛɛneŋ tenɛɛ, nawolo nyi be sɛɛwɔ Gyɔn sɔɔ wɔ Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mɔna Farasiitena na Gyudatena mmaraa wolala baŋ bɛɛ kpene keŋ Wurubuarɛ ne gyae nyi waa yɛɛ fa wɔ nɛ, nawolo nyi be bɛɛwɔ nyi Gyɔn na sɔ wɔ Wurubuarɛ loŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Keŋte Yesu bɔɔsewɔ nyiaa, “Woŋ te maa mo gyɛŋ wee kei balaŋ maa na? Sena te be doo? ");
INSERT INTO ntr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Be yɛɛ ŋgba bia kyaa la kebu man bee yoi nɛ, na bɛɛ fae yeesa yako dɔŋa nyiaa, ‘De kpee alowɔle nɔɔneŋse fa ŋon, mɔna ɛ te sɔe ya! De kpee lia nɔɔneŋse mɔ, mɔna ɛ te wii ya!’ ");
INSERT INTO ntr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gyɔn Wurubuarɛ loŋsɔɔre ŋon kɔŋawɔ na ɔ ne kyaa bake ɔ nɔɔ keŋ ɔ te nyɔɔ soloŋ kamasɛ ya. Te ɛ kpa nyi, ‘Feliŋkumɛɛ doola ɔ man.’ ");
INSERT INTO ntr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Maŋ Deniwalaŋ Bu ŋon mɔ kɔŋawɔ mee dii mɛɛ nyɔɔ, te ɛ kpa nyi, ‘Ɛ kɛɛ balee kei! Ɔ yɛɛ kedikumte na soloŋnyɔɔre e. Ɔ gyoona yɛna lempoolɛɛra na nombiakumɛɛyɛɛra.’ ");
INSERT INTO ntr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mɔna baŋ bɔɔ lɛɛ Wurubuarɛ di nɛ, ta lese wola nyi Wurubuarɛ dana nyansa nideli.” ");
INSERT INTO ntr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wee daale nɛ Farasii baale ŋolo baake Yesu nyi waa kɔŋ ɔ dɛɛ na ŋon na e ke di bom. Yesu sɛɛwɔ te ɔ gyuuwɔ ke kyaa bee dii. ");
INSERT INTO ntr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na alo ŋolo kyaa donɔɔ kenaŋ man keŋ ɔ yɛɛ futooli alo e. Ɔ kenyii nyi Yesu kyaa Farasii baale ŋon dɛɛ ɔ ne dii nɛ, ɔ moo nuŋ ofoŋofoŋte daale porontia tɔɔ kɔŋ botɔɔ, ");
INSERT INTO ntr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","keŋte ɔ kaa seŋawɔ Yesu wɔle benaa na ɔ nawɔɔ. Keŋte ɔ wii siasaraŋ woli Yesu nawɔɔ. Te ɔ moo ɔ nyeenyɔɔse feefo Yesu nawɔɔ ŋenaŋ te ɔ kyaŋa ŋa obuo man, te ɔ toosi nuŋ ofoŋofoŋte keŋ woli ŋa. ");
INSERT INTO ntr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farasii baale ŋon ɔ be baake Yesu gyu ɔ dɛɛ kena mena nɛ, ɔ yakowɔ ɔ nyeeman nyiaa, “Akpaa balee kei deŋ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre gbagba e na, nafɔ waa gyeŋ alo ŋon ɔ ne tina e nɛ dinɔɔ. Nawolo nyi ɔ yɛɛ dukumyɛɛre e.” ");
INSERT INTO ntr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Keŋte Yesu tiranɔɔ fa e nyiaa, “Simɔn, me dana kolo maa yako neŋ.” Keŋte ɔ yako e nyiaa, “De Gbeŋgyoo, yako maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Botɔɔ te Yesu gyɔɔ e dudu kei nyiaa, “Balaŋ bala baale kyaawɔ te be gyuuwɔ ke paa kɔba lee kɔbate ŋolo gyaŋ. Ŋolo wui yɛɛ kɔbabia kakpoŋ yaale, te ŋolo mɔ wui yɛɛ sɔŋola na kufu. ");
INSERT INTO ntr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Be man kamasɛ bɛɛ tale waa tɔ ɔ kom ya, mena dɔɔ balee ŋon moo ba koma ŋan pou kyɛɛ wɔ. Yako maŋ! Balaŋ bala kɛwɔ na, be man woŋti ne gyae la waa gyae kɔbate ŋon nombia nideli?” ");
INSERT INTO ntr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Keŋte Simɔn tiranɔɔ nyiaa, “Mɛɛ lɛɛdi nyi ŋon ɔ kom boe nɛ.” Te Yesu yako e nyiaa, “N tiranɔɔ nideli.” ");
INSERT INTO ntr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Botɔɔ te Yesu besena ɔ sia tee alo ŋon te ɔ yako Simɔn nyiaa, “N naa alo kei? Me kɔŋa n dɛɛ na n te fa maŋ loŋ maa faafo me nawɔɔ ya. Mɔna alo kei dɔɔ ŋon ta mo ɔ siasaraŋ faafo me nawɔɔ te ɔ moo ɔ nyeenyɔɔse feefo ŋa. ");
INSERT INTO ntr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","N te pukaa maŋ ya, mɔna lee debaŋ keŋ mɔɔ kɔŋ kɛbo nɛ, alo kei te tinaa ta me nawɔɔ ke pukaa yela ya. ");
INSERT INTO ntr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","N ta mo nuŋ paŋpaŋ gba tiu ma nyee ya, mɔna alo kei dɔɔ ŋon kyɛɛkee nuŋ woli me nawɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mena dɔɔ mɛɛ yako neŋ n ke nyii nyi ɔ nombiakumɛɛ ŋan pou ɔ be yɛɛ nɛ, Wurubuarɛ ta mo ŋa kyɛɛ e, mena dɔɔ te ɔ ne gyae me nombia nideli. Nyaŋ ŋon ŋolo da mo n dukum kyomii kyɛɛ neŋ na, n ne gyae ɔtenate nombia bo kyomii.” ");
INSERT INTO ntr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Botɔɔ te Yesu yako alo ŋon nyiaa, “Wurubuarɛ ta mo n nombiakumɛɛ kyɛɛ neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Keŋte balaŋ baŋ be kyaa botɔɔ bee dii nɛ bɔɔse dɔŋa nyiaa, “Amɔte yɛna kei, ŋon ɔ na mo nombiakumɛɛ kyɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Botɔɔ te Yesu yako alo ŋon nyiaa, “N kelɛɛdi te yeli n te nyiŋ nyeedoŋ kekpaa, ta wosefɛɛreŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kedi weeya ala nɛ Yesu gyuuwɔ ke kila donɔɔse na akuraase pou man, na ɔ ne yako Wurubuarɛ gyoori keŋ wose man nombia kpaakpaa ŋan fa balaŋ, na ɔ kaseela kufu bala baŋ mɔ silana e. ");
INSERT INTO ntr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na ala baale baŋ ɔ be kyɔ wɔ be kaweese te ɔ be gegi feliŋkumɛɛ lee be baale man nɛ mɔ kpuɛ na e. Be man baale yɛna Mɛɛre ŋon bɛɛ baake e nyi Magedala, ŋon Yesu be gegi feliŋkumɛɛ nyetooro lee ɔ man nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Gyoana ŋon ɔ baale yɛna Kusa nɛ. Kusa kei yɛɛ kegyia ŋolo e gyoo Herode dekpaŋalaŋ man, na Susana na ala burum baŋ bɔɔ mo ba abɔɔ kɛɛ Yesu na ɔ kaseela dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Debaŋ keŋ balaŋ burum kpu na baŋ bɔɔ lee debiise man kɔŋ be kaa yilaa Yesu gyaŋ nɛ, ɔ gyɔɔ dudu fa wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wɔɔfarale ŋolo gyuuwɔ ke ŋmatee abɔɔ bia ŋgba amɔla nɛ ɔ wɔɔman. Ɔ kɛɛ ŋmatee ŋa nɛ ŋaale yalawɔ wɔɔ keŋ gbɛɛneŋ man te balaŋ tɛɛwɔ ŋe dɔɔ sakatee ŋa laŋ, te gyebuse kaa tɔɔsee ŋa di. ");
INSERT INTO ntr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ŋaale mɔ yalawɔ kpanaŋse dɔɔ te ŋe tuuwɔ, mɔna te kyare ya te ŋa yekeewɔ. Nawolo nyi tɛɛle ta boo kpanaŋse ŋan dɔɔ na ke lɛɛ loŋ see ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bia ŋan ŋaale mɔ yalawɔ kpalamse man te ŋe tuuwɔ, te kpalamse ŋan mɔ tuuwɔ milii ŋa. ");
INSERT INTO ntr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ŋaale mɔ yalawɔ tɛɛle kpaakpaa dɔɔ te ŋe tuuwɔ bee, te ŋa see bia burum.” Botɔɔ te Yesu yako wɔ nyiaa, “Ŋon ɔ dana deŋele waa nyii na, waa tei nideli.” ");
INSERT INTO ntr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Keŋte Yesu kaseela baŋ yako e nyi waa wola wɔ dudu keŋ asɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Te Yesu yako wɔ nyiaa, “Ɛmɛɛ dɔɔ Wurubuarɛ ta toro ya agyueŋse na ɛ ka gyeŋ nombia ŋan weesɛɛ lee ɔ gyoori keŋ wose man. Mɔna balaŋ akaŋ baŋ dɔɔ aduya kaageŋ man te maa kolosi fa wɔ. ‘Baa kɛo na baa kɛo mɔna bɔɔ gyae baa naa ya, te baa tei na baa tei mɔna bɔɔ gyae baa nyii asɛɛ ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Keŋte Yesu yako wɔ nyiaa, dudu keŋ mɔɔ gyɔɔ nɛ ka asɛɛ yaa. “Abɔɔ bia ŋan seŋɛɛ fa Wurubuarɛ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bia ŋan be yale gbɛɛnaa man nɛ, seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan te ɔbɔnsam ne kɔŋ kaa ŋmɛɛle ŋa lee be konɔɔse man, na bɔɔ nyiŋ lɛɛ ŋa di na Wurubuarɛ ke lɛɛ ba nyee ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bia ŋan be yale kpanaŋse dɔɔ nɛ seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan te bɛɛ lɛɛ ŋa na gyoŋ, mɔna ŋe bee nyiŋ lila be man ya. Bɛɛ lɛɛ ŋa di debaŋ kyomii bo, te akpaa ɔbɔnsam de kɛɛse wɔ kɛɛ na ba te yale. ");
INSERT INTO ntr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bia ŋan be yale kpalamse man nɛ seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan, te tɛɛle kei dɔɔ nombia, na kɔba kegyae beiŋ, na tɛɛle kei dɔɔ abɔɔ akaŋ ŋan kegyae da gyoo be man nɛ, na bee yeli baa bee Kristo man ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Abɔɔ bia ŋan be yale tɛɛle kpaakpaa dɔɔ nɛ seŋɛɛ fa balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan, te bɛɛ lɛɛ ŋa do konɔɔ kpaakpaa man, te bɛɛ tela ŋa nideli te bɛɛ yɛɛ kakyeŋ di ŋe dɔɔ kelii debaŋ keŋ nombia ŋan ne yeli bɛɛ yɛɛ abɔɔ kpaakpaa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu besewɔ gyɔ dudu fa wɔ nyiaa, “Ŋolo bɛɛ kyaŋee kanea na waa mo kolo wu ke dɔɔ yaa waa mo ke do mpa ateta ya. Mɔna ɔ na mo ke bo gyakaa kolo dɔɔ adido na kena dekpaŋalaŋ pou, na baŋ bɛɛ kɔŋ na baa nyiŋ naa. ");
INSERT INTO ntr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kolo ba weesɛɛ keŋ be gyae ka lee debɔɔ ya, te kolo mɔ be wuɛ keŋ nyi be gyae ka lee debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mena dɔɔ ɛ kɛɛ ɛ wose nideli lee mena keŋ ɛ na mo tei nombia ŋan. Nawolo nyi nyaŋ ŋon n dana kolo na Wurubuarɛ waa kpu neŋ burum, te nyaŋ ŋon n be dana kolo ya na kyomii keŋ n na gyueŋ nyi n dana koraŋ nɛ, Wurubuarɛ waa lɛo ke lee n nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu ɔ naa na ɔ naabia kɔŋawɔ ɔ gyaŋ, mɔna balaŋ dikpii keŋ dɔɔ be te nyiŋ baa benaa e ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Botɔɔ te ŋolo yako Yesu nyiaa, “N naa na n naabia seŋɛɛ debɔɔ man bɛɛ gyae baa naa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Keŋte Yesu yako wɔ nyiaa, “Me naa na me naabia yɛna baŋ bee nyii Wurubuarɛ nombia ŋan te bee di ŋe dɔɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wee daale nɛ Yesu yako ɔ kaseela baŋ nyiaa, “Ɛ yela dɛɛ toŋ gyu boo keŋ diŋgyiŋ.” Mena dɔɔ ba gyoowɔ degbele man te be laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Debaŋ keŋ be kyaa degbele keŋ man bee gyu nɛ te dosoroŋ moo Yesu. Keŋte feliŋ dinaa daale korowɔ ne gyɔɔ loŋ keŋ dɔɔ, mena dɔɔ ke gyɔɔ loŋ do degbele keŋ man te Yesu kaseela baŋ sia yɛɛ wɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mena dɔɔ Yesu kaseela baŋ gyuuwɔ ke gyuusu e yako e nyiaa, “De Gbeŋgyoo, de Gbeŋgyoo dɛɛ gyae dee munu.” Botɔɔ te Yesu korowɔ te ɔ fae feliŋ keŋ na loŋ keŋ pou te ŋe yɛɛwɔ yididi. ");
INSERT INTO ntr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Keŋte Yesu bɔɔse ɔ kaseela baŋ nyiaa, “Weera dɔɔ te ɛ bɛɛ lɛɛ maŋ di ya?” Gyakoloŋ kyaŋa wɔ te ba wose yeŋa wɔ te be bɔɔse dɔŋa nyiaa, “Walaŋ woŋti yɛna kei? Ɔ ne kolosi fa feliŋ na loŋ koraŋ na ŋee nyii e.” ");
INSERT INTO ntr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Keŋte Yesu na ɔ kaseela baŋ toŋawɔ gyu Gerasenetena tɛɛle man keŋ kyaa Galelia boo diŋgyiŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu ka betaa lee degbele keŋ man pɛ, te baale ŋolo ŋon feliŋkumɛɛ doo ɔ man nɛ leewɔ donɔɔ keŋ man kɔŋ kaa gyaŋee na e. Ɔ te tɛɛ diteŋteli kyare te ɔ bɛɛ kyaa dɛɛ ya. Ɔ kyae amuseese man. ");
INSERT INTO ntr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Debaŋ keŋ ɔ be naa Yesu nɛ ɔ fae yeesa te ɔ leewɔ yala ɔ nawɔɔ tɛɛ, na ɔ ne fae yeesa keŋkeŋ nyiaa, “Yesu Wurubuarɛ Adidote Bu, woŋ te n ne gyae me gyaŋ? Mɛɛ waase neŋ bo, na naase maŋ diyem ya.” ");
INSERT INTO ntr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nawolo nyi na Yesu taŋ ke fae feliŋkum keŋ nyi ke dɛɛ lee ɔ man. Debaŋ kamasɛ na feliŋkum keŋ ne naase e diyem, na ba te kyaŋ e bake e agbaraagbaraase ɔ nyiŋmaase na ɔ nawɔɔ man na balaŋ ne gyee e. Keŋ koraŋ na ɔ ne tirii ŋa, na feliŋkum keŋ ta mo e gyu kefula man. ");
INSERT INTO ntr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Keŋte Yesu bɔɔse e nyiaa, “N yele yɛna sena?” Te balee ŋon tiranɔɔ nyi ma yele yɛna “Dikpii” Ɔ tiranɔɔ mena nawolo nyi feliŋkumɛɛ burum doo ɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Botɔɔ te feliŋkumɛɛ ŋan waase Yesu nyi, ɔ na gegi wɔ ka do bɔɔ keŋ betaŋ ɔto ya nɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Debaŋ kenaŋ na kekuiriise dikpii daale seŋɛɛ bula daale dɔɔ bee dii. Keŋte feliŋkumɛɛ ŋan waase Yesu nyi waa yela be kaa gyoo kekuiriise baŋ man, te Yesu faa wɔ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mena dɔɔ feliŋkumɛɛ ŋan leewɔ balee ŋon man ka gyoo kekuiriise baŋ man, te ba dikpii keŋ pou yeuwɔ tisi bula kyoloŋkyoloŋ keŋ gyu ka gyoo loŋ keŋ man te be munuwɔ pou. ");
INSERT INTO ntr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Balaŋ baŋ bɛɛ kɛɛ kekuiriise baŋ dɔɔ kena kpene keŋ be kɔŋ nɛ, ba korowɔ yeu gyu ke yako kpene keŋ be kɔŋ nɛ fa balaŋ baŋ be kyaa donɔɔ keŋ man nɛ na akuraase ŋan man pou. ");
INSERT INTO ntr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Keŋte balaŋ yeuwɔ gyu be kaa kɛɛ kpene keŋ be kɔŋ nɛ. Ba ke kɔŋ Yesu gyaŋ nɛ, be naa walaŋ ŋon nafɔ feliŋkumɛɛ doo ɔ man nɛ baŋɛɛ Yesu nawɔɔ tɛɛ, na ɔ wose te fɛɛ e keŋ ɔ doona abɔɔ. Te gyakoloŋ gyoo balaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Balaŋ baŋ bɔɔ naa kpene keŋ be kɔŋ nɛ yako baŋ bɔɔ kɔŋ nɛ mena keŋ Yesu be kyɔ balee ŋon kawee. ");
INSERT INTO ntr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Keŋte balaŋ baŋ pou be kyaa Gerasene tɛɛle dɔɔ nɛ waase Yesu nyi waa lee be gyaŋ nawolo nyi gyakoloŋ dinaa ta gyoo wɔ. Mena dɔɔ Yesu gyoowɔ degbele keŋ man te ɔ laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Walaŋ ŋon Yesu be gegi feliŋkumɛɛ lee ɔ man nɛ waase Yesu nyi waa sila e. Mɔna Yesu bɛɛwɔ te ɔ yako e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bese gyu n dɛɛ, na n kaa yako kpene keŋ Wurubuarɛ be yɛɛ fa neŋ nɛ fa balaŋ.” Mena dɔɔ balee ŋon gyuuwɔ donɔɔ keŋ man ke yako balaŋ pou kpene keŋ Yesu be yɛɛ fa e nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu ka bese lee boo keŋ diŋgyiŋ kɔŋ nɛ, balaŋ burum kɔŋawɔ kaa gyaŋee na e. Nawolo nyi na be popou ne kɛɛ ɔ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Botɔɔ te balee ŋolo ŋon bɛɛ baake nyi Gyariose, ŋon ɔ yɛɛ Gyudatena ɔsom deni man kegyia e nɛ kɔŋawɔ kaa buŋ Yesu nawɔɔ tɛɛ sola e nyi waa kɔŋ ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nawolo nyi ɔ bu alebu dokoloŋ kooŋ ŋon ɔ be di kulutooneŋ kufu ala nɛ ne gyae waa yeŋ. Yesu kee gyuu keŋ nɛ na balaŋ baŋ be silana e te yɛɛ nsendee ya, mena dɔɔ na ɔ bee nyiŋ gbɛɛ gba waa besena ɔ wose ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na alo ŋolo kpuɛ balaŋ burum baŋ be silana Yesu nɛ man keŋ fatabo ne gyɔ e kulutooneŋ kufu ala yaa, mɔna ŋolo te tale kyɔ e ya. ");
INSERT INTO ntr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Alo ŋon moowɔ balaŋ baŋ man ka lee Yesu wɔle te ɔ tinaa ɔ kegba nɔɔbii. Debokenaŋ man te fatabo keŋ ne gyɔ e nɛ karawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Botɔɔ te Yesu bɔɔsewɔ nyiaa, “Amɔte tinaa na maŋ?” Balaŋ baŋ pou kebɛɛ nyi be te tina e ya nɛ te Pita yako e nyiaa, “De Gbeŋgyoo, balaŋ burum ke kilisi neŋ gyaŋee te bɛɛ tɛɛse dɔŋa kei na, n ne bɔɔse nyi amɔte tinaa na neŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mɔna Yesu yakowɔ nyiaa, “Ŋolo te tina maŋ. Nawolo nyi ma te naa nyi doŋ daale ta lee me man.” ");
INSERT INTO ntr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Alo ŋon kena nyi ɔ be gyae waa tale weese ɔ wose ya nɛ, ɔ moo gyakoloŋ na wose keseree kaa buŋ Yesu nawɔɔ tɛɛ. Botɔɔ te ɔ yako kpene keŋ dɔɔ ɔ be tina Yesu kegba, na mena keŋ ɔ kawee keŋ be taŋ debokenaŋ man nɛ balaŋ baŋ pou siaman. ");
INSERT INTO ntr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Keŋte Yesu yako alo ŋon nyiaa, “Me bu, n kelɛɛ maŋ di dɔɔ te n nyiŋa kawee kekyɔ. Ta wosefɛɛreŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ke gyakaa ɔ ne kolosi nɛ, walaŋ ŋolo lee Gyudatena ɔsom deni man kegyia Gyariose ŋon dɛɛ kaa yako e nyiaa, “N bu alebu ŋon ta yem. Na tekaa naase de Gbeŋgyoo ŋon diyem bela ya.” ");
INSERT INTO ntr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu ke nyii nombia kɛŋa nɛ ɔ yako Gyariose nyiaa, “Na yee ya, nyaŋ lɛɛ maŋ di. N bu ŋon waa nyiŋ nyeedoŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu ke gyu ka gyoo Gyariose dɛɛ nɛ, ɔ te yeli ŋolo ke sila e gyoo deni keŋ man ya. Pita na Gyɔn na Gyemisi na bu ŋon ɔ kya na ɔ naa baageŋ te ɔ moowɔ sila ɔ wose. ");
INSERT INTO ntr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na balaŋ baŋ bɔɔ yilaa botɔɔ nɛ pou ne wii na bee di walaŋsa. Botɔɔ te Yesu yako wɔ nyiaa, “Ɛ na wii ya, alebu kei ta yeŋa ta ya, ɔ doo dosoroŋ bo.” ");
INSERT INTO ntr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Keŋte balaŋ baŋ pou boŋo Yesu, nawolo nyi ba gyeŋ nyi bu ŋon ta yem. ");
INSERT INTO ntr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Keŋte Yesu kyaŋa alebu ŋon nyiŋmaa man te ɔ yakowɔ nyiaa, “Me bu! Koro seŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Botɔɔ te bu ŋon woo besewɔ kɔŋ kaa gyoo ɔ man te ɔ korowɔ seŋ debokenaŋ man. Keŋte Yesu yako wɔ nyi baa gyae kolo fa bu ŋon na waa di. ");
INSERT INTO ntr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gyakoloŋ gyoo bu ŋon ɔ kya na ɔ naa, te Yesu tɔɔ wɔ nideli nyi be na yako walaŋ na walaŋ kpene keŋ be kɔŋ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wee daale Yesu baake ɔ kaseela kufu bala baŋ gyaŋee, te ɔ faa wɔ doŋ nyi baa mo di feliŋkumɛɛ dɔɔ na baa kyɔ kaweese. ");
INSERT INTO ntr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Keŋte ɔ kpila wɔ nyi baa gyu ke yako Wurubuarɛ gyoori keŋ wose man nombia na baa kyɔ kaweesetena. ");
INSERT INTO ntr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Botɔɔ te ɔ yako wɔ nyiaa, “Ɛ ne gyu na ɛ na mo kolo na kolo tela ya. Ɛ na mo gbutu yaa akpo yaa weenɛɛ, yaa kɔba, yaa kegba alate gba tela ya. ");
INSERT INTO ntr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dekpaŋalaŋ kamasɛ keŋ man ɛ soo te be lɛɛ ŋon atuu na, ɛ kyaa botɔɔ kaboena ɛ ka mo lee donɔɔ kenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Donɔɔ keŋ man ɛ gyu te ba te lɛɛ ŋon ya na, ɛ na lee ke man na ɛ kpiisi ɛ nawɔɔ aŋasa lɔ wɔ na ke di adansɛɛ tia wɔ nyi Wurubuarɛ be gyae waa tina wɔ yela ya.” ");
INSERT INTO ntr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mena dɔɔ Yesu kaseela baŋ korowɔ gyu akuraa kamasɛ man, na be dɔŋ bɛɛ yako Wurubuarɛ nombia ŋan te be kyɔɔ balaŋ kaweese yenaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galeliatena Gyoo dinaa Herode ke nyii abɔɔ ŋan pou Yesu be yɛɛ nɛ ŋe haa e ɔ konɔɔ man, nawolo nyi balaŋ baale ne yako nyi, “Gyɔn Wurubuarɛ loŋsɔɔre ŋon ɔ ba yem nɛ foŋala lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Baale mɔ kpa Wurubuarɛ dekpeŋkpeŋgyɔɔre Elia bɛɛ la lee, te baale mɔ kpa Wurubuarɛ akpeŋkpeŋgyɔɔra benɛɛ baŋ maŋ ŋolo foŋala lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Botɔɔ te gyoo Herode yakowɔ nyiaa, “Ma te yela ba te kara Gyɔn nyee, te walaŋ woŋti yɛna ŋon mee nyii ɔ wose man gyakoloŋ nombia kɛŋa nɛ?” Mena dɔɔ ɔ yase ɔ sia gyae gbɛɛ keŋ waa mo naa Yesu. ");
INSERT INTO ntr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Debaŋ keŋ kpilala kufu bala baŋ ba bese kɔŋ nɛ, be yako Yesu kpene kamasɛ keŋ bɔɔ yɛɛ nɛ. Keŋte Yesu baake wɔ te ŋon na wɔ gyuu donɔɔ keŋ bɛɛ baake ke nyi Bɛtesaida nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Balaŋ dikpii keŋ kenyii nyi ɔ te lam botɔɔ nɛ be sila ɔ gbɛɛ. Be ke gyu kena nɛ ɔ lɛɛ wɔ atuu te ɔ kolosi Wurubuarɛ gyoori keŋ wose man nombia fa wɔ, te ɔ kyɔɔ baŋ be hia kawee kekyɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ke lii balinɔɔ weese nɛ, Yesu kpilala kufu bala baŋ kɔŋawɔ ɔ gyaŋ kaa yako e nyiaa, “Yela balaŋ baŋ keta na baa gyu akuraase na donɔɔse ŋan benaa nɛ man, na be kaa gyae weenɛɛ na adoise, nawolo nyi kɛbo kei yɛɛ ŋale nsana keŋ kolo be kyaa ya.” ");
INSERT INTO ntr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mɔna Yesu yako wɔ nyiaa, “Ɛmɛɛ gbagba ɛ fa wɔ kolo baa di.” Botɔɔ te be tiranɔɔ nyi, “Ŋan pou de dana yɛna bodobodose abiliŋ anoŋ na kpebia bala. Yaa n ne gyae nyi dee gyu ke lɛɛ weenɛɛ kɔna balaŋ dikpii kei pou?” ");
INSERT INTO ntr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na baala baŋ baageŋ baa yɛɛ ŋgba balaŋ kakpoŋse banoŋ (5000)nɛ. Keŋte Yesu yako ɔ kpilala baŋ nyiaa, “Ɛ yela balaŋ baŋ ke kyaa dikpii, dikpii. Dikpii kamasɛ dɛɛ yɛɛ balaŋ sɔŋola na kufu (50).” ");
INSERT INTO ntr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Keŋte kpilala baŋ yela balaŋ baŋ pou kyakeewɔ ŋgba mena keŋ Yesu be yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Botɔɔ te Yesu moo bodobodose abiliŋ anoŋ ŋan na kpebia bala baŋ te ɔ gyinaa ɔ nyee adido, te ɔ fanewɔ do Wurubuarɛ nɔɔ te ɔ kɛrɛɛ ŋa te ɔ moo ŋa fa ɔ kpilala baŋ nyi baa mo kpɛlɛɛ balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Balaŋ baŋ pou diiwɔ baa, te be tɔɔsee weenɛɛ buruburu akaŋ ŋan na be nyiŋa doŋase kufu ala (12). ");
INSERT INTO ntr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wee daale Yesu kɛɛ fane waageŋ nɛ ɔ kaseela baŋ gyuuwɔ ke kpu na e te ɔ bɔɔse wɔ nyiaa, “Balaŋ ne kolosi ma wose man nombia na be kpa maŋ yɛna amɔ?” ");
INSERT INTO ntr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Keŋte ɔ kaseela baŋ tiranɔɔ nyiaa, “Balaŋ baale kpa nyaŋ yɛna Gyɔn Wurubuarɛ loŋsɔɔre ŋon. Baale mɔ kpa nyaŋ yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre Elia, te baale mɔ kpa Wurubuarɛ akpeŋkpeŋgyɔɔra benɛɛ baŋ man ŋolo foŋala.” ");
INSERT INTO ntr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Ɛmɛɛ mɔ de? Ɛ kpa maŋ yɛna amɔ?” Te Pita tiranɔɔ nyiaa, “Nyaŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Botɔɔ te Yesu tɔɔ wɔ nideli nyi be na yako nombii kei fa walaŋ na walaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Keŋte ɔ besewɔ yako wɔ nyiaa, “Kaboena nyi maŋ Deniwalaŋ Bu maa naa diyem nideli. Gyudatena kegyiise na Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ baa bɛɛ maŋ. Baa ko maŋ, te weeya atoorote keŋ man na, Wurubuarɛ waa gyuusu maŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Keŋte Yesu yako be popou nyiaa, “Akpaa ŋolo ne gyae waa sila maŋ na ɔ na yɛɛ kpene keŋ ŋon gbagba ne gyae ya, mɔna waa mo ɔ ɔpaŋdaŋ seele na waa sila maŋ wee kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nawolo nyi walaŋ kamasɛ ŋon ɔ ne gyae waa lɛɛ ŋon gbagba nyeedoŋ na, ke gyae ka lee ɔ nyiŋmaa man. Mɔna walaŋ kamasɛ ŋon ɔ nyeedoŋ da lee ɔ nyiŋmaa man lee maŋ Yesu dɔɔ nɛ waa bese nyiŋ ke. ");
INSERT INTO ntr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Akpaa ŋolo de nyiŋ tɛɛle kei dɔɔ abɔɔ pou te ɔ nyeedoŋ da lee ɔ nyiŋmaa man na, woŋ tɔnɔɔ te waa nyiŋ? ");
INSERT INTO ntr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Akpaa maŋ Yesu na me nombia de yɛɛ ŋolo desɛŋ tɛɛle kei dɔɔ nɛ, kenaŋ na wee keŋ maŋ Deniwalaŋ Bu ŋon maa bese kɔŋ daa na me kya Wurubuarɛ na Wurubuarɛ kpilala baŋ gyoorobiiri man nɛ, walaŋ ŋonaŋ mɔ nombia gyae ke yɛɛ maŋ desɛŋ. ");
INSERT INTO ntr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ampaŋ yaa mɛɛ yako ŋon nyi ɛ man baale kyaa kɛbo kei keŋ bɔɔ gyae baa yeŋ ya, kelii debaŋ keŋ baa naa Wurubuarɛ gyoorobiiri keŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu keyako nombia kɛŋa weeya gyanaara wɔle nɛ, ɔ moo Pita na Gyemisi na Gyɔn sila ɔ wose gyu bula dɔɔ ɔ kaa fane. ");
INSERT INTO ntr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ɔ kɛɛ fane nɛ, karatetee dokoloŋ te ɔ sia gbɛɛ kyɛɛkeewɔ te wa abɔɔ ŋan ɔ doona nɛ bese abɔɔ wolomɛɛ futututu na ŋɛɛ ŋalakee nɛ polɛpolɛpolɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Debokenaŋ man te baala bala baale kaa bɛɛwɔ lee Yesu dɔɔ te be kolosiwɔ na e. Balaŋ bala kɛwɔ yɛna Mosesi na Elia. ");
INSERT INTO ntr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Be kɔŋawɔ gyoorobiiri man kaa yako Yesu mena keŋ waa yeŋ Gyerusalɛm donɔɔ man, ŋgba mena keŋ Wurubuarɛ be bake see nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mena debaŋ kenaŋ na Pita na ɔ tebia baŋ bɔɔ sila Yesu gyu nɛ te doo dosoroŋ. Ba ke foŋii nɛ, be naa Yesu gyoorobiiri man na baala bala seŋɛɛ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Baala bala baŋ ka lee Yesu gyaŋ bee gyu nɛ te Pita yako Yesu nyiaa, “De Gbeŋgyoo, dei ŋgba daa mɔ be kɔŋ kɛbo nɛ. Yela dɛɛ baŋ kefɛɛse atooro kɛbo. N wui daale, Mosesi wui daale, te Elia mɔ wui daale.” Mɔna ɔ ba gyeŋ kpene keŋ ɔ ne yako nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita kɛɛ kolosi keŋ nɛ te ŋɔma kaa wuuwɔ be dɔɔ, keŋte gyakoloŋ kyaŋa kaseela baŋ ŋgba ŋɔma ŋan be kaa wuu be dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Botɔɔ te be nyii nɔɔwoya ŋaale lee ŋɔma ŋan man nyiaa, “Kei yɛna me bu ŋon mɔɔ lese e, ɛ nyii e.” ");
INSERT INTO ntr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nɔɔwoya ŋan kekolosi taŋ nɛ, be kɛɛ na Yesu waageŋ seŋɛɛ la te kaseela baŋ wuu be nɔɔ. Ba te yako walaŋ kamasɛ kpene keŋ bɔɔ naa weeya ŋenaŋ man nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tɛɛ kena keŋ bɔɔ lee bula keŋ dɔɔ bɛɛ kɔŋ nɛ, balaŋ burum kɔŋawɔ kaa gyaŋee na Yesu, ");
INSERT INTO ntr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","botɔɔ te balee ŋolo fae yeesa lee balaŋ burum baŋ man nyiaa, “De Gbeŋgyoo, mɛɛ waase neŋ kɛɛ me bu fa maŋ, nawolo nyi ŋon waageŋ yɛna me bu. ");
INSERT INTO ntr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Feliŋkum ne kyaa ɔ dɔɔ na ɔ te peti fae yeesa na te fuŋ e ŋmera na ɔ nɔɔ ne tɔ afofose. Ne yɛɛ doŋ pɛte kɛɛ koro ɔ dɔɔ, mɔna ke gyakaa kɛɛ wɔlɛɛ e. ");
INSERT INTO ntr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Me waase n kaseela baŋ nyi baa gegi feliŋkum keŋ, mɔna ba te tale ya.” ");
INSERT INTO ntr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Botɔɔ te Yesu tiranɔɔ nyiaa, “Ao! Ɛ mɛɛ gyɛŋ balaŋ baŋ ɛ bɛɛ lɛɛ maŋ di ya te ɛ gbɛɛneŋ ba tenɛɛ ya. Weeya aŋmoŋ te kaboena nyi maa kyaa ɛ gyaŋ na maa nyiŋ konɔɔ fa ŋon?” Keŋte ɔ yako balee ŋon nyi, “Mo n bu ŋon kɔna maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bu ŋon kɛɛ kɔŋ nɛ, feliŋkum keŋ doo ɔ man nɛ kara e lɔ na ne wɔŋee e tokii. Mɔna Yesu fae feliŋkum keŋ te ɔ kyɔɔ bu ŋon kawee te ɔ besena e fa ɔ kya. ");
INSERT INTO ntr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Balaŋ baŋ wose yeŋa wɔ lee Wurubuarɛ doŋ dinaa keŋ bɔɔ naa nɛ dɔɔ. Nombia ŋan Yesu be yɛɛ nɛ doo balaŋ baŋ nɔɔ te be ka seŋ bɛɛ gyueŋ ŋe man nɛ ɔ yako ɔ kaseela baŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ɛ nyii nombia ŋan mɛɛ gyae maa yako ŋon nɛ nideli. Baa lese maŋ Deniwalaŋ Bu ŋon do balaŋ nyiŋmaa man.” ");
INSERT INTO ntr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mɔna ɔ kaseela baŋ te nyii kpene keŋ ɔ ne yako wɔ nɛ man ya. Nawolo nyi Wurubuarɛ ta lese wola wɔ na baa nyii asɛɛ ya, mɔna bee yee nyi baa bɔɔse e nombii kenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Keŋte aŋmaareŋ gyoo Yesu kaseela baŋ man nyi be man woŋti kela na ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Na Yesu gyeŋ kpene keŋ bɛɛ gyueŋ nɛ te ɔ kyaŋa biikyaabii ŋolo kaa seŋ ɔ yenaŋ, ");
INSERT INTO ntr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","keŋte ɔ yako wɔ nyiaa, “Walaŋ ŋon ɔ lɛɛ biikyaabii kei ma yele man na ɔ te lɛɛ maŋ, te ŋon ɔ lɛɛ maŋ na ɔ te lɛɛ ŋon ɔ be kpila maŋ nɛ. Nawolo nyi walaŋ ŋon ɛ bɛɛ mo e yɛɛ kolo ɛ man ya nɛ, ŋon kela na ɛ popou.” ");
INSERT INTO ntr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Botɔɔ te Gyɔn yako Yesu nyiaa, “De Gbeŋgyoo, de naa balee ŋolo na ɔ ne gegi feliŋkumɛɛ lee n yele man te de tɔɔ e, nawolo nyi ɔ be kpuɛ de man ya.” ");
INSERT INTO ntr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Keŋte Yesu tiranɔɔ fa e nyiaa, “Ɛ na tɔ e gbɛɛ ya, nawolo nyi ŋon ɔ bee yoo na ŋon ya nɛ, na ɔ seŋɛɛ ɛ wɔle.” ");
INSERT INTO ntr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Weeya ŋan Wurubuarɛ waa mo Yesu gyu adido kɛɛ benaa nɛ, ɔ yɛɛ wa gyueŋ nyi waa gyu Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Keŋte ɔ kpila ɔ kaseela baale nyi baa kyaŋ gbɛɛ gyu Samaria donɔɔ daale man na be kaa desina botɔɔ see e. ");
INSERT INTO ntr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mɔna balaŋ baŋ be kyaa botɔɔ nɛ bɛe nyi bɔɔ lɛɛ e ya, nawolo nyi na ɔ sia gyakae nyi ɔ ne gyu Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ɔ kaseela Gyemisi na Gyɔn kena mena nɛ be bɔɔse e nyiaa, “De Gbeŋgyoo, n ne gyae dɛɛ baake boalaŋ lee adido na kaa kpa wɔ wɔlɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Botɔɔ te Yesu besenawɔ kɛɛ wɔ te ɔ faree wɔ nyi be naa yɛɛ mena ya. ");
INSERT INTO ntr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Keŋte be popou gbaawɔ gyu akuraa wɔle man. ");
INSERT INTO ntr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ba ke ta bee gyu keŋ nɛ, walaŋ ŋolo kɔŋawɔ kaa yako Yesu nyiaa, “Yenaŋ kamasɛ keŋ n ke gyu nɛ maa sila neŋ gyu.” ");
INSERT INTO ntr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Botɔɔ te Yesu yako e nyiaa, “Nyanyase dana bɔɔneŋ te gyebuse mɔ dana asaase, mɔna Deniwalaŋ Bu ŋon betaŋ botɔɔ keŋ waa mo ɔ nyee teeli ya.” ");
INSERT INTO ntr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Walaŋ wɔle ŋolo mɔ kɔŋawɔ Yesu gyaŋ te Yesu yako e nyi, “Sila maŋ.” Mɔna walaŋ ŋon yako e nyiaa, “Me Gbeŋgyoo, yela maa taŋgbɛɛ gyu kewuu me kya pɛna me kaa sila neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Keŋte Yesu tiranɔɔ fa e nyiaa, “Yela woya kewuu ba woya, mɔna nyaŋ dɔɔ gyu na n kaa kolosi Wurubuarɛ gyoori keŋ wose man nombia.” ");
INSERT INTO ntr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ŋolo mɔ yako Yesu nyiaa, “Me Gbeŋgyoo maa sila neŋ, mɔna yela maa gyu kekalaa ma loŋtona pɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Keŋte Yesu yako e nyiaa, “Nyaŋ walaŋ ŋon n buŋɛɛ fare dɔɔ te n ne gɛɛse kɛɛ n wɔle nɛ, n tekaboena Wurubuarɛ gyoori keŋ man ka gyoo ya.” ");
INSERT INTO ntr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kei wɔle nɛ de Gbeŋgyoo lese baala sɔŋotooro na kufu bala (72) te ɔ kpila wɔ bala bala nyi, baa kyaŋ gbɛɛ gyu donɔɔse na yenaase ŋan pou man ŋon gbagba ne gyae waa gyu nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Keŋte Yesu yako wɔ nyiaa, “Wɔɔman weenɛɛ ŋan boe na ke tekerii, mɔna balaŋ baŋ baa tekerii nɛ ta boo ya. Mena dɔɔ ɛ waase wɔɔte ŋon na waa kpila balaŋ burum kɔŋ wɔɔ keŋ man na be kaa tekerii. ");
INSERT INTO ntr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ɛ ta! Mee kpila ŋon baa ŋgba namensebia ne gyuula gbougbouse man nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ɛ ne gyu na ɛ na mo kɔba yaa akpo yaa nkyokota ya. Te ɛ na wɔlɛɛ debaŋ na balaŋ nɔɔ kado gbɛɛnaa man ya. ");
INSERT INTO ntr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dekpaŋalaŋ kamasɛ keŋ man ɛ gyoo na, ɛ taŋgbɛɛ yako dekpaŋalaŋmantena baŋ nyi, ‘Wosefɛɛreŋ dɛɛkɔŋ dekpaŋalaŋ kei man.’ ");
INSERT INTO ntr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akpaa walaŋ ŋon ɔ ne gyae wosefɛɛreŋ kyaa dekpaŋalaŋ kenaŋ man na, ɛ wosefɛɛreŋ gyae ke kyaa na e. Te akpaa walaŋ ŋon ɔ ne gyae wosefɛɛreŋ be kyaa botɔɔ ya na, ɛ wosefɛɛreŋ keŋ gyae ka bese kɔŋ ɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nyi be lɛɛ ŋon na ɛ kyaa dekpaŋalaŋ kenaŋ man na ɛ ke di na ɛ ke nyɔɔ kpene kamasɛ keŋ baa fa ŋon nɛ, nawolo nyi kaboena nyi baa tɔ tomyɛɛre kamasɛ kom. Ɛ na tɛɛ na akpaŋalaŋ yakaa yakaa ya. ");
INSERT INTO ntr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Akpaa ɛ gyu donɔɔ daale man te be lɛɛ ŋon atuu na, ɛ di kpene kamasɛ keŋ balaŋ baŋ baa fa ŋon nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ɛ kyɔ kaweesetena kawee donɔɔ kenaŋ man, na ɛ keyako donɔɔsetena benaŋ nyi, ‘Wurubuarɛ gyoori keŋ ta benaa ŋon taŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mɔna donɔɔ keŋ man ɛ gyu te ba te lɛɛ ŋon ya nɛ, ɛ gyu ka abɔnterese ŋan man na ɛ ke yako nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ɛ donɔɔ aŋasa ŋan be mataa de nawɔɔ koraŋ nɛ, de te kpiisi ŋa woli ɛ nyeeya nsana. Mɔna ɛ tɔɔse nyi Wurubuarɛ gyoori keŋ ta benaa taŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mɛɛ yako ŋon na ɛ ke nyii nyi wee keŋ Wurubuarɛ waa kɔŋ kaa di balaŋ nombia nɛ, waa wii Sodomtena waraŋase koraŋ kela mena donɔɔ kenaŋ man balaŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin na Bɛtesaida donɔɔsetena! Mɛɛ fa ŋon laako. Nawolo nyi gyakoloŋ nombia ŋan Wurubuarɛ be yɛɛ ɛ gyaŋ nɛ, nyi akpaa beŋ yɛɛ ŋa Tae na Sidɔn donɔɔse man nɛ nafɔ beŋ te wulaa do titere abɔɔ kyaa mo tɔŋ buraa ba wose, na kawola nyi ba te kyɛɛkee ba agyueŋ lee be gbɛɛneŋ kumɛɛ man kɔŋ Wurubuarɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mɔna wee keŋ Wurubuarɛ waa kaa di balaŋ nombia nɛ, waa wii Taetena na Sidɔntena waraŋase kela ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te nɛnɛɛ ɛmɛɛ Kapanumtena! Ɛ gyeŋ nyi baa gyina ŋon adido gyu Wurubuarɛ gyaŋ? Koa, baa tisina ŋon ateta ateta kɔŋ botɔɔ keŋ ɛ kena diyem kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Walaŋ ŋon ɔ nyii ŋon na maŋ yaa ɔ nyiiwɔ, te ŋon ɔ bɛɛ ŋon na maŋ yaa ɔ bɛɛwɔ. Te ŋon ɔ bɛɛ maŋ na ɔ te bɛɛ ŋon ɔ be kpila maŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Te kyare ya te balaŋ sɔŋotooro na kufu bala baŋ Yesu be kpila wɔ nɛ besewɔ kɔŋ. Na te yɛɛ wɔ gyoŋ nideli te be yako e nyiaa, “De Gbeŋgyoo, lee n yele man dɔɔ feliŋkumɛɛ gba ne nyii daa.” ");
INSERT INTO ntr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Me naa ɔbɔnsam lee adido kaa yala ŋgba ɔga ŋmaalela nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ɛ nyii, ma te fa ŋon doŋ nyi yaa mo sakatee doma na kanase dɔɔ na ɛ ke di ɛ kɔlare ŋon doŋ dɔɔ, te kolo be gyae ke tale yɛɛ ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɛ na yela keyɛɛ ŋon gyoŋ nyi feliŋkumɛɛ ne nyii ŋon ya, mɔna ɛ yela keyɛɛ ŋon gyoŋ nyi ba te ŋmarase ɛ yela adido.” ");
INSERT INTO ntr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Debaŋ kenaŋ man te Wurubuarɛ feliŋ ŋon yela gyoŋ kaa gyoowɔ Yesu man nideli te ɔ yakowɔ nyiaa, “Me kya adido na ateta pou Gbeŋgyoo! Mɛɛ fa neŋ karaŋ nawolo nyi n ta mo abɔɔ kɛŋa weese nyansatena na baŋ ba gyeŋ nombia nɛ, te n lese ŋa wola baŋ be dinɔɔ yɛɛ ŋgba bia nɛ. Taata, ma gyeŋ nyi kei yɛna nyaŋ gbagba n kegyaebii.” ");
INSERT INTO ntr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Botɔɔ te Yesu yako balaŋ baŋ nyiaa, “Me kya ta mo kpene kamasɛ do maŋ me nyiŋmaa man. Ŋolo ba gyeŋ maŋ ɔ Bu ŋon ya, me kya waageŋ kooŋ gyeŋa na maŋ. Ŋolo mɔ ba gyeŋ kya ŋon ya, maŋ ɔ Bu ŋon na baŋ maa lese me kya ŋon wola wɔ nɛ daageŋ ne gyae la dɛɛ gyeŋ e.” ");
INSERT INTO ntr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Keŋte Yesu besenawɔ kɛɛ ɔ kaseela baŋ te ɔ yako wɔ nyiaa, “Ɛ te yɛɛ nyeebam ŋgba ɛ ne naa mena abɔɔ ŋan ɛ ne naa nɛ! ");
INSERT INTO ntr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mɛɛ yako ŋon ɛ ke nyii nyiaa, Wurubuarɛ akpeŋkpeŋgyɔɔra na gyooneŋ gyaewɔ baa naa kpene keŋ ɛ ne naa nɛ mɔna ba te naa ya, te be gyaewɔ baa nyii kpene keŋ ɛ ne nyii nɛ mɔna be te nyii ya.” ");
INSERT INTO ntr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wee daale nɛ Gyudatena mmaraa wolale ŋolo kɔŋawɔ ɔ kaa teese Yesu nɔɔman te ɔ bɔɔse e nyiaa, “De Gbeŋgyoo, woŋ te maa yɛɛ na maa nyiŋ nyeedoŋ kekpaa keŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Botɔɔ te Yesu bɔɔse e nyi, “Woŋ te be ŋmarasewɔ do Wurubuarɛ mmaraa tɔne keŋ man? Sena te ɛ ne nyii mmaraase ŋan man?” ");
INSERT INTO ntr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Keŋte balee ŋon tiranɔɔ nyiaa, “Be ŋmarasewɔ nyi mo n konɔɔ pou na n wose pou na n doŋ pou na nya agyueŋ pou gyae n Gbeŋgyoo Wurubuarɛ, na n ke gyae n dɔɔ ŋgba nyaŋ gbagba n wose nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Keŋte Yesu yako e nyiaa, “N tiranɔɔ nideli, yɛɛ ŋgba mena keŋ n be yako nɛ na n ke nyiŋ nyeedoŋ kekpaa keŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mɔna keŋ mmaraa wolale ŋon ne gyae waa wola nyi ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman dɔɔ nɛ, ɔ bɔɔse Yesu nyi, “Amɔte yɛna me dɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Botɔɔ te Yesu gyɔɔ dudu daale tiranɔɔ fa e nyiaa, “Wee daale balee ŋolo lee Gyerusalɛm donɔɔ man tisi ɔ ne gyu Gyeriko donɔɔ man. Keŋte ɔ gyuuwɔ kegyaŋee na ŋmɛɛlatena, te be lɛo ɔ kpene kamasɛ te be tuku e yeŋ yeŋ, te be tinaa e yela diteŋteli. ");
INSERT INTO ntr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te kɔŋawɔ nyi Wurubuarɛ Sae ŋolo tisiwɔ mo gbɛɛ kenaŋ ɔ ne gyu. Ɔ kena balee ŋon doo nɛ ɔ kpasewɔ mo yenaŋ laŋ. ");
INSERT INTO ntr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mena mɔ te Lewi baale ŋolo mɔ kɔŋawɔ kaa mo botɔɔ te ɔ kena balee ŋon doo nɛ, ŋon mɔ kpasewɔ mo yenaŋ laŋ. ");
INSERT INTO ntr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mɔna Samaria baale ŋolo ŋon ɔ ne gyu ɔ gbɛɛ nɛ, kaa leewɔ balee ŋon dɔɔ. Ɔ kena e keŋ nɛ ɔ tɔɔ nyakee e, te waraŋase kyaŋa e fa balee ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔ tuuwɔ benaa e te ɔ doo e tee ɔ gyamɛɛ ŋan man te ɔ bake ŋa. Botɔɔ te ɔ moo balee ŋon gyakaa ŋon gbagba ɔ wonembu ŋon ɔ kyaa nɛ dɔɔ, te ɔ moo e gyu ŋɔɔla dɛɛsoe keŋ man nyi baa kɛɛ ɔ dɔɔ fa e. ");
INSERT INTO ntr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tɛɛ kena nɛ, ɔ lese kɔba fa kegyia ŋon ɔ ne kɛɛ ŋɔɔla dɛɛsoe keŋ dɔɔ nɛ te ɔ yako e nyiaa, ‘Kɛɛ balee kei dɔɔ fa maŋ. Ma bese kɔŋ na me kaa tɔ neŋ kom kamasɛ keŋ n be wɔlɛɛ ɔ dɔɔ nɛ kpu.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Keŋte Yesu bɔɔse balee ŋon nyiaa, “Nya agyueŋ man na, balaŋ batooro kɛwɔ man woŋti yɛna balee ŋon ŋmɛɛlatena be tuku e nɛ ɔ dɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Keŋte mmaraa wolale ŋon tiranɔɔ nyiaa, “Walaŋ ŋon ɔ be wii ɔ waraŋase nɛ.” Botɔɔ te Yesu yako e nyiaa, “Nyaŋ mɔ gyu na n kaa yɛɛ wɔe mena.” ");
INSERT INTO ntr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na ɔ kaseela kegyakaa be gbɛɛ dɔɔ bee gyu nɛ, ɔ keliiwɔ akuraa daale man te alo ŋon bɛɛ baake e nyi Maata nɛ moo e gyu ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na Maata dana naabu ŋolo ŋon bɛɛ baake e nyi Mɛɛre. Keŋte Mɛɛre kɔŋawɔ kaa kyaa de Gbeŋgyoo Yesu gyaŋ ɔ ne nyii Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maata kɛɛ ka ɔ wose na ŋɔɔla baŋ kedi man nɛ, ɔ kɔŋawɔ kaa bɔɔse Yesu nyiaa, “De Gbeŋgyoo, n be famenɛ ŋgba me naabu be tina maŋ yela maageŋ yee? Yako e nyi waa kɔŋ kaa kyɔ maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Keŋte de Gbeŋgyoo Yesu tiranɔɔ fa e nyiaa, “Maata, Maata, n ne naase n wose diyem abɔɔ burum dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","mɔna kolo dokoloŋ ne hia la keŋ kaboena nyi nya yɛɛ. Mena kolo kpaakpaa kenaŋ yaa Mɛɛre moowɔ, te bɔɔ gyae baa lɛo ke lee ɔ nyiŋmaa man ya.” ");
INSERT INTO ntr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wee daale Yesu gyuu yenaŋ daale ɔ ne fane. Ɔ kefane taŋ nɛ, ɔ kaseela baŋ man ŋolo yako e nyiaa, “De Gbeŋgyoo, wola daa mena keŋ dɛɛ fane ŋgba mena keŋ Gyɔn ba wola ɔ kaseela nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Keŋte Yesu yako wɔ nyiaa, “Ɛ ne gyae ɛ ke fane na ɛ yako nyiaa, ‘De kya, dɛɛ fane nyi balaŋ pou baa lese n yele Lese n gyoori debɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fa daa wee kamasɛ weenɛɛ ŋan ne hia daa nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mo de nombiakumɛɛ kyɛɛ daa, 3 nawolo nyi daa mɔ na mo kyɛɛ balaŋ baŋ bɛɛ yɛɛ nombiakumɛɛ tia daa nɛ. Na yeli dɛɛ yala kekɛɛsekɛɛ man ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu besewɔ yako ɔ kaseela baŋ nyiaa, “Ɛ yela dɛɛ mo ke nyi n dana gyoo, te n gyu ɔ dɛɛ tɛɛ nsana ke gyɔ ɔ disim yako e nyi ‘Me gyoo, waaseda paa maŋ weenɛɛ kyomii. ");
INSERT INTO ntr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nawolo nyi me gyoo ŋolo ta lee gbɛɛ kɔŋ me gyaŋ, te mɔɔ dana kolo na kolo maa fa e ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na n gyoo ŋon te tiranɔɔ deni tɔɔman nyi, ‘Na haa maŋ ya, me taŋ ketɔ me disim te daa na me bia mɔ taŋ kedoo. Mɔɔ gyae maa tale koro kaa fa neŋ kolo ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Keŋte Yesu yako wɔ nyiaa, “Akpaa nyi ŋon na e gyoori kaageŋ wui dɔɔ nɛ nafɔ ɔ be gyae waa koro ya. Mɔna mena keŋ ɔ ne gyɔ disim keŋ kakyekyemaare man dɔɔ nɛ, waa koro toro na waa fa e kpene keŋ ɔ ne gyae nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mena dɔɔ mɛɛ yako ŋon baa nyi ɛ sola Wurubuarɛ kolo na, ɛ nyiŋmaa gyae ke kaŋ ke. Ɛ kɛo kolo lee ɔ gyaŋ na ɛ ke nyiŋ ke, te ɛ gyɔ e disim mɔ na waa toro fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nawolo nyi walaŋ kamasɛ ŋon ɔ bɔɔse e kolo na ɔ nyiŋmaa ne kaŋ ke, te ŋon ɔ gyae kolo lee ɔ gyaŋ na ɔ ne nyiŋ ke, te ŋon mɔ ɔ gyɔ e disim na waa toro fa e. ");
INSERT INTO ntr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Lolala, ɛ man woŋti kyaa la keŋ nyi ɔ bu da sola e kpebii na, waa mo dom fa e? ");
INSERT INTO ntr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yaa ɔ sola e wɔe na, waa mo kana fa e? ");
INSERT INTO ntr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akpaa ɛmɛɛ baŋ ɛ yɛɛ nombiakumɛɛyɛɛrawɔ koraŋ gyeŋ abɔɔ kpaakpaa ka mo fa ɛ bia na, de yaa sena te ɛ kya ŋon ɔ kyaa adido nɛ, ba mo ɔ feliŋ do baŋ bɛɛ sola e nɛ man nideli ya?” ");
INSERT INTO ntr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wee daale Yesu gberaa feliŋkum keŋ ne yeli walaŋ bɛɛ tale kolosi ya nɛ lee balee ŋolo man. Feliŋkum keŋ ka lee nɛ, balee ŋon kolosiwɔ te doo balaŋ dikpii keŋ be kyaa botɔɔ nɛ pou nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Keŋte balaŋ baŋ baale yakowɔ nyiaa, “Feliŋkumɛɛ pou gyoo Bɛlisɛbu faa na balee kei doŋ te ɔ ne tale gegi feliŋkumɛɛ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Keŋ baale mɔ ne gyae baa teese Yesu nɔɔman dɔɔ be yako e nyi waa yɛɛ gyakoloŋ nombia, na kawola nyi ɔ lee Wurubuarɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mɔna Yesu gyeŋ kpene keŋ bɛɛ gyueŋ nɛ te ɔ yako wɔ nyiaa, “Tɛɛle kamasɛ keŋ ke man balaŋ de kpase ba wose kpookpoo bee yoo na dɔŋa na, tɛɛle kenaŋ be gyae ke de ya. Mena mɔ te dekpaŋalaŋ daale man balaŋ de kpase ba wose kpookpoo bee yoo na dɔŋa na, dekpaŋalaŋ kenaŋ ne yɛlɛɛ bo. ");
INSERT INTO ntr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Akpaa nyi ɔbɔnsam gyoori keŋ man balaŋ de kpase ba wose kpookpoo bee yoo na dɔŋa nɛ, sena te ɔ gyoori keŋ gyae ke tale seŋ? Keŋ dɔɔ mɛɛ yako kei yɛna nyi, ɛmɛɛ kpa feliŋkumɛɛ pou gyoo Bɛlisɛbu faa na maŋ doŋ te mɛɛ mo gegi feliŋkumɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Akpaa nyi Bɛlisɛbu doŋ te mɛɛ mo gegi feliŋkumɛɛ na, amɔte doŋ yaa ɛ silala baŋ na mo gegi feliŋkumɛɛ? Ɛmɛɛ gbagba ɛ silala ne gyae la baa bu ŋon fɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te akpaa Wurubuarɛ doŋ te mɛɛ mo gegi feliŋkumɛɛ na, kenaŋ na ɛ wulaa gyeŋ nyi Wurubuarɛ gyoori keŋ taŋ kekɔŋ ɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Akpaa doŋte ŋolo de desina ɔ wose mo yoo abɔɔ ɔ na deke ɔ dɛɛ nɛ, ŋolo be tale kaa mo ɔ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mɔna akpaa walaŋ ŋon ɔ dana doŋ kela e de kɔŋ kaa yokii na e te ɔ di ɔ dɔɔ nɛ, ɔ ne lɛo ɔ yoo abɔɔ ŋan ɔ na mo ɔ wose lɔ ŋe dɔɔ nɛ pou, na ɔ te kuu wa abɔɔ pou ke kpɛlɛɛ balaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Walaŋ kamasɛ ŋon ɔ be kpuɛ na maŋ ya nɛ na ɔ ne kɔla maŋ, te walaŋ kamasɛ ŋon mɔ ɔ bɛɛ kyɔ maŋ na dee yilaa balaŋ fa Wurubuarɛ ya nɛ, ɔ ne yaasee wɔ bo.” ");
INSERT INTO ntr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Keŋte Yesu yako wɔ nyiaa, “Feliŋkum da lee walaŋ man nɛ, ɔ ne tɛɛ kila kɛo tɛɛle awolɛɛ ɔ ne gyae dekyae. Akpaa ɔ te nyiŋ dekyae ya na ɔ ne yako ɔ wose nyiaa, ‘Maa bese gyu ma dekyae bene keŋ mɔɔ lee nɛ man.’ ");
INSERT INTO ntr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Akpaa ɔ kɔŋ kaa naa nyi ba te gbee botɔɔ desina ke nideli keŋ nyi ayimɛɛ kamasɛ be doo ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ɔ na bese gyu ka mo feliŋkumɛɛ nyetooro ŋan ŋe dana nombiakumɛɛ kela e nɛ kpu na ɔ wose na be kaa kyaa walaŋ ŋonaŋ man. Dekɔŋ mena na, walaŋ ŋonaŋ dinɔɔ na bese wɔlɛɛ kela ɔ kekyaa gyaŋgba keŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu kɛɛ kolosi nombia kɛŋa nɛ, alo ŋolo gyinaa ɔ nɔɔ balaŋ baŋ man yako nyiaa, “Alo ŋon ɔ ba lola neŋ te ɔ be kɛɛle neŋ nɛ, ŋon na nyeebam.” ");
INSERT INTO ntr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Keŋte Yesu tiranɔɔ nyiaa, “Balaŋ baŋ bee nyii Wurubuarɛ nombia ŋan te bee di ŋe dɔɔ nɛ, baŋ gba te kaboena nyi be sia dɛɛ gye.” ");
INSERT INTO ntr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Balaŋ baŋ ke kɔŋ kaa wuku nɛ Yesu besewɔ yako nyiaa, “Gyɛŋ wee kei balaŋ yɛɛ nombiakumɛɛyɛɛrawɔ. Bɛɛ gyae bo nyi baa naa gyakoloŋ nombia, mɔna mɔɔ gyae maa yɛɛ gyakoloŋ nombia kpu na ŋan be kɔŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyona dɔɔ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mena keŋ Gyona nombia ŋan ba bese kolo kekasee fa Niniwetena nɛ, mena mɔ te maŋ Deniwalaŋ Bu ŋon mɔ me nombia gyae ka bese kolo kekasee fa gyɛŋ wee kei balaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wee keŋ Wurubuarɛ waa kɔŋ ɔ kaa di balaŋ nombia nɛ, Seba gyoo ŋon ɔ yɛɛ alo e te ɔ ba lee ata yenaŋ nɛ, waa koro seŋ na waa bu gyɛŋ wee kei balaŋ fɔɔ. Nawolo nyi ɔ ke nyii Solomɔn nyansa nombia ŋan nɛ, ɔ tɛɛwɔ leenaŋ tɛɛle ɔto kɔŋ kaa nyii ŋa. Mɛɛ yako ŋon baa nyi walaŋ ŋon ɔ kela gyoo Solomɔn ŋonaŋ kyaa kɛbo mɔna ɛ bee nyii e ya. ");
INSERT INTO ntr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mena mɔ te wee keŋ Wurubuarɛ waa kɔŋ ɔ kaa di balaŋ nombia nɛ, Niniwetena baa koro seŋ na baa bu gyɛŋ wee kei balaŋ fɔɔ. Nawolo nyi debaŋ keŋ Gyona be kolosi Wurubuarɛ nombia ŋan fa wɔ nɛ, be kyɛɛkeewɔ lee be gbɛɛneŋ kumɛɛ man te be kɔŋawɔ Wurubuarɛ gyaŋ. Mɛɛ yako ŋon baa nyi walaŋ ŋon ɔ kela Gyona ŋonaŋ nɛ kyaa kɛbo.” ");
INSERT INTO ntr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Keŋte Yesu besewɔ yako wɔ nyiaa “Ŋolo bɛɛ kyaŋee kanea na waa mo ke weese yaa waa mo kolo wu ke ya. Mɔna ɔ na mo ke bo gyakaa kolo dɔɔ adido na balaŋ baŋ bɛɛ kɔŋ dekpaŋalaŋ keŋ man nɛ ke nyiŋ naa. ");
INSERT INTO ntr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Deniwalaŋ kanea yɛna ɔ sia. N sia ne naa na n wose pou yɛɛ keŋmaŋee ke, mɔna n sia de wɔlɛɛ na n wose pou doo ditiŋtɛɛ tuum man. ");
INSERT INTO ntr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mena dɔɔ ɛ kɛɛ nideli nyi keŋmaŋee keŋ doo ɛ man nɛ ba bese ditiŋtɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nyi akpaa n wose pou doo keŋmaŋee man te ka yenaŋ daale be doo ditiŋtɛɛ man ya na, kenaŋ na n wose pou gyae ke ŋalakee ŋgba mena keŋ kanea ne ŋalakee nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu kekolosi taŋ nɛ Farasii baale ŋolo baake e gyu ɔ dɛɛ ɔ kaa di, mena dɔɔ ɔ gyuuwɔ kekyaa weenɛɛ ŋan tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farasii baale ŋon kena nyi Yesu te faafo ɔ nyiŋmaase ŋgba mena keŋ ba beneŋ mmaraa nawolo ya nɛ, doo ɔ nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Keŋte de Gbeŋgyoo Yesu yako e nyiaa, “Ɛmɛɛ Farasiitena ne faafo ɛ leenɔɔse na ɛ nyefalɛɛ wɔle bo, mɔna ŋe man dana ayimɛɛ. Mena te ɛmɛɛ mɔ konɔɔse man doo, ɛ dana sibii te nombiakumɛɛ mɔ te wulu ɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɛmɛɛ ayiŋtena; Ɛ ba gyeŋ nyi Wurubuarɛ ŋon ɔ be yɛɛ kolo wɔle nɛ, ŋon yɛna ke tɔɔman mɔ yee? ");
INSERT INTO ntr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mena dɔɔ ɛ yɛɛ deeli fa ayematena, na kawola nyi ɛ wose betaŋ ayimɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ɛmɛɛ Farasiitena ɛ laako! Nawolo nyi ɛ na mo ɛ wɔɔman abɔɔ buruburu gba kufu man dekpeŋ dokoloŋ fa Wurubuarɛ, mɔna ɛ bee di nombia na ŋe gbɛɛ ya te ɛ bɛɛ mo Wurubuarɛ mɔ yɛɛ kolo ya. Kaboena nyi nafɔ yaa yɛɛ mena abɔɔ kɛŋa pou, na ɛ ka bese fa ɛ wɔɔman abɔɔ buruburu ŋan kufu man dekpeŋ dokoloŋ bela kpu. ");
INSERT INTO ntr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ɛmɛɛ Farasiitena ɛ laako! Nawolo nyi ɛ ne gyae akyaese kpaakpaa Gyudatena ɔsom denɛɛ man, te ɛ ne gyae mɔ nyi ɛ lii balaŋ man na balaŋ dee buŋ do ŋon nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ɛ laako! Nawolo nyi ɛ yɛɛ ŋgba yebɔɔse ŋan ba yoo te balaŋ ne tɛɛ ŋe dɔɔ keŋ bɔɔ gyeŋ nyi ŋe yɛɛ yebɔɔse ŋa ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Botɔɔ te mmaraa wolala baŋ man ŋolo bɔɔse e nyiaa, “De Gbeŋgyoo, nya ayakoŋ kɛŋa nɛ ŋgba n tee daa mɔ baa.” ");
INSERT INTO ntr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Keŋte Yesu tiranɔɔ fa e nyiaa, “Ɛmɛɛ mmaraa wolala mɔ ɛ laako! Nawolo nyi ɛ ne bake kasolɔse ŋan kela balaŋ nɛ yere wɔ, mɔna ɛmɛɛ gbagba bɛɛ yɛɛ kolo kyomii kyɔ wɔ na baa tale seele be kasolɔse ŋenaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ɛ laako! Nawolo nyi ɛ ne desina Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ yebɔɔse, mɔna ɛmɛɛ gbagba ɛ naanaɔ koona wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mena dɔɔ kei nawolo baa nyiaa, ɛmɛɛ gbagba te lɛɛ nombia ŋan ɛ naanaɔ be yɛɛ nɛ do. Nawolo nyi ɛ naanaɔ koona Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ, te ɛmɛɛ mɔ kɔŋawɔ ɛ ne desina ba yebɔɔse. ");
INSERT INTO ntr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kei dɔɔ te Wurubuarɛ nyansate ŋon kolosiwɔ nyiaa, ‘Maa kpila ma akpeŋkpeŋgyɔɔra na me kpilala be gyaŋ. Baa ko be man baale, na baa naase be man baale mɔ diyem.’ ");
INSERT INTO ntr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ bɔɔ koo lee debaŋ keŋ Wurubuarɛ be yɛɛ tɛɛle kei nɛ, ka deŋele kewɔŋ gyae ke kɔŋ ɛmɛɛ gyɛŋ balaŋ kɛwɔ dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","lee Abɛle kako man kelii Sakaria dɔɔ. Sakaria kei te ba koowɔ Wurubuarɛ kedeesa boe keŋ, na Wurubuarɛ ɔsom deni dinaa keŋ nsana nsana nɛ. Mɛɛ yako ŋon ɛ ke nyii nyiaa, kɛŋa pou deŋele kewɔŋ gyae ke kɔŋ ɛmɛɛ gyɛŋ balaŋ kɛwɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ɛmɛɛ mmaraa wolala ɛ laako! Ɛ ta mo Wurubuarɛ kagyeŋ gbɛɛ weese balaŋ te ɛmɛɛ gbagba mɔ bɛɛ tɛɛ gbɛɛ kenaŋ dɔɔ ya, te ɛ ne tɔ baŋ bɛɛ gyae baa ta gbɛɛ kenaŋ dɔɔ mɔ nɛ gbɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu ka lee botɔɔ nɛ, mmaraa wolala na Farasiitena baŋ moo nombia gyu ke tuŋ e baŋ man te be bɔɔse e nombia burum, ");
INSERT INTO ntr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mo teese ɔ nɔɔman na baa nyiŋ kyaŋ e. ");
INSERT INTO ntr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Debaŋ kenaŋ man nɛ, balaŋ burum kɔŋawɔ kaa yilaa keŋ nae daseŋae be doo ya. Keŋte Yesu fiasɛɛ ɔ ne yako ɔ kaseela baŋ nyiaa, “Ɛ kɛɛ ɛ wose man nideli na Farasiitena dinɔɔ keŋ ke yɛɛ ŋgba tee keŋ bɛɛ mo do kolo man te ne wuku nɛ. Nawolo nyi bɛɛ yɛɛ ba wose ŋgba be yɛɛ balaŋ kpaakpaawɔ nɛ mɔna bɛɛ beo bo. ");
INSERT INTO ntr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Te kolo be kyaa keŋ bɔɔ wu ke dɔɔ keŋ nyi bɔɔ gyae baa gyuusu ke ya, te nombia aweeseŋ ŋaale mɔ be kyaa keŋ be gyae ka lee debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mena dɔɔ nombii kamasɛ keŋ ɛ be yako ke ditiŋtɛɛ man nɛ gyae ka lee debɔɔ, te nombii kamasɛ keŋ ɛ be kolosi adadawoya man do ŋolo deŋele man deni tɔɔman nɛ, baa mo ke gyɔ dekpeŋkpeŋ. ");
INSERT INTO ntr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Me tebia mɛɛ yako ŋon baa nyi ɛ na yee balaŋ baŋ bɛɛ ko wosenaane kaageŋ bo, mɔna bɔɔ tale yɛɛ kolo kpu bela nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mɛɛ gyae maa wola ŋon walaŋ ŋon kaboena nyi yaa yee. Ɛ yee Wurubuarɛ ŋon ɔ ko walaŋ na, ɔ dana doŋ nyi waa fuŋ ɔ woo ka do boalaŋ keŋ bɛɛ yem ya nɛ man. Ampaŋ yaa mɛɛ yako ŋon nyiaa, ŋon yɛna walaŋ ŋon kaboena nyi yaa yee. ");
INSERT INTO ntr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Akpelee koya yɛɛ aŋmoŋ? Na kaperɛ ala te bɛɛ yɔɔ akpeleese banoŋ yee? Mɔna Wurubuarɛ bee wolee be man dokoloŋ koraŋ gba ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɛ nyeenyɔɔse koraŋ nɛ, Wurubuarɛ gyeŋ ŋe yaanɔɔle. Mena dɔɔ ɛ na yee ya, nawolo nyi ɛ dana tɔnɔɔ kela akpeleese burum.” ");
INSERT INTO ntr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Keŋte Yesu kpa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ kamasɛ ŋon ɔ lɛɛ maŋ do denibalaŋ siaman nyi me yɛɛ ɔ Gbeŋgyoo e na, maŋ Deniwalaŋ Bu ŋon mɔ maa lɛɛ e do Wurubuarɛ kpilala baŋ siaman adido. ");
INSERT INTO ntr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mɔna walaŋ ŋon ɔ te lɛɛ maŋ do denibalaŋ siaman nyi me yɛɛ ɔ Gbeŋgyoo e ya nɛ, maŋ Deniwalaŋ Bu ŋon mɔ maa bɛɛ e Wurubuarɛ kpilala baŋ siaman adido. ");
INSERT INTO ntr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nyi akpaa ŋolo de kolosi nombiakumɛɛ tia maŋ Deniwalaŋ Bu ŋon nɛ Wurubuarɛ waa mo kyɛɛ e, mɔna nyi akpaa ŋolo de kolosi mmusuo nombia tia Wurubuarɛ feliŋ ŋon na, Wurubuarɛ be gyae waa mo kyɛɛ e korakora ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Akpaa be wɔŋee ŋon gyu Gyudatena ɔsom denɛɛ man na gyooneŋ na donɔɔ kegyiise siaman nyi be kaa di ɛ nombia na, ɛ na wɔlɛɛ na mena keŋ ɛ ke tira ɛ nɔɔse yaa kpene keŋ ɛ ke yako ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nawolo nyi debaŋ kenaŋ nɛ, Wurubuarɛ feliŋ ŋon ne gyae la waa wola ŋon kpene keŋ ɛ ke yako.” ");
INSERT INTO ntr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesu kee kolosi nɛ, walaŋ ŋolo korowɔ balaŋ dikpii keŋ man yako e nyiaa, “De Gbeŋgyoo, yako me kegyia na dɛɛ kpala de kya abɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Keŋte Yesu tiranɔɔ fa e nyi “Baale, amɔte lese na maŋ nyi maa yɛɛ ɛ nombiadiiri yaa ya abɔɔ kpalare?” ");
INSERT INTO ntr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Keŋte ɔ yako wɔ nyiaa, “Ɛ kɛɛ nideli na ɛ ka deke ɛ wose lee kedikum kamasɛ man, nawolo nyi deniwalaŋ nyeedoŋ be doo abɔɔ burum kenyiŋ man ya.” ");
INSERT INTO ntr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Keŋte Yesu gyɔɔ dudu kei fa wɔ nyiaa, “Kɔbate ŋolo kyaawɔ keŋ ɔ wɔɔman weenɛɛ deewɔ fa e nideli. ");
INSERT INTO ntr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Keŋte balee ŋonaŋ yako ɔ wose nyiaa, ‘Woŋ te maa yɛɛ, nawolo nyi mɔɔ taŋ botɔɔ keŋ maa see me weenɛɛ bela ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Keŋte balee ŋon yako ɔ wose nyi ‘Ma gyeŋ kpene keŋ maa yɛɛ, maa tekerii me kpeese benɛɛ ŋan pou na maa baŋ dinaana na maa see me weenɛɛ na ma abɔɔ pou ŋe man.’ ");
INSERT INTO ntr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na maa yako ma wose nyiaa, ‘Me dana abɔɔ kpaakpaa burum ŋan gyae ke doo fa maŋ kulutooneŋ burum. Mena dɔɔ maa kyaa fɛɛfo na maa di na maa nyɔɔ na maa di gyoŋ!’ ” ");
INSERT INTO ntr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mɔna Wurubuarɛ yako e nyiaa, “Nyaŋ diyiŋte! Gyɛŋ nelim kei maa lɛo n nyeedoŋ lee n nyiŋmaa man. Na nya abɔɔ ŋan pou n be gyae see nɛ, gyae ka bese amɔte wui?” ");
INSERT INTO ntr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Keŋte Yesu yakowɔ nyiaa, “Nnɛ kei te gyae ke kɔŋ walaŋ kamasɛ ŋon ɔ ne gyae abɔɔ burum fa ɔ wose tɛɛle kei dɔɔ, mɔna Wurubuarɛ siaman na ɔ be doo kolo man ya nɛ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Mena dɔɔ te mɛɛ yako ŋon nyi ‘Ɛ na naase ɛ wose diyem lee ɛ kekyaa man kedi na kenyɔɔ na abɔɔ ŋan ɛ ka do ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nyeedoŋ ne hia kela weenɛɛ, te deniwalaŋ wose mɔ ne hia kela abɔɔ ŋan waa do. ");
INSERT INTO ntr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɛ kɛɛ gyebuse, bɔɔ ne duu abɔɔ ya te bɔɔ ne kɔɔ ya, te bɔɔ dana kpeese yaa denɛɛ ŋan man baa see weenɛɛ ya, mɔna Wurubuarɛ ne fa wɔ weenɛɛ. Kaboena yaa gyeŋ nyi ɛ wose ne hia kela gyebuse. ");
INSERT INTO ntr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɛ man woŋti te lee ɔ kayeyɛɛ man nɛ, waa tale mo debaŋ dokoloŋ kooŋ pɛ kpu na ɔ weeya ŋan Wurubuarɛ be fa e nɛ? ");
INSERT INTO ntr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Akpaa nyi ɛ be gyae ɛ ke tale yɛɛ kolo peperee kei ya na, woŋ dɔɔ te ɛ ne naase ɛ wose diyem abɔɔ akaŋ ŋan dɔɔ? ");
INSERT INTO ntr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ɛ kɛɛ mena keŋ kyeŋkyeŋkɔɔse na bee, ŋe bɛɛ yɛɛ tom ya te ŋe bɛɛ loo kanyaŋse mɔ ya. Mɔna mɛɛ yako ŋon ɛ ke nyii nyi Gyoo Solomɔn na ɔ wosekenyiŋ koraŋ nɛ, ɔ te nyiŋ kyeŋkyeŋkɔɔse kɛŋa man dokoloŋ kyeo ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Weera dɔɔ te ɛ bɛɛ lɛɛ Wurubuarɛ di nideli ya? Nyi akpaa mena te Wurubuarɛ ne desina ŋalese ŋan ɛ kena ŋa gyɛŋ kyoo na be ta too ŋa na, kenaŋ na ɛ tɔɔse nyi Wurubuarɛ waa tale desina ŋon kela ŋalese ŋenaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mena dɔɔ ɛ na mo ɛ konɔɔ gyakaa kpene keŋ ɛ ke di yaa kpene keŋ ɛ ke nyɔɔ dɔɔ ya. Ɛ na yeyɛɛ na mena abɔɔ ŋenaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nawolo nyi mena abɔɔ kɛŋa te tɛɛle kei dɔɔ balaŋ baŋ bɔɔ gyeŋ Wurubuarɛ ya nɛ sia ne yɛɛ ŋe dɔɔ, mɔna ɛ kya Wurubuarɛ gyeŋ nyi mena abɔɔ kɛŋa ne hia ɛmɛɛ mɔ. ");
INSERT INTO ntr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mena dɔɔ ɛ taŋgbɛɛ mo ɛ loo pou gyakaa Wurubuarɛ gyoori keŋ dɔɔ. Nyi akpaa ɛ yɛɛ mena na, Wurubuarɛ waa mo abɔɔ akaŋ ŋan pou kpu ŋon.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ɛmɛɛ me balaŋ dikpiibii, ɛ ta boo ya mɔna ɛ na yee ya nawolo nyi dana ɛ kya Wurubuarɛ gyoŋ nyi waa yela ɛ ke di gyoori kpu na e. ");
INSERT INTO ntr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ɛ yɔɔ ya abɔɔ na ɛ ka mo ŋe kɔba pou fa ayematena. Kei gyae ke yela ɛ ke nyiŋ abɔɔ kpaakpaa see ɛ wose Wurubuarɛ man. Ŋmɛɛlate be gyae waa tale gyu botɔɔ ke ŋmɛɛle ya, te kolo be gyae ke tale wɔlɛɛ ŋa mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ɛ tɔɔse nyi botɔɔ keŋ ya abɔɔ kpaakpaa doo nɛ, botɔɔ te ɛ loo mɔ gyakaa.” ");
INSERT INTO ntr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Keŋte Yesu besewɔ yako wɔ nyiaa, “Ɛ doo ɛ wose dɔɔ nideli na ɛ ke kyaŋee ɛ kanease see, ");
INSERT INTO ntr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ŋgba tewulɛɛ baŋ bɛɛ daa be gbeŋgyoo ka lee alowɔle tɛɛ kɔŋ nɛ. Na nyi akpaa ɔ betaa kɔŋ kaa gyɔ disim na baa koro toro e bileŋ. ");
INSERT INTO ntr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tewulɛɛ baŋ be gbeŋgyoo waa kaa naa nyi ba delena nɛ, baŋ na nyeebam. Ampaŋ yaa mɛɛ yako ŋon nyiaa, be gbeŋgyoo ŋon waa kpee wa abɔɔ desina ɔ wose na waa yela baa kyakee na waa fa wɔ weenɛɛ baa di. ");
INSERT INTO ntr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Akpaa nyi be gbeŋgyoo ŋon da bese kɔŋ tɛɛ nsana yaa nebo fuu koraŋ te ɔ naa nyi ɔ tewulɛɛ baŋ delena na, baŋ na nyeebam. ");
INSERT INTO ntr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mɔna ɛ tɔɔse nyiaa, akpaa dekpaŋalaŋte deŋ gyeŋ debaŋ keŋ ŋmɛɛlatena baa kɔŋ kaa ŋmɛɛle e nɛ, nafɔ waa doo ɔ wose dɔɔ na bɔɔ nyiŋ kɔŋ kaa kuu wa abɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mena dɔɔ kaboena nyi ɛmɛɛ mɔ yaa doo ɛ wose dɔɔ, nawolo nyi maŋ Deniwalaŋ Bu ŋon mɔ maa kɔŋ bo debaŋ keŋ ɛ loo be gyakaa ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Botɔɔ te Pita bɔɔse Yesu nyiaa, “Me Gbeŋgyoo, daa yaa n gyɔɔ dudu kei fa yaa walaŋ kamasɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Keŋte Yesu tiranɔɔ fa e nyi, “Amɔte yɛna tobaale ŋon bɛɛ lɛɛ e di te ɔ sia be kare?” Ŋon yɛna walaŋ ŋon ɔ gbeŋgyoo ba mo e nyi waa kɛɛ ɔ tewulɛɛ akaŋ baŋ dɔɔ, na waa fa wɔ weenɛɛ debaŋ keŋ kaboena nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nyi ɔ gbeŋgyoo ŋon de kɔŋ kaa naa e nyi ɔ ne yɛɛ ɔ tom ŋgba mena keŋ ɔ kpa waa yɛɛ nɛ, na ŋon na nyeebam. ");
INSERT INTO ntr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ampaŋ yaa mɛɛ yako ŋon nyiaa, ɔ gbeŋgyoo ŋon waa mo wa abɔɔ pou do tobaale ŋonaŋ nyiŋmaa man nyi waa kɛɛ ŋe dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mɔna akpaa tobaale kei de yako ɔ wose nyiaa, “Me gbeŋgyoo te kyare ɔ bɛɛ kɔŋ ya, te ɔ gyoo tewulɛɛ na alebia akaŋ baŋ akpanyaŋnyaŋ keyɛɛ te ɔ ne dii te ɔ ne nyɔɔ dɛɛse nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ɔ gbeŋgyoo ŋon da bese kɔŋ wee yaa debaŋ keŋ tobaale ŋon loo be gyakaa ya nɛ, waa wɔŋ tobaale ŋonaŋ deŋele na waa gegi e na waa yela waa naa diyem ŋgba baŋ bɔɔ ne lɛɛ Wurubuarɛ di ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tobaale ŋon ɔ gyeŋ kpene keŋ ɔ gbeŋgyoo ne gyae te ɔ te desina ɔ wose see na waa yɛɛ ɔ gbeŋgyoo kegyaebii ya nɛ, baa kebii e dambiise nideli. ");
INSERT INTO ntr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mɔna tobaale ŋon ɔ ba gyeŋ kpene keŋ ɔ gbeŋgyoo ne gyae ya te ɔ yɛɛ kpene keŋ kaboena ketuku na, baa tuku e bo kyomii. Walaŋ kamasɛ ŋon ba mo abɔɔ burum do ɔ nyiŋmaa man na, baa bɔɔse abɔɔ burum lee ɔ gyaŋ. Te ŋon mɔ ba mo abɔɔ ŋan ŋa boe nideli do e ɔ nyiŋmaa man na, mena ke mɔ te baa bɔɔse lee ɔ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Keŋte Yesu yako wɔ nyiaa, “Me kɔŋae me kaa do boalaŋ tɛɛle kei dɔɔ, te ma kegyaebii yɛna nyi nafɔ ke deŋ wulaa kɛɛ kpaa. ");
INSERT INTO ntr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kaale daale doo daa na maŋ te mɛɛ yeyɛɛ kelii debaŋ keŋ kaale kenaŋ gyae ke taŋ. ");
INSERT INTO ntr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɛ gyeŋ nyi wosefɛɛreŋ yaa ma moowɔ kɔŋ tɛɛle kei dɔɔ? Koa! Na wosefɛɛreŋ ya, mɔna me kɔŋae na balaŋ kekpase kpookpoo. ");
INSERT INTO ntr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lee gyɛŋ ne gyu nɛ dekpaŋalaŋ keŋ ke man balaŋ yɛɛ balaŋ banoŋ na baa kpase ba wose. Balaŋ batooro baa koro seŋ tia balaŋ bala, na balaŋ bala mɔ ka koro seŋ tia balaŋ batooro. ");
INSERT INTO ntr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kyaɔ baa koro seŋ tia be bia baala te bia baala mɔ baa koro seŋ tia be kyaɔ. Naɔ baa koro seŋ tia be bia alebia te bia alebia mɔ baa koro seŋ tia be naɔ. Awuna baa koro seŋ tia be bia ala te bia ala mɔ baa koro seŋ tia ba awuna.” ");
INSERT INTO ntr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Keŋte Yesu besewɔ yako balaŋ dikpii keŋ nyiaa, “Ɛ naa ŋɔma da lee weese dɛɛyalae man nɛ, debokenaŋ man na ɛ kpa ‘Ɔga ne kɔŋ’ na ampaŋ ɔga te ŋɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te ɛ naa ŋgba feliŋ ne gyɔɔ lee ata yenaŋ na ɛ kpa ‘Weese waa seŋ’ na ampaŋ te kɔŋ mena. ");
INSERT INTO ntr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɛmɛɛ baŋ ɛ na beo ɛ wose! Ɛ ne tale kɛɛ adido na ateta na ɛ ta wola kpene keŋ gyae ke yɛɛ. Woŋ dɔɔ te ɛ be tale kɛɛ abɔɔ ŋan ne kɔŋ gyɛŋ nɛ, na ɛ ka wola ŋe man ya? ");
INSERT INTO ntr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Woŋ dɔɔ te ɛmɛɛ gbagba be tale gyueŋ naa kpene keŋ dei fa ŋon na ɛ ke yɛɛ ya? ");
INSERT INTO ntr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nyi akpaa ŋolo de samenaa neŋ te ɛ ne gyu ɛ kaa di nombia ŋan na, yɛɛ kakyeŋ na ɛ ke desina ya nsana gbɛɛnaa man. Na mena ya na waa mo neŋ gyu nombiadiiri ŋon gyaŋ na ŋon mɔ ka mo neŋ kefa kotɔtɔɔtena na baŋ mɔ kewɔŋee neŋ ketɔ deni. ");
INSERT INTO ntr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mɛɛ yako neŋ n ke nyi nyiaa, n be gyae n ka lee deni man botɔɔ ya kaboena n ketɔ kom keŋ baa kara fa neŋ nɛ pou taŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesu ke gyakaa ɔ ne kolosi fa balaŋ baŋ nɛ balaŋ baale kɔŋawɔ kaa yako e nyiaa, Galeliatena baale gyuuwɔ Wurubuarɛ ɔsom deni dinaa keŋ man be kaa deesi fa Wurubuarɛ. Keŋte gyoo dinaa Pilato yela be ka koo wɔ, te be fatabo kyakalewɔ na ba kedeesa fatabo keŋ. ");
INSERT INTO ntr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Keŋte Yesu bɔɔse wɔ nyiaa, “Ɛ na gyueŋ nyi Galeliatena baŋ bɔɔ naa mena diyem kei gyu ka yeŋ nɛ, be nombiakumɛɛ kela Galeliatena akaŋ baŋ pou? ");
INSERT INTO ntr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Koa be doo mena ya, mɛɛ yako ŋon baa nyiaa akpaa ɛ te kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man na ɛ ke kɔŋ Wurubuarɛ gyaŋ ya nɛ, ɛmɛɛ mɔ ɛ ka yeŋ. ");
INSERT INTO ntr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yaa ɛ na gyueŋ nyi balaŋ kufu gyanaara baŋ deni dɔɔloŋte keŋ be yale ŋere wɔ Siloam nɛ, be nombiakumɛɛ kela balaŋ akaŋ baŋ be kyaa Gyerusalɛm donɔɔ man nɛ pou? ");
INSERT INTO ntr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Koa be doo mena ya, mɛɛ yako ŋon baa nyiaa akpaa ɛ te kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man na ɛ ke kɔŋ Wurubuarɛ gyaŋ ya nɛ, ɛmɛɛ mɔ ɛ ka yeŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Botɔɔ te Yesu gyɔɔ dudu kei fa wɔ nyiaa, “Balee ŋolo duu daŋ keŋ bɛɛ baake ke nyi fiigi nɛ ɔ wɔɔman, te ɔ gyuuwɔ ɔ kaa kɛɛ nyi waa nyiŋ ke bia di mɔna ke ta see ya. ");
INSERT INTO ntr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Keŋte ɔ yako ɔ paate ŋon nyiaa, ‘Kɛɛ kulutooneŋ atooro sɔɔŋ yaa ŋgba mɛɛ kɔŋ kɛbo kaa kɛɛ nyi maa nyiŋ daŋ kei bia, mɔna me bee nyim ya. Kara ke leki! Woŋ dɔɔ te ka seŋɛɛ kɛɛ wɔlɛɛ me tɛɛle?’ ");
INSERT INTO ntr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Keŋte ɔ paate ŋon tiranɔɔ nyiaa, ‘Me gbeŋgyoo, yela ke ka seŋ kulutoo dokoloŋ kpu na maa wula tɛɛle keŋ ke dei nɛ kaa do ka ateta na dɛɛ kɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Akpaa ke da see bia kulutoo anekɔŋaŋ na dei, te akpaa ke ta see ya na dɛɛ kara ke leki.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gyudatena kefɛɛfowee daale nɛ, na Yesu na wolo Gyudatena ɔsom deni daale man. ");
INSERT INTO ntr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na alo ŋolo kyaa botɔɔ keŋ feliŋkum ba do e kawee kulutooneŋ kufu gyanaara, te ke yela ɔ goowɔ keŋ ɔ bɛɛ tale waa tenee ɔ wose koraŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu kena alo ŋon nɛ, ɔ baake e kaa seŋ balaŋ siaman te ɔ yako e nyiaa, “Alo, n te nyiŋ kawee kekyɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Keŋte Yesu moo ɔ nyiŋmaa gyakaa ɔ dɔɔ, debokenaŋ man te alo ŋon teneewɔ te ɔ lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Botɔɔ te bɔ ɔsom deni man kegyia ŋon gyeŋa baŋ nyi Yesu te kyɔ walaŋ kawee ba kefɛɛfowee, mena dɔɔ ɔ kolosiwɔ fa balaŋ baŋ bɔɔ gyaŋee botɔɔ nɛ nyiaa, “Ɛ dana weeya looro keŋ ɛ na mo yɛɛ tom. Ɛ kɔŋ weeya ŋenaŋ man na baa kyɔ ŋon ɛ kaweese, te yɛɛ nyi kefɛɛfowee te ɛ ke kɔŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Keŋte de Gbeŋgyoo Yesu tiranɔɔ fa e nyiaa “Ɛmɛɛ baŋ ɛ na beo ɛ wose! Ɛ man woŋti bɛɛ booli na ɔ wonembu lee ɔ dekpaŋae man mo e gyu kefa e loŋ kefɛɛfowee ya? ");
INSERT INTO ntr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Te nɛnɛɛ alo kei ŋon ɔ ba lee Aberaham duuluŋ man te ɔbɔnsam ba do e kawee kulutooneŋ kufu gyanaara sɔɔŋ yaa nɛ, tekaboena nyi maa kyɔ e kawee kefɛɛfowee yee?” ");
INSERT INTO ntr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu nɔɔ ketira keŋ yela ɔ kɔlala baŋ pou sia yeŋawɔ, te gyakoloŋ nombia ŋan ɔ be yɛɛ nɛ yɛɛ balaŋ baŋ pou gyoŋ. ");
INSERT INTO ntr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Keŋte Yesu bɔɔse wɔ nyiaa, “Sena te Wurubuarɛ gyoori keŋ doo? Yaa woŋ te dɛɛ mo ke maa na? ");
INSERT INTO ntr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ke yɛɛ ŋgba daŋ daale bii peperee ŋgba kpeli bii keŋ balee ŋolo ba mo ke duu ɔ wɔɔman nɛ. Te ke tuuwɔ bese daŋ dinaa dinaa te gyebuse kɔŋawɔ kaa loo ba asaase do ke tombia man.” ");
INSERT INTO ntr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Keŋte Yesu besewɔ bɔɔse wɔ nyiaa, “Woŋ te maa mo Wurubuarɛ gyoori keŋ maa na? ");
INSERT INTO ntr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wurubuarɛ gyoori keŋ yɛɛ ŋgba tee keŋ alo ŋolo ba mo kyakale bodobodo biliŋ tasa dinaa man, kaboena biliŋ keŋ pou korowɔ wuku nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ka mo ɔ nyee baŋ ɔ ne gyu Gyerusalɛm donɔɔ man nɛ, ɔ tɛɛwɔ donɔɔse na akuraase man ɔ na wola wɔ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Keŋte walaŋ ŋolo bɔɔse e nyiaa, “Me Gbeŋgyoo, balaŋ akalansɛɛ te Wurubuarɛ waa lɛɛ ba nyee yaa?” Te Yesu tiranɔɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nyi akpaa ɛ ne gyae ɛ ka gyoo Wurubuarɛ gyoori keŋ man nɛ, ɛ yɛɛ kakyeŋ na ɛ ka mo denanɔɔ bɔbɔɔkyee keŋ man gyoo. Nawolo nyi balaŋ burum baa peree nyi baa mo botɔɔ gyoo, mɔna bɔɔ gyae baa tale ya. ");
INSERT INTO ntr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Debaŋ keŋ dekpaŋalaŋte ŋon waa koro na waa tɔ ɔ disim nɛ, debaŋ kenaŋ te ɛ ka seŋ debɔɔ man na ɛ ke gyɔ disim keŋ na ɛ ke waase e nyiaa, ‘De Gbeŋgyoo toro denanɔɔ keŋ fa daa.’ Keŋte waa tiranɔɔ fa ŋon nyi, ‘Mɔɔ gyeŋ ŋon ya te mɔɔ gyeŋ botɔɔ keŋ ɛ ba lee mɔ ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Botɔɔ te ɛ ke tiranɔɔ nyiaa, daa na neŋ doo nyiŋmaa di te de nyɔɔwɔ, te n wola nombia de debiise mɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mɔna dekpaŋalaŋte ŋon waa bese yako nyiaa, ‘Mɔɔ gyeŋ ŋon ya te mɔɔ gyeŋ botɔɔ keŋ ɛ ba lee mɔ ya. Ɛ ta lee me siaman, ɛmɛɛ nombiakumɛɛyɛɛra!’ ");
INSERT INTO ntr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Debaŋ keŋ ɛ kena de naanaɔ Aberaham na Asiki na Gyekɔpo na Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ pou Wurubuarɛ gyoori keŋ man te ɛ be gyae ɛ ke tale ke kpu na wɔ ya nɛ, botɔɔ te ɛ ke kyaŋ ɛ nyeeya wii na ɛ ka doŋee ɛ nyimbia. ");
INSERT INTO ntr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Balaŋ baa lee weese dɛɛlee na weese dɛɛyalae man, na ado na ata yenaŋ kɔŋ kaa kyaa Wurubuarɛ gyoori keŋ man di gyoŋ. ");
INSERT INTO ntr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mɛɛ yako ŋon ɛ ke nyii nyiaa, balaŋ baŋ bɔɔ dɔɔ wɔle nɛ baa kaa laŋ siaman, te baŋ be kyaa siaman nɛ baa dɔɔ wɔle.” ");
INSERT INTO ntr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Debaŋ kenaŋ man te Farasiitena baale kɔŋawɔ Yesu gyaŋ kaa yako e nyi “Lee kɛbo kei gyu yenaŋ daale, nawolo nyi gyoo Herode ne gyae neŋ waa ko.” ");
INSERT INTO ntr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ gyu ke yako mena adaote ŋonaŋ nyiaa, maa gberaa feliŋkumɛɛ na maa kyɔ balaŋ gyɛŋ na kyoo, te weeya atoorote man na maa taŋ ma tom.” ");
INSERT INTO ntr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mɔna kaboena nyi maa mo me sia tee me dee gyue dɛɛdɛɛ gyɛŋ na kyoo na ke tɛɛ kena. Nawolo nyi yɛɛ senaa nɛ, Gyerusalɛm donɔɔ man te kaboena nyi Wurubuarɛ dekpeŋkpeŋgyɔɔre waa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Keŋte Yesu yakowɔ nyiaa, “O Gyerusalɛmtena, O Gyerusalɛmtena, ɛmɛɛ koona Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ te ɛ fuŋii Wurubuarɛ kpilala baŋ ɔ be kpili ɛ gyaŋ nɛ boya. Ma te yɛɛ mena keŋ maa yilaa ŋon kɔŋ me gyaŋ ŋgba mena keŋ kegyim talabo ne yilaa ɔ bia do ɔ beŋkelɛɛ tɛɛ nɛ, mɔna ɛ te fa maŋ gbɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ɛ kɛɛ, Wurubuarɛ ta lese ɔ sia lee ɛ donɔɔ keŋ dɔɔ. Te mɛɛ yako ŋon ɛ ke nyii nyiaa, ɛ be gyae ɛ kena maŋ bela ya kelii debaŋ keŋ ɛ keyako nyiaa, ‘Walaŋ ŋon ɔ ne kɔŋ de Gbeŋgyoo Wurubuarɛ yele man nɛ, ŋon na nyeebam.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gyudatena kefɛɛfowee daale nɛ, Yesu gyuu Farasiitena siamante ŋolo dɛɛ ɔ kaa di. Ɔ ke kyaa botɔɔ keŋ na, Farasiitena baŋ na deke e baa kɛɛ nyi baa nyiŋ kolo yako lee ɔ wose man. ");
INSERT INTO ntr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Keŋte balee ŋolo ŋon ɔ ba bokee nɛ kɔŋawɔ Yesu gyaŋ, ");
INSERT INTO ntr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","te Yesu bɔɔse Gyudatena mmaraa wolala baŋ na Farasiitena baŋ nyiaa, “Da mmaraa ne fa gbɛɛ nyi dɛɛ kyɔ walaŋ kawee kefɛɛfowee yaa bɛɛ fa daa gbɛɛ ya?” ");
INSERT INTO ntr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mɔna be man ŋolo te gyuusu ɔ nɔɔ ya. Keŋte Yesu kyaŋa kaweete ŋon nyiŋmaa man te ɔ kyɔɔ e kawee te ɔ lɔɔ e gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Akpaa ɛ man ŋolo dana bu baale bii yaa wonembu te ɔ yale ditiribuŋ man kefɛɛfowee na, ɔ be gyae waa lese e debokenaŋ man yee?” ");
INSERT INTO ntr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mɔna ba te tale tiranɔɔ fa e ya. ");
INSERT INTO ntr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu kena mena keŋ balaŋ baŋ bɔɔ baake wɔ kɔŋ weenɛɛ ŋan tɛɛ kɛɛ tɔɔsee akyaese kpaakpaa nyiŋan nɛ, ɔ gyɔɔ dudu kei fa wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Akpaa ŋolo de baake neŋ alowɔlere weenɛɛ tɛɛ nɛ na peree dekyae kpaakpaate ya. Nawolo nyi gyae ke tale kɔŋ nyi ɔ te baake walaŋ ŋolo ŋon ɔ kela neŋ nɛ mɔ kɔŋ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Akpaa de kɔŋ mena na walaŋ ŋon ɔ be baake ɛ bala nɛ, waa kɔŋ kaa yako neŋ nyiaa ‘Koro mo n dekyae fa balee kei.’ Botɔɔ na desɛŋ gyae ke kyaŋ neŋ, na n ke gyu ke kyaa botɔɔ keŋ be taŋ obuo ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mɔna nyi akpaa ŋolo de baake neŋ gyu ɔ dɛɛ nɛ, gyu ke kyaa botɔɔ keŋ be taŋ obuo ya nɛ te akpaa walaŋ ŋon ɔ be baake neŋ de kɔŋ nɛ waa yako neŋ nyiaa, ‘Me gyoo koro ke kyaa dekyae kpaakpaate man.’ Kei gyae ke fa neŋ obuo balaŋ baŋ bɔɔ baake wɔ nɛ pou siaman. ");
INSERT INTO ntr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nawolo nyi walaŋ kamasɛ ŋon ɔ gyina ɔ wose na Wurubuarɛ waa yɔkɔse e, te walaŋ kamasɛ ŋon ɔ yɔkɔse ɔ wose na Wurubuarɛ waa gyina e adido.” ");
INSERT INTO ntr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Botɔɔ te Yesu yako walaŋ ŋon ɔ be baake e gyu ɔ dɛɛ nɛ nyiaa, “Akpaa n do kesaa te n ne gyae n ke baake balaŋ kaa di be nɔɔ nɛ, na baake n gyoona yaa n naabia yaa n loŋtona yaa n tebia baŋ be dana kɔba nɛ ya. Nawolo nyi n yɛɛ mena na baŋ mɔ baa kaa baake neŋ wee daale tɔ kom. ");
INSERT INTO ntr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mena dɔɔ nyi akpaa n do kesaa na, baake ayematena na ɔtakasese na abafaŋse na siayɛlɛɛsatena. ");
INSERT INTO ntr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","N yɛɛ mena na Wurubuarɛ waa hiraa neŋ. Nawolo nyi baŋ be gyae baa tale yɛɛ mena tɔ neŋ kom ya, mɔna Wurubuarɛ ne gyae la waa tɔ neŋ kom wee keŋ waa gyuusu balaŋ baŋ be gbɛɛneŋ tenɛɛ ɔ siaman lee yeŋ man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Balaŋ baŋ baŋ na wɔ kyaa bee di weenɛɛ ŋan man ŋolo kenyii nombia kɛŋa nɛ ɔ yako Yesu nyiaa, “Walaŋ ŋon waa di weenɛɛ Wurubuarɛ gyoori keŋ man nɛ, ŋon na nyeebam!” ");
INSERT INTO ntr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Keŋte Yesu tiranɔɔ fa e nyiaa, “Balee ŋolo kyaawɔ te wee daale ɔ doo kesaa, te ɔ baake balaŋ burum nyi be kaa di. ");
INSERT INTO ntr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Debaŋ keŋ weenɛɛ ŋan kedi be lii nɛ, ɔ kpila ɔ tobaale nyi waa ta baake balaŋ baŋ ɔ be lɔ yele baake wɔ nɛ nyiaa, ‘Ɛ kɔŋ, ba te taŋ kpene kamasɛ.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mɔna be popou wɔŋee ba wose lee wɔle dokoloŋ dokoloŋ. Walaŋ gyaŋgbate ŋon tobaale ŋon be gyu ɔ gyaŋ nɛ yakowɔ nyiaa, ‘Ma ke lɛɛ tɛɛle daale yaa te mee gyu me kaa kɛɛ ke mena dɔɔ mɛɛ waase neŋ bo mɔɔ gyae maa tale kɔŋ ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ŋolo mɔ yako e nyiaa, ‘Ma te lɛɛ nunkyuese baala kufu baŋ baa yɛɛ tom fa maŋ te mee gyu me kaa mo wɔ fara kɛɛ be doŋ man, mena dɔɔ mɛɛ waase neŋ bo mɔɔ gyae maa tale kɔŋ ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Keŋte ŋolo mɔ yakowɔ nyiaa, ‘Ma ke yala alo yaa, mena dɔɔ mɔɔ gyae maa tale kɔŋ ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mena dɔɔ tobaale ŋon besewɔ gyu ke yako ɔ gbeŋgyoo ŋon nombia ŋan bɔɔ yako e nɛ. Ɔ gbeŋgyoo ŋon ke nyii nombia kɛŋa nɛ ɔ gyeŋa baŋ nideli te ɔ yako ɔ tobaale ŋon nyiaa, ‘Bese gyu donɔɔ keŋ abɔnterese na ŋe gbɛɛneŋ nɔɔman, na n kaa baake ayematena na ɔtakasese na siayɛlɛɛsatena na abafaŋse nyi be popou baa kɔŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te kyare ya nɛ tobaale ŋon besewɔ kɔŋ kaa yako ɔ gbeŋgyoo ŋon nyiaa, ‘Me gbeŋgyoo, kpene keŋ n be kpila maŋ nyi maa yɛɛ nɛ, ma te yɛɛ mɔna akyaese sɛɛ doo burum.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Keŋte balee ŋon yako ɔ tobaale ŋon nyiaa, ‘Gyu donɔɔ keŋ denɛɛ wɔla na ke gbɛɛneŋ pou man, na n kaa mo balaŋ kɔŋ na ma dekpaŋalaŋ keŋ kenyiŋ wulu.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mɛɛ yako ŋon ɛ ke nyii nyiaa, ‘Balaŋ baŋ mɔɔ lɔ yele baake wɔ nɛ, be man ŋolo na ŋolo nɔɔ be gyae ke daa me weenɛɛ kɛŋa ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wee daale balaŋ burum baale kesila Yesu bee gyuu nɛ, ɔ besena ɔ sia tee wɔ te ɔ yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Akpaa ŋolo ne kɔŋ me gyaŋ ɔ kaa sila maŋ te ɔ te gyae maŋ kela ɔ kya na ɔ naa na ɔ wɛɛle na ɔ bia na ɔ kegyiise na ɔ naabia na ɔ deesina na ŋon gbagba ɔ wose koraŋ ya nɛ, ɔ be gyae waa tale bese me kaseele ya. ");
INSERT INTO ntr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te walaŋ kamasɛ ŋon ɔ ta mo ɔ ɔpaŋdaŋ keŋ ka seŋɛɛ fa kaale na yeŋ na waa sila maŋ ya nɛ, ɔ be gyae waa tale bese me kaseele ya. ");
INSERT INTO ntr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Akpaa ɛ man ŋolo ne gyae waa baŋ deni dinaa na, ɔ bɛɛ kyaa na waa bu deni keŋ abɔɔ koya kɛɛ nyi kɔba keŋ ɔ dana nɛ gyae ka yee deni kenaŋ kebaŋ yee? ");
INSERT INTO ntr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nawolo nyi akpaa ɔ see deni keŋ mokɔɔ te ɔ te tale taŋ ke ya na, baŋ pou baa naa ke nɛ baa boŋo e, ");
INSERT INTO ntr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nyiaa ‘Balee kei korowɔ nyi ɔ ne baŋ deni mɔna ɔ nyiŋmaa te gyaŋee ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Keŋte Yesu besewɔ yako nyiaa, akpaa gyoo ŋolo dana yoonɔɔtena kakpoŋse kufu (10,000) te ɔ ne gyu ɔ kaa yoo na ɔ dɔɔ gyoo ŋon ɔ dana yoonɔɔtena kakpoŋse sao (20,000) na, ɔ be gyae waa kyaa na waa gyueŋ kɛɛ nyi waa tale mo ɔ wui yoonɔɔtena kakpoŋse kufu (10,000) baŋ ke yoo na ɔ dɔɔ ŋon wui yoonɔɔtena kakpoŋse sao (20,000 ) baŋ yee? ");
INSERT INTO ntr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nyi akpaa ɔ kɛɛ nyi ɔ be tale yoo na e ya nɛ, debaŋ keŋ ɔ ta benaa ta e ya na waa kpila teree gyu ke doo e nyi waa yela baa desina ba nsana na baa kyaa wosefɛɛreŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mena mɔ te ɛ man walaŋ kamasɛ ŋon ɔ be gyae waa tale tina kpene kamasɛ keŋ ɔ dana yela ya nɛ, ɔ be gyae waa tale bese me kaseele ya.” ");
INSERT INTO ntr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Keŋte Yesu besewɔ yako nyiaa, “Yabia dei mɔna akpaa ka gyoŋ keŋ da lee ke man nɛ, n be gyae n ke tale yela ka ke yɛɛ gyoŋ bela ya. ");
INSERT INTO ntr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","De kɔŋ mena na, yabia kenaŋ be dei fa kolo na kolo keyɛɛ bela ya, bee fuŋ ke bo leki. Walaŋ kamasɛ ŋon ɔ dana deŋela anenyiiŋ dei na, waa tei nombia ŋan mɛɛ yako nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Debaŋ daale nɛ, lempoolɛɛra burum na nombiakumɛɛyɛɛra kɔŋawɔ Yesu gyaŋ be kaa nyii nombia ŋan ɔ na wolo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Keŋte Farasiitena na Gyudatena mmaraa wolala ŋorokosowɔ yako nyiaa, “Balee kei dɔɔ ɔ ne lɛɛ nombiakumɛɛyɛɛra do ɔ wose man te ɔ ne dii bom na wɔ gba koraŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mena dɔɔ Yesu gyɔɔ dudu kei fa wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Akpaa ɛ man ŋolo dana namense sɔŋonoŋ (100) te be man ŋolo da yoo na woŋ te ɔ ne yɛɛ?” Ɔ be gyae waa tina sɔŋonaara na kufu kadaale (99) baŋ yela ŋale nsana botɔɔ na waa ta kɛo ŋon ɔ ba yoo nɛ kaboena waa naa e yee? ");
INSERT INTO ntr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te akpaa ɔ naa e na, ɔ be gyae waa nyaŋee na waa gate e gyakaa ɔ degbaŋgbaŋ dɔɔ mo e gyu dɛɛ yee? ");
INSERT INTO ntr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ɔ gyu dɛɛ nɛ waa baake ɔ gyoona na ɔ tebia gyaŋee na waa yako wɔ nyiaa, “Ɛ yela dɛɛ nyaŋee nawolo nyi ma te naa me nam ŋon ɔ ba yoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mɛɛ yako ŋon ɛ ke nyii nyiaa, mena ke te akpaa nombiakumɛɛyɛɛre dokoloŋ de kyɛɛkee lee ɔ gbɛɛneŋ kumɛɛ man te ɔ kɔŋ Wurubuarɛ gyaŋ nɛ, baŋ be kyaa Wurubuarɛ man adido nɛ baa nyaŋee ɔ dɔɔ kela balaŋ sɔŋonaara na kufu kadaale baŋ bɛɛ gyueŋ nyi be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman, mena dɔɔ tekaboena nyi baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu besewɔ yako nyiaa, akpaa alo ŋolo dana kɔba wolom bia kufu te ŋe man dokoloŋ da yoo na woŋ te ɔ ne yɛɛ? Ɔ be gyae waa kyaŋee kanea na waa gbee ɔ deni man na waa kɛo yenaŋ kamasɛ nideli kaboena waa naa ke yee? ");
INSERT INTO ntr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te akpaa ɔ naa ke na, ɔ ne baake ɔ gyoona na ɔ tebia gyaŋee na waa yako wɔ nyiaa, “Ɛ yela dɛɛ nyaŋee nawolo nyi ma te naa me kɔba wolom bii keŋ kɔɔ yoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mɛɛ yako ŋon ɛ ke nyii nyiaa, mena ke te akpaa nombiakumɛɛyɛɛre dokoloŋ de kyɛɛkee lee ɔ gbɛɛneŋ kumɛɛ man te ɔ kɔŋ Wurubuarɛ gyaŋ nɛ, Wurubuarɛ kpilala baŋ be kyaa adido nɛ baa nyaŋee ɔ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu besewɔ gyɔ dudu kei fa wɔ nyiaa, “Balee ŋolo kyaawɔ na ɔ dana bia baala bala. ");
INSERT INTO ntr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wee daale balee kei bu kemaasa ŋon yako ɔ kya nyiaa, ‘Taata, kpala nya abɔɔ ŋan n dana nɛ na n ka mo me wui fa maŋ.’ Mena dɔɔ ɔ kya ŋon kpala wa abɔɔ ŋan fa ɔ bia baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Te di weeya ala ya te ɔ bu kemaasa ŋon yɔɔ abɔɔ ŋan ɔ be nyim nɛ pou te ɔ moo kɔba keŋ do ɔ wose man te ɔ moo ɔ nyee baŋ tɛɛle wɔle daale man. Ɔ ke gyu botɔɔ nɛ, ɔ moo kɔba keŋ ɔ dana nɛ ke yɛɛ kehuhoori wɔlɛɛ ke pou. ");
INSERT INTO ntr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ɔ ke wɔlɛɛ kɔba keŋ pou taŋ nɛ, tanam dinaa daale yalawɔ tɛɛle kenaŋ pou dɔɔ te ɔ wose kyaŋa e nideli. ");
INSERT INTO ntr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mena dɔɔ ɔ gyuuwɔ ɔ kaa di paa fa donɔɔte ŋolo, te donɔɔte ŋon moo e gyu nyi waa gyu ke kɛɛ ɔ kekuiriise dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na nafɔ ɔ loo gyakaa nyi waa nyiŋ kekuiriise baŋ weenɛɛ ŋan ŋaale di, mɔna ŋolo te fa e ŋa ya. ");
INSERT INTO ntr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ɔ sia ke ŋmaŋee e nɛ ɔ yako ɔ wose nyiaa, ‘Me kya tewulɛɛ pou ne dii baa kaase, te maŋ kyaa kɛbo keŋ tanam ne gyae ke kara ma nyee?’ ");
INSERT INTO ntr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maa koro na maa bese gyu me kya gyaŋ na me kaa yako e nyiaa, ‘Taata, ma te yɛɛ nombiakumɛɛ tia Wurubuarɛ te ma te yɛɛ tia nyaŋ mɔ. ");
INSERT INTO ntr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mena dɔɔ ma tekaboena nyi nya baake maŋ n bu bela ya, mo maŋ yɛɛ ŋgba n tewulɛɛ baŋ man ŋolo nɛ.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mena dɔɔ ɔ korowɔ mo gbɛɛ ɔ ne gyu ɔ kya gyaŋ. Debaŋ keŋ ɔ dɔŋɛɛ lemlem ɔ ne kɔŋ dɛɛ nɛ, ɔ kya naa e te ɔ bu ŋon nombia yɛɛ e waraŋase te ɔ yeuwɔ kegyaŋee na e te ɔ pukaa e nyaŋee na e. ");
INSERT INTO ntr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Botɔɔ te ɔ bu ŋon yako e nyiaa, “Taata, ma te yɛɛ nombiakumɛɛ tia Wurubuarɛ te ma te yɛɛ tia nyaŋ mɔ. Mena dɔɔ ma tekaboena nyi nya baake maŋ n bu bela ya. Mo maŋ yɛɛ ŋgba n tewulɛɛ baŋ man ŋolo nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Keŋte ɔ kya ŋon baake ɔ tewulɛɛ baŋ yako wɔ nyiaa, “Ɛ kaŋ ɛ wose na ɛ ka lese kegba dɔɔloŋ kpaakpaate keŋ kɔŋ kaa do e. Ɛ do e kɔlabia ɔ nyiŋmaa man na ɛ ka do e nkyokotase. ");
INSERT INTO ntr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na ɛ ke gyu ka mo nunkyue baale dinaa ŋon kɔŋ kaa ko na dee di de nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nawolo nyi yɛɛ yaa ŋgba me bu kei yeŋae te ɔ besewɔ foŋ nɛ. Nafɔ na ɔ ta yoo te nɛnɛɛ ma te naa e bela.” Keŋte be fiasɛɛ bɛɛ nyaŋee na bee di be nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Debaŋ keŋ bɛɛ yɛɛ kɛŋa pou nɛ, na ɔ bu kegyia ŋon kyaa wɔɔman. Ɔ ka lee wɔɔ ɔ ne kɔŋ te ɔ ba benaa dɛɛ nɛ, ɔ nyii nɔɔneŋ na suya ne tao kela. ");
INSERT INTO ntr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Keŋte ɔ baake ɔ kya tewulɛɛ baŋ man ŋolo bɔɔse e kpene keŋ be kɔŋ dekpaŋalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Te ɔ tiranɔɔ fa e nyiaa, “N naabu ŋon ta bese kɔŋ donɔɔ te n kya koo nunkyue baale dinaa ŋon, nawolo nyi ɔ ta bese kɔŋ dɛɛ na nyeedoŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Botɔɔ te ɔ bu kegyia ŋon gyeŋa baŋ bɛɛ nyi ɔ ba gyoo dekpaŋalaŋ keŋ man bela ya. Ɔ kya ke nyii mena na te ɔ leewɔ kɔŋ kaa waase e nyi waa gyoo dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Keŋte ɔ yako ɔ kya nyiaa, “Taata nyaŋ kɛɛ, kulutooneŋ kɛŋa pou me kyaa mɛɛ som neŋ ŋgba gbeŋi nɛ, te ma te yɛɛ deŋele doŋ n dɔɔ ya. Woŋ te n faa maŋ? N te faa ta maŋ asoobii paŋpaŋ gba na daa na me gyoona mɔ kedi de nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mɔna n bu kei ŋon ɔ ba mo nya abɔɔ pou ke wɔlɛɛ futooli ala dɔɔ te ɔ ba bese kɔŋ donɔɔ nyiŋmaase wolo nɛ te n koo nunkyue baale dinaa ŋon fa.” ");
INSERT INTO ntr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Keŋte ɔ kya ŋon yako e nyiaa, “Me bu, debaŋ kamasɛ n kyae me gyaŋ te kpene kamasɛ keŋ me dana nɛ yɛɛ n wui. ");
INSERT INTO ntr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mɔna kaboena nyi dee di de nɔɔ na dɛɛ nyaŋee. Nawolo nyi yɛɛ yaa ŋgba n naabu kei yeŋae te ɔ besewɔ foŋ nɛ, nafɔ na ɔ ta yoo te nɛnɛɛ da te naa e.” ");
INSERT INTO ntr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Keŋte Yesu gyɔɔ dudu fa ɔ kaseela baŋ nyiaa, “Kɔbate ŋolo kyaawɔ keŋ ɔ dana tobaale ŋon ɔ ne kɛɛ wa abɔɔ pou dɔɔ, te be yako balee ŋon nyi ɔ tobaale ŋon ne wɔlɛɛ ɔ kɔba. ");
INSERT INTO ntr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mena dɔɔ balee ŋon baake ɔ tobaale ŋon te ɔ bɔɔse e nyiaa, woŋ nombia yaa mee nyii lee n wose man nɛ? Kɔŋ kaa bu abɔɔ ŋan pou doo n nyiŋmaa man nɛ akɔntaa fa maŋ, nawolo nyi n ba tekaa kɛɛ ma abɔɔ dɔɔ bela ya.” ");
INSERT INTO ntr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Botɔɔ te tobaale ŋon yakowɔ ɔ nyee man nyiaa, “Me gbeŋgyoo ne gyae waa gegi maŋ lee ma tom man. Sena te maa yɛɛ? Mɔɔ taŋ doŋ me kaa fara ya, te abɔɔ kasolee mɔ dana maŋ desɛŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Keŋte ɔ yako ɔ wose nyi me ta gyeŋ kpene keŋ maa yɛɛ keŋ nyi akpaa ma tom de wɔlɛɛ na, maa nyiŋ balaŋ baŋ baa lɛɛ maŋ be dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mena dɔɔ ɔ baake balaŋ baŋ pou be dana ɔ gbeŋgyoo ŋon koma nɛ dokoloŋ dokoloŋ. Keŋte ɔ bɔɔse gyaŋgbate ŋon nyiaa, “Kom aŋmoŋ te n dana me gbeŋgyoo?” ");
INSERT INTO ntr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Keŋte ɔ tiranɔɔ fa nyiaa, “Nuŋ garawaase sɔŋonaara na kufu (90).” Te tobaale ŋon lese ɔ kom tɔne keŋ fa e te ɔ yako e nyiaa, “Tisi kyaa bileŋ na n ke kyɛɛkee ke yɛɛ garawaase sɔŋola na anoŋ (45).” ");
INSERT INTO ntr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Keŋte ɔ besewɔ bɔɔse balate ŋon mɔ nyi, “Kom aŋmoŋ te nyaŋ dana me gbeŋgyoo?” Te ŋon mɔ tiranɔɔ fa e nyiaa, “Maŋ dana e kom kameese tasase kakpoŋ (1000).” Keŋte tobaale ŋon lese ɔ kom tɔne fa e te ɔ yako e nyiaa, “Kyɛɛkee ke yɛɛ sɔŋonoŋse akpeŋ gyanaara (800).” ");
INSERT INTO ntr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ɔ gbeŋgyoo ŋon ke nyii wa ayɛɛŋ nɛ, ɔ kɛlɛɛ ɔ tobaale nkontopoote ŋon nyi ɔ gyeŋ adao nideli. Nawolo nyi tɛɛle kei dɔɔ balaŋ gyeŋ adaosebia ŋan baa mo kyaa na be tebia kela balaŋ baŋ bee yee Wurubuarɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyi ɛ mo tɛɛle kei dɔɔ abɔɔ yɛɛ deeli lese gyoori, na akpaa abɔɔ ŋan de taŋ nɛ, na ke yela Wurubuarɛ ke lɛɛ ŋon na ɛ ke kyaa ɔ gyaŋ kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Walaŋ kamasɛ ŋon ɔ ne di anokoare kolo peperee dɔɔ kekɛɛ man nɛ, waa di anokoare kolo dinaa mɔ dɔɔ kekɛɛ man. Te walaŋ kamasɛ ŋon ɔ bee di anokoare kolo peperee dɔɔ kekɛɛ man ya nɛ, ɔ be gyae waa di anokoare kolo dinaa mɔ dɔɔ kekɛɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Akpaa nyi n bee di anokoare tɛɛle kei dɔɔ abɔɔ kekɛɛ dɔɔ ya na, amɔte ne gyae la waa mo abɔɔ kpaakpaa ŋan ŋe dana tɔnɔɔ Wurubuarɛ man nɛ do neŋ n nyiŋmaa man? ");
INSERT INTO ntr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te akpaa n te di anokoare kɛɛ ŋolo abɔɔ dɔɔ nideli ya na, amɔte ne gyae la waa sɛɛ mo nyaŋ gbagba wui do neŋ n nyiŋmaa man? ");
INSERT INTO ntr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tobaale kamasɛ be gyae waa tale som gbeŋgyoona bala ya. De kɔŋ mena na waa kɔla ŋolo na waa gyae ŋolo nombia, yaa waa som ŋolo kela ŋolo. Ɛ be gyae ɛ ke tale som Wurubuarɛ na kɔba bom ya.” ");
INSERT INTO ntr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farasiitena baŋ be sia ne yɛɛ kɔba dɔɔ nideli ke nyii nombia kɛŋa nɛ, ba boŋo Yesu kulu e. ");
INSERT INTO ntr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Keŋte Yesu yako wɔ nyiaa, “Ɛmɛɛ yɛna balaŋ baŋ ɛ ne desina ɛ wose balaŋ siaman, mɔna Wurubuarɛ gyeŋ ɛ konɔɔse man. Nawolo nyi kpene kamasɛ keŋ balaŋ ne bu ke nideli nɛ, ke yɛɛ kolo anekɔlaŋ ke Wurubuarɛ siaman. ");
INSERT INTO ntr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Wurubuarɛ mmaraase ŋan, na Wurubuarɛ akpeŋkpeŋgyɔɔra nombia ŋan dɔɔ te balaŋ ne dii pɛte Gyɔn Wurubuarɛ loŋsɔɔre ŋon kɔŋawɔ. Lee mena debaŋ keŋ Gyɔn be kɔŋ pou na, bee kolosi Wurubuarɛ gyoori keŋ wose man nombia kpaakpaa ŋan, te walaŋ kamasɛ na peree nyi waa gyoo ke man. ");
INSERT INTO ntr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dana doŋ nyi kolo bii peperee ka yo lee Wurubuarɛ mmaraase ŋan man, kela nyi adido na ateta ke ŋaalaa. ");
INSERT INTO ntr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Walaŋ kamasɛ ŋon ɔ bɛɛ ɔ wɛɛle te ɔ yala alo wɔle nɛ, Wurubuarɛ siaman na ɔtenate gyae ŋolo wɛɛle baa Te walaŋ kamasɛ ŋon mɔ ɔ yala alo ŋon ɔ baale be bɛɛ e na, Wurubuarɛ siaman na ɔtenate mɔ gyae ŋolo wɛɛle baa.” ");
INSERT INTO ntr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Keŋte Yesu besewɔ yako nyiaa, “Kɔbate ŋolo kyaawɔ keŋ ɔ na do abɔɔ kpaakpaa nyiŋan ŋan ŋe dana koyadoŋ te ɔ ne di gyoŋ wee kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wee na wee mɔ na, bɛɛ mo balee diyemte ŋolo ŋon bɛɛ baake e nyi Lasarose nɛ, kaa see kɔbate ŋon denanɔɔ man. Na Lasarose kei wose pou te kulii gyamɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɔ ne kɔŋ kaa kyaa botɔɔ gyakaa loo nyi waa nyiŋ kɔbate ŋon weenɛɛ ŋan ne yale tɛɛle man nɛ ŋaale di. Na babaase gba ne kɔŋ kaa deŋee ɔ gyamɛɛ ŋan. ");
INSERT INTO ntr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wee daale nɛ, balee diyemte ŋon kaa yeŋawɔ te be wuu e te Wurubuarɛ kpilala kaa seele ɔ woo gyu Aberaham gyaŋ Wurubuarɛ man. Kenaŋ wɔle te kɔbate ŋon mɔ kaa yeŋawɔ te be wuu e te ɔ gyuuwɔ ka gyoo boalaŋ keŋ ke bɛɛ yem ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ɔ ke doo botɔɔ ɔ ne naa diyem nɛ, ɔ gyinaa ɔ sia kɛɛ adido na te ɔ naa Aberaham lemlem na Lasarose ŋon kyaa ɔ yenaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Botɔɔ te kɔbate ŋon gyinaa ɔ nɔɔ baake Aberaham nyiaa, ‘Me kya Aberaham! Wii me waraŋase na n ke yela Lasarose ka mo ɔ nyimbii ke sɔɔ loŋ man, na waa mo kaa tina me laakem na ma wose ke fɛɛ maŋ kyomii, nawolo nyi mɛɛ naa diyem nideli boalaŋ kei man!’ ");
INSERT INTO ntr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Keŋte Aberaham tiranɔɔ fa e nyiaa, ‘Me bu, tɔɔse nyi debaŋ keŋ n kyaa tɛɛle dɔɔ nɛ n nyiŋa abɔɔ kpaakpaa di gyoŋ, na Lasarose ŋon doo diyem man ɔ na yeyɛɛ, te nɛnɛɛ ŋon mɔ ne di gyoŋ kɛbo te nyaŋ mɔ n doo diyem man n na yeyɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te agyakaŋ yɛna nyi, bɔɔ dinaa dinaa daale doo daa na ŋon nsana keŋ nyi baŋ be kyaa kɛbo nɛ be gyae baa tale gbaa kɔŋ ɛ gyaŋ ya, mena mɔ te baŋ be kyaa botɔɔ nɛ be gyae baa tale gbaa kɔŋ de gyaŋ kɛbo ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Keŋte kɔbate ŋon yako e nyiaa, ‘Me kya, kenaŋ na mɛɛ sola neŋ bo, kpila Lasarose ka bese gyu me kya dɛɛ, ");
INSERT INTO ntr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nawolo nyi me dana naabia baala banoŋ na ɔ kaa faree wɔ, na mena ya na baŋ mɔ baa kɔŋ kaa naa diyem boalaŋ kei man.’ ");
INSERT INTO ntr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Keŋte Aberaham yako kɔbate ŋon nyiaa, ‘Ba gyeŋ Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see, na Wurubuarɛ nombia ŋan Wurubuarɛ akpeŋkpeŋgyɔɔra ba wolo nɛ. Mena dɔɔ baa tei nombia ŋenaŋ nideli.’ ");
INSERT INTO ntr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Botɔɔ te kɔbate ŋon tiranɔɔ nyiaa, ‘Koa me kya Aberaham! Akpaa ŋolo da lee woya man kɛbo gyu keyako wɔ nɛ, baa kyɛɛkee lee be nombiakumɛɛ keyɛɛ man na baa kɔŋ Wurubuarɛ gyaŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Keŋte Aberaham yako e nyiaa, ‘Nyi akpaa be te nyii Mosesi na Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ nombia ya nɛ, mena mɔ te ŋolo de fom lee yeŋ man kɛbo gyu be gyaŋ koraŋ na bɔɔ gyae baa taŋ bua e ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Abɔɔ ŋan ne yeli balaŋ ne yɛɛ dukum nɛ gyae ke kɔŋ, mɔna nyaŋ ŋon ŋe gyae ke ta n dɔɔ kɔŋ nɛ nya laako! ");
INSERT INTO ntr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Akpaa nyi ba mo boe dinaa dinaa kpaŋ n wɔŋe man te be fuŋ neŋ do ɛpo man nɛ, dei fa neŋ kela nyi n ke yela bia buruburu kɛwɔ man ŋolo keyɛɛ dukum. ");
INSERT INTO ntr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mena dɔɔ ɛ kɛɛ ɛ wose nideli. Akpaa n dɔɔ de yɛɛ neŋ dukum na lese si e, te akpaa ɔ nyii ɔ wose asɛɛ te ɔ kyɛɛkee na mo kyɛɛ e. ");
INSERT INTO ntr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Akpaa ɔ yɛɛ nombiikum tia neŋ betabonyetooro wee dokoloŋ, te ɔ bese kɔŋ n gyaŋ betabonyetooro wee dokoloŋ kenaŋ kaa doo neŋ teree na mo kyɛɛ e.” ");
INSERT INTO ntr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Keŋte Yesu kpilala kufu bala baŋ yako e nyiaa, “De Gbeŋgyoo, yela da kelɛɛdi ka bo kpu.” ");
INSERT INTO ntr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Keŋte de Gbeŋgyoo Yesu yako wɔ nyiaa, “Akpaa ɛ kelɛɛdi yɛɛ peperee ŋgba kefaabii koraŋ nɛ, ɛ ke tale yako daŋ nyi ‘Kulu na n lila pou na n kaa seŋ ɛpo man, te gyae ke kɔŋ mena.’ ");
INSERT INTO ntr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dɛɛ mo ke nyi ɛ man ŋolo dana tobaale ŋon ɔ ne fare fa e yaa ɔ ne kɛɛ ɔ namense dɔɔ. Akpaa tobaale ŋon da lee ŋale man kɔŋ nɛ, ɔ gbeŋgyoo ŋon bɛɛ yako e nyi tisi kyaa bileŋ na n kedi ya. ");
INSERT INTO ntr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mɔna ɔ ne yako e bo nyi, ‘Desina n wose na n ke saa me balinɔɔ weenɛɛ fa maŋ na n ke kyaa daa maŋ maa di na maa nyɔɔ, me taŋ na pɛna nyaŋ mɔ n kaa di na n ke nyɔɔ.’ ");
INSERT INTO ntr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kaboena nyi balee ŋon waa do ɔ tobaale ŋon nɔɔ nyi ɔ te yɛɛ kpene keŋ ɔ be yako e nyi waa yɛɛ dɔɔ? Koa. ");
INSERT INTO ntr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mena te doo fa ɛmɛɛ mɔ, nyi akpaa ɛ yɛɛ kpene kamasɛ keŋ mɔɔ yako ŋon nyi yaa yɛɛ nɛ, kaboena yaa yako nyi de taŋ yɛɛ n tewulɛɛwɔ, tom keŋ kaboena nyi dɛɛ yɛɛ nɛ te de yɛɛwɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu ka mo ɔ nyee baŋ ɔ ne gyu Gyerusalɛm donɔɔ man nɛ, ɔ tɛɛwɔ Samaria na Galelia tɛɛlese wulu man. ");
INSERT INTO ntr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Debaŋ keŋ ɔ na gyoo akuraa daale man nɛ, balaŋ kufu baale baŋ bɛɛ wee kawee yayam nɛ kɔŋawɔ be kaa gyaŋee na e te be dɔɔwɔ seŋ lemlem, ");
INSERT INTO ntr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","keŋte be gyinaa be nɔɔ nyiaa, “De Gbeŋgyoo Yesu! Waaseda wii de waraŋase!” ");
INSERT INTO ntr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu kena wɔ keŋ nɛ, ɔ yako wɔ nyiaa “Ɛ mo ɛ wose kawola Wurubuarɛ saese baŋ.” Be kee gyuu nɛ te be kaweese ŋan taŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Be man ŋolo kena nyi ɔ kawee te taŋ nɛ, ɔ besewɔ kɔŋ Yesu gyaŋ na ɔ ne fae yeesa lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Keŋte ɔ kaa buŋawɔ Yesu nawɔɔtɛɛ do e nɔɔ. Na mena balee kei yɛɛ Samaria baale e. ");
INSERT INTO ntr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Botɔɔ te Yesu bɔɔsewɔ nyiaa, “Na balaŋ kufu te me kyɔɔwɔ yee? Te nde balaŋ kadaale akaŋ baŋ? ");
INSERT INTO ntr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Weera dɔɔ te ŋɔɔle kei waageŋ yɛna walaŋ ŋon ɔ ba bese kɔŋ ɔ kaa fa Wurubuarɛ karaŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Botɔɔ te Yesu yako e nyiaa, “Koro na n ke ta, n kelɛɛdi dɔɔ te n nyiŋa kawee kekyɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wee daale nɛ Farasiitena baale bɔɔse Yesu nyiaa, debaŋ woŋti te Wurubuarɛ gyoori keŋ gyae ke kɔŋ. Keŋte Yesu tiranɔɔ fa wɔ nyi, “Wurubuarɛ gyoori keŋ be gyae ke kɔŋ na ɛ kena ke na ɛ sia fonɛɛ nyi kɛɛ kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ŋolo be gyae waa yako ŋon nyiaa ‘Ɛ kɛɛ, keŋ yaa kɛbo,’ yaa ke kyaa yenaŋ daale ya! Nawolo nyi Wurubuarɛ gyoori keŋ kyaa ɛ man.” ");
INSERT INTO ntr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Debaŋ daale gyae kekɔŋ keŋ ɛ ke gyae nyi ɛ ka bese naa maŋ Deniwalaŋ Bu ŋon kekyaa man wee dokoloŋ gba, mɔna ɛ be gyae ɛ kena ya.” ");
INSERT INTO ntr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Balaŋ baa yako ŋon nyiaa, “Ɔ kyaa kɛbo, yaa ɔ kyaa yenaŋ daale! Mɔna ɛ na yekii sila wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nawolo nyi wee keŋ maŋ Deniwalaŋ Bu ŋon maa bese kɔŋ nɛ, walaŋ kamasɛ waa naa maŋ ŋgba mena keŋ ɔga ne ŋmaale adido te walaŋ kamasɛ ne naa ka keŋmaŋee keŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mɔna kaboena nyi maa taŋgbɛɛ naa diyem nideli, na gyɛŋ wee kei balaŋ ke bɛɛ maŋ pɛ. ");
INSERT INTO ntr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mena keŋ be kɔŋ Nowa kekyaa man nɛ, mena mɔ te gyae ke kɔŋ maŋ Deniwalaŋ Bu ŋon ka bese kɔŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mena Nowa weeya ŋenaŋ man nɛ, na balaŋ gyakaa bee dii na bɛɛ nyɔɔ, na ala na baala mɔ ne yala dɔŋa kelii debaŋ keŋ Nowa ba gyoo adakaa keŋ man te loŋ keŋ waalewɔ kaa koe balaŋ pou. ");
INSERT INTO ntr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mena mɔ te yɛɛwɔ Lɔɔte kekyaa man. Balaŋ gyakaa bee dii na bɛɛ nyɔɔ, na baale ne yɔɔ abɔɔ na baale mɔ ne lɛɛ, na baale ne duu abɔɔ na baale mɔ ne ma denɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mɔna wee keŋ Lɔɔte ba lee Sodom donɔɔ man nɛ, Wurubuarɛ yela boalaŋ na kpatakpela leewɔ adido kɔŋ kaa kpa Sodom donɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mena mɔ te wee keŋ maŋ Deniwalaŋ Bu ŋon maa bɛɛ lee nɛ gyae ke futaa balaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mena wee kenaŋ nɛ walaŋ kamasɛ ŋon ɔ be kyaa ɔ deni man ya te wa abɔɔ doo ɔ deni man nɛ, ɔ na bese gyu ka lese ŋa ya. Mena mɔ te walaŋ ŋon ɔ kyaa wɔɔman nɛ ɔ na bese gyu dɛɛ nyi ɔ kaa mo ɔ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɛ na wolee kpene keŋ be kɔŋ Lɔɔte wɛɛle dɔɔ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Walaŋ kamasɛ ŋon ɔ ne gyae nyi waa lɛɛ ŋon gbagba nyeedoŋ na ke gyae ka lee ɔ nyiŋmaa man, mɔna walaŋ ŋon ɔ nyeedoŋ da lee ɔ nyiŋmaa man lee maŋ dɔɔ nɛ waa bese nyiŋ ke. ");
INSERT INTO ntr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyi mena wee kenaŋ nelim nɛ balaŋ bala baa doo dofoŋoŋ dokoloŋ dɔɔ, mɔna Wurubuarɛ waa mo ŋolo tina ŋolo yela. ");
INSERT INTO ntr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ala bala baa seŋ debodokoloŋ bɛɛ naŋ abɔɔ, mɔna Wurubuarɛ waa mo ŋolo tina ŋolo yela. ");
INSERT INTO ntr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mena mɔ te baala bala baa seŋ wɔɔman bɛɛ yɛɛ tom, mɔna Wurubuarɛ waa mo ŋolo tina ŋolo yela.” ");
INSERT INTO ntr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Botɔɔ te ɔ kaseela baŋ bɔɔse e nyiaa, “De Gbeŋgyoo, aleŋ gbɛɛ te mena nombia kɛŋa pou gyae kekɔŋ?” Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Botɔɔ keŋ kolo punta doo nɛ, botɔɔ te bapɛtɛɛna ne yilaa.” ");
INSERT INTO ntr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Keŋte Yesu gyɔɔ dudu fa ɔ kaseela baŋ wola wɔ nyiaa, kaboena nyi baa fane wee kamasɛ keŋ ba wose na yɔkɔse wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ɔ yako wɔ nyiaa “Donɔɔ daale man nɛ nombiadiiri ŋolo kyaawɔ keŋ ɔ bee yee Wurubuarɛ ya, te ɔ be famenɛ na walaŋ mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na lialo ŋolo mɔ kyaa donɔɔ kenaŋ man. Ɔ ne kyaa kɔŋ nombiadiiri ŋon gyaŋ kaa waase e wee kamasɛ nyiaa, ‘Kɛɛ na n ke di daa na me walaŋ ŋon daa na e be nyim nɛ nombia ŋan nideli fa maŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nafɔ nombiadiiri ŋon bɛɛwɔ kelii debaŋ daale, mɔna wɔle wɔle nɛ ɔ yako ɔ wose nyiaa, ‘Yɛɛ ampaŋ nyi mɔɔ ne yee Wurubuarɛ ya te mɔɔ famenɛ na walaŋ mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mɔna alo kei nombia te poro maŋ mena dɔɔ maa kɛɛ na maa di ɔ nombia ŋan nideli fa e, na ɔ be nyiŋ gyem tisi me dɔɔ naase maŋ diyem bela ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Botɔɔ te Yesu yakowɔ nyiaa, “Ɛ nyii kpene keŋ nombiadiiri kum kei be yako. ");
INSERT INTO ntr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Akpaa mena na Wurubuarɛ be gyae waa di nombia anokoare man fa ɔ balaŋ baŋ bee wii baake e nelim na ka weese nɛ yee? Ɛ ne lɛɛdi nyi waa wɔŋee ɔ wose nyi ɔ be kyɔ wɔ yee? ");
INSERT INTO ntr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mɛɛ yako ŋon ɛ ke nyii nyiaa, Wurubuarɛ waa di nombia ŋan anokoare man fa wɔ bileŋ na waa yela baa di deŋele. Te nyi akpaa maŋ Deniwalaŋ Bu ŋon ma bese kɔŋ na, balaŋ baa kyaa tɛɛle kei dɔɔ keŋ baa lɛɛ maŋ di?” ");
INSERT INTO ntr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu besewɔ gyɔ dudu kei fa balaŋ baŋ bɛɛ kɛɛ ba wose gyɔ konɔɔ nyi be gbɛɛneŋ tenɛɛ Wurubuarɛ siaman, te bɔɔ na mo walaŋ kamasɛ yɛɛ kolo ya nɛ nyiaa! ");
INSERT INTO ntr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Baala bala baale gyuu Wurubuarɛ ɔsom deni dinaa keŋ man be kaa fane. Ŋolo yɛɛ Farasii baale e te ŋolo mɔ yɛɛ lempoolɛɛre e. ");
INSERT INTO ntr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasii baale ŋon korowɔ seŋ te ɔ fanewɔ kɛlɛɛ ɔ wose nyiaa, ‘Wurubuarɛ mɛɛ fa neŋ karaŋ nyi ma te yɛɛ nombiakumɛɛyɛɛre e ŋgba balaŋ akaŋ baŋ nɛ ya. Mɔɔ yɛɛ ŋgba ŋmɛɛlatena na balaŋ kumɛɛ na kafoŋtena yaa ŋgba lempoolɛɛre kei nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mɛɛ bake me nɔɔ betabola weeya nyetooro kamasɛ man, te mɛɛ kpase ma kpene kamasɛ keŋ mee nyim nɛ akpeŋ kufu na me ta mo dekpeŋ dokoloŋ fa nyaŋ Wurubuarɛ.’ ");
INSERT INTO ntr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mɔna lempoolɛɛre ŋon dɔɔ, ŋon gyuuwɔ ka seŋ yenaŋ keŋ nyi ɔ te gyina ɔ sia kɛɛ adido gba ya te ɔ moo ɔ nyiŋmaase gyakaa ɔ konɔɔ dɔɔ waraŋase man yako nyiaa, ‘Wurubuarɛ, wii maŋ nombiakumɛɛyɛɛre kei waraŋase.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Keŋte Yesu yakowɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyi ba ke fane taŋ nɛ, lempoolɛɛre ŋon te Wurubuarɛ lɛɛwɔ do nyi ɔ gbɛɛneŋ tenɛɛ ŋon Wurubuarɛ siaman. Nawolo nyi walaŋ kamasɛ ŋon ɔ gyina ɔ wose adido na Wurubuarɛ waa yɔkɔse e, te walaŋ kamasɛ ŋon ɔ yɔkɔse ɔ wose na Wurubuarɛ waa gyina e adido.” ");
INSERT INTO ntr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wee daale balaŋ baale moo be bia kɔŋ nyi Yesu waa mo ɔ nyiŋmaa gyakaa be dɔɔ na waa hiraa wɔ. Ɔ kaseela baŋ kena mena nɛ, be ŋmanyaŋ balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Keŋte Yesu baake bia baŋ kɔŋ ɔ gyaŋ te ɔ yakowɔ nyiaa, “Ɛ yela bia baŋ kekɔŋ me gyaŋ, ɛ na tɔ wɔ gbɛɛ ya. Nawolo nyi Wurubuarɛ gyoori keŋ yɛɛ balaŋ baŋ bɛɛ yɔkɔse ba wose ŋgba bia kɛwɔ dinɔɔ nɛ wui. ");
INSERT INTO ntr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ampaŋ yaa mɛɛ yako ŋon nyiaa, walaŋ kamasɛ ŋon ɔ te yɔkɔse ɔ wose do Wurubuarɛ tɛɛ ŋgba biikyaa e ya nɛ, ɔ be gyae waa gyoo Wurubuarɛ gyoori keŋ man korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wee daale nɛ Gyudatena siamante ŋolo kaa bɔɔse Yesu nyiaa “De Gbeŋgyoo kpaakpaa, woŋ te maa yɛɛ na maa nyiŋ nyeedoŋ kekpaa keŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Botɔɔ te Yesu bɔɔse e nyiaa, “Woŋ dɔɔ te n ne baake maŋ walaŋ kpaakpaa? Lee Wurubuarɛ wɔle nɛ walaŋ kamasɛ be kyaa keŋ ɔ yɛɛ walaŋ kpaakpaate e ya.” ");
INSERT INTO ntr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ŋgba n gyeŋ Wurubuarɛ mmaraase ŋan ne yako nyi, “Na lee n baale yaa n wɛɛle wɔle ya, na ko walaŋ ya na ŋmɛɛle ya, na kara n dɔɔ nɔɔ ya. Bu n kya na n naa nɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Keŋte balee ŋon mɔ tiranɔɔ nyiaa “Me wulaa mee di mmaraase kɛŋa pou dɔɔ leenaŋ me biatɛɛ” ");
INSERT INTO ntr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu ke nyii ɔ nɔɔwoya ŋan nɛ ɔ yako e nyiaa, “Ta bese ka neŋ kolo dokoloŋ kooŋ n ke yɛɛ. Gyu ke yɔɔ nya abɔɔ ŋan pou n dana nɛ na n ka mo kɔba keŋ kpɛlɛɛ ayematena na n ke kɔŋ kaa sila maŋ. N yɛɛ mena na n ke nyiŋ abɔɔ kpaakpaa see n wose Wurubuarɛ gyaŋ adido.” ");
INSERT INTO ntr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Balee ŋon ke nyii nombia kɛŋa nɛ, takaa e nideli nawolo nyi ɔ dana abɔɔ burum. ");
INSERT INTO ntr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Keŋte Yesu gɛɛsewɔ kɛɛ e te ɔ yakowɔ nyiaa, “Gyae ke yɛɛ doŋ fa baŋ be dana kɔba nɛ nyi baa gyoo Wurubuarɛ gyoori keŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mɛɛ yako ŋon ɛ ke nyii nyiaa, gyae ke yɛɛ doŋ fa baŋ be dana kɔba nɛ nyi baa gyoo Wurubuarɛ gyoori keŋ man, kela nyi kurumɔɔ ka gyoo ŋarale bɔɔ man lee.” ");
INSERT INTO ntr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Balaŋ baŋ ke nyii nombia kɛŋa nɛ be bɔɔse e nyiaa, “Nyi nnɛ te doo na, amɔte ne gyae la waa nyiŋ nyeekelɛɛ baa?” ");
INSERT INTO ntr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Keŋte Yesu tiranɔɔ nyiaa, “Kpene keŋ deniwalaŋ be gyae waa tale yɛɛ ya nɛ, Wurubuarɛ dɔɔ waa tale yɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Botɔɔ te Pita yakowɔ nyiaa, “De gbeŋgyoo, daa dɔɔ de te tina kpene kamasɛ keŋ de dana nɛ yela, te de dɔŋɛɛ de silana neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Keŋte Yesu yako wɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ kamasɛ ŋon ɔ be tina ɔ dekpaŋalaŋ yaa ɔ wɛɛle yaa ɔ naabia yaa ɔ kya na ɔ naa yaa ɔ bia yela lee Wurubuarɛ gyoori keŋ dɔɔ nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","waa bese nyiŋ ŋa burum kpu gyɛŋ weeya kɛŋa man, na waa bese nyiŋ nyeedoŋ kekpaa wee daale.” ");
INSERT INTO ntr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wee daale nɛ Yesu baake ɔ kaseela kufu bala baŋ lee yenaŋ te ɔ yako wɔ nyiaa, “Dee gyu Gyerusalɛm donɔɔ man baa, te kpene kamasɛ keŋ Wurubuarɛ akpeŋkpeŋgyɔɔra be ŋmarase lee maŋ Deniwalaŋ Bu ŋon wose man nɛ, gyae ke kɔŋ mena. ");
INSERT INTO ntr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Baa mo maŋ do balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ nyiŋmaa man, na baa kulu maŋ na baa tee maŋ na baa tɔ nɔɔloŋ woli maŋ na baa tuku maŋ na baa ko maŋ. ");
INSERT INTO ntr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mɔna weeya atoorote keŋ nɛ, Wurubuarɛ waa gyuusu maŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesu kaseela baŋ te nyii nombia kɛŋa man ya, nawolo nyi Wurubuarɛ ta lese ŋe man wola wɔ ya mena dɔɔ be te nyii ŋe man dokoloŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu kɛɛ benaa Gyeriko donɔɔ man nɛ, na siayɛlɛɛsate ŋolo kyaa gbɛɛnaa man ɔ na solee abɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ɔ ke nyii balaŋ burum baŋ kɛɛ lam nɛ, ɔ bɔɔse wɔ nyi woŋ kɔŋala? ");
INSERT INTO ntr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Keŋte balaŋ baŋ yako e nyiaa “Yesu Nasarɛte baale ŋon ne laŋa laa.” ");
INSERT INTO ntr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Botɔɔ te ɔ gyinaa ɔ nɔɔ baake nyiaa, “Yesu, Defidi ɔ naanabii! Wii me waraŋase!” ");
INSERT INTO ntr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Balaŋ baŋ be dɔŋɛɛ siaman nɛ ŋmanyaŋ e nyi waa wu ɔ nɔɔ. Mɔna nɛnɛɛ gba te ɔ desinaa fae yeesa nedoŋ nyiaa, “Defidi ɔ naanabii! Wii me waraŋase.” ");
INSERT INTO ntr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mena dɔɔ Yesu seŋawɔ te ɔ yakowɔ nyi baa mo siayɛlɛɛsate ŋon kɔŋ ɔ gyaŋ. Ɔ ka benaa e nɛ, Yesu bɔɔse e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Woŋ te n ne gyae nyi maa yɛɛ fa neŋ?” Keŋte siayɛlɛɛsate ŋon tiranɔɔ nyiaa, “Me Gbeŋgyoo, mɛɛ gyae me sia ke gyuusu.” ");
INSERT INTO ntr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Keŋte Yesu yako e nyiaa, “N sia dee gyuusu na n kena. N ke lɛɛ maŋ di dɔɔ te n nyiŋa kawee kekyɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Debokenaŋ man te ɔ sia gyuusuwɔ, te ɔ naawɔ te ɔ sila Yesu na ɔ na lese Wurubuarɛ yele. Balaŋ dikpii keŋ pou kena nɛ, baŋ mɔ lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ke gyu ka gyoo Gyeriko donɔɔ man ɔ ne lam nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","na balee ŋolo kyaa botɔɔ keŋ ɔ yele yɛna Sakio. Ɔ yɛɛ lempoolɛɛra kegyia e te ɔ dana kɔba mɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakio kei gyaewɔ nyi waa naa Yesu mɔna ɔ yɛɛ walaŋ duguŋte e dɔɔ ɔ te tale naa e ya, nawolo nyi balaŋ baŋ boe. ");
INSERT INTO ntr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mena dɔɔ ɔ kyaŋa gbɛɛ gyu siaman ka gyeŋ daŋ daale, na waa nyiŋ naa e nawolo nyi botɔɔ te Yesu waa kaa mo. ");
INSERT INTO ntr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu kelii daŋ keŋ tɛɛ nɛ ɔ gyinaa ɔ sia kɛɛ adido te ɔ naa Sakio te ɔ baake e nyiaa, “Sakio tisi kɔŋ bileŋ, nawolo nyi gyɛŋ n dɛɛ te maa soo.” ");
INSERT INTO ntr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mena dɔɔ Sakio mɔ tisiwɔ bileŋ kɔŋ te ɔ lɛɛ Yesu gyoŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Balaŋ baŋ pou bɔɔ naa nɛ fiasɛɛ bɛɛ ŋorokotee nyi, “Balee kei ne gyu ɔ kaa soo nombiakumɛɛyɛɛre kei.” ");
INSERT INTO ntr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Be ke gyu ka gyoo Sakio dɛɛ nɛ, ɔ korowɔ kaa seŋ balaŋ baŋ siaman te ɔ yako Yesu nyiaa, “De Gbeŋgyoo kɛɛ, maa kpase ma abɔɔ ŋan pou me dana nɛ yaale fa ayematena. Te akpaa me te sisii ŋolo na maa tɔ e betabonaara kpu” ");
INSERT INTO ntr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Keŋte Yesu yako Sakio nyiaa, “Gyɛŋ Wurubuarɛ te lɛɛ ɛmɛɛ na n dekpaŋalaŋmantena pou nyee, nawolo nyi nyaŋ mɔ n yɛɛ Aberaham ɔ naanabii e. ");
INSERT INTO ntr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nawolo nyi maŋ Deniwalaŋ Bu kɔŋae me kaa kɛo na maa lɛɛ baŋ bɔɔ yoo nɛ nyee.” ");
INSERT INTO ntr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Balaŋ baŋ kee tei mena nombia kɛŋa nɛ, Yesu besewɔ gyɔ dudu fa wɔ nawolo nyi bɛɛ benaa Gyerusalɛm donɔɔ man, na balaŋ gyeŋ nyi Wurubuarɛ gyoori keŋ gyae ke bɛɛ lee debokenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mena dɔɔ Yesu yakowɔ nyiaa, “Balee ŋolo kyaawɔ keŋ ɔ yɛɛ gyooro bu e, te ɔ korowɔ gyu tɛɛle daale dɔɔ lemlem ɔ kaa di gyoori na waa bese kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Debaŋ keŋ ɔ ne gyae waa gyu nɛ ɔ baake ɔ tewulɛɛ kufu baale te ɔ faa wɔ kɔba kyɛɛkyɛɛ te ɔ yako wɔ nyiaa, ‘Ɛ mo kɔba kei besena ɛ wose kelii debaŋ keŋ maa bese kɔŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mɔna ɔ dɛɛtena baŋ bɛɛ gyae ɔ nombia ya, mena dɔɔ be kpila balaŋ gyu keyako donɔɔ keŋ man ɔ ne gyu nɛ kegyiise nyiaa, ‘De bɛɛ gyae balee kei kaa bese de gyoo ya.’ ");
INSERT INTO ntr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mɔna kegyiise baŋ see balee ŋon gyoo te ɔ besewɔ kɔŋ ɔ dɛɛ. Ɔ ka bese kɔŋ nɛ ɔ kpilawɔ baake ɔ tewulɛɛ baŋ ɔ be fa wɔ kɔba nɛ nyi baa kɔŋ, na waa kɛɛ kpene keŋ bɔɔ nyim gyakaa be kɔbase ŋan dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ɔ tobaale gyaŋgbate ŋon kɔŋawɔ kaa yako e nyiaa, ‘Me gbeŋgyoo, kɔba keŋ n ba mo fa maŋ nɛ ta lola kufu kpu na bene keŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Keŋte ɔ gbeŋgyoo ŋon yako e nyiaa, ‘Nyaŋ na keyɛɛ, n yɛɛ tobaale kpaakpaate e! Mena keŋ n be di anokoare abɔɔ peperee kɛŋa man dɔɔ nɛ, maa yela n ke kɛɛ donɔɔse kufu dɔɔ fa maŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɔ tobaale balate ŋon mɔ kɔŋawɔ kaa yako e nyiaa, ‘Me gbeŋgyoo, n kɔba keŋ n ba mo fa maŋ nɛ ta lola anoŋ kpu na bene keŋ.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Botɔɔ te ɔ yako e nyiaa, “Nyaŋ mɔ n ke kɛɛ donɔɔse anoŋ dɔɔ fa maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Keŋte ɔ tobaale ŋolo mɔ kɔŋawɔ kaa yako e nyiaa, “Me gbeŋgyoo, n kɔba keŋ n ba mo fa maŋ nɛ yaa, ma moo ke kpaŋ na kakyeŋgbelaa ka weese. ");
INSERT INTO ntr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nawolo nyi na mee yee neŋ nyi n nombia dana doŋ. N na mo kpene keŋ te yɛɛ n wui ya, te n ne kɔ abɔɔ ŋan n te duu ya nɛ mɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Keŋte ɔ gbeŋgyoo ŋon yako e nyiaa, “N yɛɛ tobaale kum e, nyaŋ gbagba n nɔɔwoya te maa mo bu neŋ fɔɔ. N gyeŋ nyi me nombia dana doŋ te mɛɛ mo kpene keŋ te yɛɛ me wui ya, te mɛɛ kɔ abɔɔ ŋan me te duu ya na, ");
INSERT INTO ntr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","woŋ dɔɔ te n ta mo me kɔba keŋ ka do kɔba dɛɛsee man na me kɔŋ na, me kaa lɛɛ keŋ na ka loŋ keŋ ya?” ");
INSERT INTO ntr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Botɔɔ te be gbeŋgyoo ŋon yako baŋ ba seŋɛɛ botɔɔ nɛ nyiaa, “Ɛ lɛo kɔba keŋ lee ɔ gyaŋ na ɛ ka mo fa walaŋ ŋon ɔ kɔba ba lola kufu kpu nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Keŋte ɔ tewulɛɛ baŋ yako e nyiaa, “De gbeŋgyoo, ŋgba ŋon wulaa ɔ dana kɔba burum?” ");
INSERT INTO ntr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Botɔɔ te be gbeŋgyoo ŋon tiranɔɔ fa wɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyi walaŋ kamasɛ ŋon ɔ wulaa ɔ dana abɔɔ burum nɛ baa mo ŋaale kpu e bela. Te walaŋ kamasɛ ŋon ɔ betaŋ ya nɛ, kyomii keŋ gba ɔ dana koraŋ nɛ baa lɛo ke lee ɔ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Te me kɔlala baŋ ba te gyae nyi maa di gyoori be dɔɔ ya nɛ, ɛ mo wɔ kɔŋ na ɛ kaa koe wɔ me siaman kɛbo.” ");
INSERT INTO ntr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu keyako nombia kɛŋa taŋ nɛ, ɔ tɛɛwɔ balaŋ baŋ siaman te ba moo ba nyee baŋ bee gyu Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ɔ kɛɛ benaa Bɛtifagi na Bɛtani donɔɔse ŋan kyaa oliifi bula keŋ teŋa man nɛ, ɔ kpila ɔ kaseela baŋ man balaŋ bala ");
INSERT INTO ntr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nyiaa, “Ɛ gyu akuraa keŋ kyaa ɛ siaman nɛ man. Ɛ betaa ɛ na gyoo ke man pɛ nɛ, ɛ kena afurum bu ŋolo kpaŋɛɛ keŋ walaŋ na walaŋ te kyaa ta ɔ dɔɔ see ya. Ɛ booli e na ɛ ka mo e kɔna maŋ kɛbo. ");
INSERT INTO ntr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Akpaa ŋolo de bɔɔse ŋon nyi, ‘Weera dɔɔ te ɛ ne booli e?’ na ‘Ɛ yako e nyi de Gbeŋgyoo Yesu ne gyae na e.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Keŋte baŋ Yesu be kpili nɛ gyuuwɔ kena afurum bu ŋon kpaŋɛɛ ŋgba mena keŋ ɔ be yako wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Be kee booli afurum bu ŋon nɛ ɔ gbeŋgyoo bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ ne booli ma afurum bu ŋon?” ");
INSERT INTO ntr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Keŋte be tiranɔɔ fa e nyiaa, “De Gbeŋgyoo Yesu ne gyae na e.” ");
INSERT INTO ntr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Te ba moo afurum bu ŋon kɔna Yesu. Botɔɔ te ɔ kaseela baŋ moo be kanyaŋse gyakaa afurum bu ŋon dɔɔ te be gate Yesu gyakaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu kekyaa ɔ dɔɔ ɔ ne gyuu nɛ, baale fɛlɛɛ be kanyaŋse lɔ gbɛɛnaa man fa e. ");
INSERT INTO ntr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesu kɛɛ gyoo Gyerusalɛm donɔɔ man, te ɔ ka benaa na botɔɔ keŋ gbɛɛ keŋ be tisi lee oliifi bula keŋ nyee man ne kɔŋ ka teŋa man nɛ, ɔ silala burum baŋ pou sia gyeewɔ te be fiasɛɛ bɛɛ fae yeesa lese Wurubuarɛ yele gyoŋ man lee nombia dinaana na gyakoloŋ nombia ŋan bɔɔ naa nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Be fae yeesa yako nyiaa, “Ɛ fa dɛɛ lese gyoo ŋon ɔ ne kɔŋ de Gbeŋgyoo Wurubuarɛ yele man nɛ yele. Wosefɛɛreŋ dɛɛ kyaa adido, te Wurubuarɛ ŋon ɔ kyaa adido mɔ nɛ gyoorobiiri dɛɛ kaboena e.” ");
INSERT INTO ntr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na Farasiitena baale kpuɛ na balaŋ baŋ be silana e nɛ te be yako Yesu nyiaa, “De Gbeŋgyoo, tɔ n silala baŋ nyi baa wu be nɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Keŋte Yesu yako wɔ nyiaa, “Akpaa balaŋ kɛwɔ de wu be nɔɔ koraŋ nɛ, boya gyae ke fae yeesa lese Wurubuarɛ yele.” ");
INSERT INTO ntr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ka benaa Gyerusalɛm donɔɔ te ɔ kena ke nɛ, ɔ wiiwɔ fa ke, ");
INSERT INTO ntr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","keŋte ɔ yakowɔ nyiaa, “Nafɔ akpaa ɛmɛɛ Gyerusalɛmtena deŋ gyeŋ kpene keŋ gyae ke fa ŋon wosefɛɛreŋ gyɛŋ wee kei nɛ, nafɔ na dei. Mɔna ɛ ba gyeŋ ke ya! ");
INSERT INTO ntr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Te weeya ŋaale gyae kekɔŋ keŋ ɛ kɔlala baa kilisi ŋon, na baa tɔ ŋon do lee yenaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na baa wɔlɛɛ ɛmɛɛ na ɛ donɔɔ keŋ pou keŋ nyi boe na boe be gyae ke gyakaa ke dɔɔ dɔɔ ya, nawolo nyi debaŋ keŋ Wurubuarɛ be kɔŋ nyi ɔ kaa lɛɛ ŋon nɛ ɛ bɛɛ e bo.” ");
INSERT INTO ntr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Keŋte Yesu gyuuwɔ ka gyoo Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man. Na balaŋ ne yɔɔ abɔɔ botɔɔ te ɔ gegi wɔ, ");
INSERT INTO ntr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","te ɔ yako wɔ nyiaa, “Wurubuarɛ nombia aŋmaraseŋ see ne yako nyi Wurubuarɛ kpa, ‘Me deni dinaa keŋ gyae ke yɛɛ botɔɔ keŋ baa fane. Mɔna ɛmɛɛ ta besena ke yɛɛ ŋmɛɛlatena dɛɛgyaŋee!’ ” ");
INSERT INTO ntr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wee na wee na Yesu ne kyaa wola balaŋ Wurubuarɛ nombia Wurubuarɛ ɔsom deni dinaa keŋ man. Te saese kegyiise na Gyudatena mmaraa wolala na donɔɔ kegyiise baŋ gyae gbɛɛ nyi baa ko e. ");
INSERT INTO ntr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mɔna be ta gyeŋ gbɛɛ keŋ baa mo kyaŋ e ya, nawolo nyi na balaŋ baŋ pou ne tei ɔ nombia ŋan ɔ na wolo nɛ nideli keŋ bɔɔ ne gyae ŋa ke laŋ wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wee daale Yesu ke kyaa Wurubuarɛ ɔsom deni dinaa keŋ man ɔ na wola balaŋ nombia te ɔ ne kolosi Wurubuarɛ nombia kpaakpaa ŋan fa wɔ nɛ, saese kegyiise na Gyudatena mmaraa wolala na donɔɔ kegyiise kɔŋawɔ ɔ gyaŋ ");
INSERT INTO ntr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kaa bɔɔse e nyiaa, “Yako daa, doŋ woŋti yaa n dana n ne yɛɛ mena abɔɔ kɛŋa pou? Amɔte faa na neŋ mena doŋ kenaŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Maŋ mɔ ne gyae maa bɔɔse ŋon nombii dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Gyɔn Wurubuarɛ loŋkesɔ keŋ ɔ be sɔ balaŋ nɛ, lee Wurubuarɛ gyaŋ yaa balaŋ gyaŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Botɔɔ te be lɛɛ aŋmaareŋ na dɔŋa nyiaa, “Woŋ te dɛɛ yako? Akpaa de yako nyi ka lee Wurubuarɛ gyaŋ na, waa bɔɔse daa nyi woŋ dɔɔ te da te lɛɛ Gyɔn nombia ŋan di ya? ");
INSERT INTO ntr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te akpaa de yako nyi ka lee balaŋ gyaŋ na, balaŋ dikpii kɛwɔ pou baa fuŋii daa boya. Nawolo nyi bɛɛ lɛɛ di nideli nyi Gyɔn yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e.” ");
INSERT INTO ntr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mena dɔɔ be tiranɔɔ fa Yesu nyiaa “Dɔɔ gyeŋ botɔɔ keŋ kɔɔ lee ya.” ");
INSERT INTO ntr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Keŋte Yesu mɔ yako wɔ nyiaa, “Akpaa mena na, maŋ mɔ ba wola ŋon me doŋ keŋ da lee ya.” ");
INSERT INTO ntr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Botɔɔ te Yesu gyɔɔ dudu kei fa balaŋ baŋ nyiaa, “Wɔɔfarale ŋolo fara wɔɔ te ɔ duu daasebia ŋaale ŋan ŋe yɛɛ ŋgba akutuse te bɛɛ baake ŋa nyi gerepo nɛ, te ɔ moo ŋa do paasetena baale nyiŋmaa man nyi baa kɛɛ ŋe dɔɔ, te ɔ korowɔ gyu tɛɛle wɔle daale man lemlem ke kyaa botɔɔ kyare. ");
INSERT INTO ntr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Debaŋ kelii nyi bɛɛ kɔ daasebia ŋan nɛ, ɔ kpila ɔ tobaale ŋolo gyu paasetena baŋ gyaŋ nyi baa fa e ɔ wui nɔɔ. Botɔɔ te paasetena baŋ tuku tobaale ŋon, te be tina e yela ɔ laŋawɔ nawɔɔ kufu nyiŋmaase kufu. ");
INSERT INTO ntr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wɔɔte ŋon besewɔ kpila tobaale wɔle bela, mɔna be tuku ŋon mɔ do e desɛŋ te be yela e ɔ laŋawɔ nawɔɔ kufu nyiŋmaase kufu. ");
INSERT INTO ntr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Botɔɔ te ɔ besewɔ kpila tobaale batoorote, mɔna be tuku ŋon mɔ do e gyamɛɛ te be gegi e lee wɔɔ keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Keŋte wɔɔte ŋon yakowɔ nyiaa, “Woŋ te maa yɛɛ? Maa kpila maŋ gbagba me tɔɔman lolo bu, mberem ŋon na baa bu e.” ");
INSERT INTO ntr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mɔna paasetena baŋ kena bu ŋon nɛ be yako dɔŋa nyiaa, “Kei yɛna bu ŋon waa di ɔ kya abɔɔ ŋan. Ɛ yela dɛɛ ko e na wa abɔɔ ŋan ka bese de wui.” ");
INSERT INTO ntr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mena dɔɔ be wɔŋee e lee wɔɔ keŋ man ka ko. Keŋte Yesu bɔɔse wɔ nyiaa, “Woŋ te ɛ ne lɛɛdi nyi wɔɔte ŋon waa yɛɛ paasetena baŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Waa kɔŋ na ɔ kaa ko paasetena benaŋ, na waa mo wɔɔ keŋ do balaŋ wɔlɛɛ nyiŋmaa man.” Debaŋ keŋ balaŋ baŋ be nyii nombia kɛŋa nɛ be yakowɔ nyiaa, “Wurubuarɛ na yeli kekɔŋ mena ya.” ");
INSERT INTO ntr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Keŋte Yesu kɛɛ wɔ te ɔ bɔɔse wɔ nyiaa, “Nyi akpaa mena na, sena te ɛ ne nyii Wurubuarɛ nombia kɛŋa asɛɛ? ‘Boe keŋ deni maara baŋ be bɛɛ nɛ, ta bese mokɔɔ kasee boe keŋ ne yeli deni keŋ ne yɛɛ doŋ.’ ");
INSERT INTO ntr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Walaŋ kamasɛ ŋon ɔ yale boe kei dɔɔ na, ke gyae ke keretii e kpetekpetekpete. Te nyaŋ walaŋ kamasɛ ŋon mɔ boe keŋ de yale n dɔɔ na, nyaŋ ke pɛtɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Botɔɔ na saese kegyiise na Gyudatena mmaraa wolala baŋ gyae gbɛɛ baa kyaŋ Yesu debokenaŋ man. Nawolo nyi ba gyeŋ nyi baŋ yaa ɔ gyɔɔ dudu keŋ, mɔna na bee yee balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Keŋ dɔɔ ba moo be sia gyakaa ɔ dɔɔ. Botɔɔ te kegyiise baŋ gyae kɔba fa balaŋ te be kpila wɔ nyi baa yɛɛ ba wose ŋgba be yɛɛ balaŋ kpaakpaawɔ nɛ na baa deke Yesu, na be kaa teese ɔ nɔɔman na baa nyiŋ lese e fa gyoo dinaa ŋon ɔ ne di be dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Keŋte balaŋ baŋ gyuuwɔ ke bɔɔse e nyiaa, “De Gbeŋgyoo, da gyeŋ nyi kpene keŋ n ne yako te n na wolo mɔ nɛ yɛɛ ampaŋ. Da gyeŋ nyi n bɛɛ kɛɛ walaŋ siaman ya, mɔna n na wola balaŋ Wurubuarɛ gbɛɛneŋ kpaakpaa ŋan bo na anokoare. ");
INSERT INTO ntr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dei nyi dɛɛ tɔ lempoo fa Romantena gyoo dinaa ŋon yaa de na tɔɔ ya?” ");
INSERT INTO ntr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu kena ba adao ŋan bee dii nɛ ɔ yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ɛ mo kɔbabii keŋ daale kɔŋ maa kɛɛ. Amɔte nyee na ɔ yele gyakaa la ke dɔɔ?” Botɔɔ te be tiranɔɔ nyi “Romantena gyoo dinaa ŋon.” ");
INSERT INTO ntr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mena dɔɔ Yesu yako wɔ nyiaa, “Mena na kpene keŋ yɛɛ Gyoo dinaa ŋon wui na ɛ mo fa e, te kpene keŋ yɛɛ Wurubuarɛ mɔ wui na ɛ mo fa e.” ");
INSERT INTO ntr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kpene keŋ ɔ be yako nɛ dɔɔ ba te tale mo ɔ nɔɔwoya ŋan kyaŋ e balaŋ baŋ siaman ya. Mena dɔɔ ɔ nɔɔwoya yɛɛ wɔ gyakoloŋ te be wuu be nɔɔse. ");
INSERT INTO ntr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Keŋte Sadukiitena baŋ bɛɛ yako nyi yeŋ wɔle kefoŋ be kyaa ya nɛ man baale kɔŋawɔ Yesu gyaŋ kaa bɔɔse e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“De Gbeŋgyoo, de naana Mosesi ŋmarase mmaraa kei fa daa nyi, ‘Akpaa walaŋ ŋolo ɔ kegyia yaa ɔ naabu da yem tina ɔ wɛɛle yela te be ta lola bia ya na, kaboena nyi ŋon ɔ kyaa nɛ waa mo lialo ŋon yala na baa lola bia yere ŋon yele man.’ ");
INSERT INTO ntr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kɔŋawɔ nyi baala nyetooro baale kyaawɔ te be kegyia ŋon yala alo te ɔ yeŋawɔ keŋ ɔ ta lola bia ya. ");
INSERT INTO ntr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Botɔɔ te balate ŋon mɔ yala alo ŋon, ");
INSERT INTO ntr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","te batoorote ŋon mɔ mena. Balaŋ nyetooro kɛwɔ pou yala alo kei te ba yekeewɔ, mɔna be man ŋolo na alo ŋon ta lolo ya. ");
INSERT INTO ntr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kenaŋ wɔle na te alo ŋon mɔ yeŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mena dɔɔ wee keŋ Wurubuarɛ waa gyuusu balaŋ baŋ pou bɔɔ yem nɛ lee yeŋ man na, baala nyetooro kɛwɔ baŋ bɔɔ yala alo kei gyaŋee nɛ, be man woŋti te alo ŋon waa yɛɛ ɔ wɛɛle?” ");
INSERT INTO ntr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Bɛɛ mo ala baŋ be kyaa tɛɛle kei dɔɔ nɛ fa yale te baala baŋ mɔ be kyaa tɛɛle kei dɔɔ nɛ ne yala ala, ");
INSERT INTO ntr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","mɔna balaŋ baŋ be kaboena nyi Wurubuarɛ waa gyuusu wɔ lee yeŋ man na baa kyaa kekpaakekpaa nɛ, baala be gyae baa yala ya te bɔɔ gyae baa mo ala mɔ fa yale debaŋ wɔle kenaŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yeŋ be tale ko wɔ bela ya nawolo nyi be yɛɛ ŋgba Wurubuarɛ kpilala nɛ. Be yɛɛ Wurubuarɛ biawɔ, nawolo nyi ba te fom lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosesi mɔ torowɔ yako nyiaa, balaŋ ayeŋaŋ baa foŋ lee yeŋ man. Nawolo nyi debaŋ keŋ ɔ be naa depoŋfa keŋ ne kpaa nɛ ɔ yakowɔ nyiaa, de Gbeŋgyoo Wurubuarɛ yɛna Aberaham na Asiki na Gyekɔpo Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kei nawolo baa nyiaa, ɔ yɛɛ balaŋ baŋ be kyaa na be sia nɛ Wurubuarɛ e. Ɔ te yɛɛ woya Wurubuarɛ e ya, nawolo nyi Wurubuarɛ siaman na ɔ balaŋ pou delena.” ");
INSERT INTO ntr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Botɔɔ te Gyudatena mmaraa wolala baŋ baale yakowɔ nyiaa, “De Gbeŋgyoo, n tiranɔɔ nideli.” ");
INSERT INTO ntr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mena dɔɔ ŋolo te tale gyɔ ɔ konɔɔ bɔɔse e nombii bela ya. ");
INSERT INTO ntr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Keŋte Yesu bɔɔse wɔ nyiaa, “Sena te baa tale yako nyi nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ yɛɛ gyoo Defidi ɔ naanabii e? ");
INSERT INTO ntr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nawolo nyi gyoo Defidi gbagba yakowɔ nɔɔneŋ tɔne keŋ man nyiaa, ‘De Gbeŋgyoo Wurubuarɛ ŋon yako me Gbeŋgyoo nyi “Tisi kyaa me dunoluŋ dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kelii debaŋ keŋ maa mo n kɔlala baŋ do n tɛɛ.” ’ ");
INSERT INTO ntr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gyoo Defidi baake nyeelɛɛre ŋonaŋ nyi ɔ Gbeŋgyoo. Akpaa mena na, sena te nyeelɛɛre ŋonaŋ waa bese gyoo Defidi ɔ naanabii?” ");
INSERT INTO ntr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Balaŋ baŋ pou kee tei Yesu nɛ ɔ yako ɔ kaseela baŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ɛ kɛɛ ɛ wose nideli na Gyudatena mmaraa wolala baŋ. Bɛɛ gyae kegbase dɔɔloŋ nyiŋan keta do kila, te bɛɛ gyae balaŋ ke buŋii do wɔ nɔɔ balaŋ dɛɛgyaŋee man, te bɛɛ gyae akyaese kpaakpaa Gyudatena ɔsom denɛɛ na be dɛɛgyaŋee di gyoŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɛɛ beo liala lɛo ba abɔɔ ŋan be dana nɛ. Bɛɛ fane kyare na baa mo beo balaŋ nyi be yɛɛ balaŋ kpaakpaawɔ.” Wurubuarɛ waa wɔŋ mena balaŋ kɛwɔ dinɔɔ deŋela nideli kela walaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kekyaa Wurubuarɛ ɔsom deni dinaa keŋ man nɛ, ɔ gyinaa ɔ nyee na ɔ naa kɔbatena kɛɛ mo be kɔba kaa do kɔba adakaa keŋ man, ");
INSERT INTO ntr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","te ɔ naa lialo diyemte ŋolo mɔ moo kɔbasebia ala kaa do kɔba adakaa keŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Botɔɔ te Yesu yakowɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyi lialo diyemte kei ta do kɔba kela balaŋ akaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nawolo nyi baŋ pou bɔɔ do kɔba nɛ, ba lese kyomii bo lee ŋan be dana nɛ man. Mɔna lialo kei na ɔ diyem koraŋ na, ɔ moo kɔba keŋ pou ɔ dana nɛ kaa do.” ");
INSERT INTO ntr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na Yesu kaseela baŋ man baale ne kolosi Wurubuarɛ ɔsom deni dinaa keŋ kyeo na mena keŋ bɔɔ mo boya kpaakpaa nyiŋan ma ke, na abɔɔ kpaakpaa ŋan balaŋ ba mo kaa fa Wurubuarɛ te bɔɔ mo desina deni kenaŋ nɛ wose man nombia. Keŋte Yesu yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Abɔɔ ŋan pou ɛ ne naa kɛbo nɛ, debaŋ daale gyae kekɔŋ keŋ baa tekerii ŋe popou lɔ keŋ nyi ɛ be gyae ɛ kena boe na boe gyakaa ke dɔɔ dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Keŋte ɔ kaseela baŋ bɔɔse e nyiaa, “De Gbeŋgyoo, debaŋ woŋti te mena nombia kɛŋa gyae kekɔŋ? Woŋ ne gyae la ke yɛɛ na kawola nyi debaŋ keŋ nombia kɛŋa gyae ke kɔŋ nɛ te lii?” ");
INSERT INTO ntr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ kɛɛ ɛ wose nideli nyi ŋolo na beo ŋon ya. Nawolo nyi balaŋ burum baa kɔŋ ma yele man nyi, ‘Baŋ yɛna maŋ nyeelɛɛre ŋon,’ na baa yako ŋon nyi ‘Debaŋ keŋ te lii.’ Akpaa ɛ nyii mena na ɛ na sila wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te akpaa ɛ nyii yoo na yoo nombia na ɛ na yeli gyakoloŋ kekyaŋ ŋon ya, nawolo nyi kaboena nyi mena nombia kɛŋa pou dɛɛkɔŋ. Mɔna kɛŋa bɛɛ wolo nyi debaŋ ɔtomante keŋ gyae ke kɔŋ debokenaŋ man ya.” ");
INSERT INTO ntr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Keŋte Yesu besewɔ yako wɔ nyiaa, “Tɛɛlese gyae ka koro yokii na dɔŋa, te gyooneŋ mɔ baa yokii na dɔŋa. ");
INSERT INTO ntr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tɛɛle gyae ke wosi, tanam dinaa gyae ke yala tɛɛlese dɔɔ te kaweese mɔ gyae ke gbiki tɛɛlese dɔɔ. Gyakoloŋ nombia na nombia dinaana gyae ka lee adido kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mɔna pɛte kɛŋa pou kekɔŋ nɛ, lee maŋ dɔɔ baa kyaŋ ŋon na baa naase ŋon diyem. Baa mo ŋon fa Gyudatena ɔsom denɛɛ man kegyiise na gyooneŋ na gyooneŋ kegyiise na baa di ɛ nombia na baa do ŋon denɛɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kɛŋa gyae ke yela ɛ kenyiŋ gbɛɛ kolosi Wurubuarɛ nombia kpaakpaa ŋan fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mɔna ɛ yela ke doo ya agyueŋ man nyiaa, te yɛɛ keŋ ɛ ka yeyɛɛ na nombii keŋ ɛ ka mo kolosi lese ɛ nɔɔse ya, ");
INSERT INTO ntr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nawolo nyi maŋ ne gyae la maa wola ŋon nombia ŋan ɛ ke yako. Na maa fa ŋon nyansa keŋ ɛ kɔlala be gyae baa tale seŋ ɛ siaman nyi ɛmɛɛ na wɔ kedi nombia ya. ");
INSERT INTO ntr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ɛmɛɛ gbagba ɛ kyaɔ na ɛ naɔ na ɛ naabia na ɛ loŋtona na ɛ gyoona ne gyae la baa lese ŋon fa, na baa koe ɛ man baale. ");
INSERT INTO ntr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lee maŋ dɔɔ balaŋ pou baa kɔla ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mɔna ɛ nyeenyɔɔse dokoloŋ koraŋ gba be gyae ka yo ya. ");
INSERT INTO ntr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɛ seŋ keŋkeŋ ɛ kelɛɛdi man kelii ɔto na, ɛ ke nyiŋ nyeedoŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Keŋte Yesu yako wɔ nyi, “Debaŋ keŋ ɛ naa yoonɔɔtena de kaa kilisi Gyerusalɛm donɔɔ nɛ, botɔɔ te ɛ ka gyeŋ nyi ka kewɔlɛɛ ta benaa. ");
INSERT INTO ntr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Akpaa de kɔŋ mena na balaŋ baŋ be kyaa Gyudia tɛɛle man nɛ, baa yeu gyu bulase dɔɔ te baŋ mɔ be kyaa Gyerusalɛm donɔɔ man nɛ baa lee ke man, te baŋ mɔ be kyaa ka yenaase nɛ be na bese kɔŋ donɔɔ keŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nawolo nyi kei yɛna deŋele kewɔŋ keŋ gyae ke kɔŋ ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see ŋan be yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Weeya ŋenaŋ man nɛ, fulɛɛtena na talabose baa laako. Nawolo nyi kayeyɛɛ dinaa gyae ke kɔŋ tɛɛle kei dɔɔ, na Wurubuarɛ deŋele kewɔŋ kekɔŋ balaŋ kɛwɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Baa mo sila ko balaŋ baŋ baale, na baa kyaŋ baale ketɔ deni tɛɛlese wɔlɛɛ dɔɔ. Balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ baa di Gyerusalɛm donɔɔ dɔɔ kelii debaŋ keŋ Wurubuarɛ ba see nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Keŋte Yesu yakowɔ nyiaa, “Ɛ kena gyakoloŋ nombia weese na gyaalaŋ na kyolobiise man, te gyakoloŋ gyae ka gyoo tɛɛle kei dɔɔ balaŋ pou te bɔɔ gyae baa gyeŋ kpene keŋ baa yɛɛ ya, lee mena keŋ ɛpo ne muusu te kɛɛ gyɔɔ nedoŋ nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Debaŋ keŋ bɛɛ wɔlɛɛ na nombia ŋan gyae ke yɛɛ tɛɛle kei dɔɔ nɛ, gyakoloŋ gyae ke yela balaŋ woya ke yekii lee be man, nawolo nyi abɔɔ ŋan ŋe kyaa adido te ŋe dana doŋ nɛ pou gyae ke wosi. ");
INSERT INTO ntr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Debaŋ kenaŋ nɛ, ɛ kena maŋ Deniwalaŋ Bu ŋon ta mo doŋ na gyoorobiiri lee ŋɔma man adido mɛɛ kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Akpaa ɛ naa abɔɔ kɛŋa ne kɔŋ na ɛ koro seŋ na ɛ ke kpaŋ ɛ gbegyase, nawolo nyi ɛ nyeekelɛɛ ta benaa.” ");
INSERT INTO ntr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Keŋte Yesu gyɔɔ dudu fa wɔ nyiaa, “Ɛ kɛɛ fiigi daŋ keŋ na daase akaŋ ŋan pou. ");
INSERT INTO ntr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Akpaa ɛ naa ŋgba ŋe tombia ne pɔrɔkee na, ɛ gyeŋ nyi dekpao ta benaa. ");
INSERT INTO ntr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mena mɔ te akpaa ɛ naa mena abɔɔ kɛŋa ne kɔŋ na, ɛ gyeŋ nyi Wurubuarɛ gyoori keŋ ta benaa. ");
INSERT INTO ntr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ampaŋ yaa mɛɛ yako ŋon nyiaa, mena duuluŋ kei be gyae ke munu pɛte abɔɔ kɛŋa pou ke kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adido na tɛɛle kei pou gyae ke gyu ɔto, mɔna me nɔɔwoya ŋan dɔɔ ŋan gyae ke kyaa kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ɛ kɛɛ ɛ wose dɔɔ nideli! Ɛ na yeli tɛɛle kei dɔɔ abɔɔ kegyae ka bere ɛ sia ya. Ɛ na mo soloŋ kenyɔɔ do ɛ wose ya. Ɛ na gyueŋ tɛɛle kei dɔɔ nombia beiŋ, na wee keŋ be nyiŋ kɔŋ kaa futaa ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nawolo nyi mena wee kenaŋ gyae ke kɔŋ tɛɛle kei balaŋ pou dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mena dɔɔ ɛ kɛɛ ɛ wose dɔɔ nideli debaŋ kamasɛ na ɛ ke fane na ɛ kenyiŋ tale lese ɛ wose lee nombia ŋan pou gyae ke kɔŋ nɛ man, na ɛ ke nyiŋ tale seŋ maŋ Deniwalaŋ Bu ŋon siaman.” ");
INSERT INTO ntr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wee kamasɛ na, Yesu na wolo Wurubuarɛ ɔsom deni dinaa keŋ man te balinɔɔ de lii na ɔ ne gyu ke doo oliifi bula keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tɛɛ de naa nebo nebo na, balaŋ baŋ pou ne gyu ke yilaa Wurubuarɛ ɔsom deni dinaa keŋ man na baa nyii ɔ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gyudatena debaŋ keŋ bɛɛ baake ke nyi nyeekelɛɛ debaŋ keŋ bee di bodobodo keŋ bodobodo tee be doo ke man ya nɛ kɛɛ benaa nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala gyae gbɛɛ keŋ baa mo ko Yesu, mɔna bee yee balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Keŋte ɔbɔnsam gyoo Yesu kaseela kufu bala baŋ man ŋolo ŋon bɛɛ baake nyi Gyudase Isekarɔte nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Keŋte Gyudase gyuuwɔ te ŋon na Wurubuarɛ saese kegyiise na Wurubuarɛ ɔsom deni dinaa keŋ kotɔtɔɔtena kegyiise bakewɔ see mena keŋ waa lese Yesu fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yɛɛ kegyiise baŋ gyoŋ te be sɛɛwɔ nyi baa fa e kɔba. ");
INSERT INTO ntr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Keŋte Gyudase mɔ sɛɛwɔ te ɔ gyae gbɛɛ keŋ waa mo lese Yesu fa wɔ keŋ balaŋ ba gyem ya. ");
INSERT INTO ntr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gyudatena wee dinaa keŋ bee di bodobodo keŋ bodobodo tee be doo ke man ya, te bɛɛ mo nyeekelɛɛ nambu ŋon mɔ deesi kelii nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu kpila Pita na Gyɔn nyiaa, “Ɛ gyu ke desina abɔɔ ŋan dɛɛ mo di nyeekelɛɛ weenɛɛ ŋan nɛ see.” ");
INSERT INTO ntr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Botɔɔ te be bɔɔse e nyiaa, “Aleŋ te n ne gyae de kaa desina see?” ");
INSERT INTO ntr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Keŋte Yesu yako wɔ nyiaa, “Ɛ betaa ɛ na gyoo donɔɔ keŋ man nɛ, ɛ kena balee ŋolo seelena loŋ na ogele. Ɛ sila e gyu dekpaŋalaŋ keŋ man waa gyoo nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","na ɛ ke yako dekpaŋalaŋte ŋon nyiaa, ‘De Gbeŋgyoo ŋon kpa dɛɛ bɔɔse neŋ nyi aleŋ te ŋɔɔla deni keŋ daa na me kaseela dɛɛ kaa di nyeekelɛɛwee weenɛɛ ŋan nɛ kyaa?’ ");
INSERT INTO ntr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Balee ŋonaŋ waa wola ŋon abansoro deni dinaa daale keŋ ke kyaa adido te bɔɔ desina ke man nideli nɛ. Ɛ desina botɔɔ na de kaa di weenɛɛ ŋan.” ");
INSERT INTO ntr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesu kaseela baŋ ke gyu keŋ nɛ, be naa kpene kamasɛ doo pɛpɛɛpɛ ŋgba mena keŋ Yesu be yako wɔ nɛ, te be desina nyeekelɛɛ weenɛɛ ŋan see botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Debaŋ keŋ kelii nɛ, Yesu na ɔ kaseela baŋ kyaawɔ bom baa di. ");
INSERT INTO ntr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Me gyaewɔ nideli me konɔɔ man nyi daa na ŋon ke di mena nyeekelɛɛ weenɛɛ kɛŋa pɛna me kaa naa diyem! ");
INSERT INTO ntr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mena dɔɔ mɛɛ yako ŋon ɛ ke nyii nyiaa, mɔɔ gyae maa tekaa di weenɛɛ kɛŋa bela ya kelii wee keŋ kpene keŋ mena kedi kei seŋɛɛ fa nɛ, gyae ke kɔŋ mena Wurubuarɛ gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Keŋte Yesu moo leenɔɔ keŋ te ɔ fanewɔ do Wurubuarɛ nɔɔ te ɔ yakowɔ nyiaa, “Ɛ lɛɛ kei na ɛ ke nyɔɔ fa dɔŋa. ");
INSERT INTO ntr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nawolo nyi mɛɛ yako ŋon baa nyiaa, mɔɔ gyae maa nyɔɔ soloŋ kei bela ya kelii wee keŋ Wurubuarɛ gyoori keŋ gyae ke kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Keŋte ɔ moo bodobodo te ɔ fanewɔ do Wurubuarɛ nɔɔ te ɔ kara ke mo fa wɔ te ɔ yakowɔ nyiaa, “Kei yɛna ma wosenaane keŋ mɔɔ mo deesi fa ŋon. Ɛ kyaa yɛɛ kei na ɛ ka mo tɔɔse maŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mena mɔ te be ke di taŋ nɛ, ɔ moo leenɔɔ te ɔ yakowɔ nyiaa, “Kei yɛna me fatabo keŋ Wurubuarɛ be kyɛɛkee leki mo tɔ nɔɔkebakesee wɔle keŋ nɔɔ fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mɔna mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ ŋon waa lese maŋ fa nɛ kpuɛ na maŋ weenɛɛ kɛŋa dedii man kɛbo. ");
INSERT INTO ntr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maŋ Deniwalaŋ Bu ŋon maa yeŋ ŋgba mena keŋ Wurubuarɛ be yako see nɛ, mɔna walaŋ ŋon waa lese maŋ fa nɛ waa laako.” ");
INSERT INTO ntr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Botɔɔ te ɔ kaseela baŋ gyoo dɔŋa ke bɔɔse nyiaa, “De man walaŋ woŋti kitii ne gyae la waa yɛɛ mena nombii kei?” ");
INSERT INTO ntr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Keŋte aŋmaareŋ gyoo Yesu kaseela baŋ man nyi be man woŋti ne gyae la waa yɛɛ be kegyia? ");
INSERT INTO ntr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Botɔɔ te Yesu yako ɔ kaseela baŋ nyiaa, “Tɛɛle kei dɔɔ gyooneŋ ne di doŋ be balaŋ dɔɔ, mɔna balaŋ ne baake mena gyooneŋ kɛwɔ nyi be yɛɛ balaŋ kpaakpaawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mɔna tekaboena nyi ɛmɛɛ ke yɛɛ ŋgba mena balaŋ kɛwɔ nɛ ya. Walaŋ ŋon ɔ yɛɛ kegyia e ɛ man nɛ waa yɛɛ ɔ wose ŋgba ɛ man kemaasabii nɛ, te ŋon ɔ yɛɛ ɛ siamante e nɛ waa som ŋon. ");
INSERT INTO ntr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Walaŋ ŋon ɔ kyaa ɔ ne dii na ŋon ɔ na som e nɛ, be man woŋti yɛna kegyia? Na walaŋ ŋon ɔ kyaa ɔ ne dii nɛ yee? Mɔna maŋ kyaa ɛ man ŋgba walaŋ ŋon ɔ na som nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɛmɛɛ yɛna baŋ ɛ ba sem me wɔle lee me kayeyɛɛ man pou, ");
INSERT INTO ntr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","mena dɔɔ mɛɛ see ŋon gyoori ŋgba mena keŋ me kya ba see maŋ gyoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na daa na ŋon kedi na dɛɛ nyɔɔ me gyoori keŋ man, na ɛ ke kyaa me gyooro gbelɛɛ ŋan dɔɔ ɛ ke di Iseraetena akpaŋalaŋ kufu ala ŋan balaŋ nombia.” ");
INSERT INTO ntr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Keŋte Yesu yako Simɔn Pita nyi “Simɔn, Simɔn nyii! Ɔbɔnsam ta sola gbɛɛ lee Wurubuarɛ gyaŋ waa kɛɛse ɛ popou kɛɛ na waa kpase ɛ man ŋgba mena keŋ bee feefu amɔla lese bia nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mɔna ma te fane fa nyaŋ Simɔn na n kelɛɛdi be yɔkɔse ya. Te akpaa n kyɛɛkee lee n gbɛɛneŋ kumɛɛ man bese kɔŋ me gyaŋ nɛ, do n tebia me kaseela akaŋ baŋ kakyeŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Botɔɔ te Pita tiranɔɔ nyiaa, “Me Gbeŋgyoo, nyi akpaa ke yɛɛ deni kedoo ke yaa yeŋ ke koraŋ na, ma te desina ma wose nyi maa sila neŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Keŋte Yesu tiranɔɔ nyiaa, “Pita, mɛɛ yako neŋ nyi pɛte kegyim kelɔ woya gyɛŋ na, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Debaŋ keŋ mɔɔ kpila ŋon keŋ ɛ ta mo kɔba yaa akpo, yaa ɛ ta mo nkyokotase tela ya nɛ kolo hia ŋon?” Keŋte be tiranɔɔ nyiaa, “Koa, kolo te hia daa ya.” ");
INSERT INTO ntr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Keŋte Yesu yako wɔ nyiaa, “Nɛnɛɛ dɔɔ nyaŋ ŋon n dana kɔba yaa akpo na mo tela, te nyaŋ ŋon n be dana sila ya na yɔɔ n kegba na n ka mo ke lɛɛ daale. ");
INSERT INTO ntr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nawolo nyi ba te ŋmarase ma wose man nombia see nyiaa, ‘Ba te kala e do nombiakumɛɛyɛɛra man,’ te mɛɛ yako ŋon ɛ ke nyii nyiaa, Wurubuarɛ nombia ŋan bɔɔ ŋmarase see lee ma wose man nɛ, kaboena nyi ŋe dɛɛ kɔŋ mena. Ampaŋ kpene keŋ bɔɔ ŋmarase see lee ma wose man nɛ ta benaa ka ke kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Botɔɔ te ɔ kaseela baŋ yako e nyiaa, “De Gbeŋgyoo kɛɛ silase ala yaa.” Keŋte Yesu yako wɔ nyi, “Tekaboe mena.” ");
INSERT INTO ntr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Keŋte Yesu leewɔ donɔɔ keŋ man gyu oliifi bula keŋ dɔɔ ŋgba mena keŋ ɔ ne kyaa gyu nɛ, te ɔ kaseela baŋ sila e gyu. ");
INSERT INTO ntr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Be kelii botɔɔ nɛ Yesu yako ɔ kaseela baŋ nyiaa, “Ɛ fane na ɛ be nyiŋ gyoo kekɛɛsekɛɛ man ya.” ");
INSERT INTO ntr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Keŋte ɔ wɔŋa ɔ wose lee yenaŋ gyu siaman kyomii te ɔ ke buŋawɔ fane nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taata, akpaa ke yɛɛ n kegyaebii ke na, lese maŋ lee kaale kei man. Mɔna na yɛɛ maŋ kegyaebii ya, yɛɛ nyaŋ gbagba n kegyaebii.” ");
INSERT INTO ntr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Botɔɔ te Wurubuarɛ kpilale lee adido kɔŋ kaa do e kakyeŋ. ");
INSERT INTO ntr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu kɛɛ yeyɛɛ keŋ nɛ, ɔ kyaŋa ɔ wose fane nideli te dufuŋ keŋ ba lee e nɛ kyɔseewɔ yala tɛɛle man ŋgba fatabo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ɔ ke fane taŋ keŋ nɛ te ɔ besewɔ gyu ɔ kaseela baŋ gyaŋ. Ɔ ke gyu keŋ na ɔ ke naawɔ ŋgba ɔ kaseela baŋ te dokii, nawolo nyi dekɔkɔrɔkɔɔ te kyaŋ wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Keŋte Yesu bɔɔse wɔ nyiaa, “Weera ɛ ne doo? Ɛ koro na ɛ ke fane na ɛ be nyiŋ gyoo kekɛɛsekɛɛ man ya.” ");
INSERT INTO ntr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ka seŋ ɔ ne kolosi nɛ balaŋ dikpii baale kaa bɛɛwɔ lee ɔ dɔɔ, na Gyudase ŋon ɔ yɛɛ Yesu kaseela kufu bala baŋ man ŋolo e nɛ dɔŋɛɛ la be siaman. Ɔ kena Yesu nɛ te ɔ kɔŋawɔ ɔ kaa pukaa e. ");
INSERT INTO ntr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Keŋte Yesu bɔɔse e nyiaa, “Gyudase, kepukaa te nyaŋ ka mo lese maŋ Deniwalaŋ Bu ŋon fa?” ");
INSERT INTO ntr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu kaseela baŋ kena kpene keŋ ne gyae ke kɔŋ nɛ te be bɔɔse e nyiaa, “De Gbeŋgyoo, dɛɛ mo de silase na dee yoo?” ");
INSERT INTO ntr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Botɔɔ te Yesu kaseela baŋ man ŋolo moo ɔ yoosila kara saese kegyia tobaale ŋolo dunoluŋ deŋele lese ke lɔ. ");
INSERT INTO ntr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Keŋte Yesu yako wɔ nyiaa, “Ɛ tina yela, ɛ na yɛɛ mena ya.” Te ɔ tinaa balee ŋon deŋele keŋ te ka towaawɔ bela. ");
INSERT INTO ntr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Keŋte Yesu bɔɔse saese kegyiise na Wurubuarɛ dɛɛ kotɔtɔɔtena kegyiise na kegyiise baŋ bɔɔ kɔŋ botɔɔ be kaa kyaŋ e nɛ nyiaa, “Weera te ɛ moo yoosilase na akpokpose ɛ ne kɔŋ me dɔɔ ŋgba me yɛɛ walaŋkum e nɛ? ");
INSERT INTO ntr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wee kamasɛ daa na ŋon ne kyaa la Wurubuarɛ ɔsom deni dinaa keŋ man, mɔna ɛ te kyaŋ maŋ ya. Nɛnɛɛ te gbɛɛ torowɔ fa ŋon nyi yaa kyaŋ maŋ, na ɛ ke yɛɛ ɔbɔnsam ditiŋtɛɛ gyoo ŋon kegyaebii.” ");
INSERT INTO ntr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Botɔɔ te be kyaŋa Yesu mo e gyu Wurubuarɛ saese kegyia ŋon dekpaŋalaŋ man, na Pita mɔ silana wɔ wɔle wɔle. ");
INSERT INTO ntr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Keŋte balaŋ baŋ doo boalaŋ dekpaŋalaŋ keŋ nsana nsana te be yilaawɔ ke gyaŋ bee woli, te Pita mɔ gyuuwɔ ke kyaa be gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Alebia baŋ bɛɛ yɛɛ tom dekpaŋalaŋ keŋ man nɛ ŋolo naa Pita kyaa boalaŋ keŋ gyaŋ, te ɔ gyene e nideli te ɔ yakowɔ nyi “Na balee kei mɔ kpuɛ na Yesu!” ");
INSERT INTO ntr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Keŋte Pita lɛɛ aŋmaareŋ nyiaa, “Alebu, mɔɔ gyeŋ e ya.” ");
INSERT INTO ntr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Te kyare ya te ŋolo mɔ naa e te ɔ yako e bela nyiaa, “Nyaŋ mɔ n yɛɛ be man ŋolo e!” Keŋte Pita tiranɔɔ nyiaa, “Baale, mɔɔ kpuɛ na wɔ ya!” ");
INSERT INTO ntr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Debaŋ dokoloŋ daale wɔle nɛ, ŋolo mɔ kaa yase ɔ sia do Pita ŋonaŋ nyiaa, “Ke yɛɛ ampaŋ kaeŋ nyi balee kei kpuɛ na Yesu, nawolo nyi ɔ yɛɛ Galelia baale e!” ");
INSERT INTO ntr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Botɔɔ te Pita tiranɔɔ nyiaa, “Baale, mɔɔ gyeŋ nombia ŋan n ne yako nɛ man ya.” Pita ke gyakaa ɔ ne kolosi nɛ te kegyim lɔɔ woya. ");
INSERT INTO ntr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Botɔɔ te de Gbeŋgyoo Yesu gɛɛsewɔ kɛɛ Pita, te Pita tɔɔse de Gbeŋgyoo Yesu nombia ŋan ɔ be yako e nɛ nyiaa, “Pɛ kegyim ke lɔ woya gyɛŋ na, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Keŋte Pita leewɔ debɔɔ man gyu ke kyaŋ ɔ nyee wii nideli. ");
INSERT INTO ntr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Balaŋ baŋ bɛɛ kɛɛ Yesu dɔɔ nɛ fiasɛɛ bee kulu e na bee tuku e. ");
INSERT INTO ntr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba moo kanyaŋ bake ɔ sia na bɛɛ takee e akɔtase na bɛɛ bɔɔse e nyi “Yako daa, amɔte gyɔɔ na neŋ?” ");
INSERT INTO ntr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te ba tee e tuubia kpaŋ kpaŋ kpu. ");
INSERT INTO ntr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tɛɛ kena keŋ nɛ, donɔɔ kegyiise na Wurubuarɛ saese kegyiise na Gyudatena mmaraa wolala baŋ gyaŋeewɔ te ba moo Yesu kɔŋ kaa seŋ be siaman. ");
INSERT INTO ntr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Keŋte be yako Yesu nyiaa, “Akpaa nyaŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ na yako daa dee nyii.” Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Akpaa me yako ŋon na ɛ be gyae ɛ ke lɛɛ maŋ di ya, ");
INSERT INTO ntr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","te akpaa me bɔɔse ŋon nombia mɔ nɛ ɛ be gyae ɛ ke tiranɔɔ fa maŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mɔna lee debaŋ kei ne gyu nɛ, maŋ Deniwalaŋ Bu ŋon maa kyaa Wurubuarɛ Kpatakpere ŋon dunoluŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Keŋte be popou bɔɔse e nyiaa, “Akpaa mena na nyaŋ yɛna Wurubuarɛ bu ŋon?” Keŋte Yesu tiranɔɔ nyi, “Mena yaa ɛ ne yako nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Keŋte be yakowɔ nyiaa, “Woŋ nombia yaa dɛɛ gyae dɛɛ bese nyii kpu bela. Daa gbagba te nyii lee ŋon gbagba nɔɔman!” ");
INSERT INTO ntr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Keŋte balaŋ baŋ bɔɔ gyaŋee botɔɔ nɛ pou korowɔ mo Yesu gyu Pilato ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man nɛ gyaŋ, ");
INSERT INTO ntr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","te be fiasɛɛ bɛɛ mo nombia gyakaa ɔ dɔɔ nyiaa, “De naa balee kei dɔŋ de balaŋ siaman ɔ na wola wɔ nombiakumɛɛ keyɛɛ. Ɔ ne bɛɛ nyi be na tɔ lempoo fa gyoo dinaa Kaesa ya, te ɔ ne gyɔ ɔ konɔɔ yako nyi ŋon yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ, te ɔ yɛɛ gyoo mɔ e.” ");
INSERT INTO ntr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Botɔɔ te Pilato bɔɔse Yesu nyiaa, “Nyaŋ yɛna Gyudatena gyoo ŋon?” Te Yesu tiranɔɔ nyi, “Mena yaa n yakowɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Keŋte Pilato yako saese kegyiise baŋ na balaŋ dikpii keŋ nyiaa, “Ma te naa nombiikum keŋ balee kei be yɛɛ keŋ kaboena nyi maa bu e fɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mɔna nɛnɛɛ gba te ba seŋɛɛ be nɔɔwoya dɔɔ keŋkeŋ nyi, “Ɔ ta mo ɔ kawola keŋ wɔlɛɛ balaŋ agyueŋ Gyudia tɛɛle kei dɔɔ pou. Ɔ fiasɛɛ lee Galelia tɛɛle dɔɔ te nɛnɛɛ ɔ te kaa lii de gyaŋ kɛbo.” ");
INSERT INTO ntr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato ke nyii nombia kɛŋa nɛ ɔ bɔɔsewɔ nyiaa, “Balee kei yɛɛ Galelia baale e?” ");
INSERT INTO ntr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato ka gyeŋ nyi Yesu lee gyoo Herode tɛɛle man nɛ, ɔ yela ba mo e gyu gyoo Herode gyaŋ. Debaŋ kenaŋ na gyoo Herode mɔ kyaa Gyerusalɛm donɔɔ man botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Gyoo Herode kena Yesu nɛ yɛɛ e gyoŋ nideli, nawolo nyi ɔ wulaa nyii Yesu wose man nombia te ɔ ne gyae e mɔ waa naa. Lee mena keŋ ɔ be nyii Yesu wose man nombia dɔɔ nɛ, wa agyueŋ yɛna nyi waa yɛɛ gyakoloŋ nombia wola e. ");
INSERT INTO ntr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mena dɔɔ gyoo Herode bɔɔse Yesu nombia burum, mɔna ɔ te tira ŋe man dokoloŋ nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Botɔɔ na saese kegyiise na Gyudatena mmaraa wolala baŋ seŋɛɛ keŋkeŋ bɛɛ kɛrɛɛ nombia dinaana gyakaa Yesu dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Keŋte gyoo Herode na ɔ yoonɔɔtena baŋ kulu Yesu te ba do e desɛŋ. Ba doo e gyooro kegba te ɔ yela ba besena e gyina Pilato. ");
INSERT INTO ntr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lee wee kenaŋ te gyoo Herode na Pilato nsana besewɔ de, nafɔ na bɔɔ na gyoo ya. ");
INSERT INTO ntr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Botɔɔ te Pilato baake saese kegyiise baŋ na donɔɔ kegyiise na balaŋ baŋ pou gyaŋee, ");
INSERT INTO ntr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","te ɔ yako wɔ nyiaa, “Ɛmɛɛ moona balee kei kɔŋ me gyaŋ te ɛ kpa ɔ na beo balaŋ baŋ. Maŋ gyoo ke man ɛ siaman kɛbo mɔna ma te naa nombiakumɛɛ ŋan ɔ be yɛɛ te ɛ ne kara ɔ nɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Gyoo Herode mɔ te naa nombiikum lee ɔ wose man ya, te ɔ yela ba besena e kɔna daa. N kɛɛ paa na balee kei te yɛɛ kolo kum keŋ kaboena nyi baa ko e ya. ");
INSERT INTO ntr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mena dɔɔ maa yela baa tuku e na baa tina e yela.” ");
INSERT INTO ntr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na ke yɛɛ ba mmaraa ke nyi ba nyeekelɛɛwee kedi kamasɛ na, kaboena nyi Pilato waa tina balaŋ baŋ bɔɔ kyam tɔ deni man nɛ, be man ŋolo ŋon baŋ Gyudatena ne gyae nɛ yela fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Botɔɔ te balaŋ dikpii keŋ pou fae yeesa nedoŋ nyiaa, “Ko balee kei na n ke tina Barabase yela fa daa.” ");
INSERT INTO ntr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Keŋ dɔɔ bɔɔ kyaŋ Barabase tɔ deni yɛna nyi, ŋon tɛɛ la balaŋ siaman te ba korowɔ seŋ tia kegyiise te ɔ koo walaŋ nombia ŋenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Keŋ Pilato ne gyae waa tina Yesu yela dɔɔ nɛ, ɔ besewɔ kolosi fa balaŋ baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mɔna balaŋ baŋ gyakaa bɛɛ fae yeesa nyiaa, “Yela baa gyɔ e sakaa ɔpaŋdaŋ dɔɔ” ");
INSERT INTO ntr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Keŋte Pilato besewɔ kolosi fa wɔ betabotoorote nyiaa, “Woŋ nombiikum yaa balee kei yɛɛwɔ? Maŋ te naa kpene keŋ ɔ be yɛɛ keŋ kaboena nyi baa ko e ya. Mena dɔɔ maa yela baa tuku e na maa tina e yela.” ");
INSERT INTO ntr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mɔna balaŋ baŋ seŋɛɛ keŋkeŋ bɛɛ fae yeesa nedoŋ nyi baa gyɔ e sakaa ɔpaŋdaŋ dɔɔ, te be yeesa ŋan kela Pilato. ");
INSERT INTO ntr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mena dɔɔ Pilato yɛɛ wa agyueŋ nyi waa yɛɛ balaŋ baŋ kegyaebii fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Keŋte Pilato tinaa Barabase ŋon bɔɔ kyam tɔ deni nɛ yela fa wɔ. Barabase kei tɛɛ la balaŋ baale siaman te ba korowɔ seŋ tia kegyiise te ɔ koo walaŋ mɔ. Ŋon yɛna walaŋ ŋon balaŋ baŋ be yako nyi waa tina e yela fa wɔ nɛ. Te ɔ moo Yesu fa wɔ nyi baa gyu ke yɛɛ e ba kegyaebii. ");
INSERT INTO ntr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Be ka mo Yesu lee Pilato gyaŋ bee gyuu nɛ, be gyaŋee na balee ŋolo ŋon bɛɛ baake e nyi Simɔn ŋon ɔ ba lee Kirene donɔɔ man nɛ, na ɔ ta lee akuraa ɔ ne kɔŋ Gyerusalɛm donɔɔ man. Keŋte be kyaŋa e te ba ŋere e mo ɔpaŋdaŋ keŋ seele e na ɔ silana Yesu wɔle wɔle. ");
INSERT INTO ntr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na balaŋ burum silana Yesu, mo kpu na ala baŋ bee wii te be tɔɔse ne kyoŋii wɔ fa e nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Keŋte Yesu besenawɔ kɛɛ wɔ te ɔ yako wɔ nyiaa, “Gyerusalɛm ala, ɛ na wii fa maŋ ya. Mɔna ɛ wii fa ɛ wose na ɛ bia. ");
INSERT INTO ntr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nawolo nyi debaŋ daale ne kɔŋ keŋ ɛ ke yako nyiaa, ‘Ɔlamanbose, ɛmɛɛ baŋ bia te doo ɛ tɔɔman see ya te bia te ŋmase ya ade ya nɛ, ɛmɛɛ na nyeebam.’ ");
INSERT INTO ntr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Debaŋ kenaŋ te balaŋ baa yako bulase nyiaa, ‘Ɛ kaa ŋere daa,’ na baa yako bulasebia mɔ nyiaa, ‘Ɛ kaa wuu de dɔɔ!’ ");
INSERT INTO ntr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Akpaa daŋ laŋte ne kpaa la nnɛ na, sena te daŋ dowolo gyae ke yɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Keŋte ba moo nombiakumɛɛyɛɛra bala baale mɔ kaa kpu na Yesu na be kaa ko wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Be kelii botɔɔ keŋ bɛɛ baake ke nyi “Nyeepookoo dɛɛ” nɛ, be gyɔɔ Yesu sakaa ɔpaŋdaŋ dɔɔ. Keŋte be gyɔɔ nombiakumɛɛyɛɛra bala baŋ mɔ sakaa ɔpaŋdaase kpu na e. Ŋolo sakaa ɔ dunoluŋ dɔɔ te ŋolo mɔ sakaa ɔ demena dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Keŋte Yesu yakowɔ nyiaa, “Taata! Mo balaŋ kɛwɔ nombiakumɛɛ kyɛɛ wɔ, nawolo nyi bɔɔ gyeŋ kpene keŋ bɛɛ yɛɛ nɛ ya.” Keŋte be lɔɔ boe mo kpala Yesu kegbase. ");
INSERT INTO ntr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na balaŋ burum seŋɛɛ botɔɔ bɛɛ kɛɛ te Gyudatena kegyiise baŋ mɔ kulu e nyiaa, “Ɔ ne lɛɛ balaŋ nyee, ɛ yela waa lɛɛ ɔ wose na dɛɛ kɛɛ. Ŋgba ŋon kpa ŋon yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Keŋte yoonɔɔtena baŋ mɔ kulu e te be faa e soloŋ keŋ kɔɔ nyaŋe nɛ, ");
INSERT INTO ntr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","te be yakowɔ nyiaa, “Akpaa nyaŋ yɛna Gyudatena gyoo ŋon na, kenaŋ na lɛɛ n wose!” ");
INSERT INTO ntr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te be ŋmarase nombia kɛŋa see ɔ nyee adido nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Botɔɔ te nombiakumɛɛyɛɛra bala baŋ be sakaa ɔpaŋdaase dɔɔ nɛ man ŋolo tee Yesu nyiaa, “Na nyaŋ yɛna nyeelɛɛre ŋon yee? Lɛɛ n wose na n ke lɛɛ daa mɔ.” ");
INSERT INTO ntr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Keŋte ɔ balate ŋon gyɔɔ ɔ nɔɔ dɔɔ nyiaa, “N bee yee Wurubuarɛ ŋgba de popou doo deŋele kewɔŋ dokoloŋ man yee? ");
INSERT INTO ntr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","De nombiakumɛɛ ŋan dɔɔ yɛɛ nɛ, ŋa deŋele kewɔŋ yaa de nyiŋawɔ nɛ. Mɔna balee kei dɔɔ ɔ te yɛɛ nombiikum daale ya.” ");
INSERT INTO ntr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Botɔɔ te ɔ yako Yesu nyi “Yesu, n kɔŋ n gyoori keŋ man na, na wolee maŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Keŋte Yesu yako e nyiaa, “Ampaŋ yaa mɛɛ yako neŋ nyiaa, gyɛŋ nyaŋ ke kyaa me gyaŋ Wurubuarɛ man.” ");
INSERT INTO ntr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Weese ka seŋ dɛɛ nɛ, weese tinaa kegyɔ yela te ditiŋtɛɛ lɛɛ tɛɛle keŋ dɔɔ pou kelii debaŋ keŋ weese be gɛɛse nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Botɔɔ te kanyaŋ keŋ kpaŋɛɛ Wurubuarɛ ɔsom deni dinaa keŋ man nɛ bɛɛsewɔ kyɛɛkyɛɛ ala. ");
INSERT INTO ntr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Keŋte Yesu fae yeesa keŋkeŋ nyiaa, “Taata, me ta mo ma woo do n nyiŋmaa man.” Ɔ ka betaa yako mena pɛ te ɔ kara weesi. ");
INSERT INTO ntr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yoonɔɔtena kegyia ŋon kena kpene keŋ be kɔŋ nɛ, ɔ lese Wurubuarɛ yele yako nyiaa “Ampaŋ, balee kei gbɛɛneŋ tenɛɛ Wurubuarɛ siaman!” ");
INSERT INTO ntr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Balaŋ baŋ pou bɔɔ gyaŋee botɔɔ bɛɛ kɛɛ nɛ naa kpene keŋ be kɔŋ, te ba besewɔ gyu donɔɔ man na ba nyiŋmaase gyakaa ba nyeeya dɔɔ waraŋase man. ");
INSERT INTO ntr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mɔna baŋ pou ba gyeŋ Yesu na ala baŋ bɔɔ sila e lee Galelia donɔɔ man nɛ, seŋawɔ lemlem bɛɛ kɛɛ nombia kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Balee ŋolo kyaawɔ na bɛɛ baake e nyi Gyosɛfo. Ɔ lee Gyudatena donɔɔ keŋ bɛɛ baake ke nyi Arimatia nɛ man. Na ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman te bee bu e mɔ nideli. Ɔ yɛɛ walaŋ ŋon ɔ ne kɛɛ Wurubuarɛ gyoori keŋ siaman te ŋon mɔ kpuɛ Gyudatena kegyiise baŋ man, mɔna ɔ te lɛɛ kpene keŋ bɔɔ bake na kpene keŋ bɔɔ yɛɛ nɛ do ya. ");
INSERT INTO ntr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mena balee kei gyuuwɔ Pilato gyaŋ ka sola gbɛɛ nyi waa mo Yesu woo ŋon ke wuu. ");
INSERT INTO ntr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Keŋte ɔ ka lese woo ŋon lee ɔpaŋdaŋ keŋ dɔɔ te ɔ moo akaralɛɛ milii e te ɔ moo e ke wuu yebɔɔ keŋ bɔɔ kare boe man te be te wuu ta walaŋ na walaŋ ke man see ya nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wee kenaŋ yɛɛ wee keŋ Gyudatena na mo desina ba wose fa ba kefɛɛfowee keŋ kedi. ");
INSERT INTO ntr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ala baŋ bɔɔ sila Yesu lee Galelia kɔŋ nɛ, sila Gyosɛfo gyu te ba ke naa yebɔɔ keŋ na mena keŋ ɔ be wuu Yesu. ");
INSERT INTO ntr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Keŋte ba besewɔ gyu ba akpaŋalaŋse man be kaa gyae teeneŋ ofoŋofoŋ ŋan bɛɛ mo desina woo nɛ, na baa mo kaa buraa woo ŋon na ɔ be nyiŋ wɔlɛɛ bileŋ ya. Mɔna be fɛɛfowɔ Gyudatena kefɛɛfowee keŋ ŋgba mena keŋ Mosesi mmaraase ŋan na wolo nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ba kefɛɛfowee keŋ wɔle tɛɛ kena nebo nebo fuu nɛ, ala baŋ moo ba teeneŋ ofoŋ nyiŋan ŋan bɔɔ gyae see nɛ te be gyuuwɔ yebɔɔ keŋ tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Be kelii botɔɔ nɛ be naawɔ ŋgba boe keŋ bɔɔ mo tɔ yebɔɔ keŋ nɔɔman nɛ te biliŋi laŋ yenaŋ, ");
INSERT INTO ntr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","mena dɔɔ ba gyoowɔ yebɔɔ keŋ man mɔna ba te naa de Gbeŋgyoo Yesu woo ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Be ka seŋ botɔɔ bɛɛ gyueŋ nombia kɛŋa man nɛ, karatetee dokoloŋ te baala bala baŋ ba doona kegbase wolomɛɛ ŋan ŋɛɛ ŋalakee ŋgba akaralɛɛ nɛ kaa bɛɛwɔ lee be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gyakoloŋ kyaŋa ala baŋ te be gɔŋase ba nyeeya. Keŋte baala baŋ bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ ne kɛo walaŋ ŋon ɔ delena nɛ woya dɛɛ? ");
INSERT INTO ntr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔ be kyaa kɛbo ya ɔ te fom. Ɛ te wolee nombia ŋan ɔ be yako ŋon debaŋ keŋ ɔ kyaa ɛ gyaŋ Galelia nɛ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kaboena nyi baa lese maŋ Deniwalaŋ Bu ŋon fa nombiakumɛɛyɛɛra, na baa gyɔ maŋ nyeelabia sakaa ɔpaŋdaŋ dɔɔ na maa yeŋ. Mɔna weeya atoorote na Wurubuarɛ waa gyuusu maŋ lee yeŋ man.’ ” ");
INSERT INTO ntr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Botɔɔ te ala baŋ tɔɔse ɔ nɔɔwoya kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Be ka lee yebɔɔ keŋ tɛɛ nɛ, ba ke yako nombia kɛŋa pou fa ɔ kpilala kufu daale baŋ na ɔ kaseela akaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mɛɛre Magedala na Gyoana na Gyemisi ɔ naa Mɛɛre, na ala akaŋ baŋ be kpuɛ na wɔ nɛ gyuu la ke yako nombia kɛŋa fa kpilala baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mɔna kpilala baŋ gyueŋwɔ nyi ŋan ala baŋ be yako nɛ pou yɛɛ diyiŋ nombia ŋa, mena dɔɔ ba te lɛɛ wɔ di ya. ");
INSERT INTO ntr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Keŋte Pita ŋon korowɔ yeu gyu yebɔɔ keŋ tɛɛ. Ɔ ke buŋawɔ do ɔ sibii kɛɛ yebɔɔ keŋ man na, ɔ naa akaralɛɛ keŋ bɔɔ mo milii e nɛ kaageŋ doo la. Botɔɔ te ɔ besewɔ gyu dɛɛ na ɔ na gyueŋ nombia ŋan be kɔŋ nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mena wee kenaŋ nɛ, Yesu kaseela bala baale leewɔ Gyerusalɛm donɔɔ man bee gyu donɔɔbii daale keŋ bɛɛ baake ke nyi Emause nɛ man. Lee botɔɔ gyu Gyerusalɛm donɔɔ man gyae ke yɛɛ ŋgba gbɛɛkemaase nyetooro (kilometase kufu daale) nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na be dɔŋɛɛ bɛɛ yɔɔ nombia ŋan be kɔŋ nɛ afa. ");
INSERT INTO ntr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba ke ta bɛɛ yɔɔ afa kɛŋa nɛ, Yesu gbagba kaa bɛɛwɔ lee be dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mɔna be ta gyem nyi Yesu ŋonaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Woŋ afa yaa ɛ dɔŋɛɛ ɛ ne yɔɔ mena?” Keŋte be dɔɔwɔ seŋ waraŋase man. ");
INSERT INTO ntr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Te be man ŋolo ŋon bɛɛ baake e nyi Kilopase nɛ bɔɔse Yesu nyiaa, “N yɛɛ ŋɔɔle e Gyerusalɛm donɔɔ man kɛbo, keŋ n ba gyeŋ kpene keŋ be kɔŋ weeya ala kɛŋa yee?” ");
INSERT INTO ntr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Botɔɔ te Yesu bɔɔse wɔ nyiaa “Woŋ nombia kɔŋala?” Keŋte be tiranɔɔ fa e nyiaa, “Yesu Nasarɛte baale ŋon wose man nombia. Balee kei yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e te ɔ kekolosi na ɔ nombia ŋan ɔ be yɛɛ nɛ, lesewɔ wola nyi Wurubuarɛ kpuɛ na e te balaŋ mɔ lɛɛ e di. ");
INSERT INTO ntr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wurubuarɛ saese kegyiise na de donɔɔ kegyiise lese na e fa nyi baa ko, te be gyɔɔ e sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mɔna nafɔ ŋon te de loo gyakaa ɔ dɔɔ nyi waa kaa lɛɛ Iseraetena nyee. Gyɛŋ yɛna weeya atoorote ŋgba kɛŋa pou be kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kɛŋa wɔle nɛ, ala baale baŋ be kpuɛ na daa nɛ kɔŋawɔ kaa yako daa gyakoloŋ nombia ŋaale. Be kpa be karatɛɛwɔ gyu yebɔɔ keŋ tɛɛ, ");
INSERT INTO ntr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mɔna ba te naa Yesu woo ŋon ya te ba besewɔ kɔŋ kaa yako nyi, Wurubuarɛ kpilala bala baale kaa lese ba wose wola wɔ, te be yako wɔ nyi Yesu delena. ");
INSERT INTO ntr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","De man baale mɔ gyuu yebɔɔ keŋ tɛɛ na, ba ke naa kpene kamasɛ ŋgba mena keŋ ala baŋ be yako nɛ mɔna baŋ mɔ te naa Yesu ŋon ya.” ");
INSERT INTO ntr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Botɔɔ te Yesu yako wɔ nyiaa, “O ɛmɛɛ ayiŋtena, weera dɔɔ te ɛ yɛɛ nyoɛnyoɛ na nombia ŋan pou Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ be yako see nɛ ke lɛɛ di mena. ");
INSERT INTO ntr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tekaboena nyi nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ, waa naa diyem kei pɛna waa gyoo ɔ gyoori keŋ man yee?” ");
INSERT INTO ntr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Botɔɔ te Yesu fiasɛɛ ɔ na wola wɔ kpene keŋ bɔɔ ŋmarase Mosesi mmaraase ŋan man, na ŋan Wurubuarɛ akpeŋkpeŋgyɔɔra be yako see lee ɔ wose man nɛ man. ");
INSERT INTO ntr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Be ka benaa donɔɔbii keŋ man bee gyuu nɛ, Yesu yɛɛwɔ ŋgba ɔ ne gbaa waa laŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mɔna be waase e nideli nyi, “Tɛɛ te yuu dɔɔ waa kɔŋ kaa doo be gyaŋ.” Mena dɔɔ ɔ gyuuwɔ kekyaa be gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ŋon na wɔ ke kyaa baa di nɛ, ɔ moo bodobodo te ɔ fanewɔ do Wurubuarɛ nɔɔ te ɔ kɛrɛɛ ke kpala wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Botɔɔ te be sia gyuusuwɔ te ba gyeŋawɔ nyi Yesu ŋonaŋ, keŋte ɔ ŋaalaawɔ be siaman. ");
INSERT INTO ntr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Keŋte be bɔɔse dɔŋa nyiaa, “Debaŋ keŋ ɔ ne kolosi na daa gbɛɛnaa man te ɔ ba lese Wurubuarɛ nombia aŋmaraseŋ see ŋan man wola daa nɛ, de wɔe te lɔ daa yee?” ");
INSERT INTO ntr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Debokenaŋ man te ba korowɔ bileŋ bese gyu Gyerusalɛm donɔɔ man. Botɔɔ te ba ke naa kpilala kufu daale baŋ na balaŋ akaŋ baŋ te yilaa botɔɔ ");
INSERT INTO ntr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na bɛɛ yako nyiaa, “Ampaŋ de Gbeŋgyoo ŋon te fom! Ɔ ta lese ɔ wose wola Simɔn!” ");
INSERT INTO ntr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Botɔɔ te kaseela bala baŋ mɔ yako wɔ kpene keŋ be kɔŋ Emause gbɛɛnaa man nɛ, na mena keŋ Yesu be kɛrɛɛ bodobodo kpala wɔ te bɔɔ gyem nyi ŋon ŋonaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ba ke gyakaa bee kolosi ɔ wose nombia kɛŋa nɛ, Yesu gbagba kaa seŋawɔ be gyaŋ te ɔ yako wɔ nyiaa, “Wosefɛɛreŋ dɛɛ kyaa ɛ man.” ");
INSERT INTO ntr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Be ŋeŋawɔ te gyakoloŋ kyaŋa wɔ, na baŋ gyeŋ nyi woo yaa be naawɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Keŋte Yesu bɔɔse wɔ nyiaa, “Woŋ dɔɔ te ɛ ne yee yaa woŋ dɔɔ te ɛ ne lɛɛ aŋmaareŋ ɛ nyeeya man? ");
INSERT INTO ntr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɛ kɛɛ me nyiŋmaase na me nawɔɔ! Maŋ gbagba ŋonaŋ. Ɛ tina maŋ kɛɛ! Nawolo nyi woo be dana wosenaane na ŋɔɔ ŋgba mena keŋ ɛ ne naa maŋ dana nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ɔ kekolosi taŋ nɛ, ɔ moo ɔ nyiŋmaase na ɔ nawɔɔ wola wɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nombia ŋan doo be nɔɔ te yɛɛ wɔ gyoŋ gbaa keŋ nyi ba te lɛɛ di ya. Keŋte Yesu bɔɔse wɔ nyiaa, “Ɛ dana weenɛɛ ŋaale kɛbo?” ");
INSERT INTO ntr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Keŋte ba moo kpebii keŋ bɔɔ ŋasee ke nɛ duguŋ fa e. ");
INSERT INTO ntr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Te ɔ lɛɛ ke tao be siaman botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Keŋte ɔ yako wɔ nyiaa, “Debaŋ keŋ me kyaa ɛ gyaŋ nɛ me yako ŋon nyiaa, nombii kamasɛ keŋ bɔɔ ŋmarase Mosesi mmaraase ŋan man, na ŋan Wurubuarɛ akpeŋkpeŋgyɔɔra be ŋmarase see na ŋan bɔɔ ŋmarase see nɔɔneŋ tɔne man lee ma wose man nɛ, kaboena nyi ŋe dɛɛ kɔŋ mena.” ");
INSERT INTO ntr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Botɔɔ te ɔ toro ba agyueŋ na baa nyiŋ nyii Wurubuarɛ nombia aŋmaraseŋ see ŋan man. ");
INSERT INTO ntr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Keŋte Yesu yako wɔ nyiaa, “Be yakowɔ Wurubuarɛ nombia aŋmaraseŋ see ŋan man nyiaa, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ, waa naa diyem na waa yeŋ mɔna ka weeya atoorote keŋ na waa foŋ lee yeŋ man, ");
INSERT INTO ntr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","te baa kolosi Wurubuarɛ nombia ɔ yele man fa balaŋ pou tɛɛle kei dɔɔ, na baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa kɔŋ Wurubuarɛ gyaŋ, na Wurubuarɛ ka mo be nombiakumɛɛ kyɛɛ wɔ. Baa fiasɛɛ lee Gyerusalɛm donɔɔ man, pɛna baa gyu donɔɔse akaŋ ŋan man. ");
INSERT INTO ntr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɛmɛɛ yɛna balaŋ baŋ ɛ ke di mena nombia kɛŋa wose man adansɛɛ. ");
INSERT INTO ntr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Maa mo me kya Wurubuarɛ feliŋ ŋon ɔ be yako see nyi waa fa ŋon nɛ kaa do ɛ man. Mɔna ɛ kyaa Gyerusalɛm donɔɔ man kɛbo kelii debaŋ keŋ waa mo mena doŋ kei lee adido kaa do ɛ man.” ");
INSERT INTO ntr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Keŋte Yesu moo ɔ kaseela baŋ lee donɔɔ kenaŋ man gyu Bɛtani donɔɔ nɔɔman, botɔɔ te ɔ gyinaa ɔ nyiŋmaase adido te ɔ hiraa ɔ kaseela baŋ. ");
INSERT INTO ntr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɔ kee hiraa wɔ nɛ, ɔ tinaa wɔ yela te Wurubuarɛ moo e laŋ adido. ");
INSERT INTO ntr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Keŋte ba som e te ba moo kenyaŋee dinaa bese kɔŋ Gyerusalɛm donɔɔ man, ");
INSERT INTO ntr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","te debaŋ kamasɛ na bee gyu ke kyaa Wurubuarɛ ɔsom deni dinaa keŋ man lese Wurubuarɛ yele.");
INSERT INTO ntr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lee kewalaŋ keŋ pɛna Wurubuarɛ ke yɛɛ kpene kamasɛ na, ŋon bɛɛ baake e nyi Wurubuarɛ nombii ŋon nɛ wulaa ɔ kyaa. Na ŋon na Wurubuarɛ kyaa la, te ŋon yɛna Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ŋon na Wurubuarɛ kyaa la leenaŋ kewalaŋ kenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɔ dɔɔ te Wurubuarɛ tɛɛwɔ yɛɛ kpene kamasɛ, te Wurubuarɛ ta lee ɔ wɔle yɛɛ kolo na kolo ya. ");
INSERT INTO ntr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wurubuarɛ nombii kei ne faa na nyeedoŋ, te nyeedoŋ kenaŋ yɛna keŋmaŋee keŋ ne gyuusu balaŋ sia na baa naa Wurubuarɛ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Keŋmaŋee kenaŋ ne ŋmaŋee ditiŋtɛɛ man, mɔna ditiŋtɛɛ keŋ bɛɛ tale di ke dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Debaŋ daale liiwɔ na Wurubuarɛ kpila ɔ kpilale ŋolo ŋon bɛɛ baake e nyi Gyɔn. ");
INSERT INTO ntr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ŋon kɔŋala ɔ kaa di adansɛɛ lee keŋmaŋee keŋ wose man fa balaŋ, na balaŋ pou kenyiŋ ta ɔ dɔɔ lɛɛ keŋmaŋee keŋ di. ");
INSERT INTO ntr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Na ŋon Gyɔn gbagba yɛna keŋmaŋee keŋ ya, mɔna ɔ kɔŋae kaa di adansɛɛ lee keŋmaŋee keŋ wose man. ");
INSERT INTO ntr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ŋon bɛɛ baake e keŋmaŋee gbagba keŋ nɛ waa kɔŋ tɛɛle kei dɔɔ, na ɔ kaa ŋmaŋee fa walaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Keŋmaŋee kenaŋ kaa kyaawɔ tɛɛle kei dɔɔ. Ɔ dɔɔ te Wurubuarɛ tɛɛwɔ yɛɛ kpene kamasɛ tɛɛle kei dɔɔ, mɔna tɛɛle kei dɔɔ balaŋ ta gyeŋ e ya. ");
INSERT INTO ntr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ kɔŋawɔ ŋon gbagba ɔ balaŋ gyaŋ, mɔna ɔ balaŋ te lɛɛ e ya. ");
INSERT INTO ntr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mɔna balaŋ baŋ pou bɔɔ lɛɛ e te bɔɔ lɛɛ di nɛ, ɔ faa wɔ gbɛɛ te ba bese Wurubuarɛ bia. ");
INSERT INTO ntr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ba te yɛɛ Wurubuarɛ bia ŋgba mena keŋ alo na baale na lola bia ba kegyae man nɛ ya. Mɔna Wurubuarɛ gbagba kegyaebii man te ɔ lese wɔ nyi baa yɛɛ ɔ bia. ");
INSERT INTO ntr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ŋon bɛɛ baake e nyi Wurubuarɛ nombii nɛ, kaa bese deniwalaŋ te ɔ kaa kyaawɔ de man weeya akalansɛɛ ŋaale. De naa ɔ gyoorobiiri keŋ nawolo nyi ŋon waageŋ yɛna ɔ kya Wurubuarɛ bu dokoloŋ ŋon nɛ. Ɔ man te Wurubuarɛ bɛrɛɛ na anokoare keŋ doo. ");
INSERT INTO ntr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Gyɔn dii adansɛɛ lee ɔ wose man. Ɔ fae yeesa yako nyi, “Walaŋ kei wose man nombia yaa me wulaa yako ŋon nyiaa, ‘Walaŋ ŋon ɔ dɔŋ me wɔle ɔ ne kɔŋ nɛ ɔ kela maŋ, nawolo nyi ɔ wulaa ɔ kyaa pɛte ba lola maŋ.’ ” ");
INSERT INTO ntr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Lee ɔ bɛrɛɛ keŋ be wulu ɔ man nɛ dɔɔ, te ɔ ne hiraa daa agbaatee agbaatee. ");
INSERT INTO ntr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosesi dɔɔ te Wurubuarɛ tɛɛwɔ mo mmaraase ŋan fa daa, mɔna Yesu Kristo dɔɔ te ɔ tɛɛwɔ wola daa ɔ bɛrɛɛ na wa anokoare keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ŋolo na ŋolo te naa ta Wurubuarɛ na ɔ sia ya, mɔna Wurubuarɛ bu dokoloŋ kooŋ ŋon loŋ bɛɛ lam ŋon na ɔ kya nsana ya nɛ, kaa lesena Wurubuarɛ dinɔɔ wola daa. ");
INSERT INTO ntr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Gyudatena kegyiise baŋ be kyaa Gyerusalɛm donɔɔ man nɛ, kpila Wurubuarɛ saese na Lewitena baale nyi be kaa bɔɔse Gyɔn nyiaa, “Nyaŋ yɛna amɔte?” Gyɔn ta beo wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mɔna ɔ torowɔ yako wɔ nyiaa, “Na maŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Keŋte be bɔɔse e nyiaa, “Kenaŋ na nyaŋ yɛna amɔte? Nyaŋ yɛna Elaegya?” Keŋte ɔ tiranɔɔ fa wɔ nyi, “Koa, na maŋ yɛna Elaegya ya.” Ba besewɔ bɔɔse e nyiaa, “Nyaŋ yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon dɛɛ daa nɛ?” Keŋte Gyɔn tiranɔɔ fa wɔ nyi “Koa, na maŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Keŋte be bɔɔse e nyi “Te kenaŋ na nyaŋ yɛna amɔte? Yako daa nombii dokoloŋ na dee nyiŋ gyu ke yako baŋ bɔɔ kpila daa nɛ. Sena te n ne yako lee nyaŋ gbagba n wose man?” ");
INSERT INTO ntr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Botɔɔ te Gyɔn moo nɔɔwoya ŋan Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya be yako see nɛ tiranɔɔ fa wɔ nyiaa, “Maŋ yɛna woya ŋan ne fae yeesa depampaa dinaa keŋ man nɛ nyiaa, Ɛ tenee de Gbeŋgyoo Wurubuarɛ gbɛɛ see e na ɔ kaa ta ke dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Balaŋ baŋ bɔɔ kpili gyu Gyɔn gyaŋ nɛ, man baale yɛɛ Farasiitenawɔ, ");
INSERT INTO ntr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","keŋte be bɔɔse Gyɔn nyiaa, “Akpaa na nyaŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ ya, yaa Elaegya yaa Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon ya na, woŋ dɔɔ te n ne sɔ balaŋ Wurubuarɛ loŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Botɔɔ te Gyɔn tiranɔɔ fa wɔ nyiaa, “Maŋ dɔɔ loŋ yakaa te me dana mɛɛ sɔ balaŋ Wurubuarɛ loŋ, mɔna ŋolo kyaa ɛ man keŋ ɛ ba gyeŋ e ya. ");
INSERT INTO ntr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ŋon yɛna walaŋ ŋon ɔ dɔŋ me wɔle ɔ ne kɔŋ, keŋ ma te kaboe gba nyi maa buŋ booli ɔ nkyokota ŋmeeseŋ koraŋ gba ya.” ");
INSERT INTO ntr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nombia kɛŋa pou kɔŋae Gyɔɔdan boo diŋgyiŋ donɔɔ keŋ bɛɛ baake ke Bɛtani nɛ man, botɔɔ keŋ Gyɔn ne sɔ balaŋ Wurubuarɛ loŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tɛɛ kena nɛ, Gyɔn naa Yesu ne kɔŋ ɔ gyaŋ te ɔ yakowɔ lee Yesu wose man nyiaa, “Ɛ kɛɛ Wurubuarɛ nambu ŋon. Ŋon na lesena balaŋ lee be dukum man. ");
INSERT INTO ntr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kei yɛna walaŋ ŋon mɔɔ wulaa yako ŋon ɔ wose man nombia nyiaa, ‘Walaŋ ŋon ɔ dɔŋ me wɔle ɔ ne kɔŋ nɛ ɔ kela maŋ. Nawolo nyi ɔ wulaa ɔ kyaa pɛte ba lola maŋ.’ ");
INSERT INTO ntr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nafɔ na maŋ gbagba ba gyeŋ e ya, mɔna ŋon dɔɔ te Wurubuarɛ kpila maŋ nyi me kaa sɔ balaŋ Wurubuarɛ loŋ, na maa lese e debɔɔ wola Iseraetena na baa nyiŋ gyeŋ e.” ");
INSERT INTO ntr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Keŋte Gyɔn dii adansɛɛ nyiaa, “Me naa Wurubuarɛ feliŋ ŋon moo duwuluŋ dinɔɔ tisi lee adido kaa kyaa ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nafɔ maŋ gbagba ba gyeŋ e ya, mɔna Wurubuarɛ ŋon ɔ be kpila maŋ nyi me kaa mo loŋ sɔ balaŋ Wurubuarɛ loŋ nɛ yako na maŋ nyiaa, ‘Walaŋ ŋon n naa Wurubuarɛ feliŋ ŋon de tisi kaa kyaa ɔ dɔɔ nɛ, ŋon ne gyaela waa mo Wurubuarɛ feliŋ ŋon sɔ balaŋ Wurubuarɛ loŋ.’ ");
INSERT INTO ntr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma te naa te mee di adansɛɛ nyiaa, ŋon yɛna Wurubuarɛ bu ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tɛɛ kena nɛ, Gyɔn na ɔ kaseela bala besewɔ gyu boo keŋ nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Keŋte Gyɔn naa Yesu ne lam. Ɔ kena e nɛ te ɔ yakowɔ nyiaa, “Ɛ kɛɛ Wurubuarɛ nambu ŋon!” ");
INSERT INTO ntr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gyɔn kaseela bala baŋ kenyii Gyɔn nɔɔwoya kɛŋa nɛ, be tinaa Gyɔn yela gyu ke sila Yesu. ");
INSERT INTO ntr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu gɛɛsewɔ kɛɛ na te ɔ naa wɔ keŋte ɔ bɔɔse wɔ nyiaa, “Woŋ yaa ɛ ne gyae?” Botɔɔ te baŋ mɔ bɔɔse e nyiaa, “De Gbeŋgyoo, aleŋ te n kyaa?” ");
INSERT INTO ntr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ kɔŋ na ɛ kaa kɛɛ.” Mena dɔɔ be gyuuwɔ kena botɔɔ keŋ ɔ kyaa. Debaŋ kenaŋ na te gyɔ balinɔɔ debaŋ anaara te be kyaawɔ ɔ gyaŋ wee kenaŋ pou. ");
INSERT INTO ntr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Balaŋ bala baŋ bɔɔ nyii Gyɔn nɔɔwoya te bɔɔ sila Yesu nɛ, be man ŋolo yɛna Simɔn Pita ɔ naabu Anderiase. ");
INSERT INTO ntr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kpene keŋ Anderiase be taŋgbɛɛ yɛɛ yɛna nyi, ɔ gyuuwɔ ke kɛo ɔ kegyia Simɔn te ɔ yako e nyiaa, “Da te naa Mesaya ŋon, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Keŋte Anderiase moo Simɔn kɔŋ Yesu gyaŋ. Yesu kena Simɔn nɛ ɔ kɛɛ e yididi te ɔ yako e nyiaa, “Me gyeŋ nyi nyaŋ yɛna Gyɔn bu Simɔn ŋon. Baa baake neŋ nyi Kefase yaa Pita.” Ka asɛɛ yɛna nyi boe. ");
INSERT INTO ntr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tɛɛ kena nɛ, Yesu yɛɛ wa agyueŋ nyi waa gyu Galelia tɛɛle man. Keŋte ɔ naa Filipo te ɔ yako e nyiaa, “Kaa sila maŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo lee donɔɔ keŋ bɛɛ baake ke Bɛtesaida nɛ man. Donɔɔ kenaŋ man mɔ te Anderiase na Pita mɔ leewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo mɔ naa Natanɛle te ɔ yako e nyiaa, “Da te naa walaŋ ŋon Mosesi be ŋmarase ɔ wose man nombia do mmaraa tɔne keŋ man, te Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ mɔ be ŋmarase ɔ wose man nombia nɛ. Bɛɛ baake e nyi Yesu. Ŋon yɛna Yesu, Gyosɛfo bu ŋon ɔ ba lee Nasarɛte nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Keŋte Natanɛle bɔɔse e nyiaa, “Nasarɛte ya? Kolo kpaakpaa daale gyae ke tale lee botɔɔ?” Keŋte Filipo yako e nyiaa, “Nyaŋ kɔŋ na n kaa kɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu kena Natanɛle ne kɔŋ ɔ gyaŋ nɛ ɔ kolosiwɔ lee ɔ wose man nyiaa, “Ɛ kɛɛ, Iserae baale gbagba yaa kei keŋ dekara be doo ɔ man ya.” ");
INSERT INTO ntr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Botɔɔ te Natanɛle bɔɔse e nyiaa, “Sena te n yɛɛwɔ gyeŋ maŋ?” Keŋte Yesu tiranɔɔ fa e nyi, “Me wulaa naa neŋ fiigi daŋ keŋ tɛɛ pɛte Filipo baake neŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Keŋte Natanɛle torowɔ yako nyiaa, “De Gbeŋgyoo, nyaŋ yɛna Wurubuarɛ bu ŋon! Nyaŋ yɛna Iseraetena gyoo ŋon!” ");
INSERT INTO ntr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Keŋte Yesu yako e nyiaa, “Keŋ mɔ yako neŋ nyi me naa neŋ fiigi daŋ keŋ tɛɛ dɔɔ te n ne lɛɛ maŋ di? N kena nombia dinaana ŋan kela kɛŋa.” ");
INSERT INTO ntr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Keŋte Yesu besewɔ yako wɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, ɛ kena ŋgba adido ta toro na Wurubuarɛ kpilala baŋ na gyem tisi maŋ Deniwalaŋ Bu ŋon dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ka weeya atoorote keŋ nɛ, ba kpeo alo ŋolo Kaanan donɔɔ keŋ ke kyaa Galelia tɛɛle man nɛ man. Na Yesu ɔ naa mɔ kyaa botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Be baake Yesu na ɔ kaseela mɔ kɔŋ alowɔle keŋ tɛɛ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Balaŋ baŋ soloŋ ke taŋ nɛ, Yesu ɔ naa yako e nyi “Balaŋ baŋ soloŋ te taŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Botɔɔ te Yesu tiranɔɔ fa e nyiaa, “Nna kei te yɛɛ daa na neŋ de nombia ya. Debaŋ keŋ Wurubuarɛ ba see maŋ nɛ te lii ta ya.” ");
INSERT INTO ntr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Keŋte Yesu ɔ naa yako dekpaŋalaŋ keŋ tewulɛɛ baŋ nyiaa, “Kpene kamasɛ keŋ ɔ yako ŋon nyi yaa yɛɛ na, ɛ yɛɛ ke.” ");
INSERT INTO ntr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Debaŋ kenaŋ na, osuŋse dinaana looro ŋaale baŋɛɛ botɔɔ. Gyudatena ɔsom man na, osuŋse kɛŋa man te bee kyekii loŋ do mo faafo ba wose. Dokoloŋ gyae ke lɛɛ loŋ ŋgba garawaase anoŋ yaa looro nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Botɔɔ te Yesu yako tewulɛɛ baŋ nyiaa, “Ɛ kyekii loŋ do osuŋse ŋan man wulu.” Keŋte tewulɛɛ baŋ kyekii loŋ wulu ŋa belebelebele. ");
INSERT INTO ntr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Keŋte ɔ yako wɔ nyiaa, “Nɛnɛɛ ɛ kyee loŋ keŋ ŋaale gyina kegyia ŋon ɔ seŋɛɛ alowɔle keŋ siaman nɛ.” Te be kyeewɔ gyina e. ");
INSERT INTO ntr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kegyia ŋon daa loŋ keŋ ba bese soloŋ nɛ kɛɛ. Ɔ naawɔ nyi soloŋ keŋ dei, mɔna ɔ ba gyeŋ ke dalee ya, mɔna tewulɛɛ baŋ bɔɔ kyee loŋ keŋ kɔna e nɛ baŋ gyeŋ botɔɔ keŋ kɔɔ lee. Keŋte kegyia ŋon baake alowɔle baale ŋon lee yenaŋ, ");
INSERT INTO ntr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","te ɔ yako e nyiaa, “Balaŋ degyaŋee na, bɛɛ taŋgbɛɛ bo mo soloŋ kpaakpaate fa wɔ, te akpaa be dɛɛse na te bɛɛ mo soloŋ keŋ kɔɔ dei ya nɛ kɔŋ. Mɔna nyaŋ moo soloŋ kpaakpaate keŋ bo weese kaa lii debaŋ kei pɛte n lese ke debɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kei yɛna gyakoloŋ nombia gyaŋgbate keŋ Yesu be yɛɛ Kaanan donɔɔ keŋ ke kyaa Galelia tɛɛle dɔɔ nɛ man. Ɔ moo ke lese ɔ gyoorobiiri wola, te ɔ kaseela baŋ mɔ lɛɛ e di. ");
INSERT INTO ntr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kei wɔle nɛ, ŋon na ɔ naa na ɔ naabia na ɔ kaseela baŋ gyuu donɔɔ keŋ bɛɛ baake ke Kapanum nɛ man ke di weeya akalansɛɛ ŋaale botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Debaŋ keŋ Gyudatena nyeekelɛɛwee keŋ na benaa nɛ, Yesu gyuu Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yesu ke gyu ka gyoo Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man nɛ, ɔ naawɔ nyi baale ne yɔɔ nunkyuese na namense na awuluŋna, na balaŋ baale mɔ kyakɛɛ bɛɛ yɛlɛɛ kɔba. ");
INSERT INTO ntr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mena dɔɔ ɔ moo ŋmeeseŋ ŋmɛ yɛɛ dambila te ɔ moowɔ gegi balaŋ baŋ na be nunkyuese na be namense pou lee dekpaŋalaŋ keŋ man. Ɔ yaasee be kɔbasebia ŋan te ɔ besena be tebuluse ŋan pou buŋii. ");
INSERT INTO ntr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Keŋte ɔ yako balaŋ baŋ bɛɛ yɔɔ awuluŋna nɛ nyiaa, “Ɛ mo wɔ lee kɛbo! Ɛ na mo me kya dɛɛ besena ɛ kebu dedii ya!” ");
INSERT INTO ntr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nombia kɛŋa yela ɔ kaseela baŋ tɔɔse Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nyi, “O Wurubuarɛ, n deni dinaa keŋ man nombia ne hia maŋ nideli, te ŋe te di ma nyee mɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Botɔɔ te Gyudatena kegyiise kaa bɔɔse e nyiaa, “Woŋ gyakoloŋ nombia te nyaŋ ke tale yɛɛ na kawola daa nyi Wurubuarɛ faa na neŋ doŋ nyi nya yɛɛ mena abɔɔ kɛŋa?” ");
INSERT INTO ntr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ yɛlɛɛ Wurubuarɛ ɔsom deni dinaa kei, weeya atoorote na maa ma ke bela.” ");
INSERT INTO ntr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Botɔɔ te Gyudatena kegyiise baŋ yako Yesu nyiaa, “Ba moo kulutooneŋ sɔŋola na looro bo ma Wurubuarɛ ɔsom deni dinaa kei, te nyaŋ n ke tale mo weeya atooro ma ke?” ");
INSERT INTO ntr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mɔna Wurubuarɛ ɔsom deni dinaa keŋ Yesu ne kolosi ka wose man nombia nɛ, yɛna ŋon gbagba ɔ wose. ");
INSERT INTO ntr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mena dɔɔ debaŋ keŋ Yesu be fom lee yeŋ man nɛ, ɔ kaseela baŋ tɔɔsewɔ nyi ɔ yako mena nombia kɛŋa. Te be lɛɛ Wurubuarɛ nombia aŋmaraseŋ see, na Yesu nombia ŋan ɔ be yako nɛ di nideli. ");
INSERT INTO ntr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu ke kyaa Gyerusalɛm Gyudatena nyeekelɛɛweeya kedi ŋan man nɛ, balaŋ burum naa gyakoloŋ nombia ŋan ɔ be yɛɛ nɛ te be lɛɛ e di. ");
INSERT INTO ntr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mɔna Yesu ta mo ɔ wose lɔ be dɔɔ ya, nawolo nyi ɔ gyeŋ walaŋ kamasɛ dinɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Te yɛɛ keŋ nyi ŋolo keyako deniwalaŋ nombii fa e ya, nawolo nyi ɔ gyeŋ walaŋ kamasɛ nyeeman nombia. ");
INSERT INTO ntr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mena debaŋ kenaŋ man nɛ, na Gyudatena kegyia ŋolo kyaawɔ keŋ ɔ yele yɛna Nikodemose. Ɔ kpuɛ Farasiitena dikpii keŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wee daale nelim nɛ ɔ korowɔ gyu Yesu gyaŋ te ɔ yako e nyiaa, “Kegyia, da gyeŋ nyi n yɛɛ wolale e ŋon Wurubuarɛ be kpila neŋ. Nawolo nyi ŋolo be kyaa keŋ waa tale yɛɛ gyakoloŋ nombia na nombia dinaana ŋan n ne yɛɛ nɛ, keŋ nyi Wurubuarɛ be kpuɛ na e ya.” ");
INSERT INTO ntr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Botɔɔ te Yesu yako e nyiaa, “Mɛɛ yako neŋ anokoare n ke nyii nyiaa, akpaa be ta bese lola walaŋ ya nɛ, ɔ be gyae waa naa Wurubuarɛ gyoori keŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Keŋte Nikodemose bɔɔse Yesu nyiaa, “Walaŋ ŋon ɔ ba bee na, sena te baa bese tale lola e? Waa bese tale gyoo ɔ naa tɔɔman na baa lola e bela?” ");
INSERT INTO ntr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Botɔɔ te Yesu tiranɔɔ fa e nyiaa, “Mɛɛ yako neŋ anokoare n ke nyii nyiaa, akpaa ba te sɔ neŋ Wurubuarɛ loŋ na Wurubuarɛ ka mo ɔ feliŋ do n man ya na, n be gyae n ke tale gyoo Wurubuarɛ gyoori keŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Deniwalaŋ na lola ɔ dinɔɔ bo, te Wurubuarɛ feliŋ ŋon mɔ na lola walaŋ bo ŋgba Wurubuarɛ dinɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na yela keyɛɛ neŋ gyakoloŋ nyi me kpa, kaboena nyi ba bese lola neŋ bela ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Feliŋ ne gyɔɔ bo gyu botɔɔ keŋ kɛɛ gyae. N ne nyii mena keŋ kɛɛ gyɔɔ mɔna n ba gyeŋ ke dalee yaa ke dee gyue ya. Mena mɔ te doo fa walaŋ kamasɛ ŋon Wurubuarɛ feliŋ ba lola e nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Keŋte Nikodemose bɔɔse Yesu nyiaa, “Sena te kɛŋa gyae ke tale kɔŋ mena?” ");
INSERT INTO ntr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Botɔɔ te Yesu bɔɔse e nyiaa, “Ŋgba n yɛɛ Gyudatena wolale kegyia e. N bee nyii mena nombia kɛŋa man yee? ");
INSERT INTO ntr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mɛɛ yako neŋ anokoare n ke nyii nyiaa, nombia ŋan da gyeŋ nɛ te dɛɛ yako te ŋan dɛɛ naa mɔ nɛ te dee di ŋa wose man adansɛɛ, mɔna ɛ bɛɛ lɛɛ nombia ŋan dɛɛ yako ŋon nɛ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mɛɛ yako ŋon tɛɛle kei dɔɔ nombia te ɛ bɛɛ lɛɛ ŋa di ya na, sena te me yako ŋon Wurubuarɛ man nombia na ɛ kelɛɛ ŋa di? ");
INSERT INTO ntr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ŋolo na ŋolo te gyuu ta Wurubuarɛ man ya, Gyisɛ maŋ Deniwalaŋ Bu ŋon mɔɔ lee botɔɔ kɔŋ nɛ maageŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ɛ gyeŋ nyi gyaŋgba keŋ na Wurubuarɛ yela Mosesi yɛɛ dom te ɔ moowɔ mataa na daŋ adido depampaa dinaa keŋ man. Walaŋ kamasɛ ŋon ɔ be gyina ɔ sia kɛɛ mena dom kei na ɔ nyiŋa nyeedoŋ. Mena ke te baa gyɔ maŋ Deniwalaŋ Bu ŋon mɔ mataa na ɔpaŋdaŋ adido. ");
INSERT INTO ntr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Na walaŋ kamasɛ ŋon ɔ lɛɛ maŋ di na, waa nyiŋ nyeedoŋ kekpaa keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Lee mena keŋ Wurubuarɛ ne gyae balaŋ dɔɔ te ɔ moo ɔ bu dokoloŋ kooŋ ŋon fa, nyi walaŋ kamasɛ ŋon ɔ lɛɛ e di na ɔ be gyae waa yeŋ leki ya, mɔna waa nyiŋ nyeedoŋ kekpaa.” ");
INSERT INTO ntr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nawolo nyi Wurubuarɛ te kpila ɔ bu tɛɛle kei dɔɔ nyi ɔ kaa bu balaŋ fɔɔ ya, mɔna ɔ kpila e bo na balaŋ ke ta ɔ dɔɔ nyiŋ nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Walaŋ kamasɛ ŋon ɔ lɛɛ e di na bɔɔ gyae baa bu e fɔɔ ya, te ŋon ɔ te lɛɛ e di ya na be wulaa bu e fɔɔ, nawolo nyi ɔ te lɛɛ Wurubuarɛ bu dokoloŋ kooŋ ŋon di ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nombia ŋan bɔɔ mo bu tɛɛle kei dɔɔ balaŋ fɔɔ yɛna nyi, keŋmaŋee te kɔŋ tɛɛle kei dɔɔ, mɔna balaŋ ne gyae ditiŋtɛɛ bo kela keŋmaŋee keŋ. Nawolo nyi be nombia ŋan bɛɛ yɛɛ nɛ yɛɛ dukum ke. ");
INSERT INTO ntr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Walaŋ kamasɛ ŋon ɔ ne yɛɛ dukum na, ɔ ne kɔla keŋmaŋee keŋ te ɔ bɛɛ benaa ke ya. Nawolo nyi ɔ bɛɛ gyae nyi ɔ nombiakumɛɛ ŋan ka lee debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mɔna walaŋ kamasɛ ŋon ɔ ne yɛɛ nombia kpaakpaa nɛ, ɔ na benaa keŋmaŋee keŋ. Nawolo nyi keŋmaŋee keŋ gyae ka lese ɔ nombia ŋan ɔ ne yɛɛ nɛ wola nyi ɔ ne yɛɛ Wurubuarɛ kegyaebii. ");
INSERT INTO ntr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kɛŋa wɔle nɛ Yesu na ɔ kaseela baŋ gyuu Gyudia tɛɛle man. Yesu kyaawɔ botɔɔ weeya akalansɛɛ ŋaale te ɔ sɔɔ balaŋ Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Debaŋ kenaŋ na Gyɔn mɔ ne sɔ balaŋ Wurubuarɛ loŋ donɔɔ keŋ bɛɛ baake ke nyi Aenɔn keŋ ka benaa na Salim donɔɔ nɛ man. Nawolo nyi na loŋ boe botɔɔ, te balaŋ mɔ na gyem tisi ɔ dɔɔ nyi waa sɔ wɔ Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Debaŋ kenaŋ na ba te kyaŋa ta Gyɔn tɔ deni ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gyuda baale ŋolo na Gyɔn kaseela baŋ man baale lɛɛ aŋmaareŋ lee mena keŋ bɛɛ mo loŋ faafo ba wose lee ba amanberɛ gbɛɛ nɛ wose man. ");
INSERT INTO ntr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Botɔɔ te Gyɔn kaseela baŋ kɔŋawɔ Gyɔn gyaŋ kaa yako e nyiaa, “De Gbeŋgyoo, n ne tɔɔse balee ŋon nafɔ ɔ kpuɛ na daa Gyɔɔdan boo keŋ diŋgyiŋ, te n be di ɔ wose man adansɛɛ nideli nɛ? Kɛɛ, ɔ ne sɔ balaŋ Wurubuarɛ loŋ, te balaŋ pou ne gyu ɔ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Keŋte Gyɔn tiranɔɔ fa wɔ nyiaa, “Nyi Wurubuarɛ te fa walaŋ gbɛɛ nyi waa yɛɛ kolo ya nɛ, ɔtenate be gyae waa tale yɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɛmɛɛ gbagba ɛ ke tale di maŋ adansɛɛ nyi me yakowɔ nyiaa, Na maŋ yɛna Nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ ya, mɔna Wurubuarɛ kpila maŋ bo nyi maa kyaŋ gbɛɛ ta ɔ siaman kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Keŋte Gyɔn gyɔɔ dudu yako wɔ nyiaa, “Walaŋ ŋon ɔ dana alowɔle na, ŋon yɛna alowɔle ŋon baale. Mɔna alowɔle baale ŋon ɔ gyoona dɔɔ bɛɛ sem bo yenaŋ tei, te akpaa be nyii alowɔle baale ŋon woya na ne yɛɛ wɔ gyoŋ nideli. Mena mɔ yaa yɛɛ maŋ gyoŋ nideli debokeiman ŋgba mɔɔ nyii Yesu nkaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kaboena nyi Yesu yele dɛɛ lee kela maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Walaŋ ŋon ɔ ba lee adido kɔŋ nɛ ɔ kela walaŋ kamasɛ, te walaŋ ŋon ɔ ba lee tɛɛle kei dɔɔ nɛ ɔ yɛɛ tɛɛle kei dɔɔ walaŋ e te ɔ ne kolosi tɛɛle kei dɔɔ nombia bo. Walaŋ ŋon ɔ ba lee adido nɛ, ɔ kela kpene kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nombia ŋan ɔ be naa na ŋan ɔ be nyii nɛ wose man adansɛɛ te ɔ ne dii, mɔna ŋolo te lɛɛ wa adansɛɛ keŋ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Te walaŋ ŋon ɔ be lɛɛ wa adansɛɛ keŋ di na, na ɔtenate te sɛɛ baa nyi Wurubuarɛ nombia ŋan yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Walaŋ ŋon Wurubuarɛ be kpila e na ɔ ne kolosi Wurubuarɛ nombia bo, nawolo nyi Wurubuarɛ ta mo ɔ feliŋ ŋon do walaŋ ŋonaŋ man nideli. ");
INSERT INTO ntr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kya ŋon ne gyae ɔ bu ŋon nombia, te ɔ moo kpene kamasɛ do e ɔ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Walaŋ kamasɛ ŋon ɔ lɛɛ ɔ bu ŋon di na waa nyiŋ nyeedoŋ kekpaa, te walaŋ kamasɛ ŋon ɔ bɛɛ ɔ bu ŋon na ɔ be gyae waa nyiŋ nyeedoŋ kei ya, mɔna Wurubuarɛ waa gyeŋ baŋ do e kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farasiitena baŋ nyiiwɔ nyi Yesu ne nyiŋ balaŋ burum sɔ wɔ Wurubuarɛ loŋ kela Gyɔn Wurubuarɛ loŋsɔɔre. ");
INSERT INTO ntr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mɔna Yesu gbagba dɔɔ ɔ te sɔ ŋolo na ŋolo Wurubuarɛ loŋ ya, ɔ kaseela baŋ sɔɔ na wɔ. ");
INSERT INTO ntr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu ke nyii mena keŋ balaŋ ne kolosi ɔ wose man nombia nɛ, ɔ korowɔ lee Gyudia tɛɛle man bese gyu Galelia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na kaboena nyi waa mo na Samaria tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mena dɔɔ ɔ moowɔ botɔɔ kelii Samariatena donɔɔ keŋ bɛɛ baake ke nyi Sikya nɛ man. Sikya donɔɔ kei benaa na tɛɛle keŋ Gyekɔpo ba mo fa ɔ bu Gyosɛfo nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na Gyekɔpo ditiribuŋ doo botɔɔ. Yesu kelii botɔɔ nɛ, na ɔ te kaa mena dɔɔ ɔ tisiwɔ kyaa ditiribuŋ keŋ gyaŋ. Debaŋ kenaŋ na weese ta seŋ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɔ ke kyaa botɔɔ nɛ Samaria alo ŋolo kɔŋawɔ botɔɔ ɔ kaa kyee loŋ, keŋte Yesu sola e nyi “Fa maŋ loŋ maa nyɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Debaŋ kenaŋ na, ɔ kaseela baŋ te lam donɔɔ keŋ man be kaa lɛɛ weenɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Botɔɔ te Samaria alo ŋon yako Yesu nyiaa, “N yɛɛ Gyuda baale e te maŋ mɔ yɛɛ Samaria alo e. Woŋ dɔɔ te n na sola maŋ loŋ?” Keŋ dɔɔ ɔ be bɔɔse mena yɛna nyi, Gyudatena na Samariatena bɛɛ gyoo ya. ");
INSERT INTO ntr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Keŋte Yesu tiranɔɔ fa e nyiaa, “Akpaa nyeŋ gyeŋ Wurubuarɛ kolo anefaŋ na walaŋ ŋon ɔ na sola neŋ loŋ kei nɛ, nafɔ nyaŋ ka sola e na waa fa neŋ loŋ keŋ kɛɛ fa nyeedoŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Botɔɔ te alo ŋon yako e nyiaa, “Kegyia, ditiribuŋ keŋ dana siiliŋ te n be dana kpene keŋ n ka mo kyee loŋ keŋ ya. Aleŋ te nyaŋ kenyiŋ mena nyeedoŋ loŋ kei. ");
INSERT INTO ntr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yaa nyaŋ kela na de naana Gyekɔpo ŋon ɔ be wula ditiribuŋ kei fa daa nɛ? Ŋon gbagba na ɔ bia na ɔ wonembia pou nyɔɔ loŋ lee ditiribuŋ kei man.” ");
INSERT INTO ntr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Keŋte Yesu tiranɔɔ fa alo ŋon nyiaa, “Walaŋ kamasɛ ŋon waa nyɔɔ loŋ kei nɛ, loŋboaneŋ gyae ka ko e bela. ");
INSERT INTO ntr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mɔna walaŋ kamasɛ ŋon waa nyɔɔ loŋ keŋ maa fa e nɛ, loŋboaneŋ be gyae ka ko e bela ya. Loŋ keŋ maa fa e nɛ gyae ke doo ɔ man ŋgba ditiribuŋ nɛ, na ka ke fa e nyeedoŋ loŋ na waa nyiŋ nyeedoŋ kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Botɔɔ te alo ŋon yako e nyiaa, “Kegyia, akpaa mena na fa maŋ mena loŋ kei na loŋboaneŋ ba tekaa ko maŋ bela ya, na maa tina ditiribuŋ kei man kekɔŋ yela.” ");
INSERT INTO ntr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Keŋte Yesu yako e nyiaa, “Gyu ke baake n baale na ɛ ke kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Te alo ŋon yako e nyiaa, “Mɔɔ dana baale ya.” Keŋte Yesu yako e nyiaa, “N te yako anokoare nyi n be dana baale ya. ");
INSERT INTO ntr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","N taŋ ke yala baala banoŋ, te ŋon gyaŋ n kyaa debokeiman nɛ ɔ te yɛɛ n baale e ya. Mena dɔɔ nombia ŋan n be yako maŋ nɛ yɛɛ ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Botɔɔ te alo ŋon yako e nyiaa, “Kegyia ma te naa nyi n yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","De naanaɔ som Wurubuarɛ bo bula kei dɔɔ, mɔna ɛmɛɛ Gyudatena kpa Gyerusalɛm donɔɔ man te kaboena nyi dɛɛ som Wurubuarɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Keŋte Yesu yako e nyiaa, “Alo lɛɛ maŋ di, debaŋ daale gyae kekɔŋ keŋ bɔɔ gyae baa tekaa som Wurubuarɛ bula kei dɔɔ yaa Gyerusalɛm donɔɔ man ya. ");
INSERT INTO ntr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɛmɛɛ Samariatena na som Wurubuarɛ ŋon ɛ ba gyeŋ e ya, te daa Gyudatena dɔɔ dɛɛ som Wurubuarɛ ŋon da gyeŋ e, nawolo nyi nyeekelɛɛ gyae ke ta bo Gyudatena dɔɔ kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Debaŋ daale ne kɔŋ te ke taŋ kekɔŋ, keŋ nyi baŋ bɛɛ som Wurubuarɛ anokoare man nɛ, baa mo Wurubuarɛ Feliŋ na anokoare bo som Wurubuarɛ nawolo nyi mena somra kɛwɔ dinɔɔ te Wurubuarɛ ne gyae. ");
INSERT INTO ntr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wurubuarɛ yɛɛ feliŋ e, mena dɔɔ baŋ baa som e nɛ kaboena nyi baa mo ɔ feliŋ na anokoare som e.” ");
INSERT INTO ntr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Botɔɔ te Samaria alo ŋon yako e nyiaa, “Ma gyeŋ nyi Nyeelɛɛre ŋon bɛɛ baake e nyi Kristo nɛ waa kɔŋ. Ɔ kɔŋ na waa kaa lese kpene kamasɛ man fa daa.” ");
INSERT INTO ntr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Keŋte Yesu torowɔ yako e nyiaa, “Maŋ ŋon mɛɛ kolosi na neŋ nɛ, maŋ yɛna nyeelɛɛre ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Be kee kolosi kenaŋ nɛ, te Yesu kaseela baŋ leewɔ donɔɔ man kɔŋ. Ba kena ŋgba Yesu na alo ŋon seŋɛɛ bee kolosi nɛ, yɛɛ wɔ gyakoloŋ. Mɔna be man ŋolo te tale bɔɔse alo ŋon nyi woŋ te ɔ ne gyae ya, te ba te tale bɔɔse Yesu mɔ nyi weera ɔ ne kolosi na alo ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Botɔɔ te alo ŋon tina osuŋ keŋ yela, te ɔ yeuwɔ gyu donɔɔ keŋ man ke yako balaŋ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ɛ kɔŋ kaa kɛɛ balee ŋolo ŋon ɔ be yako maŋ ma wose man nombia ŋan pou mɔɔ yɛɛ nɛ. Na ŋon yɛna Kristo, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ baa yaa?” ");
INSERT INTO ntr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mena dɔɔ balaŋ leewɔ donɔɔ keŋ man kɔŋ Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Debaŋ kenaŋ na te ɔ kaseela baŋ waase e nyiaa, “De Gbeŋgyoo mo kolo tina n nɔɔ” ");
INSERT INTO ntr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Keŋte Yesu yako wɔ nyiaa, “Me dana weenɛɛ ŋaale maa di keŋ ɛ ba gyeŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Botɔɔ te ɔ kaseela baŋ bɔɔse dɔŋa nyiaa, “Doona ŋolo saa weenɛɛ baa kɔna e?” ");
INSERT INTO ntr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Keŋte Yesu yako wɔ nyiaa, “Me weenɛɛ yɛna nyi maa yɛɛ me kya ŋon ɔ be kpila maŋ nɛ kegyaebii, na maa yɛɛ tom keŋ ɔ ba mo fa maŋ nɛ kelii ɔto. ");
INSERT INTO ntr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɛmɛɛ gbagba ne tale yako nyi ‘Te ka gyaalaŋna banaara na weenɛɛ kekɛrɛɛ te lii.’ Mɛɛ yako ŋon ɛ ke nyii nyiaa, ɛ gyina ɛ sia na ɛ ke kɛɛ wɔɔse ŋan. Ɛ kena nyi abɔɔ ŋan te yɛɛ na kekɛrɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Walaŋ ŋon ɔ ne kɛrɛɛ weenɛɛ ŋan nɛ baa tɔ e kom, te ɔ ne yilaa abɔɔ ŋenaŋ bo see fa nyeedoŋ kekpaakekpaa keŋ. Mena dɔɔ walaŋ ŋon ɔ be fare na walaŋ ŋon ɔ be kɛrɛɛ nɛ pou baa bom di gyoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Dudu keŋ bɔɔ gyɔɔ nyi, ‘Ŋolo ne duula te ŋolo mɔ ne karala’ nɛ yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me kpila ŋon baa nyi ya gyu ke kɛrɛɛ weenɛɛ wɔɔ keŋ ɛ te yɛɛ tom ya nɛ man. Baale yɛɛna tom keŋ, te ɛmɛɛ kɔŋawɔ ɛ ne di ba tom keŋ bɔɔ yɛɛ nɛ tɔnɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Balaŋ baŋ be kyaa Samaria donɔɔ keŋ man nɛ, be man burum lɛɛ Yesu di nawolo nyi alo ŋon yakowɔ nyiaa, “Ɔ te yako maŋ ma wose man nombia ŋan pou weesɛɛ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mena dɔɔ Samariatena baŋ kekɔŋ ɔ gyaŋ nɛ, be waase e nyi waa kyaa be gyaŋ, te Yesu dii weeya ala be gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesu nombia ŋan ɔ ba wolo nɛ yela balaŋ burum lɛɛ e di. ");
INSERT INTO ntr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Keŋte be yako alo ŋon nyiaa, “Nɛnɛɛ dɔɔ nɛ na n nɔɔwoya ŋan dɔɔ te de lɛɛ e di ya, mɔna daa gbagba te nyii e te da te naa nyi ŋon yɛna balaŋ pou nyeelɛɛre gbagba ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu kedi weeya ala botɔɔ wɔle nɛ, ɔ leewɔ botɔɔ bese gyu Galelia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nawolo nyi Yesu gbagba yakowɔ nyiaa, “Bɔɔ ne lɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre kamasɛ do ŋon gbagba ɔ donɔɔ man ya.” ");
INSERT INTO ntr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu kekɔŋ kaa gyoo Galelia nɛ, botɔɔtena lɛɛ e nideli, nawolo nyi be naa nombia ŋan pou ɔ be yɛɛ Gyerusalɛm donɔɔ man debaŋ keŋ bɔɔ gyu be kaa di ba nyeekelɛɛwee keŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Keŋte Yesu besewɔ gyu Kaanan donɔɔ keŋ ke kyaa Galelia tɛɛle man nɛ man. Mena donɔɔ kenaŋ man te ɔ besena loŋ yɛɛ soloŋ nɛ. Debaŋ kenaŋ na tomyɛɛre kegyia ŋolo kyaa botɔɔ keŋ ɔ bu na wee Kapanum donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tomyɛɛre kegyia ŋon kenyii nyi Yesu ta lee Gyudia kɔŋ Galelia botɔɔ nɛ, ɔ gyuuwɔ ɔ gyaŋ ke waase e nyi ɔ bu na wee ɔ doo Kapanum donɔɔ man ɔ ne gyae waa yeŋ. Mena dɔɔ waa kɔŋ na ɔ kaa kyɔ e kawee fa e. ");
INSERT INTO ntr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Botɔɔ te Yesu yako e nyiaa, “Na ɛ kena gyakoloŋ nombia na nombia dinaana ya nɛ, nafɔ ɛ man walaŋ kamasɛ be gyae waa lɛɛ maŋ di ya.” ");
INSERT INTO ntr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Keŋte kegyia ŋon yako Yesu nyiaa, “Me Gbeŋgyoo, waase kɔŋ dee gyu bileŋ na mena ya na me bu ŋon waa yeŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Botɔɔ te Yesu yako e nyiaa, “Ta, n bu ŋon waa nyiŋ nyeedoŋ.” Balee ŋon lɛɛ Yesu nɔɔwoya ŋan di te ɔ laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Balee ŋon keta ɔ ne gyu ɔ dɛɛ nɛ, ɔ gyaŋee na ɔ tewulɛɛ gbɛɛnaa man te be yako e nyiaa, “N bu ŋon wose te yɛɛ e doŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Botɔɔ te balee ŋon bɔɔse ɔ tewulɛɛ baŋ nyiaa, debaŋ woŋti man te me bu ŋon wose yɛɛ e doŋ? Keŋte be tiranɔɔ fa nyiaa, “Dana weeseteŋteŋ kegyɔ ŋgba debaŋ dokoloŋ nɛ, te bu ŋon wose yɛɛ e doŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Botɔɔ te ɔ kya ŋon tɔɔsewɔ nyiaa, debaŋ kenaŋ man pɛpɛɛpɛ te Yesu yako e nyiaa, “N bu ŋon wose gyae ke yɛɛ e doŋ.” Mena dɔɔ ŋon na ɔ dekpaŋalaŋmantena pou lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu ka lee Gyudia kɔŋ Galelia tɛɛle man nɛ, kei yɛna gyakoloŋ nombia bolate keŋ ɔ be yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kɛŋa wɔle nɛ, Gyudatena ne di bɔ ɔsom wee dinaa daale Gyerusalɛm donɔɔ man, te Yesu mɔ gyuu botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na depaa daale kyaa Gyerusalɛm donɔɔ man keŋ bɛɛ baake ke be dɛɛ dei man nyi Bɛtesaida. Mena depaa kei benaa na denanɔɔ keŋ bɛɛ baake ke nyi “Namense Denanɔɔ” nɛ, te be baŋee kefɛɛse anoŋ kilisi ke. ");
INSERT INTO ntr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kaweesetena kpookpoo burum ŋgba siayɛlɛɛsatena na ɔtakasese na baŋ ba yenaase ba yekee nɛ na lee donɔɔ keŋ man kaa doo botɔɔ daa loŋ keŋ kewosi. ");
INSERT INTO ntr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nawolo nyi be kyaa be kyaa na, Wurubuarɛ kpilale ne kyaa kaa wosi loŋ kenaŋ te kaweete ŋon ɔ taŋgbɛɛ ka gyoo loŋ keŋ man na, ɔ kawee ne taŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na balee ŋolo ŋon ɔ be tekerii kulutooneŋ sao na kufu gyanaara nɛ doo botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu kena balee ŋonaŋ te ɔ ke nyii nyi ɔ ta wee kyare nɛ ɔ bɔɔse e nyiaa, “N ne gyae n kawee ke taŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Botɔɔ te kaweete ŋon tiranɔɔ fa e nyiaa, “Me Gbeŋgyoo, akpaa be wosi loŋ keŋ na, mɔɔ ne nyiŋ ŋon waa gate maŋ ka do ke man ya. Akpaa ma mo maa yɛɛ kakyeŋ koro ka gyoo na ŋolo te taŋgbɛɛ maŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Botɔɔ te Yesu yako e nyiaa, “Koro! Gate n dofoŋoŋ na n ke ta.” ");
INSERT INTO ntr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Debokenaŋ man te balee ŋon kawee taŋawɔ te ɔ korowɔ gate ɔ dofoŋoŋ te ɔ tɛɛwɔ laŋ. Mena wee kenaŋ yɛɛ Gyudatena kefɛɛfowee ke. ");
INSERT INTO ntr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mena dɔɔ Gyudatena kegyiise yako balee ŋon bɔɔ kyɔ e nɛ nyiaa, “Gyɛŋ yɛɛ da kefɛɛfowee ke, te da mmaraa bɛɛ fa gbɛɛ nyi nya seele n dofoŋoŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Keŋte balee ŋon tiranɔɔ fa wɔ nyiaa, “Walaŋ ŋon ɔ be kyɔ maŋ me kawee nɛ, yako na maŋ nyi maa gate ma dofoŋoŋ na maa ta.” ");
INSERT INTO ntr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Botɔɔ te be bɔɔse e nyiaa, “Walaŋ woŋti yako na neŋ nyi nya gate n dofoŋoŋ na n keta?” ");
INSERT INTO ntr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mɔna balee ŋon Yesu be kyɔ e ɔ kawee nɛ, ta gyem nyi Yesu kyɔɔna e ɔ kawee keŋ ya. Nawolo nyi na balaŋ boe botɔɔ te Yesu mɔ ta ŋere gyoo be man. ");
INSERT INTO ntr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kenaŋ wɔle nɛ, Yesu kena balee ŋonaŋ Wurubuarɛ ɔsom deni dinaa keŋ man te ɔ yako e nyiaa, “Kɛɛ, nɛnɛɛ n wose te yɛɛ neŋ doŋ, na tekaa yɛɛ dukum bela ya. Na mena ya na kpene keŋ gyae kekɔŋ n dɔɔ nɛ, gyae ka kela kei.” ");
INSERT INTO ntr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Botɔɔ te balee ŋon gyuuwɔ keyako Gyudatena kegyiise baŋ nyiaa, Yesu kyɔɔ na e ɔ kawee keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mena dɔɔ Gyudatena kegyiise baŋ naase Yesu diyem, nawolo nyi ɔ te kyɔ kawee ba kefɛɛfowee. ");
INSERT INTO ntr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Keŋte Yesu yako wɔ nyiaa, “Me kya Wurubuarɛ ne yɛɛ tom debaŋ kamasɛ kaa lii na gyɛŋ, mena dɔɔ kaboena nyi maŋ mɔ maa yɛɛ tom mena.” ");
INSERT INTO ntr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lee mena nombia kɛŋa dɔɔ nɛ Gyudatena kegyiise baŋ yase sia gyae gbɛɛ keŋ baa mo ko Yesu. Nawolo nyi na keŋ ɔ be wɔlɛɛ ba kefɛɛfowee keŋ kaageŋ dɔɔ ya, mɔna ɔ kpa ɔ kya yɛna Wurubuarɛ keŋ nawolo nyi ɔ dokoso yɛna Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, kolo be kyaa keŋ maŋ Wurubuarɛ bu ŋon ne yɛɛ ma wose dɔɔ ya. Kpene keŋ me naa me kya ne yɛɛ na keŋ te mɛɛ yɛɛ. Kpene keŋ kya ŋon ne yɛɛ na, keŋ te maŋ ɔ bu ŋon mɔ ne yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nawolo nyi me kya ne gyae maŋ te ɔ na wola maŋ kpene kamasɛ keŋ ŋon gbagba ne yɛɛ nɛ. Waa wola maŋ abɔɔ dinaana ŋan kela kɛŋa na maa yɛɛ, na ɛ wose ka yeŋ ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mena keŋ kya ŋon ne gyuusu woya te ɔ ne fa wɔ nyeedoŋ nɛ, mena kee te maŋ ɔ bu ŋon mɔ maa fa balaŋ baŋ maŋ gbagba ne gyae nɛ nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kya ŋon gbagba bee di balaŋ nombia ya. Ɔ ta mo balaŋ nombia kedi pou do maŋ ɔ bu ŋon nyiŋmaa man, ");
INSERT INTO ntr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","na balaŋ pou ke nyiŋ lese maŋ ɔ bu ŋon yele ŋgba mena keŋ bɛɛ lese me kya ŋon yele nɛ. Walaŋ ŋon ɔ bɛɛ lese maŋ ɔ bu ŋon yele ya na, ɔ bɛɛ lese me kya ŋon ɔ be kpila maŋ ɔ bu ŋon nɛ yele ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ kamasɛ ŋon ɔ nyii me nɔɔwoya te ɔ lɛɛ walaŋ ŋon ɔ be kpila maŋ nɛ di na, waa nyiŋ nyeedoŋ kekpaa te bɔɔ gyae baa bu e fɔɔ ya. Kei nawolo baa nyi ɔ ta lee yeŋ man kɔŋ nyeedoŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, debaŋ daale ne kɔŋ te ke taŋ ke kɔŋ keŋ balaŋ baŋ be yɛɛ ŋgba woya nɛ, nawolo nyi ba te lɛɛ Wurubuarɛ nombia ŋan di dɔɔ ya nɛ, baa nyii maŋ Wurubuarɛ bu ŋon dei. Balaŋ baŋ baa nyii me dei te baa yɛɛ kpene keŋ mɔɔ yako wɔ nɛ na baa nyiŋ nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mena keŋ me kya ŋon ne fa balaŋ nyeedoŋ nɛ, mena mɔ te ɔ faa maŋ ɔ bu doŋ nyi maa fa balaŋ nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɔ te fa maŋ ɔ bu ŋon doŋ nyi maa di balaŋ nombia, nawolo nyi maŋ yɛna Deniwalaŋ Bu ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ɛ na yeli nombia kɛŋa ke yɛɛ ŋon gyakoloŋ ya, nawolo nyi debaŋ daale gyae kekɔŋ keŋ woya pou baa nyii ma woya, ");
INSERT INTO ntr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na baa lee ba yebɔɔse man kɔŋ. Baŋ bɔɔ yɛɛ nombia kpaakpaa nɛ baa koro na baa nyiŋ nyeedoŋ, te baŋ bɔɔ yɛɛ nombiakumɛɛ nɛ baa koro na baa bu wɔ fɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Maŋ gbagba bɛɛ yɛɛ kolo me baam dɔɔ ya. Mena keŋ me kya Wurubuarɛ de yako maŋ nɛ, mena te mee di balaŋ nombia, te me nombia kedi mɔ doo na ke gbɛɛ. Nawolo nyi na maŋ gbagba kegyaebii te mɛɛ yɛɛ ya, mɔna me kya ŋon ɔ be kpila maŋ nɛ kegyaebii te mɛɛ yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nyi akpaa maŋ gbagba de di ma wose man adansɛɛ na, ɛ be gyae ɛ ke lɛɛ maŋ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mɔna ŋolo kyaa keŋ ɔ ne di ma wose man adansɛɛ, te ma gyeŋ nyi wa adansɛɛ keŋ ɔ ne dii lee ma wose man nɛ yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɛ kpila balaŋ gyu Gyɔn gyaŋ, te ɔ dii anokoare keŋ wose man adansɛɛ fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Na mɛɛ gyae bo nyi denibalaŋ baa di ma wose man adansɛɛ ya, mɔna ɛ nyeedoŋ kenyiŋ dɔɔ te mɛɛ yako kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Gyɔn yɛɛ ŋgba kanea keŋ kɛɛ naa te kɛɛ ŋalakee nɛ, te ɛ gyaewɔ nyi ɛ ke di kanea kenaŋ gyoŋ kyomii. ");
INSERT INTO ntr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Me dana ŋolo ŋon ɔ ne di ma wose man adansɛɛ, te wa adansɛɛ kenaŋ kela Gyɔn wui keŋ ɔ be dii lee ma wose man nɛ. Nawolo nyi tom keŋ me kya Wurubuarɛ ba mo do maŋ me nyiŋmaa man nyi maa yɛɛ ke kelii ɔto te mɛɛ yɛɛ ke nɛ, ne diina adansɛɛ lee ma wose man nyi me kya ŋonaŋ kpila na maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Me kya ŋon ɔ be kpila maŋ nɛ, ŋon gbagba mɔ ne di ma wose man adansɛɛ. Ɛ te nyii ta ɔ nɔɔwoya ya, te ɛ te naa ta ɔ dinɔɔ mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɔ nombia be doo ɛ konɔɔse man ya, nawolo nyi ɛ bɛɛ lɛɛ walaŋ ŋon ɔ be kpili nɛ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɛ ne yase ɛ sia kasee Wurubuarɛ nombia ŋan nawolo nyi na ya agyueŋ yɛna nyi ŋe man te ɛ ke nyiŋ nyeedoŋ kekpaa keŋ. Te mena Wurubuarɛ nombia aŋmaraseŋ see kɛŋa ne di ma wose man adansɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mɔna ɛ bɛɛ gyae ɛ ke kɔŋ me gyaŋ na ɛ kaa nyiŋ nyeedoŋ kekpaa keŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na ma kegyaebii yɛna nyi balaŋ baa kɛlɛɛ maŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mɔna ma gyeŋ ɛ dinɔɔ te ma gyeŋ nyi ɛ bɛɛ gyae Wurubuarɛ lee ɛ konɔɔse man ya. ");
INSERT INTO ntr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Me kɔŋae me kya ŋon yele man mɔna ɛ te lɛɛ maŋ ya. Mɔna akpaa ŋolo de kɔŋ ŋon gbagba yele man na ɛ ke lɛɛ e. ");
INSERT INTO ntr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɛ ne gyae nyi ɛ ke kɛlɛɛ dɔŋa, mɔna ɛ bɛɛ gyae nyi Wurubuarɛ dokoloŋ ŋon ke kɛlɛɛ ŋon ya. Kenaŋ na sena te ɛ ke tale lɛɛ maŋ di? ");
INSERT INTO ntr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ɛ na gyueŋ nyi maŋ ne gyaela me kaa yako ɛ nombiakumɛɛ fa me kya Wurubuarɛ ya. Mosesi ŋon ɛ ba mo ɛ loo gyakaa ɔ dɔɔ nɛ, ŋon ne gyaela waa mo ɛ nombiakumɛɛ gyu me kya siaman. ");
INSERT INTO ntr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nyi yeŋ lɛɛ Mosesi di na nafɔ ɛ kelɛɛ maŋ mɔ di, nawolo nyi ma wose man nombia te Mosesi ŋmarasewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mɔna nyi akpaa ɛ bɛɛ lɛɛ kpene keŋ ɔ be ŋmarase nɛ di ya na, sena te ɛ kelɛɛ kpene keŋ mɛɛ yako nɛ di?” ");
INSERT INTO ntr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Weeya akalansɛɛ ŋaale wɔle nɛ, Yesu toŋa Galelia depaa keŋ bɛɛ baake ke bela nyi Tiberiase nɛ gyu ke diŋgyiŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Balaŋ burum sila ɔ gbɛɛ gyu botɔɔ, nawolo nyi be naa gyakoloŋ nombia na nombia dinaana ŋan ɔ be yɛɛ lee mena keŋ ɔ be kyɔ balaŋ kaweese nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Keŋte Yesu na ɔ kaseela baŋ gyeŋa bula daale kekyaa botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Debaŋ kenaŋ na Gyudatena nyeekelɛɛwee kedi keŋ ta benaa. ");
INSERT INTO ntr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu gɛɛsewɔ kɛɛ te ɔ naawɔ nyi balaŋ burum ne kɔŋ ɔ gyaŋ keŋte ɔ bɔɔse Filipo nyiaa, “Aleŋ te dee nyiŋ weenɛɛ lɛɛ fa balaŋ burum kɛwɔ dinɔɔ kedi?” ");
INSERT INTO ntr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu bɔɔse Filipo mena nombia kɛŋa na waa mo kɛɛ wa agyueŋ nawolo nyi ŋon gbagba wulaa ɔ gyeŋ kpene keŋ waa yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Botɔɔ te Filipo tiranɔɔ fa e nyiaa, “Pɛ walaŋ kamasɛ kenyiŋ kyomii di koraŋ na, kaboena nyi dɛɛ mo tomyɛɛre kegyia ŋolo gyaalaŋna gyanaara kɔba bo lɛɛ weenɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Keŋte ɔ kaseela baŋ ŋolo ŋon bɛɛ baake e nyi Anderiase, ŋon ɔ kegyia yɛna Simɔn Pita nɛ yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bu ŋolo kyaa kɛbo keŋ ɔ dana bodobodose anoŋ na kpebia bala. Mɔna woŋ te kɛŋa gyae keyɛɛ balaŋ burum kɛwɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Botɔɔ te Yesu yako ɔ kaseela baŋ nyiaa, “Ɛ yela balaŋ baŋ pou ke tisi kyakee.” Na ŋalese murumuru ŋaale kyaa botɔɔ, mena dɔɔ balaŋ baŋ pou tisiwɔ kyakee botɔɔ. Baala baŋ be kyaa botɔɔ nɛ baa yɛɛ ŋgba balaŋ kakpoŋse banoŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Keŋte Yesu moo bodobodose ŋan te ɔ fanewɔ fa Wurubuarɛ karaŋ, te ɔ moo ŋa kpɛlɛɛ fa balaŋ baŋ be kyaa botɔɔ nɛ. Mena ke te ɔ moo kpebia ŋan mɔ te ɔ fanewɔ fa Wurubuarɛ karaŋ te ɔ kpɛlɛɛ ŋa fa balaŋ baŋ pou. Balaŋ baŋ diiwɔ baa ba kegyaebii. ");
INSERT INTO ntr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Balaŋ baŋ pou kedi baa nɛ Yesu yako ɔ kaseela baŋ nyiaa, “Ɛ tɔɔsee weenɛɛ akaŋ ŋan pou, ɛ na yeli ŋa kewɔlɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Weenɛɛ ŋan balaŋ baŋ be dii kaase nɛ, be tɔɔsee ŋa buruburu akaŋ ŋan na be nyiŋa doŋase kufu ala. ");
INSERT INTO ntr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Balaŋ baŋ kena gyakoloŋ nombia ŋan Yesu be yɛɛ nɛ be yakowɔ nyiaa, “Kei yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon ɔ be yako see nyi waa kɔŋ tɛɛle kei dɔɔ nɛ ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na Yesu taŋ kena nyi balaŋ baŋ ne gyae be kaa kyaŋ e, na baa ŋere e mo e see be gyoo mena dɔɔ ŋon waageŋ wɔŋa ɔ wose lee be man gyu ke kyaa bula keŋ dɔɔ bela. ");
INSERT INTO ntr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kelii balinɔɔ nɛ Yesu kaseela baŋ besewɔ gyu depaa keŋ nɔɔman, ");
INSERT INTO ntr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","keŋte ba gyoowɔ degbele daale man te ba moo ba nyee baŋ bee gyu Kapanum donɔɔ man. Debaŋ kenaŋ na tɛɛ te biri mɔna Yesu sɛɛ ɔ te kɔŋa ta be gyaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Te feliŋ dinaa daale korowɔ ne gyɔɔ loŋ keŋ dɔɔ keŋ te yɛɛ nsendee ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɔ kaseela baŋ kesaa degbele keŋ gyu siaman keŋ gyae keyɛɛ ŋgba gbɛɛkemaa atooro na yale nɛ, be naa Yesu dɔŋɛɛ loŋ keŋ dɔɔ ɔ ne kɔŋ ba degbele keŋ gyaŋ, keŋte gyakoloŋ gyoo wɔ. ");
INSERT INTO ntr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Keŋte Yesu yako wɔ nyiaa, “Ɛ na yee ya, maŋ ŋonaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Botɔɔ te be lɛɛ Yesu gyoŋ man do ba degbele keŋ man, debokenaŋ man te be kelii botɔɔ keŋ bee gyu nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tɛɛ kena nɛ, balaŋ burum baŋ bɔɔ kaa depaa keŋ diŋgyiŋ nɛ naawɔ nyi degbele dokoloŋ doo la botɔɔ. Te ba gyeŋ mɔ nyi Yesu ta gyoo degbele kenaŋ man kpu na ɔ kaseela baŋ ya. Ɔ kaseela baŋ baageŋ gyoola ke man laŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Agbelese ŋaale mɔ lee Tiberiase donɔɔ man kɔŋ diŋgyiŋ botɔɔ, benaa na botɔɔ keŋ Yesu ba mo bodobodo fane fa Wurubuarɛ karaŋ te ɔ ba mo fa balaŋ burum baŋ be dii nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Balaŋ burum baŋ kena nyi Yesu na ɔ kaseela baŋ be kyaa botɔɔ ya nɛ, ba gyoowɔ agbelese ŋenaŋ man gyu Kapanum donɔɔ man bɛɛ kɛo e. ");
INSERT INTO ntr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Balaŋ baŋ ke gyu kena Yesu boo keŋ diŋgyiŋ nɛ be bɔɔse e nyiaa, “De Gbeŋgyoo, debaŋ woŋti yaa n taŋ kaa lii kɛbo?” ");
INSERT INTO ntr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, na gyakoloŋ nombia ŋan ɛ be naa mɔɔ yɛɛ nɛ dɔɔ te ɛ silana me gbɛɛ ya, mɔna weenɛɛ ŋan ɛ be nyim di baa ɛ kegyaebii nɛ dɔɔ te ɛ silana me gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ɛ na naase ɛ wose diyem gyae weenɛɛ ŋan gyae kewɔlɛɛ nɛ ya, mɔna ɛ yɛɛ kakyeŋ gyae weenɛɛ ŋan gyae kefa ŋon nyeedoŋ kekpaa keŋ nɛ. Weenɛɛ kɛŋa te maŋ Deniwalaŋ Bu ŋon maa fa ŋon, nawolo nyi me kya Wurubuarɛ ta mo ɔ doŋ do me man keŋ nawolo nyi ɔ te lɛɛ maŋ do.” ");
INSERT INTO ntr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Keŋte be bɔɔse Yesu nyiaa, “Woŋ te kaboena nyi dɛɛ yɛɛ, na dɛɛ tale yɛɛ kpene keŋ Wurubuarɛ ne gyae nyi dɛɛ yɛɛ nɛ?” ");
INSERT INTO ntr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Tom keŋ Wurubuarɛ ne gyae nyi yaa yɛɛ yɛna nyiaa, ɛ lɛɛ walaŋ ŋon ɔ be kpila e nɛ di.” ");
INSERT INTO ntr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Keŋte be bɔɔse Yesu nyiaa, “Woŋ gyakoloŋ nombia te nyaŋ ke yɛɛ wola daa na dɛɛ lɛɛ neŋ di nyi Wurubuarɛ kpila na neŋ? Woŋ te nyaŋ ke yɛɛ? ");
INSERT INTO ntr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","De naanaɔ dii weenɛɛ ŋan bɛɛ baake ŋa nyi maana nɛ depampaa keŋ man, ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako daa nɛ nyiaa, ‘Ɔ faa wɔ weenɛɛ lee adido te be diiwɔ.’ ” ");
INSERT INTO ntr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Keŋte Yesu yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyiaa, na Mosesi faa na ŋon weenɛɛ lee adido ya, mɔna me kya yɛna walaŋ ŋon ɔ ne fa weenɛɛ gbagba ŋan ba lee adido nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nawolo nyi weenɛɛ ŋan me kya Wurubuarɛ ne faa nɛ yɛna ŋon ɔ ba lee adido kɔŋ tɛɛle kei dɔɔ, te ɔ ne fa balaŋ nyeedoŋ kekpaa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Keŋte be yako e nyiaa, “De Gbeŋgyoo, akpaa mena na lee gyɛŋ ne gyu na fa daa weenɛɛ kɛŋa wee kamasɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Te Yesu yako wɔ nyiaa, “Maŋ yɛna nyeedoŋ weenɛɛ ŋan. Walaŋ kamasɛ ŋon ɔ kɔŋ me gyaŋ nɛ, tanam be gyae ka ko e ya. Te walaŋ kamasɛ ŋon ɔ lɛɛ maŋ di na, loŋboaneŋ be gyae ka ko e ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ŋgba mena keŋ mɔ taŋ yako ŋon kaalaŋ nɛ, ɛ te naa maŋ mɔna ɛ bɛɛ lɛɛ maŋ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Walaŋ kamasɛ ŋon me kya ba mo e fa maŋ nɛ, waa kɔŋ me gyaŋ. Te walaŋ kamasɛ ŋon ɔ kɔŋ me gyaŋ nɛ, mɔɔ gyae maa gegi e ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nawolo nyi me ta lee adido kɔŋ tɛɛle kei dɔɔ nyi me kaa yɛɛ maŋ gbagba kegyaebii ya, mɔna me kɔŋae me kaa yɛɛ ŋon ɔ be kpila maŋ nɛ kegyaebii. ");
INSERT INTO ntr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ŋon ɔ be kpila maŋ nɛ kegyaebii yɛna nyiaa, balaŋ baŋ pou ɔ ba mo do maŋ me nyiŋmaa man nɛ, me na yela be man dokoloŋ ka yo ya. Mɔna wee ɔtomante keŋ man nɛ, maa gyuusu wɔ pou lee yeŋ man kɔŋ nyeedoŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nawolo nyi me kya ŋon kegyaebii yɛna nyi walaŋ kamasɛ ŋon ɔ mo ɔ loo gyakaa me dɔɔ te ɔ lɛɛ maŋ di na, waa nyiŋ nyeedoŋ kekpaa keŋ. Te wee ɔtomante keŋ man nɛ, maa gyuusu mena walaŋ ŋonaŋ lee yeŋ man kɔŋ nyeedoŋ man.” ");
INSERT INTO ntr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Botɔɔ te Gyudatena baŋ fiasɛɛ bɛɛ ŋorokoso lee Yesu wose man nawolo nyi ɔ kpa, ŋon yɛna weenɛɛ ŋan ba lee adido kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Keŋte be yakowɔ nyiaa, “Na kei yɛna Gyosɛfo bu ŋon bɛɛ baake e nyi Yesu nɛ yee? Da gyeŋ ɔ kya na ɔ naa. Woŋ dɔɔ te nɛnɛɛ ɔ ne yako daa nyi ɔ lee adido bo kɔŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Botɔɔ te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ na ŋorokoso na dɔŋa ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nyi akpaa me kya ŋon ɔ be kpila maŋ nɛ te wɔŋ ŋolo benaa na maŋ ya nɛ, mena walaŋ ŋonaŋ be gyae waa tale kɔŋ me gyaŋ ya. Te wee ɔtomante keŋ nɛ, maa gyuusu mena walaŋ ŋonaŋ lee yeŋ man na waa nyiŋ nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ man ŋolo ŋmarasewɔ see nyiaa, ‘Wurubuarɛ ne gyaela waa wola walaŋ kamasɛ nombia.’ Mena dɔɔ walaŋ kamasɛ ŋon ɔ tei me kya Wurubuarɛ nombia te ɔ kasee ŋa nɛ, waa kɔŋ me gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kei bɛɛ wolo nyi ŋolo te naa me kya ŋon ya. Walaŋ ŋon ɔ ba lee Wurubuarɛ gyaŋ kɔŋ nɛ, ŋon waageŋ naa na e. ");
INSERT INTO ntr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ampaŋ yaa mɛɛ yako ŋon nyiaa, walaŋ ŋon ɔ lɛɛ maŋ di na waa nyiŋ nyeedoŋ kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maŋ yɛna nyeedoŋ weenɛɛ ŋan. ");
INSERT INTO ntr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ɛ naanaɔ dii weenɛɛ ŋan bɛɛ baake ŋa nyi maana nɛ depampaa keŋ man, mɔna ba yekeewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mɔna nyeedoŋ weenɛɛ ŋan ba lee Wurubuarɛ man kɔŋ te mɛɛ yako ŋon ŋa wose man nombia nɛ dɔɔ, walaŋ kamasɛ ŋon ɔ di ke na ɔ be gyae waa yeŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Maŋ yɛna nyeedoŋ weenɛɛ ŋan ba lee adido kɔŋ tɛɛle kei dɔɔ nɛ. Walaŋ kamasɛ ŋon ɔ di mena weenɛɛ kɛŋa na, waa nyiŋ nyeedoŋ kekpaakekpaa. Weenɛɛ ŋan maa mo fa balaŋ na baa nyiŋ nyeedoŋ nɛ yɛna ma wosenaane.” ");
INSERT INTO ntr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Botɔɔ te Gyudatena baŋ gyoo aŋmaareŋ na dɔŋa nyiaa, “Sena te balee kei waa tale mo ɔ wosenaane fa daa na dee di?” ");
INSERT INTO ntr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Keŋte Yesu yako wɔ nyiaa, “Ampaŋ yaa mɛɛ yako ŋon nyiaa, nyi akpaa ɛ te di maŋ Deniwalaŋ Bu wosenaane na ɛ kenyɔɔ me fatabo ya nɛ, ɛ be gyae ɛ ke nyiŋ nyeedoŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Walaŋ kamasɛ ŋon waa di ma wosenaane na waa nyɔɔ me fatabo nɛ, waa nyiŋ nyeedoŋ kekpaa keŋ. Wee ɔtomante keŋ man nɛ, maa gyuusu mena walaŋ ŋonaŋ lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nawolo nyi ma wosenaane yɛna weenɛɛ anediŋ gbagba, te me fatabo mɔ yɛna kolo anenyɔɔŋ gbagba. ");
INSERT INTO ntr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Walaŋ kamasɛ ŋon ɔ di ma wosenaane te ɔ nyɔɔ me fatabo na, daa na e ta bese walaŋ dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Me kya ŋon ɔ ne fa balaŋ nyeedoŋ nɛ kpila na maŋ, te wa adaworoma dɔɔ te me dana nyeedoŋ. Mena ke mɔ te walaŋ kamasɛ ŋon ɔ di ma wosenaane na, maa fa e nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Maŋ yɛna weenɛɛ ŋan ba lee adido kɔŋ tɛɛle kei dɔɔ nɛ. Ma te yɛɛ ŋgba weenɛɛ ŋan ɛ naanaɔ be dii te bɔɔ yekee nɛ ya. Walaŋ kamasɛ ŋon wa di mena weenɛɛ kɛŋa nɛ, waa nyiŋ nyeedoŋ kekpaakekpaa.” ");
INSERT INTO ntr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Debaŋ keŋ Yesu na wolo Gyudatena ɔsom deni man Kapanum donɔɔ man nɛ, te ɔ yako mena nombia kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu kaseela baŋ kenyii nombia kɛŋa nɛ be yakowɔ nyiaa, “Mena kawola kɛŋa man dana doŋ. Amɔte ne gyaela waa tale lɛɛ ŋa do?” ");
INSERT INTO ntr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu ka gyeŋ nyi ɔ kaseela baŋ na ŋorokoso lee nombia kɛŋa wose man nɛ ɔ bɔɔse wɔ nyiaa, “Nombia kɛŋa ne takaa ŋon? ");
INSERT INTO ntr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kenaŋ na akpaa ɛ naa maŋ Deniwalaŋ Bu ŋon na gyem mee gyu adido, botɔɔ keŋ mɔɔ lee na sena te ɛ ke yɛɛ? ");
INSERT INTO ntr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wurubuarɛ feliŋ ne faa na balaŋ nyeedoŋ. Kpene keŋ denibalaŋ na mo baŋ gbagba be doŋ yɛɛ nɛ be taŋ tɔnɔɔ ya. Nombia ŋan mɔɔ yako ŋon nɛ lee Wurubuarɛ feliŋ ŋon man te ŋɛɛ fa nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mɔna ɛ man baale bɛɛ lɛɛ di ya.” Yesu yako nombia kɛŋa nawolo nyi lee kewalaŋ keŋ na, ɔ wulaa ɔ gyeŋ baŋ bɔɔ gyae baa lɛɛ e di ya, na ŋon waa kaa lese e fa. ");
INSERT INTO ntr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Keŋte Yesu besewɔ yako wɔ nyiaa, “Kei dɔɔ te me yako ŋon nyiaa, akpaa me kya te fa ŋolo gbɛɛ nyi waa kɔŋ me gyaŋ ya na, ɔ be gyae waa tale kɔŋ ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kei wɔle nɛ, ɔ silala baŋ man balaŋ burum wɔŋa ba wose lee wɔle keŋ be te sila e bela ya. ");
INSERT INTO ntr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Keŋte Yesu bɔɔse ɔ kaseela kufu bala baŋ mɔ nyiaa, “Ɛmɛɛ mɔ ne gyae ɛ ka bese ɛ wɔle yaa?” ");
INSERT INTO ntr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Botɔɔ te Simɔn Pita tiranɔɔ nyiaa, “De Gbeŋgyoo, amɔte gyaŋ te dee gyu? Nyaŋ nyaageŋ danaana nombia ŋan ŋɛɛ fa nyeedoŋ kekpaa keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nɛnɛɛ da te lɛɛ neŋ di, te de ta gyem nyi nyaŋ yɛna walaŋ ŋon Wurubuarɛ be kpili te ayimɛɛ be doo ɔ man ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Keŋte Yesu bɔɔse wɔ nyiaa, “Na ɛmɛɛ balaŋ kufu bala te me baakewɔ yee? Mɔna ɛ man ŋolo yɛɛ walaŋkum e.” ");
INSERT INTO ntr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na Simɔn Isekarɔte bu Gyudase wose man nombia yaa Yesu ne yako nɛ. Nawolo nyi Gyudase yɛɛ ɔ kaseela kufu bala baŋ man ŋolo e, mɔna ŋon ne gyae la ɔ kaa lese Yesu fa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nombia kɛŋa wɔle nɛ Yesu tɛɛwɔ kila Galelia donɔɔse man. Ɔ te gyae nyi waa gyu Gyudia tɛɛle man ya, nawolo nyi Gyudatena kegyiise baŋ be kyaa botɔɔ nɛ ne gyae gbɛɛ baa ko e. ");
INSERT INTO ntr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Debaŋ kenaŋ na Gyudatena kefɛɛse man kekyaa wee dinaa kedi ta benaa. ");
INSERT INTO ntr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mena dɔɔ Yesu ɔ naabia yako e nyiaa, “Kaboena nyi nya lee kɛbo na n ke gyu Gyuda tɛɛle man na n kaseela baŋ ke nyiŋ naa gyakoloŋ nombia ŋan n ne yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nawolo nyi walaŋ ne gyae ɔ yele ka lee na, ɔ bɛɛ yɛɛ kolo weese ya. Mena dɔɔ n keta n ne yɛɛ gyakoloŋ nombia kɛŋa nɛ, kaboena nyi nya lese n wose debɔɔ fa balaŋ pou.” ");
INSERT INTO ntr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ɔ naabia baŋ kolosi nombia kɛŋa nawolo nyi baŋ gbagba koraŋ te lɛɛ e di ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Keŋte Yesu yako wɔ nyiaa, “Debaŋ keŋ Wurubuarɛ ba see fa maŋ nɛ te lii ta ya, mɔna ɛmɛɛ dɔɔ debaŋ kamasɛ dei fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tɛɛle kei dɔɔ balaŋ bɛɛ kɔla ŋon ya mɔna maŋ dɔɔ bɛɛ kɔla maŋ, nawolo nyi me gyakaa mɛɛ yako wɔ nyi be nombia ŋan bɛɛ yɛɛ nɛ be dei ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɛmɛɛ ɛ ta gyu kedi wee dinaa keŋ, maŋ be gyae maa gyu ya nawolo nyi ma debaŋ keŋ te lii ta ya.” ");
INSERT INTO ntr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ɔ ke yako nombia kɛŋa fa wɔ taŋ nɛ, te ŋon dɔɔwɔ Galelia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu ɔ naabia ke laŋ ba wee dinaa keŋ dedii man nɛ, te ŋon mɔ korowɔ gyu botɔɔ. Mɔna ɔ weese ɔ wose bo. ");
INSERT INTO ntr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na Gyudatena kegyiise baŋ dɔŋɛɛ bɛɛ kɛo e na bɛɛ bɔɔse nyiaa “Ɔ kyaa aleŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Keŋte balaŋ baŋ man balaŋ burum gyoo kekolosi na dɔŋa lee Yesu wose man. “Baale kpa ɔ yɛɛ walaŋ kpaakpaa e, te baale mɔ kpa koa, ɔ na beo balaŋ bo na baa yo lee Wurubuarɛ gbɛɛneŋ ŋan man.” ");
INSERT INTO ntr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mɔna ŋolo te tale kolosi ɔ wose man nombia balaŋ man ya, nawolo nyi be yee Gyudatena kegyiise baŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Be kedi ba wee dinaa keŋ kelii nsana nsana nɛ, Yesu gyuu Wurubuarɛ ɔsom deni dinaa keŋ man ɔ na wola balaŋ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ɔ kawola keŋ doo Gyudatena kegyiise baŋ nɔɔ te be bɔɔsewɔ nyiaa, “Sena te balee kei yɛɛwɔ gyeŋ nombia kɛŋa keŋ nyi ɔ te kasee lee ŋolo gyaŋ ya?” ");
INSERT INTO ntr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Kpene keŋ mɛɛ wolo nɛ ta lee maŋ gbagba gyaŋ ya, mɔna ka lee me kya Wurubuarɛ ŋon ɔ be kpila maŋ nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Walaŋ kamasɛ ŋon ɔ ne gyae nyi waa di Wurubuarɛ nombia ŋan dɔɔ nɛ, ɔtenate waa gyeŋ nyi kpene keŋ mɛɛ wolo nɛ, lee Wurubuarɛ gyaŋ yaa lee maŋ gbagba gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Walaŋ kamasɛ ŋon ɔ ne kolosi ŋon gbagba ɔ baam dɔɔ nɛ, na ɔ ne gyae yele bo wa fa ɔ wose. Te walaŋ kamasɛ ŋon ɔ ne gyae bo nyi waa lese ŋon ɔ be kpila e nɛ yele na, ɔ nombia doo na ke gbɛɛ keŋ nyi dekara be doo ke man ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na Mosesi faa na ŋon mmaraase ŋan yee? Mɔna ɛ man ŋolo bee di ŋe dɔɔ ya. Woŋ dɔɔ te ɛ ne gyae ɛ ka ko maŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Botɔɔ te balaŋ dikpii keŋ tiranɔɔ fa e nyiaa, “Feliŋkumɛɛ doo n man. Amɔte ne gyae la waa ko neŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Keŋte Yesu yako wɔ nyiaa, “Gyakoloŋ nombii dokoloŋ te me yɛɛwɔ ɛ kefɛɛfowee, keŋ na doo na ŋon gyakoloŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesi yako ŋon nyi ya kara ɛ bia baalawose. (Kei ta lee Mosesi gyaŋ ya, mɔna ka lee ɛ naanaɔ gyaŋ), mena dɔɔ ɛ ne kara ɛ bia baalawose ɛ kefɛɛfowee. ");
INSERT INTO ntr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nyi akpaa ɛ ne kara ɛ bia baalawose ɛ kefɛɛfo te keŋ bɛɛ wɔlɛɛ ya mmaraa ya na, weera dɔɔ te ɛ na gyeŋ baŋ do maŋ nyi ma te kyɔ walaŋ dibiliŋ kawee kefɛɛfowee? ");
INSERT INTO ntr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ɛ na barase bu balaŋ fɔɔ ya, ɛ di nombia na ŋe gbɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Keŋte Gyerusalɛmtena baale bɔɔsewɔ nyiaa, “Na balee kei te bɛɛ kɛo nyi baa ko nɛ yee? ");
INSERT INTO ntr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ɛ kɛɛ ɔ ka seŋ balaŋ man ɔ ne kolosi keŋ ŋolo bɛɛ bɔɔse e daale ya. Yaa nɛnɛɛ dɔɔ kegyiise baŋ te lɛɛ e do nyi ŋon yɛna nyeelɛɛre ŋon? ");
INSERT INTO ntr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Balee kei dɔɔ de popou gyeŋ botɔɔ keŋ ɔ ba lee. Mɔna akpaa nyi nyeelɛɛre ŋon waa kɔŋ na, ŋolo be gyae waa gyeŋ botɔɔ keŋ waa lee ya.” ");
INSERT INTO ntr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu kɛɛ wola abɔɔ Wurubuarɛ ɔsom deni dinaa keŋ man nɛ, ɔ gyinaa ɔ woya bɔɔse wɔ nyiaa, “Mena dɔɔ ɛ gyeŋ maŋ nideli na botɔɔ keŋ mɔɔ lee? Na maŋ gbagba me baam dɔɔ te me kɔŋawɔ ya. Walaŋ ŋon ɔ be kpila maŋ nɛ ɔ yɛɛ anokoarete e, mɔna ŋon dɔɔ ɛ ba gyeŋ e ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mɔna maŋ dɔɔ ma gyeŋ e nawolo ɔ gyaŋ te ma leewɔ te ŋon kpila na maŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mena dɔɔ be yela baa kyaŋ Yesu, mɔna ŋolo te tale mo ɔ nyiŋmaa tina e ya, nawolo nyi debaŋ keŋ Wurubuarɛ ba see nyi waa yeŋ nɛ te lii ta ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mɔna balaŋ burum lɛɛ e di te be bɔɔsewɔ nyiaa, “Akpaa nyeelɛɛre ŋon de kɔŋ na, waa yɛɛ gyakoloŋ nombia kela balee kei aneyɛɛŋ kɛŋa?” ");
INSERT INTO ntr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasiitena ke nyii mena keŋ balaŋ ne kolosi nombia kɛŋa adadawoya man lee Yesu wose man nɛ, baŋ na Wurubuarɛ saese kegyiise kpila kotɔtɔɔtena baŋ bɛɛ deke Wurubuarɛ ɔsom deni dinaa keŋ nɛ nyi baa gyu kekyaŋ e kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Keŋte Yesu yakowɔ nyiaa, “Maa kyaa ɛ gyaŋ bo weeya akalansɛɛ ŋaale na maa bese gyu walaŋ ŋon ɔ be kpila maŋ nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ɛ ke kɛo maŋ mɔna ɛ be gyae ɛ kena maŋ ya, te botɔɔ keŋ me kyaa mɔ nɛ, ɛ be gyae ɛ ke tale kɔŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Botɔɔ te Gyudatena kegyiise baŋ bɔɔse dɔŋa nyiaa, “Aleŋ yaa balee kei ne gyae waa yeu gyu te dɔɔ gyae dɛɛ naa e ya? Yaa ɔ ne gyae waa yeu ba gyu Girikitena gyaŋ botɔɔ keŋ de balaŋ be yaasee gyu nɛ ɔ kaa wola wɔ abɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ɔ ke yako nyi, “Ɛ ke kɛo maŋ mɔna ɛ be gyae ɛ kena maŋ ya, Te botɔɔ keŋ me gyu nɛ ɛ be gyae ɛ ke tale gyu ya nɛ, na sena yaa ɔ ne yako baa? Na woŋ nombia yɛna kɛŋa baa?” ");
INSERT INTO ntr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gyudatena kefɛɛse man kekyaa weekedi ɔtomante keŋ nɛ, Yesu korowɔ seŋ te ɔ gyinaa ɔ nɔɔ kolosi te ɔ yako wɔ nyiaa, “Akpaa nyaŋ ŋon loŋboaneŋ dana neŋ na kɔŋ me gyaŋ na n kaa nyɔɔ loŋ. ");
INSERT INTO ntr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","‘Walaŋ kamasɛ ŋon ɔ lɛɛ maŋ di na, nyeedoŋ nombia gyae ka lee ɔ man kɔŋ ŋgba mena keŋ loŋ na lee ditiribuŋ man kɔŋ nɛ. Nnɛ te Wurubuarɛ nombia aŋmaraseŋ see yakowɔ.’ ” ");
INSERT INTO ntr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu kekolosi kei nɛ, na Wurubuarɛ feliŋ ŋon waa kaa mo do baŋ baa lɛɛ e di nɛ man nombia yaa ɔ ne kolosi nɛ. Debaŋ kenaŋ na ɔ ta moo ta Wurubuarɛ feliŋ ŋon do ŋolo man ya, nawolo nyi Yesu gyoorobiiri keŋ ta lee ta debɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Balaŋ baŋ ke nyii Yesu nɔɔwoya kɛŋa nɛ be man baale yakowɔ nyiaa, “Ampaŋ, balee kei yɛna Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Baale mɔ yakowɔ nyiaa, “Balee kei yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kaa kɔŋ nɛ ampaŋ. Mɔna baale mɔ yakowɔ nyiaa, na Galelia tɛɛle man te nyeelɛɛre ŋon waa lee ya.” ");
INSERT INTO ntr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nyiaa, “Nyeelɛɛre ŋon waa lee bo Bɛtelɛhɛm donɔɔ man botɔɔ keŋ Gyoo Defidi be kyaa nɛ, te waa lee bo gyoo Defidi loŋtoro man.” ");
INSERT INTO ntr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lee Yesu dɔɔ, balaŋ baŋ man kpasewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Balaŋ baŋ baale gyaewɔ nyi baa kyaŋ Yesu, mɔna ŋolo te tale mo ɔ nyiŋmaa tina e ya. ");
INSERT INTO ntr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wɔle wɔle keŋ nɛ, kotɔtɔɔtena baŋ bɛɛ deke Wurubuarɛ ɔsom deni dinaa keŋ te bɔɔ kpila wɔ nɛ besewɔ kɔŋ Wurubuarɛ saese kegyiise na Farasiitena baŋ gyaŋ. Keŋte kegyiise baŋ bɔɔse wɔ nyiaa, “Weera dɔɔ te ɛ te kyaŋ e kɔŋ ya?” ");
INSERT INTO ntr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Keŋte be tiranɔɔ fa kegyiise baŋ nyiaa, “Ŋolo na ŋolo te kolosi ta see ŋgba balee kei nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Te Farasiitena baŋ bɔɔse wɔ nyiaa, “Doona ɔ taŋ beo ɛmɛɛ mɔ? ");
INSERT INTO ntr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ɛ te nyii nyi donɔɔ kegyiise kɛwɔ man ŋolo yaa Farasiitena kɛwɔ man ŋolo te lɛɛ Yesu di? ");
INSERT INTO ntr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mɔna mena balaŋ burum kɛwɔ baŋ bɔɔ gyeŋ Mosesi mmaraa keŋ ya nɛ, baŋ doola kefaala tɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemose ŋon ɔ be kyaa gyu Yesu gyaŋ nɛ yɛɛ kegyiise baŋ man ŋolo e. Te ɔ bɔɔse wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Da mmaraa ne fa daa gbɛɛ nyi dɛɛ bu ŋolo fɔɔ keŋ de te nyii ta ɔ nɔɔman nombia yee?” ");
INSERT INTO ntr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Keŋte be tiranɔɔ fa e nyiaa, “Weera nyaŋ mɔ ne kolosi ŋgba n yɛɛ Galelia baale e nɛ? Nyaŋ kɛɛ Wurubuarɛ nombia aŋmaraseŋ see ŋan man nideli, n kena nyi Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo ta lee ta Galelia ya.” ");
INSERT INTO ntr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Keŋte be popou yaaseewɔ dokoloŋ dokoloŋ gyu be dɛɛse. ");
INSERT INTO ntr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Balaŋ baŋ ke yaasee nɛ, Yesu gyuuwɔ oliifi bula keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tɛɛ kena nɛ ɔ besewɔ kɔŋ Wurubuarɛ ɔsom deni dinaa keŋ man. Balaŋ baŋ pou be kyaa botɔɔ nɛ kaa wuuwɔ ɔ dɔɔ te ɔ tisiwɔ kyaa ɔ na wola wɔ Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Botɔɔ te Gyudatena mmaraa wolala na Farasiitena baŋ moo alo ŋolo ŋon ɔ ba lee ɔ baale wɔle te bɔɔ kyaŋ e nyiŋmaa nyiŋmaa nɛ kɔŋ kaa seŋ Yesu na balaŋ baŋ pou siaman. ");
INSERT INTO ntr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Keŋte be yako Yesu nyiaa, “De Gbeŋgyoo, da te kyaŋ alo kei ɔ ne gyae baala. ");
INSERT INTO ntr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesi mmaraa ŋan na wola daa nyi dee fuŋii mena alo kei dinɔɔ boya ko. Te nyaŋ mɔ n kpoo?” ");
INSERT INTO ntr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Be yako nombia kɛŋa nyi baa mo teese Yesu nɔɔman, na baa nyiŋ mo nombia gyakaa ɔ dɔɔ. Mɔna Yesu gɔŋasewɔ te ɔ moo ɔ nyimbii ŋmarase kolo tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Be kaseŋ bɛɛ daa e nyi waa tiranɔɔ fa wɔ nɛ, ɔ korowɔ seŋ te ɔ yako wɔ nyiaa, “Nyaŋ ŋon n gyeŋ nyi n te yɛɛ ta dukum see ya nɛ taŋgbɛɛ mo boe fuŋ e” ");
INSERT INTO ntr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Te ɔ besewɔ gɔŋase ŋmarase kolo tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Be ke nyii nombia kɛŋa nɛ, be yaaseewɔ dokoloŋ dokoloŋ tina e yela. Be man kegyiise baŋ taŋgbɛɛ la lee botɔɔ, te kaa Yesu na alo ŋon na balaŋ dikpii keŋ baageŋ. ");
INSERT INTO ntr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Keŋte Yesu korowɔ seŋ te ɔ bɔɔse alo ŋon nyiaa, “Alo nde wɔ? Ŋolo te tale bu neŋ fɔɔ yee?” ");
INSERT INTO ntr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Te alo ŋon tiranɔɔ fa e nyiaa, “Me Gbeŋgyoo, ŋolo te bu maŋ fɔɔ ya.” Te Yesu yako e nyiaa, “Maŋ mɔ be gyae maa bu neŋ fɔɔ ya. Ta, na tekaa yɛɛ dukum bela ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nombia kɛŋa wɔle nɛ Yesu besewɔ kolosi fa balaŋ baŋ nyiaa, “Maŋ yɛna keŋmaŋee fa balaŋ tɛɛle kei dɔɔ. Walaŋ kamasɛ ŋon ɔ sila maŋ na ɔ sia gyae ke gyuusu na waa naa nyeedoŋ gbɛɛ keŋ. Ɔ be gyae waa ta ditiŋtɛɛ man ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Keŋte Farasiitena baŋ yako e nyiaa, “Nyaŋ gbagba ne diina n wose man adansɛɛ, mɔna nya adansɛɛ keŋ betaŋ tɔnɔɔ fa daa ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Botɔɔ te Yesu yako wɔ nyiaa, “Nyi akpaa maŋ gbagba de di ma wose man adansɛɛ koraŋ nɛ, ke doo na ke gbɛɛ. Nawolo nyi ma gyeŋ botɔɔ keŋ mɔɔ lee na botɔɔ keŋ mee gyu. Ɛmɛɛ ba gyeŋ botɔɔ keŋ mɔɔ lee ya, te ɛ ba gyeŋ botɔɔ keŋ mee gyu ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɛmɛɛ ne bu balaŋ fɔɔ bo lee denibalaŋ nombia kedi gbɛɛ man, mɔna maŋ dɔɔ mɔɔ ne bu ŋolo fɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mɔna nyi akpaa me yako nyi maa bu ŋolo fɔɔ koraŋ nɛ, ke doo na ke gbɛɛ nawolo nyi na maŋ maageŋ ne buu na fɔɔ keŋ ya. Daa na me kya ŋon ɔ be kpila maŋ nɛ ne buu na fɔɔ kenaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ba te ŋmarase do ya mmaraa tɔne man nyiaa, akpaa adansɛɛtena bala nɔɔ de yɛɛ dokoloŋ lee nombii man na, na ke yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Maŋ gbagba ne di ma wose man adansɛɛ, te me kya ŋon ɔ be kpila maŋ nɛ mɔ ne di ma wose man adansɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Keŋte be bɔɔse e nyiaa, “N kya ŋonaŋ kyaa aleŋ?” Te Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ ba gyeŋ maŋ ya te ɛ ba gyeŋ me kya ŋon mɔ ya. Nyi akpaa yeŋ gyeŋ maŋ nɛ, nafɔ ɛ ka gyeŋ me kya ŋon mɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Debaŋ keŋ Yesu na wola nombia kɛŋa Wurubuarɛ ɔsom deni dinaa keŋ man nɛ, na ɔ seŋɛɛ benaa na adakaase ŋan bɛɛ mo abɔɔ do ŋe man fa Wurubuarɛ nɛ. Mɔna ŋolo te tale kyaŋ e ya, nawolo nyi debaŋ keŋ Wurubuarɛ ba see e nɛ te lii ta ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Keŋte Yesu besewɔ yako wɔ nyiaa, “Mee gyu baa. Ɛ ke kɛo maŋ, mɔna ɛ ka yeŋ ɛ nombiakumɛɛ man. Ɛ be gyae ɛ ke tale gyu botɔɔ keŋ mee gyu nɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mena dɔɔ Gyudatena kegyiise baŋ bɔɔse dɔŋa nyiaa, “Na ɔ ne gyae waa ko ɔ wose baa yaa sena te ɔ ne yako nyi, ɛ be gyae ɛ ke tale gyu botɔɔ keŋ mee gyu ya nɛ?” ");
INSERT INTO ntr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Keŋte Yesu yako wɔ nyiaa, “Ɛmɛɛ lee tɛɛle kei dɔɔ kɛbo, mɔna maŋ dɔɔ ma lee adido. Ɛ yɛɛ tɛɛle kei dɔɔ balaŋwɔ, mɔna maŋ te yɛɛ tɛɛle kei dɔɔ walaŋ e ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mena dɔɔ te mɛɛ yako ŋon nyiaa, ɛ ka yeŋ ɛ nombiakumɛɛ man nɛ. Nyi akpaa ɛ bɛɛ ɛ te lɛɛ maŋ di nyi maŋ yɛna ŋon ɔ kyaa pɛte be yɛɛ kpene kamasɛ ya nɛ, ɛ ka yeŋ ɛ nombiakumɛɛ man.” ");
INSERT INTO ntr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Keŋte be bɔɔse Yesu nyiaa, “Nyaŋ yɛna amɔte?” Te Yesu tiranɔɔ fa wɔ nyiaa, “Maŋ yɛna walaŋ ŋon mɔɔ taŋ wulaa yako ŋon lee kewalaŋ keŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Me dana nombia burum ŋan kaboena nyi maa yako lee ɛ wose man na maa bu ŋon fɔɔ. Mɔna walaŋ ŋon ɔ be kpila maŋ nɛ ɔ nombia doo na ke gbɛɛ, mena dɔɔ kpene keŋ me nyi lee ɔ gyaŋ na, keŋte mɛɛ yako fa balaŋ tɛɛle kei dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mɔna balaŋ baŋ te nyii nombia ŋan man nyi Yesu ne kolosi baa lee ɔ kya Wurubuarɛ wose man ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mena dɔɔ Yesu yako wɔ nyiaa, “Nyi akpaa ɛ gyɔ maŋ Deniwalaŋ Bu ŋon ɔpaŋdaŋ dɔɔ mataa adido nɛ, botɔɔ te ɛ kena nyi maŋ yɛna walaŋ ŋon me kpa me yɛɛ nɛ. Botɔɔ te ɛ kena nyiaa mɔɔ ne yɛɛ kolo me baam dɔɔ ya. Mɔna mɛɛ kolosi kpene keŋ me kya ŋon ne yako maŋ nɛ bo. ");
INSERT INTO ntr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Te ŋon ɔ be kpila maŋ ne kpuɛ na maŋ. Ɔ te tinaa ta maŋ yela maageŋ ya, nawolo nyi debaŋ kamasɛ na mɛɛ yɛɛ ɔ kegyaebii bo.” ");
INSERT INTO ntr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Keŋte balaŋ burum baŋ bɔɔ nyii nombia ŋan Yesu ne yako nɛ lɛɛ e di. ");
INSERT INTO ntr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mena dɔɔ Yesu yako Gyudatena baŋ bɔɔ lɛɛ e di nɛ nyiaa “Akpaa ɛ di kpene keŋ mɛɛ wola ŋon nɛ dɔɔ na, kenaŋ na ɛ yɛɛ me kaseela gbagbawɔ. ");
INSERT INTO ntr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kei gyae ke yela ɛ ka gyeŋ anokoare keŋ, te anokoare keŋ gyae ke yela ɛ ke nyiŋ ɛ wose.” ");
INSERT INTO ntr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Keŋte be tiranɔɔ nyiaa, “De yɛɛ Aberaham ɔ naanasewɔ, te de ta bese ta ŋolo gbeŋi ya. Sena yaa n ne yako nyi dɛɛ lee gbeŋiri man na dee nyiŋ da wose?” ");
INSERT INTO ntr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu tiranɔɔ fa wɔ nyiaa, “Anokoare yaa mɛɛ yako ŋon nyi nyaŋ ŋon n yɛɛ dukum nɛ, n ta bese gbeŋi fa dukum keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gbeŋi bɛɛ bese dekpaŋalaŋ duuluŋ walaŋ ya, mɔna dekpaŋalaŋte bu dɔɔ ɔ yɛɛ dekpaŋalaŋ duuluŋ walaŋ e kekpaa. ");
INSERT INTO ntr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mena dɔɔ nyi maŋ Wurubuarɛ bu de yela n nyiŋ n wose na, n ke nyiŋ n wose kekpaa. ");
INSERT INTO ntr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma gyeŋ nyi ɛ yɛɛ Aberaham ɔ naanasewɔ mɔna ɛ ne gyae ɛ ka ko maŋ, nawolo nyi me nombia be doo ɛ konɔɔse man ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nombia ŋan me kya ba wola maŋ nɛ ŋan te mee kolosi fa ŋon, te ɛmɛɛ dɔɔ ŋan ɛ be nyii lee ɛ kya gyaŋ nɛ ŋan te ɛ ne yɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Botɔɔ te be tiranɔɔ fa e nyiaa, “Aberaham yɛna de kya.” Te Yesu yako wɔ nyiaa, “Akpaa ɛ yɛɛ Aberaham biawɔ nɛ, nafɔ ɛ keyɛɛ abɔɔ ŋan Aberaham be yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mɔna ɛ te yase sia nyi ɛ ka ko maŋ nawolo nyi ma te yako ŋon anokoare keŋ mɔɔ nyii lee Wurubuarɛ gyaŋ nɛ. Aberaham te yɛɛ mena nombia kɛŋa dinɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɛ ne yɛɛ kpene keŋ ɛmɛɛ gbagba ɛ kya ne yɛɛ nɛ bo.” Te be lɛɛ ka aŋmaareŋ nyiaa, “Wurubuarɛ waageŋ yɛna de kya, da te yɛɛ diidɔɔre bia ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Keŋte Yesu yako wɔ nyiaa, “Nyi akpaa ɛ kya yɛna Wurubuarɛ nɛ nafɔ ɛ ke gyae maŋ, nawolo nyi Wurubuarɛ ŋonaŋ gyaŋ te ma leewɔ kɔŋ kɛbo. Na maŋ gbagba me baam dɔɔ te me kɔŋawɔ ya. Wurubuarɛ ŋonaŋ gbagba kpila na maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Weera dɔɔ te ɛ be nyii me nombia ŋan man ya? Nawolo nyi ɛ bɛɛ gyae ɛ ke nyii me nombia ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɛ kya yɛna ɔbɔnsam te ɛ kya ŋonaŋ kegyaebii te ɛ ne gyae ɛ ke yɛɛ. Ɔ yɛɛ awudiini e leenaŋ gyaŋgba gyaŋgba keŋ, te ɔ bɛɛ gyae anokoare ya nawolo nyi anokoare be doo ɔ man ya. Akpaa ɔ ne di dekara nɛ ke yɛɛ ŋon gbagba dinɔɔ ke, nawolo nyi akɛrɛɛ te wulu ɔ man te ŋon yɛna akɛrɛɛ pou nyee. ");
INSERT INTO ntr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mɔna maŋ dɔɔ nombia ŋan ŋe doo na ŋe gbɛɛ nɛ te mɛɛ yako ŋon, mena dɔɔ te ɛ bɛɛ lɛɛ maŋ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ɛ man woŋti ne gyae la waa tale wola nyi nombiikum kei te me yɛɛwɔ? Te akpaa mɛɛ yako ŋon anokoare na, woŋ dɔɔ te ɛ bɛɛ lɛɛ maŋ di ya? ");
INSERT INTO ntr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Walaŋ ŋon ɔ yɛɛ Wurubuarɛ walaŋ e nɛ, ɔ ne nyii Wurubuarɛ dei. Kpene keŋ dɔɔ te ɛ bee nyii Wurubuarɛ dei yɛna nyi, ɛ te yɛɛ ɔ balaŋwɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Keŋte Gyudatena kegyiise baŋ bɔɔse Yesu nyiaa, “De yako nyi n yɛɛ Samaria baale e te feliŋkum doo n man na, de karae?” ");
INSERT INTO ntr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Botɔɔ te Yesu yako wɔ nyiaa, “Feliŋkum be doo me man ya. Mɛɛ lese me kya ŋon yele bo, mɔna ɛmɛɛ bee bu maŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɔɔ ne gyae maa lese maŋ gbagba yele ya, mɔna ŋolo kyaa keŋ waa lese ma yele. Ŋon yɛna nombiadiiri ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ kamasɛ ŋon ɔ di me nombia dɔɔ nɛ ɔ be gyae waa yeŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Keŋte Gyudatena kegyiise baŋ yako e nyiaa, “Nɛnɛɛ da te naa gyeŋ nyi feliŋkum doo n man. Aberaham ta yem mena mɔ te Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ mɔ yekeewɔ. Mɔna nyaŋ ne yako nyi walaŋ kamasɛ ŋon ɔ di n nombia dɔɔ na ɔ be gyae waa yeŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nyaŋ kela na de naana Aberaham ŋon? Aberaham ta yem mena mɔ te Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ mɔ yekeewɔ. N ne yako baa nyi nyaŋ yɛna amɔte?” ");
INSERT INTO ntr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Keŋte Yesu yako wɔ nyiaa, “Akpaa ma lese maŋ gbagba yele nɛ, ma yele kalese keŋ yɛɛ yakaa. Me kya ŋon ɛmɛɛ kpa ŋon yɛna ɛ Wurubuarɛ nɛ na lesena ma yele. ");
INSERT INTO ntr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ɛmɛɛ ba gyeŋ e ya, mɔna maŋ dɔɔ ma gyeŋ e. Nyi akpaa me yako ŋon nyi mɔɔ gyeŋ e ya nɛ na me ta bese dekarate ŋgba ɛmɛɛ nɛ, mɔna ma gyeŋ e te mee dii ɔ nombia dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yɛɛ ɛ kya Aberaham gyoŋ ŋgba ɔ be naa ma kekɔŋ nɛ. Ɔ naa ke te yɛɛ e gyoŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Keŋte Gyudatena kegyiise baŋ bɔɔse Yesu nyiaa, “N te dii ta kulutooneŋ sɔŋola na kufu gba ya, sena te n yɛɛwɔ naa Aberaham?” ");
INSERT INTO ntr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Keŋte Yesu tiranɔɔ fa wɔ nyiaa “Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, pɛ baa lola Aberaham nɛ na maŋ kyaa.” ");
INSERT INTO ntr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Botɔɔ te be gate boya baa fuŋii e, mɔna Yesu sarakeewɔ lee Wurubuarɛ ɔsom deni dinaa keŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu keta ɔ ne lam nɛ ɔ naa balee ŋolo ŋon ɔ sia be yɛlɛɛ leenaŋ ɔ biatɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Botɔɔ te ɔ kaseela baŋ bɔɔse e nyiaa, “De Gbeŋgyoo, amɔte dukum faa la te ba lola e siayɛlɛɛsate? Yɛɛ ŋon gbagba wui yaa ɔ lolala wui?” ");
INSERT INTO ntr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu tiranɔɔ fa wɔ nyiaa, “Ɔ sia keyɛlɛɛ te yɛɛ ɔ dukum yaa ɔ lolala wui ya. Ba lola e bo mena na balaŋ kena gyakoloŋ nombia ŋan Wurubuarɛ waa yɛɛ ɔ man. ");
INSERT INTO ntr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Weese nyiŋa ɔ kyaa nɛ, kaboena nyi dɛɛ yɛɛ ŋon ɔ be kpila maŋ nɛ tom, Tɛɛ gyae ke yuu keŋ ŋolo be gyae waa tale yɛɛ tom bela ya. ");
INSERT INTO ntr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Me nyiŋa me kyaa tɛɛle kei dɔɔ nɛ, maŋ yɛna keŋmaŋee fa tɛɛle kei balaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ɔ keyako nombia kɛŋa taŋ nɛ, Yesu tɔɔ nɔɔloŋ lɔ tɛɛle man te ɔ buu tɛɛle te ɔ moowɔ taa balee ŋon sia ŋan dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","keŋte ɔ yako e nyiaa, “Gyu kefaafo n sia depaa keŋ bɛɛ baake ke Siloam nɛ man.” (Siloam kei asɛɛ yɛna “Kekpila”.) Mena dɔɔ balee ŋon gyuuwɔ kefaafo ɔ sia, ɔ ka bese kɔŋ dɛɛ na ɔ sia te gyuusu. ");
INSERT INTO ntr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɔ tebia na balaŋ baŋ ba gyeŋ e nyi nafɔ ɔ kyaa na ɔ na solee abɔɔ nɛ bɔɔsewɔ nyiaa, “Na balee kei ne kyaa la kyaa solee abɔɔ nɛ yee?” ");
INSERT INTO ntr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Botɔɔ te baale kpa “Ŋon ŋonaŋ” mɔna baale mɔ kpa “Koa, na ŋon ŋonaŋ ya, ɔ lee e bo.” Mena dɔɔ balee ŋon gbagba yakowɔ nyiaa, “Maŋ ŋonaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Te be bɔɔse e nyiaa, “Sena yaa n yɛɛwɔ te n sia gyuusuwɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Keŋte ɔ tiranɔɔ fa wɔ nyiaa, “Balee ŋon bɛɛ baake e nyi Yesu nɛ, buuna tɛɛle te ɔ moowɔ mataa me sia te ɔ yako maŋ nyi maa gyu Siloam depaa keŋ man kefaafo me sia. Mena dɔɔ me gyuuwɔ, te me kabetaa faafo me sia na te ŋe gyuusuwɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Keŋte be bɔɔse e nyiaa, “Ɔ kyaa aleŋ?” Te ɔ tiranɔɔ fa wɔ nyi “Mɔɔ gyeŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Te ba moo balee ŋon nafɔ ɔ sia be yɛlɛɛ nɛ kɔŋ Farasiitena gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wee kenaŋ keŋ Yesu be buu tɛɛle mo kyɔ siayɛlɛɛsate ŋon nɛ yɛɛ Gyudatena kefɛɛfowee ke. ");
INSERT INTO ntr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mena dɔɔ Farasiitena baŋ besewɔ bɔɔse balee ŋon bela mena keŋ be yɛɛ te ɔ sia ŋan be gyuusu. Keŋte ɔ yako wɔ nyi, “Ɔ buu tɛɛle bo taa me sia, te me gyuuwɔ kefaafo te ŋe gyuusuwɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Botɔɔ te Farasiitena baŋ baale yakowɔ nyi “Balee ŋon ɔ be yɛɛ nombii kei nɛ ta lee Wurubuarɛ gyaŋ ya, nawolo nyi ɔ bee di da kefɛɛfowee keŋ dɔɔ ya.” Mɔna baale mɔ yakowɔ nyiaa, “Sena te walaŋ ŋon ɔ yɛɛ nombiakumɛɛyɛɛre e nɛ, waa tale yɛɛ gyakoloŋ nombia kɛŋa?” Botɔɔ na te be man kpasewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mena dɔɔ Farasiitena baŋ besewɔ bɔɔse balee ŋon bela nyiaa, “N sia te ɔ gyuusuwɔ. Mena dɔɔ sena te n ne yako lee ɔ wose man?” Keŋte balee ŋon tiranɔɔ nyiaa, “Ɔ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e.” ");
INSERT INTO ntr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kɛŋa pou wɔle nɛ Gyudatena kegyiise baŋ te sɛɛ lɛɛ di nyi ɔ sia yɛlɛɛwɔ te nɛnɛɛ ba te kyɔ e kawee ya, te ba ke baake ɔ kya na ɔ naa kɔŋ, ");
INSERT INTO ntr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","te be bɔɔse wɔ nyiaa, “Ɛ bu yɛna kei? Ɛ ne yako baa nyi ba lola e na ɔ sia te yɛlɛɛ? Sena kɔŋala te nɛnɛɛ dɔɔ ɔ ne naa?” ");
INSERT INTO ntr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Keŋte ɔ kya na ɔ naa tiranɔɔ nyiaa, “Da gyeŋ nyi de bu ŋonaŋ, te da gyeŋ nyi da lola e na ɔ sia te yɛlɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mɔna dɔɔ gyeŋ mena keŋ be kɔŋ te ɔ ne naa nɛ ya, te dɔɔ gyeŋ ŋon ɔ be kyɔ e ya. Ɛ bɔɔse e, ɔ ta bee keŋ waa tale tiranɔɔ fa ɔ wose.” ");
INSERT INTO ntr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɔ kya na ɔ naa yako nombia kɛŋa nawolo nyi bee yee Gyudatena kegyiise baŋ. Na Gyudatena baŋ taŋ kaŋ ntam nyi nyaŋ ŋon n ka koro yako nyi Yesu yɛna nyeelɛɛre ŋon na baa gegi neŋ lee bɔ ɔsom deni man. ");
INSERT INTO ntr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mena dɔɔ te balee ŋon ɔ kya na ɔ naa yakowɔ nyi, “Ɔ ta bee, ɛ bɔɔse e nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Te ba besewɔ baake balee ŋon nafɔ ɔ sia be yɛlɛɛ nɛ kɔŋ te be yako e nyiaa, “Kaŋ Wurubuarɛ nyi nyaŋ keyako anokoare. Da gyeŋ nyi balee ŋon ɔ be kyɔ neŋ nɛ yɛɛ dukumyɛɛre e.” Yako mena na n ka mo lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Keŋte balee ŋon tiranɔɔ fa wɔ nyiaa, “Ɔ yɛɛ dukumyɛɛre o, ɔ yɛɛ walaŋ kpaakpaa e o maŋ ba gyeŋ ya. Keŋ maŋ gyeŋ yɛna nyi nafɔ na me sia te yɛlɛɛ te nɛnɛɛ dɔɔ mɛɛ naa.” ");
INSERT INTO ntr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Keŋte ba besewɔ bɔɔse e nyiaa, “Woŋ te ɔ yɛɛ neŋ te n sia gyuusuwɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Te ɔ tiranɔɔ nyiaa, “Me taŋ keyako ŋon, te ɛ bɛɛ gyae ɛ ke tei ya. Woŋ dɔɔ te ɛ ne gyae ɛ kenyii ke bela? Ɛmɛɛ mɔ ne gyae ɛ ka bese ɔ kaseela?” ");
INSERT INTO ntr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Keŋte ba tee e te be yakowɔ nyiaa, “Nyaŋ yɛna walaŋ ŋonaŋ kaseele, mɔna daa yɛɛ Mosesi wui kaseelawɔ. ");
INSERT INTO ntr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Da gyeŋ nyi Wurubuarɛ kolosiwɔ fa Mosesi, te balee kei dɔɔ dɔɔ gyeŋ botɔɔ keŋ ɔ ba lee gba ya.” ");
INSERT INTO ntr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Botɔɔ te balee ŋon yako wɔ nyiaa, “Te doo me nɔɔ ŋgba ɛ ba gyeŋ botɔɔ keŋ ɔ ba lee ya, mɔna ŋon gyuusu na me sia. ");
INSERT INTO ntr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Da gyeŋ nyi Wurubuarɛ bee nyii nombiakumɛɛyɛɛra ya. Ɔ ne nyii balaŋ baŋ bee nyii e te bɛɛ yɛɛ kpene keŋ ɔ ne gyae nɛ bo. ");
INSERT INTO ntr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lee tɛɛle kei kewalaŋ nɛ, ŋolo te nyii ta nyi ŋolo te gyuusu walaŋ ŋon bɔɔ lola e na ɔ sia te yɛlɛɛ nɛ sia ya. ");
INSERT INTO ntr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Akpaa balee kei ta lee Wurubuarɛ gyaŋ ya nɛ, ɔ be gyae waa tale yɛɛ nombii kei ya.” ");
INSERT INTO ntr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Te be tiranɔɔ fa e nyiaa, “Nyaŋ ŋon bɔɔ lola neŋ dukum man te bɔɔ kɛɛle neŋ dukum man na, nyaŋ ne gyae n kawola daa nombia?” Keŋte be gegi e lee te be tɔɔ e nyi ɔ na kɔŋ bɔ ɔsom deni keŋ man bela ya. ");
INSERT INTO ntr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu kenyii nyi ba te gegi e lee bɔ ɔsom deni keŋ man nɛ, ɔ ke kɛo e te ɔ naa e te bɔɔse e nyiaa, “N ne lɛɛ Deniwalaŋ Bu ŋon di?” ");
INSERT INTO ntr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Te balee ŋon tiranɔɔ fa e nyi, “Me Gbeŋgyoo, amɔte ŋonaŋ? Yako maŋ na maa lɛɛ e di.” ");
INSERT INTO ntr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Botɔɔ te Yesu yako e nyiaa, “N taŋ kena e. Ŋon yɛna ŋon ɔ ne kolosi fa neŋ debokeiman nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Te balee ŋon yakowɔ nyiaa, “Mɛɛ lɛɛ e di me Gbeŋgyoo.” Te ɔ buŋawɔ Yesu siaman som e. ");
INSERT INTO ntr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Botɔɔ te Yesu yakowɔ nyiaa, “Me kɔŋae tɛɛle kei dɔɔ na balaŋ nombiakumɛɛ ka lee debɔɔ. Na baŋ bɔɔ ne naa ya nɛ kena, na baŋ bɛɛ naa nɛ sia keyɛlɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farasiitena baŋ be kyaa ɔ gyaŋ botɔɔ nɛ, baale nyii kpene keŋ ɔ be yako mena dɔɔ be bɔɔse e nyiaa, “Mena dɔɔ n ne yako baa nyi daa mɔ sia te yɛlɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Ɛ sia deŋ te yɛlɛɛ nɛ nafɔ ŋolo be gyae waa bu ŋon fɔɔ ya. Te keŋ ɛ kpa ɛ ne naa dɔɔ te ɛ sɛɛ ɛ doo ɛ dukum keyɛɛ man.” ");
INSERT INTO ntr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Keŋte Yesu yakowɔ nyiaa, “Mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ ŋon ɔ ta mo denanɔɔ keŋ man gyoo namense debɔɔlɔɔ keŋ man ya, te ɔ gyem mo yenaŋ kale gyoo na ɔ yɛɛ ŋmɛɛlate e, te ɔ na mo doŋ bo lɛo balaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Walaŋ ŋon ɔ na mo denanɔɔ keŋ man gyoo na, ŋon yɛna namensekɛɛlere ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Denanɔɔ dekere ŋon na toro fa e te namense baŋ ne nyii ɔ woya. Ɔ ne baake ŋon gbagba namense baŋ yele na ɔ ta mo wɔ lee. ");
INSERT INTO ntr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te ɔ mo wɔ pou lee na ɔ ne tɛɛ be siaman, te namense baŋ ne sila e nawolo nyi ba gyeŋ ɔ woya. ");
INSERT INTO ntr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bɔɔ gyae baa sila walaŋ yakaate ya. Baa yeu lee ɔ gyaŋ nawolo nyi bɔɔ gyeŋ ɔ woya ya.” ");
INSERT INTO ntr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu gyɔɔ dudu kei fa wɔ, mɔna be te nyii kpene keŋ ɔ ne yako nɛ asɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mena dɔɔ Yesu besewɔ yako wɔ nyiaa “Ampaŋ yaa mɛɛ yako ŋon nyiaa, maŋ yɛna namense debɔɔlɔɔ keŋ denanɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Baŋ pou bɔɔ taŋgbɛɛ maŋ kɔŋ kaa beo nyi Wurubuarɛ kpila na wɔ nɛ, be yɛɛ ŋmɛɛlatenawɔ na baŋ bɛɛ mo doŋ lɛo balaŋ abɔɔ nɛ, mɔna namense baŋ te nyii wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Maŋ yɛna denanɔɔ keŋ, akpaa ŋolo de tɛɛ me man gyoo na, maa lɛɛ ɔ nyee. Waa gyoo na waa lee na waa nyiŋ weenɛɛ kpaakpaa di. ");
INSERT INTO ntr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ŋmɛɛlate dɔɔ ɔ ne kɔŋ bo kaa ŋmɛɛle na ɔ ta koo na ɔ te wɔlɛɛ abɔɔ. Maŋ kɔŋae na ɛ kenyiŋ nyeedoŋ, na ɛ kenyiŋ ke kekpaa. ");
INSERT INTO ntr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Maŋ yɛna namensekɛɛlere kpaakpaate ŋon. Namensekɛɛlere kpaakpaate ŋon na mo ɔ wose fa yeŋ ɔ namense baŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mɔna paate ŋon bɔɔ moo nyi waa kɛɛ namense baŋ dɔɔ na baa tɔ e kom nɛ, na ŋon yɛna namensekɛɛlere ŋon ɔ tee namense baŋ ya. Mena dɔɔ ɔ naa nyi gbougbouse ne kɔŋ na, ɔ ne yeu tina namense baŋ yela, na gbougbouse baŋ te kyaŋ baale na akaŋ baŋ te yaasee. ");
INSERT INTO ntr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ɔ ne yeu nawolo nyi ba mo e bo na bɛɛ tɔ e kom, mena dɔɔ ɔ be famenɛ na namense baŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Maŋ yɛna namensekɛɛlere kpaakpaate ŋon. Mena keŋ me kya gyeŋ maŋ te maŋ mɔ gyeŋ e nɛ mena ke te ma gyeŋ me namense te baŋ mɔ gyeŋ maŋ, te ma te sɛɛ nyi maa mo ma wose fa yeŋ me namense baŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Me dana namense baale baŋ bɔɔ kpuɛ kɛwɔ man ya. Kaboena nyi maa mo baŋ mɔ kaa kpu na kɛwɔ na be popou keyɛɛ walaŋ dokoloŋ namense, debɔɔlɔɔ dokoloŋ man, na be kɛɛlere ke yɛɛ dokoloŋ na baa nyii ma dei. ");
INSERT INTO ntr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kpene keŋ dɔɔ me kya ne gyae me nombia yɛna nyi, ma te desina ma wose nyi maa mo ma wose fa yeŋ ma kegyaebii man na maa bese foŋ lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ŋolo be gyae waa tale lɛo ma nyeedoŋ lee me gyaŋ ya. Mɔna maŋ gbagba ma kegyaebii man te maa mo ma wose fa yeŋ. Me dana doŋ maa mo ma wose fa yeŋ, te me dana doŋ maa bese nyiŋ nyeedoŋ bela. ‘Kei yɛna kpene keŋ me kya ŋon be yako maŋ nyi maa yɛɛ.’ ” ");
INSERT INTO ntr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lee nɔɔwoya kɛŋa dɔɔ Gyudatena baŋ besewɔ kpase ba wose man. ");
INSERT INTO ntr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Be man balaŋ burum yakowɔ nyiaa, “Ɔ dana feliŋkum mena dɔɔ ɔ nyee ne wɔlɛɛ. Woŋ dɔɔ te ɛ ne nyii e?” ");
INSERT INTO ntr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Baale mɔ kpa, “Walaŋ ŋon feliŋkum doo ɔ man be gyae waa tale kolosi nnɛ ya! Sena te feliŋkum gyae ke tale gyuusu siayɛlɛɛsate sia?” ");
INSERT INTO ntr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Keŋte Gyudatena wee dinaa daale kaa liiwɔ. Mena wee kei te bee dii mo tɔɔse debaŋ keŋ bɔɔ mo bɔ ɔsom deni dinaa keŋ do Wurubuarɛ nyiŋmaa man nɛ. Mena debaŋ kenaŋ yɛɛ waare tɛɛ Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na Yesu dɔŋɛɛ ɔ ne kila poto keŋ bɛɛ baake ke Solomɔn poto Wurubuarɛ ɔsom deni dinaa keŋ dekpaŋalaŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Keŋte Gyudatena baale kaa yilaawɔ ɔ gyaŋ bɔɔse e nyiaa, “Sena yaa n tinaa daa yela te de bɛɛ gyeŋ da nyee na de nawɔɔ ya nɛ? Yako daa anokoare keŋ. Nyaŋ yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ?” ");
INSERT INTO ntr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Me taŋ keyako ŋon mɔna ɛ bɛɛ lɛɛ maŋ di ya. Gyakoloŋ nombia ŋan mɔɔ yɛɛ me kya yele man nɛ, ne diina ma wose man adansɛɛ, ");
INSERT INTO ntr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","mɔna ɛ bɛɛ lɛɛ maŋ di ya, nawolo nyi ɛ te yɛɛ me namensewɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Me namense ne nyii me dei, te ma gyeŋ wɔ te bee sila maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɛɛ fa wɔ nyeedoŋ kekpaa keŋ, te bɔɔ gyae baa yo lee Wurubuarɛ siaman ya. Ŋolo be gyae waa tale lɛo wɔ lee me gyaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Me kya ŋon ɔ ba mo wɔ do me nyiŋmaa man nɛ, dana doŋ kela kolo kamasɛ te ŋolo be gyae waa tale lɛo wɔ lee me kya nyiŋmaa man ya. ");
INSERT INTO ntr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Daa na me kya yɛɛ walaŋ dokoloŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Botɔɔ te Gyudatena baŋ gate boya baa fuŋ e bela. ");
INSERT INTO ntr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Keŋte Yesu yako wɔ nyiaa, “Me kya te yeli ma te yɛɛ nombia kpaakpaa burum ɛ siaman, ŋe man woŋti dɔɔ te ɛ ne gyae ɛ ke fuŋii maŋ boya?” ");
INSERT INTO ntr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Te Gyudatena baŋ tiranɔɔ fa e nyiaa, “Na abɔɔ nya ayɛɛŋ kɛŋa dɔɔ te dɛɛ gyae dee fuŋii neŋ boya ya, mɔna mena keŋ n ne yako mmusuo nombia dɔɔ. Nawolo nyi n yɛɛ deniwalaŋ e, mɔna n na mo n wose maa na Wurubuarɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Botɔɔ te Yesu bɔɔse wɔ nyiaa, “Ba te ŋmarase ɛmɛɛ gbagba mmaraa tɔne keŋ man nyi, Wurubuarɛ kpa, ɛ yɛɛ Wurubuarɛ kemaasasewɔ yee? ");
INSERT INTO ntr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Da gyeŋ nyi kpene keŋ Wurubuarɛ nombia ŋan ne yako nɛ yɛɛ anokoare kekpaa. Te Wurubuarɛ de baake balaŋ baŋ ɔ ba mo ɔ nombia ŋan fa nɛ nyi be yɛɛ Wurubuarɛ kemaasasewɔ na, ");
INSERT INTO ntr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","weera dɔɔ te ɛ ne yako maŋ ŋon Wurubuarɛ ba lese maŋ te ɔ be kpila maŋ kɔŋ tɛɛle kei dɔɔ nɛ nyi mɛɛ mo ma wose maa na Wurubuarɛ keŋ mɛɛ yako nyi me yɛɛ Wurubuarɛ bu e dɔɔ? ");
INSERT INTO ntr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Akpaa me bɛɛ yɛɛ kpene keŋ me kya ŋon kpa ma yɛɛ ya na, ɛ na lɛɛ maŋ di ya, ");
INSERT INTO ntr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","te akpaa mɛɛ yɛɛ ŋa na, nyi ɛ be lɛɛ maŋ di koraŋ ya na ɛ lɛɛ abɔɔ ŋan mɛɛ yɛɛ nɛ di, na ɛ ka gyeŋ na ɛ kenyii asɛɛ nyiaa daa na me kya ŋon yɛɛ dokoloŋ” ");
INSERT INTO ntr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mena dɔɔ be gyaewɔ baa kyaŋ e bela, te ɔ sarakeewɔ lee be man. ");
INSERT INTO ntr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Keŋte Yesu besewɔ toŋ Gyɔɔdan boo keŋ gyu botɔɔ keŋ Gyɔn be kyaa sɔ balaŋ Wurubuarɛ loŋ kaalaŋ nɛ, te ɔ ke kyaawɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Balaŋ burum kɔŋawɔ ɔ gyaŋ te be yako dɔŋa nyiaa, “Gyɔn te yɛɛ gyakoloŋ nombia ya, mɔna kpene kamasɛ keŋ ɔ be yako lee balee kei wose man nɛ yɛɛ ampaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Keŋte balaŋ burum baŋ ba seŋɛɛ botɔɔ nɛ lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Balee ŋolo kyaawɔ Bɛtani donɔɔ man keŋ bɛɛ baake e nyi Lasarose. Bɛtani donɔɔ kenaŋ man te Mɛɛre na ɔ kɔɔ Maata leewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mɛɛre kei yɛna walaŋ ŋon ɔ be toosi nuŋ ofoŋofoŋ woli Yesu nawɔɔ, te ɔ ba mo ɔ nyeenyɔɔse feefo ŋa nɛ. Ɔ ŋmɛɛtee yɛna Lasarose ŋon ɔ na wee nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mena dɔɔ Mɛɛre na Maata doo Yesu tiila nyiaa, “De Gbeŋgyoo, n gyoo ŋon loŋ bɛɛ lam ɛmɛɛ na e nsana ya nɛ na wee.” ");
INSERT INTO ntr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu kenyii tiila keŋ nɛ ɔ yakowɔ nyiaa, “Kawee kei te yɛɛ kawee keŋ gyae ka ko Lasarose ya. Mɔna ke gyae ke yela balaŋ kena Wurubuarɛ gyoorobiiri na ka ke yela baa lese maŋ Wurubuarɛ bu ŋon mɔ yele.” ");
INSERT INTO ntr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na Yesu ne gyae Maata na ɔ naabu Mɛɛre na Lasarose nombia. ");
INSERT INTO ntr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mɔna ɔ kenyii nyi Lasarose na wee nɛ, ɔ besewɔ di weeya ala botɔɔ keŋ ɔ kyaa nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kenaŋ wɔle nɛ ɔ yako ɔ kaseela baŋ nyiaa, “Ɛ fa dɛɛ bese gyu Gyudia tɛɛle man bela.” ");
INSERT INTO ntr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Botɔɔ te ɔ kaseela baŋ yako e nyiaa, “De Gbeŋgyoo, weeya akalansɛɛ ŋaale yaa ŋgba Gyudatena be yele baa fuŋii neŋ boya nɛ. Woŋ dɔɔ te n ne gyae n ka bese gyu botɔɔ bela?” ");
INSERT INTO ntr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Keŋte Yesu tiranɔɔ fa wɔ nyiaa, “Wee kamasɛ dana ke nelim na ka weese. Akpaa ŋolo dɔŋɛɛ weeseteŋteŋ nɛ, ɔ bɛɛ gyɔ ɔ nae ya nawolo nyi weese kyaa. ");
INSERT INTO ntr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mɔna nyi akpaa ɔ dɔŋɛɛ ditiŋtɛɛ man na ɔ ne gyɔ ɔ nae, nawolo nyi keŋmaŋee be kyaa na waa naa ya.” ");
INSERT INTO ntr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kei wɔle na Yesu besewɔ yako wɔ nyiaa, “De gyoo Lasarose te doo dosoroŋ mɔna maa gyu na me kaa gyuusu e.” ");
INSERT INTO ntr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Botɔɔ te ɔ kaseela baŋ tiranɔɔ nyiaa, “De Gbeŋgyoo, akpaa ɔ doe na ɔ kawee keŋ gyae ke taŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na Lasarose yeŋ nombia yaa Yesu ne yako, mɔna ɔ kaseela baŋ na gyueŋ bo nyi dosoroŋ gbagba yaa Lasarose doowɔ. ");
INSERT INTO ntr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Botɔɔ te Yesu torowɔ yako wɔ nyiaa, “Lasarose ta yem, ");
INSERT INTO ntr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","mɔna lee ɛmɛɛ dɔɔ dana maŋ gyoŋ nyi mɔɔ kyaa botɔɔ pɛte ɔ yeŋawɔ ya, na ɛ kenyiŋ lɛɛ maŋ di. Ɛ fa dee gyu ɔ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mena dɔɔ ɔ kaseela baŋ man ŋolo ŋon bɛɛ baake e Tomase yaa Ata nɛ yako ɔ tebia kaseela akaŋ baŋ nyiaa, “Ɛ fa de popou ke sila da wolale ŋon gyu. Nyi yɛɛ yeŋ ke na, de popou ka yeŋ kpu na e.” ");
INSERT INTO ntr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu ke gyu ka gyoo Bɛtani donɔɔ man nɛ, be yako e nyiaa be kewuu Lasarose weeya anaarate kenaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani yɛɛ donɔɔ keŋ ka benaa na Gyerusalɛm donɔɔ. Ke lem gyae ke yɛɛ ŋgba gbɛɛkemaase atooro nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na Gyudatena burum te kɔŋ Maata na Mɛɛre gyaŋ be kaa gyam wɔ lee be ŋmɛɛtee ŋon yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maata ke nyii nyi Yesu ne kɔŋ nɛ, ɔ leewɔ gyu ke gyaŋee na e. Na Mɛɛre dɔɔ ŋon kyaa dekpaŋalaŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata ke gyu ke tuŋ Yesu nɛ ɔ yako e nyiaa, “Me Gbeŋgyoo, nyi akpaa nyeŋ kyaa kɛbo na nafɔ me ŋmɛɛtee deŋ ta yem ya! ");
INSERT INTO ntr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mɔna ma gyeŋ nyi debokeiman koraŋ nɛ, kpene kamasɛ keŋ n bɔɔse Wurubuarɛ na waa yɛɛ fa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Keŋte Yesu yako e nyiaa, “N ŋmɛɛtee ŋon waa bese foŋ na waa nyiŋ nyeedoŋ bela.” ");
INSERT INTO ntr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Te Maata yako e nyiaa, “Ayi ma gyeŋ nyi wee ɔtomante keŋ woya pou baa foŋ lee yeŋ man nɛ, ŋon mɔ waa foŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Keŋte Yesu yako e bela nyiaa, “Maŋ yɛna walaŋ ɔ ne gyuusu balaŋ lee yeŋ man te be nyiŋ nyeedoŋ. Walaŋ kamasɛ ŋon waa lɛɛ maŋ di na, nyi ɔ yem koraŋ na waa bese nyiŋ nyeedoŋ, ");
INSERT INTO ntr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","te walaŋ kamasɛ ŋon ɔ kyaa te ɔ lɛɛ maŋ di na, ɔ be gyae wa yeŋ leki ya.” Keŋte Yesu bɔɔse Maata nyiaa, “N ne lɛɛ nombia kɛŋa di?” ");
INSERT INTO ntr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Te Maata sɛɛ e nyiaa, “Ayi me Gbeŋgyoo, mɛɛ lɛɛ di nyi nyaŋ yɛna nyeelɛɛre, Wurubuarɛ bu ŋon dɛɛ daa nyi waa kɔŋ tɛɛle kei dɔɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata kekolosi nombia kɛŋa taŋ nɛ, ɔ besewɔ gyu dekpaŋalaŋ man ke baake ɔ naabu Mɛɛre lee yenaŋ te ɔ yako e nyiaa, “De Gbeŋgyoo ŋon te kɔŋ te ɔ kpa nya kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɛɛre kenyii mena nɛ, ɔ korowɔ bileŋ gyu ke gyaŋee na e. ");
INSERT INTO ntr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Debaŋ kenaŋ na Yesu ta gyoo ta donɔɔ keŋ man ya. Na ɔ sɛɛ ɔ kyaa botɔɔ keŋ Maata be gyu ke tuŋ e nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Debaŋ kenaŋ mɔ na, Gyudatena te kɔŋ dekpaŋalaŋ keŋ man bee kolosi do Mɛɛre. Ba kena ŋgba Mɛɛre ba koro karatetee dokoloŋ lee ɔ ne gyu nɛ, na baŋ gyeŋ nyi ɔ ne gyu baa ɔ ŋmɛɛtee Lasarose yebɔɔ keŋ tɛɛ ɔ kaa wii. Mena dɔɔ baŋ mɔ korowɔ sila e. ");
INSERT INTO ntr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛɛre ke gyu kelii botɔɔ keŋ Yesu kyaa nɛ te ɔ tisiwɔ buŋ Yesu nawɔɔ tɛɛ te ɔ yako e nyiaa, “Me Gbeŋgyoo, nyeŋ kyaa kɛbo na nafɔ me ŋmɛɛtee deŋ ta yem ya.” ");
INSERT INTO ntr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu kena mena keŋ Mɛɛre na Gyudatena baŋ be silana e ne wii nɛ, takaa e te dekɔkɔrɔkɔɔ kyaŋa e. ");
INSERT INTO ntr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Keŋte ɔ bɔɔse wɔ nyiaa, “Aleŋ te ɛ wuu e?” Te be yako e nyiaa, “De Gbeŋgyoo, kɔŋ na n kaa kɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Keŋte Yesu wiiwɔ. ");
INSERT INTO ntr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Keŋte Gyudatena baŋ yakowɔ nyiaa, “Ɛ kɛɛ mena keŋ ɔ ne gyae Lasarose nombia.” ");
INSERT INTO ntr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mɔna balaŋ baale yakowɔ nyiaa, “Na Yesu kei gyuusuna siayɛlɛɛsate ŋon sia yee? Nafɔ ŋgba ŋon talewɔ lɛɛ Lasarose na ɔ ba yem ya?” ");
INSERT INTO ntr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dekɔkɔrɔkɔɔ kyaŋa Yesu bela te ɔ gyuu botɔɔ keŋ bɔɔ wuu Lasarose nɛ. Na be wuu e bo boe bɔɔ daale maŋ, te be biliŋi boe dinaa daale tɔ ke nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Keŋte Yesu yako wɔ nyiaa, “Ɛ biliŋi boe keŋ lee yebɔɔ keŋ nɔɔman.” Te yere ŋon ɔ deesi Maata yako Yesu nyiaa, “De Gbeŋgyoo, debaŋ kei dɔɔ ɔ ne wɔlɛɛ. Nawolo nyi gyɛŋ yɛna weeya anaara yaa ŋgba bɔɔ wuu e nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Te Yesu yako e nyiaa, “Ma te yako neŋ nyi akpaa n lɛɛ maŋ di na nyaŋ kena Wurubuarɛ gyoorobiiri keŋ yee?” ");
INSERT INTO ntr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mena dɔɔ be biliŋi boe keŋ lee yebɔɔ keŋ nɔɔman. Botɔɔ te Yesu gyinaa ɔ nyee kɛɛ adido te ɔ fanewɔ fa Wurubuarɛ nyiaa, “Taata, mɛɛ fa neŋ karaŋ ŋgba n ne nyii maŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Maŋ dɔɔ ma gyeŋ nyi n ne nyii maŋ debaŋ kamasɛ, mɔna balaŋ baŋ ba seŋɛɛ kɛbo dɔɔ te mɛɛ yako mena na baa nyiŋ gyeŋ nyi nyaŋ kpila na maŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu ke yako mena taŋ nɛ, te ɔ fae yeesa keŋkeŋ baake Lasarose nyiaa, “Lasarose, lee kɔŋ!” ");
INSERT INTO ntr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Keŋte Lasarose ŋon ɔ ba yem nɛ leewɔ kɔŋ, na kewuu abɔɔ ŋan bɔɔ mo bake ɔ nyiŋmaase na ɔ nawɔɔ, na kanyaŋ keŋ bɔɔ mo bake ɔ sia gbɛɛ nɛ doo mena. Te Yesu yako wɔ nyiaa “Ɛ booli e, na waa ta.” ");
INSERT INTO ntr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gyudatena burum baŋ bɔɔ kɔŋ Mɛɛre gyaŋ te bɔɔ naa kpene keŋ Yesu be yɛɛ nɛ lɛɛ e di. ");
INSERT INTO ntr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mɔna be man baale besewɔ gyu Farasiitena baŋ gyaŋ gyu ke yako wɔ kpene keŋ Yesu be yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Keŋte Wurubuarɛ saese kegyiise na Farasiitena baake donɔɔ kegyiise gyaŋee. Te be bɔɔse dɔŋa nyiaa “Sena yaa dɛɛ yɛɛ? Nawolo nyi balee kei ne yɛɛ gyakoloŋ nombia burum. ");
INSERT INTO ntr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Akpaa de tina e yela te ɔ gyakaa ɔ ne yɛɛ mena tom kei na, balaŋ baŋ pou baa lɛɛ e di na ke yela Romantena kaa yɛlɛɛ de Wurubuarɛ ɔsom deni dinaa keŋ na baa lɛo de tɛɛle pou.” ");
INSERT INTO ntr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Te balaŋ baŋ man ŋolo ŋon bɛɛ baake e nyi Kaifase ŋon ɔ be yɛɛ saese kegyia kulutoo kenaŋ man nɛ yakowɔ nyiaa, “Ɛmɛɛ dɔɔ ɛ ba gyeŋ daale ya. ");
INSERT INTO ntr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ɛ ba gyeŋ nyi dei nyi walaŋ dokoloŋ waa yeŋ fa balaŋ baŋ pou kela keŋ nyi tɛɛle pou balaŋ kewɔlɛɛ yee?” ");
INSERT INTO ntr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Te yɛɛ Kaifase gbagba agyueŋ yaa ɔ moowɔ yako nombia kɛŋa ya, mɔna keŋ ɔ be yɛɛ Wurubuarɛ sae kegyia kulutoo kenaŋ man dɔɔ te Wurubuarɛ yela ɔ yako mena nombia ŋenaŋ see nyi, kaboena nyi Yesu waa yeŋ fa Gyudatena pou. ");
INSERT INTO ntr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te yɛɛ nyi Gyudatena baageŋ te Yesu waa yeŋ fa ya, mɔna waa yeŋ bo fa Wurubuarɛ bia baŋ pou bɔɔ yaasee nɛ na waa nyiŋ mo wɔ kaa yilaa. ");
INSERT INTO ntr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Leenaŋ wee kenaŋ keŋ kegyiise baŋ be gyaŋee nɛ, te be fiasɛɛ bɛɛ gyae gbɛɛ keŋ baa mo ko Yesu. ");
INSERT INTO ntr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lee mena dɔɔ na Yesu bɛɛ tekaa lese ɔ wose debɔɔ Gyudia tɛɛle man bela ya. Mɔna ɔ leewɔ botɔɔ gyu donɔɔ keŋ bɛɛ baake ke nyi Eferam te ka benaa na depampaa dinaa daale nɛ. Botɔɔ te ŋon na ɔ kaseela baŋ gyuuwɔ ke kyaa. ");
INSERT INTO ntr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na Gyudatena nyeekelɛɛwee kedi keŋ ta benaa, mena dɔɔ balaŋ burum lee donɔɔse ŋan man gyu Gyerusalɛm be kaa gyoraa ba wose pɛna nyeekelɛɛwee kedi keŋ kelii. ");
INSERT INTO ntr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Debaŋ kenaŋ man pou na bɛɛ kɛo Yesu. Be ka seŋ Wurubuarɛ ɔsom deni dinaa keŋ man nɛ be bɔɔse dɔŋa nyiaa, “Sena yɛna ya gyueŋ? Doona ɔ be gyae waa kɔŋ nyeekelɛɛwee kedi kei man ya?” ");
INSERT INTO ntr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na Wurubuarɛ saese kegyiise na Farasiitena baŋ te yako wɔ nyiaa, walaŋ kamasɛ ŋon ɔ gyeŋ Yesu dekyae na ɔ kaa yako wɔ na be kaa kyaŋ e. ");
INSERT INTO ntr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Keka weeya looro na Gyudatena kedi ba nyeekelɛɛwee dinaa keŋ nɛ, Yesu gyuu Bɛtani donɔɔ man. Mena donɔɔ kenaŋ man te Lasarose ŋon Yesu be gyuusu e lee yeŋ man nɛ leewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Be lɔɔ yele saa weenɛɛ fa Yesu. Maata mɔ kpuɛ baŋ bɛɛ kpɛlɛɛ weenɛɛ ŋan nɛ man. Na Lasarose mɔ kpuɛ na baŋ be kyaa bee dii nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Keŋte Mɛɛre moo nuŋ ofoŋofoŋte keŋ ke dana koyadoŋ nɛ porontia tɔɔ, te ɔ kaa toosi ke woli Yesu nawɔɔ te ɔ moo ɔ nyeenyɔɔse feefo ɔ nawɔɔ ŋan. Te nuŋ keŋ ofoŋ lɛɛ dekpaŋalaŋ keŋ pou. Daŋ keŋ bɛɛ baake ke nyi Naade nɛ te ba moowɔ yɛɛ nuŋ kenaŋ ");
INSERT INTO ntr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te Yesu kaseela baŋ man ŋolo ŋon bɛɛ baake e nyi Gyudase Isekarɔte, ŋon waa kaa lese Yesu fa na baa ko nɛ yakowɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Woŋ dɔɔ te ba te yɔɔ mena nuŋ ofoŋofoŋ kei na baa mo ke kɔba keŋ fa ayematena ya.” Nyi beŋ yɔɔ ke na nafɔ baa nyiŋ tomyɛɛre kulutoo dokoloŋ kɔba lee ke man. ");
INSERT INTO ntr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gyudase keyako nombia kɛŋa nɛ, na ayematena wose man yaa ɔ na gyueŋ ya, mɔna ɔ yɛɛ ŋmɛɛlate e. Ŋon na see na be kɔba, te ɔ ne kyaa mo ŋaale desina ɔ wose. ");
INSERT INTO ntr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Keŋte Yesu yako e nyiaa, “Ɛ tina alo ŋon yela! Ɔ yɛɛ kei baa mo daa me kewuu. ");
INSERT INTO ntr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ayematena dɔɔ be kyaa ɛ gyaŋ debaŋ kamasɛ, mɔna maŋ dɔɔ mɔɔ gyae maa kyaa ɛ gyaŋ kekpaa ya.” ");
INSERT INTO ntr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Gyudatena burum kenyii nyi Yesu kyaa Bɛtani donɔɔ man nɛ, be gyuuwɔ botɔɔ. Na Yesu waageŋ dɔɔ te be gyuuwɔ botɔɔ ya, mɔna bɛɛ gyae baa naa Lasarose ŋon Yesu be gyuusu e lee yeŋ man nɛ mɔ. ");
INSERT INTO ntr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mena dɔɔ saese kegyiise baŋ mɔ gyae gbɛɛ baa ko Lasarose mɔ, ");
INSERT INTO ntr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nawolo nyi Yesu ke gyuusu e lee yeŋ man dɔɔ Gyudatena burum te bɛɛ wɔ te ba ke lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tɛɛ kena nɛ, balaŋ burum baŋ bɔɔ kɔŋ nyeekelɛɛwee kedi keŋ man nyiiwɔ nyi Yesu dɔŋ gbɛɛ ɔ ne kɔŋ Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mena dɔɔ be gyae bakɛɛna faareŋse gyu be kaa gyaŋee na e na bɛɛ fae yeesa nyiaa, “Lɛɛ daa. De Gbeŋgyoo Wurubuarɛ waa hiraa walaŋ ŋon ɔ ne kɔŋ ɔ yele man nɛ, na waa hiraa Iseraetena gyoo ŋon mɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu gyae afurum te ɔ kyaawɔ ɔ dɔɔ, ŋgba mena keŋ Wurubuarɛ nombia aŋmaraseŋ see be yako nɛ. Nombia ŋenaŋ yɛna nyiaa, ");
INSERT INTO ntr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ɛmɛɛ Gyerusalɛmtena, ɛ na yela ɛ wɔe ke lɔ ŋon ya. Ɛ kɛɛ, ɛ gyoo ne kɔŋ, ɔ kyaa afurum bu dɔɔ ɔ ne kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kewalaŋ keŋ nɛ, ɔ kaseela baŋ te nyii nombia kɛŋa man ya. Mɔna kenaŋ wɔle Wurubuarɛ ka lese Yesu gyoorobiiri wola nɛ te be tɔɔsewɔ nyiaa, nombia ŋan Wurubuarɛ nombia aŋmaraseŋ see be yako lee ɔ wose man nɛ kɔŋala mena nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Keŋte balaŋ burum baŋ be kpuɛ na Yesu, debaŋ keŋ ɔ be baake Lasarose lee yebɔɔ man te ɔ be gyuusu e lee yeŋ man nɛ, yaasee nombia kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Keŋ dɔɔ te balaŋ burum leewɔ donɔɔ man kɔŋ kaa gyaŋee na e nɛ, nawolo nyi be nyiiwɔ nyi ɔ yɛɛ mena gyakoloŋ nombii kei. ");
INSERT INTO ntr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Botɔɔ te Farasiitena baŋ yako dɔŋa nyiaa, “Ŋgba ɛ ne naa nyi da te tale yɛɛ kolo ya na? Ɛ kɛɛ! Balaŋ pou silana e.” ");
INSERT INTO ntr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na Girikitena baale mɔ kpuɛ na balaŋ baŋ bɔɔ gyu Gyerusalɛm be kaa som Wurubuarɛ Gyudatena nyeekelɛɛwee kedi keŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Be gyuuwɔ Filipo ŋon ɔ ba lee Bɛtesaida keŋ ke kyaa Galelia tɛɛle man nɛ gyaŋ ke yako e nyiaa, “Kegyia, dɛɛ gyae dɛɛ naa Yesu.” ");
INSERT INTO ntr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Keŋte Filipo mɔ gyuuwɔ ke yako Anderiase. Te be balaŋ bala gyuuwɔ keyako Yesu. ");
INSERT INTO ntr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Botɔɔ te Yesu tira nombia kɛŋa nɔɔ fa wɔ nyiaa, “Debaŋ keŋ te lii nyi baa lese maŋ Deniwalaŋ Bu ŋon gyoorobiiri keŋ wola. ");
INSERT INTO ntr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, nyi akpaa be ta mo wambelebii do bɔɔ man na ke ka yeŋ ya nɛ, na ke sɛɛ ke yɛɛ bii dokoloŋ. Mɔna nyi akpaa ba mo ke do bɔɔ man te ke da yem te ke de tuu na te kɛɛ see bia burum. ");
INSERT INTO ntr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Walaŋ kamasɛ ŋon ɔ ne gyae ŋon gbagba nyeedoŋ kela Wurubuarɛ nɛ, waa yeŋ leki. Mɔna walaŋ kamasɛ ŋon lee Wurubuarɛ nombia dɔɔ ɔ be famenɛ na ŋon gbagba nyeedoŋ ya nɛ, Wurubuarɛ waa fa e nyeedoŋ kekpaa.” ");
INSERT INTO ntr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Keŋte Yesu besewɔ yako nyiaa, “Walaŋ kamasɛ ŋon ɔ ne gyae nyi waa som maŋ nɛ, kaboena nyi waa sila maŋ. Na botɔɔ keŋ me kyaa na, ŋon mɔ ke nyiŋ kpu na maŋ. Walaŋ kamasɛ ŋon ɔ na som maŋ na, me kya mɔ waa lese ɔ yele.” ");
INSERT INTO ntr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Te Yesu besewɔ yako nyiaa, “Nɛnɛɛ dekɔkɔrɔkɔɔ te kyaŋ maŋ nideli, te sena yaa maa yako? ‘Maa yako nyi me kya, lese maŋ lee mena kaale dinaa kei man?’ Mɔna mena kaale kei dɔɔ te me kɔŋawɔ tɛɛle kei dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Keŋte Yesu fanewɔ nyiaa, “Me kya, lese n gyoorobiiri wola.” Te be nyii woya ŋaale kolosiwɔ lee adido nyiaa, “Me te wulaa lese me gyoorobiiri wola, te maa bese lese ke wola.” ");
INSERT INTO ntr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Balaŋ burum baŋ ba seŋɛɛ botɔɔ te bɔɔ nyii woya ŋan nɛ, be man baale yakowɔ nyiaa, “Ɔga faela” te baale mɔ yakowɔ nyi, “Wurubuarɛ kpilale ŋolo kolosi la na e lee adido.” ");
INSERT INTO ntr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Keŋte Yesu yako wɔ nyiaa, “Ɛmɛɛ dɔɔ te mena nɔɔwoya kɛŋa kɔŋawɔ, na maŋ dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nɛnɛɛ yɛna debaŋ keŋ Wurubuarɛ waa di balaŋ nombia tɛɛle kei dɔɔ. Nɛnɛɛ te Wurubuarɛ waa gegi ɔbɔnsam ŋon ɔ ne di gyoori tɛɛle kei dɔɔ nɛ lee ɔ gbeli keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mɔna maŋ dɔɔ nyi akpaa be gyina maŋ adido lee tɛɛle kei dɔɔ nɛ, maa wɔŋ walaŋ kamasɛ benaa ma wose.” ");
INSERT INTO ntr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ɔ kekolosi kei na wola yeŋ keŋ waa kaa yeŋ nɛ baa. ");
INSERT INTO ntr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Botɔɔ te balaŋ burum baŋ tiranɔɔ fa e nyiaa, “De kalawɔ lee da mmaraa tɔne man nyiaa, Nyeelɛɛre ŋon waa kyaa keŋ ɔ be gyae waa yeŋ ya. Te sena yaa n ne yako nyi kaboena nyi baa gyina Deniwalaŋ Bu ŋon adido? Amɔte yɛna Deniwalaŋ Bu kei?” ");
INSERT INTO ntr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Te Yesu tiranɔɔ fa wɔ nyiaa, “Keŋmaŋee keŋ nyiŋa ke kyaa ɛ gyaŋ nɛ ɛ ta ke man na ditiŋtɛɛ be nyiŋ futaa ŋon ya. Nawolo nyi walaŋ ŋon ɔ dɔŋɛɛ ditiŋtɛɛ man nɛ, ɔ ba gyeŋ botɔɔ keŋ ɔ ne gyu ya. ");
INSERT INTO ntr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Walaŋ ŋon ɔ ne fa keŋmaŋee nyiŋa ɔ kyaa ɛ gyaŋ nɛ, ɛ lɛɛ e di na ɛ kenyiŋ bese balaŋ baŋ be doo keŋmaŋee man.” Yesu kekolosi nombia kɛŋa taŋ nɛ, ɔ wɔŋa ɔ wose kekyaa yenaŋ daale keŋ bɔɔ ne naa e ya. ");
INSERT INTO ntr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu yɛɛ gyakoloŋ nombia burum be siaman, mɔna kɛŋa pou wɔle na be bɛe ba te lɛɛ e di ya. ");
INSERT INTO ntr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kei yela nombia ŋan Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya be yako nɛ kɔŋawɔ ampaŋ. Yesaya yakowɔ nyiaa, “De Gbeŋgyoo, amɔte lɛɛ na nombia ŋan dɔɔ yako nɛ di? Amɔte te de Gbeŋgyoo lese ɔ wɔɔle wola?” ");
INSERT INTO ntr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lee mena dɔɔ bɔɔ ne tale baa lɛɛ Wurubuarɛ nombia di ya ŋgba mena keŋ Yesaya be yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ɔ besewɔ yako nyiaa, “Wurubuarɛ te yɛlɛɛ be sia na bɔɔ nyiŋ naa ya, te ɔ tɔɔ ba agyueŋse na bɔɔ tale nyii kolo man ya. Na mena ya na nafɔ baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa kɔŋ me gyaŋ na maa kyɔ wɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya te kolosi nombia kɛŋa yakaa ya, mɔna ɔ wulaa naa Yesu gyoorobiiri keŋ dinɔɔ keŋ dɔɔ te ɔ kolosiwɔ lee ɔ wose man. ");
INSERT INTO ntr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nombia kɛŋa wɔle nɛ Gyudatena kegyiise burum lɛɛ Yesu di, mɔna Farasiitena baŋ dɔɔ ba te tale lese ba kelɛɛdi keŋ debɔɔ ya, nawolo nyi be yeewɔ nyi Farasiitena baŋ baa tɔɔ wɔ gbɛɛ nyi be na kɔŋ bɔ ɔsom deni man bela ya. ");
INSERT INTO ntr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Be ta lese ba kelɛɛdi keŋ debɔɔ ya nawolo nyi bɛɛ gyae bo nyi balaŋ ka lese ba yele kela Wurubuarɛ ka lese ba yele. ");
INSERT INTO ntr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Keŋte Yesu gyinaa ɔ nɔɔ kolosi nyiaa, “Nyaŋ ŋon n lɛɛ maŋ di nɛ, na maageŋ te n lɛɛwɔ di ya mɔna ŋon ɔ be kpila maŋ nɛ mɔ yaa n lɛɛwɔ di. ");
INSERT INTO ntr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nyaŋ walaŋ ŋon n naa maŋ na, n te naa walaŋ ŋon ɔ be kpila maŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me kɔŋae tɛɛle kei dɔɔ ŋgba keŋmaŋee nɛ na maa ŋmaŋee fa balaŋ. Nyaŋ ŋon n lɛɛ maŋ di na n be gyae n ke dɔɔ ditiŋtɛɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Walaŋ ŋon ɔ nyii me nombia te ɔ te lɛɛ ŋa do ya na, mɔɔ gyae maa di ɔ nombia ya. Nawolo nyi ma te kɔŋ me kaa di balaŋ nombia tɛɛle kei dɔɔ na maa bu wɔ fɔɔ ya, mɔna me kɔŋae me kaa lɛɛ ba nyee. ");
INSERT INTO ntr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nyaŋ ŋon n bɛɛ maŋ te n te lɛɛ me nombia ya na, nombiadiiri ŋolo kyaa keŋ waa di n nombia. Nɔɔwoya ŋan mɔɔ kolosi nɛ, ŋan te baa mo di n nombia wee ɔtomante keŋ man na baa bu neŋ fɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nawolo nyi ma te kolosi maŋ gbagba me doŋ man ya, mɔna me kya ŋon ɔ be kpila maŋ nɛ, ŋon yako na maŋ kpene keŋ maa yako na mena keŋ maa yako ke. ");
INSERT INTO ntr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te maŋ gyeŋ mɔ nyi kpene keŋ ɔ be yako daa nyi dɛɛ yɛɛ nɛ, keŋ ne faa na nyeedoŋ kekpaa keŋ. Mena dɔɔ kpene keŋ mɛɛ yako nɛ, yɛɛ keŋ me kya be yako maŋ nyi maa yako.” ");
INSERT INTO ntr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pɛ tɛɛ kena na Gyudatena kedi ba nyeekelɛɛwee keŋ nɛ, na Yesu wulaa gyeŋ nyi ɔ debaŋ te lii keŋ waa lee tɛɛle kei dɔɔ gyu ɔ kya gyaŋ. Mɔna mena keŋ ɔ ne gyae ɔ balaŋ baŋ be kyaa tɛɛle kei dɔɔ nɛ, mena te waa gyae be nombia kelii ɔto. ");
INSERT INTO ntr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na ɔ kaseela baŋ ke kyaa baa di be balinɔɔ weenɛɛ nɛ, na ɔbɔnsam taŋ ka mo nombiakumɛɛ do Simɔn bu Gyudase Isekarɔte nyeeman nyi waa lese Yesu fa na baa ko. ");
INSERT INTO ntr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu mɔ gyeŋ nyi ɔ kya ta mo kpene kamasɛ do ɔ nyiŋmaa man, te ɔ gyeŋ mɔ nyi ɔ lee Wurubuarɛ gyaŋ bo kɔŋ te ɔ gyaŋ te waa bese gyu. ");
INSERT INTO ntr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mena dɔɔ Yesu korowɔ lee weenɛɛ ŋan tɛɛ te ɔ kpee ɔ kegba wurikyim keŋ ɔ doona nɛ, te ɔ moo bɔroboa kpaŋ ɔ teŋa man. ");
INSERT INTO ntr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Keŋte ɔ toosi loŋ do tasa man te ɔ fiasɛɛ ɔ ne faafo ɔ kaseela baŋ nawɔɔ, te ɔ moo bɔroboa keŋ kpaŋɛɛ ɔ teŋa man nɛ feefo wɔ. ");
INSERT INTO ntr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ɔ kelii Simɔn Pita gyaŋ nɛ Pita bɔɔse e nyiaa, “Me Gbeŋgyoo, nyaŋ ne gyaela n kefaafo me nawɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Te Yesu tiranɔɔ fa e nyiaa, “Kpene keŋ mɛɛ yɛɛ nɛ n be gyae n ke nyii ke man debokeiman ya, mɔna nyaŋ kaa nyii ke man wɔle wɔle.” ");
INSERT INTO ntr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Keŋte Pita yako e nyiaa, “Koa, mɔɔ sɛɛ na n ke faafo me nawɔɔ korakora ya.” Botɔɔ te Yesu tiranɔɔ fa e nyiaa, “Akpaa ma te faafo n nawɔɔ ya na, daa na neŋ be doo daale man ya.” ");
INSERT INTO ntr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Te Simɔn Pita yako e nyiaa, “Me Gbeŋgyoo, akpaa mena na na faafo me nawɔɔ kaageŋ ya, mɔna faafo me nyiŋmaase na ma nyee mɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Te Yesu yako e nyiaa, “Walaŋ ŋon ɔ be sɔɔ nɛ ɔ wose pou ta lee. Ɔ be kaboena nyi waa sɔ bela ya. Kaboena bo nyi waa faafo ɔ nawɔɔ kaageŋ. Ɛ popou wose ta lee, mɔna walaŋ dokoloŋ wose danaana ayimɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nawolo nyi na Yesu gyeŋ walaŋ ŋon waa lese e fa, mena dɔɔ te ɔ yakowɔ nyi “Walaŋ dokoloŋ wose danaana ayimɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu kefaafo be nawɔɔ taŋ nɛ, ɔ moo ɔ kegba wurikyim keŋ do bela te ɔ gyuuwɔ kekyaa ɔ dekyae man. Te ɔ bɔɔse wɔ nyiaa, “Ɛ ne nyii kpene keŋ mɔɔ yɛɛ fa ŋon nɛ man? ");
INSERT INTO ntr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɛ ne baake maŋ nyi ɛ wolale na ɛ Gbeŋgyoo. Dei ŋgba ɛ ne baake maŋ mena nɛ, nawolo nyi ŋe kaboena maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Te akpaa maŋ ɛ Gbeŋgyoo na ɛ wolale te faafo ɛ nawɔɔ nɛ, mena te kaboena nyi ɛmɛɛ mɔ yaa faafo dɔŋa nawɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Me yɛɛ kei baa wola ŋon na ɛmɛɛ mɔ kenyiŋ yɛɛ fa dɔŋa ŋgba mena keŋ maŋ be yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Anokoare yaa mɛɛ yako ŋon nyiaa, gbeŋi bɛɛ kela ɔ gbeŋgyoo ya, te kpilale mɔ bɛɛ kela walaŋ ŋon ɔ be kpila e nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nɛnɛɛ keŋ ɛ ba gyeŋ nombia kɛŋa nɛ, akpaa ɛ di ŋe dɔɔ na gyoŋ gyae ke doo ɛ man. ");
INSERT INTO ntr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na ɛ popou yaa me dana ya, nawolo nyi ma gyeŋ balaŋ baŋ mɔɔ lese. Mɔna kaboena nyi Wurubuarɛ nombia ŋan bɔɔ ŋmarase see nɛ dɛɛ kɔŋ mena. Be ŋmarasewɔ see nyiaa, walaŋ ŋon daa na e na do nyiŋmaa di nɛ, ta koro seŋ me dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mena dɔɔ me wulaa mɛɛ yako ŋon nombii kei baa pɛna ka ke kɔŋ, na ka de kɔŋ na ɛ ke lɛɛ di nyiaa, maŋ yɛna ŋon ɔ kyaa pɛte be yɛɛ kpene kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Anokoare yaa mɛɛ yako ŋon nyiaa, walaŋ ŋon ɔ lɛɛ walaŋ kamasɛ ŋon maa kpila nɛ na maŋ yaa ɔ lɛɛwɔ, te walaŋ ŋon ɔ lɛɛ maŋ na ɔ te lɛɛ walaŋ ŋon ɔ be kpila maŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu keyako nombia kɛŋa taŋ nɛ, nombia takaa e ɔ konɔɔ man nideli te ɔ kolosiwɔ balaŋ man keŋ ɔ ta mo kolo weese ya nyi, “Ɛ man ŋolo waa lese maŋ fa na baa ko.” ");
INSERT INTO ntr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Botɔɔ te ɔ kaseela baŋ wose yeŋawɔ te be kɛɛ dɔŋa dokoloŋ dokoloŋ, nawolo nyi be ta gyeŋ ŋon ɔ dana ya. ");
INSERT INTO ntr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ɔ kaseela baŋ man ŋolo ŋon Yesu ne gyae nideli nɛ kyaa la benaa e, ");
INSERT INTO ntr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","mena dɔɔ Simɔn Pita fatee e te ɔ yakowɔ nyi, “Bɔɔse e walaŋ ŋon ɔ dana.” ");
INSERT INTO ntr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mena dɔɔ kaseele ŋon tuuwɔ benaa na Yesu te ɔ bɔɔse e nyiaa, “Me Gbeŋgyoo, amɔte yaa n dana?” ");
INSERT INTO ntr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Te Yesu tiranɔɔ nyiaa, “Walaŋ ŋon maa kara bodobodo mo nyoko tasa kei man fa e nɛ, na ŋon yaa me dana.” Keŋte ɔ kara bodobodo keŋ te ɔ moowɔ nyoko tasa keŋ man te ɔ moowɔ fa Simɔn bu Gyudase Isekarɔte ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gyudase kedi bodobodo keŋ pɛ te ɔbɔnsam gyoo ɔ man. Te Yesu yako e nyi, “Kpene keŋ n ne gyae n keyɛɛ nɛ, yɛɛ ke bileŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mɔna baŋ be kyaa weenɛɛ ŋan tɛɛ nɛ, be ta gyeŋ kpene keŋ dɔɔ te Yesu be yako e mena ya. ");
INSERT INTO ntr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na Gyudase ne kɛɛ na be kɔba dɔɔ, mena dɔɔ kaseela baŋ baale gyueŋwɔ nyi Yesu yako e baa nyi waa gyu ke lɛɛ weenɛɛ ŋan baa mo gyu kedi ba nyeekelɛɛwee kedi keŋ man nɛ, yaa waa lese kɔba fa ayematena. ");
INSERT INTO ntr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mena dɔɔ Gyudase ka betaa lɛɛ bodobodo keŋ di pɛ, te ɔ leewɔ bileŋ. Na tɛɛ te yuu. ");
INSERT INTO ntr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gyudase kalee laŋ nɛ Yesu yakowɔ nyiaa, “Nɛnɛɛ te Wurubuarɛ waa lese maŋ Deniwalaŋ Bu ŋon gyoorobiiri debɔɔ. Waa ta me dɔɔ yela balaŋ kena ɔ gyoorobiiri keŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Keŋte Yesu besewɔ yako nyi, “Akpaa Wurubuarɛ waa ta me dɔɔ lese ɔ gyoorobiiri wola na, mena mɔ te waa ta ŋon gbagba dɔɔ lese me gyoorobiiri wola. Be gyae ke kyare pɛte waa yɛɛ nombii kei ya. ");
INSERT INTO ntr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Me bia mɔɔ gyae maa kyaa ɛ gyaŋ kyare ya. Ɛ ke kɛo maŋ, mɔna ŋgba mena keŋ mɔɔ yako Gyudatena baŋ nɛ, mena yaa mɛɛ yako ŋon debokeiman nyiaa ‘Botɔɔ keŋ mee gyu nɛ ɛ be gyae ɛ ke tale kɔŋ botɔɔ ya.’ ");
INSERT INTO ntr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mɛɛ fa ŋon mmaraa wɔle nyiaa, ɛ gyae dɔŋa. Ŋgba mena keŋ maŋ be gyae ŋon nɛ, ɛmɛɛ mɔ ɛ gyae dɔŋa mena. ");
INSERT INTO ntr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Akpaa ɛ ne gyae dɔŋa na, walaŋ kamasɛ waa naa nyi ɛ yɛɛ me kaseelawɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Botɔɔ te Simɔn Pita bɔɔse e nyiaa, “Me Gbeŋgyoo, aleŋ yaa n ne gyuu?” Te Yesu tiranɔɔ fa e nyiaa, “Botɔɔ keŋ mee gyu nɛ, n be gyae n ke tale sila maŋ debokeiman ya, mɔna nyaŋ kaa sila maŋ wɔle wɔle.” ");
INSERT INTO ntr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Te Pita bɔɔse e nyiaa, “Me Gbeŋgyoo, weera dɔɔ te mɔɔ tale sila neŋ debaŋ kei ya? Ma te sɛɛ nyi maa yeŋ fa neŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Te Yesu tiranɔɔ nyiaa, “N ne lɛɛdi nyi nyaŋ ke tale yeŋ fa maŋ? Ampaŋ yaa mɛɛ yako neŋ nyi pɛ kegyim kelɔ woya nɛ, nyaŋ ke bɛɛ betabotooro nyi n ba gyeŋ maŋ korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Keŋte Yesu yako ɔ kaseela baŋ nyiaa, “Ɛ na yeli ɛ wɔe ke lɔ ŋon ya. Ɛ lɛɛ Wurubuarɛ di na ɛ ke lɛɛ maŋ mɔ di. ");
INSERT INTO ntr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Denɛɛ burum doo me kya ŋon dekpaŋalaŋ man. Akpaa te yɛɛ mena ya na nafɔ mɔɔ yako nyi mee gyu me kaa desina akyaese see ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Akpaa me gyu ke desina botɔɔ taŋ na maa bese kɔŋ kaa mo ŋon gyu me gyaŋ, na botɔɔ keŋ me kyaa na ɛmɛɛ mɔ ke kyaa botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Botɔɔ keŋ mee gyu nɛ ɛ gyeŋ ke gbɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Botɔɔ te Tomase bɔɔse e nyiaa, “Me Gbeŋgyoo, dɔɔ gyeŋ botɔɔ keŋ ne gyu ya, sena te dɛɛ yɛɛ na dɛɛ gyeŋ ke gbɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Keŋte Yesu tiranɔɔ fa e nyiaa, “Maŋ yɛna gbɛɛ keŋ na anokoare keŋ na nyeedoŋ keŋ. Ŋolo be kyaa nyi waa tale gyu me kya ŋon gyaŋ keŋ ɔ te tɛɛ me dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nyi akpaa yeŋ gyeŋ maŋ na nafɔ ɛ ka gyeŋ me kya ŋon mɔ. Lee gyɛŋ ne gyu nɛ, ɛ ta gyeŋ e te ɛ ne naa e mɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Keŋte Filipo mɔ yakowɔ nyiaa, “De Gbeŋgyoo, wola daa n kya ŋon. Akpaa n wola daa n kya ŋon na, keŋ kaageŋ koraŋ dei fa daa.” ");
INSERT INTO ntr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Te Yesu mɔ bɔɔse e nyiaa, “Filipo, mena dɔɔ leenaŋ ma ke kyaa ɛ gyaŋ kei nɛ, na ɛ ba gyeŋ maŋ yee? Walaŋ ŋon ɔ naa maŋ na, ɔ te naa me kya ŋon mɔ. Sena yaa n ke tale yako maŋ nyi, ‘Maa wola ŋon me kya ŋon bela?’ ");
INSERT INTO ntr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipo n bɛɛ lɛɛ di nyi daa na me kya ŋon yɛɛ dokoloŋ yee? Na maŋ gbagba me baam dɔɔ te mee kolosi nombia kɛŋa ya. Mɔna me kya ŋon ɔ doo me man nɛ, ŋon ne tɛɛ la me dɔɔ yɛɛ ɔ tom. ");
INSERT INTO ntr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Me yako nyi daa na me kya ŋon yɛɛ dokoloŋ na, ɛ lɛɛ maŋ di. Akpaa nyi ɛ be lɛɛ maŋ di koraŋ ya nɛ, ɛ kɛɛ gyakoloŋ nombia ŋan mɛɛ yɛɛ nɛ na ɛ ke lɛɛ maŋ di. ");
INSERT INTO ntr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mɛɛ yako ŋon ɛ ke nyii nyiaa, walaŋ kamasɛ ŋon waa lɛɛ maŋ di nɛ, waa yɛɛ abɔɔ ŋan mɛɛ yɛɛ nɛ, te waa yɛɛ gyakoloŋ nombia kela ŋan mɛɛ yɛɛ nɛ. Nawolo nyi mee gyu me kya ŋon gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te kpene kamasɛ keŋ ɛ ke bɔɔse lee ma yele man na, me kya waa yɛɛ fa ŋon na maŋ ɔ bu ŋon ke yela baa lese ɔ yele. ");
INSERT INTO ntr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Akpaa ɛ bɔɔse kpene kamasɛ ma yele man na, maa yɛɛ fa ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Akpaa ɛ ne gyae maŋ na, nafɔ ɛ ke di maŋ mmaraase ŋan dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Te maa waase me kya ŋon na waa fa ŋon walaŋ ŋon waa yako do ŋon, na ɔ kaa kyaa me nawɔɔ man kekpaakekpaa. Ŋon yɛna ɔ feliŋ ŋon waa lese Wurubuarɛ dinɔɔ wola nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Balaŋ baŋ be loo gyakaa tɛɛle kei abɔɔ dɔɔ nɛ, bɔɔ gyae baa tale lɛɛ Wurubuarɛ feliŋ ŋon ya. Nawolo nyi bɔɔ ne naa e ya te bɔɔ gyeŋ e mɔ ya. Mɔna ɛmɛɛ dɔɔ ɛ gyeŋ e, nawolo nyi ɔ kyaa na ŋon te ɔ doo ɛ man. ");
INSERT INTO ntr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Debaŋ keŋ me lam nɛ, mɔɔ gyae maa tina ŋon yela ŋgba yoyolobiise nɛ ya, mɔna maa bese kɔŋ ɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Teka kyomii balaŋ be gyae baa tekaa naa maŋ bela ya, mɔna ɛmɛɛ dɔɔ ɛ kena maŋ. Keŋ me dana nyeedoŋ dɔɔ ɛmɛɛ mɔ ɛ ke nyiŋ nyeedoŋ. ");
INSERT INTO ntr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Debaŋ kenaŋ de lii na ɛ kena nyi daa na me kya ŋon kyaa la, te ɛmɛɛ mɔ ɛ kyaa na maŋ te maŋ mɔ me kyaa na ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Walaŋ kamasɛ ŋon ɔ lɛɛ maŋ mmaraase ŋan do te ɔ di ŋe dɔɔ na, ŋon ne gyae na me nombia ta me kya ŋon mɔ waa gyae ŋon ɔ ne gyae me nombia nɛ nombia. Maŋ mɔ maa gyae ɔ nombia na maa lese ma wose wola e.” ");
INSERT INTO ntr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Botɔɔ te Gyudase (na Gyudase Isekarɔte ŋon ɔ ba lese Yesu fa nɛ ya) bɔɔse e nyiaa, “Me Gbeŋgyoo, sena te gyae ke tale kɔŋ nyi nyaŋ ka lese n wose wola daa daageŋ, te n be gyae n ka lese wola balaŋ pou ya?” ");
INSERT INTO ntr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Keŋte Yesu tiranɔɔ fa e nyiaa, “Akpaa ŋolo ne gyae maŋ na, waa lɛɛ me nombia ŋan mɛɛ wolo nɛ do, na daa na me kya ke gyae ɔ nombia na de kaa kyaa ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Walaŋ kamasɛ ŋon ɔ bɛɛ gyae me nombia ya na, ɔ bee di me nombia ŋan mɛɛ wolo nɛ dɔɔ ya. Nombia ŋan mɛɛ yako ŋon nɛ ta lee me gyaŋ ya mɔna ŋa lee me kya ŋon ɔ be kpila maŋ nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Debaŋ keŋ me sɛɛ me kyaa ɛ gyaŋ nɛ yaa mɛɛ yako ŋon nombia kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Walaŋ ŋon waa yako do ŋon nɛ, ŋon yɛna feliŋ ŋon me kya waa kpila ma yele man nɛ. Waa kaa wola ŋon abɔɔ pou, na waa tɔɔse ŋon abɔɔ ŋan pou mɔɔ yako ŋon nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ma wosefɛɛreŋ dɛɛ kyaa na ŋon, mɛɛ fa ŋon wosefɛɛreŋ. Na wosefɛɛreŋ keŋ balaŋ ne nyim tɛɛle kei dɔɔ nɛ yaa mɛɛ fa ŋon ya, mɔna ma wosefɛɛreŋ gbagba yaa mɛɛ fa ŋon. Ɛ na yele ɛ wɔe ke lɔ ŋon ya, te ɛ na yele gyakoloŋ mɔ ke kyaŋ ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Me yako ŋon nyi, mee gyu mɔna maa bese kɔŋ ɛ gyaŋ. Akpaa nyi yeŋ ne gyae me nombia na nafɔ gyae ke yɛɛ ŋon gyoŋ nyi mee gyu me kya ŋon gyaŋ, nawolo nyi ɔ kela maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Me wulaa mɛɛ yako nombia kɛŋa pou pɛna ŋa ke kɔŋ, na akpaa nyi ŋa de kɔŋ na, ɛ ke nyiŋ lɛɛ maŋ di. ");
INSERT INTO ntr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mɔɔ gyae maa tekaa kolosi na ŋon burum bela ya, nawolo nyi ɔbɔnsam ŋon ɔ ne di doŋ tɛɛle kei dɔɔ nɛ ne kɔŋ. Ɔ be taŋ doŋ me dɔɔ berɛ ya, ");
INSERT INTO ntr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mɔna mɛɛ gyae balaŋ pou ka gyeŋ nyi mɛɛ gyae me kya ŋon nombia, te kpene kamasɛ keŋ ɔ yako maŋ nyi maa yɛɛ na keŋ te mɛɛ yɛɛ. Ɛ koro dɛɛ lee kɛbo.” ");
INSERT INTO ntr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Keŋte Yesu besewɔ yako ɔ kaseela baŋ nyiaa, “Maŋ yɛna daŋ keŋ gbagba, te me kya yɛna wɔɔfarale ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tombii kamasɛ keŋ doo me man te ke bɛɛ see bia ya nɛ waa kara ke leki. Mɔna tombii kamasɛ keŋ doo me man te kɛɛ se bia na, waa kpaase ke na ke kenyiŋ se bia burum. ");
INSERT INTO ntr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lee nombia ma ayakoŋ ŋon kɛŋa dɔɔ nɛ, ŋe taŋ ke yela ɛ wose ta lee keŋ ayimɛɛ be doo ɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ɛ doo me maŋ, na maŋ mɔ ke doo ɛ man. Tombii kamasɛ be kyaa nyi ke gyae ke tale se bia ka wose dɔɔ, keŋ kɔɔ towaa na ke daŋ ya. Mena mɔ yaa ɛmɛɛ mɔ be gyae ɛ ke tale yɛɛ kolo ɛ wose dɔɔ keŋ nyi ɛ be doo me man ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Maŋ yɛna daŋ keŋ te ɛmɛɛ yɛna ke tombia ŋan. Walaŋ kamasɛ ŋon ɔ doo me man, te maŋ mɔ doo ɔ man nɛ, waa se bia burum. Nawolo nyi ɛ be gyae ɛ ke tale yɛɛ kolo ɛ wose dɔɔ keŋ mɔɔ kpuɛ na ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Walaŋ kamasɛ ŋon ɔ be doo me man ya nɛ, ɔ yɛɛ ŋgba tombii keŋ bɔɔ kare leki te kɔɔ wolo nɛ. Baa yilaa mena tombia ŋenaŋ bo na baa mo ŋa do boalaŋ man na ŋa ke kpa. ");
INSERT INTO ntr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nyi akpaa ɛ sɛɛ doo me man te me nombia ŋan mɔ de doo ɛ man nɛ, kpene kamasɛ keŋ ɛ ke bɔɔse na maa yɛɛ fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Akpaa ɛ se bia burum nɛ, ke gyae ke yela baa lese me kya ŋon yele. Kei gyae ke yela balaŋ ka gyeŋ nyi ɛ yɛɛ me kaseelawɔ. ");
INSERT INTO ntr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ŋgba mena keŋ me kya ŋon ne gyae me nombia nɛ, mena ke yaa maŋ mɔ ne gyae ɛ nombia. Mena dɔɔ ɛ yela maa gyae ŋon kelii ɔto. ");
INSERT INTO ntr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nyi akpaa ɛ di ma mmaraase ŋan dɔɔ nɛ, maa gyae ɛ nombia kelii ɔto ŋgba mena keŋ mɔɔ di me kya ŋon mmaraase dɔɔ te ɔ ne gyae me nombia nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mɛɛ yako mena nombia kɛŋa baa na ke yela ma gyoŋ keŋ ke doo ɛ man, na ɛ ke nyiŋ di gyoŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mmaraa keŋ mɛɛ fa ŋon yɛna nyiaa, ɛ gyae dɔŋa ŋgba mena keŋ mɔɔ gyae ŋon nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Walaŋ kegyae daale be kyaa keŋ ka kela kegyae keŋ ŋolo waa gyae ɔ gyoona na waa yeŋ fa wɔ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyi akpaa ɛ yɛɛ kpene keŋ mɔɔ yako ŋon nyi yaa yɛɛ nɛ, mena na ɛ yɛɛ me gyoona gbagbawɔ. ");
INSERT INTO ntr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mɔɔ tekaa baake ŋon me tewulɛɛ bela ya, nawolo nyi tobaale ba gyeŋ ɔ gbeŋgyoo nyeeman nombia ya. Mɔna mɛɛ baake ŋon me gyoona, nawolo nyi ma te yako ŋon kpene kamasɛ keŋ me kya be yako maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na ɛmɛɛ lese na maŋ ya, mɔna maŋ lese na ŋon. Ma lese ŋon bo nyi yaa yɛɛ nombia kpaakpaa ŋan ŋe dana tɔnɔɔ debaŋ kamasɛ. Ɛ yɛɛ mena na me kya waa fa ŋon kpene kamasɛ keŋ ɛ ka sola e lee ma yele man. ");
INSERT INTO ntr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mmaraa keŋ mɛɛ fa ŋon yɛna nyi, ‘Ɛ gyae dɔŋa.’ ” ");
INSERT INTO ntr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Akpaa tɛɛle kei dɔɔ balaŋ ne kɔla ŋon nɛ, ɛ tɔɔse nyi mena te be taŋgbɛɛwɔ kɔla maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nyi yeŋ yɛɛ ŋgba balaŋ baŋ be kyaa tɛɛle kei dɔɔ nɛ, nafɔ baa gyae ŋon ŋgba baŋ gbagba be balaŋ nɛ. Mɔna kpene keŋ dɔɔ te bɛɛ kɔla ŋon yɛna nyi me ta lese ŋon lee be man, te ɛ ba tekaa kpuɛ na wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ɛ tɔɔse nɔɔwoya ŋan mɔɔ yako ŋon nɛ nyi, “Tobaale kamasɛ ba kela ɔ gbeŋgyoo ya. Nyi be naase maŋ diyem nɛ, mena ke te baa naase ɛmɛɛ mɔ diyem. Nyi akpaa be lɛɛ me kawola keŋ di na, mena mɔ te baa lɛɛ ɛmɛɛ mɔ wui di. ");
INSERT INTO ntr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mɔna lee maŋ dɔɔ baa mo mena nombia kɛŋa pou yɛɛ ŋon, nawolo nyi bɔɔ gyeŋ walaŋ ŋon ɔ be kpila maŋ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Akpaa meŋ te kɔŋ kaa kolosi fa wɔ ya nɛ, nafɔ bɔɔ gyae baa di fɔɔ be dukum keyɛɛ man ya. Mɔna nɛnɛɛ nyi be yɛɛ dukum na, bɔɔ gyae baa tale yako nyi be ta gyem bo te be yɛɛwɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nyaŋ ŋon n ne kɔla maŋ na, n ne kɔla me kya ŋon mɔ. ");
INSERT INTO ntr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Akpaa meŋ te yɛɛ tomse ŋan ŋolo te yɛɛ ta see be man ya nɛ, nafɔ beŋ te di fɔɔ be dukum keyɛɛ man ya. Mɔna nɛnɛɛ ba te naa gyakoloŋ nombia kɛŋa pou mɔna bɛɛ kɔla daa na me kya ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kei yela kpene keŋ bɔɔ ŋmarase see ba mmaraa tɔne man nɛ kɔŋawɔ mena. Be ŋmarasewɔ nyiaa, ‘Be kɔla maŋ bo yakaa.’ ");
INSERT INTO ntr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mɔna maa yela Wurubuarɛ feliŋ ŋon ka lee me kya ŋon gyaŋ kɔŋ na ɔ kaa kyaa na ŋon. Ŋon ne gyae la waa yako do ŋon na waa lese anokoare keŋ doo Wurubuarɛ man nɛ wola ŋon, na waa di adansɛɛ lee ma wose man. ");
INSERT INTO ntr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te ɛmɛɛ mɔ ɛ di adansɛɛ lee ma wose man, nawolo nyi lee kewalaŋ keŋ pou na ɛ kyaa me gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mɛɛ yako mena nombia kɛŋa pou baa na ɛ be nyiŋ tina ɛ kelɛɛdi keŋ yela ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gyudatena kegyiise baa tɔ ŋon nyi ɛ na kɔŋ bɔ ɔsom denɛɛ man donɔɔ kamasɛ man ya. Debaŋ daale gyae kelii nɛ, akpaa walaŋ da ko ɛ man ŋolo na waa yako nyi Wurubuarɛ ɔsom nombia dɔɔ te ɔ koo ŋon. Na waa yako nyi ɔ yɛɛ deeli baa fa Wurubuarɛ. ");
INSERT INTO ntr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Baa mo mena nombia kɛŋa yɛɛ ŋon nawolo nyi be ta gyeŋa ta daa na me kya ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mɛɛ wulaa yako ŋon nombia kɛŋa baa na akpaa debaŋ kenaŋ de lii na, ɛ ke tɔɔse nyi me wulaa yako ŋon nombia kɛŋa na ɛ ke nyiŋ do ogo.” ");
INSERT INTO ntr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ma te yako ŋon nombia kɛŋa lee kewalaŋ keŋ ya, nawolo nyi na maŋ gbagba kyaa ɛ gyaŋ dɔɔ. Mɔna nɛnɛɛ yaa mɛɛ yako ŋon nawolo nyi mee gyu ŋon ɔ be kpila maŋ nɛ gyaŋ, mɔna ɛ man ŋolo te tale bɔɔse maŋ nyi ‘Aleŋ yaa n ne gyu ya.’ ");
INSERT INTO ntr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Te nɛnɛɛ keŋ mɔɔ yako ŋon na, te ɛ gyoo kayeyɛɛ? ");
INSERT INTO ntr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mɔna mɛɛ yako ŋon nombii anokoare baa nyiaa, ɛ deeli dɔɔ te mee gyu nɛ. Nawolo nyi akpaa me te gyu ya na, Wurubuarɛ feliŋ ŋon waa yako do ŋon nɛ be gyae waa kɔŋ ɛ gyaŋ ya. Mɔna akpaa me gyu na, maa kpila e na waa kɔŋ ɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tɛɛle kei balaŋ kpa ba gyeŋ kpene keŋ yɛɛ dukum ke, te ba gyeŋ kpene keŋ doo na ke gbɛɛ, te ba gyeŋ Wurubuarɛ nombia kedi keŋ wose man nombia mɔ. Mɔna akpaa ɔ kɔŋ na waa yela baa gyeŋ nyi be nombia be dei ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bɔɔ gyeŋ kpene keŋ yɛɛ dukum ke ya, nawolo nyi ba te lɛɛ maŋ di ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Te bɔɔ gyeŋ kpene keŋ mɔ doo na ke gbɛɛ ya, nawolo nyi mɛɛ bese mee gyu me kya ŋon gyaŋ te ɛ be gyae ɛ ka tekaa naa maŋ bela ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bɔɔ gyeŋ Wurubuarɛ nombia kedi keŋ wose man daale ya, nawolo nyi ɔbɔnsam ŋon ɔ ne di tɛɛle kei dɔɔ gyoori nɛ, Wurubuarɛ te wulaa di ɔ nombia bu e fɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Me dana nombia burum maa yako ŋon, mɔna debokeiman man nɛ ŋe dana yuŋ kela ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mɔna akpaa Wurubuarɛ feliŋ ŋon ɔ bee di dekara ya nɛ de kɔŋ na, waa lese nombia ŋan ŋe doo na ŋe gbɛɛ pou nɛ wola ŋon. Nawolo nyi na ŋon gbagba ɔ baam dɔɔ te ɔ ne kolosi ya, mɔna nombia ŋan pou ɔ be nyii nɛ yaa ɔ ne kolosi na waa lese nombia ŋan pou gyae ke kɔŋ wee daale nɛ wola ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wurubuarɛ feliŋ ŋon waa yela balaŋ kena me gyoorobiiri, nawolo nyi waa lese kpene kamasɛ keŋ me dana maa yako ŋon nɛ wola ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kpene kamasɛ keŋ me kya dana na ke yɛɛ me wui, mena dɔɔ te mɛɛ yako ŋon nyi Wurubuarɛ feliŋ ŋon waa lese kpene kamasɛ keŋ me dana maa yako ŋon nɛ wola ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Keŋte Yesu besewɔ yako nyiaa, “Teka kyomii ɛ be gyae ɛ kena maŋ bela ya, mɔna kenaŋ wɔle nɛ be gyae ke kyare ya, ɛ ka bese naa maŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Botɔɔ te ɔ kaseela baŋ baale bɔɔse dɔŋa nyiaa, “Sena yaa balee kei ne yako baa, ɔ kpa ‘Teka kyomii ɛ be gyae ɛ kena maŋ bela ya, te kenaŋ wɔle na be gyae ke kyare ya na, ɛ ka bese naa maŋ.’ Nawolo nyi mee gyu me kya gyaŋ dɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Keŋte ba besewɔ bɔɔse dɔŋa nyiaa, “ ‘Teka kyomii’ kei mɔ na wolo baa sena? Dɔɔ ne nyii nombia kɛŋa man ya.” ");
INSERT INTO ntr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na Yesu gyeŋ nyi bɛɛ gyae baa bɔɔse e nombia kɛŋa man, mena dɔɔ ɔ bɔɔse wɔ nyiaa, “Keŋ mɔɔ yako ŋon nyi, ‘Teka kyomii ɛ be gyae ɛ kena maŋ bela ya, mɔna kenaŋ wɔle na be gyae ke kyare ya ɛ ka bese naa maŋ’ nɛ yaa ɛ ne bɔɔse dɔŋa nɛ? ");
INSERT INTO ntr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ampaŋ yaa mɛɛ yako ŋon ɛ ke nyii nyiaa, ɛ ke wii na ɛ ka yeyɛɛ mɔna balaŋ baŋ be loo gyakaa tɛɛle kei abɔɔ dɔɔ nɛ baa di gyoŋ. Ɛmɛɛ ɛ ka yeyɛɛ, mɔna ɛ kayeyɛɛ keŋ gyae kaa bese gyoŋ kedi. ");
INSERT INTO ntr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Akpaa alo na doŋee na ɔ na yeyɛɛ, nawolo nyi ɔ debaŋ te lii. Mɔna akpaa ɔ lola bu ŋon na, ne yɛɛ e gyoŋ nyi ɔ ta lola bu kɔŋ tɛɛle kei dɔɔ. Mena gyoŋ kei ne yele ɔ ne wolee ɔ kaale keŋ ɔ be naa nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mena ke mɔ yaa doo fa ŋon. Debaŋ kei na ɛ na yeyɛɛ, mɔna maa bese kɔŋ ɛ gyaŋ na ɛ wose ke fɛɛ ŋon, na ɛ ke di gyoŋ. Te ŋolo be gyae waa tale lese gyoŋ kenaŋ lee ɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mena wee kenaŋ dɔɔ nɛ, ɛ be gyae ɛ ke bɔɔse maŋ daale ya. Mɛɛ yako ŋon ɛ ke nyii nyiaa, kpene kamasɛ keŋ ɛ ka sola me kya ŋon ma yele man na, waa mo fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kaalii na gyeŋ kei nɛ, ɛ ta sola ta kolo ma yele man ya. Ɛ sola na ɛ ke nyiŋ, na ke yɛɛ ŋon gyoŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mɛɛ yako ŋon ɛ ke nyii nyiaa, debaŋ daale gyae kelii na mɔɔ gyae maa tekaa kolosi na ŋon aduya man bela ya. Mɔna maa toro me kya ŋon nombia yako ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Debaŋ kenaŋ de lii nɛ, ɛ ka sola e ma yele man. Mɔna te yɛɛ nyi maa seŋ ɛ nawɔɔ man na maa sola me kya ŋon fa ŋon ya. ");
INSERT INTO ntr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nawolo nyi me kya ŋon gbagba ne gyae ŋon, keŋ ɛ ne gyae maŋ te ɛ be lɛɛ di nyi ma lee Wurubuarɛ gyaŋ nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Daa na me kya kyaa la pɛte ma lee ɔ gyaŋ kɔŋ tɛɛle kei dɔɔ, te nɛnɛɛ mɛɛ bese mɛɛ lee tɛɛle kei dɔɔ mee gyu me kya ŋonaŋ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Botɔɔ te ɔ kaseela baŋ yako e nyiaa, “Nɛnɛɛ dɔɔ n bɛɛ kolosi aduya man fa daa bela ya. N ta lese nombia ŋan man wola daa. ");
INSERT INTO ntr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nɛnɛɛ da te naa nyi n gyeŋ kpene kamasɛ, te tekaboena nyi ŋolo dɛɛ bɔɔse neŋ nombia daale bela ya. Kei te yeli da te naa nyi n lee Wurubuarɛ gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Keŋte Yesu bɔɔse wɔ nyiaa, “Nɛnɛɛ ɛ ne lɛɛ maŋ di? ");
INSERT INTO ntr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Debaŋ keŋ ne kɔŋ te ke taŋ kekɔŋ, keŋ ɛ popou ɛ ke yaasee. Walaŋ kamasɛ waa gyu ɔ dɛɛ tina maŋ yela na ke ka maageŋ. Mɔna na maageŋ kyaa la ya, nawolo nyi me kya ŋon kpuɛ na maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mɛɛ yako nombia kɛŋa baa, na ɛ ke ta me dɔɔ nyiŋ wosefɛɛreŋ. Balaŋ baa yela ɛ kena diyem nideli tɛɛle kei dɔɔ, mɔna ɛ nyiŋ konɔɔ na ɛ ka seŋ keŋkeŋ nawolo nyi me te di tɛɛle kei dɔɔ!” ");
INSERT INTO ntr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ke yako nombia kɛŋa taŋ nɛ, ɔ gyinaa ɔ sia kɛɛ adido te ɔ fanewɔ nyiaa, “Taata, debaŋ keŋ te lii. Lese maŋ n bu ŋon yele na maŋ mɔ ka lese n yele. ");
INSERT INTO ntr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nawolo nyi n te fa maŋ doŋ balaŋ pou dɔɔ, nyi maa fa baŋ pou n ba mo do maŋ me nyiŋmaa man nɛ nyeedoŋ kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nyeedoŋ kekpaa kenaŋ yɛna nyiaa, balaŋ pou baa gyeŋ neŋ na baa gyeŋ nyi nyaŋ nyaageŋ yɛna Wurubuarɛ ŋon n ne di anokoare. Na baa bese gyeŋ maŋ Yesu Kristo ŋon n be kpili nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Me ta lese n yele tɛɛle kei dɔɔ, nawolo nyi ma te yɛɛ tom keŋ n ba fa maŋ nɛ kelii kɔ ɔto. ");
INSERT INTO ntr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taata, nɛnɛɛ lese me gyoorobiiri keŋ me dana n siaman pɛte n be yɛɛ kpene kamasɛ tɛɛle kei dɔɔ nɛ wola. ");
INSERT INTO ntr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Me ta lese n dinɔɔ wola balaŋ baŋ n ba lese wɔ lee tɛɛle kei dɔɔ fa maŋ nɛ. Be yɛɛ n balaŋwɔ te n moo wɔ fa maŋ. Be te di n nombia ŋan dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","te nɛnɛɛ ba te naa nyi kpene kamasɛ keŋ me dana nɛ lee n gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nawolo nyi ma te yako wɔ nombii kamasɛ keŋ n be yako maŋ nɛ, te be lɛɛ ŋa do. Ba te naa nyi ke yɛɛ ampaŋ nyi ma lee n gyaŋ, te ba te lɛɛ di nyi nyaŋ kpila na maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mɛɛ fane baa fa wɔ. Na tɛɛle kei dɔɔ balaŋ pou yaa mɛɛ fane maa fa ya. Mɛɛ fane maa fa balaŋ baŋ n ba mo wɔ fa maŋ nɛ, nawolo nyi be yɛɛ n wui. ");
INSERT INTO ntr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kpene kamasɛ keŋ n dana nɛ yɛɛ me wui, te keŋ maŋ mɔ dana nɛ yɛɛ n wui. Te n te tɛɛ be dɔɔ lese me gyoorobiiri wola. ");
INSERT INTO ntr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nɛnɛɛ mɛɛ kɔŋ baa n gyaŋ. Mɔɔ gyae maa tekaa kyaa tɛɛle kei dɔɔ bela ya, mɔna baŋ sɛɛ be kyaa tɛɛle kei dɔɔ. Me kya ŋon ayimɛɛ be doo n man ya, doŋ keŋ n ba mo gyee maŋ nɛ, mo mena doŋ kenaŋ gyee wɔ nideli, na baa yɛɛ nɔɔdokoloŋ ŋgba mena keŋ daa na neŋ yɛɛ dokoloŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Debaŋ keŋ me kyaa be gyaŋ nɛ, me gyee wɔ nideli lee n doŋ keŋ n ba do me man nɛ dɔɔ. Me gyee wɔ nideli keŋ be man ŋolo ta yoo ya. Ŋon kaboena nyi waa yo nɛ waageŋ yoo la, na ke yela Wurubuarɛ nombia aŋmaraseŋ see ŋan ke nyiŋ kɔŋ mena. ");
INSERT INTO ntr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nɛnɛɛ mɛɛ kɔŋ n gyaŋ. Te debaŋ kei keŋ me sɛɛ me kyaa tɛɛle kei dɔɔ nɛ, mɛɛ yako nombia kɛŋa baa na ke yela gyoŋ keŋ doo me maŋ nɛ ke nyiŋ doo be man nideli. ");
INSERT INTO ntr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma te kolosi n nombia fa wɔ mɔna tɛɛle kei dɔɔ balaŋ kɔla wɔ, nawolo nyi baŋ na wɔ ta tekaa yɛɛ dokoloŋ ya, ŋgba mena keŋ daa na tɛɛle kei dɔɔ balaŋ ta tekaa yɛɛ dokoloŋ ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mɔɔ ne fane nyi nya lese wɔ lee tɛɛle kei dɔɔ ya, mɔna mɛɛ fane bo nyi nya gyee wɔ nideli na bɔɔ yale walaŋkum ŋon kɔta man ya. ");
INSERT INTO ntr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ŋgba mena keŋ daa na tɛɛle kei balaŋ te yɛɛ dokoloŋ ya nɛ, mena kee yaa baŋ mɔ na tɛɛle kei dɔɔ balaŋ te yɛɛ dokoloŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mo nya anokoare nombia ŋan desina wɔ see. Nawolo nyi n nombia ŋan doo na ŋe gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mena keŋ n be kpila maŋ tɛɛle kei dɔɔ nɛ, mena ke yaa maŋ mɔ ne kpila wɔ tɛɛle kei dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Baŋ dɔɔ te ma moo ma wose fa neŋ, na baŋ mɔ ke nyiŋ mo ba wose fa neŋ kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na me kaseela kɛwɔ baageŋ yaa mɛɛ fane fa ya. Mɔna mɛɛ fane mɛɛ fa balaŋ baŋ pou baa nyii me kaseela kɛwɔ nombia te baa lɛɛ maŋ di nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mɛɛ fane bela nyiaa, be popou baa yɛɛ nɔɔdokoloŋ ŋgba mena keŋ me doo nyaŋ me kya man te nyaŋ mɔ n doo me man nɛ. Mena ke yaa yela baa doo de man na tɛɛle kei balaŋ pou ke nyiŋ lɛɛ di nyi nyaŋ kpila na maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma te fa wɔ gyoorobiiri keŋ n ba mo fa maŋ nɛ, na baa yɛɛ nɔɔdokoloŋ ŋgba mena keŋ daa na neŋ yɛɛ dokoloŋ te loŋ bɛɛ lam da nsana ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Me doo be man ŋgba mena keŋ nyaŋ mɔ n doo me man nɛ, na baa nyiŋ yɛɛ dokoloŋ keŋ nyi loŋ gba be lam ba nsana ya. Na tɛɛle kei dɔɔ balaŋ ke nyiŋ gyeŋ nyi nyaŋ kpila na maŋ, te n ne gyae be nombia ŋgba mena keŋ n ne gyae me nombia nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taata! Mɛɛ gyae nyi me kaseela baŋ n ba mo wɔ fa maŋ nɛ, baa kyaa me gyaŋ botɔɔ keŋ me kyaa nɛ, na baa nyiŋ naa me gyoorobiiri keŋ n ba mo fa maŋ nɛ. N moo gyoorobiiri kei fa maŋ nawolo nyi, n wulaa n ne gyae maŋ pɛte n yɛɛ tɛɛle kei. ");
INSERT INTO ntr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Me kya, nyaŋ yɛna walaŋ ŋon n gbɛɛneŋ tenɛɛ. Balaŋ baŋ be loo gyakaa tɛɛle kei dɔɔ nɛ, be ta gyeŋa ta neŋ ya mɔna maŋ dɔɔ ma gyeŋ neŋ. Te me kaseela baŋ mɔ gyeŋ nyi nyaŋ kpila na maŋ. ");
INSERT INTO ntr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Me ta lese n dinɔɔ wola wɔ te maa bese lese ke wola wɔ bela, na kegyae keŋ n ne gyae maŋ nɛ ke nyiŋ doo be man na maŋ mɔ ke doo be man.” ");
INSERT INTO ntr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu ke fane taŋ nɛ, ŋon na ɔ kaseela baŋ korowɔ gyu ka toŋ boŋobii keŋ bɛɛ baake ke Kidrɔn nɛ, te be ka gyoowɔ oliifi wɔɔbii daale man. ");
INSERT INTO ntr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Gyudase ŋon ɔ ba lese Yesu fa nɛ mɔ gyeŋ botɔɔ, nawolo nyi Yesu na ɔ kaseela baŋ ne kyaa gyu ke gyaŋee botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mena dɔɔ Gyudase moo balaŋ burum baŋ be dana kanease na kefuluse te ba doona yoo abɔɔ nɛ gyu botɔɔ. Mena balaŋ kɛwɔ baale yɛɛ yoonɔɔtenawɔ, te baale mɔ yɛɛ kotɔtɔɔtena baŋ bɛɛ deke Wurubuarɛ ɔsom deni dinaa keŋ nɛ. Gyudatena saese kegyiise na Farasiitena kpila na wɔ. ");
INSERT INTO ntr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Keŋ Yesu gyeŋ kpene keŋ ne kɔŋ ɔ dɔɔ dɔɔ nɛ, ɔ leewɔ ɔ kaseela baŋ man kɔŋ siaman te ɔ bɔɔse balaŋ baŋ nyiaa, “Amɔte yaa ɛ ne gyae?” ");
INSERT INTO ntr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Keŋte be tiranɔɔ fa e nyiaa, “Yesu Nasarɛte baale ŋon yaa dɛɛ gyae.” Te Yesu yako wɔ nyi, “Maŋ yaa.” Debaŋ kenaŋ na Gyudase ŋon waa lese Yesu fa nɛ mɔ kpuɛ balaŋ baŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu ke yako wɔ nyi “Maŋ yaa” nɛ, be tuuwɔ lee wɔle wɔle te ba ke yalawɔ tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Botɔɔ te Yesu besewɔ bɔɔse wɔ nyiaa, “Amɔte yaa ɛ ne gyae?” Te be yakowɔ nyi, “Yesu Nasarɛte baale ŋon yaa dɛɛ gyae.” ");
INSERT INTO ntr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Keŋte Yesu yakowɔ nyiaa “Me wulaa yako ŋon nyi maŋ yaa. Akpaa maŋ te ɛ ne gyae berɛ na, ɛ yela me balaŋ kɛwɔ ke ta.” ");
INSERT INTO ntr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kei yela nombia ŋan ɔ be wulaa yako nɛ kɔŋawɔ mena. Ɔ yakowɔ nyiaa, “Balaŋ baŋ nyaŋ me kya ba mo fa maŋ nɛ, ma te yeli be man dokoloŋ ka yo ya.” ");
INSERT INTO ntr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Botɔɔ na Simɔn Pita dana yoosila, te ɔ wɔŋa ke lese kara saese kegyia ŋon tobaale ŋolo dunoluŋ deŋele lese ke lɔ. Tobaale ŋonaŋ yele yɛna Maakuse. ");
INSERT INTO ntr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Botɔɔ te Yesu fae Pita nyiaa, “Besena n sila keŋ do ke bɔɔlee man. N bɛɛ gyae nyi maa naa diyem keŋ me kya be yako nyi me kaa naa nɛ yee?” ");
INSERT INTO ntr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Keŋte yoonɔɔtena siamante ŋon na ɔ yoonɔɔtena dikpii keŋ, na Gyudatena kotɔtɔɔtena baŋ kyaŋa Yesu te be bake e, ");
INSERT INTO ntr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","te be taŋgbɛɛwɔ mo e gyu Anase gyaŋ. Kaifase ŋon ɔ yɛɛ saese kegyia e kulutoo kenaŋ man nɛ, ɔ neŋgya yɛna Anase ŋonaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifase kei faa na Gyudatena agyueŋ nyi, dei nyi walaŋ dokoloŋ waa yeŋ fa balaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Debaŋ keŋ bɔɔ mo Yesu bee gyu saese kegyia ŋon dɛɛ nɛ, na Simɔn Pita na ɔ dɔɔ kaseela baŋ man ŋolo silana e wɔle wɔle. Keŋ kaseele ɔ dɔɔ ŋon gyeŋ saese kegyia ŋon dɔɔ nɛ, ŋon sila Yesu ka gyoo dekpaŋalaŋ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mɔna Pita ŋon dɔe denanɔɔ man. Botɔɔ te kaseele ŋon saese kegyia ŋon gyeŋ nɛ, besewɔ kɔŋ kaa kolosi na alebu ŋon ɔ na deke denanɔɔ keŋ nɛ nyi waa yela Pita mɔ ka gyoo. Keŋte ɔ moo e gyu dekpaŋalaŋ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Keŋte alebu ŋon bɔɔse Pita nyiaa, “Ŋgba nyaŋ mɔ n yɛɛ Yesu kaseela baŋ man ŋolo e?” Te Pita tiranɔɔ nyi, “Koa, ma te yɛɛ be man ŋolo e ya” ");
INSERT INTO ntr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Debaŋ kenaŋ na waare kyaa, mena dɔɔ kotɔtɔɔtena baŋ na dekpaŋalaŋ keŋ man tomyɛɛra baale doo boalaŋ bee woli. Te Pita mɔ gyuuwɔ ka seŋ be gyaŋ ɔ ne woli boalaŋ keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Be ka mo Yesu gyu saese kegyia ŋon dekpaŋalaŋ man nɛ, ɔ bɔɔse Yesu nombia lee ɔ kaseela na ɔ kawola keŋ wose man. ");
INSERT INTO ntr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Keŋte Yesu tiranɔɔ nyiaa, “Ma seŋawɔ balaŋ man kolosi. Debaŋ kamasɛ mɔ na mɛɛ wola Wurubuarɛ nombia Gyudatena ɔsom denɛɛ man, na Wurubuarɛ ɔsom deni dinaa keŋ Gyudatena pou ne kyaa gyaŋee ke man nɛ man. Mɔna ma te yako kolo weese ya. ");
INSERT INTO ntr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Woŋ dɔɔ te n ne bɔɔse maŋ mena nombia kɛŋa? Bɔɔse balaŋ baŋ bɔɔ nyii me kawola keŋ nɛ. Baŋ gyeŋa na kpene keŋ mɔɔ yako nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu kekolosi nombia kɛŋa nɛ te kegyiise baŋ man ŋolo gyɔɔ e ɔ lakaa man te ɔ bɔɔse e nyiaa, ‘Mena te kaboena nyi nya tiranɔɔ fa saese kegyia ŋon?’ ” ");
INSERT INTO ntr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Keŋte Yesu yako e nyiaa, “Akpaa me yako nombiikum daale na wola maŋ ke. Te akpaa me nombia doo na ke gbɛɛ na weera te ne gyɔ maŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Keŋte Anase yela ba moo Yesu gyu saese kegyia Kaifase gyaŋ, na ɔ sɛɛ ɔ doo ŋmeeseŋ ŋan bɔɔ mo bake e nɛ man. ");
INSERT INTO ntr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simɔn Pita ka seŋ botɔɔ ɔ ne woli boalaŋ keŋ nɛ te be bɔɔse e nyiaa, “Ŋgba nyaŋ mɔ n yɛɛ Yesu kaseela baŋ man ŋolo e?” Keŋte Pita tiranɔɔ nyi “Koa, ma te yɛɛ be man ŋolo e ya.” ");
INSERT INTO ntr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Botɔɔ te saese kegyia ŋon tobaale ŋolo ŋon ɔ loŋto yɛna tobaale ŋon Pita be kara ɔ deŋele nɛ bɔɔse Pita nyiaa, “Ŋgba me naa nyaŋ mɔ n kpuɛ na wɔ oliifi wɔɔbii keŋ man?” ");
INSERT INTO ntr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Keŋte Pita besewɔ bɛɛ nyi koa. Debokenaŋ man te kegyim lɔɔ woya. ");
INSERT INTO ntr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tɛɛ kena nebo nebo fuu nɛ, ba moo Yesu lee Kaifase dɛɛ gyu Pilato ŋon ɔ seŋɛɛ Romantena gyoo dinaa nawɔɔ man ɔ ne kɛɛ Gyuda tɛɛle dɔɔ nɛ dɛɛ. Debaŋ kenaŋ na Gyudatena nyeekelɛɛwee kedi keŋ ta benaa. Gyudatena kegyiise baŋ ta gyoo Pilato dekpaŋalaŋ keŋ man ya. Nawolo nyi ba te gyae baa walaa ba wose pɛ baa di ba nyeekelɛɛwee dinaa keŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mena dɔɔ kegyia Pilato leewɔ kɔŋ be gyaŋ debɔɔ man kaa bɔɔse wɔ nyiaa, “Woŋ dukum te balee kei yɛɛwɔ te ɛ ne gyae ɛ ke bu e fɔɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Keŋte be tiranɔɔ fa e nyiaa, “Nyi ŋon te yɛɛ bu kum e ya nɛ, nafɔ dɔɔ mo e kɔŋ kɛbo ya.” ");
INSERT INTO ntr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Botɔɔ te Pilato yako wɔ nyiaa, “Ɛ mo e ta na ɛmɛɛ gbagba kaa di ɔ nombia ŋgba mena keŋ ya mmaraa na wola ŋon nɛ.” Keŋte Gyudatena kegyiise baŋ tiranɔɔ fa e nyiaa, “Ɛmɛɛ Romantena mmaraa bɛɛ fa daa gbɛɛ nyi dɛɛ ko walaŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kei yela Yesu nombia ŋan ɔ be wulaa yako see lee ɔ yeŋ keŋ waa yeŋ wose man nɛ kɔŋawɔ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Keŋte kegyia Pilato besewɔ gyoo ɔ dekpaŋalaŋ man te ɔ baake Yesu bɔɔse e nyiaa, “Nyaŋ yɛna Gyudatena gyoo ŋon?” ");
INSERT INTO ntr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Te Yesu mɔ besenawɔ bɔɔse e nyiaa, “Nyaŋ gbagba nyeeman nombii yaa n ne bɔɔse maŋ nɛ yaa ŋolo yako na ma wose man nombia fa neŋ?” ");
INSERT INTO ntr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Botɔɔ te Pilato bɔɔse e nyiaa, “Me yɛɛ Gyuda baale e? Nyaŋ gbagba n balaŋ na ɛ saese kegyiise moona neŋ kɔna maŋ. Woŋ dukum te n yɛɛwɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Keŋte Yesu tiranɔɔ fa e nyiaa, “Me gyoori ta lee tɛɛle kei dɔɔ ya, nyi ke deŋ lee tɛɛle kei dɔɔ nɛ, nafɔ me tewulɛɛ baa yoo lɛɛ maŋ na bɔɔ nyiŋ mo maŋ ka do Gyudatena nyiŋmaa man ya. Mɔna me gyoori ta lee tɛɛle kei dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Keŋte Pilato yako e nyiaa, “Kenaŋ na ŋgba n yɛɛ gyoo e baa?” Te Yesu tiranɔɔ nyiaa, “Keŋ yaa n yakowɔ nɛ. Mena nombia kɛŋa dɔɔ te ba lola maŋ, te ŋan mɔ dɔɔ te me kɔŋawɔ tɛɛle kei dɔɔ na me kaa yako anokoare keŋ. Walaŋ kamasɛ ŋon ɔ ne gyae anokoare keŋ nɛ ɔ ne tei maŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Botɔɔ te Pilato bɔɔse e nyiaa, “Woŋ yɛna anokoare kei?” Ɔ ke bɔɔse e nombia kɛŋa taŋ nɛ te ɔ besewɔ lee kɔŋ Gyudatena baŋ gyaŋ kaa yako wɔ nyiaa, “Ma ta naa nombiikum daale lee ɔ wose man ya. ");
INSERT INTO ntr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mɔna ke yɛɛ ya mmaraa ke nyi ɛ nyeekelɛɛwee kedi kamasɛ man na, maa tina balaŋ baŋ bɔɔ kyam tɔ deni nɛ man dokoloŋ yela fa ŋon. Mena dɔɔ ɛ ne gyae nyi maa tina Gyudatena gyoo ŋon yela yaa sena?” ");
INSERT INTO ntr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Keŋte be fae yeesa yako nyiaa, “Koa, na Yesu te dɛɛ gyae nyi nya tina e yela ya. Barabase te dɛɛ gyae nyi nya tina e yela.” Barabase kei yɛna walaŋ ŋon ɔ be kyaa koro seŋ tia gyooneŋ te ɔ ba ko walaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Keŋte Kegyia Pilato yela ba ŋmeree Yesu mpiree. ");
INSERT INTO ntr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kei wɔle nɛ, Romantena yoonɔɔtena baŋ moo sɔɔse loo gyooro kotɔtɔɔ te ba moowɔ wuu Yesu. Te ba doo e kegba yayam wurikyim daale ŋgba gyoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na bee gyu bɛɛ kɔŋ kaa ŋmiŋ e kulu e nyiaa, “Gyudatena gyoo! N nyee dɛɛ wolose!” Na bɛɛ felee e ɔ lakaase man. ");
INSERT INTO ntr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Botɔɔ te kegyia Pilato besewɔ kɔŋ debɔɔ man te ɔ yako Gyudatena baŋ nyiaa, “Ɛ nyii, mɛɛ mo e maa lee kɔna ŋon debɔɔ man kɛbo na ɛ kena nyi ma te naa ɔ dukum keŋ ɔ be yɛɛ ya.” ");
INSERT INTO ntr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mena dɔɔ te kyare ya te Yesu leewɔ debɔɔ man, na ɔ wuuna gyooro kotɔtɔɔ keŋ te ɔ doona ɔ kegba yayam keŋ mɔ! Keŋte kegyia Pilato yako wɔ nyiaa, ɛ walaŋ ŋon yaa. ");
INSERT INTO ntr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Saese kegyiise na Wurubuarɛ dɛɛ kotɔtɔɔtena baŋ ke gyɔ ba sibii na Yesu nɛ, ba fae yeesa nedoŋ nyiaa, “Gyɔ e sakaa ɔpaŋdaŋ dɔɔ, gyɔ e sakaa ɔpaŋdaŋ dɔɔ.” Botɔɔ te kegyia Pilato yako wɔ nyiaa, “Ma te naa dukum keŋ ɔ be yɛɛ ya. Ɛmɛɛ gbagba ɛ mo e kegyɔ sakaa ɔpaŋdaŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Botɔɔ te Gyudatena baŋ tiranɔɔ nyiaa, “Daa dana mmaraa daale te kɛɛ wolo nyi kaboena nyi waa yeŋ, nawolo nyi ɔ ta mo ɔ wose nyi ɔ yɛɛ Wurubuarɛ bu e.” ");
INSERT INTO ntr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kegyia Pilato ka betaa nyii nombia kɛŋa nɛ, gyakoloŋ gyoo e gbaa. ");
INSERT INTO ntr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Botɔɔ te ɔ besewɔ gyu dekpaŋalaŋ keŋ man ke bɔɔse Yesu nyiaa, “N lee aleŋ?” Mɔna Yesu diŋi e bo. ");
INSERT INTO ntr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mena dɔɔ kegyia Pilato bɔɔse e nyiaa, “N be kolosi yee? N ba gyeŋ nyi me dana doŋ keŋ maa tale tina neŋ yela, yaa maa yela baa gyɔ neŋ sakaa ɔpaŋdaŋ dɔɔ yee?” ");
INSERT INTO ntr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Botɔɔ te Yesu tiranɔɔ nyiaa, “Me kya faa na neŋ gbɛɛ, mena dɔɔ te n nyiŋa doŋ me dɔɔ. Nafɔ nyaŋ gbagba n baam dɔɔ na, n be dana doŋ me dɔɔ ya. Mena dɔɔ walaŋ ŋon ɔ ba lese maŋ fa nɛ, ŋon wui dukum kela la.” ");
INSERT INTO ntr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Debaŋ keŋ kegyia Pilato be nyii nombia kɛŋa nɛ, ɔ gyae gbɛɛ keŋ waa mo tina Yesu yela, mɔna na Gyudatena baŋ ne fae yeesa yako nyiaa, “Akpaa n tina balee kei yela na, n te yɛɛ Romantena gyoo dinaa Kaesa ɔ dɔɔ e ya. Walaŋ kamasɛ ŋon ɔ see ɔ wose gyoo nɛ, na ɔ na koro baa seŋ tia gyoo dinaa Kaesa.” ");
INSERT INTO ntr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kegyia Pilato ka betaa nyii nɔɔwoya kɛŋa nɛ, ɔ moo Yesu lee kɔŋ debɔɔ man te ɔ kaa gyeŋawɔ kyaa ɔ gbeli keŋ dɔɔ ɔ ne kyaa di nombia nɛ. Boya te ba moowɔ ma ɔ dekyae kenaŋ, te Gyudatena dei man na bɛɛ baake ke nyi “Gabata.” ");
INSERT INTO ntr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Debaŋ kenaŋ na weese ta seŋ dɛɛ. Wee kenaŋ te Gyudatena ne desina ba wose na ke tɛɛ naa na, baa di ba nyeekelɛɛwee keŋ. Keŋte kegyia Pilato yako Gyudatena baŋ nyiaa, “Ɛ kɛɛ, ɛ gyoo ŋon yaa.” ");
INSERT INTO ntr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Botɔɔ te be fae yeesa nyiaa, “Ɛ mo e lee de siaman, ɛ mo e lee de siaman. Ɛ gyɔ e sakaa ɔpaŋdaŋ dɔɔ.” Te kegyia Pilato bɔɔse wɔ nyiaa “Ɛ gyoo yaa te ɛ ne gyae nyi maa ko e?” Keŋte saese kegyiise baŋ tiranɔɔ nyi, “Da be dana gyoo kamasɛ kpu na Kaesa ya.” ");
INSERT INTO ntr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kɛŋa pou wɔle nɛ, kegyia Pilato moo Yesu do balaŋ baŋ nyiŋmaa man nyi baa gyu ke gyɔ e sakaa ɔpaŋdaŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mena dɔɔ yoonɔɔtena baŋ moo Yesu lee donɔɔ keŋ man na ɔ seelena ɔ ɔpaŋdaŋ keŋ te ba moo e laŋ gyu botɔɔ keŋ bɛɛ baake “Nyeepookoo dɛɛ” nɛ. Gyudatena dei man na bɛɛ baake ke bo nyi “Golgata.” ");
INSERT INTO ntr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Botɔɔ te be gyɔɔ e nyeelabia sakaa ɔpaŋdaŋ dɔɔ. Keŋte be gyɔɔ balaŋ bala baale mɔ sakaa ɔpaŋdaase dɔɔ kpu na e. Ŋolo sakaa ɔ dunoluŋ dɔɔ te ŋolo mɔ sakaa ɔ demena dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Keŋte kegyia Pilato yela be ŋmarase nɔɔwoya kɛŋa mataa na ɔpaŋdaŋ keŋ. Nɔɔwoya ŋenaŋ yɛna nyiaa, ");
INSERT INTO ntr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gyudatena burum kala keŋmarase kei nawolo nyi botɔɔ keŋ bɔɔ gyɔ Yesu ɔpaŋ dɔɔ nɛ betaŋ lem na donɔɔ keŋ ya. Be ŋmarase ke Gyudatena dei man na Romantena dei man na Giriki dei man. ");
INSERT INTO ntr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Gyudatena saese kegyiise kena keŋmarase keŋ nɛ be yako kegyia Pilato nyiaa, “Nyeŋ te ŋmarase ke nyi Gyudatena gyoo ya. Nyeŋ ŋmarase ke bo nyi, balee kei kpa ŋon yɛna Gyudatena gyoo.” ");
INSERT INTO ntr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Botɔɔ te kegyia Pilato tiranɔɔ nyiaa, “Kpene keŋ mɔɔ ŋmarase nɛ, me taŋ keŋmarase.” ");
INSERT INTO ntr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Debaŋ keŋ yoonɔɔtena baŋ be gyɔ Yesu ɔpaŋdaŋ dɔɔ taŋ nɛ, ba moo ɔ wose man abɔɔ ŋan te be kpala ŋa akpeŋ anaara, na be man kamasɛ ka mo dekpeŋ dokoloŋ. Ba ke kpala taŋ na te kaa ɔ kegba atetate keŋ. Mena kegba kei dɔɔ kanyaŋ dokoloŋ te ba moowɔ loo ke karatetee lee ka nyeeman tisi. Be ta loo ke towaa towaa ŋgba mena keŋ bɛɛ loo kegba yakaa nyiŋan nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Keŋte yoonɔɔtena baŋ yako dɔŋa nyiaa, “Ɛ na fa dee tirii kegba kei ya. Ɛ fa dɛɛ lɔ boe na dɛɛ kɛɛ ŋon waa nyiŋ ke.” Kei yela Wurubuarɛ nombia aŋmaraseŋ see ŋan kɔŋawɔ ampaŋ. Be ŋmarasewɔ see nyiaa, “Be kpala ma abɔɔ, te ma kegba atetate dɔɔ be lɔɔ boe bo ke dɔɔ” Keŋ dɔɔ mena mɔ te yoonɔɔtena baŋ yɛɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Debaŋ kenaŋ na Yesu ɔ naa na ɔ niinaa na Kilopase wɛɛle Mɛɛre, na Mɛɛre ŋon ɔ ba lee Magedala nɛ seŋɛɛ benaa na Yesu ɔpaŋdaŋ keŋ. ");
INSERT INTO ntr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu kena ɔ naa na ɔ kaseele ŋon ɔ ne gyae ɔ nombia seŋɛɛ benaa na dɔŋa nɛ, ɔ yako ɔ naa nyiaa, “Nna, n bu ŋonaŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Keŋte ɔ kɛɛ ɔ kaseele ŋon mɔ te ɔ yako e nyiaa, “Kɛɛ, n naa ŋonaŋ.” Lee debaŋ kenaŋ na, te kaseele ŋon moo Yesu ɔ naa gyu ɔ dɛɛ te ɔ ke kyaawɔ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kɛŋa wɔle Yesu kena nyi nɛnɛɛ kpene kamasɛ te taŋ nɛ ɔ yakowɔ nyiaa, “Loŋboaneŋ dana maŋ.” Kei yela Wurubuarɛ nombia aŋmaraseŋ see ŋan kɔŋawɔ mena. ");
INSERT INTO ntr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na osuŋ na soloŋ denyaŋesa daale baŋɛɛ botɔɔ. Mena dɔɔ ba moo kolo ŋgba kokyaa keŋ gyae ke tale lɛɛ loŋ nɛ do soloŋ keŋ man, te ba moo ke tooso na daŋ daale te ba moo ke sɔɔ ɔ nɔɔ nyi waa nyɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Soloŋ keŋ ke tina Yesu nɔɔ nɛ te ɔ yakowɔ nyiaa, “Te taŋ.” Botɔɔ te ɔ gɔŋase ɔ nyee te ɔ kara weesi. ");
INSERT INTO ntr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wee kenaŋ yɛna wee keŋ Gyudatena na mo desina ba wose fa ba kefɛɛfowee kedi. Mena kefɛɛfowee kei yɛɛ wee dinaa ke. Te ke yɛɛ kpene keŋ bɛɛ kɔle nyi baa tina woo yela ɔpaŋdaŋ dɔɔ na ba kefɛɛfowee keŋ kaa tuŋ e. Lee mena dɔɔ Gyudatena kegyiise baŋ gyuu kegyia Pilato gyaŋ ka sola e nyi, waa fa wɔ gbɛɛ na be kaa tekerii balaŋ baŋ bee fiti na yeŋ nɛ nawɔɔ na baa nyiŋ yeŋ bileŋ, na baa nyiŋ lese wɔ ɔpaŋ daase ŋan dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mena dɔɔ yoonɔɔtena baŋ gyuuwɔ ke tekerii balaŋ bala baŋ bɔɔ gyɔ wɔ sakaa kpu na Yesu nɛ nawɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mɔna ba kekɔŋ Yesu gyaŋ te ba kena nyi ɔ taŋ ke wulaa yeŋ nɛ, ba te tekerii ɔ nawɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Keŋte yoonɔɔtena baŋ ŋolo moo wa apia sɔɔ Yesu yenaabia man. Debokenaŋ man te fatabo na loŋ leewɔ. ");
INSERT INTO ntr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Maŋ walaŋ ŋon mɔɔ naa nombia kɛŋa na me sia nɛ ne diina ka wose man adansɛɛ, te ma adansɛɛ keŋ yɛɛ anokoare. Ma gyeŋ nyi anokoare yaa mɛɛ yako, te mee di adansɛɛ baa na ɛmɛɛ mɔ ke nyiŋ lɛɛ di. ");
INSERT INTO ntr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kei yela Wurubuarɛ nombia aŋmaraseŋ see ŋan kɔŋawɔ ampaŋ. Nombia ŋenaŋ yɛna nyiaa, “Bɔɔ gyae baa tekeri ɔ ŋɔe dokoloŋ pɛ gba ya.” ");
INSERT INTO ntr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wurubuarɛ nombia aŋmaraseŋ daale mɔ yakowɔ nyiaa, “Balaŋ baa kɛɛ walaŋ ŋon bɔɔ sɔɔ e apia nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kɛŋa pou wɔle nɛ, Gyosɛfo ŋon ɔ ba lee Arimatia donɔɔ man nɛ kaa sola gbɛɛ lee kegyia Pilato gyaŋ na ɔ kaa lese Yesu woo ŋon kewuu. Na Gyosɛfo kei mɔ yɛɛ Yesu kaseele e, mɔna ɔ weese ɔ wose bo nawolo nyi ɔ ne yee Gyudatena kegyiise baŋ. Kegyia Pilato ke fa e gbɛɛ nɛ te ɔ gyuuwɔ ka lese woo ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemose ŋon ɔ be kyaa kɔŋ Yesu gyaŋ nelim nɛ, mɔ kaa kpuuwɔ na Gyosɛfo ŋon. Nikodemose kei moo pɛperɛ na oliifi na abɔɔ ofoŋ nyiŋan ŋaale tasatɔɔ kɔŋ te ba moowɔ desina woo ŋon. ");
INSERT INTO ntr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Be balaŋ bala moo akaralɛɛ na abɔɔ ofoŋ nyiŋan mo milii Yesu ŋgba mena keŋ Gyudatena ne desina woo pɛte bee wuu e nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na wɔɔbii daale kyaa botɔɔ keŋ bɔɔ gyɔ Yesu sakaa ɔpaŋdaŋ dɔɔ nɛ. Yebɔɔ wɔle wɔle daale doo botɔɔ keŋ be te wuu ta walaŋ ke man see ya. ");
INSERT INTO ntr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Keŋ Gyudatena kefɛɛfowee keŋ na benaa te bee desina ba wose mɔ te yebɔɔ keŋ mɔ benaa na botɔɔ dɔɔ nɛ, ba moo woo ŋon kewuu ke man. Keŋte be biliŋi boe dinaa daale tɔ ke nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kosida nebo nebo fuu keŋ tɛɛ te ŋmaŋee ta nideli ya nɛ, Mɛɛre ŋon ɔ ba lee Magedala donɔɔ man nɛ, karatɛɛwɔ gyu botɔɔ keŋ bɔɔ wuu Yesu nɛ. Ɔ ke gyu botɔɔ nɛ, ɔ naawɔ nyi be te biliŋi boe keŋ lee yebɔɔ keŋ nɔɔman. ");
INSERT INTO ntr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mena dɔɔ ɔ yeuwɔ kɔŋ Simɔn Pita na kaseele ŋon Yesu ne gyae ɔ nombia nɛ gyaŋ kaa yako wɔ nyiaa, “Be ta lese de Gbeŋgyoo lee yebɔɔ keŋ man, te dɔɔ gyeŋ botɔɔ keŋ bɔɔ moo e ka see ya.” ");
INSERT INTO ntr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Keŋte Pita na kaseele ŋon yeuwɔ gyu yebɔɔ keŋ tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Be kee yeu keŋ nɛ, kaseele ŋon Yesu ne gyae ɔ nombia nɛ yeuwɔ gbaa Pita kyaŋ gbɛɛ ka gyoo yebɔɔ keŋ tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɔ buŋawɔ kɛɛ yebɔɔ keŋ man na, ɔ naa akaralɛɛ keŋ kaageŋ doo la mɔna ɔ ta gyoo ke man ya. ");
INSERT INTO ntr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔn Pita ka lee wɔle kɔŋ na te ŋon kaa gyoowɔ yebɔɔ keŋ man. Ɔ gyoowɔ na te ɔ naa akaralɛɛ keŋ, ");
INSERT INTO ntr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kanyaŋ keŋ bɔɔ mo bake ɔ nyee nɛ. Kanyaŋ keŋ be doo akaralɛɛ keŋ gyaŋ ya, mɔna akaralɛɛ keŋ te bɔɔ ke doo yenaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wɔle wɔle na te kaseele ɔ dɔɔ ŋon mɔ gyoowɔ kena abɔɔ ŋan, keŋte ŋon mɔ lɛɛwɔ di. ");
INSERT INTO ntr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mɔna Wurubuarɛ nombia aŋmaraseŋ see ŋan ne yako nyi “Yesu waa foŋ lee yeŋ man nɛ, be sɛɛ be te nyii ta ŋe man nideli ya.” ");
INSERT INTO ntr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Keŋte kaseela baŋ besewɔ gyu be dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mɔna Mɛɛre ŋon ɔ be sila wɔ gyu nɛ seŋɛɛ yebɔɔ keŋ tɛɛ ɔ ne wii. Ɔ ka seŋ ɔ ne wii nɛ te ɔ buŋawɔ kɛɛ yebɔɔ keŋ man, ");
INSERT INTO ntr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","keŋte ɔ naa Wurubuarɛ kpilala bala na ba doona kegbase wolomɛɛ be kyaa botɔɔ keŋ bɔɔ mo Yesu woo ŋon doosi nɛ. Ŋolo kyaa yebɔɔ keŋ nyee gbɛɛ te ŋolo mɔ kyaa ke nawɔɔ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Keŋte be bɔɔse e nyiaa, “Alo, weera n ne wii?” Te ɔ tiranɔɔ fa wɔ nyiaa, “Nawolo nyi be ta lese me Gbeŋgyoo lee yebɔɔ keŋ man, te mɔɔ gyeŋ botɔɔ keŋ bɔɔ mo e ka see ya.” ");
INSERT INTO ntr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɔ ke yako mena nɛ, ɔ gɛɛsewɔ kɛɛ na te ɔ naa Yesu seŋɛɛ, mɔna ɔ ta gyem nyi Yesu ŋonaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Keŋte Yesu bɔɔse e nyiaa, “Alo, weera n ne wii? Amɔte yaa n ne kɛo?” Na Mɛɛre gyeŋ nyi walaŋ ŋon ɔ ne kɛɛ wɔɔbii keŋ dɔɔ nɛ ŋonaŋ, mena dɔɔ ɔ yako e nyiaa, “Tobaale, akpaa nyaŋ moona woo ŋon ka weese na, wola maŋ botɔɔ keŋ n ba mo e ka see na me kaa mo e ta.” ");
INSERT INTO ntr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Keŋte Yesu baake e nyiaa, “Mɛɛre!” Mɛɛre gɛɛsewɔ kɛɛ te ɔ fae yeesa baake e be dɛɛ dei man nyiaa, “Raboni” keŋ nawolo nyi “De Gbeŋgyoo” ");
INSERT INTO ntr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Keŋte Yesu yako e nyiaa, “Na tina maŋ ya, nawolo nyi me te gyuu ta me kya ŋon gyaŋ ya. Mɔna bese gyu me kaseela baŋ gyaŋ na n kaa yako wɔ nyi ‘Mee gyu me kya ŋon ɔ yɛɛ ɛ kya e nɛ, na me Wurubuarɛ ŋon ɔ yɛɛ ɛ Wurubuarɛ e nɛ gyaŋ.’ ” ");
INSERT INTO ntr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mena dɔɔ Mɛɛre Magedala ŋon gyuuwɔ ke yako kaseela baŋ nyiaa “Ma te naa de Gbeŋgyoo Yesu ŋon.” Te ɔ besewɔ yako wɔ nombia ŋan Yesu be yako e nyi waa yako wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kosida kenaŋ balinɔɔ nɛ, kaseela baŋ gyuuwɔ ke gyaŋee deni man te be tɔɔ disim do ba wose, nawolo nyi bee yee Gyudatena kegyiise baŋ. Debokenaŋ man te Yesu kaa bɛɛwɔ lee ba nsana te ɔ yako wɔ nyiaa, “Wosefɛɛreŋ dɛɛ kyaa na ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɔ ke yako wɔ mena nɛ, ɔ moo ɔ nyiŋmaa na ɔ yenaabia gyam keŋ wola wɔ. Keŋte yɛɛ ɔ kaseela baŋ gyoŋ nideli nyi ba te naa be Gbeŋgyoo ŋon bela. ");
INSERT INTO ntr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Keŋte Yesu besewɔ yako wɔ nyiaa, “Wosefɛɛreŋ dɛɛ kyaa na ŋon, mena keŋ me kya ŋon be kpila maŋ nɛ, mena ke yaa mɛɛ kpila ɛmɛɛ mɔ.” ");
INSERT INTO ntr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ɔ kekolosi nombia kɛŋa taŋ nɛ, ɔ lee weesɛɛ woli wɔ te ɔ yako wɔ nyiaa, “Ɛ lɛɛ Wurubuarɛ feliŋ ŋon na waa kyaa ɛ man. ");
INSERT INTO ntr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Akpaa ɛ mo ŋolo nombiakumɛɛ kyɛɛ e na, Wurubuarɛ mɔ waa mo kyɛɛ e. Te akpaa ɛ bɛɛ ɛ ta mo ŋolo nombiakumɛɛ kyɛɛ e ya na, Wurubuarɛ mɔ be gyae waa mo kyɛɛ e ya.” ");
INSERT INTO ntr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wee kenaŋ keŋ Yesu be kaa lese ɔ wose wola ɔ kaseela kufu bala baŋ nɛ, na be man ŋolo ŋon bɛɛ baake e nyi Tomase yaa Ata nɛ be kpuɛ na ɔ tebia ya. ");
INSERT INTO ntr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mena dɔɔ Yesu kaseela akaŋ baŋ yako Tomase nyiaa, “Da te naa de Gbeŋgyoo ŋon.” Keŋte Tomase yako wɔ nyiaa, “Akpaa me ta mo me sia naa nyeelabia gyaŋtarɛɛ ŋan, na maa mo me nyimbii do ɔ yenaabia gyam keŋ man ya nɛ, maŋ be gyae maa lɛɛ di korakora ya.” ");
INSERT INTO ntr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Weeya gyanaara wɔle nɛ, na ɔ kaseela baŋ te gyaŋee deni man bela. Wee kenaŋ na Tomase mɔ kpuɛ na wɔ. Ba te tɔ asima ŋan pou, karatetee dokoloŋ te Yesu kaa bɛɛwɔ lee be dɔɔ te ɔ yako wɔ nyiaa, “Wosefɛɛreŋ dɛɛ kyaa na ŋon.” ");
INSERT INTO ntr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Keŋte ɔ yako Tomase nyiaa, “Mo n nyiŋmaa do me nyiŋmaa bɔɔ man na n ke kɛɛ me nyiŋmaase, na n ka mo n nyimbii do ma yenaŋ kɛɛ. Tina aŋmaareŋ kelɛɛ yela na n ke lɛɛ di.” ");
INSERT INTO ntr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Botɔɔ te Tomase tiranɔɔ nyiaa, “Nyaŋ yɛna me Gbeŋgyoo na me Wurubuarɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Keŋte Yesu bɔɔse e nyiaa, “Keŋ n be naa maŋ dɔɔ te n lɛɛwɔ di? Balaŋ baŋ ba te naa maŋ ya te bɔɔ lɛɛ di nɛ, baŋ na nyeebam.” ");
INSERT INTO ntr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu besewɔ yɛɛ gyakoloŋ nombia burum ŋan ɔ kaseela baŋ be naa na be sia, mɔna na ŋe popou te be ŋmarasewɔ do tɔne kei man ya. ");
INSERT INTO ntr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mɔna be ŋmarase kɛŋa bo na ɛ ke lɛɛ di nyi Yesu yɛna Wurubuarɛ bu na nyeelɛɛre ŋon. Na nyaŋ ŋon n lɛɛ e di na, n ke nyiŋ nyeedoŋ kekpaa keŋ ɔ yele man. ");
INSERT INTO ntr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kɛŋa pou wɔle nɛ, Yesu besewɔ lese ɔ wose wola ɔ kaseela baale Tiberiase boo nɔɔman. Mena keŋ ɔ ba lese ɔ wose wola wɔ yaa. ");
INSERT INTO ntr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ɔ kaseela baŋ bɛɛ baake wɔ Simɔn Pita na Tomase ŋon bɛɛ baake e Ata nɛ na Natanɛle ŋon ɔ ba lee Kaanan donɔɔ keŋ ke kyaa Galelia tɛɛle man nɛ, na Sebedeo bia na ɔ kaseela bala baale gyuuwɔ ke kyaa bom. ");
INSERT INTO ntr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Keŋte Simɔn Pita yako wɔ nyiaa, “Mee gyu boo man me kaa kyaŋ kpebia.” Te baŋ mɔ yako e nyiaa, “Daa mɔ dee sila neŋ gyu.” Mena dɔɔ be gyuuwɔ ka gyoo degbele man te be laŋawɔ. Be lɔɔ asawu nelim kenaŋ pou mɔna ba te kyaŋ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tɛɛ kena nebo nebo fuu nɛ, be kɛɛ na ŋolo seŋɛɛ la boo nɔɔman, na n kɛɛ nɛ Yesu ŋonaŋ. Mɔna ɔ kaseela baŋ ta gyeŋ e ya. ");
INSERT INTO ntr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Keŋte Yesu bɔɔse wɔ nyiaa, “Tewulɛɛ, doona ɛ te kyaŋ kolo ya?” Te be tiranɔɔ nyiaa, “Koa de te nyiŋ kpebii dokoloŋ paŋpaŋ gba ya.” ");
INSERT INTO ntr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Keŋte ɔ yako wɔ nyiaa, “Ɛ fuŋ ya asawu keŋ lɔ degbele keŋ dunoluŋ dɔɔ na ɛ ke kyaŋ kpebia.” Mena dɔɔ be fuŋa asawu keŋ lɔ botɔɔ yenaŋ te be kyaŋa kpebia burum keŋ nyi bɔɔ ne tale baa wɔŋee asawu keŋ gba ya. ");
INSERT INTO ntr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Botɔɔ te Yesu kaseele ŋon ɔ ne gyae ɔ nombia nɛ yako Pita nyiaa, “De Gbeŋgyoo Yesu ŋonaŋ.” Simɔn Pita kenyii nyi de Gbeŋgyoo Yesu ŋonaŋ nɛ te ɔ moo ɔ kegba wurikyim milii ɔ wose, nawolo nyi ɔ wulaa kpee ke. Keŋte ɔ toŋawɔ gyoo loŋ keŋ man yɛlɛɛ ɔ ne gyu Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mɔna kaseela akaŋ baŋ saa degbele keŋ bɛɛ kɔŋ dekeŋkeŋ dɔɔ na bɛɛ wɔŋee asawu keŋ kpebia be wulu ke man nɛ, nawolo nyi na ba dekyae keŋ taŋ lem na dekeŋkeŋ ya. Ke lem gyae ke yɛɛ ŋgba baam tɔɔse sɔŋola na kufu nɛ (50). ");
INSERT INTO ntr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Be kelii dekeŋkeŋ dɔɔ nɛ be naa boalaŋ na nyewalaŋ, na kpebia gyakaa ke dɔɔ na bodobodo mɔ doo yenaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Keŋte Yesu yako wɔ nyiaa, “Ɛ mo kpebia baŋ ɛ be kyam nɛ baale kɔŋ.” ");
INSERT INTO ntr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mena dɔɔ Simɔn Pita besewɔ gyu degbele keŋ man, te ɔ ke wɔŋee asawu keŋ kɔŋ dekeŋkeŋ dɔɔ. Na kpebia dinaana baŋ bɔɔ wulu asawu keŋ nɛ, be yaanɔɔle yɛɛ sɔŋonoŋ na sɔŋola na kufu batooro (153). Keŋ na kpebia baŋ booroŋ kei koraŋ nɛ, asawu keŋ te tirii ya. ");
INSERT INTO ntr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Keŋte Yesu yako wɔ nyiaa, “Ɛ kɔŋ kaa di ɛ nebo weenɛɛ.” Mɔna ɔ kaseela baŋ ŋolo te tale gyɔ ɔ konɔɔ bɔɔse e nyi “Nyaŋ yɛna amɔte ya?” Nawolo nyi ba gyeŋ nyi be Gbeŋgyoo Yesu ŋonaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Te Yesu kɔŋawɔ kaa mo bodobodo keŋ fa wɔ, kenaŋ wɔle te ɔ moo kpebia baŋ mɔ fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu kefoŋ lee yeŋ man nɛ, kei yɛna betabotoorote keŋ ɔ ba lese ɔ wose wola ɔ kaseela baŋ. ");
INSERT INTO ntr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Be kedi weenɛɛ ŋan taŋ nɛ te Yesu bɔɔse Simɔn Pita nyiaa, “Gyɔn bu Simɔn, n ne gyae maŋ kela n tebia kɛwɔ kɛɛ gyae maŋ?” Keŋte Pita tiranɔɔ fa e nyiaa, “Ayi, me Gbeŋgyoo, n gyeŋ nyi mɛɛ gyae n nombia.” Keŋte Yesu yako e nyiaa, “Kɛɛ me silala baŋ dɔɔ ŋgba mena keŋ namensekɛɛlere ne kɛɛ namense dɔɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Te Yesu besewɔ bɔɔse e bolate nyiaa, “Gyɔn bu Simɔn, n ne gyae me nombia?” Te Pita tiranɔɔ fa e nyiaa, “Ayi me Gbeŋgyoo, nyaŋ gbagba gyeŋ nyi mɛɛ gyae n nombia.” Keŋte Yesu yako e nyiaa “Kɛɛ me silala baŋ dɔɔ ŋgba mena keŋ namensekɛɛlere ne kɛɛ ɔ namense dɔɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Keŋte Yesu besewɔ bɔɔse e betabotoorote nyiaa, “Gyɔn bu Simɔn, n ne gyae me nombia nideli?” Nombia ŋenaŋ takaa Pita nideli nawolo nyi ɔ te bɔɔse e betabotooro nyi, “N ne gyae maŋ nideli?” Keŋte Pita yako e nyi, “Me Gbeŋgyoo, nyaŋ gbagba n gyeŋ kpene kamasɛ. N gyeŋ nyi mɛɛ gyae neŋ nideli.” Keŋte Yesu yako e nyiaa, “Mena na kɛɛ me silala baŋ dɔɔ ŋgba mena keŋ namensekɛɛlere ne kɛɛ ɔ namense dɔɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mɛɛ yako neŋ anokoare nyiaa, “Debaŋ keŋ n yɛɛ tobaale e nɛ nyaŋ gbagba ne tale mo n kegba do n wose, na n ka koro gyu botɔɔ keŋ n ne gyae. Mɔna n kaa ŋmɛɛ na ŋolo ne gyae la waa do neŋ kegba na waa kyaŋ neŋ n nyiŋmaa man mo neŋ gyu botɔɔ keŋ n bɛɛ gyae nyi n ke gyu ya.” ");
INSERT INTO ntr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu yako nombia kɛŋa baa na kawola yeŋ keŋ Pita waa yeŋ na ka lese Wurubuarɛ yele. Yesu kekolosi nombia kɛŋa pou taŋ nɛ te ɔ yako Pita nyiaa, “Sila maŋ!” ");
INSERT INTO ntr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ba ke ta bee gyu nɛ, Pita gɛɛsewɔ kɛɛ te ɔ naawɔ ŋgba kaseele ŋon Yesu ne gyae ɔ nombia nideli nɛ silana wɔ wɔle wɔle. Mena kaseele kei yɛna ŋon ɔ be kyaa teelina Yesu debaŋ keŋ bee di be balinɔɔ weenɛɛ te ɔ be bɔɔse e nyiaa, “Me Gbeŋgyoo, amɔte ne gyae la waa lese neŋ fa yeŋ nɛ?” ");
INSERT INTO ntr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita kena kaseele ŋon nɛ ɔ bɔɔse Yesu nyiaa, “Me Gbeŋgyoo, sena te baa yɛɛ balee kei mɔ?” ");
INSERT INTO ntr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Keŋte Yesu tiranɔɔ fa e nyiaa, “Akpaa mɛɛ gyae nyi waa kyaa kelii debaŋ keŋ maa bese kɔŋ na, n woŋ faa la? Nyaŋ sila maŋ!” ");
INSERT INTO ntr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mena dɔɔ nombia kɛŋa yaaseewɔ Yesu kaseela baŋ man nyiaa, kaseele ŋon Yesu ne gyae ɔ nombia nɛ be gyae waa yeŋ ya. Mɔna Yesu te yako nyi ɔ be gyae waa yeŋ ya. Keŋ ɔ be yako yɛna nyi, “Akpaa mɛɛ gyae nyi waa kyaa kelii debaŋ keŋ maa bese kɔŋ na, n woŋ faa la?” ");
INSERT INTO ntr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mena kaseele kei diina nombia kɛŋa wose man adansɛɛ te ɔ ŋmarase ŋa see. Te da gyeŋ mɔ nyi wa adansɛɛ keŋ yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yɛɛ abɔɔ burum ŋaale mɔ. Akpaa beŋ ŋmarase ŋa dokoloŋ dokoloŋ nɛ, tɛɛle kei dɔɔ pou bɔɔ gyae baa nyiŋ botɔɔ keŋ baa mo ŋa see ya.");
INSERT INTO ntr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kegyia Teyofilose, maŋ Luka ne ŋmarase na tɔne kei mee yelee neŋ. Me tɔne gyaŋgbate keŋ man nɛ, ma wola abɔɔ ŋan pou Yesu be yɛɛ na ŋan ɔ ba wolo debaŋ keŋ ɔ be fi ɔ tom asɛɛ, ");
INSERT INTO ntr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mo kelii wee keŋ Wurubuarɛ ba mo e laŋ adido nɛ. Pɛ Wurubuarɛ ka mo Yesu gyu adido nɛ, Wurubuarɛ feliŋ ŋon tɛɛwɔ ŋon Yesu dɔɔ wola ɔ kpilala baŋ ɔ ba lese nɛ tom keŋ baa yɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu Kristo ka yeŋ wɔle weeya sɔŋola man nɛ, ɔ lese ɔ wose wola ɔ kaseela baŋ agbaatee agbaatee lee gbɛɛneŋ burum man wola nyi ɔ delena, keŋ nyi ŋolo be tale lɛɛ ka aŋmaareŋ ya. Be naa e na be sia, te ɔ kolosiwɔ fa wɔ lee Wurubuarɛ gyoorobiiri keŋ wose man. ");
INSERT INTO ntr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ba kekyaa man nɛ, wee daale ɔ faree ɔ kaseela baŋ nyi “Ɛ na lee Gyerusalɛm donɔɔ man ya, mɔna ɛ kyaa botɔɔ daa kpene keŋ me kya be yako see nyi waa fa ŋon nɛ.” Me wulaa yako ŋon ka wose man nombia nyi, ");
INSERT INTO ntr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","loŋ te Gyɔn moowɔ sɔ ŋon Wurubuarɛ loŋ, mɔna weeya akalansɛɛ ŋaale wɔle na Wurubuarɛ waa mo ɔ feliŋ ŋon bo sɔ ŋon Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Debaŋ keŋ Yesu na ɔ kpilala baŋ be yilaa nɛ te be bɔɔse e nyiaa, “De Gbeŋgyoo, mena dɔɔ nɛnɛɛ n ka besena gyoori keŋ fa Iseraetena?” ");
INSERT INTO ntr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Botɔɔ te Yesu tiranɔɔ fa wɔ nyi, “Ka te yɛɛ kpene keŋ nyi ɛ ka gyeŋ debaŋ keŋ ya, nawolo nyi debaŋ keŋ na wee keŋ mena nombii kei gyae ke kɔŋ dɔɔ, kyae me kya gyaŋ. Ɔ doŋ dɔɔ te ɔ see ŋa. ");
INSERT INTO ntr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mɔna debaŋ keŋ Wurubuarɛ waa mo ɔ feliŋ ŋon do ɛ man nɛ, ɛ ke nyiŋ doŋ. Na ɛ ka bese ma adansɛɛtena Gyerusalɛm donɔɔ man, na Gyudia na Samaria tɛɛlese pou dɔɔ mo kelii tɛɛle pou ɔto.” ");
INSERT INTO ntr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ɔ kekolosi kɛŋa pou taŋ na, te Wurubuarɛ mo e laŋ adido be popou siaman ka gyoo ŋɔma man. Mena dɔɔ ba te naa e bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Be ka seŋ botɔɔ be sɛɛ bɛɛ kɛɛ adido fee nɛ, karatetee na tewulɛɛ bala baale seŋɛɛ laa ba yenaŋ na ba doona abɔɔ wolomɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Te be bɔɔse Yesu kpilala baŋ nyi, “Galeliatena, weera te ɛ seŋɛɛ ɛ ne kɛɛ adido fee mena? Yesu kei, ŋon Wurubuarɛ ba mo e lee ɛ gyaŋ laŋ adido nɛ, mena ke te waa bese kɔŋ ŋgba mena keŋ ɛ be naa e ɔ ne gyu adido nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Te ɔ kpilala baŋ besewɔ lee oliifi bula keŋ dɔɔ kɔŋ Gyerusalɛm. Lee botɔɔ kɔŋ Gyerusalɛm donɔɔ keŋ man benaa na dɔŋa. Gyae ke yɛɛ ŋgba wɔɔ ŋmeeseŋ sao na kufu nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba ke kɔŋ kaa gyoo Gyerusalɛm donɔɔ keŋ man nɛ, te ba gyeŋawɔ gyu abansoro deni be dɛɛkyae keŋ man. Balaŋ baŋ be kyaa botɔɔ yɛna, Pita na Gyɔn na Anderiase na Filipo na Tomase na Batolomeo na Mateo na Alfeose bu Gyemisi na Simɔn ŋon ɔ ne gyae ɔ balaŋ nideli nɛ, na Gyemisi bu Gyudase. ");
INSERT INTO ntr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Be popou na ala baale na Yesu ɔ naa Mɛɛre, na Yesu ɔ naabia ne yɛɛ na nɔɔdokoloŋ yilaa fane debaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wee daale balaŋ baŋ bɔɔ lɛɛ Yesu di nɛ kaa yilaawɔ, na baa yɛɛ ŋgba balaŋ sɔŋonoŋ na balaŋ sao nɛ (120). Botɔɔ te Pita korowɔ seŋ yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Me tebia, nombia ŋan Wurubuarɛ nombia be yako see lee Gyudase wose man nɛ, kaboena nyi ŋe dɛɛ kɔŋ mena. Gyudase kei wose man te gyoo Defidi yakowɔ see nyiaa, ŋon ne gyae la waa ta balaŋ baŋ baa gyu ke kyaŋ Yesu nɛ siaman.” ");
INSERT INTO ntr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nafɔ na Gyudase kei kpuɛ de man, nawolo nyi Yesu lese na ŋon mɔ nyi waa kpu na daa na dɛɛ yɛɛ tom kei. ");
INSERT INTO ntr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kɔba keŋ ŋon Gyudase be nyim lee ɔ nombiakumɛɛ kɛŋa keyɛɛ man nɛ, te ɔ moowɔ lɛɛ tɛɛle. Tɛɛle kenaŋ man te ɔ yalawɔ te ɔ tɔɔ bɛɛwɔ te ɔ loobia pou leewɔ. ");
INSERT INTO ntr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Balaŋ baŋ pou be kyaa Gyerusalɛm donɔɔ man nɛ nyii mena nombii kei, mena dɔɔ ba doo botɔɔ yele be dɛɛ dei man nyi Akɛledama, keŋ nawolo nyi Fatabo tɛɛle. ");
INSERT INTO ntr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Gyoo Defidi yako Gyudase wose man nombia Wurubuarɛ Nɔɔneŋ tɔne keŋ man nyi, “Ɔ dekpaŋalaŋ dɛɛ doo yakaa keŋ ŋolo na kyaa ke man ya.” Ɔ besewɔ yako nyi, “Walaŋ wɔle waa kyaa ɔ nawɔɔ man na waa yɛɛ ɔ tom.” ");
INSERT INTO ntr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mena dɔɔ kaboena nyi ŋolo waa kyaa ɔ nawɔɔ man kpu na daa, na dee di de Gbeŋgyoo Yesu kefoŋ lee yeŋ man keŋ adansɛɛ. Kaboena nyi walaŋ ŋonaŋ waa yɛɛ walaŋ ŋon na ɔ kpuɛ na daa debaŋ keŋ pou daa na de Gbeŋgyoo Yesu ne gyu dɛɛ kɔŋ, lee debaŋ keŋ Gyɔn be sɔ e Wurubuarɛ loŋ kelii debaŋ keŋ Wurubuarɛ ba mo e lee de gyaŋ gyu adido nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mena dɔɔ ba lese Gyosɛfo ŋon bɛɛ baake e nyi Basabase yaa Gyustuse nɛ na Matiase. ");
INSERT INTO ntr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Te be fanewɔ nyi, “De Gbeŋgyoo, nyaŋ gyeŋa na walaŋ kamasɛ konɔɔ man. Mena dɔɔ wola daa tewulɛɛ bala kɛwɔ man ŋon n ba lese nyi waa yɛɛ Yesu kpilale, ");
INSERT INTO ntr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na waa kyaa Gyudase ŋon ɔ be tina ɔ tom yela te ɔ be lam gyu botɔɔ keŋ kaboena e nɛ nawɔɔ man.” ");
INSERT INTO ntr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mena dɔɔ be lɔɔ boe, te boe keŋ yalawɔ Matiase yele dɔɔ. Kei nawolo nyi ŋon te Wurubuarɛ lesewɔ, te ba moo e kpu Yesu kpilala kufu daale baŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gyudatena wee dinaa keŋ bɛɛ baake ke nyi Pentekosite keŋ kelii nɛ, baŋ pou bɔɔ lɛɛ Kristo Yesu di nɛ ke yilaawɔ debodokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Karatetee dokoloŋ te be nyii nkaŋ daale lee adido ŋgba feliŋ dinaa daale ne gyɔɔ la nɛ, te ke kaa lɛɛ dekpaŋalaŋ keŋ man be kyaa nɛ pou. ");
INSERT INTO ntr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Botɔɔ te be naa kolo ŋgba boalaŋ laakemse nɛ, te ŋe yaaseewɔ kaa gyakaa walaŋ kamasɛ nyee dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Te Wurubuarɛ moo ɔ feliŋ ŋon do be popou man, te be fiasɛɛ bɛɛ kolosi deise kpookpoo ŋgba mena keŋ Wurubuarɛ feliŋ ŋon be fa wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Debaŋ kenaŋ na Gyudatena baŋ bee yee Wurubuarɛ te bɔɔ lee tɛɛle kei dɔɔ pou nɛ, kyaa Gyerusalɛm donɔɔ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Be kenyii mena nkaŋ kei nɛ, te balaŋ burum kaa yilaawɔ. Balaŋ baŋ pou wose yeŋa wɔ nawolo nyi walaŋ kamasɛ nyiiwɔ ŋgba bee kolosi ɔ dɛɛ dei nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yɛɛ wɔ gyakoloŋ te be bɔɔse dɔŋa nyiaa, balaŋ anekoloseŋ kɛwɔ pou te yɛɛ Galeliatenawɔ yee? ");
INSERT INTO ntr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Te weera de man walaŋ kamasɛ ne nyii bee kolosi ŋon gbagba ɔ dɛɛ dei? ");
INSERT INTO ntr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","De popou lee tɛɛlese kpookpoo dɔɔ. De man baale lee Patia na Media na Elam te baale mɔ lee Mesopotamia na Gyudia na Kapadosia, te baale mɔ lee Pɔntuse na Esia. ");
INSERT INTO ntr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Baale lee Firigia na Pamfilia na Igyipite te baale mɔ lee Libia tɛɛlese ŋaale ŋan benaa na donɔɔ keŋ bɛɛ baake ke Kirene nɛ man. ");
INSERT INTO ntr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Gyudatena na baŋ ba te yɛɛ Gyudatenawɔ ya te bɔɔ kyɛɛkee gyoo Gyudatena ɔsom man nɛ, man baale mɔ lee Roman donɔɔ man kɔŋ. De baale mɔ lee Kreti na Arebia, mɔna dee nyii bee kolosi nombia dinaana ŋan Wurubuarɛ be yɛɛ nɛ daa gbagba de deise man. ");
INSERT INTO ntr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gyakoloŋ gyoo wɔ te ba nyeeya man mɔ yɛɛ wɔ basaa te be bɔɔse dɔŋa nyiaa, na nombia kɛŋa asɛɛ yɛna sena baa? ");
INSERT INTO ntr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mɔna be man baale mɔ kulu wɔ nyi kei dɔɔ be dɛɛsee. ");
INSERT INTO ntr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Botɔɔ te Pita na ɔ tebia Yesu kpilala kufu daale baŋ korowɔ seŋ, te ɔ gyinaa ɔ woya kolosi fa balaŋ dikpii keŋ nyiaa, “Me tebia Gyudatena na ɛmɛɛ baŋ pou ɛ kyaa Gyerusalɛm nɛ, ɛ tei me gyaŋ nideli na maa wola ŋon kpene keŋ nombii kei nawolo. ");
INSERT INTO ntr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ne yɛɛ ŋon nyi balaŋ kɛwɔ dɛɛsee, mɔna na be dɛɛsee ya. Nawolo nyi nebo weese gba yaa, nɛnɛɛ te gyɔɔ debaŋ kadaale. ");
INSERT INTO ntr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mɔna nombii kei yɛna kpene keŋ Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyowɛle be kolosi see nyi ke gyae ke kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Wurubuarɛ dekpeŋkpeŋgyɔɔre Gyowɛle yakowɔ see nyi, ‘Wurubuarɛ kpa, “Tɛɛle kei na benaa kɔ ɔto na, maa mo me feliŋ do walaŋ kamasɛ man. Ɛ bia ala na baala baa kolosi nombia see ma yele man. Ɛ tewulɛɛ baa naa me nombia ŋan ŋe doo na ŋe gbɛɛ nɛ na be sia ŋgba dosɛɛ man nɛ. Akpegyiina mɔ baa doosi naa me nombia ŋan ŋe doo na ŋe gbɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Debaŋ kenaŋ man nɛ maa mo me feliŋ do ma alebia na me tewulɛɛ man na baa kolosi nombia see ma yele man. ");
INSERT INTO ntr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Maa yɛɛ gyakoloŋ nombia adido, na maa lese me wɔɔle wola tɛɛle kei dɔɔ. Ɛ gyae ɛ kena fatabo na boalaŋ na nyɔɔse tuum. ");
INSERT INTO ntr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Weeseteŋteŋ gyae ka bese ditiŋtɛɛ tuum na gyaalaŋ ke yase ŋgba fatabo nɛ. Nombia kɛŋa pou gyae ke kɔŋ, pɛte wee dinaa keŋ de Gbeŋgyoo waa lese ɔ gyoorobiiri wola nɛ kelii. ");
INSERT INTO ntr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Te walaŋ kamasɛ ŋon waa baake de Gbeŋgyoo Wurubuarɛ yele na, waa lɛɛ ɔ nyee.” ’ ");
INSERT INTO ntr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita gyina ɔ kekolosi keŋ dɔɔ nyiaa, Iseraetena, ɛ tei nombia kɛŋa nideli. Wurubuarɛ tɛɛwɔ Yesu Nasarɛte baale ŋon dɔɔ yɛɛ gyakoloŋ nombia lese ɔ wɔɔle wola ɛ man ŋgba mena keŋ ɛmɛɛ gbagba ɛ gyeŋ nɛ. Kɛŋa diina adansɛɛ nyi Wurubuarɛ kpila na e. ");
INSERT INTO ntr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lee Wurubuarɛ gbagba kegyaebii na ɔ ka gyeŋ man te ɔ wulaa bakewɔ see nyi baa lese Yesu fa ŋon, te ɛ yela balaŋ kumɛɛ gyɔɔ e ɔpaŋdaŋ dɔɔ ko. ");
INSERT INTO ntr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mɔna Wurubuarɛ gyuusu e lee yeŋ man, te ɔ lese e lee yeŋ weeleŋ man, nawolo nyi yeŋ be tale kyaŋ e see ɔ gyaŋ kekpaakekpaa ya. ");
INSERT INTO ntr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gyoo Defidi yakowɔ lee Yesu wose man nyi, ‘Me naa de Gbeŋgyoo ŋon me siaman debaŋ kamasɛ. Ɔ seŋɛɛ ma yenaŋ mena dɔɔ kolo be tale tɛɛse maŋ ya, ");
INSERT INTO ntr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","mena dɔɔ me wɔe te fɛɛ maŋ, me sia mɔ ta gye. Me yɛɛ walaŋ ŋon maa yeŋ wee daale, mɔna me sia gyakaa abɔɔ ŋan Wurubuarɛ waa kaa fa man nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nawolo nyi n be gyae n ke yela maa dɔɔ yebɔɔ man ya. N be gyae n ke yela n walaŋ ŋon ayimɛɛ be doo ɔ man ya nɛ ke doo yebɔɔ man dala ya. ");
INSERT INTO ntr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","N ta wola maŋ nyeedoŋ gbɛɛ. Nawolo nyi n kpuɛ na maŋ dɔɔ te yɛɛ maŋ gyoŋ nideli.’ ");
INSERT INTO ntr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Me tebia, mɛɛ gyae maa yako ŋon kolo lee de naana Defidi wose man, ɔ yeŋawɔ te be wuu e, ɔ yebɔɔ sɛɛ doo de gyaŋ kɛbo kaa lii na gyɛŋ. ");
INSERT INTO ntr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na ɔ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e, te ɔ gyeŋ nombia ŋan Wurubuarɛ be kaŋ ntam yako see lee ɔ wose man nyi, waa mo Defidi duuluŋ man ŋolo see gyoo na waa kyaa ɔ gyoorogbeli keŋ dɔɔ di gyoori ŋgba ŋon Defidi nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gyoo Defidi naa kpene keŋ Wurubuarɛ waa kaa yɛɛ, mena dɔɔ ɔ kolosiwɔ lee Kristo kefoŋ lee yeŋ man wose man nombia nyi, ‘Wurubuarɛ te tina e yela yebɔɔ man na waa dala ya.’ ");
INSERT INTO ntr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wurubuarɛ te gyuusu Yesu kei lee yeŋ man, te de popou ne di adansɛɛ nyi nombii kei yɛɛ ampaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ɔ kya Wurubuarɛ gyinaa e adido te ɔ moo e see ɔ dunoluŋ dɔɔ te ɔ moo ɔ feliŋ ŋon fa e ŋgba mena keŋ ɔ be kaŋ ntam see nɛ. Mena feliŋ kei yaa Yesu moowɔ do de man gyɛŋ. Wurubuarɛ feliŋ kei tom yaa ɛ ne naa te ɛ ne nyii nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Gyoo Defidi gbagba te gyu adido ŋgba Yesu nɛ ya, mɔna ɔ talewɔ yako Yesu wose man nombia nyi, ‘De Gbeŋgyoo Wurubuarɛ ŋon yako me Gbeŋgyoo nyi, “Kyaa me dunoluŋ dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kelii debaŋ keŋ maa mo baŋ bɛɛ kɔla neŋ nɛ do n nawɔɔ tɛɛ.” ’ ");
INSERT INTO ntr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mena dɔɔ ɛmɛɛ Iseraetena pou ɛ gyeŋ nideli nyi, Yesu kei ŋon ɛ be gyɔ e nyeelabia ko ɔpaŋdaŋ dɔɔ nɛ, ŋon ke te Wurubuarɛ moowɔ yɛɛ de Gbeŋgyoo na da nyeelɛɛre ŋon ɔ be yako see nyi waa kɔŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Balaŋ baŋ kenyii nombia kɛŋa nɛ, takaa wɔ nideli te be bɔɔse Pita na Yesu kpilala akaŋ baŋ nyiaa, “De tebia, sena yaa dɛɛ yɛɛ?” ");
INSERT INTO ntr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Te Pita tiranɔɔ fa wɔ nyi, “Walaŋ kamasɛ waa kyɛɛkee lee ɔ nombiakumɛɛ man, na baa sɔ e Wurubuarɛ loŋ lee Yesu Kristo yele man, na Wurubuarɛ ka mo ɔ nombiakumɛɛ kyɛɛ e, na waa mo ɔ feliŋ ŋon do ɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wurubuarɛ nombii keŋ ɔ be yako see nyi waa mo ɔ feliŋ do ɛ man nɛ, yɛɛ ɛmɛɛ na ɛ bia na baŋ pou be kyaa lemlem, na baŋ pou de Gbeŋgyoo Wurubuarɛ waa baake wɔ kɔŋ ŋon gbagba gyaŋ nɛ wui.” ");
INSERT INTO ntr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita kolosiwɔ fa wɔ nideli te ɔ faree wɔ te ɔ sola wɔ nyi, “Ɛ lese ɛ wose lee tɛɛle kei dɔɔ balaŋ kumɛɛ kɛwɔ man, na Wurubuarɛ ke lɛɛ ɛ nyee.” ");
INSERT INTO ntr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Be man balaŋ burum lɛɛ ɔ nombia ŋan di, te be sɔɔ wɔ Wurubuarɛ loŋ. Balaŋ kakpoŋse batooro (3000) kaa kpu la na Kristotena dikpii keŋ mena wee kenaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Be kyaŋa Yesu kpilala baŋ kawola man nideli, te be popou ne yɛɛ nɔɔdokoloŋ gyaŋee debaŋ kamasɛ. Bɛɛ yɛɛ nɔɔdokoloŋ di weenɛɛ ŋan Yesu kpa baa di na baa mo tɔɔse e nɛ, te bɛɛ bese yɛɛ nɔɔdokoloŋ gyaŋee fane. ");
INSERT INTO ntr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesu Kpilala baŋ yɛɛ gyakoloŋ nombia burum, te gyakoloŋ gyoo balaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Baŋ pou bɔɔ lɛɛ Yesu di nɛ, yɛɛ nɔɔdokoloŋ ba kekyaa man, na bɛɛ kɛɛ ba abɔɔ ŋan be dana nɛ nyi yɛɛ be popou wui. ");
INSERT INTO ntr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te be yɔɔ ba abɔɔ ŋaale mɔ, na bɛɛ kpala kɔba keŋ fa walaŋ kamasɛ ŋgba mena keŋ ne hia e nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wee kamasɛ na, be dikpii keŋ ne gyaŋee be Wurubuarɛ ɔsom deni dinaa keŋ man. Bɛɛ yɛɛ nɔɔdokoloŋ te bɛɛ mo konɔɔ kpaakpaa, na sia kagye di weenɛɛ bom ba akpaŋalaŋse man. ");
INSERT INTO ntr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bɛɛ lese Wurubuarɛ yele, te balaŋ pou mɔ ne kɛlɛɛ wɔ. Te wee kamasɛ mɔ nɛ, de Gbeŋgyoo na mo balaŋ wɔlɛɛ baŋ ɔ ne lɛɛ ba nyeeya nɛ kaa kpu na wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wee daale balinɔɔ weese ŋgba debaŋ atoorote man nɛ, Pita na Gyɔn korowɔ gyu Wurubuarɛ ɔsom deni dinaa keŋ man nyi be kaa fane. Debaŋ kenaŋ yɛna kefane debaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na balee ŋolo kyaa keŋ ɔ yɛɛ ɔtakase e leenaŋ ɔ biatɛɛ. Wee kamasɛ nɛ bɛɛ mo e kaa see Wurubuarɛ ɔsom deni dinaa denanɔɔ keŋ bɛɛ baake ke nyi Denanɔɔ Kyeote nɛ man, na waa sola kɔba lee balaŋ baŋ bɛɛ gyoo deni kenaŋ man nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Debaŋ keŋ ɔ be naa nyi Pita na Gyɔn ne kɔŋ be kaa gyoo deni dinaa keŋ man nɛ, te ɔ sola wɔ nyi baa fa e kɔba. ");
INSERT INTO ntr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Keŋte be kɛɛ e yididi te Pita yako e nyiaa, “Kɛɛ daa.” ");
INSERT INTO ntr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Te balee ŋon mɔ kɛɛ wɔ gyakaa loo nyi, waa nyiŋ kolo lee be gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Te Pita yako e nyi, “Nyi kɔba na, mɔɔ dana ŋaale maa fa neŋ ya, mɔna kpene keŋ me dana nɛ te maa fa neŋ. Lee Yesu Kristo Nasarɛte baale ŋon yele man nɛ, koro seŋ na n ke ta,” ");
INSERT INTO ntr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Te Pita kyaŋa ɔ dunoluŋ nyiŋmaa man kyɔ e te ɔ korowɔ seŋ. Debokenaŋ man te ɔ doona na ɔ nawɔɔ pou yɛɛ e doŋ. ");
INSERT INTO ntr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Karatetee dokoloŋ te ɔ toŋawɔ seŋ ɔ nawɔɔ dɔɔ, te ɔ fiasɛɛ ɔ ne tɛɛ. Keŋte ɔ sila wɔ gyoo Wurubuarɛ ɔsom deni dinaa keŋ man ɔ dɔŋɛɛ na ɔ na toŋee na ɔ na lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Balaŋ baŋ pou be kyaa botɔɔ nɛ, naa e na ɔ dɔŋɛɛ ɔ na lese Wurubuarɛ yele. ");
INSERT INTO ntr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Te be ka gyeŋ e nyi ŋon yɛna walaŋ ŋon nafɔ ɔ ne kyaa Denanɔɔ Kyeote keŋ man solee abɔɔ nɛ, ba wose yeŋa wɔ gbaa, te gyakoloŋ gyoo wɔ lee kpene keŋ bɔɔ naa ɔ man nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Balaŋ baŋ kena balee ŋon mataa na Pita na Gyɔn botɔɔ keŋ bɛɛ baake nyi Solomɔn poto man nɛ, doo be popou nɔɔ te be yeuwɔ gyu be gyaŋ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita kena balaŋ baŋ nɛ ɔ bɔɔse wɔ nyiaa, “Iseraetena, weera dɔɔ te kei ne doo ɛ nɔɔ? Yaa weera dɔɔ te ɛ ne kɛɛ daa fee mena? Ɛ fɛɛ ɛ sia baa ɛ ne kɛɛ daa nyi mberem daa gbagba de doŋ na de Wurubuarɛ keyee dɔɔ te de yela balee kei tɛɛwɔ? ");
INSERT INTO ntr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","De naanaɔ Aberaham na Asiki na Gyekɔpo Wurubuarɛ ŋon ɔ yɛɛ de naanaɔ pou Wurubuarɛ e nɛ, lesena ɔ tobaale Yesu gyoorobiiri wola. Ɛmɛɛ moona e do Romantena kegyiise nyiŋmaa man, te ɛ bɛɛ e Pilato siaman nyi baa ko e, mɔna nafɔ ɔ yɛɛ wa agyueŋ koraŋ nyi waa tina e yela, nyi ɔ te naa dukum ɔ man ya. ");
INSERT INTO ntr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɛ bɛɛ Yesu ŋon ayimɛɛ be doo ɔ man ya te ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman man nɛ, te ɛ sola Pilato nyi waa tina awudiini Barabase ŋon bɔɔ kyaŋ tɔ deni nɛ yela fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Te ɛ koo Yesu ŋon ɔ ne fa balaŋ nyeedoŋ kekpaa nɛ. Mɔna Wurubuarɛ gyuusu e lee yeŋ man keŋ de popou ne di ka wose man adansɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mena keŋ dɔɔ lɛɛ Yesu di dɔɔ, te Wurubuarɛ yela balee aseŋaŋ ɛ siaman kei ŋon ɛ gyeŋ e nɛ, nyiŋa kawee kekyɔ. Ke yɛɛ ampaŋ nyi mena keŋ dɔɔ lɛɛ Yesu di dɔɔ, te balee kei nyiŋa wosedoŋ, ŋgba mena keŋ ɛ ne naa e nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Me tebia, ma gyeŋ nyi kpene keŋ ɛmɛɛ na ɛ siamantena be yɛɛ Yesu nɛ, ɛ ta gyem bo ya. ");
INSERT INTO ntr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lee gyaŋgba gyaŋgba keŋ, te Wurubuarɛ tɛɛwɔ wa akpeŋkpeŋgyɔɔra pou dɔɔ yako see nyi, nyeelɛɛre ŋon ɔ be yako see nyi waa kɔŋ nɛ, waa naa diyem. Wurubuarɛ yele la nombia kɛŋa pou kɔŋawɔ mena. ");
INSERT INTO ntr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mena dɔɔ ɛ kyɛɛkee lee ɛ gbɛɛneŋ kumɛɛ man, na ɛ kekɔŋ Wurubuarɛ gyaŋ, na waa gberaa ya ayimɛɛ pou lee ɛ wose man. ");
INSERT INTO ntr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na de Gbeŋgyoo Wurubuarɛ kefa ŋon wosefɛɛreŋ na waa yela ŋon ɔ yɛɛ nyeelɛɛre ŋon ɔ be wula lese e see fa ŋon nɛ kekɔŋ. Ŋon yɛna Yesu. ");
INSERT INTO ntr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kaboena nyi waa kyaa adido kelii debaŋ keŋ Wurubuarɛ waa yɛɛ kpene kamasɛ wɔle, ŋgba mena keŋ Wurubuarɛ be tɛɛ wa akpeŋkpeŋgyɔɔra dɔɔ yako see gyaŋgba keŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Na Mosesi mɔ yɛɛ Wurubuarɛ dekpeŋkpeŋgyɔɔre e, ɔ yakowɔ see nyi, ‘Ɛ Gbeŋgyoo Wurubuarɛ waa lese dekpeŋkpeŋgyɔɔre lee ɛmɛɛ gbagba ɛ balaŋ man fa ŋon, ŋgba maŋ Mosesi nɛ. Ɛ tei kpene kamasɛ keŋ waa yako ŋon nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Walaŋ kamasɛ ŋon ɔ te tei kpene keŋ dekpeŋkpeŋgyɔɔre kei waa yako ya nɛ, Wurubuarɛ waa lese e lee ɔ balaŋ man na waa yo.’ ");
INSERT INTO ntr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ Wurubuarɛ be tɛɛ be dɔɔ kolosi nɛ pou, lee Samuɛle dɔɔ kelii baŋ bɔɔ kɔŋ ɔ wɔle pou nɛ, be wula yako kolo see lee nombia ŋan ne kɔŋ weeya kɛŋa man nɛ man. ");
INSERT INTO ntr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nombia ŋan pou Wurubuarɛ be tɛɛ wa akpeŋkpeŋgyɔɔra dɔɔ yako see nɛ yɛɛ ɛ wui, te ɛmɛɛ mɔ kpuɛ kebakesee keŋ Wurubuarɛ be bake na ɛ naanaɔ nɛ man. Nawolo nyi ɔ yako Aberaham nyi, ‘N duuluŋ man te maa ta hiraa tɛɛle kei dɔɔ balaŋ pou.’ ");
INSERT INTO ntr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mena dɔɔ debaŋ keŋ Wurubuarɛ ba lese ɔ tobaale Yesu nɛ, ɔ yela ɔ taŋgbɛɛwɔ kɔŋ ɛ gyaŋ nyi ɔ kaa hiraa ŋon, na waa yela ɛ man walaŋ kamasɛ kekyɛɛkee lee ɔ gbɛɛneŋ kumɛɛ man.” ");
INSERT INTO ntr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Debaŋ keŋ Pita na Gyɔn sɛɛ bɛɛ kolosi fa balaŋ baŋ nɛ, te Wurubuarɛ saese na kegyia ŋon ɔ ne kɛɛ balaŋ baŋ bɛɛ gyee Wurubuarɛ ɔsom deni dinaa keŋ nɛ, na balaŋ baŋ bɛɛ baake wɔ nyi Sadukiitena nɛ baale kɔŋawɔ be gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba gyeŋa baŋ nideli nawolo nyi, Pita na Gyɔn na wola balaŋ baŋ nyi, Yesu te fom lee yeŋ man, keŋ nawolo nyi balaŋ pou baa foŋ lee yeŋ man bela. ");
INSERT INTO ntr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mena dɔɔ be kyaŋa Pita na Gyɔn ka do deni man, na tɛɛ te lam dɔɔ, be yela be doowɔ kelii tɛɛ kena. ");
INSERT INTO ntr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mɔna balaŋ baŋ bɔɔ nyii nombia ŋan Pita na Gyɔn be yako nɛ, be man burum lɛɛ ŋa di, mena dɔɔ balaŋ baŋ pou bɔɔ lɛɛ Yesu di nɛ, be man baala wukuwɔ kelii balaŋ kakpoŋse banoŋ (5000). ");
INSERT INTO ntr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tɛɛ kena keŋ nɛ, Gyudatena kegyiise na be siamantena na ba mmaraa wolala baŋ gyaŋeewɔ Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Be gyaŋeewɔ na saese pou kegyia Anase na Kaifase na Gyɔn na Alɛkesanda na baala baale baŋ bɔɔ lee saese pou kegyia ŋon dekpaŋalaŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Be yela ba moo Pita na Gyɔn kaa seŋ be siaman te be bɔɔse wɔ nyi, “Woŋ wɔɔle yaa amɔte yele man yaa ɛ kyɔɔ balee ŋon?” ");
INSERT INTO ntr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Te Pita ŋon Wurubuarɛ feliŋ ŋon doo ɔ man nideli nɛ, tiranɔɔ fa wɔ nyi, “Kegyiise na siamantena, ");
INSERT INTO ntr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","akpaa gyɛŋ ɛ te baake daa kaa seŋ ɛ siaman ɛ ne bɔɔse daa lee kolo kpaakpaa keŋ dɔɔ yɛɛ, te ɔtakase ŋon be nyiŋ doŋ koro seŋ nɛ dɔɔ na, ");
INSERT INTO ntr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kenaŋ na mɛɛ gyae ɛmɛɛ na Iseraetena pou ka gyeŋ nyi, Yesu Kristo ŋon ɔ ba lee Nasarɛte nɛ yele man yaa balee aseŋaŋ ɛ siaman kei nyiŋa doŋ nɛ. Ŋon te ɛ gyɔɔwɔ sakaa ɔpaŋdaŋ dɔɔ ko, te Wurubuarɛ gyuusu e lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu yɛna walaŋ ŋon Wurubuarɛ nombia tɔne be yako nyi, ‘Boe keŋ ɛmɛɛ deni maara baŋ be bɛɛ ke nɛ, keŋ kaa bese na deni mokɔɔ kasee boe keŋ ne yeli deni keŋ ne yɛɛ doŋ nideli.’ ");
INSERT INTO ntr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu waageŋ kooŋ yɛna nyeelɛɛre, ŋon waageŋ kooŋ te Wurubuarɛ lesewɔ tɛɛle kei dɔɔ nyi de baake ɔ yele na waa lɛɛ da nyee.” ");
INSERT INTO ntr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mena keŋ Pita na Gyɔn be kolosi nideli te ba te yee gyakoloŋ ya, te kegyiise baŋ kenyii nyi be yɛɛ balaŋ yakaa nyibaŋwɔ keŋ be te gyu sukuu ya nɛ, ba wose yeŋa wɔ. Botɔɔ te be naawɔ nyi baŋ na Yesu tɛɛ la. ");
INSERT INTO ntr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mɔna ba kena balee ŋon bɔɔ kyɔ e seŋɛɛ Pita na Gyɔn gyaŋ botɔɔ nɛ, ba te tale nyiŋ nombiikum daale yako lee ba wose man ya. ");
INSERT INTO ntr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mena dɔɔ be yako wɔ nyi baa lee nombia dedii deni keŋ man, botɔɔ te kegyiise baŋ moo ba nyeeya baŋ na dɔŋa. ");
INSERT INTO ntr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bɛɛ bɔɔse dɔŋa nyi, “Woŋ yaa dɛɛ yɛɛ balaŋ kɛwɔ? Walaŋ kamasɛ ŋon ɔ kyaa Gyerusalɛm donɔɔ man nɛ, gyeŋ nyi baŋ yɛɛna gyakoloŋ nombii kei, te dɔɔ gyae dɛɛ tale lɛɛ ka aŋmaareŋ ya. ");
INSERT INTO ntr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mena keŋ dɔɔ ne gyae nyi baa mo nombia kɛŋa kpeŋkpeleŋ dɔɔ ya nɛ, ɛ yela dɛɛ tɔ wɔ nideli nyi be na tekaa kolosi Yesu kei nombia fa walaŋ na walaŋ ya.” ");
INSERT INTO ntr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mena dɔɔ be baake wɔ gyoo be gyaŋ bela, te be tɔɔ wɔ nyi be na tekaa kolosi Yesu nombia, yaa baa wola balaŋ kolo lee ɔ yele man korakora bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Keŋte Pita na Gyɔn tiranɔɔ nyi, “Ɛmɛɛ gbagba ɛ kɛɛ nombia kɛŋa man nideli nyi woŋti dei la Wurubuarɛ siaman? Dee nyii ɛ wui yaa dee nyii Wurubuarɛ wui? ");
INSERT INTO ntr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nawolo nyi daa dɔɔ, dɔɔ tale tina kpene keŋ dɔɔ naa, na keŋ dɔɔ nyii nɛ kekolosi yela ya.” ");
INSERT INTO ntr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mena dɔɔ kegyiise baŋ tɔɔ wɔ nideli bela, te be tina wɔ yela. Be te nyiŋ gbɛɛ keŋ baa mo wɔŋ ba deŋela ya, nawolo nyi balaŋ baŋ pou na lese Wurubuarɛ yele lee kpene keŋ ɔ be yɛɛ nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Balee ŋon bɔɔ kyɔ e kawee kei nɛ, kela kulutooneŋ sɔŋola (40). ");
INSERT INTO ntr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Be ke tina Pita na Gyɔn yela nɛ, te ba besewɔ gyu be tebia gyaŋ keyako wɔ kpene kamasɛ keŋ saese kegyiise na donɔɔ kegyiise baŋ be yako wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kristotena baŋ kenyii nombia ŋenaŋ nɛ, be popou moo nɔɔdokoloŋ fane fa Wurubuarɛ nyi, “De Gbeŋgyoo, nyaŋ ŋon n be yɛɛ adido na ateta, na ɛpo na kpene kamasɛ keŋ doo ŋe man. ");
INSERT INTO ntr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nyaŋ tɛɛ la n feliŋ ŋon dɔɔ te n yela de naana Defidi ŋon ɔ yɛɛ n tobaale e nɛ yakowɔ nyi, ‘Weera dɔɔ te tɛɛle kei dɔɔ balaŋ na gyeŋee baŋse, te bɛɛ bake nombiakumɛɛ yakaa yakaa, mɔna ŋe bee dee ya nɛ? ");
INSERT INTO ntr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tɛɛle kei dɔɔ gyooneŋ ne desina ba wose fa yoo, te siamantena baŋ mɔ na koro seŋ tia de Gbeŋgyoo Wurubuarɛ na nyeelɛɛre ŋon ɔ be yako see nyi waa kɔŋ nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ampaŋ te gyoo Herode na Pɔntiɔse Pilato na Iseraetena na baŋ mɔ ba te yɛɛ Iseraetenawɔ ya nɛ, gyaŋeewɔ donɔɔ kei man te be bakewɔ tia n tobaale Yesu ŋon ayimɛɛ be doo ɔ wose man ya, te nyaŋ Wurubuarɛ ba mo e yɛɛ nyeelɛɛre na gyoo nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Be gyaŋeewɔ te be yɛɛ kpene keŋ nyaŋ Wurubuarɛ n be wula yako see nyi gyae kekɔŋ nɛ, lee n doŋ na n kegyaebii man. ");
INSERT INTO ntr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nɛnɛɛ de Gbeŋgyoo Wurubuarɛ, kɛɛ mena keŋ bɛɛ ŋmaase daa na n ka do daa n tewulɛɛ kakyeŋ na dɛɛ tale gyɔ de konɔɔ kolosi n nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wurubuarɛ koro seŋ na n kekyɔ kaweese, na n ke ta de dɔɔ yɛɛ gyakoloŋ nombia lese n wɔɔle wola lee n tobaale Yesu ŋon ayimɛɛ be doo ɔ wose man ya nɛ yele man.” ");
INSERT INTO ntr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba ke fane taŋ keŋ nɛ, te botɔɔ keŋ bɔɔ gyaŋee nɛ wosiwɔ te Wurubuarɛ feliŋ ŋon kaa gyoowɔ be popou man nideli te be gyɔɔ be konɔɔ kolosi Wurubuarɛ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Balaŋ baŋ pou bɔɔ lɛɛ Kristo Yesu di nɛ, kyaawɔ nɔɔdokoloŋ man te ba agyueŋ mɔ yɛɛ dokoloŋ. Ŋolo bɛɛ yako nyi ɔ kolo yɛɛ waageŋ wui ya, mɔna be kpɛlɛɛ ba abɔɔ pou fa dɔŋa. ");
INSERT INTO ntr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yesu kpilala baŋ moo Wurubuarɛ doŋ dinaa keŋ di adansɛɛ nyi, de Gbeŋgyoo Yesu te fom lee yeŋ man, te Wurubuarɛ moo ɔ bɛrɛɛ boele baŋ pou bɔɔ lɛɛ Yesu di nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kolo te hia be man ŋolo ya, nawolo nyi baŋ be dana denɛɛ na tɛɛlese nɛ yɔɔ ŋa na bɛɛ mo kɔba keŋ bɔɔ nyim nɛ, ");
INSERT INTO ntr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kɔna Yesu kpilala baŋ na be ta mo kpala fa wɔ. Bɛɛ fa walaŋ kamasɛ ŋgba mena keŋ ne hia e nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mena ke te Lewi baale ŋolo ŋon ɔ ba lee Saiporɔse tɛɛle man, te ɔ yele yɛna Gyosɛfo nɛ yɛɛwɔ. Yesu kpilala baŋ doo e yele nyi Banabase, keŋ nawolo nyi walaŋ ŋon ɔ na do balaŋ kakyeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ŋon mɔ ka moo ɔ tɛɛle keŋ ɔ dana nɛ yɔɔ, te ɔ moo kɔba keŋ ɔ be nyim nɛ kaa fa Yesu kpilala baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Balee ŋolo kyaawɔ keŋ bɛɛ baake e nyi Ananiase, na ɔ wɛɛle mɔ yele yɛna Safira. Baŋ mɔ gyuuwɔ ka mo ba agyapadɛɛ daale yɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ŋon na ɔ wɛɛle yɛɛ nɔɔ te ba moo kɔba keŋ bɔɔ nyim nɛ man ŋaale weese, te baale ŋon moo akaŋ keŋ gyu kefa Yesu kpilala baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Botɔɔ te Pita bɔɔse e nyi, “Ananiase, weera dɔɔ te n yela ɔbɔnsam dii n dɔɔ mena, te ɔ yela n dii dekara fa Wurubuarɛ feliŋ ŋon, te n moo n kɔba keŋ n be nyim lee agyapadɛɛ keŋ n be yɔɔ nɛ man ŋaale weese? ");
INSERT INTO ntr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Agyapadɛɛ keŋ te yɛɛ n wui pɛte n yɔɔ ke yee? N yɔɔ ke taŋ mɔna kɔba keŋ n be nyim nɛ te yɛɛ n wui yee? Nɛnɛɛ weera n bakewɔ n konɔɔ man te n yɛɛ nombiikum kei mena? Na denibalaŋ te n dii dekara fa ya, Wurubuarɛ te n dii dekara fa.” ");
INSERT INTO ntr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiase ka betaa nyii nombia kɛŋa pɛ, te kara e lɔ te ɔ yeŋawɔ. Mena dɔɔ gyakoloŋ gyoo baŋ pou bɔɔ nyii nombia ŋenaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Keŋte tewulɛɛ kɔŋawɔ kaa mo kolo milii e, te be gate e lee gyu kewuu. ");
INSERT INTO ntr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Te kyare ya te ɔ wɛɛle ŋon mɔ kaa gyoowɔ botɔɔ mɔna ŋon ba gyeŋ kpene keŋ be kɔŋ ya. ");
INSERT INTO ntr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Te Pita bɔɔse alo ŋon nyiaa, “Yako maŋ, kɔba keŋ ɛmɛɛ na n baale Ananiase be nyim lee agyapadɛɛ keŋ keyɔɔ man pou yaa ɔ moowɔ kɔŋ nɛ?” Te ɔ tiranɔɔ nyi ayi, mena te de yɔɔ ke. ");
INSERT INTO ntr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Botɔɔ te Pita bɔɔse e nyi, “Weera te ɛmɛɛ na n baale yɛɛ nɔɔ nyi ɛ kekɛɛse de Gbeŋgyoo feliŋ ŋon kɛɛ! Kɛɛ, balaŋ baŋ bɔɔ moo n baale kewuu nɛ, baŋ seŋɛɛ la denanɔɔ man nɛ, baa seele nyaŋ mɔ lee.” ");
INSERT INTO ntr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Karatetee dokoloŋ te kara ŋon mɔ lɔ Pita nawɔɔ tɛɛ te ɔ yeŋawɔ. Tewulɛɛ baŋ kekɔŋ kaa gyoo te ba kena nyi ŋon mɔ ta yem nɛ, te ba mo e lee gyu kewuu ɔ baale yenaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mena dɔɔ gyakoloŋ dinaa daale gyoo Kristotena dikpii keŋ pou, na baŋ pou bɔɔ nyii nombia kɛŋa nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu kpilala baŋ yɛɛ gyakoloŋ nombia na nombia dinaana burum balaŋ baŋ man. Te baŋ pou bɔɔ lɛɛ Yesu Kristo di nɛ, ne gyu ke yilaa Solomɔn poto keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na balaŋ ne bu wɔ nideli, mɔna balaŋ yenaasetena baŋ yee mena keŋ baa kaa kpu na wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mɔna ala na baala burum lɛɛ de Gbeŋgyoo Yesu di, te Wurubuarɛ moo wɔ kaa kpu na Kristotena baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lee gyakoloŋ nombia ŋan Yesu kpilala baŋ ne yɛɛ dɔɔ, balaŋ na mo be kaweesetena kaa doosi afoŋoŋse na mpase dɔɔ gbɛɛnaa nɔɔman, na akpaa Pita de kɔŋ ɔ ne lam na ɔ wɔŋtaa ke yala be man baale dɔɔ, na baa nyiŋ kawee kekyɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Balaŋ lee donɔɔse ŋan benaa na Gyerusalɛm nɛ kɔŋ Gyerusalɛm donɔɔ keŋ man, te ba moo be kaweesetena na baŋ feliŋkumɛɛ ne naase wɔ diyem nɛ kɔŋ te be kyɔɔ wɔ pou. ");
INSERT INTO ntr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mena dɔɔ Wurubuarɛ sae kegyia ŋon, na ɔ kegyiise na baŋ bɔɔ lee Sadukiitena dikpii man nɛ sia yɛɛwɔ Yesu kpilala baŋ dɔɔ, te be bakewɔ see nyi baa gyae kolo yɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mena dɔɔ be kyaŋa Yesu kpilala baŋ te ba moo wɔ ketɔ deni. ");
INSERT INTO ntr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mɔna ke nelim nɛ, de Gbeŋgyoo Wurubuarɛ kpilale kɔŋawɔ kaa toro deni keŋ fa wɔ, te ɔ moo wɔ lee deni keŋ man, te ɔ yako wɔ nyi, ");
INSERT INTO ntr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ɛ gyu ka seŋ Wurubuarɛ ɔsom deni dinaa keŋ man na ɛ kekolosi nyeedoŋ wɔle kei wose man nombia fa balaŋ baŋ pou.” ");
INSERT INTO ntr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesu Kristo kpilala baŋ yɛɛwɔ ŋgba mena keŋ Wurubuarɛ kpilale ŋon be yako nɛ, mena dɔɔ nebo nebo fuu te be gyuuwɔ Wurubuarɛ ɔsom deni dinaa keŋ man, te be fiasɛɛ bɛɛ wola balaŋ baŋ. Wurubuarɛ Sae kegyia ŋon na ɔ kegyiise baake Gyudatena kegyiise baŋ pou, te be gyaŋeewɔ te be kpilawɔ nyi be ka mo Yesu kpilala baŋ lee deni keŋ man kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mɔna balaŋ baŋ bɔɔ kpili nɛ gyuuwɔ kelii botɔɔ na, ba te naa Yesu kpilala baŋ deni keŋ man ya. Mena dɔɔ ba besewɔ kɔŋ kaa yako kegyiise baŋ nyi, ");
INSERT INTO ntr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“De gyuu botɔɔ keŋ bɔɔ kyaŋ wɔ do nɛ na disim keŋ tɔɛ kiiŋ, na baŋ mɔ bee gyee ke nɛ seŋɛɛ be daseŋae man. Mɔna da toro disim keŋ na, da te naa Yesu kpilala baŋ deni keŋ man ya.” ");
INSERT INTO ntr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Debaŋ keŋ kegyia ŋon ɔ ne kɛɛ balaŋ baŋ bɛɛ gyee Wurubuarɛ ɔsom deni dinaa keŋ dɔɔ nɛ, na saese kegyiise baŋ be nyii nombia kɛŋa nɛ, ta seŋ wɔ nideli ya. Te be bɔɔse dɔŋa nyi, “Na woŋ yɛna tewulɛɛ kɛwɔ baa?” ");
INSERT INTO ntr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Botɔɔ te balee ŋolo kɔŋawɔ kaa yako wɔ nyi, “Ɛ nyii, balaŋ baŋ ɛ be kyam do deni man nɛ, seŋɛɛ Wurubuarɛ ɔsom deni dinaa keŋ man bɛɛ wola balaŋ Wurubuarɛ nombia.” ");
INSERT INTO ntr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mena dɔɔ kegyia ŋon ɔ ne kɛɛ balaŋ baŋ bee gyee Wurubuarɛ ɔsom deni dinaa keŋ dɔɔ nɛ, na ɔ tewulɛɛ gyuuwɔ ka moo wɔ kɔŋ kegyiise baŋ gyaŋ, mɔna be ta mo wɔ doŋ man ya, nawolo nyi bee yee nyi balaŋ baŋ baa fuŋii wɔ boya. ");
INSERT INTO ntr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Be ka mo wɔ kɔŋ nombiadiira baŋ siaman nɛ, te sae kegyia ŋon yako wɔ ");
INSERT INTO ntr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","nyi, “De faree ŋon nyi ɛ na wola kolo lee Yesu yele man ya, mɔna ɛ kɛɛ ya aneyɛɛŋ, ɛ ta mo ɔ nombia ŋan ɛ na wolo nɛ wulu Gyerusalɛm donɔɔ pou, te ɛ ne gyae ɛ ka mo ɔ yeŋ seele daa.” ");
INSERT INTO ntr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Botɔɔ te Pita na Yesu kpilala akaŋ baŋ tiranɔɔ nyi, “Kaboena nyi dee nyii Wurubuarɛ dei kela balaŋ wui.” ");
INSERT INTO ntr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","De naanaɔ Wurubuarɛ ŋon gyuusu na Yesu ŋon ɛ be gyɔɔ e sakaa ɔpaŋdaŋ dɔɔ ko e nɛ lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wurubuarɛ gyina e adido te ɔ mo e see ɔ dunoluŋ dɔɔ, te ɔ moo e yɛɛ siamante na nyeelɛɛre, na waa yela Iseraetena ke nyiŋ gbɛɛ kyɛɛkee lee be nombiakumɛɛ man na baa kɔŋ Wurubuarɛ gyaŋ, na waa mo be nombiakumɛɛ kyɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Daa ne diina nombia kɛŋa adansɛɛ. Wurubuarɛ feliŋ ŋon ɔ ba mo do baŋ bee nyii ɔ dei man nɛ, mɔ ne di nombia kɛŋa adansɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kegyiise baŋ bɔɔ gyaŋee nɛ nyii nombia kɛŋa na ba gyeŋa baŋ nideli, mena dɔɔ be gyaewɔ nyi baa ko Yesu kpilala baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mɔna be man ŋolo, ŋon ɔ doo Farasiitena dikpii keŋ man te bɛɛ baake e nyi Gamaleli, te ɔ yɛɛ Wurubuarɛ mmaraa keŋ wolale e, te ɔ wose man dana obuo donɔɔ keŋ man nɛ, korowɔ seŋ be man. Botɔɔ te ɔ yela ba lese Yesu kpilala baŋ yenaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Te ɔ yako kegyiise baŋ nyi, “Me tebia Iseraetena, ɛ kɛɛ kpene keŋ ɛ ne gyae ɛ ke yɛɛ balaŋ kɛwɔ nɛ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Debaŋ duguŋ daale kaa laŋawɔ na, balee ŋon bɛɛ baake e nyi Teudase nɛ korowɔ seŋ te ɔ yɛɛ ɔ wose ŋgba walaŋ dinaa ŋolo nɛ, te balaŋ sɔŋonoŋ akpeŋ anaara (400) korowɔ sila e. Mɔna be ka ko e na ɔ balaŋ baŋ pou mɔ yaaseewɔ, keŋte ɔ kawola keŋ pou mɔ kaa yɛɛwɔ yakaa. ");
INSERT INTO ntr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kei mɔ wɔle debaŋ keŋ bɛɛ kala balaŋ nɛ, te Galelia baale Gyuda korowɔ seŋ, te ŋon mɔ kaa beo balaŋ burum sila ɔ wose. Be ka ko ŋon mɔ nɛ, ɔ balaŋ baŋ pou bɔɔ sila e nɛ yaaseewɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mena dɔɔ nombia kɛŋa man nɛ, mɛɛ yako ŋon nyi ɛ na yɛɛ balaŋ kɛwɔ kolo ya. Ɛ yela baa ta, nawolo nyi akpaa kpene keŋ bɛɛ wolo te bɛɛ yɛɛ nɛ, lee deniwalaŋ gyaŋ na, keŋ mɔ gyae ke yɛɛ yakaa bo mena. ");
INSERT INTO ntr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mɔna akpaa ka lee Wurubuarɛ gyaŋ na, ɛ be gyae ɛ ke tale tɔ wɔ gbɛɛ ya. Ɛ kena bo nyi ɛ ne yoo bo na Wurubuarɛ.” Mena dɔɔ kegyiise baŋ mɔ yɛɛwɔ ŋgba mena keŋ Gamaleli be yako wɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mena dɔɔ be baake Yesu kpilala baŋ kɔŋ te be yela be tuku wɔ, te be tɔɔ wɔ nyi be na kolosi kolo lee Yesu yele man bela ya. Te be tina wɔ yela. ");
INSERT INTO ntr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesu kpilala baŋ ka lee kegyiise baŋ gyaŋ nɛ na be sia ta gye, nawolo nyi Wurubuarɛ te kɛɛ wɔ nyi baŋ mɔ kaboena nyi baa do wɔ desɛŋ lee Yesu dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Te wee kamasɛ na, bee gyu Wurubuarɛ ɔsom deni dinaa man na balaŋ akpaŋalaŋse man. Bɛɛ wola nombia kpaakpaa ŋan nyi Yesu yɛna Kristo, nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. Te be te tina nombia kɛŋa kawola yela ya. ");
INSERT INTO ntr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Weeya ala ŋenaŋ man na baŋ bɔɔ lɛɛ Yesu di nɛ korowɔ bee wuku te kekolosi kaa gyoo Gyudatena baŋ bɛɛ kolosi Giriki dei, na Gyudatena akaŋ baŋ man. Gyudatena baŋ bɛɛ kolosi Giriki dei nɛ, kpa Gyudatena akaŋ baŋ ne wuritii wɔ weenɛɛ kekpala man, nawolo nyi be kpa wee kamasɛ weenɛɛ ŋan bɛɛ kpɛlɛɛ nɛ, bee tuŋ baŋ wui liala baŋ ya. ");
INSERT INTO ntr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Keŋte Yesu kpilala kufu bala baŋ baake baŋ pou bɔɔ lɛɛ Yesu di nɛ gyaŋee, te be yako wɔ nyiaa, “Tekaboena nyi daa dɛɛ bese tina Wurubuarɛ nombia ŋan keyako yela, na dɛɛ kɔŋ kaa kɛɛ abɔɔ kekpɛlɛɛ dɔɔ bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mena dɔɔ de tebia, ɛ kɛɛ ɛ man na ɛ ka lese baala nyetooro baŋ ba wose man dana obuo, te Wurubuarɛ feliŋ ŋon doo be man nideli te be sia be kare mɔ nɛ, na dɛɛ mo mena tom kei do be nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na daa ke nyiŋ mo de doŋ pou do kefane, na Wurubuarɛ nombia ŋan keyako man.” ");
INSERT INTO ntr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nombia naŋ Yesu kaseela baŋ be yako nɛ, seŋa balaŋ baŋ pou nideli. Te ba lese Sitifin ŋon ɔ ne lɛɛ Wurubuarɛ di nideli te Wurubuarɛ feliŋ doo ɔ man nideli nɛ. Te ba besewɔ lese Filipo na Prokoro na Nikanɔ na Timɔn na Pamena na Nikolase ŋon ɔ ba lee Antiɔke te ɔ ba mo ɔ wose kpu Gyuda ɔsom keŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Keŋte ba moo balaŋ nyetooro kɛwɔ kaa seŋ Yesu kpilala baŋ siaman. Te ba moo be nyiŋmaase gyakaa be dɔɔ te be fanewɔ fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mena dɔɔ Wurubuarɛ nombia ŋan yaaseewɔ bileŋbileŋ, te baŋ bɔɔ lɛɛ Yesu di nɛ wukuwɔ burum Gyerusalɛm donɔɔ keŋ man. Te Wurubuarɛ saese burum baale mɔ lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Te Sitifin ŋon Wurubuarɛ ba mo ɔ bɛrɛɛ boele e nideli, te ɔ doŋ doo ɔ man nɛ yɛɛ gyakoloŋ nombia na nombia dinaana balaŋ baŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mɔna Gyudatena baale baŋ bɛɛ gyaŋee Gyudatena ɔsom deni keŋ bɛɛ baake ke nyi gbeŋa baŋ bɔɔ tina wɔ yela nɛ ɔsom deni man nɛ, fiasɛɛ bɛɛ lɛɛ aŋmaareŋ na Sitifin. Balaŋ benaŋ baale lee Kirene na Alɛkesanderia na Silisia na Esia tɛɛlese man. ");
INSERT INTO ntr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mɔna Wurubuarɛ feliŋ ŋon faa Sitifin nyansa te ɔ kolosiwɔ nideli mena dɔɔ be te nyiŋ keŋ baa yako bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Keŋ dɔɔ be gyuuwɔ ke feefu do balaŋ baale nyi baa di dekara gyakaa ɔ dɔɔ nyi, “De nyiiwɔ ɔ ne kolosi mmusuo nombia gyakaa de naana Mosesi na Wurubuarɛ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nnɛ te be wɔlɛɛ e fa balaŋ baŋ na ɔsom kegyiise na mmaraa wolala baŋ pou, te ba korowɔ seŋ ɔ dɔɔ te ba kyaŋa e gyu donɔɔ kegyiise siaman. ");
INSERT INTO ntr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mena dɔɔ be gyae balaŋ baale kɔŋ, te be kaa dii akɛrɛɛ gyakaa ɔ dɔɔ nyi, “Debaŋ kamasɛ na balee kei ne kolosi bo tia de Wurubuarɛ ɔsom deni dinaa keŋ, na Wurubuarɛ mmaraase ŋan Mosesi ba wola daa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nawolo nyi de nyiiwɔ ŋgba ɔ ne yako nyi, “Yesu ŋon ɔ ba lee Nasarɛte nɛ, waa yɛlɛɛ Wurubuarɛ ɔsom deni dinaa kei lɔ, na waa kyɛɛkee abɔɔ ŋan pou Mosesi ba mo see daa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Te nombiadiira baŋ be kyaa deni keŋ man nɛ, kɛɛ Sitifin nɛ yididi te be naawɔ ŋgba ɔ sia gbɛɛ te kyɛɛkee yɛɛ ŋgba Wurubuarɛ kpilale sia gbɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Keŋte Wurubuarɛ sae kegyia ŋon bɔɔse Sitifin nyi, “Mena dɔɔ nombia ba ayakoŋ kɛŋa pou yɛɛ ampaŋ?” ");
INSERT INTO ntr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Botɔɔ te Sitifin tiranɔɔ nyi, “Me tebia na me kyaɔ, ɛ tei me gyaŋ. Wurubuarɛ ŋon ɔ ne di gyoori nɛ lese na ɔ wose wola de naana Aberaham, debaŋ keŋ ɔ kyaa Mesopotamia tɛɛle man nɛ, kenaŋ wɔle pɛte ɔ korowɔ gyu kekyaa Haran donɔɔ man, ");
INSERT INTO ntr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","botɔɔ te Wurubuarɛ yako e nyi, ‘Koro lee n tɛɛle man na n loŋtona gyaŋ, na n ke tu gyu ke kyaa tɛɛle keŋ maa wola neŋ nɛ dɔɔ.’ ");
INSERT INTO ntr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mena dɔɔ Aberaham korowɔ lee Kaldea tɛɛle man, te ɔ gyuuwɔ kekyaa Haran donɔɔ man. Ɔ kya yeŋ wɔle nɛ, Wurubuarɛ moo e kaa see tɛɛle ya akyaŋ ke dɔɔ kei dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tɛɛle naetɔɔ dokoloŋ koraŋ ɔ te fa e botɔɔ nyi dɛɛ bese ŋon gbagba ɔ wui ya. Mɔna Wurubuarɛ yakowɔ see nyi, waa mo tɛɛle kenaŋ fa ŋon na ɔ duuluŋ man balaŋ. Debaŋ kenaŋ mɔ na Aberaham be dana bu koraŋ gba ya. ");
INSERT INTO ntr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Keŋte Wurubuarɛ yako e nyi, ‘N duuluŋ man balaŋ baa kyaa dei wɔle daale tɛɛle dɔɔ bese ŋɔɔla. Baa moo wɔ yɛɛ gbeŋa, na baa yɛɛ wɔ nyeemandoŋ na akpanyaŋnyaŋ kulutooneŋ sɔŋonoŋ akpeŋ anaara (400). ");
INSERT INTO ntr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mɔna maa wɔŋ tɛɛle kenaŋ mantena baŋ baa mo n duuluŋ man balaŋ baŋ yɛɛ gbeŋa nɛ deŋele. Kenaŋ wɔle na, n duuluŋ man balaŋ baŋ baa lee tɛɛle kenaŋ man, na be kaa som maŋ kɛbo kei.’ ");
INSERT INTO ntr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Te Wurubuarɛ na Aberaham bakewɔ see nyi, ŋon na ɔ duuluŋ man balaŋ pou baa kara ba baala wose. Mena dɔɔ Aberaham ka lola ɔ bu Asiki weeya gyanaarate nɛ te ɔ kara ɔ baala wose. Kenaŋ wɔle Asiki mɔ kaa lola Gyekɔpo, te Gyekɔpo mɔ lola de naanaɔ kufu bala baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Gyosɛfo mɔ yɛɛ de naanaɔ kufu bala baŋ man ŋolo e. Keŋ ɔ kegyiise ne kɔla e dɔɔ nɛ te ba mo e yɔɔ te ɔ ka bese gbeŋi Igyipite tɛɛle man, mɔna Wurubuarɛ seŋawɔ ɔ wɔle, ");
INSERT INTO ntr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","te ɔ lese e lee ɔ diyem pou man. Te ɔ fa e nyansa, te ɔ yela Igyipitetena gyoo Faaro gyae ɔ nombia, mena dɔɔ gyoo ŋon moo ɔ dekpaŋalaŋ na Igyipite tɛɛle keŋ pou do ŋon Gyosɛfo nyiŋmaa man nyi waa kɛɛ ŋe dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Debaŋ kenaŋ te tanam dinaa daale kaa yalawɔ Igyipite na Kaanan tɛɛlese pou dɔɔ, te ka moo kaale dinaa mɔ kaa lɔ be dɔɔ. Mena dɔɔ de naanaɔ baŋ te nyiŋ weenɛɛ baa di ya. ");
INSERT INTO ntr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Debaŋ keŋ Gyekɔpo be nyii nyi weenɛɛ kyaa Igyipite nɛ, te ɔ kpila ɔ bia de naanaɔ baŋ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Be ka bese gyu Igyipite bolate nɛ, Gyosɛfo lese ɔ wose wola ɔ kegyiise baŋ, te gyoo Faaro mɔ kaa gyeŋa Gyosɛfo ɔ loŋtona baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mena dɔɔ Gyosɛfo doo ɔ kya Gyekɔpo tiila nyi ŋon na ɔ balaŋ pou baa tu kɔŋ Igyipite. Be yaanɔɔle pou yɛɛ balaŋ sɔŋotooro na kufu banoŋ (75). ");
INSERT INTO ntr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mena dɔɔ Gyekɔpo gyuuwɔ ke kyaa Igyipite, te ŋon na ɔ bia pou yekeewɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba besena ba woya baŋ kɔŋ Sekyɛm donɔɔ man, te be kaa wuu wɔ boe bɔɔ keŋ Aberaham be kala kɔba lɛɛ lee Hamɔ bia gyaŋ nɛ man. ");
INSERT INTO ntr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Debaŋ keŋ Wurubuarɛ nombii ayakoŋ see fa Aberaham keŋ na benaa kekɔŋ ampaŋ nɛ, te de balaŋ baŋ be kyaa Igyipite nɛ wukuwɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kenaŋ wɔle nɛ, gyoo wɔle ŋolo ŋon ɔ ba gyeŋ kolo lee Gyosɛfo wose man ya nɛ, kaa dii gyoori Igyipite tɛɛle keŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mena dɔɔ ɔ yɛɛ de naanaɔ baŋ nyeemandoŋ na akpanyaŋnyaŋ, te ɔ ŋere wɔ dekpaŋkpasare man nyi baa tirii be bia wɔlɛɛ leki na baa nyiŋ yeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mena debaŋ kenaŋ man mɔ te ba lola Mosesi, mɔna ɔ te yɛɛ bu yakaate e Wurubuarɛ siaman ya. Ba weese e ɔ kya deni man te be kɛɛle e botɔɔ gyaalaŋna batooro. ");
INSERT INTO ntr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lii debaŋ daale na, be tira e leki debɔɔ man, te gyoo Faaro bu alebu naa e mo ke kɛɛle ŋgba ŋon gbagba ɔ bu nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba wola e Igyipitetena nyansa pou. Te ɔ kaa bese walaŋ dinaa ɔ kekolosi na ɔ tom keyɛɛ pou man. ");
INSERT INTO ntr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosesi kedi kulutooneŋ sɔŋola nɛ, te kɔŋawɔ ɔ nyeeman nyi waa koro gyu ke kɛɛ ɔ tebia Iseraetena kekyaa man. ");
INSERT INTO ntr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɔ ke gyu keŋ nɛ, ɔ ke naawɔ ŋgba Igyipite baale ŋolo ne naase Iserae baale ŋolo diyem na, te ɔ gyuuwɔ ke lɛɛ ɔ dɛɛ baale ŋon nɔɔ te ɔ koo Igyipite baale ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesi agyueŋ man na, ŋon gyeŋ nyi ɔ balaŋ baŋ baa nyii asɛɛ nyi Wurubuarɛ waa ta ɔ dɔɔ bo lese wɔ lee be kaale man, mɔna be te nyii asɛɛ mena ya. ");
INSERT INTO ntr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ke tɛɛ naa nɛ, ɔ ke naa Iseraetena wolɛɛwolɛɛ bala mɔ ne yoo, te ɔ gyuuwɔ ɔ kaa pataa wɔ te ɔ yako wɔ nyiaa, ‘Me tebia ɛ kɛɛ, ɛ wolɛɛwolɛɛ. Weera dɔɔ te ɛ ne yɛɛ dɔŋa akpanyaŋnyaŋ mena?’ ");
INSERT INTO ntr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mɔna ŋon ɔ ne yɛɛ ɔ dɔɔ akpanyaŋnyaŋ nɛ tɛɛse Mosesi lee yenaŋ te ɔ bɔɔse e nyiaa, ‘Amɔte moona neŋ yɛɛ de siamante na de nombiadiiri?’ ");
INSERT INTO ntr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘N ne gyae baa n ka ko maŋ ŋgba mena keŋ dana n ba ko Igyipite baale ŋon nɛ?’ ");
INSERT INTO ntr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosesi kenyii nombii kei nɛ te ɔ korowɔ yeu gyu ke kyaa Midian tɛɛle man bese ŋɔɔle botɔɔ. Botɔɔ te ɔ yalawɔ te ɔ lola bia baala bala. ");
INSERT INTO ntr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kulutooneŋ sɔŋola wɔle nɛ, Wurubuarɛ kpilale ŋolo kaa lese ɔ wose wola Mosesi, boalaŋ daale keŋ ne kpaa depoŋfa daale man depampaa nsana Sinai bula keŋ gyaŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosesi naa ke na, gyakoloŋ kyaŋa e. Te ɔ tuuwɔ benaa ke na waa nyiŋ naa ke nideli. Botɔɔ te ɔ nyii de Gbeŋgyoo Wurubuarɛ woya nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Maŋ yɛna n naanaɔ Aberaham na Asiki na Gyekɔpo Wurubuarɛ ŋon.’ Te gyakoloŋ gyoo Mosesi te ɔ sereewɔ, mena dɔɔ ɔ te tale kɛɛ ke bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Te de Gbeŋgyoo Wurubuarɛ yako e nyiaa, ‘Kpee nyaŋ nkyokotase lee n naawɔ man, nawolo nyi maŋ Wurubuarɛ gbagba kyaa botɔɔ keŋ n seŋɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ampaŋ, ma te naa me balaŋ baŋ be kyaa Igyipite nɛ kaale te me te nyii mena keŋ mɔ bɛɛ toroŋ, mena dɔɔ me te tisi lee adido kɔŋ me kaa lɛɛ wɔ. Desina n wose na maa kpila neŋ Igyipite!’ ");
INSERT INTO ntr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mosesi kei nombia te be bɛɛwɔ, te be bɔɔse e nyi, ‘Amɔte yɛɛ na neŋ de siamante, na de nombiadiiri.’ Wurubuarɛ tɛɛwɔ ɔ kpilale ŋon ɔ ba lese ɔ wose wola Mosesi depoŋfa keŋ man nɛ dɔɔ, yɛɛ e siamante na nyeelɛɛre. ");
INSERT INTO ntr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosesi kei yɛna gyakoloŋ nombia na nombia dinaana debaŋ keŋ ɔ ba mo Iseraetena lee Igyipite ta be siaman mo wɔ kaa toŋ ɛpo yayam keŋ, gyu ke ta depampaa dinaa keŋ man kulutooneŋ sɔŋola (40) nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosesi kei yako na Iseraetena nyiaa, ‘Wurubuarɛ waa kpila ɔ dekpeŋkpeŋgyɔɔre ŋolo ɛ gyaŋ ŋgba mena keŋ ɔ be kpila maŋ nɛ. Waa lee bo ɛmɛɛ gbagba ɛ balaŋ man.’ ");
INSERT INTO ntr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosesi kei na Iseraetena baŋ ke kyaa depampaa keŋ man nɛ, Wurubuarɛ kpilale kaa kolosiwɔ na e Sinai bula keŋ dɔɔ te ɔ lɛɛ Wurubuarɛ nyeedoŋ nombia ŋan fa de naanaɔ, te ŋe kaa tuŋa daa mɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mɔna de naanaɔ yɛɛ deŋele doŋ te be bɛɛ ɔ nombia ŋan, te be tɛɛse e see yenaŋ. Te baŋ be konɔɔse man na, nafɔ be gyaewɔ nyi baa bese gyu Igyipite. ");
INSERT INTO ntr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mena dɔɔ be yako Aarɔn nyi, ‘Yɛɛ bɛɛneŋ fa daa na baa ta de siaman, nawolo nyi dɔɔ gyeŋ kpene keŋ be yɛɛ Mosesi ŋon ɔ ba mo daa lee Igyipite nɛ ya.’ ");
INSERT INTO ntr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Weeya ŋenaŋ man te be yɛɛ nunkyue bu mo yɛɛ be bane, te be faa ke kedi te be dii be nɔɔ mo lese kpene keŋ baŋ gbagba ba mo be nyiŋmaase yɛɛ nɛ yele. ");
INSERT INTO ntr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mena dɔɔ Wurubuarɛ lese ɔ sia yela wɔ, te ɔ moo wɔ fa adido kyolobiise kasom, ŋgba mena keŋ bɔɔ ŋmarase do Wurubuarɛ akpeŋkpeŋgyɔɔra tɔne keŋ man nɛ. Ba ŋolo ŋmarasewɔ nyi Wurubuarɛ kpa, ‘O Iseraetena, na maŋ te ɛ koo wonembia deesi fa kulutooneŋ sɔŋola (40) depampaa dinaa keŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ɛ bane Molɛki te ɛ yɛɛ kanyaŋ deni do ke, na ɛ bane Refan wulu keŋ ke yɛɛ ŋgba kyolobii nɛ, te ɛ moowɔ sila ɛ wose. Baŋ yɛna banɛɛ baŋ ɛ be yɛɛ nyi ɛ ka som! Mena dɔɔ maa yela baa mo ŋon gyu lemlem, naŋ Babilɔn donɔɔ keŋ wɔle.’ ");
INSERT INTO ntr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Depampaa dinaa keŋ man nɛ, na de naanaɔ dana kanyaŋ deni dinaa daale keŋ ne di wɔ adansɛɛ nyi Wurubuarɛ kyaa be gyaŋ. Be yɛɛ kanyaŋ deni dinaa kei ŋgba mena keŋ Wurubuarɛ ba lese wola Mosesi nyi waa yɛɛ ke nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","De naanaɔ ke lɛɛ kanyaŋ deni dinaa kei lee be kyaɔ gyaŋ nɛ, ba moo ke sila be siamante Gyosua kelii tɛɛle keŋ Wurubuarɛ be yeli bɔɔ yoo gegi ke balaŋ te ɔ be lɛo ke fa wɔ nɛ man. Kanyaŋ deni dinaa kei doowɔ botɔɔ kelii debaŋ keŋ Defidi be kaa di gyoori nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Defidi kei nombia gyoo Wurubuarɛ sia, te ɔ yako Wurubuarɛ nyi waa fa e gbɛɛ na waa baŋ ɔsom deni dinaa gbagba fa ɔ naana Gyekɔpo Wurubuarɛ ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mɔna ɔ bu Solomɔn kaa baŋa na ɔsom deni dinaa kenaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mɔna Wurubuarɛ ŋon ɔ kela kpene kamasɛ nɛ, bɛɛ kyaa deni keŋ bɔɔ mo nyiŋmaase ma ke nɛ man ya. Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo yako mena nombii kei nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","De Gbeŋgyoo Wurubuarɛ kpa, ‘Adido te me gyooro gbeli kyaa, te tɛɛle dɔɔ yɛna me nae dɛɛsee. Woŋ deni dinɔɔ yaa ɛ ke ma fa maŋ, yaa aleŋ te maa kyaa fɛɛfo? ");
INSERT INTO ntr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na maŋ gbagba yɛɛna abɔɔ kɛŋa pou yee?’ ” ");
INSERT INTO ntr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Te Sitifin yako wɔ bela nyiaa, “Ɛmɛɛ konɔɔyuŋtena, ɛ dana konɔɔyuŋ ŋgba balaŋ baŋ bɔɔ ne nyii Wurubuarɛ dei ya nɛ, te ɛ ne yɛɛ deŋele doŋ ŋgba ɛ kyaɔ nɛ. Nawolo nyi debaŋ kamasɛ na ɛ na koro seŋ tia Wurubuarɛ feliŋ ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo kyaawɔ keŋ ɛ naanaɔ te naase e diyem yee? Ba koo Wurubuarɛ kpilala baŋ bɔɔ wula yako see nyi Yesu Kristo ŋon ɔ nombia tenɛɛ nɛ waa kɔŋ nɛ, te nɛnɛɛ ɛ lese Yesu ŋonaŋ fa te ba koo e. ");
INSERT INTO ntr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɛmɛɛ yɛna baŋ ɛ be nyiŋ Wurubuarɛ mmaraase ŋan lee ɔ kpilala gyaŋ, mɔna ɛ te di ŋe dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Debaŋ keŋ donɔɔ kegyiise baŋ be nyii nombia kɛŋa nɛ, be sia yɛɛwɔ ɔ dɔɔ te ba gyeŋa baŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mɔna Sitifin ŋon Wurubuarɛ feliŋ ŋon doo ɔ man nideli nɛ kɛɛ adido na, te ɔ naa Wurubuarɛ gyoorobiiri keŋ, na Yesu mɔ seŋɛɛ Wurubuarɛ dunoluŋ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Te Sitifin yakowɔ nyiaa, “Ɛ kɛɛ, mɛɛ naa ŋgba adido ta toro, na Deniwalaŋ Bu ŋon seŋɛɛ Wurubuarɛ dunoluŋ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɔ keyako mena nɛ te kegyiise baŋ moo be nyiŋmaase tɔ ba deŋela, te be fae yeesa keŋkeŋ. Karatetee te be popou kaa wuuwɔ ɔ dɔɔ, ");
INSERT INTO ntr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","te be wɔŋee e lee donɔɔ keŋ man ke fuŋii e boya. Baŋ bɔɔ gyu be kaa fuŋii e boya nɛ, kpee ba kegba wurikyimse ŋan fa tobaale ŋon bɛɛ baake e nyi Sɔɔl nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Be kee fuŋii Sitifin boya ŋan nɛ, na ɔ ne fane nyi, “Me Gbeŋgyoo Yesu, lɛɛ ma woo.” ");
INSERT INTO ntr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Botɔɔ te ɔ ŋmiŋawɔ ɔ doona dɔɔ te ɔ fae yeesa nyiaa, “Me Gbeŋgyoo Yesu, na mo nombiakumɛɛ kɛŋa tɔ wɔ kom ya.” Ɔ kekolosi nombia kɛŋa taŋ pɛ, te ɔ kara weesi. Be kɛɛ ko Sitifin na Sɔɔl mɔ seŋɛɛ botɔɔ ɔ na do wɔ kakyeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Lee wee kenaŋ te be fiasɛɛ bɛɛ naase Kristotena dikpii keŋ diyem nideli Gyerusalɛm donɔɔ man. Mena dɔɔ Kristotena baŋ pou yaaseewɔ laŋ Gyudia na Samaria tɛɛlese man, kaase kpilala baŋ baageŋ Gyerusalɛm donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Keŋte balaŋ baŋ bee yee Wurubuarɛ nɛ, baale gyuuwɔ kewuu Sitifin te be wii ɔ lia nideli. ");
INSERT INTO ntr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mɔna Sɔɔl korowɔ seŋ ɔ ne naase Kristotena baŋ diyem nideli. Ɔ na gyoo akpaŋalaŋse man ke wɔŋee Kristotena ala na baala gyu ketɔ deni. ");
INSERT INTO ntr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yenaŋ kamasɛ keŋ Kristotena baŋ be yaasee gyu nɛ, be kolosi Wurubuarɛ nombia ŋan fa balaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Te Filipo gyuu Samariatena donɔɔ dinaa daale man keyako Wurubuarɛ nombia nyi, Yesu Kristo yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Debaŋ keŋ balaŋ burum baŋ be nyii nombia ŋan Filipo be yako, te bɔɔ naa gyakoloŋ nombia ŋan ɔ be yɛɛ nɛ dɔɔ, be tei ɔ nombia ŋan nideli. ");
INSERT INTO ntr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filipo kekolosi keŋ nɛ, balaŋ baŋ feliŋkumɛɛ doo be man nɛ fae yeesa keŋkeŋ, te feliŋkumɛɛ ŋan leewɔ be man. Te baŋ mɔ be baamense ba yekee, na ɔtakasese burum mɔ wose yɛɛ wɔ doŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mena dɔɔ yɛɛ donɔɔ kenaŋ mantena baŋ pou gyoŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Donɔɔ kenaŋ man na balee ŋolo kyaa botɔɔ keŋ bɛɛ baake e nyi Simɔn. Ɔ ne yɛɛ baalabiiri nombia wola Samariatena, keŋ nyi ba wose na gbirisi wɔ. Ɔ ne gyina ɔ wose adido wola ɔ wose nyi ɔ yɛɛ walaŋ dinaa ŋolo e. ");
INSERT INTO ntr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mena dɔɔ walaŋ kamasɛ, bia na kegyiise pou ne tei e te bɛɛ yako nyi, “Ŋon yɛna Wurubuarɛ doŋ keŋ bɛɛ baake nyi doŋ dinaa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɔ ta mo ɔ baalabiiri nombia kɛŋa wola wɔ yela ba wose te gbirisi wɔ kyare, mena dɔɔ bɛɛ lɛɛ e di nideli. ");
INSERT INTO ntr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mɔna Filipo ke yako wɔ Wurubuarɛ gyoori na Yesu Kristo wose man nombia ŋan nɛ be lɛɛwɔ di, te be sɔɔ ala na baala pou Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔn gbagba mɔ lɛɛ nombia ŋan di te be sɔɔ e Wurubuarɛ loŋ, te ɔ moo ɔ wose do na Filipo nideli. Te gyakoloŋ nombia na nombia dinaana ŋan ɔ be naa Filipo ne yɛɛ dɔɔ, ɔ wose gbirisi e. ");
INSERT INTO ntr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Debaŋ keŋ Yesu kpilala baŋ be kyaa Gyerusalɛm be nyii nyi Samariatena te lɛɛ Wurubuarɛ nombia ŋan di nɛ, be kpila Pita na Gyɔn be gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba kekɔŋ kaa gyoo na, be fanewɔ fa wɔ nyi Wurubuarɛ waa mo ɔ feliŋ ŋon do be man. ");
INSERT INTO ntr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nawolo nyi na Wurubuarɛ ta moo ta ɔ feliŋ ŋon do baŋ Samariatena benaŋ man ŋolo man ya. Be sɔɔ wɔ Wurubuarɛ loŋ bo lee de Gbeŋgyoo Yesu waageŋ yele man. ");
INSERT INTO ntr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Te Pita na Gyɔn moo be nyiŋmaase gyakaa be dɔɔ te be fanewɔ fa wɔ, te Wurubuarɛ moo ɔ feliŋ ŋon do be man. ");
INSERT INTO ntr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simɔn naawɔ nyi Yesu kpilala baŋ ka mo be nyiŋmaase gyakaa balaŋ baŋ dɔɔ fane fa wɔ nɛ, Wurubuarɛ moo ɔ feliŋ ŋon do be man keŋte ɔ lese kɔba waa fa wɔ, ");
INSERT INTO ntr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","te ɔ yako wɔ nyiaa, “Ɛ mo mena doŋ kei fa maŋ mɔ, na walaŋ kamasɛ ŋon maa mo me nyiŋmaa gyakaa ɔ dɔɔ na, Wurubuarɛ ka mo ɔ feliŋ ŋon do ɔ man.” ");
INSERT INTO ntr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Te Pita yako e nyi, “Wurubuarɛ waa yela ɛmɛɛ na n kɔba pou ka gyoo boalaŋ man. Nawolo nyi n te yɛɛ nya agyueŋ nyi n ka mo kɔba lɛɛ Wurubuarɛ kolo anefaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","N be dana dedii yaa daseŋae da tom kei man ya, nawolo nyi n konɔɔ man nombia ba tenɛɛ Wurubuarɛ siaman ya. ");
INSERT INTO ntr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kyɛɛkee nya agyueŋ lee n nombiikum kei man, na n kefane fa de Gbeŋgyoo Wurubuarɛ na waa mo ke kyɛɛ neŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nawolo nyi ma te naa nyi n dana sibiikum, te nombiakumɛɛ te di n dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Te Simɔn yako wɔ nyi, “Mɛɛ waase ŋon bo ɛ fane fa de Gbeŋgyoo Wurubuarɛ fa maŋ, na ŋan pou ɛ be yako nɛ man dokoloŋ gba be kɔŋ me dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita na Gyɔn kekolosi Wurubuarɛ nombia ŋan di adansɛɛ lee Yesu Kristo wose man taŋ nɛ, te ba besewɔ laŋ Gyerusalɛm donɔɔ man. Be ka bese bee gyu keŋ nɛ, be kolosi Kristo nombia kpaakpaa ŋan Samariatena akuraase burum man. ");
INSERT INTO ntr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","De Gbeŋgyoo Wurubuarɛ kpilale ŋolo lee adido kaa yako Filipo nyiaa, “Koro desina n wose na n ka mo ata yenaŋ gbɛɛ bene keŋ ba lee Gyerusalɛm ne gyu Gasa donɔɔ man nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Keŋte Filipo korowɔ desina ɔ wose moo gbɛɛ. Ɔ kee gyu keŋ na te ɔ ke gyaŋee na Itiopia baale saayɛte ŋolo. Ɔ yɛɛ Itiopia ala gyoo ŋon bɛɛ baake e nyi Kandase nɛ wose man walaŋ kegyia ŋolo e. Ŋon ne kɛɛ na ala gyoo ŋon kɔba pou dɔɔ. Balee kei gyuu Gyerusalɛm bo ka som Wurubuarɛ, ");
INSERT INTO ntr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","te ɔ besewɔ kaa laŋ ɔ ne gyu ɔ dɛɛ. Na ɔ kyaa anebiliŋinbii daale man keŋ dɛɛkyɔŋse ne wɔŋee na ke. Ɔ kyaa ɔ ne kala Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya tɔne. ");
INSERT INTO ntr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Te Wurubuarɛ feliŋ ŋon yako Filipo nyi, “Tuu benaa anebiliŋinbii keŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Keŋte Filipo yeuwɔ gyu botɔɔ, te ɔ ke nyiiwɔ ŋgba balee ŋon ne kala kolo lee Wurubuarɛ dekpeŋkpeŋgyɔɔre Yesaya tɔne keŋ man nɛ te Filipo bɔɔse e nyi, “Mena dɔɔ n ne nyii kpene keŋ n ne kale nɛ man?” ");
INSERT INTO ntr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Te balee ŋon tiranɔɔ fa Filipo nyi, “Sena te maa tale nyii ke man, keŋ ŋolo ta lese ke man fa maŋ ya?” Te ɔ baake Filipo nyi waa gyeŋ kaa kyaa ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na Wurubuarɛ nombia ŋan bɔɔ ŋmarase see te ɔ ne kale yɛna nyi, “Ba te kparaa e laŋ ŋgba nam ŋon bee gyu be kaa ko e nɛ. Ɔ yɛɛ ŋgba nambu ŋon bɛɛ kɛrɛɛ ɔ wona te ɔ seŋɛɛ yididi nɛ. Ɔ te wii koraŋ gba ya. ");
INSERT INTO ntr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Be tisinaa e tɛɛle man, do e desɛŋ, te be sukutii ɔ nombia do. Amɔ ne gyae la waa tale yako kolo lee ɔ duuluŋ man balaŋ wose man, ŋgba bɔɔ ko e bileŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Botɔɔ te Itiopia baale kegyia ŋon bɔɔse Filipo nyiaa, “Kegyia waaseda, amɔte wose man nombia yaa Wurubuarɛ dekpeŋkpeŋgyɔɔre kei ne yako nɛ, ŋon gbagba yaa walaŋ wɔle ŋolo bo?” ");
INSERT INTO ntr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Te Filipo seŋawɔ Wurubuarɛ nombia ŋan bɔɔ kale nɛ dɔɔ yako e Yesu wose man nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Be kee gyu keŋ nɛ, te be ka leewɔ loŋ daale dɔɔ. Botɔɔ te balee ŋon bɔɔse Filipo nyiaa, “Kɛɛ loŋ daale yaa kei, woŋ ne tɔɔ na maŋ gbɛɛ na Wurubuarɛ loŋkesɔ?” ");
INSERT INTO ntr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Te Filipo yako e nyi, “Akpaa n mo n konɔɔ pou lɛɛ Kristo di na, gbɛɛ doo nyi maa sɔ neŋ Wurubuarɛ loŋ.” Balee ŋon mɔ yakowɔ nyiaa, “Mɛɛ lɛɛdi nyi Yesu Kristo yɛna Wurubuarɛ bu ŋon.” ");
INSERT INTO ntr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mena dɔɔ balee ŋon yela anebiliŋinbii keŋ seŋawɔ, te ŋon na Filipo pou tisiwɔ ka gyoo loŋ keŋ man te Filipo sɔɔ e Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Be ka lee loŋ keŋ man nɛ, te de Gbeŋgyoo Wurubuarɛ feliŋ ŋon moo Filipo laŋ debokenaŋ man, mena dɔɔ balee ŋon te naa e bela ya. Mɔna balee ŋon besewɔ mo ɔ gbɛɛ ɔ ne gyu gyoŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo kɛɛwɔ na, ɔ kyaa Asotuse donɔɔ man. Ɔ tɛɛwɔ donɔɔse ŋan man kolosi Kristo nombia ŋan, kaboena ɔ gyuuwɔ ka lee Kaesaria donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Weeya ŋenaŋ pou man na Sɔɔl sɛɛ ɔ ne ŋmaase de Gbeŋgyoo Yesu silala baŋ nyi waa ko wɔ. Mena dɔɔ ɔ gyuu Wurubuarɛ sae kegyia ŋon gyaŋ, ");
INSERT INTO ntr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ka sola e lɛɛ ɔ nyiŋmaa man tɔne keŋ gyae ke fa e doŋ na waa mo gyu Damasekuse donɔɔ man kefa Gyudatena ɔsom denɛɛ man kegyiise baŋ. Na baa fa e gbɛɛ waa kyaŋ walaŋ kamasɛ, ala na baala baŋ pou ɔ naa nyi be silana Yesu kawola wɔle kei nɛ. Na waa nyiŋ kyaŋ wɔ kɔŋ Gyerusalɛm donɔɔ man kaa tɔ deni. ");
INSERT INTO ntr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ɔ ke gyu ka benaa Damasekuse donɔɔ nɛ, debokenaŋ man te boalaŋ daale lee adido kaa ŋmaale polɛ kilisi e. ");
INSERT INTO ntr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mena dɔɔ ɔ leewɔ yala te ɔ nyii woya ŋaale baake e bɔɔse nyi, “Sɔɔl, Sɔɔl, weera dɔɔ te n ne naase maŋ diyem mena?” ");
INSERT INTO ntr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Botɔɔ te Sɔɔl tiranɔɔ bɔɔse e nyiaa, “Nyaŋ amɔte ŋonaŋ me Gbeŋgyoo?” Te ŋon mɔ yako e nyiaa, “Maŋ yɛna Yesu ŋon n ne naase diyem nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mɔna koro na n ke gyu donɔɔ keŋ man, na baa yako neŋ kpene keŋ kaboena nyi nya yɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Balaŋ baŋ baŋ na Sɔɔl dɔŋɛɛ nɛ, ba woya yeuwɔ lee be gyaŋ keŋ ba te tale gyuusu be nɔɔ ya. Baŋ mɔ nyii nɔɔwoya ŋan, mɔna ba te naa ŋolo ya. ");
INSERT INTO ntr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔl korowɔ seŋ te ɔ gyuusu ɔ sia mɔna ɔ te tale naa kolo ya, mena dɔɔ be kyaŋa e ɔ nyiŋmaa man, te ba moo e gyu Damasekuse donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ɔ kyaawɔ botɔɔ weeya kpaakpaa atooro keŋ nyi ɔ bɛɛ naa ya, te ɔ bee dii ya, te ɔ bɛɛ nyɔɔ mɔ ya. ");
INSERT INTO ntr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na Yesu silale ŋolo kyaa Damasekuse botɔɔ keŋ bɛɛ baake e nyi Ananiase. Ɔ nyiiwɔ de Gbeŋgyoo baake e ŋgba dosɛɛ man nɛ nyi, “Ananiase.” Te ɔ kpaawɔ nyi, “Me Gbeŋgyoo maŋ yaa!” ");
INSERT INTO ntr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Te de Gbeŋgyoo Yesu yako e nyi, “Koro gyu Gyuda dɛɛ, ke kyaa gbɛɛnaa keŋ bɛɛ baake ke nyi gbɛɛnaa keŋ ka Tenɛɛ nɛ nɔɔman, na n ke bɔɔse Sɔɔl ŋon ɔ ba lee Tasuse nɛ dɔɔ. Ɔ kyaa botɔɔ ɔ ne fane. ");
INSERT INTO ntr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wurubuarɛ ta lese wola ŋon Sɔɔl mɔ ŋgba dosɛɛ man nɛ nyi, balee ŋon bɛɛ baake e nyi Ananiase nɛ, te kɔŋ ɔ kaa mo ɔ nyiŋmaase gyakaa ɔ dɔɔ, na waa bese naa bela.” ");
INSERT INTO ntr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiase tiranɔɔ nyiaa, “Me Gbeŋgyoo, balaŋ burum te yako maŋ balee kei wose man nombia, na mena keŋ ɔ be yɛɛ n balaŋ baŋ be kyaa Gyerusalɛm donɔɔ man nɛ akpanyaŋnyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ɔ lɛɛ tɔne keŋ ne fa e doŋ baa lee Gyudatena saese kegyiise gyaŋ kɔŋ Damasekuse kɛbo, na ɔ kaa kyaŋ baŋ pou bɛɛ som neŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Keŋte de Gbeŋgyoo Yesu tiranɔɔ fa Ananiase nyiaa, “Gyu ɔ gyaŋ, nawolo nyi maŋ lese na e nyi waa som maŋ, na waa yela baŋ pou ba te yɛɛ Gyudatenawɔ ya, na be gyooneŋ na Iseraetena pou ke nyii ma yele. ");
INSERT INTO ntr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Maŋ ne gyae la maa wola e mena keŋ kaboena nyi waa naa diyem nideli lee ma yele dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Keŋte Ananiase gyuuwɔ ka gyoo dekpaŋalaŋ keŋ man. Te ɔ moo ɔ nyiŋmaase gyakaa Sɔɔl nyee dɔ fane nyiaa, “Me dɔɔ Sɔɔl, de Gbeŋgyoo Yesu ŋon ɔ ba lese ɔ wose wola neŋ gbɛɛnaa man debaŋ keŋ ne kɔŋ kɛbo nɛ, ŋon kpila na maŋ n gyaŋ nyi me kaa fane fa neŋ na n kabese naa. Na Wurubuarɛ kenyiŋ mo ɔ feliŋ ŋon do n man.” ");
INSERT INTO ntr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Debokenaŋ man te kolo leewɔ ɔ sia ŋan man yala ŋgba kpebii bɔɔlɛɛ bia nɛ, te Sɔɔl sia ŋan gyuusuwɔ, te ɔ besewɔ ɔ ne naa bela. Ɔ korowɔ seŋ te ba ke sɔɔ e Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kenaŋ wɔle te be faa e weenɛɛ. Ɔ ke di taŋ nɛ, ɔ wose besewɔ yɛɛ e doŋ. Te ɔ dii weeya akalansɛɛ ŋaale Yesu silala baŋ gyaŋ Damasekuse donɔɔ man botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Debokenaŋ man te Sɔɔl fiasɛɛ ɔ ne kolosi Yesu nombia Gyudatena ɔsom denɛɛ man nyi, Yesu yɛna Wurubuarɛ bu ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Baŋ pou bɔɔ nyii e nɛ wose gbirisi wɔ, te be bɔɔse dɔŋa nyi, “Na balee kei kyaa la Gyerusalɛm donɔɔ man ɔ ne naase baŋ bɛɛ som Yesu nɛ diyem yee? Na keŋ dɔɔ te ɔ kɔŋawɔ kɛbo ɔ kaa kyaŋ wɔ na waa mo wɔ gyina saese kegyiise baŋ yee?” ");
INSERT INTO ntr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Te Sɔɔl besewɔ nyiŋ doŋ kpu te ɔ kolosiwɔ lese ŋe man nideli fa Gyudatena baŋ nyi, Yesu yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. Ɔ kolosiwɔ nideli keŋ nyi Gyudatena baŋ be kyaa Damasekuse donɔɔ man nɛ, te tale gyuusu be nɔɔ bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Weeya ala ŋaale wɔle nɛ, Gyudatena kegyiise gyaŋeewɔ yɛɛ nɔɔ nyi baa ko Sɔɔl. ");
INSERT INTO ntr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mɔna Sɔɔl nyii be nombiakumɛɛ ŋan bɔɔ bake ɔ nyeeman nɛ. Nelim na ka weese pou na, bɛɛ deke donɔɔ keŋ anaanɔɔse ŋan na baa nyiŋ ko e. ");
INSERT INTO ntr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mɔna nelim daale nɛ, ɔ kaseela baŋ moo e do dokyoŋoloŋ man, te be tisinaa e mo nfansere man gbaa dekyaŋ keŋ bɔɔ maa kilisi donɔɔ keŋ nɛ, te ɔ yeuwɔ laŋ Gyerusalɛm. ");
INSERT INTO ntr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔl ka bese gyu Gyerusalɛm donɔɔ man nɛ, ɔ gyaewɔ nyi waa mo ɔ wose kpu na Yesu silala baŋ. Mɔna be popou ne yee nawolo nyi na ba te lɛɛ ta di nyi, ŋon mɔ ta bese Yesu silale gbagba ya. ");
INSERT INTO ntr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Keŋte Banabase moo e gyu Kristo kpilala baŋ gyaŋ. Te ɔ yako wɔ mena keŋ Sɔɔl be naa de Gbeŋgyoo Yesu Damasekuse gbɛɛnaa man, na mena keŋ de Gbeŋgyoo Yesu be kolosi na e, na mena keŋ ɔ be gyɔ ɔ konɔɔ mo Yesu yele keyako Wurubuarɛ nombia ŋan Damasekuse donɔɔ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mena dɔɔ Sɔɔl kpuuwɔ na Yesu silala baŋ. Ɔ kyaawɔ be gyaŋ te be gyɔɔ be konɔɔ ta na Gyerusalɛm donɔɔ kolosi Wurubuarɛ nombia ŋan lee de Gbeŋgyoo Yesu yele man. ");
INSERT INTO ntr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sɔɔl kolosiwɔ nideli te ŋon na Gyudatena baŋ bee kolosi Giriki dei nɛ, lɛɛ aŋmaareŋ nideli. Te be gyae gbɛɛ keŋ baa mo ko e. ");
INSERT INTO ntr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mena dɔɔ Yesu silala baŋ ka gyeŋ mena nɛ, ba moo e gyu Kaesaria donɔɔ man te be yela ɔ laŋa Tasuse. ");
INSERT INTO ntr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mena dɔɔ Kristotena baŋ be kyaa Gyudia na Galelia na Samaria tɛɛlese man nɛ, wose fɛɛ wɔ mena debaŋ kenaŋ man. Be lɛɛ Yesu nombia ŋan di nideli, te be tɛɛwɔ Wurubuarɛ kegyaebii man, te Wurubuarɛ feliŋ ŋon doo wɔ kakyeŋ te be wukuwɔ kpu. ");
INSERT INTO ntr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kɔŋawɔ debaŋ daale nyi Pita keta ɔ ne kila tɛɛle keŋ nɛ, ɔ gyuu Lida donɔɔ man ɔ kaa kɛɛ Kristotena baŋ be kyaa botɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Keŋte ɔ ke naa balee ŋolo na ɔ yele yɛna Anease ŋon ɔ wose pou ba yem nɛ. Ɔ doowɔ dofoŋoŋ dɔɔ kulutooneŋ gyanaara keŋ ɔ bɛɛ tale koro ya. ");
INSERT INTO ntr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Botɔɔ te Pita baake e nyiaa, “Anease kɛɛ, Yesu Kristo te kyɔ neŋ n kawee. Koro seŋ na n ke bɔ n dofoŋoŋ!” Debokenaŋ man te Anease korowɔ seŋ. ");
INSERT INTO ntr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Balaŋ baŋ pou be kyaa Lida na Sarɔn kena Anease dɔŋɛɛ nɛ, be lɛɛ de Gbeŋgyoo Yesu nombia ŋan di te ba bese ɔ silala. ");
INSERT INTO ntr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na alo ŋolo mɔ kyaa Gyopa keŋ ŋon mɔ yɛɛ Yesu silale e te ɔ yele yɛna Tabita. Giriki dei man na baa baake e nyi Dɔkase keŋ nawolo nyi ŋaa. Debaŋ kamasɛ na alo kei ne yɛɛ deeli fa balaŋ, te ɔ ne kyɔ ayematena mɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Debaŋ kenaŋ man nɛ, ɔ gyoo kawee te ɔ yeŋawɔ. Te be sɔɔ e teeli abansoro deni daale man. ");
INSERT INTO ntr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida na Gyopa donɔɔse taŋ lem na dɔŋa ya. Te kaseela baŋ be kyaa Gyopa kenyii nyi Pita kyaa Lida nɛ, be kpila tewulɛɛ bala gyu ɔ gyaŋ nyi, “Pita, waaseda, yɛɛ bileŋ na n kekɔŋ de gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mena dɔɔ Pita korowɔ sila wɔ. Be ka gyoo botɔɔ nɛ te ba moo e gyu deni adidote keŋ man. Te liala baŋ pou kaa yilaawɔ kilisi Pita bee wii, na bɛɛ mo kegbase na abɔɔ ŋan Tabita be ŋare fa wɔ pɛte ɔ ba yem nɛ wola e. ");
INSERT INTO ntr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Keŋte Pita lese be popou lee deni keŋ man, te ɔ ŋmiŋawɔ ɔ doona dɔɔ te ɔ fanewɔ. Te ɔ besenawɔ kɛɛ woo ŋon te ɔ yakowɔ nyiaa, “Tabita, koro!” Te woo ŋon gyuusu ɔ sia, te ɔ kena Pita nɛ, ɔ korowɔ kyaa. ");
INSERT INTO ntr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Keŋte Pita kyaŋa e ɔ nyiŋmaa man kyɔ e te ɔ korowɔ seŋ. Te ɔ baake Yesu silala baŋ na liala baŋ, te ɔ moo Dɔkase do wɔ be nyiŋmaa man na ɔ delena. ");
INSERT INTO ntr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nombia kɛŋa yaaseewɔ kila Gyopa keŋ pou, te balaŋ burum kaa lɛɛ de Gbeŋgyoo Yesu di. ");
INSERT INTO ntr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kenaŋ wɔle na Pita dii weeya burum Gyopa donɔɔ man botɔɔ. Na ɔ kyae Simɔn ŋon ɔ ne yɛɛ wonembia tɔna wose man tom nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Balee ŋolo kyaawɔ Kaesaria donɔɔ man na ɔ yele yɛna Kɔnelio. Ɔ yɛɛ Itali tɛɛle yoonɔɔtena dikpii siamante e. Na yoonɔɔtena sɔŋonoŋ doo la ɔ tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɔ yɛɛ walaŋ ŋon ɔ ba mo ɔ wose fa Wurubuarɛ, te ŋon na ɔ dekpaŋalaŋmantena pou ne yee Wurubuarɛ nideli. Ɔ dana wɔe fa Gyudatena ayematena te ɔ ne fane fa Wurubuarɛ debaŋ kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wee daale balinɔɔ weese debaŋ atoorote nɛ, ɔ naa kolo na ɔ sia ŋgba dosɛɛ man nɛ. Ɔ naa Wurubuarɛ kpilale ŋolo ta lee adido kɔŋ ɔ gyaŋ te ɔ baake e nyi, “Kɔnelio.” ");
INSERT INTO ntr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Te Kɔnelio kɛɛ e yididi gyakoloŋ man te ɔ bɔɔse e nyi, “Me Gbeŋgyoo weera?” Keŋte Wurubuarɛ kpilale ŋon yako e nyiaa, “Wurubuarɛ te lɛɛ n kefane. Ɔ te naa mena keŋ n ne yɛɛ wɔe fa ayematena baŋ, te ŋe ta gyoo ɔ sia. ");
INSERT INTO ntr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mena dɔɔ kpila balaŋ gyu Gyopa donɔɔ keŋ man, be kaa baake walaŋ ŋon bɛɛ baake e nyi Simɔn yaa Pita nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔ kyaa Simɔn ŋon ɔ ne yɛɛ wonembia tɔna wose man tom nɛ dɛɛ. Ɔ dɛɛ kyaa ɛpo nɔɔman.” ");
INSERT INTO ntr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wurubuarɛ kpilale ŋon kekɔŋ kaa kolosi fa e taŋ te ɔ be lam nɛ, Kɔnelio baake ɔ dekpaŋalaŋ man tewulɛɛ bala, na yoonɔɔtena baŋ bee gyee e nɛ man ŋolo, ŋon ɔ benaa na e te ɔ ne yee Wurubuarɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Te ɔ yako wɔ kpene keŋ pou be kɔŋ nɛ, te ɔ kpila wɔ Gyopa donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tɛɛ kena weeseteŋteŋ keŋ be dɔŋ bee gyuu te be ka benaa Gyopa donɔɔ keŋ nɛ, debaŋ kenaŋ te Pita mɔ gyeŋawɔ laŋ abansoro dɔɔ ɔ kaa fane. ");
INSERT INTO ntr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tanam kyaŋa e te ɔ gyae kolo waa di, mɔna debaŋ keŋ bɛɛ saa weenɛɛ ŋan nɛ, ɔ naa kolo na ɔ sia ŋgba dosɛɛ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ɔ naawɔ ŋgba adido ba toro na, te ɔ naa kolo ŋgba kanyaŋ dinaa daale nɛ, na be dana ke nɔɔsebia anaara ŋan man lee adido, te be tisinaa ke kaa see tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na wonembia kpookpoo doo ke man. Baŋ be dana nawɔɔ anaara, na baŋ bee tuu be tɔɔse dɔɔ, na baŋ bee furufu nɛ doo ke man. ");
INSERT INTO ntr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Keŋte ɔ nyii nɔɔwoya ŋaale nyi, “Pita, koro na n ka ko di.” ");
INSERT INTO ntr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Te Pita yakowɔ nyi, “Koa, dee gyu lem me Gbeŋgyoo, nawolo nyi me te dii ta kolo kum yaa kpene keŋ dɛɛ kɔle nɛ see ya.” ");
INSERT INTO ntr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Te nɔɔwoya ŋan besewɔ yako e bela nyi, “Kpene keŋ Wurubuarɛ be lɛɛ do nyi ke dei nɛ, na baake ke nyi kolo anekɔlaŋ bela ya.” ");
INSERT INTO ntr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kei yɛɛwɔ mena betabotooro. Te debokenaŋ man ba moo kanyaŋ keŋ laŋ adido bela. ");
INSERT INTO ntr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita kekyaa ɔ na gyueŋ nombia ŋan ɔ be naa nɛ wose man nɛ, na Kɔnelio kpilala baŋ mɔ te bɔɔse gyu kena dekpaŋalaŋ keŋ man Simɔn kyaa, te be gyuuwɔ ka seŋ ka denanɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Keŋte be baake ŋolo dekpaŋalaŋ keŋ man bɔɔse e nyiaa, “Kɛbo te balee ŋon bɛɛ baake e nyi Simɔn Pita nɛ kyaa?” ");
INSERT INTO ntr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na Pita sɛɛ ɔ na gyueŋ nombia ŋan ɔ be naa nɛ wose man, te Wurubuarɛ feliŋ yako e nyiaa, “Simɔn, nyii kɛbo, tewulɛɛ batooro baale ne gyae neŋ. ");
INSERT INTO ntr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mena dɔɔ desina n wose na n ke tisi gyu be gyaŋ. Sila wɔ ta, na lɛɛ n wose aŋmaareŋ ya nawolo nyi maŋ kpila na wɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mena dɔɔ Pita tisiwɔ gyu balaŋ baŋ gyaŋ te ɔ ke yako wɔ nyiaa, “Maŋ yɛna walaŋ ŋon ɛ ne kɛo nɛ. Ɛ keta gyakoloŋ?” ");
INSERT INTO ntr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Keŋte balaŋ baŋ tiranɔɔ nyiaa, “De gbeŋgyoo yoonɔɔtena dikpii siamante ŋon bɛɛ baake e nyi Konelio nɛ kpila na daa n gyaŋ. Ɔ yɛɛ walaŋ ŋon ɔ ne yee Wurubuarɛ, te ŋon na e mɔ nsana dei, te Gyudatena pou ne bu e. Wurubuarɛ kpilale ŋolo kɔŋala kaa yako e nyi, waa kpila kaa mo neŋ kɔŋ ɔ gyaŋ, na waa nyii kpene keŋ n dana fa e.” ");
INSERT INTO ntr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Te Pita moo balaŋ baŋ gyu ɔ dɛɛ, te ɔ yela be doowɔ ɔ gyaŋ. Tɛɛ kena keŋ nɛ, Pita desina ɔ wose te ŋon na wɔ pou laŋawɔ. Ɔ tebia Kristotena baale mɔ leewɔ Gyopa sila wɔ gyu. ");
INSERT INTO ntr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tɛɛ kena te ba gyoo Kaesaria, na Kɔnelio ne kɛɛ be gbɛɛ mena dɔɔ ɔ yilaa ɔ loŋtona na ɔ gyoona kpaakpaa nyibaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ka gyoo dekpaŋalaŋ keŋ man nɛ, Kɔnelio kaa gyaŋeewɔ na e te ɔ tisiwɔ buŋ ɔ nawɔɔtɛɛ obuo man. ");
INSERT INTO ntr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Keŋte Pita yako e nyi “Koro, na yɛɛ mena ya. Nawolo nyi maŋ mɔ yɛɛ deniwalaŋ e ŋgba nyaŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Te ŋon na Pita moo afa keyɔɔ mo gyoo dekpaŋalaŋ keŋ man, te Pita ke naa balaŋ burum baŋ pou bɔɔ yilaa botɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Te ɔ yako wɔ nyi, “Ɛmɛɛ gbagba ɛ gyeŋ nideli nyi nafɔ daa Gyudatena ɔsom kɛɛ wolo man na, gbɛɛ be doo keŋ nyi Gyuda baale ka mo ɔ wose do na walaŋ ŋon ɔ te yɛɛ Gyuda baale e ya, yaa waa gyu ɔ gyaŋ ya. Mɔna Wurubuarɛ ta lese wola maŋ nyi, me na kɛɛ walaŋ ŋolo nyi ɔ yɛɛ walaŋ yakaate e ya. ");
INSERT INTO ntr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lee mena dɔɔ n ke kpila baake maŋ na, ma te bɛɛ nyi mɔɔ kɔŋ ya. Mɛɛ gyae maa nyii kpene keŋ dɔɔ n be kpili baake maŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Botɔɔ te Kɔnelio tiranɔɔ nyiaa, “Weeya anaara yaa ŋgba me kyaa me dɛɛ mɛɛ fane balinɔɔ weese ŋgba debaŋ atoorote man nɛ, debokenaŋ man te baale ŋolo kaa bɛɛwɔ lee me dɔɔ. Na ɔ doona abɔɔ ŋan ne ŋalakee nɛ, te ɔ kaa seŋawɔ me siaman. ");
INSERT INTO ntr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Te ɔ yako maŋ nyi, ‘Kɔnelio, Wurubuarɛ te nyii n kefane te ɔ ne tɔɔse n wɔe keŋ n dana fa ayematena nɛ, mena dɔɔ ");
INSERT INTO ntr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","kpila gyu Gyopa donɔɔ man ke baake Simɔn Pita, ɔ kyaa Simɔn ŋon ɔ ne yɛɛ wonembia tɔna wose man tom te ɔ dekpaŋalaŋ kyaa ɛpo nɔɔman nɛ gyaŋ.’ ");
INSERT INTO ntr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mena dɔɔ te me kpila balaŋ n gyaŋ debokenaŋ man. N yɛɛ ke nideli ŋgba n be kɔŋ nɛ. Nɛnɛɛ de popou te kaa gyaŋee kɛbo Wurubuarɛ siaman dɛɛ daa neŋ, na dee nyii nɔɔwoya ŋan de Gbeŋgyoo Wurubuarɛ kpa nya yako daa nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Botɔɔ te Pita gyinaa ɔ nɔɔwoya nyi, “Nɛnɛɛ dɔɔ ma te naa ampaŋ nyi balaŋ pou yɛɛ kyɛɛkyɛɛ Wurubuarɛ siaman, te ɔ bɛɛ kɛɛ ŋolo siaman ya. ");
INSERT INTO ntr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mɔna walaŋ kamasɛ ŋon ɔ ne yee e te ɔ ne yɛɛ abɔɔ ŋan doo na ŋe gbɛɛ na, ɔ ne lɛɛ e do. Ɔ be famenɛ na ɔtenate dalee ya. ");
INSERT INTO ntr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ɛmɛɛ gbagba gyeŋ nɔɔwoya kpaakpaa ŋan Wurubuarɛ ba mo fa Iseraetena nɛ. Ɔ yako wɔ nyi baa sila Kristo ŋon ɔ yɛɛ walaŋ kamasɛ Gbeŋgyoo e nɛ, na baŋ na ŋon Wurubuarɛ nsana ke de na baa nyiŋ wosefɛɛreŋ. ");
INSERT INTO ntr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ɛ gyeŋ nombii dinaa keŋ be kɔŋ Iserae tɛɛle dɔɔ, keŋ be fiasɛɛ lee Galelia tɛɛle man debaŋ keŋ Gyɔn be kolosi lee Wurubuarɛ loŋkesɔ keŋ wose man nombia ŋan wɔle nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɛ gyeŋ mena keŋ Wurubuarɛ ba mo ɔ feliŋ na ɔ doŋ keŋ do Yesu Nasarɛte baale ŋon man, mena dɔɔ Yesu tɛɛwɔ yɛɛ deeli te ɔ kyɔɔ baŋ pou ɔbɔnsam be di be dɔɔ nɛ kaweese. Ɔ yɛɛ kɛŋa pou nawolo nyi Wurubuarɛ kpuɛ na e. ");
INSERT INTO ntr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Te dee di adansɛɛ lee kpene kamasɛ keŋ ɔ be yɛɛ Gyudatena tɛɛle man na Gyerusalɛm donɔɔ man nɛ. Be gyɔɔ e sakaa ɔpaŋdaŋ dɔɔ ko. ");
INSERT INTO ntr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mɔna weeya atoorote keŋ man nɛ, Wurubuarɛ gyuusu e lee yeŋ man, te ɔ yela ɔ lese ɔ wose wola balaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Na balaŋ pou naa na e ya, mɔna daa baŋ Wurubuarɛ be wulaa lese nyi dɛɛ yɛɛ wa adansɛɛtena nɛ, daa daageŋ naa na e. Wurubuarɛ ke gyuusu e lee yeŋ man mɔ nɛ, daa na e diiwɔ te de nyɔɔwɔ. ");
INSERT INTO ntr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Te ɔ yako daa nyi dee kolosi ɔ nombia fa balaŋ na dee di adansɛɛ lee ɔ wose man nyi, ŋon yɛna walaŋ ŋon Wurubuarɛ ba lese nyi, waa di balaŋ baŋ bɔɔ yekee na baŋ be kyaa na be sia nɛ pou nombia. ");
INSERT INTO ntr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wurubuarɛ akpeŋkpeŋgyɔɔra baŋ pou kolosiwɔ lee ɔ wose man nyi, walaŋ kamasɛ ŋon waa lɛɛ e di na, Wurubuarɛ waa mo ɔ nombiakumɛɛ kyɛɛ e lee Yesu yele man.” ");
INSERT INTO ntr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita kegyakaa ɔ ne kolosi nɛ, te Wurubuarɛ feliŋ ŋon kaa gyoo baŋ pou bee tei e nɛ man. ");
INSERT INTO ntr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Te Gyudatena baŋ bɔɔ lɛɛ Yesu di te bɔɔ sila Pita kɔŋ nɛ, wose gbirisi wɔ ŋgba Wurubuarɛ ba mo ɔ feliŋ ŋon do balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya mɔ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nawolo nyi be nyiiwɔ bee kolosi deise kpookpoo, na bɛɛ lese Wurubuarɛ yele. Keŋte Pita yako wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wurubuarɛ ta mo ɔ feliŋ ŋon do balaŋ kɛwɔ mɔ man, ŋgba mena keŋ keŋ ɔ ba mo do de man nɛ. Ŋolo waa tale tɔ wɔ gbɛɛ nyi be na sɔ wɔ Wurubuarɛ loŋ yee?” ");
INSERT INTO ntr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mena dɔɔ ɔ yela be sɔɔ wɔ Wurubuarɛ loŋ lee Yesu Kristo yele man. Te ba sola e nyi, waa kyaa be gyaŋ weeya ala. ");
INSERT INTO ntr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu kpilala na Kristotena baŋ be kyaa Gyudia tɛɛle keŋ dɔɔ nyiiwɔ nyi, balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ mɔ te lɛɛ Wurubuarɛ nombia ŋan do. ");
INSERT INTO ntr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita ke gyu ka gyoo Gyerusalɛm donɔɔ man nɛ, Gyudatena baŋ ba seŋɛɛ nyi Yesu silala pou baa kara be baala wose nɛ te sɛɛ e ya. ");
INSERT INTO ntr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Be bɔɔse e nyi, “Weera te n gyuuwɔ balaŋ baŋ ba te kara be baala wose ya nɛ gyaŋ, te n ke diiwɔ bom na wɔ?” ");
INSERT INTO ntr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Botɔɔ te Pita lese kpene keŋ be kɔŋ nɛ man dokoloŋ dokoloŋ fa wɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na me kyaa Gyopa donɔɔ man mɛɛ fane. Keŋte me naa kolo ŋgba kanyaŋ dinaa daale nɛ na me sia ŋgba dosɛɛ man nɛ, keŋ be dana ke nɔɔbia anaara ŋan man te be tisinaa ke lee adido kaa see me siaman. ");
INSERT INTO ntr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Me kɛɛ ke man nideli na te me naa wonembia kpookpoo, baŋ be dana nawɔɔ anaara na baŋ bee tuu be tɔɔse dɔɔ na baŋ bee furufu na wonembia kumɛɛ pou. ");
INSERT INTO ntr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Te me nyii nɔɔwoya ŋaale nyi, ‘Pita, koro na n ka ko di.’ ");
INSERT INTO ntr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Te me yakowɔ nyiaa, ‘Me Gbeŋgyoo koa, dee gyu lem, kolo kum yaa kpene keŋ dɛɛ kɔle nɛ te tinaa ta me nɔɔ see ya.’ ");
INSERT INTO ntr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Te nɔɔwoya ŋan besewɔ yako man lee adido bolate nyiaa, ‘Kpene keŋ Wurubuarɛ be lɛɛ do nyi ke dei nɛ, na baake ke nyi kolo anekɔlaŋ ya.’ ");
INSERT INTO ntr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ke yɛɛwɔ mena betabotooro te be wɔŋa woni keŋ pou laŋ adido bela. ");
INSERT INTO ntr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Debaŋ kenaŋ na baala batooro baŋ Konelio be kpili lee Kaesaria kɔŋ me gyaŋ nɛ, te kaa sem dekpaŋalaŋ keŋ man me kyaa nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Te Wurubuarɛ feliŋ yako maŋ nyi, me na lɛɛ ma wose aŋmaareŋ ya, maa sila wɔ gyu. Me tebia looro kɛwɔ sila maŋ lee Gyopa gyu Kaesaria te de popou gyuuwɔ ka gyoo Konelio dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Botɔɔ te ɔ yako daa mena keŋ Wurubuarɛ kpilale be kaa bɛɛ lee ɔ dɔɔ ɔ dekpaŋalaŋ man, te ɔ yako e nyi kpila gyu Gyopa ke baake balee ŋon bɛɛ baake e nyi Simɔn Pita nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Waa kɔŋ kaa yako ŋon nombia kpaakpaa ŋan gyae ke yela ɛmɛɛ na n dekpaŋalaŋmantena pou ke nyiŋ nyeekelɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Me ke gyina me nɔɔ mee kolosi pɛ, te Wurubuarɛ feliŋ ŋon kɔŋawɔ kaa gyoo be man, ŋgba mena keŋ ba gyoo de man kewalaŋ keŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Botɔɔ te me tɔɔse de Gbeŋgyoo Yesu nɔɔwoya ŋan ɔ be yako nyi, ‘Loŋ te Gyɔn moowɔ sɔ balaŋ Wurubuarɛ loŋ, mɔna Wurubuarɛ waa mo ɔ feliŋ ŋon bo sɔ ŋon Wurubuarɛ loŋ.’ ");
INSERT INTO ntr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mena keŋ Wurubuarɛ ba mo ɔ feliŋ do de man debaŋ keŋ man dɔɔ lɛɛ de Gbeŋgyoo Yesu Kristo di nɛ, mena ke yaa ɔ moowɔ do baŋ mɔ man. Kenaŋ na, maŋ yɛna amɔte ŋon maa tale tɔ Wurubuarɛ gbɛɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Be ke nyii nombia kɛŋa nɛ be tinaa nombia ŋan kewɔŋee yela te ba lese Wurubuarɛ yele nyi, “Nɛnɛɛ dɔɔ, Wurubuarɛ te fa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ mɔ gbɛɛ nyi, baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa nyiŋ nyeedoŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Be ka ko Sitifin wɔle nɛ, baŋ bɔɔ lɛɛ Kristo di nɛ yaaseewɔ lee mena keŋ bɛɛ naase wɔ diyem dɔɔ. Baale gyuuwɔ naŋ Tunisia na Saiporɔse tɛɛle man, na Antiɔke donɔɔ man bɛɛ yako Yesu nombia ŋan fa Gyudatena baageŋ. ");
INSERT INTO ntr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mɔna baŋ bɔɔ lɛɛ Kristo di nɛ man baale baŋ bɔɔ lee Saiporɔse na Kirene nɛ, gyuu Antiɔke ke yako de Gbeŋgyoo Yesu wose man nombia kpaakpaa ŋan fa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","De Gbeŋgyoo Wurubuarɛ seŋawɔ be wɔle te balaŋ burum lɛɛ nombia ŋan di te be kyɛɛkeewɔ lee be gbɛɛneŋ kumɛɛ man, te be kɔŋawɔ de Gbeŋgyoo Yesu gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Debaŋ keŋ Kristotena baŋ be kyaa Gyerusalɛm be nyii nombia kɛŋa nɛ, be kpila Banabase gyu Antiɔke. ");
INSERT INTO ntr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ɔ ke gyu ka gyoo botɔɔ te ɔ kena mena keŋ Wurubuarɛ ba mo ɔ bɛrɛɛ boele wɔ nɛ, yɛɛ e gyoŋ te ɔ doo be popou kakyeŋ nyi baa mo be konɔɔ pou sila de Gbeŋgyoo Yesu. ");
INSERT INTO ntr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabase yɛɛ walaŋ kpaakpaate ŋon ɔ be lɛɛ Kristo nombia ŋan di, te Wurubuarɛ feliŋ doo ɔ man nideli. De Gbeŋgyoo Wurubuarɛ moo balaŋ burum kaa kpu na Kristotena dikpii keŋ. ");
INSERT INTO ntr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Te Banabase gyuu Tasuse ɔ kaa kɛo Sɔɔl. ");
INSERT INTO ntr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ɔ kena e nɛ ɔ moo e kɔŋ Antiɔke. Kulutoo dibiliŋ pou na Banabase na Sɔɔl ne kyaa gyaŋee Yesu kaseela dikpii dinaa keŋ na bɛɛ wola wɔ. Antiɔke botɔɔ te be taŋgbɛɛwɔ baake Yesu silala baŋ nyi Kristotena. ");
INSERT INTO ntr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Weeya ŋenaŋ man te Wurubuarɛ akpeŋkpeŋgyɔɔra baale lee Gyerusalɛm gyu Antiɔke. ");
INSERT INTO ntr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Keŋte be man ŋolo ŋon bɛɛ baake e Agabuse nɛ korowɔ seŋ te Wurubuarɛ feliŋ tɛɛwɔ ɔ dɔɔ yako nombia see nyiaa, tanam dinaa daale gyae kekɔŋ tɛɛle keŋ pou dɔɔ. (Tanam dinaa kei kɔŋawɔ mena ampaŋ debaŋ keŋ gyoo dinaa Klaudiuse ne di gyoori nɛ.) ");
INSERT INTO ntr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mena dɔɔ kaseela baŋ yɛɛ ba agyueŋ nyi be man walaŋ kamasɛ waa fa kolo ɔ ke talebii man, na baa mo yelee be tebia Kristotena baŋ be kyaa Gyudia tɛɛle man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Te ampaŋ be yɛɛwɔ mena. Ba moo abɔɔ ŋan bɔɔ faa nɛ do Banabase na Sɔɔl nyiŋmaa man, te ba moowɔ gyina kegyiise baŋ be kyaa botɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Debaŋ kenaŋ man te gyoo Herode fiasɛɛ ɔ ne naase Kristotena baŋ baale diyem. ");
INSERT INTO ntr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɔ yela ba moo sila ko Gyɔn ɔ kegyia Gyemisi. ");
INSERT INTO ntr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ɔ kena nyi kpene keŋ ɔ be yɛɛ nɛ dana Gyudatena baŋ gyoŋ nɛ, te ɔ yela be kyaŋa Pita mɔ. Na ke yɛɛ Gyudatena wee dinaa keŋ bee di bodobodo keŋ tee keŋ ne yeli bodobodo na koro nɛ be doo ke man ya nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ɔ ke kyaŋ Pita do deni man wɔle nɛ, ɔ moo e do yoonɔɔtena akpeŋ anaara nyiŋmaa man nyi baa gyee e. Yoonɔɔtena banaara doo la dekpeŋ kamasɛ man. Herode yɛɛ ke nyi akpaa be di ba nyeekelɛɛwee dinaa keŋ taŋ nɛ, na waa di ɔ nombia balaŋ nsana. ");
INSERT INTO ntr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mena dɔɔ ɔ yela Pita doowɔ deni man botɔɔ, mɔna Kristotena dikpii keŋ ne fane nideli fa Wurubuarɛ ɔ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nelim keŋ pɛ tɛɛ kena, na gyoo Herode ka lese Pita lee deni man na baa di ɔ nombia nɛ, na ɔ doo yoonɔɔtena bala nsana keŋ bɔɔ do e agbaraagbaraase ala. Debaŋ kenaŋ na yoonɔɔtena baŋ bee gyee denanɔɔ keŋ mɔ seŋɛɛ be daseŋae man. ");
INSERT INTO ntr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Karatetee dokoloŋ na te de Gbeŋgyoo Wurubuarɛ kpilale ŋolo bɛɛwɔ lee botɔɔ te deni keŋ man ŋmaŋeewɔ. Te ɔ kyaŋa Pita ɔ degbaŋgbaŋ dɔɔ wosi e te ɔ gyuusu e yako e nyi, “Koro bileŋ.” Debokenaŋ man te agbaraagbaraase ŋan leewɔ ɔ nyiŋmaase man yala. ");
INSERT INTO ntr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Botɔɔ te Wurubuarɛ kpilale ŋon yako e nyiaa, “Mo nya abɔɔ do na n ka do nyaŋ nkyokotase.” Te Pita mɔ yɛɛwɔ mena te kpilale ŋon yako e bela nyi, mo n kegba wurikyim keŋ do na n ke sila maŋ. ");
INSERT INTO ntr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Te Pita sila e lee debɔɔ man. Mɔna ɔ ta gyem nyi kpene keŋ Wurubuarɛ kpilale ŋon ne yɛɛ nɛ yɛɛ ampaŋ ya. Nawolo nyi ŋon gyaŋ na, yɛɛ e bo ŋgba dosɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Be tɛɛwɔ gbaa balaŋ gyaŋgba nyibaŋ baŋ bee gyee botɔɔ nɛ, na baŋ be gyakaa be dɔɔ nɛ, kaboena be ke lii nyeele denanɔɔ keŋ na mo lee donɔɔ keŋ man nɛ gyaŋ. Be kelii botɔɔ na, te nyeele denanɔɔ keŋ torowɔ fa wɔ ka wose dɔɔ, te ba leewɔ laŋ. Ba ke ta bee gyuu na, te kpilale ŋon ŋaalaawɔ yela Pita karatetee dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Botɔɔ te Pita sia ŋmaŋee e te ɔ yakowɔ nyiaa, “Nɛnɛɛ, me ta gyem nyi de Gbeŋgyoo Wurubuarɛ kpila na ɔ kpilale nyi ɔ kaa lese maŋ lee gyoo Herode nyiŋmaa man, na ŋan pou nafɔ Gyudatena be bake see nyi baa yɛɛ maŋ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita kena mena nombia kɛŋa nɛ, te ɔ gyuu Gyɔn Maake ɔ naa Mɛɛre dɛɛ. Debaŋ kenaŋ na balaŋ burum te yilaa botɔɔ bɛɛ fane. ");
INSERT INTO ntr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ke gyɔ be disim keŋ te alebu ŋolo ŋon bɛɛ baake e nyi Roda nɛ, gyuuwɔ ke kɛɛ nyi amɔte ne gyɔɔ laa. ");
INSERT INTO ntr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ɔ ke gyu kenyii woya ŋan te ɔ ba gyem nyi Pita woya ŋenaŋ nɛ, yɛɛ e gyoŋ nideli te ɔ woleewɔ nyi waa toro e denanɔɔ keŋ. Mena dɔɔ ɔ yeuwɔ keyako wɔ nyiaa, “Pita te kɔŋ ɔ seŋɛɛ denanɔɔ man!” ");
INSERT INTO ntr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Te be bɔɔse e nyiaa, “Yaa n na gyoo diteŋ bo?” Mɔna ɔ yase ɔ sia yako wɔ nyi yɛɛ ampaŋ. Keŋte be yakowɔ nyi gyae ke yɛɛ ɔ woo bo. ");
INSERT INTO ntr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Na Pita gyakaa bo ɔ ne gyɔ denanɔɔ keŋ. Nɛnɛɛ be ka toro denanɔɔ keŋ na Pita seŋɛɛ laa, mena dɔɔ ba wose gbirisi wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Te Pita gyina ɔ nyiŋmaa adido mo yako wɔ nyi baa wu be nɔɔ. Te ɔ yako wɔ mena keŋ de Gbeŋgyoo Wurubuarɛ ba lese e lee deni keŋ man. Te ɔ yako wɔ nyi, “Ɛ yako Gyemisi na Kristotena akaŋ baŋ mena nombia kɛŋa.” Te ɔ korowɔ laŋ yenaŋ wɔle. ");
INSERT INTO ntr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tɛɛ kena keŋ nɛ, te aŋmaareŋ dinaa daale gyoowɔ yoonɔɔtena baŋ nsana. Be bɔɔse dɔŋa nyi, “Aleŋ yaa Pita moowɔ baa?” ");
INSERT INTO ntr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gyoo Herode yela be kɛo Pita nideli, mɔna ba te naa e ya. Mena dɔɔ ɔ baake yoonɔɔtena baŋ bɔɔ gyee e nɛ, nyii be nɔɔman nombia, te ɔ yela ba koo wɔ pou. Kenaŋ wɔle nɛ, gyoo Herode leewɔ Gyudia tɛɛle man gyu kekyaa Kaesaria donɔɔ man kyomii. ");
INSERT INTO ntr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Gyoo Herode gyeŋa baŋ Taetena na Sidɔntena dɔɔ. Mena dɔɔ balaŋ benaŋ yɛɛ nɔɔ te be gyuuwɔ kena e. Be taŋgbɛɛwɔ mo nombia ŋenaŋ do Bilasituse nɔɔman nyi waa doo e teree fa wɔ, nawolo nyi donɔɔse ala ŋenaŋ pou ne nyiŋ be weenɛɛ bo lee gyoo ŋonaŋ tɛɛle man. Bilasituse yɛna gyoo ŋon dekpaŋalaŋ keŋ pou kegyia. ");
INSERT INTO ntr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Wee keŋ bɔɔ see kelii nɛ, te gyoo Herode moo ɔ gyooro abɔɔ do, te ɔ gyuuwɔ ka gyeŋ gyakaa ɔ gyooro gbeli keŋ dɔɔ te ɔ kolosiwɔ fa balaŋ baŋ pou. ");
INSERT INTO ntr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Te balaŋ baŋ pou fae yeesa yako nyi, “Kei dɔɔ te yɛɛ deniwalaŋ ne kolosi la ya, yɛɛ bane ŋolo e.” ");
INSERT INTO ntr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Debokenaŋ man te de Gbeŋgyoo Wurubuarɛ kpilale kɔŋawɔ kaa gyɔ e do kawee, nawolo nyi ɔ ta lese Wurubuarɛ yele ya. Te gyoo ŋon wose pou gyoo feelɛɛ te ɔ yeŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kɛŋa pou man na, Wurubuarɛ nombia ŋan sɛɛ ŋɛɛ yaasee na balaŋ burum mɔ ne lɛɛ ŋa di. ");
INSERT INTO ntr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Debaŋ keŋ Banabase na Sɔɔl be taŋ ba tom keŋ nɛ, ba besewɔ lee Gyerusalɛm gyu Antiɔke. Be kee gyu keŋ nɛ, te ba moo Gyɔn Maake sila ba wose. ");
INSERT INTO ntr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kristotena dikpii keŋ ke kyaa Antiɔke donɔɔ man nɛ, na be dana Wurubuarɛ akpeŋkpeŋgyɔɔra na wolala be man. Baŋ yɛna Banabase na Simeɔn ŋon bɛɛ baake e nyi walaŋ bibiini nɛ na Lusiuse ŋon ɔ ba lee Kirene nɛ, na Sɔɔl na Manayen ŋon bɔɔ kɛɛle ŋon na gyoo Herode Antipase bom nɛ. Gyoo Herode Antipase yɛna walaŋ ŋon ɔ seŋɛɛ gyoo dinaa nawɔɔ man Galelia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wee daale be kɛɛ som Wurubuarɛ nɛ, be bake be nɔɔ bɛɛ fane te Wurubuarɛ feliŋ yako wɔ nyiaa, “Ɛ lese Banabase na Sɔɔl fa maŋ, na baa yɛɛ tom keŋ dɔɔ mɔɔ baake wɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mena dɔɔ ba kebake be nɔɔ fane taŋ nɛ, ba moo be nyiŋmaase gyakaa be dɔɔ fane fa wɔ te be lɔɔ wɔ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wurubuarɛ feliŋ ke kpila Banabase na Sɔɔl nɛ, be gyuu Selusia. Botɔɔ te ba moo degbele dinaa mo loŋ dɔɔ gyu Saiporɔse tɛɛle keŋ loŋ be kilisi ke nɛ man. ");
INSERT INTO ntr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Be kelii Salamise nɛ be yako Wurubuarɛ nombia ŋan Gyudatena ɔsom denɛɛ man. Na Gyɔn Maake mɔ kpuɛ na wɔ ɔ ne kyɔ wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Be kila tɛɛle kenaŋ dɔɔ pou gbaa ke gyu ke lii Pafose donɔɔ man. Botɔɔ te ba ke naa ŋmeeseŋte ŋolo ŋon bɛɛ baake e nyi Baa Yesu nɛ. Ɔ yɛɛ Gyuda baale e te ɔ moo ɔ wose yɛɛ ŋgba Wurubuarɛ dekpeŋkpeŋgyɔɔre nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Na ɔ yɛɛ gyoo ŋon ɔ seŋɛɛ gyoo dinaa nawɔɔ man tɛɛle kenaŋ man nɛ ɔ dɔɔ e. Bɛɛ baake e nyi Segiuse Pɔluse. Na ɔ yɛɛ walaŋ ŋon ɔ gyeŋ nombia nideli. Ɔ baake Banabase na Sɔɔl ɔ gyaŋ, nawolo nyi na ɔ ne gyae waa nyii Wurubuarɛ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mɔna ŋmeeseŋte ŋon ɔ yele Giriki dei man yɛna nyi Elimase nɛ, korowɔ seŋ tia Banabase na Sɔɔl. Ɔ gyaewɔ nyi waa lese gyoo ŋon agyueŋ lee Wurubuarɛ nombia ŋan man, na ɔ be nyiŋ lɛɛ ŋa di ya. ");
INSERT INTO ntr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Keŋte Sɔɔl ŋon bɛɛ baake e nyi Pɔɔl te Wurubuarɛ feliŋ doo ɔ man nideli nɛ, kɛɛ ŋmeeseŋte ŋon diiŋ te ɔ yako e nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nyaŋ ɔbɔnsam bu! N ne kɔla kpene kamasɛ keŋ dei, nyaŋ yɛna dekara na adao kumɛɛ pou nyee. Woromɔ te n ke tina de Gbeŋgyoo Wurubuarɛ nombia ŋan doo na ŋe gbɛɛ nɛ ketulii yela? ");
INSERT INTO ntr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","De Gbeŋgyoo Wurubuarɛ waa lese ɔ doŋ wola neŋ. N sia gyae keyɛlɛɛ, te n be gyae n kena weese ya, kelii debaŋ daale.” Debokenaŋ man te ɔ sia yɛlɛɛwɔ, na ɔ dɔŋ ɔ ne lalaa ɔ ne gyae walaŋ ŋon waa kyaŋ e ɔ nyiŋmaa man wola e gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gyoo kemaasa ŋon kena kpene keŋ be kɔŋ balee kei dɔɔ nɛ ɔ lɛɛ Yesu di, nawolo nyi ɔ nombia ŋan bɔɔ wolo nɛ yela ɔ wose gbirisi e. ");
INSERT INTO ntr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔl na ɔ tebia moowɔ loŋ dɔɔ lee Pafose kelii Pɛga keŋ kyaa Pamfilia tɛɛle man nɛ. Botɔɔ te Gyɔn Maake tinaa wɔ yela te ɔ besewɔ laŋ Gyerusalɛm. ");
INSERT INTO ntr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Be ka lee Pɛga nɛ, be gyuuwɔ kelii Antiɔke keŋ kyaa Pisidia tɛɛle man nɛ, te Gyudatena kefɛɛfowee keŋ kelii nɛ, be gyuu Gyudatena ɔsom deni man kekyaa. ");
INSERT INTO ntr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Gyudatena baŋ kekala lee Mosesi mmaraa tɔne na akpeŋkpeŋgyɔɔra tɔna ŋan man taŋ nɛ, bɔ ɔsom deni man kegyiise baŋ yako Pɔɔl na ɔ tebia nyiaa, “De tebia, akpaa ɛ dana kolo ɛ ka mo do balaŋ baŋ kakyeŋ na, ɛ kolosi fa wɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Botɔɔ te Pɔɔl korowɔ seŋ te ɔ gyinaa ɔ nyiŋmaa adido nyi baa yela kekolosi. Te ɔ fiasɛɛ ɔ ne kolosi nyiaa, “Iseraetena na ɛmɛɛ baŋ ɛ te yɛɛ Iseraetenawɔ ya, te ɛ ne yee Wurubuarɛ nɛ ɛ tei maŋ! ");
INSERT INTO ntr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iseraetena Wurubuarɛ lese na de naanaɔ, te ɔ yela be nyiŋa ba wose debaŋ keŋ be kyaa Igyipite tɛɛle man nɛ. Wurubuarɛ moo ɔ doŋ dinaa keŋ lese wɔ lee tɛɛle kenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Te ɔ nyiŋa konɔɔ fa wɔ kulutooneŋ sɔŋola (40) depampaa dinaa keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wurubuarɛ yela ɔ balaŋ dii debiise nyetooro dɔɔ Kaanan tɛɛle man, te ɔ lɛo be tɛɛlese fa wɔ kekpaakekpaa. ");
INSERT INTO ntr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lee debaŋ keŋ Wurubuarɛ ba lese ɔ balaŋ lee Igyipite, kaa lii mena debaŋ kei nɛ yɛɛ kulutooneŋ sɔŋonoŋ akpeŋ anaara na sɔŋola na kufu (450). Kei wɔle nɛ, Wurubuarɛ faa wɔ nombiadiira kelii ɔ dekpeŋkpeŋgyɔɔre Samuɛle dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Keŋte balaŋ baŋ yako Wurubuarɛ nyi waa see gyoo fa wɔ. Te ɔ moo Kisi ŋon ɔ ba lee Bɛngyamɛn dekpaŋalaŋ man nɛ bu Sɔɔl fa wɔ, te Sɔɔl dii gyoori kulutooneŋ sɔŋola (40).” ");
INSERT INTO ntr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wurubuarɛ ka lese Sɔɔl lee gyoori man nɛ, ɔ moo Defidi see gyoo. Wurubuarɛ dii adansɛɛ lee ɔ wose man nyiaa, “Me te nyiŋ Gyese bu Defidi ŋon mɛɛ gyae e lee me konɔɔ man. Ŋon ne gyae la waa yɛɛ kpene kamasɛ keŋ mɛɛ gyae. ");
INSERT INTO ntr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Defidi kei duuluŋ man te Wurubuarɛ lese nyeelɛɛre Yesu, te ɔ kɔŋawɔ Iseraetena gyaŋ ŋgba mena keŋ ɔ be yako see nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pɛte Yesu ke kɔŋ na, Gyɔn taŋ kekolosi fa Iseraetena pou nyi, baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man, na baa kɔŋ Wurubuarɛ gyaŋ na baa sɔ wɔ Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Gyɔn kɛɛ gyae waa taŋ ɔ tom nɛ ɔ bɔɔse balaŋ baŋ nyiaa, ‘Ɛmɛɛ gyeŋ nyi maŋ yɛna amɔte? Na maŋ yɛna walaŋ ŋon ɛ ne daa nɛ ya. Ɛ kɛɛ, ŋon ɛ ne daa nɛ dɔŋ me wɔle ɔ ne kɔŋ. Te maŋ Gyɔn be kaboena nyi maa buŋ booli ɔ nkyokota ŋmeeseŋ gba ya.’ ");
INSERT INTO ntr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Me tebia Aberaham duuluŋ man bia, na ɛmɛɛ baŋ ɛ te yɛɛ Iseraetenawɔ ya te ɛ ne yee Wurubuarɛ nɛ, daa te Wurubuarɛ yela ba moo nyeedoŋ nombia kɛŋa kɔna. ");
INSERT INTO ntr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nawolo nyi Gyerusalɛmtena, na be siamantena baŋ ta gyem nyi ŋon yɛna nyeelɛɛre ŋon ya. Be te nyii nɔɔwoya ŋan akpeŋkpeŋgyɔɔra baŋ be ŋmarase see, te bɛɛ kale ba kefɛɛfowee kamasɛ man nɛ ya. Mɔna be ke bu e fɔɔ keŋ nɛ, yela akpeŋkpeŋgyɔɔra nɔɔwoya ŋan bɔɔ ŋmarase see lee ɔ wose man nɛ kɔŋawɔ mena. ");
INSERT INTO ntr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Keŋ koraŋ be te nyiŋ nombiikum baa seŋ ke dɔɔ bu e fɔɔ na ba ko e ya nɛ, ba sola Gyoo Pilato nyi waa lese e fa wɔ na baa ko. ");
INSERT INTO ntr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba ke yɛɛ ŋan pou bɔɔ ŋmarase lee ɔ wose man taŋ nɛ, ba lese e lee ɔpaŋdaŋ keŋ dɔɔ ke wuu boe bɔɔ daale man. ");
INSERT INTO ntr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mɔna Wurubuarɛ gyuusu e lee yeŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Te ɔ lese ɔ wose wola balaŋ baŋ ŋon na wɔ ne kyaa ta lee Galelia gyu Gyerusalɛm donɔɔ man nɛ weeya burum man. Balaŋ baŋ ɔ ba lese ɔ wose wola wɔ nɛ, ne diina ɔ wose man adansɛɛ fa de balaŋ Iseraetena gyɛŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Wurubuarɛ nombia kpaakpaa ŋenaŋ yaa dɛɛ yako ŋon nɛ. Wurubuarɛ nombia kpaakpaa ŋan ɔ be yako see fa de naanaɔ nyi waa yɛɛ nɛ, nɛnɛɛ ɔ te yɛɛ ŋa fa daa baŋ de yɛɛ be duuluŋ man balaŋwɔ nɛ, nawolo nyi ɔ te gyuusu Yesu lee yeŋ man. Be ŋmarasewɔ Defidi nɔɔneŋ alate man nyi, Wurubuarɛ kpa ‘Nyaŋ yɛna me bu, gyɛŋ me yɛɛ n kya e.’ ");
INSERT INTO ntr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wurubuarɛ besewɔ yako ɔ tɔne keŋ yenaŋ daale mena keŋ waa gyuusu Yesu lee yeŋ man na ɔ be doo yebɔɔ man dala ya nɛ nyi, ‘Maa mo me nyiŋmaa gyakaa ɛ dɔɔ ampaŋ ampaŋ, ŋgba mena keŋ mɔɔ yako see fa Defidi nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Defidi nɔɔneŋ tɔne keŋ man yenaŋ daale na, ɔ besewɔ yako nyi, ‘N be gyae n ke yela n tobaale ŋon ayimɛɛ be doo ɔ wose man ya nɛ ke dala ya.’ ");
INSERT INTO ntr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Defidi ke kyaa na ɔ sia, te ɔ ka som Wurubuarɛ taŋ ŋgba mena keŋ Wurubuarɛ ne gyae nɛ, ɔ moo ɔ kpaa teeli te ba moo e ke wuu ɔ naanaɔ gyaŋ te ɔ dalawɔ. ");
INSERT INTO ntr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mɔna walaŋ ŋon Wurubuarɛ be gyuusu e lee yeŋ man nɛ, ŋon te dale ya. ");
INSERT INTO ntr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mena dɔɔ me tebia, mɛɛ gyae ɛ ka gyeŋ nideli nyi Yesu adaworoma dɔɔ te dɛɛ yako ŋon mena keŋ walaŋ waa yɛɛ, na Wurubuarɛ ka mo ɔ dukum kyɛɛ e. ");
INSERT INTO ntr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lee Yesu dɔɔ walaŋ kamasɛ ŋon ɔ lɛɛ Wurubuarɛ nombia ŋan di na waa di deŋele, nawolo nyi nafɔ ŋolo be kyaa keŋ waa tale di Mosesi mmaraase ŋan dɔɔ, na waa di deŋele Wurubuarɛ siaman ya. ");
INSERT INTO ntr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lee mena dɔɔ ɛ kɛɛ ɛ wose man nideli, na nombia ŋan Wurubuarɛ akpeŋkpeŋgyɔɔra be ŋmarase see nɛ, be kɔŋ ɛ dɔɔ ya. Be ŋmarasewɔ nyiaa, ");
INSERT INTO ntr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ɛ kɛɛ, ɛ mɛɛ baŋ ɛ ne kulu Wurubuarɛ nɛ, gyakoloŋ gyae ka gyoo ŋon, na ɛ ka yeŋ futaa ɛ wose. Nawolo nyi maa yɛɛ tom daale ɛ weeya kɛŋa man, keŋ nyi ɛ be gyae ɛ ke lɛɛdi ya. Akpaa ŋolo de yako ŋon koraŋ na, ɛ be gyae ɛ ke lɛɛdi ya.’ ” ");
INSERT INTO ntr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mena dɔɔ debaŋ keŋ Pɔɔl na Banabase ba lee bɔ ɔsom deni keŋ man bee gyu keŋ nɛ, balaŋ baŋ waase wɔ nyi baa bese kɔŋ ba kefɛɛfowee anekɔŋaŋ, na be kaa yako wɔ mena nombia kɛŋa bela kpu. ");
INSERT INTO ntr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Balaŋ baŋ ke yaasee taŋ keŋ nɛ, Gyudatena burum na balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya te bee yee Wurubuarɛ te bɔɔ mo ba wose do Gyudatena ɔsom keŋ man nɛ, sila Pɔɔl na Banabase. Te Pɔɔl na Banabase kolosiwɔ do wɔ kakyeŋ nyi, wee kamasɛ na baa tɔɔse Wurubuarɛ bɛrɛɛ keŋ ɔ ba mo boele wɔ nɛ nideli na baa kyaa fa e. ");
INSERT INTO ntr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Gyudatena kefɛɛfowee ka bese lii nɛ, donɔɔ keŋ pou kaa yilaawɔ nyi baa nyii de Gbeŋgyoo Wurubuarɛ nombia. ");
INSERT INTO ntr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Gyudatena kena balaŋ baŋ yaanɔɔle nɛ be sia yɛɛwɔ be dɔɔ, mena dɔɔ be lɛɛ Pɔɔl nombia ŋan ɔ ne yako nɛ aŋmaareŋ te ba tee e. ");
INSERT INTO ntr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Te Pɔɔl na Banabase gyɔɔ be konɔɔ yako wɔ nyi, “Nafɔ kaboena nyi dɛɛ taŋgbɛɛ kolosi Wurubuarɛ nombia ŋan bo fa ŋon pɛ, mɔna keŋ ɛ be bɛɛ ŋa te ɛ be kɛɛ ɛ wose nyi ɛ be kaboena nyi ɛ ke nyiŋ nyeedoŋ kekpaa keŋ dɔɔ ya nɛ, dɛɛ lee ɛ gyaŋ dee gyu baŋ ba te yɛɛ Gyudatenawɔ ya nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nawolo nyi keŋ de Gbeŋgyoo Wurubuarɛ be yako daa yɛna nyi, ‘Me ta mo neŋ yɛɛ keŋmaŋee fa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ, na n ka wola wɔ gbɛɛ keŋ tɛɛle kei dɔɔ balaŋ baa mo na baa nyiŋ nyeekelɛɛ nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mɔna balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya ke nyii nombia kɛŋa nɛ, yɛɛ wɔ gyoŋ nideli te ba lese Wurubuarɛ yele lee ɔ nyeedoŋ nombia ŋan dɔɔ. Te baŋ Wurubuarɛ ba lese wɔ nyi baa nyiŋ nyeedoŋ kekpaa keŋ nɛ, lɛɛ de Gbeŋgyoo Yesu di.” ");
INSERT INTO ntr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Te de Gbeŋgyoo Yesu nombia ŋan yaaseewɔ tɛɛle keŋ dɔɔ pou. ");
INSERT INTO ntr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mɔna Gyudatena baŋ feefuwɔ do kegyiise baŋ na ala baŋ bee yee Wurubuarɛ te ba wose dana obuo donɔɔ kenaŋ man nɛ, te be naase Pɔɔl na Banabase diyem, te be gegi wɔ lee tɛɛle keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mena dɔɔ Kristo kpilala baŋ kpiisi be nawɔɔ tɛɛ aŋasa see wɔ na kawola nyi ba te bɛɛ wɔ, te ba lese be nae botɔɔ te be laŋa Ikonium. ");
INSERT INTO ntr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mɔna Yesu silala baŋ be kyaa botɔɔ nɛ dɔɔ, yɛɛ wɔ gyoŋ nideli na Wurubuarɛ feliŋ ŋon mɔ doo be man nideli. ");
INSERT INTO ntr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔɔl na Banabase ka gyoo Ikonium donɔɔ keŋ man nɛ, be gyuu Gyudatena ɔsom deni keŋ man ŋgba mena keŋ bɛɛ taŋ yɛɛ nɛ. Be kolosi Wurubuarɛ nombia ŋan nideli, te Gyudatena na baŋ ba te yɛɛ Gyudatenawɔ ya nɛ burum lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mɔna Gyudatena baŋ bɔɔ bɛɛ nyi bɔɔ lɛɛ Yesu di ya nɛ, feefuwɔ do baŋ ba te yɛɛ Gyudatenawɔ ya nɛ te ba korowɔ seŋ tia Pɔɔl na Banabase. ");
INSERT INTO ntr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔl na Banabase kyaawɔ botɔɔ weeya akalansɛɛ ŋaale, te be gyɔɔ be konɔɔ kolosi de Gbeŋgyoo Yesu nombia ŋan. Ŋon mɔ seŋawɔ be wɔle te ɔ moo ɔ bɛrɛɛ boele wɔ, te be yɛɛ nombia dinaana na gyakoloŋ nombia botɔɔ wola nyi ɔ nombia ŋan bee kolosi nɛ doo na ŋe gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mena dɔɔ donɔɔ keŋ man balaŋ kpasewɔ akpeŋ ala. Dekpeŋ daale seŋawɔ Gyudatena baŋ wɔle, te daale mɔ seŋawɔ Kristo kpilala baŋ wɔle. ");
INSERT INTO ntr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Keŋte Gyudatena na baŋ ba te yɛɛ Gyudatenawɔ ya nɛ, man baale na be siamantena yɛɛ nɔɔdokoloŋ nyi, baa naase Pɔɔl na Banabase diyem na baa fuŋii wɔ boya. ");
INSERT INTO ntr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Pɔɔl na Banabase ke nyii mena nombia kɛŋa nɛ, be yeuwɔ lee donɔɔ kenaŋ man gyu Listra na Dɛbi donɔɔse ŋan kyaa Likonia tɛɛle man nɛ, na donɔɔse ŋan benaa na botɔɔ nɛ pou kekolosi Wurubuarɛ nombia kpaakpaa ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Be ke gyu kelii Listra donɔɔ keŋ man nɛ, na ɔtakase ŋolo kyaa botɔɔ keŋ nyi leenaŋ bɔɔ lola e na, ɔ te tale ta koro ta ya. ");
INSERT INTO ntr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɔ ke kyaa botɔɔ ɔ ne tei Pɔɔl kekolosi nɛ, Pɔɔl kɛɛ e yididi te ɔ naawɔ nyi ɔ kelɛɛdi gyae ke tale yela waa nyiŋ kawee kekyɔ, ");
INSERT INTO ntr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","keŋte Pɔɔl yako e keŋkeŋ nyi “Koro seŋ n nawɔɔ dɔɔ.” Botɔɔ te ɔtakase ŋon toŋawɔ seŋ ɔ nawɔɔ dɔɔ te ɔ fiasɛɛ ɔ ne tɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Balaŋ baŋ kena kpene keŋ Pɔɔl be yɛɛ nɛ, be fae yeesa be dɛɛ Likonia dei man nyi, “Bɛɛneŋ besena na ba wose yɛɛ denibalaŋ kaa seŋ de gyaŋ yaa?” ");
INSERT INTO ntr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mena dɔɔ ba moo be bɛɛneŋ yela do Banabase na Pɔɔl. Ba doo Banabase nyi Sewuse, te ba doo Pɔɔl mɔ nyi Hemise nawolo nyi ŋon yɛna be kolosire. ");
INSERT INTO ntr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na be bane ŋon bɛɛ baake e nyi Sewuse nɛ deni seŋɛɛ donɔɔ keŋ nɔɔman. Te bane Sewuse sae ŋon moo nunkyuese na kyeŋkyeŋkɔɔse kaa seŋ donɔɔ keŋ nɔɔman, nawolo nyi ŋon na balaŋ dikpii keŋ ne gyae baa fa Pɔɔl na Banabase kedi ŋgba bɛɛneŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mɔna Banabase na Pɔɔl ke nyii nombia kɛŋa nɛ, be kyaŋa ba kegbase tirii na kawola nyi nombia ŋan te takaa wɔ, te ba moo yeesa yeu karatetee dokoloŋ kagyoo balaŋ dikpii burum baŋ nsana nyi, ");
INSERT INTO ntr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“De tebia, woŋ nombia yaa kɛŋa, weera ɛ ne yɛɛ mena? Daa mɔ yɛɛ denibalaŋwɔ ŋgba ɛmɛɛ nɛ. De kɔŋae de kaa yako Kristo nombia kpaakpaa ŋan fa ŋon, na ɛ ke tina ɛ nombia kɛŋa ŋan be taŋ tɔnɔɔ ya nɛ keyɛɛ yela, na ɛ ke kɔŋ Wurubuarɛ ŋon ɔ bɛɛ yem ya nɛ gyaŋ. Ŋon yɛɛna adido na ateta na ɛpo, na kpene kamasɛ keŋ doo ŋe man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gyaŋgba keŋ na, ɔ yela balaŋ yɛɛ kpene keŋ baŋ gbagba ne gyae. ");
INSERT INTO ntr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mɔna ɔ na lese ɔ wose wola nyi ɔ kyaa ampaŋ, lee deeli keŋ ɔ ne yɛɛ nɛ dɔɔ, te ɔ ne fa ŋon ɔga na ɛ wɔɔse man weenɛɛ debaŋ kpaakpaate man. Ɔ ne fa ŋon weenɛɛ te ɔ ne yeli ɛ sia na gye.” ");
INSERT INTO ntr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kristo kpilala baŋ ke yako kɛŋa koraŋ na, yɛɛ wɔ doŋ pɛte be talewɔ tɔ balaŋ baŋ gbɛɛ nyi be na fa wɔ kedi ya. ");
INSERT INTO ntr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Gyudatena baale lee Antiɔke keŋ kyaa Pisidia tɛɛle man nɛ, na Ikonium kɔŋ botɔɔ kaa wɔlɛɛ balaŋ baŋ agyueŋ te ba seŋawɔ be wɔle. Keŋte be fuŋii Pɔɔl boya, te be tuu e na tɛɛle lee donɔɔ keŋ man kelɔ donɔɔ nɔɔman. Na baŋ gyeŋ nyi ɔ ta yem. ");
INSERT INTO ntr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mɔna Yesu silala baŋ kekɔŋ kaa yilaa ɔ gyaŋ nɛ, ɔ korowɔ bese gyu donɔɔ keŋ man. Ke tɛɛ kena na te ŋon na Banabase laŋa Dɛbi donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔɔl na Banabase kekolosi Kristo nombia kpaakpaa ŋan Dɛbi donɔɔ man nɛ, balaŋ burum kɔŋawɔ kaa lɛɛ Yesu di te ba bese ɔ silala, Keŋte ba besewɔ gyu Listra na Ikonium na Antiɔke keŋ kyaa Pisidia nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Be kolosiwɔ fa Kristotena baŋ te ba doo wɔ kakyeŋ nyi Kristo nombia ŋan bɔɔ lɛɛ di nɛ, baa kyaŋ ŋa keŋkeŋ. Ba besewɔ do wɔ kakyeŋ nyi, “Kaboena nyi dɛɛ naa diyem nideli pɛna dɛɛ tale gyoo Wurubuarɛ gyoori keŋ man.” ");
INSERT INTO ntr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kristotena dikpii kamasɛ man na, Pɔɔl na Banabase na lese siamantena fa wɔ. Ba lese wɔ taŋ na, bɛɛ bake be nɔɔ fane fa wɔ, na be ta mo be popou do de Gbeŋgyoo Kristo ŋon bɔɔ lɛɛ e di nɛ nyiŋmaa man. ");
INSERT INTO ntr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ba ke ta kila Pisidia tɛɛle dɔɔ taŋ nɛ, be gyuu Pamfilia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Be kolosi Kristo nombia ŋan Pɛga donɔɔ man. Be ka lee botɔɔ na, te be gyuuwɔ Atalia donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Be ka lee botɔɔ mɔ nɛ, ba moowɔ loŋ dɔɔ bese kɔŋ Antiɔke. Antiɔke botɔɔ te Kristotena baŋ fanewɔ mo wɔ do Wurubuarɛ nyiŋmaa man nyi, waa mo ɔ bɛrɛɛ boele wɔ na baa gyu ke yɛɛ tom keŋ bɔɔ yɛɛ taŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ba ke kɔŋ kaa gyoo botɔɔ nɛ, be yilaa Kristotena dikpii keŋ pou te be yako wɔ tom keŋ pou Wurubuarɛ be tɛɛ be dɔɔ yɛɛ, na mena keŋ ɔ ba toro gbɛɛ fa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya, te baŋ mɔ be lɛɛ Kristo nombia ŋan di nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Lee kenaŋ wɔle na, be kyaawɔ be tebia Kristotena baŋ gyaŋ weeya burum. ");
INSERT INTO ntr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Balaŋ baale leewɔ Gyudia tɛɛle man kɔŋ Antiɔke donɔɔ man bɛɛ wola Kristotena baŋ nyi, “Nyi akpaa ɛ te kara ɛ baala wose ŋgba mena keŋ Wurubuarɛ mmaraase ŋan ɔ be yela Mosesi be ŋmarase see nɛ nawolo ya na, Wurubuarɛ be gyae waa tale lɛɛ ɛ nyee ya.” ");
INSERT INTO ntr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mena dɔɔ aŋmaareŋ dinaa daale gyoo balaŋ benaŋ na Pɔɔl na Banabase nsana. Keŋte Kristotena baŋ lese Pɔɔl na Banabase na Antiɔke Kristotena baŋ baale te be kpila wɔ Gyerusalɛm na be kaa naa Kristo kpilala baŋ na ɔsom kegyiise baŋ lee nombii kei dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kristotena baŋ ke lɔ wɔ gbɛɛ taŋ nɛ, ba moowɔ Fonisia na Samaria tɛɛlese man. Te be yako be tebia Kristotena baŋ be kyaa botɔɔ nɛ, mena keŋ balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ ke lɛɛ Yesu nombia ŋan di. Kristotena baŋ nyii nombia kɛŋa na, yɛɛ wɔ gyoŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Be ke gyu ka gyoo Gyerusalɛm nɛ, Kristo kpilala baŋ na ɔsom kegyiise na Kristotena dikpii keŋ pou lɛɛ wɔ nideli, te baŋ mɔ yako wɔ kpene kamasɛ keŋ Wurubuarɛ be tɛɛ be dɔɔ yɛɛ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Te balaŋ baŋ nafɔ be doo Farasiitena dikpii keŋ man te nɛnɛɛ bɔɔ lɛɛ Yesu di nɛ, man baale korowɔ seŋ te be yako wɔ nyi “Kaboena nyi baa yela baŋ ba te yɛɛ Gyudatenawɔ ya nɛ, ke kara be baala wose na baa di Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see nɛ dɔɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mena dɔɔ Kristo kpilala baŋ, na ɔsom kegyiise baŋ gyaŋeewɔ na baa gyoo nombia ŋenaŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba ke kyɔɔle dɔŋa gyu siaman nɛ, Pita korowɔ seŋ te ɔ yako wɔ nyi, “Me tebia, ɛmɛɛ gbagba ɛ gyeŋ nyi leenaŋ kewalaŋ keŋ, te Wurubuarɛ lese maŋ nyi maa kolosi Kristo nombia kpaakpaa ŋan fa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ, na baa nyiŋ nyii na baa lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wurubuarɛ ŋon ɔ gyeŋ walaŋ kamasɛ konɔɔ man nombia nɛ, lesewɔ wola nyi ɔ te lɛɛ wɔ do lee ɔ feliŋ ŋon ɔ ba mo do be man, ŋgba mena keŋ ɔ ba mo do daa mɔ man nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wurubuarɛ te kɛɛ wɔ nyi be yɛɛ balaŋ kpoo lee de man ya, mɔna ɔ moo be nombiakumɛɛ kyɛɛ wɔ lee keŋ bɔɔ lɛɛ Kristo di dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nɛnɛɛ weera te ɛ ne gyae ɛ ke kɛɛse Wurubuarɛ kɛɛ, keŋ ɛ ne gyae ɛ ka mo kasolɔ keŋ daa na de naanaɔ te tale seele ya nɛ, seele baŋ bɔɔ lɛɛ Yesu di nɛ? ");
INSERT INTO ntr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ɛ na yeli ke kɔŋ mena ya! Dɛɛ lɛɛ di nyi de Gbeŋgyoo Yesu bɛrɛɛ keŋ dɔɔ te Wurubuarɛ lɛɛ da nyee, ŋgba mena keŋ ɔ be lɛɛ baŋ mɔ nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Balaŋ baŋ pou bɔɔ gyaŋee nɛ, kyaawɔ yididi debaŋ keŋ bee tei Banabase na Pɔɔl ne yako wɔ mena keŋ Wurubuarɛ be tɛɛ be dɔɔ yɛɛ gyakoloŋ nombia na nombia dinaana balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ba kekolosi taŋ nɛ, te Gyemisi mɔ gyinaa ɔ nɔɔ nyi, “Ɛ tei me gyaŋ, me tebia. ");
INSERT INTO ntr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Debokeiman te Simɔn Pita yako daa mena keŋ Wurubuarɛ be taŋgbɛɛ yɛɛ wola daa nyi ɔ ne gyae balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ, te ɔ lese be man baale mo yɛɛ ɔ wui. ");
INSERT INTO ntr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nombia kɛŋa na Wurubuarɛ akpeŋkpeŋgyɔɔra nombia ŋan te yɛɛ dokoloŋ. Nawolo nyi be ŋmarasewɔ see nyi Wurubuarɛ kpa nyi, ");
INSERT INTO ntr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kei wɔle na, maa bese kɔŋ na maa bese ma Defidi dekpaŋalaŋ keŋ be yɛlɛɛ nɛ, na maa desina ka abɔɔ ŋan be wɔlɛɛ nɛ, na ke ka seŋ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Denibalaŋ akaŋ baŋ na balaŋ baŋ pou ba te yɛɛ Gyudatenawɔ ya te mɔɔ lese wɔ yɛɛ me wui nɛ, baa kɛo maŋ be Gbeŋgyoo Wurubuarɛ ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nnɛ yaa maŋ ɛ Gbeŋgyoo Wurubuarɛ ŋon, mɔɔ wulaa lese kɛŋa wola lee gyaŋgba nɛ ne yako!’ ” ");
INSERT INTO ntr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Gyemisi besewɔ gyina ɔ nɔɔwoya ŋan dɔɔ nyi, “Ma agyueŋ man na, ɛ na yeli dɛɛ mo nombia ŋaale ŋere balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya, te bɛɛ mo ba wose fa Wurubuarɛ nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mɔna ɛ yela dɛɛ ŋmarase wɔ tɔne nyi, be na di bane dɛɛ weenɛɛ ya, na baa lese ba wose lee kafoŋ nombia man. Be na di wonembu ŋon ba te kara ɔ nyee ya te ɔ ba yem nɛ na wonembu fatabo ya. ");
INSERT INTO ntr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nawolo nyi be wula bɛɛ kala Wurubuarɛ mmaraase ŋan ɔ ba mo fa Mosesi nɛ Gyudatena ɔsom deni man kefɛɛfowee kamasɛ, te bee kolosi ɔ nombia ŋenaŋ donɔɔ kamasɛ mɔ man.” ");
INSERT INTO ntr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Keŋte Kristo kpilala baŋ na ɔsom kegyiise baŋ na Kristotena dikpii keŋ mantena akaŋ pou yɛɛ nɔɔ nyi baa lese be man balaŋ baale na baa kpu na Pɔɔl na Banabase, na baa kpila wɔ Antiɔke. Mena dɔɔ ba lese Gyuda ŋon bɛɛ baake e nyi Basabase nɛ, na Silase baŋ ba wose man dana obuo be man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nɔɔwoya ŋan doo tɔne keŋ man yɛna nyi. “Daa Kristo kpilala na ɔsom kegyiise na ɛ tebia baŋ be kyaa Gyerusalɛm donɔɔ man nɛ, ne ŋmarasena tɔne kei dee yelee ɛmɛɛ Kristotena baŋ ɛ te yɛɛ Gyudatenawɔ ya, te ɛ kyaa Antiɔke na Siria na Silisia tɛɛlese man nɛ. Dɛɛ do ŋon nɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","De te nyii nyi balaŋ baale ta lee de man kɔŋ ɛ gyaŋ, kaa mo nɔɔwoya ŋaale bɛɛ ŋere ŋon te bɛɛ do ŋon kaale, keŋ nyi na daa faa na wɔ gbɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mena dɔɔ de gyaŋeewɔ kolosi see nyi, dɛɛ lese balaŋ baale kpu na de gyoona kpaakpaa Banabase na Pɔɔl, na dee kpila wɔ ɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Be yɛɛ balaŋ baŋ lee de Gbeŋgyoo Yesu Kristo yele man dɔɔ, te ba moo ba wose fa yeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Keŋ dɔɔ te dee kpila Gyudase na Silase mɔ, na baa mo be nɔɔ yako ŋon nombia ŋan dɔɔ ŋmarase do tɔne keŋ man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Daa na Wurubuarɛ feliŋ ŋon te sɛɛ nyi dɔɔ gyae dɛɛ mo nombia ŋaale ŋere ŋon ya. Mɔna ŋan dɛɛ gyae ɛ ke yɛɛ yɛna nyi, ");
INSERT INTO ntr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ɛ na di bane dɛɛ weenɛɛ, yaa wonembu fatabo yaa wonembu ŋon ba te kara ɔ nyee te ɔ ba yem nɛ ya. Nɛnɛɛ mɔ ɛ lese ɛ wose lee kafoŋ nombia man. Akpaa ɛ lese ɛ wose lee kɛŋa pou man na, kpene kamasɛ gyae ke de fa ŋon. De nɔɔwoya ɔto yaa. Ɛ kyaa nideli.” ");
INSERT INTO ntr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Be lɔɔ balaŋ baŋ bɔɔ kpili nɛ gbɛɛ, te be laŋa Antiɔke. Be ke gyu ka gyoo botɔɔ nɛ, be yilaa Kristotena dikpii keŋ pou te ba moo tɔne keŋ fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Balaŋ baŋ ke kala tɔne keŋ nɛ, yɛɛ wɔ gyoŋ lee mena keŋ bɔɔ do wɔ kakyeŋ nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Gyudase na Silase baŋ mɔ be yɛɛ Wurubuarɛ akpeŋkpeŋgyɔɔrawɔ nɛ kolosiwɔ nideli do wɔ kakyeŋ na doŋ. ");
INSERT INTO ntr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Be ke di weeya akalansɛɛ ŋaale nɛ, Kristotena baŋ be kyaa botɔɔ nɛ lɔɔ wɔ gbɛɛ wosefɛɛreŋ man te ba besewɔ laŋ balaŋ baŋ bɔɔ kpila wɔ nɛ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mɔna Silase yɛɛ wa agyueŋ nyi waa dɔɔ botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔɔl na Banabase kyaawɔ Antiɔke kyare kyomii, te baŋ na balaŋ burum baale kolosi de Gbeŋgyoo Wurubuarɛ nombia ŋan fa balaŋ te ba wola wɔ mɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Debaŋ daale wɔle nɛ, Pɔɔl yako Banabase nyi, “Yela dɛɛ bese gyu donɔɔ kamasɛ keŋ man dɔɔ gyu kekolosi de Gbeŋgyoo Yesu nombia ŋan nɛ, na de kaa kɛɛ balaŋ baŋ bɔɔ lɛɛ Kristo nombia ŋan di nɛ kekyaabii man.” ");
INSERT INTO ntr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nafɔ Banabase gyaewɔ nyi waa mo Gyɔn Maake kpu na ba wose. ");
INSERT INTO ntr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mɔna Pɔɔl kɛɛ ke nyi tekaboena nyi waa sila wɔ ya. Nawolo nyi ba ke kyaa Pamfilia nɛ, ɔ te yɛɛ tom na wɔ kelii ɔto ya, mɔna ɔ tinaa wɔ yela botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mena dɔɔ kewɔŋee dinaa daale gyoo ba nsana te be tira dɔŋa. Banabase moo Maake te ba moowɔ loŋ dɔɔ laŋ Saiporɔse. ");
INSERT INTO ntr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Te Pɔɔl mɔ moo Silase, te Kristotena baŋ fanewɔ nyi de Gbeŋgyoo Wurubuarɛ waa mo ɔ bɛrɛɛ boele wɔ te be lɔɔ wɔ gbɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pɔɔl tɛɛwɔ Siria na Silisia tɛɛlese man do Kristotena baŋ kakyeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔl gyuu Dɛbi donɔɔ man, te ɔ gyuu Listra donɔɔ man mɔ. Botɔɔ te ɔ ke naa Kristo baale ŋolo ŋon bɛɛ baake e nyi Timoti nɛ. Ɔ naa yɛɛ Gyuda alo ŋon ɔ be lɛɛ Yesu di, mɔna ɔ kya yɛɛ Giriki baale e. ");
INSERT INTO ntr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kristotena baŋ pou be kyaa Listra na Ikonium donɔɔse man nɛ dii adansɛɛ kpaakpaate lee ɔ wose man. ");
INSERT INTO ntr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Na Pɔɔl ne gyae waa mo Timoti sila ɔ wose dɔɔ, ɔ yela be kara ɔ baala wose, nawolo nyi Gyudatena baŋ pou be kyaa botɔɔ nɛ gyeŋ nyi Timoti ɔ kya yɛɛ Giriki baale e. ");
INSERT INTO ntr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ba ke ta bɛɛ lam donɔɔse ŋan man nɛ, be yako wɔ nombia ŋan Kristo kpilala na kegyiise baŋ be kyaa Gyerusalɛm be yako see nyi baa di ŋe dɔɔ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mena dɔɔ Kristotena baŋ seŋawɔ keŋkeŋ ba kelɛɛdi keŋ man nideli, na wee kamasɛ na balaŋ ne kaa kpuu na wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔɔl na ɔ tebia tɛɛwɔ ka mo na Firigia na Galatia tɛɛlese ŋan man, nawolo nyi Wurubuarɛ feliŋ ŋon te fa wɔ gbɛɛ nyi baa gyu kekolosi nombia ŋan Esia tɛɛle man ya. ");
INSERT INTO ntr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Be ke gyu kelii Misia tɛɛle wulu man nɛ, be yɛɛ kakyeŋ nyi baa gbaa gyoo Bitinia tɛɛle man, mɔna Yesu feliŋ ŋon te fa wɔ gbɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mena dɔɔ be gbaa Misia tɛɛle man tisi laŋ Torase donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ke nelim na, te Pɔɔl naa kolo na ɔ sia ŋgba dosɛɛ man nɛ nyi, ɔ te naa balee ŋolo ta lee Masedonia tɛɛle man kɔŋ ɔ na sola e nyi, “Gbaa kɔŋ de gyaŋ Masedonia na n kaa kyɔ daa.” ");
INSERT INTO ntr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔl kena ke pɛ, te da korowɔ desina da wose bileŋ na dee gyu Masedonia nawolo nyi, de lɛɛwɔ di nyi Wurubuarɛ baake na daa nyi dee gyu ke yako Kristo nombia kpaakpaa ŋan fa balaŋ botɔɔ mɔ. ");
INSERT INTO ntr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Da moo degbele dinaa lee Torase teeŋ gyu Samoterase. Tɛɛ naawɔ na te de gyuu Neyapolise donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De ka lee botɔɔ na, te de gyuuwɔ Filipi donɔɔ man. Filipi donɔɔ kenaŋ yɛɛ Masedonia tɛɛle yenaŋ daale donɔɔ dinaa ke. Na Romantena kyaa donɔɔ kenaŋ man burum, te de kyaawɔ botɔɔ weeya akalansɛɛ ŋaale. ");
INSERT INTO ntr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Gyudatena kefɛɛfowee kelii nɛ, te da leewɔ donɔɔ keŋ man gyu boo daale nɔɔman. Na da gyeŋ nyi dɛɛ naa Gyudatena dɛɛgyaŋee fane botɔɔ. De lii botɔɔ na te de tisiwɔ kyaa. Na ala baale te yilaa botɔɔ, te de fiasɛɛ dee kolosi Wurubuarɛ nombia fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ala baŋ bɔɔ tei de nombia nɛ, man ŋolo yele yɛna Lidia. Ɔ lee Tiatira donɔɔ keŋ man te ɔ ne yɔɔ agoo kanyaŋse ŋaale, na ɔ yɛɛ walaŋ ŋon mɔ ɔ na som Wurubuarɛ nideli. Mena dɔɔ de Gbeŋgyoo toro wa agyueŋ, te ɔ lɛɛ nombia ŋan Pɔɔl ne yako nɛ do nideli. ");
INSERT INTO ntr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mena dɔɔ be sɔɔ ŋon na ɔ dekpaŋalaŋmantena pou Wurubuarɛ loŋ. Te ɔ yako wɔ nyi, “Akpaa ɛ te lɛɛ maŋ do nyi ampaŋ ma te lɛɛ de Gbeŋgyoo Yesu di na, kenaŋ na mɛɛ sola ŋon nyi ɛ kɔŋ kaa kyaa me dɛɛ.” Te ɔ waase daa nideli mo daa gyu ɔ dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wee daale nɛ da korowɔ dee gyu botɔɔ keŋ bɛɛ fane nɛ, te de gyaŋee na alebubii ŋolo na ɔ yɛɛ balaŋ baale alebu e. Feliŋkum daale doo ɔ man, keŋ ne yeli ɔ ne tale gbala. Lee ɔ kegbala dɔɔ ɔ gbeŋgyoona baŋ nyiŋa kɔba nideli. ");
INSERT INTO ntr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Botɔɔ te alebu kei sila daa na Pɔɔl na ɔ ne fae yeesa nyi, “Balaŋ kɛwɔ yɛna Wurubuarɛ adidote ŋon tewulɛɛ. Mena keŋ ɛ ke yɛɛ na Wurubuarɛ ke lɛɛ ɛ nyee nɛ yaa bɛɛ wola ŋon nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ɔ yɛɛwɔ mena weeya burum te yɛɛ Pɔɔl ahiŋ te ɔ gɛɛsewɔ kɛɛ e, te ɔ faree e yako nyiaa, “Lee Yesu Kristo yele man, mɛɛ yako nyaŋ feliŋkum keŋ doo ɔ man nyi, lee ɔ man!” Debokenaŋ man te feliŋkum keŋ leewɔ ɔ man laŋ. ");
INSERT INTO ntr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Debaŋ keŋ alebu ŋon gbeŋgyoona be naa nyi be kɔba kenyiŋ gbɛɛ te tɔɔ nɛ, te ba ke kyaŋa Pɔɔl na Silase te be wɔŋee wɔ gyu kegyiise dɛɛgyaŋee man balaŋ nsana. ");
INSERT INTO ntr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba moo wɔ gyu Roman kegyiise gyaŋ te ba ke yako wɔ nyi, “Balaŋ kɛwɔ yɛɛ Gyudatenawɔ, te ba te kɔŋ bɛɛ wɔlɛɛ donɔɔ keŋ. ");
INSERT INTO ntr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bɛɛ wola abɔɔ ŋan na seŋ tia da mmaraase. Daa yɛɛ Romantenawɔ, dɔɔ gyae dɛɛ tale di ŋe dɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mena dɔɔ balaŋ dikpii keŋ pou kaa kyɔɔ wɔ te ba seŋawɔ tia wɔ. Kegyiise baŋ yela ba kpee Pɔɔl na Silase kegbase te be yela dambiise yee wɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Be ke tuku wɔ nideli taŋ nɛ ba moo wɔ do deni man, te be faree deni keŋ dɔɔ kɛɛre ŋon nyi waa tɔ deni keŋ nideli na bɔɔ nyiŋ lee ya. ");
INSERT INTO ntr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Deni keŋ dɔɔ kɛɛre ŋon kenyii nombia kɛŋa dɔɔ, ɔ moo wɔ do deni tɔɔmante keŋ man te ɔ gyɔɔ wɔ ɔpaŋ be nawɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kelii tɛɛ nsana nɛ, Pɔɔl na Silase korowɔ bɛɛ fane na bee kpee nɔɔneŋ lese Wurubuarɛ yele. Na balaŋ akaŋ baŋ mɔ be doo deni man nɛ ne tei wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Debokenaŋ man te tɛɛle wosiwɔ keŋkeŋ, te deni keŋ mokɔɔ wosiwɔ. Denɛɛ ŋan anaanɔɔse pou torowɔ, te be nawɔɔ leewɔ ɔpaŋ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Deni keŋ dɔɔ kɛɛre ŋon kefoŋ nɛ, ɔ naawɔ nyi denɛɛ ŋan ta toro te ɔ wɔŋa ɔ sila lese nyi waa ko ɔ wose. Nawolo nyi ŋon gyeŋ nyi balaŋ baŋ pou be doo deni keŋ man nɛ ta lee yeu. ");
INSERT INTO ntr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Keŋte Pɔɔl fae yeesa keŋkeŋ yako e nyi, “Na gooli n wose ya, de popou kyaa kɛbo!” ");
INSERT INTO ntr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mena dɔɔ deni keŋ dɔɔ kɛɛre ŋon yela ba moo kanea kɔna e, te ɔ yeuwɔ gyoo deni keŋ man te ɔ ke ŋmiŋawɔ Pɔɔl na Silase nawɔɔ tɛɛ. Na ɔ ne seree kpakpakpakpa. ");
INSERT INTO ntr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Te ɔ moo wɔ lee te ɔ bɔɔse wɔ nyi, “Ɛ waase da, woŋ te maa yɛɛ na Wurubuarɛ ke lɛɛ ma nyee?” ");
INSERT INTO ntr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Botɔɔ te be tiranɔɔ yako e nyi, “Lɛɛ de Gbeŋgyoo Yesu di, na Wurubuarɛ ke lɛɛ ɛmɛɛ na n dekpaŋalaŋmantena pou nyee.” ");
INSERT INTO ntr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Te be kolosi de Gbeŋgyoo Wurubuarɛ nombia ŋan fa deni keŋ dɔɔ kɛɛre ŋon na ɔ dekpaŋalaŋmantena pou. ");
INSERT INTO ntr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Botɔɔ te deni keŋ dɔɔ kɛɛre ŋon moo Pɔɔl na Silase gyu ka nyekee be gyamɛɛ, te baŋ mɔ sɔɔ ŋon na ɔ dekpaŋalaŋmantena pou Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ɔ moo wɔ gyu ɔ dɛɛ ke fa wɔ weenɛɛ. Yɛɛ ŋon na ɔ dekpaŋalaŋmantena pou gyoŋ, nawolo nyi ba te kaa lɛɛ de Gbeŋgyoo Wurubuarɛ di. ");
INSERT INTO ntr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tɛɛ kena te Romantena kegyiise baŋ kpila kotɔtɔɔtena kegyiise nyi, baa gyu keyako deni keŋ dɔɔ kɛɛre ŋon nyi, “Waa lese Pɔɔl na Silase na baa ta.” ");
INSERT INTO ntr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mena dɔɔ deni keŋ dɔɔ kɛɛre ŋon yako Pɔɔl nyi, “Kegyiise baŋ te kpila balaŋ kɔŋ nyi maa tina ŋon yela na ɛ ke ta, mena dɔɔ ɛ ke tale ta wosefɛɛreŋ man.” ");
INSERT INTO ntr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mɔna Pɔɔl yako kotɔtɔɔtena kegyiise baŋ nyi, “Be te di de nombia ya te be tuku daa balaŋ nsana te be kyaŋa daa ke tɔ deni, keŋ de yɛɛ Romantena gbagbawɔ. Te nɛnɛɛ bɛɛ gyae baa yo tina daa yela nyi dɛɛ ta. Koa, dɔɔ gyu ya, kegyiise baŋ gbagba baa kɔŋ na be kaa lese daa.” ");
INSERT INTO ntr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mena dɔɔ kotɔtɔɔtena kegyiise baŋ besewɔ gyu ke yako nombia kɛŋa fa Romantena kegyiise baŋ. Te be kenyii nyi Pɔɔl na Silase yɛɛ Romantenawɔ nɛ, gyakoloŋ gyoo wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mena dɔɔ be kɔŋawɔ be gyaŋ kaa doo wɔ teree, te ba lese wɔ lee deni keŋ man, te be waase wɔ nyi baa lee be donɔɔ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔɔl na Silase ka lee deni keŋ man nɛ, be gyuu alo ŋon bɛɛ baake e nyi Lidia nɛ dɛɛ. Te ba ke naa Kristotena baŋ botɔɔ te be kolosiwɔ fa wɔ do wɔ kakyeŋ te be laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔɔl na Silase moowɔ Anfipolise na Apolonia donɔɔse man te be gyuu Tesalonika donɔɔ man, na Gyudatena ɔsom deni kyaa botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔɔl gyuu Gyudatena ɔsom deni keŋ man, ŋgba mena keŋ ɔ ne taŋ yɛɛ nɛ. Pɔɔl na balaŋ benaŋ moo Gyudatena kefɛɛfoweeya atooro sɔɔŋ gyoo Wurubuarɛ nombia aŋmaraseŋ see ŋan man. ");
INSERT INTO ntr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Na ɔ na lese nombia ŋan man wola wɔ nyi, “Kaboena nyi Kristo ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ waa naa diyem na waa foŋ lee yeŋ man. Te ɔ besewɔ yako nyi, Yesu ŋon nombia mɛɛ yako ŋon nɛ, ŋon yɛna Kristo nyeelɛɛre ŋon.” ");
INSERT INTO ntr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Te Gyudatena baale agyueŋ kyɛɛkeewɔ te be lɛɛ Yesu di, te be sila Pɔɔl na Silase. Girikitena baŋ bee yee Wurubuarɛ na ala burum baale, baŋ ba wose man dana obuo nɛ mɔ lɛɛ nombia ŋan do. ");
INSERT INTO ntr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mɔna Gyudatena baŋ ba te lɛɛ Yesu di ya nɛ, man baale sia yɛɛwɔ Pɔɔl na Silase dɔɔ, te ba korowɔ yilaa donɔɔ keŋ man aboŋtena, te be wosi donɔɔ keŋ ampaŋ ampaŋ. Mena dɔɔ be gyuu balee ŋon bɛɛ baake e nyi Gyasɔn nɛ dɛɛ bɛɛ kɛo Pɔɔl na Silase baa lese wɔ fa balaŋ dikpii keŋ. ");
INSERT INTO ntr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Keŋ ba te naa wɔ dɔɔ ya nɛ, be wɔŋee Gyasɔn na Kristotena baale gyu donɔɔ keŋ kegyiise gyaŋ na yeesa nyi, “Balaŋ kɛwɔ yɛɛ tɛɛleyɛlɛɛlawɔ. Ba de laŋae kamasɛ na bee loo nombia do, te nɛnɛɛ ba te kaa lii de gyaŋ kɛbo, ");
INSERT INTO ntr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","te Gyasɔn dɔɔ ŋon lɛɛ wɔ see ɔ dɛɛ. Bɛɛ wɔlɛɛ gyoo dinaa Kaesa mmaraase ŋan, te bɛɛ yako nyi gyoo ŋolo kyaa bela ŋon bɛɛ baake e nyi Yesu.” ");
INSERT INTO ntr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Donɔɔ keŋ mantena na kegyiise baŋ kenyii nombia kɛŋa nɛ, ba nyonowɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mena dɔɔ be yela Gyasɔn na balaŋ akaŋ baŋ tɔɔ kɔba daale mo seŋ be wɔle nyi, bɔɔ tekaa yɛɛ mena bela ya te be tina wɔ yela. ");
INSERT INTO ntr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tɛɛ ke yu pɛ te Kristotena baŋ moo Pɔɔl na Silase lee donɔɔ keŋ man, te be gyuu Beria donɔɔ man. Be ke gyu ka gyoo botɔɔ nɛ, be gyuuwɔ Gyudatena ɔsom deni keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Balaŋ baŋ be kyaa Beria nɛ, gyeŋ nombia kela Tesalonikatena, nawolo nyi ba moo be konɔɔse pou lɛɛ Wurubuarɛ nombia ŋan. Te bɛɛ gyoo Wurubuarɛ nombia aŋmaraseŋ see ŋan man wee kamasɛ, na bɛɛ kɛɛ nyi nombia ŋan Pɔɔl na wola wɔ nɛ yɛɛ ampaŋ? ");
INSERT INTO ntr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mena dɔɔ Gyudatena balaŋ burum lɛɛ Kristo nombia ŋan di. Te Girikitena ala baŋ ba wose man dana obuo na Girikitena baala burum mɔ lɛɛ Kristo nombia ŋan di. ");
INSERT INTO ntr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Gyudatena baŋ be kyaa Tesalonika kenyii nyi Pɔɔl ne yako Wurubuarɛ nombia ŋan Beria mɔ nɛ, be kɔŋawɔ kaa wosi botɔɔ wɔlɛɛ Pɔɔl na ɔ tebia fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Debokenaŋ man te Kristotena baŋ lɔɔ Pɔɔl gbɛɛ te ɔ laŋa ɛpo nɔɔman. Mɔna Silase na Timoti dɔɔ baŋ dɔɔwɔ Beria botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Balaŋ baŋ bɔɔ moo Pɔɔl ka tee nɛ, moo e kelii na Atɛnse donɔɔ man. Be ka bese bɛɛ kɔŋ Beria nɛ, Pɔɔl doo wɔ tiila nyi baa yako Silase na Timoti nyi be kaa tuŋ e bileŋ. ");
INSERT INTO ntr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔɔl kɛɛ gyeki Silase na Timoti Atɛnse donɔɔ man nɛ, ɔ naawɔ nyi bɛɛneŋ te wulu donɔɔ keŋ man mena dɔɔ takaa e nideli. ");
INSERT INTO ntr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mena dɔɔ ɔ gyuu Gyudatena ɔsom deni keŋ man, na ŋon na Gyudatena na balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya te bee yee Wurubuarɛ nɛ, na gyoo Wurubuarɛ nombia ŋan man nideli. Mena te wee kamasɛ mɔ, ɔ ne kolosi fa balaŋ baŋ bɛɛ kɔŋ botɔɔ keŋ balaŋ ne gyaŋee nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Botɔɔ te wolala baale baŋ bɛɛ baake wɔ nyi Epikuritena na Setɔyikitena nɛ, na ŋon Pɔɔl wɔŋee nombia ŋaale. Pɔɔl kekolosi lee Yesu kabese foŋ lee yeŋ man nombia nɛ, balaŋ baale bɔɔsewɔ nyi “Na woŋ yaa nkpee kei ne yako baa? Te baale mɔ kpa, mberem ɔ ne kolosi bɛɛneŋ wɔlɛɛ baale nombia bo.” ");
INSERT INTO ntr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mena dɔɔ ba moo Pɔɔl gyu be dɛɛgyaŋee keŋ bɛɛ baake ke nyi Areopaguse nɛ, kegyiise siaman. Te be bɔɔse Pɔɔl nyi, “Nyaŋ ke tale lese n kawola wɔle kei man wola daa? ");
INSERT INTO ntr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nawolo nyi n nombia ŋan n na wolo nɛ, ta bese nombia wɔlɛɛ da deŋela man. Mena dɔɔ dɛɛ gyae nyi n ka lese ŋe man wola daa.” ");
INSERT INTO ntr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Balaŋ baŋ be kyaa Atɛnse donɔɔ keŋ man na ŋɔɔla baŋ be kyaa botɔɔ nɛ, bɛɛ yɛɛ kolo kpu na nombia wɔlɛɛ kenyii na ŋa keyako ya. ");
INSERT INTO ntr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Keŋte Pɔɔl korowɔ seŋ kegyiise baŋ be kyaa Areopaguse dɛɛgyaŋee keŋ siaman te ɔ yako wɔ nyiaa, “Atɛnsetena, ma te naa nyi gbɛɛ kamasɛ man na, ɛ dana yɔ ɔsom keŋ man nideli. ");
INSERT INTO ntr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nawolo nyi ma keta mee kila donɔɔ keŋ na, me naa abɔɔ ŋan ɛ na som nɛ, te me naawɔ nyi ɛ te ŋmarase gyakaa ɛ kedeesa boe daale dɔɔ nyi, ‘Wurubuarɛ ŋon dɔɔ gyeŋ e ya nɛ kedeesa boe.’ Mena Wurubuarɛ ŋon ɛ ba gyeŋ e ya te ɛ na som e nɛ, ɔ nombia yaa mɛɛ gyae maa yako ŋon nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wurubuarɛ ŋon ɔ be yɛɛ tɛɛle kei na kpene kamasɛ keŋ doo ke man nɛ, ŋon yɛna adido na ateta Gbeŋgyoo. Ɔ bɛɛ kyaa denɛɛ ŋan denibalaŋ be bam te bɛɛ som ŋe man nɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Te yɛɛ mɔ nyi kolo ne hia na e, te ɔ ne gyae nyi denibalaŋ baa yɛɛ fa e ya. Nawolo nyi ŋon ne faa na balaŋ pou nyeedoŋ na weesɛɛ na kpene kamasɛ. ");
INSERT INTO ntr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Walaŋ dokoloŋ dɔɔ, te ɔ tɛɛwɔ yela debiise balaŋ pou kɔŋawɔ tɛɛle kei dɔɔ. Ŋon see na debaŋ, na botɔɔ keŋ walaŋ kamasɛ waa kyaa tɛɛle kei dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wurubuarɛ yɛɛ kɛŋa pou see na balaŋ kenyiŋ kɛo e na baa naa e. Mɔna ɔ be dana lem lee de man ŋolo gyaŋ ya. ");
INSERT INTO ntr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ŋgba mena keŋ ŋolo be yako see nyi, ŋon dɔɔ te de dana nyeedoŋ te dɛɛ tale wosi da wose te de kyaa nɛ. Ɛmɛɛ gbagba ɛ nɔɔneŋ kpeere ŋolo yako nombii kei nyi, daa mɔ de yɛɛ ɔ biawɔ. ");
INSERT INTO ntr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mena dɔɔ keŋ de yɛɛ ɔ biawɔ dɔɔ, de na kɛɛ nyi Wurubuarɛ yɛɛ ŋgba kɔba yayam, yaa nyeele wolom, yaa boe keŋ balaŋ ba mo ba agyueŋ na ba adao mo ke yɛɛ bane see nɛ ya. ");
INSERT INTO ntr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gyaŋgba keŋ na Wurubuarɛ lese ɔ sia lee nombia ŋan balaŋ ba gyeŋ ya te bɛɛ yɛɛ nɛ dɔɔ. Mɔna nɛnɛɛ dɔɔ ɔ ne faree balaŋ pou yenaŋ kamasɛ nyi, baa kyɛɛkee lee be gbɛɛneŋ kumɛɛ man na baa kɔŋ ɔ gyaŋ. ");
INSERT INTO ntr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nawolo nyi ɔ ta lese wee daale see, keŋ waa ta walaŋ ŋon ɔ ba lese see nɛ dɔɔ, na waa di walaŋ kamasɛ nombia gbɛɛ kpaakpaate man. Mena keŋ balaŋ kenyiŋ gyeŋ nyi mena nombia kɛŋa yɛɛ ampaŋ dɔɔ, te ɔ gyuusu walaŋ ŋonaŋ lee yeŋ man.” ");
INSERT INTO ntr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Balaŋ baŋ kenyii mena keŋ Pɔɔl ne kolosi lee yeŋ wɔle kefoŋ wose man nombia nɛ, be man baale kulu e te baale mɔ yako e nyi, “Dɛɛ gyae n ka bese yako daa mena nombia kɛŋa bela.” ");
INSERT INTO ntr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mena dɔɔ Pɔɔl korowɔ lee balaŋ baŋ degyaŋee keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Balaŋ baŋ baale seŋawɔ Pɔɔl wɔle te be lɛɛ Yesu di. Be man baale yɛna Dinisuse ŋon ɔ yɛɛ botɔɔ keŋ bɛɛ gyaŋee nɛ kegyia ŋolo e, na alo ŋon bɛɛ baake e Damarise nɛ, na be man balaŋ burum baale. ");
INSERT INTO ntr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kei wɔle nɛ, Pɔɔl korowɔ lee Atɛnse donɔɔ keŋ man laŋ Korinto. ");
INSERT INTO ntr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Botɔɔ te ɔ ke naa Gyuda baale ŋolo ŋon bɛɛ baake e nyi Akuila nɛ. Ɔ yɛɛ Pɔntuse baale e, te ŋon na ɔ wɛɛle Pirisila ka lee Itali kɔŋ Korinto donɔɔ man te kyare ta ya. Nawolo nyi gyoo dinaa Klaudiuse ta see mmaraa nyi, Gyudatena pou baa lee Roman donɔɔ keŋ man. Pɔɔl gyuuwɔ Akuila na ɔ wɛɛle gyaŋ Korinto botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Te keŋ ŋon na wɔ pou tom yɛɛ dokoloŋ dɔɔ, ɔ kyaawɔ be gyaŋ te be yɛɛ tom bom. Ba tom keŋ bɛɛ yɛɛ yɛna nyi, kanyaŋse te bɛɛ mo yɛɛ denɛɛ yɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Gyudatena kefɛɛfowee kamasɛ nɛ, Pɔɔl ne gyu Gyudatena ɔsom deni man, na ŋon na wɔ ta gyoo Wurubuarɛ nombia ŋan man nideli, na Gyudatena na Girikitena kenyiŋ lɛɛ Wurubuarɛ nombia ŋan di. ");
INSERT INTO ntr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silase na Timoti ka lee Masedonia kɔŋ na, Pɔɔl te yɛɛ kolo kpu na Kristo nombia ŋan keyako ya. Ɔ na lese ŋe man wola Gyudatena baŋ nideli nyi Yesu yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mɔna be bɛɛ Pɔɔl nombia ŋan te ba tee e. Mena dɔɔ ŋon mɔ kpiisi ɔ kegba ayimɛɛ woli wɔ keŋ nawolo nyi ɔ ta lese ɔ nyiŋmaase lee be nombia man te ɔ yako wɔ nyi, “Akpaa ɛ yoo Wurubuarɛ gbɛɛman na, ɛmɛɛ gbagba ɛ nombia ŋenaŋ, te yɛɛ me nombia bela ya. Nawolo nyi keŋ kaboena nyi maa yɛɛ yaa me yɛɛwɔ nɛ. Lee gyɛŋ ne gyu dɔɔ, maa gyu kekolosi Wurubuarɛ nombia bo fa baŋ ba te yɛɛ Gyudatenawɔ ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mena dɔɔ ɔ leewɔ be gyaŋ gyu kekyaa Tituse Gyustuse ŋon ɔ te yɛɛ Gyuda baale e ya te ɔ na som Wurubuarɛ nɛ dekpaŋalaŋ man. Ɔ dekpaŋalaŋ kenaŋ benaa na Gyudatena ɔsom deni keŋ. ");
INSERT INTO ntr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bɔ ɔsom deni man kegyia ŋon bɛɛ baake e nyi Kirispuse nɛ na ɔ dekpaŋalaŋmantena pou lɛɛ de Gbeŋgyoo Wurubuarɛ nombia ŋan di. Korintotena burum mɔ nyii nombia ŋan te be lɛɛ ŋa di, te be sɔɔ wɔ Wurubuarɛ loŋ. ");
INSERT INTO ntr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Wee daale nelim nɛ, de Gbeŋgyoo Wurubuarɛ kolosiwɔ fa Pɔɔl ŋgba dosɛɛ man nɛ nyi, “Na yee ya, mɔna kolosi Wurubuarɛ nombia ŋan debaŋ kamasɛ. Na tina ŋa keyako yela ya. ");
INSERT INTO ntr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nawolo nyi me kpuɛ na neŋ. Ŋolo be gyae waa tale yɛɛ neŋ kolo ya, nawolo nyi balaŋ burum kyaa donɔɔ kei man keŋ be yɛɛ me wui.” ");
INSERT INTO ntr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mena dɔɔ Pɔɔl kyaawɔ botɔɔ kulutoo dokoloŋ na yaale na ɔ na wola wɔ Wurubuarɛ nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Debaŋ keŋ Galio ba seŋ Romantena gyoo dinaa nawɔɔ man dii gyoori Girikitena dɔɔ nɛ, te Gyudatena yɛɛ nɔɔ te be kyaŋa Pɔɔl mo e gyu nombia dedii man. ");
INSERT INTO ntr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Te be yakowɔ nyi “Balee kei na wola balaŋ Wurubuarɛ ɔsom wɔle daale keŋ ne tia da mmaraase.” ");
INSERT INTO ntr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔl ka mo waa kolosi pɛ, te Galio yako Gyudatena baŋ nyi, “Nyi akpaa deŋ yɛɛ nyi nombiikum daale yaa balee kei yɛɛwɔ na, nafɔ maa nyiŋ konɔɔ fa ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mɔna kei dɔɔ, ke yɛɛ nɔɔwoya na yela, na ɛmɛɛ gbagba ya mmaraase wose man te ɛ ne wɔŋee dɔɔ, ɛmɛɛ gbagba ɛ gyu kedi ɛ nombia. Nombia kɛŋa dinɔɔ dɔɔ, maŋ be gyae maa tale di ŋa ya.” ");
INSERT INTO ntr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Te ɔ yela be gegi wɔ lee nombia dedii man botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Keŋte balaŋ baŋ pou korowɔ kyaŋ Sositene ŋon ɔ yɛɛ ɔsom deni keŋ kegyia e nɛ, te be tuku e nombia dedii man botɔɔ, mɔna Galio te taŋ bua wɔ ya. ");
INSERT INTO ntr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔl kyaawɔ Kristotena baŋ be kyaa Korinto nɛ gyaŋ kelii debaŋ daale, te ɔ korowɔ lee botɔɔ mo loŋ dɔɔ gyu Siria tɛɛle man. Ɔ ne gyu na te ɔ moo Pirisila na Akuila kpu na ɔ wose. Ɔ ke gyu ka gyoo Kenkiria donɔɔ man nɛ, ɔ gbee ɔ nyee lee ntam keŋ ɔ be kam fa Wurubuarɛ nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Be ke gyu ka gyoo Efeso donɔɔ man nɛ, ɔ tinaa Pirisila na Akuila yela, te waageŋ gyuu Gyudatena ɔsom deni man, te ŋon na wɔ gyoo Wurubuarɛ nombia ŋan man. ");
INSERT INTO ntr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Keŋte balaŋ baŋ yako e nyi nafɔ waa kyaa be gyaŋ kyomii te ɔ bɛɛwɔ. ");
INSERT INTO ntr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ɔ kee gyu na te ɔ yako wɔ nyiaa, “Akpaa Wurubuarɛ de sɛɛ na, maa bese kɔŋ ɛ gyaŋ.” Te ɔ moowɔ loŋ dɔɔ lee Efeso donɔɔ man laŋ. ");
INSERT INTO ntr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ɔ kelii Kaesaria donɔɔ man nɛ, ɔ leewɔ botɔɔ gyu Gyerusalɛm donɔɔ man ka do Kristotena baŋ nɔɔ, te ɔ laŋa Antiɔke. ");
INSERT INTO ntr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɔ dii weeya akalansɛɛ botɔɔ, kenaŋ wɔle nɛ ɔ tɛɛwɔ Galatia na Firigia tɛɛlese man do Kristotena baŋ kakyeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Debaŋ kenaŋ man na, Gyuda baale ŋon bɛɛ baake e nyi Apolo, ŋon bɔɔ lola e Alɛkesanda donɔɔ man nɛ, te kɔŋ ɔ kyaa Efeso donɔɔ man. Ɔ yɛɛ walaŋ ŋon ɔ gyeŋ kekolosi nideli, te ɔ gyeŋ Wurubuarɛ nombia aŋmaraseŋ see ŋan mɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Na be taŋ wola e de Gbeŋgyoo Yesu nombia ŋan nideli. Ɔ moo ɔ konɔɔ pou yase sia kolosi te ɔ wola de Gbeŋgyoo Yesu wose man nombia ŋan man nideli, mɔna Gyɔn kesɔ balaŋ Wurubuarɛ loŋ keŋ kaageŋ wose man nombia te ɔ gyeŋ. ");
INSERT INTO ntr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ɔ gyoo Gyudatena ɔsom deni man te ɔ gyɔɔ ɔ konɔɔ kolosi Wurubuarɛ nombia ŋan. Pirisila na Akuila kenyii ɔ nombia ŋan ɔ na wolo nɛ, be kaa moo e gyu be dɛɛ te be desinawɔ lese Wurubuarɛ nombia ŋan man wola e nideli. ");
INSERT INTO ntr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Debaŋ keŋ Apolo be yɛɛ wa agyueŋ nyi ɔ ne gyu Akaya Girikitena tɛɛle man nɛ, Kristotena baŋ be kyaa Efeso nɛ doo e kakyeŋ, te be faa e be nyiŋmaa man tɔne nyi waa mo gyina Kristotena baŋ be kyaa botɔɔ nɛ, nyi baa lɛɛ e nideli. Ɔ ka gyoo botɔɔ nɛ, ɔ kyɔɔ baŋ lee Wurubuarɛ bɛrɛɛ keŋ dɔɔ, bɔɔ lɛɛ de Gbeŋgyoo Yesu di nɛ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Be gyaŋee balaŋ man bɛɛ lɛɛ aŋmaareŋ lee Wurubuarɛ nombia man na ɔ ne di Gyudatena baŋ dɔɔ, nawolo nyi ɔ na mo Wurubuarɛ nombia aŋmaraseŋ see ŋan wola wɔ nyi Yesu yɛna nyeelɛɛre ŋon Wurubuarɛ be yako see nyi waa kɔŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Debaŋ keŋ Apolo kyaa Korinto nɛ, Pɔɔl besewɔ kila menɛɛ kelii Efeso donɔɔ man. Botɔɔ te ɔ ke naa Yesu silala baale, ");
INSERT INTO ntr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","te ɔ bɔɔse wɔ nyi, “Debaŋ keŋ ɛ be lɛɛ Yesu di na, Wurubuarɛ moo ɔ feliŋ ŋon do ɛ man?” Te be tiranɔɔ fa e nyi, “De te nyii ta gba nyi Wurubuarɛ feliŋ daale kyaa ya.” ");
INSERT INTO ntr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Te Pɔɔl bɔɔse wɔ bela nyi, “Kenaŋ na Wurubuarɛ loŋ woŋti yaa be sɔɔ ŋon?” Te be tiranɔɔ fa e nyiaa, “Gyɔn Wurubuarɛ loŋkesɔ te be sɔɔ daa.” ");
INSERT INTO ntr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Botɔɔ te Pɔɔl yako wɔ nyi, “Baŋ bɔɔ kyɛɛkee lee be gbɛɛneŋ kumɛɛ man nɛ, baŋ te Gyɔn sɔɔ wɔ Wurubuarɛ loŋ. Keŋte ɔ yako Iseraetena nyi, baa lɛɛ ŋon waa kɔŋ ŋon Gyɔn wɔle nɛ di. Ŋon yɛna Yesu.” ");
INSERT INTO ntr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Be ke nyii nombia kɛŋa nɛ, be yela be sɔɔ wɔ Wurubuarɛ loŋ lee de gbeŋgyoo Yesu yele man. ");
INSERT INTO ntr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔɔl moo ɔ nyiŋmaa gyakaa be dɔɔ, te Wurubuarɛ moo ɔ feliŋ do be man. Botɔɔ te be kolosi deise wɔlɛɛ, te Wurubuarɛ tɛɛwɔ be dɔɔ kolosi nombia. ");
INSERT INTO ntr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Na be yɛɛ ŋgba baala kufu bala (12) nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Gyaalaŋna batooro sɔɔŋ na, Pɔɔl ne gyu Gyudatena ɔsom deni man, na ɔ ne gyɔ ɔ konɔɔ kolosi Wurubuarɛ nombia ŋan fa wɔ. Ŋon na wɔ na gyoo Wurubuarɛ nombia ŋan man, te ɔ ne wɔŋee ba agyueŋ kɔŋ Wurubuarɛ gyoori deedii keŋ wose man nombia man, na baa nyiŋ lɛɛ Yesu di. ");
INSERT INTO ntr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mɔna be man baale yɛɛ konɔɔyuŋ te be bɛɛwɔ bɔɔ lɛɛ Yesu nombia ŋan di ya, te be yako nombiakumɛɛ lee de Gbeŋgyoo Yesu nyeedoŋ gbɛɛ keŋ ɔ ba wolo nɛ wose man balaŋ nsana. Mena dɔɔ Pɔɔl moo silala baŋ kpu na ɔ wose, te ba korowɔ tina balaŋ baŋ yela. Wee kamasɛ na bɛɛ gyaŋee Tiranuse deni dinaa keŋ ɔ na wola abɔɔ nɛ man gyoo Wurubuarɛ nombia ŋan man. ");
INSERT INTO ntr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ɔ yɛɛ kei menɛɛ kulutooneŋ ala mena dɔɔ walaŋ kamasɛ ŋon ɔ kyaa Esia tɛɛle keŋ man nɛ, na baŋ ba te yɛɛ Gyudatenawɔ ya nɛ pou nyii de Gbeŋgyoo Yesu nombia ŋan. ");
INSERT INTO ntr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wurubuarɛ tɛɛwɔ Pɔɔl dɔɔ yɛɛ gyakoloŋ nombia na nombia dinaana. ");
INSERT INTO ntr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Keŋ nyi balaŋ moo adukuse na kanyaŋsebia ke tina Pɔɔl, na be ta mo ke tina be kaweesetena na ba wose te yɛɛ wɔ doŋ, te baŋ mɔ feliŋkumɛɛ doo be man na, ŋɛɛ lee be man. ");
INSERT INTO ntr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Na Gyudatena baale mɔ dɔŋɛɛ bee kili gegi feliŋkumɛɛ lee balaŋ wose man. Be gyɔɔ be konɔɔ mo de Gbeŋgyoo Yesu yele nyi baa gegi feliŋkumɛɛ. Bɛɛ gyae baa gegi feliŋkumɛɛ lee balaŋ wose man na bɛɛ yako nyi, “Lee Yesu ŋon Pɔɔl ne yako ɔ nombia nɛ yele man, mɛɛ faree ŋon nyi ‘Ɛ lee ɔ man.’ ” ");
INSERT INTO ntr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Na Gyudatena saese kegyia ŋolo ŋon bɛɛ baake e nyi Siifa nɛ bia baala nyetooro baale ne yɛɛ na mena nombia kɛŋa. ");
INSERT INTO ntr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Be kɛɛ yɛɛ mena nɛ, wee daale feliŋkum daale bɔɔse wɔ nyi, “Ma gyeŋ Yesu te ma gyeŋ Pɔɔl mɔ, te ɛmɛɛ yɛna bomɔ?” ");
INSERT INTO ntr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mena dɔɔ balee ŋon feliŋkum keŋ doo ɔ man nɛ yeuwɔ gyoo wɔ ketuku. Ɔ tuku wɔ tirii ba kegbase, te ba moo fatabose yekii lee dekpaŋalaŋ keŋ man diteŋteli. ");
INSERT INTO ntr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Te Gyudatena na baŋ ba te yɛɛ Gyudatenawɔ ya te be kyaa Efeso donɔɔ man nɛ, nyii nombia kɛŋa na, gyakoloŋ gyoo wɔ. Mena dɔɔ ba moo obuo fa de Gbeŋgyoo Yesu, te be ta mo ɔ yele do nsendee ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Te baŋ bɔɔ lɛɛ Yesu di nɛ, be man balaŋ burum leewɔ balaŋ nsana tɔlɛɛ be nɔɔwoya lese be nombiakumɛɛ ŋan bɔɔ yɛɛ nɛ debɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Be man ŋmeeseŋtena burum mɔ moo ba ŋmeeseŋ tɔna ŋan bɛɛ ŋmarase ba ŋmeeseŋ nombia do ŋe man nɛ kɔŋ, te Pɔɔl na ɔ tebia too ŋa balaŋ baŋ pou siaman. Ba mo tɔna ŋan bɔɔ too nɛ pou koya bom na, te yɛɛ kɔba nsendee ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lee mena dɔɔ de Gbeŋgyoo Yesu nombia ŋan yaaseewɔ gyu lem te balaŋ lɛɛ ŋa do nideli. ");
INSERT INTO ntr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nombia kɛŋa pou wɔle nɛ, Pɔɔl yɛɛ wa agyueŋ nyi waa mo na Masedonia na Giriki tɛɛlese man, na waa gyu Gyerusalɛm donɔɔ man. Botɔɔ te ɔ yakowɔ nyi, “Akpaa me gyu kelii botɔɔ na, kaboena nyi maa gyu Roman donɔɔ man mɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mena dɔɔ ɔ kpila balaŋ baŋ bɛɛ kyɔ e nɛ man balaŋ bala, baŋ yɛna Timoti na Erasituse nyi baa gyu Masedonia, na ŋon Pɔɔl kekyaa Esia tɛɛle man kyomii. ");
INSERT INTO ntr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Debaŋ kenaŋ man te aŋmaareŋ dinaa daale gyoo Efesotena man lee de Gbeŋgyoo Yesu nyeedoŋ gbɛɛ keŋ ɔ silala baŋ na wolo nɛ dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Na nyeele wolom luure ŋolo kyaa ŋon bɛɛ baake e nyi Demetiriyu. Ɔ na mo nyeele wolom luu be bane Atemise denɛɛbia yɔɔ. Mena dɔɔ balaŋ baŋ bɛɛ yɛɛ mena tom kei nɛ nyiŋa kɔba nideli. ");
INSERT INTO ntr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Keŋte Demetiriyu ŋon baake ɔ tomyɛɛra, na baŋ pou bɛɛ yɛɛ mena tom kenaŋ dinɔɔ nɛ te ɔ yako wɔ nyiaa, “Me tebia ŋgba ɛ gyeŋ nyi dee nyiŋ kɔba lee da tom kei man. ");
INSERT INTO ntr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ɛmɛɛ gbagba ɛ ne naa te ɛ ne nyii mena keŋ Pɔɔl kei ne wɔlɛɛ balaŋ nyeeya, te ɔ na wola balaŋ nyi kpene keŋ bɛɛ mo nyiŋmaase yɛɛ nɛ, te yɛɛ kpene keŋ kaboena nyi baa som ya. Na Efeso kɛbo kaageŋ te ɔ ne wɔlɛɛ balaŋ nyeeya ya, mɔna ɔ ta mo ɔ nombia ŋenaŋ kila Esia tɛɛle kei pou. ");
INSERT INTO ntr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Te yɛɛ nyi da tom kei kaageŋ ne gyae la ke wɔlɛɛ ya, mɔna de bane alo Atemise deni dinaa keŋ Esia na tɛɛle kei dɔɔ balaŋ pou ne kaa som nɛ, yele gyae ke yala te de bane Atemise ŋon mɔ be gyae waa tekaa nyiŋ obuo bela ya.” ");
INSERT INTO ntr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Balaŋ dikpii keŋ ke nyii nombia kɛŋa nɛ, ba gyeŋa baŋ te ba gyoo yeesa kefae nyi, “Daa Efesotena bane Atemise ŋon yɛɛ bane dinaa e!” ");
INSERT INTO ntr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mena dɔɔ donɔɔ keŋ siŋiiwɔ, te ba ke kyaŋa Gayose na Arisitakuse. Baŋ yɛna Masedonia tewulɛɛ bala baŋ be kpuɛ na Pɔɔl nɛ, keŋte be yɛɛ nɔɔdokoloŋ wɔŋee wɔ gyu be dɛɛgyaŋee keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nafɔ Pɔɔl gyaewɔ nyi waa gyu botɔɔ, mɔna kaseela baŋ te fa e gbɛɛ ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Te Esiatena kegyiise baŋ be yɛɛ Pɔɔl ɔ gyoonawɔ nɛ, kpilawɔ ka sola Pɔɔl nyi ɔ na fa waa gyu ba degyaŋee keŋ man ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Debaŋ kenaŋ na donɔɔ keŋ te siŋii na bɛɛ fae yeesa. Baale kpa kei, baale mɔ ne yako ŋaale kpoo. Be man dikpii dinaa daale mɔ dɔɔ, baŋ ba gyeŋ kpene keŋ be kɔŋ dɔɔ te bɔɔ kaa gyaŋee botɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Te Gyudatena baŋ moo nombia gyakaa Alɛkesanda dɔɔ. Be tɛɛse e lee siaman kɔŋ balaŋ nsana, mena dɔɔ balaŋ baŋ baale gyueŋwɔ nyi Alɛkesanda gyae na nombia ŋan kɔŋ, keŋte Alɛkesanda gyinaa ɔ nyiŋmaa adido nyi waa kolosi lese ɔ nɔɔse. ");
INSERT INTO ntr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mɔna balaŋ baŋ ka gyeŋ nyi ɔ yɛɛ Gyuda baale e nɛ, ba seŋawɔ nombii dokoloŋ dɔɔ bɛɛ fae yeesa ŋgba debaŋse ala nɛ nyi, “Daa Efesotena bane Atemise yɛɛ bane dinaa e!” ");
INSERT INTO ntr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Keŋte donɔɔ keŋ tɔne ŋmarasere ŋon yela balaŋ baŋ pou tinaa kekolosi yela te ɔ yako wɔ nyi, “Efesotena, amɔte kyaa la tɛɛle kei dɔɔ keŋ nyi ɔ ba gyeŋ nyi Efeso donɔɔ yɛna de bane dinaa Atemise deni na ɔ boe keŋ kɛɛ wola ɔ dinɔɔ keŋ ba lee adido kaa yala nɛ nyee ya? ");
INSERT INTO ntr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ŋolo be kyaa keŋ nyi waa tale lɛɛ mena nombia kɛŋa aŋmaareŋ ya. Mena dɔɔ ɛ nyiŋ konɔɔ, ɛ na barase yɛɛ kolo ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Balaŋ kɛwɔ baŋ ɛ ba mo wɔ kɔŋ nɛ, te ŋmɛɛle kolo lee de bane deni man ya. Te ba te yako nombiikum mɔ tia de bane kei ya. ");
INSERT INTO ntr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Akpaa Demetiriyu na ɔ tebia na ŋolo dana nombia na, nombia kedi weeya kyaa te kegyiise baŋ mɔ kyaa. Baa tale mo dɔŋa gyu botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mɔna nyi akpaa ɛ dana nombia wɔlɛɛ ŋaale na, kaboena nyi donɔɔsetena gbagba baa di ŋa ŋgba mena keŋ da mmaraa keŋ na wolo nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Akpaa da te kɛɛ nideli ya na, dee nyiŋ nombia lee gyɛŋ basabasa kei dɔɔ. Te akpaa de nyiŋ nombia mɔ na, dɔɔ gyae dɛɛ tale tiranɔɔ lese da wose lee ŋe man ya, nawolo nyi basabasa kei be taŋ nyee na nawɔɔ ya.” ");
INSERT INTO ntr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ɔ kekolosi taŋ nɛ, te ɔ yela balaŋ baŋ pou yaaseewɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Basabasa keŋ wɔle nɛ, Pɔɔl baake Kristotena baŋ pou yilaa te ɔ kolosiwɔ fa wɔ do wɔ kakyeŋ te ɔ kalaa wɔ, te ɔ lee botɔɔ laŋ Masedonia. ");
INSERT INTO ntr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ɔ tɛɛwɔ kila botɔɔ yenaŋ pou, na ɔ ne kolosi do balaŋ baŋ pou kakyeŋ te ɔ leewɔ botɔɔ kɔŋ Giriki tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ɔ kyaawɔ botɔɔ gyaalaŋna batooro. Ɔ kɛɛ desina ɔ wose waa gyu Siria tɛɛle man na te ɔ naawɔ nyi Gyudatena ne bake ɔ nyeeman. Mena dɔɔ ɔ yɛɛ wa agyueŋ nyi waa bese ka mo na Masedonia tɛɛle man. ");
INSERT INTO ntr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Balaŋ baŋ bɔɔ sila e gyu nɛ yɛna Piruse ŋon ɔ ba lee Beria nɛ bu Sopata, na Arisitakuse na Sekunduse baŋ bɔɔ lee Tesalonika nɛ, na Gayose ŋon ɔ ba lee Dɛbi nɛ, na Timoti na Tikikuse na Tirofimuse baŋ bɔɔ lee Esia tɛɛle man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mena balaŋ kɛwɔ kyaŋa gbɛɛ te ba ke kyaawɔ Torase donɔɔ man daa daa. ");
INSERT INTO ntr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Gyudatena bodobodo keŋ tee be doo ke man ya kedi wee dinaa keŋ wɔle nɛ, da moo degbele dinaa lee Filipi. Weeya anoŋ wɔle nɛ te de ka tuŋa baŋ bɔɔ kyaŋ gbɛɛ laŋ nɛ Torase donɔɔ man te de dii weeya nyetooro botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Gyudatena kefɛɛfowee keŋ wɔle nɛ de popou kaa gyaŋeewɔ dee di weenɛɛ ŋan de Gbeŋgyoo Yesu ba wola daa nyi dee di na dɛɛ mo tɔɔse e nɛ. Lee keŋ tɛɛ de naa na Pɔɔl waa bese dɔɔ, ɔ kolosi Wurubuarɛ nombia ŋan menɛɛ kelii tɛɛ nsana. ");
INSERT INTO ntr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Na kanease burum doo abansoro deni keŋ man dɔɔ gyaŋee nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pɔɔl kɛɛ kolosi keŋ nɛ, na tobaale ŋon bɛɛ baake e nyi Yutikuse baŋɛɛ abansoro deni kebaŋ gyakaa atoorote keŋ nfansere dɔɔ ɔ ne deŋeli. Lee Pɔɔl kekolosi kyare dɔɔ dosoroŋ moo tobaale ŋon, te tira e lee botɔɔ kaa lɔ tɛɛle man. Be gyuuwɔ ke gate e na ɔ ta yem. ");
INSERT INTO ntr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Keŋte Pɔɔl tisiwɔ gyu ke buŋ tobaale ŋon dɔɔ te ɔ pukaa e te ɔ gyuusu e lee yeŋ man. Keŋte ɔ yako wɔ nyi, “Ɛ na yeli ɛ wɔe ke lɔ ŋon ya, ɔ delena.” ");
INSERT INTO ntr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Keŋte Pɔɔl besewɔ gyu ba dekyae keŋ man adido botɔɔ te be ke dii weenɛɛ ŋan de Gbeŋgyoo Yesu kpa baa di na baa mo tɔɔse e nɛ. Ɔ besewɔ kolosi menɛɛ kelii tɛɛ kɛɛ yɛɛ maa na te ɔ laŋawɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Te balaŋ baŋ moo tobaale ŋon ɔ ba yem te Pɔɔl be gyuusu e nɛ, gyu ɔ dekpaŋalaŋ man te be popou wɔe fɛɛ wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Keŋte da gyoowɔ degbele dinaa keŋ man gyu Asose donɔɔ man, na de kaa mo Pɔɔl kpu na da wose. Nawolo nyi ɔ yako daa nyi waa kyaŋ gbɛɛ na ɔ naawɔ, na de kaa mo e botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ɔ ke kɔŋ kaa tuŋ daa Asose donɔɔ man keŋ nɛ, da moo e kpu na da wose gyu Mitilene donɔɔ keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tɛɛ kena keŋ nɛ te da moo degbele dinaa keŋ bela kelii Kiyose tɛɛlebii keŋ loŋ be kilisi ke nɛ yenaŋ. Weeya alate keŋ na te de gbaawɔ gyu Samose tɛɛlebii keŋ loŋ be kilisi ke nɛ man, te ka weeya atoorote na, te da gyoo Miletuse donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔɔl yɛɛ wa agyueŋ nyi, ɔ be gyae waa seŋ Efeso donɔɔ man ya, na ɔ be nyiŋ wɔlɛɛ debaŋ Esia tɛɛle man ya. Nawolo nyi ɔ ne gyae bileŋ nyi akpaa ɔ tale na, waa gyu Gyerusalɛm donɔɔ man ke tuŋ Gyudatena wee dinaa keŋ bɛɛ baake ke nyi Pentekosite nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ɔ ke kyaa Miletuse na, te ɔ kpilawɔ ka mo Efeso Kristotena ɔsom kegyiise baŋ. ");
INSERT INTO ntr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ba ke kɔŋ kaa gyoo nɛ, ɔ yako wɔ nyi “Ɛmɛɛ gbagba ɛ gyeŋ nyi, leenaŋ wee gyaŋgbate keŋ mɔɔ kɔŋ ɛ gyaŋ Esia tɛɛle man nɛ, daa na ŋon kyaawɔ nideli weeya ŋenaŋ pou man. ");
INSERT INTO ntr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ɛ gyeŋ mena keŋ mɔɔ yɔkɔse ma wose te mɔɔ mo siasaraŋ yɛɛ tom keŋ nideli ŋgba de Gbeŋgyoo Wurubuarɛ tobaale nɛ. Te ɛ naa mena keŋ Gyudatena ba koro seŋ me dɔɔ te bɔɔ do maŋ sibiiyam nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ɛ gyeŋ nyi debaŋ keŋ mee kolosi Wurubuarɛ nombia ŋan fa ŋon balaŋ nsana na ya akpaŋalaŋse man nɛ, me ta mo kolo weese ŋon ya. Ma lese abɔɔ ŋan gyae ke kyɔ ŋon nɛ pou wola ŋon. ");
INSERT INTO ntr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Gyudatena na Girikitena pou te me fareewɔ nyi, baa kyɛɛkee lee be nombiakumɛɛ man na baa kɔŋ Wurubuarɛ gyaŋ na baa lɛɛ de Gbeŋgyoo Yesu di. ");
INSERT INTO ntr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Te nɛnɛɛ, mɛɛ gyae maa yɛɛ kpene keŋ Wurubuarɛ feliŋ ŋon ne gyae dɔɔ mee gyu Gyerusalɛm, mɔna mɔɔ gyeŋ kpene keŋ gyae ke kɔŋ me dɔɔ botɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nombii dokoloŋ keŋ ma gyeŋ yɛna nyi, Wurubuarɛ feliŋ ŋon ne faree maŋ donɔɔ kamasɛ man nyi, baa naase maŋ diyem na baa kyaŋ maŋ tɔ deni. ");
INSERT INTO ntr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mɔna mɔɔ ne kɛɛ ma nyeedoŋ nyi ke yɛɛ kolo ke fa maŋ ya. Mɛɛ gyae maa yɛɛ tom keŋ de Gbeŋgyoo Yesu be fa maŋ nyi maa yɛɛ nɛ ke si kɔ ɔto. Tom kenaŋ yɛna nyi, maa yako ɔ nombia kpaakpaa ŋan fa balaŋ nyi Wurubuarɛ waa mo ɔ bɛrɛɛ boele wɔ.” ");
INSERT INTO ntr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nɛnɛɛ ma gyeŋ nyi ɛmɛɛ baŋ pou mɔɔ kili ɛ dɔɔ yako ŋon Wurubuarɛ gyoori keŋ wose man nombia ŋan nɛ, ɛ man ŋolo be gyae waa tekaa naa maŋ bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mena dɔɔ gyɛŋ wee kei mɛɛ yako ŋon baa nyi, akpaa ɛ man ŋolo da yoo lee Wurubuarɛ gbɛɛ man na, me nɔɔ be doo ya. ");
INSERT INTO ntr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nawolo nyi ma te yako ŋon Wurubuarɛ nyeeman nombia ŋan pou. ");
INSERT INTO ntr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɛ kɛɛ ɛ wose dɔɔ nideli, na ɛ ke kɛɛ balaŋ baŋ Wurubuarɛ feliŋ ŋon ba mo wɔ do ɛ nyiŋmaa man nɛ mɔ dɔɔ nideli. Ɛ kɛɛ Kristotena dikpii keŋ dɔɔ nideli ŋgba mena keŋ wonembu kɛɛlere ne kɛɛ ɔ wonembia dɔɔ nɛ. Baŋ yɛna baŋ Wurubuarɛ be yela ɔ bu ba yem lɛɛ ba nyeeya nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ma gyeŋ nyi ma ke laŋ wɔle na, balaŋ kumɛɛ baa kaa gyoo ɛ man ŋgba mena keŋ gbougbouse na gyoo wonembia man nɛ, te bɔɔ gyae baa tina ŋon yela ya. ");
INSERT INTO ntr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Te debaŋ daale gyae kelii nɛ, baale baa lee ɛmɛɛ gbagba ɛ dikpii keŋ man na baa beo ɛ tebia Kristotena baŋ baale sila ba wose. ");
INSERT INTO ntr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mena dɔɔ ɛ doo ɛ wose dɔɔ, na ɛ ke tɔɔse nyi kulutooneŋ atooro sɔɔŋ te me faree ŋon na siasaraŋ nelim na ka weese pou. ");
INSERT INTO ntr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Te nɛnɛɛ mɛɛ mo ŋon mɛɛ do Wurubuarɛ nyiŋmaa man. Nombia ŋan na wola Wurubuarɛ bɛrɛɛ keŋ ɔ dana fa deniwalaŋ nɛ, ne gyae la ke kyɔ ŋon na ɛ ke tale seŋ nombia ŋan ɛ be lɛɛ di nɛ man nideli. Wurubuarɛ waa mo ɔ nyiŋmaa gyakaa ɛmɛɛ na ɔ balaŋ akaŋ baŋ ɔ ba lese nɛ pou dɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Me sia te yɛɛ ŋolo kɔba yayam yaa ɔ kɔba, yaa wa abɔɔ dɔɔ ya. ");
INSERT INTO ntr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ɛmɛɛ gbagba ɛ gyeŋ nyi ma nyiŋmaase kɛŋa te ma moowɔ yɛɛ tom te me nyiŋa abɔɔ ŋan pou gyae ke hia daa na me tebia nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ma wola ŋon kpene kamasɛ man nyi, kaboena nyi walaŋ kamasɛ waa yɛɛ tom nideli mena, na waa nyiŋ kolo kyɔ baŋ bɔɔ dana doŋ ya nɛ. Na ɛ ke tɔɔse de Gbeŋgyoo Yesu kawola keŋ nyi, “Kolo kefa dana gyoŋ na wosefɛɛreŋ kela kolo kenyiŋ lee ŋolo gyaŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ɔ kekolosi kɛŋa taŋ nɛ, be popou tisiwɔ buŋ ba doona dɔɔ te be fanewɔ. ");
INSERT INTO ntr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Keŋte be man walaŋ kamasɛ moo kewii pukaa e te be kalaa e. ");
INSERT INTO ntr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Keŋ ɔ be yako wɔ nyi bɔɔ gyae baa tekaa naa e bela ya nɛ, keŋ yɛna kpene keŋ be takaa wɔ nideli. Ba moo e ka tee, te ɔ gyoo degbele dinaa keŋ man laŋ. ");
INSERT INTO ntr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Da ke kalaa dɔŋa taŋ keŋ nɛ, da moowɔ loŋ keŋ dɔɔ teeŋ te da toŋawɔ gyu Kosi donɔɔ man. Tɛɛ naawɔ na te de ka gyoo Rodesi donɔɔ man, te da leewɔ botɔɔ gyu Patara donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Botɔɔ te de naa degbele dinaa daale na kee gyu Fonisia tɛɛle man te da gyoo ke man laŋ. ");
INSERT INTO ntr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","De sia ke gyɔ Saiporɔse tɛɛlebii keŋ loŋ be kilisi ke nɛ, te de tinaa ke yela te de kpasewɔ mo ka ata yenaŋ gyu ka seŋ Tae boo nɔɔman Siria tɛɛle keŋ dɔɔ. Botɔɔ te ba lese kasolɔse ŋan doo degbele dinaa keŋ man nɛ see. ");
INSERT INTO ntr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Botɔɔ te de naa Kristotena baale te de kyaawɔ be gyaŋ weeya nyetooro. Te Wurubuarɛ feliŋ ŋon tɛɛwɔ be dɔɔ yako Pɔɔl nyi, ɔ na fa waa gyu Gyerusalɛm ya. ");
INSERT INTO ntr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mɔna debaŋ keŋ kelii nyi dɛɛ koro lee be gyaŋ nɛ, te da korowɔ mo de gbɛɛ bela. Keŋte baŋ na be wɛɛla na be bia pou gyuuwɔ ka tee daa donɔɔ keŋ nɔɔman. Te de popou buŋawɔ da doona dɔɔ ɛpo keŋ nɔɔman te de fanewɔ. ");
INSERT INTO ntr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","De kalaa dɔŋa te de ka gyoo degbele dinaa keŋ man te baŋ mɔɔ besewɔ laŋ be dɛɛ. ");
INSERT INTO ntr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Da besewɔ mo de gbɛɛ keŋ dɔɔ lee Tae menɛɛ kelii Pitolemase te da doo Kristotena baŋ be kya botɔɔ nɛ nɔɔ te de kyaawɔ be gyaŋ wee dokoloŋ. ");
INSERT INTO ntr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tɛɛ kena na te da korowɔ ka gyoo Kaesaria donɔɔ man, te de ka soo Filipo ŋon ɔ ne tɛɛ kolosi Kristo nombia nɛ. Ŋon Filipo mɔ kpuɛ balaŋ nyetooro baŋ bɔɔ kyaa lese Gyerusalɛm nyi baa kɛɛ weenɛɛ kekpɛlɛɛ dɔɔ nɛ man. ");
INSERT INTO ntr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Na ɔ dana bia alebia banaara baŋ ba te yala ta ya, na Wurubuarɛ ne tɛɛ be dɔɔ kolosi. ");
INSERT INTO ntr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","De ke di weeya akalansɛɛ ŋaale botɔɔ nɛ, te Wurubuarɛ dekpeŋkpeŋgyɔɔre ŋolo ŋon bɛɛ baake e nyi Agabuse nɛ, lee Gyudia tɛɛle man kɔŋ. ");
INSERT INTO ntr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ɔ kɔŋa de gyaŋ na, te ɔ moo Pɔɔl abɔsɔɔ mo baake ŋon gbagba ɔ nawɔɔ na ɔ nyiŋmaase te ɔ yakowɔ nyiaa, “Nnɛ yaa Wurubuarɛ feliŋ ŋon ne yako. Nnɛ te Gyudatena baŋ be kyaa Gyerusalɛm donɔɔ man nɛ, baa bake ŋon ɔ tee abɔsɔɔ kei nɛ, na baa lese e fa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ.” ");
INSERT INTO ntr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Debaŋ keŋ dɔɔ nyii mena nombia kɛŋa nɛ, te daa na balaŋ akaŋ baŋ be kyaa botɔɔ nɛ waase Pɔɔl nyi ɔ na gyu Gyerusalɛm ya. ");
INSERT INTO ntr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Keŋte Pɔɔl tiranɔɔ fa wɔ nyi, “Weera ɛ ne wii te ɛ ne yeli dekɔkɔrɔkɔɔ ne kyaŋ maŋ mena? Na me desina ma wose bo fa kebake kaageŋ Gyerusalɛm ya, mɔna ma te desina ma wose fa yeŋ mɔ lee de Gbeŋgyoo Yesu yele man.” ");
INSERT INTO ntr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Da te tale kyɛɛkee wa agyueŋ ya, mena dɔɔ de tina e yela te de yakowɔ nyi, “Wurubuarɛ gbagba waa yɛɛ ɔ kegyaebii.” ");
INSERT INTO ntr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Da ke kyaa botɔɔ kyomii nɛ, da moo da wose te de laŋa Gyerusalɛm. ");
INSERT INTO ntr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kristotena baŋ bɔɔ lee Kaesaria nɛ man baale sila daa, te ba moo daa gyu Masɔne ŋon ɔ ba lee Saiporɔse donɔɔ man nɛ dɛɛ. Masɔne kei yɛɛ walaŋ ŋon ɔ be wulaa lɛɛ Kristo di leenaŋ kewalaŋ keŋ. ");
INSERT INTO ntr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","De ka gyoo Gyerusalɛm donɔɔ man nɛ, Kristotena baŋ be kyaa botɔɔ nɛ lɛɛ daa nideli. ");
INSERT INTO ntr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ke tɛɛ naa keŋ nɛ, daa na Pɔɔl gyuuwɔ ka do Gyemisi nɔɔ. De ke gyu keŋ na ɔsom kegyiise baŋ pou kyaa botɔɔ. ");
INSERT INTO ntr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔl doo wɔ nɔɔ te ɔ yako wɔ kpene kamasɛ keŋ Wurubuarɛ be tɛɛ ɔ dɔɔ yɛɛ balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Be ke nyii nombia ŋan taŋ nɛ, be popou lese Wurubuarɛ yele. Te be yako e nyi, “Kegyia Pɔɔl, ŋgba n naa mena keŋ Gyudatena burum be lɛɛ Kristo nombia ŋan di, mɔna be sɛɛ be dana Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see nɛ man nideli. ");
INSERT INTO ntr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Be te nyii n nombia nyi, n na wola Gyudatena baŋ pou be kyaa balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ tɛɛle dɔɔ nyi, baa tina Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see nɛ dɔɔ kedi yela. Be na kara ba bia baala wose ya, te be na sila de naanaɔ beneŋ nombia ŋan bela ya. ");
INSERT INTO ntr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kei na sena yaa dɛɛ yɛɛ baa, de yɛɛ senaa baa nyii nyi n te kɔŋ kɛbo. ");
INSERT INTO ntr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mena dɔɔ yɛɛ kpene keŋ dɛɛ yako neŋ nɛ. Balaŋ banaara baale kyaa de gyaŋ kɛbo keŋ bɔɔ kaŋ ntam. ");
INSERT INTO ntr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gyu ke kpu na balaŋ banaara kɛwɔ na ɛ ka gberaa ɛ wose, na n ke tɔ kom keŋ baa gyoo nɛ, na baa nyiŋ tale tisi ba nyeeya. N yɛɛ mena na, walaŋ kamasɛ waa naa nyi nombia ŋan pou bɔɔ yako lee n wose man nɛ te yɛɛ ampaŋ ya. Mɔna baa naa nyi nyaŋ gbagba mɔ n ne di Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see nɛ dɔɔ nideli. ");
INSERT INTO ntr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya te bɔɔ lɛɛ Yesu di nɛ dɔɔ, da te ŋmarase tɔne yelee wɔ te de yako wɔ kpene keŋ dɔɔ bake see nɛ nyi be na di bane dɛɛ weenɛɛ ya. Be na di fatabo ya te be na di wonembu ŋon ba te kara ɔ nyee pɛte ɔ ba yem nɛ ya. Nɛnɛɛ baa lese ba wose lee kafoŋ nombia man.” ");
INSERT INTO ntr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Mena dɔɔ tɛɛ kena keŋ na, te Pɔɔl moo balaŋ banaara baŋ, te be gyuuwɔ kegberaa ba wose. Te ɔ gyuu Wurubuarɛ ɔsom deni dinaa keŋ man ka see wee keŋ ba wose kegberaa keŋ gyae ke taŋ, na wee keŋ be man walaŋ kamasɛ waa fa Wurubuarɛ kedi. ");
INSERT INTO ntr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Weeya nyetooro ŋan kɛɛ benaa keŋ nɛ, Gyudatena baale baŋ bɔɔ lee Esia tɛɛle man nɛ naa Pɔɔl Wurubuarɛ ɔsom deni dinaa keŋ man. Te be feefuwɔ do balaŋ dikpii keŋ bɔɔ gyaŋee botɔɔ nɛ te be kyaŋa e, ");
INSERT INTO ntr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","te be fae yeesa nyi, “Iseraetena ɛ kaa kyɔ daa, balee kei yɛna walaŋ ŋon ɔ dɔŋ yenaŋ kamasɛ ɔ na wola balaŋ pou nombia tia de balaŋ na Wurubuarɛ mmaraase ŋan ɔ be yeli Mosesi be ŋmarase see fa daa nɛ, na Wurubuarɛ ɔsom deni dinaa keŋ. Lee kenaŋ wɔle koraŋ na, ɔ ta mo balaŋ baŋ ba te yɛɛ Gyudatenawɔ ya nɛ kɔŋ Wurubuarɛ ɔsom deni dinaa keŋ man mo ayimɛɛ kaa buraa ke.” ");
INSERT INTO ntr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Keŋ dɔɔ bɔɔ yako mena yɛna nyi, na be wulaa naa Efeso baale ŋon bɛɛ baake e nyi Tirofimuse nɛ, na Pɔɔl dɔŋɛɛ donɔɔ keŋ man, mena dɔɔ na baŋ gyeŋ nyi Pɔɔl ta mo e gyu Wurubuarɛ ɔsom deni dinaa keŋ man. ");
INSERT INTO ntr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Botɔɔ te donɔɔ keŋ pou siŋiiwɔ te balaŋ yeuwɔ lee yenaŋ kamasɛ kɔŋ kaa kyaŋ Pɔɔl te be wɔŋee e lee Wurubuarɛ ɔsom deni dinaa keŋ man. Karatetee dokoloŋ te be kyaŋa ka asima ŋan pou tɔ. ");
INSERT INTO ntr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Be kɛɛ gyae baa ko e nɛ, te tiila ke tuŋa Romantena yoonɔɔtena siamante ŋon nyi, Gyerusalɛm donɔɔ keŋ pou te siŋii. ");
INSERT INTO ntr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Debokenaŋ man te ɔ moo yoonɔɔtena kegyiise na yoonɔɔtena baale, te be yeuwɔ gyu balaŋ dikpii keŋ gyaŋ. Balaŋ baŋ kena siamante ŋon na yoonɔɔtena baŋ nɛ, te be tinaa Pɔɔl ketuku yela. ");
INSERT INTO ntr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Be siamante ŋon gyuu Pɔɔl gyaŋ te ɔ ke kyaŋa e te ɔ yakowɔ nyi baa mo agbaraagbaraase ala bake e. Keŋte ɔ bɔɔse wɔ nyi, “Amɔte yɛna balee kei, te woŋ yaa ɔ yɛɛwɔ?” ");
INSERT INTO ntr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Balaŋ baŋ baale ne yako nombii dokoloŋ na baale mɔ ne yako ŋaale kpoo. Botɔɔ kee wosi dɔɔ, yoonɔɔtena siamante ŋon ta gyeŋ nombia ŋan nyee na ŋe nawɔɔ ya, mena dɔɔ ɔ yako ɔ tewulɛɛ baŋ nyi baa mo e gyu ba dekyae man. ");
INSERT INTO ntr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Be ka mo e kelii botɔɔ keŋ bɛɛ mo gyeŋ gyoo deni keŋ man nɛ, balaŋ baŋ sia keyɛɛ dɔɔ yoonɔɔtena baŋ gate Pɔɔl seele adido. ");
INSERT INTO ntr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Na balaŋ baŋ be silana wɔ nɛ, ne fae yeesa nyii, “Ɛ ko e.” ");
INSERT INTO ntr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Be kɛɛ gyae baa mo Pɔɔl gyoo yoonɔɔtena baŋ dekyae keŋ man nɛ, ɔ yako yoonɔɔtena siamante ŋon nyi, “Mɛɛ gyae maa yako neŋ nombii daale.” Te ɔ bɔɔse Pɔɔl nyi, “N ne nyii Giriki dei?” ");
INSERT INTO ntr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Na nyaŋ yɛna Igyipite baale ŋon n be kyaa koro seŋ tia kegyiise te n ba mo awudiina kakpoŋse banaara (4,000) sila n wose gyu kefula man nɛ yee?” ");
INSERT INTO ntr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Te Pɔɔl tiranɔɔ fa e nyi, “Koa, me yɛɛ Gyuda baale e te ba lola maŋ bo Silisia tɛɛle man. Ma lee Tasuse donɔɔ keŋ ke dana yele nɛ man. Waaseda, fa maŋ gbɛɛ na maa kolosi fa balaŋ baŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Te yoonɔɔtena siamante ŋon faa e gbɛɛ nyi waa kolosi. Mena dɔɔ Pɔɔl seŋawɔ botɔɔ keŋ bɛɛ mo gyeŋ gyoo deni keŋ man nɛ, te ɔ gyinaa ɔ nyiŋmaa adido nyi baa wu be nɔɔ na baa tei e. Balaŋ baŋ ke wu be nɔɔse nɛ, te Pɔɔl kolosiwɔ Hiburu dei man fa wɔ. ");
INSERT INTO ntr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Keŋte Pɔɔl kolosiwɔ lese ɔ nɔɔse nyiaa, “Me tebia na me kyaɔ, ɛ tei maŋ.” ");
INSERT INTO ntr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Be kenyii ɔ kekolosi na wɔ Hiburu dei man nɛ, be wuu be nɔɔse te botɔɔ yɛɛwɔ diiŋ. Te Pɔɔl yakowɔ nyi, ");
INSERT INTO ntr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Me yɛɛ Gyuda baale e te ba lola maŋ bo Tasuse Silisia tɛɛle dɔɔ mɔna be kɛɛle maŋ bo Gyerusalɛm donɔɔ man kɛbo, Na me yɛɛ Gamaleli tobaale e. Ɔ kɛɛle maŋ nideli de naanaɔ ɔsom amanberɛ gbɛɛ man te me yase me sia mo ma wose lɔ Wurubuarɛ dɔɔ ŋgba mena keŋ ɛ man walaŋ kamasɛ ne yɛɛ gyɛŋ nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Me naase baŋ be dɔŋ de Gbeŋgyoo Yesu nyeedoŋ gbɛɛ kei dɔɔ nɛ diyem nideli keŋ nyi be baale koraŋ yekeewɔ, te me kyaŋa be man ala na baala pou ketɔ deni. ");
INSERT INTO ntr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sae kegyia na nombiadiira kegyiise baa di adansɛɛ nyi kpene keŋ mɛɛ yako nɛ yɛɛ anokoare. Nawolo nyi me lɛɛ tɔna koraŋ lee be gyaŋ, ŋan bɔɔ ŋmarase fa be tebia Gyudatena baŋ be kyaa Damasekuse nɛ, te me gyuuwɔ me kaa kyaŋ Kristotena baŋ be kyaa botɔɔ nɛ, na maa do wɔ akyakaase kɔŋ Gyerusalɛm na baa wɔŋ ba deŋela. ");
INSERT INTO ntr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Keŋte Pɔɔl yakowɔ nyi, ma keta gyu ka benaa Damasekuse donɔɔ keŋ na weese ta seŋ dɛɛ. Karatetee dokoloŋ te keŋmaŋee dinaa daale lee adido kaa ŋmaale polɛ kilisi maŋ. ");
INSERT INTO ntr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kara maŋ lɔ tɛɛle man te me nyii nɔɔwoya ŋaale ne bɔɔse maŋ nyi, ‘Sɔɔl! Sɔɔl! Weera te n ne naase man diyem?’ ");
INSERT INTO ntr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Te me bɔɔse e nyi, ‘Nyaŋ amɔte ŋonaŋ me Gbeŋgyoo?’ Te ɔ tiranɔɔ nyi ‘Maŋ Yesu Nasarɛte baale ŋon n ne naase diyem nɛ.’ ");
INSERT INTO ntr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Balaŋ baŋ daa na wɔ dɔŋɛɛ nɛ naa keŋmaŋee keŋ, mɔna be te nyii nɔɔwoya ŋan be kolosi na maŋ nɛ man ya. ");
INSERT INTO ntr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Me bɔɔsewɔ nyi, ‘Woŋ te maa yɛɛ me Gbeŋgyoo?’ Te de Gbeŋgyoo yako maŋ nyi, ‘Koro gyu Damasekuse. Botɔɔ te baa yako neŋ kpene kamasɛ keŋ Wurubuarɛ ne gyae nyi n ke yɛɛ.’ ");
INSERT INTO ntr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Keŋmaŋee dinaa keŋ yela me sia yɛlɛɛwɔ, mena dɔɔ balaŋ baŋ daa na wɔ dɔŋ nɛ, kyaŋa na maŋ me nyiŋmaa man gyu ka gyoo Damasekuse donɔɔ man. ");
INSERT INTO ntr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Balee ŋolo ŋon bɛɛ baake e nyi Ananiase nɛ kɔŋawɔ kaa kɛɛ maŋ. Ɔ yɛɛ walaŋ ŋon ɔ ne yee Wurubuarɛ, te ɔ ne di Wurubuarɛ mmaraase ŋan dɔɔ nideli, te Gyudatena baŋ pou be kyaa Damasekuse nɛ ne bu e nideli. ");
INSERT INTO ntr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɔ kɔŋawɔ kaa seŋ me gyaŋ te ɔ yakowɔ nyi, ‘Me dɔɔ Sɔɔl, gyuusu n sia na n kena.’ Debokenaŋ man te me sia gyuusuwɔ te me naa e. ");
INSERT INTO ntr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Te Ananiase yako maŋ nyi, ‘De naanaɔ Wurubuarɛ lese na neŋ nyi nya gyeŋ kpene keŋ ɔ ne gyae nyi nya yɛɛ, na n kena ɔ walaŋ ŋon ɔ gbɛɛneŋ tenɛɛ Wurubuarɛ siaman nɛ, na n ke nyii ɔ nɔɔwoya. ");
INSERT INTO ntr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nawolo nyi nyaŋ ne gyae la n ke di ɔ wose man adansɛɛ fa balaŋ pou lee kpene keŋ n be naa, na kpene keŋ n be nyii lee ɔ wose man nɛ. ");
INSERT INTO ntr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nɛnɛɛ woŋ yaa n ne daa? Koro seŋ na n ke yela baa sɔ neŋ Wurubuarɛ loŋ na n ke fane de Gbeŋgyoo Yesu yele man, na Wurubuarɛ ke gberaa nya ayimɛɛ l