﻿USE sofia;
DROP TABLE IF EXISTS sofia.ntpNT_vpl;
CREATE TABLE ntpNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ntpNT_vpl WRITE;
INSERT INTO ntpNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Potʌʌtʌgiducatadai ʌʌqui aaduñdʌcarudʌ Suusi Cristo ismaacʌdʌ ʌrcajiudadʌ ʌraí Davicaru dai Davicaru ʌrcajiudadʌ Avraañicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Avraañicaru ʌroogadʌ Isaacaru, Isaacaru ʌroogadʌ Jacocaru, Jacocaru ʌroogadʌ Judacaru dai aa ismaacʌdʌ maamarai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judacaru ʌroogadʌ Paaresicaru daidʌ Saaracaru daidʌ ʌdʌʌdʌ Tamara tʌʌgiducatadai, Paaresicaru ʌroogadʌ Esinomicaru, Esinomicaru ʌroogadʌ Aramacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramacaru ʌroogadʌ Aminadabacaru, Aminadabacaru ʌroogadʌ Naasonacaru, Naasonacaru ʌroogadʌ Salmonacaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonacaru ʌroogadʌ Boosocaru daidʌ ʌdʌʌdʌ Raaba tʌʌgiducatadai, Boosocaru ʌroogadʌ Obedicaru daidʌ ʌdʌʌdʌ Ruuta tʌʌgiducatadai, Obedicaru ʌroogadʌ Isaícaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaícaru ʌroogadʌ ʌraí Davicaru, daidʌ ʌraí Davicaru ʌroogadʌ Salomoñicaru daidʌ ʌdʌʌdʌ ʌrUriiasicaru ooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Daidʌ Salomoñicaru ʌroogadʌ Roboamicaru, Roboamicaru ʌroogadʌ Aviiasicaru, Aviiasicaru ʌroogadʌ Asacaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asacaru ʌroogadʌ Josapaatacaru, Josapaatacaru ʌroogadʌ Joramacaru, Joramacaru ʌroogadʌ Usiasicaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiasicaru ʌroogadʌ Jotamacaru, Jotamacaru ʌroogadʌ Acasicaru, Acasicaru ʌroogadʌ Esequiiasicaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esequiiasicaru ʌroogadʌ Manaseesicaru, Manaseesicaru ʌroogadʌ Amoñicaru, Amoñicaru ʌroogadʌ Josiiasicaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiiasicaru ʌroogadʌ Jeconiiasicaru dai aa ismaacʌdʌ maamarai ʌgai. Ʌgai oidacatadai aidʌsi ʌraígadʌ Bavilooniana oidacami divia dʌvʌʌragadʌana ʌjudidíu dai maisapicami vuucai mui gʌdʌvʌʌragamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dai gooquiʌrʌ Jeconiiasicaru ʌroogadʌ Salatielicaru, Salatielicaru ʌroogadʌ Sorovaveelicaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorovaveelicaru ʌroogadʌ Aviudicaru, Aviudicaru ʌroogadʌ Eliaquiimicaru, Eliaquiimicaru ʌroogadʌ Asoracaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoracaru ʌroogadʌ Sodocaru, Sodocaru ʌroogadʌ Aquimicaru, Aquimicaru ʌroogadʌ Eliudacaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudacaru ʌroogadʌ Eleasaracaru, Eleasaracaru ʌroogadʌ Matanacaru, Matanacaru ʌroogadʌ Jacocaru, ");
INSERT INTO ntpNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacocaru ʌroogadʌ Osee ismaacʌdʌ ʌrcunadʌ María dai María ʌrdʌʌdʌ Suusi ismaacʌdʌ ʌrʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tami gʌaagai baivustaama dan maacova oodami ismaacʌdʌ oidacatadai aidʌsi oidacatadai Avraañicaru abiaadʌrʌ asta aidʌsi oidacatadai Davicaru uucami tomasi maivʌʌsi ʌʌpana oidacatadai dai ʌʌpʌ baivustaama dan maacova Davicaru abiaadʌrʌ asta aidʌsi ʌraí Bavilooniʌrʌ oidacami maisapicami vuucai ʌjudidíu Bavilooniamu ʌgai maivʌʌscatai ʌʌpana oidacatadai dai ʌʌpʌ baivustaama dan maacova aidʌ abiaadʌrʌ asta aidʌsi vuusai ʌCristo, ʌgai maivʌʌscatai ʌʌpana oidacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aduucai ʌpʌdui tai divia Suusi Cristo: María ʌrdʌʌdʌ dai casi ʌrgʌncuucunacamicatadai ʌgai ʌʌmadu ʌOsee dʌmos maiquia ʌmapai oidacatadai, taidʌ María nonoatu guvucadadʌcʌdʌ Diuusi Ibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ɅOsee ʌrʌmo cʌʌli cʌʌga tuigacami dai maitipʌliditadai ismatiagi ʌoodami isnonoacatadai ʌMaría, baiyoma ipʌliditadai ʌgai isʌstocai dagituagi sai maisoimaa taatatuldana ʌtʌtʌaanʌdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dai aidʌsi quiaa tʌtʌgitoitadai ʌOsee gomaasi, tai coosigadʌrʌ gʌmaasitu ʌmo Diuusi tʌaañicarudʌ daidʌ itʌtʌdai: ―Osee Davicaru cajiudadʌ, maitiduaadicuda vʌʌnañi ʌMaría vaidʌ ʌrgʌooñiacana, Diuusi Ibʌadʌ guvucadadʌcʌdʌ viaaca agai ʌgai ʌali oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ʌgai marata agai ʌmo ali gʌʌli pai Suusi tʌʌtʌ. ɅSuusi cʌʌgacʌrʌ vuvaida agai oodami soimaascamigadʌaiñdʌrʌ ismaacʌdʌ vaavoitudagi cascʌdʌ potʌʌgiduca agai ʌgai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aidʌsi ʌpʌdui gomaasi aidʌ ʌpʌdui ismaacʌdʌ aagai Diuusi gʌñiooquituldiadamigacʌdʌ saidʌ icaiti: ");
INSERT INTO ntpNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ʌmo ali tʌji nonoatumu dai maratamu ʌmo ali gʌʌli dai Emanuel aagadamu oodami. Ascaiti Diuusi. Emanuel itʌiya ʌlidi: Diuusi gʌrʌʌmadu daacana. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dai aidʌsi nʌnʌa ʌOsee poduucai idui isducatai aagidi ʌDiuusi tʌaañicarudʌ, vʌʌna ʌgai ʌMaría. ");
INSERT INTO ntpNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Dʌmos maiaabana voo ʌgai asta aidʌsi marai ʌMaría. Ʌgai ʌrtuucamidʌrʌ maradʌ tai Suusi tʌʌtʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ɅSuusi Beleenʌrʌ vuusai Judeea dʌvʌʌriʌrʌ, aidʌsidʌ ʌEroodʌsi ʌrraícatadai ami dʌvʌʌriʌrʌ. Tai ami Jerusaleenʌrʌ Judeea dʌvʌʌriʌrʌ dada chiʌʌqui cʌcʌʌli. Jerusaleenʌrʌ siooma muidu oidacami siaa ʌʌmapʌcʌrʌ Judeea dʌvʌʌriʌrʌ. Ʌcʌcʌʌli ismaacʌdʌ ami dada cʌʌ maatʌ nʌidi sisiaavugai. Siaalico padʌrʌ dada ʌcʌcʌʌli, ");
INSERT INTO ntpNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","dai gatʌcacaimi daidʌ icaitimi: ―Vaaco daja aapimʌ judidíu gʌnraíga ismaacʌdʌ vuusai, nʌidi aatʌmʌ siaavugaigadʌ cascʌdʌ dada aatʌmʌ dai siaa duutuda ragai ―ascaiti ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dai aidʌsidʌ ʌraí Eroodʌsi maí gomaasi aliʌ duaadimu ʌgai. Ʌgai poʌliditadai isoidaca agai ʌmai raí siʌgai camaitatʌaanʌda agaitadai. Dai vʌʌsi ʌoodami Jerusaleenʌrʌ oidacami aliʌ duduaadimu ʌʌpʌ. Ʌgai poʌliditadai isʌtʌtʌaanʌdami istutuiditadai isgʌncocodagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Taidʌ ʌEroodʌsi ʌmpagi vʌʌsi ʌpapaali baitʌguucacamigadʌ, ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ dai tʌcacai saaco vuusia agaitadai ʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Beleenʌrʌ tami Judeea dʌvʌʌriʌrʌ, dai Diuusi ñiooquituldiadamigadʌ ooja sai pocaiti Diuusi: ");
INSERT INTO ntpNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ismaacʌdʌ Beleenʌrʌ oidaca agai Judeea dʌvʌʌriʌrʌ aa judidíu vaamioma siaa duutuadamu siaa judidíu. Ʌgai saagida vuusia agai ʌmo gʌʌ tʌaanʌdami. Dai ʌgai tʌaanʌdamu ʌjudidíu. Ascaiti Diuusi ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Taidʌ ʌEroodʌsi ʌstocai vaí ʌcʌcʌʌli ismaacʌdʌ dada siaalico padʌrʌ, dai cʌʌga tʌcacai suu duucu gʌmaasitu ʌsiaavugai. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dai gooquiʌrʌ ootoi ʌEroodʌsi ʌcʌcʌʌli Beleenamu daidʌ itʌtʌdai: ―Iimivurai dai gaaga ʌali siʌʌñi dai mʌsiʌʌscadʌ tʌgiagi vʌrai dadacai giñaagida nai aanʌ ʌʌpʌ mʌʌ siaa duutudagi ―astʌtʌdai ʌEroodʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Potʌtʌdai ʌraí taidʌ ʌcʌcʌʌli iji. Daidʌ ʌsiaavugai ismaacʌdʌ tʌʌ ʌgai vaasʌquioma mosbaitʌqui imʌitadai. Taida cʌquiva ʌsiaavugai daama siaaco daacatadai ʌali siʌʌñi. Dai aidʌsi ʌcʌcʌʌli tʌʌ ʌsiaavugai aliʌ baigʌnʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dai vaapacʌcai ami quiiyʌrʌ tʌʌ ʌgai ʌali siʌʌñi ʌʌmadu ʌdʌʌdʌ. Dai gʌntootonacʌdʌ guuquiva dai siaa duutuli ʌgai ʌali siʌʌñi dai gooquiʌrʌ cuupioco ʌgai gʌncajojooñiga dai oi ooro, dai cubimadali dai mirra. Mirra ʌrʌmo istumaasi chigian uuvadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dai gooquiʌrʌ Diuusi aagidi ʌcʌcʌʌli coosigadʌrʌ sai camaiiimʌna siaaco daacatadai ʌEroodʌsi tai cascʌdʌ ʌmai voiyamu sʌʌli noonora ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dai aidʌsi canoonora ʌcʌcʌʌli, ʌmo Diuusi tʌaañicarudʌ gʌmaasitu coosigadʌrʌ ʌOsee daidʌ itʌtʌdai: ―Vañigiñi dai vaidacai goali siʌʌñi ʌʌmadu godʌʌdʌ voopoivurai Ejiipituamu dai momʌʌca avʌr daraaja asta siʌʌscadʌ gʌnaagida aanʌ. ɅEroodʌsi gaaga agai goali siʌʌñi dai muaa ʌlidi ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Taidʌ ʌOsee vañi dai tucarʌ vaidacai ʌali siʌʌñi ʌʌmadu ʌdʌʌdʌ Ejiipituamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dai anaasi daraaja ʌgai asta aidʌsi muu ʌEroodʌsi. Aidʌsi poduucai idui ʌgai poduucai ʌpʌdui ismaacʌdʌ aagai Diuusi ʌʌquioma gʌñiooquituldiadamigacʌdʌ dai pocaiti: “Aagidamu aanʌ giñmara sai vuusaiña Ejiipituaiñdʌrʌ”, ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dai aidʌsi maí ʌEroodʌsi isyaatagi ʌcʌcʌʌli aliʌ baamu, dai gatʌjai coodaragai vʌʌsi aali ismaacʌdʌ viaacatadai googo uumigi coidamacoga ismaacʌdʌ Beleenʌrʌ oidacatadai dai vʌʌsi sicoli Beleena oidacami. Ʌcʌcʌʌli sastuduacʌdʌ caaagidi ʌEroodʌsi siʌʌquidʌ tʌʌtadai ʌgai ʌsiaavugai dai poduucai ʌʌsitu ʌEroodʌsi siʌjudidíu raígadʌ ismaacʌdʌ gaagai ʌgai cayoga viaacatadai gooca uumigi. Dai cascʌdʌ gatʌjai coodaragai vʌʌsi aali ismaacʌdʌ viaacatadai googo uumigi coidamacoga. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Poduucai ʌpʌdui ismaacʌdʌ ooja gʌraduñicaru Jeremiiasi Diuusi ñiooquituldiadamigadʌ dai poduucai ooja: ");
INSERT INTO ntpNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Muidutai judidíu ooqui suaanʌda agai muiyapʌrʌ oidacami. Ʌooqui suaanʌda agai gʌcooditudacai maamaradʌ. Dai maitipʌliadamu ʌooqui isaa baiʌʌliatudagi. Cacoimu maamaradʌ cascʌdʌ. Ascaiti Jeremiiasicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dai aidʌsi camuu ʌEroodʌsi, tai ʌmo Diuusi tʌaañicarudʌ gʌmaasitu ʌOsee coosigadʌrʌ Ejiipitʌrʌ daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Vañigiñi dai vaidacai goali siʌʌñi ʌʌmadu dʌʌdʌ ʌpamu avʌr iimi gʌndʌvʌʌragamu casi atcoi ʌgai ismaacʌdʌ muaa ʌliditadai goali siʌʌñi ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Taidʌ ʌOsee vañi dai vuaa ʌali siʌʌñi ʌʌmadu ʌdʌʌdʌ tami Isireli dʌvʌʌriʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dʌmos aidʌsi maí ʌOsee siʌʌArquelao ʌrtʌaanʌdamicatadai Judeeʌrʌ gʌooga Eroodʌsi vʌʌtarʌ, duaadicuitadai ʌgai isimiagi gaamucu, tai coosigadʌrʌ aagidi Diuusi tʌaañicarudʌ sai Galileeamu iimʌna. ");
INSERT INTO ntpNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dai aʌcai Galileeʌrʌ dʌvʌʌriʌrʌ Nasareeta oidatu. Aidʌsi poduucai idui ʌgai poduucai ʌpʌdui ismaacʌdʌ aagai Diuusi ñiñiooquituldiadamigadʌ saidʌ ʌoodami pocaitiada agai saidʌ ʌSuusi ʌrNasareetʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aidʌ tuigaco oidigana Judeea dʌvʌʌriʌrʌ divia ʌVuaana ismaacʌdʌ vapaconai ʌoodami, ");
INSERT INTO ntpNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","daidʌ itʌtʌdai: ―Ʌma duucai avʌr gʌntʌtʌgito dai camaisoimaasi ivuaada casia miaadʌimi istuigaco Diuusi soiña agai oodami sai cʌʌgacʌrʌ oidacana ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Idi Vuaana ʌgai ismaacʌdʌ aagai ʌDiuusi ñiooquituldiadamigadʌ Isaíacaru aduucai ooja ʌgai: Diuusi ootosa agai ʌmo cʌʌli sai oidigana gamamaatʌtuldiña dai poduucai gaaagidamu ʌgai: “Caotoma divia agai gʌrtʌaanʌdamiga cascʌdʌ ʌma duucai avʌr gʌntʌtʌgito dai camaisoimaasi ivuaada”. Asduu ooja Isaía. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ɅVuaana yuucusidʌ cameyu vopodʌcʌdʌ duñisicatadai dai givuradʌ ogicʌdʌ duñisicatadai, dai soosoyi cuaadana ʌVuaana ʌʌmadu saivoli. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vai daivʌiña oodami vʌʌsi Judeea dʌvʌʌriaiñdʌrʌ Jerusaleenaiñdʌrʌ dai aa ʌʌmapʌcʌrʌaiñdʌrʌ caʌca ʌliditai istumaasi aagai ʌVuaana dai ismaacʌdʌ miaanai oidacatadai ʌaqui Jordán ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dai ismaacʌdʌ daanʌiña Diuusi sai oigʌldana soimaascamigadʌ ʌVuaana vapaconaiña ami ʌgʌʌ Jordán aquiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dʌmos aidʌsi tʌʌ ʌVuaana ismuidutai fariseo ʌʌmadu saduseo daivimi sai ʌgai vapaconana tai ʌgai itʌtʌdai: ―Aapimʌ ismaacʌdʌ daivʌi tami ansai gʌnvapaaconana ʌpan ducami coocoyi ismaacʌdʌ vopooyi siuu duucu camʌʌjidagi vasoi, poʌliditai sai poduucai Diuusi camaisoimaasi gʌntaatatulda agai. Ʌʌpʌga gʌaagai issʌʌlicʌdʌ ʌma duucai gʌntʌtʌgituagi aapimʌ dai camaisoimaasi ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cʌʌgacʌrʌavʌr oidaca vai nʌidiña aa mʌssʌʌlicʌdʌ caʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada agai. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dai maitavʌr povʌnʌliada aapimʌ mʌsaidʌ ʌrAvraañicaru cajiudadʌ sai cascʌdʌ cʌʌgacʌrʌ gʌnnʌidi Diuusi. Sʌʌlicʌdʌ angʌnaagidi sai Diuusi istutuidi isiduñiagi Avraañicaru cajiudadʌ asta idi ojoodiaiñdʌrʌ isipʌliadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Diuusi cabaigʌduu issoimaa taatatuldagi maicʌʌga tuutiacʌdʌ ʌpan duucai ʌmo cʌʌli ismaacʌdʌ guicutai uusi ismaacʌdʌ maicʌʌgadu iibiadʌ dai mʌmʌidi. Poduucai Diuusi ootosamu ʌoodami ismaacʌdʌ soimaasi ivueeyi mʌʌca siaaco tomastuigaco mʌʌcana taí. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aanʌ gia suudagicʌdʌ gʌnvapaconai sai nʌidiña aa mʌsai caʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada agai. Dʌmos divia agai ʌmai ismaacʌdʌ gʌnvapacona agai Diuusi Ibʌadʌcʌdʌ sai gʌnʌʌmadu daacana Diuusi Ibʌadʌ. Dai ʌgai vaa nʌida agai oodami ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami. Ʌgai vaamioma viaa guvucadagai iñsaanʌ. Aanʌ maitistutuidi siʌʌsi istutuidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ʌmo cʌʌli ismaacʌdʌ cʌlivai tʌligi bai tueeyi ʌtʌligi daidʌ ʌcosadʌ mʌmʌidi. Poduucai iduñia agai ʌgai ismaacʌdʌ divia agai ʌoodamicʌdʌ. Ismaacʌdʌ vaavoitudai ʌgai iimia agai tʌvaagiamu dai ismaacʌdʌ maivaavoitudai Diaavora ʌʌmadu iimia agai ʌgai siaaco tomastuigaco mʌʌcana taí ―astʌtʌdai ʌVuaana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Vaidʌ ʌSuusi Galilea dʌvʌʌri amaadʌrʌ imʌitadai dai aayi ami ʌgʌʌ Jordán aquiʌrʌ siaaco daacatadai ʌVuaana sai ʌgai vacuaanana. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ɅVuaana maitipʌlidimi tuucamidʌrʌ isvacuaanagi daidʌ itʌtʌdai ʌgai ʌSuusi: ―Aanʌava ʌgai dai gʌaagai pʌsgiñvacuaanagi. ¿Tuipʌsi aapi ipʌlidi isaanʌ gʌvacuaanagi? ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dʌmos ʌSuusi itʌtʌdai: ―Casi maiñioocada sioomʌ ʌrcʌʌgai tʌsiduñiagi istumaasi Diuusi ipʌlidi ―astʌtʌdai ʌSuusi. Taidʌ ʌVuaana ipʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Dai aidʌsi mosvacoi ʌVuaana ʌSuusi taidʌ ʌSuusi vuusai suudagiaiñdʌrʌ. Tai otoma gʌcupiooco ʌtʌvaagi taidʌ ʌSuusi tʌʌ Diuusi Ibʌadʌ vai tʌvai siaaco uucami daacatadai ʌgai ʌpa maasi ʌmo tugu. ");
INSERT INTO ntpNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tai caidatu ʌmo ñiooqui tʌvaagiaiñdʌrʌ daidʌ icaiti: ―Idiavʌr giñmara nai aliʌ oigʌdai aanʌ. Dai aanʌ aliʌ baigiñʌlidi goocʌdʌ ―ascaiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Taidʌ Diuusi Ibʌadʌ vaidacai ʌSuusi oidigamu, sabai ʌDiaavora iduiñtuldana ʌmo istumaasi istumaasi Diuusi maitipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Daidʌ Suusi maitauu goo coobai tasai dai goo coobai tucagi dai cascʌdʌ biuugimucatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Taidʌ ʌDiaavora miaadʌrʌ cʌquiva siaaco daacatadai ʌSuusi nʌida ʌliditai sabai iduiñtuldana ʌmo istumaasi istumaasi Diuusi maitipʌlidi daidʌ itʌtʌdai: ―Pʌsaapi ʌrDiuusi maradʌ di, tʌaañiñi goojoodai vai tascali gʌnaatona ―astʌtʌdai ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dʌmos ʌSuusi itʌtʌdai: ―Diuusi ñiooquidʌrʌ icaiti: “Maisiu mosʌca tascalicʌdʌ istutuidi oodami isoidacagi, gʌaagiava Diuusi ñiooquidʌ ʌʌpʌ”, ascaiti Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Taidʌ ʌDiaavora vaidacai ʌSuusi Jerusaleenamu dai ami ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu daama tʌsagi, ");
INSERT INTO ntpNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","daidʌ itʌtʌdai: ―Pʌsaapi ʌrDiuusi maradʌ di, tabiaadʌrʌ mʌtana gʌʌsi tuduidʌ. Pocaiti Diuusi ñiooquidʌrʌ di: Diuusi ootosamu gʌtʌtʌaañicaru vaidʌ gʌnuucaticana. Sigʌdaagiadamu ʌgai gʌnnoonovicʌdʌ pai maisaraana aapi gʌʌʌcaso ʌmo odiana. Ascaiti Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Taidʌ ʌSuusi itʌtʌdai: ―Pocaiti ʌʌpʌ Diuusi ñiooquidʌrʌ di: “Maitʌaagai pʌsaagiadagi Diuusi saidʌ iduuna ʌmo istumaasi mosnʌida ʌliditai sabai giduuna”, ascaiti Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tai ʌpamu ʌDiaavora vaidacai ʌSuusi ʌmo gʌʌ tuvidacamu dai abiaadʌrʌ tʌtʌʌgidi vʌʌsi gʌgʌr tʌtʌaanʌdami ismaacʌdʌ oidaga oidigi daama dai vʌʌsi oodami ismaacʌdʌ tʌaanʌi ʌtʌtʌaanʌdami, ");
INSERT INTO ntpNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","daidʌ itʌtʌdai: ―Aanʌ angʌmaquiagi oigaragai pai tʌaanʌda vʌʌsi goovai pʌsgiñvuidʌrʌ gʌtootonacʌdʌ cʌquivagi dai giñsiaa duutudagi ―astʌtʌdai ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Taidʌ ʌSuusi itʌtʌdai: ―Imʌdañi tabiaadʌrʌ Diaavora, pocaiti Diuusi ñiooquidʌrʌ: “Aliʌsi gʌaagai issiaa duutuadagi Diuusi dai mosʌca ʌgai ʌʌgiadagi”, ascaiti Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Taidʌ ʌDiaavora ii abiaadʌrʌ, tai dada Diuusi tʌtʌaañicarudʌ dai nuucagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aidʌsi maí ʌSuusi ismaisapicatadai ʌVuaana ii Galilea dʌvʌʌriamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dʌmos camaivii ʌgai Nasareetʌrʌ baiyoma Capernauumamu ii ʌgai dai mʌʌca oidaca agai. Capernauuma ʌrgʌʌ suudagi ugidiana. Ʌgʌʌ suudagi ugidiana ʌrNepatalicaru dʌvʌʌragadʌcatadai dai abaana Nepatalicaru dʌvʌʌragadʌ ʌrSebulonacaru dʌvʌʌragadʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aidʌsi ʌSuusi ii gamucu aidʌ ʌpʌdui ismaacʌdʌ ooja Diuusi ñiooquituldiadamigadʌ Isaíacaru daidʌ icaiti: ");
INSERT INTO ntpNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Mui oodami sibʌaadʌrʌ oidacami oidaca agai Galileeʌrʌ Sebulonacaru dʌvʌʌragadʌrʌ dai Nepatalicaru dʌvʌʌragadʌrʌ ʌgʌʌ suudagi abaana Jordán aqui maigovai. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dai ʌgai maimaatʌcamu Diuusi ñiooquidʌ dai aliʌ soimaasi ivuaadamu. Dʌmos gooquiʌrʌ caʌcamu ʌgai istumaasi gamamaatʌtulda agai ʌcʌʌgacʌrʌ vuviaadami dai baigʌnʌliadamu ʌgai. Ascaiti Isaíacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aidʌ abiaadʌrʌ ʌSuusi potʌtʌdaiña ʌoodami: ―Ʌma duuquiavʌr gʌntʌtʌgito dai camaisoimaasi ivuaada. Casia miaadimi istuigaco soiña agai Diuusi oodami sai cʌʌgacʌrʌ oidacana ―astʌtʌdaiña ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ɅSuusi gʌʌ suudagi ugidiamu sʌʌli imʌitadai Galileeʌrʌ, dai tʌʌ gooca gʌnsiʌʌgʌmʌ. Ʌmoco Simuñi Piiduru tʌʌgidu, dai ʌgʌmai Aandʌrʌsi. Ʌgai ʌrvatopa vuudamicatadai, dai suudarʌ dadaitudai gʌnvatopa vuicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Taidʌ ʌSuusi itʌtʌdai: ―Giñoidávurai nai aanʌ gʌnmaatʌtuldana mʌsducatai gaagada aapimʌ oodami vaidʌ giñvaavoitudana ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tai ʌgai otoma anaasi viaa gʌnvatopa vuicaru dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Dai baitʌquiooma tʌʌ ʌSuusi ʌʌpʌ gooca gʌnsiʌʌgʌmʌ. Jacovo ʌʌmadu Vuaana Sevedeo maamaradʌ. Vai ʌmo vaarcu ʌraana daraajatadai ʌʌmadu oogadʌ dai daraasdi gʌnvatopa vuicaru. Taidʌ ʌSuusi vaí. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tai ʌgai otoma anaasi viaa ʌvaarcu ʌʌmadu gʌnooga dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ɅSuusi vʌʌsi Galilea dʌvʌʌriana aimʌraitadai, dai vʌʌsi judidíu quiquiuupaigadʌrʌ gaaagidimi isDiuusi soiña agai oodami sai cʌʌgacʌrʌ oidacana. Vʌʌsi istumaasi gaaagidiña ʌSuusi sʌʌlicʌdʌ ʌrcʌʌgaducami. Dai Suusi duduaaidimi mui oodami naana maasi coocodagai viaacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tai otoma maí vʌʌsi Siria dʌvʌʌriʌrʌ oidacami istumaasi ivuaadana ʌSuusi, dai otoma vuaapi ʌgai ʌSuusi vʌʌsi ʌcoococoidadʌ sai duduaaidana tomastuma coocodagai viaacami dai ismaacʌdʌ maitistutuiditadai isoiñʌdagi vaidʌ ʌSuusi duduaaidiña vʌʌscatai dai vuvaitu Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tai oí mui oodami ʌSuusi Galileeaiñdʌrʌ, dai Decapolisi dʌvʌʌriaiñdʌrʌ, dai vʌʌsi Judeea dʌvʌʌriaiñdʌrʌ Jerusaleenaiñdʌrʌ dai aa ʌʌmapʌcʌrʌaiñdʌrʌ, ʌgʌʌ aqui Jordán vasoñiomaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dai aidʌsi tʌʌ ʌSuusi vʌʌsi ʌoodami, tʌsai ʌmo giidiana dai ami daiva. Taidʌ ʌmamaatʌrdamigadʌ gʌnʌmpagi ʌSuusi sicoli dai vʌʌsi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Vaidʌ ʌSuusi mamaatʌtuldi daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Diuusi cʌʌgacʌrʌ nʌidi vʌʌscatai ismaacʌdʌ maatʌ istʌgito isDiuusi soiñagi vaidʌ ivuaada ʌgai istumaasi Diuusi ipʌlidi. Diuusi soiñamu vai ʌgai ivuaadana istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ sivi soigʌʌlidi soimaasi ivuaadatai ʌgai Diuusi bai ʌʌliatudamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ maigʌgʌrducʌdʌ gʌnʌlidi, ʌgai tʌaanʌdamu oidigi utudiʌrʌ siʌʌscadʌ ugitiagi idi oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ sʌʌlicʌdʌ cʌʌgacʌrʌ oidaca ʌlidi, Diuusi soiña agai ʌgai vai poduucai oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ soigʌnʌlidi aacʌdʌ, Diuusi soigʌʌliadamu ʌgaicʌdʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ maisoimaasi ivuaada ʌlidi. Ʌgai Diuusi ʌʌmadu iimimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ soicʌi ʌcocoadami sai camaitʌncocodaiña. Diuusi gʌmaamara duucai nʌijadamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Diuusi cʌʌgacʌrʌ nʌidi ʌgai ismaacʌdʌ aa soimaa taatamituldi ivuaadatai ʌgai istumaasi Diuusi ipʌlidi. Diuusi soiñamu vaidʌ apiaivuaada ʌgai istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Diuusi cʌʌgacʌrʌ gʌnnʌijadamu aapimʌ siʌʌscadʌ ʌoodami gʌnaagiadagi soimaasi ñiooqui dai soimaasi gʌntaatamituldiadagi dai mʌsiʌʌscadʌ gʌnyaatagʌdagi, giñvaavoitudaitai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dʌmos baigavʌr ʌnʌliada aapimʌ Diuusi gʌnmaaquimu ʌmo istumaasi cʌʌgaducami tʌvaagiʌrʌ, poduucai ʌʌpʌ soimaa taata ʌDiuusi ñiñiooquituldiadamigadʌ ismaacʌdʌ ʌʌpʌga dada isaapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ismaicʌʌgacʌrʌ oidaca aapimʌ oodami maitipʌliadamu isvaavoitudagi Diuusi ñiooquidʌ poduucai isduucai ʌmo oodami maitipʌlidiña iscuaadagi cuaadagai maiyoovicami. Cascʌdʌ aliʌsi gʌaagai iscʌʌgacʌrʌ oidaca aapimʌ. Nʌiditai aa iscʌʌgacʌrʌ oidaga aapimʌ poduucai ipʌliadamu ʌgai isvaavoitudagi Diuusi ñiooquidʌ dʌmos ismaicʌʌgacʌrʌ oidaca aapimʌ aidʌ gia maisoicʌi aapimʌ oodami dai Diuusi gajiaadʌrʌ gʌnviaamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","16","Aliʌsi ʌrsoiñi cuudagi tucarʌ. Poduucai ʌʌpʌ aliʌsi ʌrsoiñi aapimʌ cʌʌgacʌrʌ oidacatai vai poduucai maatʌna aa isducatai Diuusi ipʌlidi isoidacagi. Vʌʌsi oodami gʌntʌgito nʌidi isaapimʌ ʌrvaavoitudadami. Daidʌ ʌoodami nʌiditai iscʌʌgacʌrʌ oidaga aapimʌ siaa duutuadagi Diuusi gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Maitavʌr povʌnʌliada aapimʌ iñsaanʌ divia dai maiʌʌgiada iñagai Diuusi sʌʌlicamigadʌ dai mamaatʌtuldiaragadʌ ismaacʌdʌ aagidi ʌgai Moseesacaru dai gʌñiñiooquituldiadamiga, baiyoma divia aanʌ dai ʌʌgiada iñagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sʌʌlicʌdʌ angʌnaagidi sai siʌʌsi uucami cʌaacagi oidigi vʌʌsi istumaasi aagai Diuusi moduucai imʌda agai maitʌviaa agai tomalaachi tomali ʌmo oojai maimaigovai gʌdaasa agai asta siʌʌscadʌ ʌpʌdui vʌʌsi ismaacʌdʌ viaa siʌpʌduñiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Cascʌdʌ sioorʌ ʌmapiadʌrʌ viaagi ʌmo istumaasi Diuusi sʌʌlicamigadʌaiñdʌrʌ, tomasi ʌgai poʌlidi ismaisi gʌaagai isiduñiagi dai poduucai mamaatʌtuldiadagi ʌoodami sai poduucai ivuaadana ʌgai maicʌʌga ivueeyi istumaasi Diuusi ipʌlidi. Dʌmos ʌgai ismaacʌdʌ ʌʌgiadagi Diuusi sʌʌlicamigadʌ dai poduucai mamaatʌtuldiadagi ʌoodami sai poduucai ivuaadana ʌgai gia cʌʌga ivueeyi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aanʌ angʌnaagidi aapimʌ sai ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo poʌlidi iscʌʌgacʌrʌ oidaga dʌmos maitʌrvaavoi. Aapimʌ aliʌsi gʌaagai issʌʌlicʌdʌ cʌʌgacʌrʌ oidacagi maisiu ʌpan duucai ʌgai. Dʌmos istʌtʌgitoda aapimʌ ʌpan duucai ʌgai, Diuusi maitʌnsoiñamu iscʌʌgacʌrʌ oidaca aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aapimʌ cajioma mʌsaidʌ itʌtʌdai gʌnʌʌqui aaduñicaru: “Maitavʌr gacoodada, isʌmaadutai gamuaagi ʌdudunucami gʌaagai isgatʌaañiagi muaaragai ʌgai ʌʌpʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dʌmos aanʌ angʌnaagidi sai tomasioorʌ sioorʌ baamuagi gʌaduñi vui, dai sioorʌ galnaasi ñioocadagi gʌaduñi vui, dai sioorʌ vuiirugami aagadagi gʌaduñi Diuusi soimaa taatatuldamu tomasi gʌnmamaatʌtuldiadamiga maipoduucai gʌnmamaatʌtuldiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Poduucai isʌmaadutai imiagi ʌgʌʌ quiuupiamu dai siaa duutuda agadagi Diuusi dai ami tʌgituagi saidʌ idui ʌmo istumaasi soimaascami gʌaduñi vui vai cascʌdʌ vui baamucagi ʌaduñdʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","gʌaagai isvuusia ʌgai abiaadʌrʌ dai mʌʌ nʌidagi gʌaduñi dai baiduñiagi ñiooqui ʌgai ʌʌmadu. Dai aidʌ gia ʌpamu imiagi ʌgai ʌgʌʌ quiuupiamu dai ami siaa duutudagi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Isʌmaadutai soimaasi iduñiagi gʌaduñi vui vaidʌ ʌaduñdʌ vaidaquiagi dudunucamiʌrʌ dʌmos baiyoma gʌaagai isbai duñia ʌgai ñiooqui ʌgai ʌʌmadu voiyamu vai ʌgai maivaidaquiagi dudunucamiʌrʌ vaidʌ ʌdudunucami tʌʌgidan tada ʌsandaaru vaidʌ ʌsandaaru maisagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aanʌ gia gʌnaagidi sai maivuusian tada ʌgai abiaadʌrʌ asta siʌʌscadʌ gaaa namʌqui vʌʌsi mʌsiʌʌsi tañiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Aapimʌ cajioma sai ʌʌqui abiaadʌrʌ aduucai gʌaa: “Sai maitʌaagai isgoogosi gʌnducamicagi oodami”. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dʌmos aanʌ angʌnaagidi sai tomasioorʌ sioorʌ galnaasi gʌntʌtʌgitodagi ʌmo ooqui vui tomasi mʌʌcasdʌrʌ nʌidi ʌgai, ʌgai caʌpan ʌʌsi soimaasi ivueeyi isʌʌmadu voimudai. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Isʌmaadutai nʌijadagi ʌmo istumaasi dai gaʌʌsida ʌliadagi siʌʌpʌ ʌma maasi soimaascami baiyoma gʌaagai ismainʌijadagi dai Diuusi ʌʌmadu imiagi dai maisiu ʌDiaavora ʌʌmadu imiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Isʌmaadutai iduñia ʌliadagi ʌmo istumaasi soimaascami gʌnoonovicʌdʌ baiyoma gʌaagai ispoʌliadagi ʌgai ismainoonovʌ dai Diuusi ʌʌmadu imiagi dai maisiu ʌDiaavora ʌʌmadu imiagi. Poduucai aagai ʌSuusi sai ʌoodami camaisoimaasi ivuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ʌʌqui aduucai gʌaagai ʌʌpʌ: “Tomasioorʌ sioorʌ dagituagi gʌooñiga gʌaagai ismaquiagi ʌmo oojai siaaco aagadagi iscadagito”. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dʌmos aanʌ angʌnaagidi sai isʌmo cʌʌli dagituagi gʌooñiga, maiviaacatai istuisidʌ dagituagi, oodami poʌliadamu isʌooqui gogoosi gʌducami sai cascʌdʌ dagito ʌcʌʌli dʌmos ʌcʌʌli ʌrduñidʌ ispoduucai tʌtʌgitodagi ʌoodami, dai sioorʌ vʌʌnagi ʌmo ooqui dagitobarui ʌgai soimaasi ivueeyi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aapimʌ cajioma ʌʌpʌ mʌsaidʌ itʌtʌdai gʌnʌʌqui aaduñicaru: “Siʌʌscadʌ ʌmaadutai pocaitiadagi sai maatʌ Diuusi sai sʌʌlicʌdʌ iduñia agai ʌmo istumaasi Diuusi vʌʌtarʌ aliʌsi gʌaagai isiduñiagi”. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dʌmos aanʌ angʌnaagidi sai maitʌaagai isaagadagi Diuusi tomastumaasicʌdʌ. Gʌaagai isaagadagi Diuusi mosʌcaasi siʌʌscadʌ sʌʌlicʌdʌ gʌaagadagi dai sai siʌʌscadʌ aagadagi isʌmo istumaasi ʌrvaavoi maiaagadagi tʌvaagi mʌʌca gatʌaanʌi Diuusi cascʌdʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","tomali maiaagadagi dʌvʌʌrai ami daja Diuusi cascʌdʌ, tomali Jerusaleena ami gatʌaanʌda agai Diuusi gʌrbaitʌcʌaacamiga cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dai tomali maiaagadagi gʌnmoomo aapimʌ maitistutuidi istojatudagi siʌʌpʌ tucutudagi tomali ʌmo cuupai. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mosavʌr cho caitiada siʌʌpʌ ʌjʌ dai maitʌrcʌʌgai isvaamioma aagadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Aapimʌ cajioma isʌʌqui gʌaagai aduucai: “Isʌmaadutai gʌgʌgʌʌviagi gʌvuji pai camainʌaada aapi gʌvujicʌdʌ ʌdudunucami viaa ispoduucai iduñiagi ʌgaicʌdʌ ʌʌpʌ dai isʌmaadutai gʌgʌgʌʌviagi dai daitudagi gʌtaatamu ʌdudunucami viaa ispoduucai iduiñiagi ʌʌpʌ ʌgaicʌdʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dʌmos aanʌ angʌnaagidi: Maitʌaagai pʌsvui gʌsia aapi ʌoomaligami baiyoma isʌmoco gʌgʌgʌʌviagi gʌvuivasana dagitoñi vai ajadʌrʌ gʌgʌgʌna ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Isʌmoco vaama gʌcʌʌsagi dai gʌyaatagʌdagi gʌvoopoida ʌliditai gʌvaasaraga dagitoñi vai bʌʌcaiña gʌdaan vaasaraga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Isʌmaadutai gʌaagidagi issoiña bʌʌquia aapi cusuvidʌ tomasi daan duucu uucami soiñañi asta uruunoco uucami. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tomasioorʌ sioorʌ gʌtaanʌdagi ʌmo istumaasi maacañi aapi, dai sioorʌ gʌtaanʌdagi ʌmo istumaasi tañiuvidicami tañiuvidañi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Aapimʌ cajioma ʌʌpʌ sai aduucai gʌaa ʌʌqui: “Oigʌadañi gʌaduuñi dai cʌʌdada gʌsaayu”. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dʌmos aanʌ angʌnaagidi: Oigʌadavurai gʌnsasayu, cʌʌgavʌr ñioocada vui ʌgai ismaacʌdʌ gʌnñiooquidi, cʌʌgavʌr ivuiidiada sioorʌ gʌncʌʌdadagi, gamamadadavurai ʌgai vʌʌtarʌ ismaacʌdʌ soimaasi ñiooqui gʌnsuuligiadagi dai soimaasi gʌntaatamituldiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Poduucai gʌmaatʌ isaapimʌ ʌrmaamaradʌ gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja. Ʌgai ootosdi tonoli cʌʌga tuutiacami dai maicʌʌga tuutiacami, dai ʌgai ootosdi duuqui ismaacʌdʌ siaa duutudai dai ismaacʌdʌ maisiaa duutudai. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dai isaapimʌ oigʌadagi mosʌca ʌgai ismaacʌdʌ gʌnoigʌdai aapimʌ poduucai siaadʌrʌ gʌnoidana Diuusi ʌmo istumaasi. Asta maicʌʌga tuutiacami ʌʌpʌ poduucai ivueeyi di. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dai isviaatuldiada aapimʌ mosʌca gʌnaaduñi tuma cʌʌga ivueeyi aapimʌ asta ʌgai ismaacʌdʌ maivaavoitudai Diuusi ʌʌpʌ poduucai ivueeyi di. ");
INSERT INTO ntpNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cʌʌgavʌr ivuaada aapimʌ ʌpan duucai gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Siʌʌscadʌ aapimʌ siaa duutuadagi Diuusi maitavʌr poduucai ivuaada mosipʌliditai isgʌnnʌijadagi ʌoodami dai cʌʌga ñioocadagi aapimʌ gʌnvui, mʌspovuaada aapimʌ aidʌ gia gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja maitʌnoidamu tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cascʌdʌ mʌsiʌʌscadʌ oidiadagi soituutuigami ʌmo istumaasi maitavʌr poduucai ivuaada mosipʌliditai isgʌnnʌijadagi oodami poduucai isduucai ivueeyi ʌgai ismaacʌdʌ aagaiña ʌmo istumaasi dai ʌma maasi ivuaadana. Quiquiuupiʌrʌ dai cacaayana poduucai ivuaadana ʌgai sai cʌʌga ñioocaiña oodami ʌgai vʌʌtarʌ. Dʌmos aanʌ angʌnaagidi sai ʌgai ismaacʌdʌ povuaadagi gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja maioidamu tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dʌmos mʌsiʌʌscadʌ aapimʌ oidiadagi ʌmo istumaasi soituutuigami maitavʌr poduucai ivuaada ipʌliditai isgʌnnʌijadagi aa. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dai Diuusi gʌrooga ismaacʌdʌ nʌidi mʌstumaasi ivueeyi ʌgai gʌnoidamu ʌmo istumaasi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Dai mʌsiʌʌscadʌ gamamadada aapimʌ, maitavʌr ʌpan duucai ivuaada ʌgai ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi, ʌgai oojoidi isgugucaitai gamamadadagi quiquiuupiʌrʌ dai cacaayana sai nʌidiña ʌoodami. Sʌʌlicʌdʌ angʌnaagidi sai gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja maitʌnoidamu tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dʌmos aapimʌ mʌsiʌʌscadʌ gamamadadagi iimivurai siaaco maitiipu oodami dai gamamadada. Dai Diuusi gʌrooga ismaacʌdʌ nʌidi mʌstumaasi ivueeyi ʌstocai ʌgai gʌnsoicʌdamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mʌsiʌʌscadʌ gamamadadagi maitavʌr muiyoco aagada ʌmo istumaasi isduucai ivueeyi ʌgai ismaacʌdʌ maivaavoitudai Diuusi dai poʌlidiña ʌgai sai ʌmomoono caʌca agai aliʌ tʌvʌpi ñioocaitai ʌgai tomasi maicaʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Maitavʌr potuutiaca aapimʌ, Diuusi gʌrooga maiquiaa aagidacai aapimʌ abiaadʌrʌ camaatʌcana mʌstumaasi tʌgito aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Cascʌdʌ aduuquiavʌr gamamadada: Gʌrooga aapi pʌsmaacʌdʌ tʌvaagiʌrʌ daja, aatʌmʌ ipʌlidi isʌoodami gʌsiaa duutuadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Vai otoma aʌna istuigaco gatʌaanʌda agai aapi ʌʌgi tami oidigi daama. Vaidʌ ʌpʌduuna pʌstumaasi aapi ipʌlidi tami oidigi daama poduucai isduucai ʌpʌvueeyi tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gʌrsoiñañi tʌtai viaaca aatʌmʌ cuaadagai tʌsiʌʌsi tʌgito sivi vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gʌroigʌldañi gʌrsoimaascamiga tʌsmaacʌdʌ ivueeyi poduucai tʌsduucai oigʌldi aatʌmʌ ʌgai ismaacʌdʌ soimaasi gʌrvuiididi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Maiti dagito isʌDiaavora gʌraagiadan taadacagi isiduñia aatʌmʌ soimaasi. Cʌʌ maatʌ aatʌmʌ isaapi ʌrʌgʌʌ baitʌcʌaacami tʌvaagiʌrʌ dai oidi daama tomastuigaco, dai aapi vaamioma viaa guvucadagai tomastuigaco istomali ʌmo ʌmai dai isaliʌsi gʌaagai isvʌʌsi oodami gʌsiaa duutuadagi tomastuigaco. Vʌʌsi gomaasi sʌʌlicʌdʌ ʌpʌduñia agai poduuquiavʌr gamamadada. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mʌsaapimʌ oigʌldiadagi aa siʌʌscadʌ soimaasi gʌnvuiidiada ʌgai, Diuusi gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja gʌnoigʌldiadamu aapimʌ gʌnsoimaascamiga ʌʌpʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","dai mʌsaapimʌ maioigʌldiadagi aa aidʌ gia tomali Diuusi gʌrooga maitʌnoigʌldiadamu gʌnsoimaascamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mʌsiʌʌscadʌ aapimʌ gayunandudagi maitavʌr soigʌnʌliadan vuaada ʌpan duucai ʌgai ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi, ʌgai soigʌnʌliadan vuaadana sai nʌidiña oodami isyunandui ʌgai. Sʌʌlicʌdʌ angʌnaagidi sai gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja maioidamu tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dʌmos aapimʌ mʌsiʌʌscadʌ gayunandudagi maitʌaagai mʌssoigʌnʌliadan vuaadagi, ");
INSERT INTO ntpNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vai maimaatʌna oodami mʌsgayunandui. Vai mosʌca Diuusi gʌrooga maatʌcana dai poduucai ʌgai gʌnoidamu ʌmo istumaasi cʌʌgaducami. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Maitʌaagai istʌtʌgitodagi oodami isʌmpaidiadagi mui naana maasi tami oidigi daama siaaco maamaradʌ uugiugai dai siaa gʌvueeyi istumaasi dai tami siaaco ʌʌsivogami vapacʌi dai gaʌʌsidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Baiyoma gʌaagai isivuaadagi vʌʌsi istumaasi Diuusi ipʌlidi dai ʌgai maaquimu istumaasi tʌgito tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","23","Isʌmpaidiada oodami mui naana maasi dai riricutuagi aidʌ gia mostʌtʌgitodamu ʌgai gʌnvustuidaga dai poduucai ʌʌgi gʌnvupuiirumadai dai maisoicʌi aa dai maitistutiadamu istʌtʌgitodagi istumaasi Diuusi ipʌlidi isivuaada ʌgai. Dai camaitʌtʌgitoi istumaasi aagai Diuusi ñiooquidʌrʌ dai apiasoimaasi ivuaadana. Baiyoma gʌaagai istʌtʌgitodagi oodami istumaasi Diuusi ipʌlidi isivuaadagi poduucai gia soicʌi ʌgai aa. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sioorʌ mostʌtʌgitodagi isducatai gamaitʌcʌdagi mui tumiñsi ʌgai gia maitistutuidi isʌʌgiadagi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Gʌnaagidiana maitavʌr vuam ʌnʌliada cuaadagaicʌdʌ mʌsmaacʌdʌ ugia agadagi siʌʌpʌ mʌstumaasi iiya agadagi dai oidacagi, tomali yuucusicʌdʌ mʌsmaacʌdʌ gʌnaada agadagi. Diuusi gʌndui aapimʌ Diuusi gʌnmaa iibʌdagai ʌgai gʌnsoiñamu isviaacagi cuaadagai dai yuucusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nʌidavurai ujuurugi. Goovai maita ʌsai tomali maita yoovai, tomali maibai tueeyi gʌnyoova troojʌrʌ, vai vʌʌscʌrʌ Diuusi gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja maacai cuaadagai. Ʌoodami vaamioma namʌga siujuurugi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Cascʌdʌ maitʌrsoiñi isnaana maasi tʌtʌgitodagi oodami. Tomali maitistutuidi istaajucami metro vaamioma gʌtʌcavaldiagi, tomasi naana maasi gʌtʌtʌgitoi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Tuisidʌ mosʌʌsi tʌtʌgitoiña oodami yuucusi? ʌoodami gʌaagai isnʌijadagi isducatai gʌʌrai yoosigai oidigana maita aata vuaadatai dai tomali maita iilutaitai. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dai vʌʌscʌrʌ gʌnaagidi aanʌ sai tomali ʌraí Salomoñicaru ismaacʌdʌ viaacatadai yuucusi cʌcʌʌgaducami vʌʌscʌrʌ yuucusidʌ maiʌpan ʌʌsi chigiamaasi yoosigai. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gʌaagai isgʌntʌgito nʌijadagi oodami vasoi. Chiʌʌqui tasai dʌjiana guucacana dai gaacʌcai gʌmʌmʌidi ooroñiʌrʌ maitiipucatai cuaagi vai vʌʌscʌrʌ Diuusi sigia maastudai, vʌʌsi vaamioma soiñana ʌgai oodami isyuucustada. Vʌʌscʌrʌ ʌoodami maicʌʌga vaavoitudai isDiuusi nuucada. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Cascʌdʌ gʌaagai ismaivuam ʌnʌliadagi oodami dai maitʌaagai ispocaitiadagi: “¿Istumaasi ugimu aatʌmʌ?” Siʌʌpʌ: “¿Istumaasi iimu aatʌmʌ?” Siʌʌpʌ: “¿Istumaasi gʌraadamu aatʌmʌ?” ");
INSERT INTO ntpNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vʌʌsi ʌoodami ismaacʌdʌ maivaavoitudai Diuusi mosʌca gomaasi gʌntʌtʌgitoiña, dʌmos gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja camaatʌ isvʌʌsi gomaasi tʌgito aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Baiyoma gʌaagai isipʌliadagi oodami sai Diuusi soiñana vai cʌʌgacʌrʌ oidaca ʌgai isducatai Diuusi ipʌlidi, siDiuusi soicʌdamu siviaacamu ʌgai istumaasi tʌgitocagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maitʌaagai issoimaasi gʌntaatamituldiadagi oodami naana maasi gʌntʌtʌgitoitai. Vʌʌs tasai naana maasi oidacana dai vʌʌscʌrʌ Diuusi gʌrnuucada aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Maitavʌr pocaitiadai: “Dañi tʌʌ soimaasi idui ʌgai maiviaacatai istuisidʌ pocaitiadagi”. Ispocaitiada aapimʌ Diuusi potʌimu sai maicʌʌga ivueeyi aapimʌ pocaititai. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Isʌmaadutai gʌtʌgito nʌijadagi ʌsoimaasi ismaacʌdʌ ivuaadagi ʌaduñdʌ aidʌ gia Diuusi gʌtʌgito nʌijadamu ʌsoimaasi ismaacʌdʌ ivuaadana ʌgai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Tuipʌsi gʌtʌgito nʌidi issoimaasi ivueeyi gʌaduñi dai maitʌtʌgito nʌidi isaapi vaamioma soimaasi ivueeyi? ");
INSERT INTO ntpNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Tuipʌsi maisiaa ʌrai aapi?, sai potʌtʌdai gʌaduñi: “Dañi aliʌ soimaasi ivueeyi aapi”, tʌtʌdai. Dai maitʌtʌgito nʌidi isvaamioma soimaasi ivueeyi aapi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Aapi ʌrʌmoco ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Ʌʌpʌga gʌaagai iscamaisoimaasi ivuaada aapi dai gooquiʌrʌ aagidagi gʌaduñi sai camaisoimaasi ivuaadana. Mʌsapiaaagiadamudai aapimʌ Diuusi ñiooquidʌ ʌoodami ismaacʌdʌ cʌʌdai Diuusi mosgalnasi ñioocadamudai ʌgai Diuusi vui dai soimaasi ivuiidiadamudai Diuusi ñiñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Cascʌdʌ maitʌaagai mʌsapiaaagiada Diuusi ñiooquidʌ ʌoodami ismaacʌdʌ cʌʌdai Diuusi dai maivaavoituda ʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aliʌsi gʌaagai mʌsiapiataanʌdagi Diuusi istumaasi tʌgitocagi siʌgai gʌnsoicʌdamu sai viaacana istumaasi tʌgitocagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sioorʌ apiataanʌdagi Diuusi istumaasi tʌgitocagi Diuusi sʌʌlicʌdʌ soicʌdamu ʌgai sai viaacana istumaasi tʌgitocagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Baisoidaga ʌmaadutai aapimʌ isgʌntaañiagi gʌnmara ʌmo paana baisoidana aapimʌ ʌmo odai? ");
INSERT INTO ntpNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Siʌʌpʌ isbaioidana aapimʌ ʌmo cooyi isgʌntaañia ʌgai vatopa? ");
INSERT INTO ntpNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʌsaapimʌ ismaacʌdʌ maicʌʌ tuutuiga maatʌ oidi gʌnmaamara istumaasi cʌʌgaducami, siooma cʌʌga gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja ʌgai maacai istumaasi cʌcʌʌgaducami sioorʌ taanʌdagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pocaiti Diuusi sʌʌlicamigadʌrʌ dai pocaiti ʌʌpʌ Diuusi ñiñiooquituldiadamigadʌ. Mʌstumaasi ipʌliada aapimʌ isgʌnvuiidiadagi aa poduuquiavʌr ivuiidiada aapimʌ ʌgai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Sʌʌlicʌdʌ avʌr ipʌliada aapimʌ isDiuusi gʌnsoicʌdagi isʌʌgiada aapimʌ. Muidutai maitipʌlidi isDiuusi soicʌdagi. Siooma maisijaiga isʌgai ivuaadagi istumaasi ipʌlidi dʌmos ʌgai gia iimimu Diaavora ʌʌmadu. Aliʌ sijaiga oodami vʌʌtarʌ isipʌliadagi isDiuusi soicʌdagi isʌʌgiada ʌgai Diuusi, dai vaamioma chiʌʌquidu sioorʌ ʌʌgidi Diuusi dai ʌgai gia iimimu Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gʌnnuucadacavurai dai maitivuaada istumaasi gʌnaagiadagi ʌmamaatʌtuldiadami yaatavogami. Ʌgai gʌnʌʌmadu gʌnʌmpaidi ducami isvaavoitudadagi Diuusi ñiooquidʌ dʌmos maitʌrvaavoi isvaavoitudai ʌgai. Ʌgai ipʌlidi isgʌnvupuiirumadagi mʌsaidʌ ʌrmamaatʌrdamigadʌcana dai oidiña mui naana maasi mʌstumaasi viaacagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aapimʌ istutuidi ismatiagi isbai sʌʌlicʌdʌ ʌrDiuusi ñiñiooquituldiadamigadʌ ʌgai ischo ʌʌpʌ, ʌgaicʌdʌ ismaacʌdʌ ivuaada ʌgai. Cʌʌga maatʌ aapimʌ ismaitʌyoovai uuvasi uupariaiñdʌrʌ, tomali iigosi uuvasi dʌʌdʌdʌaiñdʌrʌ, poduucai ʌʌpʌ ʌoodami yaatavogami maitistutuidi iscʌʌgacʌrʌ oidacagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Poduucai ʌʌpʌ oidaga uusi ismaacʌdʌ yoovi iibiadʌ dai oidaga aa uusi ismaacʌdʌ maiyoovi iibiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ʌmo uusi cʌʌgaducami maitistutuidi issoimaascagi iibiadʌ, dai ʌmo uusi maicʌʌgaducami maitistutuidi iscʌʌgaducagi iibiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vʌʌsi uusi ismaacʌdʌ maicʌcʌʌgaducagi iibiadʌ tami gʌrdʌvʌʌragʌrʌ gʌguicumai dai taiyʌrʌ gʌmʌmʌidi. Poduucai ʌʌpʌ Diuusi soimaa taatatuldamu ʌmamaatʌtuldiadami yaatavogami ʌgʌʌ taiyʌrʌ ʌDiaavora ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nʌiditai issoimaasi ivueeyi ʌgai poduucai gʌmaatʌ isʌgai ʌryaatavogami. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Maisiu vʌʌscatai ismaacʌdʌ pocaitiadagi sai aanʌ ʌrtʌaanʌdamigadʌ iimia agai siaaco gatʌaanʌi Diuusi mosʌca ʌgai ismaacʌdʌ ivueeyi istumaasi ipʌlidi Diuusi gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Siʌʌscadʌ ajiagi istuigaco nʌida iñagada aanʌ vʌʌsi oodami ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami amaasi muidutai povai iñtʌtʌadamu: “Tʌaanʌdami aatʌmʌ gamamaatʌtuldiña gʌñiooqui, dai gʌguvucadagacʌdʌ vuvaidiña Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ, dai gʌguvucadagacʌdʌ ivuaadana aatʌmʌ mui naana maasi gʌgʌrducami”, iscaitiadamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dʌmos aanʌ potʌʌdamu: “Aapimʌ tomali ʌmo imidagai maitiñvaavoitu. Iimivurai tabiaadʌrʌ. Aapimʌ ʌrsoimaasi ivuaadami”, antʌʌdamu aanʌ ―astʌtʌdai Suusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Daidʌ itʌtʌdai ʌʌpʌ: ―Sioorʌ giñcaʌcagi daidʌ ivuaadagi istumaasi aagai aanʌ ʌgai ʌrʌpan ducami ʌmo cʌʌli ismaacʌdʌ aliʌ saituduga daidʌ idui ʌmo vaaqui dʌmos ʌʌpʌga cʌʌga cooco dʌvʌʌrai dai cʌʌgaducami darai simientogadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tai duudu dai gʌʌpi daivusai suudagi dai cavami ʌvʌ tai vʌʌscʌrʌ maigʌi ʌvaaqui cʌʌgaducatadai ʌgai simientogadʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dʌmos sioorʌ giñcaʌcagi dai maitivuaadagi istumaasi aagai aanʌ ʌgai ʌrʌpan ducami ʌmo cʌʌli vuiirugami ismaacʌdʌ mosoorai daama idui ʌmo quii. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tai duudu dai gʌʌpi daivusai suudagi dai cavami ʌvʌ tai gʌi ʌvaaqui dai camaitʌrsoiñi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aidʌsi canaatocai ñioo ʌSuusi, vaidʌ ʌoodami camaitʌʌ isducatai gʌntʌtʌgituagi caʌcatai siʌʌ cʌʌga ñioocai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ʌmo sʌʌlicami viaacami duucai mamaatʌtuldi ʌgai dai maisiu ʌpan duucai ʌmo mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aidʌsi ʌSuusi tʌvai giidiaiñdʌrʌ tai oí mui oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tai miaadʌrʌ cʌquiva ʌmo cʌʌli ismaacʌdʌ viaacatadai ʌmo coocodagai ismaacʌdʌ duvaaldi gatuucuga dai siaa duutuli ʌSuusi, daidʌ itʌtʌdai: ―Tʌaanʌdami pʌsipʌliadagi istutuidi aapi isgiñduaaidagi ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Taidʌ ʌSuusi taata gʌnovicʌdʌ daidʌ itʌtʌdai: ―Ipʌlidiana isgʌduaaidagi, duaadicami ivii ―astʌtʌdai ʌSuusi. Mospotʌi ʌSuusi taidʌ ʌcoocoadʌ duaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Taidʌ ʌSuusi itʌtʌdai: ―Dañi, maitiaagiada tomali ʌmaadutai pʌsducatai dueeyi mosaiimi dai mʌʌ vuidʌrʌ cʌquiva ʌpaali dai oida istumaasi aagai Moseesacaru sʌʌlicamigadʌ vai nʌidiña ʌoodami pʌscadueeyi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aidʌsi mosaayi ʌSuusi Capernauumʌrʌ tai miaadʌrʌ cʌquiva ʌmo sandaaru tʌaanʌdamigadʌ. Ʌgai ʌrromanu dai daañimi, ");
INSERT INTO ntpNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","daidʌ itʌtʌdai: ―Tʌaanʌdami giñmara quiiyʌrʌ caatʌ maitistutuidi isaimʌrdagi dai aliʌ soimaa taataca coocodagai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ gaamu imimu dai duaaidamu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Taidʌ ʌsandaaru tʌaanʌdamigadʌ aa noragi daidʌ itʌtʌdai: ―Tʌaanʌdami aapi vaamioma tʌaanʌi iñsaanʌ cascʌdʌ maitʌaagai pʌssoigʌvuaadagi mosai potʌi sai duaadʌna giñmara siʌgai duaadimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aanʌ viaa giñtʌaanʌdamiga, dai aanʌ viaa ʌʌpʌ giñsandaaruga ismaacʌdʌ tʌaanʌi aanʌ, siʌʌscadʌ aagida aanʌ ʌmoco sai imʌna vai aimʌrai, dai siʌʌscadʌ aagida aanʌ ʌmai sai diviana vai didivai, dai siʌʌscadʌ tʌaañia aanʌ ʌmo istumaasi giñpiooñiga vaidʌ ivueeyi ―astʌtʌdai ʌsandaaru tʌaanʌdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aidʌsi caʌ ʌSuusi imaasi, maitʌʌ istumaasi gʌtʌgituagi daidʌ itʌtʌdai ʌjudidíu ismaacʌdʌ oiditadai: ―Sʌʌlicʌdʌ angʌnaagidi, sai gʌraaduñi saagida maiquiaa nʌidi aanʌ tomali ʌmoco ispocaasi vaavoitudadagi siʌʌsi vaavoitudai idi cʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aanʌ angʌnaagidi sai mui ismaacʌdʌ maitʌrjudidíu aipaco oidacami vaavoituda agai Diuusi ñiooquidʌ. Dai ʌgai iimia agai tʌvaagiamu mʌʌca siaaco gatʌaanʌi Diuusi dai ʌʌmadu daraaja agai Avraañicaru dai Isaacaru, dai Jacocaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dʌmos ʌjudidíu ʌgai ismaacʌdʌ poʌlidi sai iimia agai mʌʌca siaaco gatʌaanʌi Diuusi Avraañicaru cajiudadʌcatai, ʌgai gia maiviaacamu oigaragai isiimiagi. Diuusi ootosa agai ʌgai mʌʌca siaaco tomastuigaco tucamuga dai suaanʌda agai ʌgai dai aliʌ soimaa taataca agai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dai amaasi ʌSuusi itʌtʌdai ʌsandaaru tʌaanʌdamigadʌ: ―Imʌdañi gʌquiiyamu dai pʌstumaasi vaavoitudai poduucai ʌpʌduuñimu ―astʌtʌdai. Dai mospotʌi ʌSuusi tai dueeyi maradʌ ʌsandaaru tʌaanʌdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Taidʌ ʌSuusi ii Piiduru quiidiamu vai ami caatʌcatadai ʌPiiduru tuumudʌ aliʌ oiditadai toiñdagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Taidʌ ʌSuusi mostaata novidʌ tai dagito toiñdagai tai otoma vañi ʌgai dai bibi gʌdadidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dai aidʌsi catuca taidʌ ʌoodami vuaapi ʌSuusi mui oodami ismaacʌdʌ viaacatadai Diaavora tʌtʌaañicarudʌ, taidʌ ʌSuusi mosali ʌmo ñiooquicʌdʌ vuvaitu vʌʌsi ʌDiaavora tʌtʌaañicarudʌ dai duduaadi vʌʌsi ʌcoococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aidʌsi ʌpʌdui imaasi poduucai ʌpʌdui ismaacʌdʌ aagai Isaía Diuusi ñiooquituldiadamigadʌ dai poduucai ooja aagaitai ʌCristo: “Ʌgai gʌrduduaaidamu”, ascaiti Isaía. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aidʌsi tʌʌ ʌSuusi isaliʌ muidu oodami ʌgai sicoli, aagidi ʌgai gʌmamaatʌrdamiga sai daivuñdana vaasadʌrʌ ʌgʌʌ suudagi Galilea. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tai ʌmo mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ miaadʌrʌ cʌquiva daidʌ itʌtʌdai ʌSuusi: ―Mamaatʌtuldiadami aanʌ gʌoidatucuda iñʌlidi tomasiaaco siaaco aimʌrda aapi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Cacaasiocai viaa gʌntʌʌtʌjoga dai ujuurugi viaa gʌncoocosa, dʌmos aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami maivaacʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dai ʌmai ismaacʌdʌ ʌrʌSuusi mamaatʌrdamigadʌcatadai potʌtʌdai ʌgai ʌSuusi: ―Tʌaanʌdami giñdagitoñi nai ʌʌpʌga mʌʌ yaasa aanʌ giñooca dai gooquiʌrʌ gʌoidatucudagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Giñoidañi dai dagito vai ʌgai ismaacʌdʌ ʌrʌpan ducami coidadʌ maitiñʌʌgiditai yaasana gʌncoidadʌga ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Amaasi ʌSuusi tʌsai ʌmo vaarcuʌrʌ ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dai aidʌsi gʌʌ suudagi daama iimʌitadai ʌgai tai aliʌ cavami ʌvʌ vai tai tʌʌsadʌi suudagi dai vaarcu ʌraana vaacʌi. Vaidʌ ʌSuusi coosocatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tʌtai aatʌmʌ mamaatʌrdamigadʌ ʌgai iji dai mʌʌ nʌnʌitu daidʌ itʌtʌdai: ―Tʌaanʌdami cʌʌgacʌrʌ igʌrvuvaida casiatʌ yooga duudupi ―astʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Tuimʌsi duduaadimuca? Aapimʌ maivaavoitudai iñsaanʌ istutuidi isgʌnnuucadacagi ―gʌrtʌtʌdai ʌSuusi. Dai vañi dai dodoligitu ʌʌvʌʌli ʌʌmadu ʌgʌʌ suudagi tai vʌʌsi dodoli vii. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tʌtai aatʌmʌ maitʌʌ isducatai gʌrtʌtʌgituagi daidʌ icaiti: ―¿Istuma cʌʌli idi vai asta ʌʌvʌʌli dai gogʌʌ suudagi ʌʌgidi? ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dai amaasi vaasadʌrʌ dʌgavusai ʌgai ʌgʌʌ suudagi dai aayi Gadara dʌvʌʌriʌrʌ, tai vuvaaja gooca cʌcʌʌli camposantuaiñdʌrʌ ʌgai viaacatadai Diaavora tʌtʌaañicarudʌ dai aliʌ oomaliga tomali oodami maitistutuidiña ismiaanai dʌgavuscʌdagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Amaasi miaadʌrʌ guuquiva ʌgai siaaco cʌaacatadai ʌSuusi dai iiñaquimi daidʌ icaitimi: ―¿Tuipʌsi gʌrʌʌmadu vapacʌi aapi Suusi Diuusi maradʌ maitiquiaa aʌcai istuigaco soimaasi gʌrtaatatulda agai aapi? ―ascaiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dai bai miaanai abiaadʌrʌ ajioopaitadai mui tataisoli, ");
INSERT INTO ntpNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","vaidʌ ʌDiaavora tʌtʌaañicarudʌ daañimi ʌSuusi daidʌ itʌtʌdai: ―Pʌsgʌrvuvaidagi idi cʌcʌʌliaiñdʌrʌ pai gʌrdagito tʌtai vaapaquia aatʌmʌ gotataisoliʌrʌ ―astʌtʌdai ʌDiaavora tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Taidʌ ʌSuusi itʌtʌdai: ―Iimivurai tudu ―astʌtʌdai. Taidʌ ʌDiaavora tʌtʌaañicarudʌ vuvuaaja ʌcʌcʌʌliaiñdʌrʌ dai tataisoliʌrʌ vaapa, taidʌ ʌtataisoli koidam voopoi dai gʌʌ suudarʌ suuli dai vʌʌsi baicoi. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Taidʌ ʌnuucadacami tataisoli voopoi dai duduaadimutugai, dai mʌʌca gaaagidi quiiquiana vʌʌsi istumaasi ʌpʌdui, dai isducatai ʌpʌdui ʌcʌcʌʌlicʌdʌ ismaacʌdʌ viaacatadai ʌDiaavora tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tai vʌʌscatai ʌoidacami iji siaaco daacatadai ʌSuusi, dai tʌʌgacai daañimi sai imʌna ami dʌvʌʌriaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tai amaasi ʌSuusi tʌsai ʌmo vaarcuʌrʌ, dai daivusai vaasadʌrʌ ʌgʌʌ suudagi dai ʌpamu aayi ʌʌgi gʌdʌvʌʌragʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mʌtai uusiʌrʌ vuaapi ʌmo cʌʌli ismaacʌdʌ maitistutuiditadai isoiñʌdagi. Dai aidʌsi tʌʌ ʌSuusi isaliʌ vaavoitudai ʌoodami potʌtʌdai ʌgai ʌcʌʌli coocoadʌ: ―Maiti soigʌʌliada giñaduñi, casiant oigʌli aanʌ vʌʌsi istumaasi soimaascami ismaacʌdʌ ivuaadana aapi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Amaasi ʌʌmoco ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ aduucai gʌntʌtʌgitoitadai: “Idi cʌʌli poʌlidi isʌrDiuusi”, asʌnʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Vaidʌ ʌSuusi maatʌcatadai istumaasi gʌntʌtʌgitoi ʌgai daidʌ itʌtʌdai: ―¿Tuimʌsi mosʌʌ soimaasi gʌntʌtʌgitoi? ");
INSERT INTO ntpNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Aanʌ viaa ʌmo sʌʌlicami dai cascʌdʌ viaa guvucadagai isoigʌldiadagi vʌʌsi soimaascamigadʌ oodami. Dʌmos maisijaiga ispoduucai aagagi tomasioorʌ cascʌdʌ sivi gʌntʌʌgidamu aanʌ issʌʌlicʌdʌ viaa aanʌ guvucadagai isduaaidagi idi cʌʌli ―astʌtʌdai ʌSuusi ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Dai amaasi itʌtʌdai ʌSuusi ʌcʌʌli coocoadʌ: ―Vañigiñi dai bʌi gʌvaacosi dai noragi gʌquiiyamu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Taidʌ ʌcoocoadʌ vañi dai nora gʌquiiyamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aidʌsi tʌʌ ʌoodami imaasi, aliʌ duduaadimu dai siaa duutuli Diuusi, maacacai ʌgai guvucadagai ʌmo cʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Taidʌ ʌSuusi ii abiaadʌrʌ dai giñtʌʌ iñsaanʌ daacatai gavuuyi tumiñsi, dai povai iñtʌtʌdai: ―Mataivo, giñoidañi ―iñtʌtʌdai. Antai aanʌ cʌquiva dai oí. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dai ʌmo imidagai gacuaadatadai ʌSuusi ʌmo quiiyʌrʌ tai mui tumiñsi vuudami dai aa soimaasi ivuaadami dada dai ami meesa vuidʌrʌ daraaja Suusi ʌʌmadu dai aatʌmʌ mamaatʌrdamigadʌ ʌSuusi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dʌmos tʌʌgacai ʌfariseo gʌrtʌcacai aatʌmʌ ʌSuusi mamaatʌrdamigadʌ dai povʌrtʌtʌdai: ―¿Tuisidʌ gacueeyi gʌnmamaatʌtuldiadamiga tumiñsi vuudami dai soimaasi ivuaadami ʌʌmadu? ―gʌrtʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Vaidʌ ʌSuusi caʌ gomaasi daidʌ itʌtʌdai: ―Ʌʌgi coococoidadʌ tʌgito gaduduaaidiadami ʌmaicoococoidadʌ maitʌgito. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Maatʌvurai aapimʌ istʌiya ʌlidi idi ñiooqui Diuusi ñiooquidʌrʌ: “Aanʌ maitipʌlidi isʌoodami giñoidiadagi naana maasi tomali maitipʌlidi aanʌ isʌoodami coodadagi tutuuru tomali sisiivatu aanʌ giñvʌʌtarʌ, baiyoma ipʌlidi aanʌ sai soigʌnʌlidiña oodami aacʌdʌ”. Aanʌ andivia tami oidigi daama vai ʌsoimaasi ivuaadami ʌma duucai gʌntʌtʌgitona dai camaisoimaasi ivuaadana. Ismaacʌdʌ poʌlidi ismaisoimaasi ivueeyi siaadʌrʌ ʌma duucai gʌntʌtʌgitona ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Amaasi ʌmamaatʌrdamigadʌ ʌVuaana miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi dai potʌtʌdai: ―Aatʌmʌ ʌʌmadu ʌfariseo duudatai maitacueeyi. ¿Tuisidʌ aapi gʌmamaatʌrdamiga gacueeyi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aanʌ gia ʌʌmadu aimʌrai giñmamaatʌrdamiga cascʌdʌ gacueeyi goovai, dʌmos siʌʌscadʌ ʌgai ismaacʌdʌ giñvuidʌrʌ vʌʌtʌ giñmuaagi aidʌ gia maitaugimu giñmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","17","Tomali ʌmaadutai maitistutuidi isvaavoitudagi istumaasi gamamaatʌtuldi aanʌ dai apiavaavoitudadagi gʌvaavoidaraga ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aidʌsidʌ ʌSuusi aagaitadai imaasi tai ami divia ʌmo judidíu tʌaanʌdamigadʌ dai gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ daidʌ itʌtʌdai: ―Giñmara ooqui utudama muu dai isaapi imiagi dai daama daasagi gʌnovi ʌpamu duaacan tada ʌgai ―astʌtʌdai ʌjudidíu tʌaanʌdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Taidʌ ʌSuusi cʌquiva dai ii ʌgai ʌʌmadu dai aatʌmʌ mamaatʌrdamigadʌ ʌʌpʌ oí. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Amaasi ʌmo ooqui ismaacʌdʌ cabaivustaama dan gooca uumigi soimaascatadai masaadaigadʌ miaadʌrʌ cʌquiva ʌgai ʌSuusi abaana dai gooquiamadʌrʌ mostaata ugidiana daama vaasaradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Povʌʌliditadai ʌgai: “Tomasi mosʌca daama vaasaradʌ taata aanʌ cascʌdʌ caduaadian tada aanʌ”, asʌʌlidi ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dʌmos ʌSuusi gooquiamaco nʌnʌava daidʌ itʌtʌdai ʌooqui: ―Baigi gʌʌliada giñmara giñvaavoitu aapi cascʌdʌ dueeyi ―astʌtʌdai. Dai aidʌ todian duucai ʌooqui dueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aidʌsi aayi ʌSuusi quiidiʌrʌ ʌtʌaanʌdami tʌʌ ʌgai ʌiivadami cabaigʌnducacatadai dai iivitulda agaitadai aidʌmʌsi yaasa agaitadai ʌali tʌji dai tʌʌ mui oodami vai gʌgʌrʌ suaanʌitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Taidʌ ʌSuusi itʌtʌdai: ―Vuvaaquivurai tabiaadʌrʌ, goali tʌji maitʌrmuuquiadʌ mosacooso goovai ―astʌtʌdai ʌSuusi. Dʌmos ʌoodami mosasʌi pocaititai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aidʌsi cavʌʌsi vuvaja ʌoodami taidʌ ʌSuusi vaa dai bʌi ʌmuuquiadʌ novidʌ tai ʌgai vañi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dai vʌʌsi aipacoga sicoli oidacami maí istumaasi ʌpʌdui. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aidʌsi vuusai ʌSuusi abiaadʌrʌ gooca mainʌnʌaadami oí ʌgai dai iiñaquimi daidʌ icaitimi: ―Aapi Davicaru cajiudadʌ ismaacʌdʌ Diuusi maa ʌmo sʌʌlicami soigi gʌʌlda aatʌmʌcʌdʌ ―tʌtʌdai ʌmainʌnʌaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dai aidʌsidʌ ʌSuusi vaa ʌmo quiiyʌrʌ taidʌ ʌmainʌnʌaicʌdʌ abaana guuquiva taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Vaavoitudaimʌsi aapimʌ iñsaanʌ istutuidi isgʌnduduaaidagi? ―tʌtʌdai. Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Ʌjʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Amaasi ʌSuusi taata ʌgai vuupuidʌ daidʌ itʌtʌdai: ―Povʌduñia agai isducatai vaavoitudai aapimʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tai povʌdui caduduaadicami vii. Amaasi ʌSuusi cʌʌga aagidi daidʌ itʌtʌdai: ―Maitavʌr aagiada aapimʌ tomali ʌmaadutai istumaasi idui aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dai mosutudama vuvacʌcai abiaadʌrʌ tomasioorʌ aagidimi aipacoga istumaasi iduitadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aidʌsi quiaa vuvaquimi ʌcʌcʌʌli tai aa vuaa ʌmo cʌʌli muudugami sai duaaidana ʌSuusi. Ʌgai viaacatadai ʌmo Diaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dai vuvaidacai ʌSuusi ʌDiaavora tʌtʌaañicarudʌ tai bovasdʌrʌ gʌaagacai ñioo ʌcʌʌli. Taidʌ ʌjudidíu maitʌʌ istumaasi gʌntʌtʌgituagi daidʌ icaiti: ―Tomali ʌmo imidagai maitʌnʌidiña ʌmo istumaasi pomaasi vʌʌsi gʌrdʌvʌʌragʌrʌ ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dʌmos ʌfariseo vui ñioocai ʌSuusi daidʌ icaiti: ―Gocʌʌli vuvaidi Diaavora tʌtʌaañicarudʌ guvucadadʌcʌdʌ ʌbaitʌcʌaacamigadʌ ʌDiaavora tʌtʌaañicarudʌ ―caiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Vaidʌ ʌSuusi aimʌraiña vʌʌsi aali quiiquiana dai aipaco ami dʌvʌʌriʌrʌ uugidiana mamaatʌtuldiña ʌgai ʌoodami judidíu quiquiuupaigadʌrʌ. ɅSuusi aagidiña ʌoodami sai Diuusi soicʌda ʌlidi oodami sai cʌʌgacʌrʌ oidacana. Dai duduaaidiña ʌSuusi tomastuma coocodagai viaacagi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tʌʌgacai ʌSuusi mui oodami aliʌ soigʌʌli ʌgaicʌdʌ. Ʌgai aliʌ soigʌʌli vaamioma gatʌaanʌitai ʌromamano dai maitiipu sioorʌ soiñagi vai ʌʌgi gatʌaanʌdagi ʌgai. Ʌgai ʌpan ducami cañiiru maipastutuuruacami, maiviaacatai sioorʌ nuucadacagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Amaasi ʌSuusi povʌrtʌtʌdai aatʌmʌ ismaacʌdʌ ʌrmamaatʌrdamigadʌ: ―Tami oidigi daama oidaga mui oodami ismaacʌdʌ vaavoituda ʌlidi Diuusi ñiooquidʌ, dʌmos maitiipu sioorʌ aagidagi, chiʌʌquidu oodami ismaacʌdʌ gaaagidi Diuusi ñiooquidʌ cascʌdʌ. Vai ismaacʌdʌ caʌca ʌlidi ʌpan ducami gʌʌpi yoovaragai dai yoovadami chiʌʌquidu. ");
INSERT INTO ntpNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cascʌdʌ daanʌdavurai aapimʌ Diuusi ismaacʌdʌ ʌrtʌaanʌdami vai ootosana aa gʌñiñiooquituldiadamiga vai aagidana ʌgai ñiooquidʌ ʌoodami ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Amaasi ʌSuusi gʌrvaí aatʌmʌ baivustaama dan gooca tʌsaidʌ ʌrmamaatʌrdamigadʌcana dai gʌrmaa sʌʌlicami sai vuvaidiña aatʌmʌ Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ dai duduaaididana oodami tomastuma coocodagai viaacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dai potʌʌtʌgidu aatʌmʌ baivustaama dan gooca ʌSuusi ojootosadʌ. Ʌʌpʌgadadʌ ʌrSimuñi mʌsmaacʌdʌ Piiduru aagaiña ʌʌpʌ, dai Aandʌrʌsi Piiduru suculidʌ, dai Jacovo ʌʌmadu Vuaana Sevedeo maamaradʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","dai Piili, dai Bartolomé, dai Tomás, dai aanʌ Mataivo ismaacʌdʌ ʌrvuudamicatadai tumiñsi, dai Jacovo Alfeo maradʌ, dai Leveo mʌsmaacʌdʌ Tadeo aagaiña ʌʌpʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","dai Simuñi ʌgai ʌrʌmoco ismaacʌdʌ vuidʌrʌ caatʌcana ʌromamano, dai Uudasi Iscaliote ismaacʌdʌ gooquiʌrioma gatʌʌgi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Daidʌ ʌSuusi gʌrootoi vʌʌscatai aatʌmʌ tʌsai gaaagidana Diuusi ñiooquidʌ dai povʌrtʌtʌdai ʌgai: ―Maitavʌr iimi siaaco oidaga ʌgai ismaacʌdʌ maitʌrjudidíu, tomali maivapacʌda quiiquidʌrʌ Samaalia dʌvʌʌriʌrʌ oidacami, ");
INSERT INTO ntpNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","baiyomavʌr iimi gʌraaduñi judidíu ʌʌmadu. Ʌjudidíu camaiʌʌgidi Diuusi ñiooquidʌ cascʌdʌ ʌjudidíu ʌrʌpan ducami cañiiru sibʌ iimiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Iimivurai dai aagida sai camiaadimi istuigaco Diuusi soicʌda ʌlidi oodami sai cʌʌgacʌrʌ oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aanʌ gʌnmaa guvucadagai mʌsai duduaaidiña ismaacʌdʌ viaacagi ʌcoocodagai ismaacʌdʌ duvaldi gatuucuga dai ismaacʌdʌ ʌma maasi coocodagai viaacagi ʌʌpʌ dai duduaacaldavurai coidadʌ dai vuvaidavurai Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. Aanʌ gʌnmaa idi guvucadagai dai maitʌntai tumiñsi, cascʌdʌ aapimʌ avʌr maitaanʌda ʌʌpʌ mʌsmaacʌdʌ duduaaidagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dai maitavʌr vuucai tumiñsi, ");
INSERT INTO ntpNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tomali maivuucai gʌnmoraraaliga gaamu voiyamu. Mosali ʌʌmo vaapasaragai avʌr vuucai dai maitavʌr vuucai aa susuusacai tomali giicai. Ʌaata vuaadami viaa sʌʌlicami mʌsbibiaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mʌsiʌʌscadʌ ajiagi aapimʌ ʌmo ali quiiyʌrʌ vʌrai gaaga ʌmo oodami cʌʌ tuigacami ismaacʌdʌ vʌʌsi oodami siaa duutuadagi dai ami quiidiʌrʌ ʌgai avʌr gʌnuuliña asta mʌsiʌʌscadʌ iji aapimʌ abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mʌsiʌʌscadʌ aiya ʌmo quiiyʌrʌ vʌrai aagida ʌoidacami sai Diuusi ipʌlidi isiibʌstudacan taadacagi ʌgai iibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dai isami oidacami caʌca ʌliadagi Diuusi ñiooquidʌ dai sʌʌlicʌdʌ ipʌliadagi isDiuusi soiñagi vai gʌniibʌstacan tadacagi ʌgai aidʌ gia gʌniibʌstacan tadacamu ʌgai. Dai ismaicaʌca ʌliada ʌgai aidʌ gia maitʌniibʌstacan tadacamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dai mʌsiaaco maitʌnmiaadʌgida agadagi dai tomali maitʌncaʌca ʌliadagi vʌrai vuvaaqui abiaadʌrʌ dai gigigida ʌdʌvʌʌrai gʌnʌʌcasuaiñdʌrʌ vai poduucai maatʌna ʌoodami ismaicʌʌga idui. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sʌʌlicʌdʌ angʌnaagidi sai siʌʌscadʌ Diuusi nʌidagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami vaamioma soimaasi taatatuldamu ʌgai ʌoodami ismaacʌdʌ maitʌnmiaadʌgidagi siʌoodami ismaacʌdʌ Sodoomʌrʌ dai Gomoorʌrʌ oidacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Gʌnootosai aanʌ ʌoodami saagida dai ʌʌmoco aliʌ oomaliga dai soimaasi gʌntaatatulda agai poduucai isduucai sʌʌsʌyi soivueeyi cañiiru. Cʌʌga avʌr gʌntʌtʌʌgitoca dai cʌʌga tuutiaca vʌʌscatai vui. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dʌmos aapimʌ gʌaagai mʌsʌjʌʌgi gʌnnuucadacagi, gʌntʌʌgida magai dudunucami dai gʌngʌgʌʌgʌtudamu aapimʌ quiquiuupiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dai asta vaama gʌntutusadamu oodami tʌtʌaanʌdami vuidʌrʌ dai raraí vuidʌrʌ giñvaavoitudaitai aapimʌ, poduucai istutiadamu aapimʌ isgiñaagadagi ʌgai vuitapi dai ʌgai ismaacʌdʌ maitʌrjudidíu vuitapi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Dʌmos mʌsiʌʌscadʌ vaama gʌntutusadagi aapimʌ dudunucamiʌrʌ maitavʌr vuaam ʌnʌliada maimaatʌcatai istʌiyagi. Diuusi Ibʌadʌ gʌnsoicʌdamu vʌrai aagada mʌstumaasi tʌgitocagi amaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dai oodami gatʌtʌgiada agai ʌʌgi gʌnsusuuculi dai gʌnsiisiʌgi dudunucamiʌrʌ mʌsai coodaiña, dai dʌʌdʌdʌ gatʌtʌgiada agai ʌʌgi gʌnmaamara, dai maamaradʌ vuidʌrʌ vʌʌtʌca agai gʌndʌʌdʌ dai gatʌaanʌdamu coodaragai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dai vʌʌsi oidigi daama oidacami gʌncʌʌdada agai giñvaavoitudaitai aapimʌ. Dʌmos sioorʌ apiagiñvaavoitudadagi siʌʌscadʌ uucami oidacagi oidigi daama ʌgai cʌʌgacʌrʌ vuvaaquimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mʌsiʌʌscadʌ soimaasi gʌntaatamituldiadagi ʌmo ali quiiyʌrʌ iimivurai sibʌaacoga ʌmai ali quiiyʌrʌ. Sʌʌlicʌdʌ angʌnaagidi sai maiquiaa naatocai iimia agai aapimʌ vʌʌsi aali quiiquidʌrʌ ʌjudidíu sidivimu aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tomali ʌmo mamaatʌrdami maivaamioma maatʌ siʌmaatʌ gamamaatʌtuldiadami dai tomali ʌmo piooñi maivaamioma gatʌaanʌi siʌʌsi gatʌaanʌi gatʌaanʌdami. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Isoimaasi taatamadagi ʌmamaatʌtuldiadami ʌmamaatʌrdamigadʌ ʌʌpʌ soimaa taatamaiña. Dai issoimaasi taatamadagi gatʌaanʌdamiga ʌpiooñigadʌ soimaasi taatamaiña ʌʌpʌ cascʌdʌ aapimʌ soimaasi taatamadamu ʌʌpʌ ʌpan duucai aanʌ. Ʌoodami Diaavora giñaagaiña dai vaamioma galnaasi ñiooqui gʌnaagiadamu ʌgai aapimʌ giñmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Dʌmos maitavʌr ʌʌbiada ʌoodami ismaacʌdʌ soimaasi gʌnduiñda ʌliadagi. Cʌʌ maatʌ Diuusi vʌʌsi istumaasi iduñia ʌliada ʌgai aapimʌ gʌnvui dai Diuusi maasiuldamu vʌʌsi gomaasi siʌʌscadʌ nʌidagi ʌgai ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Vʌʌsi ismaacʌdʌ gʌnaagidi aanʌ ʌʌgi daraajatai aatʌmʌ aagidavurai aapimʌ ʌoodami vʌʌsi aipacoga oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Maitavʌr ʌʌbiada ʌgai ismaacʌdʌ mumueeyi gatuucuga dʌmos maitistutuidi ismuaagi gaibʌdaga. Baiyomavʌr ʌʌbiada Diuusi ismaacʌdʌ istutuidi isootosagi gaibʌdaga ʌʌmadu gatuucuga mʌʌca siaaco oidaga ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Cʌʌ maatʌ aapimʌ isgʌgaagarai gooca ujuurugi ʌmo sintaavucʌdʌ dʌmos Diuusi vʌʌscʌrʌ nuucadacana. Ʌoodami maitistutuidi ismuaagi tomali ʌmo urugi maimaacacai oigaragai Diuusi. Dai Diuusi vaamioma gʌnnuucada aapimʌ siʌ ujuurugi cascʌdʌ maitavʌr duduaadicuda Diuusi gʌnnuucadaca agai. Diuusi maatʌ vʌʌscatai asta siʌʌjʌquidu ʌʌmadutai cuucupadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Vʌʌscatai ismaacʌdʌ gʌnmaasiuldagi oodami vuitapi isgiñvaavoitudai aanʌ ʌʌpʌ aagamu giñooga vuitapi ismaacʌdʌ tʌvaagiʌrʌ daja isʌgai ʌrgiñmaamara. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dai ismaacʌdʌ giñʌstocadagi oodami vuitapi aanʌ aagamu Diuusi gʌrooga vuitapi ismaacʌdʌ tʌvaagiʌrʌ daja sai ʌgai maitʌrgiñmaamara. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Maitavʌr povʌnʌliada aapimʌ ansai aanʌ divia sai siooma oidacana vʌʌsi oodami maitavʌr vaavoi baiyoma divia aanʌ vai oidacana cocodi. Ismaacʌdʌ maitiñvaavoitudai cocoadamu ʌgai ismaacʌdʌ giñvaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Isʌmo cʌʌli giñvaavoitudagi maradʌ vuidʌrʌ caatʌcamu. Dai isʌmo ooqui giñvaavoitudagi ooqui maradʌ vuidʌrʌ caatʌcamu. Dai isʌmo ooqui giñvaavoitudagi caasdʌʌdʌ vuidʌrʌ caatʌcamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dai poduucai aipaco gʌnvupui vʌʌtʌcamu ʌoodami ʌʌgi gʌnaadunumʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tomasioorʌ sioorʌ maitiñvaavoituda ʌliadagi baamucai dʌʌdʌ maimaaquimu aanʌ oigaragai isʌrgiñmamaatʌrdamicagi dai tomasioorʌ sioorʌ maitiñvaavoituda ʌliadagi baacoicai maamaradʌ maitipʌliditai isgiñvaavoitudagi oogadʌ maimaaquimu aanʌ oigaragai isʌrgiñmamaatʌrdamicagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dai sioorʌ maibaigʌducagi isoimaa taatagi dai asta muquiagi ʌmo curusiaba giñvaavoitudaitai maimaaquimu aanʌ oigaragai isʌgai ʌrgiñmamaatʌrdamicagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dai sioorʌ giñvaavoitudadagi vai cascʌdʌ ʌoodami muaagi ʌgai Diuusi ʌʌmadu oidacamu tomastuigaco dʌmos sioorʌ duaadicudagi mʌsmuaagi dai cascʌdʌ pocaitiadagi sai maitiñvaavoitudai ʌgai gia maiimimu Diuusi ʌʌmadu tʌvaagiamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Dai sioorʌ ʌʌgiditai gʌncaʌcagi aapimʌ ʌgai ʌʌgiditai giñcaʌ aanʌ ʌʌpʌ dai sioorʌ ʌʌgiditai giñcaʌ aanʌ ʌgai ʌʌgiditai caʌ gʌrooga ismaacʌdʌ giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dai sioorʌ ʌʌgiditai caʌ ʌmo Diuusi ñiooquituldiadamigadʌ Diuusi ootosadʌcatai ʌgai, ʌgai ismaacʌdʌ ʌʌgiditai caʌ Diuusi maaquimu ʌmo istumaasi ʌpan duucai gʌñiooquituldiadamiga. Dai sioorʌ ʌʌgiditai caʌ ʌmoco ismaacʌdʌ siaa duutudai Diuusi, siaa duutudaitai ʌgai Diuusi, Diuusi maaquimu ʌmo istumaasi cʌʌgaducami poduucai isduucai maa ʌgai ismaacʌdʌ siaa duutudai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dai tomasioorʌ sioorʌ baigʌʌliaracʌdʌ vasidagi ʌmo avʌsi suudagi ʌmoco ismaacʌdʌ giñvaavoitudai, giñʌʌgiditai caʌ ʌgai sʌʌlicʌdʌ Diuusi maaquimu ʌgai ʌmo istumaasi cʌʌgaducami, tomasi mosvasidagi ʌmo avʌsi suudagi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dai aidʌsi naatocai gʌrmaamatʌtuli ʌSuusi aatʌmʌ mamatʌrdamigadʌ iji abiaadʌrʌ dai aagida ragai Diuusi ñiooquidʌ vʌʌsi aipaco sicoli oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ɅVuaana ismaacʌdʌ vapaconaitadai ʌoodami ʌgʌʌ aqui Jordáñiʌrʌ maisacariʌrʌ daacatadai dai maí vʌʌsi istumaasi ivuaadatadai ʌSuusi. Amaasi ootoi gooca gʌmamaatʌrdamiga siaaco daacatadai ʌSuusi ");
INSERT INTO ntpNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","sai tʌcacana sabai ʌgai sʌʌlicʌdʌ ʌrʌCristo ismaacʌdʌ viaacatadai isdiviagi sabai gʌaagai isnʌnʌracagi ʌmai. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Mʌʌcavʌr aagida ʌVuaana vʌʌsi mʌstuma nʌidi dai caʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dai aagidavurai isducatai ismaacʌdʌ mainʌnʌaitadai casi istutuidi isnʌaadagi dai ismaacʌdʌ maiajioopaitadai caajioopai, dai ismaacʌdʌ viaacatadai gocoocodagai ismaacʌdʌ duvaldi gatuucuga duduaadʌi, dai ismaacʌdʌ maitʌtʌcaidacatadai catʌtʌcaidaga, dai coidadʌ duduaacarʌi dai soituutuigami vʌʌsi gʌmamaatʌtuldi isducatai cʌʌgacʌrʌ gʌvuvacʌi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Baigʌʌliadamu sioorʌ apiagiñvaavoitudadagi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dai aidʌsi caiji ʌgai ismaacʌdʌ ootoi ʌVuaana taidʌ ʌSuusi gʌaagacai aagidi ʌoodami aagaitai ʌVuaana dai potʌtʌdai ʌgai ʌoodami: ―Aapimʌ iji mʌʌ oidigana siaaco daacatadai ʌVuaana. Aapimʌ maatʌcatadai sai ʌgai maitʌrʌmoco ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aapimʌ iji mʌʌca siaaco daacatadai ʌVuaana. Aapimʌ maatʌcatadai sai ʌgai maitʌrʌmoco ismaacʌdʌ cʌʌga dadapacami yuucustai. Aapimʌ cʌʌga maatʌ sai ismaacʌdʌ cʌʌga dadapacami yuucustai cʌcʌʌgaducami quiiquiʌrʌ oidaga gʌgʌr raí baabaquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aapimʌ iji mʌʌ oidigana nʌida ʌliditai ʌmo Diuusi ñiooquituldiadamigadʌ dai sʌʌlicʌdʌ angʌnaagidi sai Vuaana aa duiñdadʌ vaamioma namʌga siʌ aa duiñdadʌ vʌʌsi ʌgaa Diuusi ñiñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Diuusi ñiooquidʌrʌ pocaiti aagaitai ʌVuaana: Ootosamu aanʌ ʌmo ootosicami aapi Cristo gʌbaitʌqui vai ʌgai aagidana ʌoodami sai divia agai aapi daidʌ ʌoodami ʌma duucai gʌntʌtʌgitomu dai camaisoimaasi ivuaadamu. Ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sʌʌlicʌdʌ angʌnaagidi sai vʌʌsi oodami saagidaiñdʌrʌ ʌVuaana ismaacʌdʌ vapaconaitadai ʌoodami viaa goaa duiñdagai ismaacʌdʌ vaamioma namʌga sitomasmaascʌdʌ oodami aa duiñdadʌ, dʌmos vaamioma baigʌnʌlidi ʌgai ismaacʌdʌ giñnʌidi dai giñvaavoitudai siʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aidʌsi divia ʌVuaana ismaacʌdʌ vapacoi ʌoodami abiaadʌrʌ ʌoodami gʌnaajagʌi vaavoituda ʌliditai gocʌʌgaducʌdʌ ñiooqui isducatai Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aidʌsi maiquia divia ʌVuaana Moseesacaru ʌʌmadu ʌgaa Diuusi ñiñiooquituldiadamigadʌ aagidi gʌrʌʌqui aaduñicaru dai ooja liivruʌrʌ isducatai Diuusi divia agaitadai dai gatʌaanʌda agaitadai tami oidigi daama ʌmo imidagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dai isaapimʌ vaavoitudagi istumaasi gʌnaagidi aanʌ aidʌ gia maatʌmu aapimʌ isʌrvaavoi isʌVuaana ʌʌpʌga divia iñsaanʌ dai gaaagidimi ansai aanʌ gooquiʌrioma divia iñagaitadai. Ʌgai idui ʌaa duiñdagai ismaacʌdʌ Diuusi ñiñiooquituldiadamigadʌ aagidi ʌʌquioma Eliiasicaru isiduñia agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cʌʌgavʌr gʌntʌgito caʌca aapimʌ istumaasi gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sivi gʌnaagidamu aanʌ istumaasi ʌpan ducami ʌoodami sividadʌ. Ʌgai ʌpan ducami ʌaali ismaacʌdʌ plaasʌrʌ gatʌtʌvʌiña dai iiñoquidiña gʌaaduñi daidʌ itʌtʌdaiña: ");
INSERT INTO ntpNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Iiva aatʌmʌ muusicocʌdʌ mʌtai maitatuutudai. Susuañi aatʌmʌ mʌtai aapimʌ maisoigʌnʌʌli”, astʌtʌdaiña. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Diviacai Vuaana ʌgai ismaacʌdʌ vapaconai ʌoodami dai ʌgai aliʌ duudatai gayunanduiña dai tomali ʌmo imidagai maitayʌʌdana istumaasi navamudaga. Mai aapimʌ pocaitiña sai ʌgai viaa ʌmo Diaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dai diviacai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami dai maiduudatai gayunandui dai gayiʌʌyi mai pocaiti aapimʌ giñparunaitai ansaidʌ ʌrtuu naacʌdami dai iitʌracami tomasi tomali ʌmo imidagai mainavamucurui aanʌ, dai ansaidʌ ʌraduuñdʌ tumiñsi vuudami dai aa soimaasi ivuaadami. Vʌʌscʌrʌ maimaatʌ nʌidi aapimʌ isducatai Diuusi gʌrsoi Vuaana ʌʌmadu aanʌ sai maatʌna aatʌmʌ istumaasi gʌaagai tʌsiduñiagi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Amaasi ʌSuusi gʌaagacai aagidi ʌoodami siʌʌ soimaasi ivuaadana Corasiiñiʌrʌ oidacami dai Betasaidʌrʌ oidacami dai siʌʌ soimaa taata agai ʌgai. Ʌsuusi ivuaadana mui naana maasi gʌgʌrducami Corasiiñiʌrʌ dai Betasaidʌrʌ tai vʌʌscʌrʌ maiʌma duucai gʌntʌtʌgito dai apiasoimaasi ivueeyi ami oidacami cascʌdʌ ʌSuusi bagaimi daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Soogigi aapimʌ Corasiiñiʌrʌ oidacami dai Betasaidʌrʌ oidacami siʌʌ soimaa taatamu aapimʌ. Ʌoodami ismaacʌdʌ Tiiroʌrʌ dai Sidooniʌrʌ oidacatadai maitʌrjudidíu dai maivaavoitudai Diuusi. Istʌʌgimudai ʌgai istumaasi gʌgʌrducami mʌsmaasi tʌʌ aapimʌ ʌgai gia ʌma duucai gʌntʌtʌgitomudai dai camaisoimaasi ivuaadamudai dai gʌnaadamudai yuucusi tutuucucami dai gʌncocomaivadamudai mataicʌdʌ dai poduucai tʌʌgidamudai aa oodami iscaʌma duucai gʌntʌtʌgito dai camaisoimassi ivuaada agai. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dʌmos siʌʌscadʌ Diuusi nʌidagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami vaamioma soimaasi gʌntaatatuldamu ʌgai aapimʌ siʌTiiroʌrʌ dai Sidooniʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dai aapimʌ judidíu Capernauumʌrʌ oidacami povai ʌnʌlidi mʌsai iimia agai Diuusi ʌʌmadu baiyoma mʌiimia agai Diaavora ʌʌmadu. Ʌoodami ismaacʌdʌ Sodoomʌrʌ oidaga maitʌrjudidíu dai maivaavoitudai Diuusi dʌmos isʌgai tʌʌgimudai istumaasi gʌgʌrducami mʌsmaasi tʌʌ aapimʌ aidʌ gia Diuusi maiugititudamudai Sodoomʌrʌ oidacami quiaa oidacamudai oodami Sodoomʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dʌmos siʌʌscadʌ Diuusi nʌidagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami vaamioma soimaasi gʌntaatatuldamu ʌgai aapimʌ siʌSodoomʌrʌ oidacami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Amaasi ʌSuusi potʌtʌdai Diuusi gʌooga: ―Giñooca aanʌ gia sʌʌlicʌdʌ siaa gʌduutudai aapi apʌrbaitʌcʌaacami tʌvaagiʌrʌ dai oidigi daama. Aapi apʌtmaimaatʌtuli idi maasi ismaacʌdʌ poʌlidi isʌrsastudugami, aapi maatʌtuli mosʌca ʌgai ismaacʌdʌ maatia ʌlidi gʌmamaatʌtuldaraga. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Cʌʌgaduava giñooca poduucai ipʌli aapi dai poduucai idui ―tʌtʌdai ʌSuusi gʌooga. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dai apiamamaatʌtuldi ʌSuusi ʌoodami dai potʌtʌdai: ―Giñooca giñmaa vʌʌsiaʌcatai. Aanʌ ʌrDiuusi maradʌ dai tomali ʌmaadutai maicʌʌga giñmaatʌ mosʌca giñooca dai tomali ʌmaadutai maicʌʌga maatʌ giñooca mosʌca aanʌ ismaacʌdʌ ʌrmaradʌ ʌgai. Dai vʌʌscʌrʌ oidaga aa ismaacʌdʌ maatʌ giñooca mosʌca ʌgai ismaacʌdʌ aanʌ ipʌlidi sai maatʌna. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","29","Vʌʌscatai aapimʌ ismaacʌdʌ caoojogi ʌʌgiditai mamaatʌtuldaragadʌ ismaacʌdʌ gamamaatʌtuldi quiquiuupiʌrʌ, aapimʌ maitʌniibʌstacan tadaga gʌniibʌdaga gomaasicʌdʌ, giñvaavoitudavurai dai giñdagito nai aanʌ gʌnmamaatʌtuldiadagi dai ʌʌgiadavurai istumaasi gʌnmamaatʌtuldiada aanʌ. Aanʌ maioojodai giñmamaatʌrdamiga dai maigʌʌducʌdʌ giñʌlidi aanʌ dai gʌniibʌstacan taadacamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maisijaiga isʌʌgiada aapimʌ giñmamaatʌtuldaraga ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ʌmo imidagai ibʌstaragai tasʌrʌ ʌsicami saagida imʌitadai ʌSuusi tʌtai aatʌmʌ mamaatʌrdamigadʌ vaiñcumaimi tʌligi muuradʌ dai gʌrnoonovicʌdʌ cʌlivaimi aatʌmʌ dai cuumimi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Vai ʌʌmoco ʌfariseo tʌʌgacai gomaasi potʌtʌdai ʌgai ʌSuusi: ―Dañi gʌmamaatʌrdamiga ivueeyi aa duiñdagai ismaacʌdʌ maitiipu oigaragai isivuaadagi ibʌstaragai tasʌrʌ ―tʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dʌmos ʌSuusi potʌtʌdai: ―Canʌidi aapimʌ ʌoojai siaaco aagai ismaasi idui Davicaru ʌmo imidagai aidʌsi ʌgai ʌʌmadu aaduñdʌ biuugicoi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Vaa ʌgai ʌquiiyʌrʌ siaaco siaa duutudaiña gʌrʌʌqui aaduñicaru Diuusi dai uu ʌpaana daasdaradʌ Diuusi ismaacʌdʌ ʌʌgi papaali viaacatadai oigaragai iscuaadagi ʌʌgi poduucai viituli Moseesacaru cascʌdʌ. Tai vʌʌscʌrʌ vui Davicaru dai uu dai gomaasi maitʌrsoimaascami. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Siʌpʌ canʌidi aapimʌ oojai siaaco oojisi Moseesacaru sʌʌlicamigadʌ saidʌ ʌpapaali ʌgʌʌ quiuupaigadʌrʌ judidíu aata vuaadana ibʌstaragai tasʌrʌ dai gomaasi maitʌrsoimaascami. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Dʌmos aanʌ angʌnaagidi sai aanʌ cadivia dai vaamioma gʌaagai aanʌ siʌdudunucami ʌgʌʌ quiuupiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aapimʌ maimaatʌ caʌ istʌiya ʌlidi idi ñiooqui Diuusi ñiooquidʌrʌ ismaacʌdʌ pocaiti: “Aanʌ ipʌlidi isaapimʌ soigʌnʌliadagi aacʌdʌ maisiu mosʌcaasi giñdadaadiadagi naana maasi istumaasi dai coodadagi tutuuru dai sisiivatu dai giñdadasdiadagi”, ascaiti Diuusi. Ismaatʌ caʌcamudai aapimʌ gomaasi aidʌ gia maigʌʌpiʌrʌ vuupadamudai giñmamaatʌrdamiga. Goovai maitivueeyi tomali ʌmo istumaasi soimaascami. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aanʌ viaa ʌmo sʌʌlicaami cascʌdʌ viaa aanʌ sʌʌlicami isaagagi istumaasi ʌpʌduñiagi ibʌstaragai tasʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Amaasi ii ʌSuusi abiaadʌrʌ dai vaa ʌgʌʌ quiuupaigadʌrʌ judidíu. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Vai ami cʌaacatadai ʌmo cʌʌli ismaacʌdʌ gaquisapicatadai ʌmo novidʌ, vaidʌ ʌfariseo gaagaitadai istuucʌdʌ gʌʌpiʌrʌ vuaajagi ʌSuusi dai tʌcacai dai potʌtʌdai: ―¿Oidagasi oigaragai isduaaidagi ʌmo coocoadʌ ibʌstaragai tasʌrʌ cho sio?― tʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Taidʌ ʌSuusi aa noragi dai potʌtʌdai: ―¿Maacʌdʌ aapimʌ maiotoma vañigidana gʌnsoiga cañiiru issibʌcai dʌʌcarʌ gʌsiagi ʌgai tomasi ʌribʌstaragai tasʌrʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dai ʌmo oodami vaamioma namʌga isʌmo cañiiru. Poduucai tudu oidaga oigaragai isivuaadagi ʌmo istumaasi cʌʌgaducami ibʌstaragai tasʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Amaasi potʌtʌdai ʌSuusi ʌcʌʌli: ―Giñuuliñdañi gʌnovi ―ʌtʌdai. Dai mosuuliñi ʌgai gʌnovi tai cacʌʌga duaadicami vii ʌpan duucai ʌgʌmai novidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amaasi vuvaaja ʌfariseo abiaadʌrʌ daidʌ icaiti: ―Isducatai iduuñimu aatʌmʌ dai muaamu goSuusi ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dai aidʌsi maí ʌSuusi gomaasi, ii abiaadʌrʌ tai mui oodami oí. Taidʌ ʌSuusi duduaadi vʌʌsi ʌcoococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dai aagidi ʌgai ʌoodami sai maiaagaiña sioorʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aidʌsi ʌpʌdui gomaasi aidʌ ʌpʌdui ismaacʌdʌ ooja Isaía sai pocaiti Diuusi: ");
INSERT INTO ntpNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Idi ʌrgiñpiooñiga ismaacʌdʌ ʌco vuusaitu aanʌ. Dai aliʌ oigʌdai aanʌ goovai dai baigiñʌlidi goocʌdʌ. GiñIbʌdaga imia agai goovai ʌʌmadu. Dai goovai aagida agai ʌoodami ismaacʌdʌ maitʌrjudidíu sai Diuusi oigʌldi ʌsoimaasi ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dai goovai maicocoaada agai oodami dai maiiiñacada agai caayana. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dai duduaaidiada agai ʌcoococoidadʌ dai cʌʌgacʌrʌ vuvaida agai ʌsoimaasi ivuaadami. Dai ʌmo imidagai goovai taiyʌrʌ daituda agai ʌDiaavora siaaco tomastuigaco mʌʌcana. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dai ʌgai ismaacʌdʌ maitʌrjudidíu vaavoituda agai istumaasi aagai giñpiooñiga dai poduucai tomastuigaco Diuusi ʌʌmadu daraaja agai. Ascaiti Diuusi, asduu ooja Isaía. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Amaasi mʌtai vaidacai ʌmo cʌʌli mainʌaadami dai muudugami mʌʌca siaaco daacatadai ʌSuusi. Ʌcʌʌli viaacatadai ʌmo Diaavora tʌaañicarudʌ taidʌ ʌSuusi duaadi ʌmuudu tai ʌgai istui isñiooquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Taidʌ ʌoodami maitʌʌ isducatai gʌntʌtʌʌgituagi tʌʌgacai gomaasi, daidʌ icaiti: ―Davicaru cajiudadʌ lienʌ goovai ismaacʌdʌ catʌvʌpi ʌpʌdui isnʌnʌra aatʌmʌ, ismaacʌdʌ Diuusi daasa agai saidʌ ʌrraícana ʌpan duucai gʌraduuñi Davicaru ʌrraícatadai ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dʌmos aidʌsi ʌfariseo caʌ gomaasi pocaiti: ―Idi cʌʌli vuvaidi Diaavora tʌtʌaañicarudʌ Diaavora guvucadadʌcʌdʌ ―ascaiti ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dʌmos ʌSuusi maatʌcatadai istumaasi gʌntʌtʌgitoitadai ʌgai dai potʌtʌdai: ―Isʌdudunucami mosaipaco gʌncocoadagi camaitistutuidi isapiagatʌaanʌdagi, isaipaco gʌncocoadagi ʌmapʌcʌrʌ oidacami ugitimu ʌoodami dai baabaquidʌ suuligimu. Dai isaipaco gʌncocoadagi ʌmo adunumʌ vʌʌsi ugitimu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Poduucai ʌʌpʌ isʌDiaavora ʌʌgi vuvaidagi Diaavora tʌtʌaañicarudʌ poduucai isduucai icaiti aapimʌ ʌgai poduucai ʌʌgi gʌcocodagi otoma camaitatʌaanʌdan tada ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aapimʌ pocaiti ansai aanʌ vuvaidi Diaavora tʌtʌaañicarudʌ Diaavora guvucadadʌcʌdʌ. Siʌrvaavoicamudai isDiaavora guvucadadʌcʌdʌ vuvaidi aanʌ Diaavora tʌtʌaañicarudʌ aidʌ gia aapimʌ gʌnaaduñi vuvaidi Diaavora tʌtʌaañicarudʌ Diaavora guvucadadʌcʌdʌ ʌʌpʌ. Ʌʌgi ʌgai gʌnaagidamu ismaitʌrvaavoi isDiaavora guvucadadʌcʌdʌ vuvaidi Diaavora tʌtʌaañicarudʌ aanʌ ʌʌmadu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Baiyoma Diuusi Ibʌadʌ guvucadadʌcʌdʌ vuvaidi aanʌ Diaavora tʌtʌaañicarudʌ dai poduucai cʌʌ maatʌ aapimʌ iscaaayi istuigaco Diuusi soicʌda agai oodami sai cʌʌgacʌrʌ oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Suusi Cristo vaamioma viaa guvucadagai isʌDiaavora cascʌdʌ istui isvuvaidagi Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sioorʌ maitiñvaavoitudadagi ʌgai giñvuidʌrʌ vʌʌtʌ, sioorʌ maitiñsoiña aagiadagi ʌoodami isducatai cʌʌgacʌrʌ vuvaquia ʌgai, ʌgai sobicʌi sai maivaavoitudana dai maicʌʌgacʌrʌ vuvacʌna. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Cascʌdʌ aanʌ angʌnaagidi sai vʌʌsi istumaasi soimaascami ismaacʌdʌ ivueeyi ʌoodami gʌoigʌldi dai vʌʌsi istumaasi galnaasi ismaacʌdʌ aagadagi oodami gʌoigʌldi dʌmos sioorʌ soimaasi ñiooqui aagadagi Diuusi Ibʌadʌ vui ʌgai gia maiviaa gʌoigʌldaraga. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dai tomasioorʌ ismaacʌdʌ giñvui ñioocadagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ʌgai gʌoigʌldi dʌmos sioorʌ soimaasi ñiooqui aagadagi Diuusi Ibʌadʌ vui ʌgai gia maiviaa gʌoigʌldaraga tomali ʌmo imidagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ispoʌlidi aapimʌ ansai aanʌ ivueeyi Diaavora aa duiñdadʌ mosavʌr gʌntʌgito nʌijada aapimʌ istumaasi ivueeyi aanʌ dai poduucai maatʌmu aapimʌ sai istumaasi ivueeyi aanʌ ʌrDiuusi aa duiñdadʌ maisiu ʌDiaavora aa duiñdadʌ. Poduucai isduucai ʌmo uusi cʌʌgaducami cʌʌgaducami iibiatai dai ʌmo uusi maicʌʌgaducami maicʌʌgaducami iibiatai. Vʌʌsi uusi cʌʌga gʌmaatʌ iibiadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aapimʌ ivuaadana naana maasi soimaascami. Siaadʌrʌ istuidʌna aapimʌ isaagagi ʌmo istumaasi cʌʌgaducami soimaasi ivuaadatai. Vʌʌsi ismaacʌdʌ aagai ʌmo oodami ibʌadʌaiñdʌrʌ vusacʌi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ʌmo cʌʌli cʌʌ tuigacami viaa naana maasi cʌcʌʌgaducami gʌibʌdagʌrʌ cascʌdʌ aagai naana maasi cʌcʌʌgaducami. Dai ʌmo cʌʌli maicʌʌ tuigacami viaa naana maasi soimamaascami gʌibʌdagʌrʌ cascʌdʌ aagaiña ʌgai naana maasi soimamaascami. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Dai aanʌ angʌnaagidi sai siʌʌscadʌ Diuusi nʌidagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami ʌgai soimaa taatatuldamu vʌʌscatai ismaacʌdʌ galnaasi ñioocai, dai Diuusi maisoimaa taatatuldamu ismaacʌdʌ cʌʌga ñioocai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Amaasi ʌʌmoco ʌfariseo ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ potʌtʌdai ʌgai ʌSuusi: ―Mamaatʌtuldiadami nʌida ʌrʌlidi aatʌmʌ siduñia aapi ʌmo istumaasi gʌducami ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌoodami maicʌʌga tuutiacami giñaagidi ansaidʌ iduuna ʌmo istumaasi gʌducami ʌgai vuitapi dʌmos maitʌʌgimu ʌgai ʌmai istumaasi gʌducami mosʌca ʌistumaasi gʌducʌdʌ ismaacʌdʌ idui Diuusi ootosacai Joonasi gaamu Ñiñiviamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dai poduucai isduucai Joonasi ʌraana daacatadai ʌvatopa gʌducʌdʌ vaica tasai dai vaica tucagi poduucai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami yaasapicamu vaica tasai dai vaica tucagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dai siʌʌscadʌ caaiyagi istuigaco Diuusi nʌida agadagi oodami sividadʌ ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami amaasi aagamu Diuusi sai ismaacʌdʌ Ñiñiviʌrʌ oidacatadai ʌʌqui maitʌrgʌpiʌrʌ vʌʌtʌcami dʌmos aapimʌ gia sʌʌlicʌdʌ gʌpiʌrʌ vʌʌtʌ, ʌÑiñiviʌrʌ oidacami ʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada agai aidʌsi Joonasi aagidi Diuusi ñiooquidʌ cascʌdʌ. Dai tami daja aanʌ sivi dai vaamioma ʌrtʌaanʌdami aanʌ siJoonasi dai aapimʌ maitiñʌʌgiditai caʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dai siʌʌscadʌ caaiyagi istuigaco Diuusi nʌida agadagi oodami sividadʌ ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami amaasi aagamu Diuusi isʌooqui ʌʌquidʌ ismaacʌdʌ ʌrbaitʌcʌaacamicatadai mʌʌ Siipʌrʌ cʌʌga gʌtʌgito ʌgai mʌʌcasdʌrʌ divia dai caʌca agai istumaasi aagai ʌSalomoñi ismaacʌdʌ ʌrʌmo tʌaanʌdami saitudugami. Dai tami daja aanʌ sivi dai vaamioma ʌrtʌaanʌdami aanʌ siʌSalomoñi mai aapimʌ maitiñʌʌgiditai caʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","Ʌoodami sividadʌ soimaasi ivuaadami ʌrʌpan ducami ʌmo cʌʌli ismaacʌdʌ ibʌadʌrʌ daja ʌmo Diaavora tʌaañicarudʌ. Siʌʌscadʌ ʌDiaavora tʌaañicarudʌ vuusiagi ʌcʌʌliaiñdʌrʌ oidigana aimʌraiña dai gaagaiña siaaco gʌibʌstagi dai siʌʌscadʌ maitʌʌgia ʌgai siaaco povʌ ʌʌlidiña: “Ʌpamu animiagi giñquiiyamu iñsiaadʌrʌ vuusai”, asʌʌlidiña. Dai siʌʌscadʌ ʌpamu ami divia ʌgai dai tʌtʌʌgaiña ʌcʌʌli ʌpan duucai ʌmo quii siaaco maitiipu oidacami dai cʌʌga voisiquicami dai cʌʌga baiduñisicami. Dai amaasi ʌgai aimʌraiña dai vuaapaiña ʌʌpʌ cuvaracami Diaavora tʌtʌaañicarudʌ, ismaacʌdʌ ʌrvaamioma soimaascami siʌgai. Dai ʌgai ʌʌmadu vʌʌsi ʌgaa vapacʌiña ami cʌʌliʌrʌ dai ami oidacana dai poduucai vaamioma soigʌ vuaadana ʌgai isvaasʌquioma. Poduucai ʌpʌduuñimu ʌʌpʌ idi oodamicʌdʌ sividadʌ soimaasi ivuaadami, ʌgai maitiñʌʌgiditai caʌ cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Daidʌ ʌSuusi quiaa ñiooquiditadai ʌoodami aidʌsi ami dada ʌSuusi dʌʌdʌ ʌʌmadu susuuculidʌ. Dʌmos quiidigana guucacatadai ʌgai dai nʌida ʌliditadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tai ʌmoco aagidi ʌSuusi dai potʌtʌdai: ―Gʌdaada ʌʌmadu gʌsusuuculi quiidigaiñdʌrʌ guuca dai gʌaatagida ʌlidi ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Taidʌ ʌSuusi aa noragi dai potʌtʌdai: ―Vʌʌscatai cʌʌgacʌrʌ vuvacʌi giñvaavoitudaitai tomasi ʌrgiñdaada dai giñsusuuculi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Amaasi gʌrvui nʌnʌava ʌSuusi aatʌmʌ mamaatʌrdamigadʌ daidʌ itʌtʌdai ʌoodami: ―Idi ʌʌpʌ ʌrgiñaaduñi. ");
INSERT INTO ntpNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tomasioorʌ sioorʌ ivuaadagi istumaasi ipʌlidi gʌrooga ismaacʌdʌ tʌvaagiʌrʌ daja ʌgai ʌʌpʌ ʌrgiñaaduñi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ʌgai vaa tasʌrʌ ii ʌgai ami quiiyaiñdʌrʌ dai mʌʌ gʌʌ suudagi ugidiana daiva. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tai mui oodami gʌnʌmpagi ami siaaco daacatadai ʌSuusi. Taidʌ ʌSuusi ʌmo vaarcu ʌraana vaa dai ami daiva. Tai vʌʌsi ʌoodami anaasi gʌʌ suudagi ugidiana vii. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tai naana maasi istumaasi mamaatʌtuli ʌSuusi cuentocʌdʌ dai potʌtʌdai: ―Ʌmo ʌsadami gaʌsimu ");
INSERT INTO ntpNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","dai gaʌsaimi ʌgai tai chiʌʌqui tʌligi voiyʌrʌ suuli tai dada ujuurugi dai uu. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tai aa tʌligi ojoodai saagida suuli siaaco maitiipucatadai gʌʌpi dʌvʌʌrai. Tai otoma vuvaja ʌtʌligi maituucavi dʌvʌʌracatadai ʌdʌvʌʌrai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tai mosvuusai tasai tai gaquisa maitatacatadai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aa tʌligi vasoi saagida suuli taidʌ ʌvasoi maidagito isgʌʌliagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tai aa tʌligi cʌʌgaducami dʌvʌʌriʌrʌ suuli dai gʌʌ dai cʌʌga iibaji asta ʌmo siento litro vuvaja ali ʌmo litroaiñdʌrʌ. Dai aa vaicobai litro vuvaja ʌmo litroaiñdʌrʌ. Dai aa asta ʌmo coobai dan baivustaama litro vuvaja ʌmo litroaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cʌʌgavʌr gʌntʌgito caʌca aapimʌ istumaasi gʌnaagidi aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Amaasi aatʌmʌ mamaatʌrdamigadʌ ʌSuusi miaadʌrʌ guuquiva dai tʌcacai daidʌ itʌtʌdai: ―¿Tuipʌsi ñiooquidi gooodami cuentocʌdʌ? ―tʌtʌdai aatʌmʌ mamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tai ʌgai gʌraa noragi dai povʌrtʌtʌdai: ―Diuusi gʌnmaatʌtuldamu aapimʌ mʌstumaasi maimaatʌ isducatai ipʌlidi Diuusi issoicʌdagi oodami sai cʌʌgacʌrʌ oidacana dʌmos gogaa maiviaa oigaragai ismatiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sioorʌ bʌʌjʌi giññiooqui dai giñʌʌgidi ʌgai vaamioma maatʌtuldamu aanʌ, dai sioorʌ maibʌʌjʌi giññiooqui dai maitiñʌʌgidi tomasi palʌʌpi maatʌ ʌgai aanʌ vʌʌscʌrʌ maitʌgitoldamu istumaasi maatʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cascʌdʌ gʌnñiooquidi aanʌ cuentocʌdʌ. Ʌgai canʌidiña istumaasi ivuaadana aanʌ dai maitipʌlidi isgiñvaavoitudagi dai cacaʌcana istumaasi gamamaatʌtuldi aanʌ dai maitipʌlidi ismaatʌ caʌcagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ʌgaicʌdʌ casi ʌpʌdui ismaacʌdʌ ooja Isaíacaru Diuusi ñiooquituldiadamigadʌ dai pocaiti: Caʌcamu aapimʌ Diuusi ñiooquidʌ dʌmos tomali ʌmo imidagai maimaatʌ caʌcamu. Nʌijadamu aapimʌ istumaasi ivueeyi Diuusi dʌmos maimaatʌ nʌijadamu. Ducami iscuupicagi gʌnvuupuji. Aapimʌ maitipʌlidi isvaavoitudagi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aapimʌ vuidʌrʌ vʌʌtʌ Diuusi. Tomali maitʌntʌgito caʌ aapimʌ Diuusi ñiooquidʌ. Mainʌijada ʌlidi aapimʌ tomali maicaʌca ʌlidi tomali maiʌma duucai gʌntʌtʌgitua ʌlidi dai camaisoimaasi ivuaadagi isaanʌ cʌʌgacʌrʌ gʌnvuvaidana. Astʌtʌdai Diuusi Ibʌadʌ ʌIsaía sai potʌʌna. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dʌmos Diuusi gʌnmaa oigaragai mʌsai aapimʌ giñmamaatʌrdamiga gia nʌidiña naana maasi istumaasi ismaacʌdʌ ivueeyi aanʌ dai mʌsai caʌcana istumaasi gamamaatʌtuldi aanʌ cascʌdʌ baigʌnʌlidi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sʌʌlicʌdʌ gʌnaagidi aanʌ sai mui Diuusi ñiñiooquituldiadamigadʌ dai aa oodami cʌʌ tuutiacami nʌida ʌliditadai istumaasi nʌidi aapimʌ dʌmos mainʌidi. Ʌgai caʌca ʌliditadai dʌmos maicaʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Caʌcavurai aapimʌ istʌiya iñʌlidi aanʌ aagaitai ʌsadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ismaacʌdʌ caʌ Diuusi ñiooquidʌ ismaacʌdʌ aagai istumaasi Diuusi ipʌlidi issoiñagi oodami sai cʌʌgacʌrʌ oidacana dai maimaatʌ caʌ ʌgai vaa ʌrʌgai daidʌ ʌrʌpan ducami ʌtʌligi ismaacʌdʌ voiyʌrʌ suuli. ɅDiaavora didivai dai maitʌgitoldi Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Daidʌ ʌtʌligi ismaacʌdʌ ojoodai saagida suuli ʌpan ducami ʌoodami ismaacʌdʌ caʌcana Diuusi ñiooquidʌ dai cʌʌga baigʌnʌliaracʌdʌ ʌʌgidiña, ");
INSERT INTO ntpNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","dʌmos maisiguupuacana ʌgai vaavoidaragadʌ. Vaavoitudaiña chiʌʌqui tasai dai siʌʌscadʌ parunadagi aa vaavoitudaitai ʌgai Diuusi ñiooquidʌ vai cadadagitoi gʌnvaavoidaraga. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Daidʌ ʌtʌligi ismaacʌdʌ vasoi saagida suuli ʌgai ʌpan ducami ʌoodami ismaacʌdʌ caʌcana Diuusi ñiooquidʌ dai mostʌgitocana tumiñsiʌrʌ dai istumaasi tʌgito vʌʌsi tasai dai mui aa naana maasiʌrʌ dai poduucai maitivueeyi ʌgai istumaasi Diuusi ipʌlidi dai ʌpan ducami ʌtʌligi ismaacʌdʌ maiiibiatai. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dʌmos ʌtʌligi ismaacʌdʌ cʌʌga dʌvʌʌriʌrʌ suuli ʌgai ʌrʌpan ducami ʌoodami ismaacʌdʌ maatʌ caʌ Diuusi ñiooquidʌ dai mamaatʌtuldi aa ʌgai ismaacʌdʌ vʌtʌmʌ mamaatʌrʌi ʌgai ʌgai daidʌ ʌrʌpan ducami iibiadʌ. Ʌʌmoco ʌrʌpan ducami ʌtʌligi ismaacʌdʌ cʌʌga iibaji asta ʌmo siento litro vuvaja ʌmo litroaiñdʌrʌ dai aa ʌrʌpan ducami ʌtʌligi ismaacʌdʌ iibaji vaicobai litro dai aa ʌrʌpan ducami ʌtʌligi ismaacʌdʌ iibaji ʌmo coobai dan baivustaama litro ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Daidʌ ʌSuusi gʌraagidi ʌmai ñiooqui cuentocʌdʌ dai potʌtʌdai: ―Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana. Gomaasi ʌpan ducami aidʌsi ʌmo oodami ʌi tʌligi cʌʌgaducami gʌdʌvʌʌragʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dai gooquiʌrʌ coi ʌgai ʌʌmadu gʌpipiooñiga tai tucarʌ divia ʌmo saayudʌ ʌʌsʌcami dai tʌligi saagida ʌi ʌgai vasoi dai ʌpamu nora. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dai aidʌsi cagʌʌ ʌtʌligi dai muuradagai moguucacatadai ʌvasoi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Amaasi iji ʌpipiooñigadʌ dai mʌʌ aagidi gʌaamu dai potʌtʌdai: “Cʌliodami ʌi aapi tʌligi cʌʌgaducami. ¿Siaadʌrʌ vuvaja idi vasoi?” astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Taidʌ ʌaamudʌ itʌtʌdai: “Ʌmoco giñsaayu ʌi gomaasi”, astʌtʌdai. Amaasi ʌpipiooñigadʌ itʌtʌdai: “¿Ipʌlidipʌsi isiimia aatʌmʌ dai vooponagi ʌvasoi?” astʌtʌdai ʌpipiooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Cho”, astʌtʌdai ʌgai. “Isvoopona aapimʌ ʌvasoi vooponan tada aapimʌ ʌtʌligi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Baiyomavʌr dagito vai vʌʌsi baigʌduuna vʌrai amaasi iimi dai ʌʌpʌga voopona ʌvasoi dai mʌida dai gooquiʌrʌ voopona ʌtʌligi dai baitua giñtroojogʌrʌ”, astʌtʌdai ʌaamudʌ gʌpipiooñiga ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Daidʌ ʌSuusi gʌraagidi ʌmai ñiooqui cuentocʌdʌ sai poduucai maatʌna ʌoodami isducatai Diuusi ñiooquidʌ aipacoga imʌi oidigi daama dai potʌtʌdai: ―Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana. Gomaasi ʌrʌpan ducami istumaasi ʌpʌvueeyi ʌcaidʌ ʌmo uusi ismaacʌdʌ ʌpa maasi coravi caidʌ ismaacʌdʌ ʌi ʌmo oodami gʌdʌvʌʌragana. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Goovai ʌraliducʌdioma uusi caidʌ oidigi daama ismaacʌdʌ gʌʌsai. Vai gʌgʌrʌ dai gʌgʌrʌ mamartai. Dai asta ujuurugi daivʌi dai ami maamaradʌrʌ coocosatai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Daidʌ ʌSuusi gʌraagidi ʌmai ñiooqui cuentocʌdʌ ʌʌpʌ sai poduucai maatʌna ʌoodami isducatai Diuusi ñiooquidʌ aipaco imʌi oidigi daama, dai potʌtʌdai: ―Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana, gomaasi ʌrʌpan ducami navaiti ismaacʌdʌ vʌʌnagi ʌmo ooqui vaica muuli tʌligi tuicami tai copoda. Vʌʌsi tui saagida ii ʌnavaiti dai poduucai vʌʌsi aipacoga oidigi daama imʌi Diuusi ñiooquidʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vʌʌsi gomaasi aagidi ʌSuusi ʌoodami cuentocʌdʌ dai tomastuigaco mamaatʌtuldiña ʌSuusi ʌoodami cuentocʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aidʌsi poduucai ivuaadana ʌSuusi poduucai ʌpʌdui ismaacʌdʌ ooja Diuusi ñiñiooquituldiadamigadʌ istumaasi aagai Diuusi dai pocaiti: Ñiooquidamu aanʌ ʌoodami cuentocʌdʌ. Aagidamu aanʌ naanʌ maasi istumaasi ismaacʌdʌ maimaatʌ tomali ʌmo oodami mosʌʌgi aanʌ. Ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Amaasi ʌSuusi diosagi ʌoodami dai vaa ʌmo quiiyʌrʌ tʌtai ami miaadʌrʌ guuquiva aatʌmʌ mamaatʌrdamigadʌ daidʌ itʌtʌdai aatʌmʌ: ―Gʌraagidañi aapi istʌiya ʌlidi gocuento ʌvasoi ismaacʌdʌ gʌʌi tʌligi saagida ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Amaasi ʌSuusi povai gʌrtʌtʌdai: ―Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ʌrʌpan ducami ʌgai ismaacʌdʌ ʌi ʌtʌligi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Daidʌ ʌdʌvʌʌrai ʌrʌpan ducami ʌoidigi. Daidʌ ʌtʌligi ʌrʌpan ducami ʌoodami ismaacʌdʌ gʌndagito sai Diuusi soicʌiña iscʌʌga gʌntʌtʌgitoca ʌgai daidʌ ʌvasoi ʌrʌpan ducami ʌgai ismaacʌdʌ iimia agai mʌʌca siaaco oidaga ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Daidʌ giñsaayu ismaacʌdʌ ʌi ʌvasoi ʌrʌpan ducami ʌDiaavora. Ʌyoovaragai ʌrʌpan ducami siʌʌscadʌ ugitiagi oidigi. Dai ʌpipiooñi ismaacʌdʌ voopoi ʌtʌligi ʌrʌpan ducami Diuusi tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Poduucai isduucai ʌvasoi gʌvoopo dai gʌmʌmʌji poduucai ʌʌpʌ ʌpʌduñia agai siʌʌscadʌ ugitiagi oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ootosamu giñtʌtʌaañicaru siʌmpaidamu ʌgai vʌʌsi soimaasi ivuaadami dai vʌʌscatai ismaacʌdʌ soimaasi iduiñtuldi aa vai ʌcovai vuvaidana ʌgai sai camaiʌʌmadu daraajana ʌgai ismaacʌdʌ aanʌ soicʌi sai cʌʌga gʌntʌtʌgitocana. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dai mʌʌca taiyʌrʌ siaaco oidaga ʌDiaavora ootosamu Diuusi ʌgai sisuaanʌdamu ʌgai dai aliʌ soimaa taatacamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amaasi vʌʌscatai ismaacʌdʌ ivueeyi istumaasi Diuusi ipʌlidi dadadacʌda agai ʌgai ʌpan duucai tasai mʌʌca siaaco gatʌaanʌi Diuusi gʌrooga. Cʌʌgavʌr gʌntʌgito caʌca istumaasi gʌnaagidi aanʌ dai ʌʌgiadavurai. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ʌgai ismaacʌdʌ ipʌlidi sai Diuusi soicʌiña sai cʌʌga gʌntʌtʌgitocana ʌrʌpan ducami ʌcʌʌli ismaacʌdʌ tʌʌ tumiñsi yaasapicami ʌmo dʌvʌʌriʌrʌ, dai ʌpamu yaasa anaasi. Dai baigʌʌliditai imʌi dai gagara vʌʌsi istumaasi viaacatadai dai gasavʌʌli ʌdʌvʌʌrai. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ʌgai ismaacʌdʌ ipʌlidi sai Diuusi soicʌiña sai cʌʌga gʌntʌtʌgitocana ʌrʌpan ducami ʌmo riicugami ismaacʌdʌ gaagaimi soorʌ viaa aali ojoodai namʌacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Dai aidʌsi tʌʌ ʌmoco ismaacʌdʌ viaacatadai ʌmo odai vaamioma namʌacami sivʌʌsi ʌgaa ii ʌgai dai gagaara vʌʌsi gʌvustuidaga dai gasavʌli ʌali odai. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana dai gomaasi ʌrʌpan ducami ʌmo gʌʌ vatopa vuicarui ismaacʌdʌ dadaitudai ʌvatopa vuudami ʌgʌʌ suudarʌ dai vuuyi mui naana maasi vatopa. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Siu duucu suudagi ʌvatopa vuicarui ʌvatopa vuudami bʌʌ ajioopai gʌʌ suudagi ugidiana dai ami dadarʌi dai ʌcovai vuvaidi ʌvatopa cʌcʌʌgaducʌdʌ dai asarʌrʌ tueeyi dai maigovai suuligai ʌvatopa maicʌcʌʌgaducʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Poduucai ʌpʌduñia agai ugitʌcai oidigi. Diuusi tʌtʌaañicarudʌ dadimu dai ʌcovai vuvaidamu ʌoodami soimaasi ivuaadami dai ʌgai ismaacʌdʌ camaitʌrsoimaasi ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dai maigovai suuligamu ʌsoimaasi ivuaadami taiyʌrʌ siaaco oidaga ʌDiaavora sisuaanʌdamu ʌgai dai soimaa taatacamu ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Amaasi ʌSuusi gʌrtʌcacai dai povʌrtʌtʌdai: ―¿Maatʌmʌs caʌ aapimʌ vʌʌsi gomaasi? ―gʌrtʌtʌdai ʌSuusi. Tai aa noragi aatʌmʌ daidʌ itʌtʌdai: ―Ʌjʌ tʌaanʌdami ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Amaasi ʌSuusi gʌraa noragi dai povʌrtʌtʌdai: ―Ʌmoco ismaacʌdʌ cʌʌ maatʌ istumaasi aagai judidíu sʌʌlicamigadʌrʌ dai cʌʌ maatʌ ʌʌpʌ ismaacʌdʌ gamamaatʌtuldi aanʌ isducatai Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana ʌgai gia cabai gʌnduuduna isaagidagi aa Diuusi ñiooquidʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aidʌsi naato gʌraagidi ʌSuusi ʌcuento ii abiaadʌrʌ ");
INSERT INTO ntpNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","gaamucu siaaco gʌʌ ʌgai. Dai judidíu quiuupaigadʌrʌ gʌaagacai gamamaatʌtuldi ʌgai Diuusi ñiooquidʌ. Taidʌ ʌoodami camaitʌʌ isducatai gʌntʌtʌgituagi daidʌ icaiti: ―¿Ducatai istutuidi goovai ismosʌʌ cʌʌga tʌtʌgitodagi daidʌ ivueeyi goovai istumaasi gʌgʌrducami? ");
INSERT INTO ntpNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Idiavʌr ʌuusi ivisumadami maradʌ dai María ʌrdʌʌdʌ. Dai susuuculidʌ ʌrJacovo, dai Osee, dai Simuñi, dai Uudasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dai susuuculidʌ ooqui ʌʌpʌ tami gʌrsaagida oidaga. ¿Siaacoga maí goovai vʌʌsi imaasi? ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aliʌ mui naana maasi maatʌcatadai ʌSuusi cascʌdʌ baacoican tada ʌoodami ʌgai vui. Dʌmos ʌSuusi itʌtʌdai: ―Vʌʌsi oodami cʌʌgacʌrʌ nʌidiña ʌmo Diuusi ñiooquituldiadamigadʌ mosʌca ʌʌgi dʌvʌʌragadʌana oidacami gia maisiaa duutudaiña tomali aaduñdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Daidʌ ʌSuusi maitidui mui naana maasi gʌgʌrducami ami. Ʌoodami maivaavoitudaiña ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aidʌ tuigaco ʌEroodʌsi ʌrcaigicatadai Galileeʌrʌ dai maí istumaasi ivuaadatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Daidʌ ʌEroodʌsi aagidi ʌgai ismaacʌdʌ ʌʌmadu daraajatadai dai potʌtʌdai: ―Gooviava ʌrVuaana ismaacʌdʌ vapaconaitadai ʌoodami dai caduaaca ʌgai coidadʌ saagidaiñdʌrʌ cascʌdʌ viaa ʌgai guvucadagai daidʌ ivueeyi naana maasi gʌgʌrducami ―astʌtʌdai ʌEroodʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ɅEroodʌsi ʌʌquioma gatʌjaitadai mʌsai bʌʌcaiña ʌVuaana dai maisacarui vuurana cadeenacʌdʌ. ɅErodiiasi ʌrduñidʌcatadai. ɅErodiiasi ʌrooñigadʌcatadai ʌPiili ʌEroodʌsi suculidʌ. Dʌmos ʌEroodʌsi ʌʌsi gʌsuculi ooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Taidʌ ʌVuaana itʌtʌdai ʌEroodʌsi: ―Maitavʌaagai pʌsʌʌsiadagi gʌsuculi Piili ooñigadʌ ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eroodʌsi aidʌ otoma muaa ʌliditadai ʌVuaana dʌmos ʌʌbʌiditadai ʌgai ʌoodami. Ʌoodami vaavoitudai isʌVuaana ʌrDiuusi ñiooquituldiadamigadʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dʌmos tasagadʌrʌ ʌEroodʌsi idui ʌgai ʌmo vagimi dai ʌmo ali tʌji Erodiiasi maradʌ vaa dai gatuudai ʌvapaidadʌ vuitapi vaidʌ ʌEroodʌsi aliʌ oojoidi tuudaidadʌ ʌali tʌji. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Daidʌ itʌtʌdai ʌEroodʌsi ʌali tʌji: ―Maatʌ Diuusi nai gʌmaquiagi pʌstumaasi giñtañiagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Amaasi ii ʌgai siaaco daacatadai ʌdʌʌdʌ taidʌ ʌdʌʌdʌ aagidi istumaasi tañia ʌgai ʌEroodʌsi. Dai ʌpamu divia ʌgai daidʌ itʌtʌdai ʌEroodʌsi: ―Giñmaacañi ʌmo aasocoliʌrʌ moodʌ ʌVuaana ismaacʌdʌ vapaconaiña ʌoodami ―astʌtʌdai ʌali tʌji. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Taidʌ ʌraí sʌʌlicʌdʌ soi gʌʌli. Dʌmos caaagiditadai ʌgai sai maatʌ Diuusi sai maquia agai ʌʌgi istumaasi tañia ʌgai. Daidʌ ʌvapaidadʌ caʌcatadai ʌʌpʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Amaasi gatʌjai ʌEroodʌsi mʌsai guicutana ʌVuaana cusivodʌ amʌʌ maisacariʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Boodʌrʌ ʌmo aasocoliʌrʌ vuaa dai maa ʌali tʌji, taidʌ ʌali tʌji maa gʌdʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Amaasi dada ʌVuaana mamaatʌrdamigadʌ dai mʌʌ bʌi ʌVuaana tuucugadʌ dai bʌʌcai dai yaasa. Dai gooquiʌrʌ iji siaaco daacatadai ʌSuusi dai aagidi istumaasi ʌpʌdui. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Aidʌsi maí ʌSuusi gomaasi ii abiaadʌrʌ ʌmo vaarcuʌrʌ ʌmapʌcʌrʌ siaaco maitiipu oidacami. Dʌmos ʌoodami maí isii ʌSuusi, gooquiʌrʌ iji aali quiiquiaiñdʌrʌ. Dʌmos ʌgai dʌvʌʌrapi sʌʌli iji. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dai aidʌsi tʌvai ʌSuusi vaarcuaiñdʌrʌ tʌʌ ʌgai mui oodami dai soigʌʌldan tada ʌgaicʌdʌ, dai duduaadi ʌcoococoidadʌ ismaacʌdʌ vaidaticatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dai aidʌsi casi ʌrurunococatadai miaadʌrʌ guuquiva aatʌmʌ ʌSuusi mamaatʌrdamigadʌ daidʌ itʌtʌdai: ―Casiat urui dai tomali ʌmaadutai maioidaga tanai. Ootosañi gooodami vai iimʌna aali quiiquiamu siaaco miaaga vai gasavʌdana cuaadagai dai gaugaana ―tʌtʌdai aatʌmʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Maita viaa goovai isiimiagi. Bibidavurai aapimʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tʌtai aatʌmʌ itʌtʌdai: ―Mosʌca taama paana dai gooca vatopa viaa aatʌmʌ ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Baigovai avʌr giñvuaapida ―gʌrtʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dai amaasi ʌgai aagidi ʌoodami sai vasoi saagida daraivana. Dai amaasi ʌSuusi vui ʌtaama paana dai tai nʌnʌava tʌvaagiamu dai gamamagi dai saasasacai gʌrmaa aatʌmʌ mamaatʌrdamigadʌ tʌsai taacogidana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dai vʌʌscatai gauu dai tataascovai. Dai gooquiʌrʌ ʌmpagi baivustaama dan gooca aasarai susudacami saasaquigadʌ ʌpaana ʌʌmadu vatopa. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Daidʌ ʌoodami ismaacʌdʌ gauu ʌrtaama milicatadai, dai ʌcovai ooqui dai aali. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Taidʌ ʌSuusi gʌraagidi aatʌmʌ mamaatʌrdamigadʌ tʌsai tʌʌtʌidʌna vaarcuʌrʌ dai dʌgavunʌna vaasadʌrʌ ʌgʌʌ suudagi ʌʌpʌga isʌgai dai ʌgai dioosaidimi ʌoodami quiaa. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dai aidʌsi cadioosagi ʌgai ii ʌmo tuvidacamu dai ʌʌgi gamamada agai. Dai aidʌsi cadidiaimi ʌSuusi quiaa ʌʌgi daacatadai amʌʌca. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Daidʌ ʌvaarcu caʌran ʌʌsi imʌitadai ʌgʌʌ suudagi. Daidʌ ʌvaarcu vuidʌrʌ vustai ʌʌvʌʌli dai tai vapañigʌi suudagi dai mʌʌ vaarcuaba astʌcʌi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dai casiaalimodʌ ʌSuusi cayoga gʌraayitadai aatʌmʌ mamaatʌrdamigadʌ mossuudagi daama imʌitadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dai aidʌsi tʌʌ aatʌmʌ issuudagi daama imʌitadai ʌgai aliʌ duduaadimu aatʌmʌ dai ijiiña daidʌ icaiti: ―Gooviava ʌrʌmo suiñali ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dʌmos ʌSuusi gʌrñiooqui dai povʌrtʌtʌdai: ―Maitavʌr vuaam ʌnʌliada aanʌana. Maitavʌr duduaadicuda ―gʌrtʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Amaasi ʌPiiduru ñiooqui daidʌ itʌtʌdai: ―Tʌaanʌdami isʌraapi giñtʌaañiñi isimia aanʌ suudagi daama dai mʌʌca gʌajiagi ―tʌtʌdai Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Taidʌ ʌSuusi itʌtʌdai: ―Giimi tudu ―tʌtʌdai. Amaasi tʌvai ʌPiiduru vaarcuaiñdʌrʌ dai gʌaagacai aimʌrai suudagi daama dai mʌʌ vuidʌrʌ ajia agai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dai aidʌsi tʌʌ ʌgai isaliʌ cavami ʌvʌʌlimi aliʌ duaadimu, dai casuudagi uta vaaquimi dai iiña daidʌ itʌi: ―Tʌaanʌdami cʌʌgacʌrʌ igiñvuusaida ―caiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Taidʌ ʌSuusi otoma bʌi novidʌ daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ maicʌʌga giñvaavoitudai aapi. ¿Tuipʌsi maicʌʌga giñvaavoitudai? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aidʌsi tʌʌtʌsai vaarcuʌrʌ ʌPiiduru ʌʌmadu ʌSuusi otoma gʌʌʌpitu ʌvʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Amaasi aatʌmʌ ismaacʌdʌ vaarcuʌrʌ daraajatadai gʌrtootonacʌdʌ guuquiva ʌSuusi vuidʌrʌ daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ aapi apʌrmaradʌ Diuusi ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dai vaasadʌrʌ dʌgavusai aatʌmʌ ʌgʌʌ suudagi dai aayi Genesareta dʌvʌʌriʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dai aidʌsi maí ʌoodami isʌgai ʌrSuusi otoma aagidi vʌʌsi ami dʌvʌʌriʌrʌ oidacami. Taidʌ ʌoodami otoma vuaa vʌʌsi ʌcoococoidadʌ ami siaaco daacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Daidʌ ʌoodami daañimi ʌSuusi daidʌ itʌtʌdai: ―Gʌdagitoñi tʌtai taata aatʌmʌ gʌyuucusi tomasi ugidiana gʌyuucusi taata aatʌmʌ ―tʌtʌdai ʌoodami. Dai vʌʌscatai ismaacʌdʌ taata yuucusidʌ duduaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Amaasi miaadʌrʌ guuquiva ʌfariseo ʌʌmadu ʌmamaatʌtuldadami Diuusi sʌʌlicamigadʌ siaaco daacatadai ʌSuusi. Ʌgai Jerusaleenaiñdʌrʌ dada, daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Tuisidʌ maitivueeyi gʌmamaatʌrdamiga istumaasi gʌrviituli gʌrʌʌqui aaduñicaru dai maitʌrʌpan duucai vapaconai gʌnnoonovi siuu duucu gaugia aagadagi? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Tuimʌsi aapimʌ maiʌʌgidi istumaasi ipʌlidi Diuusi baiyoma ʌʌgidi aapimʌ istumaasi gʌnviituli gʌnʌʌqui aaduñicaru? ");
INSERT INTO ntpNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mospoduucai icaiti Diuusi: “Siaavʌr duutuada gʌndʌʌdʌ”, dai pocaiti ʌʌpʌ: “Sioorʌ maicʌʌga ñioocadagi gʌooga siʌpʌ gʌdʌʌ vui, ʌgai gʌaagai isdudunucami muaagi”, ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dʌmos aapimʌ pocaitiña sai ʌmo oodami istutuidi isitʌʌdagi gʌooga siʌpʌ gʌdʌʌ: “Maitan istutuidi isgʌnsoiñagi tomali istumaasicʌdʌ vʌʌsi istuma viaa aanʌ ʌrDiuusi aa duiñdadʌ vʌʌtarʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dai ispotʌiya ʌmaadutai mai aapimʌ pocaitiña sai camaiviaa ʌgai issoicʌdagi gʌooga siʌpʌ gʌdʌʌ. Dai poduucai aapimʌ mosgajiaadʌrʌ vipieeyi istumaasi ipʌlidi Diuusi ducami isiʌrʌmo istumaasi maicʌʌgaducamicagi. Dai baiyoma ivueeyi aapimʌ itumaasi gʌnviituli gʌnaaduñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai Isaíacaru Diuusi ñiooquituldiadamigadʌ gʌnaagaitai aapimʌ dai ʌgai ooja istumaasi aagidi Diuusi dai poduucai ooja: ");
INSERT INTO ntpNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Aapimʌ pocaiti mʌsai giñsiaa duutudai dai maisiaa giñduutudai. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gomaasi gia maitʌrsoiñi tomali ʌmaadutai vʌʌtarʌ. Aapimʌ maigamamaatʌtuldi giññiooqui baiyoma gamamaatʌtuldi aapimʌ istumaasi oodami gʌnviituli. Ascaiti Diuusi sai ooja Isaíacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Amaasi ʌSuusi aagidi ʌoodami sai miaadʌrʌ guuquivana daidʌ itʌtʌdai: ―Giñcaʌcavurai dai cʌʌga maatʌ caʌca: ");
INSERT INTO ntpNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tomali ʌmo istumaasi ismaacʌdʌ cueeyi oodami maivapacʌi tʌgitoidadʌrʌ cascʌdʌ cuaadagai maisoimaasi iduiñtuldi oodami. Baiyoma tʌgitoidagadʌaiñdʌrʌ vusacʌi mui naana maasi soimaascami dai poduucai gʌmaatʌ isiʌrsoimaasi ivuaadami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Amaasi aatʌmʌ mamaatʌrdamigadʌ ʌSuusi miaadʌrʌ guuquiva daidʌ itʌtʌdai: ―¿Maatʌpʌsi isaliʌ baacoi ʌfariseo caʌcai istumaasi aagai aapi? ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dʌmos ʌgai povʌrtʌtʌdai: ―Tomastuma mamaatʌtuldiaragai istumaasi gamamaatʌtuldiadagi oodami ismaacʌdʌ maitʌrDiuusi mamaatʌtuldaragadʌ vʌʌsi gomaasi ugitimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dagitovurai aapimʌ ʌgai ismaacʌdʌ gamamaatʌtuldi gomaasi. Ʌgai ʌpan ducami ʌmoco mainʌaadami ismaacʌdʌ vaidaquia ʌlidi ʌmai mainʌaadami, isvaidaquia ʌgai vʌgoocatai sibʌ dʌʌcarʌ suuligian tada ʌgai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Amaasi ʌPiiduru itʌtʌdai: ―Gʌraagidañi aapi istʌiya ʌlidi gocuento ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Taidʌ ʌSuusi itʌtʌdai: ―¿Tomali aapimʌ mʌsmaimaatʌ caʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Maitamʌsmaatʌ aapimʌ sai vʌʌsi cuaadagai ismaacʌdʌ cueeyi oodami gavoocʌrʌ vapacʌi dai gooquiʌrʌ vusacʌi? ");
INSERT INTO ntpNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dʌmos istumaasi aagai oodami ʌgai gia gatʌgitoidagaiñdʌrʌ vusacʌi, gomaasi ʌgai dai soimaasi iduiñtuldi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gatʌgitoidagaiñdʌrʌ vusacʌi gosoimaasi tʌgitoidagai cascʌdʌ, dai gomuaaragai, dai goʌʌmadu voidagai aa ooqui, dai goʌʌsidaragai, dai goyaatagidaragai, dai goñiooquidaragai. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Vʌʌsi gomaasi ʌristumaasi soimaascami. Dʌmos isʌmo oodami maivacuanagi gʌnoonovi poduucai isduucai ivueeyi ʌfariseo siuu duucu gaugia agadagi gomaasi maitʌrsoimaasi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Daidʌ ʌSuusi ii abiaadʌrʌ gamu Tiiroamu dai Sidooniamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tai ʌmo ooqui Cananeeaiñdʌrʌ divia siaaco daacatadai ʌSuusi dai iiña ʌgai daidʌ itʌtʌdai: ―Tʌaanʌdami, aanʌ anvaavoitudai sai aapi ʌrDavicaru cajiudadʌ ismaacʌdʌ ʌʌqui abiaadʌrʌ nʌnʌracatadai aatʌmʌ daidʌ ʌrraícamu aapi. Ali tʌji giñmara sʌʌlicʌdʌ soimaa taataca viaacatai ʌmo Diaavora tʌaañicarudʌ. Soigi gʌʌlda dai duaaida ―tʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dʌmos ʌSuusi maiaa noragi tomali ʌmo ñiooqui. Amaasi aatʌmʌ ʌSuusi mamaatʌrdamigadʌ dada dai daañimi daidʌ itʌtʌdai: ―Ootosañi idi ooqui mosʌrgooquiʌrʌ aimʌraiña goovai dai iiñacaiña ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Amaasi ʌSuusi itʌtʌdai ʌooqui: ―Diuusi giñootoi ansai aagidana aanʌ ʌgai ñiooquidʌ mosʌca judidíu. Ʌgai ʌrʌpan ducami cañiiru sibʌ iimiadʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Taidʌ ʌooqui miaadʌrʌ cʌquiva dai gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ daidʌ itʌtʌdai: ―Tʌaanʌdami giñsoiñañi ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Taidʌ ʌSuusi itʌtʌdai: ―Maitavʌr cʌʌgai isʌʌsiadagi oodami gʌmaamara tascalidʌ dai oidiadagi googosi ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Taidʌ ʌooqui itʌtʌdai: ―Vaavuava isʌjudidíu googosi gʌraagai dʌmos vʌʌscʌrʌ ʌgoogosi cuaadana vʌʌsi istumaasi gʌʌsʌi meesagadʌaiñdʌrʌ sosiaacami, cascʌdʌ tomasi maitʌrjudíu aanʌ giñsoiñañi aapi sivi ―tʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Amaasi ʌSuusi itʌtʌdai: ―Aapi ooqui aliʌ cʌʌga vaavoitudai, cascʌdʌ ʌpʌduuñia agai istumaasi ipʌlidi aapi ―tʌtʌdai. Dai aidʌ todian duucai ʌooqui maradʌ dueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Taidʌ ʌSuusi ii abiaadʌrʌ dai ugidiana daivusai ʌgʌʌ suudagi dai ʌmo giidian tʌsai dai ami daiva. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tai ami aayi mui oodami dai vaidaticatadai chuchuecogami dai momochugami dai mainʌnʌaadami dai mumuudugami dai mui naana maasi coococoidadʌ. Daidʌ ʌSuusi ʌʌcasodʌ abaana tuaa ʌcoococoidadʌ tai ʌgai duduaadi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dai poduucai ʌoodami maitʌʌ istumaasi gʌntʌtʌgituagi tʌʌgacai isʌmumuudu ñioocai dai duduaadʌcai ʌmomosiucʌdʌ ʌʌpʌ, dai ajioopaitai ʌchuchuecocʌdʌ, dai nʌnʌaavacai ʌmainʌaadami. Daidʌ ʌoodami gʌnaagacai siaa duutudai gʌrDiuusiga. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Amaasi ʌSuusi gʌrvai aatʌmʌ mamaatʌrdamigadʌ ʌgai daidʌ ʌpʌrtʌtʌdai: ―Soigiñʌlidi aanʌ idi oodamicʌdʌ caaayi vaica tasai istami giñʌʌmadu daraaja goovai dai maiviaa istuma ugiagi. Dai maiootosa iñʌlidi aanʌ sai noonoigʌna goovai maitaugacai, susuiquituan tada goovai voiyamu ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tʌtai aatʌmʌ mamaatʌrdamigadʌ itʌtʌdai ʌSuusi: ―Ducatai tʌʌgimu aatʌmʌ cuaadagai mosʌʌqui oodami vʌʌtarʌ, dai tami maioidaga tomali ʌmo oodami ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Mʌʌqui paana viaa aapimʌ ―gʌrtʌtʌdai. Tʌtai aatʌmʌ itʌtʌdai: ―Cuvaracami paana dai chiʌʌqui vatopa ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tai amaasi ʌSuusi aagidi ʌoodami sai dʌvʌʌrapi daraivana. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dai ʌgai vui ʌcuvaracami paana dai ʌvatopa dai gamamagi dai gooquiʌrʌ saasarai dai gʌrmaa aatʌmʌ mamaatʌrdamigadʌ ʌgai tʌtai aatʌmʌ taacogi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tai vʌʌscaitai gauu dai tatascovai. Dai gooquirʌ ʌmpagi cuvaracami aasarai ismaacʌdʌ baivito. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Daidʌ ʌoodami ismaacʌdʌ gauu ʌrmaacova miilicatadai, dai ʌcovai ooqui dai aali. ");
INSERT INTO ntpNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dai gooquirʌ ʌSuusi dioosagi ʌoodami dai vaarcuʌrʌ vaa dai iji aatʌmʌ gamu Magadaalamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Taidʌ ʌfariseo ʌʌmadu ʌsaduseo mʌʌ nʌidamu ʌSuusi mosnʌijada ʌliditai astuma duuna ʌSuusi gaagaitadai ʌgai isducatai gʌpiʌrʌ vuaajagi dai aagidi saidʌ iduuna ʌmo istumaasi gʌducami Diuusi guvucadadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Siʌʌscadʌ urunoco vʌʌgicagi icomai aapimʌ icaitiña sai cʌʌgaduca agai tasai. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dai siʌʌscadʌ quiaamoco vʌʌgicagi icomai aapimʌ icaitiña sai maicʌʌgaduca agai tasai. Aapimʌ aagaiña ʌmo istumaasi dai ʌmamaasi ivuaadana. Cʌʌga maatʌ nʌidi aapimʌ oidigi siʌʌscadʌ duuduquia aagadagi dai siʌʌscadʌ maiduuduquia agadagi dʌmos maimaatʌ nʌidi aapimʌ istumaasi ʌpʌvueeyi sivi oidigi daama. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aapimʌ sivi oidacami ʌrsoimaasi ivuaadami dai maivaavoitudadami dai giñtʌaanʌi aapimʌ isiduñia aanʌ ʌmo istumaasi gʌducami dai poduucai nʌijada ʌlidi aapimʌ sabai aanʌ ʌrʌCristo ismaacʌdʌ nʌnʌra aapimʌ dʌmos maitʌʌgimu aapimʌ ʌmai istumaasi gʌducami mosʌcaasi ʌistumaasi gʌducʌdʌ ismaacʌdʌ idui Diuusi ootosacai Joonasi gamu Ñiñiviamu ―tʌtʌdai ʌSuusi. Dai anaasi viaa ʌgai dai ii. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dai aidʌsi aatʌmʌ ʌSuusi mamaatʌrdamigadʌ vaasmocoradʌrʌ dʌgavusai tʌgito ismaivuucaticatadai paana. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Amaasi ʌSuusi povʌrtʌtʌdai: ―Gofariseo navaitigadʌ dai gosaduseo navaitigadʌ maicʌʌgadu ―gʌrtʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tʌtai aatʌmʌ gʌraagacai aipaco gʌraatagidimi daidʌ icaiti: ―Maivuucati aatʌmʌ paana cascʌdʌ pocaiti goovai ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Taidʌ ʌSuusi maí istumaasi aatagaitadai aatʌmʌ dai povʌrtʌtʌdai: ―¿Tuimʌsi pocaiti mʌsai maivuucati paana? Sʌʌlicʌdʌ maicʌʌga vaavoitudai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Maitamʌsquiaa maatʌ nʌidi tomali maitʌgito aapimʌ aidʌñsi bibi aanʌ ʌtaama mil oodami taama paanacʌdʌ mʌtʌʌqui aasarai ʌmpagi saasaquigadʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Tomali maitamʌstʌgito aapimʌ aidʌñsi bibi aanʌ ʌmaacova mil oodami cuvaracami paanacʌdʌ mʌtʌʌqui aasarai ʌmpagi saasaquigadʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ducatai maitʌntʌgito caʌ aapimʌ aidʌsi gʌnaagidi aanʌ mʌsai gʌnnuucadacana ʌfariseo navaitigadʌ dai ʌsaduseo navaitigadʌ aanʌ maiaagaitadai paana? ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Amaasi gia maatʌ caʌ aatʌmʌ isʌSuusi maiaagaitadai navaiti paana vʌʌtarʌ baiyoma aagaitadai ʌgai ʌmamaatʌtuldaragadʌ ʌfariseo dai ʌsaduseo sai maicʌʌgadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dai aidʌsidʌ ʌSuusi aayi Sesarea Filiposi dʌvʌʌriʌrʌ gʌrtʌcacai daidʌ pʌrtʌtʌdai: ―Aanʌ ʌrʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami dʌmos ʌoodami, ¿voorʌ giñaagai? ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tʌtai aatʌmʌ aa noragi daidʌ itʌtʌdai: ―Ʌʌmoco pocaiti pʌsaidʌ ʌrʌVuaanacaru ismaacʌdʌ vapaconaitadai ʌoodami, dai aa pocaiti pʌsaidʌ ʌrEliiasicaru, dai aa pocaiti pʌsaidʌ ʌrJeremiiasicaru siʌʌpʌ ʌmai Diuusi ñiooquituldiadamigadʌ ―tʌtʌdai aatʌmʌ mamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Amaasi ʌSuusi povʌrtʌtʌdai: ―¿Dai aapimʌ moorʌ giñaagai? ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Amaasi ʌSimuñi Piiduru itʌtʌdai: ―Aapi apʌrʌCristo ʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami. Dai aapi ʌrDiuusi maradʌ ismaacʌdʌ tomastuigaco oidaga ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Taidʌ ʌSuusi itʌtʌdai: ―Diuusi cʌʌgacʌrʌ gʌnʌidi aapi Simuñi, Joonasi maradʌ tomali ʌmo oodami maitʌmaatʌtuli gomaasi mosʌca Diuusi gʌrooga ismaacʌdʌ tʌvaagiana daja ʌgai gia gʌmaatʌtuli gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dai aanʌ angʌaagidi sai aapi Piiduru aagiada agai oodami ansai aanʌ ʌrcʌʌgacʌrʌ vuviaadami dai muidutai giñvaavoituda agai dai ʌgai gia cʌʌgacʌrʌ vuvaidamu aanʌ, dai tomasi coiyagi vʌʌscʌrʌ ʌmo imidagai ʌpamu duduaacamu vʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dai aanʌ gʌmaaquimu ʌmo sʌʌlicami pai aagida ʌoodami sai sioorʌ giñvaavoitudagi soicʌda aagai sai cʌʌga gʌntʌtʌgitocana Diuusi vai poduucai tomasioorʌ sioorʌ maitiñvaavoitudagi aagiditai aapi tami oidigi daama maidagitomu aanʌ isvaquia ʌgai tʌvaagiʌrʌ dai tomasioorʌ sioorʌ giñvaavoitudagi aagiditai aapi tami oidigi daama ʌgai gia dagitomu aanʌ isvaquia tʌvaagiʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Amaasi ʌSuusi sʌʌlicʌdʌ gʌrdaí aatʌmʌ mamaatʌrdami sai maiaagidiña tomali ʌmaadutai siʌgai ʌrʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aidʌ abiaadʌrʌ ʌSuusi gʌaagacai gʌraagidi aatʌmʌ mamaatʌrdami sai ʌgai viaacatadai isimiagi Jerusaleenamu dai sai soimaa taatatulda agai ʌtʌtʌaanʌdamigadʌ judidíu ʌʌmadu ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Dai gʌraagidi ʌSuusi sai ʌgai muaa agaitadai dʌmos bovaica tasaicʌdʌ ʌpamu duaaca agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Amaasi ʌPiiduru ʌcovai vaidacai dai vui ñiooquimi daidʌ itʌtʌdai: ―Chu cʌliodami Diuusi maitipʌldana dai maitʌdagitona. Tomali ʌmo imidagai maitiʌpʌduuna imaasi ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Taidʌ ʌSuusi ajaco cʌquiva daidʌ itʌtʌdai ʌPiiduru: ―Maitigiñʌʌmadu aimʌrda aapi Diaavora giñsobicʌi aapi. Aapi pocaiti sai maitʌaagai isivuaadagi aanʌ istumaasi Diuusi ipʌlidi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Amaasi ʌSuusi povʌrtʌtʌdai aatʌmʌ: ―Isʌmaadutai giñʌʌgiada ʌliada maitʌaagai isʌʌgi gʌtʌgitocagi dai gʌaagai isvʌʌs tasai baigʌducagi siʌduñiada gʌmuaatuda ʌgai giñvaavoitudaitai daida giñʌʌgiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sioorʌ ivuaadagi ʌʌgi istumaasi ipʌliadagi ʌgai gia imimu Diaavora ʌʌmadu, dʌmos sioorʌ baigʌducagi dai muquiagi giñvaavoitudaitai ʌgai gia cʌʌgacʌrʌ vuusaimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Tumaasi ʌrsoiñi ʌmo oodami vʌʌtarʌ isgamaitʌagi vʌʌsi istumaasi oidaga oidigi daama vai iibʌadʌ imiagi Diaavora ʌʌmadu? Tomali ʌmaadutai maitistutuidi isgaaanamʌquidagi dai cʌʌgacʌrʌ vuusiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami divimu ʌmaadu mui Diuusi tʌtʌaañicarudʌ dai giñooca dadadaquigadʌ gʌrsicoli dadadaquida agai. Siʌʌscadʌ diviagi Diuusi ʌgai nʌidamu vʌʌscatai ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sʌʌlicʌdʌ oidaga ʌʌmoco ismaacʌdʌ tami guuca dai maicoiya agai asta siʌʌscadʌ tʌʌ goovai ismaasca iñagai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami siʌʌscadʌ gatʌaanʌdagi Diuusi ʌʌmadu ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Daidʌ ʌSuusi bonaadami tasaicʌdʌ vaidacai ʌPiiduru ʌʌmadu ʌJacovo ʌʌmadu ʌVuaana Jacovo suculidʌ ʌmo tʌca giidiana. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dai ami ʌSuusi ʌmapʌdui vuitapi gʌmamaatʌrdamiga. Dai vuivasadʌ dadadaquitu ʌpamaastu tasai, dai yuucusidʌ cʌʌga tootuatu. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dai todian duucai tʌʌ ʌgai Eliiasicaru ʌʌmadu Moseesacaru vai gaaatagaitadai ʌʌmadu ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Amaasi ʌPiiduru itʌtʌdai ʌSuusi: ―Tʌaanʌdami vʌʌsi ʌrcʌʌgai istami daraaja aatʌmʌ isipʌliada aapi tʌtai duuñi vaica uucusai, ʌmoco aapi gʌvʌʌtarʌ dai ʌmai Moseesa vʌʌtarʌ dai ʌmai Eliiasi vʌʌtarʌ ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dai quiaa ñioocaitadai ʌgai tai divia ʌmo icomai dadadacʌdami dai iiña vʌʌscatai ismaacʌdʌ ami daraajatadai. Tai icomiaiñdʌrʌ caidatu ʌmo ñiooqui daidʌ icaiti: ―Idi Suusiava ʌrgiñmara nai aanʌ aliʌ oigʌdai dai baigiñʌlidi aanʌ goovaicʌdʌ. Ʌʌgiadavurai aapimʌ ―ascaiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Moscaʌcai ʌmamaatʌrdami ʌñiooqui dʌvʌʌrapi cuiiqui dai aliʌ duduaadimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amaasi ʌSuusi miaadʌrʌ cʌquiva daidʌ itʌtʌdai: ―Vaapaigivurai aapimʌ maitavʌr duduaadimu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dai aidʌsi aipaco nʌnʌaava ʌgai camaitʌʌ ʌgai ʌcʌcʌʌli mosʌca ʌʌgi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dai aidʌsi tʌaapañimi ʌgai ʌgʌʌ giidiaiñdʌrʌ ʌSuusi dai ʌmamaatʌrdamigadʌ daidʌ itʌtʌdai: ―Maitavʌr aagiada tomali ʌmaadutai istumaasi tʌʌ aapimʌ asta siʌʌscadʌ aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami caduaacagi coidadʌ saagidaiñdʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Amaasi ʌmamaatʌrdamigadʌ tʌcacai ʌSuusi daidʌ itʌtʌdai: ―¿Tuisidʌ icaiti ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ saidʌ ʌEliiasicaru viaacatadai isdiviagi ʌʌpʌga isaapi? ―astʌtʌdai ʌmamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Vaavoava istumaasi aagai ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ sai Eliiasi viaacatadai isʌʌpʌga diviagi dai baiduñiagi oodami iibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Dʌmos aanʌ angʌnaagidi sai cadivia Eliiasi dai ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ maimaí dai soimaa taatatuli ʌgai isducatai ipʌli. Poduucai ʌʌpʌ ʌoodami sividadʌ soimaasi giñtaatatuldamu aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Amaasi ʌmamaatʌrdamigadʌ maatʌ caʌ isʌSuusi aagaitadai ʌVuaana ismaacʌdʌ vapaconaitadai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dai aidʌsi aayi ʌgai mʌʌca siaaco daraajatadai ʌoodami ʌmo cʌʌli miaadʌrʌ cʌquiva ʌSuusi daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tʌaanʌdami soigi gʌʌlda aapi giñmaracʌdʌ. Susuiquitʌrʌi ʌgai dai aliʌ soimaa taatamai. Muiyoco imidagai taiyʌrʌ gʌgʌsʌi dai suudarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tami vuaapi aanʌ gʌmamaatʌrdamiga ismaacʌdʌ tami vii tai goovai maitistui isduaaidagi ―tʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Aapimʌ oodami maivaavoitudadami dai soimaasi ivuaadami catʌvʌpi gʌnʌʌma daja aanʌ mai aapimʌ vʌʌscʌrʌ maitiñvaavoitudai. Aliʌsi ʌroojodaragai aapimʌ. Baigovai avʌr giñvuaapidi goali gʌʌli ―gʌrtʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dʌmos ʌSuusi aagidi ʌDiaavora tʌaañicarudʌ sai dagitona ʌali gʌʌli dai camaiʌʌmadu daacana. Tai ʌgai vuusai ʌali gʌʌliaiñdʌrʌ, tai ʌali gʌʌli todian duucai duaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Dai gooquiʌrʌ aatʌmʌ mamaatʌrdamigadʌ ʌSuusi aatagi ʌgai ʌʌgi dai tʌcacai daidʌ itʌtʌdai: ―¿Tuisidʌ maitistui aatʌmʌ isvuusaidagi ʌDiaavora tʌaañicarudʌ? ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Aapimʌ maicʌʌga giñvaavoitudai cascʌdʌ. Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi. Sai iscʌʌga giñvaavoitudadamudai aapimʌ aidʌ gia istutiadamudai aapimʌ isivuaadagi istumaasi tomasi sʌʌlicʌdʌ sijaiga. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Gomaa Diaavora tʌtʌaañicarudʌ aliʌ sijaiga vuvaidaragai oodamiaiñdʌrʌ cascʌdʌ avʌnacai maitaugacai gamamadagi vai poduucai vuvacʌi goovai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dai aatʌmʌ mamaatʌrdamigadʌ ʌSuusi gʌrʌmpaidimi Galileeʌrʌ taidʌ ʌSuusi povʌrtʌtʌdai: ―Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami mʌgiñtʌʌgida aagai aa oodami ");
INSERT INTO ntpNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","siʌgai giñmuaamu dʌmos vaica tasaicʌdʌ duaacamu aanʌ ―gʌrtʌtʌdai ʌSuusi. Tʌtai aliʌ soigʌrʌʌli aatʌmʌ imaasicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aidʌsi aayi ʌSuusi ʌʌmadu aatʌmʌ Capernauumʌrʌ ʌtumiñsi vuudami ʌgʌʌ quiuupaigadʌrʌ judidíu iji siaaco daacatadai ʌPiiduru daidʌ itʌtʌdai: ―¿Gʌmamaatʌtuldadamiga isgamaacai ʌʌpʌ tumiñsi ʌgʌʌ quiuupai vʌʌtarʌ? ―astʌtʌdai ʌtumiñsi vuudami. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Ʌjʌ ―astʌtʌdai. Amaasi utudama vaacʌcai ʌPiiduru quiiyʌrʌ ʌSuusi ʌʌpʌga ñiooqui daidʌ itʌtʌdai: ―¿Tuma tʌtʌgitoi aapi? ¿Maacʌdʌ oodami taanʌi ʌtʌtʌaanʌdami tumiñsi, ʌʌgi gʌnaaduñi sisibʌacoga oidacami? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Ʌsibʌadʌrʌ oidacami ―tʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Amaasi aaduñdʌ maitʌaagai ismamaacadagi tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dʌmos vʌʌscʌrʌ maaquimu aanʌ tumiñsi vai poduucai maibaacuagi ʌtumiñsi vuudami. Imiñi aapi ʌgʌʌ suudagi ugidiamu dai daituda ʌmo babaidacarui dai vuusaida ʌvatopa ismaacʌdʌ ʌʌpʌga bʌiya gobabaidacarui. Ʌgai vatopa tʌñiʌrʌ tʌʌgimu aapi tumiñsi. Ʌtumiñsi gʌraimu isgaaanamʌquida aanʌ dai aapi ʌʌpʌ. Bʌcaiñi aapi dai mʌʌca aa namʌquida ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Amaasi aatʌmʌ mamaatʌrdamigadʌ ʌSuusi miaadʌrʌ guuquiva dai tʌcacai daidʌ itʌtʌdai: ―¿Siʌʌscadʌ gatʌaanʌdagi aapi vʌʌsi oidigi daama maascʌdʌ aatʌmʌ gʌmamaatʌrdamiga vaamioma gatʌaanʌda ragai? ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Amaasi ʌSuusi vaí ʌmo ali dai gʌrsaagida cʌi, ");
INSERT INTO ntpNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","dai povʌrtʌtʌdai: ―Sʌʌlicʌdʌ ʌrvaavoi isaapimʌ maiʌma duucai gʌntʌtʌgituagi dai camaigʌgʌrducʌdʌ gʌnʌliadagi ʌpan duucai idi ali poduucai gia maiiimimu aapimʌ siaaco tʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Poduucai gia ʌgai ismaacʌdʌ vaamioma gatʌaanʌi mʌʌca siaaco gatʌaanʌi Diuusi ʌrʌgai ismaacʌdʌ maigʌgʌrducʌdʌ gʌnʌlidi ʌpan duucai idi ali. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tomasioorʌ sioorʌ vaavoitudai giñmamaatʌtuldaraga dai cascʌdʌ oigʌdai idi ali oodami ʌgai gia giñoigʌdai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tomasioorʌ sioorʌ soimaasi iduiñtulda ʌliadagi ʌmoco ismaacʌdʌ utudama giñvaavoitudagi siooma ʌrcʌʌgai ʌgai vʌʌtarʌ mʌscusivuana vulidagi ʌmo gʌʌ mauturui dai gʌʌ suudarʌ daitudagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Sʌʌlicʌdʌ maicʌʌgadu oodami vʌʌtarʌ isoidacagi naana maasi ismaacʌdʌ soimaasi iduiñtuldiadagi ʌoodami. Vʌʌscʌrʌ oidacamu istumaasi isducatai soimaasi ivuaadagi oodami dʌmos soimaasi taatamu ʌgai ismaacʌdʌ soimaasi iduiñtuldiadagi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Isʌmaadutai iduñia ʌliadagi ʌmo istumaasi soimaascami gʌnovicʌdʌ siʌʌpʌ gʌʌcasocʌdʌ baiyoma gʌaagai ispoʌliada ʌgai ismainovʌ siʌʌpʌ maiʌcaso dai maisiu Diaavora ʌʌmadu imiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dai isʌmaadutai iduñia ʌliada ʌmo istumaasi soimaascami gʌvuupujicʌdʌ baiyoma gʌaagai ispoʌliada ʌgai ismaivuupuju. Siooma ʌrcʌʌgai ispoʌliada ʌgai ismaivuupuju dai maisiu Diaavora ʌʌmadu imiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Cʌʌgacʌrʌ avʌr nʌijada aapimʌ vʌʌscatai ismaacʌdʌ giñvaavoitudagi. Aanʌ angʌnaagidi sai Diuusi tʌtʌaañicarudʌ ismaacʌdʌ tʌvaagiʌrʌ daraaja Diuusi ʌʌmadu cʌʌga nuucada ʌgai ismaacʌdʌ giñvaavoitudai tami oidigi daama. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Dai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami divia dai cʌʌgacʌrʌ vuvaida iñagai soimaasi ivuaadami ʌgai ʌrsibʌ iimiadʌ Diuusi vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Isʌmaadutai viaacagi ʌmo siento cañiiru vai sibʌ imiagi ʌmoco siaadʌrʌ maianaasi viaana ʌgai ʌgaa maaco coobai dan baivustaama dan tustaama dai gaagamuna ʌsibʌimiaadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dai istʌgiagi sʌʌlicʌdʌ vaamioma baigʌʌliatugadagi ʌgaicʌdʌ siʌgaa ismaacʌdʌ maisibʌ iimiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Poduucai ʌʌpʌ Diuusi gʌrooga tʌvaagiʌrʌ daja dai ʌgai maitipʌlidi isiimiagi Diaavora ʌʌmadu tomali ʌmoco ismaacʌdʌ giñvaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Isʌmaadutai soimaasi duiñdagi ʌmai, ʌgai gʌaagai isaagidagi ʌʌgi ʌgai sai soimaasi duñi. Dai isʌgai cʌʌga baiduñia ʌliadagi ñiooqui aidʌ gia ʌrgʌnaadunumʌcamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dai isʌgai maibaiduñia ʌliadagi aidʌ gia gʌaagai isvaidaquiagi ʌmoco siʌʌpʌ gooca gʌaaduñi vai poduucai oidacana nʌijadami ismaitipʌlidi ʌgai isbaiduñiagi ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dai isapiaquiaa maibaiduñia ʌliada ʌgai aidʌ gia gʌaagai isaagidagi vʌʌsi ʌvaavoitudadami, dai isapiaquiaa maibaiduñia ʌliada ʌgai aidʌ gia gʌaagai isʌpan duucai nʌijadagi ʌgai ismaacʌdʌ maivaavoitudai siʌʌpʌ ʌpan duucai tumiñsi vuudami. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Dai aanʌ angʌnaagidi sai siʌʌscadʌ aagiada aapimʌ Diuusi ñiooquidʌ ʌoodami tomasioorʌ sioorʌ maitiñvaavoitudagi aagiditai aapimʌ ʌgai maidagitomu aanʌ isvaquiagi tʌvaagiʌrʌ, dai tomasioorʌ sioorʌ giñvaavoitudagi aagiditai aapimʌ ʌgai gia dagitomu aanʌ isvaquiagi tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Dai aanʌ angʌnaagidi ʌʌpʌ sai isgoocatai aapimʌ gʌnaagidagi dai daañiagi isDiuusi gʌnsoiñagi, Diuusi gʌrooga gʌnsoiñamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tomasiaaco siaaco gʌnʌmpaidadagi gooca siʌʌpʌ vaica dai giñsiaa duutuada agadagi dai gamamadada agadagi ami daacamu aanʌ ʌʌpʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amaasi ii ʌPiiduru dai tʌcacai ʌSuusi daidʌ itʌtʌdai: ―Tʌaanʌdami, ¿vʌʌquiojo imidagai gʌaagai isoigʌldada aanʌ ʌmoco giñaduñi ismaacʌdʌ soimaasi giñvuiidadagi? ¿Parʌ cuvaracamiojo? ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Chu aanʌ anmaitʌaagidi sai cuvaracamiojo baiyoma angʌaagidi aanʌ sai maiʌcaldacai gaoigʌliada. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Isducatai ʌpʌvueeyi siʌʌscadʌ Diuusi soicʌdagi oodami iscʌʌga gʌntʌtʌgitocagi ʌpan ducami istumaasi idui ʌmo tʌaanʌdami. Ʌtʌaanʌdami ipʌliditadai isʌpipiooñigadʌ aa namʌquidagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Utudama gʌaagacai taañimi ʌgai gʌpipiooñiga ismaacʌdʌ vupuaatulditadai mʌtai vuaapi ʌmo piooñigadʌ ismaacʌdʌ mui mil vuaatulditadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Daidʌ ʌpiooñigadʌ maiviaacatadai istucʌdʌ aa namʌquidagi. Taidʌ ʌaamudʌ aagidi sai gagaarana vʌʌsi gʌvustuidaga dai gʌmaamara dai gʌooñiga dai ʌʌgi ʌgai dai vuvaidana tumiñsi dai ʌcʌdʌ aa namʌquidana. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Amaasi ʌpiooñigadʌ gʌtootonacʌdʌ cʌquiva gʌaamu vuidʌrʌ dai daañimi daidʌ itʌtʌdai: “Giñaamu giñnʌnʌracañi aapi gʌaa namʌquidamu aanʌ vʌʌsi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Taidʌ ʌaamudʌ soigʌʌʌli dai oigʌli dai camaitaí aidʌ, dai dagito isimiagi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tai ii ʌgai dai moo maigovai tʌʌ ʌmoco gʌaduñi ismaacʌdʌ vuaatulditadai chiʌʌqui tumiñsi. Dai cuchivuana bʌi dai cayoga vuliji daidʌ itʌtʌdai: “Aata giñnamʌquida pʌsmaacʌdʌ giñvuaatuli”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Amaasi ʌaduñdʌ gʌtootonacʌdʌ cʌquiva ʌgai vuidʌrʌ dai daañimi daidʌ itʌtʌdai: “Giñnʌnʌracañi aapi gʌaa namʌquidamu aanʌ vʌʌsi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Taidʌ ʌgʌmai maitipʌli, baiyoma vaidacai dai gatʌjai maisaragai dai gaaagidi mʌsai anaasi maisacana asta siʌʌscadʌ aa namʌqui ʌgai vʌʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Amaasi ʌgaa pipiooñigadʌ ʌgʌʌ tʌaanʌdami tʌʌ gomaasi dai sʌʌlicʌdʌ soigʌnʌʌli dai iji dai mʌʌ aagidi ʌtʌaanʌdami vʌʌsi istumaasi ʌpʌdui. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Amaasi ʌtʌaanʌdami gatʌjai mʌsai mʌʌ vaidana ʌgai daidʌ itʌtʌdai: “Aapi gia sʌʌlicʌdʌ maicʌʌ tuiga. ¿Duucaidʌ aanʌ gʌoigʌli vʌʌsi pʌsmaacʌdʌ giñvuaatulditadai aapi, giñdaañimi aapi cascʌdʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Duucaidʌ aapi maisoigʌʌli gʌaduñicʌdʌ, poduucai isduucai soigiñʌli aanʌ aapicʌdʌ?” astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dai sʌʌlicʌdʌ baamu ʌaamudʌ dai gatʌjai maisaragai dai gaaagidi mʌsai anaasi maisacana asta siʌʌscadʌ aa namʌqui ʌgai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Cuugatʌrʌ povʌrtʌtʌdai ʌSuusi: ―Poduucai iduñia agai gʌrooga tʌvaagiʌrʌ aapimʌcʌdʌ issʌʌlicʌdʌ maitʌnoigʌliada aapimʌ aipacoga ―gʌrtʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Caaagacai ʌSuusi imaasi ii ami Galileeaiñdʌrʌ dai aayi mʌʌ Judeea dʌvʌʌriʌrʌ vaasadʌrʌ Jordán aqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dai mui oodami oiditadai tai ami duduaadi ʌSuusi coococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amaasi ʌʌmoco fariseo miaadʌrʌ guuquiva siaaco daacatadi ʌSuusi dai mossoimaasi ñiooquituda ʌlidi ʌgai cascʌdʌ tʌcacai daidʌ itʌtʌdai: ―¿Oidagasi oigaragai siʌmo cʌʌli dagituagi gʌooñiga tomastucʌdʌ? ―tʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Aapimʌ canʌidi Diuusi ñooquidʌ siaaco oojisi sai aidʌsi Diuusi idui oodami idui ʌgai cʌʌli dai ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dai Diuusi ñiooquidʌrʌ icaiti ʌʌpʌ: “Cascʌdʌ cʌcʌʌli dagitomu gʌndʌʌdʌ dai ʌʌmadu oidacamu gʌooñiga dai vʌgoocatai ʌmo oodami gʌnducamicamu ʌgai”, asduucai oojisi Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cascʌdʌ ʌmo cʌʌli maitʌaagai isdagituagi gʌooñiga tomali ʌmo ooqui gʌcuuna. Diuusi ipʌlidi isʌmapai oidaca ʌgai asta siʌʌscadʌ coi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Amaasi tʌcacai ʌfariseo daidʌ itʌtʌdai: ―¿Tuisidʌ Moseesacaru gamaa oigaragai isʌmo cʌʌli dagitua ʌliada gʌooñiga saidʌ istutuidi isbaiduñiagi ʌmo oojai dudunucamiʌrʌ dai poduucai dagituagi? ―tʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Taidʌ ʌSuusi itʌtʌdai: ―Gʌnʌʌqui aaduñicaru vuidʌrʌ vʌʌtʌcana Diuusi cascʌdʌ Moseesacaru maa ʌgai oigaragai isdadagitoda gʌnooñiga dai poduucai gʌnviituldi ʌgai. Dʌmos tucamʌrʌ maitiipucatadai oigaragai poduucai. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dai aanʌ angʌnaagidi sioorʌ dagituagi gʌooñiga maigogoosi gʌducamicatai ʌgai dai vʌʌnagi ʌmai ooqui ʌgai gia gogoosi gʌducami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Amaasi aatʌmʌ mamaatʌrdamigadʌ tʌtʌdai: ―Siʌrvaavoi ismaitiipu oigaragai isdagituagi ʌmo cʌʌli gʌooñiga aidʌ gia siooma ʌrcʌʌga ismaicuucuntadagi oodami ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Maisiu vʌʌscatai istutuidi ismaiooñtadagi mosʌca ʌgai ismaacʌdʌ Diuusi soicʌi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ʌʌmo cʌcʌʌli maiooñtai soimaa vuvacʌi ʌgai cascʌdʌ dai aa mʌscacaapuñtudagi maiooñtai, dai aa maiooñtai aipaco ajioopaitai gaaagiada ʌliditai isducatai Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana. Tomasioorʌ sioorʌ istutiadagi ismaiooñtadagi cʌʌgadu ismaiooñiacatai oidaca ʌgai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mʌtai aidʌ vuaapi ʌSuusi chiʌʌqui aali sai taatana ʌgai moomodʌ dai mamatuldana. Taidʌ aatʌmʌ mamaatʌrdamigadʌ ʌgai bagaidimi ʌoodami ismaacʌdʌ vuaapaimi ʌaali. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Dagitovurai goaali vai dadana siaaco daja aanʌ dai maitavʌr daidiada. Ismaacʌdʌ ʌpan ducami aali ʌgai gia Diuusi soicʌi ʌgai sai cʌʌga gʌntʌtʌgitocana ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Daidʌ ʌSuusi taata ʌaali moomodʌ dai gooquiʌrʌ ii abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ʌmo gʌʌli ii dai mʌʌ nʌidamu ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldadami cʌʌ tuigacʌdʌ. ¿Tumaasi istutuidi aanʌ isiduñiagi dai vʌʌscʌrʌ oidacagi Diuusi ʌʌmadu? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Taidʌ ʌSuusi itʌtʌdai: ―¿Tuipʌsi cʌʌ tuigacʌdʌ giñaagai? Aliʌmadugava cʌʌ tuigacami dai ʌgai ʌrDiuusi. ¿Ipʌlidipʌsi isimiagi Diuusi ʌmaadu? ʌʌgiditai caʌca vʌʌsi istumaasi aagai Diuusi ñiooquidʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Taidʌ ʌgʌʌli itʌtʌdai: ―¿Tumaasi ʌgai? ―tʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Maitavʌr gacoodada, dai maitavʌr googosi gʌnducamica, dai maitavʌr gaʌʌsiada gavustuidaga, dai maitavʌr yaatavoaca, ");
INSERT INTO ntpNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","dai siaa duutuada gʌndʌʌdʌ dai oigʌadavurai gʌnaaduñi poduucai mʌsduucai gʌnoigʌdai aapimʌ ʌʌgi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Taidʌ ʌgʌʌli itʌtʌdai: ―Vʌʌsi gomaasi ansiaa duutudai aanʌ aliducatai abiaadʌrʌ. ¿Tumaasi viʌʌga isiduñia aanʌ? ―tʌtʌdai ʌgʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Taidʌ ʌSuusi itʌtʌdai: ―Ipʌlidipʌsi isiduñiagi vʌʌsi istumaasi Diuusi ipʌlidi aidʌ gia imiñi dai gagaara vʌʌsi pʌstumaasi viaa dai oida ʌtumiñsi ʌsoituutuigami dai poduucai viaacamu aapi mui naana maasi tʌvaagiʌrʌ dai gooquiʌrʌ divia dai giñoidatucuda ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dai aidʌsi moscaʌ ʌgʌʌli gomaasi aliʌ soigʌʌli dai soigʌʌliatugai aliʌsi ʌrgʌviidacamicatadai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Amaasi ʌSuusi povʌrtʌtʌdai aatʌmʌ mamaatʌrdami: ―Gia sijaiga isgʌnviipidacami dagituagi isDiuusi soicʌdagi iscʌʌga gʌntʌtʌgitocagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dai aanʌ angʌnaagidi ʌʌpʌ sai siooma maisijaiga ʌmo muura vʌʌtarʌ isvaquiagi ʌmo oi dʌgadʌamu sʌʌli isʌmo gʌviidacami dagitoagi isDiuusi soicʌdagi iscʌʌga gʌtʌgitocagi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mosaagai ʌSuusi gomaasi tʌtai aatʌmʌ mamaatʌrdami maitʌʌ isducatai gʌrtʌtʌgituagi dai aipaco gʌrtʌcacai daidʌ icaiti: ―¿Voorʌ istutuididʌo iscʌʌgacʌrʌ vuvaquiagi? ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Taidʌ ʌSuusi gʌrvui nʌnʌava dai povʌrtʌtʌdai: ―Oodami gia maitistutuidi isiduñiagi imaasi dʌmos Diuusi gia istutuidi isiduñiagi. Diuusi vʌʌsiaʌcatai istutuidi isiduñiagi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Amaasi ʌPiiduru itʌtʌdai: ―Tʌaanʌdami, aatʌmʌ viaa vʌʌsi tʌstumaasi viaacatadai gʌoidatucuda ʌrʌliditai, ¿tumaasi viaacamu aatʌmʌ? ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Taidʌ ʌSuusi aa noragi dai povʌrtʌtʌdai: ―Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi, siʌʌscadʌ Diuusi utuldagi vʌʌsi istumaasi dai siʌʌscadʌ aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami gatʌaanʌdagi daacatai ʌmo daicarui dadadacʌdamiʌrʌ aapimʌ ʌʌpʌ ismaacʌdʌ giñoidatucudagi gatʌaanʌdamu ʌʌpʌ ʌchigiamaasi daraicarʌrʌ daraajatai. Aapimʌ baivustaama dan goocadu dai ʌmoco tʌaanʌdamu Ruvenicaru cajiudadʌ, dai gʌmai tʌaanʌdamu Danacaru cajiudadʌ, dai gʌmai tʌaanʌdamu Gadacaru cajiudadʌ, dai gʌmai tʌaanʌdamu Nefatalicaru cajiudadʌ, dai gʌmai tʌaanʌdamu Aseracaru cajiudadʌ, dai gʌmai tʌaanʌdamu Isaacaru cajiudadʌ, dai gʌmai tʌaanʌdamu Judacaru cajiudadʌ, dai gʌmai tʌaanʌdamu Zavulonicaru cajiudadʌ, dai gʌmai tʌaanʌdamu Simioñicaru cajiudadʌ, dai gʌmai tʌaanʌdamu Benjamiñicaru cajiudadʌ, dai gʌmai tʌaanʌdamu Efraíñicaru cajiudadʌ, dai gʌmai tʌaanʌdamu Manaasesicaru cajiudadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dai tomasioorʌ sioorʌ dagituagi gʌvustuidaga siʌʌpʌ gʌaaduñi ivuaadatai giñaa duiñdaga ʌgai viaacamu ʌmo siento vaamioma dai siʌʌscadʌ imiagi ʌgai idi oidigiaiñdʌrʌ vʌʌscʌrʌ oidacamu ʌgai Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dai mʌʌca siaaco tʌaanʌi Diuusi muidutai ismaacʌdʌ vaamioma tʌaanʌi tami, mʌʌca siooma maitʌaanʌdamu dai ismaacʌdʌ siooma maitʌaanʌi tami mʌʌca vaamioma tʌaanʌdamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Isducatai ʌpʌvueeyi siʌʌscadʌ Diuusi soicʌdagi oodami sai cʌʌga gʌntʌtʌgitocana ʌrʌpan ducami istumaasi idui ʌmo cʌʌli ismaacʌdʌ gʌʌpi viaacatadai dʌvʌʌrai ʌʌqui quiaamoco ii ʌgai dai gaaga agai pipiooñi sai yoovana uuvasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dai baidui ʌgai gʌpipiooñiga ʌʌmadu sai ʌmo coobai piisu aa namʌquida agai ʌmo tasaicʌdʌ. Dai otoma ootoi sai mʌʌca gayoovana. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dai laascʌdioma ii ʌcʌʌli plaasamu dai mʌʌca tʌʌ aa oodami mosdaraacami, ");
INSERT INTO ntpNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","daidʌ itʌtʌdai: “Iimʌdavurai dai gaaata duñi giñʌʌsiʌrʌ dai aanʌ gʌnaa namʌquidamu siʌʌsi cʌʌgaducagi”, astʌtʌdai. Tai ʌgai iji. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dai dan duucu ʌpamu ii ʌʌsʌcami dai ʌpua ootoi aata vuaadami, dai coi gʌʌsʌcai tasai ii ʌgai dai ʌpua ootoi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dai cauruñimodʌ ii ʌgai plaasamu dai mʌʌca tʌʌ aa oodami ismosdaraaja daidʌ itʌtʌdai: “¿Tuimʌsi mosdaraaja ʌmo tasai dai maitaaata vueeyi?” astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Taidʌ ʌoodami itʌtʌdai: “Tomali ʌmaadutai maitʌrmamacai aa duiñdagai cascʌdʌ”, astʌtʌdai. Amaasi itʌtʌdai ʌʌʌsʌcami: “Iimʌdavurai aapimʌ vʌʌsi dai mʌʌca aata duuñi giñʌʌsiʌrʌ dai aanʌ gʌnaa namʌquidamu siʌʌsi cʌʌgaducagi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dai caaʌcai siuu duucu gʌnʌʌpidagi ʌpipiooñi taidʌ ʌʌʌsʌcami aagidi ʌgai ismaacʌdʌ tʌaanʌi ʌpipiooñi daidʌ itʌtʌdai: “Baigovai vaida goaata vuaadami dai aa namʌquida. Gʌaagacai aa namʌquida ʌʌpʌga ismaacʌdʌ gooquiʌrʌ gʌnaaga dai ismaacʌdʌ ʌʌpʌga gʌnaaga vʌʌsia gooquiʌrʌ aa namʌquida aapi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Amaasi dada ʌgai ismaacʌdʌ gooquiʌrʌ gʌnaagacai gaaata dui mʌtai ʌʌmo coobai piisu aa namʌqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dai gooquiʌrʌ caaa namʌquida agai ismaacʌdʌ ʌʌpʌga gʌnaagacai gaata dui vai ʌgai povʌnʌliditadai mʌsi vaamioma aa namʌquida agaitadai, mʌtai ʌgai ʌʌmo coobai piisu aa namʌqui ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dai aidʌmʌsi mosaa namʌqui vai ʌgai ñiooquimi ʌʌʌsʌcami vui. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Daidʌ itʌtʌdai: “Goovai ismaacʌdʌ gooquiʌrʌ gʌnaaga ali ʌmo oora aata dui mʌtai vʌʌscʌrʌ gʌrʌpan ʌʌsi aa namʌqui dai aatʌmʌ ʌmo tasai soimaa taata toiñdagai”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Taidʌ ʌaamudʌ aa noragi daidʌ itʌtʌdai ali ʌmoco ʌʌgi ʌgai: “Giñaduñi aanʌ maisoimaasi gʌvuiididi. ¿Maitasiʌrvaavoi iñsaanʌ gʌnaagidi sai ʌmo coobai piisu gʌnaa namʌquiada iñagaitadai isgaaata duñia aapimʌ giñʌʌmadu? ");
INSERT INTO ntpNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Naa, gʌaa namʌquidaraga imʌdañi. Aanʌ ipʌlidi isgʌnʌʌpan ʌʌsi maquiagi goovai ismaacʌdʌ gooquiʌrʌ gʌnaaga. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Maitisviaa aanʌ sʌʌlicami isiduñia giñtumiñsigacʌdʌ istumaasi ipʌliadagi? ¿Tuipʌsi muuquimudadʌ caiti aapi nʌiditai iscʌʌga dui aanʌ gogaa vʌʌtarʌ?” astʌtʌdai ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Poduucai ismaacʌdʌ ʌoodami soi duu nʌidi tami oidigi daama vaamioma namʌga mʌʌca siaaco tʌaanʌi Diuusi, dʌmos ismaacʌdʌ poʌlidi isvaamioma namʌga tami oidigi daama ʌgai gia maisii namʌacamu siaaco tʌaanʌi Diuusi. Diuusi ñiniooquituldadamigadʌ aagidi mui oodami saidʌ istutuidi iscʌʌgacʌrʌ vuvaquiagi dʌmos Diuusi chiʌʌqui ʌʌco vuvaitu ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dai ʌmo imidagai voiyamu imʌitadai ʌSuusi catʌsadimi Jerusaleenamu daidʌ ʌSuusi ʌcovai gʌrvaí aatʌmʌ baivustaama dan gooca mamaatʌrdamigadʌ ʌgai dai povʌrtʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Aapimʌ nʌidi tʌscatʌʌtʌidimi aatʌmʌ Jerusaleenʌrʌ mʌsiaaco giñtʌʌgida agai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami giñtʌʌgida magai ʌbaitʌguucacamigadʌ papaali ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami isʌgai gatʌaañimu mʌsaidʌ giñmuaana, ");
INSERT INTO ntpNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","dai giñtʌʌgidamu ʌgai aa sibʌadʌrʌ oidacami ismaacʌdʌ maitʌrjudidíu siʌgai giñparunadamu dai saasasamu giñtuucuga dai giñsiisamu curusiaba. Dai bovaica tasaicʌdʌ ʌpamu duaacamu aanʌ coidadʌ saagidaiñdʌrʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Amaasi ʌJacovo dai ʌVuaana ʌʌmadu ʌdʌʌdʌ miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi. ɅJacovo dai ʌVuaana ʌrSevedeo maamaradʌ. Taidʌ ʌdʌʌdʌ gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Tumaasi aagai aapi? ―tʌtʌdai ʌgai. Tai ʌgai itʌtʌdai: ―Siʌʌscadʌ aapi vʌʌsia daama ʌrgabaitʌcʌaacamicagi giñoigʌdacai darasa aapi giñmaamara vaidʌ ʌrtʌtʌaanʌdamicana goovai ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aapimʌ maimaatʌ mʌstumaasi giñaagidi. ¿Baisistuidʌna aapimʌ issoimaa taatagi siʌʌ soimaa taata iñagai aanʌ? ―tʌtʌdai ʌSuusi. Tai ʌgai itʌtʌdai: ―Istutuidiatʌta ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Taidʌ ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ ʌrvaavoi. Aapimʌ gia soimaa taatamu siʌʌsi soimaa taata iñagai aanʌ dai vʌʌscʌrʌ aanʌ maitistutuidi isdaraasagi tʌtʌaanʌdami baiyoma ʌʌgi Diuusi gʌrooga daraasamu tʌtʌaanʌdami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aidʌsi aatʌmʌ baivustaama cai gomaasi aliʌ baacoi aatʌmʌ ʌgaa gooca gʌraaduñi vui. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Taidʌ ʌSuusi gʌrvaí aatʌmʌ dai povʌrtʌtʌdai: ―Cʌʌ maatʌ aapimʌ sai ismaacʌdʌ maitʌrjudidíu saagida ʌbaitʌcʌaacami gʌpipiooñiga duucai nʌidi gʌaaduñi dai ismaacʌdʌ vaamioma gatʌaanʌi sʌʌlicʌdʌ tʌtʌaañicui. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Dʌmos aapimʌ gʌnsaagida maitʌaagai ispoduucai ivuaadagi baiyoma sioorʌ ʌrbaitʌcʌaacamicagi gʌaagai issoicʌdagi vʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Poduucai isduucai ivueeyi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. Aanʌ gia divia oidigʌrʌ maisiu isgiñsoicʌdagi aa baiyoma divia aanʌ dai soicʌdʌ iñagai oodami dai muquia iñagai vai poduucai cʌʌgacʌrʌ vuvacʌna mui oodami ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aidʌsi vuvaquimi aatʌmʌ Jericooaiñdʌrʌ mui oodami oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Vai voi ugidiana daraajatadai gooca mainʌnʌaadami. Dai maí ʌgai isami daivusai ʌSuusi dai iiñoqui daidʌ itʌtʌdai: ―Davi cajiudadʌ ismaacʌdʌ Diuusi maa ʌmo sʌʌlicami soigi gʌʌlda aapi aatʌmʌcʌdʌ ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Taidʌ ʌoodami bagaimi sai camaiiiñacaiña vaamioma. Dʌmos ʌgai vaamioma iiñacai daidʌ itʌtʌdai: ―Tʌaanʌdami, Davi cajiudadʌ ismaacʌdʌ Diuusi maa ʌmo sʌʌlicami soigi gʌʌlda aatʌmʌcʌdʌ ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Amaasi ʌSuusi cʌquiva dai vaí ʌmainʌnʌaadami dai tʌcacai daidʌ itʌtʌdai: ―¿Tumaasi ipʌlidi aapimʌ isgʌnduiñda aanʌ? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Tʌaanʌdami, nʌada ʌrʌlidi aatʌmʌ ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Amaasi ʌSuusi soigʌʌli ʌgaicʌdʌ dai taata vuupuidʌ. Tai bovasdʌrʌ ʌismaacʌdʌ mainʌnʌaitadai istui isnʌnʌavagi dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aidʌsi camiaadimitadai ʌSuusi Jerusaleenʌrʌ aayi Betapagiʌrʌ miaanai ʌgiidi siaaco Oliivosi tʌʌgidu, ʌSuusi ootoi gooca gʌmamaatʌrdamiga, ");
INSERT INTO ntpNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dai potʌtʌdai: ―Iimivurai mʌʌ aali quiiquiʌrʌ ismaacʌdʌ mʌʌmojoro guuca dai aʌcai tʌʌgimu aapimʌ ʌmo asñiitu maracami vulicami vʌrai uupana dai vuaapa vʌgoocai. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dai isʌmaadutai gʌnaagidagi mʌsai maiuupanana vʌrai potʌʌda ansai aanʌ tʌgito dai ansai otoma ʌpamu ootosda iñagai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Poduucai ʌpʌdui saidʌ ʌpʌduuna ismaacʌdʌ aagai Diuusi ñiooquituldadamigadʌ dai poduucai ooja: ");
INSERT INTO ntpNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Aagidavurai Jerusaleenʌrʌ oidacami dai potʌʌda: “Dañi bʌrimʌi gʌraí. Maigʌducʌdʌ gʌʌlidi goovai, ʌmo asñiitu mara daama daitugai”, astʌʌda. Asduucai ooja Diuusi ñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Amaasi ʌmamaatʌrdamigadʌ iji daidʌ idui isducatai aagidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dai vuaa ʌasñiitu ʌʌmadu ʌmaradʌ dai ʌgai daama darai gʌnsosuaa dai daama daí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dai voiyʌrʌ ajioopaitadai mui oodami ismaacʌdʌ voiyʌrʌ ʌʌligaimi gʌnsosuaa dai aa guicuma uusi maamaradʌ dai voiyʌrʌ tuajaimi sai daama daivunʌna ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dai ʌgai ismaacʌdʌ baitʌqui iimʌitadai dai ismaacʌdʌ gooquiʌrʌ iimʌitadai iiñaquimi daidʌ icaitimi: ―Aliʌ cʌʌ tuiga goraí Davi cajiudadʌ ismaacʌdʌ Diuusi maa ʌmo sʌʌlicami. Diuusi aliʌ cʌʌgacʌrʌ nʌidi goovai ismaacʌdʌ divia Diuusi guvucadadʌcʌdʌ. Sʌʌlicʌdʌ cʌʌga tuiga Diuusi ―caitimi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aidʌsidʌ ʌSuusi vaa Jerusaleenʌrʌ vʌʌsi ʌoodami sisioli dai muidutai aipaco gʌntʌcacai daidʌ icaiti: ―¿Sioorʌ goovai? ―caiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Vai aa aagidi daidʌ itʌtʌdai: ―Gooviava ʌrSuusi Diuusi ñiooquituldadamigadʌ daidʌ ʌrNasareetʌrʌ oidacami Galilea dʌrʌʌriʌrʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tai gooquirʌ vaa ʌSuusi ʌgʌʌ quiuupaigadʌ tuisicʌrʌ siaaco siaa duutudai Diuusi dai vuvaitu ʌjudidíu ismaacʌdʌ ami gagaagaraitadai dai ismaacʌdʌ gasaapʌdaitadai. Dai aipaco suuli memesagadʌ ʌgai ismaacʌdʌ cambiando ʌjudidíu quiuupaigadʌ tumiñsigadʌ dai aipaco suuli daraicarudʌ ismaacʌdʌ gagaagaraitadai tutuugu. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Daidʌ itʌtʌdai: ―Diuusi ñiooquidʌrʌ aduucai oojisi: “Ʌgʌʌ quii ismaacʌdʌ idui ʌoodami dai ami giñsiaa duutuada agai itʌʌgiducamu quii mamaadaragai vʌʌtarʌ”, mai aapimʌ ʌʌsivogami tʌjogadʌ duucai nʌidi ―tʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tai ami ʌgʌʌ quiuupaigadʌrʌ judiuíu ʌʌmoco mainʌnʌaadami ʌʌmadu chuchuecogami miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi tai ʌgai duduaadi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dai aidʌsi ʌbaitʌguucacamigadʌ papaali ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ nʌidi ʌistumaasi gʌʌducʌdʌ ismaacʌdʌ idui ʌSuusi dai aidʌsi caʌ isducatai iiñacai ʌaali ʌgʌʌ quiuupiʌrʌ daidʌ icaiti: “Aliʌ cʌʌ tuiga goraí Davi cajiudadʌ ismaacʌdʌ Diuusi maa ʌmo sʌʌlicami”, caiti ʌaali. Ʌbaitʌguucacamigadʌ papaali ʌʌmadu ʌmamaatʌtuldadami Diuusi sʌʌlicamigadʌ sʌʌlicʌdʌ baacoi ʌSuusi vui, ");
INSERT INTO ntpNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","daidʌ itʌtʌdai ʌgai ʌSuusi: ―¿Maitapʌscaʌ istumaasi aagai goaali? Dodoligitudañi aapi ―tʌtʌdai. Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌjʌ caʌana. Dai canʌidi aapimʌ isduucai oojisi Diuusi ñiooquidʌrʌ daidʌ icaiti: Aali aliʌ cʌʌga ñioocada agai Diuusi vui. Ascaiti Diuusi ñiooquidʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Amaasi ʌSuusi anaasi viaa dai ii Jerusaleenaiñdʌrʌ Betaaniamu dai anaasi siaa. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dai siaadiqui caʌpamu ajacoga imʌitadai ʌSuusi Jerusaleenamu dai biuugimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dai tʌʌ ʌmo iigosi dʌʌdʌ voi ugidiana dai abaana cʌquiva dai maitʌʌ iigosi mosʌca aagadʌ. Daidʌ ʌSuusi itʌtʌdai ʌiigosi dʌʌdʌ: ―Aapi gia tomali ʌmo imidagai maiiibiatamu ―tʌtʌdai ʌSuusi. Tai otoma gaquisa ʌiigosi dʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dai aidʌsi tʌʌ aatʌmʌ mamaatʌrdami gomaasi camaitʌʌ istumaasi gʌrtʌtʌgituagi dai tʌcacai ʌSuusi daidʌ itʌtʌdai: ―Ducatai mosʌʌ otoma gaquisa goiigosi dʌʌdʌ ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Taidʌ ʌSuusi gʌraa noragi dai povʌrtʌtʌdai: ―Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi. Iscʌʌga vaavoitudadagi aapimʌ maisiu mosʌcaasi istutiadamudai isiduñia gomaasi ismaacʌdʌ idui aanʌ goiigosi dʌʌdʌcʌdʌ asta istutiadamudai aapimʌ ʌʌpʌ isivuaadagi naana maasi istumaasi sʌʌlicʌdʌ sijiacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dai vʌʌsi istumaasi taanʌi aapimʌ Diuusi mamadaitai issʌʌlicʌdʌ vaavoitudada aapimʌ Diuusi gʌnmaaquimu ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Amaasi ʌSuusi vaa ʌgʌʌ quiuupaigadʌrʌ judidíu dai ami gamamaatʌtulditadai Diuusi ñiooquidʌ tai miaadʌrʌ guuquiva ʌbaitʌguucacamigadʌ papaali daidʌ ʌtʌtʌaanʌdami judidíu dai tʌcacai daidʌ itʌtʌdai: ―¿Tuma sʌʌlicamicʌdʌ vuvaitu aapi ʌjudidíu tabiaadʌrʌ? ¿Toorʌ gʌmaa gosʌʌlicami? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aanʌan ʌʌpʌ gʌntʌcacagi ʌmo istumaasi mʌscʌʌga giñaa noragidagi istumaasi gʌntʌcaca iñagai aanʌ nai aanʌ ʌʌpʌ gʌnaagidagi istumaasi sʌʌlicamicʌdʌ ivueeyi aanʌ gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Toorʌ ootoi ʌVuaana sai vapaconana oodami Diuusi oodami sio? Aago vʌrai iñnoragida ―tʌtʌdai ʌSuusi. Vai ʌgai ʌʌgi aipaco gʌnaatagidi dai pocaiti: ―Ispotʌʌda aatʌmʌ sai Diuusi ootoi goovai gʌraa noragidamu dai povʌrtʌʌdamu: “¿Tuimʌsi maivaavoitu?” ");
INSERT INTO ntpNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dai ispotʌʌda aatʌmʌ sai oodami ootoi, gʌrvui baacoimu gooodami. Goovai sʌʌlicʌdʌ vaavoitudai siʌVuaana ʌrDiuusi ñiooquituldiadamigadʌ cascʌdʌ ―caiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dai amaasi itʌtʌdai ʌgai ʌSuusi: ―Maitatʌmaatʌ aatʌmʌ ―tʌtʌdai ʌgai. Amaasi ʌSuusi itʌtʌdai: ―Tomali aanʌ anmaitʌnaagidagi istumaasi sʌʌlicamicʌdʌ ivueeyi aanʌ gomaasi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Daidʌ ʌSuusi itʌtʌdai: ―Ʌmo cʌʌli maamaracatadai gooca, daidʌ itʌtʌdai ʌmoco gʌmara: “Giñmara imʌdañi sivi dai mʌʌ yoova uuvasi giñʌʌsi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Taidʌ ʌmaradʌ aa noragi daidʌ itʌtʌdai: “Aanʌ maiimia iñʌlidi”, astʌtʌdai. Dai gooquiʌrioma gia caʌma duucai gʌtʌgito ʌgai dai mʌʌca aata duñimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Taidʌ ʌoogadʌ ii dai mʌʌ aagidi ʌgʌmai gʌmara dai potʌtʌdai ʌʌpʌ. Tai ʌgai itʌtʌdai: “Ʌjʌʌ”, astʌtʌdai. Dai maiii. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Maacʌdʌ vʌgoocatai idui istumaasi tʌgitocatadai ʌoogadʌ? ―tʌtʌdai ʌSuusi. Tai ʌgai itʌtʌdai: ―Ʌʌpʌgadadʌ ―tʌtʌdai ʌgai. Amaasi ʌSuusi itʌtʌdai: ―Ismaacʌdʌ aanʌ gʌnaagidi ʌrvaavoi. Sai ʌtumiñsi vuudami daidʌ ʌooqui taatacaligami caʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada aagai vaavoitudacai istumaasi aagai ʌVuaana. Diuusi soicʌiña ʌgai sai cʌʌga gʌntʌgitocana. Dai aapimʌ gia cho. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ɅVuaana ismaacʌdʌ vapaconaitadai ʌoodami gʌnmamaatʌtuldi isducatai gʌaagai isoidacagi mʌtai aapimʌ maiʌma duucai gʌntʌtʌgito maivaavoitudacai tomasi nʌidi aapimʌ isʌgaa oodami sʌʌlicʌdʌ vaavoitu. Poduucai aapimʌ maidadagitoi isDiuusi gʌnsoicʌidagi iscʌʌga gʌntʌgitocagi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Caʌcavurai aapimʌ idi cuento: Ʌmo oodami ismaacʌdʌ viaacatadai dʌvʌʌrai ʌi uuvasi dai sicoli curarai daidʌ idui siaaco vuusiadagi uuvasi varagadʌ daidʌ idui ʌʌpʌ ʌmo vaaqui tʌcavacami dai abiaadʌrʌ nuucadaca agai vʌʌsi gʌʌʌsi. Dai gooquiʌrʌ taajucamicʌdʌ maa gʌʌʌsi aa oodami dai mʌʌcasi ii. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dai aʌcai yoovaragai ootoi ʌgai chiʌʌqui gʌpipiooñiga sai mʌʌ taanʌna ʌoodami ʌyoovi siʌʌqui aʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Taidʌ ʌoodami vui ʌpipiooñigadʌ dai saasarai tuucugadʌ ʌmoco, dai ʌmai muaa, dai ʌmai maicacarai. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Taidʌ ʌaamudʌ vaamioma muiyoma ootoi situcamidʌrʌ taidʌ ʌoodami poduucai idui ʌgaicʌdʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dai mʌʌ gooquiʌrʌ ootoi ʌgai gʌmara dai povʌ ʌliditadai: “Goovai gia siaa duutudan taada ʌgai”, asʌʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amaasi tʌʌgacai ʌoodami ʌmaradʌ aipaco gʌnaagidi daidʌ icaiti: “Gooviava ʌrʌgai ismaacʌdʌ ajiagai vʌʌsi vustuidadʌ ʌoogadʌ gʌaagai tʌsmuaagi dai poduucai aatʌmʌ ʌrtutuidacamicamu”, ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dai bʌi dai dʌjoi ugidiana vuusaitu dai muaa ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amaasi ʌSuusi tʌcacai ʌoodami daidʌ itʌtʌdai: ―¿Siʌʌscadʌ diviagi ʌtuidacami ʌdʌvʌʌrai istumaasi iduuñimu ʌgai? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tai ʌgai itʌtʌdai: ―Coodamu ʌgai ʌmaicʌʌga tuutiacʌdʌ maisoigʌʌliaracʌdʌ dai taajucamicʌdʌ maaquimu ʌmai gʌdʌvʌʌraga siʌgai gia cʌʌga maacadamu siʌʌsi aajʌdagi ʌgai ―tʌtʌdai ʌtʌtʌaanʌdamigadʌ ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Amaasi ʌSuusi itʌtʌdai: ―Aapimʌ cʌʌ maatʌ isduucai oojisi Diuusi ñiooquidʌrʌ daidʌ icaiti: Ʌsʌʌlicami viaacami ismaacʌdʌ daasi aagai Diuusi ʌtʌtʌaanʌdamigadʌ ʌjudidíu gajiaadʌrʌ viaa agai. Dai ʌgai ʌrʌgai vaa ismaacʌdʌ vaamioma gatʌaanʌda agai Diuusi iduñia gomaasi. Dai gomaasi ʌrʌmo istumaasi cʌʌgaducamicamu ʌgai vʌʌtarʌ ismaacʌdʌ vaavoitudagi. Ascaiti Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cascʌdʌ aanʌ angʌnaagidi sai Diuusi camaitʌnsoiña agai mʌsai cʌʌga gʌntʌtʌgitocana. Aapimʌ vuidʌrʌ vʌʌtʌ ʌgai cascʌdʌ. Baiyoma soiña agai ʌgai sai cʌʌga gʌntʌtʌgitocana ʌoodami ismaacʌdʌ ʌʌgiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dai sioorʌ giñvui vʌʌtʌcagi soimaa taatamu dai aanʌ vui caatʌcamu ʌgai aidʌ gia iimimu ʌgai ʌDiaavora ʌʌmadu ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aidʌsi ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌfariseo cai ʌcuento ismaacʌdʌ aa ʌSuusi, dai gʌntʌgito cai siʌgai aagada mʌʌlidi ʌSuusi ʌcuentocʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dai cascʌdʌ bʌiya ʌliditadai ʌgai ʌSuusi dʌmos ʌʌbʌiditadai ʌgai ʌoodami. Ʌoodami povʌnʌliditadai siʌSuusi ʌrDiuusi ñiooquituldadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Taidʌ ʌSuusi aagidi ʌʌpʌ ʌmo ñiooqui cuentocʌdʌ daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana. Gomaasi ʌrʌpan ducami isducatai idui ʌmo raí ismaacʌdʌ idui ʌmo vagimi aidʌsi ooñigai maradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ootoi ʌgai gʌpipiooñiga sai vuaapana ʌvapaidadʌ taidʌ ʌvapaidadʌ maitipʌli isdadiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tai ʌgai ʌpamu ootoi aa gʌpipiooñiga daidʌ itʌtʌdai: “Aagidavurai giñvapaida sai casi gatʌjai aanʌ coodaragai giñsosoiga giicoligadʌ dai sai cuaadagai cavʌʌsi baigʌduu vai otoma baigovai iimʌna idi cunataragʌrʌ”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dai vapaidadʌ maitaʌʌgi. Ʌmoco mʌʌ nʌidamu gʌdʌvʌʌraga dai ʌmai viaacatadai ʌma maasi isnʌidagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Daidʌ ʌgaa vui ʌpipiooñigadʌ ʌraí dai soi vuujimi dai vʌʌsi coi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Taidʌ ʌraí aliʌ baamu dai ootoi gʌsandaaruga sai mʌʌ coodana ʌgai ʌgacoodacami dai mʌmʌidana baabaquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Amaasi ʌraí itʌtʌdai aa gʌpipiooñiga: “Quiaa baigʌduu gocunataragai dai giñvapaida camaiviaa sʌʌlicami isdadiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iimʌdavurai caayamu dai vapaida vʌʌsi mʌsioorʌ tʌʌgiagi vai dadana idi cunataragʌrʌ”, astʌtʌdai ʌraí. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Taidʌ ʌpipiooñigadʌ aipaco voiyamu iji dai ʌʌmpagi vʌʌsi siʌʌqui tʌʌ oodami cʌʌga tuutiacami dai maicʌʌga tuutiacami dai poduucai suuda ami gʌʌ tuucavi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Taidʌ ʌraí vaa dai nʌnʌidi gʌvapaida dai gʌtʌgito tʌʌ siami cʌaacatadai ʌmoco ismaacʌdʌ maitʌ aadaca yuucusi ismaacʌdʌ maa ʌraí gʌvapaida sai gʌnaadana cunataragʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Daidʌ itʌtʌdai: “¿Ducatai vaa aapi maitʌaadacatai yuucusi ismaasi gʌaadai cunataragʌrʌ?” astʌtʌdai ʌraí. Taidʌ ʌgai maiñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Taidʌ ʌraí itʌtʌdai ʌgai ismaacʌdʌ gabibiditadai: “Vuravurai noonovidʌ dai ʌʌcasodʌ dai quiidigana daasa siaaco tucagamu siami aliʌ soimasi taatacamu goovai dai suaacadamu”, astʌtʌdai ʌraí. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Diuusi ñiñiooquituldiadamigadʌ aagidi mui oodami saidʌ istutuidi iscʌʌgacʌrʌ vuvaaquiagi dʌmos Diuusi chiʌʌqui ʌʌco vuvaitu ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Taidʌ ʌfariseo iji dai gʌnaagi sabai aagatudana ʌgai ʌSuusi ʌmo istumaasi vai poduucai viaaca ʌgai isducatai gʌʌpiʌrʌ vuaajagi dudunucamiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dai cascʌdʌ ootoi ʌfariseo gʌnaaduñi ʌʌmadu ʌʌmoco ʌEroodʌsi aaduñdʌ sai mʌʌ aatagidana ʌSuusi vai ʌgai itʌtʌdai: ―Mamaatʌtuldiadami cʌʌga maatʌ aatʌmʌ sai istumaasi gaaagidi aapi dai gamamaatʌtuldi ʌrvaavoi. Dai maivuaamʌ ʌlidi aapi oodamicʌdʌ siʌrgʌnviipidacami siʌrsoituutuigami ʌʌpʌ, mosgamamaatʌtuldi aapi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gʌraagidañi: ¿Cʌʌgaisi tʌsaa namʌquiada aatʌmʌ gocuota ʌgʌʌ baitʌcʌaacamigadʌ ʌromamano chio sio? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dʌmos ʌSuusi maatʌ tʌʌ isʌgai vuiirumada ʌliditadai dai potʌtʌdai: ―Aapimʌ aagai ʌmo istumaasi dai ʌmamaasi ivueeyi. ¿Tuimʌsi giñvuiirumada ʌlidi aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Giñtʌʌgidavurai ʌmo tumiñsi ismaacʌdʌcʌdʌ aa namʌquidi aapimʌ ʌcuota ʌgʌʌ baitʌcʌaacamigadʌ romamano ―tʌtʌdai ʌSuusi. Tai ʌgai tʌʌgi ʌmo tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Taidʌ ʌSuusi mostʌʌ dai tʌcacai daidʌ itʌtʌdai: ―¿Voorʌ moodʌ dai voorʌ tʌʌtʌaradʌ tumiñsiʌrʌ daja? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Ʌgʌʌ baitʌcʌaacami moodʌ dai tʌʌtʌaragadʌava ―tʌtʌdai ʌgai. Taidʌ ʌSuusi itʌtʌdai: ―Maacavurai ʌgʌʌ baitʌcʌaacami istumaasi ʌrtuidadʌ dai iduuñivurai istumaasi Diuusi ipʌlidi isivuaadagi ʌʌpʌ, ʌgai ʌrʌgʌʌ baitʌcʌaacami tʌvaagiʌrʌ dai oidigʌrʌ ʌʌpʌ cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amaasi caʌ ʌgai imaasi dai maitʌʌ istumaasi gʌntʌtʌgituagi dai dagito dai iji. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ʌgai vaa tasʌrʌ ʌʌmoco saduseo iji siaaco daacatadai ʌSuusi. Ʌsaduseo pocaiti sai maioidaga coidadʌ duaacaradʌ cascʌdʌ potʌtʌdai ʌgai ʌSuusi: ");
INSERT INTO ntpNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mamaatʌtuldiadami, ʌMoseesacaru oojisicami gʌrvii gʌsʌʌlicamiga vai pocaiti sai ismuquiagi ʌmo cʌʌli dai viaagi gʌooñiga maiquiaa maratacai abaana, saidʌ ʌsuculidʌ ʌcʌʌli gʌaagai isvʌʌnagi ʌviuudu dai maratagi abaana ʌsiʌʌgidʌ vʌʌtarʌ ismaacʌdʌ muu. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dai tami gʌrsaagida oidacatadai cuvaracami ʌmo siʌʌgʌmʌ. Dai ʌʌpʌgadadʌ ooñigai dai muu maiquiaa maamatacai. Tai gooquiʌrʌ ʌgʌmai vʌʌna ʌviuudu dai muu ʌʌpʌ maiquiaa maamatacai. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tai gooquiʌrʌ ʌgʌmai vʌʌna ʌgai vaa ooqui dai muu ʌʌpʌ maiquiaa maamatacai. Vʌʌ cuvaracami podui dai vʌʌsi coi maimaamatacai tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dai amaasi muu ʌooqui ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dai duduaacacai coidadʌ saagidaiñdʌrʌ. ¿Ismaacʌdʌ ʌrcunadʌcamu ʌooqui vʌʌsi ʌrcuucunadʌcatadai ʌgai di? ―tʌtʌdai ʌsaduseo. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Maicʌʌga gʌntʌtʌgitoi aapimʌ maimaatʌcatai iscaiti Diuusi ñiooquidʌ dai tomali maimaatʌcatai siʌʌsi guvucadagai viaa Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Siʌʌscadʌ duduaacagi coidadʌ camaicuucuntada agai tomali maiooñtada agai mosʌpan ducamicana ʌgai Diuusi tʌtʌaañicarudʌ tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Canʌidi aapimʌ oojai istumaasi gʌnaagidi Diuusi sai oidaga duaacaragai coidadʌ vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tomasi catʌvʌpi ʌpʌdui sicoi Avraañicaru dai Isaacaru dai Jacocaru vʌʌscʌrʌ pocaiti Diuusi: “Aanʌ anʌrDiuusigadʌ Avraañi dai Isaa dai Jaco dai aa ʌʌpʌ”, astʌtʌdai Diuusi. Ʌgai Diuusi ʌʌmadu daraaja tʌvaagiʌrʌ. Diuusi ʌrDiuusigadʌ ismaacʌdʌ catʌvaagiʌrʌ daraaja dai ismaacʌdʌ iimia agai tʌvaagiamu ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Moscaʌcai ʌoodami imaasi vʌʌscatai maitʌʌ istumaasi gʌntʌtʌgituagi ʌSuusi mamaatʌtuldaragadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aidʌsi ʌfariseo maí siʌSuusi cʌʌga aa noragi ʌsaduseo tai ʌgai maitʌʌ isducatai aa noragidagi ʌfariseo ʌʌgi gʌnʌmpagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dai ʌmoco ʌgai saagidaiñdʌrʌ ismaacʌdʌ ʌrmamaatʌtuldadamicatadai Diuusi sʌʌlicamigadʌ vuiirumada ʌliditadai ʌgai ʌSuusi daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―¿Mamaatʌtuldadami vʌʌsi ismaacʌdʌ ipʌlidi Diuusi tʌsivuaadagi tumaasi vaamioma gʌaagai tʌsivuaadagi? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Taidʌ ʌSuusi itʌtʌdai: ―“Oigʌadañi ʌcʌliodami gʌDiuusiga vʌʌsi gʌibʌdacʌdʌ dai vʌʌsi gʌguvucadagacʌdʌ dai vʌʌsi gʌtʌgitoidagacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gooviava ʌgai dai siooma gʌaagai isivuaadagi”. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dai gooquiʌrdadʌ baitoma pocaidaga ʌʌpʌ: “Oigʌadañi gʌaaduñi poduucai pʌsduucai gʌoigʌdai aapi ʌʌgi”. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tomasioorʌ sioorʌ sʌʌlicʌdʌ ʌʌgidi idi ñiooqui ʌgai gia vʌʌscʌrʌ ivueeyi vʌʌsi istumaasi aagai Diuusi sʌʌlicamigadʌrʌ dai istumaasi aagai Diuusi ñiñiooquituldadamigadʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Vai quiaa ʌmapai guucacatadai ʌfariseo ");
INSERT INTO ntpNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Ducatai tʌtʌgitoi aapimʌ voorʌ cajiudadʌ ʌCristo? ―tʌtʌdai ʌSuusi. Tai ʌgai itʌtʌdai: ―Davicaru cajiudadʌava ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Taidʌ ʌSuusi itʌtʌdai: ―Tuisidʌ ʌgai vaa Davicaru aagai isducatai aagidi Diuusi Ibʌadʌ daidʌ icaiti: “ɅCristo ʌrgiñDiuusiga”. Daidʌ Davicaru icaiti ʌʌpʌ: ");
INSERT INTO ntpNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Diuusi potʌtʌdai ʌCristo: “Gʌmaaquimu aanʌ ʌmo sʌʌlicami ismaacʌdʌ vaamioma namʌga. Dai ugititudamu aanʌ vʌʌsi ismaacʌdʌ gʌvuidʌrʌ vʌʌtʌcagi”. Ascaiti Davicaru aagaitai ʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Ducatai istutuidi ʌCristo siʌrcajiudadʌcagi ʌDavicaru vai ʌʌgi ʌDavicaru giñDiuusiga aagai? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dai tomali ʌmaadutai maitistutuiditadai isaa noragidagi tomali ʌmo ñiooqui dai aidʌ abiaadʌrʌ vʌʌscatai ʌʌbʌidiña istʌcacadagi ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Taidʌ ʌSuusi itʌtʌdai ʌoodami dai aatʌmʌ mamaatʌrdamigadʌ: ");
INSERT INTO ntpNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo povʌnʌlidi siʌgai vaamioma cʌʌga maatʌ caʌ istumaasi ooja Moseesacaru dai siʌʌgi ʌgai viaa sʌʌlicami isgamamaatʌtuldiadagi sʌʌlicamigadʌ Moseesacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cʌʌgadu isʌʌgiada aapimʌ dʌmos mosʌcaasi siʌʌscadʌ gʌnaagiada ʌgai mosʌcaasi istumaasi aagai Moseesacaru dʌmos maitivuaada aapimʌ ismaasi ivueeyi ʌgai. Ʌgai aagai ʌmo istumaasi dai ʌmamaasi ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pocaiti ʌgai sai gʌaagai isiduñiagi mui naana maasi istumaasi dai ʌgai ʌʌgi maitivueeyi isduucai aagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ʌgai aliʌ oojoidi isoojadagi Diuusi ñiooquidʌ papepeeliʌrʌ dai ali cajiitʌrʌ daraasaiña dai gʌncovana vupuraiña dai gʌnʌʌcana. Ʌgai maisiaa duutudai Diuusi mospovuaadana ʌgai sai pocaitiña ʌoodami isʌgai aliʌ siaa duutudai Diuusi. Dai ʌgai oojoidi isgʌnaadadagi yuucusi ismaacʌdʌ tʌʌtʌvʌdu naanacadʌ uugidiana. Ʌʌgi poduucai gʌnaadaiña sioorʌ siaa duutudagi Diuusi dʌmos ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo maisiaa duutudai Diuusi mosgʌnaadaiña ʌgai ʌyuucusi sai pocaitiña ʌoodami isʌgai aliʌ siaa duutudai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Dai ʌgai vʌʌscʌrʌ gagaagai cʌcʌʌgaducʌdioma daraicarui siu duucu gaugia agadagi muidutai dai quiquiuupiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dai oojoidi sioodami cucuaasada gʌnvapanamu dai viaatuldiada cacaayana dai siaa duutuadagi dai ʌgai aadʌrʌ maioojoidi ispoduucai ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","10","Aapimʌ mosʌmo aadunumu duucami dai mosʌca aanʌ Cristo ʌrgʌnbaitʌcʌaacamiga cascʌdʌ maitʌaagai isaagiada aapimʌ oodami sai siaa gʌnduutudaiña tʌtʌaanʌdami duucai. Diuusi gʌrooga vʌʌsia daama ʌrgabaitʌcʌaacami cascʌdʌ gʌaagai isvaamioma siaa duutuadagi ʌgai sioodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ismaacʌdʌ soicʌdagi aa ʌgai ʌrgʌducʌdʌcamicamu aapimʌ gʌnsaagida. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ʌgai ismaacʌdʌ siooma gʌducʌdʌ gʌʌliadagi ʌgai gia siooma maitʌrgʌducʌdʌcamicamu dai ʌgai ismaacʌdʌ siooma maigʌducʌdʌ gʌʌliadagi ʌgai gia siooma ʌrgʌducʌdʌcamicamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo siʌʌ soimaa taatamu aapimʌ. Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Aapimʌ mamaatʌtuldi oodami Diuusi sʌʌlicamigadʌ dai vʌʌscʌrʌ aapimʌ maitivueeyi istumaasi Diuusi ipʌlidi. Aapimʌ mamaatʌtuldadami maitipʌlidi isDiuusi gʌnsoicʌdagi mai cʌʌga gʌntʌtʌgitoca aapimʌ dai aapimʌ sobicʌi aa oodami sai maitipʌlidiña isDiuusi soicʌdagi vai cʌʌga gʌntʌtʌgitoca ʌgai tomasi ʌgai gia ipʌlidi isDiuusi soicʌdagi sai cʌʌga gʌntʌtʌgitocana. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo siʌʌ soimaa taatamu aapimʌ. Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. ¿Tuimʌsi voopoidi baabaquidʌ ʌvipiuudu? Dai tʌvʌpi gamamadaiña aapimʌ sai pocaitiña ʌoodami isaliʌ siaa duutudai aapimʌ Diuusi dʌmos maitʌrvaavoi. Cascʌdʌ aapimʌ aliʌ soimaasi gʌntaatatuldamu Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo. Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Aapimʌ tomasiaaco ajioopai dai gaagai oodami dai vaavoitulda ʌlidi gʌnʌpan duucai dai siʌʌscadʌ vaavoituda ʌgai gʌnʌpan duucai ʌgai vaamioma soimaasi ivueeyi isaapimʌ dai aapimʌ ʌrgʌnduñi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Siʌʌ soimaa taatamu aapimʌ. Aapimʌ mamaatʌtuldi ʌoodami Diuusi ñiooquidʌ dʌmos tomali aapimʌ maimaatʌ istʌiya ʌlidi. Dai gamamaatʌtuldi aapimʌ sai isʌmo oodami aagadagi isiduñia ʌmo istumaasi sai ispocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga ʌgʌʌ quiuupai aidʌ gia maiviaaca isiduñia istumaasi aagai, dʌmos ispocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga ooro ʌgʌʌ quiuupiʌrʌ aidʌ gia sʌʌlicʌdʌ viaaca isiduñia istumaasi aagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Vupuiiruga aapimʌ dai maimaatʌ istumaasi Diuusi ipʌlidi isivuaada aapimʌ. Vaamioma ʌrsoiñi ʌgʌʌ quiuupai siʌooro ismaacʌdʌ ʌgʌʌ quiuupiʌrʌ daja. Ʌooro quiuupai ʌrana daja cascʌdʌ siaa duutudi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Dai aapimʌ gamamaatʌtuldi ʌʌpʌ sai isʌmo oodami aagadagi isiduñia ʌmo istumaasi sai ispocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga ʌmo altar ʌgʌʌ quiuupiʌrʌ aidʌ gia maiviaaca isiduñia istumaasi aagai, dʌmos ispocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga istumaasi Diuusi daasdaradʌ ʌaltar daama aidʌ gia sʌʌlicʌdʌ viaaca isiduñia istumaasi aagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Vupuiiruga aapimʌ dai maimaatʌ istumaasi Diuusi ipʌlidi isivuaada aapimʌ. Vaamioma ʌrsoiñi ʌaltar siDiuusi daasdaradʌ. Diuusi daasdaradʌ ʌaltar daama daja cascʌdʌ siaa duutudi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isʌmo oodami aagadagi isiduñia ʌmo istumaasi dai pocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga ʌmo altar ʌgʌʌ quiuupiʌrʌ dai poduucai aagai ʌgai vʌʌsi istumaasi oidaga ʌaltar daama. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Isʌmo oodami aagadagi isiduñia aagai ʌmo istumaasi dai pocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga ʌgʌʌ quiuupai dai poduucai aagai ʌgai vʌʌsi Diuusi, ʌgai quiuupiʌrʌ daja cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Isʌmo oodami aagadagi isiduñia aagai ʌmo istumaasi dai pocaitiadagi sai sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai poduucai isduucai ʌrvaavoi isoidaga tʌvaagi dai poduucai aagai ʌgai vʌʌsi Diuusi, ʌgai tʌvaagiʌrʌ daja cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo. Aapimʌ aagai ʌmo istumaasi dai ʌmamaasi ivueeyi. Vʌʌsi istumaasi viaa aapimʌ aa oidiña oodami Diuusi aa duiñdadʌ vʌʌtarʌ asta ivaagi mʌsmaacʌdʌ bʌʌjʌi. Cʌʌgadu isoidiada aapimʌ oodami Diuusi aa duiñdadʌ vʌʌtarʌ mʌstumaasi viaacagi dʌmos maitivueeyi aapimʌ istumaasi Diuusi ipʌlidi gomaasi gia maicʌʌgadu. Aapimʌ maicʌʌga oidaga tomali maisoigʌnʌlidi aapimʌ aacʌdʌ tomali maicʌʌga vaavoitudai aapimʌ Diuusi ñiooquidʌ poduucai aliʌ soimaasi ivueeyi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aapimʌ ʌrʌpan ducami mainʌnʌaadami ismaacʌdʌ vaidaquia ʌlidi oodami ʌmapʌcʌrʌ. Aapimʌ ivueeyi istumaasi maisi gʌaagai dai maitivueeyi istumaasi vaamioma gʌaagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo. Aapimʌ cʌʌ tuutiacami gʌnvueeyi oodami vuitapi dʌmos aliʌ soimaasi ivueeyi aapimʌ. Ʌʌsivuacatai dai coimudadʌ tuutiacatai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Aapimʌ sʌʌlicʌdʌ maicʌʌga maatʌ caʌ Diuusi ñiooquidʌ aliʌsi gʌaagai isʌʌpʌga daanʌda aapimʌ Diuusi vai ʌgai gʌnoigʌlda gʌnsoimaascamiga dai poduucai camaitʌrsoimaasi iduucamicamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo. Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Aapimʌ ʌrʌpan ducami siaaco gʌyaasapai coidadʌ dai aliʌ cʌʌga baiduñisi daamadʌrʌ dai ʌrana aliʌ sigalnaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pomaasi aapimʌ aliʌ cʌʌga tuutiacami gʌnvueeyi oodami vuitapi dai gʌntʌgitoidagʌrʌ aliʌ soimaasi aagaiña ʌmo istumaasi dai ʌma maasi ivuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Siʌʌ soimaasi taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ dai aapimʌ fariseo. Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Aapimʌ ivuiididi baabaquidʌ Diuusi ñiñiooquituldiadamigadʌ ismaacʌdʌ coi gʌnʌʌqui aaduñicaru dai siaaco yaasapi dai gʌnaaduñicaru coi ʌʌpʌ aa oodami cʌʌ tuutiacami ʌgai ami daama ʌsai aapimʌ yoosigai. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dai pocaiti aapimʌ: “Isoidacamudai aatʌmʌ ʌʌquioma aidʌsi oidacatadai gʌrʌʌqui aaduñicaru maisoiña coodamudai aatʌmʌ Diuusi ñiñiooquituldiadamigadʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Poduucai ʌʌgi aapimʌ aagai mʌsidʌ ʌrcajiudadʌ dai ʌpan tuutuiga aapimʌ ʌgai ismaacʌdʌ coi Diuusi ñiñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Isapiasoimaasi ivuaada aapimʌ otoma ʌpan ʌʌsi gʌpiʌrʌ vʌʌtʌcamu aapimʌ gʌnʌʌqui aaduñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sʌʌlicʌdʌ ʌrsoimaasi ivuaadami aapimʌ. Aapimʌ gia maicʌʌgacʌrʌ vuvaquimu baiyoma iimimu aapimʌ mʌʌca siaaco oidaga ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cascʌdʌ ootosamu aanʌ Diuusi ñiñiooquituldiadamigadʌ dai oodami sastuduacami, dai mamaatʌtuldiadami. Dʌmos aapimʌ coodamu ʌʌmoco dai aa curusiaba siisisamu dai aa gʌviarsamu quiquiuupiʌrʌ, dai aa soimaa taatatuldamu aali quiiquiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dai poduucai aapimʌ gʌpiʌrʌ vʌʌtʌcamu vʌʌsi gocʌʌ tuutiacamicʌdʌ ismaacʌdʌ gʌncooditu. Aidʌsi abiaadʌrʌ gʌmuaatu Aveelicaru cʌʌ tuigacʌdʌ asta aidʌsi gʌmuaatu Zacaríasi Berequiiasi maradʌ ʌgai ismaacʌdʌ muaa ʌgai ʌgʌʌ quiuupai vuidʌrʌ ʌaltar abaana. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi. Aapimʌ sivi oidacami gʌpiʌrʌ vʌʌtʌcamu vʌʌsi gomaasicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Aapimʌ Jerusaleenʌrʌ oidacami aapimʌ mʌsmaacʌdʌ coodai Diuusi ñiñiooquituldiadamigadʌ ojoodaicʌdʌ, mosʌʌ muiyoco imidagai ipʌliditadai aanʌ isgʌnʌmpaidagi dai gʌnnuucadacagi ʌpan duucai ʌtacucu ʌmpaidi gʌmaamara gʌaana uta mʌtai maitipʌli aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Dañi aapimʌ sivi gʌndagitomu aanʌ dai camaitiñtʌʌgimu aapimʌ ʌpamu asta siʌʌscadʌ aiyagi istuigaco potʌiya aapimʌ: “Aliʌ siaa duutudai aatʌmʌ ismaacʌdʌ borimʌi Diuusi guvucadadʌcʌdʌ” ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Daidʌ ʌSuusi vuusai ʌgʌʌ quiuupaigadʌaiñdʌrʌ ʌjudidíu dai caimia agaitadai tai miaadʌrʌ guuquiva aatʌmʌ mamaatʌrdamigadʌ ʌgai dai aagidi sai aliʌ chigiamaasi ʌgʌʌ quiuupai. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Taidʌ ʌSuusi gʌraa noragi dai povʌrtʌtʌdai: ―¿Nʌidimʌsi aapimʌ vʌʌsi idi? Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi sai tomali ʌmo odai maiviiya agai ʌmai daama, vʌʌsi siaa gʌduuñimu goovai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Amaasi iji aatʌmʌ Oliivosi giidiamu dai ami daiva ʌSuusi. Mosʌcaasi ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ ʌgai ami daacatadai tʌtai aatʌmʌ itʌtʌdai: ―Aatʌmʌ ipʌlidi pʌsgʌraagida aapi siʌʌscadʌ ʌpʌduñia agai gomaasi ismaacʌdʌ aagai aapio. ¿Duucatai maatʌcamu oodami iscayo divi agai aapi dai cayo ugitimu oidigi? ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Amaasi ʌSuusi povʌrtʌtʌdai: ―Gʌnnuucadacavurai vai tomali ʌmaadutai maitʌnvupuiirumadaiña. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muidutai dadia agai daidi caitiadamu ʌgai: “Aanʌ anʌrCristo”, dai muidutai vupuiirumadadamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cajiomacamu ʌoodami muiyapʌrʌ cocodi, dai aa cayo gʌncocoda ʌʌpʌ, maitavʌr duduaadicuda gomaasi ʌpʌduñia agai ʌpʌga, dʌmos maiquia aayi cuugatʌrʌ tasʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ʌmo dʌvʌʌriʌrʌ oidacami cocuadamu ʌmai dʌvʌʌriʌrʌ oidacami dai oidacamu biuugigai dai coocodagai aipacoga dai aliʌ cavami gigivucudamu ʌʌmapʌcʌrʌ gooidigi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vʌʌsi gomaasicʌdʌ utudama gʌaagacai soimaasi taatamu oidigi daama oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Dai amaasi ʌoodami tʌʌgidamu ʌvaavoitudadami dudunucamiʌrʌ mʌsaidʌ gʌʌgʌna dai coodana. Dai vʌʌsi oidigi daama oidacami cʌʌdadamu giñvaavoitudaitai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Siʌʌscadʌ aiyagi amaasi tasʌrʌ muidutai camaitiñvaavoitudada agai, dai aipaco gʌncʌʌdadamu dai aipaco gʌntʌtʌgiadamu dudunucamiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dai oidacamu mui yaatavogami ismaacʌdʌ pocaitada agai saidʌ ʌrDiuusi ñiñiooquituldiadamigadʌ dai vupuiirumadadamu mui oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dai sʌʌlicʌdʌ oidacamu soimaasi dai cascʌdʌ mui oodami camaitʌnoigʌadamu aipacoga. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dʌmos ʌgai ismaacʌdʌ apiagiñvaavoitudadagi siʌʌsi uucami oidacagi oidigi daama ʌgai gia cʌʌgacʌrʌ vuvaquimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dai vʌʌsi oidigʌrʌ gʌaagadamu gocʌʌ caidacʌdʌ isducatai Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana sipoduucai vʌʌsi oidigi daama oidacami maatʌcamu. Dai amaasi gia caugitimu oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Tai Daniel ʌmo Diuusi ñiooquituldiadamigadʌ poduucai ooja sai divia aagai ʌmoco ismaacʌdʌ sʌʌlicʌdʌ soimaasi iduñia agai ʌmo istumaasi ʌgʌʌ quiuupaigadʌrʌ judidíu ʌrana. Siʌʌscadʌ nʌijada oodami ispomaasi ʌpʌvuimi, amaasi ʌgai ismaacʌdʌ tami Judeeʌrʌ daraajagi gʌaagai isvoopiagi gigiidiamu ―gʌrtʌtʌdai ʌSuusi. Sioorʌ nʌijadagi idi oojai gʌaagai ismaatʌ caʌcagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Daidʌ ʌSuusi potʌtʌdai ʌʌpʌ: ―Sioorʌ vaaqui daama daacagi aidʌ tasʌrʌ aliʌsi gʌaagai isotoma voopiagi maivuvaidacai gʌvustuidaga tuucavidʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","dai sioorʌ dʌjiana ajioopadagi maitʌaagai isʌpamu iimiagi gʌnquiiquiamu dai vuiyagi gʌnyuucusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Siʌʌ soimaa taatamu ʌooqui ismaacʌdʌ noonoacagi siʌʌpʌ viaacagi aali siisiʌdami, aidʌ tasʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aliʌsi gʌaagai isdaanʌdagi Diuusi vai maitʌrtoomococana mʌsiʌʌscadʌ voopiagi, tomali maitʌrʌmo ibʌstaragai tasʌrʌcana. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aliʌ soima taata agai ʌvaavoitudadami cascʌdʌ. Vaamioma soimaasi gʌtaatamu amaasi sitomali ʌmo imidagai aidʌsi abiaadʌrʌ Diuusi idui oidigi dai gooquiʌrʌ tomali ʌmo imidagai maipomaasi gʌtaatamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Isbai tʌvʌpi ʌpʌduñiagi gomaasi aidʌ gia vʌʌsi coiyantada oodami dʌmos Diuusi maidagitomu istʌvʌpi ʌpʌduñia gomaasi ʌgai aliʌ oigʌdai ismaacʌdʌ ʌcovai vuvaitu cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Amaasi isʌmaadutai povʌntʌtʌadagi: “Dañi tami daja ʌCristo”, mʌsiʌpʌ povʌtʌtʌadagi: “Dañi mʌʌca daja”, maitavʌr vaavoitudada. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dadia vagai yaatavogami dai pocaitiada agai saidʌ ʌrʌCristo dai pocaitiada agai saidʌ ʌrDiuusi ñiñiooquituldiadamigadʌ, daidʌ ivuaada agai naana maasi gʌgʌrducami dai poduucai vupuiirumadada agai asta ʌgai ismaacʌdʌ Diuusi ʌʌgi ʌcovai vuvaitu isistutiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dʌmos aanʌ ʌʌquiasdʌrʌ abiaadʌrʌ gʌaagidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Cascʌdʌ isaagiada ʌgai dai povʌtʌtʌadagi: “Dañi mʌʌca oidigana daja ʌCristo”. Maitʌaagai isiimiagi ʌoodami daida isaagiadagi ʌgai dai povʌtʌtʌdai: “Dañi tami quiiyʌrʌ daja”, maitʌaagai isvaavoitudadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Poduucai ismaascana siʌʌscadʌ vʌpʌdocʌdagi oidigi poduucai ʌʌpʌ vʌʌsi oodami giññʌida agai siʌʌscadʌ ajiagi istuigaco diviagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tomasiaaco siaaco caatʌcagi baabaidi duvaligadʌ ami gʌnʌmpaidiña nuunui, poduucai ʌrvaavoi ʌʌpʌ saidʌ ʌpʌduuñi agai vʌʌsi istumaasi aagai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Dai amaasi siʌʌscadʌ cadaivuñiagi gosoimaa taataragai tasai tucapi viiya agai dai masaadai gʌiiña agai, dai sisiaavugai suuligia agai tʌvaagiaiñdʌrʌ, dai vʌʌsi istumaasi oidaga tʌvaagiʌrʌ gigivucudamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dai amaasi tʌʌgimu oodami tʌvaagiʌrʌ ʌmo istumaasi dai poduucai maatʌmu iscadivia aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami dai vʌʌsi oidigi daama oidacami suaanʌda agai daidʌ giñtʌʌgimu ʌgai istʌvaagiaiñdʌrʌ imʌdamu aanʌ icomai saagidaiñdʌrʌ guvucadagaicʌdʌ dai Diuusi dadadaquigadʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dai ootosamu aanʌ giñtʌtʌaañicaru vai ʌgai cavami iivana trompeetacʌdʌ dai poduucai ʌmpaida aagai vʌʌsi ʌoodami ismaacʌdʌ Diuusi ʌcovai vuvaitu vʌʌsi oidigiaiñdʌrʌ dai vʌʌsi tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Maatʌvurai aapimʌ idi ñiooqui ismaacʌdʌ gʌnaagidia iñagai aanʌ aagaitai ʌiigosi. Siʌʌscadʌ momiacagi iigosi maamaradʌ dai iipoidagi aagadʌ poduucai camaatʌca iscamiaadimi taaco. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Poduucai ʌʌpʌ mʌsiʌʌscadʌ nʌijadagi iscasi ʌpʌvuidagi gomaasi ismaacʌdʌ caaagidi aanʌ camaatʌca iscayoga ugidagai oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi sai gomaasi ʌpʌduñia agai maiquiaa ugitʌcai oodami sivi oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tʌvaagi dai dʌvʌʌrai ugitimu dʌmos giññiooqui maiugitimu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Dʌmos tomali ʌmaadutai maimaatʌ siʌʌscadʌ tomali siuu duucu tomali Diuusi tʌtʌaañicarudʌ tʌvaagiʌrʌ daraajatai maimaatʌ, tomali aanʌ Diuusi maradʌcatai. Mosʌʌgi gʌrooga Diuusi ʌgai dai maatʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Poduucai isduucai ʌpʌdui aidʌsi oidacatadai ʌNoé poduucai ʌpʌduuñimu ʌʌpʌ siʌʌscadʌ cadivia iñagada aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ʌʌqui aidʌsi maiquiaa cavami duudu dai maiquiaa gʌiiña oidigi suudagicʌdʌ ʌoodami gacuaadana dai gayʌʌdana dai cuucuntaiña, dai gamamaacaiña gʌnmaamara ooqui mʌsai ooñtaiña asta aidʌ uucami sivaa ʌNoé gʌvaarcugʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sai moduu maimaí ʌgai asta aidʌsi caduuquimi tai vʌʌsi ʌoodami coi. Poduucai ʌpʌduuñimu ʌʌpʌ siʌʌscadʌ divia aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dai amaasi gooca cʌcʌʌli oidigana daraajamu siDiuusi vaidacaimu ʌmoco dai ʌgʌmai viaamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dai gooca ooqui gatuaadamu siDiuusi vaidacaimu ʌmoco dai ʌgʌmai viaamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Vʌʌscʌrʌ gʌaagai isbaigʌnduca aapimʌ maimaatʌcatai tomali siuu duucu divia aagai ʌtʌaanʌdami. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dʌmos cʌʌga maatʌ aapimʌ sai isʌmo oodami maatʌcagi siuu duucu ami quiidiʌrʌ divia agadagi ʌmo ʌʌsivogami maicosian tada ʌgai nuucadacatai sai maivaacʌna quiidiʌrʌ dai ʌʌsidana. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Poduucai ʌʌpʌ aapimʌ aliʌsi gʌaagai mʌsbaigʌn ducagi, siuu duucu siooma maitʌgitoca aapimʌ iñsidivimu aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Daidʌ ʌSuusi itʌtʌdai ʌʌpʌ: ―Ʌmoco gaaamu vʌʌscʌrʌ gaagaiña ʌmoco ʌʌgidaracami dai saituduacami saidʌ ʌrtʌaanʌdamigadʌcana pipiooñigadʌ dai bibidiña siuu duucu gʌaagadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Baigʌʌliadamu ʌtʌaanʌdami ismaacʌdʌ iducagi vʌʌsi cʌʌga siuu duucu diviagi ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sʌʌlicʌdʌ angʌnaagidi saidʌ ʌaamudʌ tʌaanʌdami duucai viituldamu vʌʌsi istumaasi viaacagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dʌmos siʌpiooñi ismaacʌdʌ tʌaanʌdami duucai viaagi ʌaamudʌ maicʌʌga tuigacagi dai povʌʌldagi siʌaamudʌ maiotoma divia aagai ");
INSERT INTO ntpNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dai gʌaagacai soivuaadagi ʌgaa pipiooñi dai ʌgai gacuaadagi dai gayʌʌdagi dai navamuagi aa navacoidadʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dai poduucai ʌaamudʌ diviagi siuu duucu ʌpiooñigadʌ siooma mainʌnʌracagi dai siuu duucu ʌgai maimaatʌcagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dai sʌʌlicʌdʌ soima taatatuldamu ʌgai daidʌ iduuñimu ʌgaicʌdʌ isducatai ʌpʌvueeyi ʌgaicʌdʌ ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Amaasi susuaaquimu ʌgai dai aliʌ soimaasi taata agai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Isducatai ʌʌpʌ vueeyi siʌʌscadʌ Diuusi soicʌdagi oodami sai cʌʌga gʌntʌgitocana ʌrʌpan ducami istumaasi idui baivustaama aali tʌtʌʌji ismaacʌdʌ iimi agaitadai ʌmo cunataragiamu dai bʌʌ iimʌi gʌncuucudacaru. Dai ʌgai ajia agai ʌnoovio ʌmapʌcʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dai taamatai ʌgai maicʌʌga gʌntʌtʌgito dai taamatai ʌgai aliʌ cʌʌga gʌntʌtʌgito. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ʌgai ismaacʌdʌ maicʌʌga gʌntʌtʌgito maibʌcai asaiti istucʌdʌ suusudadagi gʌncuucudacaru siuu duucu caugitiagi asaitigadʌ ʌcuucudacarui. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dai ʌgai ismaacʌdʌ cʌʌga gʌntʌtʌgito ʌgai gia bʌcai asaiti istucʌdʌ suusudadagi gʌncuucudacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Daidʌ ʌnoovio camaiotoma divia sai cavʌʌscatai sʌʌlicʌdʌ coocosimu dai coocoi. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sai caʌran tucarʌ sibʌ iiña istumaasi saidʌ icaiti: “Casibʌdʌrʌ imʌi lienʌ ʌnoovio, mʌcavʌr vuidʌrʌ aji”, ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tai vʌʌscatai ʌaali tʌtʌʌji vaapañi dai baidui gʌncuucudacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Daidʌ ʌtaama ismaacʌdʌ maicʌʌga gʌntʌtʌgito itʌtʌdai ʌgaa ismaacʌdʌ cʌʌga gʌntʌtʌgito: “Gʌrcuucudacaru cayoga tuu gʌrmaacavurai laalachi asaiti”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sai aa noragi ʌgai ismaacʌdʌ cʌʌga gʌntʌtʌgito daidʌ itʌtʌdai: “Chu, aidʌ gia maitʌrajia goovai dai tomali aapimʌ ʌʌpʌ. Baiyoma avʌr iimi aapimʌ mʌʌca siaaco gʌgaagarai dai savʌda aapimʌ gʌnvʌʌtarʌ”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dai aidʌsi utudama mʌʌca gasavʌdamu ʌgai ʌasaiti sai aayi ʌnoovio. Dai ʌaali tʌtʌʌji ismaacʌdʌ cʌʌga gʌntʌtʌgito vaapa ʌnoovio ʌʌmadu ami cunataragiʌrʌ, dai cuu ʌcuuparagai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Sai gooquiʌrʌ dada ʌgaa aali tʌtʌʌji daidʌ icaiti: “Cʌliodami, cʌliodami gʌrcupioquidañi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sai ʌgai aa noragi daidʌ itʌtʌdai: “Maitanʌnmaatʌ”, astʌtʌdai ʌgai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Taidʌ ʌSuusi povʌrtʌtʌdai aatʌmʌ mamaatʌrdami: ―Cascʌdʌ baigavʌr gʌnduca aapimʌ maitamʌmaatʌ siʌʌscadʌ tomali siuu duucu divia iñagai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Siʌʌscadʌ Diuusi soicʌdagi oodami sai cʌʌga gʌntʌgitocana gomaasi ʌrʌpan ducai isduucai idui ʌmo cʌʌli ismaacʌdʌ imia agaitadai ʌmai dʌvʌʌriamu dai vaí gʌpipiooñiga dai maa tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ʌmoco maa ʌgai taama mil piisu, dai ʌgʌmai goo mil, dai ʌgʌmai ʌmo mil. Ʌʌpʌgadagʌ siooma saituduga cascʌdʌ vaamioma mui maa ʌgai tumiñsi daidʌ ʌgaa siooma maisastuduga cascʌdʌ vaamioma chiichiʌqui maa ʌgai tumiñsi. Dai ii ʌgai ʌmai dʌvʌʌriamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ʌpiooñigadʌ ismaacʌdʌ viaacatadai taama mil piisu gamaitʌ ʌʌpʌ taama mil piisu ʌtumiñsicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Poduucai ʌʌpʌ ʌgʌmai ismaacʌdʌ viaacatadai goo mil gamaitʌ ʌʌpʌ goo mil. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tai ʌgai ismaacʌdʌ viaacatadai ʌmo mil ii dai ʌsto ʌtumiñsigadʌ gʌaamu dʌvʌʌrai uta. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tʌvʌpicʌdʌ ʌpamu divia ʌaamudʌ dai vaí ʌgai gʌpipiooñiga dai maatʌca aagai sʌʌjʌqui gamaitʌ ʌʌmadutai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ʌʌpʌga divia ʌgai ismaacʌdʌ viaacatadai taama mil piisi dai tʌʌgi ʌtumiñsi ismaacʌdʌ gamaitʌ daidʌ itʌtʌdai: “Giñaamu, aapi giñmaa taama mil piisu dai tami daja ʌʌpʌ taama mil piisu ismaacʌdʌ gamaitʌ aanʌ”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Taidʌ ʌaamudʌ itʌtʌdai: “Cʌʌgaduava, aapi ʌrʌmo cʌʌ piooñi cacʌʌga idui aapi laachicʌdʌ sivi gia gʌmaaquimu aanʌ gʌʌpioma. Miaadʌi dai baigʌʌliada aanʌ giñʌʌmadu”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tai gooquiʌrʌ ami divia ʌpiooñigadʌ ismaacʌdʌ viaacatadai goo mil piisu daidʌ itʌtʌdai: “Giñaamu giñmaa aapi goo mil piisu dai tami daja ʌʌpʌ goo mil ismaacʌdʌ gamaitʌ aanʌ”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Taidʌ ʌaamudʌ itʌtʌdai: “Cʌʌgaduava, aapi apʌrʌmo cʌʌ piooñi cacʌʌga idui aapi laachicʌdʌ sivi gia gʌmaaquimu aanʌ gʌpioma. Miaadʌi dai baigʌʌliada giñʌʌmadu”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tai gooquiʌrʌ ami divia ʌgʌmai piooñigadʌ ismaacʌdʌ viaacatadai ʌmo mil piisu, ʌgai itʌtʌdai gʌaamu: “Giñaamu cʌʌ maatʌ aanʌ sialiʌ oomaliga aapi dai aa gʌʌsituldiña pai aapi mosvuudana yoovisicami dai maita aata vueeyi aapi dai vʌʌscʌrʌ vuuyi tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cascʌdʌ gʌʌʌbʌñi aanʌ dai ii dai ʌsto gʌtumiñsiga dʌvʌʌrai uta dai tami daja”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Taidʌ ʌaamudʌ aa noragi daidʌ itʌtʌdai: “Aapi ʌrʌmo piooñi maicʌʌ tuigacami dai parʌgami camaatʌcatadai aapi isaa giñʌsituldi dai iñsaanʌ mosvuuyi yoovisicami dai ismaita aata vueeyi aanʌ dai vʌʌscʌrʌ vuuyi tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cascʌdʌ sibʌaco gamaaquimudai aapi gotumiñsi mʌsiaaco maitʌtuldamudai simuiyoma vuimudai aanʌ diviacai”, astʌtʌdai ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Daidʌ itʌtʌdai ʌgai ʌgaa ismaacʌdʌ ami guucacatadai: “Bʌivurai gotumiñsi dai maaca ʌgai ismaacʌdʌ viaa baivustaama mil”, astʌtʌdai ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Tomasioorʌ cʌʌga aata vueeyi istucudʌ Diuusi gʌroidi vaamioma viaaca aagai. Dai sioorʌ maicʌʌga aata vueeyi istucʌdʌ viaa, ʌgai gia ootoma maiviaaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dai idi giñpiooñiga maicʌʌ tuigacʌdʌ vuusaidavurai quiidigamu dai poduucai ʌʌpʌ Diuusi ootosamu vʌʌsi ʌsoimasi ivuaadami mʌʌca siaaco oidacagi ʌDiaavora sisuaanʌdamu ʌgai dai aliʌ soimaasi taata agai”, ascaiti ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Siʌʌscadʌ divia aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami vʌʌsi giñtʌtʌaañicaru ʌʌmadu daidʌ ʌrraícamu aanʌ amaasi. Diuusi giñdaasamu baitʌcʌaacami sitʌaanʌdamu aanʌ vʌʌsi oodami oidigi daama oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Dai vʌʌsi oidacami gʌnʌmpaidamu giñabaana dai ʌcovai vuvaidamu aanʌ ʌvaavoitudadami dai sʌʌlisapadʌrʌ daraasamu dai ʌsoimaasi ivuaadami oogisapadʌrʌ poduucai isduucai ʌmo pastuuru judidíu ʌcovai vuvaidiña cañiiru sisiivatu saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Amaasi aanʌ ismaacʌdʌ ʌrraí aagidamu ismaacʌdʌ sʌʌlisa padʌrʌ daraaja: “Aapimʌ ismaacʌdʌ Diuusi gʌrooga cʌʌgacʌrʌ nʌidi giñʌʌmadu daraajamu dai aanʌ gʌnmaaquimu sʌʌlicami isaapimʌ giñʌʌmadu tʌaanʌdagi. Aidʌsi abiaadʌrʌ idui Diuusi oidigi aagai sai aapimʌ gatʌaanʌda agai aanʌ iñʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Biuugimu aanʌ mʌtaidʌ imbii. Tonomu aanʌ mʌtaidʌ iñvasiibi suudagi. Aanʌ aimʌraitadai mai aapimʌ maitiñmaatʌcatadai dai vʌʌscʌrʌ giñmaa aapimʌ oigaragai isgʌnquiiyʌrʌ tiñuuliña aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dai camaiviaacatadai aanʌ yuucusi mʌtai aapimʌ giñmaa yuucusi, dai coococatadai aanʌ mʌtai aapimʌ giñdadiji, dai maisapicatadai aanʌ mʌtai aapimʌ giñdadiji ʌʌpʌ”, povʌntʌtʌaadamu aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Amaasi ʌvaavoitudadami giñaa noragidamu dai povai iñtʌʌdamu: “¿Tʌaanʌdami, vʌquidʌ gʌnʌidi aatʌmʌ isbiuugimucatadai aapi siaatʌmʌ gʌbii? ¿Vʌquidʌ gʌnʌidi aatʌmʌ istonomucatadai aapi siaatʌmʌ gʌvasiibi suudagi? ");
INSERT INTO ntpNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Vʌquidʌ daivusai aapi siaatʌmʌ maitʌmaatʌcatadai dai vʌʌscʌrʌ gʌmaa oigaragai isgʌrquiiyʌrʌ coi aapi? ¿Vʌquidʌ gʌnʌidi aatʌmʌ ismaiyuucusu aapi dai gʌmaa yuucusi? ");
INSERT INTO ntpNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Vʌquidʌ coococatadai aapi dai vʌquidʌ maisapicatadai aapi sigʌdadiji aatʌmʌ?” Povai iñtʌtʌadamu ʌvaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dai aanʌ aa noragidamu daidʌ itʌʌdamu: “Ismaacʌdʌ gʌnaadidi aanʌ ʌrvaavoi tomastumaasi cʌʌgaducami ismaacʌdʌ aapimʌ giñaaduñi gʌnvuiididiña aipacoga gʌnsoicʌitai ducami isgomaasi iduuñimudai aapimʌ aan imvʌʌtarʌ”, povʌntʌʌdamu aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Amaasi aanʌ gʌʌ raí, itʌʌdamu ʌgai ismaacʌdʌ giñoogisa padʌrʌ guuca: “Iimʌdavurai aapimʌ tabiaadʌrʌ Diuusi maicʌʌgacʌrʌ gʌnnʌidi aapimʌ, iimʌdavurai siaaco tomastuigaco mʌʌcana taí, mʌʌca siaaco baidui Diuusi ʌDiaavora vʌʌtarʌ dai ʌDiaavora tʌtʌaañicarudʌ vʌʌtarʌ: ");
INSERT INTO ntpNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Biuugimu aanʌ mʌtai maitiñbii, tonomu aanʌ mʌtai maitiñvasiibi suudagi, ");
INSERT INTO ntpNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","dai gʌndiviji aanʌ maiaapimʌ maitiñmaatʌcatadai dai casʌcʌdʌ maitiñmaa oigaragai isgʌnquiiyʌrʌ giñuuliña aanʌ. Dai maiyuucusucatadai aanʌ mʌtai maitiñoi yuucusi, coococatadai aanʌ mʌtai maitiñdadiji, maisapicatadai aanʌ mʌtai maitiñdadiji”, potʌʌdamu aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Amaasi ʌgai povaiñtʌtʌadamu: “Tʌaanʌdami, ¿vʌquidʌ biuugimu aapi, dai tonomu, dai gʌrdiviji, dai maiyuucusu, dai cooco, dai maisapicatadai simaitʌ soi aatʌmʌ?” povaiñtʌtʌadamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Siaanʌ gʌʌ raí aa noragidamu daidʌ itʌʌdamu: “Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi tomastumaasi cʌʌgaducami ismaacʌdʌ maitidui aapimʌ govaavoitudadami vʌʌtarʌ tomasi maisi gʌaagai goovai gomaasi maitidui aapimʌ aanʌ giñvʌʌtarʌ”, potʌtʌadamu aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Daidʌ ʌsoimaasi ivuaadami iimia agai siaaco tomastuigaco Diuusi soimaasi taatamituldiadamu daidʌ ʌcʌʌga tʌgitocami iimia agai tʌvaagiamu siaaco oidacamu Diuusi ʌʌmadu tomastuigaco ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aidʌsi canaato aa ʌSuusi vʌʌsi gomaasi, ʌgai povʌrtʌtʌdai aatʌmʌ mamaatʌrdami: ");
INSERT INTO ntpNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Cʌʌ maatʌ aapimʌ sigoo tasaicʌdʌ aiya agai ʌsiaa duudagai ismaacʌdʌ pascua tʌʌgidu, siamaasi giñbʌimu ʌoodami dai mʌʌca iñtʌʌgidamu mʌsaidʌ giñsiisana curusiaba poduucai iñmuaamu aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ―gʌrtʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Amaasi ʌbaitʌguucacamigadʌ ʌpapaaligadʌ ʌjudidíu daidʌ ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌpipiscaligadʌ ʌjudidíu Caifási quiidiana tuisicana gʌnʌmpagi. Ʌgai ʌrbaitʌcʌaacamigadʌcatadai papaaligadʌ ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dai vʌʌscatai ʌgai gʌnaatagi isducatai yaatagidagi ʌSuusi dai bʌjiagi dai muaagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Daidʌ icaiti: ―Baiyoma nʌnʌraca aatʌmʌ vai daivuñiagi gosiaa duudagai tʌtaida bʌiya aatʌmʌ vai maitʌrvui baacoagi oodami ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Vaidʌ ʌSuusi Betaaniʌrʌ daacatadai Simuñi quiidiʌrʌ. ɅSimuñi ʌʌquioma viaacatadai ʌmo coocodagai ismaacʌdʌ duvaldi gatuucuga dʌmos cadueeyi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tai ami divia ʌmo ooqui dai bʌʌcati ʌmo tucayu alavastrocʌdʌ duñisicami suudacami asaiti sigian uuvadami sʌʌlicʌdʌ namʌacami. Daacatadai ʌSuusi mesa abaana taidʌ ʌooqui tʌi ʌasaiti moodʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aidʌsi tʌʌ aatʌmʌ ʌSuusi mamaatʌrdamigadʌ gomaasi aliʌ baacoi aatʌmʌ dai aipaco gʌraatagidimi daidʌ icaiti: ―¿Istuisidʌ siaa doodai goovai goasaiti? ");
INSERT INTO ntpNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cʌʌga gʌgagaramudai goovai mui tumiñsicʌdʌ dai ʌcʌdʌ soiñamudai soitutuigami ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Vaidʌ ʌSuusi caʌ istumaasi aagai aatʌmʌ mamaatʌrdamigadʌ ʌgai daidʌ povʌrtʌtʌdai: ―¿Tuimʌsi pocai nʌidi aapimʌ idi ooqui? Gomaasi ismaacʌdʌ giñduñi goovai ʌrʌmo istumaasi cʌʌgaducami. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Soitutuigami vʌʌscʌrʌ viaacamu aapimʌ gʌnsaagida dai aanʌ gia maisiu vʌʌscʌrʌ giñnʌijadamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Idi ooqui giñtʌi asaiti giñmooana otoma muquia iñagai aanʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi sai tomasiaacoga siaaco gaagiadagi Diuusi ñiñiooquituldiadamigadʌ Diuusi ñiooquidʌ vʌʌsi oidigi daama gaaagiadamu ʌʌpʌ istumaasi idui idi ooqui sipoduucai vʌʌsi oodami maatʌcamu ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tai amaasi ʌUudasi Iscaliote, ʌmoco ʌbaivustaama dan gooca mamaatʌrdamigadʌ ʌSuusi ii dai gaaataga ʌgai ʌbaitʌguucacamigadʌ ʌpapaaligadʌ ʌjudidíu ʌʌmadu, ");
INSERT INTO ntpNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","daidʌ itʌtʌdai: ―¿Mʌʌqui giñmaquiagi tumiñsi isgʌntʌʌgida aanʌ ʌSuusi? ―astʌtʌdai. Tai ʌgai aa namʌqui ʌmo coobai dan baivustaama piisu plata. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aidʌ abiaadʌrʌ ʌUudasi gaagai isducatai gatʌʌgidagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tai aayi ʌsiaa duudagai istuigaco gʌtʌgitoi ʌjudidíu aidʌsi Diuusi cʌʌgacʌrʌ vuvaidi Ejiipituaiñdʌrʌ. Tai aatʌmʌ ʌSuusi mamaatʌrdamigadʌ miaadʌrʌ guuquiva ʌSuusi dai tʌcacai daidʌ itʌtʌdai: ―Vaacoga ipʌlidi aapi tʌsbaiduñiagi cuaadagai idi siaa duudagai vʌʌtarʌ ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tai ʌgai povʌrtʌtʌdai: ―Iimivurai mʌʌca gʌgʌr quiiquiʌrʌ dai aagida ʌcʌʌli ismaacʌdʌ caaagidi aanʌ dai aagidavurai sai aanʌ pocaiti sai camiaadimi mʌsiʌʌscadʌ giñmua aagai sai quiidiʌrʌ gaugia ragai aatʌmʌ aanʌ ʌʌmadu aapimʌ idi siaa duudagʌrʌ cuaadagai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tʌtai aatʌmʌ mamaatʌrdamigadʌ ʌgai idui isducatai gʌraagidi ʌSuusi dai baidui ʌcuaadagai siaa duudagʌrʌ vʌʌtarʌ. Idi siaa duudagʌrʌ tʌtʌgitoi ʌjudidíu aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dai aidʌsi catuca mesa vuidʌrʌ daacatadai ʌSuusi ʌʌmadu aatʌmʌ ʌbaivustaama dan gooca mamaatʌrdamigadʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dai gacuaadatadai aatʌmʌ taidʌ ʌSuusi povʌrtʌtʌdai: ―Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi, ʌmaadutai aapimʌ giñtʌʌgida agai ʌdudunucami siʌgai giñmuaamu ―gʌrtʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tʌtai aatʌmʌ aliʌ soigʌrʌʌli dai aipaco gʌraagidimi dai pocaitimi aatʌmʌ. ―Tʌaanʌdami, aanʌ gia cho ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Taidʌ ʌSuusi gʌraa noragi dai povʌrtʌtʌdai: ―Ismaacʌdʌ giñʌʌmadu gacueeyi ʌgai vaa plaatʌrʌ gooviava ʌgai daidʌ giñtʌʌgida agai dudunucami. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ivueeyi istumaasi aagai Diuusi ñiooquidʌrʌ dʌmos siʌʌ soimaa taatamu gocʌʌli ismaacʌdʌ giñtʌʌgida agai siooma ʌrcʌʌgaicamudai gocʌʌli vʌʌtarʌ ismaivuusaimudai tami oidigi daama ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Amaasi ñioo ʌUudasi ismaacʌdʌ gatʌʌgida agaitadai ʌSuusi daidʌ itʌtʌdai ʌgai ʌSuusi: ―Giñmamaatʌtuldiadamiga, aanʌ gia cho ―tʌtʌdai ʌgai. Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌjʌ aapiapa ―tʌtʌdai ʌsuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dai aidʌsi gacuaadatadai aatʌmʌ, taidʌ ʌSuusi bʌi ʌpaana dai gamamagi dai saasarai dai gʌrmaa aatʌmʌ mamaatʌrdami daidʌ povʌrtʌtʌdai: ―Ugavurai. Idi ʌrgiñtuucuga ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dai bʌi ʌʌpʌ ʌmo vaasu uuvasi varagadʌ dai gamamadacai gʌrmaa ʌʌpʌ daidʌ povʌrtʌtʌdai: ―Iivurai idi vʌʌscatai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Idi ʌrʌpan ducami giñʌʌra ismaacʌdʌ aastia agai muucucai aanʌ sipoduucai gʌoigʌldamu soimaascamigadʌ, tomasioorʌ sioorʌ vaavoitudagi. Iñsiʌʌscadʌ muquiaagi vai aastiagi giñʌʌra aidʌ abiaadʌrʌ gʌaagamu goñiooqui utudui ismaacʌdʌ gaaagidi isduucatai gaoigʌldi soimascami dai cʌʌgacʌrʌ vuvaquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Dai aanʌ angʌnaagidi ansai camaiyʌʌda iñagai aanʌ uuvasi varagadʌ asta iñsiʌʌscadʌ iiyagi utudui aapimʌ gʌnʌʌmadu mʌʌca siaaco gatʌaanʌi gʌrooga Diuusi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dai canʌʌcai ʌmo Diuusi nʌidadʌ siaa duutudaitai Diuusi, iji aatʌmʌ Oliivosi giidiamu. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Vʌʌscatai aapimʌ voopoimu dai ʌʌgi giñdagitomu sivi tucarʌ, pocaiti Diuusi ñiooquidʌrʌ: “Dagitomu aanʌ isgʌmuaatudamu pasturu sicañiirugadʌ aipaco iimimu”, caiti Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dʌmos siʌʌscadʌ ʌpamu duaaca aanʌ ʌʌpʌga aimu aanʌ Galileeʌrʌ isaapimʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Tomasi vʌʌscatai gogaa voopiagi dai ʌʌgi gʌdagituagi aanʌ gia maiʌʌgi gʌdagituagi ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Taidʌ ʌSuusi itʌtʌdai: ―Ismaacʌdʌ gʌaagidi aanʌ ʌrvaavoi sai sivi tucarʌ maiquiaa cuujuicai tacucu aapi vaicojo potʌiya agai pʌsai maitiñmaatʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Taidʌ ʌPiiduru itʌtʌdai: ―Tomañsi aapi gʌʌmadu muu maitanpotʌiyagi iñsmaitʌmaatʌ ―tʌtʌdai ʌPiiduru. Tʌtai vʌʌscatai aatʌmʌ potʌi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dai amaasi aayi ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ ʌgai ʌmapʌcʌrʌ siaaco Getasemani tʌʌgidu taidʌ ʌSuusi povʌrtʌtʌdai: ―Tamiavʌr daraaja naida aanʌ mʌʌca gamamadagi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dai vaidacai ʌPiiduru ʌʌmadu ʌgooca Sevedeo maamaradʌ dai aliʌ soigʌʌlidi dai camostʌgitocan tada isdadiagi ʌtʌtʌaanʌdami dai bʌʌquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Daidʌ itʌtʌdai: ―Camuquiadan tada aanʌ soigiñʌliditai. Tanasiavʌr vii aapimʌ dʌmos maitavʌr coocosi ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dai baitʌquioma ii dai cupulia voi dʌvʌʌrapi dai daanʌi Diuusi dai potʌtʌdai: ―Giñooca isbaigaca ismaisii soimaa taata aanʌ dʌmos vai maitʌʌpʌ duuna istumaasi aanʌ ipʌlidi mosʌcaasi istumaasi aapi ipʌldagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dai amaasi ʌpamu ii ʌgai mʌʌca siaaco daraajatadai ʌmamaatʌrdamigadʌ vai ʌgai coocosʌcatadai, daidʌ potʌtʌdai ʌgai ʌPiiduru: ―¿Maitapʌs istui isnʌaagagi tomasi ʌmo oora aanʌ giñʌʌmadu? ");
INSERT INTO ntpNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Maitavʌr coocosi dai gamamadada vai maisoimaasi gʌnduiñtuldana ʌDiaavora. Aapimʌ iduñia ʌlidi istumaasi Diuusi ipʌlidi dai vʌʌscʌrʌ maiquiaa cʌʌga vaavoitudai cascʌdʌ maitivueeyi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dai imʌcai gamamagi ʌSuusi ʌpamu dai poduucai gamamagi: ―Giñooca ismaibaigacagi ismaisoima taata aanʌ isducatai cabaidui aatʌmʌ aidʌ gia ʌpʌduuna isducatai aapi ipʌliadagi ―asduucai gamamadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dai otoma ʌpamu ii siaaco daraajatadai ʌmamaatʌrdamigadʌ vai ʌpamu coocosʌcatadai aliʌ coocosimucatadai ʌgai mossusuligʌi vuupuidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dai dagito ʌgai dai imʌcai gamamagi ʌpamu ʌgai vaa ñiooquicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Amaasi ʌpamu ii ʌgai siaaco daraajatadai ʌmamaatʌrdamigadʌ daidʌ itʌtʌdai: ―Siviavʌr gia coocosi daidʌ gʌniibʌsta. Casiat aayi mʌsiuu duucu giñtʌʌgida agai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. Giñtʌʌgida mʌaagai soimaasi ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Vaapaigivurai. Tiimʌda. Casia boodʌrʌ imʌi ismaacʌdʌ giñtʌʌgida agai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dai quiaa ñioocaitadai ʌSuusi tai ami divia ʌUudasi. Ʌgai ʌrʌmoco gʌraduñi aatʌmʌ baivustaama dan gooca mamaatʌrdamigadʌ ʌSuusi vai oiditadai mui oodami dai vuucati mamaastai dai uusi. Ʌgai ʌrojootosadʌcatadai ʌbaitʌguucacamigadʌ papaaligadʌ ʌjudidíu dai ʌpipiscaligadʌ ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uudasi ismaacʌdʌ gatʌʌgida agaitadai ʌSuusi casi itʌtʌdai ʌʌquioma ʌgai ʌoodami: ―Ismaacʌdʌ usupiga aanʌ ʌgiava ʌgai vʌrai bʌi ―tʌtʌdai ʌUudasi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Amaasi miaadʌrʌ cʌquiva ʌgai ʌSuusi daidʌ itʌtʌdai: ―Baiga giñmamaatʌtuldiadamiga ―tʌtʌdai ʌUudasi. Dai usupi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Giñaduñi pʌtuma duñia agai dai divia? ―tʌtʌdai ʌgai. Amaasi miaadʌrʌ guuquiva ʌoodami dai bʌi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amaasi ʌmaadutai ismaacʌdʌ ami guucacatadai Suusi ʌʌmadu vuusaitu gʌcusiru dai iquitʌ ʌmo naacadʌ ʌbaitʌcʌaacami papaali piooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Taidʌ ʌSuusi itʌtʌdai: ―Gʌcuviertagʌrʌ icʌʌsa gʌcusiru. Vʌʌscatai sioorʌ gacocoadagi cusiruicʌdʌ cusiruicʌdʌ coimu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Maitapʌs maatʌ aapi iñsaanʌ istutuidi istaañiagi giñooca ʌmo soiñi vai ʌgai cʌʌga istutuidi isgiñootosdagi mui mil gʌsandaaruga tʌvaagiaiñdʌrʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Isʌgai giñootosdagi aidʌ gia camaitʌʌpʌduñia go ismaacʌdʌ aagai Diuusi ñiooquidʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Amaasi ʌSuusi itʌtʌdai ʌoodami: ―¿Tuimʌsi dada aapimʌ dai vuucati uusi dai mamaastai? ¿Dai tuimʌsi giñbʌʌquia agai ducami siaanʌ ʌrʌmo ʌʌsivogamicagi? Vʌʌs tasai gʌnsaagida daacana aanʌ ʌgʌʌ quiuupaigadʌrʌ judidíu dai gʌnmamaatʌtuldiña Diuusi ñiooquidʌ mʌtai tomali ʌmo imidagai maimaisapicami giñbʌi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dai vʌʌsi gomaasi idui aapimʌ vaidʌ ʌpʌduuna isducatai ooja Diuusi ñiñiooquituldiadamigadʌ Diuusi ñiooquidʌrʌ ―tʌtʌdai ʌSuusi. Tʌtai vʌʌscatai aatʌmʌ mamaatʌrdamigadʌ voopoi dai ʌʌgi viaa ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tai ʌgai ismaacʌdʌ bʌi ʌSuusi bʌʌcai mʌʌca siaaco daacatadai ʌCaifási. Ʌgai ʌrbaitʌcʌaacamigadʌ papaaligadʌ ʌjudidíu. Ami casi gʌnʌmpaidacatadai ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌpipiscaligadʌ ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Vaidʌ ʌPiiduru mosmʌʌcasdʌrʌ oiditadai ʌgʌʌ baitʌcʌaacamigadʌ papaaligadʌ ʌjudidíu tuisiquigadʌrʌ ucami dai amaasi vaa dai daiva ʌsandaaru ʌʌmadu dai nʌijada aagai istumaasi iduñia ʌgai ʌSuusicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Taidʌ ʌtʌtʌaanʌdamigadʌ ʌpapaali ʌʌmadu ʌpipiscali vʌʌscatai ʌvaamioma tʌtʌaanʌdamigadʌ uusi dadagʌcʌdʌ dudunucami ʌjudidíu gaagai ʌmo istumaasi istucʌdʌ gʌpiʌrʌ vuaajagi tomasi maitʌrvaavoi dai poduucai gatʌaañia agai muaaragai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dai vʌʌscʌrʌ maitʌʌ tomali ʌmo istumaasi istucʌdʌ gʌpiʌrʌ vuaajagi tomasi muidutai dada dai yaatagʌi. Dai cuugatʌrʌ dada gooca nʌijadami yaatavogami ");
INSERT INTO ntpNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","daidʌ icaiti: ―Gocʌʌli icaiti: “Aanʌ istutuidi isdaitudagi ʌgʌʌ quiuupai dai vaica tasaicʌdʌ ʌpamu vañigidagi”, caiti gocʌʌli ―ascaiti gonʌijadami. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amaasi ʌbaitʌcʌaacamigadʌ ʌpapaali judidíu cʌquiva daidʌ itʌtʌdai ʌSuusi: ―¿Maitapʌs gaaa noragida agai tomali ʌmo istumaasi? ¿Tumaasi goovai ismaacʌdʌ aagai goovai gʌvui? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Taidʌ ʌSuusi maiñioocacai vii. Taidʌ ʌbaitʌcʌaacamigadʌ ʌpapaali judidíu itʌtʌdai: ―Aanʌ angʌaagidi pʌsaidʌ gʌraagidana Diuusi vuitapi ismaacʌdʌ tomastuigaco oidaga pʌsabai aapi ʌrʌCristo Diuusi maradʌ siʌʌpʌ cho ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Taidʌ ʌSuusi itʌtʌdai: ―Ʌjʌ Diuusi maradʌana poduucai isducatai aagai aapi. Dai aapimʌ giñtʌʌgimu aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami siDiuusi sʌʌlisa padʌrʌ daacamu aanʌ dai giñtʌʌgimu aapimʌ siʌʌscadʌ tʌvaagiaiñdʌrʌ imʌda aanʌ icomai saagida ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Taidʌ ʌbaitʌcʌaacamigadʌ papaali judidíu saasarai gʌyuucusi. Aliʌ baamu ʌgai caʌcatai istumaasi aagai ʌSuusi. Daidʌ itʌtʌdai ʌbaitʌcʌaacami: ―Gocʌʌli poʌlidi isʌrDiuusi maradʌ di. Dai vui ñioocai Diuusi camaitʌgito aatʌmʌ vaamioma nʌijadami. Aapimʌ cacaʌ isducatai vui ñioocai goovai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tʌtuma duuna gocʌʌlicʌdʌ? ―astʌtʌdai. Tai ʌgai itʌtʌdai: ―Gʌpiʌrʌ caatʌcamiava goovai gatʌaañivurai muaaragai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Daidʌ ʌoodami sisividimi ʌSuusi vuivasadʌ dai capiacarai. Dai aa vuivasana capiacarai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Daidʌ itʌtʌdai: ―Aapi poʌlidi isDiuusi gʌmaa ʌmo sʌʌlicami. Maatʌñi toorʌ gʌʌgʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Vaidʌ ʌPiiduru maigovai tuisicana daacatadai tai ʌmo cusñiirugadʌ ʌbaitʌcʌaacamigadʌ ʌpapaali ami divia daidʌ itʌtʌdai ʌgai ʌPiiduru: ―Aapiapa ʌʌpʌ ʌʌmadu aimʌraiña ʌSuusi Galileeʌrʌ oidacami ―astʌtʌdai ʌcusñiiru. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dʌmos ʌPiiduru yaatagi daidʌ itʌtʌdai: ―Maitan maatʌ aanʌ pʌsioorʌ aagai aapi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ɅPiiduru cavuusaimi maigo quiidigamu, tai ʌʌpʌ ʌmai ʌgai vaa cusñiirugadʌ tʌʌ ʌPiiduru ʌʌpʌ daidʌ itʌtʌdai ismaacʌdʌ ami daraajatadai: ―Gocʌʌli ʌʌpʌ ʌʌmadu aimʌraiña ʌSuusi Nasareetʌrʌ oidacami ―astʌtʌdai ʌali tʌji. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dʌmos ʌPiiduru ʌpamu yaatagi daidʌ itʌtʌdai: ―Maatʌ Diuusi ismaimaatʌ aanʌ gocʌʌli ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dai laachicʌdʌ ʌgai ismaacʌdʌ ami daraajatadai abaana guuquiva ʌPiiduru daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ aapiapʌ ʌrʌmoco ʌSuusi mamaatʌrdamigadʌ ʌʌpʌ. Asta ʌpamaasi ñioocai aapi ʌSuusi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Vaidʌ ʌPiiduru galñaasi ñiooquimi daidʌ icaitimi: ―Maatʌ Diuusi nai aanʌ maimaatʌ gocʌʌli ―ascaiti. Tai aidʌ otoma cuujui ʌtacucu. ");
INSERT INTO ntpNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Taidʌ ʌPiiduru tʌgito istʌtʌdai ʌSuusi sai maiquiaa cuujuicai ʌtacucu ʌgai vaicojo itʌiya agaitadai sai maimaatʌ ʌSuusi. Daidʌ ʌPiiduru ii abiaadʌrʌ dai soigʌʌldacai sosua. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dai mosmaasicai vʌʌsi ʌtʌtʌaanʌdamigadʌ ʌpapaali ʌʌmadu ʌpipiscali judidíu gʌnaatagi isducatai muaagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dai vulicami bʌʌcai ʌSuusi dai mʌʌ tʌʌgi ʌPilaato, ʌgai ʌrtʌaanʌdamigadʌ Judeeʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aidʌsidʌ ʌUudasi ismaacʌdʌ gatʌʌgi ʌSuusi tʌʌ mʌscamuaa agaitadai ʌSuusi aliʌ soigʌʌli dai ʌma duucai gʌtʌgito. Dai ʌpamu vuidacai vʌʌsi goʌmo coobai dan baivustaama piisu ʌbaitʌguucacamigadʌ papaali judiuíu ʌʌmadu ʌpipiscali. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Daidʌ itʌtʌdai: ―Aliʌ soimaasi idui aanʌ gatʌʌgidacai ʌmo cʌʌli maigʌpiʌrʌ caatʌcami mʌsai muaana ―astʌtʌdai ʌUudasi. Dʌmos ʌgai aa noragi daidʌ itʌtʌdai: ―¿Dai gomaasi tumaasi ʌrgʌrvʌʌtarʌ aatʌmʌ? Aapi ʌʌgi ʌrgʌduñi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Taidʌ ʌUudasi ami ʌgʌʌ quiuupai ʌrana suuli ʌtumiñsi, dai ii dai gʌvuliji. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Taidʌ ʌbaitʌguucacami ʌpapaali ʌmpagi ʌtumiñsi daidʌ itʌtʌdai: ―Maibaiga isvʌʌnaida aatʌmʌ gogaa tumiñsi ismaacʌdʌ gʌoidi oodami Diuusi aa duiñdadʌ vʌʌtarʌ. Idi tumiñsi ʌrnamʌgadʌ ʌʌrai cascʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dai aipaco gʌnaagi sai ʌgai tumiñsicʌdʌ savʌda agai ʌmo dʌvʌʌrai siaaco Aajatadami tʌʌgidu dai ami viaaca aagai siaaco yaasapadagi ismaacʌdʌ maitʌroidacami ami. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dai Dʌvʌʌrai ʌʌrai tʌʌgidu asta sivi ucami. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Poduucai ʌpʌdui ismaacʌdʌ ʌʌquioma aagai Jeremiiasicaru Diuusi ñiooquituldiadamigadʌ daidʌ icaiti: “Ʌjudidíu tʌtʌaanʌdamigadʌ vuuquia agai goʌmo coobai dan baivʌstaama piisu plaata ismaacʌdʌ baiga duu dai aa namʌquida gocʌʌli ismaacʌdʌ gatʌʌgi gogʌmai cʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dai ʌgaicʌdʌ gasavʌli agai ʌdʌvʌʌrai ismaacʌdʌ Aajatadami tʌʌgidu, poduucai isduucai giñaagidi giñtʌaanʌdamiga”, ascaiti Jeramiiasicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tai vaidacai ʌgai ʌSuusi ʌgʌʌ tʌaanʌdami vuitapi tai ʌgai tʌcacai daidʌ itʌtʌdai: ―¿Aapipʌsi ʌrraígadʌ judidíu? ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Vaavuava, ʌjʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Taidʌ ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌpipiscali gʌpiʌrʌ vuupai dʌmos ʌSuusi maiaa noragi tomali ʌmo ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Taidʌ ʌPilaato itʌtʌdai: ―¿Maitapʌs caʌ aapi vʌʌsi goovai mʌsmaacʌdʌ aagai gʌvui? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Taidʌ ʌSuusi vʌʌscʌrʌ maiaa noragi tomali ʌmo istumaasi, dai poduucai ʌgʌʌ tʌaanʌdami maitʌʌ istumaasi gʌtʌgituagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vaidʌ ʌPilaato dadagitoiña ʌmo maisapicami aidʌ siaa duudagʌrʌ ʌʌgi poduucai gʌviidacatadai ʌgai isdadagitoldiadagi ʌoodami ʌʌgi ismaacʌdʌ ipʌliadagi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Vai ami maisacariʌrʌ cuupicatadai ʌmo cʌʌli Baraavási tʌʌgiducami ismaacʌdʌ tomasioorʌ cajiomacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tai aidʌsi ʌoodami gʌnʌʌmpagi ʌPilaato tʌcacai daidʌ itʌtʌdai: ―¿Maacʌdʌ ipʌlidi aapimʌ isdagitua aanʌ Baraavási siʌSuusi ismaacʌdʌ Cristo aagai? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ʌgai maatʌcatadai ismoscoimudadʌ tadacatadai ʌbaitʌguucacamigadʌ ʌpapaali dai cascʌdʌ gatʌʌgi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ɅPilaato quiaa daacatadai ʌdudunucamiʌrʌ taidʌ ʌooñigadʌ ootosi ñiooqui daidʌ itʌtʌdai: ―Maitigʌvapasada aapi gocʌʌli cʌʌ tuigacami ʌʌmadu. Tuucarʌ tʌʌtʌquimi aanʌ ʌmo istumaasi soimasi ʌgai vʌʌtarʌ ―asducai ootosi ñiooqui Pilaato ooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dʌmos ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌpipiscali avʌnaqui ʌoodami sai baiyoma gataanʌna mʌsdagituagi Baraavási dai sai muaana ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Taidʌ ʌgʌʌ tʌaanʌdami ʌpamu ñioo dai tʌcacai ʌoodami daidʌ itʌtʌdai: ―¿Maacʌdʌ goovai vʌgoocai siooma ipʌlidi aapimʌ isgʌndagitolda aanʌ? ―astʌtʌdai. Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Baraavási ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Taidʌ ʌPilaato tʌcacai daidʌ itʌtʌdai: ―¿Dai goSuusi mʌismaacʌdʌ Cristo aagai ducatai iduuna aanʌ? ―astʌtʌdai. Tai vʌʌscatai aa noragi daidʌ itʌtʌdai: ―Siisañi curusiaba vai poduu muucuna ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Taidʌ ʌPilaato itʌtʌdai: ―¿Tumaasi soimaasi iducami goovio? ―astʌtʌdai. Tai ʌgai ʌpamu ijiña daidʌ itʌtʌdai: ―Siisañi curusiaba, vai poduu muucuna ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aidʌsi ʌPilaato catʌʌ iscamaitistui ʌoodamicʌdʌ cavaamioma galcaititai ʌgai, dai gatai suudagi dai gʌico vʌʌsi ʌoodami vuitapi daidʌ itʌtʌdai: ―Aanʌ gia maitʌrgiñduñi gocʌʌlicʌdʌ. Goovai gia maitʌrgʌʌpiʌrʌ caatʌcami, goovai gia ʌʌgi aapimʌ ʌrgʌnaa duiñdaga ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tai vʌʌscatai ʌoodami aa noragi daidʌ itʌtʌdai: ―Aatʌmʌ ʌʌmadu gʌrmaamara tʌrgʌʌpiʌrʌ vʌʌtʌcamicagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Taidʌ ʌPilaato dagitoli Baraavási daidʌ ʌPilaato gatʌjai mʌsai gʌicarsana iquisanaicʌdʌ ʌSuusi dai tʌʌgi ʌoodami sai curusiaba siisana sai poduu muucuna. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tai gooquiʌrʌ ʌgʌʌ tʌaanʌdami sandaarugadʌ vaidacai ʌSuusi gamu Pilaato quiidiamu dai vaí vʌʌsi ʌsandaaru dai ami siaaco cʌacatadai ʌSuusi vʌʌsi sicoli guuquiva. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mʌtai uupasi yuucusidʌ ʌSuusi dai aadi aa yuucusi vʌpʌgicami sai ʌpʌa maascamu ʌmo raí, ");
INSERT INTO ntpNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","dai moo daama daí ʌmo cooronai uuparaicʌdʌ duñisicami dai maa ʌmo tʌʌvʌli sʌʌlisa padʌrʌ noviʌrʌ. Daidʌ gʌntootonacʌdʌ guuquiva ʌSuusi vuidʌrʌ dai parunai daidʌ icaiti: ―Sivi gia tʌvʌpi oidacamu aapi raígadʌ ʌjudidíu ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dai sisividimi ʌʌpʌ dai bʌbʌyi tʌʌvʌli dai ʌgaicʌdʌ moodʌana gʌvai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dai canaato parunacai ʌpamu uupasi ʌyuucusi vʌpʌgicʌdʌ dai ʌpamu aadi ʌʌgi yuucusidʌ. Dai boodʌrʌ vaidacai dai mʌʌ siisa agai curusiaba sai poduu muucuna. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dai aidʌsi utudama iji ʌgai abiaadʌrʌ vuidʌrʌ aayi ʌmo cʌʌli Simuñi tʌʌgiducami Sireñiʌrʌ oidacami mʌtai aagidi sai bʌʌcaiña ʌgai ʌcurusigadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dai poduucai aayi mʌʌca siaaco Gólgota tʌʌgidu. Gólgota icaidaga moodʌ muuquiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dai ami oidi uuvasi varagadʌ vʌʌnagʌcami ʌmo doadigami aliʌ ʌʌcocami sai ʌgaicʌdʌ palʌpioma soimaa taatana. Taidʌ ʌSuusi mosdʌʌ dai camaitipʌli isiiyagi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dai casiisacai curusiaba dʌmos maiquiaa muu ʌgai tai gooquiʌrʌ nʌʌnʌitudai volao dai poduucai nʌida agai isioorai ajia agai yuucusidʌ ʌSuusi. Dai poduucai ʌpʌdui istumaasi aagai Diuusi ñiooquituldiadamigadʌ daidʌ icaiti: “Sai nʌʌnʌituda agai volao dai poduucai nʌida aagai isioorai ajiagi ʌyuucusidʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dai ami daraajatai nuucada. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dai curusiaba moo daama daí ʌmo oojai ismaacʌdʌ gatʌjai ʌPilaato dai aagai mʌstuisidʌ gatʌjai muaaragai daidʌ icaiti: “Idiava ʌrʌSuusi, raígadʌ judidíu”, ascaiti ʌoojai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dai abaana ʌSuusi siisisa gooca ʌʌsivogami ʌmoco sʌʌlisa padʌrʌ ʌmai curusiaba dai ʌgʌmai oogisa padʌrʌ ʌmai curusiaba. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dai ismaacʌdʌ amui dʌgavusai galnaasi ñiooqui suuligidi ʌSuusi dai gidai gʌnmoomo, ");
INSERT INTO ntpNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","daidʌ itʌtʌdai: ―Epa aapi pʌsmaacʌdʌ dadaitudai ʌgʌʌ quiuupaigadʌ ʌjudidíu dai vaica tasaicʌdʌ ivueeyi ʌpamu cʌʌgacʌrʌ igʌvuusaida aapi ʌʌgi. Siaapi ʌrDiuusi maradʌ tʌvañiñi bocurusiaiñdʌrʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Poduucai ʌʌpʌ parunai ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo ʌʌmadu ʌpipiscali dai aipaco gʌnaagidi daidʌ icaiti: ");
INSERT INTO ntpNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Cʌʌgacʌrʌ vuvaitu goovai aa dai goovai ʌʌgi gia maitistutuidi iscʌʌgacʌrʌ gʌvuusaidagi. Issʌʌlicʌdʌ ʌrvaavoi isʌgai ʌrgʌrraíga aatʌmʌ judidíu vai tʌvanʌna curusiaiñdʌrʌ tʌtai poduucai vaavoituda aatʌmʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Goovai povʌʌlidi siDiuusi nuucada. SiDiuusi sʌʌlicʌdʌ oigʌdai cʌʌgacʌrʌ vuusaidana tuduidʌ sivi. Gocaasi gʌraagidi goovai saidʌ ʌrDiuusi maradʌ ―ascaiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dai asta ʌʌʌsivogami ismaacʌdʌ cucurusiaba siisisapicatadai ami sonuana ʌSuusi galnaasi ñioocai ʌgai vui vʌʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dai dan duucu vʌʌsi oidigi tucapi vii vaic oora. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dai aidʌ coi gʌʌsʌco gʌgʌrʌ iiña ʌSuusi daidʌ icaiti: ―Eloi, Eloi, lama sabactani ―ascaiti. Asmaacʌdʌ itʌiya ʌlidi giñDiuusiga, giñDiuusiga ¿tuipʌsi giñdagito? astʌiya ʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dai ʌʌmoco ismaacʌdʌ ami daraajatadai caʌ ispocaiti ʌgai daidʌ icaiti: ―Dañi vapaidi goovai ʌDiuusi ñiooquituldiadamigadʌ Eliiasi ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tai otoma ʌmaadutai mʌʌ dai bʌi ʌmo visiocoli dai vadʌitu uuvasi varagadʌ ʌʌcocamicʌdʌ dai ʌmo tootoicami cuugʌrʌ daí ʌvisiocoli dai miaadʌrʌ dadasdi ʌSuusi sai visiusuna. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dʌmos aa itʌtʌdai: ―Tʌdagito sabai diviana Eliiasi dai cʌʌgacʌrʌ vuusaidana ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Taidʌ ʌSuusi gʌgʌrʌ iiña dai muu. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Vaidʌ ʌgʌʌ icusi ismaacʌdʌ ʌgʌʌ quiuupaigadʌrʌ judidíu sagiʌcatadai ʌpan ʌʌsi covocami ʌmo sueeyi dai ʌraana sʌʌli sarai tʌcavidʌrʌ abiaadʌrʌ mʌtana ucami. Dai dʌvʌʌrai gigivuli dai ojoodai taatapai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Daidʌ gʌcuucupioco siaaco yaasapicatadai ʌcoidadʌ dai mui oodami ismaacʌdʌ vaavoitudaitadai Diuusi duduaca ʌcoidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Dai caduaacacai ʌpamu ʌSuusi coidadʌ saagidaiñdʌrʌ daidʌ ʌgaa vʌʌsi vuvaja coidadʌ saagidaiñdʌrʌ dai mʌʌ Jerusaleenʌrʌ vaapa tai mui oodami tʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tai amaasi ʌtʌaanʌdamigadʌ sandaaru ʌʌmadu ʌgaa ismaacʌdʌ nuucadacatadai ʌSuusi aidʌsi tʌʌ ʌgai isgigivuli dʌvʌʌrai dai tʌʌ vʌʌsi ismaacʌdʌ ʌpʌdui sʌʌlicʌdʌ duduaadimu, daidʌ icaiti: ―Baivaavoi idi cʌʌli sʌʌlicʌdʌ ʌrDiuusi maradʌcatadai ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dai ami guucacatadai mui ooqui mʌʌcasdʌrʌ nʌiditadai ʌʌpʌ ismaacʌdʌ Galileeaiñdʌrʌ oidatucuitadai ʌSuusi dai soicʌitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ʌgai saagida daraajatadai María Madaliña, dai María Jacovo dʌʌdʌ dai Osee dʌʌdʌ, dai Zevedeo maradʌ dʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dai caurui tai ami divia ʌmo cʌʌli gʌviidacami Osee tʌʌgiducami. Ʌgai ʌrArimateeʌrʌ oidacami, ʌgai ʌrvaavoitudadami ʌSuusi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dai amaasi ʌgai nʌidamu ʌPilaato dai taí ʌSuusi tuucugadʌ. Taidʌ ʌPilaato gatʌjai mʌsai tʌʌgidana. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dai tʌvañdacai ʌSuusi ami curusiaiñdʌrʌ dai ʌmo icusi maitucuracamiʌrʌ biisa. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Daidʌ ʌOsee casi gatʌjaitadai coocodagai ʌmo vavuana mʌsai ami yaasana siʌʌscadʌ muquiagi ʌgai dʌmos ʌSuusi ami tʌʌ ʌgai. Dai cacuupacai ʌquitaagiña ʌmo gʌʌ odaicʌdʌ daivunu ii. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Vai ami daacatadai ʌMaría Madaliña ʌʌmadu ʌgʌmai María siaaco yaasapicatadai ʌSuusi sonuana. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Aidʌ ʌrʌtasaicatadai istuigaco baivuaadana ʌgai vʌʌsi dai siaadiqui ʌribʌstaragaicatadai istuigaco maitistuma vuaadana ʌgai. Dai siaadiqui ʌbaitʌguucacamigadʌ ʌpapaali judidíu, ʌʌmadu ʌfariseo mʌʌ nʌidamu ʌPilaato ");
INSERT INTO ntpNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","daidʌ itʌtʌdai: ―Tʌgito aatʌmʌ ʌyaatavogami Suusi aidʌsi quiaa oidacatadai ʌgai iscaititadai sai vaica tasaicʌdʌ duaaca agaitadai ʌgai coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cascʌdʌ gatʌaañiñi mʌsai cʌʌga nuucadacana mʌʌca siaaco yaasapi ʌSuusi vaica tasai uucami vai poduucai maidadana ʌSuusi mamaatʌrdamigadʌ tucarʌ vai maibʌʌna ʌtuucugadʌ vai gooquiʌrʌ maipocaitiada ʌgai iscaduaaca. Dai poduucai ʌgooquiʌrdadʌ yaatagi vaamioma maicʌʌgaducagi siʌtuucamidʌrʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Daidʌ ʌPilaato itʌtʌdai: ―Moguuca giñsandaaruga. Vaidacai aapimʌ dai mʌʌca siaaco cayaasa ʌSuusi cʌʌ bai duñia isistutuidi di vai poduucai maibʌʌna ʌmuuquiadʌ ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dai iji dai mʌʌ cʌʌga baidui siaaco yaasapicatadai ʌSuusi dai seeracʌdʌ bidasa dai ami seeraba daí ʌseeyogadʌ ʌgʌʌ baitʌcʌaacamigadʌ ʌromamano. Vai ami daraajatadai ʌsandaaru ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dai cadaivunucai ʌibʌstaragai tasʌrʌ dai camaasimi oidigi tumiñoco daidʌ ʌMaría Madaliña ʌʌmadu ʌgʌmai María iji mʌʌca siaaco yaasapicatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tai todian duucai gigivuli dʌvʌʌrai, ʌmo Diuusi tʌaañicarudʌ tʌvai tʌvaagiaiñdʌrʌ cascʌdʌ. Dai aʌcai mʌʌca siaaco yaasapicatadai ʌSuusi maigovai daitu ʌodai istucʌdʌ cuupicatadai ʌgai dai daama daiva ʌodai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dadadacʌi ʌgai ʌpan duucai pʌpʌdocʌdami dai yuucusidʌ ʌpan ʌʌsi tootuaja cʌvai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mostʌʌgacai ʌsandaaru ʌDiuusi tʌaañicarudʌ giigivuli duduaadimucai dai camoscoidadʌ duucai vii. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dai amaasi ʌDiuusi tʌaañicarudʌ itʌtʌdai ʌooqui: ―Maitavʌr duduaadicuda. Aanʌ cʌʌga maatʌ isgaagai aapimʌ ʌSuusi ismaacʌdʌ curusiaba gʌsiisatu. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dai ʌgai maitiipu tami casiat duaaca isduucai aagaitadai ʌgai. Baigovai avʌr iimi dai ñʌida siaaco caatʌcatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iimʌdavurai otoma dai mʌʌ aagida ʌmamaatʌrdamigadʌ iscaduaaca ʌgai coidadʌ saagidaiñdʌrʌ dai sivi imia agai ʌgai gʌnbaitʌqui Galileeamu dai ami tʌʌgimu aapimʌ. Goovai ʌrvʌʌsi ismaacʌdʌ gʌnaagida iñagai aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Taidʌ ʌooqui otoma iji abiaadʌrʌ baigʌnʌliatugai dai duduaadimutugai. Dai voopoigi dai mʌʌ gʌraagida agai aatʌmʌ mamaatʌrdamigadʌ ʌSuusi vʌʌsi istumaasi aagidi ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dai aidʌsi voopoigitadai ʌgai tai vuidʌrʌ aayi ʌSuusi dai viaatuli. Tai ʌgai abaana gʌntootonacʌdʌ guuquiva ʌSuusi dai siaa duutuli dai taata ʌʌcasodʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tai ʌgai itʌtʌdai: ―Maitavʌr duduaadicuda. Iimivurai dai mʌʌ aagida giñaaduñi vai iimʌna Galileeamu dai ami giñtʌʌgimu ʌgai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aidʌsi ʌooqui gamu iimʌitadai taidʌ ʌsandaaru chiʌʌqui caayamu iji dai aagidi ʌbaitʌguucacamigadʌ ʌpapaligadʌ ʌjudidíu vʌʌsi istumaasi ʌpʌdui. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Taidʌ ʌbaitʌguucacamigadʌ iji dai mʌʌ aatagi ʌgai ʌpipiscali ʌʌmadu dai nʌida aagai isducatai iduñiagi. Dai gooquiʌrʌ aa namʌqui ʌgai mui tumiñsi ʌsandaaru ");
INSERT INTO ntpNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","daidʌ itʌtʌdai: ―Aagidavurai aapimʌ situcarʌ coocosʌcatadai aapimʌ sai dada ʌSuusi mamaatʌrdamigadʌ dai bʌʌcai ʌtuucugadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Isʌgʌʌ tʌaanʌdami maatia goovai aatʌmʌ atʌbai duñiagi ʌgai ʌʌmadu cascʌdʌ maitʌsiʌnduñia ʌgai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Taidʌ ʌsandaaru vui ʌtumiñsi dai iji dai mʌʌ aagidi istumaasi aagidi ʌgai. Dai poduucai aagai ʌjudidíu asta sivi ucami. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dai poduucai iji aatʌmʌ baivustaama dan ʌmoco mamaatʌrdamigadʌ ʌSuusi gamu Galileeamu ʌmo quiidiamu siaaco aagai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dai aidʌsi tʌʌ aatʌmʌ ʌSuusi siaa duutuli dʌmos ʌʌmoco gʌraaduñi maicʌʌga vaavoitudaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Taidʌ ʌSuusi abaana cʌquiva aatʌmʌ dai povʌrtʌtʌdai: ―Aanʌ via ʌmo sʌʌlicami dai vaamioma gatʌaanʌi tʌvaagiʌrʌ dai tami oidigʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iimʌdavurai aapimʌ dai aagida oodami vʌʌsi oidigʌrʌ oidacami sai aliʌsi gʌaagai isvaavoitudai iñsaanʌ ʌrʌcʌʌgacʌrʌ vuviadami dai poduucai ʌrgiñmamaatʌrdamicagi. Ismaacʌdʌ vaavoitudai ʌgai gia vapaconavurai Diuusi gʌrooga guvucadadʌcʌdʌ dai giñguvucadagacʌdʌ, aanʌ ʌrDiuusi maradʌ, dai Diuusi Ibʌadʌ guvucadadʌcʌdʌ vai poduucai maatiagi aa iscavaavoitudai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Dai maatʌtuldavurai sai ʌʌgidiña vʌʌsi istumaasi gʌnaagidi aanʌ. Maatʌcavurai aapimʌ iñsaanʌ gʌnʌʌmadu daaca iñagai vʌʌs tasai ugitʌcai oidigi ucami ―gʌrtʌtʌdai ʌSuusi. Mosʌcaasi.");
INSERT INTO ntpNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ʌʌquioma ooja Isaíacaru ʌmo ñiooqui Diuusi ñiooquidʌrʌ ismaacʌdʌ istutuidi isbaiʌliatuda oodami aagaitai ʌSuusi Cristo Diuusi maradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaía ʌrñiooquituldiadamigadʌcatadai Diuusi dai aagai sai Diuusi pocaiti: Ootosamu aanʌ ʌmo ootosicami aapi Cristo gʌbaitʌqui Vai ʌgai aagidana ʌoodami sai divia agai aapi. Daidʌ ʌoodami ʌma duucai gʌntʌtʌgitodamu Dai camaisoimaasi ivuaadamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Diuusi ootosa agai ʌmo cʌʌli sai oidigana gamamaatʌtuldiña dai poduucai aagidamu ʌgai oodami: “Caotoma divia agai gʌrtʌaanʌdamiga cascʌdʌ ʌma duucai avʌr gʌntʌtʌgito dai camaisoimaasi ivuaada”. Asduu ooja Isaía. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tai divia ʌVuaana dai oidigana vapaconaimi ʌoodami, dai aagidi sai gʌaagai isʌma duucai gʌntʌtʌgituagi dai isgʌnvapaconacagi dai camaisoimaasi ivuaadagi sai poduucai Diuusi oigʌldana soimaascamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tai ami oidigʌrʌ dada vʌʌsi Judeea dʌvʌʌriʌrʌ oidacami dai Jerusaleenʌrʌ oidacami dai caʌca agai istuma aagaiña ʌVuaana; vaidʌ ʌVuaana vapaconaiña ami ʌgʌʌ aqui Jordánʌrʌ ismaacʌdʌ aagaiña ʌsoimaascami ismaacʌdʌ ivuaadana sai Diuusi oigʌldana. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Daidʌ ʌVuaana yuucusidʌ cameyu vopodʌcʌdʌ duñisicatadai dai givuradʌ ogicʌdʌ duñisicatadai dai cuaadana ʌgai soosoyi dai saivoli. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dai aagidiña ʌgai ʌoodami Diuusi ñiooquidʌ daidʌ itʌtʌdaiña: ―Gooquiʌrʌ divia agai ʌmai ismaacʌdʌ vaamioma viaa guvucadagai iñsaanʌ. Aanʌ tomali maiviaa sʌʌlicami iscuiquiagi dai uupasdagi susuusacadʌ gigiaragadʌ, aanʌ maitistutuidi siʌʌsi istutuidi ʌgai dai ʌgai vaamioma namʌga iñsaanʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aanʌ gʌnvapaconai aapimʌ suudagicʌdʌ dʌmos ʌgai divimu dai maaqui agai oodami guvucadadʌ Diuusi Ibʌadʌ ―astʌtʌdaiña ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tai aidʌ tuigaco ii ʌSuusi Nasareetaiñdʌrʌ Galilea dʌvʌʌriaiñdʌrʌ mʌʌca siaaco daacatadai ʌVuaana taidʌ ʌVuaana vacoi ʌSuusi ami ʌaqui Jordánʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Amaasi mosvuusai ʌSuusi suudagiaiñdʌrʌ dai tʌʌ tʌvaagi taidʌ gʌcupioco dai Diuusi Ibʌadʌ ʌmo tugu maasi tʌvai ʌgai daama. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tai caidatu ʌmo ñiooqui tʌvaagiaiñdʌrʌ daidi caiti: ―Aapiapʌ ʌrgiñmara ismaacʌdʌ aliʌ oigʌdai aanʌ dai aliʌ baigiñʌlidi aanʌ aapicʌdʌ ―ascaiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tai gooquiʌrʌ Diuusi Ibʌadʌ vaidacai ʌSuusi oidigamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tai ʌgai ii dai oidigana daja goo coobai tasai cʌcʌisi saagida vaidʌ ʌDiaavora soimaasi iduiñtulda ʌliditadai ʌSuusi. Tai dada Diuusi tʌtʌaañicarudʌ dai nuucada ʌSuusi sai maisoimaasi iduiñtuldana ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aidʌ tuigaco sidʌ ʌEroodʌsi maisa ʌVuaana, ii ʌSuusi Galileeamu, dai gaaagidimi Diuusi ñiooquidʌ dai isducatai gatʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Daidʌ itʌtʌdai ʌgai ʌʌpʌ ʌoodami: ―Casi atyoga aayi istuigaco soiña agai Diuusi oodami sai cʌʌgacʌrʌ oidacana cascʌdʌ ʌma duucai avʌr gʌntʌtʌgito vuitapi Diuusi dai vaavoituda isDiuusi cʌʌgacʌrʌ vuvaida agai oodami ―astʌdai Suusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ʌgʌʌ suudagi ismaacʌdʌ Galilea tʌʌgidu ugidiana sʌʌli imʌitadai ʌSuusi dai tʌʌ gooca gʌnsiʌʌgʌmʌ Simuñi ʌʌmadu Aandʌrʌsi. Ʌgai ʌrvatopa vuudamicatadai dai suudarʌ dadaitudai gʌnvatopa vuicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Taidʌ ʌSuusi itʌtʌdai: ―Giñoidávurai nai aanʌ gʌnmaatʌtuldana mʌsducatai gaagadagi oodami vaidʌ giñvaavoitudaiña ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tai ʌgai otoma anaasi viaa gʌnvatopa vuicaru dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Vaidʌ ʌSuusi apiaimʌi dai baitʌquioma tʌʌ ʌJacovo Sevedeo maradʌ dai Vuaana Jacovo suculidʌ, vai ʌmo vaarcu ʌrana daraajatai darasdi gʌnvatopa vuicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Taidʌ ʌSuusi vaí ʌgai sai oidana tai ʌgai anaasi vaarcu ʌrana viaa gʌnooga ʌʌmadu ʌpipiooñigadʌ dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Amaasi aayi ʌgai Capernauumʌrʌ; dai mosaayi ibʌstaragai tasʌrʌ tai vaa ʌSuusi ʌjudidíu quiuupaigadʌrʌ dai gʌaagacai gamamaatʌtuldimi Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dai vʌʌscatai ismaacʌdʌ caʌ maitʌʌ isducatai gʌntʌtʌgituagi caʌcatai siʌʌ cʌʌga ñioocai ʌSuusi. Ʌmo sʌʌlicami viaacami duucai gamamaatʌtuldi ʌgai dai maisiu ʌpan duucai ʌmo mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dai ami ʌjudidíu quiuupaigadʌrʌ daacatadai ʌmo cʌʌli ismaacʌdʌ viaacatadai ʌmo Diaavora tʌaañicarudʌ daidʌ ʌDiaavora tʌaañicarudʌ iiñaquitu ʌcʌʌli daidʌ itʌtʌdai ʌgai Suusi: ");
INSERT INTO ntpNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Tuipʌsi gʌrsaagida vapacʌi aapi Suusi Nasareetʌrʌ oidacami? ¿Gʌrcoodapʌsi agai dai divia? Aanʌan gia cʌʌga gʌmaatʌ dai maatʌ aanʌ pʌsiʌrDiuusi maradʌ ismaacʌdʌ tomali ʌmo imidagai maisoimaasi ivueeyi ―astʌtʌdai ʌcʌʌli ismaacʌdʌ viaacatadai ʌDiaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Taidʌ ʌSuusi bagaimi ʌDiaavora tʌaañicarudʌ daidʌ itʌtʌdai: ―Maitiñioocada mosaivuusai dai dagito gocʌʌli ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tai amaasi ʌDiaavora tʌaañicarudʌ suiquituli ʌcʌʌli dai gʌgʌrʌ iiñaquimi dai vuusai ʌcʌʌliaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tai vʌʌscatai ismaacʌdʌ ami daraajatadai aliʌ duduaadimu, dai aipaco gʌntʌcacaimi daidʌ icaitimi: ―¿Tumaasi goovai? ¿Tuma utudui gʌrmamaatʌtuldi goovai? Gocʌʌli gia sʌʌlicʌdʌ viaa guvucadagai asta ʌDiaavora tʌtʌaañicarudʌ ʌʌpʌ ʌʌgidi dai vuuvacʌi oodamiaiñdʌrʌ ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tai otoma gʌmaí vʌʌsi Galilea dʌvʌʌriʌrʌ istumaasi ivuaadatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aidʌsi vuvaja ʌjudidíu quiuupaigadʌaiñdʌrʌ ʌSuusi ʌʌmadu ʌJacovo ʌʌmadu ʌVuaana oí ʌgai ʌSimuñi dai ʌAandʌrʌsi quiidiamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Vaidʌ ʌSimuñi tuumudʌ aliʌ coococatadai oiditai toiñdagai dai caatʌcatadai, mʌtai aagidi ʌSuusi sai ʌgai coococatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Taidʌ ʌSuusi miaadʌrʌ cʌquiva dai noviaiñdʌrʌ bʌi dai vañigi. Mospodui ʌgai tai dagito ʌtoiñdagai, dai ʌgai vaa ooqui ʌgai dai bibi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dai aidʌsi catuca, mʌtai vuaapi ʌSuusi vʌʌsi ʌcoococoidadʌ dai ismaacʌdʌ viaacatadai ʌDiaavora tʌtʌaañicarudʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dai vʌʌsi ʌoodami gʌnʌmpagi ami quitaagiña. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Taidʌ ʌSuusi duduaadi muidutai naana maasi coocodagai viaacami dai vuvaitu oodamiaiñdʌrʌ mui Diaavora tʌtʌaañicarudʌ. ɅDiaavora tʌtʌaañicarudʌ gia maatʌcatadai ʌSuusi dʌmos ʌgai maidadagitoiña isñioocada ʌgai sai maimaasico vuajana ʌoodami vuitapi sioorʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ɅSuusi siaalimodʌ vañi quiaa tucagamucatai dai ii oidigamu dai mʌʌca gamamada agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Taidʌ ʌSimuñi ʌʌmadu ʌaaduñdʌ gaagamu ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dai aidʌsi tʌʌ ʌgai potʌtʌdai: ―Vʌʌsi oodamiava ʌgaagai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dʌmos ʌSuusi itʌtʌdai: ―Timʌda sibʌacoga dai ami gaaagida ʌʌpʌ Diuusi ñiooquidʌ. Gomaasi ivuaada iñagai aanʌ dai divia tami oidigi daama ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dai ii vʌʌsi ʌjudidíu quiquiuupaigadʌrʌ Galilea dʌvʌʌriʌrʌ dai ami gamamaatʌtuldimi Diuusi ñiooquidʌ dai vuvaidimi Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taidʌ ʌSuusi miaadʌrʌ cʌquiva ʌmo cʌʌli ismaacʌdʌ viaacatadai ʌmo coocodagai ismaacʌdʌ duvaldi gatuucuga, dai gʌtootonacʌdʌ cʌquiva daidʌ itʌtʌdai: ―Pʌsipʌliadagi istutuidi aapi isgiñduaaidagi ―astʌtʌdai ʌcʌʌli coocoadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Taidʌ ʌSuusi soigʌʌldan tadatu dai taata gʌnovicʌdʌ daidʌ itʌtʌdai: ―Ipʌlidiana isgʌduaaidagi, duaadicami ivii ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mospotʌi ʌSuusi tai maigo ii ʌcʌʌli coocodadʌ dai cacʌʌ duaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Taidʌ ʌSuusi ootoi dai sʌʌlicʌdʌ daí isaagada ʌgai gomaasi daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Dañi, maitiaagiada tomali ʌmaadutai pʌsducatai dueeyi mosai imi dai mʌʌ vuidʌrʌ cʌquiva ʌpaali dai oida istumaasi aagai Moseesacaru sʌʌlicamigadʌ vai nʌidiña ʌoodami pʌscadueeyi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Taidʌ ʌcʌʌli mosii dai otoma aagidimi vʌʌscatai isducatai ʌpʌdui. Cascʌdʌ ʌSuusi maitistutuiditadai isvaquiagi tomali ʌmapʌcʌrʌ vʌʌsi oidacami vuitapi dai baiyoma mosugidiana aimʌraiña siaaco maitiipucatadai oidacami, vai vʌʌscʌrʌ muidutai aipadʌrʌ ajioopaiña siaaco ucami daaca ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dai bochiʌʌqui tasaicʌdʌ ʌSuusi ʌpamu ii Capernauumamu; tai otoma maí ʌoidacami isgʌquiiyʌrʌ daacatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dai otoma sʌʌlicʌdʌ mui gʌnʌmpagi oodami tomali maiaʌcatadai siaa sʌʌli vaapaquiagi aa; vai ʌgai gamaatʌtulditadai Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Amaasi aayi maacova cʌcʌʌli dai uusiʌrʌ bʌcaiticatadai ʌmo cʌʌli ismaacʌdʌ maitistutuiditadai isoiñiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dʌmos maitʌtʌgaitadai ʌgai isducatai aitudagi ʌcoocoadʌ siaaco daacatadai ʌSuusi mosʌʌ muiducatai oodami, dai amaasi vaaqui daama tʌʌtʌsai dai siaaco daacatadai ʌSuusi sʌʌli daama cupioco dai amui sʌʌli tʌvañi ʌcoocoadʌ uusiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dai aidʌsidʌ ʌSuusi tʌʌ siʌʌ cʌʌga vaavoitudaitadai ʌgai, itʌtʌdai ʌgai ʌcoocoadʌ: ―Giñmara gʌsoimaascamiga caoigʌldi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dʌmos ʌʌmoco mamaatʌtuldiadami sʌʌlicami ismaacʌdʌ ami daraajatadai ʌpʌnʌlidi: ");
INSERT INTO ntpNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Istuisidʌ poduucai ñioocai gocʌʌli? Parundan caiti goovai Diuusi, tomali ʌmaadutai maitistutuidi isgaoigʌliadagi gasoimaascamiga mosʌʌgi Diuusi”, asʌnʌlidi ʌmamaatʌtuldiadami sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dʌmos ʌSuusi maatʌcatadai istumaasi gʌntʌtʌgitoitadai ʌgai daidʌ itʌtʌdai: ―¿Tuimʌsi poduucai gʌntʌtʌgitoi aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tumaasi siooma maisijaiga isaagidagi gocoocoadʌ: “Gʌsoimaascamiga caoigʌldi”, siʌpʌ potʌʌdagi: “Vañigiñi dai bʌi gʌvaacosi dai imʌda”? ");
INSERT INTO ntpNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gʌntʌʌgidamu aanʌ iñsaanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami viaa guvucadagai ʌʌpʌ tami oidigi daama isgaoigʌldiada gasoimaascamiga ―astʌtʌdai ʌSuusi ʌmamaatʌtuldiadami sʌʌlicami. Dai amaasi itʌtʌdai ʌgai ʌcʌʌli coocoadʌ: ");
INSERT INTO ntpNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Aapi angʌaagidi vañigiñi dai bʌi gʌvaacosi dai noragi gʌquiiyamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Taidʌ ʌcoocoadʌ otoma vañi; dai bʌi gʌvaacosi dai vuusai abiaadʌrʌ vʌʌscatai vuitapi. Tai vʌʌscatai camaitʌʌ isducatai gʌntʌtʌgitoagi tʌʌgacai goomasi dai cʌʌga ñiooquimi Diuusi vʌʌtarʌ daidʌ icaiti: ―Tomali ʌmo imidagai mainʌidiña aatʌmʌ gomaasi ―ascaitimi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Dai gooquiʌrʌ ii ʌSuusi ʌpamu ʌgʌʌ suudagi ugidiana; dai aidʌsi vʌʌsi ʌoodami miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi tai ʌgai mamaatʌtuli Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dai aidʌsi daivusquimi ʌSuusi ʌmapʌcʌrʌ tʌʌ ʌmo cʌʌli Leví tʌʌgiducami Alfeo maradʌ vai daacatadai ami siaaco gavuudana ʌgai tumiñsi. Ʌgai ʌrtumiñsi vuudamicatadai, taidʌ ʌSuusi itʌtʌdai: ―Giñoidáni ―astʌtʌdai. Taidʌ ʌLeví otoma cʌquiva dai oí. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dai aidʌsidʌ gacuaadatadai ʌSuusi Leví quiidiʌrʌ ʌʌmadu muidutai tumiñsi vuudami ʌʌmadu aa soimaasi ivuaadami. Vʌʌscatai mesa vuidʌrʌ daraajatadai ʌʌmadu ʌSuusi dai vʌʌsi ʌSuusi mamaatʌrdamigadʌ ʌʌpʌ. Aliʌ muiducatadai ismaacʌdʌ oidatucuiña. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dʌmos ʌmamaatʌtuldiadami sʌʌlicami ʌʌmadu ʌfariseo tʌʌgacai isʌSuusi vʌʌscatai ʌʌmadu gacuaadatadai itʌtʌdai ʌgai ʌmamaatʌrdamigadʌ: ―¿Tuisidʌ gʌnmamaatʌtuldiadamiga ʌʌmadu gacueeyi daidʌ yʌʌyi tumiñsi vuudami dai soimaasi ivuaadami ʌʌmadu? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dʌmos aidʌsi caʌ ʌSuusi imaasi itʌtʌdai: ―Ismaacʌdʌ maicoococoñi maitʌgito duduaaidiadami mosʌcaasi ismaacʌdʌ coococoñi. Dai poduucai aanʌ maisiu cʌʌga ivuaadami vʌʌtarʌ divia. Aanʌ divia dai cʌʌgacʌrʌ vuvaida iñagai soimaasi ivuaadami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ʌmo imidagai gayunanducai ʌVuaana mamaatʌrdamigadʌ ʌʌmadu ʌfariseo mamaatʌrdamigadʌ, tai dada ʌʌmoco oodami siaaco daacatadai ʌSuusi dai tʌcacai daidʌ itʌtʌdai: ―¿Tuisidʌ gayunandui ʌVuaana mamaatʌrdamigadʌ ʌʌmadu ʌfariseo mamaatʌrdamigadʌ, vai aapi gʌmamaatʌrdamiga vʌʌscʌrʌ gacuadana? ―astʌtʌdai ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Istutuidisi isgayunanduagi ʌvapaidarsicʌdʌ ʌmo cunataragiʌrʌ siʌʌscadʌ quiaa daraajagi ʌcucuntadami? Siʌʌscadʌ quiaa daraajagi ʌcucuntadami maitʌaagai isgayunandudagi ʌvapaidarsicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dʌmos istodian duucai gʌmuaatudagi ʌcʌʌli aidʌ gia gayunanduan tada ʌvapaidarsicʌdʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","Dai vaamioma aagidi daidʌ itʌtʌdai: ―Tomali ʌmaadutai maitistutuidi isvaavoitudagi istumaasi gamamaatʌtuldi aanʌ dai apiavaavoitudadagi gʌvaavoitudaraga ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ʌmo imidagai ibʌstaragai tasʌrʌ tʌligi ʌsicami saagida imʌitadai ʌSuusi; vaidʌ ʌmamaatʌrdamigadʌ vaiñcumaimi tʌligi muuradʌ saagida iimʌitai. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Vaidʌ ʌfariseo itʌtʌdai ʌSuusi: ―Dañi ¿tuisidʌ ivueeyi gʌmamaatʌrdamiga aa duiñdagai ismaacʌdʌ Moseesacaru sʌʌlicamigadʌ aagai sai maitiipu oigaragai isivuaadagi ibʌstaragai tasʌrʌ? ―astʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dʌmos ʌSuusi itʌtʌdai: ―¿Tomali ʌmo imidagai mʌsmaiquiaa nʌidi aapimʌ ʌoojai siaaco aagai istumaasi idui ʌDavi ʌʌmadu ʌaaduñdʌ ʌmo imidagai aliʌ oidacai biuugigai? ");
INSERT INTO ntpNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Siaaco aagai sai vaa ʌDavi quiuupiʌrʌ aidʌsidʌ ʌAbiaataʌrʌ ʌbaitʌcʌaacamigadʌcatadai papaali, dai bʌi ʌgai ʌcuaadagai Diuusi dasdaradʌ ismaacʌdʌ ʌʌgi papaali viaacatadai oigaragai isugiagi tai ʌgai uu dai aa oí gʌaaduñi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Daidʌ itʌtʌdai ʌʌpʌ ʌSuusi ʌfariseo: ―Ibʌstaragai tasai ʌrsiaa duutudaragai Diuusi vʌʌtarʌ. Vaamioma namʌga oodami siʌibʌstaragai tasai. ");
INSERT INTO ntpNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cascʌdʌ aanʌ iñsmaacʌdʌ viaa ʌmo sʌʌlicami ʌʌpʌ viaa guvucadagai isgaaagiadagi istumaasi gʌaagai isivuaadagi ibʌstaragai tasʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Taidʌ ʌSuusi vaa ʌpamu ʌmo quiuupaigadʌrʌ ʌjudidíu vai ami daacatadai ʌmo cʌʌli ismaacʌdʌ gaquisapi ʌmo novidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vai aa soobidacatadai ʌSuusi dai nʌida agai sabai duaaidana ʌgai ʌcʌʌli ibʌstaragai tasʌrʌ vai poduucai viaaca ʌgai istucʌdʌ gʌʌpi ʌrvuaajagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Amaasi ʌSuusi itʌtʌdai ʌcʌʌli ismaacʌdʌ gaquisapi ʌcadʌ: ―Vañigiñi dai ʌran ʌʌsi cʌquiva ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dai amaasi itʌtʌdai ʌSuusi ʌoodami ismaacʌdʌ ami daraajatadai: ―¿Tumaa aagai Moseesacaru sʌʌlicamigadʌrʌ? ¿Isoidaga oigaragai isivuaadagi ibʌstaragai tasʌrʌ ʌmo istumaasi cʌʌgaducami maicʌʌgaducami sio? ¿Cʌʌgacʌrʌ vuusaidagi ʌmo oodami muaagi sio? ―astʌtʌdai ʌSuusi. Dʌmos ʌgaa maiñiooca vii. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Vaidʌ ʌSuusi baamudacʌdʌ nʌnʌidi dai soiʌliaragaicʌdʌ maimaatʌ caʌcatai ʌgai istumaasi aagidi ʌSuusi. Amaasi ʌSuusi itʌtʌdai ʌcʌʌli ismaacʌdʌ gaquisapicatadai noovidʌ: ―Sʌʌliñañi gʌnovi ―astʌtʌdai. Tai ʌgai sʌʌli dai cacʌʌga duaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tai amaasi otoma vuvaja ʌfariseo abiaadʌrʌ dai avʌnaquida agai ʌEroodʌsi aaduñdʌ dai muaa agai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Dʌmos ii ʌSuusi ʌʌmadu ʌmamaatʌrdamigadʌ ʌgʌʌ suudagi ugidiamu, tai mui oodami Galileeʌrʌ oidacami oí. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Dai aidʌsi aa oodami maí ʌʌpʌ isivuaadatadai ʌSuusi istumaasi gʌgʌrducami muidutai dada siaaco daacatadai ʌgai dai nʌida agai Judeeaiñdʌrʌ, dai Jerusaleenaiñdʌrʌ, dai Idumeaiñdʌrʌ dai vasmocoradʌrʌ ʌgʌʌ aqui Jordán dai Tiiro dʌvʌʌriaiñdʌrʌ dai Sidooniaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Vaidʌ ʌSuusi caʌʌquiasdʌrʌ abiaadʌrʌ aagidi gʌmamaatʌrdamiga sai baiduiñdacana ʌmo vaarcu, vai ami daaca agai ʌgai sai mainuituscʌiña mosʌʌqui oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ɅSuusi casʌʌlicʌdʌ mui duduaadi oodami gʌguvucadacʌdʌ vai cascʌdʌ aa coococoidadʌ aipaco nuituscʌiña ʌSuusi vʌʌscatai taata ʌliditai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vaidʌ ʌoodami ismaacʌdʌ viaacatadai Diaavora tʌtʌaañicarudʌ mostʌtʌʌgaiña ʌSuusi dai vuidʌrʌ gʌtootonacʌdʌ guguucaiña vaidʌ ʌDiaavora tʌtʌaañicarudʌ iiñaquitudaiña vai ʌgai itʌtʌdaiña: ―Aapiapʌ ʌrDiuusi maradʌ ―astʌtʌdaiña. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dʌmos ʌSuusi sʌʌlicʌdʌ daí ʌDiaavora tʌtʌaañicarudʌ ismaasiuldagi sioorʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dai gooquiʌrʌ tʌsai ʌSuusi ʌmo giidiamu, dai vaidacai ismaacʌdʌ ʌgai ipʌli tai ʌgai oí. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dai amaasi ʌcovai vuvaitu baivustaama dan gooca ʌoodami saagidaiñdʌrʌ sai ʌʌmadu ajioopaiña, dai sai gooquiʌrʌ gaaagidiña ʌgai Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Dai maa guvucadagai sai duduaaidiña coococoidadʌ dai sai vuvaidiña Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ʌcovai vusaitu ʌSuusi, Simuñi Piiduru, dai ");
INSERT INTO ntpNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacovo dai siʌʌgidʌ ismaacʌdʌ Vuaana tʌʌgidu ʌgai ʌrSevedeo maamaradʌ, dai Suusi Boanerges aagai ʌgai ismaacʌdʌ tʌiya ʌlidi cʌcʌʌli ismaacʌdʌ cavami ñioocai ʌpan duucai covoñdami. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Dai Aandʌrʌsi, dai Piili, dai Bartolomé, dai Mataivo, dai Tomás, dai Jacovo. Alfeo maradʌ dai Tadeo, dai Simuñi ismaacʌdʌ ʌrʌmoco ismaacʌdʌ vuvaida ʌliditai ʌromamano. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Dai Uudasi Iscaliote ismaacʌdʌ gooquiʌrʌ gatʌʌgi ʌSuusi mʌsai muaana. Dai gooquiiʌrʌ vaa ʌSuusi ʌmo quiiyʌrʌ ʌʌmadu ismaacʌdʌ ʌcovai vuvaitu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tai ʌpamu sʌʌlicʌdʌ mui gʌnʌmpagi oodami ami quiiyʌrʌ vai ʌgai tomali maitistutuiditadai isgaugiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dai aidʌsi maí ʌSuusi aaduñdʌ gomaasi dada dai vaidaquia agai pocaititai sai vuiirutu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vaidʌ ʌmamaatʌtuldiadami sʌʌlicami ismaacʌdʌ Jerusaleenaiñdʌrʌ dada icaiti: ―Idi cʌʌli viaa Beelsevú ismaacʌdʌ ʌrDiaavora vai ʌgai guvucadadʌcʌdʌ vuvaidi goovai Diaavora tʌtʌaañicarudʌ ―ascaiti ʌmamaatʌtuldiadami sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tai amaasi ʌSuusi vaí ʌoodami dai aagidi ʌmo ñiooqui cuentocʌdʌ daidʌ itʌtʌdai: ―¿Siaadʌrʌ istuidʌna ʌDiaavora isʌʌgi gʌvusaidagi oodamiaiñdʌrʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Isʌmapʌcʌrʌ oidacami ʌʌgi gʌncocodagi otoma aipacoga gʌncoodian tada ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Isʌmo quiiyʌrʌ oidacami ʌʌgi gʌncocodagi otoma aipaco gʌncoodian tada ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dai siʌDiaavora ʌʌgi gʌvui gʌsiaa ʌliada siaadʌrʌ istuidʌna ʌgai, baiyoma mosugitian tada ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tomali ʌmaadutai maivaquian tada ʌmo cʌʌli omaligami quiidʌrʌ dai ʌʌsidagi, ismaivuliagi ʌʌpʌgʌ; avʌnacai isvulia gia gʌdagituan tada ʌgai mʌsʌʌsdagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sʌʌlicʌdʌ aan gʌnaagidi sai baiga isoigʌldagi oodami vʌʌsi soimaascamigadʌ dai issoimaasi ñiooqui ñioocada ʌgai ʌʌpʌ; ");
INSERT INTO ntpNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dʌmos sioorʌ vui ñioocadagi Diuusi Ibʌadʌ ʌgai gia maiviaa oigʌldaragai tomali ʌmo imidagai poduucai ʌgai ʌrduñidʌ tomastuigaco ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ɅSuusi poduucai aagidi ʌoodami pocaititai ʌgai saidʌ ʌSuusi viaa ʌmo Diaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tai gooquiʌrʌ ami dada ʌSuusi susuculidʌ ʌʌmadu ʌdʌʌdʌ, dʌmos quiidigaiñdʌrʌ vii ʌgai dai abiaadʌrʌ ootosi ñiooqui ʌSuusi sai diviana. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Vai ʌgai ismaacʌdʌ sonuana daraajatadai ʌSuusi itʌtʌdai: ―Quiidigaiñdʌrʌ daraaja gʌdaada ʌʌmadu gʌsusuculi daidʌ gʌgaagai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dʌmos ʌSuusi itʌtʌdai: ―¿Voorʌ ipʌlidi aapimʌ isʌrgiñdaada daidʌ giñsusuculi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dai amaasi nʌnʌidi vʌʌscatai ismaacʌdʌ ami sicoli daraajatadai siaaco daacatadai ʌgai daidi tʌi: ―Idi ʌʌpʌ ʌrʌpan ducami giñdaada dai giñsusuculi. ");
INSERT INTO ntpNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tomasioorʌ sioorʌ ivuaadagi istumaasi Diuusi ipʌlidi ʌgai ʌʌpʌ ʌrʌpan ducami giñdaada ʌʌmadu giñsusuculi ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ʌʌpʌ ʌmo imidagai gamamaatʌtulditadai ʌSuusi ʌgʌʌ suudagi ugidiana, tai sʌʌlicʌdʌ mui gʌnʌmpagi oodami ami siaaco daacatadai ʌgai. Dai sʌʌlicʌdʌ muiducatadai ʌgai tai cascʌdʌ ʌSuusi ʌmo vaarcu ʌraana daiva gʌʌ suudagi daama. Tai vʌʌsi ʌoodami ooratana vii. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Taidʌ ʌSuusi aagidi mui naana maasi cuentocʌdʌ dai aidʌsi mamaatʌtuldi ʌgai itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Caʌcavurai aapimʌ imaasi: Ʌmo imidagai ʌmo oodami gaʌi, ");
INSERT INTO ntpNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","tai chiʌʌqui ʌstucai voiyʌrʌ suuli; tai dada ujuurugi dai cuucu. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tai aa ʌstucai ojoodai saagida suuli, siaaco maisi tiipu dʌvʌʌrai; dai otoma vuvaja maisi tuucavi suuli ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dai mosvuusai tasai tai vuaama dai maisi tataaca ʌgai cascʌdʌ mosgaquisa. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dai aa ʌstucai uuparai saagida suuli taidʌ ʌuuparai gʌʌ dai mosvuaamatu, tai poduucai ʌtʌligi maiiibaji. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tai aa ʌstucai cʌʌgaducami dʌvʌʌriʌrʌ suuli dai vuvaja dai cʌʌga gʌʌ, dai cʌʌga iibaji. Ʌmo caidʌaiñdʌrʌ ʌmo coobai dan baivustaama vuvaja, dai ʌmiaiñdʌrʌ vaicoobai, dai ʌmiaiñdʌrʌ ʌmo siento. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Cʌʌgavʌr gʌntʌgito caʌca aapimʌ istumaasi gʌnaagidi aanʌ ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Amaasi caiimʌcai ʌoodami tai ʌʌgi vii ʌSuusi ʌbaivustaama dan gooca gʌmamaatʌrdamiga ʌʌmadu. Dai ʌgai ismaacʌdʌ sonuana daraajatadai ʌSuusi tʌcacai astʌiya ʌlidi ʌgai ʌcuentocʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Taidʌ ʌSuusi itʌtʌdai: ―Diuusi gʌnmaatʌtuldamu aapimʌ mʌstumaasi maimaatʌ isducatai ipʌlidi Diuusi issoicʌdagi oodami sai cʌʌgacʌrʌ oidacana dʌmos gogaa mamaatʌtuldi aanʌ cuentocʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ʌgai canʌidiña istumaasi ivuaadana aanʌ dai maitipʌlidi isgiñvaavoitudagi dai caʌcana istumaasi gamamaatʌtuldi aanʌ dai maitipʌlidi ismaatʌ caʌcagi, cascʌdʌ Diuusi maioigʌldi soimaascamigadʌ dai maicʌʌgacʌrʌ vuvaidamu ʌgai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Daidʌ itʌtʌdai ʌgai ʌʌpʌ: ―¿Maitamʌsmaatʌ caʌ aapimʌ idi cuento? ¿Ducatai maatʌ caʌca agaidʌ aapimʌ ʌgaa cuentoo? ");
INSERT INTO ntpNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ʌcʌʌli ʌsadami ʌrʌpan ducami ʌmoco ismaacʌdʌ aagidiña oodami Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ʌʌmoco oodami ʌpan ducami ʌʌstucai ismaacʌdʌ voiyʌrʌ suuli ismaacʌdʌ caʌcana Diuusi ñiooquidʌ vai didivai ʌDiaavora dai maigovai dadasai ʌñiooqui ibʌadʌaiñdʌrʌ sai maivaavoitudana. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dai aa oodami ʌpan ducami ʌʌstucai ismaacʌdʌ ojoodai saagida suuli ismaacʌdʌ baigʌnʌliaracʌdʌ caʌcana Diuusi ñiooquidʌ dai vaavoitudaiña, ");
INSERT INTO ntpNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","dʌmos maiquiaa sigupucatʌrdan vuaadana ʌgai vaavoidaragadʌ cascʌdʌ mosparunaiña aa ʌñiooquicʌdʌ dai soimaa taatamituldiña vai ʌgai caugiatʌi vaavoidaragadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dai aa oodami ʌpan duucami ʌʌstucai ismaacʌdʌ uuparai saagida suuli caʌcana ʌgai Diuusi ñiooquidʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","dʌmos aliʌ tʌtʌgitoiña ʌgai istumaasiʌrʌ ismaacʌdʌ oidaga tami oidigi daama, tumiñsiʌrʌ dai vʌʌsiaʌcatai viaaca ʌlidiña ʌgai dai mosgomaasiʌrʌ tʌtʌgitoiña dai camaitʌtʌgitoiña Diuusi ñiooquidʌ cascʌdʌ maitivueeyi istumaasi Diuusi ipʌlidi dai maicʌʌgacʌrʌ vuvacʌi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Daidʌ ʌʌstucai ismaacʌdʌ cʌʌgaducami dʌvʌʌriʌrʌ suuli ʌpan ducami ʌoodami ismaacʌdʌ baigʌnʌliaracʌdʌ caʌcana Diuusi ñiooquidʌ dai vaavoitudaiña daidʌ ivuaadana istumaasi Diuusi ipʌlidi. Ʌʌmoco ʌrʌpan ducami ʌʌstucai ismaacʌdʌ ʌmo coobai dan baivustaama vuvaja ʌmo caidʌaiñdʌrʌ dai ʌmiaiñdʌrʌ vaicoobai dai ʌmiaiñdʌrʌ ʌmo siento ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dai gooquiʌrʌ itʌtʌdai ʌʌpʌ: ―Tomali ʌmo oodami maicucuudagʌi ʌmo cuudacarui dai gooquiʌrʌ iiñapai tomali maivoicarui uta dadasai. Baiyoma tʌcavi gʌdadasai vai cʌʌga maasicagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Poduucai istumaasi aanʌ gamamaatʌtuldi vʌʌsi gʌmaasiuldi, sivi maiquiaa cʌʌga maatʌ caʌ ʌoodami dʌmos gooquiʌrioma gia vʌʌsi maatʌ caʌcamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Cʌʌgavʌr gʌntʌgito caʌca aapimʌ istumaasi gʌnaagidi aanʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Daidʌ itʌtʌdai ʌʌpʌ: ―Ʌʌgiditai avʌr caʌca aapimʌ vʌʌsi mʌstuma caʌ. Iscʌʌga ʌʌgiditai caʌca aapimʌ giñmamaatʌtuldaraga vaamioma cʌʌga maatʌ caʌcamu vʌʌsi istumaasi gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sioorʌ bʌʌjʌi giññiooqui dai giñʌʌgidi ʌgai vaamioma maatʌtuldamu aanʌ, dai sioorʌ maibʌʌjʌi giññiooqui dai maitiñʌʌgidi voopoidamu aanʌ istumaasi maatʌ gʌʌlidi ʌgai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Daidʌ ʌSuusi itʌtʌdai ʌʌpʌ ʌoodami: ―Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitona. Gomaasi ʌrʌpan ducami aidʌsi ʌmo oodami ʌi tʌligi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dai gooquiʌrʌ nonoragʌi dai cocosʌi, vaidʌ chiʌʌqui tasaicʌdʌ vuvacʌi ʌtʌligi dai gʌʌrai, vaidʌ ʌcʌʌli maimaatʌcana isducatai. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ʌdʌvʌʌrai ʌʌgi baivueeyi cuaadagai ʌcʌʌli mosʌcaasi nuucada ʌʌsicami. Ʌʌpʌga vuvacʌi aagadʌ dai gooquiʌrʌ muuradʌ, dai gooquiʌrʌ ibiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dai siʌʌscadʌ cacaibia ʌgai vai aiyagi yoovaragai otoma gʌyoovai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Daidʌ itʌtʌdai ʌʌpʌ ʌSuusi ʌoodami: ―Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana. Dai aanʌ cuentocʌdʌ gamamaatʌtuldi isducatai ivueeyi gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gomaasi ʌrʌpan ducami istumaasi ʌpʌvueeyi ʌcaidʌ ʌmo uusi ismaacʌdʌ ʌpʌa maasi coravi caidʌ. Goovai ʌraliducʌdioma uusi caidʌ oidigi daama ");
INSERT INTO ntpNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ismaacʌdʌ gʌʌsai vai gʌgʌrʌ dai gʌgʌrʌ mamartai vaidʌ ʌujuurugi ʌʌcagidʌrʌ gʌniibʌstaiña ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Poduucai mamaatʌtuldiña ʌSuusi Diuusi ñiooquidʌ ʌoodami goʌʌ cuentocʌdʌ tomasi maimaatʌ caʌcana ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Maitiipucana ʌmo imidagai ismaiaagiada ʌSuusi ʌmo istumaasi cuentocʌdʌ dʌmos gooquiʌrʌ vʌʌsi aagidiña ʌgai gʌmamaatʌrdamiga istʌiya ʌlidi cuento. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dai ʌgai vaa tasʌrʌ aidʌsi catucaimi ʌSuusi itʌtʌdai gʌmamaatʌrdamiga: ―Tiimʌda vaasadʌrʌ gogʌʌ suudagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Taidʌ ʌmamaatʌrdamigadʌ anaasi viaa ʌoodami dai vaidacai ʌSuusi ʌvaarcuʌrʌ ismaacʌdʌrʌ daacatadai ʌgai, tai aa oodami oí ʌʌpʌ aa vaarcuʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tai caavami ʌvʌ daidʌ ʌʌvʌli nuituscʌi suudagi vai vaarcu ʌraana vaacʌi dai cayoga suuda ʌvaarcu suudagicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Vaidʌ ʌSuusi ʌvaarcu gooquiamadʌrʌ coosocatadai. Taidʌ ʌmamaatʌrdamigadʌ nʌñitu ʌgai daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, ¿maitapʌs vuaamʌ ʌlidi tʌsbaicoagi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tai vañi ʌSuusi dai dodoligitu ʌʌvʌʌli ʌʌmadu ʌgʌʌ suudagi daidʌ itʌtʌdai: ―Gʌʌʌpidañi ―astʌtʌdai. Taidʌ ʌʌvʌʌli gʌʌʌpitu tai vʌʌsi dodoli vii ");
INSERT INTO ntpNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","amaasi ʌSuusi itʌtʌdai gʌmamaatʌrdamiga: ―¿Tuimʌsi duduaadimuca dai maivaavoitudai iñsaanʌ istutuidi isgʌnnuucadajagi? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Vai ʌgai aliʌ duduaadimuca dai aipaco gʌnaagidi daidʌ icaiti: ―¿Sioorʌ idi cʌʌli vai asta ʌʌvʌʌli dai gogʌʌ suudagi ʌʌgidi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dai amaasi vaasadʌrʌ dʌgavusai ʌgai ʌgʌʌ suudagi dai aayi Gadara dʌvʌʌriʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Dai aidʌsi tʌvai ʌSuusi vaarcuaiñdʌrʌ tai otoma ami divia ʌmo cʌʌli caposantuaiñdʌrʌ. Ʌcʌʌli viaacatadai ʌmo Diaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ʌcʌʌli moscaposantuana oidacana vai tomali ʌmaadutai maitistutuidiña isvuracagi tomali cadeenacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Muiyoco imidagai vupuraiña aa oodami cadeenacʌdʌ noonovidʌ dai ʌʌcasodʌ dʌmos ʌgai otoma ʌʌquitudaiña vai tomali ʌmaadutai maitistutuidiña isdodoli daasacagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dai tasʌrʌ dai tucarʌ oidigana dai caposantuana aimʌraitai iiñacaiña ʌgai dai saasasaiña gʌtuucuga ojoodaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dʌmos aidʌsi tʌʌ ʌgai ʌSuusi mʌcasdʌrʌ vuidʌrʌ mʌʌ dai vuidʌrʌ gʌtootonacʌdʌ cʌquiva. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Dai iiñaquidatai itʌtʌdai: ―¿Tuipʌsi divia aapi Suusi tami siaaco aimʌrai aanʌ? Aapi ʌrDiuusi baitʌcʌaacami maradʌ. Gʌdaanʌi aanʌ Diuusi guvucadadʌcʌdʌ pai maitiñoiñiada ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Pocaiti ʌgai itʌtʌdaitai ʌSuusi: ―Aapi Diaavora tʌaañicarudʌ dagitoñi idi cʌʌli ―astʌtʌdai ʌSuusi ʌDiaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Daidʌ ʌSuusi tʌcacai ʌDiaavora tʌaañicarudʌ daidʌ itʌtʌdai: ―¿Tʌʌgidu aapi? ―astʌtʌdai. Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Legión antʌʌgidu aanʌ. Muidu aatʌmʌ cascʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Daidʌ ʌDiaavora tʌtʌaañicarudʌ daañimi ʌSuusi sai ʌgai maiootosana ami dʌvʌʌriaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vai muiducatadai tataisoli ami giidʌrʌ daida cuaayitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Taidʌ ʌDiaavora tʌtʌaañicarudʌ itʌtʌdai ʌSuusi: ―Gʌrdagitoñi tʌtai vaapaquia aatʌmʌ gotataisoliʌrʌ ―astʌtʌdai ʌDiaavora tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Taidʌ ʌSuusi maa oigaragai isvaapaquia ʌgai tataisoliʌrʌ, taidʌ ʌDiaavora tʌtʌaañicarudʌ vuvuaaja ʌcʌʌliaiñdʌrʌ dai tataisoliʌrʌ vaapa. Ʌtataisoli ʌrgoo milʌcatadai dai coidam voopoi dai gʌʌ suudarʌ suuli dai baicoi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Taidʌ ʌnuucadacami ʌtataisoli aliʌ dudaadimu dai voopoi dai mʌʌca gaaagidi quiiquiana dai dʌjiana. Tai dada ʌoodami dai nʌida agai astumaasi ʌpʌduitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dai aidʌsi aayi ʌgai ami siaaco daacatadai ʌSuusi, tʌʌ ʌcʌʌli ismaacʌdʌ viaacatadai ʌDiaavora tʌtʌaañicarudʌ vai cacʌʌga dodoli daacatadai dai cacʌʌga yuucusu taidʌ ʌoodami aliʌ duduaadamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dai ʌgai ismaacʌdʌ nʌiditadai isducatai ʌpʌdui ʌcʌʌlicʌdʌ ismaacʌdʌ viaacatadai ʌDiaavora tʌtʌaañicarudʌ daidʌ ʌtataisolicʌdʌ aagidi ʌoodami gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Taidʌ ʌoodami goguama oi ʌSuusi sai imʌna abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dai aidʌsi tʌsai ʌSuusi ʌpamu vaarcuʌrʌ vaidʌ ʌcʌʌli ismaacʌdʌ viaacatadai ʌDiaavora tʌtʌaañicarudʌ daañimi ʌSuusi sai dagitona isoidagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dʌmos ʌSuusi maimaa oigaragai, baiyoma itʌtʌdai: ―Imʌdañi gʌquiiyamu siaacoga daraaja gʌaaduñi dai aagida vʌʌsi istuma idui aanʌ aapicʌdʌ dai isducatai soigiñʌʌli aanʌ aapicʌdʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Taidʌ ʌcʌʌli ii dai mʌʌca gaaagidi Decápolisi dʌvʌʌriʌrʌ vʌʌsi istumaasi idui ʌSuusi ʌgaicʌdʌ vai vʌʌscatai maitʌtʌgaitadai isducatai gʌntʌtʌgitoagi caʌcatai istumaasi aagidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dai aidʌsi vaasadʌrʌ ʌgʌʌ suudagi divia ʌSuusi ʌpamu tai ami dada mui oodami siaaco daacatadai ʌgai. Taidʌ ʌSuusi anaasi vii ʌgʌʌ suudagi ugidiana. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tai amaasi ami divia ʌmo baitʌcʌaacami ʌjudidíu quiuupaigadʌrʌ Jairo tʌʌgiducami; dai aidʌsi mostʌʌ ʌgai ʌSuusi gʌtootonacʌdʌ cʌquiva ʌSuusi ʌʌcasodʌ abaana. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Dai sʌʌlicʌdʌ daañimi daidʌ itʌtʌdai: ―Giñmara ooqui atcayooga muu. Tinda pai daama daraasa gʌnoonovi vai duaadʌna ʌgai dai oidacana ―astʌtʌdai ʌJairo. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Taidʌ ʌSuusi oi ʌJairo; vai mui oodami oidatucuitadai ʌSuusi, dai asta nuitusquimi ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Daidʌ ʌoodami saagida imʌitadai ʌmo ooqui ismaacʌdʌ cabaivustaama dan gooca uumigi coococatadai gʌʌʌracʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dai sʌʌlicʌdʌ soimaa taatacatadai ʌgai mosʌʌ mui duduaaidiadami ʌʌmadu aimʌraitai dai casiaa dodai vʌʌsi istuma viaacatadai. Dai vʌʌscʌrʌ maidueeyi, baiyoma vaamuimi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aidʌsi cajioma ʌooqui siʌSuusi gaduduaaidiña, miaadʌrʌ cʌquiva ʌoodami saagida dai gooquiamadʌrʌ taata ʌgai ʌSuusi yuucusidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Dai poʌlidi ʌooqui: “Tomasi mosʌca yuucusidʌ taata aanʌ cascʌdʌ caduaadian tada aanʌ”, asʌliditadai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dai aidʌsi mostaata ʌgai otoma uu ʌʌradʌ dai otoma maatʌ taata ʌgai gʌtuucugʌrʌ iscamaigo ii coocodadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Taidʌ ʌSuusi maí isduaadi ʌgai ʌmaadutai gʌguvucadacʌdʌ dai amaasi gooquiamaco nʌnʌaava ʌgai daidʌ icaiti: ―¿Toorʌ taata giñyuucusi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taidʌ ʌmamaatʌrdamigadʌ itʌtʌdai: ―Canʌidi aapi isaipadʌrʌ gʌnuituscʌi gooodami pai vʌʌscʌrʌ gatʌcacai soorʌ gʌtaata ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dʌmos ʌSuusi aipaaco nʌʌjimi dai nʌida agai soorʌ taata. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vaidʌ ʌooqui gigivuquimi duaadimucai dai maatʌcatadai ʌgai isducatai ʌpʌduitadai ʌgaicʌdʌ, ii dai gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ, dai aagidi vʌʌsi isducatai ʌpʌduitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Taidʌ ʌSuusi itʌtʌdai ʌooqui: ―Giñvaavoitu aapi cascʌdʌ dueeyi. Imʌdañi dai maivuaamʌ ʌliatugada dai caduaadicami vii ―astʌtʌdai ʌSuusi ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Dai quiaa ñioocaitadai ʌSuusi tai dada ojootosicami Jairo quiidiaiñdʌrʌ daidʌ itʌtʌdai ʌali ooqui oogadʌ: ―Casi atmuu gʌmara. Casi maivaidacai gomamaatʌtuldiadami ―astʌtʌdai ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dʌmos ʌSuusi moscaʌ istumaasi aagaitadai ʌgai daidʌ itʌtʌdai ʌgai ʌbaitʌcʌaacami ʌjudidíu quiuupaigadʌrʌ: ―Maitiduaadicuda; mosai giñvaavoituda ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Daidʌ ʌSuusi maidagito ʌoodami isoidagi mosʌcaasi ʌPiiduru dai Jacovo daidʌ ʌVuaana Jacovo suculidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dai aidʌsi aayi ʌgai ʌbaitcʌcʌaacami quiidiʌrʌ, caí ʌgai ʌoodami vai siaa caiti gʌgʌrʌ suaanʌi dai iiñacai. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Taidʌ ʌSuusi vaa daidʌ itʌtʌdai ʌoodami: ―¿Tuimʌsi mosʌʌ sisiocai dai tuimʌsi mosʌʌ gʌgʌrʌ suaanʌi? Goali ooqui maitʌrmuuquiadʌ mosacooso ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Vaidʌ ʌoodami parunai pocaititai ʌSuusi. Taidʌ ʌSuusi vuvaitu vʌʌsi ʌoodami abiaadʌrʌ, dai mosʌca ʌali ooqui dʌʌdʌdʌ dagito isvaapaquiagi ʌʌmadu ʌcʌcʌʌli ismaacʌdʌ vaidaticatadai ʌgai. Dai vaapa siaaco caatʌcatadai ʌali ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Taidʌ ʌSuusi noviaiñdʌrʌ bʌi ʌali ooqui daidʌ itʌtʌdai: ―Talita cumi ―astʌtʌdai. Gomaasi itʌiya ʌlidi: Ali ooqui, aapi angʌaagidi vañigiñi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tai otoma vañi ʌali ooqui dai gʌaagacai aimʌrai. Baivustaama dan gooca uumigi viaacatadai ʌgai. Taidʌ ʌoodami maitʌʌ isducatai gʌntʌtʌgitoagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Taidʌ ʌSuusi sʌʌlicʌdʌ daí ʌoodami sai maiaagidiña tomali ʌmaadutai gomaasi. Dai gatʌjai biidaragai ʌali ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Taidʌ ʌSuusi ii abiaadʌrʌ gʌdʌvʌʌragamu, ʌʌmadu gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dai aidʌsi aayi ibʌstaragai tasʌrʌ, ʌSuusi gʌaagaca gamamaatʌtuldimi Diuusi ñiooquidʌ ʌjudidíu quiuupaigadʌrʌ. Dai muidutai ismaacʌdʌ caʌcatadai camaitʌʌ istumaasi gʌntʌtʌgitoagi daidʌ icaiti: ―¿Siaaco maí goovai vʌʌsi imaasi? ¿Ducatai istutuidi goovai ismosʌʌ cʌʌga tʌtʌgitodagi daidʌ ivueeyi goovai istumaasi gʌgʌrducami? ");
INSERT INTO ntpNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dai idiava ʌrʌuusi ivisumadami, María maradʌ daidʌ ʌrsiʌʌgidʌ ʌJacovo daidʌ ʌOsee daidʌ ʌUudasi ʌʌmadu ʌSimuñi, daidʌ ʌsusuculidʌ ooqui ʌʌpʌ tami gʌrsaagida oidaga ―ascaiti ʌoodami. Aliʌ mui naana maasi maatʌcatadai ʌSuusi cascʌdʌ baacoican tada ʌoodami ʌgai vui. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dʌmos ʌSuusi itʌtʌdai: ―Vʌʌsi oodami cʌʌgacʌrʌ nʌidiña ʌmo Diuusi ñiooquituldiadamigadʌ mosʌca ʌʌgi dʌvʌʌragadʌana oidacami gia maisiaa duutudaiña tomali aaduñdʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dai maitidui mui istumaasi gʌgʌrducami ami mosdaama daarai gʌnoonovi chiʌʌqui coococoidadʌ dai duduaadi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Daidʌ ʌSuusi maitʌtʌgaitadai istumaasi gʌtʌgitoagi nʌiditai isʌoodami maivaavoitudai. Dai gooquiʌrʌ ii ʌSuusi vʌʌsi ami dʌvʌʌriʌrʌ aipaco uugidiana dai gaaagidimi Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dai amaasi vai ʌbaivustaama dan gooca gʌmamaatʌrdamiga, dai aipaco ootoi mosgoogocatai, dai maa guvucadagai sai vuvaididana Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dai aagidi sai maivuucaiña tomali istumaasi voiyʌrʌ vʌʌtarʌ, mosʌca gʌngigiica sai maivuucaiña tomali morarali, tomali biitugai tomali tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dai sai gʌnadacaiña sususacai maisiu sasaputusi, dai sai maivuucaiña aa yuucusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Daidʌ itʌtʌdai: ―Mʌsiʌʌscadʌ ajiagi ʌmo quiiyʌrʌ vʌrai anaasi gʌnuuliñaca asta mʌsiʌʌscadʌ iimiagi ʌgai dʌvʌʌriañdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dai mʌsajiagi ʌmapʌcʌrʌ mʌsiaaco maitʌnmiaadʌgidagi dai tomali maitʌncaʌca agadagi, vʌrai vuvaqui abiaadʌrʌ dai gigigida ʌdʌvʌʌrai gʌnʌcasuaiñdʌrʌ vai poduucai nʌijada ʌgai ismaicʌʌga idui. Sʌʌlicʌdʌ angʌnaagidi sai siʌʌscadʌ Diuusi nʌida agadagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ maitʌʌrcʌʌga ivuaadami vaamioma soimaasi taatatuldamu ʌgai ʌoodami ismaacʌdʌ maitʌnmiaadʌgidagi siʌSodoomʌrʌ ʌʌmadu Gomoorʌrʌ oidacami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Taidʌ ʌmamaatʌrdamigadʌ iji dai aagidimi ʌoodami sai gʌaagai isʌma duucai gʌntʌtʌgitoagi vuitapi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dai vuvaitu ʌʌpʌ mui Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ, dai mui duduaadi coococoidadʌ mostʌiditai asaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Taidʌ ʌgʌʌ baitʌcʌaacami Eroodʌsi maí gomaasi aidʌsi cavʌʌsi aipaco gʌaagaitadai ʌSuusi. Vaidʌ ʌEroodʌsi icaiti: ―Duaacatiqui ʌVuaana ismaacʌdʌ vapaconaitadai oodami cascʌdʌ viaa ʌgai guvucadagai ―ascaiti ʌEroodʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vai aa icaiti: ―Eliiasicaru lienʌ ʌgai ʌDiuusi ñiooquituldiadamigadʌ ―ascaiti. Vai aa icaiti: ―Ʌmo Diuusi ñiooquituldiadamigadʌava ʌpan duucai ʌʌquidʌ Diuusi ñiñiooquituldiadamigadʌ ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dai aidʌsidʌ ʌEroodʌsi caʌ imaasi icaiti: ―Gooviava ʌrVuaana di, ʌgai ismaacʌdʌ gatʌjai aanʌ cuicutaragai moodʌ, dai sivi duaaca ʌgai coidadʌ saagidaiñdʌrʌ ―ascaiti ʌEroodʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ɅEroodʌsi ʌʌquioma gatʌjaitadai mʌsai bʌʌcaiña ʌVuaana dai maisacarui ʌrana vuunana cadeenacʌdʌ. ɅErodiiasi ʌrduñidʌcatadai. ɅErodiiasi ʌrooñigadʌcatadai ʌPiili Eroodʌsi suculidʌ. Dʌmos ʌEroodʌsi ʌʌsi gʌsuculi ooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Taidʌ ʌVuaana itʌtʌdai ʌEroodʌsi: ―Maitavʌaagai pʌsʌʌsiadagi gʌsuculi Piili ooñigadʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Vai cascʌdʌ ʌErodiiasi cʌʌdaitadai ʌVuaana dai muaa ʌliditadai dʌmos maitistutuiditadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ɅEroodʌsi cʌʌga maatʌcatadai isʌVuaana ʌrʌmoco cʌʌ tuigacami dai maitʌrsoimaasi ivuaadami. Dai ʌgai ʌʌbʌiditadai ʌVuaana cascʌdʌ maidadagitoitadai ʌgai issoimaasi iduiñdagi ʌErodiiasi ʌVuaana, tomasi maicʌʌga maatʌ caʌcatadai ʌEroodʌsi istumaasi aagaitadai ʌVuaana vʌʌscʌrʌ baigʌʌliaragacʌdʌ caʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dʌmos ʌErodiiasi ʌmo imidagai tʌʌ isducatai muaagi ʌVuaana. Ʌmo imidagai tasagadʌrʌ ʌEroodʌsi, tai ʌgai idui ʌmo vagimi daidʌ idui cʌʌgaducami cuaadagai dai vapai gʌsonʌrguucacamiga, ʌʌmadu baitʌguucacamigadʌ ʌsandaaru, ʌʌmadu aa gʌnviipidacami Galileeʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Taidʌ ʌErodiiasi maradʌ ooqui vaa ami siaaco gacuaadatadai ʌvapaidarsicʌdʌ dai gatuudai. Taidʌ ʌEroodʌsi ʌʌmadu ismaacʌdʌ ʌʌmadu gacuaadatadai oojoida tʌʌ ʌali ooqui. Taidʌ ʌEroodʌsi itʌtʌdai ʌali ooqui: ―Giñtaañiñi pʌstumaasi ipʌliadagi iñsaanʌ gʌmaaquimu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Daidʌ itʌtʌdai ʌpamu: ―Maatʌ Diuusi naidʌ gʌmaquiagi pʌstumaasi giñtaañiagi tomapʌs giñtaí tajucami dʌvʌʌrai ismaacʌdʌ tʌaanʌi aanʌ ―astʌtʌdai ʌEroodʌsi ʌali ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Taidʌ ʌali ooqui vuusai daidʌ itʌtʌdai gʌdʌʌ: ―¿Istumaasi taanʌna aanʌ? ―astʌtʌdai. Taidʌ ʌdʌʌdʌ itʌtʌdai: ―Taañiñi ʌVuaana moodʌ ismaacʌdʌ vapaconaiña oodami ―astʌtʌdai ʌdʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Taidʌ ʌali ooqui otoma vaa ʌpamu siaaco daacatadai ʌraí Eroodʌsi, daidʌ itʌtʌdai: ―Ipʌlidiana pʌsisivi otoma giñmaquiagi ʌmo aasocoliʌrʌ ʌVuaana moodʌ ―astʌtʌdai ʌali ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Taidʌ ʌraí sʌʌlicʌdʌ soigʌʌʌli. Dʌmos caaagaitadai sai maatʌ Diuusi gʌvapaida vuitapi cascʌdʌ maitistutuiditadai ʌgai ismaimaquiagi istumaasi taanʌi ʌali ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Taidʌ ʌraí otoma ootoi ʌmo sandaaru dai aagidi sai vuaapidana ʌVuaana moodʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Taidʌ ʌsandaaru ii maisacaruamu, dai mʌʌ guicuta ʌVuaana moodʌ dai ʌmo aasocoliana vuaa. Taidʌ ʌraí maa ʌali ooqui, taidʌ ʌali ooqui tʌʌgi gʌdʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dai aidʌsidʌ ʌVuaana mamaatʌrdamigadʌ maí imaasi, mʌʌ bʌi ʌVuaana tuucugadʌ dai bʌcai dai yaasa. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tai gooquiʌrʌ ʌSuusi ojootosadʌ ʌpamu aayi siaaco daacatadai ʌSuusi dai aagidi vʌʌsi istumaasi idui, dai istumaasi gamamaatʌtuli ʌgai ʌoodami saagida. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Taidʌ ʌSuusi itʌtʌdai gʌmamaatʌrdamiga: ―Tinda dai gʌriibʌsta siaaco maitiipu oodami ―astʌtʌdai. Aliʌ mui oidatucuitadai oodami cascʌdʌ ʌgai maiajʌitadai tasai tomali ugidagai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Taidʌ ʌSuusi ʌʌmadu gʌmamaatʌrdamiga ʌʌgi iji ʌmo vaarcuana ʌmapʌcʌrʌ siaaco maitiipu oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Dʌmos muidutai tʌʌ isiji ʌgai dai maí isʌrʌSuusi dai mosdʌvʌʌrapi sʌʌli voopai vʌʌsi aipadʌrʌ oidacami, dai ʌpʌga aayi isʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dai aidʌsi tʌvai ʌSuusi vaarcuaiñdʌrʌ tʌʌ mui oodami dai soigʌʌldan tadatu ʌgaicʌdʌ, ʌgai tʌgitocatadai sioorʌ aagidagi duucatai gʌaagai isoidacagi. Dai gʌaagacai mamaatʌtuldimi mui naana maasi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dai aidʌsi casi ʌrurunococatadai taidʌ ʌmamaatʌrdamigadʌ ʌSuusi miaadʌrʌ guuquiva daidʌ itʌtʌdai: ―Casiat urui dai tomali ʌmo oodami maioidaga tanai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ootosañi gooodami vai iimʌna aali quiiquiamu siaaco miaaga dai savʌdana cuaadagai daida ugana, maitavuucati goovai istuma ugiagi ―astʌtʌdai mamaatʌrdamigadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dʌmos ʌSuusi aa noragi daidʌ itʌtʌdai: ―Bibidavurai aapimʌ ―astʌtʌdai ʌSuusi. Tai ʌgai itʌtʌdai: ―¿Savʌdatʌsi ʌragai goo siento piisu aʌcami paana gooodami vʌʌtarʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Taidʌ ʌSuusi itʌtʌdai: ―Mʌcavʌr nʌida mʌsʌʌqui paana viaa ―astʌtʌdai. Dai aidʌsi camaí ʌgai siʌʌquidu itʌtʌdai: ―Taama tʌviaa paana dai gooca vatopa ―astʌtʌdai ʌmamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tai amaasi ʌgai tʌjai ʌoodami sai vasoi saagida daraivana chʌchʌʌquiatai aipaco; ");
INSERT INTO ntpNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Taidʌ ʌoodami daraiva ʌʌmo siento dai tataucami siento. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tai amaasi ʌSuusi vui ʌtaama paanʌ ʌʌmadu ʌgooca vatopa dai taí nʌnʌaava dai gamamagi dai saasasacai paana maa gʌmamaatʌrdamiga sai taacogidana ʌoodami. Dai ʌgooca vatopaiñdʌrʌ ʌʌpʌ taacogi vʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dai vʌʌscatai gauu dai tatascovai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dai gooquiʌrʌ ʌmpagi baivustaama dan gooca aasarai susudacami paana saasaquigadʌ ʌʌmadu vatopa. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Daidʌ ismaacʌdʌ gauu ʌtaama paanaiñdʌrʌ ʌrtaama mil cʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Taidʌ ʌSuusi aagidi gʌmamaatʌrdamiga sai tʌtʌidʌna vaarcuʌrʌ dai dʌgavunʌna vaasadʌrʌ ʌgʌʌ suudagi dai aʌna Betasaida dʌvʌʌriʌrʌ ʌʌpʌga isʌgai. Dai ʌgai diosaidimi ʌoodami quiaa. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dai aidʌsi cadiosagi ʌgai ii ʌmo giidiamu dai gamamada agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dai aidʌsi cadidiaimi ʌvaarcu caʌran ʌʌsi imʌitadai ʌgʌʌ suudagi vaidʌ ʌSuusi ʌʌgi ugidiana cʌaacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dai tʌʌ ʌgai siʌmamaatʌrdamigadʌ camaitistutuiditadai isimitudagi ʌvaarcu vuidʌrʌ vustaitai ʌʌvʌʌli. Dai casiaalimodʌ ʌSuusi caaijimitadai gʌmamaatʌrdamiga mossuudagi daama imʌitai dai mosdaivuñia ʌliditadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Dai aidʌsi tʌʌ ʌmamaatʌrdamigadʌ issuudagi daama imʌitadai ʌgai poʌliditadai ʌgai sidʌ ʌrʌmo suiñali dai vʌʌscatai ijiña tʌʌgacai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vʌʌscatai tʌʌ ʌgai cascʌdʌ aliʌ duduaadimu. Dʌmos ʌSuusi ñiooqui daidʌ itʌtʌdai: ―Maitavʌr vuaamʌ ʌnʌliada aanʌana maitavʌr duduaadicuda ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dai tʌsai ʌvaarcuʌrʌ ismaacʌdʌrʌ iimʌitadai ʌgai tai otoma gʌʌpitu ʌʌvʌʌli. Vaidʌ ʌmamaatʌrdamigadʌ maitʌtʌʌgaitadai isducatai gʌntʌtʌgitoagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dai aidʌ maiquiaa tʌtʌʌgaitadai ʌgai isducatai idui ʌSuusi ʌpaanacʌdʌ, aidʌ maiquiaa cʌʌga vaavoitudai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dai vaasadʌrʌ dʌgavusai ʌgai ʌgʌʌ suudagi dai aayi Genesareta dʌvʌʌriʌrʌ, dai ʌgʌʌ suudagi ugidiana vuu ʌgai ʌvaarcu. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Dai aidʌsi mostʌaapai ʌgai ʌvaarcuaiñdʌrʌ, taidʌ ʌoodami maí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Dai ootoma voopoi dai uusiʌrʌ vuaapaimi ʌcoococoidadʌ siaaco cajiomacatadai ʌgai isdaacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Dai tomasiaaco siaaco daacagi ʌSuusi gʌgʌrʌ quiiquiana siʌpʌ ali quiiquiana siʌpʌ dʌjiana ʌoodami vuvaidiña ʌcoococoidadʌ cacaayana dai daanʌiña ʌgai ʌSuusi sai gʌdagitona istaatagi ʌcoococoidadʌ tomasi mosʌcaasi yuucusidʌ, dai vʌʌscatai ismaacʌdʌ mostaata dodoi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amaasi miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi ʌfariseo ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami. Ʌgai Jerusaleenaiñdʌrʌ dada. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dai ʌgai gʌntʌgito tʌʌ isʌʌmoco ʌmamaatʌrdamigadʌ ʌSuusi maitʌniicomai poduucai isduucai ivuaadana ʌgai siuu duucu gaugia agadagi cascʌdʌ ñiooquidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ʌfariseo ʌʌmadu vʌʌsi ʌgaa ʌjudidíu ʌpan duucai gʌnviidacatadai gʌnʌqui aaduñicaru. Ʌʌpʌga gʌniicomaiña ʌgai muioco dai gooquiʌrʌ gacuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Dai siuu duucu dadiagi ʌgai plaasaiñdʌrʌ, maitacuaadana asta siuu duucu vapacoi gʌnnoonovi isducai gʌnviidacatadai ʌgai. Dai quiaa ivueeyi ʌgai mui naana maasi gʌnviituldaraga duucami isducatai vacuanai ʌgai gʌnajaasocoli dai gʌnajaa dai gʌniidoracaru dai gʌnvopoicaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tai amaasi ʌmamaatʌrdami sʌʌlicami ʌʌmadu ʌfariseo tʌcacai ʌSuusi daidʌ itʌtʌdai: ―¿Tuisidʌ gʌmamaatʌrdamiga maitivueeyi mʌsducatai gʌrviituli dai maitʌrʌpan duucai vacuanai gʌnnoonovi siuu duucu gaugia agadagi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. Sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai Isaíacaru Diuusi ñiooquituldiadamigadʌ gʌnaagaitai aapimʌ dai ooja istumaasi aagidi Diuusi dai poduucai ʌooja: Aapimʌ pocaiti mʌsai giñsiaa duutudai dai maisiaa giñduutudai. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gomaasi gia maitʌrsoiñi tomali ʌmaadutai vʌʌtarʌ. Aapimʌ maigamamaatʌtuldi giññiooqui baiyoma gamamaatʌtuli aapimʌ istumaasi oodami gʌnviituli. Ascaiti Diuusi sai ooja Isaíacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aapimʌ maitivueeyi istumaasi Diuusi ipʌlidi, ivuaada ʌliditai istumaasi oodami gʌnviituli, isducatai vacuanadagi gʌnajaa ʌʌmadu gʌnajaasocoli, dai mui aa naana maasi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Daidʌ itʌtʌdai ʌʌpʌ: ―Mosivuaada ʌlidi aapimʌ gʌnviituldaraga cascʌdʌ maitivueeyi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseesacaru icaititadai: “Siaavʌr duutuada gʌnooga ʌʌmadu gʌndʌʌ”, dai “Sioorʌ maicʌʌga ñioocadagi gʌooga siʌpʌ gʌdʌʌ vui ʌgai gʌaagai isdudunucami muaagi”, ascaiti Moseesacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Dʌmos aapimʌ pocaitiña sai ʌmo oodami istutuidi isitʌʌdagi gʌooga siʌpʌ gʌdʌʌ: “Maitan istutuidi isgʌsoiñagi tomali istumaasicʌdʌ. Vʌʌsi istumaasi viaa aanʌ ʌrcorvan”, ismaacʌdʌ itʌiya ʌlidi vʌʌsi ʌrDiuusi aa duiñdadʌ vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Dai ispotʌiyagi ʌmaadutai mai aapimʌ pocaitiña sai camaiviaa ʌgai issoicʌdagi gʌooga siʌpʌ gʌdʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dai poduucai aapimʌ mosgajiaadʌrʌ vipieeyi istumaasi ipʌlidi Diuusi ducami ismaicʌʌgaducagi, mosvuaada ʌliditai gʌnviituldaraga dai mui naana maasi pomaasi ivuaadana aapimʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Taidʌ ʌSuusi ʌpamu vaí ʌoodami daidʌ itʌtʌdai: ―Giñcaʌcavurai vʌʌscatai dai gʌntʌgito caʌca: ");
INSERT INTO ntpNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tomali ʌmo istumaasi ismaacʌdʌ cueeyi oodami maivapacʌi tʌgitoidadʌrʌ cascʌdʌ cuaadagai maisoimaasi iduiñtuldi oodami. Baiyoma tʌgitoidagadʌaiñdʌrʌ vusacʌi mui naana maasi soimaascami dai poduucai gʌmaatʌ isiʌrsoimaasi ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cʌʌgavʌr gʌntʌgito caʌca aapimʌ istumaasi gʌnaagidi aanʌ ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dai aidʌsi anaasi viaa ʌSuusi ʌoodami dai quiiyʌrʌ vaa ʌmamaatʌrdamigadʌ tʌcacai astʌiya ʌlidi ʌcuento. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Taidʌ ʌSuusi itʌtʌdai: ―¿Tomali aapimʌ mʌsmaimaatʌ caʌ sai istumaasi ismaacʌdʌ cueeyi oodami maivapacʌi tʌgitoidadʌrʌ cascʌdʌ cuaadagai maisoimaasi iduiñtuldi oodami? Gomaa cuaadaga. Mosgavoocʌrʌ vapacʌi dai gooquiʌrʌ vusacʌi gatuucugaiñdʌrʌ ―astʌtʌdai ʌSuusi. Poduucai aagidi ʌgai aagidi ʌliditai sai cuaadagai maisoimaasi iduiñtuldi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Daidʌ itʌtʌdai ʌSuusi ʌʌpʌ: ―Gatʌgitoidagaiñdʌrʌ vusacʌi gosoimaasi ");
INSERT INTO ntpNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tʌgitoidagai cascʌdʌ, dai goʌʌmadu voidagai aa ooqui, dai oodami ipʌlidiña isivuaadagi mosʌcaasi istumaasi ipʌlidi, gomuaaragai, ");
INSERT INTO ntpNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","dai goʌʌsidaragai, dai viaaca ʌlidiña gavustuidaga, dai yaatagidaragai, dai muuquimudagai, dai ñiooquidaragai, dai soiducai nʌijadagi soitutuigami, dai maicʌʌga tʌtʌgitoiña oodami, dai aa naana maasi istumaasi soimaascami. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vʌʌsi gomaasi gatʌgitoidagaiñdʌrʌ vusacʌi dai soimaasi iduiñtuldi oodami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tai amaasi ii ʌSuusi abiaadʌrʌ Tiiroamu dai Sidooniamu dai ami vaa ʌmo quiiyʌrʌ dai maitipʌliditadai ismatiagi oodami isami daacatadai ʌgai, dʌmos maitistui isgʌʌstuagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Otoma maí ʌmo ooqui dʌʌdʌ ʌmo ali tʌji ismaacʌdʌ viaacatadai ʌmo Diaavora tʌaañicarudʌ dai divia siaaco daacatadai ʌSuusi dai ʌʌcasodʌ abaana gʌtootonacʌdʌ cʌquiva. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Daidʌ ʌooqui ñioocaitadai giliego ñiooquidʌ daidʌ ʌrSiropeniisiʌrʌ oidacamicatadai. Divia ʌgai dai daañimi ʌSuusi sai vusaidana ʌDiaavora tʌaañicarudʌ maradʌaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dʌmos ʌSuusi itʌtʌdai: ―Aliʌsi gʌaagai isoodami dagitoagi ismaamaradʌ tatascoñiagi ʌʌpʌga maitavʌr cʌʌgai isʌʌsiadagi oodami gʌmara tascaldʌ dai maacadagi googosi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Taidʌ ʌooqui aa noragi daidi tʌtʌdai: ―Vaavuava isʌjudidíu googosi gʌraagai dʌmos vʌʌscʌrʌ ʌgoogosi ismaacʌdʌ mesa uta vʌʌtʌcana cuaadana ʌsaasaquigadʌ ismaacʌdʌ suuligaiña aali ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Taidʌ ʌSuusi itʌtʌdai: ―Cʌʌga pʌaagai. Dai casi istutuidi aapi pʌsnoragiagi ʌDiaavora tʌaañicarudʌ atcavuusai gʌmaraiñdʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dai aidʌsi aayi ʌooqui gʌquiiyʌrʌ ʌmaradʌ caatʌcatadai daidʌ ʌDiaavora tʌaañicarudʌ cavuusai ʌgiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taidʌ ʌSuusi ii Tiiroaiñdʌrʌ dai Sidooniamu sʌʌli daivusai dai ʌmapʌcʌrʌ Decápolisia dʌvʌʌriʌrʌ sʌʌli dai aayi ʌgʌʌ suudagi siaaco Galilea tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mʌtai ami vuaapi ʌmo cʌʌli maitʌcaidacami dai sasaimʌliacami, dai daañimi sai daama daasana ʌSuusi gʌnovi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Taidʌ ʌSuusi ʌcovai vaidacai siaaco maitiipucatadai oodami dai naanacadʌ ʌraana vaapai gʌmamasquiga dai sisivi gʌnovi dai taata nʌnʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dai tʌvaagiamu nʌnʌaava dai sobʌvʌi daidʌ itʌtʌdai: ―Efata ―astʌtʌdai. Gomaasi itʌiya ʌlidi gʌcupiocoñi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mospotʌi ʌgai taidʌ ʌmaitʌcaidacʌdʌ naanacadʌ gʌcupioco, dai nʌʌnʌdʌ cacʌʌga gʌdui dai ʌgai cacʌʌga istui isñiooquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Taidʌ ʌSuusi sʌʌlicʌdʌ daí ʌoodami sai maiaagidiña tomali ʌmaadutai. Dʌmos siʌʌscadʌ vaamioma daidiada ʌgai ʌoodami vaamioma aipaco aagaiña. ");
INSERT INTO ntpNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vaidʌ ʌoodami maitʌtʌgaiña isducatai gʌntʌtʌgitoagi daidʌ iscaitiña: ―Vʌʌsiaʌcatai cʌʌga ivueeyi goovai asta maitʌtʌcaidacʌdʌ tʌtʌcaidatudai dai mumudu ñiooquitudai ―ascaitiña ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dai aidʌ tuigaco mui gʌnʌmpagi oodami siaaco daacatadai ʌSuusi dai maiviaacatadai istuma ugiagi. Tai amaasi ʌSuusi vaí gʌmamaatʌrdamiga daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Soigiñʌlidi aanʌ idi oodamicʌdʌ, caaayi vaica tasai istami giñʌʌmadu daraaja goovai dai maiviaa istuma ugiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dai ismaitaugacai ootosa aanʌ sai noonoigʌna goovai susuiquituan tada goovai voiyamu. Ʌʌmoco aliʌ mʌcasdʌrʌ dada di ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Taidʌ ʌmamaatʌrdamigadʌ aa noragi daidʌ itʌtʌdai: ―¿Voorʌ bibidana mosʌʌqui oodami tanai siaaco maitiipu istumaasi dai tomali oidacami? ―astʌtʌdai ʌmamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Taidʌ ʌSuusi tʌcacai daidi tʌtʌdai: ―¿Mʌʌqui paana viaa aapimʌ? ―astʌtʌdai. Taidʌ ʌmamaatʌrdamigadʌ itʌtʌdai: ―Cuvaracami atʌviaa ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tai amaasi ʌSuusi tʌjai ʌoodami sai dʌvʌʌrapi daraivana, dai ʌgai vui ʌpaana dai gamamagi. Dai gooquiʌrʌ saasarai dai maa ʌgai gʌmamaatʌrdamiga tai ʌgai taacogi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dai viaacatadai ʌgai chiʌʌqui vatopa ʌʌpʌ taidʌ ʌSuusi pocaiti sai baigʌʌlidi Diuusicʌdʌ dai gatʌjai taacogidaragai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vʌʌscatai gauu dai tatascovai. Dai gooquiʌrʌ ʌmpagi cuvaracami aasarai saasaquigadʌ ismaacʌdʌ baivito. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Daidʌ ʌoodami ismaacʌdʌ gauu ʌrparʌ maacova milʌcatadai. Taidʌ ʌSuusi ootoi sai noonoigʌna. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dai ʌgai tʌsai vaarcuʌrʌ ʌʌmadu gʌmamaatʌrdamiga dai iji Dalmanuta dʌvʌʌriamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tai amaasi dada ʌfariseo siaaco daacatadai ʌSuusi dai gaaatagaimi ʌʌmadu ʌSuusi. Daidʌ ʌfariseo mosnʌida ʌliditadai sabaig ʌrvaavoi isʌSuusi istutuidi isivuaadagi istumaasi aagai oodami saidʌ ivueeyi ʌgai, dai aagidi sai tʌʌgidana ʌmo istumaasi gʌducami tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Taidʌ ʌSuusi gʌgʌrʌ sobʌvʌi daidʌ itʌi: ―¿Tuimʌsidʌ giñtaanʌi aapimʌ istumaasi gʌgʌrducami? Sʌʌlicʌdʌ angʌnaagidi sai maitʌʌgimu aapimʌ tomali ʌmo istumaasi gʌducami ―astʌi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dai anaasi viaa ʌgai ʌoodami dai ʌpamu tʌsai vaarcuʌrʌ dai ii vaasadʌrʌ ʌgʌʌ suudagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dai maitʌgito ʌgai isbʌquiagi cuaadagai dai mosaliʌmo paana bʌcaiticatadai vaarcuʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Taidʌ ʌSuusi itʌtʌdai gʌmamaatʌrdamiga: ―Gofariseo navaitigadʌ dai Eroodʌsi navaitigadʌ maicʌʌgadu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vaidʌ ʌmamaatʌrdamigadʌ aipaco gʌnaatagidimi daidi caiti: ―Maiviaa aatʌmʌ paana cascʌdʌ pocaiti goovai ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Taidʌ ʌSuusi maí istumaasi aatagaitadai ʌgai daidʌ itʌtʌdai: ―¿Tuimʌsi pocaiti mʌsai maiviaa paana? ¿Maitamʌsquiaa maatʌ caʌ istumaasi gʌnaagidi aanʌ? ¿Tomali maitʌntʌgito nʌidi istumaasi ivueeyi aanʌ? Sʌʌlicʌdʌ maicʌʌga vaavoitudai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Maitamʌsnʌnʌeeyi aapimʌ dai maitamʌstʌtʌcaidaga? ");
INSERT INTO ntpNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Maitamʌstʌgito aidʌñsi bibi aanʌ ʌtaama mil oodami ʌtaama paana mʌtʌʌqui aasarai ʌmpagi saasaquigadʌ? ―astʌtʌdai ʌSuusi. Taidʌ ʌmamaatʌrdamigadʌ itʌtʌdai: ―Baivustaama dan gooca ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Dai aidʌñsi bibi aanʌ ʌmaacova mil oodami cuvaracami paanacʌdʌ, ¿mʌtʌʌqui aasarai susudacami ʌmpagi? ―astʌtʌdai ʌSuusi. Taidʌ ʌgai itʌtʌdai: ―Cuvaracami ―astʌtʌdai ʌmamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Taidʌ ʌSuusi itʌtʌdai: ―¿Vʌʌscʌrʌ mʌsmaiquiaa maatʌ caʌ? ―astʌtʌdai. Suusi maiaagaitadai navaiti paana vʌʌtarʌ baiyoma aagaitadai ʌgai ʌmamaatʌtuldaragadʌ ʌfariseo dai Eroodʌsi sai maicʌʌgadu. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Dai gooquiʌrʌ aayi ʌgai Betasaidʌrʌ, mʌtai ami vuaapi ʌSuusi ʌmo cʌʌli mainʌaadami, dai daañimi sai taatana. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Taidʌ ʌSuusi noviaiñdʌrʌ bʌi ʌcʌʌli dai vaidacai ugidiana ʌBetasaida. Dai ami vuupujiana tʌi gʌsisivaraga dai vuupuidʌ daama darai gʌnoonovi, dai tʌcacai sabaig istuiditadai isnʌaadagi tomasi palʌpi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Taidʌ ismaacʌdʌ mainʌaadatadai nʌnʌaava daidʌ itʌtʌdai: ―Nʌidi aanʌ oodami ʌpa maasi uusi dʌmos ajioopai ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Taidʌ ʌSuusi ʌpamu vuupuidʌ daama darai gʌnoonovi, vaidʌ ʌcʌʌli cʌʌga gʌtʌgito nʌnʌʌnai dai cacʌʌga istui isnʌnʌaavagi dai cʌʌga nʌidi vʌʌsiaʌcatai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Taidʌ ʌSuusi ootoi ʌcʌʌli sai noragʌna daidʌ itʌtʌdai: ―Maiti vaaqui Betasaidʌrʌ, dai tomali maiaagiada imaasi tomali ʌmaadutai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dai gooquiʌrʌ ii ʌSuusi ʌʌmadu gʌmamaatʌrdamiga vʌʌsi ʌmapʌcʌrʌ Sesareeʌrʌ Filiposi dʌvʌʌriʌrʌ. Dai voiyamu tʌcacai ʌSuusi gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―¿Voorʌ giñaagai ʌoodami? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Ʌʌmoco pocaiti pʌsaidʌ ʌrʌVuaana ismaacʌdʌ vapaconaiña oodami dai aa pocaiti pʌsaidʌ ʌrEliiasicaru, dai aa pocaiti pʌsaidʌ ʌrʌmo Diuusi ñiooquituldiadamigadʌ ―astʌtʌdai ʌmamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tai amaasi ʌSuusi itʌtʌdai: ―¿Dai aapimʌo moorʌ giñaagai? ―astʌtʌdai. Taidʌ ʌPiiduru itʌtʌdai: ―Aapiapʌ ʌrʌCristo dai Diuusi gʌootoi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dʌmos ʌSuusi sʌʌlicʌdʌ daí sai maiaagidiña tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dai amaasi ʌSuusi gʌaagacai mamaatʌtuldimi dai aagidi sai ʌgai viaacatadai ʌmo sʌʌlicami dai viaacatadai issʌʌlicʌdʌ soimaa taatagi dai aagidi sai mosgajiaadʌrʌ viaa agaitadai ʌtʌtʌaanʌdami ʌʌmadu ʌpapaali tʌtʌaanʌdamigadʌ dai ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami. Dai aagidi ʌʌpʌ mʌsai muaa agaitadai dai aagidi sai bovaica tasaicʌdʌ duaaca agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Vʌʌsi gomaasi cʌʌ sʌʌli aagidi ʌgai gʌmamaatʌrdamiga. Taidʌ ʌPiiduru ʌcovai vaidacai dai bagaidimi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Taidʌ ʌSuusi ajaco cʌquiva dai nʌnʌidi gʌmamaatʌrdamiga dai bagaimi ʌPiiduru aduucai: ―Maitigiñʌʌmadu aimʌrda aapi Diaavora. Aapi pocaiti sai maitʌaagai isivuaadagi aanʌ istumaasi Diuusi ipʌlidi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dai amaasi vaí ʌSuusi gʌmamaatʌrdamiga ʌʌmadu ʌoodami daidʌ itʌtʌdai: ―Isʌmaadutai giñoidatucuda ʌliada maitʌaagai isʌʌgi gʌtʌgitocagi, dai gʌaagai isvʌʌscʌrʌ baigʌducagi siʌduñiada gʌmuaatuda giñvaavoitudaitai daida giñoidatucuda. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dʌmos sioorʌ ivuaadagi istumaasi ʌʌgi ʌgai ipʌlidi, ʌgai gia imimu Diaavora ʌʌmadu. Dʌmos sioorʌ baigʌduu dai muquiagi giñvaavoitudaitai dai ʌʌgidi Diuusi ñiooquidʌ ʌgai gia cʌʌgacʌrʌ vusaimu. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tumaasi ʌrcʌʌgai oodami vʌʌtarʌ isgamaitʌagai vʌʌsi istumaasi oidaga oidigi daama vai ibʌadʌ Diaavora ʌʌmadu imiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tomali ʌmaadutai maitistutuidi isgaaa namʌquidagi dai cʌʌgacʌrʌ vuusiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Isʌmaadutai siaa ʌradagi isgʌmaasiuldagi oodami vuitapi dai soimaasi ivuaadami vuitapi isgiñvaavoitudai dai ismaatʌ giññiooqui aanʌ iñsmaacʌdʌ viaa ʌmo sʌʌlicami ʌʌpʌ siaa ʌrogiadamu ʌgaicʌdʌ siʌʌscadʌ giñooga tʌʌgidagi isaliʌsi viaa aanʌ guvucadagai dai diviagi aanʌ ʌtʌtʌaañicarudʌ ʌʌmadu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Daidʌ ʌSuusi itʌtʌdai ʌʌpʌ: ―Sʌʌlicʌdʌ aangʌnaagidi sai oidaga ʌʌmadutai tami ismaacʌdʌ maicoiya agai asta siʌʌscadʌ tʌʌ ismaasi siaaco tʌaanʌi Diuusi gʌguvucadacʌdʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Daidʌ ʌSuusi bonaadami tasaicʌdʌ vaidacai ʌPiiduru, ʌʌmadu ʌJacovo, ʌʌmadu ʌVuaana, ʌmo tʌca tuvidacʌrʌ dai ami ʌSuusi ʌmapʌdui vuitapi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Daidʌ ʌyuucusidʌ dadadaquitu dai cʌʌga tootoatu ʌpa maastu cʌvai tomali ʌmo vacuandami oidigi daama maipocasi tootoatudai yuucusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dai ʌmamaatʌrdami tʌʌ ʌEliiasicaru ʌʌmadu Moseesacaru vaidʌ gaaatagai ʌSuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Taidʌ ʌPiiduru itʌtʌdai ʌSuusi: ―Mamaatʌtuldiadami, vʌʌsi ʌrcʌʌgai istami daraaja aatʌmʌ tʌtai duuñi vaica uucusai ʌmoco aapi gʌvʌʌtarʌ dai ʌmai Moseesa vʌʌtarʌ dai ʌmai Eliiasi vʌʌtarʌ ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ʌmamaatʌrdami aliʌ duduaadimucatadai, daidʌ ʌPiiduru maimaatʌcatadai istumaasi aagaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tai amaasi divia ʌmo icomai dai iiña, daidʌ ʌicomai saagida caidatu ʌmo ñiooqui ismaacʌdʌ icaiti: ―Idiavʌr giñmara ismaacʌdʌ aliʌ oigʌdai aanʌ cʌʌgavʌr ʌʌgiada ―ascaiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dai otoma aipaco nʌnʌaava ʌgai dai camaitʌʌ ʌcʌcʌʌli mosʌca ʌSuusi ʌʌgi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dai aidʌsi tʌaapañimi ʌgai ʌtuvidacaiñdʌrʌ, ʌSuusi daí gʌmamaatʌrdamiga sai maiaagidiña tomali ʌmaadutai istuma tʌʌ ʌgai asta siʌʌscadʌ duaacagi ʌgai coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cascʌdʌ maiaagidi ʌgai tomali ʌmaadutai, dʌmos aipaco gʌntʌcacaitadai ʌgai istʌiya ʌlidi ʌSuusi aagaitai isduaaca agai coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dai amaasi tʌcacai ʌgai ʌSuusi daidʌ itʌtʌdai: ―¿Tuisidʌ icaiti ʌmamaatʌtuldiadami sʌʌlicami saidʌ ʌEliiasi ʌʌpʌga viaacatadai isdiviagi isaapi? ―astʌtʌdai ʌmamaatʌrdami. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Vaavuava istumaasi aagai ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ sai ʌEliiasi viaacatadai isʌʌpʌga diviagi dai soiñagi oodami sai vaavoitudana Diuusi. Dai pocaiti Diuusi ñiooquidʌrʌ giñaagaitai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ansai aliʌ soimaa taata iñagai dai mʌsai ʌmapiadʌrʌ giñviaa agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Dʌmos aanʌ angʌnaagidi saidʌ ʌEliiasi cadivia, mʌtaidʌ idui ʌgaicʌdʌ vʌʌsi istumaasi ipʌli, poduucai isduucatai aagai Diuusi ñiooquidʌrʌ mʌsaidʌ iduñia agaitadai ʌgaicʌdʌ ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dai gooquiʌrʌ ʌpamu aayi ʌgai siaaco daraajatadai ʌgaa mamaatʌrdami, dai tʌʌ mui oodami ʌgai sicoli. Dai ami ʌʌmadu gaaatagaitadai ʌʌpʌ ʌmamaatʌtuldiadami sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dai aidʌsidʌ ʌoodami tʌʌ ʌSuusi vʌʌscatai maitʌʌ isducatai gʌntʌtʌgitoagi dai vui voopoi dai viaatulda agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Mʌtumaasi aatagai aapimʌ ʌʌmadʌ giñmamaatʌrdamiga? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tai ʌmaadutai ismaacʌdʌ ami daraajatadai aa noragi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, gʌvuaapianta giñmara ismaacʌdʌ viaa ʌmo Diaavora tʌaañicarudʌ dai goDiaavora tʌaañicarudʌ muudutuli. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tomasiaaco dʌvʌʌrapi dadaitudaiña goDiaavora tʌaañicarudʌ dai totostudai tʌñidʌ dai cʌcʌrʌntudai taatamudʌ, vai cascʌdʌ goovai maiviaa gʌguvucadaga dai aanʌ caaagidi gʌmamaatʌrdamiga sai vusaidana goDiaavora tʌaañicarudʌ tai maitistui ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Taidʌ ʌSuusi baamuan tada daidʌ itʌtʌdai: ―Aapimʌ oodami maivaavoidaracami, ¿asta siʌʌscadʌ uucami viaacamu aanʌ isgʌnʌʌmadu daacagi? Giñvuaapidavurai goali gʌʌli ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mʌtai vuaapi siaaco daacatadai ʌgai. Dai aidʌsidʌ ʌDiaavora tʌaañicarudʌ tʌʌ ʌSuusi suiquituli ʌgai ʌali gʌʌli taidʌ ʌali gʌʌli dʌvʌʌrapi gʌi, dai aipaco yaalimi, dai totostuimi tʌñidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Taidʌ ʌSuusi tʌcacai ʌoogadʌ daidʌ itʌtʌdai: ―¿Vʌquiidʌ abiaadʌrʌ povʌvueeyi goovai? ―astʌtʌdai. Taidʌ ʌoogadʌ itʌtʌdai: ―Aliducatai abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dai goDiaavora tʌaañicarudʌ muiyoco imidagai taiyʌrʌ dadaitudaiña dai suudarʌ muaa ʌliditai. Dai pʌsaapi istutiadagi isiduñiagi istumaasi goovai vʌʌtarʌ, soigi gʌʌlda aatʌmʌcʌdʌ dai gʌrsoiña ―astʌtʌdai ʌoogadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Taidʌ ʌSuusi itʌtʌdai: ―Pʌsistutiadagi isvaavoitudagi di, vaavoitudadami vʌʌtarʌ tomali ʌmo istumaasi maisijaiga ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Taidʌ ʌali gʌʌli oogadʌ gʌgʌrʌ iiña daidʌ itʌtʌdai: ―Vaavoitudiana. Giñsoiñañi nai vaamioma vaavoituda aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dai aidʌsi tʌʌ ʌSuusi isami gʌnʌmpaidimi mui oodami ʌgai bagaimi ʌDiaavora tʌaañicarudʌ daidʌ itʌtʌdai: ―Diaavora tʌaañicarudʌ maiñioocadami dai maitʌcaidacami aanʌ angʌtʌaanʌi pʌsai vusaiña. Dagitoñi idi ali gʌʌli dai camaivapacʌda ʌpamu idiʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Taidʌ ʌDiaavora tʌaañicarudʌ gʌgʌrʌ iiña dai ʌpamu suiquituli ʌali gʌʌli, dai vuusaicai muuquiadʌ ducai viaa ʌgai ʌali gʌʌli vai muidutai pocaitimi sai casi ʌrmuuquiadʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dʌmos ʌSuusi noviaiñdʌrʌ bʌi dai vañigi taidʌ ʌali gʌʌli cʌquiva. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Taidʌ ʌSuusi vaa ʌmo quiiyʌrʌ, taidʌ ʌmamaatʌrdamigadʌ ʌcovai tʌcacai daidʌ itʌtʌdai: ―Tuisidʌ maitistui aatʌmʌ isvusaidagi ʌDiaavora tʌaañicarudʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Taidʌ ʌSuusi itʌtʌdai: ―Idi Diaavora tʌtʌaañicarudʌ aliʌ sijaiga vusaidaragai cascʌdʌ avʌnacai maitaugacai gamamaadagi vai poduucai vuvacʌi goovai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dai aidʌsi iji ʌgai abiaadʌrʌ Galileeamu sʌʌli dʌgavusai dʌmos ʌSuusi maitipʌliditadai ismatiagi tomali ʌmo oodami, ");
INSERT INTO ntpNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mamaatʌtulditadai ʌgai gʌmamaatʌrdamiga cascʌdʌ dai aagiditadai sai ʌgai viaacatadai ʌmo sʌʌlicami dai mʌsai tʌʌgida agaitadai aa oodami sai ʌgai muaa agaitadai sai vʌʌscʌrʌ ʌgai bovaica tasaicʌdʌ duaaca agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dʌmos ʌmamaatʌrdamigadʌ maimaatʌ caʌcatadai istumaasi aagidi ʌSuusi dai duduaadicuitadai ʌgai iscʌʌga tʌcacagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dai amaasi aayi ʌgai Capernauumʌrʌ. Dai aidʌsi caʌmo quiiyʌrʌ daraajatadai ʌgai, taidʌ ʌSuusi itʌtʌdai gʌmamaatʌrdamiga: ―¿Mʌtumaasi aatagaimi aapimʌ voiyaiñdʌrʌ iimʌtai? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dʌmos ʌmamaatʌrdamigadʌ mosdodoli vii, voiyamu aagaimitadai ʌgai sai ismaacʌdʌ vaamioma namʌga cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tai amaasi daiva ʌSuusi dai vaí ʌbaivustaama dan gooca gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―Isʌmaadutai vaamioma namʌaca ʌliadagi ʌgai gʌaagai ismaigʌducʌdʌ ʌliadagi dai gʌaagai issoicʌdagi vʌʌscatai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Amaasi bʌi ʌSuusi ʌmo ali gʌʌli daidʌ gʌmamaatʌrdamiga saagida cʌi dai gooquiʌrʌ mootoi daidʌ itʌtʌdai gʌmamaatʌrdamiga: ");
INSERT INTO ntpNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Tomasioorʌ sioorʌ vaavoitudai giñmamaatʌtuldiaraga dai cascʌdʌ oigʌdai idi ali oodami, ʌgai giñoigʌdai aanʌ ʌʌpʌ. Dai ʌgai ismaacʌdʌ giñoigʌdai aanʌ ʌgai oigʌdai ʌgai ismaacʌdʌ giñootoi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Amaasi ʌVuaana itʌtʌdai: ―Mamaatʌtuldiadami, tʌʌ aatʌmʌ ʌmo cʌʌli vai aagai gʌtʌtʌaaraga dai poduucai vuvaidi Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ. Dʌmos maigʌrʌʌmadu aimʌrai ʌgai tʌtai cascʌdʌ daí ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dʌmos ʌSuusi itʌtʌdai: ―Maitavʌr daidiada. Maitatiipu tomali ʌmaadutai isivuaadagi istumaasi gʌgʌrducami aagaitai giñtʌʌtʌaraga dai gooquiʌrʌ giññiooquiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sioorʌ maitʌrvui caatʌcagi ʌgai gʌrʌpa maasi tʌgito. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tomasioorʌ sioorʌ baigʌʌliaragacʌdʌ gʌnoidagi tomasi ʌmo avʌsi suudagi giñvaavoitudaitai aapimʌ sʌʌlicʌdʌ Diuusi maaquimu ʌgai ʌmo istumaasi cʌʌgaducami. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tomasioorʌ sioorʌ soimaasi iduiñtulda ʌliadagi ʌmoco ismaacʌdʌ utudama giñvaavoitudagi sioomʌ ʌrcʌʌgai ʌgai vʌʌtarʌ mʌscusivuan vulidagi ʌmo gʌʌ mouturui dai gʌʌ suudarʌ daitudagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Dai isʌmaadutai iduñia ʌliadagi ʌmo istumaasi soimaascami gʌnoonovicʌdʌ siʌpʌ gʌʌʌcasocʌdʌ siʌpʌ gʌvuupujicʌdʌ baiyoma gʌaagai ispoʌliada ʌgai ismainoonovʌ siʌpʌ maiʌʌcaso siʌpʌ maivuupuju dai maisiuu ʌDiaavora ʌʌmadu imiagi siaaco tomastuigaco soimaasi gʌtaatacana dai tomastuigaco mʌʌcana tai baiyoma isimiagi Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dai tomasioorʌ sioorʌ cʌʌgacʌrʌ oidaca ʌliadagi aliʌsi soimaasi taatatuldia agai aa oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Aliʌsi gʌaagai aapimʌ iscʌʌgacʌrʌ oidacagi vai aa oodami ipʌliadagi isvaavoitudagi Diuusi ñiooquidʌ poduucai isduucai ʌmo oodami siooma cueeyi cuaadagai yoovicami ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tai amaasi ʌSuusi ii Capernauumaiñdʌrʌ. Judeea dʌvʌʌriamu vaasadʌrʌ ʌaqui Jordán. Tai ʌpamu gʌnʌmpagi oodami siaaco daacatadai ʌSuusi vai ʌgai mamaatʌtuldimi poduucai isduucai ivuaadana ʌgai vʌʌscʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tai ʌʌmoco ʌfariseo miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi dai mossoimaasi ñiooquituda ʌlidi ʌgai ʌSuusi cascʌdʌ tʌcacai sabai oidaga oigaragai isʌmo cʌʌli dagitoagi gʌooñiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Tumaasi gʌntʌjai Moseesacaru? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Taidʌ ʌfariseo itʌtʌdai: ―ɅMoseesacaru gʌrmaa oigaragai isdadagitodagi ooqui dʌmos sai gʌaagai ismamaacadagi ʌmo oojai siaaco aagadagi iscadagito ―astʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Taidʌ ʌSuusi itʌtʌdai: ―Aliʌsi ʌrsoimaasi ivuaadami oodami cascʌdʌ poduucai aagidi ʌgai ʌMoseesacaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dʌmos aidʌsi tucamidʌrʌ idui Diuusi gooidigi, idui cʌʌli dai ooqui, ");
INSERT INTO ntpNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","cascʌdʌ ʌcʌʌli viaa isdagitoagi gʌooga ʌʌmadu gʌdʌʌ dai vʌʌnagi ʌmo ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Dai poduucai ducami si ʌraliʌmo oodamicagi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cascʌdʌ ismaacʌdʌ ʌmapagidi Diuusi ʌoodami maitʌagai isdadagitodagi ―astʌtʌdai ʌSuusi ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dai aidʌsi aayi ʌSuusi ʌmo quiiyʌrʌ taidʌ ʌmamaatʌrdamigadʌ ʌpamu tʌcacai astʌiya ʌlidi ʌgai ismaacʌdʌ aagaitadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Taidʌ ʌSuusi itʌtʌdai: ―Sioorʌ dagitoagi gʌooñiga dai vʌʌnagi ʌmai ooqui ʌgai soimaasi ivueeyi gʌooñiga ʌpʌgadadʌ vui. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dai isʌmo ooqui dagitoagi gʌcuna dai vʌʌnagi ʌmai cʌʌli ʌgai ʌʌpʌ soimaasi ivueeyi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mʌtai aidʌ vuaapi ʌSuusi chiʌʌqui aali sai taatana. Dʌmos ʌmamaatʌrdamigadʌ bagaidimi ʌoodami ismaacʌdʌ vuaapaimi ʌaali. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dai aidʌsi tʌʌ ʌSuusi aliʌ baamu daidʌ itʌtʌdai ʌgai gʌmamaatʌrdamiga: ―Dagitovurai goaali vai dadana siaaco daja aanʌ dai maitavʌr daidiada. Siaaco gatʌaanʌi Diuusi ʌrʌgai vʌʌtarʌ ismaacʌdʌ ʌpan ducami aali. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sʌʌlicʌdʌ angʌnaagidi sai sioorʌ maivaavoitudagi Diuusi ʌpan ducai ʌmo aliducami ʌgai maiimimu siaaco gatʌaanʌi Diuusi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dai moomotoi ʌgai ʌaali dai daama darai gʌnoonovi dai siaa duutuli. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dai aidʌsi apiaimʌitadai ʌSuusi, tai voiyʌrʌ mʌraitai aayi ʌmo cʌʌli dai vuidʌrʌ gʌtootonacʌdʌ cʌquiva daidʌ itʌtʌdai: ―Mamaatʌtuldiadami cʌʌ tuigacami, ¿tuma duuna aanʌ dai vʌʌscʌrʌ oidacana Diuusi ʌʌmadu? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Taidʌ ʌSuusi itʌtʌdai: ―¿Tuipʌsi cʌʌ tuigacami giñaagai? Aliʌmadugava cʌʌ tuigacami dai ʌgai ʌrDiuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aapi cʌʌga maatʌ istumaasi ipʌlidi Diuusi isivuaadagi oodami maitigaʌʌsiada gaooñiga, dai maitigacoodadai, dai maitigaʌʌsiada gavustuidaga, dai maitiyaatagʌda, dai maitigavupuiirumadada dai siaa iduutuada gʌooca dai gʌdaada ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Taidʌ ʌcʌʌli aa noragi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, vʌʌsi gomaasi ansiaa duutudai aanʌ aliducatai abiaadʌrʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Taidʌ ʌSuusi baigʌʌliaragacʌdʌ nʌnʌidi ʌcʌʌli daidi tʌtʌdai: ―Ʌmo istumaasi aviʌʌga pʌsiduñiagi. Imiñi dai gagara vʌʌsi pʌstuma viaa dai oida ʌtumiñsi ʌsoitutuigami dai poduucai viaacamu aapi mui naana maasi tʌvaagiʌrʌ. Dai gooquiʌrʌ divia daidʌ iñooida. Dʌmos ʌʌpʌga gʌaagai pʌsbaigʌducagi siʌduñiada gʌmuaatudagi giñvaavoitudaitai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dʌmos aidʌsi caʌ ʌcʌʌli imaasi aliʌ soigʌʌli dai imʌcai soigʌʌliatugai aliʌsi ʌrgʌvidacamicatadai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tai amaasi ʌSuusi aipaco nʌnʌaava daidʌ itʌtʌdai gʌmamaatʌrdamiga: ―Gia sijaiga isgʌnviipidacami gʌndagituagi isDiuusi tʌaanʌdagi dai soicʌdagi sai cʌʌga gʌntʌtʌgitocana ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Taidʌ ʌmamaatʌrdamigadʌ maitʌʌ isducatai gʌntʌtʌgitoagi pocaititai ʌSuusi, dʌmos ʌSuusi itʌtʌdai ʌpamu: ―Giñaaduñi gia sijaiga isʌgai ismaacʌdʌ mosʌcaasi gʌnvustuidagʌrʌ tʌtʌgitoi dagituagi isDiuusi soicʌdagi iscʌʌga gʌntʌtʌgitocagi aliʌsi gʌnviipidacatai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Siooma maisijaiga ʌmo muura vʌʌtarʌ isvaquiagi ʌmo oyi dʌgadʌamu sʌʌli isʌmo gʌviidacami dagituagi isDiuusi soicʌdagi iscʌʌga gʌtʌgitocagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dai aidʌsi caʌ ʌgai imaasi maitʌʌ isducatai gʌntʌtʌgitoagi dai aipaco gʌntʌcacai daidʌ icaiti: ―¿Voorʌ istutuididʌo iscʌʌgacʌrʌ vuvaquiagi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Taidʌ ʌSuusi vui nʌnʌava daidʌ itʌtʌdai: ―Oodami gia maitistutuidi isiduñia imaasi, dʌmos Diuusi gia istutuidi. Diuusi vʌʌsiaʌcatai istutuidi isiduñiagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tai amaasi itʌtʌdai ʌPiiduru: ―Mamaatʌtuldiadami, aatʌmʌ viaa vʌʌsi tʌstuma viaacatadai gʌoidatucuda ʌrʌliditai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ angʌnaagidi sai tomasioorʌ sioorʌ dagitoagi gʌquii dai gʌsisiʌʌgi, dai gʌsusuculi, dai gʌooga, dai gʌdʌʌ, dai gʌooñiga, dai gʌmaamara, dai gʌdʌvʌʌraga giñvaavoitudaitai aanʌ dai vaavoitudaitai Diuusi ñiooquidʌ, ");
INSERT INTO ntpNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ʌgai viaacamu idi oidigʌrʌ ʌmo siento vaamioma baabaqui, dai siisiʌʌgi, dai susuculi, dai dʌʌdʌcamu, dai maamaracamu, dai dʌdʌʌvʌracamu, tomasi soimaa taatamaitai. Dai siʌʌscadʌ imiagi ʌgai idi oidigaiñdʌrʌ vʌʌscʌrʌ oidacamu Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dʌmos mʌʌca siaaco gatʌaanʌi Diuusi muidutai ismaacʌdʌ vaamioma tʌaanʌi tami mʌʌca siooma maitʌaanʌdamu dai ismaacʌdʌ siooma maitʌaanʌi tami, mʌʌca vaamioma tʌaanʌdamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dai ʌmo imidagai voiyamu iimʌitadai ʌgai catʌʌtʌidimi Jerusaleena ʌSuusi baitʌqui imʌitadai gʌmamaatʌrdamiga, vaidʌ ʌmamaatʌrdamigadʌ maitʌtʌgaitadai istumaasi gʌntʌtʌgitoagi dai duduaadimutugaitai oidi. Taidʌ ʌSuusi ʌpamu ʌcovai vuvaitu ʌbaivustaama dan gooca gʌmamaatʌrdamiga, dai aagidi isducatai ʌpʌduñia agaitadai ʌgaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Daidʌ itʌtʌdai: ―Aapimʌ nʌidi tʌscatʌtʌidimi Jerusaleenʌrʌ, mʌsiaaco giñtʌʌgida agai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. Giñtʌʌgida magai ʌbaitʌguucacamigadʌ papaali ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami isʌgai gatʌaañimu mʌsaidʌ giñmuaana. Giñtʌʌgidamu ʌgai aa sibʌadʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Dai giñparundada magai dai saasasa magai giñtuucuga dai giñsisiviada magai dai giñmuaa magai. Dʌmos bovaica tasaicʌdʌ ʌpamu duaacamu aanʌ coidadʌ saagidañdʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tai amaasi ʌJacovo ʌʌmadu ʌVuaana ʌSevedeo maamaradʌ miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, aatʌmʌ ipʌlidi pʌsiduñiagi tʌsducatai gʌaagida ragai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Taidʌ ʌSuusi itʌtʌdai: ―¿Tumaasi ipʌlidi aapimʌ isiduñia aanʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tai ʌgai itʌtʌdai: ―Siʌʌscadʌ aapi vʌʌsia daama ʌrgabaitʌcʌaacamicagi gʌrmaacañi oigaragai tʌtaidʌ ʌrtʌtʌaanʌdamica aatʌmʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tai amaasi ʌSuusi itʌtʌdai: ―Aapimʌ maimaatʌ mʌstumaasi giñaagidi. ¿Baisi istutuidʌna aapimʌ issoimaasi taatagi siʌʌ soimaa taata iñagai aanʌ? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Istutuidiatʌta ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ ʌrvaavoi. Aapimʌ gia soimaa taatamu siʌʌsi soimaa taata iñagai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Dʌmos aanʌ maitistutuidi isdaraasagi tʌtʌaanʌdami baiyoma ʌʌgi Diuusi gʌrooga daraasamu tʌtʌaanʌdamicagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dai aidʌsidʌ ʌgaa baivustaama mamaatʌrdami cai gomaasi baacoi ʌJacovo ʌʌmadu ʌVuaana vui. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dʌmos ʌSuusi vaí ʌgai daidʌ itʌtʌdai: ―Cʌʌ maatʌ aapimʌ sai ismaacʌdʌ maitʌrjudidíu saagida ʌbaitʌcʌaacami gʌpipiooñiga duucai nʌidi gʌaaduñi dai ismaacʌdʌ vaamioma gatʌaanʌi sʌʌlicʌdʌ tʌtʌaañicui. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Dʌmos aapimʌ gʌnsaagida maitʌaagai ispoduucai ivuaadagi baiyoma sioorʌ ʌrbaitʌcʌaacamicagi gʌaagai issoicʌdagi vʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Poduucai isduucai ivueeyi aanʌ iñsmaacʌdʌ viaa ʌmo sʌʌlicami. Aanʌ gia divia oidigʌrʌ maisiu isgiñsoicʌdagi aa baiyoma divia aanʌ dai soicʌda iñagai oodami dai muquia iñagai vai poduucai cʌʌgacʌrʌ vuvacʌna mui oodami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Amaasi aayi ʌgai Jericooʌrʌ dai aidʌsi cavuvaquimi abiaadʌrʌ ʌSuusi ʌʌmadu ʌmamaatʌrdamigadʌ dai muidutai aa oodami, vai ʌmo cʌʌli mainʌaadami Vatimeo tʌʌgiducami Timeo maradʌ, voi ugidiana daacatai gataanʌi oidicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dai aidʌsi caʌ ʌcʌʌli ismiaadimi ami ʌSuusi otoma iiñoquidimi daidʌ itʌtʌdai: ―Suusi Davi cajiudadʌ soigigʌʌlda aanʌcʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tai muidutai bagaimi sai maitadacana, dʌmos ʌcʌʌli vaamioma iiñacai daidʌ icaiti: ―Davi maradʌ soigigʌʌlda aanʌcʌdʌ ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Taidʌ ʌSuusi cʌquiva, daidʌ itʌtʌdai gʌaaduñi: ―Baigovai avʌr vaida ―astʌtʌdai. Taidʌ ʌoodami vaí ʌmainʌaadami dai avʌnaquidimi daidʌ itʌtʌdai: ―Baigi gʌʌliada, otoma icʌquiva, gʌvaidiava ʌSuusi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Taidʌ ʌcʌʌli otoma maigovai daitu gʌsuaa dai otoma cʌquivacai ii siaaco daacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Taidʌ ʌSuusi itʌtʌdai: ―¿Tumaasi ipʌlidi aapi isgʌduiñda aanʌ? ―astʌtʌdai. Taidʌ ʌmainʌaadacʌdʌ aa noragi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, nʌada iñʌlidi aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Taidʌ ʌSuusi itʌtʌdai: ―Casi aapi istutuidi isimʌdagi, giñvaavoitu aapi cascʌdʌ canʌnʌaava ―astʌtʌdai. Mospotʌi ʌgai taidʌ ʌcʌʌli istui isnʌnʌaavagi, dai oí ʌSuusi voiyamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dai aidʌsi camiaadimi ʌgai Jerusaleenʌrʌ ugidana iimʌitai Betapagi dai Betania vuidʌrʌ ʌOliivosi giidi, taidʌ ʌSuusi ootoi gooca gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Daidʌ itʌtʌdai: ―Iimivurai mʌmocoro ali quiiyʌrʌ, dai mʌsiuu duucu aiyagi tʌʌgimu aapimʌ ʌmo asñiitu vulicami. Ʌgai maiquiaa dadaʌjʌi tomali ʌmaadutai. Upanavurai dai vuaapa. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dai isʌmaadutai gʌntʌcacagi mʌstuisidʌ povueeyi vʌrai aagida ansai aanʌ tʌgito, ansai otoma ʌpamu ootsoda iñagai ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tai ʌgai iji, dai tʌʌ ʌasñiitu vai ʌmo quitaagiña vulicatadai voiyʌrʌ, dai uupai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tai ʌʌmadutai ismaacʌdʌ ami daraajatadai itʌtʌdai: ―¿Mʌtuma vueeyi? ¿Tuimʌsi uupaisai goasñiitu? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tai ʌgai aa noragi dai aagidi istʌtʌdai ʌSuusi tai ʌgai dagito mʌsbʌquiagi ʌasñiitu. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tai ʌgai otoma bʌidacai ʌasñiitu ʌSuusi. Dai asñiitu daama darai gʌnsusuaa, taidʌ ʌSuusi daamioma daiva. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tai muidutai aa oodami voiyʌrʌ ʌligaimi gʌnsusuaa dai aa guicuta uusi maamaradʌ dai voiyʌrʌ tuajaimi dai poduucai tʌtʌgidi ʌgai ʌSuusi isaliʌ siaa duutudai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dai ʌgai ismaacʌdʌ baitʌqui iimʌitadai dai ismaacʌdʌ gooquiʌrʌ iimʌitadai iiñaquimi daidʌ icaitimi: ―Aliʌ siaa duutudai aatʌmʌ Diuusi. Aatʌmʌ ipʌlidi sai Diuusi cʌʌgacʌrʌ nʌijadana goovai ismaacʌdʌ divia Diuusi guvucadadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dai aliʌ baigʌnʌliadamu vʌʌscatai ismaacʌdʌ tʌaanʌda goovai. Goovai ʌrʌraí Davicaru cajiudadʌ. Sʌʌlicʌdʌ siaa duutudai aatʌmʌ Diuusi gʌrbaitʌcʌaacamiga ―ascaitimi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Taidʌ ʌSuusi aayi Jerusaleenʌrʌ, dai vaa ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu. Dai aipaco nʌnʌaava dai nʌnʌidi istumaasi oidaga ami, dai gooquiʌrʌ ii Betaaniamu ʌʌmadu ʌbaivustaama dan gooca mamaatʌrdamigadʌ, casi ʌrurunococatadai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Dai siaadico aidʌsi iji ʌgai Betaaniaiñdʌrʌ tai aayi biuugigai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dai ʌgai mʌcasdʌrʌ tʌʌ ʌmo iigosi dʌʌdʌ cʌʌga tʌtʌdogi aagadʌ. Dai ʌgai ii dai nʌnʌidi sabai ibaidaga, dʌmos maitʌʌ tomali ʌmo iibiadʌ mosgoʌʌgi aagadʌ maiquiaa aayi istuigaco ibiatai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Amaasi ʌSuusi itʌtʌdai ʌiigosi dʌʌdʌ: ―Tomali ʌmo imidagai camaiugimu tomali ʌmaadutai gʌibaidaga ―astʌtʌdai. Vaidʌ ʌmamaatʌrdamigadʌ caʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dai gooquiʌrʌ aayi ʌgai Jerusaleenʌrʌ. Dai aidʌsi vaa ʌSuusi ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu, dai vuvaidimi vʌʌscatai ismaacʌdʌ ami gagaagarai dai ismaacʌdʌ gasaapʌdai. Dai aipaco suuli memesagadʌ ismaacʌdʌ cambiando ʌjudidíu quiuupaigadʌ tumiñsigadʌ ʌʌmadu daraicarudʌ ismaacʌdʌ gagaagarai tutugu; ");
INSERT INTO ntpNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dai maidagito tomali ʌmaadutai iscucuuspʌticagi gʌvustuidaga quiuupai ʌraana. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dai gʌaagacai mamaatʌtuldimi daidʌ itʌtʌdai: ―Diuusi ñiooquidʌrʌ aduucai oojisi: “Giñquii itʌʌgiducamu quii mamaadaragai vʌʌtarʌ tomastuma oodami ami gamamaadadamu”, ascaiti Diuusi ñiooquidʌrʌ. Dʌmos aapimʌ ʌpan duucai ivueeyi ʌʌsivogami tami Diuusi quiidʌrʌ ―astʌtʌdai Suusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Taidʌ ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌmaatʌtuldiadami sʌʌlicami caʌ iscaiti ʌSuusi, dai otoma gaagaimi isduucatai muaagi, poʌliditadai isvʌʌsi oodami vaavoituda aagaitadai. Vaidʌ ʌoodami vʌʌscatai maitʌtʌgaitadai isducatai gʌntʌtʌgitoagi caʌcatai isducatai mamaatʌtuldi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dʌmos ʌSuusi mostuca tai ii abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Dai siaadico quiamoco dʌgavusai ʌgai dai tʌʌ ʌiigosi dʌʌdʌ vai cagaquisapi tatacadʌaiñdʌrʌ abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Taidʌ ʌPiiduru tʌgito daidʌ itʌtʌdai ʌgai ʌSuusi: ―Mamaatʌtuldiadami, dañi goiigosi dʌʌdʌ ismaacʌdʌ ñiooquidi aapi tacavo ticagaquisa ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Vaavoitudadavurai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sʌʌlicʌdʌ angʌnaagidi, sai tomasioorʌ sioorʌ sʌʌlicʌdʌ cʌʌga giñvaavoitudadagi cʌʌga istutuidi isivuaadagi naana maasi istumaasi sʌʌlicʌdʌ sijiacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cascʌdʌ angʌnaagidi sai mʌsiʌʌscadʌ taanʌdagi Diuusi ʌmo istumaasi gʌnmamaadiʌrʌ dai mʌssʌʌlicʌdʌ vaavoitudadagi isʌgai istutuidi isgʌnmaquiagi viaacamu aapimʌ mʌstumaasi taañiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dai mʌsiʌʌscadʌ gamamadadagi mʌsviaacagi ʌmoco gʌnsaayu oigʌldavurai, vai giñooga ismaacʌdʌ tʌvaagiʌrʌ daja gʌnoigʌldana gʌnsoimaascamiga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dai mʌsiaapimʌ maioigʌldagi, tomali gʌnooga ismaacʌdʌ tʌvaagiʌrʌ daja maitʌnoigʌldamu ʌʌpʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Dai amaasi aayi ʌgai ʌpamu Jerusaleenʌrʌ. Dai aidʌsidʌ ʌSuusi ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu ʌrana aimʌraitadai, tai miaadʌrʌ guuquiva ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami, ʌʌmadu ʌsonʌrʌ guucacami, ");
INSERT INTO ntpNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","daidʌ itʌtʌdai: ―¿Tuma sʌʌlicamicʌdʌ ivueeyi aapi imaasi? ¿Toorʌ gʌmaa sʌʌlicami pʌsai pomaasi ivuaadana? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aanʌan ʌʌpʌ gʌntʌcacagi ʌmo istumaasi mʌscʌʌga giñaa noragidagi dai giñaagidagi istumaasi giñtʌcaca iñagai, nai aana ʌʌpʌ gʌnaagidagi istuma sʌʌlicamicʌdʌ ivueeyi aanʌ gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Toorʌ ootoi ʌVuaana sai vapaconana oodami, Diuusi, oodamisio? Aagavʌrai, noragida ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Vaidʌ ʌcʌcʌʌli aipaco gʌnaagidimi daidʌ icaiti: ―Ispotʌiya aatʌmʌ sai Diuusi ootoi ʌVuaana goovai povʌrtʌʌdan tada tʌsai tuisi maivaavoitu. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Isbai potʌʌna aatʌmʌo sai oodami ootoi ―ascaiti ʌtʌtʌaanʌdami. Aliʌ ʌbʌiditadai ʌgai ʌoodami cascʌdʌ. Cʌʌga maatʌcatadai ʌgai siʌoodami sʌʌlicʌdʌ vaavoitudai siʌVuaana ʌrDiuusi ñiooquituldiadamigadʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dai amaasi itʌtʌdai ʌgai ʌSuusi: ―Maitatʌmaatʌ sioorʌ ootoi ʌVuaana ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Tomali aanʌ anmaitʌnaagidagi tuduidʌ istuma sʌʌlicamicʌdʌ ivueeyi aanʌ gomaasi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Amaasi ʌSuusi gʌaagacai mamaatʌtuldimi cuentocʌdʌ daidʌ itʌtʌdai: ―Ʌmo imidagai oidacatadai ʌmo cʌʌli dai ʌi uuvasi gʌdʌvʌʌragana, dai sicoli curarai. Daidi idui siaaco vusiadagi uuvasi varagadʌ. Daidʌ idui ʌʌpʌ ʌmo vaaqui tʌcavacami dai abiaadʌrʌ nuucadaca agai vʌʌsi gʌʌʌsi. Dai gooquiʌrʌ taajucamicʌdʌ maa gʌʌʌsi aa oodami dai mʌcasi ii. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dai aidʌsi aayi yoovaragai ootoi ʌgai ʌmoco gʌpiooñiga sai mʌtaanʌna ʌaata vuadami ʌuuvasi varagadʌ siʌʌqui aʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Dʌmos ʌaata vuadami bʌi ʌootosicami dai soidoodai dai saasarai tuucugadʌ dai maimaa toma laachi dai ootoi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Taidʌ ʌaamudʌ ootoi ʌmai piooñi, mʌtai ʌgai maicacarai, dai saasarai moodʌ dai galnaasi ñiooqui aagidi dai mosootoi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Taidʌ ʌaamudʌ ootoi ʌmai gʌpiooñiga, mʌtai ʌgai muaa. Dai gooquiʌrʌ ʌaamudʌ ootoi mui aa pipiooñi mʌtai ʌʌmoco soidoodai dai saasarai tuutucugadʌ dai aa coi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Dai maracatadai ʌcʌʌli ʌmo cʌʌli dai aliʌ oigʌdaitadai dai cuugatʌrʌ ootoi poʌliditai: “Giñmara gia siaadʌrʌ maisiaa duutudana ʌgai”, asʌʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dʌmos ʌaata vuadami tʌʌgacai, aipaco gʌnaatagidimi daidʌ icaiti: “Gooviava ʌgai ismaacʌdʌ ajiagai vʌʌsi oogadʌ vustuidadʌ gʌaagai tʌsmuaagi dai poduucai aatʌmʌ ʌrtutuidacamicamu”, ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dai bʌi dai muaa dai dʌjoi ugidiana daitu ʌtuucugadʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dai amaasi ʌSuusi tʌcacai ʌtʌtʌaanʌdami daidʌ itʌtʌdai: ―¿Isduuñimu ʌtuidacami ʌdʌvʌʌrai ʌpipiooñi? Divimu ʌgai dai codimu ʌaata vuadami dai maaquimu ʌgai ʌdʌvʌʌrai aa oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aapimʌ cʌʌ maatʌ isduucai oojisi Diuusi ñiooquidʌrʌ daidʌ icaiti: Ʌsʌʌlicami viaacami ismaacʌdʌ daasa aagai Diuusi ʌtʌtʌaanʌdamigadʌ ʌjudidíu gajiaadʌrʌ viaa agai. Dai ʌgai ʌrʌgai vaa ismaacʌdʌ vaamioma gatʌaanʌda agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Diuusi iduñia gomaasi. Dai gomaasi ʌrʌmo istumaasi cʌʌgaducamicamu ʌgai vʌʌtarʌ ismaacʌdʌ vaavoitudagi. Ascaiti Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dai maatʌ caʌ ʌtʌtʌaanʌdami isʌgai aagada mʌʌlidi ʌSuusi cascʌdʌ aagai ʌcuento. Dai bʌiya ʌliditadai ʌtʌtʌaanʌdami ʌSuusi dai maisagi dʌmos ʌbʌiditadai ʌgai ʌoodami dai dagito dai iji. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dai gooquiʌrʌ ootoi ʌtʌtʌaanʌdami ʌʌmoco ʌfariseo ʌʌmadu ʌʌmoco ʌEroodʌsi aaduñdʌ sai nʌidana sabai aagatudana ʌgai ʌSuusi ʌmo istumaasi istumaasi vui caatʌcagi ʌjudidíu vaavoidaragadʌ vai poduucai gʌʌpiʌrʌ vuaajagi ʌgai dudunucamiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tai ʌgai aayi siaaco daacatadai ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, maatʌ aatʌmʌ sai istumaasi aagai aapi ʌrvaavoi. Dai maivuaamʌ ʌʌlidi aapi oodamicʌdʌ siʌrgʌnviipidacami siʌrsoituutuigami ʌʌpʌ. Mosgamamaatʌtuldi aapi istumaasi Diuusi ipʌlidi. ¿Cʌʌgaisi tʌsaa namʌquiada aatʌmʌ gocuota ʌgʌʌ baitʌcʌaacamigadʌ ʌromamanu cho sio? ―astʌtʌdai ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dʌmos ʌSuusi maatʌcatadai ismosvuiirumada ʌliditadai ʌgai daidʌ itʌtʌdai: ―Aapimʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. ¿Tuimʌsidʌ giñvuiirumada ʌlidi? Giñtʌʌgidavurai ʌmo tumiñsi ismaacʌdʌcʌdʌ gaaa namʌquidi aapimʌ ʌcuota nai nʌida aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mʌtai tʌʌgi. Vaidʌ ʌSuusi nʌnʌidi daidʌ itʌtʌdai: ―¿Voorʌ moodʌ dai voorʌ tʌʌtʌaragadʌ viaa gotumiñsi? ―astʌtʌdai. Taidʌ ʌgaa aa noragi daidʌ itʌtʌdai: ―Ʌgʌʌ maitʌcʌaacami moodʌ dai tʌtʌaragadʌava ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Taidʌ ʌSuusi itʌtʌdai: ―Maacavurai ʌbaitʌcʌaacami istumaasi ʌrtuidadʌ, dai iduuñivurai istumaasi Diuusi ipʌlidi isivuaadagi ʌʌpʌ, ʌgai ʌrʌgʌʌ baitʌcʌaacami tʌvaagiʌrʌ cascʌdʌ ―astʌtʌdai ʌSuusi. Taidʌ ʌcʌcʌʌli maitʌʌ istumaasi gʌntʌtʌgitoagi caʌcatai isducatai aa noragidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tai amaasi iji ʌʌmoco saduseo siaaco daacatadai ʌSuusi. Ʌsaduseo pocaiti sai maioidaga duaacaragai coidadʌ vʌʌtarʌ, cascʌdʌ itʌtʌdai ʌgai ʌSuusi: ");
INSERT INTO ntpNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mamaatʌtuldiadami, Moseesacaru oojisicami gʌrvii vai pocaiti sai isʌmo cʌʌli muquiagi dai viaagi gʌooñiga maiquiaa maamatacai abaana, saidʌ ʌsuculidʌ gʌaagai isvʌʌnagi ʌviuudu dai maamatagi abaana ʌgai ismaacʌdʌ muu vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cuvaracamicatadai gʌnsiʌʌgʌmʌ. Taidʌ ʌvʌʌsi gasiʌʌgi ooñigai dai muu maiquiaa maamatacai. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tai ʌmo suculidʌ vʌʌna ʌviuudu dai muu ʌʌpʌ maiquiaa maamatacai. Taidʌ ʌgʌmai suculidʌ vʌʌna dai podui ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Vʌʌ cuvaracami podui ʌgai vaa ooqui dai vʌʌsi coi maimaamatacai, taida muu ʌooqui ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dai siʌʌscadʌ duduaacagi ʌgai dai ʌpamu oidacagio ismaacʌdʌ ʌrcunadʌcamu ʌooqui vʌʌ cuvaracami ʌrcucunadʌcatai tami oidi daama ―astʌtʌdai ʌsaduseo. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tai amaasi ʌSuusi aa noragi daidʌ itʌtʌdai: ―Maicʌʌga gʌntʌtʌgitoi aapimʌ maimaatʌcatai iscaiti Diuusi ñiooquidʌ dai tomali maimaatʌcatai isDiuusi viaa guvucadagai. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Siʌʌscadʌ duduaacagi coidadʌ camaicucuntai tomali maiooñtai, mosʌpan ducamicana ʌgai Diuusi tʌtʌaañicarudʌ tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gʌnaagidamu aanʌ ʌmo istumaasi aagaitai goduaacaragai. Canʌidi aapimʌ Moseesacaru oojadʌ siaaco ooja ʌgai istumaasi aagidi Diuusi ʌmo uusi iipoadʌaiñdʌrʌ siaaco mʌʌcatadai taí dai aagidi sai oidaga duaacaragai. Tomasi catʌvʌpi ʌpʌdui sicoi Avraañicaru dai Isaacaru dai Jacocaru vʌʌsicʌrʌ pocaiti Diuusi: “Aanʌ anʌrDiuusigadʌ Avraañi dai Isaa dai Jaco dai aa ʌʌpʌ” ―astʌtʌdai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ʌgai Diuusi ʌʌmadu daraaja tʌvaagiʌrʌ Diuusi ʌrDiuusigadʌ ismaacʌdʌ catʌvaagiʌrʌ daraaja dai ismaacʌdʌ iimia agai tʌvaagiamu. Cascʌdʌ gʌnaagidi aanʌ mʌsai maicʌʌga gʌntʌtʌgitoi aagaitai sai maioidaga duaacaragai coidadʌ ―astʌtʌdai ʌSuusi ʌsaduseo. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tai ami divia ʌʌpʌ siaaco daacatadai ʌSuusi ʌmoco ʌmamaatʌtuldiadami sʌʌlicami, ʌgai caʌ istumaasi aatagaitadai ʌSuusi ʌʌmadu ʌsaduseo dai maatʌcatadai ʌgai isʌSuusi cʌʌga aa noragi, cascʌdʌ itʌtʌdai ʌgai ʌSuusi: ―Vʌʌsi ismaacʌdʌ ipʌlidi Diuusi tʌsivuaadagi ¿tumaasi vaamioma gʌaagai tʌsivuaadagi? ―astʌtʌdai ʌmamaatʌtuldiadami sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Taidʌ ʌSuusi itʌtʌdai: ―Pocaiti Diuusi ñiooquidʌrʌ: “Giñcaʌcavurai Isireliʌrʌ oidacami ʌcʌliodamiava ʌrgʌrDiuusiga dai mosʌca ʌmadugava Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oigʌadañi ʌcʌliodami gʌDiuusi vʌʌsi gʌibʌdacʌdʌ, dai vʌʌsi gʌtʌgitoidacʌdʌ, dai vʌʌsi gʌguvucadacʌdʌ”. Goovai ʌrʌgai ismaacʌdʌ vaamioma gʌaagai isivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Dai gotordadʌ baitoma pocaidaga ʌʌpʌ. “Oigʌadañi gʌaaduñi poduucai pʌsduucai gʌoigʌdai aapi ʌʌgi”. Goovai vʌgoocai ʌgai dai vaamioma gʌaagai isʌʌgiadagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Taidʌ ʌmamaatʌtuldiadami sʌʌlicami itʌtʌdai: ―Gia cʌʌga aagai aapi mamaatʌtuldiadami. Vaavuava ismaacʌdʌ aagai aapi, sai mosʌca ʌmaduga Diuusi sai maitiipu ʌmai mosʌca ʌmoco. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dai sai gʌaagai tʌsoigʌadagi Diuusi vʌʌsi gʌribʌdacʌdʌ, dai vʌʌsi gʌrtʌgitoidacʌdʌ, dai vʌʌsi gʌrguvucadacʌdʌ, dai tʌsai oigʌdaiña gʌraaduñi poduucai tʌsduucai gʌroigʌdai aatʌmʌ ʌʌgi. Vʌʌsi gomaasi vaamioma namʌga isʌvustaqui dai aa naana maasi ismaacʌdʌ coodaiña oodami dai mʌmʌidiña Diuusi vʌʌtarʌ siaa duutudaitai Diuusi ―astʌtʌdai ʌmamaatʌtuldiadami sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dai aidʌsi caʌ ʌSuusi iscʌʌga aa noragi ʌmamaatʌtuldiadami sʌʌlicami itʌtʌdai: ―Baitoma maatʌ caʌcan caiti aapi isducatai gatʌaanʌi Diuusi ―astʌtʌdai ʌSuusi. Tai tomali ʌmaadutai camaitʌpʌʌli istʌcacagi vaamioma. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ɅSuusi mamaatʌtulditadai ʌoodami ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu, daidʌ itʌtʌdai: ―¿Tuisidʌ pocaiti mamaatʌtuldiadami sʌʌlicami, saidʌ ʌCristo ʌrDavi cajiudadʌ? ");
INSERT INTO ntpNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vai ʌgai vaa Davi aagai isducatai aagidi Diuusi Ibʌadʌ daidʌ icaiti: “ɅCristo ʌrgiñDiuusiga”, ascaiti. Diuusi potʌtʌdai ʌCristo: “Gʌmaaquimu aanʌ ʌmo sʌʌlicami ismaacʌdʌ vaamioma namʌga. Dai ugititudamu aanʌ vʌʌsi ismaacʌdʌ gʌvuidʌrʌ vʌʌtʌcagi”, astʌtʌdai Diuusi. Ascaiti Davicaru aagaitai ʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Ducatai istutuidi ʌCristo siʌrDavi cajiudadʌcagi vai ʌʌgi ʌDavi giñDiuusiga aagadagi? ―astʌtʌdai ʌSuusi. Daidʌ ʌoodami sʌʌlicʌdʌ muiducatadai dai baigʌnʌliaragacʌdʌ caʌcatadai istumaasi aagai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Daidʌ itʌtʌdai ʌSuusi ʌoodami aidʌsi mamaatʌtulditadai: ―Maitavʌr ʌpan duucai ivuaada aapimʌ gomamaatʌtuldiadami sʌʌlicamicʌdʌ, ismaacʌdʌ oojoidi iscʌcʌʌgaducami gʌnaadadagi yuucusi, dai oojoidi mʌscucuanadagi gʌnvapanamu dai viaatuldiadagi cacayana. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Dai goovai gaagaiña cʌcʌʌgaducʌdioma daraicarui ʌjudidíu quiquiuupaigadʌrʌ, dai siaaco gacuaada goovai cʌcʌʌgaducʌdioma daraicarui oojoidi isdadarʌdagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dai ʌʌsidiña goovai vipiuudu baabaquidʌvio dai tʌvʌpi gamamaadaiña sai maimaatʌcana oodami issoimaasi ivueeyi ʌgai. Goovai tuduidʌ ʌgai dai vaamioma soimaa taatatuldamu Diuusi ―astʌtʌdai Suusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ʌmo imidagai ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu daacatadai ʌSuusi vuidʌrʌ ʌcajojoñi siaaco gʌtuaadana tumiñsi Diuusi aa duiñdadʌ vʌʌtarʌ. Daacatai nʌidi ʌgai vaidʌ ʌgʌnviipidacʌdʌ muumuji tueeyi tumiñsi ami cajojoñiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tai ami aayi ʌʌpʌ ʌmo viuudu soitigami dai ʌmo cajoñiʌrʌ tuaa goo sintavo. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tai amaasi ʌSuusi vaí gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ angʌnaagidi sai idi viuudu soitigami siooma mui motuaa tumiñsi sivʌʌscatai gogaa ismaacʌdʌ muumuji motueeyi tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vʌʌscatai goovai motueeyi ismaacʌdʌ cababaivitocʌi, dʌmos goooqui soitigamicatai motuaa vʌʌsi ismaacʌdʌ viaacatadai istucʌdʌ oidacagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dai aidʌsi vuusai ʌSuusi ʌgʌʌ quiuupaigadʌaiñdʌrʌ ʌjudidíu tai ʌmaadutai ʌmamaatʌrdamigadʌ itʌtʌdai: ―Mamaatʌtuldiadami, dañi vʌʌ sigiamaasi goojoodai ismaacʌdʌ ʌcʌdʌ duñisi gogʌʌ quiuupai dai gogʌgʌrʌ baabaqui ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dʌmos ʌSuusi itʌtʌdai: ―Canʌidi aapimʌ idi gʌgʌrʌ baabaqui tami. Maiviimu tomali ʌmo odai daama ʌmai. Vʌʌsi siaa gʌduuñimu goovai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Amaasi iji ʌgai Oliivosi giidiamu, ʌgai ʌrvuidʌrʌ ʌgʌʌ quiuupaigadʌ ʌjudidíu. Dai aidʌsi ami daiva ʌSuusi, taidʌ ʌPiiduru, ʌʌmadu ʌJacovo, ʌʌmadu ʌVuaana, ʌʌmadu ʌAandʌrʌsi, ʌcovai itʌtʌdai ʌgai ʌSuusi: ");
INSERT INTO ntpNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Aatʌmʌ ipʌlidi pʌsgʌraagidagi aapi siʌʌscadʌ ʌpʌduñia agai gomaasi. ¿Ducatai maatʌcamu aatʌmʌ isvʌʌsi gomaasi casi ʌpʌduñia agadagi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Gʌnnuucadacavurai, vai tomali ʌmaadutai maitʌnvupuiirumadaiña. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muidutai dadia agai daidi caitidamu: “Aanʌ anʌrʌCristo”, dai muidutai vupuiirumadamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dʌmos mʌsiʌʌscadʌ cajiomacagi aapimʌ cocodi muiyapʌrʌ maitavʌr duduaadicuda. Vʌʌsi gomaasi gʌaagai isʌpʌduñiagi. Dʌmos gomaasi maiquiaa ʌrcuugadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ʌmo oodami cocoda agai aa oodami, dai ʌmo dʌvʌʌriʌrʌ oidacami cocoda agai ʌmai dʌvʌʌriʌrʌ oidacami. Dai muiyapʌrʌ gigivucudamu dʌvʌʌrai. Dai oidacamu biuugigai, dai siaa caitadamu cocoadami. Vʌʌsi gomaasicʌdʌ utudama gʌaagacai soimaasi taatamu oidigi daama oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dʌmos aapimʌ gʌaagai mʌsʌjʌʌgi gʌnnuucadacagi; gʌntʌʌgida magai baitʌguucacami, dai gʌngʌgʌgʌtudadamu aapimʌ quiquiuupiʌrʌ. Dai viaacamu aapimʌ isvan guguucadagi dudunucami vuidʌrʌ dai raraí vuidʌrʌ giñvaavoitudaitai aapimʌ. Poduucai istuidimu aapimʌ isgiñagadagi ʌgai vuitapi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dʌmos maiquiaa aʌcai cuugatʌrʌ tasʌrʌ gʌaagai isaagidagi vʌʌsi oidigi daama oidacami isducatai Diuusi cʌʌgacʌrʌ vuvaidi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dai mʌsiʌʌscadʌ vaama gʌntuutusagi aapimʌ dudunucamiʌrʌ, maitavʌr vuaamʌ ʌnʌliada maimaatʌcatai istʌiyagi, tomali maitʌaagai mʌstʌtʌgitodagi. Diuusi gʌnsoicʌdamu vʌrai aagada mʌstumaasi tʌgitocagi aidʌpʌcʌ. Aapimʌ maiñiooquia agai mosʌʌgi Diuusi Ibʌadʌ gʌnñiooquitudamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dai oodami gatʌtʌgiada agai ʌʌgi gʌnsusuculi dai gʌnsisiʌʌgi mʌsai coodaiña. Dai dʌʌdʌdʌ gatʌtʌgiada agai ʌʌgi gʌnmaamara. Dai maamaradʌ vui vʌʌtʌcamu gʌndʌʌdʌ dai asta gatʌaanʌdamu coodaragai. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dai vʌʌsi oidigi daama oidacami gʌncʌʌdada agai giñvaavoitudaitai aapimʌ. Dʌmos sioorʌ moʌʌ cʌʌga giñvaavoitudadagi siʌʌsi ucami oidacagi oidigi daama ʌgai cʌʌgacʌrʌ vuvaquimu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ɅDiuusi ñiooquituldiadamigadʌ Daniel ooja sai divia agai ʌmoco ismaacʌdʌ sʌʌlicʌdʌ soimaasi iduñia agai ʌmo istumaasi ʌmapʌcʌrʌ siaaco maiviaa ʌgai oigaragai isvapacʌdagi (sioorʌ nʌidagi idi oojai gʌaagai ismaatʌ caʌcagi). Siʌʌscadʌ nʌijada oodami ispomaasi ʌpʌvuimi, amaasi ʌgai ismaacʌdʌ tami Judeeʌrʌ daraajagi gʌaagai isvoopiagi gigiidamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dai amaasi sioorʌ vaaqui daama daacagi aidʌ tasʌrʌ aliʌsi gʌaagai isotoma voopiagi maivuvaidacai gʌvustuidaga tuucavidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dai sioorʌ dʌjiana ajioopadagi, maitʌaagai isʌpamu iimiagi gʌnquiiyamu dai vuiyagi gʌnyuucusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Siʌʌ soimaa taatamu ʌooqui ismaacʌdʌ noonoacagi siʌpʌ viaacagi aali sisiʌdami aidʌ tasʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aliʌsi gʌaagai isdaanʌdagi Diuusi vai maitʌrtoomococana mʌsiʌʌscadʌ voopiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aliʌ soimaa taata agai oodami cascʌdʌ. Vaamioma soimaasi gʌtaatamu amaasi sitomali ʌmo imidagai aidʌsi abiaadʌrʌ idui Diuusi oidigi, dai gooquiʌrʌ tomali ʌmo imidagai maipomaasi gʌtaatama. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Isbai tʌvʌpi ʌpʌduñiagi gomaasi aidʌ gia vʌʌsi coiyantada oodami dʌmos Diuusi maidagitomu istʌvʌpi ʌpʌduñi gomaasi ʌgai aliʌ oigʌdai ismaacʌdʌ ʌcovai vuvaitu cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Amaasi isʌmaadutai povʌntʌtʌdagi: “Dañi tami daja ʌCristo”, mʌsiʌpʌ povʌntʌtʌadagi: “Dañi mʌca daja”, maitavʌr vaavoitudada. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dadiav agai yaatavogami dai pocaitiada agai saidʌ ʌrʌCristo dai pocaitiada agai saidʌ ʌrDiuusi ñiñiooquituldiadamigadʌ, daidʌ ivuaada agai naana maasi gʌgʌrducami dai poduucai vupuiirumadada agai asta ʌgai ismaacʌdʌ Diuusi ʌʌgi ʌcovai vuvaitu isistuidiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dʌmos aapimʌ avʌr baigʌnduca cascʌdʌ ʌʌquiasdʌrʌ abiaadʌrʌ gʌnaagidi aanʌ gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Dai amaasi siʌʌscadʌ cadaivuñiagi gosoimaa taataragai, tasai tucapi viiya agai dai masaadai gʌiiña agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dai sisiaavugai suuligia agai tʌvaagiañdʌrʌ, dai vʌʌsi istumaasi oidaga tʌvaagiʌrʌ gigivucudamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dai amaasi giñtʌʌgimu oodami aanʌ iñsimaacʌdʌ viaa ʌmo sʌʌlicami, iñsimʌʌcadʌrʌ imʌʌdamu icomai saagida guvucadagaicʌdʌ, dai Diuusi dadadaquigadʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dai ootosamu aanʌ giñtʌtʌaañicaru sai ʌgai ʌmpaidana vʌʌsi ʌoodami ismaacʌdʌ Diuusi ʌcovai vuvaitu vʌʌsi oidigiaiñdʌrʌ dai vʌʌsi tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Maatʌvurai aapimʌ idi ñiooqui iñsmaacʌdʌ gʌnaagidia iñagai aanʌ aagaitai ʌiigosi: Siʌʌscadʌ momiacagi mamaaradʌ dai iipoidagi aagadʌ poduucai camaatʌca iscamiaadimi taaco. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Poduucai ʌʌpʌ mʌsiʌʌscadʌ nʌijadagi iscasi ʌpʌvuidagi gomaasi ismaacʌdʌ caaagidi aanʌ camaatʌca iscayoga ugidagai oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iñsmaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi sai gomaasi ʌpʌduñia agai maiquiaa ugitʌcai oodami sivi oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tʌvaagi dai dʌvʌʌrai ugitimu, dʌmos giññiooqui maiugitimu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Dʌmos tomali ʌmaadutai maimaatʌ siʌʌscadʌ tomali siuu duucu, tomali ʌDiuusi tʌtʌaañicarudʌ tʌvaagiʌrʌ daraajatai maimaatʌ, tomali aanʌ Diuusi maradʌcatai. Mosʌʌgi gʌrooga Diuusi ʌgai dai maatʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cascʌdʌ gʌaagai mʌsbaigʌnducagi, dai gamamadadagi maitavʌmaatʌ siʌʌscadʌ ajia agai ʌcaa duucu. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gomaasi ʌrʌpan ducami ʌmo cʌʌli siʌʌscadʌ imiagi sibʌcai mʌʌcasi. Maiquiaa imʌcai vipiidiña ʌgai gʌpipiooñiga ʌʌmadutai aa duiñdagai, dai quitaagiña vipieeyi nuucadacami. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Dai aanʌ ʌʌpʌ imia iñagai dai maimaatʌ siuu duucu divia iñagai cascʌdʌ baigavʌr gʌnduca maimaatʌcatai siuu duucu divia iñagai aanʌ siʌmo imidagai urunuco, siʌpʌ ʌran tucarʌ, siʌpʌ cuujuicai tacucu, siʌpʌ maasicai. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Todian duucai divimu aanʌ dai cascʌdʌ gʌaagai mʌsbaigʌnducagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Istumaasi gʌnaagidi aanʌ aapimʌ ʌrvʌʌscatai vʌʌtarʌ. Baigavʌr gʌnduca ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dai gooca tasai viʌʌgacatadai gopascua vʌʌtarʌ. Gopascua ʌrʌsiaa duudagai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ. Vaidʌ ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami gaagaitadai isducatai yaatagidacai bʌjiagi ʌSuusi dai muaagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dʌmos icaititadai ʌgai: ―Baiyoma asta siʌʌscadʌ daivuñiagi gosiaa duudagai vai poduucai maitʌrvui baacoagi ʌoodami ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Vaidʌ ʌSuusi Betaaniʌrʌ daacatadai Simuñi quiidiʌrʌ. ɅSimuñi ʌʌquioma viaacatadai ʌcoocodagai ismaacʌdʌ duvaldi gatuucuga dʌmos cadueeyi ʌgai. Dai aidʌsi mesa vuidʌrʌ daacatadai ʌSuusi, tai ami divia ʌmo ooqui dai bʌʌcati ʌmo tucayu alavastrocʌdʌ duñisicami suudacami asaiti sigian uuvadami sʌʌlicʌdʌ namʌacami. Dai taapai ʌtucayu dai ʌSuusi moodʌrʌ tʌi ʌasaiti sigian uuvaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tai ʌʌmoco ismaacʌdʌ ami daraajatadai aliʌ baacoi dai aipaco gʌnaatagidimi daidʌ icaiti: ―¿Istuisidʌ siaa doodai goovai goasaiti sigian uuvadami? ");
INSERT INTO ntpNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cʌʌga gʌgagaramudai goovai vaamiomacʌdʌ isvaica siento piisu dai ʌcʌdʌ soiñamudai soitutuigami ―ascaiti. Dai sʌʌlicʌdʌ baacoi ʌooqui vui. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dʌmos ʌSuusi itʌtʌdai: ―Casiavʌr maiñioocada aapimʌ gooqui vui. Goovai ismaacʌdʌ iñduñi goovai ʌrʌmo istumaasi cʌʌgaducami. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Soitutuigami vʌʌscʌrʌ viaacamu aapimʌ gʌnsaagida, daidʌ istutuidi aapimʌ iscʌʌga iduiñdagi mʌsiʌʌscadʌ ipʌliadagi. Dʌmos aanʌ gia maisiuu vʌʌscʌrʌ giñnʌijada agai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Idi ooqui giñduñi istumaasi istui. Tʌi goovai giñtuucuga sigian uuvadami otoma muquia iñagai aanʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi sai tomasiaacoga siaaco gʌaagadagi Diuusi ñiooquidʌ vʌʌsi oidigi daama gʌagada agai ʌʌpʌ istumaasi idui idi ooqui vʌrai poduucai tʌtʌgitoda ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tai amaasi ʌUudasi Iscaliote, ʌmoco ʌbaivustaama dan gooca mamaatʌrdamigadʌ ʌSuusi, ii daidʌ gaaataga agai ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu dai baiduñia agai ñiooqui dai tʌʌgida agai ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dai aidʌsidʌ caʌ ʌbaitʌguucacami imaasi aliʌ baigʌnʌʌli dai aagidi ʌgai ʌUudasi sai aa namʌquida agai. Taidʌ ʌUudasi gʌaagacai gaa isducatai gatʌʌgidagi ʌSuusi mʌsai muaana. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tai aayi ʌtucamidʌrʌ tasʌrʌ ʌsiaa duudagai istuigaco tʌtʌgitoiña ʌjudidíu aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ dai istuigaco gʌcuaadana paana maicopodatudicami, dai gʌmumueeyiña ʌmo ali cañiiru dai aa gʌdadaasdiña Diuusi. Taidʌ ʌSuusi mamaatʌramigadʌ itʌtʌdai ʌSuusi: ―Vaacoga ipʌlidi aapi tʌsbaiduñiagi cuaadagai idi siaa duudagai vʌʌtarʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Taidʌ ʌSuusi ootoi gooca gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―Iimivurai mʌʌca gʌgʌrʌ quiiquiana, dai ami tʌʌgimu aapimʌ ʌmo cʌʌli vai vaigʌtica agai ʌmo aayi suudagi vʌrai oida. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dai siaaco vaquiagi ʌgai vʌrai ami itʌʌda ʌquiʌʌcami: “Ʌmamaatʌtuldiadami icaiti saaco cʌʌca ʌtucavi siaaco gaugia agai ʌgai idi siaa duudagʌrʌ cuaadagai ʌʌmadu aatʌmʌ avʌr tʌʌda”. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Siʌgai gʌntʌʌgidamu ʌmo tuucavi gʌducami gocua daama vaquiʌrʌ tʌcaviacoga, cabaiduñisicami, vʌrai ami baiduuñi ʌcuaadagai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Taidʌ ʌmamaatʌrdamigadʌ iji dai aayi ʌgʌgʌrʌ quiiquiʌrʌ, dai vʌʌsi tʌʌ isducatai aagidi ʌSuusi. Dai baidui ʌcuaadagai ʌsiaa duudagai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dai aidʌsi cadidia ami divia ʌSuusi ʌʌmadu gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dai aidʌsi mesa vuidʌrʌ daraajatai gacueeyi ʌgai, taidʌ ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ angʌnaagidi sai ʌmaadutai aapimʌ ismaacʌdʌ giñʌʌmadu gacueeyi giñtʌʌgida agai dudunucami siʌgai giñmuaamu ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Taidʌ ʌmamaatʌrdamigadʌ aliʌ soigʌnʌʌli, dai vʌʌscatai tʌcacaimi daidʌ itʌtʌdaimi: ―¿Aanʌnsi ʌʌpʌ? ―astʌi ʌmoco. Tai ʌmai potʌi ʌʌpʌ: ―¿Aanʌnsio? ―astʌi ʌgʌmai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌmaadutai aapimʌ baivustaama dan goocaiñdʌrʌava. Goovai ismaacʌdʌ giñsoiña cueeyi ʌgai vaa asocoliʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aanʌ iñsmaacʌdʌ viaa ʌmo sʌʌlicami ivueeyi istumaasi aagidi Diuusi ñiooquidʌrʌ dʌmos siʌsoimaa taatamu gocʌʌli ismaacʌdʌ giñtʌʌgida agai sioomʌ ʌrcʌgaicamudai gocʌʌli vʌʌtarʌ ismaivuusaimudai tami oidigi daama ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dai aidʌsi gacuaadatadai ʌgai, taidʌ ʌSuusi bʌi ʌpaana dai gamamagi dai saasasacai maa gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―Ugavurai idi paana. Idi ʌrgiñtuucuga ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dai bʌi ʌʌpʌ ʌmo viaacami uuvasi varagadʌ dai gamamadacai maa ʌʌpʌ tai vʌʌscatai ii ʌvaasuaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Daidʌ ʌSuusi itʌtʌdai: ―Idi ʌrgiñʌʌra ismaacʌdʌ aastia agai muucucai aanʌ sipoduucai gʌoigʌldamu soimaascamigadʌ tomasioorʌ sioorʌ vaavoitudagi. Dai gomaasicʌdʌ canamʌaca agai Diuusi ñiooquidʌ gooquirdadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sʌʌlicʌdʌ angʌnaagidi, ansai camaiyʌʌda iñagai uuvasi varagadʌ asta iñsiʌʌscadʌ iiyagi utudui mʌʌca siaaco gatʌaanʌi Diuusi ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dai canʌʌcai ʌmo nʌidagai iji Oliivosi giidiamu. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Taidʌ ʌSuusi itʌtʌdai: ―Vʌʌscatai aapimʌ ʌʌgi giñviaa agai sivi tucarʌ. Pocaiti Diuusi ñiooquidʌrʌ: “Gʌmuaatudamu pastuuru sicañiirugadʌ aipaco iimimu”. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dʌmos siʌʌscadʌ ʌpamu duaaca aanʌ ʌpʌga aimu aanʌ Galileeana isaapimʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tai amaasi ʌPiiduru itʌtʌdai: ―Tomasi vʌʌscatai gʌdagito aanʌan gia maitʌdagitoagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dʌmos ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ angʌaagidi sai sivi tucarʌ maiquiaa goocuaja cuujuicai tacucu aapi vaicojo maimaasi aag agai pʌsgiñmaatʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dʌmos ʌPiiduru vaamioma guvucamicʌdʌ ñioo daidʌ icaiti: ―Tomañsi aapi gʌʌmadu muu maitanʌstuagi iñsigʌmaatʌ ―astʌtʌdai. Tai vʌʌscatai potʌi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dai amaasi aayi ʌgai ʌmapʌcʌrʌ siaaco Getasemani tʌʌgidu, taidʌ ʌSuusi itʌtʌdai gʌmamaatʌrdamiga: ―Tami avʌr daraiva naida aanʌ mʌʌca gamamaadagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dai vaidacai ʌPiiduru, ʌʌmadu ʌJacovo, ʌʌmadu ʌVuaana, dai duaadicudan tadatuimi dai soigʌʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Daidʌ itʌtʌdai ʌgai gʌmamaatʌrdamiga: ―Sʌʌlicʌdʌ soigʌʌlidi giñibʌdaga muquiadan tada. Tanasi avʌr vii aapimʌ, dʌmos maitavʌr coocosi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dai baitʌquioma ii, dai cupuliaco voi dʌvʌʌrapi daanʌi Diuusi sai isbaigacamudai iducai maisoimaa taatamudai ʌgai istumaasi casi ʌpʌduñia agaitadai aidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Daidʌ aduucai gamamadai ʌSuusi: ―Giñooga, aapi vʌʌsiaʌcatai istutuidi isiduñiagi maitidagito issoimaa taata aanʌ dʌmos vai maitʌpʌduna iducatai aanʌ ipʌliadagi mosʌca isducatai aapi ipʌlidi ―astʌtʌdai ʌSuusi gʌooga. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dai amaasi ii ʌgai siaaco daraajatadai ʌmamaatʌrdamigadʌ vai coocosʌcatadai, daidʌ itʌtʌdai ʌgai ʌPiiduru: ―Simuñi, ¿coosopʌsi? ¿Maitapʌsistui isnʌaadagi tomas ʌmo ora? ");
INSERT INTO ntpNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Maitavʌr coocosi dai gamamadadavurai vai maisoimaasi gʌnduiñtuldana ʌDiaavora. Aapimʌ iduñia ʌlidi istumaasi Diuusi ipʌlidi dai vʌʌscʌrʌ maitistui isnʌaadagi dai maidaanʌi aapimʌ Diuusi sai gʌnsoiñana ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dai imʌcai gamamagi ʌSuusi ʌpamu ʌgai vaa ñiooquicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dai ʌpamu ii siaaco daraajatadai ʌmamaatʌrdamigadʌ vai ʌpamu coocosʌcatadai, aliʌ coocosimucatadai ʌgai mossusuligʌi vupuidʌ. Dai maimaatʌcatadai ʌgai isducatai aa noragidagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dai ʌpamu gamamada agai ʌSuusi daidʌ itʌtʌdai gʌmamaatʌrdamiga: ―Siviavʌr gia coocosi daidʌ gʌniibʌsta. Casia cʌʌgadu, casi ataayi mʌsiuu duucu giñtʌʌgida agai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami giñtʌʌgida magai soimaasi ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Vaapaigivurai, timʌda. Casia bodʌrʌ imʌi ismaacʌdʌ giñtʌʌgida agai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dai quiaa ñioocaitadai ʌSuusi tai ami divia ʌUudasi. Ʌgai ʌrʌmoco ʌbaivustaama dan gooca mamaatʌrdamigadʌ ʌSuusi vai oiditadai mui oodami dai vuucati mamastai dai uusi. Ʌgai ʌrojootosadʌcatadai ʌpapaali baitʌguucacamigadʌ ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami, ʌjudidíu sonʌrguucacamigadʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Daidʌ ʌUudasi ismaacʌdʌ gatʌʌgida agaitadai ʌSuusi caaagiditadai ʌgai ʌoodami: ―Ismaacʌdʌ usupiga aanʌ ʌgiava ʌgai vʌrai bʌi dai cʌʌga vulicami bʌcai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dai mosaayi siaaco daacatadai ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, mamaatʌtuldiadami ―astʌtʌdai. Dai usupi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mʌtai otoma bʌi dai vulicami bʌʌcai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dʌmos ʌmaadutai ismaacʌdʌ ami daraajatadai vusaitu gʌcusiru dai iquitʌ ʌmo naacadʌ ʌbaitʌcʌaacamigadʌ papaali piooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Taidʌ ʌSuusi itʌtʌdai ʌoodami: ―¿Tuimʌsi dada aapimʌ dai vuucati uusi dai mamaastai? ¿Dai tuimʌsi giñbʌquia agai, ducami siaanʌ ʌrʌmo ʌʌsivogamicagi? ");
INSERT INTO ntpNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Vʌʌs tasai gʌnsaagida daacana aanʌ ʌgʌʌ quiuupagadʌrʌ ʌjudidíu dai gʌnmamaatʌtuldiña Diuusi ñiooquidʌ, mʌtai tomali ʌmo imidagai maitimbʌi. Dʌmos poduucai idui aapimʌ vaidʌ ʌpʌduuna isducatai oojisi Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tai vʌʌscatai ʌmamaatʌrdamigadʌ voopoi dai ʌʌgi viaa ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dʌmos ʌmo gʌʌli apiaoiditadai ʌSuusi dai maitʌaadacatadai yuucusi mosʌmo icuusi tʌigigi mʌtai bʌi ʌgai ʌicusdʌaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tai ʌgai anaasi viaa gʌicuusi dai mosmʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mʌtai bʌidacai ʌSuusi ʌbaitʌcʌaacamigadʌ ʌpapaali, taidʌ gʌnʌmpagi vʌʌsi ʌpapaali tʌtʌaanʌdamigadʌ ʌʌmadu ʌsonʌrguucacamigadʌ ʌjudidíu ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Vaidʌ ʌPiiduru mosmʌʌcasdʌrʌ oiditadai ʌgʌʌ baitʌcʌaacamigadʌ papaali tuisiquigadʌrʌ ucami. Anaasi tuisicana vii ʌgai ʌʌmadu sandaaru gʌucada taí. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vaidʌ ʌtʌtʌaanʌdamigadʌ papaali ʌʌmadu vʌʌs ʌsonʌrguucacamigadʌ ʌjudidíu ʌʌmadu dudunucami gatʌcacaitadai astuma soimaasi idui ʌSuusi daida gatʌaañia agai muaragai. Dʌmos maitʌʌ ʌgai istumaasi soimaascami vui ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vai muidutai mosyaatagʌi ʌSuusi, dai maiʌmadugan duucai aagai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vai aa mosyaatagʌi daidi caiti: ");
INSERT INTO ntpNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Aatʌmʌ caʌ vaidi icaiti goovai: “Aanʌan daitudagi gogʌʌ quiuupagadʌ ʌjudidíu ismaacʌdʌ idui oodami dai vaica tasaicʌdʌ ʌpamu iduñimu aanʌ ʌmai quiuupai dai ʌgai maitʌroodami duñidʌca agai”, pocaiti goovai ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dʌmos vʌʌscʌrʌ maiʌmaduga maasi ñioocai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tai amaasi ʌgʌʌ baitʌcʌaacamigadʌ ʌpapaali cʌquiva vʌʌscatai saagida daidʌ itʌtʌdai ʌgai ʌSuusi: ―¿Tumaasi goovai ismaacʌdʌ aagai goovai gʌvui? ¿Maitapʌs gaaa noragida agai? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dʌmos ʌSuusi maiñioocacai vii, dai apiamaitadaga. Taidʌ ʌbaitʌcʌaacamigadʌ papaali ʌpamu tʌcacai daidʌ itʌtʌdai: ―¿Aapipʌsi ʌrʌCristo Diuusi maradʌ? Diuusi gia siaa duutadai aatʌmʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Taidʌ ʌSuusi itʌtʌdai: ―Ʌjʌʌ Diuusi maradʌana. Dai aapimʌ giñtʌʌgimu aanʌ siʌʌscadʌ Diuusi ismaacʌdʌ sʌʌlicʌdʌ viaa guvucadagai giñmaaquiagi ʌmo sʌʌlicami dai giñtʌʌgimu aapimʌ siʌʌscadʌ tʌvaagiaiñdʌrʌ imʌda aanʌ iicomai saagida ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Taidʌ ʌbaitʌcʌaacamigadʌ papaali saasarai gʌyuucusi baamucai caʌcatai istumaasi aagai ʌSuusi daidʌ itʌi: ―¿Tuisidʌ gaagaiña aatʌmʌ vaamioma nʌijadami? ");
INSERT INTO ntpNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Aapimʌ cacaʌ isducatai caiti goovai sai ʌpan tuiga Diuusi. ¿Mʌtumaasi tʌtʌgitoi? ―astʌtʌdai. Vai vʌʌscatai aagidi sai gatʌaanʌna muaaraga. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vai ʌʌmoco sisividimi, dai iiñapai vuivasadʌ dai gʌvai daidʌ itʌtʌdai: ―Maatʌñi toorʌ gʌgʌgʌ ―astʌtʌdai. Vaidʌ ʌsandaaru vuivasana gʌvai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Vaidʌ ʌPiiduru maigotana tuisicana daacatadai, tai ami divia ʌmo cusñirugadʌ ʌbaitʌcʌaacamigadʌ papaali. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Dai nʌiditai istaicovai daja ʌPiiduru cʌʌga gʌtʌgito nʌnʌidi daidʌ itʌtʌdai: ―Aapiapʌ ʌʌpʌ ʌʌmadu aimʌraiña ʌSuusi Nasareetʌrʌ oidacʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dʌmos ʌPiiduru ʌsto daidʌ itʌtʌdai: ―Maitan maatʌ aanʌ ʌgai, tomali maimaatʌ aanʌ pʌstumaasi agai aapi ―astʌtʌdai. Dai ii ʌPiiduru abiaadʌrʌ dai quitaagiña cʌquiva. Tai cuujui ʌmo tacu cʌliadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Taidʌ ʌcusñiru ʌpʌpʌ vui nʌnʌaava ʌPiiduru daidʌ itʌtʌdai ʌgai ismaacʌdʌ ami daraajatadai: ―Gooviavʌr aduñdʌ gomaisapicʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dʌmos ʌPiiduru ʌsto. Tai bolaascʌdʌ ʌgai ismaacʌdʌ ami daraajatadai ʌpamu itʌtʌdai ʌgai ʌPiiduru: ―Sʌʌlicʌdʌ pʌraduñdʌ aapi goSuusi. Galileeʌrʌ oidacami aapi ʌʌpʌ di, dai ʌpa maasi ñioocai aapi goSuusi aaduñdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Vaidʌ ʌPiiduru galnaasi ñiooquimi daidʌ icaiti: ―Maatʌ Diuusi nai aanʌ maimaatʌ gocʌʌli ismaacʌdʌ agai aapimʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tai ʌpʌpʌ cuujui tacu cʌliadʌ, taidʌ ʌPiiduru tʌgito istʌtʌdai ʌSuusi sai maiquiaa cuujuicai tacucu goocuaja ʌgai vaicojo itʌiya agaitadai sai maimaatʌ ʌSuusi. Dai tʌgito ʌgai gomaasi dai sosua. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dai mosmaasicai gʌnʌmpagi ʌtʌtʌaanʌdamigadʌ ʌpapaali, ʌʌmadu ʌsonʌrguucacamigadʌ ʌjudidíu ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami, ʌʌmadu vʌʌscatai tʌtʌaanʌdami. Dai vulicami bʌcai ʌSuusi dai tʌʌgi ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Taidʌ ʌPilaato tʌcacai daidʌ itʌtʌdai: ―¿Aapipʌsi ʌrraígadʌ ʌjudidíu? ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Ʌjʌ, poduuquiava pʌsducatai agai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Vaidʌ ʌtʌtʌaanʌdamigadʌ ʌpapaali naana maasicʌdʌ gʌpiʌrʌ vuupaimi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Vaidʌ ʌPilaato ʌpamu itʌtʌdai ʌSuusi: ―¿Maitapʌs gaaa noragida agai tomali ʌmo ñiooqui? Dañi vʌʌ naana maasicʌdʌ gʌpiʌrʌ gʌvuupai goovai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dʌmos ʌSuusi maiaa noragi tomali ʌmo ñiooqui. Cascʌdʌ ʌPilaato maitʌtʌgaitadai istumaasi tʌgitoagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vaidʌ ʌPilaato dadagitoiña ʌmo maisapicami aidʌ siaa duudagʌrʌ ʌʌgi poduucai gʌviidacatadai ʌgai isdadagitoldiadagi ʌoodami ʌʌgi ismaacʌdʌ ipʌliadagi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vai ami maisacariʌrʌ cuupicatadai ʌmo cʌʌli Baraavási tʌʌgiducami ʌʌmadu aa ismaacʌdʌ coitadai oodami ʌmo cocodiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tai ami dada ʌoodami dai aagidimi ʌPilaato saidʌ iduuna poduucai isduucai ivuaadana ʌgai vʌʌsi uumigi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Taidʌ ʌPilaato aa noragi daidʌ itʌtʌdai: ―¿Ipʌlidimʌsi isgʌndagitolda aanʌ gʌnraíga? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ɅPilaato maatʌcatadai isʌtʌtʌaanʌdamigadʌ ʌpapaali vui baacoicatadai ʌSuusi. Ʌgai cʌʌdaitadai ʌSuusi oidatucuitai mui oodami dai cascʌdʌ gatʌʌgi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dʌmos ʌtʌtʌaanʌdamigadʌ ʌpapaali avʌnaqui ʌoodami sai baiyoma gataanʌna ʌBaraavási. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Taidʌ ʌPilaato tʌcacai daidi tʌtʌdai: ―¿Dai tumaasi ipʌlidi aapimʌ isiduñia aanʌ goocʌdʌ ismaacʌdʌ ʌjudidíu raígadʌ aagai aapimʌ? ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tai ʌgai ijiña daidʌ itʌtʌdai: ―Siisañi curusiaba ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Taidʌ ʌPilaato itʌtʌdai: ―¿Tumaasi soimaasi iducami goovaio? ―astʌtʌdai. Tai ʌgai ʌpamu ijiña daidʌ itʌtʌdai: ―Siisañi curusiaba ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Vaidʌ ʌPilaato maitipʌliditadai isvui baacoagi ʌoodami cascʌdʌ dagitoli Baraavási, dai gatʌjai mʌsai gʌicarsana ʌSuusi dai gooquiʌrʌ gatʌjai curusiaba siisaragai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Taidʌ ʌsandaaru vaidacai ʌSuusi tuisicamu dai ami ʌmpagi vʌʌsi ʌsandaaru. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dai aadi yuucusi moraduacami daidʌ iduñi ʌmo cooronai uuparaicʌdʌ dai cʌʌsi sai ʌpa maascana ʌmo raí dai poduucai parunai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dai vʌʌscatai iiñacai daidʌ icaiti: ―Tan cʌʌca ʌraígadʌ ʌjudidíu ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dai ʌmo ali uusicʌdʌ moodʌrʌ gʌvai. Dai sisividi, dai gʌntootonacʌdʌ guguucai dai siaa duutudadan vueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Vʌʌsi poduucai parunai ʌgai dai gooquiʌrʌ uupasi ʌyuucusi moraduacʌdʌ dai ʌʌgi yuucusidʌ aadi. Dai gooquiʌrʌ vusaitu abiaadʌrʌ dai curusiaba siisa agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Vai ʌmo cʌʌli Sireñiʌrʌ oidacami Simuñi tʌʌgiducami ʌgai ʌroogadʌ Lejandro ʌʌmadu Rufo. Dai oidigaiñdʌrʌ imʌitadai ʌgai dai amui daivusai mʌtai goguama cusuvi ʌcurusi ismaacʌdʌ cusuvaticatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mʌtai bʌʌcai ʌSuusi ʌmapʌcʌrʌ siaaco Gólgota aagaiña saidʌ itʌiya ʌlidi oodami moodʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dai oida agaitadai ʌgai uuvasi varagadʌ ʌʌcocami vʌʌnacami miira taidʌ ʌSuusi maitipʌli isiiyagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mʌtai curusiaba siisa. Vaidʌ ʌsandaaru nʌʌnʌitudai volao dai nʌida agai sooriatai vuiya agai ʌSuusi yuucusidʌ dai astumaasi ajia agai ʌʌmadutai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Quiaa ʌrquiaamococatadai aidʌmʌsi curusiaba siisa ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Daidʌ ʌoojai mʌsmaacʌdʌ ooja curusiaba dai agai mʌstuisidʌ gatʌjai muaaragai, icaiti ʌʌpʌ: “Raígadʌ judidíu”. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dai abaana ʌSuusi ticurusiaba siisisa gooca ʌʌsivogami ʌʌpʌ ʌmoco sʌʌlisa padʌrʌ ʌmai curusiaba dai ʌgʌmai oogisa padʌrʌ ʌmai curusiaba. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Poduucai ʌpʌdui saidʌ ʌpʌduuna ismaacʌdʌ aagai oojiʌrʌ ismaacʌdʌ icaiti: “Oodami soimaasi ivuaadami duucai nʌidi ʌCristo”. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dai ismaacʌdʌ amui dʌgavuscʌi galnaasi ñiooqui suuligidi ʌSuusi dai gidai gʌnmoomo parunaitai ʌSuusi daidʌ itʌtʌdai: ―Epa aapi pʌsmaacʌdʌ pocaiti pʌsaidʌ istutuidi isdaitudagi ʌgʌʌ quiuupagadʌ ʌjudidíu dai vaica tasaicʌdʌ ivueeyi ʌpamu, ");
INSERT INTO ntpNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","cʌʌgacʌrʌ igʌvuusaida aapi ʌʌgi dai tʌvañi curusiaiñdʌrʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Poduucai ʌʌpʌ parunai ʌtʌtʌaanʌdamigadʌ papaali ʌʌmadu ʌmamaatʌtuldiadami sʌʌlicami dai aipaco gʌnaagidi daidʌ icaiti: ―Cʌʌgacʌrʌ vuvaitu goovai aa dai goovai ʌʌgi gia maitistutuidi iscʌʌgacʌrʌ gʌvuusaidagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Isnʌijada aatʌmʌ goCristo raígadʌ ʌjudidíu issivi tʌvañiagi curusiaiñdʌrʌ, aidʌ gia vaavoitudan tada aatʌmʌ ―ascaiti. Dai asta ʌcʌcʌʌli ismaacʌdʌ saigiʌcatadai soimaasi ñiooqui suuligidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dai dan duucu vʌʌsi oidigi tucapi vii coigʌsʌco tasai uucami. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dai aidʌ uruno tadaco gʌgʌrʌ iiña ʌSuusi daidi caiti: ―Eloi, Eloi, ¿Lama sabactani? ―ascaiti. Sai ʌgai itʌiya ʌlidi: GiñDiuusiga, giñDiuusiga, ¿Tuipʌsidʌ giñdagito? ");
INSERT INTO ntpNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dai ʌʌmoco ismaacʌdʌ ami daraajatadai caʌ ispocaiti ʌgai daidʌ icaiti: ―Dañi, vapaidi goovai ʌDiuusi ñiooquituldiadamigadʌ Eliiasi ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tai ʌmaadutai mʌʌ dai bʌi ʌmo visocli dai vadʌitu uuvasi varagadʌ ʌʌcocamicʌdʌ, dai ʌmo uusi tʌvʌducami cuugʌrʌ daí ʌvisocoli dai miaadʌrʌ dadasdi ʌSuusi sai visiusuna daidʌ icaiti: ―Tʌdagito sabai diviana Eliiasi dai tʌvaiñdana ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Taidʌ ʌSuusi gʌgʌrʌ iiña daida muu. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Vaidʌ ʌgʌʌ icuusi ismaacʌdʌ ʌgʌʌ quiuupagadʌrʌ ʌjudidíu sagiʌcatadai ʌpan ʌʌsi covoca ʌmo sueeyi dai ʌrana sʌʌli sarai tʌcavidʌrʌ abiaadʌrʌ mʌtana ucami. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Daidʌ ʌcapitán romanu ismaacʌdʌ vuidʌrʌ cʌaacatadai ʌSuusi tʌʌgacai isducatai iiña ʌgai dai isducatai muu icaiti: ―Sʌʌlicʌdʌ qui ʌrDiuusi maradʌcatadai gocʌʌli ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ʌʌmoco ooqui mʌcasdʌrʌ nʌiditadai ʌʌpʌ. Ʌgai saagida daraajatadai María Madaliña, dai María ismaacʌdʌ ʌrdʌʌdʌ Jacovo ʌʌmadu Osee. Vai ali Jacovo aagaiña oodami Jacovo. Dai modaja ʌʌpʌ Salomé. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Idi ooqui oidatucuiña ʌSuusi dai soicʌiña aidʌsi Galileeana aimʌraiña ʌgai. Dai muiducatadai aa ooqui ismaacʌdʌ oiditadai ʌSuusi Jerusaleenʌrʌ uucami. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dai caurui dai aidʌ baivuaadana ʌjudidíu vʌʌsiaʌcatai dai siaadico ibʌstaragaicatai maitistuma vuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tai ami divia Osee Arimateeʌrʌ oidacami, dai ʌgai ʌrʌmo gʌʌ tʌaanʌdamicatadai ʌʌpʌ. Dai ʌgai nʌnʌracatadai siʌʌscadʌ gatʌaanʌda agai Diuusi. Dai maiduaadicuitai vaa siaaco daacatadai Pilaato dai taí oigaragai dai tʌvaiñda agai ʌSuusi tuucugadʌ dai yaasa agai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Taidʌ Pilaato maitʌʌ isducatai tʌgituagi maicʌʌga maatʌcatai isbai camuu ʌgai. Dai vaí ʌcapitán dai tʌcaca agai sabai camuu. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Vaidʌ ʌcapitán aagidi sai camuu. Taidʌ Pilaato maa oigaragai ʌOsee isyaasagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Taidʌ Osee savʌli ʌmo icuusi namʌacami dai tʌvañi ʌmuuquiadʌ dai ʌicuusiʌrʌ biisa. Dai ʌmo aitʌana siaaco cadʌgarsicatadai ami tʌʌ. Dai taagiña daí ʌmo gʌʌ odai. ");
INSERT INTO ntpNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Vaidʌ María Madaliña ʌʌmadu María Osee dʌʌdʌ nʌidi mʌsiaaco tʌʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dai cadaivunucai ʌibʌstaragai tasʌrʌ, taidʌ María Madaliña ʌʌmadu María Jacovo dʌʌdʌ ʌʌmadu Salomé, ʌgai savʌli sigian uuvadami dai toida agai ʌmuuquiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dai tumiñoco ʌʌqui iji ʌgai siaaco yaasapicatadai ʌSuusi. Tasai vusaico aayi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Dai aipaco gʌnaagidimi ʌgai daidʌ icaitimi: ―¿Sioorʌ maigovai daasamu ʌgʌʌ odai sivaapaquimu aatʌmʌ? ―ascaitimi. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dai nʌnʌaavacai tʌʌ ʌgʌʌ odai vai camaianaasi daacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tai ʌgai vaapa siaaco yaasapicatadai ʌSuusi, dai ami tʌʌ ʌmo Diuusi tʌaañicarudʌ. Ʌgai ʌpa maasi ʌmo gʌʌli vai sʌʌlisa padʌrʌ daacatadai, dai mʌtana ugurui yuucusidʌ dai tootoaja. Taidʌ ʌooqui aliʌ duduaadimu. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dʌmos ʌDiuusi tʌaañicarudʌ itʌtʌdai: ―Maitavʌr duduaadicuda. Aapimʌ gaagai ʌSuusi ismaacʌdʌ Nasareetʌrʌ oidacatadai, ʌgai mʌsmaacʌdʌ curusiaba siisa. Dʌmos ʌgai caduaaca maitatiipu tami. Nʌidavurai movai mʌsiaaco tʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Iimivurai dai aagida ʌPiiduru ʌʌmadu ʌgaa mamaatʌrdamigadʌ ʌSuusi saidʌ ʌSuusi ʌpʌga ajiagai Galileeʌrʌ isaapimʌ. Ami tʌʌgimu aapimʌ poduucai isduucai gʌnaagidi ʌgai ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Taidʌ ʌooqui voopoi abiaadʌrʌ duduaadimucai dai giigivuquimi. Dai maiaagidi ʌgai tomali ʌmaadutai aliʌ duduaadimucai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aidʌsi duaaca ʌSuusi ʌʌpʌga gʌmaasitu ʌgai María Madaliña vuitapi ismaacʌdʌaiñdʌrʌ vuvaitu ʌgai cuvaracami Diaavora tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tai ʌgai ii dai aagidi ʌgai ismaacʌdʌ ʌʌmadu ajioopaiña ʌSuusi. Ʌgai aliʌ soigʌnʌliditadai dai suaanʌitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dai aidʌsi caʌ ʌgai isduaaca ʌSuusi, dai isnʌidi ʌooqui ʌgai maivaavoitu. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dai gooquiʌrʌ ʌSuusi gʌmaasitu ʌma duucai gooca gʌoidatucudami vuitapi. Ʌgai oidigamu iimʌitadai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tai ʌgai iji dai aagidi ʌgaa, dai tomali poduucai maivaavoitu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tai gooquiʌrʌ gʌmaasitu ʌSuusi ʌbaivustama dan ʌmoco mamaatʌrdami vuitapi aidʌsi mesa vuidʌrʌ daraajatadai ʌgai. Daidʌ ʌSuusi bagaimi gʌmamaatʌrdamiga maivaavoidaracatai ʌgai maivaavoitudacai ʌgai ʌgaa ismaacʌdʌ aagidi isnʌidi isduaaca. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Daidʌ itʌtʌdai: ―Iimivurai vʌʌsi oidigi daama dai aagida vʌʌsi oidigi daama oidacami sai casi istutuidi iscʌʌgacʌrʌ vuvaquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dai sioorʌ vaavoitudagi dai gʌnvapaconagi ʌgai cʌʌgacʌrʌ vuvaquimu. Dai sioorʌ maivaavoitudagi ʌgai Diaavora ʌʌmadu iimimu. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dai naana maasi istumaasi gʌgʌrducami ivuaadamu sioorʌ giñvaavoitudagi. Vuviadamu ʌgai oodamiaiñdʌrʌ Diaavora tʌtʌaañicarudʌ giñguvucadacʌdʌ dai ʌmamaasi ñiooqui ñioocadamu ismaacʌdʌ maimaatʌcana ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dai gʌnnoonovicʌdʌ vuudamu ʌgai gʌgʌrʌ coocoyi. Dai isyʌʌda ʌgai muuquigami maigalvuaadamu. Dai coococoidadʌ daama daraasadamu ʌgai gʌnnoonovi sidʌ ʌcoococoidadʌ duduaadʌdamu ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dai aidʌsi canaatocai ñiooqui gʌrtʌaanʌdamiga Suusi gʌmamaatʌrdamiga, taidʌ Diuusi vaidacai tʌvaagiamu dai maa ʌmo gʌʌ sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Taidʌ ʌmamaatʌrdamigadʌ aipaco iji dai aagidi oodami sai casi istutuidi iscʌʌgacʌrʌ vuvaquiagi vaavoitudacai gʌrtʌaanʌdamiga Suusi Cristo. Dai ʌgai vaa Suusi Cristo soicʌiña aa duiñdadʌrʌ vai ʌgai naana maasi gʌgʌrducami ivuaadana dai poduucai maasiuldi sai ismaacʌdʌ aagaiña ʌgai ʌrvaavoi. Dai mosʌcaasi.");
INSERT INTO ntpNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Giñaduñi Teoopilo ʌmo istumaasi gʌoojidi aanʌ. Mui oodami caooja isducatai ʌpʌdui aatʌmʌ gʌrsaagida. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ʌgai ooja ismaacʌdʌ aagidi aa ismaacʌdʌ ʌrnʌijadami. Ʌgai nʌidi isducatai ʌpʌdui tucamʌrʌ abiaadʌrʌ, dai ʌgai vaa ʌrgamamaatʌtuldiadamicatadai Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aanʌ ʌʌpʌ cʌʌga giñtaatacai gatʌcacai isducatai ʌpʌdui tucamidʌrʌ abiaadʌrʌ, dai cʌʌgadu ʌlidi aanʌ isgʌoojidagi vʌʌsi gomaasi, ");
INSERT INTO ntpNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","pai cʌʌga maatʌca aapi ismaacʌdʌ ʌrvaavoi dai sai maisiu vʌʌsi mʌsmaacʌdʌ gʌaagidiña ʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aidʌsidʌ ʌEroodʌsi ʌrgʌʌ tʌaanʌdamicatadai Judeeʌrʌ, vai ami oidacatadai ʌmo paali Zacaría tʌʌgiducami, daidʌ ʌraduñdʌcatadai ʌAviaasicaru. Daidʌ ʌooñigadʌ ʌZacaría Elisabeeta tʌʌgidu, dai vʌgoocatai ʌraaduñdʌ ʌpaali Aaróñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dai vʌgoocatai aliʌ cʌʌ tuutuiga Diuusi vui, dai cʌʌga ʌʌgidiña daidʌ ivuaadana istumaasi Diuusi ipʌlidi, dai poduucai tomali ʌmaadutai maigʌpiʌrʌ vuupaiña tomali ʌmo istumaasicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dʌmos maimaamaracatadai ʌgai, ʌElisabeeta maitistutuiditadai ismaamatadagi cascʌdʌ. Casi ʌroocodamicatadai ʌgai daidʌ ʌcʌʌli casi ʌrcʌliodamicatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dai ʌmo imidagai aʌʌcatadai ʌZacaría ʌʌmadu ʌaaduñdʌ isiduñiagi gʌnaa duiñdaga ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu. Diuusi pipiooñigadʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Dai tʌcavi daitu ʌmo tumiñsi ʌʌgi poduucai gʌviidacatadai ʌpapaali dai nʌida agai soorʌ vaacʌna ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu siaaco siaa duutudai Diuusi dai mʌidana ʌcuubimidali. Taidʌ ʌZacaría aayi isvaquiagi ʌgʌʌ quiuupiʌrʌ dai mʌidagi ʌcuubimidali. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dai aidʌsi mʌmʌiditadai ʌZacaría ʌcuubimidali vʌʌscatai ʌgaa quidigaiñdʌrʌ guucacatai gamamadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tai todian duucai tʌʌ ʌZacaría ʌmo Diuusi tʌaañicarudʌ vai bo cʌaacatadai sʌʌlisia padʌrʌ siaaco gʌmʌmʌidi cuubimidali. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dai aidʌsi ʌZacaría tʌʌ ʌDiuusi tʌaañicarudʌ maitʌʌ isducatai gʌduñiagi dai aliʌ duaadimu. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dʌmos ʌDiuusi tʌaañicarudʌ itʌtʌdai: ―Zacaría, maitiduaadicuda cacaʌ Diuusi ismaacʌdʌ taanʌi aapi daanʌitai cascʌdʌ gʌooñiga maraata agai ʌmo ali gʌʌli vʌrai Vuaana tʌʌtʌi gʌnmara. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dai baigʌnʌliadamu aapimʌ dai muidutai ʌʌpʌ diviacai ʌali oodami, ");
INSERT INTO ntpNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Diuusi tʌaanʌdami duucai nʌijada agai ʌgai cascʌdʌ. Dai ʌgai gia maitayʌʌda agai uuvasi varagadʌ tomali ʌma maasi ismaacʌdʌ navamudaga dai maiquiaa vuusaicai ʌgai aidʌ abiaadʌrʌ Diuusi Ibʌadʌ ʌʌmadu daacamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dai ʌgai vaa aagida agai ʌjudidíu sai cʌʌga vaavoitudaiña Diuusi ʌpan duucai ʌʌqui aaduñdʌcardu dai muidutai ʌma duucai gʌntʌtʌgitomu dai camaisoimaasi ivuaadamu dai vaavoitudamu Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dai ʌgai ismaacʌdʌ ʌrVuaanaca agai ʌʌpʌga imimu ʌgai isʌtʌaanʌdami dai Diuusi Ibʌadʌ ʌʌmadu daacamu sipoduucai viaacamu ʌgai guvucadagai ʌpan duucai ʌDiuusi ñiooquituldiadamigadʌ Eliiasicaru dai aagidamu ʌgai vʌʌsi oodami dʌʌdʌdʌ sai ʌpamu oigʌdaiña gʌnmaamara dai ʌgai ismaacʌdʌ soimaasi ivueeyi sai ʌma duucai gʌntʌtʌgitona Diuusi vuitapi ʌpan duucai aa ismaacʌdʌ vaavoitudai Diuusi. Dai poduucai cabai gʌnducamu ʌoodami iibʌadʌ siʌʌscadʌ diviagi ʌtʌaanʌdami Cristo ―astʌtʌdai ʌDiuusi tʌaañicarudʌ ʌZacaría. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amaasi ʌZacaría tʌcacai ʌDiuusi tʌaañicarudʌ daidʌ itʌtʌdai: ―Isducatai maatʌna aanʌ siʌrvaavoi ismaacʌdʌ giñaagidi aapi casi ʌrcʌcʌʌliocoidadʌ aatʌmʌ vʌgoocatai di ―astʌtʌdai ʌZacaría. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Taidʌ ʌDiuusi tʌaañicarudʌ aa noragi daidʌ itʌtʌdai: ―Aanʌ anʌrGavriel daidʌ ʌrootosadʌ Diuusi. Ʌgai giñootoi ansaidʌ gʌaagidana goñiooqui ismaacʌdʌ casi gʌaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dʌmos maivaavoitu aapi ismaacʌdʌ gʌaagidi aanʌ cascʌdʌ muudutumu aapi dai maiñiooquimu asta siʌʌscadʌ divia gʌmara. Idi gia povʌduñia agai ismaacʌdʌ gʌaagidi aanʌ siʌʌscadʌ Diuusi ipʌliadagi ―astʌtʌdai Gabriel. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vaidʌ ʌoodami quiidigamadʌrʌ guucacatai nʌnʌra ʌZacaría dai maitʌtʌʌgaitadai isgʌnʌldagi maiootoma vuusaicai ʌZacaría ʌgʌʌ quiuupaigadʌaiñdʌrʌ judidíu. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aidʌsi vuusai ʌZacaría maitistui isñiooquiadagi ʌoodami ismaacʌdʌ quiidigana guucacatadai. Dai poduucai maí ʌgai istʌʌ ʌgai ʌmo istumaasi ʌgʌʌ quiuupaigadʌrʌ judidíu dai cascʌdʌ muudutu. Dai seeñacʌdʌ ñiooquidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aidʌsi caaitu ʌZacaría siʌʌqui tasai gaaata duñia agaitadai ʌgʌʌ quiuupiʌrʌ, nora gʌquiiyamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dai bo chiʌʌqui tasaicʌdʌ tʌʌ Elisabeeta ʌmo ali siʌʌñi. Dai taama masaadai maivuusai ʌgai gʌquiiyaiñdʌrʌ. Dai poduucai gʌtʌgito ʌgai: ");
INSERT INTO ntpNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ʌʌgi poduucai giñduñi Diuusi dai sivi maraatamu aanʌ sicamaitiñcʌʌdadamu oodami”, asʌʌlidi Elisabeeta. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dai bo naadami masaadaicʌdʌ Diuusi ootoi ʌGavriel Nasareetamu Galilea dʌvʌʌriʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","sai aagidana ʌmo ñiooqui ʌmo ali tʌji María tʌʌgiducami. Nasareetʌrʌ oidacatadai ʌmo cʌʌli Osee tʌʌgiducami dai ʌgai ʌrcajiudadʌ Davicaru. Casi ʌrgʌncuucunacamicatadai ʌgai dʌmos maiquiaa ʌmapai oidacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aidʌsi aayi ʌGavriel mʌʌca siaaco daacatadai María itʌtʌdai: ―Baiga, Diuusi cʌʌgacʌrʌ gʌnʌidi dai vʌʌscʌrʌ gʌʌmadu daja, Diuusi vaamioma cʌʌgacʌrʌ gʌnʌidi aapi istomasmaascʌdʌ ooqui ―astʌtʌdai ʌGavriel. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aidʌsi tʌʌ María ʌGavriel dai caí istumaasi aagidi ʌgai maitʌʌ isducatai gʌtʌgituagi. “Tuisi povai iñtʌtʌdai goovai sai Diuusi cʌʌgacʌrʌ giñnʌidi”, asʌʌlidi ʌMaría. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tai amaasi itʌtʌdai ʌgai: ―María maitiduaadicuda, Diuusi cʌʌgacʌrʌ gʌnʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aapi María maraatamu ʌmo ali gʌʌli dai Suusi tʌʌtʌmu aapi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dai siaa duutuadamu muidutai ʌSuusi. Dai pocaitiadamu gooviava ʌrDiuusi maradʌ ʌvaamioma gʌʌ baitʌcʌaacami. Dai Diuusi maaquimu ʌSuusi sʌʌlicamigadʌ gʌaduñi Davicaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dai vʌʌscʌrʌ tʌaanʌdamu ʌgai ʌjudidíu. Dai tomali ʌmo imidagai maiugitimu ʌgai sʌʌlicamigadʌ ―astʌtʌdai Gavriel. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tai amaasi ʌMaría tʌcacai ʌGavriel: ―¿Ducatai ʌpʌduñia agai goovai ismaacʌdʌ giñaagidi aapi? Maiquiaa ʌrvʌʌnacami aanʌ cʌʌli di ―astʌtʌdai María. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tai aa noragi Gavriel daidʌ itʌtʌdai: ―Tʌvaañimu Diuusi Ibʌadʌ dai gʌʌmadu daacamu. Ʌgai sʌʌlicʌdʌ viaa guvucadagai. Cascʌdʌ siʌʌscadʌ vuusiagi ʌali gʌʌli ismaacʌdʌ Suusi tʌʌgiduca agai, pocaitiadamu oodami: “Gooviava ʌrDiuusi maradʌ ismaacʌdʌ tomali ʌmo imidagai maisoimaasi ivueeyi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dañi gʌaduñi Elisabeeta maraata agai ʌmo ali gʌʌli casi ʌrooquimudadʌcatai ismaacʌdʌ pocaidacatadai sai maitistutuiditadai ismaamatagi vai sivi caviaa naadami masaadai istʌʌ ʌmo ali siʌʌñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diuusi ivueeyi ʌʌgi istumaasi iduñia ʌliada ―astʌtʌdai Gavriel. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Taidʌ María itʌtʌdai: ―Aanʌ iduuñimu ʌʌgi istumaasi giñaagidagi Diuusi. Vai Diuusi iduuna aanʌcʌdʌ pʌstumaasi giñaagidi ―astʌtʌdai María. Bodʌrʌ daivunu ii Gabriel. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dai bo chiʌʌqui tasaicʌdʌ cavami ii María gaamu ucoidigamu ʌmo ali quiiyamu Judeea dʌvʌʌriʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Dai Zacaría quiidiʌrʌ vaa dai viaatuli Elisabeeta. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aidʌsi María viaatuli Elisabeeta maatʌ taata ʌElisabeeta isoiñi maradʌ ʌraana. Dai aidʌ Diuusi Ibʌadʌ divia dai ʌʌmadu daaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Amaasi gʌgʌrʌ ñioo Elisabeeta dai potʌtʌdai: ―Diuusi vaamioma cʌʌgacʌrʌ gʌnʌidi aapi istomasmaascʌdʌ ooqui. Dai cʌʌgacʌrʌ nʌidi Diuusi gʌmara ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Noorʌ aanʌ sidiviacai giñdiviji cʌʌgacʌrʌ giñvuviaadamiga dʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mosiñviaatuli aapi antai otoma maatʌ taata aanʌ isoiñi giñmara giñʌraana baigʌʌldacai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aliʌ baigʌʌlidi aapi vaavoitudacai siʌpʌduñia agai ʌgai ismaacʌdʌ gʌaagidi Diuusi tʌaañicarudʌ ―astʌtʌdai Elisabeeta. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Amaasi icaiti María: Aliʌ siaa duutudai aanʌ Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Dai aliʌ baigiñʌlidi aanʌ Diuusicʌdʌ ismaacʌdʌ cʌʌgacʌrʌ giñvusasdi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Aanʌ ʌrsoitigami vai Diuusi vʌʌscʌrʌ cʌʌgacʌrʌ giñnʌidi. Dai sivi abiaadʌrʌ baitʌacoga vʌʌsi ʌoodami aduucai giñiimʌdamu “Ismaacʌdʌ Diuusi cʌʌgacʌrʌ nʌidi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ʌgai ismaacʌdʌ sʌʌlicʌdʌ viaa guvucadagai idui mui naana maasi gʌgʌrducami aanʌ giñvʌʌtarʌ. Sʌʌlicʌdʌ tomali ʌmo imidagai maisoimaasi ivueeyi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diuusi vʌʌscʌrʌ soigʌʌlidi vʌʌscataicʌdʌ ismaacʌdʌ siaa duutudai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mui naana maasi gʌgʌrducami ivueeyi Diuusi gʌtʌgitoidacʌdʌ. Diuusi aliʌ siaa ʌʌratudai ʌgai ismaacʌdʌ gʌgʌrducʌdʌ gʌnʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Diuusi camaitipʌli siʌrtʌtʌaanʌdamicagi ʌgai ismaacʌdʌ vaamioma gatʌaanʌi, dai cascʌdʌ maa ʌsʌʌlicamigadʌ ʌsoituutuigami. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dai ʌsoituutuigami ismaacʌdʌ biuugicoñicatadai Diuusi maa mui naana maasi istuucʌdʌ tataasconʌca ʌgai. Daidʌ ʌriricu soituutuigamiʌrʌ viaa. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Diuusi cʌʌga nuucada ʌjudidíu ʌgai ʌrpipiooñigadʌ dai Diuusi aliʌ soigʌʌlidi ʌgaicʌdʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Vʌʌsi gomaasi idui ʌgai poduucai bai duí ʌgai Avraañicaru dai ʌaaduñdʌ ʌʌmadu cascʌdʌ. Dai goñiooqui ismaacʌdʌ bai duí ʌgai ʌrtomastuigaco vʌʌtarʌ. Ascaiti María. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Daidʌ María vaica masaadai daja Zacaría quiidiʌrʌ daida ʌpamu nora gʌquiiyamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dai caaayi istuigaco maraata agai Elisabeeta dai marai ʌmo ali gʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aidʌsi marai ʌgai ʌaaduñdʌ ismaacʌdʌ miaanioma oidacatadai iji dai mʌʌ dadiji dai nʌnʌidi dai poduucai camaí ʌgai isDiuusi sʌʌlicʌdʌ cʌʌga tuiga Elisabeeta vuí. Dai baigʌnʌʌli vʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Dai bo mamacova tasaicʌdʌ ʌpamu iji ʌgai dai mʌʌ iquitʌ tuucugadʌ ʌali gʌʌli dai ʌaaduñdʌ Zacaría tʌʌtʌa agaitadai potʌʌgidu ʌoogadʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Taidʌ ʌdʌʌdʌ itʌtʌdai: ―Cho, Vuaana tʌʌtʌmu aatʌmʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Taidʌ itʌtʌdai ʌaaduñdʌ: ―Tomali ʌmoco gʌaaduñi maipotʌʌgidu di ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Daidʌ ʌaaduñdʌ seeñamagi Zacaría maatʌca ʌliditai istʌʌgiduca agai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Taidʌ ʌZacaría seeñacʌdʌ taí gʌaaduñi ʌmo istumaasi istuucʌdʌ oojagi dai poduucai ooja: “Vuaana tʌʌgiducamu goovai”, asduucai ooja ʌgai. Tai camaitʌʌ ʌaaduñdʌ isducatai gʌntʌtʌgituagi tʌʌgacai ismaacʌdʌ ooja ʌZacaría. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aidʌsi quiaa nʌnʌidi ʌaaduñdʌ ismaacʌdʌ ooja ʌZacaría taidʌ ʌZacaría ʌpamu ñioo dai sʌʌlicʌdʌ cʌʌga siaa duutuli Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Taidʌ ʌaaduñdʌ sʌʌlicʌdʌ duduaadimu ʌpamu ñioocacai ʌZacaría, vai vʌʌsi ucoidigana Judeeʌrʌ vʌʌsi aipacoga gʌnaagidi ʌoodami isducatai ʌpʌdui ami Judeeʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vʌʌsi ismaacʌdʌ caí isducatai ʌpʌdui naana maasi gʌntʌtʌgitoi dai aipaco gʌntʌcacai daidʌ icaiti: ―¿Sioor maatʌ istumaasicamu goovai? Sʌʌlicʌdʌ Diuusi cʌʌgacʌrʌ nʌidi goovai ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dai Diuusi Ibʌadʌ divia dai ʌʌmadu daja Zacaría ʌVuaana oogadʌ. Aidʌ ʌZacaría aagidi ʌgaa oodami istʌtʌdai Diuusi Ibʌadʌ ʌZacaría dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Diuusi cadivia gʌrʌʌmadu dai casi cʌʌgacʌrʌ gʌrvuvaitu cascʌdʌ aliʌ siaa duutudai aanʌ Diuusi. Aatʌmʌ ʌrjudidíu Diuusi maamaradʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Diuusi gʌrootosi ʌmo cʌʌgacʌrʌ gʌrvuviaadamiga ismaacʌdʌ sʌʌlicʌdʌ viaa guvucadagai. Dai ʌgai ʌrcajiudadʌ Davicaru ismaacʌdʌ cʌʌga ʌʌgiditadai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Poduucai ʌʌqui utu oidigʌrʌ idui Diuusi gʌaatagi gʌñiñiooquituldiadamiga ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tai ʌgai aagidi gʌraaduñicaru iscʌʌgacʌrʌ gʌrvuvaida agai Diuusi. Dai maidagito agai issoigʌrvuaada agai gʌrsasaayu dai vʌʌsi ismaacʌdʌ maitʌroigʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dai sai Diuusi soigʌʌliada agaitadai gʌraaduñicarucʌdʌ. Dai sai maiugu tʌgitoca agai Diuusi gʌaatagi ismaacʌdʌ idui tucamʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Goovai ʌrgoaatagi cʌʌgaducʌdʌ ismaacʌdʌ aagidi Diuusi gʌraduñi Avraañicaru dai pocaiti sai sʌʌlicʌdʌ ʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Dai sai Diuusi gʌrsoiña agai sai maisoimaasi gʌrtaatamituldiña gʌrsasaayu. Dai tʌsai siaa duutudaiña aatʌmʌ Diuusi maiduduaadicuitai. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dai cʌʌ vuaadatai Diuusi vui. Dai cʌʌga ʌʌgiditai aatʌmʌ Diuusi siʌʌsi uucami oidacagi aatʌmʌ amaasi uucami. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dai aapi giñmara poduucai gʌiimʌdamu oodami Diuusi ʌbaitʌcʌaacami ñiooquituldiadamigadʌ. Aapi baitʌqui imia agai ʌtʌaanʌdami dai mʌʌ aagida agai oodami sai bai gʌnduucana dai siʌʌscadʌ mʌʌ diviagi ʌtʌaanʌdami sai cʌʌgacʌrʌ miaadʌgidana. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dai maatʌtulda agai aapi oodami sai Diuusi ʌgai dai cʌʌgacʌrʌ gʌrvuvaidi. Dai gʌroigʌldi vʌʌsi gʌrsoimaascamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diuusi gʌrooga sʌʌlicʌdʌ gʌroigʌdai dai soigʌʌlidi aatʌmʌcʌdʌ cascʌdʌ gʌrootosi gʌmara tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sai gʌraagidana isducatai Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana tʌsai vaavoitudacai maiiimʌna Diaavora ʌʌmadu. Cascʌdʌ povueeyi Diuusi tʌsai ʌʌmadu ajioopaiña. Ascaiti Zacaría. ");
INSERT INTO ntpNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dai gʌʌlimi ʌali gʌʌli dai vʌʌs tasai vaamioma bʌʌjimi gʌtʌgitoidaga. Dai aidʌsi cagʌʌ ʌgai oidigana oidatu asta aidʌsi gʌaagacai aagidi ʌgai Diuusi ñiooquidʌ ʌjudidíu. Dai mʌʌ diviacai aagidi ʌgai ismaacʌdʌ aagidi Diuusi isaagida ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aidʌsi vuusai Vuaana aidʌ Augusto ʌrgʌʌ baitʌcʌaacamicatadai Roomʌrʌ. Dai ʌgai tʌjai gʌsonʌrʌ guucacamiga sai ʌʌcaldana ʌoodami dai oojana istʌʌtʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aidʌ ʌrtucamidʌrʌcatadai mʌsiʌcalda agai vʌʌsi ʌoodami oidi daama oidacami. Aidʌmʌsi ʌcali ʌoodami aidʌ ʌSireñio ʌrcaigicatadai Siriana. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mʌtai tʌjai ʌoodami sai iimʌna siaaco vuvaaja mʌsai ʌcaldana. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cascʌdʌ ii ʌOsee Nasareetaiñdʌrʌ Galilea dʌvʌʌriaiñdʌrʌ Beleenamu Judeea dʌvʌʌriʌrʌ. Davicaru ʌrBeleenʌrʌ vuusaicami dai ʌOsee ʌrcajiudadʌ Davicaru cascʌdʌ ii ʌgai Beleenamu mʌsai ʌcaldana. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dai ʌOsee vaidacai María Beleenamu. Casi ʌrgʌncuucunacamicatadai ʌgai dʌmos maiquiaa ʌmapai oidacatadai. Dai María cayoga dueeyitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Aidʌsi aayi ʌgai Beleenʌrʌ camaitiipucatadai siaaco gʌnuuliña ʌgai cascʌdʌ caapayu quiidiʌrʌ gʌnuuli ʌgai. Dai aidʌsi quiaa mʌʌca daraajatadai ʌgai, tai caaayi istuigaco duaadia agaitadai María dai dueeyi. Ʌgai ʌrtuucamidʌrʌ maradʌcatadai tai biisa dai ami siaaco gacuaadana caapayu ami vooda. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dai Beleena maigovai oidigana ajioopaitadai pastutuuru dai nuucadacatadai gʌnsosoiga cañiiru tucarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tai todian duucai gʌmaasitu ʌmo Diuusi tʌaañicarudʌ ʌpastutuuru vuitapi. Tai Diuusi gʌguvucadacʌdʌ cuudan duí ami siaaco daraajatadai ʌgai tai duduaadimu ʌpastutuuru. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tai potʌtʌdai ʌDiuusi tʌaañicarudʌ: ―Maitavʌr duduaadicuda aapimʌ. Aanʌ angʌnbʌidati cʌʌga ñiooqui dai idi ñiooquicʌdʌ aliʌ baigʌnʌliadamu aapimʌ dai vʌʌsi ʌoidacami oidi daama. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ʌʌquiapo moquiiyʌrʌ siaaco oidacatadai Davicaru ʌʌquioma movuusai ʌmo cʌʌgacʌrʌ gʌnvuviaadamiga. Ʌgai ʌrgʌntʌaanʌdamiga Cristo. ɅCristo icaidaga ʌmo gʌʌ tʌaanʌdami ismaacʌdʌ ʌcovai vuusaitu Diuusi sai cʌʌgacʌrʌ gavuvaidiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mo siaaco gacuaadana ʌcaapayu mo caatʌcamu ʌali gʌʌli biisapicami sitʌʌgimu aapimʌ dai poduucai maatʌmu aapimʌ sai ismaacʌdʌ gʌnaagidi aanʌ sʌʌlicʌdʌ ʌrvaavoi ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mosai cuugaida ñioo ʌgai tai mui vaamioma gʌnmaasitu Diuusi tʌtʌaañicarudʌ daidʌ itʌtʌdai ʌgai ʌpastutuuru: ");
INSERT INTO ntpNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Mʌʌ tʌvaagiʌrʌ vʌʌsi Diuusi tʌtʌaañicarudʌ cʌʌga ñioocai Diuusi vui. Dai sivi tami oidigi daama Diuusi cʌʌgacʌrʌ nʌidi oodami. Cascʌdʌ sivi gia cacʌʌga gʌniibʌstacan taadacamu gooidacami. Ascaiti ʌDiuusi tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aidʌsi iji ʌgai abiaadʌrʌ tʌvaagiamu vaidʌ ʌpastutuuru aipaco gʌnaagidi daidʌ icaiti: ―Tiimʌda gaamu moocoro Beleenamu dai nʌida istumaasi asducatai ʌpʌdui goovai ismaacʌdʌ gʌraagidi Diuusi ―ascaiti ʌpastutuuru. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dai otoma iji dai cavami iji dai mʌʌca tʌʌ ʌgai ʌMaría dai ʌOsee dai ʌali siʌʌñi mo caatʌcatadai siaaco gacuaadana ʌcaapayu. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mostʌʌgacai ʌpastutuuru ʌgai otoma aagidi ʌMaría ʌʌmadu ʌOsee iscaiti ʌDiuusi tʌtʌaañicarudʌ aagaitai ʌali siʌʌñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dai vʌʌscatai ismaacʌdʌ caí ismaacʌdʌ aagai ʌpastutuuru camaitʌʌ isducatai gʌntʌtʌgituagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dai ʌMaría maiugu tʌgitocana istumaasi ʌpʌdui. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aidʌsi caʌpamu aa suuli ʌpastutuuru voiyamu iimʌitai siaa duutudaimi ʌgai Diuusi dai cʌʌga aatagi aatagaimi ʌgai Diuusi vʌʌtarʌ vʌʌsicʌdʌ ismaacʌdʌ tʌʌ ʌgai dai caʌ. Vʌʌsi povʌdui isducatai aagidi ʌDiuusi tʌtʌaañicarudʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mʌtai bo mamacova tasaicʌdʌ iquitʌ tuucugadʌ ʌali siʌʌñi dai Suusi tʌʌtʌi. Maiquiaa nonoacatai María abiaadʌrʌ aagidi Diuusi tʌaañicarudʌ sai Suusi tʌʌtʌna cascʌdʌ Suusi tʌʌtʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dai aidʌsi casi idui ʌgai vʌʌsi isducatai aagai Moseesacaru sʌʌlicamigadʌrʌ saidʌ ivuaadana vʌʌsi ʌooqui siʌʌscadʌ maamatadagi amaasi bʌʌcai ʌgai ʌali gʌʌli Jerusaleenamu. Dai ami ʌgʌʌ quiuupaigadʌrʌ judidíu itʌtʌdai ʌgai Diuusi: ―Aatʌmʌ ipʌlidi sai gʌrmara vʌʌscʌrʌ gʌʌʌgidiña ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Poduucai oojisi Diuusi ñiooquidʌrʌ sai vʌʌsi judidíu maamaradʌ tucamidʌrʌ isʌrcʌcʌʌlicagi sai viaacatadai isivuaadagi Diuusi aa duiñdadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iji ʌgai dai dasda agai Diuusi gooca vautu dai gooca tutuugu poduucai isduucai oojisi Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mo Jerusaleenʌrʌ oidacatadai ʌmo cʌʌli Simuñi tʌʌgiducami. Dai cʌʌga ʌʌgidiña Diuusi dai siaa duutudai. Dai ʌgai ʌrʌmoco ʌʌpʌ ismaacʌdʌ nʌnʌracatadai isdiviagi ʌmaadutai dai soiñagi ʌjudidíu vai ʌgai ʌʌgi gatʌaanʌdagi gʌndʌvʌʌragʌrʌ. Dai Diuusi Ibʌadʌ ʌʌmadu daacatadai Simuñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Dai caaagiditadai Diuusi Ibʌadʌ Simuñi sai maiquiaa muucucai ʌgai tʌʌgia agaitadai ʌCristo ismaacʌdʌ ootosa agai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dai Diuusi Ibʌadʌ ootoi Simuñi ʌgʌʌ quiuupaigadʌamu judidíu. Tai aidʌ ami dada Osee ʌʌmadu María dai bʌʌcati ʌali gʌʌli daidʌ iduñia agai isducatai viituli Moseesacaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tai ʌSimuñi bʌi ʌali siʌʌñi dai siaa duutuli Diuusi dai potʌtʌdai ʌgai Diuusi: ");
INSERT INTO ntpNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tʌaanʌdami, aanʌ ivueeyi vʌʌsi istumaasi giñaagidi aapi. Sivi gia cacʌʌga baigiñʌliaracʌdʌ muuquimu aanʌ. Casi iñtʌʌgi aapi ismaacʌdʌ giñaagidi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Catʌʌ aanʌ idi cʌʌgacʌrʌ vuviaadami ");
INSERT INTO ntpNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ismaacʌdʌ ootosi aapi vʌʌsi oidi daama oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Idi maatʌtuldamu ʌgai ismaacʌdʌ maitʌrjudidíu gʌñiooqui. Dai idi cʌʌga ñioocadamu gʌmaamara judidíu vʌʌtarʌ. Astʌtʌdai Simuñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Daidʌ ʌdʌʌdʌdʌ Suusi maitʌʌ isducatai gʌntʌtʌgituagi caʌcai istumaasi aagai Simuñi aagaitai ʌmaradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Taidʌ ʌSimuñi itʌtʌdai: ―Vai Diuusi cʌʌgacʌrʌ gʌnnʌidiña ―astʌtʌdai. Dai gooquiʌrʌ itʌtʌdai ʌgai ʌMaría ʌʌgi: ―Siʌʌscadʌ gʌʌliagi idi ali siʌʌñi ismaacʌdʌ ootoi Diuusi muidutai judidíu cʌʌgacʌrʌ vuvaaquimu idicʌdʌ dai aa mui maicʌʌgacʌrʌ vuvaaquimu dai muidutai vui ñioocadamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dai poduucai gʌmaatʌmu isducatai gʌntʌtʌgitoi ʌoodami. Dai aapi sʌʌlicʌdʌ gʌaimu soiʌliaragai ―astʌtʌdai Simuñi ʌMaría. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ami Jerusaleenʌrʌ oidacatadai ʌmo oocodami Aana tʌʌgiducami. Ʌgai ʌrPanuelicaru maradʌcatadai daidʌ ʌrcajiudadʌ Asielicaru. Dai ʌgai ʌrDiuusi ñiooquituldiadamigadʌcatadai. Aidʌsidʌ ʌrtʌjicatadai cunai ʌgai ʌmo cʌʌli. Dai bo cuvaracami uumigicʌdʌ viuudutu. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Dai aidʌ camaaco coobai dan maacova uumigi viaacatadai. Dai vʌʌs tasai maitacuaadatai aimʌraiña ʌgai ʌgʌʌ quiuupaigadʌamu ʌjudidíu dai daanʌiña Diuusi sai soicʌiña dai siaa duutudaiña Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aidʌsi quiaa ami ʌgʌʌ quiuupaigadʌrʌ judidíu guucacatadai Suusi dʌʌdʌdʌ ʌʌmadu Simuñi tai ami divia ʌAana dai ʌʌpʌga siaa duutuli Diuusi dai gooquiʌrʌ ii dai mʌʌ aagidi vʌʌsi ʌJerusaleenʌrʌ oidacami ismaacʌdʌ nʌnʌracatadai isDiuusi cʌʌgacʌrʌ vuvaidagi aagaitai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aidʌsi canaato Osee ʌʌmadu María vʌʌsi ismaacʌdʌ aagai Diuusi ñiooquidʌrʌ canoonora Nasareetamu Galilea dʌvʌʌriʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Vaidʌ ʌali gʌʌli gʌʌlimi dai cʌʌga bʌʌjimi gʌtʌgitoidaga dai Diuusi cʌʌgacʌrʌ nʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vʌʌsi uumigi mosaajʌiña ʌgʌʌ siaa duudagadʌ judidíu vai ajioopaiña dʌʌdʌdʌ ʌSuusi Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dai ʌmo imidagai caviaacatadai ʌSuusi baivustaama dan gooca uumigi aidʌsi aayi istuigaco ajioopaiña ʌgai Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dai cadaivunucai ʌgʌʌ siaa duudagai tai cavʌʌsi noonora ʌoodami tai ʌSuusi anaasi Jerusaleenʌrʌ vii. Daidʌ ʌdʌʌdʌdʌ maimaatʌcatadai ismomʌʌca vii ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Povʌnʌliditadai ʌdʌʌdʌdʌ sidʌ ʌSuusi ʌoodami saagida imʌitadai dai ʌmo tasai iji. Dai gaa ʌgai ʌSuusi ʌoodami saagida dai tʌcacaimi gʌnaaduñi dai aa oodami ismaacʌdʌ maatʌcatadai ʌgai, ");
INSERT INTO ntpNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","dai maitʌʌ. Dai ʌpamu aa suuli Jerusaleenamu dai gaaga agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vaica tasai gaa daida tʌʌ vai ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu daacatadai Suusi ʌʌmadu ismaacʌdʌ gamamaatʌtuldi Diuusi ñiooquidʌ. Dai cʌʌga gʌtʌgito caʌ dai tʌcacai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dai vʌʌscatai ismaacʌdʌ caʌ ismaacʌdʌ aagai ʌSuusi camaitʌʌ isducatai gʌntʌtʌgituagi. Dai povʌnʌlidi ducatai mosʌʌ cʌʌgadu goovai moodʌ dai mosʌʌ cʌʌga gaaa nonoragidi mʌstumaasi tʌcacai, asʌnʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aidʌsi ʌdʌʌdʌdʌ tʌʌ ʌSuusi poduucai gʌntʌtʌgitoi: “¿Ducatai tanai daja goovai?” asduucai gʌntʌtʌgitoi. Daidʌ ʌdʌʌdʌ itʌtʌdai: ―¿Giñmara tuipʌsi povʌrduuñi? Gʌooca ʌʌmadu aanʌ aliʌ duduaadimucatadai gʌgaagaitai ―astʌtʌdai María. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Taidʌ ʌSuusi itʌtʌdai: ―¿Tuimʌsidʌ giñgaagai? ¿Maitamʌsmaatʌ aapimʌ isviaa aanʌ isiduñiagi istumaasi giñtʌjai giñooca? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Taidʌ ʌdʌʌdʌdʌ maimaatʌ caí istumaasi aagidi ʌSuusi maimaatʌcatadai ʌgai isDiuusi gʌooga aagai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Taida oí ʌSuusi gʌdʌʌdʌ gaamu Nasareetamu dai apiamoʌʌsi cʌʌga ʌʌgidi gʌdʌʌdʌ. Daidʌ ʌdʌʌdʌ maiugu tʌgitocana vʌʌsi isducatai ʌpʌvueeyi dai istumaasi aagaiña ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Daidʌ ʌSuusi gʌʌlimi dai vaamioma bʌʌjimi gʌtʌgitoidaga dai Diuusi cʌʌgacʌrʌ nʌidi ʌSuusi daidʌ ʌoodami ʌcaa cʌʌgacʌrʌ nʌidi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Aidʌsi ʌTiverio Sesara ʌrʌgʌʌ baitʌcʌaacamicatadai Roomʌrʌ. Cabaivustaama dan taama uumigi daacatadai ʌgai, vaidʌ Ponsio Pilaato ʌrcaigicatadai Judeeʌrʌ, vaidʌ Eroodʌsi ʌrcaigicatadai Galileeʌrʌ, vaidʌ ʌPiili Eroodʌsi suculidʌ ʌrcaigicatadai Itureeʌrʌ ʌʌmadu Traconiitʌrʌ, vaidʌ Lisaaniasi ʌrcaigicatadai Aviliiñiʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","vaidʌ Aanasi ʌʌmadu Caifasi ʌrbaitʌguucacamigadʌcatadai ʌpapaali. Dai aidʌ ʌVuaana Zacaría maradʌ oidigana oidacatadai taidʌ Diuusi ootosi ʌmo ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Daidʌ ʌVuaana muiyapʌrʌ aimʌraiña ʌaqui Jordán ugidiana, dai aagidiña ʌoodami sai ʌma duucai gʌntʌtʌgitona dai camaisoimaasi ivuaadana sai Diuusi oigʌldana vʌʌsi soimaascamigadʌ dai sai gʌnvapaconana sai nʌidiña ʌoodami iscaʌma duucai gʌntʌtʌgito dai camaisomaasi ivuaada agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isducatai aagaitadai Isaíacaru Diuusi ñiooquituldiadamigadʌ siduuñia agai Vuaana mospovʌdui. Ʌgai aduucai ooja: Diuusi ootosa agai ʌmo cʌʌli sai oidigana gamamaatʌtuldiña dai poduucai gaaagidamu ʌgai: “Siʌʌscadʌ ʌoodami nʌnʌracagi isdiviagi ʌmo baitʌcʌaacami gʌaagai isbaiduiñdiagi voogʌdʌ. Poduucai ʌʌpʌ gʌaagai mʌsbaiduiñdiagi gʌniibʌdaga caotoma divia agai gʌrtʌaanʌdamiga cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Siʌʌscadʌ baiduiñdiagi ʌbaitʌcʌaacami voogʌdʌ siaaco dʌdʌcagiga gʌaagai iscʌʌga tʌpaalicadagi. Dai siaacoga tuutuvidaca gʌaagai iscʌʌga tʌpaalicadagi. Dai siaacoga noonoliñicagi voi gʌaagai issʌʌli tʌquiagi. Dai poduucai ʌʌpʌ gʌaagai isbaiduiñdiagi ʌoodami gʌniibʌdaga. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dai vʌʌsi ʌoodami oidi daama oidacami maatʌmu isDiuusi ʌrʌgai ismaacʌdʌ cʌʌgacʌrʌ gavuvaidi”. Ascaiti Isaía oojadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aidʌsi vuvaaja ʌoodami gʌnquiiquiaiñdʌrʌ sai vapaconana ʌVuaana taidʌ ʌVuaana potʌtʌdai: ―Aapimʌ ismaacʌdʌ daivʌi tami ansai gʌnvapaconana ʌpan ducami coocoyi ismaacʌdʌ vopooyi siuu duucu camʌʌjidagi vasoi poʌliditai sai poduucai Diuusi camaisoimaasi gʌntaatatulda agai. Ʌʌpʌga gʌaagai issʌʌlicʌdʌ ʌma duucai gʌntʌtʌgituagi aapimʌ dai camaisoimaasi ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gʌaagai mʌscʌʌgacʌrʌ oidaca aapimʌ vai nʌidiña aa mʌscaʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada agai. Dai maitavʌr gʌnaagiada aapimʌ aipacoga mʌsaidʌ ʌrAvraañicaru cajiudadʌ sai cascʌdʌ cʌʌgacʌrʌ gʌnnʌidi Diuusi. Aanʌ angʌnaagidi sai asta goojoodai ismaacʌdʌ modaraaja cʌʌga istutuidi Diuusi isiduñiagi Avraañicaru cajiudadʌ isipʌliadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Diuusi cabai gʌduu issoimaa taatatuldagi maicʌʌ tuutiacʌdʌ ʌpan duucai ʌmo cʌʌli ismaacʌdʌ guicutai uusi ismaacʌdʌ maicʌʌgadu iibiadʌ dai mʌmʌidi. Poduucai Diuusi ootosamu ʌoodami ismaacʌdʌ soimaasi ivueeyi mʌʌca siaaco tomastuigaco mʌʌcana taí ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amaasi ʌoodami tʌcacai ʌVuaana daidʌ itʌtʌdai: ―¿Tuma duuna aatʌmʌ sividʌo? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Taidʌ ʌVuaana aa noragi daidʌ itʌtʌdai: ―Ʌgai ismaacʌdʌ gʌviida gooca vaapasaragai gʌaagai isoidagi ʌmoco ʌgai ismaacʌdʌ maiviaa dai ʌgai ismaacʌdʌ gʌviidacagi cuaadagai gʌaagai isaa oidagi ismaacʌdʌ maitʌviida ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tai dada ʌʌmoco tumiñsi vuudami sai vapaconana ʌVuaana daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, ¿tuma duuna aatʌmʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Taidʌ ʌVuaana aa noragi daidʌ itʌtʌdai: ―Maitavaamioma gʌtaanʌi tumiñsi mosʌcaasi siʌʌsi maigarsi mʌsgataanʌdagi ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tai dada sandaaru ʌʌpʌ dai tʌcacai ʌʌpʌ: ―¿Dai aatʌmʌ tuma duuna? ―astʌtʌdai. Taidʌ ʌVuaana itʌtʌdai: ―Maitavʌr ʌʌsiada aapimʌ ʌoodami tomali ʌmo istumaasi guvucadacʌdʌ tomali maitʌaagai mʌsgʌpiʌr vuupada ismaacʌdʌ maigʌpiʌrʌ vʌʌtʌ, baiyomavʌr baigʌnʌliada ʌgaicʌdʌ mʌsmaacʌdʌ gamaitʌcʌi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vʌʌsi ʌoodami camaatʌcatadai isDiuusi ootosa agai ʌCristo dai canʌnʌracatadai dai cascʌdʌ povʌnʌliditadai saidʌ ʌVuaana ʌrʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dʌmos ʌVuaana potʌtʌdai vʌʌscatai: ―Aanʌ gia suudagicʌdʌ gʌnvapaconai dʌmos divia agai ʌmai ismaacʌdʌ gʌnvapacona agai Diuusi Ibʌadʌcʌdʌ sai gʌnʌʌmadu daacana Diuusi Ibʌadʌ. Dai ʌgai vaa nʌida agai oodami ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami. Ʌgai vaamioma viaa guvucadagai iñsaanʌ. Aanʌ maitistutuidi siʌʌsi istutuidi ʌgai. Aanʌ tomali maiviaa sʌʌlicami isuupasdagi susuusacadʌ gigiaaragadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ʌmo cʌʌli ismaacʌdʌ cʌlivai tʌligi bai tueeyi ʌtʌligi daidʌ ʌcosadʌ mʌmʌidi. Poduucai iduñia agai ʌgai ismaacʌdʌ divia agai ʌoodamicʌdʌ. Ismaacʌdʌ vaavoitudai ʌgai iimia agai tʌvaagiamu dai ismaacʌdʌ maivaavoitudai Diaavora ʌʌmadu iimi agai ʌgai siaaco tomali ʌmo imidagai maitutucui ʌtai ―astʌtʌdai ʌVuaana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dai poduucai dai mui vaamioma ñiooqui cʌʌgaducami aagidi ʌVuaana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dai aagidi ʌgai ʌʌpʌ ʌcaigi Eroodʌsi sai aliʌ soimaasi idui ʌgai ʌʌsidacai gʌsuculi Piili ooñigadʌ Erodiiasi, dai sai ʌma maasi soimaascami idui ʌgai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gooquiʌrʌ vaamioma soimaasi idui ʌEroodʌsi maisacai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dʌmos aidʌsi maiquiaa gʌmaisatu ʌVuaana ʌgai vapacoi mui oodami dai vacoi ʌSuusi ʌʌpʌ. Vaidʌ ʌSuusi gadaanʌitadai Diuusi dai aidʌsi gadaanʌitadai ʌgai Diuusi tai gʌcupiooco ʌtʌvaagi, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tai Diuusi Ibʌadʌ tʌvai ʌSuusi daama ʌmo tugu maasi. Tai caidatu ʌmo ñiooqui tʌvaagiaiñdʌrʌ dai pocaiti: ―Aapiapʌ ʌrgiñmara nai aliʌsi gʌoigʌdai aanʌ dai aliʌ baigiñʌlidi aanʌ aapicʌdʌ ―ascaiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Suusi viaacatadai parʌ ʌmo coobai dan baivustaama uumigi aidʌsi gʌaaga gʌaa duiñdaga. Dai poʌliditadai ʌoodami isʌgai ʌrOsee maradʌ. ɅOsee ʌrmaradʌ Elicaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ismaacʌdʌ ʌrmaradʌcatadai Maatatacaru, ismaacʌdʌ ʌrmaradʌcatadai Levícaru, ismaacʌdʌ ʌrmaradʌcatadai Melquicaru, ismaacʌdʌ ʌrmaradʌcatadai Anacaru, ismaacʌdʌ ʌrmaradʌcatadai Oseecaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ismaacʌdʌ ʌrmaradʌcatadai Matatiiasicaru, ismaacʌdʌ ʌrmaradʌcatadai Amoosicaru, ismaacʌdʌ ʌrmaradʌcatadai Naumacaru, ismaacʌdʌ ʌrmaradʌcatadai Eslicaru, ismaacʌdʌ ʌrmaradʌcatadai Nagaicaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ismaacʌdʌ ʌrmaradʌcatadai Maatacaru, ismaacʌdʌ ʌrmaradʌcatadai Matatiiasicaru, ismaacʌdʌ ʌrmaradʌcatadai Semeicaru, ismaacʌdʌ ʌrmaradʌcatadai Oseecaru, ismaacʌdʌ ʌrmaradʌcatadai Uudacaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ismaacʌdʌ ʌrmaradʌcatadai Oanacaru, ismaacʌdʌ ʌrmaradʌcatadai Resacaru, ismaacʌdʌ ʌrmaradʌcatadai Sorovaveelicaru, ismaacʌdʌ ʌrmaradʌcatadai Salatieelicaru, ismaacʌdʌ ʌrmaradʌcatadai Nelicaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ismaacʌdʌ ʌrmaradʌcatadai Melquicaru, ismaacʌdʌ ʌrmaradʌcatadai Adicaru, ismaacʌdʌ ʌrmaradʌcatadai Cosaamacaru, ismaacʌdʌ ʌrmaradʌcatadai Elimoodamacaru, ismaacʌdʌ ʌrmaradʌcatadai Eracaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ismaacʌdʌ ʌrmaradʌcatadai Osuecaru, ismaacʌdʌ ʌrmaradʌcatadai Elieesicaru, ismaacʌdʌ ʌrmaradʌcatadai Oorimacaru, ismaacʌdʌ ʌrmaradʌcatadai Mataatacaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ismaacʌdʌ ʌrmaradʌcatadai Levícaru, ismaacʌdʌ ʌrmaradʌcatadai Simeoñicaru, ismaacʌdʌ ʌrmaradʌcatadai Uudacaru, ismaacʌdʌ ʌrmaradʌcatadai Oseecaru, ismaacʌdʌ ʌrmaradʌcatadai Onanacaru, ismaacʌdʌ ʌrmaradʌcatadai Eliaaquimacaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ismaacʌdʌ ʌrmaradʌcatadai Meliacaru, ismaacʌdʌ ʌrmaradʌcatadai Mainanacaru, ismaacʌdʌ ʌrmaradʌcatadai Mataatacaru, ismaacʌdʌ ʌrmaradʌcatadai Nataanacaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ismaacʌdʌ ʌrmaradʌcatadai Davicaru, ismaacʌdʌ ʌrmaradʌcatadai Isaícaru, ismaacʌdʌ ʌrmaradʌcatadai Obedicaru, ismaacʌdʌ ʌrmaradʌcatadai Boosocaru, ismaacʌdʌ ʌrmaradʌcatadai Salimoonocaru, ismaacʌdʌ ʌrmaradʌcatadai Naasonocaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ismaacʌdʌ ʌrmaradʌcatadai Aminadaavacaru, ismaacʌdʌ ʌrmaradʌcatadai Araamacaru, ismaacʌdʌ ʌrmaradʌcatadai Esiroomacaru, ismaacʌdʌ ʌrmaradʌcatadai Pareesicaru, ismaacʌdʌ ʌrmaradʌcatadai Uudacaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ismaacʌdʌ ʌrmaradʌcatadai Jacocaru, ismaacʌdʌ ʌrmaradʌcatadai Isaacaru, ismaacʌdʌ ʌrmaradʌcatadai Avraañicaru, ismaacʌdʌ ʌrmaradʌcatadai Tarecaru, ismaacʌdʌ ʌrmaradʌcatadai Nacoracaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ismaacʌdʌ ʌrmaradʌcatadai Serugacaru, ismaacʌdʌ ʌrmaradʌcatadai Raagaucaru, ismaacʌdʌ ʌrmaradʌcatadai Peleegacaru, ismaacʌdʌ ʌrmaradʌcatadai Eveelicaru, ismaacʌdʌ ʌrmaradʌcatadai Salacaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ismaacʌdʌ ʌrmaradʌcatadai Cainanacaru, ismaacʌdʌ ʌrmaradʌcatadai Arapaajadacaru, ismaacʌdʌ ʌrmaradʌcatadai Semicaru, ismaacʌdʌ ʌrmaradʌcatadai Noecaru, ismaacʌdʌ ʌrmaradʌcatadai Lamecaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ismaacʌdʌ ʌrmaradʌcatadai Matusaleenacaru, ismaacʌdʌ ʌrmaradʌcatadai Enoococaru, ismaacʌdʌ ʌrmaradʌcatadai Areedicaru, ismaacʌdʌ ʌrmaradʌcatadai Maalaleelicaru, ismaacʌdʌ ʌrmaradʌcatadai Cainanacaru, ");
INSERT INTO ntpNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ismaacʌdʌ ʌrmaradʌcatadai Enoosicaru, ismaacʌdʌ ʌrmaradʌcatadai Setacaru, ismaacʌdʌ ʌrmaradʌcatadai Adáñicaru, ismaacʌdʌ ʌrmaradʌcatadai Diuusi ʌgai idui Adáñi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Taidʌ ʌSuusi ii ʌaqui Jordánaiñdʌrʌ vaidʌ Diuusi Ibʌadʌ ʌʌmadu daacatadai dai ʌgai vaa Diuusi Ibʌadʌ vaidacai oidigamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Amaasi aidʌsi mʌʌ oidigana divia ʌgai anaasi daja goo coobai tasai. Dai siʌʌqui tasai daja ʌgai camosaagidiña ʌDiaavora siduñia ʌgai soimaasi. Dai siʌʌqui tasai daja ʌgai oidigana ʌcaaqui tasai maitauu ʌgai. Dai asta ʌcaaqui tasaicʌdʌ aayi biuugigai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Amaasi ʌDiaavora itʌtʌdai: ―Isaapi ʌrDiuusi maradʌ di aagidañi goojoodai vai tascali gʌnaatona ―astʌtʌdai ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Diuusi ñiooquidʌrʌ pocaiti: “Maisiu mosʌca tascalicʌdʌ istutuidi oodami isoidacagi, gʌaagiava Diuusi ñiooquidʌ ʌʌpʌ”, ascaiti Diuusi ñiooquidʌrʌ ―astʌtʌdai Suusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aidʌ ʌDiaavora vaidacai ʌSuusi ʌmo gʌʌ tuvidacamu dai abiaadʌrʌ tʌtʌʌgidi vʌʌsi gʌgʌr tʌtʌaanʌdami ismaacʌdʌ oidaga oidigi daama dai vʌʌsi oodami ismaacʌdʌ tʌaanʌi ʌtʌtʌaanʌdami. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Daidʌ ʌDiaavora itʌtʌdai: ―Vʌʌsi goovai ismaacʌdʌ gʌtʌtʌgidi aanʌ, aanʌrgiñtuidaga. Aanʌ istutuidi ismaquia ʌʌgi sioorʌ maquia iñʌliada aanʌ. Aapi angʌmaquiagi vʌʌsi goovai paidʌ ʌrtʌaanʌdamica. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Isaapi gʌtootonacʌdʌ cʌquivagi giñvuidʌrʌ daidʌ giñsiaa duutudagi vʌʌsi ʌrgʌtuidacamu goovai ―astʌtʌdai ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Imʌdañi tabiaadʌrʌ aapi Diaavora poduucai oojisi Diuusi ñiooquidʌrʌ: “Siaavʌr duutuada aapimʌ gʌnDiuusiga dai mosʌca ʌgai ʌmoco avʌr ʌʌgiada” ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dai gooquiʌrʌ vaidacai ʌDiaavora ʌSuusi Jerusaleenamu. Dai ami ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu daama tʌsagi daidʌ itʌtʌdai: ―Isaapi ʌrDiuusi maradʌ di, tabiaadʌrʌ mʌtana gʌʌsi tuduidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Poduucai oojisi Diuusi ñiooquidʌrʌ: Diuusi ootosamu gʌtʌtʌaañicaru vaidʌ gʌnuucaticana. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Sigʌdaagiadamu ʌgai gʌnnoonovicʌdʌ pai maisaraana gʌʌʌcaso ʌmo odiaba. Asduu oojisi Diuusi ñiooquidʌrʌ ―astʌtʌdai ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Poduucai oojisi Diuusi ñiooquidʌrʌ di: “Maitʌaagai pʌsaagiadagi Diuusi saidʌ iduuna ʌmo istumaasi mosnʌida ʌliditai sabai giduuna” ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Amaasi ʌDiaavora camaitʌʌgacai isducatai soimaasi iduiñtuldagi ʌSuusi dagito chiʌʌqui tasai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Taidʌ ʌSuusi ʌpamu aa gʌi Galileeamu. Daidʌ Diuusi Ibʌadʌ ʌʌmadu daacatadai cascʌdʌ viaa ʌgai guvucadadʌ Diuusi. Dai vʌʌsi Galileeʌrʌ oidacami dai vʌʌsi ʌʌmapʌcʌrʌ sicoli Galilea oidacami maí istumaasi ivuaadatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dai ami Galileeʌrʌ ʌSuusi aipaco aimʌraiña judidíu quiquiuupaigadʌrʌ dai gamamaatʌtuldiña Diuusi ñiooquidʌ dai vʌʌscatai goʌʌ cʌʌga ñiooqui aagaiña aagaitai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Amaasi ʌSuusi aayi Nasareetana siaaco gʌʌ ʌgai. Dai aidʌsi aayi ibʌstaragai tasʌrʌ ii ʌgai judidíu quiuupaigadʌamu ʌʌgi poduucai gʌviidacatadai ʌgai cascʌdʌ. Dai cʌquiva dai aaga agai oojai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Taidʌ ʌnuucadacami ʌliliivru maa ʌliivru ismaacʌdʌ ooja Isaíacaru Diuusi ñiooquituldiadamigadʌ. Vai ʌgai nʌnʌidi dai tʌʌ siaaco aduucai oojisi: ");
INSERT INTO ntpNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Diuusi Ibʌadʌ giñʌʌmadu daja. Diuusi ʌcovai giñvuusaitu ansai aanʌ imʌna dai aagidana ʌcʌʌgaducʌdʌ ñiooqui ismaacʌdʌ tʌgito sioorʌ soicʌdagi vaidʌ ivuaada ʌgai istumaasi Diuusi ipʌlidi. Dai ansai aagidana aanʌ ʌgai ismaacʌdʌ maamaisaca ʌDiaavora sai casi istutuidi isvuvaquiagi. Dai ansai nʌnʌaavatudana ismaacʌdʌ maiñʌnʌeeyi. Dai ansai soiñana mʌsmaacʌdʌ soi duucai nʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dai ansai aagidana aanʌ ʌoodami sai caaayi istuigaco Diuusi cʌʌgacʌrʌ nʌijada agai vʌʌscatai. Ascaiti ʌoojai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Amaasi ʌSuusi cuu ʌliivru dai gatʌʌgi dai daiva. Dai vʌʌscatai ismaacʌdʌ ami daraajatadai apianʌnʌidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tai ʌgai ñioo daidʌ itʌi: ―Siviat caaayi aapimʌ gʌnsaagida ismaacʌdʌ ooja Isaíacaru ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vai vʌʌscatai cʌʌga ñioocai aagaitai ʌSuusi dai maitʌʌ isducatai gʌntʌtʌgituagi caʌcatai ismosʌʌ cʌʌga ñioocai ʌSuusi. Dai aipaco gʌnaagidi daidʌ icaiti: ―Cʌʌ maatʌ aatʌmʌ idi cʌʌli sidʌ ʌrOsee maradʌ daidʌ ʌrtami oidacami ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Taidʌ ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ povai iñtʌtʌaadamu aapimʌ: “Pʌssʌʌlicʌdʌ istutuidi isiduñiagi gomaasi di, iduuñiñi”. Dai povai iñtʌtʌaadamu aapimʌ ʌʌpʌ: “Tami siaaco ʌrgʌʌracami aapi igiduuñi ʌʌpʌ istumaasi caʌ aatʌmʌ saidʌ idui aapi Capernauumʌrʌ”, iñtʌtʌaadamu aapimʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Daidʌ ʌSuusi vaamioma ñioo daidʌ itʌtʌdai: ―Sʌʌlicʌdʌava ʌrvaavoi ismaacʌdʌ gʌnaagidi aanʌ sai siʌʌscadʌ gamamaatʌtuldiadagi ʌmo Diuusi ñiooquituldiadamigadʌ ʌʌgi gʌdʌvʌʌragʌrʌ maiʌʌgiditai caʌcana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Goovai ismaacʌdʌ gʌnaagidi aanʌ gia sʌʌlicʌdʌ ʌrvaavoi. Ʌʌquioma aliʌ ii biuugigai Isireli dʌvʌʌriʌrʌ, maiduudu vaica uumigi dan taaucami cascʌdʌ. Vai aidʌ oidacatadai Eliiasicaru dai muiducatadai vipiuudu ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Taidʌ Diuusi maiootoi Eliiasicaru tomali ʌmo viuudu quiidiamu anaasi issoiñagi ʌgai dai baiyoma sibʌacoga ootoi ʌgai ʌmo viuudu quiidiamu Sareepatʌrʌ Sidóni dʌvʌʌriʌrʌ sai soiñana. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dai aidʌsi quiaa oidacatadai Eliiasicaru mui judidíu viaacatadai ʌcoocodagai ismaacʌdʌ duvaldi gatuucuga. Tai vʌʌscʌrʌ tomali ʌmaadutai ʌgai maiduaadi Eliiasicaru dai baiyoma duaadi ʌmai sibʌaco oidacami Naamán tʌʌgiducami Siriʌrʌ oidacami ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dai goovai ismaacʌdʌ aa ʌSuusi caʌ ʌoodami dai sʌʌlicʌdʌ baacoi vui. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dai vʌʌscatai guuquiva dai goguaama vaidacai ʌSuusi dai vuusaitu Nasareetaiñdʌrʌ. Nasareeta ʌruranacatadai. Mʌtai tʌsagi ʌSuusi ʌmo vavuana dai abiaadʌrʌ mʌtana daituda agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Taidʌ ʌSuusi mossaagida daivusai ʌoodami dai daivunu ii. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Amaasi ii ʌSuusi Capernauumamu Galilea dʌvʌʌriʌrʌ. Dai ami mamaatʌtuldi ʌoodami Diuusi ñiooquidʌ ʌmo ibʌstaragai tasʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tai camaitʌʌ ʌoodami isducatai gʌntʌtʌgituagi caʌcatai isducatai gamamaatʌtuldi ʌgai dai ʌpan ʌʌsi cʌʌga ñioocaitai ʌmo guvucadagai viaacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dai ami judidíu quiuupaigadʌrʌ daacatadai ʌmo cʌʌli ismaacʌdʌ viaacatadai ʌmo Diaavora tʌaañicarudʌ dai gʌgʌrʌ iiña daidʌ icaiti: ");
INSERT INTO ntpNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Gʌrdagitoñi. ¿Tuipʌsi divia aapi dai gʌroojotuldi aapi Suusi Nasareetʌrʌ oidacami? ¿Gʌrugiuga pʌsiʌlidi aapi diviacai? Aanʌ gia cʌʌga gʌmaatʌ aapi. Aapiapʌ ʌrʌco vuusaidadʌ Diuusi ismaacʌdʌ tomali ʌmo imidagai maisoimaasi ivueeyi ―ascaiti ʌDiaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Taidʌ ʌSuusi bagaimi ʌDiaavora tʌaañicarudʌ daidʌ itʌtʌdai: ―Maitiñioocada. Dagitoñi gocʌʌli ―astʌtʌdai ʌSuusi. Taidʌ ʌDiaavora tʌaañicarudʌ dʌvʌʌrapi daitu ʌcʌʌli vʌʌsi ʌoodami vuitapi dai vuusai ʌcʌʌliaiñdʌrʌ dai daivunu ii. Dai vʌʌscʌrʌ tomali ʌmo soimaasi maitiduuñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tai vʌʌsi ʌoodami duduaadimu dai aipaco gʌnaagidi daidʌ icaiti: ―¿Ducatai istutuidi goovai ispoduucai ñioocadagi? Ducatai istutuidi gocʌʌli istʌaanʌdagi Diaavora tʌtʌaañicarudʌ mosʌʌ guvucadacʌdʌ vai goDiaavora tʌtʌaañicarudʌ ʌʌgidi dai otoma vuvacʌi ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Daidʌ ʌoodami vʌʌsi aipaco oidacami aatagaiña dai aagaiña ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Amaasi ʌSuusi vuusai ami judidíu quiuupaigadʌaiñdʌrʌ dai ii Simuñi quiidiamu. Vaidʌ ʌSimuñi tuumudʌ sʌʌlicʌdʌ coococatadai oiditadai toiñdagai. Vaidʌ ʌaaduñdʌ ʌcoocoadʌ daañimi ʌSuusi sai duaaidana. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Taidʌ ʌSuusi miaadʌrʌ cʌquiva dai duaadi tai otoma dagito ʌtoiñdagai. Tai otoma vañi ʌooqui dai bibi gʌdadidacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dai aidʌ ʌcʌrʌ urunoco duupidatai tasai mʌtai mui vuaapi ʌSuusi coococoidadʌ mui naana maasi coocodagai viaacami. Vaidʌ ʌSuusi mostaatamai ʌcoococoidadʌ tuutucugadʌ gʌnoonovicʌdʌ vai duduaadʌi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dai muidutai ʌcoococoidadʌaiñdʌrʌ vuvaja Diaavora tʌtʌaañicarudʌ. Dai gʌgʌrʌ ñioocai ʌDiaavora tʌtʌaañicarudʌ daidʌ itʌtʌdai ʌSuusi: ―Aapiapʌ ʌrmaradʌ Diuusi ―astʌtʌdai. Taidʌ ʌSuusi bagaimi dai camaidagito isvaamioma ñioocada ʌgai. ɅDiaavora tʌtʌaañicarudʌ maatʌcatadai isʌgai ʌrʌCristo dʌmos ʌSuusi maitipʌliditadai isaaga ʌgai cascʌdʌ maidagito isvaamioma ñiooquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dai camaasidatai ii ʌSuusi ami Capernauumaiñdʌrʌ bai mʌʌcasi oidigana siaaco maioidaga oodami. Taidʌ ʌoodami gaagamu daidʌ aayi siaaco daacatadai ʌgai. Maitipʌliditadai ʌoodami isimia ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dʌmos ʌSuusi itʌtʌdai: ―Aliʌ tʌgito aanʌ isimiagi sibʌaco gʌgʌr quiiquiamu ʌʌpʌ dai aagidagi ʌoodami sai Diuusi soicʌi ʌoodami sai cʌʌgacʌrʌ oidacana, cascʌdʌ giñootoi Diuusi idi oidigʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Daidʌ ʌSuusi gaaagidimi Diuusi ñiooquidʌ quiquiuupaigadʌrʌ ʌjudidíu Galileeʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ʌmo imidagai ʌSuusi gʌʌ suudagi ugidiana daacatadai siaaco Genesareta tʌʌgidu ʌgʌʌ suudagi. Tai mui dada oodami dai camogʌvisa ʌoodami dai sʌʌlicʌdʌ abaana gugucai asta baitoma maioiñitudai caʌca ʌliditadai ʌgai Diuusi ñiooquidʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Taidʌ ʌSuusi tʌʌ gooca vaarcu ʌgʌʌ suudagi ugidiana suudagi daama simosguuca. Ʌvatopa vuviadami cavuvajatadai abiaadʌrʌ dai vapaconaitadai gʌnvatopa vuicaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Taidʌ ʌSuusi ii dai tʌsai vaarcugadʌrʌ Simuñi dai potʌtʌdai ʌSuusi ʌSimuñi sai mʌʌcasioma imitudana ʌsuudagi ugidiaiñdʌrʌ. Taidʌ ʌSuusi ami vaarcuʌrʌ daiva dai abiaadʌrʌ mamaatʌtuldi ʌoodami Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dai aidʌsi canaato ñioo ʌSuusi potʌtʌdai ʌgai ʌSimuñi: ―Imitudañi govaarcu siaaco vaamioma tuucavaga dai suudarʌ avʌr suuliga gʌnvatopa vuvaidacaru dai vuvaida vatopa ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Taidʌ Simuñi aa noragi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami ʌmo tucagi gʌraaga aatʌmʌ dai maivui tomali ʌmoco, isaapi pocaiti di vʌʌscʌrʌ atʌsuudarʌ suuligagi govatopa vuvaidacarui ―astʌtʌdai ʌSimuñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dai mospodui ʌgai dai sʌʌlicʌdʌ mui vuvaitu vatopa asta saasaquimi ʌvatopa vuvaidacarui. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tai mooguvidʌ ʌgai gʌnaaduñi ismaacʌdʌ ʌgʌmai vaarcuʌrʌ daraajatadai sai dadana dai soiñana. Tai ʌgai dada dai cʌʌga suusudagi vʌgoocai vaarcu dai asta baitoma dupiquimi ʌvaarcu vʌʌtʌcatai. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tʌʌgacai imaasi ʌSimuñi Piiduru gʌtootonacʌdʌ cʌquivʌ ʌSuusi vuidʌrʌ daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, iñdagitoñi, aanʌrʌmo cʌʌli soimaasi ivuaadami ―astʌtʌdai ʌSimuñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ɅSimuñi aliʌ duaadimucatadai cascʌdʌ. Dai vʌʌsi ʌgaa ʌʌpʌ ismaacʌdʌ ʌʌmadu daraajatadai vʌʌscatai duduaadimucatadai mosʌʌ mui tʌʌgacai vatopa. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jacovo dai Vuaana Sevedeo maamaradʌ ʌraaduñdʌcatadai ʌSimuñi dai duduaadimucatadai ʌʌpʌ. Dʌmos ʌSuusi potʌtʌdai ʌSimuñi: ―Maiti duaadicuda sivi uucami ʌrvatopa vuudamicamu aapi dai sivi abiaadʌrʌ gaagadamu aapi oodami vaidʌ giñoidatucuiña aanʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dai amaasi cavuvaidacai ʌvaarcu ʌgʌʌ suudagi ugidiana anaasi viaa vʌʌsiaʌcatai dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ʌmo imidagai ʌSuusi ʌmo ali quiiyʌrʌ daacatadai tai ami aayi ʌmo cʌʌli ismaacʌdʌ viaacatadai ʌmo coocodagai ismaacʌdʌ duvaldi gatuucuga. Dai aidʌsi tʌʌ ʌgai ʌSuusi gʌtootonacʌdʌ cʌquiva dai dʌvʌʌrapi cuiqui dai daañimi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami pʌsipʌliadagi istutuidi aapi isgiñduaaidagi ―astʌtʌdai ʌcoocoadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Taidʌ ʌSuusi taata gʌnoovicʌdʌ daidʌ itʌtʌdai: ―Ipʌlidiana isgʌduaaidagi. Duaadicami vii ―astʌtʌdai. Mospotʌi ʌgai tai maigo ii ʌcʌʌli coocodadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Taidʌ ʌSuusi potʌtʌdai sai maiaagidiña tomali ʌmaadutai imaasi dai potʌtʌdai: ―Mosai imi dai mʌʌ vuidʌrʌ cʌquiva ʌpaali dai oida istumaasi aagai Moseesacaru sipoduucai maatʌcamu ʌoodami iscadueeyi aapi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dai aidʌsi duduaaidiña ʌSuusi ʌmo coocoadʌ vai vaamioma aipaco imimi goñiooqui vai vaamioma mui oodami gʌnʌmpaidimi vʌʌs tasai caʌca ʌliditai Diuusi ñiooquidʌ. Dai sai duduaaidana ʌgai coococoidadʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dʌmos ʌSuusi ʌcovai vusacʌiña siaaco maitiipu oodami dai ami daanʌiña Diuusi sai soiñana. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ʌmo imidagai ʌSuusi gamamaatʌtulditadai Diuusi ñiooquidʌ vai ami daraajatadai ʌʌmoco fariseo ʌʌpʌ dai ʌʌmoco mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ismaacʌdʌ vʌʌsi ʌʌmapʌcʌrʌiñdʌrʌ Galilea dada dai vʌʌsi Judeeaiñdʌrʌ dai Jerusaleenaiñdʌrʌ. Taidʌ ʌSuusi Diuusi guvucadadʌcʌdʌ duduaadi ʌcoococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tai ami dada ʌʌmoco cʌcʌʌli dai bʌʌcaticatadai uusiʌrʌ ʌmo cʌʌli ismaacʌdʌ maitistutuiditadai isoiñiagi vai ʌgai vaasa ʌliditadai tuucavi siaaco daacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dʌmos maitʌtʌʌgaitadai siaa sʌʌli vaasagi ʌgai ʌcoocoadʌ gʌvistudicatadai oodami cascʌdʌ. Dai vaaqui daama tʌʌtʌsai dai abiaadʌrʌ cupiooco dai amui sʌʌli tʌvañi ʌcoocoadʌ sueeyiʌrʌ vʌʌsi ʌoodami saagida sʌʌli dai aitu siaaco daacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dai aidʌsi tʌʌ ʌSuusi siʌʌsi vaavoitudaitadai ʌgai, potʌtʌdai ʌgai ʌcoocoadʌ: ―Giñaduñi gʌsoimaascamiga caoigʌldi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amaasi ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo ʌʌgi gʌntʌtʌgitoimi dai povʌnʌlidi: “Sioorʌ idi cʌʌli dai pomaasi ñioocai. Vui ñioocai Diuusi tomali ʌmaadutai maitistutuidi isgaoigʌldiadagi gasoimaascamiga mosʌʌgi Diuusi”, asʌnʌlidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dʌmos ʌSuusi maatʌcatadai ispomaasi gʌntʌtʌgitoitadai ʌgai dai potʌtʌdai: ―¿Tuimʌsi poduucai gʌntʌtʌgitoi aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tumaasi siooma maisijaiga isaagagi: “Gʌsoimaascamiga caoigʌldi”, siʌʌpʌ potʌʌdagi: “Cʌquivañi dai aimʌrda”? ");
INSERT INTO ntpNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gʌntʌʌgidamu aanʌ aapimʌ iñsaanʌ viaa ʌmo sʌʌlicami dai viaa guvucadagai tami oidigi daama isgaoigʌldiadagi gasoimaascamiga ―astʌtʌdai ʌSuusi ʌoodami. Dai amaasi potʌtʌdai ʌgai ʌcʌʌli coocoadʌ: ―Aapi angʌaagidi vañigiñi dai bʌi gʌsuaa dai imʌda gʌquiiyamu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mospotʌi ʌSuusi tai otoma vañi ʌcoocoadʌ vʌʌscatai vuitapi dai bʌi gʌsuaa istuucʌrʌ caatʌcatadai dai nora gʌquiiyamu dai cʌʌga ñiooquimi Diuusi vui. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dai vʌʌscatai ʌoodami maitʌʌ isducatai gʌntʌtʌgituagi dai cʌʌga ñiooquimi Diuusi vui. Dai duduaadimucatai pocaiti: ―Sivi gia tʌʌ aatʌmʌ istumaasi gʌgʌrducami ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Dai amaasi vuusai ʌSuusi abiaadʌrʌ dai tʌʌ ʌmo cʌʌli tumiñsi vuudami. Ʌgai Leví tʌʌgidu dai daacatadai quiiyʌrʌ siaaco gʌvuudana tumiñsi dai potʌtʌdai ʌSuusi: ―Giñoidañi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Amaasi ʌLeví cʌquiva dai anaasi viaa vʌʌsiaʌcatai dai oí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dai gooquiʌrʌ ʌLeví idui ʌmo gʌʌ vagimi gʌquiiyʌrʌ ʌSuusi vʌʌtarʌ dai ami daraajatadai mui tumiñsi vuudami dai aa oodami meesa vuidʌrʌ ʌgaa ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Vaidʌ ʌfariseo ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ aatagidi ʌSuusi mamaatʌrdamigadʌ dai potʌtʌdai: ―¿Tuimʌsidʌ gacueeyi dai gayʌʌyi aapimʌ gotumiñsi vuudami dai gosoimaasi ivuaadami ʌʌmadu? Aapimʌ maicʌʌga ivueeyi ―astʌtʌdai ʌgai ʌSuusi mamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ismaacʌdʌ maitʌrcoococoidadʌ maitʌgito duduaaidiadami mosʌʌgi coococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Poduucai aanʌ ʌʌpʌ maicʌcʌʌgaducʌdʌ vʌʌtarʌ divia mosʌʌgi soimaasi ivuaadami vʌʌtarʌ antdivia aanʌ vai ʌmaa duucai gʌntʌtʌgitona ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amaasi ʌgai tʌcacai ʌSuusi daidʌ itʌtʌdai: ―Tuisidʌ mosʌʌ maitacueeyi dai mosʌʌsi gamamadaiña ʌmamaatʌrdamigadʌ ʌVuaana daidʌ ʌmamaatʌrdamigadʌ ʌfariseo. Dai aapi gʌmamaatʌrdamiga vʌʌscʌrʌ gacueeyi dai gayʌʌyi ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Istutuidisi ismaitaugiagi ʌvapaidarsicʌdʌ ʌmo cunataragiʌrʌ siʌʌscadʌ quiaa daraajagi ʌcuucuntadami? ");
INSERT INTO ntpNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dʌmos todian duucai gʌmuaatudamu ʌcʌʌli amaasi maitaugimu ʌvapaidarsicʌdʌ ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dai apiamamaatʌtuldi dai potʌtʌdai: ―Tomali ʌmaadutai maisaranan tada ʌmo ipuurui utuudui dai ʌcʌdʌ daasdagi ʌmo ipuurui cʌliñdadʌ. Ispoduuñiagi ʌgai siaa tuidimu ʌipuurui utuuducʌdʌ dai vʌʌscʌrʌ ʌicuusi utuuducʌdʌ maicʌʌga viimu ʌipuurui cʌliñdadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tomali ʌmaadutai maitueeyi valienti utuudui ojoogi cʌcʌʌliocoidadʌrʌ ispoduuñiagi ʌvalienti utuudui cocopoñtudamu ʌojoogi dai siaa tuidimu vʌʌsi siʌʌsi ʌvalienti ʌcaasi ʌojoogi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cascʌdʌ gʌaagai isoojogi uutuducamiʌrʌ tuaadagi valienti utuudui dai poduucai maisiaa tuidʌrʌi ʌvalienti tomali ʌojoogi. ");
INSERT INTO ntpNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Vʌʌscatai ismaacʌdʌ yʌʌyi valienti cʌliñdadʌ gooquiʌrʌ maiaagaiña valienti utuudui pocaitiña sai siooma vʌʌñiga cʌliñdadʌ ―astʌtʌdai ʌSuusi ʌoodami. Gomaasi aagidi ʌSuusi ʌoodami cʌʌga maatʌcatai isʌoodami apiavaamioma cʌʌga vaavoitudai ʌʌquidʌ gʌnvaavoidaraga dai maisiu utuuducʌdʌ mamaatʌtuldaragadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ʌmo imidagai ibʌstaragai tasʌrʌ ʌʌsicami saagida imʌitadai ʌSuusi vaidʌ ʌmamaatʌrdamigadʌ vaiñcumaimi tʌligi muuradʌ dai gʌnnoonovicʌdʌ cʌlivaimi dai cuumimi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tai ʌmaadutai ʌfariseo itʌtʌdai: ―¿Tuimʌsidʌ ivueeyi aapimʌ aa duiñdagai ismaacʌdʌ maitiipu oigaragai isivuaadagi ibʌstaragai tasʌrʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Maitamʌsquiaa nʌidi aapimʌ oojai siaaco aagai ismaasi idui Davicaru ʌmo imidagai aidʌsi ʌgai ʌʌmadu aaduñdʌ biuugicoi? ");
INSERT INTO ntpNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Vaa ʌgai ʌquiiyʌrʌ siaaco siaa duutudaiña ʌjudidíu Diuusi dai vui ʌpaana daasdaradʌ Diuusi dai uu ʌgai dai oi gʌaaduñi ismaacʌdʌ ʌʌmadu daraajatadai. Daidʌ ʌpaana mosʌʌgi papaali viaacatadai oigaragai iscuaadagi ʌʌgi poduucai viituli Moseesacaru cascʌdʌ, tai vʌʌscʌrʌ vui ʌDavicaru dai uu. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dai potʌtʌdai ʌʌpʌ: ―Aanʌ viaa ʌmo sʌʌlicami cascʌdʌ viaa aanʌ sʌʌlicami isaagagi istumaasi ʌpʌduuñiagi ibʌstaragai tasʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ʌʌpʌ ʌmo ibʌstaragai tasʌrʌ judidíu quiuupaigadʌrʌ vaa ʌSuusi dai gʌaagacai mamaatʌtuldi ʌoodami Diuusi ñiooquidʌ. Tai ami vaa ʌmo cʌʌli ismaacʌdʌ gaquisapicatadai novidʌ sʌʌlisia padʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vaidʌ ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo soobidacatadai ʌSuusi sabai duaaidana ibʌstaragai tasʌrʌ dai poduucai viaacagi istucʌdʌ gʌpiʌrʌ vuaajagi ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dʌmos ʌSuusi maatʌcatadai ismaasi gʌntʌtʌgitoitadai ʌgai daidʌ itʌtʌdai ʌcʌʌli ismaacʌdʌ gaquisapicatadai novidʌ: ―Cʌquivañi dai mʌʌ ʌran ʌʌsi cʌquiva ―astʌtʌdai. Taidʌ ʌcʌʌli cʌquiva dai ami cʌquiva siaaco aagidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Amaasi ʌSuusi potʌtʌdai ʌgaa: ―Giñaagidavurai ʌmo istumaasi: ¿Tumaasi oidaga oigaragai isivuaadagi ibʌstaragai tasʌrʌ istumaasi cʌʌgaducami maicʌʌgaducami sio, cʌʌgacʌrʌ vuvaidagi oodami coodagi sio? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Amaasi ʌSuusi nʌnʌidi vʌʌscatai ismaacʌdʌ ami daraajatadai dai potʌtʌdai ʌgai ʌcʌʌli: ―Giñuuliñdañi gʌnovi ―astʌtʌdai. Taidʌ ʌcʌʌli uuliñi gʌnovi dai cacʌʌga duaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Taidʌ ʌgaa sʌʌlicʌdʌ baacoi dai aipaco gʌntʌcacaimi astumaasi istutuidi isiduuñiagi ʌSuusi vui. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Amaasi ii ʌSuusi ʌmo giidiamu dai daañia agai Diuusi sai soiñana dai ʌmo tucagi anaasi siaa daanʌitai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dai aidʌsi camaasi ʌgai vaí gʌmamaatʌrdamiga dai ʌcovai vuvaitu baivustaama dan gooca ʌgai saagidaiñdʌrʌ saidʌ ʌrojootosadʌcana. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Dai potʌʌtʌgidu ʌgai: Ʌmoco ʌrSimuñi taidʌ ʌSuusi Piiduru tʌʌtʌi ʌʌpʌ, dai Aandʌrʌsi ʌʌpʌ Simuñi suculidʌ, dai Jacovo, dai Vuaana, dai Piili, dai Bartolomé, ");
INSERT INTO ntpNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","dai Mataivo, dai Tomás, dai Jacovo Alfeo maradʌ, dai Simuñi ʌgai ʌrʌmoco zelolote saagidaiñdʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","daidʌ Uudasi Jacovo suculidʌ, daidʌ Uudasi Iscaliote ismaacʌdʌ gooquiʌrioma gatʌʌgi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Daidʌ ʌSuusi tʌvai giidiaiñdʌrʌ vʌʌscatai ʌgai ʌʌmadu. Dai ʌmapʌcʌrʌ siaaco tʌpaalica cʌquiva ʌSuusi mui gʌmamaatʌrdamiga ʌʌmadu dai oidacatadai ʌʌpʌ mui oodami vʌʌsi Judeea dʌvʌʌriaiñdʌrʌ dai Jerusaleenaiñdʌrʌ dai coostaiñdʌrʌ siaaco Tiiro tʌʌgidu dai Sidóni ʌʌpʌ. Vʌʌsi idi ami dada caʌca ʌliditai Diuusi ñiooquidʌ dai duduaadia ʌliditai ʌʌpʌ cascʌdʌ dada ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dai ismaacʌdʌ soimaa taatacana viaacatai Diaavora tʌtʌaañicarudʌ vʌʌsi duduaadi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vʌʌsi ʌoodami taata ʌliditadai ʌSuusi. Ʌgai duduaaidiña ʌcoococoidadʌ gʌguvucadacʌdʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Amaasi ʌSuusi vui nʌnʌava gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―Diuusi cʌʌgacʌrʌ gʌnnʌidi aapimʌ giñmamaatʌrdamiga. Aapimʌ cʌʌga maatʌ istʌgito sioorʌ gʌnsoiñagi maidʌ ivuaada aapimʌ istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Diuusi cʌʌgacʌrʌ gʌnnʌidi aapimʌ ismaacʌdʌ biuugicoñi sivi gooquiʌrʌ tatasconʌca agai aapimʌ cascʌdʌ. Diuusi cʌʌgacʌrʌ gʌnnʌidi aapimʌ ismaacʌdʌ suaanʌi sivi, gooquiʌrʌ asʌda agai aapimʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Diuusi cʌʌgacʌrʌ gʌnnʌidi aapimʌ ismaacʌdʌ gʌncʌʌdai oodami dai siʌʌscadʌ maitʌnñiooquiadagi, daidʌ gʌnñiooquiadagi, dai tomali maicaʌca ʌliadagi gʌntʌʌtʌaraga vʌʌsi goovai povʌduuñimu giñoidatucuitai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Vʌʌscʌrʌ sʌʌlicʌdʌavʌr baigʌnʌliada amaasi. Poduucai idui ʌʌqui aaduñdʌcardu gooodami maicʌʌ tuutiacʌdʌ Diuusi ñiñiooquituldiadamigadʌcʌdʌ. Mʌʌ tʌvaagiʌrʌ gʌnmaaquimu Diuusi mui naana maasi cʌcʌʌgaducami. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Dʌmos siʌʌ soimaa taatamu ʌriricu gooquiʌrʌ, sivi gia viaa ʌgai istucʌdʌ baigʌnʌliadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Siʌʌ soimaa taatamu ʌgai ismaacʌdʌ tatasconʌ sivi, gooquiʌrʌ biuugicoñicamu ʌgai. Siʌʌ soimaa taatamu ʌgai ismaacʌdʌ sivi asʌi, gooquiʌrʌ suaanʌdamu ʌgai soiʌliaragaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Siʌʌ soimaa taatamu ʌgai siʌʌscadʌ vʌʌscatai cʌʌga ñioocadagi ʌgai vui, poduucai idui ʌʌqui aaduñdʌcardu ʌgaicʌdʌ ismaacʌdʌ poduucai yaatagʌi saidʌ ʌrDiuusi ñiñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Dʌmos aapimʌ mʌsmaacʌdʌ giñcaʌ aapimʌ angʌnaagidi: Oigʌadavurai gʌnsasaayu, dai cʌʌgavʌr ivuiidiada ismaacʌdʌ gʌncʌʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cʌʌgavʌr ñioocada ʌgai vui ismaacʌdʌ maicʌʌga ñioocai aapimʌ gʌnvui. Isʌmaadutai gʌnñiooquiadagi daanʌdavurai Diuusi ʌgai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Isʌmaadutai gʌngʌʌgʌviagi ʌmapiadʌrʌ gʌnvuivasa vʌrai ajadʌrʌ vui daasa ʌʌpʌ. Dai isʌmaadutai bʌiyagi gʌsuaa dagitoñi vai bʌʌcaiña gʌvaasaraga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dai sioorʌ gʌtaanʌdagi ʌmo istumaasi pai oidiada. Isʌmaadutai bʌiyagi istumaasi ʌrgʌtuidaga maititaanʌda. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ivuiidiadavurai aa mʌstumaasi aapimʌ ipʌliadagi isgʌnvuiidiada ʌgai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mʌsaapimʌ oigʌadagi mosʌcaasi ismaacʌdʌ gʌnoigʌdai aapimʌ, ¿tumaasi ʌrcʌʌgai poduucai? Asta ʌgai ismaacʌdʌ maicʌʌga tuutuiga ʌʌpʌ poduucai ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mʌsiʌʌpʌ cʌʌga ivuiidiadagi mosʌcaa ʌgai ismaacʌdʌ cʌʌga gʌnvuiididi aapimʌ, ¿tumaa cʌʌga ivueeyi aapimʌ poduucai? Maicʌʌga tuutiacʌdʌ ʌʌpʌ poduucai ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dai mʌstaañiupiadagi mosʌcaa ʌgai ismaacʌdʌ gʌnaa noragidadan tadacagi, ¿tumaasi cʌʌga ivueeyi aapimʌ poduucai? Maicʌʌga tuutiacʌdʌ ʌʌpʌ taañiupidi ʌgaa maicʌʌga tuutiacʌdʌ dai nʌnʌracana isaa noragidagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dʌmos aapimʌ gʌaagai isoigʌadagi gʌnsasaayu dai cʌʌga ivuiidiadagi dai taañiupiadagi dai maitʌgitocagi mʌsaa gʌnnoragidagi. Poduucai Diuusi naana maasi gʌnmaaquimu dai poduucai aapimʌ maamaradʌ Diuusi ismaacʌdʌ ʌrʌvaamioma baitʌcʌaacami gʌnducamicamu. Diuusi cʌʌtuiga maicʌʌga ivuaadami vui dai ismaacʌdʌ maiDiuusiatʌnamʌquidana caitiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Oigʌldiadavurai aapimʌ aa poduucai isduucai Diuusi gʌnooga oigʌldi ʌmaicʌʌga tuutiacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Maitavʌr pocaitiada: “Dañi tʌʌ soimaasi idui ʌgai”, mʌsimaipovʌntʌtʌadamu aapimʌ ʌʌpʌ. Maitavʌr pocaitiada siʌrgʌpiʌr caatʌcami ʌgai mʌsimaipovʌntʌtʌadamu aapimʌ ʌʌpʌ. Oigʌldiadavurai aa mʌsaapimʌ gʌnoigʌldiadamu ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Oidiadavurai aapimʌ aa mʌsiaapimʌ gʌnoidiadamu gʌnbaimocorʌrʌ ʌmo ʌpavidacarui cʌʌgaducamiʌrʌ cʌʌ suudacami gigigidicami, dai cʌʌ gʌisatudicami dai vʌʌtʌncʌacami. Ʌpavidacaruicʌdʌ ismaacʌdʌcʌdʌ gamaacai aapimʌ istumaasi ʌgai vaacʌdʌ gʌnmaaquimu ʌgai ʌʌpʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dai ʌSuusi aduucai gamamaatʌtuldi: ―¿Istutuidisi ʌmo mainʌaadami isvaidaticagi ʌmai mainʌaadami? ¿Maisiu suuligia ʌgai vʌgoocatai sibʌ dʌʌcarʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ʌmo mamaatʌrdami maivaamioma maatʌ isʌmamaatʌtuldiadamigadʌ, dai siʌʌscadʌ cacʌʌga maatia ʌgai ʌpan ʌʌsi maatʌcamu gʌmamaatʌtuldiadamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Tuipʌsi gʌtʌgito nʌidi aapi issoimaasi ivueeyi gʌaduñi dai maitʌtʌgito nʌidi isaapi vaamioma soimaasi ivueeyi? ");
INSERT INTO ntpNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ducatai maisiaa ʌʌrai aapi ispotʌtʌadagi gʌaduñi: “Dañi aliʌ soimaasi ivueeyi aapi”. Dai maitʌtʌgito nʌidi isvaamioma soimaasi ivueeyi aapi. Aapi ʌrʌmoco ismaacʌdʌ aagai ʌmo istumaasi daidʌ ivueeyi ʌma maasi. Ʌʌpʌga gʌaagai iscamaisoimaasi ivuaada aapi dai gooquiʌrʌ aagidagi gʌnaduñi sai camaisoimaasi ivuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Maioidaga uusi cʌcʌʌgaducami issoimaasi iibiatadagi dai ʌmo uusi maicʌʌgaducami maitistutuidi iscʌʌgaducagi iibiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vʌʌsi uusi gʌmaatʌ iibiadʌrʌ. Maitavʌyoovai iigosi tomali uuvasi uupariaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ʌmo cʌʌli maisoimaasi ivuaadami maisoimaasi ñioocaiña, ibʌadʌrʌ daja gocʌʌ tʌgitoidagai cascʌdʌ. Dai ʌcʌʌli maicʌʌga ivuaadami goʌʌgi soimaasi ñioocaiña, ibʌadʌrʌ daja gosoimaasi tʌgitoidagai cascʌdʌ istumaasi aagai ʌgai gʌtʌñicʌdʌ vʌʌsi ibʌadʌaiñdʌrʌ vusacʌi. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Tuimʌsi pocaitiña ansai aanʌ ʌrgʌnaamu dai vʌʌscʌrʌ maitiñʌʌgidiña? ");
INSERT INTO ntpNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gʌnaagidamu aanʌ sioorʌ ʌpan ducami ʌgai ismaacʌdʌ giñʌʌgiditai caʌ daidʌ ivueeyi istumaasi aagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ʌgai ʌpan ducami ʌmo cʌʌli ismaacʌdʌ idui ʌmo vaaqui dʌmos ʌʌpʌga cʌʌga tuucavi cooco ʌgai dai cʌʌgaducami daí simiento dai aidʌsi gʌpi daivusai suudagi vʌʌscʌrʌ maioiñitu aliʌ cʌʌgaducatadai simientogadʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dai ismaacʌdʌ giñcaʌ dai maitivueeyi istumaasi tʌaanʌi aanʌ ʌgai ʌpan ducami ʌmo cʌʌli ismaacʌdʌ idui ʌmo vaaqui mosdʌvʌʌrapi maidarasacai ojoodai uta tai gooquiʌrʌ gʌpi daivusai suudagi dai daitu taidʌ ʌvaaqui camaicʌʌgaducami vii ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aidʌsidʌ ʌSuusi naato ñiooqui ʌoodami ii Capernauumamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Vai ami oidacatadai ʌmo sandaaru tʌaanʌdamigadʌ ʌgai ʌrromanu dai ʌgai viaacatadai ʌmo piooñi ismaacʌdʌ aliʌ oigʌdai ʌgai vai ʌgai aliʌ coococatadai cayoga muu. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Daidʌ ʌsandaaru tʌaanʌdamigadʌ cajioomacatadai isami aimʌraitadai ʌSuusi dai ootoi chiʌʌqui tʌtʌaanʌdamigadʌ judidíu sai mʌʌ daanʌna ʌSuusi sai diviana dai duaaidana ʌpiooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tai ʌgai miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi dai sʌʌlicʌdʌ goguaama oidatucui dai potʌtʌdai: ―Idi sandaaru tʌaanʌdamigadʌ gia gʌaagai pʌssoiñagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ʌgai gia siaa gʌrduutudai aatʌmʌ judidíu dai ʌgai vaa ʌgai dai gatʌjai duiñdagai gʌrquiuupaiga ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Taidʌ ʌSuusi ii ʌgai ʌʌmadu dʌmos aidʌsi cayoga aayi ʌgai quii taidʌ ʌtʌaanʌdamigadʌ sandaaru ootoi aa gʌaaduñi sai potʌʌdana ʌSuusi: ―Mamaatʌtuldiadami maitisoi gʌvuaada aanʌ tomali maiviaa sʌʌlicami pʌsvaquiagi giñquiiyʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","cascʌdʌ maitipiñʌli aanʌ isʌʌgi mʌʌca gʌgaagamuagi. Mosai potʌi sai duaadʌna sidʌ giñpiooñiga caduaadimu, asduucai ootosi ʌsandaaru tʌaanʌdamigadʌ ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aanʌan ʌʌpʌ viaa giñtʌtʌaanʌdamiga dai poduucai ʌʌpʌ viaa aanʌ giñsandaaruga ismaacʌdʌ tʌaanʌi aanʌ siuu duucu potʌʌda aanʌ ʌmoco sai imʌʌna vai aimʌrai dai siuu duucu potʌʌda aanʌ sai diviana vai didivai, dai siuu duucu tʌaañia aanʌ giñpiooñiga saidʌ iduuna ʌmo istumaasi vaidʌ ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aidʌsi caʌ ʌSuusi imaasi maitʌʌ istumaasi gʌtʌgituagi ʌcʌʌli vui dai vui nʌnʌaava ʌoodami ismaacʌdʌ oiditadai dai potʌtʌdai: ―Sʌʌlicʌdʌ tomali judidíu saagida mainʌidi aanʌ tomali ʌmoco ispocaasi vaavoitudai siʌʌsi vaavoitudai idi cʌʌli ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dai aidʌsidʌ ʌojootosicami quiiyʌrʌ dada vaidʌ ʌpiooñi coocoadʌ caduaadicatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dai cadaivunucai imaasi vaidʌ ʌSuusi Naína amaco imʌitadai vaidʌ ʌmamaatʌrdamigadʌ oiditadai dai mui aa oodami ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dai aidʌsi cayoga aayi ʌgai ami Naínʌrʌ tʌʌ mʌsbʌʌcaticatadai ʌmo muuquiadʌ dai yaasa agai dai ʌgai ʌmaaduacatadai maradʌ ʌooqui viuudu vai mui oodami ami dʌvʌʌriʌrʌ oidacami oiditadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dai aidʌsi tʌʌ ʌSuusi soigʌʌli ʌooquicʌdʌ dai potʌtʌdai: ―Maiti suaacada ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dai miaadʌrʌ cʌquiiva dai taata ʌcajooñi tai guuquiva ʌgai ismaacʌdʌ bʌʌcaticatadai taidʌ ʌSuusi potʌtʌdai ʌgʌʌli muuquiadʌ: ―Gʌʌli aanʌ angʌaagidi vañigiñi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tai ʌgai ismaacʌdʌ ʌrmuuquiadʌcatadai sʌʌli daiva dai gʌaagacai ñioocai taidʌ ʌSuusi tʌʌgi ʌdʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dai tʌʌgacai ʌoodami imaasi vʌʌscatai duduaadimu dai siaa duutudaimi Diuusi dai pocaitimi: ―Gʌrsaagida tigʌmaasitu ʌmo Diuusi ñiooquituldiadamigadʌ ―ascaiti. Daidʌ icaiti ʌʌpʌ: ―Diviatiqui Diuusi dai soiña agai gʌmaamara ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dai vʌʌsi Judeeʌrʌ dai vʌʌsi uugidiana gʌmaí istumaasi idui ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Taidʌ ʌVuaana maí vʌʌsi gomaasi, ʌmamaatʌrdamigadʌ aagidi cascʌdʌ. Taidʌ ʌVuaana vaí gooca gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dai ootoi siaaco daacatadai ʌSuusi sai tʌcacana sabai ʌgai sʌʌlicʌdʌ ʌrʌCristo ismaacʌdʌ viaacatadai isdiviagi sabai gʌaagai isnʌnʌracagi ʌmai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Taidʌ ʌmamaatʌrdamigadʌ ʌVuaana miaadʌrʌ guuquiva ʌSuusi daidʌ itʌtʌdai: ―ɅVuaana, ʌgai ismaacʌdʌ vapaconai ʌoodami, gʌrootoi tʌsai gʌtʌcacana pʌsabai aapi ʌrʌCristo ismaacʌdʌ viaa isdiviagi siʌʌpʌ sabai gʌaagai tʌsnʌnʌracagi ʌmai ―ascaiti ʌVuaana mamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dai aidʌsi mosaayi ʌgai ami ʌSuusi duduaadi mui oodami coococoidadʌ dai ismaacʌdʌ viaacatadai Diaavora tʌtʌaañicarudʌ duduaadi ʌʌpʌ dai mui ismaacʌdʌ mainʌnʌeeyitadai ʌgai nʌnʌaavatu. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dai poduucai ʌSuusi aa noragi dai potʌtʌdai: ―Mʌʌcavʌr aagida ʌVuaana vʌʌsi mʌstumaa nʌidi dai caʌ. Dai aagidavurai isducatai ismaacʌdʌ mainʌnʌeeyitadai casi istutuidi isnʌaadagi dai ismaacʌdʌ maiajioopaitadai caajioopai, dai ismaacʌdʌ viaacatadai gocoocodagai ismaacʌdʌ duvaldi gatuucuga duduaadʌi, dai ismaacʌdʌ maitʌtʌʌcaidacatadai catʌtʌʌcaidaga, dai coidadʌ duduaacarʌi, dai soituutuigami vʌʌsi gʌmamaatʌtuldi ismaacʌdʌ ʌgai daidʌ ʌrcʌʌgacʌrʌ vuvaidaragai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baigʌʌliadamu sioorʌ apiagiñvaavoitudadagi ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dai aidʌsi caiji ʌgai ismaacʌdʌ ootoi ʌVuaana taidʌ ʌSuusi gʌaagacai aagidi ʌoodami dai aagai ʌVuaana dai potʌtʌdai ʌoodami: ―¿Mʌtumaasi nʌidamu aapimʌ oidigamu? ¿Mʌsbai nʌidamu aapimʌ ʌvasoi ismaacʌdʌ mosaipaco oiñidi ʌvʌʌli? ");
INSERT INTO ntpNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Mʌtumaa nʌidamu aapimʌ, ʌmo cʌʌli ismaacʌdʌ cʌʌga dadaapacami yuucustai? Aapimʌ cʌʌga maatʌ sai ismaacʌdʌ cʌʌga dadaapacami yuucustai cʌcʌʌgaducami quiiquiʌrʌ oidaga gʌgʌr raí baabaquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Mʌtumaasi nʌidamu, ʌmo Diuusi ñiooquituldiadamigadʌ? ʌjʌʌ sʌʌlicʌdʌ angʌnaagidi, daidʌ ʌrasta vaamioma isʌmo Diuusi ñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Vuaana ʌrʌgai ismaacʌdʌ aagai Diuusi ñiooquidʌrʌ dai pocaiti: “Ootosamu aanʌ ʌmo ootosicami aapi gʌbaitʌqui vai ʌgai aagidana giññiooqui ʌoodami dai poduucai ʌgai cabai gʌnducamu dai vaavoitudamu ismaacʌdʌ aagida aapi”, ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gʌnaagidiana aanʌ sai Vuaana vaamioma tʌaanʌi istomaliʌmaadutai Diuusi ñiñiooquituldiadamigadʌ dai vʌʌscatai ismaacʌdʌ gatʌaanʌda agai siaaco tʌaanʌi Diuusi vaamioma gatʌaanʌda agai isVuaana ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dai aidʌsi caʌ imaasi vʌʌsi ʌoodami ʌʌmadu ʌtumiñsi vuudami ismaacʌdʌ gʌnvapacoinaitadai ʌVuaana vacuanaragadʌcʌdʌ maatʌ tʌʌ sai istumaasi aagai Diuusi ʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dʌmos ʌfariseo ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ismaacʌdʌ maitʌnvapacoi Vuaana vacuanaragadʌcʌdʌ mosʌmaapiadʌrʌ viaa istumaasi Diuusi ipʌliditadai isiduñiagi ʌgai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Vaidʌ ʌSuusi pocaiti: ―¿Tumaasi ʌpan ducami ʌoodami sividadʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ʌpan ducami ʌaali ismaacʌdʌ plaasʌrʌ gatʌtʌʌvʌiña dai iiñoquidiña gʌnaaduñi daidʌ itʌtʌdaiña: “Iiva aatʌmʌ muusicocʌdʌ mʌtai maitatuutudai. Susuaañi aatʌmʌ mʌtai aapimʌ maisusuaañi”, astʌtʌdaiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Diviacai Vuaana ʌgai ismaacʌdʌ vapaconai ʌoodami dai maitacueeyi tascali tomali maitayʌʌyi istumaasi guvuucami, mai aapimʌ pocaiti sai viaa ʌmo Diaavora tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dai diviacai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami dai gacueeyi dai gayʌʌyi mai pocaiti ansaidʌ ʌrtuu naacʌdami daidʌ ʌriitʌracami, dai ansaidʌ ʌraduñdʌ tumiñsi vuudami dai ʌmaicʌʌga ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Vʌʌscatai ismaacʌdʌ ʌʌgidi Diuusi cʌʌ maatʌ isaliʌ cʌʌgadu Diuusi maatʌdagadʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ʌmaadutai ʌfariseo vaí ʌSuusi sai quiidiʌrʌ gaugaana taidʌ ʌSuusi ii quiidiamu dai meesa vuidʌrʌ daiva. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tai ʌmo ooqui ʌgai vaa dʌvʌʌriʌrʌ oidacami ismaacʌdʌ gogoosi gʌducamicana maí siʌSuusi ii fariseo quiidiamu dai ʌʌmadu gaugia agai. Ʌgai ami divia dai bʌʌcati ʌmo tucayu suudacami asaiti sigian uuvadami. Ʌtucayu alavastrocʌdʌ duñisi. Ʌgai ʌrodai namʌaacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dai suaaquimi daidʌ ʌSuusi ʌʌcasodʌ abaana daiva dai vacuañdimi ʌʌcasodʌ gʌoogacʌdʌ dai gooquiʌrʌ gʌcuupacʌdʌ gaqui dai usupi dai gooquiʌrʌ tʌi ʌasaiti sigian uuvaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aidʌsidʌ ʌfariseo ismaacʌdʌ vaí ʌSuusi tʌʌ imaasi povʌʌli: “Isidi cʌʌli sʌʌlicʌdʌ ʌrʌmo Diuusi ñiooquituldiadamigadʌcamudai maatʌmudai goovai ismaa ooqui goovai dai taatamai. Goovai gogoosi gʌducami”, asʌlidi ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Taidʌ ʌSuusi potʌtʌdai ʌfariseo: ―Simuñi gʌaagida iñʌlidi aanʌ ʌmo istumaasi ―astʌtʌdai. Taidʌ ʌfariseo aa noragi daidʌ itʌtʌdai: ―Giñaagidañi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Taidʌ ʌSuusi itʌtʌdai: ―Ʌmo cʌʌli tañiuuvi tumiñsi goocatai cʌcʌʌli. Ʌmaadutai tañiuuvi ʌgai taan siento daidʌ ʌgʌmai taajucan siento. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dai tomali ʌmaadutai vʌgoocatai maitistutuiditadai isaa noragidagi taidʌ ismaacʌdʌ gatañiuuvi mosoi ismaacʌdʌ vuaatulditadai ʌgai. Sivi giñaagidañi ¿ismaacʌdʌ vʌgoocatai vaamioma oigʌdai? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Taidʌ ʌSimuñi aa noragi daidʌ itʌtʌdai: ―Poʌlidi aanʌ sai ismaacʌdʌ vaamioma mui oi ―astʌtʌdai ʌfariseo. Taidʌ ʌSuusi potʌtʌdai: ―Vaavuava ismaacʌdʌ aagai aapi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Amaasi ʌSuusi vui nʌnʌaava ʌooqui dai potʌtʌdai ʌSimuñi: ―¿Nʌidipʌsi idi ooqui? Vaa aanʌ gʌquiiyʌrʌ pʌtai maitiñmaa suudagi istuucʌdʌ vacuana aanʌ giñʌʌcaso poduucai isduucai gʌrviida aatʌmʌ tai idi ooqui vapacoi giñʌʌcaso gʌoogacʌdʌ dai gʌcuupacʌdʌ gaqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dai aapi maitiñusupi poduucai isduucai gʌrviida aatʌmʌ, vai goovai aidʌsi abiaadʌrʌ vaa aanʌ maidagitocai uusupigai giñʌʌcaso. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dai aapi maitiñtʌi asaiti giñmooana poduucai isduucai gʌrviida aatʌmʌ tai goovai giñtʌi asaiti sigian uuvadami giñʌʌcasoana. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cascʌdʌ angʌaagidi sai idi ooqui tʌtʌgidi vʌʌscatai isaliʌsi iñoigʌdai aliʌsi ʌrsoimaasi iducami goovai cascʌdʌ dai vʌʌsi soimaascamigadʌ caoigʌldi. Dʌmos ʌmai oodami ismaacʌdʌ ʌrmaisi soimaasi iducami gatʌtʌgidi ismaisi iñoigʌdai maitʌrgʌpi soimaascamigadʌ cascʌdʌ dai cavʌʌsi oigʌldi ―astʌtʌdai ʌSuusi ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Amaasi potʌtʌdai ʌSuusi ʌooqui: ―Gʌsoimaascamiga caoigʌldi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Vaidʌ ʌvapaidarsicʌdʌ ismaacʌdʌ ami daraajatadai ʌʌgi aipaco gʌnaagidimi daidʌ icaiti: ―¿Sioorʌ idi cʌʌli dai asta gasoimaascamiga oigʌldi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Taidʌ ʌSuusi potʌtʌdai ʌooqui: ―Vaavoitu aapi cascʌdʌ cacʌʌgacʌrʌ vuusai, imʌʌdañi dai maivuamʌ ʌliatugada ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dai cadaivunucai imaasi ii ʌSuusi mui ʌʌmapʌcʌrʌ ami dʌvʌʌriʌrʌ dai gamamaatʌtuldimi Diuusi ñiooquidʌ dai isDiuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana. Dai vʌʌ baivustaama dan gooca mamaatʌrdamigadʌ oidatucuitadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dai oidatucuitadai ʌʌpʌ chiʌʌqui ooqui ismaacʌdʌ duduaadi ʌSuusi. Ʌʌmoco viaacatadai Diaavora tʌtʌaañicarudʌ dai aa ʌma maasi coocodagai. Dai ami ʌʌmadu imʌitadai María ismaacʌdʌ ʌrMadaliña ʌgai ooquiaiñdʌrʌ vuvaaja cuvaracami Diaavora tʌtʌaañicarudʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","dai Vuañiita ʌʌpʌ ooñigadʌ Chusa. Chusa ʌrʌmo tʌaanʌdamigadʌ Eroodʌsi pipiooñigadʌ, dai Susaana, dai mui aa ooqui ismaacʌdʌ soicʌitadai istucʌdʌ viaacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Muidutai oodami vuvaaja gʌndʌdʌʌvʌragaiñdʌrʌ dai nʌida agai ʌSuusi dai aidʌsi gʌnʌmpagi mui oodami taidʌ ʌSuusi ñiooqui daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Ʌmo ʌsaadami gaʌsimu dai gaʌsaimi ʌgai tai chiʌʌqui ʌstucadʌ voiyʌrʌ suuli mʌtai cʌjiata tai dada ujuurugi dai uu. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tai aa ʌstucai ojoodai saagida suuli dai aidʌsi vuvaaja ʌgai gaquiisa viʌʌgacatadai vaagidagai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tai aa ʌstucai uuparai saagida suuli dai vuvaaja taidʌ ʌuuparai ismaacʌdʌ ʌʌmadu vuvaaja gaquiistu. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tai aa ʌstucai cʌʌgaducami dʌvʌʌriʌrʌ suuli dai gʌʌ dai cʌʌga iibaji asta ʌmo siento litro vuvaaja aliʌmo litroaiñdʌrʌ. Dai aidʌsi capotʌi ʌSuusi gʌgʌrʌ ñioo dai potʌtʌdai: ―Mʌsaapimʌ tʌtʌcaidacagi vʌrai caʌca ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Taidʌ ʌmamaatʌrdamigadʌ tʌcacai daidʌ itʌtʌdai: ―Tʌiya ʌlidi aapi idi cuentocʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Taidʌ ʌSuusi potʌtʌdai: ―Aapimʌ Diuusi gʌnmaatʌtuldamu istumaasi maimaatʌ aapimʌ isducatai Diuusi soicʌi oodami sai cʌʌga gʌntʌtʌgitocana, dʌmos gogaa poduucai ñiooquidi aanʌ vai nʌijada goovai dai ducami ismaiñʌijadagi dai caʌca dai ducami ismaicaʌcagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Gʌnaagidamu aanʌ istʌiya ʌlidi gocuento: ―Goʌstucai ʌpan ducami Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Goʌstucai ismaacʌdʌ voiyʌrʌ suuli ʌgai ʌpan ducami ʌoodami ismaacʌdʌ caʌcana Diuusi ñiooquidʌ vai didivai ʌDiaavora dai maigovai dadasai ibʌadʌaiñdʌrʌ sai maivaavoitudaiña dai maicʌʌgacʌrʌ vuvaacʌna. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Daidʌ ʌstucai ismaacʌdʌ ojoodai saagida suuli ʌgai ʌpan ducami ʌoodami ismaacʌdʌ caʌcana Diuusi ñiooquidʌ dai cʌʌga baigʌnʌliaracʌdʌ ʌʌgidiña dʌmos maisi guupuacana ʌgai vaavoidaragadʌ. Vaavoitudaiña ʌgai chiʌʌqui tasai dai siʌʌscadʌ parunadagi aa vai cadadagitoiña gʌnvaavoidaraga. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Daidʌ ʌstucai ismaacʌdʌ uuparai saagida suuli ʌgai ʌpan ducami ʌoodami ismaacʌdʌ caʌcana Diuusi ñiooquidʌ dai maiʌʌgidiña momaasi gʌtʌgitocana dai gaquiistudai gʌnvaavoidaraga mosʌʌ tʌgitocatai tumiñsiʌrʌ dai gʌnvagimadagʌrʌ dai mui aa naana maasiʌrʌ dai poduucai maitivueeyi ʌgai istumaasi Diuusi ipʌlidi dai ʌpan ducami ʌstucai ismaacʌdʌ maiiibiatai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Daidʌ ʌstucai ismaacʌdʌ cʌʌgaducami dʌvʌʌriʌrʌ suuli ʌgai ʌrʌoodami ismaacʌdʌ baigʌnʌliaracʌdʌ caʌca ʌlidiña Diuusi ñiooquidʌ dai vʌʌsi ʌʌgidiña istumaasi mamaatʌrʌi Diuusi ñiooquidʌrʌ dai ʌgai ismaacʌdʌ apiavaavoitudai dai mamaatʌtuldi aa ʌgai ismaacʌdʌ vʌtʌmʌ mamaatʌrʌi ʌgai ʌgai daidʌ ʌriibiadʌ gʌnducami. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tomali ʌmo oodami maicucuudagʌi ʌmo cuudacarui dai gooquiʌrʌ iiñapai tomali maivoicarui uta dadasai, baiyoma tʌcavi dadasai vai cuudagidaca ʌgai vʌʌscatai sioorʌ vapacʌdagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Poduucai istumaasi aanʌ gamamaatʌtuldi vʌʌsi gʌmaasiuldi, sivi maiquiaa cʌʌga maatʌ caʌ ʌoodami gooquiʌrioma gia vʌʌsi maatʌ caʌcamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Poduucai tudu cʌʌgavʌr caʌca. Sioorʌ bʌʌjʌi giññiooqui dai giñʌʌgidi ʌgai vaamioma maatʌtuldamu aanʌ, dai sioorʌ maibʌʌjʌi giññiooqui dai maitiñʌʌgidi poopoidamu aanʌ istumaasi maatʌ gʌʌlidi ʌgai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amaasi ʌSuusi dʌʌdʌ ʌʌmadu susuuculidʌ ami dada siaaco daacatadai ʌgai dʌmos maitistutuiditadai ʌgai ismiaadʌrʌ ajiagi aliʌ muiducatai oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tai ʌmaadutai aagidi ʌSuusi daidʌ itʌtʌdai: ―Gʌdaada ʌʌmadu gʌsusuuculi quiidigaiñdʌrʌ guuca dai gʌnʌida ʌlidi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dʌmos ʌSuusi potʌtʌdai: ―Sioorʌ caʌcagi Diuusi ñiooquidʌ dai ʌʌgiditai caʌcagi ʌgiava ʌgai daidʌ ʌrgiñdaada ducami ʌʌmadu giñsusuuculi ducami ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ʌmo imidagai tʌsai ʌSuusi ʌmo vaarcuʌrʌ ʌʌmadu gʌmamaatʌrdamiga daidʌ itʌtʌdai ʌgai: ―Tiimʌda vaasadʌrʌ gogʌʌ suudagi ―astʌtʌdai ʌSuusi. Tai bodʌrʌ iji. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dai aidʌsi gʌʌ suudagi ʌraana iimʌitadai ʌgai taidʌ ʌSuusi coí. Tai todian duucai cavami ʌvʌ vai taí tʌʌsadʌi suudagi daidʌ ʌvaarcu casuudaimi suudagi dai asta cayoga duupi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tai ʌgai iji dai nʌnʌitu ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, Mamaatʌldiadami, casiatʌ yooga duudupi ―astʌtʌdai. Taidʌ ʌSuusi vañi dai ʌʌpitu ʌʌvʌʌli ʌʌmadu ʌsuudagi tai vʌʌsi gʌʌʌpitu dai vʌʌsi dodoli vii. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Amaasi ʌSuusi potʌtʌdai gʌmamaatʌrdamiga: ―¿Tʌdui gʌnvaavoidaraga? ―astʌtʌdai. Vai ʌgai duduaadimucatadai dai maitʌʌ istumaasi gʌntʌtʌgituagi dai aipaco gʌntʌcacai daidʌ icaiti: ―¿Sioorʌ idi cʌʌli dai tʌaanʌi ʌvʌʌli ʌʌmadu gosuudagi vai ʌʌgidi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Daida aayi ali quiiyʌrʌ. Gadarʌrʌ tʌʌgidu ali quii. Vaasadʌrʌ ʌgʌʌ suudagi ʌrGadara ajaadʌrʌ ʌrGalilea. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mostuvanʌcai ʌSuusi dʌvʌʌrapi tai miaadʌrʌ cʌquiva ʌmo cʌʌli Gadarana oidaacami dai catʌvʌpi ʌpʌduitadai isʌcʌʌli viaacatadai Diaavora tʌtʌaañicarudʌ dai maitʌaadaiña yuucusi tomali maioidacatadai quiiyʌrʌ mosʌcaasi siaaco gʌyaasapai coidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dai mostʌʌgacai ʌgai ʌSuusi vuidʌrʌ gʌtootonacʌdʌ cʌquiva dai iiñaquimi dai potʌtʌdai: ―¿Tuipʌsidʌ giñʌʌmadu vapaacʌi aapi Suusi ʌgʌʌ baitʌcʌaacami maradʌ? Gʌdaanʌi aanʌ pai maitiñoiñiada ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pocaiti ʌgai tʌaanʌitai ʌSuusi ʌDiaavora tʌtʌaañicarudʌ sai vuvaacʌna ʌgiaiñdʌrʌ. Muiyoco imidagai bʌbʌʌjʌiña ʌDiaavora tʌtʌaañicarudʌ vaidʌ ʌoodami vupuuraiña noonovidʌ dai ʌʌcasodʌ cadeenacʌdʌ sai maiuupanʌna vai ʌgai ʌʌquitudaiña ʌcadeena. Daidʌ ʌDiaavora tʌtʌaañicarudʌ mosmʌmʌlitudaiña ʌgai oidigamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Tʌʌgidu aapi? ―astʌtʌdai. Tai ʌgai aa noragi dai potʌtʌdai: ―Legión antʌʌgidu aanʌ ―ascaiti. Poduucai aagai ʌgai aliʌ muiducatai ʌDiaavora tʌtʌaañicarudʌ ismaacʌdʌ ʌgiʌrʌ vaapa cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Daidʌ ʌDiaavora tʌtʌaañicarudʌ potʌtʌdai ʌSuusi sai maiootosana siaaco tuucavaga ami siaaco oidaga vʌʌsi ʌDiaavora tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dai muiducatadai tataisoli ami giidiʌrʌ daida cueeyitadai. Daidʌ ʌDiaavora tʌtʌaañicarudʌ potʌtʌdai ʌSuusi sai dagitona isvaapaquiagi ʌtataisoliʌrʌ. Taidʌ ʌSuusi maa oigaragai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Taidʌ ʌDiaavora tʌtʌaañicarudʌ vuvaaja ʌcʌʌliaiñdʌrʌ dai tataisoliʌrʌ vaapa. Tai vʌʌsi ʌgai gʌʌ vaapavuana sʌʌli suuli gaamu taana dai gʌʌ suudarʌ suuli dai baicoi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tai ʌgai ismaacʌdʌ nuucadacatadai ʌtataisoli aliʌ duduaadimu aidʌsi tʌʌ imaasi dai voopoi dai mʌʌca gaaagidi quiiquiana dai dʌjiana. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Taidʌ ʌoodami vʌʌscatai iji dai nʌida agai astumaasi ʌpʌdui dai aidʌsi aayi ʌgai siaaco daacatadai ʌSuusi tʌʌ ʌgai ʌcʌʌli ismaacʌdʌaiñdʌrʌ vuvaaja ʌDiaavora tʌtʌaañicarudʌ vai ʌʌcasodʌ abaana daacatadai ʌgai ʌSuusi cʌʌga yuucusu dai cacʌʌga dodoli daja tai ʌgai aliʌ duduaadimu. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Daidʌ ʌtataisoli nuucadacami ismaacʌdʌ nʌiditadai aagidi vʌʌsi isducatai dueeyi ʌcʌʌli ismaacʌdʌ viaacatadai ʌDiaavora tʌtʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Imaasicʌdʌ vʌʌsi ʌoodami ami Gadarʌrʌ oidacami gʌnaaga daañimi ʌSuusi sai imʌʌna abiaadʌrʌ aliʌ duduaadicuitadai ʌgai cascʌdʌ. Taidʌ ʌSuusi tʌsai vaarcuʌrʌ dai ii abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Daidʌ ʌcʌʌli ismaacʌdʌiñdʌrʌ vuvaaja ʌDiaavora tʌtʌaañicarudʌ goguaama oí sai dagitona isoidagi dʌmos ʌSuusi potʌtʌdai sai viʌʌna dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Noragiñi gʌquiiyamu dai mʌʌca gaaagida vʌʌsi istumaasi idui Diuusi aapicʌdʌ ―astʌtʌdai. Taidʌ ʌcʌʌli nora dai mʌʌca gaaagidi vʌʌsi ami dʌvʌʌriʌrʌ siʌ cʌʌga idui ʌSuusi ʌgai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aidʌsidʌ ʌSuusi vaasadʌrʌ divia ʌpamu ʌgʌʌ suudagi tai vʌʌscatai baigʌnʌliaracʌdʌ miaadʌgi canʌnʌracatadai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tai ami divia ʌmo cʌʌli Jairo tʌʌgiducami ʌgai ʌrtʌaanʌdamicatadai quiuupaigadʌrʌ judidíu dai gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ dai daañimi sai imʌʌna quiidiamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ali ʌmaaduacatadai ʌgai maradʌ daidʌ ʌrooqui parʌ baivustaama dan gooca uumigi viaacatadai dai cayoga muutadai. Dai imʌcai ʌSuusi oí mui oodami dai asta gʌisatudaimi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dai ʌgai saagida imʌitadai ʌmo ooqui ismaacʌdʌ cabaivustaama dan gooca uumigi coococatadai gʌʌʌracʌdʌ dai casiaa doodai vʌʌsi istumaasi viaacatadai duduaadigamiʌrʌ vai tomali ʌmaadutai maitistutuiditadai isduaaidagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tai ʌgai miaadʌrʌ cʌquiva ʌSuusi dai gooquiamadʌrʌ mostaata yuucusidʌ taidʌ ʌʌradʌ gʌʌʌpitu. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Vaidʌ ʌSuusi gatʌcacaimi daidʌ icaitimi: ―¿Toorʌ giñtaata? ―ascaiti ʌSuusi. Vai vʌʌscatai pocaiti sai tomali ʌmaadutai vaidʌ Piiduru ʌʌmadu ʌaaduñdʌ potʌtʌdai: ―Mamaatʌtuldiadami, mosʌʌquidu oodami dai gʌgʌgʌisatudai dai aipaco gʌnuituscʌi paidʌ gatʌcacai soorʌ gʌtaata ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dʌmos ʌSuusi potʌi: ―Ʌmaadutai atgiñtaata, maiyanta aanʌ iñsiduaadi ʌmaadutai giñguvucadacʌdʌ ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dai mostʌʌgacai ʌooqui iscamaasico vuaa ʌSuusi divia dai gigivuquimi dai gʌtootonacʌdʌ cʌquiva vuidʌrʌ ʌSuusi dai vʌʌsi oodami vuitapi aagidi istuisi taata dai isducatai caduaadicami vii mostaatacai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Amaasi ʌSuusi potʌtʌdai: ―Giñaduñi vaavoitu aapi cascʌdʌ cadueeyi. Imʌʌdañi dai maivuamʌ ʌliatugada ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Dai quiaa ñioocaitadai ʌSuusi tai divia ʌmaadutai Jairo quiidiaiñdʌrʌ dai potʌtʌdai ʌgai ʌJairo: ―Casiatmuu gʌmara casi maisoi vuaada gomamaatʌtuldiadami ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dʌmos aidʌsi caʌ ʌSuusi potʌtʌdai: ―Maitiduaadicuda mosai giñvaavoituda sigʌmara duaadimu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dai aidʌsi aayi ʌSuusi quiiyʌrʌ maidagito ʌgai ʌoodami isvaapaquiagi ʌʌmadu tuucavi mosʌcaa Piiduru dai Jacovo dai Vuaana ʌʌmadu ʌali ooqui dʌʌdʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vʌʌscatai suaanʌitadai dai aliʌ soigʌnʌliditadai ʌali ooquicʌdʌ dʌmos ʌSuusi potʌtʌdai: ―Maitavʌr suaanʌda goali ooqui maitʌrmuuquiadʌ mosacooso ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dʌmos ʌoodami mosparunai pocaititai ʌSuusi. Ʌoodami maatʌcatadai isiʌrmuuquiadʌ ʌgai cascʌdʌ parunai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Taidʌ ʌSuusi bʌi novidʌ dai gʌgʌrʌ ñioo dai potʌtʌdai: ―Ali ooqui vañigiñi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tai ʌgai ʌpamu duaaca dai otoma vañi taidʌ ʌSuusi gatʌjai mʌsai biidana. ");
INSERT INTO ntpNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Daidʌ ʌdʌʌdʌdʌ maitʌtʌgaitadai istumaasi gʌntʌtʌgituagi. Dʌmos ʌSuusi potʌtʌdai sai maiaagidiña tomali ʌmaadutai istumaasi ʌpʌdui. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ɅSuusi ʌmapagi ʌbaivustaama dan gooca gʌmamaatʌrdamiga dai maa guvucadagai dai sʌʌlicami sai vuvaidiña vʌʌsi Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ dai sai duduaaididana gacoocodaga. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dai Suusi ootoi ʌgai sai gaaagidana sai Diuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana dai duduaaididana coococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dai potʌtʌdai: ―Maitavʌr vuucai tomali ʌmo istumaasi voiyʌrʌ vʌʌtarʌ tomali gʌngiica tomali gʌnmoraaliga tomali biitugai tomali tumiñsi dai mosaliʌʌmoco vaapasaragai avʌr gʌnaadatica maisiu googoca. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tomastuma quiiyʌrʌ mʌsiaaco gʌnuuliñagi anaasiavʌr gʌnuuliñaca asta mʌsiʌʌscadʌ iji ʌgai dʌvʌʌriaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dai mʌsiaaco maitʌnmiaadʌgidagi vʌrai vuvaaqui abiaadʌrʌ dai gigigida ʌdʌvʌʌrai gʌnʌʌcasoaiñdʌrʌ vai poduucai maatʌna ʌgai ismaicʌʌga idui ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tai iji ʌgai dai mosʌʌmapʌcʌrʌ iimʌi dai gaaagidimi Diuusi ñiooquidʌ dai duduaaidimi coococoidadʌ vʌʌsi aipacoga. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Taidʌ ʌtʌaanʌdami Eroodʌsi maí vʌʌsi istumaasi ivuaadatadai ʌSuusi dai maitʌtʌgaitadai istumaasi gʌtʌgituagi. Dai ʌʌmoco pocaititadai saidʌ ʌVuaana duaaca coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dai aa pocaititadai saidʌ ʌrʌEliiasicaru Diuusi ñiooquituldiadamigadʌ daidʌ maasitu. Dai aa pocaititadai saidʌ ʌrʌmoco ʌʌquidʌ Diuusi ñiooquituldiadamigadʌ dai duaaca. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dʌmos ʌEroodʌsi pocaiti: ―Aanʌ ʌʌgi antgatʌjai guicutaragai moodʌ ʌVuaana ¿dai idio sioorʌ ismaacʌdʌ mosʌʌ naana maasi caʌ aanʌ aatagi? ―ascaiti ʌEroodʌsi. Daidʌ ʌEroodʌsi gʌaajagʌi isnʌidagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dai aidʌsi dada ʌSuusi ojootosadʌ aagidi ʌgai ʌSuusi vʌʌsi istumaasi idui. Taidʌ ʌSuusi vaidacai ʌmaapʌcʌrʌ siaaco baitoma maitiipu oidacami Betasaidamacoga. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dai aidʌsi maí ʌoodami isii ʌSuusi gooquiʌrʌ iji taidʌ ʌSuusi miaadʌgi dai aagidi sai Diuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana daidʌ ʌSuusi duduaadi ʌcoococoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dai aidʌsi cauruñimi ʌbaivustaama dan gooca mamaatʌrdami miaadʌrʌ guuquiva dai potʌtʌdai ʌgai ʌSuusi: ―Ootosañi gooodami vai gʌniibʌstana dai gaagana cuaadagai aali quiiquiana siaaco vaamioma miaagacagi. Tami siaaco daraaja aatʌmʌ maitiipu tomali istumaasi ―astʌtʌdai ʌmamaatʌrdami. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Taidʌ ʌSuusi potʌtʌdai: ―Bibidavurai aapimʌ ―astʌtʌdai. Taidʌ ʌmamaatʌrdamigadʌ aa noragi daidʌ itʌtʌdai: ―Maitatʌviaa vaamioma mosaltaama paana dai gooca vatopa. Siʌgisgiaa mʌʌca savʌʌda aatʌmʌ cuaadagai vʌʌsi idi oodami vʌʌtarʌ ―astʌtʌdai ʌmamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Daidʌ ʌoodami parʌ taama miil aʌcatadai. Dʌmos ʌSuusi potʌtʌdai gʌmamaatʌrdamiga: ―Aagidavurai gooodami sai daraivana chiichiʌquiatai aipacoga parʌ taataucami siento ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tai podui vʌʌscatai daraiva. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Taidʌ ʌSuusi vui ʌtaama paana daidʌ ʌgooca vatopa dai tʌvaagiamu nʌnʌaava dai gamamagi dai gooquiʌrʌ saasarai ʌpaana dai ʌvatopa dai maa gʌmamaatʌrdamiga sai taacoidana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tai vʌʌscatai gauu dai tataascovai dai gooquiʌrʌ suusudagi baivustaama dan gooca aasarai saasaquigadʌ ismaacʌdʌ baivito. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ʌmo imidagai aidʌsi ʌcovai daanʌitadai Diuusi ʌSuusi vaidʌ ʌmamaatʌrdamigadʌ ʌʌmadu daraajatadai taidʌ ʌSuusi tʌcacai gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―¿Voorʌ giñaagai ʌoodami? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tai ʌgai itʌtʌdai: ―Ʌʌmoco pocaiti pʌsaidʌ ʌrʌVuaana ʌgai ismaacʌdʌ vapaconaiña ʌoodami, dai aa pocaiti pʌsaidʌ ʌrEliiasi, dai aa pocaiti pʌsaidʌ ʌrʌʌquidʌ Diuusi ñiooquituldiadamigadʌ dai duaaca ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Taidʌ ʌSuusi potʌtʌdai: ―¿Dai aapimʌo mʌcaiti ansoorʌ aanʌ? ―astʌtʌdai. Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Aapiapʌ ʌrDiuusi Cristogadʌ ismaacʌdʌ ʌgai ʌcovai vuusaitu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dʌmos ʌSuusi sʌʌlicʌdʌ daí sai maiaagidiña imaasi tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dai potʌtʌdai: ―Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami viaacamu issʌʌlicʌdʌ soimaa taatagi dai mosʌmapiadʌrʌ giñviaamu ʌtʌtʌaanʌdamigadʌ judidíu ʌʌmadu baitʌguucacamigadʌ papaali ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Dai giñmuaaa magai vʌʌsi dai vʌʌsʌcʌrʌ bo vaica tasaicʌdʌ ʌpamu duaacamu aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dai gooquiʌrʌ potʌtʌdai vʌʌscatai: ―Sioorʌ giñʌʌgiada ʌliada maitʌaagai isʌʌgi gʌtʌgitocagi dai vʌʌs tasai gʌaagai isbai gʌducagi siʌduñiada gʌmuaatuda giñvaavoitudaitai daida giñʌʌgiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sioorʌ ivuaadagi ʌʌgi istumaasi ipʌlidi, ʌgai gia imimu Diaavora ʌʌmadu, dʌmos ʌgai ismaacʌdʌ bai gʌduu dai muquiagi giñvaavoitudaitai ʌgai gia cʌʌgacʌrʌ vuusaimu. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tumaasi ʌrcʌʌgai ʌmo oodami vʌʌtarʌ isgamaitʌagi vʌʌsi istumaasi oidaga oidigi daama vai ibʌadʌ imiagi Diaavora ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami tʌvaagiaiñdʌrʌ divia dai ʌpamu noragia iñagai dai gooquiʌrʌ ʌpamu divimu aanʌ ʌʌmadu mui Diuusi tʌtʌaañicarudʌ. Dai giñooga dadadaquigadʌ gʌrsicoli dadadaquida agai. Isʌmaadutai siaa ʌradagi giñvaavoitudaitai aanʌ ʌʌpʌ siaa ʌrogiadamu amaasi iñsiʌʌscadʌ diviagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ismaacʌdʌ gʌnaagidi aanʌ ʌrvaavoi sai oidaga ʌmaadutai ismaacʌdʌ tami guuca sai maicoiya agai asta tʌʌgacai ismaasi siaaco tʌaanʌi Diuusi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dai aidʌsi potʌi ʌSuusi bo mamacova tasaicʌdʌ tʌsai ʌmo giidiʌrʌ dai gamamada agai dai ʌʌmadu iimʌitadai Piiduru dai Jacovo dai Vuaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dai aidʌsi daanʌitadai Diuusi ʌSuusi vuivasadʌ ʌmapʌdui dai yuucusidʌ cʌʌga tootuatu dai dadadacʌdami gʌnaato. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tai gʌmaasitu gooca cʌcʌʌli abaana ʌSuusi dai ʌʌmadu gaaatagitadai ʌgai ʌrMoseesacaru ʌʌmadu Eliiasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Dai sicolimadi ʌmo cuudagi dadadacʌdami dai aagaitadai issoimaa taata agai ʌSuusi dai isducatai muquia agai Jerusaleenʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tomasi ʌPiiduru ʌʌmadu ʌaaduñdʌ aliʌ coocosimucatadai vʌʌscʌrʌ maicoocoi dai tʌʌ isducatai dadadacʌi ʌSuusi sicoli dai vʌgoocai cʌcʌʌli ismaacʌdʌ ʌʌmadu guucacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dai aidʌsidʌ ʌcʌcʌʌli mʌʌcasioma iimimitadai ʌSuusi sonuaiñdʌrʌ taidʌ ʌPiiduru potʌtʌdai ʌSuusi: ―Mamaatʌtuldiadami, vʌʌsi ʌrcʌʌgai istami daraaja aatʌmʌ tʌtai duuñi vaica uucusai ʌmoco aapi gʌvʌʌtarʌ dai ʌmai Moseesa vʌʌtarʌ dai ʌmai Eliiasi vʌʌtarʌ ―astʌtʌdai. Dʌmos ʌPiiduru maimaatʌcatadai iscaititadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dai quiaa ñioocaitadai ʌgai tai divia ʌmo icomai dai iiña vʌʌscatai tai ʌgai aliʌ duduaadimu tʌʌgacai isicomai saagida iji ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tai icomiaiñdʌrʌ caidatu ʌmo ñiooqui ismaacʌdʌ icaiti: ―Idiavʌr giñmara dai aanʌ aliʌ oigʌdai. Ʌʌgiadavurai aapimʌ ―ascaiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dai aidʌsi capotʌi ʌñiooqui ʌgai gʌntʌgito tʌʌ sidʌ ʌSuusi caʌʌgi cʌacatadai. Dai vʌvaicai mamaatʌrdamigadʌ maiaagidi tomali ʌmaadutai tomali ʌmo ñiooqui istumaasi tʌʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dai siaadiqui aidʌsi tʌaapai ʌgai giidiaiñdʌrʌ tai mui oodami vuvaaja dai vuidʌrʌ aayi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tai ʌmo cʌʌli ʌoodami saagida gʌgʌrʌ ñiooqui daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, giñoigʌdañi dai nʌida giñmara, idi caʌmaduga giñmara cʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vai ʌmo Diaavora tʌaañicarudʌ bʌbʌjʌi dai iiñaquitudai dai susuiquituldi dai totosacatudai tʌñidʌ dai soi vueeyi dai maidagitua ʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Casiant goguama oí gʌmamaatʌrdamiga sai vuusaidana ʌgai goDiaavora tʌaañicarudʌ dʌmos ʌgai maitistui ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tai aa noragi ʌSuusi dai potʌtʌdai: ―Dañi aapimʌ sivi oidacami maivaavoidaracami dai maiʌʌgidaracami siʌʌ tʌvʌpi vaamioma viaacamu aanʌ isgʌnʌʌmadu daacagi dai gʌnnʌijadagi ―astʌtʌdai ʌSuusi. Dai potʌtʌdai ʌgai ʌoogadʌ: ―Baigovai vuaapa gʌmara ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dʌmos aidʌsi ʌali gʌʌli miaadʌrʌ cʌquiva taidʌ ʌDiaavora tʌaañicarudʌ dʌvʌʌrapi daitu dai suiquituli. Dʌmos ʌSuusi dodoligitu ʌDiaavora tʌaañicarudʌ dai duaadi ʌali gʌʌli dai tʌʌgi oogadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tai vʌʌscatai maitʌʌ istumaasi gʌntʌtʌʌgituagi tʌʌgacai istumaasi mosʌʌ gʌducami ismaacʌdʌ idui Diuusi. Dai maiquiaa tʌtʌgaitadai ʌgai istumaasi gʌntʌtʌʌgituagi gomaasicʌdʌ ismaacʌdʌ idui ʌSuusi tai ʌgai potʌtʌdai gʌmamaatʌrdamiga: ");
INSERT INTO ntpNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Cʌʌgavʌr caʌca idi dai mostʌgitoca. Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami mʌgiñtʌʌgida agai aa oodami ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dʌmos ʌmamaatʌrdamigadʌ maimaatʌ caʌcatadai istumaasi aagidi ʌgai, maimaaquiarsicatadai ʌgai oigaragai ismaatʌ cajiagi cascʌdʌ, dai ʌgai duduaadicuitadai isaagidagi sai cʌʌga aagidana isducatai maatʌ cajiagi ʌgai istumaasi aagaitadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Vaidʌ ʌSuusi mamaatʌrdamigadʌ ʌʌgi gʌnaatagidi dai pocaiti sai sioorʌ ʌgiaiñdʌrʌ cʌʌgadu isvaamioma gatʌaanʌdagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dʌmos ʌSuusi maí istumaasi gʌntʌtʌʌgitoitadai ʌgai dai bʌi ʌmo ali oodami dai gʌabaana cʌi ");
INSERT INTO ntpNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","dai potʌtʌdai: ―Tomasioorʌ ismaacʌdʌ vaavoitudai giñmamaatʌtuldiaraga dai cascʌdʌ oigʌdai idi ali oodami ʌgai giñoigʌdai aanʌ ʌʌpʌ dai ʌgai ismaacʌdʌ giñoigʌdai aanʌ ʌgai oigʌdai ʌgai ismaacʌdʌ giñootoi. Ismaacʌdʌ poʌlidi ismaisi gatʌaanʌi ʌgai vaa ʌgai dai vaamioma gatʌaanʌi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Taidʌ ʌVuaana potʌtʌdai: ―Mamaatʌtuldiadami, tʌʌ aatʌmʌ ʌmoco ismaacʌdʌ potʌi sai gʌguvucadacʌdʌ vuvaiditadai Diaavora tʌtʌaañicarudʌ tʌtai daí sai camaivuvaidiña maitʌrʌʌmadu aimʌraitai ʌgai ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dʌmos ʌSuusi potʌtʌdai: ―Maitavʌr daidiada. Ismaacʌdʌ maitʌrvui caatʌ ʌgai gʌrʌpa maasi tʌtʌgitoi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aidʌsi camiaadimi istuigaco tʌsadia agaitadai ʌSuusi tʌvaagiamu ʌgai pocaiti: ―Aanʌ angia imia iñagai Jerusaleenamu ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dai baitʌqui ootoi ojootosicami tai ʌgai iji ʌmo ʌmapʌcʌrʌ Samaalia dai gaagida agai siaaco gʌuuliñagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dʌmos ʌSamaaliʌrʌ oidacʌdʌ maitipʌli ismiaanai daasagi maatʌcai isJerusaleenamaco imʌitadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aidʌsidʌ ʌmamaatʌrdamigadʌ ʌSuusi Jacovo ʌʌmadu Vuaana tʌʌ imaasi potʌtʌdai ʌgai ʌSuusi: ―Mamaatʌtuldiadami, ¿ipʌlidipʌsi tʌsgatañiagi taí tʌvaagiaiñdʌrʌ dai vʌʌsi ugititudagi gooodami poduucai isduucai idui Eliiasicaru Diuusi ñiooquituldiadamigadʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Taidʌ ʌSuusi vui nʌnʌaava dai bagaimi dai potʌtʌdai: ―Aapimʌ maimaatʌ ismaasi gʌniibʌdaga. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami maidiviacai cooda iñagai oodami baiyoma moscʌʌgacʌrʌ vuvaida iñagai aanʌ ―astʌtʌdai ʌSuusi. Dai amaasi iji sibʌaacoga. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dai aidʌsi voiyʌrʌ iimʌitadai ʌgai tai ʌmo cʌʌli potʌtʌdai ʌSuusi: ―Mamaatʌtuldiadami, gʌoidatucuda iñʌlidi aanʌ vʌʌsi pʌsiaaco aimʌrdagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Cacaasiocai viaa gʌntʌʌtʌjoga vaidʌ ʌujuurugi gʌncoocosa, dʌmos aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami maiviaa tomali siaaco mootagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Daidʌ ʌSuusi potʌtʌdai ʌmai cʌʌli: ―Giñoidañi ―astʌtʌdai. Dʌmos ʌcʌʌli potʌtʌdai: ―Mamaatʌtuldiadami, giñdagitoñi quiaa ʌʌpʌga anmʌʌ yaasagi giñooca ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dʌmos ʌSuusi aa noragi daidʌ itʌtʌdai: ―Dagitoñi vai ʌgai ismaacʌdʌ ʌpan ducami coidadʌ maiʌʌgiditai Diuusi yaasana gʌncoidadʌga, dai aapi imi dai gaaagida sai Diuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tai ʌmai cʌʌli potʌtʌdai: ―Mamaatʌtuldiadami, gʌoida iñʌlidi aanʌ dʌmos giñdagitoñi quiaa nai mʌʌ diosagidagi giñaaduñi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dʌmos ʌSuusi itʌtʌdai: ―Sioorʌ gasicuandagi dai aa nʌʌjidagi maisʌʌli sicuanai, poduucai ʌʌpʌ ʌgai ismaacʌdʌ giñoidatucuda ʌliada dai otoma imia ʌlidi gʌquiiyamu ʌgai maitʌrcʌʌga aata vuaadami Diuusi aa duiñdadʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dai cadaivunucai imaasi taidʌ ʌSuusi ʌcovai vuvaitu ʌʌpʌ vaic coobai dan baivustaama oodami dai mosgoogocatai baitʌqui ootoi vʌʌsi ʌʌmapʌcʌrʌ siaaco viaacatadai ʌgai isimiagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dai potʌtʌdai: ―Mʌsiaaco iimia agai aapimʌ mui oodami cabaigʌnduuduna iibʌadʌ dai caʌca agai Diuusi ñiooquidʌ ʌpan duucai gʌpi ʌsicami ismaacʌdʌ casi gʌaagai yoovaragai. Dai Diuusi ñiñiooquituldiadamigadʌ chiʌʌquidu cascʌdʌ daanʌdavurai aapimʌ Diuusi ismaacʌdʌ ʌrʌpan ducami ʌʌsʌcami vai ootosana aa gʌñiñiooquituldiadamiga ismaacʌdʌ ʌrʌpan ducami pipiooñi vai aagida ʌgai ñiooquidʌ ʌoodami ismaacʌdʌ baigʌnduuduna iibʌadʌ ʌgai ʌpan ducami ʌsicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Iimivurai aapimʌ. Dañi aanʌ ʌpan duucai gʌnootosai cañiiru sʌʌsʌyi saagida. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Maitavʌr vuucai gʌnmoraraaliga tomali gʌntumiñsi daraasacaru tomali aa susuusacai, dai maitavʌr guguquida voiyʌrʌ mʌsiaaco ajiagi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mʌsiʌʌscadʌ ajiagi ʌmo quiiyʌrʌ vʌrai aagida ʌoidacami sai Diuusi ipʌlidi isiibʌstudacan tadacagi ʌgai iibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dai isami daacagi ʌmaadutai dai nʌnʌracagi isDiuusi soiñagi vai gʌiibʌstacan tadaca ʌgai ibʌadʌ aidʌ gia gʌiibʌstacan tadacamu ʌgai. Dai ismaitiipucagi tomali ʌmaadutai ami isnʌnʌracagi isDiuusi soiñagi vai gʌiibʌstacan tadacagi ʌgai vʌʌscʌrʌ aapimʌ gʌaagai isaagididagi gomaasi aa oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dai anaasi mʌsiaaco cʌʌga gʌnmiaadʌgidagi ʌgai vaa quiiyʌrʌ avʌr gʌnuuliña dai ugaavurai dai ii istumaasi viaacagi ʌgai, ʌmo piooñi viaa sʌʌlicami mʌsaa namʌquidagi. Dai maitavʌr mosquiiquiʌrʌ ajioopada. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dai mʌsiʌʌscadʌ ajiagi ʌmapʌcʌrʌ mʌsicʌʌga gʌnmiaadʌgidagi ugaavurai mʌstumaasi gʌnbiidagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dai duduaaidavurai ʌcoococoidadʌ ismaacʌdʌ ami oidacagi dai poviavʌr tʌʌda ʌoidacami: “Cadivia Diuusi dai gʌnʌʌmadu daaca agai daidʌ ipʌlidi isgʌnsoiñagi mai cʌʌgacʌrʌ oidaca aapimʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dai mʌsajiagi ʌmapʌcʌrʌ mʌsiaaco maitʌnmiaadʌgidagi vʌrai vuvaqui caayʌrʌ dai potʌʌda: ");
INSERT INTO ntpNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Asta dʌvʌʌragadʌ gʌnoidaga ismaacʌdʌ gʌrʌʌcasuana saí gigigidamu aatʌmʌ vʌrai poduucai maatʌca aapimʌ mʌsmaicʌʌga idui. Dʌmos maatʌcavurai sicayooga aayi siʌʌscadʌ gatʌaanʌda agai Diuusi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dai quiaa ñioocai ʌSuusi dai potʌtʌdai: ―Aanʌ angʌnaagidi sai siʌʌscadʌ Diuusi nʌidagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami ʌgai soimaasi taatatulda agai ʌoodami ismaacʌdʌ maitʌnmiaadʌgidagi vaamioma soimaasi taatatuldamu ʌgai siʌ Sodoomʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aapimʌ Corasiiñiʌrʌ oidacami dai Betasaidʌrʌ oidacami siʌ soimaa taatamu aapimʌ. IsTiiroʌrʌ dai Sidooniʌrʌ oidacami tʌʌgimudai istumaasi gʌgʌrducami mʌsmaasi tʌʌ aapimʌ ʌgai gia caʌʌqui abiaadʌrʌ gʌnaadadamudai yuucusi tutucucami dai gʌncocoomaivadamudai mataicʌdʌ dai poduucai maasiuldamudai iscaʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dʌmos siʌʌscadʌ Diuusi nʌidagi ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami gʌngʌʌgʌvituldaraga vaamioma soimaascamu isʌTiiroʌrʌ dai Sidooniʌrʌ oidacami vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dai aapimʌ Capernauumʌrʌ oidacami. ¿Povai mʌsiʌnʌlidi mʌstʌvaagiʌrʌ ucami tʌʌtʌidia agai? Baiyoma mʌtʌapañia agai dʌvʌʌrai utamacoga ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dai potʌtʌdai ʌgai gʌmamaatʌrdamiga: ―Ismaacʌdʌ ʌʌgiditai gʌncaʌ aapimʌ ʌgai giñʌʌgiditai caʌ aanʌ ʌʌpʌ dai ismaacʌdʌ gajiaadʌrʌ gʌnvipieeyi aapimʌ ʌgai gajiaadʌrʌ giñvipieeyi aanʌ ʌʌpʌ dai ismaacʌdʌ gajiaadʌrʌ giñvipieeyi aanʌ ʌgai gajiaadʌrʌ vipieeyi ʌʌpʌ ʌgai ismaacʌdʌ giñootoi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Taidʌ ʌvaic coobai dan baivustaama ʌpamu dadacai baigʌnʌliatugai dai potʌtʌdai ʌgai ʌSuusi: ―Mamaatʌtuldiadami, asta Diaavora tʌtʌaañicarudʌ vʌʌsi gʌrʌʌgi aagaitai aatʌmʌ gʌtʌʌtʌaraga ―astʌtʌdai ʌojootosicami ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Taidʌ ʌSuusi potʌtʌdai: ―Aanʌ annʌidi isducatai gʌi ʌDiaavora tʌvaagiaiñdʌrʌ ʌpan duucai ʌmo siitañi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aanʌ angʌnmaa guvucadagai aapimʌ mʌsai cʌcʌisapaiña gʌgʌr coocoyi dai nanacasʌrai dai poduucai vaamioma viaa aapimʌ guvucadagai isgʌrsaayu Diaavora. Dai aapimʌ maisoimaa taatamai tomali ʌmo istumaasicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Maitavʌr baigʌnʌliada cascʌdʌ gʌnʌʌgiditai Diaavora tʌtʌaañicarudʌ. Baiyoma mosgʌaagai mʌsbaigʌnʌliadagi oojisicatai gʌntʌʌtʌaraga mʌʌ tʌvaagiʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aidʌ otoma baiʌliatu Diuusi Ibʌadʌ ʌSuusi tai ʌgai potʌtʌdai: ―Giñooca aanʌ gia sʌʌlicʌdʌ siaa gʌduutudai, aapiapʌ ʌrbaitʌcʌaacami tʌvaagiʌrʌ dai oidigi daama. Aapi apʌtmaimaatʌtuli idi maasi ʌsastudugami tomali ʌgai ismaacʌdʌ naana maasi mamaatʌrʌi mosʌca ʌgai ismaacʌdʌ maisi sastuduga dai ismaacʌdʌ mainaana maasi mamaatʌrʌi. Cʌʌgaduava giñooca poduucai ipʌli aapi dai poduucai idui ―astʌtʌdai ʌSuusi gʌooga. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dai apiamamaatʌtuldi ʌSuusi ʌoodami dai potʌtʌdai: ―Giñooca giñmaa vʌʌsiaʌcatai. Aanʌ ʌrDiuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ dai tomali ʌmaadutai maicʌʌga giñmaatʌ mosʌca giñooca dai tomali ʌmaadutai maicʌʌga maatʌ giñooca mosʌca aanʌ ismaacʌdʌ ʌrmaradʌ ʌgai. Dai vʌʌscʌrʌ oidaga aa ismaacʌdʌ maatʌ giñooca mosʌca ismaacʌdʌ aanʌ ipʌlidi sai maatʌna. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Amaasi ʌgai vui nʌnʌava gʌmamaatʌrdamiga dai ʌʌgi ʌgai potʌtʌdai: ―Baigʌnʌlidi aapimʌ nʌiditai mʌstumaa nʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aanʌ angʌnaagidi sai mui Diuusi ñiñiooquituldiadamigadʌ ʌʌmadu mui raraí nʌida ʌliditadai mʌstumaasi aapimʌ nʌidi dai maitʌʌ, dai ʌgai caʌca ʌliditadai mʌstumaasi aapimʌ caʌ dai maicaʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Amaasi ʌmo mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ cʌquiva dai ii dai mʌʌ aatagida agai ʌSuusi. Mosnʌida ʌliditadai ʌgai sabai aagana Suusi ʌmo istumaasi istumaasi vui caatʌcagi ʌvaavoidaragadʌ dai potʌtʌdai: ―Mamaatʌtuldiadami, ¿tumaasi istutuidi aanʌ isiduñiagi dai vʌʌscʌrʌ ʌʌmadu daacagi Diuusi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―¿Tumaasi ʌgai dai oojisi sʌʌlicamiʌrʌ? Aapi nʌnʌidiña oojai vʌʌs tasai giñaagidañi iscaiti ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Taidʌ ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ aa noragi daidʌ itʌtʌdai: ―“Oigʌadañi gʌDiuusiga vʌʌsi gʌiibʌdacʌdʌ, dai vʌʌsi gʌguvucadacʌdʌ dai vʌʌsi gʌtʌgitoidacʌdʌ, dai oigʌadañi gʌaaduñi poduucai pʌsduucai gʌoigʌdai aapi ʌʌgi” ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Taidʌ ʌSuusi itʌtʌdai: ―Cʌʌga pʌtgiñaa noragi isvʌʌsi gomaasi iduñia aapi, aapi vʌʌscʌrʌ oidacamu Diuusi ʌʌmadu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Vaidʌ ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌgi gʌsoiña ʌliditadai dai potʌtʌdai ʌgai ʌSuusi: ―¿Voorʌ ʌrgiñaaduñi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌmo imidagai ʌmo cʌʌli tʌvañimitadai ʌmo voi Jerusaleenaiñdʌrʌ Jericooamu tai voiyʌrʌ aayi ʌʌsivogami dai baitoma gʌviji dai ʌʌsi istumaasi vuucaticatadai ʌgai asta yuucusidʌ dai sʌʌlicʌdʌ soidoodai dai baitoma muuquiadʌ viaa dai iji. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dai aidʌpʌcʌ amui imʌitadai ʌmo paaligadʌ judidíu ʌgai vaa voiyʌrʌ dai tʌʌgacai mossʌʌli daivusai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dai ʌmo leviita ʌʌpʌ amui sʌʌli daivusai dai aidʌsi tʌʌ ʌgai mosdaivusai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Dai ʌmai cʌʌli Samaaliaiñdʌrʌ ʌgai vaa voiyamu imʌitadai dai tʌʌgacai soigʌʌldian taada. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dai miaadʌrʌ cʌquiva siaaco caatʌcatadai ʌcʌʌli dai duaadi istuidana saasaquicatadai asaiticʌdʌ dai valieenticʌdʌ, dai vipiosolicʌdʌ vuupuli dai ʌʌgi gʌsoiga daama daí dai bʌʌcai ʌmo quiiyamu dai ami gʌuuli ʌʌmadu dai nuucagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dai siaadiqui aidʌsi caimia agaitadai ʌSamaaliʌrʌ oidacami vuuvaitu goo piisu dai maa ʌoidacami dai potʌtʌdai: “Nuucadacañi idi cʌʌli dai pʌsvaamioma siaa duadagi gʌaa namʌʌquidamu aanʌ iñsiʌʌscadʌ ʌpamu diviagi”, astʌtʌdai ʌSamaaliʌrʌ oidacʌdʌ ʌoidacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dai sivi maacʌdʌ idi vʌvaicai cʌcʌʌli ʌraduñdʌ ʌcʌʌli ismaacʌdʌ baitoma gʌviji ʌʌsivogami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Taidʌ ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ itʌi: ―Ʌgai ismaacʌdʌ soigʌʌli tʌʌgacai ―astʌtʌdai. Taidʌ ʌSuusi potʌtʌdai: ―Imiñi aapi dai poduuñi ʌʌpʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dai apiaimʌi ʌSuusi dai aayi ʌmaapʌcʌrʌ. Vai ami oidacatadai ʌmo ooqui Maaruta tʌʌgiducami dai miaadʌgi gʌquiiyʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Daidʌ ʌMaaruta siʌgʌcatadai ʌmai ooqui María tʌʌgiducami. Tai ʌgai vuidʌrʌ daiva ʌSuusi dai caʌca agai istumaasi aagaitadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dʌmos ʌMaaruta aliʌsi istumaa vuaadatadai cusiñiʌrʌ dai miaadʌrʌ cʌquiva siaaco daacatadai ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, ¿maitapʌsvuamʌ ʌlidi tomalaachi isgiñsiisi ʌʌgi giñvidagi mosʌʌsi aa duiñdagai? Aagidañi tudu vaidʌ giñsoiñana ―astʌtʌdai ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Maaruta, Maaruta, maitivuamʌ ʌliada aapi mosʌʌ naana maasicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mosaliʌmo istumaasi oidaga ismaacʌdʌ vaamioma gʌaagai dai goMaría gia bʌi cʌʌgaducʌdioma aa duiñdagai dai tomali ʌmaadutai maivoopoidamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ʌmo imidagai ʌSuusi gamamadaitadai ʌmo ʌmaapʌcʌrʌ. Dai aidʌsi canaato mamagi ʌgai tai ʌmaadutai ʌmamaatʌrdamigadʌ itʌtʌdai: ―Mamaatʌtuldiadami, gʌrmaatʌtuldañi mamadaragai poduucai isduucai ʌVuaana maatʌtuli gʌmamaatʌrdamiga ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Taidʌ ʌSuusi potʌtʌdai: ―Mʌsiʌʌscadʌ gamamadadagi vʌrai aduucai gamamadada: Gʌrooga aapi pʌsmaacʌdʌ tʌvaagiʌrʌ daja, aatʌmʌ ipʌlidi isʌoodami gʌsiaa duutuadagi, dai maatʌna isaapi maisoimaasi ivueeyi vai otoma aʌna istuigaco gatʌaanʌda agai aapi tami oidigi daama vaidʌ ʌpʌduuna pʌstumaasi aapi ipʌlidi tanai oidigi daama ʌpan duucai tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gʌrsoiñañi tʌtai viaaca aatʌmʌ cuaadagai siʌʌsi tʌgito sivi vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dai gʌroigʌldañi vʌʌsi gʌrsoimaascamiga aatʌmʌ ʌʌpʌ oigʌldi vʌʌscatai ismaacʌdʌ soimaasi gʌrvuiididi. Maiti dagito isʌDiaavora gʌraagiadan tadacagi isiduñia aatʌmʌ soimaasi poduucai vʌrgamamadada. Astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Daidʌ ʌSuusi potʌtʌdai ʌʌpʌ: ―Ducami isʌmaadutai aapimʌ viaacagi ʌmoco gʌnaduñi pai aapi imiagi quiidiamu ʌrantucarʌ pai potʌʌda aapi: “Giñaduñi giñtañiuvidañi vaica tascali, ");
INSERT INTO ntpNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","utudama giñdiviji ʌmoco giñaduñi mʌʌcasdʌrʌ imʌʌdami dai aanʌ maiviaa istumaasi biidagi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dai ducami siʌgʌmai aa gʌnoragidagi tuucavidʌrʌ dai povʌtʌʌdagi: “Maitigiññiooquiada casia cuupi quitaagiña dai giñmaamara giñʌʌmadu vʌʌtʌ giñvaacosiʌrʌ nai cascʌdʌ maitistutuidi aanʌ isvañigʌcai gʌmaquiagi tomali ʌmo istumaasi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aanʌ angʌnaagidi tomasi maivañigʌcai gʌmaa ʌgai istumaasi gʌaduñicatai baiyoma vañigian taada ʌgai dai gʌmaquiagi vʌʌsi istumaasi tʌgitoca aapi maicaʌca ʌliditai ñioocadami. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Cascʌdʌ aanʌ angʌnaagidi mʌsai daanʌiña Diuusi sai gʌnsoicʌiña mai viaaca aapimʌ tʌgitocagi dai gʌaagai mʌscʌʌga vaavoitudadagi sai Diuusi gʌnsoicʌda agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sioorʌ daanʌdagi Diuusi sai soicʌiña gia soicʌiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ʌmaadutai aapimʌ ismaacʌdʌ ʌrgaooga ¿mʌsbai oidana aapimʌ gʌnmara ʌmo odai isgʌntaanʌda ʌgai paana? ¿Siʌpʌ oidagi ʌmo cooyi isgʌntaanʌda ʌgai vatopa? ");
INSERT INTO ntpNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Isgʌntaanʌda ʌgai ʌmo tacunono isbai oidana aapimʌ ʌmo nacasʌrai? ");
INSERT INTO ntpNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʌsaapimʌ ismaacʌdʌ maicʌʌ tuutuiga maatʌ oidi gʌnmaamara istumaasi cʌʌgaducami siooma cʌʌga gʌnooga ismaacʌdʌ tʌvaagiʌrʌ daja gʌnootosdamu gʌIbʌdaga vai gʌnʌʌmadu daacana vʌʌscatai sioorʌ ipʌliadagi isʌʌmadu daaca ʌgai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ɅSuusi vusaasditadai ʌmo cʌʌliaiñdʌrʌ ʌmo Diaavora tʌaañicarudʌ. ɅDiaavora tʌaañicarudʌ muudutu ʌcʌʌli. Dai aidʌsi vuusai ʌDiaavora tʌaañicarudʌ taidʌ ismaacʌdʌ muudutu istui isñiooquiagi ʌpamu. Taidʌ ʌoodami maitʌʌ isducatai gʌntʌtʌgituagi tʌʌgacai imaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dʌmos ʌʌmoco pocaiti: ―Idi cʌʌli vuvaidi Diaavora tʌtʌaañicarudʌ Beelsevú guvucadadʌcʌdʌ ―ascaiti ʌoodami. Beelsevú ʌrDiaavora dai aliʌ guvuca. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dai aa mosnʌijada ʌlidi astumaa duuna ʌSuusi dai cascʌdʌ potʌtʌdai sai tʌʌgidana ʌmo istumaasi gʌducami tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dʌmos ʌSuusi maatʌcatadai istumaasi gʌntʌtʌgitoitadai ʌgai dai potʌtʌdai: ―Isaipaco gʌncocodagi ʌmapʌcʌrʌ oidacami ugitimu ʌoodami dai baabaquidʌ suuligimu. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Poduucai ʌʌpʌ isʌDiaavora ʌʌgi gʌcocodagi otoma camaitatʌaanʌdan tada ʌgai cascʌdʌ poduucai gʌnaagidi aanʌ pocaititai aapimʌ ansai aanʌ vuvaidi Diaavora tʌtʌaañicarudʌ Beelsevú guvucadadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Siʌrvaavoicamudai isDiaavora guvucadadʌcʌdʌ vuvaidi aanʌ Diaavora tʌtʌaañicarudʌ aidʌ gia aapimʌ gʌnaaduñi vuvaidi Diaavora tʌtʌaañicarudʌ Diaavora guvucadadʌcʌdʌ ʌʌpʌ. Ʌʌgi ʌgai gʌnaagidamu ismaitʌrvaavoi isDiaavora guvucadadʌcʌdʌ vuvaidi aanʌ ʌʌmadu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Baiyoma Diuusi guvucadadʌcʌdʌ vuvaidi aanʌ Diaavora tʌtʌaañicarudʌ dai poduucai cʌʌ maatʌ aapimʌ iscaaayi istuigaco Diuusi soicʌda agai oodami sai cʌʌgacʌrʌ oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Siʌʌscadʌ ʌmo oodami guvuacami dai cʌʌga gagatocami nuucadacagi gʌquii dai vʌʌsi istumaasi oidaga ami poduucai maitiipu sioorʌ gaʌʌsidagi ami. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dʌmos isdiviagi ʌmai vaamioma guvuacami dai vaamioma istuidiagi dai ʌʌsidagi vʌʌsi gagatodʌ istuucʌdʌ gʌtʌgitocatadai ʌgai isgʌsoiñagi dai gataacogida ʌgai vʌʌsi istumaasi gaʌʌsidagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sioorʌ maitʌrgiñʌʌmaducagi ʌgai giñvuidʌrʌ caatʌ sioorʌ maitiñsoiña aagiadagi ʌoodami isducatai cʌʌgacʌrʌ vuvaqui ʌgai sobicʌi sai maivaavoitudana dai maicʌʌgacʌrʌ vuvaacʌna. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Siʌʌscadʌ ʌmo Diaavora tʌaañicarudʌ vusiagi ʌmo cʌʌliaiñdʌrʌ oidigana aimʌraiña dai gaagaiña siaaco gʌibʌʌstagi dai siʌʌscadʌ maitʌgia ʌgai siaacoga povʌ ʌʌlidiña: “Ʌpamu animiagi giñquiiyamu iñsiaadʌrʌ vuusai”, asʌʌlidiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dai siʌʌscadʌ ʌpamu ami diviagi ʌgai dai tʌtʌʌgaiña ʌcʌʌli ʌpan duucai ʌmo quii cʌʌga voisiquicami dai cʌʌga bai duñisicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dai amaasi ʌgai aimʌrai dai vuaapai ʌʌpʌ cuvaracami Diaavora tʌtʌaañicarudʌ. Dai ʌgai ʌʌmadu vʌʌsi ʌgaa vapacʌiña ami cʌʌliʌrʌ dai ami oidacana dai poduucai ʌcʌʌli vaamioma soi gʌvuaadana isvaasʌquioma ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Aidʌsidʌ ʌSuusi aagaitadai imaasi, tai ʌmo ooqui oodami saagida iiña dai pocaiti: ―Siʌ cʌʌgacʌrʌ nʌidi Diuusi ʌgai ismaacʌdʌ gʌmarai dai gʌsiitu ―astʌtʌdai ʌooqui ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dʌmos ʌSuusi potʌtʌdai: ―Ʌcaasi cʌʌgacʌrʌ nʌidi ʌgai ʌʌpʌ vʌʌsi oodami ismaacʌdʌ caʌ Diuusi ñiooquidʌ dai ʌʌgiditai caʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Daidʌ ʌoodami apiagʌnʌmpaidimi ami ʌSuusi sicoli taidʌ ʌSuusi gʌaagacai mamaatʌtuldimi Diuusi ñiooquidʌ dai potʌtʌdai: ―Oodami sivi oidacami aliʌ maicʌʌga tuutuiga dai giñaagidi ansaidʌ iduuna ʌmo istumaasi gʌducami ʌgai vuitapi, dʌmos maitʌʌgimu ʌgai ʌmai istumaasi gʌducami mosʌcaasi ʌistumaasi gʌducʌdʌ ismaacʌdʌ idui Diuusi ootosacai Joonasi Ñiñiviamu vai ʌgai aagidi ʌoidacami sai ugitia agai ʌgai ismaiʌma duucai gʌntʌtʌgituagi dai camaisoimaasi ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Poduucai ʌʌpʌ giñootoi Diuusi. Aanʌ ʌrʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami dai aagidamu aanʌ sivi oidacami sai ugitia agai ʌʌpʌ ismaiʌma duucai gʌntʌtʌgituagi dai camaisoimaasi ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Siʌʌscadʌ caaiyagi istuigaco Diuusi nʌidagi oodami sividadʌ ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami, daidʌ ʌooqui ismaacʌdʌ ʌrbaitʌcʌaacamicatadai Siipʌrʌ divimu dai gʌpiʌrʌ suuligamu ʌoodami sivi oidacami. Ʌgai sʌʌlicʌdʌ mʌʌcasdʌrʌ divia dai caʌca agai istumaasi aagai ʌSalomoñi. Ʌgai ʌrʌmo tʌaanʌdami saitudugami dai tami daja aanʌ sivi dai vaamioma ʌrtʌaanʌdami aanʌ siSalomoñi mai aapimʌ maitiñʌʌgiditai caʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ismaacʌdʌ Ñiñiviʌrʌ oidacatadai dadimu siʌʌscadʌ Diuusi nʌida agadagi sivi oidacami ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami, daidʌ ʌÑiñiviʌrʌ oidacami gʌpiʌrʌ suuligamu ʌoodami sivi oidacami ʌʌpʌ mai aapimʌ maitiñʌʌgiditai caʌ ʌgai gia caʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada agai aidʌsi ʌJoonasicaru aagidi Diuusi ñiooquidʌ, dai tami daja aanʌ dai vaamioma ʌrtʌaanʌdami aanʌ siJoonasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tomali ʌmaadutai cucuudagʌi ʌmo cuudacarui dai gooquiʌrʌ ʌstoquicʌrʌ dadasai tomali ʌmo cajooñi uta baiyoma tʌcavacamiʌrʌ gʌdadasai vai sioorʌ vapacʌdagi istutiadagi isnʌaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gavuupuji ʌrʌpan ducami ʌmo cuudacarui gatuucuga vʌʌtarʌ isgʌvuupuji cʌcʌʌgaducagi vʌʌsi gʌtuucuga ʌʌpʌ viaa cuudagi, dai isgʌvuupuji maicʌcʌʌgaducagi gʌtuucuga ʌʌpʌ ducami istucagamucagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Goovai ismaacʌdʌ maatʌ aapimʌ Diuusicʌdʌ ʌpan ducami ʌmo cuudagi gʌntʌgitoidagʌrʌ gʌnnuucadacavurai aapimʌ vai maituucuna dai poduucai tucapi viimu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iscʌʌga cuudagʌcagi vʌʌsi gʌntʌgitoidagʌrʌ dai maitiipucagi tomalaachi tucapi dai poduucai cʌʌga maatʌ caʌcamu aapimʌ ʌpan duucai mʌsduucai nʌidi ʌmo tuucavi siaaco cʌʌga cuudagʌcagi ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dai aidʌsi cadagito ñioo ʌSuusi tai ʌmo fariseo vaí sai quiidiʌrʌ gaugana. Taidʌ ʌSuusi ii dai meesa vuidʌrʌ daiva. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Taidʌ ʌfariseo maitʌʌ istumaasi gʌtʌgituagi tʌʌgacai siʌSuusi maivacoi gʌnoonovi isducatai viituli Moseesacaru ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tai amaasi ʌSuusi potʌtʌdai: ―Aapimʌ fariseo vuaanai gʌnajaasocoli ʌʌbʌadʌrʌ dʌmos aapimʌ tuculimadai gʌnʌranaga muuquimudagaicʌdʌ dai soimaascamicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Vupuiiruga aapimʌ, ¿maitamʌs maatʌ tʌtʌgitoi maitamʌs maatʌ sai sioorʌ idui ʌʌbʌadʌrʌ idui ʌʌpʌ ʌraviadʌrʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gaoidiadavurai oidicami baigʌnʌliaracʌdʌ dai poduucai maitʌrsoimaasi iducamicamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Siʌ soimaa taatamu aapimʌ fariseo vʌʌsi istumaasi viaa aapimʌ aa oidi oodami Diuusi aa duiñdadʌ vʌʌtarʌ, asta ivaagi mʌsmaacʌdʌ bʌʌjʌi. Cʌʌgadu isoidiada aapimʌ oodami Diuusi aa duiñdadʌ vʌʌtarʌ mʌstumaasi viaacagi dʌmos aliʌ soi duucai nʌidi aapimʌ gʌnaaduñi dai maioigʌdai Diuusi gomaasi gia maicʌʌgadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Siʌ soimaa taatamu aapimʌ fariseo. Oojoidi aapimʌ iscʌcʌʌgaducʌdioma daraicariʌrʌ dadaarʌdagi judidíu quiquiuupaigadʌrʌ dai oojoidi aapimʌ isvʌʌsi oodami siaa gʌnduutuadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Siʌ soimaa taatamu aapimʌ fariseo dai aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Aagai aapimʌ ʌmo istumaasi dai ʌma maasi ivueeyi. Aapimʌ ʌrʌpan ducami siaaco gʌyaasapai coidadʌ dai camaimaatʌgia maasi daamadʌrʌ vaidʌ ʌoodami daama dʌgavuscʌiña maimaatʌcatai siʌ sigalnaasi uta, pomaasi aapimʌ ʌraviadʌrʌ ʌʌpʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tai ʌʌmoco ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ aa noragi dai potʌtʌdai: ―Mamaatʌtuldiadami, aagaitai aapi imaasi asta aatʌmʌ vʌʌsi gʌrñiooquidi ―astʌtʌdai ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dʌmos ʌSuusi potʌtʌdai: ―Siʌ soimaa taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌpʌ. Aapimʌ pocaiti sai gʌaagai siduñiagi mui naana maasi istumaasi maiaagai Moseesacaru. Ducami isvaamioma cucuspiada aapimʌ asta siʌʌsi uucami maitistutuidi ʌoodami dai aapimʌ maicucuspʌi tomalaachi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Siʌ soimaa taatamu aapimʌ. Aapimʌ ivuiididi baabaquidʌ Diuusi ñiñiooquituldiadamigadʌ ismaacʌdʌ coi gʌnʌʌqui aaduñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cʌʌga maatʌ aapimʌ vʌʌsi gomaasi dai soicʌdʌ mʌnʌlidi aapimʌ gʌnaaduñicaru. Ʌgai coi Diuusi ñiñiooquituldiadamigadʌ mai aapimʌ ivuiididi baabaquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Cascʌdʌ Diuusi ismaacʌdʌ maatʌ vʌʌsiaʌcatai pocaiti: “Gʌnootosdamu aanʌ giñiñiooquituldiadamiga ʌʌmadu giñojootosa mʌsiaapimʌ coodamu ʌʌmoco dai aa soimaa taatatuldamu”, ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Diuusi soimaasi gʌntaatatulda agai aapimʌ sivi oidacami vʌʌsicʌdʌ ʌñiñiooquituldiadamigadʌ ismaacʌdʌ gʌncooditu aidʌsi abiaadʌrʌ cʌquiva gooidigi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aidʌsi abiaadʌrʌ gʌmuaatu Aveelicaru asta aidʌsidʌ gʌmuaatu Zacariiasicaru ʌgai ismaacʌdʌ gʌmuaatu ʌgʌʌ quiuupai abaana vai ajadʌrʌ cʌʌca ʌooroñi mʌsiaaco mʌmʌidiña vustaaqui isducatai gatʌjai Diuusi. Sʌʌlicʌdʌ angʌnaagidi sai Diuusi gʌpiʌrʌ gʌnsuuliga agai aapimʌ sivi oidacami ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Siʌ soimaa taatamu aapimʌ mamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Ducami iscuupaca aapimʌ candaadocʌdʌ siaaco oidaga Diuusi mamaatʌtuldaragadʌ, dai aapimʌ viaa yaavigadʌ dai maivapacʌi aapimʌ dai tomali maidadagitoi aa isvaapaquiagi tomasi vaapaquia ʌlidi ʌgai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aidʌsi aagidi ʌSuusi imaasi taidʌ ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo aliʌ baacoi ʌgai vui dai gʌnaagacai tʌcacaimi mui naana maasi, ");
INSERT INTO ntpNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sabai aagana ʌgai ʌmo istumaasi vaavoidaragadʌ vui vai poduucai gʌpiʌrʌ vuaaja ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tai amaasi mui miil oodami gʌnʌmpagi sʌʌlicʌdʌ muidu dai asta gʌncʌcʌisapai aipacoga. Taidʌ ʌSuusi gʌaagacai aagidi ʌʌpʌga gʌmamaatʌrdamiga dai potʌtʌdai: ―Cʌʌgavʌr gʌntʌtʌgitoca aapimʌ. Maitavʌr ʌpan duucai ivuaada gofariseo. Goovai aagai ʌmo istumaasi dai ʌma maasi ivueeyi vai aa nʌidiña dai poduucai ivuaada ʌlidiña ʌʌpʌ dʌmos aapimʌ maitʌaagai ispoduucai ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Maioidaga tomali ʌmo istumaasi ʌstoquicami tomasi duudusali gʌaagai vʌʌscʌrʌ vʌʌsi gʌmamaatʌi, dai maioidaga tomali ʌmo istumaasi ʌstoquicami ismaitʌmaasiuldagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Vʌʌsi mʌsmaacʌdʌ aagai aapimʌ tucarʌ vʌʌsi gomaasi gʌcaʌcamu tasʌrʌ, dai mʌsmaacʌdʌ duudusali aagai aapimʌ cuupacatai quitaagiña goovai vʌʌsi iiñacaitai gʌaagadamu baabaqui daamadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Aapimʌ giñaaduñi angʌnaagidi sai maitʌaagai mʌsʌʌbiadagi ʌgai ismaacʌdʌ mumueeyi gatuucuga, dai gooquiʌrʌ ʌgai camaitistutuidi isiduñiagi vaamioma. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dʌmos gʌnaagidamu aanʌ sioorʌ gia gʌaagai mʌsʌʌbiadagi. Ʌʌbiadavurai ʌgai ismaacʌdʌ viaa guvucadagai isbʌʌquiagi muuquiadʌ ibʌadʌ Diaavor ʌʌmadu. Ʌjʌ, ʌgai gia gʌaagai mʌsʌʌbiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Diuusi vaamioma gʌnoigʌdai aapimʌ siʌ ujuurugi cascʌdʌ maitavʌr duduaadicuda cʌʌ maatʌ aapimʌ isgʌgaagarai taama ujuurugi gooca sintaavucʌdʌ vai Diuusi vʌʌscʌrʌ nuucadacana. Diuusi maatʌ vʌʌsiaʌcatai asta siʌʌjʌquidu ʌʌmadutai cuupadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gʌnaagidiana sai vʌʌscatai ismaacʌdʌ gʌnmaasiuldi oodami vuitapi isgiñvaavoitudai aanʌ ʌʌpʌ ismaacʌdʌ viaa ʌmo sʌʌlicami maiʌstocadamu Diuusi tʌtʌaañicarudʌ vuitapi mosaagamu aanʌ isʌgai ʌrgiñmaamara. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dai ismaacʌdʌ giñʌstocadagi oodami vuitapi aanʌ ʌʌpʌ ʌstocadamu ʌgai Diuusi tʌtʌaañicarudʌ vuitapi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dai tomasioorʌ ismaacʌdʌ giñvui ñioocadagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami istutuidi isoigʌldagi. Dʌmos sioorʌ soimaasi ñiooqui aagadagi Diuusi Ibʌadʌ vui ʌgai gia maiviaa gʌoigʌldaraga. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mʌsiʌʌscadʌ vaama gʌntuutusa agadagi ʌmo quiuupaigadʌrʌ judidíu siʌʌpʌ baitʌguucacami dai aa sʌʌlicami viaacami vuidʌrʌ, maitavʌr vuamʌ ʌnʌliada Diuusi Ibʌadʌ gʌnsoiñamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mʌsiuu duucu caviaacagi isñiooquiagi mʌsducatai gaaa noragidagi dai mʌstʌiyagi ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tai ʌmaadutai ʌoodami saagidaiñdʌrʌ potʌtʌdai ʌSuusi: ―Mamaatʌtuldiadami, aagidañi giñsiisi tʌtaidʌ ʌrtaacoida aatʌmʌ gʌrvustuidaga ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dʌmos ʌSuusi potʌtʌdai: ―Giñaduñi, ¿toorʌ giñdaí aanʌ dunucami duucai siʌʌpʌ taacogiadami aapimʌ gʌnvʌʌtarʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dai potʌtʌdai ʌʌpʌ: ―Dañi gʌnnuucadacavurai dai maicoimudadʌ tuutiaca tomasi naana maasi viaa ʌmo oodami maimosʌca ʌgaicʌdʌ duaaca ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dai amaasi aagidi ʌSuusi ʌmo ñiooqui ʌoodami cuentocʌdʌ dai potʌtʌdai: ―Oidacatadai ʌmo cʌʌli riicuacami, daidʌ ʌʌsidʌ sʌʌlicʌdʌ cʌʌga gʌduitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Vaidʌ ʌriicu gʌtʌtʌgitoi dai povʌʌlidi: “Istumaa duuñimu aanʌ maiviaa aanʌ siaaco baituagi giñyoova”. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Daida povʌʌli: “Casian maatʌ istumaa duñiagi. Suuligamu aanʌ gotroojo daidʌ iduuñimu aa gʌgʌrducamioma dai ami baituamu aanʌ vʌʌsi giñyoova dai vʌʌsi iñstumaa viaa. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dai amaasi povaiñtʌʌdamu aanʌ”, ascaiti ʌriicu. “Mui naana maasi apʌviaa baidarajami mui uumigi vʌʌtarʌ sivi gia gʌibʌstañi gacuaadañi dai baigʌliada”, ascaiti ʌriicu. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dʌmos Diuusi potʌtʌdai: “Vuiirugami aapi idi vaa tucarʌ pʌmuquia agai dai vʌʌsi istumaasi viaa aapi, ¿sioorʌ vʌʌtarʌ viimu goovai?” astʌtʌdai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ʌʌgi poduucai ʌpʌvueeyi ʌoodamicʌdʌ isʌmpaidiadagi mui naana maasi ʌʌgi gʌvʌʌtarʌ ʌgai mossoitigamiʌrʌ vipiʌʌyi Diuusi vuitapi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dai gooquiʌrʌ potʌtʌdai ʌSuusi gʌmamaatʌrdamiga: ―Gʌnaagidiana maitavʌr vuamʌ ʌnʌliada cuaadagaicʌdʌ mʌsmaacʌdʌ ugia agai dai oidaca agai, tomali yuucusicʌdʌ mʌsmaacʌdʌ gʌnaada agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gaibʌdaga vaamioma gʌaagai sicuaadagai, dai gatuucuga vaamioma gʌaagai siyuucusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gʌntʌgitovʌr nʌida coocoñiʌrʌ, ʌgai maitaʌsai tomali maitayoovai tomali maiviaa gʌntroojoga, dʌmos Diuusi ʌgai dai maacai cuaadagai. Sʌʌlicʌdʌ vaamioma namʌʌga aapimʌ siujuurugi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Dai voorʌ aapimʌ tomasiʌʌsi naana maasi gʌntʌtʌgitoi istutuidimʌsi istaajucami metro vaamioma gʌntʌcavaldagi? ");
INSERT INTO ntpNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mʌsmaitistutuidi isiduñiagi istumaasi maisijaiga maitavʌr vuamʌ ʌnʌliada ʌma maasicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gʌntʌgitovʌr nʌida yoosigiʌrʌ ducatai gʌʌrai maitaaata vuaadatai tomali maitaiilutaitai, dai vʌʌscʌrʌ gʌnaagidi aanʌ sai tomali ʌraí Salomoñi ismaacʌdʌ viaacatadai yuucusi cʌcʌʌgaducami vʌʌscʌrʌ maiʌpa maasi gʌai goyoosigai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gʌntʌgitovʌr nʌida yoosigiʌrʌ ʌmo imidagai oidigana guucacana dai siaadiqui mʌicana, vai vʌʌscʌrʌ Diuusi sigia maasi yuucustudai, vʌʌsi vaamioma gʌnyuucustudana ʌgai aapimʌ tomasi maicʌʌga vaavoitudai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Cascʌdʌ avʌr maivuamʌ ʌnʌliada gaagaitai istumaasi ugiagi dai istumaasi iiyagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vʌʌsi ʌoodami oidigi daama oidacami mosʌca gomaasiʌrʌ gʌntʌtʌgitoiña, dʌmos aapimʌ viaa ʌmoco gʌnooga ismaacʌdʌ camaatʌ istʌgito aapimʌ vʌʌsi gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Baiyomavʌr ipʌliada aapimʌ sai Diuusi gʌnsoicʌiña vai cʌʌgacʌrʌ oidaca aapimʌ siDiuusi gʌnsoicʌdamu siviaacamu aapimʌ istumaasi tʌgitocagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Maitavʌr duduaadicuda aapimʌ ʌrʌpan ducami giñsosoiga cañiiru dai chiʌʌquidu aapimʌ. Dai aliʌ baigʌʌlidi Diuusi gʌnmaacacai oigaragai isgatʌaanʌda aapimʌ siaaco tʌaanʌi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gaagardavurai aapimʌ mʌstumaa viaa dai oidiada soituutuigami poduucai ivuaadamu aapimʌ Diuusi aa duiñdadʌ vai gʌntumiñsiga maisiaa gʌvueeyi dai poduucai ʌʌpʌ bai darasaidamu aapimʌ gʌnvustuidaga tʌvaagiʌrʌ siaaco maiuugiatʌi dai siaaco maivapacʌi ʌʌsivogami tomali vatopadagai isugiugagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ami siaaco ʌmpaidiada aapimʌ gʌnvustuidaga mosami gʌntʌgitocana. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Aanʌ imia iñagai tʌvaagiamu ʌmo imidagai dai ʌpamu divimu aanʌ. Baigavʌr ʌnduuca dai giñnʌnʌraca. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ʌpan duucai ʌpipiooñi nʌnʌracana gʌnaamu isdiviagi ʌmo cunataragiaiñdʌrʌ vai cupioquidagi ʌgai quitaagiña mosaʌcai ʌgai dai quitaagiña ñiooquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Siʌʌ baigʌnʌliadamu ʌpipiooñi ismaacʌdʌ maicoocosʌcagi aʌcai aamudʌ. Sʌʌlicʌdʌ angʌnaagidi sai ʌʌgi gaaamu bai gʌduuñimu dai meesa vuidʌrʌ daraasamu gʌpipiooñiga dai bibidamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tomasi ʌran tucarʌ divia ʌgai siʌpʌ sialimadʌ, siʌʌ baigʌnʌliadamu ʌpipiooñi ismaacʌdʌ nʌaadagi vai diviagi ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dai maatʌcavurai aapimʌ idi ʌʌpʌ ―ascaiti ʌSuusi―. Ducami isʌmo oidacami ʌmo quiiyʌrʌ ismaatʌcagi isiuu duucu ami quiidiʌrʌ divia agadagi ʌmo ʌʌsivogami maicosian tada ʌgai nuucadacatai sai maivaacʌna quiidiʌrʌ dai ʌʌsidana. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Poduucai ʌʌpʌ aapimʌ gʌaagai mʌsbai gʌnducagi siuu duucu aapimʌ siooma maitʌgitocagi divimu aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tai amaasi ʌPiiduru tʌcacai dai potʌtʌdai: ―Mamaatʌtuldiadami, ¿voorʌ vʌʌtarʌ aagai aapi idi cuento mosʌca aatʌmʌ vʌʌscatai sio? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Taidʌ ʌSuusi itʌi: ―Ʌmoco gaaamu vʌʌscʌrʌ gaagaiña ʌmoco ʌʌgidaracami dai saituduacami saidʌ ʌrtʌaanʌdamigadʌcana pipiooñigadʌ dai bibidiña siuu duucu gʌaagadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Baigʌʌliadamu ʌtʌaanʌdami ismaacʌdʌ ivueeyi vʌʌsi cʌʌga siuu duucu diviagi ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sʌʌlicʌdʌ angʌnaagidi saidʌ ʌaamudʌ tʌaanʌdami duucai vituldamu vʌʌsi istumaasi viaaca ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dʌmos siʌpiooñi ismaacʌdʌ tʌaanʌdami duucai viaagi ʌaamudʌ povʌʌldagi siʌaamudʌ maiotoma divia agai, dai gʌaagacai soi vuaadagi ʌgaa pipiooñi ʌʌmadu ʌcusñiñiru dai ʌgai gacuaadagi dai gayʌʌdagi dai navamuagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Dai poduucai ʌaamudʌ divimu siuu ducuu ʌpiooñigadʌ siooma mainʌnʌracagi, dai siuu duucu ʌgai maimaatʌcagi dai sʌʌlicʌdʌ soimaa taatatuldamu ʌgai daidʌ iduuñimu ʌgaicʌdʌ isducatai ʌpʌvueeyi ʌmaiʌʌgidaracʌdʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Daidʌ ʌpiooñi ismaacʌdʌ maatʌ istumaasi ʌaamudʌ ipʌlidi isiduñiagi dai maibai gʌducagi dai maiʌʌgidagi vʌʌsi ismaacʌdʌ tʌjai ʌaamudʌ, ʌgai soimaa taatamu gʌgʌʌgʌtudacai. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dʌmos ʌpiooñi ismaacʌdʌ maimaatʌcagi daidʌ iduñiagi istumaasi soimaascami ʌgai vʌʌscʌrʌ maisi soimaa taatamu. Dai ʌgai ismaacʌdʌ vaamioma maatʌ Diuusi ñiooquidʌ dai maiʌʌgidi ʌgai vaamioma soimaasi taatatuldamu Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Divia aanʌ dai cʌʌgacʌrʌ vuvaida iñagai vʌʌsi oidi daama oidacami vʌʌscatai ismaacʌdʌ giñvaavoitudagi oigʌldamu aanʌ vʌʌsi soimaascamigadʌ dai ʌgai ismaacʌdʌ maitiñvaavoitudagi ugitimu. Sʌʌlicʌdʌ canʌijada iñʌlidi aanʌ idi cʌʌgacʌrʌ vuvaidaragai iscaaipaco imʌdagi ʌpan duucai taí. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aliʌ soimaa taatamu aanʌ chiʌʌqui tasai, dai soigiñʌliadamu asta siʌʌscadʌ ajiagi istuigaco soimaa taata iñagai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aapimʌ povʌnʌlidi ansai aanʌ divia sai siooma oidacana vʌʌsi oodami, maitavʌr vaavoi baiyoma divia aanʌ vai oidacana cocodi aanʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dai sivi baitʌacoga oidacamu taama ʌmo quiiyʌrʌ oidacami dai vaica vuidʌrʌ vʌʌtʌcamu gooca. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ʌoogadʌ vuidʌrʌ caatʌcamu gʌmara cʌʌli daidʌ ʌmaradʌ gʌooga, daidʌ ʌdʌʌdʌ vuidʌrʌ caatʌcamu gʌmara ooqui daidʌ maradʌ gʌdʌʌ, daidʌ tuumudʌ vuidʌrʌ caatʌcamu gʌcaa dʌʌ daidʌ ʌcaa dʌʌdʌ gʌtuumu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Daidʌ ʌSuusi potʌtʌdai ʌʌpʌ ʌoodami: ―Siuu duucu nʌijada aapimʌ iicomai isuruñi amadʌrʌ vuvacʌi otoma pocaitiña aapimʌ sai duuduquia agai, vai povʌ vuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dai siʌʌscadʌ dʌvʌʌrai toñiamadʌrʌ ʌvʌrdagi pocaitiña aapimʌ sai toñica agai, vai povʌ vuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aapimʌ ismaacʌdʌ aagaiña ʌmo istumaasi dai ʌma maasi ivuaadana. ¿Ducatai maatʌ aapimʌ ismaasca agai oidigi mosnʌiditai mʌstumaa nʌidi? Dai vʌʌscʌrʌ maimaatʌ nʌidi tomali maimaatʌ caʌ istumaasi ʌpʌvueeyi sivi aapimʌ gʌnsaagida. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Tuimʌsi maitʌntʌtʌgitoi aapimʌ istumaasi ʌrcʌʌgaducami? ");
INSERT INTO ntpNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Isʌmaadutai gʌpiʌrʌ gʌvuupadagi dai gʌvaidaquiagi dunucamiʌrʌ baigi duuñi ñiooqui ʌgai ʌʌmadu voiyamu vai ʌgai maitʌvaidaquiagi dunucamiʌrʌ vaidʌ ʌdunucami gʌtʌʌgidagi ʌsandaaru vaidʌ ʌsandaaru gʌmaisagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Dai abiaadʌrʌ gia siaadʌrʌ vuusaiña aapi asta pʌsiʌʌscadʌ gaaa namʌqui vʌʌsi mʌsiʌʌsi gʌtañiagi ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Amaasi tuigaco ami dada chiʌʌqui cʌcʌʌli siaaco daacatadai ʌSuusi dai aagidi isducatai ʌPilaato coi chiʌʌqui cʌcʌʌli Galileeana oidacami dai bʌi ʌʌradʌ dai saagida vʌʌnagi vustaaqui ʌʌradʌ ismaacʌdʌ coitadai ʌcʌcʌʌli Galileeana oidacʌdʌ maiquiaa gʌncooditudacai ismaacʌdʌ daasda agaitadai ʌgai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dʌmos ʌSuusi potʌtʌdai: ―¿Povai mʌsiʌnʌlidi aapimʌ ispomaasi ʌpʌdui ʌcʌcʌʌlicʌdʌ Galileeʌrʌ oidacami vaamioma soimaasi ivuaadamicatai ʌgai siʌgaa anaasi oidacami? ");
INSERT INTO ntpNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aanʌ angʌnaagidi sai cho, dai mʌsaapimʌ maiʌma duucai gʌntʌtʌgituagi dai camaisoimaasi ivuaadagi vʌʌscatai ugitimu aapimʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Povai mʌsiʌnʌlidi aapimʌ siʌbaivustaama dan mamacova ismaacʌdʌ coi daama gʌʌsʌcai ʌgʌʌ vaaqui tʌcavacʌdʌ Siloeʌrʌ siʌgai vaamioma ʌrduñidʌcatadai isʌgaa Jerusaleenʌrʌ oidacʌdʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aanʌ angʌnaagidi sai cho dai mʌsaapimʌ maiʌma duucai gʌntʌtʌgituagi dai camaisoimaasi ivuaadagi vʌʌscatai ugitimu aapimʌ ʌʌpʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Daidʌ ʌSuusi aagidi ʌmo ñiooqui cuentocʌdʌ dai potʌtʌdai: ―Ʌmo cʌʌli ʌʌsʌcatadai ʌmo iigosi gʌdʌvʌʌragana, dai ʌmo imidagai mʌʌ nʌidamu sabai iibaidaga, dʌmos maitʌʌ tomali ʌmo iibiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dai amaasi potʌtʌdai ʌgai ʌcʌʌli ismaacʌdʌ nuucatuldacatadai ʌgai gʌdʌvʌʌraga: “Dañi cavaica uumigi miaad oidacai didivai aanʌ dai gaagaiña goiigosi iibiadʌ dai maitʌtʌgai mosʌʌgi cʌʌca goovai maiiibiataliacatai”, astʌtʌdai ʌʌʌsʌcami gʌpiooñiga. “Daitudañi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dʌmos ʌnuucadacami aa noragi dai potʌtʌdai: “Dagitoñi quiaa tomasi mosʌca idi uumigi, moicadagena godʌvʌʌragadʌ dai daasdagi ʌpua dʌvʌʌrai duaadidicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sabai poduucai iibiatana, dai ismaiiibiatagi aidʌ gia daitudagi”, astʌtʌdai ʌnuucadacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dai ʌmo ibʌstaragai tasʌrʌ ʌSuusi gamamaatʌtulditadai Diuusi ñiooquidʌ ʌmo judidíu quiuupaigadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Vai ami daacatadai ʌmo ooqui ismaacʌdʌ cabaivustaama dan mamacova uumigi coococatadai. Ʌmo Diaavora tʌaañicarudʌ topostudacatadai vai ʌgai maitistutuiditadai isgʌsʌʌliñagi tomali palʌpi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dai aidʌsi tʌʌ ʌSuusi ʌooqui vaí dai potʌtʌdai: ―Giñaduñi casiapʌt duaadicami vii ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mosdaama darai ʌgai gʌnoonovi taidʌ ʌooqui gʌsʌʌli, dai gʌaagacai cʌʌga ñioo Diuusi vui. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dʌmos ʌtʌaanʌdami judidíu quiuupaigadʌrʌ sʌʌlicʌdʌ baamu duaaidacai ʌSuusi ʌooqui ibʌstaragai tasʌrʌ, dai potʌtʌdai ʌgai ʌoodami: ―Oidagava naadami tasai aa duiñdagai vʌʌtarʌ dai istutuidi aapimʌ isdadacai gʌnduduaaidagi, dai maisiu ibʌstaragai tasʌrʌ ―astʌtʌdai ʌtʌaanʌdami ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tai amaasi ʌSuusi aa noragi dai potʌtʌdai: ―Aapimʌ ismaacʌdʌ aagai ʌmo istumaasi dai ʌma maasi ivueeyi. ¿Istutuidimʌsi aapimʌ ismaiuupanagi gʌnsoiga vooyisi siʌpʌ gʌnsoiga asñiitu ibʌstaragai tasʌrʌ dai iitudagi suudagi? ");
INSERT INTO ntpNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dai idi ooqui ismaacʌdʌ ʌrcajiudadʌ Avraañicaru vaidʌ ʌDiaavora vuracatadai idi coocodagaicʌdʌ cabaivustaama dan mamacova uumigi. ¿Dai maitisbaiga tomali isduaaidagi coocodadʌ ibʌstaragai tasʌrʌ? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dai aidʌsi capotʌi ʌSuusi, vʌʌscatai ismaacʌdʌ vuidʌrʌ vʌʌtʌcatadai siaa ʌʌran tadatu dʌmos vʌʌsi ʌoodami baigʌnʌliditadai nʌiditai istumaasi gʌgʌrducami ismaacʌdʌ ivuaadatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Amaasi potʌi ʌSuusi: ―Siuu duucu Diuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana ");
INSERT INTO ntpNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","gomaasi ʌrʌpan ducami istumaasi ʌpʌvueeyi ʌcaidʌ ʌmo uusi ismaacʌdʌ coravi tʌʌgidu ismaacʌdʌ ʌmo cʌʌli gʌdʌjoogana ʌi. Taidʌ ʌali caidʌ gʌʌ dai gʌʌ uusi gʌnaato. Vaidʌ ʌujuurugi maamaradʌrʌ dadarʌiña dai ami gacoocosatai. Poduucai siʌ otoma gʌʌ ʌali caidʌ poduucai otoma gʌmaatʌmu aipacoga isducatai soicʌi Diuusi oodami sai cʌʌgacʌrʌ oidacana ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Dai potʌi ʌSuusi ʌʌpʌ: ―Siuu duucu Diuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana ");
INSERT INTO ntpNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","gomaasi ʌrʌpan ducami istumaasicʌdʌ ʌooqui avocamadai tʌligi tuicami dai gooquiʌrʌ ivueeyi paana. Ʌmo ooqui vʌʌnaidi gocopodacarui vaica muuli tʌligi tuicami vai copodarʌi. Vʌʌsi tui saagida aimʌrai gocopodacarui dai poduucai vʌʌsi oidigi daama imʌi Diuusi ñiooquidʌ ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Vaidʌ ʌSuusi apiaimʌitadai Jerusaleenamu dai aijimi quiiquiʌrʌ dai gamamaatʌtuldimi Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tai ʌmaadutai tʌcacai dai potʌtʌdai: ―Mamaatʌtuldiadami, ¿maitasmuidu ismaacʌdʌ cʌʌgacʌrʌ vuvacʌi? ―astʌtʌdai. Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gʌnaagavurai dai vaapaqui goquitaagiña ismaacʌdʌ alidu gajiaacoga. Aanʌ angʌnaagidi sai muidutai vaapaquia ʌliadamu dai maitistuidimu aliʌ sijaiga isvaapaquiagi siaaco tʌaanʌi Diuusi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dai siuu duucu ʌquiʌʌcami cacuupagi gʌquii, dai aapimʌ mʌsmaacʌdʌ quiidigana guuca ñiooquiadamu aapimʌ dai potʌtʌadamu: “Cʌliodami gʌrcupioquidañi”. Dʌmos ʌgai gʌnaa noragidamu dai povʌntʌʌdamu: “Maitanmaatʌ aanʌ mʌsiaadʌrʌ aapimʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mʌsi aapimʌ potʌʌdamu: “Gʌʌʌmadu gacuaadana aatʌmʌ dai gayʌʌdana dai aapi gamamaatʌtuldiña tʌsiaaco oidaga aatʌmʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dʌmos ʌgai gʌnaa noragidamu dai povʌntʌʌdamu: “Casian gʌnaagidi ansai maimaatʌ mʌsiaadʌrʌ aapimʌ. Ʌcovai avʌr iimi giñabaiñdʌrʌ, vʌʌscatai aapimʌ mʌsmaacʌdʌ soimaasi ivueeyi”, astʌʌdamu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dai ami suaanʌdamu aapimʌ dai aliʌ soimaa taata agai, nʌiditai ʌAvraañi ʌʌmadu Isaa, dai Jaco dai vʌʌsi Diuusi ñiñiooquituldiadamigadʌ ʌʌmadu daraaja Diuusi siaaco gatʌaanʌi ʌgai, mai aapimʌ quiidigamu gʌnvuvaidagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aipadʌrʌ dadimu oodami dai daraivacai gaugimu ami siaaco gatʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Amaasi ʌʌmadutai ismaacʌdʌ vaamioma namʌga tami oidigi daama mʌʌca siooma maiñamʌacamu dai ʌʌmadutai ismaacʌdʌ maiñamʌga tami oidigi daama mʌʌca siooma namʌacamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dai ʌgai vaa tasʌrʌ ami dada ʌʌmoco fariseo siaaco daacatadai ʌSuusi dai potʌtʌdai: ―Imʌdañi tabiaadʌrʌ ʌEroodʌsi gʌmuaa ʌlidi ―astʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dʌmos ʌSuusi aa noragi dai potʌtʌdai: ―Iimivurai dai mʌʌ aagida ʌcʌʌli ismaacʌdʌ aliʌ saituduga mosʌca soimaasi iduiñdagai vʌʌtarʌ. Quiaa anvuvaidagi Diaavora tʌtʌaañicarudʌ oodamiaiñdʌrʌ dai duduaaidagi coococoidadʌ dai asta naatomu aanʌ giñaa duiñdaga daida apiaimʌdamu Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tomali ʌmaadutai Diuusi ñiñiooquituldiadamigadʌ maitʌcooditudai sibʌaacoga mosʌca Jerusaleenʌrʌ cascʌdʌ aliʌsi gʌaagai isimia aanʌ Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aapimʌ Jerusaleenʌrʌ oidacʌdʌ, aapimʌ mʌsmaacʌdʌ coodai Diuusi ñiñiooquituldiadamigadʌ dai maisai ojootosicami ismaacʌdʌ gʌnootosdi ʌgai. Mosʌ muiyoco imidagai ipʌliditadai aanʌ isgʌnʌmpaidagi dai gʌnnuucadacagi ʌpan duucai ʌtacucu ʌmpaidi gʌmaamara gʌaana uta mʌtai maitipʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aapimʌ sivi gʌndagitomu aanʌ dai camaitiñtʌʌgimu aapimʌ ʌpamu asta siʌʌscadʌ aayi istuigaco potʌiya aapimʌ: “Aliʌ baigʌʌlidi goovai ismaacʌdʌ borimʌi Diuusi guvucadadʌcʌdʌ”, astʌiya aapimʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ʌmo ibʌstaragai tasʌrʌ ii ʌSuusi ʌmo fariseo baitʌcʌaacami quiidiamu dai ʌʌmadu gaugia agai, vaidʌ ʌgaa fariseo soobidacatadai sabai giduuna ʌmo istumaasi istucʌdʌ istutiada ʌgai isgʌpiʌrʌ vuaajagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Vai ami ʌSuusi vuidʌrʌ daacatadai ʌʌpʌ ʌmo coocoadʌ ismaacʌdʌ vaiguuguñicatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tai amaasi ʌSuusi tʌcacai ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ʌʌmadu ʌfariseo dai potʌtʌdai: ―¿Oidagasi oigaragai ʌmo ibʌstaragai tasʌrʌ isduaaidagi ʌmo coocoadʌ chio sio? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dʌmos ʌgaa mosdodoli vii. Tai amaasi ʌSuusi bʌi ʌcoocoadʌ dai duaadi dai potʌtʌdai sai noragʌna. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dai potʌtʌdai ʌSuusi ʌfariseo: ―¿Maacʌdʌ aapimʌ maiotoma vañigidana gʌnsoiga asñiitu siʌpʌ gʌnsoiga vooyisi issibʌcai dʌʌcarʌ gʌsiagi ʌgai tomasi ʌribʌstaragai tasʌrʌ? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Taidʌ ʌfariseo tomali ʌmaadutai maitʌʌ istʌʌdagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tʌʌgacai ʌSuusi siʌvapaidarsicʌdʌ cʌcʌʌgaducʌdioma daraicariʌrʌ daraivaimi meesa vuidʌrʌ, aagidi idi ñiooqui cuentocʌdʌ dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Siʌʌscadʌ ʌmaadutai gʌnvaidagi ʌmo cunataragiʌrʌ maitavʌr cʌcʌʌgaducʌdioma daraicariʌrʌ daraiva. Divian tada ʌmai vaidarsicami ismaacʌdʌ vaamioma namʌga isaapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Vai ʌgai ismaacʌdʌ gʌnvapai divian tada dai povʌntʌʌdagi ʌmaadutai aapimʌ: “Maacañi godaicarui idi gʌmai”. Amaasi ʌgai siaa ʌratugaitai cʌquivan tada dai cugatʌrʌ daicariʌrʌ daivagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Baiyoma mʌsiʌʌscadʌ gʌnvaidagi vʌrai soimaascʌdioma daraicariʌrʌ daraiva, dai poduucai divimu ʌgai ismaacʌdʌ gʌnvapai dai povʌntʌʌdamu: “Giñaaduñi vaamioma cʌcʌʌgaducʌdioma daraicariʌrʌ avʌrdaraiva”. Dai poduucai vaamioma gʌducʌdʌ gʌʌldamu ʌgai vuitapi ismaacʌdʌ ʌʌmadu daraajagi meesa vuidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ʌgai ismaacʌdʌ siooma gʌducʌdʌ gʌʌliadagi ʌgai siooma maitʌrgʌducʌdʌcamicamu dai ʌgai ismaacʌdʌ siooma maigʌducʌdʌ gʌʌliadagi ʌgai siooma ʌrgʌducʌdʌcamicamu ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Daidʌ ʌSuusi potʌtʌdai ʌʌpʌ ʌgai ismaacʌdʌ vaí: ―Pʌsiʌʌscadʌ gabibida ʌliada maitivapiada gʌaaduñi tomali gʌsiisiʌgi tomali gʌsusuuculi, tomali gʌaaduñi riricu ʌgai ʌʌpʌ gʌvaidan tada dai poduucai viaacamu aapi gʌaa noragidaraga. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Baiyoma pʌsiʌʌscadʌ gabibida ʌliada pai vapaida soituutuigami ismaacʌdʌ maiviaa istumaasi, dai ismaacʌdʌ maitistutuidi isgaaata vuaadagi, dai ismaacʌdʌ maitistutuidi isajioopadagi, dai ismaacʌdʌ maiñʌnʌeeyi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dai baigʌʌliadamu aapi maitistutuiditai ʌgai isgʌaa noragidagi. Viaacamu aapi gʌaa noragidaraga siʌʌscadʌ duduaacagi coidadʌ saagidaiñdʌrʌ ʌgai ismaacʌdʌ ʌʌgidi Diuusi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dai caʌcai imaasi ʌmaadutai ismaacʌdʌ meesa vuidʌrʌ daacatadai potʌtʌdai ʌgai ʌSuusi: ―Baigʌʌliadamu ʌgai ismaacʌdʌ gacuaadagi mʌʌca siaaco gatʌaanʌi Diuusi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Taidʌ ʌSuusi potʌtʌdai: ―Ʌmo cʌʌli idui gʌpi cuaadagai, dai ootoi sioorʌ vapaidagi mui oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dai aidʌsi caayi siuu duucu gʌugia agai, taidʌ ʌcʌʌli ootoi ʌmoco gʌpiooñiga sai potʌʌdana ʌvapaidarsicʌdʌ sai cadadana sai cabaigʌduu vʌʌsiaʌcatai. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dʌmos vʌʌsi ʌvapaidarsicʌdʌ maiiimia ʌlidi cascʌdʌ potʌtʌdai sai oigʌldana. Ʌʌpʌgadadʌ potʌtʌdai: “Utudama savʌʌli aanʌ ʌmo dʌvʌʌrai dai viaa ismʌʌ nʌidagi aagidañi vaidʌ giñoigʌldana siviʌrʌ”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Taidʌ ʌgʌmai potʌtʌdai: “Savʌʌli aanʌ taama vuupulicami vopooyisi dai viaa aanʌ isnʌidagi sabai cʌcʌʌgadu aagidañi vaidʌ giñoigʌldana”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tai ʌmai potʌtʌdai: “Utudama antooñigai dai cascʌdʌ maitistutuidi isimiagi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dai aidʌsidʌ ʌpiooñi ʌpamu quiiyʌrʌ divia dai aagidi vʌʌsi imaasi gʌaamu tai ʌgai sʌʌlicʌdʌ baamu dai potʌtʌdai gʌpiooñiga: “Imiñi otoma cacayamu dai plaasamu dai baigovai vuaapa vʌʌsi ʌsoituutuigami ismaacʌdʌ maiviipia istumaasi dai ʌgai ismaacʌdʌ maitistutuidi isgaaata vuaadagi dai ʌgai ismaacʌdʌ maitistutuidi isajioopadagi dai ismaacʌdʌ maiñʌnʌeeyi”, astʌtʌdai ʌaamudʌ gʌpiooñiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tai bo laascʌdʌ potʌtʌdai ʌpiooñigadʌ: “Casiant idui pʌsducatai giñaagidi, vai quiaa oidaga siaacoga aa vʌʌtarʌ”, astʌtʌdai ʌpiooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tai amaasi ʌaamudʌ potʌtʌdai gʌpiooñiga: “Imiñi ʌpamu voiyamu dai dʌjiamu dai goguama vapaida aa vai vaapacʌna, vai poduucai suudana giñquii. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gʌnaagidiana sai tomali ʌmaadutai ismaacʌdʌ vapai aanʌ ʌʌpʌga maiugimu giñcuaadagaiga”, astʌtʌdai ʌaamudʌ gʌpiooñiga ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mui oodami oidatucuitadai ʌSuusi, dai ʌgai aa nʌnʌaava dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Isʌmaadutai giñoidatucuda ʌliada dai vaamioma oigʌadagi gʌooga dai gʌdʌʌ, dai gʌooñiga, dai gʌmaamara, dai gʌsusuuculi, dai gʌsiisiʌgi, dai asta ʌʌgi gʌibʌdaga isaanʌ, ʌgai maitistutuidi isʌrgiñmamaatʌrdamicagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dai sioorʌ maibaigʌ ducagi issoimaa taatagi dai asta muquiagi curuusiaba giñvaavoitudaitai maitistutuidi isiʌrgiñmamaatʌrdamicagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Isʌmaadutai aapimʌ iduñia ʌliada ʌmo quii siaadʌrʌ maiʌʌsitudana aapimʌ ʌʌpʌga siʌʌsi gʌaagai mʌsabai aitudadan tada ʌcaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ʌma duucai isdarasa aapimʌ ojoodagadʌ dai maiviaacagi istuucʌdʌ naatuagi dai vʌʌscatai sioorʌ nʌijadagi gʌnparunadamu ");
INSERT INTO ntpNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","dai pocaitiadamu: “Gocʌʌli mosgʌaaga gʌquii dai maitistui isnaatuagi”, caitiadan tada oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Siʌpʌ ʌmo raí cocoda agadagi ʌmai raí siaadʌrʌ maiʌʌsitudana ʌgai ʌʌpʌga sabai istuidiadan tada iscocodagi baivustaama miil sandaarucʌdʌ vui ʌgʌmai ismaacʌdʌ viaa ʌmo coobai miil. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dai ismaitistuidiadan tadaca ʌgai ootosan tada ʌgai ojootosicami siʌʌscadʌ quiaa mʌʌcasdʌrʌ imʌdagi ʌgʌmai, sai baiduuna ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Poduucai ʌʌpʌ sioorʌ maidagituagi vʌʌsi istumaasi viaa maitistutuidi isʌrgiñmamaatʌrdamicagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Daidʌ itʌtʌdai ʌʌpʌ: ―Gomaa onai aliʌ vʌʌñiga dʌmos iscamaiyoovica ʌgai, ¿ducatai yoovituna ʌgai ʌpamu? ");
INSERT INTO ntpNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Camaicʌʌgaducamu ʌgai duaaidaragai dʌvʌʌrai vʌʌtarʌ mosʌ daituda ʌgai. Aapimʌ mʌsmaacʌdʌ tʌtʌcaidaga caʌcavurai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vʌʌscatai ʌtumiñsi vuudami ʌʌmadu ʌgai ismaacʌdʌ maivaavoitudai vaavoidaragadʌ ʌfariseo miaadʌrʌ guuquiva siaaco daacatadai ʌSuusi dai caʌca agai istumaasi aagaitadai ʌgai, ");
INSERT INTO ntpNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","vai cascʌdʌ ʌfariseo ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ñiooquidi ʌgai ʌSuusi dai pocaiti: ―Idi cʌʌli miaadʌgidi soimaasi ivuaadami dai ʌʌmadu gacueeyi ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Taidʌ ʌSuusi aagidi ʌmo ñiooqui cuentocʌdʌ dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Voorʌ aapimʌ isviaacagi ʌmo siento cañiiru vai sibʌ imiagi ʌmoco siaadʌrʌ maianaasi viaana aapimʌ ʌgaa maaco coobai dan baivustaama dan tustaama dai gaagamuna ʌsibʌ imiaadʌ asta siuu duucu tʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dai tʌʌgacai bʌiyagi dai baigʌʌliatugaitai mootiagi dai bʌʌquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dai aʌcai gʌquiiyʌrʌ ʌmpaidagi gʌaaduñi dai potʌʌdagi: “Baigavʌr ʌnʌliada giñʌʌmadu casiantʌʌ giñsoiga ismaacʌdʌ sibʌ iitadai”. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aanʌ angʌnaagidi sai poduucai ʌʌpʌ vaamioma oidaga baiʌliaragai mʌʌ tʌvaagiʌrʌ ʌmo soimaasi ivuaadamicʌdʌ ismaacʌdʌ ʌma duucai gʌtʌgituagi dai camaisoimaasi ivuaadagi isbai maaco coobai dan baivustaama dan tustaamacʌdʌ ismaacʌdʌ maitʌrsoimaasi ivuaadami dai maitʌaagai isʌma duucai gʌntʌtʌgituagi dai camaisoimaasi ivuaadagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Daidʌ ʌSuusi itʌtʌdai ʌʌpʌ: ―Siʌpʌ ʌmo ooqui viaacagi ʌgai ali baivustaama piisu dai sibʌ vuaajagi ʌmoco siaadʌrʌ maicuudana ʌgai ʌmo cuudagi dai voisicana dai cʌʌga gʌtaatacai gaagana asta siuu duucu tʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dai tʌʌgacai ʌmpaidagi gʌaaduñi dai potʌʌdagi: “Giñʌʌmadu avʌr baigʌnʌliada casiantʌʌ ʌtumiñsi ismaacʌdʌ sibʌ vuaatadai aanʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aanʌ angʌnaagidi sai poduucai ʌʌpʌ aliʌ baigʌnʌlidiña Diuusi tʌtʌaañicarudʌ ʌmo soimaasi ivuaadamicʌdʌ siʌʌscadʌ ʌma duucai gʌtʌgituagi ʌgai dai camaisoimaasi ivuaadagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Daidʌ ʌSuusi potʌtʌdai ʌʌpʌ: ―Ʌmo cʌʌli maamaracatadai gooca cʌcʌʌli, ");
INSERT INTO ntpNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","taidʌ ʌgooquiʌrdadʌ potʌtʌdai gʌooga: “Giñooca giñmaacañi gʌvustuidaga siʌʌsi giñajʌga”, astʌtʌdai. Taidʌ ʌoogadʌ maa gʌvustuidaga siʌʌsi aʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tai bo chiʌʌqui tasaicʌdʌ ʌmaradʌ gooquiʌrdadʌ ʌmpagi vʌʌsi gʌvustuidaga dai daivunu ii mʌʌcasi ʌmai dʌvʌʌriʌrʌ, dai ami vʌʌsi soimaasiʌrʌ siaa doodai gʌvustuidaga. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Dʌmos aidʌsi cavʌʌsi siaa doodai ʌgai tai divia gʌʌ biuugigai ami dʌvʌʌriʌrʌ, vai ʌgai bibiuugʌi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dai amaasi gaagamu aa duiñdagai ʌmo cʌʌli ami dʌvʌʌriʌrʌ oidacami ʌʌmadu, tai ʌgai ootoi sai nuucadana tataisoli. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tascoñia ʌliditadai ʌuuparai iibiadʌcʌdʌ ismaacʌdʌ cuaadatadai ʌtataisoli dai tomali ʌmaadutai maibibiditadai tomalaachi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tai amaasi divia tʌgitoidadʌ dai ʌgai povʌʌli: “Mosʌʌ muidu giñooca quiidiʌrʌ pipiooñi vai vʌʌscʌrʌ babaivitocʌi cuaadagai, dai aanʌ tanai cayooga muu biuugimucai. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Imimu aanʌ giñooca quiidiamu dai potʌʌdamu: Giñooca, soimaasi idui aanʌ Diuusi vui dai aapi gʌvui, ");
INSERT INTO ntpNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","camaiviaa aanʌ sʌʌlicami siʌrgʌmaracagi, tomasi ʌmoco gʌpiooñiga duucai giñnʌijada aapi istʌʌdamu aanʌ”, asʌʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dai amaasi voiyʌrʌ cʌquiva dai ii gʌooga quiidiamu. Dai quiaa mʌʌcasdʌrʌ imʌi tai tʌʌ ʌoogadʌ dai aayi soiʌliaragai tʌʌgacai gʌmara dai mʌʌ dai mʌʌ vuidʌrʌ aayi dai coomitu dai usupi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Taidʌ ʌmaradʌ potʌtʌdai gʌooga: “Giñooca, soimaasi idui aanʌ Diuusi vui dai aapi gʌvui, camaiviaa aanʌ sʌʌlicami siʌrgʌmaracagi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dʌmos ʌoogadʌ potʌtʌdai gʌpipiooñiga: “Otomavʌr vuvaida cʌcʌʌgaducʌdioma yuucusi dai aadida dai daasdavurai ʌmo aniyu noviʌrʌ, dai aadidavurai sasapatusi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dai vuaapavurai ʌvaaca mara giʌcʌdioma dai muaa tʌtaidʌ iduuñi vagimi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Idi giñmara casi ʌrmuuquiadʌcatadai dai ʌpamu duaaca casi ʌrsibʌ imiadʌcatadai goovai tʌtai ʌpamu tʌʌ”, ascaiti ʌoogadʌ daidʌ idui vagimi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Vaidʌ ʌmaradʌ gʌducʌdioma dʌjiana aimʌraitadai dai aidʌsi divia ʌgai cayoga aijimitadai quii dai cai iivaragai dai tuutudacʌdami. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dai amaasi vaí ʌgai ʌmaadutai ʌgʌgʌʌli dai tʌcacai astumaasi ʌpʌduitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Taidʌ ʌgʌʌli potʌtʌdai: “Casi atdivia gʌsucuuli cascʌdʌ gʌooca gatʌjai muaaragai ʌvaaca mara giʌcʌdioma cʌʌgacʌrʌ diviacai ʌgai dai maicoocotugaitai”, astʌtʌdai ʌgʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dʌmos ʌsiʌʌgidʌ sʌʌlicʌdʌ baamu, dai maitipʌliditadai isvaquiagi taidʌ ʌoogadʌ vuusai dai goguama oí sai vaacʌna. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tai ʌgai potʌtʌdai gʌooga: “Aapi cʌʌga maatʌ iscamui uumigi vaa gʌsoi aanʌ dai vʌʌscʌrʌ gʌʌʌgidiña pai tomali ʌmo imidagai maiquiaa giñoidi tomali ʌmo sivatu isʌʌmadu iduñia aanʌ vagimi giñaaduñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dʌmos sivi diviacai gʌmara ismaacʌdʌ soimaasiʌrʌ siaa doodai gʌtumiñsiga ooqui taatacaligami ʌʌmadu pʌtai muí ʌvaaca mara giʌcʌdioma”, astʌtʌdai ʌmaradʌ gʌducʌdioma gʌooga. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Amaasi ʌoogadʌ potʌtʌdai: “Giñmara aapi vʌʌscʌrʌ giñʌʌmadu daacana dai vʌʌsi istumaasi viaa aanʌ vʌʌsi ʌraapi gʌvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dʌmos sivi sʌʌlicʌdʌ gʌaagaitadai isiduñia aatʌmʌ vagimi dai baigʌrʌliadagi, gʌsucuuli ismaacʌdʌ casi ʌrmuuquiadʌcatadai ʌpamu duaaca casi ʌrsibʌ imiadʌcatadai tʌtai ʌpamu tʌʌ”, astʌtʌdai ʌoogadʌ gʌmara ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Daidʌ ʌSuusi potʌtʌdai ʌʌpʌ gʌmamaatʌrdamiga: ―Oidacatadai ʌmoco gaaamu gʌviidacami dai viaacatadai mui pipiooñi dai ʌmoco ʌrpipiooñi tʌaanʌdamigadʌ. Dai amaasi maí ʌaamudʌ siʌpipiooñi tʌaanʌdamigadʌ siaa vuiididi vustuidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Amaasi ʌaamudʌ vaí dai potʌtʌdai: “¿Tumaasi idi mʌsmaacʌdʌ giñaagidi pʌsaidʌ ivueeyi? Giñaagidañi pʌstumaasi idui aapi vaa giñvustuidagacʌdʌ casiapʌ maitʌrgiñtʌaañicaruca agai”, astʌtʌdai ʌaamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Amaasi ʌpipiooñi tʌaanʌdamigadʌ aduucai gʌtʌgito: “¿Istuma duuñimu aanʌ giñvuusaidacai giñaamu idi aa duiñdagiaiñdʌrʌ? Maiguvuca aanʌ isaata vuaadagi dʌjiana, dai siaa ʌrai aanʌ isgataanʌdagi oidicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Casian maatʌ istuma duñiagi dai viaacagi sioorʌ giñmiaadʌgidagi iñsiʌʌscadʌ maiviaaca aanʌ aa duiñdagai”, asʌʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Amaasi vaí mosʌʌmadutai ismaacʌdʌ vupuaatulditadai ʌaamudʌ. Dai tʌcacai ʌpʌgadadʌ dai potʌtʌdai: “¿Pʌʌsi vuaatuldi aapi giñaamu?” astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tai ʌgai aa noragi dai potʌtʌdai: “Ʌmo siento vopoti giigi”, astʌtʌdai. Taidʌ ʌtʌaanʌdami potʌtʌdai: “Tanai daja siaaco oojisi pʌsiʌʌsi vuaatuldi. Bʌiñi dai siaa duaada dai ʌpamu ooja dai poduucai ooja pʌsai altaajucami siento vuaatuldi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Amaasi vaí ʌgai ʌmai dai potʌtʌdai: “¿Aapio pʌʌsi vuaatuldi?” astʌtʌdai. Tai ʌgai potʌtʌdai: “Ʌmo baimocoroi tʌligi”, astʌtʌdai. Taidʌ ʌtʌaanʌdami potʌtʌdai: “Tami daja siaaco oojisi pʌsiʌʌsi vuaatuldi. Bʌiñi dai siaa duada dai ʌpamu ooja dai poduucai ooja pʌsai ali maaco coobai vuaatuldi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Taidʌ ʌaamudʌ maatʌ tʌʌ isaliʌ saituduacatadai ʌtʌaanʌdami ʌʌsivuaacʌdʌ. Ʌoodami ismaacʌdʌ ivueeyi istumaasi ʌʌgi ʌgai ipʌlidi siooma sastuduga isgaagadagi istumaasi ipʌlidi isʌgai ismaacʌdʌ ivueeyi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dʌmos aanʌ angʌnaagidi sai tomamʌs saagida daraaja ʌgai ismaacʌdʌ gamaitʌcʌi gʌnvustuidaga vupuiirumadaitai aa dʌmos aapimʌ gʌaagai mʌssoicʌdagi aa gʌnvustuidagacʌdʌ isducatai Diuusi ipʌlidi siʌʌscadʌ coiyagi aapimʌ gʌnvustuidaga camaitʌnsoiñamu dai Diuusi gʌnmiaadʌgidamu tʌvaagiʌrʌ dai gʌnmaaquimu baabaqui ismaacʌdʌ tomali ʌmo imidagai maiuugiatʌi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sioorʌ ivueeyi laachi istumaasi isducatai aagai poduucai iduñian tada ʌgai gʌpi ʌʌpʌ, dai isʌʌsivuaca ʌgai laachicʌdʌ poduucai ʌʌsivuacan tada ʌgai ʌʌpʌ gʌpicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mʌsmaitivueeyi mʌstumaasi aagai gʌnvustuidagacʌdʌ tami oidi daama Diuusi maitʌnmaaquimu istumaasi vʌʌscʌrʌ namʌacana. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mʌsmaitivueeyi mʌstumaasi aagai gavustuidagacʌdʌ voorʌ gʌnmaquia agai istumaasi aapimʌ ʌʌgi gʌnvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tomali ʌmo piooñi maitistutuidi isgoocaducagi aamudʌ, cʌʌdadan tada ʌgai ʌmoco dai oigʌadagi ʌgʌmai, ʌʌgiadan tada ʌgai ʌmoco dai maiʌʌgiadagi ʌgʌmai. Sioorʌ oigʌadagi gʌvustuidaga maitistutuidi isʌʌgiadagi Diuusi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ʌfariseo ismaacʌdʌ aliʌ oojoidi isʌmpaidiada mui tumiñsi caʌcai vʌʌsi imaasi ʌgai mosparunai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Amaasi ʌSuusi potʌtʌdai: ―Aapimʌ cʌʌ tuutiacami gʌnaagai oodami vuitapi, dʌmos Diuusi cʌʌ maatʌ gʌniibʌdaga. Ʌʌmo istumaasi istumaasi ʌoodami cʌʌgadu ʌlidi Diuusi aliʌ cʌʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Aidʌsi maiquiaa divia ʌVuaana ismaacʌdʌ vapacoi ʌoodami oidacatadai Moseesacaru sʌʌlicamigadʌ ismaacʌdʌ maa Diuusi dai oidacatadai ʌʌpʌ Diuusi ñiñiooquituldiadamigadʌ mamaatʌtuldaragadʌ. Dai aidʌsi divia ʌVuaana aidʌ abiaadʌrʌ gʌaagai sai Diuusi soicʌda ʌlidi oodami sai cʌʌgacʌrʌ oidacana, dai vʌʌscatai gʌnaajagʌi vaavoituda ʌliditai sai Diuusi soicʌda ʌlidi oodami sai cʌʌgacʌrʌ oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Siooma maisijaiga isugitiagi tʌvaagi ʌʌmadu dʌvʌʌrai siugitiagi ʌmo ñiooqui sʌʌlicamigadʌ Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tomastuma cʌʌli isdagituagi gʌooñiga dai vʌʌnagi ʌmai ʌgai aliʌ soimaasi ivueeyi, dai ʌgai ismaacʌdʌ vʌʌnagi ʌmo ooqui dagitobarui ʌgai aliʌ soimaasi ivueeyi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ʌmo imidagai oidacatadai ʌmo cʌʌli gʌviidacami dai cʌʌga dadapacami gʌaadaiña yuucusi dai cʌʌga titiodicami, dai vʌʌs tasai ivuaadana vagimi gʌgʌrducami. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dai oidacatadai ʌʌpʌ ʌmo soitigami Lázaru tʌʌgiducami, ismaacʌdʌ iivosicatadai vʌʌsi tuucugadʌ dai mosdʌvʌʌrapi dadaʌjʌiña ʌgʌviidacʌdʌ quitaagiñagadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Vaidʌ ʌsoitigami tascoñia ʌliditadai ʌcuaadagai viigiadʌcʌdʌ ismaacʌdʌ gʌʌsʌi ʌgʌviidacʌdʌ meesagadʌaiñdʌrʌ, vai asta ʌgoogosi viñiumiditadai iivoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tai ʌmo imidagai muu ʌsoitigami, tai dada Diuusi tʌtʌaañicarudʌ dai bʌʌcai sai ʌʌmadu daacana Avraañicaru siaaco ajioopai ʌcoidadʌ. Dai bo chiʌʌqui tasaicʌdʌ muu ʌgʌviidacʌdʌ ʌʌpʌ mʌtai yaasa. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dai aidʌsidʌ ʌgʌviidacʌdʌ soimaa taatacatadai mʌʌca siaaco ajioopai maicʌʌga tuutiacʌdʌ, dai taí nʌnʌaava dai mʌʌcasdʌrʌ tʌʌ ʌgai ʌAvraañi, daidʌ ʌLázaru ʌʌmadu daja. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dai amaasi iiña dai potʌi: “Avraañi soigi gʌʌlda aanʌcʌdʌ dai baigovai ootosa goLázaru vai vadʌidana gʌmasaiga cuugadʌ suudarʌ dai diviana dai ʌvogidana giñnʌʌnʌ alianʌ soimaa taataca aanʌ tami taiyʌrʌ”, astʌtʌdai ʌgʌviidacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dʌmos ʌAvraañi potʌtʌdai: “Giñmara, gʌtʌgitoñi pʌsiaapi cʌʌgacʌrʌ oidacatadai maiquiaa muucucai, dai goLázaru aliʌ soimaa taata. Dai sivi goovai baigʌʌlidi tami pai aapi soimaa taataca. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dai tomasducatai maibaiga isducatai oidagava ʌmo gʌʌ dʌʌcagi tuucavacami dai poduucai sioorʌ imia ʌliada tabiaadʌrʌ gaamucu maitistutuidi tomali mʌʌcadʌrʌ baigovaco maibaiga”, astʌtʌdai ʌAvraañi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Amaasi ʌgʌviidacʌdʌ potʌtʌdai: “Gʌdaanʌi aanʌ tuduidʌ aapi, cʌliodami Avraañi, pai ootosa goLázaru giñooca quiidiamu, ");
INSERT INTO ntpNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ami siaaco daraaja taama giñsusuuculi dai giñsiisiʌgi vai aagidana goovai isducatai maidadiagi ʌgai ʌʌpʌ tami siaaco mosʌʌ soimaasi gʌtaatamai”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dʌmos ʌAvraañi potʌtʌdai: “Ʌgai viaa ʌgai ismaacʌdʌ ooja Moseesacaru ʌʌmadu Diuusi ñiñiooquituldiadamigadʌ, vai ʌʌgiditai caʌcana”, astʌtʌdai Avraañi. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Taidʌ ʌgʌviidacʌdʌ aa noragi dai potʌtʌdai: “Dañi aapi Avraañi, siaadʌrʌ ʌʌgidana ʌgai Avraañi dʌmos isimiagi ʌmaadutai coidadʌ saagidaiñdʌrʌ mʌʌca siaaco daraaja ʌgai poduucai gia ʌma duucai gʌntʌtʌgituan tada ʌgai dai camaisoimaasi ivuaadagi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dʌmos ʌAvraañi potʌtʌdai: “Ismaiʌʌgida ʌliada ʌgai ʌMoseesacaru ʌʌmadu Diuusi ñiñiooquituldiadamigadʌ poduucai ʌʌpʌ siaadʌrʌ ʌʌgidana ʌgai tomasi ʌmaadutai duaacagi coidadʌ saagidaiñdʌrʌ”, astʌtʌdai ʌAvraañi ―astʌtʌdai ʌSuusi ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Amaasi ʌSuusi potʌtʌdai gʌmamaatʌrdamiga: ―Vʌʌscʌrʌ oidacamu istumaasi isducatai soimaasi ivuaadagi oodami dʌmos siʌʌ soimaa taatamu ʌgai ismaacʌdʌ soimaasi iduiñtulda ʌliada oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sioomʌ ʌrcʌʌgai ʌgai vʌʌtarʌ mʌscusivuana vulidagi ʌmo mauturui dai gʌʌ suudarʌ daitudagi baiyoma issoimaasi iduiñtuldada ʌgai ʌmaadutai idi ismaacʌdʌ utudama vaavoitu. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cʌʌgavʌr gʌntʌtʌgitoca aapimʌ isʌmaadutai soimaasi iduñia gʌvui aagidavurai aapimʌ ʌgai issoimaasi idui ʌgai gʌvui. Dai isʌma duucai gʌtʌgituagi ʌgai dai camaisoimaasi ivuaada agadagi oigʌldavurai. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tomasi muiyoco soimaasi gʌvuiidiada ʌgai dai vʌʌsi vuidagʌrʌ didivadagi dai povai gʌntʌtʌadagi: “Casian maipovuaadagi”, vʌʌscʌrʌ gʌaagai mʌsoigʌnʌldiadagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ʌojootosicami potʌtʌdai ʌSuusi: ―Gʌrsoiñañi tʌtai vaamioma vaavoituda aatʌmʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Amaasi ʌSuusi potʌtʌdai: ―Isviaacamudai aapimʌ tomasi lʌʌchi vaavoidaragai tomasi ʌpan ʌʌsi isuiduru ʌmo caidʌ coravi istutiadamudai aapimʌ ispotʌʌdagi idi iigosi: “Gʌvaiñcumañi dai gʌʌ suudarʌ cʌquiva”, idi iigosi gia gʌnʌʌgidamudai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Isʌmaadutai aapimʌ viaacagi ʌmo piooñi vai ʌgai gasicuandagi dʌjiana siʌʌpʌ nuucadacagi vustaqui, dai siuu duucu divia ʌgai ¿bais potʌʌdana aapimʌ giimi dai gauga? ");
INSERT INTO ntpNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Maipotʌʌdan tada aapimʌ baiyoma potʌʌdan tada aapimʌ: “Baigi tua gocuaagi nai aanʌ gaugiagi quiaa pai gooquiʌrʌ gauga aapi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Bais Diuusiatʌnamʌquidana tʌʌdana aapimʌ ʌpiooñi iduucai ʌgai mʌstumaasi tʌjai? Cho lienʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Poduucai aapimʌ ʌʌpʌ mʌsiʌʌscadʌ naatuagi vʌʌsi istumaasi ismaacʌdʌ gʌntʌaanʌi Diuusi, gʌaagai mʌspotʌʌdagi: “Aatʌmʌ ʌpan ducami tomastuma pipiooñi idui aatʌmʌ mosʌcaasi istumaasi viaacatadai isiduñiagi cascʌdʌ” ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dai apiaimʌitadai ʌSuusi Jerusaleenamu ʌmapiadʌrʌ ʌrSamaalia dai ajadʌrʌ ʌrGalilea tai ʌgai ʌrana sʌʌli daivusai. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dai aʌcai ʌgai ʌmo ʌmapʌcʌrʌ vai vuidʌrʌ iimʌitadai baivustaama cʌcʌʌli ismaacʌdʌ viaacatadai ʌcoocodagai ismaacʌdʌ duvaldi gatuucuga dʌmos bai mʌʌcasdʌrʌ guuquiva ʌgai ");
INSERT INTO ntpNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dai ijiña daidʌ icaiti: ―Suusi mamaatʌtuldiadami soigi gʌʌlda aatʌmʌcʌdʌ ―ascaiti ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dai aidʌsi tʌʌ ʌSuusi potʌtʌdai: ―Iimivurai dai mʌʌ vuidʌrʌ guuquiva ʌpapaaligadʌ ʌjudidíu ―astʌtʌdai ʌSuusi. Dai aidʌsi iimʌitadai ʌgai todian duucai duduaadicami vii. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amaasi ʌmaadutai ʌgai mostʌʌ iscadueeyi aa gʌi dai iiñaquitadai siaa duutudaimi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dai gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ dai dʌvʌʌrapi cuiqui dai potʌtʌdai: “Diuusiatʌnamʌquidana”, astʌtʌdai. Dai idi cʌʌli ʌrSamaaliʌrʌ oidacamicatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Amaasi ʌSuusi pocaiti: ―¿Bais maivʌʌ baivustaama dudueeyi? ¿Siaaco daraaja ʌgaa tuustaama? ");
INSERT INTO ntpNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mosʌca idi ismaacʌdʌ maitʌrjudíu aa gʌi dai siaa duutuda agai Diuusi ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dai amaasi potʌtʌdai ʌgai ʌcʌʌli: ―Cʌquivañi dai imʌda. Giñvaavoitu aapi cascʌdʌ dueeyi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Taidʌ ʌfariseo tʌcacai ʌSuusi sʌʌscadʌ ʌgai sigatʌaanʌda agai Diuusi tami oidigi daama, taidʌ ʌSuusi aa noragi dai potʌtʌdai: ―Siʌʌscadʌ gatʌaanʌdagi Diuusi tami maitʌrʌmo istumaasi ismaacʌdʌ maasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maita povʌcaitiada agai: “Tamia daja”, siʌʌpʌ “Mʌʌca daja”; Diuusi catanai gʌnsaagida gatʌaanʌi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dai amaasi potʌtʌdai ʌSuusi gʌmamaatʌrdamiga: ―Aimu istuigaco aapimʌ ipʌliadamu isgatʌaanʌda aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami tami tomasi ʌmo tasai dʌmos maiaimu amaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dai aa povʌntʌtʌadamu: “Tamia daja”, siʌʌpʌ “Mʌʌca daja”. Dʌmos maitavʌr ajioopada, tomali maioidatucuda. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Poduucai ismaascana siʌʌscadʌ vʌpʌdocʌdagi oidigi pomaascamu siʌʌscadʌ ajiagi istuigaco diviagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dʌmos ʌʌpʌga viaa aanʌ issʌʌlicʌdʌ soimaa taatagi, daidʌ ʌoodami sivi oidacami gajiaadʌrʌ giñviaamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Poduucai isducatai ʌpʌdui aidʌsi oidacatadai ʌNoee, poduucai ʌpʌduuñimu ʌʌpʌ siʌʌscadʌ cadivia iñaagada aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ʌoodami gacuaadana dai gayʌʌdana, dai cuucuntaiña, dai gamamaacaiña gʌnmaamara ooqui mʌsai ooñtaiña, asta aidʌ uucami sivaa ʌNoee gʌvaarcugʌrʌ tai sʌʌlicʌdʌ tʌvʌpi duudu tai vʌʌsi ʌoodami coi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Dai poduucai ʌpʌdui ʌʌpʌ aidʌsi oidacatadai ʌLota ʌoodami gacuaadana, dai gayʌʌdana, dai gasaapʌdaiña dai gaagaraiña, dai gaʌsaiña, daidʌ ivuaadana baabaqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dʌmos aidʌsi ii ʌLota Sodoomaiñdʌrʌ taí duudu tai ʌʌmadu asufre tʌvaagiaiñdʌrʌ, tai vʌʌsi oodami coi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Poduucai ʌpʌduuñimu ʌʌpʌ siʌʌscadʌ diviagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Amaasi isʌmaadutai vaaqui daama daacagi dai tuucavi viaacagi gʌvustuidaga maitʌaagai istʌvañiagi ʌgai dai vuvaidagi, dai isʌmaadutai dʌjiana aimʌrdagi maitʌaagai isimiagi ʌgai gʌquiiyamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gʌntʌgitovurai Lota ooñigadʌ isducatai muu vaamioma oigʌdatai gʌvustuidaga tami oidi daama siDiuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sioorʌ mostʌtʌgitodagi isducatai cʌʌgacʌrʌ oidacagi tami oidigi daama ʌgai tomali ʌmo istumaasi maiviaacamu gooquiʌrʌ, dai sioorʌ maitʌtʌgitodagi mosʌcaasi isducatai cʌʌgacʌrʌ oidacagi tami oidigi daama ʌgai sʌʌlicʌdʌ baigʌʌliadamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gʌnaagidiana sai amaasi tucarʌ goocatai abaana vʌʌtʌcamu siDiuusi bʌʌcaimu ʌmoco dai ʌgʌmai viaamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dai gooca ooqui ʌmapai gatuaadamu siDiuusi bʌʌcaimu ʌmoco dai ʌgʌmai viaamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dai gooca cʌcʌʌli dʌjiana daraajamu siDiuusi bʌʌcaimu ʌmoco dai ʌgʌmai viaamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Moscaʌcai ʌgaa imaasi tʌcacai dai potʌtʌdai: ―¿Vaaco ʌpʌduñia agai imaasi? ―astʌtʌdai. Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Tomasiaaco siaaco caatʌcagi baabaidi duvaligadʌ ami gʌnʌmpaidiña nunui poduucai ʌrvaavoi ʌʌpʌ saidʌ ʌpʌduuñia agai istumaasi aagai aanʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ɅSuusi aagidi ʌoodami ʌmo ñiooqui cuentocʌdʌ dai aagidi sai gʌaagai ismaiugutai daanʌdagi Diuusi dai maiiibiocorʌitai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Dai potʌtʌdai: ―Ʌmapʌcʌrʌ oidacatadai ʌmo dunucami ismaacʌdʌ maisiaa duutudaitadai Diuusi dai tomali maivuamʌ ʌliditadai tomaliʌ ʌmaadutaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dai amaasi ʌgai vaa dʌvʌʌriʌrʌ oidacatadai ʌʌpʌ ʌmo ooqui viuudu, ismaacʌdʌ cocodacatadai ʌmai dai aliʌ duudatai aimʌraiña ʌgai ʌdunucami quiidiamu dai potʌtʌdaiña sabai baiduiñdana ñiooqui ʌsaayudʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tʌvʌpi mospovuaadana ʌgai vaidʌ ʌdunucami moscaʌcana. Dʌmos gooquiʌrʌ povʌʌli: “Tomasi maisiaa duutudai aanʌ Diuusi dai maivuamʌ iñʌlidi tomali ʌmaadutaicʌdʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dʌmos idi ooqui viuudu apiagiñoojotuldi soiñamu aanʌ vai camaididivaitai giñoojotuldiña vaamioma”, ascaiti ʌdunucami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dai potʌtʌdai ʌSuusi: ―Poduucai aagai ʌdunucami maicʌʌ tuigacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Isbai maisoiñana Diuusi ʌʌpʌ ismaacʌdʌ ʌcovai vuvaitu ʌgai ismaacʌdʌ maiugutai taanʌdagi soiñi? ¿Isbai tʌvʌpicʌdʌ soiñana ʌgai? ");
INSERT INTO ntpNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aanʌ angʌnaagidi sai ʌgai gia otoma soiñamu. Dʌmos siʌʌscadʌ diviagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami, ¿isbai quiaa tʌʌgimu aanʌ oodami vaavoitudadami tami oidigi daama? ");
INSERT INTO ntpNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Daidʌ ʌSuusi aagidi ʌmai cuento chiʌʌquiatai vʌʌtarʌ ismaacʌdʌ siooma cʌʌga tuutiacami gʌnʌlidi siaa dai soiduucai nʌidi ʌgaa. Dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Gooca cʌcʌʌli iji ʌgʌʌ quiuupaigadʌamu judidíu dai gamamada agai. Ʌmoco ʌrfariseocatadai dai ʌgʌmai ʌrvuudamicatadai tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ʌfariseo cʌacatai gamamadai dai aduucai gamamadai: “GiñDiuusiga, aliʌ baigiñʌlidi aanʌ maitʌrʌpan ducamicatai aa ismaacʌdʌ ʌrʌʌsivogami dai ismaacʌdʌ ʌrsoimaasi ivuaadami, dai ismaacʌdʌ googosi gʌnducami aanʌ tomali maitʌrʌpan ducami idi vuudami tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dai aanʌ maitacueeyi gocuaja ʌmo ʌcaldiʌrʌ, dai aa gʌoidi aanʌ iñsmaacʌdʌ gamaitʌcʌi”. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dʌmos ʌvuudami tumiñsi baimʌʌcasdʌrʌ vii dai tomali maitʌpʌʌli tomali istaí nʌnʌaavagi tʌvaagiamu, mosgʌvai gʌmoo dai pocaiti: “GiñDiuusiga soigi gʌʌlda aanʌcʌdʌ aliʌsi ʌrsoimaasi ivuaadami aanʌ”, ascaiti ʌvuudami tumiñsi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aanʌ angʌnaagidi sai idi vuudami tumiñsi nora gʌquiiyamu caoigʌldicami soimaascamigadʌ dai ʌgʌmai gia chio. Tomasioorʌ ismaacʌdʌ gʌducʌdʌ gʌʌliadagi ʌgai maitʌrgʌducʌdʌcamicamu dai sioorʌ maigʌducʌdʌ gʌʌliadagi ʌgai ʌrgʌducʌdʌcamicamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dai aa oodami vuapaimi ʌʌpʌ aali siaaco daacatadai ʌSuusi, sai ʌgai taatana. Dʌmos aidʌsidʌ ʌmamaatʌrdamigadʌ ʌSuusi tʌʌ imaasi, bagaidimi ʌgai ismaacʌdʌ vuaapaimi ʌaali. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dʌmos ʌSuusi vaí gʌmamaatʌrdamiga dai potʌtʌdai: ―Dagitovurai vai dadana goaali siaaco daja aanʌ, dai maitavʌr daidiada. Ismaacʌdʌ ʌpan ducami idi aaliducʌdʌ ʌgai ʌgai ismaacʌdʌ ajioopai mʌʌca siaaco gatʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aanʌan sʌʌlicʌdʌ gʌnaagidi sioorʌ iimia ʌliada siaaco gatʌaanʌi Diuusi ʌgai gʌaagai siʌpan ducamica ʌmo ali dai ismaipoducamica ʌgai siaadʌrʌ vaacʌna ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ʌmaadutai ʌtʌtʌaanʌdami tʌcacai ʌSuusi dai potʌtʌdai: ―Mamaatʌtuldiadami cʌʌ tuigacʌdʌ, ¿tumaasi istutuidi aanʌ siduñiagi dai vʌʌscʌrʌ oidacagi Diuusi ʌʌmadu? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Taidʌ ʌSuusi potʌtʌdai: ―Mosʌca Diuusi cʌʌ tuiga dai tomali ʌmo imidagai maisoimaasi ivueeyi. Dai aapi maivaavoitudai iñsaanʌ ʌrDiuusi. Mosʌʌgi pocaiti aapi ansai aanʌ ʌrcʌʌ tuigacami dai tomali ʌmo imidagai maisoimaasi ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aapi cʌʌga maatʌ istumaasi gatʌaanʌi Diuusi: “Maitavʌr googosi gʌnducamica, maitavʌr gacoodada, maitavʌr gaʌʌsiada, maitavʌr yaatagʌda aa, dai siaavʌr duutuada gʌnooga ʌʌmadu gʌndʌʌ”, podu gatʌaanʌi Diuusi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Taidʌ ʌcʌʌli potʌtʌdai: ―Vʌʌsi gomaasi aan aliducatai abiaadʌrʌ ʌʌgidi ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Amaasi caʌcai ʌSuusi imaasi potʌtʌdai: ―Dʌmos quiaa viʌʌga ʌmo istumaasi pʌsiduñiagi, gagarañi vʌʌsi pʌstumaasi viaa dai oida ʌsoituutuigami ʌtumiñsi, dai poduucai viaacamu aapi vaamioma tʌvaagiʌrʌ. Imiñi dai poduuñi dai diviacai giñoidatucuda ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dai aidʌsi caʌ ʌcʌʌli imaasi, aliʌ soigʌʌli, aliʌsi ʌrgʌviidacamicatadai ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dai tʌʌgacai ʌSuusi isaliʌ soigʌʌli ʌgai potʌtʌdai: ―Gia sijaiga isgʌnviipidacami iimiagi siaaco gatʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Siooma maisijaiga ʌmo muura vʌʌtarʌ isdaivuñiagi ʌmo oi dʌgadʌamu sʌʌli isʌmo gʌviidacami imiagi siaaco gatʌaanʌi Diuusi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dai ʌgai ismaacʌdʌ caʌ imaasi potʌtʌdai: ―¿Vooriatai istutuidido iscʌʌgacʌrʌ vuvaquiagi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Taidʌ ʌSuusi potʌtʌdai: ―Istumaasi oodami maitistutuidi isiduñiagi Diuusi gia istutuidi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Taidʌ ʌPiiduru potʌtʌdai: ―Mamaatʌtuldiadami, aatʌmʌ viaa vʌʌsi tʌstumaasi viaacatadai, gʌoidatucuda ʌrʌliditai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Amaasi ʌSuusi aa noragi dai potʌtʌdai: ―Sʌʌlicʌdʌ angʌnaagidi tomasioorʌ ismaacʌdʌ viaagi gʌquii, siʌʌpʌ gʌdʌʌdʌ, siʌʌpʌ gʌsusuuculi, siʌʌpʌ gʌooñiga, siʌʌpʌ gʌmaamara iduñia ʌliditai Diuusi aa duiñdadʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ʌgai sioon mui viaacamu idi oidi daama dai gooquiʌrʌ ʌgʌmai oidigʌrʌ vʌʌscʌrʌ oidacamu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ɅSuusi ʌcovai vaí ʌbaivustaama dan gooca gʌmamaatʌrdamiga dai potʌtʌdai: ―Siviatʌ iimiagi Jerusaleenamu, siaaco gʌaagai isʌpʌduñiagi vʌʌsi istumaasi ooja ʌDiuusi ñiñiooquituldiadamigadʌ giñaagaitai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Giñtʌʌgida magai aa sibʌadʌrʌ oidacami, dai giñparunada magai, dai soimaasi ñiooqui giñsuuligiada agai, dai giñsisiviada agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Dai giñgʌicarsa magai, dai gooquiʌrʌ giñmuaamu, dʌmos bo vaica tasaicʌdʌ ʌpamu duaacamu aanʌ coidadʌ saagidaiñdʌrʌ ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dʌmos ʌmamaatʌrdamigadʌ maimaatʌ caʌ tomali ʌmo istumaasi idi maasi, tomali maimaatʌcatadai ʌgai istumaasi aagidi ʌSuusi, goovai ʌrʌmo istumaasicatadai istumaasi maitistutuiditadai ʌgai ismaatʌ caʌcagi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aidʌsidʌ ʌSuusi caaijimitadai Jericooʌrʌ vai voi ugidiana daacatadai ʌmo maiñʌaadami daidʌ gataanʌitadai oidicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dai aidʌsi caʌ ʌgai ismui iimʌdan caitimi oodami, ʌmaiñʌaadami gatʌcacai astumaasi ʌpʌduitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mʌtai potʌtʌdai sai amui imʌitadai ʌSuusi Nasareetʌrʌ oidacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tai ʌgai iiña dai pocaitimi: ―Suusi Davi maradʌ soigi gʌʌlda aanʌcʌdʌ ―ascaiti ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dʌmos ʌgai ismaacʌdʌ baitʌqui iimʌitadai bagaimi sai camaiiiñacaiña vaamioma. Dʌmos ʌgai apiaiiñacai dai pocaiti: ―Davi maradʌ soigi gʌʌlda aanʌcʌdʌ ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Amaasi ʌSuusi cʌquiva dai ootoi sioorʌ vuaapagi ami siaaco daacatadai ʌgai. Dai aidʌmʌsi caami vuaa taidʌ ʌSuusi tʌcacai dai potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tumaasi ipʌlidi aapi iñsiʌduiñda aanʌ? ―astʌtʌdai. Taidʌ ʌcʌʌli ismaacʌdʌ maiñʌaadatadai aa noragi dai potʌtʌdai: ―Mamaatʌtuldiadami, nʌada iñʌlidi aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Taidʌ ʌSuusi potʌtʌdai: ―Nʌaadañi, vaavoitu aapi cascʌdʌ nʌnʌaava ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mospotʌi ʌgai taidʌ ʌismaacʌdʌ maiñʌaadatadai istui isnʌnʌaavagi, dai oí ʌSuusi dai siaa duutudaimi Diuusi. Dai vʌʌsi ʌoodami ismaacʌdʌ tʌʌ imaasi siaa duutuli Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Taidʌ ʌSuusi aayi ami Jericooʌrʌ dai amui daivusquimi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Vai ami oidacatadai ʌmo cʌʌli gʌviidacami Zaqueo tʌʌgiducami, dai ʌgai ʌrbaitʌcʌaacamigadʌcatadai tumiñsi vuudami. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Daidʌ ʌZaqueo matia ʌliditadai ʌSuusi, dʌmos maitistutuiditadai istʌgiagi aliʌ maitʌcavacatadai ʌZaqueo cascʌdʌ dai oodami aliʌ muiducatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Vai ʌgai maitʌtʌgaitadai isducatai matiagi dai amaasi baitʌqui mʌʌ dai tʌsai ʌmo uusi tʌcavacamiʌrʌ voiyʌrʌ siaaco viaacatadai ʌSuusi isdaivuñiagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dai aidʌsi amui daivusquimi ʌSuusi tʌcavi nʌnʌaava dai potʌtʌdai: ―Zaqueo otoma itʌvañi boodʌrʌ sivi anviaa aanʌ isgʌquiiyʌrʌ giñuuliñagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Taidʌ ʌZaqueo otoma tʌvai, dai baigʌʌliaracʌdʌ miaadʌgi ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amaasi tʌʌgacai ʌoodami imaasi vʌʌscatai ñiooquidimi ʌSuusi dai pocaitimi saidʌ ʌSuusi ʌmo soimaasi ivuaadami quiidiʌrʌ gʌuuli. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Amaasi ʌZaqueo cʌquiva dai potʌtʌdai ʌSuusi: ―Dañi, mamaatʌtuldiadami oidamu aanʌ ʌsoituutuigami taajucami vʌʌsi giñvustuidaga iñsmaacʌdʌ viaa dai iñsiʌmaadutai ʌʌsi aanʌ vuiirumadacai aa noragidamu aanʌ asta macovaco vaamioma ismaacʌdʌ ʌʌsi aanʌ ―astʌtʌdai ʌZaqueo. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Taidʌ ʌSuusi potʌtʌdai: ―Idi cʌʌli cavaavoitu Diuusi isduucai vaavoitu aduñdʌ Avraañicaru cascʌdʌ siviat aayi cʌʌgacʌrʌ vuvaidaragai idi quiiyʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami divia dai gaaga iñagai dai cʌʌgacʌrʌ vuvaida iñagai soimaasi ivuaadami ʌgai ʌrsibʌiimiadʌ Diuusi vʌʌtarʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dai camiaanai daacatadai ʌgai Jerusaleena daidʌ ʌoodami povʌnʌliditadai iscaotoma gatʌaanʌda agai Diuusi oidi daama cascʌdʌ aidʌsi quiaa tʌtʌgitoitadai ʌoodami ismaacʌdʌ aagidi ʌSuusi, ʌgai aagidi ʌmo ñiooqui cuentocʌdʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","dai potʌtʌdai: ―Ʌmo imidagai oidacatadai ʌmo cʌʌli dai vʌʌsi ʌaaduñdʌ ʌrtʌtʌaanʌdamicatadai daidʌ ʌrgʌnviipidacamicatadai. Dai mʌʌcasi ii ʌgai ʌmai dʌvʌʌriʌrʌ mʌsiaaco daasa agaitadai raí dai gooquiʌrʌ ʌpamu divia agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dai maiquiaa imʌcai vaí baivustaama gʌpipiooñiga dai vʌʌscatai ʌʌmadutai maa tumiñsi dai potʌtʌdai: “Aa duiñtuldavurai idi tumiñsi asta siʌʌscadʌ divia aanʌ”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dʌmos ʌgʌmai dʌvʌʌriʌrʌ oidacami aliʌ cʌʌdaitadai dai imʌcai ʌgai tai ʌgaa gooquiamu ootoi chiʌʌqui cʌcʌʌli sai potʌʌdana: “Maitatʌta ipʌlidi aatʌmʌ isaapi ʌrgʌrtʌaanʌdamicagi”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mʌtai vʌʌscʌrʌ daí ʌgai gatʌaanʌdami duucai tai ʌpamu nora. Amaasi aʌcai gʌquiiyʌrʌ vaí ʌgai gʌpipiooñiga ismaacʌdʌ vii ʌgai tumiñsi dai maatʌca agai sʌʌjʌqui gamaitʌ ʌʌmadutai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ʌʌʌpʌgadadʌ divia dai potʌtʌdai: “Giñaamu, gʌtumiñsiga gamaitʌ baivustaamaojo vaamioma”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Taidʌ ʌraí aa noragi dai potʌtʌdai: “Cʌʌgaduava aapiapʌ ʌrʌmo cʌʌ piooñi cacʌʌga idui aapi laachicʌdʌ sivi gia gʌdaasamu aanʌ caigi pai tʌaanʌda baivustaama quiiqui”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tai gooquiʌrʌ divia ʌmai dai potʌtʌdai: “Giñaamu, gʌtumiñsiga gamaitʌ taamojo vaamioma”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Taidʌ ʌaamudʌ aa noragi dai potʌtʌdai: “Aapi ʌrcaigicamu ʌʌpʌ dai tʌaanʌdamu taama quiiqui”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tai gooquiʌrʌ divia ʌmai dai potʌtʌdai: “Giñaamu, tanai daja gʌtumiñsiga giñpañiitugʌrʌ vuraca aanʌ dai baidasaca. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gʌʌʌbʌñi aanʌ. Maatʌ aanʌ isaliʌ oomaliga aapi cascʌdʌ. Dai maita aata vueeyi dai vʌʌscʌrʌ vuuyi tumiñsi, dai aa gʌʌsituldi pai aapi mosvuuyi yoovisicami”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Amaasi ʌraí potʌtʌdai: “Aapiapʌ ʌrʌmo piooñi maicʌʌ tuigacami. Gʌñiooquicʌdʌ maatʌ aanʌ isaapi ʌrgʌduñi dai maicʌʌ dui. Iscamaatʌcatadai aapi siaanʌ ʌroomaligami dai ismaitaaata vueeyi aanʌ dai vʌʌscʌrʌ vuuyi tumiñsi dai isaa giñʌsituldi dai isaanʌ mosvuuyi yoovisicami. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Camaatʌcatadai aapi ¿tuipʌsi maitamaa gotumiñsi sibʌacoga mʌsiaaco gamaitʌmudai vaamioma ʌtumiñsicʌdʌ simuiyoma vuimudai aanʌ diviacai?” astʌtʌdai aamudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amaasi potʌtʌdai ʌgai ʌgaa ismaacʌdʌ ami daraajatadai: “Bʌivurai gotumiñsi dai maaca ʌgai ismaacʌdʌ viaa baivustaama”, astʌtʌdai ʌraí. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tai ʌgai potʌtʌdai: “Gʌraamu, ʌgai caviaa baivustaama”, astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Taidʌ ʌraí aa noragi dai potʌtʌdai: “Aanʌ angʌnaagidi sai ismaacʌdʌ viaa vaamioma gʌmaacai dai ismaacʌdʌ maiviaa gʌvoopoidi tomasi ʌlaachi ismaacʌdʌ viaaca ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dai ʌoodami ismaacʌdʌ giñvui vʌʌtʌ dai maitipʌliditadai isiʌrtʌaanʌdamica aanʌ, vuaapavurai dai giñvuitapi cooda”, astʌtʌdai ʌraí gʌpipiooñiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Dai amaasi caaagacai ʌSuusi imaasi ʌpamu apiaimʌitadai Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dai aidʌsi caaijimitadai ʌSuusi Betapagiʌrʌ dai Betaaniʌrʌ miaanai ʌgiidi siaaco Oliivosi tʌʌgidu, ʌSuusi ootoi gooca gʌmamaatʌrdamiga, ");
INSERT INTO ntpNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","dai potʌtʌdai: ―Iimivurai mʌʌ aali quiiquiʌrʌ ismaacʌdʌ miaaga tabiaadʌrʌ dai aʌcai tʌʌgimu aapimʌ ʌmo asñiitu vulicami ismaacʌdʌ tomali ʌmaadutai maiquiaa dadaʌjʌi vʌrai uupana dai vuaapa. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dai isʌmaadutai gʌntʌcacagi mʌstuisi uupasai vʌrai potʌʌda ansai aanʌ tʌgito ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Amaasi ʌmamaatʌrdamigadʌ iji dai tʌʌ vʌʌsi isducatai aagidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dai aidʌsi uupasaitadai ʌgai ʌasñiitu taidʌ ʌsoigacami tʌcacai dai potʌtʌdai: ―¿Tuimʌsi uupasai goasñiitu? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tai ʌgai aa noragi dai potʌtʌdai: ―Ʌmamaatʌtuldiadami tʌgito cascʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amaasi bʌidacai ʌgai ʌasñiitu ʌSuusi, dai asñiitu daama darai gʌnsosua dai daama daí ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dai aidʌsi asñiitu daama imʌitadai ʌSuusi ʌoodami voiyʌrʌ ʌʌligaimi gʌnsosua. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dai aidʌsi camiaadimi ʌgai coidama gʌʌsʌcʌrʌ ʌOliivosi giidiaiñdʌrʌ, vai vʌʌscatai ʌvaavoitudadami ismaacʌdʌ oiditadai iiñaquimi baigʌnʌliatugaitai dai siaa duutudaimi Diuusi vʌʌsi ʌismaacʌdʌ gʌgʌrducamicʌdʌ ismaacʌdʌ tʌʌtadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dai pocaitimi: ―Diuusi aliʌ cʌʌgacʌrʌ nʌidi goovai ismaacʌdʌ divia Diuusi guvucadadʌcʌdʌ. Vʌʌscatai gʌniibʌstacan tada tʌvaagiʌrʌ aatʌmʌ aliʌ siaa duutudai Diuusi ―ascaitimi ʌvaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amaasi ʌʌmoco ʌfariseo ismaacʌdʌ ʌoodami saagida daraajatadai potʌtʌdai ʌgai ʌSuusi: ―Mamaatʌtuldiadami bagaidañi gʌmamaatʌrdamiga ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dʌmos ʌSuusi aa noragi dai potʌtʌdai: ―Aanʌ angʌnaagidi sai isidi maiiiñacadagi sʌʌlicʌdʌ goojoodai iiñacadamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dai aidʌsi caaijimitadai ʌgai Jerusaleenʌrʌ dai tʌʌgacai Jerusaleena ʌSuusi sosua ʌoidacamicʌdʌ ");
INSERT INTO ntpNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","dai pocaiti: ―Gia ipʌlidi aanʌ issivi maatʌ caʌcagi gooidacami isducatai istutuidi isgʌniibʌstacan tadacagi dʌmos maitistutuidi goovai ismaatʌ caʌcagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aimu istuigaco sicolimagi sasaayudʌ dai sicoli curartamu, dai vʌʌsi aipadʌrʌ cocodamu, ");
INSERT INTO ntpNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","vʌʌsi dʌvʌʌrapi suuligamu dai coodamu dai vʌʌsi Jerusaleenʌrʌ maiviimu tomali ʌmo odai ʌmai daama. Aidʌsi diviji aanʌ ismaacʌdʌ ʌrDiuusi tai maitiñmiaadʌgi gooidacami cascʌdʌ ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amaasi ʌSuusi vaa ʌgʌʌ quiuupaigadʌrʌ judidíu dai vuvaitu ismaacʌdʌ ami gagaagaraitadai dai ismaacʌdʌ gasaapʌdaitadai, ");
INSERT INTO ntpNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","dai potʌtʌdai: ―Diuusi ñiooquidʌrʌ pocaiti: “Giñquiiavʌr mamadaragai vʌʌtarʌ”. Mai aapimʌ tʌjogadʌ ʌʌsivogami duucai nʌidi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ɅSuusi vʌʌs tasai gamamaatʌtuldiña Diuusi ñiooquidʌ ʌgʌʌ quiuupaigadʌrʌ judidíu, dʌmos ʌbaitʌguucacamigadʌ ʌpapaaligadʌ judidíu ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ, dai ʌʌmadu ʌdudunucamigadʌ ʌoodami gaagaitadai isducatai muaagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dʌmos vʌʌsi ʌoodami cʌʌga gʌntʌgito caʌcatadai iscaiti ʌSuusi cascʌdʌ maitʌtʌgaitadai ʌgai isducatai muaagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ʌmo imidagai ʌgʌʌ quiuupaigadʌrʌ judidíu daacatadai ʌSuusi dai mamaatʌtulditadai ʌoodami Diuusi ñiooquidʌ ʌʌmadu cʌʌgacʌrʌ vuvaidaragai, tai ami dada ʌbaitʌguucacamigadʌ papaaligadʌ ʌjudidíu ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ, ʌʌmadu aa baitʌguucacami, ");
INSERT INTO ntpNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","dai potʌtʌdai ʌgai ʌSuusi: ―Gʌraagidañi, ¿tuma sʌʌlicamicʌdʌ pomaasi ivueeyi aapi? ¿Toorʌ gʌmaa gosʌʌlicami? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Amaasi ʌSuusi potʌtʌdai: ―Aanʌan ʌʌpʌ gʌntʌcacagi ʌmo istumaasi vʌrai giñaagida: ");
INSERT INTO ntpNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Toorʌ ootoi ʌVuaana sai gavapaconana? ¿Diuusi oodami sio? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dʌmos vʌʌsi ʌbaitʌguucacami ʌʌgi aipaco gʌnaatagidimi dai pocaiti: ―¿Istʌʌdamu aatʌmʌ? Ispotʌʌda aatʌmʌ sai Diuusi ootoi goovai otoma gʌraa noragidamu dai povʌrtʌʌdamu: “¿Tuimʌsi maivaavoitu?” ");
INSERT INTO ntpNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dai ispotʌʌda aatʌmʌ sai oodami ootoi, vʌʌscatai gooodami gʌrcoodian tada ojoodaicʌdʌ, vʌʌscatai goovai sʌʌlicʌdʌ vaavoitudai siʌVuaana ʌrDiuusi ñiooquituldiadamigadʌ ―ascaiti ʌbaitʌguucacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dai amaasi aa noragi ʌgai ʌSuusi dai potʌtʌdai sai maimaatʌ sioorʌ ootoi ʌVuaana sai gavapaconana. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Amaasi ʌSuusi potʌtʌdai: ―Tomali aanʌan maitʌnaagidagi istuma sʌʌlicamicʌdʌ ivueeyi aanʌ imaasi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Amaasi ʌSuusi gʌaagacai aagidi ʌoodami, dai aagidi ʌmo ñiooqui cuentocʌdʌ dai potʌtʌdai: ―Oidacatadai ʌmo cʌʌli ismaacʌdʌ ʌi uuvasi gʌdʌvʌʌragana, dai gooquiʌrʌ taajucamicʌdʌ maa ʌgai aa oodami gʌʌʌsi dai ii abiaadʌrʌ sibʌaco dai tʌvʌpi daja. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dai aidʌsi aayi yoovaragai ʌgai ootoi ʌmoco gʌpiooñiga sai taanʌna ʌgai ʌoodami ʌyoovi siʌʌsi aʌʌcatadai, dʌmos ʌoodami gʌicacarai dai soi doodai dai ootoi maimaacacai istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Amaasi ʌtuidacami ootoi ʌmai piooñi, mʌtai ʌgai ʌʌpʌ aliʌ soimaasi ñiooqui aagidi dai gʌicacarai dai ootoi maimaacacai istumaasi aagaimi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Daidʌ ʌtuidacami ootoi ʌmai, dʌmos ʌoodami aliʌ soi doodai ʌgai ʌʌpʌ dai aadaji. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dai cagooquiʌrʌ pocaiti ʌtuidacami ʌdʌvʌʌrai: “¿Isducatai iduuñimu aanʌ? Ootosamu aanʌ giñmara tomasi aliʌ oigʌdai aanʌ, siaadʌrʌ maisiaa duutudadan tadacana ʌgai siuu duucu tʌgiagi”, ascaiti ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dʌmos aidʌsidʌ ʌaata vuaadami tʌʌ gʌamo maradʌ aipaco gʌnaatagidimi dai pocaiti: “Idi ʌgai ismaacʌdʌ ʌrtuidacamica agai oogadʌ vustuidadʌ gʌaagai tʌsmuaagi dai poduucai aatʌmʌ ʌrtutuidacamicamu”, ascaiti ʌaata vuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dai amaasi vuusaitu ami dʌjiaiñdʌrʌ dai muaa. Amaasi ʌSuusi tʌcacai ʌoodami dai potʌtʌdai: ―¿Isduuñimu ʌdʌvʌʌrai tuidacami ʌaata vuaadami? ");
INSERT INTO ntpNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Divimu ʌgai dai coodimu dai maaquimu ʌdʌvʌʌrai aa oodami ―astʌtʌdai ʌSuusi. Moscaʌcai ʌgai imaasi maí isʌgai aagadamʌ ʌlidi ʌSuusi cascʌdʌ pocaiti ʌgai: ―Diuusi maidagitona ispovʌ duñiagi ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dʌmos ʌSuusi vui nʌnʌava dai potʌtʌdai: ―¿Tʌiya ʌlidi idʌ goovio ismaacʌdʌ oojisi Diuusi ñiooquidʌrʌ siaaco pocaiti?: Ʌodai ismaacʌdʌ gajiaadʌrʌ viaa ʌbaabaquitadami sivi ʌgai ʌrʌgai ismaacʌdʌ vaamioma gʌaagai ʌvaaqui vʌʌtarʌ. Asduu oojisi Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tomasioorʌ ismaacʌdʌ utuvagi ʌodiʌrʌ moslalachi daivamu, dai isʌodai daama gʌsiagi ʌmai ʌgai mosʌtuisamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ʌbaitʌguucacamigadʌ ʌpapaaligadʌ judidíu ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ ipʌliditadai isaidʌ otoma bʌjiagi ʌSuusi, cʌʌga maatʌcatadai ʌgai isʌgai vʌʌtarʌ aagaitadai ʌSuusi ʌcuento cascʌdʌ, dʌmos ʌʌbʌiditadai ʌgai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dai amaasi ootoi sioorʌ soobidacagi vai ʌgai cʌʌ tuutiacami gʌnvueeyi, dai gaagai isducatai aagagi ʌSuusi ʌmo istumaasi istumaasi vui caatʌcagi ʌdudunucami vai poduucai tʌʌgida ʌgai ʌdudunucami. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Cascʌdʌ tʌcacai ʌgai dai potʌtʌdai: ―Mamaatʌtuldiadami, cʌʌ maatʌ aatʌmʌ sai ismaacʌdʌ gaaagidi aapi dai gamamaatʌtuldi ʌrvaavoi. Dai maivuaamʌ ʌlidi aapi oodamicʌdʌ siʌrgʌnviipidacami siʌrsoitutuigami ʌʌpʌ, mosgamamaatʌtuldi aapi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gʌraagidañi, ¿cʌʌgaisi tʌsaa namʌʌquiadagi ʌgʌʌ baitʌcʌaacami romano cho sio? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dʌmos ʌSuusi maatʌ tʌʌ isʌgai vuiirumada ʌliditadai dai potʌtʌdai: ―¿Tuimʌsi giñvuiirumada ʌlidi aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Giñtʌʌgidavurai aapimʌ ʌmo tumiñsi. ¿Voorʌ moodʌ dai voorʌ tʌʌtʌaradʌ tumiñsiʌrʌ daja? ―astʌtʌdai ʌSuusi. Tai ʌgaa aa noragi daidʌ itʌtʌdai: ―Ʌgʌʌ baitʌcʌaacami moodʌ dai tʌʌtʌaragadʌava ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Taidʌ ʌSuusi potʌtʌdai: ―Maacavurai ʌgʌʌ baitʌcʌaacami istumaasi ʌrtuidadʌ dai maacavurai Diuusi istumaasi ʌrDiuusi tuidadʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tai ʌgai maitistui issoimaasi ñiooquitudagi oodami vuitapi baiyoma maitʌʌ ʌgai isducatai gʌntʌtʌgituagi caʌcatai isducatai ñioocai ʌSuusi dai cascʌdʌ maiñioocacai vii. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dai gooquiʌrʌ iji ʌʌmoco ʌsaduseo siaaco daacatadai ʌSuusi. Ʌsaduseo pocaiti sai maioidaga coidadʌ duaacaradʌ cascʌdʌ potʌtʌdai ʌgai ʌSuusi: ");
INSERT INTO ntpNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Mamaatʌtuldiadami, ʌMoseesacaru oojisicami gʌrvii vai pocaiti sai ismuquiagi ʌmo cʌʌli dai viaagi gʌooñiga maiquiaa maamatacai abaana, saidʌ ʌsucuulidʌ ʌcʌʌli gʌaagai isvʌʌnagi ʌviuudu dai maamatagi abaana ʌsiʌʌgidʌ vʌʌtarʌ ismaacʌdʌ muu. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dai ʌmo imidagai oidacatadai cuvaracami ʌmo siʌʌgʌmʌ, ʌʌpʌgadadʌ ooñigai dʌmos muu maiquiaa maamatacai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Amaasi ʌgooquiʌrdadʌ vʌʌna ʌviuudu, dai muu ʌʌpʌ maiquiaa maamatacai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tai gooquiʌrʌ ʌgʌmai vʌʌna ʌgai vaa ooqui, dai muu ʌʌpʌ maiquiaa maamatacai, vʌʌ cuvaracami podui dai vʌʌsi coi maimaamatacai tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dai amaasi muu ʌooqui ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dai duduaacacai coidadʌ saagidaiñdʌrʌ, ¿ismaacʌdʌ ʌrcunadʌcamu ʌooqui vʌʌsi ʌrcuucunadʌcatadai ʌgai di? ―astʌtʌdai ʌsaduseo. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Amaasi ʌSuusi aa noragi dai potʌtʌdai: ―Tami oidigi daama cʌcʌʌli dai ooqui cuucuntai dai ooñtai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dʌmos ʌgai ismaacʌdʌ Diuusi maaquiagi oigaragai isiimiagi tʌvaagiamu caduduaacacai coidadʌ saagidaiñdʌrʌ mʌʌca maitʌcuucuntai tomali maitʌmamacai gʌnmaamara cuucuntaragai vʌʌtarʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","mʌʌca camaitʌcooyi cascʌdʌ. Moscaduduaacacai ʌgai ʌpan ducamica agai Diuusi tʌtʌaañicarudʌ ʌgai ʌrDiuusi maamaradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moseesa ʌʌpʌ gʌrmamaatʌtuldi sai duduaacarʌi coidadʌ siaaco gʌaagai ʌali uusi ismaacʌdʌrʌ mʌi taí daidʌ ʌuusi maimʌi ami gʌaagai ʌʌpʌ sai Diuusi ʌrAvraañicaru dai Isaacaru dai Jacocaru Diuusigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dʌmos Diuusi maitʌrDiuusigadʌ ʌgai ismaacʌdʌ ʌDiaavora ʌʌmadu ajioopai coocai, baiyoma ʌrDiuusigadʌ ʌgai ismaacʌdʌ ʌgai ʌʌmadu ajioopai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Amaasi ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ potʌtʌdai: ―Cʌʌga aagai aapi mamaatʌtuldiadami ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dai camaitʌpʌnʌʌli isvaamioma tʌcacagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Taidʌ ʌSuusi potʌtʌdai: ―¿Ducatai pocaiti aapimʌ saidʌ ʌCristo ʌrDavi maradʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Vaidʌ ʌDavi aduucai ooja Salmosi liivrugadʌrʌ: Ʌtʌaanʌdami potʌtʌdai giñtʌaanʌdamiga: “Gʌmaaquimu aanʌ ʌmo sʌʌlicami ismaacʌdʌ vaamioma namʌga. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Dai ugititudamu aanʌ vʌʌsi ismaacʌdʌ gʌvuidʌrʌ vʌʌtʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Dʌmos ducatai istutuidi ʌCristo siʌrmaradʌcagi ʌDavi vai ʌʌgi ʌDavi giñtʌaanʌdamiga aagai? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vʌʌsi ʌoodami caʌcatadai aidʌsi ʌSuusi potʌtʌdai gʌmamaatʌrdamiga: ");
INSERT INTO ntpNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Cʌʌgavʌr gʌntʌtʌgitoca aapimʌ. Maitavʌr ʌpan duucai ivuaada gomamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Goovai oojoidi iscʌcʌʌgaducami yuucustadagi, dai ipʌlidiña mʌscocoanadagi gʌnvapaanamu dai viaatuldiadagi cacaayana, dai cʌcʌʌgaducʌdioma daraicariʌrʌ oojoidi isdadarʌdagi judidíu quiquiuupaigadʌrʌ, dai siaaco gacuaada goovai cʌcʌʌgaducʌdioma daraicariʌrʌ oojoidi isdadarʌdagi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dai ʌʌsidiña goovai ʌʌpʌ ʌvipiuudu baabaquidʌ dai tʌvʌpi gamamadaiña sai nʌidiña ʌoodami. Goovai ʌgai ismaacʌdʌ vaamioma soimaa taatatuldamu Diuusi ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dai ʌSuusi tʌʌ ʌgʌʌ quiuupaigadʌrʌ judidíu ʌgʌnviipidacʌdʌ ismaacʌdʌ tueeyi tumiñsi cajojooñiʌrʌ ismaacʌdʌrʌ gʌʌmpaidi tumiñsi Diuusi aa duiñdadʌ vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dai tʌʌ ʌʌpʌ ʌmo viuudu soitigami ismaacʌdʌ ami cajooñiʌrʌ darai goo sintaavu, ");
INSERT INTO ntpNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tai potʌi ʌSuusi: ―Sʌʌlicʌdʌ angʌnaagidi sai idi viuudu soitigami vaamioma daí isvʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vʌʌscatai gogaa darai ismaacʌdʌ cababaivitocʌi, dʌmos goooqui soitigamicatai modaí vʌʌsi ismaacʌdʌ viaacatadai istuucʌdʌ oidacagi ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dai ʌʌmadutai aagai ʌgʌʌ quiuupaigadʌ judidíu dai pocaiti sai aliʌ sigia maasi ʌquiuupai ʌojoodaicʌdʌ sigia maascamicʌdʌ dai aa ʌmamaasicʌdʌ ismaacʌdʌ aa ami darai sai sigia maascana ʌquiuupaigadʌ judidíu. Tai amaasi ʌSuusi potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Aimu siʌʌscadʌ vʌʌsi idi mʌsmaacʌdʌ nʌidi aapimʌ vʌʌsi siaa gʌduuñimu, dai maiviimu tomali ojoodai goocua daama ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tai ʌgai tʌcacai dai potʌtʌdai: ―Mamaatʌtuldiadami, ¿vʌʌscadʌ ʌpʌduñia agai imaasi? ¿Ducatai maatʌmu aatʌmʌ isimaasi casiʌpʌduñia agai? ―astʌtʌdai ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Taidʌ ʌSuusi potʌtʌdai: ―Gʌntʌgitovʌr nʌijada, dai maitavʌr gʌndagito mʌsgʌnvupuiirumadadagi, dadiava agai muidutai giñtʌʌtʌaaragacʌdʌ dai pocaitiadamu ʌgai: “Aanʌ anʌrʌCristo”, dai “Casiat aayi istuigaco ugitia agai oidigi”. Dʌmos maitavʌr oidatucuda. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dai mʌsiʌʌscadʌ cajiomacagi muiyapʌrʌ cocoodi, maitavʌr duduaadicuda gomaasi daivuñia agai ʌʌpʌga, dʌmos maiquiaa aayi cugatʌrʌ tasʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dai bodʌrʌ apiaaatagidimi vaamioma dai potʌtʌdai: ―Ʌmo dʌvʌʌriʌrʌ oidacami cocoaadamu ʌmai dʌvʌʌriʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dai aliʌ cavami gigivucudamu ʌʌmapʌcʌrʌ gooidigi, dai oidacamu biuugigai dai coocodagai aipacoga, dai tʌvaagiʌrʌ duaadimudaca maascamu istumaasi dai naana maasi gʌgʌrducami maascamu ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dʌmos ʌʌpʌga gʌnsasaayu gʌnvuimu dai soimaasi gʌntaatatuldamu, dai vaama gʌntuutusada agai ʌgai ʌtʌtʌaanʌdami vuidʌrʌ ʌgai vaa ismaacʌdʌ gatʌaanʌi quiquiuupaigadʌrʌ judidíu, dai gʌnmaamaisapada agai dai vaama gʌntutusada agai ʌraraí vuidʌrʌ dai moomoyi vuidʌrʌ giñvaavoitudaitai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Amaasi tuigaco istutiaadamu aapimʌ isaagadagi ʌgai vuitapi isvaavoitudai aapimʌ istumaasi gamamaatʌtuldi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dai maibai vuaada ʌʌquiasdʌrʌ isducatai aa noragidagi ʌgai ismaacʌdʌ gʌpiʌrʌ gʌnsusuuligadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aanʌ gʌnmaaquimu maatʌdagai dai ñiooqui isducatai gʌnsoiña aapimʌ dai poduucai gʌnsasaayu maiviaacamu isducatai gʌnaa noragidagi tomali maitʌnvui ñioocadamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dai asta gʌndʌʌdʌ dai gʌnsusuuculi dai gʌnsiisiʌgi dai gʌnaaduñi aagiada agai gʌnsasaayu mʌsiaaco daraaja aapimʌ. Dai gʌncooditudamu aapimʌ ʌʌmadutai. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dai vʌʌsi oidacami gʌncʌʌdadamu giñvaavoitudaitai aapimʌ, ");
INSERT INTO ntpNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","dʌmos maisibʌ imimu tomali ʌmo cuupai gʌnmooaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dʌmos aapimʌ apiavaavoitudadamu dai mʌsiʌʌscadʌ dʌgavuñiagi vʌʌsi gosoimaa taataragai gooquiʌrʌ vʌʌscʌrʌ oidacamu aapimʌ Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mʌsiʌʌscadʌ nʌijadagi iscasicoolimadi sandaaru Jerusaleenʌrʌ, maatʌcamu aapimʌ iscaotoma vʌʌsi siaa gʌduuñimu. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Amaasi ismaacʌdʌ Judeeʌrʌ daraajagi gʌaagai isvoopiagi gigiidiamu, dai sioorʌ Jerusaleenʌrʌ daraajagi gʌaagai isvuvaaquiagi abiaadʌrʌ, dai sioorʌ dʌjiaadana ajioopadagi maitʌaagai isʌpamu iimiagi gʌnquiiquiamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Amaasi ʌgai istuigaco soimaasi taatatulda agai Diuusi ʌjudidíu ismaacʌdʌ vuidʌrʌ vʌʌtʌcagi Diuusi. Poduucai ʌpʌduñia agai ismaacʌdʌ oojisi Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Siʌ soimaa taatamu ʌooqui ismaacʌdʌ amaasi noonoacagi siʌʌpʌ viaacagi aali siisiʌdami aliʌ oidacamu soimaa taataragai oidi daama, dai sʌʌlicʌdʌ soimaasi gʌʌgʌvituldaragai idi oodami Jerusaleenʌrʌ oidacami vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ʌʌmoco coimu cocodiʌrʌ, dai aa sibʌadʌrʌ oidacami maamaisapicami vuimu aa dai vuucaimu. Dai ismaacʌdʌ maitʌrjudidíu gatʌaanʌda agai Jerusaleenʌrʌ asta siʌʌscadʌ uucami Diuusi maquiagi oigaragai. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Dai amaasi oidacamu maasidaragai tasiʌrʌ dai masaadiʌrʌ dai sisiaavugiʌrʌ, dai tami oidigi daama vʌʌsi oidacami maitʌtʌgadamu isducatai gʌntʌtʌgitodagi aliʌ duduaadicudamu ʌgai aliʌ sigal caititai ʌgʌʌ suudagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ʌoodami susuiiquitʌrdamu duduaadicuitai dai tʌtʌgitoitai istumaasiʌrʌ istumaasi daivuñia agai oidigi daama, asta tʌvaagi gigivucudamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dai amaasi giñtʌʌgimu aapimʌ aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami iñsiboodʌrʌ imʌdamu ʌmo icomai saagida guvucadagaicʌdʌ dai sʌʌlicʌdʌ dadadaquidatai. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Siʌʌscadʌ casi ʌpʌvuiidagi imaasi vʌrai taí nʌnʌnda moscamiaadʌidatai mʌstuigadʌ cʌʌgacʌrʌ gʌnvuvaida agai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dai aagidi ʌʌpʌ ʌmo ñiooqui cuentocʌdʌ dai potʌtʌdai: ―Nʌidavurai goiigosi siʌpʌ tomastuma ʌmai uusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mʌsiʌʌscadʌ nʌijadagi iscaiipoidagi aagadʌ, aapimʌ camaatʌcana iscamiaadimi toiñdagai. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dai poduuquiavʌr maatʌca ʌʌpʌ mʌsiʌʌscadʌ nʌijadagi gomaasi vʌrai maatʌca iscamiaadimi istuigaco gatʌaanʌda agai Diuusi tami oidi daama. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sʌʌlicʌdʌ angʌnaagidi sai vʌʌsi imaasi ʌpʌduñia agai maiquiaa ugitʌcai idi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tʌvaagi ʌʌmadu oidigi ugitimu, dʌmos ismaacʌdʌ aagai aanʌ goovai gia ʌpʌduñia agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Todian duucai aimu Diuusi ʌpan duucai isduucai gʌcucuupai ʌmo trampa dai vʌʌsi oidi daama oidacami maatʌmu imaasi, cascʌdʌ gʌntʌgitovʌr nʌijada dai maigajiaadʌrʌ vipiaada Diuusi mosgayʌʌdatai dai tʌtʌgitoitai istumaasi oidaga oidi daama. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Baigavʌr ʌnduca aapimʌ tudu, dai tomastuigaco avʌr gamamadada dai poduucai istuidimi aapimʌ iscʌʌgacʌrʌ vuvaaquiagi vʌʌsi gomaasiaiñdʌrʌ ismaacʌdʌ ʌpʌduñia agai, dai poduucai istuidimu isgiñvuidʌrʌ guuquivagi aapimʌ aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ɅSuusi gamamaatʌtuldiña tasʌrʌ ʌgʌʌ quiuupaigadʌrʌ judidíu dai tucarʌ aimʌraiña dai giidiana cocosʌiña siaaco Oliivosi tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dai vʌʌsi ʌoodami ʌʌqui quiamoco ʌgʌʌ quiuupaigadʌrʌ judidíu daivʌiña caʌca ʌliditai istumaasi aagidiña ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aidʌ camiaadimitadai ʌsiaa duudagai istuigaco tʌtʌgitoiña ʌjudidíu aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ. Ʌsiaa duudagai pascua tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Vaidʌ ʌpapaaligadʌ ʌjudidíu baitʌguucacamigadʌ ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ gaagaitadai isducatai muaagi ʌSuusi, dʌmos aliʌ ʌʌbʌiditadai ʌgai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tai amaasi ʌDiaavora vaa ʌUudasiʌrʌ, mʌsmaacʌdʌ Iscaliote aagaiña ʌʌpʌ, ʌgai ʌrʌmoco ʌbaivustaama dan gooca ismaacʌdʌ ʌrʌSuusi ojootosadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Daidʌ ʌUudasi nʌidamu ʌpapaaligadʌ ʌjudidíu baitʌguucacamigadʌ ʌʌmadu sandaaru ʌgʌʌ quiuupaigadʌrʌ judidíu dai ʌgʌʌ quiuupiʌrʌ sandaaru dai ʌʌmadu gaaataga dai aagidi isducatai istutuiditadai ʌgai istʌʌgidagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tai ʌgai aliʌ baigʌnʌʌli dai aagidi ʌgai ʌUudasi sai maquia agai tumiñsi, ");
INSERT INTO ntpNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","taidʌ ʌUudasi bai aa dai gʌaagacai gaa isducatai gatʌʌgidagi ʌSuusi siʌʌscadʌ maitiipucagi aa oodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tai amaasi aayi ʌsiaa duudagai istuigaco tʌtʌgitoiña ʌjudidíu aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ dai aidʌ coodaiña ʌjudidíu cañiiru dai dadasdiña Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Taidʌ ʌSuusi ootoi ʌPiiduru ʌʌmadu ʌVuaana, dai potʌtʌdai: ―Iimivurai dai bai duuñi cuaadagai idi siaa duudagai vʌʌtarʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tai ʌgai tʌcacai dai potʌtʌdai: ―¿Vaaco ipʌlidi aapi tʌsbai duñiagi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Taidʌ ʌSuusi aa noragi dai potʌtʌdai: ―Mʌsiuu duucu ajiagi ʌquiiquiʌrʌ, tʌʌgimu aapimʌ ʌmo cʌʌli ismaacʌdʌ vaigʌtica agai ʌmo aayi suudagi vʌrai oida siaaco vaquia ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dai tʌcacavurai ʌquiʌʌcami saaco cʌʌca ʌtuucavi siaaco gaugia iñagai aanʌ idi siaa duudagʌrʌ ʌʌmadu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Siʌgai gʌntʌʌgidamu ʌmo tuucavi gʌducami goocua daama vaaquiʌrʌ tʌcaviacoga cabai duñisicami vʌrai ami bai duuñi cuaadagai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tai ʌgai iji dai tʌʌ vʌʌsiaʌcatai isducatai aagidi ʌSuusi, dai bai dui ʌcuaadagai siaa duudagai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dai caaʌcai ugidagai, taidʌ ʌSuusi meesa vuidʌrʌ daiva ʌʌmadu gʌojootosa. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Taidʌ ʌSuusi potʌtʌdai gʌojootosa: ―Gia ipʌliditadai aanʌ isgʌnʌʌmadu gaugiagi idi siaa duudagʌrʌ maiquiaa muucucai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aanʌ angʌnaagidi ansai sivi gaugia iñagai idi siaa duudagʌrʌ cuaadagai dai camaitacuaada iñagai idi siaa duudagʌrʌ cuaadagai asta siʌʌscadʌ idui Diuusi vʌʌsi istumaasi iduñia agai dai cʌʌgacʌrʌ vuvaidagi oidi daama oidacami diviacai ʌgai dai gatʌaanʌda tami oidigi daama. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Amaasi bʌi ʌmo tucayu uuvasi varaagadʌ dai gamamagi dai gooquiʌrʌ maa gʌmamaatʌrdamiga daidʌ itʌtʌdai: ―Vʌʌscatai avʌr ii idi tucayuaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sʌʌlicʌdʌ angʌnaagidi ansai camaitayʌʌda iñagai uuvasi varaagadʌ asta siʌʌscadʌ aiyagi istuigaco diviagi Diuusi dai nʌidagi oodami ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dai gooquiʌrʌ bʌi ʌpaana dai gamamagi dai gooquiʌrʌ saasarai dai maa gʌmamaatʌrdamiga, daidʌ itʌtʌdai: ―Idiav ʌrʌpan ducami giñtuucuga mʌsmaacʌdʌ gatʌʌgida agai mʌsai muaana mʌsai aapimʌ cʌʌgacʌrʌ vuvacʌna. Poduuquiavʌr ivuaada daidʌ giñtʌtʌgitoda ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dai cauugitocai ʌSuusi bʌi ʌtucayu dai potʌtʌdai gʌmamaatʌrdamiga: ―Idi uuvasi varaagadʌ ismaacʌdʌ idi tucayuana daja ʌpan ducami giñʌʌra ismaacʌdʌ aastia agai mʌsai aapimʌ cʌʌgacʌrʌ vuvacʌna. Iñsiʌʌscadʌ muquiaagi vai aastia giñʌʌra aidʌ abiaadʌrʌ gʌaagadamu goñiooqui utudui ismaacʌdʌ Diuusi ootosda agai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dʌmos sivi gocʌʌli ismaacʌdʌ giñtʌʌgida agai ʌdudunucami tami meesa daama caatʌ novidʌ giñʌpan duucai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami cabʌʌcaiti govoi ismaacʌdʌ gʌaa ʌʌqui abiaadʌrʌ dʌmos siʌʌ soimaa taatamu ʌcʌʌli ismaacʌdʌ giñtʌʌgida agai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Amaasi ʌmamaatʌrdamigadʌ aipaco gʌntʌcacaimi soorʌ ʌgai dai gatʌʌgida agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Amaasi ʌmamaatʌrdami ʌʌgi gʌnvupui ñiñio aagaitai sai ismaacʌdʌ vaamioma ʌrtʌaanʌdamica agai siʌʌscadʌ iimiagi siaaco gatʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dʌmos ʌSuusi potʌtʌdai: ―Ismaacʌdʌ maitʌrjudidíu saagida ʌbaitʌcʌaacamigadʌ gʌpipiooñiga duucai nʌidiña ʌoodami, dai ʌgai aadʌrʌ ipʌlidi mʌscʌʌga tuutiacami duucai nʌijadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dʌmos aapimʌ maitʌaagai mʌspoduucai ivuaadagi, baiyoma ismaacʌdʌ ʌrbaitʌcʌaacamicagi gʌaagai isvaamioma gʌʌli gʌvuaadagi dai piooñi duucai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Maacʌdʌ ʌrvaamioma tʌaanʌdami ismaacʌdʌ meesa vuidʌrʌ daja ismaacʌdʌ gabiaajai sio? ¿Maitasi ʌrvaavoio sai ismaacʌdʌ meesa vuidʌrʌ daja? Dʌmos aanʌ gʌnsaagida daja ʌmo piooñi duucai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aapimʌ vʌʌscʌrʌ giñʌʌmadu daraajana aidʌsi soimaa taatamaiña aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Cascʌdʌ aanʌ gʌnmaaquia iñagai ʌmo sʌʌlicami poduucai isduucai giñooca giñmaa aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dai aapimʌ giñʌʌmadu gacuaadamu mʌʌca siaaco gatʌaanʌda iñagai aanʌ dai giñsoiña tʌaanʌdamu aapimʌ Diuusi maamaradʌ ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Amaasi potʌi ʌʌpʌ ʌSuusi: ―Simuñi, Simuñi, ʌDiaavora taí oigaragai Diuusi isgʌduiñdagi mui naana maasi soimaascami mʌsai camaitiñvaavoitudaiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dʌmos aanʌ daanʌi Diuusi aapimʌ gʌnvʌʌtarʌ vai maivʌʌsi ugitʌna gʌnvaavoidaraga, dai siʌʌscadʌ ʌpamu cʌʌga giñvaavoituda aapi pai soiña gʌaaduñi vai vaamioma cʌʌga giñvaavoitudana ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Taidʌ ʌSimuñi aa noragi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, baigan giñduu isgʌoidagi maisacaruamu dai asta muquiaagi gʌʌʌmadu ―astʌtʌdai Simuñi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Taidʌ ʌSuusi potʌtʌdai: ―Piiduru, sʌʌlicʌdʌ angʌaagidi sai sivi maiquiaa cuujuicai tacucu pʌaapi vaicojo potʌiya agai pʌsai maitiñmaatʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Taidʌ ʌSuusi potʌtʌdai: ―Aidʌsidʌ gʌnootoi aanʌ maimoraraaliacami dai tomali tumiñsi daraasacarucami, dai tomali aa sususacaicʌdʌ ¿isbai viʌʌgacatadai aapimʌ istumaasi? ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. Tai ʌgai aa noragi dai potʌtʌdai: ―Tomali ʌmo istumaasi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tai amaasi ʌSuusi potʌtʌdai: ―Sivi angʌnaagidi sai sioorʌ viaacagi moraali gʌaagai isbʌʌ aimʌrdagi, dai tumiñsi darasacarui ʌʌpʌ, dai sioorʌ maiviaacagi maastai vai gagarana ʌmoco gʌvaasaraga dai savʌdana. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aanʌ angʌnaagidi sai gʌaagai siʌpʌduñiagi isducatai ooja Isaíacaru Diuusi ñiooquidʌrʌ siaaco icaiti: “Soi duucai mʌnʌijada agai tomastuma soimaasi iducami duucai”. Istumaasi oojisi giñaagaitai gʌaagai siʌpʌduñiagi ―astʌtʌdai ʌSuusi gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tai ʌgai potʌtʌdai: ―Mamaatʌtuldiadami, tami vʌʌtʌ gooca mamaastai ―astʌtʌdai. Tai ʌgai aa noragi dai potʌtʌdai: ―Cascʌdʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Amaasi ʌSuusi vuusai dai ii Oliivosi giidiamu poduucai isduucai ivuaadana ʌgai taidʌ ʌmamaatʌrdamigadʌ oí. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Amaasi aʌcai ami giidiʌrʌ, taidʌ ʌSuusi potʌtʌdai gʌmamaatʌrdamiga: ―Daanʌdavurai aapimʌ Diuusi vai ʌgai maidagitona ʌDiaavora issoimaasi gʌnduiñtuldagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Taidʌ ʌSuusi ʌcovai ii maisi mʌʌcasi ʌpan ʌʌ mʌʌcasi siʌʌsi vuupai ʌmoco ʌmo odai, dai gʌtootonacʌdʌ cʌquiva dai gamamada agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Dai aduucai gamamagi: ―Giñooca isbaigacamudai ismaisoimaa taata aanʌ poduucai isducatai ʌpʌduñia agai dʌmos vaidʌ ʌpʌduuna pʌsducatai aapi ipʌliadagi. Dai maisiu istumaasi aanʌ ipʌliadagi ―asduucai gamamagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tai amaasi vuitapi gʌmaasitu ʌmo Diuusi tʌaañicarudʌ tʌvaagiaiñdʌrʌ dai vaamioma maquia agai guvucadagai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dai aliʌ soimaa taatacatai vaamioma daanʌi Diuusi dai vaajurdadʌ ʌpan duucai ootai ʌʌrai dai dʌvʌʌrapi gʌʌsʌi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Dai aidʌsi canaato mamagi ʌgai cʌquiva dai ii siaaco daraajatadai ʌmamaatʌrdamigadʌ dai coocosʌcami tʌʌ, gamaitʌ soiʌliaragai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Daidʌ ʌSuusi potʌtʌdai: ―¿Tuimʌsi coocosʌ? Vaapaigivurai, dai daanʌda Diuusi vai ʌgai maidagitona ʌDiaavora issoimaasi gʌnduiñtuldagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dai quiaa ñiooquiditadai ʌSuusi, tai ami aayi mui oodami. Dai ismaacʌdʌ Uudasi tʌʌgiducatadai ʌbaivustaama dan gooca mamaatʌrdamiaiñdʌrʌ, ʌgai baitʌqui imʌitadai ʌoodami, dai miaadʌrʌ cʌquiva dai usupiga agai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Amaasi ʌSuusi potʌtʌdai: ―Uudasi, ʌmo ¿usupigaicʌdʌ pʌsgiñtʌʌgida agai aapi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tai ʌgai ismaacʌdʌ ʌʌmadu daraajatadai ʌSuusi dai nʌiditai istumaasi iduñia agaitadai ʌgai tʌcacai ʌSuusi dai potʌtʌdai: ―Mamaatʌtuldiadami, ¿vuidʌrʌ tʌssuuligʌna mamaastaicʌdʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dai ʌmaadutai ʌgai iquitʌ sʌʌlisia padʌrʌ naacadʌ ʌpiooñigadʌ ʌbaitʌcʌaacamigadʌ papaaligadʌ ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dʌmos ʌSuusi potʌtʌdai: ―Dagitovurai casia cʌʌgadu ―astʌtʌdai. Taidʌ ʌSuusi mostaata ʌpiooñi naacadʌ tai dueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dai amaasi ʌSuusi potʌtʌdai ʌbaitʌguucacamigadʌ papaaligadʌ ʌjudidíu, ʌʌmadu ʌgʌʌ quiuupiʌrʌ sandaaru, ʌʌmadu ʌsonʌrʌ guucacami judidíu ʌgai ismaacʌdʌ dada dai bʌʌquia agai: ―¿Ducatai dada aapimʌ mamaastaicʌdʌ dai uusicʌdʌ ducami iñsaanʌr ʌmo ʌʌsivogamicagi? ");
INSERT INTO ntpNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aidʌsi gʌnʌʌmadu daacatadai aanʌ vʌʌs tasai ʌgʌʌ quiuupaigadʌrʌ judidíu tomali maitiñtaata aapimʌ, dʌmos sivi casigʌnajʌga aapimʌ tucagi ʌrDiaavora aa duiñdadʌ vʌʌtarʌ cascʌdʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tai amaasi ʌgai maisapicami bʌi ʌSuusi, dai bʌʌcai ʌbaitʌcʌaacamigadʌ papaali quiidiamu, vaidʌ ʌPiiduru mosmʌʌcasdʌrʌ oidi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tai aa ami tuisiqui ʌraana ganai, dai taicovai daraiva, taidʌ ʌPiiduru saagida daiva ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tai amaasi ʌmo cusñiiru tʌʌgacai istaicovai daacatadai ʌgai, gʌtʌgito nʌnʌidi daidʌ itʌtʌdai: ―Idi cʌʌli ʌʌpʌ ʌʌmadu aimʌraiña gomaisapicʌdʌ ―astʌtʌdai ʌcusñiiru. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dʌmos ʌPiiduru ʌsto, daidʌ itʌtʌdai: ―Maitanmaatʌ aanʌ gocʌʌli di ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tai gooquiʌrioma, ʌmai cʌʌli tʌʌ daidʌ itʌtʌdai: ―Aapiapʌ ʌrʌmoco gomaisapicʌdʌ aduñdʌ ʌʌpʌ ―astʌtʌdai. Dʌmos ʌPiiduru itʌtʌdai: ―Cho, maitanmaatʌ aanʌ gocʌʌli di ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tai bo laascʌdʌ ʌmai itʌi: ―Sʌʌlicʌdʌ idi cʌʌli ʌʌmadu aimʌraiña gomaisapicʌdʌ ʌʌpʌ daidʌ ʌrGalileeʌrʌ oidacami ʌʌpʌ ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Taidʌ ʌPiiduru itʌi: ―Cho, aanʌ tomali maimaatʌ mʌsioorʌ aagai aapimʌ ―astʌtʌdai ʌPiiduru. Dai quiaa ñioocaitadai ʌgai tai cuujui tacucu. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Taidʌ ʌSuusi vui nʌnʌaava ʌPiiduru, taidʌ ʌPiiduru tʌgito istumaasi aagidi ʌmamaatʌtuldiadami, sai maiquiaa cuujuicai tacucu ʌgai vaicojo ʌstua agaitadai ismaatʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Taidʌ ʌPiiduru vuusai abiaadʌrʌ dai soigʌʌldacai sosua. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Daidʌ ʌcʌcʌʌli ismaacʌdʌ nuucadacatadai ʌSuusi parunai dai saasarai tuucugadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dai iiña vuupuidʌ dai vuivasana gʌvai, daidʌ itʌtʌdai: ―¿Maatʌñi toorʌ gʌgʌʌgʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dai aagidi mui naana maasi ñiooqui sigalnascami. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dai aidʌsi casi ʌrtasʌrʌcatadai, gʌnʌmpagi ʌjudidíu sonʌrʌ guucacamigadʌ, ʌʌmadu ʌbaitʌguucacamigadʌ ʌpapaaligadʌ ʌjudidíu, ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ, mʌtai vaan cʌi ʌSuusi dudunucami vuidʌrʌ mʌtai ami tʌcacai, daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Gʌraagidañi povai pʌscaiti aapi pʌsaidʌ ʌrʌCristo ismaacʌdʌ Diuusi ʌcovai vuusaitu pʌsai cʌʌgacʌrʌ gʌrvuvaidana? ―astʌtʌdai. Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Ispovʌntʌʌda aanʌ sai ʌjʌ, siaadʌrʌ giñvaavoitudana aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Dai isgʌntʌcaca aanʌ ʌmo istumaasi siaadʌrʌ giñaa noragidana aapimʌ tomali maitiñdagituan taada aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dai aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami caotoma imimu Diuusi ʌʌmadu dai ʌʌmadu gatʌaanʌda iñagai, ismaacʌdʌ vaamioma viaa guvucadagai istomali ʌmo ʌmai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tai amaasi vʌʌscatai tʌcacai ʌSuusi daidʌ itʌtʌdai: ―¿Aidʌ gia aapi ʌrDiuusi maradʌ? ―astʌtʌdai. Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌjʌ Diuusi maradʌana poduucai mʌsduucai aagai aapimʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tai ʌgai itʌi: ―¿Tuisidʌ nʌnʌracana aatʌmʌ vaamioma nʌijadami cacaʌcatai isʌʌgi gʌtʌñicʌdʌ gʌraagidi goovai? ―ascaiti ʌbaitʌguucacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Amaasi vʌʌscatai ʌbaitʌguucacami bʌʌcai ʌSuusi dai Pilaato vuidʌrʌ cʌi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dai ami gʌpiʌrʌ vuupaimi daidʌ icaiti: ―Tʌʌ aatʌmʌ idi cʌʌli vai sisioquitudai gʌraaduñi daidʌ icaiti sai maitʌaagai tʌsaa namʌquiadagi ʌgʌʌ baitʌcʌaacami romano, daidʌ icaiti ʌʌpʌ sai sʌʌlicʌdʌ ʌrʌCristo goovai ismaacʌdʌ ʌrraí ʌʌpʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Amaasi ʌPilaato tʌcacai daidʌ itʌtʌdai: ―¿Aapipʌsi ʌrʌjudidíu raígadʌ? ―astʌtʌdai. Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ʌjʌ poduuquiava pʌsducatai aagai aapi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Amaasi ʌPilaato itʌtʌdai ʌbaitʌguucacamigadʌ papaali ʌʌmadu ʌoodami: ―Maitantʌtʌgai tomali ʌmo istumaasi soimaascami idi cʌʌliʌrʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dʌmos ʌoodami vaamioma gʌgʌrʌ aagidi daidʌ itʌtʌdai: ―Goovai sisioquitudai vʌʌsi Judeeʌrʌ oidacami gʌmamaatʌtuldaragacʌdʌ, Galileeaiñdʌrʌ abiaadʌrʌ gʌaaga goovai dai asta tami ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dai aidʌsi caʌ ʌPilaato imaasi gatʌcacai sabaigʌ ʌrGalileeʌrʌ oidacami ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Dai aidʌmʌsi aagidi sai ʌjʌ, tai ʌgai ootosi ʌEroodʌsi ismaacʌdʌ ʌrtʌaanʌdamicatadai Galileeʌrʌ dʌmos aidʌ Jerusaleenʌrʌ daacatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Taidʌ ʌEroodʌsi aliʌ baigʌʌli tʌʌgacai ʌSuusi ʌʌquioma abiaadʌrʌ nʌida ʌliditadai ʌgai cajioomacatadai ʌgai dai nʌida ʌlidiña isivuaada ʌgai ʌmo istumaasi gʌgʌrducami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Daidʌ ʌEroodʌsi naana maasi tʌcacai, dʌmos ʌSuusi maiaa noragi tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Dai ami daraajatadai ʌʌpʌ ʌbaitʌguucacamigadʌ ʌpapaaligadʌ ʌjudidíu ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ, ʌgai aliʌ goguama gʌpiʌrʌ vuupai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Amaasi ʌEroodʌsi ʌʌmadu ʌsandaarugadʌ soi duucai nʌidi ʌSuusi, dai mosparunda ʌlidi ʌgai dai cʌʌga dadapacami aadi yuucusi ʌmo raí duucai. Amaasi ʌEroodʌsi ootosi ʌpamu ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dai aidʌ tasʌrʌ gʌnaaduñta ʌPilaato ʌʌmadu ʌEroodʌsi ʌʌquioma ʌrgʌnsasaayumʌcatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Amaasi ʌPilaato ʌmpagi ʌbaitʌguucacamigadʌ papaali ʌʌmadu ʌtʌtʌaanʌdami ʌʌmadu ʌoodami, ");
INSERT INTO ntpNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","daidʌ itʌtʌdai: ―Aapimʌ mʌtaiñvuaapi idi cʌʌli pocaititai sai goovai sisioquitudai oodami, nai aanʌ catʌcacai aapimʌ gʌnvuitapi dai canʌidi aapimʌ iñsmaitʌtʌgai istumaasicʌdʌ gʌpiʌrʌ caatʌcagi goovai tomali ʌmo istumaasicʌdʌ mʌstuucʌdʌ gʌpiʌrʌ vuupai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tomali ʌEroodʌsi baiyoma ʌpamu gʌrootosi ʌgai canʌidi aapimʌ ismaitʌristuma ducami goovai tomali maiviaa aatʌmʌ istuisidʌ muaagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mossoimaa taatatuldamu aanʌ dai gooquiʌrʌ dagitomu ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilaato aidʌ siaa duudagʌrʌ viaacatadai isdagitoldagi ʌoodami ʌmaadutai ʌmaamaisapicʌdʌ poduucai ivuaadana ʌgai vʌʌsi uumigi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tai vʌʌsi ʌoodami ʌmapai ijiña dai pocaiti: ―Vaidacaivurai goovai dai muaa dai dagito Baraavási ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraavási ʌmpagi oodami dai cocotuli ʌbaitʌguucacami ʌʌmadu daidʌ ʌrgamuaacamicatadai ʌʌpʌ mai cascʌdʌ maisacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Vaidʌ Pilaato dagitua ʌliditadai ʌSuusi, dai aagidi ʌoodami ʌpamu. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dʌmos ʌgai vaamioma ijiña daidʌ icaiti: ―Siisañi curusiaba. Siisañi curusiaba ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dai amaasi cavaicʌrʌ itʌtʌdai ʌPilaato: ―¿Tuma soimaasi iducami goovio? Aanʌ maitʌtʌgai istuisi muaagi, soimaa taatatuldamu aanʌ dai dagitomu ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dʌmos ʌoodami vaamioma gʌgʌr ñiooquimi daidʌ icaiti mʌsai curusiaba siisana, dai mosʌʌ gʌgʌr ñiooquimi ʌgai mʌsai siisana curusiaba mʌtai poduucai idui isducatai aagai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Taidʌ ʌPilaato ipʌli isiduñiagi mʌsducatai aagidi, ");
INSERT INTO ntpNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","dai dagito ʌcʌʌli ismaacʌdʌ ʌoodami ipʌli, ʌgai ismaacʌdʌ maisapicatadai gamuaacamicatai dai cocotuldacai ʌoodami. Taidʌ ʌPilaato tʌʌgi ʌSuusi ʌoodami saidʌ iduuna ʌgaicʌdʌ istumaasi ipʌliadagi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dai aidʌsi vaidaticatadai ʌgai ʌSuusi dai curusiaba siisa agai, dai caayana aayi ʌmo cʌʌli Sireñiʌrʌ oidacami ismaacʌdʌ dʌjiaiñdʌrʌ imʌitadai Simuñi tʌʌgiducami, mʌtai bʌi dai tʌjai sai gooquiʌrʌ imʌiña ʌSuusi dai bʌʌcaticana ʌcurusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dai oiditadai mui oodami dai mui ooqui ʌʌpʌ oiditadai dai gʌgʌrʌ suaañimi dai iiñaquimi soigʌnʌliditai nʌiditai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dʌmos ʌSuusi vui nʌnʌaava daidʌ itʌtʌdai: ―Ooqui Jerusaleenʌrʌ oidacami maitavʌr suaanʌda soimaa taatacatai aanʌ baiyomavʌr suaanʌda mʌsiʌʌscadʌ soimaa taatacagi aapimʌ ʌʌmadu gʌnmaamara giñvaavoitudaitai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aimu istuigaco aliʌ soimaasi gʌtaatamu dai povʌcaitiada agai: “Siʌʌ baigʌnʌlidi ʌooqui ismaacʌdʌ maitistutuidi ismaamatadagi dai ʌgai ismaacʌdʌ tomali ʌmo imidagai maimaamatai”. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Dai amaasi ʌoodami ipʌliadamu isdaama suuligiagi ʌgigiidi dai sai iiñana. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Canʌidi aapimʌ siʌ soimaasi giñtaatamituldi gooodami maitʌristuma ducamicatai aanʌ, dʌmos nʌidamu aapimʌ siʌ soimaa taatamu goovai ismaacʌdʌ ʌrsoimaasi iducami ―astʌtʌdai ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dai vaidaticatadai ʌʌpʌ gooca ʌʌsivogami dai ʌʌmadu coodia agai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dai amaasi aʌcai mʌʌca siaaco Calavera tʌʌgidu ami curusiaba siisa ʌSuusi, ʌʌmadu ʌvʌgoocai gʌpiʌrʌ vʌʌtʌcami. Ʌmoco ʌmo curusiaba sʌʌlisia padʌrʌ ʌSuusi dai ʌgʌmai ʌmai curusiaba oogisia padʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dai aidʌmʌsi curusiaba siisapaitadai ʌSuusi tai ʌgai itʌi: ―Giñooca oigʌldañi idi oodami maitamaatʌ goovai istuma vueeyi ―astʌtʌdai ʌSuusi. Daidʌ ʌsandaaru tʌcavi dadaitudai tumiñsi dai nʌida agai sooriatai gʌntaacoida agai ʌSuusi yuucusdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vaidʌ ʌoodami nʌiditadai ami daraajatai, dai asta ʌtʌtʌaanʌdami parunaitadai ʌSuusi daidʌ icaiti: ―Cʌʌgacʌrʌ vuvaitu goovai aa dai sivi ¿tuisidʌ maicʌʌgacʌrʌ gʌvuusaida ʌlidi goovai ʌʌgi? Issʌʌlicʌdʌ ʌrʌCristo goovai di daidʌ ʌrDiuusi ʌcovai vuusaidadʌ ―ascaiti ʌtʌtʌaanʌdami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Daidʌ ʌsandaaru ʌʌpʌ parunai dai miaadʌrʌ gugucai dai iituda agaitadai valienti maisi cʌʌgaducami ");
INSERT INTO ntpNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","daidʌ itʌtʌdai ʌʌpʌ: ―Pʌsaapi ʌrraígadʌ judidíu di cʌʌgacʌrʌ igʌvuusaida aapi ʌʌgi ―astʌtʌdai ʌsandaaru. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dai moodʌ daanioma oojisicatadai gilieegocʌdʌ dai latiiñicʌdʌ dai evreocʌdʌ, siaacoga icaiti: “Idiavʌr raígadʌ judidíu”, ascaiti ʌoojai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ʌmaadutai ʌgʌpiʌrʌ vʌʌtʌcʌdʌ ismaacʌdʌ ami saigiʌcatadai parunai ʌgai cascʌdʌ itʌtʌdai: ―Pʌsaapi ʌrCristo cʌʌgacʌrʌ igʌvuusaida aapi ʌʌgi dai cʌʌgacʌrʌ gʌrvuvaida aatʌmʌ ʌʌpʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dʌmos ʌgʌmai bagaimi gʌaduñi daidʌ itʌtʌdai: ―¿Maitapʌs ʌʌbʌidi Diuusi? Aapi ʌʌpʌ soimaasi taataca ʌpan duucai goovai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dʌmos aatʌmʌ gia viaa istucʌdʌ soimaasi taatacagi, soimaasi idui aatʌmʌ cascʌdʌ. Dʌmos idi cʌʌli maitidui tomali ʌmo soimaasi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dai amaasi itʌtʌdai ʌgai ʌSuusi: ―Pʌsiʌʌscadʌ aiyagi pʌsiaaco gatʌaanʌda agai pai giñtʌgito ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ angʌaagidi pʌsai sivi giñʌʌmadu daaca agai tʌvaagiʌrʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Aidʌsi casi ʌrdaan duucucatadai vʌʌsi oidigi tucapi vii uruno taadaco uucami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tasai mostucapi vii, taidʌ ʌgʌʌ icuusi vaamioma covoocami siʌmo sueeyi ismaacʌdʌ ʌgʌʌ quiuupaigadʌrʌ judidíu sagiʌcatadai ʌran sʌʌli sarai sʌʌliacoga tʌcavidʌrʌ abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Amaasi ʌSuusi gʌgʌrʌ iiña daidʌ itʌi: ―Giñooca gʌviituldagena giñibʌdaga ―astʌtʌdai. Dai mospotʌi ʌgai dai muu. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dai aidʌsidʌ ʌsandaaru tʌaanʌdamigadʌ ismaacʌdʌ ʌrromano nʌiditai istumaasi ʌpʌduitadai, siaa duutuli Diuusi daidʌ icaiti: ―Sʌʌlicʌdʌ ʌrvaavoi isidi cʌʌli maitʌrsoimaasi iducamicatadai ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Dai vʌʌsi ʌoodami ismaacʌdʌ ami daraajatadai dai nʌidi istumaasi ʌpʌdui, iji abiaadʌrʌ dai gʌvimi gʌnmoomo. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dʌmos vʌʌscatai ismaacʌdʌ maatʌcatadai ʌSuusi mʌʌcasdʌrʌ guucacatai nʌidi imaasi ʌʌmadu ʌooqui ismaacʌdʌ oiditadai Galileeaiñdʌrʌ abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Dai oidacatadai ʌmo cʌʌli cʌʌ tuigacami dai maitʌrsoimaasi ivuaadami, Osee tʌʌgiducami, Arimateeʌrʌ oidacami Judeea dʌvʌʌriʌrʌ. Dai ʌgai ʌrʌmo tʌaanʌdami ismaacʌdʌ tʌcacaiña mʌsmaacʌdʌ vaan tutusaiña. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ʌgai nʌnʌracatadai istuigaco gatʌaanʌda agai Diuusi, cascʌdʌ maibai aagaitadai ʌgai isducatai idui ʌgaa baitʌguucacami. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dai amaasi ʌgai nʌidamu ʌPilaato dai taí ʌSuusi tuucugadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dai tʌvaañdacai curusiaiñdʌrʌ ʌmo icuusi tuaacamiʌrʌ biisa dai ʌmo tʌjoovai tʌʌ mʌsiaaco tomali ʌmaadutai maiquiaa yaasa ʌmai muuquiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aidʌ ʌrʌtasaicatadai istuigaco bai vuaadana ʌgai vʌʌsi dai siaadiqui ʌribʌstaragaicatadai istuigaco maitistuma vuaadana ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Daidʌ ʌooqui ismaacʌdʌ oiditadai ʌSuusi Galileeaiñdʌrʌ abiaadʌrʌ iji dai nʌnʌidi ʌtʌjoi dai gʌntʌgito nʌnʌidi mʌsducatai tʌʌ ʌmuuquiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dai aidʌsi quiiyana dada ʌgai bai dui asaiti sigian uuvadami dai siaadiqui ibʌstaragʌrʌ gʌniibʌsi poduucai isducatai gʌnviidacatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dai siaadiqui tuucamidʌrʌ tasʌrʌ ʌʌcaldiʌrʌ, ʌooqui ʌʌqui quiaamoco iji siaaco caatʌcatadai ʌSuusi tuucugadʌ dai vuucaticatadai ʌsigian uuvaicʌdʌ ismaacʌdʌ bai duitadai ʌgai dai tʌida agaitadai ʌmuuquiadʌ dai aa ooqui ʌʌpʌ oiditadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dai aidʌsi aayi ʌgai gʌntʌgito tʌʌ isʌodai ismaacʌdʌ ʌcʌdʌ cuupicatadai ʌtʌjoi iscamaianaasi daacatadai, ");
INSERT INTO ntpNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tai ʌgai vaapa dʌmos maitʌʌ ʌgai ʌSuusi tuucugadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dai ʌgai aliʌ duduaadimucatadai dai tomali maimaatʌcatadai istuma duñiagi, dai tʌʌ gooca cʌcʌʌli vai sonuana guucacatadai dai dadadacʌi yuucusidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Daidʌ ʌooqui cuicʌsacatadai duduaadimucai taidʌ ʌcʌcʌʌli itʌtʌdai: ―¿Tuimʌsi gaagai coidadʌ saagida ʌgai ismaacʌdʌ duaaca? ");
INSERT INTO ntpNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maita tami daja ʌgai duaacata. Gʌntʌgitovurai isducatai gʌnaagidi ʌgai aidʌmʌsi quiaa Galileeʌrʌ daraajatadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Aidʌsi povʌntʌtʌdai ʌgai sai ʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami gʌaagaitadai mʌstʌʌgidagi soimaasi ivuaadami, dai sai bo vaica tasaicʌdʌ duaaca agaitadai ―astʌtʌdai ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tai ʌgai gʌntʌgito ʌñiooqui ismaacʌdʌ aagidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dai iimʌcai abiaadʌrʌ ʌooqui iji dai mʌʌ aagidi vʌʌsi imaasi ʌbaivustaama dan ʌmoco ʌSuusi ojootosadʌ ʌʌmadu vʌʌscatai ʌgaa. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ʌooqui ismaacʌdʌ aagidi ʌojootosicami ʌrMaría Madaliña, ʌʌmadu Vuañiita, ʌʌmadu María Jacovo dʌʌdʌ, dai aa ooqui. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dʌmos ʌojootosicami mosvuiirugami duucai caʌ ʌñiooqui ismaacʌdʌ aagidi ʌooqui dai maivaavoitu. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dʌmos ʌPiiduru mʌraitai vuusai dai mʌʌ nʌnʌidi siaaco caatʌcatadai ʌSuusi, dai aʌcai tuucavi nʌnʌaava dai tʌʌ ʌicuusi tuaacʌdʌ ismaacʌdʌrʌ biisapicatadai ʌmuuquiadʌ vai mosgajiaadʌrʌ daacatadai, tai ʌgai ʌpamu aa gʌi dai duaadimutugaitai ʌgaicʌdʌ ismaacʌdʌ ʌpʌduitadai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dai ʌgai vaa tasʌrʌ goocatai ʌSuusi mamaatʌrdamigadʌ Emausamaco iimʌitadai, Emausa maisi mʌʌcoraga Jerusaleenaiñdʌrʌ parʌ goo oora imidagai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dai iimʌitai aatagaimi dai aagaimi ʌgai vʌʌsi istumaasi daivusai Jerusaleenʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dai aidʌsi aipaco gʌnaatagidimi ʌgai, tai ʌʌgi ʌSuusi miaadʌrʌ cʌquiva dai oí. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Daidʌ ʌcʌcʌʌli nʌiditadai dʌmos Diuusi maimaa oigaragai ismatiagi sioorʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Taidʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―¿Tumaasi aatagaimi aapimʌ iimʌitai? ¿Tuimʌsi soigʌnʌlidi? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tai ʌmaadutai ʌcʌcʌʌli ismaacʌdʌ Cleoofasi tʌʌgidu aa noragi daidʌ itʌtʌdai: ―Vʌʌsi oidacami maatʌ istumaasi ʌpʌdui Jerusaleenʌrʌ, ¿mosʌca aapipʌs maimaí, ami gʌuuliñacatai ʌʌpʌ? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Amaasi ʌSuusi itʌtʌdai: ―¿Tumaasi ʌpʌduio? ―astʌtʌdai. Tai ʌgai itʌtʌdai: ―Ʌgai ismaacʌdʌ ʌpʌdui ʌSuusi Nasareetʌrʌ oidacamicʌdʌ, ismaacʌdʌ ʌrʌmo Diuusi ñiooquituldiadamigadʌcatadai daidʌ ivuaadana mui naana maasi gʌgʌrducami asta gʌñiooquicʌdʌ Diuusi vuitapi dai ʌoodami vuitapi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dai isduucai ʌbaitʌguucacamigadʌ ʌpapaaligadʌ ʌjudidíu ʌʌmadu gʌrtʌtʌaanʌdamiga gatʌʌgi mʌsai gatʌaanʌna muaaragai dai curusiaba siisana. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aatʌmʌ poʌliditadai isʌgai ʌgai dai cʌʌgacʌrʌ vuvaida agaitadai judidíu. Dʌmos sivi casiʌpʌdui vaica tasai siʌpʌdui gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dʌmos ʌʌmoco ooqui aatʌmʌ gʌrsaagidaiñdʌrʌ gʌrʌʌbʌcatai. Aliʌ ʌʌqui iji ʌgai siaaco caatʌcatadai ʌSuusi, ");
INSERT INTO ntpNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","dai maitʌʌ ʌgai ʌtuucugadʌ, dai dadacai pocaitimi sai vuitapi gʌnmaasitu Diuusi tʌtʌaañicarudʌ sai potʌtʌdai sai ʌSuusi duaaca. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tai ʌʌmadutai gʌraaduñi iji siaaco caatʌcatadai ʌgai dai tʌʌ vʌʌsi isducatai aagai ʌooqui dʌmos ʌSuusi gia maitʌʌ ʌgai ʌʌpʌ ―astʌtʌdai ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Amaasi ʌSuusi itʌtʌdai: ―Gia maimaatʌ caʌ aapimʌ dai mosʌʌ tʌvʌpicʌdʌ maiquiaa vaavoitudai ismaacʌdʌ aagai ʌDiuusi ñiñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Maitasi viaacatadai ʌCristo issoimaa taatagi vʌʌsi gomaasi vai gooquiʌrʌ siaa duutuadagi vʌʌscatai tʌvaagiʌrʌ? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Amaasi ʌSuusi aagidi istʌiya ʌlidi vʌʌsi ʌoojai ismaacʌdʌ oojisi Diuusi ñiooquidʌrʌ siaaco ooja Diuusi ñiñiooquituldiadamigadʌ aagaitai ʌSuusi. Ʌʌpʌga aagai ʌgai ismaacʌdʌ ooja Moseesacaru dai gooquiʌrʌ aagai ismaacʌdʌ ooja ʌgaa Diuusi ñiñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dai aidʌsi aayi ʌcʌcʌʌli siaacoga iimia agaitadai vaidʌ ʌSuusi mosdaivuñia agaitadai abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dʌmos ʌcʌcʌʌli goguama oí sai viʌʌna daidʌ itʌtʌdai: ―Gʌrʌʌmadu ivii casia uruñimi oidigi dai catucaimi vʌʌsi ―astʌtʌdai. Taidʌ ʌSuusi ami aayi ʌʌpʌ dai ʌʌmadu viiya agai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dai aidʌsi gaugia agaitadai ʌgai ʌcʌcʌʌli ʌʌmadu meesa vuidʌrʌ taidʌ ʌSuusi bʌi ʌpaana dai gamamagi dai saasarai dai maa ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mospodui ʌgai tai Diuusi maa oigaragai ʌcʌcʌʌli sai maatʌna isʌgai ʌrʌSuusi. Dʌmos aidʌ otoma ʌSuusi maitʌmaasitu abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Vaidʌ ʌcʌcʌʌli povai gʌntʌtʌdai aipacoga: ―¿Maitasi ʌrvaavoi tʌsaliʌ baigʌrʌliditadai aatʌmʌ aidʌsi gʌroiditadai ʌgai voiyaiñdʌrʌ dai gʌraagidimi isducatai icaiti Diuusi ñiooquidʌ? ―astʌtʌdai ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dai amaasi ʌgai mainʌnʌra vaamioma mosotoma ʌpamu aa suuli Jerusaleenamu, vai ami gʌnʌmpaidacatadai ʌbaivustaama dan ʌmoco ojootosicami ʌʌmadu ʌaaduñdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Daidʌ ʌojootosicami potʌtʌdai ʌgaa gooca cʌcʌʌli: ―Sʌʌlicʌdʌ ʌrvaavoi isduaaca ʌmamaatʌtuldiadami goSimuñi catʌʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amaasi ʌvʌgoocai cʌcʌʌli aagidi isducatai ʌpʌdui voiyʌrʌ, dai isducatai maí ʌgai ʌSuusi aidʌsi saasarai ʌgai ʌpaana. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Amaasi quiaa aagaitadai ʌgai imaasi, taidʌ ʌSuusi saagida cʌquiva dai aduucai viaatuli: ―¿Baigamʌsi ʌnʌlidi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tai ʌgai aliʌ duduaadimu dai povʌnʌliditadai siʌrʌmo suiñali ismaacʌdʌ nʌidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dʌmos ʌSuusi itʌtʌdai: ―¿Tuimʌsi duduaadimucu? ¿Tuimʌsi maicʌʌga vaavoitu aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nʌidavurai giñnoonovi ʌʌmadu giñʌʌcaso ʌgai vaa Suusiana. Giñtaatavurai dai nʌida. Ʌmo suiñali maioo tomali maituucuga poduucai mʌsducatai giñnʌidi aapimʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dai potʌʌcai tʌtʌgidi gʌnoonovi ʌʌmadu gʌʌʌcaso. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dʌmos ʌgai maiquiaa vaavoitudaitai baigʌnʌldacai dai maitʌtʌgaitai istumaasi gʌntʌtʌgituagi. Cascʌdʌ ʌSuusi potʌtʌdai: ―¿Viaamʌsi istumaa ugia aanʌ? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tai ʌgai maa laachi vatopa gaicami dai ʌmo mʌʌmʌvai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Taidʌ ʌSuusi bʌi dai uu ʌgai vuitapi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dai gooquiʌrʌ itʌtʌdai ʌSuusi: ―Vʌʌsi istumaasi ismaacʌdʌ soimaa taata aanʌ ʌrʌgai isducatai gʌnaagidi aanʌ aidʌsi quiaa gʌnʌʌmadu daacatadai, sai viaacatadai siʌpʌduñiagi vʌʌsi gomaasi ismaacʌdʌ gʌaagai ʌliivroʌrʌ ismaacʌdʌ ooja Moseesacaru dai ismaacʌdʌ ooja ʌDiuusi ñiñiooquituldiadamigadʌ dai ismaacʌdʌ oojisi Salmosi liivrugadʌrʌ giñaagaitai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dai soi ʌSuusi ʌgai sai maatʌ caʌcana. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Daidʌ itʌtʌdai: ―Poduucai oojisi saidʌ ʌCristo viaacatadai ismuquiaagi dai bo vaica tasaicʌdʌ viaacatadai isduaacagi coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dai gomaasi ismaacʌdʌ soimaa taata aanʌ gʌaagai mʌsaagidagi vʌʌsi oidigi daama oidacami Jerusaleenaiñdʌrʌ abiaadʌrʌ gʌnaagacai dai sai gʌaagai isʌma duucai gʌntʌtʌgituagi dai camaisoimaasi ivuaadagi vai poduucai oigʌldica ʌgai vʌʌsi soimaascamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Dai aapimʌ ʌrnʌijadami vʌʌsi imaasi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dai aanʌ gʌnootosdamu vʌʌsi istumaasi aagai giñooca, dʌmos tanasi Jerusaleenʌrʌ avʌr daraaja asta siʌʌscadʌ diviagi Diuusi guvucadadʌ tʌvaagiaiñdʌrʌ aapimʌ gʌnʌʌmadu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Daidʌ ʌSuusi vaidacai gʌojootosa abiaadʌrʌ Betaaniamu, dai vañigidacai gʌnoonovi siaa duutuli. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Dai siaa duutuldacai ʌcovai ii dai tʌvaagiamu tʌsai. ");
INSERT INTO ntpNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Daidʌ ʌojootosicami casiaa duutudacai aa suuli Jerusaleenamu dai aliʌ baigʌnʌliatugai, ");
INSERT INTO ntpNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","dai vʌʌscʌrʌ ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu daraajatai siaa duutudaiña Diuusi. Mosʌcaasi.");
INSERT INTO ntpNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Diuusi maradʌ ʌgai dai tomastuigaco tʌvaagiʌrʌ daacana Diuusi ʌʌmadu. Aidʌsi maiquiaa cʌquiva oidigi vʌʌscʌrʌ oidaga Diuusi maradʌ Diuusi ʌʌmadu. Diuusi maradʌ ʌgai daidʌ gʌrmaatʌtuli istuiga Diuusi. Diuusi maradʌ ʌrDiuusi ʌʌpʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Diuusi maradʌ ʌʌmadu Diuusi idui vʌʌsiaʌcatai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Diuusi maradʌ gʌrmaacai ibʌdagai utuducami dai soicʌi oodami ismaatʌ caʌcagi Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Diuusi maradʌ divia oidigi daama dai oidacatadai oodami saagida. Ʌoodami maimaatʌ caʌcatadai Diuusi ñiooquidʌ baiyoma apiasoimaasi ivuaadana. Diuusi maradʌ soi mui oodami sai maatʌ caʌcana Diuusi ñiooquidʌ tomasi vaamioma muidu ismaacʌdʌ gajiaadʌrʌ vipieeyi Diuusi ñiooquidʌ. Siaaco oidaga cuudagi maitutucagʌi. Poduucai ʌʌpʌ sioorʌ vaavoitudai dai ʌʌgidi Diuusi maradʌ ʌgai gia gajiaadʌrʌ vipieeyi gosoimaascami. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Diuusi ootoi ʌVuaana sai vapaconana oodami sai gaagidana isDiuusi maradʌ ʌrʌgai ismaacʌdʌ maatʌtuldia agai oodami Diuusi ñiooquidʌ, sai oodami vaavoitudana ʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ɅVuaana maitʌrʌCristocatadai baiyoma Diuusi ootoi ʌVuaana sai gaaagidiana sioorʌ ʌrʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ɅCristo divia agaitadai gooquiʌrioma dai soiña agai oodami sai maatʌ caʌcana Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ɅCristo oidacatadai oidi daama dʌmos ʌoodami maimaatʌcatadai sioorʌ ʌgai. Ʌgai ʌgai daidʌ idui oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Daidʌ ʌCristo ʌrjudíucatadai dʌmos chiʌʌqui judidíu vaavoitudaitadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dʌmos vʌʌscʌrʌ ʌʌmoco cʌʌga gʌntʌgito caʌ dai vaavoitu ʌSuusi Cristo tai Diuusi maa ʌgai sʌʌlicami saidʌ ʌrDiuusi maamaradʌcana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mospoduucai ʌrDiuusi maamaradʌcana oodami maisiu mosvuvaacʌcai oodamiaiñdʌrʌ. Ʌvaavoitudadami ʌrDiuusi maamaradʌ maisiu mosipʌliditai dʌʌdʌdʌ tomali maisiu mosipʌliditai ʌmo oodami baiyoma ʌrDiuusi maamaradʌ ipʌliditai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Daidʌ ʌCristo Diuusi maradʌ tʌvai tʌvaagiaiñdʌrʌ dai ʌgaicʌdʌ gʌmaí istuiga Diuusi. Diuusi maradʌ vuusai oodami duucai dai oodami saagida oidacana. Dai ʌgai sʌʌlicʌdʌ cʌʌgacʌrʌ nʌidiña oodami dai vʌʌsi istumaasi aagaiña ʌgai ʌrvaavoi. Dai aatʌmʌ maí siʌgai viaa ʌmo sʌʌlicami dai aliʌ viaa guvucadagai. Diuusi ʌgai dai maa gʌmara sʌʌlicami dai guvucadagai. Diuusi mosaliʌʌmaduga maradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Dai poduu aagai ʌVuaana aagaitai ʌgai: ―Idiava ʌrʌgai ismaacʌdʌ gʌnaagidi aanʌ sai divia agaitadai, dai vaamioma namʌga iñsaanʌ dai aanʌ maitistutuidi siʌʌsi istutuidi idi. Maiquiaa vuusaicai aanʌ abiaadʌrʌ caoidacatadai idi ―ascaiti ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Daidʌ ʌgai sʌʌlicʌdʌ gʌroigʌdai dai cʌʌgacʌrʌ gʌrnʌidi dai vʌʌscʌrʌ gʌrsoicʌi naana maasi istumaasicʌdʌ aatʌmʌ ismaacʌdʌ vaavoitudai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moseesacaru ʌgai daidʌ gʌrmaa Diuusi sʌʌlicamigadʌ dai sioorʌ maiʌʌgidiña ʌsʌʌlicami ʌdudunucami gʌvaiña ʌgai iscoodaiña ʌʌpʌ. Dʌmos ʌSuusi Cristo ʌgai dai oigʌdai oodami dai oigʌldi dai cʌʌgacʌrʌ nʌidi dai vʌʌsi istumaasi aagai ʌgai ʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tomali ʌmaadutai mainʌidi Diuusi tomali ʌmo imidagai. Dʌmos Diuusi maradʌ ismaacʌdʌ tomastuigaco tʌvaagiʌrʌ daja Diuusi gʌrooga ʌʌmadu dai cascʌdʌ cʌʌ maatʌ istuiga Diuusi. Ʌgai ʌgai dai gʌrmaatʌtuldi istuiga Diuusi. Diuusi mosaliʌʌmaduga maradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ʌfariseo Jerusaleenʌrʌ oidacami ootoi papaali ʌʌmadu pipiooñigadʌ sai tʌcacana ʌVuaana soor ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Taidʌ ʌVuaana sʌʌli aagidi dai potʌtʌdai: ―Aanʌ anmaitʌrʌCristo ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Amaasi potʌtʌdai ʌpapaali ʌʌmadu pipiooñigadʌ ʌgai: ―¿Poor aapi? ¿Aapipʌsi ʌrEliiasi Diuusi ñiooquituldiadamigadʌ? ―astʌtʌdai. Taidʌ ʌVuaana potʌtʌdai: ―Chuu ―astʌtʌdai. Tai ʌgaa potʌtʌdai: ―¿Aapipʌsi ʌrʌDiuusi ñiooquituldiadamigadʌ ismaacʌdʌ aagai Diuusi ñiooquidʌrʌ sai divia agaitadai? ―astʌtʌdai. Taidʌ ʌVuaana potʌtʌdai: ―Chuu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Amaasi ʌgaa potʌtʌdai: ―¿Poor aapi? Gʌraagidañi aapi tʌtai aagida aatʌmʌ ʌmo istumaasi ʌgai ismaacʌdʌ gʌrootoi. ¿Tumaasi gʌraagidamu aapi? ¿Poor aapi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Taidʌ ʌVuaana potʌtʌdai: ―Aanʌanʌ ʌgai ismaacʌdʌ aagai Diuusi ñiooquituldiadamigadʌ Isaíacaru sai oidigana gamamaatʌtuldia agai Diuusi ñiooquidʌ dai aduucai ooja ʌgai: “Aagidamu ʌgai oodami sai otoma divia agai gabaitʌcʌaacamiga, cascʌdʌ aliʌsi gʌaagai isʌma duucai gʌntʌtʌgito dai camaisoimaasi ivuaada ʌgai”, asduucai ooja Isaíacaru ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Amaasi ʌfariseo ojootosadʌ ismaacʌdʌ dada Jerusaleenaiñdʌrʌ ");
INSERT INTO ntpNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","potʌtʌdai: ―Isaapi maitʌrʌCristo, tomali maitʌrEliiasi, tomali maitʌrDiuusi ñiooquituldiadamigadʌ ismaacʌdʌ divia agaitadai, aidʌ gia ¿tuipʌsi vapaconai aapi oodami? ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Taidʌ ʌVuaana potʌtʌdai: ―Aanʌ gia suudagicʌdʌ vapaconai oodami dʌmos aapimʌ gʌnsaagida aimʌrai ʌmai dai maimaatʌ aapimʌ sioorʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aanʌ ʌpʌga divia isʌgai dʌmos ʌgai vaamioma viaa guvucadagai iñsaanʌ. Aanʌ maitistutuidi siʌʌsi istutuidi ʌgai. Ʌgai sʌʌlicʌdʌ vaamioma namʌga iñsaanʌ ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Vʌʌsi gomaasi ʌpʌdui Betaabarʌrʌ vaasmocoradʌrʌ ʌgʌʌ aqui Jordán. Ʌaqui Jordánʌrʌ ʌgai siaaco vapaconai ʌVuaana ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Siaadico ʌVuaana nʌidi isvuidʌrʌ imʌi ʌSuusi. Daidʌ ʌVuaana itʌtʌdai ʌoodami: ―Dañi gooviava ʌgai ismaacʌdʌ ootoi Diuusi sai gʌmuaatudana curusiaba vai poduucai Diuusi istuidʌna isoigʌldiagi oodami soimaascamigadʌ. Poduucai goSuusi ʌrʌpan ducami ʌali cañiiru ismaacʌdʌ ʌʌquioma gʌraaduñicaru coodaiña sai Diuusi oigʌldiña soimaascamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Goovai aagai aanʌ aidʌñsi pocaiti: “Aanʌ ʌpʌga divia isʌgai dʌmos ʌgai vaamioma viaa guvucadagai iñsaanʌ. Aanʌ maitistutuidi siʌʌsi istutuidi ʌgai. Maiquiaa vuusaicai aanʌ abiaadʌrʌ caoidacatadai ʌgai”, tʌtʌdai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aanʌ ʌʌpʌ maimaatʌcatadai sioorʌ ʌgai. Dʌmos aanʌ vapaconai ʌjudidíu suudagicʌdʌ vai poduucai ʌgai maatʌna sioorʌ ʌgai ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Daidʌ ʌVuaana pocaiti ʌʌpʌ: ―Aanʌ tʌʌ aidʌsi Diuusi Ibʌadʌ tʌvai tʌvaagiaiñdʌrʌ ʌSuusi daama ʌmo tugu maasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Aanʌ maiquiaa maatʌcatadai sioorʌ ʌgai dʌmos Diuusi ʌgai dai giñootoi sai vapaconana aanʌ oodami suudagicʌdʌ dai ʌgai povaiñtʌtʌdai: “Siʌʌscadʌ nʌijadagi giñibʌdaga istʌvañiagi dai dan daiva ʌmo cʌʌli ʌgai vaa ʌrʌgai dai maaqui agai oodami guvucadadʌ giñibʌdaga”, iñtʌtʌdai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dai nʌidi aanʌ istumaasi ʌpʌdui ʌcʌʌlicʌdʌ dai aanʌ ʌrnʌijadami isʌgai ʌrDiuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Siaadico ʌVuaana movaasi daacatadai ʌʌmadu gooca gʌmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dai nʌiditai isdaivusai ʌSuusi, ʌVuaana itʌtʌdai gʌmamaatʌrdamiga: ―Dañi bodʌrʌ imʌi goovai ismaacʌdʌ Diuusi ootoi sai gʌmuaatudana curusiaba vai poduucai Diuusi istuidana isoigʌldiagi oodami soimaascamigadʌ. Poduucai Suusi ʌrʌpan duucami ʌali cañiiru ismaacʌdʌ ʌʌquioma gʌraaduñicaru coodaiña vai Diuusi oigʌldiña soimaascamigadʌ ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vʌgoocatai mamaatʌrdamigadʌ ʌVuaana cai iscaiti ʌVuaana dai oí ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Amaasi ʌSuusi aa nʌnʌava dai tʌʌ isoidi ʌgai daidʌ itʌtʌdai: ―¿Tuma gaagai aapimʌ? ―astʌtʌdai ʌSuusi. Tai ʌgai itʌtʌdai: ―Mamaatʌtuldiadami, ¿paaco oidaga aapi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Taidʌ ʌSuusi itʌtʌdai: ―Giñoidávurai dai nʌida ―astʌtʌdai. Amaasi oí ʌgai dai tʌʌ siaaco gʌuliñacatadai ʌgai. Dai casi ʌrurunucocatadai dai movaasi daraaja ʌgai ʌSuusi ʌʌmadu asta duupicoi tasai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ʌmaadutai ʌgai Aandʌrʌsi tʌʌgidu. Ʌgai ʌrsuculidʌ Simuñi Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Otoma ii ʌgai dai tʌʌ gʌsiʌʌgi daidʌ itʌtʌdai: ―Aatʌmʌ tʌʌ ʌCristo ismaacʌdʌ Diuusi ootoi tʌvaagiaiñdʌrʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dai Aandʌrʌsi vaidacai Simuñi mʌʌca siaaco daacatadai ʌSuusi. Dai mostʌʌgacai ʌSuusi ʌSimuñi potʌtʌdai: ―Aapiapʌ ʌrSimuñi Joonási maradʌ dʌmos sivi Sefasi gʌaagadamu aanʌ. Sefasi ʌrPiiduru ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dai siaadico ʌSuusi imia agaitadai Galilea dʌvʌʌriamu. Dʌmos ʌpʌga tʌʌ ʌgai ʌPiili daidʌ itʌtʌdai: ―Giñoidáñi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ɅPiili ʌrBetasaidʌrʌ oidacami. Dai ami oidacatadai ʌʌpʌ Aandʌrʌsi ʌʌmadu Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Amaasi ii ʌPiili dai gaagamu Natanieli daidʌ itʌtʌdai: ―Aatʌmʌ tʌʌ ʌcʌʌli ismaacʌdʌ aagai Moseesacaru daidʌ ʌDiuusi ñiñiooquituldiadamigadʌ aidʌsi ooja ʌgai Diuusi ñiooquidʌ. Ʌgai ʌrSuusi, Osee maradʌ Nasareetʌrʌ oidacami ―astʌtʌdai ʌPiili. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Taidʌ ʌNatanieli itʌtʌdai: ―Siaadʌrʌ diviana ʌmo oodami cʌʌ tuigajami Nasareetaiñdʌrʌ ―astʌtʌdai. Taidʌ ʌPiili itʌtʌdai: ―Timuda pai nʌida ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aidʌsi ʌSuusi tʌʌ isvuidʌrʌ imʌi ʌNatanieli, potʌtʌdai ʌgai ʌoodami: ―Bodʌr imʌi Natanieli. Goovai ʌrʌmo judíu ismaacʌdʌ sʌʌlicʌdʌ siaa duutudai Diuusi dai cʌʌga ʌʌgidi Diuusi sʌʌlicamigadʌ dai maitʌryaatavogami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Amaasi Natanieli itʌtʌdai: ―¿Ducatai giñmaatʌ aapi? ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ gʌnʌidi aidʌsi abiaadʌrʌ maiquiaa gʌvaí goPiili pai ʌmo iigosi uta daacatadai aapi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Amaasi Natanieli itʌtʌdai: ―Mamaatʌtuldiadami, aapi apʌrDiuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ. Aapi apʌrraígadʌ ʌjudidíu ―astʌtʌdai Natanieli. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Taidʌ ʌSuusi itʌtʌdai: ―¿Mosgʌaagidacai aanʌ sai gʌnʌidi ʌiigosi uta giñvaavoitu aapi? Nʌidamu aapi naana maasi istumaasi vaamioma gʌgʌrducami sigomaasi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Daidʌ ʌSuusi itʌtʌdai ʌʌpʌ: ―Sʌʌlicʌdʌ tʌʌgimu aapimʌ iscupioquiñi ʌtavaagi dai Diuusi tʌtʌaañicarudʌ tʌʌsadʌdamu dai tʌapanʌdamu siaaco aimʌrda aanʌ. Aanʌanʌ ʌgai dai viaa ʌmo sʌʌlicami ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bovaica tasaicʌdʌ Suusi ii ʌmo cunataragʌrʌ Canaaʌrʌ Galilea dʌvʌʌriʌrʌ. Vai ami daacatadai ʌSuusi dʌʌdʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Daidʌ ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ vapaidarsicatadai ʌʌpʌ cascʌdʌ iji aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tai ugidagai uuvasi varagadʌ. Taidʌ ʌSuusi dʌʌdʌ itʌtʌdai ʌSuusi: ―Camaitiipu uuvasi varagadʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dʌmos ʌSuusi itʌtʌdai: ―Giñdaada, ¿tuipʌsi giñaagidi gomaasi? Maiquiaa aayi siuu duucu iduñia iñagai aanʌ ʌmo istumaasi gʌducami ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dʌmos ʌSuusi dʌʌdʌ potʌtʌdai ʌvasibadami: ―Iduuñivurai tomastumaasi istumaasi gʌnaagidagi goSuusi ―tʌtʌdai ʌSuusi dʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Vai ami daraajatadai naadami ojoodai ajaayi, ismaacʌdʌrʌ toadana ʌjudidíu suudagi sai ʌcʌdʌ gʌniicomana vʌʌsi ʌvapaidarsicami poduucai isduucai viituli ʌjudidíu ʌʌqui aaduñdʌcardu. Ʌʌmo ajaayi aajʌi parʌ maaco coobai litro suudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Taidʌ ʌSuusi potʌtʌdai ʌvasibadami: ―Suusudadavurai idi ajaayi suudagicʌdʌ ―tʌtʌdai ʌSuusi. Tai ʌgai cʌʌ suusudagi ʌajaayi suudagicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tai amaasi ʌSuusi itʌtʌdai: ―Siviavʌr gia vaasiba lʌʌchi dai bʌidacai ʌtʌaanʌdami idi cunataragiʌrʌ ―tʌtʌdai ʌSuusi. Tai podui ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Taidʌ ʌtʌaanʌdami dʌʌ gosuudagi ismaacʌdʌ uuvusi varagadʌ gʌnaato. Dʌmos ʌgai maimaí siaadʌrʌ vuaa ʌvasibadami gouuvasi varagadʌ. Mosʌʌgi ʌvasibadami maatʌcatadai. Ʌʌgi ʌgai vaigi ʌsuudagi cascʌdʌ. Taidʌ ʌtʌaanʌdami vaí ʌnovio ");
INSERT INTO ntpNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","daidʌ itʌtʌdai: ―Sʌʌlicʌdʌ vʌʌñiga idi uuvasi varagadʌ. Vʌʌsi oodami ʌʌpʌga gavasidiña ʌuuvasi varagadʌ vʌʌñiacʌdioma dai gooquiʌrʌ maisi vʌʌñiacʌdʌ. Dʌmos aapi ʌʌpʌga gatʌjai vasibaragai gouuvasi varagadʌ maisi vʌʌñiacʌdʌ dai gooquiʌrʌ ʌvʌʌñiacʌdioma ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gomaasi ismaacʌdʌ idui ʌSuusi Canaaʌrʌ ʌrʌpʌgadadʌ istumaaasi gʌducʌdʌ ismaacʌdʌ idui ʌgai ʌoodami vuitapi dai ʌgaicʌdʌ maí ʌoodami isviaa ʌgai guvucadagai. Dai aatʌmʌ mamaatʌrdamigadʌ ʌSuusi vaavoitu isʌgai ʌrʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dai mosgʌcuugaidacai ʌvagimi ii ʌSuusi Capernauumamu. Dai Suusi dʌʌdʌ ʌʌmadu Suusi susuculidʌ ʌʌmadu Suusi mamaatʌrdamigadʌ oidi ʌgai dai anaasi daraaja chiʌʌqui tasai. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dai aidʌ camiaadimitadai ʌsiaa duudagarʌ ʌjudidíu istuigaco ʌgai tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu cajiudadʌ Ejiipituaiñdʌrʌ. Daidʌ ʌSuusi ii Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dai anaasi ʌgʌʌ quiuupiʌrʌ tuisicʌrʌ ʌSuusi tʌʌ isami ʌʌmadutai gagaagaraitaidai vopoisi dai cañiiru dai tutugu dai aa mo daraaja gagaagaraitadai ʌtumiñsi ismaacʌdʌcʌdʌ saapʌdaiña ʌoodami istumaasi gʌgaagaraiña quiuupiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mostʌʌgacai ʌSuusi gomaasi idui ʌmo iquisanai aali tʌtʌroviñdicʌdʌ dai vuvaitu quiidigamu vʌʌsi ʌoodami ʌʌmadu ʌvopoisi dai ʌcañiiru. Dai dʌvʌʌrapi suuli ʌtumiñsi ismaacʌdʌ gagaagaraitadai ʌcʌcʌʌli dai aipaco suuli meesagadʌ ʌgai ismaacʌdʌ gagaagaraitadai tutugu. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Daidʌ potʌtʌdai ʌSuusi ʌgaagardami tutugu: ―Vuvaidavurai vʌʌsi gomaasi. Maitavʌr ʌmo gagaaracarui duucai nʌijada giñooga quiidʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Amaasi aatʌmʌ ʌSuusi mamaatʌrdamigadʌ gʌntʌgito ispodu oojisi Diuusi ñiooquidʌrʌ: “Giñooga, sʌʌlicʌdʌ ipʌlidi aanʌ isvʌʌsi oodami siaa duutuadagi gʌquii poduucai isduucai aapi ipʌlidi”, asduucai oojisi Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Amaasi ʌjudidíu tʌcacai ʌSuusi dai potʌtʌdai: ―¿Tumaa istumaasi gʌducami iduñia agai aapi vai ʌgaicʌdʌ maatiagi aatʌmʌ isaapi viaa sʌʌlicami isivuaadagi gomaasi? ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Taidʌ ʌSuusi itʌtʌdai: ―Daitudavurai aapimʌ idi gʌʌ quiuupai dai vaic tasaicʌdʌ ʌpamu iduuñimu aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Amaasi ʌjudidíu itʌtʌdai: ―Goo coobai dan naadami uumigicʌdʌ ʌpʌdui idi gʌʌ quiuupai. ¿Siaadʌrʌ iduuna aapi vaic tasaicʌdʌ? ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dʌmos ʌSuusi maiaagai ʌgʌʌ quiuupai ismaacʌdʌ idui oodami. ɅSuusi aagai ʌʌgi gʌtuucuga. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cascʌdʌ aidʌsi ʌSuusi ʌpamu duaaca ʌcoidadʌ saagidiaiñdʌrʌ gʌrtʌgito aatʌmʌ mamaatʌrdamigadʌ ʌgai iscaiti ʌSuusi dai vaavoitu Diuusi ñiooquidʌ dai vʌʌsi istumaasi ʌSuusi aagaiña. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aidʌsi ʌSuusi modaacatadai Jerusaleenʌrʌ ʌsiaa duudagʌrʌ ʌjudidíu istuigaco ʌgai tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu cajiudadʌ Ejiipituaiñdʌrʌ muidutai vaavoitu isʌgai ʌrʌCristo, nʌiditai naana maasi istumaasi gʌgʌrducami ismaacʌdʌ ivuaadana ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dʌmos ʌSuusi ʌʌbiadan tada ʌgai maatʌcatai isʌgai maiʌʌgiada agaitadai. ɅSuusi cʌʌga maatʌ iducatai tʌtʌgitoi vʌʌsi oodami cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ɅSuusi maitʌgito isaagidiagi ʌmai isducatai tʌtʌgitoi oodami mosʌʌgi ʌgai maatʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ʌmo imidagai tucarʌ ii Nicodemo dai mʌʌ diviji ʌSuusi. Nicodemo ʌrfariseo daidʌ ʌrʌmo dunucamigadʌ ʌjudidíu. Daidʌ itʌtʌdai Nicodemo ʌSuusi: ―Mamaatʌtuldiadami, cʌʌ maatʌ aatʌmʌ isDiuusi gʌootoi aapi pʌsai gʌrmamaatʌtuldana ñiooquidʌ. Mosmaitiipu aa sioorʌ istutiadagi isivuaadagi naana maasi gʌgʌrducami isducatai ivueeyi aapi isDiuusi maiʌʌmadu daacagi. Poduucai gʌmaatʌ issʌʌlicʌdʌ viaa guvucadagai aapi ―astʌtʌdai ʌNicodemo. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Amaasi ʌSuusi itʌtʌdai: ―Aanʌ angʌaagidi sai sʌʌlicʌdʌ ismaiʌpamu vuusiagi ʌmo oodami maitistutiada agai ismatiagi isducatai tʌaanʌi Diuusi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Taidʌ ʌNicodemo tʌcacai daidʌ itʌtʌdai: ―¿Ducatai istutuidi ʌmo cʌʌli isʌpamu vusiagi cacʌʌlitucai? Siaadʌrʌ ʌpamu vaacʌna ʌmo oodami gʌdʌʌ ʌraana dai ʌpamu vuusaiña ―astʌtʌdai Nicodemo. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aanʌ angʌaagidi sai sioorʌ maivuusiagi suudagicʌdʌ dai Diuusi Ibʌadʌcʌdʌ ʌʌpʌ ʌgai gia maiimia agai tʌvaagiamu dai Diuusi ʌʌmadu oidacagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Istumaasi vuusai oodamiaiñdʌrʌ ʌgai ʌroodami. Istumaasi vuusai Diuusi Ibʌadʌaiñdʌrʌ ʌgai viaa ʌmo ibʌdagai utudui: ");
INSERT INTO ntpNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","¿Tuipʌsi maitʌʌ aapi istumaa tʌgituagi gʌaagiditai aanʌ sai vʌʌscatai viaa isʌpamu vuvaquiagi? ");
INSERT INTO ntpNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ʌʌvʌʌli tomasiaaco vustai dai caʌcana aapi iscaiti dʌmos maimaatʌ siaadʌrʌ daivuscʌi tomali siaaco imia agai. Poduucai ʌʌpʌ ʌgaicʌdʌ ismaacʌdʌ vusacʌi Diuusi Ibʌadʌ guvucadadʌcʌdʌ, tomali ʌmaadutai mainʌidi Diuusi Ibʌadʌ mosʌcaasi nʌidi isducatai ʌma maasi tʌgito oodami aidʌsi Diuusi Ibʌadʌ ʌʌmadu daacagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Taidʌ ʌNicodemo itʌtʌdai: ―¿Ducatʌ ʌpʌvueeyi imaasi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Taidʌ ʌSuusi itʌtʌdai: ―Aapi apʌrʌmo gʌʌ mamaatʌtuldiadamigadʌ ʌjudidíu. ¿Ducatai maimaatʌ caʌ aapi istumaasi gʌaagidi aanʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aanʌ gaaagidi istumaasi sʌʌlicʌdʌ maatʌ dai aanʌ ʌrnʌijadami istumaasi sʌʌlicʌdʌ nʌidi. Dʌmos aapimʌ maivaavoitudai istumaasi gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Isaapimʌ maitiñvaavoitudagi aagaitai aanʌ istumaasi ʌpʌvueeyi tami oidigi daama ¿ducatai iñvaavoituda agai isgʌnaagidiagi istumaasi ʌpʌvueeyi tʌvaagiʌrʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tomali ʌmo oodami maiii tʌvaagiamu dai ʌpamu divia tami oidi daami daidʌ istutuidi isaagidiagi aa ismaasi mʌʌca. Mosʌcaasi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami tʌvai tʌvaagiaiñdʌrʌ dai ʌpamu imimu aanʌ tʌvaagiamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Dai poduucai isduucai Moseesacaru ʌmo uusiʌrʌ sagia ʌmo cooyi vaiñomicʌdʌ duñisicami dai oodami vuitapi cʌi ʌuusi oidigana, poduucai mʌgiñsiisa agai curusiaba dai ʌoodami vuitapi cʌʌsa agai ʌcurusi. Aanʌ ʌrʌgai dai divia tʌvaagiaiñdʌrʌ dai aanʌ viaa ʌmo sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Giñmuaamu ʌoodami curusiaba vai tomasioorʌ sioorʌ vaavoitudagi iñsaanʌ ʌrʌcʌʌgacʌrʌ vuviadami ʌgai gia camaiimia agai ʌDiaavora ʌʌmadu baiyoma imia agai tʌvaagiamu dai Diuusi ʌʌmadu oidaca agai tomastuigaco. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Diuusi sʌʌlicʌdʌ oigʌdai ʌoodami oidigi daama oidacami cascʌdʌ ootoi ʌgai gʌmara, mosaliʌʌmaduga ʌgai maradʌ, dai gʌmuaatu sai tomasioorʌ sioorʌ vaavoitudagi isʌgai ʌrʌcʌʌgacʌrʌ vuviadami camaiimi agai ʌDiaavora ʌʌmadu baiyoma imia agai tʌvaagiamu dai Diuusi ʌʌmadu oidaca agai tomastuigaco. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diuusi ootoi gʌmara tami oidi daama sai cʌʌgacʌrʌ vuvaidana oodami sioorʌ vaavoitudagi maisiu isootosa ʌgai ʌDiaavora ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sioorʌ vaavoitudai Diuusi maradʌ ʌgai gia maiimia agai ʌDiaavora ʌʌmadu dʌmos sioorʌ maivaavoitudagi ʌgai gia imia agai ʌDiaavora ʌʌmadu maivaavoitudacai ʌgai Diuusi maradʌ. Mosaliʌʌmaduga Diuusi maradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sioorʌ maivaavoitudagi sʌʌlicʌdʌ imia agai ʌDiaavora ʌʌmadu. ɅCristo divia tami oidigi daama dai soicʌda agai oodami sai maatʌ caʌcana Diuusi ñiooquidʌ dʌmos ʌoodami vaamioma oojoidi issoimaasi ivuaadagi dai maisiu vaavoitudagi ʌCristo. Ʌoodami ʌrsoimaasi ivuaadamicatadai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sioorʌ soimaasi ivueeyi ʌgai gia cʌʌdai ʌCristo dai maivaavoitudai ʌCristo maitipʌliditai isaa maatiagi issoimaasi ivueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dʌmos sioorʌ ʌʌgidi Diuusi ʌgai gia dai vaavoitudai ʌCristo vai poduucai gʌmaatʌcana isivueeyi ʌgai istumaasi Diuusi ipʌlidi ―astʌtʌdai ʌSuusi ʌʌgi gʌaagaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dai casi ʌpʌduucai gomaasi ii ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ Judeea dʌvʌʌriamu. Dai movaasi daraaja aatʌmʌ chiʌʌqui tasai vapaconaitadai oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Daidʌ ʌVuaana vapaconaitadai oodami ʌʌpʌ Enoonʌrʌ dai abiaadʌrʌ Salimʌrʌ miaaga. Ami gʌpiacatadai suudagi cascʌdʌ. Tai daada oodami sai vapaconana ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aidʌ maiquiaa maisapicatadai ʌVuaana ismaacʌdʌ vapaconaitadai oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ʌjudidíu muiyoco imidaga dai naana duucai gʌniicomaiña siuu duucu gaugia agadagi. Ʌgai poʌlidiña sai poduucai Diuusi cʌʌgacʌrʌ nʌidiña. Dʌmos ʌmamaatʌrdamigadʌ ʌVuaana maipoduucai ivuaadana cascʌdʌ ʌmo imidagai aliʌsi gʌnvupui ñiñio ʌgai ʌʌmadu aa judidíu aagaitai gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dai gooquiʌrʌ iji ʌmamaatʌrdamigadʌ ʌVuaana daidʌ itʌtʌdai ʌgai ʌVuaana: ―Mamaatʌtuldiadami ʌcʌʌli ismaacʌdʌ gʌʌʌmadu daacatadai ʌgʌʌ aqui Jordán vaasadʌrʌ ismaacʌdʌ gʌraagidi aapi saidʌ ʌrʌCristo sivi ʌgai vapaconai oodami dai muidutai oidatucui ʌgai ―astʌtʌdai ʌmamaatʌrdamigadʌ ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Amaasi ʌVuaana itʌtʌdai: ―Tomasioorʌ sioorʌ viaacagi sʌʌlicami Diuusi ʌgai dai maacai gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aapimʌ cacaʌ iscaiti aanʌ ansai maitʌrʌCristo. Aanʌ ʌpʌga divia isʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Siʌʌscʌdʌ cunaata agadagi ʌmo ali tʌji vʌʌscʌrʌ ipʌlidiña isʌʌmadu daacagi ʌnovio. Daidʌ ʌnovio vapaidadʌ aliʌsi baigʌnʌlidiña isʌmapai daraaja ʌgai. Dai sivi aanʌ ʌʌpʌ baigiñʌlidi nʌiditai ismui oodami oidatucui ʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aliʌsi gʌaagai isʌCristo vaamioma ʌrbaitʌcʌaacamicagi iñsaanʌ vai poduucai otoma camaiñamʌacagi giñsʌʌlicamiga. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ɅCristo tʌvai tʌvaagiaiñdʌrʌ dai vaamioma namʌga sʌʌlicamigadʌ ʌgai sitomasioorʌ sʌʌlicamigadʌ. Dʌmos aanʌ ʌroidigi daama oidacami dai gaaagidi aanʌ istumaasi ʌpʌvueeyi tami oidigi daama. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ɅCristo gaaagidi istumaasi nʌidi dai istumaasi caʌ tʌvaagiʌrʌ vai chiʌʌquidu ismaacʌdʌ vaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dʌmos sioorʌ vaavoitudai poduucai cʌʌga maatʌ isDiuusi maiyaatagʌi tomali ʌmo imidagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Suusi Cristo ʌrʌgai ismaacʌdʌ Diuusi ootoi sai gaaagidana Diuusi ñiooquidʌ. Sʌʌlicʌdʌ Diuusi Ibʌadʌ ʌʌmadu daja ʌgai cascʌdʌ sʌʌlicʌdʌ viaa guvucadagai dai maitistutuidi ismaatiagi siʌʌsi guvucadagai viaa ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Diuusi gʌrooga sʌʌlicʌdʌ oigʌdai ʌgai. Ʌgai ʌrmaradʌ cascʌdʌ. Dai Diuusi maa ʌgai ʌmo sʌʌlicami sai vaamioma tʌaanʌiña sitomasioorʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sioorʌ vaavoitudai Diuusi maradʌ ʌgai gia tomastuigaco oidaca agai tʌvaagiʌrʌ Diuusi ʌʌmadu. Dʌmos sioorʌ maivaavoitudagi ʌgai maiimi agai tʌvaagiamu baiyoma Diuusi sʌʌlicʌdʌ soimaasi taatatuldia agai ʌgai ―astʌtʌdai ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ʌfariseo cajioma sai Suusi vaamioma mui vapaconaitadai oodami siʌVuaana dai vaamioma mui oodami oidatucui ʌSuusi siʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Dʌmos maitʌrvaavoi isʌSuusi vapaconaitadai oodami. Aatʌmʌ mamaatʌrdamigadʌ ʌgai dai vapacoinaitadai oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dai aidʌsi maí ʌSuusi ismaí ʌfariseo gomaasi ii ʌgai Judeeaiñdʌrʌ dai nora Galileeamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ʌgai viaacatadai isdaivuñiagi Samaaria dʌvʌʌriʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Dai aayi Sicaarʌrʌ Samaaria dʌvʌʌriʌrʌ ismaacʌdʌ miaan daja Jacocaru dʌvʌʌragadʌ. Ʌgai vaa ʌrʌdʌvʌʌrai ismaacʌdʌ Jacocaru maa gʌmara Osee. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ami ʌgai siaaco daja Jacocaru poosogadʌ. ɅSuusi caibimucatadai aimʌraitai dai modaiva pooso soonoana. Aidʌ cayoga dan duitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tai ami divia ʌmo ooqui Samaariʌrʌ oidacami dai vaigi agai suudagi. Taidʌ ʌSuusi itʌtʌdai: ―Giñvasidañi suudagi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Aatʌmʌ caijitadai caayamu dai gasavʌda ragai cuaadagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Amaasi ʌooqui itʌtʌdai ʌSuusi: ―¿Tuipʌsi giñtaanʌi suudagi? Aapi ʌrjudíu nai aanʌ ʌrSamaariʌrʌ oidacami ―astʌtʌdai ʌooqui. Ʌjudidíu ʌʌmadu ʌSamaariʌrʌ oidacami maicʌʌga gʌnñiñiooquidi aipacoga cascʌdʌ potʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Amaasi ʌSuusi aa noragi daidʌ itʌtʌdai: ―Ismaatʌcamudai aapi istumaasi maacai Diuusi ʌoodami dai sioorʌ aanʌ aidʌ gia aapi giñtaañimudai suudagi, dai aanʌ gʌoidamudai suudagi ismaacʌdʌcʌdʌ oodami tomastuigaco oidacana Diuusi ʌʌmadu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Taidʌ ʌooqui itʌtʌdai: ―Aapi maiviaa istucudʌ vusaidagi suudagi dai aliʌ tuucavuga gopooso. ¿Vaadʌrʌ vusaida agai aapi suudagi ismaacʌdʌcʌdʌ oodami tomastuigaco oidacana Diuusi ʌʌmadu daidʌ giñoidagi? ");
INSERT INTO ntpNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gʌrʌʌqui aduñicaru Jaco idui idi pooso. Ʌgai ʌʌmadu maamaradʌ ʌʌmadu sosoigadʌ gayʌʌdana suudagi idi poosoaiñdʌrʌ. Siaadʌrʌ vaamioma gatʌaanʌiña aapi siʌgai ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Sioorʌ yʌʌdagi idi suudagi vʌʌscʌrʌ ʌpamu tonoocorʌiña. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dʌmos sioorʌ iiyagi ʌsuudagi ismaacʌdʌ aanʌ gaoidi, camaitonoocorʌi ʌgai tomali ʌmo imidagai. Ʌsuudagi ismaacʌdʌ aanʌ gaoidi gaibʌdagʌrʌ daacana dai vʌʌscʌrʌ vusanʌiña gosuudagi poduucai isduucai vusanʌi suudagi ʌmo vagʌacañiaiñdʌrʌ dai gosuudagicʌdʌ tomastuigaco oidacana oodami tʌvaagiʌrʌ Diuusi ʌʌmadu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amaasi ʌooqui itʌtʌdai: ―Giñoida aapi ʌsuudagi nai poduucai camaitonoomucurʌda aanʌ tomali maiviaacagi isdidivaitai gavaigʌdagi suudagi idi poosoaiñdʌrʌ ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Taidʌ ʌSuusi itʌtʌdai: ―Imʌdañi dai vuaapa gʌcuna ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Amaasi aa noragi ʌooqui daidʌ itʌtʌdai: ―Maicuna aanʌ ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Vaavuava ismaicuna aapi cascʌdʌ pocaiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cataama ñiooquiditadai aapi cʌcʌʌli dai sivi ʌmoco ʌʌmadu oidaga aapi vai ʌgai maitʌrgʌcuna cascʌdʌ istumaasi aagai aapi ʌrvaavoi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Moscaʌ gomaasi ʌooqui daidʌ tʌtʌdai: ―Aapi sʌʌlicʌdʌ ʌrʌmo Diuusi ñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gʌrʌʌqui aaduñicaru tami Samaariʌrʌ oidacatadai dai siaa duutudaiña Diuusi tami idi giidiana dʌmos aapimʌ judidíu pocaiti sai Jerusaleenʌrʌ ʌgai siaaco gʌaagai issiaa duutuadagi Diuusi ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Taidʌ ʌSuusi itʌtʌdai: ―Giñvaavoitudañi aapi, aimu istuigaco aapimʌ siaa duutuadamu Diuusi maisiu tami idi giidiana tomali Jerusaleenana. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aapimʌ Samaariʌrʌ oidacami maicʌʌ maatʌ Diuusi tomasi siaa duutuadai. Aatʌmʌ judidíu cʌʌga maatʌ Diuusi. Ʌgai ismaacʌdʌ cʌʌgacʌrʌ vuvaida agai oodami ʌrjudíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dʌmos aimu istuigaco sioorʌ sʌʌlicʌdʌ siaa duutuadagi Diuusi siaa duutuada agai maisiu mosʌcaasi ñiooquicʌdʌ baiyoma siaa duutuada agai Diuusi gʌniibʌdagacʌdʌ dai gʌntʌtʌgitoidagacʌdʌ poduucai isduucai Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diuusi ʌribʌdagai cascʌdʌ sioorʌ siaa duutuada ʌliadagi Diuusi gʌniibʌdagacʌdʌ viaa isiaa duutuadagi poduucai isduucai Diuusi ipʌlidi dai maisiu mosʌcaasi ñiooquicʌdʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Taidʌ ʌooqui itʌtʌdai: ―Aanʌ gia maatʌ isdivia agai ʌCristo dai siʌʌscadʌ diviagi ʌgai cʌʌga gʌraagida agai vʌʌsi istumaasi ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ anʌrʌCristo ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dai quiaa aatagiditadai ʌgai tʌtai dada aatʌmʌ mamaatʌrdamigadʌ ʌSuusi. Dai maitʌʌ istumaasi gʌrtʌtʌgituagi tʌʌgacai ʌSuusi isaatagidi ʌmo ooqui. Dʌmos vʌʌscatai aatʌmʌ ʌʌbʌiditadai ʌSuusi cascʌdʌ tomali ʌʌmadutai maitʌcacai istumaa agai tomali istumaasi aatagidi ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Amaasi ʌooqui anaasi viaa gʌvaigacaru dai ii caayamu dai potʌtʌdai ʌoodami: ");
INSERT INTO ntpNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Mʌʌcavʌr nʌida ʌmo cʌʌli ismaacʌdʌ giñaagidi vʌʌsi istumaasi ivuaadana aanʌ. ɅCristo lienʌ ʌgai ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Amaasi iji ʌoodami caayaiñdʌrʌ dai aayi mʌʌca siaaco daacatadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mosimʌcai ʌooqui poosoaiñdʌrʌ tʌtai aatʌmʌ mamaatʌrdamigadʌ ʌSuusi daañimi sai gaugana. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dʌmos ʌSuusi povʌrtʌtʌdai: ―Viaa aananʌ ʌmo istumaasi istumaasi cueeyi istumaasi maimaatʌ aapimʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Amaasi aatʌmʌ mamaatʌrdamigadʌ ʌSuusi aipaco gʌrtʌcacaimi dai pocaiti: ―¿Sioorʌ vuaapi cuaadagai? ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dʌmos ʌSuusi itʌtʌdai: ―Siuu duucu ivuaada aanʌ istumaasi ipʌlidi Diuusi giñooga ismaacʌdʌ giñootoi ivuaadatai aa duiñdadʌ ʌgai, gomaasi ʌrʌpan duucami cuaadagai aan imvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aapimʌ pocaiti sai quiaa viʌʌga maaco masaadai isyoovagi oodami tʌligi. Dʌmos aanʌ angʌnaagidi sai caoidaga mui oodami ismaacʌdʌ caʌca ʌlidi isgaaagiadagi aapimʌ Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sioorʌ gaʌsai tʌligi gamaitʌcʌi tumiñsi dai sioorʌ gayoovai tʌligi gamaitʌcʌi tumiñsi ʌʌpʌ. Poduucai ʌʌpʌ Diuusi aa duiñdadʌrʌ. Ʌʌmadutai aagidiña Diuusi ñiooquidʌ oodami vai aa daivuiña gooquiʌrʌ dai ʌpamu aagidiña Diuusi ñiooquidʌ oodami vai ʌgai vaavoitudaiña Diuusi ñiooquidʌ dai cʌʌgacʌrʌ vuvacʌi dai tomastuigaco oidacana tʌvaagiʌrʌ Diuusi ʌʌmadu. Daidʌ ismaacʌdʌ ʌʌpʌga gaaagiadagi Diuusi ñiooquidʌ daidʌ ismaacʌdʌ gooquiʌrʌ gaaagiadagi Diuusi ñiooquidʌ aliʌ baigʌnʌliadamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sʌʌlicʌdʌ ʌrvaavoi istumaasi gʌaagai sai ʌʌmoco gaʌsai daidʌ aa gayoovai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aanʌ gʌnootoi mʌsai aagidana Diuusi ñiooquidʌ oodami vai ʌgai giñvaavoitudana. Dʌmos aa Diuusi ñiñiooquituldiadamigadʌ caaagidi Diuusi ñiooquidʌ ʌoodami dai aapimʌ aagidi ʌoodami sai ʌliʌsi gʌaagai isvaavoitudagi. Poduucai ʌgaa ʌrʌpan ducami ʌsadami tʌligi dai aapimʌ ʌrʌpan ducami yoovadami tʌligi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dai muiduitai Samaariʌrʌ oidacʌdʌ vaavoitu isʌSuusi ʌrʌCristo caʌcatai isʌooqui potʌtʌdai saidʌ ʌSuusi maatʌ vʌʌsi istumaasi ivuaadana ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cascʌdʌ aidʌsi aayi ʌSamaariʌrʌ oidacʌdʌ daañimi ʌgai ʌSuusi sai anaasi viʌʌna. Taidʌ ʌSuusi anaasi daja goo tasai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tai vaamioma muidutai vaavoitu caʌcatai istumaasi aagidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Amaasi potʌtʌdai ʌoodami ʌooqui: ―Sivi vaavoitu aatʌmʌ maisiu mosʌcaasi istumaasicʌdʌ gʌraagidi aapi ʌʌgi aatʌmʌ cacaʌ ʌʌpʌ istumaasi gʌraagidi goovai dai cʌʌga maatʌ aatʌmʌ issʌʌlicʌdʌ ʌrʌCristo dai cʌʌgacʌrʌ vuvaidi goovai oodami ―tʌtʌdai oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dai bogooca tasaicʌdʌ ʌSuusi ii Samaariaiñdʌrʌ Galilea dʌvʌʌriamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ɅSuusi pocaititadai sai isʌmo Diuusi ñiooquituldiadamigadʌ gaaagiadagi Diuusi ñiooquidʌ ʌʌgi gʌdʌvʌʌragʌrʌ ami dʌvʌʌriʌrʌ oidacami maiʌʌgiditai caʌcana istumaasi aagiadagi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dai aidʌsi aayi ʌSuusi Galilea dʌvʌʌriʌrʌ baigʌnʌliaracʌdʌ viaatuli dai miaadʌgʌ ʌGalileeʌrʌ oidacami. Ʌgai nʌiditadai vʌʌsi istumaasi idui ʌSuusi Jerusaleenʌrʌ ʌgʌʌ siaa duudagʌrʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Amaasi aa gʌi ʌSuusi Canaamu siaaco idui ʌgai uuvasi varagadʌ suudagicʌdʌ. Dai Capernauumʌrʌ oidacatai ʌmo gʌʌ dunucami. Dai maracatadai ʌgai ʌmo cʌʌli vai aliʌ cooco. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aidʌsi maí ʌdunucami isʌSuusi caaayi Galileeʌrʌ ii ʌgai dai nʌida agai ʌSuusi. Dai daañimi ʌgai ʌSuusi sai imʌna quiidamu dai duaaidana maradʌ ismaacʌdʌ camuuquimi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Amaasi ʌSuusi itʌtʌdai ʌoodami: ―Aapimʌ maivaavoitudai ismainʌijadagi ʌmo istumaasi gʌducami ismaacʌdʌ ivuaadagi aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dʌmos dunucami itʌtʌdai: ―Mamaatʌtuldiadami, timʌda otoma vai maimuucuna giñmara ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Amaasi ʌSuusi itʌtʌdai: ―Noragiñi aapi gʌquiiamu gʌmara cadueeyi ―tʌtʌdai ʌSuusi. Taidʌ ʌcʌʌli vaavoitu ʌSuusi dai ii. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dai voiyʌrʌ aayi pipiooñigadʌ tai ʌgai potʌtʌdai: ―Cadueeyi gʌmara ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Amaasi ʌtʌaanʌdami tʌcacai suu duucu dueeyi. Taidʌ ʌpipiooñigadʌ itʌtʌdai: ―Tacavo moscoi gʌsʌco tasai dagito toiñdagai ―tʌtʌdai ʌpipiooñigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Amaasi ʌali gʌʌli oogadʌ tʌgitu isʌca duucu ʌSuusi aagidi sai cadueeyi maradʌ. Daidʌ ʌdunucami ʌʌmadu vʌʌscatai ismaacʌdʌ quiidʌrʌ oidaga vaavoitu isSuusi ʌrʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ʌgaicʌdʌ casi ʌrgooca istumaasi gʌgʌrducami ismaacʌdʌ idui ʌSuusi Galileeʌrʌ aidʌsi abiaadʌrʌ vuusai Judeeaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dai gooquiʌrʌ ʌpamu ii ʌSuusi Jerusaleenamu dai ami daivuñda agai ʌjudidíu siaa duudagadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusaleenʌrʌ oidaga ʌmo gʌʌ piila. Ami cañiiru cuuparagadʌrʌ tʌʌgidu. Ʌgʌʌ piila Betesada tʌʌgidu ʌjudidíu ñiooquidʌcʌdʌ. Dai sicoli taamadu portatali. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Vai ami portataliana vʌʌtʌcatadai mui coococoidadʌ ʌʌmadu mui maiñʌaadami, ʌʌmadu mui chuchuecugami ʌʌmadu muidutai ismaacʌdʌ maitistutuidi isoiñʌdagi. Vʌʌscatai mosnʌnʌʌracatadai isoiñiagi ʌsuudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ʌʌmo iimidagai tʌapanaiña ʌmo Diuusi tʌaañicarudʌ dai oiñidiña ʌsuudagi. Vai tomasmaacʌdʌ cocoadʌ ismaacʌdʌ ʌʌpʌga vaaquiagi ʌsuudarʌ caoiñicami ʌgai gia duduaadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ʌmo cʌʌli ismaacʌdʌ ami caatʌcatadai viaacatadai ʌmo coobai dan baivʌstaama dan mamaco uumigi iscoococatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Daidʌ ʌSuusi tʌʌgacai dai maatʌcai isʌgai catʌvʌpi mocaatʌcatadai potʌtʌdai: ―¿Ipʌlidipʌsi isduaadiagi? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Taidʌ ʌcocoadʌ itʌtʌdai: ―Mamaatʌtuldiadami, siuu duucu ʌDiuusi tʌaañicarudʌ tʌapanʌdagi dai oiñiadagi ʌsuudagi maitiipucana sioorʌ giñvaasagi suudarʌ. Vʌʌscʌrʌ aanʌ vaaquia iñʌlidiña suudarʌ vai aa giñmamaitʌcʌi dai ʌʌpʌga vaapacʌiña ʌgai suudarʌ ―tʌtʌdai ʌcocoadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Taidʌ ʌSuusi itʌtʌdai: ―Vañiñi dai bʌi gʌvaacosi dai imʌda ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tai otoma dueeyi ʌcʌʌli dai bʌi gʌvaacosi dai gʌaagacai aimʌrai. Dʌmos aidʌ tasʌrʌ ʌribʌstaragaicatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Taidʌ ʌjudidíu potʌtʌdai ʌcʌʌli ismaacʌdʌ dueeyi: ―Sivi ʌribʌstaragai tasʌrʌ dai Moseesacaru sʌʌlicamigadʌ aagai sai maitiipu oigaragai isaata vuaadagi cascʌdʌ maitʌaagai pʌsbʌʌquiagi gʌvaacosi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Taidʌ ʌcʌʌli aa noragi daidʌ itʌtʌdai: ―Ʌgai ismaacʌdʌ giñduaadi giñaagidi ansai bʌʌcaiña giñvaacosi dai imʌdana ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Amaasi ʌjudidíu itʌtʌdai: ―¿Voor gʌaagidi pʌsai bʌʌcaiña gʌvaacosi dai imʌdana? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dʌmos ʌcʌʌli maimaí sioorʌ duaadi, aliʌ muiducatadai oodami cascʌdʌ. Aidʌ ʌSuusi caiitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dai gooquiʌrʌ ʌSuusi tʌʌ ʌcʌʌli ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu daidʌ itʌtʌdai: ―Dañi aapi cadueeyi dai casi maisoimaasi ivuaada tadu vaamioma soimaasi taata aapi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Taidʌ ʌcʌʌli ii abiaadʌrʌ dai aagidi ʌjudidíu saidʌ ʌSuusi ʌgai dai duaadi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Cascʌdʌ ʌjudidíu gaagaitadai ʌSuusi dai muaa ʌliditadai. ɅSuusi ivuaadana naana maasi istumaasi ibʌstaragai tasʌrʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dʌmos ʌSuusi itʌtʌdai ʌjudidíu: ―Diuusi giñooga apiaivueeyi naana maasi gʌgʌrducami vʌʌs tasai dai aanʌ ʌʌpʌ ivueeyi naana maasi gʌgʌrducami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mosaagidi ʌSuusi gomaasi vaidʌ ʌjudidíu vaamioma cʌʌga ipʌliditadai ismuaagi. ɅSuusi maiʌʌgidi ʌjudidíu sʌʌlicamigadʌ aata vuaadatai ibʌstaragai tasʌrʌ dai aagidacai ʌSuusi sai Diuusi ʌroogadʌ. Aagaitai ʌSuusi gomaasi potʌiya ʌlidi sai ʌpan tuiga Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Amaasi ʌSuusi itʌtʌdai: ―Aanʌ angʌnaagidi sai aanʌ Diuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ maitistutuidi isʌʌgi ivuaadagi ʌmo istumaasi. Aanʌ ivueeyi mosʌcaasi istumaasi ivueeyi Diuusi giñooga. Poduucai aanʌ ʌʌmadu giñooga mosʌmadugan duucai ivueeyi istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Giñooga aliʌsi giñoigʌdai dai giñtʌtʌʌgidi vʌʌsi istumaasi ivueeyi ʌgai dai aanʌ iduuñimu naana maasi istumaasi vaamioma gʌgʌrducami siʌgai ismaacʌdʌ casi idui aanʌ. Dai aapimʌ sʌʌlicʌdʌ maitʌʌgi agai istumaasi gʌntʌtʌgitodagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Dai asta duduaacaldiadamu aanʌ ʌʌmo oodami coidadʌ saagidiaiñdʌrʌ poduucai isduucai ivueeyi Diuusi giñooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dai Diuusi giñooga giñmaa sʌʌlicami ansai aanʌ nʌidana vʌʌsi oodami ismaacʌdʌ cʌʌga ivuaadana dai ismaacʌdʌ maicʌʌga ivuaadana. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Vai poduucai vʌʌscatai siaa giñduutuadagi poduucai isduucai siaa duutudai Diuusi giñooga. Aanʌ anʌrDiuusi maradʌ dai tʌvai aanʌ tʌvaagiaiñdʌrʌ dai sioorʌ maisiaa giñduutuadagi ʌgai gia maisiaa duutudai Diuusi giñooga. Ʌgai ʌgai dai giñootoi tami oidigi daama. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sioorʌ gʌntʌgito caʌcagi istumaasi gʌnaagidi aanʌ dai vaavoitudagi Diuusi ʌgai gia sʌʌlicʌdʌ tomastuigaco oidacamu tavaagiʌrʌ Diuusi ʌʌmadu. Dai ʌgai maiiimia agai ʌDiaavora ʌʌmadu cacʌʌgacʌrʌ vuvacʌi ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aanʌ anʌrDiuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ. Dai aanʌ angʌnaagidi sai caaayi istuigaco ʌsoimaasi ivuaadami caʌca agai giññiooqui. Dai sioorʌ giñʌʌgiditai caʌcagi aanʌ cʌʌgacʌrʌ vuvaidamu dai tomastuigaco oidacamu ʌgai Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Diuusi ʌgai dai viaa guvucadagai ismaaquiagi oodami ibʌdagai utudui. Dai aanʌ ʌrDiuusi maradʌ dai Diuusi giñmaa guvucadagai sai aanʌ ʌʌpʌ maacaiña oodami ibʌdagai utudui. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Dai Diuusi giñmaa sʌʌlicami ansai aanʌ nʌidana oodami ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami. Diuusi giñootoi tʌvaagiaiñdʌrʌ saidʌ ivuaadana imaasi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tomasi aapimʌ maitʌtʌʌgiadagi istumaasi gʌntʌtʌgitodagi gomaasicʌdʌ vʌʌscʌrʌ aimu istuigaco vʌʌscatai ismaacʌdʌ cacoi caʌca agai iñsaanʌ Diuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ vapaida agai ");
INSERT INTO ntpNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dai gʌcuucupiocoa agai siaaco yaasapi siʌgai vuvaquimu. Dai ismaacʌdʌ ʌrcʌʌga ivuaadamicatadai tomastuigaco oidaca agai Diuusi ʌʌmadu dai ismaacʌdʌ ʌrsoimaasi ivuaadamicatadai iimia agai ʌDiaavora ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aanʌ ʌʌgi giñsʌʌlicamigacʌdʌ maitivueeyi tomali ʌmo istumaasi. Aanʌ ivueeyi mosʌcaasi istumaasi ipʌlidi Diuusi giñooga. Cascʌdʌ siʌʌscadʌ nʌidi aanʌ sabai cʌʌga ivuaadana siʌpʌ maicʌʌga ivuaadana ʌmo oodami aanʌ ivueeyi istumaasi ʌrsʌʌlicami ʌgaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Iñsaanʌ ʌʌgi gʌnaagidagi iñsaanʌ ʌrʌCristo siaadʌrʌ giñvaavoitudana aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dʌmos isDiuusi gʌnaagidagi iñsaanʌ viaa ʌmo sʌʌlicami aidʌ gia vaavoitudan tada aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aapimʌ ootoi ʌʌmoco sai tʌcacana ʌVuaana soor ʌgai daidʌ ʌVuaana aa istumaasi ʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dʌmos aanʌ maitʌgito ʌmo nʌijadami oodami saagidaiñdʌrʌ isaagagi iñsioorʌ aanʌ. Aanʌ gʌnaagidi gomaasi mʌsai poduucai vaavoitudana aapimʌ iñsaanʌ ʌrʌCristo dai cʌʌgacʌrʌ vuvaacʌna. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Siaaco daacagi ʌmo cuudagi cʌʌ maascana vʌʌsiaʌcatai. Poduucai ʌʌpʌ sioorʌ caʌ istumaasi aagai ʌVuaana cʌʌ maatʌ caʌcana Diuusi ñiooquidʌ. Dai aapimʌ baigʌnʌliaracʌdʌ caʌna ʌgai chiʌʌqui tasai. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dai aanʌ ivueeyi naana maasi istumaasi gʌgʌrducami istumaasi giñtʌjai Diuusi giñooga ansaidʌ ivuaadana dai ʌgaicʌdʌ cʌʌga gʌmaatʌ isDiuusi giñootoi ansai gʌnaagidana ñiooquidʌ ʌgai dai cʌʌga gʌmaatʌ iñsaanʌ viaa ʌmo sʌʌlicami. Dai gomaasicʌdʌ vaamioma cʌʌga gʌmaatʌ iñsioorʌ aanʌ siʌ ʌVuaana ñiooquidʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dai aanʌ ʌrootosadʌ Diuusi giñooga. Dai ʌgai ʌrcaʌcami sai istumaasi aagai aanʌ ʌrvaavoi, tomasi aapimʌ tomali ʌmo imidagai maicaʌ isñioocai ʌgai tomali mainʌidi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dʌmos aapimʌ maisʌʌlicʌdʌ vaavoitudai Diuusi ñiooquidʌ, aapimʌ maitiñvaavoitudai aanʌ Diuusi ootosadʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aapimʌ cʌʌga nʌnʌidi oojai Diuusi ñiooquidʌrʌ poʌliditai ispoduucai tomastuigaco oidaca agai aapimʌ Diuusi ʌʌmadu. Dʌmos Diuusi ñiñiooquituldiadamigadʌ giñaagai Diuusi ñiooquidʌrʌ dai pocaitiña ansai aanʌ ʌrʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Dʌmos aapimʌ maitiñvaavoitudai poduucai siaadʌrʌ tomastuigaco oidacana Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Aanʌ maigaagai sioorʌ cʌʌga ñioocadagi aanʌ gimvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aanʌ cʌʌga gʌnmaatʌ aapimʌ. Maatʌ aanʌ ismaioigʌdai aapimʌ Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aanʌ ʌrootosadʌ Diuusi giñooga dai aapimʌ maitiñvaavoitudai. Dʌmos daivʌitai aa ismaacʌdʌ maitʌrojootosadʌ Diuusi giñooga ʌgai gia vaavoitudadaiña aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aapimʌ maiʌʌgidi Diuusi vai ʌgai cʌʌgacʌrʌ gʌnnʌijadagi baiyoma aapimʌ ipʌlidi isoodami cʌʌga ñioocadagi aapimʌ gʌmvʌʌtarʌ cascʌdʌ maitistutuidi aapimʌ isgiñvaavoitudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aanʌ maigʌpiʌrʌ gʌnsuuliga iñagai Diuusi vuitapi, Moseesacaru ʌgai dai gʌpiʌrʌ gʌnvuupai tomasi aapimʌ pocaiti mʌsai vaavoitudai istumaasi ooja Moseesacaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Issʌʌlicʌdʌ vaavoitudadamudai aapimʌ istumaasi gaaagidi Moseesacaru aidʌ gia aapimʌ giñvaavoitudadamudai aanʌ ʌʌpʌ. Moseesacaru oojadʌrʌ giñaagai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aapimʌ maivaavoitudai istumaasi ooja Moseesacaru cascʌdʌ maivaavoitudai aapimʌ istumaasi gʌnaagidi aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Dai gooquiʌrʌ ii ʌSuusi vaasadʌrʌ ʌgʌʌ suudagi ismaacʌdʌ Galilea tʌʌgidu dai Tibeeriasi tʌʌgidu ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tai mui oodami oí ʌSuusi. Ʌoodami canʌidi isʌSuusi duduaadi mui coococoidadʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aidʌ ʌSuusi tʌsai ʌmo giidiʌrʌ dai modaiva aatʌmʌ mamaatʌrdamigadʌ ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aidʌ camiaadimitadai ʌgʌʌ siaa duudagai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu cajiudadʌ Ejiipituaiñdʌrʌ. Ʌsiaa duudagai pascua tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dai aidʌsi tʌʌ ʌSuusi ismuidutugai oodami, ʌgai gooquiʌrʌ potʌtʌdai ʌPiili: ―¿Siaaco savʌdamu aatʌmʌ cuaadagai mosʌʌqui oodami vʌʌtarʌ? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Suusi aagidi gomaasi ʌPiili maatia ʌliditai istʌiya ʌgai. ɅSuusi camaatʌcatadai istumaasi iduñia agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Amaasi ʌPiili itʌtʌdai: ―Issavʌda aatʌmʌ goo siento piisu aʌcami paana vʌʌscʌrʌ moslaalachi ajian tada goovai ―tʌtʌdai ʌPiili. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Amaasi Aandʌrʌsi potʌtʌdai ʌSuusi: ―Tami cʌʌca ʌmo ali gʌʌli dai viaa taama paana dai gooca vatopa. ¿Dʌmos siaadʌrʌ aʌna goovai mosʌʌqui oodami vʌʌtarʌ? ―tʌtʌdai Aandʌrʌsi. Aandʌrʌsi ʌrʌmoco ʌSuusi mamaatʌrdamigadʌ daidʌ ʌrsuculidʌ ʌSimuñi Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Amaasi ʌSuusi itʌtʌdai: ―Aagidavurai gooodami vai daraivana ―tʌtʌdai ʌSuusi. Aliʌ vaasoacatadai ami oidigi tai ami daraiva ʌoodami. Ʌgai ajʌacatadai parʌ taam mil cʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Amaasi ʌSuusi vui ʌpaana dai aagidi Diuusi sai aliʌsi baigʌʌlidi oidacatai cuaadagai. Dai amaasi ʌSuusi gʌrmaa ʌpaana tʌsai aatʌmʌ taacogidana ʌoodami daidʌ taacogi ʌvatopa ʌʌpʌ tai ʌgai uu vʌʌsi siʌʌjʌsi ipʌli. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dai catatascovai vʌʌscatai taidʌ ʌSuusi povʌrtʌtʌdai: ―Ʌmpaidavurai aapimʌ gosaasaquigadʌ ismaacʌdʌ baivito vai maisuuligagi toma lʌʌchi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tʌtai aatʌmʌ ʌmpagi saasaquigadʌ ismaacʌdʌ vii tai suusuda baivustan dan goo aasarai ʌpaana saasaquigadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amaasi ʌoodami tʌʌgacai isSuusi idui gomaasi gʌducami pocaiti: ―Sʌʌlicʌdʌ ʌrvaavoi isidi cʌʌli ʌrʌDiuusi ñiooquituldiadamigadʌ ismaacʌdʌ divia agaitadai tami oidigi daama ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Dʌmos ʌSuusi maatʌcatadai isʌoodami poipʌliditadai isʌgai ʌrraígadʌ cascʌdʌ goguama vaidaquia agaitadai saidʌ ʌrraígadʌcana dʌmos ʌSuusi maitipʌliditadai, cascʌdʌ ʌʌgi ii abiaadʌrʌ sibʌacoga ami giidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dai aidʌsi cadidiaimi aatʌmʌ mamaatʌrdamigadʌ ʌSuusi tʌaapai ʌgʌʌ suudagi ugidiana. Amaasi catuca taidʌ ʌSuusi maiquiaa divia, ");
INSERT INTO ntpNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","taidʌ aatʌmʌ ʌmamaatʌrdamigadʌ tʌʌtʌsai vaarcuʌrʌ dai dʌgavusquimi ʌgʌʌ suudagi Capernauumamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Daidʌ ʌvaarcu vuidʌrʌ cavami vustai ʌʌvʌʌli dai taí vapañigʌi suudagi dai mʌʌ vaarcuaba aastʌcʌi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dai aidʌsi caiji aatʌmʌ parʌ taam mil metro ʌgʌʌ suudagi daama todian duucai tʌʌ aatʌmʌ ʌSuusi issuudagi daama imʌitadai dai aliʌ duduaadimu aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dʌmos ʌSuusi povʌrtʌtʌdai: ―Aanʌana. Maitavʌrduduaadicuda ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Amaasi baigʌrʌliaracʌdʌ miaadʌgi aatʌmʌ taidʌ ʌSuusi tʌsai ʌvaarcuʌrʌ dai otoma aayi aatʌmʌ mʌʌca siaaco iimia ragaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dai siaadico ʌoodami ismaacʌdʌ vaasadʌrʌ ʌgʌʌ suudagi viitadai maatʌ tʌʌ iscaiji aatʌmʌ abiaadʌrʌ ʌvaarcuʌrʌ dai ami maitiipucatadai ʌmai vaarcu. Dai maí ʌgai isʌSuusi maitʌroí. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Vʌʌscʌrʌ aa cʌcʌʌli aayi aa vaarcuʌrʌ Tibeeriasiaiñdʌrʌ dai ami tuutui ʌgai ʌvaarcu miaanai siaaco ʌSuusi baigʌʌliaracʌdʌ bibi ʌoodami gamamadacai. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aidʌsi ʌoodami maí ismaitiipu ʌSuusi tomali aatʌmʌ mamaatʌrdamigadʌ aidʌ gia tʌtʌsai ʌgai ʌvaarcuʌrʌ dai iji Capernauumamu dai gaaga agai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mosaayi ʌoodami vaasadʌrʌ ʌgʌʌ suudagi dai tʌʌ ʌSuusi daidʌ itʌtʌdai: ―Mamaatʌtuldiadami, ¿pʌtʌquidʌ aayi aapi tami? ―tʌtʌdai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Taidʌ ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ giñgaagaitadai aapimʌ tatasconʌcai ʌcuaadagaicʌdʌ ismaacʌdʌ gʌmbii aanʌ dai maisiu maatʌ nʌiditai istumaasi gʌgʌrducami ismaacʌdʌ ivueeyi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Maitʌaagai isvuaamʌ ʌnʌliada aapimʌ cuaadagaicʌdʌ otoma uugiatʌi cuaadagai cascʌdʌ. Baiyoma aliʌsi gʌaagai mʌscʌʌga gʌntʌgito caʌcagi istumaasi gʌnaagidi aanʌ dai poduucai cʌʌgacʌrʌ vuvaquiagi dai tomastuigaco oidacagi tʌvaagiʌrʌ. Giññiooqui ʌrʌpan ducami cuaadagai ismaacʌdʌ tomali ʌmo imidagai maiuugiatʌi. Aanʌ ʌgai dai viaa ʌmo sʌʌlicami ismaacʌdʌ giñmaa Diuusi giñooga. Cascʌdʌ aanʌ gʌnmaaquimu ibʌdagai utudui dai ʌgaicʌdʌ tomastuigaco oidacamu aapimʌ tʌvaagiʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Amaasi ʌoodami itʌtʌdai: ―¿Tumaasi gʌaagai isivuaada aatʌmʌ dai poduucai ivuaadagi istumaasi Diuusi ipʌlidi? ―tʌtʌdai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Diuusi ipʌlidi isaapimʌ giñvaavoitudagi. Aanʌ giñootoi Diuusi ansaidʌ cʌʌgacʌrʌ vuvaidana oodami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Amaasi ʌoodami itʌtʌdai: ―¿Tumaasi istumaasi gʌducami iduñia agai aapi tʌtai nʌijada aatʌmʌ dai gʌvaavoitudagi? ");
INSERT INTO ntpNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gʌrʌʌqui aaduñicaru gau ʌmaná oidigana dai podu oojisi Diuusi ñiooquidʌrʌ: “Diuusi bibi ʌgai ʌpaana tʌvaagiaiñdʌrʌ” ―tʌtʌdai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Taidʌ ʌSuusi itʌtʌdai: ―Vaavuava, isgiñooga ʌgai dai maa ʌoodami ʌpaana tʌvaagiaiñdʌrʌ maisiuu Moseesacaru. Dai sivi Diuusi giñooga gʌnmaacai aapimʌ ʌpaana tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Daidʌ ʌpaana ismaacʌdʌ Diuusi gamaacai sivi tʌvai tʌvaagiaiñdʌrʌ dai ʌgaicʌdʌ ʌoodami tomastuigaco oidacagi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Amaasi ʌoodami itʌtʌdai: ―Gʌroidañi gopaana tʌvaagiaiñdʌrʌ ―tʌtʌdai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ anʌrʌpan ducami paana ʌgai vʌʌtarʌ ismaacʌdʌ maacai aanʌ ibʌdagai utudui giñvaavoitudacai ʌgai. Dai poduucai ʌgai camaibiuugicoñicamu tomali maitonocoñicamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dʌmos casi gʌnaagidi aanʌ sai aapimʌ maitiñvaavoitudai tomasi casi giñnʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tomasioorʌ sioorʌ Diuusi giñooga ipʌlidi sai giñʌʌgidiña ʌgai gia giñvaavoitudai dai aanʌ maigajiaadʌrʌ vipieeyi tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Dai aanʌ tʌvai tʌvaagiaiñdʌrʌ dai maisiu ivuaada iñagai istumaasi ʌʌgi ipʌliadagi aanʌ baiyoma aanʌ ipʌlidi isivuaadagi istumaasi ipʌlidi Diuusi giñooga. Ʌgai ʌgai daidi giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Daidʌ giñooga ipʌlidi ansai aanʌ cʌʌgacʌrʌ vuvaidiña vʌʌscatai ismaacʌdʌ ʌgai ʌco vuvaitu dai ansai aanʌ duduaacaldana vʌʌsi ʌvaavoitudadami coidadʌ saagidiaiñdʌrʌ siʌʌscadʌ caugitiagi oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Diuusi giñooga ipʌlidi isvʌʌscatai ismaacʌdʌ giñnʌidi dai giñvaavoitudai tomasguigaco oidacana tʌvaagiʌrʌ dai aanʌ duduaacalda iñagai ʌgai siʌʌscadʌ caugitiagi oidigi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Vaidʌ ʌjudidíu vui ñiooquimi ʌSuusi. ɅSuusi pocaititadai saidʌ ʌrʌpan ducami ʌpaana dai sai ʌgai tʌvai tʌvaagiaiñdʌrʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Daidʌ ʌjudidíu pocaiti: ―¿Maitasi ʌrOsee maradʌ idi cʌʌli? Cʌʌga maatʌ aatʌmʌ dʌʌdʌdʌ. ¿Tuisi pocaiti goovai saidʌ tʌvai tʌvaagiaiñdʌrʌ? ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Amasi ʌSuusi itʌtʌdai: ―Casiavʌr maitiññiooquiada aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mosʌcaasi ʌgai ismaacʌdʌ Diuusi ipʌlidi sai giñʌʌgidiña ʌgai gia giñvaavoitudai. Diuusi giñooga giñootoi tami oidigi daama ansaidʌ cʌʌgacʌrʌ vuvaidana sioorʌ giñvaavoitudagi dai aanʌ duduaacaldamu vʌʌsi vaavoitudadami siʌʌscadʌ ugitiagi oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diuusi ñiñiooquituldiadamigadʌ ooja Diuusi ñiooquidʌrʌ dai poduu ooja: “Diuusi maatʌtuldiamu oodami sioorʌ ʌrʌCristo”, ascaiti Diuusi ñiñiooquituldiadamigadʌ. Poduucai tomasioorʌ sioorʌ ʌʌgiditai caʌ Diuusi giñooga giñvaavoitudai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tomali ʌmo oodami oidigi daama oidacami mainʌidi Diuusi. Mosʌcaasi aanʌ nʌidi Diuusi. Aanʌ divia tʌvaagiaiñdʌrʌ siaaco daja Diuusi. Aanʌ ʌrDiuusi maradʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Vaavuava sai sioorʌ giñvaavoitudai tomastuigaco oidaca agai tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aanʌ anʌrʌpan ducami ʌpaana oodami vʌʌtarʌ. Aanʌ cʌʌgacʌrʌ vuvaidi oodami vai ʌgai tomastuigaco oidacagi tʌvaagiʌrʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gʌnʌʌqui aaduñicaru oidigana gau ʌpaana ismaacʌdʌ ʌmaná tʌʌgiducatadai dʌmos vʌʌscʌrʌ coi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dʌmos tomasioorʌ sioorʌ cueeyi ʌpaana ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ ʌgai gia maiimia agai ʌDiaavora ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aanʌ antʌvai tʌvaagiaiñdʌrʌ dai aanʌ ʌrʌpan ducami ʌpaana dai tomasioorʌ sioorʌ giñugiagi tomastuigaco oidacamu tʌvaagiʌrʌ. Aanʌ muuquimu curusiaba vai poduucai mui oodami tomastuigaco oidacana tʌvaagiʌrʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Amaasi ʌjudidíu gʌnaatagidimi aipacoga daidi pocaiti: ―¿Ducatʌ istutuidi goovai isgʌrbiidagi gʌtuucuga tʌsai uugana? ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","54","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ anʌviaa ʌmo sʌʌlicami namʌacami. Daidʌ ʌoodami giñmuaamu ʌmo curusiaba siastimu giñʌʌra vai tomasioorʌ sioorʌ vaavoitudagi iñsaanʌr ʌcʌʌgacʌrʌ vuviadami ʌgai gia tomastuigaco oidaca agai tʌvaagiʌrʌ Diuusi ʌʌmadu dai aanʌ duduaacaldamu ʌgai siʌʌscadʌ caugitiagi oidigi. Dʌmos sioorʌ maitiñvaavoitudagi ʌgai gia maiiimia agai tʌvaagiamu tomali maioidaca agai Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cascʌdʌ aliʌsi gʌaagai iñsaanʌ muuquiagi curusiaba vai astiagi giñʌʌra mosʌcaasi poduucai istutuidi ʌoodami iscʌʌgacʌrʌ vuvaquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sioorʌ giñvaavoitudagi giñʌma daacamu ʌgai dai soiñamu aanʌ ʌgai sai cʌʌgacʌrʌ oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Diuusi giñooga giñootoi dai ʌgai tomastuigaco oidaga dai cascʌdʌ aanʌ ʌʌpʌ tomastuigaco oidaga poduucai ʌʌpʌ sioorʌ giñvaavoitudagi tomastuigaco oidaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aanʌ anʌrʌpan ducami ʌpaana dai tʌvai aanʌ tʌvaagiaiñdʌrʌ. Ʌpaana ismaacʌdʌ maná tʌʌgidu tai uu gʌnʌʌqui aaduñicaru maitʌrsoiñicatadai istomastuigaco oidacagi. Dʌmos sioorʌ giñvaavoitudagi dai giñʌʌgiadagi ʌgai gia tomastuigaco oidaca agai tʌvaagiʌrʌ Diuusi ʌʌmadu ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Gomaasi gamamaatʌtuli ʌSuusi ʌjudidíu quiuupaigadʌrʌ Capernauumʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dai muidutai ismaacʌdʌ oiditadai ʌSuusi moscaʌ gomaasi daidʌ icaiti: ―Sʌʌlicʌdʌ sijaiga ismaatʌ caʌcagi aatʌmʌ idi ñiooqui. ¿Siaadʌrʌ istuidana oodami isʌʌgiadagi gomaasi? ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Amaasi ʌSuusi maí isʌoodami maibaigʌnʌʌli gomaasicʌdʌ ismaacʌdʌ aagiditadai ʌgai cascʌdʌ itʌtʌdai: ―¿Gʌnsobicʌisi aanʌ idi ñiooquicʌdʌ isvaavoituda aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Isducatai gʌntʌtʌgitona aapimʌ mʌsgiñtʌʌgiagi aanʌ ismaacʌdʌ viaa ʌmo sʌʌlicami isnoragiagi aanʌ tʌvaagiamu? ");
INSERT INTO ntpNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diuusi Ibʌadʌ ʌgai dai maacai oodami ibʌdagai utudui. Giñtuucuga maisoicʌi oodami sai cʌʌgacʌrʌ vuvacʌna mosʌcaasi giñibʌdaga. Istumaasi aagai aanʌ ʌrgaibʌdaga vʌʌtarʌ maisiu gatuucuga. Tomasioorʌ sioorʌ vaavoitudagi goñiooqui ismaacʌdʌ gʌnaagidi aanʌ ʌgai gia viaaca agai ibʌdagai utudui dai tomastuigaco oidaca agai tʌvaagiʌrʌ Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dʌmos quiaa oidaga ʌʌmoco aapimʌ gʌnsaagida ismaacʌdʌ maivaavoitudai ―tʌtʌdai ʌSuusi. ɅSuusi maí tucamidʌrʌ abiaadʌrʌ ismaacʌdʌ mamaatʌrdamigadʌ maivaavoitudaitadai dai ismaacʌdʌ mamaatʌrdamigadʌaiñdʌrʌ gatʌʌgida agaitadai mʌsai muaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Daidʌ ʌSuusi itʌtʌdai ʌoodami: ―Cascʌdʌ casi gʌnaagidi aanʌ sai mosʌcaasi ʌgai ismaacʌdʌ Diuusi giñooga ipʌlidi isgiñʌʌgidiña ʌgai gia giñvaavoitudai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aidʌ abiaadʌrʌ muidutai ismaacʌdʌ oidatucuitadai ʌSuusi ʌcovai iji dai camaioidatucui ʌgai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Amaasi ʌSuusi povʌrtʌtʌdai aatʌmʌ ʌbaivustan dan gooca mamaatʌrdamigadʌ: ―¿Giñdagitoamʌsi ʌlidi aapimʌ ʌʌpʌ? ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tai Simuñi Piiduru itʌtʌdai: ―¿Siaadʌrʌ gʌdagitona aatʌmʌ? Aapi ʌrgʌrbaitʌcʌaacami. Dai gʌmamaatʌtuldiaragacʌdʌ camaatʌ aatʌmʌ isducatai cʌʌgacʌrʌ vuvacʌi oodami dai tomastuigaco oidaca agai tʌvaagiʌrʌ Diuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dai aatʌmʌ cavaavoitu. Dai cʌʌ maatʌ aatʌmʌ isaapi ʌrʌCristo Diuusi maradʌ dai tʌvai tʌvaagiaiñdʌrʌ. Dai Diuusi tomastuigaco oidaga ―tʌtʌdai Simuñi Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Ʌcovai gʌnvuvaitu aanʌ baivustan dan gooca aapimʌ dai ʌmoco ʌrʌDiaavora piooñigadʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ɅSuusi aagidi gomaasi aagaitai ʌUudasi Iscaliote ʌSimuñi maradʌ. Dai tomaasi ʌgai ʌrʌmoco ʌbaivustan dan gooca mamaatʌrdamigadʌ ʌSuusi, vʌʌscʌrʌ Uudasi gatʌʌgida agaitadai mʌsai muaana ʌSuusi cascʌdʌ pocaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dai gooquiʌrʌ ʌSuusi aimʌraitadai ʌGalilea dʌvʌʌriʌrʌ. Ʌgai maitipʌli isaimʌrdagi Judeea dʌvʌʌriʌrʌ, ʌjudidíu ipʌliditadai ismuaagi ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dai camiaadimi ʌsiaa duudagadʌ ʌjudidíu istuigaco ivuaadana uucusai cascʌdʌ potʌʌgidi ʌsiaa duudagai uucusai. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Taidʌ ʌSuusi susuculidʌ itʌtʌdai: ―Maiviimu aapi tanai. Imʌdañi aapi Judeea dʌvʌʌriamu vai poduucai gʌoidatucʌdami ismaacʌdʌ mʌʌca daraaja nʌijadagi istumaasi ivueeyi aapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tomasioorʌ sioorʌ ipʌliadagi ismaatʌcagi oodami istumaasi ivueeyi ʌgai gia maiʌstocai ivueeyi istumaasi. Issʌʌlicʌdʌ ivueeyi aapi naana maasi istumaasi aidʌ gia ivuaadañi gomaasi ʌoodami vuitapi vai nʌijada ʌgai vʌʌscatai ―tʌtʌdai ʌSuusi susuculidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Dʌmos tomali ʌgai maivaavoitudaitadai ʌSuusi cascʌdʌ pocaiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Amaasi ʌSuusi itʌtʌdai: ―Maiquiaa aayi istuigaco imia aanʌ gaamucu. Dʌmos aapimʌ cʌʌga istutuidi isgaamucu iimiagi tomasiʌʌscʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ʌoodami ismaacʌdʌ maivaavoitudai Diuusi maitʌncʌʌdai aapimʌ mosʌca aanʌ. Aanʌ aagidi saidʌ ʌrsoimaasi ivuaadami ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Iimivurai aapimʌ gaamucu idi siaa duudagʌrʌ. Aanʌ gia maiimimu. Maiquiaa aayi istuigaco imiagi aanʌ cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Dai mospotʌtʌdai ʌSuusi dai anaasi Galilea dʌvʌʌriʌrʌ vii. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amaasi caiji ʌSuusi susuculidʌ tai gooquiʌrʌ ii ʌSuusi ʌʌpʌ ʌsiaa duudagamu. Ʌgai gʌʌsto ii sai mainʌidiña oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ʌjudidíu gaagai ʌSuusi ʌsiaa duudagʌrʌ daidʌ icaiti: ―¿Siaaco daja ʌcʌʌli? ―caiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dai aliʌsi gʌnaatagidimi ʌoodami aipacoga aagaitai ʌSuusi. Dai ʌʌmoco pocaiti sai cʌʌ tuiga ʌgai. Dai aa pocaiti sai maicʌʌ tuiga sai mosyaatagidi ʌgai oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dʌmos ʌoodami ismaacʌdʌ cʌʌga ñioocai ʌSuusi vʌʌtarʌ maitipʌli ismaatʌcagi ʌjudidíu tʌtʌaanʌdami iscʌʌga ñioocai ʌgai ʌSuusi vʌʌtarʌ ʌbʌidi ʌgai cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aidʌsi catajucami viitugai isugitiagi ʌvagimi ii ʌSuusi ʌjudidíu gʌʌ quiuupaigadʌamu dai ami gamamaatʌtuldi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Daidʌ ʌtʌtʌaanʌdamigadʌ ʌjudidíu maitʌʌ istumaasi gʌntʌtʌgitoagi caʌcatai ʌSuusi daidʌ icaiti: ―¿Ducatai maatʌ idi cʌʌli mosʌʌ naana maasi istumaasi maitʌvʌpi daivacai oojʌrʌ? ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Istumaasi gamamaatʌtuldi aanʌ ʌrDiuusi ñiooquidʌ maisiu aanʌ ʌʌgi. Ʌgai giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dai sioorʌ ipʌliadagi isivuaadagi istumaasi Diuusi ipʌlidi ʌgai gia maatʌmu isgiñmamaatʌtuldaraga ʌrDiuusi ñiooquidʌ siʌpʌ sabai aanʌ gamamaatʌtuldi istumaasi ʌʌgi aanʌ ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sioorʌ gaaagiadagi mosʌcaasi istumaasi ʌʌgi ʌgai tʌtʌgitodagi ʌgai povuaadana sai oodami cʌʌga ñioocaiña ʌgai vʌʌtarʌ. Dʌmos sioorʌ ipʌliadagi isʌoodami cʌʌga ñioocadagi ʌgai vʌʌtarʌ ismaacʌdʌ ootoi ʌgai gia gaaagidi istumaasi ʌrvaavoi dai tomali ʌmo imidagai maiyaatagidiña ʌgai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Vaavuava isMoseesacaru gʌrmaa ʌsʌʌlicami dʌmos tomali ʌmaadutai aapimʌ maiʌʌgidi vʌʌsi ʌsʌʌlicami. ¿Tuimʌsi giñmuaa ʌlidi aapimʌ? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Taidʌ ʌoodami itʌtʌdai: ―Aapi viaa ʌmo Diaavora tʌaañicarudʌ. ¿Voorʌ gʌmuaa ʌlidi? ―tʌtʌdai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ idui ʌmo istumaasi ʌmo ibʌstaragai tasʌrʌ dai aapimʌ maitʌʌ istumaasi gʌntʌtʌgitoagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dʌmos aapimʌ iiquitʌcʌi aali tuutucugadʌ tomasi ʌribʌstaragai tasʌrʌ. Moseesacaru gʌntʌjai mʌsai poduucai ivuaadana cascʌdʌ poduucai ivueeyi aapimʌ. Vʌʌscʌrʌ ʌʌqui abiaadʌrʌ capovuaadana gʌrʌʌqui aaduñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Isaapimʌ ivueeyi gomaasi tomasi ʌrʌmo ibʌstaragai tasʌrʌ ʌʌgida ʌliditai Moseesacaru sʌʌlicamigadʌ, ¿tuimʌsi bacocoi aapimʌ aanʌ giñvui duaaidacai aanʌ ʌmo cʌʌli ʌmo ibʌstaragai tasʌrʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Cʌʌgavʌr gʌntʌtʌgito aapimʌ. Maisiu gʌpiʌr giñvuupada maicʌʌga gʌntʌtʌgitoitai, baiyomavʌr cʌʌga gʌntʌtʌgitoda aapimʌ istumaasi ʌrsʌʌlicami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Amaasi ʌʌmoco ʌJerusaleenʌrʌ oidacami aipacoga gʌntʌcacaimi dai pocaitimi: ―¿Maitasi ʌridi cʌʌli ʌgai mʌsmaacʌdʌ gaagai dai muaa agai? ");
INSERT INTO ntpNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mosmocʌʌca goovai dai mamaatʌtuldi gooodami vai tomali ʌmaadutai maivui ñioocai. ¿Maisiu cavaavoitu ʌjudidíu tʌtʌaanʌdamigadʌ isgoovai ʌrʌCristo? ");
INSERT INTO ntpNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Siaadʌr ʌrʌCristocana goovai. Aatʌmʌ cʌʌ maatʌ siaaco oidaga idi cʌʌli. Siʌʌscadʌ diviagi ʌCristo tomali ʌmaadutai maimaatʌca agai siaadʌrʌ divia agai ʌgai ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Daidʌ ʌSuusi quiaa mamaatʌtulditadai ʌoodami ʌgʌʌ quiuupiʌrʌ dai caʌcai istumaasi aagai ʌoodami cavami ñioo ʌgai dai potʌtʌdai: ―Vaavuava ismaatʌ aapimʌ siaaco oidaga aanʌ. Dʌmos maimaatʌ aapimʌ sioorʌ giñootoi. Aanʌ divia maisiu mosʌʌgi ipʌliditai aanʌ baiyoma ʌgai ismaacʌdʌ tomali ʌmo imidagai maiyaatagʌi atgiñootoi. Vʌʌsi istumaasi aagai ʌgai ʌrvaavoi. Dai aapimʌ maimaatʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aanʌ gia maatʌ ʌgai. Aanʌ ʌgai ʌʌmadu daacatadai tai ʌgai giñootoi tami oidigi daama ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Amaasi ʌoodami bʌiya ʌliditadai ʌSuusi dai maisagi dʌmos tomali ʌmaadutai maibʌi, maiquiaa aayi istuigaco cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dai vʌʌscʌrʌ muidutai vaavoitu ʌSuusi daidʌ icaiti: ―Siʌʌscadʌ diviagi ʌCristo siaadʌrʌ iduuna ʌgai vaamioma gʌgʌrducami istumaasi isidi cʌʌli ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amaasi ʌfariseo caʌcai ispocaiti ʌoodami aagaitai ʌSuusi ʌgai ʌʌmadu ʌbaitʌgucacamigadʌ ʌpapaali judidíu ootoi sandaaru ismaacʌdʌ nuucada ʌquiuupai sai bʌʌna ʌSuusi dai maisana. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Taidʌ ʌSuusi itʌtʌdai: ―Chiʌʌqui tasai daacamu aanʌ aapimʌ gʌnsaagida dai gooquiʌrʌ noragimu aanʌ dai ʌʌmadu daacamu ʌgai ismaacʌdʌ giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aapimʌ giñgaagamu dai maitiñtʌʌgimu. Aapimʌ maitistutuidi isiimiagi mʌʌca siaaco daaca aanʌ cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Amaasi ʌjudidíu aipaco gʌtʌcacaimi daidʌ icaiti: ―¿Siaaco imia agai idi cʌʌli tʌsai maitʌʌgana aatʌmʌ? ¿Imia ʌlidi lienʌ goovai ʌjudidíu ʌʌmadu ismaacʌdʌ ʌgiliego saagida oidaga mamaatʌtulda ʌlidi lienʌ goovai ʌgiliego? ");
INSERT INTO ntpNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Istʌiya ʌlidi goovai dai pocaiti tʌsai gaaga ragai dai maitʌʌgia ragai, dai sai aatʌmʌ maitistutuidi isiimiagi mʌʌca siaaco daaca agai ʌgai? ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ʌcuugatʌrʌ tasʌrʌ ʌsiaa duudagʌrʌ vaamioma namʌga isʌgaa tasai. Amaasi ʌSuusi cʌquiva dai cavami ñioo dai potʌtʌdai ʌoodami: ―Sioorʌ ipʌliadagi iscʌʌgacʌrʌ vuvaquiagi vai dadana dai giñcaʌcana. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Poduucai oojisi Diuusi ñiooquidʌrʌ sai tomasioorʌ giñvaavoitudagi ʌgai gia viaacamu guvucadagai isaagidagi muidutai isducatai Diuusi cʌʌgacʌrʌ vuuvaidi oodami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pocaiti ʌSuusi vai maatʌca ʌoodami isDiuusi Ibʌadʌ ʌʌmadu daacana sioorʌ vaavoitudagi ʌgai. Aidʌ maiquiaa tʌvai Diuusi Ibʌadʌ tʌvaagiaiñdʌrʌ. ɅSuusi maiquiaa ii tʌvaagiamu cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ʌʌmo oodami moscaʌ gomaasi daidʌ icaiti: ―Sʌʌlicʌdʌ ʌrvaavoi isidi cʌʌli ʌrʌDiuusi ñiooquituldiadamigadʌ ismaacʌdʌ Moseesacaru aagai sai divia agai ―caiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dai aa icaiti: ―Idiava ʌrʌCristo ―caiti. Dʌmos aa icaiti: ―ɅCristo maidivia agai Galileeaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pocaiti Diuusi ñiooquidʌrʌ saidʌ ʌCristo ʌrDavicaru cajiudadʌca agai, dai Beleenʌrʌ vuusia agai ʌgai vaa ali quiiyʌrʌ siaaco vuusai Davicaru ―caiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Poduucai ʌoodami maiʌmadugan caiti aagaitai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ʌʌmoco bʌiya ʌlidi dai maisagi dʌmos tomali ʌmaadutai maibʌi. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ʌsandaarugadʌ ʌgʌʌ quiuupai ʌpamu dada siaaco daraacatadai ʌfariseo ʌʌmadu ʌbaitʌgucacamigadʌ ʌpapaali judidíu tai ʌgai itʌtʌdai: ―¿Tuimʌsi maivuaa aapimʌ ʌSuusi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Taidʌ ʌsandaaru aa noragi daidʌ itʌtʌdai: ―Tomali ʌmo imidagai tomali ʌmaadutai maiʌpan duucai ñioocaiña idi cʌʌli ―astʌtʌdai ʌsandaaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amaasi ʌfariseo itʌtʌdai: ―¿Aapimʌ mʌscasi ʌndagitu ʌʌpʌ isgʌnyaataida ʌgai? ");
INSERT INTO ntpNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tomali ʌmaadutai aatʌmʌ dudunucamigadʌ ʌjudidíu daidʌ ʌfariseo maivaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dʌmos idi oodami maicʌʌ maatʌ Moseesacaru sʌʌlicamigadʌ. Dai sʌʌlicʌdʌ Diuusi soimaasi taatatuldiamu ʌgai vaavoitudaitai ʌgai ʌcʌʌli ―astʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Taidʌ ʌNicodemo, ʌgai vaa ismaacʌdʌ diviji ʌSuusi tucarʌ, ʌrʌmo fariseo daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Gʌrsʌʌlicamiʌrʌ pocaiti sai maitʌaagai ispocaitiadagi sai ʌmo cʌʌli ʌrgʌpiʌr caatʌcami asta siʌʌscadʌ vuaa ʌcʌʌli dai tʌcacagi dai maatʌcagi istumaasi idui ʌgai sabai gʌpiʌr caatʌcami ischo ʌʌpʌ ―astʌtʌdai ʌNicodemo. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Amaasi ʌgaa aa noragi daidʌ itʌtʌdai: ―¿Aapipʌsi ʌrGalileeʌrʌ oidacami ʌʌpʌ? Gaagañi aapi Diuusi ñiooquidʌrʌ dai nʌidamu aapi sai tomali ʌmo Diuusi ñiooquituldiadamigadʌ maivuusai Galileeaiñdʌrʌ ―astʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Amaasi vʌʌscatai noonora. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Daidʌ ʌSuusi ii ʌOliivosi giidiamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dai siaadico mosmaasico ʌʌpamu ii ʌgai quiuupiamu. Tai vʌʌscatai dada siaaco daacatadai ʌSuusi vai ʌgai mamaatʌtuldimi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dai quiaa ñioocaitadai ʌSuusi tai dada ʌfariseo ʌʌmadu ʌdudunucamigadʌ ʌjudidíu dai vuaa ʌmo ooqui ismaacʌdʌ gogoosi gʌducami dai aa tʌʌ isʌma voopoi ʌmo cʌʌli ismaacʌdʌ maitʌrcunadʌ. Daidʌ ʌfariseo ʌoodami vuitapi van cʌi ʌooqui, ");
INSERT INTO ntpNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","daidi itʌtʌdai ʌfariseo ʌSuusi: ―Mamaatʌtuldiadami, ʌʌmoco tʌʌ idi ooqui isʌʌmadu voopoi ʌmo cʌʌli ismaacʌdʌ maitʌrcunadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moseesacaru sʌʌlicamigadʌrʌ pocaiti sai gʌaagai iscoodadagi ismaacʌdʌ googosi gʌnducami ojoodaicʌdʌ. ¿Aapio pʌcaiti? ―tʌtʌdai ʌfariseo ʌʌmadu ʌgaa. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pocaiti ʌgai mosnʌijada ʌliditai astʌʌna ʌSuusi gaagaitadai ʌgai isducatai gʌpiʌr vuaajagi ʌSuusi. Dʌmos ʌSuusi cuicʌʌsa dai ooja dʌvʌʌrapi gʌmasavicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dai ʌgaa apiatʌcacaimi, taidʌ ʌSuusi cʌquiva daidʌ itʌtʌdai: ―Tomasmaacʌdʌ aapimʌ mʌsmaacʌdʌ vuaa goooqui dai ismaacʌdʌ tomali ʌmo imidagai maisoimaasi ivuaadana vai ʌpʌga maiñana goooqui ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dai ʌpamu cuicʌʌsa dai gaooja dʌvʌʌrapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dʌmos ʌgai ismaacʌdʌ vuaa ʌooqui moscaʌ istumaasi aagai ʌSuusi dai mosʌʌmadutai iimimi. Ʌʌpʌga ʌcʌcʌʌliocoidadioma dai gooquiʌrʌ ʌuutuducʌdioma maatʌcatai vʌʌscatai isʌrsoimaasi ivuaadami. Dai maivii tomali ʌmoco mosʌʌgi vii ʌSuusi ʌʌmadu ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Amaasi ʌSuusi cʌquiva dai camaitʌʌ tomali ʌmaadutai ʌgaa, potʌtʌdai ʌgai ʌooqui: ―¿Siaaco duudui ʌoodami ismaacʌdʌ gʌpiʌrʌ gʌvuupai? ¿Camaitiipu sioorʌ gʌmaicarsagi? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tai ʌooqui potʌtʌdai: ―Chu. Camaitiipu, tomali ʌmaadutai ―tʌtʌdai. Amaasi ʌSuusi itʌtʌdai: ―Tomali aanʌ maitʌmaicarsamu. Sivi gia imʌdañi dai camaisoimaasi ivuaada ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Daidʌ ʌSuusi apiaaatagidimi ʌoodami ismaacʌdʌ ʌʌmadu aatagaitadai: ―Aanʌ anʌsoicʌi ʌoodami iscʌʌga maatʌ caʌcagi istumaasi Diuusi ipʌlidi isivuaadagi. Dai sioorʌ giñvaavoitudai ʌgai gia viaacamu ibʌdagai utudui dai camaioojiadamu issoimaasi ivuaadagi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Amaasi ʌfariseo itʌtʌdai ʌSuusi: ―Aapi cʌʌga ñioocai ʌʌgi gʌvʌʌtarʌ dʌmos gʌñiooqui maiñamʌga ―tʌtʌdai ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Daidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Tomasi ʌʌgi aanʌ cʌʌga ñioocai giñvʌʌtarʌ vʌʌscʌrʌ sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai aanʌ. Cʌʌ maatʌ aanʌ iñsiaadʌrʌ divia dai iñsiaaco imia iñagai dʌmos aapimʌ gia maimaatʌ iñsiaadʌr divia tomali iñsiaaco imia iñagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aapimʌ caʌ istumaasi aagai aanʌ dai pocaiti sai maiñamʌga giñiooqui maimaatʌcatai sioor aanʌ dʌmos aanʌ maigʌpiʌr vuupai tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dʌmos isgʌpiʌr gʌnvuupadamudai aanʌ istumaasi aagadamudai ʌrsʌʌlicamicamudai. Aanʌ maiʌʌgi gʌpiʌr gʌnvuupadamudai. Diuusi giñoogai ismaacʌdʌ giñootoi ʌgai gʌpiʌr gʌnvuupai aanʌ iñʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dai Moseesacaru sʌʌlicamigadʌrʌ pocaiti sai siʌʌscadʌ gooca cʌcʌʌli nʌijadami ʌmadugan caitiadagi aliʌsi gʌaagai isvaavoitudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aanʌ anʌrʌmo nʌijadami daidʌ giñooga ismaacʌdʌ giñootoi ʌgai ʌrʌmai nʌijadami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Amaasi ʌgaa itʌtʌdai: ―¿Vaa daja gʌooga? ―tʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Aapimʌ maimaatʌ iñsioorʌ aanʌ, tomali maimaatʌ giñooga. Ismaatʌmudai aapimʌ iñsioorʌ aanʌ aidʌ gia maatʌmudai ʌʌpʌ giñooga ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ɅSuusi gaaagidi vʌʌsi gomaasi gamamaatʌtulditai daacatai ʌgʌʌ quiuupiʌrʌ anaasi siaaco daraaja ʌcajoñi siaaco gʌdaraasai ʌtumiñsi Diuusi aa duiñdadʌ vʌʌtarʌ. Dʌmos tomali ʌmaadutai maibʌi ʌSuusi. Maiquiaa aayi istuigaco cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Daidʌ ʌSuusi ʌpamu ñiooqui ʌoodami daidʌ itʌtʌdai: ―Aanʌ anʌimia iñagai dai aapimʌ giñgaagamu dʌmos aapimʌ iimia agai ʌDiaavorʌ ʌʌmadu aapimʌ ʌrsoimaasi ivuaadami cascʌdʌ. Dai maitistutuidi isimiagi aapimʌ mʌʌca iñsiaaco imia iñagai aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Amaasi ʌjudidíu pocaiti: ―¿Ʌʌgi gʌmuaa agai lienʌ goovai dai cascʌdʌ povʌrtʌtʌdai tʌsai maitistutuidi isiimiagi mʌʌca siaaco imia agai goovai? ―caiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Amaasi ʌSuusi itʌtʌdai: ―Aapimʌ ʌroidigi daama oidacami dʌmos aanʌ gia chu. Aanʌ tʌvai tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cascʌdʌ povʌntʌtʌdai aanʌ mʌsai aapimʌ imia agai ʌDiaavora ʌʌmadu quiaa soimaasi ivuaadamicatai. Ismaitiñvaavoitudai aapimʌ gʌnaagiditai iñsioorʌ aanʌ aidʌ gia aapimʌ iimia agai ʌDiaavora ʌʌmadu quiaa soimaasi ivuaadamicatai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Amaasi ʌjudidíu itʌtʌdai: ―¿Poorʌ aapio? ―tʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Casi gʌnaagidi aanʌ tucamidʌrʌ abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dai aanʌ quiaa gaaagidamu naana maasi istumaasi gʌnaagaitai aapimʌ dai aanʌ gʌpiʌrʌ gʌnvuaajamu ʌʌmo istumaasicʌdʌ. Dʌmos aanʌ gaaagidi mosʌcaasi istumaasi giñaagidi ʌgai ismaacʌdʌ giñootoi dai ʌgai gia sʌʌlicʌdʌ aagai mosʌcaasi istumaasi ʌrvaavoi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dʌmos ʌjudidíu maimaatʌ caʌ isʌSuusi aagai Diuusi gʌrooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Cascʌdʌ ʌSuusi potʌtʌdai: ―Siʌʌscadʌ aapimʌ giñmuaagi aidʌ gia maatʌmu aapimʌ iñsaanʌ ʌrʌCristo ʌgai vaa ismaacʌdʌ viaa ʌmo sʌʌlicami. Dai aanʌ gʌñaagidi mosʌcaasi istumaasi giñmamaatʌtuli giñooga maisiu istumaasi ʌʌgi aanʌ ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dai giñooga ʌgai daidʌ giñootoi dai vʌʌscʌrʌ giñʌʌmadu daja. Ʌgai maiʌʌgi giñdadagitu. Aanʌ vʌʌscʌrʌ ivueeyi istumaasi ʌgai ipʌlidi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aidʌsi ʌSuusi aagidi gomaasi muidutai vaavoitu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Amaasi ʌSuusi itʌtʌdai ʌjudidíu ismaacʌdʌ vaavoitu: ―Isaapimʌ apiavaavoitudadagi istumaasi gʌnaagidi aanʌ, sʌʌlicʌdʌ aapimʌ ʌrgiñmamaatʌrdamicamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dai maatʌmu istumaasi ʌrvaavoi. Dai siʌʌscadʌ camaatia aapimʌ istumaasi ʌrvaavoi aidʌ gia camaitʌrpipiooñicamu aapimʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tai ʌgai itʌtʌdai: ―Aatʌmʌ ʌrAvraañicaru cajiudadʌ. Dai tomali ʌmo imidagai maitʌrpipiooñigadʌcatadai tomali ʌmaadutai. ¿Ducatʌ caiti aapi iscamaitʌrpipiooñicamu aatʌmʌ? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Taidʌ ʌSuusi itʌtʌdai: ―Sʌʌlicʌdʌ ʌrvaavoi sai sioorʌ soimaasi ivuaadagi ʌgai gia ʌrpiooñigadʌ ʌDiaavora. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ʌmo cʌʌli maiʌmadugan duucai nʌidi gʌpipiooñiga dai gʌmaamara. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dai siʌʌscadʌ aanʌ Diuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ cʌʌgacʌrʌ vusaidiagi ʌmo cʌʌli ʌgai camaitʌrpiooñigadʌcamu ʌDiaavorʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Camaatʌ aanʌ isaapimʌ ʌrcajiudadʌ Avraañicaru dʌmos aapimʌ maitiñvaavoitudai cascʌdʌ giñmuaa ʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aanʌ anʌgʌnaagidi istumaasi giñooga giñmaatʌtuli dai aapimʌ ivueeyi istumaasi gʌnaagidi gʌnooga ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Taidʌ ʌgai aa noragi daidʌ itʌtʌdai: ―Avraañicaru ʌrgʌraduñicaru ―tʌtʌdai ʌgai. Dʌmos ʌSuusi itʌtʌdai: ―Issʌʌlicʌdʌ ʌrvaavoi isaapimʌ ʌrAvraañicaru cajiudadʌcamudai aidʌ gia giñvaavoitudamudai aapimʌ ʌpan duucai Avraañicaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dʌmos aapimʌ giñmuaa ʌlidi tomasi aanʌ gʌnaagidi mosʌcaasi itumaasi ʌrvaavoi istumaasi Diuusi giñmaatʌtuli. Avraañicaru maipoduucai iduuñimudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Aapimʌ ivueeyi poduucai isduucai ivueeyi gʌnooga ―tʌtʌdai ʌSuusi. Amaasi ʌgai itʌtʌdai: ―Aatʌmʌ maitʌrmaamaradʌ ooqui taatacaligami. Mosʌmaduga gʌrooga ʌgai vaa ʌrDiuusi ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Amaasi ʌSuusi itʌtʌdai: ―Issʌʌlicʌdʌ ʌrvaavoicamudai isDiuusi ʌrgʌnoogacamudai aidʌ gia aapimʌ giñoigʌadamudai. Diuusi giñootoi maisiu mosʌʌgi divia aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aapimʌ maitipʌlidi isʌʌgiadagi istumaasi gʌnaagidi aanʌ cascʌdʌ maimaatʌ caʌ giñmamaatʌtuldiaraga. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aapimʌ gʌnooga ʌrʌDiaavora cascʌdʌ aapimʌ ʌrmaamaradʌ ʌDiaavora daidʌ ivuaada ʌlidi istumaasi ʌgai ipʌlidi. Tucamidʌrʌ abiaadʌrʌ ʌDiaavora ʌrgamuaacami daidʌ ʌryaatavogami. Ʌgai tomali ʌmo imidagai maiaagai istumaasi ʌrvaavoi baiyoma vʌʌscʌrʌ mosyaatagʌi ʌgai. Vʌʌsi istumaasi tʌtʌgitoi ʌgai maitʌrvaavoi potuiga ʌgai cascʌdʌ. Ʌgai ʌroogadʌ ducami vʌʌsi ʌyaatavogami. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Cascʌdʌ siʌʌscadʌ aanʌ gʌnaagidi istumaasi ʌrvaavoi aapimʌ maitiñvaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tomali ʌmaadutai aapimʌ gʌnsaagida maitistutuidi isaagagi iñsaanʌ idui ʌmo istumaasi soimaasicami. Siʌʌscadʌ gʌnaagiada aanʌ istumaasi ʌrvaavoi, ¿tuimʌsi maitiñvaavoitudai aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diuusi maamaradʌ sʌʌlicʌdʌ oojoidi iscaʌcagi Diuusi ñiooquidʌ dʌmos aapimʌ maicaʌca ʌlidi Diuusi ñiooquidʌ, aapimʌ maitʌrDiuusi maamaradʌ cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Amaasi ʌjudidíu itʌtʌdai: ―Sʌʌlicʌdʌ ʌrvaavoi istumaasi aagai aatʌmʌ sai aapi ʌrsamaritano dai isviaa aapi ʌmo Diaavora tʌaañicarudʌ ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Daidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aanʌ gia maiviaa Diaavora tʌaañicarudʌ. Aanʌ mossiaa duutudai giñooga dai aapimʌ maisiaa giñduutudai mossoiduucai giñnʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aanʌ maigagaagai sioorʌ siaa giñduutuadagi dʌmos vʌʌscʌrʌ oidaga ʌmoco ismaacʌdʌ gagaagai sioorʌ siaa giñduutuadagi, dai ʌgai soimaasi taatatuldiami sioorʌ maisiaa giñduutuadagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Vaavuava sai sioorʌ ʌʌgiditai caʌ istumaasi gaaagidi aanʌ ʌgai gia tomastuigaco oidaca agai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Amaasi ʌjudidíu aa noragi daidʌ itʌtʌdai: ―Sivi gia cʌʌ maatʌ aatʌmʌ issʌʌlicʌdʌ viaa aapi ʌmo Diaavora tʌaañicarudʌ. Avraañicaru dai vʌʌsi Diuusi ñiñiooquituldiadamigadʌ coi dai vʌʌscʌrʌ aapi gʌraagidi sai sioorʌ ʌʌgiditai caʌ istumaasi gaaagidi aapi ʌgai gia tomastuigaco oidaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Povaipʌsi ʌlidi aapi pʌsai vaamioma viaa guvucadagai isʌAvraañicaru gʌrʌʌqui aduñicaru ismaacʌdʌ camuu? ¿Dai povaipʌsi ʌlidi aapi pʌsai vaamioma viaa guvucadagai siʌDiuusi ñiñiooquituldiadamigadʌcaru ismaacʌdʌ cacoi? ¿Aapia poorʌ gʌʌlidi? ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Amaasi ʌSuusi itʌtʌdai: ―Iñsaanʌ ʌʌgi cʌʌga ñioocadagi ʌʌgi gimvʌʌtarʌ aidʌ gia maiñamʌga giññiooqui. Dʌmos Diuusi giñooga ʌgai vaa ismaacʌdʌ aagai aapimʌ saidʌ ʌrgʌnDiuusiga ʌgai gia cʌʌga ñioocai aanʌ gimvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Dʌmos aapimʌ maimaatʌ ʌgai. Aanʌ gia maatʌ ʌgai. Daidʌ isgʌnaagiadagi aanʌ ansai maimaatʌ aanʌ ʌgai aidʌ gia aanʌ ʌryaatavogamicagi gʌnʌpan duucai. Dʌmos sʌʌlicʌdʌ ʌrvaavoi iñsaanʌ maatʌ ʌgai dai ʌʌgiditai caʌ aanʌ vʌʌsi istumaasi giñaagidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gʌnʌʌqui aduñicaru Avraañi aliʌsi baigʌʌli maatʌcai iñsaanʌ divia iñagaitadai oidigi daama dai vaamioma baigʌʌli ʌgai aidʌsi divia aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Amaasi ʌjudidíu potʌtʌdai ʌSuusi: ―Maiquiaa viaa aapi goo coobai dan baivʌstaama uumigi, ¿ducatai caiti aapi isnʌidi Avraañicaru? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Vaavuava ismaiquiaa vuusaicai Avraañicaru abiaadʌrʌ catʌvaagiʌrʌ daacatadai aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Amaasi vui ʌjudidíu ojoodai dai maicarsa ʌliatugai ʌgai ʌSuusi. Dʌmos ʌSuusi gʌʌʌsto ii dai vuusai ʌgʌʌ quiuupiaiñdʌrʌ. Dai ʌoodami saagida daivusai dai ii. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Vaidʌ ʌSuusi daivusquimi ʌmapʌcʌrʌ dai tʌʌ ʌmo maiñʌaadami. Podu vuusai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tʌtai aatʌmʌ mamaatʌrdamigadʌ ʌSuusi tʌcacai daidʌ itʌtʌdai: ―Gʌrmamaatʌtuldiadamiga, ¿tuisi podu vuusai idi cʌʌli? ¿Voorʌ soimaasi idui gocʌʌli isʌdʌʌdʌdʌ? ―povʌrtʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Taidʌ ʌSuusi itʌtʌdai: ―Idi cʌʌli maisoimaasi idui tomali ʌdʌʌdʌdʌ. Baiyoma goovai maiñʌai sai poduucai aa oodami maatʌna issʌʌlicʌdʌ viaa guvucadagai Diuusi isduaaidagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iñsiʌʌsi uucami oidacagi tami oidigi daama aliʌsi gʌaagai iñsivuaadagi aa duiñdadʌ ʌgai ismaacʌdʌ giñootoi. Aimu istuigaco iscamaitistutuidi isaata vuaadagi tomali ʌmaadutai tomali aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quiaa oidacatai aanʌ tami oidigi daama aanʌ soicʌi oodami iscʌʌga maatʌ caʌcagi istumaasi Diuusi ipʌlidi isivuaadagi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Caaagacai gomaasi ʌSuusi dʌvʌʌrapi sisiva dai vadʌitu laachi dʌvʌʌrai dai ʌmaiñʌaadami vuupuidʌ daama daí ʌdʌvʌʌrai vaagiadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Amaasi itʌtʌdai: ―Imʌdañi dai vacuana gʌvuupuji ʌpiilʌrʌ ismaacʌdʌ Siloé tʌʌgidu ―tʌtʌdai ʌSuusi. Siloé tʌiya ʌlidi ootosicami oodamicʌdʌ. Taidʌ ʌmaiñʌaadami ii dai vacoi gʌvuupuji dai ʌpamu divia dai canʌeeyi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amaasi ʌaaduñdʌ ʌʌmadu aa ismaacʌdʌ ʌʌquioma nʌiditadai ʌmaiñʌaadami icaiti: ―¿Maitasi ʌridi cʌʌli ʌgai vaa ismaacʌdʌ daacatai gataanʌiña tumiñsi? ―ascaiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vai aa icaiti: ―Ʌjʌ ʌgai vaa goovai ―ascaiti. Vai aa icaiti: ―Chu, maitʌrʌgai dʌmos ʌpʌa maasi goovai ―ascaiti. Dʌmos ʌcʌʌli ʌʌgi pocaiti: ");
INSERT INTO ntpNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","―Aanʌava ―ascaiti. Amaasi ʌgaa tʌcacai daidʌ itʌtʌdai: ―¿Ducatai nʌeeyi aapi sivi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Ʌcʌʌli ismaacʌdʌ Suusi tʌʌgidu vadʌitu dʌvʌʌrai dai giñvuupujiana dagivi daidʌ povaiñtʌtʌdai ansai imʌna dai vacuanana giñvuupuji ʌpiilʌrʌ ismaacʌdʌ Siloé tʌʌgidu. Antai aanʌ ii dai vacuanacai casistui aanʌ isnʌnʌavagi ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Amaasi tʌcacai ʌgaa daidi itʌtʌdai: ―¿Vaa daja ʌcʌʌli? ―astʌtʌdai. Tai ʌgai itʌtʌdai: ―Maimaatʌ aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Amaasi ʌoodami vaidacai ʌgai ismaacʌdʌ mainʌaadatadai ʌfariseo vuitapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aidʌsi ʌSuusi vadʌitu ʌdʌvʌʌrai gʌsisivaragacʌdʌ dai dagivi vuupuidʌrʌ ʌgai ismaacʌdʌ maiñʌaadatadai aidʌ ʌribʌstaragai tasʌrʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Cascʌdʌ ʌfariseo ʌʌpʌ tʌcacai ʌcʌʌli dai potʌtʌdai: ―¿Ducatai nʌnʌaava aapi? ―astʌtʌdai ʌfariseo. Tai ʌgai itʌtʌdai: ―Giñdagiviamʌta dʌvʌʌrai vagiadʌ giñvuupuji daama antai vacoi aanʌ dai sivi canʌeeyi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amaasi ʌʌmoco ʌfariseo icaiti: ―Ʌcʌʌli ismaacʌdʌ idui goomasi maitʌrootosadʌ Diuusi, ʌgai maisiaa duutudai ibʌstaragai tasai cascʌdʌ ―ascaiti ʌgai. Dʌmos aa icaiti: ―¿Ducatʌ ivueeyi ʌgai naana maasi gʌgʌrducami isiʌrsoimaasi ivuaadami? ―ascaiti ʌgai. Poduucai ʌʌmoco aagai ʌmo istumaasi dai aa aagai ʌmai istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dai ʌpamu tʌcacai ʌgai ismaacʌdʌ maiñʌaadatadai daidʌ itʌtʌdai: ―¿Dai aapi pʌtʌiya agai aagaitai ʌcʌʌli ismaacʌdʌ gʌduaadi? ―astʌtʌdai. Tai ʌgai itʌtʌdai: ―Aanʌ gʌnaagidi saidʌ ʌrʌmo Diuusi ñiooquituldiadamigadʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Dʌmos ʌjudidíu maitipʌliditadai isvaavoitudagi isʌʌquioma maiñʌaadatadai ʌgai dai sivi canʌeeyi cascʌdʌ vaí ʌgai dʌʌdʌdʌ ʌcʌʌli ismaacʌdʌ maiñʌaadatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Dai tʌcacai daidʌ itʌtʌdai: ―¿Idisi ʌrgʌnmara aapimʌ ismaacʌdʌ pocaiti aapimʌ sai maiñʌaadami vuusai? ¿Ducatai canʌeeyi goovai sivi? ―astʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Taidʌ ʌcʌʌli dʌʌdʌdʌ itʌtʌdai: ―Maatʌ aatʌmʌ isidi ʌrgʌrmara dai ismaiñʌaadami vuusai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Dʌmos maimaatʌ aatʌmʌ isducatai sivi canʌeeyi goovai tomali maimaatʌ aatʌmʌ sioorʌ nʌnʌaavatu. Ʌʌgiavʌr tʌcaca aapimʌ. Goovai casi ʌrgʌducami. Ʌʌgi goovai gʌnaagidiamu ―astʌtʌdai ʌdʌʌdʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Potʌtʌdai ʌgai ʌbʌiditai ʌjudidíu. Ʌjudidíu casi gʌnaagi aipacoga sai isʌmoco vaavoitudagi saidʌ ʌSuusi ʌrʌCristo ʌgai ismaacʌdʌ vaavoitudagi camaiviaaca agai oigaragai isvapaacʌdagi ʌjudidíu quiuupaigadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Cascʌdʌ ʌcʌʌli dʌʌdʌdʌ itʌtʌdai sai tʌcacana maradʌ dai sai ʌgai casi ʌrgʌducami. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Amaasi ʌjudidíu ʌpamu vaí ʌcʌʌli ismaacʌdʌ maiñʌaadatadai daidʌ itʌtʌdai: ―Ʌʌgi Diuusi vʌʌtarʌ icʌʌga ñioocada aapi dai maisiu ʌSuusi. Cʌʌga maatʌ aatʌmʌ saidʌ ʌSuusi ʌrsoimaasi ivuaadami ―astʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Amaasi ʌgai aa noragi daidʌ itʌtʌdai: ―Aanʌ maimaatʌ isiʌrsoimaasi ivuaadami ischo ʌʌpʌ. Mosʌcaasi maatʌ aanʌ iñsaanʌ ʌrmaiñʌaadamicatadai dai sivi gia canʌnʌaava aanʌ ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tai ʌpamu tʌcaca ʌgai daidʌ itʌtʌdai: ―¿Tumaasi idui ʌgai? ¿Ducatai idui pʌsicanʌnʌaava? ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tai aa noragi ʌcʌʌli daidʌ itʌtʌdai: ―Casian gʌnaagidi, ¿maitamʌscaʌ aapimʌ? ¿Tuimʌsi ipʌlidi isʌpamu gʌnaagida aanʌ? ¿Aapimʌ mʌsiʌʌpʌ vaavoituda ʌlidi? ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Amaasi ʌjudidíu vui ñiooquimi ʌcʌʌli daidʌ itʌtʌdai: ―Aapiapa vaavoitudai ʌgai dʌmos aatʌmʌ ʌʌgidi Moseesacaru sʌʌlicamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aatʌmʌ maatʌ isDiuusi ñiooqui Moseesacaru dʌmos maimaatʌ aatʌmʌ tomali siaadʌrʌ divia ʌSuusi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Amaasi ʌcʌʌli aa noragi daidʌ itʌtʌdai: ―Calio maimaatʌ aanʌ istumaasi tʌtʌgitoi pocaititai aapimʌ. ɅSuusi giñʌnʌaavatu dai vʌʌscʌrʌ aapimʌ maimaatʌ siaadʌrʌ divia. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cʌʌga gʌmaatʌ isDiuusi maicaʌ ʌsoimaasi ivuaadami baiyoma Diuusi caʌ mosʌcaasi ʌgai ismaacʌdʌ siaa duutudai Diuusi daidʌ ivuaadagi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tomali ʌmo imidagai maicajiomacatadai aatʌmʌ isʌmaadutai duaadi ʌmoco ismaacʌdʌ maiñʌaadami vuusai dai nʌnʌaavatu. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Isʌgai maitʌrDiuusi ootosadʌcamudai maitistutiadamudai ispoduucai ivuaadagi ―astʌtʌdai ʌgai ismaacʌdʌ maiñʌaadatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amaasi ʌgaa itʌtʌdai: ―Gʌdʌʌdʌ ʌʌmadu aapi ʌrsoimaasi ivuaadami dai vʌʌscʌrʌ aapi gʌrmaatʌtulda ʌlidi ―astʌtʌdai ʌjudidíu. Daidʌ quiidamacoga vuusaitu. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Amaasi maí ʌSuusi mʌsiʌgʌʌ quiuupai quiidigamu vuusaitu ʌcʌʌli ismaacʌdʌ maiñʌaadatadai. Dai aidʌsi ʌSuusi tʌʌ ʌgai potʌtʌdai: ―¿Vaavoitudaipʌsi aapi ʌCristo Diuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Taidʌ ʌcʌʌli itʌtʌdai: ―Iñaagidañi aapi sioor ʌgai nai vaavoitudagi aanʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Nʌidapa. Aatagidapa. Aanʌana ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Amaasi ʌcʌʌli gʌtootonacʌdʌ cʌquiva ʌSuusi vuidʌrʌ daidʌ itʌtʌdai: ―Giñtʌaanʌdamiga aanʌ gia gʌvaavoitudai ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Amaasi ʌSuusi itʌtʌdai: ―Aanʌ divia tami oidigi daama dai nʌnʌaavatuda iñagai ʌgai ismaacʌdʌ maiñʌnʌai, dai ʌgai ismaacʌdʌ pocaiti sai cʌʌga maatʌ caʌ Diuusi ñiooquidʌ maatʌna ismaitʌrvaavoi baiyoma ʌrʌpan ducami maiñʌaadami maimaatʌcatai ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amaasi ʌʌmoco ʌfariseo ismaacʌdʌ ami daraajatadai itʌtʌdai: ―¿Povaipʌs caiti aapi tʌsai aatʌmʌ maiñʌnʌai ʌʌpʌ? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Issʌʌlicʌdʌ maiñʌnʌaadamudai aapimʌ dai maimaatʌ caʌcamudai Diuusi ñiooquidʌ aidʌ gia maitʌrgʌnduñicamudai aapimʌ dʌmos aapimʌ pocaiti mʌsai cʌʌga maatʌ caʌ Diuusi ñiooquidʌ cascʌdʌ ʌrsoimaasi ivuaadami aapimʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Vaavuava sai sioorʌ vapacʌdagi ʌmo curarʌrʌ daama sʌʌli maisiu quitaagiña sʌʌli ʌgai gia ʌrʌʌsivogami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ʌpastuuru ʌgai dai nuucada ʌcañiiru dai ʌgai gia quitaagiña sʌʌli vapacʌi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ʌcʌʌli ismaacʌdʌ quitaagiña cʌaacana dai nuucadacana ʌcañiiru tucarʌ siuu duucu ami diviagi ʌpastuuru ʌgai otoma cupioscʌiña. Ʌcañiiru cʌʌ maatʌ caʌcana ʌpastuuru ñiooquidʌ. Ʌpastuuru vapaidiña ʌcañiiru poduucai istʌʌtʌgida ʌgai dai vuvaidi ʌgai curaraiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dai cavuvaidacai vʌʌsi ʌcañiiru ʌpastuuru baitʌqui imʌiña vaidʌ ʌcañiiru oidíña. Ʌcañiiru cʌʌ maatʌ ñiooquidʌ ʌpastuuru cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dʌmos ʌcañiiru maioidátucui ʌmoco ismaacʌdʌ maimaatʌ ʌgai baiyoma vopooyiña ʌgai maimaatʌcatai ñiooquidʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ɅSuusi aagidi gomaasi ipʌliditai ismamaatʌtuldagi ʌoodami naana maasi istumaasi dʌmos ʌgai maimaatʌ caʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Amaasi ʌSuusi ʌpaamu aagidi ʌoodami daidʌ itʌtʌdai: ―Vaavuava iñsaanʌ ʌrʌpan ducami ʌcurarai quitaagiñagadʌ siaa sʌʌli vapacʌi ʌcañiiru. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vʌʌsi ʌmamaatʌtuldiadami yaatavogami ismaacʌdʌ dada maiquiaa diviacai aanʌ ʌgai ʌrʌʌsivogami ducami dʌmos Diuusi maamaradʌ maioidátucui ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Vaavuava iñsaanʌ ʌrʌpan ducami ʌmo quitaagiña. Sioorʌ ipʌliadagi isivuaadagi istumaasi Diuusi ipʌlidi giñvaavoitudaitai ʌgai gia poduucai cʌʌgacʌrʌ vuvacʌi. Daidʌ ʌvaavoitudadami ʌrʌpan ducami cañiiru ismaacʌdʌ ʌpastuuru vʌʌs tucagi vaapasai ʌcurarʌrʌ dai vʌʌs tasai nunucadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ʌʌʌsivogami dada dai mosʌcaasi mosgaʌʌsidiña dai coodaiña dai siaa vuaadana naana maasi istumaasi dʌmos aanʌ divia vaidʌ ʌoodami tomastuigaco oidaca agai cʌʌgacʌrʌ vuvaacʌitai dai vai sʌʌlicʌdʌ baigʌnʌliaracʌdʌ oidacana. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ʌmo pastuuru cʌʌ tuigacami cʌʌga nunucada gʌsosoiga cañiiru tomasi gʌmuaatu sai maicuucuna ʌsʌʌyi. Dai aanʌ ʌrʌpan ducami ʌmo pastuuru cʌʌ tuigacami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dʌmos ʌmo pastuuru ismaacʌdʌ maitʌrsosiacami ʌgai gia mosmʌmʌraiña siuu duucu tʌʌgiagi ʌmo sʌʌyi dai dadagitoi ʌcañiiru. Vaidʌ ʌsʌʌyi bʌbʌʌyiña ʌmo ʌcañiiru vaidʌ ʌgaa aipaco vopooyiña. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ʌpastuuru maitʌrsosiacamicana cascʌdʌ mʌmʌraiña dai maivuaamʌ ʌlidiña ʌcañiirucʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Aanʌ anʌrʌpan ducami ʌmo pastuuru cʌʌ tuigacami ismaacʌdʌ cʌʌ maatʌ gʌsosoiga cañiiru dai ʌcañiiru cʌʌ maatʌ gʌpastuuruga. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Poduucai isduucai Diuusi giñooga cʌʌga giñmaatʌ dai aanʌ cʌʌga maatʌ giñooca. Dai aanʌ sʌʌlicʌdʌ soiñamu sioorʌ giñvaavoitudagi dai aanʌ muuquimu vai ʌgai cʌʌgacʌrʌ vuvaquiagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dai oidaga aa oodami ismaacʌdʌ maitʌrjudidíu ismaacʌdʌ giñvaavoituda agai ʌʌpʌ. Dai aanʌ cʌʌgacʌrʌ vuvaidamu. Quiaa ʌrsibʌa oidacami ʌgai dʌmos aimu istuigaco isʌgai ʌʌmadu aa giñvaavoitudadami ʌrʌmo aadunumʌca agai dai viaaca agai ʌmo baitʌcʌaacami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Aanʌ muuquimu dai ʌpamu duaacamu vai poduucai cʌʌgacʌrʌ vuvaquiagi oodami. Cascʌdʌ giñoigʌdai giñooca. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tomali ʌmaadutai maitistutuidi isgiñmuuagi ismaitiñdagitu aanʌ. Vʌʌscʌrʌ iñdagitamu aanʌ mʌsgiñmuaagi mosaanʌ ipʌlidi cascʌdʌ. Aanʌ viaa sʌʌlicami isdagituagi isgiñmuaagi dai aanʌ viaa guvucadagai isʌpamu duaacagi. Diuusi giñooca giñmaa sʌʌlicami dai guvucadagai cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aidʌsi ʌjudidíu tʌtʌaañʌdamigadʌ caʌ gomaasi ʌʌmoco aagai ʌmo istumaasi dai aa aagai ʌmai istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dai muidutai pocaiti: ―¡Goovai viaa ʌmo Diaavora tʌaañicarudʌ di! Sʌʌlicʌdʌ ʌrvuiirugami goovai. Maitʌaagai tʌscaʌcagi istumaasi aagai goovai ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dʌmos aa icaiti: ―Isviaacamudai goovai ʌmo Diaavora tʌaañicarudʌ maitistutiadamudai iscʌʌga ñiooquiagi poduucai isduucai ñioocai goovai. Tomali maitistutiadamudai isduaaidagi ʌmo maiñʌaadami ―caiti ʌʌmoco. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aidʌsi ʌSuusi Jerusaleenʌrʌ daacatadai, aidʌ ʌrtoomococatadai. Dai aidʌ casi ʌrʌvagimicatadai ismaacʌdʌ ivuaadana ʌjudidíu tʌʌtʌgitoitai istuigaco idui ʌgʌʌ quiuupai. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Daidʌ ʌSuusi moimʌitadai ʌgʌʌ quiuupiʌrʌ siaaco Solomoñi portaaligadʌ tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Daidʌ ʌtʌtʌaanʌdamigadʌ ʌjudidíu sicoli guuquiva ʌSuusi abaana daidi itʌtʌdai: ―¿Pʌʌscadʌ gʌraagida agai isbai aapi sʌʌlicʌdʌ ʌrʌCristo ischo ʌʌpʌ? ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Casiant gʌnaagidi aanʌ dʌmos aapimʌ maitiñvaavoitu. Diuusi giñooga giñmaa sʌʌlicami ansaidʌ ivuaadana aanʌ naana maasi istumaasi gʌgʌrducami ismaacʌdʌcʌdʌ cʌʌga gʌmaatʌ iñsioorʌ aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dʌmos aapimʌ maitiñvaavoitudai. Aapimʌ maitʌrgiñaaduñi vaavoitudadami cascʌdʌ, poduucai isduucai casigʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Giñaaduñi vaavoitudadami cʌʌ maatʌ giñmamaatʌtuldaraga daidʌ giñʌʌmadu ajioopai. Dai aanʌ cʌʌga maatʌ giñaaduñi vaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aanʌ cʌʌgacʌrʌ vuvaidi ʌgai vai tomastuigaco oidacana tʌvaagiʌrʌ. Maitiipu sioorʌ istutuidi isgiñvoopoidagi giñaaduñi vaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Diuusi giñooga ʌgai daidʌ ʌʌcovai vuvaitu ʌgai saidʌ giñvaavoitudana. Diuusi giñooga sʌʌlicamigadʌ vaamioma namʌga istomasioorai dai cascʌdʌ maitiipu sioorʌ istutuidi isvoopoidagi giñooga giñaaduñi vaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aanʌ ʌʌmadu giñooga viaa ʌgai vaa sʌʌlicami daidʌ ʌgai vaa tʌgitoidagai dai ʌgai vaa guvucadagai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Amaasi ʌjudidíu ʌpamu vui ojoodai dai maicarsa agaitadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Taidʌ ʌSuusi itʌtʌdai: ―Casivuaadana aanʌ mui naana maasi gʌgʌrducami guvucadadʌcʌdʌ giñooga aapimʌ gʌnsaagida. ¿Maascʌdʌ ʌgaicʌdʌ giñmaicarsa agai aapimʌ? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Taidʌ ʌjudidíu aa noragi daidʌ itʌtʌdai: ―Maisiu ivuaadatai aapi ʌmo istumaasi gʌducami aatʌmʌ gʌmaicarsa agai vui ñioocaitai aapi Diuusi aagaitai sai aapi ʌrDiuusi dʌmos aapi ʌrcʌʌli ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Amaasi ʌSuusi itʌtʌdai: ―Diuusi ñiooquidʌrʌ pocaiti saidʌ ʌdudunucami ʌjudidíu ʌrdidiuusi ducami. Diuusi maacai sʌʌlicami cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cʌʌ maatʌ aatʌmʌ sai istumaasi oojisi Diuusi ñiooquidʌrʌ sʌʌlicʌdʌ ʌrvaavoi. Dai Diuusi pocaiti sai ʌgai ismaacʌdʌ Diuusi maa ʌmo sʌʌlicami ʌrdiuusi ducami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dai Diuusi ʌcovai giñvusaitu daidʌ giñootoi tami oidagi daama. ¿Ducatai povaiñtʌtʌdai aapimʌ sai aanʌ vui ñioocai Diuusi aagaitai ansaidʌ ʌraanʌ Diuusi maradʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aanʌ ivueeyi naana maasi gʌgʌrducami. Diuusi giñooga giñmaa ʌmo sʌʌlicami cascʌdʌ. Dai cascʌdʌ aliʌsi gʌaagai isaapimʌ giñvaavoitudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tomasi maivaavoitudai aapimʌ istumaasi gʌnaagidi aanʌ vʌʌscʌrʌ cʌʌga maatʌ aapimʌ isivuaadana aanʌ naana maasi istumaasi gʌgʌrducami dai gomaasicʌdʌ aliʌsi gʌaagai isvaavoitudagi iñsaanʌ ʌrDiuusi maradʌ dai istʌvai aanʌ tʌvaagiaiñdʌrʌ dai poduucai vaavoitudagi sai Diuusi giñooga aanʌ giñʌʌmadu daja dai sai aanʌ Diuusi giñooga ʌʌmadu daja ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Taidʌ ʌpamu ʌjudidíu ipʌlitadai isbʌiyagi ʌSuusi dai maisagi dʌmos ʌSuusi mosdaivunu ii. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Amaasi ʌSuusi ʌpamu ii ʌgʌʌ aqui Jordán mʌʌmojoradʌrʌ siaaco ʌʌquioma gavapaconaitadai ʌVuaana dai ami daaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Taidʌ mui oodami iji dai mʌʌ nʌidamu ʌSuusi daidʌ icaiti: ―Tomasi ʌVuaana maitidui tomali ʌmo istumaasi gʌducami vʌʌscʌrʌ vʌʌsi istumaasi aagai ʌgai aagaitai idi cʌʌli sʌʌlicʌdʌ ʌrvaavoi ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tai ami mui oodami vaavoitu ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ʌmo cʌʌli Betaaniʌrʌ oidacami aliʌ coococatadai. Lázaru tʌʌgidu ʌgai. Daidʌ ʌLázaru susuculidʌ ʌrMaría dai Maaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María ʌgai dai ʌʌquioma tʌi asaiti sigian uuvaicʌdʌ ʌSuusi ʌʌcasodʌ daama dai gʌcuupacʌdʌ gaqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Daidʌ María ʌʌmadu Maaruta ootoi ʌmo piooñi sai aagidana ʌSuusi sai aliʌ cooco ʌLázaru dai potʌtʌdai ʌpiooñi ʌSuusi: ―Gʌrbaitʌcʌaacamiga, aliʌ cooco gʌaamiiguga Lázaru ―tʌtʌdai ʌpiooñi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tai mosmaí ʌSuusi daidʌ icaiti: ―Ʌgai oí coocodagai dai tomasi muuquiagi vʌʌscʌrʌ maisiu cascʌdʌ oí coocodagai. Ʌgai oí coocodagai sai poduucai gooquiʌrʌ mui oodami maatʌna issʌʌlicʌdʌ viaa guvucadagai Diuusi, dai sai ʌoodami maatʌna ʌʌpʌ isaliʌ cʌʌ tuiga aanʌ Diuusi maradʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tomasi ʌSuusi sʌʌlicʌdʌ oigʌdai Maaruta ʌʌmadʌ suculidʌ ʌʌmadu Lázaru ");
INSERT INTO ntpNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","vʌʌscʌrʌ anaasi vii ʌʌpʌ goo tasai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dai gooquiʌrʌ povʌrtʌtʌdai ʌgai aatʌmʌ: ―Timʌda ʌpamu Judeeamu ―gʌrtʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tʌtai aatʌmʌ itʌtʌdai: ―Mamaatʌtuldiadami, maiquiaa daivusai mui tasai daidʌ ʌjudidíu mʌʌca Judeeʌrʌ ipʌliditadai isgʌmaicarsagi. ¿Ducatai ʌpamu mʌʌca imia ʌlidi aapi? ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Tomali ʌmaadutai maitistutuidi isgiñmuaagi maiquiaa naatocai aanʌ giñaa duiñdaga. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gʌramiiguga Lázaru cooso dai aanʌ imia iñagai dai nʌñiituda iñagai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Amaasi aatʌmʌ itʌtʌdai: ―Gʌrtʌaanʌdamiga, iscooso ʌgai aidʌ gia casi gʌtaumadaimi ʌgai ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Povʌrtʌtʌdai ʌSuusi potʌiya ʌliditai saidʌ Lázaru camuu. Dʌmos aatʌmʌ poʌliditadai isʌrvaavoi iscooso ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Amaasi ʌSuusi sʌʌli gʌraagidi dai povʌrtʌtʌdai: ―Camuu Lázaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dai cʌʌgadu ismaiʌʌmadu daacatadai aanʌ. Poduucai vaamioma cʌʌgaduca agai aapimʌ gʌnvʌʌtarʌ, vaamioma giñvaavoituda agai cascʌdʌ. Tiñda ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Amaasi ʌTomás mʌsmaacʌdʌ cuate aagaiña povʌrtʌtʌdai: ―Tʌoidá cascʌdʌ ʌmapai cooyi aatʌmʌ ―gʌrtʌtʌdai ʌTomás. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tai mosaayi ʌSuusi Betaaniʌrʌ dai maí iscasi ʌpʌduitadai maaco tasai isyaasapi ʌLázaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaaniaiñdʌrʌ miaaga Jerusaleenamu parʌ goo mil dan taan siento metro ʌʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Dai mui judidíu caaayi dai daadiji Maaruta ʌʌmadu María camuucucai Lázaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aidʌsi ʌMaaruta maí isʌSuusi camiaadimi, ii ʌgai dai mʌʌ vuidʌrʌ ajia agai. Dʌmos ʌMaría anaasi quiiyʌrʌ vii. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Daidʌ ʌMaaruta itʌtʌdai ʌSuusi: ―Giñtʌaanʌdamiga, istami daacamudai aapi maimuuquimudai giñsiʌʌgi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dʌmos cʌʌ maatʌ aanʌ sai Diuusi iduñia agai tomastumaasi istumaasi aagida aapi ―tʌtʌdai ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Taidʌ ʌSuusi itʌtʌdai: ―Gʌsiʌʌgi ʌpamu duaacamu ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Taidʌ ʌMaaruta itʌtʌdai: ―Ʌjʌ, cʌʌga maatʌ aanʌ sai ʌpamu duaaca agai ʌgai siʌʌscadʌ aiyagi istuigaco duduaacagi vʌʌsi coidadʌ ―tʌtʌdai ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Amaasi ʌSuusi itʌtʌdai: ―Aanʌanʌ ʌgai dai ʌpamu duduaacalda iñagai coidadʌ sitomastuigaco oidacamu ʌgai. Sioorʌ giñvaavoitudai tomasi muuquiagi vʌʌscʌrʌ tomastuigaco oidaca agai tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dai sioorʌ oidaga giñvaavoitudaitai ʌgai gia maiimia agai ʌDiaavora ʌʌmadu. ¿Vaavoitudaipʌsi aapi imaasi? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Taidʌ ʌMaaruta itʌtʌdai: ―Ʌjʌ, vaavoitudiana isaapi ʌrʌCristo, Diuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ. Ʌgai vaa ismaacʌdʌ tʌvʌpi nʌnʌracatadai aatʌmʌ ―tʌtʌdai ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Caaagidi ʌMaaruta gomaasi dai ii dai duudusali aagidi gʌsuculi María dai potʌtʌdai: ―Gʌrmamaatʌtuldiadami cadivia dai gʌvaidi ―astʌtʌdai ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Amaasi mosmaí ʌgai gomaasi dai cʌquiva dai ii dai mʌʌ viaatuli ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Maiquiaa vaatadai ʌSuusi caayʌrʌ. Quiaa momʌʌca cʌaacatadai ʌgai siaaco aayi ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aidʌsi ʌjudidíu ismaacʌdʌ quiiyʌrʌ daraacatadai ʌʌmadu ʌMaría tʌʌ isʌgai todian duucai cʌquiva dai otoma vuusai oidi ʌgai ʌMaría. Ʌgai povʌnʌliditadai isimia agai ʌgai mʌʌca siaaco yaasapi ʌsiʌʌgidʌ dai ami suaacada agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Amaasi aʌcai ʌMaría mʌʌca siaaco cʌaacatadai ʌSuusi gʌtootonacʌdʌ cʌquiva ʌgai ʌSuusi vuidʌrʌ daidʌ itʌtʌdai: ―Giñbaitʌcʌaacamiga istami daacamudai aapi maimuuquimudai giñsiisi ―tʌtʌdai ʌMaría. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mostʌʌgacai ʌSuusi issuanʌi ʌjudidíu ʌʌmadu ʌMaría sʌʌlicʌdʌ soigʌʌli ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Daidʌ itʌtʌdai: ―¿Vaaco yaasa aapimʌ ʌgai? ―tʌtʌdai ʌSuusi. Tai ʌgai itʌtʌdai: ―Gʌrtʌaanʌdamiga tiñda pai nʌida ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Taidʌ ʌSuusi sosoa. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Amaasi ʌjudidíu icaiti: ―Dañi sʌʌlicʌdʌ oigʌdaitadai goovai ―caiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dʌmos ʌʌmoco icaiti: ―Idi cʌʌli nʌnʌaavatu ʌmaiñʌaadami. Cʌʌga istuidimudai goovai issoiñagi ʌLázaru simaimuuquimudai ʌgai ―caiti ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Taidʌ ʌSuusi ʌpamu soigʌʌli aidʌsi caaijimi ʌtʌjovai siaaco yaasapi ʌLázaru. Dai ʌtʌjovai vaacʌaacʌrʌ daja ʌmo odai gʌducami. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Taidʌ ʌSuusi itʌtʌdai: ―Maigovaiavʌr daasa goodai ―tʌtʌdai ʌSuusi. Taidʌ ʌMaaruta suculidʌ ʌmuuquiadʌ itʌtʌdai: ―Giñtʌaanʌdamiga, casi ʌpʌdui maaco tasai ismuu goovai dai galiuvai goovai nai iñʌlidi aanʌ ―tʌtʌdai ʌMaaruta. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dʌmos ʌSuusi itʌtʌdai: ―¿Maitasi ʌrvaavoi saidʌ gʌaagidi aanʌ isvaavoitudagi aapi nʌidagi isDiuusi sʌʌlicʌdʌ viaa guvucadagai? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Amaasi maigovai daí ʌgai ʌoodai. Taidʌ ʌSuusi taí nʌnʌaava daidʌ itʌtʌdai Diuusi gʌooga: ―Giñooga, baigiñʌlidi aanʌ aapicʌdʌ isgiñcaʌcana aapi siuu duucu gʌñiooquiada aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Cʌʌga maatʌ aanʌ isvʌʌscʌrʌ giñcaʌcana aapi dʌmos sivi poduucai gʌaagidi aanʌ sai vʌʌsi idi oodami ismaacʌdʌ tanasi guuca vaavoitudagi isaapi giñootoi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Dai capotʌʌcai ʌSuusi cavami iña daidʌ itʌi: ―¡Lázaru vuusaiñi! ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tai vuusai ʌmuuquiadʌ dai quiaa biisapicatadai noonovidʌ dai ʌʌcasodʌ ʌmo icusi tʌvʌʌducamicʌdʌ. Daidʌ vuivasadʌ ʌʌpʌ quiaa biisapi ʌmo icusicʌdʌ. Taidʌ ʌSuusi itʌtʌdai: ―Uupanavurai vaidʌ istuidʌ aimʌraiña ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Dai muidutai ʌjudidíu ismaacʌdʌ oidatucuitadai ʌMaría vaavoitu ʌSuusi nʌiditai isʌpan duaacali ʌSuusi Lázaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dʌmos ʌʌmoco ʌjudidíu ismaacʌ vuidʌrʌ vʌʌtʌ ʌSuusi iji dai nʌida agai ʌfariseo dai aagidi istumaasi idui ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Amaasi ʌfariseo ʌʌmadu ʌtʌtʌaanʌdamigadʌ ʌpapaali gʌnʌmapagi ʌjudidíu dudunucami daidʌ itʌtʌdai: ―¿Tuma duuna aatʌmʌ? Idi cʌʌli ivueeyi mui naana maasi gʌgʌrducami. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ismosdagitu aatʌmʌ dai maitiduñiagi tomali ʌmo istumaasi muidutai vaavoituda agai ʌgai daidʌ ʌtʌtʌaanʌdamigadʌ ʌromamanu dadimu dai daitudamu gʌrquiuupaiga gʌducʌdʌ dai gʌrcoodamu ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dʌmos ʌmoco ʌvaamioma tʌtʌaanʌdamigadʌ ʌjudidíu saagida ismaacʌdʌ Caifási tʌʌgidu dai aidʌ uumiʌrʌ ʌgai ʌrbaitʌcʌaacamigadʌ ʌpapaali aa noragi daidʌ itʌtʌdai: ―Vupuiirugami aapimʌ, maimaatʌ tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Maimaatʌ aapimʌ isvaamioma ʌrcʌʌgai aatʌmʌ gʌrvʌʌtarʌ ismuuquiagi ʌmo cʌʌli vʌʌsi oodami vʌʌtarʌ dai poduucai maiugitimu vʌʌsi ʌoodami ―astʌtʌdai Caifási. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dʌmos Caifási pocaiti maisiu poduucai tʌgitoitai ʌʌgi ʌgai baiyoma ʌgai ʌrʌbaitʌcʌaacamigadʌ ʌpapaali cascʌdʌ Diuusi poduucai tʌgitoli ʌgai ismuuquiagi ʌSuusi ʌjudidíu vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dai maisiu mosʌcaasi ʌjudidíu vʌʌtarʌ muuquia agaitadai ʌSuusi baiyoma vʌʌsi oodami ismaacʌdʌ aipa oidaga vʌʌsi oidigʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aidʌ tasʌrʌ abiaadʌrʌ tʌtʌaanʌdamigadʌ ʌjudidíu gagaagaimi isducatai muaagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Cascʌdʌ ʌSuusi camaiaimʌrai caayana ʌjudidíu saagida. Baiyoma ii ʌgai Judeeaiñdʌrʌ mʌʌ Efraiinamu ʌmo ali quiiyʌrʌ oidigana ugidana. Dai movaasi daraaja aatʌmʌ ʌʌmadu ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aidʌ camiaadimitadai ʌsiaa duudagai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu cajiudadʌ Ejiipituaiñdʌrʌ. Ʌsiaa duudagai pascua tʌʌgidu. Dai mui oodami ʌaali quiiquiaiñdʌrʌ iji Jerusaleenamu dai ami iduñi agai istumaasi gʌaagaitadai siduñiagi maiquiaa aʌcai ʌgʌʌ siaa duudagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gagaagaimi ʌoodami ʌSuusi dai ʌgʌʌ quiuupiʌrʌ guucacatadai dai aipaco gʌntʌcacai daidʌ icaiti: ―¿Tumaasi tʌtʌgitoi aapimʌ? ¿Bais divimu ʌSuusi sivi siaa duudagʌrʌ? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ʌfariseo ʌʌmadu ʌtʌtʌaanʌdamigadʌ ʌpapaali gaaagidi sai sioorʌ matiagi siaaco daja ʌSuusi sai aagidaña vaidʌ ʌjudidíu bʌʌjiagi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Quiaa viʌʌgacatadai naadami tasai isaayagi ʌsiaa duudagai taidʌ ʌSuusi ii Betaaniamu. Ami oidacatadai ʌLázaru ʌgai vaa ismaacʌdʌ ʌSuusi ʌpamu duaacali ʌcoidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tai ami ʌoodami vaí ʌSuusi sai gauugana. Taidʌ ʌMaaruta gabibi dai ʌLázaru meesa vuidʌrʌ daiva ʌSuusi ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Amaasi ʌMaría vuaa parʌ taucami litro asaiti sigian uvadami sʌʌlicʌdʌ namʌacami. Dai tʌi ʌgai ʌasaiti ʌSuusi ʌʌcasodʌ dai gʌcuupacʌdʌ gaqui. Tai sʌʌlicʌdʌ sigian uvaitu vʌʌsi ʌquiiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amaasi ʌUudasi Iscaliote ʌmo maatʌrdamigadʌ ʌSuusi ñiooqui ʌSuusi. Ʌgai vaa Uudasi ʌrSimuñi maradʌ daidʌ gatʌʌgida agaitadai ʌSuusi daidʌ potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tuisi maitʌgagaara idi asaiti sigian uvadami? Cʌʌga gʌvuiimudai parʌ vaic siento piisu dai ʌgaicʌdʌ soiñamudai aatʌmʌ ʌsoitutuigami ―tʌtʌdai ʌUudasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dʌmos ʌUudasi potʌtʌdai maisiu soigʌʌliditai ʌgai ʌsoitutuigamicʌdʌ baiyoma ʌrʌʌsivogami ʌgai cascʌdʌ pocaiti. Ʌgai ʌrgʌrtumiñsiga nuucadacamicatadai dai gʌrʌʌsidiña. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Amaasi ʌSuusi itʌtʌdai: ―Daigitoñi goooqui. Dagitoñi vai bai daasana goovai gogaa asaiti ismaacʌdʌ vii asta mʌsiʌʌscadʌ giñyaasagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vʌʌscʌrʌ oidaca agai soitutuigami gʌnsaagida vʌrai soicʌda dʌmos aanʌ maivʌʌscʌrʌ oidacamu aapimʌ gʌnsaagida ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Muidutai ʌjudidíu maí isʌSuusi Betaaniʌrʌ daacatadai. Dai mʌʌca iji maisiu mosʌcaasi nʌidi ʌliditai ʌSuusi dʌmos nʌidi ʌliditadai ʌLázaru ʌʌpʌ. Ʌgai vaa Lázaru ismaacʌdʌ ʌSuusi duaacali coidʌ saagidiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Dai muidutai judidíu maí isʌSuusi duaacali ʌLázaru dai cascʌdʌ gajiaadʌrʌ viaa ʌjudidíu vaavoidaragadʌ dai vaavoitudaimi ʌSuusi. Cascʌdʌ ʌtʌtʌaanʌdamigadʌ ʌpapaali bai idui ismuaagi ʌLázaru ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mui oodami Jerusaleenʌrʌ dada gosiaa duudagʌrʌ. Dai cajioma ʌoodami sai siaadico divia agaitadai ʌSuusi Jerusaleenʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Amaasi ʌoodami guicuma souvali maamaradʌ dai iji dai mʌʌ vuidʌrʌ aayi ʌSuusi dai iiñaquimi daidʌ icaiti: ―Aliʌ siaa duutudai aatʌmʌ Diuusi. Aatʌmʌ ipʌlidi sai Diuusi aliʌ cʌʌgacʌrʌ nʌijadagi ʌraígadʌ ʌjudidíu ismaacʌdʌ divia Diuusi guvucadadʌcʌdʌ ―caiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Taidʌ ʌSuusi tʌʌ ʌmo asñiitu dai dan daiva poduucai isduucai gaaagidi Diuusi ñiooquituldiadamigadʌ Diuusi ñiooquidʌrʌ dai podu ooja: ");
INSERT INTO ntpNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Maitavʌr duduaadicuda aapimʌ Jerusaleenʌrʌ oidacami. Dañi bʌrimʌi gʌraíga ʌmo asñiitu dan daitugai. Asduu ooja Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Aidʌ ʌpʌdui gomaasi maimaí aatʌmʌ mamaatʌrdamigadʌ ʌSuusi istuisi podui. Dʌmos gooquiʌrʌ aidʌsi ʌSuusi ʌpamu nora tʌvaagiamu aidʌ gia tʌgitu aatʌmʌ isDiuusi ñiñiooquituldiadamigadʌ ooja Diuusi ñiooquidʌrʌ aagaitai ʌCristo dai sai poduucai ʌpʌduñia agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ʌoodami ismaacʌdʌ moguucacatadai ʌSuusi ʌʌmadu aidʌsi ʌgai vaí ʌLázaru quiaa yaasapicatai ʌgai dai nʌidi ʌgai isʌSuusi duaacali ʌLázaru coidadʌ saagidiaiñdʌrʌ aagidi aa oodami istumaasi nʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Cascʌdʌ iji ʌoodami dai mʌʌ vuidʌrʌ aayi ʌSuusi. Cʌʌ maatʌ ʌoodami isʌSuusi idui ʌmo istumaasi gʌducami. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amaasi ʌfariseo aipaco gʌnaagidi daidʌ icaiti: ―Dañi. Maitistutuidi aatʌmʌ isbʌiyagi ʌSuusi sivi. Vʌʌscatai oidátucui ʌgai cascʌdʌ ―ascaiti ʌfariseo. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ʌoodami saagida ajioopaitadai ʌʌmo giliego. Ʌgai dada Jerusaleenʌrʌ sai siaa duutuda agai Diuusi ʌsiaa duudagʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dai ʌgai miaadʌrʌ guuquiva ʌPiili ismaacʌdʌ ʌrBetasaidʌrʌ oidacami. Betasaida ʌrʌmo ali quii Galilea dʌvʌʌriʌrʌ. Daidʌ ʌoodami giliego itʌtʌdai ʌPiili: ―Aapi cʌʌli, aatʌmʌ nʌida ʌrʌlidi ʌSuusi ―astʌtʌdai ʌgiliego. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Taidʌ ʌPiili ii dai aagidi ʌAandʌrʌsi. Taidʌ vʌgoocatai iji dai aagidi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Amaasi ʌSuusi itʌtʌdai: ―Aanʌ ʌrʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami dai caaayi istuigaco matiagi oodami isvaamioma namʌga giñsʌʌlicamiga sitomasmaascʌdʌ sʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Vaavuava isʌmo caidʌ tʌligi vʌʌscʌrʌ mosaliʌmaduacana asta mʌsiʌʌscadʌ ʌsiagi vai vusacʌi vupusiadʌ dai gʌʌrai vai uugiatʌi ʌʌstucai dai muuratai vai muidarʌi tʌligi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sioorʌ ivuaadagi ʌʌgi istumaasi ipʌlidi, ʌgai gia iimimu ʌDiaavora ʌʌmadu, dʌmos sioorʌ maiivuaadagi ʌʌgi istumaasi ipʌlidi tami oidigi daama ʌgai gia cʌʌgacʌrʌ vuusaimu dai tomastuigaco oidacamu tʌvaagiʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Isʌmaadutai giñsoicʌda ʌliadagi gʌaagai isgiñoidátucudagi dai tomasiaaco aimʌrda aanʌ movaasi aimʌradagi ʌgai ʌʌpʌ. Dai sioorʌ giñsoicʌi, giñooga cʌʌgacʌrʌ nʌijada agai, ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Camuquiadan tada aanʌ soigiñʌliditai. Dʌmos vʌʌscʌrʌ maiaagidamu aanʌ giñooga sai giñsoiñana ismaisii soimaasi taatagi aanʌ. Aanʌ divia tami oidi daama dai soimaasi taata iñagai dai muuquia iñagai oodami vʌʌtarʌ, cascʌdʌ maiaagidamu aanʌ giñooga sai giñsoiñana nai maisoimaasi taata aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baiyoma aagidamu aanʌ giñooga sai vʌʌsi oodami maatʌna sai Diuusi ʌrbaitʌcʌaacamigadʌ vʌʌsi oidigi dama oidacami dai sai vʌʌscatai siaa duutuadagi Diuusi ―tʌtʌdai ʌSuusi. Amaasi ñioo Diuusi tʌvaagiaiñdʌrʌ daidʌ itʌtʌdai ʌgai ʌSuusi: ―Ʌoodami gia maatʌ isaapi siaa giñduutudai soimaasi taatamai aapi cascʌdʌ ―tʌtʌdai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Taidʌ ʌoodami ismaacʌdʌ novaasi guucacatadai daidʌ cai isDiuusi ñioo icaiti sai covoi oidigi dai aa oodami icaiti: ―Ʌmo tʌaañicarudʌ Diuusi ñiooqui ―caiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Amaasi ʌSuusi potʌtʌdai ʌoodami: ―Pocaiti giñooga sai aapimʌ maatʌna isʌgai cʌʌgacʌrʌ giñnʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Camiaadimi istuigaco camainamʌaca agai ʌDiaavora sʌʌlicamigadʌ tami oidigi daama baiyoma aanʌ iñsʌʌlicamiga namʌaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dai mʌsiʌʌscadʌ giñsiisagi curusiaba Diuusi soiña agai muidutai vʌʌsi oidigi daama sai giñvaavoitudana ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Potʌtʌdai ʌSuusi sai maatʌna ʌoodami isducatai muuquia agai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Taidʌ ʌoodami aa noragi daidʌ itʌtʌdai: ―Diuusi ñiooquidʌrʌ pocaiti saidʌ ʌCristo tomastuigaco oidaca agai. ¿Ducatʌ caiti aapi saidʌ ʌoodami siisapa agai ʌmo curusiaba ʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami? ¿Sioorʌ ʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami? ―tʌtʌdai ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Amaasi ʌSuusi itʌtʌdai: ―Aanʌ quiaa daacamu aapimʌ ʌʌmadu ʌʌpʌ chiʌʌqui tasai dai gʌnmamaatulda iñagai aanʌ. Cʌʌgavʌr giñcaʌca aapimʌ istumaasi gʌnaagidi aanʌ vai poduucai cʌʌgacʌrʌ oidacagi dai cʌʌgacʌrʌ vuvaquiagi. Sioorʌ maicʌʌgacʌrʌ oidaga maimaata siaaco iimia agai coocai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aliʌsi gʌaagai isvaavoitudadagi aapimʌ istumaasi gʌnmamaatʌtuldi aanʌ quiaa daacatai aanʌ aapimʌ gʌnʌʌmadu vai poduucai cʌʌgacʌrʌ oidaca aapimʌ ―tʌtʌdai ʌSuusi. Caaagidacai ʌSuusi imaasi ii abiaadʌrʌ dai gʌʌʌsto taidʌ ʌoodami camaitʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ɅSuusi idui mui naana maasi istumaasi gʌrgʌrducami ʌoodami vuitapi dʌmos vʌʌscʌrʌ maivaavoitu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Poduucai ʌpʌdui istumaasi gaaagidiña Diuusi ñiooquituldiadamigadʌ Isaíacaru potʌtʌdai ʌgai Diuusi: GiñDiuusiga baitoma tomali ʌmaadutai maivaavoitu aidʌsi aagidi aatʌmʌ gʌñiñiooquituldiadamiga gʌñiooqui ʌoodami. Tomasi ʌoodami nʌidi issʌʌlicʌdʌ viaa aapi giñDiuusi guvucadagai vʌʌscʌrʌ maimaatʌ nʌidi istumaasi ʌpʌdui. Astʌtʌdai Isaíacaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Dai Isaíacaru ooja ʌʌpʌ istuisi maitistutuidi ʌoodami isvaavoitudagi dai podu ooja: ");
INSERT INTO ntpNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nʌijadamu ʌgai istumaasi ivueeyi Diuusi dʌmos Diuusi maidagito ismaatʌ nʌijadagi. Ducami iscuupicagi vuupuidʌ. Caʌ ʌgai Diuusi ñiooquidʌ dʌmos Diuusi maidagito ismaatʌ caʌcagi. Dai Diuusi pocaiti: “Ʌgai maiʌma duucai gʌntʌtʌgito ʌlidi dai maitʌnvaavoitu vai poduucai cʌʌgacʌrʌ gʌnvuvaidan aanʌ”, ascaiti Diuusi. Asduucai ooja Isaíacaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Pocaiti Isaíacaru aagaitai ʌCristo. Isaía nʌidi ʌCristo gʌcoosigʌrʌ dai poduucai maí issʌʌlicʌdʌ vaamioma viaa guvucadagai ʌCristo sitomasioorʌ dai isvaamioma tʌaanʌi sitomasioorʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dʌmos vʌʌscʌrʌ muidutai ʌjudidíu tʌaanʌdamigadʌ vaavoitu ʌSuusi dʌmos maiaagidi vʌʌsi oodami. Ʌgai ʌʌbʌidi ismaatʌmudai ʌfariseo. Ʌgai camaidagitu isvaapaquiagi ʌquiuupaigadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vaamioma oojoidi ʌgai isʌoodami cʌʌgacʌrʌ nʌijadagi siʌDiuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ʌsuusi cavami iiña daidʌ icaiti: ―Tomasioorʌ sioorʌ iñvaavoitudagi ʌgai vaavoitudai ʌʌpʌ Diuusi giñooga. Ʌgai ʌgai daidʌ giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Dai tomasioorʌ sioorʌ maatʌ istuiga aanʌ cʌʌga maatʌ istuiga ʌgai ismaacʌdʌ giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aanʌ andivia tami oidigi daama vai ʌoodami maatʌna istumaasi Diuusi ipʌlidi isivuaadagi dai divia aanʌ sai sioorʌ giñvaavoitudagi camaisoimaasi ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tomasioorʌ sioorʌ caʌcagi istumaasi gaaagiada aanʌ dai maitiñʌʌgiadagi aanʌ maitʌrʌgai ismaacʌdʌ gaaagida iñagai isducatai soimaasi taata agai ʌgai. Aanʌ divia tami oidigi daama sai cʌʌgacʌrʌ vuuvacʌna oodami, dai maisiu aagida iñagai oodami isducatai soimaasi taata agai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tomasioorʌ sioorʌ gajiaadʌrʌ giñviaa aanʌ dai maivaavoitudai giññiooqui ʌgai gia sʌʌlicʌdʌ soimaasi taata agai siʌʌscadʌ caugitiʌgi oidigi. Giñmamaatʌtuldiaragacʌdʌ cʌʌga gʌmaatʌmu isʌgai ʌrsoimaasi ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Istumaasi aagai aanʌ maitʌraan ʌʌgi giññiooqui baiyoma aanʌ aagai mosʌcaasi istumaasi ipʌlidi giñooga. Ʌgai giñootoi daidʌ giñaagidi istumaasi gʌnaagida aanʌ dai istumaasi gʌnmaatʌtuldiagi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Dai cʌʌ maatʌ aanʌ sai istumaasi giñaagidi giñooga ansai gaaagidana gomaasicʌdʌ cʌʌgacʌrʌ vuvacʌi oodami. Cascʌdʌ aanʌ angaaagidi mosʌcaasi istumaasi giñtʌjai giñooga ansai gaaagidana ―caiti ʌSuusi ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dai cayoga aayitadai ʌsiaa duudagai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ, mosʌmo tasai viʌʌga. Camaatʌcatadai ʌSuusi iscaaayi istuigaco daivunu imia agai ʌgai idi oidigiaiñdʌrʌ dai ʌpamu noragia agai mʌʌca siaaco daja oogadʌ. ɅSuusi sʌʌlicʌdʌ oigʌdai vʌʌsi ismaacʌdʌ vaavoitudai ʌgai tami oidi daama, vʌʌsi gʌibʌdagacʌdʌ oigʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Dai ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ gacueeyitadai tucara. Taidʌ ʌʌquioma abiaadʌrʌ ʌDiaavora divia Simuñi maradʌ ʌUudasi Iscaliote ʌʌmadu dai ipʌlitu isgatʌʌgida ʌgai ʌSuusi sai bʌʌna ʌgai ismaacʌdʌ vuidʌrʌ vʌʌtʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ɅSuusi maatʌcatadai isDiuusi oogadʌ ʌgai ootoi tami oidi daama tʌvaagiaiñdʌrʌ dai isʌpamu gaamu aa gʌsiagi Diuusi ʌʌmadu. Dai ʌgai maatʌcatadai ʌʌpʌ isʌoogadʌ camaa guvucadagai sai tʌaanʌiña vʌʌsiaʌcatai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Daidʌ quiaa acueeyitadai ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ dai cʌquiva ʌgai dai maigo daí gʌdaamanaga yuucusi dai bʌi ʌmo gaquidacarui dai gʌpuraan vuu. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Amaasi toa suudagi ʌmo vaateejʌrʌ dai gʌaagacai gʌrvacuañimi gʌrʌʌcaso aatʌmʌ mamaatʌrdamigadʌ. Dai gaquigi gaquidacarucʌdʌ ismaacʌdʌ gʌpuraana vuutadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dai aidʌsi vacuaañda agaitadai ʌgai ʌSimuñi Piiduru ʌʌcasodʌ ʌgai potʌtʌdai: ―¿Aanʌ iñʌʌcaso pʌsvacuaana agai ʌʌpʌ? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Sivi maimaatʌ nʌidi aapi istuma vueeyi aanʌ dʌmos gooquiʌrʌ gia maatʌ nʌidamu aapi ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dʌmos ʌPiiduru itʌtʌdai: ―Aanʌ giñʌʌcaso gia tomali ʌmo imidagai maitiñvacuaañdamu aapi ―tʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Ismaivacuaana aanʌ gʌʌʌcaso aidʌ gia aapia maitʌrgiñaduñi ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Taidʌ ʌSimuñi Piiduru itʌtʌdai: ―Giñbaitʌcʌaacamiga aidʌ gia maisiu mosʌcaasi giñʌʌcaso vacuaanamu aapi, gʌaagai pʌsvacuaanagi aapi giñnoonovi daidʌ giñmoo ʌʌpʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dʌmos ʌSuusi itʌtʌdai: ―Sioorʌ utudami gʌnvapaʌtʌviagi maitʌaagai isvʌʌsi tuucugadʌ vacuaanagi mosʌcaasi ʌʌcasodʌ gʌaagai isvacuaanagi. Dai aapimʌ cavuaañicam vii dʌmos maisiu vʌʌscatai ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Cʌʌ maí ʌSuusi sioorʌ tʌʌgida agaitadai, cascʌdʌ pocaiti sai maivʌʌscatai vuaañicam vii, poduucai tʌiya ʌlidi ʌSuusi isʌrsoimaasi ivuaadami ʌgai ismaacʌdʌ tʌʌgida agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dai canaato vacuaañdacai ʌSuusi aatʌmʌ mamaatʌrdamigadʌ ʌʌcasodʌ ʌpamu gʌai gʌdaamanaga yuucusi dai ʌpamu daiva meesa vuidʌrʌ. Daidʌ itʌtʌdai aatʌmʌ mamaatʌrdamigadʌ: ―¿Maatʌmʌsi nʌidi aapimʌ istumaasi idui aanʌ aapimʌcʌdʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Aapimʌ mamaatʌtuldiadami dai baitʌcʌaacami giñaagai daidʌ ʌrvaavoi iñsaanʌ ʌrmamaatʌtuldiadami daidʌ ʌrbaitʌcʌaacami cascʌdʌ poduucai cʌʌga aagai aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dai aanʌ iñsmaacʌdʌ ʌrgamamaatʌtuldiadamiga daidʌ ʌrgabaitʌcʌaacamiga cavacoi aanʌ aapimʌ gʌnʌʌcaso cascʌdʌ aliʌsi gʌaagai mʌsiaipacoga gʌnvacuaañdiadagi aapimʌ gʌnʌʌcaso. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aapimʌ aliʌsi gʌaagai mʌsivuaadagi ʌʌpʌ isducatai ivueeyi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Vaavuava istumaasi gʌnaagidi aanʌ sai tomali ʌmo piooñi maivaamioma nʌmʌga isgaaamu dai tomali ʌmo ootosicami maivaamioma namʌga siʌ ʌgai ismaacʌ ootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mʌsimaatʌ caʌ aapimʌ vʌʌsi imaasi dai ʌʌgiditai caʌ sʌʌlicʌdʌ baigʌnʌliadamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Dai aanʌ maivʌʌscatai gʌnaagai aagaitai mʌsaidʌ ʌrsoimaasi ivuaadami. Cʌʌ maatʌ ismaacʌdʌ ʌcovai vuvaitu aanʌ. Dai vʌʌscʌrʌ aliʌsi gʌaagai isʌpʌduñiagai istumaasi aagai Diuusi ñiooquidʌrʌ dai poduucai aagai: “Ʌgai vaa ismaacʌdʌ giñʌʌmadu acueeyi casi giñvuidʌrʌ gʌi”, caiti Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gʌnaagidi aanʌ imaasi maiquiaa ʌpʌduucai vai poduucai siʌʌscadʌ ʌpʌduñiagi aapimʌ vaavoitudana iñsaanʌ ʌrʌgai iñsmaacʌdʌ aagai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Vaavuava istumaasi gʌnaagidi aanʌ sai sioorʌ miaadʌgidagi giñootosa ʌgai gia giñmiaadʌgi aanʌ ʌʌpʌ dai sioorʌ giñmiaadʌgidagi aanʌ ʌgai gia miaadʌgi ʌgai ismaacʌdʌ giñootoi ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Caaagidacai ʌSuusi imaasi sʌʌlicʌdʌ soigʌʌʌli ʌgai dai sʌʌli aagidi dai potʌtʌdai: ―Vaavuava isʌmaadutai aapimʌ giñtʌʌgida agai saidʌ giñbʌʌna giñvuidʌrʌ vʌʌtʌcami ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Amaasi aatʌmʌ mamaatʌrdamigadʌ ʌgai aipaco gʌrnʌnʌidimi vʌʌscatai maimaatʌcatai ismaacʌdʌ aagai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aanʌ ʌSuusi abaana daivacai gauu. Aanʌ aliʌsi giñoigʌdaiña ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Vaidʌ ʌSimuñi Piiduru gʌnoovicʌdʌ giñsisigidi ansai tʌcacana sioorʌ aagai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Amaasi aanʌ aabanion daiva ʌSuusi daidʌ itʌtʌdai: ―Giñbaitʌcʌaacamiga. ¿Voorʌ aagai aapi? ―tʌtʌdai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Taidʌ ʌSuusi giñaa noragi daidʌ povaiñtʌtʌdai: ―Vadʌidamu aanʌ laachi paana dai sioor maaquia aanʌ ʌgiava ʌgai ―iñtʌtʌdai. Amaasi vadʌitu laachi paana dai maa ʌUudasi. Ʌgai ʌrmaradʌ Simuñi Iscaliote. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dai mosbʌi ʌUudasi ʌpaana daidʌ ʌDiaavora vaa ibʌdagʌrʌ ʌgai. Amaasi ʌSuusi itʌtʌdai ʌUudasi: ―Istumaasi iduñia agai aapi, otoma iduuñi tuduidi ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dʌmos tomali ʌmaadutai ismaacʌdʌ mees vuidʌrʌ daraaja maimaatʌ caʌ istuisi potʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ɅUudasi ʌgai dai bai darasacana vʌʌscatai tumiñsigadʌ cascʌdʌ ʌʌmadutai poduucai gʌntʌtʌgito sai Suusi tʌaanʌi issavʌda ʌgai ʌmo istumaasi ʌtumiñsicʌdʌ ʌsiaa duudagʌrʌ vʌʌtarʌ siʌpʌ maaquiagi ʌmo istumaasi ʌsoituutuigami. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Dai mosgau ʌpaana ʌUudasi dai vuusai quiidigamu. Dai casi ʌrtucarʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Dai mosvuusai ʌUudasi taidʌ ʌSuusi potʌi: ―Sivi gia maatʌmu oodami issʌʌlicʌdʌ viaa aanʌ guvucadagai aanʌ iñsmaacʌdʌ viaa ʌmo sʌʌlicami. Dai maatʌmu ʌʌpʌ issʌʌlicʌdʌ siaa duutudai aanʌ Diuusi giñooga muucucai aanʌ curusiaba sai cʌʌgacʌrʌ vuvacʌna oodami poduucai isduucai ʌgai ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Siʌʌscadʌ aanʌ iñsmaacʌdʌ viaa ʌmo sʌʌlicami tʌʌgidagi ʌoodami isDiuusi giñooga sʌʌlicʌdʌ viaa guvucadagai aidʌ gia Diuusi giñooga tʌʌgidamu oodami issʌʌlicʌdʌ viaa aanʌ guvucadagai ʌʌpʌ. Dai otoma iduñimu ʌgai gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Giñaaduñi camaitʌvʌpi daacamu aanʌ aapimʌ gʌnʌʌmadu. Aapimʌ giñgaagamu dai maitiñtʌʌgimu. Dai aanʌ angʌnaagidi aapimʌ ʌpan duucai aagidi aanʌ ʌjudidíu sai mʌʌca siaaco imiagi aanʌ, aapimʌ maitistutuidi isiimiagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Dai aanʌ gʌnaagidi idi ñiooqui utudui sai aapimʌ aipacoga gʌnoigʌadaiña. Poduucai isduucai gʌnoigʌdai aanʌ poduucai ʌʌpʌ aliʌsi gʌaagai mʌsiaapimʌ aipacoga gʌnoigʌadagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Vai poduucai vʌʌsi oodami oidi daama cʌʌga maatʌmu mʌsiaapimʌ ʌrgiñmamaatʌrdamiga ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Taidʌ ʌSimuñi Piiduru itʌtʌdai: ―Giñbaitʌcʌaacamiga, ¿pa imia agai aapi? ―tʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Mʌʌca siaaco imia iñagai aanʌ aapi maitistutuidi isiñoidági sivi, dʌmos gooquiʌrioma giñoidámu aapi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Amaasi ʌPiiduru itʌtʌdai: ―Giñbaitʌcʌaacamiga, ¿tuisi maitistutuidi aanʌ isʌoidá sivi? Aanʌ baigiñduu iñsmuuquiagi aapi gʌvʌʌtarʌ ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Taidʌ ʌSuusi itʌtʌdai: ―Mospocaiti aapi isbaigʌduu pʌsmuuquiagi aanʌ giñvʌʌtarʌ. Baiyoma sivi tucarʌ maiquiaa cucuicai ʌtacucu potʌimu aapi vaicojo ismaitʌgiñmaatʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Maitavʌrvuaamʌ ʌnʌliada aapimʌ. Cʌʌgavʌr vaavoitudada Diuusi dai cʌʌgavʌr giñvaavoitudada aanʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mʌʌca siaaco daja giñooga muidu baabaqui. Dai mʌʌca imia iñagai aanʌ dai movai duuñimu aanʌ siaaco oidaca aapimʌ. Ismaitʌrvaavoicamudai imaasi aanʌ gia maitʌnaagidamudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dai caimʌcai aanʌ bai duuñimu siaaco oidaca aapimʌ aidʌ gia ʌpan divimu aanʌ daidʌ gʌnvaidacamu aanʌ vai aapimʌ oidacagi aan iñʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aapimʌ gia cʌʌ maatʌ siaaco imia iñagai aanʌ dai maatʌ ʌʌpʌ voi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Taidʌ ʌTomás itʌtʌdai: ―Giñbaitʌcʌaacamiga aatʌmʌ maimaatʌ siaaco imia agai aapi. ¿Duucatʌ maatʌna aatʌmʌ voi? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ voi iñducami aapimʌ gʌnvʌʌtarʌ cascʌdʌ aanʌcʌdʌ aimu aapimʌ mʌʌca siaaco daja Diuusi. Dai aanʌcʌdʌ maatʌmu istumaasi ʌrvaavoi. Dai aanʌ gʌnmaacai ibʌdagai utudui. Mosʌcaasi sioorʌ giñvaavoitudagi aimu mʌʌca siaaco daja giñooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iscʌʌga maatʌmudai aapimʌ iñsioorʌ aanʌ aidʌ gia maatʌmudai aapimʌ giñooga ʌʌpʌ. Dʌmos sivi maatʌ aapimʌ ʌgai canʌidi ʌgai cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Taidʌ ʌPiili itʌtʌdai: ―Giñbaitʌcʌaacamiga, gʌrdagitoñi tʌsnʌida aatʌmʌ Diuusi gʌrooga. Mosʌcaasi gomaasi ipʌlidi aatʌmʌ ―tʌtʌdai ʌPiili. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Taidʌ ʌSuusi itʌtʌdai: ―Piili, mosʌʌ tʌvʌpi daja aanʌ gʌnʌʌmadu. ¿Ducatai maitiñmaatʌ aapimʌ quiaa? Sioorʌ giñnʌidi ʌgai nʌidi giñooga ʌʌpʌ. ¿Tuipʌsi giñaagidi iñsaanʌ gʌndagituagi mʌsnʌidagi aapimʌ Diuusi gʌrooga? ");
INSERT INTO ntpNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Maitapʌsvaavoitudai aapi ismosʌmadugan tuutuiga aanʌ ʌʌmadu gʌrooga? Idi ñiooqui ismaacʌdʌ gʌnaagidi aanʌ maisiu ʌʌgi giñtʌgitoidacʌdʌ aagi aanʌ. Gʌrooga ʌgai daidʌ giñʌʌmadu daja daidʌ giñmaa guvucadagai isiduuna aanʌ aa duiñdagadʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Giñvaavoitudavurai aapimʌ isʌmadugan tuutuiga aanʌ ʌʌmadu gʌrooga. Ismaitiñvaavoitudai mosʌcaasi giññiooquicʌdʌ aidʌ gia giñvaavoitudavurai aapimʌ ʌnaana maasi gʌgʌrducamicʌdʌ iñsmaacʌdʌ ivuaadana aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sʌʌlicʌdʌ ʌrvaavoi isʌgai ismaacʌdʌ giñvaavoitudai iduuñimu ʌʌpʌ naana maasi gʌgʌrducami poduucai isduucai ivueeyi aanʌ dai asta istumaasi gʌgʌrducʌdioma iduñia agai ʌgai. Aanʌ noragimu mʌʌca siaaco daja gʌrooga cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dai siuu duucu daanʌda aapimʌ Diuusi giñvaavoitudacai taanʌdavurai istumaasi ipʌlidi naidʌ gʌnmaaquimu aanʌ vai poduucai gʌmaatiagi isviaa guvucadagai giñooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sʌʌlicʌdʌ iduuñimu aanʌ tomastumaasi istumaasi ismaacʌdʌ taanʌdagi aapimʌ giñvaavoitudacai. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mʌsiaapimʌ iñoigʌdai ʌʌgiditai avʌrcaʌca ismaacʌdʌ gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Siaanʌ daanʌdamu gʌrooga siʌgai gʌnootosdamu gʌibʌdaga vai ʌgai gʌnsoicʌdagi mʌsai vaamioma cʌʌga vaavoitudaiña daidʌ baigʌnʌliatudagi ʌpan duucai aanʌ gʌnsoicʌi daidʌ baigʌnʌliatudai sivi. Ʌgai vaa ʌgai daidʌ gamaatʌtuldiamu mosʌcaasi istumaasi ʌrvaavoi. Dai ʌgai vʌʌscʌrʌ gʌnʌʌmadu daaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ʌoodami maivaavoitudadami maimaatʌ Diuusi Ibʌadʌ tomali maimaatʌ istan daja ʌgai cascʌdʌ maitistutuidi isdagituagi isʌʌmadu daacagi. Dʌmos ʌgai cadaja aapimʌ gʌnʌʌmadu daidʌ gʌnʌʌmadu daaca ʌgai tomastuigaco cascʌdʌ aapimʌ maatʌ Diuusi Ibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aanʌ gia maitʌndagitomu siʌʌgi daraaca aapimʌ. Ʌpan divimu aanʌ daidʌ gʌnʌʌmadu daacamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Otoma ʌoodami tami oidi daama oidacami camaitiñnʌijadamu, dʌmos aapimʌ gia giñtʌʌgimu ʌpamu. Aanʌ gia ʌpamu duaacamu cascʌdʌ aapimʌ oidaca agai tomastuigaco. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aidʌ gia aapimʌ maatʌmu iñsaanʌ vʌʌscʌrʌ daja Diuusi giñooga ʌʌmadu. Dai aanʌ vʌʌscʌrʌ gʌnʌʌmadu daja. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Isʌmaadutai maatʌcagi istumaasi gatʌaanʌi aanʌ dai ʌʌgiditai caʌcagi poduucai cʌʌ maatʌ aanʌ issʌʌlicʌdʌ iñoigʌdai ʌgai. Dai Diuusi giñooga oigʌadamu vʌʌscatai ismaacʌdʌ giñoigʌdai. Dai aanʌ ʌʌpʌ oigʌadamu ʌgai. Dai aanʌ maatʌtuldamu ʌgai iñsaanʌ daja ʌgai ʌʌmadu ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aidʌ gia ñioo ʌUudasi (idi ʌrʌmai Uudasi maisiu Uudasi Iscaliote) dai potʌtʌdai: ―Gʌrbaitʌcʌaacamiga, ¿ducatai aapi gʌrmaatʌtuldamu mosʌcaasi aatʌmʌ pʌsgʌrʌʌmadu daja dai maimaatʌtulda agai ʌoodami maivaavoitudadami? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Taidʌ ʌSuusi itʌtʌdai: ―Sioorʌ giñoigʌdai ʌgai gia ʌʌgiditai caʌcamu giññiooqui. Daidʌ gʌrooga oigʌadamu ʌgai. Dai giñooga ʌʌmadu aanʌ daraajamu ʌgai ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sioorʌ maitiñoigʌdai ʌgai gia maiʌʌgiditai caʌ giññiooqui. Idi ñiooqui ismaacʌdʌ gʌnaagidi aanʌ maisiu mosʌʌgi gʌnaagidi aanʌ baiyoma gomaasi ʌrñiooquidʌ Diuusi giñooga dai ʌgai giñootoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Aanʌ gʌnaagidi vʌʌsi imaasi quiaa aimʌraitai tami oidi daama aapimʌ gʌnʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dai daañidamu aanʌ Diuusi giñooga sai ʌgai ootosana gʌIbʌdaga sai ʌgai gʌnnuucadacana daidʌ baigʌnʌliatudana. Ʌgai ʌgai daidʌ gʌnmaatʌtuldiamu vʌʌsiaʌcatai dai ʌgai gʌntʌgitotulda vʌʌsi istumaasi gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Canoragimu aanʌ dʌmos aapimʌ daraajamu dai gʌniibʌstacan tadacamu gʌniibʌdaga. Vʌʌscʌrʌ aanʌ gʌniibʌstudan tadatudamu gʌniibʌdaga maisiu ʌpan duucai oodami caiti isiibʌstudan tadacana. Maitavʌr vuaamʌ ʌnʌliada aapimʌ tomali maiʌʌbiada tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aapimʌ casi giñcai iscaiti aanʌ isimia iñagai mʌʌca siaaco daja gʌrooga dai iñsʌpamu divimu aanʌ dai ʌmapai daraajamu aatʌmʌ. Issʌʌlicʌdʌ giñoigʌadamudai aapimʌ aidʌ gia baigʌnʌliadamudai caʌcai iñsimia iñagai aanʌ. Giñooga vaamioma viaa guvucadagai iñsaanʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aanʌ gʌnaagidi imaasi sivi maiquiaa ʌpʌdui vai poduucai siʌʌscadʌ ʌpʌduñiagi aapimʌ cʌʌga vaavoitudamu istumaasi gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Camaitʌvʌpi gʌnaatagidamu aanʌ aapimʌ. Casi bʌrimui ʌDiaavora. Ʌgai ʌgai dai tʌaanʌi ʌoodami ismaacʌdʌ maitiñvaavoitudai. Dʌmos ʌgai maitistutuidi aanʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dʌmos vʌʌscʌrʌ gʌaagai ispoduucai ʌpʌduñiagi vai ʌoodami maatiagi iñsaanʌ oigʌdai gʌrooga daidʌ iñsaanʌ ivueeyi vʌʌsi istumaasi giñtʌaanʌi ʌgai. Guuquivavurai aapimʌ. Timʌda tabʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Uuvasi dʌʌdʌ iñducami aanʌ. Dai uuvasi dʌʌdʌ nuucadacami ducami Diuusi gʌrooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ʌmaamaradʌ ismaacʌdʌ maiiibiatai guicumai ʌnuucadacami daidʌ ʌgaquiadʌ maamaradʌ guicumai ʌʌpʌ vai poduucai vaamioma cʌʌga iibiatai ʌuuvasi dʌʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Daidʌ ʌmaamaradʌ ismaacʌdʌ cʌʌga iibiatai gʌnducami aapimʌ cʌʌga giñvaavoitudaitai. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Maitavʌr gajiaadʌrʌ giñviaa aapimʌ dai aanʌ maigajiaadʌrʌ gʌnviaa ʌʌpʌ. Ʌuuvasi maamaradʌ maisiu ʌʌgi iibiatai. Mosʌcaasi ʌmaamaradʌ ismaacʌdʌ quiaa arasaca ʌuuvasi dʌʌdʌ istutuidi isiibiatagi. Dai poduucai aapimʌcʌdʌ ʌʌpʌ. Mosʌcaasi sioorʌ apiavaavoitudada giññiooqui istutuidi iscʌʌgacʌrʌ oidacagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Uuvasi dʌʌdʌ iñducami aanʌ dai aapimʌ maamaradʌ gʌnducami. Sioorʌ maigajiaadʌrʌ giñviaagi ʌgai vaamioma cʌʌga istutuidi iscʌʌgacʌrʌ oidacagi. Aatʌmʌ ʌmapai daraaja cascʌdʌ. Aapimʌ ʌʌgi maitistutuidi isiduñiagi tomali ʌmo istumaasi cʌʌgaducami. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sioorʌ gajiaadʌrʌ viaa giññiooqui gajiaadʌrʌ viaamu aanʌ ʌʌpʌ, poduucai isduucai gʌguicomai ʌuuvasi maamaradʌ ismaacʌdʌ maiiibiatai dai gaquisarʌi. Dai gooquiʌrʌ gʌʌmpaidi ʌmaamaradʌ gaquiadʌ daidʌ mʌmʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Isaapimʌ maitiñdagitu dʌmos baiyoma apiavaavoitudada giñmamaatʌtuldaraga aidʌ gia giñtaañimu istumaasi ipʌliadagi dai aidʌ gia aanʌ gʌnmaaquimu. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Siʌʌscadʌ aapimʌ cʌʌgacʌrʌ oidacagi poduucai siaa duutuda aapimʌ Diuusi, dai poduucai cʌʌga gʌmaatʌ isaapimʌ ʌrgiñmamaatʌrdamiga. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Poduucai isduucai giñoigʌdai giñooga poduucai aanʌ ʌʌpʌ gʌnoigʌdai aapimʌ. Apiavʌr tʌtʌgitoda aapimʌ iñsgʌnoigʌdai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Isʌʌgiadagi aapimʌ giñmamaatʌtuldaraga poduucai tʌtʌgitodamu aapimʌ iñsgʌnoigʌdai aanʌ. Dai aanʌ ʌʌpʌ ʌʌgidi vʌʌsi istumaasi giñaagidi giñooga dai baigiñʌlidi aanʌ giñoigʌdaitai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gʌnaagidi aanʌ idi ñiooqui vai poduucai aapimʌ baigʌnʌliadagi aanʌ iñʌʌmadu dai isvʌʌsi gʌniibʌdacʌdʌ baigʌnʌliada aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dai aanʌ gʌntʌjai mʌsiaipacoga gʌnoigʌada aapimʌ poduucai isduucai gʌnoigʌdai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sioorʌ aliʌsi oigʌadagi ʌmoco gʌaduñi ʌgai gia bai gʌduu ismuuquiagi ʌgai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dai aapimʌ ʌrgiñaaduñicamu mʌsivuaadagi istumaasi gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aanʌ camaigiñpipiooñiga gʌnaagai. Ʌpiooñi maimaatʌ istuma vueeyi aamudʌ cascʌdʌ. Baiyoma aanʌ giñaaduñi gʌnaagai. Aanʌ casi gʌnaagidi vʌʌsi istumaasi giñaagidi giñooga cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aapimʌ maiʌcovai giñvusaitu baiyoma aanʌ ʌcovai gʌnvuvaitu aapimʌ. Dai aanʌ gʌnootoi aapimʌ sai aagidana giññiooqui aa oodami vʌʌscʌrʌ cʌʌgacʌrʌ oidacatai aapimʌ. Daidʌ giñooga gʌnmaaquimu vʌʌsi istumaasi taañʌdagi aapimʌ giñvaavoitudaitai. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dai aanʌ gʌntʌaanʌi siaipacoga gʌnoigʌada aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Isʌoodami gʌncʌʌdadagi aapimʌ gʌntʌgitovurai isaanʌ giñcʌʌdaina ʌgai ʌpʌga. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Isaapimʌ uurapʌcʌdamudai ʌoodami maivaavoitudadami aidʌ gia ʌgai gʌnoigʌadamudai poduucai isduucai gʌnoigʌdai ʌgai aipacoga. Dʌmos aanʌ ʌcovai gʌnvuvaitu ʌoodami maivaavoitudadami saagidiaiñdʌrʌ dai sivi camaiuurapʌcʌi aapimʌ ʌgai. Cascʌdʌ ʌgai gʌncʌʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gʌntʌtʌgitovurai aapimʌ isgʌnaagidi aanʌ sai tomali ʌmo piooñi maivaamioma namʌga siʌaamudʌ. Ʌoodami soimaasi giñtaatatuli aanʌ ismaacʌdʌ gaaamu cascʌdʌ soimaasi gʌntaatatuldamu ismaacʌdʌ giñpipiooñiga gʌnducami. Ʌʌmo oodami ʌʌgiditai caʌ giññiooqui poduucai ʌʌpʌ ʌʌmo oodami ʌʌgiditai caʌcamu gʌnñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vʌʌsi gomaasi iduuñimu ʌgai giñvaavoitudacai aapimʌ. Ʌgai maimaatʌ ʌgai ismaacʌdʌ giñootoi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iñsaanʌ maidivimudai dai maiñiooquidamudai ʌgai aidʌ gia ʌgai maigajiaadʌrʌ giñviaamudai. Dʌmos aliʌsi soimaasi idui ʌgai gajiaadʌrʌ giñviaacai maitiipucatai istui. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sioorʌ giñcʌʌdada ʌgai gia cʌʌdai Diuusi gʌrooga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iñsaanʌ maitiduuñimudai ʌgai saagida naana maasi gʌgʌrducami ismaacʌdʌ maitidui tomali ʌmo ʌmai ʌgai maisoimaasi iduuñimudai gajiaadʌrʌ giñviaacai. Dʌmos tomasi ʌgai nʌidi vʌʌsi gomaasi vʌʌscʌrʌ giñcʌʌdai daidʌ ʌgai cʌʌdai giñooga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aidʌsi ʌpʌdui imaasi aidʌ ʌpʌdui istumaasi caoojisi ʌjudidíu sʌʌlicamigadʌrʌ dai pocaiti: “Giñcʌʌdai ʌgai maitiipucatai istucudʌ”, ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Dʌmos daañimu aanʌ giñooga vai ʌgai ootosana gʌIbʌdaga. Dai siʌʌscadʌ diviagi ʌgai gʌnsoicʌdamu mʌsai cʌʌga vaavoitudaiña daidʌ baigʌnʌliatudamu ʌgai. Dai ʌgai gia gʌnaagidamu mosʌcaasi istumaasi ʌrvaavoi. Dai ʌgai gʌnaagidamu naana maasi istumaasi giñaagaitai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Dai aapimʌ ʌʌpʌ aagidamu aa oodami naana maasi istumaasi cʌcʌʌgaducami giñaagaitai aanʌ. Aapimʌ aanʌ iñʌʌmadu ajioopaitadai tucamidʌrʌ abiaadʌrʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Vʌʌsi imaasi gʌnaagidi aanʌ mʌsai apiacʌʌga vaavoitudaiña. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","3","Daidʌ ʌjudidíu ismaacʌdʌ maisʌʌlicʌdʌ maatʌ Diuusi gʌrooga tomali maisʌʌlicʌdʌ giñmaatʌ maitʌndagitamu isaapimʌ vapaaquiagi quiquiuupaigʌdʌrʌ. Dai aimu istuigaco ʌgai vaa gʌncoodamu poʌliditai ispoduucai ivueeyi istumaasi Diuusi ipʌlidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Poduucai gʌnaagidi aanʌ vai siʌʌscadʌ ʌpʌduuñiagi gomaasi ismaacʌdʌ gʌnaagidi aanʌ aidʌ gia tʌgitomu aapimʌ iscasi gʌnaagidi aanʌ. Aanʌ gʌnʌʌmadu aimʌraitadai cascʌdʌ maitʌnaagidi aanʌ imaasi ʌʌquioma. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dʌmos sivi caʌpamu imimu aanʌ mʌʌca siaaco daja giñooga. Ʌgai ʌgai dai giñootoi tami oidi daama. Dai tomali ʌmaadutai maitiñtʌcacai aapimʌ iñsiaaco imia iñaagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Baiyoma soigʌnʌʌli aapimʌ gʌnaagidacai aanʌ imaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dʌmos sʌʌlicʌdʌ ʌrvaavoi isvaamiomʌ ʌrcʌʌgai aapimʌ gʌnvʌʌtarʌ iñsimi aanʌ. Iñsmaiimia aanʌ aidʌ gia maidivimu ʌgai ismaacʌdʌ gʌnsoicʌda agai mʌsai vaamioma cʌʌga vaavoitudaiña dai baigʌnʌliatudagi. Dʌmos iñsimia aanʌ aidʌ gia baigovai ootosamu aanʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Siʌʌscadʌ divia ʌgai maatʌtuldiadamu oodami isʌrsoimaasi ivuaadami maitiñvaavoitudacai ʌgai. Daidʌ Diuusi Ibʌadʌ maatʌtuldiadamu ʌoodami ʌʌpʌ iñsaanʌ sʌʌlicʌdʌ cʌʌga giñtʌgito dai tomali ʌmo imidagai maisoimaasi idui aanʌ. Vʌʌsi imaasi cʌʌga maatʌmu ʌgai imʌcai aanʌ mʌʌca siaaco daja giñooga dai aapimʌ camaitiñʌijadamu. Daidʌ Diuusi Ibʌadʌ maatʌtuldiadamu ʌoodami isʌmo imidagai Diuusi soimaasi taatamituldiamu ʌoodami maivaavoitudadami. Dai aidʌ gia Diuusi soimaasi taatamituldiamu ʌDiaavora ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Quiaa oidaga naana maasi istumaasi gʌnaagida iñʌlidi aanʌ dʌmos aapimʌ maitistutuidi ismaatʌ caʌcagi sivi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Siʌʌscadʌ diviagi Diuusi Ibʌadʌ ʌgai gʌnmaatʌtuldiamu vʌʌsi istumaasi ʌrvaavoi. Vʌʌsi istumaasi aagai ʌgai ʌrvaavoi. Ʌgai gʌnmaatʌtuldiamu maisiu istumaasi ʌʌgi ʌgai ipʌlidi, baiyoma ʌgai gʌnmaatʌtuldiamu mosʌcaasi istumaasi aagidi aanʌ. Dai ʌgai gʌnaagidamu istumaasi ʌpʌduñia agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dai ʌgai soicʌda agai oodami sai siaa giñduutudaiña mamaatʌtulditai ʌgai istumaasi aanʌ aagidi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vʌʌsi istumaasi aagai giñooga ʌgai vaa ñiooqui aagai aanʌ ʌʌpʌ cascʌdʌ pocaiti aanʌ sai Diuusi Ibʌadʌ gʌnmaatʌtuldiamu istumaasi aagai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Caotoma maitiñnʌijadamu aapimʌ dai gooquiʌrʌ maitʌvʌpicʌdʌ ʌpamu giñtʌʌgimu. Aanʌ imimu tʌvaagiamu siaaco daja giñooga cascʌdʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Amaasi ʌʌmoco aatʌmʌ mamaatʌrdamigadʌ ʌSuusi aipaco gʌrtʌcacaimi dai pocaitimi: ―Istʌiya ʌlidi goovai dai pocaiti tʌsai caotoma mainʌijada ragai aatʌmʌ dai gooquiʌrʌ maitʌvʌpicʌdʌ ʌpamu tʌʌgia ragai. Dai sai imia agai tʌvaagiamu siaaco daja oogadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Istuisi pocaiti goovai tʌsai otoma camaitʌʌgia ragai. Aatʌmʌ maimaatʌ caʌ istʌiya ʌlidi goovai ―caiti aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ɅSuusi maatʌcatadai isaatʌmʌ tʌcaca ipʌliditadai ʌmo istumaasi cascʌdʌ povʌrtʌtʌdai: ―Casi gʌnaagidi aanʌ sai caotoma maitiñnʌijadamu aapimʌ dai gooquiʌrʌ maitʌvʌpicʌdʌ ʌpamu giñtʌʌgimu. ¿Gomaasi mʌsaagai aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sʌʌlicʌdʌ aapimʌ soigʌnʌliadamu dai suaanʌdamu dʌmos ʌoodami maivaavoitudadami baigʌnʌliadamu. Dʌmos gʌnsoiʌliaraga ugitimu sibaigʌnʌliadamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Siʌʌscadʌ ʌmo ooqui cacoocoagi duaaidia agaitai ali oodami aliʌ soimaasi taatacana ʌgai dʌmos siʌʌscadʌ cavuusai ʌali oodami camaitʌgito iscavami cooco baigʌʌliatugaitai iscavuusai ʌmo ali oodami. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Poduucai aapimʌ soigʌnʌlidi sivi dʌmos ʌpan divimu aanʌ dai gʌnnʌidamu dai aidʌ gia sʌʌlicʌdʌ baigʌnʌliadamu aapimʌ dai maitiipucamu sioorʌ soigʌnʌʌliatudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Aidʌ tasʌrʌ camaitiñtʌcacamu aapimʌ tomali ʌmo istumaasi. Sʌʌlicʌdʌ ʌrvaavoi mʌsiaapimʌ tañiagi Diuusi gʌrooga tomastumaasi giñvaavoitudacai ʌgai gia gʌnmaaquimu istumaasi tañiagi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ʌʌquioma daanʌiña aapimʌ Diuusi maisiu giñsʌʌlicamigacʌdʌ. Sivi gia taanʌdavurai aapimʌ Diuusi istumaasi tʌgitocagi giñsʌʌlicamigacʌdʌ dai Diuusi gʌnmaaquimu vai poduucai sʌʌlicʌdʌ baigʌnʌliadamu aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aanʌ gʌnaagidi ʌʌmo istumaasi gʌnmaatʌtulda iñʌliditai ʌma maasi. Dʌmos aimu istuigaco aanʌ camaipoduucai gʌnmamaatʌtuldiadamu baiyoma sʌʌli gʌnaagiadamu aanʌ naana maasi istumaasi aagaitai Diuusi gʌrooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dai aidʌ tasʌrʌ daañidamu aapimʌ Diuusi gʌrooga giñsʌʌlicamigacʌdʌ. Dai camaitʌgitocamu aapimʌ iñsaanʌ daanʌdagi gʌrooga aapimʌ gʌnvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Diuusi gʌrooga sʌʌlicʌdʌ gʌnoigʌdai giñoigʌdaitai aapimʌ dai vaavoitudaitai iñsaanʌ divia mʌʌcadʌrʌ siaaco oidaga Diuusi gʌrooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Vaavuava iñsaanʌ divia mʌʌcadʌrʌ siaaco oidaga Diuusi giñooga dai divia aanʌ tami oidi daama. Dai sivi caimʌdamu aanʌ ʌpamu gaamucu siaaco daja gʌrooga ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Taidʌ aatʌmʌ ʌSuusi mamaatʌrdamigadʌ potʌtʌdai: ―Sivi gia casʌʌli gʌraagidi dai maisiu gʌraagidi ʌmo istumaasi gʌrmaatʌtulda ʌliditai ʌma maasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sivi gia cʌʌ maatʌ aatʌmʌ isaapi maatʌ vʌʌsiaʌcatai. Aapi maitʌgito isʌmo oodami gʌtʌcaca ʌmo istumaasi. Aapi camaatʌ vʌʌsi istumaasi tʌtʌgitoi oodami cascʌdʌ. Imaasicʌdʌ cavaavoitu aatʌmʌ isaapi divia mʌʌcadʌrʌ siaaco daja Diuusi ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Taidʌ ʌSuusi povʌrtʌtʌdai: ―¿Sʌʌlicʌdʌ mʌsgiñvaavoitudai aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Otoma aimu istuigaco aapimʌ aipacoga voopoimu dai ʌʌgi ginviaamu. Dʌmos vʌʌscʌrʌ maiʌʌgi daacamu aanʌ. Diuusi giñooga giñʌʌmadu daacamu cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Vʌʌsi imaasi gʌnaagidi aanʌ vai aapimʌ gʌniibʌstacan tadaca giñvaavoitudacai. Tami oidigi daama sʌʌlicʌdʌ soimaasi taatamu aapimʌ. Dʌmos maitavʌrvuaam ʌnʌliada aapimʌ aanʌ gia vaamioma istutuidi siʌgai ismaacʌdʌ viaa guvucadagai tami oidi daama ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Caaagidacai ʌSuusi imaasi dai tai nʌnʌaava tʌvaagi amacoga daidʌ itʌtʌdai: ―Giñooga caaayi siuu duucu aapi tʌʌgidagi oodami iñsaanʌ gʌmara viaa guvucadagi dai tʌʌgidamu aanʌ oodami issʌʌlicʌdʌ viaa guvucadagai aapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aapiapa ʌgai daidʌ giñmaa sʌʌlicami ansai aanʌ tʌaanʌiña vʌʌsi oodami oidi daama oidacami. Dai ansai aanʌ maacana ibʌdagai utudui vʌʌsi ismaacʌdʌ aapi ʌco vuvaitu vai ʌgai vʌʌscʌrʌ oidacamu aatʌmʌ gʌrʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dai sioorʌ viaacamu idi ibʌdagai utudui poduucai ʌgai gʌmaatʌ aapi daidʌ giñmaatʌ aanʌ ʌʌpʌ. Daidʌ maatʌ ʌgai isʌʌgi aapi sʌʌlicʌdʌ ʌrDiuusi, dai isaapi giñootoi tami oidigi daama. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Camamaatʌtuli aanʌ ʌoidacami tami oidi daama isaapi vaamioma viaa guvucadagai sitomasioorʌ. Canaato aanʌ aa duiñdagai ismaacʌdʌ giñtʌjai aapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sivi gia giñooga ʌpamu igiñmaaca ʌgai vaa guvucadagai ismaacʌdʌ viaacatadai aanʌ aapi ʌʌmadu maiquiaa tiipucatai oidigi abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Camaatʌtuli aanʌ ʌgai ismaacʌdʌ ʌco vuvaitu aapi oidigi daama oidajami saagidiaiñdʌrʌ istuiga aapi. Aapi ʌco vuvaitu ʌgai vaidʌ giñoidátucuiña dai ʌʌgiditai caʌcana gʌñiooqui ismaacʌdʌ aagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dai sivi ʌgai cʌʌ maatʌ ismosʌcaasi istumaasi giñaagidi aapi ʌgai vaa ñiooqui aagidi aanʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Poduucai aanʌ aagidi ʌgai gʌñiooqui ismaacʌdʌ giñmaa aapi dai ʌgai vaavoitu giñiooqui. Dai ʌgai vaavoitudai ʌʌpʌ iñsaanʌ divia mʌʌcadʌrʌ siaaco daja aapi daidʌ isaapi giñootoi tami oidi daama. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Gʌdaañʌi aanʌ pʌsai nuucadacana ʌgai ismaacʌdʌ giñoidatucui ʌgai vaa ismaacʌdʌ ʌco vuvaitu aapi dai maisiu gʌdaanʌi pʌsai nuucadacana aapi ʌmaivaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vʌʌsi istumaasi viaa aapi ʌraanʌ iñtuidaga ʌʌpʌ dai vʌʌsi istumaasi viaa aanʌ ʌraapi gʌtuidaga ʌʌpʌ. Dai vʌʌsi aapi gʌmaamara ʌraanʌ giñmaamara ʌʌpʌ. Sʌʌlicʌdʌ siaa giñduutuadamu oodami nʌiditai isducatai ivueeyi ʌgai ismaacʌdʌ giñvaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aanʌ gia camaiviimu tami oidi daama baiyoma imimu aanʌ mʌʌca siaaco daja aapi. Dʌmos ʌgai gia viimu tami oidi daama. Giñooga aapi tomali ʌmo imidagai maisoimaasi ivueeyi sʌʌlicʌdʌ cʌʌga tʌgito aapi. Nuucadañi aapi gʌguvucadacʌdʌ ʌgai ismaacʌdʌ ʌco vuvaitu aapi vai ʌgai viaacagi ʌmo tʌgitoidagai ʌpan duucai aatʌmʌ viaa ʌmo tʌgitoidagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aidʌsi quiaa aimʌraitadai aanʌ ʌgai ʌʌmadu tami oidi daama cʌʌga nuucadatadai aanʌ gʌguvucadacʌdʌ ʌgai ismaacʌdʌ ʌco vuvaitu aapi dai soicʌitadai aanʌ sai apiavaavoitudaiña. Tomali ʌmoco maigajiaadʌrʌ giñviaa mosʌca ʌmoco ʌgai ismaacʌdʌ ʌʌmadu daja ʌDiaavora dai poduucai ʌpʌdui ismaacʌdʌ casi ooja Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dai sivi caimia iñagai aanʌ mʌʌca siaaco daja aapi. Dʌmos quiaa daacatai aanʌ tami oidi daama aagidi aanʌ vʌʌsi imaasi giñmamaatʌrdamiga vai ʌgai baigʌnʌliada poduucai isduucai baigiñʌlidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Camaa aanʌ gʌñiooqui ʌgai. Daidʌ ʌmaivaavoitudadami sʌʌlicʌdʌ cʌʌdai ʌvaavoitudadami. Ʌvaavoitudadami camaisoiduucai oidaga cascʌdʌ. Ʌvaavoitudadami cʌʌgacʌrʌ oidaga giñʌʌpan duucai. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aanʌ maitʌdaanʌi pʌsai vuvaidana ʌvaavoitudadami oidigi daamaiñdʌrʌ mosʌcaasi gʌdaanʌi aanʌ pʌsai sobicʌdana ʌDiaavora vai ʌgai maisoimaasi duiñtuldana. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Aanʌ gia maisoiduu oidaga daidʌ giñmamaatʌrdamiga maisoiduu oidaga poduucai isduucai soiduu oidaga ʌmaivaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Soicʌdañi aapi giñmamaatʌrdamiga vai ʌgai sʌʌlicʌdʌ cʌʌga gʌntʌtʌgitocana dai cʌʌga oidacagi vaavoitudacai ʌgai gʌñiooqui. Gʌñiooqui sʌʌlicʌdʌ ʌrvaavoi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Poduucai isduucai aapi giñootoi tami oidi daama aanʌ ʌʌpʌ ootosa giñmamaatʌrdamiga vai aagidiana ʌgai gʌñiooqui ʌoodami tami oidi daama oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Dai aanʌ gia sʌʌlicʌdʌ gʌʌʌgidi vʌʌsi istumaasi giñtʌaanʌi aapi vai poduucai ʌgai ʌʌpʌ sʌʌlicʌdʌ gʌʌʌgiadagi dai cʌʌgacʌrʌ oidacagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Maisiu mosʌcaasi gʌdaanʌi aanʌ pʌsai soicʌiña giñmamaatʌrdamiga baiyoma gʌdaanʌi aanʌ pʌsai soicʌiña ʌgaa ismaacʌdʌ vaavoituda agai aagidacai giñmamaatʌrdamiga gʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dai gʌdaanʌi aanʌ giñooga isʌgai vʌʌscatai mosʌmadugan duucai tʌtʌgitoiña ʌpan duucai aatʌmʌ mosʌmadugan duucai tʌtʌgitoi. Mosʌmadugan duucai tʌtʌgitodacai ʌgai poduucai ʌoodami oidi daama oidacami vaavoituda agai pʌsigiñootoi aapi tami oidi daama. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Poduucai isduucai aapi giñooga giñsiaa duutudai iñʌʌmadu aimʌraitai poduucai ʌʌpʌ aanʌ siaa duutudai giñmamaatʌrdamiga ʌʌmadu aimʌraitai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ʌgai ʌʌmadu daja aanʌ. Dai aapi giñʌʌmadu daja. Dai poduucai ʌmadugan duucai tʌtʌgitoi ʌgai daidʌ poduucai ʌmaivaavoitudadami maatʌmu isaapi giñootoi daidʌ isaapi oigʌdai giñmamaatʌrdamiga poduucai isduucai giñoigʌdai aapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Giñooga, aapi ʌco vuvaitu ʌgai aanʌ iñvʌʌtarʌ. Dai aanʌ ipʌlidi isʌgai giñʌʌma daraajagi dai nʌidagi iñsaanʌ viaa ʌmo sʌʌlicami ismaacʌdʌ giñmaa aapi dai iñsaanʌ ʌrʌmo gʌʌ tʌaanʌdami mʌʌca siaaco daja aapi. Maiquiaa cʌquivacai oidigi abiaadʌrʌ giñoigʌdai aapi cascʌdʌ giñmaa ʌsʌʌlicami. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Giñooga aapi ivueeyi mosʌcaasi istumaasi ʌrsʌʌlicami. Ʌoodami maivaavoitudadami maitʌmaatʌ dʌmos aanʌ gia gʌmaatʌ. Daidʌ giñmamaatʌrdamiga cʌʌ maatʌ isaapi giñootoi ansai diviana tami. ");
INSERT INTO ntpNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aanʌ casi aagidi ʌgai istuiga aapi. Dai quiaa aagidimi aanʌ ʌgai istuiga aapi, vai poduucai ʌgai giñoigʌadagi poduucai isduucai aapi giñoigʌdai, ʌʌmadu daacatai aanʌ ʌgai ―tʌtʌdai ʌSuusi gʌooga. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Dai casi aagidacai ʌSuusi imaasi ii ʌgai aatʌmʌ mamaatʌrdamigadʌ ʌʌmadu mʌʌmocoradʌrʌ ʌaqui Sedʌróñi mʌʌca siaaco muidu oliivosi dʌʌdʌdʌ. Dai movaapa ʌgai uusi saagida. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Daidʌ ʌUudasi cʌʌga maatʌcatadai ami, ʌSuusi ʌʌmadu aatʌmʌ mamaatʌrdamigadʌ ʌgai duudatai ami gʌrʌmpaidiña cascʌdʌ. ɅUudasi ʌgai dai ami gatʌʌgida agaitadai ʌSuusi mʌsai bʌʌcaiña dai muaana. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Taidʌ ʌUudasi ami divia siaaco daacatadai ʌSuusi dai vaidati mui sandaaru. Siʌʌsi guviernu sandaarugadʌ icaasi ʌjudidíu quiuupaigadʌ sandaarugadʌ ismaacʌdʌ ootoi ʌbaitʌguucacamigadʌ papaali daidʌ ʌfariseo. Ʌsandaaru vucati mamaastai dai cuudagi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Dʌmos ʌSuusi camaatʌcatai vʌʌsi istumaasi ʌpʌduñia agaitai vuidʌrʌ cʌquiva ʌsandaaru dai tʌcacai dai potʌtʌdai: ―¿Moor gaagai aapimʌ? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Taidʌ ʌsandaaru aa noragi daidʌ itʌtʌdai: ―Gaagai aatʌmʌ ʌSuusi Nasareetʌrʌ oidacami ―tʌtʌdai. Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aanʌava ―tʌtʌdai. Taidʌ ʌsandaaru saagida cʌʌca ʌUudasi. Ʌgai vaa ʌgai daidʌ gatʌʌgi ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aidʌsi ʌSuusi itʌtʌdai: “Aanʌanʌ”, taidʌ ʌsandaaru taí suuli dʌvʌʌrapi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Taidʌ ʌSuusi mostʌcacai ʌʌpʌpʌ ʌsandaaru daidʌ itʌtʌdai: ―¿Moor gaagai aapimʌ? ―tʌtʌdai. Taidʌ ʌsandaaru itʌtʌdai: ―Gaagai aatʌmʌ ʌSuusi Nasareetʌrʌ oidajami ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Amaasi ʌSuusi itʌtʌdai: ―Casi gʌnaagidi aanʌava. Isgiñgaagaimi aapimʌ, dagitavurai vai iimʌna idi ismaacʌdʌ giñʌʌmadu guuca ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Dai mopovʌdui dai ʌpʌdui istumaasi caaagaitaidai ʌSuusi: “Ismaacʌdʌ ʌco vuvaitu giñooga tomali ʌmaadutai maitiñvoopoji”, caititadai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Amaasi Simuñi Piiduru vusaitu gʌcusiru dai ʌgaicʌdʌ iquitʌ naacadʌ sʌʌlisa padʌrʌ Malico. Ʌgai ʌrpiooñigadʌ ʌbaitʌcʌaacamigadʌ ʌpapaali. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dʌmos ʌSuusi itʌtʌdai Piiduru: ―Ʌpamu igʌcubiertagʌrʌ cʌʌsa gʌcusiru. Aliʌsi gʌaagai iñsaanʌ soimaasi taatagi poduucai isduucai aagai giñooga issoimaasi taata iñagai aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Amaasi ʌguviernu sandaarugadʌ ʌʌmadu ʌtʌaanʌdamigadʌ ʌgai ʌʌmadu ʌjudidíu sandaarugadʌ bʌi ʌSuusi dai vuu. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dai otoma vaidacai ʌAanási quiidiamu Aanási ʌrtuubadʌ Caifási. Aidʌ uumirʌ Caifási ʌrbaitʌcʌaacamigadʌ ʌpapaali. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ʌgai vaa Caifási caaagiditadai ʌjudidíu isvaamioma ʌrcʌʌgai ʌgai vʌʌtarʌ ismuuquiagi ʌmo cʌʌli vʌʌsi oodami vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simuñi Piiduru ʌʌmadu aanʌ oí ʌSuusi. Ʌbaitʌcʌaacamigadʌ ʌpapaali giñmaatʌcatadai cascʌdʌ vaa aanʌ Suusi ʌʌmadu tuisicana quiidʌrʌ ʌbaitʌcʌaacamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dʌmos Piiduru quiidigana vii cuuparagai abaana. Cascʌdʌ aagidi aanʌ ʌali ooqui ismaacʌdʌ nuucada quitaagiña sai maacana oigaragai isvaaquiagi Piiduru. Dai mosai vaaquimi ʌPiiduru ");
INSERT INTO ntpNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","taidʌ ʌali ooqui tʌcacai ʌPiiduru daidi itʌtʌdai: ―¿Maitasi ʌrvaavoi isaapi ʌrmamaatʌrdamigadʌ gomaisapicʌdʌ? ―tʌtʌdai ʌali ooqui. Taidʌ ʌPiiduru itʌtʌdai: ―Chuava. Angia chu ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ʌpidicatadai aidʌpʌrʌ cascʌdʌ ʌpipiooñi ʌʌmadu ʌsandaaru ganai daidʌ gʌuucadaca taí. Vaidʌ ʌPiiduru ami gasaagida cʌʌcʌ ʌʌpʌ daidʌ uucadacai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ʌbaitʌcʌaacamigadʌ ʌpapaali tʌcacaimi ʌSuusi soorʌ ʌrmamaatʌrdamigadʌ ʌgai dai astumaasi mamaatʌtuli ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ gaaagidi giññiooqui ʌoodami vuitapi dai vʌʌscʌrʌ gamamaatʌtulitadai ʌaali quiquiuupaigadʌrʌ ʌjudidíu daidʌ ʌgʌʌ quiuupaigadʌrʌ ʌjudidíu siaaco gʌnʌmpaidi ʌgai. Dai aanʌ maisiu ʌʌstocai gaaagidi tomali ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tuipʌsi giñtʌcacai? Tʌcacañi aapi ʌgai ismaacʌdʌ giñcaʌ vai ʌgai gʌaagidana istumaasi gaaagidi aanʌ. Cʌʌ maatʌ ʌgai istumaasi gaaagidi aanʌ ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Potʌʌdacai ʌSuusi tai ʌmo sandaaru ʌgʌʌ quiuupiaiñdʌrʌ mocʌaacatadai dai gʌʌgʌ ʌgai ʌSuusi vuivasadʌrʌ daidʌ itʌtʌdai: ―Maitiñiooquiada ʌbaitʌcʌaacamigadʌ ʌpapaali ―tʌtʌdai ʌsandaaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Isaagai aanʌ ʌmo istumaasi maicʌʌgaducami iñaagidañi aapi istumaasi maicʌʌgaducami aagai aanʌ. Dʌmos iscʌʌgadu istumaasi aagidi aanʌ, ¿tuipʌsi giñgʌʌgʌ? ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Amaasi ʌsandaaru vuu ʌSuusi tai Aanási ootoi ʌSuusi Caifási quiidiamu. Caifási ʌrʌbaitʌcʌaacamigadʌ ʌpapaali. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Vaidʌ Piiduru quiaa taíco cʌaacatadai dai gʌuucada. Daidʌ ʌgaa ismaacʌdʌ moguucacatadai itʌtʌdai: ―¿Maitasi ʌrvaavoi isaapi ʌrmamaatʌrdamigadʌ gomaisapicʌdʌ? ―tʌtʌdai ʌgai. Taidʌ ʌPiiduru itʌtʌdai: ―Chu, angia chu ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Vai ami cʌaacatadai ʌmo piooñigadʌ ʌbaitʌcʌaacamigadʌ ʌpapaali. Ʌpiooñi ʌraduñdʌ ʌcʌʌli ismaacʌdʌ Piiduru iquitʌ naacadʌ. Daidʌ ʌpiooñi itʌtʌdai ʌPiiduru: ―¿Maitasi ʌrvaavoi isgʌnʌidi aanʌ mʌʌca siaaco muidu oliivosi dʌʌdʌdʌ ʌmaisapicʌdʌ ʌʌmadu? ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dai Piiduru ʌʌpʌpʌ itʌtʌdai ismaitʌrvaavoi. Pocaitimi Piiduru tai cuujui ʌmo tacu cʌliadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Dai camaasidatai oidigi ʌsandaaru vaidacai ʌSuusi ʌgʌʌ quiiyamu siaaco daacatadai ʌcaigi. Dʌmos ami siaaco daacatadai ʌcaigi maivaapa ʌjudidíu. Camiaadimitadai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ cascʌdʌ. Ʌjudidíu daidarsi isvaapaquiagi quiidʌrʌ ʌmoco ismaacʌdʌ ʌmaitʌrjudidíu siaa duutudaitai ʌsiaa duudagai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Cascʌdʌ ʌcaigi ismaacʌdʌ Pilaato tʌʌgidu vuusai dai ñiooquida agai ʌjudidíu dai potʌtʌdai: ―¿Tumaasicʌdʌ gʌpiʌr vuupai aapimʌ idi cʌʌli? ―tʌtʌdai ʌcaigi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tai ʌgaa aa noragi daidʌ itʌtʌdai: ―Isgoovai maitʌrsoimaasi ivuaadamicamudai maivuaapamudai aatʌmʌ ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Amaasi ʌPilaato tʌtʌdai: ―Bʌcavurai aapimʌ gocʌʌli dai ʌʌgi aapimʌ nʌida issʌʌlicʌdʌ gʌpiʌr caatʌcami ischu ʌʌpʌ aapimʌ gʌnsʌʌlicamigacʌdʌ ―tʌtʌdai ʌPilaato. Tai aa noragi ʌjudidíu dai potʌtʌdai: ―Dʌmos aatʌmʌ ʌjudidíu maiviaa oigaragai ismuaagi tomali ʌmaadutai ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aidʌsi ʌpʌdui gomaasi aidʌ ʌpʌdui ismaacʌdʌ aagai ʌSuusi aagaitai isducatai muuqui agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Taidʌ ʌPilaato aa gʌi dai vaa ʌgʌʌ quiiyʌrʌ. Dai vaí ʌgai ʌSuusi daidʌ tʌcacai dai potʌtʌdai: ―¿Aapipʌsi ʌrraígadʌ ʌjudidíu chu sio? ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Taidʌ ʌSuusi itʌtʌdai: ―¿Aapi ʌʌgipʌsi giñtʌcacai gomaasi aa isgʌaagidio? ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Taidʌ ʌPilaato aa noragi daidʌ itʌtʌdai: ―¿Povaipʌs ʌlidi aapi iñsaanʌ ʌrjudíu? Gʌaaduñi ʌjudidíu ʌʌmadu ʌbaitʌguucacamigadʌ ʌpapaali gʌvuaa tami. ¿Tuma dui aapi? ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Amaasi ʌSuusi itʌtʌdai: ―Giñsʌʌlicamiga maisiu ʌpan ducami sʌʌlicamigadʌ baitʌguucacami tami oidi daama. Isʌrraícamudai aanʌ ʌpan duucai ʌmo raí tami oidi daama aidʌ gia giñoidatucudamiga cocodamudai ʌjudidíu sai maitimbʌʌna dai tomali ʌUudasi maitiñtʌʌgidamudai ʌjudidíu. Dʌmos aanʌ ʌrraí maisiu ʌpan duucai ʌmo raí tami oidigi daama ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Amaasi ʌPilaato itʌtʌdai: ―¿Aidʌ gia ʌrvaavoi isaapi ʌrraígadʌ ʌjudidíu? ―astʌtʌdai. Taidʌ ʌSuusi itʌtʌdai: ―Aanʌ ʌrraí poduucai isduucai iñaagidi aapi. Aanʌ divia tami oidi daama dai oodami duucai vuusai daidʌ gaaagida iñagai istumaasi ʌrvaavoi. Tomasioorʌ sioorʌ caʌca ʌlidi istumaasi ʌrvaavoi ʌgai gia ʌʌgiditai caʌcana istumaasi aagidi aanʌ ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Taidʌ ʌPilaato itʌtʌdai: ―¿Tumaasi ʌrvaavoi? ―astʌtʌdai. Dai mospotʌʌdacai ʌʌpʌpʌ vuusai ʌgai quiidigamu dai ñiooquida agai ʌjudidíu daidʌ potʌtʌdai: ―Aanʌ maitʌtʌʌgai istumaasicʌdʌ gʌpiʌr vuupai aapimʌ idi cʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dʌmos aapimʌ poduucai gʌnviida vʌʌsi uumigi idi siaa duudagʌrʌ isdagituagi isimiagi ʌmo maisapicami. ¿Ipʌlidimʌsi aapimʌ iñsdagituagi isimiagi ʌraígadʌ ʌjudidíu? ―tʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Amaasi vʌʌscatai cavami ijiña daidi itʌtʌdai: ―Googia chu. Daigitoñi vai imʌna Baraavási ―tʌtʌdai ʌjudidíu. ɅBaraavási ʌrʌʌsivogamicana. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Amaasi ʌPilaato gatʌjai mʌsai gʌgʌʌna ʌSuusi iquisanaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Daidʌ ʌsandaaru idui ʌmo cooronai uuparaicʌdʌ dai ʌSuusi moodʌ daama daí. Dai aadi yuucusi moraducami sai ʌpʌa maascana raí. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dai sicoli guuquiva daidʌ icaiti: ―Tan cʌʌca ʌraígadʌ ʌjudidíu ―ascaiti ʌsandaaru parunaitai ʌSuusi. Daidʌ ʌsandaaru capiji ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Amaasi ʌPilaato ʌpamu vuusai quiidigamu daidi itʌtʌdai ʌjudidíu: ―Vuaapamu aanʌ gomaisapicʌdʌ baigovai vai nʌida aapimʌ ismaitʌʌ aanʌ isducatai ʌrsoimaasi ivuaadami goovai ―tʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tai vuusai ʌSuusi dai quiaa gʌmoo dan daasa ʌuuparai cooronai dai apiaquiaa gʌaada ʌyuucusi moraduacʌdʌ. Aidʌ ʌPilaato itʌtʌdai ʌjudidíu: ―Tan cʌʌca gocʌʌli ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mostʌʌ ʌbaitʌguucacamigadʌ ʌpapaali ʌʌmadu sandaaruga ʌSuusi dai iiñaquimi daidʌ icaiti: ―Siisañi curusiaba, siisañi curusiaba vai poduu muucuna ―caiti ʌoodami. Taidʌ ʌPilaato itʌtʌdai: ―Vaidacaivurai aapimʌ idi cʌʌli dai siisa curusiaba. Aanʌ gia maitʌtʌʌgai isducatai ʌrsoimaasi ivuaadami idi ―tʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Daidʌ ʌjudidíu aa noragi daidʌ itʌtʌdai: ―Gʌrsʌʌlicamigadʌcʌdʌ aliʌsi gʌaagai ismuuquiagi gocʌʌli. Goovai gaagidi saidʌ ʌrDiuusi maradʌ ismaacʌdʌ divia tʌvaagiaiñdʌrʌ daidʌ isʌpan tuiga Diuusi. Cascʌdʌ aliʌsi gʌaagai ismuquiagi ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Moscaʌcai imaasi ʌPilaato dai vaamioma duaadimu ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dai ʌpa aa gʌi dai vaa ʌgʌʌ quiiʌrʌ dai tʌcacai ʌSuusi dai potʌtʌdai: ―¿Paaco oidacami aapi? ―astʌtʌdai. Dʌmos ʌSuusi maiaa noragi tomali ʌmo ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Amaasi ʌPilaato itʌtʌdai: ―¿Maitiñaa noragi aapi? ¿Maitapʌsmaatʌ aapi iñsaanʌ viaa sʌʌlicami isgʌsiisagi curusiaba? Dai aanʌ viaa sʌʌlicami ʌʌpʌ isgʌdagituagi pʌsai imʌna ―tʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aapi gia maiviaacamudai toma lʌʌchi sʌʌlicami pʌsigiñmuaagi isgiñooga maitʌmaaquimudai sʌʌlicami. Cascʌdʌ ʌgai ismaacʌdʌ giñtʌʌgi aapi vuitapi vaamioma ʌrsoimaasi ivuaadami isaapi ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Aidʌ abiaadʌrʌ ʌPilaato gaagaimi isducatai dagituagi isimiagi ʌSuusi. Dʌmos ʌjudidíu iiñaquimi dai potʌtʌdai: ―Isaapi dagituagi isimiagi goovai aidʌ gia aapi maitʌramiigugadʌ ʌbaitʌcʌaacamigadʌ ʌRoomʌrʌ oidacami. Tomasioorʌ sioorʌ raíca ʌʌliadagi ʌgai ʌrsaayudʌ ʌbaitʌcʌaacamigadʌ ʌromamano ―tʌtʌdai ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Moscaʌcai ʌPilaato imaasi gatʌjai sai vusaidana ʌSuusi. Daidʌ ʌPilaato daiva ami siaaco gatʌcacai ismaacʌdʌ gʌpiʌr vuupai sabai isgʌpiʌr caatʌcami ischu ʌʌpʌ. Ami Gabatʌrʌ tʌʌgidu ismaacʌdʌ evreo ñiooquidʌcʌdʌ itʌiya ʌlidi odai daapacami. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aidʌ ʌrʌmo tasai ʌbʌidʌrʌ ʌsiaa duudagai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ daidʌ cayoga dan duitadai. Amaasi ʌPilaato itʌtʌdai ʌjudidíu: ―Tan cʌʌca gʌnraíga ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dʌmos cavami ijiiña ʌjudidíu: ―Muucuna, muucuuna, siisañi curusiaba ―tʌtʌdai ʌjudidíu. Taidʌ ʌPilaato itʌtʌdai: ―¿Ipʌlidimʌsi aapimʌ iñsaanʌ siisana curusiaba gʌnraíga? ―tʌtʌdai ʌPilaato. Dʌmos ʌbaitʌcʌaacamigadʌ ʌpapaali aa noragi daidʌ itʌtʌdai: ―Mosaliʌʌmaduga aatʌmʌ gʌrraíga. Mosʌʌgi ʌbaitʌcʌaacamigadʌ ʌromamano ―tʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gomaasicʌdʌ ʌPilaato tʌʌgi ʌSuusi ʌjudidíu sai gatʌaanʌna siisaragai curusiaba. Tai ʌgai vaidacai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tai vuusai ʌSuusi dai bʌcati gʌcurusiga. Dai imʌi mʌʌ oodami moodʌamu ismaacʌdʌ tʌʌgidu Gólgotʌrʌ evreo ñiooquidʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Dai ami siisa ʌsandaaru ʌSuusi curusiaba. Dai abaana ʌSuusi siisisa ʌpʌ gooca. Ʌmoco sʌʌlisa padʌrʌ ʌmai curusiaba dai ʌgʌmai ogisa padʌrʌ ʌmai curusiaba dai ʌSuusi ʌraana. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Dai curusiaba moo daama daí ʌmo oojai ismaacʌdʌ gatʌjai ʌPilaato daidʌ icaiti: “Idiavʌr ʌSuusi Nasareetʌrʌ oidacami raígadʌ ʌjudidíu”, caiti ʌoojai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dai ooja ʌñiooqui evreo ñiooquicʌdʌ dai giliego ñiooquicʌdʌ dai latiñi ñiooquicʌdʌ. Dai mʌʌca siaaco siisa ʌgai ʌSuusi miaaga ʌbaabaqui cascʌdʌ muidutai ʌjudidíu nʌidi gooojai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Cascʌdʌ ʌbaitʌcʌaacamigadʌ ʌpapaaligadʌ ʌjudidíu, itʌtʌdai ʌPilaato. ―Maitiooja aapi “Raígadʌ ʌjudidíu”, baiyoma poduu ooja. “Ʌʌgi pocaiti idi cʌʌli saidʌ ʌrraígadʌ ʌjudidíu” ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dʌmos ʌPilaato aa noragi daidʌ itʌtʌdai: ―Isduu ooja aanʌ poduu viimu goo ―astʌtʌdai ʌPilaato. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dai casiisacai ʌsandaaru ʌSuusi curusiaba dai ʌmpagi yuucusidʌ ʌSuusi dai gʌntaacogi ʌʌgi vʌʌtarʌ ʌmaacova sandaaru. Daidʌ bʌi ʌSuusi vaasaragadʌ tʌvʌʌducʌdʌ. Maisoomi ʌgai mosʌran dʌga. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Daidʌ ʌsandaaru aipacoga gʌaagidi dai pocaiti: ―Maisaranamu aatʌmʌ govaasaragai. Baiyoma nʌʌnʌituda aatʌmʌ volao dai poduucai nʌida agai isioorʌ ajiagi govaasaragai ―caiti ʌsandaaru. Aidʌsi ʌpʌdui imaasi aidʌ ʌpʌdui istumaasi aagai Diuusi ñiñiooquituldiadamigadʌ daidʌ poduu ooja: “Gʌntaacogi ʌgai giñyuucusi ʌʌgi ʌgai gʌnvʌʌtarʌ nʌʌnʌitudacai volao giñyuucusi vʌʌtarʌ”, asduu oojisi. Poduucai idui ʌsandaaru. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Suusi curusigadʌ abaana guucacatadai Suusi dʌʌdʌ ʌʌmadu Suusi duusulidʌ ʌʌmadu María Cʌliopasi ooñigadʌ, ʌʌmadu María Madaliña. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Daidʌ ʌSuusi tʌʌ gʌdʌʌ dai aanʌ abaana cʌaacatadai. Dai aliʌsi giñoigʌdaiña. Daidi itʌtʌdai ʌSuusi gʌdʌʌ. ―Giñdaada, mocʌʌca gʌmaara ―tʌtʌdai ʌSuusi giñaagaitai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Amaasi povaiñtʌtʌdai ʌSuusi. ―Mocʌʌca gʌdaada, iñtʌtʌdai. Dai aidʌ abiaadʌrʌ ʌSuusi ʌdʌʌdʌ giñquiiyʌrʌ oidatu. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Daidʌ maí ʌSuusi iscaʌpʌdui vʌʌsi istumaasi gʌaagaitadai isʌpʌduñiagi vai cʌʌgacʌrʌ vuvaquiagi oodami. Daidʌ ʌSuusi icaiti. ―Tonomo aanʌ ―caiti. Daidʌ gomaasicʌdʌ ʌpʌdui istumaasi oojisi Diuusi ñiooquidʌrʌ isʌpʌduuñi agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dai ami daacatadai ʌmo aayi suudacami uuvasi varagadʌ ʌʌcocami. Daidʌ ʌsandaaru bʌi ʌmo visiocoli dai vadʌitu ʌuuvasi varagadʌcʌdʌ dai ʌmo tootoicami cuugʌrʌ daí ʌvisiocoli dai miaadʌrʌ dadasdi ʌSuusi sai visiusuna. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Taidʌ ʌSuusi visiusu ʌuuvasi varagadʌ ʌʌcocʌdʌ daidʌ icaiti: ―Caʌpʌdui vʌʌsi istumaasi ʌpʌduñia agaitadai ―caiti ʌSuusi. Amaasi coidamacoga cuiqui ʌSuusi dai muu. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aidʌ ʌrʌmo tasai ʌbʌidʌrʌ ʌsiaa duudagai istuigaco ʌjudidíu tʌtʌgitoiña aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ. Daidʌ ʌjudidíu maitipʌliditadai iscurusiaba viiagi ʌcoidadʌ ibʌstaragai tasʌrʌ. Vaamioma siaa gʌduu aidʌ tasʌrʌ cascʌdʌ. Dai cascʌdʌ daanʌitadai ʌgai ʌPilaato sai gatʌaanʌna omisaragai nonoosacadʌ ʌgai ismaacʌdʌ cucurusiaba siisisapi dai istʌaapaiñdagi tuutucugadʌ cucurusiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Amaasi ʌsandaaru iji dai oomi nonoosacadʌ ʌpʌgadadʌ daidʌ ʌgʌmai ʌʌpʌ ismaacʌdʌ ʌSuusi abaana siisapi ʌmai curusiaba. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dʌmos aidʌsi miaadʌrʌ nʌnʌidi ʌgai ʌSuusi tʌʌ ʌgai iscasi ʌrmuuquiadʌ dai cascʌdʌ maioomi nonoosacadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Vʌʌscʌrʌ ʌmo sandaaru bʌi ʌmo uusi tʌvʌʌducami muucacami cuugadʌ dai ʌgaicʌdʌ sʌi oonomadʌ uuta tai vuusai ʌʌradʌ ʌʌmadu suudagi abaidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Idi ismaacʌdʌ ooja aanʌ, aanʌ gia ñʌidi dai sʌʌlicʌdʌ ʌrvaavoi. Dai cʌʌ maatʌ aanʌ vaidʌ ʌrvaavoi daidʌ poduu ooja aanʌ mʌsai vaavoitudana aapimʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aidʌsi ʌpʌdui vʌʌsi gomaasi aidʌ ʌpʌdui istumaa ooja Diuusi ñiooquituldiadamigadʌ dai poduu ooja: “Maimuuliña agai tomali ʌmo odʌ ʌgai”. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dai ooja ʌʌpʌ Diuusi ñiooquituldiadamigadʌ dai poduu ooja: “Dai nʌidamu ʌoodami mʌssʌi tuucugadʌ ʌgai”, asduu ooja. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Amaasi ʌmo cʌʌli Osee tʌʌgiducami Arimateeʌrʌ oidacami ii dai taí oigaragai ʌPilaato sai dagitona isbʌʌquia ʌgai ʌSuusi tuucugadʌ. Daidʌ ʌOse ʌrvaavoitudadamicatadai, tomasi ʌsto vaavoitudai ʌgai. Ʌʌbʌidi ʌgai ʌjudidíu cascʌdʌ. Taidʌ ʌPilaato maa oigaragai isbʌʌquiagi ʌgai ʌSuusi tuucugadʌ. Taidʌ ʌOsee ii dai bʌcai tuucugadʌ ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ɅOsee ʌʌmadu ii Nicodemo. ɅNicodemo ʌgai dai tucarʌ diviji ʌSuusi. Dai bʌcati ʌgai ʌmo coobai dan baivustaama kilo chigian uuvadami. Ʌchigian uuvadami mirracʌdʌ ʌʌmadu áloesicʌdʌ duñisicatadai. Mirra ʌrʌsabai daidʌ áloesi ʌrʌmo uusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Daidʌ ʌOsee ʌʌmadu ʌNicodemo bʌʌcai ʌtuucugadʌ ʌSuusi dai biisa yuucusicʌdʌ ismaacʌdʌ sarabi ʌgai ʌchigian uuvadami poduucai isduucai gʌnviidacana ʌjudidíu yaasapaitai ʌcoidadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mʌʌca siaaco siisa ʌoodami ʌSuusi curusiaba ami oidacatadai mui uusi ismaacʌdʌ iibiatai. Dai ami oidacatadai ʌmo tʌjoi ismaacʌdʌ idui ʌoodami aitʌrʌ dai ami yaasa agai ʌmo muuquiadʌ. Dʌmos maiquiaa yaasa tomali ʌmaadutai tʌjoviʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dai ami ʌsto ʌgai ʌSuusi tuucugadʌ. Aliʌ miaaga ʌtʌjoi cascʌdʌ dai cayoga aayi siuu duucu abiaadʌrʌ siaa duutudaiña ʌjudidíu ʌibʌstaragai tasai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dai tumiñoco maiquiaa maasicai María Madaliña ii mʌʌca siaaco caatʌcatadai ʌSuusi tuucugadʌ. Dai aidʌsi aayi ʌgai tʌʌ isʌodai ismaacʌdʌ ʌcʌdʌ cuupicatadai ʌtʌjoi camaianaasi daacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Amaasi mʌʌ ʌMaría mʌʌca siaaco daraacatadai ʌSimuñi Piiduru ʌʌmadu aanʌ. ɅSuusi aliʌsi giñoigʌdaiña aanʌ. Daidʌ ʌMaría povʌrtʌtʌdai: ―Casi mʌtibʌcai gʌrbaitʌcʌaacamiga ʌtʌjooviaiñdʌrʌ dai maimaatʌ aatʌmʌ mʌsiaaco ʌsto ―gʌrtʌtʌdai ʌMaría. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Amaasi ʌPiiduru ʌʌmadu aanʌ vuvaja dai iji. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ʌmapai voopoigi aatʌmʌ vʌgoocatai. Dʌmos vaamioma mʌldaga aanʌ siʌPiiduru dai ʌpʌga aayi mʌʌ tʌjoovai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dai gai nʌnʌaava aanʌ tuucavi. Dai tʌʌ ʌyuucusi ismaacʌdʌ ʌcʌdʌ biisapicatadai ʌSuusi tuucugadʌ ismodaraaja dʌmos maivaa aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Gooquiʌrʌ aayi ʌPiiduru dai tuucavi vaa. Dai Piiduru tʌʌ ʌʌpʌ ʌyuucusi ismodaraaja. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Dai tʌʌ ʌʌpʌ ʌicuusi isaacʌdʌ ʌcʌdʌ biisapicatadai ʌSuusi moodʌ ismaiabaana daja ʌgaa yuucusi baiyoma ʌcovai daacatadai dai biisapica daja. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Amaasi vaa aanʌ ʌʌpʌ dai tʌʌ istumaasi ʌpʌduitadai dai vaavoitu. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aatʌmʌ maiquiaa maatʌ caʌcatadai istumaasi ooja Diuusi ñiñiooquituldiadamigadʌ Diuusi ñiooquidʌrʌ dai pocaiti sai aliʌsi gʌaagai isʌSuusi ʌpamu duaacagi coidadʌ saagidiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Amaasi aa suuli aatʌmʌ quiiyamu. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Dʌmos ʌMaría anaasi quiidigana vii ʌtʌjoi abaana dai suaacai soigʌʌʌldacai maitʌʌgacai ʌSuusi tuucugadʌ. Daidʌ quiaa suaacaitai gai nʌnʌaava tucavi tʌjovai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Dai tʌʌ gooca Diuusi tʌtʌaañicarudʌ tooto yuucuscami vai daraaja ami siaaco caatʌcatadai ʌtuucugadʌ ʌSuusi. Ʌmo Diuusi tʌaañicarudʌ moovasa amadʌrʌ daacatadai dai ʌgʌmai taatapʌsi amadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Taidʌ ʌDiuusi tʌtʌaañicarudʌ itʌtʌdai ʌMaría: ―¿Tuipʌsi suaacai? ―astʌtʌdai. Taidʌ ʌMaría itʌtʌdai: ―Bʌʌquiamʌta giñbaitʌcʌaacamiga dai maimaatʌ aanʌ mʌsiaaco imitu ―astʌtʌdai ʌMaría. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mospotʌtʌdai ʌMaría dai aa nʌnʌaava dai tʌʌ ʌSuusi vai ami cʌʌca dʌmos maimaí ʌgai siʌrSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Amaasi ʌSuusi tʌcacai dai potʌtʌdai: ―¿Tuipʌsi suaacai? ¿Poorʌ gaagai aapi? ―astʌtʌdai ʌSuusi. Daidʌ ʌMaría povʌlidi siʌgai ʌrʌʌsicami nuucadacami daidʌ itʌtʌdai: ―Aapi cʌʌli, pʌsbʌʌcai ʌmuuquiadʌ iñaagidañi pʌsiaaco daí nai aanʌ bʌʌquiagi ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Taidʌ ʌSuusi itʌtʌdai: ―María ―astʌtʌdai. Taida ʌMaría aa nʌnʌaava daidʌ itʌtʌdai evreocʌdʌ: ―Raboñi ―astʌtʌdai. Ismaacʌdʌ itʌiya ʌlidi mamaatʌtuldiadami. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Taidʌ ʌSuusi itʌtʌdai: ―Casi maitiñtaatamada. Maiquiaa tʌsai aanʌ mʌʌca siaaco daja giñooga. Baiyoma imʌdañi dai aagidañi giñaaduñi iñscaimia iñagai aanʌ mʌʌca siaaco daja Diuusi gʌrooga ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Amaasi ii ʌMaría Madaliña dai gʌraagida agai iscatʌʌ ʌSuusi dai istumaasi aagidi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ʌgai vaa tasʌrʌ tucarʌ gʌrʌʌmapagi aatʌmʌ ʌmo quiiyʌrʌ. Dai cucuupacatadai cucuuparagai. Ʌbʌiditadai aatʌmʌ ʌjudidíu cascʌdʌ. Tai todian duucai vaa ʌSuusi dai ʌran cʌquiva ʌgai. Dai gʌrviaatuli dai povʌrtʌtʌdai: ―Gʌniibʌstacan tadacavurai gʌniibʌdaga ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Gʌraagidacai gomaasi ʌSuusi gʌrtʌʌgi gʌnoovovi daidʌ gʌoonomaba gʌrtʌʌgi ʌʌpʌ siaaco sʌʌsiñi. Tʌtai aatʌmʌ sʌʌlicʌdʌ baigʌrʌʌli tʌʌgacai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Amaasi ʌSuusi ʌpamu povʌrtʌtʌdai: ―Gʌniibʌstacan tadacavurai gʌniibʌdaga. Poduucai isduucai giñootoi giñooga tami oidi daama saidʌ iduuna aanʌ istumaasi ʌgai ipʌlidi poduucai gʌnootoi aanʌ aapimʌ saidʌ iduuna aapimʌ istumaasi ʌgai ipʌlidi ―gʌrtʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Amaasi ʌSuusi gʌrvuijago vusiji dai povʌrtʌtʌdai: ―Diuusi Ibʌadʌ gʌnʌʌmadu daacana. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Isaapimʌ oigʌldi ʌsoimaascamigadʌ ʌoodami casiatgʌoigʌldi ʌsoimaascamigadʌ ʌgai. Dai isaapimʌ maioigʌldi ʌsoimaascamigadʌ ʌoodami casiatamaigʌoigʌldi ʌsoimaascamigadʌ ʌgai ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Dʌmos Tomás ʌmoco aatʌmʌ gʌraduñi ʌbaivʌstaama dan gooca mamaatʌrdamigadʌ ʌSuusi maitʌrʌma daacatadai aidʌsi divia ʌSuusi. Cuatai aagaiña oodami ʌTomás. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Dai gooquiʌrʌ aatʌmʌ potʌtʌdai ʌTomás: ―Tʌʌ aatʌmʌ gʌrbaitʌcʌaacamiga ―tʌtʌdai aatʌmʌ. Dʌmos ʌTomás povʌrtʌtʌdai: ―Ismaitʌʌgi aanʌ mʌsiaaco dʌʌdʌgarai ʌclaavocʌdʌ noonovidʌrʌ dai ismaivaasa aanʌ giñmaasaviga siaaco dʌʌdʌga noonoviʌrʌ ʌclaavocʌdʌ dai ismaivaasa aanʌ giñoovi siaaco sʌʌsiñi oonomaba maitistuidi antada aanʌ isvaavoitudagi ―gʌrtʌtʌdai ʌTomás. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bomamaco tasaicʌdʌ ʌpamu gʌrʌʌmapagi aatʌmʌ mamaatʌrdamigadʌ ʌSuusi ʌmo quiiyʌrʌ. Dai aidʌ ʌTomás modaacatadai aatʌmʌ gʌrʌʌmadu. Vai cucuupicatadai cucuuparagai tai vʌʌscʌrʌ vaa ʌSuusi dai ʌran cʌquiva. Dai gʌrviaatuli ʌgai dai povʌrtʌtʌdai: ―Gʌnibʌstacan tadacavurai gʌniibʌdaga ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Daidʌ ʌSuusi itʌtʌdai ʌTomás: ―Vaasañi tami gʌmasaviga dai nʌida giñmaataca. Dai vaasañi gʌnoovi dʌgacʌrʌ giñoonoma. Cascʌdʌ camaipoʌliada aapi ismaitʌrvaavoi, baiyoma vaavoitudañi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aidʌ gia aa noragi Tomás daidʌ itʌtʌdai: ―Giñbaitʌcʌaacamiga, giñDiuusiga ―tʌtʌdai ʌTomás. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Taidʌ ʌSuusi itʌtʌdai: ―Tomás sivi gia vaavoitudai aapi giñtʌʌgacai. Sʌʌlicʌdʌ baigʌnʌlidi ʌgai ismaacʌdʌ vaavoitudai tomasi maitiñnʌidi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Daidʌ ʌSuusi idui mui naana maasi gʌgʌrducami aatʌmʌ gʌrvuitapi ismaacʌdʌ maioojisi idi liivruʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dʌmos vʌʌsi istumaasi oojisi idi liivruʌrʌ casi gʌooja vai poduucai vaavoitudana aapimʌ isSuusi ʌrʌCristo daidʌ ʌrDiuusi maradʌ ismaacʌdʌ tʌvai tʌvaagiaiñdʌrʌ. Daidʌ isvʌʌscʌrʌ oidaca agai aapimʌ Diuusi ʌʌmadu vaavoitudacai Suusi Cristo. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dai ʌʌpʌ ʌmo imidagai ʌSuusi ʌpamu gʌmaasitu aatʌmʌ gʌrvuitapi mʌʌca ugidana ʌgʌʌ suudagi Tiveriiasi. Dai poduucai idui ʌgai: ");
INSERT INTO ntpNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ʌmapai daraaja ʌSimuñi Piiduru ʌʌmadu ʌTomás ismaacʌdʌ Cuatai aagaiña oodami ʌʌmadu Nataniel Canaaʌrʌ oidacami. Canaa ʌrʌmo ali quii Galilea dʌvʌʌriʌrʌ. Daidʌ modaraaja ʌʌpʌ Sevideo maamaradʌ dai ʌʌpʌ gooca gʌraaduñi ʌSuusi mamaatʌrdamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Taidʌ ʌSimuñi Piiduru povʌrtʌtʌdai: ―Mʌʌca vuvaida iñagai aanʌ vatopa ―tʌtʌdai. Tʌtai aatʌmʌ aa noragi daidʌ itʌtʌdai: ―Aatʌmʌ ʌʌpʌ imia ragai aapi gʌʌʌmadu ―tʌtʌdai. Amaasi iji aatʌmʌ dai tʌʌtʌsai ʌmo vaarcuʌrʌ. Dai ʌmo tucagi gaagai aatʌmʌ vatopa dai tomali ʌmoco maivuusaitu. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dai camaasidatai gʌmaasitu ʌSuusi ʌgʌʌ suudagi ugidana dʌmos maimaí aatʌmʌ isʌrSuusi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Amaasi ʌSuusi povʌrtʌtʌdai: ―Giñaaduñi, ¿maitamʌsi vuusaitu tomali ʌmoco? ―gʌrtʌtʌdai ʌgai. Tʌtai aatʌmʌ aa noragi daidʌ itʌtʌdai: ―Tomali ʌmoco ―tʌtʌdai aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Taidʌ ʌSuusi tʌtʌdai: ―Daitudavurai ʌvatop vuicaru sʌʌlisa apadʌrʌ govaarcu dai poduucai vuvaidamu aapimʌ vatopa ―gʌrtʌtʌdai ʌSuusi. Dai podui aatʌmʌ dai camaitistui isvusaidagi ʌvatop vuicarui mui vatopa vuucaticatai. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Amaasi aanʌ itʌtʌdai ʌPiiduru: ―Goovai ʌrgʌrbaitʌcʌaacamiga ―tʌtʌdai aanʌ. Moscaʌ ʌSimuñi Piiduru isʌrgʌrbaitʌcʌaacamiga ʌgai dai otoma gʌai gʌyuucusi dai suudarʌ gʌi. Ʌʌquiapioma Piiduru uupai gʌyuucusi vuvaidacai vatopa. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ʌvaarcu maisi mʌʌcasi daja ʌgʌʌ suudagi ugidiaiñdʌrʌ ʌmo sien metro ʌʌsi. Dai aatʌmʌ ismaacʌdʌ vaarcuʌrʌ vii vaiñstugai aatʌmʌ ʌvatopa vuicarui suudacami vatopa dai uugidiʌrʌ vuusaitu. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Amaasi mostʌaapai aatʌmʌ dʌvʌʌrapi dai tʌʌ tutupali mʌʌcami dai dan caatʌ ʌmo vatopa dai an vʌʌtʌ paana ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Taidʌ ʌSuusi povʌrtʌtʌdai: ―Baigovai avʌrgimvuida chiʌʌqui vatopa ismaacʌdʌ utudami vuvaitu aapimʌ ―gʌrtʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Taidʌ ʌSimuñi Piiduru tʌsai ʌvaarcuʌrʌ dai tʌvaimʌ ʌvatopa vuicarui ʌgʌʌ suudagi ugidana. Cʌʌ suudacami vatopa gʌgʌrducami ʌvatop vuicarui asta ʌmo siento dan goo coobai dan baivʌstaama dai vaica ajʌga vatopa. Dai tomasi muidu ʌvatopa vʌʌscʌrʌ maiʌʌcai ʌvatop vuicarui. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Amaasi ʌSuusi povʌrtʌtʌdai: ―Baigovʌr iimi tʌtaida uuga ―gʌrtʌtʌdai ʌSuusi. Dai tomali ʌmaadutai aatʌmʌ maitʌpʌrʌʌli istʌcacagi ʌSuusi sioorʌ ʌgai cʌʌga maatʌcatai isʌgai ʌrSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Amaasi ʌSuusi taicovai cʌquiva dai vui ʌpaana dai ʌvatopa gaicami dai gʌrtaacogi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aidʌcʌdʌ casi ʌrvaicojo isʌSuusi gʌmaasitu gʌrvuitapi duaacai abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cauugitocai aatʌmʌ taidʌ ʌSuusi tʌcacai ʌSimuñi Piiduru dai potʌtʌdai: ―Simuñi, Joonasi maradʌ, ¿vaamiomapʌsi giñoigʌdai aapi isgogaa? ―tʌtʌdai ʌSuusi. Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Ʌjʌ, giñbaitʌcʌaacamiga cʌʌ maatʌ aapi iñsaanʌ gʌoigadai ―tʌtʌdai ʌPiiduru. Taidʌ ʌSuusi itʌtʌdai: ―Aidʌ gia nuucadacañi aapi ʌoodami ismaacʌdʌ giñvaavoitudai. Aapi ʌrʌpan ducami ʌmo pastuuru. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dai ʌʌpʌpʌ tʌcacai ʌSuusi ʌPiiduru daidʌ itʌtʌdai: ―Simuñi, Joonasi maradʌ, ¿giñoigʌdaipʌsi aapi? ―tʌtʌdai. Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Ʌjʌ giñbaitʌcʌaacamiga cʌʌ maatʌ aapi iñsaanʌ gʌoigʌdai ―tʌtʌdai ʌgai. Taidʌ ʌSuusi itʌtʌdai: ―Aidʌ gia nuucadacañi aapi ʌoodami ismaacʌdʌ giñvaavoitudai ―tʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tai ʌpamu tʌcacai ʌSuusi ʌPiiduru daidʌ itʌtʌdai: ―Simuñi, Joonasi maradʌ, ¿giñoigʌdaipʌsi aapi? ―tʌtʌdai ʌSuusi. Taidʌ soigʌʌli ʌPiiduru catʌcacaitai ʌSuusi vaicojo isbai oigʌdai ʌgai daidʌ itʌtʌdai: ―Giñbaitʌcʌaacamiga cʌʌ maatʌ vʌʌsi istumaasi. Cʌʌ maatʌ aapi iñsaanʌ gʌoigʌdai ―tʌtʌdai ʌPiiduru. Taidʌ ʌSuusi itʌtʌdai: ―Aidʌ gia nuucadacañi aapi ʌgai ismaacʌdʌ giñvaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aanʌ gʌaagidi sai sʌʌlicʌdʌ aidʌsi vaamioma ʌrgʌʌli aapi ʌʌgi gʌaada gʌyuucusi dai aimʌrai tomasiaaco imia ʌliadagi. Dʌmos siʌʌscadʌ cacʌʌlimu aapi sʌʌliñamu gʌʌʌca vai ʌmai gʌaadidamu gʌyuucusi dai gʌvaidacamu mʌʌca siaaco maitipʌlidi aapi siimiagi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Potʌtʌdai ʌSuusi ʌPiiduru vai poduucai maatʌna isducatai muuquia agai ʌgai vaidʌ poduucai oodami cʌʌga siaa duutuadagi Diuusi. Daidʌ gooquiʌrʌ potʌtʌdai: ―Iñoidáñi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tai aa nʌnʌaava ʌPiiduru dai giñtʌʌ isgooquiʌrʌ imʌitadai aanʌ. ɅSuusi aliʌsi giñoigʌdaiña aanʌ. Dai aanʌ abaana daivacai gauu ʌSuusi aidʌ tucarʌ mʌsigatʌʌgida agaitadai. Dai aanʌ tʌcacai asmaacʌdʌ ʌgai dai tʌʌgida agai. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aidʌsi ʌPiiduru giñtʌʌ tʌcaca ʌgai ʌSuusi daidʌ itʌtʌdai: ―Giñbaitʌcʌaacamiga, ¿tumaasi ʌpʌduñi agai idi cʌʌlicʌdʌ? ―tʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Iñsaanʌ ipʌliadagi isgoovai oidacagi asta siʌʌsca ʌpamu divia aanʌ, ¿tumaasi ʌrgʌvʌʌtarʌ aapi? Mosai apiacʌʌga giñvaavoitudada aapi ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amaasi ʌvaavoitudadami aipaco aagaiña ansai aanʌ maimuuquiaa iñagai. Dʌmos ʌSuusi maiaagai ismaimuuquia iñagai aanʌ baiyoma potʌtʌdai ʌgai ʌPiiduru: “Iñsaanʌ ipʌliadagi isgoovai oidacagi astʌ siʌʌsca ʌpamu divia aanʌ, ¿tumaasi ʌrgʌvʌʌtarʌ aapi?” ―tʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dai aanʌ ooja vʌʌsi gomaasi idi liivruʌrʌ. Dai vʌʌsi istumaasi ooja aanʌ sʌʌlicʌdʌ ʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Dai oidaga mui vaamioma istumaasi ismaacʌdʌ idui ʌSuusi. Daidʌ isgʌoojamudai vʌʌsi gomaasi liliivruʌrʌ aanʌ piñʌlidi ismaiaajiacamudai vʌʌsi oidigʌrʌ ʌliliivru ismaacʌdʌ ʌpʌduuñimudai. Mosʌcaasi.");
INSERT INTO ntpNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Giñaduñi Teoopilo aanʌ ʌrRuucasi dai casiant gʌooji aanʌ dai gʌaagidi vʌʌsi istumaasi idui ʌʌmadu istumaasi mamaatʌtuldiña ʌSuusi oodami. Dai gʌaagidi aanʌ isducatai gʌaaga ʌSuusi gʌaa duiñdaga dai isducatai ivuaadana ");
INSERT INTO ntpNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta aidʌsi tʌsai ʌgai tʌvaagiamu. Aidʌsi maiquiaa ii ʌSuusi tʌvaagiamu aagidi ʌgai guvucadadʌcʌdʌ Diuusi Ibʌadʌ gʌojootosa istumaasi gʌaagai isiduñiagi. Ʌgai ʌrʌgai vaa ismaacʌdʌ ʌco vuvaitu ʌSuusi ʌʌquioma abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aidʌsi muu ʌSuusi ʌpamu duaaca dai ʌgai vaa divia dai vuidʌrʌ cʌquiva gʌojootosa dai goo coobai tasai aitu didividitai. Poduucai maasitu ʌSuusi isduaaca. Dai aagadi ʌSuusi gʌojootosa ismaasi siaaco tʌaanʌi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aidʌsi quiaa daacatadai ʌSuusi gʌojootosa ʌʌmadu aagidi sai maiiimʌna Jerusaleenaiñdʌrʌ, dai potʌtʌdai: ―Nʌnʌracavurai aapimʌ asta siʌʌscadʌ ʌpʌdui ismaacʌdʌ gʌnaagidi Diuusi giñooga isiʌpʌduñiagi, ʌgai vaa ismaacʌdʌ gʌnaagidi aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sʌʌlicʌdʌ ʌVuaana gʌnvapacoi suudagicʌdʌ mosʌʌpʌ chiʌʌqui tasaicʌdʌ vapacoñicamu aapimʌ Diuusi Ibʌadʌcʌdʌ sai ʌgai gʌnʌʌmadu daaca agai. Poduucai divimu Diuusi Ibʌadʌ dai vʌʌscʌrʌ gʌnʌʌmadu aimʌrdamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dai aidʌsi gʌnʌmpaidacatadai ʌgai Oliivosi giidiʌrʌ taidʌ ʌojootosicami itʌtʌdai ʌSuusi: ―Mamaatʌtuldiadami, ¿sivisi ʌrsiʌʌscadʌ vuvaida agai aapi ʌromamano vai camaitatʌaanʌiña ʌgai tanai Isireli dʌvʌʌriʌrʌ dai baiyoma aapi tʌaanʌdagi? ―astʌtʌdai ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Taidʌ ʌSuusi aa noragi daidʌ itʌtʌdai: ―Aapimʌ maitʌrʌnvʌʌtarʌ mʌsmaatʌcagi siʌʌscadʌ tomali istuigaco iduñiagi giñooca istumaasi ʌʌgi ʌgai viaa sʌʌlicami siduñiagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Siʌʌscadʌ tʌvañiagi Diuusi Ibʌadʌ aapimʌ gʌnʌʌmadu viaacamu aapimʌ guvucadadʌ dai ñiooquimu giñvʌʌtarʌ siʌʌsi tami Jerusaleenʌrʌ ʌcaasi aipacoga sicooli Jerusaleena, siaaco Judeea tʌʌgidu, dai gʌmai dʌvʌʌriʌrʌ vʌʌsi siaaco Samaalia tʌʌgidu dai asta mʌʌcasi oidigi ugidʌrioma ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aidʌsi caaagidi ʌSuusi imaasi tʌsai tʌvaagiamu. Dai quiaa tʌʌgigi ʌojootosicami tai divia ʌmo icomai dai iiña ʌSuusi tai camaivaamioma tʌʌ ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dai quiaa tʌʌgigi ʌgai tʌvaagiamu dai todian duucai tʌʌ gooca cʌcʌʌli tooto yuucuscami vai abaana guuca. Ʌgai dada aidʌsi quiaa tʌsadimi ʌSuusi tʌvaagiamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dai potʌtʌdai: ―Cʌcʌʌli Galileeʌrʌ oidacami, ¿tuimʌsi mosguucacatai tʌvaagiamu nʌeeyi? ʌgai vaa Suusi ismaacʌdʌ tʌsai tʌvaagiamu aapimʌ gʌnsaagidaiñdʌrʌ ʌpamu divimu poduucai isducatai tʌʌgigi aapimʌ aidʌsi tʌsai ʌgai tʌvaagiamu ―astʌtʌdai ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tai iji ʌojootosicami ami giidiaiñdʌrʌ Jerusaleenamu. Ʌgiidi miaanai cʌʌca Jerusaleena parʌ goo miil vaan cʌisapi ʌʌsi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aidʌsi caaayi ʌgai Jerusaleenʌrʌ goocua daama vaaquiʌrʌ tʌcaviaco tʌʌtʌsai. Ami gʌnuuliñacatadai ʌPiiduru, Jacovo, Vuaana, Aandʌrʌsi, Piili, Tomás, Bartolomé, Mataivo, ʌʌmadu Jacovo Alfeo maradʌ, ʌʌmadu Simuñi ismaacʌdʌ vuvaida ʌliditadai ʌromamano, ʌʌmadu Uudasi Jacovo suculidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vʌʌscatai ʌgai gʌnʌmpaidiña mamaadaragai vʌʌtarʌ, Suusi susuuculidʌ ʌʌmadu dai María Suusi dʌʌdʌ ʌʌmadu dai aa ooqui ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ʌmo imidagai aidʌsi gʌnʌmpagi ʌvaavoitudadami tai saagida cʌquiva ʌPiiduru, ami daraajatadai ʌmo siento dan ʌmo coobai oodami. Taidʌ ʌPiiduru potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Giñaaduñi, poduucai gʌaagaitadai siʌpʌduñiagi ismaacʌdʌ ʌʌquioma aagai Davicaru guvucadadʌcʌdʌ Diuusi Ibʌadʌ. Davicaru aagai Uudasicaru. Uudasicaru ʌrʌgai ismaacʌdʌ vuaa ʌgai ismaacʌdʌ maisapicami bʌʌcai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Daidʌ ʌrʌmoco gʌraduñicatadai dai viaacatadai sʌʌlicami gʌraa duiñdagʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Dai gasavʌʌli ʌmo dʌvʌʌrai ʌtumiñsicʌdʌ ismaacʌdʌ aa namʌqui ʌbaitʌguucacami ʌUudasicaru soimaasi iduucai ʌgai. Tai Uudasicaru gʌsagia dai vaiguugu dai taapai voocadʌ tai vuvaaja ijidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aidʌsi maí Jerusaleenʌrʌ oidacami Aselidama tʌʌtʌi ʌdʌvʌʌrai ismaacʌdʌ itʌiya ʌlidi oodamicʌdʌ Dʌvʌʌrai ʌʌracʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Poduucai ooja Davicaru liivruʌrʌ Salmosi tʌʌgiducʌrʌ aagaitai Uudasicaru: Ʌʌgi viʌʌna vaaquidʌ. Maitiipucana sioorʌ ami oidacagi. Dai siʌmai bʌimu sʌʌlicamigadʌ. Asduucai ooja Davicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Tanai aatʌmʌ gʌrsaagida oidaga ʌʌmoco cʌcʌʌli ismaacʌdʌ gʌrʌʌmadu ajioopaiña vʌʌs tasai aidʌsi daacatadai ʌSuusi aatʌmʌ gʌrʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Aidʌsi abiaadʌrʌ ʌVuaana vacoi ʌSuusi gʌrʌʌmadu ajioopaiña goovai asta aidʌsi tʌsai ʌgai tʌvaagiamu aatʌmʌ gʌrsaagidaiñdʌrʌ. Aliʌsi gʌaagai isgaaga aatʌmʌ ʌmoco goovai saagidaiñdʌrʌ ismaacʌdʌ nʌidi isduaaca Suusi vaidʌ ʌraagiadamicana Suusi duaacaradʌ aatʌmʌ gʌrʌʌmadu ―astʌtʌdai Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Amaasi ʌco vuvaitu gooca. Ʌmoco Osee Barsavasi tʌʌgidu mai Justo aagaiña ʌʌpʌ. Dai ʌgʌmai Matiia tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dai aduucai gamamagi: ―Aapi cʌliodami Diuusi gʌrooga, cʌʌ maatʌ vʌʌscatai iibʌadʌ. Gʌrtʌʌgidañi ismaacʌdʌ idi vʌgoocai ʌco vuusaitu aapi ");
INSERT INTO ntpNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sai bʌʌna sʌʌlicamigadʌ Uudasicaru dai gʌrsoicʌiña idi aa duiñdagiʌrʌ ismaacʌdʌ gʌrmaa aapi. Ʌgai ʌrDiuusi ootosadʌcatadai dai dagito gʌsʌʌlicamiga dai ii ami siaaco aʌcatadai aliʌ soimaasi iduucai ―asduucai gamamagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dai tʌcavi daitu ʌmo tumiñsi tai gamaitʌ Matiia. Dai otoma vʌʌna ʌbaivustaama dan ʌmoco ojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aidʌsi aayi ʌgʌʌ siaa duudagai Pentecostési tʌʌgiducʌdʌ mosʌmapʌcʌrʌ daraajatadai ʌvaavoitudadami vʌʌscatai ʌmapai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tai todian duucai gʌʌ caidatu tʌvaagiaiñdʌrʌ ʌpan caiti siʌʌscadʌ cavami ʌvʌʌrdagi dai vʌʌsiaʌcatai gigiduli ami quiiyʌrʌ siaaco daraajatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Amaasi gʌmaasitu ʌmo istumaasi taí maascami dai aipaco daama daraiva ismaacʌdʌ ami daraajatadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tai divia Diuusi Ibʌadʌ dai vʌʌscatai ʌvaavoitudadami ʌʌmadu daaca agai tai ʌgai gʌnaagacai ñiñio ʌma maa ñiooqui. Vʌʌscatai ñiñio ʌʌmo ñiooqui ismaacʌdʌ maimaatʌcatadai ismaacʌdʌ maa Diuusi Ibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aidʌ Jerusaleenʌrʌ oidacatadai judidíu vʌʌsi aipadʌrʌ dai maiʌmo ñiooqui ñioocaitadai dai aliʌ siaa duutudai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aidʌsi caʌ ʌgai isgʌʌ caidatu gʌnʌmpagi ami siaaco daraajatadai ʌvaavoitudadami dai maitʌʌ isducatai gʌntʌtʌʌgituagi caʌcatai isʌʌmadutai ñioocai ñiooquidʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dai vʌʌscatai vupuiirutuan tada dai aipaco gʌnaagidi: ―Goovai ismaacʌdʌ pomaa ñioocai ʌrGalileeʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Dai ducatai aatʌmʌ ʌʌmadutai caʌ ʌʌgi gʌrñiooqui? ");
INSERT INTO ntpNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tami daraaja oodami Partiaiñdʌrʌ, dai Meediaiñdʌrʌ, dai Elamaiñdʌrʌ, dai Mesapotaamiaiñdʌrʌ, dai Judeeaiñdʌrʌ, dai Capadusiaiñdʌrʌ, dai Poontoaiñdʌrʌ, dai Aasiaiñdʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","dai Filijiaiñdʌrʌ, dai Panfiiliaiñdʌrʌ, dai Ejiipituaiñdʌrʌ, dai ʌʌmapʌcʌrʌaiñdʌrʌ Apilica vaasoñiomaiñdʌrʌ Sireñi. Tami daraaja ʌʌmoco Romaiñdʌrʌ ʌʌpʌ dai ʌʌmoco ʌrjudidíu vaavoitudaitai vaavoidaragadʌ ʌjudidíu dai aa gia ʌrjudidíu dʌʌdʌdʌ cascʌdʌ ʌrjudidíu goovai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tami daraaja ʌʌpʌ oodami Cʌrʌtʌaiñdʌrʌ, dai Araaviaiñdʌrʌ dai vʌʌscatai aatʌmʌ caʌ isgʌrñiooquicʌdʌ aagai gocʌcʌʌli istumaasi gʌgʌrducami istumaasi ʌʌgi Diuusi ivueeyi ―ascaiti ʌjudidíu ismaacʌdʌ ami dada. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dai vupuiirutuan tada dai aipaco gʌntʌcacai daidʌ icaiti: ―¿Istuisi ʌpʌdui gomaasi? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dai aa mosparunai daidʌ icaiti: ―Aliʌ navaacoñi goovai cascʌdʌ pomaa ñioocai ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Amaasi guuquiva ʌbaivustaama dan gooca ojootosicami taidʌ ʌPiiduru gʌgʌrʌ ñioo daidʌ itʌtʌdai: ―Judeeʌrʌ oidacami ʌʌmadu vʌʌscatai ismaacʌdʌ Jerusaleenʌrʌ oidaga maatʌvurai aapimʌ idi dai cʌʌgavʌr caʌca ismaacʌdʌ gʌnaagida iñaagai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aatʌmʌ maitʌrnavaacoidadʌ mʌsducatai gʌntʌtʌʌgitoi aapimʌ. Tami oidacami mainavaacorʌi ʌʌqui quiaamoco tuustaamʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Idi ʌrʌgai ismaacʌdʌ aagidi Joeelicaru gʌrʌʌqui aaduñicaru. Ʌgai ʌrDiuusi ñiooquituldiadamigadʌcatadai dai pocaiti: ");
INSERT INTO ntpNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Pocaiti Diuusi: “Cayoga ugitʌcai oidigi divimu giñIbʌdaga dai ʌʌmadu daacamu vʌʌsi oodami aipaco oidacami. Vʌʌsi gʌnmaamara ñiooquimu aanʌ giñvʌʌtarʌ. Dai gʌnmaamara cʌcʌʌli tʌʌgimu mui naana maasi istumaasi mainʌidi aa oodami. Dai ñiooquida iñagai aanʌ ʌcʌcʌʌliocoidadʌ coosigadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Amaasi ootosamu aanʌ giñIbʌdaga vai ʌʌmadu daacana giñpipiooñiga. Siʌgai ñiooquimu aanʌ giñvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tʌcavi tʌvaagiana gʌntʌʌgidamu aanʌ mui naana maasi istumaasi. Dai oidigi daama gʌntʌʌgidamu aanʌ mui naana maasi ʌʌrai ʌʌmadu taí, ʌʌmadu gʌpi cuubusi dai poduucai maatʌmu aapimʌ iscaugitia agai oidigi. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tucaagamucamu gotasai. Dai masaadai moʌʌrai gʌduuñimu dai gooquiʌrʌ aimu istuigaco divia agai ʌtʌaanʌdami. Dai vʌʌscatai siaa duutuada agai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amaasi vʌʌscatai ismaacʌdʌ giñdaanʌdagi cʌʌgacʌrʌ vuvaidamu aanʌ”, ascaiti Diuusi. Ascaiti Joeelicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Caʌcavurai aapimʌ judidíu ismaacʌdʌ gʌnaagida iñagai aanʌ. Suusi ʌrNasareetʌrʌ oidacamicatadai dai ʌgai ʌrʌmo cʌʌli ismaacʌdʌ maa Diuusi gʌʌ guvucadagai saidʌ iduuna mui naana maasi gʌgʌrducami aapimʌ gʌnvuitapi dai idi maasicʌdʌ Diuusi gʌntʌʌgi isootoi ʌSuusi. Vʌʌsi imaasi cʌʌ maatʌ aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Vʌʌscʌrʌ aidʌmʌsi gʌntʌʌgi ʌSuusi maisatugai aapimʌ dai tʌʌgi ʌcʌcʌʌli ismaacʌdʌ maisiaa duutudai Diuusi sai curusiaba siisana dai poduucai gatʌjai aapimʌ muaaragai. Vʌʌsi imaasi camaatʌcatadai Diuusi. Ʌʌgi ʌgai capomaasi gʌtʌgito ʌʌqui abiaadʌrʌ sai poduucai ʌpʌduuna. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ʌgai vaa Diuusi ʌpamu duaacali ʌSuusi. Tomali ʌmo istumaasi maitistui issoobidagi ʌSuusi isduaacagi, tomali muuquigami. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dai aagai Davicaru ʌSuusi dai poduucai ooja: Vʌʌscʌrʌ nʌidi aanʌ ʌcʌliodami Diuusi aanʌ giñʌʌmadu daja giñsʌʌlisa padʌrʌ. Giñnuucada ʌgai vai tomali ʌmaadutai maisoimaasi giñvuiididi. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Cascʌdʌ aliʌ baigiñʌlidi aanʌ dai aagai ansai baigiñʌlidi. Cascʌdʌ maiduaadicui aanʌ istuma daivuñiagi giñtuucugacʌdʌ siʌʌscadʌ muuquia aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dʌmos aapi giñDiuusiga maiviaamu giñibʌdaga aa coidadʌ ibʌadʌ saagida. Dai maitidagito issiaa tuidiagi giñtuucuga. Aanʌ ʌrʌgai ismaacʌdʌ oigʌdai aapi. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Giñduaacaldamu aapi. Aanʌ giñʌʌmadu aimʌrai aapi cascʌdʌ aliʌ baigiñʌlidi aanʌ. Asduucai ooja Davicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Giñaaduñi cʌʌga maatʌ aapimʌ siʌʌqui muu gʌraduñi Davicaru dai quiaa maasi mʌsiaaco yaasa. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davicaru ʌrDiuusi ñiooquituldiadamigadʌcatadai dai cʌʌga maatʌcatadai isDiuusi aagidi vʌʌsi gʌibʌdacʌdʌ sai ʌmaadutai cajiudadʌ ʌrCristoca agai dai bʌjia agai Davicaru sʌʌlicamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Idi vaa cʌʌga maatʌcatadai Davicaru nʌijadacan caitiña ʌʌquioma abiaadʌrʌ cascʌdʌ aagaitadai ʌgai ʌSuusi duaacaradʌ daidʌ icaiti maiviimu Cristo Ibʌadʌ coidadʌ saagida tomali maisiaa tuidimu tuucugadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Diuusi duaacali ʌgai vaa Suusi dai vʌʌscatai aatʌmʌ ʌrnʌijadami vʌʌsi imaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Diuusi vaidacai ʌSuusi tʌvaagiamu sai sonuana daacana dai poduucai maa ʌmo gʌʌ sʌʌlicami. Dai sivi ootoi ʌSuusi Diuusi Ibʌadʌ, poduucai isducatai gʌnaagidi ʌSuusi oogadʌ. Vʌʌsi idi ismaacʌdʌ nʌidi aapimʌ dai caʌ Diuusi Ibʌadʌ idui. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davicaru maitʌrʌgai ismaacʌdʌ tʌsai tʌvaagiamu. Ʌʌgi Davicaru icaiti: Ʌcʌliodami Diuusi itʌtʌdai giñtʌaanʌdamiga: “Daacañi giñsʌʌlisa padʌrʌ ");
INSERT INTO ntpNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta siʌʌscadʌ cabaidui aanʌ vai camaitistuidiagi vaamioma gʌsasaayu”. Ascaiti Davicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Vʌʌsi judidíu sʌʌlicʌdʌ gʌaagai ismaatʌcamudai isʌgai vaa Suusi ismaacʌdʌ siisa aapimʌ curusiaba cadaí Diuusi ʌgai saidʌ ʌrCristocana ismaacʌdʌ vaamioma tʌaanʌda agai oidigi daama ―astʌtʌdai Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aidʌsi caʌ ʌgaa gomaasi aayi soiʌliaragai dai tʌcacai ʌgai ʌPiiduru ʌʌmadu ʌgaa ojootosicami: ―¿Tʌtumaa duuna? ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Amaasi ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Ʌma duucaiavʌr gʌntʌtʌgito dai camaisoimaasi ivuaada vai Diuusi gʌnoigʌldana vʌʌsi gʌnsoimaascamiga. Gʌnvapaconavurai aapimʌ vʌʌscatai Suusi sʌʌlicamigadʌcʌdʌ siDiuusi ootosamu gʌIbʌdaga vai gʌnʌʌmadu daacana. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Idi ñiooqui ʌraapimʌ gʌnvʌʌtarʌ ʌʌmadu gʌnmaamara dai ʌgai ismaacʌdʌ mʌʌcasi daraaja dai vʌʌscatai ismaacʌdʌ ʌcʌliodami gʌrDiuusiga vapaida ʌlidio ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Idi ñiooquicʌdʌ ʌʌmadu vaamioma aa ñiooquicʌdʌ ñioo ʌPiiduru dai cʌʌga maa ñiooqui dai potʌtʌdai: ―Cʌʌgacʌrʌavʌr vuvaaqui gʌʌgʌvituldaragadʌaiñdʌrʌ ʌoodami soimaasi ivuaadami ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Poduucai tudo vʌʌscatai ismaacʌdʌ ʌʌgi ñiooquidʌ gʌnvapacoi. Aidʌ tasʌrʌ urava parʌ vaica miil oodami ʌgaa ismaacʌdʌ vaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Dai vʌʌscatai apiavaavoitudai istumaasi mamaatʌtuldiña ʌojootosicami. Dai ʌmo tʌgitoidagai viaacana dai gamamadaiña gʌnʌʌmpaiditai siuu duucu gaugia agadagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Daidʌ ivuaadana ʌojootosicami mui naana maasi gʌgʌrducami vai vʌʌscatai duduaadicuiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Dai vʌʌscatai ismaacʌdʌ vaavoitudaitadai sʌʌlicʌdʌ cʌʌga gʌnuraavacatadai dai ʌmapai viaacatadai gʌnvustuidaga. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dai gaagaraiña gʌnvustuidaga dai ʌtumiñsi ʌrvʌʌscatai vʌʌtarʌcana. Isʌmaadutai vaamioma tʌgitocagi vaamioma maacaiña ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dai vʌʌs tasai gʌnʌmpaidiña ʌgʌʌ quiuupaigadʌrʌ judidíu. Dai ʌmapai gacuaadana quiiquiʌrʌ baigʌnʌliaracʌdʌ dai tomali ʌmoco maivaamioma gʌducʌdʌ gʌʌlidiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dai vʌʌscatai siaa duutudaiña Diuusi dai vʌʌsi oodami cʌʌgacʌrʌ nʌidiña dai vʌʌs tasai ʌmpaidimi Diuusi ismaacʌdʌ cacʌʌgacʌrʌ vuvaidimi ʌʌmadu ʌgaa ismaacʌdʌ cavaavoitudai. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ʌmo imidagai coi gʌʌsʌco tasai tʌʌtʌidimitadai Piiduru ʌʌmadu Vuaana ʌmapai ʌgʌʌ quiuupaigadʌrʌ judidíu. Caaayi siuu duucu gamamadaiña ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Vʌʌs tasai ami dadaʌjʌiña ʌmo cʌʌli. Ʌgai maitistutuidiña isaimʌrdagi poduucai vuusai ʌgai. Ʌgʌʌ quiuupaigadʌamu judidíu bʌʌ ajioopaiña aa, dai dadaasaiña quitaagiña cʌʌ tioodicʌrʌ tʌʌgiducana sai gataanʌiña tumiñsi oidicami ismaacʌdʌ vaapaquidagi ami. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aidʌsi tʌʌ ʌcʌʌli soimaascʌdʌ ʌPiiduru ʌʌmadu ʌVuaana aidʌsi vaapaquia agaitadai ʌgai ʌgʌʌ quiuupaigadʌrʌ judidíu taí ʌmo oidicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Amaasi vui nʌnʌaava ʌPiiduru ʌʌmadu ʌVuaana ʌcʌʌli taidʌ ʌPiidiru potʌtʌdai: ―Gʌrvuidʌrʌ iñʌnʌaava ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Amaasi vui nʌnʌaava ʌcʌʌli poʌliditai isoida agai istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dʌmos ʌPiiduru potʌtʌdai: ―Maitan viaa tumiñsi vʌʌscʌrʌ gʌoidamu aanʌ istuma viaa. Suusi Cristo ismaacʌdʌ Nasareetʌrʌ oidacatadai guvucadadʌcʌdʌ cʌquivañi dai aimʌrda ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amaasi bʌi ʌPiiduru ʌcoocoadʌ novidʌ sʌʌlisa padʌrʌ dai vañigi. Tai bovasdʌrʌ guupucatu ʌʌcasodʌ ʌʌmadu tʌtʌaanasigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Amaasi tʌca tual daa ʌgai dai cʌquiva. Dai gʌaagacai aimʌrai dai vaa ʌgaa ʌʌmadu ʌgʌʌ quiuupaigadʌrʌ judidíu. Dai tuali dadaimi. Dai aliʌ cʌʌga ñiooquimi Diuusi vui. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Dai canʌiditai vʌʌscatai iscaaimʌrai dai cʌʌga ñioocai Diuusi vui aliʌ duduaadimu, ");
INSERT INTO ntpNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dai camaitʌʌ isducatai gʌntʌtʌʌgituagi tomali istʌiyagi nʌiditai iscadueeyi ʌcoocoadʌ. Cʌʌga maatʌcatadai ʌgai isʌgai ʌrʌgai vaa ismaacʌdʌ dadaʌjʌiña daida taanʌiña oidicami ʌgʌʌ quiuupaigadʌrʌ judidíu quitaagiña tioodicʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Caduaadʌcai ʌcʌʌli ismaacʌdʌ maitistutuiditadai isaimʌrdagi mosʌʌmadu aimʌraiña ʌgai ʌPiiduru ʌʌmadu ʌVuaana. Dai vʌʌsi ʌoodami camaitʌʌ istumaasi gʌntʌtʌʌgituagi dai voopoi ami ʌgʌʌ quiuupaigadʌamu judidíu siaaco Solomoñi portaaligadʌ tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dai tʌʌgacai ʌPiiduru isgʌnʌmpagi vʌʌscatai potʌtʌdai: ―Aapimʌ judidíu, ¿tuimʌsi gʌrnʌnʌidi ducami isaatʌmʌ ʌʌgi duaaidamudai idi cʌʌli dai imitu gʌrguvucadagacʌdʌ siʌpʌ cʌʌ tuutiacatai? ");
INSERT INTO ntpNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Baiyoma Suusi guvucadadʌcʌdʌ atdueeyi idi cʌʌli. Diuusi maa gʌmara Suusi ʌdaasicami ismaacʌdʌ vaamioma viaa guvucadagai. Dai ʌgai vaa Diuusi ʌrDiuusigadʌcatadai ʌʌpʌ gʌraduñi Avraañicaru dai Isaacaru dai Jacocaru. Dai Suusi ʌrʌgai vaa ismaacʌdʌ tʌʌgi aapimʌ dudunucami. Dai aidʌsi dagitua agaitadai Pilaato ʌSuusi mosgajiaadʌrʌ vipieeyi aapimʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Maiaagidi aapimʌ isdagitomudai ʌgai ismaacʌdʌ cʌʌ tuiga dai maitʌrgʌpiʌr caatʌcami baiyoma aagidi aapimʌ isdagitua ʌgai ʌmo gamuaacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Poduucai muaa aapimʌ ismaacʌdʌ gamaacai ibʌdagai utudui. Taidʌ Diuusi duaacali ʌgai coidadʌ saagidaiñdʌrʌ, vʌʌsiaʌcatai idi aatʌmʌ daraaja nʌijadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ʌgai vaa Suusi guvucadadʌcʌdʌ bʌi guvucadagai idi cʌʌli ismaacʌdʌ nʌidi dai maatʌ aapimʌ. Vaavoitudai aatʌmʌ dai idi cʌʌli Suusi guvucadadʌrʌ cascʌdʌ cacʌʌga dueeyi goovai. Canʌidi aapimʌ iscadueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Giñaaduñi judidíu cʌʌga maatʌ aanʌ isaapimʌ ʌʌmadu gʌnbaitʌguucacamiga muaa ʌSuusi maicʌʌga maatʌcatai mʌstuma vueeyi. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Poduucai baidui Diuusi ismaacʌdʌ ʌʌquiacoga aagai ñiñiooquituldiadamigadʌ. Ʌgai vaa aagaitadai isaliʌ soimaa taata agaitadai ʌCristo. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Cascʌdʌ ʌma duucaiavʌr gʌntʌtʌʌgito aapimʌ dai aagoavʌr suuligi gosoimaa voiyaiñdʌrʌ. Vaavoitudavurai Diuusi vai ʌgai gʌnoigʌldana vʌʌsi gʌnsoimaascamiga amaasi ʌcʌliodami Diuusi baigʌnʌʌliatudamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dai gʌnootosdamu Diuusi Suusi ʌpamu. Ʌgai vaa ʌrCristo ismaacʌdʌ ʌʌquiacoga ʌco vuusaitu Diuusi aapimʌ gʌnvʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Vʌʌscʌrʌ tʌvaagiʌrʌ viimu Suusi Cristo asta siʌʌscadʌ baidui Diuusi vʌʌsiaʌcatai istumaasi isducatai aagaitadai ʌʌquiacoga ʌñiñiooquituldiadamigadʌ ismaacʌdʌ ʌʌgi ʌgai ʌco vuvaitu. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Poduucai tudu ʌʌquiacoga potʌtʌdai Moseesacaru gʌraaduñicaru: “Ootosamu Diuusi ʌmo ñiooquituldiadami aapimʌ gʌnvʌʌtarʌ vʌʌscatai aapimʌ gʌnaadunumʌ saagidaiñdʌrʌ poduucai isducatai giñootoi ʌgai aanʌ. Ʌʌgiadavurai vʌʌsiaʌcatai istumaasi ʌgai gʌnaagiadagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Vʌʌscatai ismaacʌdʌ maiʌʌgidi Diuusi ñiooquituldiadamigadʌ ugititudamu Diuusi dai ʌco vuvaidamu judidíu saagidaiñdʌrʌ”, astʌtʌdai Moseesacaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Poduucai tudu vʌʌsi Diuusi ñiñiooquituldiadamigadʌ Samueli baigovacoga aagai istumaasi daivuñia agaitadai sivi. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aapimʌ ʌrcajiudadʌ vʌʌsi Diuusi ñiñiooquituldiadamigadʌ. Dai vʌʌsi ʌñiooqui ismaacʌdʌ ootoi Diuusi gʌñiñiooquituldiadamigacʌdʌ ʌraapimʌ gʌnvʌʌtarʌ. Dai vʌʌsi istumaasi ismaacʌdʌ Diuusi baidui gʌnaaduñicaru ʌʌmadu ʌraapimʌ gʌnvʌʌtarʌ. Dai asta ismaacʌdʌ aagidi Diuusi gʌraduñi Avraañicaru aidʌsi potʌtʌdai: “Aanʌ baiʌʌliatudamu vʌʌsi oodami oidigi daama oidacami aapi gʌcajiudagacʌdʌ”. ");
INSERT INTO ntpNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aidʌsi duaacali Diuusi gʌmara ʌʌpʌga gʌnootosi aapimʌ sai baigʌnʌʌliatudana mʌsai aapimʌ camaisoimaasi ivuaadana ―astʌtʌdai Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Quiaa ñiooquiditadai ʌPiiduru ʌʌmadu ʌVuaana ʌoodami tai dada ʌpapaali judidíu ʌʌmadu ʌbaitʌcʌaacamigadʌ ʌgʌʌ quiuupiʌrʌ sandaaru ʌʌmadu ʌsaduseo. Ʌsaduseo ʌrʌgai ismaacʌdʌ maivaavoitudai duaacaragai. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dai aliʌ baacoi vʌʌscatai mamaatʌtulditai ʌPiiduru ʌʌmadu ʌVuaana ʌoodami isduaacaradʌcʌdʌ ʌSuusi camaatʌ vʌʌscatai isoidaga duaacaragai coidadʌ vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Amaasi vui ʌgai ʌPiiduru ʌʌmadu ʌVuaana dai casi ʌrurunococatadai dai camaiaʌcatadai uruñi isbai duñiagi dudunucamiʌrʌ cascʌdʌ cuu ʌgai asta siaadiqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Muidutai ʌgai ismaacʌdʌ gʌntʌgito caʌ ʌñiooqui vaavoitu. Vʌʌsi ismaacʌdʌ vaavoitu baitoma aayi taan miil, gocaaqui aayi goʌʌ cʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dai siaadiqui gʌnʌmpagi Jerusaleenʌrʌ vʌʌsi ʌdudunucamigadʌ ʌjudidíu ʌʌmadu ʌpipiscali ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dai ami daacatadai ʌʌpʌ Aanasi baitʌcʌaacamigadʌ papaali, judidíu ʌʌmadu Caifási, ʌʌmadu Vuaana, ʌʌmadu Alijandʌro, ʌʌmadu vʌʌsi ismaacʌdʌ ʌraaduñdʌ ʌbaitʌcʌaacamigadʌ papaali. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dai vaí ʌPiiduru ʌʌmadu ʌVuaana dai ʌraana tuutui dai tʌcacai: ―¿Tuma guvucadagaicʌdʌ dai voorʌ sʌʌlicamigadʌcʌdʌ ivueeyi aapimʌ gomaasi? ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Amaasi Diuusi Ibʌadʌ ʌʌmadu daacatadai ʌPiiduru taidʌ ʌPiiduru itʌtʌdai: ―Dudunucamigadʌ dai pipiscaligadʌ judidíu ");
INSERT INTO ntpNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","sivi casi gʌrtʌcacai aapimʌ isducatai cʌʌgacʌrʌ vuusai idi cʌʌli coocoadʌ dai isducatai dueeyi goovai. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aapimʌ gʌnvuitapi aagamu aatʌmʌ vai maatʌna vʌʌscatai Isireliʌrʌ oidacami. Idi cʌʌli vʌʌscatai aapimʌ gʌnvuitapi cʌʌca caduaadʌcatai Suusi Cristo guvucadadʌcʌdʌ. Ʌgai ʌrʌgai vaa ismaacʌdʌ Nasareetʌrʌ oidacatadai dai aapimʌ siisa curusiaba tai Diuusi duaacali coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ɅSuusi ʌpan ducami ʌodai ismaacʌdʌ siooma gʌaagai ʌmo vaaqui vʌʌtarʌ dai aapimʌ ʌpan ducami ʌbaabaquitadami ismaacʌdʌ gajiaadʌrʌ viaa ʌodai. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Diuusi ootoi ʌSuusi Cristo oidi daama sai ʌʌgi ʌgai viaacana guvucadagai iscʌʌgacʌrʌ vuviaadagi vʌʌsi oodami oidi daama oidacami. Maitiipu ʌmai vʌʌsi oidigʌrʌ ismaacʌdʌ viaa guvucadagai iscʌʌgacʌrʌ vuviaadagi oodami ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amaasi tʌʌ ʌdudunucami ʌPiiduru ʌʌmadu ʌVuaana dai maatʌ tʌʌ isʌcʌcʌʌli maitʌvʌpi daraiva oojiʌrʌ dai maitʌrmamaatʌtuldiadami dai vʌʌscʌrʌ maiduduaadimu ñiñio. Daidʌ ʌdudunucami maitʌʌ istumaasi gʌntʌtʌgituagi. Dai amaasi maatʌ tʌʌ sidi ʌrʌgai ismaacʌdʌ ʌʌmadu ajioopaiña ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dai ʌcʌʌli ismaacʌdʌ cadueeitadai ami ʌʌmadu cʌaacatadai ʌPiiduru ʌʌmadu ʌVuaana cascʌdʌ maitistutuiditadai ʌdudunucami isvuidʌrʌ ñioocada tomali ʌmo ñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Daidʌ ʌdudunucami ʌʌgi gaaataga ʌliditadai cascʌdʌ ootoi ʌojootosicami sai vuvaacʌna ʌmpaidaragiaiñdʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","daidʌ icaiti: ―¿Tʌduuna gocʌcʌʌli? Cʌʌ maatʌ vʌʌscatai Jerusaleenʌrʌ oidacami sidʌ idui gocʌcʌʌli idi istumaasi gʌducami dai maitistutuidi aatʌmʌ ispotʌiyagi ismaitʌrvaavoi. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ʌbʌʌcatamu aatʌmʌ vai sivi abiaadʌrʌ camaiaagidiña goovai tomali ʌmaadutai istumaasi ivuaadana ʌSuusi dai istumaasi gamamaatʌtuldiña ʌgai vai camaivaamioma aipaco imʌna idi maasi ―ascaiti ʌdudunucami. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Amaasi vaí ʌdudunucami ʌPiiduru ʌʌmadu ʌVuaana dai aagidi sai camaiaagaiña istumaasi ivuaadana ʌSuusi dai mamaatʌtuldiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dʌmos aa noragi ʌPiiduru ʌʌmadu ʌVuaana daidʌ itʌtʌdai: ―¿Tuma tʌtʌgitoi aapimʌ baisi ʌrcʌʌgai Diuusi vʌʌtarʌ isgʌnʌʌgida aatʌmʌ aapimʌ dai maiʌʌgidagi Diuusi? ");
INSERT INTO ntpNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mosmaibaiga ismaiaaga aatʌmʌ tʌstuma nʌidi aatʌmʌ dai caʌ ―astʌtʌdai ʌPiiduru ʌʌmadu ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Baitoma vʌʌsi ʌoodami cʌʌga ñiñio Diuusi vʌʌtarʌ duaadʌcai ʌcoocoadʌ cascʌdʌ ʌdudunucami aliʌ ʌʌbʌiditadai ʌoodami cascʌdʌ maitʌpʌnʌʌlidi isgʌviaarsagi ʌPiiduru ʌʌmadu ʌVuaana dai mosʌbʌqui dai dagito sai iimʌna. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ʌcʌʌli ismaacʌdʌ cadueeyi Diuusi guvucadadʌcʌdʌ viaacatadai vaamioma isgoo coobai uumigi. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Amaasi cadagitocai ʌgai ʌPiiduru ʌʌmadu ʌVuaana ʌgai mosiji mʌʌca siaaco daraajatadai ʌaaduñdʌ dai vʌʌsi aagidi istʌtʌdai ʌbaitʌguucacamigadʌ papaali ʌʌmadu judidíu pipiscali. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aidʌsi caʌ ʌgai imaasi vʌʌscatai ʌmapai daanʌi Diuusi daidʌ icaiti: ―Gʌrcʌliodamiga Diuusi, aapiapʌ ʌrDiuusi ismaacʌdʌ idui tʌvaagi dai dʌvʌʌrai dai gʌʌ suudagi dai vʌʌsi istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gʌpiooñiga Davicaru aagai istumaasi aagidi aapi sai aagana dai pocaiti: ¿Tuisidʌ bacocoi vʌʌsi oodami naana maasi ñioocadami Diuusi vui? ¿Dai tuisi tʌtʌgitoi ʌoodami mui naana maasi maicʌcʌʌgaducami? ");
INSERT INTO ntpNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ʌraraí oidigi daama oidacami ʌʌmadu aa baitʌguucacami gʌnʌmpagi dai ñiooquiada agai Diuusi ʌʌmadu Cristogadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sʌʌlicʌdʌ ʌrvaavoi istanai Jerusaleenʌrʌ gʌnʌmpagi Eroodʌsi ʌʌmadu Ponsio Pilaato ʌʌmadu judidíu dai aa ismaacʌdʌ maitʌrjudidíu dai vuidʌrʌ suuli gʌmara Suusi ismaacʌdʌ maisoimaasi idui dai ʌco vuusaitu aapi gʌrDiuusiga. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gomaasicʌdʌ idui ʌgai vʌʌsiaʌcatai ismaacʌdʌ ipʌli aapi gʌrDiuusiga siʌpʌduñiagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sivi gʌrgʌviarsa agaitadai ʌdudunucami cascʌdʌ gʌrmaacañi aatʌmʌ gʌpipiooñiga guvucadagai tʌtai ñioocadagi gʌñiooqui maisiu duaadimudacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dai duduaaididagi ʌcoococoidadʌ gʌguvucadagacʌdʌ daidʌ ivuaadagi istumaasi gʌgʌrducami gʌmara Suusi guvucadadʌcʌdʌ. Ʌgai vaa Suusi ʌrgʌʌco vuusaida aapi ―ascaiti ʌaaduñdʌ vaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aidʌsi canaato mamagi ʌgai gigivuli ʌquii siaaco daraajatadai ʌgai tai divia Diuusi Ibʌadʌ vʌʌscatai ʌʌmadu dai poduucai maiduduaadicuitai aagaiña ʌgai Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Dai camuiducatadai vaavoitudadami dai vʌʌscatai viaacatadai ʌmo tʌgitoidagai. Dai vʌʌscatai ʌmapai viaacatadai gʌnvustuidaga cascʌdʌ tomali ʌmaadutai maiaagaiña siʌgai ʌrtuidadʌ ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Vʌʌscatai ʌojootosicami apiaaagaiña siooma guvucadagaicʌdʌ Suusi duaacaragadʌ vai Diuusi cʌʌgacʌrʌ nʌidiña vʌʌscatai. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Vʌʌscatai ismaacʌdʌ viaacatadai dʌdʌʌvʌrai isbaabaqui ʌʌpʌ gaagaraiña ʌgai dai vuaapaiña ʌtumiñsi. Dai maacaiña ʌgai ʌojootosicami ʌtumiñsi. Ʌtumiñsi ʌrvʌʌscatai vʌʌtarʌcana. Isʌmaadutai vaamioma tʌgitocagi vaamioma maacaiña ʌgai cascʌdʌ vʌʌscatai viaacana istumaasi tʌgito. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Dai ami ʌgai ʌʌmadu daacatadai ʌmo cʌʌli Levícaru cajiudadʌ ʌgai Osee tʌʌgiducatadai. Ʌgai ʌrSipiliʌrʌ vuusaicami. Taidʌ ʌojootosicami Bernabé tʌʌtʌi ismaacʌdʌ itʌiya ʌlidi ʌmo baiʌliatudadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ʌgai gagaara ʌmo dʌvʌʌrai ismaacʌdʌ viaacatadai ʌgai dai vuaapi ʌtumiñsi ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dai ami daacatadai ʌʌpʌ ʌmai cʌʌli Ananiiasi tʌʌgiducami dai Safira tʌʌgiducatadai ooñigadʌ. Dai vʌgoocatai viaacatadai ʌgai ʌmo dʌvʌʌrai dai gagaara. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ʌcʌʌli aa maa ʌtumiñsi ʌojootosicami ducami iscavʌʌsi tʌʌgidamudai dai viidadʌ viaa ʌʌgi gʌvʌʌtarʌ. Dai ʌooñigadʌ maatʌcatadai ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Amaasi itʌi ʌPiiduru: ―¿Ananiiasi tuipʌsi dagito isvaquiagi ʌDiaavora gʌibʌdagʌrʌ dai gʌyaatagitu Diuusi Ibʌadʌ vui? Aapi aa viaa tumiñsi ʌʌgi gʌvʌʌtarʌ mʌsmaacʌdʌ gʌaa namʌqui gʌdʌvʌʌragacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Maitisi ʌrvaavoi isaapi ʌrgʌtuidacatadai ʌdʌvʌʌrai? Dai aidʌpʌsi gagaara ʌdʌvʌʌrai ¿maitisi ʌrvaavoi isaapi ʌrgʌtuidacatadai ʌtumiñsi? ¿Tuipʌsi podui? Yaatagi aapi Diuusi maisiu oodami ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Moscaʌ ʌAnaniiasi gomaasi dai muucucatai gʌi. Dai vʌʌscatai ismaacʌdʌ maí gomaasi sʌʌlicʌdʌ duduaadimu. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Amaasi dada ʌʌmoco gʌgʌʌli dai cʌʌga biisa ʌmuuquiadʌ dai bʌʌcai dai yaasa. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vaica ooracʌdʌ vaa Ananiiasi ooñigadʌ maimaatʌcatai ʌgai istumaasi ʌpʌdui cunaadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Taidʌ ʌPiiduru itʌtʌdai: ―Giñaagidañi, ¿ʌcaaquicʌdʌ mʌsgagaara ʌdʌvʌʌrai? ―astʌtʌdai ʌPiiduru. ―Ʌjʌ, ʌcaaquicʌdʌ ―astʌtʌdai ʌooqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Amaasi ʌPiiduru itʌtʌdai: ―¿Tuimʌsi pomaasi gʌntʌtʌgito aapimʌ isyaatagidagi Diuusi Ibʌadʌ? Quiidigaiñdʌrʌ iimʌi ismaacʌdʌ bʌʌcai dai yaasa gʌcuna. Dai sivi aapi gʌbʌʌquia agai ʌʌpʌ ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tai ʌgai otoma muu dai ʌʌcasodʌ abaana gʌi ʌgai ʌPiiduru. Amaasi vaapa ʌgʌgʌʌli dai tʌʌ ʌooqui muuquiadʌ dai vuusaitu dai mʌʌ yaasa cunadʌ abaana. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tai aliʌ duduaadimu ʌvaavoitudadami ʌʌmadu vʌʌscatai ismaacʌdʌ maí gomaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mui istumaasi gʌgʌrducami ivuaadana ʌojootosicami ʌoodami saagida dai vʌʌscatai gʌnʌmpagi ami ʌgʌʌ quiuupiʌrʌ siaaco Salomoñi portaaligadʌ tʌʌgidu. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tomasi tomali ʌmaadutai maitipʌliditadai isgʌnʌmpaidagi ʌvaavoitudadami ʌʌmadu vʌʌscʌrʌ cʌʌga ñioocaitadai ʌgai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Muidutai cʌcʌʌli ʌʌmadu ooqui vaavoitu isSuusi Cristo ʌrcʌʌgacʌrʌ vuviaadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Amaasi vuvaitu ʌoodami coococoidadʌ caayana dai vopoicariʌrʌ tuaa dai vapaacosiʌrʌ sai siuu duucu daivuñiagi ʌPiiduru sai tomasi mosʌcaasi ʌʌcagidʌ aʌna tomasi ʌmaadutai daama. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vʌʌsi miimianai aali quiiquiaiñdʌrʌ daivimi muidutai Jerusaleenʌrʌ vuucati coococoidadʌ ʌʌmadu aa ismaacʌdʌ aliʌ soimaa taatamituldi ʌDiaavora tʌtʌaañicarudʌ tai vʌʌscatai dudueeyi Diuusi guvucadadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Amaasi ʌbaitʌcʌaacamigadʌ papaali judidíu ʌʌmadu vʌʌsi ʌsaduseo ismaacʌdʌ uraavacatadai ʌbaitʌcʌaacamigadʌ papaali vui baacoi ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dai vui ʌgai dai maamaisa. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dʌmos tucarʌ divia ʌmo Diuusi tʌaañicarudʌ dai cuucupioco cuucuparagadʌ ʌmaisacarui dai vuvaitu ʌojootosicami daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Iimivurai dai ʌgʌʌ quiuupaigadʌrʌ judidíu guuquiva dai ami aagida ʌoodami isducatai istutuidi ʌgai isoidacagi vʌʌscʌrʌ Diuusi ʌʌmadu ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Amaasi caʌcai ʌojootosicami imaasi, siaadiqui ʌʌqui vaapa ʌgʌʌ quiuupaigadʌrʌ judidíu dai aagidi ʌoodami Diuusi ñiooquidʌ. Vaidʌ ʌbaitʌcʌaacamigadʌ papaali ʌʌmadu ismaacʌdʌ uraavacatadai poʌliditadai isquiaa maisacariʌrʌ daraajatadai ʌojootosicami cascʌdʌ ʌmpagi ʌgai ʌvaamioma tʌtʌaanʌdami. Ʌgai ʌrpipiscali judidíu. Dai gooquiʌrʌ ootoi sandaaru sai vuaapana maisacaruiñdʌrʌ ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aidʌsi aayi ʌsandaaru maisacariʌrʌ maitʌʌ ʌojootosicami, ");
INSERT INTO ntpNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","dai ʌpamu aa suuli dai mʌʌ potʌtʌdai: ―Cʌʌga cuucupi vʌʌsi cuucuparagadʌ ʌmaisacarui dai vuidʌrʌ guuca ʌsandaaru dai nuucada. Amaasi cupioco ʌgai tʌtai tomali ʌmoco maitʌʌ tuucavi ―astʌtʌdai ʌsandaaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Amaasi caʌcai imaasi ʌbaitʌcʌaacamigadʌ ʌgʌʌ quiuupiʌrʌ sandaaru ʌʌmadu ʌbaitʌcʌaacamigadʌ papaali judidíu ʌʌmadu aa papaali tʌtʌaanʌdami aipaco gʌntʌcacai daidʌ icaiti: ―¿Istumaasi daivuñia agai vʌʌsi gomaasicʌdʌ? ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tai amaasi divia ʌmo cʌʌli dai potʌtʌdai: ―Ʌcʌcʌʌli ismaacʌdʌ maamaisa aapimʌ ʌgʌʌ quiuupaigadʌrʌ judidíu guucacatai mamaatʌtuldi ʌoodami ―astʌtʌdai ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Amaasi ii ʌbaitʌcʌaacamigadʌ ʌgʌʌ quiuupiʌrʌ sandaaru ʌʌmadu sandaaru dai vuaa. Dʌmos aliʌ ʌʌbʌiditadai ʌsandaaru ʌoodami ismaicarsagi ʌgai cascʌdʌ maisoi vuimi ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Amaasi vuaa dai vuitapi tuutui ʌvaamioma tʌtʌaanʌdami taidʌ ʌbaitʌcʌaacamigadʌ papaali judidíu potʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Sʌʌlicʌdʌ gʌndaí aatʌmʌ mʌsai camaitaaagidiña Suusi Cristo mamaatʌtuldaragadʌ. ¿Mostuma dui aapimʌ? Camaatʌtuli aapimʌ vʌʌsi Jerusaleenʌrʌ oidacami gʌnmamaatʌtuldaraga. Dai aatʌmʌ gʌpiʌrʌ gʌrsusuuligai gʌmuaatudacai ʌcʌʌli ismaacʌdʌ Suusi aagai aapimʌ ―astʌtʌdai ʌbaitʌcʌaacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Amaasi ʌPiiduru ʌʌmadu aa ojootosicami ismaacʌdʌ oi ʌgʌʌ quiuupiaiñdʌrʌ ñiñio daidʌ itʌtʌdai: ―Aliʌsi gʌaagai isʌʌgida aatʌmʌ Diuusi ʌʌpʌga sioodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aatʌmʌ quiaa vaavoitudai gʌraaduñicaru Diuusigadʌ. Ʌgai ʌpamu duaacali ʌSuusi. ɅSuusi ʌrʌgai ismaacʌdʌ gatʌjai aapimʌ curusiaba siisaragai dai muaaragai. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tai tʌvaagiamu vañigi Diuusi ʌSuusi dai sʌʌlisa padʌrʌ daí saidʌ ʌrtʌaanʌdamicana daidʌ ʌrcʌʌgacʌrʌ vuviadamicana vaidʌ istuidʌna aatʌmʌ judidíu isʌma duucai gʌrtʌtʌgituagi dai camaisoimaasi ivuaadagi dai poduucai gʌroigʌldamu Diuusi gʌrsoimaascamiga. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dai vʌʌsi imaasi ʌrnʌijadami aatʌmʌ ʌʌmadu Diuusi Ibʌadʌ ismaacʌdʌ ootoi Diuusi sai vʌʌscatai ʌʌmadu daacana ismaacʌdʌ ʌʌgiditai caʌ ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amaasi caʌcai ʌgaa gomaasi aliʌ baacoi dai cooda ʌliditadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amaasi cʌquiva ʌmo sonʌrʌ cʌaacami Gamalieli tʌʌgiducami. Ʌgai ʌrʌmo fariseo daidʌ ʌrmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Dai vʌʌsi ʌoodami aliʌ siaa duutudaiña. Dai ʌgai gatʌjai mʌsai vuvaidana laachi ʌojootosicami. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dai otoma potʌtʌdai ʌgai ʌgaa tʌtʌaanʌdami: ―Giñaaduñi, aatʌmʌ ʌrjudidíu, gʌntʌgitovʌr nʌida mʌsduñiagi gocʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gʌntʌgitovurai aapimʌ catʌvʌpi ʌpʌdui isoidacatadai ʌmo cʌʌli Teudasi tʌʌgiducami. Dai pocaititadai saidʌ ʌrʌmo cʌʌli gʌʌ guvucadagai viaacami tai oí maaco siento cʌcʌʌli. Mʌtai muaa. Tai vʌʌscatai ismaacʌdʌ oidatucuitadai vʌʌsi aipaco iji. Dai vʌʌsi ugidagai. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Dai gooquiʌrʌ aidʌsi gatʌjai ʌgʌʌ tʌaanʌdami ʌcaldaragai oodami oidacatadai ʌmai cʌʌli Uudasi tʌʌgiducami ʌgai ʌrGalileeʌrʌ oidacamicatadai. Tai muidutai oí. Mʌtai muaa ʌʌpʌ. Dai vʌʌscatai ismaacʌdʌ oidatucuitadai aipaco iji. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Cascʌdʌ aanʌ angʌnaagidi mʌsai dagitona idi cʌcʌʌli. Maitavʌr oiñiada. Siʌduñiada gomaasi ʌrʌmo istumaasi ismaacʌdʌ ivueeyi oodami vʌʌsi ugitimu goovai. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Siʌduñiaada gomaasi ʌrʌmo istumaasi ismaacʌdʌ ivueeyi Diuusi siaadʌrʌ istuidʌcai ugititudana aapimʌ. Gʌntʌgitovʌr nʌida maisiu soimaasi ivuaada Diuusi vui ―ascaiti Gamalieli. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tai vʌʌscatai bai aa isducatai aagidi ʌGamalieli. Amaasi vaí ʌgai ʌojootosicami. Dai gʌviaacarai sai camaivaamioma ñioocaiña Suusi vʌʌtarʌ. Dai gooquiʌrʌ dagito sai iimʌna. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ʌojootosicami vuvaacʌcai vuitapiaiñdʌrʌ ʌvaamioma tʌtʌaanʌdami baigʌnʌliatugai dagitocai Diuusi issoimaa taatagi ʌgai gaaagiditai ʌSuusi mamaatʌtuldaragadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Dai vʌʌs tasai gamamaatʌtuldiña ʌgʌʌ quiuupaigadʌrʌ judidíu dai quiiquiʌrʌ dai gaaagidiña isSuusi Cristo ʌrʌgai ismaacʌdʌ Diuusi ʌco vuusaitu saidʌ ʌrʌcʌʌgacʌrʌ vuviadamicana. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Amaasi tuigaco vaamioma muidaimi ʌvaavoitudadami dai ʌgai ismaacʌdʌ ñioocaitadai giliego ñiooquidʌ aagidi ʌojootosicami sai ʌgai ismaacʌdʌ ñioocaitadai judidíu ñiooquidʌ maicʌʌga oidi cuaadagai ʌvipiuudu giliego gataacogiditai cuaadagai vʌʌs tasai. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Taidʌ ʌbaivustaama dan gooca ojootosicami aagidi ʌvaavoitudadami sai gʌnʌmpaidana dai potʌtʌdai: ―Maitʌaagai isdagitocai gaaagiada aatʌmʌ Diuusi ñiooquidʌ, cascʌdʌ maitistutuidi aatʌmʌ isgʌntaacogiadagi cuaadagai. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Cascʌdʌ gʌraaduñi, gaagavurai aapimʌ cuvaracami cʌcʌʌli gʌnsaagidaiñdʌrʌ ismaacʌdʌ sastuduga dai ʌʌgiadagi Diuusi Ibʌadʌ dai vʌʌscatai siaa duutuadagi dai nuucatulda idi aa duiñdagai. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aatʌmʌ apiagamamadada ragai dai apiagamamaatʌtuldiada ragai Diuusi ñiooquidʌ ―astʌtʌdai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tai vʌʌscatai bai aa dai nʌidacai ʌco vuusaitu Tiivañi ʌgai aliʌ cʌʌga vaavoitudai dai ʌʌgidi Diuusi Ibʌadʌ ʌʌmadu Piili, ʌʌmadu Porocoro, ʌʌmadu Nicanoro, ʌʌmadu Tiimoñi, ʌʌmadu Parameenasi, ʌʌmadu Micuraasi ʌmo cʌʌli Antioquiiʌrʌ oidacami ismaacʌdʌ ʌʌquioma vaavoitudaiña judidíu vaavoidaragadʌ dai sivi cavaavoitudai Suusi Cristo. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mʌtai vʌʌscatai vaidacai siaaco daraajatadai ʌojootosicami tai ʌgai gamamaagi dai daama darai gʌnnoonovi. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Dai vʌʌsi aipaco ii Diuusi ñiooquidʌ. Jerusaleenʌrʌ vaamioma muidaimi ʌvaavoitudadami dai muidutai ʌpapaali judidíu vaavoitu ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tiivañi ʌrʌmo cʌʌli ismaacʌdʌ Diuusi cʌʌgacʌrʌ nʌiditadai. Dai ʌgai viaacatadai guvucadadʌ Diuusi Ibʌadʌ. Cascʌdʌ ivuaadana ʌgai mui naana maasi gʌgʌrducami ʌoodami saagida. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amaasi dada ʌʌmoco cʌcʌʌli ʌmo judidíu quiuupaigadʌaiñdʌrʌ. Ʌquiuupai ʌrcʌcʌʌli vʌʌtarʌcatadai ismaacʌdʌ ʌʌquioma aa oodami gʌnsosoiga duucai viaacana dai sivi camosajioopaitadai ʌgai, dai aa Sireñiaiñdʌrʌ, dai Alijandʌriaiñdʌrʌ dai Silisiaiñdʌrʌ, dai Aasiaiñdʌrʌ dai aliʌ ñiñio ʌTiivañi vui. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tiivañi ñioocaitadai maatʌdagaicʌdʌ ismaacʌdʌ maa Diuusi Ibʌadʌ, cascʌdʌ camaitistutuiditadai ʌgaa isvaamioma vuidʌrʌ suuligiagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Amaasi ʌgaa aa namʌqui aa sai potʌʌna sai caʌ ʌgai isTiivañi soimaa ñioocai Moseesacaru mamaatʌtuldaragadʌ vui dai Diuusi vui. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dai poduucai sisiolitu ʌgai ʌoodami ʌʌmadu ʌpipiscali, ʌʌmadu ʌmamaatʌtuldiadami Diuusi sʌʌlicamigadʌ. Dai vʌʌscatai vuidʌrʌ suuli ʌTiivañi. Dai bʌi. Dai bʌʌcai ʌvaamioma tʌtʌaanʌdamigadʌ ʌjudidíu vuidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Amaasi ʌʌpʌpʌ gaa ʌgai aa yaatavogami saidʌ itʌʌna: ―Idi cʌʌli vʌʌscʌrʌ vui ñioocaiña ʌgʌʌ quiuupai siaaco siaa duutudai aatʌmʌ Diuusi. Dai vʌʌscʌrʌ vuidʌrʌ caatʌcana Moseesacaru sʌʌlicamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Caʌatʌta aatʌmʌ iscaiti Tiivañi sai ʌSuusi ismaacʌdʌ Nasareetʌrʌ oidacatadai daituda agaitadai ʌgʌʌ quiuupai. Dai gʌrmaatʌtulda ʌlidi ʌmamaasi vaavoidaragai ismaacʌdʌ maiʌpa maasi ismaacʌdʌ gʌrvii Moseesacaru ―ascaiti ʌyaatavogami. ");
INSERT INTO ntpNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Amaasi ʌtʌtʌaanʌdami ʌʌmadu vʌʌscatai ismaacʌdʌ ami daraajatadai tʌʌgacai ʌTiivañi gʌntʌgito tʌʌ isʌpa maasi vuivasadʌ ʌmo Diuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Amaasi ʌbaitʌcʌaacamigadʌ papaali judidíu itʌtʌdai ʌTiivañi: ―¿Baisi ʌrvaavoi vʌʌsiʌcatai imaasi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Cʌʌga baigiñʌliaracʌdʌ gʌnnʌidi aanʌ aapimʌ giñaaduñi ʌʌmadu tʌtʌaanʌdami. Giñcaʌcavurai. Diuusi gʌrooga ʌrʌgai ismaacʌdʌ vaamioma viaa guvucadagai istomali ʌmo ʌmai. Dai gʌmaasitu gʌraduñi Avraañicaru vuitapi aidʌsi quiaa oidacatadai ʌgai Mesopotaamiʌrʌ aidʌsi maiquiaa ii ʌgai Araanamu dai mʌʌca oidaca agai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dai potʌtʌdai: “Dagitoñi gʌdʌvʌʌraga ʌʌmadu vʌʌsi gʌaaduñi dai imi nai aanʌ gʌtʌʌgidana oidigi pʌsiaaco oidacagi”, astʌtʌdai Diuusi ʌAvraañicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Taidʌ ʌAvraañi vuusaidʌ Calideeaiñdʌrʌ dai ii Araanamu dai ami oidaca agai. Tai gooquiʌrʌ muuidʌ oogadʌ. Tai vuaa Diuusi ʌAvraañi tami idi dʌvʌʌriʌrʌ siaaco oidaga aapimʌ sivi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dai maioi tomalaachi dʌvʌʌrai tami tomali siaaco cʌisa ʌgai. Dai vʌʌscʌrʌ caaagiditadai Diuusi isoida agai. Sai siʌʌscadʌ muquiaa ʌgai saidʌ ʌrcajiudadʌ vʌʌtarʌca agai. Aidʌ ʌAvraañi maiquiaa maamaracatadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dai aagidi ʌʌpʌ Diuusi ʌAvraañi sai cajiudadʌ oidaca agai mʌʌcasdʌrʌ oidacami duucai gadʌvʌʌragana dai sai soiduucai oidaca agai dai mʌsai soiduucai nʌijada agai ʌgai maaco siento uumigi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dai potʌtʌdai Diuusi ʌʌpʌ: “Soimaa taatatuldamu aanʌ ʌgai ismaacʌdʌ tʌaañia agai aa duiñdagai gʌnsosoiga duucai dai gooquiʌrʌ vuvaaquimu gʌcajiudaga abiaadʌrʌ dai giñsiaa duutuadamu ʌgai idi dʌvʌʌriʌrʌ”, astʌtʌdai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Diuusi baidui ʌmo ñiooqui Avraañicaru ʌʌmadu. Dai tʌjai sai iquiitʌna gʌtuucuga dai poduucai tʌgitocana ismaacʌdʌ aagidi Diuusi. Cascʌdʌ aidʌsi vuusai Isaacaru Avraañicaru maradʌ bo mamacova tasaicʌdʌ poduucai iquiitʌ Avraañicaru Isaa ʌʌpʌ, dai poduucai idui ʌʌpʌ Isaacaru gʌmara Jacocaru dai Jacocaru podui ʌʌpʌ ʌbaivustaama dan gooca gʌmaamara ismaacʌdʌaiñdʌrʌ vuvaaja vʌʌsi judidíu. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Gʌraduñi Jacocaru maamaradʌ aliʌ cʌʌdai gʌnsuculi Osee cascʌdʌ gagaali ʌgai ʌOsee aa cʌcʌʌli sibʌaadʌrʌ oidacami tai ʌgai bʌʌcai ʌOsee Ejiipitu dʌvʌʌriamu dai gagaali Potifara. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dai ʌgai aliʌ soimaa taatamituldiña ʌOsee dai maisa. Dai vʌʌscʌrʌ Diuusi ʌʌmadu daacatadai ʌOsee dai cʌʌgacʌrʌ vuusaitu maisacaruaiñdʌrʌ, dai maa saituducami tʌgitoidagai. Paraoñi cʌʌgacʌrʌ nʌiditadai ʌOsee, Diuusi poduucai ipʌli cascʌdʌ. Paraoñi ʌrraí Ejiipitʌrʌ dai daí ʌgai ʌOsee ali mooyi sai soiña tʌaanʌiña ami dʌvʌʌriʌrʌ dai Paraoñi quiidiʌrʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Amaasi divia gʌʌ biuugigai tai aliʌ soimaa taata Ejiipitʌrʌ oidacami ʌʌmadu Canaanʌrʌ oidacami. Dai gʌraaduñicaru ʌʌqui oidacami ismaacʌdʌ Canaanʌrʌ oidacatadai camaitʌtʌgaitadai istumaa ugiagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aidʌsi maí Jacocaru isoidacatadai tʌligi Ejiipitʌrʌ gaamucu ootoi gʌmaamara. Ʌgai ʌrgʌrʌʌqui aaduñicaru. Dai ʌgai tomali ʌmo imidagai maiquiaa ajioopaiña Ejiipituamu. Dai aidʌsi tʌʌ ʌgai ʌOsee Ejiipitʌrʌ maimaí sidʌ ʌrsuculidʌcatadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dai gooquiʌrʌ ʌpaamu iji ʌgai taida aagidi ʌOsee sioorʌ ʌgai. Dai poduucai maí ʌParaoñi istuma oodamicatadai ʌOsee. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Amaasi ʌOsee ootosi ñiooqui gʌooga Jaco sai dividana vʌʌsi maamaradʌ ʌʌmadu, vʌʌsicʌdʌ ʌrvai coobai dan baivustaama dan taamacatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Poduucai ii Jaco Ejiipitʌrʌ oidatu. Dai gooquiʌrʌ movaasi muu. Dai movaasi coi ʌʌpʌ aa gʌraaduñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tai gooquiʌrʌ ʌcajiudadʌ vuucai gʌnaaduñicaru oodʌ Siqueemamu dai yaasa ʌtʌjoovai ismaacʌdʌ savʌʌli ʌAvraañicaru ʌAmori maamaradʌ Siqueemʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Aidʌ tuigaco cayooga aayitadai istumaasi ismaacʌdʌ bai duitadai Diuusi Avraañicaru ʌʌmadu vʌʌsi gʌtʌgitoidacʌdʌ. Dai ʌjudidíu ismaacʌdʌ Ejiipitʌrʌ oidacatadai aliʌ muidaimi dai sʌʌlicʌdʌ muida. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Aidʌ utuudama daiva Ejiipitʌrʌ ʌmo baitʌcʌaacami dai ʌgai maimaatʌcatadai ʌOsee. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Dai idi baitʌcʌaacami naana duucai vupuiirumada ʌliditadai gʌraaduñicaru dai aliʌ soimaasi ivuiididitadai dai dadaagitoldi cʌcʌʌli maamaradʌ dʌʌdʌdʌaiñdʌrʌ utu vuvaaquiadʌ sai coona. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aidʌsi gatʌaanʌitadai ʌbaitʌcʌaacami maicʌʌ tuigacʌdʌ aidʌ vuusai Moseesa. Aliducatai abiaadʌrʌ baigʌʌldacai tʌʌ Diuusi. Taidʌ ʌdʌʌdʌdʌ nuucagi gʌnquiiyʌrʌ vaica masaadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aidʌsi caviaacatadai ʌdʌʌdʌdʌ isvuusaidagi ʌMoseesa quiidiaiñdʌrʌ camaitistutuiditai isʌstuagi taidʌ ʌooqui Paraoñi maradʌ bʌi dai gʌʌli gʌmara duucai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Cascʌdʌ mamaatʌtuldiña Ejiipitʌrʌ mamaatʌtuldiadami ʌMoseesa vʌʌsi istumaasi mamaatʌcatadai Ejiipitʌrʌ oidacami. Dai cʌʌga maatʌ ñioocai ʌMoseesa dai aliʌ saituduga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aidʌsi caviaacatadai ʌMoseesa goo coobai uumigi diviji ʌgai ʌjudidíu Goosiena, ʌgai ʌrjudíucatadai ʌʌpʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dai ami tʌʌ ʌMoseesa ʌmo cʌʌli Ejiipitʌrʌ oidacami ismaacʌdʌ soi vuaadatadai ʌmo judíu. Dai soiña ʌliditadai ʌMoseesa ʌjudíu cascʌdʌ muaa ʌgai ʌcʌʌli Ejiipitʌrʌ oidacami tai aduucai aa noragi ismaacʌdʌ soimaasi ivuaadatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moseesa poʌliditadai isʌjudidíu camaatʌcatadai isDiuusi ootosa agai ʌgai sai vuvaidana ʌoodami Ejiipituaiñdʌrʌ dai vʌʌscʌrʌ maimaatʌcatadai ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Dai siaadiqui tʌʌ ʌMoseesa gooca judidíu vai aliʌsi gʌncocoodaitadai dai ʌgai baiʌʌliatuda ʌlidi cascʌdʌ itʌtʌdai: “Aapimʌ ʌrʌmo oodami ¿tuimʌsi soi gʌnvueeyi?” astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Amaasi ʌgai ismaacʌdʌ soi vueeyi ʌgʌmai nuituca Moseesa daidʌ itʌtʌdai: “¿Toorʌ gʌdaí aapi tʌaanʌdami duucai dai dunucami duucai aatʌmʌ gʌrvʌʌtarʌ? ");
INSERT INTO ntpNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Giñmuaa pʌsiʌlidi aanʌ ʌʌpʌ poduucai pʌsduucai muaa aapi tacavo ʌEjiipitʌrʌ oidacʌdʌ?” astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tai mʌʌidʌ ʌMoseesa caʌcai iscaiti ʌcʌʌli. Dai vuusai Ejiipituaiñdʌrʌ dai mʌʌcasi ii Madianamu. Dai ami oidacatu mʌʌcasdʌrʌ oidacami duucai. Dai maamarai gooca. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Dai cadaivunucai goo coobai uumigi, ami oidigana miaanai ʌgiidi siaaco Siñaí tʌʌgidu, gʌmaasitu ʌmo Diuusi tʌaañicarudʌ ʌMoseesa vuitapi taiyʌrʌ ismaacʌdʌ mʌʌcatadai ʌmo uusi iipuadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Taidʌ ʌMoseesa maitʌʌ isducatai gʌtʌgituagi tʌʌgacai gomaasi. Dai aidʌsi miaadʌrʌ cʌquiva ʌgai dai cʌʌgioma nʌida agai, caʌ ʌgai Diuusi ñiooquidʌ ismaacʌdʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Aanʌanʌ ʌrDiuusigadʌ gʌʌʌqui aaduñicaru Avraañicaru ʌʌmadu ʌIsaacaru ʌʌmadu Jacocaru”, ascaiti ʌñiooqui. Amaasi ʌMoseesa gigivuquimi duaadimucai dai camaitʌpʌʌli isvui nʌnʌavagi vaamioma. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Taidʌ Diuusi itʌtʌdai ʌMoseesa: “Movai pʌsiaaco cʌʌca aapi godʌvʌʌrai ʌrʌcovai giñvuusaida cascʌdʌ uupasañi gʌsusuusaca dai poduucai siaa giñduutuda. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aanʌ cʌʌ maatʌ siʌʌ soimaa taataca vʌʌsi giñmaamara Ejiipitʌrʌ oidacami, aanʌ caʌ isaijigʌi ʌgai cascʌdʌ tʌvai aanʌ dai cʌʌgacʌrʌ vuvaida iñagai. Imiñi tudu gʌootosamu aanʌ Ejiipituamu”, astʌtʌdai Diuusi ñiooquidʌ ʌMoseesa. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tomasi ʌMoseesa aaduñdʌ maicʌʌgacʌrʌ nʌiditadai ʌMoseesa dai potʌtʌdai: “¿Toorʌ dunucami dai tʌaanʌdami duucai gʌdaí?” astʌtʌdai. Vʌʌscʌrʌ Diuusi ootoi ʌMoseesa tʌaanʌdami duucai dai cʌʌgacʌrʌ vuviadami, poduucai ootosi ʌgai ñiooqui gʌtʌaañicarucʌdʌ ismaacʌdʌ gʌmaasitu ʌtaiyʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dai Moseesa ʌrʌgai ismaacʌdʌ vuvaitu gʌraaduñicaru Ejiipituaiñdʌrʌ dai idui mui naana maasi gʌgʌrducami Diuusi guvucadadʌcʌdʌ ami dʌvʌʌriʌrʌ dai siaaco Gʌʌ Suudagi Vʌgicʌrʌ tʌʌgidu ʌʌpʌ dai oidigana ʌʌpʌ goo coobai uumigi pomaasi ivueeyi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Dai ʌMoseesa ʌgai daidʌ itʌtʌdai ʌjudidíu: “Diuusi gʌnootosda agai ʌmoco ismaacʌdʌ ñioocada agai ʌgai vʌʌtarʌ ʌʌgi aapimʌ gʌnaadunumʌ saagidaiñdʌrʌ, poduucai isduucai giñootoi ʌgai aanʌ. Dai ʌʌgiadavurai ʌgai”, astʌtʌdai Moseesa. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Dai ʌMoseesa ʌgai ismaacʌdʌ oidigana aimʌraitadai ʌʌmadu ʌoodami, dai ʌgai ñiooqui Diuusi tʌaañicarudʌ ʌgiidi Siñaíʌrʌ dai ʌʌmadu daacatadai gʌraaduñicaru ʌʌpʌ dai Diuusi aagidi Moseesa ñiooqui sai gʌraagidana isducatai gʌaagai isoidaca aatʌmʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Dʌmos gʌraaduñicaru maitipʌli isʌʌgidagi, baiyoma mosgajiaadʌrʌ vipieeyi ʌgai ismaacʌdʌ mamaatʌtuldi Moseesa dai ʌpamu noonoigia ʌliditadai Ejiipituamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Amaasi itʌtʌdai ʌgai ʌAaróñi: “Aatʌmʌ ipʌlidi pʌsgʌrduiñdagi didiuusi vai gʌrnuucadacana aatʌmʌ maimaatʌ siaaco dui ʌMoseesa ismaacʌdʌ gʌrvuvaitu Ejiipituaiñdʌrʌ”, ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Amaasi idui ʌgai ʌmo ali cʌisi vaaca mara maasi, dai coi vustaaqui dai dadasdiña ʌvaaca mara ismaacʌdʌ idui ʌgai dai diuusi aagaiña. Dai aliʌ baigʌnʌliditadai ʌgai ʌgaicʌdʌ ismaacʌdʌ idui ʌgai gʌnnoonovicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Amaasi Diuusi ʌcovai ii ʌgai saagidaiñdʌrʌ, dai dagito sai siaa duutudaiña ʌgai sisiaavugai gʌndiuusiga duucai, dai ʌmo Diuusi ñiooquituldiadamigadʌ ooja iscaiti Diuusi sai pocaiti: ¿Coimʌsi aapimʌ judidíu vustaaqui dai giñdadasdiña aidʌsi goo coobai uumigi oidigana ajioopaitadai aapimʌ? ");
INSERT INTO ntpNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Baiyoma bʌʌ ajioopaiña aapimʌ gʌndiuusiga Moloqui ʌmo icuusi vaaquiʌrʌ daidʌ idui aapimʌ ʌmo istumaasi ʌmo siaavugai maasi dai Rempañi tʌʌtʌi, ʌgai ʌrdidiuusi ismaacʌdʌ aapimʌ ʌʌgi idui dai siaa duutudaiña. Cascʌdʌ gʌnvuvaidamu aanʌ gʌndʌvʌʌragaiñdʌrʌ dai gʌnootosamu mʌʌcasi Bavilonia baitʌqui. Ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Gʌraaduñicaru viaacatadai oidigana ʌmo icuusi vaaqui siaaco bai daraasacana ʌgai ʌojoodai caacaparacʌdʌ ismaacʌdʌrʌ ooja Diuusi ismaacʌdʌ ʌrsʌʌlicami. Diuusi tʌjai ʌMoseesa ʌicuusi vaaqui sai poduucai iduuna isducatai nʌiditadai ʌgai ʌmai sibʌacoga siaaco tʌʌgi Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dai gʌraaduñicaru vii ʌicuusi vaaqui ismaacʌdʌ idui Moseesacaru aa gooquiʌrdadioma gʌraaduñicaru, dai ʌgai ismaacʌdʌ oiditadai ʌJosue bʌʌcaticatadai ʌicuusi vaaqui aidʌsi voopoji ʌgai dʌvʌʌragadʌ aa ʌma maa ñioocadami. Diuusi vuvaitu ʌgai ismaacʌdʌ ami oidacatadai sai ami oidacana ʌJosue ʌʌmadu ʌgaa oodami. Daidʌ ʌicuusi vaaqui movaasi viaacatadai ʌoodami dai ami siaa duutudaiña Diuusi asta aidʌsi gatʌjai ʌbaitʌcʌaacami Davicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Diuusi aliʌ cʌʌgacʌrʌ nʌiditadai Davicaru vaidʌ ʌDavicaru iduñia ʌliditadai ʌmo vaaqui Diuusi vʌʌtarʌ. Gʌraduñi Jacocaru vaavoitu Diuusi gʌrooga ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dʌmos ʌSalomoñi ʌgai daidʌ idui Diuusi vaaquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tomasi Diuusi ismaacʌdʌ ʌrʌbaitʌcʌaacami maioidaga quiquiuupiʌrʌ ismaacʌdʌ ivueeyi oodami. Poduucai isducatai aagai Diuusi ñiooquituldiadamigadʌ sai pocaiti Diuusi: ");
INSERT INTO ntpNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Aanʌana ʌgai ismaacʌdʌ tʌaanʌi tʌvaagi dai vʌʌsi oidigi ʌʌpʌ. ¿Maasca agai ʌvaaqui ismaacʌdʌ giñduiñda agai aapimʌ? Aanʌ anmaitʌgito siaaco giñibʌstagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Maitansi ʌʌgi idui aanʌ vʌʌsi gomaasio? Ascaiti Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Daidʌ ʌTiivañi apiañiooquidi ʌoodami daidʌ itʌtʌdai: ―Aapimʌ aasñiñitu gʌnducami maitʌtʌʌcaidaga ʌpan ducami aapimʌ ismaacʌdʌ maivaavoitudai Diuusi. Dai vʌʌscʌrʌ vuidʌrʌ vʌʌtacana aapimʌ Diuusi Ibʌadʌ ʌpan tuutuiga aapimʌ gʌnʌʌqui aaduñicaru. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gʌnaaduñicaru soimaa taatatuli dai asta coi vʌʌsi Diuusi ñiñiooquituldiadamigadʌ ismaacʌdʌ ʌʌquioma dada dai aagidi Diuusi ñiooquidʌ. Ʌgai vaa ñiñiooquituldiadami aagai isdivia agai ʌcʌʌ tuigacʌdʌ ismaacʌdʌ tomali ʌmo imidagai maisoimaasi ivueeyi. Dai aidʌsi divia ʌgai aapimʌ gatʌʌgi mʌsai muaana. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diuusi gʌnaagidi gʌtʌtʌaañicarucʌdʌ isducatai gʌaagai mʌsoidacagi mai aapimʌ maiʌʌgidi ―astʌtʌdai Tiivañi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dai aidʌsi caʌ ʌoodami imaasi sʌʌlicʌdʌ baacoi ʌTiivañi vui dai cʌcʌrʌñdimi gʌntaatamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Dʌmos Diuusi Ibʌadʌ ʌʌmadu daacatadai ʌTiivañi tai ʌgai tʌvaagiamu nʌnʌava dai tʌʌ Diuusi isvaamioma dadadacʌi sitasai dai ʌSuusi sʌʌlisa padʌrʌ cʌʌca Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Amaasi itʌtʌdai ʌTiivañi ʌoodami: ―Dañi nʌidi aanʌ tʌvaagi vai cupioquiñi dai ʌgai ismaacʌdʌ viaa ʌmo sʌʌlicami sʌʌlisa padʌrʌ cʌʌca Diuusi ―astʌtʌdai Tiivañi. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amaasi ʌoodami cuu gʌnnaanaca maicaʌca ʌliditai, dai vʌʌscatai gʌgʌrʌ iiñaquimi dai vui voopoi ʌTiivañi ");
INSERT INTO ntpNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","dai bʌi dai vuusaitu ami Jerusaleenaiñdʌrʌ dai maicacarai. Dai ʌgai ismaacʌdʌ maisai nuucatuli gʌnsosoa ʌmo gʌʌli Saulo tʌʌgiducami. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dai aidʌsi quiaa maisaitadai ʌoodami taidʌ ʌTiivañi aduucai daanʌgi ʌSuusi: ―Suusi bʌʌcaiñi giñiibʌdaga ―ascaiti. ");
INSERT INTO ntpNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dai gooquiʌrʌ gʌtootonacʌdʌ cʌquiva dai gʌgʌrʌ iiña daidʌ icaiti: ―Tʌaanʌdami maiti gʌpiʌrʌ vuupada gooodami idi soimaascamicʌdʌ ―ascaiti. Dai mospotʌi dai muu. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Daidʌ ʌSaulo baiaa ʌʌpʌ mʌsmuaagi ʌTiivañi. Dai aidʌ ʌcʌrʌ sigʌmuaatu ʌTiivañi ʌJerusaleenʌrʌ oidacʌdʌ vui suuli ʌvaavoitudadami dai soimaa taatatuli. Tai vʌʌsi ʌvaavoitudadami aipaco iji Judeeamu dai Samaaliamu mosʌcaasi ʌojootosicami maiiji abiaadʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dai ʌʌmoco cʌcʌʌli ismaacʌdʌ siaa duutudaitadai Diuusi yaasa ʌTiivañi dai sʌʌlicʌdʌ sosuaañi ʌgaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Vaidʌ ʌSaulo apiasoi vuaadatadai ʌvaavoitudadami, dai vʌʌsi quiiquiʌrʌ vapaacʌiña dai tʌvaimʌticatai vuvaidiña cʌcʌʌli dai ooqui gatʌaañia ʌliditai maamaisaragai. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Dʌmos ʌvaavoitudadami ismaacʌdʌ iji Jerusaleenaiñdʌrʌ tomasiaaco siaaco ajioopaitadai ʌgai gaaagidimi isSuusi Cristo ʌrcʌʌgacʌrʌ vuviaadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ʌmaadutai ʌvaavoitudadami Piili tʌʌgiducatadai dai ii ʌmapʌcʌrʌ Samaalia dʌvʌʌriʌrʌ. Dai ami gaaagidi isSuusi Cristo ʌrcʌʌgacʌrʌ vuviaadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vaidʌ ʌoodami gʌnʌmpaidiña dai cʌʌga gʌntʌgito caʌcana istumaasi aagidiña ʌPiili. Dai nʌidi ʌgai ʌʌpʌ istumaasi gʌgʌrducami ismaacʌdʌ ivuaadatadai ʌPiili Diuusi guvucadadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Muidutai ʌgai ismaacʌdʌ viaacatadai Diaavora tʌtʌaañicarudʌ duduaadi ʌPiili vaidʌ ʌDiaavora tʌtʌaañicarudʌ vuvacʌiña oodamiaiñdʌrʌ iiñaquidatai, dai muidutai ismaacʌdʌ maitistutuiditadai isoiñiadagi ʌʌmoco gʌnʌʌca siʌʌpʌ ʌʌmoco gʌncaacaji vʌʌsi duduaadi ʌgai. Dai ʌʌmoco ismaacʌdʌ maitistutuiditadai isajioopadagi vʌʌsi duduaadi ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dai poduucai vʌʌsi ʌoodami baigʌnʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dai ami oidacatadai ʌmo cʌʌli Simuñi tʌʌgiducami, ismaacʌdʌ ʌʌquioma ʌrcʌʌdaracamicatadai dai mosyaatagidiña ʌgai ʌoodami potʌtʌdaitadai saidʌ ʌrmaatʌcami. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vai vʌʌsi ʌoodami ʌmaduga mʌʌsi aaliducami dai gʌgʌrducami vʌʌsi gʌntʌgito caʌcana istumaasi aagaiña ʌgai daidʌ icaitiña: ―Goovai gia viaa Diuusi guvucadadʌ ―ascaitiña ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tʌvʌpi yaatagidiña ʌSimuñi gʌcʌʌdaragacʌdʌ cascʌdʌ gʌntʌgito caʌcana ʌoodami dai ʌʌgidiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dai aidʌsi vaavoitu ʌoodami aagiditai ʌPiili isDiuusi soicʌi oodami sai cʌʌgacʌrʌ oidacana dai isSuusi Cristo ʌrcʌʌgacʌrʌ vuviaadami, muidutai ooqui dai cʌcʌʌli gʌnvapacoi. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dai asta ʌSimuñi ismaacʌdʌ ʌrcʌʌdaracamicatadai vaavoitu dai gʌvacoi, dai ʌʌmadu aimʌraiña ʌPiili dai maitʌtʌgaiña isducatai gʌtʌgituagi nʌiditai ʌPiili isivuaadana naana maasi gʌgʌrducami Diuusi guvucadadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aidʌsi maí ʌojootosicami ismaacʌdʌ Jerusaleenʌrʌ daraajatadai isSamaaliʌrʌ oidacami vaavoitu Diuusi ñiooquidʌ, gaamucu ootoi ʌPiiduru ʌʌmadu ʌVuaana. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dai aidʌsi aayi ʌgai Samaaliʌrʌ gamamagi ʌvaavoitudadami vʌʌtarʌ, sai Diuusi Ibʌadʌ diviana ʌvaavoitudadami ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tomali ʌmaadutai ʌgai maiquiaa ʌʌmadu daacatadai Diuusi Ibʌadʌ. Mosvapacoñicatadai ʌgai Suusi sʌʌlicamigadʌcʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Cascʌdʌ ʌPiiduru ʌʌmadu ʌVuaana daama darai gʌnnoonovi tai poduucai divia Diuusi Ibʌadʌ ʌvaavoitudadami ʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dai aidʌsidʌ ʌSimuñi tʌʌ isdivia Diuusi Ibʌadʌ ʌvaavoitudadami ʌʌmadu aidʌsi daama darai ʌojootosicami gʌnnoonovi, ");
INSERT INTO ntpNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","amaasi ʌSimuñi itʌtʌdai: ―Aanʌ gʌnmaquiaagi tumiñsi vʌrai aapimʌ giñmaaca guvucadagai nai siʌʌscadʌ aanʌ daama darasadagi giñnoonovi tomastuma oodami vai didivadagi Diuusi Ibʌadʌ ʌgai ʌʌmadu ―astʌtʌdai ʌSimuñi. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amaasi ʌPiiduru itʌtʌdai: ―Poʌlidi aapi sai istumaasi gaoidi Diuusi gʌsaapʌdai tumiñsicʌdʌ cascʌdʌ ugitʌna gʌtumiñsiga aapi gʌʌmadu. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aapi maiviaa tomalaachi sʌʌlicami idi guvucadagiʌrʌ maitacʌʌgadu gʌibʌdaga Diuusi vuitapi. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dagitoñi vʌʌsi gʌsoimaascamiga dai daañi Diuusi sabai gʌoigʌldana ʌgai gʌsoimaascamiga ismaacʌdʌ viaa aapi gʌibʌdagʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Giñtʌgito nʌidi aanʌ isaliʌsi ʌrsoimaasi iducami aapi dai gʌsoimaascamiga gʌmaisacan duu ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Amaasi ʌSimuñi aa noragi daidʌ itʌtʌdai: ―Daanʌdavurai aapimʌ Diuusi aanʌcʌdʌ nai maipovai iñduñia aanʌ mʌsducatai aagai aapimʌ ―astʌtʌdai ʌSimuñi. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Amaasi ʌPiiduru ʌʌmadu ʌVuaana aatagi ʌoodami dai aagidi ʌʌpʌ Diuusi ñiooquidʌ, dai gooquiʌrʌ iji muiyapʌrʌ Samaalia dʌvʌʌriʌrʌ dai gaaagidimi isSuusi Cristo ʌrcʌʌgacʌrʌ vuviaadami dai gooquiʌrʌ noonora Jerusaleenamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Amaasi cadaivunucai imaasi ʌmo Diuusi tʌaañicarudʌ ñiooqui ʌPiili daidʌ itʌtʌdai: ―Cʌquivañi dai imi govoiyamu ismaacʌdʌ Jerusaleenaiñdʌrʌ caatʌ Gaasamaco dai idi vaa voi ʌgai dai oidigana daivunuga siaaco maitiipu oidacami ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Taidʌ ʌPiili cʌquiva dai ii dai voiyʌrʌ aayi ʌmo cʌʌli Etiopiiʌrʌ oidacami. Ʌgai ʌrtʌaanʌdamicatadai daidʌ ʌrnuucadacamicatadai ʌCandaasi tumiñsigadʌ. ɅCandaasi ʌrʌmo ooqui daidʌ ʌrbaitʌcʌaacamicatadai Etiopiiʌrʌ dai vʌʌsi cʌcʌʌli ismaacʌdʌ aata vuaadana Candaasi vʌʌtarʌ cacaapuñicatadai cascʌdʌ ʌcʌʌli capuuñicatadai ʌʌpʌ. Daidʌ ʌcʌʌli cagʌquiiyamaco imʌitadai Jerusaleenaiñdʌrʌ siaaco siaa duutudaitadai ʌgai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Vaidʌ ʌcʌʌli ʌmo careeta ʌraana daitugaitadai dai aagaimi oojai ismaacʌdʌ ooja Isaíacaru Diuusi ñiooquituldiadamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Amaasi Diuusi Ibʌadʌ itʌtʌdai ʌPiili: ―Imiñi dai abaan cʌquiva gocareeta ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dai aidʌsi miaadʌrʌ cʌquiva ʌPiili caʌ ʌgai ʌcʌʌli isaagaimi oojai ismaacʌdʌ ooja Isaía tai ʌgai tʌcacai daidʌ itʌtʌdai: ―¿Maatʌpʌs caʌ gooojai pʌsmaacʌdʌ aagai? ―astʌtʌdai ʌPiili. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Taidʌ ʌcʌʌli aa noragi daidʌ itʌtʌdai: ―¿Ducatai maatʌ caʌcana aanʌ maitiipucatai sioorʌ giñaagidagi istʌiya ʌlidi goovai? ―astʌtʌdai ʌcʌʌli. Dai vaí ʌPiili sai abaana daivana. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Vaidʌ ʌcʌʌli aagaitadai ʌoojai Diuusi ñiooquidʌrʌ siaaco icaiti: Aidʌmʌsi bʌʌcai dai muaa agai maiaijigʌi ʌpan duucai ʌmo cañiiru ismaacʌdʌ maisuaacai mʌsiuu duu muaagi. Dai ʌpan duucai cañiiru mara ismaacʌdʌ maisuaacaiña mʌsiuu duuca iicadagi, Poduucai ʌgai maisosua dai muu. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Soi dui ʌgai maiviaacatai ʌgai istuisi soimaa taatagi. ¿Sioorʌ istuidʌcai ʌcaldana siʌʌquiatai vaavoituda agai? Ascaiti Diuusi ñiooquidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Taidʌ ʌtʌaanʌdami tʌcacai ʌPiili daidʌ itʌtʌdai: ―Giñoigʌdacai giñaagida, ¿voorʌ aagai goDiuusi ñiooquituldiadamigadʌ ʌʌgi ʌgai ʌmai sio? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Amaasi ʌPiili gʌaagacai aagidi ʌñiooqui ismaacʌdʌ aagai ʌcʌʌli oojiʌrʌ dai aagidi ʌma maasi ʌʌpʌ aagaitai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Dai aidʌsi aayi ʌgai ʌmapʌcʌrʌ siaaco daacatadai suudagi, taidʌ ʌtʌaanʌdami itʌi: ―Tami daja suudagi. ¿Baisi ʌrcʌʌgai isvacuañica aanʌ? ―astʌtʌdai ʌgai ʌPiili. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Taidʌ ʌPiili itʌtʌdai: ―Pʌssʌʌlicʌdʌ vaavoitudadagi aidʌ gia istutuidi aapi ―astʌtʌdai ʌPiili. Taidʌ ʌcʌʌli aa noragi daidʌ itʌtʌdai: ―Aanʌ angia vaavoitudai isSuusi Cristo ʌrDiuusi maradʌ ―ascaiti ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Amaasi ʌcʌʌli gatʌjai cʌʌsaragai ʌcareeta, dai vʌgoocatai tʌaapai siaaco daacatadai ʌsuudagi, taidʌ ʌPiili vacoi ʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dai aidʌsi ʌpaamu tʌʌtʌsai ʌgai abiaadʌrʌ taidʌ Diuusi Ibʌadʌ vaidacai ʌPiili, taidʌ ʌtʌaanʌdami camaitʌʌ vaamioma, dʌmos apiaimʌi ʌgai gʌvoogʌamu baigʌʌliatugaitai. ");
INSERT INTO ntpNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Amaasi ʌPiili aayi Asootʌrʌ dai vʌʌsi ʌʌmapʌcʌrʌ aijimi dai gaaagidimi ʌcʌʌgacʌrʌ vuvaidaragai mospovuimi dai aayi Sesareeʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ɅSaulo maidagitocai soi vueeyi ʌvaavoitudadami. Dai pocaitiña sai coodia agai cascʌdʌ nʌidamu ʌgai ʌbaitʌcʌaacamigadʌ papaali judidíu ");
INSERT INTO ntpNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","dai taí oojai ismaacʌdʌrʌ maa ʌgai oigaragai sai imʌna ʌgai judidíu quiquiuupaigadʌamu Damascʌrʌ dai gaagana ismaacʌdʌ apiavaavoitudai Suusi Cristo mamaatʌtuldaragadʌ dai sai maamaisapicamu vuaapana Jerusaleenʌrʌ vʌʌsi ʌmaduga mʌʌsi ooqui dai cʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dʌmos aidʌsi voiyamu imʌitadai ʌgai camiaadʌrʌ Damasco, tai todian duucai vʌpʌdoli sicoli ʌgai ʌmo cuudagi tʌvaagiaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Taidʌ ʌSaulo dʌvʌʌrapi gʌi, dai caʌ ʌmo ñiooqui ismaacʌdʌ itʌtʌdai: ―Saulo, Saulo, ¿tuipʌsi soi giñvueeyi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Amaasi ʌSaulo itʌtʌdai: ―¿Poorʌ aapi tʌaanʌdami? ―astʌtʌdai. Taidʌ ʌñiooqui aa noragi daidʌ itʌtʌdai: ―Aanʌanʌ ʌrSuusi ʌgai vaa ismaacʌdʌ soi vueeyi aapi. Ʌʌgi gʌtomitʌscʌi aapi ʌpan duucai ʌmo vooyisi ismaacʌdʌ cuituscʌi tootoicami cuugadʌ ―astʌtʌdai ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Amaasi ʌSaulo gigivuquimi duaadimucai daidʌ itʌtʌdai: ―Tʌaanʌdami, ¿tumaasi ipʌlidi aapi isiduñia aanʌ? ―astʌtʌdai. Taidʌ ʌtʌaanʌdami itʌtʌdai: ―Cʌquivañi dai ai Damascʌrʌ mʌsimʌʌca gʌaagidamu istumaasi gʌaagai pʌsiduñiagi ―astʌtʌdai ʌtʌaanʌdami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ʌcʌcʌʌli ismaacʌdʌ ʌʌmadu iimʌitadai ʌSaulo aliʌ duduaadimu caʌcacai ʌñiooqui dai maitʌʌgacai tomali ʌmaadutai. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Amaasi ʌSaulo cʌquiva dʌvʌʌrapidʌrʌ, dʌmos maitistui isnʌnʌavagi tomalaachi. Taidʌ ʌaaduñdʌ vaidacai Damascoamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Daidʌ ʌSaulo vaica tasai maitistui isnʌnʌavagi dai maitauu dai maitaii tomalaachi istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dai ami Damascʌrʌ oidacatadai ʌmo vaavoitudadami Ananiiasi tʌʌgiducami tai ʌgai vuitapi gʌmaasitu ʌSuusi daidʌ itʌtʌdai: ―Ananiiasi ―astʌtʌdai. Tai ʌgai aa noragi daidʌ itʌtʌdai: ―Tʌaanʌdami tami andaja ―astʌtʌdai Ananiiasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Amaasi ʌtʌaanʌdami itʌtʌdai: ―Cʌquivañi dai imi siaaco caayi Sʌʌliñicʌrʌ tʌʌgidu dai Uudasi quiidiʌrʌ nʌida ʌmo cʌʌli Tarsuaiñdʌrʌ Saulo tʌʌgiducami gamamadiava. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Gʌtʌʌtʌquiʌrʌ tʌʌ ʌgai ʌmo cʌʌli Ananiiasi tʌʌgiducami sai vaa dai daama darai gʌnoonovi saidʌ istui ʌgai isnʌnʌavagi ʌpamu ―astʌtʌdai ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Taidʌ ʌAnaniiasi moscaʌ imaasi daidʌ itʌtʌdai: ―Tʌaanʌdami muidutai giñaagidiña gocʌʌli dai vʌʌsi soimaascami ismaacʌdʌ ivuiididiña goovai ismaacʌdʌ gʌvaavoitudai Jerusaleenʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Dai sivi divia goovai tami ʌpapaali baitʌguucacamigadʌ sʌʌlicamigadʌcʌdʌ, dai maamaisapicami vuuquia agai vʌʌscatai ismaacʌdʌ gʌvaavoitudai aapi ―astʌtʌdai Ananiiasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amaasi ʌtʌaanʌdami itʌtʌdai: ―Imiñi casiant ʌco vuusaitu aanʌ ʌSaulo vai aagidana ʌgai aa ʌma maasi ñioocadami dai raraí dai judidíu ʌʌpʌ iñsaanʌ cʌʌgacʌrʌ vuvaidi oodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aanʌ tʌʌgidamu isaliʌ viaa ʌgai issoima taatagi giñvaavoitudaitai ―ascaiti ʌSuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Amaasi ii Ananiiasi ʌquiiyamu siaaco daacatadai ʌSaulo dai ami vaacʌcai daama darai gʌnoonovi daidʌ itʌtʌdai: ―Giñaduñi Saulo, ʌSuusi ismaacʌdʌ gʌmaasitu aapi gʌvuitapi voiyaiñdʌrʌ ʌgai atgiñootoi pʌsai ʌpamu nʌnʌavana dai sai Diuusi Ibʌadʌ gʌʌmadu daaca agai ―astʌtʌdai Ananiiasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tai otoma suuli vatopa coocomidʌ maasi vuupujiaiñdʌrʌ dai casi istui ʌgai isnʌnʌavagi. Dai otoma cʌquiva dai gʌvacoi sai nʌidiña ʌoodami iscaʌma duucai gʌtʌgito ʌgai dai camaisoimaasi ivuaada agai. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Dai gooquiʌrʌ gauu dai bʌi gʌguvucadaga ʌpamu dai anaasi daja chiʌʌqui tasai ʌvaavoitudadami ʌʌmadu Damascʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Otoma gʌaagacai gamamaatʌtuldimi ʌSaulo judidíu quiquiuupaigadʌrʌ Diuusi ñiooquidʌ dai gaaagidi sai Suusi ʌrDiuusi maradʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dai vʌʌscatai ismaacʌdʌ caʌ maitʌtʌgaitadai isducatai gʌntʌtʌgituagi daidʌ icaiti: ―¿Maitasi ʌrʌcʌʌli goovai ismaacʌdʌ Jerusaleenʌrʌ aimʌraiña dai gaagaiña ʌvaavoitudadami dai soi vuaadana? ¿Dai maitasi ʌrʌgai vaa ismaacʌdʌ tami divia dai maamaisapicami vuuquia agaitadai vaavoitudadami ʌʌpʌ dai tʌʌgida agai ʌbaitʌguucacamigadʌ papaali Jerusaleenʌrʌ? ―ascaiti ʌoodami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dʌmos ʌSaulo vaamioma maiduaadicuitai gaaagidi Diuusi ñiooquidʌ dai gaaagidiña ʌʌpʌ saidʌ ʌSuusi ʌrʌCristo, taidʌ ʌjudidíu Damascʌrʌ oidacʌdʌ camaitʌʌ isducatai gʌntʌtʌgituagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Dai bai tʌvʌpicʌdʌ ʌjudidíu gʌnaagi dai muaa agai ʌSaulo. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dʌmos ʌSaulo maí. Dai Damasco sicoli cuupicatadai gʌʌ bidaaviquicʌdʌ vaidʌ ʌjudidíu ʌbidaaviqui cuucuparagadʌrʌ soobidacana tasʌrʌ dai tucarʌ siaaco vuusiagi sai muaa agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dʌmos ʌvaavoitudadami gʌʌ asaarai ʌraana daí ʌSaulo dai bidaaviquiamu sʌʌli tʌvaañi ʌmo imidagai tucarʌ tai poduucai cʌʌgacʌrʌ vuusai ʌSaulo. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aidʌsi aayi ʌSaulo Jerusaleenʌrʌ ʌgai urava ʌliditadai ʌvaavoitudadami dʌmos ʌvaavoitudadami ʌʌbʌidiña vʌʌscʌrʌ maivaavoitudaiña ʌgai siʌSaulo casi ʌrvaavoitudadami ʌʌpʌ cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dʌmos ʌBernabé gia vaidacai dai vaan cʌʌsi ʌojootosicami dai aagidi isducatai tʌʌ ʌSaulo ʌSuusi Cristo voiyʌrʌ, dai isducatai ñiooqui ʌSuusi, dai isducatai ʌSaulo maiduaadimudacʌdʌ aagidi Diuusi ñiooquidʌ Damascʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Taidʌ ʌSaulo anaasi Jerusaleenʌrʌ vii dai ʌʌmadu aimʌraiña ʌvaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Dai maiduaadicuitai gaaagidiña Diuusi ñiooquidʌ, dai ʌʌmadu gaaatagaiña ʌgai ʌjudidíu ismaacʌdʌ ñioocaitadai giliego ñiooquidʌ, dʌmos ʌjudidíu gaagaitadai isducatai muaagi ʌSaulo. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dai aidʌsidʌ ʌvaavoitudadami maí gomaasi otoma vaidacai ʌgai ʌSaulo Sesareeamu dai abiaadʌrʌ ootoi Tarsuamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Aidʌ camaitiipucatadai sioorʌ soi duucai nʌijadagi ʌvaavoitudadami Judeeʌrʌ dai Galileeʌrʌ dai Samaaliʌrʌ oidacami cascʌdʌ baigʌnʌliditai oidaga ʌgai dai vaamioma cʌʌga vaavoitudaimi dai siaa duutudaiña Diuusi. Dai Diuusi Ibʌadʌ ʌʌmadu daacatadai vai vaamioma muidaimi vaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Aidʌsidʌ ʌPiiduru didividitadai ʌvaavoitudadami diviji ʌgai ʌʌpʌ ʌvaavoitudadami Liidiʌrʌ oidacʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Vai ami oidacatadai ʌʌpʌ ʌmo cʌʌli Eneeasi tʌʌgiducami ismaacʌdʌ caparʌ mamacova uumigi moscaatʌcatadai maitistutuidiña ʌgai isaimʌrdagi cascʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Taidʌ ʌPiiduru itʌtʌdai: ―Eneeasi casiapʌtdueeyi Suusi Cristo guvucadadʌcʌdʌ, vañigiñi dai bai duuñi gʌvaacosi ―astʌtʌdai ʌPiiduru. Taidʌ Eneeasi otoma vañi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dai vʌʌscatai Liidiʌrʌ oidacʌdʌ dai Saroñiʌrʌ oidacʌdʌ tʌʌgacai imaasi dagito ʌʌquidʌ gʌnvaavoidaraga dai vaavoitu Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Aidʌ Jopʌrʌ oidacatadai ʌmo ooqui vaavoitudadami Tavita tʌʌgiducami dai giliego ñiooquicʌdʌ ʌrDoorcasi. Idi ooqui vʌʌscʌrʌ cʌʌga ivuaadana dai soicʌiña ʌsoituutuigami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Dai ʌmo imidagai aliʌ cooco ʌooqui dai muu, mʌtai vaʌtʌsi dai gooquiʌrʌ goocua daama vaaquiʌrʌ tʌcaviaco tʌʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Dai Jopaiñdʌrʌ miaaga Liidiamu siaaco daacatadai ʌPiiduru, taidʌ ʌvaavoitudadami maí isami daacatadai ʌPiiduru dai ootoi gooca cʌcʌʌli sai mʌʌ aagidana ʌPiiduru sai otoma diviana. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Taidʌ ʌPiiduru otoma oí ʌcʌcʌʌli. Aidʌsi aayi ʌgai mʌtai otoma vaidacai siaaco caatʌcatadai ʌmuuquiadʌ, tai vʌʌsi ʌvipiuudu sicoli guuquiva dai suaañimi dai vuvaitu yuupurui dai vaapasaragai ismaacʌdʌ idui ʌDoorcasi maiquiaa muucucai dai tʌtʌgidi ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Amaasi ʌPiiduru quiidigamu ootoi vʌʌscatai ismaacʌdʌ ami daraajatadai dai gʌtootonacʌdʌ cʌquiva dai gamamagi, dai vui nʌnʌava ʌgai ʌooqui muuquiadʌ daidʌ itʌtʌdai: ―Tavita vañigiñi ―astʌtʌdai ʌPiiduru ʌooqui. Tai ʌgai cupioco gʌvuupuji dai tʌʌ ʌPiiduru dai sʌʌli daiva. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Taidʌ ʌPiiduru noviaiñdʌrʌ bʌi dai vañigi, dai otoma vaí ʌaaduñdʌ ʌʌmadu ʌvipiuudu dai vaan cʌʌsi duaacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Vʌʌsi gomaasi maí vʌʌscatai Jopʌrʌ oidacami dai muidutai vaavoitu Suusi Cristo. ");
INSERT INTO ntpNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Taidʌ ʌPiiduru anaasi Jopʌrʌ vii bai tʌvʌpi ʌmo vaqueetatadami quiidiʌrʌ Simuñi tʌʌgiducami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesareeʌrʌ oidacatadai ʌmo cʌʌli Cornelio tʌʌgiducami ismaacʌdʌ tʌaanʌitadai ʌmo siento sandaaru mʌsmaacʌdʌ Italianu aagaiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Dai Cornelio ʌʌmadu vʌʌsi aaduñdʌ aliʌ siaa duutudaiña Diuusi, dai ʌgai soicʌiña mui tumiñsicʌdʌ ʌjudidíu dai vʌʌscʌrʌ gamamadaiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dai ʌmo imidagai coi gʌʌsʌco tasai cʌʌga tʌʌ ʌCornelio ʌmo Diuusi tʌaañicarudʌ ismaacʌdʌ vaa siaaco daacatadai ʌgai daidʌ itʌtʌdai: ―Cornelio ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Vaidʌ ʌCornelio mosnʌidi ʌDiuusi tʌaañicarudʌ duaadimucai. Dai amaasi tʌcacai daidʌ itʌtʌdai: ―¿Tumaasi tʌgito aapi? ―astʌtʌdai Cornelio. Amaasi ʌDiuusi tʌaañicarudʌ itʌtʌdai: ―Diuusi aliʌ baigʌʌlidi gʌmamadaragacʌdʌ dai vʌʌsicʌdʌ ismaacʌdʌ ivueeyi aapi soicʌitai soituutuigami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ootosañi cʌcʌʌli Jopamu vai vaidana Simuñi Piiduru, ");
INSERT INTO ntpNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ismaacʌdʌ ʌmai Simuñi quiidiʌrʌ gʌuuliñaca. Ʌgai ʌrvaqueetatadami dai gʌʌ suudagi ugidiana oidaga. ɅPiiduru gʌaagidamu istumaasi gʌaagai pʌsiduñiagi ―astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aidʌsi ii ʌDiuusi tʌaañicarudʌ taidʌ ʌCornelio vaí gooca gʌpipiooñiga dai ʌmo sandaaru ismaacʌdʌ siaa duutudai Diuusi vaidʌ ʌCornelio baigʌʌliditai nʌidiña. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Dai aagidi vʌʌsi istumaasi tʌʌ ʌgai. Dai gooquiʌrʌ ootoi Jopamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Dai siaadiqui aidʌsi camiaadimitadai ʌgai Jopʌrʌ dan duucu ʌʌsi tʌsai ʌPiiduru vaaqui daama daida mamada agai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dai ʌgai aliʌ biuugimucatadai dʌmos quiaa bai vuiididitadai cuaadagai, tai gʌmaasitu ʌgai vuitapi ʌmo istumaasi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tʌʌ ʌgai isgʌcupioco tʌvaagi dai dʌvʌʌrapi uucami tʌaapanʌi ʌmo istumaasi ʌpa maasi ʌmo gʌʌ tua icuusi vʌmaacova siisisodʌ vuupuli. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Dai ami tua icuusiʌrʌ daraitugai naana maasi cʌcʌisi maaco taataracami dai gʌgʌr coocoyi dai ujuurugi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dai amaasi caʌ ʌgai ʌmo ñiooqui ismaacʌdʌ itʌtʌdai: ―Cʌquivañi Piiduru dai cooda dai uga ―astʌtʌdai ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Taidʌ ʌPiiduru aa noragi daidʌ itʌtʌdai: ―Chio tʌaanʌdami, tomali ʌmo imidagai maitʌrugacami aanʌ istumaasi judidíu maiviaa oigaragai iscuaadagi ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Taidʌ ʌñiooqui ʌpamu ñioo daidʌ itʌtʌdai: ―Istumaasi Diuusi aagai saidʌ ʌrcuaadagai maitʌaagai pʌspocaitiadagi sai maicʌʌgadu ―astʌtʌdai ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ʌtua icuusi vaicojo tʌvai daida tʌsai tʌvaagiamu ʌpamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Aidʌsidʌ ʌPiiduru tʌtʌgitoitadai istʌiya ʌlidi ʌgai ismaacʌdʌ gʌmaasitu vuitapi, tai quitaagiña aayi ʌcʌcʌʌli Cornelio ojootosadʌ gatʌcacaimi ʌgai siaaco oidaga Simuñi daida aayi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dai aʌcai gʌgʌrʌ gatʌcacai sabai ami gʌuuliñacatadai ʌmo cʌʌli Simuñi Piiduru tʌʌgiducami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Dai quiaa tʌtʌgitoitadai ʌPiiduru ʌgiʌrʌ ismaacʌdʌ vuitapi gʌmaasitu, taidʌ Diuusi Ibʌadʌ itʌtʌdai: ―Dañi gʌgaagiava vaica cʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tʌvañiñi dai oida dai maivuaamʌ ʌliatugada aanʌanta ootoi ―astʌtʌdai Diuusi Ibʌadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Taidʌ ʌPiiduru tʌvai dai ii siaaco guucacatadai ʌcʌcʌʌli Cornelio ojootosadʌ daidʌ itʌtʌdai: ―Aanʌana ʌgai mʌsmaacʌdʌ gaagai aapimʌ. ¿Mʌtumaasi aagaimi? ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Taidʌ ʌcʌcʌʌli aa noragi daidʌ itʌtʌdai: ―Gʌrbaitʌcʌaacamiga Cornelio atgʌrootoi. Ʌgai ʌrʌmo cʌʌli cʌʌ tuigacami dai siaa duutudai Diuusi. Dai vʌʌsi ʌjudidíu cʌʌgacʌrʌ nʌidi dai oigʌdai. Tai ʌmo Diuusi tʌaañicarudʌ aagidi ʌCornelio sai gʌvaidana pʌsai aapi imʌna quiidiamu sai ʌgai caʌcana pʌstumaasi viaaca isaagidagi ―astʌtʌdai ʌcʌcʌʌli. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Taidʌ ʌPiiduru miaadʌgi, tai ʌgai anaasi vii aidʌ tucarʌ ʌPiiduru ʌʌmadu. Dai siaadiqui iji tai oí ʌPiiduru dai oí ʌʌpʌ ʌʌmoco ʌvaavoitudadami Jopʌrʌ oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dai siaadiqui aayi ʌgai Sesareeʌrʌ siaaco nʌnʌracatadai ʌCornelio ʌʌmadu muidutai aaduñdʌ dai aa ismaacʌdʌ cʌʌga ʌʌmaducatadai ʌgai vʌʌsi vapai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aidʌsi aayi ʌPiiduru quiiyʌrʌ tai vuusai ʌCornelio dai miaadʌgida agai dai vuidʌrʌ gʌtootonacʌdʌ cʌquiva dai siaa duutuda agaitadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dʌmos ʌPiiduru cʌquivatu daidʌ itʌtʌdai: ―Cʌquivañi. Aanʌ anʌʌpʌ ʌrcʌʌli gʌʌpan duucai ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Dai apiaaatagaimi ʌgai ʌCornelio ʌʌmadu dai vaa tuucavi dai ami tʌʌ mui oodami ismaacʌdʌ gʌnʌmpaidacatadai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Amaasi ʌPiiduru itʌtʌdai ʌoodami: ―Aapimʌ cʌʌga maatʌ isjudidíu vaavoidaragadʌ maitamaacai oigaragai isuurapʌcʌdagi ʌma maa ñioocadami tomali isvapacʌdagi quiidiʌrʌ. Dʌmos Diuusi giñmaatʌtuli ansai dagitona aanʌ govaavoidaragai. Dai sioorʌ Diuusi cʌʌgacʌrʌ nʌidi aanʌ maiviaa istuisi gajiaadʌrʌ vipiaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Cascʌdʌ mosgiñvaí antai maiñioocacai mʌʌcadʌrʌ ii. Dai maatʌca iñʌlidi aanʌ tʌimʌsidʌ giñvaí ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Taidʌ ʌCornelio aa noragi daidʌ itʌtʌdai: ―Casi ʌpʌdui maacova tasai icaduucu lienʌ coi gʌʌsʌco tasai tanasi giñquiiyʌrʌ daacatadai aanʌ dai gamamadaitadai maitaugacai, dai tʌʌ aanʌ ʌmo cʌʌli vai dadadacʌi yuucusidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Vaidʌ ipiñtʌtʌdai: “Cornelio, Diuusi caʌ gʌmamadaraga dai maatʌ ʌʌpʌ istumaasi ivueeyi aapi soicʌital soituutuigami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ootosañi tudu Jopamu sioorʌ vaidagi ʌSimuñi Piiduru ʌmai Simuñi quiidiʌrʌ avʌuuliñaca. Ʌgai ʌrvaqueetatadami dai gʌʌ suudagi ugidiana oidaga. Dai siʌʌscadʌ divia ʌgai gʌaagidamu ʌmo istumaasi iñtʌtʌdai ʌcʌʌli”, ascaiti ʌCornelio. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Cascʌdʌ otoma ootoi aanʌ mʌsai gʌgaagana, dai aapi cʌʌga dui diviacai. Dai sivi tami daraaja aatʌmʌ dai siaa duutudai Diuusi dai caʌca ʌrʌlidi ʌñiooqui ismaacʌdʌ gʌrootosi Diuusi aapicʌdʌ ―astʌtʌdai ʌCornelio. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Amaasi gʌaagacai ñioo ʌPiiduru daidʌ itʌtʌdai: ―Sivi camaatʌ nʌidi aanʌ isDiuusi maivaamioma cʌʌgacʌrʌ nʌidi ʌʌmoco, ʌgai vʌʌscatai ʌmadugan duucai nʌidi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Diuusi aliʌ cʌʌgacʌrʌ nʌidi tomastuma oodami ismaacʌdʌ siaa duutudai dai maisoimaasi ivuaadagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diuusi ootosi ʌmo ñiooqui ʌjudidíu Suusi Cristocʌdʌ sai cʌʌgacʌrʌ oidacana Diuusi vuitapi dai oodami vuitapi daidʌ Suusi Cristo ʌrbaitʌcʌaacamigadʌ vʌʌsi oidi daama oidacami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aapimʌ cʌʌga maatʌ istumaasi ʌpʌdui judidíu dʌvʌʌragadʌrʌ, aidʌsi casi gaaagidi ʌVuaana Diuusi ñiooquidʌ dai casi gavapaconacai vʌʌsi gomaasi Galileeaiñdʌrʌ gʌaaga. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dai cʌʌga maatʌ aapimʌ ʌʌpʌ isducatai maa Diuusi ʌSuusi ismaacʌdʌ Nasareetʌrʌ oidacatadai guvucadadʌ Diuusi Ibʌadʌ, dai isducatai aimʌraitai cʌʌga ivuaadana ʌgai dai duduaaidiña vʌʌscatai ismaacʌdʌ soimaa taatacana Diaavora tʌtʌaañicarudʌcʌdʌ. Diuusi Ibʌadʌ ʌʌmadu daacatadai ʌSuusi cascʌdʌ pomaasi ivuaadana ʌgai. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Dai aatʌmʌ ʌrnʌijadami vʌʌsi istumaasi ivuaadana ʌSuusi siʌʌsi Judeea dʌvʌʌriʌrʌ ʌcaasi Jerusaleenʌrʌ ʌʌpʌ mʌtai gooquiʌrʌ curusiaba siisa dai muaa. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Dʌmos Diuusi bo vaica tasaicʌdʌ duaacali ʌpamu, dai gʌrmaa oigaragai tʌstʌgiagi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Dʌmos maisiu vʌʌsi oodami maa ʌgai oigaragai istʌgiagi mosʌca aatʌmʌ ismaacʌdʌ Diuusi ʌcovai vuvaitu ʌʌquioma abiaadʌrʌ tʌsaidʌ ʌrnʌijadamicana dai aatʌmʌ ʌʌmadu gauu dai gaii caduaacacai ʌgai coidadʌ saagidaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dai ʌgai gʌrtʌjai tʌsai aagidana oidigi daama oidacami Diuusi ñiooquidʌ dai aagidana ʌʌpʌ tʌstumaasi nʌidiña dai tʌstumaa caʌcana sai Diuusi aagidi ʌSuusi sai ʌgai nʌidana ʌcoidadʌ dai ʌduduaacʌdʌ ismaacʌdʌ ʌrcʌʌga ivuaadami dai ismaacʌdʌ ʌrmaicʌʌga ivuaadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ʌʌquioma abiaadʌrʌ aagai vʌʌsi ʌDiuusi ñiñiooquituldiadamigadʌ ʌSuusi dai pocaiti sai sioorʌ vaavoitudagi isʌSuusi ʌrcʌʌgacʌrʌ vuviadami Diuusi oigʌlda agai vʌʌsi soimaascamigadʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Quiaa ñioocaitadai ʌPiiduru, tai divia Diuusi Ibʌadʌ dai ʌʌmadu daaca agai vʌʌscatai ismaacʌdʌ caʌ istumaasi aagaitadai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Taidʌ ʌjudidíu vaavoitudadami ismaacʌdʌ oiditadai ʌPiiduru camaitʌʌ isducatai gʌntʌtʌgituagi nʌiditai isDiuusi Ibʌadʌ divia dai ʌʌmadu daaca agai ʌʌpʌ ʌgai ismaacʌdʌ maitʌrjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dai caʌ ʌgai isnaana maasi ñiooqui ñioocai ʌgai dai siaa duutudai Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Amaasi ʌPiiduru itʌi: ―¿Baigas potʌʌna aapimʌ isidi oodami maitistutuidi isvapacoñicagi canʌidi aapimʌ isdivia Diuusi Ibʌadʌ vʌʌscatai ʌʌmadu poduucai isduucai divia aatʌmʌ gʌrʌʌmadu? ―ascaiti ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Amaasi tʌjai ʌPiiduru ʌoodami sai gʌnvapaconana isduucai gatʌjai Suusi Cristo. Dai gooquiʌrʌ ʌgai goguaama oi ʌPiiduru sai anaasi viʌʌna chiʌʌqui tasai. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Amaasi ʌojootosicami ʌʌmadu ʌvaavoitudadami ismaacʌdʌ Judeeʌrʌ daraajatadai maí isʌgai ismaacʌdʌ maitʌrjudidíu vaavoitu Diuusi ñiooquidʌ ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dai aidʌsi ʌpamu ii ʌPiiduru Jerusaleenamu vaidʌ ʌjudidíu ismaacʌdʌ ʌrvaavoitudadami ñiooquidi, ");
INSERT INTO ntpNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","daidʌ itʌtʌdai: ―¿Tuipʌsi diviji ismaacʌdʌ maitʌrjudidíu dai ʌʌmadu gauu? ―astʌtʌdai ʌjudidíu vaavoitudadami ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Taidʌ ʌPiiduru aagidi vʌʌsi isducatai ʌpʌdui daidʌ itʌtʌdai: ");
INSERT INTO ntpNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Aanʌ Jopʌrʌ daacatadai, dai aidʌsi gamamadaitadai aanʌ tʌʌ aanʌ ʌmo istumaasi ʌpa maasi ʌmo gʌʌ tua icuusi, vai tʌvaagiaiñdʌrʌ tʌaapanʌi dai aajʌi mʌʌca siaaco daacatadai aanʌ dai vʌʌ maacova siisisodʌ vuupuli ʌtua icuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Dai aidʌsi cʌʌga nʌnʌidi aanʌ astumaasi oidaga ʌraana, vai ami daraajatadai cʌcʌisi maaco taataracami, dai coocoyi dai ujuurugi ʌʌpʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dai caʌ aanʌ ʌmo ñiooqui vaidʌ ipiñtʌtʌdai: “Cʌquivañi Piiduru dai cooda dai uga”. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dʌmos aanʌ itʌtʌdai: “Chio tʌaanʌdami tomali ʌmo imidagai anmaivapasai aanʌ giñtʌñiʌrʌ istumaasi judidíu maiviaa oigaragai iscuaadagi”, antʌtʌdai aanʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tai amaasi ʌñiooqui tʌvaagiaiñdʌrʌ ʌpamu giññiooqui daidʌ ipiñtʌtʌdai: “Istumaasi Diuusi aagai saidʌ ʌrcuaadagai maitʌaagai pʌspocaitiadagi sai maicʌʌgadu”, caiti ʌñiooqui. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Taidʌ ʌtua icuusi vaicoojo tʌvai dai ʌpamu tʌsai tʌvaagiamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Dai quiaa vaaqui daama daacatadai aanʌ tai ami dada vaica cʌcʌʌli daidʌ giñgaagaimi ʌgai ʌrojootosicami Sesareeaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Taidʌ Diuusi Ibʌadʌ giñaagidi ansai oidana maivuaam iñʌliatugaitai, tai idi naadami vaavoitudadami giñoí ʌʌpʌ dai vʌʌscatai aatʌmʌ vaapa ʌmo cʌʌli quiidiʌrʌ, ");
INSERT INTO ntpNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ismaacʌdʌ gʌraagidi isducatai tʌʌ ʌgai ʌmo Diuusi tʌaañicarudʌ sai cʌʌca daidʌ itʌtʌdai: “Ootosañi cʌcʌʌli Jopamu vai mʌʌ vaidana Simuñi Piiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Siʌgai gʌaagidamu isducatai cʌʌgacʌrʌ vuusia aapi ʌʌmadu vʌʌsi gʌaaduñi”, astʌtʌdai ʌDiuusi tʌaañicarudʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Dai aidʌsi giñaagacai ñiooqui aanʌ divia Diuusi Ibʌadʌ vʌʌscatai ʌgai ʌʌmadu poduucai isducatai divia aatʌmʌ gʌrʌʌmadu tuucamidʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Amaasi antai tʌgito aanʌ iscaiti gʌrtʌaanʌdami: “Vaavuava sidʌ ʌVuaana suudagicʌdʌ gavapacoi dʌmos vapacoñicamu aapimʌ Diuusi Ibʌadʌcʌdʌ sai ʌgai gʌnʌʌmadu daaca agai”. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","IsDiuusi maa ʌgai ʌʌpʌ istumaasi gʌrmaa aatʌmʌ ismaacʌdʌ vaavoitu Suusi Cristo ¿noorʌ aanʌ sivuidʌrʌ ñioocaiña Diuusi? ―astʌtʌdai ʌPiiduru. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Aidʌsi caʌ imaasi ʌvaavoitudadami ismaacʌdʌ Jerusaleenʌrʌ daraajatadai camaiñiñio ʌPiiduru vui. Mossiaa duutudaimi Diuusi daidʌ icaiti: ―Iscapovʌdui di isDiuusi maa oigaragai ismaacʌdʌ maitʌrjudidíu ʌʌpʌ isʌma duucai gʌntʌtʌgituagi ʌgai dai poduucai vʌʌscʌrʌ oidacagi Diuusi ʌʌmadu ―ascaiti ʌjudidíu. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aidʌsi muaa ʌoodami ʌTiivañi, gʌnaagacai soi vuimi ʌʌpʌ ʌgaa vaavoitudadami, tai ʌʌmoco dʌgavunu voopoi asta Penisiʌrʌ uucami dai aa Sipiliamu dai aa Antioquiiʌrʌ uucami dai ami aagidi Diuusi ñiooquidʌ mosʌca ʌjudidíu dai aa oodami gia chio. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Dʌmos ami Antioquiiʌrʌ dada aa vaavoitudadami Sipiliaiñdʌrʌ dai Sireñiaiñdʌrʌ dai aagidi ʌoodami dai ismaacʌdʌ maitʌrjudidíu ʌʌpʌ isSuusi Cristo ʌrcʌʌgacʌrʌ vuviadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Diuusi Ibʌadʌ ʌʌmadu daacatadai ʌvaavoitudadami dai poduucai muidutai ʌgaa dagito gʌnʌʌqui vaavoidaraga dai vaavoitu isSuusi Cristo ʌrcʌʌgacʌrʌ vuviadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Dai aidʌsi maí ʌvaavoitudadami Jerusaleenʌrʌ imaasi ootoi ʌBernabé asta Antioquiiʌrʌ uucami. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Dai aʌcai Bernabé tʌʌ isducatai Diuusi aliʌ cʌʌgacʌrʌ nʌiditadai ʌvaavoitudadami dai aliʌ baigʌʌli, dai maa ñiooqui daidʌ itʌtʌdai sai vʌʌsi gʌnibʌdacʌdʌ apiavaavoitudaiña Diuusi. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé ʌrʌmo cʌʌli cʌʌ tuigacami dai vʌʌsi gʌibʌdacʌdʌ vaavoitudaiña ʌgai vai Diuusi Ibʌadʌ ʌʌmadu daacatadai dai poduucai muidutai vaavoituli ʌgai Diuusi ñiooquidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dai gooquiʌrʌ ii Bernabé Tarsuamu dai gaaga agai ʌSaulo, dai tʌʌgacai vaidacai Antioquiiamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Dai anaasi daraaja ʌgai ʌvaavoitudadami ʌʌmadu ʌmo uumigi suudacami dai gamamaatʌtuldi Diuusi ñiooquidʌ. Antioquiiʌrʌ ʌgai siaaco ʌʌpʌga gʌaaga goñiooqui iscristianu aagadagi vaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aidʌ tuigaco iji ʌʌmoco Diuusi ñiñiooquituldiadamigadʌ Jerusaleenaiñdʌrʌ Antioquiiamu. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tai ʌmoco Agavo tʌʌgiducami cʌquiva ʌvaavoitudadami saagida daidʌ itʌtʌdai sai imia agai ʌmo gʌʌ biuugigai vʌʌsi oidigi daama. Gomaasi maatʌcatadai ʌgai aagiditai Diuusi Ibʌadʌ, tai sʌʌlicʌdʌ povʌdui aidʌsidʌ ʌrbaitʌcʌaacamicatadai ʌClaudio. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Taidʌ ʌvaavoitudadami Antioquiiʌrʌ gʌnaagi dai ootosda agai soiñi ʌgaa vaavoitudadami Judeeʌrʌ, dai ʌmpagi vʌʌscatai siʌʌjʌsi istui. ");
INSERT INTO ntpNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Dai ootosi ʌtʌtʌaanʌdamigadʌ ʌvaavoitudadami Judeeʌrʌ Bernabécʌdʌ dai Saulocʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Aidʌ tuigaco ʌraí Eroodʌsi gʌaagacai soi vuaadatadai ʌvaavoitudadami. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dai gatʌjai muaaragai ʌJacovo Vuaana siʌʌgidʌ ʌmo mastaicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Dai aidʌsi tʌʌ ʌgai isaliʌ baigʌnʌʌli ʌjudidíu pomaasi iduucai ʌgai maisapicami bʌi ʌʌpʌ ʌPiiduru. Gomaasi ʌpʌdui siaa duudagʌrʌ istuigaco tʌtʌgitoiña ʌjudidíu aidʌsi Diuusi cʌʌgacʌrʌ vuvaitu Ejiipituaiñdʌrʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Aidʌsi cabʌi ʌgai ʌPiiduru maisacariʌrʌ cuu siaacoga sʌʌlicʌdʌ cʌʌga nuucadicatadai maamacova ʌmapai ajioopaitadai ʌsandaaru maacovapʌrʌ dai nuucada ʌmaamaisapicʌdʌ. Cadaivunucai ʌsiaa duudagai ʌEroodʌsi vuusaida ʌliditadai ʌPiiduru maisacaruaiñdʌrʌ dai vʌʌsi ʌoodami vuitapi gatʌaañia agaitadai muaaragai. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Vaidʌ ʌPiiduru maisapicatadai dai cʌʌga nuucadicatadai. Vaidʌ ʌvaavoitudadami sʌʌlicʌdʌ gamamadaitadai ʌgai vʌʌtarʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Aidʌsi vuusaida agaitadai ʌEroodʌsi ʌPiiduru ʌoodami vuitapi aidʌ tacavioma tucarʌ coosocatadai ʌPiiduru vai aipadʌrʌ guucacatadai gooca sandaaru nuucadacami vaidʌ ʌPiiduru vulicatadai gooca cadeenacʌdʌ ʌvʌgoocai sandaaruaiñdʌrʌ, dai aa sandaaru quiidigamadʌrʌ guucacatadai dai nuucadacatadai ʌmaamaisapicʌdʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tai todian duucai gʌmaasitu ʌmo Diuusi tʌaañicarudʌ ʌPiiduru vuitapi dai vʌʌsi maasiuli ʌmaisacarui daidʌ ʌDiuusi tʌaañicarudʌ taata ʌPiiduru ʌmaapiadʌrʌ dai nʌnʌitu daidʌ itʌtʌdai: ―Otoma ivañigi ―astʌtʌdai. Tai otoma uupai ʌcadeena ismaacʌdʌ ʌcʌdʌ vulicatadai ʌPiiduru noonovidʌ. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Taidʌ ʌDiuusi tʌaañicarudʌ itʌtʌdai: ―Gʌisatudañi gʌgivuura dai gʌaada gʌsusuusaca ―astʌtʌdai. Dai aidʌsi capodui ʌPiiduru taidʌ itʌtʌdai ʌDiuusi tʌaañicarudʌ: ―Gʌtuiñi gʌsuaa daidʌ iñoida ―astʌtʌdai. ");
INSERT INTO ntpNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Amaasi vuusai ʌD