﻿USE sofia;
DROP TABLE IF EXISTS sofia.ntj_vpl;
CREATE TABLE ntj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ntj_vpl WRITE;
INSERT INTO ntj_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ngarnmanypalpi Mama Kuurrtu manta yilkaritarrartu palyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nyangka kutjupa-kutjupa ngaranytjamaalpa mantakutju ngaralanytja. Nyangka kapi yirrala purlkanya manta katalarrawana ngarrirra parrayurrirranytja. Nyangka munga purlkanyalu tjutura kanyiranytja. Nyangka Mama Kuurrku Kuurti pirriyapirinypa parrapitjalayintja kapi katuwana. ");
INSERT INTO ntj_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nyangka Mama Kuurrtu watjarnu, “Tilirriwa.” Nyangka mularrpartu tilirringu. ");
INSERT INTO ntj_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","5","Nyangka nyakulalpi watjarnu, “Yuwa, walykumunu ngarala.” Palunyalu tili palunyanya tjapirnu, “Karlarla”. Palunyalu tjarrarnu karlarla, munga mawurntalpa ngaralatjaku. Nyangka munga ngaralanyangka tjapirnu, “Munga”. Nyangka ngurra kutjutjanulu kapilu manta tirtu tjutura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nyangka Mama Kuurrtu watjarnu, “Ngururrpa yilkarirri nyangkayi kapi mawurntalpa-mawurntalpa ngara.” Nyangka mularrpartu palunyapirinypa ngarangu. ");
INSERT INTO ntj_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tjiinya kapi kutjupatjarra pakarnu katalarrawana ngarrirranytja. Nyangka kapi kutjupatjarranya mantawana ngarrirranytja. Tjiinya Mama Kuurrtu watjannyangka palunyapirinypa tjarrarringu ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nyangka Mama Kuurrtu yilkari ngaralanyangka tjapirnu, “Yilkari.” Nyangka ngurra kutjarratjanulu ");
INSERT INTO ntj_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mama Kuurrtu kapi watjarnu, “Tjarrarriwa-ya ngarri nyangkayi manta yartakarri.” Nyangka mularrpartu manta yartakarringu. ");
INSERT INTO ntj_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nyangka tjapirnu, “Manta” puru kutjupanya “Kapi Yirrala Purlkanya”. Palunyalu nyakulalpi watjarnu, “Yuwa, walykumunu ngarala.” ");
INSERT INTO ntj_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nyangka Mama Kuurrtu watjarnu yukiri kutjupa-kutjupa pirni mantanguru paka-pakaltjaku tjiinya yukiri kutjupa-kutjupa yurninytjarra puru warta kutjupa-kutjupa mirrkatjarra ngaralatjaku. ");
INSERT INTO ntj_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nyangka mularrpartu-ya paka-pakarnu ngaralanytja. Nyangka Mama Kuurrtu nyakulalpi watjarnu, “Yuwa, walykumunu-ya ngarala.” ");
INSERT INTO ntj_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","15","Nyangka ngurra marnkurrtjanulu Mama Kuurrtu watjarnu tjirntu, kirnara puru pirntirritarrartu-ya yartakarritjaku. Nyangka-ya mularrpartu yartakarringu ngaralanytja. Nyangka Mama Kuurrtu watjarnu, “Yuwa, tjirntu pakaralpi yartakara kanyirayilku ma-tjarrparralpi mungarriku. Nyangka kirnaralulpi mungangka yartakara kanyinma. Nyangka yarnangu pirnilu-ya tjirntu, kirnara, pirntirritarrartu nyakula tjurrkurltu watjanma tjiinya nyinnga, pirriya-pirriya, kurlikutu ngamurrinyangka.” Nyangka mularrpartu palunyapirinypa yartakarringu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","18","Tjiinya Mama Kuurrtu tili purlkanya kutjarra palyarnu tjirntu, puru kirnara. Puru pirntirritarrartu palyarnu wantingu. Tjiinya tili yilkaringkatja tjunu manta yartakara kanyiratjaku. Tjiinya tjirntu tjunu pakara karlarlara kanyira ma-tjarrparratjaku. Palunyalu kirnara tjunu mungangka yartakara kanyiratjaku. Nyangka Mama Kuurrtu nyakulalpi watjarnu, “Yuwa, walykumunu-ya ngarala.” ");
INSERT INTO ntj_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nyangka ngurra kutjarra-kutjarratjanulu ");
INSERT INTO ntj_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mama Kuurrtu watjarnu kapingkatja kutjupa-kutjupa kapinguru yartakarritjaku. Nyangka-yayi kapiwana parrapitjalayinma. Puru watjarnu tjurlpu kutjupa-kutjupa-ya yartakarringkula yilkariwana parrapitjalayiltjaku. Nyangka-ya mularrpartu yilkariwana parrapitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tjiinya Mama Kuurrtu kapingkatja kutjupa-kutjupa palyarnu purlkanya, kurlunypatarrartu. Palunyalu tjurlpu kutjupa-kutjupa palyarnu yilkariwana-ya parrapitjalayiltjaku. Palunyalu nyakulalpi watjarnu, “Yuwa, walykumunu-ya parrapitjalayirni.” ");
INSERT INTO ntj_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Palunyalu-tjananya watjarnu kurlunypa pirnitjarrarringkula-wanarayiltjaku. Tjiinya-tjanampa walykumunu watjarnu. Nyangka-ya mularrpartu pirnirringkula-wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nyangka ngurra 5-tjanulu ");
INSERT INTO ntj_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Mama Kuurrtu watjarnu yanamulpa kutjupa-kutjupa mantanguru yartakarritjaku. Nyangka-ya mularrpartu yartakarringu nyinarranytja. Tjiinya kutjupatjarra-ya ngulytju, nyangka kutjupatjarra-ya ngupanu nyinarranytja. Nyangka-ya kutjupatjarra tjuninguru parrapitjalayintja. Tjiinya Mama Kuurrtu yanamulpa pirninyartu palyarnu. Palunyalu nyakulalpi watjarnu, “Yuwa, walykumunu-ya ngarala.” ");
INSERT INTO ntj_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nyangka Mama Kuurrtu watjarnu, “Kuwarrinya-la yarnangu ngayunyapirinypa-lanku palyala. Nyangka-yayi yanamulpa pirniku puurrpa nyinama. Tjiinya kuka kapingkatjaku, tjurlpuku, yanamulpa ngulytjuku, ngupanukutarrartu puru yanamulpa kutjupa-kutjupakutarrartu puurrpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nyangkalta-tjananya yarnangu palyarnu, wati minyma. Tjiinya palyarnu palunyala yarangka-ya nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Palunyalu-tjanampa walykumunu watjarnu, “Nyuntulu-yan tjilku pirnitjarrarringkula-wanarayinma. Nyangka-tjanampanku tjamu kaparlipirti nyinarra-wanarayinma ngurra yarla lipiwana. Palunyalu-yayi manta lipiwanalu puurrarringkulalpi kanyinma. Puru-yayi puurrpa nyinama kuka kapingkatjaku, tjurlpuku, puru yanamulpa pirnikutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Puru Mama Kuurrtu-tjananya ngaapirinypa watjarnu, “Kulila-ya. Ngayulu-tjanamparnanku yurninypa kutjupa-kutjupa puru mirrka wartangkatja kutjupa-kutjupa pirni tjunu ngalkulatjaku-yan. ");
INSERT INTO ntj_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Palunyalu-tjanamparna yanamulpa pirniku puru tjurlpu pirniku tjunu yukiri puru warta nyarlpitjarra tjiinya mirrka-yanku ngalkulatjaku.” Yuwa, Mama Kuurrtu watjannyangka palunyapirinypa ngarangu. ");
INSERT INTO ntj_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nyangka Mama Kuurrtu pirninyartu parranyakulalpi watjarnu, “Yuwawu! Pirninyartu walykumunu ngarala.” Tjiinya palyara-wanarayirnu ngurra 6-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yuwa, Mama Kuurrtu manta yilkari puru mantangkatja yilkaringkatja palyarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Palunyalu ngurra 6-tjanu waarka wiyarringkulalpi nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Palunyalu watjarnu ngurra 6-tjanu tjirntu kutju miirl-miirlpa tirtu ngaralatjaku tjiinya waarka wiyalu-ya Mama Kuurrnga marninypungkulatjaku. Tjiinyamarntu pirninyartu palyarnu wiyaralpi ngurra 6-tjanu waarkamaalpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yuwa, palunyapirinypa Mama Kuurrtu manta yilkari palyarnu. Nyangka tjiinya Mama Kuurrtu manta yilkari palyarnu wantinyangka ");
INSERT INTO ntj_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","yukiri wartatarrartu pakara ngaranytjamunurtu tjiinyamarntu Mama Kuurrtu kapi wiyantjamunungka. Nyangka kutjupa nyinanytjamunurtu manta tjawara yukiri pakaltjingalkitja. ");
INSERT INTO ntj_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nyangka kapi manta kaninytjarra ngarrirranytjalu tulykura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nyangka Mama Kuurrtu manta mantjiralpi wati palyarnu ngarritjunu. Palunyalu-lu mulyanguru puurnu. Nyangka wankarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nyangka Mama Kuurrtu kaatanpa palyarnu kakarrara, ngurra yini Yiitanta. Palunyalu wati palunyanya nyinatjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Palunyalu warta walykumunu pirninya mirrka kutjupa-kutjupatjarra pakaltjingarnu wantingu. Nyangka ngururrkutjarra warta kutjarra-pula ngaralanytja. Tjiinya warta kutju ngaralanytja ngalkula wanka tirtu nyinarra-wanarayiltjaku. Nyangka warta kutjupanya ngaralanytja ngalkula pina taparlarrara nintipuka nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nyangka ngurra nyarra Yiitantawana kapi warla purlkanya kukurrmaranytja. Palunyalu warta pirninya wanka kanyiranytja. Palunyalu kaatanpa wayirntaralpi kutjunguru tjarra-tjarrarringkulalpi kutjarra-kutjarra ma-ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Tjiinya kapi warla kutju yini Piitjannga parrakatingu ngurra yini Yapilalawana. ");
INSERT INTO ntj_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nyangka ngurra palunyangkatja-ya mantjilpayi yapu walykumunu pirni puru kawurlpatarrartu. Nyangka-ya warta parnti walykumunutjarra ngarala-warni. ");
INSERT INTO ntj_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nyangka kapi warla kutjupanya yini Kiyannga kukurrmaranytja ngurra yini Kuutjulawana. ");
INSERT INTO ntj_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nyangka kutjupanya kapi yini Tayikurinya kukurrmaranytja ngurra yini Yatjiriyala kakarrarawana. Nyangka kutjupanya yini Purayitinya. ");
INSERT INTO ntj_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nyangka Mama Kuurrtu wati palunyanya katingu kaatanpangka nyinatjuralpi watjarnu miranykanyira kanyiratjaku puru manta tjawara mirrka pakaltjingaltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Palunyalu watjarnu, “Palyan warta kutjupa-kutjupa pirningkatja mirrka ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Nyangka warta kutju miirl-miirlpa ngarala. Palunyangkatjan ngalkulalpi pina taparlarralku palunyalun nintipuka nyinama. Nyangka ngalkunytjamaaltu wantima. Ngalkulalpin mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nyangka Mama Kuurrtu watjarnu, “Wiya, kamu yamatjimaalpa wati ngaanya kutju nyinama. Ngayulu-rna yamatji palyaralpi nintilku tjiinya-pulanku ngaparrkulu yirringkaratjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Nyangka Mama Kuurrtu manta mantjiralpi yanamulpa, puru tjurlpu pirninyatarrartu palyarnu wantingu. Palunyalu-tjananya wati palunyakutu katingu ngaratjunu yini-tjananya tjapiratjaku. Nyangka-tjananya yini tjapira-wanarnu wantingu. Palunyalu purtu nyangu, “Yamatji-tju ngayuku nyinanytjamunurtu yirringkaratjaku-rni.” ");
INSERT INTO ntj_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nyangka Mama Kuurrtu wati palunyanya kunkuntjunu. Nyangka kunkunpa purlkanya ngarrirranyangka kantilypa kutju mantjiralpi marlakulu-lu yangatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Palunyalu kantilypa palunyanya mantjiralpi minyma palyarnu. Palunyalu katingu wati palunyakutu. ");
INSERT INTO ntj_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nyangka nyakulalpi watjarnu, “Yuwa, ngaanya yarnangu ngayunyapirinypa-rni palyarnu. Tjiinya tarrka yilytjanpa ngayunyamartatji mantjiralpi palyarnu. Nyangka-rna yini minyma tjapilku watingkatjamarntu mantjinnyangka.” Palunyapirinypa watilu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nyangka palunyanguru watilunku mama ngunytju wantirralpi kurringka lurrtjurringkupayi. Palunyalu-pula yarnangu kutjurringkulalpi nyinapayi. ");
INSERT INTO ntj_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nyangkalta-pula wati minyma kutjarranyartu nikirrpalya nyinarranytja kurntamaalpa. ");
INSERT INTO ntj_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nyangka Mama Kuurrtu yanamulpa pirninya palyarnu. Nyangka lirrukutju yayirninytju nyinarranytja yanamulpa pirningka munkarra. Palunyalu pitjangu minyma tjapirnu, “Mularrpa-muntanta Mama Kuurrtu watjarnu warta pirningkatja-pulan ngalkunytjamaaltu wantirratjaku?” ");
INSERT INTO ntj_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nyangka minymalu watjarnu, “Wiya, palya-litju warta pirningkatja mirrka ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Nyangka ngururrpa warta kutju miirl-miirlpa purlkanya ngarala. Tjiinya Mama Kuurrtu yaka-yakarnu palunyangkatja pampuntjamaaltu wantirratjaku mirrirritjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyangka lirrulu watjarnu, “Wiya, mirrirrikitjamunu-pulan. ");
INSERT INTO ntj_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tjiinya Mama Kuurrtu nintilu kulira tjiinya-pulan ngalkulalpi nintipukarriku, Mama Kuurrngapirinypa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nyangka minymalu warta palunyanya nyakulalpi kulirnu, “Yuwa, mularrpa mirrka walykumunu ngarala. Nyangka-tjinguru-rna ngalkulalpi nintipukarriku.” Nyangka mularrpartu minyma palunyalu mirrka mantjiralpi ngalangu. Palunyalu palunyaku kurriku nintirnu. Nyangka mularrpartu mantjiralpi ngalangu. ");
INSERT INTO ntj_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Palunyatjanu-pula pina taparlarraralpi-pulanku nyangu nikirrpalya ngaralanytjalu. Palunyalu-pula warta nyarlpi mantjiralpi wakarnu lurrtjurnu. Palunyalu-pulanku karilwanalu karrpiralpi tjuturnu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nyangka tjirntu tjarrpanyangka-pula kulirnu Mama Kuurrnga kaatanwana parrapitjalayinnyangka. Palunyangkalta-pula ngurlu kukurraarnu wartangka kumpiralpi nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nyangka Mama Kuurrtu wati tjapirnu, “Wanytjatjarringun?” ");
INSERT INTO ntj_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nyangka watjarnu, “Wiya, kulirnu-rnanta kaatanwana parrapitjalayinnyangka. Palunyatjanu-rna ngurlu kumpirnu, tjiinya-rna nikirrpalya nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nyangka Mama Kuurrtu tjapirnu, “Nganalunta watjarnu nikirrpalyan nyinarranyangka? Mirrka-muntan ngalangu warta miirl-miirltatja?” ");
INSERT INTO ntj_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nyangka watjarnu, “Wiya, minyma ngaa-rnin nintirnu, palunyalu-rni mantjiralpi nintirnu. Nyangka-rna mularrpartu ngalangu.” ");
INSERT INTO ntj_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nyangka Mama Kuurrtu minyma puru tjapirnu, “Nyaangurun palunyapirinypa palyarnu?” Nyangka watjarnu, “Wiya, lirrulu-rni mayunnyangka-rna mularrpartu ngalangu.” ");
INSERT INTO ntj_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nyangka Mama Kuurrtu lirrungka watjarnu, “Yuwa, kurralku-rnanta tjiinyamarntun minyma mayunnyangka. Nyangka ngaangurunku nyuntuku palyamunu tirtu ngarala-wanarayinma. Nyangka yanamulpa kutjupatjarraku walykumunu tirtu ngarama. Tjiinya ngaangurun tjuninguru parrapitjala manta ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nyangka nyuntulu-pulankun minymararra yanyan-yanyanpa tirtu nyinarra-wananma. Nyuntuku wartangkatja, puru minymaku wartangkatja-yankun tirtu yanyan-yanyanpa nyinama. Nyangka wati nyarra minymaku wartangkatjalunta ngula kata kantulku. Nyangka-lun nyuntulu tarta patjalku.” ");
INSERT INTO ntj_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nyangka Mama Kuurrtu minymangka watjarnu, “Nyuntulun mukala nyinarranytjalu pika purlkanya miranma. Nyangka tjilku ngarrikitjangkan kulilku pika purlkanya kaarrngaralanyangka. Purun kulilku wantirralpi kurriku tirtu mukurringama. Nyangkanku puurrpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Nyangka Mama Kuurrtu watingka watjarnu, “Tjiinyan nyuntulunku kurri kuliralpi mirrka miirl-miirlpa ngalangu. Palunyanguru-rnanku manta ngaanya kurralku. Nyangka tjilka-tjilka pirni-ya paka-pakalku. Nyangkan yurirlta waarka purlkanya palyanma mirrka pakaltjingara ngalkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tjiinyan mirrka ngalkukitjalu yakuripurulu waarka purlkanya palyarayilku mirrirringku. Tjiinyamarntu-rnanta mantangkatja palyarnu wantingu. Nyangkan mirrirringkulalpi marlakurtu mantarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nyangka Yatamalunku kurri yini Yiipanya tjapirnu. Tjiinyamarntu minyma palunyanya yarnangu pirniku-lampa kaparli nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nyangka Mama Kuurrtu yanamulpa minyarra mantjiralpi warntu-pulampa palyaralpi nintirnu. Nyangka-pula tjarrpatjunu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nyangka Mama Kuurrtu watjarnu, “Wiya-kulila-pula ngayunyapirinyarringu-lanya. Tjiinya-pula pina taparlarraralpi nintipuka nyinarra. Nyangka-pulanyarna witulku warta wanka kanyilpayinya-pula ngalkula wanka tirtu nyinatjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nyangka-pulanya mularrpartu witurnu kaatanpa Yiitannga wantirra-pula yankutjaku. Nyangka-pula mularrpartu pakara kutipitjangu. Nyangka watilu manta tjawara mirrka pakaltjingaranytja. Tjiinya Mama Kuurrtu-lu mantangkatja palyarnu wantingu. Nyangka manta palunyangkartu tjawara mirrka tjunkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nyangka Mama Kuurrtu nyarlpitjarra pirni ngaratjunu kaatanpangka kakarrara yangatjura-ya kanyiratjaku. Puru tjunu kunmarnu purlkanya waru tili wankatjarra parrayurrirratjaku. Nyangka-ya mularrpartu yangatjura kanyiranytja warta wanka kanyilpayinya-pula pampultjakutarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nyangka Yatamanya-pula Yiipanya kurrirarra ngarringu. Nyangka mukalarringu. Palunyalu katja kanyiralpi watjarnu, “Tjiinya-rni Mama Kuurrtu yirringkankunyangka-rna katja ngaanya kanyirnu.” Nyangka yini tjapirnu Kayinnga. ");
INSERT INTO ntj_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Palunyatjanu nyinarrayirnu puru katja kutjupanya kanyirnu yini Yayipulnga. Nyangka Yayipultu purlkarringkulalpi tjiipu miranykanyiranytja. Nyangka Kayintu manta tjawara mirrka pakaltjingaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Palunyalu nyinarrayirnu mirrka mantjira katingu Mama Kuurrku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Nyangka Yayipultu tjiipu warlangu kurranyu ngarrinytjanya ngurrkarntanu. Palunyalu pungkulalpi kuka karnpi purlkanyatjarra Mama Kuurrku nintirnu. Nyangka nyakulalpi pukurlarringu palunyapirinypa nintinnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Palunyalu Kayinku mirrka nyakulalpi paanypungu. Nyangka mirrparnarringkulalpi yiiku palyamunurringu. ");
INSERT INTO ntj_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nyangka Mama Kuurrtu tjapirnu, “Nyaatjanun mirrparnpa nyinarra? Nyaatjanungkan yiiku kutjuparringu? ");
INSERT INTO ntj_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tjingurun walykumunu palyantjatjanu pukurlpa yikarringama. Ngaanyan palyamunu palyannyangka kutjupa-kutjupa mamupirinytjunta nyakula. Tjiinyanta pitjangu muku-mukulkitja palyamunun palyaltjaku. Nyangka kulira wantima.” ");
INSERT INTO ntj_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nyangka Kayintunku marlanypa yarltirralpi watjarnu, “Kutipitja-li purtikutu.” Nyangka-pula mularrpartu kutipitjangu. Nyangka Kayintunku marlanypa pungu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nyangka Mama Kuurrtu-lu tjapirnu, “Marlanypanku ngaangka yaaltjirringu?” Nyangka watjarnu, “Wiya, ngurrpa-rna. Ngayuku-munta ngarala marlanypa-rna miranykanyiltjaku?” ");
INSERT INTO ntj_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nyangka Mama Kuurrtu watjarnu, “Wiya, nyuntulun palyamunu palyarnu. Tjiinyankun marlanypa pungu mirrirntanu. Nyangka yirrami mantangkarringu yularra-rni tjapira ngaparrtjika-rnanta pungkutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nyangka-rnanta kurralku. Nyangkan manta tjawara mirrka purtu pakaltjinganma. Tjiinyamarntunkun marlanyku yirrami mantangkanu. ");
INSERT INTO ntj_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Palunyangurun manta purtu walykumunura kanyinma. Tjiinyan mirrka purtu pakaltjingara nyangama. Palunyatjanunkun kaatanpa wantirra ngurramaalpa tirtu parrapitjalayinma.” ");
INSERT INTO ntj_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","14","Nyangka Kayintu watjarnu, “Wiya, palyamunu-rnin watjara. Nyuntulu-rnin witura tjiinya-rnanta wantirra tiwa yankutjaku, puru-rna ngurramaalpa tirtu parrapitjalayiltjaku. Nyangka kutjupalu-rni nyakulalpi mirri pungku.” ");
INSERT INTO ntj_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nyangka Mama Kuurrtu watjarnu, “Wiya, tjiinya nyuntunyanta-ya mirri pungkunyangka-rna ngayulu ngaparrtjika yarnangu 7-pa pungku.” Nyangka Kayinku ngalyangka parlkuntjunu wantingu nyakula-ya mirri pungkutjamaaltu wantirratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Nyangka Kayintu Mama Kuurrnga wantirra yanu Yiitanta kakarrara nyinarranytja ngurra yini Parrapitjapayila. ");
INSERT INTO ntj_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nyangka Kayintu kurri yarltirralpi katja yini Yiinakanya yartakanu. Palunyalu ngurra yiwarla purlkanya palyarnu. Palunyalu yiwarla tjapirnu yini Yiinakanya palunyaku katjawana. ");
INSERT INTO ntj_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nyangka Yiinakalu katja yini Yiratanya yartakanu. Nyangka Yiratalu katja yini Miyutjalnga yartakanu. Nyangka Miyutjaltu yartakanu katja yini Mitjutjalnga. Nyangka Mitjutjaltu katja yini Lamikinya yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Nyangka Lamikilu kurri kutjarra kanyiranytja yini Yayitanya, Tjiilanya. ");
INSERT INTO ntj_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Nyangka Yayitalu kanyirnu katja yini Tjapalnga. Palunyanya-tjanampa kutjutjamu nyinarranytja puluka tjiipu miranykanyilpayiku. Tjiinya-ya tiintitjarralu parrapitjala puluka pirninya miranykanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nyangka Tjapalku marlanypa yini Tjupalnga. Nyangka Tjupalnga kutjutjamu nyinarranytja-tjanampa kitaapirinypa pampura wangkatjingalpayiku puru puura wangkatjingalpayiku. ");
INSERT INTO ntj_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Nyangka minyma Tjiilalu katja kanyirnu yini Tjupal-Kayinnga. Nyangka purlkarringkulalpi yayintatja kutjupa-kutjupa palyalpayi: tjiinya kunmarnu, katju, yapu pungkupayinya, pirti tjawalpayinyatarrartu. Nyangka Tjupal-Kayinku nyarrumpa yini Naamanya. ");
INSERT INTO ntj_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Nyangka Lamikilunku kurri kutjarranya watjarnu, “Yayita, Tjiila, kulila-rnipula. Ngayulu-rna wati yangupala pungu mirrirntanu ngayunya-rni pungkunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tjiinya Kayinnga mirri pungkunyangka Mama Kuurrtu yarnangu 7-pa ngaparrtjika pungku mirrirntanku. Nyangka-rni ngayunya mirrirntankunyangka Mama Kuurrtu yarnangu pirni pungku mirrirntanku palunyangka munkarra.” ");
INSERT INTO ntj_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nyangka Yatamalu-pula Yiipalu katja kutjupanyalpi kanyirnu. Nyangka Yiipalu watjarnu, “Mama Kuurrtu-tju katja kutjupanya nintirnu tjiinya Kayintunku marlanypa mirri pungkunyangka.” Nyangka Yiipalu yini tjapirnu Tjiirrnga. ");
INSERT INTO ntj_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nyangka Tjiirrtu katja yini Yiinatjanya yartakanu. Nyangka palunyanguru-ya Mama Kuurrnga yini Yaawayinya warlkura marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yatamaku tjamupirti-ya ngaapirinypa nyinarranytja. Tjiinya Mama Kuurrtu yarnangu pirninya yungarrapirinypa palyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Tjiinya wati minyma palyaralpi walykumunu-pulampa watjarnu wantingu. Palunyalu yini ngaapirinypa “yarnangu” tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Nyangka Yatamanya nyinarrayirnu kurli-ra 130 ngaralanyangka katja yartakanu mamangka yarangka. Palunyalu yini Tjiirrnga tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Palunyalu nyinarrayirnu katja yurntalpa kutjupatjarranya puru yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Palunyalu kurli-ra 930 ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Nyangka-ra Yatamaku katja Tjiirrnga nyinarrayirnu kurli-ra 105-pa ngaralanyangka katja yini Yiinatjanya yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Palunyalu nyinarrayirnu katja yurntalpa kutjupatjarranya yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Palunyalu kurli-ra 912-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Nyangka Yiinatjanya nyinarrayirnu kurli-ra 90 ngaralanyangka katja yini Kiinannga yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Palunyalu nyinarrayirnu katja yurntalpa kutjupatjarranya yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Palunyalu kurli-ra 905-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Nyangka Kiinannga nyinarrayirnu kurli-ra 70 ngaralanyangka katja yini Maalalilnga yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Palunyalanguru nyinarrayirnu katja yurntalpa kutjupatjarranya puru yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Palunyalu kurli-ra 910-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Nyangka Maalalilnga nyinarrayirnu kurli-ra 65-pa ngaralanyangka katja yini Tjarirrnga yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Palunyalanguru nyinarrayirnu katja yurntalpa kutjupatjarranya puru yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Palunyalu kurli-ra 895-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Nyangka Tjarirrnga nyinarrayirnu kurli-ra 162 ngaralanyangka katja yini Yiinakanya yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Palunyalu nyinarrayirnu katja yurntalpa kutjupatjarranya yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Palunyalu kurli-ra 962 ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Nyangka Yiinakanya nyinarrayirnu kurli-ra 65-pa ngaralanyangka katja yini Matjutjalanya yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Palunyanguru nyinarrayirnu katja yurntalpa kutjupatjarranya yartakaranytja. Palunyalu Mama Kuurrta tirtu wangkarranytja yamatjingkapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Palunyalu kurli-ra 365-pa ngarangu. ");
INSERT INTO ntj_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Tjiinya Yiinakanya Mama Kuurrta pukurlpa wangkapayi. Palunyalu nyinarrayirnu wiyarringu. Nyangka-ya purtu nyangu. Tjiinyamarntu Mama Kuurrtu mantjira katingu. ");
INSERT INTO ntj_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Nyangka Matjutjalanya nyinarrayirnu kurli-ra 187-pa ngaralanyangka katja yini Lamikinya yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Palunyanguru nyinarrayirnu katja yurntalpa kutjupatjarranya puru yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Palunyalu kurli-ra 969-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Nyangka Lamikinya nyinarrayirnu kurli-ra 182 ngaralanyangka katja yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Palunyalu watjarnu, “Yuwa, tjilku ngaanguru-lan waarka purlkanya palyantjamaalarriku. Tjiinya Mama Kuurrtu manta kurrannyangka waarka purlkanya-lan palyaranytja. Nyangka tjilku ngaalu-lanya yirringkanku waarka purlkanya-lan palyaranyangka.” Nyangka tjilku palunyanya yini Nawanya tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nyangka Lamikinya puru nyinarra-wanarayirnu katja yurntalpa kutjupatjarranya yartakaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Palunyalu kurli-ra 777-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nyangka Nawanya nyinarrayirnu kurli 500-tjanulu katja marnkurrpa-tjananya yartakanu yini Tjiimanya, Yaamanya, Tjayipinya. ");
INSERT INTO ntj_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nyangka palunyangka yarnangu-ya pirnirringkula yanu manta lipiwanatarrartu nyinarranytja. Palunyalu-yanku yurntalpa kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Nyangka-ya wati yilkaringkatjalu-tjananya nyangu walykumunu-ya nyinarranyangka. Palunyalu-tjananya miratjura yarltirranytja. ");
INSERT INTO ntj_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nyangka Mama Kuurrtu watjarnu, “Ngaangkalpi-tjananyarna wantirranytja rawa nyinarra-wanarayiltjaku. Ngaanguru-rna kutjupanku. Nyangka-ya kurli ngatal-ngatalnguru nyinarra wiyarringama. Kamu-rna wantiku yarnangu pirninya-ya tirtu nyinarratjaku. Tjiinyamarntu-ya pirntirrimunu. Ngaanguru-ya nyinarrayilku kurli-tjanampa 120 ngaralanyangka mirrirringama.” ");
INSERT INTO ntj_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Palunyatjarralpi-ya wati tjangarapirinypa nyinarranytja. Tjiinya-ya wati yilkaringkatjalu kungka yarltirralpi katja palunyapirinypa yartakaranytja. Kutjulpirtulpi-ya nyinarranytja. Nyangka-ya kulira marninypungkula mirrawarnipayi. ");
INSERT INTO ntj_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nyangka Mama Kuurrtu nyangu yarnangu pirnilu-ya palyamunu palyaranyangka puru palyamunu tirtu kuliranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Palunyalu watjarnu, “Tjinguru-tjananyarna palyantjamaaltu wantima.” Tjiinya nyakulalpi tjuni tjurlpilyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Palunyalu watjarnu, “Wiya, mirrirntanku-tjananyarna yarnangu, yanamulpa puru tjurlpu pirninyatarrartu. Tjinguru-tjananyarna ngarnmanytjulpi palyantjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nyangka Mama Kuurrtu wati yini Nawanya nyakulalpi pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Tjukurrpa ngaanya Nawanyatjarra. Wati palunyalu katja marnkurrpa-tjananya kanyiranytja yini Tjiimanya, Yaamanya, Tjayipinya. Nyangka yarnangu pirninya-ya palyamunu nyinarranyangka Nawanyakutju walykumunu nyinarranytja. Tjiinya palyamunu palyantjamaalpa puru Mama Kuurrta wangkapayi yamatjingkapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Nyangka Mama Kuurrtu nyangu palyamunukutju-ya palyaranyangka puru-yanku nganyirrirringkula mirri pungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nyangka Mama Kuurrtu Nawala watjarnu, “Ngayulu-rna kulira yarnangu pirninya mirrirntara wiyalkitjalu. Tjiinyamarntu-ya manta lipiwanartu palyamunurringkula-wanarnu. ");
INSERT INTO ntj_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kulila. Warta walykumunu mantjiralpi pawurrpa purlkanya palyala ngurra pirnitjarra. Palunyalu kaninytjarrawanalu puru yilkakuwanalu parrakirtitjurra. ");
INSERT INTO ntj_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Purlkanya mularrpan ngaapirinypa palyalku. Tjiinyan mulya kurranyunguru marlarrkukutu nyakula-wanalku miita 150 palyalku. Palunyalun kantilypa kutjupanguru kantilypa kutjupakutu nyakula-wanalku miita 25-pa palyalku. Palunyalun kaninytjarranguru katukututjarra ma-palyara-wanalku miita 15-pa. ");
INSERT INTO ntj_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Palunyalun kaninytjarra palyalku ruumpa marnkurrpa katulkirra-katulkirra ngaralatjaku, tjiinya kutju kaninytjarra, kutju ngururrkutjarra puru kutju katalarra ngaralatjaku. Nyangkan katuwanalu pupatjunkula-wanalku wantiku. Palunyalun katuwanalu winta parrapalyalku pirriyaku. Palunyalun tuu kutjunguru palyalku. ");
INSERT INTO ntj_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tjiinya ngayulu-rna kapi purlkanya wiyalku manta lipiwanartu ngarrirratjaku. Nyangka-ya yarnangu pirninya puru mantangkatja kutjupa-kutjupa pirninya mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nyangka ngayulu-rnanta mula-mulalu kalkura tjiinya-rnanta wankara kanyilkitjalu. Tjiinya nyuntulu-pulan kurrirarra puru katja marnkurrpa, mingkayi marnkurrpatarrartu-yan pawurrpa palunyangka tjarrpaku. ");
INSERT INTO ntj_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Palunyalun yanamulpa kurrirarra-kurrirarra puru tjurlpu kurrirarra-kurrirarra katiku pawurrpangka tjarrpatjunku wantiku wankarritjaku-ya. ");
INSERT INTO ntj_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Palunyatjanulu-tjanampan mirrka yurrarayilku tjarrpatjunku wantiku ngalkulatjaku-ya. Palunyalu-yanku mirrka yurrara tjarrpatjunku ngalkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nyangka mularrpartu Nawalu pirninyartu palyarnu Mama Kuurrtu watjarnu palunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nyangka Mama Kuurrtu Nawanya watjarnu, “Yuwa, nyuntuku kurri, katja marnkurrpa puru mingkayi marnkurrpatarrartu yarltirralpi pawurrpangka tjarrpatjurra, tjiinyamarntu-rna nyangu nyuntulukutjun tjukarurru nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Palunyalun yanamulpa kukatjarra kurrirarra-kurrirarra 7-pa katiku-tjananya pawurrpangka tjarrpatjunku. Palunyalu yanamulpa miirl-miirlnga kurrirarra-kurrirarra tjarrpatjunku. ");
INSERT INTO ntj_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Palunyalun tjurlpu kurrirarra-kurrirarra 7-pa-tjananya katiku tjarrpatjunku. Nyangka-yayi yanamulpa puru tjurlpu pirninya wankarringkula ngula yilkakurringkulalpi pirnirriwa. ");
INSERT INTO ntj_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nyangka ngurra 6-tjanulu-rna kapi purlkanya wiyalku. Nyangka pungkulayilku kirnara kutjarratjanu wiyarriku. Nyangka-ya yarnangu, yanamulpa puru tjurlpu pirninyatarrartu, tjiinya ngayulu-rna palyantjatjanunya mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nyangka Nawalu Mama Kuurrku wangka wangarnarralu kulira palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","7","Nyangka Nawanya-pula kurrirarra, katja marnkurrpa puru mingkayi marnkurrpa-ya pawurrpangka tjarrpangu kapingkatarra. Tjiinya kapi purlkanya yartakarrinyangka Nawaku-ra kurli 600-pa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tjiinya-tjananya yanamulpa tjurlpu ngalkupayinya puru wantipayinyatarrartu kurrirarra-kurrirarra katingu pawurrpangka tjarrpatjunu Mama Kuurrtu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Nyangka ngurra 6-tjanu kapi purlkanyalu pakarnu manta yangatjuranytja. ");
INSERT INTO ntj_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kapi purlkanya nyarra manta kaninytjarra ngarrirranytjalanguru puku-pukulyarrarnu. Nyangka kapi purlkanyalu yutuwaritjarralu pungkulanytja. Palunyatjarra Nawaku-ra kurli 600-pa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nyangka kapi punkarayirnu manta yangatjunu kirnara kutjarratjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tjiinya kapilu kuwarripa pungkukitjangka Nawanya-pula kurrirarra, palunyaku katja marnkurrpa yini Tjiimanya, Yaamanya, Tjayipinya kurrirarra-kurrirarra pawurrpangka tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Nyangka-tjananya lurrtjurringu yanamulpa pirninya ngupanu, tjami-tjami, kurrirarra-kurrirarra puru tjurlpu-ya kurrirarra-kurrirarra pirni tjarrpangu wiyarringu ");
INSERT INTO ntj_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","tjiinya Mama Kuurrtu watjarnu wantinyangka. Nyangkalta Mama Kuurrtu tuu tjatapungu. ");
INSERT INTO ntj_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Nyangka kapilu pungkulayirnu kirnara kutjarrarringkulalpi manta lipi yangatjura kanyiranytja. Nyangka kapi yuru tati-tatira yanu. Palunyalu pawurrpa palunyanya yurritjingarnu. Nyangka kapi katuwana parrapitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nyangka kapi purlkanyalu purli wararra purlkanya wayirntanu. ");
INSERT INTO ntj_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Palunyalu purli pirninya puru wayirntara yanu miita 7-pa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nyangka mantangkatja kutjupa-kutjupa pirninya-ya mirrirringu, tjurlpu, yanamulpa puru yarnangutarrartu-ya wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","23","Tjiinya Mama Kuurrtu pirninyartu mirrirntanu. Ngarna Nawanya-ya pawurrpangka tjarrpangu nyinarrayirnu wankarringu. ");
INSERT INTO ntj_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nyangka kapi purlkanya tirtu katurtu ngaralayirnu, kirnara 5-nguru purinypa tjarrparrayirnu ngula wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nyangka Mama Kuurrtu watarrkurrinytjamaaltu-tjananya tirtu miranykanyiranytja Nawanya puru yanamulpa pirninyatarrartu. Palunyalu pirriya purlkanya wiyarnu. Nyangka puuranyangka kapi kaninytjarrarringkula-wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tjiinya kapi manta kaninytjarranguru paka-pakaranytjanya wiyarringu. Nyangka yilkaringkatja yutuwari wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Nyangka kapi purinypa kaninytjarrarringkula-wanarayirnu, nyangka kirnara 5-tjanu pawurrpa palunyanya parrapitjalayirnu purli wararra katalarra nyinakatingu ngurra yini Yarararrta. ");
INSERT INTO ntj_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nyangka kapi puru kaninytjarrarringkula-wanarnu, nyangka kirnara kutjarratjanu purli wararra purlkanya-ya yarta-yartakarringkula-wanarnu. ");
INSERT INTO ntj_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nyangka kirnara kutjarratjanulu Nawalu winta yarlarnu. ");
INSERT INTO ntj_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Palunyalu kaarnka kutju wiyarnu. Nyangka yanu wiyarringu. Tjiinya tirtu parrapitjala nyakulanytja kapi wiyarritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nyangka Nawalu purtu kuliranytja, “Kapi-munta wiyarringu?” Nyangka tjurlpu kuukuku wiyarnu nyakutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nyangka parrapitjala purtu kuliranytja nyinakatikitjalu tjiinyamarntu kapilu manta tirtu yangatjura kanyiranyangka. Nyangka marlaku pawurrkutu pitjangu. Nyangka Nawalu marakatirralpi mantjirnu tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Palunyalu wiiki kutjunguru kuukuku palunyanya puru wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nyangka parrapitjalayirnu mungarrtjirringkulalpi marlaku pitjangu. Nyangka Nawalu nyangu nyarlpi katingu. Palunyalu nintilu kulirnu kapi kaninytjarrarringkula-wanarayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nyangka nyinarrayirnu wiiki kutjupangurululpi kuukuku palunyanya puru wiyarnu. Nyangka parrapitjalayirnu marlaku pitjanytjamunurtu. ");
INSERT INTO ntj_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nyangka Nawaku-ra kurli 601-pa ngaralanyangka kapi wiyarringu. Nyangka Nawalu pawurrpa katalarrangkatjanya wakarnu yarlapungkulalpi ma-tjunu palunyalu parranyangu tjiinya manta tikirlarringkula-wanarayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nyangkalta kirnara kutjarratjanu manta tikirlarringu. ");
INSERT INTO ntj_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nyangka Mama Kuurrtu Nawanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pakara-ya yarltirra mapitja, nyuntuku kurri, katja marnkurrpa puru mingkayi marnkurrpa. ");
INSERT INTO ntj_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tjurlpu pirninya puru yanamulpatarrartu-tjananya kati ma-walatjurra. Nyangka-yayi puru pirnirringkula-wanala manta lipiwana nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nyangka Nawanya-pula kurrirarra, katja marnkurrpa puru mingkayi marnkurrpa-ya tjarungaralalpi pakarnu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nyangka-ya yanamulpa pirni puru tjurlpu pirninya tjarungaralalpi ngurrkarntarri-ngurrkarntarri yankula-warningu. ");
INSERT INTO ntj_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nyangka Nawalu yapu tjunkula parrawanarnu katurnu. Palunyalu yanamulpa tjurlpu ngalkupayinya kutju-kutju pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nyangka Mama Kuurrtu parntiralpi pukurlarringu. Palunyalunku watjarnu, “Wiya, manta-rna ngula kurralkitjamunu yarnangulu-ya palyamunu palyaranyangka. Tjiinya-rna nintilu kulira tjilkunguru-ya nyalparringkula palyamunu tirtu kuliranyangka. Ngaanguru-rna mantangka nyinapayi pirninya kapingka mirrirntankukitjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nyangka manta ngaralanyangka-ya yurninypa tjunkula mirrka pakaltjinganma. Nyangka nyinngatjanu pirriya-pirriya ngarama. Nyangka pirriya-pirriyatjanu kurli ngarama. Tjiinya palunyapirinypartu tirtu ngaraku ngarama. Nyangka mungatjanutarrartu tirtu tjirnturringama.” ");
INSERT INTO ntj_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nyangka Mama Kuurrtu-tjanampa Nawaku puru palunyaku katja marnkurrku watjarnu walykumunu ngaralatjaku. Tjiinya ngaapirinypa watjarnu, “Tjilku pirnitjarrarringkula-ya wanarayinma. Nyangka-tjanampankuya tjamu kaparlipirti manta lipiwana nyinarra-wanarayinma. ");
INSERT INTO ntj_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nyangka-ya yanamulpa, tjurlpu puru kapingkatja pirninya-tjanampanku ngurlurringama. Nyangka-tjananyayan puurrarringkula kanyinma. ");
INSERT INTO ntj_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Palunyatjinnga-tjanampanku kuka tirtu ngarama. Nyangka-yan pungkula ngalkunma. Kutjulpirtu-tjanamparnanku yukiri puru mirrka wartangkatja nintirnu ngalkulatjaku-yan. Nyangka-yan ngaanguru kukatarrartu pungkula ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nyangka-tjananyarnanta ngaanyakutju yaka-yakalku wantiku. Kuka pungkula yirramitjarra ngalkunytjamaaltu wantima. Ngarna-yan kuka pungkulalpi tjunku wantiku yirrami tjutirra wiyarringkunyangkakutju paalku ngalku wiyalku. Tjiinya yirramilu-tjananyanta wankara kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nyangka kutjupalu-tjinguru yarnangu kutjupa pungku mirrirntanku. Nyangka-rnalu ngaparrtjika pungku mirrirntanku. Nyangka yanamultu-tjinguru yarnangu patjalku mirrirntanku, tjinguru kantulku mirrirntanku. Nyangka-rna palunyanya ngaparrtjika pungku mirrirntanku. ");
INSERT INTO ntj_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Nyangka kutjupalu mirri pungkunyangka tjiinya kutjupalu ngaparrtjika mirri pungku. Tjiinyamarntu-rna yarnangu palyarnu yara ngayunyapirinypa nyinarratjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Puru Mama Kuurrtu ngaapirinypa watjarnu, “Yuwa, tjilku pirnitjarrarringkula-wananma-ya. Nyangka-tjanampankuyi tjamu kaparlipirti ngurra pirniwana parranyinarra-wanarayinma.” ");
INSERT INTO ntj_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Nyangka Mama Kuurrtu-tjananya Nawanya palunyaku katja marnkurrpatarrartu watjarnu, ");
INSERT INTO ntj_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","11","“Ngaanya-tjananyarnanta mula-mulalu watjara nyuntulu purunku tjamu kaparlipirtilu-ya tirtu kuliratjaku. Tjiinya-rna ngula yarnangu pirninya, yanamulpa puru tjurlputarrartu kapi purlkanyangka mirrirntankukitjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ngayulu-rna tjurtirangu ngaratjunu wantingu yutuwaringka. Nyangka-ya marlangkatja-marlangkatjalu nyakula kulinma tjiinya-rna ngula kapi purlkanyangka mirrirntankukitjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tjiinya-rna nyaku tjurtirangu yutuwaringka yartakarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Palunyalu-rna kulilku tjiinya-rna watjarnu wantingu ngula yarnangu yanamulpatarrartu kapingka mirrirntankukitjamunulu. ");
INSERT INTO ntj_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tjiinya-rna tjurtirangu nyaku yutuwaringka ngaralanyangka. Palunyalu-rna kulilku tjiinya wangka-rna kuwarri watjarnu wantitjalu. Wangka palunyanya-rna kutjupankukitjamunu. Nyangka tirtu ngaraku ngarama. ");
INSERT INTO ntj_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nyangka-ya yarnangu marlangkatja-marlangkatja pakaranytjalu tjurtirangu nyakula kulinma tjiinya-rna watjarnu wantingu ngula yarnangu pirninya kapingka mirrirntankukitjamunulu.” ");
INSERT INTO ntj_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nyangka Nawaku katja marnkurrpa yini Tjiimanya, Yaamanya, Tjayipinya nyinarranytja. Nyangka Yaamanya tjiinya Kayinanku mama. ");
INSERT INTO ntj_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nyangka katja marnkurrpa-ya tjiinya manta lipingkatjaku-tjanampa tjamu purlkanya nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nyangka Nawalu mirrka pakaltjingalpayi. Tjiinya Nawalunku kurranyulu mirrka kiripi murrutjunu pakaltjingarnu. Nyangka kutjupatjarralu-ya minirringkulalpi marlawanalu murrutjuranytja. ");
INSERT INTO ntj_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Nyangka mirrka kiripi yurnmirrinyangka Nawalu yurrara palyara wayinkarraranytja. Palunyalu tjikirayirnu kakiri purlkarringkulalpi warntu yurulypungu nikirrpalya ngarrirranytja palunyaku tiinti kaninytjarra. ");
INSERT INTO ntj_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nyangka Kayinanku mama Yaamalu tjarrparra pitjalalpi nyangu Nawanya nikirrpalya ngarrirranyangka. Palunyalu yanunku kurta kutjarra watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nyangka Tjiimalu-pula Tjayipilu warntu mantjirnu takuwanalu-pulanku parratjunkulalpi warna-warnalu tjarrparralpi-pulanku mama tjuturnu, tjiinya nikirrpalya ngarrirranyangka nyakutjakutarra. ");
INSERT INTO ntj_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nyangka Nawanya ngarrirrayirnu kanarringkulalpi kulirnu palunyaku katja marlangkatjalu yanu watjarnu nikirrpalya ngarrirranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Palunyalu Yaamala watjarnu, “Wiya, nyuntuku katja Kayinannga-rna kurralku. Nyangka waarka purlkanya palyanma palunyaku kurtapirtiku. ");
INSERT INTO ntj_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yuwa, marninypungama-ya Mama Kuurrnga, tjiinya Tjiimalu pupakatirra marninypungkupayinya. Tjiinya Kayinanku tjamupirtilu-ya waarka purlkanya palyanma Tjiimaku tjamupirtiku. ");
INSERT INTO ntj_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nyangka Mama Kuurrtu Tjayipinya miranykanyinma. Nyangka-raya palunyaku tjamu kaparlipirti pirnirringkula-wanarayinma. Palunyalu-ya Tjiimaku tjamupirtingka lurrtjurringkula nyinama. Nyangka Kayinanku tjamupirtilu-ya Tjayipiku tjamupirtiku waarka palyanma.” ");
INSERT INTO ntj_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Nyangka kapi purlkanya ngarangu wiyarrinyangka Nawanya puru nyinarrayirnu kurli-ra 950 ngaralanyangka yirna purlkanya mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","32","Nyangka kapi purlkanya ngaralayirnu wiyarrinyangka Nawaku katja marnkurrtu-ya katja yurntalpa pirni yartakaranytja. Nyangka yarnangu palunyalu-ya katja yurntalpa pirni yartakaranytja. Tjiinya-ya Nawaku tjamu kaparlipirti marlangkatja-marlangkatja pakara-wanarayirnu pirnirringu. ");
INSERT INTO ntj_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ngarnmanypalpi-ya yarnangu manta lipingkatja wangka waarrku wangkarranytja. Wangka kutjurtu-ya wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Palunyalu-ya kakarrara parrapitjalayirnu yurirlpa walykumunukutu pitjangu. Palunyalu-ya ngurrararringu nyinarranytja. Ngurra palunyanya yini Papulaniyanya. ");
INSERT INTO ntj_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nyangka-ya kapurturringu watjarnu, “Kulila-ya. Pilki-la mantjiralpi paara witu-witunma.” Nyangka-ya mularrpartu pilki paarnu yapukarraralpi tjaparupirinytja kirtitjuranytja yapu tjunkula lurrtjulkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Palunyalu-ya watjarnu, “Yiwarla pirni-munta-lan palyalku nyinakitjalu?” Nyangka-ya mularrpartu yiwarla pirni palyarayirnu, nyangka lipiwana ngaralanytja. Nyangka-yanku watjarnu, “Yiwarla kutjupa-la palyala yilkari katukututjarra ngaralatjaku. Nyangka-lanyayayi pirnilu marninypungama. Nyangka-layi ngurra kutjupa-kutjupaku tjarrarringkutjamaalpa wantirra nyinama.” Nyangka-ya mularrpartu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nyangka Mama Kuurrnga tjarungarangu nyakukitja yiwarla-ya palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Palunyalunku watjarnu, “Wiya, yiwarla ngaanya-ya karnany-karnanytju palyara. Palunyalu-ya wuyurrarringkulalpi kutjupa-kutjupa nintipukalu palyanma wangka waarrku wangkarra kuliranytjalu. ");
INSERT INTO ntj_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Palunyakutarrartu-lan tjarungaralalpi wangka kutjupa-kutjupanku. Nyangka-ya purtu wangkarra-yanku ngurrkarntanama.” ");
INSERT INTO ntj_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nyangka mularrpartu-tjananya wangka kutjupa-kutjupanu. Nyangka-ya yiwarla palunyanya palyantjamaalarringu. Nyangka Mama Kuurrtu-tjananya tjarrarnu. Nyangka-ya tjarra-tjarrarringkula yanu manta lipiwana nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Palunyanguru-ya yiwarla palunyanya yini Papulannga tjapirnu. Tjiinyamarntu-tjananya Mama Kuurrtu wangka kutjupa-kutjupanu. Nyangka palunyangurulta-ya yankula-warningu ngurra kutjupa-kutjupangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","26","Nyangka Nawaku katja Tjiimaku tjamu kaparlipirti pirnirringu. Tjiinya-ya marlangkatja-marlangkatja pakara-wanarnu wati yini Tiiralakutu. ");
INSERT INTO ntj_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nyangka Tiiraku yungarrapirti-ya ngaapirinypa nyinarranytja. Tjiinya Tiiralu katja marnkurrpa yartakanu yini Yayipamanya, Nayiyunya, Yarrannga. Nyangka Yarrantu katja yartakanu yini Luutanya. ");
INSERT INTO ntj_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Nyangka Tiiranya nyinarrayirnu purrkutjarrarringu palunyaku katja Yarrannga mirrirrinyangka. Tjiinya ngurra yungarrangkartu mirrirringu yiwarla yini Yurala tjiinya ngurra yini Papulaniyala. ");
INSERT INTO ntj_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Nyangka Yayipamalu minyma Tjarayinya yarltingu. Nyangka tjilkumaalpa tirtu nyinarranytja. Nyangka Nayiyulu Yarranku yurntalpa Milkanya yarltingu. Nyangka Yarranku katja kutjupa yini Yilykanyatarrartu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Nyangka Tiiralunku katja Yayipamanya, mingkayi Tjarayinya, puru tjamu Luutanya yarltirra yalatja yanu. Tjiinya-ya yiwarla Yuranya Papulaniyala ngaralanytjanya wantirra yanu ngurra Kayinanngakitja. Pitjalayirnu-ya ngurra yini Yarranta nyatarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nyangka Tiiranya nyinarrayirnu kurli-ra 205 ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nyangka Mama Kuurrtu-lu Yayipamanya watjarnu, “Yuwa, pakaran yanku ngurra nyarra ngayulu-rnanta nintitjunku, palunyalakutu. Nyuntuku ngurra puru yungarrapirtin wantirra kutipitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nyangka-rnanta kanyilku tjamu kaparlipirti-ya pirnirritjaku. Nyangka yarnangu pirnilu-tjananyaya mirrawarnima. Puru-rnanta nyuntunya kanyilku wati purlkanya nyinarratjaku. Nyangkanta-ya marninypungama. Nyangka nyuntulanguru-tjananyarna yarnangu manta lipingkatja walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Tjiinya-ya nyuntunya-tjananyanta miranykanyiranyangka ngayulu-tjananyarna ngaparrtjika miranykanyinma. Tjiinya kutjupatjarralu-tjingurunta-ya yinitjunku. Nyangka ngayulu-tjananyarna ngaparrtjika yinitjunku. Tjiinya nyuntulanguru ngayulu-tjananyarna yarnangu yarla lipingkatja walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Nyangka mularrpartu Yayipamalu ngurra nyarra Yarrannga wantirra pakara yalatja yanu kurli-ra 75-pa ngaralanyangka. Tjiinya Yayipamalunku kurri Tjarayinya, palunyaku marlanyku katja Luutanya, puru waarka palyalpayi pirninyatarrartu-tjananya yarltirra katingu. Palunyalunku yulytja puru tjimarri pirninya ngurra nyarra Yarranta mantjintjalu lurrtjura katingu. Palunyalulta-ya kutipitjangu ngurra yini Kayinanku. Pitjalayirnu-ya Kayinanku parrapitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Palunyanguru-ya tirtu mapitjalayirnu ngurra yini Tjikimaku parrapitjangu warta miirl-miirlpa yini Muurayinya ngaralanyangka. Tjiinya-ya Kayinanku tjamu kaparlipirti ngurra palunyawana tirtu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nyangka Mama Kuurrtu Yayipamala yartakarringkulalpi watjarnu, “Ngurra ngaa lipinya-rnanku nyuntuku nintilku, puru nyuntuku tjamupirtikutarrartu.” Nyangka kuliralpi yapu tjunkula parrawanarnu katurnu. Palunyalu tjiipu pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalulta Mama Kuurrnga marninypungu. ");
INSERT INTO ntj_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Palunyalu pakara yurlparirra yanu ngurra tjunu ngurra purlitjarrangka yiwarla yini Pitjulta Yayila ngururrkutjarra. Tjiinya Pitjulnga yapurra ngaralanytja. Nyangka Yayinya kakarrara ngaralanytja. Nyangka Yayipamalu yapu tjunkula parrawanarnu katuralpi tjiipu pungu tilirnu tjunu Mama Kuurrku nintirnu. Palunyalulta Mama Kuurrnga marninypungu. ");
INSERT INTO ntj_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Palunyalu Kayinantawana tirtu parrapitjalayintja ngurra kutjupa-kutjupakutu. Tjiinya tirtu ngurra tjunkula mapakaranytja. Palunyalu yurlparirra tirtu mapitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nyangka yayilurru purlkanya ngarangu Kayinantawana. Palunyangka Yayipamanya wayirntara yurlparirra yanu ngurra yini Yiitjipula nyinakitja. ");
INSERT INTO ntj_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Palunyalu tjarrpakitjalunku kurri Tjarayinya watjarnu, “Yuwa, nyuntulun minyma kuru mantjil-mantjilpa. ");
INSERT INTO ntj_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","13","Nyangkanta-tjinguru-ya Yiitjipula nyinapayilu nyuntunya nyakulalpi ngayunya-rniya pungku mirrirntanku nyuntunya yarltirra kanyilkitjalu. Palunyakutarran watjalku nyarrumpa-rnatju katirrayintja. Nyangka-rniyayi pungkutjamaaltu wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Nyangka-pula Yiitjipulakutu parrapitjanyangka mularrpartu-ya nyangu minyma walykumunu pitjalayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nyangka-ya puurrku yamatji pirnilu nyangu minyma walykumunu mularrpa. Palunyalu-ya yanu puurrpa Piirula tjakultjunu. Nyangka-tjananya watjarnu, “Mapitja-ya yarltirra kati.” Nyangka-ya mularrpartu yarltirra katingu palunyaku yiwarlakutu. ");
INSERT INTO ntj_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nyangka palunyanguru puurrpa Piirulu Yayipamanya kalypalu kanyiranytja. Palunyalu kutjupa-kutjupa walykumunu nintirnu, tjiipu pirni, nanikuurrpa, puluka, tungki, kamurlpa puru waarka palyalpayinyatarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Nyangka Mama Kuurrtu puurrpa palunyanya pikatjarrarnu Tjarayinya kanyiranyangka. Puru-tjananya yarnangu pirninya palunyaku yiwarlangka nyinapayinya pikatjarrarnu. ");
INSERT INTO ntj_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Nyangka puurrpa Piirulu wati kutju witurnu Yayipamanya yarltirra katitjaku. Nyangka mularrpartu yarltirra katingu. Nyangka tjapirnu, “Nyaaku-rnin mayurnu? Nyaaku-rnin watjantjamaaltu wantingu nyuntukunku kurri nyinarranyangka? ");
INSERT INTO ntj_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tjinguru-rnin tjurrkurltu watjanma. Tjiinya-rnin watjarnu nyarrumpan katinytjalu. Nyangka-rna ngayulu mantjirnu kurrirringu kanyiranytja. Yala, kurriltanku yarltirra kutipitja!” ");
INSERT INTO ntj_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Nyangka puurrpa Piirulu-tjananya waarka palyalpayinya wituralpi watjarnu, “Kutikati-pulanya. Tiwa makatirrayila wanti.” Nyangka mularrpartu-ya Yayipamanya, palunyaku kurri, puru tjiipu, nanikuurrpa, puluka, waarka palyalpayinya puru kamurlpatarrartu makatirrayirnu tiwa mawantingu. ");
INSERT INTO ntj_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Nyangka Yayipamanya-ya pakara Yiitjipunya wantirra marlaku yanu Kayinantakutu. Tjiinya Yayipamanya-pula kurrirarra, palunyaku marlanyku katja, Luutanya puru yarnangu pirninyatarrartu-ya pakara pitjalayirnu parrapitjangu Kayinanta yurlparirra nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Tjiinya Yayipamanya yulytja purlkanyatjarra nyinarranytja. Tjiinya tjilpa, kawurlpa, tjiipu, nanikuurrpa puru puluka pirninyatarrartu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Palunyalu pakara yanu ngurra kutjupa-kutjupakutu parrapitjalayintja. Palunyalu ngurra nyarra kutjulpirtu nyinarranytja, palunyangka ngurra tjunu tjiinya yiwarla Pitjulta Yayila ngururrkutjarra. ");
INSERT INTO ntj_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tjiinya ngurra palunyangka kutjulpirtu yapu tjunkula parrawanarnu katurnu wantingu. Palunyangka kuka pungu tilirnu tjunu Mama Kuurrku nintiralpi marninypungu. ");
INSERT INTO ntj_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Nyangka Luutalutarrartu tjiipu, nanikuurrpa puru pulukatarrartu kanyiranytja. Palunyalu kurri, yurntalpa kutjarra, puru waarka palyalpayi pirninyatarrartu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nyangka-ya yanamulpa pirnilu yukiriku purtu ngurriranytja. Nyangka Yayipamalu-pula purtu kuliranytja lurrtju nyinakitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tjiinya Yayipamaku puru Luutaku yanamulpa miranykanyilpayilu-yanku pika-pika wangkarranytja. Tjiinya palunyatjarralpi-ya Kayinanku tjamu kaparlipirti puru Pirinyku tjamupirti ngurra palunyangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nyangka Yayipamalu watjarnu, “Nyaaku-limpa-ya waarka palyalpayilu-yanku pikarringkula payira? Tjiinya-lin mamararra nyinarra. ");
INSERT INTO ntj_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nyangka-munta-lin tjarrarriku? Nyuntulu-muntan ngurra ngurrkarntankulalpi nyinama? Nyangka-rna ngayulu ngurra kutjupangka nyinaku.” ");
INSERT INTO ntj_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nyangka Luutalu parranyakulalpi nyangu kapi Tjuutannga. Tjiinya kapi purlkanya, yukiri purlkanyatarrartu yiwarla yini Tjawalakutu ma-ngarringu. Tjiinya yitjarnu purlkanya ngaralanytja, Mama Kuurrtu kaatanpa ngarnmanypalpi palyarnu wantitjapirinypa puru ngurra Yiitjipunyapirinypa. Tjiinya Mama Kuurrtu yiwarla Tjatamanya Kumaranya wiyantja kuwarripangka. ");
INSERT INTO ntj_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nyangka Luutalu ngurra palunyanya nyakulalpi watjarnu yankula nyinakitjalu. Palunyalu mularrpartu pakara kakarrara yanu. Tjiinya palunyapirinypa Yayipamanya-pula Luutanya tjarrarringu. ");
INSERT INTO ntj_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nyangka Yayipamanya nyinangu ngurra nyarra Kayinanta. Nyangka Luutanya tjarungarala yanu kapi Tjuutantakutu. Palunyalu yiwarla kutjupa-kutjupakutu ma-yankulayintja. Pitjalayirnu parrapitjangu ngurra tjunu yiwarla Tjatamala ngamu. ");
INSERT INTO ntj_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Nyangka ngurra palunyangka-ya palyamunu mularrpa palyalpayi Mama Kuurrta mirangka. ");
INSERT INTO ntj_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Nyangka Luutanya yankunyangka Mama Kuurrtu Yayipamanya watjarnu, “Yuwa, palan kuwarrinya ngaralanytjalu yarla lipirntara nyawa kakarrara, yapurra, kayili, yurlparirra. ");
INSERT INTO ntj_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tjiinya ngurra nyarran nyakula, palunyanya-rnanku nintilku. Nyangkanku tjamu kaparlipirtitarrartu-ya tirtu nyinama ngurra palunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tjiinya-rnanku nyuntuku tjamu kaparlipirti kanyilku pirnirringkutjaku-ya. Nyangka-ya minga-minga nyinama. Tjiinya-tjananya kutjupalu purtu parralku wantiku. ");
INSERT INTO ntj_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Yuwa, pakara kutipitja ngurra lipiwanalu parranyawa. Tjiinyamarntu-rnanku nyuntuku nintilku.” Nyangka Yayipamalu mularrpartu ngaralanytjalu parranyangu. ");
INSERT INTO ntj_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Palunyalu ngarringu tjirnturringkulalpi pakara mapitjangu ngurra tjunu yiwarla yini Yapuranta ngamu, wati Mamurayiku warta miirl-miirlpa-ya ngaralanyangka. Palunyalu yapu pirninya tjunkula parrawanarnu katurnu. Palunyalu tjiipu pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu Mama Kuurrnga marninypungu. ");
INSERT INTO ntj_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Nyangka palunyatjarralpi wati yini Kitulamanya ngurra pirniku puurrpa nyinarranytja. Puurrpa palunyanya ngurra yini Yiilamala nyinarranytja. Tjiinya ngurra palunyanya kakarrara ngaralanytja. Nyangka palunyangka ngamu yiwarla marnkurrpa ngaralanytja puurrtjarra-puurrtjarra. Tjiinya puurrpa palunyanya-ya puurrpa Kitulamaku yamatji nyinarranytja. Nyangka yiwarla kutjupa yini Tjatamanya yurlparirra ngaralanytja yuru yini Kumpuwalykula ngamu. Nyangka palunyangka ngamu yiwarla kutjarra-kutjarra ngaralanytja. Nyangka yarnangu-ya ngurra yini Tjatamalawana puru yiwarla kutjarra-kutjarrawana nyinapayinya yanyan-yanyanarripayi-tjanampa yarnangu Yiilamalawana nyinapayiku. Tjiinyamarntu puurrpa Kitulamalu-ya kurli kutjupa kurli pitjala pawurntjingara kutjupa-kutjupa mantjilpayi, tjimarri purlkanya, mirrka purlkanya puru yulytja purlkanyatarrartu. Nyangka-ya ngurlu-ngurlulu nintirayintja. Palunyalu-ya kurli 12-tjanulu raparringkulalpi kulirnu tungun-tungunarrikitjalu puurrpa Kitulamaku-tjanampa. Palunyalu-ya puurrpa 5-nya Tjatamalawana nyinapayinya pakarnu warrmarlara yanu lurrtjurringu karru-karru yini Tjitimala. ");
INSERT INTO ntj_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","7","Nyangka puurrpa Kitulamalu kulirnu tungun-tungunarrinyangka-ya. Palunyalu yarltingu-tjananya puurrpa yiwarla marnkurrtatja warrmarlara lurrtjurringkula yankutjaku. Nyangka-ya mularrpartu warrmarlara lurrtjurringkula yanu. Palunyalu-ya ngururrpa pitjalayintjalu yarnangu kutjupa-kutjupa pirni pungkula wiyaranytja. Nyangka-ya ngurlu kumpira kukurraarnu yurlparirra. Nyangka puurrpa Kitulamalu-ya ngurlura wanarnu mawantingu. Palunyalu-ya pinkurraara marlaku pitjala yarnangu kutjupatjarra pungkula-tjananya parrawanarayirnu wiyarnu, Yamalikiku tjamupirti puru Yayimuku tjamupirti. ");
INSERT INTO ntj_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Nyangka-ya puurrpa Tjatamanyamartatji puru ngurra ngamungkatjaku puurrpa kutjarra-kutjarralu kulirnu puurrpa Kitulamanya-ya pikakitja pitjalanyangka. Palunyalu-ya lurrtjurringkula yanu karru-karru Tjitimala pikakitja ngaralanytja. Nyangka-ya puurrpa Kitulamalu pitjangu pika purlkanya pungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nyangka puurrpa Tjatamanyamartatji-pula Kumaranyamartatji kukurraalkitja karralukatingu pirti tjulyulyungka. Nyangka-ya puurrpa marnkurrarringkula kukurraarnu purlikutu. ");
INSERT INTO ntj_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Nyangka-ya puurrpa Kitulamalu yiwarla Tjatamaku Kumaraku parrapitjangu. Palunyalu-ya yanamulpa pirninya, yulytja puru mirrkatarrartu mantjirayirnu yanu. ");
INSERT INTO ntj_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Yayipamaku katja Luutanyatarrartu-ya tjulyara katingu, palunyaku yanamulpa puru yulytjatarrartu. Tjiinyamarntu Luutanya Tjatamala nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nyangka wati kutju kumpira kukurraarnu wati Yiipuru Yayipamala tjakultjunkukitja. Palunyalu parrapitjalalpi nyangu warta miirl-miirlta nyinarranyangka. Tjiinya Yayimuku tjamu Mamurayiku warta miirl-miirlta nyinarranytja. Tjiinya Mamurayinya puru-ra marlanypa kutjarra yini Yalykalnga Yayinanya-pula Yayipamaku-ya yamatji nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Nyangka Yayipamalu kulirnu palunyaku katja-ya tjulyara katinyangka. Palunyalu palunyaku ngurrangkatja warrmarlara yanu. Wati 318-pa-ya lurrtjurringkula yanu. Palunyalu-ya puurrpa kutjarra-kutjarranya-tjananya ngurlura wanarayirnu yiwarla Taanta ma-tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Palunyalu mungarringkulalpi warrmarla pirninya tjarrarnu-tjarrarnu kutjupatjarra-ya parrapitjala kutjupanguru pika pungkutjaku. Nyangka-ya mularrpartu tjarrarringkula-tjananya pika purlkanya pungu. Nyangka-ya kutjupatjarra kukurraannyangka-tjananya pungkula-wanarayirnu yiwarla Tamarrkanya wayirntaralpi kayili wanarnu-tjananya ma-tjarrpatjunu yiwarla yini Yawupala. ");
INSERT INTO ntj_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Nyangka Yayipamalu yulytja pirninya tjiinya-ya tjulyara katinytjanya yurrarnu. Palunyalunku katja Luutanya yulytja pirnitjarra, minyma pirninya puru yarnangu kutjupatjarranyatarrartu yarltirra marlakulu katingu. ");
INSERT INTO ntj_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Nyangka Yayipamanya pikatjanu marlaku pitjangu puurrpa kutjarra-kutjarra pungu wiyaralpi. Nyangka puurrpa Tjatamanyamartatji ngata-ngata yanu nyakukitja karru-karru Tjayipalawana pitjalayinnyangka. Tjiinya Tjayipanya yini kutjupanya ngaapirinypa, “Puurrku Karru-karru”. ");
INSERT INTO ntj_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Nyangka puurrpa Tjayilamanyamartatji yini Maltjakilu pukurltu katingu mirrka nyamirli puru wayinpa Yayipamaku nintilkitjalu. Tjiinya wati palunyalu kuka tilira tjunkula nintilpayi Mama Kuurrku, tjiinya purlkanya nyinapayiku. ");
INSERT INTO ntj_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Palunyalu mirrka nintiralpi watjarnu, “Mama Kuurrtu nyarra yilkari manta palyantjalu Yayipamanya walykumunura kanyinma. Mama Kuurrnga purlkanya mularrpa nyinarra. Palunyalu-tjananyanta yirringkanu nyangka-tjananyayan yanyan-yanyanpa pirninya pungkulayirnu wiyarnu. Kutju-palunyanya-la marninypungama.” Nyangka Yayipamalu yulytja pirninya mantjira katinytjalu 100-pa tjunkulalpi 10-pa tjarrarnu Maltjakiku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nyangka puurrpa Tjatamanyamartatjilu Yayipamanya watjarnu, “Palyan kutjupa-kutjupa yurrara katinytjalu kanyinma. Yarnangu pirninyakutju-rni nintila tjiinya ngayuku yungarrapirti tjiinyan wanarayirnu marlakulu katinytjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Nyangka Yayipamalu paanypungkulalpi watjarnu, “Wiya, ngayuku-tju nintintjamaaltu wanti. Tjinguru-tjun nintiralpi ngaapirinypa watjanma, ‘Ngarna ngayulu-rnalu nintinnyangka Yayipamanya yulytja pirnitjarra nyinarra.’ Palunyakutarra-rnanta mantjilkitjamunu. Kurlunypatarrartu-rnanta mantjilkitjamunu. Mama Kuurrta tjiinya Puurrpa Purlkanya nyinapayila mirangka-rna mayuntjamaaltu watjara. ");
INSERT INTO ntj_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Palya ngayuku warrmarlalu-ya mirrka nyuntulamartatji ngalkula pitjanytja. Nyangka ngayuku yamatjiku tjiinya Yayinaku, Yalykalku Mamurayiku-tjanampa yirringkaralpi nintila tjiinyamarntu-rniya lurrtjurringkula yanu pika-tjananya pungkulayirnu pitjanytja.” ");
INSERT INTO ntj_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nyangka palunyalanguru Yayipamalu tjukurrpa nyangu Mama Kuurrnga yartakarringkulalpi-lu watjarnu, “Yayipama, ngurlurriku-kurlun. Wanti. Tjiinya-rnanta ngayulu tjaralupirinypa yangatjura kanyinma. Palunyalu-rnanku kutjupa-kutjupa walykumunu nintinma.” ");
INSERT INTO ntj_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Nyangka kuliralpi watjarnu, “Wiya Puurr, kunpu-kunpu-rnin nintilku. Tjiinyamarntu-rna tjilkumaalpa nyinarra. Nyangka wati yini Yalitjalu nyarra Tamarrkanyamartatjilu-tju yulytja pirninya mantjilku kanyilku wiyarrinyangka-rna. ");
INSERT INTO ntj_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tjiinyamarntu-rnin tjilku nintintjamaalpartu. Nyangka-tju waarka palyalpayilu yulytja pirninya mantjilku wiyarrinyangka-rna.” ");
INSERT INTO ntj_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nyangka Mama Kuurrtu watjarnu, “Wiya, nyuntuku waarka palyalpayilu kamu mantjilku. Nyuntukunku katja yungarralu mantjilku.” ");
INSERT INTO ntj_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nyangka-lu yarltirra katingu yilkakuralpi watjarnu, “Parranyawa pirntirri yilkaringka ngaralanyangka. Tjiinyan purtu parrara-wanarayilku wantiku. Nyangka palunyapirinypa nyuntuku kaparli tjamupirti-ya pirnirriku nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Nyangka Yayipamanya mula-mularringu Mama Kuurrtu watjannyangka. Nyangka palunyanguru Mama Kuurrnga-ra pukurlarringu. Palunyalu watjarnu, “Wiya, tjukarurru-rnin nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Puru Mama Kuurrtu-lu ngaapirinypa watjarnu, “Ngayulu-rna Mama Kuurrnga nyuntuku Puurrpa. Ngayulu-rnanta ngurra Papulaniyalanguru tjiinya yiwarla Yuralanguru yarltirra katingu ngurra ngaanya-rnanku nintilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Nyangka Yayipamalu tjapirnu, “Wiya Puurr, kutjupa-kutjupa-muntan palyalku nintilu-rna kuliltjaku ngurra ngaanya-rna yungarrarringkula kanyilkitjalu?” ");
INSERT INTO ntj_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nyangka Mama Kuurrtu watjarnu, “Yanamulpa warlangu puru tjurlpu kati, tjiinya ngaapirinypa; puluka kamina, nanikuurrpa kamina, tjiipu marnti puru tjurlpu kuukuku marnpitarrartu.” ");
INSERT INTO ntj_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Nyangka mularrpartu-tjananya pungkula mantjira katingu. Palunyalu kartara-tjananya ngarrakurla-ngarrakurla tjunkula-wanarnu. Nyangka tjurlpu kutjarra-pulanya kartantjamaaltu tjunu yarnangurtu wantingu. ");
INSERT INTO ntj_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nyangka warlawurru-ya pitja-pitjala nyinakatirra ngalkukitjangka Yayipamalu-tjananya tjirtira wiyaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nyangka tjirntu ma-tjarrparranyangka Yayipamanya kunkunarringu. Palunyalu kunkunpa purlkanya ngarrirranyangka munga marurringkulalpi kutjupa-kutjuparringu. Nyangka ngurluny-ngurlunyarringkulalpi ngarrirra tiltirrmaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","14","Nyangka Mama Kuurrtu watjarnu, “Nyuntuku tjamu kaparlipirti-ya yanku ngurra kutjupangka maliki nyinama. Nyangka-tjananyaya ngarltumaaltu pawurntjingara witu-witunma waarka purlkanya palyaratjaku. Nyangka-ya palyanma. Nyangka kurli 400-tjanulu-tjanamparna ngayulu nyarra witu-witulpayiku palyamunu purlkanya yartakanku. Nyangkalta-ya nyuntuku tjamu kaparlipirti ngurra palunyalanguru pakaralpi yanamulpa, mirrka puru tjimarritarrartu mantjira pitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Tjiinya-ya nyuntuku tjamu kaparlipirti nyinarrayilku kurli 400-tjanu marlaku pitjaku ngurra ngaawana nyinakitja. Tjiinya ngurra ngaangkatja Yayimuku tjamupirti-ya palyamunu mularrarriku. Palunyangka-tjananyarna pika purlkanya pungku wiyalku. Yuwa, nyuntulun nyinarrayilku yirna purlkarringkulalpi kurrurnpa rapa wiyarriku. Nyangkanta-ya katiku pulpangka tjarrpatjunku.” ");
INSERT INTO ntj_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nyangka tjirntu tjarrpanyangka ma-mungarringu. Nyangka Yayipamalu nyangu puran-purantatja tjunarnpa purlkarrinyangka puru tjangi tili purlkanyatjarra yartakarringkulalpi kukangka ngururrkutjarrawana mapitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nyangka palunyangurulta Mama Kuurrtu Yayipamanya kalkuralpi watjarnu, “Ngayulu-tjanamparna ngurra ngaanya nintilku nyuntuku tjamu kaparlipirtiku. Tjiinya ngurra palunyanya lipi purlkanya, ngurra Yiitjipulanguru makatirrayirnu kapi yini Purayitinya pampurnu. ");
INSERT INTO ntj_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Tjiinya yarnangu ngaanya-ya kuwarrinya ngarna nyinarra: Kiinku tjamupirti, Kinirrku tjamupirti, Karrmanku tjamupirti, ");
INSERT INTO ntj_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Yatjaku tjamupirti, Pirinyku tjamupirti, Ripayiku tjamupirti, ");
INSERT INTO ntj_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Yayimuku tjamupirti, Kayinanku tjamupirti, Kukatjaku tjamupirti, puru Tjipurrku tjamupirti. Yarnangu palunyaku-tjanampa ngurra-rna nintilku nyuntuku tjamupirti-ya nyinarratjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Yayipamaku kurri Tjarayinya tjilkumaalpa tirtu nyinarranytja. Palunyalu kungka Yiitjipunyamartatji yini Yayikanya kanyiranytja tjiinya-ra waarka palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nyangka Tjarayilunku kurringka watjarnu, “Tjiinya Mama Kuurrtu-rni tjilkumaalmara kanyira. Nyangka-muntan ngayuku waarka palyalpayingka-pulan ngarriku? Nyangka tjilku ngayuku-tju kanyilku.” Nyangka mularrpartu watjarnu ngarrikitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nyangka-ra Yayikanya witurnu nganartirritjaku. Tjiinya Yayipamanya ngurra Kayinanta nyinarrayirnu kurli 10-tjanulu kungka palunyanya yarltingu. ");
INSERT INTO ntj_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Nyangka-pula mularrpartu ngarringu. Nyangka Yayikanya nyinarrayirnu mukalarringu. Palunyalu karnany-karnanyarringkulalpi Tjarayila kutjupa-kutjupa watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Nyangka Tjarayilu Yayipamala watjarnu, “Kulila. Nyuntulanguru-rni Yayikalu karnany-karnanytju watjara. Ngarna-rnalu ngayulu nyuntulakutu witurnu. Nyangka mukalarringkulalpi-rni tirtu watjara. Nyangka Mama Kuurrtu-linya ngurrkarntanku. Tjinguru ngayulu-rna tjukarurru nyinarra. Tjingurun nyuntulu tjukarurru nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nyangka Yayipamalu watjarnu, “Wiya, nyuntulun kungka palunyaku puurrpa. Tjiinyanku nyuntuku palyalpayi. Nyangka nyuntulukurrurntu kulira watjanma.” Nyangka Tjarayilu mularrpartu ngarltumaaltu witu-wituranytja waarka purlkanya palyaratjaku. Nyangka palunyangurulta mayura wantirra kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Palunyalu mapitjalayintja yiwarra nyarra Tjuralakutu ngarala, palunyawana. Palunyalu kapi warla nyakulalpi tjikirnu. Nyangka Mama Kuurrku yayintjultu pitjangu-lu ");
INSERT INTO ntj_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","watjarnu, “Yayika, Tjarayikun waarka palyalpayi. Wanytjangurun pitjangu? Palunyalun wanytjatja yankukitja?” Nyangka watjarnu, “Wiya, ngayuku puurrpa-rna mayura wantirra kutipitjangu.” ");
INSERT INTO ntj_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nyangka-lu watjarnu, “Marlaku pinkurraara mapitja. Waarka-ra tirtu palyanma. ");
INSERT INTO ntj_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","11","Kuwarri-kuwarrin katja kanyilku. Palunyalun yini tjapilku Yitjumayilnga. Tjiinyamarntunta Mama Kuurrtu kulirnu purtun kulira yularranyangka. Nyangka ngayulu-rnanku tjamu kaparlipirti kanyilku pirnirritjaku-ya. Tjiinyanku-ya purtu parralku wantiku. ");
INSERT INTO ntj_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nyangka katjanku nyinarrayilku watirringkulalpi nganyirri purlkanya nyinama. Tjiinya-tjanampa yarnangu pirniku yanyan-yanyanpa nyinama. Nyangka-raya ngaparrtjika palunyaku yanyan-yanyanpa nyinama. Nyangka yungarrapirtingka nyinanytjamaalpa tjiinya mawurntalpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nyangka Yayikalunku yungarralu kulirnu, “Yuwa-watjala. Mama Kuurrnga-rna nyakulalpi mirrirringkutjamaalpa wanka tirtu nyinarra. Wiya, Mama Kuurrtu mularrpa nintilu nyakupayi.” ");
INSERT INTO ntj_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nyangka palunyanguru-ya kapi wiilpa palunyanya tjapirnu yini Piilarunya. Tjiinya Piilarunya ngaapirinypa, Wanka Tirtu Nyinapayilu-rni Nyakupayinya. Tjiinya kapi palunyanya ngarala Kaatitjala Pirirrta ngururrpa. ");
INSERT INTO ntj_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nyangka Yayikanya marlaku yanu palunyaku puurrkutu. Palunyalu katja kanyirnu. Palunyangka Yayipamalu yini tjapirnu Yitjumayilnga. ");
INSERT INTO ntj_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Nyangka palunyatjarralpi Yayipamaku-ra kurli 86-pa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Nyangka Yayipamanya nyinarrayirnu nyangka-ra kurli 99-pa ngaralanytja. Nyangka-lu Mama Kuurrtu yartakarringkulalpi watjarnu, “Yuwa, ngayulu-rna Mama Kuurrnga, Yayirninytjulu Palyalpayinya. Ngayuku wangka wangarnarralu kulira palyanma. Palunyatjanu tjukarurru nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ngayulu-rnanta tjukurrpa watjalku wantinyangka tirtu ngarama. Nyangka nyuntuku tjamu kaparlipirtinku-ya pirnirriku.” ");
INSERT INTO ntj_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nyangka Yayipamalu kuliralpi pupakatingu. Nyangka Mama Kuurrtu watjarnu, ");
INSERT INTO ntj_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tjukurrpa ngaanya tirtu ngaraku ngarama. Tjiinya nyuntulun kutjutjamu-tjanampan yarnangu kutjupa-kutjupa pirniku nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nyangkanku yini Yayipamanya wiyarriku. Nyangkanta-ya Yayipuramanya tjapinma. Tjiinyamarntu-tjanampan kutjutjamu yarnangu kutjupa-kutjupa pirniku nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nyuntuku tjamu kaparli-ya pirnirriku. Yuwa, nyuntuku tjamu kaparlipirti-ya pirnirringkulalpi ngurra kutjupa-kutjupangka nyinarra-wanarayinma. Nyangka-ya kutjupatjarra puurrpa purlkanya nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","8","Puru Mama Kuurrtu ngaapirinypa watjarnu, “Yuwa, mula-mulalu-rnanta kalkura nyuntunya puru nyuntuku tjamu kaparlipirti tjiinya marlangkatja-marlangkatja-ya pakaranyangka. Tjiinya-tjananyarna Mama Kuurrtu tirtu miranykanyira kanyinma. Tjiinyan pitjangu maliki nyinarra ngurra ngaa Kayinanta, ngurra palunyanya-rnanku nintilku nyuntuku tjamu kaparlipirtikutarrartu. Palunyanguru-rniya kulinma ngayulu-tjananyarna Mama Kuurrtu tirtu miranykanyira kanyinma. Nyangka tjukurrpa palunyanya tirtu ngaraku ngarama.” ");
INSERT INTO ntj_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nyangka Mama Kuurrtu puru Yayipuramala watjarnu, “Yuwa, nyuntulu purunku tjamupirtilu-rniya ngayuku wangka wangarnarralu kulira palyanma. ");
INSERT INTO ntj_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tjiinya nyuntulu purunku tjamupirti marlangkatja-marlangkatja pakaranytjatjanu watirringama. ");
INSERT INTO ntj_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Ngaanguru-yan ngaapirinymanama. Tjilku minarli yirti ngarrinyangka-yan tjirntu 7-tjanulu watinma. Nyangka waarka palyalpayiku katja yirti nyuntuku ngurrangka kanyiranytjanya-yan watinma. Nyangka ngurra kutjupangurulu waarka palyalkitja pitjalanyangka-yan katirra watinma. Palunyapirinypa palyaranytjalu-yan yartakanku tjiinya tjukurrpa ngayulu-rna nintintjanya-yan kulira palyara. ");
INSERT INTO ntj_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Palunyapirinypa-yan palyaranytjalu kulinma tjukurrpa-tjananyarnanta ngayulu watjarnu wantitjanya tirtu ngaraku ngarama. ");
INSERT INTO ntj_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nyangka watirringkutjamununya tjiinya marrkula wanti mungutja nyinarratjaku. Tjiinyamarntu ngayuku wangka wangarnarralu kulira palyaranytjamunu.” ");
INSERT INTO ntj_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nyangka Mama Kuurrtu-lu Yayipuramanya watjarnu, “Ngaangurun kurri Tjarayinya tjapintjamaaltu wantiku. Palunyalun Tjiiranya tjapinma. ");
INSERT INTO ntj_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Tjiinya ngayulu-rnalu walykumunura kanyinma. Nyangkanku nyuntuku katja yirti kanyilku. Tjiinyamarntu-rnalu walykumunura kanyiranyangka kutjukaparli nyinama yarnangu kutjupa-kutjupa pirniku. Nyangka-raya tjamupirti kutjupatjarra marlangkatja-marlangkatja pakaranytjalu puurrarringkula nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nyangka Yayipuramanya pupakatingu. Palunyalu yikarringkula kuliranytja, “Wati-munta-rna kurli 100-tjanulu katja yutilku? Nyangka-munta mularrpa Tjiiralu yirti mantjilku kurli 90-tjanulu? ");
INSERT INTO ntj_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Palya-tjinguru-tju katja Yitjumayiltu mantjilku nyuntulun kalkurnu wantinyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nyangka Mama Kuurrtu watjarnu, “Wiya, nyuntuku kurri Tjiiralunku katja kanyilku. Nyangkan yini tjapilku Yayitjikinya. Nyangka ngayulu-rnalu tjukurrpa watjalku wantinyangka tirtu ngaraku ngarama. Puru palunyaku tjamu kaparlipirti marlangkatja-marlangkatja pakaranytjaku-tjanampa tjukurrpa palunyanya tirtu ngarama. ");
INSERT INTO ntj_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tjiinya-rnanta kulirnu Yitjumayilkun tjapiranyangka. Nyangka-rnalu walykumunura kanyinma. Nyangka-ra tjilku puru tjamu pirnirringama. Nyangka palunyaku katja 12-pa-ya puurrpa nyinama ngurra kutjupa-kutjupangka. Yarnangu palunyanya-ya pirnirringkula-wanarayinma. Nyangka pirnilu-tjananyaya mirrawarnima. ");
INSERT INTO ntj_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nyangka Tjiiralu katja kanyilku ngaapirinytjartu kutjupa kurlingka. Nyangka-rnanku katja Yayitjikinya tjukurrpa watjalku wantinyangka tirtu ngaraku ngarama.” ");
INSERT INTO ntj_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nyangka Mama Kuurrnga Yayipuramala wangkangu wiyarringkula kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nyangka tjirntu palunyangkartu Yayipuramalu wangarnarralu palyarnu Mama Kuurrtu watjarnu wantitjanya. Tjiinya palunyaku katja Yitjumayilnga watirnu. Purunku waarka palyalpayi palunyaku ngurrangka yirtinguru purlkarringkutjanya watirnu. Puru waarka palyalpayi ngurrangka tjarrpatjura kanyiranytjalu watirnu. ");
INSERT INTO ntj_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tjiinya Yayipuramanya kurli 99-tjanu watirringu. ");
INSERT INTO ntj_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nyangka-ra katja Yitjumayilnga murtilya kurli 13-pa watirringu. ");
INSERT INTO ntj_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Tjiinya tjirntu kutjungkartu-ya Yayipuramanya, Yitjumayilnga, puru waarka palyalpayi pirninyartu watirringu. ");
INSERT INTO ntj_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nyangka Mama Kuurrnga Yayipuramala yartakarringu wati Mamurayiku warta miirl-miirlpa pirningka nyinarranyangka. Tjiinya Yayipuramanya karlarlarringkulalpi palunyaku tiinti tjaangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Palunyalu nyangu, “Wati marnkurrpa-ya ngaa ngarala!” Nyangka waarrpungkulalpi pakarnu-tjananya wangkakitja. Palunyalu pupakatirralpi-tjananya ");
INSERT INTO ntj_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","watjarnu, “Yuwa, walykumunu-yan ngayuku ngurrakutu pitjangu. Wantirralpi-ya nyina. Nyangka-tjananyarnanta yirringkala. ");
INSERT INTO ntj_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kapi-tjanamparnanku katiku tjina-yankun parltjiltjaku. Nyangka kuwarripa-ya wiltjangka nyina palyarriwa. ");
INSERT INTO ntj_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tjiinya mirrka-tjanamparnanku katiku nintilku. Nyangka-yan ngalkula palya yalatjarringkula yanku. Tjiinya-rna pukurlarringu ngayuku ngurrakutu-yan pitjanyangka. Nyangka-ya nyina nyangka-tjanamparnanku nintila.” Nyangka-ya watjarnu, “Yuwa, palya-latju nyinaku.” ");
INSERT INTO ntj_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Nyangka Yayipuramalu waarrpungkula mawirrtjarnu tiintingka tjarrparralpi watjarnu, “Minyma ngana, pakaralpi purlakarra purlkanya mantjila nyuma paala.” Nyangka mularrpartu pakarnu paarnu. ");
INSERT INTO ntj_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nyangka Yayipuramalu puluka pirnikutu kukurraaralpi puluka warlangu karnpi purlkanya ngurrkarntaralpi nintirnu waarka palyalpayilu pungkula paaltjaku. Nyangka pungu paaralpi Yayipuramaku katingu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nyangka miilki tangka, kukatarrartu katingu-tjanampa nintirnu. Nyangka-ya wiltjanguru nyinarra ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Palunyalu-ya tjapirnu, “Wanytjatjanku kurri Tjiiranya?” Nyangka Yayipuramalu watjarnu, “Pala tiinti kaninytjarra nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Nyangkalta wati kutjulu watjarnu, “Ngula-rna kurli kutjupangka marlaku pitjaku. Palunyangurulta nyuntuku kurrilu katja kanyilku.” Nyangka Tjiiralu tiinti tjaangurulu nyinarra kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Palunyalulta puriny-purinypa yikarringu, tjiinya kulirnunku, “Ngayulu-rnatju ngaanya pamparringu. Tjiinya-rna tjilku kanyilkitjamunu.” Tjiinya minyma palunyanya tjilku kanyiltjaku kutjulpirtu wiyarringu nyinarranytja. Nyangka-ra kurritarrartu yirna purlkanya nyinarranytja. Nyangka yungarralunku yikarringkula kuliranytja, “Wiya, ngayulu-litju wati minyma nyalparringu nyinarra. Ngayulu-munta-rna mukurringkula kurringka ngarrikitja?” ");
INSERT INTO ntj_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nyangka Mama Kuurrtu Yayipuramanya tjapirnu, “Nyaatjanungka Tjiiralu yikarringkulalpi watjarnu, ‘Mularrpa-munta-rna yirti mantjilku minyma pampa purlkalurtu?’ ");
INSERT INTO ntj_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Wiya, ngayulu-rna Mama Kuurrtu yayirninytjulu palyalpayi. Kutjupa-kutjupa-munta-rna purtu palyalku? Mularrpa-rna kurli kutjupangka pitjaku nyaku nyuntuku kurri tjilku yirtitjarra nyinarranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Nyangka Tjiiralu ngurluny-ngurlunyarringkulalpi watjarnu, “Wiya, yikarringkutjamunurtu-rna.” Nyangka watjarnu, “Wiya, mularrpan yikarringu.” ");
INSERT INTO ntj_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nyangka-ya wati marnkurrpa pakara yanu yiwarla Tjatamanya wararrangurulu walunyakukitja. Nyangka Yayipuramanya pakara wanarnu-tjananya mawantikitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Palunyangka Mama Kuurrnga yungarranku wangkarra kuliranytja, “Ngayulu-rna kumpitjunkutjamaaltu Yayipuramala watjalku yartakanku kuwarri-kuwarrinya-rna palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tjiinya wati palunyaku tjamupirti-ya pirnirringkula nyinama. Nyangka pirnilu-tjananya mirrawarnima. Tjiinya palunyalanguru-tjananyarna yarnangu yarla lipingkatja walykumunura kanyinma ");
INSERT INTO ntj_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Wati palunyanya-rna ngurrkarntanu palunyaku katja puru tjamupirti-tjananya tjukurrpa ngayunyatjarra nintipungkulatjaku nyangka-yayi ngayuku wangka wangarnarralu kulira palyara tjukarurru nyinama. Palunyapirinypa-ya nyinaku, nyangka wangka Yayipuramanya-rna kalkurnu wantitjanya yartakarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nyangka Mama Kuurrtu-lu Yayipuramanya watjarnu, “Wiya, pitjala-rniya tjakultjunkupayi tjiinya yiwarla nyarra Tjatamala puru Kumarala-ya kutjupa-kutjupa palyamunu palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nyangka-rna tjarungarala yanku nyaku, ‘Mularrpa-munta-rniya watjara?’” ");
INSERT INTO ntj_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Nyangka-pula wati kutjarranya tjarungarala yanu Tjatamalakutu. Nyangka Mama Kuurrnga wantingu nyinarranytja Yayipuramala. ");
INSERT INTO ntj_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nyangka Mama Kuurrnga tjapirnu, “Mularrpa-muntan yarnangu walykumunu palyalpayinya lurrtjuralpi mirrirntanku-tjananya palyamunu palyalpayingka? ");
INSERT INTO ntj_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tjiinya yarnangu 50-ya walykumunu nyinarranyangka pirninyartu-muntan mirrirntanku? Yiwarla palunyanya-muntan wantiku yarnangu walykumunu 50-ya mirrirritjakutarra? ");
INSERT INTO ntj_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Wiya, nyuntulun tjukarurrulu ngurrkarntara watjalpayi. Tjiinyan yarnangu manta lipingkatjanya tjukarurrulu ngurrkarntara watjalpayi. Nyangka-muntan tjukarurru nyinapayinyatarra lurrtjuralpi mirrirntanku?” ");
INSERT INTO ntj_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nyangka Mama Kuurrtu watjarnu, “Yuwa palya. Tjiinya-rna nyaku yarnangu 50-ya walykumunu nyinarranyangka yiwarla palunyanya-rna wantiku yarnangu palunyanya-ya mirrirritjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Nyangka Yayipuramalu watjarnu, “Puurr, ngayulu-rnanta watilukutju Puurrpa yilkaringkatja tjapira. Nyangka-rni mirrparnarrinytjamaaltu kulinma kurrurnpa rapalu-rnanta tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tjinguru-ya 45-pa walykumunu nyinarranyangka-muntan putakulurtu yiwarla palunyanya wiyalku?” Nyangka Mama Kuurrtu watjarnu, “Wiyalkitjamunu-rna yiwarla palunyanya yarnangu-ya 45-pa walykumunu nyinarranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nyangka Yayipuramalu puru tjapirnu, “Tjinguru-ya yarnangu 40 walykumunu nyinarranyangkan yaaltjinku?” Nyangka Mama Kuurrtu watjarnu, “Ngurra palunyanya-rna wiyalkitjamunu yarnangu 40-ya-tjinguru walykumunu nyinarranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Nyangka Yayipuramalu watjarnu, “Mirrparnarrinytjamaaltu-rni wanti puru-rna tjapiranyangka. Tjiinya-tjinguru-ya yarnangu 30 walykumunu nyinarranyangkan yaaltjinku?” Nyangka Mama Kuurrtu watjarnu, “Ngurra palunyanya-rna wantiku yarnangu 30 walykumunu nyakulalpi.” ");
INSERT INTO ntj_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Nyangka pururtu Yayipuramalu watjarnu, “Puurr, mirrparnarrinytjamaaltu-rni kulinma tjiinya-rnanta kurrurnpa rapalu tirtu tjapiranyangka. Tjingurun nyaku 20-ya walykumunu nyinarranyangka yaaltjinku?” Nyangka Mama Kuurrtu watjarnu, “Yiwarla-rna wiyalkitjamunu yarnangu 20 walykumunu nyakulalpi.” ");
INSERT INTO ntj_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Nyangka Yayipuramalu watjarnu, “Mirrparnarrinytjamaaltu-rni wanti. Kutjuwarra-rnanta ma-tjapiralpi wantiku. Tjiinya-tjingurun nyaku yarnangu 10-pa walykumunu nyinarranyangka yaaltjinku?” Nyangka Mama Kuurrtu watjarnu, “Wiyalkitjamunu-rna yarnangu-ya 10-pa walykumunu nyinarranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nyangka Mama Kuurrnga Yayipuramala wangkarrayirnu wiyarringkula yanu. Nyangkalta Yayipuramanya marlaku ngurrakutu yanu. ");
INSERT INTO ntj_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nyangka-pula yayintjulpa kutjarranya Yayipuramaku ngurra wantirra pitjalayirnu mungarrtjirringkula parrapitjangu yiwarla Tjatamaku. Nyangka Luutanya yiwarla palunyaku kayirrta nyinarranytja, tjiinya-ya wati pirni nyinarra wangkapayingka. Palunyalu nyangu wati-pula kutjarra pitjalayinnyangka. Palunyalu nyakula ngata-ngata mapitjangu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Palunyalu watjarnu, “Yuwa, walykumunu. Pitjaku-munta-pulan ngayuku ngurrakutu nyangka-pulanyarnanta yirringkanku? Nyangka-pulankun tjina parltjilku ngarriku tjirnturringkula yanku.” Nyangka-pula watjarnu, “Wiya palya, yilkaku-litju ngarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nyangka-pulanya tirtu yarltirranyangka-pula wanarnu palunyaku ngurrakutu. Nyangka Luutalunku waarka palyalpayi pirninya watjarnu mirrka nyuma, kuka walykumunutarrartu witara katitjaku. Nyangka-ya witarnu katingu-pulampa nintirnu. Nyangka-pula ngalkulayirnu parltjarringu. ");
INSERT INTO ntj_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nyangka kuwarripa-pula ngurra ngarrikitjangka-ya wati ngurrangkatjalu pitjangu ngurra palunyanya parrangururrtjunu. Wati pirninyartu-ya pitjangu yirna puru yangupalatarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Palunyalu-ya mirrarra Luutanya tjapiranytja, “Wati-pula kutjarra palangka yaaltjirringu? Kati-pulanya ngayulakutu-lanyatju.” Tjiinya-ya watjaranytja watirarra ngarrikitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nyangka Luutanya yilkaku pakaralpi tuu tjatapungu. ");
INSERT INTO ntj_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Palunyalu-tjananya watjarnu, “Wati pirni, palyamunurringkutjamaaltu-ya wanti. ");
INSERT INTO ntj_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kulila-ya. Ngayulu-rna yurntalpa kutjarra kanyira. Watiku ngurrpa-pula. Yurntalpa kutjarranya-rna ma-nintilku nyangka-yan kanyinma. Palunyalu-yan wati ngaanya-pulanya wantiku pampuntjamaaltu. Tjiinya wati kutjarra-rna ngayulu miranykanyira.” ");
INSERT INTO ntj_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nyangka-ya watjarnu, “Wiya, wati-langarriwa. Pitjangu-munta-lanyatjun malikilu puurrarringu watjara?” Nyangka-ya puru watjaranytja, “Wati-tiwarriwa tjiinya-latjunta ma-palyamunultjakutarra, wati palangka-pulanya munkarra.” Nyangka-ya Luutanya watiyurnturalpi tuu lampilkitja ngalyakukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nyangka-pula wati kutjarralu tuu yarlaralpi Luutanya yamirrinu tjarrpatjunu. Palunyalu tuu tjatapungu. ");
INSERT INTO ntj_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Palunyalu-pula wati pirninya kuru pupatjunu. Nyangka-ya purtu parrapantjurrmaranytja tuu pampulkitja. ");
INSERT INTO ntj_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nyangka-pula wati kutjarralu Luutanya watjarnu, “Yungarrapirti-muntanku-ya ngurra ngaangka nyinarra? Katja, yurntalpa, waputju-tjananya yarltirra yarra. ");
INSERT INTO ntj_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Tjiinyamarntu-litju pitjangu yiwarla ngaanya wiyalkitja. Tjiinya Mama Kuurrtu kulirnu ngurra ngaangkatjalu-ya palyamunu palyaranyangka. Palunyalu-linyatju witurnu ngurra ngaanya wiyaltjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nyangka Luutalu yanu palunyaku waputju kutjarrakutu. Tjiinya-pulampa kalkurnu yurntalpa nintilkitjalu. Palunyalu watjarnu, “Waarrpungkula-la pakara yarra. Tjiinyamarntu Mama Kuurrtu kuwarrinya watjarnu yiwarla ngaanya wiyalkitjalu.” Nyangka-pula kulirnu wantingu ngarlpululkanyu watjaranytjakukantjalu. ");
INSERT INTO ntj_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nyangka-pula yayintjulpa kutjarralu ngarringu mungayurnturalpi pakarnu Luutanya watjarnu, “Waarrpungkula pakala! Nyuntuku kurri, yurntalpa kutjarranya yarltirra kukurraala. Tjiinyamarntu Mama Kuurrtu ngurra ngaanya tililku tjarrpatjunku. Palunyangkatarrartu kukurraala!” ");
INSERT INTO ntj_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Nyangka Luutalu waarrpungkutjamaaltu kuwarripa kuliranytja. Nyangka Mama Kuurrtu nyakulalpi ngarlturringu-ra. Nyangkalta-pula wati kutjarralu Luutanya, palunyaku kurri puru yurntalpa kutjarranya yamirrira-tjananya yarltirra katingu. ");
INSERT INTO ntj_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nyangka yiwarla yilkakuralpi yayintjulpa kutjulu watjarnu, “Wankalpi-ya kukurraala. Pinkurraara-ya nyakunytjamaalpa tirtu kukurraala. Yapukutu-ya kukurraala mirrirritjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Nyangka Luutalu watjarnu, “Wiya, wanti-lanyatju palunyapirinypa watjantjamaaltu. ");
INSERT INTO ntj_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mularrpa-rnin walykumunulu wankarnu. Nyangka yapu nyarranya tiwa purlkanya ngarala-wanarayirni. Tjiinya-rna pitjalayilku ngatalpartu mirrirriku kutjupa-kutjupa palyamunu yartakarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Palya-munta-rna yiwarla nyarra ngamungkatjaku yanku nyinaku? Tjiinya yiwarla kurlunypa. Nyangka-rna tjarrparralpi wankarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nyangka watjarnu, “Yuwa, palya. Ngayulu-rna yiwarla palunyanya wiyalkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Waarrpungkula kukurraala. Tjiinya-yan pitjalayilku ngurrangka tjarrpanyangka-rna Tjatamanya wiyalku.” Tjiinya Luutalu yiwarla kurlunypa watjaranytja. Nyangka palunyangurulu-ya yini Tjawanya tjapirnu. Tjiinya yini Tjawanya wangka ngaapirinypa, Kurlunynga. ");
INSERT INTO ntj_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nyangka tjirntu pakarayinnyangka Luutanya-ya pitjalayirnu parrapitjangu Tjawalakutu. ");
INSERT INTO ntj_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nyangka Mama Kuurrtu waru parnti palyamunutjarra tjutipirti-pirtirnu ngurra nyarra Tjatamala Kumarala-pulanya. ");
INSERT INTO ntj_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Palunyangka-tjananya yarnangu pirninya, yanamulpa puru wartatarrartu kamparrayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nyangka Luutaku kurrilu pinkurraarnu nyakulalpi yapurringu. ");
INSERT INTO ntj_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nyangka Yayipuramanya ngarringu munga-mungangka pakara yanu ngurra nyarra Mama Kuurrta-lu wangkarranytja, palunyalakutu. ");
INSERT INTO ntj_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Palunyalu yapunguru walunyangu ngurra lipi Tjatamala Kumaralawana winyinpa purlkanya pakaranyangka. Tjiinyakurlu tjaparu kamparra winyinpa purlkanya tunngu-tunngunma, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tjiinya Mama Kuurrtu yiwarla kutjarranya tilira tjarrpatjunkukitjalu Yayipuramanya ngarltunytjulu kuliralpi palunyaku katja Luutanya-lu wankarura katingu. ");
INSERT INTO ntj_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nyangka Luutanya yiwarla Tjawala nyinarrayirnu ngurlurringu. Palunyalunku yurntalpa kutjarra-pulanya yarltirra katingu yapukutu. Palunyalu-ya pulpangka tjarrpangu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nyangka tjurtulunku marlanypa watjarnu, “Wiya, ngayuku-limpa mama yirnarringu. Nyangka-ya wati kutjupa nyinanytjamunurtu ngayunya-linya kurri yarltikitja. ");
INSERT INTO ntj_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nyangka-munta-lin wama nintilku Mamanya kakirinku? Palunyatjanu-lin ngarriku tjilkutjarrarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nyangka munga palunyangkartu-pula wayinpa nintirnu kakirinu. Nyangka kakiri ngarrirranyangka tjurtu tirnanya mapitjangu-lu ngarringu. Nyangka kakiri purlkanya ngarringu ngurrpartu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nyangka karlarlarringkulalpi tjurtu tirnalunku marlanypa watjarnu, “Pururtu-li wama nintila kakirila. Nyangka nyuntululpi ngarri. Nyangka-lin kutjarralu tjilku kanyilku mamangkatja.” ");
INSERT INTO ntj_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Nyangka-pula nyinarrayirnu mungarringkulalpi wama nintirnu kakirinu. Nyangka marlanyngalpi-lu pakarnu mapitjangu ngarringu. Nyangka pururtu kakiri ngarringu watarrku tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nyangka palunyangurulta-pula Luutaku yurntalpa kutjarranya mukalarringu mama yungarrangkatja. ");
INSERT INTO ntj_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nyangkalta tjurtu tirnalu katja kanyiralpi yini Mawapanya tjapirnu. Tjiinya palunyanya kutjutjamu-tjanampa Mawapaku tjamupirtiku. ");
INSERT INTO ntj_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nyangka marlanytju katja kanyiralpi yini Pinaminya tjapirnu. Tjiinya palunyanya kutjutjamu-tjanampa Yamanku tjamupirtiku. ");
INSERT INTO ntj_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","18","Nyangka Yayipuramanya-pula Tjiiranya mapitjangu ngurra yini Kiirala nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nyangka Mama Kuurrtu-lu Tjiiranya walykumunura kanyiranytja tjiinya-lu kalkurnu wantinytjalu. ");
INSERT INTO ntj_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nyangka nyinarrayirnu mukalarringkulalpi tjilku katja kanyirnu palunyaku kurri Yayipuramanya yirna purlkanya nyinarranyangka. Tjiinya tayimpa Mama Kuurrtu watjarnu wantitjala, palunyangka tjilku palunyanya ngarringu. ");
INSERT INTO ntj_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nyangka Yayipuramalu yini Yayitjikinya tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nyangka Yayipuramalu nyinarrayirnu ngurra 7-tjanulu katjanku watirnu wantingu tjiinyamarntu Mama Kuurrtu kutjulpirtu-lu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Tjiinya Yayipuramaku-ra kurli 100-pa ngaralanyangka Yayitjikinya ngarringu. ");
INSERT INTO ntj_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nyangka Tjiiralu watjarnu, “Wiya, Mama Kuurrtu-rni pukurlmanu. Nyangka-rna pukurlpa yikarringkula. Nyangka-rniya pirnilu kulilku pukurlpa yikarringama. ");
INSERT INTO ntj_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Wiya, pirnilu-rniya kuliranytja tjilku-rna kanyintjamaalpa nyinarrayilku wiyarritjaku. Nyangka-rna tjilku ngaanya kanyirnu wati yirnangkatja.” ");
INSERT INTO ntj_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nyangka tjilku palunyanya kurli marnkurrarringu mimi tjikintjamaalarringu. Nyangka Yayipuramalu-ra mirrka purlkanya palyarnu. Nyangka palunyaku yamatji pirnilu-ya pitjangu pukurltu ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nyangka Tjiiralu nyangu palunyaku nganartiku katja Yitjumayiltu palunyaku tjilku kurlunypa Yayitjikinya kanyira ngarlpurringkulanyangka. Tjiinya Yitjumayilnga minyma nyarra Yiitjipunyamartatjiku katja, tjiinya Yayipuramalu kutjulpirtu yutirnu minyma nyarra Yayikala. ");
INSERT INTO ntj_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Nyangka Tjiiralu-pulanya nyakulalpi Yayipuramanya watjarnu, “Witula-pulanya minyma waarka palyalpayinya katjararrartu. Minyma nyarraku katjalu tjimarri yulytjatarrartu mantjilkitjamunu nyuntulun wiyarrinyangka. Tjiinya ngayuku katjalu mantjilku kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nyangka Yayipuramalu kuliralpi tjurlpilyarringu katja Yitjumayilngatjirratja. ");
INSERT INTO ntj_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nyangka Mama Kuurrtu watjarnu, “Tjurlpilyarriku-kurlu-pulampan katjatjirratja puru minyma waarka palyalpayi Yayikanyatjirratja. Tjiiralunta watjaranyangka wangarnarralu kulira palyanma. Tjiinyamarntu-rna kalkurnu wantingu Yayitjikilangurunku tjamu kaparlipirti pirnirritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nyangka-rna minyma waarka palyalpayiku katjaku tjilku pirni nintilku. Nyangka-ya marlangkatja-marlangkatja pakaranytjatjanu purlkawati nyinama. Tjiinyamarntu Yitjumayilngatarrartunku katja nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nyangka ngarringu tjirnturringkulalpi Yayipuramalu pakarnu kapi tjutirnu minyarra puturlpirinytja. Palunyalu kapi, mirrka kalikiralpi Yayikaku nintirnu. Palunyalu tjilkurarra-pulanya witurnu wiyarnu. Nyangka mularrpartu-pula yankulayirnu mayu-mayu Piyatjiipalawana parranyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nyangka-pulampa kapi wiyarringu. Nyangka ngunytjulunku katja mantjiralpi wiltjangka ngarritjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Palunyalu tiwa-tiwa yanu nyinakatirralpi watjarnu, “Kamu-rnatju nyaku tjilku-tju mirrirrinyangka.” Nyangka nyinarra purtu kulira yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nyangka Mama Kuurrtu kulirnu tjilku yularranyangka. Nyangka yilkaringurulu yayintjultu watjarnu, “Yayika, nyaatjanungkan yularra? Ngurlumaalpa nyinama. Tjiinya Mama Kuurrtu kulirnu tjilkunku yularranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Pakara mapitja yampuralpi kanyila. Tjiinyamarntu-rnalu kanyilku palunyaku tjamupirti-ya pirnirritjaku. Nyangka pirnilu-tjananya mirrawarnima.” ");
INSERT INTO ntj_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nyangka Mama Kuurrtu kapi wiilpa yartakanu. Nyangka nyakula pakara yanu kapi minyarra puturlpirinytja tjutira katingu nintirnu katjaku. Nyangka tjikiralpi walykumunurringu. ");
INSERT INTO ntj_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nyangka Mama Kuurrtu tjilku palunyanya tirtu miranykanyiranytja. Nyangka purlkarringkulalpi kukaputju nyinarranytja purti yini Paranta. ");
INSERT INTO ntj_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nyangka palunyaku ngunytjulu-ra yankulayirnu kungka Yiitjipunyamartatji katingu kurri yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","34","Nyangka Yayipuramalu-pulanku puurrpa Yapimalu kalkurnu pukurlpa nyinakitjalu. Palunyanguru-ya ngurra palunyanya Piyatjiipanya tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nyangka Mama Kuurrtu kulirnu, “Yayipuramalu-munta-tju wangka wangarnarralu kulilku palyalku?” Palunyalu tjapirnu, “Yayipurama!” Nyangka-lu watjarnu, “Yuwa Puurr, kulira-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nyangka Mama Kuurrtu watjarnu, “Nyuntukunku katja kurrurnkurlu tjiinyan mukulyanytjulu kanyilpayilu yarltirra kati. Nyangka-pulan yankulayilku ngurra yini Murayaku parrapitjaku. Nyangka yapu nyarra ngayulu-rnanta nintitjunku, palunyangka-pulan tatilku. Nyangkanku katja wakalku tililku tjunkulalpi ngayuku nintilku.” ");
INSERT INTO ntj_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nyangka ngarringu mungayurntura Yayipuramalu pakarnu waru kartarntanu tungkingka tjunkulalpi Yayitjikinya puru waarka palyalpayi kutjarra-pulanya yarltingu. Palunyanguru-ya pakara yanu ngurra nyarra Mama Kuurrtu watjarnu wantitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mapitjalayirnu-ya, nyangka ngurra kutjarratjanulu Yayipuramalu ma-nyangu yapu palunyanya watingarrirranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Palunyalu waarka palyalpayi kutjarranya watjarnu, “Kuwarripa-pula nyinarra tungki miranykanyinma. Nyangka-litju ngurra nyarratja yanku Mama Kuurrnga marninypungku. Palunyanguru-litju marlaku pitjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Nyangka Yayipuramalu waru kurrkalpa Yayitjikiku nintirnu katirrayiltjaku. Palunyalu kunmarnu puru tjangitarrartu mantjira-pula yanu. Mapitjalayirnu-pula tiwa-tiwarringu, ");
INSERT INTO ntj_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","nyangka tjilku palunyalu tjapirnu, “Mama, tjapilku-munta-rnanta?” Nyangka Yayipuramalu watjarnu, “Nyaapa?” Nyangka Yayitjikilu watjarnu, “Tjiinya-lin kurrkalpa, tjangitarrartu katirrayirni. Nyangkanyka wanytjatja tjiipu warlangu wakara-lin tilira tjunkutjaku?” ");
INSERT INTO ntj_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nyangka Yayipuramalu watjarnu, “Wiya, Mama Kuurrtu-limpa nintilku.” Nyangka-pula tirtu mapitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yankulayirnu-pula parrapitjangu ngurra nyarra Mama Kuurrtu watjarnu wantinytjaku. Nyangka Yayipuramalu yapu tjunkula parrawanarnu katuralpi kurrkalpa tjunu. Palunyalunku katja mantjiralpi karrpirnu ngarritjunu. ");
INSERT INTO ntj_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Palunyalulta kunmarnu mantjiralpi wakalkitjangka, ");
INSERT INTO ntj_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mama Kuurrku yayintjultu yilkaringurulu watjarnu, “Yayipurama!” Nyangka watjarnu, “Yuwa, kulira-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Nyangka-lu watjarnu, “Wakalku-kurlunkun katja. Wanti. Tjiinya-rnanta nyangu nyuntulun Mama Kuurrku wangka wangarnarralu kulira palyaranyangka. Tjiinyanku katja kurrurnkurlu kanyintjamaaltu yinytjanulu-rni nintirnu.” ");
INSERT INTO ntj_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Nyangka Yayipuramalu pinkurraaralpi tjiipu marnti nyangu, tjiinya purnulu kata witurrpungu kanyiranyangka. Nyangka pukurlarringkula parrapitjangu mantjirnu. Palunyalunku katja yarrarnu walatjunu. Palunyalu tjiipu wakaralpi tilirnu tjunu Mama Kuurrku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Palunyalu yapu palunyanya yini tjapirnu, Yaawayilu Nintilpayinya. Palunyangurulta-ya kuwarrinya tirtu watjalpayi, “Yuwa, Mama Kuurrtu yapu yungarrangka nintilpayi.” ");
INSERT INTO ntj_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nyangka purulpi-lu yayintjultu watjarnu, ");
INSERT INTO ntj_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ngayulu-rna Mama Kuurrtu mula-mulalu kalkura tjiinya-rnanta walykumunura kanyinma. Tjiinyanku katja kurrurnkurlu kanyintjamaaltu yinytjanulu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Nyangka-rnanku tjamu kaparlipirti kanyilku pirnirringkula-ya minga-minga nyinarratjaku. Puru-tjananyarna kanyilku yanyan-yanyanpa nyinapayi pirninya-ya pungkula wiyaltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nyangka nyuntuku tjamupirtinguru-tjananyarna yarnangu yarla lipingkatja walykumunura kanyinma. Palunyapirinypa yartakarriku tjiinya-rnin kuwarrinya ngayuku wangka wangarnarralu kulirnu palyannyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nyangka Yayipuramanya-pula katjararra marlaku yanu waarka palyalpayi kutjarrakutu. Nyangka-ya lurrtjurringkula marlaku yanu ngurra nyarra Piyatjiipalakutu. Palunyalu-ya ngurra palunyangka tirtu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","24","Nyangka Yayipuramalu kulirnu palunyaku kurta Nayiyuku katja yurntalpa-ya pirnirringu. ");
INSERT INTO ntj_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","20","Nyangka Yayipuramaku kurri Tjiiranya nyinarrayirnu mirrirringu. Nyangka Yayipuramanya yularrayirnu pakara yanu-tjananya Yatjaku tjamupirtingka tjapilkitja. Mapitjalayirnu parrapitjalalpi-tjananya tjapirnu, “Yuwa, kutjurringu-rna. Mukurringkula-rna manta pulpatjarra payipungkula mirri tjarrpatjunkukitjalu.” Nyangka Yatjaku tjamupirtilu-ya watjarnu tjimarri 400-pangka payipungkutjaku. Nyangka Yayipuramalu mularrpartu nintirnu. Tjiinya ngurramaalpa maliki pitjangu ngurra palunyangka nyinarranytjalu manta payipungu. Palunyalu pakara yanu mirri mantjira katingu pulpa palunyangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Nyangka Mama Kuurrtu-lu Yayipuramanya ngarltunytjulu tirtu kanyiranytja nyangka tjilpi purlkarringu. ");
INSERT INTO ntj_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Nyangka wati kutju puurrpa-tjanampa nyinarranytja Yayipuramaku waarka palyalpayi pirniku. Nyangka-lu Yayipuramalu yarltirralpi watjarnu, “Yuwa, watjala-rni wanti ngayuku katjaku kurri ngurra ngaa Kayinanngamartatji ngurrkarntankutjamaaltu wantikitjalu. Wiya, ngayuku ngurrakutu kutipitja ngayuku yungarrapirtikutu. Palunyalu kungka ngurrkarntara kati ngayuku katjalu yarltitjaku. Watjala-rni wanti Mama Kuurrta mirangka, tjiinya manta yilkariku Puurrta mirangka.” ");
INSERT INTO ntj_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nyangka waarka palyalpayilu watjarnu, “Tjinguru-rna kungka palunyanya purtu yarltiku ngayula-rni pitjatjaku. Palunyangka-munta-rna nyuntuku katja marlakulu witulku yankula ngurra palunyangka kurri ngurriltjaku?” ");
INSERT INTO ntj_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nyangka Yayipuramalu watjarnu, “Wiya, wanti ngayuku katja nyinatjaku. Witulku-kurlun nyarratja yankutjaku. Wanti. ");
INSERT INTO ntj_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tjiinya Mama Kuurrtu Puurrpa yilkaringkatjalu-rni ngurraranguru yarltirra katingu ngurra ngaangka nyinatjunu. Palunyalu-rni kalkurnu wantingu ngurra ngaanya nintilkitjalu ngayuku, puru ngayuku tjamu kaparlipirtikutarrartu. Kutju-palunyalunta yayintjulpa witulku kurranyu kutipitjatjaku. Nyangkan kungka yarltirra katiku nintilku ngayuku katjalu yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wiya-tjingurun kungka purtu walalku wantiku. Tjiinya palya. Nyangka-kurlun ngayuku katja kutikatiku ngurra palunyakutu. Wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nyangka-lu waarka palyalpayilu mularrpartu watjarnu wantingu palunyapirinypa palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nyangka waarka palyalpayilu kutjupa-kutjupa walykumunu pirni mantjiralpi Yayipuramaku kamurlpa 10-ta tjunu. Palunyalu wati marnkurr-marnkurrpa yarltirra pakara kutipitjangu ngurra tiwaku, ngurra nyarra Yayipuramaku kurta Nayiyunya nyinarrayirnu wiyarringu, palunyalakutu. ");
INSERT INTO ntj_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pitjalayirnu-ya parrapitjangu kapi wiilpa ngaralanyangka kamurlpa pirninya pupatjunkulalpi tjarungarangu. Tjiinya-ya mungarrtji-mungarrtji parrapitjangu. Nyangka-ya minyma pirni wiilkutu pitja-pitjalanytja kapi tjutilkitja. ");
INSERT INTO ntj_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nyangka waarka palyalpayilu Mama Kuurrnga tjapirnu, “Yuwa, ngayuku puurrpa Yayipuramalunta pupakatirra marninypungkupayi. Nintitjurra-rni nyangka-rnayi tjurrkurltu ngurrkarntarra kurri ngayuku puurrku katjalu yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Yuwa, kungka pirni-ya nyarra pakarnu yiwarlanguru pitjalayirni kapi tjutira makatikitja. ");
INSERT INTO ntj_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nyangka-rna kutju tjapilku, ‘Kapi-rni nintila tjikiltjaku.’ Nyangka tjinguru-tju nintilku. Palunyalu watjalku, ‘Kamurlkutarrartu-rna kapi tjutira katiku nintilku.’ Yuwa, palunyapirinypa watjannyangka-rna nintilu kulilku nyuntulun kungka palunyanya ngurrkarntankunyangka tjiinyamarntun ngayuku puurrpa mukulyanytjulu kanyiranytjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nyangka kuwarripa tjapiranyangka kungka yini Ripakanya waalkarrarnu, kapingkatja takungka katirrayintja. Tjiinya kungka palunyanya Patjiyulku yurntalpa. Nyangka-ra tjamu Nayiyunya, Yayipuramaku kurta. Nyangka-ra kaparli Milkanya. ");
INSERT INTO ntj_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Tjiinya kungka palunyanya yiiku walykumunu, puru watiku ngurrpa nyinapayi. Palunyalu wiilkutu mapitjangu kapi tjutira marlaku pitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nyangka Yayipuramaku waarka palyalpayilu watiwirrtjarnu tjapirnu, “Kapi-munta-rnin nintilku tjikiltjaku-rna?” ");
INSERT INTO ntj_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nyangka watjarnu “Yuwa, tjikila.” Nyangka kapi tjarutjunu kanyirnu tjikiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nyangka mularrpartu tjikirnu kapitjanurrinyangka watjarnu, “Kapi-rna tjutira katiku kamurlkutarrartu nintilku.” ");
INSERT INTO ntj_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nyangka mularrpartu-tjanampa tirtu tjutira katirra nintiranytja. Nyangka-ya tjikirnu kapitjanurringu. ");
INSERT INTO ntj_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nyangka Yayipuramaku waarka palyalpayilu wangkamaaltu nyakula kuliranytja, “Mularrpa-tjinguru-rni Mama Kuurrtu kungka ngaanya nintitjunu. Nyangka-rnara puurrku katjaku ngurrkarntanku.” ");
INSERT INTO ntj_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Nyangka kamurltu-ya tjikirnu wiyarrinyangka waarka palyalpayilu yamirringkatja puru mulyangkatja walyku-walykumunu yakutjangkatja mantjiralpi tjarrpatjunu-lu kungka palunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","25","Palunyalu watjarnu, “Watjala-rni. Mamanku yini ngananya?” Nyangka watjarnu, “Ngayuku mama yini Patjiyulnga, Nayiyuku-pulampa Milkaku katja.” Nyangka watjarnu, “Purtu-rna kulira. Wanytjatja-latju ngarriku? Nyuntuku mamaku yiwarla-tjinguru kurlunypa.” Nyangka watjarnu, “Wiya, yurirlpa-latju kanyira ngarritjaku-yan. Puru-latju mirrka kamurltatja kanyira.” ");
INSERT INTO ntj_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nyangka waarka palyalpayilu kata pupakatirralpi Mama Kuurrnga marninypungu, ");
INSERT INTO ntj_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Yuwa Mama, walykumunulun Yayipuramanya kanyira. Tjiinya-rnin tjurrkurltu katingu palunyaku yungarrapirtikutu, tjiinyan ngayuku puurrpa mukulyanytjulu kanyiranytjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nyangka Ripakanya ngurrakutu kukurraarnu-tjananya tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Nyangka palunyaku kurta Layipantu yamirringkatja mulyangkatjatarrartu nyangu puru tjukurrpa kulirnu watjannyangka. Palunyalu ngata-ngata kukurraaralpi nyangu wati palunyanya-ya kamurltjarra wiilta ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Palunyalu watjarnu, “Yuwa, Mama Kuurrtu-tjananyanta walykumunulu katingu ngurra ngaaku. Nyangka-rniya wanala ngurrakutu. Tjiinya yurirlpa ngarala ngarritjaku-yan puru-tjanampanku kamurlpatarrartu. Nyaaku-yan yilkaku tirtu ngarala?” ");
INSERT INTO ntj_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nyangka mularrpartu-ya Layipannga wanarnu ngurrakutu. Nyangka Layipantu luurrpa kamurltatja yarrarnu tjunu. Palunyalu mirrka kamurlku nintirnu. Palunyalu kapi katingu tjunu Yayipuramaku waarka palyalpayilu-yanku tjina parltjiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Palunyalu mirrka kuka katingu tjunu. Parturtu wati palunyalu watjarnu, “Wiya, kuwarripa wanti. Ngarnmanytju-rna tjukurrpa watjala. Palunyalu-rna marla ngala.” Nyangka Layipantu watjarnu, “Yuwa, tjukurrpa watjala.” ");
INSERT INTO ntj_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nyangka wati palunyalu watjarnu, “Ngayulu-rna Yayipuramaku waarka palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Nyangka Mama Kuurrtu ngayuku puurrpa walykumunura kanyiranytja. Nyangka yulytja pirnitjarra nyinarra. Tjiinya Mama Kuurrtu-ra yanamulpa pirni nintirnu, tjiipu, nanikuurrpa, puluka, kamurlpa puru tungkitarrartu. Puru-ra tjimarri purlkanya, puru waarka palyalpayi pirni nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nyangka palunyaku kurri Tjiiranya tjilkumaalpa nyinarrayirnu pamparringkulalpikutju katja kanyirnu. Nyangka ngayuku puurrtu-ra katja palunyaku pirninyartu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Palunyalu-rni ngaapirinypa watjarnu, ‘Watjala-rni wanti ngayuku katjaku kurri ngurra ngaa Kayinanngamartatji ngurrkarntankutjamaaltu wantikitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Wiya, ngayuku mamaku ngurrakutu kutipitja ngayuku yungarrapirtikutu. Palunyalu kungka ngurrkarntara kati ngayuku katjalu yarltitjaku.’ ");
INSERT INTO ntj_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nyangka-rna tjapirnu, ‘Nyangka-tjinguru-rna kungka palunyanya purtu yarltiku. Palunyalu-rna yaaltjirriku?’ ");
INSERT INTO ntj_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nyangka watjarnu ‘Wiya, Mama Kuurrnga tjiinya-rna tirtu wanalpayi, palunyalunku yayintjulpa witulku lurrtjurringkula-pulan kutipitjatjaku. Nyangkan palya kungka ngurrkarntanku ngayuku yungarrapirtingkatja tjiinya ngayuku katjalu yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wiyangka-tjingurun kungka ngurrkarntaralpi purtu yarltiku tjiinya-luya marrkura kanyiranyangka, palyan wantirra pitjaku.’ ");
INSERT INTO ntj_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Nyangka-rna kuwarrinya pitjangu wiilnguru ngarala kurrurntukutju ngaapirinypa tjapiranytja, ‘Yuwa Mama Kuurr, ngayuku puurrpa Yayipuramalunta pupakatirra marninypungkupayi. Nyangka-rni kungka nintitjurra palunyaku katjalu kurri yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nyawa-rni wiilta-rna ngaralanyangka. Nyangka kungkawara kapiku pitjanyangka-rna tjapilku kapi-rni nintiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Nyangka tjinguru-rni nintilku palunyalu watjalku kamurlkutarra nintilkitjalu. Nyangka-rna nintilu kulilku tjiinyan kungka palunyanya nintitjunkunyangka.’ ");
INSERT INTO ntj_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nyangka kuwarripa-rna kurrurntukutju tjapiranyangka Ripakanya waalkarrara pitjangu, tjiinya kapingkatja takungka katirrayintja. Palunyalu wiilkutu mapitjangu kapi tjutirnu. Nyangka-rna tjapirnu, ‘Kapi-munta-rnin nintilku tjikiltjaku-rna?’ ");
INSERT INTO ntj_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Nyangka waarrpungkulalpi kapingkatja tjunkulalpi watjarnu, ‘Tjikila wanti. Nyangka-rna kamurlkutarra kapi tjutira kati nintila.’ Nyangka-rna tjikirnu wantinyangka kamurlkutarra tjutira katingu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Nyangka-rna tjapirnu, ‘Mamanku yini ngananya?’ Nyangka-rni watjarnu, ‘Ngayuku mama Patjiyulnga tjiinya Nayiyuku-pulampa Milkaku katja.’ Nyangka-rna yakutjangka ngarrirranyangka yamirringkatja puru mulyangkatja mantjira katingu tjunu-lu. ");
INSERT INTO ntj_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Palunyalu-rna kata pupakatirralpi Mama Kuurrnga marninypungu, tjiinya ngayuku puurrpa Yayipuramalu pupakatirra marninypungkupayi, palunyanya. Tjiinya-rni tjurrkurltu katingu ngayuku puurrku yungarrapirtikutu. Nyangka-rna kungka ngurrirnu ngayuku puurrku katjalu yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nyangka-yan nyaapirinypa kulira? Kungka-munta-yan witulku? Nyangkayi ngayuku puurrtu nyawa pukurlarri. Tjinguru-yan wiyarnmankunyangka-rna yaaltjirriku? Tjinguru-rna kutjupaku ngurrilku. Wiya-tjinguru-rna wantirra kutipitjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nyangka Layipantu-pula Patjiyultu watjarnu, “Wiya, Mama Kuurrtunta nintitjunu. Kamu-litju marrkulku kanyilku. ");
INSERT INTO ntj_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Yuwa, Ripakanya ngaanya nyinarra. Yarltirra-lu makati. Nyangkayi nyuntuku puurrku katjalu yarlti, tjiinya Mama Kuurrtu watjarnu wantinyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Nyangka Yayipuramaku waarka palyalpayilu kuliralpi pupakatingu Mama Kuurrnga marninypungu. ");
INSERT INTO ntj_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Palunyalu warntu walykumunu puru tjilpa kawurlpatarrartu katingu Ripakaku nintirnu. Puru kutjupa-kutjupa walykumunu nintirnu palunyaku kurtaku ngunytjukutarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nyangka Yayipuramaku waarka palyalpayilu puru wati nyarra lurrtju pitjanytjalu-ya mirrka kuka ngalangu parltjarringu. Palunyalu-ya ngarringu tjirnturringkulalpi wati palunyalu pakaralpi watjarnu, “Witula-rni puurrtakutu-latju marlaku yankutjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nyangka-pula Ripakaku kurtalu ngunytjulu watjarnu, “Wiya, kuwarripa wanti. Nyangkayi nyina wiiki kutjarratjanu pakara kutipitja.” ");
INSERT INTO ntj_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nyangka watjarnu, “Marrkuntjamaaltu-rniya wanti. Tjiinya Mama Kuurrtu-rni tjurrkurltu nintitjunu. Witula-rniya nyangka-latjuyi marlaku kutipitja ngayuku puurrkutu.” ");
INSERT INTO ntj_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nyangka-pula watjarnu, “Kuwarripa nyina. Ripakanya-litjuyi yarlti. Nyangkayi pitja yungarralu watjala.” ");
INSERT INTO ntj_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nyangka-pula mularrpartu Ripakanya yarltirralpi tjapirnu, “Nyaapan kulira? Kuwarrinyartu-muntan kutipitjaku wati ngaangka?” Nyangka watjarnu, “Yuwa, kutipitjakitja-rna.” ");
INSERT INTO ntj_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Nyangka-ya Ripakanya witurnu Yayipuramaku waarka palyalpayingka-tjananya kutipitjatjaku. Puru-ya minyma pampa tjiinya Ripakanya kanyirnu purlkantjanya, palunyanyatarrartu witurnu. ");
INSERT INTO ntj_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Palunyalu-ya Ripakaku walykumunu watjarnu, “Yuwa marlany, Mama Kuurrtunta walykumunura kanyinma nyuntuku tjamu kaparli-ya pirnirritjaku. Nyangka-yayi yanyan-yanyanpa pirninya pungkula wiyanma, Mama Kuurrtu-tjananya kanyiranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nyangka Ripakanya puru kungka palunyaku palyalpayi pirninya-ya pakara kamurlta tatira Yayipuramaku palyalpayingka kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nyangka tjiinya Yayitjikinya kapi nyarra Piilarula nyinarrayirnu wantirra pitjangu Kayinanta yurlparirra nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Palunyalu mungarrtji-mungarrtji pakara mapitjangu yilkaku parrangaralanytja. Palunyalu nyangu kamurlpa pirni-ya tiwa pitjalayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Nyangka Ripakalu Yayitjikinya nyakulalpi kamurlnguru tjarungaralalpi ");
INSERT INTO ntj_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","tjapirnu, “Wati nyarranya ngananya ngata-ngata pitjalayirni?” Nyangka Yayipuramaku waarka palyalpayilu watjarnu, “Ngayuku puurrpa Yayitjikinya.” Nyangka Ripakalunku yangki mantjiralpi yiiku tjuturnu. ");
INSERT INTO ntj_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nyangka Yayipuramaku waarka palyalpayilu parrapitjangu Yayitjikila tjukurrpa pirni watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Nyangka Yayitjikilu Ripakanya yarltirra katingu tiintikutu. Nyangka-pula yarltingu nyinarranytja. Nyangka Yayitjikinya Ripakaku mukulyanytju nyinarranytja. Nyangka-lu pukurlmara kanyiranytja tjiinyamarntu tjirturu-tjirturu nyinarranytja palunyaku ngunytju rawamunu mirrirrinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nyangka Yayipuramalu kurri kutjupanya yarltingu yini Katuranya. ");
INSERT INTO ntj_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","4","Nyangka minyma palunyalu katja marnkurrpa-marnkurrpa kanyirnu. Nyangka palunyanguru tjamu-ra pirnirringu. ");
INSERT INTO ntj_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Nyangka Yayipuramalu wankalulpi kutjupa-kutjupa walykumunu katja 6-ku-tjanampa nintirnu. Palunyalu-tjananya wituralpi watjarnu, “Mapitja-ya kakarrara nyinama.” Tjiinya Yayitjikila-ya ngamu nyinatjakutarra-tjananya witurnu tiwa-ya yankula nyinatjaku. Palunyalu Yayipuramalu mirrirrikitjalu watjarnu wantingu Yayitjikilu-ra yulytja pirninyartu mantjiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Nyangka Yayipuramanya nyinarrayirnu kurli-ra 175 ngaralanyangka mirrirringu. Tjiinya yirna purlkanya mularrpa. ");
INSERT INTO ntj_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Nyangka palunyaku katja Yayitjikilu-pula Yitjumayiltu mirri makatingu pulpangka tjarrpatjunu palunyaku kurri Tjiirala yitingka. Tjiinya pulpa palunyanya yini Makapalanya ngurra yini Mamurayila kakarrara ngaralanytja, wati yini Yiipuranku mantangka. Wati palunyanya Tjawaku katja, tjiinya wati yini Yatjaku wartangkatja. Tjiinya Yayipuramalu kutjulpirtu pulpa palunyanya payipungu. Nyangka-pula pulpa palunyangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Nyangka Yayipuramanya mirrirrinyangka Mama Kuurrtu palunyaku katja Yayitjikinya miranykanyira kanyiranytja. Nyangka ngurra nyarra Piilarula nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","18","Nyangka Yayipuramaku katja Yitjumayilnga, tjiinya minyma nyarra Yayikalu kanyirnu, palunyalu katja 12-pa yartakanu. Palunyanguru palunyaku tjamupirti-ya pirnirringu. Palunyalu-ya mawurntalpa nyinarranytja kakarrara. Nyangka Yitjumayilku-ra kurli 137-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Tjukurrpa ngaanya Yayipuramaku katja Yayitjikinyatjarra. ");
INSERT INTO ntj_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tjiinya Yayitjikiku-ra kurli 40 ngaralanyangka kurrinku yarltingu Layipanku nyarrumpa Ripakanya, tjiinya wati Patjiyulku yurntalpa. Wati palunyanya ngurra nyarra Yaramanyangurrara. ");
INSERT INTO ntj_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nyangka Ripakanya tirtu tjilkumaralpa nyinarranytja. Nyangka-ra Yayitjikilu Mama Kuurrnga tjapirnu. Nyangka Mama Kuurrtu kulirnu. Nyangka Ripakanya mularrpartu mukalarringu. ");
INSERT INTO ntj_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Palunyalu mirarnunku mukala kaninytjarra yurntu-yurnturanytja. Nyangka nintilu kuliranytja kutjarra kanyilkitjalu. Palunyalu kuliranytja, “Nyaatjanu-rni yurntu-yurntura?” Nyangka tjapirnu Mama Kuurrtu-lu watjara yutiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Nyangka Mama Kuurrtu watjarnu, “Nyuntulun katja kutjarra kanyilku. Nyangka-pulampa tjamupirti minga-minga nyinama. Nyangka-yanku ngaparrku-ngaparrkulu yanyan-yanyantu payinma. Nyangka katja marlangkatjaku-ra tjamupirtilu-ya kurtaku tjamupirti puurrarringkula kanyinma. Nyangka-ya marlangkatjaku tjamupirtiku waarka palyanma.” ");
INSERT INTO ntj_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nyangka mularrpartu Ripakalu katja kutjarra kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nyangka-ra katja tirnanya minyarra tjitirn-tjitirnpa puru purrmu purlkanya ngarringu. Nyangka-pula yini tjapirnu Yiitjunya. ");
INSERT INTO ntj_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nyangka marlangkatjalu kurtaku tarta witurrpungkulalpi ngarringu. Nyangka-pula yini tjapirnu Tjayikapanya. Palunyatjarralpi palunyaku mama Yayitjikiku-ra kurli 60 ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nyangka tjilku palunyanya-pula nyinarrayirnu purlkarringu. Nyangka kurta Yiitjunya kukaputju wampartaku nintipuka purtiwana parrangarapayi. Nyangka Tjayikapanya-parturtu ngurrangka nyinapayi, tjiinya ngurrangurulu tjiipu nanikuurrpa miranykanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Nyangka mama Yayitjikinya katja Yiitjuku mukulyanytju nyinapayi. Tjiinyamarntu kuka purtingkatja pukurltu ngalkupayi Yiitjulu wakara katirra nintiranyangka. Nyangka ngunytju Ripakanya Tjayikapaku mukulyanytju nyinapayi. ");
INSERT INTO ntj_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nyinarrayirnu-ya nyangka Tjayikapalu mirrka tjuupa yurninytjarra kurrkaltjuranytja. Nyangka Yiitjunya walatjanu pitjangu nungkumunu. ");
INSERT INTO ntj_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Palunyalu Tjayikapanya watjarnu, “Parltjatjirratja-rna. Nintila-rni mirrka pala tjitirn-tjitirnnga.” Palunyalanguru-ya Yiitjunya yini kamparntalpa tjapiranytja Yiitamanya. Tjiinya Yiitamanya wangka ngaapirinypa, Tjitirn-tjitirnnga. ");
INSERT INTO ntj_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Nyangka Tjayikapalu watjarnu, “Yuwa palya. Nyangka nyuntulu-rni ngarnmanytju watjala wanti. Tjiinya nyuntulu-tjun kurta purlkanya nyangka-rnanku nyuntuku marlanypa. Nyangkan ngula Mamaku yarangka ngarama mirrirrinyangka. Ngulan puurrpa nyinaku purun Mamaku yulytja kutjupa-kutjupa mantjilku. Nyangka Mama Kuurrtunta walykumunura kanyinma tjamu Yayipuramanya kalkuntjatjanulu. Yuwa, watjala-rni wanti ngayululpi-rna kurtapirinyarritjaku. Nyangka-rnanta mirrka nintilku.” ");
INSERT INTO ntj_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Nyangka Yiitjulu watjarnu, “Wiya palya. Parltjatjirratja-rna mirrirrikitja. Palunyatjanu-rna Mamaku yarangka ngarakitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Nyangka Tjayikapalu watjarnu, “Ngarnmanytju-rni watjala wanti.” Nyangka Yiitjulu-lu mularrpartu Tjayikapanya watjarnu wantingu kurtapirinypa nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Nyangka Tjayikapalu-ra nyuma tjuupatarrartu nintirnu. Nyangka ngalangu nungkurringkulalpi pakara yanu. Tjiinya kuliranytjamunu kurta tirtu nyinakitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nyangka yayilurru puru ngarangu ngurra palunyangka tjiinya kutjulpirtu Yayipuramanya wanka nyinarranyangkalpi ngarangu, palunyapirinypa. Nyangka Yayitjikinya kutipitjangu ngurra yini Kiiralakutu puurrpa Yapimanya nyinarranyangka. Tjiinya wati palunyanya puurrpa ngurra yini Pilitjiku nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tjiinya Mama Kuurrtu Yayitjikila yartakarringkulalpi watjarnu, “Kutipitjaku-kurlun ngurra Yiitjipuku. Wanti. Ngurra ngaa ngamuwana parrapitjala ngurra tjunkula nyinama, tjiinya-rnanta nintitjunkunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Palyartun maliki nyinama. Ngayulu-rnanta ngamu nyinarranytjalu walykumunura kanyinma. Palunyalu-rnanku ngula ngurra ngaanya nintilku puru nyuntuku tjamupirtikutarrartu, tjiinya-rna kurranyululpi nyuntuku mama Yayipuramanya kalkurnu wantinytjalu. ");
INSERT INTO ntj_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Puru-rnanku tjamu kaparlipirti kanyilku pirnirringkula-ya minga-minga nyinarratjaku. Palunyalu-tjanamparna ngurra ngaanya nintilku. Palunyalu-tjananyarna ngula nyuntuku tjamupirtinguru yarnangu yarla lipingkatja walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Yuwa, palunyapirinypa yartakarriku tjiinya Yayipuramalu ngayuku wangka wangarnarralu kulira palyantjatjanungka.” ");
INSERT INTO ntj_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nyangka mularrpartu Yayitjikinya kutipitjangu Kiirala nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nyangka-ya wati ngurrangkatjalu palunyaku kurri Ripakanya nyakulalpi tjapirnu, “Minyma ngaanya ngananya?” Nyangka Yayitjikilu watjarnu, “Wiya, ngayuku-tju nyarrumpa.” Tjiinya ngurlurringkulalpi watjarnu tjiinya-ya pungkulalpi Ripakanya mantjiltjakutarra. Tjiinyamarntu Ripakanya kuru mantjil-mantjilpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nyangka-pula nyinarrayirnu, nyangka puurrpa Yapimalu wintangurulu nyangu Yayitjikilu Ripakanya yampura nyunytjuranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nyangka Yayitjikinya yarltirralpi watjarnu, “Yuwa-parta? Nyuntuku kurri-watjala Ripakanya? Nyaatjanungka-tjananyan mayurnu watjarnu nyuntukunku nyarrumpa nyinarranyangka?” Nyangka watjarnu, “Wiya, kulirnu-rna tjinguru-rna kurri watjannyangka-rniyan pungku kungka palunyanya mantjilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Nyangka puurrpa Yapimalu watjarnu, “Nyaaku-lanyatjun mayurnu watjarnu? Wati kutju-tjingurunku nyarrumpakukantja ngarrima nyuntuku kurringka. Nyangka-tjinguru-lanyatjun tjitjarntanama.” ");
INSERT INTO ntj_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nyangka puurrpa Yapimalu palunyaku yarnangu pirninya ngurlutjunu Yayitjikinya palunyaku kurritarrartu pampuntjamaaltu wantitjaku mirrirntankutjakutarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nyangka Yayitjikilu manta tjawara yurninypa pirni tjunkula-wanarnu. Nyangka paka-pakaralpi mirrka purlkarringu tjiinyamarntu Mama Kuurrtu-lu walykumunura kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","14","Tjiinya-ra mirrka purlkarringu puru tjiipu pulukatarrartu pirnirringu. Nyangka waarka palyalpayi pirni puru yulytja purlkanyatarrartu kanyiranytja. Nyangka-ya yarnangu Pilitjinyamartatjilu rawalu nyangu-nyangu karurr-karurrarringu. ");
INSERT INTO ntj_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Palunyalu-ya pitjangu wiilpa pirninya kantura tjuturanytja, tjiinya Yayipuramaku waarka palyalpayilu-ya kutjulpirtu tjawarnu wantinytjanya. ");
INSERT INTO ntj_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Nyangka puurrpa Yapimalu Yayitjikinya watjarnu, “Ngurra-lampatju wantirra kutipitja. Tjiinyamarntu-yan pirnirringu. Wayirntanu-lanyatjuyan nyinarra. Nyangka-latju ngatalpa nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Nyangka Yayitjikinya-ya pakara yanu karru Kiirala yitingka ngurra tjunkulalpi nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Palunyalu-ya wiilpa pirni puru tjawara kapi yutiranytja. Tjiinya palunyaku mamaku waarka palyalpayilu-ya tjawarnu wantinyangka wati Pilitjinyamartatjilu-ya pitjangu tjuturnu, palunyanya-ya puru tjawaranytja. Nyangka Yayitjikilu kapi yini tjapiranytja, palunyaku mamalu tjapintjanya. ");
INSERT INTO ntj_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nyangka-ya Yayitjikiku waarka palyalpayilu karrungka tjawarnu kapi yutirnu. ");
INSERT INTO ntj_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nyangka-ya tjiipu miranykanyilpayi Kiiranyamartatjilu pitjangu Yayitjikiku tjiipu miranykanyilpayi pirninya pika-pikaralpi watjarnu, “Wiya, kapi ngaanya ngayuku-lampatju.” Nyangka Yayitjikilu wiilpa palunyanya tjapirnu Pika-pikaranytjanya. ");
INSERT INTO ntj_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nyangka-ya Yayitjikiku waarka palyalpayilu kapi kutjupalpi tjawarnu yutirnu. Nyangka-ya Kiiranyamartatjilu puru pitjangu pika-pikaranytja. Nyangka Yayitjikilu wiilpa palunyanya tjapirnu yini Yanyan-yanyannga. ");
INSERT INTO ntj_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nyangka-ya pakara kutipitjangu kapi kutjupalpi tjawarnu yartakanu. Nyangka-ya nyangu wantingu pika-pikantjamaaltu. Nyangka Yayitjikilu wiilpa palunyanya tjapirnu Yarla Lipinya. Palunyalu watjarnu, “Mama Kuurrtu-lampa yarla lipi nintirnu tjiinya-lan pirnirringkula ngurra ngaangka nyinarratjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nyangka Yayitjikinya pakara ngurra palunyanya wantirra kutipitjangu ngurra nyarra Piyatjiipala nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nyangka mungangka Mama Kuurrtu-lu yartakarringkulalpi watjarnu, “Ngayulu-rna Mama Kuurrnga, tjiinya nyuntuku mama Yayipuramalu-rni pupakatirra marninypungkupayinya. Nyangka ngurlumaalpa nyinama. Ngayulu-rnanta tirtu nyinarra. Palunyalu-rnanta walykumunura kanyinma. Nyangkanku tjamupirti pirnirriku. Tjiinyamarntu-rna kalkurnu wantingu ngayuku waarka palyalpayi Yayipuramanya.” ");
INSERT INTO ntj_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nyangka Yayitjikilu yapu pirni parratjunkula-wanarnu katurnu. Palunyalu kuka wakaralpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu Mama Kuurrnga pupakatirralpi marninypungu. Palunyalu-ya ngurra tjunu. Nyangka-ya palunyaku waarka palyalpayilu puru kapi kutjupalpi tjawarnu yartakanu. ");
INSERT INTO ntj_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nyangka-lu puurrpa Yapimanya Kiiralanguru pitjangu Yayitjikila wangkakitja. Nyangka palunyaku yamatji wati yini Yutjatjanya puru palunyaku warrmarlaku puurrpa yini Payikulngatarrartu lurrtjurringkula pitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nyangka Yayitjikilu-tjananya tjapirnu, “Nyaaku-yan ngayulakutu pitjangu? Ngaangkalpi-rniyan yanyan-yanyantu watjarnu nyuntuku ngurra-latju wantirra yankutjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Nyangka-ya watjarnu, “Wiya, nintilu-latju kulira Mama Kuurrtu-tjananyanta miranykanyira kanyiranyangka. Nyangka-munta-lankun wangkarra kulilku kalyparringkulalpi nyinama? Puru watjala-lanyatju wanti pika pungkunytjamaaltu wantikitjalu. Tjiinya ngayulu-tjananyarnanta pungkunytjamaaltu wantingu palunyalu mirrparnmaaltu witurnukutju. Palunyapirinypa-lanyatju watjala walykumunu kalypa nyinakitjalu. Tjiinya nintilurtu-rna kulira Mama Kuurrtu-tjananyanta walykumunura kanyiranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Nyangka Yayitjikilu watjarnu palunyaku waarka palyalpayilu-ya kuka mirrka purlkanya-tjanampa paara katitjaku. Nyangka-ya mularrpartu paaralpi katingu tjunu. Nyangka-ya pirnilurtu ngalangu parltjarringu. ");
INSERT INTO ntj_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Palunyalu-ya ngarringu tjirnturringkulalpi pakarnu watjarnu-yanku pukurlpa nyinakitjalu. Nyangka Yayitjikilu-tjananya ngurraku witurnu. Nyangka-ya pukurlarringkula yanu. ");
INSERT INTO ntj_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nyangka tjirntu palunyangkartu Yayitjikiku waarka palyalpayilu-ya pitjangu watjarnu, “Tjawarnu-latju kapi yutirnu.” ");
INSERT INTO ntj_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Nyangka Yayitjikilu kapi palunyanya tjapirnu Tjiipanya. Tjiinya Tjiipanya ngaapirinypa, Kalkuntjanya. Nyangka kuwarrinyatarrartu-ya yiwarla palunyangka ngamu ngaralanytjanya tirtu Piyatjiipanya tjapira. ");
INSERT INTO ntj_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","35","Nyangka Yayitjikiku katja Yiitjunya nyinarrayirnu kurli-ra 40 ngaralanyangka kungka kutjarra ngurra palunyangkatja yarltingu tjiinya Yatjaku wartangkatja. Nyangka-pula kungka kutjarralu kutjupa-kutjupa palyaranytjalu mingkayi-pulanku tjuni tjurlpilymaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nyangka Yayitjikinya nyinarrayirnu yirnarringkulalpi kurutjarra nyinarranytja. Palunyalu witurnu wati kutjulu palunyaku katja tirna Yiitjunya yarltirra katitjaku. Nyangka mularrpartu yarltirra katingu. Nyangka Yayitjikilu watjarnu, “Katja!” Nyangka watjarnu, “Yuwa Mama, kulira-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Nyangka watjarnu, “Yuwa, yirna purlkarringu-rna. Kuwarri-kuwarrirtu-rna wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kulila-rni. Kurlartanku mantjira kutipitja kuka purtingkatja wakara-tju kati. ");
INSERT INTO ntj_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Palunyalu paala walykumunuralpi-tju nintila. Ngayulukurlu-rna ngalkunma, palunyapirinypa paaralpi-tju kati nintila. Nyangka-rna ngalkulalpi walykumunu-rnanku watjalku wantiku wiyarrikitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Nyangka Ripakalu nyinarra kuliranytja Yayitjikilu watjaranyangka. Nyangka Yiitjunya kukaku kutipitjanyangka ");
INSERT INTO ntj_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ripakalu mapitjangu Tjayikapala tjakultjunu, “Kulirnu-rna nyuntuku mamalu Yiitjunya kukaku witunnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Tjiinya ngaapirinypa watjaralpi witurnu, ‘Kuka-tju yarra wakara kati. Palunyalu-tju paala walykumunuralpi kati nintila. Nyangka-rnankuyi ngalkulalpi Mama Kuurrta mirangka walykumunu watjala wanti wiyarrikitjalu.’” ");
INSERT INTO ntj_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nyangka Ripakalu tirtu watjaranytja, “Katja, kulila-rni. ");
INSERT INTO ntj_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mapitja nanikuurrpa warlangu kutjarra pungkula kati. Nyangka-rna kuka walykumunu paalku nyuntuku mamalu pukurltu ngalkutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nyangkan makatiku nintilku. Nyangka ngalkulalpinku walykumunu watjalku wantiku wiyarrikitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nyangka Tjayikapalu watjarnu, “Wiya Ngunytju, Yiitjunya purrmu purlkanya. Nyangka-rna ngayulu purrmu wiya. ");
INSERT INTO ntj_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tjinguru Mamalu-rni pampulku ngurrkarntanku mayuranyangka-rna. Nyangka-tju walykumunu watjalkitjamunulu mirritjunkutarrartu-rni.” ");
INSERT INTO ntj_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nyangka-lu watjarnu, “Wiya Katja, tjingurunta mirritjunku, nyangkan karalyarriku. Nyangka-rna ngayulutarrartu tjinguru mirrirriku. Yala, mapitja nanikuurrpa kutjarra pungkula kati.” ");
INSERT INTO ntj_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Nyangka mularrpartu mapitjangu pungkula katingu ngunytjuku nintirnu. Nyangka paarnu walykumunurnu Yayitjikilu pukurltu ngalkutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Palunyalu yiwarlangka tjarrparralpi Yiitjuku warntu walykumunu mantjira katingu Tjayikapaku nintirnu. Nyangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nyangka palunyaku ngunytjulu puru nanikuurrpa minyarra mantjiralpi Tjayikapaku marawana puru ngurntiwana tjunu. ");
INSERT INTO ntj_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Palunyalu kuka walykumunu puru nyuma paantjatjanulu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Nyangka Tjayikapalu mamangka tjarrparralpi watjarnu, “Mama, kuka-rnanku katinytja. Ngalku-muntan?” Nyangka-lu tjapirnu, “Katja wanytjartitjanyan?” ");
INSERT INTO ntj_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Nyangka Tjayikapalu watjarnu, “Yiitjunya-rna nyuntuku katja ngarnmanytjatjanya. Nyuntulun watjannyangka-rna kuka wakara katingu. Nyangka pakala ngala. Palunyalu-tju walykumunulta watjala wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Nyangka Yayitjikilu watjarnu, “Rawamunulpinyun yanu? Yaaltjilun waarrpungkula wakara katingu?” Nyangka Tjayikapalu watjarnu, “Wiya, Mama Kuurrtu, tjiinyan nyuntulu pupakatirra marninypungkupayilu-rni tjukarurrulu katingu.” ");
INSERT INTO ntj_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Nyangka Yayitjikilu watjarnu, “Pitja ngamurri ngara. Nyangka-rnanta pampula. Mularrpa-muntan Yiitjunya?” ");
INSERT INTO ntj_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Nyangka mularrpartu ngamurringu ngarangu. Nyangka pampuralpi watjarnu, “Wiya, wangkan Tjayikapanyapirinypa. Nyangka maranta Yiitjunyapirinypa.” ");
INSERT INTO ntj_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tjiinya purtu kulirnu mara purrmutjarra Yiitjunyapirinypa pampuralpi. Nyangka walykumunu-ra watjalkitjalu ");
INSERT INTO ntj_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","puru tjapirnu-lu, “Mularrpa-muntan Yiitjunya?” Nyangka watjarnu, “Yuwa, Yiitjunya-rna.” ");
INSERT INTO ntj_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Nyangka-lu watjarnu, “Yuwa, kuka-rni nintila. Nyangka-rnayi ngalkulalpi walykumunu-rnanku watjala wanti.” Nyangka mularrpartu kuka katingu nintinnyangka ngalangu. Puru wayinpa nintinnyangka tjikirnu. ");
INSERT INTO ntj_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Palunyalu watjarnu, “Katja, ngamuntirri-rni nguku kutjarranya nyunytjula.” ");
INSERT INTO ntj_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nyangka mularrpartu nyunytjunnyangka palunyaku mama Yayitjikilu-ra warntu parntirnu. Palunyalu-ra walykumunu watjarnu, “Yuwa Katja, warntunku parnti walykumunu, yitjarnu purlkanyapirinypa. Tjiinyakurlu Mama Kuurrtu kapi nintinnyangka yukiri purlkarriwa, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tjapira-rnanku Mama Kuurrtunku kapi kulyarrpa nintiltjaku, tjiinyanku mirrka yurninypa purlkarritjaku, puru mirrka kiripi purlkarrinyangkan wayinpa palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nyangka yarnangu pirnilu-yanku waarka palyanma nyuntuku, puru nyuntuku tjamupirtikutarrartu. Puru-ya nyuntunya pupakatirra marninypungama. Nyangkan yungarrapirtiku puurrarriku. Nyangkanta-ya nyuntuku tjinawana pupakatima. Nyangka kutjupatjarralu-tjingurunta-ya yinitjunku. Nyangka-tjananya Mama Kuurrtu ngaparrtjika yinitjunku. Nyangka kutjupatjarralu-tjingurunta-ya walykumunura kanyinma. Nyangka Mama Kuurrtu-tjananya ngaparrtjika walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Nyangka Yayitjikilu watjarayirnu wantinyangka Tjayikapanya pakara kutipitjangu. Nyangka palunyangkartu Yiitjunya kukatjarra waalkarrara pitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Palunyalu paarnu walykumunuralpi katingu mamaku nintilkitjalu. Palunyalu watjarnu, “Mama, kuka-rnanku katingu. Pakala ngala wiyaralpi-tju walykumunu watjala wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nyangka Yayitjikilu tjapirnu, “Ngananyan?” Nyangka watjarnu, “Yiitjunya-rna, nyuntuku katja ngarnmanytjatjanya.” ");
INSERT INTO ntj_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nyangka Yayitjikilu kuliralpi tiltirrmaranytja. Palunyalu tjapirnu, “Nyangka nganalunyka-rni ngaangka katingu kuka nintirnu? Nyangka-rnara kurranyulurtu walykumunu watjarnu wantingu. Nyangka wartalpitjanu palunyapirinypa ngarama.” ");
INSERT INTO ntj_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Nyangka Yiitjulu kuliralpi kurrurnpa wiyarringu yularranytja. Palunyalu tjapirnu, “Mama, ngayukutarrartu-tju walykumunu watjala wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nyangka Yayitjikilu watjarnu, “Wiya, nyuntuku marlanytju pitjangu-rni mayurnu. Nyangka-rnara nyuntunyakukantjalu walykumunu watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Nyangka Yiitjulu watjarnu, “Tjurrkurltu-pulan yini Tjayikapanya tjapirnu, tjiinya yini palunyanya Mayulpayinya. Tjiinya-rni kutjarrara mayurnu. Kutjulpirtu-rni witu-witurnu marlanyarringkula-rnara nyinarratjaku. Palunyalu kuwarrinta mayurnu palunyaku-ran walykumunu watjara wantitjaku. Wiya, ngayukutarrartu-tju walykumunu watjala wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Nyangka Yayitjikilu watjarnu, “Wiya Katja, wiyangkalpi-rna watjarnu Tjayikapanya nyuntuku puurrpa nyinarratjaku. Puru-rna watjarnu palunyaku yungarrapirtilu-ra waarka palyaratjaku. Puru-rna watjarnu mirrka purlkanya puru wayinpa purlkanya kanyiratjaku. Palunyalu-rna purtu kulira kutjupa-kutjupa nyuntuku watjalkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nyangka Yiitjulu watjarnu, “Wiya Mama, kutjupa-kutjupa-tjinguru ngarala ngayuku-tjun watjaltjaku. Ngayukutarrartu-tju walykumunu watjala wanti.” Nyangka yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nyangka palunyaku mamalu watjarnu, “Wiya, ngurra palyamunuwanan nyinama. Nyangka kapi kurlunypa punkanma. ");
INSERT INTO ntj_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nyangkan pika pungkula mirrka ngurlunyparranma. Purun waarka palyanma marlanyku. Palyarayilkun ngula tungun-tungunarriku. Nyangkanku puurrpa wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nyangka Yiitjunya yanyan-yanyanarringu Tjayikapaku, tjiinyamarntu mayurnu palunyaku mamalu-ra walykumunu watjaltjaku. Palunyalu yungarralunku ngaapirinypa kuliranytja, “Kuwarri-kuwarri-litju wangulyararriku. Nyangka-latju yularrayilku watatjarriku. Palunyangka-rna Tjayikapanya mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Nyangka palunyaku ngunytju Ripakalu tjakulpa kulirnu Yiitjulu tjumaranyangka. Palunyalu Tjayikapanya yarltirralpi watjarnu, “Katja, pitja kulila. Nyuntuku kurtalunta watjara mirrirntankukitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kulila ngaanya-rnanta watjalku wantinyangka. Pakara kutipitja ngurra yini Yarrantakutu, nyuntuku kamuru Layipantakutu. ");
INSERT INTO ntj_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Palunyalu nyinarra tjarlpa kulinma Yiitjunyanku kalyparritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tjiinya watatjarriku nyinarranyangka-rna wikarru witulku yarltirranta katitjaku. Tjiinya-tjingurunta Yiitjulu pungku mirrirntankunyangka-ya ngaparrtjika pungku mirrirntanku. Nyangka-rna katja kutjarratjirratja purrkutjarrarriku. Palunyangkatarrartu pakara yarra kamurukutu.” ");
INSERT INTO ntj_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nyangka Ripakalunku kurri Yayitjikila watjarnu, “Wiya, kurrurnpa-rna walykurringkula mingkayi kutjarraku, Yiitjuku kurri kutjarraku. Tjinguru Tjayikapalutarrartu kungka palunyapirinypa yarltinyangka-rna purtu kuliralpi kurltjirr-kurltjirrpa tirtu nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Nyangka Yayitjikilu katja Tjayikapanya yarltirralpi watjarnu, “Yuwa Katja, kungka ngurra ngaa Kayinanngamartatji yarltinytjamaaltu wanti. ");
INSERT INTO ntj_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Pakara kutipitja nyuntuku tjamu Patjiyulku ngurrakutu. Palunyalu-tjingurun kamuru Layipanku yurntalpa nyakulalpi yarltiku. ");
INSERT INTO ntj_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nyangka Mama Kuurrtu Yayirninytjulu Palyalpayilunta walykumunura kanyinma tjilkun pirnitjarrarritjaku. Nyangkan kutjutjamu nyinama yarnangu pirniku. ");
INSERT INTO ntj_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nyangka Mama Kuurrtunta walykumunura kanyinma, tjiinya nyuntuku tjamu Yayipuramanya walykumunura kanyiranytja, palunyapirinypa. Nyangka ngurra ngaa-lan maliki nyinarra, palunyanyan yungarralu kanyinma. Tjiinyamarntu Mama Kuurrtu Yayipuramanya kalkurnu nintilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Tjiinya Yayitjikilu Tjayikapanya witurnu ngurra tiwakutu, nyarra palunyaku kamuru Layipannga nyinarranytjalakutu. Tjiinya wati palunyanya Patjiyulku katja. ");
INSERT INTO ntj_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Nyangka Yiitjulu kulirnu palunyaku mama Yayitjikilu-ra marlanypa Tjayikapaku walykumunu watjarnu wantirralpi kamurukutu witunnyangka. Puru kulirnu palunyaku mamalu Tjayikapanya watjarnu kungka Kayinanngamartatji yarltinytjamaaltu wantirratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nyangka Yiitjulu puru kulirnu tjiinya Tjayikapalu wangarnarralu kulira ngurra palunyalakutu kutipitjanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Palunyalu pina taparlarraralpi kulirnu, “Munta yuwa, ngayuku mama-parta kurrarringkula kungka Kayinanngamartatjiku.” ");
INSERT INTO ntj_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Nyangka mapitjangu palunyaku mama tirna Yitjumayiltakutu. Palunyalu palunyaku yurntalpa yarltingu. ");
INSERT INTO ntj_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nyangka Tjayikapanya Piyatjiipanya wantirra kutipitjangu ngurra yini Yarranku. ");
INSERT INTO ntj_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Pitjalayirnu tjirntu tjarrpanyangka ngurra tjunu ngarrikitjalu. Palunyalu yapu mantjirnu kata tjunkulalpi kunkunarringu. ");
INSERT INTO ntj_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Palunyalu tjukurrpa nyangu tjukalpa mantanguru murrungaralanytja yilkarikutu. Nyangka Mama Kuurrku yayintjulpa-ya tjarungarala ma-tatiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nyangka Mama Kuurrnga yitingka ngaralanytja. Palunyalu-lu watjarnu, “Yuwa, ngayulu-rna Mama Kuurrnga nyuntuku Puurrpa, tjiinya nyuntuku tjamu Yayipuramalu puru nyuntuku mama Yayitjikilu pupakatirra marninypungkupayinya. Manta ngaangkan ngarrirra, palunyanya-rnanku nintilku puru nyuntuku tjamupirtikutarra. ");
INSERT INTO ntj_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nyangka-ya nyuntuku tjamupirti minga-mingarriku. Palunyalu-ya lipirntara nyinama yarla lipiwana. Nyangka-tjananyarna ngula nyuntuku tjamupirtinguru yarnangu yarla lipingkatja walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kulila. Ngayulu-rnanta tirtu nyinama. Tjiinya-rnanta katiku kamurukutu palunyalu marlakulu katiku ngurra ngaaku. Tjiinya-rnanta wantikitjamunulu tirtu miranykanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nyangka Tjayikapalu wankarringkulalpi watjarnu, “Yuwa-watjala? Mama Kuurrnga ngurra ngaangkatarrartu nyinarra. Nyangka-rna ngurrpartu pitjangu.” ");
INSERT INTO ntj_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Palunyalu ngurlurringkulalpi watjarnu, “Wiya, ngurra ngaanya-kulila miirl-miirlpa. Mama Kuurrku-ra ngurra. Tjinguru kayirrpa yilkarikutu ngarala tjarrparra mapitjalatjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nyangka ngarringu tjirnturringkulalpi pakarnu yapu nyarra kata tjunkula ngarrinytjalu mantjiralpi murrutjunu wantingu ngula nyakula ruukulilkitjalu. Palunyalu uyilpa tjutirnu miirl-miirlmankukitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Palunyalu ngurra palunyanya yini tjapirnu Pitjulnga, tjiinya wangka ngaapirinypa, Mama Kuurrku Ngurra. Tjiinya yiwarla ngamu ngaralanytjanya-ya kutjulpirtu yini Latjanya tjapiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nyangka Tjayikapalu Mama Kuurrnga ngaapirinypa kalkurnu wantingu, “Yuwa Mama Kuurr, nyuntulu-tjinguru-rnin lurrtju mapitjaku, puru-rnin mirrka, warntu nintilku. Puru-tjinguru-rnin miranykanyira katirrayilku ");
INSERT INTO ntj_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","marlakulu katiku ngayuku mamaku ngurrakutu. Nyangka-rnanta tirtu pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nyangka yarnangu pirninya-ya pitjaku yapu ngaangka nyuntunyanta-ya pupakatirra marninypungama. Nyangka-rnin kutjupa-kutjupa nintilku, palunyangka-rnanku 100-tjanulu tjarralku 10-pa nintilku.” ");
INSERT INTO ntj_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nyangka Tjayikapanya pakara kakarrara mapitjalayirnu-mapitjalayirnu ");
INSERT INTO ntj_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","nyangu kapi wiilpa yurirlta ngaralanyangka. Nyangka tjiipu nanikuurrpa pirni-ya ngarrirranytja kapurtu marnkurrpa tjarntutjarra-tjarntutjarra. Tjiinya kapi wiilpa palunyangkatja-ya tjutira nintilpayi tjiipu nanikuurrpa pirniku. Nyangka yapu purlkanya wiilta katu yangangarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tjiinya-ya kuwarripa wantipayi. Nyangka tjiipu miranykanyilpayi pirninya-ya lurrtjurriku, palunyangkakutju-ya yapu purlkanya watiyurnturalpi kapi tjutilku tjiipu nanikuurrpa pirniku yungku. Nyangka-ya tjikilku wiyarrinyangka yapu palunyanya-ya marlakulu watitjunkupayi. ");
INSERT INTO ntj_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Nyangka Tjayikapalu-tjananya tjapirnu, “Yuwa wati pirni, yiwarla nganalanguru-yan pitjangu?” Nyangka-ya watjarnu, “Yarrantanguru-latju.” ");
INSERT INTO ntj_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Nyangka-tjananya puru tjapirnu, “Wati yini Layipanku-munta-yan ninti, tjiinya wati yini Nayiyuku tjamu?” Nyangka-ya watjarnu, “Yuwa, ninti-latju.” ");
INSERT INTO ntj_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nyangka tjapirnu, “Walykumunu-munta nyinarra?” Nyangka-ya watjarnu, “Yuwa, walykumunu nyinarra. Watinyawa palunyaku yurntalpa Rayirrtjulnga nyarra pitjalayirni tjiipu pirnitjarra.” ");
INSERT INTO ntj_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Nyangka Tjayikapalu tjapirnu, “Nyaaku-yan tirtu nyinarra kapi tjutintjamaralpa? Tjiinya tjirntu katu ngarala mungarrtjirrinytjamaalpa. Nyangka-tjinguru-yan kurranyulu kapi nintiralpi tjiipu marlakulu makatima yukiri-ya ngalkulatjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nyangka-ya watjarnu, “Wiya, kuwarripa-latju nyinarra. Ngarna pirninyartu-ya lurrtjurrinyangka-latju yapu watiyurnturalpi kapi nintilku tjiipu nanikuurrpa pirniku.” ");
INSERT INTO ntj_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","10","Nyangka kuwarripa wangkarranyangkartu Rayirrtjulnga pitjangu palunyaku mamaku tjiiputjarra. Nyangka Tjayikapalu nyakula wiilkutu watipitjangu yapu watiyurnturalpi kapi tjutirnu nintirnu palunyaku tjiipu nanikuurrpa pirniku. ");
INSERT INTO ntj_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Palunyalu Rayirrtjulnga nguku kutjarranya nyunytjuralpi yulangu-ra. ");
INSERT INTO ntj_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Palunyalu watjarnu, “Ngayulu-rna nyuntuku mamaku yukari. Tjiinya-rna nyuntuku kurntili Ripakaku katja.” Nyangka Rayirrtjulnga kulira kukurraarnu mamanku watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nyangka palunyaku mama Layipantu kulira ngata-ngata ngalyakukurraarnu Tjayikapanya yampurnu nyunytjuralpi ngurrakutu katingu. Nyangka Tjayikapalu tjukurrpa pirni tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nyangka Layipantu watjarnu, “Yuwa, mularrpa-tjun ngayuku yukari yungarra, ngayuku nyarrumpaku katja.” Nyangka Tjayikapanya nyinarranytja palunyaku kamuruku ngurrangka. Nyangka kirnara kutjutjanulu ");
INSERT INTO ntj_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Layipantu Tjayikapanya watjarnu, “Kuliranytja-rna tjiinya-tjun yukari nyinarra. Nyangka-munta-tjun waarka kunpu-kunpu palyanma? Watjala-rni. Nyaapa-rnanku nintilku?” ");
INSERT INTO ntj_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tjiinya Layipantu yurntalpa kutjarra kanyiranytja. Nyangka ngarnmanytjatjanya yini Liyanya. Nyangka marlangkatjanya yini Rayirrtjulnga. ");
INSERT INTO ntj_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Nyangka Liyanya kuru walykumunu nyinarranytja. Nyangka Rayirrtjulnga kuru mantjil-mantjilpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Nyangka Tjayikapanya Rayirrtjulku-ra mukurringkulanytja. Palunyalu Layipanta watjarnu, “Waarka-rna palyarayilku kurli 7-tjanu wiyarriku nyuntuku yurntalpa marlangkatjanya yarltikitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Nyangka Layipantu watjarnu, “Yuwa, palyan yarltiku ngayuku yurntalpa. Pukurlarriku-rna. Tjiinyan tjukarurru nyinarra yurntaltu yarltitjaku. Yuwa, nyinarra-tju waarka palyanma.” ");
INSERT INTO ntj_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Nyangka mularrpartu Tjayikapalu pukurltu palyaranytja kungka Rayirrtjulnga yarltikitjalu. Waarka palyarayirnu palunyalu kurli 7-tjanulu kuliranytja rawamaalpartu kurli pirninya wiyarringkutja tjiinya purlkanya-ra mukurringkulanytjalu. ");
INSERT INTO ntj_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Palunyalu waputjungka watjarnu, “Wiya, yurntalpanku kuwarrinyartu ngalyawitula yarltitjaku-rna tjiinyamarntu-rna waarka palyarayirnu wiyarringu.” ");
INSERT INTO ntj_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nyangka Layipantu mirrka kuka purlkanya paarnu ngarnmanymanu wantingu. Palunyalu yarnangu pirninya yarltingu pitjala-ya ngalkula pukurlarritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Nyangka-ya pitjangu lurrtjurringu mirrka ngalkula wayinpa tjikiranytja. Nyangka mungangka Layipantu palunyaku yurntalpa ngarnmanytjatja Liyanya katingu Tjayikapalakutu. Nyangka Rayirrtjulngakukantjalu yarltingu ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Nyangka Layipantu kungka waarka palyalpayi yini Tjilpanya nintirnu Liyaku waarka tirtu palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nyangka Tjayikapalu ngarringu tjirnturringkulalpikutju nyangu, “Wiya, ngaanya Liyanya.” Palunyalu mapitjangu Layipanta watjarnu, “Nyaaku-rnin Liyanya nintirnu? Rayirrtjulku-rna waarka palyarayirnu raatjunu. Nyaatjanungka-rnin mayuralpi tjurtu tirnanya nintirnu? Tjinguru-rnin wantirralpi marlangkatjanya nintinma.” ");
INSERT INTO ntj_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nyangka Layipantu watjarnu, “Wiya, ngayuku-lampatju yara ngaapirinypa ngarala. Tjiinya tjurtu tirnanya ngarnmanytju kurrikutu witulku palunyalu marlangkatjanya marla witulku. ");
INSERT INTO ntj_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kulila. Kuwarripa-la Liyaku-pulampanku mirrka kuka purlkanya ngalku tjirntu 7-tjanu wiyarriku. Palunyangka-rnanku Rayirrtjulngalta nintilku. Nyangka-tjun puru waarka palyarayilku kurli 7-tjanu wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nyangka Tjayikapalu yuwarnmanu. Nyangka-ya ngalkulayirnu tjirntu 7-tjanu wiyarrinyangka Layipantu Rayirrtjulngalpi witurnu Tjayikapalu yarltitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Palunyalu Layipantu kungka waarka palyalpayi yini Pilanya nintirnu Rayirrtjulku waarka tirtu palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Nyangkalta Tjayikapalu Rayirrtjulnga yarltingu kanyiranytja. Palunyalu Rayirrtjulku tirtu mukulyanytju nyinarranytja. Palunyalu Liyaku watatjapirinypa nyinarranytja. Palunyalu Layipanku-ra waarka puru palyarayirnu kurli 7-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nyangka Mama Kuurrtu nyangu Tjayikapanya Liyaku watatjapirinypa nyinarranyangka palunyalu Rayirrtjulku purlkanya mukurringkulanyangka. Palunyalu Liyanya yirringkanu tjilkutjarrarritjaku. Nyangka Rayirrtjulnga tjilkumaalpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nyangka Liyalu katja kanyiralpi watjarnu, “Mama Kuurrtu-rni nyangu tjirturu-tjirturu-rna nyinarranyangka. Nyangka ngaanguru-tjinguru-tju kurri mukurriku.” Palunyalu katja yini Rupannga tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nyangka Liyalu nyinarrayirnu puru katja kutjupa kanyiralpi watjarnu, “Mama Kuurrtu-rni kulirnu ngarlturringu Tjayikapanya ngayuku mukulyanytju wiya nyinarranyangka. Palunyalu-rni katja ngaanya nintirnu.” Palunyalu katja palunyanya yini Tjimiyannga tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nyangka Liyalu nyinarrayirnu puru katja kutjupa kanyiralpi watjarnu, “Ngaanguru ngayuku kurrilu-rni yampura kanyinma. Tjiinya-rnara katja marnkurrpa kanyirnu.” Palunyalu katja palunyanya yini Liipayinya tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nyangka Liyalu nyinarrayirnu puru katja kutjupa kanyiralpi watjarnu, “Mama Kuurrnga-rna marninypungama.” Palunyalu katja palunyanya yini tjapirnu Tjuutanya. Nyangka Liyanya tjilku kanyintjamaalarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nyangka Rayirrtjultu nyangu palunyaku tjurtulukutju tjilku kanyiranyangka karurr-karurrarringu. Palunyalu Tjayikapala watjarnu, “Nyaaku-rnin tjilku ngayula yutintjamaaltu wantingu? Mukurringkula-rna tjilku kanyilkitja. Tjilkutjirratja-rna mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nyangka Tjayikapalu kuliralpi mirrparnarringu. Palunyalu-lu watjarnu, “Ngayulu-rna Mama Kuurrnga wiya. Palunyalunta tjilkumaalmara kanyira.” ");
INSERT INTO ntj_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Nyangka Rayirrtjultu watjarnu, “Ngarriku-muntan ngayuku waarka palyalpayi Pilala? Nyangka tjilku ngayuku-tju kanyilku. Nyangka-rnara ngayulu nyuyupungku kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nyangka mularrpartu witurnu Tjayikapalakutu. Nyangka-pula ngarringu. ");
INSERT INTO ntj_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Palunyatjanu nyinarrayirnu mukalarringu. Palunyalu Tjayikapaku katja kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nyangka Rayirrtjultu nyakulalpi watjarnu, “Mama Kuurrtu-rni nyakulalpi watjarnu tjukarurru-rna nyinarranyangka. Puru-rni kulirnu tjapiranyangka. Palunyalu-rni katja nintirnu.” Nyangka Rayirrtjultu yini Taannga tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nyangka Pilalu puru katja kutjupa kanyirnu Tjayikapaku. ");
INSERT INTO ntj_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nyangka Rayirrtjultu puru mantjirnu lurrtjurnu kutjarra kanyiranytja Pilaku katja. Palunyalu watjarnu, “Wiya, tjurtulu-litjunku tirtu wangkarranytja tjilkunguru. Palunyalu-rnalu wangka kanmarrmanu tjilku kutjarra mantjiralpi.” Palunyalu yini Natjalinya tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Nyangka Liyalu kulirnu, “Yuwa-parta-rna tjilku kanyintjamaalarringu?” Palunyalu witurnu palunyaku waarka palyalpayi Tjilpanya Tjayikapala ngarritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nyangka ngarringu palunyatjanu nyinarrayirnu Tjayikapaku katja kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nyangka Liyalu nyakulalpi watjarnu, “Wiya, walykumunu-tju ngarangu.” Palunyalu katja palunyanya yini tjapirnu Kaarrnga. ");
INSERT INTO ntj_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nyangka Tjilpalu Tjayikapaku katja kutjupanya puru kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nyangka Liyalu nyakulalpi watjarnu, “Wiya, pukurlarringu-rna. Nyangka-ya minyma pirninya ngayuku pukurlarriku.” Palunyalu katja palunyanya yini tjapirnu Yatjanya. ");
INSERT INTO ntj_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nyangka-ya mirrka wiirpa yurraranytja. Nyangka tjilku Rupannga yanu nyarra mirrka-ya yurraranytjalakutu. Palunyalu nyangu warta kutjupa-kutjupa pakarnu ngaralanyangka. Warta palunyanya yiiku mingkurlpirinypa. Nyangka-ya minyma pirnilu kuliranytja warta palunyanya ngalkunytjatjanu mukalarripayi. Nyangka Rupantu warrpura katingu palunyaku ngunytju Liyaku nintirnu. Nyangka Rayirrtjultu nyakulalpi watjarnu, “Nintila-rni nyuntuku katjalu katinytjanya.” ");
INSERT INTO ntj_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nyangka Liyalu watjarnu, “Wiya wanti. Wiyangkalpin ngayuku kurri kanyira. Palunyalun nyaaku watjara ngayuku katjaku warta-rnanku nintiltjaku?” Nyangka Rayirrtjultu watjarnu, “Tjinguru-rnin warta palanya nintilku. Nyangkan palya Tjayikapala ngarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nyangka Tjayikapanya mirrka yurrantjatjanu mungarrtji ngurraku pitjalayinnyangka Liyalu ngata-ngatalu mapitjalalpi watjarnu, “Yuwa, ngurra-lin ngarriku tjiinyamarntu-rna katjaku warta nintirnu Rayirrtjulku palunyangka.” Nyangka mularrpartu-pula ngarringu. ");
INSERT INTO ntj_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nyangka Mama Kuurrtu kulirnu Liyalu tjilkuku tjapiranyangka. Nyangka katja nampa 5-nya kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Palunyalu nyakulalpi watjarnu, “Yuwa, Mama Kuurrtu-rni katja ngaanya nintirnu tjiinya-rna kungka waarkarripayinya Tjayikapaku nintinnyangka.” Palunyalu yini tjapirnu Yitjakanya. ");
INSERT INTO ntj_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Palunyalu Liyalu puru kanyirnu katja nampa 6-nga. ");
INSERT INTO ntj_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Palunyalu nyakulalpi watjarnu, “Mama Kuurrtu-rni walykumunulu nintirnu. Nyangka-rni kurrilu marninypungku tjiinyamarntu-rnara katja 6-pa kanyinnyangka.” Palunyalu yini tjapirnu Tjipulannga. ");
INSERT INTO ntj_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Palunyalu marla yurntalpa kanyiralpi tjapirnu Tayinanya. ");
INSERT INTO ntj_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","23","Nyangka Mama Kuurrtu kulirnu Rayirrtjultu tirtu tjapiranyangka. Nyangkalta-ra katja nintirnu. Nyangka Rayirrtjultu nyakulalpi watjarnu, “Ngarltutjarra-rna tjilku wiya nyinarrayirnu, nyangka-rni Mama Kuurrtu katja nintinnyangka-rna pukurlarringu.” ");
INSERT INTO ntj_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Palunyalu yini tjapirnu Tjawutjanya. Palunyalu watjarnu, “Puru-rna tjapira Mama Kuurrtu-rni katja kutjupa nintiltjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","43","Nyangka Mama Kuurrtu Tjayikapanya walykumunura kanyiranytja. Nyangka yulytja pirnitjarrarringu. Nyangka-ra tjiipu, nanikuurrpa, kamurlpa puru tungkitarrartu pirnirringu. Nyangka waarka palyalpayinyatarrartu-tjananya pirni kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nyangka Tjayikapalu tjakulpa kulirnu palunyaku makurntalu-yanyu yanyan-yanyantu watjaranytja, “Wiya, Tjayikapalu-lampa mamangkatja tjiipu pirninya mantjirnu. Palunyalu kuwarrinya-lampa mamangkatja yulytja pirni kanyira.” ");
INSERT INTO ntj_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nyangka Tjayikapalunku waputju nyakulanytja kutjuparringkula yanyan-yanyanarringkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nyangka Mama Kuurrtu-lu watjarnu, “Yuwa, pakara marlaku kutipitja nyuntuku tjamuku ngurrakutu, nyuntuku yungarrapirtikutu. Tjiinya-rnanta ngayulu walykumunulu makatiku ngurra palunyalakutu.” ");
INSERT INTO ntj_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nyangka Tjayikapalu kuliralpi wati kutju witurnu. Nyangka mapitjangu Rayirrtjulnga-pulanya Liyanya watjarnu yankula Tjayikapala lurrtjurringkula kuliltjaku. Nyangka-pula mularrpartu yankulayirnu nyangu Tjayikapalu tjiipu nanikuurrpa pirninya yurirlta kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Nyangka Tjayikapalu-pulanya watjarnu, “Wiya, nyakulanytja-rna nyuntuku mama-tju kutjuparringkula yanyan-yanyanarringkulanyangka. Nyangka Mama Kuurrtu, ngayuku mamalu pupakatirra marninypungkupayilu-rni kanyira. ");
INSERT INTO ntj_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tjiinya-pulan nintilu kulira tjiinya-rna nyuntuku mamaku waarka purlkanya palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Nyangka-rni tirtu mayura watjalpayi. Puru-tju payi kutjupankupayi. Nyangka-rni Mama Kuurrtu yangakanyiranytja kurraltjakutarra. ");
INSERT INTO ntj_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tjiinya nyuntuku mamalu-rni watjalpayi, ‘Tjiipu nanikuurrtu-ya kurlunypa walka kutjupa-kutjupa tjunkunyangka palunyanya nyuntuku payi.’ Nyangka pirnilu-ya walka kutjupa-kutjupa tjunkupayi. Nyangka-rni puru watjalku, ‘Wiya, maru-maru tjunkunyangka palunyanya nyuntuku payi.’ Nyangkalta-ya pirnilu maru-maru tjunkupayi. ");
INSERT INTO ntj_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Palunyapirinypa Mama Kuurrtu-rni nyuntuku mamangkatja mantjira nintiranytja.” ");
INSERT INTO ntj_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Nyangka Tjayikapalu tirtu watjaranytja, “Yuwa, ngaangkalpi-rna tjukurrpa ngaapirinypa ngarringu nyangu. Tjiinya tjiipu nanikuurrpa-ya kurla-kurlaranytja. Palunyalu-ya marnti walka kutjupa-kutjupa puru marnti maru-maru pirninyakutju tati-tatiranytja kamina pirningka. ");
INSERT INTO ntj_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nyangka-rni Mama Kuurrku yayintjultu tjapirnu, ‘Tjayikapa!’ Nyangka-rna watjarnu, ‘Yuwa, kulira-rnanta.’ ");
INSERT INTO ntj_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nyangka-rni watjarnu, ‘Tjiipu nanikuurrpa pirninya nyawa. Tjiinya-ya marnti walka kutjupa-kutjupa puru marnti maru-maru pirninyakutju tati-tatira kamina pirningka. Tjiinya-rna ngayulu palyarnu palunyapirinypa ngaralatjaku. Tjiinyamarntu-rna nyangu nyuntuku waputju Layipantunta mayuranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yuwa, ngayulu-rna Mama Kuurrnga tjiinya-rnanta yartakarringu ngurra nyarra Pitjulta. Nyangkan ngurra palunyangka yapu murrutjunkulalpi uyilpa tjutirnu palunyalu-rnin kalkurnu wanalkitjalu. Yuwa, ngurra ngaanya wantirra pakara kutipitja ngurra nyarra nyuntulun yirti ngarringu, palunyalakutu.’” ");
INSERT INTO ntj_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nyangka Rayirrtjultu-pula Liyalu kuliralpi watjarnu, “Yuwa, palya-litju kulira. Nyaaku-lan nyinama? Tjiinya kutjupa-kutjupa wiyarringu ngula-litju mantjiltjaku Mamanya wiyarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tjiinya Mamalu-linyatju malikipirinypa nyakula wantipayi. Tjiinyan waarka palyarnu mantjilkitjalu-linyatjun. Nyangka tjimarri waarka palunyangkatja mamalu nintirayirnu wiyarnu. Tjinguru-limpatju nintinma kanyiltjaku-litju. ");
INSERT INTO ntj_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yuwa, tjiinya Mama Kuurrtu kutjupa-kutjupa pirni Mamala mantjiralpi nyuntuku nintirnu, palunyanya ngayuku-limpatju puru tjilku pirnikutarrartu ngarala. Yuwa, palya-lan yanku Mama Kuurrtunta watjaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Nyangka Tjayikapalu pakarnu warntu karrpirnu marlaku kutipitjakitjalu ngurra nyarra Kayinantakutu palunyaku mamakutu. Palunyalunku kurri, tjilku pirninyartu kamurlta tatitjura kutipitjangu. Palunyalu tjiipu nanikuurrpatarrartu tjirtira wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","20","Tjiinya Tjayikapalunku waputju tjamalankutjamaalpa mayura wantirra kutipitjangu. Tjiinyamarntu palunyaku waputju Layipannga yanu palunyaku tjiipu pirninya purrmu katapungkulanytja. Nyangka Rayirrtjultu palunyaku mamaku ngurrangka marlarntanu tjarrpangu mulyatarrirra katingu palunyaku yapu pirninya tjiinya pupakatirra marninypungkupayinya. ");
INSERT INTO ntj_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nyangka Tjayikapalunku yulytja puru yanamulpa pirninyartu waarrpungkula kutikatingu. Palunyalu-ya kapi yirrala purlkanya yini Purayitilawana tjarrparra-tjarrparra mapitjalayintja ngurra purlitjarra yini Kilatalakutu. ");
INSERT INTO ntj_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nyangka ngurra kutjarratjanulu Layipantu kulirnu Tjayikapalu-lu mayura wantirra kutipitjanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Palunyalu-tjananya wati pirninya yarltirra Tjayikapanya-tjananya ngurlura wanarnu. Wanarayirnu-ya tjirntu 7-tjanulu waalkarraralpi nyangu-tjananya ngurra purlitjarrangka-ya yini Kilatala nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Tjiinya Tjayikapalu-yanku ngurra tjunu purlingka nyinarranytja. Nyangka Layipantu wati pirnitjarralu ngurra palunyangkartu tjunu purli kutjupangka. Palunyalu mungangka Layipantu ngarringu tjukurrpa nyangu Mama Kuurrtu-lu waalkarrara pitjalalpi watjarnu, “Kulila. Payilku-kurlun Tjayikapanya. Wanti.” ");
INSERT INTO ntj_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nyangka ngarringu tjirnturringkulalpi Layipantu mapitjangu Tjayikapanya watjarnu, “Nyaatjanungka-rnin mayura wantirra kutipitjangu? Nyaatjanungka-tjun yurntalpa kutjarranya waarrpungkula katingu? Tjiinyakurlu warrmarlalu-ya tjulyara kati, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nyaatjanungka-rnin tjamalankutjamaalpa kampangkartu kutipitjangu? Tjinguru-rnin tjamalanama. Nyangka-tjinguru-lan mirrka purlkanya ngalkula turlku yinkarra wantinyangka-yan kutipitjama. ");
INSERT INTO ntj_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tjiinya-yan waarrpungkula yanu. Tjinguru-rna tjamu kaparli yurntalpatarrartu nyunytjura wantima. Wiya, katakurralu-tjananyan waarrpungkula katingu. ");
INSERT INTO ntj_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tjinguru-tjananyarnanta pika pungama. Ngarna Mama Kuurrtu, nyuntuku Mamalu pupakatirra marninypungkupayilu-rni mungangka watjarnu, ‘Kulila. Payilku-kurlun Tjayikapanya. Wanti.’ ");
INSERT INTO ntj_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Yuwa, nintilu-rna kulira tjiinyan watjil-watjilarringkula ngurraku yanu. Palunyalun nyaaku ngayuku yapu pirninya mulyatarrirra katingu?” ");
INSERT INTO ntj_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nyangka Tjayikapalu watjarnu, “Wiya, ngurlu-rna kampangkartu yanu. Ngurlurringkulanytja-rna tjiinyankun yurntalpa kutjarranya ngurlunyparrara kanyiltjakutarra. ");
INSERT INTO ntj_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Wiya, ngayulu-latjunku nyuntuku yapu pirninya mulyatarrirra katinytjamunurtu. Mukurringkulanytjalunku parrangurrila nyawa. Tjingurun ngurrilku kutjupalu kanyiranyangka watjalku-rna yarnangu palunyanya-ya pungkula mirrirntankutjaku. Yuwa, ngurrila nyawa yungarrapirtilunta-ya nyakulanyangka. Kutjupa-kutjupa nyuntukunku nyakulalpi mantjira kati.” Tjiinya Tjayikapalu kulintjamunurtu Rayirrtjultu mulyatarrirra katinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Nyangka Layipantu Tjayikapaku tiintingka tjarrparralpi purtu ngurrirnu. Palunyalu Liyaku tiintingka tjarrparralpi purtu nyangu. Palunyalu kungka waarka palyalpayi kutjarraku tiintingka purtu ngurrirnu. Palunyalu Rayirrtjulku tiintingka tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tjiinya Rayirrtjultu yapu palunyanya kamurltatjangka kumpitjuralpi palunyangkartu nyinarranytja. Nyangka Layipantu tiinti lipiwanalu kutjupa-kutjupa parrawirlkara-wanarnu purtu wiyanyangu. ");
INSERT INTO ntj_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nyangka Rayirrtjultu mamangka watjarnu, “Wiya Mama, mirrparnarriku-kurlu-tjun tirtu-rna nyinarranyangka. Tjiinya-rna kapa pikatjarra nyinarra.” Nyangka Layipantu parrangurrirayirnu purtu nyangu. ");
INSERT INTO ntj_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nyangka Tjayikapalu mirrparnarrirralpi Layipannga payirnu watjarnu, “Yaaltjilu-rnanta kurrarnu? Palyamunu nyaapirinypa-rna palyarnu nyangka-rnin ngurlura wanarnu? ");
INSERT INTO ntj_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Watjala-rni. Ngurrirnu-muntankun kutjupa-kutjupa? Yutila tjurra pirnilu-ya nyakutjaku. Nyakulalpi-linyantayi ngurrkarntarra, ‘Nganalu tjukarurrulu watjara? Tjingurun nyuntulu, tjinguru-rna ngayulu.’ ");
INSERT INTO ntj_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tjiinya-rna rawalu nyuntuku tjiipu nanikuurrpa miranykanyirayirnu kurli 20-tjanulu wantingu. Nyangka-ya tirtu kurlunytjarrarringkula pirnirringkulanytja. Nyangka-rnanku tjiipu marnti kutjupa wakara ngalkunytjamaalpartu wiyartu. ");
INSERT INTO ntj_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nyangka papa ngupanulunku tjiipu patjara mirrirntankunyangka-rnanku tjiipu kutjupanya nintilpayi. Nyangka kutjupalu karlarla mungangkatarrartu mulyatarrinyangka-rnin watjalpayi ngayulu-rnanku tjiipu kutjupanya nintiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Wiya, nyuntuku tjiipu-rna karlarla miranykanyiranyangka kurlilu-rni kampapayi. Puru-rna mungangka miranykanyiranyangka nyinngalu-rni warritjunkupayi. Nyangka-rna purtu kunkunarripayi. ");
INSERT INTO ntj_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yuwa, rawalu-rnanku nyinarra waarka palyarayirnu kurli 20-tjanulu wantingu. Nyuntuku yurntalpa kutjarranya yarltikitjalu-rna waarka palyarayirnu kurli 14-tjanu wiyarringu. Palunyalu-rna tjiipu nanikuurrpa pirninya mantjilkitjalu puru waarkarringkulayirnu kurli 6-tjanu wiyarringu. Nyangka-tjun payi tirtu mayura kutjupankupayi. ");
INSERT INTO ntj_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tjinguru-rnin maralpa witunma. Ngarna Mama Kuurrtu-rni miranykanyiranytja. Tjiinya ngayuku tjamu Yayipuramalu puru ngayuku mama Yayitjikilu pupakatirra marninypungkupayi, palunyalu-rni nyakupayi waarka purlkanya-rna palyaranyangka purunta nyangu nyuntulu-rnin kurralkitjalu kuliranyangka. Palunyalunta mungangka marrkurnu.” ");
INSERT INTO ntj_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Nyangka Layipantu Tjayikapanya watjarnu, “Kulila. Minyma ngaa kutjarranya-pula ngayuku yurntalpa. Nyangka tjilku ngaanya-ya ngayuku tjamu kaparli. Nyangka-ya tjiipu nanikuurrpatarrartu ngayuku. Pirninyartun ngaa ngarala parranyakula, palunyanya-ya ngayuku. Nyangka-tjananyarna purtu kulira yurntalpa tjamu kaparlitarrartu nyuntulanguru yangatjirrkara kanyilkitjalu. Tjiinyamarntu-ya nyuntuku. ");
INSERT INTO ntj_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nyangka-linku nyinakatirralpi ngaparrku kalkula wanti. Puru-linku yapu pirni tjurra tirtu-lin kuliltjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nyangka Tjayikapalu yapu walu kutju mantjiralpi murrutjunu tirtu kulilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Palunyalu watjarnu wati pirnilu-ya yapu pirninya yurrara katirra tjunkutjaku. Nyangka-ya mularrpartu katingu tjunu. Palunyalu-ya yapungka yitingka mirrka ngalangu. ");
INSERT INTO ntj_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Nyangka Layipantu yapu palunyatjinnganya wangka yungarralu yini tjapirnu Tjika-Tjaatutjanya. Nyangka Tjayikapalulpi wangka yungarralu yini tjapirnu Kaliitanya, tjiinya wangka ngaapirinypa, Yapu Pirni Tirtu Kuliratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nyangka Layipantu watjarnu, “Yapu ngaanya-ya tirtu ngarrima tjiinya-lin kutjarralurtu kuliratjaku.” Palunyangurulta-ya yini Kaliitanya tjapilpayi. ");
INSERT INTO ntj_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nyangka Layipantu watjarnu, “Mama Kuurrtu-linya nyakuma tjarrarringkula-li yankula nyinarranyangka.” Nyangka-ya ngurra palunyanya puru Mitjipanya tjapilpayi. Tjiinya Mitjipanya wangka ngaapirinypa, Nyakupayinya. ");
INSERT INTO ntj_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nyangka Layipantu watjarnu, “Nyangka-tjinguru-tjun yurntalpa pungkulanyangka, puru-tjingurun kurri kutjupanya yarltinyangka kulinma tjiinya Mama Kuurrtunta nyakula. Palyartu-rna ngurrpa tiwa nyinarra. Nyangka Mama Kuurrtunta nyakula. ");
INSERT INTO ntj_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Yapu pirninya ngaanya nyawa puru yapun murrutjunu wantinytjanya. Nyakulalpi kulinma tjiinya-rna yapu ngaa pirninya wayirntara mapitjakitjamunu nyuntunya-rnanta pika pungkukitja. Nyangka nyuntulutarrartun yapu ngaa pirninya wayirntara pitjakitjamunu ngayunya-rnin pika pungkukitja. ");
INSERT INTO ntj_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Yuwa, Mama Kuurrtu-linya nyangama tjiinya-lin tirtu kuliratjaku. Mama Kuurrnga, nyuntuku tjamu Yayipuramalu puru ngayuku mama Nayiyulu pupakatirra marninypungkupayilu-linya nyangama.” Nyangka Tjayikapalu Mama Kuurrta mirangka watjarnu wantingu yapu pirninya wayirntara Layipanku pika-pika yankutjamaaltu wantikitjalu. Tjiinya Mama Kuurrnga tjiinya palunyaku mama Yayitjikilu pupakatirra marninypungkupayi, palunyala mirangka watjarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Palunyalu Tjayikapalu puluka pungkulalpi purlingkartu paaralpi kutjupatjarra nintirnu Mama Kuurrku. Palunyalu-tjananya wati yungarrapirti yarltingu kuka kutjupatjarranya-ya pitjala lurrtjurringkula ngalkutjaku. Nyangka-ya ngalangu wiyarringkulalpi purlingkartu ngarringu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nyangka Layipantu mungayurnturalpi pitjangu yurntalpa, tjamu kaparlitarrartu-tjananya nyunytjurnu wantirra marlaku yanu ngurra yungarrakutu. ");
INSERT INTO ntj_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nyangka Tjayikapanya pakara kutipitjangu. Pitjalayirnu nyangu yayintjulpa pirninya-ya ngata-ngata pitjalayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nyangka Tjayikapalu-tjananya nyakulalpi watjarnu, “Wiya, ngaanya-kulila Mama Kuurrku warrmarla pirniku ngurra. Tjiinya-rniya pitjangu kurtangkatarra patjurinkukitja.” Nyangka Tjayikapalu ngurra palunyanya yini tjapirnu Maanayiminya. Tjiinya Maanayiminya wangka ngaapirinypa, Warrmarlaku Ngurra Kutjarranya. ");
INSERT INTO ntj_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","5","Nyangka Tjayikapalu wati marnkurrpa witurnu tjakultjarra-ya palunyaku kurta Yiitjulakutu yankutjaku ngurra yini Yiitamala nyinarranyangka. Nyangka-ya mularrpartu mapitjalayirnu Yiitjula lurrtjurringkulalpi watjarnu, “Nyuntuku marlanypa Tjayikapalu ngaapirinypa watjarnu, ‘Yuwa Kurta, ngayulu-rna Tjayikapalu nyuntuku marlanytju watjara, tjiinyan nyuntulu ngayuku puurrpirinypa nyinarra. Nyangka-rnanta tjakultjura, tjiinya-rna Kamuru Layipanta rawa nyinarranytja. Tjiinya-rna kuwarrikutju pakara pitjangu. Palunyalu-rna pirnipurlka kanyira, puluka, tungki, tjiipu nanikuurrpa pirni, puru waarka palyalpayi pirninyatarrartu. Yuwa Kurta, watjara-rnanta tjiinya-rnin nintilu kulira pukurlarrirra kawarrtu nyakulatjaku.’ Palunyapirinypa nyuntuku marlanytju watjarnu.” ");
INSERT INTO ntj_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nyangka-ya watjarnu wantirra marlaku yanu. Palunyalu-ya pitjangu Tjayikapala watjarnu, “Yuwa, yanu-latju nyuntuku kurta Yiitjula tjakultjunu. Nyangka kuliralpi pakarnu ngata-ngata pitjalayirni wati pirnitjarra, wati 400-tjarra.” ");
INSERT INTO ntj_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nyangka Tjayikapalu kuliralpi ngurlurringu. Palunyalu yarnangu pirninya-tjananya tjarraralpi kutjurntanu-kutjurntanu. Puru tjiipu, nanikuurrpa, puluka, kamurlpatarrartu palunyapirinymanu. ");
INSERT INTO ntj_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tjiinya kulirnu, “Tjinguru Yiitjulu pitjaku kutjupatjarranya-lanya pika pungkunyangka kutjupatjarra-tjinguru-ya kumpira kukurraalku wankakitja.” ");
INSERT INTO ntj_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Nyangka Tjayikapalu Mama Kuurrta tjapiranytja, “Yuwa Mama, ngayuku tjamu Yayipuramalu puru ngayuku mama Yayitjikilunta pupakatirra marninypungkupayi. Nyangka-munta-rnin kulilku? Tjiinya nyuntulu-rnin ngaangkalpi watjarnu, ‘Pakara marlaku kutipitja nyuntuku tjamuku ngurrakutu, nyuntuku yungarrapirtikutu. Nyangka-rnanta walykumunura kanyinma.’ ");
INSERT INTO ntj_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Wiya, palyartu-rna palyamunu nyinapayi. Nyangka-rnin tirtu ngarltunytjulu kanyilpayi. Tjiinya-rna kutjulpirtu kapi ngaa Tjuutantawana tjarrparra kutipitjangu. Maralpa-rna kutipitjangu wanatjarrakutju. Nyangka-rnin miranykanyira kanyirayirnu pirnipurlka nintirnu. Nyangka-rna marlaku pitjangu yarnangu pirnitjarra puru yanamulpa pirnitjarra. Tjiinyamarntu-rnin miranykanyira katirrayirnu marlakunu. ");
INSERT INTO ntj_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nyangka Mama, kanyila-rni Kurtalatarrartu. Tjiinya-rna ngurlurringkula Yiitjulu-lanyatju pitjala pirninyartu pungkutjakutarra, ngayuku kurri puru tjilkutarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nyuntulu-rnin watjarnu walykumunura kanyilkitjalu. Palunyalu-rnin ngaapirinypa watjarnu, ‘Ngayulu-rnanku tjamu kaparlipirti kanyilku minga-minga-ya nyinarratjaku, tjiinya-ya purtu parralku wantitjaku.’” ");
INSERT INTO ntj_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nyangka Tjayikapalu palunyapirinypa tjapiralpi ngurra palunyangka ngarringu tjirnturringu. Palunyalu yanamulpa pirni ngurrkarntanu palunyaku kurta Yiitjuku nintira wanalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Tjiinya ngaapirinypa ngurrkarntanu: nanikuurrpa kamina 200-pa puru marnti 20, puru tjiipu kamina 200-pa puru marnti 20, ");
INSERT INTO ntj_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","puru kamurlpa mimitjarra 30, kurlunypa pirnitjarra, puru puluka kamina 40 puru marnti 10-pa, puru tungki kamina 20 puru marnti 10-pa. ");
INSERT INTO ntj_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Palunyalu watjarnu waarka palyalpayilu-ya kutju-kutjulu katirrayiltjaku, tjiinya kutjupalu kurranyulu katirrayiltjaku nyangka kutjupalu ngururrkutjarra katirrayiltjaku nyangka kutjupalu marla mularrpa katirrayiltjaku. Nyangka-ya yanamulpa pirninya kapurtunu kanyiranytja yankukitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nyangka Tjayikapalu waarka palyalpayi kurranyungkatja watjarnu, “Yuwa, mapitjalayilkun, nyangka ngayuku kurta Yiitjulunta nyakulalpi tjapilku, ‘Ngananyanku puurrpa? Wanytjatjan mapitjalayirni? Nyangka yanamulpa ngaa pirninya nganaku-ra?’ ");
INSERT INTO ntj_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Nyangka-lun watjalku, ‘Wiya, nyuntukunku marlanytju Tjayikapalu watjarnu nyuntuku nintilkitjalu. Palunyanya marlawana pitjalayirni.’” ");
INSERT INTO ntj_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nyangka Tjayikapalu palunyapirinypartu watjarnu waarka palyalpayi nampa 2-nya, puru nampa 3-nya, puru kutjupatjarranyatarrartu tjiinya-ya yanamulpa pirninya marlawanalu makatirrayilkitja ngaralanyangka. Tjiinya-tjananya ngaapirinypa watjarnu, “Ngayuku kurta Yiitjunya-ya nyakulalpi watjala, ");
INSERT INTO ntj_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Yuwa, nyuntuku marlanypa Tjayikapanya marlawana pitjalayirni.’” Tjiinya Tjayikapalu ngaapirinypa kuliranytja, “Tjinguru-rnalu yanamulpa pirni nintiralpi kalypalku. Nyangka-rni kalypalu nyaku.” ");
INSERT INTO ntj_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nyangka-ya mularrpartu waarka palyalpayi pirnilu kurranyulu makatirrayirnu nintirnu. Nyangka mungarringkunyangka Tjayikapanya ngurrangka ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nyangka mungangka Tjayikapalu pakara palunyaku yungarrapirti katingu karru Tjapukanya kanturalpi kutjupa kantilypangka-tjananya nyinatjunu, tjiinya kurri kutjarra-kutjarranya, puru katja 11-patarrartu. Palunyalu marlaku yanu ");
INSERT INTO ntj_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","watjarnu waarka palyalpayi pirnilu-ya yulytja pirninya puru yanamulpa pirninya makatirra palunyangkartu tjunkutjaku. Nyangka-ya mularrpartu makatingu tjunu. ");
INSERT INTO ntj_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nyangka Tjayikapanya marlartarringu nyinarranytja. Nyangka wati kutju pitjangu-lu lurrtjurringu. Palunyalu-pulanku ngaparrku witurrpungkulalpi purtu tjarliranytja mantangka-pulanku warnikitjalu. Purtulirringu-purtulirringu-pula palunyangka manta yutirringu. ");
INSERT INTO ntj_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nyangka wati palunyalu purtulirrinytjatjanulu Tjayikapaku yangkarlpa pungu nyangka wilurru tarrka yarralyarrarnu. ");
INSERT INTO ntj_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nyangka wati palunyalu watjarnu, “Wanti-rni tjirnturrinyangka. Nyangka-rna kutipitja.” Nyangka Tjayikapalu watjarnu, “Wiya, wantikitjamunu-rnanta. Ngarna-tjun walykumunu watjannyangka-rnanta wantiku.” ");
INSERT INTO ntj_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nyangka wati palunyalu tjapirnu, “Yinin ngananya?” Nyangka watjarnu, “Tjayikapanya-rna.” ");
INSERT INTO ntj_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nyangka watjarnu, “Yuwa, nyuntuku yini Tjayikapanya, tjiinya Mayulpayinya wiyarriku. Nyangkanta-ya yini Yitjurayilnga tjapinma, tjiinya Putakurripayinya. Tjiinyan Mama Kuurrta puru yarnangu pirningkatarrartu putakurtu winarringu.” ");
INSERT INTO ntj_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nyangka Tjayikapalu tjapirnu, “Tjapilku-munta-rnanta? Yinin ngananya?” Nyangka watjarnu, “Nyaaku-rnin yini tjapira?” Nyangka palunyangurulta-ra Tjayikapaku walykumunu watjarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nyangka Tjayikapalu watjarnu, “Yuwa-parta-rna Mama Kuurrnga yiiku nyakulalpi ngaa mirrimaalpartu ngarala.” Palunyalu ngurra palunyanya yini Paniyulnga tjapirnu. Tjiinya Paniyulnga wangka ngaapirinypa, Mama Kuurrku Yiiku. ");
INSERT INTO ntj_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Nyangka tjirntu pakannyangka Tjayikapanya ngurra palunyanya wantirra kutipitjangu, tjiinya yangkarltjarra lurrparayintja. ");
INSERT INTO ntj_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nyangka kuwarritarrartu-ya Yitjurayilku tjamupirtilu paarlpa yangkarltatjanya ngalkunytjamaaltu wantipayi, tjiinyamarntu-lu Tjayikapanya yangkarlpa pungu palunyanguru. ");
INSERT INTO ntj_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Nyangka Tjayikapalu nyangu palunyaku kurta Yiitjunya waalkarrara pitjanyangka wati 400-tjarra. Palunyalu watjarnu tjilku pirninya-ya ngunytjuwana-ngunytjuwana mapitjalayiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Palunyalu watjarnu minyma waarka palyalpayinya-pula tjilkutjarra kurranyu mapitjatjaku. Palunyalu watjarnu Liyanya tjilkutjarra ngururrpa mapitjatjaku. Palunyalu watjarnu Rayirrtjulnga-pula Tjawutjanya marla mapitjatjaku. ");
INSERT INTO ntj_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nyangka Tjayikapanya kurranyurringkula mapitjangu palunyaku kurtangka ngamurringkulalpi 7-nguru mantangka pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Nyangka Yiitjulu nyakula ngalyakukurraarnu yampurnu-lu nyunytjurnu. Nyangka-pulanku yulangu. ");
INSERT INTO ntj_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nyangka Yiitjulu nyangu minyma pirni puru tjilku pirni ngaralanyangka tjapirnu, “Nganaku tjilku-ya ngaanya ngarala?” Nyangka Tjayikapalu watjarnu, “Wiya, ngayuku-tju tjilku, tjiinya Mama Kuurrtu-rni ngarltunytjulu nintiranytja.” ");
INSERT INTO ntj_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nyangka minyma waarka palyalpayi kutjarranya tjilkutjarra pitjangu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nyangka Liyanya tjilku pirnitjarra pitjangu pupakatingu. Nyangkalta marla mularrpa Rayirrtjulnga-pula katjararra pitjangu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Nyangka Yiitjulu puru tjapirnu, “Nyaakun yanamulpa pirninya ngalyawiyarnu?” Nyangka Tjayikapalu watjarnu, “Wiya, nyuntuku-rnanku mawiyarnu tjiinya-tjun kalyparritjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nyangka Yiitjulu watjarnu, “Wiya Marlany, wiyangkalpi-rnatju pirni kanyira. Palyanku ma-kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Nyangka Tjayikapalu watjarnu, “Wiya Kurta, tjinguru-tjun mularrpa kalyparringkulalpi mantjilku kanyilku nintiranyangka-rnanta. Pukurlarringu-rnanku yiiku nyakulalpi, tjiinya-rna Mama Kuurrku yiiku nyakunytjatjanupirinypa. Pukurlarringu-rna kalyparringkunyangka-tjun. ");
INSERT INTO ntj_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mantjila kanyila. Nintirnu-rnanku. Tjiinyamarntu-tju Mama Kuurrtu ngarltunytjulu pirnipurlka nintirnu.” Nyangka Yiitjulu purtu paanypungu wantingu tjiinyamarntu-lu Tjayikapalu tirtu witu-witunnyangka. ");
INSERT INTO ntj_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Nyangka Yiitjulu watjarnu, “Yuwa, pakara-la kutipitja. Nyangka-tjananyarnanta walara kati.” ");
INSERT INTO ntj_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nyangka Tjayikapalu watjarnu, “Wiya Kurta, nintilun kulira tjiinya tjilkulu-ya purtu kulilku waarrpungkula yankukitjalu. Tjiinya-ya wawanyarriku. Puru-rna tjiipu puluka kurlunytjarra kulira, tjiinya-tjananyarna waarrpungkula katirrayilku mirrirntankutjakutarra. Kulira-rna yatatjura katirrayilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nyuntulu-tjinguru-yan palya kurranyurrirra yanku. Nyangka-rna marlawana purinypa mapitjalayinma tjilkutjarra, puru tjiipu puluka kurlunypa pirnitjarra. Mapitjalayilku-latjunta lurrtjurringku nyuntuku ngurra Yiitamala.” ");
INSERT INTO ntj_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Nyangka Yiitjulu watjarnu, “Tjinguru-rna ngayuku waarka palyalpayi kutjupatjarra wantiku nyuntunyanta-ya yirringkankutjaku.” Nyangka Tjayikapalu watjarnu, “Wiya palya. Makati-tjananya. Pukurlarringu-rna kalyparrinyangka-tjun.” ");
INSERT INTO ntj_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Nyangka Yiitjunya pakara marlaku kutipitjangu ngurra nyarra Yiitamalakutu. ");
INSERT INTO ntj_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nyangka Tjayikapanya ngurra kutjupakutu yini Tjakatjaku mapitjangu. Palunyalu ngurra palunyangka yiwarla palyarnu nyinarranytja. Puru-ya wiltja pirni palyarnu yanamulpa pirniku. Palunyanguru Tjayikapalu ngurra palunyanya yini tjapirnu Tjakatjanya. Tjiinya Tjakatjanya wangka ngaapirinypa, Wiltjanya. ");
INSERT INTO ntj_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Nyangka tjiinya Tjayikapanya-ya palunyaku kamuruku ngurranguru pitjalayirnu wankartu parrapitjangu yiwarla Tjikimalakutu. Palunyalu ngurra tjunu yurirlta yiwarla palunyangka yitingka. ");
INSERT INTO ntj_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tjiinya Yayimuku tjamupirtilu-ya manta palunyanya kanyiranytja. Wati Yayimunya tjiinya wati Tjikimaku mama. Nyangka Tjayikapalu manta payipungu. Tjiinya tala 100-pa-tjanampa nintirnu mantjilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Palunyalu Tjayikapalu yapu pirni tjunkula parrawanarnu katurnu. Palunyalu kuka pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu miirl-miirlmanu Mama Kuurrku, tjiinya palunyalu tirtu marninypungkupayiku. ");
INSERT INTO ntj_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nyangka Mama Kuurrtu Tjayikapanya watjarnu, “Yuwa, pakara kutipitja Pitjulta nyinama. Palunyalu yapu pirni parratjunkula-wanala katula. Palunyalu kuka pungkulalpi tilila tjurra ngayuku-tju nintila. Tjiinya-rnanta ngurra palunyangka yartakarringu nyuntuku kurta Yiitjukun ngurlu kukurraannyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Nyangka Tjayikapalu-tjananya palunyaku yungarrapirti puru yarnangu kutjupatjarranya watjarnu, “Yuwa, tjinguru-yan yapu pupakatirra marninypungkupayinya kanyira, ngurra kutjupangkatja katinytjalu, puru yarnangu kutjupangkatja mantjintjalu. Wanti-ya. Palunyalu-ya mantjira kati ngayuku-tju nintila nyangka-rna tjawala tjurnutjurra. Puru-yanku parltjiralpi warntu walykumunu tjarrpatjurra. ");
INSERT INTO ntj_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nyangkalta-lan pakara ngurra nyarra Pitjulku kutipitjaku Mama Kuurrnga marninypungkukitja. Palunyangka-rna yapu pirni parratjunkula-wanalku katulku. Palunyalu-rna kuka pungkulalpi tililku tjunku Mama Kuurrku nintilku. Tjiinya palunyalu-rni yirringkanu purtu-rna kuliranyangka. Palunyalu-rni lurrtju tirtu yankupayi ngurra kutjupa-kutjupakutu-rna yankulanyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Nyangka-ya mularrpartu yapu nyarra pupakatirra marninypungkupayi pirninya tjiinya malikingka mantjintjalu puru pinangkatjatarrartu mantjira katingu Tjayikapaku nintirnu. Nyangka Tjayikapalu warta purlkanyangka yitingka tjawarnu tjurnutjunu yiwarla nyarra Tjikimala ngamu. ");
INSERT INTO ntj_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Nyangkalta-ya Tjayikapanya puru palunyaku yungarrapirtitarrartu Pitjulku pakara yanu. Nyangka-tjanampaya yarnangu nyarra yiwarla ngamungkatjanya ngurluny-ngurlunyarringu. Palunyalu-tjananyaya ngurlulu wantirranytja pika-pikantjamaaltu. Tjiinyamarntu Mama Kuurrtu-tjananya ngurluny-ngurlunymanu. ");
INSERT INTO ntj_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nyangka Tjayikapanya-ya pitjalayirnu parrapitjangu ngurra yini Latjaku tjiinya ngurra Kayinanta ngaralanyangka. Tjiinya ngurra palunyanya-ya kuwarrinya Pitjulnga watjara. ");
INSERT INTO ntj_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nyangka Tjayikapalu yapu pirni parratjunkula-wanarnu katurnu. Palunyalu kuka pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu ngurra palunyanya yini tjapirnu Yaal-Pitjulnga. Tjiinya Yaal-Pitjulnga wangka ngaapirinypa, Mama Kuurrnga Pitjulta Nyinapayinya. Tjiinyamarntu Mama Kuurrnga ngurra palunyangka Tjayikapala yartakarringu palunyaku kurtaku ngurlu kukurraannyangka. ");
INSERT INTO ntj_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nyangka ngurra palunyangka minyma pampa yini Tipuranya mirrirringu. Minyma tjiinya Tjayikapaku ngunytju Ripakanya purlkarnu, palunyanya mirrirringu. Nyangka-ya mirri katingu tjawarnu tjurnutjunu warta purlkanyangka. Palunyalu-ya warta palunyanya tjapirnu yini Warta-yulanya, tjiinyamarntu-ya warta palunyangka yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yuwa, Tjayikapanya palunyaku kamuruku ngurranguru marlaku pitjangu. Nyangka Mama Kuurrnga-lu puru yartakarringkulalpi walykumunu-ra watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Tjiinya-lu ngaapirinypa watjarnu, “Nyuntuku yini Tjayikapanya wiyarriku. Nyangkanta-ya Yitjurayilnga tjapinma.” Tjiinya Mama Kuurrtu-lu yini Yitjurayilnga tjunu. ");
INSERT INTO ntj_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Palunyalu watjarnu, “Yuwa, ngayulu-rna Mama Kuurrnga, Yayirninytjulu Palyalpayinya. Nyangka nyuntulun tjilku pirni kanyilku. Nyangka-ya nyuntuku tjamu kaparlipirti pirnirringku ngurra kutjupa-kutjupangka nyinarra-wanarayinma. Nyangka-ya kutjupatjarra puurrpa purlkanya nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nyangka ngurra nyarra ngayulu-rna Yayipuramanya puru Yayitjikinya kalkurnu nintilkitjalu, palunyanya-rnanku nyuntuku nintilku puru nyuntuku tjamupirtikutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nyangka Mama Kuurrnga pakara yanu. ");
INSERT INTO ntj_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nyangka Tjayikapalu yapu purlkanya mantjiralpi murrutjunu tirtu ruukulilkitjalu tjiinya Mama Kuurrnga-lu ngurra palunyangka wangkarranytja. Palunyalu wayinpa uyilpatarrartu tjutiralpi miirl-miirlmanu. ");
INSERT INTO ntj_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Palunyalu yini Pitjulnga tjapirnu. Tjiinyamarntu-lu Mama Kuurrnga palunyangkartu wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nyangka Tjayikapalu-ya Pitjulnga wantirra kutipitjangu ngurra yini Puratjaku. Nyangka Rayirrtjulnga tjaka-tjaka nyinarranytja. Nyangka ngururrpartu-ra ngamurringu tjilku kanyiltjaku. Nyangka mularrpartu pika purlkanya miraranytja. ");
INSERT INTO ntj_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nyangka minyma yirringkankupayilu-lu watjarnu, “Wiya, ngurlumaalpa nyinama. Tjiinyan tjilku minarli kanyirnu.” ");
INSERT INTO ntj_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nyangka Rayirrtjultu mirrirrikitjalu katja tjapirnu yini Pinaninya. Parturtu Tjayikapalu yini kutjupanya tjapirnu Pintjimannga. ");
INSERT INTO ntj_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nyangka Rayirrtjulnga mirrirringkunyangka-ya tjawarnu tjurnutjunu yiwarrangka yitingka, yiwarra nyarra Puratjaku ma-ngarrirra, palunyangka. Nyangka kuwarrinya-ya Puratjanya yini kutjupa Pitjiliyamanya tjapira. ");
INSERT INTO ntj_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nyangka Tjayikapalu yapu murrutjunu wantingu tirtu-ya kuliratjaku. Nyangka yapu palunyanya kuwarrinya tirtu ngarala. ");
INSERT INTO ntj_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nyangka Tjayikapanya tjiinya yini kutjupa Yitjurayilnga pakara mapitjalayirnu ngurra yini Mikatal-Yitanya wayirntaralpi ngurra ma-tjunu. ");
INSERT INTO ntj_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Nyangka ngurra palunyangka-ya nyinarranyangka Tjayikapaku katja tirna Rupannga yanu panykarnu ngarringu palunyaku mamaku kurri kutjupangka Pilala. Nyangka palunyaku mamalu kuliralpi tjuni walykurringu. ");
INSERT INTO ntj_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Tjiinya Tjayikapalu katja 12-pa kanyiranytja. Tjiinya minyma Liyalu 6-pa kanyirnu yini ngaanya-tjananya: Rupannga tjiinya Tjayikapaku katja tirnanya, puru Tjimiyannga, Liipayinya, Tjuutanya, Yitjakanya, Tjipulanngalta. ");
INSERT INTO ntj_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Nyangka Rayirrtjultu katja kutjarra kanyirnu Tjawutjanya-pulanya Pintjimannga. ");
INSERT INTO ntj_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Nyangka Rayirrtjulku waarka palyalpayi Pilalu katja kutjarra kanyirnu Taannga-pulanya Natjalinya. ");
INSERT INTO ntj_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Nyangka Liyaku waarka palyalpayi Tjilpalu katja kutjarra kanyirnu Kaarrnga-pulanya Yatjanya. Palunyanya-ya Tjayikapaku katja pirni palunyaku kamuruku ngurrangka yirti ngarrinytja. ");
INSERT INTO ntj_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nyangka Tjayikapanya yanu palunyaku mama Yayitjikilakutu. Tjiinya ngurra yini Mamurayila nyinarranytja ngurra yini Yapuranta ngamu. Tjiinya Yayipuramanya kutjulpirtu maliki nyinarranytja, palunyangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Palunyatjanu nyinarrayirnu kurli-ra 180 ngaralanyangka mirrirringu, tjiinya yirna purlkanya. Nyangka palunyaku katja Yiitjulu-pula Tjayikapalu mirri makatingu pulpangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","43","Nyangka Yiitjulu kurri marnkurrpa kanyiranytja. Nyangka-ya katja 5-pa kanyirnu ngurra nyarra Kayinanta nyinarranytjalu. Nyangka-ya pakara yurlparirra kutipitjangu ngurra yaputjarra yini Tjiyala nyinarranytja. Tjiinya Yiitjulu-pula Tjayikapalu tjiipu, nanikuurrpa, puru puluka pirni kanyiranytja. Palunyalu-pula purtu kulirnu ngamu-ngamu nyinakitjalu yukirimarntu kurlunypa ngaralanyangka. Palunyanguru-pula tjarrarringu. Nyangka Yiitjunya yurlparirra kutipitjangu. Nyangka-ya Yiitjuku tjamu pirnirringkulalpi tirtu nyinarranytja ngurra yini Tjiyala, tjiinya-ya kuwarrinya yini Yiitamanya tjapira, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2","Nyangka Tjayikapanya tirtu nyinarranytja ngurra yini Kayinanta, tjiinya palunyaku mama nyinarrayirnu wiyarringu, palunyangka. Nyangka tjukurrpa ngaanya palunyaku yungarrapirtitjarra. Nyangka Tjawutjanya murtilyarrinyangka kurli-ra 17-pa ngaralanytja. Tjiinya palunyaku kurtapirtingka lurrtjurringkula miranykanyilpayi tjiipu puru nanikuurrpa pirninya. Tjiinya ngunytju kutjupaku katjangka, Pilaku puru Tjilpaku katjangka, kurta palunyangka-tjananya tirtu lurrtjurripayi. Palunyalu pitjala palunyaku mamangka tjukurrpa palyamunu pirni watjalpayi palunyaku kurta pirnilu-ya kutjupa-kutjupa palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Nyangka palunyaku mama Tjayikapanya Tjawutjaku-ra kurrurntatjaku mukurringkulanytja. Tjiinyamarntu-lu yirnarringkulalpi yutirnu. Palunyalu-ra Tjawutjaku kawutu walykumunu, yamirri wirrmiratjarra nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nyangka-ya palunyaku kurtapirtilu nyangu tjiinya palunyaku mamalu palunyanyakutju kurrurntatja kanyiranyangka. Palunyalanguru-raya Tjawutjaku yanyan-yanyanarringkulalpi tirtu mirrparn-mirrparnpa wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nyangka Tjawutjalu tjukurrpa ngarringu nyakulalpi palunyaku kurtapirtingka-tjananya tjakultjunu. Nyangka-raya kuliralpi ma-yanyan-yanyanarringu. ");
INSERT INTO ntj_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Tjiinya ngaapirinypa-tjananya tjakultjunu, “Kulilku-munta-rniyan? Tjukurrpa ngaapirinypa-rna ngarringu nyangu. ");
INSERT INTO ntj_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tjiinya-lanyun mirrka wiirpa pirninya katapungkula karrpira tjunkulanytja. Nyangkanyu ngayuku wiirpa nyarra karrpirnu-rna tjunu wantingu, palunyanyanyu pakaralpi tjukarurru ngaralanytja. Nyangka-tjanampankunyu nyuntuku wiirpa pirninya ngayuku parrangururrtjunkulalpi pupakatingu.” ");
INSERT INTO ntj_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nyangka-ya palunyaku kurtapirtilu panypuratjarralu watjarnu, “Yuwa-parta? Nyuntulu-parta-lampatjun puurrarrikitja?” Nyangka-raya yanyan-yanyanpa purlkanya nyinarranytja. Tjiinya tjumatjunkulalpi-tjananya tjakultjunu palunyanguru-raya puru ma-yanyan-yanyanarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nyinarrayirnu-ya nyangka munga kutjupangka Tjawutjalu ngarringu puru tjukurrtjunu. Palunyalu-tjananya palunyaku kurtapirtingka puru tjakultjunu, “Kulilku-rniyan? Ngayulu-rna puru ngarringu tjukurrpa kutjupanya tjumatjunu, tjiinya tjirntu, kirnara puru pirntirri 11-pa-yanyu pitjangu ngayula pupakatingu.” ");
INSERT INTO ntj_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Palunyalu yanu palunyaku mamangka tjukurrpa palunyanya tjakultjunu. Nyangka kulirnu mirrparnarrirralpi watjarnu, “Nyaapan watjara? Yuwa-parta? Nyuntuku ngunytju, ngayulu puru nyuntuku kurtatarrartu-latju pitjaku nyuntula pupakatiku?” ");
INSERT INTO ntj_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nyangka Tjawutjaku kurta pirninyartu-raya tirtu karurr-karurrarringkulanytja. Tjiinyamarntu-tjananya tirtu watjaranytja puurrarringkula kanyilkitjalu. Nyangka palunyaku mamalu tjuma palunyanya rawalu kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","14","Nyangka-ya ngurra yini Yapuranta nyinarranytja, purlingka ngururrkutjarra. Nyangka-ya Tjawutjaku kurtapirtilu tjiipu pirninya katingu ngurra yini Tjikimalakutu yukiri-ya ngalkutjaku. Nyangka Tjayikapalu Tjawutjanya witurnu, “Yarra-tjananya nyawa nyuntuku kurtapirti-yayi palya nyinama. Puru tjiipu pirninyatarrartu ma-nyawa. Palunyalu-rni marlakulu pitja watjala.” Nyangka mularrpartu wangarnarralu kulira yanu. Palunyalu Tjikimala ngamurringkulalpi ");
INSERT INTO ntj_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","purtu parranyangu. Nyangka-lu wati kutjulu pitjangu nyakulalpi tjapirnu, “Nganakun parrangurrira?” ");
INSERT INTO ntj_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nyangka Tjawutjalu watjarnu, “Wiya, ngayuku kurta pirniku-rna ngurrirayirni. Tjiinya-ya tjiipu miranykanyira. Nyawayin wati palunyatjinnga?” ");
INSERT INTO ntj_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nyangka wati palunyalu kuliralpi watjarnu, “Yuwa, kutjulpirtu-ya yanu. Kulirnu-rna ngaapirinypa-ya watjaranyangka, ‘Yarra-la ngurra nyarra Tutjantakutu.’” Nyangka Tjawutjanya Tutjantakutu mapakarnu palunyaku kurtapirti ngurlura wanarnu. ");
INSERT INTO ntj_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nyangka-ya kurta pirnilu nyangu Tjawutjanya tiwa pitjalayinnyangka. Palunyalu-luya tjumara watjaranytja mirri pungkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tjiinya-ya ngaapirinypa ngaparrku watjaranytja, “Alu! Tjumatjunkupayinya pitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kulila-ya. Puwa-la mirrirntaralpi warni tjarrpatjurra pirti purlkanyangka, nyarra kapi purlkanya ngarringu wiyarringu palunyangka. Palunyalu-lan Mamala mayulku watjalku, ‘Wiya, ngupanulu-ya ngurlura wanarnu patjarnu ngalangu wiyarnu.’ Palunyangkalta-ra tjukurrpa yartakarrikitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Nyangka kurta tirna Rupantu kuliralpi watjarnu, “Wiya, pungku-kurlu-yan mirrirntanku. Pirtingkakutju-ya warni tjarrpatjurra.” Tjiinya-ra Tjawutjaku ngarltuwangkarralpi kuliranytja ngula mantjira marlakulu palunyaku mamakutu witulkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nyangka Tjawutjanya kurta pirnikutu pitjangu. Palunyangka-ya palunyaku kawutu walykumununya tjulyaralpi lingkirrtu yarrarnu parnangka warningu. ");
INSERT INTO ntj_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Palunyalu-ya Tjawutjanya mantjira makatingu pirti palunyangka warningu tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Palunyalu-ya mirrka nyinarra ngalkulanytjalu nyangu Yitjumayilku tjamupirti-ya waalkarrara pitjanyangka. Tjiinya-ya ngurra yini Kilatalanguru pitjalayintja. Tjiinya-ya kamurltjarralu kutjupa-kutjupa puru parnti walykumununyatarrartu katirrayintja ngurra nyarra Yiitjipula nintilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Nyangka Tjuutalu watjarnu, “Wiya, nyaaku-lankun marlanypa yungarra pungku mirrirntaralpi mayunma? Wanti-la. ");
INSERT INTO ntj_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nyawa-ya Yitjumayilku tjamupirti-ya waalkarrara pitjangu. Palunyaku-la nintila tjimarrikitjalu. Nyaaku-lan pungku mirrirntanku? Tjiinyamarntu-lampa marlanypa yungarra.” Nyangka-ya kurta pirnilurtu kuliralpi palyarnmanu. ");
INSERT INTO ntj_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nyangka-ya wati kamurltjarra pirninya pitjangu ngamurringkunyangka Tjawutjaku kurtalu-ya pirtikutu mapitjangu. Palunyalu-ya Tjawutjanya yilarnu pakaltjingaralpi wati kamurltjarra pirniku nintirnu. Nyangka-ya ngaparrtjika tjimarri purlkanya nintirnu. Palunyalu-ya Tjawutjanya Yiitjipulakutu katingu. ");
INSERT INTO ntj_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nyangka kurta tirna Rupannga kutjupa-kutjupa parrapalyaranytjatjanu marlaku pirtikutu pitjangu. Palunyalu Tjawutjaku purtu nyakulalpi kata paarnarrarnu. Palunyalu tjirturu-tjirtururringkulalpi yungarralunku tjaarnpa wartunpungu marlanytjirratjalu. Tjiinya yarlaku kuliranytja Tjawutjanya-ya mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Palunyalu yanu-tjananya palunyaku marlanypa pirningka watjarnu, “Tjawutjanya wiyarringu. Nyangka-rna nyaapa watjalku Mamala?” ");
INSERT INTO ntj_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nyangka-ya nanikuurrpa wakarnu mirrirntaralpi Tjawutjaku kawutu yirramingka winytjurnu. Nyangka yirramipururringu. ");
INSERT INTO ntj_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nyangkalta-ya kawutu palunyanya katingu mamangka-yanku nintitjuralpi watjarnu, “Ngaanya-latju ngurrirnu. Ngurrkarntara-muntan kawutu ngaanya? Nyuntuku katjaku-munta?” ");
INSERT INTO ntj_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nyangka mularrpartu nyangu ngurrkarntaralpi watjarnu, “Yuwa, mularrpa ngayuku katjaku-ra kawutu ngaanya. Wiya-kulila-lu ngupanulu patjarnu ngalangu wiyarnu.” ");
INSERT INTO ntj_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nyangka Tjayikapanya katjatjirratja tjirturu-tjirtururringu. Palunyalu yungarralunku warntu wartunpungu palunyalu warntu palyamunu tjarrpatjunu kanyiranytja. Palunyalu rawa nyinarra yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nyangka-ya palunyaku katja yurntalpirtilu purtu yipilymara kanyiranytja. Nyangka-tjananya kulira wantirranytja. Palunyalu-tjananya watjarnu, “Ngaanya-rna yungarra yularrayilku-yularrayilku ma-mirrirriku.” Nyangkalta katjatjirratja rawa yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nyangka-ya wati kamurltjarra pirninya pitjalayirnu parrapitjangu Yiitjipuku. Palunyalu-ya Tjawutjanya parrakatingu ngaratjunu pirnilu-ya nyakutjaku. Nyangka puurrpa yini Patipalu nyakulalpi watjarnu, “Tjimarri purlkanya-tjanamparnanku nintilku. Nintila-rni wati palanya. Nyangka-tju nyinarra waarka palyanma.” Nyangka-ya mularrpartu Tjawutjanya nintirnu tjimarri purlkanyakitjalu. Nyangka nyinarra waarka palyaranytja puurrpa Patipaku. Tjiinya wati palunyanya puurrpa nyinarranytja wati warrmarla pirniku, nyarra puurrpa Piirunya-ya miranykanyilpayi, palunyaku-tjanampa. ");
INSERT INTO ntj_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","30","Nyangka Tjayikapaku katja yini Tjuutalu katja marnkurrpa yutirnu. Palunyangka Tjuutaku kurri mirrirringu. Nyangka minyma kutjupangkatja katja kutjupa kutjarra puru yutirnu yini Pirinynga-pulanya Tjirranya. Tjiinya palunyaku-pulampa ngunytju yini Tayimanya nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nyangka tjiinya wati kamurltjarra pirnilu-ya Tjawutjanya katirrayirnu parrakatingu ngurra nyarra Yiitjipulakutu. Palunyatjanu-luya puurrpa Patipaku tjimarrikitjalu nintirnu. Tjiinya wati palunyanya puurrpa nyinarranytja wati warrmarla pirniku, nyarra puurrpa Piirunya-ya miranykanyilpayi, palunyaku-tjanampa. ");
INSERT INTO ntj_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","3","Nyangka Tjawutjanya nyinarranytja puurrpa Patipaku ngurrangka. Tjiinyamarntu wati palunyanya-ra puurrarringu nyinarranytja. Nyangka nyinarra waarka purlkanya palyaranytja. Waarka walykumunu palyaranytja tjiinyamarntu-lu Mama Kuurrtu yirringkaranyangka. Nyangka puurrpa Patipalu nyakulalpi watjarnu, “Yuwa, Tjawutjalu waarka walykumunu palyara. Mularrpa-lu Mama Kuurrtu yirringkara.” ");
INSERT INTO ntj_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nyangka Patipalu nyangu pukurlarringkulalpi watjarnu wantingu Tjawutjalu miranykanyiratjaku-ra palunyaku ngurra, puru waarka palyalpayi pirninya puru yulytja pirninyatarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nyangka Tjawutjalanguru Mama Kuurrtu-tjananya puurrpa Patipaku yungarrapirti walykumunura kanyiranytja. Palunyatjanulu-tjanampa mirrka wiirpatarrartu purlkaranytja. ");
INSERT INTO ntj_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nyangka Patipalu kuliranytja, “Ngaanguru-rna ngurrangkatja pirniku kulintjamaalpa watatja nyinama. Tjiinyamarntu Tjawutjalu-tju wiyangkalpi walykumunura kanyira.” Palunyalu mirrkakutju kuliranytja ngurrangka tjarrparra ngalkukitjalu. Nyangka Tjawutjanya yiiku walykumunu puru yarnangu walykumunu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nyangka Patipaku kurrilu nyakula mukurringkulanytja. Palunyalu-lu tjapirnu ngarrikitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nyangka Tjawutjalu paanypungkulalpi watjarnu, “Wiya, wanti. Tjiinya ngayuku puurrpa pukurlpa-tju nyinarra, ngurrangkatja kutjupa-kutjupa pirninya kulintjamaalpa. Tjiinyamarntu-rni tjunu puurrarringkula-rna pirninyartu kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nyangka-rna puurrarringu yarnangu pirnikurtu. Palunyalu-rna ngurrangkatja pirninya miranykanyira kanyira. Tjiinya nyuntunyakutju-rna kanyiltjaku nintintjamunurtu. Nyuntulumarntu-ran palunyaku kurri nyinarra. Nyangka-rna ngayulu palyamunurringkukitjamunu Mama Kuurrta mirangka.” ");
INSERT INTO ntj_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Nyangka tjirntu kutjupa tjirntu minyma palunyalu pitjala tjapiranytja Tjawutjala ngarrikitjalu. Nyangka tirtu paanypungkula watjaranytja. Palunyalu minyma palunyalawana ngamutarrartu parrapitjalanytjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nyinangu-ya, nyangka Tjawutjanya yanu tjarrpangu Patipaku warlingka waarka palyalkitja. Tjiinya-ya waarkarripayi kutjupa pirninya kaninytjarra ngaralanytjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Nyangka-ra Patipaku kurrilu kawutu tjulyarnu. Palunyalu watjarnu, “Yuwa, ngarri-li!” Nyangka Tjawutjanya tjirrka-tjirrkara pakara yilkaku kukurraarnu. Nyangka minyma palunyalu kawutukutju marangka kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","Palunyalu mirrangu waarka palyalpayi pirninya-tjananya yarltirralpi mayurnu watjarnu, “Nyawa-ya kawutu ngaanya. Tjiinya wati Yiipuru nyarra ngayuku kurrilu ngurrakutu katingu, palunyanya-lampa tjalkirr-tjalkirrpa nyinarra. Nguwanpa-rni ngayula ngarringu. Nyangka-rna lingkirrpa mirrangu. ");
INSERT INTO ntj_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Palunyangka-rni kuliralpi pakara yilkaku kukurraarnu. Palunyalunku parrparta-parrpartalu kawutu ngaanya wantirra kukurraarnu.” ");
INSERT INTO ntj_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nyangka Patipaku kurrilu Tjawutjaku kawutu tirtu kanyiranytja palunyaku kurri ngurrakutu pitjatjaku. ");
INSERT INTO ntj_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Palunyalu-lu nyinangu mayurnu watjarnu, “Wati Yiipuru tjiinya nyuntulun mantjirnu waarkarritjaku, palunyanya-rni nguwanpa ngarringu. ");
INSERT INTO ntj_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nyangka-rnatju lingkirrpa mirrangu. Nyangka kawutu wantirra ngurlu pakara yilkaku kukurraarnu.” ");
INSERT INTO ntj_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nyangka-ra Patipalu kuliralpi Tjawutjaku lirri warurringu. ");
INSERT INTO ntj_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Palunyalu watjarnu Tjawutjanya-ya tjulyara katirra tjayilpangka tjarrpatjunkutjaku. Nyangka-ya mularrpartu tjulyara katingu tjarrpatjunu, tjayilpa nyarra puurrpa Piiruku waarka palyalpayi-ya palyamunu palyaranytjatjanu nyinarranytja, palunyangkartu-luya tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nyangka Tjawutjanya tjayilpa kaninytjarra nyinarranyangka Mama Kuurrtu-lu walykumunura kanyiranytja. Nyangka puurrpa tjayiltatjalu Tjawutjanya nyakulalpi pukurlarringu-ra. ");
INSERT INTO ntj_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Palunyalu watjarnu Tjawutjalu-tjananya puurrarringkula kanyiltjaku tjayilpa-ya nyinapayi pirninya, palunyalu-tjananya tjurrkurlmara kanyiratjaku waarka-ya palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tjiinya Mama Kuurrtu-lu Tjawutjanya yirringkaranytja. Nyangka-tjananya walykumunura kanyiranytja. Nyangka palunyanguru puurrpa tjayiltatja watatja nyinarranytja kutjupa-kutjupa kulintjamaalpa Tjawutjalu palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Nyangka Tjawutjanya tjayilpangka tirtu nyinarranytja. Nyangka puurrpa Piirunya tjiinya ngurra ngaa Yiitjipunya lipikurtu puurrpa, palunyanya mirrparnarringu palunyaku waarka palyalpayi kutjarraku. Tjiinya wati kutjulu wayinpa katirra puurrpa Piiruku nintilpayi nyangka wati kutjupalu-ra mirrka nyamirli palyalpayi. Nyangka-pulampa mirrparnarringkulalpi tjayilpangka tjarrpatjunu, nyarra Tjawutjanya tjarrpangu nyinarranytja, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nyangka puurrpa tjayiltatjalu watjarnu Tjawutjalu-pulanya wati kutjarranya yirringkaratjaku. Nyangka-pula tjayilpangka rawa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nyinarrayirnu-pula ngarringu kutju-kutjulu tjukurrpa kutjupa-kutjupa nyangu. Tjiinya-pula munga kutjungkartu ngarringu tjuma nyangu. ");
INSERT INTO ntj_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Nyangka Tjawutjalu-pulanya yunguntjarra pitjangu nyangu tjurlpilypa-pula nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Palunyalu-pulanya tjapirnu, “Nyaatjanu-pulan tjurlpilypa nyinarra?” ");
INSERT INTO ntj_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nyangka-pula watjarnu, “Wiya, mungangka-litju kutjarralurtu ngarringu tjuma kutjupa-kutjupa nyangu. Palunyalu-litju purtu kulira. Nyaaku-litju tjuma nyangu? Nganalunyka-linyatju watjalku tjukarurrulku?” Nyangka Tjawutjalu-pulanya watjarnu, “Wiya, Mama Kuurrtu kutjulu tjukurrpa watjara tjukarurrulpayi. Palunyalu-rni watjalku tjukarurrulku tjumatjunkutja-pulan. Watjala-rnipula. Nyaapirinypa-pulan nyangu?” ");
INSERT INTO ntj_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nyangka wati nyarra kutjulpirtu puurrpa Piiruku wayinpa nintilpayilu watjarnu, “Yuwa, nyangu-rna warta kiripi ");
INSERT INTO ntj_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","yamirri marnkurrtjarra. Nyangkanyu nyarlpi pakannyangkartu yirnuntji paka-pakarnu. Nyangkalta kiripi kururringu. ");
INSERT INTO ntj_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nyangka-rnanyu kiripi mantjiralpi tjulkurnu puurrpa Piiruku panikinpangka tjutirnu. Palunyalu-rnaranyu nintirnu.” ");
INSERT INTO ntj_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","13","Nyangka Tjawutjalu watjarnu, “Yuwa, watjalku-rnanta tjukarurrulku nyuntulun tjumatjunkutjanya. Tjiinya warta yamirri marnkurrtu nintitjura tjiinyanta tjirntu marnkurrtjanulu puurrpa Piirulu yarltiku. Nyangkan marlaku yanku wayinpa-ran tirtu katirra nintinma, nyarra kurranyulun palyaranytja, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Nyangka-rni watatjarrinytjamaaltu kulinma. Palunyalu puurrpa Piiruku waarkarrinytjalu ngayunyatjarra watjala. Nyangka-rniyi pakaltjingala tjayilpangka-rna nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tjiinya-rniya ngurra yungarranguru karrpira katingu. Nyangka-rniya ngurra ngaa Yiitjipula kunpu-kunpu tjayilpangka tjarrpatjunu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nyangka wati nyarra mirrka nyamirli puurrpa Piiruku palyalpayilu kulirnu tjiinya Tjawutjalu wati kutjupaku tjukurrpa walykumunu watjarnu tjukarurrunnyangka. Palunyalu Tjawutjala watjarnu, “Ngayulutarra-rna tjuma ngarringu nyangu. Katangka-rnanyu tiirrtji purlkanya marnkurrpa tjarlirnu katirrayintja. ");
INSERT INTO ntj_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nyangkanyu tiirrtji katungkatjangka mirrka nyamirli kutjupa-kutjupa pirni ngarrirranytja. Nyangka-ya tjurlpu pirnilu pitjala mirrka tjulyara mantjira makatirra ngalkulanytja.” ");
INSERT INTO ntj_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","19","Nyangka Tjawutjalu watjarnu, “Yuwa, watjalku-rnanta tjukarurrulku nyuntulun tjumatjunkutjanya. Tjiinya tiirrtji purlkanya marnkurrtu nintitjunkula tjiinyanta tjirntu marnkurrnguru puurrpa Piirulu watjalku nyuntuku kata-ya kartara warnitjaku. Nyangka-ya mularrpartu kartalku. Palunyalunta-ya mirri purnungka yurtitjunku wantiku. Nyangka tjurlpulunta-ya pitjala nyinakatirra ngalkunma.” ");
INSERT INTO ntj_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Nyangka ngurra kutjarratjanulu-ya mirrka purlkanya palyarnu puurrpa Piirulu watjannyangka. Nyangka-tjananya puurrpa Piirulu palunyaku yamatji pirninya yarltingu pitjala-ya ngalkula pukurlarritjaku. Nyangka-ya pitjangu nyinarra ngalkulanyangka puurrpa Piirulu wati kutju witurnu yankula yarltirra katitjaku wayinpa nintilpayinya-pulanya nyamirli palyalpayinya. Nyangka mularrpartu tjayilkutu yanu-pulanya yarltirra katingu. ");
INSERT INTO ntj_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nyangka puurrpa Piirulu watjarnu wati nyarra wayinpa nintilpayilu-ra waarka puru palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Palunyalu warrmarla pirninya watjarnu wati nyarra nyamirli palyalpayinya-ya mirrirntankutjaku. Nyangka-ya mularrpartu mirrirntanu. Tjiinya Tjawutjalu watjarnu wantinytjanyartu yartakarringu. ");
INSERT INTO ntj_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nyangka wati nyarra wayinpa nintilpayinya Tjawutjaku watatjarringu. ");
INSERT INTO ntj_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nyangka kurli kutjarratjanulu puurrpa Piirulu ngarringu tjuma ngaapirinypa nyangu, tjiinya kapi kantilypangka ngaralanytja, kapi yirrala purlkanya yini Nayilta. ");
INSERT INTO ntj_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Palunyalu nyangu puluka karnpi purlkanya 7-pa-ya kapinguru paka-pakarnu. Palunyalu-ya yukiri parrangalkulanytja kapi kantilywanalu. ");
INSERT INTO ntj_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nyangka puru puluka nyurrka-nyurrka 7-pa-ya kapinguru pakarnu. ");
INSERT INTO ntj_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Palunyalu-ya puluka karnpi purlkanya 7-nga ngalangu wiyarnu. Nyangkalta puurrpa Piirunya tjulurraaralpi wankarringu. ");
INSERT INTO ntj_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Palunyalu marlaku kunkunarringkulalpi puru tjuma kutjupanya nyangu. Tjiinya nyangu yukiri mirrka wiirtjarra ngaralanytja. Nyangka yamirri kutjungka mirrka wiirpa yurninytjarra walykumunu 7-pa-ya ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nyangka marla puru nyangu wiirpa yurninytjarra kutjupa 7-pa-ya yutirringu yukiri palunyangkartu. Tjiinya-ya yurninytjarra yikirr-yikirrpa, pirriya warulu kampanytja-kampanytja ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Palunyalu-ya yurninytjarra yikirr-yikirrpa pirnilu kuurltjunu yurninytjarra walykumunu 7-nga. Nyangka puurrpa Piirunya pururtu wankarringkulalpi kulirnu, “Munta! Tjumatjunkulanytja-rna.” ");
INSERT INTO ntj_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nyangka tjirntungka puurrpa Piirunya pakarnu tjurlpilypa nyinarranytja. Tjiinyamarntu nyinarra tjuma palunyanya purtu kuliranytja. Palunyalu wati kutju witurnu yankula palunyaku wati ngalya yarlanya puru wati nintipuka pirninya yarltirra katitjaku. Nyangka mularrpartu-tjananya yarltirra katingu. Nyangkalta-tjananya tjuma kutjarranya watjarnu. Nyangka-ya pirnilurtu purtu kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Nyangkalta wati nyarra wayinpa nintilpayilu puurrpa Piirula watjarnu, “Munta! Watatjarringu-rna. Tjinguru-rnanta kutjulpirtulpi watjanma. ");
INSERT INTO ntj_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","12","Tjiinya-limpatjun kutjulpirtu nyamirli palyalpayiku mirrparnarringu. Palunyalu-linyatjun tjayilpangka tjarrpatjunu wantingu. Nyangka wati yangupala-latju tjayilpangka lurrtju nyinarranytja. Tjiinya yangupala palunyanya yini Tjawutjanya tjiinya nintipukalu tjukurrpa watjara tjukarurrulpayi. Nyangka-litju ngarringu kutjarralurtu tjuma kutju-kutju nyangu. Palunyalu-litju tjumatjunkulalpi Tjawutjala tjakultjunu. Nyangka watjarnu tjukarurrurnu. ");
INSERT INTO ntj_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nyangka mularrpartu yutirringu palunyaku wangkangkartu. Tjiinya-rnin watjarnu waarka-rnatju puru marlakulu palyaratjaku. Nyangka-ya nyamirli palyalpayinya mirrirntanu.” ");
INSERT INTO ntj_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nyangka puurrpa Piirulu kuliralpi wati kutju witurnu yankula Tjawutjanya yarltirra katitjaku. Nyangka mularrpartu yanu tjayilnguru pakaltjingarnu. Nyangka pakaralpinku tjayipungu palunyalu warntu walykumunu tjarrpatjunu. Nyangkalta-lu katingu puurrpa Piirulakutu. ");
INSERT INTO ntj_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Nyangka watjarnu, “Tjuma-rna ngarringu nyangu. Nyangka kutjupatjarralu-ya purtu kulira watjara tjukarurrulkitjalu. Nyangka-rni kutjupalu watjarnu tjiinya nyuntulunyun tjuma watjara tjukarurrulpayi.” ");
INSERT INTO ntj_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Nyangka Tjawutjalu watjarnu, “Wiya puurr, ngayulu-rna yungarralu purtu watjalku tjukarurrulku. Ngarna Mama Kuurrtu watjalku tjukarurrulku tjiinyan nintilu kuliltjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nyangka puurrpa Piirulu Tjawutjanya watjarnu, “Wiya, ngarringu-rna tjuma ngaapirinypa nyangu. Tjiinya ngaralanytja-rnanyu kapi yirrala Nayilta kantilypangka. ");
INSERT INTO ntj_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Palunyalu-rna nyangu puluka karnpi purlkanya 7-pa-ya kapinguru ngalyapakarnu. Palunyalu-yanyu yukiri parrangalkulanytja kapi kantilywanalu. ");
INSERT INTO ntj_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Palunyalu-rna puru nyangu puluka nyurrka-nyurrka 7-pa-ya kapi palunyangururtu ngalyapakannyangka. Tjiinya-rna puluka nyurrka-nyurrka palunyapirinypa kutjuwarra nyakula wantirranytjamunu Yiitjipulawana-ya ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nyangka-ya puluka nyurrka-nyurrka pirnilu puluka karnpi purlkanyanya ngalangu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Palunyatjanu-ya karnpirringkutjamaalpa nyurrka-nyurrka tirtu ngaralanytja. Nyangka-rna wankarringu. ");
INSERT INTO ntj_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Palunyalu-rna marlaku kunkunarringkulalpi tjuma kutjupanya nyangu. Tjiinya-rna nyangu yukiri mirrka wiirtjarra ngaralanytja. Nyangka yamirri kutjungka mirrka wiirpa yurninytjarra walykumunu 7-pa-ya ngaralanytja tjiinya kampangu yurnmirringkutja. ");
INSERT INTO ntj_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nyangka marla-rna puru nyangu wiirpa yurninytjarra kutjupa 7-pa-ya yutirringu yukiri palunyangkartu. Tjiinya-ya yurninytjarra palunyanya pirriya warulu rulyupungu-rulyupungu yikirr-yikirrmankutja ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Palunyalu-ya kuurltjunu yurninytjarra nyarra walykumunu pirninya. Palunyapirinypa-rna nyangu. Palunyalu-rna tjirntungka wati ngalya yarla pirninya yarltirralpi tjuma ngaa kutjarranya tjakultjunu. Nyangka-ya purtu kuliranytja watjara tjukarurrulkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nyangka Tjawutjalu kuliralpi watjarnu, “Tjiinya tjuma kutjarranyartu-pula kutjurringu yara waarrku. Tjiinya Mama Kuurrtunta nintitjura kutjupa-kutjupa ngula ngaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tjiinya puluka karnpi purlkanya 7-tu nintitjura mirrka purlkanya ngaralayilku kurli 7-tjanu wiyarriku. Nyangka palunyapirinypartu mirrka yurninytjarra walykumunu 7-tu nintitjura mirrka purlkanya ngaralayilku kurli 7-tjanu wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nyangka tjiinya-ya puluka nyurrka-nyurrka 7-nga kapinguru marla pakantjanya puru mirrka yurninytjarra 7-nga pirriya warulu kampangu yikirr-yikirrmankutjanya, palunyalu-ya nintitjura yayilurru purlkanya ngula yartakarritjaku. Nyangka ngaralayilku kurli 7-tjanu wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tjiinya Mama Kuurrtunta nintitjura ngula ngaapirinypa ngaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","30","Tjiinya Yiitjipula yarla lipiwana mirrka wiirpa purlkanya ngaralayilku nyangka kurli 7-tjanu yayilurru purlkanya yartakarriku. Palunyalu ngaralayilku kurli 7-tjanu wiyarriku. Nyangka yayilurru ngaralanyangka-ya yarnangu pirninya mirrka purlkanyaku watarrkurriku. Tjiinyamarntu-ya ngurra yarla lipiwana parltjatjirratjarriku nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Tjiinya yayilurru purlkanya ngaraku. Nyangka kutjupalu ruukulilkitjamunu mirrka purlkatjarra nyinangu wantitja. ");
INSERT INTO ntj_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tjiinya Mama Kuurrtunta kutjarrara nintitjunu, tjiinyan nintilu kuliratjaku. Tjiinya palunyalu mula-mulalu kulira palunyapirinypa kuwarri-kuwarrirtu palyalkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Puru Tjawutjalu puurrpa Piirula ngaapirinypa watjarnu, “Yuwa puurr, tjingurun nyuntulu ngurrkarntanku wati kutju yatatjura kulira palyalpayinya. Palunyalu-lun tjunku nyuntula yitingka ngurra ngaa Yiitjipuku puurrarritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Purun wati kutjupatjarra tjunku mirrkaku-ya puurrarritjaku. Nyangka-ya mirrka yurranma, tjiinya mirrka purlkanya ngaralanyangkalpi. Nyangka yarnangu pirnilu-yanku mirrka yurraralpi kutjupatjarra kanyinma. Palunyalu-ya kutjupatjarranya nintilku puurrpa pirniku, tjiinya-ya yiwarla mirrka tjunkupayila tjunkutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nyangka mirrka palunyanya ngulaku ngarrima. Nyangka yayilurru purlkanya yutirrinyangka-ya yarnangu pirnilu mirrka palunyangkatja ngalkunma parltjatjirratja mirrirritjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nyangka-ya puurrpa Piirulu puru palunyaku yamatji pirnilu Tjawutjaku tjukurrpa kuliralpi pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nyangka puurrpa Piirulu-tjananya watjarnu, “Wati ngaanya walykumunu mularrpa. Tjiinya Mama Kuurrku Kuurti Walykumunulu yirringkara. Wati kutjupa palunyapirinypa ngaangka nyinanytjamunurtu.” ");
INSERT INTO ntj_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Nyangka puurrpa Piirulu Tjawutjanya watjarnu, “Yuwa mularrpa, kutjupa nintipuka nyuntunyapirinypa ngaangka nyinanytjamunurtu. Tjiinyamarntu Mama Kuurrtunta pirninyartu yutirnu. ");
INSERT INTO ntj_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nyangka-rnanta tjunku puurrpan nyinarratjaku ngayuku kantjulpa pirniku. Nyangkanta-ya yarnangu pirnilu wangka kutju waarrpungkula kulinma. Nyangka kutjupanta nyuntula munkarra nyinakitjamunu. Ngarna ngayulukutju-rna puurrpa purlkanya nyinama. ");
INSERT INTO ntj_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yuwa, kuwarrinya-rnanta tjunku manta Yiitjipuku puurrpan nyinarratjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Nyangka puurrpa Piirulunku marangkatja yarraralpi Tjawutjaku marangka tjarrpatjunu kanyiltjaku. Palunyalu warntu walykumunu nintirnu tjarrpatjunkutjaku. Puru-lu lirringkatja kawurlpa lirriwanalu tjunu. ");
INSERT INTO ntj_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Palunyalu-lu watjarnu purni kaarrtjarra walykumunungka tjiinya puurrpa nampa 2-ngkatja tatiltjaku. Nyangka warrmarla pirninya-ya kurranyurringu, yarnangu pirninya-tjananya mirrarra watjaranytja, “Langarriwa-ya. Nyangkayi puurrpa yarlangkakutju mapitja!” Tjiinya palunyapirinypa puurrpa Piirulu Tjawutjanya tjunu ngurra Yiitjipula yarla lipiwana puurrpa nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Palunyalu Tjawutjanya watjarnu, “Palyartu-rna puurrpa purlkanya nyinarra. Nyangka kutjupalu ngurra ngaa Yiitjipulawanalu pina yungarralu kulira palyalkitjamunu. Ngarna nyuntulun watjannyangkakutju-ya kulira palyanma.” ");
INSERT INTO ntj_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Nyangka puurrpa Piirulu Tjawutjaku yini kutjupankulalpi tjapirnu Tjapina-Paniyanya. Palunyalu-ra nintirnu Patiparaku yurntalpa yini Yatjinanya kurri yarltitjaku. Tjiinya wati palunyalu yapu nyarra pupakatirra marninypungkupayi miranykanyilpayi ngurra yini Yiliyapalila. Nyangka Tjawutjalu mularrpartu kungka palunyanya yarltingu kanyiranytja. Nyangka tjiinya Tjawutjaku-ra kurli 30 ngaralanyangkalpi-lu puurrpa Piirulu ngurrkarntaralpi puurrpa nyinatjunu wantingu. Nyangka Tjawutjanya puurrpa Piiruku warlinguru pakara yanu ngurra yarla lipiwana parrangarala ngurra nyakulayintja. ");
INSERT INTO ntj_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nyangka kurli kutjupa kurli mirrka purlkanya ngaralayirnu kurli 7-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nyangka mirrka purlkanya ngaralanyangkalpi Tjawutjalu-tjananya watjarnu waarkarripayi pirnilu-ya mirrka wiirpa mawurntalpa yurrara tjunkutjaku yiwarla mirrka tjunkupayila. Nyangka-ya mirrka yurirltatja katirra tjunkulanytja yiwarla kutju-kutjungka nyarra ngamu-ya ngaralanytja, palunyatjinta. ");
INSERT INTO ntj_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tjiinya-ya yakutjangka tjunkula nampa nyangu-nyangu watatjarringu tjiinyamarntu mirrka purlkarringu. Nyangka-ya nampaku purtu kulirnu. ");
INSERT INTO ntj_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nyangka Tjawutjaku kurrilu katja kutjarra kanyirnu yayilurru kuwarripangka. ");
INSERT INTO ntj_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nyangka katja kurranyungkatjanya ngarrinyangka Tjawutjalu watjarnu, “Tjiinya-rna ngurra ngaaku pitjangu nyinarranytjalu yungarrapirtiku kulira watjil-watjilarringu. Puru-rna waarka purlkanya palyaranytja tjayilpangkatarrartu. Nyangka Mama Kuurrtu-rni pina watatjanu.” Nyangkanku katja tjapirnu yini Manatjanya. ");
INSERT INTO ntj_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Palunyalu katja marlangkatjanya nyakulalpi watjarnu, “Mama Kuurrtu-rni katja kutjarra nintirnu ngurra ngaa watjil-watjilta-rna nyinarranyangka. Nyangka-rnalu tjapilku yini Yipurayimanya.” ");
INSERT INTO ntj_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nyangka Yiitjipula mirrka purlkanyanya pakara ngarapayinya kurli 7-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","0Nyangkalta yayilurru purlkanya ngarangu. Tjiinya Tjawutjalu nyarra watjarnu wantingu, palunyapirinypartu yutirringu. Nyangka mirrka kurlunyarringu ngurra kutjupa-kutjupa pirningka. Nyangka-ya Yiitjipulawana mirrka purlkanya kanyiranytja mirrka tjunkupayila. ");
INSERT INTO ntj_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nyangka yayilurru purlkarringu ngaralanytja. Nyangka-ya yarnangu pirni mirrka wiyarringkula yankulanytja puurrpa Piirulakutu mirrkaku ngatjilkitja. Nyangka-tjananya watjalpayi, “Mapitja-ya Tjawutjanya tjapila. Nyangka-tjananyantayi kutjupa-kutjupa watjannyangka-ya kuliralpi wangarnarralu palyala.” ");
INSERT INTO ntj_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nyangka yayilurru ma-mula-mularrarringu ngurra Yiitjipulawana ngaralanytja. Nyangka Tjawutjalu yiwarla mirrkatjarra pirninya yarlara-wanarnu. Palunyalu-tjanampa mirrka tjimarrikitjalu nintiranytja ngurrarangkatja pirniku. ");
INSERT INTO ntj_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Nyangka-ya yarnangu pirni ngurra kutjupa-kutjupanguru pitjangu Yiitjipulakutu mirrka payipungkukitja. Tjiinyamarntu yayilurru purlkanya ngaralanytja manta lipiwanartu. ");
INSERT INTO ntj_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nyangka Tjawutjaku mama Tjayikapanya tirtu nyinarranytja ngurra yini Kayinanta palunyaku katja 11-tjarra. Nyangka yayilurru purlkarringu. Nyangka kutjupalu pitjangu Tjayikapanya watjarnu tjiinya yarnangu pirnilu-yanyu mirrka wiirpa purlkanya kanyira ngurra nyarra Yiitjipula. Nyangkalta-tjananya palunyaku katja pirni watjarnu, “Nyaaku-yan nyinarra purtu kulira? ");
INSERT INTO ntj_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Tjiinya-rna kulirnu mirrka wiirpa purlkanya-yanyu kanyira Yiitjipula. Pakara-ya yarra mirrka payipuwa, parltjatjirratja-lan nyinaku mirrirritjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Nyangka-ya mularrpartu Tjawutjaku kurta 10-pa yanu mirrka wiirpa payipungkukitja. ");
INSERT INTO ntj_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Nyangka Tjayikapalu marrkurnu Tjawutjaku marlanypa Pintjimannga ngurrangka nyinarratjaku. Tjiinyamarntu ngaapirinypa kuliranytja, “Tjinguru palunyaku kurtapirtingka yankulalpi kurrakuturriku.” ");
INSERT INTO ntj_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nyangka-ya Tjayikapaku katja pirni yarnangu kutjupatjarrangka lurrtjurringkula yanu mirrka payipungkukitja. Tjiinyamarntu yayilurru purlkanya ngaralanytja Kayinanta lipiwana. ");
INSERT INTO ntj_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nyangka-ya pitjalayirnu Yiitjipula tjarrparralpi yanu puurrpa Tjawutjalakutu, palunyalumarntu tjimarrikitjalu mirrka wiirpa nintiranytja yarnangu pirniku. Pitjangu-ya waalkarraralpi pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Nyangka Tjawutjalu-tjananya kutjukampa nyangu ngurrkarntanu. Nyangka-luya ngurrpalu nyakulanytja. Nyangka-tjananya ngarnartu malikipirinypa wangkarranytja. Palunyalu-tjananya mirrparn-mirrparntu tjapirnu, “Ngurra wanytjanguru-yan pitjangu?” Nyangka-ya watjarnu, “Ngurra yini Kayinantanguru-latju pitjanytja mirrka wiirpa payipungkukitja.” ");
INSERT INTO ntj_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nyangkalta Tjawutjalunku pina taparlarraralpi kulirnu, “Munta! Tjiinya kutjulpirtulpi-rna tjumatjunu, palunyanguru-ya pitjangu pupakatingu.” Nyangka-tjananya watjarnu, “Wiya, nyuntulu-yan ngarnartu pitjangu ngurra-lampatjuyan wiyapirinytju parranyakula yankula tjakultjunkukitja. Palunyalu-yan warrmarla yarltirra katikitja.” ");
INSERT INTO ntj_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nyangka-ya watjarnu, “Wiya puurr, mirrkakukutju-latju pitjanytja payipungkukitja. ");
INSERT INTO ntj_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ngayulu-latju kurtararranpa mama kutjungkatja. Tjiinya-latju mayuranytjamaaltu tjukarurrulu watjara.” ");
INSERT INTO ntj_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nyangka Tjawutjalu watjarnu, “Wiya, nyuntuku puurrtu-tjananyanta witurnu pitjala-yan wiyapirinytju parranyakutjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nyangka-ya watjarnu, “Wiya puurr, ngayulu-latju kurtararranpa nyinarra. Tjiinya-latju 12-pa nyinarranytja mama kutjungkatja. Nyangka-lampatju marlanypa kutju wiyarringu. Nyangka marlanypa marlangkatjanya mamangka nyinarra Kayinanta.” ");
INSERT INTO ntj_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nyangka Tjawutjalu watjarnu, “Yuwa, tjukarurrulu-rna watjaranytja. Nyuntulu-yan mayunytju pirni. Ngarnartu-yan pitjanytja ngurra-lampatjuyan wiyapirinytju parranyakukitja. ");
INSERT INTO ntj_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Tjurrkurltu-munta-yan watjara? Kulila-rna tjukarurrula. Tjiinya-tjananyarnanta 9-pa tjarrpatjunku kanyinma. Palunyalu-rna kutju witulku wantiku marlanypa-tjanampanku yankula yarltirra katitjaku. Nyangka-tjinguru-lu katinytjamunungka-rna nintilu kulilku tjiinya-yan wiyapirinypa pitjanytja ngurra parranyakukitja. Ngaanya-tjananyarnanta mula-mulalu watjara. Pakantjamaalpa-yan nyinama marlanypa marlangkatjanya pitjanytjamunungka.” ");
INSERT INTO ntj_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nyangka Tjawutjalu kurta pirninya, tjiinya 10-ngartu-tjananya tjayilpangka tjarrpatjunu. Nyangka-ya nyinangu ngurra kutjarratjanulu ");
INSERT INTO ntj_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","nyangu Tjawutjalu-tjananya pitjangu watjarnu, “Yuwa, tjinguru-tjananyarnanta pirninyartu mirrirntanama. Ngarna Mama Kuurrnga-rna kuliranytjalu-tjananyarnanta wantiku. Nyangka ngula-yan marlanypa yarltirra katiku. Wiyangka-tjinguru-tjananyarnanta mirrirntanku. ");
INSERT INTO ntj_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Yuwa, wati kutju tjayilpangka nyinaku. Nyangka-yan kutjupatjarralu mirrka marlakulu katiku yungarrapirtikutu, tjiinyamarntu-ya parltjatjirratja nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Palunyalu-yan ngula pitjalalpi marlanypa marlangkatjanya yarltirra katiku. Nyangka-rna nyakulalpi nintilu kulilku tjukarurrulu-rniyan watjannyangka. Palunyalu-tjananyarna warrmarla pirninya watjalkitjamunu mirri-tjananyanta pungkutjaku.” Nyangka-ya kuliralpi yuwarnmanu. ");
INSERT INTO ntj_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Palunyalu-ya marlakukuturnu ruukuliranytja Tjawutjanya-ya kutjulpirtu pirtingka warningu tjarrpatjunu. Palunyalu-yanku wangka yungarralu ngaparrku watjaranytja, “Kuwarripartu! Wiya, Tjawutjalanguru-lan kunkanyarringu. Tjiinya pirti kaninytjarranguru yularra-lanya watjaranytja yirringkankutjaku. Nyangka-lan kulira wantirranytja. Palunyalanguru-lan kurrakuturringu.” ");
INSERT INTO ntj_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nyangka kurta tirna Rupantu-tjananya watjarnu, “Ngayulu-tjananyarnanta purtu watjaranytja tjilku palunyanya-yan pungkutjamaaltu wantitjaku. Nyangka-yan kulira wantirranytja. Nyangka-lan palunyanguru kunkanyarringu.” ");
INSERT INTO ntj_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nyangka tjiinya-ya watatja wangkarranytja. Nyangka-tjananya Tjawutjalu kutjukampa kulira ngurrkarntaranytja. Tjiinya-tjananya tjaa maliki wangkarranytja. Nyangka wati kutjupalu-tjananya watjara yutiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Nyangka Tjawutjalu-tjananya kulira yanu kumpiralpi yularranytja. Yularrayirnu palyarringkula pitjangu. Palunyalu watjarnu waarka palyalpayi pirnilu-ya palunyaku kurta Tjimiyannga karrpiltjaku, ngarala-ya nyakulanyangka. Nyangka-ya mularrpartu karrpira katingu tjayilpangka tjarrpatjunu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nyangka Tjawutjalu-tjananya waarka palyalpayi pirninya watjarnu, “Mirrka wiirpa-tjanampaya yakutjangka tjutila mulyawiily-wiilymarra. Palunyalu tjimarri mirrkaku-ya nintintjanyatarrartu yakutjangka tjarrpatjurra. Puru mirrka-tjanampa nintila yalatjaku.” Nyangka-ya mularrpartu palunyapirinypa palyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nyangka kurta pirnilu-yanku kutju-kutjulu yakutja mirrkatjarra tungkingka yurtitjura kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Palunyalu-ya pitjalayirnu-pitjalayirnu ngururrpa ngurra tjunu ngarrikitjalu. Nyangka kurta kutjulunku yakutja yarlarnu palunyaku tungkiku mirrka mantjira nintilkitjalu. Yarlaralpi nyangu palunyaku tjimarri mirrkangka katu ngarrirranyangka. Nyakulalpi kata paarnarrarnu ");
INSERT INTO ntj_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","palunyaku kurta pirninya-tjananya mirrangu watjarnu, “Pitja-ya nyawa! Tjimarri nyarra puurrku-rna nintirnu mirrkaku, palunyanya ngaa ngarrirra yakutjangka.” Nyangka-ya nyakulalpi ngurlu-ngurlurringu. Palunyalu-yanku ngaparrku watjarnu, “Wiya, wartalpitjanu-lanya Mama Kuurrtu kunkanymanu.” ");
INSERT INTO ntj_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ngarringu tjirnturringkulalpi-ya pakarnu pitjalayirnu ngurrakutu parrapitjangu. Palunyalu-yanku mamangka tjukurrpa watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Tjiinya-ya ngaapirinypa watjarnu, “Puurrpa Yiitjipula nyinapayilu-lanyatju mirrparn-mirrparntu watjaranytja. Palunyalu-lanyatju ngukara watjaranytja, tjiinya-latjunyu wiyapirinypa palunyaku-tjanampa ngurrangka tjarrpangu pikakitja. ");
INSERT INTO ntj_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nyangka-latju watjarnu, ‘Wiya, ngayulu-latjunku mayunytju wiya. Tjukarurrulu-latju watjalpayi. ");
INSERT INTO ntj_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tjiinya-latju kurtararra 12-pa nyinarranytja mama kutjungkatja. Nyangka marlanypa kutju-lampatju wiyarringu. Nyangka marlanypa marlangkatjanya Kayinanta nyinarra mamangka.’ ");
INSERT INTO ntj_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Nyangka wati palunyalu watjarnu, ‘Mularrpa-munta-yan tjukarurrulu watjara? Kulilku-rna tjukarurrulkitjalu ngaapirinypa-tjananyarnanta watjalku. Tjiinya wati kutju ngayula-rni nyinaku. Nyangka-yan kutjupatjarralu mirrka wiirpa makatiku yungarrapirti ngurrangka nyinarranytjalu-ya ngalkula parltjarritjaku. ");
INSERT INTO ntj_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Palunyalu-yankun marlanypa yarltirra katiku. Nyangka-rna nyakulalpi mularrkulilku tjiinya-yan mayunytju wiya, tjukarurrulu watjalpayi. Palunyalu-tjanamparnanku kurta tjayilnguru pakaltjingalku. Nyangka-yan mukurringkulanytjalu palya ngurra ngaangka nyinarra kutjupa-kutjupa pirni tjimarrikitjalu ngurra pirniwanalu parranintinma.’” Palunyapirinypa-yanku mamangka watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nyangka-yanku kurta pirnilu yakutja yarlara-wanarnu mirrka tjunkupayingka tjutilkitjalu. Palunyalu-ya nyangu tjimarri palunyanya yakutja mirrkatjarra kutju-kutjungka ngarrirranytja. Nyangka-ya nyakulalpi ngurlurringu. Palunyaku mamalutarrartu nyakulalpi ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nyangka-tjananya palunyaku mamalu watjarnu, “Wiyangkalpi-yan ngayuku katja kutjarra Tjawutjanya-pulanya Tjimiyannga katingu kurrakuturnu. Palunyalu-yan watjara Pintjimanngalpi katikitjalu. Wanti. Tirtu-tjuyan katja katirra tjitjarntara.” ");
INSERT INTO ntj_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nyangka Rupantu watjarnu, “Wiya, Pintjimannga-rni ngayulawana witula. Nyangka-rnalu ngayulu miranykanyira kanyinma. Nyangka tjinguru-rnalu marlakulu katinytjamunungkan palya ngayuku katja kutjarranya pungku mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nyangka Tjayikapalu watjarnu, “Wiya, kamu-rna Pintjimannga witulku-tjananyarnanta. Wiyangkalpi-ra kurta wiyarringu. Nyangka-tju katja kutjurringu nyinarra. Nyangka-tjinguru-yan katiku kurrakuturalpi tjuni-rniyan kartarntanku. Nyangka-rna yulaku-yulaku mirrirriku, tjiinyamarntu-rna yirna purlkanya nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nyangka Kayinanta yayilurru ma-purlkarringu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Nyangka-ya Tjayikapaku yungarrapirtilu mirrka palunyanya ngalkulayirnu wiyarnu, tjiinya Yiitjipulanguru payipungu katinytjanya. Nyangka palunyaku mamalu katja pirni watjarnu, “Marlaku-ya yarra Yiitjipuku. Palunyalu-ya mirrka puru payipuwa.” ");
INSERT INTO ntj_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nyangka Tjuutalu watjarnu, “Wiya, puurrpa palunyalu-lanyatju watjarnu ngulanyu wangkakitjamunu. Ngarna-latju marlanypa makatinyangka-lanyatju wangkaku. ");
INSERT INTO ntj_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tjinguru-lanyatjun Pintjimannga witulku. Nyangka-latju yanku mirrka payipungku. ");
INSERT INTO ntj_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Wiyangka-tjinguru Pintjimannga-lanyatjun wituntjamunungka-latju wantiku nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Nyangka palunyaku mamalu-tjananya watjarnu, “Nyaaku-yan puurrpa palunyangka watjarnu tjiinya-yan marlanypa kanyiranytjalu? Mantjirnu-rniyan tjuni kurrarnu.” ");
INSERT INTO ntj_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nyangka-ya watjarnu, “Wiya, wati palunyalu-lanyatju rawalu tjapira ngurringaralanytja ngayunya-lanya puru-lampa yungarrapirti. Palunyalu ngaapirinypa tjapiranytja, ‘Mama-munta-tjanampanku wanka tirtu nyinarra? Marlanypa-munta-yan kutjupa puru kanyira?’ Tjiinya tjapiranyangkakutju-latju watjaranytja. Tjiinya wati palunyalu-lanyatju watjarnu kata pawurntjingarnu ngayulu-latjunku yankula marlanypa yarltirra katitjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nyangka Tjuutalunku mama watjarnu, “Pintjimannga-rni ngayulawana witula. Ka-latjuyi kuwarrirtu pakara yarra, pirninyartu-lan parltjatjirratja mirrirritjakutarra. ");
INSERT INTO ntj_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ngayulu-rnanta kalkulku wantiku wankaru makatirra marlakulu katikitjalu. Wiya-tjinguru-rna katinytjamunungka, palyartu-rnin kunkanymanku. ");
INSERT INTO ntj_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tjinguru-latju kutjulpirtulpi mirrkaku yankuma. Tjinguru-latju yankula mantjira pitjala nyinarra puru yankula marlaku pitjama. Ngaanyanyka-latju rawarringkula parranyinarra.” ");
INSERT INTO ntj_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nyangka palunyaku mamalu-tjananya watjarnu, “Wiya, mukurringkula-rna Pintjimannga kanyilkitja. Ngarna puurrtu watjannyangka-rna witulku. Kulila-ya. Kutjupa-kutjupa walykumunu pirni makati puurrku nintilkitjalu, tjiinya parnti walykumunu, yarrpalypa, mirrka tartu pirni puru yurninypa kutjupa-kutjupatarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Palunyalu-ya tjimarri purlkanya makati. Tjiinya tjimarri nyarra yakutjangka-yan nyangu palunyanyatarrartu-ya marlakulu makati nintila. Tjinguru-ya watatjarringu yakutja mirrkatjarrangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Marlanypa-yanku yarltirra waarrpungkula yarra. ");
INSERT INTO ntj_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nyangka-tjanamparnanku tjapilku Mama Kuurrtu Yayirninytjulu Palyalpayilu-tjananyanta kanyiltjaku puru puurrpa palunyanya wuyurrmankutjaku. Nyangka-tjanampankuyi ngarlturringkulalpi witula Pintjimannga-pulanya kurta kutjupanyatarrartu. Nyangka-yan lurrtjurringkula marlaku pitjaku. Wiyangka-tjinguru-rna palyartu purrkutjarrarriku tirtu nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Nyangka-ya kurta pirnilu Pintjimannga yarltirra yalatja yanu ngurra nyarra Yiitjipuku. Palunyalu-ya mantjira katingu kutjupa-kutjupa walykumunu pirni, puru tjimarri purlkanya puurrku nintilkitjalu. Tjiinya tjimarri yakutjangka ngarrirranytja, palunyanya-ya marlakulu katingu. Puru-ya tjimarri kutjupanya katingu mirrka puru payipungkukitjalu. Pitjalayirnu-ya Yiitjipula tjarrparralpi parrapitjangu waalkarrarnu Tjawutjala. Palunyatjanu-luya pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nyangka Tjawutjalu nyangu Pintjimannga-tjananya ngaralanyangka wati warli kanyilpayinya watjarnu, “Wati ngaanya-tjananya ngayuku warlikutu kati. Palunyalu kuka pungkulalpi paala tangkala. Nyangka-rniyayi karlarla kuwarrinya ngayula lurrtjurriwa mirrka ngala.” ");
INSERT INTO ntj_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nyangka mularrpartu-tjananya Tjawutjaku kurta pirninya palunyaku warlikutu yarltirra katingu. ");
INSERT INTO ntj_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nyangka-ya ngurlu-ngurlu mapitjalayintja. Palunyalu-yanku kulira watjaranytja, “Wartalpitjanu-lanya ngaanya katingu nyarra tjimarringuru. Tjiinya kutjupalu-lampa yakutja mirrkatjarrangka marlakulu tjarrpatjunu, palunyanguru-lanya ngaanya katingu. Palunyalu-lanya kuwarrinya kuru watjaralpi tjulyalku tjayilpa tjarrpatjunku, palunyalu-lampa tungki pirninya mantjira katiku.” ");
INSERT INTO ntj_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nyangka-ya warlingka tjarrpakitjalu wati warli kanyilpayingka watjarnu, ");
INSERT INTO ntj_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Puurr, ngaangkalpi-latju pitjanytja mirrka wiirpa payipungkula marlakulu katikitja. ");
INSERT INTO ntj_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ngurrakutu-latju marlaku yanu. Mapitjalayirnu-latju ngurra tjunu. Palunyalu-latjunku kutju-kutjulu yakutja mirrka wiirtjarra yarlaralpi nyangu tjimarri ngaa ngarrirra wankartu, tjiinya mirrkaku nintintjanya. Tjimarri palunyanya-latju marlakulu katingu. ");
INSERT INTO ntj_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Puru-latju tjimarri kutjupatjarratarrartu katingu mirrka puru payipungkukitjalu. Tjiinya-latju purtu kulirnu, ‘Nganalunyka-ya tjimarri palunyanya yakutjangka tjunu?’” ");
INSERT INTO ntj_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nyangka wati warli kanyilpayilu-tjananya watjarnu, “Tjurlpilyarriku-kurlu-yan. Wanti. Puru-kurlu-yan ngurlurriku. Tjiinya Mama Kuurrtu nyarra nyuntuku mamalu-yan pupakatirra marninypungkupayi, palunyalu-tjinguru-tjanampanku tjimarri yakutjangka tjunu. Tjiinyamarntu ngayulu-tjananyarnanta tjimarri nampartu mantjirnu.” Nyangka watjarnu wantirralpi-tjanampa kurta Tjimiyannga katingu lurrtjurnu. ");
INSERT INTO ntj_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Palunyalu-tjananya warlingka tjarrpatjunu. Puru kapi-tjanampa katingu nintirnu tjina-yanku parltjiltjaku. Palunyalu-tjanampa tungki pirniku mirrka nintirnu. ");
INSERT INTO ntj_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nyangka-ya kurta pirnilu walykumunu pirninya katinytjatjanulu tamarlmanu tjunu wantingu Tjawutjaku nintilkitjalu, karlarla pitjanyangka. Tjiinyamarntu-ya kulirnu mirrka-yanyu lurrtjurringkula ngalkutjaku ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Nyangka Tjawutjanya ngurrakutu pitjanyangka-ya kurta pirnilu walykumunu pirninya katingu nintiralpi pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nyangka Tjawutjalu-tjananya tjapirnu, “Walykumunu-munta-yan? Ngaangkalpi-rniyan nyuntuku mama yirnatjarra watjaranytja. Wankartu-munta nyinarra?” ");
INSERT INTO ntj_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nyangka-ya watjarnu “Yuwa puurr, mama-lampatju walykumunu, wankartu nyinarra.” Nyangka-ya puru pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Nyangka Tjawutjalu palunyaku marlanypa Pintjimannga nyakulalpi-tjananya watjarnu, “Yuwa, ngaanyartu-munta-tjanampanku marlanypa, tjiinya ngaangkalpi-rniyan watjaranytja?” Palunyalu-lu Pintjimanngalpi watjarnu, “Yuwa, Mama Kuurrtunta walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nyangka Tjawutjanya kurrurnpa kakulyarrarnu nguwanpa yularralpi waarrpungkula yanu palunyaku ruumpangka tjarrparralpi yularranytja. Tjiinyamarntu kurrurnpa pukurlarringu palunyaku marlanypa pitjanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yulangu wiyarringkulalpinku yiiku parltjirnu. Palunyalu marlaku pitjangu-tjananya lurrtjurringu. Palunyalu lirri palyarringkulalpi palunyaku waarkarripayi pirninya watjarnu, “Kati-ya mirrka pirninya tjurra ngalkutjaku-latju.” Nyangka-ya mularrpartu katirra tjunkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","33","Nyangka waarka palyalpayi kutjulu-tjananya kurta pirninya nyinatjunu. Tjiinya-tjananya ngaapirinypa nyinatjunkula-wanarnu. Kurta tirnanya kurranyulu nyinatjunkulalpi tjukarurrulu marlanypa pirninya-tjananya nyinatjunkula-wanarnu palunyalu marlanypa marlangkatjanya marla mularrpa nyinatjunu. Nyangka-yanku nyakulalpi yayirni-yayirnirringu. Palunyalu-ya kuliranytja, “Yuwa-parta, ngaanya ninti?” Nyangka Tjawutjalu kutjulu nyinarra ngalkulanytja. Nyangka-raya palunyaku kurtapirtilu mawurntaltu ngalyanyinarra ngalkulanytja. Nyangka-ya Yiitjipunyamartatji pirnilu mawurntalturtu puru nyinarra ngalkulanytja. Tjiinya-tjanampa Yiitjipunyamartatji pirniku mayaka ngaralanytja Yiipuru pirningka lurrtjurringkula ngalkunytjamaaltu wantirratjaku. Palunyalanguru-ya mawurntaltu nyinarra ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nyangka-ya waarka palyalpayi pirnilu kuka mirrka purlkanya katingu tjunu Tjawutjaku tayipulpangka. Palunyalu-ya palunyangkatja katirra nintiranytja kurta pirniku. Palunyalu-ya mirrka purlkanya mularrpa wayirntanu nintirnu Pintjimanku. Nyangka-ya nyinarra pukurltu wama tjikira mirrka ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","2","Nyangka Tjawutjalu palunyaku warli kanyilpayingka watjarnu, “Wati pirniku-tjanampa yakutjangka mirrka wiirpa tjutirayila mulyawiily-wiilymarra. Palunyalu tjimarri-tjanampa marlakulu yakutjangka tjarrpatjurra. Palunyalu ngayuku panikinpa walykumununya tjarrpatjurra wati marlangkatjaku yakutjangka.” Nyangka mularrpartu palunyapirinypa palyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nyangka kurtararranpa-ya ngarringu tjirnturringu. Nyangka-tjananya munga-mungangka waarka palyalpayilu wankaralpi witurnu ngurrakutu-ya pakara yankutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nyangka-ya pakara yanu. Palunyalu kuwarripartu ngamutja mapitjalayinnyangka Tjawutjalu palunyaku warli kanyilpayingka watjarnu, “Waarrpuwa wati nyarranya-tjananya ngurlura wanala. Mapitja-tjananya lurrtjurringkulalpi ngaapirinypa watjala, ‘Ngayuku puurrtu-tjananyanta walykumunura kanyiranytja. Nyangka-rayan nyaaku palunyaku panikinpa walykumununya mulyatarringu? ");
INSERT INTO ntj_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Panikinpa palunyangkatja tjikira wiyarringkula kapi puru tjutilpayi. Palunyalu yayirnirrirra nyakupayi kutjupa-kutjupa pirni ngula yutirritjaku. Tjiinya-yan walykunytjilpa palyarnu.’” ");
INSERT INTO ntj_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Nyangka mularrpartu-tjananya ngurlura wanarnu ngamuntinu. Palunyalu nyakulalpi watjarnu, “Nyaaku-yan ngayuku puurrku panikinpa walykumununya mulyatarringu?” ");
INSERT INTO ntj_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nyangka-ya watjarnu, “Wiya puurr, nyaapan watjara? Ngayulu-latju-kulila kutjuwarra palunyapirinypa palyaranytjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tjiinya-latju tjimarri pirninya yakutja mirrkatjarrangka ngurrintjatjanulu Kayinantanguru marlakulu katinytja. Kamu-latju kutjupa-kutjupa walykumunu mulyatarriku nyuntuku puurrku warlingkatja. ");
INSERT INTO ntj_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tjingurun ngurrilku nyaku kutjupalu panikinpa palunyanya kanyiranyangka palya-lun pungku mirrirntanku. Nyangka-latju ngaa kutjupatjarralu nyinaku nyuntuku waarka palyanma.” ");
INSERT INTO ntj_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nyangka wati palunyalu watjarnu, “Yuwa palya. Nyangka wati nyarra panikinpa walykumununya mulyatarringu, palunyanyakutju nyinarra ngayuku tirtu waarkarrima. Nyangka-yan kutjupatjarranya palya marlaku yanku ngurrakutu.” ");
INSERT INTO ntj_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Nyangka-yanku kurtararralu waarrpungu yakutja mirrkatjarra pirninya mantjiralpi mantangka tjunkula-wanarnu. Palunyalu-ya yarlara-wanarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nyangka Tjawutjaku waarka palyalpayilu yakutja pirninya nyakula-wanaranytja. Tjiinya kurta tirnaku yakutja kurranyulu nyangu palunyalu marlanypa pirniku nyakula wanarnu-wanarnu marla mularrpa Pintjimanku yakutjangka nyangu, “Panikinpa palunyanya ngaa ngarrirra.” ");
INSERT INTO ntj_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nyangka-ya kurta pirnilu nyakulalpi kata paarnarrarnu. Palunyalu-yanku tjuni tjurlpilyarringkulalpi tjaarnpa wartunpungu. Palunyalu-ya yakutja mirrkatjarra pirninya marlakulu tungkingka tjunkula marlaku yanu yiwarlakutu. ");
INSERT INTO ntj_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Palunyalu Tjuutanya-ya kurtararranpa pitjalayirnu parrapitjangu Tjawutjaku yiwarlakutu. Nyangka tjiinya pakara yankutjamaalpa kuwarripartu nyinarranytja. Nyangka-luya parrapitjangu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nyangka-tjananya watjarnu, “Nyaaku-yan palunyapirinypa palyarnu? Ngayulu-rna-kulila ngalya yarla, kutjupa-kutjupa nyakupayi.” ");
INSERT INTO ntj_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Nyangka Tjuutalu watjarnu, “Wiya puurr, purtu-latju kulira kutjupa-kutjupa watjalkitjalu. Kutjulpirtu-latju palyamunu palyarnu. Nyangka kumpilpa ngaralayirnu, nyangka Mama Kuurrtu yartakanu. Ngaanguru-latju pirninyartu nyinarra nyuntuku tirtu waarkarrima, wati nyarra panikinpa kanyiranytja, puru ngayulutarrartu-latju nyinarra waarkarrima.” ");
INSERT INTO ntj_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Nyangka Tjawutjalu watjarnu, “Wiya! Kamu-tjananyarnanta watjalku pirninyartu-tjuyan nyinarra waarkarritjaku. Ngarna nyarra panikinpa kanyiranytja, palunyanyakutju-tju nyinarra waarkarrima. Nyangka-yan kutjupatjarranya palya pukurlpa marlaku yanku mamakutu.” ");
INSERT INTO ntj_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nyangka Tjuutalu Tjawutjala ngamurringkulalpi watjarnu, “Puurr, mukurringkula-rnanta wangkakitja kurrurnpa rapa. Nyangka-rni kulila watjaranyangka-rnanta. Mirrparnarriku-kurlu-tjun. Tjiinyan nyuntulu puurrpa purlkanyapirinypa nyinarra. Nyangka-rna ngayulu mungutja. ");
INSERT INTO ntj_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tjiinya-lanyatjun ngaangkalpi tjapirnu, ‘Mama-munta-tjanampanku wanka nyinarra? Puru-munta-yan marlanypa kutjupa kanyira?’ ");
INSERT INTO ntj_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nyangka-latju watjarnu, ‘Yuwa, mama-lampatju yirna nyinarra. Puru-lampatju marlanypa marlangkatjanya nyinarra, Mamalu yirnalu yutintjanya. Nyangka palunyaku-ra kurta mirrirringu. Tjiinya-pula ngunytju kutjungkatja. Nyangka ngayuku-lampatju mamalu Pintjimannga mukulyanytjulu kanyilpayi.’ ");
INSERT INTO ntj_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nyangka nyuntulu-lanyatjun watjarnu, ‘Marlanypa palunyanya yarltirra kati nyakutjaku-rna.’ ");
INSERT INTO ntj_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nyangka-latju watjarnu, ‘Wiya, mama-lampatju mirrirriku, Pintjimannga-latju yarltirra katinyangka.’ ");
INSERT INTO ntj_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nyangka-lanyatjun watjarnu, ‘Wiya, marlanypa-yanku katinytjamunungka-tjananyarnanta puru wangkakitjamunu.’” ");
INSERT INTO ntj_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nyangka Tjuutalu tirtu watjaranytja, “Nyangka-latju marlaku yanu nyuntuku wangka Mamala tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nyangka nyinarrayirnu ngulartu-lanyatju puru witurnu mirrka puru payipungkutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nyangka-latju watjarnu, ‘Wiya, puurrtu-lanyatju watjarnu ngula wangkakitjamunu. Ngarna-latjunyu marlanypa makatinyangka wangkaku-lanyatju.’ ");
INSERT INTO ntj_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Nyangka Mamalu watjarnu, ‘Ninti-yan tjiinya ngayuku kurri Rayirrtjultu katja kutjarra kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Nyangka kutju wiyarringu tirtu palunya. Nyangka-rna nyakunytjamaalarringu. Tjinguru ngupanulu ngalangu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nyangka-yan palunyaku marlanypa Pintjimannga katinyangka tjinguru kurrakuturriku. Palunyangka-rna katja marlangkatjatjirratja kulilku-kulilku yirna purlkanya mirrirriku katja marlangkatjatjirratja.’” ");
INSERT INTO ntj_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Nyangka Tjuutalu tirtu watjaranytja, “Nyangka-tjinguru-rna marlanypa Pintjimannga ngurra ngaangka wantirra marlaku yankunyangka Mamalu purtu nyakulalpi mirrirriku. Tjiinya ngayuku-lampatju mamalu katja marlangkatjanya mukulyanytjulu kanyilpayi. Nyangka-tjinguru-latju Pintjimannga marlakulu katinytjamunungka Mamanya tjuni kartakatirralpi tjirturu-tjirturu purlkarringkulalpi mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nyangka-rna Mamanya kalkurnu wantingu tjiinya Pintjimannga-rnalu wankartu marlakulu katikitjalu. Nyangka-tjinguru-rna katinytjamunungka, palyartu-rni kunkanymanku.” ");
INSERT INTO ntj_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Palunyalu Tjuutalu puru kurrurntutarra watjarnu, “Wiya puurr, marlanypa-lampatju witula kurta pirningka Mamalakutu yankutjaku. Nyangka-rna ngayulu ngurra ngaangka nyinarra-rnanku waarka palyanma. ");
INSERT INTO ntj_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kamu-rnatju marlanypa marlangkatjanya wantirralpi Mamalakutu marlaku yanku. Ngayulu-rna Mamanya ngarltutjarra nyakukitjamunu tjirturu-tjirturu purlkarrinyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nyangka Tjawutjalu Tjuutaku tjukurrpa kuliralpi kurrurnpa kakulyarrarnu. Palunyalu yulakitjalu wantingu. Tjiinyamarntu-ya palunyaku waarka palyalpayinyatarrartu ngaralanytja. Nyangka-tjananya witurnu. Nyangka-ya mularrpartu yilkaku yanu. Nyangka Tjawutjalu-tjananya kurtapirtingka watjarnu, “Kulila-rniya. Ngayulu-tjanamparnanku marlanypa Tjawutjanya.” ");
INSERT INTO ntj_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nyangka palunyapirinypa watjaralpi mirrarra yularranytja. Nyangka-ya Yiitjipunyamartatji pirnilu kulira yanu puurrpa Piirula tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nyangka Tjawutjalu-tjananya kurtapirtingka watjarnu, “Ngayulu-tjanamparnanku marlanypa Tjawutjanya. Mularrpa-munta Mamanya wanka tirtu nyinarra?” Nyangka-ya kuliralpi kata paarnarrarnu purtu kuli-kulirnu. Palunyalu-ya ngurlurringkulalpi wangkamaalpa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Nyangka-tjananya watjarnu, “Ngamurringkula-ya pitja.” Nyangka-ya ngamurrinyangka-tjananya watjarnu, “Yuwa, marlanypa-tjanamparnanku Tjawutjanya. Tjiinya-rniyan tjimarrikitjalu maliki pirniku nintirnu, nyangka-rniya Yiitjipuku katingu, palunyanya-rna. ");
INSERT INTO ntj_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Wiya, palyartu-rniyan maliki pirniku nintirnu. Nyangka-kurlu-yan tjurlpilyarriku ruukuliralpi. Puru-kurlu-yankun yungarralu kulinma palyamunu palyantjatjanulu. Wantima-ya. Tjiinya-rni Mama Kuurrtu ngalyawiturnu kurranyurringkula-rna pitjala yarnangu pirninya wankara kanyiratjaku parltjatjirratja-ya mirrirritjakutarra tjiinya yayilurru purlkanya ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tjiinya-rni Mama Kuurrtu nintitjunu yayilurru rawa mularrpa ngaralayiltjaku. Nyangka mularrpartu yayilurru ngaralayirnu tirtu ngarala. Palunyalu puru ngaralayilku ngula wiyarriku. Tjiinya yayilurru ngaralanyangka kutjupalu mirrka purtu pakaltjingalku. Tjiinyamarntu kapi punkalkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tjiinya-rni Mama Kuurrtu kuliltjarralu ngalyawiturnu kurranyurringkula-rna ngurra ngaangka nyinarratjaku. Nyangka-tjananyarnantayi nyuntunya puru nyuntuku tjamu kaparlipirti wankara kanyinma parltjatjirratja-yan mirrirritjakutarra. ");
INSERT INTO ntj_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tjiinya nyuntulu-rniyan ngurra ngaaku wituntjamunurtu. Mama Kuurrtu-rni katingu nyinatjunu puurrpa-rna nyinarratjaku. Nyangka puurrpa Piirunyakutju ngayula-rni munkarra nyinarra. Nyangka ngayulu-tjananyarna yarnangu pirni miranykanyira Yiitjipula yarla lipingkatjanyartu.” ");
INSERT INTO ntj_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Puru Tjawutjalu-tjananya ngaapirinypa watjarnu, “Kulila-rniya. Waarrpungkula-ya marlaku yarra Mamalakutu. Palunyalu-ya ngayuku wangka ngaapirinypa watjala, ‘Mama Kuurrtu-rni tjunu puurrpa-rna nyinarratjaku ngurra ngaa Yiitjipuku. Nyangka waarrpungkula pitja ");
INSERT INTO ntj_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ngayula-rni ngamu nyinama ngurra yini Kutjurnta. Kati-tjananya nyuntuku katja yurntalpa, tjamu kaparlitarrartu. Puru yanamulpa pirninya kati, purunku yulytja kutjupa-kutjupa, palunyanyatarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nyangka-rnanta ngurra ngaa Yiitjipula mirrkangkara kanyinma, yayilurru purlkanya kuwarripangkartu ngaralanyangka. Pitja-ya ngamu nyinama tjiinya-yan pirninyartu puru yanamulpatarrartu nyinaku parltjatjirratja mirrirritjakutarrartu.’” ");
INSERT INTO ntj_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Puru Tjawutjalu-tjananya ngaapirinypa watjarnu, “Nyakula-munta-rniyan tjiinya-rna mularrpa Tjawutjanya wangkarra?” Palunyalu Pintjimantalpi watjarnu, “Nyakula-munta-rnin tjiinya-rna mularrpa Tjawutjanya wangkarranyangka?” ");
INSERT INTO ntj_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Palunyalu-tjananya watjarnu, “Yankulalpi-ya Mamala watjala tjiinya-rna puurrpa nyinarra ngurra ngaa Yiitjipula. Puru-luya watjala kutjupa-kutjupa pirni-yan nyakunytjatjanulu. Waarrpungkula-ya yarra Mamanya yarltirra kati.” ");
INSERT INTO ntj_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nyangka Tjawutjalu-pulanku Pintjimantu yampuralpi yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nyangka Tjawutjalu-tjananya yulalu-yulalu kurta pirninyartu yampura parranyunytjuranytja. Nyangkalta-ya palunyalanguru raparringkulalpi Tjawutjala wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nyangka kutjupalu yanu puurrpa Piirunya watjarnu tjiinya Tjawutjaku kurtapirti-ya pitjanyangka. Nyangka puurrpa Piirulu puru palunyaku yamatji pirnilu-ya kuliralpi pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Palunyalu wati kutju witurnu yankula Tjawutjanya yarltirra katitjaku. Nyangka pitjanyangka-lu puurrpa Piirulu watjarnu, “Watjalanku nyuntuku kurtapirti tungkingka-yanku mirrka yurtitjunkula Kayinantakutu marlaku yankutjaku. ");
INSERT INTO ntj_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Palunyalu-yankuyi mama puru yungarrapirti yarltirra kati. Nyangka-tjanamparna manta walykumunu nintilku. Nyangka mirrka kutjupa-kutjupa pirni pakannyangka-ya ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Puru-tjananya watjala kaarrpa pirni-ya makatitjaku, tjiinya kurri puru tjilku pirninya-ya tatira pitjatjaku. Puru watjala mamatarrartu-yanku tatitjura katitjaku. ");
INSERT INTO ntj_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Puru-tjananya watjala, ‘Yulytja kutjupa-kutjupa pirninya-yanku kulintjamaaltu wantirra pitja.’ Tjiinyamarntu ngurra ngaangka-ya tjarrpanyangka-tjanamparna kutjupa-kutjupa walykumunu pirni nintilku.” ");
INSERT INTO ntj_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Nyangka mularrpartu Tjawutjalu-tjanampa kaarrpa pirni puru mirrkatarrartu yalatjaku nintira wanarnu. ");
INSERT INTO ntj_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Palunyalu-tjanampa kurta pirniku kawutu walykumunu kutju-kutju nintirnu. Palunyalu-ra Pintjimanku nintirnu kawutu walykumunu 5-pa puru tjimarri purlkanya. ");
INSERT INTO ntj_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Palunyalu kutjupa-kutjupa nintirnu mamaku-raya makatirra nintiltjaku, tjiinya tungki 10-pa kutjupa-kutjupa walykumunu pirnitjarra, puru tungki 10-pa mirrka wiirpa puru nyamirli pirnitjarra. Puru-ra tjunu mirrka kutjupatjarra Yiitjipuku ngalyapakaralpi yalatjalu ngalyangalkulayiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Palunyalu-tjananya kurta pirninya wituralpi watjarnu, “Mapitjaku-kurlu-yan ngururrpa pika-pikarringku. Kurrurnpa pukurlpa-ya mapitjalayila ngurrangka ma-tjarrpa.” ");
INSERT INTO ntj_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nyangka-ya Yiitjipunya wantirra marlaku yanu palunyaku mamakutu Kayinanta nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Pitjalayirnu-ya tjarrparralpi watjarnu, “Kulilku-muntan? Nyuntukunku katja Tjawutjanya mirrimaalpartu wanka nyinarra. Tjiinya puurrarringu nyinarra Yiitjipuku yarla lipikurtu.” Nyangka Tjayikapalu kuliralpi kata paarnarrarnu. Palunyalu purtu mula-mularringkulanytja. Tjiinya kuliranytja mayura-ya, palunyakukantja. ");
INSERT INTO ntj_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Palunyalu Tjawutjaku tjukurrpa kuliralpi puru kaarrpa Yiitjipuku yalatja yankutjaku nyakulalpi mula-mularringu. Palunyalu kurrurnpa palyarringkulalpi pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Palunyalu watjarnu, “Yuwa-parta, ngayuku katja Tjawutjanya wankartu nyinarra. Pitjangu-rniyan yipilymanu tjukurrpa walykumunungka. Waarrpungku-rna yanku wankalulpi nyaku palunyalu wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nyangka Tjayikapalunku yulytja pirninyartu yurrara pakarnu ngurra nyarra Yiitjipuku. Tjiinya palunyaku yungarrapirti puru yanamulpa pirninyartu katingu. Pitjalayirnu-ya yiwarla yini Piyatjiipala yitingka ngurra tjunu. Nyangka Tjayikapalu yapu pirninya parratjunkula-wanarnu katurnu. Palunyalu kuka pungu tilirnu tjunkulalpi nintirnu Mama Kuurrku, tjiinya palunyaku mama Yayitjikilu pupakatirra marninypungkupayi, palunyaku. ");
INSERT INTO ntj_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Palunyalu ngarringu kulirnu Mama Kuurrtu-lu ngarala tjapiranytja, “Tjayikapa!” Nyangka kuliralpi watjarnu, “Yuwa, kulira-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nyangka Mama Kuurrtu-lu watjarnu, “Yuwa, ngayulu-rna Mama Kuurrnga, tjiinya nyuntuku mamalu-rni pupakatirra marninypungkupayinya. Ngurlumaalpa mapitja Yiitjipulakutu. Tjiinya-rnanta ngayulu walykumunura kanyiranyangka nyuntuku tjamu kaparlipirti-ya pirnirringku. Nyangka-tjananyaya yarnangu pirnilu mirrawarnima. ");
INSERT INTO ntj_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ngayulu-rnanta tirtu miranykanyira kanyinma ngurra nyarra Yiitjipulan nyinarranyangka. Nyangkan nyinaku wiyarringku nyuntuku katja Tjawutjaku kurungkartu. Nyangka ngula-tjananyarna nyuntuku tjamu kaparlipirti marlakulu katiku ngurra ngaaku.” Palunyapirinypa Mama Kuurrtu-lu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Nyangka Tjayikapanya puru palunyaku yungarrapirti-ya ngarringu tjirnturringkulalpi Piyatjiipanya wantirra kutipitjangu Yiitjipulakutu. Tjiinya-luya palunyaku katjapirtilu tatitjunu purni kaarrtjarrangka nyarra puurrpa Piirulu-ra ngalyawiyarnu, palunyangka. Palunyalu-ya tjilku kurluny-kurlunypa pirninya puru-yanku kurri pirninya purni kaarrtjarra kutjupatjarrangka tatitjunu. Tjiinya Tjayikapaku yungarrapirti pirninyartu-ya kutipitjangu Yiitjipulakutu, palunyaku katja yurntalpirti, puru tjamu kaparlipirti. Puru-yanku yanamulpa pirninya puru yulytja pirninyartu katingu. ");
INSERT INTO ntj_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","25","Nyangka Tjayikapalu katja 12-pa yutirnu. Nyangka-ya kurri yarltirra-wanarnu, palunyanguru-ya pirnirringu. ");
INSERT INTO ntj_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tjiinya Tjayikapanya puru palunyaku yungarrapirti nyarra Yiitjipuku-ya yanu, palunyanya-ya pirni mularrpa. Tjiinya-ya yarnangu 66-pa yanu. Tjiinya palunyaku mingkayipirti lurrtjuntjamunurtu nampa ngaa palunyangka. ");
INSERT INTO ntj_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Nyangka Tjawutjanya, puru palunyaku katja kutjarranya-pula kurranyu-ya ngurra palunyangka nyinarranytja. Palunyanguru tjiinya Tjayikapaku wartangkatja-ya yarnangu 70 Yiitjipula nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nyangka-ya Yiitjipuku ngamurringkulanyangka Tjayikapalunku katja Tjuutanya watjarnu, “Kurranyurringkula yarra Tjawutjanya watjala ngata-ngata pitjala-lanyatju ngurra yini Kutjurnta lurrtjurringkutjaku.” Nyangka mularrpartu kurranyurringkula yanu Tjawutjanya-lu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Nyangka kuliralpi pakarnu palunyaku purni kaarrtjarrangka tatira ngata-ngata makukurraarnu palunyaku mama nyakukitja. Palunyalu kukurrpa mapitjalayirnu mamanku nyakulalpi pukurltu parrayampurnu. Palunyalu rawa ngarala yularranytja. ");
INSERT INTO ntj_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nyangka Tjayikapalunku katjangka watjarnu, “Wiya, kuwarrinyakutju-rnanta nyangu kurrurnpa pukurlarringu. Palunyangurulta-rna nyinaku pinayurtu wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Nyangka Tjawutjalu-tjananya palunyaku kurtapirtingka puru kutjupatjarrangka watjarnu, “Yanku-rna puurrpa Piirunya watjalku tjiinya-yan Kayinantanguru pitjangu ngurra ngaangka nyinakitja. ");
INSERT INTO ntj_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tjiinya-rnalu ngaapirinypa watjalku, tjiinya nyuntulu-yan tjiipu miranykanyilpayi. Palunyalu-yankun tjiipu, nanikuurrpa, puluka pirni katingu puru kutjupa-kutjupa pirninyatarrartu. ");
INSERT INTO ntj_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Nyangka puurrpa Piirulu-tjananyanta yarltirralpi tjapilku, ‘Waarka nyaapirinypa-yan palyalpayi?’ ");
INSERT INTO ntj_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Nyangka-yan kuliralpi ngaapirinypa watjalku, ‘Ngayulu-latju puluka tjiipu nanikuurrpa pirni miranykanyira kanyilpayi, tjiinya-lampatju tjamupirtingka yarangka.’ Tjiinya Yiitjipunyamartatji-ya yanamulpa kanyilpayi pirningka ngamu nyinakitjamunu. Nyangka puurrpa Piirulu-tjananyanta kuliralpi watjalku ngurra ngaa Kutjurnta-yan ngurra tjunkula mawurntalpa nyinarratjaku. Nyangka-yan ngurra ngaangka tjunkulalpi nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Nyangka Tjawutjalunku kurta 5-pa katingu puurrpa Piirula nintitjunkukitjalu. Palunyalu puurrpa Piiruku warlingka tjarrparralpi watjarnu, “Ngayuku mama puru kurtapirti-ya ngurra Kayinantanguru tjarrpangu. Tjiinya-yanku pirnipurlka katinytja, tjiipu, nanikuurrpa, puluka puru yulytja kutjupa-kutjupatarrartu Kutjurnta tjunkulalpi nyinarra.” Nyangka Tjawutjalu-tjananya kurta 5-nya papulangka nintitjunu. ");
INSERT INTO ntj_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Nyangka puurrpa Piirulu-tjananya tjapirnu, “Waarka nyaapirinypa-yan palyalpayi?” Nyangka-ya watjarnu, “Wiya Puurr, yanamulpa-latju miranykanyilpayi, tjiinya ngayuku-lampatju tjamupirtilu palyalpayi, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tjiinya-latju pitjangu ngurra ngaangka nyinakitja, tjiinyamarntu ngayuku-lampatju ngurrawana yayilurru purlkanya ngarala. Nyangka yukiri wiyarringu yanamulpa pirnilu-ya ngalkutjaku. Nyangka palya-munta-latju ngurra tjunkulalpi nyinama Kutjurntawana?” ");
INSERT INTO ntj_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Nyangka puurrpa Piirulu Tjawutjanya watjarnu, “Yuwa, walykumunu-ya nyuntuku mama puru kurta pirninya pitjangu ngurra ngaangka tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Nyangka ngurra ngaa Yiitjipunya lipi ngarala tjiinya-ya ngurrkarntara ngurra tjunkula nyinarratjaku. Nyangka-rna kulira tjiinya palya-tjinguru-yanku ngurra tjunkula nyinama Kutjurnta. Tjiinyamarntu ngurra palunyanya walykumunu. Nyangka-tjananya watjala, yanamulpa walykumunura kanyilpayilu-yayi ngayuku yanamulpa pirninyatarrartu miranykanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Nyangkalta Tjawutjalunku mama Tjayikapanya katingu puurrpa Piirula nintitjunu. Nyangka Tjayikapalu puurrpa Piirula watjarnu, “Yuwa, Mama Kuurrtunta walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Nyangka puurrpa Piirulu tjapirnu, “Kurlinku yaaltjirri ngarala?” ");
INSERT INTO ntj_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Nyangka Tjayikapalu-lu watjarnu, “Wiya, parranyinarrayintja-rna ngurra pirniwana. Nyangka-tju kurli 130-kutju ngarala. Tjiinya ngayuku tjamu puru mama rawa mularrpa parranyinarrayirnu kurli pirnitjanu wiyarringu. Nyangka ngarltutjarra-tju kurli ngatalpa ngarala. Nyangka-tju kutjupa-kutjupa palyamunu tirtu ngaralanytja.” ");
INSERT INTO ntj_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nyangka Tjayikapalu puurrpa Piirula watjarnu, “Tjapilku-rna Mama Kuurrnga.” Palunyalu tjapirnu, “Yuwa Mama, puurrpa Piirunya walykumunura kanyinma.” Palunyapirinypa tjapiralpi wantirra yanu. ");
INSERT INTO ntj_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nyangka Tjawutjalu-tjananya mama puru kurtapirti Yiitjipula nyinatjunu ngurra walykumunungka yiwarla yini Ramatjila yitingka tjiinya puurrpa Piirulu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Palunyalu-tjananya pirninyartu tirtu mirrkangkara kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nyangka yayilurru purlkanya ngaralanyangka-tjanampa mirrka wiyarringu yarla lipiwanartu. Nyangka-ya yarnangu pirninyartu Yiitjipula puru Kayinantatarrartu parltjatjirratja patata-patatarringkula-wanarnu. ");
INSERT INTO ntj_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Palunyatjanu-ya pitjangu Tjawutjanya tjapiranytja. Nyangka-tjanampa mirrka wiirpa tjimarrikitjalu nintiranytja. Palunyalu tjimarri katirra tjunkulanytja puurrpa Piiruku yiwarlangka. ");
INSERT INTO ntj_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nyangka yarnangu pirnilurtu-ya mirrka tjimarringka mantjirayirnu-wanarnu tjimarri wiyarringu. Nyangka-ya Yiitjipunyamartatji pirnilu pitjangu Tjawutjala watjarnu, “Purtu-latju kulira tjimarri-lampatju wiyarrinyangka. Mirrka-lampatju kaantjamaaltu nintila mirrirritjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Nyangka Tjawutjalu-tjananya kuliralpi watjarnu, “Yuwa, tjimarri wiyarrinytjalu-yanku yanamulpa kati. Nyangka-tjanamparnanku ngaparrtjika mirrka wiirpa nintila.” ");
INSERT INTO ntj_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nyangka-ya mularrpartu mirrkakitjalu Tjawutjaku katirra nintiranytja-yanku purni pirni, tungki pirni, tjiipu pirni puru nanikuurrpa pirninya. Tjiinya kurli palunyangkartu-ya yanamulpa pirninyartu katingu nintirayirnu wiyarnu mirrkakitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nyangka kurli kutjupangka-ya puru pitjangu Tjawutjala watjarnu, “Wiya, puurr, mayuntjamaaltu-latju ngaanya tjukarurrulu watjalku. Tjimarri-lampatju wiyarringu. Puru-lampatju yanamulpa pirninyartu wiyarringu. Nyangkalta-latju mantangkakutju nyinarra. ");
INSERT INTO ntj_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mirrka wiirpa-lampatju nintila parltjatjirratja-latju mirrirritjakutarra. Puru-lampatju yurninypa nintila mantangka tjunkutjaku. Nyangkayi yukiri pakara-wanala, pirriyalu manta puultjingaltjakutarra. Nyangka-latju puurrpa Piiruku ngaparrtjika tjimarrimaaltu waarka tirtu palyanma. Nyangka manta-lampatju puurrpa Piiruku ngarama.” ");
INSERT INTO ntj_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nyangka tjiinya yayilurru purlkangkamarntu Tjawutjalu Yiitjipula yarla lipiwanalu manta mantjirnu puurrpa Piiruku. ");
INSERT INTO ntj_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Palunyalu yarnangu pirninyartu watjarnu tjimarrimaaltu-ya waarka palyaratjaku puurrpa Piiruku. ");
INSERT INTO ntj_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nyangka-yanku wati nyarra yapu miirl-miirlpa miranykanyilpayilukutju manta yungarra tirtu kanyiranytja, tjiinyamarntu-tjanampa puurrpa Piirulu mirrka tirtu nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nyangkalta Tjawutjalu yarnangu pirningka watjarnu, “Kulila-ya. Nyuntulu-yan puru nyuntuku-tjanampanku manta puurrpa Piiruku ngarala. Nyangka-tjanamparnanku yurninypa nintilku mantangka-yan tjawara tjunkulatjaku. ");
INSERT INTO ntj_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nyangka mirrka wiirpa pakalku yurnmirringkunyangka-yan yurraralpi tjarralku. Palunyalu-yan mirrka kutjupatjarra puurrpa Piiruku nintilku. Palunyalu-yankun kutjupatjarranya kanyinma tjiinya mantangka tjunkukitjalu puru-yan yungarrapirtilu ngalkulatjaku.” ");
INSERT INTO ntj_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nyangka-ya yarnangu pirnilu Tjawutjala watjarnu, “Yuwa puurr, nyuntulu-lanyatjun wankarunu mirrirritjakutarra. Nyangka-latju puurrpa Piiruku waarka tirtu nyinarra palyanma.” ");
INSERT INTO ntj_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nyangka Tjawutjalu tjukurrpa ngaapirinypa walkatjunu. Tjiinya kurli kutjupa kurli mirrka wiirpa yurnmirrinyangka-ya yarnangu pirnilu kutjupatjarra katirra nintinma puurrpa Piiruku. Nyangka-yanku wati nyarra yapu miirl-miirlpa miranykanyilpayilukutju manta yungarralu kanyinma. Nyangka-ya mularrpartu palunyapirinypa tirtu palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nyangka Tjayikapanya tjiinya yini kutjupa Yitjurayilnga puru palunyaku yungarrapirti Kutjurntawana rawa nyinarrayirnu, nyangka-tjanampa tjamu kaparlipirti-ya minga-mingarringu. Puru-tjanampa tjimarri purlkarringu puru puluka, tjiipu puru nanikuurrpatarra-ya pirnirringu. ");
INSERT INTO ntj_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nyangka Tjayikapanya ngurra palunyangka nyinarrayirnu nyangka kurli 17-tjanu-ra kurli 147-pa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Palunyalu mirrirrikitjalu wati kutju witurnu yankula palunyaku katja Tjawutjanya yarltirra katitjaku. Nyangka yarltirra katingu. Nyangka-lu watjarnu, “Yuwa katja, wiyarringkunyangka-rni ngurra ngaangka tjurnutjunkutjamaaltu kati tjarrpatjurra pulpa nyarra ngayuku mama puru ngayuku tjamu-pula mirri ngarrirra, palunyangka. Palunyalu-munta-rnin kalkulku Mama Kuurrta mirangka-rni nyarratja makatirra tjarrpatjunkukitjalu?” Nyangka Tjawutjalu kuliralpi watjarnu, “Yuwa, palya-rna makatiku tjunku.” ");
INSERT INTO ntj_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nyangka Tjayikapalu watjarnu, “Mama Kuurrta mirangka-munta-rnin kalkulku palyalkitjalu?” Nyangka Tjawutjalu-lu watjarnu, “Yuwa, Mama Kuurrta mirangka-rnanta kalkura.” Nyangka palunyaku mamalu kuliralpi kata pupakatingu. Palunyalu Mama Kuurrnga piirrngurulu marninypungu. ");
INSERT INTO ntj_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nyangka Tjawutjanya marlaku yanu ngurrangka nyinarranytja. Nyangka kutjupalu pitjangu watjarnu tjiinya palunyaku-ra mama pika purlkanya ngarrirranyangka. Nyangka kuliralpi yarltingunku katja kutjarranya, Manatjanya-pulanya Yipurayimanya. Nyangka-ya yanu nyakukitja. ");
INSERT INTO ntj_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nyangka Tjawutjanya waalkarrara pitjanyangka kutjupalu tjarrparralpi Tjayikapala watjarnu, “Nyuntuku katja Tjawutjanyanta pitjangu nyakukitja.” Nyangka kuliralpi purrkara witurringkula pakarnu piirrpangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Palunyalu Tjawutjala watjarnu, “Yuwa katja, kulila. Mama Kuurrnga tjiinya Yayirninytjulu Palyalpayinya kutjulpirtu-rni yutirringu ngurra Kayinanta yiwarla yini Latjala. Palunyalu-rni watjarnu walykumunura kanyilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Tjiinya-rni ngaapirinypa kalkuralpi watjarnu, ‘Miranykanyira-rnanta kanyilku. Nyangkanku-ya nyuntuku tjamu kaparlipirti minga-mingarriku. Nyangka-rna ngurra ngaanya nintilku nyuntuku tjamupirtiku, tjiinyanyka-yayi marlangkatja-marlangkatja pakaralpi palunyangka nyinama.’” ");
INSERT INTO ntj_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nyangka Tjayikapalu ngaapirinypa mawatjara-wanarnu, “Yuwa katja, ngayuku tjamu kutjarra Yipurayimanya-pula Manatjanya ngurra ngaa Yiitjipula ngaarnmanu, ngurra kutjupangka-rna nyinarranyangka. Palunyanya-pulanyarna katjarnmanku. Nyangka-pula mama pirnipirinypa nyinama, nyarra Rupannga-pula Tjimiyannga nyinarra, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nyangka-tjingurun ngula katja marlangkatja pirni puru kanyilku, palunyanya-ya tjiinya ngayuku tjamu nyinama. Tjiinya-tjananyarna nyuntuku katja marlangkatjanya katjarnmankukitjamunu. Nyangka-ya ngula nyuntuku tjamupirti ngurra Kayinanta tjarrpaku nyinarranyangka, nyuntuku katja marlangkatja pirninya-ya ngurra palunyangka nyinama palunyaku-tjanampa kurta Yipurayimala puru Manatjalawana. ");
INSERT INTO ntj_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tjiinya-pulanyarna katjarnmara palunyaku kaparli Rayirrtjultanguru. Tjiinya-lan nyuntuku kamuruku ngurra wantirra Kayinantawana pitjalayintja. Nyangka-rna tjuni kartakatirralpi nyuntuku ngunytju yiwarrangka yitingka tjurnutjunu, yiwarra nyarra warli Puratjaku ma-ngarrirra, palunyangka. Tjiinya nyuntuku ngunytju tjinguru wanka nyinarranytjalu katja kutjupanya puru kanyinma. Ngaanya wiyarringkunyangka-pulanyarna nyuntuku katja kutjarra katjarnmanku kanyinma.” Palunyapirinypa Tjayikapalu watjarnu. Tjiinya-ya kuwarrinya Puratjanya yini Pitjiliyamanya watjara. ");
INSERT INTO ntj_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Nyangka tjiinya Tjayikapalu kuru pawulytju purtu nyakulanytja, yirnalutjaru. Palunyalu-pulanya Tjawutjaku katja kutjarra purtu ngurrkarntaralpi tjapirnu, “Ngananya-pula palanya?” Nyangka Tjawutjalu-lu watjarnu, “Wiya, nyuntuku tjamu kutjarra-pula ngaanya. Tjiinya Mama Kuurrtu-rni nintirnu ngurra ngaa Yiitjipula, palunyanya-pula.” Nyangka Tjayikapalu kuliralpi watjarnu, “Kati-pulanya ngamu nyinatjurra. Nyangka-pulamparnayi Mama Kuurrnga tjapila, tjiinya-pulanya walykumunura kanyiratjaku.” Nyangka mularrpartu Tjawutjalu-pulanya katingu nyinatjunu. Nyangka-pulanya yampuralpi nyunytjurnu. ");
INSERT INTO ntj_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Palunyalu Tjawutjanya-lu watjarnu, “Rawalu-rnanta kuliranytja mirrirringulkanyun. Tjiinya-rna kuliranytja ngula-rnanta puru nyakukitjamunulu. Ngaanya-rni Mama Kuurrtu rawalu wanka kanyiranytja nyakutjaku-rnanta puru nyuntuku tjilkutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nyangka Tjawutjalu-pulanya watjarnu, “Pakala-pula.” Nyangka-pula yampunguru pakannyangka pupakatingu mamangka. ");
INSERT INTO ntj_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","14","Nyangka Tjawutjalu katja tirna katingu nyinatjunu tjamu wakunguru palunyalu marlanypa tjampunguru nyinatjunu. Tjiinya-tjanampa yara ngaapirinypa ngaralanytja tjiinya mara wakulu kurta pampultjaku puru mara tjampulu marlanypa pampultjaku. Parturtu Tjayikapalu kulirnu tjamu marlangkatjanya mara wakulu pampulkitjalu. Palunyalu mara wakulu pampurnu marlanypa Yipurayimaku kata. Palunyalu mara tjampulu pampurnu kurta Manatjaku kata. ");
INSERT INTO ntj_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Palunyalu Tjawutjaku-ra walykumunu watjaralpi ngaapirinypa Mama Kuurrnga tjapirnu, “Yuwa, Mama Kuurr, ngayuku tjamu Yayipuramalu puru ngayuku mama Yayitjikilu-pula nyuntunya pupakatirra marninypungkupayi. Tjiinya nyuntulu-rnin tirtu kanyira katirrayintja. Nyangka-rni nyuntuku yayintjultu tirtu miranykanyira katirrayintja kutjupa-kutjupa palyamunungkatarra. Nyangka-rnanta tjapira ngayuku tjamu kutjarra-pulanya walykumunura tirtu kanyiratjaku. Nyangka-pulanyayayi yarnangu pirnilu ngula nyakula ngaapirinypa kulinma, ‘Munta yuwa, Mama Kuurrtu-pulanya walykumunura kanyira, tjiinya-tjananya Yayipuramanya, Yayitjikinya puru Tjayikapanya kanyiranytja, palunyapirinypa.’ Yuwa Mama Kuurr, tjilku pirni-pulampa nintila, puru tjamutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nyangka Tjawutjalu nyangu palunyaku mamalu mara wakulu Yipurayimaku kata pampunnyangka walykurringu. Palunyalunku mamaku mara mantjiralpi Manatjaku katangka tjunu. ");
INSERT INTO ntj_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Palunyalu watjarnu, “Wiya Mama, yarlakun pampurnu. Ngaanya Manatjanya kurranyungkatja. Nyangka mara wakulu palunyaku kata pampula.” ");
INSERT INTO ntj_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nyangka Tjayikapalu watjarnu, “Wiya katja, nintilu-rna ngaanya kulira pampura. Tjiinya Manatjaku tjamupirti-ya pirnirriku. Nyangka palunyaku marlanypa Yipurayimaku-ra wayirntaralpi minga-mingarringku.” ");
INSERT INTO ntj_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nyangka Tjayikapalu-pulampa puru walykumunu watjarnu ngaapirinypa, “Yuwa, ngula Yitjurayilku tjamupirtilu-yanku ngaparrku-ngaparrkulu Mama Kuurrnga tjapiranytjalu ngaapirinymara watjanma, ‘Yuwa, Mama Kuurrtunta walykumunura kanyinma nyarra Yipurayimanya-pulanya Manatjanya kanyiranytja, palunyapirinypa.’” Tjiinya Tjayikapalu Yipurayimaku yini kurranyulu watjarnu. Palunyalu Manatjaku yini marla watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Palunyalu Tjawutjanya watjarnu, “Yuwa, kuwarrinya-rnin nyakula tjiinya-rna wiyarrikitja ngarrirranyangka. Nyangka-rna wiyarringkunyangka Mama Kuurrtunta kanyinma. Palunyalunta marlakulu katiku nyuntuku tjamupirtiku ngurrarakutu. ");
INSERT INTO ntj_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nyangka-rnanta kuwarrinya kalkura tjiinya nyuntuku tjamupirtikutju-ya nyinarratjaku ngurra yini Tjikimala, tjiinyamarntu manta walykumunu ngaralanyangka. Tjiinya-rna kutjulpirtulpi Yayimuku tjamupirti wakarayirnu mirrirntanu ngurra palunyangka-ya nyinarranyangka. Nyangka nyuntuku kurta pirniku tjamupirti-ya ngurra palunyangka nyinakitjamunu. Tjiinya nyuntuku tjamupirtikutju-ya palunyangka nyinama.” ");
INSERT INTO ntj_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nyangka Tjayikapalu wati kutju witurnu palunyaku katjapirti-tjananya yarltirra katitjaku. Nyangka mularrpartu yanu katinyangka-tjananya watjarnu, “Yuwa, ngamurringkula-ya pitja nyinakati. Nyangka-tjananyarnanta watjala yartakarra kutjupa-kutjupa-tjanampanku ngula ngaratjaku. ");
INSERT INTO ntj_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yuwa katja pirni, kapurturri-rniya kulila mamalu-tjananyarnanta watjaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","28","Nyangka-tjananya katja pirningka kutju-kutju watjara yutiranytja kutjupa-kutjupa-tjanampa ngula ngaratjaku. Palunyapirinypa Tjayikapalu watjara-wanarnu wiyarnu palunyaku katja 12-ku-tjanampa. Nyangka-ya kutju-kutjulu kuliranytja, “Munta yuwa, palunyapirinypa ngula ngaraku ngayuku tjamu kaparlipirtiku-tjanampa.” ");
INSERT INTO ntj_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","32","Nyangka Tjayikapalu-tjananya palunyaku katja pirningka watjarnu, “Yuwa, kuwarri-kuwarrirtu-rna wiyarriku. Nyangka-rniya makati tjarrpatjurra pulpa yini Makapala ngurra yini Mamurayila kakarrara. Tjiinya kutjulpirtulpi ngayuku tjamu Yayipuramalu manta palunyanya pulpatjarra payipungu wantingu wati yini Yiipuranta tjiinya Yatjaku wartangkatja. Tjiinya pulpa palunyangka-lampa yungarrapirti ngarrirra, tjiinya ngayuku tjamu Yayipuramanya-pula ngayuku kaparli Tjiiranya puru ngayuku mama Yayitjikinya-pula ngunytju Ripakanya. Nyangka-rna ngayuku kurri Liyanya pulpa palunyangkartu tjarrpatjunu. Nyangka-rniya Kayinantakutu makati pulpa palunyangkartu tjarrpatjurra.” ");
INSERT INTO ntj_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nyangka Tjayikapanya katja pirningka wangkarrayirnu wiyarringkulalpi marlaku ngarrikatirralpi wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nyangka Tjawutjalunku mama yulalu-yulalu pupakatingu yampuralpi nyunytjurnu. ");
INSERT INTO ntj_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Palunyalu watjarnu palunyaku waarka palyalpayi pirnilu-ya mirri Tjayikapanya parnti walykumunungka nyirtiltjaku. ");
INSERT INTO ntj_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Nyangka-ya mularrpartu tjirntu kutjupa tjirntu palyarayirnu kirnara kutjarratjanu wiyarringu. Tjiinya-ya palunyapirinypa tirtu palyalpayi. Nyangka-raya Yiitjipunyamartatji pirninyartu tjirntu kutjupa tjirntu yularranytja. Palunyalu-ya kirnara marnkurrtjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nyangka Tjawutjalu puurrpa Piiruku yamatji pirningka watjarnu, “Tjapilku-munta-tjananyarnanta?” Nyangka-ya watjarnu, “Yuwa, tjapila.” Nyangka-tjananya watjarnu, “Yanku-munta-yan puurrpa Piirunya ngaapirinypa tjapilku, ");
INSERT INTO ntj_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ngayuku mamalu-rni wiyarrikitjalu watjarnu, “Mirri-rniyanyu makati tjarrpatjurra pulpangka, ngurra nyarra Kayinanta.” Nyangka palya-munta-rna yanku tjarrpatjunkula marlaku pitjaku?’” Nyangka-ya mularrpartu yanu palunyapirinypa watjarnu. ");
INSERT INTO ntj_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nyangka puurrpa Piirulu kuliralpi-tjananya witurnu mapitjala-ya Tjawutjanya ngaapirinypa watjaltjaku, “Yuwa, palyan yanku nyuntuku mama mirri makatiku pulpa palunyangka tjarrpatjunku.” ");
INSERT INTO ntj_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Nyangka-ya mularrpartu Tjawutjalu, palunyaku kurtapirtilu puru yungarrapirti pirnilurtu mirri makatingu. Nyangka minyma ngunytju tjilku kurlunytjarrakutju-ya marlartarringu nyinarranytja ngurra Kutjurnta. Nyangka-ya waarka palyalpayi kutjupatjarralu yanamulpa pirninya marlartalu kanyiranytja. Nyangka-ya yarnangu pirni Tjawutjaku yungarrapirtingka lurrtjurringkula yanu, tjiinya puurrpa Piiruku yamatji pirni, Yiitjipunyamartatji wati purlkanya pirni, warrmarla pirni purni kaarrtjarra puru wati purnitjarra pirni. ");
INSERT INTO ntj_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pitjalayirnu-ya kapi Tjuutanta ngamurringkulalpi nyangu ngurra yini Yatarrnga ngaralanyangka, tjiinya-ya yurninypa yararrapungkupayi, palunyanya. Tjiinya ngurra palunyanya kapi Tjuutanta kakarrara ngarala. Nyangka-ya ngurra tjunkulalpi nyinarra yularrayirnu-yularrayirnu wiiki kutjutjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Nyangka-tjananya yarnangu Kayinanngamartatji pirnilu-ya nyakula watjaranytja, “Ngarltutjarra-ya pirni, tjirturu-tjirturu purlkanya-ya yularra.” Nyangka palunyangurulta-ya ngurra palunyanya tjapirnu yini Yayipul-Mitjurayinya. Tjiinya Yayipul-Mitjurayinya wangka ngaapirinypa, Yiitjipunyamartatji-ya Yularranytjanya. ");
INSERT INTO ntj_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Palunyangurulta-ya Tjayikapaku katja pirnilu pakara mama mirri katingu pulpa yini Makapalakutu ngurra yini Mamurayila kakarrara. Tjiinya kutjulpirtulpi Yayipuramalu manta palunyanya pulpatjarra payipungu wati yini Yiipuranta tjiinya Yatjaku wartangkatja. Nyangka pulpa palunyangkalta-yanku mama mirri tjarrpatjunu. Tjiinya palunyaku mamalu watjarnu wantinyangka-ya katingu palunyangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Rapitjingka-ya ngarangu wiyarringkulalpi Tjawutjanya, palunyaku kurta pirninya, puru yarnangu kutjupatjarranyatarrartu marlaku yanu Yiitjipuku. ");
INSERT INTO ntj_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nyangka palunyaku mama mirrirringkunyangka-ya Tjawutjaku kurtapirtilu kulira watjaranytja, “Wiya, Tjawutjanya-tjinguru-lampa kurrupuru mirrparnpa tirtu nyinarra. Tjiinyamarntu-lan ngarltumaaltu kutjupa-kutjupa palyaranytja. Nyangka-tjinguru kulira ngaparrtjika-lanya pika purlkanya pungkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Nyangka-ya wati kutju witurnu yankula Tjawutjala ngaapirinypa watjaltjaku, “Tjiinya Mamalu-lanyatju wankalulpi watjarnu ngaapirinypa-latjunta watjaltjaku, ‘Kutjulpirtu-latjunta tjimarrikitjalu maliki pirniku nintirnu. Nyangka-lampatju kalyparriwa. Tjiinyamarntu Mama Kuurrnga-lampa kutjumama nyinarra. Nyangka-lan pirnilurtu pupakatirra marninypungkupayi, tjiinya Mamalu pupakatirra marninypungkulanytja, palunyapirinypa.’” Nyangka mularrpartu mapitjangu watjannyangka Tjawutjalu kuliralpi yulangu. ");
INSERT INTO ntj_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nyangkalta-ya palunyaku kurta pirninya pitjangu-luya pupakatingu. Palunyalu-ya watjarnu, “Yuwa puurr, ngaanguru-latju nyuntuku waarka tirtu palyanma, tjimarri kulintjamaaltu.” ");
INSERT INTO ntj_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Nyangka Tjawutjalu-tjananya watjarnu, “Wiya, ngurlumaaltu-ya kulinma. Kamu-tjananyarnanta ngayulu ngaparrtjika pungku. Ngarna Mama Kuurrtu ngaparrtjika pungku. Pumpa-kulila wati-rna nyuntunyapirinypartu-tjananyarnanta. ");
INSERT INTO ntj_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wiya, palyartu-rniyan kutjulpirtu tjumaranytja pungkula mirrirntankukitjalu. Nyangka Mama Kuurrtu kutjupanu walykumunu ngaratjaku. Tjiinya nintilu kuliranytja yarnangu pirninya wankara kanyilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nyangka-ya ngurlurringkutjamaalpa nyinama. Tjiinya ngayulu-tjananyarnanta mirrkangkara kanyinma, puru nyuntuku yungarrapirtitarrartu.” Nyangka-ya palunyaku kurtapirtilu kuliralpi kurrurnpa raparringu. ");
INSERT INTO ntj_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nyangka Tjawutjanya puru palunyaku yungarrapirti-ya tirtu nyinarranytja Yiitjipula. Nyangka Tjawutjanya nyinarrayirnu kurli-ra 110-pa ngaralanyangka mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tjiinya nyinarrayirnu wankalurtu nyangu palunyaku katja Yipurayimaku tjilku pirni puru tjamu kaparli nyinarranyangka. Puru nyangu palunyaku katja Manatjaku tjamu kaparli nyinarranyangka. Tjiinya palunyaku-tjanampa mama yini Makirrnga. ");
INSERT INTO ntj_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nyangka Tjawutjalunku kurta pirningka watjarnu, “Yuwa, wiyarrikitja-rna ngarrirra. Nyangka-tjananyanta Mama Kuurrtu yirringkanama. Palunyalu-tjananyanta ngurra ngaanguru pakaltjingara makatiku, ngurra nyarra Mama Kuurrtu Yayipuramanya, Yayitjikinya puru Tjayikapanya kalkurnu wantitjalakutu. ");
INSERT INTO ntj_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nyangka-rniya kalkula wanti. Tjiinya ngula Mama Kuurrtu-tjananyanta makatinyangka ngayuku tarrka-yan mantjira makatiku.” Nyangka mularrpartu-luya kalkurnu palunyapirinypa palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nyangka Tjawutjanya mirrirringu Yiitjipula, tjiinya-ra kurli 110-pa ngaralanyangka. Nyangka-ya parnti walykumunungka nyirtiralpi warntungka karrpirnu. Palunyalu-ya puukangka tjarrpatjunu wantingu. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","4","Yuwa, wati yini Yitjurayilnga tjiinya yini kutjupanya Tjayikapanya ngurra nyarra Yiitjipulakutu yanu palunyaku katja pirnitjarra. Tjiinya katja yini ngaanya-ya: Rupannga, Tjimiyannga, Liipayinya, Tjuutanya, Yitjakanya, Tjipulannga, Pintjimannga, Taannga, Natjalinya, Kaarrnga, puru Yatjanya. Tjiinya-ya kurrirarra-kurrirarra kutipitjangu katja yurntalpirtitjarra. ");
INSERT INTO ntj_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yanu-ya marlanypa Tjawutjala lurrtjurringu nyinarranytja tjiinyamarntu ngarnmanyarringu Yiitjipula nyinarranyangka. Tjiinya-ya Tjayikapaku wartangkatja pirni yarnangu 70 nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Nyinarrayirnu-ya nyalparringkulalpi mirrirringu, Tjawutjanya puru palunyaku kurtapirtitarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nyangka-ya Yitjurayilku tjamupirti marlangkatja-marlangkatja paka-pakaralpi pirnirringkula-wanarnu ngurra Yiitjipula lipiwanartu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nyangkalta puurrpa purlkanya kutjupa puurrarringu nyinarranytja. Tjiinya tjukurrpa Tjawutjanyatjarra kulintjamaalpa ngurrpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Palunyalu palunyaku yarnangu ngulytju pirningka-tjananya watjarnu, “Nyawa. Ngaanya-kulila Yitjurayilku tjamupirti-ya pirnirringu. Ngayunya-kulila-lanyaya wayirntaralpi minga-minga nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tjiinya-tjinguru-ya ngurra kutjupanguru warrmarlara pitjaku. Nyangka Yitjurayilku tjamupirtilu-tjinguru-tjananya lurrtjurringkulalpi pika-lanya pungku. Palunyalu-ya waarka wantirra kukurraalku ngurra kutjupakutu. Palunyakutarra-la kurrala tjiinya puru pirnirritjakutarra-ya.” ");
INSERT INTO ntj_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nyangka-ya wangkarra kuliralpi watjarnu wantingu wati kutjupatjarralu-ya Yitjurayilku tjamupirti-tjananya pawurntjingara witu-wituratjaku. Nyangka-tjananyaya mularrpartu witu-witura nintiranytja waarka purlkanya-ya palyaratjaku. Nyangka-ya yiwarla purlkanya kutjarra yini Pitjamanya puru Ramatjinya kutjurntara palyarayirnu wiyarnu tjiinya mirrka purlkanya, kutjupa-kutjupatarrartu tjunkulatjaku. Nyangka-ya mularrpartu mirrka purlkanya tjunkulanytja yarnangu pirnilu-ya pitjala payipungkulatjaku. ");
INSERT INTO ntj_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tjiinya-tjananyaya ngarltumaaltu Yitjurayilku tjamupirti witu-witura nintiranytja waarka purlkanya-ya palyaratjaku. Nyangka-ya putakurtu tjilku pirnitjarrarringkula-wanarayintja. Palunyalu-ya ngurra lipiwana nyinarranytja. Nyangka-tjananyaya Yiitjipunya ngurraralu nyakula ngurlurringkulanytja. ");
INSERT INTO ntj_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Palunyalu-tjananya ngarltumaaltu witu-witura nintiranytja waarka purlkanya-ya palyaratjaku. Nyangka-ya yaputjarralu yiwarla palyaranytja. Nyangka-ya kutjupatjarralu kaatanpa palyaranytja. Palyarayirnu-ya kaarr-kaarrarringu. Tjiinyamarntu-ya kutjurntara nyinarranytjamunu. ");
INSERT INTO ntj_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nyangka puurrpa purlkanya Yiitjipunyamartatjilu minyma kutjarra-pulanya yarltingu pitjala-pula kuliltjaku. Minyma palunyalu-pula minyma Yiipuru pirninya-tjananya yankula yirringkara kanyilpayi tjilku ngarrikitjangka. Tjiinya-pula yini Tjipuranya puru Puwanya. Pitjanyangka-pulanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Tjiinya-pulan yanku yirringkanku minyma Yiipurulu tjilku kanyiltjaku. Palunyalu-pula tjilku minarli nyakulalpi puwa mirrirntarra. Nyangka kungka ngarrinyangka wanka wanti.” ");
INSERT INTO ntj_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Parturtu-pula puurrku wangka kulirnu wantirralpi minarli-tjananya nyakula wanka kanyiranytja. Tjiinyamarntu-pula Mama Kuurrnga kulilpayi. ");
INSERT INTO ntj_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Nyangka puurrpa palunyalu minyma kutjarra-pulanya puru yarltirralpi watjarnu, “Nyaaku-pulan tungun-tunguntu minarli pirninya kanyira pungkunytjamaaltu?” ");
INSERT INTO ntj_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Nyangka-pula watjarnu, “Wiya, tjiinya minyma Yiipuruku tjilku-ya wangarnarra ngarripayi nyuntuku-tjanampanku tjilkupirinymaalpa. Tjiinya-litju kuliralpi yankupayi. Palunyalu-litju marlarringkulalpi nyaku wartalpitjanu tjilku ngarrinyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Nyangka Mama Kuurrnga-pulampa pukurlarringu tjiinyamarntu-pula palunyanya kuliranyangka. Palunyalu-pulanya walykumunura kanyiranytja. Nyangka palunyalutarrartu-pula tjilku yungarralu kanyiranytja. Nyangka Yitjurayilku tjamupirti-ya tirtu pirnirringkulayintja. ");
INSERT INTO ntj_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Nyangka puurrpa Piirunya nyinarrayirnu palunyalulta palunyaku yarnangu ngulytju pirningka watjarnu, “Kulila-ya. Tjilku minarli Yiipuru ngarrinyangka tjulyaralpi makati kapi yirralangka warni tjarrpatjurra. Nyangka-yayi kungkakutju wanka nyinama.” Nyangka-ya mularrpartu tjilku minarli tjulyara kapingka warnirra tjarrpatjuranytja. ");
INSERT INTO ntj_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Nyangka palunyatjarralpi wati kutju Liipayiku wartangkatjalu kurri yarltingu. Kungka palunyanyatarrartu Liipayiku wartangkatja nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Palunyalu nyinangu tjilku katja kanyirnu. Palunyalu nyakulalpi watjarnu, “Wiya, tjilku ngaanya walyku-walykumunu.” Palunyalunku kumpitjura kanyirayirnu kirnara marnkurrtjanulu ");
INSERT INTO ntj_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","purtu kuliranytja, “Yaaltji-yaaltjilu-rna kumpitjura kanyinma?” Wantingu kulirnu kutjupa-kutjupa palyalkitjalu. Palunyalu tjanpi kartarntaralpi tiirrtjipirinypa palyarnu. Palunyalu parrakirtitjurayirnu yarla pirninya yangatjunu. Palunyalu tjilku yirti yampuralpi tjarrpatjunu. Palunyalu liirrpa pupatjunu wantingu. Palunyalu kapi yirrala yini Nayilta tjunu wantingu yukiri wirrmira ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nyangka tjilku palunyaku tjurtulu tiwa-tiwanguru ngarala nyakulanytja, “Marlanypa-tju ngarriku yaaltjirriku?” ");
INSERT INTO ntj_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ngarangu-ngarangu nyangu puurrpa Piiruku yurntalpa pitjangu kapingka tjarrparra parltjilkitja. Nyangka-ya kungka waarka palyalpayi pirninyatarrartu pitjangu kapi kantilyngurulu miranykanyiranytja. Nyangka puurrku yurntaltu nyangu tiirrtjipirinynga yukiriwana ngarrirranyangka. Nyakulalpi watjarnu mantjira katitjaku. Nyangka mularrpartu mantjira katingu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Nyangka yarlaralpi nyangu tjilku minarli kurlunypa ngarrirranyangka. Nyangka yularranyangka ngarlturringu watjarnu, “Wiya, tjilku ngaanya minyma Yiipuruku.” ");
INSERT INTO ntj_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nyangka palunyaku tjurtulu waalkarraralpi watjarnu, “Yanku-munta-rna minyma Yiipuru yarltirra katiku nyangkanku tjilku kanyilku mimi nintilku purlkalku?” ");
INSERT INTO ntj_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nyangka watjarnu, “Yuwa, mapitja yarltirra kati.” Nyangka mularrpartu yanunku ngunytju yungarra yarltirra katingu. ");
INSERT INTO ntj_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nyangka puurrpa Piiruku yurntaltu watjarnu, “Yampura-tju makati mimi nintira kanyinma. Nyangka-rnanta payipungama.” Nyangka mularrpartu ngunytju yungarralu yampura katingu ngurrangka kanyira mimi nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nyangka tjilku palunyaku-ra kurli marnkurrpa ngaralanyangka palunyaku ngunytjulu marlakulu katingu nintirnu puurrpa Piiruku yurntalku. Nyangka nyuyupungu kanyiranytja. Palunyalu yini Mawutjanya tjapirnu. Tjiinya kulirnu, “Kapi yirralangkatja-rna mantjirnu. Nyangka-ra yini Mawutjanya ngarama.” ");
INSERT INTO ntj_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Nyangka Mawutjanya nyinarrayirnu wati purlkarringu. Palunyalu nyinarrayirnu ngulartu pakara mapitjangu palunyaku yungarrapirti Yiipuru pirninya nyakukitja. Mapitjalayirnu nyangu puurrpa pirnilu-tjananyaya pungkula kanyiranytja waarka purlkanya palyaranyangka. Nyangka puru nyangu wati Yiitjipunyamartatjilu palunyaku-ra yungarra kutju pungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nyangka wantirralpi purtu lipirntara parranyangu. Palunyalu wati Yiitjipunyamartatjinya pungu mirrirntaralpi talingka tjawarnu tjurnutjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ngarringu tjirnturringkula puru mapitjangu nyangu wati Yiipuru kutjarralu-pulanku pika pungkulanyangka. Palunyalu wati nyarra kunpu-kunpu pika-pikaranytja, palunyangka watjarnu, “Nyaakunkun wati yungarra pungkula?” ");
INSERT INTO ntj_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Nyangka watjarnu, “Puurrpa-muntan pitjangu tjukarurrura-linyatjun kanyilkitja? Ngayunyatarrartu-munta-rnin mirri pungkukitja tjiinyan wati Yiitjipunyamartatjinya mungarrtjilpi pungu mirrirntanu, palunyapirinypa?” Nyangka Mawutjalu ngurlurringkulalpi kulirnu, “Wiya, kutjupalu-tjinguru-rni nyakulalpi tjakultjunu.” ");
INSERT INTO ntj_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Nyangka puurrpa Piirulu kulirnu Mawutjalu wati kutju pungu mirrirntankunyangka. Palunyalu watjarnu ngaparrtjika-ya pungkula mirrirntankutjaku. Nyangka wangka kutju kulira ngurlu kukurraarnu ngurra yini Mitiyantakutu. Pitjalayirnu kapi wiilta nyinakatingu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nyangka ngurra nyarra Mitiyanta wati kutju yini Tjatjarunya nyinarranytja yurntalpa 7-tjarra. Wati palunyalu kuka pungkula tilira tjunkula Mama Kuurrku nintilpayi. Nyangka kungka palunyanya-ya kapi wiilkutu pitjangu kapi tjutira yungkukitja-tjanampa palunyaku mamaku tjiipu nanikuurrkutarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nyangka-ya wati tjiinya tjiipu kutjupatjarranya miranykanyilpayinya waalkarrara pitjangu. Palunyalu-ya kungka pirninya-tjananya payirnu wiyarnu. Nyangka-parturtu Mawutjalu pakaralpi marrkurnu-tjananya kanyiranytja. Palunyalu-tjanampa kapi tjutirnu kungkaku tjiipu nanikuurrkutarrartu yungu. Nyangka-ya tjikirnu wiyarrinyangka-ya ngurraku yanu. ");
INSERT INTO ntj_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Nyangka palunyaku mamalu nyakulalpi watjarnu, “Rawamunu-yan mapitjangu. Nyaatjanu-yan waarrpungkula marlaku pitjangu?” ");
INSERT INTO ntj_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nyangka-ya watjarnu, “Wiya, wati Yiitjipunyamartatjilu-lanyatju yirringkanu. Palunyalu wati tjiipu miranykanyilpayi-tjananya payirnu. Puru kapitarrartu tjutirnu tjiipu nanikuurrku yungu.” ");
INSERT INTO ntj_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Nyangka palunyaku mamalu watjarnu, “Wati palunyanya wanytjatjarringu? Nyaatjanu-yan wantirra pitjangu? Mapitja-ya yarltirra kati pitjala mirrka ngalkutjaku.” Nyangka-ya mularrpartu mapitjalayirnu yarltirra katingu. Nyangkalta-ya lurrtjurringkulalpi mirrka ngalangu. ");
INSERT INTO ntj_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nyangka Tjatjarulu watjarnu Mawutjanya nyinarratjaku. Nyangka yuwarnmaralpi nyinarranytja-tjananya. Nyangka Tjatjarulunku yurntalpa yini Tjipuranya nintirnu. Nyangka-pula yarltingu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nyangka Tjipuralu nyinarrayirnu tjilkunku katja yampurnu. Nyangka Mawutjalu yini Kutjamanya tjapirnu. Palunyalu watjarnu, “Ngayulu-rna ngurra ngaangka maliki nyinarra.” Tjiinya yini Kutjamanya wangka ngaapirinypa, Malikinya. ");
INSERT INTO ntj_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","24","Nyangka puurrpa purlkanya nyarra Yiitjipula nyinapayinya nyinarrayirnu mirrirringu. Nyangka-ya Yitjurayilku tjamupirtilu tirtu yularra waarka purlkanya palyaranytja ngarltumaaltu-tjananya pawurntjingara witu-wituranyangka. Yulatjarralu-ya watjaranytja, “Nganalu-lanyatju pitjaku yirringkanku?” Nyangka Mama Kuurrtu kulirnu yularranyangka-ya. Palunyalu kulirnu kutjulpirtu kalkurnu wantinytjalu. Tjiinya Mama Kuurrtu Yayipuramanya, Yayitjikinya puru Tjayikapanya kalkurnu palunyaku tjamupirti-tjananya tirtu walykumunura kanyilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Palunyalu-tjananya nyangu waarka purlkanya-ya palyaranyangka. Palunyalu ngarlturringu-tjanampa. ");
INSERT INTO ntj_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Nyangka Mawutjaku waputju yini Tjatjarunya ngurra Mitiyanta nyinarranytja. Nyangka Mawutjalu-ra tjiipu nanikuurrpa pirni miranykanyiranytja. Palunyatjanu yukiriku ngurriranytjalu mayu-mayuwanalu tiwa katirrayirnu parrapitjangu Mama Kuurrku yapu miirl-miirlkutu tjiinya yapu yini Tjayinayilakutu. ");
INSERT INTO ntj_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nyangka Mama Kuurrku yayintjulpa yartakarringu-lu wartangka tilingaralanytja. Nyangka Mawutjalu tjulurraaralpi nyangu, “Wiya, warta nyarranya-kulila tirtu ngarala kamparra. Mukirringkutjamaalpa tirtu-munta wanka ngarala?” ");
INSERT INTO ntj_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nyangka ngarala kuliranytja, “Nyaatjanu warta nyarranya kamparra mukirringkutjamaalpa tirtu ngarala? Mapitjaku-rna ngamuntirringkulalpi nyaku.” ");
INSERT INTO ntj_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nyangka Mama Kuurrtu nyangu ngamuntirrinyangka. Palunyalu wartangurulu tjapirnu, “Mawutja.” Nyangka watjarnu, “Yuwa, kulira-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nyangka Mama Kuurrtu watjarnu, “Ngamuntirrirra-kurlun pitjaku. Palangkartu ma-ngara. Palunyalunku tjina yarrala. Tjiinyan manta miirl-miirlta ngarala. ");
INSERT INTO ntj_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Kulila-rni. Ngayulu-rna Mama Kuurrnga tjiinya-rniya tjamupirti Yayipuramalu, Yayitjikilu puru Tjayikapalu pupakatirra marninypungkupayinya.” Nyangka Mawutjalunku mara kurungka yangatjunu tjiinyamarntu ngurlurringu Mama Kuurrnga nyakula mirrirritjakutarra. ");
INSERT INTO ntj_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Nyangka Mama Kuurrtu watjarnu, “Yuwa, nyakulanytja-tjananyarna ngayuku katja yurntalpirtilu-ya waarka purlkanya palyaranyangka ngurra nyarra Yiitjipula, tjiinya-tjananyaya ngarltumaaltu pawurntjingara witu-wituranyangka. Puru-rna kulirnu yularranyangka-ya puurrpa pirnilu-tjananyaya pungkula kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Palunyalu-rna pitjangu pakaltjingara-tjananya katikitja Yiitjipunyamartatjilu-ya tirtu pawurntjingara kanyiratjakutarra. Palunyalu-tjananyarna katiku ngurra walykumunukutu, kuka mirrka purlkakutu. Ngurra palunyanya lipi purlkanya ngarala. Nyangka kuwarrinya-ya yarnangu kutjupatjarra ngurra palunyangka nyinarra: tjiinya Kayinanku tjamupirti, Yatjaku tjamupirti, Yayimuku tjamupirti, Pirinyku tjamupirti, Yayipiku tjamupirti puru Tjipurrku tjamupirti. ");
INSERT INTO ntj_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yuwa, kulirnu-rna ngayuku katja yurntalpirti-ya yularranyangka. Puru-rna nyakula Yiitjipunyamartatjilu-tjananyaya ngarltuku ngurrpalu pungkula kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Yuwa, witulku-rnanta puurrpa Piirulakutu. Nyangkan mapitjaku ngayuku katja yurntalpirti-tjananya ngurra nyarra Yiitjipulanguru pakaltjingara katiku.” ");
INSERT INTO ntj_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Nyangka Mawutjalu watjarnu, “Wiya, ngayulu-kulila-rna wati purlkamunu. Tjinguru-rna mapitjaku puurrpa Piirunya purtu tjapilku Yitjurayilku tjamupirti walara katikitjalu.” ");
INSERT INTO ntj_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nyangka Mama Kuurrtu watjarnu, “Wiya, kawaku-lin yanku. Palunyalu-lin yarnangu pirninya yarltirra katirrayilku ngurra ngaa-lin ngarala wangkarra, palunyakutu. Nyangka-rniyan purli ngaangkartu pupakatirra marninypungama. Palunyalun nintilu kulilku ngayulu-rnanta mularrpa witunnyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Nyangka Mawutjalu watjarnu, “Tjinguru-rna mapitjaku Yitjurayilku tjamupirti-tjananyarna watjalku, ‘Mama Kuurrnga tjiinya ngayuku-lampa tjamupirtilu-ya pupakatirra marninypungkupayi, palunyalu-rni witurnu.’ Nyangka-tjinguru-rniya tjapilku, ‘Yini ngananya?’ Nyangka-rna nyaapirinypa watjalku?” ");
INSERT INTO ntj_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nyangka Mama Kuurrtu watjarnu, “Ngayulu-rna tirtu nyinapayinya. Nyangka mapitja-tjananya watjala. Ngayulu-rna tirtu nyinapayilu-rnanta witurnu. ");
INSERT INTO ntj_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","16","Watjala-tjananya tjiinya-rna Yaawayinya, tjiinya-rniya tjamupirtilu pupakatirra marninypungkupayinya, Yayipuramalu, Yayitjikilu puru Tjayikapalu. Nyangka-tju yini Yaawayinya tirtu ngaraku ngarama. Nyangka-rniya marlangkatja-marlangkatjalu yini palunyanya tirtu tjapinma. Yuwa, mapitja-tjananya Yitjurayilku tjamupirtiku liita pirninya yarlti kutjungkaralpi watjala tjiinya-rnanta yartakarringu wangkangu. Tjiinya-rna ngamuntirringu nyakula Yiitjipunyamartatjilu-tjananyaya ngarltumaaltu pungkula kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Palunyalu-rna kulira-tjananya ngurra Yiitjipulanguru pakaltjingara katikitjalu, tjiinya-tjananya ngarltumaaltu pungkula kanyiranyangka. Palunyalu-tjananyarna katiku ngurra walykumunukutu, mirrka kuka purlkakutu. Ngurra nyarra kutjupatjarra-ya nyinarra, palunyakutu, tjiinya-ya Kayinanku tjamupirti, Yatjaku tjamupirti, Yayimuku tjamupirti, Pirinyku tjamupirti, Yayipiku tjamupirti, Tjipurrku tjamupirti-ya kuwarrinya nyinarra, palunyalakutu-rna katiku.” ");
INSERT INTO ntj_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Nyangka Mama Kuurrtu tirtu watjaranytja, “Yuwa, liita pirnilu-ya nyuntuku wangka kulilku. Nyangka-yan lurrtjurringkula yanku puurrpa purlkanya Yiitjipula nyinapayilakutu. Palunyalun ngaapirinypa watjalku, ‘Yaawayinya, tjiinya Yiipuru pirnilu-latju pupakatirra marninypungkupayinya-lanyatju yartakarringu. Palya-munta-latju mayu-mayu mapitjalayilku ngurra kutjarratjanulu kuka pungkulalpi paalku nintilku puurrpa-lampatju Mama Kuurrku?’” ");
INSERT INTO ntj_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nyangka Mama Kuurrtu Mawutjala tirtu watjaranytja, “Yuwa, nintilu-rna kulira puurrpa Yiitjipula nyinapayinya. Tjiinya witu-witu tjukumunu. Kamu-tjananyanta witulku. Ngarna ngayulu-rna mara yarlalu kutjupa-kutjupa palyaranytjalu wuyurrpa kutjupankunyangka-tjananyanta witulku. ");
INSERT INTO ntj_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tjiinya-rna yayirninytjulu pika kutjupa-kutjupa yartakanku ngurra Yiitjipula. Nyangka-ya nyakulalpi ngurlurriku. Palunyangka puurrpa purlkanyalu-tjananyanta wuyurrarringkulalpi witulku. ");
INSERT INTO ntj_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Puru-tjananyarna yarnangu ngurrangkatja pirninya wuyurrmanku nyangka-tjanampankuya kutjupa-kutjupa walykumunu pirni wangarnarralu nintilku maralpa-yan yankutjakutarra. ");
INSERT INTO ntj_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tjiinya ngula-yan ngurra Yiitjipunya wantirra yankukitjalu minyma pirnilu-ya yanku-tjananya minyma ngurrarangkatja pirninya ngatjilku. Nyangka-ya warntu puru marangkatja lirringkatja kawurlpa tjilpatarrartu wangarnarralu nintilku. Nyangka-ya katja yurntalpirtingka-tjananya parratjunku wantinyangka-ya palunyatjarra yalatjarringkula yanku. Nyangka-ya Yiitjipunyamartatjinya maralarriku nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Nyangka Mawutjalu Mama Kuurrta watjarnu, “Wiya, tjinguru-rniya Yitjurayilku tjamupirti ngayuku wangkaku mula-mularrikitjamunu. Tjinguru-rniya watjalku, ‘Wiya, Mama Kuurrnganta nyuntula yartakarrinytjamunurtu.’ Palunyapirinypa watjannyangka-rna yaaltjinku?” ");
INSERT INTO ntj_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nyangka Mama Kuurrtu watjarnu, “Nyaapan marangka kanyira?” Nyangka watjarnu, “Wiya, wana-rna kanyira.” ");
INSERT INTO ntj_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Nyangka Mama Kuurrtu watjarnu, “Mantakutu warni.” Nyangka mularrpartu mantakutu warningu. Nyangka lirrurringu. Nyangka Mawutjanya ngurlu kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nyangka-lu watjarnu, “Wipu mantjila.” Nyangka mularrpartu wipu mantjinnyangka marlakurtu wanarringu. ");
INSERT INTO ntj_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Nyangka Mama Kuurrtu watjarnu, “Palunyapirinypan palyannyangka-ya nyaku mula-mularriku tjiinya-rna Mama Kuurrnga tjiinya Yayipuramalu, Yayitjikilu puru Tjayikapalu pupakatirra marninypungkupayinya. Palunyalu-rnanta nyuntula yartakarringu.” ");
INSERT INTO ntj_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Puru Mama Kuurrtu watjarnu, “Maranku pirlpirrta tjarrpatjurra.” Nyangka mularrpartu pirlpirrta tjarrpatjunu. Palunyalu yilaralpi nyangu purrtjutjarrarringu. ");
INSERT INTO ntj_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nyangka Mama Kuurrtu watjarnu, “Maranku marlaku tjarrpatjurra.” Nyangka mularrpartu tjarrpatjunu. Palunyalu yilaralpi nyangu marlaku wirulyarringu mara kutjupapirinypartu. ");
INSERT INTO ntj_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nyangka Mama Kuurrtu watjarnu, “Tjiinya-tjinguru-ya purtu mula-mularriku wana warninyangka. Nyangkan mara pirlpirrta tjarrpatjunku. Nyangka-ya nyaku mula-mularriku. ");
INSERT INTO ntj_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Wiyangka-tjingurun kutjupa ngaapirinypa nintitjunku. Kapin maralu marnmalku yirrala yini Nayiltamartatji palunyalun mantangka tjutilku. Nyangka kapi palunyanya yirramirriku.” ");
INSERT INTO ntj_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nyangka Mawutjalu kuliralpi watjarnu, “Wiya Puurr, wanti-rni wituntjamaaltu. Tjiinya-rna wangka walykumunu watjaranytjamunu. Piwarr-piwarrpa-rna wangkapayi. Purtu-rna wangkapayi. Purinypa-rna wangkapayi.” ");
INSERT INTO ntj_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nyangka Mama Kuurrtu-lu watjarnu, “Nganalu tjaa palyarnu wangkarratjaku? Nganalu pina tjutulku puru tjaa tjutulku? Nganalu kuru palyarnu nyakulatjaku? Puru nganalu kuru tjutulku? Wiya, ngayulukutju-rna palunyapirinypa palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Yuwa, mapitjalta. Ngayulu-rnanta kanyilku walykumunun wangkarratjaku. Ngayulu-rnanta pinangkatjunku nyangkan tjurrkurltu watjanma.” ");
INSERT INTO ntj_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nyangka Mawutjalu puru watjarnu, “Wiya Puurr, wanti-rni. Kutjupanya witula.” ");
INSERT INTO ntj_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Nyangka Mama Kuurrtu Mawutjaku mirrparnarrirralpi watjarnu, “Wiya, nyuntuku kurta Yarannga wangka walykumunu wangkapayi. Palunyanya kuwarrinya ngata-ngata pitjalayirni. Palunyalunta nyakulalpi pukurlarriku. ");
INSERT INTO ntj_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Yuwa, nyuntulu-lun ngayuku wangka tjakultjunku. Nyangka nyuntuku kurtalu kulira mawatjanma. Nyangka ngayulu-pulanyarnanta kanyilku walykumunulu-pulan watjaratjaku. Puru-pulanyarnanta tjurrkurlmanku watjalku. Nyangka-pulan kutjupa-kutjupa palyanma. ");
INSERT INTO ntj_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Tjiinyan Mama Kuurrngapirinytju tjurrkurlmara watjanma. Nyangka nyuntuku kurtalu nyuntuku wangka mawatjanma-tjananya yarnangu pirningka. ");
INSERT INTO ntj_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Yuwa, wana palanya mantjira mapitja. Palunyanya kanyiranytjalun yayirninytjulu kutjupa-kutjupa pirni palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Nyangka Mawutjanya marlaku yanu palunyaku waputju Tjatjarula watjarnu, “Palya-munta-rna marlaku yanku Yiitjipulakutu ngayuku yungarrapirti nyakukitja? Tjinguru-ya wanka tirtu nyinarra.” Nyangka Tjatjarulu watjarnu, “Yuwa, palyan yanku. Mama Kuurrtunta miranykanyinma.” ");
INSERT INTO ntj_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nyangka Mawutjanya ngurra Mitiyanta tirtu nyinarranyangka, Mama Kuurrtu-lu watjarnu, “Yuwa, pakara marlaku mapitja Yiitjipulakutu. Tjiinyanta-ya mirritjunkulanytja, palunyanya-ya mirrirringu wiyarringu. Nyangkan palya yanku.” ");
INSERT INTO ntj_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Nyangka Mawutjalu-tjananya palunyaku kurri puru katja kutjarratarrartu tungkingka tatitjura kutipitjangu ngurra Yiitjipuku. Tjiinya Mawutjanya tjina pitjalayintja. Palunyalu wana marangka katirrayintja Mama Kuurrtu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yuwa, Yiitjipulan waalkarraralpi puurrpa Piirula mirangka yayirninytjulu kutjupa-kutjupa yartakanama, nyarra ngayulu-rnanta nintitjunu wantinyangka. Parturtu-rnalu ngayulu yapupirinymanku witu-witu nyinarratjaku. Nyangka-tjananya tungun-tunguntu wituntjamaaltu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Palunyangkan puurrpa palunyangka watjalku ngayulu-rna Mama Kuurrtu ngaapirinypa watjarnu, ‘Yitjurayilku tjamupirti-ya ngayuku katja kurranyungkatjapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Watjarnu-rnanta ngayuku katja witultjaku. Nyangka-rniyi marninypungama. Nyangkan kulirnu wantingu. Palunyangka-rnanku nyuntuku katja kurranyungkatjanya ngaparrtjika pungku mirrirntanku.’” ");
INSERT INTO ntj_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Nyangka Mawutjanya-pula kurrirarra tjilkutjarra mapitjalayirnu ngururrpa ngarringu. Nyangka Mama Kuurrtu Mawutjala lurrtjurringkulalpi pikalu-lu nguwanpa mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Nyangka palunyanguru Mawutjaku kurri Tjipuralu palunyaku katja watirnu. Palunyalu Mawutjanya tjina pampuralpi watjarnu, “Nyuntulun kurri yirramingkatja-tju ngayuku.” Tjiinya palunyaku katja watintjanya kulira watjarnu. Nyangka Mama Kuurrtu Mawutjanya mirrirntankutjamaaltu wantingu. Nyangka wankarringu. ");
INSERT INTO ntj_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nyangka Mama Kuurrtu Mawutjaku kurta Yaranta watjarnu, “Pakara mayu-mayuwana kutipitja Mawutjala lurrtjurriwa.” Nyangka mularrpartu pakara kutipitjangu. Pitjalayirnu Mawutjala lurrtjurringu Mama Kuurrku purli miirl-miirlta. Nyakulalpi-lu pukurltu nyunytjurnu. ");
INSERT INTO ntj_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Nyangka Mawutjalu-lu tjukurrpa pirni tjakultjunu tjiinya Mama Kuurrtu-lu Yiitjipulakutu witurnu. Puru tjakultjunu tjiinya Mama Kuurrtu watjarnu yayirninytjulu kutjupa-kutjupa yartakaratjaku yarnangu pirningka mirangka. ");
INSERT INTO ntj_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Nyangka-pula kutipitjangu ngurra Yiitjipulakutu. Palunyalu-pula parrapitjangu-tjananya Yitjurayilku tjamupirtiku liita pirninya yarltingu kutjungkanu. ");
INSERT INTO ntj_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Nyangka Yarantu-tjananya tjukurrpa pirni tjakultjunu Mama Kuurrtu Mawutjala watjarnu wantingu, palunyanya. Nyangka pirningka mirangka Mawutjalu yayirninytjulu kutjupa-kutjupa yartakanu. ");
INSERT INTO ntj_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Nyangka-ya yarnangu pirninya nyakulalpi mula-mularringu. Palunyalu-ya watjaranytja, “Yuwa, Mama Kuurrtu-lanya ngamuntirringu nyakula pika-lanya pungkulanyangka.” Palunyalu-ya pupakatirralpi Mama Kuurrnga marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Nyangka Mawutjalu-pula Yarantu mapitjangu puurrpa Piirula watjarnu, “Yuwa, Mama Kuurrtu Yitjurayilku tjamupirtiku Puurrtu ngaapirinypa watjarnu, ‘Ngayuku katja yurntalpirti-tjananya witula. Nyangka-yayi mayu-mayuwana kutipitja pukurltu mirrka, kuka ngalkula ngayunya-rniya pupakatirra marninypungama.’” ");
INSERT INTO ntj_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nyangka puurrpa Piirulu watjarnu, “Ngananyanyka Mama Kuurrnga? Ngayulu-rna-kulila Mama Kuurrku ngurrpa. Nyaaku-rna palunyaku wangka kuliralpi Yitjurayilku tjamupirti-tjananyarna witulku? Wiya, witulkitjamunu-rna.” ");
INSERT INTO ntj_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nyangka-pula watjarnu, “Mama Kuurrnga tjiinya Yiipuru pirnilu-latju pupakatirra marninypungkupayinya yartakarringu-linyatju. Nyangka-munta-lanyatjun witulku? Nyangka-latju mayu-mayuwana mapitjala ngurra kutjarratjanulu kuka pungkulalpi paalku nintilku. Nyangkayi Puurrpa Mama Kuurrtu nyawa pukurlarri. Wiyangka-tjinguru-lampatju Mama Kuurrtu pika purlkanya yutilku mirrirntanku. Wiya-tjinguru warrmarlatarrartu witulku nyangka-lanyatju pitjaku pungku mirrirntanku. Palunyakutarrartu-lanyatju witula.” ");
INSERT INTO ntj_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Nyangka puurrpa Piirulu watjarnu, “Wiya, nyaaku-pulan watjara waarka-ya wantirra kutipitjatjaku? Wiya, marlaku-tjananya witula waarka purlkanya-lampatju palyaratjaku! ");
INSERT INTO ntj_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tjiinya-yan wiyangkalpi pirnirringkulalpi ngayunya-lanyatju wayirntanu nyinarra. Nyangka-pulan marrkura waarka-ya wantirra yankutjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Nyangka tjirntu palunyangkartu puurrpa Piirulu-tjananya puurrpa pirninya tjiinya-ya waarkaku witu-witulpayinya puru puurrpa Yiipuru pirninya tjiinya-ya waarka miranykanyilpayinya yarltirralpi watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Yuwa, tjanpi-tjanampayan nintilpayi. Nyangka-ya pilkingka lurrtjura yapu palyalpayi. Ngaanguru-tjanampa tjanpi nintintjamaaltu wanti. Nyangka-yayi yungarralu ngurrira katima. ");
INSERT INTO ntj_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tjiinya-ya tjirntu kutjupa tjirntu yapu pirni palyalpayi. Nyangka nampa palunyanya kurlunymankutjamaaltu wanti. Nyangka-yayi nampartu tirtu palyanma. Tjiinya-tjinguru-ya waarka kurlunytjarralu kulira yankula kuka pungkula paara Mama Kuurrku nintilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Watjala-tjananya waarka purlkanya palyaratjaku tjiinya yurlta nyinarranytjalu tjukurrpa kuliratjakutarra wati palunyalu-pula yarlamayuranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nyangka-ya mularrpartu mapitjangu-tjananya yarnangu pirningka watjarnu, “Puurrpa Piirulu watjarnu tjanpi-tjanampanku nintintjamaaltu wantitjaku. ");
INSERT INTO ntj_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Tjiinya-yanyun yungarralu ngurrira katima palunyalu yapu nampartu tirtu palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Nyangka-ya mularrpartu mapitjalayirnu ngurra Yiitjipula lipiwanalu tjanpi yurrara katirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nyangka-ya puurrpa Yiitjipunyamartatji pirni nyarra waarkaku-ya witu-witulpayilu-tjananya purtu pawurntjingara witu-wituranytja yapu nampartu palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Palunyalu-tjananyaya puurrpa Yiipuru nyarra waarka-ya miranykanyilpayi pirninya pungkula watjaranytja, “Nyaatjanulu-yan yapu marnkurr-marnkurrpa palyarnu? Tjinguru-yan pirni palyanma, nyarra ngaangkalpi-yan palyalpayi, palunyapirinypartu.” ");
INSERT INTO ntj_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","16","Nyangka-ya puurrpa nyarra waarka-ya miranykanyilpayi pirninya mapitjangu puurrpa Piirula watjarnu, “Wiya puurr, nyaatjanungka-lampatjun waarka purlkarnu? Tjiinya-lampatjuya tjanpi nintiranytjamunu. Palunyalu-ya watjara yapu-latjunyu tirtu palyaratjaku. Puru-lanyatjuya pungkula. Wiya, nyuntulu-lanyatjun waarka purlkanya nintirnu. Nyangka-latju purtu kulira palyalkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nyangka puurrpa Piirulu tjalkirr-tjalkirrtu watjarnu, “Wiya, nyuntulu-yan waarrpungkula talypurringkupayi. Puru-tjinguru-yan waarkaku yanyantju. Palunyatjanu-yan tjapira kutipitjala kuka pungkula paara Mama Kuurrku nintilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Wiya, marlakulu-ya mapitja waarka palyanma. Tjanpi-tjanampankuya nintilkitjamunu. Nyangka-yan yapu nampartu tirtu palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nyangka-ya puurrpa waarka palyalpayi pirninya kata paarnarraralpi wuyurrpa kurrarringu. Palunyalu-ya purtu kuliranytja waarka palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nyangka-ya pakara mapitjangu nyangu Mawutjalu-pula Yarantu ngarala kuwarripa nyakulanytja pitjatjaku-ya. ");
INSERT INTO ntj_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Nyangka-pulanyaya watjarnu, “Wiya, Mama Kuurrtu-pulanyanta nyangu tjiinya-lampatjun pitjangu kurrannyangka. Palunyalu-pulanyanta pungku. Tjiinya-pulan watjarnu yankula kuka pungkula Mama Kuurrku nintilkitjalu. Palunyanguru tjiinya puurrpa Piirunya-lampatju yanyan-yanyanarringu. Nyuntulu-pulan pitjangu puurrpa Piirunya mirrparnmanu. Nyangka-lanyatju pungku mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Nyangka Mawutjalu Mama Kuurrta watjarnu, “Wiya Puurr, nyaatjanungka-lampatjun kurrarnu nyuntuku katja yurntalpirtiku? Nyaaku-rnin ngalyawiturnu wantinytjamaaltu? Tjinguru-rnin wantinyangka-rna ngurrangkalpi ma-nyinama. ");
INSERT INTO ntj_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tjiinya-rna mapitjangu puurrpa Piirula nyuntuku wangka watjarnu. Nyangka kuliralpi-tjanampa nyuntuku katja yurntalpirtiku waarka ma-purlkarnu. Nyangka-lanyatjun yirringkankutjamaaltu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Wiya, kuwarripa wanti. Palunyalu nyinarra nyangama. Nyangka-rnayi ngayulu puurrpa Piirunya wuyurrmarra. Tjiinya-rnalu ngayulu yayirninytjulu kutjupa-kutjupa pirni palyaranytjalu wuyurrpa kutjupanku. Nyangka-tjananya ngayuku katja yurntalpirti witulku. Yuwa, mirrparnarrirralpi-tjananya witulku palunyaku ngurra wantirra-ya kutipitjatjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yuwa, ngayulu-rna yini Yaawayinya. ");
INSERT INTO ntj_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Tjiinya-tjananyarna yartakarrirranytja Yayipuramala, Yayitjikila, puru Tjayikapala. Nyangka-rniya watjalpayi Mama Kuurrnga Yayirninytjulu Palyalpayinya. Nyangka-tjananyarna watjantjamaaltu wantirranytja ngayuku yini miirl-miirlpa Yaawayinya. ");
INSERT INTO ntj_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Tjiinya-tjananyarna kalkurnu ngurra Kayinannga nintilkitjalu ngurra nyarra kutjulpirtu-ya maliki nyinarranytja, palunyanya. ");
INSERT INTO ntj_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Yuwa, kulirnu-rna Yitjurayilku tjamupirti-ya yularranyangka Yiitjipunyamartatji pirnilu-tjananyaya pungkula yulatjingara kanyiranyangka. Palunyalu-rna kulirnu kutjulpirtu-rna Yayipuramanya kalkuntjalu. ");
INSERT INTO ntj_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Nyangka watjala-tjananya Yitjurayilku tjamupirti tjiinya-rna ngaapirinypa watjarnu, ‘Ngayulu-rna Yaawayinya. Palunyalu-tjananyarnanta yarlangkatjura katiku Yiitjipunyamartatjilu-tjananyanta waarka purlkanya tirtu nintiranyangka. Ngayulu-tjanamparna yayirninytjulu pika yutinma. Palunyalu nyuntunya-tjananyarnanta wankarura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nyangka-yan ngayuku katja yurntalpirti nyinama. Tjiinya-tjananyarnanta walykumunura kanyinma. Yuwa, ngayulu-tjananyarnanta yarlangkatjura katiku. Palunyangka-yan nintilu kulinma tjiinya ngayulu-tjanamparnanku Puurrpa Mama Kuurrnga nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Yuwa, katiku-tjananyarnanta ngurra kalkuntjalakutu. Ngurra nyarra ngayulu-rna kutjulpirtu Yayipuramanya, Yayitjikinya puru Tjayikapanya kalkurnu ngula nintilkitjalu, palunyanya-tjanamparnanku nintilku. Nyangka-yan ngurra palunyangka tirtu nyinama. Yuwa, ngayulu-rna Yaawayinya.’” ");
INSERT INTO ntj_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Nyangka Mawutjalu mapitjangu-tjananya Yitjurayilku tjamupirti tjakultjunu tjukurrpa Mama Kuurrtu watjantjanya. Nyangka-ya kulira wantirranytja. Tjiinyamarntu-ya kurltjirr-kurltjirrarringu waarka purlkanya palyaranytjatjanu. ");
INSERT INTO ntj_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Nyangka Mama Kuurrtu Mawutjala watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Mapitja watjala puurrpa Piirulu Yitjurayilku tjamupirti-tjananya witultjaku. Nyangka-yayi pakara palunyaku ngurra wantirra kutipitja.” ");
INSERT INTO ntj_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nyangka Mawutjalu watjarnu, “Wiya, Yitjurayilku tjamupirtilu-rniya kulira wantirranytja. Nyangka puurrpa Piirulu-rni kulilkitjamunu. Tjiinyamarntu-rna piwarr-piwarrpa wangkapayi.” ");
INSERT INTO ntj_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nyangka Mama Kuurrtu Mawutjala-pulanya Yaranta watjarnu, “Watjala-tjananya Yitjurayilku tjamupirti puru puurrpa Piirunya tjiinya ngayulu-pulanyarnanta watjarnu wantingu tjiinya-pulan Yitjurayilku tjamupirti-tjananya Yiitjipulanguru walara katitjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","27","Nyangka tjiinya Tjayikapalu katja pirni kanyiranytja. Nyangka palunyaku katja nampa 3, Liipayilu tjamu pirni kanyiranytja. Nyangka Yarannga-pula Mawutjanya Liipayiku wartangkatja nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Nyangka tjiinya Mama Kuurrtu Mawutjala watjarnu, “Yuwa, ngayulu-rna Yaawayinya. Nyangkan mapitjaku puurrpa Piirula watjalku ngayulu-rna watjalku wantinyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Nyangka Mawutjalu watjarnu, “Wiya, ngayulu-rna piwarr-piwarrpa wangkapayi. Nyangka-rni kamu kulilku puurrpa Piirulu.” ");
INSERT INTO ntj_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nyangka Mama Kuurrtu watjarnu, “Wiya, nyuntuku kurta Yarantu nyuntuku wangka mawatjalku puurrpa Piirula. Tjiinyakurlu-rna ngayulu watjaranyangka ngayuku wangka kulira tjakultjunkupayilu-ya mawatjala yarnangu pirningka, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tjiinya nyuntulun Yaranta tjakultjunku ngayulu-rnanta watjalku wantinyangka. Nyangka Yarantu puurrpa Piirula mawatjalku ngayuku katja yurntalpirti-tjananyanta witultjaku. Nyangka-yayin palunyaku ngurra wantirra yarra. ");
INSERT INTO ntj_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Nyangka-rna puurrpa palunyanya yapupirinymanku witu-witu tirtu nyinarratjaku. Nyangkanta kulilkitjamunu. Tjiinya-rna kutjupa-kutjupa yartakanama ngurra Yiitjipula. Nyangkanta kulilkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","5","Nyangka-rna pika purlkanya yutilku ngurra Yiitjipunyamartatjiku. Palunyalu-tjananyarnanta ngayuku katja yurntalpirti, tjiinya Yitjurayilku tjamupirti ngurra ngaanguru walara katiku. Nyangka-ya Yiitjipunyamartatji pirnilu nintilu kulilku tjiinya ngayulu-rna Mama Kuurrnga Puurrpa Purlkanya nyinarranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Nyangka Mawutjanya-pula Yarannga kulira yanu puurrpa Piirula wangkakitja. ");
INSERT INTO ntj_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tjiinya palunyatjarralpi Mawutjanya yirna purlkanya nyinarranytja, tjiinya-ra kurli 80 ngaralanytja. Nyangka palunyaku kurta Yaranku-ra kurli 83 ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nyangka Mama Kuurrtu-pulanya Mawutjala Yaranta watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Tjinguru-pulanyanta puurrpa Piirulu watjalku yayirninytjulu kutjupa-kutjupa yartakankutjaku. Nyangkayi nyakulalpi mula-mularriwa. Palunyangka watjala Yarantu palunyaku wana mantakutu warnitjaku puurrpa Piirula tjinangka. Nyangkayi lirrurriwa.” ");
INSERT INTO ntj_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Nyangka mularrpartu Mawutjanya-pula Yarannga yanu puurrpa Piirulakutu Mama Kuurrtu-pulanya watjarnu wantinyangka. Palunyalu Yarantunku wana mantakutu warningu puurrpa Piirula tjinangka puru palunyaku yamatji pirningka mirangka. Nyangka-ya nyangu lirrurringkunyangka. ");
INSERT INTO ntj_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Nyangka puurrpa Piirulu palunyaku maparntjarra pirninya yarltingu. Nyangka-ya pitjangu palunyapirinypartu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tjiinya-yanku wana warnirranytja. Nyangka-ya pirninyartu lirrurringu. Nyangka Yaranku wana lirrurringkutjatjanulu palunyaku-tjanampa lirru pirninya kuurltjunu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Parturtu puurrpa Piirulu Mawutjanya-pulanya Yarannga tungun-tunguntu tirtu kulira wantirranytja. Tjiinya Mama Kuurrtu watjarnu ngarnmanymanu wantinytjanya, palunyapirinypartu. ");
INSERT INTO ntj_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Puurrpa Piirulu yapupirinytju yarnangu pirninya witulkitjamunulu tirtu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kulila-pula. Mungayurntura-pula pakala wana palunyanya lirrurringkutjanya mantjira makati kapi kantilykutu. Palunyalu-pula ngarala nyangama puurrpa Piirunya kapi yirralakutu mapitjanyangka lurrtjurriwa. ");
INSERT INTO ntj_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Palunyalu-pula ngaapirinypa watjala, ‘Mama Kuurrtu Yiipuru pirniku Puurrtu-rni witurnu nyuntula watjaltjaku. Palunyaku katja yurntalpirtinyu witula. Nyangka-yayi mapitja mayu-mayu nyinarranytjalu Mama Kuurrnga marninypuwa. Palunyapirinypa-rnanta watjaranytja. Nyangkan wangka palunyanya kulira wantirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yuwa, nyuntulun nintirriku tjiinya Mama Kuurrnga Puurrpa Purlkanya nyinarra. Tjiinya-rna wana ngaangka kapi yirrala pungku. Palunyangka-yan nyaku kapi yirramirrinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nyangka-ya kuka kapingkatja pirninya mirrirriku. Nyangka parnti purlkanya parntirrngarama. Nyangka-yan Yiitjipunyamartatjilu kapi purtu tjikinma.’” ");
INSERT INTO ntj_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yarannga watjala wana ma-kanyiltjaku yirrala purlkanyawana puru kapi kurlunywanatarrartu. Nyangka-yayi yirramirri. Ngurra lipiwana-ya kapi pirninya yirramirriku puru wayatjarrangkatarrartu yirramirriku.” ");
INSERT INTO ntj_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Nyangka Mawutjanya-pula mularrpartu yanu kapi palunyakutu. Palunyalu-pula puurrpa Piirula puru palunyaku yamatji pirningka lurrtjurringu. Nyangka Yarantu mirangkartu-tjananya wana wakuralpi kapi pungu. Nyangka kapi yirrala Nayilnga yirramirringu. ");
INSERT INTO ntj_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nyangka-ya kuka kapingkatja pirninya mirrirringkula-wanarnu wiyarringu. Nyangka parnti purlkanya parntirrngaralanytja. Nyangka-ya Yiitjipunyamartatji pirnilu kapi palunyanya purtu tjikira yakuntjuranytja. Tjiinya kapi ngurra lipiwanartu yirramirringu ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Nyangka-ya puurrpa Piiruku maparntjarra pirnilu palunyapirinypartu palyaranytja. Parturtu puurrpa Piirulu Mawutjanya-pulanya Yarannga tungun-tunguntu tirtu kulira wantirranytja. Tjiinya Mama Kuurrtu watjarnu ngarnmanymanu wantingu witu-witu nyinarratjaku, palunyapirinypartu. ");
INSERT INTO ntj_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Nyangka puurrpa Piirunya wantirra marlaku mapitjangu palunyaku ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nyangka-ya Yiitjipunyamartatji pirnilu kapi yirralangka kantilytja tjawaranytja kapi tjurnu tjikilkitjalu. Tjiinya-ya kapi yirralangkatja purtu tjikiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nyangka ngurra 7-tjanu kapi palunyanya marlaku walykumunurringu. ");
INSERT INTO ntj_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Mapitja puurrpa Piirulakutu. Palunyalu watjala ngayulu-rna Mama Kuurrtu ngaapirinypa watjarnu, ‘Ngayuku katja yurntalpirti-tjananya witula. Nyangka-rniyayi mapitja marninypuwa. ");
INSERT INTO ntj_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nyangka-tjingurun tirtu tungun-tungunpa nyinarranyangka ngayulu-tjanamparnanku ngarnngi pirni pakaltjingalku. Nyangka-ya nyuntuku ngurra lipiwana parrawuurlmarayinma. ");
INSERT INTO ntj_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Tjiinya-ya ngarnngi pirninya kapi yirrala Nayilta pirnirringkulalpi pakara mapitjaku nyuntuku yiwarlangka tjarrpaku, puru nyuntuku ngurra ngarripayingka puru piirrpangkatarrartu. Puru-ya nyuntuku yamatji pirniku yiwarlangkatarrartu tjarrpaku, yarnangu pirnikurtu-tjanampa ngurrangka puru tiirrtji pirningka puru mirrka paalpayingkatarrartu-ya tjarrparralpi parrawuurlmarayinma. ");
INSERT INTO ntj_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Palunyalu-ya nyuntulawana, nyuntuku yamatji pirniwana puru nyuntuku yarnangu ngulytju pirniwana tatira yiikuwanatarrartu-tjananyanta parrawuurlmanama.’” ");
INSERT INTO ntj_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Nyangkalta Mama Kuurrtu Mawutjala watjarnu, “Yarannga watjala. Nyangkayi wana ma-kanyila kapi pirniwana. Nyangka-yayi ngarnngi pirni paka-pakaralpi ngurra lipiwana yangatjura nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Nyangka Yarantu mularrpartu wana ma-kanyirnu kapi pirnikutu. Nyangka mularrpartu ngarnngi pirni paka-pakaralpi ngurra lipi parrayangatjunu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nyangka-ya maparntjarra pirnilu minirringkulalpi ngarnngi pirni puru pakaltjingarnu. ");
INSERT INTO ntj_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Nyangka puurrpa Piirulu Mawutjanya-pulanya Yarannga yarltirralpi watjarnu, “Tjapila-pula nyuntuku Puurrpa Mama Kuurrtu ngarnngi ngaa pirninya mirrirntara wiyaltjaku. Nyangka-tjananyarna nyuntuku yungarrapirti witulku yankula-ya mayu-mayu kuka pungkula paara Mama Kuurrku nintiltjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Nyangka Mawutjalu watjarnu, “Yuwa, tjapilku-rnanku. Nyangka-rni watjala wanytjawara-rnanku tjapiltjaku. Nyangka-rnayi tjapila nyuntuku, puru nyuntuku yamatji pirniku, puru nyuntuku yarnangu ngulytju pirnikutarra. Nyangka-yayi ngarnngi pirninya wiyarringkulalpi kapi Nayiltakutju nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Nyangka puurrpa Piirulu watjarnu, “Tjirntungka-tju tjapila.” Nyangka Mawutjalu watjarnu, “Yuwa, tjirntungka-rnanku tjapilku. Nyangka ngarnngi pirninya mirrirriku wiyarriku. Nyangkan nintilu kulilku tjiinya kutjupa palunyapirinypa nyinarranytjamunurtu. Ngarna ngayuku Puurrpa Mama Kuurrtu palunyapirinypa palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Tjiinya-ya ngarnngi pirninya wiyarriku. Nyangka-yan, nyuntuku yamatji pirninya puru nyuntuku yarnangu ngulytju pirninya ngarnngimaalpa nyinama. Nyangka-ya kapi Nayiltakutju nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Nyangka-pula puurrpa Piirunya wantirra yanu. Nyangka Mawutjalu mularrpartu Mama Kuurrta kurrurntutarra tjapirnu ngarnngi pirninya mirrirringkula wiyarritjaku. ");
INSERT INTO ntj_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Nyangka Mawutjalu tjapinnyangka Mama Kuurrtu mularrpartu ngarnngi pirninya mirrirntanu. Nyangka-ya punkarnu mantangka ngarrirranytja yiwarlawana, yaarrta kaninytjarrawana puru yurirlwanatarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Nyangka-ya yurrara kapurtura tjunkulanytja. Nyangka ngurra lipiwana parntirrngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Nyangka puurrpa Piirulu nyangu ngarnngi pirninya mirrirrinyangka. Palunyalu pururtu tungun-tungunarringu. Palunyalu Mawutjaku-pulampa Yaranku wangka kulira wantirranytja. Tjiinya Mama Kuurrtu watjarnu ngarnmanymanu wantinytjanya, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Watjala Yarantunku wanangka manta pungkutjaku. Nyangka yulpurru pakaralpi kiwinyirriku ngurra Yiitjipula lipiwanartu.” ");
INSERT INTO ntj_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Nyangka Yarantu mularrpartu manta pungu. Nyangka yulpurru pakaralpi kiwinyirringu ngurra Yiitjipula lipiwanartu. Nyangka-ya kiwinyi pirnilu yarnangu pirninya-tjananya puru yanamulpa pirninya tjutura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nyangka-ya maparntjarra pirnilu purtu yarrkaranytja palunyapirinypa palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Palunyalu-ya puurrpa Piirula watjarnu, “Wiya, Mama Kuurrtu kiwinyi pirninya yartakanu.” Nyangka puurrpa Piirulu-pulampa wangka tungun-tunguntu tirtu kulira wantirranytja. Tjiinya Mama Kuurrtu watjarnu ngarnmanymanu wantingu palunyapirinypartu ngaratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Mungayurntura-pula pakara mapitja nyawa puurrpa Piirunya kapi yirralakutu mapitjanyangka lurrtjurriwa. Palunyalu watjala tjiinya-rna Mama Kuurrtu ngaapirinypa watjarnu, ‘Ngayuku katja yurntalpirti-tjananya witula. Nyangka-rniyayi mapitja marninypuwa. ");
INSERT INTO ntj_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Wiyangka-rnanku purnpurnpa pirni yutilku nyuntuku, puru nyuntuku yamatji pirniku, nyuntuku yarnangu ngulytju pirnikutarrartu. Nyangka-ya nyuntuku-tjanampanku yiwarlangka tjarrparralpi yarla yangatjunku puru mantatarrartu yangatjunku kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Nyangka purnpurnpa-ya yutirrikitjamunu ngurra nyarra Kutjurnta ngayuku katja yurntalpirti-ya nyinarranyangka. Palunyangkan nintilu kulinma tjiinya-rna Mama Kuurrtu yayirninytjulu kanyira ngayuku katja yurntalpirti palunyalu-tjanamparnanku nyuntuku yarnangu ngulytju pirniku purnpurnpa pirni yutira. Tjirntungka-rna purnpurnpa palunyanya yutilku. Nyangka-yan nyaku.’” ");
INSERT INTO ntj_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Nyangka Mama Kuurrtu mularrpartu purnpurnpa pirni yartakanu. Nyangka-ya puurrpa Piiruku yiwarlangka tjarrpangu puru palunyaku yamatji pirniku-tjanampa yiwarlangkatarrartu. Nyangka ngurra Yiitjipunya lipinyartu palyamunurringu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Nyangka puurrpa Piirulu Mawutjanya-pulanya Yarannga yarltirralpi watjarnu, “Yuwa, palya-yan yanku kuka pungkulalpi paalku nintilku nyuntuku Puurrpa Mama Kuurrku. Tiwa-kurlu-yan yanku. Ngamuwana-ya parrangarama.” ");
INSERT INTO ntj_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nyangka Mawutjalu watjarnu, “Wiya, ngamurtu-latju kuka pungkulalpi paalkitjamunu. Tjiinya-tjinguru-lanyatjuya Yiitjipunyamartatjilu nyaku miirlarraralpi-lanyatju yatulku mirrirntanku. ");
INSERT INTO ntj_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Palunyakutarra-latju yanku ngurra kutjarratjanulu kuka pungkulalpi paalku nintilku, Mama Kuurrtu watjarnu wantinyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nyangka puurrpa Piirulu watjarnu, “Yuwa, palya-yan mayu-mayu yanku palunyalu kuka pungkulalpi paalku Mama Kuurrku nintilku. Palunyalu tiwa-kurlu-yan yanku. Ngamuwana-ya parrangarama. Puru ngayukutarrartu-tjuya tjapinma.” ");
INSERT INTO ntj_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Nyangka Mawutjalu watjarnu, “Yuwa, mapitjalalpi-rna Mama Kuurrta tjapilku. Nyangka tjirntungka purnpurnpa pirninya-ya wiyarringkula yanku. Nyangka-yan nyuntulu, nyuntuku yamatji pirninya, puru nyuntuku yarnangu ngulytju pirninyatarra purnpurnmaalpa nyinama. Nyangka puru-kurlu-lanyatjun yarlamayulku. Marrkuntjamaaltu-lanyatju wanti. Nyangka-latjuyi mapitja kuka pungkula paara Mama Kuurrku nintinma.” ");
INSERT INTO ntj_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nyangka Mawutjalu puurrpa Piirunya wantirra mapitjalalpi Mama Kuurrta tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Nyangka Mama Kuurrtu Mawutjanya kuliralpi purnpurnpa pirninya pakaltjingarnu wiyarnu. Nyangkalta-ya pakara yanu wiyarringu. Nyangka-ya puurrpa Piirunya, palunyaku yamatji pirninya puru palunyaku yarnangu ngulytju pirninya purnpurnmaalpa nyinarranytja. Purnpurnpa kutjupa nyinanytjamaalpartu. Pirninyartu-ya wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Parturtu puurrpa Piirunya marlaku witu-witurringu. Palunyalu marrkura-tjananya tirtu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Mapitja puurrpa Piirula watjala tjiinya-rna Mama Kuurrtu Yiipuru pirniku Puurrtu ngaapirinypa watjarnu, ‘Ngayuku katja yurntalpirti-tjananya witula. Nyangka-rniyayi mapitja marninypuwa. ");
INSERT INTO ntj_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Wiyangka-rnanku pika purlkanya yartakanku nyuntuku yanamulpa pirniku tjiinya purniku, tungkiku, kamurlku, pulukaku, tjiipuku puru nanikuurrkutarrartu. Nyangka-ya mirrirriku wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nyangka-tjanamparna Yitjurayilku tjamupirtiku miratjunku wantinyangka-ya wanka tirtu ngarama. Nyangka nyuntukukutju-tjanamparnanku mirrirntanku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ngayulu-rna Mama Kuurrtu watjara tjirntungka-rna palyalkitjalu.’” ");
INSERT INTO ntj_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nyangka tjirntungka Mama Kuurrtu puurrpa Piiruku yarnangu ngulytju pirniku-tjanampa yanamulpa pirninyartu pikatjarrarnu watjarnu wantitjalu. Nyangka-ya mirrirringu wiyarringu. Nyangka Yitjurayilku tjamupirtiku-tjanampa wanka ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nyangka puurrpa Piirulu witurnu yankula-ya nyakutjaku. Nyangka-ya mularrpartu mapitjalayirnu nyangu wantirra pitjangu watjarnu, “Wiya wanka-tjanampa Yitjurayilku tjamupirtiku yanamulpa pirninya ngarala. Nyangka ngayukukutju-lampa mirrirringu.” Nyangka puurrpa Piirulu witu-witulu-tjananya tirtu marrkura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Nyangka Mama Kuurrtu Mawutjala-pulanya Yaranta watjarnu, “Mapitja-pula tjurnpa kurlkungkatja mantjira makati puurrpa Piirula mirangka ngara. Nyangkayi Mawutjalu yilkarikutu warni. ");
INSERT INTO ntj_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Nyangka tjurnpa palunyanya ma-lipirriku yulpurrupirinypa Yiitjipula ngurra lipiwanartu. Nyangka yurnturrngu pirni yarnangu pirningka puru yanamulpa pirningkatarrartu nyina-nyinakatiku.” ");
INSERT INTO ntj_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nyangka-pula tjurnpa mantjira makatingu puurrpa Piirula ngaralalpi Mawutjalu yilkarikutu warningu. Nyangka yurnturrngu-tjananya nyina-nyinakatingu yarnangu pirningka puru yanamulpa pirningkatarrartu. Palunyalu yurnarringkulalpi yarlarringu pika purlkanya ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Nyangka-ya maparntjarra pirninya yurnturrngutjarra Mawutjalakutu yankukitjalu purtu pakarnu yarrkaralpi wantingu nyinarranytja. Tjiinya-ya puurrpa Piiruku yarnangu ngulytju pirninyartu yurnturrngutjarrarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nyangka Mama Kuurrtu puurrpa Piirunya yapupirinymanu witu-witu tirtu nyinarratjaku. Nyangka-pulanya Mawutjanya witu-witulu kulira wantirranytja. Tjiinya Mama Kuurrtu Mawutjala watjarnu ngarnmanymanu wantingu, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Mungayurntura-pula pakara mapitja puurrpa Piirula watjala tjiinya-rna Mama Kuurrtu, Yiipuru pirniku Puurrtu, ngaapirinypa watjara, ‘Ngayuku katja yurntalpirti-tjananya witula. Nyangka-rniyayi mapitja marninypuwa. ");
INSERT INTO ntj_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kuwarrinya-rnanku nyuntukutarrartu pika purlkanya yutilku. Yuwa, mularrpa-tjanamparnanku nyuntuku puru nyuntuku yamatji pirniku puru nyuntuku yarnangu ngulytju pirniku pika purlkanya yutilku. Nyangkayin nintilu kulinma ngayulukutju-rna yayirninytjulu palyalpayi. Nyangka kutjupa ngayunyapirinypa manta lipiwana nyinanytjamunurtu. ");
INSERT INTO ntj_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tjinguru-tjananyarnanta pika purlkanya pungkula mirrirntanama. ");
INSERT INTO ntj_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ngarna-tjananyarnanta wantingu wanka nyinarratjaku-yan. Tjiinya-rniyayi manta lipingkatjalu nintilu kulinma ngayulu-rna yayirninytju purlkanya nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nyangkan karnany-karnanytju ngayuku katja yurntalpirti tirtu marrkura kanyira. ");
INSERT INTO ntj_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nyangka yunguntjarra tjirntu ngaapirinyarrinyangka-rna kapi purlkanya kunartatjarra wiyalku. Tjiinya-yan kunarta ngaapirinypa ngarnmanypalpi kutjuwarra nyakula wantirranytjamunu. ");
INSERT INTO ntj_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nyangka watjala-tjananya yanamulpa pirninya-ya wiltjangka tjarrpatjunkutjaku kunartalu-tjananya yatura mirrirntankutjakutarrartu yurirlta-ya ngaralanyangka. Yarnangutarrartu-tjananyaya tjarrpatjurra mirrirritjakutarra-ya.’” ");
INSERT INTO ntj_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Nyangka Mawutjalu mularrpartu puurrpa Piirula watjarnu. Nyangka-ya puurrpa Piiruku yamatji kutjupatjarra ngurlurringu Mama Kuurrtu watjannyangka. Palunyalu-tjananyaya waarka palyalpayi puru yanamulpa pirninya katingu wiltjangka kaninytjarra ngaratjunu wantingu. Nyangka-ya ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Nyangka kutjupatjarralu-ya Mama Kuurrku wangka kulira wantirranytjalu wantingu-tjanampa waarka palyalpayi pirninya puru yanamulpa pirninya yurirlta ngaralatjaku. ");
INSERT INTO ntj_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Maranku katuralpi ma-kanyila yilkarikutu. Nyangkayi kapi kunartatjarra ngurra Yiitjipula lipiwanartu punkala. Nyangka kunartalu-tjananya yarnangu pirninya puru yanamulpa pirninya yaturayilku mirrirntanku. Puru mirrka yukiri pirninya yaturayilku kartarntanku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Nyangka mularrpartu Mawutjalunku wana ma-kanyirnu yilkarikutu. Nyangka Mama Kuurrtu yartakanu kapi kunartatjarra punkaltjaku. Nyangka mularrpartu tuturanytja puru wanangaratarrartu paka-pakaranytja. Kunarta purlkanya mularrpa punkaranytja. Tjiinya palunyapirinypa Yiitjipula kutjuwarra punkara wantirranytjamunu. Palunyangkakutju kunarta purlkanya punkarnu. ");
INSERT INTO ntj_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ngurra Yiitjipula lipiwana kunartalu-tjananya yarnangu pirninya yanamulpa pirninyatarrartu yaturanytja yurirlta-ya ngaralanyangka. Puru yukiri pirninya puru warta pirninyatarrartu yaturayirnu kartarntanu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Nyangka ngurra nyarra Kutjurnta Yitjurayilku tjamupirti-ya nyinapayi, palunyangkakutju-ya kunartamaalpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Nyangka puurrpa Piirulu Mawutjanya-pulanya Yarannga yarltirralpi watjarnu, “Yuwa, palyamunulu-tjananyarnanta marrkura kanyiranytja. Nyangka Mama Kuurrnga tjukarurru mularrpa nyinarra. Nyangka ngayulu-latju palyamunu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Wiya, kunartalu-lanyatju mantjirnu karurr-karurrmanu. Tjapila-lampatju Mama Kuurrta. Tjukarurrulu-pulanyarnanta watjara. Witulku-tjananyarnanta palya-yan yankutjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Nyangka Mawutjalu-lu watjarnu, “Yuwa, yilkaku-rna mapitjalalpi mara katulku Mama Kuurrta tjapilku. Nyangka tuturanytjanya wiyarriku puru kunartatarrartu wiyarriku. Nyangkayin nintilu kulinma tjiinya Mama Kuurrnga manta lipikurtu puurrpa nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nyangka-tjananyarnanta nintilu kulira tjiinya-yan nyuntulu puru nyuntuku yamatji pirninyatarrartu-yan tjalkirr-tjalkirrpa tirtu nyinarra. Tjiinya-yan Mama Kuurrku mula-mularringkutjamaaltu tirtu kulira wantirra.” ");
INSERT INTO ntj_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Nyangka tjiinya-ya ngurra palunyangka yukiri wirrmira pakaltjingalpayi pikirrinyangka kultura warntu palyalkitjalu. Nyangka kunartalu-tjanampa yukiri wirrmira palunyanya yaturnu walykurnu. Puru mirrka paali yaturnu walykurnu tjiinyamarntu yurnmi ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Nyangka mirrka wiirpa walykumunu ngaralanytja. Tjiinyamarntu marla yurnmirringkupayi. ");
INSERT INTO ntj_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nyangka Mawutjalu-lu puurrpa Piirunya wantirra yilkaku yanu. Palunyalu mara katuralpi Mama Kuurrta tjapirnu. Nyangka mularrpartu kapi kunartatjarra tuturanytjatjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Nyangka puurrpa Piirulu nyangu kapi tutulpayinya wiyarrinyangka. Palunyalu pururtu palyamunurringu. Nyangka-ya palunyaku yamatjitarrartu witu-witu tirtu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Nyangka puurrpa Piirulu witu-witurringkulalpi Yitjurayilku tjamupirti-tjananya tirtu marrkura kanyiranytja. Tjiinya Mama Kuurrtu Mawutjala watjarnu ngarnmanymanu wantingu palunyapirinypartu ngaratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Marlaku mapitja puurrpa Piirulakutu. Tjiinya-tjananyarna ngayulu puurrpa palunyanya puru palunyaku yamatji pirninya yapupirinymanu witu-witu-ya tirtu nyinarratjaku. Tjiinya-rnayi palunyalawana-tjananyarna yayirninytjulu kutjupa-kutjupa yartakanama. ");
INSERT INTO ntj_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nyangka-yayin ngula tjukurrpa tirtu watjanma katja yurntalpirtingka puru tjamu kaparlipirtingka, tjukurrpa tjiinya-tjananyarna puurrpa Piiruku yarnangu ngulytju pirninya kanyira ngarlpupirtiranytja, yayirninytjulu kutjupa-kutjupa yartakaranytjalu. Nyangka-rniyayin nintilu kulinma tjiinya ngayulu-rna Mama Kuurrnga Puurrpa Purlkanya nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Nyangka Mawutjalu-pula Yarantu mapitjangu puurrpa Piirula watjarnu, “Mama Kuurrtu Yiipuru pirniku Puurrtu ngaapirinypa watjarnu, ‘Nyaaku-rnin tirtu tungun-tunguntu kulira wantirra? Witula-tjananya ngayuku katja yurntalpirti. Nyangka-rniyayi mapitja mayu-mayungurulu marninypuwa. ");
INSERT INTO ntj_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Wiyangka-rnanku yunguntjarra tjintilyka pirni wiyalku nyuntuku ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Nyangka-ya manta yangatjura kanyinma. Nyangka yukiri parrka marnkurr-marnkurrpa kunartatjanu ngaralanyangka, palunyanya-ya tjintilyka pirnilu pitjaku ngalkulayilku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Puru-ya nyuntuku yiwarlangka puru nyuntuku yamatji pirniku yiwarlangka puru nyuntuku yarnangu ngulytju pirniku yiwarlangka-ya tjarrparralpi parrapitjalayinma. Tjiinya nyuntuku tjamu mirri pirnilu-ya palunyapirinypa kutjuwarra nyakula wantirranytjamunu. Tjiinya kuwarrikutju yartakarriku.’” Nyangka-pula watjarnu wantirra yanu. ");
INSERT INTO ntj_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Nyangka-ya puurrpa Piiruku yamatji pirnilu-lu watjarnu, “Wiya, wati ngaalu-munta-lanya tirtu walykura kanyinma? Yala, wati-tjananya Yitjurayilku tjamupirti witula. Nyangka-yayi mapitja mayu-mayu nyinarranytjalu palunyaku Puurrpa Mama Kuurrnga marninypuwa. Purtu-muntan kulira? Wiyangkalpi-lampa ngurra palyamunurringu.” ");
INSERT INTO ntj_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Nyangka puurrpa Piirulu-tjananya witurnu yankula-ya Mawutjanya-pulanya Yarannga marlakulu yarltirra katitjaku. Nyangka-pulanyaya mularrpartu yarltirra katingu. Nyangka-pulanya watjarnu, “Mapitja-ya nyuntuku Puurrpa Mama Kuurrnga marninypuwa. Yaaltjirri-yan yanku?” ");
INSERT INTO ntj_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Nyangka Mawutjalu watjarnu, “Wiya, pirninyartu-latju yanku yirna, pampa tjilkutarrartu. Tjiinya-latju katja yurntalpatarrartu katiku puru tjiipu, nanikuurrpa puru puluka pirninyatarrartu. Tjiinya-latju mayu-mayu nyinarranytjalu mirrka, kuka ngalkula Mama Kuurrnga marninypuwa.” ");
INSERT INTO ntj_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Nyangka puurrpa Piirulu watjarnu, “Wiya! Minyma tjilkutarrartu-ya katinytjamaaltu wanti. Watikutju-yan palya yanku. Wiya-kulila-yan mayura kukurraalkitjalu kulira. ");
INSERT INTO ntj_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yuwa, mukurringkulanytjatjanu-yan palya watikutju yanku Mama Kuurrnga marninypungkukitja. Wantirra-rnipula mapitja.” Nyangka palunyaku yamatji pirnilu-pulanyaya payirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Maranku ma-kanyila ngurra Yiitjipulakutu. Nyangka-yayi tjintilyka pirnilu pakara pitja warta yukiri pirninya ngalkulayila wiyala, tjiinya marnkurr-marnkurrpa kunartatjanu ngaralanytjanya.” ");
INSERT INTO ntj_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nyangka mularrpartu Mawutjalunku wana ma-kanyirnu. Nyangka Mama Kuurrtu pirriya pakaltjingarnu. Nyangka kakarraranguru ngalyakukurraaralpi wangkarranytja. Palunyalu karlarlatjanu wangkarrayirnu mungarringu puru wangkarrayirnu tjirnturringu. Nyangka-ya wankarringkulalpi nyangu tjintilyka pirni-ya parrakukurraannyangka. ");
INSERT INTO ntj_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nyangka-ya ngurra Yiitjipula lipiwanartu nyina-nyinakatingu. Tjiinya-ya yarnangu pirnilu palunyapirinypa kutjuwarra nyakula wantirranytjamunu. Puru-ya palunyapirinypa marla nyakukitjamunu. Tjiinya palunyangkakutju-ya nyangu kata paarnarrarnu tjintilyka pirni-ya yartakarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Nyangka-ya manta yangatjura kanyiranytja. Nyangka yukiri marnkurr-marnkurrpa kunartatjanu ngaralanytja, palunyanya-ya ngalkulayirnu wiyarnu. Warta pirninya-ya ngalkulayirnu tarrkarnu. ");
INSERT INTO ntj_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Nyangka puurrpa Piirulu waarrpungkulalpi witurnu mapitjala-ya Mawutjanya-pulanya Yarannga yarltirra katitjaku. Nyangka-pulanyaya mularrpartu katingu ngaratjunu. Nyangka-pulanya watjarnu, “Wiya, palyamunulu-rna nyuntuku Puurrpa Mama Kuurrta tungunpungkulanytja, puru-rna nyuntuku wangka kulira wantirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Wiya, kutjuwarra-tju kalyparringkulalpi tjapila nyuntuku Puurrpa Mama Kuurrta. Nyangka-yayi tjintilyka pirninya wiyarriwa purnu pirninyartu ngalkula wiyaltjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Nyangka Mawutjalu puurrpa Piirunya wantirra yanu Mama Kuurrta tjapirnu tjintilyka wiyaltjaku. ");
INSERT INTO ntj_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nyangka kuliralpi Mama Kuurrtu pirriya kutjupanu. Nyangka yapurranguru ngalyakukurraarnu. Palunyalu tjintilyka pirninya katura katirrayirnu kapi purlkanyangka tjarrpatjunu. Nyangkalta-ya pirninyartu mirrirringu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nyangkalta Mama Kuurrtu puurrpa Piirunya yapupirinymanu witu-witu tirtu nyinarratjaku. Nyangka-tjananya Yitjurayilku tjamupirtinya tirtu marrkura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Maranku ma-kanyila yilkarikutu. Nyangkayi ngurra Yiitjipula lipiwanartu mungalurraala. Nyangka-ya purtu pantjurrmara parrapitjalayinma.” ");
INSERT INTO ntj_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Nyangka mularrpartu Mawutjalunku mara ma-kanyirnu yilkarikutu. Nyangka ngurra Yiitjipula lipiwanartu mungalurraarnu ngaralanytja. Ngaralayirnu ngurra marnkurrtjanu manta yartakarringu. ");
INSERT INTO ntj_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nyangka-ya Yiitjipunyamartatji pirnilu purtu nyakulanytja tjiinya mungalurraarnu ngaralanyangka. Palunyalu-yanku yiwarlangka kaninytjarra nyinarranytja. Parturtu Yitjurayilku tjamupirtiku ngurrawana-ya tjirntungka tirtu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Nyangka puurrpa Piirulu Mawutjanya yarltirralpi watjarnu, “Yuwa, palya-yan yanku Mama Kuurrnga marninypungkukitja. Yuwa, minyma tjilkutarrartu-ya palya yarra. Nyangka-kurlu-yan katiku tjiipu, nanikuurrpa puru pulukatarrartu. Wanti-ya.” ");
INSERT INTO ntj_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Nyangka Mawutjalu watjarnu, “Wiya, katiku-latjunku pungkula paara Mama Kuurrku nintilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tjiinya-latjunku yanamulpa pirninyartu katiku, kutjupa wantikitjamunulu. Tjiinya-latjunku pirningkatja miratjunku pungkula paara Mama Kuurrku nintilkitjalu. Kamu-latju kurranyulu ngurrkarntanku. Ngarna-latju yarla palunyakutu parrapitjalalpi ngurrkarntanku Mama Kuurrku nintilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nyangka Mama Kuurrtu puurrpa Piirunya yapupirinymanu witu-witu tirtu nyinarratjaku. Nyangka-tjananya wituntjamaaltu tirtu marrkura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Palunyalu Mawutjala watjarnu, “Wiya, mapitja kutipitja. Ngayulu-rnanta puru nyakukitjamunu. Tjingurun marlaku pitjanyangka-rna watjalku pungkulanta-ya mirrirntankutjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Nyangka Mawutjalu watjarnu, “Wiya, palyawu. Yanu-rna. Nyuntulu-rnin puru nyakukitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yuwa, pika kutjupa-kutjupa-rna yartakaranytja puurrpa Piiruku puru palunyaku yarnangu ngulytju pirniku. Palunyalu-rna kutjuwarrartu pika yartakanku. Nyangka-tjananyanta witulku. Tjiinya-tjananyanta pirninyartu payilku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Nyangka Yitjurayilku tjamupirti-tjananya watjala. Nyangka-yayi mapitja-tjananya ngurra ngamungkatjanya ngatjila. Nyangka-tjananyayi nintila marangkatja, lirringkatja kawurlpa tjilpatarrartu.” ");
INSERT INTO ntj_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Tjiinya Mama Kuurrtu-tjananya Yiitjipunyamartatji pirninya wuyurrmanu nintiltjaku-ya. Tjiinya-ya puurrpa Piiruku yamatji pirnilu puru palunyaku yarnangu ngulytju pirnilutarrartu-ya watjaranytja tjiinya Mawutjanya wati purlkanya. ");
INSERT INTO ntj_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Nyangka Mawutjalu puurrpa Piirula watjarnu, “Kulila. Mama Kuurrtu ngaapirinypa watjarnu, ‘Munga kultungka-rna ngurra Yiitjipulawana parrangarama. ");
INSERT INTO ntj_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Nyangka-tjanampanku katja kurranyungkatja pirninyartu mirrirriku. Tjiinya nyuntuku katja kurranyungkatja nyinarra marla puurrarrikitja, palunyanyatarrartu mirrirriku. Puru minyma mungutjaku katjatarrartu mirrirriku. Puru puluka pirniku katja kurranyungkatja pirninyatarrartu mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Nyangka-yan ngurra Yiitjipula lipiwanartu tjuni kartakatirralpi mirrarra yulama. Tjiinya-yan palunyapirinypa kutjulpirtu yularra wantirranytjamunu. Kuwarrinyakutju-yan purlkanya yulaku. Puru-yan palunyapirinypa marla yulakitjamunu. ");
INSERT INTO ntj_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nyangka Yitjurayilku tjamupirtiku ngurrawana-ya yulakitjamunu. Papatarrartu-ya yulakitjamunu. Tjiinyamarntu-ya tjuni kartakatikitjamunu. Nyangka-yan Yiitjipunyamartatji pirnilu nintilu kulinma tjiinya-rna ngayulu Mama Kuurrtu Yitjurayilku tjamupirti yayirninytjulu kanyira. Palunyalu-tjanamparnanku pika purlkanya yartakara.’” ");
INSERT INTO ntj_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Nyangka Mawutjalu puurrpa Piirunya tirtu watjaranytja, “Nyangka-ya nyuntuku yamatji pirnilu pitjaku ngayula pupakatirralpi kurrurntutarra-rniya watjalku ngayuku yungarrapirti-tjananya makatitjaku. Nyangkalta-latju yalatja yanku.” Nyangka Mawutjanya mirrparnpa purlkarringkulalpi puurrpa Piirunya wantirra yanu. ");
INSERT INTO ntj_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Tjiinya Mama Kuurrtu Mawutjala watjarnu, “Puurrpa Piirulunta kulilkitjamunu. Nyangka-rnayi ngurra Yiitjipulawana yayirninytjulu kutjupa-kutjupa yartakanama.” ");
INSERT INTO ntj_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Nyangka mularrpartu Mawutjalu-pula Yarantu yayirninytjulu kutjupa-kutjupa palyaranytja puurrpa Piirula mirangka. Nyangka Mama Kuurrtu-lu yapupirinymanu witu-witu tirtu nyinarratjaku. Nyangka-tjananya Yitjurayilku tjamupirti wituntjamaaltu tirtu marrkura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nyinarrayirnu-ya, nyangka Mama Kuurrtu-pulanya Mawutjanya Yarannga watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Tjiinya ngaanguru-yan kirnara nyakula ngurrkarntanama. Kirnara ngaanya ma-ngarringu, palunyanya-yan nyakula watjanma kirnara nampa 1-pa. ");
INSERT INTO ntj_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Yuwa, Yitjurayilku tjamupirti-tjananya watjala. Tjiinya-yayi nyawa kirnara ma-ngarrinyangka, palunyalu-yanku ngurra 10-tjanulu wati kutju-kutjulu tjiipu warlangu ngurrkarntanku kanyilku ngula pungkula ngalkukitjalu palunyaku kurri tjilku pirnilutarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nyangka watilu-tjinguru kulilku tjilku pirnimunulu tjiipu purtu ngalku wantiku. Palunyalu wati kutjarralu-pula yiwarla yitingka nyinarranytjalu palya lurrtjurringkulalpi tjiipu warlangu kutju pungku paalku ngalku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tjiipu pikatjarranya-ya wanti. Marnti kurlunypa walykumunu miratjurra kurli kutjutjanunya. Palya-yan mantjilku tjiipu warlangu tjinguru nanikuurrpa warlangu. ");
INSERT INTO ntj_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ngurrkarntaralpi-yankun katiku kanyilku. Palunyalu-yankun pirnilurtu ngurra kutjarra-kutjarratjanulu karrangka warlangu pirninya pungku. ");
INSERT INTO ntj_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Palunyalu-yan yirrami tiirrtjingka tjutiralpi tuu katuwana puru kantilywanalu parranyirtilku yiwarla palunyangka-yan nyinarra ngalkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mungangka-yan kuka paalku. Palunyalu-yan yukiri tjaa kampapayinya kukangka lurrtjuralpi ngalku. Puru-yan nyuma tjalpu ngalku. ");
INSERT INTO ntj_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kuka-kurlu-yan kana ngalku. Puru kapingka-kurlu-yan kurrkaltjunku. Yarnangurtu-yan warungka paalku wantiku, kata, tjarlpa, mukalatarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Yunguntjarraku-kurlu-yan tjunku wantiku. Purtu ngalkulanytjalu-yan ngarriku tjirnturringkulalpi tililku tjunku. Nyangka kampaku wiyalku. Tjiinyamarntu kuka palunyanya mungutjamunu. ");
INSERT INTO ntj_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Tjiinya-yanku warntu tjinatarrartu yalatjakitjalu tjarrpatjurra. Palunyalu-yanku wana mantjiralpi maraku ngamu kanyila. Palunyalu-yan yalatjakitjalu kuka waarrpungkulalpi ngalku. Ngalkula-rniyan kulinma tjiinya-tjananyarnanta munga palunyangka pungkutjamaalpa wantirra wayirntanku.” ");
INSERT INTO ntj_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Puru Mama Kuurrtu ngaapirinypa watjarnu, “Tjiinya-rna munga palunyangkartu parrangarama ngurra Yiitjipula lipiwanartu. Palunyalu-rna katja kurranyungkatja pirninya pungkula mirrirntanama. Puru yanamulpa pirniku katja kurranyungkatjatarrartu-tjananyarna pungkula mirrirntanama. Puru-tjanamparna tjukurrtatja pirninya pungku wiyalku. Tjiinya-rna ngayulu Mama Kuurrnga Puurrpa Purlkanya nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Nyangka yirrami nyirtirnu wantitjalu nintitjunku kaninytjarra-yan nyinarranyangka. Nyangka-rna pitjaku yirrami nyakula wayirntanku-tjananyarnanta. Palunyalu-tjananyarna Yiitjipunyamartatjinyakutju pungkula mirrirntanama. ");
INSERT INTO ntj_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Nyangka-yan kurli kutjupa kurli tjiipu warlangu pungkula ngalkulanytjalu kulinma tjiinya-rna nyangu tuungka nyirtirnu wantinyangka wantirra wayirntanu katja-tjanampanku wanka nyinarratjaku. Nyangka-rniya marlangkatja-marlangkatjalu yartakarringkulanytjalu tjiipu warlangu pungkula ngalkulanytjalu tirtu kulinma.” ");
INSERT INTO ntj_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Nyangka Mama Kuurrtu tirtu watjaranytja, “Yuwa, ngalku-kurlu-yan nyuma tjurltu-tjurltutjarra. Wanti-ya. Tjurltu-tjurltu pirninyartu-yan mantjilku warniku. Nyangka kutjupalu nyuma tjurltu-tjurltutjarra ngalkunyangka-yan marrkulku wantiku mungutja nyinarratjaku. Yuwa, nyuma tjalpu-yan ngalkulayilku ngurra 7-tjanulukutju nyuma tjurltu-tjurltutjarra puru paalku ngalku. ");
INSERT INTO ntj_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Nyangka tjirntu nyarra tjurltu-tjurltu-yan mantjilku warniku, palunyangka-yan waarkamaalpa nyinaku turlkuku lurrtjurriku. Palunyalu-yan ngurra 6-tjanulu puru waarkamaalpa nyinaku. Mirrkakutju-yan palyalku ngalku. Palunyalu-yan puru turlkuku lurrtjurriku. ");
INSERT INTO ntj_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kurli kutjupa kurli-yan nyuma tjalpu ngalkulanytjalu-rniyan tirtu kulinma tjiinya-tjananyarnanta Yiitjipulanguru pakaltjingara katingu. ");
INSERT INTO ntj_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Yuwa, kirnara kurlunypa ma-ngarriku. Nyangka-yan ngurra 14-tjanulu tjurltu-tjurltu mantjilku warniku. Palunyalu tjirntu tjarrpanyangka-yan nyuma tjalpu ngalku. Palunyalu-yan tirtu ngalkulayilku palunyalulta tjirntu nampa 21-ta tjirntu tjarrpanyangka-yan nyuma tjurltu-tjurltutjarra puru ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Tjiinya-yan tjurltu-tjurltu mantjilku warniku wiyartu nyinama. Nyangka-tjinguru kutjupalu, tjinguru nyuntuku yungarralu, tjinguru malikilutarrartu, nyuma tjurltu-tjurltutjarra ngalkunyangka-yan marrkulku wantiku mungutja nyinarratjaku. Nyangka ngurra 7-tjanulu-yan palya tjurltu-tjurltu puru kanyilku.” ");
INSERT INTO ntj_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Nyangka Mawutjalu Yitjurayilku tjamupirtiku-tjanampa liita pirninya yarltingu kutjungkaralpi watjarnu, “Yuwa, kutju-kutjulu-yankun tjiipu warlangu miratjuralpi pungku. Palunyalu-yan kurrirarralu tjilku pirnilu-yan ngalkula kulinma tjiinya Mama Kuurrtu-tjananyanta wayirntara mapitjaku, palunyanya. ");
INSERT INTO ntj_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nyangka-yan tjiipu pungkulalpi yirrami tjutilku tiirrtjingka. Palunyalu-yan nyarlpi kartarntaralpi yirramingka tjarrpatjunku. Palunyalu-yan yiwarla tuu katuwana puru kantilywanalu parranyirtilku. Palunyalu-yan tjarrpaku nyinaku tjirnturriku. ");
INSERT INTO ntj_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Nyangka Mama Kuurrnga Yiitjipulawana parrangaraku ngurrangkatja pirninya pungkula mirrirntankukitja. Palunyalu nyaku yirrami nyuntuku-tjanampanku yiwarlangka ngaralanyangka. Palunyalu Yayintjulpa Mirrirntankupayinya marrkulku nyuntuku-tjanampanku katja kurranyungkatja tjarrparra mirrirntankutjakutarra. ");
INSERT INTO ntj_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nyangka Yara Wayirntankutjanya tirtu ngaraku ngarama. Nyangka-ya nyuntuku-tjanampanku tjamupirtilu marlangkatja-marlangkatja pakaranytjalu yara palunyanya tirtu yarrkalpungama. ");
INSERT INTO ntj_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Nyangka-yan ngurra nyarra Mama Kuurrtu kalkurnu wantingu, palunyangka tjarrpaku nyinama. Palunyalu-yan yara Wayirntankutjanya tirtu yarrkalpungama. ");
INSERT INTO ntj_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Nyangka-tjanampanku tjilkulu-ya nyakulalpi tjapilku, ‘Nyaaku-yan tjiipu warlangu pungkula?’ ");
INSERT INTO ntj_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nyangka-yan watjalku, ‘Wiya, tjiipu-lan pungkula ngalkula tirtu kulilkitjalu tjiinya Yiitjipula Mama Kuurrtu-lampatju yiwarla wayirntara yanu. Tjiinya-tjananya ngurrangkatjakutju pungu mirrirntanu. Palunyalu ngayunya-lanyatju wantingu. Palunyanguru-lan ngalkula kulira.’” Nyangka-ya Yitjurayilku tjamupirtilu Mawutjaku wangka kuliralpi pupakatingu Mama Kuurrnga marninypungu. ");
INSERT INTO ntj_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Palunyalu-ya mularrpartu mapitjangu palyarnu Mama Kuurrtu Mawutjala-pulanya Yaranta watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nyangka munga kultungka Mama Kuurrtu Yiitjipunyamartatjiku katja kurranyungkatja pirninyartu mirrirntara-wanarnu wiyarnu. Tjiinya puurrpa Piiruku katja kurranyungkatja nyinarranytja marla puurrarrikitja, palunyanyatarrartu mirrirringu. Puru-ya tjayilpangka nyinapayi pirniku katja kurranyungkatja, puru yanamulpa pirniku katja kurranyungkatjatarrartu mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Nyangka munga palunyangkartu puurrpa Piirunya puru palunyaku yamatji pirninya puru palunyaku yarnangu ngulytju pirninya-ya tjulurraaralpi wankarringu. Pakarnu-ya mirrarra yularra punkaranytja katja kurranyungkatja-tjanampa mirrirringkula-wanarnu wiyarrinyangka, tjiinya yiwarla pirningkartu-ya mirrirringu ngarrirranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nyangka munga palunyangkartu puurrpa Piirulu watjarnu Mawutjanya-pulanyaya Yarannga yarltirra katirra ngaratjunkutjaku. Nyangka-pulanyaya mularrpartu katingu ngaratjunu. Nyangka watjarnu, “Wiya, pakara-ya kutipitja. Waarrpungkula-tjananya Yitjurayilku tjamupirti walara kati. Mapitja-ya Mama Kuurrnga marninypuwa, nyarra-pulan watjarnu wantitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Palunyalu-yanku puluka, tjiipu, nanikuurrpatarrartu kati. Palunyalu-tjuya ngayukutarrartu tjapinma. Nyangka-rni walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Nyangka-ya puurrpa Piiruku yarnangu ngulytju pirnilu pitjangu watjarnu, “Waarrpungkula-ya ngurra ngaanya wantirra pakara yarra pirninyartu-latju mirrirritjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Nyangka-ya nyuma kana tjurltu-tjurltumaalpa tiirrtjingka tjarrpatjuralpi warntungka karrpira katingu. ");
INSERT INTO ntj_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Puru tjiinya-ya Yiitjipunyamartatjingka-tjananya ngatjiranytja kutjupa-kutjupa walykumunuku, tjiinya marangkatja kawurlku, lirringkatja tjilpaku, pinangkatja kawurlku puru warntu walykumunkutarrartu, tjiinyamarntu Mawutjalu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Nyangka Mama Kuurrtu-tjananya Yiitjipunyamartatji pirninya kurrurnpa wuyurrmanu. Nyangka-ya kutjupa-kutjupa wangarnarralu nintiranytja. Nyangka-ya yulytja kutjupa-kutjupa walykumunu yalatjarringkula kutikatingu. Nyangka-ya Yiitjipunyamartatji pirnilu nintiralpi maralarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nyangka-ya Yitjurayilku tjamupirti yiwarla Ramatjinya wantirra pakara tjina kutipitjangu ngurra yini Tjakatjalakutu. Minga-minga-ya kutipitjangu. Wati 600,000-pa-ya puru minyma, tjilkutarrartu-ya pakara kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nyangka-ya yarnangu kutjupatjarratarrartu lurrtjurringkula yanu. Nyangka-ya yanamulpa pirni katingu tjiinya tjiipu, nanikuurrpa, pulukatarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nyangka-ya ngurra nyarra Tjakatjaku parrapitjalalpi nyuma tjalpu paarnu, tjiinya-ya mirrka kana Yiitjipulanguru katingu, palunyanya-ya paarnu ngalangu. Tjiinyamarntu-tjananya payirnu wiyannyangka-ya mirrka tamarlmankutjamaalpa pamparr-pamparrpa pakara yanu. ");
INSERT INTO ntj_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Nyangka tjiinya-ya Yitjurayilku tjamupirti Yiitjipula rawa nyinarranytja. Nyangkalta kurli 430-tjanulu Mama Kuurrtu-tjananya pirninyartu walara katingu. ");
INSERT INTO ntj_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tjiinya munga palunyangka Mama Kuurrtu-tjananya miranykanyira kanyiranytja Yiitjipulanguru pakaltjingara katikitjalu. Nyangka palunyanguru-ya munga palunyanya tirtu miirl-miirlpa kanyilpayi kulilkitjalu. Tjiinya-ya kunkunmaaltu kana nyinarranytjalu nyinarra kulinma Mama Kuurrtu-tjananya miranykanyiranyangka. Nyangka-ya marlangkatja-marlangkatja pakara-wanarayinkutjalu munga palunyanya miirl-miirlpa tirtu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nyangka Mama Kuurrtu Mawutjala-pulanya Yaranta watjarnu, “Tjiinya Yara Wayirntankutjanya ngaapirinypa ngarama. Malikilu kamu ngalku. ");
INSERT INTO ntj_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nyangka-tjinguru wati maliki nyuntulawana-tjananyanta tirtu waarka palyalpayilu mukurringku kuka palunyanya ngalkula kulilkitja. Wiya, ngarna watirringkulalpi ngalku. ");
INSERT INTO ntj_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nyangka malikilu ngarna nyinarranytjalu kamu ngalku. Puru kutjupalu tjimarrikitjalu waarka palyalpayilu kamu ngalku. ");
INSERT INTO ntj_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Nyangka-yan kuka palunyanya yiwarla kaninytjarra paaralpi kaninytjarrartu ngalku. Yilkaku-kurlu-yan katiku ngalkukitjalu. Puru-kurlu-yan tarrka kartarntanku. Wanti. ");
INSERT INTO ntj_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tjiinya-yan Yitjurayilku tjamupirti pirnilurtu ngalkula Wayirntankutjanya kulinma. ");
INSERT INTO ntj_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Nyangka-tjinguru maliki tjiinya nyuntulawana nyinapayinya mukurringku Wayirntankutjanya ngalkula Mama Kuurrnga kulilkitja. Wiya, ngarna watirringkulalpi ngalku. Tjiinya watirringkulalpi Yitjurayilku tjamupirinypa nyinama. Palunyalu palya ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Yuwa, maliki nyuntulawana nyinapayinya nyuntunyapirinypa nyinama. Ngarna watirringkulalpi kuka ngalkula Wayirntankutjanya kulinma.” ");
INSERT INTO ntj_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Nyangka-ya Yitjurayilku tjamupirtilu wangarnarralu kulira palyaranytja Mama Kuurrtu Mawutjala-pulanya Yaranta watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Nyangka tjirntu palunyangka Mama Kuurrtu-tjananya Yitjurayilku tjamupirti pirninyartu Yiitjipulanguru pakaltjingara katingu. ");
INSERT INTO ntj_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Yuwa, katja tirna-yanku kati ngayuku-tju nintila, puru yanamulpa pirniku katja kurranyungkatja. Tjiinyamarntu-ya Yitjurayilku tjamupirtiku katja tirnanya ngayuku nyinama. Puru-ya yanamulpa pirniku katja kurranyungkatjanya ngayuku nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Nyangka Mawutjalu-tjananya yarnangu pirningka watjarnu, “Yuwa, tjirntu kuwarrinya-yan Yiitjipunya wantirra pakarnu. Ngurra palunyangka-tjananyantaya pungkula kanyiranyangka Mama Kuurrtu-tjananyanta yayirninytjulu pakaltjingara katingu. Nyangka ngula-yan tjirntu ngaanya watarrkurrinytjamaaltu tirtu kulinma. Palunyalu-kurlu-yan ngalku nyuma tjurltu-tjurltutjarra. Nyuma tjalpukutju-ya ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Yuwa, kuwarrinya-lan ngurra Yiitjipunya wantirra pakarnu kirnara nampa 1-pa ngaranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tjiinya Mama Kuurrtu-tjananya tjamupirti kalkurnu wantingu ngurra walykumunu nintilkitjalu. Nyangka kuwarrinya-ya yarnangu kutjupatjarra ngurra palunyangka nyinarra: tjiinya Kayinanku tjamupirti, Yatjaku tjamupirti, Yayimuku tjamupirti, Yayipiku tjamupirti puru Tjipurrku tjamupirti. Tjiinya Mama Kuurrtu-tjananyanta katiku ngurra palunyangka tjarrpatjunku, mirrka kuka pirnitjarrangka. Nyangka-yan nyinarra ngalkunma. Palunyalu-yan kurli kutjupa kurli kirnara nampa 1-ta nyuma tjalpu ngalkula kulinma Mama Kuurrtu-tjananyanta Yiitjipulanguru pakaltjingara katinytjanya. ");
INSERT INTO ntj_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yuwa, nyuma tjalpu-yan ngalkulayilku, nyangka ngurra 6-tjanulu-yan mirrka kuka purlkanya ngalkula Mama Kuurrnga marninypungama. ");
INSERT INTO ntj_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tjiinya-yan tjurltu-tjurltu ngurrangka kanyiranytjalu mantjilku warniku wiyalku. Nyuntuku ngurra lipiwanalu-yankun palunyapirinypa palyalku. Palunyalu-yan nyuma tjalpu ngalkulayilku tjirntu 7-tjanulu-yan tjurltu-tjurltu kutjupa mantjiralpi nyuma tjurltu-tjurltutjarra puru paara ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Nyangka tjirntu palunyangka-yankun tjilku watjalku, ‘Tjiinya Mama Kuurrtu-lanyatju ngurra nyarra Yiitjipulanguru pakaltjingara katingu. Palunyangurungka-lan nyuma tjalpu ngalkula.’ ");
INSERT INTO ntj_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Tjiinya-yan nyuma tjalpu ngalkulanytjalu tirtu kulinma Mama Kuurrku wangka watjalkitjalu. Tjiinyamarntu Mama Kuurrtu-tjananyanta yayirninytjulu Yiitjipulanguru pakaltjingara katingu. ");
INSERT INTO ntj_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Palunyanguru-yan kurli kutjupa kurli kirnara nampa 1-ta tirtu nyuma tjalpu ngalkulanytjalu kulinma.” ");
INSERT INTO ntj_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Nyangka Mawutjalu-tjananya tirtu watjaranytja, “Yuwa, Mama Kuurrtu-tjananyanta katiku Kayinanku tjamupirtiku ngurrakutu, nyarra kutjulpirtu nyuntuku tjamu kalkurnu wantitjalu. Katiku-tjananyanta ngurra palunyakutu. Nyangka-yan yarnangu palunyanya-tjananya pungku wiyaralpi nyinama. ");
INSERT INTO ntj_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Palunyangka-yankun katja tirna pirninya Mama Kuurrku nintilku. Puru-yankun yanamulku katja kurranyungkatja Mama Kuurrku nintilku. ");
INSERT INTO ntj_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Nyangka-yan tungkiku katja kurranyungkatja kanyilkitjalu tjiipu warlangu pungkulalpi nintilku Mama Kuurrku. Wiyangka-tjinguru-yan tungki wantikitjalu ngurnti kartarntanku. Puru-yankun katja tirna marlakulu kanyilkitjalu kutjupa-kutjupa ngaparrtjika nintilku Mama Kuurrku. ");
INSERT INTO ntj_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Nyangka ngula-tjananyanta nyuntuku tjilkulu-ya tjapilku, ‘Nyaaku-yan yanamulku katja kurranyungkatja pungkula nintira Mama Kuurrku?’ Nyangka-yan watjalku, ‘Wiya, Mama Kuurrtu-lanyatju yayirninytjulu Yiitjipulanguru pakaltjingara katingu tjiinya-lanyatjuya pungkula kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tjiinya puurrpa purlkanya ngurra palunyangkatja witu-witulu-lanyatju tirtu marrkura kanyiranytja. Nyangka Mama Kuurrtu-tjananya Yiitjipunyamartatjiku katja tirna mirrirntanu puru yanamulku katja kurranyungkatja mirrirntanu. Palunyangurungka-lan yanamulku katja kurranyungkatja pungkula paara nintira Mama Kuurrku. Puru-lan kutjupa-kutjupa ngaparrtjika nintira tjiinya katja tirna-lanku marlakulu kanyilkitjalu.’ ");
INSERT INTO ntj_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Tjiinya-lan palunyapirinymaranytjalu kulinma Mama Kuurrtu-lanyatju yayirninytjulu Yiitjipulanguru pakaltjingara katingu.” ");
INSERT INTO ntj_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Nyangka puurrpa Piirulu-tjananya Yitjurayilku tjamupirti witunnyangka Mama Kuurrtu-tjananya kartakutjarra katinytjamunu ngurra nyarra Pilitjilawanalu. Tjiinya-tjinguru-ya ngurra palunyangkatja warrmarlarringkula pakannyangka tjiinya-ya wuyurrpa kurrarringkula marlaku yanku Yiitjipulakutu. ");
INSERT INTO ntj_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Palunyakutarra Mama Kuurrtu-tjananya Yitjurayilku tjamupirti tiwawanalu walara katingu ngurra mayu-mayuwanalu kapi yini Tjitirn-tjitirntakutu. Tjiinya wati pirninya-yanku kurlartatjarra-kurlartatjarra pitjalayintja. Tjiinya-ya tjarlpa kulira katirrayintja pikangkatarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Nyangka Mawutjalu Tjawutjaku mirri tarrka Yiitjipula mantjiralpi katirrayintja. Tjiinyamarntu Tjawutjalu wanka nyinarranytjalulpi watjarnu, “Mama Kuurrtu-tjananyanta ngula ngurra ngaanguru yarlangkatjura katiku. Nyangka-rniyan mirri mantjira makatiku.” ");
INSERT INTO ntj_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nyangka-ya Yitjurayilku tjamupirti ngurra nyarra Tjakatjanya wantirra mapitjalayirnu pila kantilytja ngurra tjunkulalpi ngarringu, ngurra yini Yiitjamala. ");
INSERT INTO ntj_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","Tjiinya karlarla mungangka Mama Kuurrtu-tjananya kurranyu mapitjalayintjalu nintitjuranytja-tjananya tjukarurru-ya mapitjalatjaku. Tjiinya karlarla ngangkarli wirrmiralu-tjananya murrungaralanytjalu nintitjura katirrayintja. Nyangka mungangka ngangkarli waru tilitjarrapirinypa kurranyu mapitjalayintja. Nyangka-ya nyakula wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Yitjurayilku tjamupirti-tjananya watjala. Nyangka-yayi pinkurraala ngurra tjurra yiwarla yini Paarayila yitingka, Paaltjipanta ngamu, tjiinya Mikatalta kapi Tjitirn-tjitirnta ngururrkutjarra. ");
INSERT INTO ntj_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Nyangka puurrpa Piirulu kulilku, ‘Wiya, parrakawarurringkula-ya ngururrkutjarra parrapitjalayirni pilalu-tjananya yangatjura kanyiranyangka.’ ");
INSERT INTO ntj_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nyangka-rnalu ngayulu puurrpa palunyanya yapupirinymanku witu-witu tirtu nyinarratjaku. Nyangka-tjananyanta ngurlura wanalku. Nyangka-tjananyarna ngayulu palunyaku warrmarla pirninya mirrirntanku wiyalku. Nyangkalta-rniya yarnangu manta lipingkatjalu kuliralpi marninypungama. Nyangka-ya Yiitjipunyamartatji pirnilu nintilu kulinma tjiinya ngayulu-rna Mama Kuurrnga Puurrpa Purlkanya nyinarra.” Nyangka-ya Yitjurayilku tjamupirtilu mularrpartu ngurra tjunu kapi purlkanyangka yitingka, tjiinya Mawutjalu-tjananya watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nyangka puurrpa Piirulu kulirnu Yitjurayilku tjamupirti-ya kukurraannyangka. Nyangka-yanku puurrpa Piirulu puru palunyaku yamatji pirnilu ngulakutju tjulurraaralpi watjarnu, “Wiya, nyaaku-lan witurnu? Nganalunyka-lampa waarka palyanma?” ");
INSERT INTO ntj_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Nyangka puurrpa Piirulu watjarnu palunyaku purni kaarrtjarra tamarlmara ngaratjunkutjaku. Puru watjarnu warrmarla pirnilu-ya riitikarraltjaku. ");
INSERT INTO ntj_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","8","Nyangka-ya kuliralpi kaarrpa walykumunu 600-pa riitikarrarnu puru kaarrpa kutjupatjarranya riitikarrarnu. Nyangka-ya puurrpa warrmarla pirninya pakara tati-tatira ngurlura-tjananya wanarnu. Tjiinya Mama Kuurrtu puurrpa Piirunya yapupirinymanu witu-witu tirtu nyinarratjaku. Nyangka-tjananya Yitjurayilku tjamupirti ngurlura wanarnu marlakunkukitjalu walykumunu-yanku pukurlpa mapitjalayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nyangka-ya warrmarla Yiitjipunyamartatji purni kaarrtjarralu puru purnitjarra pitjapayi pirnilu-tjananya ngurlura wanarayirnu nyangu kapi purlkanya nyarra Tjitirn-tjitirnta-ya nyinarranyangka, tjiinya yiwarla nyarra Paarayila-pulanya Paaltjipanta yitingka. ");
INSERT INTO ntj_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Nyangka-ya Yitjurayilku tjamupirtilu nyangu puurrpa Piirunya warrmarla pirnitjarra ngamuntirrinyangka-ya ngurluny-ngurlunyarringkula mirrarra tjapiranytja Mama Kuurrtu-tjananya yirringkankutjaku. ");
INSERT INTO ntj_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Palunyalu-ya Mawutjala mirrangu watjarnu, “Nyaaku-lanyatjun katingu? Pilangka mirrirritjaku-munta-lanyatjun walara katingu? Ngurra ngaangkakutju-munta-lampatju mirri tjurnutjunkutjaku ngarala? Wiya, tjinguru-lanyatjun wantima. Nyangka-latjunku Yiitjipula nyinarra yungarra wiyarringama. ");
INSERT INTO ntj_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Wiya, Yiitjipula nyinarranytjalulpi-latjunta purtu watjaranytja wantitjaku-lanyatjun nyangka-latju nyinarra waarka tirtu palyalkitjalu. Tjinguru-latju nyinarra waarka tirtu palyanma. Ngaanya-lan pitjangu pilangka mirrirrikitja.” ");
INSERT INTO ntj_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nyangka Mawutjalu watjarnu, “Wiya, nyaaku-yan ngurlurringkula? Ngurlumaaltu-ya ngarala nyakuma. Mama Kuurrtu-tjananyanta yayirninytjulu wankarunku. Nyangka-yan warrmarla palunyanya puru nyakukitjamunu. Tjiinya-ya wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tjiinya Mama Kuurrtu-tjananyanta paalytjunkula kanyinma. Nyangka-yan pika pungkutjamaaltu ngaralakutju nyakuma.” ");
INSERT INTO ntj_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Nyaaku-rnin mirrarra tjapira? Watjala-tjananya pakara kapikutu mapitjatjaku. ");
INSERT INTO ntj_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Palunyalunku wana mantjiralpi ma-kanyila kapi purlkanyakutu. Nyangkayi kapi tjarrarriwa. Nyangka-yayin Yitjurayilku tjamupirti manta tikirlpangka mapitjama. ");
INSERT INTO ntj_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nyangka ngayulu-tjananyarna Yiitjipunyamartatji pirninya yapupirinymanku witu-witu-ya tirtu nyinarratjaku. Nyangkalta-tjananyantaya kapiwanalu ngurlura wanalku. Nyangkalta-tjananyarna pirninyartu pungku wiyalku, puurrpa Piirunya, palunyaku warrmarla pirninya, palunyaku purni kaarrtjarra pirninya, puru wati purnitjarra pitjapayi pirninyatarrartu. Nyangkalta-rniya yarnangu manta lipingkatjalu kuliralpi marninypungama. ");
INSERT INTO ntj_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nyangka-ya Yiitjipunyamartatji pirnilu nintilu kulinma tjiinya ngayulu-rna Mama Kuurrnga Puurrpa Purlkanya nyinarranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Nyangka Mama Kuurrku yayintjulpa kurranyu-tjananya mapitjanytjatjanu pakara pitjangu marlarrkunguru ngaralanytja. Nyangka ngangkarli wirrmiratarrartu pitjangu marlarrkunguru ngarangu palunyalu yangatjura-tjananya kanyiranytja. Palunyalu-tjananya Yiitjipunyamartatji pirninya mungalurrmara kanyiranytja. Palunyalu Yitjurayilku tjamupirti yutira kanyiranytja. Nyangka-ya Yiitjipunyamartatji pirninya mungangka ngamuntirrikitja purtulirrirrayirnu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Nyangka Mawutjalunku mara ma-kanyirnu kapikutu. Nyangka Mama Kuurrtu pirriya purlkanya pakaltjingarnu. Nyangka kakarraranguru ngalyakukurraaralpi wangkarrayirnu tjirnturringu. Nyangka kapi wartutapirinypa ma-ngarangu. Nyangka ngururrkutjarra manta tikirlpa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Nyangka-ya Yitjurayilku tjamupirti wartutangka tjarrparra manta tikirlpangka mapitjalayinnyangka-tjananya kapilu wararrapirinytju kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Nyangka-ya Yiitjipunyamartatji pirnilu kapiwanalu-tjananya ngurlura wanarnu, puurrpa Piiruku purni kaarrtjarra pirnilu, puru purnitjarra pitjapayi pirnilu. ");
INSERT INTO ntj_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nyangka tjirntukutu Mama Kuurrtu ngangkarli tilingurulu-tjananya walunyakulalpi walykurnu. Nyangka-ya purtu kuli-kulirnu. ");
INSERT INTO ntj_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tjiinya-tjanampa wiilpa kaarrtatja pilkingka nganytjarnu. Nyangka-ya purtu wala-walaranytja wanalkitjalu-tjananya. Palunyalu-ya watjaranytja, “Wiya, Mama Kuurrtu-tjananya Yitjurayilku tjamupirti paalytjura kanyira palunyalu ngayunya-lanya walykura kanyira. Nyangka-lanku wantirra marlaku yarra.” ");
INSERT INTO ntj_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Maranku puru ma-kanyila kapi purlkanyakutu. Nyangka-tjananyayi marlakurri tjarrpatjurra Yiitjipunyamartatji pirninya, palunyaku-tjanampa purni kaarrtjarra pirninya puru wati purnitjarra pitjapayi pirninya.” ");
INSERT INTO ntj_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Nyangka mularrpartu Mawutjalu munga-mungangka maranku kapikutu ma-kanyirnu. Nyangka kapi marlakurringu yungarranyartu ngarrirranytja. Nyangka-ya Yiitjipunyamartatji pirni purtulirrirranytja kukurraalkitja. Nyangka wartalpitjanu Mama Kuurrtu-tjananya kapingka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tjiinya kapi marlakurrirranytjalu-tjananya tjarrpatjunu purni kaarrtjarra pirninya, wati purnitjarra pitjapayi pirninya, puru warrmarla pirninya. Nyangka-ya pirninyartu kapi ngukurayirnu mirrirringu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Nyangka-ya Yitjurayilku tjamupirti manta tikirlpangka mapitjalayirnu yitipirringu kapilu-tjananya kutjarrangurulu wararrapirinytju kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Nyangka tjiinya Mama Kuurrtu-tjananya wankarunu Yiitjipunyamartatjilu-tjananya pungkutjakutarra. Nyangka-ya nyangu mirri pirninya kapi kantilytja ngarrirranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tjiinya Mama Kuurrtu-tjananya yayirninytjulu mirrirntanu purrultjunu. Nyangka-ya Yitjurayilku tjamupirtilu nyakulalpi ngurluny-ngurlunyarringu. Palunyalu-ya Mama Kuurrku mula-mularringu. Puru-ya Mama Kuurrku waarka palyalpayi Mawutjakutarrartu mula-mularringu. ");
INSERT INTO ntj_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Nyangka-ya Mawutjalu puru yarnangu pirnilutarrartu turlku ngaanya yinkarra Mama Kuurrnga marninypungkulanytja: “Mama Kuurrnga-rna yinkarra marninypungama. Mama Kuurrnga wina mularrpa. Purni pirninya-tjananya kapingka warningu tjarrpatjunu, puru purnitjarra pitjapayinyatarrartu. ");
INSERT INTO ntj_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mama Kuurrtu-rni waku purlkanyalu wankarura kanyilpayi. Nyangka-rnalu marninypungama. Mama Kuurrtu-tju tjamupirti kanyiranytja. Nyangka-rna turlku yinkarra marninypungama Puurrpa Purlkanya nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mama Kuurrnga warrmarla purlkanya. Palunyanya yini Yaawayinya. ");
INSERT INTO ntj_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Palunyalu puurrpa Piiruku warrmarla pirninya puru purni kaarrtjarra pirninya kapingka warningu tjarrpatjunu. Nyangka-ya warrmarla puurrpa pirninya mirrirringu kapi ngaa Tjitirn-tjitirnta. ");
INSERT INTO ntj_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kapi katuwana ngarrirranyangka yapupirinypa-ya tjarrpangu tirtu ngarrirra. ");
INSERT INTO ntj_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mama, nyuntulun mara waku purlkanyalu yanyan-yanyanpa nyinapayinya pungkula mirrirntara wiyalpayi. ");
INSERT INTO ntj_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nyuntulun wina mularrpa. Yanyan-yanyanpa nyinapayi-tjananyan pungkula wiyalpayi. Yuwa, mirrparnarrirralpi-tjananyan pungkula-wanara wiyalpayi. Warulukurlu tjanpi kampa wiyala, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Mama, nyuntulun kapi puurnu tjarrarnu. Nyangka wararrapirinypa ngaralanytja. Nyangka manta kapi kaninytjarrangkatjanya yartakarringkulalpi yiwarrapirinypa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tjiinya-ya yanyan-yanyanpa nyinapayilu watjarnu, ‘Wanalku-latju tjulyalku. Wuyurrarringkulalpi-latju yulytja-tjanampa tjarralku kanyinma. Kunmarnu purlkanya yarraralpi-latju wakalku mirrirntaralpi yulytja-tjanampa mantjira katiku.’ ");
INSERT INTO ntj_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nyangka nyuntulun kapi puurnu. Nyangkalta-tjananya tjuturnu mirrirntanu. Nyangka-ya yapupirinypa tjarrpangu tirtu ngarrirra. ");
INSERT INTO ntj_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Mama Kuurr, tjukurrtatja kutjupa nyuntunyapirinypa nyinanytjamunurtu. Nyuntulun kutju mularrpa nyinarra. Puru nyuntulukutjun tjukarurru nyinapayi. Kutjupalu palunyapirinypa kamu palyalku. Ngarna nyuntulun yayirninytjulu kutjupa-kutjupa palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nyuntulunkun mara ma-kanyirnu. Nyangka mantalu-tjananya yanyan-yanyanpa nyinapayinya kuurltjunu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nyangkankun katja yurntalpirti wankarunu. Palunyalu-tjananyan mukulyanytjulu puru waku walykumunulu katirrayirnu tjarrpatjunu, ngurra nyarra nyuntulun nyinarra, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Nyangka-ya yarnangu kutjupa-kutjupalu kuliralpi ngurlu tiltirrmarayirnu nguwanpa punkarnu mirrirringu. Ngurra Pilitjila nyinapayilu-ya kuliralpi ngurluny-ngurlunyarringu. ");
INSERT INTO ntj_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Nyangka-ya Yiitamala nyinapayiku puurrpa pirninya ngurluny-ngurlunyarringu nyinarranytja. Nyangka-ya Mawapala nyinapayiku puurrpa pirninya ngurlu tiltirrmaranytja. Puru-ya yarnangu Kayinanta nyinapayi pirninya ngurlurringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Yuwa Mama Kuurr, purlkanya-ya ngurlurringu. Tjiinya-ya kulirnu nyuntulun waku purlkanyalu palyaranyangka. Kuliralpi-ya ngurlu tiltirrmaranytja nyuntuku katja yurntalpirti-ya watipitjalayinnyangka. Tjiinya-tjananyan Yiitjipulanguru yarlangkatjura katingu, puurrpa palunyaku waarka tirtu palyaratjakutarra. ");
INSERT INTO ntj_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Palunyalu-tjananyan katingu nyinatjunu nyuntuku yapungka, ngurra nyarra nyuntulun ngurrkarntanu nyinakitjalu, palunyangka. Tjiinyan nyinakitjalu ngurra yungarralu palyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yuwa Mama Kuurr, nyuntulun Puurrpa Purlkanya tirtu nyinaku nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Nyangka tjiinya-ya Yitjurayilku tjamupirti kapingka ngururrkutjarra manta tikirlpangka mapitjalayirnu yitipirringu. Nyangka-ya Yiitjipunyamartatji warrmarla puru purni kaarrtjarra puru purnitjarra pitjapayinyatarrartu marlawana mapitjalayinnyangka Mama Kuurrtu kapi marlakuralpi-tjananya tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nyangka Yaranku tjurtu Miriyamalu tjiinya Mama Kuurrku wangka kulira tjakultjunkupayilu tingki-tingkipirinypa mantjira pakarnu turlku yinkakitjalu. Nyangka-ya minyma pirnilu nyakula wanarnu tingki-tingkipirinypa pungku-pungkula yinkarra nyarnpirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Nyangka Miriyamalu turlku ngaapirinypa yinkangu: “Mama Kuurrnga-la yinkarra marninypungama. Mama Kuurrnga wina mularrpa. Purni pirninya-tjananya kapingka yangatjuturnu, purnitjarra pitjapayinyatarrartu.” ");
INSERT INTO ntj_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Nyangka-ya kapi Tjitirn-tjitirnnga wantirra pakarnu. Nyangka Mawutjalu-tjananya pila yini Tjuralawanalu walara katingu. Nyangka-ya pitjalayirnu-pitjalayirnu ngurra kutjarratjanulu kapiku purtu ngurriranytja. ");
INSERT INTO ntj_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Pitjalayirnu-ya parrapitjangu kapi yini Maaranya purtu tjikira yarrkaranytja. Tjiinyamarntu kapi kumpuwalyku ngarrirranytja. Palunyalu-ya yini tjapirnu Maaranya. Tjiinya wangka palunyanya ngaapirinypa, Kumpuwalykunya. ");
INSERT INTO ntj_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Nyangka-ya yarnangu pirnilu mirrparn-mirrparnarrirralpi Mawutjala watjarnu, “Wanytjanyanyka-latju kapi tjikilku?” ");
INSERT INTO ntj_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Nyangka Mawutjalu kurrurntutarra Mama Kuurrnga kapiku tjapirnu. Nyangka-lu nintitjunu warta ngaralanyangka. Nyangka kartarntaralpi kapingka warningu tjarrpatjunu. Nyangka walykumunurringu. Nyangka-ya tjikiranytja. Ngurra palunyangka-ya nyinarranyangka Mama Kuurrtu-tjananya wangka pirni watjaranytja. Kulira-yayi walykumunu nyinama. Palunyalu-tjananya tjapirnu, “Ngayunya-munta-rniyan mularrkulira?” ");
INSERT INTO ntj_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Palunyalu puru tjapirnu, “Wangarnarralu-munta-yan kulira palyanma ngayulu-tjananyarnanta tjurrkurlmara watjaranyangka? Palunyangka-tjananyarnanta pikatjarrantjamaaltu wantiku, nyarra ngayulu-tjananyarna Yiitjipunyamartatji pikatjarrarnu, palunyapirinypa. Tjiinya-tjananyarnanta ngayulu Mama Kuurrtu pika wankalpayi.” ");
INSERT INTO ntj_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Nyangka-ya pakara pitjalayirnu kapi yini Yiilimuku parrapitjangu ngurra tjunu. Palunyangka kapi warla 12-pa ngaralanytja. Puru-ya warta walykumunu mirrkatjarra pirni ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nyangka-ya Yiilimunya wantirra pakara mapitjalayintja pila yini Tjiintakutu, tjiinya Yiilimula Tjayinayila ngururrpa ngaralanyangka. Tjiinya-ya Yiitjipunya wantirra pitjalayirnu kirnara kutjupa purlkanya ngaralanyangka parrapitjangu pila palunyalakutu. ");
INSERT INTO ntj_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ngurra palyamunuwana-ya pitjalayintjatjanu mirrkatjirratja nungkumunurringu. Palunyalu-pulanyaya mirrparn-mirrpantu Mawutjanya Yarannga ");
INSERT INTO ntj_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","watjaranytja, “Wiya, Mama Kuurrtu-tjinguru-lanyatju Yiitjipula nyinarranyangkalpi mirrirntanama. Ngurra nyarrangka-latju mirrka kuka purtu ngalkula parltjarringkula wantipayi. Nyangka nyuntulu-pulan ngurra palyamunuwanalu katirrayirni parltjamunura mirrirntankukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","5","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yuwa, ngayulu-tjanamparnanku mirrka nintilku. Nyangka yilkaringuru kapipirinypa punkalku. Nyangka-yan yarnangu pirnilu yurralku tjirntu palunyangkartu parltjarrikitjalu. Palunyalu-yankun tjirntu kutjupa tjirntu tirtu yurrara ngalkunma. Nyangka-yankun tjirntu Puratingka yurralku tjirntu kutjarraku ngarnmanymanku kanyilku Tjatitikutarrartu tjiinyamarntu miirl-miirlpa ngaralanyangka. Nyangka-tjananyarnanta nyaku, ‘Mularrpa-munta-rniyan ngayuku wangka wangarnarralu kulira palyanma?’” ");
INSERT INTO ntj_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Nyangka Mawutjalu-pula Yarantu Yitjurayilku tjamupirti-tjananya watjarnu, “Nyinaku-yan karrangka nyaku mula-mularriku tjiinya-tjananyanta Mama Kuurrtu Yiitjipulanguru katingu kanyira. ");
INSERT INTO ntj_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Palunyalu-yan ngarriku tjirnturringkulalpi nyaku Mama Kuurrtanguru tilingaralanyangka. Tjiinya palunyalu-tjananyanta kulirnu mirrparn-mirrparntu-yan payiranyangka. Tjiinya ngayunyakutju-linyatjuyan payintjamaalpa, Mama Kuurrngatarrartu-yan payira. Tjiinya-litju yungarralu palyaranytjamunu. Ngarna palunyalu watjaranyangka-litju kulira palyara.” ");
INSERT INTO ntj_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Nyangka Mawutjalu-tjananya tirtu watjaranytja, “Yuwa, karrangka Mama Kuurrtu-tjanampanku kuka nintilku. Palunyalu tjirntungka-tjanampanku mirrka nintilku ngalkula-yan parltjarritjaku. Tjiinya-tjananyanta kulirnu mirrparn-mirrparntu-yan payiranyangka. Tjiinya-linyatjuyan ngayunyakutju payintjamaalpa, Mama Kuurrngatarrartu-yan payira.” ");
INSERT INTO ntj_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Nyangka Mawutjalu Yarannga watjarnu, “Watjala-tjananya nyangka-yayi pitja Mama Kuurrta ngara. Tjiinya-tjananya kulirnu mirrparn-mirrparntu-ya payiranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Nyangka mularrpartu Yarantu-tjananya watjarnu, “Pinkurraaralpi-ya ma-nyawa.” Nyangka-ya mularrpartu pinkurraarnu pilakutu ma-nyangu Mama Kuurrku tili purlkanya ngangkarli wirrmiranguru pirntalarrarnu warupirinypa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nyangka Mama Kuurrtu Mawutjala watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Kulirnu-rna Yitjurayilku tjamupirtilu-rniya mirrparn-mirrparntu payiranyangka. Ngaapirinypa-tjananya watjala, ‘Karrangka-ya kuka ngalku. Palunyalu-ya tjirntungka mirrka ngalku parltjarriku. Palunyalu-ya nintilu kulilku tjiinya-tjanamparnanku ngayulu Puurrpa Mama Kuurrnga nyinarranyangka.’” ");
INSERT INTO ntj_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nyangka mularrpartu tjurlpu mantayurntilpa-ya karrangka pitja-pitjangu ngurrangka nyina-nyinakatingu. Nyangka-ya minga-minga nyangu nyinarranyangka. Nyangka tjirntungka-ya nyangu kulyarrpa purlkanya wartungaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nyangka kulyarrpa ngarringu wiyarrinyangka mirrka kutjupa-kutjupa pirntalpa ngarrirranytja walukarrapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Nyangka-ya Yitjurayilku tjamupirtilu ngurrpa-ngurrpalu purtu yayirnirrirra tjapiranytja, “Nyaapa ngaanya?” Nyangka Mawutjalu watjarnu, “Wiya, Mama Kuurrtu-tjanampanku mirrka nintirnu ngalkula-yan parltjarritjaku. ");
INSERT INTO ntj_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tjiinya watjarnu wantingu mirrka-yankun yurrara katitjaku ngurrakutu. Nyangka-yayi yungarrapirtilu-yungarrapirtilu ngala parltjarriwa. Tjiinya-yan yurralku wayatjarrangka tjutira katiku-tjanampa parranintinma.” ");
INSERT INTO ntj_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Nyangka-ya mularrpartu yurraranytja. Kutjupatjarralu-yanku purlkanya yurraranytja. Nyangka kutjupatjarralu-yanku kurlunypa yurraranytja. ");
INSERT INTO ntj_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nyangka-ya tjilku pirnitjarralu purlkanya yurraranytjatjanulu katingu tjarraralpi parranintirnu-tjanampa. Palunyalu nyangu, “Munta, tjukarurru-watjala-rna yurrarnu.” Nyangka kutjupalu kurlunypa yurraralpi katingu nyangu, “Munta, palya-watjala-rna yurrarnu.” ");
INSERT INTO ntj_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Nyangka puru Mawutjalu-tjananya ngaapirinypa watjarnu, “Tjunku-kurlu-yan wantiku yunguntjarraku.” ");
INSERT INTO ntj_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nyangka-ya kutjupatjarralu wangka kulira wantirranytjalu tungun-tunguntu tjunu wantingu. Palunyalu-ya ngarringu tjirnturringkulalpi pakarnu nyangu yurnarringkulalpi kartilykarrinyangka. Nyangka Mawutjanya-tjanampa mirrparnarringu. ");
INSERT INTO ntj_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nyangka-ya tjirntu kutjupa tjirntu yurrara parltjaku ngalkulanytja. Nyangka tjirntu ngalyapakaranytjalu kamparra yirralankupayi mantangka tirtu ngarrirranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Nyangka-ya Puratingka mirrka purlkanya yurraranytja tjirntu kutjarraku. Nyangka-ya liita pirnilu pitjangu Mawutjala tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Nyangka-tjananya watjarnu, “Yuwa, palya. Tjiinya Mama Kuurrtu watjarnu wantingu tjirntungka-yanyun waarka wiya nyinama. Tjiinya miirl-miirlpa purlkanya ngarala tjiinya-yan nyinarra Mama Kuurrnga marninypungkutjaku. Kuwarrinya-yan wuyurrarringkulalpi mirrka palunyanya paalku. Wiya-tjinguru-yan wuyurrarringkulalpi kurrkaltjunku. Palunyalu purtu ngalkulalpi-yan yunguntjarraku tjunku wantiku.” ");
INSERT INTO ntj_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Nyangka Mawutjalu watjarnu wantinyangka-ya mularrpartu yunguntjarraku tjunu wantingu. Nyangka yurnarringkutjamaalpa puru kartilykarrinytjamaalpa ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Nyangka Mawutjalu-tjananya watjarnu, “Mirrka pala-yan kanyiranytjatjanulu ngala wiyala. Tjiinyamarntu tjirntu ngaanya miirl-miirlpa ngarala Mama Kuurrnga-yan marninypungkutjaku. Yilkaku-yan mapitjaku purtu nyaku mirrka ngarrirratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tjiinya-yan tjirntu kutjupa tjirntu mirrka yurranma. Palunyalu-yan Tjatitingka purtu nyaku wiyarrinyangka. Tjiinya tjirntu palunyangka-yan waarkamaalpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Nyangka-ya yarnangu kutjupatjarralu Tjatitingka mapitjangu mirrkaku purtu nyakulanytja wiyarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Nyangka Mama Kuurrtu yarnangu pirniku kaarr-kaarrarringkulalpi Mawutjala watjarnu, “Tirtu-munta-yan ngayuku wangka kulira wantima? ");
INSERT INTO ntj_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kulila-ya. Ngayulu Mama Kuurrtu-tjanamparnanku tjirntu kutju yaka-yakarnu wantingu waarkamaalpa-yan nyinarratjaku. Palunyanguru-rna Puratingka tjirntu kutjarraku mirrka nintinma. Nyangka-yan Tjatitingka ngurrangka nyinama.” ");
INSERT INTO ntj_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nyangka-ya mularrpartu Tjatitingka waarkamaalpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Nyangka-ya Yitjurayilku tjamupirtilu mirrka palunyanya tjaa yungarralu tjapirnu “mana”. Tjiinya mirrka palunyanya walukarrapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Nyangka Mawutjalu watjarnu, “Mama Kuurrtu-lanya watjarnu wantingu mirrka palunyanya-lanyun puturlta tjarrpatjuralpi kanyiratjaku. Nyangka-yayi marlangkatja-marlangkatja pakaranytjalu tirtu nyangama, ‘Ngaanya-watjala Mama Kuurrtu-tjananya Yiitjipulanguru pilawanalu katirrayintjalu nintiranytja ngalkulatjaku-ya.’” ");
INSERT INTO ntj_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nyangka Mawutjalu Yarannga watjarnu, “Wayatjarra kutjungka yurraralpi puturlpa kutjungka tjutila. Palunyalu tiinti miirl-miirlta tjurra tirtu ngaralatjaku. Nyangka-yayi marlangkatja-marlangkatjalu nyangama.” ");
INSERT INTO ntj_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Nyangka Yarantu mularrpartu puturlta tjarrpatjuralpi tjunu puuka miirl-miirlta yitingka. Nyangkayi tirtu ngarama. ");
INSERT INTO ntj_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Nyangka-ya Yitjurayilku tjamupirtilu mirrka mana parrangalkulayirnu kurli 40-tjanu parrapitjangu ngurra Kayinanta ngurrararringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nyangka-ya Yitjurayilku tjamupirtilu kuwarripa pitjalayintjalu pila nyarra Tjiinnga wantirra pakara kutipitjangu. Palunyalu-ya ngurra kutjupa-kutjupaku mapitjalayintja Mama Kuurrtu-tjananya watjaranyangka. Pitjalayirnu-ya ngurra yini Ripitimiku parrapitjangu. Palunyalu-ya kapi purtu nyangu. ");
INSERT INTO ntj_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Palunyalu-ya Mawutjaku mirrparn-mirrparnarringu watjarnu, “Kapi-lampatju nintila tjikiltjaku.” Nyangka Mawutjalu-tjananya watjarnu, “Nyaaku-rniyan mirrparnarringkula payira? Nyaaku-yan puurlpa kuliranytjalu Mama Kuurrnga witu-witura?” ");
INSERT INTO ntj_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Nyangka-ya kapitjirratjalu Mawutjanya tirtu payiranytja, “Nyaaku-lanyatjun Yiitjipulanguru katingu? Kapitjirratja-munta-lanyatjun mirrirntankukitjalu katingu? Puru-lampatjun tjilku yanamulpatarrartu pilawanalu katirrayirni mirrirntankukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Nyangka Mawutjalu Mama Kuurrnga kurrurntutarra tjapirnu, “Wiya, yaaltjingalku-tjananyarna yarnangu pirninya? Tjiinya-rniya mirritjura yatura mirrirntankukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nyangka Mama Kuurrtu-lu watjarnu, “Liita kutjupatjarra yarltirra ma-kurranyurrirra mapitja. Nyangka-yayi yarnangu pirnilu marlawanalu wanala. Purunku wana kati, tjiinyan kapi Nayilnga pungkutjalu. ");
INSERT INTO ntj_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nyangka ngayulu-rnanta yapungka ngalyangaraku yapu Tjayinayila ngamu. Nyangkan yapu palunyanya pungku. Nyangka kapi tjutiku pirnilu-ya tjikiltjaku.” Nyangka mularrpartu Mawutjalu mapitjangu yapu pungu. Nyangkalta kapi tjutingu liita pirningka mirangka. ");
INSERT INTO ntj_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Nyangka Mawutjalu ngurra palunyanya tjapirnu yini Matjanya puru Miripanya. Tjiinya yini Matjanya ngaapirinypa, Puurlpa Kulira Witu-witulpayinya. Nyangka yini Miripanya ngaapirinypa, Mirrparn-mirrparntu Payilpayinya. Tjiinya-ya Mama Kuurrnga puurlpa kuliranytjalu tjapiranytja, “Mularrpa-munta Mama Kuurrnga-lanya nyinarra? Wiya-kulila tjinguru-lanya wantirra yanu.” ");
INSERT INTO ntj_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Nyangka-ya Yitjurayilku tjamupirti ngurra nyarra Ripitimila nyinarranyangka wati Yamalikiku tjamupirti-ya warrmarlarrirra pitjangu-tjananya pika pungkukitja. ");
INSERT INTO ntj_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nyangka Mawutjalu wati yini Tjatjuwala watjarnu, “Wati-tjananya ngurrkarntarra warrmarlarrirra-ya mapitjala Yamalikiku tjamupirti ngaparrtjika pika pungkutjaku. Nyangka tjirntungka-rna wana mantjiralpi yapungka tatilku ngaraku. Wana nyarra Mama Kuurrtu-rni watjarnu katitjaku, palunyatjarra-rna ngaraku.” ");
INSERT INTO ntj_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Nyangka Tjatjuwalu mularrpartu wati-tjananya yarltirra warrmarlarrirra yanu Yamalikiku tjamupirti pika pungkulanytja. Nyangka-ya Mawutjanya, Yarannga, puru wati kutjupanya yini Yuuwanya yapu katu tatirnu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Nyangkanku Mawutjalu maralu wana katuralpi kanyiranytja. Nyangka palunyapirinypa ngaranyangka Yitjurayilku tjamupirtilu-ya Yamalikiku tjamupirti pungkula wiyaranytja. Nyangka Mawutjalu yamirri patalyarringkulalpi tjunkunyangka Yamalikiku tjamupirtilu-ya Yitjurayilku tjamupirti pungkula wiyaranytja. ");
INSERT INTO ntj_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Nyangka Mawutjanya yamirri patalyarringu. Nyangka Yarantu-pula Yuuwalu yapu yurnturalpi tjunu Mawutjanya nyinakatitjaku. Palunyalu-pula ngantjarrpa-ngantjarrpa ngaralanytjalu palunyaku mara witurrpungkulalpi katura kanyirayirnu tjirntu tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nyangka Tjatjuwalu-ya Yamalikiku tjamupirti pungkulayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Tjukurrpa ngaanya ruulangka walkatjurra wanti watatjarritjakutarra. Nyangka marlangkatja-marlangkatja pirnilu-yayi nyakula kulinma. Puru nyakula watjala Tjatjuwalu kuliltjaku. Tjiinya-rna Yamalikiku tjamupirti pungku wiyalku. Nyangka ngula kutjupalu-tjananya kulilkitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Nyangka Mawutjalu yapu pirninya tjunkula parrawanarnu katurnu. Palunyalu kuka pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu yini tjapirnu, Yaawayinya-lampa Yangakanyilpayinya. ");
INSERT INTO ntj_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Palunyalu watjarnu, “Mara-lanku katula Mama Kuurrtakutu. Tjiinya palunyalu Yamalikiku tjamupirti tirtu pungama.” ");
INSERT INTO ntj_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Nyangka Mawutjaku waputju, Tjatjarunya, ngurra nyarra Mitiyanta nyinarranytja. Palunyalu nyinarrayirnu tjakulpa kulirnu tjiinya Mama Kuurrtu-tjanampa Mawutjaku puru Yitjurayilku tjamupirtiku kutjupa-kutjupa palyaranytja Yiitjipulanguru katirrayintjalu. ");
INSERT INTO ntj_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Tjiinya wati palunyalu kanyiranytja Mawutjaku kurri Tjipuranya puru palunyaku katja kutjarra Kutjamanya puru Yalitjanya. Tjiinya Mawutjalunku kurri marlakulu witurnu yankula palunyaku mamangka kuwarripa nyinatjaku. Tjiinya Mawutjalu katja kurranyungkatja tjapirnu yini Kutjamanya. Palunyalu watjarnu, “Ngayulu-rna ngurra ngaangka maliki nyinarranytja.” ");
INSERT INTO ntj_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Palunyalu katja marlangkatjanya tjapirnu yini Yalitjanya. Palunyalu watjarnu, “Mama Kuurrtu tjiinya ngayuku mamalu pupakatirra marninypungkupayilu-rni yirringkanu. Palunyalu-rni wankarunu puurrpa Piirulu-rni pungkutjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Nyangka Tjatjarulu Mawutjaku kurri puru palunyaku katja kutjarra yarltirra pakara kutipitjangu Mawutjalakutu, pila nyarra Mama Kuurrku yapu miirl-miirlta yitingka nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Nyangka wati kutjulu pitjangu Mawutjala watjarnu, “Nyuntuku waputju Tjatjarunya pitjalayirni. Nyuntuku kurri puru katja kutjarra-pulanya katirrayirni.” ");
INSERT INTO ntj_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Nyangka kulira ngata-ngata mapitjangu-tjananya lurrtjurrikitja. Palunyalu Tjatjarunya nyakulalpi pupakatingu palunyalu pakaralpi nguku kutjarra nyunytjurnu. Nyangka-pulanku pukurlpa wangkarra wiyarringkulalpi Mawutjaku tiintingka tjarrpangu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Nyangka Mawutjalu waputjungka tjukurrpa pirni tjakultjuranytja tjiinya Mama Kuurrtu-tjanampa puurrpa Piiruku puru Yiitjipunyamartatji pirniku pika purlkanya yutiranytja Yitjurayilku tjamupirti pakaltjingara katikitjalu. Puru tjakultjuranytja tjiinya-ya pilawana pitjalayintjalu purtu kuliranytja. Nyangka Mama Kuurrtu-tjananya yayirninytjulu yirringkaranytja. ");
INSERT INTO ntj_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nyangka Tjatjarulu kuliralpi pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Palunyalu watjarnu, “Yuwa, Mama Kuurrnga walykumunu mularrpa. Mama Kuurrtu yayirninytjulu palyalpayi. Tjiinya-tjananyanta yarlangkatjura katingu Yiitjipunyamartatjilu-tjananyanta tirtu pungkula kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kuwarri-rna nintirringu tjiinya Mama Kuurrnga purlkanya mularrpa, tjukurrtatja kutjupatjarrangka munkarra. Tjiinyamarntu-tjananyanta yayirninytjulu pakaltjingara katingu Yiitjipunyamartatjilu-tjananyantaya karnany-karnanytju tirtu pungkula kanyiranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nyangka Tjatjarulu tjiipu katingu. Palunyalu pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu tjiipu kutjupatjarra katingu pungu paaralpi kutjupatjarra Mama Kuurrku nintirnu. Palunyalu kuka kutjupatjarra tjarraralpi tjunu lurrtjulu-ya ngalkukitjalu. Nyangka-ya Yarannga puru Yitjurayilku tjamupirtiku liita pirninya pitjangu lurrtjurringkulalpi kuka palunyanya ngalkulanytja Mama Kuurrta mirangka. ");
INSERT INTO ntj_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nyangka ngarringu tjirnturringkulalpi Mawutjalu yarnangu pirninya-tjananya nyinarra tjurrkurlmaranytja. Tjiinya-ya pitjala tjakultjuranytja kutjupalu pika-pikalu watjaranyangka. Nyangka-tjananya tjurrkurlmaranytja. Nyangka-ya Mawutjalawana yunguntjarranguru ngaralayirnu tjirntu tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Nyangka Mawutjaku waputjulu nyakulalpi tjapirnu, “Nyaakun ngaapirinypa palyara? Kutju-muntan nintipuka nyinarra tjurrkurlmankukitja-tjananya? Nyangka-ya ngaralayira ma-mungarrtjirringkula nyuntulakutjunta-ya tjakultjura.” ");
INSERT INTO ntj_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Nyangka Mawutjalu watjarnu, “Wiya, tjiinya-rniya pitjala Mama Kuurrta-rna tjapira kuliltjaku. Nyangka-tjananyarna palunyaku wangka tjakultjunkupayi. ");
INSERT INTO ntj_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tjinguru-pulanku kutjarralu pika-pikalu watjalku. Palunyalu-pula pitjaku watjalku yartakanku. Nyangka-pulanyarna tjurrkurlmanku watjalku. Puru-rna Mama Kuurrku wangka tjakultjunku.” ");
INSERT INTO ntj_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nyangka Mawutjaku waputjulu watjarnu, “Palya-munta-rnanta watjalku? Tjiinyan kutjupayarlalu palyara. ");
INSERT INTO ntj_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tjiinyan palunyapirinypa palyarayilku wawanyarriku. Nyangka-ya yarnangu pirninyatarrartu ngaralayilku punkalku. Tjiinya waarka palunyanya purlkanya mularrpa. Kutjulu kamu palyalku. Ngarna pirnilunta-ya lurrtjurringkulalpi palunyapirinypa palyalku. ");
INSERT INTO ntj_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Kulila-rni. Nyangka-rnanta watjalku tjurrkurlmanku. Nyangka Mama Kuurrtunta yirringkanama. Tjiinya palyan Mama Kuurrta tjakultjunku yarnangu-ya pika-pikarringkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Puru-tjananyan walykumunulu Mama Kuurrku wangka nintipungama. Puru-tjananyan tjurrkurlmara watjanma tjukarurrulu-ya palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nyangkan ngaapirinypa puru palyalku. Tjiinya-tjananyan wati walykumunu pirni miratjuralpi tjunku yarnangu pirninya tjurrkurlmara watjaratjaku. Wati-tjananya ngaapirinypan miratjuralpi tjunku, tjiinya tjukarurru nyinapayinya, puru mayura palyalpayi wiya, puru Mama Kuurrnga mularrkulilpayinya. Tjiinyan kutjupatjarra tjunku yarnangu 1,000 - 1,000-ku, puru kutjupatjarra tjunku yarnangu 100 - 100-ku, puru kutjupatjarra tjunku yarnangu 50 - 50-ku, puru kutjupatjarra tjunku yarnangu 10 - 10-ku. ");
INSERT INTO ntj_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Nyangka-tjananyayayi tirtu watjara tjurrkurlmanama. Ngarna-ya purtu kuliralpi pitjakunta nyuntula tjapilku. Yuwa, palunyapirinypa palyaranyangka walykumununku ngaraku. Tjiinyanta-ya pirnilu yirringkanama. ");
INSERT INTO ntj_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Yuwa, Mama Kuurrnga mukurringkula palunyapirinypan palyaratjaku. Nyangkan wawanyarrikitjamunu. Nyangka-ya yarnangu pirninya pika-pikatjanu kalyparringkulalpi lurrtjurringkula mapitjalayinma ngurrakutu.” ");
INSERT INTO ntj_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Nyangka Mawutjalu mularrpartu palyarnu palunyaku waputjulu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Palunyalu-tjananya wati walykumunu miratjunu puurrpa-ya nyinarratjaku. Nyangka-ya kutjupatjarranya yarnangu 1,000 - 1,000-ku nyinarranytja, kutjupatjarranya-ya yarnangu 100 - 100-ku, puru kutjupatjarranya-ya yarnangu 50 - 50-ku, puru kutjupatjarranya-ya yarnangu 10 - 10-ku. ");
INSERT INTO ntj_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Palunyalu-tjananyaya tirtu tjurrkurlmara watjaranytja. Ngarna-ya purtu kuliranytjatjanu Mawutjalakutu pitjala tjapilpayi. Nyangka watjalpayi. ");
INSERT INTO ntj_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Nyangka Mawutjaku waputjulu watjarnu, “Palya-munta-rna yanku ngurrakutu?” Nyangka Mawutjalu-lu witurnu. Nyangka mularrpartu marlaku kutipitjangu palunyaku ngurra yungarrakutu. ");
INSERT INTO ntj_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Nyangka-ya Yitjurayilku tjamupirtilu ngurra nyarra Ripitiminya wantirra pakara mapitjangu pila yini Tjayinayilakutu. Palunyalu-ya yapu Tjayinayila parntawanalu ngurra tjunu. Tjiinya-ya Yiitjipunya wantirra pitjalayirnu kirnara nampa 3 ma-ngarrinyangka parrapitjangu. ");
INSERT INTO ntj_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Nyangka Mawutjanya yapungka tatirnu Mama Kuurrta lurrtjurrikitja. Nyangka Mama Kuurrtu-lu yapu katunguru yarltirralpi watjarnu, “Yuwa, Yitjurayilku tjamupirtingka-tjananya ngaapirinypa watjala, ");
INSERT INTO ntj_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Tjiinya-rniyan nyangu Yiitjipunyamartatji pirninya-tjananyarna pungkula mirrirntaranyangka. Palunyalu-tjananyarnanta miranykurrulu kanyirayirnu ngurra ngaaku katingu. Tjiinyakurlu warlawurrulu-tjananya kurlunypa ngawura pakala. Palunyapirinypa-tjananyarnanta walara katingu ngurra ngaaku. ");
INSERT INTO ntj_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kulila-ya. Ngayuku wangka-ya wangarnarralu kulira palyanma. Puru-ya ngayuku tjukurrpa watatjarrirranytjamaaltu tirtu kulinma. Palunyatjanu-yan ngayuku katja yurntalpirti nyinama. Tjiinya-rna ngayulu manta lipi kanyilpayilu-tjananyarnanta nyuntunyakutju miratjunu ngayuku yungarrapirti-tjananyarnanta kanyilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Nyangka-rniyan kutjupa kulintjamaaltu ngayunyakutju kulira palyanma. Puru-rniyan ngarltuwangkama yarnangu kutjupa-kutjupa pirniku-tjanampa. Nyangka-tjananyarna walykumunura kanyinma nyuntulu-rniyan wangkarranyangka.’” ");
INSERT INTO ntj_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Nyangka Mawutjalu tjarungaralalpi-tjananya liita pirninya yarltingu kutjungkaralpi tjakultjunu Mama Kuurrtu watjarnu wantinytjanya. ");
INSERT INTO ntj_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Nyangka-ya yarnangu pirnilurtu watjarnu, “Yuwawu, palya-latju kulira palyalkitjalu Mama Kuurrtu watjarnu wantinyangka.” Nyangka Mawutjalu-tjananya kuliralpi Mama Kuurrta tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Ngayulu-rnanta yutuwari purlkanyangka ngamuntirriku wangkaku. Nyangka-rniya yarnangu pirnilu kulilku nyuntula-rna wangkarranyangka. Palunyalu-ya nyuntunya tirtu mula-mularringkula kulinma.” Nyangka Mawutjalu tjarungarangu watjarnu-tjananya. Palunyalu marlaku mapitjangu tatiralpi Mama Kuurrta tjakultjunu yarnangu pirnilu-ya watjantjanya. ");
INSERT INTO ntj_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Nyangka Mama Kuurrtu-lu watjarnu, “Mapitja-tjananya watjala tamarlmarra wanti. Nyangka-yankuyi parltjila warntutarrartu kuwarrinya puru tjirntungka. Palunyalu tamarlpa nyinama. Nyangka tjirntu nyarra kutjupangka-rna yapu Tjayinayila tjarungaraku yarnangu pirningka mirangka. ");
INSERT INTO ntj_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Yuwa, watjala-tjananya yapu parntawanalu-ya yaarrpa parrangaratjura wantitjaku tjiinya-ya pitjala wayirntankutjakutarra. Palunyalu watjala-tjananya purlikutu ngamuntirringkula pitjanytjamaalpa tiwa ngaralatjaku. Nyangka kutjupa-tjinguru tungun-tungunpa tatira pitjanyangka yapungka-ya yatula mirrirntarra. ");
INSERT INTO ntj_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Yuwa, tjinguru-yan palya kurlartangkatarrartu wakalku mirrirntanku. Tjiinya maralu pampuntjamaaltu wanti. Nyangka tjiipu nanikuurrpatarrartu tatilku parrangaralanyangka yapungka-ya yatula mirrirntarra. Wiyangka-tjinguru-yan kurlartangka wakalku mirrirntanku. Ngamuntirrinytjamaalpa-ya tiwa ngarama. Ngarna-yan kulilku turampirrpa lingkirrtu mirratjingannyangka yapukutu ngamuntirriku.” ");
INSERT INTO ntj_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","Nyangka Mawutjalu tjarungaralalpi-tjananya watjarnu, “Ngarnmanymarra-yanku parltjila walykumunurringkulalpi nyinama. Puru warntu-yanku parltjiralpi nyina ngurra kutjarrarri. Palunyalu kurringka-kurlu-yan ngarriku. Wanti.” Nyangka-ya kuliralpi mularrpartu warntu parltjiralpi tamarlpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Nyangkalta-ya ngurra kutjarratjanulu pakaralpi nyangu wanangara pakaranyangka. Puru-ya kulirnu tuturanyangka. Palunyalu-ya nyangu yutuwari purlkanya yapu katalarra ngaralanyangka. Palunyalu-ya kulirnu turampirrpa lingkirrtu mirratjingannyangka. Nyangka-ya ngurranguru kuliralpi ngurlu tiltirrmaranytja. ");
INSERT INTO ntj_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Nyangka Mawutjalu-tjananya yarltirra katingu Mama Kuurrtakutu ngamuntinkukitjalu. Nyangka-ya purli parntangka parrayangatjunu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Nyangka tjunarnpa purlkanyalu purli Tjayinayinya tjutura kanyiranytja. Tjiinyamarntu Mama Kuurrnga warutjarrapirinypa tjarungarangu ngarangu. Nyangka tjunarnpa purlkanya mularrpa pakarnu yapu yangatjunu kanyiranytja. Nyangka purli palunyanya purlkanya yurri-yurringu. ");
INSERT INTO ntj_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Nyangka turampirrpa palunyanya puru lingkirrarringu. Nyangka Mawutjanya Mama Kuurrta ma-wangkangu. Nyangka tuturalpi ngalyawangkangu. ");
INSERT INTO ntj_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Palunyalu tjarungarangu yapungka katalarra ngaralanytja. Palunyalu Mawutjanya yarltingu yapungka tatira lurrtjurritjaku. Nyangka-lu mularrpartu tatirnu lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nyangka-lu watjarnu, “Marlaku tjarungara-tjananya ngurlutjurra tjiinya yaarrpa parrangaratjunu wantingu palunyangkartu-yayi ma-ngarama, tjiinya-ya pitjaku ngamuntirringku mirrirritjakutarra. ");
INSERT INTO ntj_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Nyangka-tjananya watjala ngayuku waarka palyalpayinyatarrartu tjiinya-ya ngayulakutu ngamuntirringkukitjalu kapingka-yanku parltjira pitjatjaku. Wiyangka-tjananyarna pikatjarralku.” ");
INSERT INTO ntj_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Nyangka Mawutjalu watjarnu, “Wiya, yarnangu pirninya-ya kamu tatilku. Tjiinyamarntu-lanyatjun watjarnu wantingu yapu parntawanalu yaarrpa parrangaratjura wantitjaku palunyalu miirl-miirlmara kanyiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nyangka Mama Kuurrtu-lu watjarnu, “Tjarungarala mapitja nyuntuku kurta Yarannga yarltirra kati. Palunyalu-tjananya ngayuku waarka palyalpayi pirninya puru yarnangu pirninya marrkula wanti. Nyangka-yayi yurrimaalpa ma-ngarama pikatjarraltjakutarra-tjananyarna.” ");
INSERT INTO ntj_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Nyangka mularrpartu Mawutjalu tjarungarangu-tjananya watjarnu Mama Kuurrtu watjarnu wantinytjanya. ");
INSERT INTO ntj_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nyangka Mama Kuurrtu ngaapirinypa watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yuwa, kulila-ya. Ngayulu-tjanamparnanku nyuntuku Puurrpa Mama Kuurrnga wangkarra. Ngayulu-tjananyarnanta Yiitjipulanguru katingu ngurra palunyangka-tjananyantaya kanyira pungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Kutjupa-kutjupa-ya pupakatirra marninypungkutjamaaltu ngayunyakutju-rniya pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Puru-ya yapu purnu katapungkula yiikutjarrara yarnangutjarrara palyantjamaaltu wantima. Kutjupa-kutjupa yilkaringka parrangarapayipirinypa yarrkantjamaaltu wantima. Puru mantangka nyinapayipirinypa yarrkantjamaaltu wantima. Puru kapingka parrapitjapayipirinypa palyantjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Puru-ya warta yapu pupakatirra marninypungkutjamaaltu wantima. Tjiinyamarntu ngayulu-tjanamparnanku Puurrpa Mama Kuurrnga nyinarra. Palunyalu-rna mirrparnarriku kutjupa-kutjupa-yan pupakatirra marninypungkulanyangka. Puru-rna yanyan-yanyanpa nyinapayinya pikatjarralku. Puru-tjanamparna katja yurntalpa, tjamu kaparli puru tjamu kaparlingkatjatarrartu pikatjarralku. ");
INSERT INTO ntj_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Nyangka ngayuku-tjuya mukulyanytju nyinapayinya, puru ngayuku wangka wangarnarralu kulira palyalpayinya, palunyaku-tjanamparna tjamupirti mukulyanytjulu kanyinma. Nyangka-ya marlangkatja-marlangkatja pakaranyangka-rna mukulyanytjulu tirtu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ngayuku yini mungutjamunu-ya ngarlpupirtira watjantjamaaltu wantima. Tjiinya ngayuku yini ngarlpupirtira watjaranyangka-rna mularrpa pikatjarralku. ");
INSERT INTO ntj_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Nyangka ngurra 6-tjanulu-ya tirtu tjirntu kutjupangka waarka wantirra nyinarranytjalu ngayunya-rniya kulinma. ");
INSERT INTO ntj_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tjiinya tjirntu 6-pa-tjanampanku ngarala waarka-yan palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Nyangka ngurra 6-tjanulu-ya waarka wantirra nyinarra ngayunya-rniya kulinma. Tjiinya nyuntulu-ya puru-tjanampanku tjilkulu, waarka palyalpayilu, puru tungkilu pulukalutarrartu puru maliki nyuntulawana nyinapayilutarra waarka palyantjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tjiinyamarntu-rna Mama Kuurrtu pirninyartu palyara-wanarnu tjirntu 6-tjanu wiyarringu. Tjiinya-rna manta, yilkari, kapi, puru mantangka nyinapayinya, yilkaringka ngarapayinya, puru kapiwana parrapitjalayilpayinya palyara-wanarnu wiyarnu. Palunyalu-rna wantingu nyinarranytja. Palunyanguru-rna watjarnu wantingu ngurra 6-tjanulu-yan waarka wantirra nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Mama ngunytju-yanku panypurangkutjamaaltu kulinma. Palunyalu-yayin rawa nyinarrayilku nyalparriku ngurra nyarra ngayulu-tjanamparnanku nintilku, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mirri pungkutjamaaltu-ya wantima. ");
INSERT INTO ntj_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Kutjupaku kurringka-ya ngarrinytjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mulyatarrinytjamaaltu-ya wantima. ");
INSERT INTO ntj_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Yarnangu kutjupanya-ya kunpu-kunpu nyakula ngukara watjantjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Puru kutjupalunku kutjupa-kutjupa kanyiranyangka nyakula-ya mukurringkutjamaaltu wantima. Tjiinya kutjupalunku yiwarla, puru kurri, puru waarka palyalpayi, puru puluka, tungki, puru kutjupa-kutjupa kanyiranyangka nyakula-ya mukurringkutjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nyangka-ya yarnangu pirnilu kulirnu tuturanyangka puru turampirrpa mirratjingannyangka. Puru-ya nyangu wanangara paka-pakaranyangka puru tjunarnpa purlkanya purlinguru pakaranyangka. Palunyalu-ya tiwa ngarala ngurlu tiltirrmaranytja. ");
INSERT INTO ntj_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Palunyalu-ya Mawutjala watjarnu, “Wiya, nyuntulu-lanyatjun watjaranyangka-latju palya kulinma. Nyangka-lu Mama Kuurrnga marrkula wangkarranyangka-latju punkara mirrirringkutjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Nyangka Mawutjalu-tjananya watjarnu, “Ngurlurringkutjamaaltu-ya kurrurnpa rapalu ngarala nyangama. Tjiinya Mama Kuurrnga pitjangu-tjananyanta mularrnyakukitja, ‘Mularrpa-munta-rniya mularrkulira?’ Nyangka-yayin watarrkurrinytjamaaltu kulinma puru palyamunu palyantjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nyangka-ya tiwangurulu tirtu ngarala nyakulanytja. Nyangka Mawutjanyakutju yutuwari marunytjungkula watingarrirranyangka ngamuntirringkula mapitjangu Mama Kuurrta lurrtjurringkukitja. # 20.22-26 ngaangka ngaralanytjamunu. # 21, # 22, puru # 23 ngaangka ngaralanytjamunu. ");
INSERT INTO ntj_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yarlti-tjananya Yarannga puru palunyaku katja Nayitapinya-pulanya Yapiyunya puru Yitjurayilku tjamupirtiku liita 70. Nyangka-rniyayi ngalyatatila yapungka ngatalpa ngara. Palunyalu pupakatirralpi-rniya marninypuwa. ");
INSERT INTO ntj_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Nyangka nyuntulukutjun ngamuntirriku. Nyangka-ya kutjupatjarra ngamuntirringkutjamaalpa tiwa ma-ngarama. Nyangka-ya yarnangu pirninya yapukutu ngamurntirringkutjamaalpa ma-nyinama.” Nyangka Mawutjanya mularrpartu tatirnu Mama Kuurrta lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Palunyalu-tjananya tjarungarangu tjakultjunu Mama Kuurrku wangka pirninyartu tjiinya tjurrkurlmara watjaranytjanya. Nyangka-ya yarnangu pirnilurtu kuliralpi yuwarnkarrarnu, “Yuwawu! Mama Kuurrtu watjarnu wantitjanya-latju wangarnarralu kulira palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Nyangka Mawutjalu Mama Kuurrku wangka ruulangka walkatjura-wanarayirnu wiyaralpi tjunu wantingu. Palunyalu ngarringu tjirnturringkulalpi pakarnu yapu parntangka yapu tjunkula parrawanarnu katurnu wantingu kuka pungkula tilira tjunkula Mama Kuurrku nintilkitjalu. Palunyalu yapu 12-pa mantjirnu murrutjura-wanarnu wantingu. Tjiinyamarntu wati nyarra Yitjurayiltu kutjulpirtu katja 12-pa kanyiranytja. Nyangka-ya palunyanguru pirnirringkula-wanarnu. ");
INSERT INTO ntj_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Nyangka Mawutjalu-tjananya wati yangupala pirninya watjarnu, “Puluka-ya pungkulalpi tilila tjurra Mama Kuurrku nintila.” Nyangka-ya mularrpartu puluka pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu-ya Mama Kuurrnga marninypungkulanytja. Palunyalu-ya puru puluka pirni pungkulalpi paara ngalkulanytja Mama Kuurrta mirangka. ");
INSERT INTO ntj_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Nyangka Mawutjalu yirrami kutjupatjarra tiirrtji pirningka tjutiralpi tjunu wantingu. Palunyalu kutjupatjarrangka parrawilyarrpungu yapu nyarra tilira tjunkupayinya. ");
INSERT INTO ntj_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Palunyalu ruula palunyanya Mama Kuurrku wangkatjarra mantjiralpi yarnangu pirningka-tjananya nyakula watjara-wanarnu wiyarnu. Nyangka-ya pirnilurtu kuliralpi watjarnu, “Yuwawu! Pirninyartu Mama Kuurrtu watjarnu wantitjanya-latju wangarnarralu kulira palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Nyangka Mawutjalu tiirrtji yirramitjarra mantjiralpi-tjananya yarnangu pirninya parrawilyarrpungu. Palunyalu-tjananya watjarnu, “Nyawa-ya yirrami ngaanya. Palunyalu-ya kulila tjukurrpa ngaanya Mama Kuurrtu watjarnu wantingu palyaratjaku-yan.” ");
INSERT INTO ntj_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Nyangka-ya Mawutjanya, Yarannga, Nayitapinya, Yapiyunya puru Yitjurayilku tjamupirtiku liita 70-nya yapungka tatirnu lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Palunyalu-ya nyangu Mama Kuurrnga tjiinya Yitjurayilku tjamupirtilu-ya pupakatirra marninypungkupayinya. Nyangka palunyaku tjinawana walu purlkanyapirinypa ngaralanytja kala walykumunu yilkaripirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tjiinya-ya Mama Kuurrnga nyangu. Nyangka-tjananya pikatjarrantjamaaltu wantingu. Nyangka-ya pukurltu mirrka ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yapuwana ngalyatatila ngamurringkulalpi-rni ngayula nyinakati nyinama. Nyangka-rnanku walu kutjarra wangkatjarra nintilku. Tjiinya-rna ngayulu walkatjunu wantingu nintirringkulatjaku-ya.” ");
INSERT INTO ntj_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Nyangka Mawutjanya-pula Tjatjuwanya pakarnu Mama Kuurrku yapu miirl-miirlwana tatilkitja. Tjiinya Tjatjuwalu Mawutjala lurrtjurringkula yirringkankupayi. ");
INSERT INTO ntj_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nyangka Mawutjalu-tjananya liita pirningka watjarnu, “Ngurrangka-ya nyinarra nyangama marlaku-litju pitjatjaku. Tjiinya Yarannga-pula Yuuwanya nyinarra nyuntunya-tjananyanta miranykanyilkitja. Pika-pika wangkarranytjalu palunyala-pulanyaya watjala yartakarra. Nyangka-pula watjalku tjurrkurlmanku.” ");
INSERT INTO ntj_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Nyangka Mawutjanya yapuwana ma-tatirnu. Nyangka yutuwari purlkanyalu pitjangu yapu katu yangatjura ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Nyangka Mama Kuurrtanguru tili purlkanyalu pirntalarrara yapu palunyanya yartakara kanyiranytja. Nyangka-ya Yitjurayilku tjamupirtilu yirranyakulanytja warupirinypa yapu palunyangka kamparranyangka. Nyangka yutuwari palunyanya yapu katu yangangarrirranytja. Nyangka ngurra 6-tjanulu Mama Kuurrtu yutuwaringurulu Mawutjanya yarltingu pitjala lurrtjurritjaku. ");
INSERT INTO ntj_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Nyangka mularrpartu tatira mapitjalayirnu yutuwaringka ma-tjarrpangu. Palunyatjanu nyinarrayirnu tjirntu 40-rringu. ");
INSERT INTO ntj_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","9","Nyangka Mama Kuurrtu Mawutjala tjurrkurlmara watjaranytja, “Watjala-tjananya kutjupa-kutjupa walykumunu-ya katirra nintiltjaku. Palunyalu-tjananya watjala tiinti miirl-miirlpa-ya ngayuku palyaltjaku. Nyangka ngayulu-tjananyarna nyinama. Ngayulu-rnanta nintitjunku. Nyangka-yan palunyapirinypartu palyalku.” ");
INSERT INTO ntj_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","22","Nyangka Mama Kuurrtu Mawutjala watjarnu puuka miirl-miirlpa-ya palyaltjaku. Tjiinya ngaapirinypa watjarnu, “Warta katapungkulalpi-ya palyalku. Palunyalu-ya kawurlpa nganytjatjunku wantiku. Palunyalu-ya liirrpa kawurlpa palyalku. Palunyalu-ya nyarlpitjarra kutjarra palyaralpi-pulanyaya puuka katu ngaratjunku. Nyarlpi-pulanyaya lipiralpi lurrtjulku puuka katu. Palunyalu-ya yapu walu wangkatjarra kutjarra tjarrpatjunku puuka kaninytjarra. Nyangka-rnanta lurrtjurringkulalpi puuka katunguru watjalku wantiku kutjupa-kutjupa ngayuku katja yurntalpirtilu-ya palyaratjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","30","Nyangka Mama Kuurrtu watjarnu tayipulpa nyuma tjunkupayinya-ya palyaltjaku. Tjiinya ngaapirinypa watjarnu, “Warta katapungkulalpi-ya tayipulpa palyalku. Palunyalu-ya kawurlpa lalyparalpi nganytjatjunku wantiku. Palunyalu-ya tiinti miirl-miirlpangka tjunku. Palunyalu nyuma miirl-miirlpa tirtu tjunama.” ");
INSERT INTO ntj_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","40","Nyangka Mama Kuurrtu watjarnu lantanpa kawurlpa-ya palyaltjaku tili 7-tjarra palunyalu tiinti miirl-miirlta tjunkutjaku. ");
INSERT INTO ntj_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","37","Nyangka Mama Kuurrtu tjurrkurlmara watjaranytja tiinti miirl-miirlpa-ya palyaltjaku. Palunyalu watjarnu warntu walykumunu-ya palyara tiinti kaninytjarra ngururrkutjarra waraly-waralytjura wantitjaku. Puru ngaapirinypa watjarnu, “Palunyatjanu-ya puuka miirl-miirlpa walu kutjarratjarra warntungka munkarra tjunku. Tjiinya warntungka munkarra miirl-miirlpa purlkanya ngarama. Nyangka tayipulpa puru lantanpa warntungka kalkurni tjunku.” ");
INSERT INTO ntj_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","8","Nyangka Mama Kuurrtu tjurrkurlmara watjaranytja waru nyarra kuka tilira tjunkupayinya-ya palyaltjaku. ");
INSERT INTO ntj_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","19","Nyangka Mama Kuurrtu tjurrkurlmara watjaranytja warntu pirni lurrtjura parrawaraly-waralytjunkula yaarrpirinypa-ya palyaltjaku. Nyangkayi tiinti miirl-miirlpa ngururrkutjarra ngarama. ");
INSERT INTO ntj_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","21","Nyangka Mama Kuurrtu watjarnu, “Watjala-tjananya Yarantu puru palunyaku katjalu-ya lantanpa tiliratjaku. Munga kutjupa munga-ya tirtu tilinma. Nyangka-ya marlangkatja-marlangkatja pakaranytjalu palunyapirinypa tirtu palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","43","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Ngulan yarltiku-tjananya nyuntuku kurta Yarannga puru palunyaku katja kutjarra-kutjarranya. Palunyalu-tjananyan tjunku tiinti miirl-miirlta-ya waarka palyaratjaku. Palunyalu watjalku-tjananyan nintipukalu palyalpayi pirnilu-tjanampaya warntu kutjupa-kutjupa walykumunu palyaltjaku. Nyangka-yayi Yarantu palunyaku katja pirnilu warntu palunyanya tjarrpatjuralpi tiinti miirl-miirlta waarka palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","37","Nyangka tjiinya Mama Kuurrtu Mawutjanya watjarnu kutjupa-kutjupa palyaratjaku. Nyangka palunyangurulu-yayi Yarantu palunyaku katja pirnilu tiinti miirl-miirlta waarka palyanma. ");
INSERT INTO ntj_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","46","Nyangka Mama Kuurrtu watjarnu tjiinya-ya tjirntu kutjupa tjirntu tjiipu warlangu kutjarra pungkula warungka tilira Mama Kuurrku nintiratjaku. Kutju yunguntjarra pungkula nintinma puru kutjupa mungarrtji pungkula nintinma. Nyangka-ya marlangkatja-marlangkatja pakaranytjalu palunyapirinypartu tirtu palyanma. ");
INSERT INTO ntj_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","10","Nyangka Mama Kuurrtu watjarnu waru parnti walykumunu kampapayinya-ya palyaltjaku. Palunyalu tjunkutjaku warntu waraly-waralyngarapayingka kalkurni. Nyangka Yarantu yunguntjarra puru mungangka parnti walykumunu pulparru tjunkulalpi tilinma. ");
INSERT INTO ntj_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","16","Nyangka Mama Kuurrtu watjarnu wati kutju-kutjulu-ya tjimarri nintiratjaku. Nyangka-yayi tjimarri palunyangka tiinti miirl-miirlpa walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","21","Nyangka Mama Kuurrtu watjarnu tiirrtji purlkanya-ya palyara tjunkutjaku tiinti miirl-miirlku yaarrta kaninytjarra. Nyangka-yankuyi wati nyarra tiintingka waarka palyalpayi pirnilu mara tjina parltjinma kutjupa-kutjupa Mama Kuurrku nintilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","33","Nyangka Mama Kuurrtu Mawutjanya watjarnu uyilpa-ya palyara miirl-miirlmankutjaku, tjiinya parnti walykumunungka warli-warliralpi tjunkulatjaku. Puru watjarnu uyilpa palunyanya-ya kutjupa-kutjupangka tjutira miirl-miirlmankutjaku — tjiinya tiinti miirl-miirlta puru yulytja pirni tiinti kaninytjarra ngarrirranytjala tjutira miirl-miirlmara kanyiratjaku. Puru watjarnu uyilpa palunyanya miirl-miirlpa purlkanya ngarrirratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","38","Nyangka Mama Kuurrtu watjarnu parnti walykumunu pulparru-ya palyaralpi miirl-miirlpa kanyiratjaku tiinti miirl-miirltakutju tiliratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Nyangka Mama Kuurrtu Mawutjala wangkarrayirnu wiyarringkulalpi walu kutjarranya nintirnu. Tjiinya walu palunyangka yungarralu wangka walkatjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Nyangka-ya yarnangu pirnilu Mawutjaku purtu nyangu-nyangu kaarr-kaarrarringu tjiinyamarntu yapu katu tatirnu rawarrinyangka. Palunyalu-ya Yaranta kutjungkarringkulalpi watjarnu, “Wati Mawutjanya ngaangka yaaltjirringu, Yiitjipulanguru-lanya katinytjatjanunya? Kutjupa-kutjupa-lampa palyala pupakatirra-la marninypungkulatjaku. Nyangka-lanyayi miranykanyira katirrayinma.” ");
INSERT INTO ntj_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Nyangka Yarantu watjarnu, “Mapitja-ya pinangkatja kawurlpa nyuntuku kurringkatja puru katja yurntaltatja yarrara kati.” ");
INSERT INTO ntj_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Nyangka-ya mularrpartu pinangkatja kawurlpa pirni yarrara katingu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nyangka Yarantu mantjiralpi waru tilingka paarnu yirralaralpi puluka marnti palyarnu. Nyangka-ya watjarnu, “Yitjurayilku tjamupirti, nyawa-ya. Ngaalu-lanya Yiitjipulanguru katirrayintja. Nyangka-la pupakatirra marninypungama.” ");
INSERT INTO ntj_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Nyangka Yarantu pulukangka yampuwana yapu tjunkula parrawanarnu katurnu kuka pungkula tilira nintilkitjalu. Palunyalu-tjananya watjarnu, “Ngarriku tjirnturringkulalpi-lan pakalku lurrtjurringkulalpi pukurltu mirrka, kuka ngalkula Mama Kuurrnga marninypungama.” ");
INSERT INTO ntj_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nyangka-ya mularrpartu ngarringu mungayurntura pakarnu tjiipu, puluka katingu pungkulalpi tilirnu tjunu. Kuka kutjupatjarranya-ya katingu pungkulalpi paarnu lurrtjurringkula ngalkukitjalu. Palunyalu-ya nyinakatingu mirrka, kuka ngalkula wayinpa tjikiranytja. Palunyalu-ya kakirirringkulalpi pakarnu parrangarlpurringkula warnngira-yanku punka-punkaranytja. ");
INSERT INTO ntj_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Waarrpungkula tjarungarala mapitja nyawa. Tjiinyamarntu-ya nyuntuku yungarrapirti, nyarra Yiitjipulanguru-tjananyan walara katingu, palunyalu-rniya ngayunya wantirralpi palyamunurringkula. ");
INSERT INTO ntj_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Waarrpungkulalpi-ya ngayuku wangka puru ngayuku yiwarra wantirralpi-yanku puluka kawurlpa palyarnu. Palunyalu-ya pupakatirra marninypungkula. Puru-ya tjiipu, puluka pungkulalpi paarnu palunyaku nintirnu. Puru-ya watjara palunyalu-tjananyanyu Yiitjipulanguru katingu! ");
INSERT INTO ntj_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Wiya, nintilu-rna kulira tjiinya-ya tungun-tungunpa purlkanya tirtu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Marrkulku-kurlu-rnin. Wanti-rni. Tjiinya-rna mirrparnpa purlkanya nyinarra. Kuwarrinya-tjananyarna pungku wiyalku. Palunyalu-rnanku nyuntuku tjamupirtilpi kanyilku pirnirritjaku. Nyangka pirnilu-tjananyayi mirrawarnima.” ");
INSERT INTO ntj_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nyangka Mawutjalu Mama Kuurrnga marrkura watjaranytja, “Wiya, nyaakun mirrparnarringkula nyuntuku katja yurntalpirtiku? Tjiinyamarntu nyuntulu-tjananyan yayirninytjulu Yiitjipulanguru pakaltjingara katingu. ");
INSERT INTO ntj_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Wiya, nyuntulu-tjinguru-tjananyan mirrirntankunyangka Yiitjipunyamartatji pirnilu-ya watjalku, ‘Wiya, katingu-tjananya ngurra yaputjarrangka pungkula mirrirntara wiyalkitjalu.’ Palunyakutarra kalyparringkulalpi wanti-tjananya pungkutjamaaltu. ");
INSERT INTO ntj_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wiya, kulinma-tjananya Yayipuramanya, Yayitjikinya, Tjayikapanya. Tjiinyan kalkurnu wantingu palunyaku tjamupirti walykumunura kanyilkitjalu. Tjiinyan watjarnu, ‘Nyuntuku tjamupirti mingapirinypa nyinama. Nyangka-tjanamparna ngurra walykumunu nintilku. Nyangka-ya tirtu nyinama.’” ");
INSERT INTO ntj_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nyangka Mama Kuurrtu-tjananya pungkukitjalu kulirnu wantirralpi-tjanampa kalyparringu. Tjiinyamarntu Mawutjanya-tjanampa ngarltuwangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nyangka Mawutjanya walu kutjarratjarra yapuwana tjarungarala pitjangu. Tjiinya walu-pula wangkatjarra kutjarranguru walkatjunu wantinytjanya katunguru puru kaninytjarranguru. ");
INSERT INTO ntj_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tjiinya Mama Kuurrtu yungarralu kartaralpi walu palyarnu. Palunyalu wangka walkatjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Nyangka Mawutjanya Tjatjuwala lurrtjurringkulalpi-pula tjarungarala pitjangu kulirnu ngurrangka-ya mirrarranyangka. Nyangka Tjatjuwalu watjarnu, “Wiya-kulila, warrmarlalu-tjananyaya pitjangu wakaranyangka-ya ngaparrtjika wakara.” ");
INSERT INTO ntj_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Nyangka Mawutjalu watjarnu, “Wiya-kulila, pika-yanku pungkunytjamaalpa. Turlku-ya yinkarra.” ");
INSERT INTO ntj_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Nyangka-pula pitjangu ngamuntirringkulalpi nyangu puluka kawurlpa ngaralanyangka-ya turlku parrakanturanytja. Nyangka Mawutjalu lirri warurringkulalpi walu kutjarranya yapu parntangka warningu kartarntanu. ");
INSERT INTO ntj_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Palunyalu puluka kawurlpa mantjiralpi warningu warungka tjarrpatjunu. Palunyalu mantjiralpi yapungka rulyupungkulayirnu pulparrunu. Palunyalu kapingka wiilypungkulalpi watjarnu-tjananya tjikiltjaku-ya. Nyangkalta-ya mularrpartu tjikirnu. ");
INSERT INTO ntj_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Nyangka Mawutjalu Yarannga watjarnu, “Wiya, nyaapanta-ya watjarnu, palunyangkan kuliralpi kurrakuturnu walykunytjilpa-ya palyaltjaku?” ");
INSERT INTO ntj_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Nyangka Yarantu watjarnu, “Wiya, ngayuku-kurlu-tjun mirrparnarriku. Nyuntulun ninti. Tjiinya yarnangu ngaalu-ya tirtu kulira palyamunu palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tjiinya-rniya watjarnu, ‘Wati Mawutjanya ngaangka yaaltjirringu Yiitjipulanguru-lanya katinytjatjanunya? Kutjupa-kutjupa-lampa palyala pupakatirra-la marninypungkulatjaku. Nyangka-lanyayi miranykanyira katirrayinma.’ Palunyapirinypa-ya watjarnu. ");
INSERT INTO ntj_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nyangka-tjananyarna watjarnu pinangkatja kawurlpa-yanku yarrara kati-katitjaku. Nyangka-ya mularrpartu katinyangka-rna warukutu warningu. Nyangkalta puluka yartakarringkula warunguru pakarnu.” ");
INSERT INTO ntj_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nyangka Mawutjalu nyangu yarnangu pirninya-ya tungun-tungunarringu kutjupa-kutjupa palyaranytja Yarantu-tjananya marrkuntjamaaltu nyakula wantirranyangka. Palunyalu kulirnu, “Wiya-kulila, maliki yanyan-yanyanpa nyinapayilutarrartu-ya tjakulpa-tjananya kulira panypurangama.” ");
INSERT INTO ntj_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Nyangka Mawutjanya kayirrkutu yankulalpi-tjananya mirrangu watjarnu, “Ngananya-ya mukurringkula Mama Kuurrnga wanalkitja? Pitja-rniya ngayula ngamu ngara.” Nyangka-ya mularrpartu Liipayiku tjamupirti pakara pitjangu lurrtjurringu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nyangka-tjananya watjarnu, “Yitjurayilku tjamupirtiku Puurrpa Mama Kuurrtu watjarnu kunmarnu purlkanya-yankun mantjira ngurra pirniwanartu mapitjatjaku. Palunyalu-yankun kurtapirti puru yamatji pirninya puru yitingka nyinapayi pirninya pungku mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Nyangka-ya mularrpartu mapitjangu-tjananya parramirrirntaranytja. Nyangka-ya wati 3,000-pa mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nyangka Mawutjalu-tjananya Liipayiku tjamupirtingka watjarnu, “Yuwa, kuwarrinya-yan Mama Kuurrku wangkangka katjapirti kurtapirtitarrartu pungu mirrirntanu. Nyangka Mama Kuurrnga-tjanampanku pukurlarringu. Nyangka palunyanguru-yan palunyaku waarka tirtu palyanma.” ");
INSERT INTO ntj_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nyangka ngarringu tjirnturringkulalpi Mawutjalu yarnangu pirningka watjarnu, “Wiya, walykunytjilpa-yan palyarnu. Nyangka-rna yapungka tatilku. Palunyalu-rna Mama Kuurrnga tjapilku. Nyangka-tjinguru-tjanampanku kalyparriku.” ");
INSERT INTO ntj_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nyangka mularrpartu marlakurtu tatirnu Mama Kuurrta watjarnu, “Wiya, ngarltutjarra. Yarnangu pirnilu-ya walykunytjilpa palyarnu. Puluka kawurlpa-ya palyaralpi pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nyangka-tjanampa kalyparriwa. Wiyangka-tjingurun ngayuku yini ruwarrpungku, pukpa nyarra nyuntulun walkatjunu wantitjala.” ");
INSERT INTO ntj_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nyangka Mama Kuurrtu watjarnu, “Wiya, yarnangu nyarra ngayula-rniya tungun-tungunarringu, palunyaku-tjanamparna yini ruwarrpungku. ");
INSERT INTO ntj_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yuwa, mapitja-tjananya walara makati ngurra nyarra ngayulu-rnanta watjarnu wantinytjalakutu. Yuwa, ngayuku yayintjulpanta kurranyurringkula kutipitjaku. Nyangka-tjananyarna ngula pikatjarralku palyamunu-ya palyaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nyangka Mama Kuurrtu-tjananya mularrpartu pikatjarrarnu. Tjiinyamarntu-ya Yarannga witu-witura nintiranytja puluka kawurlpa palyaltjaku. ");
INSERT INTO ntj_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Ngurra ngaanya wantirra kutipitja ngurra nyarra ngayulu-tjanamparnanku kalkurnu wantitjalakutu. Tjiinya-rna Yayipuramanya, Yayitjikinya, puru Tjayikapanya kalkurnu nintilkitjalu, ngurra palunyalakutu kutipitja. Yarnangu palan Yiitjipulanguru katingu, palunyanya-tjananya yarltirra makati. ");
INSERT INTO ntj_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nyangka-rna yayintjulpa witulku nintitjunkula-tjananyanta katirrayiltjaku. Puru-rna ngurra nyarranguru ngurrangkatja pirninya pakaltjingalku tjiinya Kayinanku tjamupirti, Yayimuku tjamupirti, Yatjaku tjamupirti, Pirinyku tjamupirti, Yayipiku tjamupirti puru Tjipurrku tjamupirti. ");
INSERT INTO ntj_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Tjiinya-yan mapitjalayirni ngurra walykumunukutu, mirrka kuka purlkakutu. Nyangka-tjananyarnanta ngayulu lurrtju yankukitjamunu, tjiinya-tjananyarnanta mirrparnarrirralpi pungku wiyaltjakutarra. Tjiinyamarntu-tjuyan tirtu tungun-tungunarripayi.” ");
INSERT INTO ntj_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Nyangka-ya yarnangu pirnilu kuliralpi tjurlpilyarringu. Palunyalu-ya marangkatja, lirringkatja, pinangkatja yarraralpi maralpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Tjiinyamarntu Mama Kuurrtu Mawutjanya watjarnu, “Watjala-tjananya tjiinya-ya tungun-tungunpa purlkanya. Tjinguru-tjananyarnanta lurrtju yankulalpi waarrpungkulalpi pungku mirrirntanku wiyalku. Palunyakutarra-tjananya watjala tjiinya-yanku marangkatja, lirringkatja, pinangkatjatarrartu yarraltjaku. Nyangka-rnayi kulila, ‘Yaaltjingalku-tjananyarnanta?’” ");
INSERT INTO ntj_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Nyangka-ya mularrpartu ngurra Tjayinayilartu yarraralpi yakutjangkakutju katirrayintja. ");
INSERT INTO ntj_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nyangka tjiinya-ya ngurra tjunkunyangka Mawutjalu tiinti makatirra mawurntalpa tiwa-tiwa pupatjunkupayi. Palunyalu tjapirnu yini Tiinti Mama Kuurrta Lurrtjurringkula Kulilpayinya. Nyangka kutjupalu Mama Kuurrta tjapilkitjalu yilkakurringkulalpi mapitjaku tiinti palunyakutu. ");
INSERT INTO ntj_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Nyangka Mawutjanya tiinti palunyakutu mapitjalanyangka yarnangu pirninya-ya paka-pakalku tiinti yungarra-yungarrangurulu ngarala nyakula-wanarayinma Mawutjanya tiinti palunyangka tjarrpatjaku. ");
INSERT INTO ntj_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nyangka ngangkarli wirrmira tjarungaraku tiinti tjaangka ngaraku. Palunyalu Mama Kuurrnga Mawutjala wangkaku. ");
INSERT INTO ntj_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nyangka-ya yarnangu pirnilu nyaku ngangkarli wirrmira tiinti tjaangka ngaralanyangka. Palunyalu-ya tiinti yungarra-yungarranguru pupakatiku. ");
INSERT INTO ntj_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tjiinya Mama Kuurrnga lurrtjurringkula Mawutjala wangkapayi. Tjiinyakurlu lurrtjurringkula yamatji-yamatji wangkama, palunyapirinypa. Nyangka Mawutjanya pakara marlaku mapitjaku ngurraku. Nyangka wati yangupala, Naanku katja Tjatjuwanya, nyarra Mawutjanya yirringkankupayi, palunyanya tiintingka tirtu marlarringkulalpi nyinama. ");
INSERT INTO ntj_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Nyangka Mawutjalu Mama Kuurrta watjarnu, “Yuwa, nyuntulu-rnin watjarnu yarnangu pirninya-tjananyarna ngurra nyarraku katitjaku. Palunyalu-munta-rnin watjalku? Ngananyan witulku lurrtjurringkula-lanyatju yankutjaku? Tjiinya-rnin watjarnu ninti-tjun nyinarranytjalu puru-tjun pukurlpa nyinarranytjalu. ");
INSERT INTO ntj_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Mularrpa-munta-tjun pukurlpa nyinarra? Palunyalu-rni watjala. Yaaltji-yaaltjilun kulira palyalkitjalu? Nyangka-rnantayi nyuntuku nintilu kuliranytjalu tirtu pukurlmanama. Kulinma tjiinya yarnangu pirninya-ya nyuntuku katja yurntalpirti nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nyangka Mama Kuurrtu watjarnu, “Ngayulu-rnanta lurrtju kutipitjaku nyangkan kurrurnpa rapa pitjalayinma.” ");
INSERT INTO ntj_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nyangka Mawutjalu watjarnu, “Wiya, tjinguru-lanyatjun lurrtju kutipitjanytjamunungka-latju ngurra ngaangkartu tirtu nyinama. Palunyangka-lanyatju wituntjamaaltu wanti. ");
INSERT INTO ntj_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tjiinya-lanyatjun lurrtju pitjalayinnyangka ngurra kutjupangkatjalu-ya nintilu kulilku tjiinya-lampatjun pukurlpa nyinarra. Palunyalu-ya kulilku ngurrkarntanku tjiinya-latju nyuntuku katja yurntalpirti nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yuwa, walykumunu. Nyuntuku wangkangka-rna lurrtju kutipitjaku. Tjiinya-rnanku ninti nyinarra. Puru-rnanta pukurltu nyakula.” ");
INSERT INTO ntj_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Nyangka Mawutjalu watjarnu, “Wiya, mukurringkula-rnanku nyuntuku tili purlkanya nyakukitja.” ");
INSERT INTO ntj_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nyangka-lu watjarnu, “Yuwa, ngayulu-rnanta tili purlkanya nyuntulawana mapitjaku. Puru-rna watjalku ngayuku yini miirl-miirlpa nyuntulun kuliratjaku. Ngayulu-rna Yaawayinya. Tjiinya-rna yungarrakurrurntu yarnangu nyakulalpi ngarlturringkula kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nyangkan kamu nyaku ngayuku yiiku. Tjiinya kutjupalu-rni ngayunya yiiku nyakulalpi mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nyangka yurirlta yapu ngarala ngayulawanan tatira ngaralatjaku. ");
INSERT INTO ntj_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Nyangka-rnanta yapu tarlarlangka tjarrpatjunkulalpi maralu yangatjunku. Palunyalu-rnanta tili purlkanyalu wayirntanku. ");
INSERT INTO ntj_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Palunyalu-rna mara wantiku. Nyangka-rnin wirtapikutju nyaku mapitjanyangka-rna. Yiiku-rnin kamu nyaku. Tjiinyamarntu-rnin nyakulalpi mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Yapu walu kutjarra kartala, nyarra ngayulu-rnanku ngaangkalpi nintirnu, palunyapirinypa. Nyangka-rnayi wangka walkatjurra, nyarra ngaangkalpi-rna walkatjunu nyangkan walu palunyanya kartarntanu, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kartala ngarnmanymarra wanti. Palunyalu ngarrirra tjirnturringkulalpi tatila yapu Tjayinayila. Palunyalu-rni yapu katu lurrtjurriwa. ");
INSERT INTO ntj_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kutjupanya katinytjamaaltu wanti. Palunyalu-rni nyuntunyakutju pitja lurrtjurriwa. Puru-tjananya marrkula yapuwana tatintjamaaltu wantitjaku. Puru tjiipu pulukatarrartu tjirtila wiyala yapu parntawanalu-ya parrangalkutjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nyangka mularrpartu Mawutjalu yapu kutjarra kartarnu. Palunyalu ngarringu mungayurntura mantjira katingu yapu Tjayinayila tatirnu Mama Kuurrta lurrtjurrikitja, tjiinya watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nyangka Mama Kuurrnga ngangkarliwana tjarungaralalpi Mawutjala ngarangu. Palunyalunku yini miirl-miirlnga Yaawayinya yungarralu mirrangu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Palunyalu Mawutjala kurranyu watipitjangu. Palunyalu mirrangu watjarnu, “Ngayulu-rna Yaawayinya. Tjiinya-rna ngarltunytju purlkanya. Puru-rna waarrpungkula mirrparnarringkulanytjamunu. Puru-rna kalkuntjatjanulu wantinytjamaaltu tirtu mukulyanytjulu kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nyangka nyarra ngayuku-tjuya mukulyanytju nyinapayi puru ngayuku wangka wangarnarralu kulira palyalpayi, palunyanya-tjananyarna mukulyanytjulu kanyinma. Puru-rna kalyparringkupayi palyamunu-ya palyaranyangka. Puru-tjanampa tjamu kaparlipirti marlangkatja-marlangkatja pakara-wanaranyangka-tjananyarna palunyapirinypartu puru kanyinma. Nyangka nyarra ngayuku-tjuya yanyan-yanyantu palyamunu palyalpayi, tjiinya-tjanamparna ngaparrtjika palyamunu yutilku. Puru-tjanamparna palunyaku katja yurntalpirtiku, tjamu kaparlipirtiku puru tjamu kaparlingkatjakutarrartu palyamunu yutira-wananma.” ");
INSERT INTO ntj_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Nyangka Mawutjanya waarrpungkulalpi pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Palunyalu watjarnu, “Yuwa Puurr, mularrpa-munta-tjun pukurlarringu? Palunyalu lurrtju-lanyatju pitjalayinma. Tjiinya-ya mularrpa tungun-tungunpa nyinarra. Nyangka kalyparringkulalpi-lanyatju kanyinma nyuntuku katja yurntalpirti nyinarratjaku.” ");
INSERT INTO ntj_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Yuwa, Yitjurayilku tjamupirti-tjananyarnanta kalkulku wantiku. Nyuntula mirangka-tjananyarnanta yayirninytjulu palyanma. Tjiinya kutjupalu kutjuwarra palunyapirinypa nyakula wantirranytjamunu. Nyangka-yan pirnilurtu nyaku kata paarnarralku ngayulu-tjanamparnanku yayirninytjulu palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Yuwa, wangarnarralu-ya kulira palyanma ngayuku wangka kuwarrinya-rna watjaranyangka. Nyangka-yan ngurra kalkuntjalakutu mapitjalanyangka-rna kurranyulu ngurrangkatja pirni pakaltjingalku, Yayimuku tjamupirti, Kayinanku tjamupirti, Yatjaku tjamupirti, Pirinyku tjamupirti, Yayipiku tjamupirti puru Tjipurrku tjamupirti. ");
INSERT INTO ntj_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Nyangka-yan ngurra nyarrangka waalkarraralpi yarnangu ngurrangkatja pirningka-tjananya wangkarra kalypa-kalypara kalkuntjamaaltu wantima, tjiinya-tjananyantaya muku-mukulku kutjupa-kutjupa pupakatirra marninypungkulatjaku, palunyakutarra. ");
INSERT INTO ntj_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Wiya, waru nyarra kuka tilira tjunkupayinya-tjanampa kartarntarra warni. Puru yapu-ya murrutjunu miirl-miirlmanu kanyiranyangka kartarntarra warni. Puru purnu pirni-tjanampaya kartarntarra warni, nyarra palyarnu-ya minyma yini Yatjaranyapirinymaralpi pupakatirra marninypungkupayinya.” ");
INSERT INTO ntj_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Nyangka Mama Kuurrtu puru watjara-wanarnu, “Kutjupa-kutjupa-ya pupakatirra marninypungkutjamaaltu wantima. Tjiinya-rna Mama Kuurrnga mirrparnarripayi kutjupa-kutjupa-yan pupakatirra marninypungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Puru ngurrangkatja pirningka-tjananyaya lurrtjurringkula wangkarra kalypa-kalypara kalkuranytjamaaltu wantima. Tjiinya-tjinguru-tjananyantaya yarltiku lurrtjurringkula kuka pungkula kutjupa-kutjupa pupakatirra marninypungkulatjaku. Puru-tjinguru-tjanampankuya kuka nintilku tjiinya-ya yapu warta nyarra pupakatirra marninypungkupayiku nintintjanya. Nyangka-yan ngalku. Palunyakutarra-tjananya wangkarra kalypa-kalypara kalkuranytjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Puru-tjinguru-ya nyuntuku-tjanampanku katjalu kungka maliki yarltiku. Palunyalu-ya kurringka minirringkulalpi yapu warta pupakatirra marninypungama. Palunyakutarra-tjananya wangkarra kalypa-kalypara kalkuranytjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Puru pupakatirra marninypungkukitjalu-ya kawurlpa tilingka paara yirralara yarnangukarrara palyaranytjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Puru Mama Kuurrtu ngaapirinypa watjarnu, “Kurli kutjupa kurli-ya yara Nyuma Tjalpu Ngalkupayinya tirtu yarrkalpungama. Tjiinya kirnara nampa 1-ta-yan nyuma tjalpu ngalkulayilku palunyalu tjirntu 7-tjanulu tjurltu-tjurltutjarra puru ngalkunma, tjiinya ngayulu-tjananyarnanta watjarnu wantinyangka. Tjiinya kirnara palunyangka-yan ngurra Yiitjipunya wantirra ngalyapakarnu, palunyanguru.” ");
INSERT INTO ntj_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Nyangka Mama Kuurrtu tirtu watjaranytja, “Yuwa, nyuntuku-tjanampanku katja tirnanya ngayuku-tjuya nyinarra. Puru-ya yanamulpa pirniku katja kurranyungkatjanya ngayuku nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Nyangka-yan tungkiku katja kurranyungkatjanya kanyilkitjalu tjiipu warlangu-tjuyan pungkulalpi nintilku. Wiyangka-tjinguru-yan tungki wantikitjalu ngurnti kartarntanku. Puru-yan katja tirnanya marlakulu kanyilkitjalu kutjupa-kutjupa-rniyan ngaparrtjika nintilku. Puru-kurlu-yan maralpa pitjaku ngayunya-rniyan pupakatirra marninypungkukitja. Kutjupa-kutjupa-rniya kati nintila.” ");
INSERT INTO ntj_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Nyangka Mama Kuurrtu tirtu watjaranytja, “Yuwa, waarka-yan palyarayilku, palunyalu ngurra 6-tjanulu tjirntu kutjupangka waarka wantirralpi nyinaku palyarriku. Palunyalu-yan ngarriku tjirnturringkulalpi puru waarka palyanma. Tjinguru waarka purlkanya ngaraku tjiinya tjinguru manta tjawara yurninypa tjunkulatjaku, tjinguru mirrka yurnmirrinyangka yurraratjaku. Wiya, wanti. Ngurra 6-tjanu-yan waarka wantirra nyinarra palyarringama.” ");
INSERT INTO ntj_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Nyangka Mama Kuurrtu tirtu watjaranytja, “Yuwa, kurli kutjupa kurli wati pirninya-yan ngurra kutjungka ngayula lurrtjurringama. Mirrka wiirpa yurnmirrinyangka-yan kutjupatjarranya yurrara katiku ngurra palunyakutu. Palunyalu ngayuku-tjuyan nintilku. Puru ngula mirrka kiripi yurnmirrinyangka-yan yurralku wiyalku palunyalu ngayula lurrtjurringkulalpi pukurltu mirrka purlkanya ngalkunma.” ");
INSERT INTO ntj_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Nyangka Mama Kuurrtu tirtu watjara-wanaranytja, “Yuwa, kurli kutjupa kurli-ya wati pirninya marnkurrara ngurra kutjungka ngayula lurrtjurringama. Tjiinyamarntu-tjanamparnanku Mama Kuurrnga Yitjurayilku tjamupirtiku Puurrpa nyinarra. ");
INSERT INTO ntj_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ngula tjiinya-tjananyarna yarnangu kutjupatjarranya pakaltjingalku. Nyangka nyuntuku-tjanampanku ngurra lipi-lipirriku. Nyangkalta-yan ngurra kalkuntjala nyinama. Nyangka-ya wati pirninya yalatjarringkula mapitjaku ngayula lurrtjurriku. Nyangka-rna maliki pirninya marrkulku warrmarlarrirra-ya pitjatjakutarra wati pirninya-rniya ngayula lurrtjurringkulanyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Nyangka Mama Kuurrtu tirtu watjaranytja, “Puru-yan kuka pungku paalku nyuma tjurltu-tjurltutjarra lurrtjura ngayuku nintintjamaaltu wantima. Wiya, nyuma tjalpukutju-rniya kukangka lurrtjuralpi nintila. Puru-yan tjiipu warlangu pungku ngalkula Wayirntankutjanya kulinma. Palunyalu yunguntjarraku-kurlu-yan tjunku wantiku. Ngala-ya pirninyartu wiyala.” ");
INSERT INTO ntj_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Nyangka Mama Kuurrtu tirtu watjaranytja, “Kurli kutjupa kurli mirrka wiirpa yurnmirringkunyangka-yan yurralku. Palunyalu-yan ngarnmanytju tjarraralpi ngayuku-tjuyan katiku tiinti miirl-miirlta nintilku. Palunyalu-yankun yurraralpi ma-kanyilku marla ngalkukitjalu.” Puru Mama Kuurrtu ngaapirinypa watjarnu, “Puru-tjinguru-yan tjiipu nanikuurrpa warlangu pungku ngalkukitjalu. Palunyalu-kurlu-yan ngunytjuku mimingka kurrkaltjunku. Wiya, kapingkakutju-ya kurrkaltjuralpi ngala.” ");
INSERT INTO ntj_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Watjarayirnu wantirralpi Mama Kuurrtu Mawutjanya watjarnu, “Wangka palunyanya walkatjurra wanti. Tjiinya-tjananyarnanta kalkurnu wantingu nyuntunya puru Yitjurayilku tjamupirti-tjananya walykumunura kanyilkitjalu, wangka palunyanya-yan wangarnarralu kulira palyaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Nyangka Mawutjanya Mama Kuurrta rawa nyinarrayirnu tjirntu 40-rringu. Tjiinya nyinarranytjalulpi mirrka ngalkunytjamaalpa puru kapi tjikintjamaalpa tirtu nyinarranytja. Palunyalu wangka 10-nga yapu walu kutjarrangka walkatjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nyangka Mawutjalu walu kutjarra Mama Kuurrku wangkatjarra mantjiralpi yapu Tjayinayilanguru tjarungarangu. Nyangka palunyaku yiiku yirrnyaranytja. Tjiinyamarntu Mama Kuurrta wangkarranytja. Nyangka kulintjamaalpa ngurrpartu pitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nyangka-ya Yarantu, yarnangu pirnilutarrartu nyangu Mawutjaku yiiku yirrnyaranyangka. Palunyalu-ya ngurlurringkulalpi tiwanguru ngarala nyakulanytja. ");
INSERT INTO ntj_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nyangka Mawutjalu-tjananya yarltingu Yarannga puru liita pirninya. Nyangka-ya pitjangu kutjungkarringu. Nyangkalta-tjananya wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Palunyatjanungka-ya yarnangu pirninyartu mapitjangu kutjungkarringu. Nyangka-tjananya tjakultjuranytja wangka pirninyartu Mama Kuurrtu-lu yapu Tjayinayila watjarnu wantinytjanya. ");
INSERT INTO ntj_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Palunyalu-tjananya wangkangu wiyarringkulalpi Mawutjalunku yiiku yangkingkapirinypa tjuturnu. ");
INSERT INTO ntj_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Palunyalu tiintingka tjarrparra Mama Kuurrta wangkakitjalu yangki yarralpayi. Palunyalu mapakaralpi-tjananya Yitjurayilku tjamupirti tjakultjunkupayi Mama Kuurrtu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Nyangka-ya nyaku Mawutjaku yiiku yirrnyaranyangka. Nyangka Mawutjalunku marlakulu yiiku tjutulku. Ngarna Mama Kuurrtakutu tjarrparralpi yarralku. ");
INSERT INTO ntj_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","3","Nyangka Mawutjalu-tjananya yarnangu pirninya yarltingu kutjungkaralpi watjarnu ngurra 6-tjanulu-ya tjirntu kutjupangka waarka wantirra nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","9","Puru Mawutjalu-tjananya watjarnu kutjupa-kutjupa walykumunu-ya katirra nintiltjaku. Nyangka-yayi tiinti miirl-miirlpa palyala. ");
INSERT INTO ntj_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","19","Puru Mawutjalu-tjananya watjarnu wati walykumunu palyalpayilu-ya pitjala palyaltjaku. Tjiinya warta palyalpayi, yapu palyalpayi, purrmu rulyupungkupayi, tiriyalpa kultulpayi, puru walka walykumunu walkatjunkupayi. ");
INSERT INTO ntj_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","29","Nyangka-ya yarnangu pirnilu wuyurrarringkulalpi kutjupa-kutjupa walykumunu katirra nintiranytja tiinti miirl-miirlpa-ya palyaltjaku. Yapu walykumunu-ya katingu tjilpa, kawurlpa puru kutjupa-kutjupa puru warta walykumunu, tiriyalpa walykumunu, purturru walykumunu, minyarra walykumunutarrartu. Wiya, walykumunu mularrpa-ya katirra nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","35","Nyangka Mawutjalu-tjananya yarnangu pirninya watjarnu, “Mama Kuurrtu-pulanya wati kutjarra miratjunu tjiinya-pula nintipuka purlkanya. Nyangka-pula tjurrkurlmara kanyinma-tjananya walykumunu palyalpayi kutjupatjarralu-ya waarka palunyanya palyaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","7","Nyangka-ya yarnangu pirnilu kutjupa-kutjupa walykumunu tirtu katirra nintiranytja. Nyangka-ya wati walykumunu palyalpayilu Mawutjala watjarnu, “Wiya, wiyangkalpi-ya pirni katingu. Nyangka watjala wantitjaku-ya.” Nyangka Mawutjalu-tjananya yarnangu pirninya watjarnu, “Wiyangkalpi pirnirringu. Nyangka-ya wanti.” ");
INSERT INTO ntj_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","38","Nyangka-ya wati walykumunu palyalpayilu tiinti miirl-miirlpa palyarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","9","Nyangka wati kutjulu puuka miirl-miirlpa palyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","16","Palunyalu tayipulpa nyuma tjunkupayinya palyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","24","Palunyalu puru lantanpa kawurlpa palyarnu tili 7-tjarra. ");
INSERT INTO ntj_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","28","Puru wati palunyalurtu palyarnu waru nyarra parnti walykumunu kampapayinya. ");
INSERT INTO ntj_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Palunyalu puru parnti walykumunu uyilpangka warli-warlirnu. Puru parnti walykumunu pulparru palyarnu tjunu. ");
INSERT INTO ntj_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","7","Nyangka wati palunyalu palyarnu waru nyarra kuka tilira tjunkupayinya. ");
INSERT INTO ntj_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Palunyalu tiirrtji purlkanya palyarnu mara tjina-ya parltjiltjaku. ");
INSERT INTO ntj_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","20","Palunyalu warntu kartaralpi yaarrpa parrapalyarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","31","Nyangka-ya kawurlpa tjilpa yayinpatarrartu kati-katirranytja. Nyangka wati nintipuka pirnilu-ya yulytja pirninya tiinti miirl-miirlku palyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","31","Nyangka-ya warntu walykumunu palyarnu tjarrpatjunkula-ya tiinti miirl-miirlta waarka palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","43","Nyangka-ya pirninyartu palyarayirnu wiyarnu, tjiinya Mama Kuurrtu Mawutjala watjarnu wantingu, palunyapirinypartu. Palunyalu-ya katingu Mawutjalakutu nyakutjaku. Nyangka pirninyartu purinytju parranyakulayirnu pukurlarringu tjiinya-ya tjukarurrulu palyannyangka. Palunyalu-tjananya marninypungu. ");
INSERT INTO ntj_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","33","Nyangka Mama Kuurrtu Mawutjala watjarnu tiinti miirl-miirlpa pupatjunkutjaku. Palunyalu watjarnu puuka miirl-miirlpa-ya kaninytjarra tjarrpatjunkutjaku. Tjiinya puuka kaninytjarra yapu walu kutjarra ngarrirranytja Mama Kuurrku wangka 10-tjarra. Nyangka Mama Kuurrtu watjarnu warntu walykumunu waraly-waralytjunkutjaku puuka miirl-miirlta kalkurni. Palunyalu watjarnu tayipulpa nyuma tjunkupayinya katirra tjunkutjaku, puru lantanpa tili 7-tjarra katirra tjunkutjaku. Puru ngaapirinypa watjarnu, “Puru waru nyarra parnti walykumunu kampapayinya kati tjurra puuka miirl-miirlta kalkurni. Palunyalu warntu waraly-waralytjurra tiinti tjaawanalu. Palunyalu waru nyarra kuka kampapayinya kati yilkaku ngaratjurra. Palunyalu tiirrtji purlkanya kati ngururrkutjarra tjurra. Palunyalu kapi tjutila tiirrtjingka. Palunyalu warntu pirni lurrtjura parrawaraly-waralytjunkula yaarrpirinypa parrangaratjurra wanti. Nyangka-yayi kaninytjarra ngarama. Palunyalu warntu kutjupa tjaawanalu waraly-waralytjurra. Palunyalu uyilpa miirl-miirlpa pirningkartu tjutila miirl-miirlmarra.” Nyangka Mawutjalu mularrpartu watjarnu-tjananya nyangka-ya palunyapirinypartu palyarnu. ");
INSERT INTO ntj_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Nyangka ngangkarli wirrmiralu pitjangu tiinti miirl-miirlnga tjutura kanyiranytja. Nyangka tili purlkanyalu yutira kanyiranytja tjiinyamarntu Mama Kuurrnga nyinarranyangka. Nyangka-ya purtu nyakulanytja. ");
INSERT INTO ntj_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Palunyanguru Mawutjanya tiinti palunyangka purtu tjarrpangu wantingu. ");
INSERT INTO ntj_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Nyangka ngangkarli palunyalu Yitjurayilku tjamupirti-tjananya parrakatirrayintja. Tjiinya-ya yungarra pakalkitjamunu. Ngarna ngangkarli tiintinguru pakannyangka-ya pakalku yalatjarringkula kutipitjapayi. ");
INSERT INTO ntj_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Nyangka ngangkarli tiintingka ngaralanyangka-ya ngurrangka nyinama. ");
INSERT INTO ntj_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tjiinya-ya ngurra kutjupa-kutjupaku yalatja mapitjalayintjalu karlarla nyaku Mama Kuurrku ngangkarli tiintinguru ngaralanyangka. Palunyalu-ya mungangka nyaku tili warupirinypa kamparranyangka. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nyangka Mama Kuurrtu Mawutjanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Watjala-tjananya Yarannga puru palunyaku katjapirti ngaapirinytju-ya Yitjurayilku tjamupirtiku tjapiratjaku. Nyangka ngayulu-tjananyarnayi walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Watjala-tjananya ngaapirinytju-tjanampa tjapiltjaku, ‘Yuwa Mama, walykumunura-tjananya kanyinma puru miranykanyira kanyinma. ");
INSERT INTO ntj_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Palunyalu-tjananya kurrurnpa muku-mukulu ngarltunytjulu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Palunyalu-tjananya pukurltu nyakula kurrurnpa rapara kanyinma.’” ");
INSERT INTO ntj_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Nyangka Mama Kuurrtu ngaanyatarrartu watjarnu, “Yuwa, tjiinya-tjinguru-ya Yarantu puru palunyaku katjapirtilu-ya ngayuku yiniwanalu palunyapirinypa tjapilku. Nyangka-tjananyarna mularrpartu walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Nyangka tjiinya-ya tiinti miirl-miirlnga pupatjunu wantingu. Palunyangka yutuwari palunyanya yangatjura kanyilpayinya pitjangu katu ngaralanytjalu tjutura kanyiranytja. Nyangka mungangka-ya nyakupayi yutuwari palunyanya warupirinypa tili kamparranyangka tiinti katalarra. ");
INSERT INTO ntj_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","19","Nyangka Mama Kuurrtu-tjananya yutuwariwanalu nintitjunkupayi. Nyangka-ya mularrpartu pakara yalatja yankula ngurra ma-tjunkupayi. Tjiinya yutuwari tiinti miirl-miirlta katu ngaralanyangka Yitjurayilku tjamupirti-ya ngurrangka tirtu nyinapayi. Nyangka yutuwari palunyanya yurrirra pakara kurranyu yankulanyangka-ya palunyanyartu mirara wanalpayi. Nyangka yutuwari ngaranyangka ngurra-ya tjunkula nyinapayi. ");
INSERT INTO ntj_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","22","Tjiinya yutuwari tirtu ngaralanyangka-ya pakara yankukitjamunu. Ngarna yutuwari yurrinyangkakutju-ya yarnangu pirninya yurriku. Tjiinya-tjinguru yutuwari ngurra kutjutjanu yurrinyangka-ya pakara wanalku. Nyangka-tjinguru yutuwari palunyanya rawa ngaralayilku kurli kutjutjanu yurriku. Nyangka-ya rawa nyinarrayilku nyaku yutuwari yurrinyangkakutju pakara wanalku. ");
INSERT INTO ntj_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Tjiinya-ya yungarrakurrurntu ngurra tjunkukitjamunu. Puru-ya yungarrakurrurnpa pakara yankukitjamunu. Ngarna Mama Kuurrtu Mawutjanya nintitjunkunyangka-ya pakara yalatja yankupayi. ");
INSERT INTO ntj_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nyangka-ya Yitjurayilku tjamupirti rawa nyinarranytja Mama Kuurrku yapu miirl-miirlpa Tjayinayila. Palunyatjanu-ya pakara yalatja yanu. Nyangka-ya Liipayiku tjamupirtilu Mama Kuurrku puuka miirl-miirlnga kurranyulu katirrayintja Mama Kuurrtu-tjananya yutuwariwanalu ngurra nintitjuratjaku. Nyangka-ya pitjalayirnu ngurra marnkurrtjanulu ngurra tjunu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Tjiinya Mama Kuurrku yutuwarilu-tjananya tirtu walara katirrayilpayi. ");
INSERT INTO ntj_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tjiinya tjirntu kutjupa tjirntu, yarnangu pirninya-ya yankukitja ngaralanyangka Mawutjalu Mama Kuurrnga ngaapirinypa tjapilpayi, “Yuwa Mama, pakala yanyan-yanyanpa nyinapayinya-tjananya ngurlutjingala. Nyangka-yayi wililyarrara kukurraala.” Palunyapirinypa Mawutjalu tirtu tjapilpayi. ");
INSERT INTO ntj_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Nyangka-ya puuka miirl-miirlpa katirrayintjalu pitjalayilku ngaraku. Nyangka Mawutjalu Mama Kuurrnga puru tjapilpayi, “Yuwa Mama, pitja-lanyatju ngamuntirri kanyinma Yitjurayilku tjamupirti-latju minga-minga nyinarranyangka.” Nyangkalta-ya ngurra ma-tjunku. ");
INSERT INTO ntj_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Nyangka-ya yarnangu pirninya kutjupa-kutjupatjirratja Mama Kuurrku mirrparn-mirrparnarringkulalpi wangkarranytja. Nyangka Mama Kuurrtu-tjananya kuliralpi mirrparnarringu. Palunyalu-tjanampa waru tjaarrtjingarnu. Nyangka ngurrawana kamparranytja. Palunyalu kampakutjunguru tiinti pirninya kamparra-parrawanarayintja. ");
INSERT INTO ntj_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Nyangka-ya mirrarra watjaranytja Mawutjalu-tjananya yirringkankutjaku. Nyangka mularrpartu Mawutjalu Mama Kuurrnga tjapirnu. Nyangkalta waru wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nyangka-ya palunyanguru ngurra palunyanya tjapirnu yini Tapiranya. Tjiinya yini palunyanya ngaapirinypa, Kamparranytjanya. ");
INSERT INTO ntj_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nyangka-ya maliki pirnitarrartu yaanarringu pitjalayintja. Palunyalu-ya kukatjirratja wangkarranytja. Nyangka-ya Yitjurayilku tjamupirti minirringkulalpi kukatjirratja wangkarranytja, “Kukapalka-lanku ngalkula nyinama. ");
INSERT INTO ntj_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ngurra nyarra Yiitjipulalpi-lanku kuka yurungkatja purtu ngalkula wantipayi. Palunyalu-lanku mirrka kutjupa-kutjupa pirni ngalkupayi, milinpa, kuyukampa yannyinpatarrartu. ");
INSERT INTO ntj_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ngaanya-lan nyirnurru nyinarra. Tjirntu kutjupa tjirntu-lanku mirrka manakutju tirtu ngalkula.” ");
INSERT INTO ntj_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Tjiinya mana mirrka kutjupa-kutjupa, tjiinya yurninypa pirntalpa kurlunypirinypa. ");
INSERT INTO ntj_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Tjiinya mungangka kulyarrtjunkupayi, palunyangka mirrka manatarrartu yilkaringuru punkara-ya ngarripayi. Nyangka-ya tjirntungka pakaralpi yurralku katiku rulyupungku. Palunyalu-ya kurrkaltjunku lalyuralpi nyumatjunku paalku. Tjiinya mayu walykumunu nyuma uyilta paantjapirinypa ngarripayi. ");
INSERT INTO ntj_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Nyangka Mawutjalu kulirnu yarnangu pirninya-ya kukatjirratja wangkarranytja. Tjiinya-ya purrulpa kutjupa purrulpa kutjupa tiinti tjaanguru ngarala wangkarranytja. Nyangka kuliralpi walykurringu. Tjiinyamarntu-ya Mama Kuurrnga mirrparnmanu. ");
INSERT INTO ntj_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nyangka Mawutjalu Mama Kuurrnga tjapirnu, “Mirrparnpa-munta-tjun? Nyaaku-rnin watjarnu yarnangu ngaa minga-minga-rna miranykanyiratjaku? ");
INSERT INTO ntj_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ngayunya-munta-tjanamparna ngunytju? Nyaaku-rnin watjarnu pilyirrpirinypa-tjananyarna yampura katirrayiltjaku ngurra nyarra kalkuntjalakutu? ");
INSERT INTO ntj_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Wanytjanyanyka-tjanamparna kuka mantjilku? Tirtu-rniya yulatjarralu kukaku ngatjira. ");
INSERT INTO ntj_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Kutjulu-munta-tjananyarna miranykanyira kanyinma? Purtu-rna kulira. Nganalunyka-rni yirringkanku? ");
INSERT INTO ntj_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tjinguru-rnin yirringkankukitjamunulu kuwarrinya mirrirntanku, ngarltutjarralu-rna purtu kuliranyangka.” ");
INSERT INTO ntj_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Nyangka Mama Kuurrtu watjarnu, “Yuwa Mawutja, wati purlkanya 70-tjananya ngurrkarntara kati tiinti miirl-miirlkutu. Nyangkanta-yayi yitingkartu ngarama. ");
INSERT INTO ntj_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nyangkalta-rna palunyangkartu tjarungara wangka. Palunyalu-tjanamparna Kuurti Walykumununya yungku, tjiinya-rnanku nyuntuku yungu, palunyapirinypartu. Nyangkanta-ya yirringkanama. Nyangka-yan pirnilurtu yarnangu pirninya miranykanyira kanyinma. ");
INSERT INTO ntj_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Nyangka-tjananya yarnangu pirninya watjala ngaapirinypa, ‘Tjirntungka-yanku parltjila walykumunurringkulalpi nyina. Tjiinyamarntu Mama Kuurrtu-tjananyanta kulirnu kukatjirratja-yan wangkarranyangka. Puru-tjananyanta kulirnu Yiitjipulakutu-yan marlaku yankukitjalu watjaranyangka. Yuwa, Mama Kuurrtu-tjanampanku kuka yungku. Nyangka-yan ngalkunma. ");
INSERT INTO ntj_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","Rawalu-yan ngalkulayilku kaarr-kaarrarriku wantiku. Tjiinya-yan tjirntu kutjupa tjirntu ngalkula-wanarayilku wiiki kutjarra-kutjarra wiyarringkunyangka kaarr-kaarrarriku. Kulila-ya. Mama Kuurrnga-yan lurrtju pitjalayintja. Nyangka-yan wantirralpi mukurringkula Yiitjipulakutu marlaku yankukitja. Palunyangurungka-tjanampanku kuka purlkanya yungku. Nyangka-yan ngalku-ngalku kaarr-kaarrarringkulalpi wantiku.’” ");
INSERT INTO ntj_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Nyangka Mawutjalu Mama Kuurrta watjarnu, “Wiya, yarnangu minga-minga-rniya ngayulawana pitjalayirni, wati 600,000-pa-ya puru minyma tjilkutarrartu-ya. Yaaltjilunyka-tjanampan kuka yungku ngalkula-ya wiiki kutjarra-kutjarrarritjaku? ");
INSERT INTO ntj_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Nyangka-munta-latju puluka tjiipu pirninyartu pungkulayilku-tjanampa nintilku? Wiya, kuka marnkurr-marnkurrpa-ya ngaanya. Kuka kapingkatja-munta-latju tjulyara-wanarayilku wiyalku nyangka yurukutju ngarama? Wiya, kuka kurlunypa-ya kapingka ngarrirra. Nyangka-ya yarnangu pirni mularrpa.” ");
INSERT INTO ntj_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Nyangka Mama Kuurrtu watjarnu, “Ngayulu-munta-rna kutjupa-kutjupa purtu palyalku? Wiya, ngayulu-rna yayirninytjulu kutjupa-kutjupa palyalku. Nyangkan nyinarrayilku nyaku ngayuku wangka yartakarrinyangka.” ");
INSERT INTO ntj_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Nyangka-tjananya Mawutjalu mapitjangu yarnangu pirninya watjarnu Mama Kuurrtu watjarnu wantitjanya. Palunyalu-tjananya liita 70-nya yarltirra katingu tiinti miirl-miirlta yurirlta parrangaratjunu. ");
INSERT INTO ntj_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Nyangka Mama Kuurrnga yutuwariwana tjarungaralalpi Mawutjala wangkangu. Palunyalu-tjanampa liita 70-ku Kuurti Walykumununya nintirnu, tjiinya Mawutjaku nintirnu, palunyapirinypartu. Nyangka Kuurti Walykumunulu-tjananya wuyurrmaranyangka-ya Mama Kuurrku wangka nintipukalupirinypa watjarnu ngamurtu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Tjiinya liita kutjupa kutjarranya yini Yaltarrnga puru Miitarrnga tiinti miirl-miirlkutu yankutjamaalpa ngurrangka nyinarranytja. Nyangka Kuurti Walykumunulu-pulanya wuyurrmanu. Nyangka-pula palunyapirinypartu Mama Kuurrku wangka watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Nyangka wati yangupala kutjulu-pulanya nyakula kukurraarnu Mawutjala tjakultjunu, “Tjii-pula Mama Kuurrku wangka watjara.” ");
INSERT INTO ntj_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nyangka wati yini Naanku katja, Tjatjuwalu tjiinya Mawutjanya yirringkankupayilu watjarnu, “Wiya puurr, marrkula-pulanya wangkanytjamaalpa-pula nyinatjaku.” ");
INSERT INTO ntj_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Nyangka Mawutjalu watjarnu, “Tjingurun kulira ngayulukutju-rna Mama Kuurrku wangka watjara. Wiya, pukurlarriku-rna Mama Kuurrtu Kuurti Walykumununya yarnangu pirnikurtu nintinnyangka. Nyangka-ya pirnilurtu palunyaku wangka watjanma.” ");
INSERT INTO ntj_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Nyangka-ya Mawutjanya, puru liita 70-nyatarrartu ngurraku marlaku yanu. ");
INSERT INTO ntj_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Nyangka Mama Kuurrtu pirriya purlkanya pakaltjingarnu. Nyangka kapi yuru purlkanyanguru ngalyawangkarranytjalu tjurlpu mantayurntilpa pirni-pirni katingu. Nyangka-ya yilkaringuru punkarayirnu-punkarayirnu parna yangatjura katuwana ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Nyangka-ya yarnangu pirnilu tjirntungka pakaralpi yurrara pungkulayirnu mungarringkulalpi yurrara pungkulayirnu tjirnturringu. Palunyatjanu-ya yurrara pungkulayirnu ma-mungarringu. Tjiinya-yanku kutju-kutjulu pirnipurlka yurrara pungkulanytja. Palunyalu-yanku parratjunkula-wanara wantirranytja tjirntulu kamparra pikiltjaku. ");
INSERT INTO ntj_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nyangka kuka tirtu ngarrirranyangka Mama Kuurrnga-tjanampa mirrparnarringkulalpi pika purlkanya-tjanampa yungu. Nyangka-ya kutjupatjarra pikatjarrarringkula-wanarnu mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nyangka-ya ngurra palunyanya tjapirnu yini Kipura-Yatapanya. Tjiinya yini palunyanya ngaapirinypa, Ngayarrka Pirniku Kurrulpa. Palunyangkamarntu-tjananyaya tjurnutjunu yarnangu nyarra kukaku ngayarrka pirninya. ");
INSERT INTO ntj_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Nyangka-ya yarnangu pirnilu ngurra palunyanya wantirra pakara yanu. Pitjalayirnu-ya ngurra yini Yatjaratjala ngurra tjunkulalpi nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Nyangka tjiinya Mawutjalunku kurri minyma Yitjiyupinyamartatji yarltingu kanyiranytja. Nyangka palunyaku kurta Yarantu-pula tjurtu Miriyamalu yayirnirringkula tjumara ngaapirinypa watjaranytja, “Wiya, marlanytju-tjinguru kungka maliki yarltinytjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Puru-pulanku ngaparrkulu watjaranytja, “Mama Kuurrnga-munta Mawutjalakutju wangkarranytja? Wiya, ngayulatarrartu-linya wangkarranytja.” Nyangka Mama Kuurrtu kulirnu wangkarra kuliranyangka-pula. ");
INSERT INTO ntj_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Tjiinya Mawutjanya karnany-karnanymaalpa watatjanku nyinarranytja. Tjinguru wati kutjupapirinytju kulira mirrparnarringama tjumara watjaranyangka. Ngarna muku-muku nyinanytjatjanulu kulirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Nyangka Mama Kuurrtu-tjananya tjulurrtjingaralpi watjarnu, “Mawutja, Yaran, Miriyama, pitja-ya ngara tiinti miirl-miirlta.” Nyangka-ya mularrpartu pitjangu ngarangu. ");
INSERT INTO ntj_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nyangka Mama Kuurrnga ngangkarli wirrmirawana tjarungarangu tiinti tjaangka ngaralanytja. Palunyalu Yarannga-pulanya Miriyamanya yarltingu. Nyangka-pula mularrpartu ngamuntirringkula pitjangu ngarangu. ");
INSERT INTO ntj_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Nyangka Mama Kuurrtu watjarnu, “Kulila-pula wangka ngaanya-pulanyarnanta watjaranyangka. Tjiinya wati minyma pirnilu-ya ngayuku wangka kulira mawatjalpayi. Nyangka kutjupatjarralu-rniya winkirrtu ngarrirra nyakupayi wangkarranyangka-rna, puru tjumalutarrartu-rniya nyaku. ");
INSERT INTO ntj_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","8","Ngarna Mawutjalukutju-rni kulilpayi lurrtjurringkula-rnalu wangkarranyangka. Wangka kamparntalpa-rnalu wangkarranytjamunu, wangka yartaka-rnalu wangkapayi. Nyangka-rni yarnangutarrartu nyakupayi. Tjiinyamarntu Mawutjalu-tju ngayuku waarka palyalpayi. Nyangka-rnalu watjarnu ngayuku katja yurntalpirti miranykanyira kanyiratjaku. Nyangka-pula ngayuku waarka palyalpayi Mawutjanya yayirnirringkula watjantjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nyangka-pulampa Mama Kuurrnga mirrparnarringkula wantirra yanu. ");
INSERT INTO ntj_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nyangka ngangkarli pakannyangka Miriyamalunku nyangu miri ngaa purrtjutjarrarringkulalpi pirntalarringu. Nyangka Yarantu nyakulalpi ");
INSERT INTO ntj_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","12","Mawutjanya watjarnu, “Wiya puurr, katakurralu-litju palunyapirinypa watjaranytja. Ngarlturringkulalpi-lu yirringkala miri yurnarringkula wiyarritjakutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Nyangka Mawutjalu Mama Kuurrnga tjapirnu, “Mama, ngarlturringkulalpi-lu walykumunula.” ");
INSERT INTO ntj_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nyangka Mama Kuurrtu watjarnu, “Kulila-rni ngarnartu-rnanta ngaanya watjaranyangka. Tjinguru palunyaku mamalu mirrparnarrirralpi yiiku tjuupungku. Nyangka kurntarringkula mapitjaku nyinarrayilku tjirntu 7-tjanu marlaku pitjama. Nyangka-lu watjala yankula mawurntalpa ngurrangka yilkaku nyinarra tjirntu 7-tjanu marlaku pitjatjaku.” ");
INSERT INTO ntj_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Nyangka Mawutjalu mularrpartu watjarnu. Nyangka mularrpartu Miriyamanya yanu ngurrangka yilkaku nyinarranytja. Nyangka-ya yarnangu pirninya ngurra palunyangkartu nyinarrayirnu nyangu Miriyamanya pika wiyarringkulalpi marlaku pitjanyangka. ");
INSERT INTO ntj_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Palunyanguru-ya ngurra nyarra Yatjaratjanya wantirra yanu ngurra tjunu mayu-mayu Paranta ngamu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","16","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Yuwa, wati 12-pa-tjananya ngurrkarntaralpi witula ngurra nyarra Kayinannga-ya parranyakula marlaku pitjala tjakultjunkutjaku.” Nyangka Mawutjalu mularrpartu wati 12-pa-tjananya ngurrkarntaralpi witurnu ngurra-ya yankula parranyakulatjaku, ngurramarntu lipi purlkanya ngaralanyangka. Tjiinya wati 10-pa puru Tjatjuwanya-pulanya Kayilapanyatarrartu ngurrkarntanu. ");
INSERT INTO ntj_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Palunyalu-tjananya wituralpi watjarnu, “Ngaanguru-yan kayili yanku. Palunyalu ngurra nyarra Kayinanta yurlparirra tjarrparra tirtu mapitjaku ngurra purlitjarrakutu. ");
INSERT INTO ntj_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Palunyalu-ya parranyawa, ‘Ngurra nyaapirinypa ngarala? Yarnangu-munta-ya pirni nyinarra? Warrmarla-munta-ya pirni nyinarra? ");
INSERT INTO ntj_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ngurra-munta walykumunu nyinarratjaku-lan? Yiwarla-munta-ya yurirlpangka ngarala? Wiya-tjinguru yiwarla pirninya-ya yaarrpa witu-witu walutjarrangka ngarala. ");
INSERT INTO ntj_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Manta-munta walykumunu mirrka-lan pakaltjingaltjaku? Purti-munta purlkanya ngarala?’ Tjiinya mirrka kiripi-tjinguru yurnmirringu. Puru mirrkatarrartu-ya nyakula mantjira marlakulu kati yarrkaltjaku-latju.” ");
INSERT INTO ntj_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","22","Nyangka-ya mularrpartu yanu parranyakulayintja. ");
INSERT INTO ntj_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Palunyalu-ya karru-karruwana pitjalalpi mirrka kiripi tjangkurnpa purlkanya nyakulalpi kartarntanu. Nyangka-pula wati kutjarralu wartangka karrpirnu takungka tjunkulalpi katirrayintja. Palunyalu-ya yirli, mirrka kutjupa-kutjupatarrartu yurrarnu katirrayintja. ");
INSERT INTO ntj_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Nyangkalta-ya karru-karru palunyanya yini Yilykalnga tjapirnu. Tjiinya yini palunyanya ngaapirinypa, Kiripi Tjangkurnpa Purlkanyatjarranya. ");
INSERT INTO ntj_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Parranyakulayirnu-ya kirnara kutjarratjanu marlaku pitjangu ");
INSERT INTO ntj_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ngurra nyarra Kayititjalakutu, tjiinya-ya Mawutjanya, Yarannga puru yarnangu pirninyatarrartu mayu-mayu nyinarranyangka ngurra nyarra Paranta ngamu. Palunyalu-tjananyaya mirrka katingu nintitjunu puru kutjupa-kutjupa nyakunytjatjanulu tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Palunyalu-ya Mawutjala watjarnu, “Ngurra yarla walykumunukutju-latju parranyakulayintja. Tjiinya manta walykumunu ngarala mirrka purlkanya pakaltjingaltjaku. Nyawa. Mirrka-latju purlkanya katingu. ");
INSERT INTO ntj_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nyangka-ya yarnangu ngurra palunyangka yiwarla purlkanyangka nyinarra warrmarla pirnitjarra. Nyangka yunta yapu witu-witutjarralu yiwarla pirninya ngururrtjura kanyira. Puru-latju nyangu tjangarapirinypa-ya wirrmira purlkanya ngurra palunyangka nyinarra. ");
INSERT INTO ntj_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Tjiinya-ya Yamalikiku tjamupirti yurlparirrawana nyinangu. Nyangka-ya Yatjaku tjamupirti, Tjipurrku tjamupirti puru Yayimuku tjamupirti ngurra purlitjarrangka nyinarra. Nyangka-ya Kayinanku tjamupirti yuru purlkanyangka kantilywana nyinarra, puru kapi Tjuutantawana.” ");
INSERT INTO ntj_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Nyangka-ya yarnangu pirni ngamunguru ngaralanytjalu kuliralpi wangka-wangkarranytja. Nyangka Kayilapalu-tjananya kanmarrmaralpi watjarnu, “Wiya, kuwarrinyartu-la yarra-tjananya wakala wiyala. Palunyalu-la ngurrararringkulalpi nyinama. Palya-lan yanku ngurra palunyaku puurrarriku.” ");
INSERT INTO ntj_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nyangka-ya wati kutjupatjarra nyarra Kayilapala yanu lurrtjulu parranyakulayintjatjanulu watjarnu, “Wiya, purtu-lan wakalku wiyalku. Tjiinya-ya warrmarla pirnitjarra nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Palunyalu-ya ngurra palunyatjarra mayuratarrartu ngaapirinypa watjaranytja, “Wiya, ngurra yayilurru. Mirrka tjuku-tjuku ngarala. Nyangka-ya yarnangu pirni mirrkatjirratja mirrirringkukitja nyinarra. Nyangka-latju nyangu wati wirrmirakutju-ya nyinarra. ");
INSERT INTO ntj_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Palunyalu-latju nyangu tjangara pirninya Yanakiku tjamupirti nyinarranytja. Palunyalu-latjunku yungarralu nyangu kurlunypa tjintilykapirinypa. Nyangka-tjinguru-lanyatjuya nyakulalpi kulirnu tjintilykapirinypa-latju kurlunypa. Palunyanyamarntu-ya wati purlkanya pirni.” ");
INSERT INTO ntj_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nyangka-ya yarnangu pirnilu tjukurrpa palunyanya kuliralpi ngurlu yularranytja. Yularrayirnu-ya mungarringkulalpi yularrayirnu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Palunyatjanu-ya Mawutjaku-pulampa Yaranku mirrparn-mirrparnarringkulalpi ngaapirinypa watjaranytja, “Wiya, tjinguru-latju palya nyarrangkalpi Yiitjipula mirrirringama. Puru-tjinguru-latju palya ngaangka mayu-mayu mirrirringama. ");
INSERT INTO ntj_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mama Kuurrtu-lanyatju nyaaku katirrayirni ngurra nyarra pika pungkupayilakutu? Pika-lanyatjuya wakalku mirrirntanku. Palunyalu-lampatjuya kurri tjilkutarra tjulyara katiku wiyalku. Tjinguru-latju walykumunu nyinama Yiitjipula.” ");
INSERT INTO ntj_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Palunyalu-yanku yungarralu ngaparrku watjaranytja, “Wiya, liita kutjupa-la ngurrila mantjila. Nyangka-lanya Yiitjipulakutu marlakulu kati.” ");
INSERT INTO ntj_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Nyangka-pula Mawutjanya Yarannga yarnangu pirningka mirangka mantangka pupakatingu Mama Kuurrta wangkakitja. ");
INSERT INTO ntj_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nyangka-pulanku Tjatjuwalu Kayilapalu tjuni walykurringkulalpi warntu wartunpungu. ");
INSERT INTO ntj_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Palunyalu-pula yarnangu pirninya watjarnu, “Wiya, ngurra walykumunukutju-latju parranyakulanytja. ");
INSERT INTO ntj_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nyangka-lan Mama Kuurrku wangka wangarnarralu kulira palyaranyangka pukurlarriku-lampa. Palunyalu-lanya makatiku tjarrpatjunku ngurra nyarra walykumunungka. ");
INSERT INTO ntj_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Tungun-tungunarriku-kurlu-yan. Wanti. Nyaaku-yan ngurlurringkula yarnangu palunyaku-tjanampayan? Tjiinya Mama Kuurrtu-lanya miranykanyira kanyira. Nyangka-ya warrmarla nyarralu-lanya purtulinku wantiku. Ngurlurringku-kurlu-tjanampayan. Wanti.” ");
INSERT INTO ntj_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nyangka-ya yarnangu pirnilu kulirnu wantirralpi watjaranytja yatura-pulanyaya mirrirntankukitjalu. Palunyalulta-ya ma-nyangu Mama Kuurrku tili purlkanya yartakarringu tiinti miirl-miirlta ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Nyangka Mama Kuurrtu Mawutjala watjarnu, “Wiya, ngayulu-tjanamparna yarnangu ngaa pirniku yayirninytjulu kutjupa-kutjupa yartakaranytja. Nyangka-rniya tirtu wantirra. Tirtu-rniya mularrkulintjamaaltu tungun-tunguntu wantirra. ");
INSERT INTO ntj_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Wiya, pika purlkanya-tjanamparna yutilku. Nyangka-ya pirninyartu wiyarriku. Nyangka-rna nyuntuku tjamu kaparlipirtikutju kanyilku. Nyangka-yayi ngula yarnangu ngaanya-tjananya wayirntaralpi pirnipurlka nyinama.” ");
INSERT INTO ntj_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","14","Nyangka Mawutjalu Mama Kuurrta watjarnu, “Wiya, nyuntulu-lanyatjun Yiitjipulanguru yayirninytjulu yarltirra katingu. Nyangka-ya yarnangu nyarra Kayinanta nyinapayilu nintilu kulira nyuntulu-lanyatjun lurrtju pitjalayintja. Nintilu-ya kulira tjiinya-lanyatjun yutuwaringka yartakarripayi, palunyalu-lanyatjun tjirntungka ngangkarli wirrmiralu kurranyulu katirrayilpayi. Palunyalu-lanyatjun ngangkarli waru tililu mungangka kanyilpayi. Nyangka-tjinguru-tjananyan katja yurntalpirti ngurra ngaangkartu pungku mirrirntanku. Nyangka-ya Yiitjipunyamartatji pirnilu kuliralpi tjakultjunku yarnangu nyarra Kayinanta nyinapayi pirningka. ");
INSERT INTO ntj_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nyangka-ya yarnangu kutjupatjarralu kuliralpi panypuratjarralu watjalku, ");
INSERT INTO ntj_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","nyuntulu-tjananyanyun purtu katingu ngurra nyarra kalkuntjala tjarrpatjunu. Palunyanguru-tjananyanyun mayu-mayurtu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Palunyapirinypa-ya watjaltjakutarra nintitjurra-lanyatju tjiinyan yayirninytjulu katiku tjarrpatjunku kalkurnu wantinytjatjanulu. Tjiinyamarntun ngaapirinypa watjarnu wantingu, ");
INSERT INTO ntj_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ngayulu-tjanamparnanku Puurrpa Mama Kuurrnga nyinarra. Tjiinya-rna waarrpungkula mirrparnarrirranytjamunu. Palunyalu-rna kalkuntjatjanulu ngayuku katja yurntalpirti tirtu mukulyanytjulu kanyilpayi. Palunyalu-rna kalyparringkupayi tungun-tunguntu-ya palyamunu palyaranyangka. Nyangka-tjinguru-yan kulira tjiinya-rna palyamunu nyakula wantipayi. Wiya, mama ngunytjulu-ya palyamunu palyaranyangka kutjupayara-rna pika yutinma palunyaku katja yurntalpirtiku puru tjamu kaparlipirtiku puru mama ngunytju kurlunykutarrartu.’ ");
INSERT INTO ntj_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Yuwa Mama, nyuntulu-lanyatjun mukulyanytjulu tirtu kanyiranytja. Palunyanguru kalyparriwa-tjanampa tungun-tungunarrinyangka-ya. Tjiinya-ya Yiitjipulanguru pitjalayintjalu tirtu tungun-tungunarrirranytja nyangka-tjanampan kalyparringkulanytja, palunyapirinypartu.” ");
INSERT INTO ntj_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Nyangka Mama Kuurrtu watjarnu, “Yuwa, kalyparriku-tjanamparna, nyuntulu-rnin tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Yuwa, ngayulu-rna manta lipiwanalu yayirninytjulu kutjupa-kutjupa palyalpayi. Palunyanguru-rnanta tjukarurrulu ngaanya watjara. ");
INSERT INTO ntj_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Yarnangu ngaanya-ya ngurra nyarra kalkuntjala tjarrpakitjamunu. Tjiinya-ya nyangu ngayuku tili purlkanya yartakarrinyangka. Palunyalu-rniya nyangu yayirninytjulu-rna kutjupa-kutjupa palyaranyangka Yiitjipula puru mayu-mayuwanalutarrartu. Parturtu-rniya tirtu puurlpa kulira tungun-tungunarringkulanytja. ");
INSERT INTO ntj_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Palunyanguru-ya ngurra nyarra kalkuntjala tjarrpakitjamunu. Tjiinya-rniya mularrkulintjamaaltu wantingu. Palunyalu-ya ngurra palunyangka tjarrpakitjamunu. ");
INSERT INTO ntj_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nyangka ngayuku waarka palyalpayi, Kayilapanya wuyurrpa kutjupa. Tjiinya-rni tirtu mularrkuliranytja. Nyangka-rnalu katiku ngurra palunyangka tjarrpatjunku. Nyangka palunyaku tjamu kaparlipirti-ya ngurra palunyangka nyinama, ");
INSERT INTO ntj_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","nyarra Yamalikiku tjamupirti puru Kayinanku tjamupirti-ya karru-karruwana kuwarrinya nyinarra, palunyangka. Yuwa, tjirntungka-yan pinkurraalku mayu-mayuwana marlaku yanku yurlparirra yuru nyarra purlkanyakutu.” ");
INSERT INTO ntj_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nyangka Mama Kuurrtu Mawutjanya-pulanya Yarannga watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Tirtu-munta-rniya mirrparn-mirrparntu payinma yarnangu ngaa palyamunulu? Kulirnu-rna mirrparn-mirrparntu-rniya watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","29","Nyangka-tjananya ngaapirinypa watjala, ‘Tjukarurrulu-rna ngaanya watjara. Tjiinya-yan watjaranytja mayu-mayuwana mirrirrikitjalu. Yuwa, mayu-mayuwana-yan palya mirrirringama. Nyangka-tjanampanku tarrka pirninya mayu-mayuwana watingarrirrayinma. Tjiinya-rniyan mirrparn-mirrparntu watjaranytja. Palunyanguru-yan ngurra nyarra kalkuntjala tjarrpakitjamunu. Wati nyarra kurli-tjanampa 20 ngarala, puru yirna-yirna, tjilpitarrartu tjarrpakitjamunu. Yangupalakutju-ya nyinarrayilku tjarrpaku. ");
INSERT INTO ntj_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Tjiinya-tjananyarnanta watjarnu wantingu katirra ngurra palunyangka nyinatjunkukitjalu. Nyangka-yan tjarrparra nyinakitjamunu. Ngarna Kayilapanya-pula Tjatjuwanya tjarrpaku nyinama. ");
INSERT INTO ntj_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Tjiinya-yan ngurlulu watjaranytja nyuntuku-tjanampanku tjilku-ya tjulyara katitjaku. Wiya, palunyanya-tjananyarna katiku tjarrpatjunku ngurra nyarra nyuntulu-yan wantingu palunyangka. ");
INSERT INTO ntj_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Nyangka-yan nyuntulu mayu-mayuwanartu mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Nyangka-ya nyuntuku-tjanampanku katja yurntalpirti mayu-mayuwana parrapitjala nyinarrayilku kurli 40-tjanu tjarrpaku ngurra palunyangka nyinama. Parrapitjala nyinarrayilku-ya mayu-mayuwana nyuntulu-yan palyamunu palyarnu palunyatjanungka. Nyangkalta-yan pirninyartu mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tjiinya-yan yanu ngurra kalkuntjanya parranyakulayirnu tjirntu 40-tjanu marlaku pitjangu. Nyangka yara palunyapirinypartu-ya mayu-mayuwana parrapitjala nyinarrayilku kurli 40-tjanu tjarrpaku nyinama. Tjiinya-yan nyuntunya tungun-tungunarringu. Palunyanguru-yan nintirriku tjiinya ngayulu-tjanamparnanku mirrparnpa nyinarra. ");
INSERT INTO ntj_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mularrpa-tjananyarnanta watjara. Mirrirriku-yan ngaangkartu, mayu-mayu wiyarriku. Tjiinyamarntu-rniyan tungun-tungunarringu lurrtjurringu payiranytja. Ngayulu-tjananyarnanta Mama Kuurrtu ngaanya watjara.’” ");
INSERT INTO ntj_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Tjiinya Mawutjalu-tjananya wati 12-pa witurnu. Nyangka-ya yanu ngurra nyarra kalkuntjanya parranyakulayirnu pitjanytja. Nyangka wati 10-tu-ya pitjangu tjukurrpa palyamunu watjaranytja ngurra palunyatjarra. Nyangka-tjananyaya yarnangu pirnilu mularrkuliralpi Mama Kuurrnga mirrparn-mirrparntu watjaranytja. Nyangkalta Mama Kuurrtu-tjanampa wati 10-ku pika purlkanya nintirnu. Nyangka-ya pikatjarrarringkulalpi mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nyangkalta-pula kutjarra wankarringu, Tjatjuwanya Kayilapanya. ");
INSERT INTO ntj_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Nyangka Mawutjalu-tjananya yarnangu pirninya watjarnu tjiinya Mama Kuurrtu watjantjanya. Nyangka-ya kulirnu tjurlpilyarrirralpi purlkanya yulangu. ");
INSERT INTO ntj_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Palunyalu-ya mungayurnturalpi pakarnu ngulakutju tamarlmaranytja ngurra nyarra purlitjarrakutu yankukitjalu. Watjarnu-ya, “Wiya, tjinguru-latju tungunpungkutjamaaltu wantima. Kuwarrinya-la pakara yarra ngurra nyarra Mama Kuurrtu kalkuntjalakutu.” ");
INSERT INTO ntj_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nyangka Mawutjalu-tjananya watjarnu, “Wiya, tirtu-yan Mama Kuurrku wangkangka tungunpungkula. Wartalpitjanu-tjananyanta watjarnu parranyinarra-yan mirrirritjaku. Ngaanya-yan yanku tjitjaku. ");
INSERT INTO ntj_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Yanku-kurlu-yan. Wanti. Mama Kuurrnga-tjananyanta lurrtju yankukitjamunu. Nyangka-tjananyantaya yanyan-yanyanpa nyinapayi pirnilu wakalku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Tjiinya-yan yarlaku kulira Yamalikiku tjamupirti puru Kayinanku tjamupirti wakara wiyalkitjalu. Wiya, nyuntunya-tjananyantaya wakalku wiyalku. Tjiinya Mama Kuurrtu-tjananyanta miranykanyira kanyilkitjamunu. Tjiinyamarntu-yan pinkurraaralpi Mama Kuurrnga wantingu.” ");
INSERT INTO ntj_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nyangka Mawutjanya yankutjamaalpa nyinarranytja Mama Kuurrku puuka miirl-miirlta. Nyangka-ya yungarra pakara yanu ngurra purlitjarrakutu. ");
INSERT INTO ntj_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Nyangka-ya Yamalikiku tjamupirtilu puru Kayinanku tjamupirtilu tjiinya ngurra palunyangka nyinarranytjalu-tjananya nyakulalpi pika-pika pitjangu. Palunyalu-tjananya wakara ngurlura wanarayirnu yiwarla yini Yuumala wantingu. ");
INSERT INTO ntj_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Nyangka-ya wati kutjarra-kutjarra Mawutjala tungunpungu. Tjiinya wati ngaanya-ya: Kuuranya tjiinya Liipayiku wartangkatja puru Tayitjannga, Payiramanya, Yuunngatarrartu tjiinya Rupanku wartangkatja. Palunyalu-ya liita walykumunu 250 yarltirra mapitjangu ");
INSERT INTO ntj_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","kutjungkarringu Mawutjala-pulanya Yaranta. Palunyalu-ya watjarnu, “Wiya, nyuntunya-pulan karnany-karnanypa munkarra-munkarrarringkula. Nyaaku-pulan puurrarringkula-lampatjun? Pirninyartu-lan Mama Kuurrku katjapirti. Nyangka Mama Kuurrnga-lanya pirningkartu nyinarra. Nyaaku-lanyatjun puurrarringkula kanyira?” ");
INSERT INTO ntj_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Nyangka Mawutjalu kuliralpi mantangka pupakatingu Mama Kuurrnga tjapirayirnu ");
INSERT INTO ntj_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","wiyarringkulalpi pakarnu Kuuranya-tjananya watjarnu, “Wiya, tjirntungka Mama Kuurrtu-lanya nintitjunku. Nyangka wati nyarra Mama Kuurrtu ngurrkarntankutjanya palya Mama Kuurrtakutu ngamuntirriku. Nyangka kutjupatjarranya-tjananyanta Mama Kuurrtu marrkulku wantiku. ");
INSERT INTO ntj_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Yuwa Kuura, nyuntulu-yan ngaapirinymanku. Tjiinya-yankun kutju-kutjulu tjapulpa mantjiralpi murrnyultu waru yurralku. Palunyalu-yankun parnti walykumunu pulparru murrnyultungka katu pata-patalku. Palunyalu-yankun makatiku tiinti miirl-miirlta ngamu tjunku. Nyangkalta-lan nyaku, ‘Ngananya Mama Kuurrtu ngurrkarntanku?’ Wiya, nyuntunya-yan karnany-karnanypa munkarra-munkarrarringu.” ");
INSERT INTO ntj_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Nyangka Mawutjalu Kuuranya tirtu watjara wanarayintja, “Liipayiku tjamupirti, kulila-ya. ");
INSERT INTO ntj_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Tjiinya Mama Kuurrnga tjiinya-lan Yitjurayilku tjamupirtilu pupakatirra marninypungkupayi, palunyalu-tjananyanta ngurrkarntanu palunyaku tiinti miirl-miirlta-yan waarkarritjaku, puru-yan yarnangu pirninya kanyiratjaku Mama Kuurrnga-ya pupakatirra marninypungkulanyangka. Nyangka nyaaku-yan waarka kutjupaku warnirripungkula? ");
INSERT INTO ntj_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Mama Kuurrtu-tjanampanku waarka walykumunu nintirnu. Nyangka nyuntulun kulira puurrpa-tjanampa nyinakitjalu tiinti miirl-miirlta waarka palyalpayi pirnikutarrartu. ");
INSERT INTO ntj_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Tjinguru-yan kulira Yarantalkanyu-yan tungun-tungunarrirranytja. Wiya, Mama Kuurrta-yan tungun-tungunarrirranytja.” ");
INSERT INTO ntj_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Nyangka Mawutjalu wati kutju witurnu Tayitjannga-pulanya Payiramanya yarltirra katitjaku. Nyangka tiintikutu mapitjangu purtu-pulanya yarltingu wantingu. Tjiinya-pula watjarnu, “Wiya, pitjakitjamunu-litju! ");
INSERT INTO ntj_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Tjiinya-latju Yiitjipula nyinarranytjalu mirrka purlkanya pakaltjingalpayi manta walykumunungka. Nyangka nyuntulu-lanyatjun yarltirra katingu mayu-mayu mirrirntankukitjalu. Palunyalu-lanyatjun puurrarringkula kanyira. ");
INSERT INTO ntj_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Nyuntulu-lanyatjun kalkurnu ngurra walykumunu mirrka purlkanyatjarra nintilkitjalu. Wanytjanyanyka ngurra palunyanya mirrka purlkanyatjarranya? Nyaaku-lanyatjun mayulkitjalu tirtu kulira? Wiya, pitjakitjamunu-litju.” ");
INSERT INTO ntj_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Nyangka Mawutjalu lirri warurringkulalpi Mama Kuurrnga watjarnu, “Wiya, wati ngaalunku-ya nyuntuku kutjupa-kutjupa nintiranyangka paanypuwa. Tjiinya ngayulu palyamunu-tjananyarna palyaranytjamunu. Palunyalu-tjanamparna kutjupa-kutjupa mulyatarrirranytjamunu.” ");
INSERT INTO ntj_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Nyangka Mawutjalu Kuuranya watjarnu, “Yuwa, tjirntungka-yan wati 250-nyatarrartu mapitjaku Mama Kuurrku tiinti miirl-miirlkutu. Nyangka Yaranngatarrartu mapitjaku. ");
INSERT INTO ntj_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Nyangka-yankun yungarra-yungarralu tjapulpa mantjiralpi murrnyultu waru yurralku palunyalu parnti walykumunu pulparru murrnyultungka katu pata-pataralpi Mama Kuurrku nintilku.” ");
INSERT INTO ntj_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Nyangkalta-ya mularrpartu ngarringu tjirnturringkulalpi pirnilurtu-yanku tjapulpa mantjiralpi murrnyultu waru yurrarnu palunyalu parnti walykumunu pulparru murrnyultungka katu pata-patara pitjangu tiinti miirl-miirlta tjaangka yilkaku ngaralanytja. Nyangka Mawutjanya-pula Yaranngatarrartu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Nyangka Kuuralu palunyaku wanalpayi pirninya katingu kutjungkanu kanyirnu Mawutjanya-pulanya Yarannga yurakanyiltjaku. Nyangkalta-ya ngarala yurakanyiranytja tiinti tjaangka-pula ngaralanyangka. Nyangkalta Mama Kuurrku tili purlkanya yartakarringu pirningka mirangka. ");
INSERT INTO ntj_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Nyangka Mama Kuurrtu Mawutjanya-pulanya Yarannga watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Wati-langarriwa-pula. Nyangka-tjananyarnayi kuwarrinyartu mirrirntarra.” ");
INSERT INTO ntj_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Parturtu-pula mantangka pupakatirralpi watjarnu, “Wiya Mama, nyuntulu-lanyatjun yarnangu pirninyartu wankara kanyira. Palunyalu-munta-lampatjun yarnangu pirnikurtu mirrparnarriku yarnangu kutju palyamunurringkunyangka?” ");
INSERT INTO ntj_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Nyangka Mama Kuurrtu Mawutjanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Yarnangu pirninya-tjananya watjala wati marnkurrku-ya tiinti wantirra watipitjatjaku, Kuuraku, Tayitjanku puru Payiramaku tiinti wantirra watipitjatjaku.” ");
INSERT INTO ntj_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Nyangka Mawutjanya mapitjangu Tayitjanta-pulanya Payiramalakutu. Nyangka-ya liita kutjupatjarralu wanarnu. ");
INSERT INTO ntj_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Nyangka-tjananya Mawutjalu yarnangu pirninya watjarnu, “Wati ngaa palyamunuku-tjanampa tiinti-ya wantirra watipitja. Kutjupa-kutjupa-kurlu-yan pampulku. Wanti-ya nyuntunyatarrartu-tjananyanta Mama Kuurrtu mirrirntanku wiyaltjakutarra. Tjiinyamarntu wati ngaanya-ya palyamunu nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Nyangka-ya mularrpartu tiinti wantirralpi warnakatingu tiwa ngaralanytja. Nyangka Tayitjannga-pula Payiramanya pakaralpi tiinti tjaangka ngaralanytja, puru palunyaku-pulampa kurri tjilkutarrartu. ");
INSERT INTO ntj_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Nyangka Mawutjalu-tjananya yarnangu pirninya watjarnu, “Wiya, kunpu-kunpu-rna palyaranytjamunu. Ngarna Mama Kuurrtu-rni watjannyangka-rna palyalpayi. Nyangka ngaanguru-yan nintilu kulilku. ");
INSERT INTO ntj_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Tjinguru wati ngaanya-ya nyinarrayilku tjilpirringkulalpi mirrirriku. Palunyangka-yan nintilu kulilku tjiinya-rni Mama Kuurrtu ngurrkarntankutjamunurtu. ");
INSERT INTO ntj_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Wiya-tjinguru Mama Kuurrtu kutjupa-kutjupa palyalku kata-yan pawurnarraltjaku. Tjiinya-tjinguru parnalu wartunarraralpi-tjananya tjarrpatjunku kurri tjilku yulytja pirninyatarrartu. Nyangka-ya wanka tjarrpaku mirri pirniku ngurrakutu. Palunyangka-yan nintilu kulilku tjiinya wati ngaalu-ya Mama Kuurrnga tungun-tunguntu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Nyangka Mawutjaku wangkangkartu manta wati marnkurrku tjinawana yurrirra wartunarrara kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Nyangka-ya wati marnkurrngartu, kurri, tjilkutarrartu, puru Kuuraku wanalpayi pirninya puru yulytjatarrartu karralukatingu. ");
INSERT INTO ntj_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Tjiinya-ya yulytja pirnitjarra wanka karralukatingu wiyarringu mirri pirniku ngurrakutu. Nyangka manta marlaku tjuturringkulalpi-tjananya yangatjunu. Nyangkalta-ya wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Nyangka-ya Yitjurayilku tjamupirti ngamu ngaralanytja. Palunyalu-ya mirra-tjananya kulira ngurlu kukurraarnu. Palunyalu-ya watjarnu, “Wiya, ngayunyatarrartu-lanyanta yarlarringkulalpi kuurltjunku.” ");
INSERT INTO ntj_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Nyangkalta Mama Kuurrtu waru tjaarrtjingarnu. Nyangka kampangu-tjananya wiyarnu wati 250-nya, nyarra parnti walykumunu-ya tiinti miirl-miirlkutu katingu kanyiranytjanya. ");
INSERT INTO ntj_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Nyangka tjirntungka yarnangu pirnilu-ya pitjangu Mawutjanya-pulanya Yarannga mirrparn-mirrparntu watjarnu, “Wiya, nyuntulu-pulan mirrirntanu Mama Kuurrku katjapirti kutjupatjarra.” ");
INSERT INTO ntj_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Palunyanguru-ya parralarringu nyangu yutuwari tiinti miirl-miirlta ngaralanyangka. Nyangka Mama Kuurrku tili purlkanya yartakarringu. ");
INSERT INTO ntj_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Nyangka Mawutjanya-pula Yarannga mapitjangu tiinti miirl-miirlta kalkurni ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Nyangka Mama Kuurrtu Mawutjanya-pulanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Wati-langarriwa-pula. Nyangka-tjananyarnayi yarnangu pala pirninyartu wiyala.” Nyangka-pula mantangka pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Nyangka Mawutjalu Yarannga watjarnu, “Tjapulpanku mantjiralpi murrnyultu waru yurrala. Palunyalu parnti walykumunu pulparru murrnyultungka katu pata-patala. Palunyalu waarrpungkula kati nyarra yarnangu pirninya-ya ngarala, palunyalakutu. Palunyalu nintila Mama Kuurrku. Nyangka-tjanampayi kalyparriwa. Tjiinya Mama Kuurrnga kuwarri mirrparnpa purlkanya nyinarra. Nyangka-ya wiyangkalpi pikatjarrarringkula mirrirringkula-wanarayintja.” ");
INSERT INTO ntj_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Nyangka Yarantu mularrpartu tjapulpanku mantjira kukurraarnu yarnangu pirningka ngururrkutjarra ngarangu. Palunyalu nyangu wiyangkalpi-ya mirrirringkulanytja. Nyangka parnti walykumunu pulparru murrnyultungka pata-patarnu. Palunyalu Mama Kuurrku nintiralpi tjapirnu-tjanampa kalyparritjaku. ");
INSERT INTO ntj_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Nyangka palunyangururtu kutjupa mirrirringkutjamunurtu. Tjiinya Yarannga ngururrkutjarra ngaralanytja. Nyangka kutjupanguru-ya mirri pirninya ngarrirranytja. Nyangka kutjupanguru-ya wanka pirninya ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Tjiinya-ya yarnangu minga-minga mirrirringu wiyarringu, 14,700-pa. Nyangka-ya kutjupatjarra mirrirringu Kuuralawana. ");
INSERT INTO ntj_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Nyangkalta Yarannga marlaku yanu Mawutjala lurrtjurringu ngaralanytja tiinti miirl-miirlta. ");
INSERT INTO ntj_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Nyangka Mama Kuurrtu Mawutjanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Yuwa, Yitjurayilku tjamupirti-tjananya watjala tjiinya-yanku wana 12-pa mantjira katitjaku. Tjiinya Yitjurayiltu katja 12-pa kanyirnu. Nyangka katja 12-ku wartangkatja-ya liita kutju-kutjulu-yanku wana kati nintila. Nyangka wana kutju-kutjungka watiku yini walkatjurra. ");
INSERT INTO ntj_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Palunyalun Yaranku yini walkatjunku Liipayiku tjamupirtiku wanangka. ");
INSERT INTO ntj_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Palunyalun wana pirninya makatiku ngayuku tiinti miirl-miirlkutu. Palunyalu puuka miirl-miirlta yitingkartu tjunku, tjiinya-rnanta lurrtjurringkupayi, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Nyangka wati nyarra ngayulu-rna ngurrkarntanu, palunyaku wana yirnuntjitjarrarriku. Nyangka-yayi pirnilurtu nyawa nintirriwa tjiinya-rna wati palunyanya ngurrkarntanu. Palunyalu-ya nyuntunya-pulanyanta mirrparn-mirrparnmaaltu kulinma.” ");
INSERT INTO ntj_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nyangka mularrpartu Mawutjalu-tjananya Yitjurayilku tjamupirti palunyapirinypa watjarnu. Nyangka-yanku liita 11-tu puru Yarantutarrartu wana katingu Mawutjaku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Nyangka katingu tiinti miirl-miirlta tjarrparralpi Mama Kuurrku puuka miirl-miirlta yitingkartu tjunu. ");
INSERT INTO ntj_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Palunyalu ngarringu tjirnturringkulalpi Mawutjanya tiintingka tjarrparralpi nyangu Yaranku wana ngaa wiyangkalpi yirnuntjitjarrarringkulalpi puru mirrka yurnmitjarrarringu. ");
INSERT INTO ntj_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Nyangka Mawutjalu wana pirninyartu katingu yarnangu pirningka nintitjunu. Nyangka-ya liita pirnilu nyakulalpi wana-yanku mantjira katingu. ");
INSERT INTO ntj_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Yaranku wana marlakulu tjarrpatjurra wanti puuka miirl-miirlta yitingka. Nyangka-ya tungun-tungunarrinyangka-tjananya wana yirnuntjitjarranya nintitjunama. Tjiinya-ya puru tungunpungkulalpi mirrparn-mirrparnpa wangkanyangka-tjananyarna mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Nyangka Mawutjalu mularrpartu katingu tjarrpatjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Nyangka-ya Yitjurayilku tjamupirtilu Mawutjanya watjarnu, “Wiya, wartalpitjanu-latju kurrakuturringu. ");
INSERT INTO ntj_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tjinguru kutjupa Mama Kuurrku tiinti miirl-miirlta ngamurringkulalpi mirrirriku. Nyangka-tjinguru-latju puru pirninyartu mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Nyangka-ya Yitjurayilku tjamupirti rawa parranyinarrayirnu parrapitjangu ngurra tjunu mayu-mayu ngurra yini Tjiintawana. Kirnara nampa 1-ta-ya ngurra tjunu yiwarla yini Kayititjala ngamu. Nyangka Mawutjaku tjurtu Miriyamanya palunyangkartu wiyarringu. Nyangka-ya tjurnutjunu. ");
INSERT INTO ntj_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Nyangka kapi wiyarrinyangka-ya yarnangu pirninya pitjangu kutjungkarringu Mawutjala-pulanya Yaranta. ");
INSERT INTO ntj_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Palunyalu-ya mirrparn-mirrparntu watjarnu, “Wiya, tjinguru-latju mirrirringama Mama Kuurrku tiinti miirl-miirlta, nyarra kutjupatjarranya-ya mirrirringu, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Wiya, tirtu-lanyatjun katirrayirni mayu-mayu mirrirntankukitjalu. Purun yanamulpa pirninyatarrartu mirrirntanku. ");
INSERT INTO ntj_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nyaaku-lanyatjun Yiitjipulanguru katingu ngurra ngaa palyamunukutu, mirrka wiyakutu? Kapitarrartu wiyartu. Nyangka-latju purtu kulira tjikilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Nyangka Mawutjalu-pula Yarantu yarnangu pirninya wantirra mapitjangu tiinti miirl-miirlta tjaangka yilkaku ngarangu. Palunyalu-pula mantangka pupakatingu. Nyangka Mama Kuurrku tili purlkanya yartakarringu-pulanya. ");
INSERT INTO ntj_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Nyangka Mama Kuurrtu Mawutjanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Wana mantjira kati, nyarra puuka miirl-miirlta yitingka ngarrirranytjanya. Palunyalu yarnangu pirninya kutjungkarra yapu nyarrangka. Palunyalu pirningka mirangka yapu watjala kapi walatjunkutjaku. Nyangka kapi purlkanya pukulyarralku. Tjiinyan palunyapirinytju kapi nintilku tjikiltjaku-ya, puru yanamulpa pirnilutarrartu-ya tjikiltjaku.” ");
INSERT INTO ntj_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Nyangka Mawutjalu mularrpartu mapitjangu wana palunyanya mantjira katingu Mama Kuurrtu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Palunyalu-pula yarnangu pirninya yapu palunyangka kutjungkanu. Nyangka Mawutjalu-tjananya watjarnu, “Tungun-tungunpa pirni, kulila-ya. Ngayulu-munta-tjanamparnanku yapu ngaangka kapi yartakanku?” ");
INSERT INTO ntj_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Palunyatjanululta Mawutjalu wana palunyanya wakuralpi yapu kutjarrara pungu. Nyangka kapi purlkanya pukulyarraralpi kukurrmaranytja. Nyangka-ya yarnangu pirnilu puru yanamulpa pirnilutarrartu tjikiranytja. ");
INSERT INTO ntj_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nyangka Mama Kuurrtu-pulanya watjarnu, “Wiya, nyuntulu-pulan yarnangu ngaanya-tjananya katiku tjarrpatjunkukitjamunu ngurra nyarra kalkuntjala. Kutjupalu-tjananya katiku tjarrpatjunku. Tjiinya-pulan mapitjaku ngatalpartu wiyarringku. Tjiinyamarntu-rnipulan wangkakutju kulintjamunu. Tjinguru-pulan yapu watjanmakutju. Nyangka-tjinguru-rniya pirnilu nyakulalpi kulinma ngayulu-rna yayirninytjulu kapi yutinnyangka. Ngaanya-pularnin kulirnu wantirralpi yapu pungu.” ");
INSERT INTO ntj_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Nyangkalta-ya palunyanguru ngurra palunyanya tjapirnu yini Miripanya. Tjiinya yini palunyanya ngaapirinypa, Mirrparn-mirrparntu Payilpayinya. Tjiinyamarntu-ya mirrparn-mirrparntu Mama Kuurrnga payiranytja. Nyangka-tjananya yutirnu tjiinyanku miirl-miirlpa nyinarranytjalu. ");
INSERT INTO ntj_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","21","Nyangka Mawutjalu-tjananya wati tjukurrtjarra witurnu. Nyangka-ya yanu puurrpa Yiitamanyamartatji tjapirnu, “Palya-munta-latju nyuntuku ngurrawana kartakutjarra yanku ngurra kutjupakutu?” Nyangka mirrparnarrirralpi wiyarnmanu. Nyangka palunyanguru-ya Yitjurayilku tjamupirtilu wantirralpi kuliranytja yarla kutjupawana yankukitjalu. ");
INSERT INTO ntj_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Nyangka-ya Yitjurayilku tjamupirtilu ngurra nyarra Kayititjanya wantirra yanu. Pitjalayirnu-ya parrapitjangu yapu yini Yuuralakutu, ");
INSERT INTO ntj_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","tjiinya ngurra nyarra Yiitamala kantilytja ngaralanyangka. Nyangka Mama Kuurrtu Mawutjanya-pulanya Yarannga watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Yuwa, Yarannga ngurra nyarra kalkuntjala tjarrpakitjamunu, ngaangkartu wiyarriku. Tjiinyamarntu-pularnin ngayuku wangka kulirnu tungun-tungunarringu ngurra nyarra Miripala. ");
INSERT INTO ntj_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Yuwa, nyuntulu-pulan puru Yaranku katja Yaliyatjanya yapu ngaangka tatilku. ");
INSERT INTO ntj_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Nyangka Mawutjalu Yaranku warntu walykumunu, nyarra tjarrpatjunkula tiinti miirl-miirlta waarka palyalpayinya yarraralpi palunyaku katja Yaliyatjala tjarrpatjunku. Tjiinya Yarannga palunyangkartu wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Nyangka-ya mularrpartu yapu palunyangka tatirnu yarnangu pirnilu-ya nyakulanyangka. ");
INSERT INTO ntj_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Palunyatjanulu Mawutjalu Yaranku warntu walykumununya yarraralpi tjarrpatjunu palunyaku katjangka. Nyangka Yarannga yapu katurtu wiyarringu. Nyangka Mawutjanya-pula Yaliyatjanya tjarungarangu. ");
INSERT INTO ntj_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Nyangka-ya yarnangu pirnilu nyakulalpi kulirnu Yarannga wiyarrinyangka. Palunyalu-ya yularrayirnu tjirntu 30-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Nyangka-ya Yitjurayilku tjamupirtilu yapu yini Yuuranya wantirra yurlparirrawana yanu yiwarra nyarra yuru purlkanyakutu makatirrayirni, palunyangka. Tjiinya-ya kuliranytja ngurra nyarra Yiitamala kantilywana yankukitjalu. Palunyalu-ya pitjalayintjalu mirrparn-mirrparnarrirralpi ");
INSERT INTO ntj_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Mama Kuurrnga puru Mawutjanyatarrartu payirnu watjarnu, “Nyaaku-lanyatjun Yiitjipulanguru katingu mayu-mayuwana mirrirntankukitjalu? Tjiinya mirrka wiya puru kapi wiya. Nyangka-latju kaarr-kaarrarringu mirrka ngaa palyamunuku.” ");
INSERT INTO ntj_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Nyangka Mama Kuurrtu-tjananya kulirnu wangkarlkurrinyangka palunyalu lirru pirni witurnu yarnangu pirninya parrapitjala patjaltjaku. Nyangka-ya mularrpartu parrapitjala-tjananya patjara mirrirntaranytja. ");
INSERT INTO ntj_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Nyangka-ya yarnangu kutjupatjarralu pitjangu Mawutjanya watjarnu, “Munta, palyamunulu-latju nyuntunya puru Mama Kuurrnga mirrparn-mirrparntu watjaranytja. Mama Kuurrnga tjapila lirru pirninya tjirtira wiyaltjaku.” Nyangka mularrpartu Mawutjalu-tjanampa tjapirnu. ");
INSERT INTO ntj_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Yayinpa mantjila palyala lirrupirinymaralpi wartangka yurtitjurra. Nyangka-yayi nyakulalpi wankarringama.” ");
INSERT INTO ntj_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Nyangka Mawutjalu mularrpartu yayinpa mantjiralpi palyarnu lirrupirinymanu wartangka yurtitjunu. Nyangka-ya pikatjarralu lirru yayinpa nyakula wankarringkulanytja. ");
INSERT INTO ntj_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","24","Nyangka-ya Yitjurayilku tjamupirti mayu-mayu wantingu pakarnu pitjalayintja. Nyangka Mawutjalu-tjananya tjukurrtjarra witurnu Yayimuku tjamupirtiku-tjanampa puurrkutu, puurrpa yini Tjayantakutu. Nyangka-ya mularrpartu yanu tjapirnu, “Yuwa puurr, palya-munta-latju nyuntuku ngurrawana kartakutjarra yanku ngurra kutjupakutu?” Parturtu puurrpa palunyanya mirrparnarringu. Palunyalu warrmarla pirnitjarra pakara pitjangu-tjananya pika wakalkitja. Nyangka Yitjurayilku tjamupirtilu-tjananyaya Yayimuku tjamupirti wakarayirnu wiyarnu. Palunyalu-ya palunyaku ngurra yungarrarringkulalpi kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nyangka-ya Yitjurayilku tjamupirti pakara pitjangu ngurra tjunu kapi Tjuutanta kakarrara, ngurra yini Mawupalawana. Tjiinya ngurra yukiri purlkanyatjarra ngaralanytja. Nyangka kapi Tjuutannga ngururrkutjarrawana kukurrmaranytja. Nyangka yiwarla Tjarikanya kapingka yitipi ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Nyangka puurrpa Mawupanyamartatji yini Payilikilu tjakulpa kulirnu tjiinya-yanyu Yitjurayilku tjamupirti minga-mingalu pitjangu-tjananya Yayimuku tjamupirti wakarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Nyangka puurrpa Payilikilu puru palunyaku yarnangu pirnilutarrartu-ya kuliralpi ngurlu-ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Palunyalu-ya puurrpa Mitiyanngamartatji watjarnu, “Wiya, yarnangu ngaa minga-mingalu-ya mirrka-lampa ngalkulayilku wiyalku. Tjiinyakurlu puluka marnti purlkanyalu yukiri ngalkulayila wiyala, palunyapirinytju.” Nyangka puurrpa Payilikilu-tjananya ");
INSERT INTO ntj_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","6","wati pirni witurnu ngurra tiwakutu wati yini Payilamanya yarltirra katitjaku. Tjiinya ngurra palunyanya kapi Purayitila ngamu ngaralanytja. Tjiinya-tjananya watjarnu, “Yarra-ya Payilamanya ngaapirinypa watjala, ‘Yuwa, nintilu-rna kulira tjiinya nyuntulun kutjupaku-ra wangka walykumunu watjalku wantinyangka palunyaku walykumunu yutirriku. Puru nyuntulun kutjupanya yinitjunkunyangka palunyanya kurrakuturriku. Nyangka-muntan kulilku? Tjiinya yarnangu minga-minga-ya Yiitjipulanguru pitjangu ngayuku-lampatjuya ngurra lipiwananyartu ngurrararrikitja. Minga-minga-ya nyinarra ngayula-lanyatjuya munkarra. Nyangka-muntan pitjaku-tjananyan yinitjunku? Nyangka-latjuyi wakara-wanarayila wiyala.’” ");
INSERT INTO ntj_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Nyangka-ya mularrpartu tjukurrtjarra yanu. Tjimarri purlkanya-ya mantjira makatingu Payilamaku yungkukitjalu. Pitjalayirnu-ya Payilamanya nyakulalpi puurrpa Payilikiku tjukurrpa watjarnu. ");
INSERT INTO ntj_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Nyangka Payilamalu-tjananya kuliralpi watjarnu, “Yuwa, ngarri-ya tjirnturriwa. Nyangka-rna mungangka Mama Kuurrnga tjapilku. Palunyalu-tjananyarnanta tjirntungka tjakultjunku Mama Kuurrtu-rni watjalku, palunyanya.” Nyangka-ya mularrpartu ngarringu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nyangka mungangka Mama Kuurrtu Payilamanya tjapirnu, “Ngananya-ya wati ngaanya nyuntuku ngurrangka ngarrirra?” ");
INSERT INTO ntj_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Nyangka Payilamalu watjarnu, “Wiya, puurrpa Mawupanyamartatji tjiinya yini Payilikilu-tjananya witurnu pitjala-rniya yarltirra katitjaku. ");
INSERT INTO ntj_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Tjiinya-yanyu yarnangu pirni Yiitjipulanguru pitjangu katuwana nyinarra manta lipiwanartu. Nyangka puurrpa Payilikinya mukurringkula ngayulu-rnanyu yankula-tjananyarna yinitjunkutjaku. Nyangkalta-tjananyayayi wakara-wanarayila wiyala.” ");
INSERT INTO ntj_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nyangka Mama Kuurrtu Payilamanya watjarnu, “Wiya, yanku-kurlun. Wanti nyinama. Yinitjunku-kurlu-tjananyan. Wanti. Tjiinyamarntu-tjananyarna ngayulu Yitjurayilku tjamupirti walykumunura kanyira.” ");
INSERT INTO ntj_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Nyangka Payilamanya ngarringu tjirnturringkulalpi pakara mapitjangu-tjananya puurrpa Payilikiku wati pirninya watjarnu, “Wiya, palya-yan ngurraku yanku. Tjiinya Mama Kuurrtu-rni marrkurnu yankutjamaaltu-tjananyarnanta wantitjaku.” ");
INSERT INTO ntj_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nyangka-ya mularrpartu marlaku yanu puurrpa Payilikinya tjakultjunu Payilamalu wantingu ma-nyinanyangka. ");
INSERT INTO ntj_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Nyangka puurrpa Payilikilu-tjananya liita kutjupa pirni witurnu, tjiinya wati purlkanyakutju. ");
INSERT INTO ntj_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nyangka-ya mularrpartu yanu Payilamanya watjarnu, “Kulilku-muntan? Puurrpa Payilikilu ngaapirinypa watjarnu, ‘Wiya, kutjupa-kutjupa kuliranytjamaalpa pitja ngayulakutu. ");
INSERT INTO ntj_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nyangka-rnanku tjimarri purlkanya nintilku. Nyangkan kutjupa-kutjupaku ngatjiranyangka-rnanku waarrpungku nintilku. Pitja-tjananya yinitjurra.’” ");
INSERT INTO ntj_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nyangka Payilamalu watjarnu, “Wiya, kutjupa-kutjupa-rna watjalkitjamunu. Wangka nyarra Mama Kuurrtu-rni watjalku, palunyanya-rna watjalku. Tjinguru-rni puurrpa Payilikilu kalkulku palunyaku kawurlpa tjilpa pirninyartu nintilkitjalu. Wiya, palya-rna wantiku. ");
INSERT INTO ntj_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Tjarlpa ngarri-ya tjirntungka kulila. Tjiinya-rni tjinguru Mama Kuurrtu tjukurrpa kutjupa watjalku. Tjiinya-ya kutjupatjarranya ngaangkalpi ngarringu tjirnturringu, palunyapirinypa.” Nyangka-ya mularrpartu ngarringu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Nyangka mungangka Mama Kuurrtu Payilamanya watjarnu, “Yuwa, palyan yanku wati ngaangka-tjananyan. Palunyalu kutjupa-kutjupa watjantjamaaltu nyarra ngayulu-rnanta watjalku, palunyanyakutju watjala.” ");
INSERT INTO ntj_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Nyangka mularrpartu ngarringu tjirnturringkula tungkingka tatira yanu-tjananya liita Mawupanyamartatji pirningka. ");
INSERT INTO ntj_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nyangka Payilamanya puru palunyaku waarka palyalpayi kutjarranya tungkitjarra mapitjalayintja. Nyangka Mama Kuurrku yayintjulpa yiwarrangka yangangaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Nyangka Payilamaku tungkilu nyangu yayintjulpa palunyanya kunmarnu purlkanyatjarra ngaralanyangka. Nyangka yiwarra wantirra yurirlwana yanu. Nyangka Payilamalu tungki pungkula marlakulu katingu yiwarrakutu. ");
INSERT INTO ntj_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nyangka yayintjulpa pakara yanu yiwarra yutjungka puru ngaralanytja. Tjiinya kaatanpa kutjarra yiwarrangka ngantjarrpa-ngantjarrpa ngaralanytja. Nyangka yaarrpa purlitjarralu yiwarra yutjurnu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Nyangka tungkilu yayintjulpa nyakulalpi kiti-kitirringu. Nyangka yaarrpa purlitjarralu Payilamaku tjina nguwanpa pilkirrtjinu. Nyangka Payilamalu tungki pururtu pungu. ");
INSERT INTO ntj_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Nyangka yayintjulpa puru pakara yanu yiwarra yutjungkartu yangangaralanytja. Tjiinya yurirlpa wiya ngaralanytja kiti-kitirringkula yankutjaku. ");
INSERT INTO ntj_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Nyangka tungkilu yayintjulpa puru nyakulalpi ngarrikatingu ngarrirranytja. Nyangka Payilamalu mirrparnarrirralpi wartangka puru pungu. ");
INSERT INTO ntj_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Nyangka Mama Kuurrtu tungki wangkatjarrarnu. Nyangka watjarnu, “Nyaaku-rnin marnkurrara pungu?” ");
INSERT INTO ntj_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Nyangka Payilamalu watjarnu, “Wiya, nyuntulu-rnin tjalkirr-tjalkirrmara. Kunmarnupalka-rna kanyiranytjalu-rnanta wakala mirrirntarra.” ");
INSERT INTO ntj_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Nyangka tungkilu watjarnu, “Wiya, tjiinya-rnin rawa tatira yankulayintja. Nyangka-rnanta walykunyakutju ngaapirinymanu.” ");
INSERT INTO ntj_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Nyangka Mama Kuurrtu Payilamanya ngalya yarlarnu. Nyangka nyangu yayintjulpa kunmarnutjarra ngaralanyangka. Nyangkalta Payilamanya pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Nyangka yayintjultu watjarnu, “Nyaakunkun tungki marnkurrara pungu? Ngayulu-rna yiwarra yangatjunu ngaralanytja. Tjingurun ngurrangka nyinama. ");
INSERT INTO ntj_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Tjinguru-rnanta mirrirntaralpi tungki wanka kanyinma. Ngarna tungkilu-rni nyakulalpi kiti-kitirringkulanytja.” ");
INSERT INTO ntj_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Nyangka Payilamalu watjarnu, “Munta, piwarraarnu-rna. Tjiinya-rna kulintjamunu nyuntulun-rnin marrkulkitja yangatjunu ngaralanytja. Tjinguru-rnin mularrpa marrkulkitjalu kuliranyangka-rna wantirra ngurraku marlaku yanku.” ");
INSERT INTO ntj_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Nyangka yayintjultu watjarnu, “Wiya, palya-tjananyan yanku. Palunyalu kutjupa-kutjupa watjantjamaaltu, nyarra ngayulu-rnanta watjalku, palunyanyakutju watjanma.” Nyangka mularrpartu Payilamalu-tjananya puurrpa Payilikiku wati pirninya wanarnu lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Nyangka puurrpa Payilikilu kulirnu Payilamanya pitjalayinnyangka ngata-ngata mapitjangu lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Palunyalu watjarnu, “Nyaatjanungkan kurranyulpi pitjanytjamunu? Tjingurun kulira ngayulu-rna tjimarri kurlunypa kanyira nintilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Nyangka Payilamalu watjarnu, “Palunya-rna pitjangu nyuntulu-rnin watjarnu wantinyangka. Nyangka kulinma ngaanya. Tjiinya-rna yungarralu watjalkitjamunu. Ngarna wangka nyarra Mama Kuurrtu-rni watjalku, palunyanyakutju-rna watjalku.” ");
INSERT INTO ntj_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","40","Nyangka-pula lurrtjurringkula yanu. Nyangka puurrpa Payilikilu puluka tjiipu pirninya pungkulalpi paarnu. Nyangka-ya pukurltu ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nyangka tjirntungka puurrpa Payilikinya-pula Payilamanya yapungka tatirnu. Palunyalu-pula walunyakulanytja Yitjurayilku tjamupirti kutjupatjarrakutju nyinarranyangka. Tjiinyamarntu-ya yarla lipiwana watinyinarrayintja. ");
INSERT INTO ntj_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","6","Nyangka-pula yapu tjunkula parrawanarnu katurnu Mama Kuurrku kuka nintilkitjalu. Palunyalu-pula puluka 7-pa puru tjiipu 7-patarrartu pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Nyangka Payilamanya kutju yapu katu tatirnu Mama Kuurrta wangkarranytja. Nyangka-lu tjukurrpa watjarnu. Nyangka marlaku pitjangu puurrpa Payilikila lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","10","Palunyatjanu wangka walykumunu Yitjurayilku tjamupirtiku-tjanampa ngaratjaku watjarayirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Nyangka puurrpa Payilikilu watjarnu, “Wiya, nyaakunykan palunyapirinypa watjarnu? Yarltingu-rnanta tjiinya-tjananyan yinitjura wantitjaku ngayunya-lanyatju papurrmunulu pitjala pungkula wiyaltjakutarra. Parturtu-tjanampan wangka walykumunu watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Nyangka Payilamalu watjarnu, “Wiya, kamu-rna kutjupa-kutjupa watjalku. Ngarna wangka nyarra Mama Kuurrtu-rni watjarnu, palunyanyakutju-rna watjalku.” ");
INSERT INTO ntj_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Nyangka puurrpa Payilikilu Payilamanya watjarnu, “Yarra-li yapu kutjupangka tatila. Nyangka palunyanguru-tjananyan walunyakulalpi yinitjunku.” ");
INSERT INTO ntj_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Nyangka-pula mularrpartu yanu yapu kutjupangka tatiralpi Yitjurayilku tjamupirti walunyakulanytja. Nyangka puurrpa Payilikilu yapu tjunkula parrawanarnu katurnu. Palunyalu puluka 7-pa puru tjiipu 7-pa pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","17","Nyangka Payilamanya kutju mapitjangu Mama Kuurrku tjukurrpa kuliralpi marlaku pitjangu puurrpa Payilikila lurrtjurringu. Nyangka-lu tjapirnu, “Nyaa watjarnu Mama Kuurrtu?” ");
INSERT INTO ntj_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Nyangka Payilamalu Mama Kuurrku tjukurrpa watjarnu, “Yuwa Payiliki, kulila ngayulu-rnanta watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tjiinya Mama Kuurrnga yarnangupirinymaalpa. Tjiinya mayulkitjamunu. Ngarna yarnangulu mayulpayi. Nyangka Mama Kuurrnga yarnangupirinymaalpa. Tjiinya wuyurrpa kutjuparrikitjamunu. Ngarna yarnangu wuyurrpa kutjuparripayi. Nyangka Mama Kuurrtu watjalku wantirralpi tjurrkurltu palyalku. Tjiinya Mama Kuurrtu watjannyangka palunyapirinypartu ngarama. ");
INSERT INTO ntj_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Tjiinya Mama Kuurrtu-rni watjarnu wangka walykumunu-tjanamparna watjara wantitjaku. Nyangka-rna kamu kutjupanku.” ");
INSERT INTO ntj_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","24","Nyangka Payilamalu-tjanampa wangka walykumunu watjara-wanarayirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Nyangka puurrpa Payilikilu watjarnu, “Wiya! Wiya! Palunyapirinypa watjaranytjamaaltu wanti.” ");
INSERT INTO ntj_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Nyangka Payilamalu watjarnu, “Wiyangkalpi-rnanta watjarnu. Kamu-rna kutjupa-kutjupa watjalku. Ngarna wangka nyarra Mama Kuurrtu-rni watjalku, palunyanyakutju-rna watjalku.” ");
INSERT INTO ntj_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Nyangka puurrpa Payilikilu watjarnu, “Yarra-li yapu kutjupanguru tatiralpi nyawa. Tjinguru Mama Kuurrtu wuyurrpa kutjuparringkulalpi watjalku yinitjunkutjaku-tjananyan.” ");
INSERT INTO ntj_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","30","Nyangka-pula mularrpartu tjarungarala yanu yapu kutjupangka tatirnu. Nyangka puurrpa Payilikilu yapu tjunkula parrawanarnu katurnu. Palunyalu puluka 7-pa puru tjiipu 7-pa pungkulalpi tilirnu tjunu nintirnu Mama Kuurrku. ");
INSERT INTO ntj_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","2","Nyangka Payilamalu nintilu kulirnu Mama Kuurrtu-tjananya Yitjurayilku tjamupirti walykumunura kanyilkitjalu kuliranytja. Nyangka Payilamalu-tjananya ngarala walunyakulanyangka Mama Kuurrku Kuurtilu-lu wuyurrmanu wangkatjaku. ");
INSERT INTO ntj_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","9","Nyangka-tjanampa pururtu wangka walykumunu watjara-wanarayirnu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nyangka puurrpa Payilikilu kuliralpi lirri warurringu. Palunyalu watjarnu, “Wiya, yarltingu-rnanta tjiinya nyuntulu-tjananyan pitjala yinitjunkutjaku ngayunya-lanyatjuya papurrmunulu pitjala pungkula wiyaltjakutarra. Nyangka nyuntulu-tjanampan marnkurrara wangka walykumunukutju watjarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Waarrpungkulalta wantirra ngurrakutu yarra. Tjiinya-rnanta kalkurnu kutjupa-kutjupa walykumunu nintilkitjalu. Nyangka Mama Kuurrtunku kurrarnu mantjiltjakutarran.” ");
INSERT INTO ntj_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Nyangka Payilamalu watjarnu, “Tjiinya-rniya yarltinyangka-tjananyarna palunyanyartu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Tjinguru-rnin nyuntuku kawurlpa tjilpa purlkanya pirninyartu nintilku. Nyangka-rnanku palya wantiku. Tjiinya-rna kamu kutjupa-kutjupa watjalku. Ngarna wangka nyarra Mama Kuurrtu-rni watjalku, palunyanyakutju-rna watjalku.” ");
INSERT INTO ntj_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nyangka Payilamalu puurrpa Payilikinya watjarnu, “Yuwa, marlaku-rna yankukitja ngayuku yungarrapirtikutu. Nyangka-rnanta ngaanya watjalku yartakanku tjiinya ngula-tjananyanta Yitjurayilku tjamupirtilu pungkula-wanarayilku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","24","Nyangka Payilamalu watjara-wanarnu wantingu Mama Kuurrtu-lu nintitjunkutjanya. ");
INSERT INTO ntj_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Palunyatjanulta pakara marlaku yanu ngurrakutu. Nyangka puurrpa Payilikinya palunyaku ngurraku yanu. ");
INSERT INTO ntj_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Nyangka-ya Yitjurayilku tjamupirti ngurra yini Tjitimala nyinarranytja. Nyangka-ya wati kutjupatjarra yanu minyma Mawupanyamartatji pirningka ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Nyangka-tjananya minyma palunyalu-ya yarltingu pitjala-ya kuka ngalkula palunyalu palunyaku-tjanampa tjukurrtatja pupakatirra marninypungkutjaku. Nyangka-ya mularrpartu lurrtjurringu kuka ngalkulanytja. Palunyalu-ya tjukurrtatja palunyanya pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Nyangka Mama Kuurrnga-tjanampa mirrparnarringu tjiinya-ya tjukurrtatja palunyanya pupakatirra marninypungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Nyangka Mama Kuurrtu Mawutjanya watjarnu, “Yuwa, mapitjakun tatilku yapu ngaa Parimalawana. Palunyangurun ma-nyaku ngurra nyarra ngayulu-tjanamparna Yitjurayilku tjamupirtiku nintilku, palunyanya. ");
INSERT INTO ntj_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Tiwangurukutjun nyakulalpi wiyarriku, nyuntuku kurta Yarannga wiyarringu, palunyapirinypartu. ");
INSERT INTO ntj_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Tjiinyamarntu-pularnin tungun-tungunarringu mayu-mayu ngurra Tjiintawana kapi nyarra Miripala. Tjiinya yarnangu pirnilu-rniya kapitjirratjalu mirrparn-mirrparntu payiranytja. Nyangka-tjinguru-pularnin wangkakutju kulira yapu watjanmakutju. Nyangka-tjinguru-rniya pirnilu kulinma ngayulu-rna yayirninytjulu kapi yutinnyangka.” ");
INSERT INTO ntj_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Nyangka Mawutjalu Mama Kuurrta watjarnu, ");
INSERT INTO ntj_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Yuwa Mama, nyuntulun puurrpa purlkanya nyinarra. Nyuntulu-lanyatjun yarnangu pirninyartu wankara kanyira. Liita kutjupa-muntan ngurrkarntanku walara-tjananya makatirrayiltjaku ngayulu-rna wiyarrinyangka? ");
INSERT INTO ntj_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Tjinguru-ya yarnangu pirnilu purtu parrakawarurringkula kulinma. Tjiinyakurlu tjiipu pirnilu-ya purtu kulila kutjupalu-tjananya miranykanyintjamunungka, palunyapirinypa. Palunyangkatarra wati kutjupa ngurrkarntarra pikakutarrartu-tjananya walara katirrayiltjaku.” ");
INSERT INTO ntj_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","19","Nyangka Mama Kuurrtu watjarnu, “Yuwa, Naanku katja, Tjatjuwanya wati walykumunu, kuliltjarralu palyalpayi. Yarltirra-lu kati Yaliyatjalakutu, nyarra tiinti miirl-miirlta waarka palyalpayi, palunyalakutu. Palunyalu yarnangu pirninya yarlti kutjungkarra. Palunyalu Tjatjuwanya kata pampuralpi watjala, ‘Nyuntulun liita nyinama yarnangu pirniku-tjanampan.’ ");
INSERT INTO ntj_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Watjala-tjananya tjiinya-ya Tjatjuwaku wangka wangarnarralu kulira palyaratjaku, tjiinyanta-ya nyuntuku wangka wangarnarralu kulira palyaranytja, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Nyangka Tjatjuwalu nintirrikitjalu Yaliyatjanya tjapinma. Nyangka Yaliyatjalu ngayunya-rni tjapiralpi Tjatjuwala watjanma ngayulu-rna nintitjunkunyangka.” ");
INSERT INTO ntj_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","23","Nyangka Mawutjalu mularrpartu Tjatjuwanya yarltirra katingu Yaliyatjalakutu. Palunyalu yarnangu pirningka mirangka kata pampuralpi tjunu Yitjurayilku tjamupirtiku-tjanampa liita nyinarratjaku. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","3","Nyangka Mawutjanya yapu katu tatirnu ngaralanytja tjiinya Mama Kuurrtu-lu watjannyangka. Nyangka Mama Kuurrtu-lu nintitjunu ngurra lipi purlkanya kayili, yapurra yuru purlkanyakutu puru yurlparirra ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Palunyatjanulu Mama Kuurrtu-lu watjarnu, “Ngurra ngaanyan nyakula, palunyanya-rna kutjulpirtulpi Yayipuramanya Yayitjikinya puru Tjayikapanya kalkurnu palunyaku tjamu kaparlipirtiku-tjanamparna nintilkitjalu. Yuwa, kutjuwarra nyawa. Tjiinya-rnanta katingu nyakutjakun. Nyangkan tjarrparra nyinakitjamunu. Ngaangurun nyakulalpi wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Nyangka Mama Kuurrku waarka palyalpayi Mawutjanya mirrirringu ngurra nyarra Mawupala Mama Kuurrtu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Nyangka Mama Kuurrtu-lu tjurnutjunu karru-karrungka ngurra nyarra Mawupala warli yini Patjupiyula yitipi. Nyangka-ya yarnangu pirninya tjuulpa palunyaku ngurrpa. Kuwarritarrartu-ya ngurrpa tirtu nyinarra, ngayulu-rna tjukurrpa ngaanya walkatjuranyangka. ");
INSERT INTO ntj_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Tjiinya Mawutjanya kurli 120-nguru mirrirringu. Tjiinya patata-patatamaalpa kuurti wanka nyinarranytja. Puru kuru walykumunu tirtu nyinarranytja pawulypa wiyartu. ");
INSERT INTO ntj_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Nyangka-ya Yitjurayilku tjamupirti ngurra nyarra Mawupala nyinarra Mawutjaku yularrayirnu tjirntu 30-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Nyangka Tjatjuwanya wati nintipuka nyinarranytja. Tjiinyamarntu-lu Mawutjalu mirrirrikitjalu kata pampurnu liita nyinatjaku. Nyangka Mama Kuurrtu-lu ngalya yarlarnu tjiinya kuliltjarralu-tjananya yarnangu pirninya kanyiratjaku. Nyangka-ya Yitjurayilku tjamupirtilu Tjatjuwaku wangka wangarnarralu kulira palyaranytja. Palunyalu-ya Mama Kuurrku wangka nyarra Mawutjalu watjarnu wantitjanya wangarnarralu kulira palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Yuwa, Mama Kuurrnga Mawutjala lurrtjurringkula wangkapayi. Nyangka kutjupa Mawutjanyapirinypa nyinanytjamunurtu wiyartu. Ngarna wati palunyangka Mama Kuurrnga yamatjingkapirinypa lurrtjurringkula wangkapayi. ");
INSERT INTO ntj_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Nyangka kutjupalu palyaranytjamunu nyarra Mawutjalu Yiitjipula palyaranytja palunyapirinypa. Tjiinya Mama Kuurrtu-lu witunnyangka yanu yayirninytjulu kutjupa-kutjupa palyaranytja puurrpa Piirulu nyakulanyangka. Puru palunyaku puurrpa pirnilu-ya puru yarnangu Yiitjipunyamartatji pirnilutarrartu-ya nyakulanytja. ");
INSERT INTO ntj_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Yuwa, Mawutjalu yayirninytjulu kutjupa-kutjupa palyaranytja. Nyangka-ya Yitjurayilku tjamupirtilu nyakulalpi ngurlurringkupayi. Nyangka kutjupalu palunyapirinypa palyaranytjamunurtu. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Nyangka Mawutjanya mirrirringu. Tjiinya Mawutjalu Mama Kuurrku waarka palyara-wanarayintja. Nyangka wati yini Tjatjuwalu-lu yirringkankupayi. Nyangka Mawutjanya mirrirrinyangka Mama Kuurrtu Tjatjuwala watjarnu, ");
INSERT INTO ntj_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Yuwa, nyuntulu-tjananyan Yitjurayilku tjamupirti walara kutikatiku tjiinyamarntu Mawutjanya wiyarringkunyangka. Nyangka-yan pakara kutipitjaku kapi Tjuutannga kantura wayirntanku ngurra nyarra kalkurnu wantitjala tjarrpaku. ");
INSERT INTO ntj_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Ngurra kutjupa-kutjupakutu-yan yankulanyangka ngurra palunyanya-tjanamparnanku nintilku. ");
INSERT INTO ntj_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Manta lipi purlkanya-tjanamparnanku nintilku. Nyangka-yan ngurra palunyangka tjarrarringkula ma-nyinarra-wananma.” ");
INSERT INTO ntj_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Nyangka Mama Kuurrtu-lu tirtu watjara wanarayintja, “Yuwa Tjatjuwa, kulila-rni. Ngamulurtu-rnanta miranykanyira katirrayinma. Tjiinya-rna Mawutjanya miranykanyira katirrayintja, palunyapirinypartu. Nyangka nyuntulu-tjananyan yanyan-yanyanpa nyinapayi pirninya pungkula-wanarayilku wiyalku. Tjiinyamarntu-rnanta ngayulu wantikitjamunu tirtu miranykanyinma. ");
INSERT INTO ntj_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Ngurlurringkutjamaalpa rapa nyinama. Nyuntulu-tjananyan yarnangu pirninya walara katirrayilku ma-tjarrpatjunku ngurra nyarra kalkurnu wantitjala. ");
INSERT INTO ntj_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ngurlurringkutjamaalpa rapa nyinama. Palunyalu wangka pirninyartu nyarra Mawutjalunta nintipungu wantitjanya watarrkurrinytjamaaltu wangarnarralu kulira palyanma. ");
INSERT INTO ntj_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Yuwa, tirtu nyakula watjanma ngayuku wangka ruulangka ngaralanytjanya. Palunyalu karlarla mungangka tirtu kulinma. Palunyalu wangarnarralu kulira palyanma. Nyangka-rnanta walykumunura kanyinma. Nyangkanta kutjupalu walykulkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Yuwa, ngurlurringkutjamaalpa rapa nyinama. Tjiinya ngayunya-rnanta Mama Kuurrnga miranykurru tirtu pitjalayinma ngurra kutjupa-kutjupakutun yankulanyangka.” ");
INSERT INTO ntj_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","11","Nyangka Tjatjuwalu watjarnu liita pirnilu-ya ngurrawanalu yarnangu pirninya-tjananya ngaapirinypa watjaltjaku, “Ngurra kutjarratjanu-lan pakara mapitjaku kapi Tjuutanta yitipirringkulalpi ngurra tjunku ngurra nyarra Mama Kuurrtu kalkurnu wantitjala. Mirrka pirni-yanku yurraralpi tjurra yalatjarringkula kutipitjakitjalu.” Nyangka-ya liita pirnilu mularrpartu yarnangu pirninya parrawatjarnu. Nyangka-ya kuliralpi mirrka, warntutarrartu karrpirnu tjunu. ");
INSERT INTO ntj_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Kapi Tjuutanta kakarrara-ya nyinarranytja. Nyangka Tjatjuwalu wati kutjarra miratjuralpi watjarnu, “Yuwa, yarra-pula ngurra Tjarikalawana wiyapirinytju parranyawa, ‘Nyaapirinypa ngurra ngarala? Yarnangu-ya nyaapirinypa nyinarra?’” Nyangka-pula mularrpartu yanu Tjarikalakutu ngamuntirringu. Palunyalu-pula yiwarlakuturringkulalpi nyangu minyma kutju ngaralanytja. Nyangka-pula tjapirnu ngurra ngarrikitjalu. Nyangka-pulanya palunyaku yiwarlangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Nyangka wati kutjulu-pulanya nyangu. Palunyalu yanu puurrpa purlkanyangka tjakultjunu, “Wati kutjarra-pula Yitjurayilku wartangkatja kuwarrinya tjarrpangu wiyapirinytju-pula parranyakula yankula tjakultjunkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","7","Nyangka kuliralpi warrmarla-tjananya witurnu minyma nyarra Rayipaku ngurrangka wati kutjarranya tjulyara katitjaku. Nyangka tjiinya Rayipalu kurranyululpi wati kutjarranya watjarnu, “Tatila-pula yiwarla katu ngarrikati. Nyangka-pulanyarnanta tjutula warta nyarlpi pikitjarrangka.” Nyangka-pula mularrpartu tatiralpi ngarrirranytja. Nyangka-ya warrmarlalu pitjangu watjarnu, “Wati kutjarranya yarltirra kati, nyarra kuwarrinya-pula pitjangu ngurra nyakukitja.” Nyangka Rayipalu watjarnu, “Wiya, karrangka-pula yanu kayirrpa kuwarripa yarla ngaralanyangka. Ngurra kutjupakutu-tjinguru-pula yanu. Ngurrpa-rna.” Palunyalu-tjananya watjarnu, “Waarrpuwa-ya ngurlura wanala ngamuntirrirralpi nyawa.” Nyangka-ya mularrpartu kayirrwanalu ngurlura wanarnu. Nyangka-ya kayirrpa miranykanyilpayilu yangatjunu. Nyangka-ya warrmarla pirnilu kunpu-kunpu ngurlura wanarayirnu kapi Tjuutanta wantirra marlaku pitjangu. ");
INSERT INTO ntj_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Nyangka Rayipanya palunyaku yiwarlangka tjarrparralpi tatirnu nyangu wati palunyanya-pula kunkunarrinytjamaalpa tirtu wanka nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","Palunyalu watjarnu, “Nintilu-rna kulira tjiinya Mama Kuurrtu-tjanampanku ngurra ngaanya nintilku. Nyangka-latju pirninyartu ngurlu-ngurlu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Tjiinya-latju tjukurrpa kulirnu Mama Kuurrtu kapi Tjitirn-tjitirnnga tikirlmanu tjiinya nyuntulu-yan Yiitjipunya wantirra pitjanyangka. Palunyatjanu-latju tjukurrpa kulirnu tjiinya-yan kuwarri-kuwarri puurrpa kutjarra pungu mirrirntankunyangka. ");
INSERT INTO ntj_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Tjiinya-latju kulirnu ngurlurringu. Tjiinya-latju nintilu kulira Mama Kuurrnga tjiinya-yan pupakatirra marninypungkula, palunyalu manta yilkari puurrarringkula kanyira. Nyangka-lampatju wuyurrpa wiyarringu. Tjiinya-latju pikakitjamunu. ");
INSERT INTO ntj_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Nyangka-pularni ngaanya watjala wanti Mama Kuurrta mirangka tjiinya-pulan ngarltunytjulu-lanyatju kanyilkitjalu, ngayuku mama, ngunytju, kurta, marlanypirtitarrartu. Tjiinya ngayulu-pulanyarnanta miranykanyira kanyira, palunyapirinypa. Watjala-pularni yutilurtu wanti wankarura kanyilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Ngayuku yungarrapirti-lanyatju miranykanyira kanyinma. Miranykanyinma-lanyatju mirrirritjakutarrartu-latju.” ");
INSERT INTO ntj_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Nyangka wati kutjarralu-pula watjarnu, “Yuwa, miranykanyilku-litjunta. Tjiinya-tjingurun kutjupangka watjantjamaaltu wantiku. Nyangka-litjunta miranykanyira kanyinma Mama Kuurrtu-lampatju ngurra ngaanya nintinnyangka.” ");
INSERT INTO ntj_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Tjiinya yaarrpa purlkanya walutjarralu yiwarla pirninyartu parrayangatjura kanyiranytja. Yaarrpa palunyanya wirrmira mularrpa ngaralanytja. Nyangka Rayipaku ngurra katu ngaralanytja yaarrpa palunyawanartu. Nyangka Rayipalu purturru wirrmira wintanguru warningu. Ka wati kutjarralu-pula witurrpungkulalpi tjarungarangu. ");
INSERT INTO ntj_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Nyangka Rayipalu watjarnu, “Waarrpungkula-pula yapukutu kukurraala kumpiralpi nyinama ngurriltjakutarrartu. Tjinguru-ya purtu ngurrirayilku ngurra kutjarratjanu marlaku pitjaku. Nyangkalta-pulan pakara yanku ngurrakutu.” ");
INSERT INTO ntj_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Nyangka-pula watjarnu, “Ngaanya-litju tjurrkurltu watjara. Miranykanyilku-litjunta watjarnu wantitjatjanulu. ");
INSERT INTO ntj_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Nyangkan nyuntulu ngaapirinypa palyalku. Nyinarrayilkun nyaku warrmarlarringkula-latju pitjanyangka. Palunyalun purturru tjitirn-tjitirnpa ngaanya wintangka karrpilku wantiku. Palunyalunku yungarrapirti-tjananya yarltirra kati nyuntuku yiwarlangka tjarrpatjurra kanyinma. Nyangka-latju pitjaku nyaku purturru wintanguru waraly-waralyngaralanyangka. Palunyalu-latjunta wankarunku. ");
INSERT INTO ntj_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Yuwa, Mama Kuurrtu-linyatju palya kunkanymanku yarnangu kutjupanya nyuntuku yungarra mirrirrinyangka. Nyangka-tjinguru kutjupa nyuntuku ngurra wantirra pakara yanku parrangarama yilkaku. Nyangka-latju kamu miranykanyilku. ");
INSERT INTO ntj_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Nyangka-tjinguru-linyatjun ngayunyatjarra watjalku. Nyangka-litju miranykanyintjamaaltu wantiku. Nyangka-yan mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Nyangka minyma palunyalu palyarnmaralpi witurnu. Nyangka-pula yanu. Nyangka minyma palunyalu purturru tjitirn-tjitirnpa wintangka karrpirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Nyangka-pula yanu yapungka kumpirnu nyinarranytja. Nyangka warrmarla pirnilu-pulampaya yiwarrawana parrangurriranytja. Palunyalu-ya purtu ngurrirayirnu ngurra kutjarratjanulu wantirra marlaku pitjangu yiwarlakutu. ");
INSERT INTO ntj_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Nyangka-pula wati kutjarranya yapunguru tjarungarala mapitjalayirnu kapingka tjarrparra ma-katurringu. Palunyalu marlaku ngurrakutu parrapitjangu. Palunyatjanulu-pula tjukurrpa tjakultjunu Tjatjuwala. ");
INSERT INTO ntj_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Palunyalu-pula watjarnu, “Mularrpa-lampa Mama Kuurrtu manta lipinyartu nintirnu. Nyangka yarnangu pirninyartu-lampaya ngurlu-ngurlu nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Nyangka munga-mungangka-ya Tjatjuwalu puru Yitjurayilku tjamupirtilu pakaralpi-yanku warntu karrpi-karrpirnu. Palunyatjanu-ya ngurra wantirra mapitjalayirnu kapi kantilykutu. Palunyalu-ya ngurra tjunkulalpi kuwarripa nyinarranytja yitipirrikitja kutjupa kantilykutu. ");
INSERT INTO ntj_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Nyangka ngurra kutjarratjanulu-ya liita pirnilu pakaralpi ");
INSERT INTO ntj_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","yarnangu pirninya-tjananya parrawatjarnu, “Tjiinya-yan nyaku wati nyarra tiinti miirl-miirlta waarkarringkupayilu-ya puuka miirl-miirlpa makatirrayinnyangka pakaralpi-yan wanalku. ");
INSERT INTO ntj_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Nyangka-tjananyantaya nintitjunku mapitjalayiltjaku-yan. Tjiinya-yan ngurra nyarraku ngurrpa, kuwarrinyakutju pitjangu. Nyangka-kurlu-yan puuka miirl-miirlku ngamurringku. Tiwawanalu-ya nyakula wanarayinma.” ");
INSERT INTO ntj_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Nyangka Tjatjuwalu-tjananya yarnangu pirninya watjarnu, “Tjurrkurlarri-yanku Mama Kuurrta. Palunyalu tamarlpa nyina. Tjiinya-lan nyaku Mama Kuurrtu yayirninytjulu kutjupa-kutjupa palyaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Nyangka Tjatjuwalu-tjananya watjarnu wati nyarra tiinti miirl-miirlta waarkarringkupayilu-ya puuka miirl-miirlpa tjarlira kurranyulu katirrayiltjaku. Nyangka-ya mularrpartu tjarlira mapakarnu. ");
INSERT INTO ntj_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Nyangka Mama Kuurrtu-lu Tjatjuwala watjarnu, “Kuwarrinya-tjananyarna yarnangu pirninya nintitjunku tjiinya nyuntunyan liita mula-mula nyinarranyangka. Nyangkanta-ya nyangama tjiinya-rnanta yirringkaranyangka, tjiinya-rna Mawutjanya yirringkara kanyilpayi, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Yuwa, watjala-tjananya wati nyarra puuka miirl-miirltjarra mapitjalayirni. Nyangka-yayi kapingka ma-tjarrparralpi ngara.” ");
INSERT INTO ntj_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Nyangka Tjatjuwalu-tjananya yarnangu pirninya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","“Yuwa, yarnangu kutjupa-kutjupa pirni-ya kapingka munkarra nyinarra. Nyangka Mama Kuurrtu-tjananyanta yirringkanama. Nyangkalta-yan pungku wiyalku. Tjiinya-tjanampa tjukurrtatjalu-tjananya wankara kanyilkitjamunu. Nyangka Mama Kuurrtu-lanya wankara kanyinma. Nyangka-yan nyaku mula-mularriku. ");
INSERT INTO ntj_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","13","Yuwa, Mama Kuurrnga puurrpa purlkanya manta lipikurtu. Nyangka-ya palunyaku puuka miirl-miirlpa nyakuma. Nyangka-ya wati nyarra puuka miirl-miirlpa katirrayintjanya ma-tjarrpaku kapingka. Nyangka Mama Kuurrtu kapi kukurrmaranytjanya marrkulku. Nyangka mawurntalarringkulalpi ma-ngarrima yurrimaalpa yapu warrarapirinypa.” ");
INSERT INTO ntj_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Nyangka-ya mularrpartu yarnangu pirnilu ngurra palunyanya wantirra paka-pakarnu. Nyangka-ya wati nyarra puuka miirl-miirlpa katirrayintjanya kurranyurringu ");
INSERT INTO ntj_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","kapikutu. Nyangka kapi warnanpa katu mularrpa kukurrmaranytja karrungka. Nyangka wati-ya nyarra kurranyu mapitjalayintjanya kapingka tjarrparralpi ngarangu. ");
INSERT INTO ntj_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","17","Nyangka kapi ngatalarringu tiwa ma-ngarrirranytja. Kapi nyarra Yuru Kumpuwalykukutu kukurrmaranytjanya ngatalarringu ma-ngarrirranytja. Nyangka kapi ngarringu wantinyangka manta tikirlarringu. Nyangka-ya yarnangu pirninya waarrpungkula yitipirringkula yanu manta tikirlwana. Nyangka-ya wati nyarra puuka miirl-miirltjarranya karrungka ngururrkutjarra ngaralayirnu, nyangka-ya yarnangu pirninyartu yitipirrinyangka-ya pakara yitipirringu. ");
INSERT INTO ntj_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Nyangka-ya puurrpa pirni ngurra yitipi-yitipingkatjalu kulirnu tjiinya Mama Kuurrtu warnanpa purlkanya marrkurnu kanyiranytja, nyangka-ya Yitjurayilku tjamupirtilu karruwana yitipirringkula pitjangu. Kuliralpi-ya ngurluny-ngurlunyarringu. Palunyatjanu-ya pikakitjalu kulirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Nyangka Yitjurayilku tjamupirti-ya ngurra yini Kilkalta nyinarranytja tjiinya Tjarikala kakarrara. Nyinarrayirnu-ya tjirntu 14-tjanulu mungarringkulalpi tjiipu warlangu pungkula ngalkulanytja. Tjiinya-ya Yara Wayirntankutjanya yarrkalpungu nyarra kutjulpirtu-ya tjiipu pungu ngalangu Yiitjipunya wantikitjalu, palunyapirinymanu-ya. ");
INSERT INTO ntj_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ngarringu tjirnturringkulalpi-ya mirrka yurninypa ngurrangkatja yurrara ngalkulanytja. Yurninypa kutjupatjarra-ya paara ngalkulanytja. Palunyatjanulu-ya yurninypa kutjupatjarranya rungkara nyumatjunkula paara ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Nyangka tjirntu palunyangkartu mirrka mana tjiinya yilkaringuru punka-punkalpayi wiyarringu. Nyangka palunyangururtu-ya mirrka ngurrangkatja ngalkulanytja ngurra kalkurnu wantijtala. ");
INSERT INTO ntj_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Nyangka Tjatjuwanya yiwarla nyarra Tjarikala ngamu parrangaralanytja. Palunyalu tjulurraarnu nyangu wati kutjulu kunmarnu purlkanya yilarnu kanyiranyangka. Nyangka Tjatjuwanya mapitjangu-lu ngamurringkulalpi tjapirnu, “Ngayunya-munta-lanyatjun yirringkankukitja ngarala? Wiya-tjingurun kutjupatjarranya-tjananyan yirringkankukitja ngarala.” ");
INSERT INTO ntj_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Nyangka wati palunyalu watjarnu, “Wiya, ngayulu-rna warrmarla yilkaringkatjaku puurrpa.” Nyangka Tjatjuwanya mantangka pupakatirralpi watjarnu, “Yuwa, watjala-rni. Nyaapirinypa-rnanku palyalku?” ");
INSERT INTO ntj_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Nyangka wati palunyalu watjarnu, “Tjinapuunpanku yarrala. Tjiinyan manta miirl-miirlta ngarala.” Nyangka mularrpartu tjinapuunpa yarrarnu tjunu. ");
INSERT INTO ntj_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Nyangka tawunpa Tjarikanya yaarrpa purlkanyangka kaninytjarra puparranytja, yapu walu purlkanyangka palyarnu wantinyangka. Nyangka-ya yarnangu yiwarlangkatja pirninya ngurluny-ngurlunypa nyinarranytja. Palunyalu-ya kayirrpa lakapungkula wantipayi. Nyangka kutjupa tjarrparranytjamunu. Puru-ya pakara yilkaku ngaralanytjamunu. ");
INSERT INTO ntj_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Nyangka Mama Kuurrtu Tjatjuwala watjarnu, “Yuwa, ngayulu-tjananyarnanta yirringkanku. Nyangka-yan yarnangu pirninya ngurra ngaangkatja pungkula-wanarayilku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","4","Tjiinya-yan ngaapirinypa palyalku. Nyuntulun warrmarla pirnitjarra mapitjaku yiwarlakutu. Nyangka wati nyarra tiinti miirl-miirlta palyalpayi 7-pa-ya turampirrtjarra-turampirrtjarra kurranyurringkula mapitjaku. Nyangka-ya wati puuka miirl-miirltjarra marlawana mapitjaku. Nyangka-yan yaarrpa yilkakuwana wanaparri-wanaparri parrapitjalayilku marlakurringkula ngurrakutu pitjama. Palunyalu-yan ngarriku tjirnturringkulalpi puru palunyapirinypa parrapitjaku. Palunyapirinypa-yan tjirntu kutjupa tjirntu parrapitjaku. Palunyalu-yan ngurra 6-tjanu pakalku mapitjaku parrapitjaku-parrapitjaku 7-arriku. Nyangka-ya wati nyarra turampirrtjarralu tirtu mirratjingarayinma. ");
INSERT INTO ntj_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Nyangkalta-yan pirninyartu lingkirrpa mirraku. Nyangkalta yaarrpa walutjarra palunyanya purlparraalku. Nyangkalta-yan warrmarla pirninya ma-tjarrpaku.” ");
INSERT INTO ntj_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Nyangka mularrpartu Tjatjuwalu-tjananya wati nyarra tiinti miirl-miirlta waarkarringkupayinya yarltirralpi watjarnu, “Puuka miirl-miirlnga-yan mantjira katiku. Nyangka-ya wati 7-pa turampirrtjarranya kurranyu mapitjaku.” ");
INSERT INTO ntj_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","10","Nyangka Tjatjuwalu-tjananya warrmarla pirninya watjarnu, “Mapitjaku-yan yaarrpa yilkakuwana puriny-purinypa parrapitjaku. Palunyatjanu-yan ngurraku marlaku pitjaku. Tjiinya kutjupatjarra-ya kurranyu yanku. Nyangka-ya puuka miirl-miirltjarra marlawana yanku. Nyangka kutjupatjarralu-yan purinytju marlawanalu wanarayinma. Kanmarrpa-ya parrapitjala pitja. Nyangka ngula ngayulu-rna watjannyangka-yan mirraku.” Nyangka-ya mularrpartu palunyapirinypa parrapitjalayintja. Tjiinya-ya warrmarla marnkurr-marnkurrpa kurranyurringu. Nyangka-ya wati nyarra turampirrtjarralu ma-mirratjingara mapitjalayintja. Nyangka-ya wati nyarra puuka miirl-miirltjarralu wanarayintja. Nyangka-ya warrmarla kutjupatjarralu marlawanalu wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Tjiinya-ya puuka miirl-miirlpa parrakatirrayirnu marlaku pitjangu Tjatjuwalu watjannyangka. Palunyalulta-ya ngurraku marlaku pitjangu ngarringu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","14","Nyangka Tjatjuwanya munga-mungangka pakaralpi-tjananya watjarnu, “Palunyapirinypartu-ya puru yiwarlawana parrapitjala ngurraku marlaku pitja.” Nyangka mularrpartu-ya wati nyarra tiinti miirl-miirlta waarka palyalpayi puru warrmarla pirninya palunyapirinypartu parrapitjalayintja. Palunyatjanu-ya marlaku ngurraku pitjangu. Tjirntu kutjupa tjirntu-ya kutjuwarra parrapitjala ngurraku marlaku pitjangu. ");
INSERT INTO ntj_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Nyangkalta-ya ngurra 6-tjanu tjirntu kutjupangka mungayurntura pakaralpi mapitjangu yiwarlawana parrapitjangu yara palunyapirinypartu. Palunyalu-ya palunyapirinypartu puru 6-nguru parrapitjangu. ");
INSERT INTO ntj_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","19","Nyangka-ya wati nyarra turampirrtjarralu puulkitjangka Tjatjuwalu-tjananya yarnangu pirninya watjarnu, “Yuwa, Mama Kuurrtu-lanya yirringkanku. Nyangka-lan ngurra ngaangkatja yarnangu pirninyartu pungkulayilku mirrirntanku palunyalu kutjupa-kutjupa pirninya-tjanampa wiyalku. Palunyatjanu-lan minyma Rayipanyakutju wanka kanyilku, tjiinya wati kutjarranya-pulanya kumpitjunu kanyirnu, palunyangka. Nyangka-ya kutjupa-kutjupa nyakula pampuntjamaaltu wanti. Tjiinya kutjupalu kutjupa-kutjupa pampuralpi-lanya kunkanymanku. Nyangka-yan kawurlpa, tjilpa, puru yayinpa nyakulalpi mawurntalpa watitjurra wanti. Tjiinya Mama Kuurrku-ra. Yuwa, mirra-ya.” ");
INSERT INTO ntj_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","21","Nyangka-ya wati nyarra turampirrtjarralu mirratjingarnu. Nyangka-ya warrmarla lingkirrpa mirrangu. Nyangkalta yaarrpa purlkanyanya yungarra purlparraarnu. Palunyangkalta-ya makukurraarnu yiwarlangka tjarrparralpi kunmarnu purlkanyangka-tjananya wakarayirnu-wakarayirnu mirrirntanu. Nyangka-ya wati, minyma, tjilku pirninyatarrartu mirrirringu wiyarringu. Nyangka-ya puluka, tjiipu puru tungki pirninyartu mirrirringu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Nyangka Tjatjuwalu wati nyarra parranyakupayi kutjarranya witurnu, “Yarra-pula minyma Rayipanya nyawa. Palunyaku yungarrapirti yarltirra kati tjiinya-pulan watjarnu wantitjatjanulu.” ");
INSERT INTO ntj_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Nyangka-pula mularrpartu Rayipaku yiwarlangka tjarrpangu-tjananya yarnangu pirninya yarltirra katingu. Palunyalu-tjananya nyinatjunu Yitjurayilku tjamupirtiku ngurrangka ngamu. ");
INSERT INTO ntj_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Nyangka-ya warrmarla pirnilu yiwarla palunyanya tilirnu tjarrpatjunu. Nyangka mantakutju ngaralanytja. Nyangka-ya kawurlpa, tjilpa, yayinpatarrartu yurrara katingu mawurntalpa tjunu Mama Kuurrku. ");
INSERT INTO ntj_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Tjiinya Rayipanya puru palunyaku yungarrapirtikutju wankarringu nyinarranytja. Tjiinyamarntu wati kutjarranya kumpitjunu kanyiranytja, palunyangka Tjatjuwalu-tjananya wanka kanyiranytja. Nyangka-ya palunyaku tjamu kaparlipirti ngurra Yitjurayilta tirtu nyinarra kuwarrinya-rna tjukurrpa ngaanya walkatjuranyangka. ");
INSERT INTO ntj_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Nyangka Tjatjuwalu-tjananya yarnangu pirninya ngaapirinypa watjarnu ngurlutjunu, “Yiwarla ngaanya-kurlu-yan marlakulu palyalku. Wanti. Tjinguru kutjupalu yiwarla ngaanya marlakulu palyalku. Nyangka Mama Kuurrtu-lu yinitjunku. Nyangka-ra palunyaku katja tirnanya puru marlangkatjanya mirrirringku, tjiinyamarntu yiwarla palunyanya marlakulu palyannyangka.” ");
INSERT INTO ntj_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Yuwa, Mama Kuurrtu Tjatjuwanya tirtu yirringkaranytja. Nyangka-ya yarnangu pirni ngurra lipingkatjalu tjukurrpa palunyatjarra kuliralpi watjaranytja tjiinya wati purlkanyanyu. ");
INSERT INTO ntj_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Nyangka tjiinya Mama Kuurrtu-tjananya watjarnu kutjupa-kutjupa Tjarikanyamartatji-ya mantjintjamaaltu wantitjaku. Nyangka wati kutju yini Yayikantu tungun-tungunarringkulalpi kutjupa-kutjupa yurrara katingu. Nyangka Mama Kuurrnga-tjanampa Yitjurayilku tjamupirtiku mirrparnarringu. ");
INSERT INTO ntj_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Nyangka-ya Tjarikala ngamu ngurrangka nyinarranytja. Nyangka Tjatjuwalu wati-tjananya witurnu yiwarla yini Yayinya mapitjala parranyakula pitjala watjaltjaku. Nyangka-ya mularrpartu yanu parranyakulanytja. ");
INSERT INTO ntj_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Palunyalu-ya marlakulu pitjangu Tjatjuwala watjarnu, “Wiya, pirnimunu-ya. Warrmarla marnkurr-marnkurrpa witula, tjinguru 3,000-pa.” ");
INSERT INTO ntj_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","5","Nyangka mularrpartu Tjatjuwalu-tjananya warrmarla 3,000-pa witurnu. Nyangka-ya mularrpartu yanu mirri pungkukitja. Nyangka-ya wati Yayinyamartatjilu pakara-tjananya ngurlura kukurrtjingara wanarayirnu wantingu. Wati 36-pa-tjananyaya pungu mirrirntanu. Palunyalu kutjupatjarranya-tjananya kukurrtjingara wanarayirnu mawantingu. Nyangka-ya warrmarla Yitjurayilku wartangkatja ngurlu-ngurlurringkula wantirra pitjanytja. Nyangka-ya yarnangu pirninyatarrartu ngurlu-ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Nyangka-ya Tjatjuwanya puru liita pirninya tjurlpilyarringu. Palunyalu-ya yanu Mama Kuurrku puuka miirl-miirlpangka pupakatirralpi puparrayirnu tjirntu tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Nyangka Tjatjuwalu Mama Kuurrta watjarnu, “Wiya Mama, nyaatjanu-lanyatjun katingu ngurra ngaaku? Wiya, ngurra ngaangkatjalu-lanyatju pungku mirrirntanku wiyalku. Tjinguru-latju ma-nyinama kapi Tjuutanta kakarrara. ");
INSERT INTO ntj_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Wiya Mama, purtu-rna kulira watjalkitjalu. Tjiinya ngayuku warrmarlalu-tjananyaya purtu pungkula ngurlu kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Nyangka-ya yarnangu kutjupatjarralu kuliralpi-lanyatju pitjaku parrayangatjunkulalpi pungku mirrirntanku. Tjiinya-ya watjalku nyuntulu-lanyatjun purtu yirringkaranytja.” ");
INSERT INTO ntj_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Nyangka Mama Kuurrtu Tjatjuwanya watjarnu, “Nyaakun mantangka ngarrirra? Pakala. ");
INSERT INTO ntj_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Tjiinya Yitjurayilku tjamupirti-ya tungun-tungunarringu. Watjarnu-rna kutjupa-kutjupa Tjarikanyamartatji-ya pampuntjamaaltu tililtjaku. Nyangka-ya kutjupa-kutjupa tungun-tunguntu mulyatarringu. Palunyalu-ya mayuralpi kumpitjunu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Tjiinya palunyangurungka-ya warrmarla nyarranya nyakula ngurlu kukurraarnu. Wiya, kunkanypa-ya. Nyangka-tjananyarnanta ngayulu nyinakitjamunu. Ngarna-yan kutjupa-kutjupa mulyatarrinytjanya nyakulalpi tililku tjunku. Nyangka-tjanamparnanku kalyparringkulalpi tirtu nyinama. ");
INSERT INTO ntj_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Yuwa, watjala-tjananya parltjiltjaku-yanku palunyatjanu tjirntungka pitjala-ya ngayula ngaratjaku. Tjiinya-ya kutjupa-kutjupa mulyatarringu ngayulu-tjananyarna watjarnu tilira tjunkutjaku. Nyangka-tjananyarnanta yirringkankukitjamunu. Ngarna-yan kutjupa-kutjupa ngurriralpi tililku tjunku. Palunyangka-tjananyarnanta puru yirringkanku. Nyangka-yan yanyan-yanyanpa nyinapayi pirninya pungkula wiyalku. ");
INSERT INTO ntj_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Yitjurayilku tjamupirti-tjananya watjala nyangka-yayi tjirntungka pitja yungarrapirti-yungarrapirti ngara. Nyangka-rna wati kutju nintitjunku. ");
INSERT INTO ntj_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Nyangkalta-yan mirri pungkulalpi tililku tjunku puru katja yurntalpirti puru palunyaku yulytjatarra. Tjiinya-rna watjarnu wantingu kutjupa-kutjupa ngurra nyarra Tjarikanyamartatji-yan pampuntjamaaltu wantitjaku. Kurntangka! Ngayuku wangka kulirnu wantirralpi tungun-tunguntu mulyatarringu. Palunyangka-yan pirninyartu kunkanyarringu.” ");
INSERT INTO ntj_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","18","Nyangka Tjatjuwanya munga-mungangka pakaralpi wati pirninya yarltingu kutjungkanu nyarra Mama Kuurrku puuka miirl-miirlta. Nyangkalta-ya pitjangu yungarrapirti-yungarrapirti ngaralanytja. Nyangka Mama Kuurrtu nintitjunu Yayikannga. ");
INSERT INTO ntj_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Nyangka Tjatjuwalu-lu watjarnu, “Wiya Yayikan, tjurrkurltunku watjala Mama Kuurrtunta kuliranyangka. Nyaapan mulyatarringu? Kumpitjunkutjamaaltu watjalanku yartakarra.” ");
INSERT INTO ntj_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Nyangka Yayikantu watjarnu, “Yuwa, mularrpa-rna Mama Kuurrta tungun-tungunarringu. ");
INSERT INTO ntj_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","22","Nyarra Tjarikala-rna nyangu kawutu walykumunu puru tjilpa kawurlpatarrartu ngarrirranyangka mukurringu mantjira katingu. Palunyalu-rna ngayuku tiintingka tjawarnu kumpitjunu wantingu.” Nyangka Tjatjuwalu wati-tjananya witurnu palunyaku tiintikutu. Nyangka-ya mularrpartu kukurraarnu tjawaralpi nyangu kawutu, kawurlpa puru tjilpatarrartu ngarrirranyangka. ");
INSERT INTO ntj_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Nyangka-ya yurrara marlakulu katingu puuka miirl-miirlta ngamu tjunu. Nyangka-ya pirnilu nyangu. ");
INSERT INTO ntj_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Palunyatjanulu-ya Yayikannga tjulyaralpi palunyaku katja yurntalpirtitarrartu tjulyarnu. Palunyalu-ya kawutu puru kawurlpa, tjilpatarrartu puru tiinti, yulytja kutjupa-kutjupatarrartu mantjira katingu karru-karru yini Kunkanytja tjunu. Palunyalu-ya palunyaku puluka, tungki, tjiiputarrartu tjirtira wanarayirnu palunyangkartu mawantingu. ");
INSERT INTO ntj_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Nyangka Tjatjuwalu watjarnu, “Yuwa, nyuntulu-lanyatjun kunkanymanu. Nyangka Mama Kuurrtunta nyuntunya kunkanymanu.” Nyangka yarnangu pirnilu-ya yapungka yaturayirnu mirrirntanu Yayikannga puru palunyaku katja yurntalpirtitarrartu. Palunyatjanu-tjananya tilirnu tjunu palunyaku yulytja pirninyatarrartu. ");
INSERT INTO ntj_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Palunyalu-ya yapu pirni yurrara katingu kutjungkarayirnu wantingu. Palunyalu-ya ngurra palunyanya tjapirnu yini Karru-karru Kunkanynga. Nyangka Mama Kuurrnga-tjanampa kalyparringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Nyangka Mama Kuurrtu-lu Tjatjuwanya watjarnu, “Ngurlurringkutjamaalpa kurrurnpa rapa nyinama. Yuwa, warrmarlarringkula-yan yanku ngurra Yayilakutu. Nyangka-tjananyarnanta yirringkanku. ");
INSERT INTO ntj_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Nyangka-yan yarnangu pirninya pungku wiyaralpi ngurra tililku tjarrpatjunku. Tjiinya-yan Tjarikanya tilirnu tjarrpatjunu, palunyapirinypa. Yuwa, ngaangkalpi-tjananyarnanta watjarnu kutjupa-kutjupa Tjarikanyamartatji-yan pampuntjamaaltu wantitjaku. Nyangka kuwarrinya-yankun kutjupa-kutjupa pirninya palya kanyilku puru yanamulpa pirninyatarrartu. Yuwa, yanku-yan yiwarlangka takulu kumpilku nyinaku palunyalu-tjananya tjulurrtjingalku.” ");
INSERT INTO ntj_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","4","Nyangka mularrpartu Tjatjuwalu-tjananya palunyaku warrmarlapirti tamarlmanu. Palunyalu warrmarla 30,000-pa pikaputjunya ngurrkarntaralpi-tjananya watjarnu, “Mungangka-yan yanku yiwarla Yayila takulu kumpiralpi nyinama. ");
INSERT INTO ntj_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Nyangka warrmarla kutjupatjarranya-latju yanku yiwarlakutu ngamurriku. Nyangka-lanyatjuya wati Yayinyamartatjilu nyakulalpi pakalku pika pungkukitja. Nyangka-latju ngarnartu pinkurraara kukurraalku. ");
INSERT INTO ntj_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Nyangkalta-ya kulilku, ‘Wiya, ngurlu-ya kukurraarnu tjiinya-ya ngaangkalpi kukurraarnu, palunyapirinypa.’ Palunyangka-lanyatjuya ngurlura wanalku tiwa-tiwalku. ");
INSERT INTO ntj_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","8","Nyangkalta-yan kumpira nyinarranytjatjanu pakara ngalyakukurraalku. Palunyalu-yan yiwarlangka tjarrparralpi tililku tjunku, tjiinya Mama Kuurrtu-tjananyanta yirringkaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Nyangka-ya mularrpartu yanu kumpirnu nyinarranytja yiwarlangka takulu. ");
INSERT INTO ntj_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Nyangka Tjatjuwanya ngurrangka ngarringu tjirnturringkulalpi munga-mungangka pakarnu. Palunyalu warrmarla kutjupatjarranya yarltirra-tjananya walara katingu Yayilakutu. ");
INSERT INTO ntj_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Nyangka-ya yiwarla wayirntara kayili kutipitjangu murrpungka ngurra tjunu. Palunyalu ngalyanyinarra yiwarlakutu nyakulanytja. Nyangka karru-karru ngururrpa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","15","Nyangka puurrpa Yayinyamartatjilu nyangu Tjatjuwaku warrmarlapirti nyinarranyangka. Palunyalu-ya pakara waarrpungkula watipitjangu pika pungkukitja. Nyangka Tjatjuwanya-ya ngarnartu pinkurraara kukurraarnu yurirlkutu. Nyangka warrmarla kutjupatjarra-ya yiwarla kutjupanguru kumpirnu nyinarranytja pika pungkukitja. Nyangka puurrpa Yayinyamartatji ngurrpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","17","Tjiinya wati pirninya-tjananya yarltingu kutjungkaralpi watjarnu, “Waarrpungkula-tjananyaya wati pirninya ngurlura wanala.” Nyangka mularrpartu-tjananyaya waarrpungkula ngurlura wanarnu. Nyangka kutjupanya-ya yiwarlangka nyinanytjamunurtu. Tjiinya pirnilurtu-ya kayirrpa yarla wantirra kukurraarnu. Palunyalu Tjatjuwanya-tjananya tiwa ngurlura wanarnu. ");
INSERT INTO ntj_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Nyangka Mama Kuurrtu Tjatjuwanya watjarnu, “Kurlartanku katula kanyiralpi yiwarla Yayilakutu nintitjurra. Tjiinya-rnanta yirringkanku. Nyangka-yan yarnangu pirninya pungku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Nyangka mularrpartu kurlarta katurnu kanyiranytja. Nyangka-ya warrmarla nyarra kumpirnu nyinarranytja, palunyanya-ya pakara watikuku-kukurraarnu yiwarlangka tjarrparralpi waarrpungu tilirnu tjunu. ");
INSERT INTO ntj_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","21","Nyangka-ya wati Yayinyamartatjilu marlakukuturalpi nyangu tjunarnpa purlkanya pakaranyangka. Nyangka Tjatjuwaku warrmarlalutarrartu-ya nyangu tjunarnpa purlkanya pakaranyangka. Tjiinya-ya nintilu kulirnu warrmarla nyarra kutjupanguru-ya nyinanytjatjanulu tjarrparralpi tilirnu. Palunyalu-ya pinkurraaralpi-tjananya wati Yayinyamartatji wakara mirrirntaranytja. Nyangka-ya purtu kulirnu kukurraalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Nyangka-ya warrmarla Yitjurayilku wartangkatjalu tilirnu tjunkulalpi wantirra ngalyakukurraarnu lurrtjurringkulalpi-tjananya wakarayirnu-wakarayirnu wiyarnu yurirlkutjurnu. ");
INSERT INTO ntj_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Nyangka-ya warrmarla Yitjurayilku tjamupirtilu-ya marlaku kutipitjangu yiwarlangka tjarrparralpi yarnangu kutjupatjarranya pungu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","26","Nyangka Tjatjuwalu kurlarta yiwarlakutu tirtu nintitjunkula kanyirayirnu, nyangka yarnangu pirninya Yayinyamartatji mirrirringu. Tjiinya-ya wati minyma 12,000-pa-ya mirrirringu tjirntu palunyangkartu. ");
INSERT INTO ntj_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Nyangka Yitjurayilku tjamupirtilu-yanku kutjupa-kutjupa pirni, yanamulpatarrartu mantjirnu kanyiranytja tjiinya Mama Kuurrtu Tjatjuwanya watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","2","Nyangka-ya puurrpa pirni nyarra kapi Tjuutanta yapurra nyinarranytjalu kulirnu tjukurrpa Yitjurayilku tjamupirtilu-ya yiwarla kutjarra tilirnu tjarrpatjunkutja. Nyangka-ya lurrtju-lurrtjurringu Yitjurayilku tjamupirti pika pungkukitja. ");
INSERT INTO ntj_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Parturtu-ya yarnangu kutjupa nyarra yiwarla Kipiyanngamartatjilu tjuma palunyanya kuliralpi ");
INSERT INTO ntj_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","5","tjumara watjaranytja Tjatjuwanya mayulkitjalu. Nyangka-ya wati marnkurr-marnkurrtu ngarnartu warntu yarlatjarra tjarrpatjunu puru tjinapuunpa yarlatjarra. Palunyatjanulu-ya nyamirli ngarnmanytjatja mantjirnu yakutjangka tjarrpatjura tungkingka tatira yanu. ");
INSERT INTO ntj_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Palunyatjanu-ya pitjalayirnu nyangu Tjatjuwanya ngurrangka nyinarranyangka. Palunyalu-ya watjarnu, “Yuwa, ngurra tiwanguru-latju pitjangu. Nyangka-munta-lankun wangkarra kulilku palyarnkarralku pikamaalpa pukurlpa-lankun nyinakitjalu?” ");
INSERT INTO ntj_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Nyangka-ya wati nyarra Yitjurayilku tjamupirtilu watjarnu, “Wiya, tjinguru-yan ngurra ngamungurutarrartu pitjangu. Tjiinya Mama Kuurrtu-lanyatju watjarnu yarnangu ngurra ngaangkatja lurrtjurringkula wangkarra kuliranytjamaaltu wantitjaku.” ");
INSERT INTO ntj_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Nyangka-ya wati nyarra Kipiyanngamartatjilu Tjatjuwanya watjarnu, “Yuwa puurr, nyuntuku wangka-latju wangarnarralu kulira palyanma kutjupa-kutjupan watjaranyangka.” Nyangka Tjatjuwalu-tjananya watjarnu, “Ngananya-yan? Ngurra wanytjanguru-yan pitjangu?” ");
INSERT INTO ntj_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Nyangka-ya watjarnu, “Wiya puurr, ngurra tiwanguru-latju pitjangu. Kulirnu-latju tjukurrpa Mama Kuurrngatjarra. Puru-latju tjukurrpa kulirnu Mama Kuurrtu-tjanampanku ngurra Yiitjipula yayirninytjulu kutjupa-kutjupa palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","Puru-latju kulirnu tjiinya Mama Kuurrtu-tjananyanta yirringkanu kapi Tjuutanta kakarrara. Nyangka-yan puurrpa kutjarra puru yarnangu pirninyartu pungu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Nyangka liita pirnilu-lanyatju witurnu pitjala-latju nyuntunya-tjananyanta tjapiltjaku, ‘Palya-munta-lankun wangkarra kuliralpi palyarnkarralku pikamaalpa-lankun pukurlpa nyinakitjalu?’ ");
INSERT INTO ntj_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","13","Tjiinya-latju ngurra tiwanguru pitjangu. Nyamirli ngaanya nyawa. Warungkatja-latju mantjiralpi yakutjangka tjarrpatjura katirrayirnu, nyangka ngarringu pikirringu. Nyawa-lampatju warntu tjinapuunpatarrartu. Walykumunu-latju tjarrpatjura pitjalayirnu nyangka yarlatjarrarringu yiwarra wirrmirangka.” ");
INSERT INTO ntj_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","15","Nyangka-ya Yitjurayilku tjamupirti watatjarringu Mama Kuurrnga tjapilkitja. Tjinguru-ya Mama Kuurrnga tjapinma, “Palya-munta-latju palyarnkarralku wantiku wati ngaanya-tjananya pukurltu yirringkankukitjalu?” Nyangka Tjatjuwalu-tjananya watarrkulu palyarnkarrarnu wati maliki pirninya mirrirntankutjamaaltu wantikitjalu. Nyangka-ya liita pirnilutarrartu palyarnkarrarnu pukurltu-tjananya yirringkankukitjalu. Nyangka-ya wati maliki ngurraku marlaku kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Nyangka ngurra kutjarratjanulu Yitjurayilku tjamupirtilu-ya kulirnu tjiinya wati palunyanya-ya mularrpartu ngamu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Palunyalu-ya pakara yanu wangkakitja-tjananya. Marlawanalu-ya ma-wanarayirnu ngurra kutjarratjanu waalkarrarnu ngurra palunyangka-ya nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Nyangka kutjupatjarralu-ya pikaku kuliranytja tjiinya ngurra Kipiyanngamartatjinya-tjananya wakalkitjalu. Nyangka Tjatjuwalu-tjananya watjarnu, “Wiya, mirri pungkutjamaaltu-tjananya wanti. Tjiinya-lan Mama Kuurrta mirangka wangkarralpi palyarnkarrarnu pukurltu-tjananya yirringkankukitjalu.” Nyangka-ya yarnangu pirninya mirrparn-mirrparnpa wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Parturtu liita pirnilu-ya watjarnu, “Wiya, Mama Kuurrta mirangka-lan palyarnkarrarnu pukurltu-tjananya yirringkankukitjalu. Kamu-lan mirri pungku. ");
INSERT INTO ntj_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Tjiinya-lan wartalpitjanu palyarnkarrarnu. Wanti-tjananya nyangka-yayi wanka nyinama. Tjiinya Mama Kuurrnga-lampa mirrparnarritjakutarra-la wanti. ");
INSERT INTO ntj_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Nyangka-lampaya tjimarri wiyalu waarka tirtu palyanma. Tjiinya-ya waru kartara katima, kapitarra tjutira katima.” ");
INSERT INTO ntj_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Nyangka Tjatjuwalu wati kutju witurnu liita-tjananya Kipiyanngamartatji yarltirra katitjaku. Nyangka-tjananya mularrpartu yarltirra katingu. Nyangka-tjananya tjapirnu, “Nyaatjanulu-yan mayurnu watjarnu tiwanguru pitjanytjatjanulu? Nyuntulu-kulila-yan ngamu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Wiya, Mama Kuurrtu watjarnu waarka-yan tjimarri wiyalu palyaratjaku. Tjiinyamarntu-yan mayurnu watjarnu tiwanguru pitjanytjatjanulu. Palunyangka-yan waru katapungkula katima, kapitarrartu tjutira katima Mama Kuurrku tiinti miirl-miirlkutu.” ");
INSERT INTO ntj_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Nyangka-ya watjarnu, “Wiya, tjukurrpa palyamunu-latju kulirnu ngurlu-ngurlurringkulalpi mayurnu. Tjiinya-latju ngurlurringu mirrirritjakutarra. Kulirnu-latju tjiinya Mama Kuurrtu watjarnu-lanyatju mirri pungkutjaku. Puru watjarnu ngurra-lampatjun ngurlunyparrara yungarrarringkula kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Yuwa, nyuntulu-ya yungarralu kulila. Yaaltjingalku-lanyatjun? Tjinguru-lanyatjun mirri pungku. Wiya-tjinguru-lanyatjun wanka kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Nyangka Tjatjuwalu-tjananya Yitjurayilku tjamupirti marrkurnu yarnangu Kipiyanngamartatji-tjananya mirri pungkutjaku. ");
INSERT INTO ntj_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Palunyatjanulu watjarnu yarnangu Kipiyantamartatji pirnilu-ya tjimarri wiyalu waarka tirtu palyaratjaku. Tjiinya-tjananya watjarnu waru-ya tirtu katapungkula katirratjaku puru-ya kapi tirtu tjutira katirratjaku Mama Kuurrku tiinti miirl-miirlkutu. Nyangka-ya palunyapirinypa tirtu palyara kuwarrinya-rna tjukurrpa ngaanya walkatjuranyangka. ");
INSERT INTO ntj_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","5","Nyangka puurrpa pirnilu-ya kulirnu tjiinya Tjatjuwalu-ya yiwarla kutjarra tilirnu tjarrpatjunu. Palunyalu kulirnu yarnangu Kipiyanngamartatjilu-yanku puru Yitjurayilku tjamupirtilu wangkarralpi palyarnkarrarnu ngaparrku yirringkankukitjalu. Palunyalu-ya lurrtjurringu nyinarranytja. Nyangka-ya lurrtjurringkulalpi warrmarlarringkula yanu. Pitjangu-ya yiwarla Kipiyannga parrangururrtjunu pika-tjananya wakalkitja. ");
INSERT INTO ntj_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Nyangka-ya wati Kipiyanngamartatjilu wati kutju witurnu yankula Tjatjuwanya watjaltjaku. Nyangka pitjangu watjarnu, “Wiya puurr, wirrtjala-lanyatju yirringkala. Tjiinya-ya puurrpa pirni warrmarlarringkula pitjangu pika-lanyatju wakara mirrirntankukitja. Wantinytjamaaltu-lanyatju wankakutu kanyila.” ");
INSERT INTO ntj_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Nyangka Tjatjuwalu kuliralpi palunyaku warrmarla pirninya yarltingu kutjungkara pakara yanu wati Kipiyanngamartatji yirringkankukitja. ");
INSERT INTO ntj_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Nyangka Mama Kuurrtu Tjatjuwala watjarnu, “Ngurlumaalpa raparringkula yarra ngayulu-tjananyarnanta miranykanyiranyangka. Nyangka-yan puurrpa pirniku warrmarla pirninyartu wakalku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Nyangka Tjatjuwanya-ya pitjalayirnu mungangka tjulurrku waalkarrarnu. ");
INSERT INTO ntj_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Nyangka Mama Kuurrtu-tjananya puurrpa pirniku warrmarla pina kuwar-kuwarmanu. Nyangka-ya kuwararrara parrakukurraaranytja. Nyangka-ya Yitjurayilku tjamupirtilu-tjananya yapuwanalu ngurlura parrawanara wakara mirrirntaranytja. ");
INSERT INTO ntj_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Nyangka-ya puurrpa pirniku warrmarla ngurlu kukurraarnu. Nyangka Mama Kuurrtu kunarta purlkanya wiyarnu. Nyangka-tjananya yatura mirrirntaranytja. Tjiinya Yitjurayilku tjamupirtilu-ya pirni-tjananya wakara mirrirntaranytja. Nyangka kunartalu-tjananya pirnipurlka yaturayirnu mirrirntanu, tjiinya-ya wakara mirrirntaranytja, palunyangka munkarra. ");
INSERT INTO ntj_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Tjiinya tjirntu palunyangkartu Mama Kuurrtu-tjananya Yitjurayilku tjamupirti yirringkaranytja. Palunyangka-ya puurrpa pirniku warrmarla wakarayirnu mirrirntanu. Nyangka Tjatjuwalu Mama Kuurrnga tjapirnu yarnangu pirnilu-ya kuliranyangka. Tjiinya ngaapirinypa tjapirnu, “Yuwa Mama, tjirntu marrkula nyangkayi kutjungkartu ngara. Kirnaratarrartu marrkula.” ");
INSERT INTO ntj_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Nyangka mularrpartu tjirntu kirnaratarrartu marrkurnu. Nyangka palunyangkartu ngaralayirnu nyangka-ya Yitjurayilku tjamupirtilu-tjananya wakarayirnu mirrirntanu. Nyangka tjirntu rawa ngaralayirnu ngulartu ma-tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Tjiinya Mama Kuurrtu palunyapirinypa kutjuwarra palyaranytjamunu. Palunyangkakutju wati kutjuku wangka kuliralpi tjirntu marrkurnu. Tjiinya Mama Kuurrtu-tjananya Yitjurayilku tjamupirti yayirninytjulu yirringkaranytja. ");
INSERT INTO ntj_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Nyangka Tjatjuwanya palunyaku warrmarla pirninya-ya marlaku kutipitjangu ngurrangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Nyangka Mama Kuurrtu-tjananya Yitjurayilku tjamupirti yirringkaranytja. Nyangka-ya yarnangu kutjupa-kutjupa pirni pungu wiyaralpi ngurrararringu. Palunyalu-ya pikamaalpa rawa nyinarrayirnu, nyangka Tjatjuwanya yirnarringu. ");
INSERT INTO ntj_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Palunyalu-tjananya Yitjurayilku tjamupirtiku liita pirninya kutjungkaralpi watjarnu, “Yuwa, yirnarringkulalpi-rna wiyarrikitja nyinarra. ");
INSERT INTO ntj_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Tjiinya-yan nyangu Mama Kuurrtu-lanya yayirninytjulu yirringkaranytja. Nyangka-yan yarnangu kutjupa-kutjupa pirninya pungu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","5","Nyangka-ya yarnangu kutjupatjarranya tirtu nyinarra ngula-yan pungkula wiyaltjaku. Tjiinya Mama Kuurrtu kalkurnu ngurra nyuntuku nintilkitjalu. Nyangka-yan ngula pika pungkukitja yanku. Nyangka Mama Kuurrtu-tjananya ngurlura kukurrtjingalku. Nyangka-yan ngurrararriku nyinama. ");
INSERT INTO ntj_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","Kuliltjarralu-ya mularrkulinma tjiinya wangka pirninyartu Mawutjalu walkatjunu wantitjanya. Wangka pirninyartu-ya wangarnarralu kulira palyanma.” ");
INSERT INTO ntj_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Nyangka Tjatjuwalu-tjananya tirtu watjara-wanarayintja, “Yuwa, ngayuku-tju ngamuntirringu tjiinya-rna wiyarringkutjaku. Nyangka-yan nintilu kulira tjiinya Mama Kuurrtu-lampa kutjupa-kutjupa walykumunu kalkuralpi nintirnu. ");
INSERT INTO ntj_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Tjiinya Mama Kuurrtu-lanya kalkurnu wantitjatjanulu walykumunulu yirringkaranytja. Puru tjiinya mirri pungkukitjalu kalkuralpi tjurrkurltu mirri pungkupayi. ");
INSERT INTO ntj_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Nyangka-tjinguru-yan Mama Kuurrku wangka wantirralpi kutjupa pupakatirralpi marninypungku. Nyangka-tjanampanku Mama Kuurrnga mirrparnarriku. Palunyalu-tjananyanta wiyalku. Nyangka ngurra walykumunutjanu tjirturu-tjirturu purlkanya ngarama.” ");
INSERT INTO ntj_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Nyangka Tjatjuwalu-tjananya Yitjurayilku tjamupirti yarltingu pitjala-ya ngurra kutjungka lurrtjurringkutjaku. Nyangka-ya mularrpartu pitja-pitjangu. Nyangka Tjatjuwalu-tjananya watjarnu yirna pirninya-ya pitjala Mama Kuurrku tiinti miirl-miirlta ngaralatjaku. Nyangka-ya mularrpartu pitjangu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Nyangka Tjatjuwalu-tjananya watjarnu, “Yuwa, Mama Kuurrtu ngaapirinypa watjarnu, ‘Yuwa, kutjulpirtu nyuntuku-tjanampanku tjamu mirripirti-ya kakarrara nyinarranytja ngurra tiwangka. Palunyalu-yanku tjukurrtatja kutjupa-kutjupa pirni pupakatirra marninypungkulanytja. Tjiinya Yayipuramaku mamalutarrartu pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Tjiinya Yayipuramanya-tjanampanku kutjutjamu nyinarranytja. Nyangka-rnalu ngurra tiwanguru yarltirra katingu. Palunyalu manta Kayinanta ngurra lipiwanalu walara parrakatirrayintja. Palunyalu-rnara katja kutju nintirnu yini Yayitjikinya. Tjiinya-yan Yayipuramalanguru yarnangu pirnirringu. ");
INSERT INTO ntj_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Tjiinya Yayitjikiku-rna katja kutjarra nintirnu Tjayikapanya puru Yiitjunya. Nyangka Tjayikapanya palunyaku katja yurntalpirtitarrartu-ya yanu ngurra Yiitjipula nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","6","Nyangka ngulartu-rna witurnu Mawutjalu-pula Yarantu nyuntuku-tjanampanku tjamupirti yirringkankutjaku. Palunyalu-rna Yiitjipula nyinapayi pirniku pika purlkanya yutirnu. Palunyalu-rna nyuntuku tjamupirti Yiitjipulanguru pakaltjingara walara katingu. Nyangka-ya yarnangu Yiitjipunyamartatjilu-tjananya wanarayintja purni kaarrtjarralu. Nyangka-ya nyuntuku-tjanampanku tjamupirti mapitjangu kapi Tjitirn-tjitirntakutu. ");
INSERT INTO ntj_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Palunyalu-rniya mirrarra tjapiranytja ngayulu-rna yirringkankutjaku. Nyangka-rna ngururrkutjarra mungalurrmanu tjiinya warrmarlalu-tjananya nyakula pungkutjakutarra. Palunyalu-rna kapi wartutankulalpi manta tikirlmanu. Nyangka-ya nyuntuku tjamupirti wankartu mapitjalayintja. Nyangka-ya warrmarla Yiitjipunyamartatjilu-tjananya ngurlura wanarnu. Nyangka-rna kapi marlakunu. Nyangka Yiitjipunyamartatjilu-ya kapi kuurltjurayirnu mirrirringu wiyarringu. Tjiinya-yan tjukurrpa palunyaku ninti.’ Nyangka Mama Kuurrtu tirtu watjara-wanarayintja, ‘Tjiinya-yan mayu-mayuwana parranyinarrayintja. ");
INSERT INTO ntj_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Nyangka kurli pirnitjanulu-tjananyarnanta walara katingu ngurra nyarra Tjuutanta kakarrara, palunyalakutu. Nyangka-ya yarnangu kutjupa ngurra palunyangka nyinarranytja. Nyangka ngayulu-tjananyarnanta yirringkanu. Nyangka-yan yarnangu pirninya pungu wiyarnu. Palunyatjanu-yan ngurrararringu nyinarranytja palunyaku-tjanampa ngurrangka. ");
INSERT INTO ntj_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Palunyalu-yan kapi Tjuutannga kartanypungkula pitjangu Tjarikalakutu. Nyangka-ya wati Tjarikanyamartatjilu-tjananyantaya pika pungkulanytja. Nyangka ngayulu-tjananyarnanta yirringkaranytja. Nyangka-tjananyayan pungu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Tjiinya-yan mapitjalayinnyangka-ya yarnangu pirninya ngurlurringkula kukurraarnu. Tjinguru-yan kulira nyuntulu-yan kunmarnu purlkanyangka puru kurlartangka ngurlutjingarnu. Wiya, ngayulu-tjananyarnanta yirringkara ngurlutjingaranytja. ");
INSERT INTO ntj_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Yuwa, nyuntulu-yan manta ngaanya tjawara yurninypa tjunkutjamunu. Ngayulu-tjanamparnanku manta mirrkatjarra nintirnu. Nyangka-yan kuwarrinya yiwarla yanyutjangka nyinarra. Tjiinya-yan yiwarla pirninya palyara tjunkutjamunu. Puru-yan warta mirrkatjarra tjunkula pakaltjingantjamunu. Tjiinya-yan mirrka yalipi puru kiripi warta yanyutjangkatja ngalkula.’ Palunyapirinypa Mama Kuurrtu watjarnu.” ");
INSERT INTO ntj_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Nyangka Tjatjuwalu-tjananya tirtu watjara-wanarayintja, “Yuwa, Mama Kuurrngakutju-ya wananma. Puru palunyaku wangka-ya wangarnarralu kulira palyanma. Tjiinya yapu pirni nyarra-yan pupakatirra marninypungkupayinya-ya warni wanti. Palunyalu-ya Mama Kuurrngakutju pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Tjinguru-yan kulira Mama Kuurrnga wantikitjalu. Wiya, wanytjanya-yan wanalku? Tjinguru-yan yapu pirni nyarra tjamupirtilu-ya kanyiranytjanya wananma. Tjinguru-yan yapu pirni nyarra ngurra ngaangkatjalu-ya kanyiranytjanya wananma. Wiya, ngayulu-latjunku Mama Kuurrnga wananma, ngayuku yungarrapirtilu-latjunku.” ");
INSERT INTO ntj_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Nyangka-ya yarnangu pirnilu watjarnu, “Wiya, Mama Kuurrnga-latjunku wantikitjamunu. Yapu kutjupa-kutjupa-latjunku pupakatirra marninypungkukitjamunu. ");
INSERT INTO ntj_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Tjiinya-ya ngayuku-lampa mamalu waarka purlkanya palyaranytja ngurra Yiitjipula. Nyangka Mama Kuurrtu-lanyanta yayirninytjulu pakaltjingarnu. Palunyalu-lanyanta miranykanyira parrakatirrayintja ngurra kutjupa-kutjupawana. ");
INSERT INTO ntj_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Nyangka-lan ngurra ngaaku pitjangu. Nyangka Mama Kuurrtu-tjananya yarnangu pirninya pungu wiyarnu. Nyangka-latju Mama Kuurrnga tirtu marninypungama. Tjiinya palunyanyakutju nyinarra ngayulu-lan pupakatirra marninypungkulatjaku.” ");
INSERT INTO ntj_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Nyangka Tjatjuwalu-tjananya watjarnu, “Wiya, pamparr-pamparrtu-yan watjarnu. Kuliltjarralu-yanku kulinma. Tjiinya Mama Kuurrnga tjukarurru nyinarra. Palunyalu watjarnu palunyanyakutju-la pupakatirra marninypungkulatjaku. Tjinguru-yan kutjupa pupakatiku marninypungku. Nyangka-tjanampanku mirrparnarringkulalpi kalyparrikitjamunu. ");
INSERT INTO ntj_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Tjiinya Mama Kuurrtu-lanya walykumunulu miranykanyira kanyira. Wantiku-kurlu-yan. Tirtu-ya kulinma. Kutjupa-ya pupakatirra marninypungkutjamaaltu wanti. Tjinguru-yan palunyapirinypa palyalku. Nyangka Mama Kuurrtu wuyurrpa kutjuparringkulalpi-tjananyanta pungku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Nyangka yarnangu pirnilu-ya watjarnu, “Wiya, ngayulu-latju Mama Kuurrngakutju pupakatirra marninypungama.” ");
INSERT INTO ntj_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Nyangka Tjatjuwalu-tjananya watjarnu, “Kutjupatjarralu-yanku yapu tirtu kanyira pupakatirra marninypungkukitjalu. Wiya, warni-ya wanti. Palunyalu kurrurntutarrartu-ya watjala Mama Kuurrngakutju wanalkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Nyangka-ya yarnangu pirnilu Tjatjuwanya watjarnu, “Wiya, ngayulu-latjunku Mama Kuurrngakutju pupakatirra marninypungama. Palunyalu-latju palunyaku wangka wangarnarralu kulira palyanma.” Nyangka-ya mularrpartu yapu pirninya nyarra pupakatirra marninypungkutjatjanulu warningu wantingu. ");
INSERT INTO ntj_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","26","Nyangka Tjatjuwalu wangka pirni walkatjunu Mama Kuurrku ruulangka tjiinya-ya tirtu nyakula-wanaratjaku palunyalu kuliratjaku. Puru-tjananya watjarnu watilu-ya yapu purlkanya murrutjunku wantitjaku. Nyangka-ya mularrpartu murrutjunu Mama Kuurrku tiinti miirl-miirlta yitingka. ");
INSERT INTO ntj_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Nyangka Tjatjuwalu-tjananya yarnangu pirninya watjarnu, “Tjiinya ngula-yan yapu ngaanya nyakulalpi ruukulinma tjiinya-yan watjarnu wantingu Mama Kuurrnga tirtu wanalkitjalu. Yapu ngaanya-ya nyakula kulinma Mama Kuurrnga-yan watarrkurringkula wantitjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Nyangka Tjatjuwalu-tjananya yarnangu pirninya ngurrakutu witurnu. Nyangka-ya ngurra yungarra-yungarrakutu kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Nyangka Tjatjuwanya mirrirringu tjiinya kurli-ra 110-pa ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Palunyangka-ya tjurnutjunu yapu parntangka yiwarlangka ngamu. ");
INSERT INTO ntj_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Nyangka-ya Yitjurayilku tjamupirti nyinarrayirnu Mama Kuurrku watatjarringu. Tjiinya Tjatjuwanya wanka nyinarranyangkalpi-ya Mama Kuurrnga tirtu pupakatirra marninypungkulanytja. Puru yirna pirninya-ya wanka nyinarranyangkalpi yarnangu pirnilu-ya Mama Kuurrku wangka wangarnarralu kulira palyaranytja. Tjiinya-ya yirna pirnilu nyangu Mama Kuurrtu yayirninytjulu kutjupa-kutjupa palyaranytja. Nyangka Tjatjuwanya puru yirna pirninya-ya mirrirrinyangka Yitjurayilku tjamupirti-ya Mama Kuurrku watatjarringu. ");
INSERT INTO ntj_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Nyangka tjiinya-ya Yitjurayilku tjamupirtilu Tjawutjaku mirri tarrka Yiitjipulanguru katingu. Rawalu-ya parrakatirrayintja. Palunyalu-ya tjurnutjunu Tjayikapaku ngurrangka. Tjiinya kutjulpirtu Tjayikapalu tala 100-pa nintiralpi manta payipungu, ngurra palunyangkartu-ya tjurnutjunu. Yuwa, palunya.");
INSERT INTO ntj_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Kutjulpirtu puurrpa purlkanya-ya kuwarripangka, wati yini Limalikanya nyinarranytja ngurra Tjuutala tjiinya yiwarla yini Pitjiliyamala. Tjiinya wati palunyanya Puratjaku wartangkatja. Nyangka-ra kurri yini Nayaminya. Nyangka-pulanku katja kutjarra kanyiranytja yini Maalannga-pulanya Kiliyannga. Nyangka yayilurru purlkanya ngurra palunyangka ngaralanytja. Nyangka Limalikanya-ya pakara kutipitjangu ngurra yini Mawapala nyinakitja. ");
INSERT INTO ntj_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Tjarrpangu-ya nyinarranytja. Nyangka minyma palunyanya Nayaminya kutjurringu. Palunyalu katja wangulyara kutjarratjarra ngurra palunyangkartu tirtu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Nyangka-pula Nayamiku katja kutjarralu nyinarrayirnu kurri yarltingu ngurra palunya Mawapanyamartatji. Tjiinya Maalantu kurri yini Rutjanya yarltingu. Nyangka Kiliyantu kungka yini Yuupanya yarltingu. Nyangka-ya nyinarrayirnu, nyangka kurli 10-tjanu ");
INSERT INTO ntj_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Nayaminya purrkutjarrarringu katja kutjarranyartu wiyarrinyangka. Tjiinya minyma palunyanya ngurra kutjungkartu kutjurringkulalpi nyinarrayirnu puru purrkutjarrarringu. Palunyalu ngurra palunyangka tirtu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Nyangka Nayamilu nyinarrayirnu kulirnu Mama Kuurrtu-tjananya palunyaku yungarrapirti ngurra nyarra Tjuutala yirringkaranytja. Tjiinya kapi purlkanya punkarnu. Nyangka mirrka purlkanya pakannyangka-ya pukurltu yurraranytja. Nyangka-ya Nayaminya puru palunyaku mingkayi kutjarra warntu karrpiralpi Mawapanya wantirra pakara yanu ngurra nyarra Tjuutaku marlaku yankukitja. Mapitjalayirnu-ya, ");
INSERT INTO ntj_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","nyangka Nayamilu palunyaku mingkayi kutjarranya watjarnu, “Kulila-pula. Marlaku-pula yarra ngunytjungka nyinama. Nyangka-pulanyanta Mama Kuurrtu walykumunura kanyinma, tjiinya-pularnin ngayunya puru ngayuku katja kutjarranya walykumunura kanyiranytja, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Palunyalu Mama Kuurrtu-pulanyanta ngula kurri kutjupa nintilku yarltirra-yan nyinatjaku. Nyangka-yan pukurlpa nyinama.” Nyangka Nayamilu-pulanya nyunytjurnu wantirra yankukitjalu. Nyangka-pula yularra ");
INSERT INTO ntj_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","watjaranytja, “Wiya, nyuntunya-litju wantikitjamunu. Mukurringkula-litju nyuntuku yungarrapirtingka mapitjala lurrtjurringkula nyinakitja.” ");
INSERT INTO ntj_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nyangka Nayamilu-pulanya watjarnu, “Wiya, wantirra-pula marlaku mapitja ngurrangka nyinama. Nyaakunyka-pularnin tirtu wanarayirni? Ngayulu-munta-rna katja kutjupa kanyilku nyuntunya-pulanyanta purlkarringkula kurri yarltitjaku? Wiya, palunyaku-rna wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Kulila-pula. Marlaku-pula mapitja. Tjiinya-rna wartalpitjanu pamparringu. Puru-rna kurri kutjupanya yarltikitjamunu. Ngaanya-rna ngarnartu watjalku. Tjinguru-rna kuwarrinyartu kurri yarltiku palunyatjanulu-rna katja kutjarra kanyilku. Nyangka-munta-pulan rawa nyinama watirringkulalpi-pulanyanta yarltitjaku? Wiya! Kutjupalu-pulanyanta yarltiku. Tjiinya Mama Kuurrtu-rni wantingu. Nyangka-rna tjirturu-tjirturu purlkanya parrapitjalayirni. Palunyalu-pulamparnanku purlkanya ngarlturringkula.” ");
INSERT INTO ntj_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Nyangka-pula puru yularranytja. Nyangka Yuupalunku mingkayi nyunytjura wantirra marlaku yanu. Nyangka-lu Rutjalu yampurnu tirtu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nyangka Nayamilu nintitjuralpi watjarnu, “Ma-nyawa nyuntuku tjurtu Yuupanya nyarra mapitjalayirni palunyaku yungarrapirtikutu, puru palunyaku tjukurrtatja pirnikutu. Nyangkanku waarrpungkula nyuntuku tjurtuwana yarra.” ");
INSERT INTO ntj_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Nyangka Rutjalu watjarnu, “Wiya, wituntjamaaltu-rni wanti. Tjiinya-rna kulira nyuntulawana yankukitjalu. Mukurringkula-rna nyuntuku yungarrapirtingka lurrtjurringkula nyinakitja. Ngayulutarrartu-rna mukurringkula Mama Kuurrnga pupakatirra marninypungkukitja. Kulira-rna nyuntunyapirinyarrikitjalu. ");
INSERT INTO ntj_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Nyangka-lin kutjarranyartu ngurra palunyangka nyinarrayilku wiyarringku. Nyangka-linyaya kutjarranyartu lurrtjurtu tjurnutjunku. Tjiinya-rnanta Mama Kuurrta mirangka tjukarurrulu watjara. Mayuranyangka-tjinguru-rni palya pikarntanku mirrirntankutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nyangka Nayamilu kuliralpi wangka kanmarrarringu. Tjiinya Rutjalu putakulu watjaranytja wanalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Nyangka-pula wantirra kawakurtu kutipitjangu. Pitjalayirnu-pula Pitjiliyamala waalkarrara parrapitjangu. Nyangka-ya pirnilu nyakulalpi kata paarnarrarnu. Pakara-ya wirrtjarnu mularrnyakukitja. Nyangka-yanku minyma pirnilu ngaparrku tjapiranytja, “Mularrpa-munta nyarranya Nayaminya?” ");
INSERT INTO ntj_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nyangka-tjananya Nayamilu ngamurringkulalpi watjarnu, “Wiya, tjapilku-kurlu-rniyan Nayaminya. Yini palunyanya-ya wanti. Tjiinya-rna ngayulu pukurlpa wiya. Tjapinma-rniya Maaranya, tjiinyamarntu-rna tjirturu-tjirturu purlkanya pitjangu. Tjiinya-rni Mama Kuurrtu Yayirninytjulu Palyalpayilu tjuni kartarntanu wantingu. ");
INSERT INTO ntj_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Tjiinya-rna ngurra ngaanya yulytja pirnitjarralu wantirra kutipitjangu. Nyangka-rni kuwarrinya Mama Kuurrtu yulytjamaralpa marlakulu katingu. Nyangka nyaaku-rniyan tirtu tjapira Nayaminya? Tjiinya-rni Mama Kuurrtu Yayirninytjulu Palyalpayilu tjuni kartarntanu wantingu. Nyangka-rna ngaanya tjirturu-tjirturu purlkanya nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nyangka tjiinya-pula Nayaminya mingkayirra Mawapalanguru pitjangu Pitjiliyamala tjarrpangu nyinarranytja, tjiinya palunyatjarra-ya mirrka paali katapungkula yurraranytja. ");
INSERT INTO ntj_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","3","Nyangka Rutjalu Nayaminya tjapirnu, “Kurntili, palya-munta-rna yanku mirrka paali yurrara katiku, nyarra katapungkula-ya yurraranyangka? Tjinguru kutjupalu-rni wuyurrarringkulalpi watjalku palya-rna mantangkatja yurraratjaku, tjiinya kurranyulu-ya katapungkula punkatjingaranyangka ngarrirra-wanarayirni.” Nyangka Nayamilu watjarnu, “Yuwa, mapitja-tjananya lurrtjurriwa.” Nyangka mularrpartu Rutjalu yiwarla wantirra mapitjangu mirrka yurraranytjalakutu. Palunyalu nyangu-tjananya mirrka-ya katapungkula yurraranyangka. Palunyalu lurrtjurringkulalpi-tjananya mirrka mantangkatja marlawanalu yurrara-wanarayintja punkarnu-punkarnu ngarrirranyangka. Nyangka kaatanpa palunyanya-ra wati yini Pawutjaku ngaralanytja. Tjiinya wati palunyanya Nayamiku kurri Limalikaku yungarra, tjiinya yulytja pirnitjarra nyinarranytja. Nyangka-ya pirnilu kulilpayi watjaranyangka-tjananya. Nyangka Rutjanya ngurrpartu pitjangu palunyaku kaatanpangka tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Nyangka wati palunyanya yiwarla Pitjiliyamalanguru pakara pitjangu-tjananya nyakulalpi watjarnu, “Yuwa, Mama Kuurrtu-tjananyanta miranykanyira kanyinma.” Nyangka-ya ngaparrtjika watjarnu, “Yuwa, nyuntunyatarrartunta Mama Kuurrtu walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Nyangka Pawutjalu waarka palyalpayi pirniku puurrpa tjapirnu, “Kungka nyarranya ngananya?” ");
INSERT INTO ntj_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Nyangka watjarnu, “Ngurrpa. Kungka maliki, Mawapalanguru Nayamila pitjanytja. ");
INSERT INTO ntj_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Palunyalu-rni pitjangu munga-mungangkalpi tjapirnu, ‘Palya-munta-rna mirrka marlawanalu ma-yurrarayinma katapungkula-ya yurraranyangka?’ Nyangka-rna palyarnmanu. Nyangka yurrarayirnu-yurrarayirnu kuwarrikutju wiltjangka nyinakatingu.” ");
INSERT INTO ntj_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Nyangka Pawutjalu kuliralpi parrapitjangu Rutjala watjarnu, “Palya-muntan kulilku watjannyangka-rnanta? Kaatanpa kutjupakutu yankutjamaaltu ngaangkartu nyinarra mirrka yurranma. Kungka pirni wanaranytjalu yurranma nyarra watilu-ya kurranyulu katapungkula tjunkula wantirranyangka. Tjiinya-tjananyarna wati pirninya watjarnu pampuntjamaaltunta-ya wantitjaku. Nyangka-tjingurun kapitjirratjarringkulalpi palya tjikilku nyarra tjutirnu-tjutirnu-ya tjunu wantinytjanya.” ");
INSERT INTO ntj_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Nyangka Rutjalu kuliralpi pupakatingu. Palunyalu watjarnu, “Wiya, nyaaku-rnin walykumunura watjara? Ngayulu-rna maliki.” ");
INSERT INTO ntj_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Nyangka Pawutjalu watjarnu, “Wiya, pirnilu-rniya watjarnu tjiinyankun kurntili walykumunura kanyiranyangka. Tjiinya nyuntulun kutjurringkulalpi kurntili walykumunura kanyiranytja. Palunyalunkun mama ngunytju, ngurra yungarratarrartu wantirra pitjangu ngurra ngaangka malikingka nyinarra. ");
INSERT INTO ntj_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Yuwa, Mama Kuurrtunta ngaparrtjika walykumunura kanyinma. Tjiinyan Mama Kuurrtakutu pitjangu miranykanyiranta kanyiratjaku. Tjiinya-latju Yitjurayilku tjamupirtilu pupakatirra marninypungkupayi, palunyalakutun pitjangu. Nyangkanta walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Nyangka Rutjalu watjarnu, “Yuwa Puurr, walykumunulu-rnin ngarltunytjulu watjarnu pukurlmanu. Tjiinya-rna maliki ngurra ngaangka pitjangu nyinarra. Nyangka-rnin walykumunulu watjarnu nyuntuku waarka palyalpayipirinypangka.” ");
INSERT INTO ntj_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nyangka-pula wangkangu wiyarringu. Nyangka karlarlarrinyangka-ya pitjangu kapurturringkulalpi nyinakatingu mirrka ngalkukitja. Nyangka Pawutjalu Rutjanya yarltirralpi watjarnu, “Mirrkaku pitja. Palunyalu nyuma ngaanya tjalatjuralpi ngala.” Nyangka mularrpartu pitjangu nyinakatingu mirrka ngalkulanytja. Nyangka wati palunyalu puru mirrka yurninypa paantjatjanulu-ra nintirnu. Nyangka ngalangu nungkurringkulalpi kutjupatjarranya ngulaku tjunu wantingu. ");
INSERT INTO ntj_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Nyangka Rutjalu mapitjangu mirrka yurraranyangka Pawutjalu kampangkartu palyalpayi pirningka watjarnu, “Mirrka-yan katapungkula karrpilkitjalu kutjupatjarranya punkatjinganma tjiinya kungka palunyalu yurraratjaku. Nyangka ngamurrinyangka payira marrkuntjamaaltu wantima. Nyangkayi palyartu yurranma.” ");
INSERT INTO ntj_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Nyangka Rutjalu mirrka yurrarayirnu mungarrtjirringu. Palunyalu katingu pungkula pata-pataranytja. Nyangka mirrka purlkanya ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Nyangka mantjira katingu ngurrangka tjunu. Nyangka palunyaku mingkayilu nyangu. Nyangka-ra nintirnu mirrka yurninypa Pawutjalu karlarlalpi-ra nintirnu wantitjanya. ");
INSERT INTO ntj_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nyangka Nayamilu tjapirnu, “Wanytjangkatjan mirrka ngaanya yurraranytja? Nganaku kaatanpangkan yurraranytja? Wiya, Mama Kuurrtu-lu wati nyarranya walykumunura kanyinma. Tjiinyamarntunta walykumunulu kanyiranytja.” Nyangka Rutjalu watjarnu, “Wati palunyaku-ra yini Pawutjanya. Palunyaku kaatanpangka-rna parrayurraranytja.” ");
INSERT INTO ntj_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nyangka Nayamilu watjarnu, “Munta! Wati palunyanya ngayuku kurriku yungarra. Nyangka Mama Kuurrtu-lu walykumunura kanyinma. Tjiinya-limpa kurri kutjarranyartu wiyarringu. Nyangka Mama Kuurrtu-pulanya watatjarrinytjamaaltu tirtu kulira wiyarrinyangka-pula. Palunyalu-linyanta wanakaarla kutjarra tirtu walykumunura kanyira. Yuwa, wati nyarra Pawutjanya ngayuku kurriku yungarra. Nyangka palunyaku-ra ngarala tjiinya-linya miranykanyira kanyiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Nyangka Rutjalu watjarnu, “Wiya, wati palunyalu-rni watjaranytja palunyaku waarka palyalpayi pirningka-rna lurrtjurringkula mirrka yurraratjaku. Puru-rni watjarnu, ‘Mirrkanku palya ngaangkartu yurrarayila nyangkayi mirrka ngaralayila wiyarriwa.’” ");
INSERT INTO ntj_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nyangka Nayamilu watjarnu, “Yuwa, palyan minyma pirningka parrayurranma Pawutjaku kaatanpangka, watilunta-ya pampultjakutarra kaatanpa kutjupangkan yurraranyangka.” ");
INSERT INTO ntj_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Nyangka mularrpartu Rutjalu mirrka paali yurrarayirnu Pawutjaku waarka palyalpayi pirningka nyangka mirrka palunyanya ngaralayirnu wiyarringu. Palunyangka mirrka wiirpalpi yurrarayirnu nyangka ngaralayirnu wiyarringu. Nyangka tirtu mingkayingkartu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Nyinarrayirnu-pula nyangka Nayamilu Rutjala watjarnu, “Kulila. Palya-munta-rnanku kurri ngurrkarntanku? Nyangkanta yarltiku kanyinma. Nyangka-pulan kurrirarra pukurlpa nyinama. ");
INSERT INTO ntj_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kulila. Wati nyarra Pawutjanya, tjiinya palunyaku minyma palyalpayi pirningkan lurrtjurringkula mirrka yurralpayi, palunyanya ngayuku kurriku yungarra nyinarra. Tjiinya mungangka wati palunyalu waarka palyalku yurninypa yararrapungkupayila. Tjiinya-ya yurninypa warnipayi pirriyalu yulypu katitjaku. Nyangka yurninypakutju punkalku ngarrima. Palunyangka wati palunyalu waarka palyalku. ");
INSERT INTO ntj_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Nyangka-tjingurunkun parltjilku. Palunyalunkun parnti walykumunungka nyirtilku. Palunyalun turirrpa walykumunu tjarrpatjunku. Palunyalun mapitjaku yurninypa palyaranytjalakutu. Palunyalun kumpilku nyinama. Nyangka wati palunyanya mirrka ngalkulalpi parltjarriku. ");
INSERT INTO ntj_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Nyangka nyawa wati palunyanyayi pakara watipitja warntu pataralpi kunkunpa ngarrima. Nyangkan nyaku tjukarurruralpi watipitja wati palunyaku warntungka wirlkaralpi tjarrpa tjinawana ngarrikati ngarrima. Nyangkanta wankarringkulalpi nyaku kulilku, ‘Munta, minyma ngaanya-tjinguru pitjangu tjapilkitja ngayulu-rnalu kurri yarltitjaku.’ Nyangkanta watjalku kutjupa-kutjupa palyaltjaku.” ");
INSERT INTO ntj_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Nyangka Rutjalu watjarnu, “Yuwa kurntili, palyalku-rna nyuntulu-rnin watjannyangka.” ");
INSERT INTO ntj_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Nyangka Rutjanya mularrpartu pakara kutipitjangu mirrka yurninypa palyaranytjalakutu. Palunyalu kumpilpa nyinakatingu palunyaku kurntililu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Nyangka Pawutjalu ngalangu parltjarringkulalpi pukurlpa nyinarranytja. Palunyatjanu watipitjangu warntu pataralpi mirrka yurninytja yitingka kunkunarringu. Nyangka Rutjanya pakara panyka-panykaralpi parrapitjangu palunyaku tjinakutu. Palunyalu warntu wirlkaralpi tjarrpangu ngarrirranytja. Tjiinya tjinawana watingarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Nyangka wati palunyanya kunkunpa purlkanya tirtu ngarrirranytja. Palunyalu munga kultungka parrayurrirralpi tjulurraarnu nyangu, “Minyma ngananyanyka ngaanya ngarrirra ngayula tjinangka tjarrparralpi?” ");
INSERT INTO ntj_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Palunyalu tjapirnu, “Ngananyan?” Nyangka Rutjalu watjarnu, “Wiya puurr, ngayulu-rna Rutjanya ngarrirra. Tjiinya nyuntulun Nayamiku kurriku yungarra. Palya-munta-rnin yarltiku kanyinma?” ");
INSERT INTO ntj_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Nyangka-lu watjarnu, “Wiya, Mama Kuurrtunta walykumunura kanyinma. Tjiinyamarntun nyuntuku kurntili Nayaminya walykumunura kanyiranytja. Palunyalun tjurrkurltu kulira Tjitjururrulunta yarltitjaku. Tjiinya wati yangupala pirni-ya nyinarra, kutjupatjarranya-ya tjimarri purlkanyatjarra puru kutjupatjarranya-ya tjimarri wiya. Nyangka-tjananyan wantirralpi ngayunya-rnin tjurrkurlturtu ngurrkarntanu. ");
INSERT INTO ntj_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Wiya, raparriwa. Nyuntuku wangka-rna kulira. Yarnangu pirnilunta-ya nintilu kulira tjiinyan minyma walykumunu. ");
INSERT INTO ntj_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Yuwa, mularrpa-rna Nayamiku kurriku yungarra nyinarra. Tjinguru-rnanta ngayulu yarltiku miranykanyinma. Wiya-tjingurunta kutjupalu yarltiku. Tjiinya kurta tirnalu-tjingurunta yarltiku. Tjiinyamarntu-rna ngayulu marlangkatja. ");
INSERT INTO ntj_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","14","Yuwa palya. Palangkartu ngarri tjirnturriwa. Nyangka-rna tjirntungka yanku tjapilku ngayuku kurtalunta yarltitjaku. Nyangka-tjingurunta palya yarltiku. Wiyangka ngayulu-rnanta yarltiku kanyinma. Tjiinya ngayulu-rnanta Mama Kuurrta mirangka tjurrkurltu watjara. Yuwa, palangka tjinawana ngarrima. Palunyalu tjirntukutu pakara ngurrakutu yarra nyakutjakutarranta-ya.” Nyangka mularrpartu Rutjanya tjinawana ngarringu, palunyalu tjirntukutu pakarnu ngaralanytja ngurrakutu yankukitja. ");
INSERT INTO ntj_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Nyangka Pawutjalu watjarnu, “Kawutu palanya yarraralpi patala mantangka.” Nyangka mularrpartu kawutu yarraralpi patarnu. Nyangka-ra wati palunyalu mirrka yurninypa purlkanya kawutungka tjutirnu. Palunyalu karrpiralpi tjarlitjunu. Nyangka ngurraku yanu. ");
INSERT INTO ntj_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Parrapitjangu yiwarlangka tjarrpanyangka palunyaku kurntililu tjapirnu, “Yuwa, palunya?” Nyangka-lu Rutjalu tjukurrpa tjakultjunu Pawutjalu watjantjanya. ");
INSERT INTO ntj_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Palunyalu watjarnu, “Nyawa mirrka ngaanya purlkanya. Tjiinya-rni nintiralpi watjarnu, ‘Ngaanyanku makati. Kamun maralpa yanku kurntilikutu.’” ");
INSERT INTO ntj_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nyangka Nayamilu watjarnu, “Yuwa, nyinarra kulinma. Pawutjanya kuwarrinya yanku palunyaku kurtangka tjapilkitja.” ");
INSERT INTO ntj_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Nyangka Pawutjanya mapitjangu ngarnmanyarringu nyinarranytja nyarra yiwarla kayirrta-ya lurrtjurringkula mirtingi wangkapayila. Palunyalu nyinangu nyangu palunyaku kurta watipitjalayinnyangka yarltirralpi watjarnu, “Pitja ngaanguru nyinakatirralpi kulila.” Nyangka mularrpartu pitjangu nyinakatingu. ");
INSERT INTO ntj_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Nyangka-tjananya Pawutjalu wati puurrpa 10-pa yarltirralpi watjarnu, “Pitja-ya ngamu nyinakati.” Nyangka-ya mularrpartu pitjangu nyinakatingu kulilkitja. ");
INSERT INTO ntj_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Nyangka Pawutjalu palunyaku kurtangka watjarnu, “Yuwa Kurta, kulirnu-muntan Nayaminya ngurra nyarra Mawapalanguru marlaku pitjanyangka? Tjiinya minyma palunyalu kutjurringkulalpi kulira palunyaku kurriku manta nintilkitjalu. Tjiinya wati palunyanya ngayuku-limpa yungarra nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Nyangka-rnanta tjakultjura kuliltjakun. Ngaanya-tjingurun kulilku manta palunyanya payipungkukitjalu. Tjingurun palya ma-payipungku pirningka mirangka. Palya-tjingurun wantiku. Palunyalu-rni watjala. Tjiinya ngarala nyuntulun payipungkutjaku. Tjiinyamarntun kurranyungkatja. Nyangka-rna ngayulu marlangkatja.” Nyangka kuliralpi watjarnu, “Palya-rna payipungku.” ");
INSERT INTO ntj_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Nyangka Pawutjalu watjarnu, “Yuwa, manta mantjilkitjalu tjimarri Nayamiku nintila. Palunyalun Rutjanya Mawapanyamartatji yarltiku kanyinma. Tjiinya minyma palunyanya kutjurringu nyinarra. Nyangka ngula Rutjalu katja kanyiranyangka purlkarringkulalpi manta palunyanya kanyinma. Nyangka-ya pirnilu watjanma Rutjaku kurri ngarnmanytjatjaku manta.” ");
INSERT INTO ntj_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Nyangka wati palunyalu kuliralpi watjarnu, “Munta yuwa. Palya. Wantiku-tjinguru-rna manta palunyanya. Tjiinya-ya ngayuku tjilkulu kanyilkitjamunu. Yuwa, nyuntulu payipuwa kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Nyangka wati palunyalu watjarnu wantirralpi tjinangkatja kutju yarraralpi Pawutjaku-ra nintirnu. Palunyalu watjarnu, “Palyan manta mantjilku.” Tjiinya kutjulpirtu-ya Yitjurayilku tjamupirtilu palunyapirinypa palyalpayi. Tjiinya-ya manta nintilkitjalu wangkarra palyarnmaralpi tjinangkatja yarrara nintilpayi. ");
INSERT INTO ntj_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Nyangka-tjananya Pawutjalu puurrpa pirningka puru yarnangu pirningka watjarnu, “Yuwa, nyakula-yan tjiinya-rna kuwarrinya manta mantjirnu Nayamila. Tjiinya-yan kulira manta palunyanya wati yini Limalikaku puru palunyaku katja kutjarraku-pulampa Kiliyanku puru Maalanku ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Puru-rna minyma Rutjanya Mawapanyamartatji yarltiku kanyinma, tjiinya Maalanku kurri kutjurringkulalpi nyinarra. Nyangka ngula-litju tjilku kanyiranyangka pirnilu-ya watjanma Maalanku tjilku. Nyangka-ya ngurra ngaangkatjalu wati palunyanya watatjarrinytjamaaltu tirtu kulinma. Yuwa, nyuntula mirangka-tjananyarnanta watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Nyangka-ya puurrpa pirnilu puru yarnangu pirnilu watjarnu, “Yuwa, walykumunu-latju kulirnu. Nyangka Mama Kuurrtu nyuntuku kurri Rutjanya walykumunura kanyinma nyangkayi tjilku pirni kanyinma. Tjiinya Tjayikapaku kurri Rayirrtjultu-pula Liyalu tjilku pirni kanyirnu, palunyapirinypa. Puru Mama Kuurrtunta kanyinma yulytja pirnitjarra puru tjimarri purlkanyatjarran nyinarratjaku. Nyangkanta-ya Pitjiliyamala nyinapayi pirnilu nyakula marninypungama. ");
INSERT INTO ntj_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Nyangka-pulampanku tjilku pirnirriwa, tjiinya Tjuutaku-pulampa Tayimaku katja yini Pirinytju tjilku pirni kanyirnu, palunyapirinypa.” ");
INSERT INTO ntj_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Nyangka mularrpartu Pawutjalu Rutjanya yarltingu kanyiranytja. Nyangka Mama Kuurrtu minyma palunyanya walykumunura kanyiranytja. Nyangka mukalarringkulalpi tjilku katja kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Nyangka-ya minyma pirnilu palunyaku kaparli Nayamila watjarnu, “Yuwa, Mama Kuurrnga-la marninypuwa. Tjiinyanku tjamu nintirnu. Nyangkantayi ngula purlkarringkulalpi miranykanyira kanyinma. Nyangka-ya Yitjurayilku tjamupirtilu nyakula watjara marninypungama. ");
INSERT INTO ntj_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Tjiinyanta nyuntuku tjamulu tirtu pukurlmara kanyinma pamparringkulalpin nyinarranyangka. Yuwa, nyuntuku mingkayilunta rawalu mukulyanytjulu kanyiranytja. Tjiinyakurlu-yanku katja pirnilu ngunytju miranykanyira kanyinma, palunyangka munkarra nyuntuku mingkayilunta kanyiranytja. Palunyalu nyuntuku tjamu kanyirnu.” ");
INSERT INTO ntj_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nyangka kaparlilu pukurltu tjilku tjamu yampurnu kanyiranytja. Palunyalu miranykanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Nyangka-ya minyma pirni nyarra ngurrangka ngamu nyinapayilu tjilku palunyanya yini tjapirnu Yawupinya. Palunyalu-ya yarnangu pirningka pukurltu parrawatjaranytja, “Nayaminya tjamutjarrarringu.” Nyangka Yawupinya nyinarrayirnu purlkarringkulalpi yutirnu katja yini Tjatjinya. Nyangka Tjatjilu yutirnu katja yini Tayipirrnga. ");
INSERT INTO ntj_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Tjiinya wati yini Pirinynga Tjayikapaku tjamu nyinarranytja. Nyangka Pirinyku tjamupirti-ya ngaapirinypa nyinarra-wanarnu. Tjiinya Pirinytju yartakanu katja yini Yitjurannga. ");
INSERT INTO ntj_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Nyangka Yitjurantu yartakanu katja yini Raamanya. Nyangka Raamalu yartakanu katja yini Minatapinya. ");
INSERT INTO ntj_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Nyangka Minatapilu yartakanu katja yini Naatjannga. Nyangka Naatjantu yartakanu katja yini Tjamannga. ");
INSERT INTO ntj_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Nyangka Tjamantu yartakanu katja yini Pawutjanya. Nyangka Pawutjalu yartakanu katja yini Yawupinya. ");
INSERT INTO ntj_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Nyangka Yawupilu yartakanu katja yini Tjatjinya. Nyangka Tjatjilu yartakanu katja yini Tayipirrnga. Tjiinya Tayipirrnga Yitjurayilku tjamupirtiku puurrpa purlkanya nyinarranytja. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("S11_1","010_1_1","1SA","1","1","2","Nyangka Yitjurayilku tjamupirti-ya rawa nyinarranytja ngurra yini Kayinanta, tjiinya ngurra kalkurnu wantitjala. Nyangka wati ngaanya kurri kutjarratjarra nyinarranytja. Nyangka kurri kurranyungkatja yini Yananya tjilkumaalpa nyinarranytja. Nyangka palunyaku nganartilu tjilku pirni kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S11_3","010_1_3","1SA","1","3","8","Palunyalu karnany-karnanytju Yananya kutjupa-kutjupa watjara tjurlpilymaranytja. Nyangka tjirturu-tjirturu purlkanya nyinarranytja. Nyangka-ya kurli kutjupa kurli mapitjala ngurra kutjupangka Mama Kuurrnga pupakatirra marninypungkupayi. Tjiinya-ya yankula tiinti miirl-miirlta kuka Mama Kuurrku nintilpayi. Nyangka kurli kutjupangka-ya pakara mapitjalayirnu ngurra palunyakutu parrapitjangu. Palunyalu-ya lurrtjurringkulalpi kuka kutjupatjarra nintirnu Mama Kuurrku. Palunyalu-yanku kuka kutjupatjarra kanyira yurirlta ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S11_9","010_1_9","1SA","1","9","11","Nyangkanku Yananya pakara mapitjangu tiinti miirl-miirlpangka tjarrpangu. Palunyalunku nyinarranytjalu Mama Kuurrnga yularra tjapiranytja tjilku-ra nintiltjaku. Tjiinya kurrurntutarrartu ngaapirinypa tjapiranytja, “Wiya, tjilkumaalpa-rna nyinarra purtu kulira. Tjinguru-tjun ngarlturringkulalpi katja nintilku. Nyangka-rnanku ngaparrtjika nintilku nyuntuku waarka palyaratjaku.” ");
INSERT INTO ntj_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","Nyangka tjiinya Yanalu tjaalymara tjapiranytja nyangka munikutju yurrirranytja. Nyangka wati nyarra tiinti miirl-miirlta waarka palyalpayi yini Yiilayilu ngalyanyinarra nyakulanytja munikutju yurrirranyangka. Palunyalu kulirnu kakiri nyinarra wangkarranytja. Palunyakukantjalu ");
INSERT INTO ntj_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","watjarnu, “Kakiri-muntan nyinarra? Wiya, wayinpa tjikintjamaalpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Nyangka Yanalu watjarnu, “Wiya, kakiri wiya-rna nyinarra. Tjikiranytjamunu-rna. Tjiinya-rna purtu kulira. Palunyalu-rna tjakultjura Mama Kuurrtu-rni kuliltjaku. ");
INSERT INTO ntj_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Tjirturu-tjirturu purlkanyalu-rna Mama Kuurrnga tjapira.” ");
INSERT INTO ntj_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Nyangka Yiilayilu watjarnu-lu, “Yuwa, Mama Kuurrtunta kulira tjapiranyangka. Nyangka mapitja pukurlpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("S11_18","010_1_18","1SA","1","18","19","Nyangka Yananya mapitjangu pukurltu-tjananya lurrtjurringu kuka nyinarra ngalkulanytja. Nyangka-ya ngarringu tjirnturringkulalpi pakara marlaku kutipitjangu ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Palunyatjanu-ya nyinarrayirnu, nyangka Yanalu tjilku katja kanyirnu Mama Kuurrtu-lu yirringkankunyangka. Palunyalu yini Tjamiyulnga tjapirnu tjiinyamarntu Mama Kuurrnga tjapintjatjanulunku. ");
INSERT INTO ntj_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Nyangka tjilku palunyanya nyinarrayirnu purlka-purlkarringkulalpi tjina parrakukurraara ngarlpurringkulanytja. Nyangka tjilku palunyaku mama ngunytju-ya pururtu pakara yanu Mama Kuurrku tiinti miirl-miirlta lurrtjurringkula nyinakitja. Pitjalayirnu-ya parrapitjangu, nyangka Yanalunku katja makatingu Yiilayila nintitjunu. ");
INSERT INTO ntj_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Palunyalu watjarnu, “Yuwa puurr, yiiku-munta-rnin ngayunya nyakula? Tjiinya-rnin ngaangkalpi nyangu nyinarra-rna Mama Kuurrta tjapiranyangka. Minyma palunyanyartu-rna. ");
INSERT INTO ntj_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Yuwa, tjiinya-rna tjilku ngaaku ngatjiranytja. Nyangka-tju mularrpartu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Nyangka-rnara ngaparrtjika ma-nintilku Mama Kuurrku. Nyangka-ra nyinarra waarka palyanma.” ");
INSERT INTO ntj_vpl VALUES ("S12_11","010_2_11","1SA","2","11","18","Nyangka tjilku Tjamiyulnga ngurra palunyangkartu tirtu nyinarranytja yirna nyarra Yiilayila. Nyangka nyinarra nintipungkulanytja Tjamiyultu tiinti miirl-miirlta waarka palyaratjaku. Nyangka mularrpartu Mama Kuurrku waarka walykumunulu palyaranytja. Nyangka tjiinya Yiilayilu katja kutjarra kanyiranytja. Nyangka-pula palunyalutarrartu tiinti miirl-miirlta tjarrparra palyalpayi. Palunyalu-pula palyamunu palyaranytja Mama Kuurrta mirangka. Tjiinya yarnangulu-yanku kuka katirra Mama Kuurrku nintiranyangka tjalkirr-tjalkirrtu-pula mantjira ngalkupayi. ");
INSERT INTO ntj_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Nyangka kurli kutjupa kurli palunyaku ngunytjulu kawutu wirrmira wakara katirra nintilpayi, tjiinya-ya tiinti miirl-miirlkutu pitjalanytjalu. ");
INSERT INTO ntj_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Nyangka Yiilayilu-pulanya Tjamiyulku mama ngunytjungka watjalpayi, “Yuwa, Mama Kuurrtu-pulanyanta walykumunura tirtu kanyinma. Nyangka-pulayin tjilku kutjupa puru kanyila. Tjiinya Yanalunku tjilku nintirnu Mama Kuurrku, palunyanguru-pulampanku tjilku kutjupa nintilku.” Nyangka-pula kulira ngurrakutu kutipitjapayi. ");
INSERT INTO ntj_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Nyangka mularrpartu Yanalunku tjilku pirni kanyirnu, katja marnkurrpa puru yurntalpa kutjarra. Nyangka Tjamiyulnga nyinarrayirnu tiinti miirl-miirlta purlkarringu. Nyangka Mama Kuurrtu nyangu pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Nyangka Yiilayinya wati yirnarringu. Palunyalu kuliranytja palunyaku katjalu-pula palyamunu palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Palunyalulta-pulanya watjarnu, “Wiya, yarnangu pirnilu-rniya pitjala watjaranytja tjiinya-pulanyun palyamunu palyaranytja. Nyaaku-pulan palyamunu palyara? ");
INSERT INTO ntj_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Kulila-pula. Tjinguru-rna yarnangu kutjupangka palyamunu palyaranyangka Mama Kuurrnga-tju ngarlturringku. Nyangka-tjinguru-rna Mama Kuurrta palyamunu palyaranyangka-rni kutjupalu purtu yirringkanku.” Nyangka-pula mamaku wangka kulirnu wantingu. Tjiinyamarntu Mama Kuurrtu-pulanya wartalpitjanu kulirnu pungkula mirrirntankukitjalu. ");
INSERT INTO ntj_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Nyangka tjilku palunyalu Mama Kuurrku tiinti miirl-miirlta tirtu waarka palyaranytja. Tjiinya Yiilayinya yirringkankupayi kuru pawulypa nyinarranyangka. Tjiinya palunyatjarralpi Mama Kuurrnga-tjananya ngamurtu-ngamurtu wangkarranytjamunu. Puru-ya tjukurrpa Mama Kuurrngatjarra ngarrirra nyakulanytjamunu. ");
INSERT INTO ntj_vpl VALUES ("S13_2","010_3_2","1SA","3","2","4","Nyangka mungangka Yiilayinya ruumpa yungarrangka ngarrirranytja. Nyangka Tjamiyulnga kutju ngarrirranytja tiinti miirl-miirlta kaninytjarra. Palunyalunku kulirnu yini tjapiranyangka, “Tjamiyul.” ");
INSERT INTO ntj_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Nyangka pakara kukurraarnu Yiilayinya tjapirnu, “Nyaaku-rnin tjapirnu?” Nyangka watjarnu, “Ngurrpa-rnatju nyuntunya tjapintjamunurtu. Mapitja kunkunarri.” ");
INSERT INTO ntj_vpl VALUES ("S13_6","010_3_6","1SA","3","6","7","Nyangka ngarringu puru kulirnu tjapiranyangka. Tjiinya Tjamiyultu kulintjamunu Mama Kuurrnga-lu wangkarranyangka. Tjiinya-lu Mama Kuurrnga kutjuwarra wangkarra wantirranytjamunu. Nyangka kulira puru pakara kukurraarnu Yiilayinya tjapirnu, “Yuwa, nyaaku-rnin puru tjapirnu?” Nyangka Yiilayilu puru watjarnu, “Wiya, mapitja kunkunarri. Ngayulu-rnanta tjapintjamunurtu.” ");
INSERT INTO ntj_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Nyangka mapitjangu ngarringu kulirnu puru tjapiranyangka. Palunyalu puru pakara kukurraarnu Yiilayinya tjapirnu, “Yuwa, nyaaku-rnin tjapirnu?” Nyangkalta pina taparlarraralpi kulirnu, “Munta! Mama Kuurrtu-lu tjilku ngaanya tjapira.” ");
INSERT INTO ntj_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Nyangka Yiilayilu Tjamiyulta watjarnu, “Wiya, mapitja ngarrikatirralpi kulila. Nyangka purunta yini tjapinnyangka ngaapirinypa watjala, ‘Yuwa Mama, kulira-rnanta.’” Nyangka Tjamiyulnga mularrpartu mapitjangu marlaku ngarrikatingu. ");
INSERT INTO ntj_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Nyangka Mama Kuurrnga pitjangu puru palunyapirinypartu tjapirnu. Nyangka kuliralpi watjarnu, “Yuwa Mama, kulira-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Nyangka Mama Kuurrtu-lu watjarnu, “Kulila. Kuwarri-kuwarri-rna ngayulu palyamunu purlkanya yutilku. Nyangka-ya Yitjurayilku tjamupirtilu kuliralpi kata paarnarralku. ");
INSERT INTO ntj_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Tjiinya-rna kalkurnu palyamunu purlkanya yutilkitjalu Yiilayiku yungarrapirtiku. Tjukarurrulu-rna watjara palyamunu purlkanya-tjanampa yutilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Tjiinya Yiilayiku katja kutjarra-pularni ngayula rawalu tungunpungkupayi. Nyangka Yiilayilu-pulanya marrkuranytjamunu. Tjiinya-rnalu ngurlutjunu wantingu. Nyangka-pulanya marrkuranytjamunu. Nyangka mularrpa-tjanamparna Yiilayiku yungarrapirtiku palyamunu purlkanya yutilku. ");
INSERT INTO ntj_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Nyangka kutjupalu-rniya kuka pungkula tilira tjunkula nintiranytjalu purtu kalyparntanku wantiku. Tirtu-tjanamparna mirrparnpa nyinama.” Nyangka Tjamiyulnga kuliralpi marlaku ngarrikatingu. ");
INSERT INTO ntj_vpl VALUES ("S13_15","010_3_15","1SA","3","15","18","Palunyalu ngarringu tjirnturringkulalpi mapitjangu Yiilayila tjakultjunu nyarra Mama Kuurrta kulintjatjanulu. Nyangka watjarnu, “Yuwa palya. Mama Kuurrtu, Puurrpa Purlkanyalu yungarralu kulira palyalpayi. Nyangka palya palunyapirinypa yutirriku.” ");
INSERT INTO ntj_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Nyangka Tjamiyulnga ma-purlkarringkulayintja. Nyangka Mama Kuurrtu-lu tirtu yirringkaranytja. Palunyalu-lu tirtu wangkarranytja. Nyangka Tjamiyultu yarnangu pirningka tjakultjunkunyangka wangka palunyanya tirtu yutirringkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Nyangka Yitjurayilku tjamupirtilu-ya ngurra lipingkatjalurtu nintilu kuliranytja tjiinya Tjamiyultu Mama Kuurrku wangka kulira tjurrkurltu tjakultjuranyangka. ");
INSERT INTO ntj_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Nyangka Mama Kuurrnga Tjamiyulta tirtu yutirringkula wangkarranytja. Nyangka Tjamiyultu Yitjurayilku tjamupirtingka wangkarranyangka-ya pina yarlalu kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("S14_1","010_4_1","1SA","4","1","2","Nyangka-ya Yitjurayilku tjamupirti warrmarlarringkula yanu wati Pilitjinyamartatji-tjananya pika wakalkitja. Pitjangu-ya ngurra tjunu nyinarranytja. Nyangka-ya Pilitjinyamartatji wati pirni warrmarlara pitjangu ngurra ngamutja tjunu nyinarranytja. Palunyalu-ya ngarringu tjirnturringkulalpi pakara pitjangu wakalkitja. Palunyalu-yanku pika purlkanya wakaranytja. Nyangka-ya warrmarla Pilitjinyamartatji winarringkulalpi-tjananyaya Yitjurayilku tjamupirti kutjarramunu wakara mirrirntarayirnu wantingu. Tjiinya-ya 4,000-pa wakarnu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Nyangka-ya kutjupatjarranya wankarringkula marlaku kukurraarnu ngurra nyarra ngarringu wantitjalakutu. Nyangka-ya liita pirnilu wangkarra kuliranytjalu watjarnu, “Nyaatjanulu-lanya Mama Kuurrtu wantingu nyangka-ya Pilitjinyamartatji winarringu? Wiya, kulila. Tjinguru-lan Mama Kuurrku puuka miirl-miirlpa mantjira katima. Witula-lanku mantjira katitjaku. Palunyalu-la kati nyarra pika pungkupayilakutu. Nyangka-lanya Mama Kuurrtu kanyilku tjiinya-lanya wakalku mirrirntankutjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Nyangka-ya mularrpartu witurnu mantjira katitjaku. Nyangka Yiilayiku katjalu-pula puuka miirl-miirlpa mantjira makatingu warrmarla pirniku ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Nyangka-ya nyakulalpi pukurlpa mirrarranytja. ");
INSERT INTO ntj_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Nyangka-ya warrmarla Pilitjinyamartatjilu kulirnu mirrarranyangka. Palunyalu-ya watjarnu, “Nyaakunyka-ya mirrarra?” Nyangka-ya kulirnu ngurlurringu tjiinya-ya Mama Kuurrku puuka miirl-miirlpa kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("S14_7","010_4_7","1SA","4","7","8","Palunyalu-ya watjarnu, “Wiya, tjiinya-tjanampa tjukurrtatja pitjangu lurrtjurringu yirringkankukitja. Yaaltjinku-lanku? Wartalpitjanu. Kutjupalu-lanya wankalkitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Palunyalu-ya wantirralpi watjarnu, “Wiya, raparringkula-lanku pika wakanma puurrarringkula-lanya kanyiratjakutarra. Ngurlumaaltu-lanku pika wakala.” ");
INSERT INTO ntj_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Nyangka-ya mularrpartu raparringkulalpi-tjananya pika purlkanya wakara mirrirntaranytja. Tjiinya-ya Yitjurayilku tjamupirti warrmarla 30,000-pa-tjananya wakarnu mirrirntanu. Nyangka-ya kutjupatjarranya ngurlu kukurraaranytja ngurra yungarra-yungarrakutu. ");
INSERT INTO ntj_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Tjiinya-ya Pilitjinyamartatjilu Yiilayiku katja kutjarranyatarrartu wakarnu mirrirntanu. Puru-ya Mama Kuurrku puuka miirl-miirlnga mantjira katingu. ");
INSERT INTO ntj_vpl VALUES ("S14_12","010_4_12","1SA","4","12","13","Nyangka wati kutjulu-tjananya kukurraarnu milyarnpungkulanytja. Nyangka-ya mularrpartu pirninyartu yularranytja. ");
INSERT INTO ntj_vpl VALUES ("S14_14","010_4_14","1SA","4","14","16","Nyangka Yiilayilu kulirnu kawa-kawarringkulanyangka tjapirnu, “Nyaaku-ya kawa-kawarringkula?” Nyangka wati palunyalu parrapitjangu tjakultjunu, “Kulila. Pika-yanku purlkanya wakaranyangka wantirra-rna ngalyakukurraarnu.” Nyangka Yiilayilu tjapirnu, “Yuwa, nyaarringu-ya nyarratja?” ");
INSERT INTO ntj_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Nyangka watjarnu, “Wiya, Yitjurayilku tjamupirti-latjunku ngurlu kukurraarnu. Yuwa, mularrpa-latjunku ngarltutjarra. Tjiinyamarntu-lanyatjuya wakara-wanarnu wiyarnu. Puru kulila, nyuntulunkun purrkutjarrarringu. Nyangka-ya Mama Kuurrku puuka miirl-miirlnga mantjira katingu.” ");
INSERT INTO ntj_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Nyangka Yiilayinya nyinarranytjalu kuliralpi kankarra ma-punkarnu. Tjiinyamarntu yirna yarnangu purlkanya nyinarranytja. Palunyatjanu punkarnu ngurnti kartakatirralpi mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Nyangka Yiilayiku mingkayi tjaka-tjaka nyinarranytja riiti yirti kanyilkitja. Palunyalu kulirnu kutjurrinytjatjanulu waarrpungkulalpinku pika mirarnu. Nyangkalta-ra yirti ngarringu. ");
INSERT INTO ntj_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Nyangka yirti kanyiralpi mirrirrikitja riiti ngarrirranytja. Nyangka-ya minyma pirnilu yirringkaranytjalu-lu watjarnu, “Wiya, rapa nyinama. Katjankun kanyirnu.” Nyangka minyma palunyalu kulira pukurlarrinytjamaalpanku watatja ngarrirranytja. Tjiinya tjirturu-tjirturulu tirtu kuliranytja palunyaku kurri puru mingkayi wiyarringkunyangka. ");
INSERT INTO ntj_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Palunyalunku katja yini Yikaparrnga tjapirnu. Tjiinya yini Yikaparrnga ngaapirinypa, Tili wiyanya. ");
INSERT INTO ntj_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Nyangka minyma palunyalu watjarnu, “Wiya, Mama Kuurrtu-lanya wantirra yankunyangka tili mungarturringu. Tjiinyamarntu Pilitjinyamartatjilu-ya Mama Kuurrku puuka miirl-miirlnga mantjira katingu.” ");
INSERT INTO ntj_vpl VALUES ("S15_1","010_5_1","1SA","5","1","2","Nyangka-ya warrmarla Pilitjinyamartatjilu Mama Kuurrku puuka miirl-miirlpa tjarlira katingu ngurra yungarrakutu. Katingu-ya palunyaku-tjanampa tjurrtjungka tjarrpatjunu. Tjiinya tjurrtju palunyangka-ya purli purlkanya kanyiranytja. Tjiinya-ya purli palunyanya wati yarnangupirinymaralpi yini Tayikannga tjapirnu. Palunyalu-ya tjarrparra purli Tayikannga pupakatirra marninypungkupayi. Tjurrtju palunyangka-ya Mama Kuurrku puuka miirl-miirlpa katingu purli Tayikanta yitingka tjunu. ");
INSERT INTO ntj_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Nyangka-ya ngarringu tjirnturringkulalpi munga-mungangka tjarrpangu nyangu purli palunyanya punkarnu mantangka wartungaralanytja puuka miirl-miirlta yitingka. Nyangka-ya tjitiralpi marlakulu ngaratjunu. ");
INSERT INTO ntj_vpl VALUES ("S15_4","010_5_4","1SA","5","4","5","Palunyalu-ya ngarringu tjirnturringkulalpi puru pitjangu nyangu purli palunyanya pururtu punkarnu wartungaralanytja puuka miirl-miirlta yitingka. Tjiinya purli palunyaku kata puru mara kutjarranya kartakatirralpi punkarnu yiwarla tjaangka ngarrirranytja. Nyangka kultukutjurringu ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Palunyanguru Mama Kuurrtu-tjanampa pika purlkanya nintirnu. Nyangka yurnturrngu pirni-tjananya nyina-nyinakatingu. Nyangka-ya ngurlu-ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Palunyalu-ya watjarnu, “Wiya, tjinguru Mama Kuurrtu, nyarra Yitjurayilku tjamupirtilu-ya pupakatirra marninypungkupayilu pika ngaanya parlurnu. Puru-lampa purli Tayikanngatarrartu kartarntanu. Kulila-ya. Puuka miirl-miirlpa-la kanyiranytjamaaltu wanti. Marlakuralpi-lanku nintila.” ");
INSERT INTO ntj_vpl VALUES ("S16_1","010_6_1","1SA","6","1","12","Nyangka-ya mularrpartu pakarnu puuka miirl-miirlnga mantjiralpi marlakulu mawiyarnu Yitjurayilku tjamupirtiku ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("S16_13","010_6_13","1SA","6","13","18","Nyangka-ya nyangu waalkarrannyangka pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("S16_19","010_6_19","1SA","6","19","21","Nyangka-ya wati pirnilu pukurlarringkulalpi wirrtjarnu watarrkulu yarlaralpi nyangu. Nyangka-tjananya Mama Kuurrtu miirlarraralpi mirrirntanu. Tjiinyamarntu Mama Kuurrtu Mawutjala kutjulpirtulpi watjarnu wantingu wati Liipayiku tjamupirtilukutju-ya puuka miirl-miirlnga miranykanyira kanyiratjaku. Tjinguru palunyalukutju-ya kanyinma. Ngaanya-ya kutjupatjarralu watarrkulu yarlaralpi tjitjangu. ");
INSERT INTO ntj_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Nyangka-ya ngurra kutjupakutu mawiyarnu. Nyangka ngurra palunyanguru-ya wati kutju ngurrkarntanu tjunu puuka miirl-miirlnga miranykanyira kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("S17_2","010_7_2","1SA","7","2","4","Nyangka puuka miirl-miirlnga tirtu ngarrirranytja ngurra palunyangkartu. Nyangka yarnangu pirnilu-ya rawalu kuliranytja tjiinya-ya Mama Kuurrnga tjukarurrulu wanaranytjamunulu. Palunyalu-ya yularra Mama Kuurrnga tjapiranytja yirringkankutjaku warrmarla Pilitjinyamartatji pirningkatarra. Nyangka Tjamiyultu-tjananya watjarnu, “Mularrpa-munta-yan marlaku pinkurraaralpi Mama Kuurrngakutju wanalku? Wiya, yapu warta pupakatirra marninypungkupayinya-ya warni wantirralpi Mama Kuurrngakutju kulinma. Nyangka-tjananyanta wankarura kanyilku warrmarla Pilitjinyamartatji pirningkatarrartu.” Nyangka-ya mularrpartu yapu warta warningu wantirralpi Mama Kuurrngakutju pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S17_5","010_7_5","1SA","7","5","6","Nyangka Tjamiyultu-tjananya wati pirni witurnu, “Mapitja-ya ngurra pirniwanalu-tjananya watjala kapurturringkula ngurra kutjungka nyinatjaku. Nyangka-tjanamparnanku Mama Kuurrnga tjapilku.” Nyangka-ya mularrpartu kapurturringu ngurra palunyangka nyinarranytja. Palunyalu-ya mirrka ngalkulanytjamaalpa nyinarrayirnu mungarringu. Palunyalu-ya watjarnu yartakanu Mama Kuurrnga wantinytjatjanulu. ");
INSERT INTO ntj_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Nyangka-ya Pilitjinyamartatji pirnilu tjakulpa kulirnu tjiinya Yitjurayilku tjamupirti-ya ngurra palunyangka kapurturrinyangka. Nyangka-ya warrmarlara pitjangu-tjananya pika wakalkitja. Nyangka-ya Yitjurayilku tjamupirtilu kuliralpi ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Palunyalu-ya Tjamiyulnga watjarnu, “Mama Kuurrnga tirtu tjapinma. Nyangka-lanyayi yirringkala Pilitjinyamartatjilu-lanya pitjala wakara mirrirntankutjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Nyangka Tjamiyultu tjiipu warlangu pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu kurrurntutarrartu Mama Kuurrnga tjapiranytja kanyiltjaku-tjananya. Nyangka Mama Kuurrtu kulirnu. ");
INSERT INTO ntj_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Nyangka Tjamiyultu kuwarripa kuka tiliranyangka warrmarla Pilitjinyamartatji-ya ngalyangamurringu. Nyangka Mama Kuurrnga lingkirrpa wangkangu. Tjiinyakurlu kapi tutunma, palunyapirinypa. Nyangka-ya Pilitjinyamartatjilu kuliralpi kuwar-kuwararringkula kuku-kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Nyangka-ya Yitjurayilku tjamupirtilu-tjananya ngurlura wanarnu ngurra yungarrangkartu ma-tjarrpatjunu. Tjiinya-tjananyaya wakara mirrirntara wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("S17_12","010_7_12","1SA","7","12","14","Nyangka Tjamiyultu walu purlkanya mantjiralpi ngaratjunu. Palunyalu watjarnu, “Yapu ngaanya ngarala tjiinya-lan nyakula kuliratjaku tjiinya Mama Kuurrtu-lanya wantinytjamaaltu yirringkanu.” Nyangka-ya Pilitjinyamartatji warrmarlara pitjapayinya wiyarringu. Tjiinya Tjamiyulnga wanka nyinarranyangkalpi Mama Kuurrtu-tjananya marrkura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S17_15","010_7_15","1SA","7","15","17","Nyangka Tjamiyultu wanka nyinarranytjalulpi-tjananya Yitjurayilku tjamupirti pirninya miranykanyira kanyiranytja. Palunyalu kurli kutjupa kurli yankupayi ngurra kutjupa-kutjupakutu. Palunyalu-tjananya wangkarra tjukarurruranytja tjiinya-yanku mirrparn-mirrparnpa nyinarranyangka. Palunyalu marlaku yankula ngurra yungarrangka palunyapirinypa palyalpayi. Palunyalu watjarnu ngurra palunyangka-ya yapu pirninya tjunkula parrawanara katultjaku nyangka-yayi kuka pungkula tilira tjunkula Mama Kuurrku nintinma. Nyangka-ya mularrpartu yapu tjunkula parrawanarnu katurnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("S18_1","010_8_1","1SA","8","1","3","Nyangka Tjamiyultu katja kutjarra kanyiranytja. Palunyalu yirnarringkulalpi-pulanya tjunu Yitjurayilku tjamupirti-pula wangkarra tjurrkurlmaratjaku. Nyangka-parturtu-pula mamangka yarangka tjukarurrulu palyaranytjamunu. Tjiinya wati palyamunulu-ya tjimarri nintiranyangka-pula watjantjamaaltu kumpitjunkupayi palyamunu-ya palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S18_4","010_8_4","1SA","8","4","5","Nyangka-ya liita pirni lurrtjurringkula yanu Tjamiyulta watjarnu, “Kulila. Wartalpitjanun yirnarringu. Nyangka-pula nyuntuku katja kutjarralu nyuntula yarangka palyaranytjamunulu palyamunu palyara. Nyangka-munta-lampatjun puurrpa purlkanya ngurrkarntanku? Nyangka-latju puurrpa purlkanya kanyinma, tjiinya ngurra kutjupalu-yanku puurrpa purlkanya kanyira, palunyapirinypa.” ");
INSERT INTO ntj_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Nyangka Tjamiyultu kuliralpi Mama Kuurrngatjirratja tjurlpilyarringu. Palunyalu Mama Kuurrta watjarnu, “Wiya, tjapirnu-rniya puurrpa purlkanya-tjanamparna ngurrkarntankutjaku. Nyangka yaaltjinku-rna?” ");
INSERT INTO ntj_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Nyangka Mama Kuurrtu watjarnu, “Wiya, palya. Puurrpa purlkanya-tjanampa ngurrkarntarra. Tjiinya-ya nyuntunya wantinytjamaalpa ngayunya-rniya wantingu puurrpa-tjanamparna nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Tjiinya-rniya ngayunya rawalu wantirranytja. Palunyalu-ya yapu wartakutju pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Yuwa, palya-tjanampan puurrpa purlkanya ngurrkarntanku. Palunyalu-tjananya ngarnmanytju watjala tjiinya-ya puurrpa purlkanyaku kuliltjarra nyinarratjaku. Tjiinya puurrpa purlkanyalu-ya witu-witura nintilpayi kutjupa-kutjupa palyaratjaku.” ");
INSERT INTO ntj_vpl VALUES ("S18_10","010_8_10","1SA","8","10","18","Nyangka mularrpartu Tjamiyultu-tjananya watjarnu, “Yuwa, puurrpa purlkalu-tjananyanta kanyiranytjalu watjalku nyuntuku katja kutjupatjarra-ya warrmarlara yankutjaku. Puru-tjananyanta watjalku nyuntuku katja kutjupatjarralu-ya puru nyuntuku yurntaltu-ya waarka purlkanya palyaratjaku. Puru puurrpa purlkalu-tjananyanta watjalku kutjupa-kutjupa-yan palunyaku nintiratjaku, tjiinya mirrka purlkanya, kuka purlkanya, puru yanamulpa pirninyatarrartu. Tjiinya-yan puurrpa palunyaku waarka purlkanya palyanma. Palunyalu-yan ngulakutju purtu kuli-kuliralpi Mama Kuurrnga tjapinma tjiinya-tjananyanta yirringkankutjaku puurrpa purlkangkatarrartu. Nyangkalta-tjananyanta kulintjamaaltu wantima.” ");
INSERT INTO ntj_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Nyangka-ya kulirnu wantirralpi watjarnu, “Wiya, puurrpa purlkanyaku-latju mukurringkula. ");
INSERT INTO ntj_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Tjiinya ngurra kutjupalu-yanku puurrpa purlkanya kanyira, palunyapirinypa. Nyangka-lanyatju walara makatima pika wakaltjaku.” ");
INSERT INTO ntj_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Nyangka Tjamiyultu kulintjatjanulu Mama Kuurrta tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Nyangka Mama Kuurrtu watjarnu, “Wiya palya, puurrpa purlkanya-tjanampa ngurrkarntaralpi tjurra.” Nyangka Tjamiyultu-tjananya liita pirningka watjarnu, “Yuwa palya, ngula-tjanamparnanku puurrpa purlkanya ngurrkarntaralpi tjunku. Marlaku-yanku kutipitja ngurraku.” Nyangka-ya mularrpartu marlaku yanu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S19_1","010_9_1","1SA","9","1","2","Nyangka ngurra palunyangka wati yini Kiitjanya yulytja pirnitjarra nyinarranytja. Wati palunyanya Pintjimanku wartangkatja. Nyangka Kiitjaku katja yini Tjuulnga wati yangupala walykumunu nyinarranytja. Tjiinya wirrmira purlkanya nyinarranytja wati pirningka munkarra. ");
INSERT INTO ntj_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Nyangka Tjuulku mamalu tungki pirni kanyiranytja. Nyangka-ya tungki palunyanya kawarnarrara yanu. Nyangka Tjuulku mamalu palunyaku katja yarltirralpi watjarnu, “Yuwa, wati waarka palyalpayi kutju yarltirra yarra tungki ngurrila.” ");
INSERT INTO ntj_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Nyangka-pula mularrpartu yanu ngurra pirniwanalu purtu ngurrirayirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Nyangka Tjuultu watjarnu, “Wiya, yarra-li marlaku ngurrakutu. Tjiinya ngayuku mamalu tjinguru tungkiku kulirnu-kulirnu wantirralpi ngayukutarrartu-limpa tjirturu-tjirtururringu kulira tjiinya-lin yanu rawarrinyangka.” ");
INSERT INTO ntj_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Nyangka wati palunyalu watjarnu, “Kulila. Wati ngalya yarla ngamutja nyinarra. Tjiinya Mama Kuurrku waarka palyalpayinya. Tjiinya wati palunyalu kutjupa-kutjupa watjaranyangka mularrpartu yartakarripayi. Nyangka-tjinguru wati palunyalu-linya nintilu watjalku tungki-ya ngaralanyangka.” ");
INSERT INTO ntj_vpl VALUES ("S19_10","010_9_10","1SA","9","10","16","Nyangka-pula mularrpartu mapitjangu wati palunyanya nyakukitja. Pitjalayirnu-pula nyangu Tjamiyulnga ngalyawaalkarrarnu. Tjiinya mapitjalayintja kuka pungkula tilira tjunkula Mama Kuurrku nintilkitja. Tjiinya Mama Kuurrtu kurranyulu Tjamiyulta nintitjunu Tjuulnga pitjatjaku. Tjiinya-lu watjarnu, “Tjirntungka-rnanta wati kutju katiku tjiinya Pintjimanku wartangkatja. Nyangkan ngurrkarntaralpi tjunku ngayuku katja yurntalpirtiku puurrpa purlkanya nyinarratjaku.” ");
INSERT INTO ntj_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Nyangka Tjamiyultu Tjuulnga nyakulalpi kulirnu Mama Kuurrtu-lu ngaapirinypa watjaranyangka, “Wati ngaanya-rnanta watjaranytja tjiinya puurrarrirra ngayuku katja yurntalpirti kanyiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Nyangka Tjuultu ngurrpalurtu nyangu Tjamiyulnga kayirrta ngaralanyangka. Palunyalu tjapirnu, “Yuwa, watjala-rni. Wati ngalya yarlanya wanytjanya nyinarra?” ");
INSERT INTO ntj_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Nyangka Tjamiyultu watjarnu, “Wiya, ngayulu-rna wati ngalya yarlanya. Ma-kurranyurrirra-pula mapitja yarnangu pirnikutu. Kuwarrinya-pulan lurrtjurringkulalpi mirrka kuka ngalku. Palunyalu-pularnin tjirntungka tjapinma. Nyangka-pulanyarnanta tjakultjunama. Nyangkalta-pulan yanku ngurraku. ");
INSERT INTO ntj_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Wiya, tungki pirninya kulintjamaaltu wanti. Wiyangkalpi-ya ngurrirnu. Nyangka ngaanya kulila. Nyuntulun puurrpa purlkanya nyinaku. Tjiinya Yitjurayilku tjamupirtilu-ya nyuntuku mukurringkula, puru nyuntuku yungarrapirtiku.” ");
INSERT INTO ntj_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Nyangka Tjuultu watjarnu, “Wiya, nyaapan watjara? Ngayuku yungarrapirti-ya mungutja, nintipukamunu nyinarra. Nyangka nyaaku-rnin palunyapirinypa watjara?” ");
INSERT INTO ntj_vpl VALUES ("S19_22","010_9_22","1SA","9","22","25","Nyangka Tjamiyultu-pulanya walara parrakatingu ruumpa purlkanyangka tjarrpatjunu yarnangu pirninya-ya nyinarranyangka. Palunyalu-pulanya puurrpa nyinapayingka nyinatjunu. Palunyalu mirrka palyalpayinya watjarnu, “Kuka wilurru palanya-ra kati. Tjiinya-rnanta watjarnu tjunkulan wantitjaku, palunyanya.” Nyangka mularrpartu mantjira katingu Tjuulku-ra nintirnu. Nyangka Tjamiyultu watjarnu, “Ngalanku parltjarriwa. Nyuntuku-rnanku kanyiranytja.” Nyangka-ya pirnilurtu mirrka kuka ngalangu parltjarringu. Nyangka Tjamiyultu-pulanya katingu palunyaku ngurrangka tjarrpatjunu. Nyangka-pula ngarringu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("S19_26","010_9_26","1SA","9","26","27","Nyangka tjirntukutu Tjamiyultu-pulanya wankaralpi watjarnu, “Pakala-pula nyangka-pulanyarnanta makati wanti.” Nyangka-pulanya mularrpartu makatingu yilkakurringkulalpi watjarnu, “Yuwa Tjuul, nyuntuku waarka palyalpayinya witula. Nyangkayi kurranyurringkula mapitja ngara.” Nyangka mularrpartu kurranyurringkula yanu. Nyangka Tjamiyultu watjarnu, “Kuwarripa ngara. Nyangka-rnanta watjala tjiinya-rni Mama Kuurrtu watjarnu, palunyanya.” ");
INSERT INTO ntj_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Nyangka Tjamiyultu puturlpa uyiltjarra mantjiralpi tjutirnu Tjuulta katangka. Palunyalu nguku kutjarranya nyunytjurnu watjarnu, “Kulila, Mama Kuurrtunta ngurrkarntanu palunyaku katja yurntalpirtiku puurrpa purlkanya nyinarratjaku. Nyangka-ya yanyan-yanyanarripayi pirninya-tjananyanta pika wakalkitja pitjalanyangka nyuntulun Yitjurayilku tjamupirti paalytjura kanyinma. Nyangka kuwarrinya-rnanta ngaanya watjalku tjiinya kutjupa-kutjupa yartakarrinyangkan nintilu kuliltjaku, ‘Yuwa mularrpa-rni Mama Kuurrtu ngurrkarntanu palunyaku katja yurntalpirtiku puurrarritjaku.’ ");
INSERT INTO ntj_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Tjiinyan kuwarrinya kutipitjaku wati kutjarra nyaku. Nyangkanta-pula watjalku tungki-ya yartakarringu. Puru-pula watjalku tjiinya nyuntuku mama tungki palunyaku watatjarringu palunyalu nyuntuku tirtu kulira watjara, ‘Ngayuku katja yanu wiyarringu. Yaaltjirringu-munta?’” ");
INSERT INTO ntj_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Nyangka Tjamiyultu Tjuulta tirtu watjara-wanarayintja, “Palunyangurun mapitjaku nyaku wati marnkurrpa pitjalayirni. Nyangka wati kutjulu nanikuurrpa warlangu marnkurrpa walara katima. Nyangka kutjupalu nyamirli marnkurrpa katima. Nyangka wati kutjupalu yakutja wayintjarra katima. ");
INSERT INTO ntj_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Nyangkanta-ya nyaku pukurlarringkulalpi nyamirli kutjarra nintilku. Nyangka paanypungkutjamaaltu mantjila.” ");
INSERT INTO ntj_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Nyangka Tjamiyultu tirtu watjara-wanarayintja, “Palunyangurun yanku ngurra kutjupakutu. Palunyalun ngamurringkulalpi nyaku yarnangu pirninya-ya ngalyatjarungaralayirni Mama Kuurrnga marninypungkutjatjanu. Tjiinya-ya kutjupatjarralu kitaa wangkatjinganma. Nyangka kutjupatjarralu-ya turamu pungama. Tjiinya-ya ngalyakantura mirrarrayinmatarrartu. ");
INSERT INTO ntj_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Nyangkanta Mama Kuurrku Kuurti tjarrparralpi wuyurrmanku. Nyangkan lurrtjurringkulalpi pukurltu mirrarra kantunma. Palunyalun kulilku wuyurrpanta kutjuparrinyangka. ");
INSERT INTO ntj_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Nyangka palunyanya pirninya yartakarrinyangka kulira palyanma tjiinya Mama Kuurrtunta wuyurrmanku, palunyangka.” ");
INSERT INTO ntj_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Nyangka Tjamiyultu tirtu watjaranytja, “Palunyangurun yanku ngurra Kilkaltakutu. Nyangka-rna marlawana mapitjaku kuka wakaralpi tililku tjunku Mama Kuurrku nintilku. Nyangka-lan kuka kutjupatjarranya ngurra palunyangkartu ngalku. Nyangka-rnanta watjalku kutjupa-kutjupa palyaltjaku.” ");
INSERT INTO ntj_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Nyangka Tjuultu Tjamiyulnga wantirra mapitjakitjangka Mama Kuurrtu-lu wuyurrpa kutjupanu. Nyangka tjirntu palunyangkartu kutjupa-kutjupa pirni Tjamiyultu watjarnu wantinyangka mularrpartu yartakarringu. ");
INSERT INTO ntj_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Nyangka Tjuulnga-pula palunyaku waarka palyalpayinya pitjalayirnu ngurra yini Kipiyaku parrapitjangu. Nyangka-ya wati nyarra Mama Kuurrku wangka kulira tjakultjunkupayi, palunyanya-ya pitjangu lurrtjurringu. Nyangka Mama Kuurrku Kuurtilu Tjuulnga wuyurrmara kanyiranyangka pukurltu mirrarra kanturanytja. ");
INSERT INTO ntj_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Nyangka-ya yarnangu pirnilu nyakulalpi watjarnu, “Nyaarringu wati palanya Kiitjaku katja? Tjuultutarrartu-munta Mama Kuurrku wangka tjakultjunku?” ");
INSERT INTO ntj_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Nyangka Tjuultu mirrarra kanturayirnu wiyarringkula kutipitjangu yapu katalarra tjiinya-ya Mama Kuurrnga marninypungkupayi, palunyalakutu. ");
INSERT INTO ntj_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Nyangka Tjuulku kamurulu-pulanya nyakulalpi tjapirnu, “Wanytjanguru-pulan pitjangu?” Nyangka Tjuultu watjarnu, “Wiya, tungki pirniku-litju parranyakulayintja. Purtu-litju parranyangu wantirra yanu Tjamiyulnga tjapilkitja.” ");
INSERT INTO ntj_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Nyangka Tjuulku kamurulu tjapirnu, “Nyaapanta watjarnu Tjamiyultu?” ");
INSERT INTO ntj_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Nyangka Tjuultu watjarnu, “Wiya, watjarnu tjiinya-ya tungki palunyanya ngurrirnu.” Tjiinya Tjuultu palunyaku kamurungka watjantjamunurtu tjiinya Tjamiyultu-lu watjarnu puurrpa purlkanya nyinarratjaku, palunyanya. ");
INSERT INTO ntj_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Nyangka Tjamiyultu-tjananya yarnangu pirninya yarltingu pitjala-ya Mama Kuurrnga lurrtjurringkula kuliltjaku ngurra yini Mitjipala. ");
INSERT INTO ntj_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Nyangka-ya mularrpartu pitjangu lurrtjurringu. Nyangka-tjananya watjarnu, “Kulila, Mama Kuurrtu-tjananyanta ngaapirinypa watjara, ‘Yuwa, kutjulpirtulpi-tjananyarna nyuntuku tjamupirti Yiitjipulanguru pakaltjingara katingu. Puru-tjananyarna yangatjunu kanyirnu Yiitjipunyamartatjilu-tjananyaya pungkula mirrirntankutjaku. Nyangka puurrpa pirnilu-tjananya nyuntuku tjamupirti pungkulanyangka ngayulu-tjananyarna paalytjura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Tjinguru-rniyan ngayunyakutju tirtu marninypungama. Tjiinyamarntu ngayulu-tjananyarnanta yirringkankupayi purtu-yan kuliranyangka. Ngaanya-rniyan wantirralpi puurrpa kutjupaku ngatjirnu. Yuwa, palya.’” Nyangka Tjamiyultu-tjananya watjarnu yungarrapirti-yanku mawurntalpa-mawurntalpa pitjala ngaratjaku nyangka Mama Kuurrtu-tjanampa ngurrkarntankutjaku puurrpa purlkanya nyinatjaku. ");
INSERT INTO ntj_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Nyangka-ya mularrpartu palunyapirinypa pitjangu ngaralanytja. Nyangka Tjamiyultu-tjananya puru watjarnu tjiinya-ya yungarrapirti-yungarrapirti pitjala wayirntara mapitjalatjaku. Nyangka-ya mularrpartu pitjala wayirntaranyangka Mama Kuurrtu ngurrkarntanu Pintjimanku wartangkatja pirninya. ");
INSERT INTO ntj_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Nyangka-ya palunyanya pirninya pitjala wayirntaranyangka Mama Kuurrtu ngurrkarntanu Tjuulnga. Nyangka-raya purtu parranyakulanytja. ");
INSERT INTO ntj_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Palunyalu-ya Mama Kuurrnga tjapirnu, “Wati ngaangka yaaltjirringu?” Nyangka Mama Kuurrtu watjarnu, “Wiya, nyarratja yulytja pirningka kumpirnu nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Nyangka-ya kukurraarnu Tjuulnga yarltirra katingu yarnangu pirningka ngururrpa ngaratjunu. Nyangkalta-ya nyangu wirrmira purlkanya wayirntalpa ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Nyangka Tjamiyultu-tjananya watjarnu, “Nyawa-ya wati ngaanya Mama Kuurrtu-tjanampanku ngurrkarntanu.” Nyangka-ya pirnilurtu pukurltu mirrarralpi watjarnu, “Yuwawu! Puurrpa-lampa walykumunu!” ");
INSERT INTO ntj_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Nyangka Tjamiyultu-tjananya tjurrkurlmara watjaranytja puurrpa purlkanyaku waarka. Palunyalu ruulangka walkatjunu. Palunyalu-tjananya witurnu ngurraku-ya yankutjaku. Nyangka-ya mularrpartu yanu. ");
INSERT INTO ntj_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Nyangka Tjuulngatarrartu ngurraku yanu. Nyangka-ya wati pirni lurrtjurringkula yanu. ");
INSERT INTO ntj_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Nyangka kutjupatjarralu-ya panypuratjarralu watjaranytja, “Yaaltjilunyka-lanya wati nyarralu yirringkanku?” Palunyapirinypa-ya watjaralpi yanyan-yanyantu wantingu kutjupa-kutjupa walykumunu katirra nintintjamaaltu. Nyangka Tjuultu-tjananya mirrparnmaaltu kalypalu nyangu wantingu. ");
INSERT INTO ntj_vpl VALUES ("S111_1","010_11_1","1SA","11","1","13","Nyangka puurrpa kutju warrmarla pirnitjarra ngurra kutjupanguru pitjangu-tjananya pika wakalkitja. Nyangka Tjuultu-tjananya Yitjurayilku tjamupirti walara katingu pika wakaltjaku. Nyangka-tjananyaya wakara mirrirntara wiyaranytja. Nyangka-ya kutjupatjarranya ngurlu kukurraarnu. Nyangka-ya yarnangu pirninya pukurlarringu tjiinya Tjuultu-tjananya walykumunulu walara katinyangka. ");
INSERT INTO ntj_vpl VALUES ("S111_14","010_11_14","1SA","11","14","15","Nyangka Tjamiyultu-tjananya watjarnu, “Yuwa, pakara-la yarra ngurra nyarra Kilkaltakutu. Palunyalu-la watjala wanti Tjuulnga-lampa puurrpa purlkanya tirtu nyinarratjaku.” Nyangka-ya mularrpartu yanu ngurra palunyalakutu. Palunyalu-ya watjarnu wantingu Tjuulnga-tjanampa puurrpa purlkanya tirtu nyinarratjaku. Palunyalu-ya pukurlarringkulalpi Mama Kuurrnga pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Nyangka Tjamiyultu-tjananya Yitjurayilku tjamupirtingka watjarnu, “Yuwa, puurrpa purlkanya-tjanamparnanku tjunu tjiinya-rniyan watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Nyangka ngaanguru puurrpa palunyalu-tjananyanta miranykanyira kanyinma. Yuwa, ngayunya-rna wartalpi yirnarringu, wiri purlkanya. Tjiinya wati yangupalalulpi-tjananyarnanta miranykanyirayirnu yirnarringu. ");
INSERT INTO ntj_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Yuwa, pirninyartu-tjuyan ngayuku ninti. Palunyalu-rni marlakukutula kuliralpi watjala. Kutjupa-kutjupa-munta-rna palyaranytja? Kutjupaku tungki puru puluka-munta-rna ngurlunyparrara kanyiranytja? Tjimarri-munta-rna kampangkartu mantjiranytja? Nyangka-munta-rniya kutjupalu tjimarri nintiranytja kuurrpangka-rna mayura watjaratjaku? Watjala-rniya. Nyangka-tjinguru-rna palunyapirinypa palyaranytjatjanulu ngaparrtjika nintilku.” ");
INSERT INTO ntj_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Nyangka-ya yarnangu pirnilu watjarnu, “Wiya. Nyuntulu-lanyatjun mayura mantjiranytjamunurtu. Purun kutjupa-kutjupa kutjupangka mantjiranytjamunu.” ");
INSERT INTO ntj_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Nyangkalta Tjamiyultu-tjananya watjarnu, “Yuwa, Mama Kuurrtu-tjananyanta kulirnu watjaranyangka-yan. Puru nyuntuku-tjanampanku puurrpa purlkanyalu nyinarra kuliranytja.” Nyangka-ya watjarnu, “Yuwa, Mama Kuurrtu-lanyatju kulirnu watjaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Nyangka Tjamiyultu-tjananya puru watjarnu, “Yuwa, puurrpa purlkanya-tjanampanku ngaanya nyinarra. Tjiinya-yan puurrpa purlkanyaku mukurringkulanyangka Mama Kuurrtu-tjanampanku ngurrkarntaralpi tjunu. ");
INSERT INTO ntj_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Nyangka-munta-yan mukurringkula walykumunu nyinakitja? Wiya, mula-mulalu-ya Mama Kuurrnga kulinma. Pina yarlalu-ya kulira palyanma watjaranyangka. Yuwa, tjinguru nyuntuku puurrtutarrartu-yan Mama Kuurrnga wantinytjamaaltu tirtu wananma. Nyangka-tjanampanku walykumunu tirtu ngarama. ");
INSERT INTO ntj_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Nyangka-tjinguru-yan Mama Kuurrku wangka wantiku. Nyangka-tjananyanta yirringkara kanyilkitjamunu. Nyangka-ya ngurra kutjupanguru warrmarlara pitjanyangka nyuntuku puurrpa purlkanyalutarrartu-yan purtu kulinma.” ");
INSERT INTO ntj_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Nyangka-tjananya Tjamiyultu puru watjarnu, “Yuwa, nyinarra nyangama Mama Kuurrtu yayirninytjulu kutjupa-kutjupa palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Tjiinya kapilu-lanya puyiranytjamunu. Nyangka-rna Mama Kuurrnga tjapilku nyangka-lampa kapi wanangaratjarra nintilku. Nyangka-yan nyakulalpi nintilu kulilku, ‘Munta! Tjinguru-lan puurrpa purlkanyaku ngatjintjamaaltu wantima. Tjiinya Mama Kuurrnga miirlarrarnu palunyanyakutju-lan kuliranytjamunungka.’” ");
INSERT INTO ntj_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Nyangka mularrpartu Tjamiyultu Mama Kuurrnga tjapirnu. Nyangka tjirntu palunyangkartu kapi wanangaratjarra nintirnu. Nyangka-tjananya kapi purlkanyalu pungkulanytja. Nyangka-ya ngurlurringu Mama Kuurrku puru Tjamiyulkutarrartu. ");
INSERT INTO ntj_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Palunyalu-ya Tjamiyulnga watjarnu, “Wiya puurr, tjapila-lampatju tjiinya-lanyatju mirrirntankutjakutarrartu. Tjiinya-latju palyamunulu puurrpa purlkanyaku ngatjirnu.” ");
INSERT INTO ntj_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Nyangka Tjamiyultu-tjananya watjarnu, “Wiya, ngurlumaalpa-ya raparriwa. Mularrpa-yan palyamunu palyarnu. Palunyalu-ya Mama Kuurrnga wantinytjamaaltu kurrurntutarrartu tirtu wananma. ");
INSERT INTO ntj_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Nyangka-kurlu-yan pinkurraalku tjukurrtatja kutjupa-kutjupaku mula-mularriku. Wanti. Tjiinyamarntu-tjananyanta wankarura kanyilkitjamunu. Tjiinya-ya mula-mula wiya. ");
INSERT INTO ntj_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Nyangka Mama Kuurrtu-tjananyanta watjarnu wantingu tjiinya wantikitjamunulu. Tjiinya palurukurrurntu-tjananyanta ngurrkarntanu palunyaku katja yurntalpirti-yan nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Nyangka ngayulu-tjanamparnanku tirtu tjapinma. Tjinguru-rna ngayulu watatjarriku tjapilkitja. Nyangka-rni Mama Kuurrtu nyaku palyamunu-rna palyannyangka. Yuwa, tirtu-tjanamparnanku tjapinma. Palunyalu-tjananyarnanta nintipungama tjukarurru-yan nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Nyangka-ya wangka kutjurtu kulira Mama Kuurrnga kurrurnpa wuyurrtu wananma. Palunyalu-ya ruukulinma Mama Kuurrtu-tjanampanku yayirninytjulu kutjupa-kutjupa palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Nyangka-tjinguru-yan palyamunu tirtu palyanma. Nyangka Mama Kuurrtu warrmarla pirni witulku. Nyangka-ya pitjaku-tjananyanta puru nyuntuku puurrpa purlkanyatarrartu wakara mirrirntara-wanarayilku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Nyangka Tjuultu puru palunyaku katja Tjanatjantu warrmarla pirni kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Nyangka Tjanatjantu-ya mapitjangu warrmarla Pilitjinyamartatji pirninya-tjananya wakarnu mirrirntanu ngurra kutjungka-ya nyinarranyangka. Nyangka-ya yarnangu Pilitjinyamartatji pirninya kuliralpi mirrparnarringu. ");
INSERT INTO ntj_vpl VALUES ("S113_5","010_13_5","1SA","13","5","6","Palunyalu-ya minga-minga warrmarlanu lurrtjurringkulayirnu pitjangu ngurra tjunu Yitjurayilku tjamupirti pika wakalkitja. Palunyalulta-ya warrmarla palunyanya pakara minga-minga purtipirinypa waalkarrara pitjangu. Nyangka-ya Yitjurayilku tjamupirtilu nyakulalpi purtu kuli-kulirnu. Nyangka-ya kutjupatjarra kukurraarnu pulpangka puru pirtingka kumpirnu. Nyangka-ya kutjupatjarra kukurraarnu yapungka kumpiralpi puparranytja. Nyangka-ya kutjupatjarra wiilpangka tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Nyangka-ya kutjupatjarranya yuruwana yitipirrirra kukurraarnu ngurra kutjupa-kutjupakutu. Nyangka Tjuulnga tirtu nyinarranytja ngurra Kilkalta. Nyangka-ya palunyaku warrmarla pirninya ngurlu tiltirrmaranytja. ");
INSERT INTO ntj_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Nyangka-ya kutjupatjarralu wantirra yankulanytja. Nyangka Tjuultu nyinarra kawarrtu nyakulanytja Tjamiyulnga pitjatjaku. Tjiinyamarntu-lu ngaapirinypa watjarnu, “Kutjupa-kutjupa palyantjamaaltu wanti. Nyinama ngayulu-rna pitjatjaku.” Nyangka Tjuulnga mularrpartu nyinarrayirnu tjirntu 7-tjanulu purtu nyakulanytjalu-tjananya ");
INSERT INTO ntj_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","watjarnu, “Tjiipu-ya kati nyangka-rna pungkulalpi tilila tjurra Mama Kuurrku nintila.” ");
INSERT INTO ntj_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Nyangka-ya mularrpartu palyarnu wiyarrinyangkartu Tjamiyulnga waalkarrara pitjangu. Nyangka Tjuulnga mapitjangu lurrtjurringu. ");
INSERT INTO ntj_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Nyangka Tjamiyultu nyakulalpi watjarnu, “Nyaapan palyarnu?” Nyangka Tjuultu watjarnu, “Wiya, warrmarla pirnilu-rniya wantirra yankulanytja. Nyangka nyuntulun waarrpungkula pitjanytjamunurtu. Nyangka-ya warrmarla Pilitjinyamartatji pirninya ngamutja lurrtjurringkulanytja pika wakalkitja. ");
INSERT INTO ntj_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Nyangka-rna kulirnu ngurra ngaakutarrartu-lanyatjuya pitjala mirrirntankutjaku. Palunyangkatarrartu-rna yunytjurringkulalpi tjiipu pungkulalpi tilirnu tjunu Mama Kuurrku nintirnu. Palunyalu-rna tjapirnu yirringkankutjaku-lanyatju.” ");
INSERT INTO ntj_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Nyangka Tjamiyultu-lu watjarnu, “Wiya, kawa-kawalun palyarnu Mama Kuurrku wangka kuliranytjamunulu. Tjingurun Mama Kuurrnga kuliranytjatjanu Yitjurayilku tjamupirtiku puurrpa purlkanya tirtu nyinama. Nyangka-tjinguru-ya nyuntuku tjamupirti marlangkatja-marlangkatja pakaranytjalu puurrpa purlkanya nyinama nyuntuku yarangka. ");
INSERT INTO ntj_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Ngaanyan nyuntulu Mama Kuurrku wangka kuliranytjamunu. Palunyangurungkan nyuntulu puurrpa wiyarringku. Tjiinya Mama Kuurrtunta wantirralpi wati kutjupa ngurrkarntanku palunyaku katja yurntalpirtiku puurrpa purlkanya nyinarratjaku. Tjiinya wati walykumunu, Mama Kuurrnga wangarnarralu kulira palyalpayinya ngurrkarntanku.” ");
INSERT INTO ntj_vpl VALUES ("S114_1","010_14_1","1SA","14","1","7","(1,6-7) Nyangka Tjanatjantu wati yangupala tjara katirrayilpayinya yarltirralpi watjarnu, “Yuwa, yarra-li nyawa nyarra wati Pilitjinyamartatji-ya warrmarlara pitjangu ngurrangka nyinarranyangka. Palyartu-lin kutjarra nyinarra. Nyangka tjinguru Mama Kuurrtu-linya yirringkanku. Nyangka-lin wakalku-tjananya mirrirntanku. Tjiinyamarntu Mama Kuurrtu yayirninytjulu palyalpayi. Tjiinya-rna kulira yapungka tatira yutjuwana mapitjala tjarungarakitjalu.” Nyangka wati yangupalalu watjarnu, “Yuwa, palya. Walykumunulun kulira. Nyangka-lin lurrtjurtu yanku.” Nyangka-pula mularrpartu yanu. Tjiinya Tjanatjantu palunyaku mamangka tjamalankutjamaalpa kampangkartu yanu. Nyangka-ya palunyaku warrmarla pirninyatarrartu ngurrpartu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Nyangka Tjanatjantu watjarnu, “Yuwa, yitipirringkulalpi-li yartakarri. Nyangka-linyayayi warrmarla Pilitjinyamartatjilu nyawa. ");
INSERT INTO ntj_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Nyangka-tjinguru-linyaya watjalku ngaratjaku nyangka-linyayayi ngayulakutu nyakula pitja. Palunyangka-lin nyinaku. ");
INSERT INTO ntj_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Wiya-tjinguru-linyaya yarltiku. Nyangka-lin mapitjaku-tjananya wakalku. Tjiinyamarntu-linyaya yarltinyangka-lin nintilu kulilku, ‘Munta yuwa. Mama Kuurrtu-linya yirringkanku-tjananya wakara wiyaltjaku.’” ");
INSERT INTO ntj_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Nyangka-pula mularrpartu yartakarringu. Nyangka-ya warrmarla Pilitjinyamartatjilu nyakulalpi panypuratjarralu watjarnu, “Wiya, munkarra nyawa. Yitjurayilku tjamupirti-ya nyarra pirtinguru ngalyapakarnu.” ");
INSERT INTO ntj_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Nyangka-ya mirrangu watjarnu, “Pitja-pula kulila.” Nyangka Tjanatjantu wati yangupala watjarnu, “Walangkartu-rni pitja. Mama Kuurrtu-linya kanyira.” ");
INSERT INTO ntj_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Nyangka Tjanatjannga mara-mara ngalyatatirayintja. Nyangka wati yangupalalu marlawanalurtu wanarayintja. Nyangka Tjanatjantu warrmarla Pilitjinyamartatji wakara punkatjingaranytja. Nyangka wati yangupalalu-tjananya mirrirntaranytja. ");
INSERT INTO ntj_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Tjiinya-pula waarrpungkulalpi warrmarla 20 wakarnu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Nyangka-ya Pilitjinyamartatji pirninyartu ngurlu-ngurlurringu. Nyangka manta yurri-yurringu. Nyangka-ya purtu kuli-kulirnu. ");
INSERT INTO ntj_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Nyangka Tjuulku warrmarla tiwanguru ngarala nyakupayilu-ya nyangu warrmarla Pilitjinyamartatji-ya kuwar-kuwararringkulalpi kukurrpa parrapitjalayintja. Palunyalu-ya Tjuulta tjakultjunu. ");
INSERT INTO ntj_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Nyangka Tjuultu-tjananya watjarnu, “Parranyawa-ya ngayuku warrmarla pirninya nyawa, ‘Ngananya wiyarringu?’” Nyangka-ya mularrpartu parranyakulayirnu nyangu Tjanatjannga-pula wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Nyangka tjiinya wati kutju tiinti miirl-miirlta waarka palyalpayi-tjananya warrmarlangka nyinarranytja. Nyangka Tjuultu-lu yarltingu watjarnu, “Pitja. Nyangka-la Mama Kuurrnga tjapila yaaltji-yaaltji-lanku palyaltjaku.” ");
INSERT INTO ntj_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Nyangka wangkarranyangkartu Tjuultu nyangu warrmarla Pilitjinyamartatji-ya ma-kuwar-kuwararringkulalpi mirrarra parrakukurraaranytja. Nyangka Tjuultu wantirralpi wati palunyanya watjarnu, “Palya. Wanti-li marlarritjakutarrartu. Nyangka-la waarrpungkula-tjananya ngurlura wanala.” ");
INSERT INTO ntj_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Nyangka Tjuultunku warrmarla pirninya yarltirra yanu. Nyangka-ya pitjangu waalkarrarnu Pilitjinyamartatjingka nyangu tjiinya-ya kuwar-kuwararringu yungarrapirtilutarrartu-yanku ngaparrku-ngaparrkulu wakaranytja. ");
INSERT INTO ntj_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Nyangka-ya Yitjurayilku tjamupirti kutjupatjarra ngurlutjanu-ya marlaku pitjangu lurrtjurringu. Nyangka-tjananyaya pirnilurtu Pilitjinyamartatji pirninya wakaranytja. ");
INSERT INTO ntj_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Wakara-tjananya wanarayirnu mawantingu. Tjiinya tjirntu palunyangkartu Mama Kuurrtu Yitjurayilku tjamupirti paalytjunu kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Nyangka Tjamiyultu pitjangu Tjuulta watjarnu, “Yuwa, kutjulpirtu Mama Kuurrtu-rni watjarnu nyuntunyanta ngurrkarntaralpi tjunkutjaku nyangkayin puurrpa purlkanya nyinama. Nyangka-rnanta mularrpartu tjunu Yitjurayilku tjamupirtikun puurrpa purlkanya nyinarratjaku. Nyangka kulila Mama Kuurrku wangka ngaanya-rnanta watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","‘Kutjulpirtu Yitjurayilku tjamupirti-ya Yiitjipulanguru ngalyapakarnu pitjalayintja. Nyangka wati Yamalikiku tjamupirti-ya pitjangu pika wakaranytja. Nyangka kuwarrinya-rna Yamalikiku tjamupirtiku palyamunu purlkanya yutilku. ");
INSERT INTO ntj_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Nyangka yarra-tjananya pika wakara pungama. Kutjupa tjarrara wantinytjamaaltu wakara pungkula-wanarayila yurirlpakutjula. Tjiinya wati, minyma, tjilku, puru pilyirrpatarrartu wakala wiyala puru tjiipu, puluka, kamurlpa puru tungkitarrartu.’” ");
INSERT INTO ntj_vpl VALUES ("S115_4","010_15_4","1SA","15","4","9","Nyangka mularrpartu Tjuultu warrmarla pirninyartu yarltirra minga-minga yanu. Nyangka-ya yarnangu Yamalikiku tjamupirti wakara pungkulatarra wanarayirnu wiyarnu. Palunyalu-tjanampa puurrpa purlkanyakutju wantirralpi tjulyara katingu. Puru-ya tjiipu puluka karnpi purlkanya wantingu, nyurrka-nyurrkakutju wakarnu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("S115_10","010_15_10","1SA","15","10","13","Nyangka Mama Kuurrtu-lu Tjamiyulta watjarnu, “Wiya, tjinguru-rna Tjuulnga puurrpa purlkanya tjunkutjamaaltu wantima. Tjiinya-rni wantirra pinkurraarnu palunyalu ngayuku wangka kulintjamaaltu tungunpungu.” Nyangka Tjamiyultu kuliralpi Mama Kuurrku mirrparnarringu. Palunyalu mungangkartu Mama Kuurrta wangkarrayirnu tjirnturringu. Palunyalu mungayurntura pakara yanu Tjuulku ngurrilkitja. Pitjalayirnu nyangu ngurra yini Kilkalta nyinarranyangka. Nyangka Tjuultu Tjamiyulnga nyakulalpi pitjangu pukurl-pukurltu watjarnu, “Yuwa, Mama Kuurrtunta pukurlmara kanyinma. Wangarnarralu-rna kulira palyaranytja Mama Kuurrtu-rni watjannyangka.” ");
INSERT INTO ntj_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Nyangka Tjamiyultu watjarnu, “Mularrpa-munta? Wiya, nyaanguru-rna kulira tjiipu, puluka-ya wangkarranyangka?” ");
INSERT INTO ntj_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Nyangka Tjuultu watjarnu, “Wiya, warrmarlalu-ya Yamalikiku tjamupirtingka mantjirnu. Tjiinya-ya tjiipu puluka walykumunukutju ngurrkarntara katingu pungkula Mama Kuurrku nintilkitjalu. Nyangka kutjupatjarranya-latju wakarnu mirrirntanu wiyarnu.” ");
INSERT INTO ntj_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Nyangka Tjamiyultu watjarnu, “Kuwarripa kulila. Nyangka-rnanta watjala Mama Kuurrtu-rni mungangka watjarnu, palunyanya.” Nyangkalta-lu watjarnu, “Yuwa, watjala-rni.” ");
INSERT INTO ntj_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Nyangka Tjamiyultu watjarnu, “Yuwa, nyuntulunku kurlunypa kulira. Nyangka Mama Kuurrtunta ngurrkarntaralpi puurrpa purlkanya nyinatjunu Yitjurayilku tjamupirtiku. ");
INSERT INTO ntj_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Kutju-palunyalurtunta witurnu Yamalikiku tjamupirti wakara mirrirntara wiyaltjaku. ");
INSERT INTO ntj_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Nyangka nyaatjanulun wangka palunyanya kulintjamaalpa? Tjiinyan manyulu kukurraaralpi kutjupa-kutjupa parrayurrarnu. Kulila. Mama Kuurrnganku mirrparnarringu.” ");
INSERT INTO ntj_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Nyangka Tjuultu watjarnu, “Wiya, palunyaku wangka-rna wangarnarralu kulira palyaranytja. Tjiinya-latju yanu Yamalikiku tjamupirti pirninyartu mirrirntanu. Puurrpa purlkanyakutju-latju tjulyara marlakulu katingu. ");
INSERT INTO ntj_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Nyangka-ya warrmarla pirnilu tjiipu puluka walykumununyakutju mirrirntankutjamaaltu miratjura katingu pungkula Mama Kuurrku nintilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Nyangka Tjamiyultu watjarnu, “Wiya, Mama Kuurrnga wanytjapirinyku mukurringkula? Tjinguru mukurringkula tjiipu-yan pungkula nintiltjaku. Wiya, tjinguru mukurringkula palunyaku wangka-yan wangarnarralu kulira palyaratjaku. Wiya, kunpu-kunpun tjiipu tilira. Tjingurun Mama Kuurrku wangka wangarnarralu kulira palyanma. ");
INSERT INTO ntj_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Tjiinyan Mama Kuurrku wangka karnany-karnanytju kulira wantirranytja. Nyangka Mama Kuurrtunta kulira, ‘Yuwa nyuntulun wati nyarra yapu pupakatirra marninypungkupayinyapirinypa.’ Yuwa, nyuntulun Mama Kuurrku wangka wantingu. Palunyangurungka Mama Kuurrtunta paanypungu puurrpa purlkanya nyinanytjamaaltu wantitjaku.” ");
INSERT INTO ntj_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Nyangka Mama Kuurrtu-lu Tjamiyulta watjarnu, “Wiya, tirtu-muntan ruukulira Tjuulku yulama? Tjiinya-rnalu ngayulu paanypungu Yitjurayilku tjamupirtiku puurrpa purlkanya nyinarranytjamaaltu wantitjaku. Nyangka kuwarrinya uyilpa mantjira pakara yarra ngurra nyarra Pitjiliyamaku. Mapitja wati yini Tjatjila lurrtjurriwa. Tjiinyamarntu wati palunyalu katja pirni kanyiranyangka-rna katja kutju ngurrkarntanu puurrarringkula Yitjurayilku tjamupirti-tjananya kanyiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Nyangka Tjamiyultu watjarnu, “Wiya, yaaltjilu-rna palunyapirinypa palyalku? Purtu-rnatju kulira. Tjuultu-tjinguru-rni kuliralpi pungku mirrirntanku.” Nyangka Mama Kuurrtu watjarnu, “Puluka warlangu walara makati. Palunyalu-tjananya watjala tjiinyan pitjangu kuka pungkula ngayuku nintilkitja. ");
INSERT INTO ntj_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Palunyalu yarnangu pirninya yarlti pitjala-ya lurrtjurringkula puluka warlangunya pungkula tilira tjunkula ngayuku nintiltjaku. Puru Tjatjinya puru palunyaku yungarrapirtitarrartu yarlti. Nyangka-rnanta nintitjunku wati kutju. Wati nyarra watjalku-rnanta, palunyangka-lu katangka uyilpa tjutila. Tjiinya wati palunyanya puurrpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Nyangka mularrpartu Tjamiyultu uyilpa mantjira puru puluka warlangu walara yanu Pitjiliyamalakutu. Nyangka ngurra palunyanguru-ya liita pirninya ngata-ngata pitjangu lurrtjurringu. Palunyalu-ya ngurlu-ngurlulu tjapirnu, “Puurr, mirrparnpa-muntan pitjangu?” ");
INSERT INTO ntj_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Nyangka Tjamiyultu watjarnu, “Wiya. Tjiinya-rna pitjangu kuka pungkulalpi tilira tjunkula Mama Kuurrku nintilkitja. Nyangka-yanku parltjira walykumunurringkula pitja Mama Kuurrnga marninypungkukitja.” Nyangka Tjatjinya puru palunyaku katjatarrartu watjarnu, “Parltjila-ya walykumunurringkula pitja. Nyangka-la yarra puluka warlangu pungkulalpi tilila tjurra Mama Kuurrku nintila.” ");
INSERT INTO ntj_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Nyangka-ya mularrpartu pitjangu lurrtjurringu. Nyangka Tjamiyultu Tjatjiku katja tirnanya nyakulalpi kulirnu, “Tjinguru Mama Kuurrtu wati ngaanya ngurrkarntanu.” ");
INSERT INTO ntj_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Nyangka Mama Kuurrtu watjarnu, “Yuwa, wati ngaanya wirrmira puru yiiku walykumunu. Nyangka-rna wantiku. Tjiinya yarnangulu-ya yiiku walykumunu marninypungkula watjalpayi. Nyangka-rna ngayulu kurrurnpa nyakupayi puru pinalukutju kuliranytjanya.” ");
INSERT INTO ntj_vpl VALUES ("S116_8","010_16_8","1SA","16","8","10","Nyangka Tjatjilu-tjananya puru katja pirni 6-pa katingu. Nyangka Tjamiyultu watjarnu, “Wiya, Mama Kuurrtu-tjananya wati ngaanya-tjananya ngurrkarntankutjamunurtu.” ");
INSERT INTO ntj_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Nyangkalta tjapirnu, “Katja kutjupa-muntan kanyira?” Nyangka Tjatjilu watjarnu, “Yuwa, katja marlangkatjanya nyarra purtingka nyinarra tjiipu miranykanyira kanyira.” Nyangka Tjamiyultu watjarnu, “Wati kutju witula yarltirra katitjaku. Kuwarripa-rna puluka ngaanya kanyilku. Nyangka katja palunyanya pitjaku lurrtjurrinyangkakutju-la pungkulalpi tililku tjunku Mama Kuurrku nintilku.” ");
INSERT INTO ntj_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Nyangka mularrpartu Tjatjilu wati kutju witunnyangka yanu Tayipirrnga yarltirra katingu. Nyangka wati palunyanya yarnangu walykumunu puru yiiku walykumunu. Tjiinya kuru mantjil-mantjilpa. Nyangka Mama Kuurrtu watjarnu, “Yuwa, wati ngaanya palunyanya. Uyilpa tjutila katangka tjiinya-rnalu ngayulu ngurrkarntankunyangka.” ");
INSERT INTO ntj_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Nyangka Tjamiyultu mularrpartu uyilpa mantjiralpi Tayipirrta katangka tjutirnu palunyaku kurtapirtilu-ya nyakulanyangka. Nyangka Mama Kuurrku Kuurti waarrpungkulalpi Tayipirrta tjarrpangu. Palunyangururtu-lu tirtu kanyiranytja. Nyangkalta Tjamiyulnga marlaku yanu palunyaku ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Nyangka tjiinya Mama Kuurrku Kuurtilu Tjuulnga-lu wantirra yanu. Nyangka Mama Kuurrtu mamu witurnu Tjuulnga ngurlutjingara kanyiratjaku. Nyangka mularrpartu pitjangu ngurlutjingaranytja ");
INSERT INTO ntj_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Nyangka palunyaku waarka palyalpayilu-ya watjarnu, “Yuwa puurr, nintilu-latju kulira tjiinya mamulunta ngurlutjingara kanyira Mama Kuurrtu ngalyawitunnyangka. ");
INSERT INTO ntj_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Witula-lanyatju. Nyangka-latju yarra wati kitaa wangkatjingalpayinya ngurrila. Palunyalu-latju yarltirra katiku ngurra ngaangka nyinarratjaku. Nyangka mamulunta ngurlutjingara kanyiranyangka wati palunyalu kitaa wangkatjingalku. Nyangkan walykumunurringku.” ");
INSERT INTO ntj_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Nyangka Tjuultu watjarnu, “Yuwa, ngurrira kati wati kitaa walykumunulu wangkatjingalpayinya.” ");
INSERT INTO ntj_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Nyangka waarka palyalpayi kutjulu watjarnu, “Wiya, wati yini Tjatjiku katjalu kitaa walykumunulu wangkatjingalpayi. Palunyanya yangupala walykumunu, tjiinya ngurlumaaltu pika pungkupayi, puru tjukurrpa walykumunu watjalpayi. Tjiinya Mama Kuurrtu-lu tirtu miranykanyira kanyira.” ");
INSERT INTO ntj_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Nyangka mularrpartu witurnu yankula Tjatjinya tjapiltjaku. Nyangka mapitjangu watjarnu, “Yuwa, Tjuultu-rni witurnu ngaapirinypa-rnanta watjaltjaku, ‘Nyuntuku katja Tayipirrnga ngayulakutu-rni witula tjiinya tjiipu miranykanyilpayinya.’” ");
INSERT INTO ntj_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Nyangka mularrpartu Tjatjilu witurnu. Puru mirrka kukatarrartu nintirnu makatirra puurrpa Tjuulku nintiltjaku. ");
INSERT INTO ntj_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Nyangka Tayipirrnga yanu Tjuulku ngurrangka nyinarra waarka palyaranytja. Nyangka Tjuulnga-ra pukurlarringkulalpi mukulyanytjulu kanyiranytja. Palunyalu watjarnu Tayipirrtu-ra tjara kurlarta katirrayiltjaku tjiinya pika wakalkitja yankulanyangka. ");
INSERT INTO ntj_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Nyangka Tjuultu pururtu witurnu yankula Tjatjila watjaltjaku. Nyangka mularrpartu yanu watjarnu, “Kulila. Tjuulnga mukurringkula nyuntuku katja Tayipirrnga ngamu kanyilkitja waarka-ra palyaratjaku. Tjiinya-lu pukurlmara kanyira.” Nyangka Tjatjilu yuwarnmanu. ");
INSERT INTO ntj_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Nyangka palunyanguru tjiinya mamulu pitjala Tjuulnga ngurlutjingaranyangka Tayipirrtu kitaa mantjira wangkatjingalpayi. Nyangka mamulu wantirra yankupayi. Nyangka Tjuulnga walykumunurringkula nyinapayi. ");
INSERT INTO ntj_vpl VALUES ("S117_1","010_17_1","1SA","17","1","3","Nyangka-ya wati Pilitjinyamartatji warrmarlara pakara kapurturringkula pitjangu Yitjurayilku tjamupirti pika wakalkitja. Palunyalu-ya murrpungka ngurra tjunu. Nyangka-ya Tjuulnga puru wati Yitjurayilku tjamupirti warrmarlara mapitjangu karru-karrungka ngurra tjunu. Palunyalu-ya riitirringu ngaralanytja warrmarla Pilitjinyamartatji pika wakalkitja. Nyangka ngarringu tjirnturringkulalpi-ya warrmarla Pilitjinyamartatji yirrira kukurraarnu murrpu kutjupangka ngaralanytja. Nyangka-ya warrmarla Yitjurayilku tjamupirti murrpu kutjupanguru ngaralanytja. Tjiinya karru-karru ngururrkutjarra ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("S117_4","010_17_4","1SA","17","4","7","Nyangka wati kutju Pilitjinyamartatji tjiinya tjangara purlkanya ngaralanytja. Wati palunyanya yini Kilayatjanya. Palunyalu pakara kurranyu-kurranyu pitjangu ngarangu-tjananya Yitjurayilku tjamupirti ngakayarltikitja. Tjiinya warntupirinypa witu-witu purlkanya kanyiranytja mangkawarlatarrartu. Palunyalunku kurlarta tjuku-tjukumunu yiri purlkanya kanyiranytja. Nyangka wati kutju kurranyu-kurranyu ngarala-ra tjara purlkanya kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Nyangka Kilayatjalu ngarala mirrarra watjaranytja, “Kunpu-kunpu-yan yirrira kukurraarnu ngarala pika wakalkitjayuru. Wati kutju-ya ngurriralpi ngalyawitula pitjala-rni wakaltjaku. ");
INSERT INTO ntj_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Nyangka-tjinguru-rni ngayunya mirrirntanku. Nyangka-lampatjuyan puurrarringkulalpi witu-witura nintinma waarka-tjanampanku palyaratjaku. Tjinguru-rnalu ngayulu mirrirntanku. Nyangka-latju nyuntuku-tjanampanku puurrarringkulalpi witu-witura nintinma waarka-lampatjuyan palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Yala, kuwarrinyartu-ya wati kutju ngurriralpi witula. Ka-litjunku pika wakala. Wiya-tjinguru-yan purtu ngurrilku wantiku.” ");
INSERT INTO ntj_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Nyangka Tjuultu puru palunyaku warrmarla pirnilutarrartu-ya kulirnu ngurluny-ngurlunyarringkulalpi purtu kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("S117_12","010_17_12","1SA","17","12","14","Nyangka Tayipirrku mama Tjatjinya yirna purlkanya nyinarranytja ngurra nyarra Pitjiliyamala. Tjiinya Tjatjilu katja 8-pa kanyiranytja. Nyangka Tayipirrnga-ra katja marlangkatjanya nyinarranytja. Nyangka-ya Tayipirrku kurta purlkanya marnkurrpa yanu Tjuulta lurrtjurringu pika wakalkitja. ");
INSERT INTO ntj_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Nyangka Tayipirrnga Tjuulta nyinarra palunyalu wantirra marlaku yankupayi palunyaku mamaku tjiipu miranykanyilkitja. ");
INSERT INTO ntj_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Nyangka tjirntu kutjupa tjirntu tjangara Kilayatjalu-tjananya Yitjurayilku tjamupirti tirtu pikaku ngakayarltirranytja. Tjiinya yunguntjarra, mungarrtjitarrartu tirtu ngakayarltirra ngarripayi. Palunyalu kirnara kutjarratjanulu-tjananya tirtu ngakayarltirranytja. ");
INSERT INTO ntj_vpl VALUES ("S117_17","010_17_17","1SA","17","17","19","Nyangka Tjatjilu watjarnu Tayipirrtu mirrka makatirra palunyaku kurta marnkurrku nintiltjaku tjiinya-ya warrmarlaku ngurrangka nyinarranyangka. Tjiinya ngaapirinypa watjarnu, “Mirrka-tjanampa makati nintila. Palunyalu tjapila. Palya-yayi nyinama? Nyangka-rni marlakulu pitja watjala.” ");
INSERT INTO ntj_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Nyangka ngarringu tjirnturringkula Tayipirrnga mungayurntura pakaralpi watjarnu wati kutjupalu-ra tjiipu miranykanyiltjaku. Palunyalu mirrka yurrara yanu palunyaku mamalu watjarnu wantingu, palunyangka. Palunyatjanu parrawaalkarrarnu nyangu warrmarla-ya ngalytjurrmara yirrira kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Nyangkalta-ya warrmarla Pilitjinyamartatji puru Yitjurayilku tjamupirti ngaparrku ngaralanytja pikakitja. ");
INSERT INTO ntj_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Nyangka Tayipirrtu mirrka parrakatingu nintirnu warrmarla nyarra mirrka kanyilpayiku. Palunyalu wantirra makukurraarnu nyarra pikaku-ya ngaralanytja, palunyalakutu. Parrawirrtjarnu palunyaku kurta-tjananya tjapirnu, “Palya-munta-yan nyinarra?” ");
INSERT INTO ntj_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Nyangka ngarala wangkarranyangkartu tjangara Kilayatjanya yartakarringkulalpi ngarala Yitjurayilku tjamupirti puru ngakayarltirranytja. Tjiinyakurlu watjala, palunyapirinypa. Nyangka Tayipirrtu kulirnu watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Nyangka-ya Yitjurayilku tjamupirtilu Kilayatjanya nyakula wantirra ngurlu kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Palunyalu-yanku watjaranytja, “Nyawa. Pururtu-lanya pitjangu ngakayarltirra.” ");
INSERT INTO ntj_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Nyangka Tayipirrtu watjarnu, “Yuwa-parta, wati ngaalu-lanya ngayunya ngarlpupirtira watjara Yitjurayilku tjamupirti? Kulila-ya. Ngayulu-lan Mama Kuurrnga mula-mularringkula kulilpayi. Nyangka-lanya wati nyarra yapu purnu pupakatirra marninypungkupayilu pitjangu ngarlpupirtira ngaanya-lan Mama Kuurrku warrmarla nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("S117_27","010_17_27","1SA","17","27","30","Tjinguru wati kutjupalu ngurlu wiyalu yankula wakanma.” Nyangka Tayipirrku kurta purlkanyalu kulirnu mirrparnarringkulalpi panypura-panypuralu watjaranytja. Nyangka Tayipirrtu kulirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Nyangka watilu-ya kulirnu Tayipirrtu watjaranyangka mapitjangu Tjuulta tjakultjunu. Nyangka witurnu yankula yarltirra katitjaku. ");
INSERT INTO ntj_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Nyangka mularrpartu Tayipirrtu pitjangu Tjuulta watjarnu, “Wiya puurr, tjinguru wati kutjupalu ngurlu wiyalu wati nyarra Pilitjinyamartatji yankula wakanma. Wiyangka-rna ngayulu yanku wakalku.” ");
INSERT INTO ntj_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Nyangka Tjuultu watjarnu, “Wiya wanti. Yaaltjilunykan wakalku? Nyuntulun wati kurlunypa. Nyangka tjangara palunyanya nintipuka. Yangupalalulpi tirtu wakalpayi.” ");
INSERT INTO ntj_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Nyangka Tayipirrtu watjarnu, “Wiya puurr, ngayulu-rna ngayuku mamaku tjiipu pirninya paalytjura kanyilpayi. Nyangka layinpa puru papa purlkanyalu-ya pitjala tjiiputarrartu patjara katiku. ");
INSERT INTO ntj_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","Nyangka-rna ngurlura wanalku wanangka pungku tjunku. Palunyalu tjiipu mantjira marlakulu katipayi. Nyangka layintu papalutarrartu-rniya patjalkitjangka-rna lirri mantjira pungkula mirrirntankupayi. ");
INSERT INTO ntj_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Tjiinya ngayulu-rna layinpa puru papatarrartu pungkula mirrirntaranytja. Palunyalu-rna tjangara nyarranya pungku mirrirntanku, tjiinyamarntu Mama Kuurrku warrmarla pirninya ngarlpupirtira watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Tjiinya Mama Kuurrtu-rni wankarura kanyilpayi layinta, papangkatarrartu. Palunyalu-rni kuwarrirtu wankarunku wati Pilitjinyamartatjingkatarra.” Nyangka Tjuultu watjarnu, “Wiya palya. Mama Kuurrtunta miranykanyira kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Nyangka Tjuultu-ra palunyaku warntu warrmarlalu kanyilpayinya nintirnu, puru katangka pupatjunkupayi witu-witunya puru pirlpirrtatja yayinpa. Nyangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Palunyalu Tjuulku kunmarnu wirrmira kalipiwanalu tjunu. Palunyalu mapitjakitjalu purtu paltjura kuliranytja. Tjiinyamarntu-lu warntu witu-witulu tjultjurntanu kanyiranytja. Nyangka Tayipirrtu watjarnu, “Wiya, purtu-rna pikaku yanku warntu ngaanyatjarra. Tjiinya-rna ngaapirinypa kutjuwarra kanyiranytjamunu, ngurrpa.” Palunyalu pirninyartu marlakulu yarraralpi tjunu. ");
INSERT INTO ntj_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Palunyalunku wana mantjirnu. Palunyalu mawirrtjarnu purli winturrpa 5-pa karrungkatja mantjiralpi yakutjangka tjarrpatjunu. Palunyalunku tjangari marangka kanyiranytja. Palunyalulta tjukarurru mapitjangu tjangara palunyalakutu. ");
INSERT INTO ntj_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Nyangka tjangara palunyanya ngamurringkula pitjangu Tayipirrtakutu. Nyangka wati nyarra tjara kanyilpayinya kurranyu pitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Nyangka pitjangu ngamurringkulalpi nyangu, “Wiya, ngaanya wati kurlunypa, tjuku-tjuku.” Nyangka Tayipirrnga ngarlpupirtira watjaranytja, ");
INSERT INTO ntj_vpl VALUES ("S117_43","010_17_43","1SA","17","43","44","“Nyaakun wana palanya kanyira? Papapirinypa-munta-rnin pungkukitja? Wiya, pitja-tju ngaatja. Nyangka-rnanta wakala mirrirntaralpi tjurlpuku papakutarrartu warni. Nyangkanta-yayi parnangka ngala.” Nyangka palunyaku tjukurrtatjawanalu Tayipirrnga yinitjuranytja. ");
INSERT INTO ntj_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Nyangka Tayipirrtu watjarnu, “Wiya, nyuntulu-rnin pitjangu pika wakalkitja kunmarnu kurlartatjarra. Nyangka-rnanta ngayulu pitjangu Mama Kuurrngatjarra. Tjiinyan palunyanyatarrartu ngarlpupirtira watjaranytja. Nyangka-rni yirringkara.” ");
INSERT INTO ntj_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Nyangka Tayipirrtu puru watjarnu, “Wiya, Mama Kuurrtu-rni nyuntunya yinytjanulu nintilku. Nyangka-rnanta mirrirntaralpi kata katapungku warniku. Palunyalu-tjananyarna warrmarla Pilitjinyamartatji wakalku mirrirntaralpi warniku wantiku. Nyangka-ya tjurlpulu puru papalutarrartu ngalku. Nyangkalta-ya ngurra lipiwanalu nintilu kuliku tjiinya Mama Kuurrnga ngarlpu-ngarlpu wiya, mularrpa. Tjiinya Yitjurayilku tjamupirtilu-latju pupakatirra marninypungkupayi, palunyanya mularrpa. ");
INSERT INTO ntj_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Nyangka-yan pirnilurtu nyaku tjiinya Mama Kuurrtu-lanyatju Yitjurayilku tjamupirti kurlartamaaltu yirringkanku. Tjiinya kutjupalu palunyaku warrmarla pirninya mirrirntankukitjamunu. Tjiinya palunyalu-tjananyanta pirninyartu ngayuku-lampatju yinytjanulu nintilku. Nyangka-latju pirninyartu-tjananyanta wakalku mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Nyangka Kilayatjanya Tayipirrtakutu puru ngamurringkula pitjangu. Nyangka Tayipirrnga waarrpungkula ngalyakukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Palunyalu purli yakutjangka mantjirnu tjangaringka tjarrpatjuralpi warnirrayirnu ngalyatarrka yaturnu punkatjingarnu. Nyangka yiikunguru punkarnu ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Tjiinya Tayipirrtu kunmarnumaaltu tjangaritjarralukutju Kilayatjanya yaturnu punkatjingarnu. ");
INSERT INTO ntj_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Palunyalu kukurraarnu katuku ngarangu. Palunyalu Kilayatjaku kunmarnu purlkanya mantjiralpi palunyaku kata katapungkulalpi mirrirntanu. Nyangka-ya wati Pilitjinyamartatjilu nyangu palunyaku-tjanampa tjangara purlkanya mirrirrinyangka-ya wantirra ngurlu kuku-kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Nyangkalta-tjananyaya wati Yitjurayilku tjamupirtilu payi-payira ngurlura wanarnu. Wakara-wanarayirnu-ya ngurra yungarrangka ma-tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("S118_1","010_18_1","1SA","18","1","4","Nyangka tjiinya Tayipirrtu Kilayatjanya-lu mirrirntanu. Palunyangka Tjuultu-lu watjarnu palunyaku ngurrangka tirtu nyinarratjaku. Nyangka mularrpartu nyinarranytja. Nyangka Tjuulku katja Tjanatjannga pukurlarringu-ra. Palunyalu mukulyanytjulu kanyiranytja. Nyangka-pulanku kalkurnu yamatjirra tirtu nyinakitjalu. Nyangka Tjanatjantunku kawutu yarrarnu Tayipirrku nintirnu. Puru palunyaku warntu warrmarlangkatjanya puru kunmarnu purlkanya, piltatarrartu-ra nintirnu. ");
INSERT INTO ntj_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Nyangka-ya ngurra kutjupa-kutjupanguru warrmarlara pitjalanyangka Tjuultu Tayipirrnga wituranytja warrmarla pirninya walara katirra pika-tjananya wakaltjaku. Nyangka mularrpartu yankula wakara wiyalpayi. Nyangkalta-lu Tjuultu watjarnu tjunu warrmarla pirniku puurrpa nyinarratjaku. Nyangka-ya warrmarlaku puurrpa pirninya puru yarnangu pirninya-ra pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Nyangka kutjulpirtu tjiinya Tayipirrtu Kilayatjanya pungu mirrirntanu. Nyangka-ya warrmarla pirninya marlaku ngurrakutu yanu. Mapitjalayirnu-ya, nyangka minyma pirnilu-ya yiwarla kutjupa-kutjupanguru pakara pitjangu puurrpa Tjuulnga mirara wanarayintja pitjalayinnyangka-ya. Palunyalu-ya pukurltu turlku yinkarra kanturanytja. Puru-ya turamu pungkula kitaatarrartu wangkatjingaranytja. ");
INSERT INTO ntj_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Tjiinya-ya turlku ngaapirinypa yinkarranytja, “Tjuultu pirni mirrirntanu. Nyangka Tayipirrtu minga-minga.” ");
INSERT INTO ntj_vpl VALUES ("S118_8","010_18_8","1SA","18","8","9","Nyangka Tjuultu kuliralpi tjuni kurrarringu. Palunyanguru Tayipirrnga tirtu nyakula parrawanarayintja. Tjiinya mirrparnarringkulalpi watjarnu, “Tjiinya-ya watjara ngayulu-rnanyu wati pirni mirrirntanu. Nyangkanyu Tayipirrtu minga-minga. Tayipirrnga-kulila-ya puurrpatarrartu tjunku.” ");
INSERT INTO ntj_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Nyangka tjirntungka Mama Kuurrtu mamu witurnu. Nyangka mularrpartu Tjuulta kurrutjarrparralpi kata kurrarnu nyangka wangka pirnirringu. Palunyalu nyakula kulira kutjupa-kutjupa watjalpayi. Nyangka tjiinya Tayipirrtunku kitaa nyinarra wangkatjingaranytja. Nyangka Tjuultu kurlarta marangka kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Palunyalu kulirnu, “Ngayulu-rna kuwarri ngalyanyinatjunku wakalku.” Nyangka mularrpartu kurlarta warningu wakalkitjangka tjirrkarnu. Nyangka puru warningu. Nyangka puru tjirrkarnu. Nyangka wuulpakutju wakarnu. ");
INSERT INTO ntj_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Tjiinya Tjuulnga-ra Tayipirrku ngurlurringkulanytja. Tjiinyamarntu kulirnu, “Wiya, Mama Kuurrtu-rni ngayunya wantirralpi palunyanyakutju kanyira.” ");
INSERT INTO ntj_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Palunyanguru Tjuultu watjarnu Tayipirrnga puurrarritjaku warrmarla 1,000-ku, palunyalu yankula pika wakaratjaku. Nyangka mularrpartu Tayipirrtu warrmarla pirninya-tjananya walara makatipayi pika-yanku wakaratjaku. ");
INSERT INTO ntj_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Palunyalu-tjananya wakara mirrirntaranytja tjiinyamarntu-lu Mama Kuurrtu yirringkara kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Nyangka Tjuultu nyangu Tayipirrtu walykumunura palyaranyangka. Palunyalu-ra ngurlu-ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Nyangka Yitjurayilku tjamupirti-ya Tayipirrku mukurringkupayi. Tjiinya puurrarringu warrmarla pirniku palunyalu walykumunura-tjananya walara katipayi. Nyangka-ya wakara wiyara pitjapayi. ");
INSERT INTO ntj_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Nyangka Tjuultu palunyaku katja Tjanatjannga puru palunyaku waarka palyalpayi pirninya watjarnu, “Kulila-ya. Tjinguru-rna watjalku kutjupalu yankula Tayipirrnga mirrirntankutjaku.” Nyangka tjiinya Tjanatjantu Tayipirrnga mukulyanytjulu kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Palunyalu pitjangu tjakultjunu, “Wiya, ngayuku mamalu tjumara watjara nyuntunyanta mirri pungkukitjalu. Nyangka kuliltjarra nyinama. Palunyalu yunguntjarra yarra purtingka kumpiralpi nyinama. ");
INSERT INTO ntj_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Nyangka-rna yanku Mamala lurrtjurriku nyarran kumpiralpi nyinanyangka, palunyangka ngamu. Palunyalu-rna nyuntunyatjarra watjanma. Nyangka-rni kutjupa-kutjupa watjaranyangka-rnanta pitjaku tjakultjunku.” ");
INSERT INTO ntj_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Nyangkalta-pula mularrpartu mamararra lurrtjurringu. Nyangka Tjanatjantu Tayipirrnga marninypungkulalpi watjarnu, “Nyaakun kulira Tayipirrnga mirri pungkukitjalu? Tjiinyanta kurrantjamaaltu tirtu yirringkara kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Puru tjiinya ngurlumaaltu yanu Kilayatjanya mirri pungu. Nyangka Mama Kuurrtu-lanya yirringkanu. Nyangka-lan yanyan-yanyanpa nyinapayi pirninya mirrirntara-wanarnu wiyarnu. Nyangkan nyakulalpi pukurlarringu. Palunyalun nyaaku kulira wati walykumunu mirrirntankukitjalu?” ");
INSERT INTO ntj_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Nyangka Tjuultu kuliralpi mula-mularringu Tjanatjantu watjaranyangka. Palunyalu wantirralpi watjarnu Tayipirrnga mirrirntankukitjamunu wantikitjalu. ");
INSERT INTO ntj_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Nyangkalta-lu Tjanatjantu Tayipirrnga yarltirralpi tjakultjunu. Palunyalu yarltirra katingu Tjuultakutu. Nyangkalta Tayipirrtu-ra waarka pururtu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Nyangka-ya wati Pilitjinyamartatji pururtu warrmarlara pitjangu pika wakalkitja. Nyangka Tayipirrtu warrmarla pirni walara katirralpi pirni-tjananya wakarnu mirrirntanu. Nyangka-ya kutjupatjarranya ngurlu kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Nyangka Tayipirrnga marlaku pitjangu Tjuulku ngurrangka nyinarranytja. Nyangka mamu palunyanya puru pitjangu Tjuulta kurrutjarrparralpi kanyiranytja. Nyangka Tayipirrtu nyinarra kitaa wangkatjingaranytja. ");
INSERT INTO ntj_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Nyangka Tjuultu kulirnu Tayipirrnga wuulta lurrtjura wakalkitjalu. Parturtu warningu wuulpakutju wakarnu murrutjunu. Nyangka Tayipirrnga tjirrkara wankarringkula pakara kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Nyangka mungarringkunyangka Tjuultu wati pirni witurnu yankula-ya Tayipirrku ngurrangka parrayangatjura kulyakanyira tjirntungka wakara mirrirntankutjaku. Nyangka Tayipirrku kurrilu kuliralpi ngurlutjunu watjarnu, “Wiya, nyuntukunku-ya ngurrira mirri pungkukitjalu. Nyangka mungangka kukurraara kutipitja.” ");
INSERT INTO ntj_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Palunyalulta purturru-ra wintanguru walatjunu. Nyangka witurrpungkula tjarungarala kumpira kukurraarnu. ");
INSERT INTO ntj_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Nyangka Tayipirrnga parrangaralayirnu wantirra marlaku yanu palunyaku yamatji Tjanatjantakutu. Palunyalu pitjangu tjapirnu, “Wiya, nyaatjanulu-rni nyuntuku mamalu kulira mirrirntankukitjalu? Kutjupa-kutjupa-munta-rna palyarnu?” ");
INSERT INTO ntj_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Nyangka Tjanatjantu watjarnu, “Wiya pumpa! Purtu-rnatju mula-mularringkula. Tjiinya ngayuku mamalu kutjupa-kutjupa kumpitjuranytjamunu, pirninyartu-rni watjara yartakankupayi. Wiya, nyuntunyanta mirri pungkukitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Nyangka Tayipirrtu watjarnu, “Wiya, nyuntuku mama ninti tjiinya-rnin mukulyanytjulu kanyilpayi. Palunyalu watjaranytjamaaltu kumpilpa wantirra. Tjiinya nyuntulun kulilku tjurlpilyarritjaku wantirra. Tjurrkurltu-rnanta watjara tjiinya nyuntuku mamalu-rni walykurtu-walykurtu mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Nyangka Tjanatjantu watjarnu, “Mularrpanta-tjinguru. Watjala-rni. Yaaltji-yaaltjilu-rnanta yirringkanku?” ");
INSERT INTO ntj_vpl VALUES ("S120_5","010_20_5","1SA","20","5","8","Nyangka Tayipirrtu watjarnu, “Tjingurun yanku nyuntuku mama tjarlpa tjapira pitjaku tjakultjunku.” ");
INSERT INTO ntj_vpl VALUES ("S120_12","010_20_12","1SA","20","12","15","Nyangka Tjanatjantu watjarnu, “Yuwa, yanku-rna tjarlpa tjapilku mularrkulilku. Nyangka-tjingurunku kalypa nyinarranyangka-rna kutjupa witulku pitjalanta watjaltjaku. Nyangka-tjingurunta tirtu kulira pungkula mirrirntankukitjalu. Nyangka-rna kutjupa witulku pitjalanta tjakultjunkutjaku. Nyangkan ninti nyinarralpi kumpira yanku.” Nyangka Tjanatjantu tirtu watjaranytja, “Yuwa, Mama Kuurrtunta miranykanyira kanyinma, tjiinya ngayuku mama miranykanyira kanyiranytja, palunyapirinypartu. Nyangka-tjinguru-rna wanka nyinama. Nyangka-rni wantinytjamaaltu tirtu miranykanyira kanyinma, tjiinyan Mama Kuurrta mirangka watjarnu wantingu, palunyatjanulu. Tjinguru-rna wiyarriku. Nyangka-tju wantinytjamaaltu ngayuku yungarrapirti miranykanyira kanyinma. Nyangka ngula Mama Kuurrtu yanyan-yanyanpa nyinapayi-tjananya mirrirntanku wiyannyangka tirtu-rni miranykanyira kanyinma, tjiinyan Mama Kuurrta mirangka watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("S120_30","010_20_30","1SA","20","30","31","Nyangka mularrpartu yanu palunyaku mama tjarlpa tjapirnu. Nyangka Tjuulnga mirrparnarringkulalpi watjarnu, “Nyaakun Tayipirrnga yirringkara? Kulira-muntan tjiinya Tayipirrnga wanka nyinarranyangkan nyuntulu ngurra ngaaku puurrarrikitjamunu? Waarrpungkula yarra yarltirra kati. Nyangka-rna puwa mirrirntarra.” ");
INSERT INTO ntj_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Nyangka Tjanatjantu watjarnu, “Wiya, nyaakunykan mirrirntanku? Kutjupa-kutjupa-munta palyaranytja?” ");
INSERT INTO ntj_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Nyangka Tjuultu kuliralpi kurlarta warningu Tjanatjannga nguwanpa wakarnu. Nyangka kulirnu, “Yuwa, mularrpa witu-witurringkula Tayipirrnga mirrirntankukitja.” ");
INSERT INTO ntj_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Nyangka mularrpartu Tjanatjannga pakara yanu Tayipirrta tjakultjunu. Nyangka-pulanku ngaparrkulu yampura yularrayirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Nyangka Tjanatjantu watjarnu, “Yuwa, Mama Kuurrtunta miranykanyira kanyinma. Tjiinya-linku ngaangkalpi kalkurnu yungarrapirti miranykanyira kanyilkitjalu. Nyangka Mama Kuurrtu-linya nyakula tjiinya-lin mayuratjakutarra.” Nyangkalta Tayipirrnga yanu. Nyangka Tjanatjannga marlaku yanu yiwarlakutu. ");
INSERT INTO ntj_vpl VALUES ("S121_1","010_21_1","1SA","21","1","6","Nyangka Tayipirrnga Tjuulku ngurlu pitjalayirnu parrapitjangu yiwarla kutjupaku, tiinti miirl-miirlpa ngaralanyangka. Palunyalu mirrka ngatjirnu wati nyarra tiinti miirl-miirlta palyalpayingka. Nyangka-ra nyuma miirl-miirlpa nintirnu mirrka kutjupa kanyintjamunulu. Tjiinya nyuma palunyanya miirl-miirlpa ngaralanytja. Ngarna wati nyarra tiinti miirl-miirlta waarka palyalpayilu-ya ngalku. Nyangka Tayipirrku nintirnu mirrka kutjupa kanyintjamunulu. ");
INSERT INTO ntj_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Nyangka Tayipirrtu wati palunyanya tjapirnu, “Kurlarta puru kunmarnu purlkanya-muntan kanyira nintilkitjalu-rnin? Tjiinya-rni puurrpa purlkanyalu watjarnu waarrpungkula-rna yankutjaku. Nyangka-rna mularrpartu waarrpungkula yanu, kunmarnu kurlarta mantjintjamaalpa.” ");
INSERT INTO ntj_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Nyangka wati palunyalu watjarnu, “Wiya, tjangara Kilayatjaku kunmarnu purlkanya ngaanya ngarrirra. Tjiinyan nyuntulu pungu mirrirntanu, palunyaku kunmarnu ngarrirra. Mukurringkulanytjalu mantjiranku kati. Yuwa, kunmarnu palunyanyakutju-rna kanyira.” Nyangka Tayipirrtu tjapirnu, “Yuwa, nintila-rni. Tjiinya kunmarnu kutjupa ngaapirinypa ngarrinytjamunurtu, ngaanyakutju.” Nyangka mularrpartu nintinnyangka mantjira yanu parrakumpira nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Nyangka Tjuultu Pilitjinyamartatji-tjananya pika pungkulayirnu marlaku pitjangu. Nyangka-luya watjarnu tjiinyanyu Tayipirrnga nyarra purtingka nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Nyangka Tjuultu wati 3,000-pa ngurrkarntanu. Palunyalu-tjananya yarltirra warrmarlara yanu Tayipirrku puru palunyaku wati pirniku ngurrilkitja. ");
INSERT INTO ntj_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Nyangka Tjuultu yiwarrawanalu mapitjalayirnu nyangu tjurnti purlkanya ngaralanytja tjiipuku yaarrpangka ngamurtu. Nyangka lapaturiku tjarrpangu. Nyangka tjiinya Tayipirrnga palunyaku wati pirnitjarra tjurnti palunyangkartu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Nyangka-ya wati pirnilu Tjuulnga nyakulalpi watjarnu, “Yala, kutjurringu nyinarranyangkalpi waarrpuwa puwa mirrirntarra.” Nyangka Tayipirrtu ma-panykarnu kawutu yankarla katapungu. Nyangka Tjuulnga ngurrpartu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Nyangka Tayipirrtu kurntarringkulalpi tirtu kuliranytja palyamunu palyantjatjanulu. ");
INSERT INTO ntj_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Palunyalu wati pirningka watjarnu, “Wiya, Mama Kuurrnga-rna tjapira tjiinya-rni marrkura kanyiratjaku kutjupa-kutjupa-rna palyamunu palyaltjakutarra. Tjiinya puurrpa ngaanya Mama Kuurrtu ngurrkarntanu. Nyangka-rnalu ngayulu pampulkitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Tjiinya palunyapirinypa watjaranytjalu Tayipirrtu-tjananya marrkurnu pungkutjamaaltu wantitjaku-ya. Nyangkalta Tjuulnga tjurntinguru pakara yanu. ");
INSERT INTO ntj_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Nyangka Tayipirrtu marlawanalu pakaralpi mirrangu watjarnu, “Puurr!” Nyangka Tjuultu parralarringu nyangu. Nyangka Tayipirrnga pupakatingu-lu tjiinya tirtu-lu puurrpa kuliranytjatjanu. ");
INSERT INTO ntj_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Palunyalu watjarnu, “Wiya, nyaaku-tjananyan yarnangu pirniku wangkaku mula-mularringkula kulira ngayulu-rnantanyu mirri pungkutjaku? ");
INSERT INTO ntj_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Tjiinya, kuwarrinya tjurnti kaninytjarra Mama Kuurrtu-rni nyuntunya yinytjanulu nintirnu. Nyangka-rniya wati pirnilu witu-witurnu tjiinya-rnanta mirrirntankutjaku. Nyangka-rnanku ngarlturringkulalpi watjarnu tjiinya-rnanta pampulkitjamunu. Tjiinyamarntunta Mama Kuurrtu ngurrkarntanu puurrpa purlkanyan nyinatjaku.” ");
INSERT INTO ntj_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Nyangka Tayipirrtu tirtu watjaranytja, “Wiya puurr, nyawa ngaanya-rnanku kawutu yankarlakutju katapungu. Tjinguru-rnanta pungkula mirrirntanama. Ngaanya-rna wantirralpi warntukutju katapungu. Nyangka ngaanguru kulinma tjiinya-rnanta nyuntula tungun-tungunarrikitjamunu. Puru-rna kulilkitjamunu nyuntunya-rna mirri pungkukitjalu. Wiya, nyuntulu-rnin kunpu-kunpu ngurlura parrawanarayirni mirri pungkukitjalu. Nyangka-rnanku kutjupa-kutjupa palyamunu palyantjamunurtu. ");
INSERT INTO ntj_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Tjiinya Mama Kuurrtunta nintilu nyakula palyamunun palyaranyangka. Palunyalunta ngaparrtjika pika pungku. Tjiinya-rnin kuliranytja mirrirntankukitjalu. Nyangka-rnanta ngayulu pampulkitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Nyangka Tayipirrnga wangkangu wiyarrinyangka Tjuultu watjarnu, “Ngarltutjarra. Mularrpa-muntan Tayipirrnga?” Palunyalu wantirralpi yularranytja. ");
INSERT INTO ntj_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Palunyalu watjarnu, “Yuwa, nyuntulun tjukarurru nyinarra. Nyangka-rna ngayunya palyamunurringu. Nyuntulu-rnin walykumunura kanyiranytja. Nyangka-rnanta ngayulu palyamunulu ngurlura parrawanarayintja mirri pungkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Tjiinya-rnin kuwarrinya nintitjunu walykumunun nyinarranytjalu. Yuwa, Mama Kuurrtu-rni nyuntuku yinytjanulu nintirnu. Nyangka-rnin ngarlturringkulalpi wantingu mirrirntankutjamaaltu. ");
INSERT INTO ntj_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Tjiinya wati kutjupalu wati yanyan-yanyanpa nyinapayi tjulyaralpi wanka walatjunkukitjamunu. Ngarna nyuntulu-rnin wanka walatjunu. Yuwa, Mama Kuurrtunta tirtu miranykanyira kanyinma tjiinyamarntu-tjun ngarlturringu, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Nyangka-rna nintilu kulira tjiinyan mularrpa Yitjurayilku tjamupirtiku puurrarringkulalpi puurrpa tirtu nyinama. ");
INSERT INTO ntj_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Nyangka-rni watjala wanti Mama Kuurrta mirangka tjiinyan ngayuku tjamu kaparlipirti mirrirntankutjamaaltu wantikitjalu.” ");
INSERT INTO ntj_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Nyangka mularrpartu Tayipirrtu Mama Kuurrta mirangka watjarnu wantingu-tjananya mirrirntankutjamaaltu wantikitjalu. Nyangkalta Tjuulnga marlaku yanu ngurrakutu. Nyangka Tayipirrnga-ya marlaku yanu yungarrangkartu kumpiralpi nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Nyangkalta Tjamiyulnga mirrirringu. Nyangka-ya Yitjurayilku tjamupirti pirninyartu pitjangu kapurturringkulalpi-raya yularranytja. Palunyalulta-ya pulpangka tjarrpatjunu palunyaku ngurrangka yitingka. ");
INSERT INTO ntj_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Nyangka tjiinya Tjamiyulnga mirrirringu. Nyangka-raya Yitjurayilku tjamupirti pirninya yularranytja. Palunyalu-ya pulpangka tjarrpatjunu palunyaku ngurrangka yitingka. Nyangka kutjulpirtu tjiinya Tjamiyulnga wanka nyinarranyangkalpi Tjuultu-tjananya payira-wanarayirnu wiyarnu, tjiinya yarnangu nyarra mirringka wangkapayinya puru ngalya yarlalu nyakula watjalpayinya. Nyangka-ya ngurra palunyanya wantirra ngurra kutjupakutu yanu. ");
INSERT INTO ntj_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Nyangka-ya Pilitjilanguru warrmarlara pitjangu ngamurringkulalpi ngurra tjunu. Nyangka Tjuultu Yitjurayilku tjamupirti yarltinyangka-ya warrmarlarringkula yanu purlingka ngurra tjunu. ");
INSERT INTO ntj_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Nyangka Tjuultu purlinguru nyangu Pilitjinyamartatji warrmarla-ya minga-minga nyinarranyangka ngurlu-ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Palunyalu Mama Kuurrnga tjapirnu, “Yaaltjinku-rna?” Nyangka Mama Kuurrnga-lu wangkanytjamunurtu wiyartu. ");
INSERT INTO ntj_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Nyangka Tjuultu palunyaku waarka palyalpayi pirninya watjarnu, “Yarra-ya ngurrila minyma kutju tjiinya mirringka wangkapayi. Palunyalu-rniya pitja watjala. Nyangka-rnayi kutipitja tjapila.” Nyangka-ya watjarnu, “Yuwa, minyma kutju yiwarla nyarrangka nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Nyangka mungarrinyangka Tjuultu warntu kutjupa tjarrpatjunu ngurrkarntankutjaku-luya. Palunyalu wati kutjarra yarltirra kutipitjangu minyma palunyalakutu. Palunyalu tjarrparralpi Tjuultu watjarnu, “Yuwa, yini-rna tjapilku. Nyangka-muntan mirri palunyanya watjalku pitjala yartakarritjaku?” ");
INSERT INTO ntj_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Nyangka minyma palunyalu watjarnu, “Wiya, Tjuulku wangka-muntan kulira? Tjiinya mirringka wangkapayi pirninya witurnu yankutjaku-ya. Nyangka-rnin ngarnartu pitjangu witu-witura tjiinya-rni Tjuultu pungkula mirrirntankutjaku.” ");
INSERT INTO ntj_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Nyangka Tjuultu watjarnu, “Wiya, tjurrkurltu-rnanta watjara Mama Kuurrta mirangka. Tjiinyan mirringka wangkaku, nyangkanta mirrirntankukitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Nyangka minyma palunyalu watjarnu, “Mirri ngananya-rnanku yarltiku?” Nyangka watjarnu, “Tjamiyulnga.” ");
INSERT INTO ntj_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Nyangka minyma palunyalu nyangu Tjamiyulnga ngalyapakaranyangka. Palunyalu mirrarralpi watjarnu, “Wiya, yarlamayurnu-rnin. Nyuntulun puurrpa Tjuulnga.” ");
INSERT INTO ntj_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Nyangka puurrpa Tjuultu-lu watjarnu, “Wiya, raparringkulalpi-rni watjala. Nyaapan nyakula?” Nyangka watjarnu, “Mirri-rna nyakula mantanguru ngalyapakara.” ");
INSERT INTO ntj_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Nyangka puru tjapirnu, “Nyaapirinypanyka?” Nyangka watjarnu, “Wiya, wati yirna ngalyapakara kawutu wirrmiratjarra.” Nyangka Tjuultu nintilu kulirnu tjiinya Tjamiyulnga pakaranyangka. Palunyalu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Nyangka Tjamiyultu tjapirnu, “Nyaaku-rnin wankarnu pakaltjingarnu?” Nyangka Tjuultu watjarnu, “Wiya, purtu-rna kulira. Warrmarla Pilitjinyamartatji-ya pitjangu ngayuku warrmarla pirninya wakalkitja. Nyangka-rna Mama Kuurrnga purtu tjapiranytja. Tjiinyamarntu-rni wantingu. Nyangka-rnanta nyuntunya tjapira watjaltjaku-rnin.” ");
INSERT INTO ntj_vpl VALUES ("S128_16","010_28_16","1SA","28","16","17","Nyangkalta Tjamiyultu watjarnu, “Nyangka nyaaku-rnin ngayunya yarltingu? Tjiinya Mama Kuurrtunta wantingu, wiyangkalpi watjarnu wantitjatjanulu. Tjiinyanta paanypungu puurrpa purlkanya nyinanytjamaaltu wantitjaku. Nyangkalta Tayipirrnga puurrpa purlkanya nyinama. ");
INSERT INTO ntj_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Kulila. Tjiinya ngaangkalpi Mama Kuurrtu mirrparnarringkulalpi watjarnu nyuntulu-tjananyan Yamalikiku tjamupirti pungkula wiyaltjaku, puru palunyaku-tjanampa yanamulpa pirninyatarrartu. Nyangkan kutjupa-kutjupa mirrirntankutjamaaltu wantingu. Palunyanguru Mama Kuurrtunku nyuntuku kuwarrinya palyamunu yartakara. ");
INSERT INTO ntj_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Yuwa, Mama Kuurrtunta nyuntunya puru Yitjurayilku tjamupirti yinytjanulu nintilku Pilitjinyamartatjilu-ya mirrirntankutjaku. Nyangka tjirntungka nyuntulu puru nyuntuku katja-yan mirrirringkulalpi ngayula lurrtjurringku.” ");
INSERT INTO ntj_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Nyangka Tjuultu wangka palunyanya kuliralpi ngurlu punkarnu mantangka ngarrirranytja. Puru tjiinya wawanyarringu mirrkamaalpa nyinarranytjatjanu. Tjiinya yunguntjarranguru mirrka ngalkunytjamaalpa nyinarrayirnu mungarringu. ");
INSERT INTO ntj_vpl VALUES ("S128_21","010_28_21","1SA","28","21","22","Nyangka minyma palunyalu pitjangu nyangu ngurluny-ngurlunypa ngarrirranyangka. Palunyalu watjarnu, “Kulila. Mirrka-munta-rnanku paalku nintilku yiwarra wirrmirangka yankutjaku?” ");
INSERT INTO ntj_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Nyangka Tjuultu paanypungu watjarnu, “Wiya, ngalkukitjamunu-rna.” Nyangka-pula wati kutjarralutarrartu witu-wituranytja ngalkutjaku. Nyangka Tjuultu wantirralpi pakarnu piirrpangka nyinakatingu. ");
INSERT INTO ntj_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Nyangka minyma palunyalu waarrpungkulalpi puluka warlangu pungu, tjiinya kanyirayirnu karnpi purlkantjatjanulu. Palunyalu purlakarra mantjiralpi nyuma tjalpu paarnu tjurltu-tjurltu wiya. ");
INSERT INTO ntj_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Palunyalu-tjanampa mirrka kuka parranintirnu. Nyangka-ya ngalkulayirnu parltjarringkula pakara munga palunyangkartu yanu. ");
INSERT INTO ntj_vpl VALUES ("S131_1","010_31_1","1SA","31","1","2","Nyangka-yanku warrmarla Pilitjinyamartatjilu puru Yitjurayilku tjamupirtilu pika wakaranytja. Nyangka warrmarla Pilitjinyamartatjilu-tjananyaya pika purlkanya wakaranyangka-ya ngurlu kukurraarnu. Nyangka Pilitjinyamartatjilu-ya ngurlura wanarayirnu wakarayirnu mirrirntanu wiyarnu. Puru-ya Tjuulku katja marnkurrngatarrartu wakarnu mirrirntanu, Tjanatjannga puru palunyaku marlanypa kutjarra. ");
INSERT INTO ntj_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Palunyalu-ya pika purlkanya wakaranytjalu Tjuulnga ngururrtjunu kanyiranytja. Palunyalu-ya Tjuulnga kurlartangka wakarayirnu wantinyangka pika purlkanya ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Palunyalu wati nyarra tjara katipayinya watjarnu, “Kunmarnu purlkanyanku mantjiralpi-rni wakala mirrirntarra tjiinya-rniya wati Pilitjinyamartatjilu panypuratjarralu mirrirntankutjaku.” Nyangka wati yangupalalunku ngurlurringkulalpi wantingu. Nyangkalta Tjuultu kunmarnu yungarranku mantjirnu tjuningka murrutjuralpi punkarnu. Palunyalulta mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Nyangka wati yangupala palunyalu nyangu Tjuulnga mirri ngarrirranyangka palunyalutarrartunku kunmarnu yungarra tjuningka murrutjuralpi punkarnu mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Nyangka tjiinya Tjuulnga, palunyaku tjara kanyilpayinya, puru Tjuulku katja marnkurrnga, puru Tjuulku warrmarla pirninya-ya mirrirringu tjirntu palunyangkartu wiyarringu. Yuwa, palunya.");
INSERT INTO ntj_vpl VALUES ("S21_1","011_1_1","2SA","1","1","2","Nyangka Tayipirrnga wati pirnitjarra pikatjanu marlaku pitjangu ngurrangka nyinarranytja. Palunyalu nyinangu ngurra kutjarratjanulu nyangu wati kutju waalkarrara pitjanyangka. Wati palunyanya warntu wartun-wartunpa puru kata mantapuru pitjanytja. Tjiinyanku tjuni kartalytju warntu wartunpungu puru kata mantatjunu. Palunyalu pitjangu Tayipirrnga nyakulalpi pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Nyangka-lu Tayipirrtu tjapirnu, “Yuwa, wanytjangurun pitjangu?” Nyangkanku watjarnu, “Wiya, ngurlu-rna kukurraarnu, nyarra Yitjurayilku tjamupirtilu-ya pika pungkulanytja, palunyanguru-rna pitjanytja.” ");
INSERT INTO ntj_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Nyangka Tayipirrtu tjapirnu, “Nyaarringu-ya?” Nyangka watjarnu, “Wiya, ngayuku-lampa warrmarlapirti-ya ngurlu kukurraarnu. Nyangka-tjananyaya ngurlura wanarnu kutjupatjarra pungu mirrirntanu. Puru Tjuulnga-pulanyaya Tjanatjannga pungu mirrirntanu.” ");
INSERT INTO ntj_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Nyangka Tayipirrtu kuliralpi warntunku wartunpungu. Nyangka-ya palunyaku wati pirnilutarrartu-yanku warntu wartunpungu. ");
INSERT INTO ntj_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Puru-ya mirrkamaalpa nyinarra yularrayirnu tjirntu tjarrpatjunu. Tjiinya-ya tjuni kartalypa nyinarranytja tjiinyamarntu Tjuulnga, Tjanatjannga, puru wati pirninyatarrartu wiyarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Nyangka Tayipirrtu Mama Kuurrnga tjapirnu, “Yaaltjirriku-latju? Tjinguru-latju marlaku kutipitjaku ngurra nyarra Tjuutalakutu. Palunyalu yiwarla kutjupangka nyinama.” Nyangka Mama Kuurrtu watjarnu, “Yuwa, marlaku-ya yarra nyinama.” Nyangka Tayipirrtu tjapirnu, “Ngurra wanytjangka?” Nyangka watjarnu, “Ngurra Yapuranta.” ");
INSERT INTO ntj_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Nyangka mularrpartu Tayipirrnga kurri kutjarratjarra pakara kutipitjangu Yapuranta nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Nyangka-ya wati nyarra Tayipirrnga wanalpayi pirninya kurri tjilkutarrartu lurrtjurringkula yanu ngurra palunyalawana parranyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Nyangka-ya wati Tjuutaku wartangkatja pirninya pitjangu Yapuranta lurrtjurringu. Palunyalu-ya uyilpa Tayipirrta katangka tjutiralpi watjarnu, “Nyuntunya-lampatjun puurrpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("S25_1","011_5_1","2SA","5","1","2","Nyangka Tayipirrnga-tjanampa Tjuutaku wartangkatja pirniku puurrpa nyinarranytja. Nyangka-ya liita kutjupa pirni Yitjurayilku wartangkatja pitjangu Tayipirrta lurrtjurringu. Palunyalu-ya watjarnu, “Yuwa, ngayulu-lan yungarrapirti nyinarra. Tjiinya kutjulpirtu Tjuulnga puurrpa nyinarranyangkalpi nyuntulu-lanyatjun pikaku walara parrakatirrayilpayi. Nyangka Mama Kuurrtunta watjarnu nyuntunya-lampatjun puurrpa ngula nyinarratjaku, tjiinya-lanyatjun tjiipu miranykanyira kanyilpayipirinytju miranykanyiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Wangkarra-ya kulirayirnu, nyangka Tayipirrtu palyarnkarrarnu puurrpa-tjanampa nyinakitjalu. Nyangka-ya watjarnu palunyaku wangka wangarnarralu kulira palyalkitjalu. Palunyalu-ya Tayipirrta katangka uyilpa tjutiralpi nyinatjunu pirnikurtu-tjanampa puurrpa nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Nyangka Tayipirrku kurli 30 ngaralanyangka puurrarringkulalpi nyinarrayirnu kurli 40-tjanu mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Tjiinya tawunpa Yapuranta Tjuutaku-tjanampa tjamupirtiku puurrpa nyinarrayirnu kurli 7-tjanu pakara yanu Tjurutjamala nyinarranytja. Palunyatjanu Yitjurayilku tjamupirti pirnikutarra puurrpa nyinarrayirnu kurli 33-tjanu mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Nyangka tjiinya-ya yarnangu kutjupa pirni Tjurutjamala nyinarranytja. Nyangka Tayipirrnga warrmarla pirnitjarra yanu yarnangu pirninya pungkula wiyara palunyalu tawunpa palunyanya yungarrarringkula kanyilkitja. Mapitjalayirnu-ya ngamurringkula parrapitjangu. Nyangka-ya yarnangu Tjurutjamala nyinapayilu mirrangu watjarnu, “Wiya, tjarrpakitjamunu-yan.” Tjiinyamarntu yaarrpa yaputjarra purlkanyalu yiwarla palunyanya yangatjura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S25_7","011_5_7","2SA","5","7","9","Nyangka-ya Tayipirrku warrmarla marnkurr-marnkurrpa yaarrpa kaninytjarrawana yarla ngaralanyangka ma-tjarrparra mapitjangu. Palunyalu-ya yarnangu pirninya pungu wiyarnu. Nyangka Tayipirrnga yiwarla palunyaku yungarrarringu. Palunyalu pakarnu yiwarla palunyangka tjarrparralpi nyinarranytja. Nyangka-ya palunyanguru pirnilu watjalpayi Tayipirrku yiwarla. ");
INSERT INTO ntj_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Nyangkalta Tayipirrnga puurrpa purlkanya nyinarranytja tjiinyamarntu Mama Kuurrtu-lu yirringkaranyangka. ");
INSERT INTO ntj_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Nyangka puurrpa ngurra kutjupangka nyinapayilu witurnu wati marnkurr-marnkurrpa mapitjala-ya Tayipirrnga walykumunu watjaltjaku. Puru-tjananya wati nyarra yiwarla palyalpayinya witurnu. Nyangka-ya warta purlkanya pirni katingu tjunu. Palunyalu-ya yiwarla walykumunu palyarnu Tayipirrnga nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Nyangka Tayipirrtu kulirnu, “Munta yuwa, Mama Kuurrtu-rni nyinatjunu Yitjurayilku tjamupirtiku puurrpa purlkanya-rna nyinatjaku. Nyangka-tjananyarnayi walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Nyangka-ya wati ngurra Pilitjinyamartatjilu kulirnu tjiinya Tayipirrnga puurrpa purlkanya nyinarranyangka. Palunyatjanu-ya warrmarlarringkula pakara yanu Tayipirrku parrangurriranytja pungkukitjalu. Nyangka Tayipirrtu kuliralpi warrmarla pirnitjarra yanu yapungka tatirnu nyinarranytja pitjala-luya pungkutjakutarra. ");
INSERT INTO ntj_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Nyangka-ya warrmarla Pilitjinyamartatji pirninya pitjangu karru-karrungka parranyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Nyangka Tayipirrtu Mama Kuurrnga tjapirnu, “Yanku-munta-latju warrmarla Pilitjinyamartatji pirninya pungku? Yirringkanku-munta-lanyatjun nyangka-latju palunyatjinnga pungku wiyalku?” Nyangka Mama Kuurrtu watjarnu, “Yuwa, yarra-tjananya puwa wiyala. Tjiinyamarntu-tjananyarnanta yirringkanku.” ");
INSERT INTO ntj_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Nyangka mularrpartu Tayipirrnga palunyaku warrmarla pirnitjarra yanu-tjananya pungkula ngurlutjingara wanarayirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Nyangka-ya warrmarla nyarra Pilitjinyamartatji pirni puru pitjangu karru-karru palunyangka parranyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Nyangka Tayipirrtu Mama Kuurrta tjapirnu, “Yaaltjingalku-latju?” Nyangka Mama Kuurrtu watjarnu, “Ngata-ngata-tjananya mapitjanytjamaalpa kutjupakampa parrapitja warta pirniwana kumpiralpi nyinakati. ");
INSERT INTO ntj_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Palunyalu-yan kulilku pirriyalu parrka yurritjingaranyangka. Palunyalu-yan pakaralpi pungkula ngurlutjingara wanarayinma. Nyangka-tjananyarnanta ngayulu yirringkanama lurrtjulu-lan pungkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Nyangkalta mularrpartu Tayipirrtu palunyapirinymanu. Palunyalu-tjananya warrmarla Pilitjinyamartatji pungkula ngurlutjingara wanarayirnu tiwa wantingu. ");
INSERT INTO ntj_vpl VALUES ("S26_1","011_6_1","2SA","6","1","2","Nyangka Tayipirrtu-tjananya palunyaku warrmarla pirninya yarltirralpi watjarnu yankula-ya Mama Kuurrku puuka miirl-miirlnga mantjira katitjaku. ");
INSERT INTO ntj_vpl VALUES ("S26_3","011_6_3","2SA","6","3","4","Tjiinya puuka palunyanya wati kutjuku yiwarlangka ngaralanytja. Nyangka Tayipirrku wangka kuliralpi wati palunyaku katja kutjarralu-pula puuka miirl-miirlnga mantjiralpi kaarrpangka tjunu. Nyangka puluka kutjarralu-pula kaarrpa palunyanya yilara katirrayintja. Nyangka katja kutjupanya kurranyu mapitjalayintja. Nyangka katja kutjupanya kaarrpa kantilywana mapitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Nyangkalta-ya Tayipirrtu puru Yitjurayilku tjamupirtilu pukurltu turlku yinkarra kantura wanarayintja. Puru-ya Mama Kuurrnga marninypungkulanytja. Nyangka-ya kutjupatjarralu kitaa puru tingki-tingki wangkatjingara pitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Pitjalayirnu-ya, nyangka-pula puluka kutjarranya mulyarlukatingu. Nyangka wati kutjulu mara wirrmirarringkulalpi puuka miirl-miirlnga witurrpungu. ");
INSERT INTO ntj_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Nyangka Mama Kuurrnga mirrparnarringkulalpi wati palunyanya pungu mirrirntanu tjiinyamarntu puuka miirl-miirlnga pampunnyangka. Nyangka mirrirringu puuka miirl-miirlta yitingkartu. ");
INSERT INTO ntj_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Nyangka Tayipirrnga mirrparnarringu tjiinyamarntu Mama Kuurrtu mirrparntu wati palunyanya pungu mirrirntankunyangka. ");
INSERT INTO ntj_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Nyangka Tayipirrnga Mama Kuurrku ngurluny-ngurlunyarringkulalpi kulirnu, “Yaaltji-yaaltjilu-rna puuka miirl-miirlnga katiku kutjupa-kutjupa yartakarritjakutarra?” ");
INSERT INTO ntj_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Palunyalu Tjurutjamalakutu katikitjalu wantingu. Palunyalu kiti-kitirringkula katingu tjunu wati kutjupaku yiwarlangka. ");
INSERT INTO ntj_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Nyangka Mama Kuurrtu-tjananya wati palunyanya puru palunyaku yungarrapirti walykumunura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Nyangka kirnara marnkurrtjanulu Tayipirrtu tjakulpa kulirnu tjiinya Mama Kuurrtu wati palunyanya walykumunura kanyiranytja puuka miirl-miirlnga kanyiranyangka. Palunyalu ngurra palunyakutu yanu puuka miirl-miirlnga mantjilkitja. Nyangka-ya yarnangu pirninya pukurlpa lurrtjurringkula yanu. ");
INSERT INTO ntj_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Nyangka-ya wati kutjarra-kutjarralu puuka miirl-miirlnga warta kutjarrangka tjitira katingu. Nyangka-tjananya Tayipirrtu watjarnu ngaratjaku. Nyangka-ya kuliralpi ngarangu. Nyangka Tayipirrtu puluka kutjarra pungkulalpi tilirnu Mama Kuurrku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("S26_14","011_6_14","2SA","6","14","15","Nyangka-ya pukurltu puuka miirl-miirlnga katurnu makatirrayintja ngurra nyarra Tjurutjamalakutu. Pukurlpa-ya mirrarranytja. Puru-ya turampirrpa pukurltu puura mirratjingaranytja. Nyangka Tayipirrtunku tjaarnpa yarraralpi lingkirrtu kantura Mama Kuurrnga marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Nyangka Tayipirrku kurri ngarnmanytjatjalu, tjiinya Tjuulku yurntalpa yini Mikalalu wintangurulu nyakulanytja. Palunyalu kata paarnarrarnu kuliranytja, “Yuwa-watjala, palya-munta palunyapirinypa, tjiinya puurrpa purlkanyalu pirningka mirangka kantultjaku?” ");
INSERT INTO ntj_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Nyangkalta-ya Mama Kuurrku puuka miirl-miirlnga katingu tjarrpatjunu tiinti nyarra Tayipirrtu tamarlmanu wantitjala. Nyangka Tayipirrtu puluka pirni pungkulalpi tilirnu Mama Kuurrku nintirnu. Puru puluka kutjupatjarra pungkulalpi paara parranintiranytja yarnangu pirniku. ");
INSERT INTO ntj_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Palunyalu wiyarringkulalpi-tjananya yarnangu pirninya watjarnu tjiinya Mama Kuurrtu-tjananya miranykanyira kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Nyangka-tjanampa kuka mirrkatarrartu nintiranytja. Nyangka-ya ngurra yungarra-yungarrakutu yanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Nyangka Tayipirrnga ngurraku yanu. Nyangka palunyaku kurri Mikalanya pakara ngata-ngata pitjangu. Palunyalu-lu panypurangkula watjaranytja, “Nyaakun tjaarnpa yarraralpi pirningka mirangka kanturanytja?” ");
INSERT INTO ntj_vpl VALUES ("S26_21","011_6_21","2SA","6","21","22","Nyangka Tayipirrtu watjarnu, “Wiya, ngayulu-rnatju pukurltu kantura Mama Kuurrnga marninypungkulanytja. Palunyalumarntu nyuntukunku mama puru kurtatarrartu wantirralpi ngayunya-rni ngurrkarntanu puurrpa-rna nyinarratjaku. Nyangka-rna tirtu kantura Mama Kuurrnga marninypungama. Nyangka-rnin wampaka panypurangkula watjanma.” ");
INSERT INTO ntj_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Nyangka Tjuulku yurntalpa Mikalanya tjilkumaalpa nyinarrayirnu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Nyangka puurrpa Tayipirrnga nyinarranytja palunyaku yiwarla walykumunungka. Nyangka-ya yarnangu kutjupa-kutjupa pirni nganyirri pitjapayinya wiyarringu. Tjiinyamarntu Mama Kuurrtu-tjananya marrkura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Nyangka wati yini Nayitjinnga tjiinya Mama Kuurrku wangka kulira tjakultjunkupayinya pitjangu Tayipirrta nyinarra wangkarranytja. Nyangka Tayipirrtu watjarnu, “Yuwa, ngayulu-rna yiwarla walykumunungka nyinarra. Nyangka Mama Kuurrku puuka miirl-miirlnga tiintingka ngarala. Kulira-rna tjurrtju purlkanya palyalkitjalu. Nyangkayi puuka miirl-miirlpa kaninytjarra ngarama.” ");
INSERT INTO ntj_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Nyangka Nayitjintu watjarnu, “Yuwa, palya. Tjiinya Mama Kuurrtunta yirringkara kanyira. Nyangkan palya palyalku palan kuliranytjalu.” ");
INSERT INTO ntj_vpl VALUES ("S27_4","011_7_4","2SA","7","4","5","Nyangka munga palunyangkartu Mama Kuurrtu-lu Nayitjinnga watjarnu yankula Tayipirrnga ngaapirinypa watjaltjaku, “Wiya wanti. Nyaaku-tjun tjurrtju purlkanya palyalku? ");
INSERT INTO ntj_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Tjiinyamarntu-rna tjurrtjungka nyinarranytjamunu wiyartu. Kutjulpirtu-rna nyuntuku tjamupirti Yiitjipulanguru walara parrakatirrayintja. Palunyalu-rna tjurrtjungka nyinarranytjamunu. Tjiinya-rna tiintingkakutju nyinarranytja. Palunyalu-rna tiintingka tirtu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Tjiinya-rna rawa parrapitjalayintja nyuntuku tjamupirtingka. Palunyalu-rna kutjuwarra tjapiranytjamunu tjurrtju-tjuya palyaltjaku.” ");
INSERT INTO ntj_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Nyangka Mama Kuurrtu Nayitjinta tirtu watjaranytja, “Yuwa, ngaapirinypa-lu Tayipirrnga watjala, ‘Yuwa, kutjulpirtu tjiinya nyuntulun mayu-mayu nyinarranytjalu tjiipu pirninya miranykanyira kanyiranytja. Nyangka-rnanta ngurrkarntanu puurrpan nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Palunyalu-rnanta ngurra kutjupa-kutjupakutu lurrtju yankulanytja. Tjiinya-rnanta yirringkankula kanyiranytja. Nyangka-tjananyan yanyan-yanyanpa nyinapayi pirninya pungkula wiyaranytja. Nyangkanta-ya yarnangu ngurra lipingkatjalu ngula mirrawarnima. ");
INSERT INTO ntj_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Tjiinya-rna ngurra ngaanya ngurrkarntaralpi-tjananyanta nyinatjunu wantingu. Kutjulpirtu-ya warrmarla nganyirri purlkalu tirtu pitjala-tjananyanta pika pungkulanytja. Nyangka palunyapirinypa tirtu ngarakitjamunu. Nyangka-yan ngurlumaalpa kurrurnpa rapa nyinama. Tjiinyamarntu-tjananyarnanta yangatjura kanyinma pikangkatarrartu. ");
INSERT INTO ntj_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Yuwa, nyuntulun katja pirni kanyilku. Nyangkan ngula wiyarrinyangka katja kutju-rna nyinatjunku puurrpa nyinarratjaku. Nyangka puurrpa purlkanya nyinama. ");
INSERT INTO ntj_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Nyangkalta katja palunyalu tjurrtju purlkanya ngayuku-tju palyalku wantiku. Nyangka-ya palunyaku tjamu marlangkatja-marlangkatja puurrpa tirtu nyinarra-wanarayinma. ");
INSERT INTO ntj_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Yuwa, nyuntuku katja-rna mamalupirinypa tirtu kanyinma. Nyangka-tju katjapirinypa nyinama. Nyangka-rnalu tjurrkurlmara kanyinma kutjupa-kutjupa palyaranyangka. Tjiinyakurlu mamalu katja tjurrkurlmara kanyinma, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Nyangka-rna wati palunyanya wantikitjamunu. Tjiinya-rnalu tirtu yirringkankula kanyinma. Kutjulpirtu-rna Tjuulnga ngurrkarntaralpi nyinatjunu puurrpa nyinarratjaku. Palunyalu-rnalu wantirralpi nyuntunya nyinatjunu. Nyangka-tjingurun kulira nyuntuku katja-rna palunyapirinypa wantiku. Wiya, wantikitjamunulu-rnalu tirtu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Nyangka-ya nyuntuku wartangkatjanya marlangkatja-marlangkatja marlawanartu tirtu puurrarringkula nyinarra-wananma.’” ");
INSERT INTO ntj_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Nyangka Nayitjintu kuliralpi yanu tjukurrpa palunyanya Tayipirrta watjarnu. ");
INSERT INTO ntj_vpl VALUES ("S27_18","011_7_18","2SA","7","18","19","Nyangkalta puurrpa Tayipirrtu kuliralpi yanu Mama Kuurrku tiintingka tjarrparralpi Mama Kuurrta watjarnu, “Yuwa, tjukurrpa walykumunu-rnin watjaranytja.” ");
INSERT INTO ntj_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Nyangka Tayipirrtu tirtu kuliranytja Tjuulku katja Tjanatjannga-ra wankalpi yamatji walykumunu nyinarranytja. Nyangka waarka palyalpayi kutju yarltirralpi tjapirnu, “Kutjupa-munta wanka nyinarra Tjuulku yungarrapirtingkatja? Tjiinya-rna kulira walykumunura kanyilkitjalu. Tjiinyamarntu-tju Tjanatjannga ngayuku yamatji walykumunu nyinarranytja.” ");
INSERT INTO ntj_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Nyangka mularrpartu yanu Tjuulku waarka palyalpayinya nyakulalpi witurnu Tayipirrtakutu yankutjaku. Nyangka mularrpartu yanu. ");
INSERT INTO ntj_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Nyangka puurrpa Tayipirrtu tjapirnu, “Kutjupa-munta Tjuulku yungarrapirtingkatja wanka nyinarra?” Nyangka watjarnu, “Yuwa, wati kutju wangulyara nyinarra. Tjiinya Tjanatjanku katja. Wati palunyanya wawanypa nyinapayi.” ");
INSERT INTO ntj_vpl VALUES ("S29_5","011_9_5","2SA","9","5","6","Nyangka Tayipirrtu waarka palyalpayinya witurnu yankula wati palunyanya yarltirra katitjaku. Nyangka mularrpartu yanu yarltirra katingu. Nyangka pitjangu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("S29_7","011_9_7","2SA","9","7","8","Nyangka Tayipirrtu-lu watjarnu, “Wiya, ngurlumaaltu-rni kulila. Nyuntuku mamalu-rni tirtu yirringkara kanyilpayi. Nyangka-rnanta kulira ngaparrtjika yirringkara kanyilkitjalu. Nyangkan tirtu pitjama ngayuku yiwarlangka tjarrparra lurrtjurringkula mirrka walykumunu ngalkukitja. Nyangka-rnanku nintilku manta nyarra nyuntuku tjamulu kanyilpayinya.” Nyangka wati palunyalu kuliralpi pukurlarringu. ");
INSERT INTO ntj_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Nyangka puurrpa Tayipirrtu Tjuulku waarka palyalpayinya yarltirralpi watjarnu, “Yuwa, ngurra nyarra Tjuultu kanyilpayinya-rnara nintilku wati wangulyaraku. ");
INSERT INTO ntj_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Nyangkan nyuntuku katjapirtitjarralu manta palunyanya tjawara mirrka tjunkula pakaltjinganma wati palunyaku yungarrapirtiku. Nyangka wati wangulyara tirtu pitjama ngayuku yiwarla walykumunungka lurrtjurringkula mirrka ngalkukitja.” ");
INSERT INTO ntj_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Nyangka Tjuulku waarka palyalpayilu watjarnu, “Yuwa, palunyapirinypa-rna palyalku nyuntulu-rnin watjannyangka.” Nyangka wati wangulyaralu Tayipirrku yiwarla walykumunungka tirtu tjarrparra lurrtjurringkula mirrka ngalkupayi. ");
INSERT INTO ntj_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Nyangka pirriya-pirriyarringu. Palunyangka-ya puurrpa pirninya warrmarlarringkula yankupayi. Nyangka Tayipirrtu wati kutju wiyarnu warrmarla pirni walara katitjaku. Palunyalu wantirralpi ngurrangka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Nyangka kutjupa tjirntu Tayipirrnga mungarrtji-mungarrtji kunkuntjanu pakarnu parrangaralanytja yiwarla katalarrawana. Palunyatjanulu walunyangu minyma kutju kapingka tjarrparranyangka. Tjiinya minyma palunyanya kuru mantjil-mantjilpa. ");
INSERT INTO ntj_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Nyangka Tayipirrtu palunyaku waarka palyalpayinya yarltirralpi tjapirnu, “Minyma yini ngananya nyarrangka nyinapayi? Yarra tjapila.” Nyangka mularrpartu yanu tjapira marlaku pitjangu watjarnu, “Wiya, minyma palunyanya yini Paatjipanya. Tjiinya wati yini Yurayiku kurri.” ");
INSERT INTO ntj_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Nyangka Tayipirrtu nintilu kuliranytja tjiinya Yurayinya warrmarlarringkula yanu. Palunyalu wati kutju witurnu yankula minyma palunyanya yarltirra katitjaku. Nyangka mularrpartu yanu yarltirra katingu. Nyangkalta-pula ngarringu. Nyangka minyma palunyanya pakara ngurraku yanu. ");
INSERT INTO ntj_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Palunyalu nyinangu mirarnu tjuni yulkapa-yulkaparringu. Palunyalu kutjupa wiyarnu mapitjala Tayipirrnga watjaltjaku. Nyangka mularrpartu mapitjangu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Nyangka Tayipirrtu kuliranytja minyma palunyangka ngarrinytjatjanulu kumpilpa-ra ngaralatjaku. Palunyalu wati kutju wiyarnu puurrpa nyarra warrmarla pirni kanyilpayilakutu. Nyangka mapitjangu watjarnu, “Yuwa, Puurrpa Tayipirrtu watjarnu wati nyarra Yurayinya palunyalakutu witultjaku.” Nyangka mularrpartu witurnu. ");
INSERT INTO ntj_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Nyangka Yurayilu kulira mapitjangu Tayipirrtakutu. Nyangka-lu tjapiranytja warrmarlaku-tjanampa puurrpa puru warrmarla pirninya puru pika pungkulanytjanya. Nyangka-lu tjuma pirni watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Nyangka Tayipirrtu kuliralpi watjarnu, “Yuwa palya, mapitja ngurraku mungarrinyangka.” Nyangka Yurayinya pakara yanu. Nyangka Tayipirrtu palunyaku waarka palyalpayinya watjarnu mirrka purlkanya yurrara makatitjaku Yurayiku ngurrakutu. Nyangka-ya yurrara makatingu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Parturtu Yurayinya ngurraku kutipitjanytjamaalpartu parrapitjangu puurrpa Tayipirrku yiwarlangka yilkaku ngarringu wati nyarra miranykanyira kanyilpayi pirningka. ");
INSERT INTO ntj_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Nyangka Tayipirrtu kuliralpi Yurayinya watjarnu, “Wiya, tjingurun rawatjanu yankula ngurrangka ngarrima.” ");
INSERT INTO ntj_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Nyangka Yurayilu watjarnu, “Wiya, wati pirninya-ya warrmarlarringkula yanu yilkaku tirtu ngarrirra. Nyangka Mama Kuurrku puuka miirl-miirlnga yilkaku tirtu ngarala. Kamu-rna ngurraku yanku kurringka ngarrikitja.” ");
INSERT INTO ntj_vpl VALUES ("S211_12","011_11_12","2SA","11","12","13","Nyangka Tayipirrtu watjarnu, “Kuwarripa nyina. Tjirntungka-rnanta marlaku witulku.” Nyangka mularrpartu nyinangu. Nyangka Tayipirrtu-lu yarltingu pitjala mirrka ngalkutjaku. Nyangka mularrpartu pitjangu lurrtjurringkulalpi ngalkula tjikiranytja. Nyangka Tayipirrtu wama purlkanya nintiranyangka tjikirayirnu kakirirringu. Parturtu Yurayinya ngurraku mapitjanytjamaalpa yanu warntu mantjiralpi kunkunarringu ngarrirranytja wati nyarra miranykanyilpayiku ngurrangka. ");
INSERT INTO ntj_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Nyangka ngarringu tjirnturringkulalpi Tayipirrtu lata walkatjuralpi nintirnu Yurayiku. Nyangka katingu warrmarla puurrku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("S211_15","011_11_15","2SA","11","15","16","Tjiinya-ya Tayipirrku warrmarla pirnilu yiwarla kutjupanya parrayangatjunu kanyiranytja. Nyangka-ya yiwarla yaarrpa katalarrangurulu kurlartangka warnirra wakaranytja. Nyangka warrmarla puurrtu lata palunyanya mantjirnu wirlkaralpi wangka ngaapirinypa nyangu, “Yuwa, Yurayinya witula kurranyu yankula ngaratjaku nyarra-ya pika purlkanya pungkula, palunyalakutu. Puru watjala nyangka-ya warrmarla kutjupatjarra marlaku pitja. Nyangka-yayi yiwarlangurulu kurlartangka warnirrayila wakala Yurayinya mirrirntala.” Nyangka warrmarla puurrtu lata nyakulalpi Yurayinya witurnu yankula yiwarla purlkakutu ngamu-ngamurritjaku. ");
INSERT INTO ntj_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Nyangka-ya warrmarla pirninya yiwarlanguru pakaralpi Tayipirrku warrmarla pirninya pika pungkulanytja. Palunyatjanu-tjananyaya Tayipirrku warrmarla kutjupatjarra pungu mirrirntanu. Yurayinyatarrartu-ya pungu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Nyangka warrmarla puurrtu wati kutju witurnu mapitjala Tayipirrta watjaltjaku. ");
INSERT INTO ntj_vpl VALUES ("S211_22","011_11_22","2SA","11","22","23","Nyangka mularrpartu yanu Tayipirrta watjarnu, “Wiya, warrmarla pirni-ya yiwarlanguru pakara pitjangu pika-lanyatju pungkula wanarnu yurirlkuturnu. Nyangka-latju pungkula marlaku kayirrpa purlkanyangka tjarrpatjuranytja. ");
INSERT INTO ntj_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Nyangka-ya yaarrpa katalarrangurulu kurlartangka warnirra wakaranytja. Palunyalu nyuntukunku warrmarla kutjupatjarra wakarnu mirrirntanu. Yurayinyatarrartu-ya wakarnu mirrirntanu.” ");
INSERT INTO ntj_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Nyangka Tayipirrtu kuliralpi watjarnu, “Wiya, warrmarla puurrpa watjala kurrurnpa raparritjaku. Tjiinyamarntu-yan warrmarlarringkula kutipitjangu. Nyangka-ya kutjupatjarra wiyarringkupayi. Nyangka-ya kutjupatjarranya wankarringkupayi. Watjala-tjananya tirtu-ya pika pungkula yiwarla tilira tjunkulatjaku.” ");
INSERT INTO ntj_vpl VALUES ("S211_26","011_11_26","2SA","11","26","27","Nyangka Yurayiku kurrilu kuliralpi kurritjirratja yularrayirnu ngurra 7-tjanu wiyarringu. Nyangka Tayipirrtu kulirnu tjiinya minyma palunyanya yularrayirnu wiyarrinyangka. Palunyalu kutjupa witurnu mapitjala minyma palunyanya yarltirra katitjaku palunyaku yiwarlakutu. Nyangka mularrpartu yarltirra katingu. Nyangkalta-lu Tayipirrtu yarltingu kanyiranytja. Nyangka-pula katja kanyirnu. Nyangka Mama Kuurrnga mirrparnarringu Tayipirrtu palunyapirinypa palyannyangka. ");
INSERT INTO ntj_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Nyangka Mama Kuurrtu wati yini Nayitjinnga witurnu yankula Tayipirrta wangkatjaku. Tjiinya wati palunyalu Mama Kuurrku wangka kulira watjalpayi. Palunyalu mularrpartu mapitjangu Tayipirrta watjarnu, “Yuwa, tjukurrpa ngaanya-muntan kulilku?” Nyangka Tayipirrtu yuwarnmanu. Nyangka Nayitjintu watjarnu, “Tjiinya wati-pula kutjarra nyinarranytja. Nyangka wati kutjulu walykumunu pirni kanyiranytja. Nyangka wati kutjupalu kurluny-kurlunypa kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Nyangka wati walykumunu pirnitjarralu puluka puru tjiipu pirni kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Nyangka wati nyarra yulytja kurluny-kurlunytjarralu tjiipu warlangu kutju payipungu. Palunyalu ngurrakutu katingu kaninytjarra kanyirayirnu purlkarnu. Nyangka palunyaku tjilku pirningka nyinarranytja. Palunyalu wati palunyaku mirrka ngalkulanytja puru palunyaku panikinta tjikiranytja. Puru yampungkatarra ngarripayi. Nyangka wati palunyalu yurntalpirinypa kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Nyangka wati maliki ngurra kutjupanguru pitjangu wati yulytja pirnitjarraku ngurrangka nyinarranytja. Nyangka wati palunyalu kulirnu, ‘Kuka-rnara witaralpi nintilku.’ Nyangka wati palunyalu palunyaku puluka puru tjiipu yungarranya wantirra yanu wati kutjupaku ngurrakutu. Palunyalu warlangu palunyanya mantjiralpi pungu. Palunyalu witaralpi wati malikiku nintirnu.” ");
INSERT INTO ntj_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Nyangka Tayipirrtu kuliralpi mirrparnarringu wati nyarra yulytja pirnitjarraku. Palunyalu watjarnu, “Wiya, wati palunyalu palyamunu palyarnu. Nyangka-tjinguru-ya pungkula mirrirntanama. ");
INSERT INTO ntj_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Tjiinya ngarltumaaltu-ra wati yulytja kurlunytjarraku tjiipu mantjiralpi pungu. Tjinguru-ra ngaparrtjika tjiipu kutjarra-kutjarra nintinma.” ");
INSERT INTO ntj_vpl VALUES ("S212_7","011_12_7","2SA","12","7","8","Nyangka Nayitjintu watjarnu, “Wiya, nyuntulun wati palunyapirinypartu nyinarra. Tjiinya Mama Kuurrtunta ngaapirinypa watjarnu, ‘Tjiinya-rnanta puurrpa nyinatjunu. Nyangka Tjuultunta ngurlura parrawanarayinnyangka ngayulu-rnanta wankarura kanyiranytja. Puru-rnanku kutjupa-kutjupa tirtu nintilpayi. ");
INSERT INTO ntj_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Nyangkan nyaaku ngayuku wangkaku tungun-tungunarringu? Nyaatjanulun palyamunu palyaranytja? Nyuntulun Yurayinya witurnu yankula mirrirritjaku. Puru palunyaku-ran kurri yarltingu kanyira. ");
INSERT INTO ntj_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Yuwa, nyuntulun palyamunu palyarnu. Palunyangka palyamunu tirtu ngarala-wanarayinma nyuntuku yungarrapirtikutarrartu. Tjiinyamarntun Yurayiku kurri mantjirnu yungarrarringu kanyira.’ Palunyapirinypa Mama Kuurrtu watjarnu.” ");
INSERT INTO ntj_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Nyangka Tayipirrtu watjarnu, “Yuwa, mularrpa-rna palyamunu palyarnu Mama Kuurrta mirangka.” Nyangka Nayitjintu watjarnu, “Yuwa, Mama Kuurrnganku kalyparringu. Nyangkan mirrirrikitjamunu. ");
INSERT INTO ntj_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Nyangkanku nyuntuku katja kurlunynga mirrirriku. Tjiinyamarntun nyuntulu Mama Kuurrku wangka tjalkirr-tjalkirrtu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Palunyanguru Nayitjinnga ngurraku yanu. Nyangka Tayipirrku-pulampa katja kurlunypa pikatjarrarringkulalpi walykunytjilpa ngarrirranytja, tjiinyamarntu Mama Kuurrtu-lu pampunnyangka. ");
INSERT INTO ntj_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Nyangka Tayipirrtu Mama Kuurrnga tjapiranytja tjilku-ra pampura wiirrultjaku. Palunyalu mirrka paanypungkulalpi ngalkunytjamaalpa tirtu nyinarranytja. Palunyalu mungarrinyangka yanu palunyaku ngurrangka tjarrparralpi mantangka tirtu wartungaralanytja. ");
INSERT INTO ntj_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Nyangka-ya palunyaku yamatji pirnilu pitjangu purtu watjaranytja pakara mirrka ngalkutjaku. ");
INSERT INTO ntj_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Nyangka tjilku palunyanya pikatjarra ngarrirrayirnu ngurra 6-tjanu ma-wiyarringu. Nyangka-ya Tayipirrku yamatji pirnilu tjakultjunkutjamaaltu ngurlulu wantirranytja. Palunyalu-yanku watjarnu, “Wiya, tjilku palunyanya pikatjarra ngarrirranyangka Tayipirrnga wangkamaalpa tirtu nyinarranytja. Palunyalu-lampa wangka kulira wantirranytja. Kamu-lan watjalku. Tjinguru-lan watjannyangka pakaralpi yungarralunku kutjupa-kutjupanku.” ");
INSERT INTO ntj_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Nyangka-tjananya Tayipirrtu kulirnu tjaalymara-ya wangkarranyangka. Palunyalu nintilurtu kuliranytja tjilku palunyanya wiyarrinyangka. Palunyalu-tjananya tjapirnu, “Wiyarringu-munta?” Nyangka-ya watjarnu, “Yuwa, wiyarringu.” ");
INSERT INTO ntj_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Nyangka Tayipirrnga pakaralpi kapingka tjarrpangu. Palunyalu pakaralpi mangka palyarnu walykumunurnu. Palunyalu warntu kutjupanya tjarrpatjuralpi yanu Mama Kuurrku tiintingka tjarrparralpi nyinarra Mama Kuurrta wangkarranytja. Palunyalu pakara marlaku pitjangu mirrka ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Nyangka-ya palunyaku yamatji pirnilu watjarnu, “Wiya, purtu-latjunta kulira. Tjiinya tjilku palunyanya wanka ngarrirranyangka nyuntulun yularranytja. Purun mirrka ngalkunytjamaalpa ngarrirranytja. Ngaanyan purrkutjarrarringkulalpi pakarnu mirrka ngalkula.” ");
INSERT INTO ntj_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Nyangka Tayipirrtu watjarnu, “Yuwa, tjilku pikatjarra ngarrirranyangka-rna yularranytja. Puru-rna mirrka ngalkunytjamaaltu wantirranytja. Tjiinyamarntu-rna kuliranytja, ‘Tjinguru-tju Mama Kuurrtu ngarlturringkulalpi tjilku pampulku wiirrulku.’ ");
INSERT INTO ntj_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Nyangka wiyarrinyangka nyaakunyka-rna mirrka wantima? Ngayulu-munta-rna tjilku palunyanya marlakulu wankalku? Wiya. Ngula-rnalu yanku ma-lurrtjurriku. Tjiinya tjilku palunyanya marlaku pitjakitjamunu ngayulakutu.” ");
INSERT INTO ntj_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Nyangka-lu Tayipirrtu palunyaku kurri Paatjipanya walykumunulu watjara pukurlmara kanyiranytja. Nyangka-pula ngurra ngarripayi. Nyangka Paatjipalu nyinarrayirnu tjilku katja kanyirnu. Nyangka Tayipirrtu tjapirnu yini Tjalamannga. Nyangka Mama Kuurrtu tjilku palunyaku pukurlarringkulalpi mukulyanytjulu kanyiranytja. Yuwa, palunya.");
INSERT INTO ntj_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Nyangka Tayipirrnga yirnarringkulalpi wiyarrikitja nyinarranytja. Palunyalunku katja yini Tjalamannga yarltirralpi watjarnu, ");
INSERT INTO ntj_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“Yuwa katja, kuwarri-kuwarri-rna wiyarriku. Nyangka kurrurnpa rapa nyinama. ");
INSERT INTO ntj_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Puru Mama Kuurrku wangka wangarnarralu kulira palyanma. Puru wangka nyarra Mawutjalu kutjulpirtu walkatjunu wantinytjanya kulira tjukarurrulu palyanma. Nyangkanku walykumunu ngarama. ");
INSERT INTO ntj_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Tjiinya Mama Kuurrtu-rni watjarnu ngayuku wartangkatja-ya marlangkatja-marlangkatja marlawanartu tirtu puurrarringkula nyinarra-wanarayiltjaku. Nyangka nyuntulun Mama Kuurrku wangka wangarnarralu kulira palyanma. Tjingurun palunyapirinypa palyaranyangka nyuntuku wartangkatja-ya tirtu puurrarringkula nyinarra-wanarayinma.” ");
INSERT INTO ntj_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Nyangka Tayipirrnga mirrirringu. Nyangka-ya mantjira katingu tjurnutjunu. ");
INSERT INTO ntj_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Tjiinya Tayipirrnga puurrpa rawa nyinarrayirnu kurli 40-tjanu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Nyangkalta Tjalamannga puurrarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Nyangka Tjalamannga kutipitjangu ngurra kutjupakutu. Palunyalu yanamulpa pirni pungkula tilira Mama Kuurrku nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Palunyalu ngarringu tjukurrtjunu Mama Kuurrtu-lu pitjangu watjaranytja, “Yuwa, watjala-rni. Nyaapirinypa-rnanku nintilku?” ");
INSERT INTO ntj_vpl VALUES ("K13_6","012_3_6","1KI","3","6","7","Nyangka Tjalamantu watjarnu, “Yuwa, ngayuku mama Tayipirrtu nyuntuku wangka tjukarurrulu kulira palyaranytja. Nyangka-lun ngarltunytjulu miranykanyira kanyiranytja. Palunyalu-rnin palunyaku katja nyinatjunu. Nyangka-rna marlawana puurrpa nyinarra. Palunyalu-rna yangupala kurlunytju purtu kulira yarnangu pirninya miranykanyira kanyilkitjalu. ");
INSERT INTO ntj_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Tjiinyamarntu-ya minga-minga nyinarra. ");
INSERT INTO ntj_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Nyangka-munta-rnin nintipukara kanyinma? Nyangka-tjananyarna walykumunura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Nyangka Mama Kuurrnga pukurlarringu palunyapirinypa tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Palunyalu-lu watjarnu, “Yuwa, walykumunu-rnin tjapirnu. Tjingurun tjapinma rawa nyinarrayira yirnarringkulalpi wiyarrikitjalu. Tjinguru-rnin tjapinma tjimarri purlkanya-rnanku nintiltjaku. Wiya, nyuntulu-rnin tjapirnu nintipukara-rnanta kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Nyangka-rnanta mularrpartu kanyinma nintipuka nyinarratjaku. Nyangkan ninti purlkanya nyinama, yarnangu pirningka munkarra. ");
INSERT INTO ntj_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Nyangka-rnanku puru kutjupa-kutjupa nintilku, tjimarri purlkanyatarrartu. Nyangkanta-ya yarnangu pirnilu marninypungkula watjanma tjiinyan puurrpa pirningka munkarra nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Nyangka-tjinguru-tjun wangka wangarnarralu kulira palyanma. Nyangka-rnanta tirtu miranykanyira kanyinma. Nyangkaltan rawa nyinarrayilku yirnarringkulalpi wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Nyangka Tjalamantu wankarringkulalpi kulirnu, “Munta! Mama Kuurrnga-rni wangkarranytja.” Palunyalu pukurlarringkula marlaku yanu Tjurutjamalakutu. Palunyalu yanamulpa pirni pungkula tilira Mama Kuurrku yungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Nyangka-pula minyma kutjarra pitjangu puurrpa Tjalamantakutu tjiinya-pulanya tjukarurrulu watjaltjaku. ");
INSERT INTO ntj_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Nyangka minyma kutjupalu watjarnu, “Wiya puurr, minyma ngaanya-litju yiwarla kutjungkartu nyinarra. Nyangka-rna tjilku katja kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Nyangka minyma ngaalu marla katja kanyirnu. ");
INSERT INTO ntj_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Palunyalu mungangka yurringu-yurringu tjilku puurntanu mirrirntanu. ");
INSERT INTO ntj_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Palunyalu pakaralpi ngayuku-tju tjilku mulyatarrirra katingu. Palunyalu tjilku mirrinya katingu ngayula-rni kunkunta ngarritjunu. ");
INSERT INTO ntj_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Nyangka-rna ngarringu tjirnturringkulalpi pakarnu mimi nintilkitjalu nyangu tjilku ngaanya mirri ngarrirranytja. Nyangka-rna mula-mularringkulalpi nyangu, ‘Wiya, tjilku ngaanya ngayuku wiya, kutjupa.’” ");
INSERT INTO ntj_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Nyangka minyma kutjupalu watjarnu, “Wiya, tjilku ngaa wankanya ngayuku-tju. Nyuntukunku tjilku wiyarringu.” Nyangka minyma nyarra kutjupalu watjarnu, “Wiya, nyuntukunku tjilku wiyarringu. Nyangka tjilku-tju ngayuku wanka.” Nyangka-pulanku tirtu ngaparrkulu watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("K13_23","012_3_23","1KI","3","23","24","Nyangka puurrpa Tjalamantu wati kutju witurnu yankula kunmarnu wirrmira mantjira katitjaku. Nyangka mularrpartu yanu mantjira katingu. ");
INSERT INTO ntj_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Nyangka puurrpa Tjalamantu watjarnu, “Yuwa, tjilku pala wankanya kati kartala kutjarrala. Nyangka minyma kutjupalu kultu kanyilku. Nyangka kutjupalu karilpa kanyilku.” ");
INSERT INTO ntj_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Nyangka ngunytju nyarra mularrtu watjarnu, “Wiya, kartantjamaaltu nintila minyma nyarraku.” Nyangka minyma nyarra kutjupalu watjarnu, “Yuwa palya, kartala kutjarrala.” ");
INSERT INTO ntj_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Nyangka puurrpa Tjalamantu watjarnu, “Palya wanti. Kartantjamaaltu nintila-ra minyma nyarra ngarltuwangkangu, palunyaku. Tjiinya palunyanya ngunytju mularrnga.” ");
INSERT INTO ntj_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Nyangka-ya yarnangu pirnilu tjuma palunyanya kuliralpi kata paarnarrarnu. Palunyalu-ya puurrpa Tjalamanku mula-mularringu. Tjiinya-ya nintilurtu kulirnu Mama Kuurrtu-lu nintipukara kanyiranyangka. Nyangka-tjananya yarnangu pirninya nintilu kulira watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("K15_1","012_5_1","1KI","5","1","5","Nyangka Tjalamantu wati tjukurrtjarra-tjananya wiyarnu yankula-ya puurrpa nyarra ngurra kutjupangka nyinapayila watjaltjaku. Nyangka-ya mularrpartu kutipitjangu tjukurrpa ngaapirinypa watjarnu, “Yuwa, ngayuku mamalu kuliranytja tjurrtju purlkanya Mama Kuurrku palyalkitjalu. Nyangka Mama Kuurrtu marrkuralpi watjarnu, ‘Wiya, nyuntulun palyalkitjamunu. Nyuntuku katjalu-tju ngula palyalku.’ Nyangka-rna kuwarrinya kulira tjurrtju palunyanya palyalkitjalu. Nyangka-yayi yarnangu pirnilu tjarrparra Mama Kuurrnga pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Nyangka nyuntulu-munta-lanyatjun yirringkanku? Tjingurun witulku waarka palyalpayi pirnilu-ya yankula warta purlkanya pirni kartara katitjaku ngayuku. Nyangka ngayulu-tjananyarna payipungku. Tjiinyamarntu-ya wartaku nintipukalu palyalpayi. Nyangka-ya ngayuku waarka palyalpayi pirninya lurrtjurringkula yanku kartalku.” ");
INSERT INTO ntj_vpl VALUES ("K15_7","012_5_7","1KI","5","7","7","Nyangka puurrpa palunyalu kuliralpi pukurlarringu. Palunyalu watjarnu, “Yuwa, puurrpa Tjalamantu walykumunu watjarnu.” ");
INSERT INTO ntj_vpl VALUES ("K15_8","012_5_8","1KI","5","8","8","Nyangka puurrpa palunyalu-tjananya witurnu marlakulu-ya yankula ngaapirinypa watjaltjaku, “Yuwa, nyuntuku tjukurrpa-rna kulirnu. Palunyalu-tjanamparnanku warta pirni nintilku tjiinyamarntu-rnin ngatjinnyangka.” ");
INSERT INTO ntj_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","Nyangka-ya mularrpartu waarka palyalpayilu warta pirni katingu ngarnmanymanu tjunu. Puru-ya yaputarrartu yurrarayirnu tjunu tjurrtju purlkanya palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("K16_1","012_6_1","1KI","6","1","10","Nyangka puurrpa Tjalamantu-tjananya waarka palyalpayi pirninya watjarnu tjurrtju purlkanya-ya palyaratjaku. Nyangka-ya mularrpartu wati mingapirinytju kutjurntara palyarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Nyangka Mama Kuurrtu Tjalamannga watjarnu, ");
INSERT INTO ntj_vpl VALUES ("K16_12","012_6_12","1KI","6","12","13","“Yuwa, tjiinya-tjun ngayuku wangka wuyurrtu kulira palyaranyangka-tjananyarnanta Yitjurayilku tjamupirtingka tirtu nyinama. Tjiinya-tjananyarnanta wantikitjamunu. Tjurrtju ngaangka-rna tirtu nyinaku nyinama.” ");
INSERT INTO ntj_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Nyangka puurrpa Tjalamantu wati tjukurrtjarra wiyarnu yankula-tjananya puurrpa pirni nyarra tjamu Yitjurayilku wartangkatja pirninya watjaltjaku, “Yuwa, pitja-rniya lurrtjurriwa Tjurutjamala.” ");
INSERT INTO ntj_vpl VALUES ("K18_2","012_8_2","1KI","8","2","2","Nyangka-ya mularrpartu pitjangu lurrtjurringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K18_3","012_8_3","1KI","8","3","4","Nyangka-ya wati nyarra tiinti miirl-miirlta waarka palyalpayilu puuka miirl-miirlpa tjitira katingu tjurrtju purlkanyakutu. Tiinti miirl-miirlpatarrartu-ya tjurrtjukutu katingu. ");
INSERT INTO ntj_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Nyangka puurrpa Tjalamannga puru yarnangu pirninya-ya lurrtjurringkulayirnu puuka miirl-miirlta ngamutja ngaralanytja. Nyangka-ya puluka pirni puru tjiipu pirni pungkula tilira Mama Kuurrku nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("K18_6","012_8_6","1KI","8","6","8","Nyangka-ya wati nyarra tiinti miirl-miirlta waarka palyalpayilu puuka miirl-miirlnga mantjira katingu tjurrtjungka ma-tjarrparralpi ngurra nyarra miirl-miirlpa purlkanyangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("K18_9","012_8_9","1KI","8","9","9","Tjiinya yapu walu kutjarra puuka miirl-miirlta kaninytjarra ngarripayi, yapu-pula nyarra Mama Kuurrku wangka 10-tjarranya. ");
INSERT INTO ntj_vpl VALUES ("K18_10","012_8_10","1KI","8","10","11","Nyangka watilu-ya puuka miirl-miirlnga tjunu wantirralpi pakarnu. Nyangka-ya nyangu yutuwari Mama Kuurrku tili purlkanyatjarra pitjangu tjurrtjungka tjarrpangu ngaralanytja. Nyangka-ya purtu marlaku tjarrpangu kutjupa-kutjupa palyalkitja. ");
INSERT INTO ntj_vpl VALUES ("K18_12","012_8_12","1KI","8","12","12","Nyangka Tjalamantu Mama Kuurrta watjarnu, “Yuwa Mama, nyuntulun tjirntu tjunu yilkaringka. Palunyalun watjarnu mungalurrta nyinakitjalu yutuwaringka. ");
INSERT INTO ntj_vpl VALUES ("K18_13","012_8_13","1KI","8","13","13","Nyangka-rnanku tjurrtju walykumunu palyarnu. Tjiinyanykayin tirtu nyinama.” ");
INSERT INTO ntj_vpl VALUES ("K18_14","012_8_14","1KI","8","14","14","Nyangka-ya yarnangu pirninya yilkaku ngaralanytja. Nyangka Tjalamantu parralarringu-tjananya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("K18_15","012_8_15","1KI","8","15","16","“Yuwa, Mama Kuurrnga-la marninypungama. Tjiinya ngayuku mama Tayipirrnga ngurrkarntanu puurrpa-lampa nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("K18_17","012_8_17","1KI","8","17","17","Nyangka ngayuku mamalu kutjulpirtu kalkurnu tjurrtju purlkanya palyalkitjalu. Nyangkanyka-layi tjarrparra Mama Kuurrnga pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("K18_18","012_8_18","1KI","8","18","18","Nyangka Mama Kuurrtu-lu watjarnu, ‘Yuwa, walykumunulun kulira tjurrtju purlkanya-tjun palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("K18_19","012_8_19","1KI","8","19","19","Kuwarripa wanti. Nyangka nyuntuku katjalu ngula palyalku. Nyuntulun palyalkitjamunu.’ Palunyapirinypa Mama Kuurrtu-lu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("K18_20","012_8_20","1KI","8","20","20","Palunyalu-rni ngayunyalpi Mama Kuurrtu puurrpa nyinatjunu. Nyangka-rnara mularrpartu tjurrtju purlkanya palyarnu. ");
INSERT INTO ntj_vpl VALUES ("K18_21","012_8_21","1KI","8","21","21","Nyangkalta kuwarrinya palunyaku puuka miirl-miirlnga tjurrtjungka ngarala.” ");
INSERT INTO ntj_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Nyangka-ya yarnangu pirnilu tirtu ngarala nyakulanytja. Nyangka Tjalamannga mapitjangu ngaralanytja waru nyarra kuka-ya tilira tjunkupayi, palunyangka. Palunyalu mara katuralpi ");
INSERT INTO ntj_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","Mama Kuurrta tjapiranytja, “Yuwa Mama, kutjupa nyuntunyapirinypa nyinarranytjamunu pupakatirra-latju marninypungkulatjaku. Nyuntulu-lanyatjun mukulyanytjulu tirtu miranykanyira kanyilpayi tjiinya-latju nyuntuku wangka wangarnarralu kulira palyaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","Nyangka Tjalamantu Mama Kuurrta tirtu tjapiranytja, “Mularrpa-muntan parnangka nyinama? Mularrpa-muntan tjurrtju ngaangka nyinama? Wiya, nyuntunyan purlkanya nyinarra yilkaringka munkarra. ");
INSERT INTO ntj_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Yuwa Mama, ngayulu-rnanku waarka palyalpayi. Kulila-rni ngayulu-rnanta kuwarrinya tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Tjurrtju ngaanya tirtu nyakuma. Palunyalu-rni kulinma tjurrtjukutu-rna ma-nyakula tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Yuwa, kulinma-lanyatju tjurrtjukutu-latju ma-nyakula tjapiranyangka. Yilkaringurulu-lanyatju kulinma. Tjiinya-latju kutjupa-kutjupa palyamunu palyalpayi. Nyangka-lampatju kalyparriwa.” ");
INSERT INTO ntj_vpl VALUES ("K18_35","012_8_35","1KI","8","35","35","Nyangka Tjalamantu tirtu tjapiranytja, “Yuwa Mama, tjinguru-latju nyuntuku katja yurntalpirtilu kutjupa-kutjupa palyamunu palyalku. Nyangka nyuntulu-tjingurun kapi marrkulku wantiku punkaranytjamaalpa ngaralatjaku. Nyangka-latju kulilku, ‘Wiya, palyamunu-latju palyaranytja.’ Palunyalu palyamunu pirninya wantiku. Palunyalu-latju tjurrtjukutu ma-nyakulalpi nyuntunya tjapilku. ");
INSERT INTO ntj_vpl VALUES ("K18_36","012_8_36","1KI","8","36","36","Nyangka-lampatjun yilkaringurulu kuliralpi kalyparriku. Palunyalu-lanyatju nintipungama tjukarurru-latju nyinarratjaku. Puru-lampatju kapi nintila. Nyangkayi ngurra walykumunurri ngarama.” ");
INSERT INTO ntj_vpl VALUES ("K18_37","012_8_37","1KI","8","37","37","Nyangka Tjalamantu tirtu tjapiranytja, “Yuwa Mama, tjinguru kurli purlkanyalu-lampatju mirrkatarrartu kampaku pikilku. Nyangka-tjinguru-ya tjintilyka pirnilu pitjaku mirrka ngalku wiyalku. Nyangka-tjinguru-latju yayilurru purlkanyangka nyinama. Puru-tjinguru-ya warrmarla pirnilu pitjaku yiwarla pirninya parrayangatjunku kanyinma. Puru-tjinguru-latju pirninyartu pika purlkarriku. ");
INSERT INTO ntj_vpl VALUES ("K18_38","012_8_38","1KI","8","38","39","Nyangka-tjinguru-latju wuyurrpa palyamunurringkulalpi kurntarringku. Palunyalu tjurrtjukutu ma-nyakulalpi nyuntunya tjapilku. Nyangka-lanyatju yilkari katalarranguru kulila. Kalyparriwa-lampatju palunyalu yirringkanama. ");
INSERT INTO ntj_vpl VALUES ("K18_40","012_8_40","1KI","8","40","40","Nyangkalta-latju nyuntunyakutju pupakatirra marninypungama. Palunyalu-latju nyuntuku wangka tirtu kulira palyanma.” ");
INSERT INTO ntj_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","Nyangka Tjalamantu tirtu tjapiranytja, “Yuwa Mama, malikilu-tjinguru ngurra kutjupangka nyinarranytjalu kulilku tjiinya nyuntulun yayirninytjulu kutjupa-kutjupa palyalpayi. Palunyalu-tjinguru ngurra ngaaku pitjaku tjurrtjukutu ma-nyakulalpi tjapilku. ");
INSERT INTO ntj_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","Nyangkan yilkari katalarranguru kulilku tjiinya kutjupa-kutjupaku tjapiranyangka. Nyangka-ya yarnangu kutjupa-kutjupalu parna lipiwana nyinarranytjalu nintirringkulalpi nyuntunyanta pupakatirra marninypungama.” ");
INSERT INTO ntj_vpl VALUES ("K18_52","012_8_52","1KI","8","52","52","Nyangka Tjalamantu tirtu tjapiranytja, “Yuwa Mama, ngayulu-rnanku nyuntuku waarka palyalpayi. Nyangka-ya Yitjurayilku tjamupirti nyuntuku nyinarra. Nyangka-tjinguru-latju tjapilku yirringkara-lanyatjun kanyiratjaku. Palunyangka-lanyatju kuliralpi yirringkara kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("K18_62","012_8_62","1KI","8","62","63","Nyangka Tjalamantu puru yarnangu pirnilu-ya puluka pirni tjiiputarrartu pungkula tilira nintiranytja Mama Kuurrku. Tjiinya-ya tjurrtju purlkanya miirl-miirlmanu Mama Kuurrku wantingu. ");
INSERT INTO ntj_vpl VALUES ("K18_65","012_8_65","1KI","8","65","66","Palunyatjanulu-ya rawalu nyinarra pukurltu kuka ngalkulanytja. Puru-ya Mamanya marninypungkulanytja. Nyangka ngurra pirnitjanulu Tjalamantu-tjananya witurnu ngurrakutu-ya yankutjaku. Nyangka-ya pakara pukurlpa kutipitjangu tjiinyamarntu Mama Kuurrtu-tjananya walykumunulu kanyiranyangka. ");
INSERT INTO ntj_vpl VALUES ("K19_11","012_9_11","1KI","9","11","11","Nyangka tjiinya Tjalamantu tjurrtju purlkanya palyarayirnu wiyarnu. Purunku yiwarla purlkanya palyarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K19_12","012_9_12","1KI","9","12","12","Palunyangka Mama Kuurrtu-lu mungangka pitjangu yartakarringkulalpi watjaranytja, “Yuwa, kulirnu-rnanta tjiinya-rnin tjapiranyangka. Nyangka-rna tjurrtju ngaanya tjunu ngayuku-tju kurrurnkulu ngaralatjaku. Nyangka-tjuyayi puluka tjiiputarrartu katirra tjurrtju ngaangka pungkula tilira nintinma. ");
INSERT INTO ntj_vpl VALUES ("K19_13","012_9_13","1KI","9","13","14","Nyangka-ya ngula-tjinguru ngayuku katja yurntalpirtilu palyamunu palyanma. Nyangka-tjinguru-rna kapi marrkulku wantiku punkantjamaalpa ngaralatjaku. Puru-tjinguru-rna tjintilyka pirninya wiyalku. Nyangka-ya mirrka-tjanampa ngalku wiyalku. Puru-tjinguru-tjananyarna yarnangu pirninya pikatjarralku. Palunyangka-tjinguru-ya ngayuku katja yurntalpirtilu palyamunu wantirralpi ngayulakutu pinkurraalku. Palunyalu-ya karnany-karnanypa nyinanytjamaaltu ngayunya-rniya tirtu tjapinma. Palunyangka-tjananyarna yilkaringuru kuliralpi kalyparriku. Palunyalu-tjanamparna ngurra marlakulu walykumunulku. ");
INSERT INTO ntj_vpl VALUES ("K19_15","012_9_15","1KI","9","15","15","Yuwa, tjurrtju ngaanya-rna tirtu nyakuma. Puru-tjananyarna kulilku tjiinya-rniya tjurrtju ngaangurulu tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("K19_16","012_9_16","1KI","9","16","16","Tjiinyamarntu tjurrtju ngaanya ngayuku-tju kurrurnkurlu ngarala. Nyangka-rniyayi pirnilu pupakatirra marninypungama. Nyangka-rna tjurrtju ngaanya tirtu miranykanyira kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("K19_17","012_9_17","1KI","9","17","17","Nyangka Mama Kuurrnga Tjalamanta tirtu wangkarranytja, “Yuwa, nyuntuku mama Tayipirrtu ngayuku wangka wangarnarralu kulira palyalpayi. Nyangka nyuntulu palunyapirinypartu palyanma. ");
INSERT INTO ntj_vpl VALUES ("K19_18","012_9_18","1KI","9","18","18","Palunyangka wati nyuntuku wartangkatja-ya ngurra ngaangka puurrpa tirtu nyinarra-wanarayinma. Tjiinya-rna Tayipirrnga palunyapirinypa watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("K19_19","012_9_19","1KI","9","19","19","Nyangka Mama Kuurrtu Tjalamanta tirtu watjara-wanarayintja, “Nyangka ngula-tjinguru-yan yarnangu pirnilutarrartu ngayuku wangka wantirralpi yapu warta kutjupa-kutjupatarrartu pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("K19_20","012_9_20","1KI","9","20","20","Nyangkalta-tjananyarnanta witura-wanalku wantinyangka-yan kutipitjaku tiwa nyinama. Nyangka-rna tjurrtju ngaanya wantiku. Nyangka-ya yarnangu kutjupa-kutjupalu pitjala yayirnirringkula watjanma, ‘Nyawa, nyaatjanulu Mama Kuurrtu wantingu nyangka-ya pitjangu tilirnu tjarrpatjunu?’ ");
INSERT INTO ntj_vpl VALUES ("K19_21","012_9_21","1KI","9","21","21","Tjiinya tjurrtju ngaanya kuwarrinya walykumunu ngarala. Nyangka-rna ngayulu wantinyangka yarnangu pirnilu-ya pitjaku nyaku kata paarnarraralpi watjalku, ‘Nyaatjanulu Mama Kuurrtu tjurrtju puru yarnangu pirninya wantingu?’ ");
INSERT INTO ntj_vpl VALUES ("K19_22","012_9_22","1KI","9","22","22","Nyangka-ya kutjupatjarralu watjanma, ‘Wiya, yarnangu pirnilu-ya Mama Kuurrnga wantirralpi yapu warta kutjupa-kutjupa pirni pupakatirra marninypungkulanytja. Palunyanguru-tjananya wantingu.’” Palunyapirinypa Mama Kuurrtu Tjalamanta watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Nyangka minyma ngaanya puurrpa purlkanya nyinarranytja ngurra yini Tjiipala. Palunyalu tjakulpa kulirnu puurrpa Tjalamannga nintipuka nyinarranytja. Palunyalu pakara yalatjarringkula yanu lurrtjurringkula kutjupa-kutjupa tjapilkitja. ");
INSERT INTO ntj_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Nyangka-ya palunyaku waarka palyalpayi pirni lurrtjurtu yanu. Tjiinya-ya kutjupa-kutjupa pirni kamurlta tjunkula kutipitjangu. Pitjalayirnu-ya Tjurutjamalakutu parrapitjangu. Nyangka minyma palunyanya pitjangu Tjalamanku yiwarlangka tjarrparralpi nyinarra kutjupa-kutjupa tjapiranytja. ");
INSERT INTO ntj_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Nyangka-lu tjuma pirninya watjara tjukarurrurayirnu wantingu. Kutjupa wantinytjamunurtu wiyartu. Wati kutjupalu-tjinguru kutjupa purtu kuliralpi wantima. Ngarna Tjalamantu pirnipurlka watjarnu yutirnu. ");
INSERT INTO ntj_vpl VALUES ("K110_4","012_10_4","1KI","10","4","5","Nyangka minyma palunyalu kuliralpi kata paarnarrarnu. Palunyalu kutjupa-kutjupa pirni nyakulalpi kata paarnarrarnu. Tjiinya nyangu Tjalamanku yiwarla purlkanya ngaralanytja. Puru nyangu palunyaku waarka palyalpayilu-ya warntu walykumunutjarralu mirrka walykumunu kukatarrartu parranintiranytja. ");
INSERT INTO ntj_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Nyangka-lu minyma palunyalu puurrpa Tjalamannga watjarnu, “Wiya, ngayuku ngurranguru-rna kulirnu nyuntunyan nintipuka nyinarranytja. Puru-rna kulirnu nyuntulun walykumunu pirni kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Palunyalu-rna purtu mula-mularringkulanytja. Ngarna-rna yungarralu nyakulalpi mula-mularringu. Tjiinya-rniya tjukurrpa kutjupa-kutjupa pirni watjara yutintjamunurtu. Tjiinyamarntu nyuntunyan nintipuka purlkanya nyinarra, tjiinya-rniya watjaranytja, palunyangka munkarra. Purun walykumunu pirni kanyira, tjiinya-rniya watjaranytja, palunyangka munkarra.” ");
INSERT INTO ntj_vpl VALUES ("K110_10","012_10_10","1KI","10","10","10","Nyangka minyma palunyalu kutjupa-kutjupa walykumunu puurrpa Tjalamanku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","Nyangka-ra ngaparrtjika walykumunu pirni nintirnu. Nyangka minyma palunyanya-ya pakara marlakurtu yanu ngurra yungarrakutu. ");
INSERT INTO ntj_vpl VALUES ("K110_23","012_10_23","1KI","10","23","23","Nyangka puurrpa Tjalamannga ninti purlkanya nyinarranytja, puurrpa pirningka munkarra. Puru kutjupa-kutjupa walykumunu pirni kanyiranytja, puurrpa pirningka munkarra. ");
INSERT INTO ntj_vpl VALUES ("K110_24","012_10_24","1KI","10","24","24","Nyangka-ya yarnangu pirni ngurra kutjupa-kutjupanguru mukurringkulanytja pitjala Tjalamannga kulilkitja. Tjiinyamarntu Mama Kuurrtu-lu nintipukara kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("K110_25","012_10_25","1KI","10","25","25","Nyangka-ya kutjupa-kutjupa walykumunu pirni katirra nintiranytja, tjilpa, kawurlpa, warntu, kurlarta puru parnti walykumununyatarrartu puru purni, tungkitarrartu. Tjiinya-ya kurli kutjupa kurli tirtu katirra nintilpayi. ");
INSERT INTO ntj_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Nyangka puurrpa Tjalamantu minyma maliki pirni mukurringkula yarltirranytja. ");
INSERT INTO ntj_vpl VALUES ("K111_2","012_11_2","1KI","11","2","4","Tjiinya Mama Kuurrtu kutjulpirtulpi watjarnu, “Maliki-ya yarltinytjamaaltu wantima. Tjiinya-tjinguru-tjananyantaya pinkurrtjingalku. Nyangka-yan yapu warta kutjupa-kutjupa pirni pupakatirra marninypungama. Palunyakutarrartu-ya maliki yarltinytjamaaltu wantima.” Nyangka Tjalamantu tungun-tunguntu minyma maliki pirni yarltirranytja. Nyangka-luya wuyurrpa kutjupanu. Nyangka yirnarringkulalpi minyma palunyaku-tjanampa yapu warta pupakatirra marninypungkulanytja. Tjiinyanku mama Tayipirrku yara wantingu. Tjiinya Tayipirrtu Mama Kuurrnga wantinytjamaaltu tirtu wanaranytja. ");
INSERT INTO ntj_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Mama Kuurrnga Tjalamanta kutjarrara yartakarringu. Palunyalu-lu yaka-yakarnu malikiku yapu warta pupakatirra marninypungkutjamaaltu wantitjaku. Nyangka Tjalamantu tungun-tunguntu pupakatirra marninypungkulanytja. Nyangka Mama Kuurrnga-ra mirrparnarringu. ");
INSERT INTO ntj_vpl VALUES ("K111_11","012_11_11","1KI","11","11","13","Palunyalu Tjalamannga watjarnu, “Wiya, nyuntulun tungun-tunguntu ngayuku wangka kulira wantirra. Palunyanguru-ya wati nyuntuku wartangkatja tirtu puurrpa nyinarra-wanarayilkitjamunu ngurra ngaa Yitjurayilta pirniwanartu. Tjiinya-rna ngurra ngaanya tjarralku. Nyangka-ya wati nyuntuku wartangkatjalu Tjurutjamalawanakutju tirtu puurrarringkulalpi kanyinma. Nyangka-rna ngurra purlkanya nyarra kayilinguru ngaralanytjanya kutjupaku nintilku. Yuwa, nyuntuku katja puurrpa nyinarranyangka palunyapirinypa yartakarriku.” ");
INSERT INTO ntj_vpl VALUES ("K111_42","012_11_42","1KI","11","42","43","Nyangka puurrpa Tjalamannga mirrirringu. Nyangka-ya tjurnutjunu palunyaku mamaku ngurrangka. Tjiinya Tjalamannga puurrpa nyinarrayirnu kurli 40-tjanu wiyarringu. Nyangka palunyaku katja Riyapawunya puurrarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K112_1","012_12_1","1KI","12","1","20","Nyangka puurrpa Riyapawulu watjarnu witu-witu nyinakitjalu. Nyangka-ya yarnangu nyarra kayilinguru nyinapayilu tungun-tungunarringkulalpi wati Tjirrapawunya puurrpa nyinatjunu, tjiinyamarntu Mama Kuurrtu watjannyangka. Nyangka puurrpa Riyapawulu yurlparirrakutju miranykanyira kanyiranytja ngurra nyarra Tjurutjamalawanakutju. ");
INSERT INTO ntj_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Nyangka puurrpa Tjirrapawulu ngaapirinypa kulirnu, “Tjinguru-ya yarnangu pirninya yanku Tjurutjamalakutu Mama Kuurrnga pupakatirra marninypungkukitja. Palunyanguru-tjinguru-rniya ngayunya wantirralpi mula-mularriku puurrpa Riyapawuku. Tjinguru-rniya ngayunyatarrartu pungku mirrirntanku.” ");
INSERT INTO ntj_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Nyangka puurrpa Tjirrapawulu watjarnu palunyaku waarka palyalpayilu-ya puluka kawurltjarra kutjarra palyara ngaratjunkutjaku. Nyangka-ya mularrpartu palyarnu ngaratjunu. Nyangka-tjananya puurrpa Tjirrapawulu yarnangu pirninya watjarnu, “Ngula-ya Mama Kuurrnga marninypungkukitja Tjurutjamalakutu yankutjamaaltu wantima. Puluka ngaanya-tjanampanku ngarala pupakatirra-yan marninypungkulatjaku. Puluka ngaa kawurltjarralu-tjananyanta ngurra nyarra Yiitjipulanguru walara katingu.” ");
INSERT INTO ntj_vpl VALUES ("K112_29","012_12_29","1KI","12","29","30","Nyangka mularrpartu-ya yarnangu pirnilu yankula puluka kawurltjarra kutjarranya pupakatirra marninypungkulanytja. Tjiinya-ya palyamunu mularrpa palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","Nyangka wati yini Yayipanya puurrarringu nyinarranytja. Palunyalu ngurra nyarra kayilinguru ngaralanytjanya miranykanyira kanyiranytja palunyaku mama wiyarrinyangka. ");
INSERT INTO ntj_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Nyangka Yayipanya Mama Kuurrta tungun-tungunarringu puurrpa pirningka munkarra. ");
INSERT INTO ntj_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Palunyalu kutjupa-kutjupa palyamunu palyaranytja, tjiinya puurrpa nyarra Tjirrapawula yarangka. Palunyalu kurri yini Tjatjipalnga yarltingu, puurrpa ngurra kutjupangkatjaku yurntalpa. Palunyalu kurringka minirringkulalpi tjukurrtatja yini Paralnga pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Tjiinya Yayipalu palyamunu palyaranytja, puurrpa pirni-ya nyinangu wiyarringu, palunyatjinta munkarra. Nyangka Mama Kuurrnga-ra mirrparnarringu. ");
INSERT INTO ntj_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Nyangka wati yini Layirrtjanya nyinarranytja tjiinya Mama Kuurrku wangka kulira tjakultjunkupayinya. Palunyalu yanu puurrpa Yayipanya watjarnu, “Yuwa, Mama Kuurrtu-rni watjarnu pitjala-rnanta tjukurrpa ngaapirinypa watjaltjaku. Ngurra ngaanya yayilurru purlkanya rawa ngarama. Tjiinya kapi punkalkitjamunu. Ngarna-rna ngayulukutju watjannyangka kapi puru punkalku.” ");
INSERT INTO ntj_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Nyangka Mama Kuurrtu-lu Layirrtjanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("K117_3","012_17_3","1KI","17","3","4","“Yuwa, pakara kutipitja pitjalayila tiwa kumpiralpi nyinama. Karrungka yitingka ngurra tjurra. Palunyalun kapi karrungkatja tjikinma. Tjiinya-rna watjarnu kaarnkalu-ya mirrka kukatarrartu katirra nintiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Nyangka mularrpartu Layirrtjanya warntu karrpira kutipitjangu. Pitjalayirnu karrungka yitingka nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Palunyalu kapi karrungkatja tjikiranytja. Nyangka-ya kaarnkalu mirrka kukatarrartu katirra nintiranytja. Yunguntjarra mungarrtjitarrartu-ya tirtu katirra nintilpayi. ");
INSERT INTO ntj_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Nyangka Layirrtjanya nyinarrayirnu, nyangka kapi karrungkatjanya ngarringu wiyarringu. Tjiinyamarntu kapi punkantjamaalpa tirtu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Nyangka Mama Kuurrtu Layirrtjanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Yuwa, pakara mapitja ngurra kutjupangka nyinama. Tjiinya-rna minyma parnaltji ngurrkarntanu mirrkanku palyara nintiratjaku.” ");
INSERT INTO ntj_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Nyangka mularrpartu pakara yanu ngurra palunyakutu. Mapitjalayirnu ngurra palunyangka ngamurringkulalpi nyangu minyma parnaltjilu ngarala waru yurraranyangka. Nyangka-lu Layirrtjalu ngatjirnu, “Kapi-rni kati nintila.” ");
INSERT INTO ntj_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Nyangka mularrpartu mapitjangu tjutira katikitja. Nyangka-lu watjarnu, “Mirrka tampatarrartu-tju kati.” ");
INSERT INTO ntj_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Nyangka minyma palunyalu watjarnu, “Wiya, tampa wiyartu-rna. Purlakarra-tju kurlunypa ngarrirra. Waru ngaanya-rna mantjira mapitjaku tiliralpi mirrka witalku. Nyangka-litju katjararralu kutjuwarra ngalkulalpi nyinaku parltjatjirratja wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Nyangka Layirrtjalu watjarnu, “Wiya, palunyapirinypa kulintjamaaltu wanti. Ngarnmanytju tampa kurlunypa witara kati-rni nintila. Palunyalunku kurlunypa witaralpi marla-pula ngala. ");
INSERT INTO ntj_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Tjiinya Mama Kuurrtu watjarnu wantingu nyuntukunku mirrka wiyarrikitjamunu tirtu ngarrirrayilku ngarrima. Nyangka Mama Kuurrtu-lampa kapi nintilku.” ");
INSERT INTO ntj_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Nyangka minyma palunyalu ngurraku yankulalpi palunyapirinypa palyarnu. Nyangkalta-ya marnkurrtu tirtu ngalkula parltjarringkulanytja. ");
INSERT INTO ntj_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Nyangka purlakarra palunyanya wiyarringkutjamaalpa tirtu ngarrirranytja, tjiinyamarntu Mama Kuurrtu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Nyangka minyma palunyaku katja pikatjarrarringu. Pika purlkanya ngarrirrayirnu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Nyangka minyma palunyalu Layirrtjanya watjarnu, “Wiya, nyaatjanungka-rni Mama Kuurrtu purrkutjarrarnu? Nyuntulu-muntan watjarnu ngayulu-rna kutjupa-kutjupa palyamunu palyaranytja? Nyangka-rni purrkutjarrarnu?” ");
INSERT INTO ntj_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Nyangka Layirrtjalu watjarnu, “Tjilku palunyanya-rni kati nintila.” Nyangka mularrpartu katingu Layirrtjaku nintirnu. Nyangka yampura katingu palunyaku ruumkutu. Palunyalu tjilku ngarritjuralpi ");
INSERT INTO ntj_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Mama Kuurrta tjapirnu, “Wiya Mama, nyaatjanungkan minyma ngaanya purrkutjarrarnu? Tjiinya-rni walykumunulu mirrka nintira kanyiranytja. Nyangka-lun purrkutjarrarnu.” ");
INSERT INTO ntj_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Nyangka Layirrtjanya tjilku palunyangka katalarra ngampalngarangu. Palunyalu Mama Kuurrta tjapirnu, “Yuwa Mama, tjilku ngaanya-lu wankala.” Nyangka pururtu pakaralpi tjilku palunyangka ngampalngaralalpi puru tjapirnu. Nyangka puru pakaralpi tjilku palunyangka ngampalngarala tjapiranytja. ");
INSERT INTO ntj_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Nyangka Mama Kuurrtu-lu kulirnu Layirrtjalu tjapiranyangka. Nyangka tjilku palunyanya mularrpartu wankarringkulalpi ngaalymaranytja. ");
INSERT INTO ntj_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Nyangka Layirrtjalu tjilku palunyanya yampura katingu palunyaku ngunytjukutu. Palunyalu watjarnu, “Nyawa. Tjilkunku wankarringu.” ");
INSERT INTO ntj_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Nyangka minyma palunyalu watjarnu, “Yuwa, kuwarrinya-rna kulira tjiinyan nyuntulu Mama Kuurrku wangka tjurrkurltu kulira tjakultjunkupayi.” ");
INSERT INTO ntj_vpl VALUES ("K118_1","012_18_1","1KI","18","1","2","Nyangka ngurra palunyanya kapi wiya rawa ngaralayirnu ngaralanytja. Nyangka kurli marnkurrtjanulu Mama Kuurrtu Layirrtjanya watjarnu, “Yuwa, kutipitja nyawa puurrpa Yayipanya. Nyangka-tjanamparnanku ngayulu kuwarri-kuwarri kapi nintilku.” Nyangka mularrpartu Layirrtjanya kutipitjangu puurrpa Yayipala lurrtjurrikitja. ");
INSERT INTO ntj_vpl VALUES ("K118_3","012_18_3","1KI","18","3","15","Palunyalu pitjalayirnu nyangu puurrpa Yayipaku waarka palyalpayilu parrangarala yukiriku nyakulanytja. Tjiinya-yayi purnilu tungkilu pitja ngala. Nyangka Layirrtjalu watjarnu, “Yuwa, kutipitja puurrpa Yayipanya watjala ngayulu-rna pitjalayinnyangka.” ");
INSERT INTO ntj_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","Nyangka mularrpartu-lu yanu watjarnu. Nyangka Yayipanya pakara ngata-ngata pitjangu ");
INSERT INTO ntj_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Layirrtjala lurrtjurringkulalpi watjarnu, “Yuwa-parta, pitjangun yartakarringu? Nyuntulun ngurra ngaanya kurraralpi kuwarrinyakutju pitjangu yartakarringu.” ");
INSERT INTO ntj_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Nyangka Layirrtjalu watjarnu, “Wiya, ngayulu-rna ngurra ngaanya kurrantjamaalpartu. Nyuntulu-yan kurrarnu. Tjiinyamarntu-yan Mama Kuurrku wangka wantingu. Palunyalu tjumangkatja yini Paralnga warlkura marninypungkula. ");
INSERT INTO ntj_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Yuwa, yarnangu pirninya-tjananya watjala pitjala-rniya lurrtjurritjaku yapu nyarra Kaamulta. Puru Paralku waarka palyalpayi pirninya yarltirra kati.” ");
INSERT INTO ntj_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Nyangka mularrpartu-tjananya yarnangu pirninya yarltirra katingu. Nyangka-ya yanu Layirrtjala lurrtjurringu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Nyangka-tjananya Layirrtjalu watjarnu, “Wiya, tirtu-munta-yan kutjarra-kutjarra kulira? Nganalunyka yayirninytjulu kutjupa-kutjupa palyalpayi? Paraltu-munta? Wiya, Mama Kuurrtu yayirninytjulu palyaranyangka wananma-la.” Nyangka-ya yarnangu pirninyartu kanmanarringu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Nyangka Layirrtjalu watjarnu, “Wiya, Mama Kuurrnga wanalpayi pirninya-ya wiyarringkula-wanarnu. Nyangka-rna ngayulu kutjurringu nyinarra. Parturtu-ya wati pirni 450-lu Paralku waarka palyara. ");
INSERT INTO ntj_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Yuwa, puluka marnti kutjarra-ya kati. Nyangka-ya Paralku waarka palyalpayilu kutju pungkulalpi katapuwa tjurra nyarra waru tilira tjunkupayila. Palunyalu tilintjamaaltu wanti. Nyangka-rna ngayulu kutjupanya palunyapirinymaralpi tjunku. ");
INSERT INTO ntj_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Nyangka-ya Paralku waarka palyalpayilu Paralnga tjapilku. Nyangka-rna ngayulu Mama Kuurrnga tjapilku. Nyangka-lan nyaku, ‘Nganalunyka kuliralpi tjaarrtjingalku?’” Nyangka-ya pirnilurtu watjarnu, “Wiya, palya.” ");
INSERT INTO ntj_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Nyangka Layirrtjalu Paralku waarka palyalpayi-tjananya watjarnu, “Yuwa, nyuntulu-ya kurranyulu palyala. Puluka kutju-ya pungkulalpi kartala murtuny-murtunymaralpi tjurra. Palunyalu waru tilintjamaaltu wanti. Palunyalu Paralnga tjapila.” ");
INSERT INTO ntj_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Nyangka-ya mularrpartu puluka pungkulalpi katapungu tjunu. Palunyalu-ya parrakantura tjapiranytja tjiinya Paraltu-tjanampa tililtjaku. Mirrarra-ya tjapiranytja, “Paral, kulila-lanyatju.” Palunyalu-ya tirtu mirrarra tjapirayirnu tinarringu. Nyangka-tjanampa waru tjaarrantjamaalpartu wiyartu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Nyangka-tjananya Layirrtjalu ngarlpupirtira watjaranytja, “Wiya, lingkirrpa-ya mirra. Paralnga-tjinguru yalatja kutipitjangu. Tjinguru kunkunpa ngarrirra. Lingkirrpa-ya mirrarralpi kanala.” ");
INSERT INTO ntj_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Nyangka-ya tirtu mirrarra lingkirrtu tjapiranytja. Puru-yanku kunmarnungka yungarralu katapungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Kantura-ya mirrarrayirnu mungarrtjirringu. Nyangka-tjanampa waru tjaarrantjamaalpartu wiyartu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K118_30","012_18_30","1KI","18","30","32","Nyangka Layirrtjalu-tjananya yarnangu pirninya yarltingu, “Yuwa, ngamurringkula-ya pitja.” Nyangka mularrpartu-ya ngamurringkula pitjangu. Nyangka Layirrtjalu yapu 12-pa mantjiralpi parratjunkulayirnu katurnu. Palunyatjanulu pirti purlkanya yapuwanartu parratjawarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("K118_33","012_18_33","1KI","18","33","35","Palunyatjanulu waru mantjiralpi yapu katalarra tjunu. Palunyalu puluka pungkulalpi katapungu murtuny-murtunymanu tjunu. Palunyalu-tjananya yarnangu pirninya watjarnu, “Yuwa, yarra-ya kapi purlkanya tjutira kati. Palunyalu kukawanalu puru waruwanalu parratjutila.” Nyangka mularrpartu-ya kukurrmara katirra tjutiranytja. Nyangka kuka puru warutarrartu winytjurringu ngarrirranytja. Nyangka kapi yirralarringu ngarrirranytja pirtingka. ");
INSERT INTO ntj_vpl VALUES ("K118_36","012_18_36","1KI","18","36","37","Nyangka Layirrtjalu ngarangu Mama Kuurrnga tjapirnu, “Yuwa, nyuntunyan Puurrpa Purlkanya nyinarra. Yuwa, kuka ngaanya tilila. Nyangka-yayi pirnilurtu nyawa nyuntulun mularrpa yayirninytjulu palyannyangka.” ");
INSERT INTO ntj_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Nyangka mularrpartu Mama Kuurrtu waru tjaarrtjingarnu. Nyangka warulu kuka, waru puru yaputarrartu kampangu wiyarnu. Palunyalu kapi pirtingkatjanya kampangu tikirlmanu. ");
INSERT INTO ntj_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Nyangka-ya yarnangu pirnilu mularrnyakulalpi parnangka pupa-pupakatingu watjaranytja, “Wiya, Mama Kuurrnga Puurrpa Purlkanya. Kutju-palunyalu yayirninytjulu palyalpayi.” ");
INSERT INTO ntj_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Nyangka Layirrtjalu-tjananya watjarnu Paralku waarka palyalpayi pirninya-ya tjulyaltjaku. Nyangka-tjananyaya mularrpartu tjulyarnu. Nyangka-tjananya Layirrtjalu walara katingu karrungka pungkulayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Nyangka Layirrtjalu-lu puurrpa Yayipanya watjarnu, “Yuwa, yankun mirrka ngalku? Kulira-rna rurrku kapi purlkanya pitjalayinnyangka.” ");
INSERT INTO ntj_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Nyangka mularrpartu yanu mirrka ngalkulanytja. Nyangka Layirrtjanya-pula palunyaku waarka palyalpayinya yapu katu tatirnu. Nyangka Layirrtjalu pupakatirralpi Mama Kuurrta ngatjiranytja kapi nintiltjaku. ");
INSERT INTO ntj_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Palunyalu wati palunyanya witurnu, “Mapitja yapurra ma-nyawa yutuwari pakaltjaku.” Palunyangka yanu purtu nyakula pitjangu watjarnu, “Wiyartu.” Nyangka Layirrtjalu-lu tirtu tjapira puru wituranytja. Nyangka tirtu mapitjala pitjala watjaranytja, “Wiyartu.” Nyangka puru tjapiralpi witurnu. ");
INSERT INTO ntj_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Nyangka mapitjangu ma-nyangu yutuwari kurlunypa pakarnu ngaralanyangka. Palunyalu marlaku pitjalalpi watjarnu, “Yuwa, nyangu-rna yutuwari kurlunypa pakarnu ngaralanyangka.” Nyangka-lu Layirrtjalu witurnu yankula puurrpa Yayipanya ngurraku witultjaku, “Yuwa, waarrpungkula nyuntuku purni kaarrtjarrangka tatira ngurraku yarra kapilu pitjala kurraltjakutarra.” ");
INSERT INTO ntj_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Nyangka yutuwari parratjunkulalpi waarrpungu marurraarnu ngaralanytja. Nyangka kapi purlkanya punkaranytja. Nyangka puurrpa Yayipanya pakaralpi palunyaku purni kaarrtjarrangka tatira waarrpungkula kutipitjangu yiwarlakutu. ");
INSERT INTO ntj_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Nyangka Layirrtjanya tjina kukurraarnu. Palunyalu pitjalayirnu kurranyu tjarrpangu. Nyangka puurrpa Yayipanya purni kaarrtjarrangka marla pitjangu tjarrpangu. Tjiinya Layirrtjanya wala purlkanya kukurraarnu, tjiinyamarntu Mama Kuurrtu-lu yirringkaranyangka. ");
INSERT INTO ntj_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Nyangka puurrpa Yayipalu palunyaku kurri Tjatjipalta tjukurrpa Layirrtjanyatjarra tjakultjunu. Tjiinya Layirrtjalu-tjananya Paralku waarka palyalpayi pirninya pungu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Nyangka Tjatjipaltu mirrparnarringkulalpi wati tjukurrtjarra wiyarnu yankula Layirrtjanya watjaltjaku, “Yuwa, nyuntulun Paralku waarka palyalpayi pirninya pungu wiyarnu. Nyangka-rna wati kutju wiyalku. Nyangka waarrpungkula mapitjaku nyuntunyanta ngaparrtjika pungku.” ");
INSERT INTO ntj_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Nyangka Layirrtjalu kuliralpi ngurluny-ngurlunyarringu. Palunyalu palunyaku waarka palyalpayinya yarltirra-pula ngurlu tiwa kukurraarnu. Palunyalu wati palunyanya nyinatjura wantirra ");
INSERT INTO ntj_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","tirtu kutipitjangu pila kutjupa-kutjupawana. Pitjalayirnu mungarrtji-mungarrtji wartangka nyinarranytja. Palunyalu Mama Kuurrta tjapiranytja, “Wiya Mama, wanti-rni ka-rnayi mirrirriwa. Tjiinya-rna mukurringkula mirrirrikitja.” ");
INSERT INTO ntj_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Nyangka ngarrikatirralpi kunkunarringu. Ngarrirrayirnu, nyangka-lu yayintjultu pitjangu pampuralpi watjarnu, “Pakala mirrka ngala.” ");
INSERT INTO ntj_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Nyangka kanarringkulalpi nyangu, “Munta! Mirrka kapitarrartu ngarrirra.” Nyangka pakaralpi mirrka ngalangu kapitarrartu tjikirnu. Palunyalu marlakurtu puru kunkunarringu ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Ngarrirrayirnu, nyangka pururtu yayintjultu pitjangu pampuralpi watjarnu, “Pakaralpi puru ngala parltjamunutarrartun pitjalayilku punkaltjakutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Nyangka mularrpartu pakaralpi nyinarra mirrka ngalkula kapitarrartu tjikiranytja. Palunyalu pakara yanu nungkurtu pitjalayirnu ngurra 40-tjanu parrapitjangu yapu miirl-miirlkutu. ");
INSERT INTO ntj_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Nyangka Layirrtjanya ngurra palunyangka waalkarraralpi pulpa nyakulalpi tjarrpangu nyinarranytja. Nyangka Mama Kuurrtu-lu tjapirnu, “Yuwa Layirrtja, nyaatjanungkan pitjangu?” ");
INSERT INTO ntj_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Nyangka-lu watjarnu, “Wiya Mama, ngayulu-rnanku nyuntuku waarka tirtu palyaranytja. Pinkurraantjamaaltu-rna nyuntuku waarkakutju palyaranytja. Nyangka-ya yarnangu pirni nyarra Yitjurayilta nyinapayilu nyuntuku tjukurrpa wantingu. Puru-ya wati nyarra nyuntuku wangka kulira tjakultjunkupayinya-tjananya pungu wiyarnu. Nyangka-rna ngayulu kutjurringu nyinarra. Nyangka-rniya ngayunyatarrartu tjumara pungkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Nyangka Mama Kuurrtu watjarnu, “Wiya, pakara-rni pitja lurrtjurriwa yapu katalarra.” Nyangka Mama Kuurrnga wayirntara mapitjangu. Nyangkalta pirriya purlkanya ngalyakukurraaralpi yapu kartarntanu pararlpungu puru yapu kurlunypa pirninya kartarntanu murtuny-murtunymanu. Nyangka Mama Kuurrnga pirriyangka yartakarrinytjamaalpartu. Nyangka pirriya yatarnarrinyangka manta yurri-yurringu. Nyangka Mama Kuurrnga yartakarrinytjamaalpartu. ");
INSERT INTO ntj_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Nyangka manta yurrimaalarrinyangka waru tjaarrarnu. Nyangka Mama Kuurrnga warungka yartakarrinytjamaalpartu. Nyangka waru wiyarrinyangka purinypa tjaalymara wangkarranytja. ");
INSERT INTO ntj_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Nyangka Layirrtjalu kuliralpi yiikunku warntungka tjuturalpi pakarnu pulpa tjaangka ngaralanytja. Palunyalu kulirnu ngaapirinypa wangkarranytja, “Yuwa Layirrtja, nyaatjanungkan pitjangu?” ");
INSERT INTO ntj_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Nyangka-lu watjarnu, “Wiya Mama, nyuntuku-rnanku waarka tirtu palyaranytja. Pinkurraantjamaaltu-rna nyuntuku waarkakutju palyaranytja. Nyangka-ya yarnangu pirni nyarra Yitjurayilta nyinapayilu nyuntuku tjukurrpa wantingu. Puru-ya wati nyarra nyuntuku wangka kulira tjakultjunkupayinya-tjananya pungu wiyarnu. Nyangka-rna ngayulu kutjurringu nyinarra. Nyangka-rniya ngayunyatarrartu nguwankura mirri pungkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("K119_15","012_19_15","1KI","19","15","18","Nyangka Mama Kuurrtu watjarnu, “Wiya, marlaku yarra. Palunyalu wati yini Yilayitjanya nyakulalpi tjurra ngayuku wangka kulira tjakultjuratjaku nyuntulun wiyarrinyangka. Tjiinyamarntu-ya yarnangu pirni, 7,000-tu tjukurrtatja Paralnga pupakatirra marninypungkulanytjamaalpartu. Nyangkalta-tjananyarna wankarura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Nyangka Layirrtjanya pakara kutipitjangu. Palunyalu pitjalayirnu nyangu wati yini Yilayitjanya puluka kutjarratjarralu manta parratjawaranytja yurninypa tjunkukitjalu. Nyangkanku Layirrtjalu kawutu yarraralpi Yilayitjala tjarrpatjura wayirntara yanu. ");
INSERT INTO ntj_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Nyangka Yilayitjalunku puluka kutjarranya wantirra kukurrtu ngurlura wanarnu watjarnu, “Yuwa, mukurringkula-rna nyuntula lurrtjurringkukitja. Palya-munta-rna marlaku yanku ngayuku mama ngunytju tjamalara pitjaku?” Nyangka Layirrtjalu watjarnu, “Yuwa, palya. Mapitja-pulanya tjamalara marlaku pitja.” ");
INSERT INTO ntj_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Nyangka Yilayitjanya marlaku yanu puluka kutjarranya pungkulalpi kuka kurrkaltjunu kapingka. Palunyalu-tjanampa wati pirniku nintirnu nyarra-ya waarka lurrtjulu palyalpayiku. Nyangka-ya ngalkulanytja. Nyangkalta Yilayitjalu wantirra Layirrtjanya-lu wanarnu lurrtjurringu yirringkankukitja. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("K22_1","013_2_1","2KI","2","1","5","Nyangka tayimpa ngamuntirringu Mama Kuurrtu Layirrtjanya-lu mantjira katitjaku ngurra yilkarikutu. Nyangka wati yirringkankupayilu yini Yilayitjalu nintilu kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","Nyangka Layirrtjalu-lu watjarnu, “Ngaangka nyinama. Tjiinya-rni Mama Kuurrtu watjarnu kapi nyarra Tjuutantakutu-rna yankutjaku.” Nyangka Yilayitjalu watjarnu, “Wiya, ngayulu-rnanta wantikitjamunu.” Nyangka-pula lurrtjurtu yanu. ");
INSERT INTO ntj_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Nyangka wati pirnilu-pulanyaya lurrtjurringkula wanarnu. Nyangka-pula pitjangu kapingka yitingka ngaralanytja. Nyangka wati palunyanya-ya tiwa-tiwa ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Nyangka Layirrtjalunku kawutu yarrarnu ruulumaralpi kapi pungu. Nyangka kapi tjarrarringu. Nyangka ngururrkutjarra parna tikirlarringu ngaralanytja. Nyangka-pula waarrpungkula mapitjangu yitipirringu. ");
INSERT INTO ntj_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Nyangka Layirrtjalu watjarnu, “Yuwa, Mama Kuurrtu-rni kuwarri-kuwarri mantjira katiku. Nyangka nyaapa-rnanku palyalku yankukitjalu?” Nyangka Yilayitjalu watjarnu, “Nyuntukurnu-rni nintila. Nyangka-rna yayirninytjulu kutjupa-kutjupa palyanma nyuntunyapirinytju.” ");
INSERT INTO ntj_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Nyangka Layirrtjalu watjarnu, “Wiya, tjinguru-rnin kurlunyku ngatjinma. Ngaanya-rnin purlkaku ngatjira. Tjinguru-rnin nyaku yilkari katalarra-rna yankunyangka. Palunyalun ngayunyapirinytju yayirninytjulu palyanma.” ");
INSERT INTO ntj_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Nyangka-pula tirtu mapitjalayintja. Nyangka purni kutjarra-pula puru kaarrpa tili wanka waalkarrarnu. Nyangkalta pirriya purlkanya pitjangu Layirrtjanya katura katingu yilkari katalarra. ");
INSERT INTO ntj_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Nyangka Yilayitjalu nyangu mapakannyangka. Palunyalu tjuni kartakatirralpi kawutunku yarraralpi wartunpungu. ");
INSERT INTO ntj_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Palunyalu Layirrtjaku kawutu mantjirnu nyarra parnangka punkarnu ngarrirranytjanya. Palunyalu marlaku yanu kapi Tjuutanta ngarangu. ");
INSERT INTO ntj_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Palunyalu kapi pungu Layirrtjaku kawutungka. Palunyalu kulirnu, “Wiya, ngayukutarrartu-tjinguru-tju Mama Kuurrtu yayirninytjulu palyalku, tjiinya-ra Layirrtjaku palyarnu, palunyapirinypa.” Nyangka kapi tjarrarringu. Nyangka parna palunyanya tikirlarringu ngaralanytja. Nyangkalta mapitjangu kantilypa kutjupangka ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Nyangka-ya wati nyarra ngarala nyakulanytjalu-yanku watjaranytja, “Wiya, Yilayitjalu yayirninytjulu palyarnu, Layirrtjalu palyaranytja, palunyapirinypa.” Nyangkalta-ya mapitjangu lurrtjurringkulalpi Yilayitjala-luya pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Nyangka wati yini Nayimannga puurrpa-tjanampa warrmarla pirniku nyinarranytja ngurra kutjupangka. Wati palunyanya purrtjutjarra nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Nyangka tjiinya ngurra palunyangka kungka kutju Yitjurayilngamartatji nyinarranytja. Palunyalu waarka palyaranytja Nayimanku kurriku. ");
INSERT INTO ntj_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Palunyalu minyma palunyanya watjarnu, “Kulilkun? Wati nyarra Mama Kuurrku wangka kulira tjakultjunkupayi Yitjurayilta nyinarra. Nyangka nyuntuku kurri-tjinguru palunyalakutu yanku. Nyangka-lu pika walykumunulku.” ");
INSERT INTO ntj_vpl VALUES ("K25_4","013_5_4","2KI","5","4","4","Nyangka Nayimantu kuliralpi yanu puurrpa purlkanya watjarnu tjiinya kungkalu-lu watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("K25_5","013_5_5","2KI","5","5","5","Nyangka puurrpa palunyalu watjarnu, “Yuwa, palyan yanku. Nyangka-rna lata walkatjunkulalpi nintilku. Nyangkan katiku puurrpa nyarra Yitjurayilta nyinapayiku nintilku.” Nyangka Nayimantu lata mantjiralpi pakarnu tjimarri purlkanya puru warntu walykumunu pirnitarrartu yurrara yalatja kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("K25_6","013_5_6","2KI","5","6","6","Pitjalayirnu Yitjurayilku parrapitjangu lata palunyanya nintirnu puurrku. Tjiinya lata palunyangka ngaapirinypa ngaralanytja, “Yuwa, wati ngaanya yini Nayimannga. Nyangka-rna mukurringkula tjiinya nyuntulu-lun pika pampura wiirrultjaku.” ");
INSERT INTO ntj_vpl VALUES ("K25_7","013_5_7","2KI","5","7","7","Nyangka puurrpa palunyalu lata mantjirnu nyakulalpi kata paarnarrarnu. Palunyalu watjarnu, “Yuwa-parta? Ngayulu-munta-rna wati ngaanya pampulku walykumunulku? Puurrpa palunyalu-tjinguru kulira ngayulu-rna Mama Kuurrtupirinypa pika walykumunulpayi. Palunyakukantjalu-tjinguru-rni kulira. Wiya, tjinguru ngarnartu watjara pikakitjalu.” ");
INSERT INTO ntj_vpl VALUES ("K25_8","013_5_8","2KI","5","8","8","Nyangka Yilayitjalu tjakulpa kuliralpi wati tjukurrtjarra witurnu yankula puurrpa palunyanya watjaltjaku, “Wiya, nyaatjanungkan mirrparnarringkula? Wati palanya wiyala ngayulakutu nyangka-rnalu yirringkala.” ");
INSERT INTO ntj_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Nyangka puurrpa palunyalu mularrpartu Nayimannga wiyarnu. Nyangka-ya mapitjangu parrapitjalalpi Yilayitjaku ngurrangka purni-tjananya ngaratjunu. ");
INSERT INTO ntj_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Parturtu Yilayitjanya pakantjamaalpa tirtu nyinarranytja. Palunyalu wati kutju watjarnu pakara ngaapirinypa watjaltjaku, “Yuwa, mapitjakun kapi Tjuutanta 7-nguru tjarrpaku. Nyangkanta pika pirninya wiyarriku.” ");
INSERT INTO ntj_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Nyangka Nayimantu kuliralpi mirrparnarringu watjarnu, “Wiya, nyaatjanungka-rni pakara wangkanytjamaalpa tirtu kaninytjarra nyinarra? Tjinguru-rni pitjala lurrtjurringkula Mama Kuurrta tjapinma. ");
INSERT INTO ntj_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Tjiinya ngayuku ngurrangka-ya kapi walykumunu pirni ngarrirra. Tjinguru-rnatju kapi palunyatjinta parltjira walykumunurringama.” ");
INSERT INTO ntj_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Nyangka-ya waarka palyalpayi pirnilu kalypalkitjalu watjarnu, “Wiya puurr, nyaakun mirrparn-mirrparnpa wangkarra? Tjingurun kapingka tjarrparranyangka purrtjunku wiyarrikutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Nyangka mularrpartu kutipitjangu kapingka tjarrpangu-tjarrpangu pakaralpi nyangu, “Pika ngaa wiyarringu-rni.” ");
INSERT INTO ntj_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Nyangka Nayimannga waarka palyalpayi pirnitjarra marlaku kutipitjangu wati nyarra Yilayitjalakutu. Palunyalu watjarnu, “Wiya, Mama Kuurrnga yayirninytju purlkanya. Kutjupa palunyapirinypa parna lipiwana nyinarranytjamunurtu. Yuwa, kulira-rnanta kutjupa-kutjupa yungkukitjalu.” ");
INSERT INTO ntj_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Nyangka Yilayitjalu paanypungu. ");
INSERT INTO ntj_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","Palunyalu-lu Nayimanta watjarnu, “Yuwa, palyan yanku ngurraku.” Nyangka-ya mularrpartu kutipitjangu. Nyangka Yilayitjaku waarka palyalpayilu nyangu Nayimannga yankunyangka. ");
INSERT INTO ntj_vpl VALUES ("K25_20","013_5_20","2KI","5","20","20","Palunyalunku yungarralu kulirnu, “Wiya, Yilayitjalu-tjinguru kutjupa-kutjupa mantjinma. Ngayulu-rnatju ngurlura wanalku kutjupa-kutjupa mantjilku.” ");
INSERT INTO ntj_vpl VALUES ("K25_21","013_5_21","2KI","5","21","21","Palunyalu pakara waarrpungkula marlawanalu ngurlura wanarnu. Nyangka Nayimantu nyangu marlawanalu ngurlurnu ngalyawanarayinnyangka. Palunyalu purni-tjananya ngaratjunkulalpi tjarungarangu tjapirnu, “Nyaarringu?” ");
INSERT INTO ntj_vpl VALUES ("K25_22","013_5_22","2KI","5","22","22","Nyangka waarka palyalpayilu mayuralpi watjarnu, “Wiya, ngayuku puurrtu-rni witurnu nyuntunya watjaltjaku. Tjiinya wati kutjarra-pula kuwarrinyakutju pitjangu. Nyangka-tjinguru-pulampan tjimarri warntu walykumunutarrartu nintilku.” ");
INSERT INTO ntj_vpl VALUES ("K25_23","013_5_23","2KI","5","23","23","Nyangka mularrpartu Nayimantu wuyurrarringkulalpi tjimarri puru warntu walykumunutarrartu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("K25_24","013_5_24","2KI","5","24","24","Nyangka Yilayitjaku waarka palyalpayilu mantjira ngurraku yanu. Palunyalu waarrpungkulalpi yiwarla kaninytjarra tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("K25_25","013_5_25","2KI","5","25","25","Palunyalu Yilayitjala lurrtjurringu. Nyangka-lu tjapirnu, “Wanytjangurun pitjangu?” Nyangka-lu watjarnu, “Wiya, ngaangka-rna nyinarranytja.” ");
INSERT INTO ntj_vpl VALUES ("K25_26","013_5_26","2KI","5","26","26","Nyangka Yilayitjalu watjarnu, “Wiya, ngayulu-pulanyarnanta ngalya yarlalu nyakulanytja Nayimannga-pulan wangkarranyangka. Tjingurun kutjupa-kutjupa mantjintjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("K25_27","013_5_27","2KI","5","27","27","Nyangka palunyangurun nyuntunya purrtjutjarrarriku, tjiinyamarntun mayurnu mantjintjatjanu.” Nyangka mularrpartu Yilayitjaku waarka palyalpayi yarnangu pirniwanartu purrtjutjarrarringu. ");
INSERT INTO ntj_vpl VALUES ("K26_8","013_6_8","2KI","6","8","8","Nyangka puurrpa ngurra kutjupangkatja warrmarla pirnitjarra pitjangu yarnangu-tjananya Yitjurayilngamartatji pungkula tjunkukitja. Palunyalu-ya kumpiralpi nyinarranytja. Tjiinya-ya kuliranytja Yitjurayilngamartatji warrmarla-ya palunyawana pitjalanyangka tjulurrku waalkarrara pungkula tjunkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("K26_9","013_6_9","2KI","6","9","9","Parturtu Yilayitjalu nintilu kuliranytja tjiinya-ya kumpirnu nyinarranyangka. Palunyalu wati kutju witurnu yankula puurrpa Yitjurayilngamartatji ngurlutjunkutjaku. Nyangka mularrpartu yanu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("K26_10","013_6_10","2KI","6","10","10","Nyangka puurrpa palunyalu kuliralpi warrmarla pirninya watjarnu, “Nyarrawana-kurlu-yan kutipitjaku. Wantima-ya.” Nyangka-ya mularrpartu wantingu. Nyangka-ya warrmarla pirni ngurra kutjupangkatja kunpu-kunpu kumpirnu nyinarranytja. Tjiinya-ya tirtu kumpira nyinarra nyakula-nyakula kutipitjapayi. Palunyapirinyarringkulanytja-ya. ");
INSERT INTO ntj_vpl VALUES ("K26_11","013_6_11","2KI","6","11","11","Nyangka puurrpa nyarra ngurra kutjupangkatja mirrparnarringu. Tjiinya kulirnu kutjupalu mapitjala puurrpa Yitjurayilngamartatji tjakultjuranytja, palunyakukantjalu kulirnu. Palunyalu-tjananya warrmarla pirninya tjapirnu, “Yuwa, watjala-rniya. Nganalu yankula tjakultjura ngayulu-lan tjumaranyangka?” ");
INSERT INTO ntj_vpl VALUES ("K26_12","013_6_12","2KI","6","12","12","Nyangka-ya watjarnu, “Wiyartu-latju. Tjiinya Yilayitjalu kulira nyuntulun kampangkartu watjaranyangka. Ngalya yarlalutjaru kulira. Palunyalu puurrpa Yitjurayilngamartatji watjalpayi.” ");
INSERT INTO ntj_vpl VALUES ("K26_13","013_6_13","2KI","6","13","13","Nyangkalta puurrpa palunyalu watjarnu, “Wiya, wanytjatja nyinarra? Parratjapila-ya. Nyangka-rna warrmarla pirninya witulku yankula-ya tjulyara katitjaku.” Nyangka-ya yanu parratjapirnu palunyalu marlaku pitjangu watjarnu, “Wiya, Yilayitjanya yiwarla nyarrangka nyinarra.” ");
INSERT INTO ntj_vpl VALUES ("K26_14","013_6_14","2KI","6","14","14","Nyangka puurrpa palunyalu warrmarla pirninya witurnu. Nyangka-ya mungangkartu mapitjalayirnu yiwarla pirninyartu parrayangatjuralpi nyakulayirnu tjirnturringu. ");
INSERT INTO ntj_vpl VALUES ("K26_15","013_6_15","2KI","6","15","15","Nyangka Yilayitjaku waarka palyalpayilu mungayurnturnu pakaralpi nyangu warrmarla pirnilu-tjananya parrayangatjuralpi kanyiranytja. Nyangka-lu yanu Yilayitjanya watjarnu, “Wiya, wartalpitjanu-lanya yangatjunu kanyira. Yaaltjirriku-lan?” ");
INSERT INTO ntj_vpl VALUES ("K26_16","013_6_16","2KI","6","16","16","Nyangka Yilayitjalu watjarnu, “Wiya, ngurlumaalpa-la nyinama. Tjiinya ngayuku-lampa warrmarla pirnirtu, palunyangka munkarra.” ");
INSERT INTO ntj_vpl VALUES ("K26_17","013_6_17","2KI","6","17","17","Nyangka Yilayitjalu Mama Kuurrnga tjapirnu, “Yuwa Mama, wati ngaanya-lu ngalya yarlala. Nyangkayi warrmarla yarrkari pirni nyawa.” Nyangka waarka palyalpayinya ngalya yarlarringkulalpi nyangu Mama Kuurrku warrmarla pirni ngaralanyangka. Tjiinya-ya purni kaarrpa tili wankatjarralu miranykanyira kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("K26_18","013_6_18","2KI","6","18","18","Nyangka-ya warrmarla nyarra mungangka nyakula tjirnturrinytjanya ngamu-ngamuntirringu ngaralanytja. Nyangka Yilayitjalu Mama Kuurrnga tjapirnu, “Yuwa Mama, pampula-tjananya kuru tjutula.” Nyangka-tjananya mularrpartu kuru tjuturnu. ");
INSERT INTO ntj_vpl VALUES ("K26_19","013_6_19","2KI","6","19","19","Nyangka-tjananya Yilayitjalu watjarnu, “Wiya, nyuntunya-yan kutjupayarla pitjangu. Palunyalu-yan yiwarla kutjupangka ngarala. Nyangka-tjananyarnanta walara katiku wati nyarra palunyaku-yan ngurriranytjalakutu.” Nyangkalta-tjananya walara katingu yiwarla yini Tjamiriyalakutu nyarra puurrpa purlkanyaku ngurrakutu. ");
INSERT INTO ntj_vpl VALUES ("K26_20","013_6_20","2KI","6","20","20","Nyangka-ya pitjangu yiwarla palunyangka tjarrpangu. Nyangka Yilayitjalu Mama Kuurrnga tjapirnu, “Yuwa Mama, kuru-tjananya yarlala nyangka-yayi nyawa.” Nyangka mularrpartu-tjananya kuru yarlarnu. Nyangkalta-ya nyangu, “Yuwa-watjala. Tjamiriyala-la ngarala.” ");
INSERT INTO ntj_vpl VALUES ("K26_21","013_6_21","2KI","6","21","21","Nyangka puurrpa Yitjurayilngamartatjilu-tjananya nyakulalpi Yilayitjanya tjapirnu, “Mirri-munta-tjananyarna pungku?” ");
INSERT INTO ntj_vpl VALUES ("K26_22","013_6_22","2KI","6","22","22","Nyangka Yilayitjalu watjarnu, “Wiya, wanti-tjananya pungkutjamaaltu. Mirrka-tjanampa nintila. Nyangka-yayi ngalkula parltjarringkula marlaku kutipitja palunyaku puurrkutu.” ");
INSERT INTO ntj_vpl VALUES ("K26_23","013_6_23","2KI","6","23","23","Nyangka mularrpartu-tjanampa mirrka purlkanya nintirnu. Nyangka-ya ngalangu parltjarringu. Palunyangka-tjananya ngurrakutu witurnu. Nyangka-ya kutipitjangu. Palunyalu-ya warrmarlara pitjanytjamaalpa tirtu ma-nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Nyangka-ya tjilku tjirrarnka yini Tjutjayinya tjunu puurrarringkula-tjanampa nyinarratjaku. Nyangka puurrpa rawa nyinarrayirnu yirna-yirnarringkulalpi mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Tjiinya Tjutjayilu walykumunu pirni palyaranytja. Nyangka Mama Kuurrnga-ra pukurlarringu. Tjiinya Mama Kuurrku wangka wangarnarralu kulira palyaranytja palunyaku tjamu Tayipirrku yarawanalu. ");
INSERT INTO ntj_vpl VALUES ("K222_3","013_22_3","2KI","22","3","7","Nyangka puurrpa Tjutjayilu wati yini Tjayipannga witurnu tjurrtju purlkanyakutu yankutjaku. Palunyalu-lu watjarnu, “Mapitja lurrtjurriwa Yilkayila, tjiinya tjurrtjuku puurrpa purlkanyala. Palunyalu watjala tjimarri nyarra yarnangu pirnilu-ya katirra yungkupayinya mantjira waarka palyalpayi pirniku yungkutjaku. Nyangka-yayi warta yapu pirni payipungkulalpi tjurrtju purlkanya marlakulu palyala walykumunula. Tjiinyamarntu tjurrtju palunyanya ngarnmanytjanu ngaralayirnu palyamunurringu ngarala.” ");
INSERT INTO ntj_vpl VALUES ("K222_8","013_22_8","2KI","22","8","8","Nyangka Tjayipantu mularrpartu mapitjangu Yilkayinya watjarnu. Nyangka kuliralpi yuwarnmanu. Palunyalu watjarnu, “Ngaanya nyawa, ruula purlkanya-rna nyangu tjurrtjungka ngarrirranyangka.” Nyangka ruula palunyanya Tjayipanku yungu. Nyangka mantjiralpi nyakula-wanarnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K222_9","013_22_9","2KI","22","9","10","Palunyalu marlaku yanu puurrpa watjarnu, “Yuwa, wati nyarra Yilkayilu ruula purlkanya nyangu tjurrtjungka ngarrirranyangka. Palunyatjanulu-rni katingu ngaanya yungu. Nyangka-muntan kuliku?” Nyangka puurrtu yuwarnmankunyangka Tjayipantu tjukurrpa ruulangkatja nyakula watjarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K222_11","013_22_11","2KI","22","11","13","Nyangka puurrtu kuliralpi kata paarnarrarnu. Palunyalu wati 5-pa yarltirralpi watjarnu, “Mama Kuurrnga-tjinguru-lampa mirrparnarringu. Tjiinyamarntu-ya tjamupirtilu Mama Kuurrku wangka kulira wantirranytja. Palunyalu-ya watatjarringu nyinarra-wanarayintja. Nyangka-lan ngayunyalpi ngurrpa nyinarranytja wangka ruula ngaangka walkatjunu wantitjaku. Nyaapirinypa-lan palyalku? Yarra-ya Mama Kuurrnga tjapila.” ");
INSERT INTO ntj_vpl VALUES ("K222_14","013_22_14","2KI","22","14","15","Nyangka-ya wati 5-lu yanu nyangu minyma nyarra Mama Kuurrku wangka kulira tjakultjunkupayinya. Nyangka-tjananya palunyaku yiwarlangka tjarrpatjunu. Palunyalu-tjananya watjarnu, “Yuwa, nintilu-rna kulira tjiinya puurrpa Tjutjayilu-tjananyanta witurnu. Nyangka Mama Kuurrtu ngaapirinypa watjarnu, ");
INSERT INTO ntj_vpl VALUES ("K222_16","013_22_16","2KI","22","16","16","‘Yuwa Tjutjayi, mularrpa-rna palyamunu purlkanya yutilku ngurra ngaaku puru yarnangu pirni ngurra ngaangka nyinapayiku. Tjiinya ruula palangka kutjulpirtu walkatjunu wantitja, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("K222_17","013_22_17","2KI","22","17","17","Tjiinya-rniya ngayunya wantirralpi kutjupa-kutjupa yapu wartatarrartu kutjupayarla pupakatirra marninypungkulanytja. Nyangka-rna nyakulalpi mirrparnarringu. Palunyalu-rna lirri waru tirtu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("K222_18","013_22_18","2KI","22","18","19","Yuwa Tjutjayi, nyuntulun kulirnu wangka ruulangkatjanya. Palunyalu-rnin yulatjarralu tjapiranytja. Nyangka-rnanta kulirnu. ");
INSERT INTO ntj_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","Palunyalu-rna kuwarripa wantingu. Nyangkan nyinarrayilku ngula-ngula mirrirriku. Nyangkalta-rna palyamunu purlkanya marla yutilku.’ Yuwa, Mama Kuurrtu palunyapirinypa watjarnu.” Nyangka-ya wati palunyanya marlaku yanu puurrpa Tjutjayila watjarnu. ");
INSERT INTO ntj_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Nyangka puurrpa Tjutjayilu-tjananya wati pirni witurnu yankula-tjananya liita pirninya ngurra kutjupa-kutjupangka yarltirra katitjaku. Nyangka-ya mularrpartu-tjananya yarltirra katingu. ");
INSERT INTO ntj_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","Nyangka-ya lurrtjurringkula mapitjangu tjurrtju purlkanyangka tjarrpangu. Nyangka-ya yarnangu pirninyatarra lurrtjurringkula pitjangu. Nyangka Tjutjayilu Mama Kuurrku wangka ruulangkatjanya nyakula watjarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Palunyalu watjarnu wantingu Mama Kuurrku wangka wangarnarralu kulira palyalkitjalu. Nyangka-ya yarnangu pirnilu palunyapirinypartu watjarnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Nyangka puurrpa Tjutjayilu-tjananya wati nyarra tjurrtjungka waarka palyalpayinya watjarnu, “Wiya, yurrara-ya makati warni palyamunu pirni nyarra pupakatirra marninypungkupayinya.” Nyangka-ya mularrpartu yurrara katirra karrungka warnirranytja. Palunyalu-ya tilirnu tjarrpatjunu tjiinyamarntu puurrpa Tjutjayilu watjarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("K224_8","013_24_8","2KI","24","8","8","Nyangka wati yini Tjuyakinya ngurra Tjurutjamala puurrarringu nyinangu rawamaalpartu puurrpa wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("K224_9","013_24_9","2KI","24","9","9","Palunyalu Mama Kuurrku wangka kulira palyaranytjamaaltu kutjupa-kutjupa palyaranytja, tjiinya palunyaku mamalu palyaranytja, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("K224_10","013_24_10","2KI","24","10","10","Nyangka-ya warrmarla pirni Papulanngamartatjilu pitjangu yiwarla Tjurutjamanya parrayangatjunu kanyiranytja. Palunyalu-ya yarnangu pirninya yurakanyiranytja. Nyangka-ya purtu kuliranytja pakara kukurraalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("K224_11","013_24_11","2KI","24","11","11","Nyangka puurrpa Napitja Papulanngamartatjinya marlawana pitjangu-tjananya lurrtjurringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("K224_12","013_24_12","2KI","24","12","14","Nyangka puurrpa Tjuyakinya palunyaku yungarrapirtitarrartu-ya pakarnu yinytjanurringu ngaralanytja. Nyangka puurrpa Napitjalu-tjananya karrpira katingu ngurra nyarra Papulantakutu. Yarnangu pirninyatarrartu karrpira katingu. Palunyalu-tjanampa walykumunu pirni tjurrtjungkatja kartarntaralpi yurrara katingu ngurra Papulantakutu. Tjiinya Mama Kuurrtu kurranyululpi watjarnu wantingu. Palunyapirinypa ngarangu. ");
INSERT INTO ntj_vpl VALUES ("K224_17","013_24_17","2KI","24","17","17","Nyangka puurrpa Napitjalu Tjuyakiku mama marlangkatjanya tjunu puurrpa nyinarratjaku ngurra Tjurutjamalawana. Palunyalu yini kutjupa-lu tjapirnu Tjatikayinya. ");
INSERT INTO ntj_vpl VALUES ("K224_19","013_24_19","2KI","24","19","19","Nyangka Tjatikayilu Mama Kuurrku wangka kulira wantirranytja. Palunyalu kutjupa-kutjupa palyamunu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("K224_20","013_24_20","2KI","24","20","20","Nyangka Mama Kuurrnga-tjanampa mirrparnarringu yarnangu nyarra Tjurutjamalawana nyinapayi pirniku. Palunyalu-tjananya yirringkankutjamaaltu wantingu. ");
INSERT INTO ntj_vpl VALUES ("K225_1","013_25_1","2KI","25","1","1","Nyangka Tjatikayinya tungun-tungunarringu puurrpa Napitjaku. Nyangka warrmarla pirnitjarra pitjangu Tjurutjamanya yangatjunu kanyiranytja. Puru-tjananya kulyakanyiranytja pakaltjakutarra. ");
INSERT INTO ntj_vpl VALUES ("K225_2","013_25_2","2KI","25","2","3","Nyangka-ya kaninytjarranguru nyinarra purtu kuliranytja pakara yankula mirrka yurralkitjalu. Nyangka mirrka-tjanampa wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("K225_4","013_25_4","2KI","25","4","4","Nyangka mungangka puurrpa Tjatikayinya palunyaku warrmarla pirnitjarra yarla kurlunywana pakara kukurraarnu kapi Tjuutantakutu. ");
INSERT INTO ntj_vpl VALUES ("K225_5","013_25_5","2KI","25","5","5","Nyangka-ya puurrpa Napitjaku warrmarla pirnilu ngurlura wanarnu puurrpa Tjatikayinya tjulyarnu kanyiranytja. Nyangka Tjatikayiku warrmarla pirninya-ya ngurlu kukurraarnu wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("K225_6","013_25_6","2KI","25","6","7","Nyangka-ya puurrpa Tjatikayinya katingu puurrpa Napitjalakutu. Nyangka-tjananya watjarnu Tjatikayiku katja pirninya-ya pungkula tjunkutjaku mamangka mirangka. Nyangka-tjananya mularrpartu pungu mirrirntanu. Palunyalu-ya Tjatikayinya kuru kutjarranyartu wakarnu yurltupungu. Palunyalu-ya rankapungka karrpira yalatjalu katingu ngurra nyarra Papulantakutu. ");
INSERT INTO ntj_vpl VALUES ("K225_8","013_25_8","2KI","25","8","8","Nyangka puurrpa Napitjalu wati nyarra warrmarla kanyilpayinya witurnu. Nyangka warrmarla pirnitjarra yanu ngurra nyarra Tjurutjamalakutu. ");
INSERT INTO ntj_vpl VALUES ("K225_9","013_25_9","2KI","25","9","9","Palunyalu-ya tjurrtju purlkanya puru yiwarlatarrartu tilirnu tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("K225_10","013_25_10","2KI","25","10","10","Puru-ya yaarrpa purlkanya nyarra yiwarlawana parrangarapayinya yurnturnu punkatjingarnu. ");
INSERT INTO ntj_vpl VALUES ("K225_11","013_25_11","2KI","25","11","11","Palunyalu-tjananya yarnangu pirninya karrpira katingu Papulantakutu. ");
INSERT INTO ntj_vpl VALUES ("K225_12","013_25_12","2KI","25","12","12","Palunyalu-ya yarnangu mungutja-mungutja nyinapayinyakutju wantingu, tjiinya-ya nyinarra manta tjawara yurninypa tjunkula mirrka pakaltjingaltjaku. Nyangka-ya mularrpartu nyinarra mirrka pakaltjingaranytja. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("R27_11","015_7_11","2CH","7","11","11","Nyangka tjiinya Tjalamantu tjurrtju purlkanya palyarayirnu wiyarnu. Purunku yiwarla purlkanya palyarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("R27_12","015_7_12","2CH","7","12","12","Palunyangka Mama Kuurrtu-lu mungangka pitjangu yartakarringkulalpi watjaranytja, “Yuwa, kulirnu-rnanta tjiinya-rnin tjapiranyangka. Nyangka-rna tjurrtju ngaanya tjunu ngayuku-tju kurrurnkulu ngaralatjaku. Nyangka-tjuyayi puluka tjiiputarrartu katirra tjurrtju ngaangka pungkula tilira nintinma. ");
INSERT INTO ntj_vpl VALUES ("R27_13","015_7_13","2CH","7","13","14","Nyangka-ya ngula-tjinguru ngayuku katja yurntalpirtilu palyamunu palyanma. Nyangka-tjinguru-rna kapi marrkulku wantiku punkantjamaalpa ngaralatjaku. Puru-tjinguru-rna tjintilyka pirninya wiyalku. Nyangka-ya mirrka-tjanampa ngalku wiyalku. Puru-tjinguru-tjananyarna yarnangu pirninya pikatjarralku. Palunyangka-tjinguru-ya ngayuku katja yurntalpirtilu palyamunu wantirralpi ngayulakutu pinkurraalku. Palunyalu-ya karnany-karnanypa nyinanytjamaaltu ngayunya-rniya tirtu tjapinma. Palunyangka-tjananyarna yilkaringuru kuliralpi kalyparriku. Palunyalu-tjanamparna ngurra marlakulu walykumunulku. ");
INSERT INTO ntj_vpl VALUES ("R27_15","015_7_15","2CH","7","15","15","Yuwa, tjurrtju ngaanya-rna tirtu nyakuma. Puru-tjananyarna kulilku tjiinya-rniya tjurrtju ngaangurulu tjapiranyangka. ");
INSERT INTO ntj_vpl VALUES ("R27_16","015_7_16","2CH","7","16","16","Tjiinyamarntu tjurrtju ngaanya ngayuku-tju kurrurnkurlu ngarala. Nyangka-rniyayi pirnilu pupakatirra marninypungama. Nyangka-rna tjurrtju ngaanya tirtu miranykanyira kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("R27_17","015_7_17","2CH","7","17","17","Nyangka Mama Kuurrnga Tjalamanta tirtu wangkarranytja, “Yuwa, nyuntuku mama Tayipirrtu ngayuku wangka wangarnarralu kulira palyalpayi. Nyangka nyuntulu palunyapirinypartu palyanma. ");
INSERT INTO ntj_vpl VALUES ("R27_18","015_7_18","2CH","7","18","18","Palunyangka wati nyuntuku wartangkatja-ya ngurra ngaangka puurrpa tirtu nyinarra-wanarayinma. Tjiinya-rna Tayipirrnga palunyapirinypa watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("R27_19","015_7_19","2CH","7","19","19","Nyangka Mama Kuurrtu Tjalamanta tirtu watjara-wanarayintja, “Nyangka ngula-tjinguru-yan yarnangu pirnilutarrartu ngayuku wangka wantirralpi yapu warta kutjupa-kutjupatarrartu pupakatirra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("R27_20","015_7_20","2CH","7","20","20","Nyangkalta-tjananyarnanta witura-wanalku wantinyangka-yan kutipitjaku tiwa nyinama. Nyangka-rna tjurrtju ngaanya wantiku. Nyangka-ya yarnangu kutjupa-kutjupalu pitjala yayirnirringkula watjanma, ‘Nyawa, nyaatjanulu Mama Kuurrtu wantingu nyangka-ya pitjangu tilirnu tjarrpatjunu?’ ");
INSERT INTO ntj_vpl VALUES ("R27_21","015_7_21","2CH","7","21","21","Tjiinya tjurrtju ngaanya kuwarrinya walykumunu ngarala. Nyangka-rna ngayulu wantinyangka yarnangu pirnilu-ya pitjaku nyaku kata paarnarraralpi watjalku, ‘Nyaatjanulu Mama Kuurrtu tjurrtju puru yarnangu pirninya wantingu?’ ");
INSERT INTO ntj_vpl VALUES ("R27_22","015_7_22","2CH","7","22","22","Nyangka-ya kutjupatjarralu watjanma, ‘Wiya, yarnangu pirnilu-ya Mama Kuurrnga wantirralpi yapu warta kutjupa-kutjupa pirni pupakatirra marninypungkulanytja. Palunyanguru-tjananya wantingu.’” Palunyapirinypa Mama Kuurrtu Tjalamanta watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","3","Nyangka puurrpa yini Tjaaranya ngurra kutjupanguru pitjangu puurrarringu nyinarranytja ngurra Papulanta. Nyangka-lu Mama Kuurrtu wuyurrmanu Tjiyu kutjupatjarra ngurraku witultjaku. Nyangka mularrpartu-tjananya witurnu yarnangu Tjiyu kutjupatjarra-ya marlaku yankutjaku ngurra Tjurutjamalakutu palunyalu-ya Mama Kuurrku tjurrtju purlkanya marlakulu palyaltjaku. ");
INSERT INTO ntj_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","Puru puurrpa Tjaaralu-tjananya yarnangu Tjiyu kutjupatjarranya watjarnu tjimarri puru mirrkatarrartu-ya yirringkara nintiltjaku puru tungki, purni kamurlpatarrartu nintiratjaku. Kutjupa-kutjupa-yayi tjunkula makatima. ");
INSERT INTO ntj_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Nyangka Mama Kuurrtu-tjananya wuyurrmanu. Nyangka-ya yarnangu pirnilu riitikarraranytja Tjurutjamalakutu yankula Mama Kuurrku tjurrtju purlkanya marlakulu palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Nyangka-tjanampa yarnangu ngamu nyinarranytjalu kutjupa-kutjupa walykumunu nintira-wanarnu wantingu Tjurutjamalakutu-ya katitjaku. ");
INSERT INTO ntj_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","Nyangka puurrpa Tjaaralu-tjanampa panikinpa kawurltjarra pirni puru wirra kurlunypa pirni yurraralpi nintirnu marlakulu-yanku katitjaku. Tjiinya kutjulpirtu puurrpa Napitjalu yurrara katingu kanyiranytja, tjurrtju purlkanya nyarra ngarnmanypalpi Tjurutjamala ngaralanytja, palunyangkatja yurrara katingu. ");
INSERT INTO ntj_vpl VALUES ("ER2_1","016_2_1","EZR","2","1","1","Nyangka-ya yarnangu pirnilu Papulannga wantirra yalatjarringkula marlaku kutipitjangu. Tjiinyamarntu kutjulpirtu puurrpa Napitjalu-tjanampa tjamu kaparlipirti karrpira katingu ngurra Papulanta nyinatjunu wantingu. Nyangka-ya ngurra palunyangka rawa nyinarrayirnu tjamu kaparlitjarrarringu. Nyangkalta puurrpa Tjaaralu-tjananya witunnyangka-ya pakara kutipitjangu. Pitjalayirnu-ya Tjurutjamalakutu parrapitjangu. Palunyalu-ya yanu ngurra yungarrangka-yanku parranyinarranytja, palunyaku tjamu kaparlipirti-ya nyinangu wiyalurru ngarangu palunyangka. ");
INSERT INTO ntj_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","6","Nyangka-ya pitjangu lurrtjurringu Tjurutjamala. Palunyalu-ya kukangkatjanya tilira tjunkupayinya palyarnu walykumunurnu. Palunyalu-ya kuka pungkula tilira tjunkula Mama Kuurrku nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Nyangka-ya yarnangu pirnilu tjimarri nintiranytja. Nyangka-ya warta purlkanya pirni payipungu tjurrtju purlkanya palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","9","Nyangkalta-ya pirnilurtu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("ER3_10","016_3_10","EZR","3","10","11","Nyangka-ya wati kutjupatjarralu yapu walu mantawanalu parrangarritjunkula-wanarnu wiyarnu. Nyangka-ya turlku yinkapayilu puru turampirrpa puulpayilu Mama Kuurrnga pukurltu marninypungkulanytja. Tjiinya-ya turlku ngaapirinypa yinkarra marninypungkulanytja, “Mama Kuurrnga walykumunu mularrpa. Palunyalu-lanya ngarltunytjulu tirtu kanyira.” Nyangkalta-ya pirnilurtu pukurltu mirrarra Mama Kuurrnga marninypungkulanytja. Tjiinya-ya pukurlarringu yapu walu mantawana parratjunu wantinyangka tjurrtju purlkanya palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("ER3_12","016_3_12","EZR","3","12","12","Nyangka-ya wati yirna pirnilu nyakula ruukulira yularranytja. Tjiinya-ya tjurrtju ngarnmanypalpi kanyiranytjatjanulu ruukulira yularranytja. Nyangka-ya kutjupatjarranya pukurlpa mirrarranytja. ");
INSERT INTO ntj_vpl VALUES ("ER4_1","016_4_1","EZR","4","1","1","Nyangka-ya yarnangu ngurra palunyangka tirtu nyinapayilu kulirnu tjiinya yarnangu nyarra-ya marlaku pitjanytjalu tjurrtju purlkanya marlakulu palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("ER4_2","016_4_2","EZR","4","2","2","Palunyalu-ya pitjangu liita pirningka watjarnu, “Yuwa, lurrtjurringku-munta-latju palyalku? Tjiinya-latju ngayulutarrartu Mama Kuurrnga marninypungkupayi.” ");
INSERT INTO ntj_vpl VALUES ("ER4_3","016_4_3","EZR","4","3","3","Nyangka-ya liita pirnilu watjarnu, “Wiya, yungarralu-latjunku tjurrtju purlkanya palyalku, tjiinyamarntu-lanyatju puurrpa Tjaaralu watjarnu wantinyangka.” ");
INSERT INTO ntj_vpl VALUES ("ER4_4","016_4_4","EZR","4","4","4","Nyangka-ya yarnangu ngurra palunyangka nyinapayilu kutjupa-kutjupa watjaranytjalu-tjananya ngurlutjingaranytja tjiinya-ya tjurrtju purlkanya palyantjamaaltu wantitjaku. ");
INSERT INTO ntj_vpl VALUES ("ER4_5","016_4_5","EZR","4","5","5","Tirtu-ya palunyapirinymaranytja puurrpa Tjaaranya nyinarranyangkalpi puru puurrpa Turayinya nyinarranyangka. ");
INSERT INTO ntj_vpl VALUES ("ER4_24","016_4_24","EZR","4","24","24","Nyangka-ya tjurrtju purlkanya palyantjamaaltu wantingu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("ER5_1","016_5_1","EZR","5","1","2","Nyangka-pula wati kutjarra tjiinya Mama Kuurrku wangka kulira tjakultjunkupayilu watjaranytja-tjananya tjurrtju purlkanya-ya wantinytjamaaltu palyara wiyaltjaku. Nyangka-pula liita kutjarralu kuliralpi yanu yarnangu pirninyartu parrawatjaranytja, “Pitja-ya nyangka-la pirnilurtu tjurrtju purlkanya palyala wiyala.” Nyangkalta-ya mularrpartu pitjangu palyaranytja. Nyangka-pula wati kutjarra Mama Kuurrku wangka kulira tjakultjunkupayilu lurrtjurringkulalpi palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("ER5_3","016_5_3","EZR","5","3","17","Nyangka-ya wati pirni ngurra palunyawana nyinapayilu pitjangu-tjananya tjapirnu, “Yuwa, watjala-lanyatjuya. Nganalu-tjananyanta watjarnu tjurrtju ngaanya-yan marlakulu palyaltjaku?” Nyangka-ya watjarnu, “Wiya, puurrpa Tjaaralu-lanyatju witurnu pitjala-latju tjurrtju ngaanya marlakulu palyaltjaku.” Nyangka-ya kuliralpi lata walkatjunu wiyarnu puurrpa nyarra Papulanta nyinapayiku. Tjiinya puurrpa Tjaaranya wiyarrinyangka puurrpa kutjupa yini Turayinya nyinarranytja. Nyangka-ya puurrpa Turayiku ngaapirinypa walkatjunu, “Yuwa puurr, watjala-lanyatju. Mularrpa-munta puurrpa Tjaaralu-tjananya watjarnu pitjala-ya tjurrtju purlkanya Tjurutjamala palyaltjaku? Palunyapirinypa-ya yarnangu pirnilu watjara.” ");
INSERT INTO ntj_vpl VALUES ("ER6_1","016_6_1","EZR","6","1","1","Nyangka puurrpa Turayilu lata nyakulalpi watjarnu wati kutjulu yankula ruula nyarra kutjulpingkatja pirninya nyakulatjaku. ");
INSERT INTO ntj_vpl VALUES ("ER6_2","016_6_2","EZR","6","2","2","Nyangka mularrpartu ruula pirninya nyangu-nyangu palunyalu kutju ngurrkarntanu. Palunyalu nyangu wangka ngaapirinypa walkatjunu wantitja ngaralanytja: ");
INSERT INTO ntj_vpl VALUES ("ER6_3","016_6_3","EZR","6","3","3","“Puurrpa Tjaaralu watjarnu tjurrtju purlkanya-ya marlakulu palyaltjaku Tjurutjamala.” ");
INSERT INTO ntj_vpl VALUES ("ER6_6","016_6_6","EZR","6","6","8","Nyangka puurrpa Turayilu lata walkatjunu wiyarnu yarnangu nyarra Tjurutjamalawana-ya nyinapayiku. Ngaapirinypa-tjanampa walkatjunu wantingu: “Yuwa, marrkuntjamaaltu-tjananya wanti. Nyangka-yayi tjurrtju purlkanya marlakulu palyala wiyala. Tjimarri-tjanampa nintinma. Nyangka-yayi palyanma.” ");
INSERT INTO ntj_vpl VALUES ("ER6_13","016_6_13","EZR","6","13","13","Nyangka-ya lata palunyanya mantjirnu nyakulalpi mularrpartu kutjupa-kutjupa-tjanampa nintiranytja. ");
INSERT INTO ntj_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Nyangka-ya tjurrtju purlkanya kutjurntara palyarayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Nyangka-ya yarnangu pirni nyarra Papulantanguru marlaku pitjangu nyinarranytjanya pukurlpa pitjangu tjurrtjungka lurrtjurringu. Palunyalu-ya tjurrtju purlkanya miirl-miirlmanu wantingu Mama Kuurrku. ");
INSERT INTO ntj_vpl VALUES ("ER6_17","016_6_17","EZR","6","17","17","Palunyalu-ya puluka tjiipu pirni pungkulalpi tilirnu tjunu Mama Kuurrku yungu. ");
INSERT INTO ntj_vpl VALUES ("ER6_18","016_6_18","EZR","6","18","18","Puru-tjananyaya watjarnu wati nyarra tjurrtjungka waarka palyalpayilu-ya tjarrparralpi kutjupa-kutjupa tirtu palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("ER7_1","016_7_1","EZR","7","1","5","Nyangka-ya nyinarra kurli pirni pungkula warnirranytja. Nyangka wati yini Yatjuranya nyinarranytja Papulanta. Tjiinya kutjulpirtu palunyaku tjamupirti marlangkatja-marlangkatja pirninya pakara-wanara-ya watirringkula tjurrtju purlkanyangka Tjurutjamala waarkarringkupayi. ");
INSERT INTO ntj_vpl VALUES ("ER7_6","016_7_6","EZR","7","6","10","Nyangka Yatjuralu Mama Kuurrku wangka kutjulpirtu walkatjunu wantitjanya tirtu nyakula watjalpayi. Palunyalu wangka palunyanya rawalu kulilpayi. Palunyalu yarnangu pirningkartu parrawatjalpayi. Nyangka Mama Kuurrtu-lu walykumunura kanyiranytja. Nyangka Yatjuralu tjapirnu puurrpa purlkanyalu witultjaku-lu Tjurutjamalakutu. Nyangka Mama Kuurrtu-lu puurrpa palunyanya wuyurrmanu. Nyangka mularrpartu witurnu. Nyangka-ya wati pirni pitjangu Yatjurala lurrtjurringu tjiinya tjurrtju purlkanyangka waarkarrikitja. Nyangka-ya ngurra Papulannga wantirra pakara kutipitjangu. Pitjalayirnu-ya kirnara kutjarra-kutjarranguru parrapitjangu Tjurutjamalakutu. ");
INSERT INTO ntj_vpl VALUES ("ER7_11","016_7_11","EZR","7","11","11","Nyangka tjiinya puurrpa purlkanyalu lata walkatjuralpi Yatjuraku nintirnu ngurra palunyakutu katitjaku. ");
INSERT INTO ntj_vpl VALUES ("ER7_12","016_7_12","EZR","7","12","12","Yuwa Yatjura, ngayulu-rna puurrpa purlkalu lata ngaanya walkatjura. ");
INSERT INTO ntj_vpl VALUES ("ER7_13","016_7_13","EZR","7","13","13","Yuwa, tjinguru-ya Yitjurayilku tjamupirti mukurringkula nyuntulawana lurrtjurringkula Tjurutjamalakutu yankukitja. Yuwa, palya-ya yanku. ");
INSERT INTO ntj_vpl VALUES ("ER7_14","016_7_14","EZR","7","14","14","Nyangka-yan mapitjaku Tjurutjamala tjarrparralpi nyaku, “Mama Kuurrku wangka-munta-ya tjukarurrulu kulira palyara?” ");
INSERT INTO ntj_vpl VALUES ("ER7_15","016_7_15","EZR","7","15","16","Yuwa, ngayulu puru ngayuku yamatji pirnilutarrartu-latju kawurlpa puru tjilpa pirni nintirnu nyuntulun makatirra Mama Kuurrku nintiltjaku. ");
INSERT INTO ntj_vpl VALUES ("ER7_17","016_7_17","EZR","7","17","17","Tjiinya-yan tjimarri palunyangka puluka pirni puru tjiipu pirni payipungku. Palunyalu-yan pungkulalpi tililku tjunku Mama Kuurrku nintilku. ");
INSERT INTO ntj_vpl VALUES ("ER7_21","016_7_21","EZR","7","21","23","Yuwa Yatjura, nyuntunyan puurrpa yilkaringkatjaku wangkaku ninti purlkanya nyinarra. Tjingurun wati nyarra tjimarri-ya kanyilpayinya-tjananyan tjapilku. Nyangkanta-ya kutjupa-kutjupa nintilku. Nyangkan puurrpa yilkaringkatjaku nintilku tjiinya-tju ngayuku mirrparnarritjakutarrartu. ");
INSERT INTO ntj_vpl VALUES ("ER7_25","016_7_25","EZR","7","25","25","Yuwa Yatjura, nyuntulun wati pirni tjunku yarnangu nyarra Tjurutjamalawana-ya nyinarranytjanya-tjananya tjurrkurlmara kanyiratjaku. Nyangka-yan Mama Kuurrku wangka nintipungama yarnangu ngurrpa pirningka. ");
INSERT INTO ntj_vpl VALUES ("ER7_27","016_7_27","EZR","7","27","28","Nyangka Yatjuranya pukurlarringu tjiinyamarntu puurrpa palunyalu-ra lata nintinnyangka. Palunyalu watjarnu, “Yuwa, Mama Kuurrnga walykumunu mularrpa. Palunyalu puurrpa purlkanya wuyurrmanu, nyangka-rni yirringkanu. Yuwa, raparringu-rna Mama Kuurrtu-rni kanyiranyangka. Palunyalu-rna yarnangu pirninya yarltingu. Nyangka-rniya lurrtjurringu Tjurutjamalakutu yankukitja.” ");
INSERT INTO ntj_vpl VALUES ("ER8_21","016_8_21","EZR","8","21","21","Nyangka-latju warntu karrpiralpi pakara mapitjangu kapi kutjupangka ma-tjunkulalpi nyinarranytja tjiinya-latju yalatja yankukitja. Nyangka-tjananyarna watjarnu, “Yuwa, mirrka wantirralpi-la Mama Kuurrnga tjapinma. Nyangka-lanyanta miranykanyira katirrayinma. Tjiinya-lan kutjupa-kutjupa pirni tjilkutarrartu katirrayirni.” ");
INSERT INTO ntj_vpl VALUES ("ER8_22","016_8_22","EZR","8","22","22","Tjiinya tjinguru-rna puurrpa tjapinma nyangka-tjananya warrmarla pirni witunma lurrtjurringkula-ya yankutjaku. Parturtu-rna wantingu. Tjiinya-rnalu wiyangkalpi ngaapirinypa watjarnu, “Wiya, Mama Kuurrtu yarnangu miranykanyira kanyilpayi mularrkuliranyangka.” ");
INSERT INTO ntj_vpl VALUES ("ER8_23","016_8_23","EZR","8","23","23","Nyangka-latju mirrka wantirralpi Mama Kuurrnga tjapiranytja. Nyangka Mamalu-lanyatju kulirnu. ");
INSERT INTO ntj_vpl VALUES ("ER8_31","016_8_31","EZR","8","31","31","Nyangka-latju kapi palunyanya wantirra mularrpartu pakara yalatja kutipitjangu Tjurutjamalakutu. Mapitjalayirnu-latju, nyangka-lanyatju Mama Kuurrtu miranykanyira katirrayintja tjiinya-lanyatjuya mirri pungkupayilu kumpira pungkutjakutarrartu. ");
INSERT INTO ntj_vpl VALUES ("ER8_32","016_8_32","EZR","8","32","32","Nyangka-latju Tjurutjamalakutu parrapitjangu. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","1","Ngaanya Niyamayiku tjukurrpa. Yuwa, kutjulpirtu-rna tawunpa purlkanyangka nyinarranytja Papulanta munkarra. ");
INSERT INTO ntj_vpl VALUES ("NH1_2","017_1_2","NEH","1","2","2","Nyangka ngayuku-tju marlanypa Tjurutjamalanguru marlaku pitjangu. Nyangka-rnalu tjapiranytja, “Ngayuku-lampa yungarrapirti-munta-ya walykumunu nyinarra, ngurra ngaanguru yankutjatjanu? Nyangka-munta tawunpa Tjurutjamanya walykumunurtu puparra?” ");
INSERT INTO ntj_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","Nyangka-rni watjarnu, “Wiya, yaarrpa purlkanya Tjurutjamalawana parrangarapayinya tirtu kartaly-kartalypa ngarala. Kayirrpa pirninyatarrartu-ya kampangu wantitjanya tirtu palunyapirinypartu ngarala. Nyangka-lampaya ngayuku yungarrapirti tjurlpilypa tirtu nyinarra. Tjiinya-ya yarnangu malikilu-tjananya ngarlpupirtira yikarringkupayi.” ");
INSERT INTO ntj_vpl VALUES ("NH1_4","017_1_4","NEH","1","4","4","Nyangka-rna kuliralpi nyinarra yularranytja. Palunyalu-rna tjurlpilypa nyinarranytjalu mirrka ngalkunytjamaaltu wantirranytja. Palunyalu-rna Mama Kuurrnga ngaapirinypa tjapiranytja: ");
INSERT INTO ntj_vpl VALUES ("NH1_5","017_1_5","NEH","1","5","5","Yuwa Mama, nyuntunyan puurrpa purlkanya yilkari katalarra nyinarra. Palunyalun mukulyanytjulu kanyilpayi yarnangu pirni nyarra nyuntuku wangka-ya wangarnarralu kulira palyalpayinya. ");
INSERT INTO ntj_vpl VALUES ("NH1_6","017_1_6","NEH","1","6","6","Mama Kuurr, kulilku-munta-rnin tjiinya-rnanta karlarla mungangka ngayuku yungarrapirtiku tjapiranyangka? Tjiinya-latju kutjupa-kutjupa palyamunu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("NH1_7","017_1_7","NEH","1","7","7","Nyuntuku wangkaku-latju watatjarringu nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("NH1_8","017_1_8","NEH","1","8","8","Yuwa Mama, kulinma tjiinyan kutjulpirtulpi Mawutjala watjarnu wantinytjanya. Tjiinyan watjarnu-lanyatju wililytjingara-wanara ngurra kutjupa-kutjupakutu wantikitjalu tjiinya-latju nyuntunya wantirra kutjupa-kutjupa pupakatirra marninypungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("NH1_9","017_1_9","NEH","1","9","9","Purun watjarnu marlakulu-lanyatjun kapurtura kanyilkitjalu tjiinya-latju marlaku pinkurraalku nyuntuku wangka kulira palyannyangka. ");
INSERT INTO ntj_vpl VALUES ("NH1_10","017_1_10","NEH","1","10","10","Yuwa Mama, ngayulu-rnanta tjapira nyuntuku katja yurntalpirtiku. ");
INSERT INTO ntj_vpl VALUES ("NH1_11","017_1_11","NEH","1","11","11","Yuwa Mama, kulila-rni ngayulu-rnanta tjapiranyangka. Kuwarrinya-rna wayinpa katiku nintilku puurrpa purlkanyaku. Palunyalu-rna tjarlpa tjapilku Tjurutjamalakutu-rni witultjaku. Nyangka-lu wuyurrmarra ngayunya-rni palyarnkarraltjaku. Palunyapirinypa-rna Mama Kuurrta tjapiranytja. Tjiinya-tju ngayuku waarka tjiinya wayinpa puurrpa purlkanyaku katirra nintiratjaku. ");
INSERT INTO ntj_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","1","Nyangka kirnara kutjarra-kutjarratjanulu puurrpa palunyalu nyinarra mirrka ngalkulanytja. Nyangka-rnara wayinpa katingu nintirnu. Nyangka-rni nyangu yiiku kutjuparrinyangka. ");
INSERT INTO ntj_vpl VALUES ("NH2_2","017_2_2","NEH","2","2","2","Palunyalu-rni tjapirnu, “Nyaatjanungkan yiiku kutjuparringu?” ");
INSERT INTO ntj_vpl VALUES ("NH2_3","017_2_3","NEH","2","3","3","Nyangka-rna watjarnu, “Wiya puurr, ngurra nyarra ngayuku tjamupirtiku tjuulpa-ya ngarala, palunyawana yaarrpa kartaly-kartalypa tirtu ngarala.” ");
INSERT INTO ntj_vpl VALUES ("NH2_4","017_2_4","NEH","2","4","4","Nyangka puurrpa palunyalu watjarnu, “Yuwa, nyaakun tjapira?” Nyangka-rna Mamala kurrurntu tjapiralpi ");
INSERT INTO ntj_vpl VALUES ("NH2_5","017_2_5","NEH","2","5","5","puurrpa palunyangka watjarnu, “Yuwa puurr, tjingurun wuyurrarringkulalpi-rnin witulku Tjurutjamalakutu. Nyangka-rnatju mapitjaku ngayuku tjamuku ngurra marlakulurtu palyalku.” ");
INSERT INTO ntj_vpl VALUES ("NH2_6","017_2_6","NEH","2","6","6","Nyangka-rni mularrpartu witurnu. Nyangka-rnalu watjarnu marlaku pitjakitjalu. ");
INSERT INTO ntj_vpl VALUES ("NH2_7","017_2_7","NEH","2","7","8","Puru-rnalu puurrpa tjapirnu lata pirni-rni nintiltjaku nyangka-rnayi kati puurrpa pirniku nintila. Nyangka-rni mularrpartu lata pirni walkatjuralpi yungu. ");
INSERT INTO ntj_vpl VALUES ("NH2_9","017_2_9","NEH","2","9","9","Nyangka puurrpa purlkalu warrmarla pirni witurnu yankula-rniya miranykanyira wanarayiltjaku. Nyangka-latju mularrpartu pitjalayirnu parrapitjangu. Nyangka-rna lata pirninya puurrpa pirniku nintirnu. ");
INSERT INTO ntj_vpl VALUES ("NH2_10","017_2_10","NEH","2","10","10","Nyangka-pula puurrpa kutjupa kutjarralu kuliralpi mirrparnarringu tjiinya-rna pitjanyangka. Tjiinya-pula walykurringu kutjupalu-tjananya Yitjurayilku tjamupirti yirringkankukitja pitjanyangka. ");
INSERT INTO ntj_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","12","Nyangka-rna pitjangu Tjurutjamala nyinarranytja. Palunyalu-rna ngurra marnkurrtjanulu mungangka pakaralpi wati marnkurr-marnkurrpa yarltingu. ");
INSERT INTO ntj_vpl VALUES ("NH2_13","017_2_13","NEH","2","13","15","Nyangka-latju pakara yanu tawunpa yurirlwanalu puriny-purinytju parranyakulanytja. Palunyalu-latju yayirnirringkulanytja yaarrpa kartalypa ngaralanyangka puru kayirrpa pirni kampangu wantitjanya. Palunyalu-latju marlaku parrapitjangu tjarrpangu. ");
INSERT INTO ntj_vpl VALUES ("NH2_16","017_2_16","NEH","2","16","16","Nyangka-ya puurrpa pirninya ngurrpartu nyinarranytja. Tjiinya-rna kumpiltu kuliranytja yaarrpa marlakulurtu palyalkitjalu. Ngayuku yungarrapirtinyatarrartu-rna watjantjamaaltu wantingu. ");
INSERT INTO ntj_vpl VALUES ("NH2_17","017_2_17","NEH","2","17","17","Palunyalu-tjananyarna ngarringu tjirnturringkulalpi pakarnu watjarnu, “Yuwa, ngurra ngaanya-kulila palyamunu tirtu ngarala. Nyangka yaarrpa purlkanyatarrartu kartaly-kartalypa ngarala-wanarayirni. Wiya-kulila kayirrpa pirninyatarrartu kampangu mukirnu nyangka tirtu ngarala. Nyangka-munta-la yaarrpa marlakulurtu palyalku walykumunulku? Nyangka-lampaya puru yikarrikitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("NH2_18","017_2_18","NEH","2","18","18","Puru-tjananyarna tjukurrpa watjarnu tjiinya-rni Mama Kuurrtu yirringkanu puurrpa purlkanya wuyurrmanu. Nyangka-rni mularrpartu witurnu pitjala-rna palyaltjaku. Nyangka-ya watjarnu, “Yuwa, yaarrpa purlkanya-la marlakulu palyala.” Nyangka-ya mularrpartu riitikarraranytja palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("NH2_19","017_2_19","NEH","2","19","19","Nyangka wati yini Tjanpalarrtu-ya kulirnu tjiinya-latju riitikarraranytja yaarrpa purlkanya palyara walykumunulkitjalu. Nyangka-lanyatjuya pitjangu panypuratjarralu ngarlpupirtira watjaranytja, “Nyaaku-yan yaarrpa palyalku? Kulira-munta-yan puurrpa purlkala tungun-tungunarrikitjalu?” ");
INSERT INTO ntj_vpl VALUES ("NH2_20","017_2_20","NEH","2","20","20","Nyangka-rna watjarnu, “Wiya, Mama Kuurrku waarka-latju palyara. Nyangka-lanyatju yirringkanku. Nyangka-latju yaarrpa palyalku wiyalku. Nyuntuku-tjanampanku ngurra wiya ngaanya. Ngayulu-latjunku yungarralu palyara.” ");
INSERT INTO ntj_vpl VALUES ("NH3_1","017_3_1","NEH","3","1","32","Nyangka ngayulu-tjananyarna wati pirninya watjarnu, “Yuwa, yaarrpa palyalkitjalu-yan mawurntal-mawurntaltu palyanma. Kutjupatjarralu-ya mawurntalpa palyanma. Nyangka kutjupatjarralu-ya mawurntalpa palyanma. Palunyapirinypa-yan palyaranytjalu wumu-wumuralpi palyalku wiyalku.” Nyangka-ya mularrpartu palunyapirinypa palyara-wanarayintja. ");
INSERT INTO ntj_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","1","Nyangka wati nyarra Tjanpalarrtu kulirnu tjiinya-latju yaarrpa purlkanya palyaranyangka. Palunyatjanu lirri warurringkulalpi-lanyatju Tjiyu pirninya panypuratjarralu tjumara watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("NH4_2","017_4_2","NEH","4","2","2","Palunyaku yamatji pirningka watjarnu, “Wiya, nyaapanyka-ya Tjiyu pirnilu palyalku? Tjinguru-ya kulira yaarrpa nyarranya waarrpungkula palyara wiyalkitjalu. Wiya, yapu pirninya-ya wartalpitjanu murtuny-murtunyarringu pirniwanartu ngarrirra. Kamu-ya waarrpungku palyalku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("NH4_3","017_4_3","NEH","4","3","3","Nyangka wati kutjupalu tjalkirr-tjalkirrtu watjarnu, “Wiya, yaarrpa yuruly-yurulypa-ya palyara. Wiya-kulila tuukalu tatiralpi punkatjingalku.” ");
INSERT INTO ntj_vpl VALUES ("NH4_4","017_4_4","NEH","4","4","5","Nyangka-rna tjakulpa kuliralpi Mama Kuurrta tjapiranytja, “Yuwa Mama, kulila-lanyatju tjiinya-lanyatjuya yanyan-yanyantu tjumaranyangka. Wiya Mama, kalyparringkutjamaaltu-tjananya tirtu kulinma tjiinya-ya palyamunu palyaranytja.” ");
INSERT INTO ntj_vpl VALUES ("NH4_6","017_4_6","NEH","4","6","6","Nyangka-ya yarnangu pirnilu kurrurnpa wuyurrtu waarkarringkulanytja. Nyangka-latju yaarrpa palyaranytja. Nyangka mularrpartu katu-katurringkulalpi ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NH4_7","017_4_7","NEH","4","7","7","Nyangka Tjanpalarrnga puru wati kutjupatjarra-ya kuliralpi mirrparnarringu. ");
INSERT INTO ntj_vpl VALUES ("NH4_8","017_4_8","NEH","4","8","8","Palunyalu-ya tjumaranytja pitjala-lanyatjuya pungkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("NH4_9","017_4_9","NEH","4","9","9","Nyangka-latju Mama Kuurrta tjapiranytja. Palunyalu-latju wati pirni ngurrkarntanu ngarala-ya nyakulatjaku karlarla mungangkatarrartu. ");
INSERT INTO ntj_vpl VALUES ("NH4_10","017_4_10","NEH","4","10","10","Nyangka-ya waarka palyalpayi pirnilu turlku ngaapirinypa yinkarranytja: “Waarkarringu-waarkarringu-latju talypurringu. Nyangka-ya yapu pirni tirtu ngarrirra. Yaaltjilunyka-latju yaarrpa palyalku wiyalku?” ");
INSERT INTO ntj_vpl VALUES ("NH4_11","017_4_11","NEH","4","11","11","Nyangka mirrparnpa nyinapayilu-ya tjumara watjaranytja, “Wiya, kumpiralpi-lan panykalku-tjananya pungku watarrkulu-ya puparra waarka palyaranyangka.” ");
INSERT INTO ntj_vpl VALUES ("NH4_12","017_4_12","NEH","4","12","12","Nyangka-ya Tjiyu kutjupatjarranya ngamu nyinapayi yarnangu nyarra yanany-yananypa nyinapayila. Palunyalu-ya kulira pitjala-lanyatju watjalpayi tjumaranyangka-ya. ");
INSERT INTO ntj_vpl VALUES ("NH4_13","017_4_13","NEH","4","13","13","Nyangka-rna kuliralpi watjarnu wati pirninya kurlartatjarra puru kunmarnu purlkatjarra-ya ngaralatjaku yaarrpa kuwarripa yarla ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("NH4_14","017_4_14","NEH","4","14","14","Palunyalu-rna parranyakulayirnu yarnangu pirninya watjarnu, “Wiya, palunyaku-tjanampala ngurlurringkutjamaaltu Mama Kuurrnga kulinma. Tjiinya Mama Kuurrnga-lampa purlkanya nyinarra. Nyangka-la ngurlumaaltu pika puwa.” ");
INSERT INTO ntj_vpl VALUES ("NH4_15","017_4_15","NEH","4","15","15","Nyangka yanyan-yanyanpa nyinapayilu-ya pina taparlarrarnu kulirnu tjiinya-latju wartalpitjanu kulintjatjanu ninti nyinarranytja. Tjiinya Mama Kuurrtu-tjananya marrkuralpi ngayunya-lanyatju yangatjura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("NH4_16","017_4_16","NEH","4","16","16","Nyangka-latju ngaapirinypa palyaranytja. Tjiinya kutjupatjarralu-ya yaarrpa palyaranytja. Nyangka kutjupatjarralu-ya kurlartatjarralu kunmarnu purlkatjarralu ngarala miranykanyira kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("NH6_1","017_6_1","NEH","6","1","1","Nyangka-latju yaarrpa purlkanya palyarayirnu wiyarnu. Palunyalu-latju kayirrpa purlkanya pirni kuwarripa palyara ngaratjunkulanytja. Nyangka-ya yarnangu pirni nyarra yanyan-yanyanpa nyinapayilu kulirnu tjiinya-latju yaarrpa purlkanya palyarayirnu wiyannyangka. ");
INSERT INTO ntj_vpl VALUES ("NH6_2","017_6_2","NEH","6","2","2","Nyangka Tjanpalarrtu-ya wati tjukurrtjarra witurnu. Nyangka-rni pitjangu watjarnu yankula-rna wati nyarra Tjanpalarrta lurrtjurringkutjaku ngurra kutjupangka. Parturtu-rna nintilurtu kuliranytja tjiinya-rni ngarnartu mayuranytja pungkukitjalu. ");
INSERT INTO ntj_vpl VALUES ("NH6_3","017_6_3","NEH","6","3","3","Palunyalu-rnalu watjarnu marlaku yankula watjaltjaku, “Wiya, waarka purlkanya-rna palyara. Nyaatjanungka-rna wantirra yanku nyuntulakutu? Tjiinya-rna wantirra yankukitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("NH6_9","017_6_9","NEH","6","9","9","Tjiinya-ya yanyan-yanyanpa nyinapayilu kuliranytja ngurlutjingalkitjalu. Nyangka-latjuyi waarka wanti. Palunyangka-rna Mama Kuurrta tjapiranytja kurrurnpa-rni rapara kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("NH6_10","017_6_10","NEH","6","10","10","Nyangka-rna yanu wati kutjupangka yakatjarri nyinakitja. Nyangka-rni watjarnu, “Wiya, yarra-li tjurrtju purlkanyangka kumpiralpi nyinama. Tjiinyanta-ya pitjaku pungku mirrirntanku. Mungangkatarrartunta-ya pitjaku pungku tjunku.” ");
INSERT INTO ntj_vpl VALUES ("NH6_11","017_6_11","NEH","6","11","11","Nyangka-rna watjarnu, “Wiya, kamu-rna ngurlu kukurraalku kumpiralpi nyinama.” ");
INSERT INTO ntj_vpl VALUES ("NH6_12","017_6_12","NEH","6","12","12","Palunyatjanu-rna pina taparlarraralpi kulirnu tjiinya Mama Kuurrnga wati palunyangka wangkanytjamunurtu. Tjiinya Tjanpalarrtu-ra tjimarri nintirnu ngayunya-rni ngarnartu mayultjaku. ");
INSERT INTO ntj_vpl VALUES ("NH6_13","017_6_13","NEH","6","13","13","Nyangka-rnayi ngurlurringkulalpi miirl-miirlta tjarrpa. Nyangka-rniyayi puntura watjanma palyamunu-rna miirl-miirlta tjarrpanyangka. ");
INSERT INTO ntj_vpl VALUES ("NH6_15","017_6_15","NEH","6","15","15","Nyangka-latju yaarrpa purlkanya palyarayirnu wiyarnu. Palunyalu-latju kayirrpa pirninya palyarnu ngaratjuralpi yangatjunu parrawanarnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("NH6_16","017_6_16","NEH","6","16","16","Nyangka-ya yarnangu yanyan-yanyanpa nyinapayilu kuliralpi kurltjirraarnu. Tjiinya-ya nintilu kulirnu Mama Kuurrtu-lanyatju yirringkaranytja. Nyangka-ya ngurra kutjupa-kutjupangkatjalu kuliralpi ngurlurringu. ");
INSERT INTO ntj_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Nyangka-ya Yitjurayilku tjamupirti parranyinarranytja yiwarla kurluny-kurlunypa pirningka, tjiinya Tjurutjamala ngamu parrapuparra-wanarayinnyangka. Palunyalu-ya pakara pitjangu Tjurutjamala lurrtjurringu nyinarranytja. Palunyalu-ya watjarnu Yatjuralu ruula nyarra Mawutjalu walkatjunu wantitjanya mantjira katitjaku. ");
INSERT INTO ntj_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Nyangka mularrpartu mantjira katingu. Tjiinya-ya pirninyartu kapurturringu nyinarranytja wati, minyma, tjilkutarrartu. ");
INSERT INTO ntj_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Nyangka Yatjuralu Mawutjaku wangka rawalu nyakula watjara-wanarayintja. Tjiinya mungayurnturalpi tirtu nyakula watjara-wanarayirnu karlarlarringu. Palunyangka-ya pirnilurtu tirtu kuliranytja. ");
INSERT INTO ntj_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Tjiinya Yatjuranya tatirnu katu-katu ngaralanytja. Nyangka-ya pirnilurtu nyakulanytja. Nyangka Yatjuralu ruula purlkanya wirlkarnu. Palunyangka-ya pakarnu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Nyangka Yatjuralu watjarnu, “Yuwa, Mama Kuurrnga walykumunu mularrpa. Mama Kuurrnga mularrpa purlkanya nyinarra.” Nyangka-ya yarnangu pirnilu mara katuralpi watjarnu, “Yuwa walykumunu.” Nyangkalta-ya pirninyartu pupakatingu. ");
INSERT INTO ntj_vpl VALUES ("NH8_7","017_8_7","NEH","8","7","8","Nyangka Yatjuralu Mawutjaku wangka nyakula watjaranytja. Nyangka-ya wati kutjupatjarralu parrapitjala yarnangu pirninya watjara yutiranytja. ");
INSERT INTO ntj_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Nyangka-ya Mawutjaku wangka kuliralpi yularranytja. Tjiinyamarntu-ya tjukarurru nyinarranytjamunu. Nyangka-ya Niyamayilu puru Yatjuralu puru wati kutjupatjarralu-tjananya parramarrkura watjaranytja, “Wiya, yulamaalpa-ya nyinama. Tjiinya-lampa tjirntu ngaanya ngarala Mama Kuurrnga-la pukurltu kuliratjaku.” ");
INSERT INTO ntj_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Nyangka Niyamayilu-tjananya watjaranytja, “Mapitja-ya ngurraku palunyalu pukurltu mirrka ngalkunma puru wayinpa tjikinma. Puru-ya yirringkara mirrka wayinpa nintinma yarnangu nyarra maralpa-ya nyinarranytjaku. Tjiinya-lampa tjirntu ngaanya ngarala Mama Kuurrnga-la pukurltu kuliratjaku. Tjurlpilymaalpa-ya pukurlpa nyinama. Tjiinya Mama Kuurrtu-tjananyanta pukurlmara kanyira. Nyangka-yan kurrurnpa rapa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("NH8_11","017_8_11","NEH","8","11","11","Nyangka-ya wati kutjupatjarralu parrawatjaranytja, “Tjiinya-lampa tjirntu ngaanya ngarala Mama Kuurrnga-la pukurltu kuliratjaku. Nyangka-ya tjurlpilymaalpa pukurlpa nyinama.” ");
INSERT INTO ntj_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","Nyangka-ya ngurrakutu-ngurrakutu yanu. Palunyalu-ya pukurltu tjikira mirrka ngalkulanytja. Puru-ya yirringkara nintiranytja nyarra maralpa-ya nyinarranytjaku. Tjiinyamarntu-ya yuti kulirnu Mawutjaku wangka nyakula watjaranyangka. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Nyangka wati yini Tjawupanya ngurra kutjupangka nyinarranytja. Wati palunyanya tjukarurru nyinarranytja. Palunyalu kutjupa-kutjupa palyamunu palyantjamaaltu Mama Kuurrnga walykumunulu wanaranytja. ");
INSERT INTO ntj_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Nyangka-pula kurrirarralu katja 7-pa puru yurntalpa marnkurrpa kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Puru tjiipu, kamurlpa, puluka puru tungki pirni kanyiranytja. Puru waarka palyalpayi pirni kanyiranytja. Puru tjimarri purlkanya kanyiranytja wati pirningka munkarra. ");
INSERT INTO ntj_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Nyangka-ya yayintjulpa pirninya pitjangu kapurturringu Mama Kuurrta ngaralanytja. Nyangka Tjayitinngatarrartu lurrtjurringkula pitjangu ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Nyangka Mama Kuurrtu-lu watjarnu, “Yuwa Tjayitin, wanytjangurun pitjangu?” Nyangka watjarnu, “Wiya, parna lipiwanartu-rna parrapitjalayintja.” ");
INSERT INTO ntj_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Nyangka Mama Kuurrtu-lu tjapirnu, “Nyangu-muntan ngayuku waarka palyalpayi yini Tjawupanya? Tjiinya kutjupa palunyapirinypa nyinarranytjamunurtu. Wati palunyalu kutjupa-kutjupa palyamunu palyaranytjamunu tjukarurru nyinapayi. Palunyalu-rni mularrkulilpayi.” ");
INSERT INTO ntj_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Nyangka Tjayitintu watjarnu, “Wiya, wati palunyalunta kunpu-kunpu wanalkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Tjiinyamarntun nyuntulu-lu tirtu miranykanyira kanyilpayi. Palunyaku yungarrapirtitarrartun miranykanyira kanyilpayi. Walykumunura-lun kanyilpayi. Nyangka-ra puluka tjiiputarrartu pirnirringu ngarala. Palunyangurungkanta tirtu wanarayirni. ");
INSERT INTO ntj_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Nyangka-tjingurun kurralku palunyaku yungarrapirti puru kutjupa-kutjupa kanyiranytjanya. Nyangkanta palyamunu watjalku.” ");
INSERT INTO ntj_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Nyangka Mama Kuurrtu watjarnu, “Yuwa, palya-tjananyan kurralku palunyaku yungarrapirti puru kutjupa-kutjupa pirni kanyiranytjanya. Palunyalu-lu Tjawupanya pampuntjamaaltu wanti.” Nyangka Tjayitintu wantirra kutipitjangu. ");
INSERT INTO ntj_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Nyangka Tjawupaku katja yurntalpa pirnilu-ya pukurltu ngalkula puru tjikiranytja palunyaku kurta tirnaku ngurrangka. ");
INSERT INTO ntj_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Nyangka wati kutjulu ngalyakukurraarnu Tjawupanya watjarnu, “Wiya, puluka pirnitjarralu-latju parna parratjawaranytja. Nyangka-ya tungki pirnilu ngamuwanalu yukiri parrangarala ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","Nyangka-ya wati mulyatanytju pirnilu pitjangu waarka palyalpayi pirninya pungu wiyarnu. Palunyalu-ya puluka puru tungki pirninya mulyatarrirra katingu. Nyangka-rna ngayulukutju wankarringkula ngalyakukurraarnu watjalkitja-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Nyangka kuwarripa ngarala wangkarranyangka wati kutjupalulpi ngalyakukurraarnu watjarnu, “Wiya, wanangaralu-tjananya tjiipu pirninya puru miranykanyilpayi pirninya rungkarnu mirrirntanu wiyarnu. Nyangka-rna ngayulukutju wankarringkula ngalyakukurraarnu watjalkitja-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Nyangka kuwarripa ngarala wangkarranyangka wati kutjupalulpi ngalyakukurraarnu watjarnu, “Wiya, wati pirni-ya kayilinguru pitjangu-lanyatju parrayangatjuralpi kamurlpa kanyilpayi pirninya pungu wiyarnu. Palunyalu kamurlpa pirninyartu mulyatarrirra katingu. Nyangka-rna ngayulukutju wankarringkula ngalyakukurraarnu watjalkitja-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Nyangka kuwarripa ngarala wangkarranyangka wati kutjupalulpi ngalyakukurraarnu watjarnu, “Wiya, nyuntuku katja yurntalpa pirnilu-ya pukurltu ngalkula puru tjikiranytja palunyaku kurta tirnaku ngurrangka. ");
INSERT INTO ntj_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","Nyangka pirriya purlkanyalu ngalyakukurraaralpi yiwarla yurnturnu punkatjingarnu. Nyangkalta-ya pirninyartu kaninytjarra wiyarringu. Nyangka-rna ngayulukutju wankarringkula ngalyakukurraarnu watjalkitja-rnanta.” ");
INSERT INTO ntj_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Nyangka Tjawupalu kuliralpi tjuni kartalytjunku warntu wartunpungu. Palunyalunku mangka kartarnu wiyarnu. Palunyalu mantangka pupakatirralpi ");
INSERT INTO ntj_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","watjarnu, “Wiya, maralpa-rna pilyirrpa ngarringu. Puru-rna maralpartu mirrirriku. Tjiinya Mama Kuurrtu-rni pirnipurlka nintirnu. Palunyalu marlakulurtunku mantjirnu. Yuwa, Mama Kuurrnga walykumunu mularrpa.” ");
INSERT INTO ntj_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Tjiinya Tjawupalu tjuni kartakatirralpi kutjupa-kutjupa palyamunu palyantjamaalpartu. Palunyalu Mama Kuurrnga palyamunu watjantjamaalpartu. ");
INSERT INTO ntj_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Nyangka-ya yayintjulpa pirninya marlakurtu pitjangu Mama Kuurrta lurrtjurringu ngaralanytja. Nyangka Tjayitinngatarrartu pitjangu lurrtjurringkulalpi ngaralanytja. ");
INSERT INTO ntj_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Nyangka Mama Kuurrtu-lu tjapirnu, “Yuwa Tjayitin, wanytjangurun pitjanytja?” Nyangka watjarnu, “Wiya, parna lipiwanartu-rna parrapitjalayintja.” ");
INSERT INTO ntj_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Nyangka Mama Kuurrtu tjapirnu, “Wiya, nyangu-muntan ngayuku waarka palyalpayi Tjawupanya? Tjiinya kutjupa palunyapirinypa nyinarranytjamaalpartu. Tjiinya wati palunyalu kutjupa-kutjupa palyamunu palyaranytjamunu tjukarurru tirtu nyinapayi. Palunyalu-rni ngayunya tirtu wanara. Parturtu ngaangkalpi-rnin nyuntulu witu-witurnu. Nyangka-rna palyarnkarrarnu kunpu-kunpu-lun kurraltjaku. Nyangka-rni ngayunya tirtu wanara.” ");
INSERT INTO ntj_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","5","Nyangka Tjayitintu watjarnu, “Wiya, nyuntulu-tjinguru-lun pikatjarralku. Nyangkanta palyamunu watjalku.” ");
INSERT INTO ntj_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Nyangka Mama Kuurrtu watjarnu, “Yuwa, palya-tjingurun pampulku pikatjarralku. Palunyalu-lu pungkula mirrirntankutjamaaltu wanti.” ");
INSERT INTO ntj_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Nyangka Tjayitintu yanu Tjawupanya-lu pampurnu pikatjarrarnu. Nyangka yurnturrngu pirni-lu nyinakatingu. ");
INSERT INTO ntj_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Nyangka tjuni kartalytju ngurra wantirra yilkaku yanu rapitjingka nyinarranytja. Palunyalu yapu yiri mantjiralpi pika pirriranytja. ");
INSERT INTO ntj_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Nyangka palunyaku kurrilu pitjangu watjarnu, “Tirtu-muntan Mama Kuurrnga wanarayirni? Palya-tjingurun Mama Kuurrnga mirrparn-mirrparntu watjanma nyangkanta pungkula mirrirntanama.” ");
INSERT INTO ntj_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Nyangka Tjawupalu watjarnu, “Wiya, katakurralun watjara.” Tjiinya Tjawupalu kunngalarrirra Mama Kuurrnga watjantjamunurtu. ");
INSERT INTO ntj_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Nyangka Mama Kuurrtu-lu Tjawupanya marlakulurtu walykumunura kanyiranytja. Nyangka kutjupa-kutjupa walykumunu pirni kanyiranytja tjiinya kutjulpirtulpi kanyiranytja, palunyangka munkarra. ");
INSERT INTO ntj_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Nyangka-ya Tjawupaku kurta tjurtupirti puru yamatji pirnilu-ya pitjangu pukurltu mirrka ngalkulanytja palunyaku yiwarlangka. Tjiinya-ya pitjangu ngarlturringkula watjaranytja tjiinyamarntu-ra kutjupa-kutjupa palyamunu ngarangu, palunyangka. Puru-ya tjimarri katingu nintirnu. ");
INSERT INTO ntj_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Nyangka Mama Kuurrtu-ra Tjawupaku pirnipurlka puru nintirnu, tjiipu, puluka, kamurlpa puru tungkitarrartu tjiinya kutjulpirtu kanyiranytja, palunyangka munkarra. ");
INSERT INTO ntj_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Puru-ra Mama Kuurrtu katja 7-pa nintirnu puru yurntalpa marnkurrpa. ");
INSERT INTO ntj_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Nyangka Tjawupanya rawa nyinarrayirnu tjamu kaparlipirti ma-nyangu puru mama ngunytju kurlunypatarrartu. ");
INSERT INTO ntj_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Palunyalu yirna purlkarringkulalpi mirrirringu. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","2","Yuwa, yarnangu palyamunuku wangka-ya kulira nyinanytjamaaltu wantima. Palunyalu-ya palyamunu pirningka yarangka wanarayintjamaaltu wantima. Palunyalu-ya lurrtjurringkula nyinarranytjamaaltu wantima Mama Kuurrnga-ya panypuratjarralu watjaranyangka. Wiya, Mama Kuurrku wangka mukulyanytjulu-ya karlarla mungangka pukurltu kulinma. Yuwa, palunyapirinypa-yan tirtu nyinarranyangka Mama Kuurrtu-tjananyanta walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Yuwa, palunyapirinypa-yan nyinarranytjalu warta purlkurnpirinypa nyinama. Tjiinyakurlu warta kapingkartu pakala mirrka purlkanya kanyinma, palunyapirinypa. Palunyalu-yan kutjupa-kutjupa walykumunura palyanma. ");
INSERT INTO ntj_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Nyangka-ya yarnangu palyamunu tjanmarta minyarrapirinypa nyinama. Tjiinyakurlu tjanmarta rurrmupungama. Nyangka pirriyalu minyarra katima, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Tjiinya yarnangu palyamunu pirnilu-ya purtu kulilku tjiinya Mama Kuurrtu yarnangu pirninya tjarraranyangka. Tjiinya-tjananya yarnangu palyamunu pirninya tjarralku. Palunyangka-ya purtu kulilku Mama Kuurrku yungarrapirtingka nyinakitjalu. ");
INSERT INTO ntj_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Nyangka-ya yarnangu nyarra yiwarra tjurrkurlwana mapitjalayirni, palunyanya-tjananya Mama Kuurrtu miranykanyira kanyinma. Nyangka yarnangu palyamunu pirninya-ya mirrikutu mapitjalayirni yiwarra palyamunuwana. ");
INSERT INTO ntj_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Yuwa Puurr, nyuntulu-rnin miranykanyira kanyilpayi. Tjiinyakurlu watilu tjiipu miranykanyinma. Palunyapirinytju-rnin miranykanyira kanyilpayi. Nyangka-rna pirnipurlka kanyira nyuntulu-tjun nintiranyangka. ");
INSERT INTO ntj_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Patalypa-rna nyinarranyangka nyuntulu-rnin nyinatjunkupayi yukiri walykumunungka. Palunyalu-rnin walara katipayi kapi warla walykumunukutu. ");
INSERT INTO ntj_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Kurltjirr-kurltjirrpa-rna nyinarranyangka nyuntulu-rnin kurrurnpa yipilymara kanyilpayi. Puru-rnin yiwarra tjukarurruwanalu walara katipayi, tjiinyamarntu-rnin kalkurnu wantinytjatjanulu. ");
INSERT INTO ntj_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Kamu-rna ngurlurriku mirrirrikitja. Tjiinyamarntu-lin lurrtjurtu yankulayirni. Nyuntulu-rnin wartatjarralu paalytjura kanyilpayi. Tjiinyakurlu tjiipu miranykanyilpayilu warta kanyinma papa nganyirri purlkanya pungkukitjalu. Palunyapirinytju-rnin walara katirrayilpayi. Nyangka-rnanta kurrurnpa rapalu wanarayirni. ");
INSERT INTO ntj_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Nyuntulu-tjun mirrka kutjupa-kutjupa pirni palyara tjunkupayi, yanyan-yanyanpa pirnilu-rniya nyakulanyangka. Palunyalu-rnin pukurltu yarltipayi pitjala-rna mirrka ngalkulatjaku. Puru-tjun panikinta tjutira mulyawiilymankula tjunkupayi purlkanya-rna tjikiltjaku. ");
INSERT INTO ntj_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Yuwa, nyuntulu-rnin ngarltunytjulu tirtu kanyinma. Nyangka-rna nyuntuku ngurrangka tirtu nyinaku nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Mama Kuurrtu-lanya yangatjura kanyilpayi. Nyangka-lan kurrurnpa rapa nyinarra. Tjiinya-lanya tirtu yirringkara kanyilpayi kutjupa-kutjupa ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Palunyangka-lan ngurlumaalpa nyinama. Nyangka mantatarrartu yurrirranyangka purli wararra kartakatirra yuru purlkanyangka punka-punkara tjarrparranyangka-lan ngurlumaalpa nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Tjinguru kapi warnanpa purlkanya wirtatjarra rurrku kukurrmanku. Wiya, ngurlumaalpa-lan nyinama. Tjiinya yapu wararratarrartu tiltirr-tiltirrmaranyangka, ngurlumaalpa-lan nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Yuwa, kapi warla walykumunulu yarnangu Tjurutjamanyamartatji pirninya pukurlmara kanyilpayi. Yiwarla nyarra Mama Kuurrnga-ya lurrtjurringkula marninypungkupayi, palunyangka. ");
INSERT INTO ntj_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Mama Kuurrnga yiwarla palunyangka tirtu nyinama. Nyangka-ya pungkula wiyalkitjalu purtulinku wantiku. Tjiinyamarntu Mama Kuurrtu waarrpungkulalpi yangatjunku kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Yuwa, ngurra kutjupa-kutjupangkatjalu-yanku pika pungkulanyangka Mama Kuurrnga tuturapirinypa wangkama. Nyangka-ya manta lipingkatjalu kuliralpi ngurluny-ngurlunyarriku. ");
INSERT INTO ntj_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yuwa, Mama Kuurrtu Yayirninytjulu Palyalpayilu-lanya miranykanyira kanyira. Mama Kuurrnga, tjiinya Tjayikapalu pupakatirra marninypungkupayi, palunyalu-lanya yangatjura kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Pitjalalpi-yan nyaku kata paarnarralku Mama Kuurrtu manta lipiwanalu kutjupa-kutjupa palyarnu wantinyangka. ");
INSERT INTO ntj_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Tjiinya Mama Kuurrtu marrkulpayi yarnangu pirnilu-yanku warrmarlara manta lipiwanalu pika pungkulanyangka. Palunyalu kurlarta, kupulu pirninya kartarntankupayi, puru tjara pirninya tilira tjarrpatjunkupayi. ");
INSERT INTO ntj_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Mama Kuurrtu watjarnu, “Wiya, tjurlpilyarrinytjamaalpa-ya kurrurnpa yipilyarri. Palunyalu-rniya ngayunya ruukulila tjiinya-tjanamparnanku puurrpa purlkanya nyinarranyangka. Nyangka yarnangu ngurra kutjupa-kutjupangkatjalu-rniya manta lipingkatjalurtu marninypungama.” ");
INSERT INTO ntj_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yuwa, Mama Kuurrtu Yayirninytjulu Palyalpayilu-lanya miranykanyira kanyira. Mama Kuurrnga, tjiinya Tjayikapalu pupakatirra marninypungkupayi, palunyalu-lanya yangatjura kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Wati yini Tayipirrnga kampangkartu ngarringu wati kutjupaku kurringka. Nyangka wati yini Nayitjintu tjiinya Mama Kuurrku wangka kulira tjakultjunkupayilu pitjangu Tayipirrnga-lu punturnu watjarnu tjiinya wati kutjupaku kurri pampunnyangka. Nyangka palunyalanguru Tayipirrtu turlku ngaanya walkatjunu. Yuwa Mama, ngarlturriwa-tju ngayuku. Tjiinya-rnin mukulyanytjulu miranykanyira kanyilpayi. Yuwa, nyuntulun walkatjunu wantingu palyamunu-rna palyaranyangka. Nyangka-munta-tjun ruwarrpungku wiyalku? Tjiinyamarntun ngarltunytju purlkanya nyinarra. ");
INSERT INTO ntj_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Parltjila-rni walykumunula palyamunu-rna palyarnu palunyangka. ");
INSERT INTO ntj_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Tjiinya-rna nintilu kulira palyamunu palyantjatjanulu. Palunyalu-rna purtu watarrkurringkula. Tirtu-rna kulira palyamunu palyantjatjanulu. ");
INSERT INTO ntj_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Nyuntuku wangka-rna tungun-tunguntu wantingu. Nyuntula mirangka-rna palyamunu palyarnu. Nyangka-rnin tjurrkurltu watjara palyamunu-rna palyannyangka. ");
INSERT INTO ntj_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Yuwa, pilyirrngurulpi-rna palyamunu tirtu palyaranytja. ");
INSERT INTO ntj_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Yuwa Mama, nyuntulun mukurringkula tjiinya-rna mayuranytjamaalpa tjukarurru nyinarratjaku. Palunyanguru-rni nyuntuku wangka pinangka tjarrpatjurra. ");
INSERT INTO ntj_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Parltjila-rni. Nyangka-rna walykumunu nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Mama, watjala-rni kalyparringkutjatjanulu. Nyangka-rna pukurlarri nyinama. Nyuntulu-rnin kurltjirr-kurltjirrmanu. Kuwarrinya-rni kurrurnpa pukurlmara kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Tirtu-kurlun kulinma palyamunu-rna palyarnu palunyangka. Wanti. Yuwa Mama, nyuntuku walkangka ngarala. Nyangka-tju ruwarrpuwa wiyala. ");
INSERT INTO ntj_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Wiya Mama, kurrurnpa-rni parltjila walykumunula. Palunyalu-rni wuyurrpa tjurrkurlmara kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Wiya Mama, wituntjamaaltu-rni ngamulu kanyinma. Nyuntuku Kuurti Walykumununya katinytjamaaltu wanti. Nyangka-rni ngayula nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Pukurlmara-rni kanyinma, nyarra wankarunkulalpi-rnin pukurlpa kanyiranytja, palunyapirinypa. Palunyalu-rni wuyurrmarra nyuntuku wangka wangarnarralu kulira palyaratjaku. ");
INSERT INTO ntj_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Nyangka-rnayi nyuntuku wangka nintipungama yarnangu nyarra palyamunu pirningka. Nyangka-yayi pinkurraara marlaku pitja nyuntulakutu. ");
INSERT INTO ntj_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Mama, nyuntulu-rnin kutjulu wankarunku. Nyangka-kurlu-rnin ngaparrtjika pungku tjunku tjiinya-rna wati nyarranya pungu tjunkunyangka. Palunyangka-rna mirrarra yinkama nyuntulu-rnin wankarunkunyangka. ");
INSERT INTO ntj_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Mama, yirringkala-rni wangkarra-rna nyuntunya marninypungkulatjaku. ");
INSERT INTO ntj_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tjinguru-rnanku mirrka kuka katiku witaralpi nintilku. Wiya, pukurlarrikitjamunu-tjun. ");
INSERT INTO ntj_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Tjiinya-rna kurrurnpa tjirturu-tjirturu palyamununguru kurntarringku, palunyangka-tjun pukurlarriku. Palunyalu-rnin wituntjamaaltu ngamuntinku kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Yuwa Mama, walykumunura-tjananya kanyinma yarnangu pirninya nyarra Tjurutjamala nyinarranytjanya. Palunyalu-tjananya yirringkanama. Nyangka-yayi yaarrpa purlkanya yiwarlawana marlakulu parrapalyanma. ");
INSERT INTO ntj_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Palunyalu-latju palyamunu palyaralpi kurntarringkula nyinanytjatjanulu puluka pungku witalku nyuntuku nintilku. Nyangkan pukurlarriku. ");
INSERT INTO ntj_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Turlku ngaanya Tayipirrtu mayu-mayu nyinarranytjalu walkatjunu wantingu. Yuwa Mama, nyuntunya-rnanta pupakatirra marninypungkupayi. Palunyalu-rnanku kurrurnpatarra mukurringkula. Tjiinyakurlu-ya ngurra yayilurrungka pitjalayila purtu mukurringkula pinalukutju kulinma, “Kapipalka ngarrima. Nyangka-rna waarrpungkulalpi tjikila.” Palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Yuwa, mukurringkula-rnanta nyuntunya nyakukitjalu. Puru-rna mukurringkula nyuntuku tili purlkanya nyakukitjalu tjurrtjungka yirrnyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Walykumunu tjiinya wanka-rna nyinarratjaku. Nyangka palunyangka munkarra ngarala tjiinya-rnin mukulyanytjulu kanyiratjaku. Palunyalangurulta-rnanta marninypungama. ");
INSERT INTO ntj_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Yuwa, nyuntunya-rnanta marninypungkulayilku ma-mirrirriku. Puru-rnanta mara katura warlkura tjapinma. ");
INSERT INTO ntj_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Yuwa, kurrurnpa-rna pukurlpa nyinama. Tjiinyakurlu kukatjanu parltjarringkulalpi pukurlpa nyinama, palunyapirinypa. Palunyalu-rnanta pukurltu yinkarra marninypungama. ");
INSERT INTO ntj_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Mungangka-rnanta ngarrirra kulilpayi. Wankalu-rnanta kulira tjirnturringkupayi. ");
INSERT INTO ntj_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Yuwa, tirtu-rnin yirringkara kanyilpayi. Palunyangka-rnanku turlku pukurltu yinkapayi, tjiinyamarntu-rnin yangatjura kanyiranyangka. Tjiinyakurlu tjurlpulunku kurlunypa pirninya nyarlpilu yangatjura kanyinma. Palunyapirinytju-rnin kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Lurrtju-rnanta tirtu nyinama. Nyangka-rnin waku purlkanyalu patjurira kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Yarnangu nyarra nyinarra-rniya yurakanyira pungkula tjunkukitjalu, ");
INSERT INTO ntj_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","palunyanya-tjananya warrmarlalu pungku tjunku. Nyangka ngupanulu pitjaku ngalku wiyalku. ");
INSERT INTO ntj_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Yuwa Mama, ngayulu-rnanta puurrpa purlkalu pukurltu marninypungama, tjiinya-rnin yirringkaranyangka. Nyangkanta-ya yarnangu nyarra nyuntunya mularrkuliranytjalu marninypungama. Nyangka-ya mayulpayi pirninya kanmarrarriku nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Ngayulu-tjinguru-rna Mama Kuurrnga tjiinya yayirninytjulu palyalpayingka ngamu nyinama. Nyangka-rni yangatjura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Nyangkalta-rna Mama Kuurrta watjalku, “Nyuntulu-rnin tjarapirinytju yangatjura kanyilpayi. Nyangka-rnanta nyuntunyakutju pupakatirra marninypungama. Palunyalu-rnanta mula-mularringkula kulinma.” ");
INSERT INTO ntj_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Kulila. Kutjupalu-tjingurunta punkatjingalku. Wiya, Mama Kuurrtunta katulku. Nyangka-tjinguru-ya pirninya pika purlkanyatjarra ngarrima. Nyangkanta Mama Kuurrtu wankarura kanyinma mirrirritjakutarra. ");
INSERT INTO ntj_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Yuwa, Mama Kuurrtunta yangatjura kanyinma. Tjiinyakurlu tjurlpulunku kurlunypa pirninya nyarlpilu yangatjura kanyinma, palunyapirinytju. Mama Kuurrtunta watjarnu wantinytjatjanulu kanyinma. Tjiinyanta tjurlpu nyarlpipirinytju yangatjura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Wiya, nyaakun ngurlurringkula mamulunta mungangka pitjala pungkutjaku? Wiya, Mama Kuurrtunta miranykanyinma. Nyaakunykan ngurlurringkula karlarla-ya kurlarta warnirranyangka? Wiya, Mama Kuurrtunta yangatjura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Nyaakun ngurlurringkula mungangka pikatjarrarritjaku? Wiya, Mama Kuurrtunta miranykanyinma. Nyaakun ngurlurringkula kutjupa-kutjupa karlarla yutirringkulanyangka? Wiya, Mama Kuurrtunta yangatjura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Tjinguru yarnangu pirninya nyuntula yitingkartu punkalku mirrirriku. Nyangkan kutjuwanka ngarama. ");
INSERT INTO ntj_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Palunyalun nyaku Mama Kuurrtu-tjananya palyamunu pirninya ngaparrtjika pungku wiyannyangka. ");
INSERT INTO ntj_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Yuwa, kurrurnpa rapalun kulira Mama Kuurrtunta purlkanya nyinarranytjalu yangatjura kanyiratjaku. ");
INSERT INTO ntj_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Palunyangka kutjupa-kutjupalu pikanku nintilkitjamunu. Nyangka nyuntuku ngurrangka palyamunu ngarakitjamunu. ");
INSERT INTO ntj_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Nyangka Mama Kuurrtunku palunyaku yayintjulpa pirninya witulku miranykanyiranta-ya kanyiratjaku, tjiinyan ngurra kutjupa-kutjupakutu yankulanyangka. ");
INSERT INTO ntj_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Nyangka yayintjulpa pirnilunta-ya maralu katura kanyinma yapulunta tjina pikarntankutjakutarrartu. ");
INSERT INTO ntj_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Purun layinpa nganyirri purlkanyawana lirruwanatarrartu parrangarama. Nyangkanta-ya patjalkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Yuwa, Mama Kuurrtu watjarnu, “Nyuntulu-tjun mukulyanytju nyinarranyangka ngayulu-rnanta wankarura kanyinma. Ngayulu-rnanta yangatjura kanyinma nyuntulu-rnin puurrpa warlkuranyangka. ");
INSERT INTO ntj_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Nyangka-tjingurunku palyamunu yartakarrinyangka ngayula-rni tjapinma. Nyangka kuliralpi-rnanta yampura kanyinma. Palunyalu-rnanta walykumunura kanyinma wanka nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ngayulu-rnanta wankarura kanyinma. Palunyangkan rawa nyinarrayilku ma-mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Yarnangu pirni, Mama Kuurrnga-ya pukurltu marninypungama. Ngurra kutjupa-kutjupangkatja pirni, turlku-ya yinkarra Mama Kuurrnga marninypungama. ");
INSERT INTO ntj_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Yuwa, tjurrtjungka-ya turlku yinkarra tjarrpama. Palunyalu Mama Kuurrnga pukurltu marninypungama. ");
INSERT INTO ntj_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Nintilu-yan kulira Mama Kuurrnga Puurrpa Purlkanya nyinarranyangka. Kutju-palunyalu-lampa tjamupirti lurrtjurnu palunyaku katja yurntalpirti-ya nyinarratjaku. Nyangka ngayulutarrartu-lan palunyaku nyinarra. Ngayulu-lan Mama Kuurrku tjiipupirinypa nyinarra. Nyangka-lanya katja yurntalpirti kurrurnkurlu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Mapitja-ya tjurrtju kayirrpangka tjarrparralpi watjala, “Mama, walykumunulu-lanyatjun miranykanyira kanyiranytja.” Palunyatjanulu-ya tjurrtjungka ma-tjarrparralpi Mama Kuurrnga marninypungkuma. ");
INSERT INTO ntj_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Yuwa, Mama Kuurrnga walykumunu mularrpa. Palunyalu-lanya mukulyanytjulu miranykanyira kanyira. Mama Kuurrtu-lanya tirtu kanyinma watjarnu wantinytjatjanulu. Puru-tjananya katja yurntalpirti marlangkatja-marlangkatjanya pakaranyangka miranykanyira kanyinma. ");
INSERT INTO ntj_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Yuwa Mama, nyuntuku wangkaku-rna mukulyanytju nyinarra. Wantinytjamaaltu-rna kulira-wanara tjirntu tjarrpatjura. ");
INSERT INTO ntj_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Nyuntuku wangka-rna pinangka kanyilpayi. Palunyalanguru-rna nintipukarringu nyinarra, nyarra yanyan-yanyanpa-ya nyinarra, palunyangka munkarra. ");
INSERT INTO ntj_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Nyuntuku wangka-rna tirtu kuliranytjatjanu nintipukarringu nyinarra, nyarra ngayunya-rniya nintipungkulanytja, palunyangka munkarra. ");
INSERT INTO ntj_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Nyuntuku wangka-rna wangarnarralu kulira palyaranytja. Palunyalanguru-rna nintipukarringu nyinarra, tjiinya nyalpa pirningka munkarra. ");
INSERT INTO ntj_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Yiwarra lipinya-rna wantipayi tjiinya nyuntuku wangka wangarnarralu kulira palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Nyuntuku wangka-rna wantikitjamunu. Nyuntulumarntu-rnin nintipungkulanyangka. ");
INSERT INTO ntj_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Nyuntuku wangka pukarapirinypa tjiinya yirliltungka munkarra. ");
INSERT INTO ntj_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Nyuntuku wangka kuliranytjatjanu-rna nintipukarringu nyinarra. Palunyalanguru-rna yiwarra nyarra lipiku yanyan-yanyanpa nyinarra. ");
INSERT INTO ntj_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Yuwa Mama, nyuntuku wangka tilipirinypa tjiinya yiwarra-tju pirntaltjingara kanyilpayi. Nyuntuku wangka pirntal-pirntalpirinypa. Nyangka-rna palunyatjarra tjukarurru mapitjalayilku parrapitjaku. ");
INSERT INTO ntj_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Nyuntuku wangka tjukarurru mularrpa ngarala. Nyangka-rnanta watjarnu wantingu wangka palunyanya wangarnarralu kulira palyalkitjalu. ");
INSERT INTO ntj_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Wiya, yarnangu pirnilu-rniya parrawanarayirni mirri pungkula tjunkukitjalu. Palunyakutarra-rni wankarura kanyila, tjiinya-rnin watjarnu wantitjalu. ");
INSERT INTO ntj_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Yuwa Mama, pukurlarriku-munta-tjun tjiinya-rnanta marninypungkulanyangka? Pukurlarrirralpi-rni nyuntuku wangka tirtu nintipungama. ");
INSERT INTO ntj_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Wiya, tirtu-rniya parrawanarayirni pungkula mirri tjunkukitjalu. Nyangka nyuntuku wangkaku-rna watarrkurrikitjamunu. ");
INSERT INTO ntj_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Nyangka yarnangu palyamunu pirninya-ya mukurringkula piwarrtjingalkitjalu-rniya. Parturtu-rna nyuntuku wangka wantikitjamunu. ");
INSERT INTO ntj_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Yuwa, nyuntulu-rnin wangka walykumunu nintirnu. Nyangka-rnanku tirtu kanyilku kanyinma. Tjiinya-rni wangka palunyalu tirtu pukurlmara kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Nyangka-rna wangarnarralu kulira palyarayilku ma-mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Mama Kuurrtu-lanyatju ngurra nyarra Papulantanguru marlakulu katingu Tjurutjamalakutu. Palunyangka-latju kulirnu tjukurrtjuranytja-latju. ");
INSERT INTO ntj_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Yikarringkula-latju pukurlpa mirrarranytja. Nyangka yarnangu kutjupatjarralu-lanyatjuya tjumara watjaranytja, “Mama Kuurrtu-tjanampa yayirninytjulu kutjupa-kutjupa palyarnu.” ");
INSERT INTO ntj_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Yuwa mularrpa Mama Kuurrtu-lampatju yayirninytjulu kutjupa-kutjupa yutirnu. Nyangka-latju pukurlpa mularrpa nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Yuwa Mama, yungarrapirti nyarra Papulanta-ya tirtu nyinarra, palunyanya-tjananya marlakulu kati. Nyangka-latjuyi pirni nyinama. Tjiinyakurlu kapi punkannyangka warnanpa kukurrmanama karrungka, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Yuwa Mama, nyawa-tjananya nyarra-ya yulatawarralu yurninypa pirni makatingu parnangka tjunkulanyangka. Nyangkayi paka-pakannyangka mirrka purlkarriwa. Nyangka-yayi ngula mirrka purlkanya yurraralpi pukurlpa pitjama. ");
INSERT INTO ntj_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Yuwa, yarnangu pirni nyarra yulatawarralu-ya yurninypa pirni makatingu mantangka tjunu. Palunyatjinnga-ya nyinarrayilku ngula mirrka purlkanya yutirrinyangka mirratawarralu yurrara pukurltu katima. Pukurl-pukurlpa-ya ngurrakutu pitjama. ");
INSERT INTO ntj_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Mama Kuurrnga-la marninypungama, tjiinyamarntu walykumunu mularrpa. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Mama Kuurrnga-la marninypungama, tjukurrtatja pirningka munkarra nyinarranyangka. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Mama Kuurrnga-la marninypungama, puurrpa pirningka munkarra nyinarranyangka. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Kutju-palunyalu yayirninytjulu kutjupa-kutjupa palyalpayi. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Mama Kuurrtu ninti purlkanyalu yilkari palyarnu. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Palunyalu manta parratjunu kapi yirralawanalu. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Palunyalu tjirntu puru kirnara palyarnu. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Tjiinya tjirntu palyarnu karlarlara kanyiratjaku. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Puru kirnara pirntirritarrartu palyarnu mungangka yutira kanyiratjaku. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","16","Mama Kuurrtu-tjananya Yitjurayilku tjamupirti yayirninytjulu ngurra nyarra Yiitjipulanguru pakaltjingara katingu. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","20","Mama Kuurrtu puurrpa warrmarlatjarra pirninya pungkula-wanarayirnu wiyarnu. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","22","Palunyalu Yitjurayilku tjamupirti-tjananya katingu tjarrpatjunu ngurra kalkurnu wantitjala. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","24","Nyangka yanyan-yanyanpa nyinapayilu-lanya pika pungkulanyangka Mama Kuurrtu-lanya nyakulalpi paalytjunu kanyirnu. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Yuwa, Mama Kuurrtu yarnangu-lanya puru yanamulpa pirninya parltjara kanyilpayi. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Marninypungama-la Mama Kuurrnga yilkaringka nyinarranytjanya. Palunyalu-lanya ngarltunytjulu tirtu kanyira. ");
INSERT INTO ntj_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Mama Kuurrnga-rna marninypungama. Kurrurntutarrartu-rna Mama Kuurrnga marninypungama. ");
INSERT INTO ntj_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Turlku yinkarra-rna Mama Kuurrnga marninypungama. Marninypungkulayilku-rna ma-mirrirriku. ");
INSERT INTO ntj_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Kulilku-kurlu-yan mula-mularriku wati-ya puurrpa nyinarranyangka. Wanti-ya. Tjiinyanta-ya yarnangulu wankalkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Tjiinya-ya mirrirringkulalpi marlaku mantarriku. Nyangka ngarnmanymara-ya watjaranytjanya yutirrikitjamunu. ");
INSERT INTO ntj_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Mama Kuurrnga tjiinya Tjayikapalu pupakatirra marninypungkulanytja, palunyalu-lanya yirringkankupayi tjiinya-lan mula-mularringkula kuliranyangka. Nyangka palunyalanguru-la walykumunu nyinama. ");
INSERT INTO ntj_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Mama Kuurrtu manta yilkari puru kapi purlkanyatarrartu palyarnu, puru kutjupa-kutjupa mantangkatja yilkaringkatja kapingkatjatarrartu nyinarranytjanya. Palunyalu watjarnu wantitjatjanulu tjukarurrulu palyalpayi. ");
INSERT INTO ntj_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Mama Kuurrtu-tjananya yarnangu mungutja pirni yirringkankupayi kutjupalu-tjananya kurrara kanyiranyangka. Palunyalu nungkumunu pirniku mirrka nintilpayi. Mama Kuurrtu tjayilpangka nyinarranytjanya walatjunkupayi. ");
INSERT INTO ntj_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Palunyalu kurutjarra pirninya kuru yarlalpayi. Nyangka-tjinguru kutjupanya punkannyangka Mama Kuurrtu katura katirrayilpayi. Palunyalu yarnangu nyarra tjukarurru-ya nyinapayinya mukulyanytjulu kanyilpayi. ");
INSERT INTO ntj_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Mama Kuurrtu maliki pirninya miranykanyira kanyilpayi ngurra kutjupanguru-ya pitjangu nyinarranyangka. Puru Mama Kuurrtu-tjananya yirringkara kanyilpayi tjiinya-ya minyma parnaltji puru tjilku wangulyara nyinarranyangka. Palunyalu yarnangu nyarra palyamunu pirninya wiyalpayi. ");
INSERT INTO ntj_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Nyangka Mama Kuurrnga puurrpa purlkanya tirtu nyinaku nyinama. Yarnangu pirni, ngurra ngaa Yitjurayilta-yan nyinarra, kulila-ya. Mama Kuurrnga, tjiinya-yan pupakatirra marninypungkupayinya puurrpa purlkanya tirtu nyinaku nyinama. Nyangka-ya Mama Kuurrnga tirtu marninypungama. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Nyangka puurrpa Tayipirrnga Yitjurayilku tjampupirtiku puurrpa nyinarrayirnu mirrirringu. Nyangka palunyaku katja yini Tjalamannga puurrarringu nyinarranytja. Palunyalu nyinarrayirnu tjukurrpa ngaa kurluny-kurlunypa pirninya watjarayirnu wantingu yarnangu pirnilu-ya kuliratjaku. ");
INSERT INTO ntj_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Yungarralu-munta-lan tjurrkurltu kulilku? Wiya, Mama Kuurrnga-lan mularrkuliranytjalu tjapilku kulilku. Nyangka-lanya nintitjunku tjurrkurltu kuliltjaku. ");
INSERT INTO ntj_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Watatjalu palyaranytjamaaltu Mama Kuurrnga tjapila kulila wanytjapirinypan palyalku. Palunyangkanta yiwarra nintitjunku yankutjakun. ");
INSERT INTO ntj_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Yuwa, wati yangupalalu-tjinguru yiwarla puru tjimarritarrartu ngatjilku mama ngunytjungkatja nyangka-pula nintilku. Nyangka purtu kulilku kurri walykumunu mantjilkitjalu. Ngarna Mama Kuurrtu ngurrkarntanku nintilku kurri walykumunu, tjiinya yatatjura kulira wangkapayinya. ");
INSERT INTO ntj_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","14","Yuwa, tjilku-yanku wantinytjamaaltu yaka-yakara kanyinma. Yuwa, pungkula-yanku nintipungkula kanyinma. Tjiinya-yankun pungkula mirrirntankukitjamunu. Tjinguru tungun-tungunarringkulalpi yanku kutjupa-kutjupa pampulku mirrirriku, palunyakutarrartu. ");
INSERT INTO ntj_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Nyaatjanungka-ya tirtu ngarltutjarra nyinarra mirrparn-mirrparnpa puru pika pungkupayi? Nyaatjanu-ya yawarra pirnitjarra puru kuru tjitirn-tjitirnpa nyinarra? ");
INSERT INTO ntj_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Wiya, wamatjanu-ya palunyapirinypa nyinarra. ");
INSERT INTO ntj_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Yuwa, tjingurun nyakula wama tjitirn-tjitirnpa panikinta tirri-tirrirranyangka. Wiya, nyakunytjamaaltu wanti. Tjingurun waarrpungku tjikilku. ");
INSERT INTO ntj_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Nyangkanta lirrulupirinypa nyiltjitjunku. ");
INSERT INTO ntj_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Nyangkan kutjupa-kutjupa nyaku. Purun pina kutjuparringkulalpi purtu kulinma. ");
INSERT INTO ntj_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Palunyalunkun watjalku, “Wiya-tjinguru-rniya kutjupalu pungkulanytja. Nyangka-rna purtu kulira, ‘Nganalu-munta-rniya pungkulanytja?’ Purtu-rna kulira pakara nyinakitjalu. Wiya, yanku-rna puru tjikilku kata palyarriku.” ");
INSERT INTO ntj_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Nyangka-yanku mama ngunytjulu tjilku nintipungkula kanyinma. Nyangka-yayi walykumunu nyinama, mama ngunytjungka kulira. Tjiinya tjilku tungun-tungunpa nyinama mama ngunytjulu-pula wantirranyangka. Nyangka ngula palunyaku ngunytjulu nyaku kurntarriku tjilku palunyalu kutjupa-kutjupa palyaranyangka. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("IS1_1","024_1_1","ISA","1","1","1","Yuwa, ngayulu-rna Yatjayanya Yayimitjaku katja. Nyangka Mama Kuurrtu-rni nintitjunu tjukurrpa ngaanya yarnangu pirninyatjarra nyarra-ya Tjurutjamala puru ngurra nyarra Tjuutala nyinapayi, palunyatjarra. Tjiinya-rni rawalu nintitjuranytja, puurrpa pirninya-ya nyinarra-wanarayinnyangka. Tjukurrpa kutjupatjarra-rni nintitjunu Tjayanya puurrpa nyinarranyangka, palunyalu tjukurrpa kutjupa Tjawutjamanya puurrpa nyinarranyangka, puru tjukurrpa kutjupa Yayitjanya puurrpa nyinarranyangka, puru Yitjikayinya puurrpa nyinarranyangka. Tjiinya-ya ngurra Tjuutaku puurrpa pirni nyinarra-wanarayinnyangka-rni tjukurrpa nintitjuranytja. ");
INSERT INTO ntj_vpl VALUES ("IS1_2","024_1_2","ISA","1","2","2","Mama Kuurrtu ngaapirinypa watjarnu, “Parna yilkari, kulila-rnipula. Ngayulu-rna tjilku pirninya kanyirayirnu purlkarnu. Nyangka-rniya kulintjamaalpa tungun-tungunarringu. ");
INSERT INTO ntj_vpl VALUES ("IS1_3","024_1_3","ISA","1","3","3","Tjiinya puluka pirni-yanku puurrpa tjarntuku ninti nyinarra. Nyangka-yanku tungkilu nintilu kulilpayi palunyaku mirrka tjunkula wantirranyangka. Nyangka-tjuya ngayuku katja yurntalpirti tjiinya Yitjurayilku tjamupirti ngayuku-ya ngurrpa tirtu nyinarra.” Palunyapirinypa Mama Kuurrtu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("IS1_4","024_1_4","ISA","1","4","4","Yuwa Yitjurayilku tjamupirti, nyuntunya-yan palyamunu nyinapayi. Nyuntulu-yan Mama Kuurrku wangka wantirralpi kutjupa-kutjupa palyara. Nyuntulu-yan palyamunu pirni palyara, nyarra kutjulpirtu-ya mama ngunytjulutarrartu palyamunu palyaranytja, palunyapirinypa. Mama Kuurrnga walykumunu mularrpa nyinapayinya-yan wantingu, tjiinya nyuntuku-tjanampanku tjamu Yitjurayiltu pupakatirra marninypungkupayinya-yan wantirralpi yungarra nyinarra. ");
INSERT INTO ntj_vpl VALUES ("IS1_5","024_1_5","ISA","1","5","5","Nyaaku-yan Mama Kuurrta tirtu tungun-tungunarringkula? Tjiinya-tjinguru-yan mukurringkula Mama Kuurrtu-tjananyanta tirtu pungkulatjaku. Palunyalanguru-yan kata pikatjarrapirinypa nyinarra, purtupakalpa. ");
INSERT INTO ntj_vpl VALUES ("IS1_6","024_1_6","ISA","1","6","6","Tjiinya-yan mara, kata, yamirri, tjarlpa kutjarranya puru tjinatarrartu pikatjarrapirinypa nyinarra. Pika yawarra purlarrtjarra-yan nyinarra. Nyangka-tjananyanta kutjupalu mirritjinta nyirtira wantirranytjamunu. Puru-tjananyanta karrpira wantirranytjamunu. ");
INSERT INTO ntj_vpl VALUES ("IS1_7","024_1_7","ISA","1","7","7","Nyuntuku ngurra lipiwana naaru-naaru ngarala. Yiwarla pirninya malikilu-ya tilirnu tjarrpatjunu. Nyangka yurirlpakutju ngarala. Kurungkartu-tjananyanta maliki pirnilu-ya ngurra yangatjuralpi kurrara kanyira. ");
INSERT INTO ntj_vpl VALUES ("IS1_8","024_1_8","ISA","1","8","8","Nyangka Tjurutjamanya ngurra kutjurringu ngarala. Tjiinyakurlu-ya yanyan-yanyanpa pirnilu yangatjura kanyinma, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS1_9","024_1_9","ISA","1","9","9","Tjinguru-lan mirrirringama, yarnangu Tjurutjamanyamartatji pirninya-lan. Ngarna Mama Kuurrtu-lanya marnkurr-marnkurrpa kanyira wanka nyinarratjaku. Tjinguru-lan pirninyartu mirrirringama, nyarra-ya Tjatamala Kumarala kutjulpirtu mirrirringu Mama Kuurrtu ngurra-tjanampa tilirnu tjarrpatjunkunyangka, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS1_10","024_1_10","ISA","1","10","10","Puurrpa pirni, kulila-ya, ngaa Tjurutjamala-yan nyinarra. Nyuntulu-yan palyamunu nyinarra, nyarra-ya yarnangu pirninya palyamunu nyinarranytja Tjatamala Kumarala, palunyapirinypa. Kulila-ya tjiinya Mama Kuurrtu-tjananyanta watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("IS1_11","024_1_11","ISA","1","11","11","Tjiinya-tjananyanta ngaapirinypa watjara, “Nyuntulu-tjuyan tjiipu pulukatarrartu katirra pungkula tilira tjunkula nintilpayi. Tjinguru-yan kurntarringama palyamunu palyaranytjatjanulu. Palunyalu-tjuyan palya kuka katirra nintinma. Ngaanya-yan palyamunu palyaranytjatjanulu watarrkulu kuka katirra nintira. Wiya, kaarr-kaarrarringu-rna. ");
INSERT INTO ntj_vpl VALUES ("IS1_12","024_1_12","ISA","1","12","12","Tjinguru-yan kulira ngayulu-rna watjarnu kuka-yan watatjalu katirra nintiratjaku ngayuku tjurrtjungka. Wiya, watjantjamunurtu-rna. Tjinguru-yan kulira kurntarringkula kuka katirra nintinma. ");
INSERT INTO ntj_vpl VALUES ("IS1_13","024_1_13","ISA","1","13","14","Ngaanya-yan ngayuku wangka kulira wantirranytjalu kuka katirra ngayuku nintira. Wiya, wanti-ya. Tjiinya-yan kunpu-kunpu katirra nintira. Puru-yan kunpu-kunpu parnti walykumunu pulparrunya ngayuku tilira tjunkula. Palyamunu pirninya-yan palyaranytjatjanu pitjala tjirntu miirl-miirlta lurrtjurringkupayi. Palunyalu-yan turlku purlkanya kanyilpayi kirnara ma-ngarrinyangka kutjupayaratarratu. Wiya, walykurringkula-rna palunyapirinypa-yan palyaranyangka. Wanti-ya. Kaarr-kaarrarringu-rna. Tjiinyakurlu kutjupalu luurrpa purlkanya katirrayila talypurriwa, palunyapirinypa.” ");
INSERT INTO ntj_vpl VALUES ("IS1_15","024_1_15","ISA","1","15","15","Nyangka Mama Kuurrtu tirtu watjaranytja, “Wiya, kulilkitjamunu-rna tjapiranyangka-yan. Tjiinyamarntu-yan yarnangu pirninya pungkula mirrirntaranytja. ");
INSERT INTO ntj_vpl VALUES ("IS1_16","024_1_16","ISA","1","16","16","Palyamunu-ya wanti. Tjiinya-tjananyarnanta nyakula walykurringkula palyamunu-yan palyaranyangka. Wanti-ya. ");
INSERT INTO ntj_vpl VALUES ("IS1_17","024_1_17","ISA","1","17","17","Palunyalu tjukarurrurringkulalpi nyina. Tjiinya kutjupalu kutjupanya kunpu-kunpu payiranyangka marrkula. Nyangka kutjupalu minyma parnaltji puru tjilku wangulyara pungkulanyangka waarrpungkula paalytjura kanyinma.” ");
INSERT INTO ntj_vpl VALUES ("IS1_18","024_1_18","ISA","1","18","18","Nyangka Mama Kuurrtu tirtu watjara-wanarayintja, “Pitja-ya, nyangka-la wangkarra kulinma. Tjiinya-yan palyamunu palyaranytjatjanu kirtirringu nyinarra. Nyangka-tjananyarnanta parltjilku walykumunulku. Nyangka-yan walykumunurriku nyinama. ");
INSERT INTO ntj_vpl VALUES ("IS1_19","024_1_19","ISA","1","19","19","Yuwa, tjinguru-yan ngayuku wangka wangarnarralu kulira palyalku. Palunyangka mirrka walykumunu ngurra ngaangka paka-pakalku ngarama. Nyangka-yan yurrara ngalkuma. ");
INSERT INTO ntj_vpl VALUES ("IS1_20","024_1_20","ISA","1","20","20","Wiya-tjinguru-yan tungun-tunguntu ngayuku wangka kulilku wantiku. Palunyangka warrmarla pirnilu-tjananyanta pitjaku pungku wiyalku. Yuwa, ngayulu-rna Mama Kuurrtu tjukurrpa ngaanya watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Nyangka kutjulpirtu puurrpa Tjayanya mirrirrikitja nyinarranytja. Palunyangka-rna Mama Kuurrnga nyangu tjurrtju purlkanyangka kaninytjarra nyinarranytja. Tjiinya katuwana nyinarranytja palunyaku tjiya purlkanyangka. Nyangka palunyaku warntu purlkanya parna yangatjura ngarrirranytja tjurrtju kaninytjarra. ");
INSERT INTO ntj_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Nyangka-ya yayintjulpa nyarlpi 6-tjarra katu ngaralanytja. Palunyalu-yanku nyarlpi kutjarralu yiiku yangatjuranytja. Palunyalu-yanku nyarlpi kutjarralu yarnangu tjinatarrartu yangatjuranytja. Palunyalu-yanku nyarlpi kutjarra yurrirra paarrpakara parrapitjalayintja. ");
INSERT INTO ntj_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Palunyatjanu-yanku ngaparrku-ngaparrkulu mirrarra watjaranytja, “Walykumunu mularrpa, Mama Kuurrnga Puurrpa Purlkanya walykumunu mularrpa. Nyangka-ya yarnangu manta lipiwana nyinarranytjalu nyakula mirrawarnirra Mama Kuurrtu yayirninytjulu palyannyangka.” ");
INSERT INTO ntj_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Nyangka tjurrtju purlkanya yurri-yurringu yayintjulpa-ya mirrarranyangka. Palunyangka winyinpa purlkarringu tjurrtju kaninytjarra. ");
INSERT INTO ntj_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Palunyangka-rna watjarnu, “Wiya, ngarltutjarra-rnatju mirrirringku. Tjiinya-rna wangka palyamunu watjalpayi. Palunyalu-rna wangka palyamunu watjalpayi pirniwana nyinarra. Palunyalu-rna nyangu Mama Kuurrnga Puurrpa Purlkanya nyinarranytja.” ");
INSERT INTO ntj_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Nyangka yayintjulpa kutjulu mapitjangu nyangu murrnyultu waru tjiinya warungka ngarrirranyangka mantjira ngayulakutu pitjangu. ");
INSERT INTO ntj_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Palunyalu-rni muni pampuralpi watjarnu, “Kulila. Murrnyultu ngaangka-rnanta muni pampurnu. Tjiinya Mama Kuurrnganku kalyparringu. Tjiinyamarntun kurntarringu palyamunu palyaranytjatjanulu. Wiya, raparriwa. Tjiinya Mama Kuurrnganku kalyparringu.” ");
INSERT INTO ntj_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Palunyangka-rna kulirnu Mama Kuurrtu ngaapirinytju watjaranyangka, “Ngananyanyka-rna witulku? Ngananyanyka-lampatju kutipitjaku?” Nyangka-rna watjarnu, “Wiya, ngayunya-rni witula. Ngayulu-rna kutipitjaku.” ");
INSERT INTO ntj_vpl VALUES ("IS6_9","024_6_9","ISA","6","9","9","Palunyangka-rni watjarnu yankula-tjananyarna ngaapirinypa watjaltjaku, “Kulilku-kulilku-yan purtu tjukarurrulku wantiku.” ");
INSERT INTO ntj_vpl VALUES ("IS6_10","024_6_10","ISA","6","10","10","Palunyangka-rni watjarnu, “Yuwa, purtun watjarayilku-watjarayilku, nyangka-ya kulilku-kulilku pinatjarrarriku. Tjinguru-ya kulira ngayulakutu pinkurraaltjaku. Nyangka-tjananyarna wankalku.” ");
INSERT INTO ntj_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Kutjulpirtu-ya yarnangu pirnilu kuliranytja ngurra nyarra Kalalinya palyamunu ngaralanytja. Tjiinya-ya Tjipulanku tjamu kaparlipirti puru Natjaliku tjamu kaparlipirti ngurra palunyangkartu nyinarranytja. Nyangka-ya pirnilu kulilpayi ngurra palyamunu. Palunyangka-ya ngula marlangkatja-marlangkatjalu marninypungkula watjanma, “Ngurra walykumunu.” Ngurra palunyanya lipi purlkanya ngarala kapi kantilywana pururtu kapi yini Tjuutantawana. Ngurra palunyangka-ya malikitarrartu nyinapayi. ");
INSERT INTO ntj_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Nyangka-ya ngaapirinypa watjalku, “Yarnangu-ya mungalurrta nyinarranytjalu nyangu tili purlkanya yirrnyaranyangka. Munga purlkanyangka-ya purtu kuliranytja. Nyangka-tjananya tili purlkalu yartakanu kanyira.” ");
INSERT INTO ntj_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Yuwa Mama Kuurr, nyuntulu-tjananyan miranykanyira kanyiranytja. Nyangka-ya yarnangu pirnirringu. Palunyangurunta-ya pukurltu marninypungkula. Tjiinyakurlu-ya mirrka purlkanya yurraralpi pukurlpa nyinama, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Tjiinya tjilku yirti-lampa ngarriku. Mama Kuurrtu-lampa katja nintilku puurrarringkula-lanyanta kanyiratjaku. Nyangka-ya katja palunyanya yini pirni tjapinma, “Yayirninytjulu watjalpayinya”, “Mama Kuurrnga yayirninytjulu palyalpayinya”, “Mamanya tirtu nyinapayinya”, “Puurrpa rapara kanyilpayinya”. ");
INSERT INTO ntj_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Nyangka puurrpa palunyalu yarnangu pirninyartu puurrarringkula kanyinma. Nyangka-ya kurrurnpa rapa tirtu nyinama. Puurrpa palunyanya Tayipirrta yarangka nyinama, Tayipirrnga nyarra puurrpa kutjulpirtu nyinarranytja, palunyala yarangka. Puurrpa palunyalu tjukarurru nyinarranytjalu yarnangu pirninya walykumunulu kanyinma. Palunyalu puurrpa nyinarrayilku tirtu nyinaku nyinama. Tjiinya Mama Kuurrnga tjiinya Yayirninytjulu Palyalpayilu puurrpa palunyanya nyinatjunkulalpi tirtu nyakula kanyinma. ");
INSERT INTO ntj_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Ngula-ngula wati kutju Tayipirrku wartangkatja puurrpa purlkanya nyinama. Tjiinyakurlu warta kartala wantinyangka katarru ngarama. Palunyangka warta tjalkarra paka-pakala, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","Nyangka Mama Kuurrku Kuurtilu puurrpa palunyanya nintipungkula kanyinma. Nyangka-tjananya palunyaku yarnangu pirninya nintipukalu kanyinma. Palunyalu Mama Kuurrnga kuliranytjalu marninypungama. ");
INSERT INTO ntj_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","4","Puurrpa palunyalu Mama Kuurrku wangka pukurltu kulira palyanma. Nyangka-ya yarnangu pirninya kuurrpangka ngaratjunkunyangka puurrpa palunyalu kulilkitjamunu kutjupalu mayura watjaranyangka. Palunyalu-tjananya yiiku palya nyakula pamparr-pamparrtu palyarnmankukitjamunu. Tjiinya nintilu kulilku kutjupa-kutjupa kumpitjura kanyiranyangka. Nyangka-ya yarnangu ngarltutjarra-tjananya katirra ngaratjunkunyangka puurrpa palunyalu wangkarra yirringkanama. Nyangka-ya palunyaku wangkangka palyamunu pirninya-tjananya pungama. Palunyalu-ya mirriputju pirninya-tjananya pungku mirrirntanku. ");
INSERT INTO ntj_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Nyangka puurrpa palunyalu tjukarurru nyinarranytjalu yarnangu pirninyartu walykumunulu kanyinma. ");
INSERT INTO ntj_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","Nyangka-ya ngupanu puru tjiipu kurluny-kurlunypa-ya lurrtjurringkula nyinama. Nyangka-ya tjarrnga purlkanya puru nanikuurrpa kurluny-kurlunypa pirni lurrtjurringkula nyinama. Nyangka-ya puluka kurlunypa pirni layinpatarrartu lurrtjurringkula nyinama. Nyangka-ya tjilku kurlunytju-tjananya yanamulpa pirninya walara katima mirrkaku kapikututarra. ");
INSERT INTO ntj_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Nyangka-ya puluka pirnilu ngupanu pirnilu lurrtjurringkula yukiri parrangalkuma. Nyangka-tjanampa kurluny-kurlunypa pirni-ya ngurlumaalpa lurrtju ngarrima. Nyangka-ya layintu tjanpi ngalkunma pulukapirinytju. ");
INSERT INTO ntj_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Nyangka-ya tjilku kurlunypa pirni lirruku pirtiwanatarrartu palya ngarlpurringama. Nyangka-tjananya lirrulu patjantjamaaltu wantima. ");
INSERT INTO ntj_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","Nyangka-ya yarnangu pikaputju Tjurutjamalawana nyinakitjamunu. Tjiinya-ya tjamirringkulalpi nyinama. Nyangka-ya yarnangu pirninyartu Mama Kuurrku ninti nyinama. Kutjupanya ngurrpa nyinakitjamunu. ");
INSERT INTO ntj_vpl VALUES ("IS35_1","024_35_1","ISA","35","1","1","Nyangka ngurra nyarra yayilurru ngaralanytja, palunyanya pukurlarriku kapi purlkanya punkannyangka, tjiinyamarntu yitjarnu purlkanya ngarama. ");
INSERT INTO ntj_vpl VALUES ("IS35_2","024_35_2","ISA","35","2","2","Yukiri purlkanya yirnuntjitarrartu ngarama. Nyangka-ya yarnangu pirnilutarrartu-ya pukurltu mirrawarnima. Palunyangka warta wirrmira tjultjulpa ngarama, ngurra nyarra Lapananta tjultjulpa ngarapayi, palunyapirinypa. Nyangka-ya mirrka purlkanya kaatanpangka kanyinma, ngurra nyarra Kaamulta Tjarantatarrartu-ya mirrka purlkanya kanyira, palunyapirinypa. Nyangka-ya pirnilu nintilu kulilku tjiinya Mama Kuurrtu yayirninytjulu ngurra kutjupanu. ");
INSERT INTO ntj_vpl VALUES ("IS35_3","024_35_3","ISA","35","3","4","Nyangka-tjinguru-ya mara patalypa nyinarra puru murtitarrartu tiltirrmankupayi, puru kurrurnpa ngurlunytju-ngurlunytju nyinarra. Nyangka-tjananya watjala, “Wiya, ngurlumaalpa-ya kurrurnpa rapa nyinama. Mama Kuurrtu-tjananyanta pitjaku wankarura kanyinma. Palunyalu-tjananya mirri pungkupayi pirninya ngaparrtjika pungku wiyalku.” ");
INSERT INTO ntj_vpl VALUES ("IS35_5","024_35_5","ISA","35","5","5","Nyangka-ya kurutjarra nyinapayilu kuru yarlarringkulalpi nyangama. Puru-ya pinatjarra nyinapayilu pina yarlarringkulalpi kulinma. ");
INSERT INTO ntj_vpl VALUES ("IS35_6","024_35_6","ISA","35","6","6","Nyangka-ya wawanypa nyinapayi pirninya pakaralpi wuurlmara parrawirrtjanma. Nyangka-ya purtu wangkapayi pirninya wangkatjarrarringkulalpi pukurlpa mirrama. Nyangka kapi warla pilawana kukurrmanama. ");
INSERT INTO ntj_vpl VALUES ("IS35_7","024_35_7","ISA","35","7","7","Nyangka parna nyarra tjina kampapayinya kutjuparrinyangka yirrala purlkanya ngarrima. Nyangka parna nyarra kapimaalpa ngarapayinya kutjuparringkulalpi kapi pirnitjarra ngarama. Nyangka yirriya paka-pakaralpi parltju-parltjungka ngarama ngurra nyarra ngupanu-ya kurranyulpi nyinapayingka. ");
INSERT INTO ntj_vpl VALUES ("IS35_8","024_35_8","ISA","35","8","8","Nyangka yiwarra walykumunu palunyangka ngarama. Nyangka-ya tjapilku, “Mama Kuurrku yiwarra walykumununya.” Nyangka-ya palyamunu palyalpayinya yiwarra palunyangka kamu mapitjaku. Tjiinya-ya tungun-tungunpa pirninya yiwarra palunyawana mapitjakitjamunu. ");
INSERT INTO ntj_vpl VALUES ("IS35_9","024_35_9","ISA","35","9","9","Nyangka-ya layinpa ngupanu pirninyatarrartu yiwarra palunyangka kamu mapitjaku. Ngarna-ya yarnangu nyarra Mama Kuurrtu wankarnu palunyanyakutju-ya yiwarra palunyangka mapitjaku. ");
INSERT INTO ntj_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Mapitjalayilku-ya turlku pukurltu yinkarrayilku parratjarrpaku Tjurutjamala. Palunyalu-ya pukurlpa tirtu nyinama. Tjiinya-ya tjuni kartakatikitjamunu pukurlpa nyinaku nyinama. ");
INSERT INTO ntj_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Mama Kuurrnga tjiinya pupakatirra-lan marninypungkupayilu watjarnu, “Ngayuku-tju katja yurntalpirti-tjananya watjala pukurlmarra. ");
INSERT INTO ntj_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Walykumunulu-tjananya watjala yarnangu nyarra Tjurutjamala nyinapayi. Ngaapirinypa-tjananya watjala, ‘Nyuntulu-yan palyamunu palyaranytja. Nyangka-tjananyarnanta ngaparrtjika pika purlkanya yutirayirnu wiyarringu. Palunyalu kuwarrinya-tjanamparnanku kalyparringkulalpi nyinarra.’” ");
INSERT INTO ntj_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Tjiinya kutjupalu mirrarra watjara, “Mayu-mayuwana-ya yiwarra tamarlmarra wanti Puurrku. Yiwarra tjukarurru-ya palyala wanti Mama Kuurrku. ");
INSERT INTO ntj_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Parna yapu wararrangkatja-ya tjutira-wanala lawuwanalu wanti. Nyangkayi tjukarurru ngarama. Parna-ya tjutira-wanala kakal-kakalwanalu wanti. Nyangkayi tjukarurru ngarama. ");
INSERT INTO ntj_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Nyangka Mama Kuurrku tili purlkanya yartakarriku. Nyangka-ya yarnangu pirnilu nyaku. Tjiinya Mama Kuurrtu watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("IS40_6","024_40_6","ISA","40","6","6","Yuwa, kutjupalu-rni watjarnu tjukurrpa-rna watjaltjaku. Nyangka-rna tjapirnu, “Nyaapirinypa-rna watjalku?” Nyangka-rni watjarnu ngaapirinypa watjaltjaku, “Yarnangu pirninya-lan yukiripirinypa. Tjiinyakurlu yukiri ngara rawamaalpartu pikirriwa, palunyapirinypa. Nyangka-lan puru yirnuntjipirinypartu nyinarra. Tjiinyakurlu walykumunu ngaralalpi punkala wiyarriwa, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS40_7","024_40_7","ISA","40","7","7","Tjiinya Mama Kuurrtu watjannyangka yukiri pikirriku puru yirnuntji punkalku wiyarriku. Nyangka-lan palunyapirinypa nyinarra wiyarringama. ");
INSERT INTO ntj_vpl VALUES ("IS40_8","024_40_8","ISA","40","8","8","Yuwa, yukiri ngaraku pikirriku. Nyangka yirnuntji punkalku wiyarriku. Nyangka Mama Kuurrku wangka tirtu ngaraku ngarama.” ");
INSERT INTO ntj_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Yarnangu Tjurutjamanyamartatji pirni, tjukurrpa walykumunu-ya mirrarra watjanma. Purlingka-ya tatiralpi mirrarra watjanma. Ngurlumaaltu-ya rapalu mirrarra watjanma, “Mama Kuurrnga pitjalayirni.” Nyangka-yayi yarnangu ngurra pirningkatjalu kulila, ngurra nyarra Tjuutalawana nyinarranytjalu. ");
INSERT INTO ntj_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Nyawa-ya. Mama Kuurrnga Puurrpa Purlkanya pitjalayirni. Palunyalu-lanyanta puurrarringkulalpi kanyinma. Palunyalu-lampa kutjupa-kutjupa walykumunu nintilku katja yurntalpirtiku. ");
INSERT INTO ntj_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Yuwa, Mama Kuurrtu-lanyanta katja yurntalpirti tjiipupirinypa miranykanyira katirrayinma. Tjiinyakurlu tjiipu warlangu kurlunypa yampura katirrayinma. Palunyalu-tjananya tjiipu ngunytju kurlunytjarra purinytju walara parrakatirrayinma. Palunyapirinypa-lanya walara parrakatirrayinma. ");
INSERT INTO ntj_vpl VALUES ("IS40_27","024_40_27","ISA","40","27","27","Yitjurayilku tjamupirti-yan tirtu watjalpayi, “Wiya, yarnangu kutjupalu-lanyantaya kurraranyangka Mama Kuurrtu-lanyanta kulira wantipayi.” ");
INSERT INTO ntj_vpl VALUES ("IS40_28","024_40_28","ISA","40","28","28","Ngurrpa-munta-yan? Kulintjamaalpa-munta-yan? Tjiinya Mama Kuurrnga kutjulpirtu nyinarranytja. Palunyalu tirtu nyinaku nyinama. Kutju-palunyalu parna yilkari palyarnu. Palunyalu talypurringkulanytjamunu puru nyuurrukatirranytjamunu. Yuwa, yarnangu pirnilu-lan purtu kulilpayi tjiinya Mama Kuurrtu nintipukalu kuliranyangka. ");
INSERT INTO ntj_vpl VALUES ("IS40_29","024_40_29","ISA","40","29","29","Nyangka-tjinguru-rna patalyarringkulalpi talypurriku. Nyangka-rni Mama Kuurrtu walykumunulku. ");
INSERT INTO ntj_vpl VALUES ("IS40_30","024_40_30","ISA","40","30","30","Tjiinya-ya yangupalatarrartu patalyarringkulalpi punkalkutarrartu. ");
INSERT INTO ntj_vpl VALUES ("IS40_31","024_40_31","ISA","40","31","31","Nyangka-ya Mama Kuurrnga mularrkuliranytjalu patalyarrinytjatjanu walykumunurriku. Palunyalu-ya patalymaalpa tirtu parrapitjalayinma. Tjiinyakurlu-ya warlawurru patalymaalpa yilkaringka tirtu parrapitjalayinma. Palunyapirinypa-ya Mama Kuurrnga mularrkuliranytjalu talypumaalpa kukurrpa parrapitjalayinma. Puru-ya patalymaalpa tirtu parrawirrtjarayinma. ");
INSERT INTO ntj_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Mama Kuurrtu watjarnu, “Ngaanya-tju ngayuku waarka palyalpayinya. Ngayulu-rnalu ngurrkarntanu wantingu. Palunyalu-rna tirtu miranykanyira. Palunyalu-rna tirtu pukurltu nyakula. Kuurti Walykumununya-rnalu tjarrpatjunu wantingu. Nyangka-tjananya yarnangu pirninya ngurra kutjupa-kutjupangkatja walykumunulu kanyinma. Nyangka-ya tjukarurru nyinama. ");
INSERT INTO ntj_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","Tjiinya wati palunyanya lingkirrpa mirrakitjamunu. Palunyalu karnany-karnanytju watjalkitjamunu pirnilu-ya kuliltjaku. ");
INSERT INTO ntj_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Tjiinya nyaku-tjananya tjiinya-ya wanara punkaranyangka puntura watjalkitjamunu. Palunyalu-tjananya nyaku kurltjirr-kurltjirrpa-ya nyinarranyangka payilkitjamunu wantiku. Palunyalu-tjananya yarnangu pirninya walykumunulu kanyinma. Nyangka-ya tjukarurru nyinama. ");
INSERT INTO ntj_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","Tjiinya talypurringkula wantinytjamaaltu ngayuku waarka palyarayilku, nyangka-ya manta lipingkatjanya tjukarurru nyinama. Palunyatjanu-ya palunyaku wangkaku mukurringama.” Palunyapirinypa Mama Kuurrtu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("IS43_1","024_43_1","ISA","43","1","1","Mama Kuurrtu-tjananya Yitjurayilku tjamupirti watjarnu, “Kulila-rniya. Ngayulu-tjananyarnanta lurrtjurnu ngayuku katja yurntalpirti-yan nyinarratjaku. Nyangka-ya ngurlumaalpa nyinama. Ngayulu-tjananyarnanta wankarura kanyinma. Tjiinya ngayulu-tjananyarnanta ngurrkarntaralpi yini tjapirnu. Nyangka-tjuyan ngayuku nyinarra. ");
INSERT INTO ntj_vpl VALUES ("IS43_2","024_43_2","ISA","43","2","2","Tjinguru-yan tjarrparra mapitjaku kapi warnanpa purlkanya kukurrmaranyangka. Nyangka-tjananyarnanta ngayulu yirringkara kanyinma. Nyangka-yan kapingka tjarrparra mirrirrikitjamunu. Puru-yan warungka tjarrparra mapitjanyangka kampakitjamunu-tjananyanta.” ");
INSERT INTO ntj_vpl VALUES ("IS43_16","024_43_16","ISA","43","16","16","Kutjulpirtu Mama Kuurrtu yiwarra palyarnu wantingu kapi purlkanyawana-ya mapitjatjaku. ");
INSERT INTO ntj_vpl VALUES ("IS43_17","024_43_17","ISA","43","17","17","Palunyalu-tjananya warrmarla pirni wuyurrmanu kapiwanalu-ya wanaltjaku. Nyangka-ya purni kaarrtjarra tjarrpangu punkarnu mirrirringu. Pirninyartu-ya tjarrparralpi palunya wiyarringu. ");
INSERT INTO ntj_vpl VALUES ("IS43_18","024_43_18","ISA","43","18","18","Nyangka Mama Kuurrtu watjarnu, “Tirtu-kurlu-yan kulinma nyarra kutjulpirtu ngarangu. Wanti-ya. ");
INSERT INTO ntj_vpl VALUES ("IS43_19","024_43_19","ISA","43","19","19","Nyangama-ya. Ngayulu-tjananyarnanta kuwarri-kuwarri kutjupa-kutjupa nintitjunku. Yuwa, wiyangkalpi ngarala. Nyakula-munta-yan? Ngayulu-tjanamparnanku yiwarra mayu-mayuwanalu palyara. Puru-tjanamparnanku kapi pirni yartakanku. ");
INSERT INTO ntj_vpl VALUES ("IS43_20","024_43_20","ISA","43","20","20","Nyangka-rniya ngupanulu, karlayalutarrartu marninypungama. Tjiinyamarntu kapi warla purlkanya pilawana kukurrmanama ngayuku katja yurntalpirtilu-ya tjikiltjaku. ");
INSERT INTO ntj_vpl VALUES ("IS43_21","024_43_21","ISA","43","21","21","Ngayulu-tjananyarna lurrtjurnu ngayuku katja yurntalpirti-ya nyinarratjaku. Tjiinya-rniyayi yinkarra marninypungama.” ");
INSERT INTO ntj_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Nyangka Mama Kuurrtu watjarnu, “Ngayuku-tju waarka palyalpayilu palyalku wiyalku nyarra ngayulu-rna watjarnu wantinyangka. Nyangka-luya yarnangu kutjupa-kutjupalu marninypungama. ");
INSERT INTO ntj_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Yuwa, yarnangu pirnilu-ya nyakulalpi kata paarnarrarnu. Tjiinyamarntu-ya pungkulayirnu wantinyangka yawarra pirnitjarra ngaralanytja. Tjiinya kutjupa-kutjuparringkulalpi ngaralanytja. Nyangka-ya purtu ngurrkarntaranytja. ");
INSERT INTO ntj_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Nyangka kuwarrinya-ya yarnangu ngurra kutjupa-kutjupangkatjalu wati palunyanya nyakulalpi kata paarnarralku. Nyangka-ya puurrpa pirnilutarrartu kanmarrtu ngarala nyangama. Tjiinya-ya kutjupa-kutjupa nyakula wantirranytjamunulu nyaku. Puru-ya kutjupa-kutjupa kulira wantirranytjamunulu tjurrkurlmara kulilku.” ");
INSERT INTO ntj_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Nyangka-ya yarnangu pirnilu watjarnu, “Tjinguru-yan purtu mula-mularriku ngaapirinypa-latju watjaranyangka. Tjinguru-yan purtu kulira tjiinya Mama Kuurrtu kutjulpirtu kulirnu ngarnmanymanu ngaapirinypa ngaratjaku. ");
INSERT INTO ntj_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Mama Kuurrtu waarka palyalpayi palunyanya ngalyawiturnu. Parturtu-ya pirnilu nyangu purlkamunu nyinarranyangka. Tjiinyakurlu warta kurlunypa pakala manta witu-witungka. Nyangkakurlu-ya nyawa pawun-pawunpa pikirrikitja ngaralanyangka. Palunyapirinypa-ya waarka palyalpayi palunyanya nyangu pawun-pawunpa mirrirrikitjapirinypa. Wati palunyanya puurrpirinypa nyinarranytjamunu Puru yiiku walykumunu nyinarranytjamunu. Nyangka-lan nyakula wantirranytja mungutjakukantjalu. ");
INSERT INTO ntj_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Yarnangu pirnilu-ya yanyan-yanyantu wantingu. Nyangka wati palunyalu pika purlkanya mantjirnu. Nyangka-ya nyakukitjamunulu wantingu. Nyangka-lan kulirnu wantingu purlkamunulkanyu nyinarranytja. Ngurra-watjala purlkanya nyinarranytja. ");
INSERT INTO ntj_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Tjiinya wati palunyalu pika purlkanya mantjirnu ngayulanguru-lanya. Nyangka-lan kulirnu Mama Kuurrtu-ra pika yutirnu palyamunu palyannyangka, palunyakukantja. ");
INSERT INTO ntj_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Wiya, wati palunyalu pika purlkanya mantjirnu tjiinyamarntu ngayulu-lan kutjupa-kutjupa palyamunu palyarnu palunyangka. Wati palunyanya-ya pika purlkanya pungkulanytja. Palunyangka-lan pikatjarra nyinanytjatjanu walykumunurringu nyinarra. ");
INSERT INTO ntj_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Ngayulu-lan tjiipupirinypa kawarnarrara kutipitjangu. Pinkurraara-lan yungarra kutipitjangu yiwarra kutjupangka. Tjinguru-lan ngayulu mirrirringama kutjupa-kutjupa palyamunu palyaranytjatjanulu. Ngarna Mama Kuurrtu watjarnu wati palunyanya mirrirritjaku, tjiinyamarntu-lan kutjupa-kutjupa palyamunu palyaranytja palunyangka. ");
INSERT INTO ntj_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Tjiinya-ya wati palunyanya lingkirrtu pungkulanytja. Nyangka kanmarrpa ngaralanytja. Tjiinyakurlu-ya tjiipu warlangu kati ngaratjurra mirri pungkukitjalu. Nyangka kanmarrpa ngarama, palunyapirinypa. Nyangkakurlu tjiipu kanmarrpa ngarama purrmu katapungkukitjangka, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Tjiinya-ya kunpu-kunpu kuurrpangka mirritjunkulalpi mantjira makatingu mirri pungkukitjalu. Tjiinya-ra kutjupa ngarltuwangkanytjamunu wiyartu. Nyangka-ya pungu mirrirntanu tjiinyamarntu ngayuku yungarrapirtilu-ya kutjupa-kutjupa palyamunu palyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Nyangka-ya mirri katingu tjarrpatjunu wati nyarra tjimarri purlkanyatjarraku pulpangka. Tjiinya wati palunyalu kutjupa-kutjupa palyamunu palyaranytjamunurtu. Puru kutjuwarra mayuranytjamunu. Nyangka mirrirrinyangka-ya palyamunu palyalpayi pirniku tjuulwanalu tjarrpatjunu.” Palunyapirinypa-ya watjarnu. ");
INSERT INTO ntj_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Nyangka Mama Kuurrtu watjarnu, “Ngayulu-rna kutjulpirtu watjarnu wati palunyanya pika mantjira mirrirritjaku, tjiinya yarnangu palyamunu pirniku-tjanampa yangarrakatirra mirrirritjaku. Nyangka wati palunyalu nyaku palunyaku tjamu kaparlipirti. Palunyalu rawa nyinarra-wanarayinma. Wati palunyalu pirninyartu palyalku wiyalku nyarra ngayulu-rnalu watjarnu wantitjanya. ");
INSERT INTO ntj_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Tjiinya wati walykumununya kunkanypa nyinarranytjatjanu mirrirringu yarnangu palyamunu pirniku. Palunyangka ngayulu-tjanamparna kalyparriku. Palunyangka wati palunyalu nyakulalpi pukurlarriku. Palunyalu kulilku, ‘Yuwa, palya-rna pika purlkanya mantjirnu mirrirringu. Nyangka Mamanya-tjanampa kalyparringu.’” ");
INSERT INTO ntj_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Puru Mama Kuurrtu watjarnu, “Ngayulu-rnara kutjupa-kutjupa walykumunu nintilku. Palunyalu-rnalu nyinatjunku puurrpa purlkanya nyinarratjaku. Tjiinya yarnangu pirnilu-ya kuliranytja wati palunyanya palyamunu nyinarranytja, palunyakukantjalu. Wiya, yarnangu palyamunu pirniku-tjanampa yangarrakatingu mirrirringu. Palunyalu-tjanampa tjapiranytja ngayulu-rna kalyparritjaku.” ");
INSERT INTO ntj_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","Nyangka Mama Kuurrtu-tjananya palunyaku katja yurntalpirti nyarra Papulanta nyinarranytjanya ngaapirinypa watjarnu, “Kapitjirratja-munta-yan nyinarra? Wiya, pitja-ya tjikila kapi purlkanya ngaanya ngarrirranyangka. Tjinguru-yan tjimarri wiya nyinarra. Wiya, pitja-ya mirrka pirninya mantjiralpi ngala. Pitja-ya wayinpa, miilki mantjiralpi tjikila, tjimarri nintintjamaaltu. ");
INSERT INTO ntj_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","Nyaaku-yan tjimarri tirtu wiyara mirrka palyamunungka? Waarka purlkanya-yan palyara. Palunyalu parltjamaalpa tirtu nyinarra. Pina yarlarringkulalpi-rniya kulila. Palunyalu-yan mirrka walykumunu pukurltu ngalkuma. ");
INSERT INTO ntj_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Pina yarlarringkulalpi-rniya kulila. Ngayulakutu-rniya pitja wanka nyinakitjalu. Palunyalu-tjananyarnanta kalkulku wantiku walykumunura tirtu kanyilkitjalu. Tjiinya-rna puurrpa Tayipirrnga kutjulpirtu kalkurnu wantingu walykumunura kanyilkitjalu, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("IS55_4","024_55_4","ISA","55","4","4","Tjiinya-rnalu Tayipirrnga puurrpa nyinatjunu wantingu yarnangu kutjupa-kutjupa pirniku. Nyangka-ya puurrpa palunyanya nyakulalpi ngayukutarrartu-ya nintirringu. ");
INSERT INTO ntj_vpl VALUES ("IS55_5","024_55_5","ISA","55","5","5","Yuwa, tjiinya-yan yarnangu kutjupa-kutjupa maliki pirninya yarltiku. Nyangka-ya kukurrpa pitja-pitjama lurrtjurringkukitja. Ngayulu-rna Mama Kuurrnga tjukarurru nyinapayinya tjiinya Yitjurayilku tjamupirti-yan pupakatirra marninypungkupayinya. Palunyalu-tjananyarna wuyurrmanku nyuntulakutu-ya pitjatjaku. Palunyalu-tjananyarnanta nyinatjunku puurrpirinypa-yan nyinarratjaku.” Palunyapirinypa Mama Kuurrtu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","Pinkurraala-ya Mama Kuurrtakutu pitja tjiinya-tjananyanta watjaranyangka. Tjiinya ngamurringu ngaralanyangka-ya tjapila. ");
INSERT INTO ntj_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Kutjupa-kutjupa palyamunu-ya palyaranytjatjanu wanti. Puru-ya kutjupa-kutjupa palyamunu kuliranytjalu wanti. Palunyatjanu-ya marlaku pitja Mama Kuurrtakutu. Nyangka-tjanampankuyi ngarltunytju purlkanya waarrpungkulalpi kalyparriwa. ");
INSERT INTO ntj_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Nyangka Mama Kuurrtu ngaapirinypa watjaranytja, “Nyuntulu-yankun yungarralu kulilpayi. Nyangka-rna ngayulu kutjupartu kulilpayi. Nyuntulu-yankun yara yungarra wanalpayi. Nyangka ngayuku-tju yara kutjupartu ngarala. ");
INSERT INTO ntj_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Tjiinya yilkari katu mularrpa ngarala. Nyangka-yan parnangurulu purtu nyakula. Palunyapirinytju-yan ngayuku yara purtu kulira. Tjiinyamarntu nyuntuku yarangka munkarra ngarala. ");
INSERT INTO ntj_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Ngayuku-tju wangka kapipirinypa. Tjiinyakurlu kapi yilkaringuru tjutima, palunyapirinypa. Tjiinya yarlaku punkalkitjamunu. Kapi punkalku wantinyangka mirrka pakalpayi. Nyangka-ya yurninypa purlkanya yurralpayi ngalkukitjalu puru mantangka tjunkukitjalu. Tjiinya yarlaku punkalkitjamunu. ");
INSERT INTO ntj_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","Nyangka-tju ngayuku wangka kapipirinypa ngarala. Tjiinya-rna yarlaku watjalkitjamunu. Tjiinya ngayulu-rna watjaranyangka kutjupa-kutjupa yartakarripayi. ");
INSERT INTO ntj_vpl VALUES ("IS55_12","024_55_12","ISA","55","12","12","Yuwa, nyuntulu-yan ngurra nyarra Papulannga wantirra pukurlpa kutipitjaku ngurra yungarrakutu. Nyangka-tjananyantaya kalypalu ma-wanarayilku wantiku kutipitjanyangka-yan. Nyangka purli purlkalu puru purli kurluny-kurlunypa pirnilu-tjananyanta nyakula pukurltu turlku yinkama. Nyangka-ya warta pirnilu-tjananyanta nyakula-wanarayilku pukurltu-yanku mara pungama. ");
INSERT INTO ntj_vpl VALUES ("IS55_13","024_55_13","ISA","55","13","13","Nyangka-ya warta walykumunu pirni paka-pakaralpi tjultjulpa ngarama tjiinya tjilka-tjilka purlkanya ngarapayingka. Nyangka-ya yarnangu pirnilu nyaku warta palunyanya tirtu ngaralanyangka kulilku tjiinya-rna Mama Kuurrtu yayirninytjulu palyarnu.” Palunyapirinypa Mama Kuurrtu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("IS60_1","024_60_1","ISA","60","1","1","Tjurutjamala nyinapayi pirni, kulila-ya. Kurltjirr-kurltjirrpa-ya nyinarranytjamaalpa pakala nyawa Mama Kuurrku tililu-tjananyanta yutira kanyiranyangka. Nyangka-tjananyantayayi pirnilu nyawa tjirntulupirinypa yirrnyaranyangka. ");
INSERT INTO ntj_vpl VALUES ("IS60_2","024_60_2","ISA","60","2","2","Yuwa, Mama Kuurrku tililu-tjananyanta yutira kanyinma. Nyangka-ya yarnangu kutjupa-kutjupa mungalurrta nyinarra. ");
INSERT INTO ntj_vpl VALUES ("IS60_3","024_60_3","ISA","60","3","3","Palunyalu-ya tili nyakula nyuntulakutu-tjananyanta wirrtjalku. Puurrpa pirnilutarra-ya nyakula wirrtjalku nyuntulawana-tjananyanta pirlpirlarrarnu-wanarayinnyangka. ");
INSERT INTO ntj_vpl VALUES ("IS60_4","024_60_4","ISA","60","4","4","Parranyawa-ya. Yarnangu pirninya-ya lurrtjurringu-lurrtjurringu ngurrakutu pitjalayirni. Nyuntuku-tjanampanku katjapirti tiwanguru pitjalayirni. Yuwa, yurntalpatarrartu-ya lurrtju pitjalayirni. ");
INSERT INTO ntj_vpl VALUES ("IS60_5","024_60_5","ISA","60","5","5","Nyangka-yan nyakulalpi kurrurnpa pukurlarriku. Tjiinyamarntu-ya yarnangu nyarra lurrtju pitjalayintjalu yulytja pirni katiku. Kapingka munkarranguru-ya katiku-tjanampanku nintilku. ");
INSERT INTO ntj_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Nyangka Mama Kuurrku waarka palyalpayilu watjarnu, “Tjiinya Mama Kuurrtu-rni ngurrkarntaralpi palunyaku Kuurti Walykumununya tjarrpatjunu. Palunyalu-rni witurnu, ‘Mapitja tjukurrpa walykumunu watjanma ngarltutjarra pirningka. Palunyalu pukurlmara kanyinma nyarra-ya tjuni kartalypa nyinarranytjanya. Puru-tjananya ngurra kutjupangka watjil-watjilpa nyinarranytjanya watjala tjiinya puurrtu-tjananya ngurraku witultjaku. Palunyalu-tjananya tjayilpangka nyinarranytjanya watjala tjiinya-rna Mama Kuurrtu-tjananya pakaltjingalku.’ ");
INSERT INTO ntj_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Tjiinya-rni witurnu ngaapirinypa-rna watjaltjaku, ‘Kuwarrinya ngamurringu Mama Kuurrtu-lanya ngarltunytjulu wankarura kanyiratjaku, puru yanyan-yanyanpa nyinapayinya-tjananya ngaparrtjika pungkutjaku.’ Yuwa, Mama Kuurrtu-rni witurnu pukurlmara-tjananya kanyiratjaku nyarra tjirturu-tjirturu-ya nyinarranytjanya. ");
INSERT INTO ntj_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Nyangka-tjananyarna walykumunura kanyinma nyarra Tjurutjamala tjuni kartalypa-ya nyinarranytjanya. Nyangka-yayi pukurlpa nyinama. Yulatjanu-yulatjanulu-yayi turlku yinkarra Mama Kuurrnga marninypungama. Tjiinya-yayi warta witu-witupirinypa nyinama, tjiinya Mama Kuurrtu murrutjunu wantitjanya. Nyangka-yayi tjukarurrulu palyanma. Nyangka-ya yarnangu pirnilu nyakulalpi Mama Kuurrnga marninypungama. ");
INSERT INTO ntj_vpl VALUES ("IS61_4","024_61_4","ISA","61","4","4","Palunyangka-ya yiwarla purlkanya pirninya marlakulu palyalku, nyarra kutjulpirtu-ya yurntura punkatjingarayirnu wantitjanya.” Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("JR1_1","025_1_1","JER","1","1","3","Yuwa, tjukurrpa ngaanya wati yini Tjiramayilu watjarnu wantitjanya. Tjiinya Mama Kuurrtu-lu tjukurrpa watjarnu puurrpa Tjutjayinya nyinarranyangka. Palunyalu tjukurrpa tirtu watjaranytja Tjutjayiku katja puurrpa nyinarranyangka puru Tjatikayinya puurrpa nyinarranyangka. Nyangkalta-ya warrmarla pirni Papulantanguru pitjangu-tjananya yarnangu Tjurutjamala nyinapayi pirninya karrpira katingu ngurra palunyakutu.");
INSERT INTO ntj_vpl VALUES ("JR1_4","025_1_4","JER","1","4","4","Nyangka Mama Kuurrtu-rni watjarnu, ");
INSERT INTO ntj_vpl VALUES ("JR1_5","025_1_5","JER","1","5","5","“Yuwa Tjiramayi, kutjulpirtu-rnanta nintilu nyakulanytja parrkangkan ngaralanyangka. Ngurrkarntanu-rnanta yarnangu kutjupa-kutjupangkan tjukurrpa watjaratjaku. Yuwa, kutjulpirtu-rnanta ngurrkarntanu. Palunyalu-rnanta marla palyarnu nyuntuku ngunytjuku tjuningka.” ");
INSERT INTO ntj_vpl VALUES ("JR1_6","025_1_6","JER","1","6","6","Nyangka-rna watjarnu, “Wiya puurr, ngayulu-rna ngurrpa. Nyaapirinypa-rna watjalku? Ngayulu-rna wati kurlunypa.” ");
INSERT INTO ntj_vpl VALUES ("JR1_7","025_1_7","JER","1","7","7","Nyangka-rni Mama Kuurrtu watjarnu, “Palunyapirinypa watjantjamaaltu wanti. Palyan wati kurlunypa nyinarra. Nyangka ngayulu-rnanta kanyilku. Nyangkan yanku ngayuku tjukurrpa watjalku yarnangu pirningka. Tjiinyamarntu ngayulu-rnanta witura. Ngayulu-rnanta watjannyangkan wangka palunyanyartu mawatjanma. ");
INSERT INTO ntj_vpl VALUES ("JR1_8","025_1_8","JER","1","8","8","Ngurlurringkutjamaaltu-tjananya kurrurnpa rapalu watjanma, tjiinyamarntu-rnanta ngayulu maralu kanyiranyangka. Tjiinya-rnanta ngayulu Mama Kuurrtu watjarnu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("JR1_9","025_1_9","JER","1","9","9","Palunyalu mara wirrmirarringkulalpi-rni muni pampurnu watjarnu, “Kulila. Ngayulu-rnanta wangka tjarrpatjunu tjaangka. Nyangkan wangka palunyanyartu mawatjanma. ");
INSERT INTO ntj_vpl VALUES ("JR1_10","025_1_10","JER","1","10","10","Yuwa, ngayulu-rnanta tjunu ngayuku wangka mawatjaratjaku. Nyangka wangka kutjupatjarralu nintitjunku tjiinya yarnangu kutjupa-kutjupa pirninya wiyarritjaku. Nyangka wangka kutjupatjarralu nintitjunku yarnangu kutjupatjarra marlaku purlkarritjaku.” ");
INSERT INTO ntj_vpl VALUES ("JR29_1","025_29_1","JER","29","1","1","Nyangka Tjiramayilu Tjurutjamala nyinarranytjalu lata walkatjunu wiyarnu palunyaku yungarrapirtiku tjiinya-ya ngurra nyarra Papulanta nyinarranyangka. Tjiinya-tjananya warrmarla pirnilu karrpira katingu ngurra palunyangka nyinatjunu. ");
INSERT INTO ntj_vpl VALUES ("JR29_4","025_29_4","JER","29","4","4","Nyangka Tjiramayilu lata ngaapirinypa walkatjuralpi wiyarnu. Yuwa, Mama Kuurrtu yayirninytjulu palyalpayilu tjiinya-lan Yitjurayilku tjamupirtilu pupakatirra marninypungkupayilu ngaapirinypa watjarnu, “Yuwa, ngayulu-rna puurrpa Napitjanya witurnu. Nyangka warrmarla pirnitjarra yanu-tjananyanta karrpira katingu ngurra pala Papulantakutu. ");
INSERT INTO ntj_vpl VALUES ("JR29_5","025_29_5","JER","29","5","5","Kulila-ya. Ngurra palangka-yanku yiwarla palyaralpi nyinama. Puru-yanku kaatanpa palyara mirrkatarrartu pakaltjingara ngalkuma. ");
INSERT INTO ntj_vpl VALUES ("JR29_6","025_29_6","JER","29","6","6","Puru-yanku kurri yarltirralpi tjilkutjarrarriwa. Puru-yanku katja yurntalpa watjanma kurri yarltirra tjilku pirnitjarrarritjaku. Palunyanguru-yan pirnirringkula-wanarayinma. ");
INSERT INTO ntj_vpl VALUES ("JR29_7","025_29_7","JER","29","7","7","Yuwa, waarkatarrartu-ya palyanma ngurra pala Papulannga walykumunu ngaralatjaku. Puru-rniya ngayula tjapinma ngurra palunyanya-rna walykumunura kanyiratjaku. Tjiinya ngurra palunyanya walykumunu ngaralanyangka nyuntunyatarrartu-yan walykumunu nyinama. ");
INSERT INTO ntj_vpl VALUES ("JR29_10","025_29_10","JER","29","10","10","Yuwa, nyuntunya-yan ngurra pala Papulanta rawa nyinaku. Nyangka-tjanamparnanku kurli 70-nguru ngarlturringkulalpi marlakulu katiku ngurra ngaaku. Tjiinya-rna kalkurnu wantingu, palunyapirinypa. ");
INSERT INTO ntj_vpl VALUES ("JR29_11","025_29_11","JER","29","11","11","Yuwa, ngayulu-tjananyarnanta kulira walykumunura kanyilkitjalu. Tjiinya-tjanamparnanku palyamunu yutilkitjamunu. Wiya, walykumunu-tjanamparnanku yutira-wananma. Nyangka-yan pukurltu kulinma walykumunu tirtu nyinakitjalu. ");
INSERT INTO ntj_vpl VALUES ("JR29_12","025_29_12","JER","29","12","12","Palunyalu-rniyan warlkuralpi tjapilku yirringkara kanyiratjaku. Nyangka-tjananyarnanta kuliralpi walykumunura kanyinma. ");
INSERT INTO ntj_vpl VALUES ("JR29_13","025_29_13","JER","29","13","13","Yuwa, kuliralpi-tjananyarnanta ngamulu kanyinma, tjiinyamarntu-rniyan kurrurntutarrartu tjapiranyangka.” ");
INSERT INTO ntj_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","Nyangka Mama Kuurrtu-tjananya ngaapirinypa watjarnu, “Yuwa, ngayulu-tjananyarna kalkulku ngula ngamu nyinakitjalu Yitjurayilku wartangkatja pirninya puru Tjuutaku wartangkatja pirninya. ");
INSERT INTO ntj_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Tjiinya kutjulpirtu-tjananyarna palunyaku tjamupirti ngurra nyarra Yiitjipulanguru walara katingu. Palunyalu-tjananyarna kalkurnu wantingu walykumunura kanyilkitjalu. Nyangka-rniya watjarnu ngayunyakutju pupakatirra marninypungkukitjalu. Palunyangka-tjananyarna wati kurrilupirinytju miranykanyira kanyiranytja. Parturtu-rniya ngayunya wantirralpi kutjupa-kutjupa pupakatirra marninypungkulanytja. ");
INSERT INTO ntj_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Yuwa, ngayulu-tjananyarna ngula tjukurrpa kutjupa watjalku wantiku ngaapirinypa: Ngayuku wangka-tjananyarna pinangka tjarrpatjunku wantiku. Puru-tjananyarna ngayuku wangka kurrurnta tjarrpatjunku ngayunya-rniya tirtu kuliratjaku. Ngayulu-tjananyarna Mamalu miranykanyira kanyinma. Palunyangka-rniya ngayunyakutju wananma. ");
INSERT INTO ntj_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Yuwa, kutjulpirtu-yanku ngaparrku-ngaparrkulu watjaranytja tjiinya-rniya kuliratjaku. Nyangka ngula-yanku palunyapirinypa watjalkitjamunu. Tjiinyamarntu-tjuya pirninyartu ngayuku ninti nyinama. Tjiinya-ya kutjupa-kutjupa palyamunu palyaranytja. Nyangka-tjanamparna mirrparnarringu nyinarranytja. Wiya, kalyparriku-tjanamparna. Palunyalu-rna watatjarriku. Yuwa, ngayulu-rna Mama Kuurrtu watjarnu.” ");
INSERT INTO ntj_vpl VALUES ("JR36_1","025_36_1","JER","36","1","1","Nyangka-rni Mama Kuurrtu watjarnu, “Yuwa Tjiramayi, ");
INSERT INTO ntj_vpl VALUES ("JR36_2","025_36_2","JER","36","2","2","tjiinya-rnanta rawalu watjaranytja tjiinya-tjanamparna palyamunu purlkanya yutilkitjalu yarnangu ngurra ngaangkatja pirniku. Kulila. Ruula wirrmira mantjiralpi walkatjurra tjukurrpa pirni tjiinya-rnanta kutjulpirtu watjarayirnu wantitjanya. ");
INSERT INTO ntj_vpl VALUES ("JR36_3","025_36_3","JER","36","3","3","Nyangka-tjinguru-ya yarnangu pirnilu tjukurrpa kuliralpi palyamunu pirni wantiku. Nyangka-tjanamparna kalyparriku.” ");
INSERT INTO ntj_vpl VALUES ("JR36_4","025_36_4","JER","36","4","4","Nyangka-rna kuliralpi wati kutju yarltingu watjarnu, “Yuwa, ruula ngaanya mantjila palunyalu nyinakatirralpi walkatjurra tjuma ngaanya-rna yatatjura watjaranyangka. Tjiinya-rni Mama Kuurrtu tjukurrpa pirni watjaranytja, palunyanya-rna watjalku nyuntulun walkatjunkutjaku.” Nyangka mularrpartu nyinakatirralpi tjukurrpa walkatjurayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("JR36_5","025_36_5","JER","36","5","5","Nyangka-rnalu watjarnu, “Kulila. Yaka-yakarnu-rniya wantingu tjurrtju purlkanyangka-rna tjarrpanytjamaalpa nyinarratjaku. ");
INSERT INTO ntj_vpl VALUES ("JR36_6","025_36_6","JER","36","6","6","Nyangkan nyuntunya palya yanku tjarrpaku tjiinya-ya yarnangu pirni lurrtjurringkulanyangka. Ma-tjarrparralpin tjukurrpa ngaanya nyakula watjanma. Nyangka-ya pirnilu kulilku. ");
INSERT INTO ntj_vpl VALUES ("JR36_7","025_36_7","JER","36","7","7","Palunyalu-tjinguru-ya palyamunu pirninya wantirralpi Mama Kuurrnga tjapilku. Tjiinyamarntu Mama Kuurrtu mirrparnarringkulalpi watjarnu palunyaku-tjanampa palyamunu purlkanya yutilkitjalu.” ");
INSERT INTO ntj_vpl VALUES ("JR36_8","025_36_8","JER","36","8","8","Nyangka mularrpartu wati palunyanya kutipitjangu tjurrtju purlkanyangka tjarrparralpi tjukurrpa ruulangkatja nyakula watjaranytja yarnangu pirnilu-ya nyinarra kuliranyangka. ");
INSERT INTO ntj_vpl VALUES ("JR36_11","025_36_11","JER","36","11","11","Nyangka wati kutjulu kulirnu tjukurrpa palunyanya nyakula watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("JR36_12","025_36_12","JER","36","12","12","Palunyalu pakara kutipitjangu puurrpa purlkaku yiwarlakutu. Palunyalu tjarrparralpi nyangu liita pirninya-ya nyinarra wangkarranyangka. ");
INSERT INTO ntj_vpl VALUES ("JR36_13","025_36_13","JER","36","13","13","Palunyalu-tjananya tjukurrpa ruulangkatjanya watjarnu. ");
INSERT INTO ntj_vpl VALUES ("JR36_14","025_36_14","JER","36","14","14","Nyangka-ya kuliralpi wati kutju witurnu yankula wati ruulatjarranya yarltirra katitjaku. Nyangka mularrpartu yanu yarltirra katingu. ");
INSERT INTO ntj_vpl VALUES ("JR36_15","025_36_15","JER","36","15","15","Nyangka-ya watjarnu, “Yuwa, nyinakatirralpi-lanyatju tjukurrpa ruulangkatjanya nyakula watjanma.” Nyangka mularrpartu nyinakatirralpi nyakula watjaranytja. ");
INSERT INTO ntj_vpl VALUES ("JR36_16","025_36_16","JER","36","16","16","Nyangka-ya tjukurrpa palyamunu kuliralpi kata paarnarrarnu. Palunyalu-yanku kuru ngaparrkulu nyakulalpi watjarnu, “Wiya, kutipitja-la puurrpa purlkanya watjala.” ");
INSERT INTO ntj_vpl VALUES ("JR36_17","025_36_17","JER","36","17","17","Nyangka-ya wati palunyanya tjapirnu, “Kutjupalu-muntanta watjarnu wantinyangkan tjukurrpa ngaanya walkatjunu?” ");
INSERT INTO ntj_vpl VALUES ("JR36_18","025_36_18","JER","36","18","18","Nyangka watjarnu, “Yuwa, Tjiramayilu-rni tjukurrpa yatatjura watjaranyangka-rna walkatjuranytja.” ");
INSERT INTO ntj_vpl VALUES ("JR36_19","025_36_19","JER","36","19","19","Nyangka-ya liita pirnilu watjarnu, “Wiya, mapitja Tjiramayinya watjala. Palunyatjanu-pula kutipitja kumpiralpi nyinama.” ");
INSERT INTO ntj_vpl VALUES ("JR36_20","025_36_20","JER","36","20","20","Nyangka-ya liita pirnilu ruula palunyanya makatingu ruumpa kutjupangka tjarrpatjunu wantingu. Palunyalu-ya mapitjangu tjukurrpa ruulangkatjanya puurrta watjarnu. ");
INSERT INTO ntj_vpl VALUES ("JR36_21","025_36_21","JER","36","21","21","Nyangka wati kutju witurnu yankula ruula palunyanya mantjira katitjaku. Nyangka mularrpartu mapitjangu mantjira katingu. Palunyalu tjukurrpa palunyanya nyakula watjaranytja puurrpa purlkalu puru liita pirnilu-ya kuliranyangka. ");
INSERT INTO ntj_vpl VALUES ("JR36_22","025_36_22","JER","36","22","22","Nyangka puurrpa palunyanya nyinarra waru ngantjiranytja tjiinya warri purlkanya ngaralanyangka. ");
INSERT INTO ntj_vpl VALUES ("JR36_23","025_36_23","JER","36","23","23","Nyangka wati palunyalu tjukurrpa nyakula watjaranyangka puurrpa purlkanyalu kunmarnungka ruula katapungkula warungka warnirra tjarrpatjuranytja. Katapungkula warungka warnirra tjarrpatjurayirnu wiyarnu. ");
INSERT INTO ntj_vpl VALUES ("JR36_24","025_36_24","JER","36","24","25","Nyangka-ya liita kutjupatjarralu purtu marrkuranytja. Nyangka-tjananya kulira wantirranytja. Tjiinya-ya puurrpa purlkanyalu puru waarka palyalpayi pirnilu ngurlumaaltu Mama Kuurrku wangka kulirnu wantingu. ");
INSERT INTO ntj_vpl VALUES ("JR36_26","025_36_26","JER","36","26","26","Nyangka puurrpa purlkalu wati marnkurrpa watjarnu, “Yuwa, mapitja-ya Tjiramayinya-pulanya tjulyara kati.” Nyangka-ya mularrpartu mapitjangu purtu-limpatjuya ngurrirayirnu wantingu. Tjiinyamarntu-linyatju Mama Kuurrtu kumpitjura kanyiranytja. ");
INSERT INTO ntj_vpl VALUES ("JR36_27","025_36_27","JER","36","27","28","Nyangka-rni Mama Kuurrtu watjarnu, “Yuwa Tjiramayi, ruula kutjupanya mantjiralpi nintila wati walkatjunkupayiku. Palunyalu tjukurrpa palunyanyartu puru watjala. Nyangkayi puru tjaawanalu walkatjurra wanti. Tjiinyamarntu puurrpa purlkalu ruula ngarnmanytjatjanya warungka warningu tjarrpatjunu, palunyangka.” ");
INSERT INTO ntj_vpl VALUES ("JR36_29","025_36_29","JER","36","29","31","Puru-rni Mama Kuurrtu watjarnu ngaapirinypa-rna puurrpa purlkala watjaltjaku, “Yuwa, nyuntulun ruula ngayuku wangkatjarranya warungka tilirnu. Wiya, nyuntunyanta-ya pungku mirrirntanku. Palunyalunta-ya yilkaku warniku wantiku. Tjiinya-tjananyarnanta purtu ngurlutjuranytja. Nyangka-rniyan kulira wantirranytja. Nyangka-tjanamparnanku palyamunu purlkanya yutilku.” Palunyapirinypa Mama Kuurrtu watjarnu. ");
INSERT INTO ntj_vpl VALUES ("JR36_32","025_36_32","JER","36","32","32","Nyangka-rna ruula kutjupanya mantjiralpi nintirnu wati palunyalu walkatjunkutjaku. Palunyalu-rna puru yatatjura watjaranytja. Nyangka-rni kulira tjaawanalurtu walkatjurayirnu wiyarnu. Tjiinya-rna tjukurrpa palunyanyartu watjaranytja. Puru-rna tjukurrpa kutjupa watjaranytja. Nyangka ruula palunyanya purlkanya ngaralanytja nyarra puurrpa purlkalu warungka warningu tjarrpatjunu, palunyangka munkarra. ");
INSERT INTO ntj_vpl VALUES ("JR38_1","025_38_1","JER","38","1","3","Nyangka Mama Kuurrtu-rni watjarnu yarnangu pirninya-rna ngaapirinypa watjaltjaku, “Yuwa, yiwarlangka-yan nyinaku mirrirriku. Tjiinya-yan yiwarlangka tirtu nyinarranyangka Mama Kuurrtu-tjananyanta yirringkankukitjamunulu wantiku. Nyangka-tjinguru-yan parltjatjirratja mirrirriku. Puru-tjinguru-yan pika purlkanya mantjiralpi mirrirriku. Tjinguru-tjananyanta warrmarlalu pungku wiyalku. Wiya-tjinguru-yan pakalku yinytjanurringku warrmarla Papulanngamartatji pirningka. Nyangka-tjananyanta wankakutu walara katiku palunyaku ngurrakutu.” Nyangka wati kutjarra-kutjarralu-rniya kulirnu yarnangu pirningka-rna watjaranyangka. ");
INSERT INTO ntj_vpl VALUES ("JR38_4","025_38_4","JER","38","4","4","Palunyalu-ya yanu puurrpa purlkanya watjarnu, “Wiya, Tjiramayilu tjukurrpa palyamunu watjaranytja. Nyangka-lampa warrmarla pirninya ngurlurringkula. Nyangka puru-ya yarnangu pirninya tjurlpilypa nyinarra. Witula-lanyatju. Nyangka-latju yarra puwa mirrirntarra.” ");
INSERT INTO ntj_vpl VALUES ("JR38_5","025_38_5","JER","38","5","5","Nyangka puurrpa purlkalu watjarnu, “Yuwa palya, mapitja-ya puwa wuyurrpa-tjananyanta ngaralanyangka. Kamu-tjananyarnanta marrkulku.” ");
INSERT INTO ntj_vpl VALUES ("JR38_6","025_38_6","JER","38","6","6","Nyangka-rniya pitjangu tjulyara katingu. Palunyatjanu-rniya kultuwanalu parrakarrpiralpi wiilpangka tjarrpatjunu. Nyangka-rna pilkingka nyinarranytja. Tjiinyamarntu kapi wiyarringu, nyangka pilki purlkanya ngarrirranytja. ");
INSERT INTO ntj_vpl VALUES ("JR38_7","025_38_7","JER","38","7","7","Nyangka wati marulu tjiinya puurrku yiwarlangka waarka palyalpayilu kulirnu ngayunya-rniya wiilpangka tjarrpatjunu. ");
INSERT INTO ntj_vpl VALUES ("JR38_8","025_38_8","JER","38","8","8","Palunyalu yanu puurrpa purlkanya watjarnu, ");
INSERT INTO ntj_vpl VALUES ("JR38_9","025_38_9","JER","38","9","9","“Wiya puurr, palyamunulu-ya Tjiramayinya wiilpangka tjarrpatjunu wantingu. Tjiinya nyinarrayilku parltjatjirratja mirrirriku.” ");
INSERT INTO ntj_vpl VALUES ("JR38_10","025_38_10","JER","38","10","10","Nyangka puurrpa purlkanyalu watjarnu, “Wiya, mapitja-tjananya wati marnkurrpa yarltirra wiilkutu yarra. Palunyalu marlakulu yilala mirrirritjakutarrartu.” ");
INSERT INTO ntj_vpl VALUES ("JR38_11","025_38_11","JER","38","11","11","Nyangka-ya mularrpartu pitjangu wiilkutu. Tjiinya-ya warntu yurnantji mantjira katingu. Palunyalu-ya purturru puru warntu tjarrpatjuralpi ");
INSERT INTO ntj_vpl VALUES ("JR38_12","025_38_12","JER","38","12","12","watjarnu, “Warntu ngaanya ngayanywanalu karrpila purturrulunta pikaltjakutarra.” Nyangka-rna mularrpartu karrpirnu. ");
INSERT INTO ntj_vpl VALUES ("JR38_13","025_38_13","JER","38","13","13","Nyangka-rniya purturrungka yilarnu katurnu. Nyangkalta-rniya wati kutjupatjarralu yaarrpa kaninytjarra tjarrpatjuralpi tirtu miranykanyira kanyiranytja. Yuwa, palunya. ");
INSERT INTO ntj_vpl VALUES ("EK33_1","027_33_1","EZK","33","1","1","Nyangka Mama Kuurrtu-rni ngaapirinypa watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EK33_2","027_33_2","EZK","33","2","2","“Yuwa Yiitjikul, tjukurrpa-tjananya ngaapirinypa watjala. Tjukurrpa ngaanya-rna ngarnartu watjara. Tjinguru-rna warrmarla pirni witulku ngurra kutjupakutu-ya mapitjala yarnangu pirni pungkula mirrirntaltjaku. Nyangka-ya yarnangu ngurra palunyangkatjalu-tjinguru kuliralpi wati kutju witulku purlingka tatira nyinarra nyakulatjaku. ");
INSERT INTO ntj_vpl VALUES ("EK33_3","027_33_3","EZK","33","3","3","Nyangka wati palunyalu nyinaku nyaku warrmarla pirninya waalkarrannyangka mirraku yarnangu pirninya ngurlutjunku. Nyangka-ya kaninytjarra tjarrpaku wankarriku. ");
INSERT INTO ntj_vpl VALUES ("EK33_4","027_33_4","EZK","33","4","5","Nyangka-tjinguru kutjupalu mirra kulilku wantiku. Nyangka-ya warrmarlalu pitjaku pungku. Tjiinya yungarralunku kurrakuturnu. Tjinguru kulira ngurlu tjarrpama wankarrikitja. ");
INSERT INTO ntj_vpl VALUES ("EK33_6","027_33_6","EZK","33","6","6","Nyangka-tjinguru wati nyarra nyakupayilu warrmarla pirninya nyakula yarnangu pirninya ngurlutjunkutjamaaltu wantiku. Nyangka warrmarla palunyalu-ya pitjaku-tjananya yarnangu palyamunu pirninya pungku mirrirntanku. Nyangka-rna watjara tjiinya wati nyakupayinya kunkanyarriku. Tjiinya tjinguru-tjananya mirrarra ngurlutjunama. ");
INSERT INTO ntj_vpl VALUES ("EK33_7","027_33_7","EZK","33","7","7","Yuwa Yiitjikul, palunyapirinypartu-rnanta ngurrkarntanu Yitjurayilku tjamupirti ngurlutjunkulatjaku. Nyangkan ngayuku wangka kuliralpi-tjananya ngurlutjunku wantiku. ");
INSERT INTO ntj_vpl VALUES ("EK33_8","027_33_8","EZK","33","8","8","Tjinguru-rna yarnangu palyamunu palyalpayinya mirritjunku. Nyangka-tjingurun ngurlutjunkutjamaaltu wantiku. Nyangka yarnangu palunyanya mirrirriku. Nyangka nyuntunyan kunkanyarriku. Tjiinyamarntu nyuntulun watjantjamunungka yarnangu palunyanya watatja nyinangu mirrirringu. ");
INSERT INTO ntj_vpl VALUES ("EK33_9","027_33_9","EZK","33","9","9","Nyangka-tjingurun nyuntulu yarnangu palyamunu palunyanya ngurlutjunku. Nyangka-tjinguru tungun-tunguntu tirtu kulira wantirra palyamunu palyanma. Tjiinya yungarralunku kurrakutulku. Nyangka nyuntunyan kunkanyarrikitjamunu.” ");
INSERT INTO ntj_vpl VALUES ("EK33_10","027_33_10","EZK","33","10","10","Nyangka Mama Kuurrtu-rni ngaapirinypa watjarnu, “Yuwa Yiitjikul, Yitjurayilku tjamupirtilu-ya ngaapirinypa watjara, ‘Wiya, palyamunu-lan tirtu palyalpayi. Palyamunu wantikitjalu-lan purtu kulira. Tjinguru-lan mirrirriku palyamunu palyaranytjatjanu. Nyaapirinymanku-lan wanka nyinakitjalu?’ ");
INSERT INTO ntj_vpl VALUES ("EK33_11","027_33_11","EZK","33","11","11","Nyangka-tjananya ngaapirinypa watjala. Tjiinya-rna nyakula pukurlarrikitjamunu yarnangu nyarra palyamunu palyalpayinya mirrirringkunyangka. Wiya, pukurlarriku-rna tjiinya-ya palyamunu wantirra pitjanyangka. Yuwa Yitjurayilku tjamupirti, nyaaku-yan mukurringkula mirrirrikitja? Wiya, palyamunu-ya wantirralpi ngayulakutu pinkurraala wanka nyinakitja. ");
INSERT INTO ntj_vpl VALUES ("EK33_12","027_33_12","EZK","33","12","12","Yuwa Yiitjikul, ngaapirinypa-tjananya watjala, Nyangka-tjinguru walykumunu palyalpayilu kutjuparringkulalpi palyamunu palyalku. Wiya, yarnangu palunyanya kamu wankarriku kutjulpirtu walykumunu palyaranytjatjanu. Nyangka kutjupalu-tjinguru palyamunu palyaranytjatjanulu wantiku. Nyangka-rnalu kalyparringkulalpi kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EK33_13","027_33_13","EZK","33","13","13","Yuwa, ngayulu-tjinguru-rnalu kalkulku walykumunu palyalpayinya wankara kanyilkitjalu. Nyangka-tjinguru ngaapirinypa kulilku, ‘Ngayulu-rna rawalu walykumunu palyaranytja. Wantirralpi-rna palyamunu palyanma.’ Nyangka-rna kulilkitjamunu kutjulpirtu walykumunu palyaranytjanya, watatjarriku-rna. Nyangka yarnangu palunyanya palyamununguru wiyarriku. ");
INSERT INTO ntj_vpl VALUES ("EK33_14","027_33_14","EZK","33","14","15","Nyangka-tjinguru-rna palyamunu palyalpayingka watjalku, ‘Nyuntunyan mirrirriku.’ Nyangka-tjinguru palyamunu wantirralpi walykumunu palyanma. Tjinguru kutjupaku-ra mulyatarrirralpi marlakulu nintilku. Palunyalu palyamunu wantirralpi ngayuku wangka wangarnarralu kulira palyanma. Wiya, yarnangu palunyanya mirrirrikitjamunu wanka nyinama. ");
INSERT INTO ntj_vpl VALUES ("EK33_16","027_33_16","EZK","33","16","16","Tjiinya-rna kulilkitjamunu kutjulpirtu palyamunu palyaranytjanya, kalyparriku-rnara. Palunyangka wanka nyinama tjukarurrulu palyantjatjanulu.” Palunyapirinypa Mama Kuurrtu-rni watjarnu. ");
INSERT INTO ntj_vpl VALUES ("EK34_1","027_34_1","EZK","34","1","1","Nyangka-rni Mama Kuurrtu ngaapirinypa watjarnu, ");
INSERT INTO ntj_vpl VALUES ("EK34_2","027_34_2","EZK","34","2","2","“Yuwa Yiitjikul, Yitjurayilku tjamupirti-ya ngayuku tjiipu nyinarra. Nyangka-ya liita pirninya tjiipu miranykanyilpayipirinypa. Liita pirninya payinma. Watjala-tjananya tjukurrpa ngaanya-ya kuliltjaku tjiinya-rna tjukurrpa tjiipuwana kamparntaralpi watjannyangka, Wiya, mirrparnpa-tjanamparnanku nyinarra. Yungarralu-yankun parltjara kanyira. Palunyalu-munta-yan tjiipu pirninya parltjara kanyiranytja? Wiyartu. ");
INSERT INTO ntj_vpl VALUES ("EK34_3","027_34_3","EZK","34","3","3","Tjiinya-yan tjiipuku mimi tjikira. Puru-yan tjiipuku purrmu katapungkula rulyupungkula warntu wakara tjarrpatjura kanyira. Puru-yan tjiipu karnpi purlkanya pungkula ngalkula. Tjinguru-yan tjiiputarrartu miranykanyira kanyinma. ");
INSERT INTO ntj_vpl VALUES ("EK34_4","027_34_4","EZK","34","4","4","Nyangka-munta-yan tjiipu wawanypa miranykanyira kanyiranytja? Wiyartu. Puru-munta-yan pikatjarra miranykanyira kanyiranytja? Wiyartu. Puru-munta-yan riikingka-tjananya karrpira kanyiranytja tarrka-tjananya kartakatirranyangka? Wiyartu. Puru-munta-yan mantjira-tjananya katingu wililyarrara-ya kutjupa-kutjupawana kutipitjanyangka? Wiyartu. Puru-munta-yan wanarnu nyangu kawarnarrara-ya kutjupayarla yankulanyangka? Wiya, nyuntulu-tjananyan ngarltumaaltu tjirtira parrawanaranytja. ");
INSERT INTO ntj_vpl VALUES ("EK34_5","027_34_5","EZK","34","5","5","Nyangka-ya kawarnarrara kutjupayarla kutipitjangu, tjiinyamarntu kutjupalu-tjananya miranykanyira kanyiranytjamunungka. Nyangka-tjananya ngupanu pirnilu patjara ngalkulanytja. ");
INSERT INTO ntj_vpl VALUES ("EK34_6","027_34_6","EZK","34","6","6","Yuwa, ngayuku-tjuya tjiipu tjarra-tjarrarringkula yapuwana kawarnarrara kutipitjangu. Ngurra kutjupa-kutjupawana-ya tjarra-tjarrarringkula kutipitjangu. Nyangka-tjananya kutjupalu yankula parrangurrintjamaaltu wantingu.” ");
INSERT INTO ntj_vpl VALUES ("EK34_7","027_34_7","EZK","34","7","8","Nyangka Mama Kuurrtu-tjananya tirtu watjara-wanarayintja, Yuwa, tjiipu miranykanyilpayilu-rniya kulila ngayulu-rna Mama Kuurrtu watjaranyangka. Yuwa, ngupanu pirnilu-tjuya ngayuku tjiipu patjara ngalkulanytja. Tjiinyamarntu-yan miranykanyira kanyiranytjamunu. Tjiinya-yan nyakula marlakura katirranytjamunu kawarnarrara-ya kutipitjanyangka. Puru-yan tjiipu pirniku mirrka nintiranytjamunu. Yungarralukutju-yankun parltjara kanyir