﻿USE sofia;
DROP TABLE IF EXISTS sofia.nsu_vpl;
CREATE TABLE nsu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nsu_vpl WRITE;
INSERT INTO nsu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ninmeh yejvah tlen yi wejkavitl opanokeh ikojkolvah Jesucristo, tlen valajtok de David, iva noijki valajtok de Abraham. ");
INSERT INTO nsu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham oyá teta de Isaac. Isaac oyá teta de Jacob. Jacob oyá teta de Judá ivan iknivah. ");
INSERT INTO nsu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ivan Tamar okinpixkeh inpilvah intoka Fares iva Zara. Fares oyá teta de Esrom. Esrom oyá teta de Aram. ");
INSERT INTO nsu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram oyá teta de Aminadab. Aminadab oyá teta de Naasón. Naasón oyá teta de Salmón. ");
INSERT INTO nsu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ivan Rahab okipixkeh inkone itoka Booz. Booz ivan Rut okipixkeh inkone itoka Obed. Obed oyá teta de Isaí. ");
INSERT INTO nsu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí oyá teta de tlen wei tlanavati David, iva David oyá teta de Salomón. Imama Salomón yen okatka itonana in Urías. ");
INSERT INTO nsu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón oyá teta de Roboam. Roboam oyá teta de Abías. Abías oyá teta de Asa. ");
INSERT INTO nsu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa oyá teta de Josafat. Josafat oyá teta de Joram. Joram oyá teta de Uzias. ");
INSERT INTO nsu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias oyá teta de Jotám. Jotám oyá teta de Acaz. Acaz oyá teta de Ezequías. ");
INSERT INTO nsu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías oyá teta de Manasés. Manasés oyá teta de Amón. Amón oyá teta de Josías. ");
INSERT INTO nsu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías oyá teta de Jeconías iva okinpixki oksekimeh ipilvah, tlen okinpixki nepa tiempo ijkuak in gentejtih de Israel okinvikakeh para kan país de Babilonia. ");
INSERT INTO nsu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Satepa ijkuak in gentejtih de Israel okinvikakeh para Babilonia, Jeconías okipixki se ikone itoka Salatiel. Salatiel oyá teta de Zorobabel. ");
INSERT INTO nsu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel oyá teta de Abiud. Abiud oyá teta de Eliaquim. Eliaquim oyá teta de Azor. ");
INSERT INTO nsu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor oyá teta de Sadoc. Sadoc oyá teta de Aquim. Aquim oyá teta de Eliud. ");
INSERT INTO nsu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud oyá teta de Eleazar. Eleazar oyá teta de Matán. Matán oyá teta de Jacob. ");
INSERT INTO nsu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob oyá teta de José. Iva José ye tlen oyá itotata in María. Iva María okipixki ikone itoka Jesús, tlen tiknotzah Cristo. ");
INSERT INTO nsu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Opanokeh majtlaktli ivan navi tekojkolvah desde Abraham asta David. Noijki opanokeh majtlaktli ivan navi tekojkolvah desde David asta ijkuak in gentejtih de Israel okinvikakeh para Babilonia. Iva noijki opanokeh majtlaktli ivan navi tekojkolvah desde ijkuak okinvikakeh para Babilonia iva asta ijkuak oneski in Cristo. ");
INSERT INTO nsu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijkí opanolok ijkuak oneski in Jesucristo. María tlen imama in Jesús, yokitlajtlankah para monamiktis ivan José. Pero antes de mosetiliskeh, María yokipiaya ikonetzi ijtik ika ivelitilis in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iva José, tlen yokatka para monamiktis ivan María, ye se kuali tlakatl. Ye amo okinekki kiteixpantis para kipijpinatis in María, iva por eso okijto kikajkavas san ichtaka. ");
INSERT INTO nsu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ye okiyejyekovaya ijkó kichivas, pero José okitemiki se ilvikaktlatitlanili de toTeko okimonextili iva okilvi: —José, te tlen tivalevatok iwejkaixvi de David, amo ximavi de timonamiktis ivan María, porke in Tioijyotzintli ika ivelitilis okichi ma kipia yejón konetl. ");
INSERT INTO nsu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María kipias se konetl, iva tiktokayotis JESÚS, porke Ye kinmakixtis in gentejtih de Israel de nochi intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nochi nin ijkó opanolok para ma mochiva tlen okijto in toTeko por medio de yen tiotenejmachti, ijkuak okijto: ");
INSERT INTO nsu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Se ichpochtli tlen ayamo kipia itotata kipias se konetl, iva yejón konetl yetos itoka Emanuel, Emanuel kijtosneki: toYejwatzi tovan kajki. ");
INSERT INTO nsu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ijkuak José oijsak, okichi ijkó kemi okinavati in ilvikaktlatitlanili de toTeko, iva omonamikti ivan María. ");
INSERT INTO nsu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero yejvah amo osepankochiah sino asta ijkuak María okipixki ikone. Iva José okitokayoti in konetl Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús oneski itech altepetl Belén itech tlali de Judea ijkuak Herodes okatka wei tlanavati. Ijkuakó ovalajkeh ik kan valkisa tonali sekimeh ixtlamatkeh de sitlalimeh iva oajsikoh kan siudad de Jerusalén, ");
INSERT INTO nsu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","tlajtlantivitzeh: —¿Kanin kajki in wei tlanavati de judiojtih tlen yoneski? Otikittakeh isitlal ik ikan valkisa tonali, iva otivalajkeh otikweijkachivakoh. ");
INSERT INTO nsu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","In wei tlanavati Herodes iva nochtin gentejtih de Jerusalén omomavtijkeh ijkuak ijkó okikakkeh. ");
INSERT INTO nsu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes okinmololo nochtin tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés. Iva okintlajtlani kanin nesis in Cristo. ");
INSERT INTO nsu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iva yejvah okilvijkeh: —Nesis itech altepetl Belén, itech tlali de Judea. Porke ijkó okijkuilo in tiotenejmachti: ");
INSERT INTO nsu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Te Belén tlen tika itech tlali de Judá, te maski titzikitzi, te okachi tiweititok. Porke motech kisas se wei tlayakanki, tlen kinyakanas nopilvah, tlen gentejtih de Israel. ");
INSERT INTO nsu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ijkuakó Herodes san ichtaka okinnotzki in ixtlamatkeh de sitlalimeh, iva okintlajtlani itech tlan tonali mero oneski yejón sitlali. ");
INSERT INTO nsu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tonses okintitlanki ma viah Belén, iva okinmilvi: —Xiviah ompa, iva kuali xitlajtlanikah kanin kajki yejón konetl. Iva ijkuak inkajsitivih, san nima innechilviskeh para noijki nias nikweijkachivati. ");
INSERT INTO nsu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","In ixtlamatkeh de sitlalimeh satepa de okikakkeh tlen okinnavati in Herodes, oonnevakeh para Belén. Iva in sitlali tlen okittakeh ik kan valkisa tonali, okinyakantiah iva omoketzato asta kan kajki in konetl. ");
INSERT INTO nsu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ijkuak in ixtlamatkeh de sitlalimeh okittakeh in sitlali, sa tlawel opakeh. ");
INSERT INTO nsu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ijkuak okalakeh kalijtik, okittakeh in konetl ivan María tlen imama in konetl. Omotlankuaketzkeh iva okiweijkachijkeh in konetl. Satepa okintlapojkeh inkajajvah iva okitliekolijkeh oro, kopali iva ajviakayotl itoka mirra. ");
INSERT INTO nsu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Satepa, in ixtlamatkeh de sitlalimeh otemikeh Dios okinmilvi ayakmo ma mokuapakah inavak Herodes, por eso satepa yejvah omokuapkeh para inpaís itech oksé ojtli. ");
INSERT INTO nsu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ijkuak in ixtlamatkeh de sitlalimeh yoyajkeh, José okitemiki se iilvikaktlatitlanil in toTeko, okilvi: —Ximeva José, xikvika in chokotzi ivan imama para kan país de Egipto iva ompa ximokava asta ijkuak ne nimitznavatis oksé welta xivalmokuapa. Porke Herodes kitemojtinemis in konetl para kimiktis. ");
INSERT INTO nsu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","San nima yejón yovak ijkuak oijsak in José, omejki iva okivikak in konetl ivan imama para Egipto. ");
INSERT INTO nsu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iva ompa omokajkeh asta ijkuak Herodes omikki. Ijkó opanolok para ma mochiva tlen toTeko okijto por medio de yen tiotenejmachti: “De Egipto oniknotzki noKone.” ");
INSERT INTO nsu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ijkuak Herodes okimatki ke okikajkayajkeh in ixtlamatkeh de sitlalimeh, sa tlawel okualanki iva otlanavati ma kinmixpolokah nochtin chokojtzitzintih tlen chantih itech altepetl Belén iva itech nochtin oksekimeh altepemeh tlen ik ompa kateh. Herodes otlanavati ma kinmixpolokah nochtin chokojtzitzintih de ome xivitl para tlani. ");
INSERT INTO nsu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijkó opanolok kemi okijkuilo in tiotenejmachti Jeremías: ");
INSERT INTO nsu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Miek chokalistli iva miek neyolkokoli okikakkeh in gentejtih de Ramá, yen Raquel tlen choka por ipilvah, iva amo kineki moyolalis, porke yokinmixpolojkeh ipilvah. ");
INSERT INTO nsu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ijkuak Herodes omikki, José okatka Egipto iva ompa okitemikki se iilvikaktlatitlanil in toTeko, okilvi: ");
INSERT INTO nsu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ximeva, xikvika in konetl ivan imama, iva ximokuapa oksemi para Israel. Porke yomikkeh tlen okinekiah kixpoloskeh in chokotzi. ");
INSERT INTO nsu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ijkuakó in José omejki iva okivikak in konetl ivan imama para Israel. ");
INSERT INTO nsu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero ijkuak José okimatki ke itech tlali de Judea ayakmo yen Herodes tlen otlanavatijtoka sino ipiltzi tlen itoka Arquelao, ijkuakó omomavti yas ompa. José otemikki Dios okilvi ma via ik tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tonses, oyá itech yejón tlali iva ochantik itech se altepetl itoka Nazaret. Ijkó opanolok kemi okijtojkeh in tiotenejmachtijkeh, ke kinotzaskeh nazareno. ");
INSERT INTO nsu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Itech nekateh tonaltih, Juan tlen tlabautisaro ovala kan tlavaki de Judea, iva ope tetlapovia. ");
INSERT INTO nsu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Okijtovaya: —Ximoyolkuapakah, porke itlanavatijkayo in toYejwatzi yoejkok imonavak. ");
INSERT INTO nsu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","In tiotenejmachti Isaías nepa tiempo otlapo de Juan, ijkuak okijto: Se tlajtoli mokaki chikavak tetzajtzilia kan tlavaki, kijtova: “Xikyektlalikah iva xikmelavakah iojviv in toTeko.” ");
INSERT INTO nsu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Itzotzol in Juan ochijchitoka ika itzojmio kameyo, iva omotlajkoilpiaya ika se kuetlaxtli. Okinkuaya chapulimeh iva okikuaya serajnektli tlen onka itech tepetl. ");
INSERT INTO nsu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Miekeh gentejtih de Jerusalén, iva de nochi tlali de Judea iva de nochi tlali kan kajki in weyatl Jordán, oyayah kan tlavaki para kikakiskeh in Juan. ");
INSERT INTO nsu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iva ijkuak okimokuitiayah intlajtlakol, Juan okinbautisarovaya ijtik in weyatl Jordán. ");
INSERT INTO nsu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero ijkuak Juan okittak ke miekeh fariseos ivan saduceos ovalayah inavak para ma kinbautisaro, okinmilvi: —¡Imejvah intepilvah de kovameh! ¿Akin omechilvi ke tla inmobautisaroskeh ayakmo imechajsis ikualanilis in toYejwatzi tlen vitz inmopa? ");
INSERT INTO nsu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xikchivakah tlen kuali para ma motta nik yi neli yonmoyolkuapkeh, ");
INSERT INTO nsu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","iva amo xikyejyekokah ke imejvah kuali inkateh porke intepilvah de Abraham. Porke yi neli nimechilvia ke asta ninmeh temeh toYejwatzi velis kinkuapas kemi ipilvah in Abraham. ");
INSERT INTO nsu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","In acha yi kajki para kintzontekis asta itech innelvayo in kuanmeh, iva nochtin kuanmeh tlen amo kuali intlakilo kintzontekiskeh iva kintlamotlaskeh ijtik tlitl. ");
INSERT INTO nsu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ne yi neli nimechbautisarova ika atl para ma motta nik yi neli yonmoyolkuapkeh. Pero satepa de ne, vitz oksé tlen okachi velitini iva amo kemin ne, iva nion amo notech povi nion para nikinvikilis ikakvah. Ye imechbautisaros ika Tioijyotzintli iva ika tlitl. ");
INSERT INTO nsu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yi kipixtok ipala para pevas kichipavas in trigo. Iva in trigo tlen yi chipavak kitlaatis ijtik sinkali, pero itlajsolo kitlamotlas ijtik tlitl tlen amo keman sevis. ");
INSERT INTO nsu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Satepa Jesús okiski de Galilea iva oyá kan weyatl Jordán kan okatka in Juan, ompa oyá para ma kibautisaro in Juan. ");
INSERT INTO nsu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan amo okinekia kibautisaros in Jesús, iva okilvi: —Moneki yen tejwatzi techbautisaro. ¿Sejpa yej ne tikneki ma nimitzbautisaro? ");
INSERT INTO nsu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero Jesús okilvi: —Axka san ok ijkó xikava, porke Dios ijkó kineki ma tikchivakah nochi tlen kuali. Iva Juan okijto kuali kajki. ");
INSERT INTO nsu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ijkuak Jesús omobautisaro iva ijkuak ovalkiski de ijtik atl, in ilvikak otlapovik iva Jesús okittak in Tioijyotzintli ovaltemovaya ipa kemi se palomax. ");
INSERT INTO nsu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iva omokakki se tlajtoli itech ilvikak, okijto: —Ye nin noKone tlen sa tlawel niktlasojtla, iva tlen nikpia pakilistli inavak. ");
INSERT INTO nsu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Satepa, in Tioijyotzintli okivikak in Jesús kan tlavaki, para ompa in Amo Kuali Tlakatl ma kiyejyeko ika tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús omosavki ompoali tonali iva ompoali yovali, iva satepa otiojsi. ");
INSERT INTO nsu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iva in tetlajtlakolchivalti omotoki inavak, iva okilvi: —Tla yi neli tiiKone in Dios, xikinmilvi ninmeh temeh ma mokuapakah panmeh. ");
INSERT INTO nsu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Jesús okinankili: —In Tiotlajkuiloli kijtova: “In tlakatl amo velis yolitos san ika tlakuali, sino noijki ika itlajtol in Dios tlen Ye techilvia.” ");
INSERT INTO nsu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Satepa in Amo Kuali Tlakatl okivikak in Jesús kan siudad de Jerusalén tlen tlatiochivali, iva okitlejkolti ikpak in templo ");
INSERT INTO nsu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","iva okilvi: —Tla yi neli tiiKone in Dios, xontzikuini tlatzintla, porke in Tiotlajkuiloli kijtova: Dios kintitlanis iilvikaktlatitlanilvah para ma mitzpalevikah. Mitzajkuanaskeh ika inmavah, para amo tikmomakati itla tetl itech mokxi. ");
INSERT INTO nsu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús okilvi: —In Tiotlajkuiloli noijki kijtova: “Amo xikyejyeko in moTeko Dios.” ");
INSERT INTO nsu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ijkuakó in Amo Kuali Tlakatl oksemi okivikak in Jesús ipan se tepetl tlen okachi wejkapa, iva ompa okimititi nochtin países tlen okachi wejweititokeh iva tlen okachi chijchikavakeh de nin tlaltikpaktli, ");
INSERT INTO nsu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","iva okilvi: —Nochi nin nimitzmakas, tla timotlankuaketzas iva techweijkachivas. ");
INSERT INTO nsu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ijkuakó Jesús okilvi in Amo Kuali Tlakatl: —Ximachiva, Amo Kuali Tlakatl, porke in Tiotlajkuiloli kijtova: “Xikweijkachiva in moTeko Dios, iva san Ye xiktekipano.” ");
INSERT INTO nsu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ijkuakó in Amo Kuali Tlakatl oyá, iva sekimeh ilvikaktlatitlaniltih ovalajkeh para okiservirojkeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ijkuak Jesús okimatki nik in Juan okitzakeh telpiloya, oyá itech tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero amo omoka Nazaret, sino oyá ochantito Capernaum, tlen kajki itempan atl de Galilea, itech tlali de Zabulón iva de Neftalí. ");
INSERT INTO nsu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ijkó otlamochi para ma mochiva tlen okijkuilo in tiotenejmachti Isaías: ");
INSERT INTO nsu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tlali de Zabulón iva tlali de Neftalí, ojtli tlen panotok itempan atl tlen wei, ik nepa lado de kan weyatl Jordán, tlali de Galilea kan chantih tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","In gentejtih tlen kateh kan tlayova kittaskeh se wei tlavili. Tlen kateh kan tlayovalotl de mikilistli, kintlavilis se tlavili. ");
INSERT INTO nsu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iva desde ijkuakó Jesús ope tetlapovia, okijtovaya: —Ximoyolkuapakah, porke yi kajki serka para Dios pevas tlanavatis imonavak. ");
INSERT INTO nsu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Se tonali Jesús onejnentiaya itempan atl tlen wei de Galilea, iva okinmitak ome iknimeh, Simón tlen noijki okinotzayah Pedro iva ikni Andrés. Yejvah okintlamotlatokah inredvah ijtik atl, porke okatkah michkitzkijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús okinmilvi: —Xivikikah nova. Ne nimechmachtis kenik inkintlaniskeh in gentejtih para ma nechseguirokah kemi oyeskia inkinkitzkiskeh michimeh. ");
INSERT INTO nsu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yejvah san nima okinkajtejkeh inredvah iva oyajkeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Okachi tlayakapa, Jesús okinmitak ok ome tlakah iknimeh, Jacobo ivan Juan, itelpochvah in Zebedeo. Ompa okatkah ivan inpapa itech se barko okintlajtlamanijtokah inredvah. Jesús okinnotzki, ");
INSERT INTO nsu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","iva yejvah san nima okajtejkeh inbarko ivan inpapa, iva oyajkeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús onemia itech nochtin altepemeh de Galilea, iva otlamachtijtiaya itech tiotlamachtijkaltih. Otetlapoviaya nik in Dios yi pevas tlanavatis kemi wei tlanavati. Iva okinpajtiaya in gentejtih de nochi kokolistli iva de nochi kualolistli. ");
INSERT INTO nsu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Itech nochi in tlali de Siria, okimatkeh tlen Jesús okichivaya, iva okinvalikilijkeh nochtin tlen okipiayah tlatlamantli kokolistli, iva noijki tlen sa tlawel okinkokovaya inkuerpo. Noijki tlen omimikiah, iva tlen amo oveliah onejnemiah iva tlen okinpiayah amo kuali ejekameh. Iva Jesús nochtin okinpajti. ");
INSERT INTO nsu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ope kiseguirovah in Jesús miekeh gentejtih de Galilea, de Decápolis, de Jerusalén, de Judea, iva de tlen kateh ik nepa lado de kan weyatl Jordán. ");
INSERT INTO nsu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ijkuak Jesús okinmitak omololojkeh miekeh gentejtih, otlejkok ipan se tepetl iva ompa omotlali. Ijkuakó in momachtijkeh omotokijkeh inavak. ");
INSERT INTO nsu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús ope kinmachtia ijkí: ");
INSERT INTO nsu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ma pakikah tlen kimachiliah moneki kitemoskeh okachi in Dios, porke yejvah poviskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ma pakikah tlen chokah, porke Dios kinyolalis. ");
INSERT INTO nsu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ma pakikah tlen yolyamankeh, porke yetos inmaxka in tlali tlen Dios okinkakiti kinmakas. ");
INSERT INTO nsu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ma pakikah tlen ika nochi inyolo kinekih kichivaskeh tlen kuali, iva Dios kinpalevis asta ma ixvikah. ");
INSERT INTO nsu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ma pakikah tlen teiknomatih, porke Dios noijki kinmiknomatis. ");
INSERT INTO nsu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ma pakikah tlen yolchipavakeh, porke yejvah kittaskeh toTajtzin Dios. ");
INSERT INTO nsu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ma pakikah tlen kichivah amika ma mokualani, porke Dios kinnotzas kemi ipilvah. ");
INSERT INTO nsu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ma pakikah tlen kinchochololtiah por kichivah tlen Dios kineki, porke yejvah yeskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Tla imejvah por innechneltokah, in gentejtih imechvikaltiah, imechochololtiah, iva imechistlakaviah, ijkuakó imejvah xipakikah. ");
INSERT INTO nsu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xipakikah, yi neli xipakikah porke imejvah inkiseliskeh se wei tlaxtlavili itech ilvikak. Porke in tiotenejmachtijkeh tlen nepa tiempo okatkah, noijki ijkó okintoktijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Imejvah inkateh kemi istatl itech nin tlaltikpaktli. Pero tla in istatl ayakmo yetos poyek, ¿kenomi oksé welta poyeyas? Ayakmo kuali, sa se kitlamotla kiavak iva sa ipan mokejketzah. ");
INSERT INTO nsu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Imejvah inkateh kemi se tlavili itech nin tlaltikpaktli. Kemi se altepetl tlen kajki ipan se tepetl amo veli motlaatia. ");
INSERT INTO nsu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nion amika kitlikuitia se tlavili para kitlaatis itlampa se kajo, sino se kitlalia tlakpak para ma kintlavili nochtin tlen kateh kalijtik. ");
INSERT INTO nsu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ijkó noijki imejvah, xikintlavilikah in gentejtih para ma kittakah nik imejvah inkichivah tlen kuali, iva ijkó yejvah kiweijkachivaskeh imoTajtzi tlen kajki ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Amo xikyejyekokah ke Ne onivala onikpopoloko itlanavatil Moisés o tlen okijkuilojkeh in tiotenejmachtijkeh. Amo, mach onivala onikpopoloko, sino onivala para nikchivas nochi tlen kijtova. ");
INSERT INTO nsu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yi neli nimechilvia, mientras ok yetos ilvikak ivan tlaltikpaktli, amo polivis nion se letra iva nion se punto tlen ijkuilitok itech Dios itlanavatil, asta ma mochiva nochi tlen omijkuilo. ");
INSERT INTO nsu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por eso, tlen akin kipopolos se de ninmeh tlanavatiltih maski ma yeto tzikitzi, iva kinmachtis oksekimeh ijkó ma kichivakah, yejón tlakatl yetos sa tlawel tzikitzi kan Dios tlanavatia. Pero tlen akin kichivas iva tlamachtis ma kichivakah tlen kijtova yejón tlanavatili, yejón tlakatl yetos wei ijkuak Dios tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yi neli nimechilvia, tla imejvah amo inkichivaskeh tlen Dios kineki okachi ke tlen kichivah in fariseos ivan tlamachtijkeh de itlanavatil Moisés, tonses amo inkalakiskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Imejvah yinkimatih tlen yi wejkavitl imokojkolvah okinmachtijkeh: “Amo xitemikti, porke tlen temiktis kipia de kivikaskeh tekivajkapa para kitlajtlakoltiskeh.” ");
INSERT INTO nsu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero Ne nimechilvia, tlen kualanis inavak se itlakaikni, noijki kipia de kivikaskeh kan tekivajkapa kan teyekankavah para kitlajtlakoltiskeh. Iva tla íkka kilvis se itlakaikni: “Kuatonto”, yejón tlamantli kipia de kittaskeh itech injunta in judiojtih. Iva tla íkka kilvis se itlakaikni: “Miktlan yolkatl”, yetos tlajtlakole iva velis yaski miktla ijtik tlitl. ");
INSERT INTO nsu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Por eso, tla yi tiav tiktemakati motlamanal kan artal iva tikvalilnamiki ke se mokni kualani mova ika itla, ");
INSERT INTO nsu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ompa xikava motlamanal iyakapan artal iva achto xivia ximotlapojpolviti ivan mokni. Iva satepa yi velis tias kan artal para tiktemakas motlamanal. ");
INSERT INTO nsu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tla íkka mitzteilvia iva mitzvika innavak tekivajkeh, moneki achto iva ximoyektlali antes de mitztemaktis imak in jues, porke tlamo, in jues mitztemaktis inmak in mayoltih para ma mitztzakuakah. ");
INSERT INTO nsu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iva yi neli nimitzilvia ke amo tikisas de ompa telpiloya asta kan amo xiktlaxtlava nochi in tomi tlen mitztlajtlaniliskeh. ");
INSERT INTO nsu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Imejvah yinkimatih tlen yi wejkavitl omijto: “Amo xiavilnemi itech tlajtlakoli.” ");
INSERT INTO nsu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero Ne nimechilvia tla íkka kittas se sivatl iva kivelitas kemi para ivan kochis, kijtosneki yokichi imosa itech iyolo. ");
INSERT INTO nsu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Por eso, tla moixtololo de moyekmapa kichiva xivetzi itech tlajtlakoli, xikmokixtili iva wejka xiktlamotla. Okachi kuali xikpolo se parte de mokuerpo, iva amo nochi mokuerpo ma kontlamotlakah miktla. ");
INSERT INTO nsu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iva tla moyekma kichiva xivetzi itech tlajtlakoli, xiktzonteki iva wejka xiktlamotla. Okachi kuali xikpolo se parte de mokuerpo, iva amo nochi mokuerpo ma kontlamotlakah miktla. ");
INSERT INTO nsu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Noijki yinkimatih tlen yi wejkavitl omijto: “Tlen kikajkavas itonana, kipia de kimakas se amatl kan ma kijto nik kikajkava itonana.” ");
INSERT INTO nsu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero Ne nimechilvia, tla se tlakatl kikajkava itonana, maski itonana amo kema kimomekatia íkka, yejón tlakatl kijtosneki kimaka lugar itonana para ma momekati. Iva tla íkka monamiktis ivan yejón sivatl, kijtosneki kichiva imosa. ");
INSERT INTO nsu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Noijki yinkimatih tlen yi wejkavitl inmokojkolvah okinmachtijkeh: “Tla itla tikijtova tikchivas iva asta tiktemaka motlajtol, moneki xikchiva.” ");
INSERT INTO nsu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero ne nimechilvia: Amo kema xiktemakakah imotlajtol, nion por yen ilvikak, porke in ilvikak yen itekivajsiya in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nion amo xiktemakakah imotlajtol por yen tlaltikpaktli, porke Dios ompa kinsevijtok ikxivah. Nion amo xiktemakakah imotlajtol por yen siudad de Jerusalén, porke yejón siudad iaxka in Dios tlen towei tlanavati. ");
INSERT INTO nsu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nion amo xiktemakakah imotlajtol por yen imotzonteko, porke amo velis inkichivaskeh ma istaya o noso ma tlilevi se imotzonkal. ");
INSERT INTO nsu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tla inkijtoskeh kema, xikijtokah “kema”, tla inkijtoskeh amo, xikijtokah “amo”. Tla inkajxitiliskeh itla okseki tlajtoli, yen yejón tlen kineki in Amo Kuali Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Imejvah yinkimatih tlen yi wejkavitl omijto: “Tla íkka teixtzopitia, ma kixtzopitikah ye noijki. Tla íkka tetlantepeva, ma kitlantepevakah ye noijki.” ");
INSERT INTO nsu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero Ne nimechilvia: Tla íkka imechtoktia itla amo kuali, amo ivan ximokitzkikah. Okachi kuali, tla íkka mitzixtlatzinia ik moixyekmapa, xikavili noijki ma mitzixtlatzini ik moixopochmapa. ");
INSERT INTO nsu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tla íkka mitzteilvia iva kineki mitzkixtilis mokamisa, te xikmaka noijki mochamarra. ");
INSERT INTO nsu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iva tla íkka mitznavatia xitlamama se kilómetro, te xitlamama ome kilómetro. ");
INSERT INTO nsu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tla íkka mitztlajtlanilis itla tlamantli, xikmaka. Iva tla íkka mitztlanevilis itla tlamantli, xiktlaneti. ");
INSERT INTO nsu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Noijki yinkimatih tlen yi wejkavitl omijto: “Xikintlasojtla moknivah, iva xikinkualankaita tlen mitztlavelitah.” ");
INSERT INTO nsu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero Ne nimechilvia: Xikintlasojtlakah tlen imechkualankaitah, xikilvikah in Dios ma kintiochiva tlen fiero imechilviah, xikinpalevikah tlen imechkualankaitah, iva ximodiostzajtzilikah por tlen imechwikaltiah iva imechochololtiah. ");
INSERT INTO nsu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ijkó imejvah inyeskeh intepilvah de imoTajtzi Dios tlen kajki ilvikak, porke Ye kichiva ma kisa in tonali para in gentejtih tlen kualmeh iva tlen amo kualmeh. Iva kichiva ma kiavi para tlen tlakamelajkeh iva para tlen amo tlakamelajkeh. ");
INSERT INTO nsu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porke tla imejvah inkintlasojtlah san yejvah tlen imechtlasojtlah, ¿tlán tlaxtlavili inkiseliskeh por yejón? Asta in kobradortih de impuestos no ijkó kichivah. ");
INSERT INTO nsu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iva tla san yejvah imoyoliknivah inkinyeknotzah, ¿inkichivah itla tlen oksekimeh amo velih kichivah? Asta tlen amo judiojtih noijki ijkó kichivah. ");
INSERT INTO nsu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imejvah xiekah inyektikeh, ijkó kemi imoTajtzi Dios tlen kajki ilvikak Ye yektik. ");
INSERT INTO nsu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Amo xikchivakah tlen kuali san para oksekimeh ma imechitakah tlen inkichivah. Tla ijkó inkichivaskeh, imoTajtzin Dios tlen kajki ilvikak amitla tlaxtlavili imechmakas. ");
INSERT INTO nsu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Por eso, ijkuak itla inkitliokoliah se tlen amitla kipia, amo xiktematiltikah itech tiotlamachtijkaltih ivan itech ojtli para ma kimatikah, kemi kichivah tlen kipiah ome inmixko, yejvah ijkó kichivah porke kinekih kuali ma tlajtokah de yejvah. Pero yi neli nimechilvia, ke ijkuak kuali tlajtoskeh de yejvah, san yen yejón yetos intlaxtlavil. ");
INSERT INTO nsu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero te ijkuak itla tiktliokolis se tlen amitla kipia, amo ma kimati moopochma tlen kichiva moyekma. ");
INSERT INTO nsu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tla itla tiktemakas, xiktemaka san ichtaka. Iva ijkó moTajtzin Dios tlen kitta nochi tlen tikchiva ichtaka, mitzmakas motlaxtlavil teixpa. ");
INSERT INTO nsu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ijkuak imejvah inmodiostzajtziliskeh, amo xikchivakah kemi kichivah tlen kipiah ome inmixko, porke yejvah kivelitah modiostzajtziliskeh mokejketoskeh kan tiotlamachtijkaltih iva kan eskinajtih san para ma kinmitakah. Yi neli nimechilvia ke ijkuak kinmitaskeh iva kuali tlajtoskeh de yejvah, san yen yejón yetos intlaxtlavil. ");
INSERT INTO nsu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero te ijkuak timodiostzajtzilis, xikalaki mokalijtik, ximokaltzakua iva ompa moselti ximodiostzajtzili inavak Dios. Iva ijkó moTajtzin Dios mitzmakas motlaxtlavil porke Ye kitta nochi tlen se kichiva ichtaka. ");
INSERT INTO nsu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Iva ijkuak inmodiostzajtziliskeh amo san ompa xikuakuaptokah imotlajtol kemi kichivah tlen amo judiojtih, porke yejvah kiyejyekovah tla san ompa kikuaptoskeh intlajtol, Dios okachi kinkakis. ");
INSERT INTO nsu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Imejvah amo xikchivakah kemi yejvah kichivah, porke imoTajtzin Dios yi kimati tlán imechpolova antes de inkitlajtlaniliskeh. ");
INSERT INTO nsu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Por eso, imejvah moneki ijkí ximodiostzajtzilikah: ToTajtzin Dios, tejwatzi tlen tika ilvikak, nochipa ma kitlakitakah motokatzi. ");
INSERT INTO nsu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Xivalmuika xitlanavatiki. Ma mochiva tlen tejwatzi tikmonekiltia itech nin tlaltikpaktli, ijkó kemi mochiva kan ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Techmaka axka totlakual tlen nochipa moneki. ");
INSERT INTO nsu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Techtlapojpolvi de nochi tlen tikchivah tlen amo kuali, ijkó kemi tejvah noijki tikintlapojpolviah tlen techtoktiah tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amo techtekavili ma tivetzikah ijkuak techyoltilana tlen amo kuali, sino techpalevi para amo ma tivetzikah imak in Amo Kuali Tlakatl. Porke moaxka nochi tlen tiknavatia, nochi in velitilistli iva nochi in mavistilistli, para semijkak. Ijkó ma yeto. ");
INSERT INTO nsu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Porke tla imejvah inkintlapojpolviskeh tlen imechtoktiah tlen amo kuali, imoTajtzi Dios tlen kajki ilvikak noijki imechtlapojpolvis. ");
INSERT INTO nsu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero tla amo inkintlapojpolviskeh, imoTajtzi Dios noijki amo imechtlapojpolvis. ");
INSERT INTO nsu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ijkuak imejvah inmosavaskeh, amo xiiknotlachiakah kemi kichivah tlen kipiah ome inmixko, porke yejvah ijkó kichivah san para ma kinmitakah ke yejvah mosavah miek. Pero yi neli nimechilvia ke ijkuak kinmitaskeh iva kuali tlajtoskeh de yejvah, san yen yejón yetos intlaxtlavil. ");
INSERT INTO nsu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Por eso, te ijkuak timosavas, ximixami iva ximoxilvi, ");
INSERT INTO nsu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para amika ma kimati kox timosavtok. San yen moTajtzi Dios kimatis tlán tikchiva. Iva ijkó moTajtzi Dios mitzmakas motlaxtlavil porke Ye kitta nochi tlen se kichiva ichtaka. ");
INSERT INTO nsu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Amo xikololokah tlen kipia miek ipati itech nin tlaltikpaktli, kan tlakuakualo iva tlapoxkavi, iva kan ichtekeh kalakih iva tlachtekih. ");
INSERT INTO nsu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Okachi kuali xikololokah tlen kipia miek ipati itech ilvikak, kan amo velis tlakuakualos iva amo velis tlapoxkavis, iva nion se ichtekki amo velis kalakis tlachtekis. ");
INSERT INTO nsu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kan yetos tlen imejvah inkittah kipia miek ipati, ompa yetos noijki inmoyolo. ");
INSERT INTO nsu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Itlanex imokuerpo yen imoixtololovah. Tla tikinmita oksekimeh iva tikneki tikinpalevis, nochi mokuerpo tentos ika tlanextli. ");
INSERT INTO nsu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero tla tikinnexikolita, kijtosneki nochi mokuerpo kajki kan tlayovalotl. Iva tla en lugar de tlanextli tikpia yej tlayovalotl, ¡yejón tlayovalotl yi neli tlilmiktik! ");
INSERT INTO nsu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Amika tlakatl velis kinpias ome itekovah, porke kitlasojtlas in se ivan oksé amo kitlasojtlas, o noso kitlakitas in se ivan oksé amo kitlakitas. Imejvah noijki, amo velis intekipanoskeh para Dios iva intekipanoskeh para inkololoskeh tominkayotl. ");
INSERT INTO nsu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Por eso nimechilvia, amo ximotekipachokah por tlán inkikuaskeh, tlán inkoniskeh o tlán inkonakiskeh. ¿Amo inkimatih ke okachi miek ipati tonemilis ke tlen tikuah? ¿Iva amo okachi miek ipati tokuerpo ke tlen tikonakiah? ");
INSERT INTO nsu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xikimitakah in totomeh tlen patlanih, yejvah amo tookah, amo pixkah, iva nion amitla kitlaatiah ijtik sinkali. Pero imoTajtzi Dios tlen kajki ilvikak yen kintlamaka. Iva imejvah okachi miek inmopati iva amo kemi totomeh. ");
INSERT INTO nsu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tla íkka de imejvah motekipachova porke kineki moskaltis ok tlajko metro, ¿kox velis moskaltis? ");
INSERT INTO nsu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Iva tleka imejvah inmotekipachovah por inmotzotzol? Xikinmitakah kenik moskaltiah in xochimeh, yejvah amo tekipanovah iva nion amo kimochijchiviliah intzotzol. ");
INSERT INTO nsu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero Ne nimechilvia, ke nion wei tlanavati Salomón tlen okatka sa tlawel tomine amo keman omotlakenti kualtzi kemi se de yejonmeh xochimeh. ");
INSERT INTO nsu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iva tla Dios ijkó kitzotzoltia in xivitl tlen axka kajki tlala iva mostla viptla kichichinoskeh ijtik tlitl, ¿kenomi in Dios amo ma imechpalevi imejvah? ¡Seppa tzikitzi imotlaneltokalis! ");
INSERT INTO nsu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por eso, amo ximotekipachokah iva amo xikijtokah: “¿Tlán tikuaskeh? o ¿tlán tikoniskeh? o ¿tlán tikonakiskeh?” ");
INSERT INTO nsu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nochi nin tlamantli ika motekipachovah tlen amo judiojtih. Pero imoTajtzi Dios tlen kajki ilvikak yi kimati tlán imechpolova. ");
INSERT INTO nsu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Okachi kuali xikyekixmatikah imoDios kemi san Ye tlanavati iva xikchivakah tlen kuali kemi Ye kineki, iva ijkó Dios imechmakas nochi tlen imechpolova. ");
INSERT INTO nsu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ijkó pues, amo ximotekipachokah por tlen panolos mostla, porke mostla velis oksé welta inmotekipachoskeh. Kada tonali ipa yi kipia tlan ika se motekipachos. ");
INSERT INTO nsu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Amo xitlapovakah de oksekimeh, iva ijkó Dios amo tlapovas de imejvah. ");
INSERT INTO nsu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porke ijkó kemi imejvah intlapovaskeh de oksekimeh, noijki ijkó tlapovaskeh de imejvah, iva ijkó kemi imejvah inkintamachivaskeh tlen oksekimeh, imejvah noijki ijkó imechtamachivaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Tleka tikitta mokni por yen tzikitzi itlajtlakol ivan te amo timotta ke tikpia okachi wei motlajtlakol? Yejón kemi oyeskia tikitta mokni kipia se tlajsoltzintli itech ixtololo, ivan te amo timotta ke tikpia asta se wei kuavitl itech moixtololo. ");
INSERT INTO nsu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿O noso kenik veli tikilvia mokni: “Ma nimitzkixtili in tlajsoltzintli de itech moixtololo”, iva te asta tikpia se wei kuavitl itech moixtololo? ");
INSERT INTO nsu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Tikpia ome moixko! Achto te xikmokixtili in wei kuavitl tlen tikpia itech moixtololo, para ijkó velis titlachias iva velis tikixtilis in tlajsoltzintli tlen kipia mokni. ");
INSERT INTO nsu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Tlen chipavak de Dios amo xikinmakakah tlen kipiah amo kuali inyolo, porke velis inmopah mokopaskeh kemi itzkuintih iva velis imechkuaskeh. Iva tlen kipia miek ipati kemi oyeskia perlas, amo xikinmakakah tlen kichivah kemi kochijtih, porke san ipan mokejketzaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xiktlajtlanilikah in Dios tlen imechpolova iva Ye imechmakas. Xiktemokah iva inkajsiskeh. Xitenotzakah kan puerta iva Dios imechtlatlapolis. ");
INSERT INTO nsu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porke akin itla kitlajtlani, kiselia. Iva akin itla kitemova, kajsi. Iva akin tenotza kan puerta, kitlatlapoliah. ");
INSERT INTO nsu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Kox velis tikmakas mokone se tetl ijkuak mitztlajtlanilis se pan? ");
INSERT INTO nsu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O noso velis tikmakas se kovatl ijkuak mitztlajtlanilis se michi? ");
INSERT INTO nsu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iva tla imejvah fiero inmoyelis, veli inkinmakah imopilvah tlen kuali, ¡imoTajtzi tlen kajki ilvikak kenik amo ma kinmaka tlen kuali nochtin tlen akinmeh kitlajtlaniliskeh! ");
INSERT INTO nsu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Xikchivakah invan oksekimeh ijkó kemi imejvah inkinekih ma kichivakah imovah. Porke itlanavatil Moisés iva nochi tlen okijkuilojkeh in tiotenejmachtijkeh, yen yejón tlen kijtovah xikchivakah. ");
INSERT INTO nsu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Xikalakikah kan puerta tlen pitzavak. Porke patlavak in puerta iva patlavak in ojtli tlen tevika para miktla, iva miekeh kalakih ik ompa. ");
INSERT INTO nsu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero pitzavak in puerta, iva pitzavak in ojtli tlen tevika itech nemilistli, iva amo miekeh kajsih yejón ojtli. ");
INSERT INTO nsu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Xikpiakah kuidado de nekateh tiotenejmachtijkeh tekajkayajkeh. Mottah mansojtih kemi ichkameh pero kichivah kemi koyomeh tekuanimeh. ");
INSERT INTO nsu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imejvah velis inkinmixmatiskeh por yen tlen kichivah. Porke amika kiteki uvas de kan vitztli, iva nion amika kiteki igos itech se xivitl vitzo. ");
INSERT INTO nsu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ijkó pues, nochi kuavitl tlen kuali, kitemaka kuali tlakilotl. Iva nochi kuavitl tlen amo kuali, itlakilo noijki amo kuali. ");
INSERT INTO nsu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Se kuavitl tlen kuali amo velis kitemakas sen tlakilotl tlen amo kuali, iva se kuavitl tlen amo kuali amo velis kitemakas sen kuali tlakilotl. ");
INSERT INTO nsu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nochi kuavitl tlen kitemaka amo kuali tlakilotl, se kitzonteki iva se kitlamotla ijtik tlitl. ");
INSERT INTO nsu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Por eso, imejvah velis inkinmixmatiskeh in tiotenejmachtijkeh tekajkayajkeh por yen tlen kichivah. ");
INSERT INTO nsu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Amo nochtin tlen nechilviah: “NoTeko, noTeko”, kalakiskeh kan Dios tlanavatia, sino san yejvah tlen kichivah tlen kimonekiltia noTajtzi tlen kajki ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Itech neká tonali, miekeh nechilviskeh: “ToTeko, toTeko, tejvah otitetlapovijkeh ika motoka iva ika motoka otikinkixtijkeh amo kuali ejekameh, noijki ika motoka otikinchijkeh miekeh tetzavimeh.” ");
INSERT INTO nsu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero ijkuakó Ne nikinmilvis: “Mach semi onimechixmatki. Ximachivakah de Ne, porke imejvah inkichivah tlen amo kuali.” ");
INSERT INTO nsu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ijkó pues, tlen kikaki iva kichiva tlen nikijtova, yejón kemi se tlakatl tlen kipia kuali itlayejyekolis iva okichi ikal ipan tetl. ");
INSERT INTO nsu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ovala chikavak kiavitl, ovala miek atepeatl, chikavak oejekak iva itech omotlavitekiko in kali, pero amo ovetzki porke kajki ipan tetl. ");
INSERT INTO nsu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero tlen nechkaki iva amo kichiva tlen nikijtova, yejón kemi se tlakatl tlen amo tlayejyekole iva okichi ikal ipan xali. ");
INSERT INTO nsu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ovala chikavak kiavitl, ovala miek atepeatl, chikavak oejekak iva itech omotlavitekiko in kali, iva in kali ovetzito iva nochi oxixinki. ");
INSERT INTO nsu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ijkuak Jesús otlanki okintlapovi, nochtin gentejtih sa otlatlachixkeh por kenik okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porke ijkuak okintlapoviaya, okichivaya ika tlanavatijkayotl, iva amo kemi in tlamachtijkeh de itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ijkuak Jesús otemok de kan tepetl, miekeh gentejtih okitokakeh. ");
INSERT INTO nsu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ijkuakó se tlakatl tlen opalania inakayo omotoki inavak, omotlankuaketzki iva okilvi: —NoTeko, tla tikmonekiltis, techpajti de nin kokolistli para ma nichipavi. ");
INSERT INTO nsu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús okitlali ima ipan yejón kokoxki iva okilvi: —Kema. Nikneki xipajti iva xichipavi. Ijkuak ijkó okijto, in kokolistli san nima okiski de itech yejón tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iva Jesús okilvi: —Amika xiktlapovi de nin tlamantli. Xivia inavak in tiopixki para ma mitzita nik yotipajtik, iva xiktemaka motlamanal ijkó kemi kijtova itlanavatil Moisés, para ijkó nochtin ma kimatikah nik yotichipavik de mokokolis. ");
INSERT INTO nsu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ijkuak Jesús okalakito kan altepetl Capernaum, ijkuakó se kapita romano omotoki inavak Jesús iva okitlatlavti, ");
INSERT INTO nsu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","okilvi: —NoTeko, se notlakeval kajki nokalijtik mokokova, ayakmo veli meva iva chikavak kualo. ");
INSERT INTO nsu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús okinankili: —Nias nikpajtiti. ");
INSERT INTO nsu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","In kapita okinankili: —NoTeko, amo notech povi para xikalaki nokalijtik. Iva mach moneki xivia asta ompa, san nika xikijto ma pajti iva notlakeval pajtis. ");
INSERT INTO nsu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porke ne nikinvelkaki notlayakankavah, iva noijki nosoldadojvah yejvah nechvelkakih. Tla se de yejvah nikilvis: “Nepa xonyati”, in ye yavi. Iva tla oksé de yejvah nikilvis: “Xiviki”, in ye vitz. Iva tla nikilvis notlakeval: “Xikchiva nin tekitl”, in ye kichiva. ");
INSERT INTO nsu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ijkuak Jesús ijkó okikakki, sa otlatlachixki iva okinmilvi tlen okitokayah: —Yi neli nimechilvia, ke amo kema nikajsi nion se tlakatl de Israel, tlen ma kipia wei itlaneltokalis kemi nin tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iva nikneki nimechilvis ke miekeh vitzeh de ik kan valkisa tonali iva de ik kan onpolivi tonali, iva motlaliskeh tlakuaskeh ivan Abraham, ivan Isaac ivan Jacob ijkuak Dios tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero miekeh gentejtih de Israel tlen Dios okinekiah ma kalakikah kan Ye tlanavatia, kinkixtiskeh iva kinkavaskeh kan tlayova, iva ompa chokaskeh iva motlantekiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ijkuakó Jesús okilvi in kapita: —Ximokuapa mokalijtik, iva ma mochiva ijkó kemi tikneltoka. Iva san nima ijkuakó opajtik itlakeval in kapita. ");
INSERT INTO nsu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús oyá ichan Pedro, iva ompa okajsito imonna in Pedro vetok ipan kochtlapechtli iva okipiaya miek totonik. ");
INSERT INTO nsu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús okimakitzki, iva in totonik okiski. Imonna in Pedro san nima omejki iva ope kintlamaka. ");
INSERT INTO nsu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ijkuak otlayovak, okinvalikilijkeh in Jesús miekeh tlen okinpiayah amo kuali ejekameh. Iva okinkixti yejonmeh amo kuali ejekameh san ika se tlajtoli, iva okinpajti nochtin tlen omokokovayah. ");
INSERT INTO nsu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ijkó opanolok para ma mochiva tlen okijto in tiotenejmachti Isaías, ijkuak okijto: “Ye otechpajti de nochi tokokolis iva de nochi tokualolis.” ");
INSERT INTO nsu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ijkuak Jesús okinmitak miekeh gentejtih ope kiyavalovah, ijkuakó okinnavati in momachtijkeh ma panokah ik nepa lado de kan atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Se tlamachti de itlanavatil Moisés omotoki inavak Jesús iva okilvi: —Tlamachti, nikneki nias mova san kan tias. ");
INSERT INTO nsu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús okinankili: —In astomeh kipiah inchah kan tlakuyo ivan totomeh kipiah intepajsol. Pero iKone in Tlakatl amo kipia kan mosevis. ");
INSERT INTO nsu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iva se momachti okilvi: —NoTeko, techkavili achto ma niktookati nopapa. ");
INSERT INTO nsu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero Jesús okilvi: —Xikinkavili in gentejtih tlen kateh kemi miktokeh yejvah ma kintookakah inmikavah, te xiviki nova. ");
INSERT INTO nsu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús otlejkok itech se barko, iva in momachtijkeh oyajkeh Iva. ");
INSERT INTO nsu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","San nima ovala se ejekatl chikavak iva in atl ope motlatlaviteki itech barko iva ope atemi. Pero Jesús okochtoka. ");
INSERT INTO nsu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ijkuakó in momachtijkeh okijxititoh, iva okilvijkeh: —¡ToTeko, techmakixti! ¡Tapoolakih! ");
INSERT INTO nsu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ye okinmilvi: —¿Tleka inmomavtiah? ¡Seppa tzikitzi imotlaneltokalis! Jesús omoketzki iva okitlakavalti in ejekatl ivan atl tlen wei, iva satepa omoka sa tlamantok. ");
INSERT INTO nsu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tlen momachtijkeh sa otlatlachixkeh iva okimolviayah: —¿Akin nin tlakatl, porke asta in ejekatl ivan atl tlen wei kivelkakih? ");
INSERT INTO nsu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ijkuak Jesús oajsito ik nepa lado de kan atl tlen wei, itech tlalmeh de altepetl Gadara, ijkuakó omotokijkeh inavak Jesús omen tlakah tlen okinpiayah amo kuali ejekameh, ovalkiskeh de kan mikatekochtih. Okatkah sa tlawel temajmavtijkeh iva amika ovelia opanovaya itech yejón ojtli. ");
INSERT INTO nsu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iva ope tzajtzih chikavak: —¿Tlán tikneki tovah Jesús iKone in Dios? ¿Otivala otechtlajyoviltiko maski ayamo ajsi ora? ");
INSERT INTO nsu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iva amo wejka de ompa, otlakuajtokah miekeh kochijtih. ");
INSERT INTO nsu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iva in amo kuali ejekameh okitlatlavtijkeh in Jesús, okilvijkeh: —Tla techkixtis de inmijtik ninmeh tlakah, tonses techkavili ma tikalakikah inmijtik nekateh kochijtih. ");
INSERT INTO nsu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ijkuakó Jesús okinmilvi: —Xiviah pues. In amo kuali ejekameh okiskeh de inmijtik in tlakah iva okalakeh inmijtik in kochijtih. Iva san nima ijkuakó nochtin kochijtih okikistevakeh omotlelojkeh iva omotepejxivitoh kan atl tlen wei, nochtin omatlanvijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","In tlajpixkeh de kochijtih omotlelojkeh oyajkeh kan altepetl. Ompa ope tetlapoviah de nochi tlen otlamochivalok, iva de nekateh omen tlakah tlen okinpiayah amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ijkuakó nochtin gentejtih de Gadara okittatoh in Jesús, iva ijkuak okittakeh, okitlatlavtijkeh ma via de ompa de itech yejonmeh tlalmeh. ");
INSERT INTO nsu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús otlejkok itech se barko, opanok oksé lado de kan atl tlen wei, iva oajsito Capernaum tlen okatka ialtepe. ");
INSERT INTO nsu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ompa oajsikoh sekimeh tlakah inavak Jesús okivalikiliayah se tlakatl vilantzi ika ikochpetl. Ijkuak Jesús okittak ke yejonmeh tlakah yi neli okineltokayah, ijkuakó okilvi in kokoxki: —Ximoyolchikava nokone, nimitztlapojpolvia de nochi motlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ijkuakó sekimeh tlamachtijkeh de itlanavatil Moisés okijtojkeh itech inyolo: “Nin tlakatl kixpanavia in Dios.” ");
INSERT INTO nsu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús okimatia tlen yejvah okiyejyekovayah, iva okinmilvi: —¿Tleka imejvah ijkó inkiyejyekovah? ");
INSERT INTO nsu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Katli yen okachi amo ovi nikilvis nin vilantzi: “Nimitztlapojpolvia de nochi motlajtlakol”, o noso nikilvis: “Ximeva. Xikajkuana mokochpetl iva xinejnemi”? ");
INSERT INTO nsu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero Ne nimechititis ke iKone in Tlakatl, kipia velitilistli itech nin tlaltikpaktli, iva veli tetlapojpolvia de nochi tlajtlakoli. Ijkuakó okilvi in vilantzi: —Ximeva, xikajkuana mokochpetl iva xivia mokalijtik. ");
INSERT INTO nsu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ijkuakó ye omejki iva oyá para ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","In gentejtih ijkuak ijkó okittakeh, omotetzavijkeh iva ope kiweijkachivah in Dios porke ivelitilis okinmakak in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ijkuak Jesús okiski de Capernaum, okittak se tlakatl itoka Mateo oyetoka kan tlakobrarovah de impuestos, iva Jesús okilvi: —Xiviki nova. Mateo omoketzki, iva oyá ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Se tonali, Jesús otlakuajtoka ikalijtik in Mateo, iva noijki ompa oyajkeh otlakuatoh miekeh kobradortih de impuestos iva miekeh tlajtlakolejkeh. Nochtin otlakuajkeh san sekka ivan Jesús ivan tlen momachtijkeh de Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ijkuak in fariseos okittakeh nik in Jesús otlakuajtoka invah, ijkuakó ope kintlajtlaniah tlen okinmachtiaya: —¿Tleka imotlamachti tlakua ivan kobradortih de impuestos iva noijki tlakua ivan tlajtlakolejkeh? ");
INSERT INTO nsu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús okinkakki iva okinmilvi: —Tlen amo mokokovah amo yavih kitativih se tepajti, sino tlen mokokovah. ");
INSERT INTO nsu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xiviah iva kuali xikmomachtikah tlán kijtosneki in Tiotlajkuiloli kan kijtova: “Ne nikneki xiteiknomatikah iva amo nikneki techinmiktilikah yolkameh kemi se tlamanali para Ne.” Porke Ne amo onivala para nikinnotzas tlen tlakamelajkeh, sino tlen tlajtlakolejkeh para ma moyolkopakah. ");
INSERT INTO nsu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ijkuakó tlen momachtijkeh de Juan tlen tlabautisaro omotokijkeh inavak Jesús iva okitlajtlanijkeh: —¿Tleka tejvah ivan fariseos timosavah miek welta iva tlen tejwatzi tikinmachtia amo mosavah? ");
INSERT INTO nsu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús okinmilvi: —Tlen kinminvitarovah kan monamiktiah amika moyolkokova mientras in novio ompa invah kajki. Pero ajsis tonali ijkuak in novio kivikaskeh, iva ijkuakó velis mosavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Amika kitlamania se tzotzoli tlen yi tlajtlantok ika se retaso de tela yankuik. Porke in tela yankuik kototzivi iva kitzomonia in tzotzoli tlen yi tlajtlantok, iva okachi tzomoni. ");
INSERT INTO nsu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nion amika kitlalia yankuik vino ika kulambre tlen yi tlajtlantok. Porke tlamo, in yankuik vino kitzomonis in kulambre tlen yi tlajtlantok, iva in vino ivan kulambre parejo ijtlakavih. Por eso, in yankuik vino moneki motlalis ika kulambre yankuik para ijkó nochtin omeh wejkavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ijkuak Jesús ok ijkó okinmilvijtoka, ijkuakó ovala se tlayakanki de kan tiotlamachtijkali, omotlankuaketzki iyakapan Jesús, iva okilvi: —Notakotzi yikin tlamitzi oixpolivik, pero tla tejwatzi tivalmuikas nokalijtik iva tiktlalis moma ipa, moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús omoketzki, iva oyá ivan yejón tlakatl ivan momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ijkuakó se sivatl tlen yokipiaya majtlaktli ivan ome xivitl de omotlapalojviti, omotoki inavak Jesús ik ikuitlapa iva okonkitzkili san itenpantzi itlaken tlen kimokentia. ");
INSERT INTO nsu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Porke in sivatl okiyejyekovaya: “Tla sikiera onikitzkiliskia itlaken, velis nipajtis.” ");
INSERT INTO nsu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús omokuapki, okittak in sivatl iva okilvi: —Ximoyolchikava nokone, yotipajtik de mokokolis porke otechneltokak. Iva san niman ijkuakó opajtik in sivatl. ");
INSERT INTO nsu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ijkuak Jesús oajsito kan ikalijtik in tlayakanki, okinmitak in tlapitzkeh yokatkah listos para kitookativih in takotzi, iva miekeh tlen ompa okatkah ochokayah iva otzajtziah chikavak. ");
INSERT INTO nsu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ijkuakó Jesús okinmilvi: —Xikisakah, porke nin takotzi ayamo ixpolivi, ye kochi. Yejvah san okivetzkilijkeh in Jesús, ");
INSERT INTO nsu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","pero ijkuak okinkixtijkeh nochtin, ijkuakó Jesús okalakki iva okimakitzki in takotzi, iva in takotzi omejki. ");
INSERT INTO nsu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iva itech nochi yejón región okimatkeh tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ijkuak Jesús okiski de ompa, ome tlakah tlen amo otlachiayah oyayah ikuitlapa kitzajtzilijtivih chikavak: —¡IKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ijkuak Jesús okalakki kalijtik, yejonmeh tlakah tlen amo otlachiayah omotokijkeh inavak, iva Jesús okintlajtlani: —¿Inkineltokah imejvah ke velis nimechpajtis? Yejvah okilvijkeh: —Kema, toTeko, tikneltokah. ");
INSERT INTO nsu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ijkuakó Jesús okintilkoli inmixtololovah iva okinmilvi: —Ma mochiva ijkó kemi imejvah inkineltokah. ");
INSERT INTO nsu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iva san nima ijkuakó ovelikeh otlachixkeh. Iva Jesús kuali okinnajnavati: —Amika itla xiktlapovikah. ");
INSERT INTO nsu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iva yejvah oyajkeh iva nima ope tetlapoviah itech nochi yejón región de tlen Jesús okichi por yejvah. ");
INSERT INTO nsu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ijkuak yoyajkeh nekateh tlakah tlen amo otlachiayah, ijkuakó okivikilijkeh in Jesús se tlakatl noontzi tlen okipiaya se amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ijkuak Jesús okikixti in amo kuali ejekatl, in noontzi ope tlajtova. In gentejtih sa otlatlachixkeh iva okijtovayah: —Amo kema otikittayah se tlamantli kemi nin itech nin país de Israel. ");
INSERT INTO nsu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero in fariseos okijtovayah: —Nin tlakatl kinkixtia amo kuali ejekameh porke in tlayakanki de tlen amo kuali ejekameh kimaka ivelitilis para ijkó ma kichiva. ");
INSERT INTO nsu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús onemia itech nochtin siudades iva altepemeh, iva otlamachtiaya kan tiotlamachtijkaltih de kada lugar. Otetlapoviaya de tlen yankuik kuali tlajtoli nik in Dios niman pevas tlanavatis, iva okinpajtiaya de nochi kokolistli iva de nochi kualolistli. ");
INSERT INTO nsu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ijkuak Jesús okinmitak in gentejtih, okimiknomatki porke amo okimatiah tlán kichivaskeh iva amo okipiayah akin kinpalevis, okatkah kemi ichkameh tlen amo kipiah tlajpixki. ");
INSERT INTO nsu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ijkuakó okinmilvi in momachtijkeh: —In pixkalistli sa tlawel wei, pero amo onkateh miekeh tekipanojkeh para pixkaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Xiktlatlavtikah pues in Tekova ma kintitlani oksekimeh tekipanojkeh para ma pixkakah. ");
INSERT INTO nsu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús okinnotzki majtlaktli ivan ome tlen okinmachtiaya iva kada se okimakak velitilistli para ma kinkixtikah amo kuali ejekameh iva para ma kinpajtikah in gentejtih de nochi kokolistli iva de nochi kualolistli. ");
INSERT INTO nsu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yen nin intoka in majtlaktli ivan ome tlatitlaniltih de Jesús tlen okinpejpenki. Achto okipejpenki Simón, tlen noijki kinotzah Pedro, ivan ikni tlen itoka Andrés, Jacobo ivan ikni Juan, tlen itelpochvah in Zebedeo, ");
INSERT INTO nsu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo tlen okatka kobrador de impuestos, Jacobo ipiltzi in Alfeo, Lebeo tlen noijki kinotzah Tadeo, ");
INSERT INTO nsu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón tlen opovia invan kananistas, iva Judas Iscariote tlen satepa okitemakti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús okintitlanki ninmeh majtlaktli ivan ome, iva ijkí okinnajnavati: —Amo xiviah kan kateh tlen amo judiojtih, nion amo xikalakikah itech altepemeh de Samaria, ");
INSERT INTO nsu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","sino xiviah kan kateh in gentejtih de Israel tlen mopolojtinemih kemi ichkameh. ");
INSERT INTO nsu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xiviah, iva xikinmatiltikah nik yoajsik tonali para Dios pevas tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xikinpajtikah in kokoxkeh, xikinpajtikah tlen palani innakayo, xikinyolitikah in mikameh iva xikinkixtikah amo kuali ejekameh. Imejvah Dios omechmakak ivelitilis, tonses amo xitlakobrarokah por tlen inkichivah ika ivelitilis. ");
INSERT INTO nsu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Amo xikvikakah itla tomi, ");
INSERT INTO nsu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nion amo xikvikakah imoaya. Amo xikvikakah ome imotzotzol o noso oksé par de imokakvah, nion amo xikvikakah itla karroti. Porke se tekipano kipia de kitlamakaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ijkuak inmajsitivih itech se siudad o noso itech se altepetl, xiktemokah se tlen kuali tlakatl iva ompa ximokavakah ikalijtik asta ijkuak inkisaskeh de yejón lugar. ");
INSERT INTO nsu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Iva ijkuak inkalakiskeh tekalijtik, xitetlajpalokah xikinmilvikah: “Xonyekah ika kuali.” ");
INSERT INTO nsu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tla in chanejkeh kuali imechseliah, Dios kintiochivas para ma yekah ika kuali. Pero tla amo imechseliah, Dios amo kintiochivas, iva in tlatiochivalistli mokavas imovah. ");
INSERT INTO nsu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iva tla itech se kali o noso itech se altepetl amo imechseliah iva nion amo kinekih imechkakiskeh, xikisakah de ompa iva xikintzejtzelokah imokxivah. ");
INSERT INTO nsu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yi neli nimechilvia, ke itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, intlajyovilis yejonmeh gentejtih yetos okachi temavti ke intlajyovilis in gentejtih de Sodoma iva de Gomorra. ");
INSERT INTO nsu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Techkakikah! Ne nimechtitlani kemi inmichkameh kan kateh koyomeh. Ijkó pues, xiekah inlistojtih kemi kovameh iva noijki xiekah kemi palomaxtih tlen amitla kitetoktiah. ");
INSERT INTO nsu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xikpiakah kuidado, porke in gentejtih imechtemaktiskeh itech injunta in judiojtih iva imechwitekiskeh itech tiotlamachtijkaltih. ");
INSERT INTO nsu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iva asta imechtemaktiskeh innavak kobernadortih iva innavak in wejwei tlanavatijkeh por innechneltokah. Ijkuakó imejvah moneki intlajtoskeh de notlajtol inmixpa yejonmeh tekivajkeh, iva inmixpa tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero ijkuak imechtemaktiskeh innavak tekivajkeh, amo ximotekipachokah de tlán inkijtoskeh o noso de kenomi inkijtoskeh. Porke itech yejón ora Dios imechmakas tlajtoli tlen monekis inkijtoskeh. ");
INSERT INTO nsu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porke amo imejvah intlajtoskeh, sino yen iTioijyotzi imoTajtzin Dios tlen tlajtos por imejvah. ");
INSERT INTO nsu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’In teikni kitemaktis ikni ma kimiktikah. In teta kitemaktis ipiltzi ma kimiktikah. In tepilvah yaskeh en kontra de intajvah iva kinmiktiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochtin imechkualankaitaskeh por innechneltokah, pero tlen kixikos nochi in tlajyovilistli, Dios kimakixtis. ");
INSERT INTO nsu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ijkuak imechochololtiskeh itech se altepetl, xicholokah iva xiviah itech oksé altepetl. Yi neli nimechilvia, ke iKone in Tlakatl vitz oksemi antes de tlamis inkinnemiliskeh nochtin altepemeh de Israel. ");
INSERT INTO nsu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Se tlen momachtia mach velis okachi weititos ke itlamachti, iva se tlen san tlapalevia mach velis okachi weititos ke iteko. ");
INSERT INTO nsu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Se tlen momachtia ma paki tla motlamiti kemi itlamachti, iva se tlen san tlapalevia ma paki tla se tonali yetos kemi iteko. Iva tla Ne, tlen nika kemi niteta itech se familia iva mixeviah nechilviah niBeelzebú, ¿tlán amo velis imechilviskeh imejvah tlen intekipanovah nonavak? ");
INSERT INTO nsu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Por eso, amo xikinmavilikah yejonmeh gentejtih. Porke nochi tlen tlaatitok kipia de paninesis, iva nochi tlen amo momati kipia de momatis. ");
INSERT INTO nsu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tla Ne nimechilvia itla kan tlayova, imejvah xikijtokah kan tlanestok. Iva tlen Ne nimechilvia ichtaka, xikinmatiltikah nochtin ma kimatikah. ");
INSERT INTO nsu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amo xikinmavilikah tlen velis kimiktiskeh imokuerpo, pero amitla velis kitoktiskeh imoanima. Okachi kuali xikmavilikah in Dios tlen velis kixpolos imokuerpo iva noijki velis kixpolos imoanima kan miktla. ");
INSERT INTO nsu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Amo monemakah ome tototzitzintih por se tomintzi? Pero nion se de yejvah amo velis mikis tla imoTajtzi Dios amo kimonekiltis. ");
INSERT INTO nsu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Noijki Dios kuali kimati keski imotzonkal inkipiah itech imotzontekoh. ");
INSERT INTO nsu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ijkó pues, amo ximomavtikah, porke imejvah okachi imopati ke miekeh tototzitzintih. ");
INSERT INTO nsu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tlen nechneltoka iva tlajtos kuali de Ne teixpa, Ne noijki nitlajtos kuali de ye ixpan noTajtzi tlen kajki ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero tlen kijtos teixpa ke amo nechixmati, Ne noijki nikijtos ixpan noTajtzi tlen kajki ilvikak nik amo nikixmati. ");
INSERT INTO nsu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Amo xikyejyekokah ke Ne onivala onikchivako ma yeto yolsevilistli itech nin tlaltikpaktli. Amo onivala onikchivako ma yeto yolsevilistli, sino onikvalikak momagalistli. ");
INSERT INTO nsu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Por Ne, in tepiltzi kixnamikis ipapa, in teichpoch kixnamikis imama, iva in sivatl montli kixnamikis imonna. ");
INSERT INTO nsu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ijkó pues, mismo yejvah tlen imofamiliajvah velis imechtlavelitaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Tlen kitlasojtla ipapa o noso imama okachi ke Ne, amo itech povi para yetos nova. Iva tlen kitlasojtla ipiltzi o noso ichpoch okachi ke Ne, amo itech povi para yetos nova. ");
INSERT INTO nsu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tlen kinekis vitz nova pero amo kinekis tlajyovis nion amo kinekis mikis itech krus, amo velis povis nova. ");
INSERT INTO nsu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tlen kinekis kimakixtis inemilis, kipolos, pero tla íkka kipolos inemilis por Ne, kimakixtis inemilis. ");
INSERT INTO nsu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Tlen imechselis imejvah, kijtosneki Ne nechselia, iva tlen nechselia, noijki kiselia tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tlen kiselis se tiotenejmachti porke in tiotenejmachti tetlapovia de Dios, kimakaskeh itlaxtlavil ijkó kemi kimakah se tiotenejmachti. Iva tlen kiselis se tlen kuali tlakatl, kimakaskeh itlaxtlavil ijkó kemi kimakah se tlen kuali tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iva tlen kitliokolis maski san se vaso de atl sesek se de ninmeh tzitzintih tlen nechtokah, yi neli nimechilvia nik in Dios kimakas itlaxtlavil. ");
INSERT INTO nsu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ijkuak Jesús otlanki okinnajnavati tlán kichivaskeh in majtlaktli ivan ome tlen okinmachtiaya, ijkuakó Ye oyá de ompa otlamachtito iva otetlapovito de itlajtol in Dios itech oksekimeh altepemeh de yejón región. ");
INSERT INTO nsu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ijkuak Juan otzaktoka telpiloya iva ijkuak okimatki tlen okichivaya in Cristo, ijkuakó ome momachtijkeh de Juan okintitlanki ma viah ma kittatih in Jesús, ");
INSERT INTO nsu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para ma kitlajtlaniitih: —¿Kox yen tejwatzi tiCristo tlen tikchiah vitz se tonali, o noso moneki ok tikchixtoskeh? ");
INSERT INTO nsu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús okinnankili: —Xiviah xikilvitih in Juan nochi tlen imejvah inkittah ivan inkikakih. ");
INSERT INTO nsu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xikilvikah ke tlen amo otlachiayah axka yi tlachiah, in koxomeh yi nejnemih iva tlen opalania innakayo yopajtikeh de inkokolis. Tlen amo otlakakiah, axka yi tlakakih, in mikameh oksemi moyolitiah, iva in prowestih kikakih in yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iva ma paki tlen amo kipolova itlaneltokalis nonavak. ");
INSERT INTO nsu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tlen momachtijkeh de Juan ijkuak oyajkeh, ijkuakó Jesús ope kintlapovia in gentejtih aserka de Juan, iva okinmilvi: —¿Tlán onkittatoh kan tlavaki? ¿Onkittatoh se tlakatl tlen itlaneltokalis kivivika in ejekatl kemi ijkuak in ejekatl kivivika se akatl? ");
INSERT INTO nsu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tonses akin onkittatoh? ¿Onkittatoh se tlakatl tlen konakia itzotzol tlen kuali? Imejvah kuali inkimatih ke tlen konakiah intzotzol tlen kuali kateh inchan wejwei tlanavatijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tonses, ¿akin onkittatoh? ¿Onkittatoh se tiotenejmachti? Yi neli, ye okatka okachi ke se tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Se lado in Tiotlajkuiloli tlajtova de yen Juan, kijtova: Ne niktitlani notlatitlanil moyakapa, ma sa kiyektlali in ojtli para ijkuak tivalmuikas. ");
INSERT INTO nsu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yi neli nimechilvia, ke de nochtin tlaltikpaktlakah, amo onka oksé tlen ma yeto okachi mejor ke Juan tlen tlabautisaro. Pero kan Dios tlanavatia, se tlen amo ipanitalistli yejón okachi mejor ke Juan. ");
INSERT INTO nsu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde ijkuak in Juan tlen tlabautisaro ope tetlapovia de itlajtol in Dios iva asta axka, in gentejtih tlen amo ixmavkemeh sa tlawel kitzatzakuiliah kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Antes de ovalaskia in Juan, nochtin tiotenejmachtijkeh ivan itlanavatil Moisés okijtojkeh tlán panolos satepa. ");
INSERT INTO nsu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iva tla inkineltokaskeh o noso amo, Juan yen tiotenejmachti Elías tlen okipiaya de vitz. ");
INSERT INTO nsu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Tlán ika velis nikinparejaros in gentejtih de nin tiempo? Kateh kemi chokojtih tlen motlaliah maviltiah tiankistli iva kintzajtziliah inyoliknivah, ");
INSERT INTO nsu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","iva kinmilviah: “Otimechtlapichilijkeh ika flauta para ximijtotikah, iva amo onmijtotijkeh. Otimechtlakuikilijkeh se tlakuikali teyolkoko, iva amo onchokakeh.” ");
INSERT INTO nsu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porke ovala in Juan, tlen omosavaya iva amo okonia vino, iva imejvah onkijtovayah kipia se amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Satepa ovala iKone in Tlakatl, tlen tlakua iva koni, iva imejvah inkijtovah ke apistli iva tlavanki, iva inkijtovah invah movika in tlajtlakolejkeh iva in kobradortih de impuestos. Pero in tlamatilistli de Dios moteititia por tlen kichivah tlen ipilvah. ");
INSERT INTO nsu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ijkuakó Jesús ope kinmajva in gentejtih tlen chantih itech altepemeh kan okinchi okachi miekeh tetzavimeh, porke amo omoyolkuapayah. Okijto: ");
INSERT INTO nsu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ay de imejvah gentejtih de Corazín! ¡Ay de imejvah gentejtih de Betsaida! Porke tla itech altepetl de Tiro iva de Sidón okinmitaskiah in tetzavimeh tlen imejvah yonkimitakeh, yi ke tiempo yomoyolkopaskiah iva okonakiskiah intzotzol tlen tetzojtzopiti iva omotlekonexviskiah itech intzonteko, para kiteititiskeh ke ayakmo kinekih kichivaskeh tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero Ne nimechilvia, ke neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, imejvah intlajyoviskeh okachi ke in gentejtih de altepetl de Tiro iva de Sidón. ");
INSERT INTO nsu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iva imejvah gentejtih de Capernaum, ¿inkiyejyekovah inkiseliskeh tetlakitalistli itech ilvikak? ¡Pues asta miktla imechtlalchitlaliskeh! Porke tla in gentejtih de Sodoma okimitaskiah in tetzavimeh tlen imejvah yonkimitakeh, yejón altepetl oyeskia asta axka. ");
INSERT INTO nsu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero Ne nimechilvia, ke neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, imejvah intlajyoviskeh okachi ke nekateh gentejtih de región de Sodoma. ");
INSERT INTO nsu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Itech nekateh tonaltih, Jesús okijto: —NoTajtzi, nimitzweijkachiva tejwatzi tlen moaxka in ilvikak ivan tlaltikpaktli. Porke otikinmititih ninmeh tlamantih tlen yolyamankeh kemi oyeskia konemeh, iva amo otikinmititih tlen momachiliah kimatih iva kipiah tlamatilistli. ");
INSERT INTO nsu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kema, noTajtzi, porke tejwatzi ijkó otikmonekilti. ");
INSERT INTO nsu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’NoTajtzi onechmakak ma niknavati nochi tlen onka. Iva Ne niiKone amika nechixmati, sino san yen noTajtzi nechixmati. Iva amika kixmati noTajtzi, sino san yen Ne niiKone nikixmati. Iva noijki kixmatiskeh tlen akinmeh Ne nikneki ma kixmatikah noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xivikikah nonavak nochtin imejvah tlen yonsotlavakeh iva intlamamajtokeh ika miek tlamantli tesotla, iva Ne nikchivas ximosevikah. ");
INSERT INTO nsu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xikchivakah tlen Ne nimechnavatia iva ximomachtikah de Ne, porke Ne niyolyamanki iva amo nimoweíneki. Iva ijkó notech velis mosevis imoanima. ");
INSERT INTO nsu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porke in tekitl tlen Ne nikneki imejvah xikchivakah mach ovi para inkichivaskeh, iva tlen Ne nikneki imejvah xikmamakah mach etik para inkimamaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Itech nekateh tonaltih, se welta ijkuak sábado, Jesús onejnentiaya kan otoktoka trigo. Ijkuakó, in momachtijkeh otiojsijkeh iva ope kikuakojkotonah seki trigo, iva ope kikuah. ");
INSERT INTO nsu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ijkuak in fariseos okimitakeh, okilvijkeh in Jesús: —Xikinmita, tlen Te tikinmachtia kichivah tlen amo kipia de kichivaskeh ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero Jesús okinmilvi: —¿Amo semi inkilerovah tlen okichi in David ijkuak ye ivan iyoliknivah otiojsijkeh? ");
INSERT INTO nsu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Okalakeh kan ikalijtik in Dios iva okikuajkeh in pan tlatiochivali. Nion David nion iyoliknivah amo intech opovia para kikuaskeh yejón pan, sino san yejvah tiopixkeh intech opovia para kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O noso amo kema inkilerovah tlen kijtova itlanavatil Moisés? ¿Amo inkimatih ke in tiopixkeh veli tekipanovah kan templo ijkuak sábado iva yejón amo tlajtlakoli? ");
INSERT INTO nsu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero Ne nimechilvia, ke Ne tlen axka nikan nika, okachi niweititok iva amo kemi in templo. ");
INSERT INTO nsu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Imejvah amo inkajsikamatih tlen kijtova in Tiotlajkuiloli, kan kijtova: “Ne nikneki xiteiknomatikah iva amo nikneki techinmiktilikah yolkameh kemi se tlamanali para Ne.” Tla imejvah onkajsikamatiskiah, tonses amo onkintlajtlakoltiskiah tlen amo kipiah tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Porke iKone in Tlakatl yen tekova de yejón sábado iva yen velis kijtos tlán velis se kichivas itech yejón tonali. ");
INSERT INTO nsu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús oyá de ompa iva okalakki kan se tiotlamachtijkali. ");
INSERT INTO nsu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ompa okatka se tlakatl tlen ovaki ima. In fariseos okitemoliayah in Jesús tlán ika velis kiteilviskeh, iva okitlajtlanijkeh: —¿Techkavilia itlanavatil Moisés ma tikpajtikah se kokoxki ijkuak sábado? ");
INSERT INTO nsu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús okinnankili: —Tla íkka de imejvah kipia se ichka iva tla omoposojvi ijkuak sábado, ¿amo inyaskeh inkixtitivih? ");
INSERT INTO nsu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Amo okachi miek ipati se tlakatl ke se ichka? Tonses, in tlanavatili kitekavilia ma se kichiva tlen kuali ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ijkuakó Jesús okilvi in tlakatl tlen ovaki ima: —Xikmelava moma. Iva ijkuak okimela ima, yejón ima opajtik iva omoka yi kuali kemi oksé ima. ");
INSERT INTO nsu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ijkuakó in fariseos okiskeh de kan tiotlamachtijkali, iva ope motlatlalviah para kixpoloskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ijkuak Jesús okimatki tlen okinekiah kitoktiskeh, okiski de ompa, iva miekeh gentejtih okitokakeh. Jesús okinpajti nochtin tlen omokokovayah, ");
INSERT INTO nsu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","iva okinnavati amo ma kitematiltikah akin Ye. ");
INSERT INTO nsu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ijkó opanolok para ma mochiva tlen okijkuilo in tiotenejmachti Isaías: ");
INSERT INTO nsu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nikan kajki notekipano tlen Ne onikpejpenki, Ne niktlasojtla iva inavak nipaki. Niktlalis noTioijyotzi itech Ye, iva kinmatiltis nochtin gentejtih de nin tlaltikpaktli kenik velis yeskeh kuali inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Amo mokualanijtinemis iva nion amo tzatzajtzis. Iva nion amo kikakiskeh ma tlajto chikavak itech ojtli. ");
INSERT INTO nsu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Amo kipostekis in akatl tlen yokuelpachivik, nion amo kisevis in pabilo tlen ok popokatok, asta kan kichivas ma tlatlani tlen kuali. ");
INSERT INTO nsu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iva nochtin tlaltikpaktlakah kichiaskeh Ye ma kinmakixti. ");
INSERT INTO nsu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ijkuakó okivalikilijkeh in Jesús se tlakatl tlen amo otlachiaya iva okatka noontzi porke okipiaya se amo kuali ejekatl. Jesús okipajti yejón tlakatl iva ovelik otlachixki iva ovelik otlajto. ");
INSERT INTO nsu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nochtin gentejtih sa otlatlachixkeh iva okijtojkeh: —¿Nin tlakatl xamo yen ikone David tlen Dios okijto techvaltitlanilis? ");
INSERT INTO nsu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero ijkuak in fariseos ijkó okikakkeh, okijtojkeh: —Nin tlakatl kinkixtia amo kuali ejekameh ika ivelitilis Beelzebú, tlen tlayakanki de nochtin amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús kuali okimatia tlen yejvah okiyejyekovayah, iva por eso okinmilvi: —Tla in gentejtih de se país pevas momijmiktiskeh san mismo yejvah, yejón país popolivis. Iva tla se altepetl o se familia pevas kimomagaskeh san mismo yejvah, noijki mach wejkavas yeskeh san sekka. ");
INSERT INTO nsu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijkó noijki, tla in Amo Kuali Tlakatl kikixtis in Amo Kuali Tlakatl, kijtosneki san ye mismo kimomaga ivan motlajkoxelova, iva nochi tlen ye kinavatia mach wejkavas. ");
INSERT INTO nsu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iva tla Ne nikinkixtia amo kuali ejekameh ika ivelitilis Beelzebú, tonses ¿de akin ivelitilis ika kinkixtiah tlen imejvah inkinmachtiah? Por eso, yejvah innevia kiteititiah nik mach yompa tlen imejvah inkijtovah. ");
INSERT INTO nsu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero Ne nikinkixtia amo kuali ejekameh ika Dios iTioijyotzi, iva yejón kijtosneki nik in Dios yoejkok imonavak para tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Velis íkka tlakatl kalakis ikalijtik de oksé tlakatl tlen chikavak iva kikixtilis tlen kipia? Tla achto kijilpis, tonses velis kikixtilis tlen kipia ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Tlen amo kajki nova, kajki kontra Ne. Iva tlen amo nechpalevia para kinnotzas oksekimeh para ma nechseguirokah, kijtosneki san kinchochololtia. ");
INSERT INTO nsu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Por eso nimechilvia, Dios kintlapojpolvis in tlaltikpaktlakah de nochi tlajtlakoli iva de nochi in fiero tlen kijtoskeh kontra Dios, pero tla itla kijtoskeh tlen amo kuali en kontra de yen Tioijyotzintli, Dios amo keman kintlapojpolvis. ");
INSERT INTO nsu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tla íkka kijtos itla tlajtoli en kontra de iKone in Tlakatl, Dios velis kitlapojpolvis, pero akin itla kijtos en kontra de yen Tioijyotzintli, Dios amo kitlapojpolvis, nion axka itech nin tiempo iva nion itech neká tiempo tlen yetos satepa. ");
INSERT INTO nsu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Se tlen kuali kuavitl, itlakilo noijki kuali. Iva se tlen amo kuali kuavitl, itlakilo noijki amo kuali. Porke se kuavitl moixmati por itlakilo. ");
INSERT INTO nsu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Imejvah intepilvah de kovameh! ¿Kenomi velis inkijtoskeh itla tlen kuali, tla imejvah amo inkualmeh? Porke tlen tentok itech se iyolo, yen yejón se tlapova. ");
INSERT INTO nsu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Se kuali tlakatl, kijtova tlen kuali, porke itech iyolo onka tlen kuali. Pero se tlakatl tlen amo kuali kijtova tlen amo kuali, porke itech iyolo onka tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero Ne nimechilvia ke itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, nochtin imejvah inkitemakaskeh kuenta de nochi tlajtoli tlen amo kuali tlen onkijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dios kijtos kox tlajtlakole o noso amo kada se tlakatl ijkó kemi tlen okijto ika ikamak. ");
INSERT INTO nsu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ijkuakó sekimeh tlamachtijkeh de itlanavatil Moisés ivan fariseos okilvijkeh in Jesús: —Tlamachti, tiknekih tikittaskeh xikchiva se tetzavkaneskayotl tlen ma kinexti nik yi neli tivitz de Dios. ");
INSERT INTO nsu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús okinnankili: —In gentejtih tlen amo kuali inyelis iva ayakmo kipiah tlaneltokalistli inavak Dios, kinekih ma nikinmititi se tetzavkaneskayotl para nechneltokaskeh. Pero san yen tlen itech omochi in tiotenejmachti Jonás, san yen yejón tetzavkaneskayotl nikinmakas. ");
INSERT INTO nsu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iva ijkó kemi Jonás okatka eyi tonali iva eyi yovali ijtik se wei michi, ijkó noijki iKone in Tlakatl yetos eyi tonali iva eyi yovali ijtik tlali. ");
INSERT INTO nsu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, tlen de Nínive noijki moketzaskeh iva imechteilviskeh para Dios ma imechtlajyovilti. Porke yejvah omoyolkuapkeh ijkuak okintlapovi in Jonás, iva Ne okachi niweititok iva amo kemi Jonás. ");
INSERT INTO nsu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, in reina tlen ovala de wejka de ik tlatzintla moketzas iva imechteilvis para Dios ma imechtlajyovilti. Ye ovala de wejka para kikakis in wei tlanavati Salomón tlen otlamachtiaya ika tlamatilistli, iva Ne okachi niweititok iva amo kemi Salomón. ");
INSERT INTO nsu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ijkuak se amo kuali ejekatl kisa de ijtik se tlakatl, nentinemi kan tlavaki kitemojtinemi kan mosevis, iva tla amo kajsi, ");
INSERT INTO nsu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kijtova: “Nimokuapas oksemi ijtik neká tlakatl de kan onikiski.” Iva ijkuak mokuapa, konajsi in tlakatl kemi se kali kan amika chanti, kan yotlachpankeh iva yi tlayektlalitok. ");
INSERT INTO nsu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Satepa yavi kinnotzati oksekimeh chikome ejekameh tlen okachi fierotikeh, iva nochtin yavih mochantitivih ijtik yejón tlakatl, iva satepa in tlakatl mokava okachi pior ke achto. Ijkó noijki mochivaskeh in gentejtih tlen amo kuali inyelis de nin tiempo. ");
INSERT INTO nsu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ok okintlapovijtoka in gentejtih, iva ijkuakó oajsikoh imama ivan iknivah. Yejvah omokajkeh kiavak, iva okinekiah motlapoviskeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ijkuakó se tlakatl okilvi in Jesús: —Momama ivan moknivah kateh kiavak, kinekih motlapoviskeh mova. ");
INSERT INTO nsu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Jesús okinankili: —¿Akin nomama, iva akinmeh noknivah? ");
INSERT INTO nsu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Okinmajpilvi tlen okinmachtiaya iva okijto: —Ninmeh yejvah nomama iva noknivah. ");
INSERT INTO nsu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porke tlen kichiva tlen kimonekiltia noTajtzi tlen kajki ilvikak, yen yejón nokni tlakatl, yen yejón nokni sivatl iva yen yejón nomama. ");
INSERT INTO nsu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yejón tonali Jesús okiski de kalijtik iva omotlalito itempan atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iva komo omololojkeh miekeh gentejtih kan Jesús okatka, mejor otlejkok itech se barko iva ompa itech omotlali, iva nochtin gentejtih omokajkeh itempan atl. ");
INSERT INTO nsu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ijkuakó ope kinmachtia de miek tlamantli ika ejemplos. Okijto: —Se tlakatl okiski okitookato trigo. ");
INSERT INTO nsu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iva ijkuak otookatoka, seki semiya ovetzki ipan ojtli. Satepa ovalajkeh in totomeh iva okikuajkeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Okseki semiya ovetzki kan teyo, kan okipiaya tlali san tlapanixko. Yejón semiya san nima oixvak porke in tlali amo okatka tilavak. ");
INSERT INTO nsu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero ijkuak okiski in tonali, okitlati, iva komo amo wejkatla omonelvayoti, ovaki. ");
INSERT INTO nsu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Okseki semiya ovetzki ijtik xivyo tlen vitzo, iva omoskalti miek xivitl vitzo iva in tlatoktli oxivmiki. ");
INSERT INTO nsu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero seki semiya ovetzki kan kuali tlali, iva kuali otlaki. Seki tlatoktli okitemakak san de se semiya se siento tleyoltzintli de trigo. Iva sekimeh okitemakakeh expoali tleyoltzintli, iva sekimeh okitemakakeh senpoali ivan majtlaktli tleyoltzintli. ");
INSERT INTO nsu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tlen momachtijkeh de Jesús ijkuakó omotokijkeh inavak iva okitlajtlanijkeh: —¿Tleka tikintlapovia ika ejemplos? ");
INSERT INTO nsu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús okinnankili: —Imejvah Dios imechkavilia xikmatikah tlen achto amika okimatia de kenik in Dios tlanavatia, pero tlen oksekimeh amo. ");
INSERT INTO nsu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porke tlen kipia, kimakaskeh iva kipias okachi miek. Pero tlen amo kipia, asta yen tlen kipia kikixtiliskeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Por eso Ne nikintlapovia ika ejemplos, porke maski yejvah kittah tlen nikchiva amo kimomakah kuenta tlán kijtosneki. Iva maski kikakih tlen nikijtova amitla veli kajsikamatih kemi oyeskia amitla okikakkeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ijkó panolo tlen okijto in tiotenejmachti Isaías: Imejvah intlakakiskeh ika inmonakas, pero amitla inkajsikamatiskeh. Intlachiaskeh ika inmoixtololovah, pero amo inkimatiskeh tlán kijtosneki tlen inkittah. ");
INSERT INTO nsu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porke ninmeh gentejtih yoyoltlakuavakeh. Kintzakuah innakasvah para amo tlakakiskeh, kintzakuah inmixtololovah para amo tlachiaskeh. Por eso amitla kajsikamatih, amo tlachiah iva amo tlakakih. Amo kinekih mokopaskeh nonavak, iva nion amo kinekih ma nikinpajti. ");
INSERT INTO nsu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero imejvah xipakikah, porke inkajsikamatih tlen inkittah iva tlen inkikakih. ");
INSERT INTO nsu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yi neli nimechilvia, ke miekeh tiotenejmachtijkeh iva miekeh gentejtih tlen kualmeh de neká tiempo okinekiah kittaskeh iva kikakiskeh tlen imejvah axka inkittah iva inkikakih, pero amo okittakeh iva nion amo okikakkeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Xikakikah pues tlán kijtosneki in ejemplo de neká tlakatl tlen otookato. ");
INSERT INTO nsu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tlen akinmeh kikakih in yankuik kuali tlajtoli de kenik Dios tlanavatia iva amo kajsikamatih, yejonmeh kateh kemi in semiya tlen ovetzki itech ojtli, vitz in Amo Kuali Tlakatl iva kinkixtilia itlajtol in Dios tlen omotookak itech inyolo. ");
INSERT INTO nsu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","In semiya tlen ovetzki kan teyo, kijtosneki yejvah tlen kikakih itlajtol in Dios iva san nima kiseliah ika miek pakilistli. ");
INSERT INTO nsu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero komo amo monelvayotiah wejkatla, nima nelvayovakih. Iva ijkuak inpa vitz tlajyovilistli o noso ijkuak kinchochololtiah por itlajtol in Dios, valmoxijxikovah iva kikavah in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","In semiya tlen ovetzki ijtik xivyo tlen vitzo, kijtosneki yejvah tlen kikakih itlajtol Dios pero sa tlawel motekipachovah ika miek tlamantli tlen onka itech nin tlaltikpaktli iva kinmixkajkayava in tomi. Nochi nin tlamantli kixivmiktia itlajtol in Dios tlen omotookak itech inyolo, iva mokavah kemi tlatoktih tlen amo tlakih. ");
INSERT INTO nsu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero in semiya tlen omotookak kan kuali tlali, kijtosneki yejvah tlen kikakih itlajtol in Dios iva kajsikamatih, iva moyolkuapah iva kichivah tlen kuali kemi ijkuak se tlatoktli kuali tlaki. Sekimeh san de se semiya kitemakah se siento tleyoltzintli, sekimeh kitemakah expoali tleyoltzintli, iva sekimeh kitemakah senpoali ivan majtlaktli tleyoltzintli. ");
INSERT INTO nsu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús okinmilvi oksé ejemplo: —Kan Dios tlanavatia panolo ijkó kemi omochi se tlakatl tlen okitookak kuali semiya itlala. ");
INSERT INTO nsu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero de yovak ijkuak nochtin okochtokah, ovala tlen kitlavelita in tekova iva okitookak miek semiya de seki fierojxivitl kan okitookakeh trigo, iva oyá. ");
INSERT INTO nsu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ijkuak in trigo omoskalti iva omiavatik, ijkuakó noijki omoskalti miek fierojxivitl. ");
INSERT INTO nsu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","In tlakevaltih oyajkeh okilvitoh in tekova: “Tla tejwatzi otiktookak kuali semiya motlala, ¿tonses de kan okiski in fierojxivitl?” ");
INSERT INTO nsu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","In tekova okinmilvi: “Se tlakatl tlen nechtlavelita ijkó okichi.” Ijkuakó itlakevalvah okitlajtlanijkeh: “¿Tikneki ma tikvivitlatih in fierojxivitl?” ");
INSERT INTO nsu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","In tekova okinmilvi: “Amo, porke tla inkivivitlaskeh in fierojxivitl, velis noijki inkivivitlaskeh in trigo. ");
INSERT INTO nsu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Okachi kuali xikavakah ma moskaltikah san sekka asta ijkuak se kitekis in trigo. Iva ijkuakó nikintitlanis sekimeh notlakevalvah para achto ma kololokah in fierojxivitl iva ma kimanojoilpikah para kitlatiskeh. Iva satepa nikinmilvis ma kololokah in trigo para niktlaatis kan nosinkal.” ");
INSERT INTO nsu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús noijki okinmilvi nin ejemplo: —Kan Dios tlanavatia yejón kemi se semiyajtzi de mostaza tlen se tlakatl kitooka itlala. ");
INSERT INTO nsu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yejón semiyajtzi okachi tzikitzi de nochi okseki semiya, pero ijkuak moskaltia, moskaltia okachi wei de nochi tlatoktli tlen se kitooka iva motlami se kuavitl iva in totomeh asta motepajsoltiah itech imamayo. ");
INSERT INTO nsu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús noijki okinmilvi nin ejemplo: —Kan Dios tlanavatia yejón noijki kemi in xokotixtli. Ijkuak se sivatl kinelova eyi tlatamachivali de arina iva kitlalilia achitzi xokotixtli, in xokotixtli kisamava nochi in tixtli. ");
INSERT INTO nsu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús okinmachtiaya ika ejemplos ijkuak okintlapoviaya in gentejtih. Iva nochipa ijkó okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Para ma mochiva tlen okijto in tiotenejmachti: Nitlajtos ika ejemplos, nikinmijtos tlamantih tlen Dios amo okinekia íkka ma kimati desde ijkuak Dios okichi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ijkuakó Jesús ompa okinkajte in gentejtih iva oyá kalijtik. Tlen momachtijkeh omotokijkeh inavak iva okilvijkeh: —Techilvi tlan kijtosneki in ejemplo de neká fierojxivitl tlen omoskalti itzalan trigo. ");
INSERT INTO nsu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ijkuakó Jesús okinmilvi: —Tlen kitooka tlen kuali semiya, kijtosneki yen iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ivan tlala kijtosneki yen tlaltikpaktli. In kuali semiya kijtosneki yejvah tlen poviskeh kan Dios tlanavatia. Iva in fierojxivitl kijtosneki yejvah tlen kinnavatijtok in Amo Kuali Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iva tlen kitlavelita in tekova, kijtosneki yen Amo Kuali Tlakatl tlen okitookak in fierojxivitl. Iva ijkuak kololoskeh in trigo, kijtosneki ijkuak tlamis in tlaltikpaktli. Iva tlen kololovah in trigo, kijtosneki yejvah in ilvikaktlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Iva ijkó kemi ijkuak kivivitlah in fierojxivitl iva kitlatiah ijtik tlitl, ijkó noijki panolos ijkuak tlamis nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iva iKone in Tlakatl kinvalintitlanis iilvikaktlatitlanilvah kan Dios tlanavatia para ma kinkixtikih nochtin tlen kichivah tlen amo kuali iva tlen kinyakanah oksekimeh itech tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iva kintlamotlaskeh ijtik tlitl kan chokaskeh iva motlantekiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iva tlen tlakamelajkeh, petlaniskeh kemi tonali ompa kan inTajtzi Dios tlanavatia. Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Kan Dios tlanavatia yejón kemi oyeskia seki tomi tlen tlalpachitok itech se tlali. Ijkuak se tlakatl kajsi, oksemi ompa kitlaatia. Iva ika pakilistli yavi iva kinemaka nochi tlen kipia. Iva kimokovia yejón tlali. ");
INSERT INTO nsu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Noijki kan Dios tlanavatia, yejón kemi se tlasemanki tlen kintemojtinemi kuajkuali perlas, ");
INSERT INTO nsu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","iva ijkuak kajsi se perla patío, yavi ikalijtik iva kinemaka nochi tlen kipia iva kikova yejón perla. ");
INSERT INTO nsu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Noijki kan Dios tlanavatia, yejón kemi se red tlen kitlamotlah ijtik atl iva kinkitzkia miek tlamantli de michimeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ijkuak in red yotenki, in michkitzkijkeh kikixtiah itempan atl iva peva kintlapejpeniah in michimeh. In michimeh tlen kualmeh kintlaliah ijtik chikimeh, iva tlen amo kualmeh kintlamotlah. ");
INSERT INTO nsu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ijkó yetos noijki ijkuak tlamis nin tlaltikpaktli. Vitzeh in ilvikaktlatitlaniltih iva kinkixtiskeh in gentejtih tlen amo kuali inyelis de kan kateh tlen kualmeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Iva tlen amo kuali inyelis kintlamotlaskeh ijtik tlitl, kan chokaskeh iva motlantekiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ijkuakó Jesús okintlajtlani: —¿Inkajsikamatih nochi nin tlen nimechilvijtok? Yejvah okilvijkeh: —Kema, tikajsikamatih. ");
INSERT INTO nsu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ijkuakó Jesús okinmilvi: —Ijkuak se tlamachti de itlanavatil Moisés yi kimati kenik in Dios tlanavatia, mochiva kemi se tlakatl tlen chanti itech se kali. De tlen kipia tlaatitok itech ikalijtik kinkixtia tlamantih tlen yankuikeh iva tlen yi tiameh. ");
INSERT INTO nsu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ijkuak Jesús otlanki okinmilvi ninmeh ejemplos oyá de ompa ");
INSERT INTO nsu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","iva oajsito ialtepe. Ompa ope tlamachtia itech tiotlamachtijkali, iva in gentejtih sa otlatlachiayah iva okijtovayah: —¿Kan okikuito nochi nin tlamatilistli nin tlakatl? ¿Kenik veli kinchiva ninmeh tetzavimeh? ");
INSERT INTO nsu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Amo ye nin ipiltzi in kuavtlaxinki? ¿Amo imama itoka María? ¿Amo yen inmikni in Jacobo, José, Simón ivan Judas? ");
INSERT INTO nsu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Amo nika chantih itech toaltepe iknivah tlen sivameh? ¿Tonses kan okikuito nochi nin tlamantli? ");
INSERT INTO nsu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ayakmo okivelitakeh iva ayakmo okinekeh okikakkeh. Pero Jesús okinmilvi: —Se tlakatl tlen tetlapovia de Dios kitlakitah san kan yetos, pero menos itech ialtepe iva itech ifamilia. ");
INSERT INTO nsu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","In gentejtih de yejón altepetl amo okineltokayah in Jesús, iva por eso amo okinchi miekeh tetzavimeh itech yejón altepetl. ");
INSERT INTO nsu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Itech nekateh tonaltih Herodes okatka kobernador de Galilea, iva okikakki tlen Jesús okichivaya, ");
INSERT INTO nsu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","iva okinmilvi itlakevalvah: —Neká tlakatl yen Juan tlen tlabautisaro iva axka yomoyoliti. Iva por eso veli kinchiva tetzavimeh. ");
INSERT INTO nsu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Okachi achto Herodes otlanavati ma kikitzkikah in Juan, ma kijilpikah ika kadena iva ma kitzakuakah telpiloya. Herodes ijkó okichi porke Herodías ijkó okilvi ma kichiva. Herodías yen itonana in Felipe, ikni in Herodes. ");
INSERT INTO nsu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan nochipa okilviaya in Herodes: —Dios itlanavatil amo kitekavilia para ivan ximonamikti in Herodías. ");
INSERT INTO nsu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes okinekia kixpolos in Juan, pero okinmiimakasia in gentejtih porke nochtin okineltokayah ke Juan okatka tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero ijkuak Herodes okikumpliro xivitl, ichpoch in Herodías omijtoti inmixpa nochtin tlen okinminvitarojkeh. Herodes sa tlawel okivelitak kenik omijtoti yejón ichpochtli. ");
INSERT INTO nsu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iva Herodes okimakak itlajtol okilvi nik yi neli kimakas san tlen ye kitlajtlanilis. ");
INSERT INTO nsu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodías yokilvijka ichpoch tlán kitlajtlanis iva por eso okilvi in Herodes: —Techmaka ika se plato itzonteko in Juan tlen tlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","In wei tlanavati omoyolkoko. Pero komo yokimakak itlajtol inmixpa tlen okinminvitaro, tonses otlanavati ma kimakakah. ");
INSERT INTO nsu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iva otlanavati ma kikechtzontekikah in Juan kan otzaktoka, ");
INSERT INTO nsu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","iva okivalikilijkeh ika se plato itzonteko in Juan iva okimaktilijkeh in ichpochtli, iva yejón ichpochtli okimaktili imama. ");
INSERT INTO nsu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Satepa ovalajkeh tlen okinmachtiaya in Juan, okivikakeh ikuerpo iva oyajkeh okitookatoh, iva satepa oyajkeh okimatiltitoh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ijkuak Jesús okimatki yokimiktijkeh in Juan, otlejkok itech se barko iva oyá iselti kan tlalkavali. Pero ijkuak in gentejtih okimatkeh, okiskeh de inmaltepe iva oyajkeh okajsitoh nejnentivih. ");
INSERT INTO nsu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ijkuak Jesús otemok de itech barko, okinmitak miekeh gentejtih ompa yomololojkeh, okinmiknomatki iva okinpajti tlen omokokovayah. ");
INSERT INTO nsu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ijkuak yotiotlakik, tlen okinmachtiaya omotokijkeh inavak iva okilvijkeh: —Yotiotlakik, iva ik nika amika chanti. Xikintitlani ninmeh gentejtih ma viah itech altepemeh ma kimokovitih itla tlen kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús okinmilvi: —Mach moneki ma viah, imejvah xikintlamakakah. ");
INSERT INTO nsu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yejvah okilvijkeh: —Pero tikpiah san makuili pan iva ome michimeh. ");
INSERT INTO nsu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pero Jesús okinmilvi: —Nika techinvalikilikah. ");
INSERT INTO nsu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ijkuakó otlanavati ke nochtin gentejtih ma motlajtlalikah ipan sakayo. Jesús okontilanki in makuili pan ivan ome michimeh, oajkotlachixki iva okitlasojkamatki inavak Dios. Satepa okinpojpostekki in panmeh iva okinmaktili tlen momachtijkeh iva yejvah okinxejxelilijkeh nochtin gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nochtin kuali otlakuajkeh asta kan oixvikeh. Tlen momachtijkeh okololojkeh in pedasos tlen osobraro iva okintemitijkeh majtlaktli ivan ome chikimeh. ");
INSERT INTO nsu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nochtin tlen otlakuajkeh okatkah kemi makuili mil tlakah, amo okinpojkeh in sivameh nion konemeh. ");
INSERT INTO nsu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Satepa, Jesús okinnavati tlen momachtijkeh ma tlejkokah itech barko para ma panokah oksé lado de kan atl tlen wei para ma sa tlayakantokah, mientras Ye ok okinmakah nochtin gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Satepa, ijkuak yokinmakah, Jesús otlejkok ipan se tepetl omodiostzajtzilito iselti. Ijkuak otlayovak Jesús ompa okatka iselti. ");
INSERT INTO nsu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","In barko yoyaya tlatlajko atl. In atl ope motlatlaviteki chikavak itech barko porke in ejekatl okinmixnamiktivalaya. ");
INSERT INTO nsu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kualka antes de tlanesis, Jesús okinmajsito in momachtijkeh, Jesús onejnentiaya ixko atl. ");
INSERT INTO nsu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","In momachtijkeh ijkuak okittakeh nejnentivitz ixko atl, omomavtijkeh iva otzajtzikeh, okijtojkeh: —¡Se mika ejekatl! ");
INSERT INTO nsu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús okinnotzki iva okinmilvi: —¡Ximoyolchikavakah, amo ximomavtikah, Ne niJesús! ");
INSERT INTO nsu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ijkuakó Pedro okinankili: —NoTeko, tla yi neli tejwatzi, tonses xikchiva ma ninejnemi ixko atl asta kan tejwatzi tika. ");
INSERT INTO nsu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iva Jesús okilvi: —Xiviki. Ijkuakó Pedro otemok de kan barko iva ope nejnemi ixko atl para yas kajsiti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero komo okittak nik oejekaya chikavak, omomavti. Iva komo ope poolaki, okitzajtzili chikavak: —¡NoTeko, techmakixti! ");
INSERT INTO nsu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús okimakitzkijtivetzki iva okilvi: —¡Seppa tzikitzi motlaneltokalis! ¿Tleka otimoyoloomevi? ");
INSERT INTO nsu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iva ijkuak otlejkokeh itech barko, in ejekatl omoketzki. ");
INSERT INTO nsu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ijkuakó, nochtin tlen okatkah ijtik barko omotlankuaketzkeh iyakapan Jesús iva okilvijkeh: —Tejwatzi yi neli tiiKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ijkuak otlankeh opanokeh itech yejón atl tlen wei, oajsitoh kan tlali de Genesaret. ");
INSERT INTO nsu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ijkuak in gentejtih de yejón lugar okixmatkeh nik yen Jesús, oyajkeh okitematiltitoh sentetl itech yejón tlali, iva okinvalikilijkeh nochtin kokoxkeh kan Ye okatka. ");
INSERT INTO nsu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Okitlatlavtiayah ma kinkavili ma kikitzkilikah itlaken tlen kimokentia maski san itempa. Iva nochtin tlen okikitzkilijkeh, opajtikeh. ");
INSERT INTO nsu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ijkuakó sekimeh fariseos ivan tlamachtijkeh de itlanavatil Moisés tlen ovalajkeh de Jerusalén, omotokijkeh inavak Jesús iva okitlajtlanijkeh: ");
INSERT INTO nsu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tleka tlen tikinmachtia amo kitlakitah in kostumbres tlen otechmachtijkeh tokojkolvah? Porke amo momajtekiah ijkuak tlakuah. ");
INSERT INTO nsu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iva Jesús okintlajtlani: —¿Tleka noijki imejvah inkixpanaviah itlanavatil Dios por yen inmokostumbre? ");
INSERT INTO nsu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porke Dios okijto: “Xiktlakita mopapa iva momama.” Noijki okijto: “Tlen tlajtos fiero de ipapa o de imama, ma kixpolokah.” ");
INSERT INTO nsu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero imejvah inkijtovah ke se tlakatl velis kilvis ipapa o imama: “Amo velis nimitzpalevis ika tlen mitzpolova, porke nochi tlen nikpia, yonikmaktili in Dios.” ");
INSERT INTO nsu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ika yejón, imejvah inkijtovah mach moneki se kinpalevis in tetajmeh. Inkikavah se lado itlanavatil in Dios iva yej inkichivah tlen de imejvah inmokostumbre. ");
INSERT INTO nsu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Inkipiah ome inmoixko! Yompa tlen okijto in tiotenejmachti Isaías de imejvah, ijkuak okijto: ");
INSERT INTO nsu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ninmeh gentejtih san por kijtovah nechtlakitah, pero inyolo kajki wejka de Ne. ");
INSERT INTO nsu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","San nenka nechweijkachivah, porke tlen tlamachtiah yejón san de tlaltikpaktlakah intlanavatil. ");
INSERT INTO nsu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Satepa Jesús okinnotzki in gentejtih ma motokikah inavak iva okinmilvi: —Techkakikah iva xikajsikamatikah tlen nimechilvis: ");
INSERT INTO nsu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tlen kalaki itech ikamak se tlakatl mach yen kisokiotia. Tlen kisokiotia yen tlen kisa de itech ikamak. ");
INSERT INTO nsu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","In momachtijkeh de Jesús ijkuakó omotokijkeh inavak iva okilvijkeh: —¿Yotikmatki ke in fariseos okualankeh ijkuak okikakkeh tlen otikijto? ");
INSERT INTO nsu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero Ye okinnankili: —Nochi tlatoktli tlen amo okitookak noTajtzi tlen kajki ilvikak, kivivitlas ika nochi inelvayo. ");
INSERT INTO nsu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xikinkavakah yejonmeh fariseos. Porke yejvah kateh kemi oyeskia amo tlachiah. Iva tla íkka tlen amo tlachia kiyakanas oksé tlen noijki amo tlachia, nochtin omeh velis vetzitivih kan tlakuyo. ");
INSERT INTO nsu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ijkuakó Pedro okilvi in Jesús: —Techilvi tlán kijtosneki in ejemplo tlen yikin otikijto. ");
INSERT INTO nsu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús okijto: —¿Imejvah noijki amo inkajsikamatih? ");
INSERT INTO nsu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Amo inkajsikamatih ke nochi tlen kikua se tlakatl kalaki ijtik itlalix, iva satepa kisa de itech ikuerpo? ");
INSERT INTO nsu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero tlen kisa de ijtik ikamak se tlakatl, kisa de ijtik iyolo, iva yen yejón tlen kisokiotia in tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porke de itech iyolo in tlakatl kisa tlen amo kuali kiyejyekova, temiktia, avilnemi itech tlajtlakoli tlen yomonamikti iva noijki tlen ayamo monamiktia, tlachteki, kijtova tlen amo neli iva tlavikaltia. ");
INSERT INTO nsu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yen yejonmeh tlamantih tlen kisokiotiah se tlakatl. Pero tla se tlakuas iva amo se momajtekis, yejón mach velis kisokiotis in tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ijkuakó Jesús okiski de ompa, iva oyá kan región de Tiro iva de Sidón. ");
INSERT INTO nsu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Se sivatl de Canaán tlen amo judía tlen ochantia itech yejón región, ovala tzajtzitivitz inavak Jesús: —¡ToTeko, ikone in David, techiknomati! Nochpoch kipia se amo kuali ejekatl iva sa panova kitlajyoviltia. ");
INSERT INTO nsu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús amo okinankili. Tlen momachtijkeh ijkuakó omotokijkeh inavak Jesús iva okitlatlavtijkeh: —Xikilvi neká sivatl ma via, porke tzajtzitivitz tokuitlapa. ");
INSERT INTO nsu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ijkuakó Jesús okijto: —Dios amo onechvaltitlanki para ma nikinpalevi oksekimeh gentejtih, sino san yejvah tlen povih de Israel tlen mopolojtinemih kemi ichkameh. ");
INSERT INTO nsu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ijkuakó in sivatl omotoki inavak iva omotlankuaketzki iyakapa, okilvi: —¡Tejwatzi noTeko, techpalevi! ");
INSERT INTO nsu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iva Jesús okilvi: —Amo kuali kajki tla nikinkixtilis intlakual in konemeh iva nikinmakas in itzkuintih. ");
INSERT INTO nsu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero in sivatl okinankili: —Kema, noTeko, pero in itzkuintih noijki kikuah intlakualpayex de intekovah tlen tepevi itlampa mesa ijkuak tlakuah. ");
INSERT INTO nsu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijkuakó Jesús okilvi: —¡Sivatl, yi neli wei motlaneltokalis! Ma mochiva ijkó kemi tejwatzi tikneki. San nima ijkuakó ovalpajtik ichpoch in yejón sivatl. ");
INSERT INTO nsu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús okiski de ompa iva oyá itempan atl tlen wei de Galilea. Satepa otlejkok ipan se tepetl iva ompa omotlali. ");
INSERT INTO nsu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ijkuakó, miekeh gentejtih oajsitoh kan Jesús okatka, iva ompa okinvikilijkeh tlen koxomeh, tlen amo tlachiah, tlen noontzitzintih, tlen matepomeh iva miekeh oksekimeh kokoxkeh. Okintlalijkeh ikxitlan Jesús, iva Ye okinpajti. ");
INSERT INTO nsu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nochtin gentejtih sa otlatlachixkeh ijkuak okinmitakeh in noontzitzintih ope tlajtovah, ijkuak in matepomeh opajtikeh, ijkuak in koxomeh yovelitiah onejnemiah, iva ijkuak yovelik otlachixkeh tlen amo otlachiayah. Iva ope kiweijkachivah in Dios de Israel. ");
INSERT INTO nsu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ijkuakó Jesús okinnotzki in momachtijkeh iva okinmilvi: —Nikinmiknomati ninmeh gentejtih, porke yi kipia eyi tonali nika kateh nova iva amitla kipiah tlan kikuaskeh. Amo nikneki nikintitlanis inkalijtik ma tiojsijtiviah, porke velis ixtlioviliskeh ik nepa itech ojtli. ");
INSERT INTO nsu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","In momachtijkeh okilvijkeh in Jesús: —Pero ik nika amika chanti. ¿Kan tikkuitivih pan para tikintlamakaskeh asta achinmeh gentejtih? ");
INSERT INTO nsu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús okintlajtlani: —¿Keski pan inkipiah? Yejvah okinankilijkeh: —Chikome pan iva kana keski michintzitzintih. ");
INSERT INTO nsu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ijkuakó Jesús okinnavati nochtin gentejtih ma motlajtlalikah ipan tlali. ");
INSERT INTO nsu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesús okontilanki in chikome pan ivan michimeh iva okitlasojkamatki inavak Dios. Satepa okinpojpostekki in panmeh ivan michimeh iva okinmajmakak in momachtijkeh para ma kinxejxelilikah nochtin gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nochtin kuali otlakuajkeh asta kan oixvikeh. Iva okololojkeh in pedasos tlen osobraro iva okintemitijkeh chikome chikimeh. ");
INSERT INTO nsu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tlen otlakuajkeh okatkah kemi navi mil tlakah, amo okinpojkeh in sivameh nion konemeh. ");
INSERT INTO nsu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Satepa Jesús okinmakah nochtin gentejtih, otlejkok itech se barko iva oyá ik región de Magdala. ");
INSERT INTO nsu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","In fariseos ivan saduceos oyajkeh okittatoh in Jesús para kiyejyekoskeh. Iva okilvijkeh ma kichiva se tetzavkaneskayotl para kittaskeh kox yi neli Dios okivaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Ye okinmilvi: —In tiotlakkampa, imejvah inkijtovah: “Yetos kuali tiempo, porke tlachichilevi itech ilvikak.” ");
INSERT INTO nsu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iva kualkampa inkijtovah: “Axka mach kualtzi yetos in tiempo porke tlachichilevi iva tlamixtemi.” ¡Imejvah inkipiah ome inmoixko! Imejvah invelih inkiyejyekoliah tlen inkittah itech ilvikak, pero amo invelih inkittah tlen tlamochijtok itech nin tiempo. ");
INSERT INTO nsu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ninmeh gentejtih tlen amo kuali inyelis iva ayakmo kipiah tlaneltokalistli inavak Dios, kinekih ma nikinmititi se tetzavkaneskayotl para nechneltokaskeh. Pero san yen tlen itech omochi in tiotenejmachti Jonás, san yen yejón tetzavkaneskayotl nikinmakas. Ijkuakó Jesús ompa okinkajte iva oyá. ");
INSERT INTO nsu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","In momachtijkeh ijkuak opanokeh ik nepa lado de kan atl tlen wei, okilkajkeh de kivikaskeh pan. ");
INSERT INTO nsu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ijkuakó Jesús okinmilvi: —Techkakikah. Xikpiakah kuidado de inxokotix in fariseos ivan saduceos. ");
INSERT INTO nsu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","In momachtijkeh ope kimolviah entre yejvah: —Ijkó techilvia porke amo otikvalikakeh pan. ");
INSERT INTO nsu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero Jesús okimatia de tlan yejvah omotlapoviayah, iva okinmilvi: —¿Tleka inkimolviah ke amo onkivalikakeh pan? ¡Seppa tzikitzi imotlaneltokalis! ");
INSERT INTO nsu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ayamo inkajsikamatih iva ayakmo inkilnamikih ijkuak in makuili pan onikinxejxelili in makuili mil tlakah, iva keski chikivitl onkololojkeh de tlen osobraro? ");
INSERT INTO nsu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Iva nion ayakmo inkilnamikih in chikome pan tlen onikinxejxelili in navi mil tlakah, iva keski chikivitl onkololojkeh de tlen osobraro? ");
INSERT INTO nsu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Kenik amo inkajsikamatih ke mach de yen pan tlan Ne onimechilvi? Ne onimechilvi xikpiakah kuidado de inxokotix in fariseos ivan saduceos. ");
INSERT INTO nsu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ijkuakó yejvah okajsikamatkeh ke Jesús amo okinmilvijka ma kipiakah kuidado de yen xokotixtli tlen kitlaliliah in pan, sino ma kipiakah kuidado de intlamachtilis in fariseos ivan saduceos. ");
INSERT INTO nsu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ijkuak Jesús oajsito kan región de Cesarea de Filipo, okintlajtlani in momachtijkeh: —¿Tlán kijtovah in gentejtih aserka de iKone in Tlakatl? ");
INSERT INTO nsu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yejvah okinankilijkeh: —Sekimeh kijtovah yen Juan tlen tlabautisaro, oksekimeh kijtovah yen Elías, iva oksekimeh kijtovah yen Jeremías o noso se tlen nepa tiempo oyá tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ijkuakó Jesús okintlajtlani: —Iva imejvah, ¿tlán inkijtovah? ¿Akin Ne? ");
INSERT INTO nsu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro okinankili: —Tejwatzi tiCristo, iKone in Dios tlen yolitok. ");
INSERT INTO nsu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ijkuakó Jesús okilvi: —Xipaki te, Simón, ikone in Jonás, porke amika tlakatl omitzajsikamatilti nik Ne niCristo, sino omitzajsikamatilti noTajtzi tlen kajki ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iva Ne nimitzilvia, nik te tiPedro (kijtosneki tetl), iva itech nin tetl nikpevaltis notekiv de nochtin tlen nechneltokaskeh. Iva nochi ivelitilis tlen kipia in miktla, amo keman velis kintlanilis. ");
INSERT INTO nsu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iva te nimitzinmakas in yavejtih de kan Dios tlanavatia. Nochi tlamantli tlen te amo tiktekavilis ma mochiva nika itech nin tlaltikpaktli, Dios desde ilvikak noijki amo kitekavilis. Iva nochi tlamantli tlen te tiktekavilis ma mochiva itech nin tlaltikpaktli, Dios desde ilvikak noijki kitekavilis. ");
INSERT INTO nsu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ijkuakó Jesús okinnavati in momachtijkeh amika ma kitlapovikah kox yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ijkuakó Jesús ope kinyekilvia in momachtijkeh nik Ye kipia de yas Jerusalén iva ompa kitlajyoviltiskeh miek in tlayakankeh tetajmeh, noijki tlen tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés. Iva okinmilvi nik kixpoloskeh, pero ipan eyi tonali moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ijkuakó Pedro okivikak in Jesús se lado, iva ope kajva: —¡Amó, noTeko, amo Dios ma kimonekilti! ¡Amo ijkó ximochiva! ");
INSERT INTO nsu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús omokuapki iva okilvi in Pedro: —¡Ximachiva de Ne, Amo Kuali Tlakatl! ¡Amo techtzatzakuili! Porke amo mitztekipachova tlen Dios kineki, sino mitztekipachova tlen kinekih in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Satepa Jesús okinmilvi in momachtijkeh: —Tla íkka kineki vitz nonavak, moneki ayakmo ma kichiva san tlen ye kinekis. Kipia de kixikos nochi in tlajyovilistli maski ma kimiktikah itech krus, iva ma nechseguiro. ");
INSERT INTO nsu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iva tla íkka kinekis kimakixtis inemilis, kipolos. Pero tla íkka kipolos inemilis por Ne, kimakixtis inemilis. ");
INSERT INTO nsu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Porke amitla ipati tla se tlakatl yetos iaxka nochi in tlaltikpaktli, iva satepa kipolos ianima. Porke amitla onka itech nin tlaltikpaktli tlen ika velis kitlaxtlavas in tlakatl para kimakixtis ianima. ");
INSERT INTO nsu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porke iKone in Tlakatl vitz ivan ilvikaktlatitlaniltih ika imavissotlanex de iTajtzi iva ijkuakó kada se tlakatl kitlaxtlavis ijkó kemi tlen okichi. ");
INSERT INTO nsu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yi neli nimechilvia, ke sekimeh tlen nika kateh, amo mikiskeh asta kan amo ma kittakah iKone in Tlakatl yovala para tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chikuasen tonali satepa, Jesús okinvikak san yejvan Pedro, Jacobo ivan ikni tlen itoka Juan, iva oyajkeh ipan se tepetl wejkapa. ");
INSERT INTO nsu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iva Jesús ompa inmixpa omopatlak. Ixko opetlanki kemi tonali iva itzotzol omokuapki istak kemi se tlavili. ");
INSERT INTO nsu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iva ijkuakó ovalmonextijkeh in Moisés ivan Elías motlapovijtokeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijkuakó Pedro okilvi in Jesús: —NoTeko, sa tlawel kuali nika ma tiekah. Tla tikneki ma tikinchijchivakah eyi sakakaltih, se para tejwatzi, se para Moisés iva se para Elías. ");
INSERT INTO nsu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ijkuak ok ijkó otlapojtoka, ijkuakó se mixtli okinmokenki iva omokakki se tlajtoli de ijtik mixtli, okijto: —Nin yen noKone tlen niktlasojtla, tlen inavak nipaki. Xikakikah tlen Ye imechilvia. ");
INSERT INTO nsu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","In momachtijkeh ijkuak ijkó okikakkeh, omotlankuaketzkeh iva omixtlapachojkeh ipan tlali, iva sa tlawel omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ijkuakó Jesús omotoki innavak, okintlali imavah inpa iva okinmilvi: —Ximoketzakah, amo ximomavtikah. ");
INSERT INTO nsu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ijkuak oajkotlachixkeh, ayakmika okittakeh, sino sa yen Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ijkuak yotemotiayah de ipan tepetl, Jesús okinnavati: —Amika itla xiktlapovikah de tlen onkittakeh, asta ijkuak moyolitis iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ijkuakó in momachtijkeh okitlajtlanijkeh: —¿Tleka pues in tlamachtijkeh de itlanavatil Moisés kijtovah ke Elías yen achto kipia de vitz antes de vitz in Cristo? ");
INSERT INTO nsu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús okinnankili: —Yi neli, Elías achto vitz iva ye kiyektlalis nochi. ");
INSERT INTO nsu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero Ne nimechilvia ke Elías yovitza, iva yejvah amo okineltokakeh, sino okitoktijkeh san tlen yejvah okinekeh. Ijkó noijki kitlajyoviltiskeh iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ijkuakó in momachtijkeh okajsikamatkeh ke Jesús okintlapoviaya de Juan tlen tlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ijkuak oajsitoh kan okatkah in gentejtih, ijkuakó se tlakatl omotoki inavak Jesús, omotlankuaketzki iyakapa iva okilvi: ");
INSERT INTO nsu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—NoTeko, xikiknomati notelpoch, porke mimiki iva sa panova tlajyovia, yi miek welta vetzi ijtik tlitl iva ijtik atl. ");
INSERT INTO nsu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Onikinvalikili tlen tikinmachtia pero amo veli kipajtiah. ");
INSERT INTO nsu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús okijto: —¡Imejvah seppa amo intlaneltokah iva yonmijtlakavkeh! ¿Asta keman nietos imovah? ¿Asta keman nimechxikojtos? Nika techvalikilikah in telpochtli. ");
INSERT INTO nsu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ijkuakó Jesús okajvak in amo kuali ejekatl iva okiski de ijtik in telpochtli, iva san nima ijkuakó opajtik. ");
INSERT INTO nsu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Satepa in momachtijkeh omotlapovitoh se lado ivan Jesús. Iva okitlajtlanijkeh: —¿Tleka tejvah amo otivelikeh otikixtijkeh in amo kuali ejekatl? ");
INSERT INTO nsu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús okinmilvi: —Porke ok imechpolova miek para intlaneltokaskeh kemi moneki. Yi neli nimechilvia tla imejvah intlaneltokaskeh kemi moneki, maski imotlaneltokalis ma yeto tzikitzi kemi se semiyajtzi de mostaza, oveliskia onkilviskiah nin tepetl: “Ximijkuani de nika iva xivia ik nepa.” In tepetl omoijkuaniskia, iva nochi oveliskia onkichivaskiah. ");
INSERT INTO nsu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero nin tlamantli de amo kuali ejekameh velis se kinkixtis san ika diostzajtzilistli iva ika mosavalistli. ");
INSERT INTO nsu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Se tonali ijkuak ok okatkah kan región de Galilea, Jesús okinmilvi in momachtijkeh ke iKone in Tlakatl kitemaktiskeh inmak in tlaltikpaktlakah, ");
INSERT INTO nsu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iva kixpoloskeh, pero ipan eyi tonali moyolitis. Iva in momachtijkeh sa tlawel omoyolkokojkeh ijkuak ijkó okikakkeh. ");
INSERT INTO nsu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ijkuak Jesús ivan momachtijkeh oajsitoh Capernaum, tlen kobradortih de impuestos de kan templo oyajkeh okittatoh in Pedro, iva okitlajtlanijkeh: —¿Imotlamachti kox kitlaxtlava impuesto para in templo? ");
INSERT INTO nsu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro otlanankili: —Kema. Iva ijkuak Pedro okalakki kalijtik, yen Jesús achto okitlajtlani: —¿Kenomi tikitta, Simón? In wejwei tlanavatijkeh de nin tlaltikpaktli, ¿akinmeh kinkobrarovah impuesto? ¿Kinkobrarovah in gentejtih de inpaís o noso tlen vitzeh de oksé país? ");
INSERT INTO nsu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro okinankili: —Tlen vitzeh de oksé país. Jesús okilvi: —Tonses kijtosneki ke in gentejtih tlen povih itech inpaís amo kipia de kitlaxtlavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero maski amo techtokarova de tiktlaxtlavaskeh, iva para amika ma kualani, xivia kan atl tlen wei, xikajkava moansuelo ijtik atl, iva in michi tlen achto tikixtis, xiktlapoli ikamak iva ijtik tikajsis se tomi, iva ika xiktlaxtlava tlen de Ne noimpuesto iva tlen de te moimpuesto. ");
INSERT INTO nsu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ijkuakó in momachtijkeh omotokijkeh inavak Jesús, iva okitlajtlanijkeh: —¿Akin okachi weititok kan Dios tlanavatia? ");
INSERT INTO nsu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ijkuakó Jesús okinotzki se chokotzi, okitlali tlatlajko de kan yejvah okatkah, ");
INSERT INTO nsu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","iva okijto: —Yi neli nimechilvia, tla imejvah amo inmoyolkuapah iva tla amo inmokuapah kemi inkonemeh, amo inkalakiskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Por eso, tlen okachi weititok kan Dios tlanavatia, kijtosneki yen tlen motlalchitlalia iva mokuapa kemi nin chokotzi. ");
INSERT INTO nsu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Iva tlen kiselia ika notoka se chokotzi kemi nin, kijtosneki Ne nechselia. ");
INSERT INTO nsu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Tla íkka kichivas ma vetzi itech tlajtlakoli se de ninmeh tzitzintih tlen nechneltokah, okachi kuali ma kilpilikah se metlatl itech ikech iva ma konkajkavakah kan atl tlen wei kan okachi tlawejkatla. ");
INSERT INTO nsu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Prowestih in tlaltikpaktlakah porke onka miek tlamantli tlen kintoktia ma vetzikah itech tlajtlakoli. Iva amo keman tlamis yejón tlamantli. Pero ¡ay de neká tlakatl tlen kichivas íkka oksé ma tlajtlakolchiva! ");
INSERT INTO nsu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Por eso, tla moma o mokxi kichiva xivetzi itech tlajtlakoli, okachi kuali xiktzonteki iva wejka xiktlamotla. Porke okachi kuali xikalaki itech nemilistli timatepo o tiikxitepo, ke ma mitzontlamotlakah ika ome momavah o ika ome mokxivah ijtik tlitl tlen amo keman sevis. ");
INSERT INTO nsu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iva tla moixtololo kichiva xivetzi itech tlajtlakoli, okachi kuali xikmokixtili iva wejka xiktlamotla. Porke okachi kuali xikalaki itech nemilistli ika se moixtololo, ke ika ome moixtololovah ma mitzontlamotlakah miktla kan xotlatok in tlitl. ");
INSERT INTO nsu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’¡Xikpiakah kuidado! Amo xikyejyekokah ke ninmeh tzitzintih amitla inpati. Ne nimechilvia, ke in ilvikaktlatitlaniltih tlen kinkuidarovah nochipa ivan mottah noTajtzi tlen kajki ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Porke iKone in Tlakatl ovala okinmakixtiko tlen politokeh. ");
INSERT INTO nsu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Tlán inkiyejyekovah? Tla se tlakatl kinpia se siento ichkameh, iva tla okipolo se iichka, ¿amo kinkajteva ompa ipan tepetl in noventa y nueve iva yavi kitemoti tlen opolivik? ");
INSERT INTO nsu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iva tla okajsik, yi neli nimechilvia, ke okachi pakis por yejón ichka, ke por nekateh noventa y nueve tlen amo opolikeh. ");
INSERT INTO nsu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ijkó noijki imoTajtzi tlen kajki ilvikak amo kineki ma polivi nion se de ninmeh tzitzintih. ");
INSERT INTO nsu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tla se mokni mitztoktia itla amo kuali, xiknotza san ye iselti iva xikilvi tlen omitztokti. Tla mitzkaki, oksé welta velis tiknotzas kemi mokni. ");
INSERT INTO nsu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero tla amo kineki mitzkakis, ijkuakó xiknotza se o noso ome toknivah, para ke nochi tlen se kijtos ma kimatikah omeh o noso eyih kemi testigojtih. ");
INSERT INTO nsu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Iva tla nion yejvah amo kineki kinkakis, ijkuakó xikinmilvi nochtin toknivah tlaneltokakeh. Iva tla nion yejvah amo kineki kinkakis, tonses xikitta yejón tlakatl kemi se tlen amo judío o noso kemi se kobrador de impuestos. ");
INSERT INTO nsu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Yi neli nimechilvia, ke nochi tlamantli tlen imejvah amo inkitekaviliskeh ma mochiva nika itech nin tlaltikpaktli, Dios desde ilvikak noijki amo kitekavilis. Iva nochi tlamantli tlen imejvah inkitekaviliskeh ma mochiva nika itech nin tlaltikpaktli, Dios desde ilvikak noijki kitekavilis. ");
INSERT INTO nsu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Noijki nimechilvia, tla ome de imejvah inmotlaliskeh de akuerdo itech nin tlaltikpaktli para inkitlajtlaniskeh itla iva inmodiostzajtziliskeh, noTajtzi tlen kajki ilvikak imechmakas. ");
INSERT INTO nsu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porke kan mololovah omeh o eyih tlen nechneltokah, Ne noijki ompa invah nika. ");
INSERT INTO nsu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ijkuakó Pedro omotoki inavak Jesús iva okitlajtlani: —NoTeko, ¿keski welta moneki niktlapojpolvis se nokni tla onechtokti itla amo kuali? ¿Asta chikome welta? ");
INSERT INTO nsu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús okinankili: —Mach moneki xiktlapojpolvi san chikome welta, sino xiktlapojpolvi nochipa san keski welta monekis. ");
INSERT INTO nsu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Por eso, kan tlanavatia in Dios tlen kajki ilvikak yejón kemi oyeskia se wei tlanavati tlen okinekia kichivas kuenta ivan itlakevalvah. ");
INSERT INTO nsu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ijkuak ope kichiva kuenta, ijkuakó okivalikilijkeh se itlakeval tlen okivikiliaya miek miyones de tomi de plata. ");
INSERT INTO nsu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Komo itlakeval amo okipiaya tomi para kikuapilis, ijkuakó in wei tlanavati otlanavati ma kinemakakah yejón tlakatl ivan itonana, ivan ipilvah, iva nochi tlen kipia, para ika ma kitlaxtlava tlen kitevikilia. ");
INSERT INTO nsu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ijkuakó itlakeval omotlankuaketzki iyakapan wei tlanavati iva okitlatlavti: “Nimitztlatlavtia tejwatzi, ok techonchia iva nimitzkuapilis nochi tlen nimitzvikilia.” ");
INSERT INTO nsu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","In wei tlanavati okiknomatki, iva okitlapojpolvi de nochi tlen okivikiliaya iva okika ma via. ");
INSERT INTO nsu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero san nima ijkuak okiski yejón tlakatl, okinamikki se iyolikni tlen okivikiliaya san se siento tomi de plata. Okikitzki itech ikech iva ope kikechtlanpatzka, iva okilvi: “¡Techkuapili tlen techvikilia!” ");
INSERT INTO nsu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ijkuakó iyolikni omotlankuaketzki iyakapa iva okitlatlavti, okilvi: “Nimitztlatlavtia ok techonchia iva nimitzkuapilis nochi tlen nimitzvikilia.” ");
INSERT INTO nsu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ye mach okinekki kichias, sino yej okivikak okitzakuato telpiloya para ma kikuapili nochi tlen kivikilia. ");
INSERT INTO nsu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ijkuak ijkó okittakeh tlen oksekimeh itlakevalvah, sa tlawel omoyolkokojkeh. Iva oyajkeh okilvitoh in wei tlanavati tlen okittakeh. ");
INSERT INTO nsu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ijkuakó in wei tlanavati otlatitlanki ma kinotzatih itlakeval, iva okilvi: “¡Te amo kuali titlakevali! Ne onimitztlapojpolvi de nochi tlen otechvikiliaya porke otimotlatlavti nonavak. ");
INSERT INTO nsu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Te noijki otikiknomatiskia moyolikni, ijkó kemin ne onimitziknomatki.” ");
INSERT INTO nsu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","In wei tlanavati sa tlawel okualanki, iva otlanavati ma kitlajyoviltikah asta kan ma kitlaxtlava nochi tlen kitevikilia. ");
INSERT INTO nsu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús noijki okinmilvi: —NoTajtzi tlen kajki ilvikak, no ijkó imechtoktis imejvah tla amo inkintlapojpolviskeh imoknivah ika nochi inmoyolo. ");
INSERT INTO nsu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ijkuak Jesús otlanki okijto nochi nin tlajtoli, okiski de Galilea iva oyá ik itempan tlali de Judea, ik nepa lado de kan weyatl Jordán ik kan valkisa in tonali. ");
INSERT INTO nsu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sa tlawel miekeh gentejtih oyajkeh ivan Jesús. Iva Jesús ompa okinpajti tlen omokokovayah. ");
INSERT INTO nsu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ijkuakó sekimeh fariseos omotokijkeh inavak Jesús para kiyejyekoskeh, iva okitlajtlanijkeh: —¿Kox kuali se tlakatl kikajkavas itonana san ika itlajtzi? ");
INSERT INTO nsu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús okinnankili: —¿Amo inkilerovah in Tiotlajkuiloli kan kijtova ijkuak Dios ope kichiva in tlaltikpaktli, iva ijkuakó noijki okichi in tlakatl ivan sivatl? ");
INSERT INTO nsu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","In Tiotlajkuiloli noijki kijtova: “Por eso in tlakatl kikavas ipapa ivan imama iva mosetilis ivan itonana, iva de omeh mochivas sa se tlakatl.” ");
INSERT INTO nsu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tonses, ayakmo yetoskeh omeh, sino sa se. Por eso, tla Dios yokinsetili se tlakatl ivan se sivatl, amika ma kinxelo. ");
INSERT INTO nsu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ijkuakó in fariseos okitlajtlanijkeh: —¿Tonses, tleka Moisés otechkajtevili se tlanavatili kan kijtova tla íkka tlakatl kineki kikajkavas itonana, moneki ma kimaka se amatl kan ma kijto nik kikajkava itonana? ");
INSERT INTO nsu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús okinmilvi: —Moisés okitekavili xikinkajkavakah imotonanavah porke imejvah amo inkimatih intlakakih, pero achto amo ijkó okatka. ");
INSERT INTO nsu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne nimechilvia: tla se tlakatl kikajkava itonana tlen amo semi kikajkayava íkka iva, iva monamiktia ivan oksé sivatl, kijtosneki kichiva imosa. Iva tla íkka monamiktis ivan sivatl tlen yokikajkajkeh, kijtosneki kichiva imosa. ");
INSERT INTO nsu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tlen momachtijkeh okilvijkeh in Jesús: —Tla nenamiktilistli amo velis se kikotonas, tonses okachi kuali amo ma se monamikti. ");
INSERT INTO nsu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ijkuakó Jesús okinnankili: —Amo nochtin velis kixikoskeh yetoskeh inselti, sino san yejvah tlen kajsikamatih nik in Dios ijkó kineki ma mokavakah inselti. ");
INSERT INTO nsu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Onkateh sekimeh tlakah desde nesih de por sí amo velis kinpiaskeh inpilvah, iva por eso amo monamiktiah. Sekimeh amo monamiktiah porke okintoktijkeh amo ma velikah ma kinpiakah inpilvah. Iva sekimeh amo kinekih monamiktiskeh porke kinekih tekipanoskeh para Dios kan Ye tlanavatia. Por eso, nin tlamachtili san para yejvah tlen kinekih mokavaskeh inselti. ");
INSERT INTO nsu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Satepa okinvalikilijkeh in Jesús sekimeh konemeh para ma kintlali imavah inpa iva ma modiostzajtzili por yejvah, pero in momachtijkeh ope kinmajvah tlen okinvalikayah in konemeh. ");
INSERT INTO nsu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iva Jesús okinmilvi: —Xikinkavakah in konemeh ma vikikah nonavak iva amo xikintzatzakuilikah. Porke tlen kateh kemi ninmeh konemeh, yejvah poviskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús okintlali imavah ipan konemeh iva omodiostzajtzili por yejvah, iva satepa oyá de ompa. ");
INSERT INTO nsu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Se tlakatl omotoki inavak Jesús iva okitlajtlani: —Tlamachti, ¿katlen tlamantli kuali tlen moneki nikchivas para velis nikpias nemilistli para semijkak? ");
INSERT INTO nsu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús okinankili: —¿Tleka techtlajtlania katlen tlamantli kuali tlen moneki tikchivas? Onka san se tlen kuali, yen Dios. Pero tla tikneki tikpias nemilistli para semijkak, moneki xikchiva tlen itlanavatil in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","In telpochtli okilvi in Jesús: —¿Katlen yejmeh? Jesús okinankili: —Amo xitemikti, amo xiavilnemi itech tlajtlakoli, amo xitlachteki, amo xikijto tlen amo neli innavak oksekimeh, ");
INSERT INTO nsu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","xiktlakita mopapa ivan momama, iva xiktlasojtla mokni ijkó kemi te timotlasojtla. ");
INSERT INTO nsu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","In telpochtli okinankili: —Nochi yejón nikchijtivitz desde nichokko, ¿tlán okachi moneki nikchivas? ");
INSERT INTO nsu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús okilvi: —Tla yi neli tikneki tietos tiyektik, xivia mokalijtik iva xiknemaka nochi tlen tikpia iva in tomi xikinmaka tlen prowestih. Ijkó velis tikpias rikojyotl itech ilvikak. Iva ijkuakó kema xiviki iva techseguiro. ");
INSERT INTO nsu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero in telpochtli ijkuak ijkó okikakki, oyá omoyolkokojtia, porke okatka sa tlawel tomine. ");
INSERT INTO nsu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ijkuakó Jesús okinmilvi in momachtijkeh: —Yi neli nimechilvia, se tlen tomine sa tlawel ovijtitok para kalakis kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oksemi nimechilvia, ke okachi amo ovi panos se kameyo kan ixtololo se aguja, ke se tomine ma veli ma kalaki kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ijkuak in momachtijkeh okikakkeh nin tlajtoli, sa otlatlachixkeh iva okimolviayah entre yejvah: —Tonses, ¿akin velis momakixtis? ");
INSERT INTO nsu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús okintlajtlatak iva okinmilvi: —Nin tlamantli in tlaltikpaktlakah amo veli kichivah, pero Dios nochi veli kichiva. ");
INSERT INTO nsu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ijkuakó Pedro okilvi: —Tejvah otikajtejkeh nochi tlen otikpiayah porke tiknekih timitzseguiroskeh. ¿Tlán velis tikpiaskeh satepa? ");
INSERT INTO nsu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús okinmilvi: —Yi neli nimechilvia, itech nekateh tonaltih ijkuak nochi moyankuilis, ijkuak iKone in Tlakatl motlalis itech itekivajsiya tlen kipia mavissotlanextli, imejvah tlen onnechseguirojkeh, inmotlaliskeh noijki itech majtlaktli ivan ome tekivajsiyajtih para inkinmixkomakaskeh tlen majtlaktli ivan ome familias de Israel. ");
INSERT INTO nsu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iva nochtin tlen okikajtejkeh inkal, inmiknivah, inveltivah, intajvah, intonanavah, inpilvah o noso intlalvah por Ne, kiseliskeh sien veses okachi de nochi tlen okikajtejkeh, iva kiseliskeh se yankuik nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero miekeh tlen axka kateh achto satepa yeskeh asta sa ik tlami, iva tlen axka kateh asta sa ik tlami satepa yejvah yeskeh achto. ");
INSERT INTO nsu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Kan Dios tlanavatia, panolo ijkó kemi omochi se tekova tlen okitookak uvas itlala. Okiski san kualka okintemoto sekimeh tlakevaltih para ma tekipanotih itlala. ");
INSERT INTO nsu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iva omoka de akuerdo ivan tlakevaltih ke kintlaxtlavis se denario ijkó kemi motlani de se tonali, iva okintitlanki ma tekipanotih itlala. ");
INSERT INTO nsu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Satepa in tekova okiski kemi las nueve de kualka, iva okinmitak tiankistli oksekimeh tlen omajxilijtokah. ");
INSERT INTO nsu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iva okinmilvi: “Imejvah noijki xiviah xitekipanotih notlala, iva nimechtlaxtlavis ijkó kemi moneki.” Iva yejvah oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","In tekova oksemi okiski kemi tlajko tonali, iva noijki kemi las tres de tiotlaki, okintlakevato oksekimeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Iva kemi las sinko de tiotlaki, oksemi okiski okintemoto oksekimeh iva okinmajsik sekimeh tlen omajxilijtokah, iva okintlajtlani: “¿Tleka nika yontiotlakijkeh iva amo intekipanovah?” ");
INSERT INTO nsu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yejvah okinankilijkeh: “Porke amika techtlakeva.” Ijkuakó ye okinmilvi: “Imejvah noijki xiviah xitekipanotih notlala, iva nimechtlaxtlavis tlen moneki inkitlaniskeh.” ");
INSERT INTO nsu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ijkuak otlayovak, in tekova okilvi in tlakatl tlen kitta in tekitl: “Xikinnotza in tlakevaltih iva xikintlaxtlavi, achto xikintlaxtlavi tlen okalakeh satepa, iva satepa xikintlaxtlavi tlen achto okalakeh.” ");
INSERT INTO nsu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ijkuakó ovalajkeh in tlakevaltih tlen okalakeh kemi las sinko de tiotlaki, iva kada se de yejvah okintlaxtlavijkeh ika sejsen denario ijkó kemi motlani de se tonali. ");
INSERT INTO nsu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iva ijkuak okintokaroto kintlaxtlaviskeh in tlakevaltih tlen achto okalakeh, yejvah okiyejyekojkeh xamo kintlaxtlaviskeh okachi. Pero yejvah noijki okintlaxtlavijkeh ika sejsen denario. ");
INSERT INTO nsu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Por eso ijkuak okiselijkeh intlaxtlavil yejvah amo okivelitakeh kenik okintlaxtlavi in tekova, ");
INSERT INTO nsu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","iva okilvijkeh: “Nekateh tlen okalakeh satepa otekipanojkeh san se ora, iva otikintlaxtlavi kemi tejvah tlen ajsitok se tonali otitekipanojkeh ixko tonali.” ");
INSERT INTO nsu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","In tekova okinankili se de yejvah: “Techkaki noknitzi, ne mach itla nimitztoktia tlen amo kuali. ¿Amo otimokajkeh ke otiktlaniskia se denario? ");
INSERT INTO nsu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xikitzki motlaxtlavil iva xivia. Ne nikneki nikmakas tlen satepa oniktlake noijki kemi te onimitzmakak. ");
INSERT INTO nsu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Amo velis nikchivas ika notomi san tlan ne niknekis? ¿O noso timoxikova por nitlakamela?” ");
INSERT INTO nsu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Ijkó pues, tlen axka kateh achto satepa yeskeh asta sa ik tlami, iva tlen axka kateh asta sa ik tlami satepa yejvah yeskeh achto. Porke miekeh tlen tlanotzaltih pero san sekimeh tlen tlapejpenaltih. ");
INSERT INTO nsu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ijkuak Jesús yoyaya itech ojtli para Jerusalén, ijkuakó okinvikak se lado in majtlaktli ivan ome momachtijkeh iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Xikakikah, axka tiavih Jerusalén, kan iKone in Tlakatl kitemaktiskeh inmak in tlayakankeh tiopixkeh, iva inmak in tlamachtijkeh de itlanavatil Moisés, iva yejvah kitlajtlakoltiskeh para ma kixpolokah. ");
INSERT INTO nsu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kitemaktiskeh inmak tlen amo judiojtih para ma kipijpinatikah, para ma kivitekikah iva para ma kixpolokah itech krus. Pero ipan eyi tonali moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ijkuakó itonana in Zebedeo omotoki inavak Jesús ivan ome itelpochvah, iva omotlankuaketzki iyakapa para kitlajtlanilis se netlatlavtili. ");
INSERT INTO nsu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús okitlajtlani: —¿Tlán tikmonekiltia? In teena okilvi: —Nimitztlatlavtia, ijkuak pevas titlanavatis, xikinkavili ma motlalikah ninmeh omeh notelpochvah se ik moyekmapa iva oksé ik moopochmapa. ");
INSERT INTO nsu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús okinankili: —Imejvah amo inkimatih tlen inkitlajtlanih. ¿Kox velis inkoniskeh in kopa de tlajyovilistli tlen Ne nikonis? ¿Kox velis inmobautisaroskeh kemin Ne nimobautisaros ika nochi tlen tekoko? Yejvah okinankilijkeh: —Tiveliskeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús okinmilvi: —Yi neli, imejvah inkoniskeh in kopa de tlajyovilistli ijkó kemin Ne nikonis, iva inmobautisaroskeh ijkó kemin Ne nimobautisaros ika nochi tlen tekoko. Pero tla inmotlaliskeh ik noyekmapa o noso ik noopochmapa, mach Ne nikijtos, yen noTajtzi kinmilvis ompa ma motlalikah tlen Ye yokinpejpenki. ");
INSERT INTO nsu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tlen oksekimeh majtlaktli momachtijkeh ijkuak ijkó okikakkeh, okualankeh innavak tlen omeh iknimeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús okinnotzki iva okinmilvi: —Imejvah kuali inkimatih ke in kobiernojtih de nin tlaltikpaktli, kivelitah kiteititiskeh nik yejvah tlanavatiah. Iva intlakavah tlen okachi tlayakantokeh noijki kivelitah tlanavatiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero entre imejvah amo ijkó kipia de yetos. Tla se de imejvah kineki weititos, kipia de imechpalevis. ");
INSERT INTO nsu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iva tla entre imejvah íkka kineki yen tlayakantos, moneki ma tekipano imonavak kemi tlakevali. ");
INSERT INTO nsu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ijkó noijki, iKone in Tlakatl amo ovala para ma kipalevikah, sino ovala para tlapalevis iva para kitemakas inemilis tlen ika kitlaxtlavas innemakixtilis de miekeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ijkuak yejvah yokistiayah de Jericó, miekeh gentejtih okitokayah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Itempan ojtli oyetokah ome tlakah tlen amo otlachiayah. Iva ijkuak yejvah okikakkeh nik Jesús ik ompa panova, okitzajtzilijkeh chikavak: —¡ToTeko, iKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","In gentejtih okoninmajvakeh para ayakmo ma tzajtzikah, pero yejvah okachi okitzajtzilijkeh chikavak: —¡ToTeko, iKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ijkuakó Jesús omoketzki, okinnotzki in tlakah tlen amo otlachiayah iva okintlajtlani: —¿Tlán inkinekih ma nikchiva por imejvah? ");
INSERT INTO nsu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yejvah okilvijkeh: —ToTeko, tiknekih titlachiaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús okinmiknomatki, okitlali ima kan inmixtololovah, iva san nima ijkuakó ovelik otlachixkeh, iva okitokakeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ijkuak yoonajsiah Jerusalén, oajsitoh kan altepetl itoka Betfagé, tlen kajki inakastlan tepetl tlen itoka Olivos, iva ijkuakó Jesús okintitlanki ome momachtijkeh, ");
INSERT INTO nsu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iva okinmilvi: —Xiviah itech neká altepetl tlen kajki tlayakapa. Ompa inkajsitivih se burra ilpitok ivan ikonezti. Xikintotomakah iva techinvalikilikah. ");
INSERT INTO nsu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Iva tla íkka imechtlajtlania tleka inkintotomah, xikilvikah nik yen toTeko kinneki, iva san nima imechoninkavilikih. ");
INSERT INTO nsu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ijkó opanolok para ma mochiva tlen okijto in tiotenejmachti: ");
INSERT INTO nsu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xikinmilvikah in gentejtih de Sión: “Xikittakah, nimowei tlanavati ompa vitz imonavak, yolyamanki, yetivitz ipan se burro, ipan se burrojtzi, ikone in burra tlen tlamama.” ");
INSERT INTO nsu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ijkuakó in momachtijkeh oyajkeh iva okichijkeh ijkó kemi Jesús okinnavati. ");
INSERT INTO nsu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Okinvalikakeh in burra ivan burrojtzi. Iva intlakenvah tlen okinmokentiayah ope kinkentiah in yejonmeh burrojtzitzintih, iva satepa Jesús omotlali ipan burrojtzi. ");
INSERT INTO nsu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iva sa tlawel miekeh gentejtih oyayah ivan Jesús, sekimeh okinsojtiayah ipan ojtli intlakenvah tlen okinmokentiayah iva oksekimeh okintekiah imamayovah in kuanmeh iva okinsojtiayah ipan ojtli. ");
INSERT INTO nsu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","In gentejtih tlen otlayakanayah, iva tlen oyayah tlakuitlapa, okijtojtiayah chikavak: —¡Viva ikone in wei tlanavati David! ¡Ma Dios kitiochiva tlen vitz ika itoka in toTeko! ¡Viva in Dios tlen kajki ilvikak! ");
INSERT INTO nsu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ijkuak Jesús okalakki Jerusalén, in gentejtih omopajsolojkeh iva ope motlajtlaniah: —¿Akin nin tlakatl? ");
INSERT INTO nsu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iva in gentejtih okijtovayah: —Nin yen tiotenejmachti Jesús de altepetl Nazaret tlen kajki kan tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Satepa Jesús okalakki kan toYejwatzi itemplo ik kiavak, iva okinkixti nochtin tlen otlakojtokah iva tlen otlanemakatokah. Okintlatlamochili inmesajvah tlen okipatlayah tomi, iva okintlatlamochili insiyajvah tlen okinnemakayah palomaxtih. ");
INSERT INTO nsu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iva okinmilvi: —Itech Tiotlajkuiloli kijtova: “Nokal kinotzaskeh kali kan modiostzajtziliah in gentejtih.” Pero imejvah yonkikuapkeh kemi se kali de ichtekeh. ");
INSERT INTO nsu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ompa kan templo omotokijkeh inavak Jesús sekimeh tlen amo otlachiayah iva sekimeh koxomeh, iva Jesús okinpajti. ");
INSERT INTO nsu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero in tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés, sa tlawel okualankeh ijkuak okinmitakeh in tetzavimeh tlen Jesús okinchivaya, iva ijkuak okinkakkeh in konemeh okijtovayah chikavak ompa kan templo: “¡Viva ikone in wei tlanavati David!” ");
INSERT INTO nsu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iva okilvijkeh in Jesús: —¿Tikaki tlán kijtovah ninmeh konemeh? Jesús okinnankili: —Kema, nikinkaki. ¿Ke amo kema inkilerovah in Tiotlajkuiloli kan tlapova de nin tlamantli? Kan kijtova: Tejwatzi otikchi ke in konemeh iva tlen ok chichih, ma mitztlakuikilikah. ");
INSERT INTO nsu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ijkuakó Jesús okinkajte, okiski de Jerusalén iva oyá kan altepetl de Betania iva ompa omoka yejón yovak. ");
INSERT INTO nsu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Omostlatik kualkanpa ijkuak Jesús yoyaya oksemi para Jerusalén, otiojsi. ");
INSERT INTO nsu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ijkuakó okittak se igoskuavitl itempan ojtli, omotoki para kitekis seki igos, pero amo okajsik nion se igos, sino okipiaya san puro ixivyo. Ijkuakó Jesús okilvi yejón igoskuavitl: —¡Ayakmo kema xiktlakilti igos! Iva san nima ijkuakó in igoskuavitl ovaki. ");
INSERT INTO nsu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ijkuak in momachtijkeh ijkó okittakeh, sa otlatlachixkeh iva okitlajtlanijkeh in Jesús: —¿Kenik san nima ovaki in igoskuavitl? ");
INSERT INTO nsu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús okinnankili: —Yi neli nimechilvia, tla imejvah intlaneltokah iva amo inmoyoloomeviah, amo san yen igoskuavitl velis inkivatzaskeh kemin Ne onikchi, sino asta velis inkilviskeh nin tepetl: “Ximachiva de nika iva ximotlamotla kan atl tlen wei”, iva ijkó mochivas. ");
INSERT INTO nsu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tla imejvah intlaneltokah, tonses Dios imechmakas nochi tlen inkitlajtlaniliskeh ijkuak inmodiostzajtziliskeh. ");
INSERT INTO nsu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ijkuakó Jesús okalakito kan templo de Jerusalén iva ijkuak otlamachtijtoka, ovalmotokijkeh inavak sekimeh tlayakankeh tiopixkeh iva sekimeh tlayakankeh tetajmeh judiojtih iva okitlajtlanijkeh: —¿Ken timixevia tikchiva nin tlamantli? ¿Akin omitzmakak tlanavatijkayotl para ijkó xikchiva? ");
INSERT INTO nsu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús okinnankili: —Ne noijki nimechtlajtlanis se tlajtoli, iva tla imejvah innechnankiliskeh, tonses Ne noijki nimechilvis akin onechnavati ijkó ma nikchiva. ");
INSERT INTO nsu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Techilvikah, ¿akin okinavati in Juan ma tlabautisaro? ¿Yen Dios okinavati o noso íkka tlakatl okinavati? Ijkuakó yejvah ope moichtakatlapoviah iva okimolviayah: —Tla tikijtoskeh ke Dios okinavati, Ye techilvis: “¿Tonses tleka amo inkineltokakeh?” ");
INSERT INTO nsu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iva tla tikijtoskeh ke okinavati íkka tlakatl, kualaniskeh nochtin iva velis itla techtoktiskeh, porke nochtin kineltokah ke Juan okatka tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ijkuakó okinankilijkeh in Jesús: —Mach tikmatih. Iva Jesús noijki okinnankili: —Ne noijki amo nimechilvis akin onechmakak tlanavatijkayotl para ma nikchiva nin tlamantli. ");
INSERT INTO nsu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús okinmilvi: —¿Tlán inkiyejyekovah de nin tlen nimechtlapovis? Se tlakatl okinpiaya ome ipilvah, iva se de yejvah okilvi: “Nokone, xivia xitekipanoti totlala kan uvajyo.” ");
INSERT INTO nsu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ipiltzi okinankili: “¡Mach nias!” Pero satepa okipatlak itlayejyekol iva oyá otekipanoto. ");
INSERT INTO nsu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Satepa in teta noijki okilvi tlen oksé ipiltzi ma via ma tekipanoti itlala, iva ipiltzi okinankili: “Kema, papa, nias.” Pero mach oyá. ");
INSERT INTO nsu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Katli ye de yejonmeh omeh okichi tlen okinekia in teta? Yejvah okijtojkeh: —Tlen achto okinavati. Ijkuakó Jesús okinmilvi: —Yi neli nimechilvia, ke in kobradortih de impuestos iva in avilsivameh, yejvah achto kalakiskeh ke imejvah kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porke in Juan tlen tlabautisaro ovala omechmachtiko kenik moneki inviviroskeh kemi Dios kineki, iva imejvah amo onkineltokakeh. Pero in kobradortih de impuestos iva in avilsivameh yejvah okineltokakeh. Pero imejvah maski onkittakeh ke yejvah omoyolkuapkeh, imejvah amo onkineltokakeh iva nion amo onmoyolkuapkeh. ");
INSERT INTO nsu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xikakikah nin oksé ejemplo: Okatka se tekova tlen okitookak uvas itlala iva nochi okitlatzakui. Okichi se tanke para ompa kipatzkas uvas, iva okichi se torre para ompa tlejkos para kikuidaros itlala. ’Satepa okintlaneti sekimeh tekipanojkeh para ma kikuidarokah iva satepa kimakaskeh seki de tlen tlakis, iva ye oyá wejka. ");
INSERT INTO nsu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ijkuak oajsik tonali para tlatekiskeh ika uvas, ijkuakó okintitlanki sekimeh itlakevalvah para ma kikuitih tlen kitokarova. ");
INSERT INTO nsu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero nekateh tekipanojkeh okinkitzkijkeh itlakevalvah in tekova. Se de yejvah okimagakeh ika maitl, oksé okimiktijkeh, iva oksé okimagakeh ika tetl. ");
INSERT INTO nsu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","In tekova oksemi okintitlanki oksekimeh itlakevalvah, okachi miekeh ke achto. Iva yejvah no ijkó okintoktijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Sa ik tlami, okititlanki ipiltzi, okijto: “Nopiltzi yi neli kitlakitaskeh.” ");
INSERT INTO nsu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ijkuak nekateh tekipanojkeh okittakeh ipiltzi in tekova, in tekipanojkeh okimolvijkeh: “Nin ipiltzi yen kimokavis nin tlali kemi erensia. Ma tikmiktikah para tejvah tikmokaviskeh in tlali.” ");
INSERT INTO nsu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tonses in tekipanojkeh okikitzkijkeh ipiltzi in tekova, okikixtijkeh de itlala iva okimiktijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ijkuakó Jesús okintlajtlani: —Ijkuak vitz in tekova, ¿imejvah tlán inkiyejyekovah? ¿Tlán velis kintoktis nekateh tekipanojkeh? ");
INSERT INTO nsu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yejvah okinankilijkeh: —Kinmiktis in tekipanojkeh amo kualmeh iva amo kinmiknomatis. Iva satepa kintlanetis iuvajyo oksekimeh tekipanojkeh, iva yejvah kimakaskeh tlen kitokarova ijkuak tlatekiskeh ika uvas. ");
INSERT INTO nsu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús okinmilvi: —¿Amo inkilerovah tlen kijtova in Tiotlajkuiloli? In Tiotlajkuiloli kijtova: In tetl tlen kalchijkeh amo okivelitakeh, omokuapki yen tetl tlen okachi kichikajtok in kali. Nin tlamantli yen toTeko ijkó okichi, iva tikittah sa panova kualtzi. ");
INSERT INTO nsu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Por eso nimechilvia, ke Dios imechkixtilis imejvah in derecho de inpoviskeh kan Ye tlanavatia, iva kinmakas oksekimeh tlen kichivaskeh nochi tlen Dios kineki. ");
INSERT INTO nsu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tlen akin vetzis ipan nin tetl, pojpostekis. Iva tla in tetl vetzis íkka ipa, kikuejkuechos. ");
INSERT INTO nsu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ijkuak in tlayakankeh tiopixkeh ivan fariseos okinkakkeh ninmeh ejemplos tlen Jesús okijto, okimomakakeh kuenta nik yejvah okinmilvijtoka. ");
INSERT INTO nsu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ijkuakó okinekiah kikitzkiskeh in Jesús, pero okinmiimakasiah in gentejtih, porke in gentejtih okineltokayah ke Jesús Ye tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús oksemi ope kintlapovia ika ejemplos iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Kan Dios tlanavatia, yejón kemi se wei tlanavati tlen okichi se ilvitl ijkuak okinamikti itelpoch. ");
INSERT INTO nsu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Iva okintitlanki itlakevalvah ma kinnotzatih tlen okinminvitaro, pero tlen okinminvitaro amo okinekeh oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Oksemi okintitlanki oksekimeh itlakevalvah iva okinmilvi: “Xikinmilvikah tlen onikinminvitaro ke yi kajki listo in tlakuali. Yonikinmikti notorojvah iva noyolkavah tlen okachi tojtomavakeh, iva nochi yi kajki listo, ma sa valmuikakah nika itech ilvitl.” ");
INSERT INTO nsu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero tlen okinminvitarojkeh amo okichijkeh kuenta. Se oyá otekipanoto itlala, oksé oyá otlanemakato, ");
INSERT INTO nsu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","iva oksekimeh okinkitzkijkeh itlakevalvah in wei tlanavati, okinvitekeh iva okinmiktijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ijkuakó in wei tlanavati yi neli okualanki, iva okinnavati isoldadojvah ma kinmijmiktikah tlen otemiktijkeh iva ma kichichinokah inmaltepe. ");
INSERT INTO nsu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Satepa okinmilvi itlakevalvah: “In tlakuali ya yi kajki, pero nochtin tlen onikinminvitaro amo intech opovia para nikan yeskeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xiviah itech ojmeh kan eskinajtih iva xikinminvitarokah nochtin tlen inkinmajsiskeh, iva ma vikikah nika itech ilvitl.” ");
INSERT INTO nsu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","In tlakevaltih okinmololojkeh nochtin tlen okinmajsikeh itech ojtli, tlen kualmeh iva tlen amo kualmeh. Iva ijkó nochi in kali kan monamiktiah otenki de nochtin tlen okinminvitarojkeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ijkuak in wei tlanavati okalakki okinmitato tlen okinminvitarojkeh, okittak ompa okatka se tlakatl tlen amo omotzotzolti kemi omonekia para velis yetos itech yejón ilvitl. ");
INSERT INTO nsu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","In wei tlanavati okitlajtlani: “A ver te tlakatl, ¿kenik otikalakki iva amo otimotzotzolti kemi moneki para velis tietos itech nin ilvitl?” In tlakatl ayakmo ovelik otlanankili. ");
INSERT INTO nsu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ijkuakó in wei tlanavati okinmilvi tlen otlaservirojtokah: “Xikijilpikah itech ikxivah iva itech imavah, iva xiktlamotlakah kiavak kan tlayova, kan chokas iva motlantekis.” ");
INSERT INTO nsu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porke miekeh tlen tlanotzaltih pero san sekimeh tlen tlapejpenaltih. ");
INSERT INTO nsu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","In fariseos okiskeh de ompa de kan Jesús otlamachtijtoka. In fariseos omololojkeh iva omotlatlalvijkeh para kittaskeh tlán velis kitlajtlaniiskeh in Jesús para ma kijto itla tlen amijtok, iva ijkó velis kiteilviskeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Satepa, sekimeh momachtijkeh de yejvah in fariseos iva sekimeh tlen opoviah ivan Herodes, okintitlankeh para ma kilvitih in Jesús: —Tlamachti, tikmatih ke tejwatzi tikijtova tlen yi neli, iva yi neli titlamachtia kenik se nemis kemi Dios kineki. Amo tikinmiimakasi in gentejtih de tlan kiyejyekovah de tejwatzi. Tejwatzi tikinmita in gentejtih nochtin iwalestih. ");
INSERT INTO nsu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Techilvi, pues, tejwatzi ken tikitta: ¿Kox kuali se kitlaxtlavas impuestos para in wei tekiva César, o noso amo? ");
INSERT INTO nsu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús yokimatia ke yejvah san ik mochivah, iva okinmilvi: —¿Tleka inkinekih ma nikijto itla tlen amijtok? ¡Imejvah inkipiah ome inmoixko! ");
INSERT INTO nsu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Techititikah se tomi tlen ika inkitlaxtlavah impuesto. Yejvah okimakakeh se tomi itoka denario. ");
INSERT INTO nsu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iva ijkuakó Jesús okintlajtlani: —¿De akin ixko iva akin itoka tlen nestok itech nin tomi? ");
INSERT INTO nsu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yejvah okinankilijkeh: —De César. Ijkuakó Jesús okinmilvi: —Xikmakakah in César tlen itech povi in César, iva xikmakakah in Dios tlen itech povi in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ijkuak ijkó okikakkeh, omotetzavijkeh. Ayakmitla okijtojkeh iva mejor oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yejón tonali noijki sekimeh saduceos tlen kijtovah ke in mikameh amo velis moyolitiskeh, omotokijkeh inavak Jesús iva okitlajtlanijkeh: ");
INSERT INTO nsu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tlamachti, Moisés okijto tla se tlakatl tlen yomonamikti iva ixpolivi iva amo okinpixki ipilvah, ikni in difunto kipia de monamiktis ivan iknosivatl para ivan kinpias ipilvah kemi oyeskia ipilvah in difunto. ");
INSERT INTO nsu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tonses, nika itech toaltepe okatkah chikome iknimeh tlakah. Tlen tetiachka omonamikti, iva satepa oixpolivik iva amo okinpixki ipilvah. Tlen kivaltoka omonamikti ivan iknosivatl. ");
INSERT INTO nsu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero ye noijki oixpolivik. Iva satepa noijki ijkó omochi oksé tlen kivaltoka, iva ijkó omochijkeh nochtin chikome iknimeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iva satepa de oixpolikeh nochtin yejonmeh chikome iknimeh, noijki oixpolivik in sivatl. ");
INSERT INTO nsu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tonses, ijkuak moyolitiskeh in mikameh, ¿katli ye de nochtin yejonmeh chikome iknimeh yetos itonana? Porke nochtin chikome iknimeh omonamiktijkeh ivan yejón sivatl. ");
INSERT INTO nsu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús okinmilvi: —Imejvah amo inkimatih tlen inkijtovah. Amo inkimatih tlen kijtova in Tiotlajkuiloli iva nion amo inkixmatih ivelitilis in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porke ijkuak moyolitiskeh in mikameh, in tlakah ivan sivameh mach ok monamiktiskeh, porke yeskeh kemi ilvikaktlatitlaniltih de Dios tlen kateh ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero komo yi timotlapovijtokeh de moyolitiskeh in mikameh, ¿amo semi inkilerovah tlen Dios omechilvi? Ye okijto: ");
INSERT INTO nsu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ne niDios de Abraham, de Isaac iva de Jacob.” In Dios amo Dios de mikameh sino de tlen yolitokeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","In gentejtih ijkuak ijkó okikakkeh, sa otlatlachixkeh de kenik okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ijkuak in fariseos okimatkeh ke Jesús okinkamatzaki in saduceos, ijkuakó yejvah omololojkeh. ");
INSERT INTO nsu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Se de yejvah tlen okatka tlamachti de tlanavatili okinekia kiyejyekos in Jesús para kittas tlan kijtos. Iva okitlajtlani: ");
INSERT INTO nsu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tlamachti, ¿katli yen tlanavatili okachi weititok de itlanavatil Moisés? ");
INSERT INTO nsu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús okilvi: —“Xiktlasojtla moTeko Dios ika nochi moyolo, ika nochi moanima iva ika nochi motlalnamikilis.” ");
INSERT INTO nsu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ye nin tlanavatili tlen okachi tlayakantok de nochtin iva okachi weititok. ");
INSERT INTO nsu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iva onka oksé tlanavatili tlen noijki weititok, kijtova: “Xiktlasojtla mokni kemi te timotlasojtla.” ");
INSERT INTO nsu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nochi tlen kijtova itlanavatil Moisés iva nochi tlen okijkuilojkeh in tiotenejmachtijkeh, mokitzkiah itech ninmeh ome tlanavatiltih. ");
INSERT INTO nsu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iva mientras ok ompa oololitokah in fariseos, Jesús okintlajtlani, ");
INSERT INTO nsu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","okinmilvi: —¿Tlán inkiyejyekovah imejvah aserka de Cristo? ¿Akin ikone? Yejvah okilvijkeh: —Yen ikone in wei tlanavati David. ");
INSERT INTO nsu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ijkuakó Jesús okinmilvi: —Tonses, ¿tleka in David por medio de Tioijyotzintli okilvi “noTeko”? Porke David okijto: ");
INSERT INTO nsu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dios omotlapovi ivan noTeko, okilvi: “Ximotlali ik noyekmapa, asta kan ma nikintlali itlampa mokxivah tlen mitztlavelitah.” ");
INSERT INTO nsu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tla inevia in David okinotzki in Cristo iTeko, ¿tonses kenik ma yeto ikone? ");
INSERT INTO nsu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iva amika omixevi okinankili nion se tlajtoli. Iva desde yejón tonali ayakmo omixevijkeh okitlajtlanijkeh ok itla. ");
INSERT INTO nsu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ijkuakó Jesús okinmilvi in gentejtih iva tlen momachtijkeh: ");
INSERT INTO nsu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—In tlamachtijkeh de tlanavatili ivan fariseos yejvah kiteajsikamatiltiah in tlanavatili ika itlanavatijkayo Moisés. ");
INSERT INTO nsu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tonses, imejvah xikchivakah nochi tlen yejvah imechmachtiskeh, pero amo xikchivakah tlen yejvah kichivah porke yejvah amo kichivah tlen kijtovah. ");
INSERT INTO nsu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yejvah kintlamamaltiah in gentejtih ika tlamamali tlen etik iva ovi para se kivikas, pero yejvah amo kinekih koliniskeh nion se inmajpil para kajkuanaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nochi tlen kichivah, kichivah para ma kinmitakah in gentejtih. Kivikatinemih seki Tiotlajkuiloli ijtik kajajtzitzintih iva kimotlaliliah inmixkuak iva itech inmah. Kada ves kimochijchiviliah okachi patlavak in kuetlaxmekatl tlen ika kinmilpiah in kajajtzitzintih iva kinweyakiliah intenyo de intlakenvah. ");
INSERT INTO nsu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kan onka ilvitl yejvah kitemovah tlen okachi kuali lugar kan motlaliskeh tlakuaskeh. Iva kinekih motlaliskeh tlayakapa kan motlaliah tlen okachi tlayakantokeh de kan tiotlamachtijkaltih. ");
INSERT INTO nsu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iva kivelitah ma kinyektlajpalokah ijkuak kateh tiankistli iva kinekih ma kinmilvikah tlamachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero imejvah amo xikchiakah de ma imechilvikah intlamachtijkeh, porke innochtin imejvah inmiknimeh iva inkipiah san se imoTlamachti, kijtosneki yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iva amika xikilvikah padre itech nin tlaltikpaktli, porke inkipiah san se Padre tlen kajki itech ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iva nion amo xikchiakah de ma imechilvikah intlayakankeh, porke imejvah inkipiah san se imoTlayakanki, kijtosneki yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tlen okachi weititos de entre imejvah, kipia de imechpalevis kemi tlakevali. ");
INSERT INTO nsu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porke tlen momachilis okachi weititok, satepa kitlalchitlaliskeh. Pero tlen motlalchitlalis, satepa kiweijkatlaliskeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Porke inkintzakuiliah in gentejtih para amo ma kalakikah kan Dios tlanavatia. Nion imejvah amo inkalakih, iva nion amo inkinkaviliah ma kalakikah tlen kinekih kalakiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Inkinkixtiliah inkalvah in iknosivameh, iva san ik inmochivah wejkavitl inmodiostzajtziliah. Iva por eso imejvah Dios imechtlajyoviltis okachi. ");
INSERT INTO nsu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Imejvah inmochijchikavah inkintemovah tlen amo judiojtih para ma kalakikah itech imotiotlamachtil. Iva ijkuak yonkajsikeh íkka, inkikuapa okachi pior ke imejvah iva okachi ma itech povi yas miktla iva amo kemi imejvah. ");
INSERT INTO nsu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ay de imejvah, inkateh kemi oyeskia amo intlachiah iva inkinekih inkinyakanaskeh oksekimeh! Imejvah inkijtovah: “Tla íkka kitemaka itlajtol por yen templo, yejón mach itla kijtosneki. Pero tla se tlakatl kitemaka itlajtol por yen oro tlen kajki ijtik templo, yejón kipia de kichivas.” ");
INSERT INTO nsu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ay de imejvah, inkateh kemi oyeskia amo intlachiah iva amitla inkajsikamatih! ¿Katli yen okachi weititok: in oro o noso in templo tlen kitiochijtok in oro? ");
INSERT INTO nsu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iva imejvah noijki inkijtovah: “Tla se tlakatl kitemaka itlajtol por yen artal, yejón mach itla kijtosneki. Pero tla se tlakatl kitemaka itlajtol por yen tlamanali tlen kajki ipan artal, yejón kipia de kichivas.” ");
INSERT INTO nsu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Imejvah inkateh kemi oyeskia amo intlachiah iva amitla inkajsikamatih! ¿Katli yen okachi weititok: in tlamanali o noso in artal tlen kitiochijtok in tlamanali? ");
INSERT INTO nsu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Porke tlen kitemaka itlajtol por yen artal, kijtosneki kitemaka itlajtol por yen artal iva noijki por nochi tlen ompa kajki ipan artal. ");
INSERT INTO nsu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iva tlen kitemaka itlajtol por yen templo, kijtosneki kitemaka itlajtol por yen templo iva por yen Dios tlen ompa chanti. ");
INSERT INTO nsu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Noijki tlen kitemaka itlajtol por yen ilvikak, kijtosneki kitemaka itlajtol por yen ilvikak iva noijki por yen itekivajsiya in Dios, iva por yen Dios tlen motlalia ipan yejón tekivajsiya. ");
INSERT INTO nsu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Porke imejvah inkitemakah imodiezmo de menta, de anís iva de komino. Pero amo inkichivah tlen okachi moneki tlen kijtova in tlanavatili, de xiktechivilikah tlen kuali, de xiteiknomatikah, iva de xiekah intenmachtih. Yen yejón tlen okachi moneki xikchivakah, pero noijki amo xikavakah de inkitemakaskeh imodiezmo. ");
INSERT INTO nsu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Imejvah inkateh kemi oyeskia amo intlachiah iva inkinekih inkinyakanaskeh oksekimeh! ¡Inkitzejtzelovah tlen inkonih para amo ma pano itla sayolintzi, pero inkitolovah asta se kameyo! ");
INSERT INTO nsu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Imejvah inkichipavah in vaso ivan plato san panixko, pero imejvah inkintemitiah ika ichtekayotl iva ika tlaixnekayotl. ");
INSERT INTO nsu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Imejvah infariseos amo intlachiah. Achto xikchipavakah in vaso ivan plato ik tlatlaijtik, para ijkó chipavis ik panixko. ");
INSERT INTO nsu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Imejvah inkateh kemi mikatekochtih tlen ik panixko pintaritokeh de istak iva mottah kualtzi, pero ik tlatlaijtik tentokeh de omitl de mikameh iva tlapalantok. ");
INSERT INTO nsu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ijkó noijki imejvah, ik panixko inmottah kemi intlakamelajkeh inmixpan gentejtih, pero imoijtik intentokeh de ome ixkotl iva de tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés iva imejvah infariseos, inkipiah ome inmoixko! Porke imejvah kualtzi inkinchijchivah tlaixneskayomeh kan toktokeh in tiotenejmachtijkeh, iva inkintlachijchiviah kan toktokeh tlen oyajkeh tlakamelajkeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iva inkijtovah: “Tla tejvah yotieskiah nepa tiempo ijkuak okatkah tokojkolvah, amo titevanmeh otikinmiktiskiah in tiotenejmachtijkeh.” ");
INSERT INTO nsu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ika yejón, imejvah inkimokuitiah ke imejvah intewejkaixvivah de nekateh tlen otemiktijkeh, ijkuak okinmiktijkeh in tiotenejmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Xiktlamikah pues in tlajtlakoli tlen okipevaltijkeh imokojkolvah. ");
INSERT INTO nsu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Kovameh! ¡Imejvah intepilvah de kovameh! ¿Kenik incholoskeh para amo intlajyoviskeh kan miktla? ");
INSERT INTO nsu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne nimechvalintitlanilis sekimeh tiotenejmachtijkeh, sekimeh ixtlamatkeh iva sekimeh tlamachtijkeh. Pero imejvah sekimeh inkinmiktiskeh iva sekimeh inkinkrusifikaroskeh, iva oksekimeh inkinvitekiskeh kan inmotiotlamachtijkalvah, iva oksekimeh inkinchochololtiskeh sentetl itech altepemeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ijkó pues, Dios imechtlajtlanilis kuenta imejvah de nochtin tlakamelajkeh tlen okinmiktijkeh, desde Abel tlen oyá tlakamela asta Zacarías ikone in Berequías, tlen imejvah onkimiktijkeh entre kan kajki in templo iva kan kajki in artal de sacrificios. ");
INSERT INTO nsu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yi neli nimechilvia, ke imejvah tlen axka imonkateh intlajyoviskeh por nochi nin tlamantli tlen onkichijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ay, Jerusalén, Jerusalén, te tikinmiktia in tiotenejmachtijkeh iva tikinmaga ika tetl tlen Dios kivalintitlani monavak! ¡Miek welta oniknekia nikinmololos mopilvah, kemi se poyojtena kinmololova ikonevah itlampa iajasvah, pero amo otiknekki! ");
INSERT INTO nsu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Axka mokalijtik mokavas sa tlaijki. ");
INSERT INTO nsu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iva nimitzilvia, ke ayakmo kema techitas asta ma ajsiki neká tonali ijkuak tikijtos: “¡Ma Dios kitiochiva tlen vitz ika itoka in toTeko!” ");
INSERT INTO nsu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús okiski de kan templo, iva ijkuak yoyaya, ijkuakó in momachtijkeh omotokijkeh inavak iva ope kititiah in kuajkuali kalmeh tlen povih itech templo. ");
INSERT INTO nsu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iva Jesús okinmilvi: —¿Inkittah nochi nin? Yi neli nimechilvia, nochi kixixititzaskeh iva ayakmo mokavas nepanitos nion oksé tetl. ");
INSERT INTO nsu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Satepa oyajkeh ipan tepetl tlen itoka Olivos. Jesús ompa omotlali, in momachtijkeh omotokijkeh inavak, iva ijkuak yokatkah san yejvah inselti, okitlajtlanijkeh: —¿Keman ijkó panolos? ¿Katle neskayotl tikittaskeh ijkuak tivitz ika mavissotlanextli? ¿Iva kemania tlamis in tlaltikpaktli? ");
INSERT INTO nsu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús okinnankili: —¡Xikpiakah kuidado! Amika ma imechkajkayava. ");
INSERT INTO nsu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porke miekeh vitzeh san kinejnekiskeh notoka, kijtoskeh: “Ne niCristo”, iva miekeh kinkajkayavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Imejvah inkimatiskeh onka guerra iva motlapoviskeh yetos guerra, pero amo ximomavtikah, porke ijkó kipia tlen panolos. Pero ayamo tlamis in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Se país kimomagas ivan oksé país, iva se altepetl kimomagas ivan oksé altepetl. Yetos apistli, yetos kokolistli, iva sentetl tlalolinis. ");
INSERT INTO nsu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero nochi yejón yikin pevas in tlajyovilistli. ");
INSERT INTO nsu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ijkuakó imejvah imechtemaktiskeh para imechtlajyoviltiskeh iva imechmiktiskeh. Nochtin gentejtih imechkualankaitaskeh por innechneltokah. ");
INSERT INTO nsu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Itech nekateh tonaltih miekeh tlaneltokakeh kipoloskeh intlaneltokalis, mokualankaitaskeh se iva oksé, iva motemaktiskeh inavak tekivajkeh se iva oksé. ");
INSERT INTO nsu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Monextiskeh miekeh tiotenejmachtijkeh tekajkayajkeh iva kinkajkayavaskeh miekeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yetos sa tlawel miek tlajtlakoli, iva por eso miekeh ayakmo motlasojtlaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero tlen akin kixikos nochi asta sa ik tlami, momakixtis. ");
INSERT INTO nsu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iva nin kuali tlajtoli tlen techilvia kenik in Dios tlanavatia, motematiltis sentetl itech nin tlaltikpaktli, para ke nochtin gentejtih de nochtin países ma kimatikah. Iva ijkuakó tlamis in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Noijki imejvah inkittaskeh panolos tlen okijkuilo in tiotenejmachti Daniel, okijto ajsis tonali imejvah inkittaskeh itla fierotik tlen teixpolo, moketos Kan Tlatiochitok de kan templo kan amo kipia de ompa yetos, —tlen kileros nin tlajtoli tlen okijkuilo Daniel, ma kajsikamati tlán kijtosneki—, ");
INSERT INTO nsu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ijkuakó tlen yeskeh Judea, ma cholokah ma viah asta ipan tepemeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iva tlen yetos ikpak ikal, amo ma temo para kikuiti itla ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iva tlen yetos itlala, amo ma mokuapa para ikalijtik para kikuiti itlaken. ");
INSERT INTO nsu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Prowestih sivameh tlen itech nekateh tonaltih kipixtoskeh inkonetzi inmijtik iva in sivameh tlen tlaskaltijtoskeh! ");
INSERT INTO nsu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ximodiostzajtzilikah amo ma imechtokaro incholoskeh mero ijkuak seva, o noso ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Itech nekateh tonaltih yetos miek tlajyovilistli temavti, ke amo yi semi ijkó panolo desde ijkuak ope in tlaltikpaktli iva satepa ayakmo kema ijkó panolos. ");
INSERT INTO nsu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dios kintlasojtla tlen Ye yokinpejpenki, iva por eso amo wejkavas miek tiempo yejón tlajyovilistli. Porke tlamo, amika omomakixtiskia. ");
INSERT INTO nsu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ijkuakó tla íkka imechilvis: “Xikittakah, nika kajki in Cristo”, o noso “Xikittakah, nepa kajki”, amo xikneltokilikah. ");
INSERT INTO nsu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porke monextiskeh Cristojtih iva tiotenejmachtijkeh tekajkayajkeh, iva kinchivaskeh miekeh neskayomeh iva nexkuitiltih para ika tlakajkayavaskeh. Iva kinekiskeh kinkajkayavaskeh noijki tlen Dios yokinpejpenki. ");
INSERT INTO nsu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ne yonimechilvi antes de ijkó panolos. ");
INSERT INTO nsu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Por eso, tla imechilviskeh: “Xikittakah, in Cristo kajki kan tlavaki”, amo xiviah. Iva tla imechilviskeh: “Xikittakah, nika kajki kan kuarto”, amo xikneltokakah. ");
INSERT INTO nsu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porke ijkó kemi ijkuak tlapejpetlani iva tlavia desde ik kan valkisa in tonali iva asta ik kan onpolivi in tonali, ijkó noijki mottas ijkuak vitz iKone in Tlakatl ika imavissotlanex. ");
INSERT INTO nsu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ijkó kemi ijkuak in tzojpilomeh peva mololovah kan vetok se yolkatl tlen yomikki, ijkó noijki yetos ijkuak Ne nivitz porke nochtin kimatiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Iva san nima ijkuak yopanokeh in yejonmeh tonaltih de tlajyovilistli temavti, in tonali tlilevis, in metzi ayakmo tlavis, in sitlalimeh vetziskeh iva in tlamantih tlen chijchikavakeh tlen kateh itech ilvikak viviokaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iva ijkuakó mottas se neskayotl itech ilvikak nik yompa valmuika iKone in Tlakatl, iva ijkuakó nochtin gentejtih de nin tlaltikpaktli tlen kichivah tlajtlakoli sa tlawel mavkatzajtziskeh ijkuak kittaskeh valmuika itech mixtli de ilvikak, ika miek ivelitilis iva ika wei imavissotlanex. ");
INSERT INTO nsu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iva kinvaltitlanis iilvikaktlatitlanilvah, yejvah valtlapitzaskeh chikavak, iva kinmololoskeh in gentejtih tlen Ye yokinpejpenki, ik novian itech nin tlaltikpaktli desde kan onpejtok iva asta kan ontlantok. ");
INSERT INTO nsu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Xikajsikamatikah in ejemplo de se igoskuavitl: Ijkuak yi peva selia imamayo iva yi peva moxivyotia, imejvah yinkimatih ke in tonaya yi kajki serka. ");
INSERT INTO nsu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ijkó noijki, ijkuak imejvah inkittaskeh yi ijkó tlamochijtok de tlan yonimechilvi, ijkuakó noijki xikmatikah nik mach ok wejkavas para vitz iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yi neli nimechilvia, ke nochi yejón tlamantli panolos antes de ixpoliviskeh in gentejtih de nin tiempo. ");
INSERT INTO nsu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","In ilvikak ivan tlaltikpaktli ayakmo yeskeh, nochi polivis, pero notlajtol amo polivis, sino kipia de mochivas nochi tlen nimechilvijtok. ");
INSERT INTO nsu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Amika kimati tlán tonali iva tlán ora ijkuak ijkó panolos, nion ilvikaktlatitlaniltih amo kimatih, nion iKone in Dios noijki amo nikmati, sino san yen noTajtzi Dios kimati. ");
INSERT INTO nsu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Iva ijkó kemi okatka itech tiempo de Noé, no ijkó yetos ijkuak valmuikas iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Itech nekateh tonaltih, antes de mokajkavas in kiavitl chikavak, in gentejtih otlakuayah iva okoniah itech ilvimeh, in tlakah ivan sivameh omonamiktiayah. Ijkó okichijtokah asta ijkuak oajsik neká tonali ijkuak Noé okalakki kan wei barko. ");
INSERT INTO nsu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","In gentejtih amo okimatiah tlán mochivaskeh asta ijkuak ovala in kiavitl chikavak iva nochtin okinmikti. Ijkó noijki tlamochivalos ijkuak valmuikas iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ijkuakó, ome tlakah tekipanojtoskeh intlala. Se kivikaskeh ivan oksé kikajtevaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ome sivameh tlapayantoskeh itech se metlatl. Se kivikaskeh ivan oksé kikajtevaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Xiijsatokah pues, porke amo inkimatih tlan ora valmuikas imoTeko. ");
INSERT INTO nsu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xikmatikah imejvah, tla se chane okimatiskia tlan ora vitz in ichtekki, tonses oijsatoskia iva amo okikaviliskia ma kalaki ikalijtik para ma kitlachteki. ");
INSERT INTO nsu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Por eso, imejvah sa ximonejmachtijtokah, porke ijkuak imejvah amo inkiyejyekojtoskeh kox vitz, ijkuakó valmuikas iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Akin tlakevali tlen kichiva in tekitl kemi oyeskia iaxka iva itech se motenmachia? Kijtosneki yen tlen kitlalia iteko ma kinmitili tlen oksekimeh itlakevalvah, iva ma kintlamakah a tiempo. ");
INSERT INTO nsu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma paki in tlakevali tla iteko kajsiki kichijtok tlen okinavati. ");
INSERT INTO nsu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yi neli nimechilvia, ke yejón iteko kitlalis ma kitili nochi tlen iaxka. ");
INSERT INTO nsu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero tla in tlakevali amo kuali iyelis iva kiyejyekos ke iteko wejkavas de mokopati, ");
INSERT INTO nsu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","iva tla pevas kinmagas ika maitl tlen oksekimeh tlakevaltih, iva pevas tlakuas iva konis ivan oksekimeh tlavankeh, ");
INSERT INTO nsu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ijkuakó iteko vitz itech se tonali iva itech se ora ijkuak itlakeval amo kimatis kox ijkuakó vitz. ");
INSERT INTO nsu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa tlawel kiwitekis, iva kititlanis ma tlajyovi san sekka invan tlen kipiah ome inmixko kan chokas iva motlantekis. ");
INSERT INTO nsu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Ijkuakó kan Dios tlanavatia yetos kemi omochijkeh majtlaktli ichpokameh tlen okinvikayah inkandilvah iva oyajkeh okinamikitoh in novio. ");
INSERT INTO nsu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Makuili ichpokameh okatkah tlayejyekolejkeh iva ok makuiltih ichpokameh okatkah amo tlayejyekolejkeh. ");
INSERT INTO nsu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tlen okatkah amo tlayejyekolejkeh, ijkuak okivikakeh inkandil, amo okivikakeh inmaseite para kintemitiskeh oksemi. ");
INSERT INTO nsu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero tlen oksekimeh ichpokameh tlen tlayejyekolejkeh okivikakeh intepalkav de aseite iva inkandil. ");
INSERT INTO nsu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iva komo in novio amo totoka ovalaya, nochtin ichpokameh okinkitzki kochilistli, iva okochkeh. ");
INSERT INTO nsu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Satepa, kemi tlajko yovak, okikakkeh se tlajtoli: “¡Ompa vitz in novio, xiknamikitih!” ");
INSERT INTO nsu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ijkuakó nochtin ichpokameh omejtevakeh iva ope kinyektlaliah inkandilvah. ");
INSERT INTO nsu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iva in makuili ichpokameh tlen amo tlayejyekolejkeh okinmilvijkeh tlen oksekimeh makuili ichpokameh: “Techmakakah se tzikitzi imoaseite, porke tokandilvah yi mero sevih.” ");
INSERT INTO nsu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero in ichpokameh tlayejyekolejkeh otlanankilijkeh: “Amó, porke tla timechmakaskeh amo kajxilis para imejvah iva nion para tejvah tokandil. Okachi kuali xiviah kan kinemakah iva xikmokovikah para imejvah.” ");
INSERT INTO nsu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero ijkuak in makuili ichpokameh tlen amo tlayejyekolejkeh oyajkeh okimokovitoh inmaseite, ijkuakó oajsiko in novio. In ichpokameh tlen yokatkah listas okalakeh ivan novio kan monamiktiah, iva ijkuakó ovalmotzakki in puerta. ");
INSERT INTO nsu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Satepa, oajsikoh tlen oksekimeh makuili ichpokameh tlen amo tlayejyekolejkeh, okivijvitekeh in puerta iva okijtojkeh: “¡Tata, tata, techtlatlapoli!” ");
INSERT INTO nsu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero ye okinnankili: “¡Mach nimechixmati akinmeh imejvah!” ");
INSERT INTO nsu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ijkuakó Jesús okinmilvi: —Por eso imejvah xiijsatokah, porke amo inkimatih tlán tonali nion tlán ora valmuikas iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ijkuak Dios tlanavatis, yetos kemi se tlakatl tlen antes de kisas para oksé país, okinnotzki itlakevalvah iva okinkajtevili seki itomi para ika ma tekipanokah. ");
INSERT INTO nsu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Se itlakeval okimakak makuili mil tomi de plata, oksé okimakak ome mil tomi de plata, iva oksé okimakak se mil tomi de plata. Kada se de yejvah okinmakak ijkó kemi tlen yejvah oveliah okichivayah. Satepa yejón tlakatl okiski oyá wejka. ");
INSERT INTO nsu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","In tlakevali tlen okimakakeh makuili mil tomi de plata, okichi negosio ika, iva okitlanki ok makuili mil tomi de plata. ");
INSERT INTO nsu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iva in tlakevali tlen okimakakeh ome mil tomi de plata, noijki okitlanki ok ome mil tomi de plata. ");
INSERT INTO nsu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero tlen oksé tlakevali tlen okimakakeh se mil tomi de plata, okitlalpacho in tomi de iteko. ");
INSERT INTO nsu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Miek tonali satepa, inteko omokopato, iva ope kintlajtlanilia kuenta. ");
INSERT INTO nsu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","In tlakevali tlen okimakakeh makuili mil tomi de plata, okimak iteko ok makuili mil, iva okilvi: “Tejwatzi noteko, tejwatzi otechmakak makuili mil tomi de plata, nika kajki ok makuili mil tlen oniktlanki.” ");
INSERT INTO nsu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iteko okilvi: “Kuali otikchi. Te sa tlawel kuali tinotlakeval iva titenmachtli. Iva komo kuali ika otitekipano maski san ika tzikitzi, axka nimitzmakas xikitta okachi miek tlamantli. Axka xivalmuika itech noilviv.” ");
INSERT INTO nsu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","In tlakevali tlen okimakakeh ome mil tomi de plata, okitemakak kuenta ijkí: “Tejwatzi noteko, tejwatzi otechmakak ome mil tomi de plata, nika kajki ok ome mil tlen oniktlanki.” ");
INSERT INTO nsu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iteko okilvi: “Kuali otikchi. Te sa tlawel kuali tinotlakeval iva titenmachtli. Iva komo kuali ika otitekipano maski san ika tzikitzi, axka nimitzmakas xikitta okachi miek tlamantli. Axka xivalmuika itech noilviv.” ");
INSERT INTO nsu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero in tlakevali tlen okimakakeh se mil tomi de plata, okilvi iteko: “Tejwatzi noteko, komo nikmati nik titekixneki, iva tikmopixkia tlen amo otiktookak iva tikololova kan amo otikxini itla semiya, ");
INSERT INTO nsu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","onimomavti, iva okachi kuali oniktlaati motomi oniktlalpacho. Pero nika kajki motomi.” ");
INSERT INTO nsu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iteko okinankili: “Te mach tikuali tinotlakeval iva titlatzivki, tla otikmatia ke nikmopixkia tlen amo oniktookak iva nikololova kan amo onikxini itla semiya, ");
INSERT INTO nsu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","sikiera otikonkavaskia notomi kan banko para okitlaniskia ikoneyo, iva ijkuak onejkoskia, onikseliskia notomi ivan ikoneyo.” ");
INSERT INTO nsu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ijkuakó inteko okinmilvi tlen ompa okatkah: “Xikixtilikah yejón mil tomi de plata, iva xikmakakah tlen kipia majtlaktli mil. ");
INSERT INTO nsu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porke tlen kipia, se kimakas okachi, iva kipias okachi. Iva tlen amo kipia, maski asta yen tlen tzikitzi kipia se kikixtilis. ");
INSERT INTO nsu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iva nin notlakeval tlatzivki, xiktlamotlakah kiavak kan tlayova kan chokas iva motlantekis. ");
INSERT INTO nsu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ijkuak iKone in Tlakatl valmuikas ivan nochtin iilvikaktlatitlanilvah, valmuikas ika imavissotlanex iva motlalis itech itekivajsiya tlen kipia mavissotlanextli. ");
INSERT INTO nsu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","In gentejtih de nochtin países mololoskeh iyakapa, iva kinxelos ijkó kemi se tlajpixki kinxelova in ichkameh de invan tentzomeh. ");
INSERT INTO nsu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tlen ichkameh kintlalis ik iyekmapa iva tlen tentzomeh kintlalis ik iopochmapa. ");
INSERT INTO nsu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ijkuakó in Wei tlanavati kinmilvis tlen yeskeh ik iyekmapa: “Xivikikah imejvah tlen intlatiochivaltih de noTajtzi. Xivikikah iva xikselikah imoerensia kan Dios tlanavatia, kan yi tlayektlalitok para imejvah desde ijkuak omochi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porke ijkuak onitiojsi, imejvah onnechtlamakakeh. Ijkuak onamikki, imejvah onnechmakakeh atl. Ijkuak amo onikpiaya kan nimokalotis, imejvah onnechkalotijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ijkuak amo onikpiaya notzotzol, imejvah onnechmakakeh notzotzol. Ijkuak onimokoko, imejvah onnechtlajpalotoh. Ijkuak onitzaktoka telpiloya, imejvah onnechitatoh.” ");
INSERT INTO nsu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ijkuakó tlen oyajkeh tlakamelajkeh kijtoskeh: “ToTeko, ¿keman otimitzitakeh otitiojsi, iva otimitztlamakakeh? ¿O noso keman otimitzitakeh otamikki, iva otimitzmakakeh atl? ");
INSERT INTO nsu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O noso keman otimitzitakeh amo otikpiaya kan timokalotis, iva otimitzkalotijkeh, o noso amo otikpiaya motzotzol, iva tejvah otimitzmakakeh motzotzol? ");
INSERT INTO nsu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O noso keman otimitzitakeh otimokoko, o noso otitzaktoka telpiloya, iva otiajkeh otimitzitatoh?” ");
INSERT INTO nsu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ijkuakó in Wei tlanavati kinnankilis: “Yi neli nimechilvia, ke nochi tlen imejvah onkichijkeh por nochtin ninmeh noknivah tlen amo ipanitalistih, kijtosneki onkichijkeh por ne.” ");
INSERT INTO nsu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ijkuakó noijki kinmilvis tlen yeskeh ik iopochmapa: “Ximachivakah de ne, Dios yokijto ke imejvah intlajyoviskeh. Xiviah ijtik tlitl tlen amo keman sevi tlen Dios okichi para yen Amo Kuali Tlakatl ivan iejekavah. ");
INSERT INTO nsu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porke ijkuak onitiojsi, imejvah amo onnechtlamakakeh. Ijkuak onamikki, imejvah amo onnechmakakeh atl. ");
INSERT INTO nsu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ijkuak amo onikpiaya kan nimokalotis, imejvah amo onnechkalotijkeh. Ijkuak amo onikpiaya notzotzol, imejvah amo onnechmakakeh notzotzol. Ijkuak onimokoko iva ijkuak onitzaktoka telpiloya, imejvah amo onnechitatoh.” ");
INSERT INTO nsu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ijkuakó yejvah noijki kinankiliskeh: “ToTeko, ¿keman otimitzitakeh otitiojsi o noso otamikki, o noso amo otikpiaya kan timokalotis, o noso amo otikpiaya motzotzol, o noso otimokoko, o noso otitzaktoka telpiloya iva amo otimitzpalevijkeh?” ");
INSERT INTO nsu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ijkuakó in Wei tlanavati kinnankilis: “Yi neli nimechilvia, ke ijkuak imejvah amo onkinpalevijkeh noknivah tlen okachi amo ipanitalistih, kijtosneki ne amo onnechpalevijkeh.” ");
INSERT INTO nsu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yejonmeh yaskeh itech tlajyovilistli para semijkak, iva tlen tlakamelajkeh kalakiskeh itech nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ijkuak Jesús otlanki okijto nochi nin tlajtoli okinmilvi in momachtijkeh: ");
INSERT INTO nsu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Imejvah yinkimatih ke polivi sa ome tonali para yetos ilvitl de Pascua. Iva iKone in Tlakatl kitemaktiskeh para kikrusifikaroskeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Noijki itech yejón ora, in tlayakankeh tiopixkeh, in tlamachtijkeh de itlanavatil Moisés iva in tlayakankeh tetajmeh, omololojkeh kan kiavak de kan palacio kan chanti in wei tiopixki itoka Caifás. ");
INSERT INTO nsu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ompa omotlatlalvijkeh kenik velis kichivaskeh ma vetzi in Jesús itech intlakajkayavalis para ijkó velis kikitzkiskeh iva kixpoloskeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero okimolviayah: —Amo tikitzkiskeh itech ilvitl, para amo mopajsoloskeh in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús okatka Betania, kan ikalijtik in Simón, tlen Jesús okipajti ijkuak opalania inakayo. ");
INSERT INTO nsu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ijkuakó se sivatl omotoki inavak Jesús tlen okivikaya se boteyajtzi de alabastro tentok de ajviakayotl tlen patío, iva okiteekili in Jesús ipan itzonteko kan oyetoka kan mesa. ");
INSERT INTO nsu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","In momachtijkeh ijkuak ijkó okittakeh, okualankeh iva okijtojkeh: —¿Tleka nin sivatl san okavilti in ajviakayotl? ");
INSERT INTO nsu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Oveliskia omonemakaskia patío, iva in tomi se okinmakaskia tlen prowestih. ");
INSERT INTO nsu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús okikakki iva okinmilvi: —Amitla xikilvikah nin sivatl. Porke ye okichi se kuali tlamantli para Ne. ");
INSERT INTO nsu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","In prowestih nochipa inkinpiaskeh, pero Ne mach ok wejkavas nika nietos imovah. ");
INSERT INTO nsu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nin sivatl ijkuak onechteekili ajviakayotl itech nokuerpo, kijtosneki yokiyektlali nokuerpo para ijkuak nechtookaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yi neli nimechilvia, ke sentetl itech nin tlaltikpaktli kan motematiltis in yankuik kuali tlajtoli, noijki mijtos tlen okichi nin sivatl iva ijkó kilnamikiskeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ijkuakó Judas Iscariote se de tlen majtlaktih ivan ome momachtijkeh de Jesús, oyá omotlapovito invan tlayakankeh tiopixkeh, ");
INSERT INTO nsu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","iva okinmilvi: —¿Kech innechmakaskeh tla nimechmaktilis in Jesús? Ijkuakó yejvah okimakakeh senpoali ivan majtlaktli tomi de plata. ");
INSERT INTO nsu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iva desde ijkuakó Judas ope kitemova keman velis kitemaktis in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","In primer tonali ijkuak ope in ilvitl de pan tlen amo kipia xokotixtli, ijkuakó in momachtijkeh de Jesús omotokijkeh inavak, iva okitlajtlanijkeh: —¿Kan tikneki ma tikchivatih in tlakuali de Pascua? ");
INSERT INTO nsu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ye okinmilvi: —Xiviah Jerusalén kan ikalijtik in tlakatl tlen imejvah yinkixmatih, iva xikilvikah: “In Tlamachti kijtova: Yoajsik noora, moneki mokalijtik nikmomajsevis in tlakuali de Pascua Ne iva tlen nikinmachtia.” ");
INSERT INTO nsu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","In momachtijkeh okichijkeh ijkó kemi okinnavati in Jesús, iva okichijkeh in tlakuali de Pascua. ");
INSERT INTO nsu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ijkuak otlayovak, Jesús omotlali kan mesa ivan majtlaktli ivan ome momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Iva ijkuak otlakuajtokah okinmilvi: —Yi neli nimechilvia, ke se de imejvah nechtemaktis. ");
INSERT INTO nsu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yejvah sa tlawel omoyolkokojkeh, iva kada se de yejvah ope kitlajtlaniah: —¿Kox ne, noTeko? ");
INSERT INTO nsu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús okinnankili: —Tlen kapachova ipan kan plato kan Ne noijki nikapachova nopan, yen yejón nechtemaktis. ");
INSERT INTO nsu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yi neli, iKone in Tlakatl ixpolivis ijkó kemi kijtova in Tiotlajkuiloli. Pero ¡ay de neká tlakatl tlen nechtemaktis! Okachi kuali amo onesiskia. ");
INSERT INTO nsu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ijkuakó Judas tlen kitemaktis in Jesús, okitlajtlani: —Tlamachti, ¿kox ne? Jesús okinankili: —Kema, te mero. ");
INSERT INTO nsu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ijkuak otlakuajtokah, Jesús okontilanki in pan iva okitlasojkamatki inavak Dios, okipojpostekki in pan iva okinmajmakak in momachtijkeh, iva okinmilvi: —Xikuakah, nin yen nokuerpo. ");
INSERT INTO nsu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Satepa okontilanki in kopa de vino, okitlasojkamatki inavak Dios, okinpanoltili in momachtijkeh, iva okinmilvi: —Innochtin xikonikah nin vino, ");
INSERT INTO nsu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","porke nin yen noesso, iva Dios ika kichiva inmovah se yankuik moyekkavalistli, iva tlen nokivis para tlapojpolvilistli de tlajtlakoli de miekeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero nikneki nimechilvis, ke desde axka mach ok nikonis vino asta neká tonali ijkuak tlanavatis noTajtzi iva ijkuakó nikonis yankuik vino inmovah. ");
INSERT INTO nsu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Satepa de okintlakuikakeh sekimeh himnos, oyajkeh ipan tepetl tlen itoka Olivos. ");
INSERT INTO nsu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ijkuakó Jesús okinmilvi: —Nin yovak nochtin imejvah innechkavaskeh noselti, porke in Tiotlajkuiloli kijtova: “Nikmiktis in tlajpixki iva in ichkameh xixiniskeh.” ");
INSERT INTO nsu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero satepa de ijkuak nimoyolitis, nitlayakanas para Galilea iva ompa innechajsitivih. ");
INSERT INTO nsu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ijkuakó Pedro okinankili: —Maski nochtin ma mitzkavakah moselti, ne amo kema nimitzkavas. ");
INSERT INTO nsu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ijkuakó Jesús okilvi: —Yi neli nimitzilvia, nin yovak antes de tzajtzis in kaxtil, para ijkuakó te yotikijto eyi welta nik amo techixmati. ");
INSERT INTO nsu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iva Pedro okinankili: —Maski mova ma nechmiktikah, ne amo kema nikijtos ke amo nimitzixmati. Iva nochtin oksekimeh momachtijkeh no ijkó okijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Satepa Jesús oyá invan momachtijkeh kan se lugar itoka Getsemaní, iva okinmilvi: —Nika ximotlalikah, ne niav nimodiostzajtziliti ik nepa. ");
INSERT INTO nsu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús okivikak in Pedro ivan ome itelpochvah in Zebedeo. Satepa sa tlawel ope motekipachova iva moyolkokova. ");
INSERT INTO nsu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jesús okilvi in Pedro iva tlen ome itelpochvah in Zebedeo: —Sa tlawel nimoyolkokova iva ayakmo nikxikova nikmachilia niixpolivis. Nika ximokavakah xiijsatokah nova. ");
INSERT INTO nsu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús oyá ok achitzi tlayakapa, ompa omotlankuaketzki iva omixtlapacho ipan tlali, iva omodiostzajtzili okijto: —NoTajtzi, tla tikmonekiltis, techkixtili nin tlajyovilistli tekoko. Pero amo ma mochiva kemin Ne nikneki, sino kemi tejwatzi tikmonekiltis. ");
INSERT INTO nsu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Satepa Jesús omokuapki kan okatkah tlen eyi momachtijkeh, iva okinmajsito kochtokeh. Iva Jesús okilvi in Pedro: —¿Amo onkixikojkeh nion se ora inmijsatokeh nova? ");
INSERT INTO nsu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xiijsatokah iva ximodiostzajtzilijtokah, para amo xivetzikah ijkuak imechyoltilanas in tlajtlakoli. Imotonal kineki kichivas tlen kuali, pero imokuerpo amo tlaxikova. ");
INSERT INTO nsu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús oksé welta oyá omodiostzajtzilito, iva omodiostzajtzili ijkí: —NoTajtzi, tla amo velis techkixtilis nin tlajyovilistli tekoko, tonses ma mochiva kemi tejwatzi tikmonekiltis. ");
INSERT INTO nsu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oksemi omokuapki kan okatkah in momachtijkeh, iva oksemi okinmajsito kochtokeh, porke okintlanki in kochilistli. ");
INSERT INTO nsu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Oksé welta okinkajte iva oyá omodiostzajtzilito yi eyi welta, iva oksemi okijto tlen achto okijto. ");
INSERT INTO nsu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Satepa oyá kan okatkah in momachtijkeh iva okinmilvi: —¿Ok inkochih iva inmoseviah? Yoajsik ora para kitemaktiskeh iKone in Tlakatl inmak in gentejtih tlajtlakolejkeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ximevakah, ma tiviah. Yompa vitz tlen nechtemaktis. ");
INSERT INTO nsu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ok otlapojtoka iva ijkuakó oajsiko in Judas, tlen okatka se de yejvah tlen majtlaktli ivan ome momachtijkeh, iva ivan ovalayah miekeh gentejtih okivalikayah espada iva kuavitl. Nonmeh gentejtih okintitlankeh in tlayakankeh tiopixkeh iva in tlayakankeh tetajmeh judiojtih. ");
INSERT INTO nsu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pero Judas antes de kinmaktilis in Jesús, achto okinmilvi kenik kinmititis katli yen Jesús. Okinmilvi: —Tlen ne nikixpipitzos, yen yejón Jesús. Xikitzkikah iva xikvikakah. ");
INSERT INTO nsu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ijkuakó Judas omotoki inavak Jesús iva okilvi: —¡Nolti, Tlamachti! Iva okixpipitzo. ");
INSERT INTO nsu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús okinankili: —Noyolikni, ¿tlán otikchivako? Ijkuakó ipan omopachojkeh, okitzkijkeh in Jesús iva okivikakeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ijkuakó se momachti de Jesús okixti iespada iva okinakastzonteki itlakeval in wei tiopixki. ");
INSERT INTO nsu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pero Jesús okilvi: —Xiktlaati moespada. Porke nochtin tlen mokitzkiah ika espada, noijki mikiskeh ika espada. ");
INSERT INTO nsu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Amo tikmati ke tla Ne oniknekiskia, oveliskia oniktlajtlaniliskia noTajtzi okachi de majtlaktli ivan ome ejércitos de ilvikaktlatitlaniltih para ma nechpalevikih iva san nima okinvaltitlaniskia? ");
INSERT INTO nsu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tla ijkó nikchivas, ¿tonses kenik mochivas tlen ijkuilitok itech Tiotlajkuiloli, kan kijtova ke ijkó kipia de nechpanos? ");
INSERT INTO nsu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ijkuakó Jesús okinmilvi in gentejtih: —¿Onnechkitzkikoh imejvah ika espada iva ika kuavitl kemi oyeskia niichteki? Nochipa onikatka imovah kan templo onitlamachtijtoka iva amo semi onnechkitzkijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero nochi nin kipia tlen ijkó yetos para ma mochiva tlen kijtova in Tiotlajkuiloli tlen okijkuilojkeh in tiotenejmachtijkeh. Ijkuakó nochtin momachtijkeh ocholojkeh iva okikajtejkeh iselti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tlen okitzkijkeh in Jesús okivikakeh inavak in wei tiopixki Caifás, iva ompa yomololojkeh in tlamachtijkeh de itlanavatil Moisés ivan tlayakankeh tetajmeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro inkuitlapa oyaya san de wejka asta kan kiavak de kan ikalijtik in wei tiopixki, ompa okalakki iva omotlali invan templojmayoltih para kittas tlán panolos. ");
INSERT INTO nsu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","In tlayakankeh tiopixkeh, in tlayakankeh tetajmeh iva nochtin tlen povih itech injunta in judiojtih, okitemovayah kenik velis kitlajtlakoltiskeh in Jesús de itla tlen amo neli para ijkó velis kixpoloskeh. ");
INSERT INTO nsu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero amitla okajxiliayah tlan ika velis kiteilviskeh, maski miekeh okijtojkeh tlen amo neli. Pero satepa omoketzkeh ome testigojtih istlakameh, ");
INSERT INTO nsu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","iva okijtojkeh: —Nin tlakatl okijto: “Ne velis nikxitinis in templo de toTajtzin Dios, iva san ika eyi tonali oksemi niketzaltis.” ");
INSERT INTO nsu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ijkuakó in wei tiopixki ovalmoketzki, iva okitlajtlani in Jesús: —¿Amo titlanankilis? ¿Yi neli tlen kijtovah ninmeh? ");
INSERT INTO nsu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús amo otlanankili. In wei tiopixki oksemi okitlajtlani: —Nimitznavatia ika itoka toTajtzin Dios tlen yolitok, techilvi tinochtin kox te tiCristo, iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús okinankili: —Ijkó kemi te yotikijto. Iva nikneki nimechilvis desde axka imejvah inkittaskeh iKone in Tlakatl yetos ik iyekmapa in Dios tlen kipia nochi velitilistli, iva valmuikas itech mixtli de ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ijkuakó in wei tiopixki, omotlakentzomoni iva okijto: —¡Nin tlakatl kixpanavia in Dios ika itlajtol! Mach ok monekih testigojtih. Imejvah yonkikakeh kenik kixpanavia in Dios ika itlajtol. ");
INSERT INTO nsu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Imejvah tlán inkijtovah? Yejvah okijtojkeh: —¡Tlajtlakole, ma miki! ");
INSERT INTO nsu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ijkuakó okixchijchakeh iva okimagakeh ika maitl, iva oksekimeh okixtlajtlatzinijkeh ");
INSERT INTO nsu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","iva okilvijkeh: —Tla tiCristo, ¡xikyejyekoli akin omitzmagak ika maitl! ");
INSERT INTO nsu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro oyetoka kan kiavak, iva ijkuakó se sivatl itlakeval in wei tiopixki omotoki inavak Pedro iva okilvi: —Te noijki otinemia ivan Jesús tlen de Galilea. ");
INSERT INTO nsu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro amo okimokuiti iva okijto inmixpa nochtin: —Mach nikmati tlán tikijtova. ");
INSERT INTO nsu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro yokistiaya kan puerta, iva ijkuakó oksé sivatl okittak, iva okinmilvi tlen ompa okatkah: —Nin tlakatl noijki onemia ivan Jesús de Nazaret. ");
INSERT INTO nsu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro oksemi amo okimokuiti, iva okijto: —Yi neli, mach nikixmati yejón tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Okachi satepa, tlen ompa okatkah omotokijkeh inavak Pedro, iva okilvijkeh: —Yi neli, te noijki se de yejvah, porke mokaki noijki ijkó nik titlapova. ");
INSERT INTO nsu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ijkuakó Pedro ope kijtova ipan ma vetzi tlajyovilistli tla amo neli tlen kijtova iva okisentlali itlajtol, okijto: —Ne mach nikixmati yejón tlakatl. Iva san nima ijkuakó ovaltzajtzik in kaxtil. ");
INSERT INTO nsu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ijkuakó Pedro okilnamiki tlen achto okilvijka in Jesús: “Antes de tzajtzis in kaxtil, para ijkuakó te yotikijto eyi welta nik amo techixmati.” Pedro okiski de ompa iva sa tlawel ochokak. ");
INSERT INTO nsu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ijkuak otlaneski, nochtin tlayakankeh tiopixkeh ivan tlayakankeh tetajmeh judiojtih, omotlatlalvijkeh kenik kichivaskeh para kixpoloskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Okijilpijkeh iva okivikakeh okimaktilijkeh in kobernador Poncio Pilato. ");
INSERT INTO nsu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Satepa Judas, tlen okitemakti in Jesús, ijkuak okittak ke Jesús yokitlajtlakoltijkeh para kixpoloskeh, okimachili fiero por tlen okichi, iva oyá okinkuapilito in senpoali ivan majtlaktli tomi de plata in tlayakankeh tiopixkeh ivan tlayakankeh tetajmeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iva okinmilvi: —Yonikchi se wei tlajtlakoli, porke oniktemakti se tlakatl tlen amo okichi nion se tlajtlakoli. Pero yejvah okinankilijkeh: —¡Tejvah mach totekiv! ¡Ompa te xikitta! ");
INSERT INTO nsu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ijkuakó Judas okitlamotlak in tomi ompa ijtik templo, iva okiski oyá omokechpiloto. ");
INSERT INTO nsu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","In tlayakankeh tiopixkeh okololojkeh in tomi iva okijtojkeh: —Dios itlanavatil amo kitekavilia ma tiktlalikah nin tomi ijtik kaja kan kitlaliah ofrendajtomi, porke ika okitlaxtlajkeh iesso de se tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iva satepa omotlapovijkeh ke ika yejón tomi kikovaskeh se tlali, iva okikojkeh in tlali tlen itoka Itlal in Xoktzinchijchi, para kipiaskeh se lugar kan kintookaskeh in gentejtih tlen amo de ompa. ");
INSERT INTO nsu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Por eso, yejón tlali asta axka kilviah Tlali de Estli. ");
INSERT INTO nsu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Otlamochivalok ijkó kemi okijto in tiotenejmachti Jeremías, ijkuak okijto: “Okonankeh senpoali ivan majtlaktli tomi de plata, tlen gentejtih de Israel okijtojkeh ijkó ipati. ");
INSERT INTO nsu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iva ika yejón tomi okikojkeh in tlali tlen itoka Itlal in Xoktzinchijchi, ijkó kemi onechnavati in toTeko.” ");
INSERT INTO nsu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús okivikakeh inavak in kobernador Pilato, iva Pilato okitlajtlani in Jesús: —¿Neli te tiwei tlanavati de judiojtih? Jesús okinankili: —Kema, ijkó kemi te tikijtova. ");
INSERT INTO nsu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","In tlayakankeh tiopixkeh ivan tlayakankeh tetajmeh maski ope okiteistlakaviayah, Jesús amo okinnankiliaya. ");
INSERT INTO nsu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ijkuakó in Pilato okilvi: —¿Amo tikkaki nochi tlen yejvah mitzteilviah? ");
INSERT INTO nsu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús amo okinankili nion se tlajtoli, iva Pilato sa tlawel okimotetzavi. ");
INSERT INTO nsu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","In kobernador okipiaya kostumbre ke itech ilvitl de Pascua kikajkava se de tlen tzaktokeh telpiloya, ijkó kemi tlen kijtoskeh in gentejtih katli ye ma kikajkava. ");
INSERT INTO nsu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Itech yejonmeh tonaltih otzaktoka se tlakatl itoka Barrabás tlen sentetl okixmatiah. ");
INSERT INTO nsu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iva ijkuak in gentejtih omololojkeh, Pilato okintlajtlani: —¿Akin inkinekih ma nikkajkava: in barrabás o noso yen Jesús tlen kinotzah Cristo? ");
INSERT INTO nsu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato ijkó okijto porke okimatia ke Jesús okitemaktijkeh porke omoxikovayah de Ye. ");
INSERT INTO nsu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato oyetoka kan teyekankavah. Iva ijkuakó itonana otlatitlanki ma kilvitih: “Amo ximokalaki ivan yejón tlakatl tlen amitla tlajtlakoli kipia, porke nin yovak sa tlawel onimomavti tlen oniktemikki de Ye.” ");
INSERT INTO nsu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","In tlayakankeh tiopixkeh ivan tlayakankeh tetajmeh, okintlatlalvijkeh in gentejtih para ma kitlajtlanilikah in Pilato ma kikajkava in Barrabás, iva ma tlanavati ma kixpolokah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato okintlajtlani: —¿Katli de ninmeh omeh inkinekih ma nikajkava? Yejvah okilvijkeh: —¡Xikajkava in Barrabás! ");
INSERT INTO nsu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato oksemi okintlajtlani: —¿Iva tlán nikchivas ivan nin Jesús, tlen kinotzah Cristo? Nochtin otlanankilijkeh: —¡Xikrusifikaro! ");
INSERT INTO nsu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato okinmilvi: —¿Pero tleka? ¿Tlán okichi? Pero yejvah okachi otzajtziah chikavak: —¡Xikrusifikaro! ");
INSERT INTO nsu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ijkuak Pilato okittak nik amitla velis kichivas para amo ma kixpolokah in Jesús, sino yej okachi omopajsolovayah, ijkuakó otlanavati ma kikuitih atl iva ompa omomajteki inmixpa nochtin, iva okijto: —Ne amo notlajtlakol tla imejvah inkixpoloskeh nin tlakatl tlen tlakamela. Ompa imejvah xikittakah. ");
INSERT INTO nsu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iva nochtin gentejtih otlanankilijkeh: —¡Yejón techkavili tejvah ivan topilvah, ompa tejvah tikmatih de imikilis! ");
INSERT INTO nsu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ijkuakó Pilato okikajka in Barrabás. Iva satepa otlanavati ma kiwitekikah in Jesús, iva okinmaktili in soldadojtih para ma kikrusifikarokah. ");
INSERT INTO nsu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Satepa isoldadojvah in Pilato okivikakeh in Jesús kan palacio, iva nochtin soldadojtih okiyavalojkeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Satepa okikixtilijkeh itzotzol, iva okikentijkeh se kapa chichiltik. ");
INSERT INTO nsu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Okichijchijkeh se korona de vitztli iva okitlalilijkeh itech itzonteko. Okitzkiltijkeh se vara iyekmapa. Omotlankuaketzayah iyakapa iva okipijpinatiayah, okilviayah: —¡Viva in wei tlanavati de judiojtih! ");
INSERT INTO nsu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iva okixchichijchakeh, iva okikixtilijkeh in vara iva ika okikuavijvitekeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Satepa de otlanki okipijpinatijkeh, okikixtilijkeh in kapa chichiltik iva oksemi okonakiltijkeh itzotzol. Satepa okivikakeh para kikrusifikaroskeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ijkuak yoyayah itech ojtli okinamikeh se tlakatl de siudad de Cirene itoka Simón. Iva okichikavilijkeh ma kikechpanili ikrus in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Satepa oajsitoh se lugar itoka Gólgota, kijtosneki Kan Mikatzontekomatl. ");
INSERT INTO nsu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ompa okimakakeh ma koni vino tlen okinelojkeh ika seki xivitl chichik. Pero ijkuak okiyeko, amo okinekki okonik. ");
INSERT INTO nsu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ijkuak yokikrusifikarojkeh, in soldadojtih omotlatlaankeh para kittaskeh tlán kimokaviskeh kada se de yejvah de itzotzol Jesús. Ijkó omochi tlen okijto in tiotenejmachti: “Omotlatlaankeh para okimoxejxelilijkeh notzotzol.” ");
INSERT INTO nsu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Iva satepa omotlalijkeh para kikuidaroskeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iva ik tlakpak de kan ikrus in Jesús okitlalilijkeh se letrero kan kijtojtok tleka okikrusifikarojkeh. Kijtojtok: “NIN YEN JESÚS, TLEN WEI TLANAVATI DE JUDIOJTIH.” ");
INSERT INTO nsu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noijki okinkrusifikarojkeh ome ichtekeh san sekka ivan Jesús, se ik iyekmapa iva se ik iopochmapa. ");
INSERT INTO nsu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iva tlen ik ompa opanovayah otlajtovayah fiero de Ye, iva okoliniayah intzonteko ");
INSERT INTO nsu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","okijtovayah: —¿Amo otikijtovaya ke velis tikxitinis in templo iva san ika eyi tonali oksemi velis tiketzaltis? Te monevia ximomakixti. Xitemo de itech krus tla yi neli tiiKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","In tlayakankeh tiopixkeh, in tlamachtijkeh de itlanavatil Moisés, in fariseos ivan tlayakankeh tetajmeh noijki okipijpinatiayah. Okijtovayah: ");
INSERT INTO nsu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Okinmakixti oksekimeh, pero Ye inevia amo veli momakixtia. Tla yi neli yen wei tlanavati de Israel, ma temo de itech krus, iva titlaneltokaskeh inavak. ");
INSERT INTO nsu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ye motenmachijtok inavak Dios, tonses yen Dios ma kimakixti, tla yi neli kitlasojtla. Porke Ye okijto ke Ye iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tlen ichtekeh tlen okinkrusifikarojkeh ivan Jesús noijki otlajtovayah fiero de Ye. ");
INSERT INTO nsu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ijkuakó itech nochi in tlaltikpaktli otlayovak, desde tlajko tonali iva asta las tres de tiotlaki. ");
INSERT INTO nsu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iva itech yejón ora kemi las tres de tiotlaki, Jesús otzajtzik chikavak, okijto: —Elí, Elí, ¿lama sabactani? —kijtosneki: NoTajtzin Dios, noTajtzin Dios, ¿tleka otechka noselti? ");
INSERT INTO nsu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sekimeh tlen ompa okatkah, okikakkeh iva okijtojkeh: —Nin tlakatl kinotok in tiotenejmachti Elías. ");
INSERT INTO nsu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","San nima ijkuakó se de yejvah omotlelo okikuito se esponja, okapacho ika vinagre, okilpi itech se akatl iva okimakak itech iten para ma koni. ");
INSERT INTO nsu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero oksekimeh okijtojkeh: —Xikava, tikittaskeh kox vitz kipaleviki in tiotenejmachti Elías. ");
INSERT INTO nsu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús oksemi otzajtzik chikavak, iva oixpolivik. ");
INSERT INTO nsu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iva san nima ijkuakó in tzotzoltlatzakuili de kan templo otlajkotzayanki, desde tlakpak asta tlakxitla. Otlalolinki iva in temeh otlajtlapankeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iva in mikatekochtih otlajtlapovikeh, iva miekeh mikameh omoyolitijkeh tlen yolchipavakeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Satepa de ijkuak Jesús omoyoliti, tlen omoyolitijkeh okiskeh de kan inmikatekoch iva okalakeh Jerusalén, iva miekeh okinmitakeh. ");
INSERT INTO nsu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","In kapita iva tlen iva okatkah okikuidarojtokah in Jesús, ijkuak okittakeh otlalolinki iva nochi tlen opanolok, sa tlawel omomavtijkeh iva okijtojkeh: —Nin tlakatl yi neli okatka iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ompa okatkah miekeh sivameh okonittokah san wejka. Yejonmeh sivameh ovalajkeh ivan Jesús desde Galilea asta Jerusalén iva okipaleviayah. ");
INSERT INTO nsu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ompa okatka in María tlen de altepetl Magdala, iva María inmama in Jacobo ivan José. Iva noijki ompa okatka inmama tlen ipilvah in Zebedeo. ");
INSERT INTO nsu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ijkuak yope tlajtlapuyava, ovala kan ikalijtik Pilato se tlakatl tomine de altepetl Arimatea itoka José, tlen noijki onemia ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José oyá okittato in Pilato iva okitlajtlanili ma kimaka ikuerpo in Jesús. Satepa Pilato otlanavati ma kimakakah. ");
INSERT INTO nsu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José okitemovi ikuerpo in Jesús de kan krus iva okikemilo ika se sábana chipavak. ");
INSERT INTO nsu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Iva okikalaki ijtik se mikatekochtli yankuik tlen José okichkuak ikxitlan se tepejxitl. Satepa okitankachojtia se wei tetl tankachtik para ika okitentzaki, iva satepa oyá. ");
INSERT INTO nsu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ompa okatka in María tlen de altepetl Magdala ivan oksé María, oyetokah iyakapan yejón mikatekochtli. ");
INSERT INTO nsu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Omostlatik okatka yi sábado, kijtosneki se tonali satepa de ijkuak motlayektlaliliah in judiojtih para moseviskeh. Ijkuakó in tlayakankeh tiopixkeh ivan fariseos oyajkeh okittatoh in Pilato, ");
INSERT INTO nsu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","iva okilvijkeh: —Nika otimitzitakoh tejwatzi, porke otikilnamikeh ke neká tekajkaya, ijkuak ok onemia, okijto ke ipan eyi tonali satepa de ixpolivis, moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por eso, tejvah tiknekih xitlanavati ma tlakuidarojtokah eyi tonali kan toktok in Jesús. Porke amo san kichiva tlen momachtijkeh yaskeh kikixtitivih yovak, iva satepa kijtojtinemiskeh ke yomoyoliti. Porke tlamo, yejón tlakajkayavalistli yetos okachi pior ke tlen achto. ");
INSERT INTO nsu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato okinmilvi: —Nonka kateh sekimeh soldadojtih. Xikinvikakah iva ompa imejvah xikittakah kuali ma tlakuidarojtokah asta kan veli. ");
INSERT INTO nsu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tonses, oyajkeh iva kuali okitentzakeh in mikatekochtli, iva okiseyarojkeh in tetl tlen ika okitentzakeh, iva ompa okinkajtejkeh in soldadojtih. ");
INSERT INTO nsu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Opanok sábado, iva ijkuak ovalaneski tlen primer tonali de yejón samana, María tlen de altepetl Magdala ivan oksé María, oyajkeh otlachiatoh kan mikatekochtli. ");
INSERT INTO nsu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Iva san nima ijkuakó ovaltlalolinki, porke se iilvikaktlatitlanil in toTeko ovaltemok de ilvikak iva omoketzako kan mikatekochtli, okijkuani in tetl tlen ika otentzaktoka iva ipan omotlali. ");
INSERT INTO nsu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","In ilvikaktlatitlanili opetlania kemi ijkuak tlapetlani, iva itlaken okatka istak kemi mixtli istak. ");
INSERT INTO nsu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","In soldadojtih ijkuak okittakeh, sa tlawel omavkaviviokakeh iva omokajkeh kemi oyeskia omikkeh. ");
INSERT INTO nsu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","In ilvikaktlatitlanili okinmilvi in sivameh: —Amo ximomavtikah. Ne kuali nikmati ke imejvah inkitemovah in Jesús tlen okikrusifikarojkeh. ");
INSERT INTO nsu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mach ok nika kajki, Ye yomoyoliti ijkó kemi Ye yokijtojka. Xivikikah xikittakih kan okitlalijkah. ");
INSERT INTO nsu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iva xiviah san nima xikinmilvitih in momachtijkeh ke Jesús yomoyoliti. Iva Ye tlayakanas yas para Galilea iva ompa kittaskeh. Yen nin tlen omonekia nimechilvis. ");
INSERT INTO nsu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ijkuakó in sivameh oyajkeh san nima de kan mikatekochtli, oyajkeh de ompa ika miek nemavtili pero noijki ika miek pakilistli. Omotlelojkeh okinmatiltitoh in momachtijkeh de Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pero san de repente Jesús okinnamiki itech ojtli iva okintlajpalo. In sivameh omotokijkeh inavak, okikxinavajtekeh iva okiweijkachijkeh. ");
INSERT INTO nsu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iva Jesús okinmilvi: —Amo ximomavtikah. Xiviah xikinmilvitih noknivah ma viah para Galilea, iva ompa nechitaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mientras in sivameh oyajkeh, sekimeh soldadojtih tlen otlakuidarojtokah kan mikatekochtli, oyajkeh para Jerusalén okinmatiltitoh in tlayakankeh tiopixkeh nochi tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yejonmeh tiopixkeh omotlatlalvijkeh ivan tlayakankeh tetajmeh, iva okinmakakeh miek tomi in soldadojtih, ");
INSERT INTO nsu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","iva okimilvijkeh: —Imejvah xikijtokah in momachtijkeh oyajkeh yovak okichtekitoh in kuerpo, mientras imejvah onkochtokah. ");
INSERT INTO nsu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iva tla in kobernador kimatis ke onkochtokah iva kualanis, tejvah ivan timotlapoviskeh para amitla ma imechilvi. ");
INSERT INTO nsu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tonses in soldadojtih okiselijkeh in tomi iva okichijkeh ijkó kemi okinmilvijkeh. Iva yejón istlakayotl asta axka ijkó kineltokah in judiojtih. ");
INSERT INTO nsu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","In majtlaktli ivan se momachtijkeh oyajkeh para Galilea ipan se tepetl kan Jesús okinmilvi ompa mottaskeh. ");
INSERT INTO nsu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iva ijkuak okittakeh in Jesús, okiweijkachijkeh. Maski sekimeh amo okiyekneltokayah kox yen Jesús. ");
INSERT INTO nsu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús omotoki innavak iva okinmilvi: —NoTajtzin Dios onechmakak nochi in velitilistli para Ne ma nitlanavati itech nochi in ilvikak iva itech nochi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Axka, xiviah iva xikinmachtikah nochtin tlaltikpaktlakah para noijki ma yekah momachtijkeh de Ne. Iva xikinbautisarokah ika itoka in Tata Dios, ika itoka iKone, iva ika itoka in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iva xikinmachtikah ma kichivakah nochi tlen Ne yonimechnavati. Iva xikilnamiktokah ke Ne imovah nietos nochipa asta ijkuak tlamis in tlaltikpaktli. Ijkó ma yeto.");
INSERT INTO nsu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ijkí nik ope motematiltia tlen yankuik kuali tlajtoli de Jesucristo iKone toTajtzin Dios. ");
INSERT INTO nsu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","In tiotenejmachti Isaías yi wejkavitl ijkí okijkuilo: Ne niktitlani notlatitlanil moyakapa, ma sa kiyektlali mooviv. ");
INSERT INTO nsu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Se tlajtoli mokaki chikavak tetzajtzilia kan tlavaki, kijtova: “Xikyektlalikah iva xikmelavakah iojviv in toTeko.” ");
INSERT INTO nsu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yejón tlatitlanili yen Juan tlen tlabautisaro. Okatka kan tlavaki iva otetlapoviaya, okinmilviaya in gentejtih ma moyolkuapakah iva ma mobautisarokah para ijkó Dios kintlapojpolvis de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nochtin gentejtih de tlali de Judea, iva de siudad de Jerusalén, ovalayah inavak iva okimokuitiayah intlajtlakol, iva Juan okinbautisarovaya ijtik in weyatl Jordán. ");
INSERT INTO nsu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Itzotzol in Juan ochijchitoka ika itzojmio kameyo iva omotlajkoilpiaya ika se kuetlaxtli. Okinkuaya chapulimeh iva okikuaya serajnektli tlen onka itech tepetl. ");
INSERT INTO nsu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan okinmilviaya: —Satepa de ne vitz se tlen okachi velitini iva amo kemin ne. Iva ne nion amo notech povi para nimotoolos nikaktotomas. ");
INSERT INTO nsu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne nimechbautisarova ika atl pero Ye imechbautisaros ika Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Itech yejonmeh tonaltih, Jesús ovala de altepetl Nazaret tlen kajki itech tlali de Galilea, iva Juan okibautisaro in Jesús ijtik in weyatl Jordán. ");
INSERT INTO nsu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ijkuak Jesús ovalkiski de ijtik atl, ijkuakó okittak in ilvikak otlapovik iva in Tioijyotzintli ovaltemok ipan Jesús kemi se palomax. ");
INSERT INTO nsu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iva omokakki se tlajtoli itech ilvikak, okijto: —Te tinoKone tlen nimitztlasojtla, iva sa tlawel nikpia pakilistli monavak. ");
INSERT INTO nsu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ijkuakó in Tioijyotzintli okitokti in Jesús ma via kan tlavaki. ");
INSERT INTO nsu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ompa omoka ompoali tonali iva in Amo Kuali Tlakatl okiyejyeko ika tlajtlakoli, iva Jesús okatka intzala yolkameh tekuanimeh, pero satepa ovalajkeh in ilvikaktlatitlaniltih iva okiservirojkeh. ");
INSERT INTO nsu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Satepa de okitzakeh in Juan telpiloya, Jesús oyá Galilea okitematiltito in yankuik kuali tlajtoli de Dios. ");
INSERT INTO nsu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Okijtovaya: —Ya yi kajki serka para Dios pevas tlanavatis imonavak. Ximoyolkuapakah iva xikneltokakah in yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús opanotiaya itempan atl tlen wei de Galilea iva ompa okittak in Simón ivan ikni Andrés, okitlamotlatokah inred ijtik atl porke yejvah okatkah michkitzkijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iva okinmilvi: —Xivikikah nova. Ne nimechmachtis kenik inkintlaniskeh in gentejtih para ma nechseguirokah kemi oyeskia inkinkitzkiskeh michimeh. ");
INSERT INTO nsu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","San nima okinkajtejkeh inredvah iva oyajkeh Iva. ");
INSERT INTO nsu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ok achitzi tlayakapa, okinmitak in Jacobo ivan ikni Juan, itelpochvah Zebedeo, okatkah ijtik se barko okintlajtlamanijtokah inredvah. ");
INSERT INTO nsu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","San niman okinnotzki, iva yejvah oyajkeh Iva. Ompa okajtejkeh inpapa Zebedeo ijtik barko ivan itlakevalvah. ");
INSERT INTO nsu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oajsitoh kan altepetl de Capernaum, iva ijkuak oajsik sábado, Jesús okalakki kan tiotlamachtijkali iva ope kinmachtia. ");
INSERT INTO nsu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","In gentejtih asta okimotetzaviayah de kenik okinmachtiaya, porke otlamachtiaya ika tlanavatijkayotl iva amo kemi in tlamachtijkeh de itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kan yejón tiotlamachtijkali okatka se tlakatl tlen okipiaya se amo kuali ejekatl, iva chikavak otzajtzik, okijto: ");
INSERT INTO nsu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Tlán tikneki tovah, Jesús de Nazaret? ¿Otivala otechixpoloko? Ne nikmati akin Te, Te tiyolchipavak tiiKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús okajvak in amo kuali ejekatl, iva okilvi: —¡Xiktzakua mokamak, iva xikisa de itech yejón tlakatl! ");
INSERT INTO nsu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","In amo kuali ejekatl okitzejtzelo, otzajtzik chikavak iva okiski de itech in tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nochtin okimotetzavijkeh iva omotlajtlaniayah: —¿Tlán kijtosneki nin tlamantli? ¡Tlamachtia ika se tlamantli yankuik iva chikavak tlanavatia! ¡Asta in amo kuali ejekameh kinnavatia iva yejvah kivelkakih! ");
INSERT INTO nsu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iva san nima nochtin okimatkeh tlen Jesús okichivaya itech nochi in tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ijkuak okiskeh de kan tiotlamachtijkali, Jesús, Jacobo ivan Juan, oyajkeh para kan ikalijtik in Simón ivan Andrés. ");
INSERT INTO nsu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Imonna in Simón ovettoka ika miek totonik. Iva san nima okilvijkeh in Jesús ke imonna in Simón mokokova. ");
INSERT INTO nsu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús oyá okittato, okimakitzki iva okevalti. Iva san nima okiski in totonik, iva ye ope kintlamaka. ");
INSERT INTO nsu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ijkuak opolivito in tonali iva otlayovak, okinvikilijkeh in Jesús nochtin kokoxkeh iva tlen okinpiayah amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iva nochtin altepetlakah omololojkeh kaltempa. ");
INSERT INTO nsu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús okinpajti de miek kokolistli, iva okinkixti miekeh amo kuali ejekameh, pero amo okinkavili in amo kuali ejekameh ma tlajtokah porke yejvah okimatiah akin Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","San kualka ok tlayova, Jesús omejki iva okiski, iva oyá sekka kan tlalkavali para modiostzajtzilis. ");
INSERT INTO nsu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Satepa, Simón ivan iyoliknivah, oyajkeh okitemotoh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ijkuak okajsikeh okilvijkeh: —Nochtin mitztemovah. ");
INSERT INTO nsu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iva Ye okinmilvi: —Ma tiviah intech oksekimeh altepemeh tlen kateh serka, kan noijki velis nikintlapovis porke para yejón nik onivala. ");
INSERT INTO nsu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús onenki itech nochi in tlali de Galilea otetlapovijtia kan tiotlamachtijkaltih, iva okinkixtijtia in amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Se tlakatl tlen opalania inakayo omotoki inavak Jesús, omotlankuaketzki iva okilvi: —Tla tikmonekiltis, velis techpajtis. ");
INSERT INTO nsu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús okiknomatki, okitlali ima ipan yejón tlakatl iva okilvi: —Kema nikneki. Xipajti. ");
INSERT INTO nsu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","San nima ijkuakó okiski in nakayopalanilistli iva omoka chipavak. ");
INSERT INTO nsu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús okimaka iva kuali okinajnavati: ");
INSERT INTO nsu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Amika xiktlapovi de nin tlamantli. Xivia iva ximoteititi inavak in tiopixki, iva xiktemaka motlamanal ijkó kemi kijtova itlanavatil Moisés, para ijkó nochtin ma kimatikah nik yotichipavik de mokokolis. ");
INSERT INTO nsu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero in tlakatl oyá iva ope nochtin kintlapovia de kenik opajtik. Por eso Jesús ayakmo ovelia okalakia itech altepemeh, sino omokavaya kan tlalkavali kan amika chanti. Iva maski ijkó, in gentejtih de nochtin altepemeh oyayah okonitayah. ");
INSERT INTO nsu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kana keski tonali satepa, Jesús oksemi omokuapki para Capernaum. In gentejtih okimatkeh nik in Ye okatka itech se kali. ");
INSERT INTO nsu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Miekeh gentejtih omololojkeh, iva ayakmo oakiah kalijtik nion kaltempa. Iva Ye okintlapoviaya de itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ijkuakó ovalajkeh navi tlakah kan okatka in Jesús, okivalikiliayah se tlakatl vilantzi. ");
INSERT INTO nsu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Komo okatka sa tlawel miek gente, amo ovelik oajsitoh asta inavak Jesús. Ijkuakó okikuatlapojkeh in kali iva ik ompa okitemovijkeh ipan ikochpetl kan okatka in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ijkuak Jesús okittak intlaneltokalis, ijkuakó okilvi in vilantzi: —Nokone, nimitztlapojpolvia de nochi motlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sekimeh tlamachtijkeh de itlanavatil Moisés ompa oyetokah, iva okijtojkeh itech inyolo: ");
INSERT INTO nsu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ken mixevia ijkó kijtova? Kixpanavia in Dios. San yen Dios velis tetlapojpolvis.” ");
INSERT INTO nsu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús san nima okimatki tlen yejvah okiyejyekovayah, iva okinmilvi: —¿Tleka imejvah ijkó inkiyejyekovah? ");
INSERT INTO nsu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Katli yen okachi amo ovi nikilvis nin vilantzi: “Nimitztlapojpolvia de nochi motlajtlakol”, o noso nikilvis: “Ximeva. Xikajkuana mokochpetl iva xinejnemi”? ");
INSERT INTO nsu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero Ne nimechititis ke iKone in Tlakatl kipia velitilistli itech nin tlaltikpaktli, iva veli tetlapojpolvia de nochi tlajtlakoli. Iva okilvi in vilantzi: ");
INSERT INTO nsu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Tejwatzi nimitzilvia, ximeva, xikajkuana mokochpetl iva xivia mokalijtik. ");
INSERT INTO nsu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ijkuakó san nima omoketevak, okajkuanki ikochpetl iva okiski nejnentiv inmixpan nochtin. Nochtin omotetzavijkeh iva okiweijkachijkeh toTajtzin Dios, iva okijtojkeh: —¡Amo semi otikittayah se tlamantli kemi nin! ");
INSERT INTO nsu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús oksemi oyá itempan atl tlen wei de Galilea. Miekeh gentejtih omotokijkeh inavak, iva Ye okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Oyá okachi tlayakapa iva okittak in Leví, itelpoch in Alfeo, oyetoka kan tlakobrarovah de impuestos. Jesús okilvi: —Xiviki nova. Leví omoketzki iva oyá ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Satepa, Jesús iva tlen okinmachtiaya otlakuajtokah kan ikalijtik Leví, miekeh kobradortih de impuestos iva miekeh tlajtlakolejkeh noijki ompa otlakuajtokah Iva. Porke miekeh gentejtih kemi yejonmeh okitokayah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","In tlamachtijkeh de itlanavatil Moisés tlen opoviah ivan fariseos, ijkuak okittakeh in Jesús otlakuajtoka ivan kobradortih de impuestos iva noijki ivan tlajtlakolejkeh, okintlajtlanijkeh in momachtijkeh: —¿Tleka Jesús tlakua iva koni ivan kobradortih de impuestos iva tlen tlajtlakolejkeh? ");
INSERT INTO nsu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús okinkakki iva okinmilvi: —Tlen amo mokokovah amo yavih kittativih se tepajti, sino tlen mokokovah. Ne amo onivala para nikinnotzas tlen tlakamelajkeh, sino tlen tlajtlakolejkeh. ");
INSERT INTO nsu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Se tonali, tlen momachtijkeh de Juan iva tlen momachtijkeh de fariseos omosavtokah. Iva ijkuakó sekimeh tlakah omotokijkeh inavak Jesús iva okitlajtlanijkeh: —¿Tleka tlen momachtijkeh de Juan iva tlen de fariseos, yejvah mosavah iva tlen tejwatzi tikinmachtia amo mosavah? ");
INSERT INTO nsu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús okinmilvi: —¿Kox velis mosavaskeh tlen kinminvitarovah kan monamiktiah mientras in novio ompa ka invah? Mientras ompa kajki in novio amo velis mosavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero ajsis tonali ijkuak in novio kivikaskeh, iva ijkuakó velis mosavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Amika kitlamania se tzotzoli tlen yi tlajtlantok ika se retaso de tela yankuik, porke in tela tlen yankuik kototzivi iva kitzomonia in tzotzoli tlen yi tlajtlantok, iva okachi tzomoni. ");
INSERT INTO nsu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Amika kitlalia yankuik vino ika kulambre tlen yi tlajtlantok, porke in yankuik vino kitzomonia in kulambre tlen yi tlajtlantok, iva nokivi in vino iva in kulambre ijtlakavi. In yankuik vino moneki motlalis ika kulambre yankuik. ");
INSERT INTO nsu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se sábado Jesús ivan momachtijkeh onejnentiayah kan toktok trigo, iva tlen momachtijkeh ope kikuakojkotonah in trigo. ");
INSERT INTO nsu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","In fariseos okilvijkeh: —Xikitta, ¿tleka tlen tikinmachtia kichivah tlen amo kipia de kichivaskeh ijkuak sábado? ");
INSERT INTO nsu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iva Ye okinmilvi: —¿Amo kema inkilerovah tlen okichi in David ijkuak ye ivan iyoliknivah otiojsijkeh iva amo okipiayah tlán kikuaskeh? ");
INSERT INTO nsu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ijkuak Abiatar okatka wei tiopixki, David okalakki ikalijtik in Dios iva okikua in pan tlen tlatiochivali. Itlanavatil Moisés kijtova ke san yejvah tiopixkeh velis kikuaskeh yejón pan, pero David okikua iva asta okinmajmakak iyoliknivah. ");
INSERT INTO nsu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús noijki okinmilvi: —Dios okichi in sábado se kuali para yen gentejtih, iva amo okinchi in gentejtih se kuali para yen sábado. ");
INSERT INTO nsu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Por eso, tlen iKone in Tlakatl yen tekova de yejón sábado iva yen velis kijtos tlán velis se kichivas itech yejón tonali. ");
INSERT INTO nsu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús oksemi okalakki kan tiotlamachtijkali. Ompa okatka se tlakatl tlen ovaki se ima. ");
INSERT INTO nsu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sekimeh fariseos sa okistlakojtokah in Jesús kox kipajtis yejón tlakatl ijkuak sábado para ijkó velis kiteilviskeh. ");
INSERT INTO nsu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ijkuakó Jesús okilvi in tlakatl tlen ovaki ima: —Ximeva iva ximoketza tlatlajko. ");
INSERT INTO nsu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Satepa, Jesús okintlajtlani: —¿Tlán moneki se kichivas ijkuak sábado, tlen kuali o noso tlen amo kuali? ¿Moneki se kimakixtis inemilis se tlakatl o noso se kixpolos? Pero yejvah amitla okijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús okintlajtlatak nochtin ika kualanilistli, omoyolkoko porke okatkah sa tlawel yoltlakuavakeh. Satepa okilvi tlen ovaki ima: —Xikmelava moma. In tlakatl okimela ima iva opajtik. ");
INSERT INTO nsu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","In fariseos okiskeh iva oyajkeh omotlatlalvitoh ivan tlen opoviah ivan Herodes, para kittaskeh kenik velis kixpoloskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús ivan momachtijkeh oyajkeh kan atl tlen wei. Iva okitokakeh miekeh gentejtih de Galilea, de Judea, ");
INSERT INTO nsu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","de Jerusalén, de Idumea, de ik nepa lado de kan weyatl Jordán iva de región de Tiro iva de Sidón. Nochtin okiskeh okittatoh porke okikakkeh ke okinchivaya miekeh tlamantih wejweih. ");
INSERT INTO nsu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ye okinmilvi in momachtijkeh sa ma kipixtokah listo se barko, porke okatkah miekeh gentejtih iva amo okinekia ma kipajpatzmiktikah. ");
INSERT INTO nsu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Okinpajti sa tlawel miekeh, iva por eso nochtin kokoxkeh asta omotojtopevayah, porke nochtin okinekiah kitilkoskeh para pajtiskeh. ");
INSERT INTO nsu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ijkuak in amo kuali ejekameh okittayah in Jesús, omotlankuaketzayah iyakapa iva otzajtziah chikavak: —¡Te tiiKone in Dios! ");
INSERT INTO nsu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús okinnavati chikavak amika ma kilvikah akin Ye. ");
INSERT INTO nsu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús otlejkok ipan se tepetl, iva okinnotzki tlen Ye okinpejpenki. Iva yejvah omotokijkeh inavak. ");
INSERT INTO nsu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Satepa okinpejpenki majtlaktli ivan ome iva okintokayoti tiotlatitlaniltih, para ma yekah Iva, iva para kintitlanis ma tetlapovikah, ");
INSERT INTO nsu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","iva okinmakak velitilistli para kinpajtiskeh kokoxkeh iva para kinkixtiskeh amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ninmeh yejvah majtlaktli ivan ome tlen Jesús okinpejpenki: Simón tlen okitokayoti Pedro, ");
INSERT INTO nsu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo ivan Juan, tlen itelpochvah Zebedeo, tlen Jesús okintokayoti Boanerges, kijtosneki Ipilvah in Tlatikuinili. ");
INSERT INTO nsu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Noijki okinpejpenki in Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo itelpoch in Alfeo, Tadeo, Simón tlen onemia invan cananistas, ");
INSERT INTO nsu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","iva Judas Iscariote, tlen satepa okitemakti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Satepa Jesús okalakki itech se kalijtik. Oksemi omololo miek gente, iva Ye ivan momachtijkeh asta ayakmo ovelia otlakuayah. ");
INSERT INTO nsu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ijkuak ifamiliajvah in Jesús okimatkeh nik ompa okatka, ovalajkeh para kivikaskeh, porke okijtovayah yokuatlapolo. ");
INSERT INTO nsu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iva in tlamachtijkeh de itlanavatil Moisés tlen ovalajkeh de Jerusalén okijtovayah: —Nin tlakatl kipia ijtik in Beelzebú, tlen tlayakanki de amo kuali ejekameh. Beelzebú okimakak ivelitilis para ma kinkixti in amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús okinnotzki iva okinmakak se ejemplo. Okinmilvi: —¿Kenik velis in Amo Kuali Tlakatl kikixtis in Amo Kuali Tlakatl? ");
INSERT INTO nsu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tla in gentejtih de se país pevas kimomagaskeh san mismo yejvah, yejón país popolivis. ");
INSERT INTO nsu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tla se familia pevas kimomagaskeh san mismo yejvah, yejón familia mach wejkavas yeskeh san sekka. ");
INSERT INTO nsu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tla in Amo Kuali Tlakatl san ye mismo kimomagas iva motlajkoxelos, nochi tlen ye kinavatia mach wejkavas, yejón yetos itlamilis in Amo Kuali Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Amika velis kalakis ikalijtik se tlakatl tlen chikavak para kikixtilis tlen iaxka. Moneki achto kijilpis para velis kikixtilis tlen kipia ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Yi neli nimechilvia, Dios kintlapojpolvis in tlaltikpaktlakah de nochi tlajtlakoli tlen kichivah iva asta yen tlajtoli fiero tlen kijtoskeh kontra Dios. ");
INSERT INTO nsu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero tla íkka kijtos itla tlajtoli tlen amo kuali en kontra de yen Tioijyotzintli, Dios amo keman kitlapojpolvis, sino yetos tlajtlakole para semijkak. ");
INSERT INTO nsu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús ijkó okinmilvi porke yejvah okijtojkeh ke Ye kipia se amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ijkuakó oajsikoh imama ivan iknivah in Jesús, pero omokajkeh kiavak iva ontlanavatijkeh ma konnotzakah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","In gentejtih tlen oyejyetokah iva okiyavalojtokah, okilvijkeh: —Momama ivan moknivah kateh kiavak mitztemovah. ");
INSERT INTO nsu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ye okinnankili: —¿Akin nomama iva akinmeh noknivah? ");
INSERT INTO nsu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Okintlajtlatak tlen ompa oyejyetokah iva okiyavalojtokah, iva okijto: —Ninmeh yejvah nomama iva noknivah. ");
INSERT INTO nsu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porke tlen kichiva tlen Dios kimonekiltia, yen yejón nokni tlakatl, yen yejón nokni sivatl iva yen yejón nomama. ");
INSERT INTO nsu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús oksemi ope tlamachtia itempan atl tlen wei. Sa tlawel miek gente omololo inavak, iva mejor otlejkok itech se barko tlen okatka itech atl iva itech omotlali. Iva nochtin gentejtih okatkah itempan atl. ");
INSERT INTO nsu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Okinmachti de miek tlamantli iva okintlapovi ika ejemplos. Itech itlamachtil, okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—¡Kuali xikakikah tlen nimechilvis! Se tlakatl okiski okitookato trigo. ");
INSERT INTO nsu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ijkuak otookatoka, seki semiya ovetzki ipan ojtli. Ovalajkeh in totomeh iva okikuajkeh. ");
INSERT INTO nsu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Okseki ovetzki kan teyo, kan amo okipiaya miek tlali. Komo in tlali amo okatka tilavak, san nima oixvak. ");
INSERT INTO nsu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero ijkuak okiski in tonali, okitlati, iva komo amo wejkatla omonelvayoti, ovaki. ");
INSERT INTO nsu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Okseki semiya ovetzki ijtik xivyo tlen vitzo, omoskalti miek xivitl vitzo iva in tlatoktli oxivmiki. ");
INSERT INTO nsu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Okseki semiya ovetzki kan kuali tlali, oixvak iva kuali otlaki. Seki tlatoktli okitemakak san de se semiya senpoali ivan majtlaktli tleyoltzintli de trigo, iva sekimeh okitemakakeh expoali tleyoltzintli iva sekimeh okitemakakeh asta se siento tleyoltzintli. ");
INSERT INTO nsu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iva okinmilvi: —Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ijkuak omoka sa yen Jesús ivan majtlaktli ivan ome momachtijkeh iva tlen oksekimeh tlen omololojkah, ijkuakó okitlajtlanijkeh tlán kijtosneki in ejemplo de yen tlatookak. ");
INSERT INTO nsu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús okinmilvi: —Imejvah Dios imechkavilia xikmatikah tlen achto amika okimatia de kenik in Dios tlanavatia. Oksekimeh tlen amo tovan povih, Ne nikinmachtia ika ejemplos, ");
INSERT INTO nsu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","para ijkó, maski kittah tlen nikchiva, amo kimomakah kuenta tlán kijtosneki. Iva maski kikakih tlen nikijtova, amitla kajsikamatih, para amo ma moyolkopakah iva Dios amo ma kintlapojpolvi de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús okinmilvi: —¿Amo inkajsikamatih nin ejemplo? Tonses, ¿kenik velis inkajsikamatiskeh tlen oksekimeh ejemplos? ");
INSERT INTO nsu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tlen tlatookak yen tlen tetlapovia de itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","In semiya tlen ovetzki itech ojtli yejvah tlen kikakih in tlajtoli, pero san nima vitz in Amo Kuali Tlakatl iva kinkixtilia in tlajtoli tlen omotookak itech inyolo. ");
INSERT INTO nsu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","In semiya tlen ovetzki kan teyo yejvah tlen kiseliah itlajtol in Dios ika pakilistli ijkuak kikakih. ");
INSERT INTO nsu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero komo amo wejkatla monelvayotiah, nima nelvayovakih. Ijkuak peva tlajyoviah iva peva kinchochololtiah por itlajtol in Dios, valmoxijxikovah iva sa ompa mokavah. ");
INSERT INTO nsu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","In semiya tlen ovetzki ijtik xivyo tlen vitzo yejvah tlen kikakih itlajtol in Dios, ");
INSERT INTO nsu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero kintekipachova miek tlamantli tlen onka itech nin tlaltikpaktli, kinmixkajkayava in tomi, iva kinekih kipiaskeh miek tlamantli. Nochi nin tlamantli kixivmiktia itlajtol in Dios tlen omotookak itech inyolo, iva mokavah kemi tlatoktih tlen amo tlakih. ");
INSERT INTO nsu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","In semiya tlen omotookak kan kuali tlali yejvah tlen kikakih itlajtol in Dios, iva kiseliah iva kitemakah miek tlakilotl. Sekimeh kitemakah senpoali ivan majtlaktli tleyoltzintli san de se semiya, iva sekimeh kitemakah expoali, iva sekimeh kitemakah asta se siento. ");
INSERT INTO nsu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús okinmilvi: —Amika kitlalia se tlavili itlampa se kajo o itlampa se kochtlapechtli, sino kitlaliah tlakpak para ma tlavi. ");
INSERT INTO nsu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nochi tlen kajki tlaatitok kipia de paninesis, iva nochi tlen amo momati kipia de momatis. ");
INSERT INTO nsu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús okinmilvi: —Moneki kuali xikakikah tlen inkikakih. Ijkó kemi imejvah inkintamachivaskeh tlen oksekimeh, imejvah noijki ijkó imechtomachivaskeh, iva imechmakaskeh asta okachi miek. ");
INSERT INTO nsu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porke tlen kipia, kimakaskeh okachi. Pero tlen amo kipia, asta yen tlen kipia kikixtiliskeh. ");
INSERT INTO nsu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús noijki okijto: —Kan Dios tlanavatia yejón kemi se tlakatl tlen kitooka semiya itlala. ");
INSERT INTO nsu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tla kochis o noso ijsatos, o noso tla tlayovatos o noso tlanestos, in semiya ixva iva moskaltia, maski in tlatookak amo kimati kenomi. ");
INSERT INTO nsu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Inevia in tlali kitlakiltia in tlatoktli. Achto moxivyotia, para ompa miavati, iva satepa motleyolotia. ");
INSERT INTO nsu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iva tla yochikavak, kitekih ika ojoso porke yoajsik tonali para kololoskeh. ");
INSERT INTO nsu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús noijki okinmilvi: —¿Kenik velis nimechilvis para xikajsikamatikah kenik tlanavatia in Dios? O noso, ¿tlán ika velis se kiparejaros? ");
INSERT INTO nsu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yejón kemi oyeskia se semiyajtzi de mostaza tlen kitookah kan tlali. Yen tlen okachi tzikitzi de nochtin semiyajtih. ");
INSERT INTO nsu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero ijkuak se kitooka, moskaltia okachi wei ke okseki tlamantli de kilitl. Moskaltiah wejwei imamayovah iva in totomeh asta motepajsoltiah itlampa iekavil. ");
INSERT INTO nsu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús okintlapovi ika miek ejemplos kemi nin. Okintlapovi ijkó kemi tlen yejvah oveliah okajsikamatiah. ");
INSERT INTO nsu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nochipa okintlapoviaya ika ejemplos. Pero ijkuak okatka san Ye ivan momachtijkeh, nochi kuali okinyekilviaya para ma kajsikamatikah. ");
INSERT INTO nsu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yejón tonali ijkuak otlayovak, Jesús okinmilvi tlen momachtijkeh: —Ma tipanokah ik nepa lado de nin atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yejvah okinkajtejkeh nochtin gentejtih, iva oyajkeh ivan Jesús itech se barko tlen itech yokatka. Oksekimeh barkojtih noijki okintokakeh. ");
INSERT INTO nsu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Satepa ovala se ejekatl chikavak iva in atl ope motlatlaviteki itech barko iva ope atemi. ");
INSERT INTO nsu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús okochtoka tlakuitlapa ipan se tzompali. Iva okijxitijkeh okilvijkeh: —¡Tlamachti! ¿Amo mitztekipachova tla tipoolakiskeh? ");
INSERT INTO nsu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús omoketzki iva okitlakavalti in ejekatl. Iva okilvi in atl tlen wei: —¡Ximoketza! ¡San xieto! In ejekatl omoketzki iva omoka sa tlamantok. ");
INSERT INTO nsu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús okinmilvi in momachtijkeh: —¿Tleka sa tlawel inmomavtiah? ¿Ayamo intlaneltokah? ");
INSERT INTO nsu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yejvah sa tlawel omomavtijkeh iva okijtojkeh entre yejvah: —¿Akin nin tlakatl, porke asta in ejekatl ivan atl tlen wei kivelkakih? ");
INSERT INTO nsu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iva oajsitoh ik nepa lado de kan atl tlen wei kan región de Gadara. ");
INSERT INTO nsu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ijkuak Jesús otemok de kan barko, san nima ijkuakó se tlakatl omotoki inavak. Yejón tlakatl ovalkiski de kan mikatekochtih iva okipiaya se amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yejón tlakatl ochantia kan mikatekochtih. Amika ovelia okijilpiaya nion ika kadena. ");
INSERT INTO nsu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Miek welta okimaijilpiayah ika kadena iva okitzikovayah itech ikxivah ika se tepostli, pero okinkojkotonaya in kadenajtih iva okinpojpostekia in tepostih de itech ikxivah. Amika ovelia okitlaniliaya. ");
INSERT INTO nsu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ika tonali ika yovali onemia kan tepeyo iva kan mikatekochtih, otzajtzitinemia chikavak iva omotejtekia ika tetl. ");
INSERT INTO nsu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ijkuak yejón tlakatl okittak in Jesús desde wejka, omotlelo iva omotlankuaketzki iyakapa. ");
INSERT INTO nsu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Chikavak otzajtzik iva okijto: —¿Tlán tikneki nova, Jesús, iKone in Dios tlen Weijkatlalitok? ¡Ika itoka in Dios, nimitztlatlavtia amo techtlajyovilti! ");
INSERT INTO nsu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ijkó okijto porke Jesús yokilvijka in amo kuali ejekatl: —¡Te ejekatl amo tikuali, xikisa de itech nin tlakatl! ");
INSERT INTO nsu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús okitlajtlani: —¿Tlán motoka? Ye okinankili: —Notoka Miektikeh porke timiekeh. ");
INSERT INTO nsu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","In amo kuali ejekameh sa tlawel omotlatlavtijkeh inavak Jesús amo ma kinkixti de kan yejón región. ");
INSERT INTO nsu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ik ompa okatkah sa tekitl miekeh kochijtih otlakuajtokah inakastlan tepetl. ");
INSERT INTO nsu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ijkuakó in amo kuali ejekameh okitlatlavtijkeh in Jesús, okilvijkeh: —Techtitlani ma tikalakikah inmijtik nekateh kochijtih. ");
INSERT INTO nsu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús okinkavili, iva in amo kuali ejekameh okiskeh de ijtik in tlakatl iva okalakeh inmijtik in kochijtih, tlen okatkah kemi ome mil. In kochijtih okikistevakeh iva omotepejxivitoh kan atl tlen wei iva ompa omatlanvijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","In tlajpixkeh de kochijtih ocholojkeh, iva oyajkeh okitematiltitoh kan altepetl iva ik tlala. Iva miekeh oyajkeh okittatoh tlen otlamochivalok. ");
INSERT INTO nsu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ijkuak oajsikoh kan okatka in Jesús, okittakeh in tlakatl tlen okinpiaya miekeh amo kuali ejekameh, yetok, yi tzotzolejtok iva yotlalnamiki, iva nochtin omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tlen okittakeh tlen otlamochivalok, okinmilvijkeh in gentejtih kenik opajtik in tlakatl tlen okinpiaya amo kuali ejekameh iva tlán omochijkeh in kochijtih. ");
INSERT INTO nsu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ijkuakó okitlatlavtijkeh in Jesús ma via de ompa de yejón región. ");
INSERT INTO nsu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ijkuak Jesús otlejkok itech barko, ijkuakó in tlakatl tlen okinpiaya amo kuali ejekameh okitlatlavti ma kivika. ");
INSERT INTO nsu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús amo okavili, iva okilvi: —Xivia mokalijtik kan kateh mofamiliajvah, iva xikinmilvi nochi tlen toTeko okinchi por te, iva kenik omitziknomatki. ");
INSERT INTO nsu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","In tlakatl oyá itech nochtin altepemeh de kan región de Decápolis iva ompa ope kintlapovia in gentejtih tlen Jesús okichi por ye. Iva nochtin omotetzaviayah. ");
INSERT INTO nsu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús oksemi opanok itech barko oksé lado de kan atl tlen wei, iva miekeh gentejtih omololojkeh inavak ompa itempan atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ijkuakó ovala se tlakatl itoka Jairo, tlen okatka tlayakanki itech tiotlamachtijkali. Ijkuak okittak in Jesús, omotlankuaketzki ikxitla, ");
INSERT INTO nsu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","iva okitlatlavti miek, okilvi: —Notakotzi yi ixpolitok. Nimitztlatlavtia xiviki iva xikintlali momavah ipa para ma pajti iva ma ok nemi. ");
INSERT INTO nsu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús oyá ivan Jairo iva miekeh gentejtih okitokayah, asta sa okipajpatzmiktiayah. ");
INSERT INTO nsu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ompa intzala oyaya se sivatl tlen omokokovaya. Yokipiaya majtlaktli ivan ome xivitl de omotlapalojviti. ");
INSERT INTO nsu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Otlajyoviaya miek inmak miekeh tepajtijkeh iva yokitlami nochi itomi tlen okipiaya iva amo opajtia, sino yej okachi omochivaya. ");
INSERT INTO nsu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ijkuak okimatki omotlapoviayah de Jesús, omotoki ik ikuitlapa intzalan gentejtih, iva okitzkili itlaken tlen kimokentia. ");
INSERT INTO nsu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Porke okiyejyeko: “Tla sikiera onikitzkiliskia itlaken, velis nipajtis.” ");
INSERT INTO nsu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iva san nima omoketzki in estli, iva okimachili itech ikuerpo nik opajtik de neká tlajyovilistli. ");
INSERT INTO nsu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús okimomakak kuenta ke okiski velitilistli de itech. Omokuapki iva okinmitak nochtin gentejtih iva okintlajtlani: —¿Akin okitzki notlaken? ");
INSERT INTO nsu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","In momachtijkeh okilvijkeh: —Miek gente mitzpajpatzmiktiah. ¿Iva ok titlajtlani akin okitzki motlaken? ");
INSERT INTO nsu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús okintlajtlatak tlen okiyavalojtokah para kittas akin okikitzkili itlaken. ");
INSERT INTO nsu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","In sivatl omomavti iva sa oviviokatoka porke yokimatia tlen itech yomochi. Omotoki iva omotlankuaketzki inavak Jesús, iva okilvi nochi tlen melajkayotl. ");
INSERT INTO nsu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iva Jesús okilvi: —Nokone, motlaneltokalis yomitzpajti. Xivia ika kuali, yokiski tlen omitztlajyoviltiaya. ");
INSERT INTO nsu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús ok otlapojtoka, iva ijkuakó oejkokeh sekimeh tlakah tlen ovalajkeh de ikalijtik in Jairo, tlen tlayakanki de kan tiotlamachtijkali, iva okilvijkeh: —Motakotzi yoixpolivik, ayakmo xiktekimaka in Tlamachti. ");
INSERT INTO nsu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús okikakki tlen yejvah okijtovayah, iva okilvi in Jairo: —Amo ximomavti, moneki san xitlaneltoka. ");
INSERT INTO nsu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iva amo okinekki oksekimeh ma viah Iva, sino san yen Pedro, Jacobo iva Juan ikni in Jacobo. ");
INSERT INTO nsu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ijkuak oajsitoh kan ikalijtik in Jairo, okinmitak in gentejtih mopajsolovah, chikavak ochokayah iva otzajtziah. ");
INSERT INTO nsu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús okalakki iva okinmilvi: —¿Tleka inmopasolovah iva inchokah? In takotzi ayamo ixpolivi, ye kochi. ");
INSERT INTO nsu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","In gentejtih san okivetzkilijkeh. Pero Ye okinkixti nochtin de kan kalijtik. Ijkuakó okinnotzki in tetajmeh de yejón takotzi iva tlen eyi momachtijkeh, iva okalakeh kan okatka in takotzi. ");
INSERT INTO nsu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Okimakitzki yejón takotzi iva okilvi: —Talita, kumi —kijtosneki: Takotzi, te nimitzilvia ximeva. ");
INSERT INTO nsu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yejón takotzi san nima omejki iva ope nejnemi. Iva in gentejtih sa tlawel omotetzavijkeh. In takotzi okipiaya majtlaktli ivan ome xivitl. ");
INSERT INTO nsu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús kuali okinnavati amitla ma kijtokah de tlen opanolok. Iva okinmilvi ma kitlamakakah in takotzi. ");
INSERT INTO nsu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús okiski de ompa iva oyá kan ialtepe Nazaret. In momachtijkeh noijki oyajkeh Iva. ");
INSERT INTO nsu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ijkuak oajsik sábado, Jesús ope tlamachtia kan tiotlamachtijkali. Iva ijkuak in gentejtih okikakkeh, miekeh okimotetzavijkeh iva okijtojkeh: —¿Kan okimomachti nin tlakatl nochi tlamantli tlen kimati? ¿Kenik kipia sa tlawel miek tlamatilistli? ¿Kenik veli kinchiva tetzavimeh? ");
INSERT INTO nsu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Amo ye nin kuavtlaxinki, itelpoch in María, iva iknivah in Jacobo, José, Judas ivan Simón? ¿Iveltivah amo noijki chantih itech nin altepetl? Yejvah amo okinpakti iva amo okineltokilijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iva Jesús okinmilvi: —Se tiotenejmachti kitlakitah sentetl, pero amo kitlakitah kan ialtepe, nion kan ifamiliajvah iva nion kan ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Por eso Jesús amo ovelik okichi nion se tetzavitl ompa. San inpan sekimeh kokoxkeh okintlali imavah iva opajtikeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús omotetzavi porke yejvah amo okineltokakeh. Satepa Jesús onemia sentetl itech altepemeh tlen kateh ik ompa serka iva otlamachtiaya. ");
INSERT INTO nsu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús okinnotzki in majtlaktli ivan ome momachtijkeh iva ope kintitlani ojomeh, iva okinmakak velitilistli para ma kinkixtikah amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iva okinmilvi amitla ma kivikakah para itech ojtli, nion se ayatl, nion intlaxkal iva nion tomi, sino san se karroti. ");
INSERT INTO nsu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ovelia kivikaskeh inkakvah, iva intzotzol san yen tlen konakijtivih. ");
INSERT INTO nsu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Okinmilvi: —Ijkuak inkalakiskeh kana tekalijtik, ompa ximokavakah asta ijkuak inkisaskeh de itech yejón altepetl. ");
INSERT INTO nsu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tla kana amo imechseliah o noso amo imechkakiliah, xikisakah de ompa iva ximokxitzejtzelokah, para ma kimatikah ke amo kuali tlen yejvah kichivah. Yi neli nimechilvia, ke itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, intlajyovilis yejonmeh gentejtih yetos okachi temavti ke intlajyovilis in gentejtih de Sodoma iva de Gomorra. ");
INSERT INTO nsu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","In momachtijkeh oyajkeh iva okinmilviayah in gentejtih ma moyolkuapakah. ");
INSERT INTO nsu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Okinkixtijkeh miekeh amo kuali ejekameh, iva miekeh kokoxkeh okintlalilijkeh aseite iva opajtikeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","In wei tlanavati Herodes okimatki de Jesús porke sentetl omotlapoviayah de Ye. Sekimeh okijtovayah: —Juan tlen tlabautisaro yomoyoliti iva por eso veli kinchiva tetzavimeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oksekimeh okijtovayah: —Yen tiotenejmachti Elías. Iva oksekimeh okijtovayah: —Ye se tiotenejmachti kemi tlen yi wejkavitl okatkah tiotenejmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ijkuak Herodes ijkó okikakki, okijto: —Nin yen Juan, tlen ne onitlanavati ma kikechtzontekikah iva axka yomoyoliti. ");
INSERT INTO nsu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Okachi achto, Herodes otlanavati ma kikitzkikah in Juan, ma kijilpikah ika kadena iva ma kitzakuakah telpiloya. Ijkó okichi por yen Herodías. Omonamikti ivan Herodías maski okatka itonana in ikni, tlen itoka Felipe. ");
INSERT INTO nsu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Iva Juan okilviaya in Herodes: —Dios itlanavatil amo kitekavilia ximonamikti ivan itonana in mokni. ");
INSERT INTO nsu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías okikualankaitaya in Juan iva okinekia kimiktis. Pero amo ovelia. ");
INSERT INTO nsu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes okimakasia in Juan porke okimatia nik in ye tlakamela iva yolchipavak, iva okipiaya kuidado de amitla kitoktiskeh in Juan. Iva ijkuak okikakia tlen Juan okilviaya, ayakmo okimatia tlan kijtos. Pero okivelitaya kikakis. ");
INSERT INTO nsu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero se tonali Herodías okajsik kenik kimiktis in Juan. Herodes okichi se ilvitl ijkuak okikumpliro xivitl. Okintlamakak in tlayakankeh tekivajkeh, in tlayakankeh de soldadojtih iva tlen okachi wejweititokeh de Galilea. ");
INSERT INTO nsu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ichpoch in Herodías ovala iva omijtoti inyakapa nochtin tlen ompa okatkah. Herodes iva tlen iva otlakuajtokah, sa tlawel okivelitakeh. Ijkuakó Herodes okilvi in ichpochtli: —Techtlajtlanili san tlan te tiknekis iva nimitzmakas. ");
INSERT INTO nsu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iva okimakak itlajtol okilvi: —San tlan techtlajtlanilis ne nimitzmakas, maski asta tlajko de tlen ne niknavatia. ");
INSERT INTO nsu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yejón ichpochtli oyá okitlajtlaniito imama: —¿Tlán niktlajtlanilis? Iva imama okilvi: —Xiktlajtlanili ma mitzmaka itzonteko in Juan tlen tlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","San nima omotlelo in ichpochtli kan okatka in wei tlanavati iva okilvi: —Nikneki axka san nima techmaka ika se plato itzonteko in Juan tlen tlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","In wei tlanavati sa tlawel omoyolkoko, pero komo okimakak itlajtol inmixpan tlen okinminvitaro, tonses amo omixevi okilvi amo. ");
INSERT INTO nsu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","San niman okititlanki se soldado, iva okinavati ma kikuiti itzonteko in Juan. ");
INSERT INTO nsu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","In soldado oyá telpiloya iva okikechtzonteki in Juan. Satepa okivikak itzonteko in Juan ika se plato iva okimaktili in ichpochtli, ivan ichpochtli okimaktili imama. ");
INSERT INTO nsu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ijkuak in momachtijkeh de Juan okimatkeh, okikuitoh in kuerpo iva okitookakeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","In tiotlatitlaniltih omololojkeh ivan Jesús iva okilvijkeh nochi tlen okichijkeh iva nochi tlen otlamachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús okinmilvi: —Xivikikah nova ik se lado kan tlalkavali iva ximosevikah se tzikitzi. Ijkó okinmilvi porke oyayah iva ovalayah sa tlawel miekeh gentejtih, asta amo okipiayah tiempo para tlakuaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tonses oyajkeh inselti itech se barko ik se lugar kan tlalkavali. ");
INSERT INTO nsu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero miekeh tlen okinmitakeh oyajkeh kuali okinyekixmatkeh. Ijkuakó in gente de miekeh altepemeh omotlelojkeh asta ompa iva achto oajsitoh ke yejvah. ");
INSERT INTO nsu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ijkuak Jesús otemok de itech barko, okittak sa tlawel miek gente, iva okinmiknomatki porke okatkah kemi ichkameh tlen amo kipiah tlajpixki. Iva ope kinmachtia de miek tlamantli. ");
INSERT INTO nsu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ijkuak yotiotlakik in momachtijkeh omotokijkeh inavak Jesús iva okilvijkeh: —Yotiotlakik, iva ik nika amika chanti. ");
INSERT INTO nsu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xikintitlani in gentejtih ma viah ik rancherías iva ik altepemeh tlen kateh serka, ma kimokovitih tlán kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús okinmilvi: —Imejvah xikintlamakakah. Yejvah okilvijkeh: —¿Tikneki ma tikovatih pan para tikintlamakaskeh nochtin ninmeh gentejtih? In tomi moneki kemi tlen se kitlani de ome siento tonali. ");
INSERT INTO nsu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ye okinmilvi: —¿Keski pan inkipiah? Xiviah xikittatih. Ijkuak okittakeh, okilvijkeh: —Tikpiah makuili pan iva ome michimeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ijkuakó Jesús otlanavati ke nochtin gentejtih ma motlalikah por grupos ipan sakayo xoxovik. ");
INSERT INTO nsu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Omotlalijkeh grupos de sejsen siento iva de tlatlajko siento. ");
INSERT INTO nsu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús okontilanki in makuili pan ivan ome michimeh, oajkotlachixki iva okitlasojkamatki inavak Dios. Okipojpostekki in pan iva okinmakak in momachtijkeh para ma kinxejxelilikah in gentejtih. Noijki okinxejxelili nochtin in ome michimeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nochtin kuali otlakuajkeh asta kan oixvikeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Satepa, in momachtijkeh okololojkeh in pedasos de pan iva de michi tlen osobraro iva okintemitijkeh majtlaktli ivan ome chikimeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iva tlen otlakuajkeh okatkah kemi makuili mil tlakah. ");
INSERT INTO nsu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Satepa, Jesús okinnavati in momachtijkeh ma tlejkokah itech se barko iva ma panokah ik nepa lado de kan atl tlen wei, ma sa tlayakanakah ma viah kan altepetl de Betsaida, mientras Ye ok okinmakavaya in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ijkuak okinmakah, Jesús oyá ipan tepetl omodiostzajtzilito. ");
INSERT INTO nsu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ijkuak otlayovak, in barko okatka tlatlajko de kan atl tlen wei, iva Jesús ok okatka iselti ipan tlali. ");
INSERT INTO nsu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ye okinmitak in momachtijkeh amo oveliah okivikayah in barko porke in ejekatl okinmixnamiktiaya. Kemi las tres de kualka, Jesús okinmajsito nejnentiv ixko atl iva yokinpanaviskia. ");
INSERT INTO nsu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ijkuak in momachtijkeh okittakeh nejnentivitz ixko atl, sa tlawel omomavtijkeh iva otzajtzikeh chikavak porke okijtojkeh xamo se mika ejekatl. ");
INSERT INTO nsu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nochtin okittakeh iva omomavtijkeh. Pero Jesús san nima okinmilvi: —Ximoyolchikavakah. Ne niJesús. Amo ximomavtikah. ");
INSERT INTO nsu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ijkuakó otlejkok itech barko, iva omoketzki in ejekatl. Yejvah sa sa tlawel omotetzavijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Porke ayamo okajsikamatiah in tetzavitl tlen Jesús okichi ika in pan, porke ok otzaktoka intlayejyekol. ");
INSERT INTO nsu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Opanokeh itech atl tlen wei iva oajsitoh kan tlali de Genesaret. Ompa itempan atl okilpijkeh in barko. ");
INSERT INTO nsu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ijkuak otetemokeh de itech barko, in gentejtih san nima okiyekixmatkeh in Jesús, ");
INSERT INTO nsu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","iva in gentejtih oyajkeh omotlelojkeh ik sentetl de kan yejón región iva okinvalikiliayah in kokoxkeh ipan inkochpetl kan okikakiah kajki in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iva san kan oyaya in Jesús, ik rancherías, ik altepemeh o ik tlala, okintlaliliayah in kokoxkeh itech ojtli. Iva okitlatlavtiayah ma kinkavili ma kikitzkilikah sikiera yen itenpantzi de itlaken tlen kimokentia. Iva nochtin tlen okikitzkiliayah opajtiah. ");
INSERT INTO nsu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sekimeh fariseos ivan sekimeh tlamachtijkeh de itlanavatil Moisés ovalajkeh desde Jerusalén iva omololojkeh inavak Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yejvah okinmitakeh ke sekimeh momachtijkeh de Jesús otlakuayah masokiojkeh, kijtosneki amo omomajtekiayah ijkó kemi inkostumbre in judiojtih. ");
INSERT INTO nsu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(In fariseos iva nochtin judiojtih kiseguirovah in kostumbre tlen okinmititijkeh inkojkolvah. Tla amo kualtzi momajtekiah, amo tlakuah. ");
INSERT INTO nsu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iva ijkuak mokuapativih in tiankisko, tla amo kualtzi momajtekiah amo tlakuah. Iva kinpiah oksekimeh kostumbres: kinpajpakah basojtih, jarrojtih, xoktzimeh de tepostli iva kochtlapechtih.) ");
INSERT INTO nsu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","In fariseos ivan tlamachtijkeh de itlanavatil Moisés okitlajtlanijkeh in Jesús: —¿Tleka tlen tikinmachtia amo kintlakitah in kostumbres tlen otechititijkeh tokojkolvah, iva tlakuah masokiojkeh? ");
INSERT INTO nsu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ye okinnankili: —¡Imejvah inkipiah ome inmoixko! Yompa tlen okijto in tiotenejmachti Isaías de imejvah, ijkuak okijkuilo: Ninmeh gentejtih san por intlajtol kijtovah nechtlakitah, pero inyolo kajki wejka de Ne. ");
INSERT INTO nsu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","San nenka nechweijkachivah, porke tlen tlamachtiah yejón san de tlaltikpaktlakah intlanavatil. ");
INSERT INTO nsu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Imejvah inkikavah se lado itlanavatil in Dios, iva yej okachi inkitlakamatih inkostumbre in tlaltikpaktlakah: inkinpajpakah jarrojtih iva vasojtih. Iva inkichivah okseki tlamantli kemi nin. ");
INSERT INTO nsu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Noijki okinmilvi: —Imejvah sa tekitl inmañosojtih. Inkitlaliah se lado itlanavatil in Dios para inkichivaskeh tlen de imejvah imokostumbre. ");
INSERT INTO nsu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés okijto: “Xiktlakita mopapa iva momama.” Noijki okijto: “Tlen tlajtos fiero de ipapa o de imama, ma kixpolokah.” ");
INSERT INTO nsu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero imejvah inkijtovah ke se tlakatl velis kilvis ipapa o noso imama: “Amo velis nimitzpalevis ika tlen mitzpolova porke nochi tlen nikpia yi Corbán.” (Corbán kijtosneki, yonikmaktili in Dios.) ");
INSERT INTO nsu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Iva ijkó imejvah amo inkitekaviliah ma se kipalevi ipapa o noso imama. ");
INSERT INTO nsu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Por yen kostumbres tlen imejvah inkimopanoltilijtivih, amo ipan inkittah itlajtol in Dios. Iva inkichivah miek okseki tlamantli kemi nin. ");
INSERT INTO nsu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús okinnotzki nochtin gentejtih iva okinmilvi: —Techkakikah innochtin, iva kuali xikajsikamatikah. ");
INSERT INTO nsu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nion se tlakuali tlen kikua se tlakatl amo yen kisokiotia, sino kisokiotia yen tlen kisa de itech ye. ");
INSERT INTO nsu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ijkuak Jesús okinkajte in gentejtih iva okalakki kalijtik, in momachtijkeh okitlajtlanijkeh tlán kijtosneki in ejemplo tlen okinmilvi. ");
INSERT INTO nsu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ye okinmilvi: —¿Imejvah noijki amo inkajsikamatih? ¿Amo inkajsikamatih ke tlen kikua se tlakatl mach veli kisokiotia? ");
INSERT INTO nsu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porke amo kalaki itech iyolo, sino ijtik itlalix iva satepa kisa de itech ikuerpo. Jesús ijkó okinmilvi kijtosneki nik chipavak nochi tlen se kikuah. ");
INSERT INTO nsu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Noijki okijto: —Tlen kisa de ijtik se tlakatl, yen yejón kisokiotia. ");
INSERT INTO nsu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","De ijtik se tlakatl, kijtosneki de itech iyolo, kisa tlen amo kuali tlen kiyejyekova, avilnemi itech tlajtlakoli tlen yomonamikti iva noijki tlen ayamo monamiktia, temiktia, ");
INSERT INTO nsu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tlachteki, tlaíxneki, kitetoktia tlen amo kuali, tlakajkayava, kipia itlanekilis tlen tepinati, moxikova, nemi san ika iten, moweineki, iva amo kimati tlakaki. ");
INSERT INTO nsu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochi yejón tlen amo kuali kisa de itech iyolo in tlakatl iva yen yejón tlen kisokiotia. ");
INSERT INTO nsu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús okiski de ompa iva oyá ik región de Tiro iva de Sidón. Okalakki itech se kalijtik iva amo okinekia íkka ma kimati kanin kajki, pero amo ovelik omotlaati. ");
INSERT INTO nsu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Se sivatl nima okimatki kanin kajki in Jesús, oyá okittato iva omotlankuaketzki ikxitla. Itakko okipiaya se amo kuali ejekatl, ");
INSERT INTO nsu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","iva okitlatlavti ma kikixtili de itech. In sivatl amo judía, sino ye valajtok de Sirofenicia. ");
INSERT INTO nsu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iva Jesús okilvi: —Moneki achto ma tlakuakah in konemeh, amo kuali kajki tla nikinkixtilis intlakual in konemeh iva nikinmakas in itzkuintih. ");
INSERT INTO nsu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","In sivatl okinankili: —Kema, noTeko. Pero in itzkuintih kikuah intlakualpayex in konemeh tlen tepevi itlampa mesa ijkuak tlakuah. ");
INSERT INTO nsu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús okilvi: —Yi neli tlen tikijtova. Xivia ika kuali, in amo kuali ejekatl yokiski de itech motakko. ");
INSERT INTO nsu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ijkuak in sivatl oajsito ikalijtik, okajsito itakko vetok ipan ikochtlapech iva in amo kuali ejekatl yokiski. ");
INSERT INTO nsu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús okiski de kan región de Tiro. Opanok ik Sidón iva oajsito kan atl tlen wei de Galilea, opanok ik región de Decápolis. ");
INSERT INTO nsu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ompa okivikilijkeh se tlakatl tlen amo otlakakia iva amo oyektenkisaya otlapovaya. Okitlatlavtijkeh ma kitlali ima ipan yejón tlakatl para ma pajti. ");
INSERT INTO nsu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús okikixti de intzala in gentejtih iva okivikak ik se lado. Okinkalaki imajpilvah ijtik inakasvah in yejón tlakatl. Satepa ochijchak itech imajpilvah iva okikitzkili inenepil. ");
INSERT INTO nsu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Satepa Jesús oajkotlachixki ik ilvikak, oelsijsi iva okilvi: —¡Efata! —kijtosneki: ¡Ximotlapo! ");
INSERT INTO nsu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","San nima ijkuakó in tlakatl onakastlapovik iva onenepilmelavik iva ope yi kuali tlapova. ");
INSERT INTO nsu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús okinnavati in gentejtih amika ma kitlapovikah. Pero maski ijkó okinnavati, yejvah yej okachi otetlapoviayah. ");
INSERT INTO nsu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa tlawel omotetzavijkeh, iva okijtovayah: —Nochi kuali tlen kinchiva. Asta veli kichiva ma tlakakikah tlen amo tlakakih, iva ma tlajtokah tlen noontzitzintih. ");
INSERT INTO nsu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Itech nekateh tonaltih oksemi omololojkeh miekeh gentejtih iva amo okipiayah tlán kikuaskeh. Jesús okinnotzki in momachtijkeh iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nikinmiknomati ninmeh gentejtih. Yi kipia eyi tonali nova kateh iva amo kipiah tlán kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tla amo nikintlamakas iva nikintitlanis ma viah inkalijtik, velis ixtlioviliskeh ik nepa itech ojtli, porke sekimeh de yejvah ovalajkeh de wejka. ");
INSERT INTO nsu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","In momachtijkeh okinankilijkeh: —Ik nika amika chanti. ¿Kan tikkuitivih pan para tikintlamakaskeh asta achinmeh gentejtih? ");
INSERT INTO nsu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús okintlajtlani: —¿Keski pan inkipiah? Yejvah otlanankilijkeh: —Chikome pan. ");
INSERT INTO nsu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús otlanavati ke nochtin gentejtih ma motlalikah ipan tlali. Okontilanki in chikome pan iva okitlasojkamatki inavak Dios. Okipojpostekki in pan iva okinmakak in momachtijkeh para ma kinxejxelilikah in gentejtih, iva yejvah ijkó okichijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noijki okinpiayah sekimeh michintzitzintih. Jesús okitlasojkamatki inavak Dios, iva otlanavati noijki ma kinxejxelilikah in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nochtin kuali otlakuajkeh asta kan oixvikeh. Iva satepa okololojkeh in pedasos tlen osobraro iva okintemitijkeh chikome chikimeh. ");
INSERT INTO nsu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tlen otlakuajkeh okatkah kemi navi mil. Satepa Jesús okinmakah. ");
INSERT INTO nsu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Otlejkok itech barko ivan momachtijkeh, iva oyá ik región de Dalmanuta. ");
INSERT INTO nsu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ovalajkeh inavak Jesús sekimeh fariseos iva ope motlatlajtolnamikih Iva. Iva para kiyejyekoskeh okilvijkeh ma kichiva se tetzavkaneskayotl para kittaskeh kox yi neli Dios okivaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús chikavak oelsijsi, iva okijto: —¿Tleka in gentejtih de nin tiempo kinekih ma nikinmititi se tetzavkaneskayotl? Yi neli nimechilvia, ke amo kittaskeh nion se tetzavkaneskayotl. ");
INSERT INTO nsu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús ompa okinkajte, oksemi otlejkok itech se barko iva oyá ik nepa lado de kan atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","In momachtijkeh okilkajkeh de kivikaskeh tlen kikuaskeh, iva okivikayah san se pan itech barko. ");
INSERT INTO nsu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús okinnejmachti: —Xikpiakah kuidado de inxokotix in fariseos iva de ixokotix in Herodes. ");
INSERT INTO nsu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","In momachtijkeh ope kimolviah entre yejvah: —Ijkó techilvia porke amo otikvalikakeh pan. ");
INSERT INTO nsu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús okimomakak kuenta tlen yejvah okijtovayah, iva okinmilvi: —¿Tleka inkimolviah ke amo onkivalikakeh pan? ¿Ayamo inkimomakah kuenta iva nion ayamo inkajsikamatih? ¿Seppa tzaktok imotlayejyekol? ");
INSERT INTO nsu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Inkipiah inmixtololovah iva amo intlachiah. Inkipiah inmonakasvah iva amo intlakakih. ¿Ayakmitla inkilnamikih? ");
INSERT INTO nsu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ijkuak onikpojpostekki in makuili pan para otlakuajkeh makuili mil gentejtih, ¿keski chikivitl otenki de pedasos de pan tlen onkololojkeh? Yejvah okinankilijkeh: —Majtlaktli ivan ome chikivitl. ");
INSERT INTO nsu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Iva ijkuak onikpojpostekki in chikome pan para otlakuajkeh navi mil gentejtih, ¿keski chikivitl otenki de pedasos de pan tlen onkololojkeh? Yejvah okilvijkeh: —Chikome chikivitl. ");
INSERT INTO nsu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iva ijkuakó okinmilvi: —¿Ayamo inkajsikamatih? ");
INSERT INTO nsu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ijkuak oajsitoh itech altepetl de Betsaida, okivalikilijkeh se tlakatl tlen amo tlachia iva okitlatlavtijkeh in Jesús ma kitilko. ");
INSERT INTO nsu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús okimavilanki iva okixti de kan altepetl. Satepa okitlalili ichijcha itech ixtololovah, okintlali imavah ipa, iva okitlajtlani: —¿Kox yi veli itla tikitta? ");
INSERT INTO nsu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","In tlakatl ope tlachia iva okijto: —Nikinmita in gentejtih kemi kuanmeh iva nikinmita nejnemih. ");
INSERT INTO nsu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús oksemi okintlali imavah itech ixtololovah in tlakatl. In tlakatl opajtik, iva ope tlachia iva nochi yi kuali okittaya. ");
INSERT INTO nsu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús okititlanki ma via para ikalijtik, iva okilvi: —Amo xikalaki kan altepetl iva nion amika xiktlapovi ik ompa. ");
INSERT INTO nsu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús ivan momachtijkeh oyajkeh ik altepemeh de región de Cesarea de Filipo. Ijkuak onejnentiayah itech ojtli, Jesús okintlajtlani: —¿Tlán kijtovah in gentejtih? ¿Akin Ne? ");
INSERT INTO nsu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yejvah okinankilijkeh: —Sekimeh kijtovah tejwatzi tiJuan tlen tlabautisaro. Oksekimeh kijtovah tejwatzi tiElías, o noso se tlen nepa tiempo oyá tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iva Jesús okintlajtlani: —Iva imejvah, ¿tlán inkijtovah? ¿Akin Ne? Iva Pedro okinankili: —Tejwatzi tiCristo. ");
INSERT INTO nsu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero Jesús okinnavati amika ma kitlapovikah akin Ye. ");
INSERT INTO nsu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús ope kinmachtia, okinmilvi ke iKone in Tlakatl kipia de tlajyovis miek. Iva ke amo kiseliskeh tlen tlayakankeh tetajmeh, iva tlen tlayakankeh tiopixkeh ivan tlen tlamachtijkeh de itlanavatil Moisés. Kixpoloskeh, pero ipan eyi tonali moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús kuali okinyekilvi tlen kipanos. Iva Pedro okivikak in Jesús ik se lado iva ope kajva por ijkó okijto. ");
INSERT INTO nsu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús omokuapki, okonimitak in momachtijkeh iva okajvak in Pedro iva okilvi: —¡Ximachiva de Ne, Amo Kuali Tlakatl!, porke te amo mitztekipachova tlen Dios kineki, sino mitztekipachova tlen kinekih in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús okinnotzki in gentejtih ivan momachtijkeh iva okinmilvi: —Tla íkka kineki vitz nonavak, moneki ayakmo ma kichiva san tlen ye kinekis. Kipia de kixikos nochi in tlajyovilistli maski ma kimiktikah itech krus, iva ma nechseguiro. ");
INSERT INTO nsu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tla íkka kineki kimakixtis inemilis, kipolos, pero tla íkka kipolos inemilis por Ne iva por yen yankuik kuali tlajtoli, kimakixtis inemilis. ");
INSERT INTO nsu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amitla ipati tla se tlakatl yetos iaxka nochi in tlaltikpaktli iva satepa kipolos ianima. ");
INSERT INTO nsu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Porke amitla onka itech nin tlaltikpaktli tlen ika velis kitlaxtlavas in tlakatl para kimakixtis ianima. ");
INSERT INTO nsu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tla íkka pinavas de Ne iva de notlajtol inmixpa ninmeh gentejtih tlajtlakolejkeh tlen ayakmo kipiah tlaneltokalistli inavak Dios, iKone in Tlakatl noijki pinavas de ye ijkuak vitz ika imavissotlanex niTajtzi ivan iilvikaktlatitlanilvah. ");
INSERT INTO nsu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús okinmilvi: —Yi neli nimechilvia, ke sekimeh tlen nika kateh, amo mikiskeh asta kan amo ma kittakah yope tlanavatia in Dios ika ivelitilis. ");
INSERT INTO nsu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chikuasen tonali satepa, Jesús okinvikak in Pedro, Jacobo ivan Juan oyajkeh ipan se tepetl wejkapa para ompa yeskeh inselti. Ompa inmixpa, Jesús omopatlak. ");
INSERT INTO nsu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Itzotzol opetlanki sa tlawel istak ke itech nin tlaltikpaktli amika velis ijkó kistalis. ");
INSERT INTO nsu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iva okinmonextilijkeh in Elías ivan Moisés, omotlapovijtokah ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iva Pedro okilvi in Jesús: —Tlamachti, sa tlawel kuali nika ma tiekah. Ma tikinchijchivakah eyi sakakaltih, se para tejwatzi, se para Moisés iva se para Elías. ");
INSERT INTO nsu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro amo okimatia tlen okijtovaya, porke sa tlawel omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ijkuakó se mixtli okinmokenki iva omokakki se tlajtoli de ijtik mixtli, okijto: —Nin yen noKone tlen niktlasojtla. Xikakikah tlen Ye imechilvia. ");
INSERT INTO nsu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ijkuak otlatlachixtevakeh, ayakmika okittakeh, sino sa yen Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ijkuak ovaltemovayah de ipan tepetl, Jesús okinmilvi in momachtijkeh amika ma kitlapovikah de tlen okittakeh, asta ijkuak iKone in Tlakatl ma moyoliti. ");
INSERT INTO nsu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tonses, san yejvah okimatokah, pero omotlajtlaniayah tlan kijtosneki moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iva okitlajtlanijkeh in Jesús: —¿Tleka in tlamachtijkeh de itlanavatil Moisés kijtovah ke Elías yen achto kipia vitz antes de vitz in Cristo? ");
INSERT INTO nsu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús okinnankili: —Yi neli, Elías achto vitz iva ye kiyektlalis nochi. Pero, ¿tleka in Tiotlajkuiloli kijtova ke iKone in Tlakatl kipia de tlajyovis miek iva amo kitasnekiskeh? ");
INSERT INTO nsu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero Ne nimechilvia ke Elías yovitza, iva in gentejtih okitoktijkeh san tlen yejvah okinekeh, ijkó okipanok kemi kijtova in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ijkuak oajsitoh kan okatkah tlen oksekimeh momachtijkeh, okinmittakeh miekeh gentejtih kinyavalojtokeh, iva sekimeh tlamachtijkeh de itlanavatil Moisés invah omotlatlajtolnamikiah. ");
INSERT INTO nsu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ijkuak in gentejtih okittakeh in Jesús, nochtin okimotetzavijkeh iva omotlelojkeh okitlajpalotoh. ");
INSERT INTO nsu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús okintlajtlani: —¿Tlán ik inmotlatlajtolnamikih invah? ");
INSERT INTO nsu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Se tlakatl tlen ompa okatka okilvi: —Tlamachti, nika nimitzvalikilia notelpoch, kipia se amo kuali ejekatl iva okinoontili. ");
INSERT INTO nsu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ijkuak kikitzkia, kitlalviteki, tenposoni, motlanteki iva mosojsotza. Onikinmilvi tlen tikinmachtia ma kikixtilikah in amo kuali ejekatl, pero amo ovelikeh. ");
INSERT INTO nsu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús okinmilvi: —¡Imejvah seppa amo intlaneltokah! ¿Asta keman nietos inmovah? ¿Asta keman nimechxikojtos? Techvalikilikah in telpochtli. ");
INSERT INTO nsu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iva okivalikilijkeh in telpochtli. Iva ijkuak in amo kuali ejekatl okittak in Jesús, san nima chikavak okitzejtzelo in telpochtli iva okitlalviteki. In telpochtli omokuakuaptinenki iva okamaposonki. ");
INSERT INTO nsu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús okitlajtlani in teta: —¿Keman ope ijkó mochiva? In teta okinankili: —Desde ok tzikitzi. ");
INSERT INTO nsu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Miek welta kitoktia ma vetzi ijtik tlitl iva ijtik atl para ma miki. Tla tejwatzi velis itla tikchivas, techiknomati iva techpalevi. ");
INSERT INTO nsu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús okilvi: —¿Kenik “tla velis itla nikchivas”? Nochi tlamantli velis mochivas para tlen akin tlaneltoka. ");
INSERT INTO nsu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","San nima ijkuakó in teta okijto chikavak: —¡Nikneltoka! ¡Techpalevi ma nitlaneltoka okachi! ");
INSERT INTO nsu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ijkuak Jesús okittak ope mololovah miekeh gentejtih, okajvak in amo kuali ejekatl. iva okilvi: —¡Te, ejekatl tinoontli iva tinakastzajtzaktok! ¡Nimitznavatia xikisa de ijtik in telpochtli iva ayakmo kema xikalaki ijtik! ");
INSERT INTO nsu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","In amo kuali ejekatl chikavak otzajtzik, chikavak okitzejtzelo in telpochtli, iva okiski de ijtik. In telpochtli omoka kemi oyeskia yomikki. Iva miekeh okijtojkeh yomikki in telpochtli. ");
INSERT INTO nsu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús okimakitzki iva okipalevi ma moketza. Iva in telpochtli omoketzki. ");
INSERT INTO nsu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ijkuak Jesús okalakki kalijtik, in momachtijkeh ompa inselti okitlajtlanijkeh: —¿Tleka tejvah amo otivelikeh otikixtijkeh in amo kuali ejekatl? ");
INSERT INTO nsu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ye okinmilvi: —Nin tlamantli de amo kuali ejekameh velis se kinkixtis san ika diostzajtzilistli iva ika mosavalistli. ");
INSERT INTO nsu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Okiskeh de ompa iva oyajkeh ik región de Galilea. Jesús amo okinekia íkka ma kimati kanin kajki, ");
INSERT INTO nsu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porke okinmachtiaya in momachtijkeh. Okinmilviaya: —IKone in Tlakatl kitemaktiskeh inmak in tlaltikpaktlakah, iva kixpoloskeh. Pero ipan eyi tonali moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero yejvah amo okajsikamatkeh tlen okinmilvi, iva okimakasiah kitlajtlaniiskeh tlán kijtosneki. ");
INSERT INTO nsu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Oajsitoh itech altepetl de Capernaum. Ijkuak yokatkah kalijtik, Jesús okintlajtlani: —¿De tlán ik onmotlatlajtolnamiktivalayah itech ojtli? ");
INSERT INTO nsu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yejvah amo otlanankilijkeh, porke omotlatlajtolnamiktivalayah itech ojtli akin de yejvah okachi weititok. ");
INSERT INTO nsu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús omotlali iva okinnotzki in majtlaktli ivan ome momachtijkeh. Okinmilvi: —Tla íkka kineki yen weititos, moneki yen yetos asta tlakuitlapa, iva yetos kemi tlakevali de nochtin. ");
INSERT INTO nsu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesús okitlali se chokotzi tlatlajkotia de kan yejvah okatkah. Okimonapalolti iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Tlen kiselis ika notoka se chokotzi kemi nin, Ne nechselia, iva tlen nechselia, amo san Ne nechselia, sino noijki kiselia tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan okilvi in Jesús: —Tlamachti, otikittakeh se tlakatl kinkixtia amo kuali ejekameh ika motoka, iva otikilvijkeh amo ma ijkó kichiva, porke amo tovah povi. ");
INSERT INTO nsu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús okinmilvi: —Xikavakah, porke tlen kichiva tetzavitl ika notoka, amo velis tlajtos fiero de Ne. ");
INSERT INTO nsu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tlen amo kajki kontra tejvah, tovah kajki. ");
INSERT INTO nsu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iva tlen imechmakas se vaso atl ika notoka, porke imejvah inpovih de Cristo, yi neli nimechilvia nik mach kimopolilis itlaxtlavil. ");
INSERT INTO nsu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Tla íkka kichivas ma vetzi itech tlajtlakoli se de ninmeh tzitzintih tlen nechneltokah, okachi kuali ma kilpilikah itech ikech se metlatl iva ma konkajkavakah kan atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tla moma mitztoktia xivetzi itech tlajtlakoli, okachi kuali xiktzonteki. Okachi kuali xikalaki itech nemilistli timatepo ke ika ome momavah tias miktla, kan tlitl amo keman sevis, ");
INSERT INTO nsu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kan chakalimeh amo keman mikih iva in tlitl amo keman sevi. ");
INSERT INTO nsu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tla mokxi mitztoktia xivetzi itech tlajtlakoli, okachi kuali xiktzonteki. Okachi kuali xikalaki itech nemilistli sa se mokxi ke ma mitzonkajkavakah miktla ika nochi ome mokxivah, ");
INSERT INTO nsu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kan chakalimeh amo keman mikih iva in tlitl amo keman sevi. ");
INSERT INTO nsu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iva tla moixtololo mitztoktia xivetzi itech tlajtlakoli, okachi kuali xikmokixtili. Porke okachi kuali xikalaki kan Dios tlanavatia ika se moixtololo ke ma mitzonkajkavakah miktla ika nochi ome moixtololovah, ");
INSERT INTO nsu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kan chakalimeh amo keman mikih iva in tlitl amo keman sevi. ");
INSERT INTO nsu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porke nochtin kipia de mopuyeliskeh ika tlitl. Iva nochi yolkatlamiktili kipia de mopuyelis ika istatl. ");
INSERT INTO nsu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","In istatl sa tlawel kuali, pero tla in istatl ayakmo yetos poyek, ¿kenomi oksé welta poyeyas? Imejvah xiekah inkualmeh kemi in istatl: xikchivakah tlen kuali iva xiekah ika yolsevilistli invan nochtin. ");
INSERT INTO nsu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús okiski de Capernaum iva oyá ik región de Judea iva itech tlali tlen kajki ik nepa lado de kan weyatl Jordán. In gentejtih oksemi omololojkeh inavak, iva oksemi ope kinmachtia ijkó kemi Ye okimatia okichivaya. ");
INSERT INTO nsu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sekimeh fariseos omotokijkeh inavak Jesús para kiyejyekoskeh, iva okitlajtlanijkeh: —¿Kox kuali se tlakatl kikajkavas itonana? ");
INSERT INTO nsu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús okinnankili: —¿Tlán otlanavati Moisés? ");
INSERT INTO nsu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yejvah otlanankilijkeh: —Moisés okikavili in tlakatl ma kijkuilo se amatl kan ma kijtojto nik kikajkava itonana. ");
INSERT INTO nsu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús okinmilvi: —Moisés omechmakak yejón tlanavatili porke imejvah amo inkimatih intlakakih. ");
INSERT INTO nsu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ijkuak Dios okichi in tlaltikpaktli, “Dios okichi in tlakatl ivan sivatl”. ");
INSERT INTO nsu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Por eso in tlakatl kikava ipapa iva imama iva mosetilia ivan itonana, ");
INSERT INTO nsu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","iva de omeh mochiva sa se.” Iva ijkó ayakmo yeskeh omeh sino sa se. ");
INSERT INTO nsu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por eso, tla Dios yokinsetili se tlakatl ivan se sivatl, amika ma kinxelo. ");
INSERT INTO nsu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ijkuak yokatkah kalijtik, tlen momachtijkeh oksemi okitlajtlanijkeh de yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús okinmilvi: —Tlen kikajkava itonana iva monamiktia ivan oksé sivatl, kijtosneki kichiva imosa porke mokalakia ivan oksé sivatl. ");
INSERT INTO nsu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iva tla se sivatl kikajkava itotata iva monamiktia ivan oksé tlakatl, kijtosneki momekatia. ");
INSERT INTO nsu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesús okinvikilijkeh sekimeh konemeh para inpa ma kintlali imavah iva ma kintiochiva. In momachtijkeh ope kinmajvah tlen okinvikayah in konemeh. ");
INSERT INTO nsu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ijkuak Jesús ijkó okittak, okualanki iva okinmilvi in momachtijkeh: —Xikinkavakah in konemeh ma vikikah nonavak, amo xikintzatzakuilikah. Porke tlen kateh kemi ninmeh konemeh, yejvah povih kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yi neli nimechilvia, tlen amo kimokavilis in Dios ma tlanavati itech ijkó kemi se chokotzi kimokavilia, amo velis kalakis kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesús okinmonapalolti in konemeh, okintlali imavah inpa iva okintiochi. ");
INSERT INTO nsu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ijkuak Jesús yoonnevaya, ijkuakó se tlakatl omotlelo inavak, omotlankuaketzki iyakapa ivan okilvi: —Kuali tlamachti, ¿katlen tlamantli kuali tlen moneki nikchivas para nikpias nemilistli para semijkak? ");
INSERT INTO nsu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús okinankili: —¿Tleka techilvia nikuali? Amika onka oksé tlen kuali, sino san yen Dios. ");
INSERT INTO nsu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yi tikinmati in tlanavatiltih: “Amo xitemikti, amo xiavilnemi itech tlajtlakoli, amo xitlachteki, amo xikijto tlen amo neli, amo xitlachteki ika tlakajkayavalistli, iva xiktlakita mopapa iva momama.” ");
INSERT INTO nsu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","In tlakatl otlanankili: —Tlamachti, nochi yejón nikchijtivitz desde ok nichokko. ");
INSERT INTO nsu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús okittak ika tlasojtlalistli iva okilvi: —Oksé tlamantli mitzpolova tikchivas. Xivia iva xiknemaka nochi tlen tikpia, iva in tomi xikinmaka in prowestih. Ijkó velis tikpias rikojyotl itech ilvikak. Iva xokontilana in krus de tlajyovilistli iva xiviki iva techseguiro. ");
INSERT INTO nsu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","In tlakatl omotekipacho ijkuak ijkó okikakki, iva oyá omoyolkokojtia porke okatka sa tlawel tomine. ");
INSERT INTO nsu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús okinmitak tlen okiyavalojtokah iva okinmilvi in momachtijkeh: —In tominejkeh sa tlawel ovijtitok para kalakiskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","In momachtijkeh omotetzavijkeh ijkuak okikakkeh okijto yejón tlajtoli. Pero Jesús okinmilvi oksemi: —Nopilvah, sa tlawel ovijtitok para kalakiskeh kan Dios tlanavatia tlen kitlaliah inyolo itech tominkayotl. ");
INSERT INTO nsu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Okachi amo ovi panos se kameyo kan ixtololo se aguja, ke se tomine ma kalaki kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yejvah okachi omotetzavijkeh iva okimolviayah entre yejvah: —Tonses, ¿akin velis momakixtis? ");
INSERT INTO nsu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús okintlajtlatak iva okijto: —Tlen tlaltikpaktlakah amo veli kichivah, Dios veli kichiva. Porke amo onka nion itla tlamantli tlen Dios amo ma veli ma kichiva. ");
INSERT INTO nsu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ijkuakó Pedro ope kilvia: —Tejvah otikajkeh nochi tlen otikpiayah porke tiknekih timitzseguiroskeh. ");
INSERT INTO nsu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús okinnankili: —Yi neli nimechilvia, tlen okikajte ikal, iknivah, iveltivah, ipapa, imama, itonana, ipilvah o noso itlal, por Ne iva por tlen yankuik kuali tlajtoli, ");
INSERT INTO nsu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kiselis itech ninmeh tonaltih sien veses okachi de kalmeh, iknivah, iveltivah, imamanvah, ipilvah iva itlalvah maski kichochololtiskeh. Iva itech neká tiempo tlen yetos satepa kipias nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iva miekeh tlen axka kateh achto satepa yeskeh asta sa ik tlami, iva tlen axka kateh asta sa ik tlami satepa yejvah yeskeh achto. ");
INSERT INTO nsu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Oyayah itech ojtli para Jerusalén, iva Jesús otlayakanaya. Tlen momachtijkeh omotetzaviayah iva oksekimeh tlen oyayah tlakuitlapa omomavtiayah. Jesús oksemi okinnotzki sekka in majtlaktli ivan ome momachtijkeh, iva ope kinmilvia tlen kipanos. ");
INSERT INTO nsu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús okinmilvi: —Xikakikah, yi tiavih para Jerusalén kan iKone in Tlakatl kitemaktiskeh inmak in tlayakankeh tiopixkeh iva inmak in tlamachtijkeh de itlanavatil Moisés. Yejvah kitlajtlakoltiskeh para ma kixpolokah, iva kitemaktiskeh inmak tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kipijpinatiskeh, kiwitekiskeh, kixchijchaskeh iva kixpoloskeh, pero eyi tonali satepa moyolitis. ");
INSERT INTO nsu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo ivan Juan, ipilvah in Zebedeo, omotokijkeh inavak Jesús iva okilvijkeh: —Tlamachti, tiknekih techonchivili tlen timitztlajtlaniliskeh. ");
INSERT INTO nsu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús okintlajtlani: —¿Tlán inkinekih? ");
INSERT INTO nsu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yejvah okilvijkeh: —Techkavili ma timotlalikah ik monavaktzi, se ik moyekmapa iva se ik moopochmapa, kan titlanavatis ika mavissotlanextli. ");
INSERT INTO nsu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús okinnankili: —Imejvah amo inkimatih tlen inkitlajtlanih. ¿Kox velis inkoniskeh in kopa de tlajyovilistli tlen Ne nikonis? ¿Kox velis inmobautisaroskeh kemin Ne nimobautisaros ika nochi tlen tekoko? ");
INSERT INTO nsu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yejvah okijtojkeh: —Tiveliskeh. Jesús okinmilvi: —Yi neli, imejvah inkoniskeh in kopa de tlajyovilistli ijkó kemin Ne nikonis, iva inmobautisaroskeh ijkó kemin Ne nimobautisaros ika nochi tlen tekoko. ");
INSERT INTO nsu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tla inmotlaliskeh ik noyekmapa o noso ik noopochmapa, mach Ne nikijtos. Dios ompa kintlalis tlen Ye yokinpejpenki. ");
INSERT INTO nsu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ijkuak in oksekimeh majtlaktih okikakkeh tlen okitlajtlankeh in Jacobo ivan Juan, okualankeh innavak. ");
INSERT INTO nsu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús okinnotzki iva okinmilvi: —Imejvah inkimatih ke in kobiernojtih de nin tlaltikpaktli, kivelitah kiteititiskeh nik yejvah tlanavatiah. Iva intlakavah tlen okachi tlayakantokeh noijki kivelitah tlanavatiskeh. ");
INSERT INTO nsu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero entre imejvah amo ijkó kipia de yetos. Tla se de imejvah kineki weititos, kipia de imechpalevis. ");
INSERT INTO nsu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iva tla entre imejvah íkka kineki yen tlayakantos, moneki yetos kemi tlakevali de innochtin imejvah. ");
INSERT INTO nsu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porke iKone in Tlakatl amo ovala para ma kipalevikah, sino ovala para tlapalevis iva para kitemakas inemilis tlen ika kitlaxtlavas innemakixtilis de miekeh. ");
INSERT INTO nsu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oajsitoh Jericó. Iva satepa ijkuak Jesús ivan momachtijkeh yokistiayah de Jericó, miekeh gentejtih okintokayah. Iva itempan ojtli oyetoka se tlakatl tlen amo otlachiaya itoka Bartimeo, ipiltzi in Timeo, okitlajtlantoka limosna. ");
INSERT INTO nsu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ijkuak okikakki ke Jesús de Nazaret mero ik ompa opanovaya, ijkuakó ope kitzajtzilia chikavak: —¡Jesús, iKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Miekeh okitlakavaltiayah pero ye okachi chikavak okitzajtziliaya: —¡IKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús omoketzki iva okijto: —¡Xiknotzatih! Yejvah okinotzatoh iva okilvijkeh: —Ximoyolchikava, ximoketza, Jesús mitznotza. ");
INSERT INTO nsu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ijkuakó ye okitlamotlak tlen okimokentijtoka, omoketevak iva oyá inavak Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús okitlajtlani: —¿Tlán tikneki ma nikchiva por te? Tlen amo tlachia okinankili: —Tlamachti, nikneki nitlachias. ");
INSERT INTO nsu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús okilvi: —Xivia. Motlaneltokalis yomitzpajti. San nima ijkuakó ovelik otlachixki, iva okitokak in Jesús itech ojtli. ");
INSERT INTO nsu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ijkuak yoajsitiayah Jerusalén, oajsitoh kan altepetl Betfagé iva Betania, kan tepetl tlen itoka Olivos. Jesús okintitlanki ome momachtijkeh, ");
INSERT INTO nsu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","iva okinmilvi: —Xiviah kan neká altepetl tlen kajki tlayakapa, iva san nima ijkuak inmajsitivih ompa, inkajsiskeh se burro ilpitok tlen ayamo keman íkka ipan motlalia. Xiktotomakah iva techvalikilikah. ");
INSERT INTO nsu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tla íkka imechilvis: “¿Tleka inkitotomah?”, xikilvikah: “In toTeko kineki iva san nima mitzkaviliki.” ");
INSERT INTO nsu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tlen ome momachtijkeh oyajkeh kan altepetl, iva ompa okajsitoh in burro ilpitok kaltempa itempan ojtli, iva okitotonkeh. ");
INSERT INTO nsu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iva sekimeh tlen ompa okatkah okinmilvijkeh: —¿Tleka inkitotomah in burro? ");
INSERT INTO nsu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","In momachtijkeh okijtojkeh ijkó kemi Jesús okinmilvi, iva okinkavilijkeh ma kivikakah in burro. ");
INSERT INTO nsu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tonses okivikakeh in burro kan okatka in Jesús. Iva intlakenvah tlen okinmokentiayah okinkentijkeh in burro, iva Ye ipan omotlali. ");
INSERT INTO nsu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Miekeh okinsojtiayah ipan ojtli intlakenvah tlen okinmokentiayah. Oksekimeh okintekiah imamayovah in kuanmeh iva okisojtiayah ipan ojtli. ");
INSERT INTO nsu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iva tlen otlayakanayah iva tlen oyayah tlakuitlapa otzajtziah chikavak, okijtovayah: —¡Viva! ¡Ma Dios kitiochiva tlen vitz ika itoka in toTeko! ");
INSERT INTO nsu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ma Dios kitiochiva tlen yi tlanavatis kemi otlanavati in tokojkol David! ¡Viva in Dios tlen kajki ilvikak! ");
INSERT INTO nsu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ijkuak Jesús okalakki Jerusalén, oyá kan templo iva otlatlachixki sentetl. Iva komo yotiotlakik, oyá para Betania invan majtlaktli ivan ome momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Omostlatik, ijkuak okiskeh de Betania, Jesús otiojsi, ");
INSERT INTO nsu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","iva okittak de wejka se igoskuavitl okipiaya ixivyo, iva oyá okittato para kittas xamo itla tlakilotl kipia. Ijkuak oajsito amitla okajsik, okipiaya san yen ixivyo porke ayamo tiempo de igos. ");
INSERT INTO nsu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ijkuakó Jesús okilvi in igoskuavitl: —Amo oksemi ok íkka ma kikua motlakilo. Iva in momachtijkeh okikakkeh. ");
INSERT INTO nsu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ijkuak oajsitoh Jerusalén, Jesús okalakki kan ikiavak in templo, iva ope kinkixtia in tlanemakakeh ivan tlakojkeh de ompa. Okintlatlamochili inmesajvah tlen okipatlayah tomi iva okintlatlamochili insiyajvah tlen okinnemakayah palomaxtih. ");
INSERT INTO nsu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iva ayakmika okikavili ma pano ika itla tlanemaktli kan ikiavak in templo. ");
INSERT INTO nsu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iva ope kinmachtia, okinmilvi: —Itech Tiotlajkuiloli kajki ijkuilitok: “Nokal kinotzaskeh kali kan modiostzajtziliah in gentejtih de nochtin países.” Pero imejvah yonkikuapkeh kemi se kali de ichtekeh. ");
INSERT INTO nsu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ijkuak okimatkeh in tlamachtijkeh de itlanavatil Moisés ivan tlayakankeh tiopixkeh, ope kitemovah kenik kimiktiskeh. Pero okimakasiah, porke nochtin gentejtih omotetzaviayah de kenik okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ijkuak otiotlakik Jesús ivan momachtijkeh okiskeh de Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ijkuak omostlatik kualkanpa opanokeh kan okatka in igoskuavitl iva okittakeh yovaki asta itech inelvayo. ");
INSERT INTO nsu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro okilnamiki iva okilvi in Jesús: —¡Tlamachti, xikitta! ¡Yovaki in igoskuavitl tlen otikajvak! ");
INSERT INTO nsu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús okinmilvi in momachtijkeh: —Ximotenmachikah inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yi neli nimechilvia, tla íkka kilvis nin tepetl: “Ximachiva de nika iva ximotlamotla kan atl tlen wei.” Iva tla amo moyoloomevis sino motenmachis nik mochivas tlen kijtova, tonses ijkó mochivas. ");
INSERT INTO nsu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por eso nimechilvia, ke nochi tlen inkitlajtlaniskeh ika diostzajtzilistli, xikneltokakah nik ya yinkipiah, iva inkiseliskeh. ");
INSERT INTO nsu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iva ijkuak inmodiostzajtziliskeh, xiktlapojpolvikah tla íkka itla omechtokti, iva ijkó imoTajtzi Dios tlen kajki ilvikak noijki imechtlapojpolvis de imotlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tla imejvah amo intetlapojpolviskeh, imoTajtzi Dios tlen kajki ilvikak noijki amo imechtlapojpolvis de inmotlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ovalajkeh oksemi para Jerusalén. Iva mientras Jesús onemia ompa kan templo, in tlayakankeh tiopixkeh, in tlamachtijkeh de itlanavatil Moisés ivan tlayakankeh tetajmeh, omotokijkeh inavak Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Okitlajtlanijkeh: —¿Ken timixevia tikchiva nin tlamantli? ¿Akin omitzmakak tlanavatijkayotl para ijkó xikchiva? ");
INSERT INTO nsu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús okinnankili: —Ne noijki nimechtlajtlanis se tlajtoli. Technankilikah, iva nimechilvis akin onechnavati ijkó ma nikchiva. ");
INSERT INTO nsu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Akin okinavati in Juan ma tlabautisaro? ¿Yen Dios okinavati o noso íkka tlakatl okinavati? Techilvikah. ");
INSERT INTO nsu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ijkuakó ope motlapoviah entre yejvah, iva okijtovayah: —Tla tikilviskeh ke Dios okinavati, techilvis: “¿Tonses tleka amo onkineltokakeh?” ");
INSERT INTO nsu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero, amo velis tikilviskeh ke íkka tlakatl okinavati. Yejvah okinmiimakasiah in gentejtih, porke nochtin okineltokayah ke Juan yi neli okatka tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yejvah okinankilijkeh in Jesús: —Amo tikmatih. Iva Jesús okinmilvi: —Ne noijki amo nimechilvis akin onechmakak tlanavatijkayotl para ma nikchiva nin tlamantli. ");
INSERT INTO nsu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús ope kintlapovia ika ejemplos, okinmilvi: —Se tlakatl okitookak uvas itlala. Okitlatzakui, iva okichi se tanke kan kipatzkas uvas iva okichi se torre para ompa tlejkos para kikuidaros itlala. Satepa okintlaneti sekimeh tekipanojkeh para ma kikuidarokah iva satepa kimakaskeh seki de tlen tlakis, iva ye oyá wejka. ");
INSERT INTO nsu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Ijkuak oajsik tonali para tlatekiskeh ika uvas, in tekova okititlanki se itlakeval kan yejonmeh tekipanojkeh, para ma kikuiti tlen kitokarova. ");
INSERT INTO nsu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero in tekipanojkeh okitzkijkeh iva okimagakeh ika maitl iva okikuapkeh san ijki. ");
INSERT INTO nsu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","In tekova okititlanki oksé itlakeval, iva in tekipanojkeh okikojkojkeh ipan itzonteko iva fiero okilvijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","In tekova okititlanki oksé itlakeval, iva in tekipanojkeh okimiktijkeh. Iva miekeh oksekimeh okintitlanki, sekimeh okinmagakeh ika maitl iva oksekimeh okinmiktijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’In tekova ayakmo okipiaya akin kititlanis, sino sa yen ipiltzi tlen okitlasojtlaya. Okititlanki iva okijto: “Nopiltzi yi neli kitlakitaskeh.” ");
INSERT INTO nsu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero in tekipanojkeh okimolvijkeh: “Nin ipiltzi yen kimokavis nin tlali kemi erensia. Ma tikmiktikah para tejvah tikmokaviskeh in tlali.” ");
INSERT INTO nsu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tonses in tekipanojkeh okitzkijkeh ipiltzi in tekova iva okimiktijkeh, okikixtijkeh de kan itlala iva okitlamotlatoh ik nepa. ");
INSERT INTO nsu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Tlán kichivas in tekova de yejón uvajyo? Yas iva kinmiktis nekateh tekipanojkeh, iva satepa oksekimeh kintlanetis iuvajyo. ");
INSERT INTO nsu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Amo inkilerovah tlen kijtova in Tiotlajkuiloli? In Tiotlajkuiloli kijtova: In tetl tlen kalchijkeh amo okivelitakeh, omokuapki yen tetl tlen okachi kichikajtok in kali. ");
INSERT INTO nsu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nin tlamantli yen toTeko ijkó okichi, iva tikittah sa panova kualtzi. ");
INSERT INTO nsu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ijkuakó okinekiah kikitzkiskeh in Jesús, porke okajsikamatkeh nik yejvah okinmilvijtoka ika yejón ejemplo. Pero okinmiimakasiah in gentejtih, okajkeh iva oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Satepa okintitlankeh inavak Jesús sekimeh fariseos iva sekimeh tlen opoviah ivan Herodes. Yejvah okinekiah ma vetzi in Jesús itech itla tlajtoli tlen amijtok. ");
INSERT INTO nsu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ijkuak ovalajkeh inavak Jesús, okilvijkeh: —Tlamachti, tikmatih ke tejwatzi tikijtova tlen yi neli, iva amo tikinmiimakasi in gentejtih de tlan kiyejyekovah de tejwatzi. Tejwatzi tikinmita in gentejtih nochtin iwalestih. Iva yi neli titlamachtia kenik se nemis kemi Dios kineki. ¿Kox kuali se kitlaxtlavas impuestos para in wei tekiva César, o noso amo? ¿Tiktlaxtlavaskeh o amo? ");
INSERT INTO nsu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Jesús yokimatia nik kipiah ome inmixko, iva okinmilvi: —¿Tleka inkinekih ma nikijto itla tlen amijtok? Techvalikilikah se tomi ma nikitta. ");
INSERT INTO nsu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yejvah okivikilijkeh se tomi, iva Jesús okintlajtlani: —¿De akin ixko iva akin itoka tlen nestok itech nin tomi? Yejvah okinankilijkeh: —De César. ");
INSERT INTO nsu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ijkuakó Jesús okinmilvi: —Xikmakakah in César tlen itech povi in César, iva xikmakakah in Dios tlen itech povi in Dios. Iva omotetzavijkeh de kenik otlanankili. ");
INSERT INTO nsu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satepa ovalajkeh inavak Jesús sekimeh saduceos, tlen kijtovah ke in mikameh amo velis moyolitiskeh. Iva okitlajtlanijkeh in Jesús: ");
INSERT INTO nsu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tlamachti, Moisés okijkuilo, tla se tlakatl omonamikti, ixpolivi iva amo okinpixki ipilvah ivan itonana, ikni in difunto kipia de monamiktis ivan iknosivatl para ivan kinpias ipilvah kemi oyeskia ipilvah in difunto. ");
INSERT INTO nsu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yi semi okatkah chikome iknimeh. Tlen tetiachka achto omonamikti pero oixpolivik iva amo okinpixki ipilvah. ");
INSERT INTO nsu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tlen kivaltoka omonamikti ivan iknosivatl, pero ye noijki oixpolivik iva amo okinpixki ipilvah. Noijki ijkó omochi oksé tlen kivaltokatok. ");
INSERT INTO nsu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iva nochtin chikome iknimeh omonamiktijkeh ivan yejón sivatl, pero oixpolikeh iva nion se amo okipixki ikone. Satepa noijki oixpolivik in sivatl. ");
INSERT INTO nsu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tonses, ijkuak moyolitiskeh in mikameh, ¿katli ye de nochtin yejonmeh chikome iknimeh yetos itonana? Porke nochtin chikomeh iknimeh omonamiktijkeh ivan yejón sivatl. ");
INSERT INTO nsu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús okinnankili: —Imejvah amo inkimatih tlen inkijtovah. Porke amo inkimatih tlen kijtova in Tiotlajkuiloli iva nion amo inkixmatih ivelitilis in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porke ijkuak in mikameh moyolitiskeh, in tlakah ivan sivameh mach ok monamiktiskeh, sino yeskeh kemi ilvikaktlatitlaniltih tlen kateh ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iva komo yi timotlapovijtokeh de moyolitiskeh in mikameh, ¿amo inkilerovah tlen okijkuilo in Moisés, kan tlapova de se kovatlanvitztli tlen otlatlaya? Dios okilvi in Moisés: “Ne niDios de Abraham, de Isaac iva de Jacob.” ");
INSERT INTO nsu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tonses, in Dios amo Dios de mikameh, sino de tlen yolitokeh. Imejvah seppa amo ompa tlen inkiyejyekovah. ");
INSERT INTO nsu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Se tlamachti de itlanavatil Moisés okinkakki motlatlajtolnamikih. Ijkuak okimomakak kuenta nik in Jesús kuali otlanankili, ijkuakó ye omotoki iva okitlajtlani: —¿Katli yen tlanavatili okachi weititok de nochtin? ");
INSERT INTO nsu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús okinankili: —In tlanavatili tlen okachi weititok yen nin: “Xikaki, Israel, in toTeko Dios san yen se toTeko. ");
INSERT INTO nsu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Xiktlasojtla moTeko Dios ika nochi moyolo, ika nochi moanima, ika nochi motlalnamikilis iva ika nochi mochikavalis.” Nin yen tlanavatili tlen okachi weititok. ");
INSERT INTO nsu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oksé tlanavatili tlen noijki weititok kijtova: “Xiktlasojtla in mokni kemi te timotlasojtla.” Amo onkateh oksekimeh tlanavatiltih tlen okachi wejweititokeh kemi ninmeh. ");
INSERT INTO nsu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","In tlamachti de itlanavatil Moisés okilvi: —Yompa, Tlamachti. Yi neli melajka tlen tikijtova nik onka san se Dios iva amo onka oksé. ");
INSERT INTO nsu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iva moneki tiktlasojtlaskeh in Dios ika nochi toyolo, ika nochi totlalnamikilis, ika nochi toanima iva ika nochi tochikavalis. Iva moneki tikintlasojtlaskeh toknivah kemi tejvah timotlasojtlah. Yejón okachi weititok ke nochtin yolkatlamiktiltih iva in tlamanaltih tlen kinchichinovah ipan artal. ");
INSERT INTO nsu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús okittak nik kuali otlanankili in tlamachti de itlanavatil Moisés, iva okilvi: —Ayakmo tika wejka para tikalakis kan Dios tlanavatia. Iva mach ok omixevijkeh ok itla okitlajtlanijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús otlamachtijtoka kan templo, iva otlajtlanki: —¿Tleka in tlamachtijkeh de itlanavatil Moisés kijtovah ke Cristo yen ikone in David? ");
INSERT INTO nsu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porke inevia in David por medio de yen Tioijyotzintli, okijto: Dios omotlapovi ivan noTeko, okilvi: “Ximotlali ik noyekmapa, asta kan ma nikintlali itlampa mokxivah tlen mitztlavelitah.” ");
INSERT INTO nsu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Inevia in David okinotzki in Cristo iTeko, ¿tonses kenik ma yeto ikone? In gentejtih, tlen okatkah sa tlawel miekeh, okikakiah in Jesús ika miek pakilistli. ");
INSERT INTO nsu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús okijtovaya itech itlamachtil: —Xikpiakah kuidado de tlen tlamachtijkeh de itlanavatil Moisés, kivelitah nemiskeh ika kuali intlakenvah weweyakeh, iva kinekih ma kinyektlajpalokah ijkuak nemih tiankistli. ");
INSERT INTO nsu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kivelitah motlaliskeh tlayakapa kan motlaliah tlen okachi tlayakantokeh kan tiotlamachtijkaltih, iva kan tlatlakuah kivelitah motlaliskeh kan okachi kuali lugar. ");
INSERT INTO nsu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kinkixtiliah inkalvah in iknosivameh, iva san ik mochivah wejkavitl modiostzajtziliah. Iva por eso Dios kintlajyoviltis okachi. ");
INSERT INTO nsu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús omotlali iyakapan kaja kan kitlaliah in tomi para in templo. Jesús okonimitoka in gentejtih kenik okontlaliayah intomi ijtik in kaja. Miekeh tlen tominejkeh okontlaliayah miek tomi. ");
INSERT INTO nsu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ijkuakó ovala se iknosivatl prowe, okonintlali ome tomintzitzintih de cobre tlen amo miek ipati. ");
INSERT INTO nsu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús okinnotzki in momachtijkeh iva okinmilvi: —Yi neli nimechilvia, ke nin iknosivatl prowe okontlali okachi ke nochtin tlen oksekimeh tlen okontlalijkeh intomi kan kaja. ");
INSERT INTO nsu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porke nochtin tlen oksekimeh okontlalijkeh intomi tlen kinsobrarova, pero nin iknosivatl prowe okontlali nochi tlen okipiaya, nochi tlen ika otlakuaskia. ");
INSERT INTO nsu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ijkuak Jesús okiski de kan templo, se momachti okilvi: —¡Tlamachti! Xikinmita in temeh ivan kalmeh, yi neli kuajkualtih. ");
INSERT INTO nsu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús okinankili: —¿Tikinmita ninmeh kuajkualtih kalmeh? Satepa nochi kixixititzaskeh iva ayakmo mokavas nepanitos nion oksé tetl. ");
INSERT INTO nsu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Satepa Jesús omotlali kan tepetl tlen itoka Olivos, tlen kajki iyakapan templo. Pedro, Jacobo, Juan ivan Andrés okitlajtlanijkeh san yejvah inselti: ");
INSERT INTO nsu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Techilvi, ¿keman ijkó panolos? ¿Tlán neskayotl tikittaskeh ijkuak pevas ijkó panolos? ");
INSERT INTO nsu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús ope kinmilvia: —Xikpiakah kuidado, amika ma imechkajkayava. ");
INSERT INTO nsu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Miekeh vitzeh san kinejnekiskeh notoka, kijtoskeh: “Ne niCristo.” Iva miekeh kinkajkayavaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ijkuak imejvah inkikakiskeh nik onka guerra o noso motlapoviskeh yetos guerra, amo ximomavtikah porke ijkó kipia tlen panos, pero ayamo tlamis in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porke se país kimomagas ivan oksé país, iva se altepetl kimomagas ivan oksé altepetl. Tlalolinis ik sentetl, yetos apistli iva mopajsoloskeh. Nochi yejón yikin pevas in tlajyovilistli. ");
INSERT INTO nsu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Xikpiakah kuidado porke imechtemaktiskeh kan teyekankavah iva imechwitekiskeh kan tiotlamachtijkaltih. Imechvikaskeh inmak kobernadortih iva inmak in wejwei tlanavatijkeh por innechneltokah, iva ompa inmixpa imejvah velis intetlapoviskeh de Ne. ");
INSERT INTO nsu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero achto kipia de motematiltis tlen yankuik kuali tlajtoli itech nochi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ijkuak imechkitzkiskeh iva imechtlatzintokiskeh, amo ximotekipachokah por tlán inkijtoskeh. San xikijtokah tlen Dios imechilvis xikijtokah ijkuakó, porke amo imejvah intlajtoskeh, sino yen Tioijyotzintli tlajtos por imejvah. ");
INSERT INTO nsu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","In teikni kitemaktis ikni ma kimiktikah. In teta kitemaktis ikone ma kimiktikah. In tepilvah yaskeh en kontra de tetajmeh iva kinmiktiskeh. ");
INSERT INTO nsu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nochtin imechkualankaitaskeh por innechneltokah, pero tlen akin kixikos nochi in tlajyovilistli, Dios kimakixtis. ");
INSERT INTO nsu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ijkuak inkittaskeh itla fierotik tlen teixpolo, kajki kan amo kipia de ompa yetos, —tlen kileros nin tlajtoli ma kajsikamati tlán kijtosneki—, ijkuakó tlen yeskeh Judea, ma cholokah ma via asta ipan tepemeh. ");
INSERT INTO nsu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iva tlen yetos ikpak ikal, amo ma temo para kikuiti itla ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iva tlen yetos itlala, amo ma mokuapa para ikalijtik para kikuiti itlaken. ");
INSERT INTO nsu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Prowestih in sivameh tlen itech nekateh tonaltih kipixtoskeh inkonetzi inmijtik iva in sivameh tlen tlaskaltijtoskeh! ");
INSERT INTO nsu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ximodiostzajtzilikah para amo ijkó ma panolo ijkuak seva. ");
INSERT INTO nsu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porke itech yejonmeh tonaltih yetos tlajyovilistli temavti, tlen amo keman ijkó panova desde ijkuak Dios okichi in tlaltikpaktli iva asta axka, iva satepa ayakmo keman ijkó panolos. ");
INSERT INTO nsu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dios kintlasojtla tlen Ye yokinpejpenki, iva por eso amo wejkavas miek tiempo yejón tlajyovilistli. Porke tlamo, amika omomakixtiskia. ");
INSERT INTO nsu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ijkuakó tla íkka imechilvis: “Xikittakah nika kajki in Cristo”, o noso “Xikittakah nepa kajki”, amo xikneltokilikah. ");
INSERT INTO nsu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Monextiskeh Cristojtih iva tiotenejmachtijkeh tekajkayajkeh, iva kinchivaskeh neskayomeh iva nexkuitiltih para ika tlakajkayavaskeh, iva kinekiskeh kinkajkayavaskeh noijki tlen Dios yokinpejpenki. ");
INSERT INTO nsu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Xikpiakah kuidado! Ne yonimechilvi antes de ijkó panolos. ");
INSERT INTO nsu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Satepa de neká tiempo, ijkuak yopanok in tlajyovilistli, in tonali tlilevis, in metzi ayakmo tlavis, ");
INSERT INTO nsu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","in sitlalimeh vetziskeh de ilvikak, iva in tlamantih tlen chijchikavakeh tlen kateh itech ilvikak viviokaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ijkuakó kittaskeh iKone in Tlakatl vitz itech mixtli ika miek ivelitilis iva ika wei imavissotlanex. ");
INSERT INTO nsu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iva ijkuakó kinvaltitlanis iilvikaktlatitlanilvah iva kinmololoskeh tlen Ye yokinpejpenki, ik novian desde kan ontlami in tlaltikpaktli iva asta kan ontlami in ilvikak. ");
INSERT INTO nsu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Xikajsikamatikah in ejemplo de igoskuavitl: Ijkuak peva selia imamayo iva peva moxivyotia, imejvah yinkimatih nik in tonaya yi kajki serka. ");
INSERT INTO nsu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ijkó noijki, ijkuak inkittaskeh yope ijkó tlamochivalo, xikmatikah nik mach ok wejkavas para vitz iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yi neli nimechilvia, ke nochi yejón panolos antes de ixpoliviskeh in gentejtih de nin tiempo. ");
INSERT INTO nsu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","In ilvikak ivan tlaltikpaktli poliviskeh, pero notlajtol yi neli mochivas iva amo polivis. ");
INSERT INTO nsu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Amika kimati tlán tonali iva tlán ora ijkuak ijkó panolos, nion ilvikaktlatitlaniltih de ilvikak amo kimatih, nion iKone in Dios noijki amo nikmati, sino san yen toTajtzin Dios kimati. ");
INSERT INTO nsu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Xikpiakah kuidado iva xiijsatokah iva ximodiostzajtzilijtokah. Porke amo inkimatih keman ijkó panolos. ");
INSERT INTO nsu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yejón kemi oyeskia se tlakatl tlen oyá de viaje. Okinkajtevili itlakevalvah ma kikuidarokah in kali, kada se okikajtevili itekiv, iva tlen tlakuidarova kan puerta okinavati ma ijsato ma tlachixto. ");
INSERT INTO nsu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tonses, xiijsatokah porke amo inkimatih keman vitz iteko in kali, kox tiotlaki, o noso tlajkoyovak, o noso ijkuak valtzajtzis in kaxtil, o noso ijkuak valanesis. ");
INSERT INTO nsu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Amo san kichiva onajsiki iva inmechajsiki inkochtokeh. ");
INSERT INTO nsu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tlen nimechilvia imejvah, noijki nikinmilvia nochtin: ¡Xiijsatokah! ");
INSERT INTO nsu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sa ome tonali opolivia para ilvitl de Pascua iva ilvitl de pan tlen amo kipia xokotixtli. In tlayakankeh tiopixkeh ivan tlamachtijkeh de itlanavatil Moisés okitemovayah kenik velis kikitzkiskeh in Jesús ika tlakajkayavalistli iva ijkó kixpoloskeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Okijtovayah: —Amo tikitzkiskeh itech ilvitl, para amo mopajsoloskeh in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús okatka Betania kan ikalijtik in Simón tlen achto opalania inakayo. Jesús oyetoka kan mesa, iva ijkuakó ovala se sivatl kivalika se boteyajtzi de alabastro tentok de ajviakayotl tlen kixkavia nardo tlen sa tlawel patío. Okitlapanki in boteyajtzi iva okiteekili in ajviakayotl ipan itzonteko in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sekimeh tlen ompa okatkah okualankeh iva okimolvijkeh entre yejvah: —¿Tleka san okavilti in ajviakayotl? ");
INSERT INTO nsu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Oveliskia omonemakaskia patío kemi tlen kitlani se tlakatl tlen tlapalevia de se xivitl, iva in tomi se okinmakaskia tlen prowestih. Iva okajvakeh chikavak in sivatl. ");
INSERT INTO nsu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús okinmilvi: —Xikavakah, amitla xikilvikah. Ye okichi se kuali tlamantli para Ne. ");
INSERT INTO nsu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","In prowestih nochipa inkinpiaskeh iva velis inkinpaleviskeh san keman inkinekiskeh, pero Ne mach ok wejkavas nika nietos imovah. ");
INSERT INTO nsu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nin sivatl okichi tlen ovelik: yonechteekili ajviakayotl itech nokuerpo, kijtosneki yokiyektlali para ijkuak nechtookaskeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yi neli nimechilvia, ke sentetl itech nin tlaltikpaktli kan motematiltis in yankuik kuali tlajtoli, noijki mijtos tlen okichi nin sivatl iva ijkó kilnamikiskeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, se de tlen majtlaktli ivan ome momachtijkeh, oyá okinmitato in tlayakankeh tiopixkeh para kinmaktilis in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ijkuak yejvah okikakkeh, opakeh iva okilvijkeh kimakaskeh tomi. Iva Judas ope kitemova keman velis kinmaktilis. ");
INSERT INTO nsu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","In primer tonali de ilvitl de pan tlen amo kipia xokotixtli, ijkuak noijki okimiktiayah in ichkakonetl de Pascua, in momachtijkeh okitlajtlanijkeh in Jesús: —¿Kan tikneki ma tikchivatih para tejwatzi in tlakuali de Pascua? ");
INSERT INTO nsu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Okintitlanki ome momachtijkeh, iva okinmilvi: —Xiviah kan siudad, ompa inkinamikiskeh se tlakatl tlen kivika se komitl de atl. Xiktokakah, ");
INSERT INTO nsu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","iva kan ye kalakiti, ompa xiktlajtlaniikah in chane: “In Tlamachti kijtova: ¿Katli yen kuarto kan nikmomajsevis in tlakuali de Pascua Ne ivan tlen nikinmachtia?” ");
INSERT INTO nsu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ye imechititis se wei kuarto tlen kajki tlakpak kan yi tlayektlalitok. Ompa xikchivakah in tlakuali de Pascua para tejvah. ");
INSERT INTO nsu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","In momachtijkeh okiskeh iva oyajkeh kan siudad. Okajsitoh nochi kemi Jesús okinmilvi iva okichijkeh in tlakuali de Pascua. ");
INSERT INTO nsu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ijkuak otlayovak, Jesús oajsito kan yejón kuarto invan majtlaktli ivan ome momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ijkuak otlakuajtokah kan mesa, Jesús okinmilvi: —Yi neli nimechilvia, ke se de imejvah tlen nika nova tlakuajtok, nechtemaktis. ");
INSERT INTO nsu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yejvah ope moyolkokovah, iva ope kitlajtlaniah se por se: —¿Kox ne? ");
INSERT INTO nsu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús okinmilvi: —Se de imejvah inmajtlaktih iva inmomeh, tlen kapachova ipan ijtik in plato kan Ne noijki nikapachova. ");
INSERT INTO nsu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Porke iKone in Tlakatl yas itech mikilistli, ijkó kemi kijtova in Tiotlajkuiloli nik ijkó kipanos. Pero ¡ay de neká tlakatl tlen kitemaktis! Okachi kuali amo onesiskia. ");
INSERT INTO nsu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ijkuak otlakuajtokah, Jesús okontilanki in pan iva okitlasojkamatki inavak Dios, okipojpostekki in pan, okinmajmakak iva okinmilvi: —Xikuakah, nin yen nokuerpo. ");
INSERT INTO nsu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Satepa okontilanki se kopa de vino, okitlasojkamatki inavak Dios, okinpanoltili, iva nochtin okonikeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iva okinmilvi: —Nin yen noesso, tlen Dios ika kichiva se yankuik moyekkavalistli inmovah, iva nokivis para miekeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yi neli nimechilvia, ke ayakmo nikonis vino, asta neká tonali ijkuak nikonis yankuik vino kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Satepa de okintlakuikakeh sekimeh himnos, oyajkeh kan tepetl tlen itoka Olivos. ");
INSERT INTO nsu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ijkuakó Jesús okinmilvi: —Nochtin imejvah innechkavaskeh noselti, porke itech Tiotlajkuiloli ijkuilitok: “Nikmiktis in tlajpixki iva in ichkameh xixiniskeh.” ");
INSERT INTO nsu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero satepa de ijkuak nimoyolitis, nitlayakanas nias para Galilea iva ompa innechajsitivih. ");
INSERT INTO nsu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ijkuakó Pedro okilvi: —Maski nochtin ma mitzkavakah, ne amo nimitzkavas. ");
INSERT INTO nsu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús okilvi: —Yi neli nimitzilvia, axka nin yovak antes de tzajtzis in kaxtil ome welta, te ijkuakó yotikijto eyi welta nik amo tinechixmati. ");
INSERT INTO nsu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro okachi omochijchika: —Maski mova ma nechmiktikah, ne amo keman nikijtos ke amo nimitzixmati. Iva nochtin no ijkó okijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Satepa oyajkeh se lugar tlen itoka Getsemaní, iva Jesús okinmilvi in momachtijkeh: —Nika ximotlalikah mientras Ne niav nimodiostzajtziliti. ");
INSERT INTO nsu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Okinvikak in Pedro, Jacobo ivan Juan, iva ope motekipachova iva moyolkokova sa tlawel. ");
INSERT INTO nsu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Okinmilvi: —Nikmachilia niixpolivisneki de neyolkokoli. Nika ximokavakah iva xiijsatokah. ");
INSERT INTO nsu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oyá achitzi ik tlayakapa, ompa omotlankuaketzki iva omixtlapacho ipan tlali iva omodiostzajtzili, tla oveliskia, amo ma kipano in tlajyovilistli tekoko itech yejón ora. ");
INSERT INTO nsu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Okijto: —Abba, noTajtzi, tejwatzi nochi veli tikchiva. Techkixtili nin tlajyovilistli tekoko, pero amo ma mochiva kemin Ne nikneki, sino kemi tejwatzi tikmonekiltis. ");
INSERT INTO nsu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Satepa omokuapki kan okatkah in momachtijkeh iva okinmajsito kochtokeh, iva okilvi in Pedro: —Simón, ¿tikochi? ¿Amo otikxiko tiijsatok nion se ora? ");
INSERT INTO nsu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xiijsatokah iva ximodiostzajtzilijtokah, para amo xivetzikah ijkuak imechyoltilanas in tlajtlakoli. Imotonal kineki kichivas tlen kuali, pero imokuerpo amo tlaxikova. ");
INSERT INTO nsu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús oyá oksemi omodiostzajtzilito iva oksemi okijto tlen achto yokijtojka. ");
INSERT INTO nsu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ijkuak omokuapato, oksemi okinmajsito kochtokeh, porke inmixtololovah omotzakuayah porke melajka okochisnekiah. Iva amo okimatiah tlán kinankiliskeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ijkuak omokuapato ipan yi eyi welta, okinmilvi: —¿Ok inmoseviah iva inkochih? ¡Xiijsakah! Yoajsik ora, iKone in Tlakatl kitemaktiskeh inmak tlen tlajtlakolejkeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Ximevakah, ma tiviah! Xikittakah, yompa vitz tlen nechtemaktis. ");
INSERT INTO nsu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ok otlapojtoka iva ijkuakó ovala in Judas, se de tlen majtlaktli ivan ome momachtijkeh. Judas okinvalikaya miekeh gentejtih okivalikayah inmespada iva kuavitl. Nonmeh gentejtih okintitlankeh in tlayakankeh tiopixkeh, in tlamachtijkeh de itlanavatil Moisés ivan tlayakankeh tetajmeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iva Judas tlen okitemakti, yokinmilvijka in gentejtih kenik kinmititis katli yen Jesús. Okinmilvi: —Tlen ne nikixpipitzos yen yejón Jesús, xikitzkikah iva xikvikakah kuali ma ijilpitiv. ");
INSERT INTO nsu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iva ijkuak ovala in Judas, omotoki inavak Jesús iva okilvi: —¡Tlamachti! Iva okixpipitzo. ");
INSERT INTO nsu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ijkuakó okitzkijkeh iva okivikakeh. ");
INSERT INTO nsu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero se de tlen ompa okatkah, okikixti iespada iva okinakastzonteki itlakeval in wei tiopixki. ");
INSERT INTO nsu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iva Jesús okinmilvi: —¿Onvalajkeh onnechkitzkikoh ika espada iva ika kuavitl kemi oyeskia niichteki? ");
INSERT INTO nsu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nochipa onikatka inmovah kan templo onitlamachtijtoka iva amo kema onnechkitzkijkeh. Pero nin ijkó panolo para ma mochiva tlen kijtova in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nochtin momachtijkeh ocholojkeh iva okikajtejkeh iselti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Se telpochtli okitokaya, otlakentiaya san ika se sábana. Okitzkijkeh, ");
INSERT INTO nsu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero ye omoxolkopinki okitlamotlatevak in sábana, iva ocholo sa xipetztik. ");
INSERT INTO nsu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Okivikakeh in Jesús kan wei tiopixki. Ompa omololojkeh in tlayakankeh tiopixkeh, in tlayakankeh tetajmeh ivan tlamachtijkeh de itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro okitokaya in Jesús san wejka, okalakki kan kiavak de kan ikalijtik in wei tiopixki iva ompa omotlali omoskojtoka kan tlikuili invan templojmayoltih. ");
INSERT INTO nsu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","In tlayakankeh tiopixkeh iva nochtin tlen povih itech injunta in judiojtih, okitemovayah itla tlen ika velis kitlajtlakoltiskeh in Jesús para ijkó velis kixpoloskeh, pero amitla okajxiliayah. ");
INSERT INTO nsu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Miekeh okiteilviayah ika miek istlakayotl, pero amo san se tlajtoli tlen okijtovayah. ");
INSERT INTO nsu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sekimeh omoketzkeh iva oistlakatikeh, okijtojkeh: ");
INSERT INTO nsu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Tejvah otikakkeh okijto: “Nikxitinis nin templo tlen tlachivali ika inmah in tlakah, iva san ika eyi tonali niketzaltis oksé, tlen amo tlachivali ika inmah in tlakah.” ");
INSERT INTO nsu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero maski ijkó okiteilviayah, amo san se tlajtoli tlen okijtovayah. ");
INSERT INTO nsu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ijkuakó omoketzki tlatlajko in wei tiopixki iva okitlajtlani in Jesús: —¿Amo titlanankilis? ¿Tlán kijtosneki nin tlen ik mitzteilviah? ");
INSERT INTO nsu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús san omoka iva amo otlanankili. In wei tiopixki oksemi okitlajtlani: —¿Yen te tiCristo, iKone in Dios tlen tikweijkachivah? ");
INSERT INTO nsu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús okilvi: —Kema, Ne. Iva imejvah inkittaskeh iKone in Tlakatl yetos ik iyekmapa in Dios tlen kipia nochi velitilistli, iva inkittaskeh vitz de ilvikak itech mixtli. ");
INSERT INTO nsu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","In wei tiopixki omotlakentzomoni porke okualanki, iva okijto: —Mach ok monekih testigojtih. ");
INSERT INTO nsu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Imejvah yonkikakeh kenik kixpanavia in Dios ika itlajtol. ¿Tlán inkijtovah? Nochtin okijtojkeh nik tlajtlakole iva moneki ma miki. ");
INSERT INTO nsu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sekimeh ope kichijchah, okixilpijkeh iva okimagayah ika maitl, iva okilviayah: —¡Xikyejyekoli akin omitzmagak! Iva in templojmayoltih noijki okixtlajtlatziniayah. ");
INSERT INTO nsu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro okatka tlatzintla kan kiavak, iva ik ompa ovala se sivatl itlakeval in wei tiopixki. ");
INSERT INTO nsu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ijkuak okittak in Pedro moskojtok, okitlajtlatak iva okilvi: —Te noijki otinemia ivan Jesús de Nazaret. ");
INSERT INTO nsu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro amo okimokuiti iva okijto: —Mach nikixmati iva nion amo nikmati tlán tikijtova. Iva okiski kaltempa de kan kiavak. Iva ijkuakó otzajtzik in kaxtil. ");
INSERT INTO nsu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","In sivatl tlen itlakeval in wei tiopixki, oksemi okittak in Pedro, iva ope kinmilvia tlen ompa okatkah: —Nin tlakatl se de yejvah. ");
INSERT INTO nsu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro oksemi amo okimokuiti. Ok achitzi satepa, tlen ompa okatkah oksemi okilvijkeh in Pedro: —Yi neli, te se de yejvah, porke te noijki de Galilea iva titlapova kemi yejvah. ");
INSERT INTO nsu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ijkuakó Pedro ope kijtova ipan ma vetzi tlajyovilistli tla amo neli tlen kijtova iva okisentlali itlajtol, okijto: —Ne mach nikixmati yejón tlakatl de tlen imejvah inkijtovah. ");
INSERT INTO nsu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","San niman ijkuakó in kaxtil ovaltzajtzik ya ipan ome welta. Iva ijkuakó Pedro okilnamiki tlen okilvijka in Jesús: “Antes de tzajtzis in kaxtil ome welta, te ijkuakó yotikijto eyi welta nik amo techixmati.” Iva ope choka. ");
INSERT INTO nsu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","San kualka ijkuak ovalaneski, omololojkeh in tlayakankeh tiopixkeh, in tlayakankeh tetajmeh, in tlamachtijkeh de itlanavatil Moisés iva nochtin tlen povih itech injunta in judiojtih, omololojkeh para motlapoviskeh tlán kichivaskeh ivan Jesús. Yejvah okijilpijkeh iva okivikakeh okimaktilitoh in Pilato. ");
INSERT INTO nsu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato okitlajtlani in Jesús: —¿Yen te tiwei tlanavati de judiojtih? Jesús okinankili: —Tejwatzi ijkó yotikijto. ");
INSERT INTO nsu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","In tlayakankeh tiopixkeh okiteilviayah de miek tlamantli. ");
INSERT INTO nsu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tonses, Pilato oksemi okitlajtlani: —Xikitta, mitzteilviah de miek tlamantli. ¿Amitla tikijtos de tlen yejvah kijtovah? ");
INSERT INTO nsu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús amo otlanankili. Iva Pilato omotetzavi. ");
INSERT INTO nsu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nochi xivitl itech ilvitl, Pilato okikajkavaya se de tlen tzaktokeh telpiloya, ijkó kemi tlen okijtovayah in gentejtih katli ye ma kikajkava. ");
INSERT INTO nsu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Okatka se tlakatl itoka Barrabás tlen otzaktoka telpiloya. Ye ivan oksekimeh otemiktijkeh itech se pleito tlen okipixkeh ivan kobierno. ");
INSERT INTO nsu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","In gentejtih oyajkeh okittatoh Pilato, iva okilvijkeh ma kikajkava se de tlen tzaktokeh telpiloya, ijkó kemi kichiva kada xivitl. ");
INSERT INTO nsu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato okinnankili: —¿Inkinekih ma nikajkava in wei tlanavati de judiojtih? ");
INSERT INTO nsu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato okimatia ke in tlayakankeh tiopixkeh itech omoxikovayah in Jesús iva por eso okitemaktijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero in tlayakankeh tiopixkeh okintlatlalvijkeh in gentejtih para ma kilvikah in Pilato ma kikajkava in Barrabás en lugar de Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato oksemi okintlajtlani: —Tonses, ¿tlán inkinekih ma nikchiva ivan nin tlakatl tlen imejvah inkinotzah wei tlanavati de judiojtih? ");
INSERT INTO nsu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yejvah ovaltzajtzikeh chikavak: —¡Xikrusifikaro! ");
INSERT INTO nsu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato okinmilvi: —¿Tleka? ¿Tlán okichi? Pero yejvah okachi chikavak otzajtziah: —¡Xikrusifikaro! ");
INSERT INTO nsu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato okinekki mokavas kuali invan gentejtih iva okikajka in Barrabás. Otlanavati ma kiwitekikah in Jesús iva satepa okitemakti para ma kikrusifikarokah. ");
INSERT INTO nsu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","In soldadojtih okivikakeh in Jesús kan kiavak de kan palacio, iva okinmololojkeh nochtin soldadojtih. ");
INSERT INTO nsu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Okentijkeh se kapa chichilkatlilmiktik, okichijchijkeh se korona de vitztli iva okitlalilijkeh itech itzonteko. ");
INSERT INTO nsu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iva ope kipijpinatiah iva okijtovayah chikavak: —¡Viva in wei tlanavati de judiojtih! ");
INSERT INTO nsu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iva okikuavijvitekiah ika se vara, okichijchayah iva omotlankuaketzayah iyakapa kemi oyeskia kiweijkachivah. ");
INSERT INTO nsu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ijkuak otlanki okipijpinatijkeh, okixtilijkeh ikapa chichilkatlilmiktik iva oksemi okonakiltijkeh itzotzol iva okixtijkeh para kikrusifikaroskeh. ");
INSERT INTO nsu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Se tlakatl de altepetl de Cirene, itoka Simón, tlen okatka ipapa in Alejandro ivan Rufo. Ye ovalaya de tlala iva ik ompa opanovaya, iva in soldadojtih okichikavilijkeh ma kikechpanili ikrus in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Okivikakeh in Jesús se lugar kan kitokayotiah Gólgota, kijtosneki Kan Mikatzontekomatl. ");
INSERT INTO nsu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Okitekiviltijkeh vino nelitok ivan mirra, pero amo okinekki okonik. ");
INSERT INTO nsu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ijkuak Jesús okikrusifikarojkeh, in soldadojtih omotlatlaankeh para kittaskeh tlán kimokaviskeh kada se de yejvah de itzotzol Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Okatka kemi las nueve de kualka ijkuak okikrusifikarojkeh. ");
INSERT INTO nsu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iva okitlalilijkeh se letrero kan kijtojtok tleka okikrusifikarojkeh. Kijtojtok: “WEI TLANAVATI DE JUDIOJTIH.” ");
INSERT INTO nsu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Noijki okinkrusifikarojkeh ome ichtekeh san sekka ivan Jesús, se ik iyekmapa iva se ik iopochmapa. ");
INSERT INTO nsu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Omochi ijkó kemi kijtova in Tiotlajkuiloli: “Okitlalijkeh san sekka invan tlen tlajtlakolejkeh.” ");
INSERT INTO nsu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tlen opanovayah ik ompa okoliniayah intzonteko iva otlajtovayah fiero de Jesús, okilviayah: —¡Nnn! Te otikijto tikxitinis in templo iva san ika eyi tonali tiketzaltis oksemi, ");
INSERT INTO nsu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","axka te monevia ximomakixti iva xitemo de itech krus. ");
INSERT INTO nsu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","In tlayakankeh tiopixkeh ivan tlamachtijkeh de itlanavatil Moisés, noijki okipijpinatiayah in Jesús, okimolviayah: —Okinmakixti oksekimeh pero ye inevia amo veli momakixtia. ");
INSERT INTO nsu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ma temo de itech krus in Cristo, in wei tlanavati de Israel, ma tikittakah iva tikneltokaskeh. Tlen okinkrusifikarojkeh ivan Jesús noijki otlajtovayah fiero de Ye. ");
INSERT INTO nsu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Desde tlajko tonali iva asta las tres de tiotlaki, otlayovak itech nochi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iva kemi las tres, Jesús otzajtzik chikavak, okijto: —Eloi, Eloi, ¿lama sabactani? —kijtosneki: NoTajtzin Dios, noTajtzin Dios, ¿tleka otechka noselti? ");
INSERT INTO nsu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sekimeh tlen ompa okatkah ijkuak ijkó okikakkeh, okijtojkeh: —¡Xikakikah! Kinotza in tiotenejmachti Elías. ");
INSERT INTO nsu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Se de yejvah omotlelo iva okapacho se esponja ijtik vinagre. Okilpi itech se akatl weyak iva okimakak ma koni, iva okijto: —Xikavakah, tikittaskeh kox vitz in tiotenejmachti Elías kitemoviki. ");
INSERT INTO nsu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús otzajtzik chikavak, omijyoka iva oixpolivik. ");
INSERT INTO nsu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ijkuakó in tzotzoltlatzakuili de kan templo otlajkotzayanki desde tlakpak asta tlakxitla. ");
INSERT INTO nsu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","In kapita tlen okatka iyakapan Jesús, ijkuak okikakki otzajtzik chikavak iva okittak kenik oixpolivik, okijto: —Nin tlakatl yi neli okatka iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ompa okatkah sekimeh sivameh okonittokah san wejka. Ompa okatka in María tlen de altepetl Magdala, Salomé, iva noijki in María tlen inmama in José ivan Jacobo tlen xokoyotl. ");
INSERT INTO nsu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yejonmeh sivameh okitokayah iva okipaleviayah in Jesús ijkuak okatka Galilea. Noijki ompa okatkah miekeh oksekimeh sivameh tlen ovalajkeh ivan Jesús para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ijkuakó yope tlajtlapuyava. Iva itech yejón tonali okatka ijkuak in judiojtih motlayektlaliliah para valmostlatis moseviskeh, kijtosneki antes de ajsis sábado. ");
INSERT INTO nsu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José de altepetl de Arimatea okipixki yolchikavalistli iva oyá inavak Pilato okitlajtlanilito ikuerpo in Jesús. José oweititoka itech injunta in judiojtih, iva noijki okichiaya keman pevas tlanavatis in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato omotetzavi ijkuak okikakki ke Jesús yoixpolivik. Ijkuakó san nima okinotzki in kapita de soldadojtih iva okitlajtlani kox yoixpolivik in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ijkuak in kapita okilvi nik yoixpolivik, Pilato okavili in José ma kivika in kuerpo. ");
INSERT INTO nsu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José okiko se sábana de lino, okitemovi in kuerpo de itech krus iva ika okikemilo. Satepa okikavato ijtik se mikatekochtli tlen okichkuakeh ikxitlan se tepejxitl. Satepa okitankachojtia se tetl iva ika okitentzaki. ");
INSERT INTO nsu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","In María tlen de altepetl Magdala iva María imama in José, okittakeh kanin okitlalijkeh ikuerpo in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ijkuak yotlanki in tonali sábado, in María tlen de altepetl Magdala, in Salomé ivan María imama in Jacobo, oyajkeh okikovatoh tlapajyotl ajviak para kixaviliskeh ikuerpo in Jesús. ");
INSERT INTO nsu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","In primer tonali de yejón samana, san kualka ijkuak okiski in tonali, oyajkeh kan mikatekochtli. ");
INSERT INTO nsu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Omotlajtlanijtiayah entre yejvah: —¿Akin techijkuanilis in tetl tlen ika tentzaktok in mikatekochtli? ");
INSERT INTO nsu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero ijkuak oajsitoh, okittakeh in wei tetl yokijkuanijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iva ijkuak okalakeh kan mikatekochtli, okittakeh ik inyekmapa yetok se telpochtli ika itlaken istak. Iva in sivameh omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero yejón telpochtli okinmilvi: —Amo ximomavtikah. Imejvah inkitemovah in Jesús de Nazaret, tlen okikrusifikarojkeh. ¡Ye yomoyoliti! Ayakmo nika kajki. Xikittakah kan okitlalijkah. ");
INSERT INTO nsu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Axka xiviah iva xikinmilvikah in momachtijkeh ivan Pedro, ke Jesús tlayakanas yas para Galilea, iva ompa kittaskeh ijkó kemi Ye yokinmilvijka. ");
INSERT INTO nsu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ijkuakó in sivameh okikistevakeh de kan mikatekochtli, porke omomavtijkeh iva asta oviviokatokah. Amika okitlapovijkeh porke omomavtiayah. ");
INSERT INTO nsu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Satepa de ijkuak Jesús omoyoliti kualkanpa in primer tonali de yejón samana, achto okimonextili in María tlen de altepetl Magdala tlen okinkixtili chikome amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ye oyá iva okinmatilti tlen onemiah ivan Jesús, tlen omoyolkokojtokah iva ochokatokah. ");
INSERT INTO nsu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero ijkuak ye okinmilvi ke Jesús yolitok iva ke ye yokittak, yejvah amo okineltokakeh. ");
INSERT INTO nsu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Satepa Jesús okinmonextili ome momachtijkeh tlen oyayah ik tlala. Pero Jesús ayakmo omottaya iwal kemin achto. ");
INSERT INTO nsu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yejvah noijki oyajkeh okinmilvitoh tlen oksekimeh, pero yejvah noijki amo okinneltokilijkeh. ");
INSERT INTO nsu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Satepa okinmonextili nochtin tlen majtlaktli ivan se momachtijkeh, ijkuak yejvah otlakuajtokah kan mesa. Jesús okinmajvak porke amo otlaneltokayah iva por yoltlakuavakeh, porke amo okinneltokilijkeh tlen yokittakeh nik yomoyoliti. ");
INSERT INTO nsu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iva okinmilvi: —Xiviah itech nochi in tlaltikpaktli iva xikintlapovikah nochtin gentejtih de tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tlen kineltokas iva mobautisaros, momakixtis. Iva tlen amo kineltokas, yetos tlajtlakole iva tlajyovis para semijkak. ");
INSERT INTO nsu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iva tlen kineltokaskeh velis kinchivaskeh neskayomeh kemi ninmeh: Ika notoka kinkixtiskeh amo kuali ejekameh, iva tlajtoskeh ika oksekimeh yankuikeh tlajtoltih. ");
INSERT INTO nsu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Velis kinkitzkiskeh kovameh ika inmah o noso koniskeh itla tlen venenojyo, iva amitla mochivaskeh. Kintlaliskeh inmavah inpan kokoxkeh, iva pajtiskeh. ");
INSERT INTO nsu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ijkuak Jesús otlanki okintlapovi, Dios okitlejkolti para ilvikak iva ompa Jesús omotlali ik iyekmapa in Dios. ");
INSERT INTO nsu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","In momachtijkeh okiskeh otetlapovitoh ik sentetl. Iva toTeko okinpaleviaya iva okiteititiaya ke tlen yejvah otetlapoviayah yi neli melajka, por yen tetzavkaneskayomeh tlen okinchivayah.");
INSERT INTO nsu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nokni Teófilo, miekeh yokiyejyekojkeh de yokijkuilojkeh nochi tlen opanolok itech tejvah. ");
INSERT INTO nsu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Okijkuilojkeh ijkó kemi otechmatiltijkeh nekateh tlen desde achto yejvah okittakeh tlen opanolok iva satepa okitematiltijkeh itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ne noijki kuali yonitlatlajtlanki ika yolik nochi nin tlen opanolok desde ijkuak opejki. Por eso, tejwatzi Teófilo, ne onikyejyeko moneki nimitzijkuililis ijkó kemi opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Para ijkó kuali xikyekmati in melajkayotl tlen yomitzmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ijkuak Herodes okatka wei tlanavati de Judea, itech yejonmeh tonaltih okatka se tiopixki itoka Zacarías, tlen opovia invan tiopixkeh de Abías. Itonana Zacarías omotokayotiaya Elisabet, iva ye noijki valajtok de Aarón. ");
INSERT INTO nsu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías ivan Elisabet okatkah tlakamelajkeh inavak Dios, iva okinvelkakiah in tlanavatiltih iva tlen toTeko okijto ma se kichiva, iva amika ovelia okintlajtlakoltiaya de itla. ");
INSERT INTO nsu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero amo okipiayah inkone, porke Elisabet amo ovelia okinpiaya, iva nochtin omeh yokokoxkatikeh. ");
INSERT INTO nsu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Se tonali, Zacarías otekipanojtoka de tiopixki kan templo porke in tiopixkeh tlen invah kichivah in tekitl okintokaro tekipanoskeh inavak Dios yejón samana. ");
INSERT INTO nsu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","In tiopixkeh okipiayah kostumbre omotlaniah para kittaskeh akin kitokaros tlapopochvis, iva ijkuakó yen Zacarías okitokaro kalakis tlapopochvis kan itemplo in toTeko. ");
INSERT INTO nsu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mientras Zacarías otlapopochvijtoka tlatlaijtik, nochtin gentejtih omodiostzajtzilijtokah kiavak. ");
INSERT INTO nsu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ijkuakó se iilvikaktlatitlanil in toTeko okimonextili in Zacarías. Yejón ilvikaktlatitlanili omoketoka ik iyekmapa in artal kan tlapopochviah. ");
INSERT INTO nsu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías sa ovaltlatlachixki iva omomavti ijkuak okittak in ilvikaktlatitlanili. ");
INSERT INTO nsu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero in ilvikaktlatitlanili okilvi: —Zacarías, amo ximomavti, porke Dios yokikakki modiostzajtzilis, iva motonana Elisabet kipias se ikone, tlen tiktokayotis Juan. ");
INSERT INTO nsu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sa tlawel tipakis, iva miekeh noijki pakiskeh ijkuak ye nesis. ");
INSERT INTO nsu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Porke yetos wei inavak Dios. Amo konis vino iva nion amo konis itla oksé tlen teiwinti, iva tentos de Tioijyotzintli desde antes de nesis. ");
INSERT INTO nsu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ye kichivas ke miekeh gentejtih de Israel ma mokuapakah inavak toTeko tlen inDios. ");
INSERT INTO nsu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ye achto vitz antes de vitz in toTeko, iva kipias itonal iva velitilistli ijkó kemi okipixki in tiotenejmachti Elías. Ye ijkuak tetlapovis kichivas ke in tetajmeh invan inpilvah ma moyekvikakah, iva tlen ixpetoktih ma kitlakitakah in Dios. Iva ijkó, ye kinyektlalis in gentejtih para velis kiseliskeh in toTeko. ");
INSERT INTO nsu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías okitlajtlani in ilvikaktlatitlanili: —¿Kenik nikmatis kox yi neli? Porke ne ivan notonana yotikokoxkatikeh. ");
INSERT INTO nsu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","In ilvikaktlatitlanili okinankili: —Ne niGabriel, niktekipanova in Dios. Ye onechvaltitlanki ma nimitzilviki nin kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero komo amo otikneltokak tlen onimitzilvi, axka tinoontis iva mach ok velis titlajtos asta ijkuak nesis mokone. Iva nochi nin tlen nimitzilvia, ijkó mochivas ijkuak ajsis tonali. ");
INSERT INTO nsu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","In gentejtih okichixtokah in Zacarías kan kiavak, iva omotlajtlaniayah tlanik ompa mowejkajtok iva amo valkisa de kan templo. ");
INSERT INTO nsu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iva ijkuak ovalkiski, ayakmo ovelik okintlapovi. Ijkuakó okimomakakeh kuenta ke Dios okititi se tetzavistlachialistli. Zacarías sa omamasovaya porke onoontik. ");
INSERT INTO nsu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ijkuak otlanki in tiempo de okichi itekiv in Zacarías itech in templo, oyá para ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kana keski tonali satepa, Elisabet yokipiaya ikonetzi ijtik, iva amo okiska de ikalijtik kemi makuili metztli. Elisabet okiyejyekovaya: ");
INSERT INTO nsu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“¡Sa tlawel kuali tlen Dios yokichi nova! Yonechpalevi para ayakmo ma nechpinavikah por amo veli nikinpia nokonevah.” ");
INSERT INTO nsu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ijkuak Elisabet yokipiaya chikuase metztli de yokipixtoka ikonetzi ijtik, Dios okivaltitlanki iilvikaktlatitlanil Gabriel itech se altepetl itoka Nazaret tlen kajki itech tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","In ilvikaktlatitlanili okimonextili se ichpochtli itoka María, tlen yokatka para monamiktis ivan se tlakatl itoka José, tlen valajtok de David tlen oyá wei tlanavati. ");
INSERT INTO nsu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","In ilvikaktlatitlanili okalakki kan okatka in María iva okilvi: —Xipaki tejwatzi María. Dios mitzita ika kuali. In toTeko mova kajki, iva yomitztiochi okachi ke nochtin sivameh. ");
INSERT INTO nsu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ijkuak María okikakki in ilvikaktlatitlanili, sa otlatlachixki iva ayakmo okima tlán kijtos, iva okimolvi tlán kijtosneki yejón tlajpalolistli. ");
INSERT INTO nsu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ijkuakó in ilvikaktlatitlanili okilvi: —María, amo ximavi, porke Dios kipia pakilistli mova. ");
INSERT INTO nsu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Axka yi tikpias se konetl moijtik, iva tiktlakatilis se chokotzi, iva tiktokayotis Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yejón chokotzi weititos, iva kinotzaskeh iKone in Dios tlen Weijkatlalitok, iva Dios kitlalis ma yeto wei tlanavati kemi tlen yi wejkavitl ikojkol tlen itoka David. ");
INSERT INTO nsu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ye nochipa yetos tekiva itech país de Israel, iva itekivajkayo amo keman tlamis. ");
INSERT INTO nsu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María okitlajtlani in ilvikaktlatitlanili: —¿Kenik nikpias nokone? Ne ayamo nikpia nototata. ");
INSERT INTO nsu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","In ilvikaktlatitlanili okinankili: —In Tioijyotzintli vitz motech, iva ivelitilis in Dios tlen Weijkatlalitok mitzmokemis kemi se mixtli. Por eso, in chokotzi tlen nesis motemaktis inavak Dios iva kinotzaskeh iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Moprima Elisabet noijki kipias se ikone maski yokokoxkatik. Miekeh okijtovayah amo veli kinpia ikonevah, pero axka yi kipia chikuase metztli de yi kipia ikonetzi ijtik. ");
INSERT INTO nsu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Para Dios amitla onka tlen amo ma veli ma kichiva. ");
INSERT INTO nsu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ijkuakó María okijto: —Ne niitekipano in toTeko. Ma mochiva nova ijkó kemi yotikijto. Ijkuakó in ilvikaktlatitlanili oyajki. ");
INSERT INTO nsu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Itech yejonmeh tonaltih, María oyá totoka itech se altepetl tlen okatka kan tepemeh de Judea. ");
INSERT INTO nsu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ijkuak ompa oajsito, okalakki kan ikalijtik in Zacarías iva okitlajpalo in Elisabet. ");
INSERT INTO nsu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iva ijkuak Elisabet okikakki okitlajpalo in María, in konetl omolini chikavak ijtik Elisabet. Iva Elisabet otenki de Tioijyotzintli, ");
INSERT INTO nsu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","iva okijto chikavak: —Dios yomitztiochi okachi ke oksekimeh sivameh, iva yokitiochi mokone tlen tikpixtok moijtik. ");
INSERT INTO nsu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Kemi akin ne, para ma viki ma nechtlajpaloki imama in noTeko? ");
INSERT INTO nsu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porke san nima ijkuak onikakki otechtlajpalo, nokone omolini chikavak noijtik ika pakilistli. ");
INSERT INTO nsu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xipaki porke otikneltokak, porke mochivas nochi tlen toTeko yomitzilvi. ");
INSERT INTO nsu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ijkuakó María okijto: Nikweijkachiva toTeko ika nochi noyolo, ");
INSERT INTO nsu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iva sa tlawel nipaki inavak toYejwatzi noTemakixti. ");
INSERT INTO nsu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porke maski niprowe niitekipanojtzi in toYejwatzi, Ye onechilnamiki. Iva desde axka nochtin tlaltikpaktlakah kijtoskeh nik in toYejwatzi onechtiochi sa tlawel. ");
INSERT INTO nsu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porke toYejwatzi tlen kipia nochi velitilistli, okinchi wejwei tlamantih por ne. Itokatzi yi neli chipaktzi. ");
INSERT INTO nsu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nochipa kinmiknomatis nochtin tlen kitlakitah. ");
INSERT INTO nsu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kinchiva wejwei tlamantih ika ivelitilis. Okinmijtlakoli tlen okiyejyekovayah kichivaskeh tlen moweinekih. ");
INSERT INTO nsu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tlen wejwei tlanavatijkeh okinkixtili intekivajkayo, iva okinweijkatlali tlen amo ipanitalistih. ");
INSERT INTO nsu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tlen otiojsiviah okinmakak nochi tlen kuali, iva tlen tominejkeh okintitlanki mapijpilkativih. ");
INSERT INTO nsu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Okipalevi in país de Israel tlen itlakeval. Amo okilka de kinmiknomatis ");
INSERT INTO nsu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ijkó kemi okinmilvijka tlen yi wejkavitl tokojkolvah, Abraham ivan nochtin ipilvah, ke kinmiknomatis para semijkak. ");
INSERT INTO nsu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María omoka ivan Elisabet kemi eyi metztli, iva satepa omokuapki para ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oajsik tonali, Elisabet okitlakatili se chokotzi. ");
INSERT INTO nsu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nochtin ivesinojvah ivan tlen itla kinmita opakeh miek, porke okittakeh ke Dios okichi tlen kuali por ye. ");
INSERT INTO nsu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ochikometik oyajkeh okisirkunsidarotoh in chokotzi, iva okinekiah kitokayotiskeh Zacarías kemi ipapa itoka. ");
INSERT INTO nsu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero Elisabet okijto: —Amo. Tiktokayotiskeh Juan. ");
INSERT INTO nsu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iva okilvijkeh: —¿Tleka? Nion se de tlen itla tikinmita amika ijkó itoka. ");
INSERT INTO nsu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ijkuakó sa ika inmah okitlajtlanijkeh in teta, para kimatiskeh kenik kineki kitokayotis ikone. ");
INSERT INTO nsu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","In teta okitlajtlanki se tlapetzintli para itech kijkuilos, iva ijkí okijkuilo: “Yetos itoka Juan.” Iva nochtin sa otlatlachixkeh. ");
INSERT INTO nsu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iva san nima ijkuakó Zacarías oksemi ovelik otlajto, iva ope kiweijkachiva in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nochtin ivesinojvah sa otlatlachixkeh. Iva itech nochi in tepeyo de Judea oxitinki in tlajtoli de tlan opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nochtin tlen okimatkeh, omotlajtlaniayah: —¿Tlán itekiv yetos yejón chokotzi ijkuak moskaltis? Nochtin okimatiah ke ivelitilis in toTeko okatka iva. ");
INSERT INTO nsu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, ipapa in Juan, otenki de Tioijyotzintli iva okijto seki tlajtoli tlen ovala de Dios. Ijkí okijto: ");
INSERT INTO nsu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ma tikweijkachivakah in toTeko, Dios de Israel, porke ovala otechmakixtiko tejvah tlen tiiaxkavah. ");
INSERT INTO nsu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Otechmakak se toTemakixti tlen chikavak, tlen valajtok de David tlen itlakeval. ");
INSERT INTO nsu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ijkó kemi yi wejkavitl Dios okijto intech in tiotenejmachtijkeh, ");
INSERT INTO nsu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","nik techmakixtis de inmak tlen techtlavelitah iva de nochtin tlen techkualankaitah. ");
INSERT INTO nsu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Okijto nik techiknomatis ijkó kemi okinmilvijka tlen yi wejkavitl tokojkolvah, iva amo kilkavas in chipavak moyekkavalistli tlen invah okichi. ");
INSERT INTO nsu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yen nin tlen Dios okitemakak itlajtol inavak tlen yi wejkavitl tokojkol Abraham: ");
INSERT INTO nsu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nik techmakixtis de inmak tlen techtlavelitah, para velis tiktekipanoskeh amo ika mavilistli. ");
INSERT INTO nsu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Okilvi ma tiekah tiyolchipavakeh iva titlakamelajkeh inavak itech nochi tonemilis. ");
INSERT INTO nsu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iva te, tinokone, mitznotzaskeh itiotenejmachti in toYejwatzi tlen Weijkatlalitok, porke te titlayakanas para tikyektlalilis iojviv in toTeko. ");
INSERT INTO nsu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Para tikinmatiltis ipilvah tlen de Israel kenik velis momakixtiskeh, para ijkó toYejwatzi kintlapojpolvis de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ToYejwatzi sa panova techiknomati, iva desde ilvikak otechvaltitlanili se Temakixti kemi oyeskia otechvaltitlanili se yankuik tonali. ");
INSERT INTO nsu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ye kintlavilis tlen kateh kan tlayova iva kan onka mikilistli. Yetos kemi se tlanextli tlen techyakanas itech ojtli kan se yetos ika kuali. ");
INSERT INTO nsu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","In chokotzi Juan omoskaltijtiaya iva Dios okimakaya chikavalistli itech ianima, iva ochantito kan tlavaki asta ijkuak oajsik tonali ijkuak okinmotiti in gentejtih de Israel. ");
INSERT INTO nsu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Itech nekateh tonaltih in wei tekiva Augusto César otlanavati ma moijkuilokah nochtin tlen chanti itech tlalmeh de Roma tlen ye kinavatia. ");
INSERT INTO nsu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nin yen tlen yikinika omijkuilojkeh ijkuak Cirenio okatka kobernador de Siria. ");
INSERT INTO nsu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nochtin oyayah para inmaltepe kan oneskeh para ompa moijkuiloskeh. ");
INSERT INTO nsu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Por eso, José okiski de ialtepe Nazaret, tlen kajki itech tlali de Galilea, iva oyá kan altepetl de Belén, tlen kajki itech tlali de Judea. Porke itech altepetl de Belén ompa oneski in wei tlanavati David, iva José oyá ompa porke valajtok de David. ");
INSERT INTO nsu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José oyá ompa Belén para moijkuilos ivan María, tlen yokatka para monamiktis ivan José, iva María yokipiaya ikonetzi ijtik. ");
INSERT INTO nsu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iva ijkuak okatkah ompa Belén, oajsik tonali para nesis ikonetzi in María. ");
INSERT INTO nsu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iva ikonetzi oneski chokotzi tlayankuiotzintli, okemilo ika seki konetzotzoltih iva okitekak ijtik se kajo kan tlakuah yolkameh, porke amo okajsikeh nion kana kan yovalpanoskeh kan tekalotiah. ");
INSERT INTO nsu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Amo wejka de Belén okatkah sekimeh tlajpixkeh okintlatokah inmichkavah de yovak. ");
INSERT INTO nsu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","San nima ijkuakó okinmonextili se iilvikaktlatitlanil in toTeko, iva imavissotlanex in toTeko okintlavili iva yejvah sa tlawel omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero in ilvikaktlatitlanili okinmilvi: —Amo ximomavtikah, porke onivala onimechmatiltiko se kuali tlajtoli iva pakiskeh nochtin gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Axka itech ialtepe in David yoneski tlen imechmakixtis, yen Cristo tlen toTeko. ");
INSERT INTO nsu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Para velis inkimatiskeh akin Ye, imejvah inkajsitivih yejón konetl kemilitok ika seki konetzotzoltih, iva vetok ijtik se kajo kan tlakuah yolkameh. ");
INSERT INTO nsu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","San nima ijkuakó ovalmonextijkeh miekeh oksekimeh ilvikaktlatitlaniltih de ilvikak ompa kan okatka tlen oksé ilvikaktlatitlanili, iva nochtin ope kiweijkachivah in Dios. Okijtovayah: ");
INSERT INTO nsu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ma tikweijkachivakah in toYejwatzi tlen kajki ilvikak, iva itech tlaltikpaktli ma yeto yolsevilistli para tlen mopaktiah itech iiknomachilis in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ijkuak in ilvikaktlatitlaniltih omokuapkeh para ilvikak, in tlajpixkeh ope kimolviah se ivan oksé: —Ma tiviah para Belén. Ma titlachiatih tlán tlapanolo, tlen toTeko yotechmatilti. ");
INSERT INTO nsu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Oyajkeh san nima, iva okajsitoh in María ivan José, ivan konetl vetok ijtik kajo kan tlakuah yolkameh. ");
INSERT INTO nsu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ijkuak okittakeh in konetl, yejvah okitematiltijkeh nochi tlen okinmilvi in ilvikaktlatitlanili aserka de yejón konetl. ");
INSERT INTO nsu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iva nochtin tlen okikakkeh tlen okijtojkeh in tlajpixkeh, sa otlatlachixkeh. ");
INSERT INTO nsu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María nochi yejón tlamantli okitlaati itech iyolo, iva nochipa okilnamikia nochi tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","In tlajpixkeh omokuapkeh kan okatkah inmichkavah. Oyajkeh kiweijkachijtivih in Dios iva okimakayah tlasojkamachilistli por nochi tlen okittakeh iva tlen okikakkeh, porke opanolok ijkó kemi okinmilvi in ilvikaktlatitlanili. ");
INSERT INTO nsu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ijkuak ochikometik de oneski in konetl, okisirkunsidarojkeh iva okitokayotijkeh Jesús, ijkó kemi in ilvikaktlatitlanili okilvi in María antes de okipiaskia in konetl ijtik. ");
INSERT INTO nsu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ijkuak opanokeh in tonaltih de omochipajkeh kemi kijtova itlanavatil Moisés, okivikakeh in konetl Jesús kan siudad de Jerusalén para kixpantiliskeh in toTeko. ");
INSERT INTO nsu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ijkó okichijkeh porke itlanavatil in toTeko kijtova: “Nochtin chokotzitzintih tlayankuiomeh kipia de kinmixpantiliskeh in toTeko para yeskeh kemi iaxkavah.” ");
INSERT INTO nsu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Itlanavatil in toTeko noijki kijtova ke moneki kitemakaskeh ome kokolotzitzintih o noso ome palomaxtih kemi se tlamanali para Dios. ");
INSERT INTO nsu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Itech yejón tiempo ochantia Jerusalén se tlakatl itoka Simeón. Okatka tlakamela iva omotemaktiaya inavak Dios, iva okichiaya ma ejko tlen kinmakixtis in gentejtih de Israel. In Tioijyotzintli okatka itech Simeón, ");
INSERT INTO nsu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","iva okilvi nik amo ixpolivis asta kan amo ma kitta in Cristo, tlen toTeko okijto kivaltitlanis. ");
INSERT INTO nsu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","In Tioijyotzintli okivikak in Simeón kan templo. Iva ijkuak in tetajmeh de yen konetl Jesús okivikakeh kan templo para kichivaskeh tlen kijtova itlanavatil Moisés, ");
INSERT INTO nsu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón okimonapalolti in konetl Jesús iva ope kiweijkachiva in Dios, okijto: ");
INSERT INTO nsu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","NoTeko, axka yi velis techkavilis ma nixpolivi ika kuali, porke yotikchi tlen otechilvi ne nimotlakeval. ");
INSERT INTO nsu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yonikittak ika noixtololovah tlen akin techmakixtis. ");
INSERT INTO nsu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iva yotikyektlali para nochtin tlaltikpaktlakah ma kittakah. ");
INSERT INTO nsu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yetos kemi se tlavili para kintlavilis nochtin tlen amo judiojtih, iva kiseliskeh tetlakitalistli mogentejvah de Israel. ");
INSERT INTO nsu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ipapa ivan imama in Jesús sa otlatlachixkeh por tlen okijto in Simeón de yejón konetl Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ijkuakó Simeón okintiochi, iva okilvi in María imama in Jesús: —Nin konetl, Dios okitlali para miekeh gentejtih de Israel ma vetzikah iva miekeh ma mevakah. Miekeh amo kineltokaskeh ke Dios okivaltitlanki, iva por eso amo kineltokaskeh tlen kinmilvis. ");
INSERT INTO nsu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Iva ijkó yi neli momatis tlen kiyejyekova kada se. Iva te, María, nochi nin tlamantli sa tlawel mitzyolkokos kemi oyeskia omitztzopitiskiah ika se espada itech moyolo. ");
INSERT INTO nsu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ompa okatka noijki se sivatl tiotenejmachti itoka Ana, ichpoch in Fanuel, tlen valajtok de Aser. Okatka yi tenantzi. Omonamikti ok ichpochtli, iva okatka ivan itotata san chikome xivitl. ");
INSERT INTO nsu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Omoka iknosivatl iva yokipiaya navi poali ivan navi xivitl. Nochipa okatka kan templo, ika tonali ika yovali okimavistiliaya in Dios ika mosavalistli iva ika diostzajtzilistli. ");
INSERT INTO nsu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana ovala mero ijkuakó, iva omotlasojkamatki inavak Dios iva ope kintlapovia de yejón konetl nochtin tlen okichiayah Dios ma kivaltitlani tlen akin kimakixtis Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ijkuak José ivan María otlankeh okichijkeh nochi tlen kijtova itlanavatil in toTeko, omokuapkeh para inmaltepe Nazaret tlen kajki itech tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","In chokotzi Jesús omoskaltiaya iva omochikavaya, iva okajsia miek tlamatilistli. Dios okipiaya pakilistli inavak iva okitiochivaya miek. ");
INSERT INTO nsu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús itajvah nochi xivitl oyayah Jerusalén itech ilvitl de pascua. ");
INSERT INTO nsu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ijkuak Jesús okipixki majtlaktli ivan ome xivitl, Ye ivan itajvah oyajkeh Jerusalén ijkó kemi okichivayah nochi xivitl. ");
INSERT INTO nsu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ijkuak otlanki ilvitl, omokuapkeh para inmaltepe Nazaret, pero in chokotzi Jesús omoka Jerusalén, iva itajvah amo okimomakakeh kuenta in Ye kox omoka. ");
INSERT INTO nsu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Itajvah okiyejyekojkeh ke Jesús ompa ovalaya invan oksekimeh gentejtih. Pero ijkuak yonejnenkeh se tonali, ope kitemovah kan ovalayah inyoliknivah iva tlen itla invan mottah, ");
INSERT INTO nsu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pero amo okajsikeh. Tonses, oksemi omokuapkeh para Jerusalén okitemotoh. ");
INSERT INTO nsu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eyi tonali satepa okajsitoh kan templo, ompa yetok invan tlamachtijkeh de itlanavatil Moisés, okinkaktoka iva okintlajtlaniaya miek tlamantli. ");
INSERT INTO nsu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iva nochtin tlen okikakiah sa otlatlachiayah porke okipiaya tlamatilistli iva kuali okinnankiliaya. ");
INSERT INTO nsu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ijkuak okittakeh itajvah, sa otlatlachixkeh. Iva imama okilvi: —Nokone, ¿tleka ijkó otechtokti? Mopapa ivan ne sa tlawel timotekipachovah timitztemovah. ");
INSERT INTO nsu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ijkuakó Jesús okinmilvi: —¿Tleka innechtemovah? ¿Amo inkimatih ke Ne moneki nietos kan ikalijtik noTajtzi? ");
INSERT INTO nsu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yejvah amo okajsikamatkeh tlen okinmilvi. ");
INSERT INTO nsu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ijkuakó Jesús omokuapki invah para Nazaret, iva okinvelkakia itajvah. María okitlaatiaya itech iyolo nochi yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús okachi omoskaltiaya iva okajsia okachi tlamatilistli. Jesús okipaktiaya in Dios itech nochi tlen okichivaya iva noijki okinpaktiaya in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ijkuak Tiberio César yokipiaya kaxtoli xivitl de wei tekiva de Roma, ijkuakó Poncio Pilato okatka kobernador itech tlali de Judea. Herodes okatka kobernador itech tlali de Galilea, iva ikni Felipe okatka kobernador itech tlali de Iturea iva itech tlali de Traconite. Lisanias okatka kobernador itech tlali de Abilinia. ");
INSERT INTO nsu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás ivan Caifás okatkah wejwei tiopixkeh. Itech yejón tiempo, ompa kan tlavaki Dios okitlapovi in Juan, ipiltzi in Zacarías. ");
INSERT INTO nsu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan oyá itech nochtin tlalmeh tlen kateh inakastla in weyatl Jordán. Okinmilviaya in gentejtih ma moyolkuapakah iva ma mobautisarokah, para ijkó Dios ma kintlapojpolvi de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ijkó kemi in tiotenejmachti Isaías okijkuilo: Se tlajtoli mokaki chikavak tetzajtzilia kan tlavaki: “Xikyektlalikah iva xikmelavakah iojviv in toTeko. ");
INSERT INTO nsu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kan tlawewejkatla moparejaros, nochtin tepemeh ivan lomajtih moixmanaskeh. Ojmeh tlen nejnekuilikeh momelavaskeh, in ojmeh tlen amo parejo kinmixmanaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iva nochtin tlaltikpaktlakah kittaskeh tlen toYejwatzi techvaltitlanilia para techmakixtis.” ");
INSERT INTO nsu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Miekeh gentejtih ovalayah inavak Juan para ma kinbautisaro, iva Juan okinmilviaya: —¡Imejvah intepilvah de kovameh! ¿Akin omechilvi ke tla inmobautisaroskeh ayakmo imechajsis ikualanilis in Dios tlen vitz inmopah? ");
INSERT INTO nsu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xikchivakah tlen kuali para ma motta nik yi neli yonmoyolkuapkeh. Iva amo xikyejyekokah ke imejvah kuali imonkateh san por intepilvah de Abraham. Porke yi neli nimechilvia ke asta ninmeh temeh Dios velis kinkuapas kemi ipilvah in Abraham. ");
INSERT INTO nsu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In acha yi kajki para kintzontekis asta itech innelvayo in kuanmeh. Iva nochtin kuanmeh tlen amo kuali intlakilo, kintzontekiskeh iva kintlamotlaskeh ijtik tlitl. ");
INSERT INTO nsu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ijkuakó in gentejtih okitlajtlanijkeh: —Tonses, ¿tlán moneki tikchivaskeh? ");
INSERT INTO nsu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan okinnankili: —Tlen kipia ome ikamisa, ma kimaka se tlen amo kipia. Iva tlen kipia tlen kikuas, ma kimaka se tlaxkali tlen amo kipia. ");
INSERT INTO nsu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noijki ovalajkeh sekimeh tlen kobradortih de impuestos para mobautisaroskeh, iva okitlajtlanijkeh in Juan: —Tlamachti, ¿iva tejvah tlán moneki tikchivaskeh? ");
INSERT INTO nsu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan okinmilvi: —Xitlakobrarokah san yen tlen moneki, amo xitlakobrarokah okachi. ");
INSERT INTO nsu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noijki sekimeh soldadojtih okitlajtlanijkeh: —Iva tejvah, ¿tlán moneki tikchivaskeh? Iva Juan okinmilvi: —Amo xikmajmavtikah íkka para ma imechmaka itla tomi. Amo xitlateilvikah ika tlakajkayavalistli. Iva xiyolopachivikah ika inmotlaxtlavil. ");
INSERT INTO nsu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nochtin gentejtih sa okichixtokah ma viki in Cristo, iva yejvah okiyejyekojkeh xamo yen Juan in Cristo. ");
INSERT INTO nsu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero Juan okinmilvi nochtin: —Ne nimechbautisarova ika atl. Pero vitz se tlakatl tlen imechbautisaros ika Tioijyotzintli iva ika tlitl. Ye okachi velitini iva amo kemin ne, iva nion amo notech povi para nikintojtomilis ikakvah. ");
INSERT INTO nsu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Vitz kemi oyeskia kichipavas in trigo. In trigo tlen chipavak kitlaatis ijtik isinkal, iva itlajsolo kitlamotlas ijtik tlitl tlen amo keman sevi. ");
INSERT INTO nsu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ika nin, iva ika miek okseki tlajtoli, Juan okintlapoviaya in gentejtih tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Noijki okajvak in kobernador Herodes, porke okichi itonana in Herodías, tlen itonana Felipe. Iva Herodes ivan Felipe okatkah iknimeh. Iva noijki okajvak por okichi miek okseki tlamantli tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iva de nochi yejón tlen okichi in Herodes, ok okichi oksé tlamantli tlen amo kuali, okichi ma kitzakuakah in Juan kan telpiloya. ");
INSERT INTO nsu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Se tonali Juan okinbautisarojtoka miekeh gentejtih, iva ijkuakó noijki okibautisaro in Jesús. Iva ijkuak Jesús omodiostzajtzilijtoka, in ilvikak otlapovik ");
INSERT INTO nsu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iva in Tioijyotzintli ovaltemok ipan Jesús kemi se palomax. Iva omokakki se tlajtoli itech ilvikak, okijto: —Te tinoKone tlen nimitztlasojtla, iva sa tlawel nikpia pakilistli monavak. ");
INSERT INTO nsu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús okipiaya kemi senpoali ivan majtlaktli xivitl ijkuak okipevalti itekiv. Nochtin okijtovayah ke Jesús oyá tekone de José. José oyá tekone de Elí, ");
INSERT INTO nsu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ivan Elí oyá tekone de Matat, Matat oyá tekone de Leví, Leví oyá tekone de Melqui, Melqui oyá tekone de Jana, Jana oyá tekone de José, ");
INSERT INTO nsu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José oyá tekone de Matatías, Matatías oyá tekone de Amós, Amós oyá tekone de Nahúm, Nahúm oyá tekone de Eslí, Eslí oyá tekone de Nagai, ");
INSERT INTO nsu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai oyá tekone de Maat, Maat oyá tekone de Matatías, Matatías oyá tekone de Simei, Simei oyá tekone de José, José oyá tekone de Judá, ");
INSERT INTO nsu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá oyá tekone de Joana, Joana oyá tekone de Resa, Resa oyá tekone de Zorobabel, Zorobabel oyá tekone de Salatiel, Salatiel oyá tekone de Neri, ");
INSERT INTO nsu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri oyá tekone Melqui, Melqui oyá tekone de Adi, Adi oyá tekone de Cosam, Cosam oyá tekone de Elmodam, Elmodam oyá tekone de Er, ");
INSERT INTO nsu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er oyá tekone de Josué, Josué oyá tekone de Eliezer, Eliezer oyá tekone de Jorim, Jorim oyá tekone de Matat, ");
INSERT INTO nsu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat oyá tekone de Leví, Leví oyá tekone de Simeón, Simeón oyá tekone de Judá, Judá oyá tekone de José, José oyá tekone de Jonán, Jonán oyá tekone de Eliaquim, ");
INSERT INTO nsu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim oyá tekone de Melea, Melea oyá tekone de Mainán, Mainán oyá tekone de Matata, Matata oyá tekone de Natán, ");
INSERT INTO nsu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán oyá tekone de David, David oyá tekone de Isaí, Isaí oyá tekone de Obed, Obed oyá tekone de Booz, Booz oyá tekone de Salmón, Salmón oyá tekone de Naasón, ");
INSERT INTO nsu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón oyá tekone de Aminadab, Aminadab oyá tekone de Aram, Aram oyá tekone de Esrom, Esrom oyá tekone de Fares, Fares oyá tekone de Judá, ");
INSERT INTO nsu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá oyá tekone de Jacob, Jacob oyá tekone de Isaac, Isaac oyá tekone de Abraham, Abraham oyá tekone de Taré, Taré oyá tekone de Nacor, ");
INSERT INTO nsu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor oyá tekone de Serug, Serug oyá tekone de Ragau, Ragau oyá tekone de Peleg, Peleg oyá tekone de Heber, Heber oyá tekone de Sala, ");
INSERT INTO nsu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala oyá tekone de Cainán, Cainán oyá tekone de Arfaxad, Arfaxad oyá tekone de Sem, Sem oyá tekone de Noé, Noé oyá tekone de Lamec, ");
INSERT INTO nsu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec oyá tekone de Matusalén, Matusalén oyá tekone de Enoc, Enoc oyá tekone de Jared, Jared oyá tekone de Mahalaleel, Mahalaleel oyá tekone de Cainán, ");
INSERT INTO nsu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán oyá tekone de Enos, Enos oyá tekone de Set, Set oyá tekone de Adán, Adán oyá tekone de Dios. ");
INSERT INTO nsu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús okiski de ijtik in weyatl Jordán tentok de Tioijyotzintli. Iva in Tioijyotzintli okivikak kan tlavaki. ");
INSERT INTO nsu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ompa omoka ompoali tonali, iva in Amo Kuali Tlakatl okiyejyeko in Jesús ika tlajtlakoli. Iva itech yejón ompoali tonali amitla okikua, iva satepa otiojsi. ");
INSERT INTO nsu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tonses, in Amo Kuali Tlakatl okilvi: —Tla yi neli tiiKone in Dios, xikilvi nin tetl ma mokuapa pan. ");
INSERT INTO nsu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús okinankili: —In Tiotlajkuiloli kijtova: “In tlakatl amo velis yolitos san ika tlakuali, sino noijki ika itlajtol in Dios tlen Ye techilvia.” ");
INSERT INTO nsu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satepa in Amo Kuali Tlakatl okivikak ipan se tepetl wejkapa, iva san de repente okinmititi nochtin países de nin tlaltikpaktli, ");
INSERT INTO nsu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","iva okilvi: —Nimitztlalis xikinnavati nochtin ninmeh países iva nimitzmakas nochi inrikojyo tlen kipiah. Porke ne nochi noaxka, iva velis nikmakas san akin ne niknekis. ");
INSERT INTO nsu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tla timotlankuaketzas iva techmavistilis, nochi yetos moaxka. ");
INSERT INTO nsu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesús okinankili: —Ximachiva, Amo Kuali Tlakatl, porke in Tiotlajkuiloli kijtova: “Xikmavistili in moTeko Dios, iva san Ye xiktekipano.” ");
INSERT INTO nsu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satepa in Amo Kuali Tlakatl okivikak kan siudad de Jerusalén iva okitlejkolti ikpak in templo, iva okilvi: —Tla yi neli tiiKone in Dios, xontzikuini desde nika. ");
INSERT INTO nsu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porke in Tiotlajkuiloli kijtova: Dios kintitlanis iilvikaktlatitlanilvah para ma mitzpalevikah. ");
INSERT INTO nsu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mitzajkuanaskeh ika inmah, para amo tikmomakati itla tetl itech mokxi. ");
INSERT INTO nsu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús okinankili: —In Tiotlajkuiloli noijki kijtova: “Amo xikyejyeko in moTeko Dios.” ");
INSERT INTO nsu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","In Amo Kuali Tlakatl ayakmo okimatia tlán kichivas para ma vetzi itech tlajtlakoli in Jesús, iva okika por kana keski tonali. ");
INSERT INTO nsu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús omokuapki itech tlali de Galilea tentok de ivelitilis in Tioijyotzintli. Iva nochtin de yejón región omotlapoviayah de Ye. ");
INSERT INTO nsu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Otlamachtiaya kan intiotlamachtijkalvah, iva nochtin kuali otlapovayah de Ye. ");
INSERT INTO nsu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús oyá ialtepe Nazaret kan Ye omoskalti. Se sábado okalakki kan tiotlamachtijkali, ijkó kemi Ye okipiaya kostumbre. Iva omoketzki para kileros in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Okimakakeh in libro tlen okijkuilo in tiotenejmachti Isaías. Iva ijkuak okitlapo, okajsik kan ijkuilitok ijkí: ");
INSERT INTO nsu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ITioijyotzi in toTeko kajki notech, Dios onechpejpenki para ma nikinmatilti in prowestih tlen yankuik kuali tlajtoli. Onechvaltitlanki ma nikinpajti tlen moyolkokovah, ma nikinmatilti tlen tzaktokeh ke kinkajkavaskeh, ma nikintlachialti tlen amo tlachiah, iva ma nikinmakixti tlen fiero kintoktiah. ");
INSERT INTO nsu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Iva para ma niktematilti ke yen nin tiempo tlen Dios okipejpenki para kitemakas nemakixtilistli. ");
INSERT INTO nsu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Satepa Jesús okitzakki in libro, okimakak tlen tlapalevia itech yejón tiotlamachtijkali iva omotlali. Iva nochtin tlen ompa okatkah, sa okitlajtlatayah. ");
INSERT INTO nsu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iva ijkuakó Jesús okinmilvi: —Axka yomochi tlen kijtova in Tiotlajkuiloli tlen yoniklero inmoyakapa. ");
INSERT INTO nsu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nochtin kuali otlapovayah de Jesús. Sa otlatlachiayah por okittakeh kualtzi nik otlapovaya. Iva omotlajtlaniayah: —¿Amo ye nin ipiltzi in José? ");
INSERT INTO nsu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús okinmilvi: —Mixevia imejvah inkinekih innechilviskeh nin tlajtoli: “Tepajti, te monevia ximopajti.” Iva noijki innechilviskeh: “Xikchiva nika itech moaltepe, ijkó kemi otikakkeh otikchi Capernaum.” ");
INSERT INTO nsu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Noijki okinmilvi: —Yi neli nimechilvia, ke nion se tiotenejmachti amo kiseliah ika kuali itech ialtepe kan oneski. ");
INSERT INTO nsu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yi neli, nepa tiempo ijkuak okatka in tiotenejmachti Elías, amo okiavik eyi xivitl ivan tlajko, iva in gentejtih omikiah ika apistli. Iva itech país de Israel okatkah miekeh iknosivameh. ");
INSERT INTO nsu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Dios amo okititlanki in Elías para ma kinpalevi yejonmeh iknosivameh de Israel, sino okititlanki inavak se iknosivatl de altepetl Sarepta, tlen kajki serka de Sidón. ");
INSERT INTO nsu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Noijki nepa tiempo, ijkuak Eliseo okatka tiotenejmachti, noijki itech país de Israel okatkah miekeh tlen opalania innakayo. Pero Eliseo amo okipajti nion se de yejvah, sino okipajti san yen Naamán, tlen de país de Siria. ");
INSERT INTO nsu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ijkuak ijkó okikakkeh, nochtin tlen okatkah kan tiotlamachtijkali sa tlawel okualankeh. ");
INSERT INTO nsu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nochtin ovalmoketikiskeh, okikixtijkeh in Jesús iva okivikakeh asta ipan tepetl kan okatka yejón altepetl, para ompa kitepejxiviskeh. ");
INSERT INTO nsu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús opanok intzala iva oyá. ");
INSERT INTO nsu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús oyá para Capernaum, se altepetl tlen kajki itech tlali de Galilea, iva ompa ope kinmachtia in gentejtih ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nochtin okimotetzaviayah de kenik okinmachtiaya, porke itlajtol okipiaya tlanavatijkayotl. ");
INSERT INTO nsu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Itech tiotlamachtijkali okatka se tlakatl tlen okipiaya se amo kuali ejekatl, iva otzajtzik chikavak: ");
INSERT INTO nsu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Techkava! ¿Tlán tikneki tovah, Jesús de Nazaret? ¿Otivala otechixpoloko? Ne nikmati akin Te, Te tiyolchipavak tiiKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús okajvak in amo kuali ejekatl, okilvi: —¡Xiktzakua mokamak, iva xikisa de itech yejón tlakatl! Ijkuakó in amo kuali ejekatl okitlamotlak in tlakatl ipan tlali ompa inyakapa, iva okiski de itech, iva amo okikojko nion kana. ");
INSERT INTO nsu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nochtin sa otlatlachixkeh, iva okimolviayah: —¿Kenik veli ijkó kijtova? Ika itlanavatijkayo iva ika ivelitilis kinnavatia in amo kuali ejekameh ma kisakah, iva yejvah kisah. ");
INSERT INTO nsu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iva itech nochi yejón región okimatkeh nochi tlen Jesús okichivaya. ");
INSERT INTO nsu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús okiski de kan tiotlamachtijkali iva oyá para ikalijtik in Simón. Imonna in Simón okipiaya miek totonik, iva okitlatlavtijkeh in Jesús ma kipajti. ");
INSERT INTO nsu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús omotoki kan okatka imonna in Simón iva okajvak in totonik, iva in totonik okiski. Imonna in Simón san nima omejki iva ope kintlamaka. ");
INSERT INTO nsu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ijkuak opolivito in tonali, nochtin tlen okinpiayah inkokoxkavah okinvikilijkeh in Jesús. In kokoxkeh okipiayah tlatlamantli kokolistli, pero Jesús okintlali imavah inpa iva nochtin opajtikeh. ");
INSERT INTO nsu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Miekeh de yejonmeh kokoxkeh okinpiayah amo kuali ejekameh. Iva ijkuak okisayah in amo kuali ejekameh, otzajtziah chikavak, okijtovayah: —¡Tejwatzi tiiKone in Dios! Pero Jesús okinmajvak iva amo okinkavili ma tlajtokah, porke yejvah okimatiah ke Jesús yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Omostlatik, Jesús okiski de Capernaum iva oyá sekka kan tlalkavali. Pero in gentejtih okitemojtinemiah, iva satepa okajsitoh kan okatka. Iva okitlatlavtijkeh amo ma via. ");
INSERT INTO nsu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús okinmilvi: —Noijki moneki niktematiltis itech oksekimeh altepemeh in kuali tlajtoli de kenik in Dios tlanavatia, por eso Dios onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesús otetlapovijtinenki itech tiotlamachtijkaltih tlen kateh itech tlali de Judea. ");
INSERT INTO nsu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Se tonali Jesús okatka itempan atl tlen wei de Genesaret, iva miekeh gentejtih omololojkeh asta sa itech omotojtopevayah porke okinekiah kikakiskeh itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús okinmitak ome barkojtih tlen okatkah serka de itempan atl. In michkitzkijkeh otemokeh okinpakatoh inredvah. ");
INSERT INTO nsu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús otlejkok itech se de yejonmeh barkojtih, tlen iaxka in Simón, iva okilvi ma kijkuani ok se tepitzi ijtik atl. Omotlali itech yejón barko iva desde ompa ope kinmachtia in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ijkuak otlanki okintlapovi, okilvi in Simón: —Xikijkuani in barko kan okachi tlawejkatla, iva ompa xikintlamotlakah inmoredvah para xikinkitzkikah michimeh. ");
INSERT INTO nsu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón okinankili: —Tlamachti, nochi se yovali otitekipanojtokah iva amo otikajsikeh nion se michi. Pero nikchivas ijkó kemi tikijtova. ");
INSERT INTO nsu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ijkuak in michkitzkijkeh ijkó okichijkeh, okinkitzkijkeh sa tlawel miekeh michimeh asta yi mero okojkotonia inredvah. ");
INSERT INTO nsu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ijkuakó okinnotzkeh ika inmah intekitkaiknivah tlen okatkah itech oksé barko para ma kinpalevitih. Oyajkeh okinpalevitoh iva okintemitijkeh nochtin ome barkojtih asta yi mero oapachiviah. ");
INSERT INTO nsu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ijkuak ijkó okittak in Simón Pedro, omotlankuaketzki iyakapan Jesús, iva okilvi: —Xonmachiva de ne, noTeko, porke ne nitlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón ijkó okijto porke ye ivan nochtin itekitkaiknivah, okimotetzavijkeh iva ayakmo okimatiah tlán kijtoskeh, porke sa tlawel miekeh michimeh okinkitzkijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Noijki okimotetzavijkeh in Jacobo ivan Juan, ipilvah in Zebedeo, tlen itekitkaiknivah in Simón. Pero Jesús okilvi in Simón: —Amo ximomavti, porke desde axka tikintlanis in gentejtih para ma nechseguirokah kemi oyeskia tikinkitzkis michimeh. ");
INSERT INTO nsu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Satepa okintilankeh inbarkojvah asta itempan atl, ompa okajtejkeh nochi iva oyajkeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ijkuak Jesús okatka itech se altepetl, oajsiko se tlakatl tlen opalania inakayo, iva ijkuak okittak in Jesús, omotlankuaketzki iva omixtlapacho ipan tlali, iva okitlatlavti okilvi: —NoTeko, tla tikmonekiltis techpajtis, techpajti para ma nimokava nichipavak. ");
INSERT INTO nsu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ijkuakó Jesús okitlali ima ipan yejón tlakatl, iva okilvi: —Kema. Nikneki xipajti. San nima ijkuakó in kokolistli okiski. ");
INSERT INTO nsu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Satepa Jesús okinavati amika ma kitlapovi. Okilvi: —Xivia inavak in tiopixki para ma mitzita nik yotipajtik, iva xiktemaka motlamanal ijkó kemi kijtova itlanavatil Moisés, para ijkó nochtin ma kimatikah nik yotichipavik de mokokolis. ");
INSERT INTO nsu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero sentetl omotlapoviayah okachi de tlen okichivaya in Jesús, iva miekeh gentejtih omololovayah para kikakiskeh iva para ma kinpajti de inkokolis. ");
INSERT INTO nsu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús nochipa okitemovaya se lugar kan tlalkavali para modiostzajtzilis. ");
INSERT INTO nsu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Se tonali, Jesús otlamachtijtoka, iva ik ompa oyetokah sekimeh fariseos iva sekimeh tlamachtijkeh de itlanavatil Moisés tlen ovalajkeh de nochtin altepemeh de Galilea, de Judea iva de siudad de Jerusalén. Ivelitilis in toYejwatzi omoteititiaya itech Jesús para okinpajtiaya tlen mokokovah. ");
INSERT INTO nsu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ijkuakó ovalajkeh sekimeh tlakah okivalikayah se tlakatl vilantzi ika ikochpetl, iva okinekiah kikalakiskeh kalijtik para kitlaliskeh iyakapan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero amo ovelik okikalakijkeh porke otentokah miekeh gentejtih. Tonses, otlejkokeh ikpak kali. Okikuatlapojkeh in kali, iva ik ompa okitemovijkeh in vilantzi ika ikochpetl asta tlatlajko de kan okatkah in gentejtih, iva okitlalijkeh iyakapan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ijkuak Jesús okittak nik yi neli okineltokayah in yejonmeh tlakah, ijkuakó okilvi in vilantzi: —Tlakatl, nimitztlapojpolvia de nochi motlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ijkuakó in tlamachtijkeh de itlanavatil Moisés ivan fariseos okiyejyekojkeh: “¿Akin momachilia nin tlakatl kixpanavia in Dios? Amika velis tetlapojpolvis de tlajtlakoli, san yen Dios velis tetlapojpolvis.” ");
INSERT INTO nsu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús yokimatia tlen yejvah okiyejyekovayah, iva okinmilvi: —¿Tleka ijkó inkiyejyekovah? ");
INSERT INTO nsu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Techilvikah: ¿Katli yen okachi amo ovi nikilvis nin vilantzi: “Nimitztlapojpolvia de nochi motlajtlakol”, o noso nikilvis: “Ximeva iva xinejnemi”? ");
INSERT INTO nsu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero Ne nimechititis ke iKone in Tlakatl kipia tlanavatijkayotl itech nin tlaltikpaktli iva veli tetlapojpolvia de nochi tlajtlakoli. Ijkuakó okilvi in vilantzi: —Tejwatzi nimitzilvia, ximeva, xikajkuana mokochpetl iva xivia mokalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","San niman ijkuakó, in vilantzi omejki inmixpa nochtin, okajkuanki ikochpetl iva oyá para ikalijtik kiweijkachijtiv in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nochtin omotetzavijkeh iva okiweijkachijkeh in Dios, iva ika miek nemavtili okijtojkeh: —Axka yotikittakeh se wei tlamantli tlen amo semi otikittayah. ");
INSERT INTO nsu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Satepa de yejón, Jesús okiski iva okittak se tlakatl kobrador de impuestos itoka Leví. Oyetoka kan tlakobrarovah de impuestos, iva Jesús okilvi: —Xiviki nova. ");
INSERT INTO nsu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví omoketzki, okajte nochi, iva oyá ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Satepa, Leví okichi se wei ilvitl ikalijtik para yen Jesús. Ompa otlakuajtokah miekeh kobradortih de impuestos iva oksekimeh gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero in fariseos ivan tlamachtijkeh de itlanavatil Moisés ope kinpojpovah in momachtijkeh de Jesús, okinmilvijkeh: —¿Tleka imejvah intlakuah iva inkonih invah kobradortih de impuestos, iva noijki invah tlen tlajtlakolejkeh? ");
INSERT INTO nsu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús okinnankili: —Tlen amo mokokovah amo yavih kittativih se tepajti, sino tlen mokokovah. ");
INSERT INTO nsu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne amo onivala para nikinnotzas tlen momachiliah tlakamelajkeh, sino onivala para nikinnotzas tlen tlajtlakolejkeh para ma moyolkuapakah. ");
INSERT INTO nsu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ijkuakó yejvah okitlajtlanijkeh in Jesús: —¿Tleka tlen momachtijkeh de Juan iva tlen de fariseos, yejvah mosavah iva modiostzajtziliah miek welta, pero tlen tejwatzi tikinmachtia tlakuah iva konih? ");
INSERT INTO nsu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús okinnankili: —¿Velis imejvah inkinmilviskeh ma mosavakah tlen kinminvitarovah kan monamiktiah, mientras in novio ompa kajki invah? ");
INSERT INTO nsu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero ajsis tonali ijkuak kivikaskeh in novio, iva ijkuakó kema velis mosavaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Noijki okinmilvi nin ejemplo: —Amika kiteki se pedaso in tzotzoli tlen yankuik para kitlamanis se tzotzoli tlen yi tlajtlantok. Tla ijkó se kichivas, san se kijtlakos in tzotzoli yankuik, iva in pedaso tlen yankuik fiero mottas itech in tzotzoli tlen yi tlajtlantok. ");
INSERT INTO nsu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Noijki amika kitlalia yankuik vino ika kulambre tlen yi tlajtlantok, porke in yankuik vino kitzomonia, iva nokivi in vino iva in kulambre ijtlakavi. ");
INSERT INTO nsu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","In yankuik vino moneki motlalis ika kulambre yankuik, iva ijkó nochtin omeh wejkavaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iva tlen konis vino tlen yowejka, satepa ayakmo kinekis konis vino tlen yankuik, porke kijtos: “In vino tlen yowejka, okachi velik.” ");
INSERT INTO nsu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Se sábado, Jesús iva tlen okinmachtiaya onejnentiayah kan toktok trigo. In momachtijkeh okuakojkotontiayah trigo, okoyayah iva okikuayah. ");
INSERT INTO nsu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ijkuakó sekimeh fariseos okintlajtlanijkeh: —¿Tleka imejvah inkichivah tlen amo kipia de inkichivaskeh ijkuak sábado? ");
INSERT INTO nsu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús okinnankili: —¿Amo kema inkilerovah tlen okichi in David ijkuak ye ivan iyoliknivah otiojsijkeh? ");
INSERT INTO nsu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David okalakki ikalijtik in Dios, okitilanki in pan tlen tlatiochivali iva okikua, iva noijki okinmajmakak pan iyoliknivah para ma kikuakah. Maski itlanavatil Moisés kijtova san yejvah tiopixkeh velis kikuaskeh yejón pan. ");
INSERT INTO nsu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Noijki okinmilvi: —IKone in Tlakatl yen mochijtok tekova de yen tonali sábado iva yen velis kijtos tlán velis se kichivas itech yejón tonali. ");
INSERT INTO nsu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Oksé sábado, Jesús okalakki kan tiotlamachtijkali iva ope tlamachtia. Ompa okatka se tlakatl tlen ovaki iyekma. ");
INSERT INTO nsu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","In tlamachtijkeh de itlanavatil Moisés ivan fariseos sa okistlakojtokah in Jesús para kittaskeh kox kipajtis yejón tlakatl ijkuak sábado. Tla kipajtis, velis kiteilviskeh. ");
INSERT INTO nsu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús yokimatia tlen yejvah okiyejyekovayah, iva okilvi in tlakatl tlen ovaki ima: —Ximeva iva ximoketza tlatlajko. In tlakatl omejki iva omoketzki ompa tlatlajkotia. ");
INSERT INTO nsu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iva ijkuakó Jesús okinmilvi tlen ompa okatkah: —Nimechtlajtlanis se tlajtoli: ¿Tlán moneki se kichivas ijkuak sábado, tlen kuali o noso tlen amo kuali? ¿Moneki se kimakixtis inemilis de íkka o noso moneki se kixpolos? ");
INSERT INTO nsu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús okintlajtlatak nochtin, iva okilvi in tlakatl tlen ovaki ima: —Xikmelava moma. In tlakatl okimela ima iva opajtik. ");
INSERT INTO nsu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero in tlamachtijkeh de itlanavatil Moisés ivan fariseos sa tlawel okualankeh, iva ope kimolviah entre yejvah tlán velis kitoktiskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Itech yejonmeh tonaltih Jesús oyá ipan se tepetl omodiostzajtzilito, iva ompa omodiostzajtzili nochi se yovali. ");
INSERT INTO nsu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Omostlatik, okinnotzki tlen momachtijkeh, iva okinpejpenki majtlaktli ivan ome de yejvah, iva okintokayoti tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ijkí intoka in tiotlatitlaniltih: Simón tlen Jesús okitokayoti Pedro, Andrés ikni in Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO nsu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo ipiltzi in Alfeo, Simón tlen onemia invah cananistas, ");
INSERT INTO nsu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ikni in Jacobo, ivan Judas Iscariote tlen satepa okitemakti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ivan momachtijkeh otemokeh de ipan tepetl iva omoketzatoh kan ixtlavak. Ompa omololojkeh noijki miekeh oksekimeh tlen invah onemiah. Iva noijki omololojkeh miekeh gentejtih tlen ovalajkeh de tlali de Judea, de siudad de Jerusalén iva noijki de siudad de Tiro iva de Sidón tlen kateh itempan atl tlen wei. Ovalajkeh para kikakiskeh in Jesús iva para ma kinpajti de inkokolis. ");
INSERT INTO nsu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tlen otlajyoviayah inmak tlen amo kuali ejekameh, opajtikeh. ");
INSERT INTO nsu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nochtin okinekiah kitilkoskeh in Jesús, porke itech okisaya ivelitilis iva nochtin opajtiah. ");
INSERT INTO nsu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús okintlajtlatak tlen momachtijkeh iva okinmilvi: —Xipakikah imejvah tlen inprowestih, porke imejvah inpovih kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Xipakikah imejvah tlen axka intiojsivih, porke imejvah inmixviskeh. ’Xipakikah imejvah tlen axka inchokah, porke satepa imejvah inwetzkaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Xipakikah imejvah tla por inkineltokah iKone in Tlakatl imechkualankaitaskeh, imechtlaliskeh sekka, tlapovaskeh fiero de imejvah, amo imechnekiskeh iva kijtoskeh ke amo inkualmeh. ");
INSERT INTO nsu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sa tlawel xipakikah ijkuak ijkó inkipanoskeh, porke imejvah inkiseliskeh se wei tlaxtlavili itech ilvikak. Porke nepa tiempo tlen yejvah inkojkolvah no ijkó okintoktijkeh in tiotenejmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero prowestih de imejvah tlen intominejkeh, porke yonkipixkeh kuali nemilistli. ");
INSERT INTO nsu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Inprowestih imejvah tlen axka inmixvitokeh, porke satepa intiojsiviskeh. ’Inprowestih imejvah tlen axka inwetzkah, porke satepa inchokaskeh de neyolkokoli. ");
INSERT INTO nsu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Inprowestih imejvah ijkuak nochtin gentejtih kuali tlapovaskeh de imejvah, porke nepa tiempo inmokojkolvah noijki kuali otlapovayah de nekateh tiotenejmachtijkeh tekajkayajkeh. ");
INSERT INTO nsu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero imejvah tlen innechkakih nimechilvia: Xikintlasojtlakah tlen imechtlavelitah. Xikinchivilikah tlen kuali tlen imechkualankaitah. ");
INSERT INTO nsu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xiktlajtlanilikah Dios ma kintiochiva tlen imechtenxojxojviah. Ximodiostzajtzilikah por yejvah tlen imechtoktiah tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tla íkka mitzixtlatzinia se lado, xikavili noijki ma mitzixtlatzini in oksé lado. Iva tla íkka mitzkixtilia mochamarra, xikavili noijki ma kivika mokamisa. ");
INSERT INTO nsu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tla íkka mitztlajtlanilia itla, xikmaka. Iva tla íkka mitzkixtilis tlen moaxka, ayakmo xiktlajtlanili. ");
INSERT INTO nsu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xikchivakah invan oksekimeh ijkó kemi imejvah inkinekih ma kichivakah imovah. ");
INSERT INTO nsu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tla imejvah inkintlasojtlah san yejvah tlen imechtlasojtlah, ¿kox sa tlawel wei tlen inkichivah? Asta tlen tlajtlakolejkeh no ijkó kichivah. ");
INSERT INTO nsu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iva tla inkinchiviliah tlen kuali san yejvah tlen imechchiviliah tlen kuali, ¿tlán kuali tlen inkichivah? Porke in tlajtlakolejkeh no ijkó kichivah. ");
INSERT INTO nsu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iva tla imejvah inkitetlanetiah itla tlamantli iva inkichiah ma imechmakakah itla, ¿tlán kuali tlen inkichivah? Porke in tlajtlakolejkeh noijki kimotlatlanetiah itla tlamantli se ivan oksé, iva noijki kichiah ma kinmakakah itla. ");
INSERT INTO nsu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Imejvah moneki xikintlasojtlakah tlen imechtlavelitah, iva xikinchivilikah tlen kuali iva xikintlanetikah tlen kinekih iva amo xikchiakah ma imechmakakah itla. Ijkó inkipiaskeh wei inmotlaxtlavil, iva ijkó inyeskeh yi neli intepilvah de Dios tlen Weijkatlalitok. Porke Dios sa tlawel kuali iyelis asta para invan gentejtih tlen amo kualmeh iva tlen amo kimatih motlasojkamatih. ");
INSERT INTO nsu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Imejvah xiekah inteiknomatkeh, ijkó kemi inmoTajtzi Dios Ye teiknomatki. ");
INSERT INTO nsu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Amo xitlapovakah de oksekimeh, iva ijkó toYejwatzi amo tlapovas de imejvah. Amo xitetlajtlakoltikah, para ijkó noijki toYejwatzi amo imechtlajtlakoltis. Xitetlapojpolvikah, iva toYejwatzi imechtlapojpolvis. ");
INSERT INTO nsu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tla imejvah inkitemakaskeh itla, toYejwatzi imechmakas noijki. Tlen imejvah inkitemakaskeh, toYejwatzi imechmakas okachi miek asta amo akis ijtik inmobolsa, maski inkitzejtzeloskeh iva inkitijtiliniskeh, temis iva asta tetepevis. Porke ijkó kemi imejvah inkintamachivaskeh tlen oksekimeh, toYejwatzi noijki ijkó imechtamachivas. ");
INSERT INTO nsu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús noijki okinmilvi nin ejemplo: —¿Velis se tlakatl tlen amo tlachia kiyakanas oksé tlen noijki amo tlachia? ¿Amo nochtin omeh velis vetzitivih kan tlakuyo? ");
INSERT INTO nsu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Se tlen momachtia mach velis okachi tlapanavijtos ke itlamachti. Pero ijkuak tlamis momachtis, noijki velis yetos kemi itlamachti. ");
INSERT INTO nsu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Tleka tikitta mokni por yen tzikitzi itlajtlakol ivan te amo timotta ke tikpia okachi wei motlajtlakol? Yejón kemi oyeskia tikitta mokni kipia se tlajsoltzintli itech ixtololo, ivan te amo timotta ke tikpia asta se wei kuavitl itech moixtololo. ");
INSERT INTO nsu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿O noso kenik veli tikilvia mokni: “Ma nimitzkixtili in tlajsoltzintli de itech moixtololo”, iva te asta tikpia se wei kuavitl itech moixtololo? ¡Tikpia ome moixko! Achto te xikmokixtili in wei kuavitl tlen tikpia itech moixtololo, para ijkó velis titlachias iva velis tikixtilis in tlajsoltzintli tlen kipia mokni. ");
INSERT INTO nsu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Se tlen kuali kuavitl mach velis kitlakiltis tlakilotl tlen amo kuali, iva se amo kuali kuavitl mach velis kitlakiltis tlakilotl tlen kuali. ");
INSERT INTO nsu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Porke nochi kuavitl moixmati por itlakilo. Amika kiteki igos itech se kuavitl vitzo, iva nion amika kiteki uvas itech kovatlanvitztli. ");
INSERT INTO nsu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Se tlen kuali tlakatl kijtova tlen kuali porke itech iyolo onka tlen kuali. Iva se tlakatl tlen amo kuali kijtova tlen amo kuali porke itech iyolo onka tlen amo kuali. Porke tlen kijtova se tlakatl ika ikamak kijtosneki yen yejón tlen kipixtok itech iyolo. ");
INSERT INTO nsu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Tleka imejvah innechnotzah, “noTeko, noTeko”, iva amo inkichivah tlen nimechilvia? ");
INSERT INTO nsu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tlen vitz nonavak, iva nechkaki iva kichiva tlen nikijtova, yejón kemi se tlakatl ");
INSERT INTO nsu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","tlen okichi ikal, pero achto otlachkuak wejkatla, iva okichi itlakxitlanyo ipan tetl. Ijkuak ovala in atepeatl, itech omotlavitekiko chikavak in kali, pero amo okolini porke okipiaya itlakxitlanyo ipan tetl. ");
INSERT INTO nsu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero tlen nechkaki iva amo kichiva tlen nikijtova, yejón kemi se tlakatl tlen okichi ikal san ipan tlali, iva amo kipia itlakxitlanyo. Iva ijkuak ovala in atepeatl iva omotlavitekiko chikavak itech kali, ovetzki iva nochi oxixinki. ");
INSERT INTO nsu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ijkuak Jesús otlanki okintlapovi in gentejtih, oyá kan altepetl de Capernaum. ");
INSERT INTO nsu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ompa okatka se kapita romano tlen okipiaya se itlakeval tlen okitlasojtlaya, iva chikavak omokokovaya iva yi ixpolitok. ");
INSERT INTO nsu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ijkuak in kapita okikakki motlapoviah de Jesús, ijkuakó okintitlanki sekimeh tlayakankeh judiojtih para ma kitlatlavtitih ma viki ma kipajtiki itlakeval. ");
INSERT INTO nsu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tonses oyajkeh okittatoh in Jesús iva okitlatlavtijkeh, okilvijkeh: —Nin kapita yompa moneki xikpalevi, ");
INSERT INTO nsu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porke kitlasojtla topaís, iva ye okichi totiotlamachtijkal ika itomi. ");
INSERT INTO nsu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús oyá invah. Iva ijkuak yonnajsiah kan ikalijtik in kapita, in kapita okintitlanki sekimeh iyoliknivah para ma kilvikah in Jesús: —NoTeko, amo ximotekipacho, porke amo notech povi para xikalaki nokalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Por eso amo onimixevi onia onimitzitato nonevia. San xikijto ma pajti notlakeval iva pajtis. ");
INSERT INTO nsu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porke ne noijki yonimomatki nikchiva tlen nechnavatiah. Iva noijki ne nikinpia sekimeh soldadojtih tlen nikinnavatia. Ijkuak nikilvia se de yejvah: “Nepa xonyati”, in ye yavi. Iva tla nikilvis in oksé: “Xiviki”, in ye vitz. Iva tla nikilvis notlakeval: “Xikchiva nin tekitl”, in ye kichiva. ");
INSERT INTO nsu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ijkuak Jesús ijkó okikakki, sa otlatlachixki, omokuapki iva okintlajtlatak tlen okiseguirovayah, iva okinmilvi: —Yi neli nimechilvia, ke amo kema nikajsi nion se tlakatl de Israel tlen ma kipia wei itlaneltokalis kemi nin tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tlen okintitlankeh omokuapkeh kan ikalijtik in kapita iva okitajsikeh itlakeval yopajtik. ");
INSERT INTO nsu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Satepa de yejón, Jesús oyá kan se altepetl itoka Naín. Noijki oyajkeh in momachtijkeh iva miekeh oksekimeh gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ijkuak oajsitoh serka kan puerta de yejón altepetl, okittakeh yavih kitookativih se mikatl. In tena de yejón mikatl okatka iknosivatl. Miekeh altepetlakah ivan oyayah. ");
INSERT INTO nsu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ijkuak in toTeko okittak in iknosivatl, okiknomatki iva okilvi: —Amo xichoka. ");
INSERT INTO nsu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús omotoki iva okitilko in kaja. Iva tlen okikechpanovayah in kaja omoketzkeh. Jesús okilvi in mikatl: —Telpochtli, Ne nimitzilvia: ¡Ximeva! ");
INSERT INTO nsu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ijkuakó tlen oixpolika, omejki iva ope tlapova, iva Jesús okimaktili imama. ");
INSERT INTO nsu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nochtin omomavtijkeh ijkuak ijkó okittakeh, iva ope kiweijkachivah in Dios, okijtovayah: —Yomonexti se wei tiotenejmachti tovah. Iva noijki okijtovayah: —Dios yovala para techpalevis tejvah tlen de Israel tlen tiiaxkavah. ");
INSERT INTO nsu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yejón tlamantli tlen Jesús okichi niman okimatkeh itech nochi in tlali de Judea iva itech nochtin altepemeh tlen ik ompa kateh. ");
INSERT INTO nsu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan tlen tlabautisaro okimatki nochi tlen Jesús okichivaya, porke tlen Juan okinmachtiaya yejvah okimatiltijkeh. Por eso, okinnotzki ome momachtijkeh de ye, ");
INSERT INTO nsu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","iva okintitlanki inavak Jesús para ma kitlajtlaniitih kox yen Cristo tlen kipia de vitz, o noso ok moneki kichiaskeh ma viki. ");
INSERT INTO nsu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tlen Juan okintitlanki, omotokijkeh inavak Jesús, iva okitlajtlanijkeh: —Juan tlen tlabautisaro otechvaltitlanki ma timitztlajtlaniikih kox tejwatzi tiCristo tlen tikchiah vitz se tonali, o noso moneki ok tikchixtoskeh. ");
INSERT INTO nsu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Itech yejón ora, mero ijkuakó Jesús okinpajtijtoka miekeh tlen okipiayah tlatlamantli kokolistli, iva okinkixtiaya amo kuali ejekameh, iva okintlachialtiaya miekeh tlen amo otlachiayah. ");
INSERT INTO nsu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iva Jesús okinnankili: —Xiviah xikilvitih in Juan tlen imejvah yonkittakeh iva yonkikakeh. Xikilvikah ke tlen amo otlachiayah axka yi tlachiah, in koxomeh yi kuali nejnemih, tlen opalania innakayo axka yi chipavih de inkokolis, tlen amo otlakakiah axka yi tlakakih, in mikameh moyolitiah iva in prowestih kikakih tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iva ma paki tlen akin amo kipolova itlaneltokalis nonavak. ");
INSERT INTO nsu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ijkuak oyajkeh tlen Juan okintitlanki, ijkuakó Jesús ope kintlapovia in gentejtih de yen Juan tlen tlabautisaro: —¿Tlán onkittatoh kan tlavaki? ¿Onkittatoh se tlakatl tlen itlaneltokalis kivivika in ejekatl kemi ijkuak in ejekatl kivivika se akatl? ");
INSERT INTO nsu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tonses, ¿akin onkittatoh? ¿Onkittatoh se tlakatl tlen konakia itzotzol tlen kuali? Imejvah kuali inkimatih ke tlen konakiah intzotzol tlen kuali iva mopakilismakah ika tlen kipiah, kateh inchan wejwei tlanavatijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tonses, ¿tlán onkittatoh? ¿Se tiotenejmachti? Yi neli, Juan oyajki okachi ke se tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","In Tiotlajkuiloli tlajtova de yen Juan kan kijtova: Ne niktitlani notlatematiltil moyakapa, ma sa kiyektlali in ojtli para ijkuak tivalmuikas. ");
INSERT INTO nsu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iva nimechilvia, ke de nochtin tlaltikpaktlakah, amo onka oksé tlen ma yeto okachi mejor ke Juan. Pero kan Dios tlanavatia, se tlen amo ipanitalistli yejón okachi mejor ke Juan. ");
INSERT INTO nsu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Miekeh gentejtih iva asta tlen tlakobrarojkeh de impuestos, ijkuak okikakkeh in Juan, okilvijkeh ma kinbautisaro, porke okajsikamatkeh nik yompa tlen Juan okinmachtiaya de itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero in fariseos ivan tlamachtijkeh de itlanavatil Moisés amo okinekeh tlen Dios okinekia para yejvah, porke amo okinekeh ma kinbautisaro in Juan. ");
INSERT INTO nsu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús noijki okijto: —¿Tlán ika velis nikinparejaros in gentejtih de nin tiempo? ");
INSERT INTO nsu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kateh kemi chokojtih tlen motlaliah maviltiah tiankistli iva kintzajtziliah inyoliknivah, kinmilviah: “Tejvah otimechtlapichilijkeh ika flauta para ximijtotikah, pero amo onmijtotijkeh. Otimechtlakuikilijkeh se tlakuikali teyolkoko, pero amo onchokakeh.” ");
INSERT INTO nsu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porke ovala in Juan, tlen omosavaya iva amo okonia vino, iva imejvah inkijtovah ke kipia se amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Satepa ovala iKone in Tlakatl, tlen tlakua iva koni, iva imejvah inkijtovah ke apistli iva tlavanki, iva inkijtovah invah movika in tlajtlakolejkeh iva in kobradortih de impuestos. ");
INSERT INTO nsu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero in tlamatilistli de Dios moteititia por tlen kichivah ipilvah. ");
INSERT INTO nsu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Se fariseo okinvitaro in Jesús ma tlakuati ikalijtik. Jesús oyá ikalijtik in fariseo iva omotlali kan mesa. ");
INSERT INTO nsu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ijkuakó se sivatl de yejón altepetl tlen onemia itech tlajtlakoli, ijkuak okimatki ke Jesús oyá otlakuato ikalijtik in fariseo, ijkuakó ye ompa oajsito okivikaya se boteyajtzi de alabastro tentok de ajviakayotl. ");
INSERT INTO nsu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Omotlankuaketzki ikxitlan Jesús, ochokaya sa tekitl iva ixayo ochapania itech ikxivah in Jesús. Para ompa ope kikxivajvatza ika itzonkal, okikxipipitzo iva okiteekili ajviakayotl itech ikxivah. ");
INSERT INTO nsu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ijkuak ijkó okittak in fariseo tlen okinvitaro in Jesús, okiyejyeko: “Tla nin tlakatl yi neli oyeskia tiotenejmachti, okimomakaskia kuenta akin nin sivatl tlen kikikitzkia iva tlán itekiv, porke nin sivatl tlajtlakole.” ");
INSERT INTO nsu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ijkuakó Jesús okilvi in fariseo: —Simón, nikneki nimitzilvis se tlajtoli. In fariseo okinankili: —Techilvi, Tlamachti. ");
INSERT INTO nsu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ome tlakah okivikiliayah tomi se tlakatl tlen kitetlanetia tomi. Se okivikiliaya makuili siento tomi de plata, iva oksé okivikiliaya san tlajko siento. ");
INSERT INTO nsu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iva komo amo oveliah okikuapiliayah, in tlakatl tlen kitetlanetia tomi okintlapojpolvi nochtin omeh. Axka techilvi, ¿katli ye de yejonmeh omeh okachi kitlasojtlas? ");
INSERT INTO nsu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón otlanankili: —Ne nikyejyekova yen tlen okitevikiliaya okachi. Jesús okilvi: —Kema, yi neli kemi tikijtova. ");
INSERT INTO nsu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús okonitak in sivatl iva okilvi in Simón: —¿Tikitta nin sivatl? Onikalaki mokalijtik, iva amo otechmakak atl para nokxivah. Pero nin sivatl onechikxipajpaki ika ixayo, iva onechikxivajvatzki ika itzonkal. ");
INSERT INTO nsu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te ijkuak otechtlajpalo amo otechixpipitzo, pero ye nechikxipipitzojtok desde onikalakiko. ");
INSERT INTO nsu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te amo otechteekili aseite ipan notzonteko, pero ye onechteekili ajviakayotl itech nokxivah. ");
INSERT INTO nsu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nin sivatl nechtlasojtla miek porke kimati ke yoniktlapojpolvi de miek tlajtlakoli. Pero se tlen amo miek kitlapojpolviah de itlajtlakol, san tzikitzi tetlasojtla. ");
INSERT INTO nsu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ijkuakó okilvi in sivatl: —Nimitztlapojpolvia de nochi motlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tlen oksekimeh invitadojtih tlen ompa oyetokah kan mesa, ope motlapoviah entre yejvah: —¿Akin nin tlakatl? ¿Kenik mixevia tetlapojpolvia de tlajtlakoli? ");
INSERT INTO nsu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús okilvi in sivatl: —Yotimomakixti porke otechneltokak. Xivia ika kuali. ");
INSERT INTO nsu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Satepa de yejón, Jesús onemia itech miekeh siudades iva altepemeh, otetlapoviaya de yen yankuik kuali tlajtoli de kenik in Dios tlanavatia. In majtlaktli ivan ome momachtijkeh oyayah ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Noijki ivan oyayah sekimeh sivameh tlen okinpajti de amo kuali ejekameh iva de tlatlamantli kokolistli. Se de yejonmeh sivameh itoka María, tlen noijki okinotzayah Magdalena, tlen Jesús okinkixtili chikomeh amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Noijki oyaya in Juana, isiva in Chuza, Chuza yen okittaya nochi tlen iaxka in Herodes. Noijki oyaya in Susana, iva miekeh oksekimeh sivameh tlen okipaleviayah in Jesús ika tlen yejvah okipiayah. ");
INSERT INTO nsu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miekeh okiskeh de inmaltepe para kittaskeh in Jesús. Iva ijkuak omololojkeh miekeh gentejtih, ijkuakó okintlapovi ika se ejemplo. Okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Se tlakatl okiski otookato. Ijkuak otookatoka, seki semiya ovetzki ipan ojtli. In gentejtih ipan omokejketzkeh, iva in totomeh okikuajkeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Okseki semiya ovetzki kan teyo. Iva ijkuak in semiya oixvak, niman ovaki porke amo okipiaya kochavalistli. ");
INSERT INTO nsu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Okseki semiya ovetzki ijtik xivyo tlen vitzo tlen omoskalti ivan tlatoktli, iva okijyomiktijkeh in tlatoktli. ");
INSERT INTO nsu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Iva okseki semiya ovetzki kan kuali tlali. Iva ijkuak oixvak, omoskalti iva okipixki kuali itlakilo, iva kada se semiya okitemakak asta se siento tleyoltzintli. Ijkuak Jesús otlanki ijkó okijto, ijkuakó okinmilvi chikavak: —Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tlen momachtijkeh okitlajtlanijkeh in Jesús tlán kijtosneki yejón ejemplo. ");
INSERT INTO nsu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iva Jesús okinmilvi: —Imejvah Dios imechkavilia xikmatikah tlen achto amika okimatia de kenik in Dios tlanavatia. Pero oksekimeh nikinmachtia ika ejemplos, para ijkó, maski yejvah ma kittakah tlen nikchiva amo kimomakaskeh kuenta tlán kijtosneki. Iva maski ma kikakikah tlen nikijtova amitla velis kajsikamatiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’In ejemplo tlen yonimechilvi kijtosneki: In semiya yen itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","In semiya tlen ovetzki ipan ojtli kijtosneki yejvah tlen kikakih itlajtol in Dios, pero vitz in Amo Kuali Tlakatl iva kinkixtilia in tlajtoli tlen omotookak itech inyolo, para amo ma kineltokakah iva amo ma momakixtikah. ");
INSERT INTO nsu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","In semiya tlen ovetzki kan teyo kijtosneki yejvah tlen kikakih itlajtol in Dios iva kiseliah ika pakilistli, pero amo wejkatla monelvayotiah. Kineltokah san kana keski tonali, pero ijkuak panovah ovijkayotl, ayakmo motenmachiah inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","In semiya tlen ovetzki ijtik xivyo tlen vitzo, kijtosneki yejvah tlen kikakih itlajtol in Dios pero kintekipachova miek tlamantli, kinekih kipiaskeh tomi, iva kinekih mopaktiskeh itech nin tlaltikpaktli. Iva mokavah kemi tlatoktih tlen amo tlakih. ");
INSERT INTO nsu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero in semiya tlen ovetzki kan kuali tlali, kijtosneki yejvah tlen kikakih itlajtol in Dios iva kiseliah ika kuali iva ika nochi inyolo. Ninmeh kuali moyekketzah, iva motlamih kemi tlatoktih tlen kitemakah miek tlakilotl. ");
INSERT INTO nsu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Amika kixotlaltia se tlavili para kitepachos ika se xoktzi, nion amo kitlaliah itlampa se kochtlapechtli, sino kitlaliah tlakpak para ma kintlavili nochtin tlen kalakih kalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Porke nochi tlen tlaatitok kipia de paninesis, iva nochi tlen amo momati kipia de momatis iva nochtin kimatiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Por eso, kuali xikakikah tlen inkikakih. Porke tlen kipia, kimakaskeh okachi. Pero tlen amo kipia, asta yen tlen kiyejyekova kipia kikixtiliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Imama ivan iknivah in Jesús ovalajkeh kan Ye okatka, pero amo ovelik oajsitoh asta inavak porke ompa okatkah miekeh gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iva ik ompa okonilvijkeh in Jesús: —Momama iva moknivah kateh kiavak iva kinekih mitzitaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero Jesús okinmilvi: —Nomama iva noknivah yejvah tlen kikakih iva kichivah tlen kijtova itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Se tonali Jesús otlejkok itech se barko ivan momachtijkeh, iva okinmilvi: —Ma tipanokah ik nepa lado de nin atl tlen wei. Iva oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iva ijkuak opanotiayah, Jesús okochki. Ijkuakó ovala se ejekatl chikavak iva in atl ope motlatlaviteki itech barko iva ope atemi asta yi mero opolakia. ");
INSERT INTO nsu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ijkuakó okijxitijkeh in Jesús, iva okilvijkeh: —¡Tlamachti! ¡Tlamachti! ¡Tapoolakih! Jesús ovalme iva okitlakavalti in ejekatl ivan atl tlen omajkokuia. Iva ijkuakó in ejekatl ivan atl sa ovalmokajkeh iva omoka sa tlamantok. ");
INSERT INTO nsu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iva Jesús okinmilvi: —¿Kanin kajki inmotlaneltokalis? Yejvah sa tlawel omomavtijkeh iva sa otlatlachixkeh, iva omotlajtlaniayah: —¿Akin nin tlakatl? ¿Kenik veli kinnavatia in ejekatl ivan atl, iva kineltokiliah? ");
INSERT INTO nsu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Satepa oajsitoh kan región de Gadara, tlen kajki ik nepa lado de kan atl tlen wei, ik iyakapan tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ijkuak Jesús otemok de itech barko, ijkuakó se tlakatl de yejón altepetl omotoki inavak Jesús. Yejón tlakatl yokipiaya miek tiempo okinpiaya amo kuali ejekameh. Amo omotzotzoltiaya iva nion amo ochantia ikalijtik, sino ochantia kan mikatekochtih. ");
INSERT INTO nsu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ijkuak in tlakatl okittak in Jesús, otzajtzik chikavak iva omotlankuaketzki ikxitla, iva okijto chikavak: —¿Tlán tikneki nova, Jesús, iKone in Dios tlen Weijkatlalitok? Nimitztlatlavtia amo techtlajyovilti. ");
INSERT INTO nsu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ijkó okijto porke Jesús okinavati in amo kuali ejekatl ma kisa de ijtik in tlakatl. Yokipiaya tiempo in amo kuali ejekatl yokimoaxkatijka in tlakatl. Miek welta okijilpiayah ika kadena itech imavah iva itech ikxivah, pero ye okinkojkotonaya in kadenajtih. In amo kuali ejekatl okitoktiaya in tlakatl ma via kan tlalkavali. ");
INSERT INTO nsu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús okitlajtlani: —¿Tlán motoka? Iva ye okinankili: —Notoka Miektikeh. Ijkó okijto porke miekeh amo kuali ejekameh okalakeh ijtik in tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iva in amo kuali ejekameh okitlatlavtijkeh in Jesús amo ma kintitlani kan olvastli tlawejkatla. ");
INSERT INTO nsu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ik ompa okatkah miekeh kochijtih otlakuajtokah ipan tepetl, in amo kuali ejekameh okitlatlavtijkeh in Jesús ma kinkavili ma kalakikah inmijtik in kochijtih. Iva Jesús okinkavili. ");
INSERT INTO nsu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ijkuakó in amo kuali ejekameh okiskeh de ijtik in tlakatl iva okalakeh inmijtik in kochijtih. In kochijtih okikistevakeh iva omotepejxivitoh kan atl tlen wei, nochtin omatlanvijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","In tlajpixkeh de kochijtih, ijkuak okittakeh tlen otlamochivalok, omotlelojkeh oyajkeh okitematiltitoh kan altepetl iva ik tlala. ");
INSERT INTO nsu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","In gentejtih ovalajkeh okittakoh tlen opanolok. Ijkuak oajsikoh kan okatka in Jesús, okittakeh in tlakatl tlen ijtik okiskeh in amo kuali ejekameh, oyetoka ikxitlan Jesús, yi tzotzolejtok iva yotlalnamiki. Iva in gentejtih omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iva tlen okittakeh tlen otlamochivalok, okinmilvijkeh in gentejtih kenik opajtik in tlakatl tlen ijtik okiskeh in amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tonses nochtin gentejtih de yejón tlali de Gadara okitlatlavtijkeh in Jesús ma via de ompa, porke sa tlawel omomavtiayah. Satepa Jesús otlejkok itech se barko iva omokuapki oksemi para Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","In tlakatl tlen ijtik okiskeh in amo kuali ejekameh, okitlatlavti in Jesús ma kikavili ma via Iva, pero Jesús okinavati ma mokava, iva okilvi: ");
INSERT INTO nsu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ximokuapa para mokalijtik, iva xitetlapovi de nochi tlen Dios yokichi mova. In tlakatl oyá, iva ope tetlapovia itech nochi in altepetl de nochi tlen Jesús okichi por ye. ");
INSERT INTO nsu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ijkuak Jesús omokuapki oksemi para Galilea, miekeh gentejtih okiselijkeh ika pakilistli. Porke nochtin okichixtokah. ");
INSERT INTO nsu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ijkuakó ovala se tlakatl itoka Jairo, tlen okatka tlayakanki de itech tiotlamachtijkali. Omotlankuaketzki ikxitlan Jesús iva okitlatlavti ma via ikalijtik, ");
INSERT INTO nsu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porke okipiaya san se itakotzi de majtlaktli ivan ome xivitl, yi ixpolitok. Ijkuak Jesús yoyaya para ikalijtik in Jairo, miekeh gentejtih tlen oyayah Iva asta okipajpatzmiktiayah. ");
INSERT INTO nsu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ompa intzala oyaya se sivatl tlen yokipiaya majtlaktli ivan ome xivitl de omotlapalojviti, iva yokitlami nochi itomi ivan tepajtijkeh iva nion se tepajti amo ovelia okipajtiaya. ");
INSERT INTO nsu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yejón sivatl omotoki inavak Jesús ik ikuitlapa iva okonkitzkili itlaken tlen kimokentia san itenpantzi, iva san nima ijkuakó omoketzki in estli. ");
INSERT INTO nsu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ijkuakó Jesús okijto: —¿Akin okitzki notlaken? Nochtin okijtovayah nik amika okitzkili, Pedro iva tlen ivan oyayah, okijtojkeh: —Tlamachti, in gentejtih mitzpajpatzmiktiah iva mitztojtopevah, ¿kenik titlajtlani akin okitzki motlaken? ");
INSERT INTO nsu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús okijto: —Íkka okitzki notlaken, porke onikmachili notech okiski novelitilis. ");
INSERT INTO nsu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ijkuak in sivatl okimomakak kuenta nik amo velis kitlaatis de kenik opajtik, omotoki inavak Jesús iva omotlankuaketzki ikxitla iva sa oviviokatoka. Nochi okimokuiti inmixpa nochtin gentejtih por tlán nik okitzkili itlaken, iva kenik san niman opajtik. ");
INSERT INTO nsu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iva Jesús okilvi in sivatl: —Nokone, yotipajtik porke otechneltokak. Xivia ika kuali. ");
INSERT INTO nsu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ijkuak in Jesús ok okitlapovijtoka in sivatl, ijkuakó oajsiko se tlakatl tlen ovalaya de kan ikalijtik in Jairo, iva okilvi in Jairo: —Motakotzi yoixpolivik. Ayakmo xiktekimaka in Tlamachti. ");
INSERT INTO nsu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús okikakki iva okilvi: —Amo ximomavti. Moneki san techneltoka iva motakotzi pajtis. ");
INSERT INTO nsu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ijkuak Jesús oajsito kan ikalijtik in Jairo, Jesús amika okavili ma kalaki Iva, san yen Pedro, Jacobo, Juan ivan tetajmeh de yejón takotzi. ");
INSERT INTO nsu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nochtin ochokayah iva omoyolkokovayah por yen takotzi. Pero Jesús okinmilvi: —Amo xichokakah. In takotzi ayamo ixpolivi, ye kochi. ");
INSERT INTO nsu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","In gentejtih san okivetzkilijkeh porke kuali okimatiah nik yoixpolivik. ");
INSERT INTO nsu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero Jesús okimakitzki in takotzi iva okilvi chikavak: —Takotzi, ximeva. ");
INSERT INTO nsu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ijkuakó itonal omokuapki itech ikuerpo, iva niman ovalme. Iva Jesús okinnavati ma kitlamakakah in takotzi. ");
INSERT INTO nsu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","In tetajmeh de yejón takotzi sa otlatlachixkeh. Iva Jesús okinnavati amo ma tetlapovikah de tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús okinmololo in majtlaktli ivan ome momachtijkeh, iva okinmakak tlanavatijkayotl iva velitilistli para ma kinkixtikah nochi tlamantli de amo kuali ejekameh iva ma kinpajtikah in kokoxkeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Okintitlanki ma kitematiltikah kenik tlanavatia in Dios iva ma kinpajtikah kokoxkeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iva okinmilvi: —Amitla xikvikakah ijkuak inyaskeh itech ojtli, nion karroti, nion ayatl, nion tlaxkali, nion tomi, iva amo xikvikakah ome inmotlakenvah. ");
INSERT INTO nsu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ijkuak inmajsitivih itech se kalijtik, ompa ximokavakah asta ijkuak inkisaskeh de itech yejón altepetl. ");
INSERT INTO nsu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iva kan amo kinekiskeh imechseliskeh, xikisakah de itech yejón altepetl iva xikintzejtzelokah inmokxivah, para ma kimatikah ke amo kuali tlen yejvah kichivah. ");
INSERT INTO nsu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tonses, yejvah oyajkeh itech nochtin altepemeh, otetlapovijtiajkeh de tlen yankuik kuali tlajtoli iva okinpajtijkeh in kokoxkeh ik sentetl. ");
INSERT INTO nsu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","In kobernador Herodes okimatki nochi tlen Jesús okichivaya, iva ayakmo okimatia tlán kichivas, porke sekimeh okijtovayah ke Juan tlen tlabautisaro yomoyoliti. ");
INSERT INTO nsu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oksekimeh okijtovayah in tiotenejmachti Elías yomonexti. Iva oksekimeh okijtovayah ke se tlen oyá tiotenejmachti nepa tiempo axka yomoyoliti. ");
INSERT INTO nsu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes okijto: —Ne nonevia onitlanavati ma kikechtzontekikah in Juan. Tonses, ¿akin yejón tlakatl tlen miekeh tlapovah de ye? Iva Herodes okinekia kittas in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ijkuak in tiotlatitlaniltih omokuapatoh, okimatiltijkeh in Jesús nochi tlen okichijkeh. Satepa okinvikak san yejvah inselti ik sekka kan tlalkavali ik altepetl de Betsaida. ");
INSERT INTO nsu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero ijkuak in gentejtih okimatkeh, oyajkeh okajsitoh. Jesús okinseli iva okintlapovi de kenik in Dios tlanavatia iva okinpajti in kokoxkeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ijkuak ya yi tiotlaki, in majtlaktli ivan ome momachtijkeh omotokijkeh inavak Jesús iva okilvijkeh: —Xikinmilvi in gentejtih ma mosevitih iva ma kitemotih tlen kikuaskeh. Ma viah itech altepemeh iva ik rancherías tlen kateh serka, porke nika amitla onka. ");
INSERT INTO nsu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús okinmilvi: —Imejvah xikintlamakakah. Yejvah okilvijkeh: —Tikpiah san makuili pan iva ome michimeh. Tla tikintlamakaskeh nochtin ninmeh gentejtih, tonses moneki tiaskeh tikovativih tlen kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Okatkah kemi makuili mil tlakah. Jesús okinmilvi in momachtijkeh: —Xikinnavatikah ma motlalikah de ojompoali ivan majtlaktli. ");
INSERT INTO nsu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","In momachtijkeh okichijkeh ijkó kemi Jesús okinnavati, iva nochtin omotlalijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús okonintilanki in makuili panmeh ivan ome michimeh, oajkotlachixki iva okitlasojkamatki inavak Dios. Para ompa, okinpojpostekki iva okinmakak in momachtijkeh para ma kinxejxelilikah in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nochtin kuali otlakuajkeh asta kan oixvikeh. Satepa okintemitijkeh majtlaktli ivan ome chikimeh de pedasos tlen osobraro. ");
INSERT INTO nsu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se tonali Jesús omodiostzajtzilijtoka iselti, iva tlen momachtijkeh oajsitoh ompa kan Jesús okatka, iva Jesús okintlajtlani: —¿Tlán kijtovah in gentejtih? ¿Akin Ne? ");
INSERT INTO nsu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yejvah okinankilijkeh: —Sekimeh kijtovah tejwatzi tiJuan tlen tlabautisaro. Oksekimeh kijtovah tejwatzi tiElías, iva sekimeh kijtovah ke tejwatzi tiprofeta tlen yi wejkika otikatka, iva axka yotimoyoliti. ");
INSERT INTO nsu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iva Jesús okintlajtlani: —Iva imejvah, ¿tlán inkijtovah? ¿Akin Ne? Iva Pedro okilvi: —Tejwatzi tiCristo tlen Dios omitzvaltitlanki para techmakixtis. ");
INSERT INTO nsu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús kuali okinnajnavati amika ma kilvikah kox yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iva okinmilvi: —IKone in Tlakatl sa tlawel tlajyovis. In tlayakankeh tetajmeh, in tlayakankeh tiopixkeh, iva in tlamachtijkeh de itlanavatil Moisés amo kiseliskeh iva kixpoloskeh. Pero ipan eyi tonali moyolitis. ");
INSERT INTO nsu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iva okinmilvi nochtin: —Tla íkka kineki vitz nonavak, moneki ayakmo ma kichiva san tlan ye kinekis. Kipia de kixikos nochipa nochi in tlajyovilistli maski ma kimiktikah itech krus, iva ma nechseguiro. ");
INSERT INTO nsu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porke tla íkka kinekis kimakixtis inemilis, kipolos. Pero tla íkka kipolos inemilis por Ne, kimakixtis. ");
INSERT INTO nsu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amitla ipati tla se tlakatl yetos iaxka nochi in tlaltikpaktli, iva iselti mijtlakova iva mopolova para semijkak. ");
INSERT INTO nsu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tla íkka pinavas de Ne iva de notlajtol, iKone in Tlakatl noijki pinavas de ye ijkuak vitz ika imavissotlanex iva ika imavissotlanex de iTajtzi ivan iilvikaktlatitlanilvah. ");
INSERT INTO nsu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pero yi neli nimechilvia, ke sekimeh tlen nika kateh nova, amo mikiskeh asta kan amo ma kittakah kenik tlanavatia in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Satepa de opanok kana chikueyi tonali de ijkuak okijto yejón tlamantli, Jesús otlejkok ipan se tepetl omodiostzajtzilito, okinvikak in Pedro, Jacobo ivan Juan. ");
INSERT INTO nsu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ijkuak Jesús omodiostzajtzilijtoka, ixko omopatlak iva itzotzol omochi istak iva opetlania. ");
INSERT INTO nsu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ijkuakó omonextijkeh ome tlakah omotlapovijtokah ivan Jesús, yen Moisés ivan Elías, ");
INSERT INTO nsu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tlen okinmokenki se kualtzi mavissotlanextli. Nochtin omeh omotlapovijtokah ivan Jesús de kenik tlajyovis iva kenik ixpolivis kan siudad de Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Maski Pedro ivan ikompañerojvah sa tlawel okochisnekiah, omokajkeh ijsatokeh, iva okittakeh imavissotlanex in Jesús, iva noijki okinmitakeh in Moisés ivan Elías. ");
INSERT INTO nsu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ijkuak Moisés ivan Elías yoyayah, ijkuakó Pedro okilvi in Jesús: —Tlamachti, sa tlawel kuali nika ma tiekah. Ma tikinchijchivakah eyi sakakaltih, se para tejwatzi, se para Moisés iva se para Elías. Pero Pedro amo okimatia tlen okijtovaya. ");
INSERT INTO nsu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mientras Pedro ijkó okijtojtoka, ijkuakó ovala se mixtli iva okinmokenki, iva ijkuak yokatkah ijtik mixtli omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iva ijkuakó omokakki se tlajtoli de ijtik mixtli, okijto: —Nin yen noKone tlen niktlasojtla. Xikakikah tlen Ye imechilvia. ");
INSERT INTO nsu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ijkuak otlanki omokakki yejón tlajtoli, ijkuakó okittakeh in Jesús sa Ye iselti. Pedro, Juan ivan Jacobo ayakmitla okijtojkeh. Iva itech nonmeh tonaltih amika itla okilvijkeh de tlen okittakeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Omostlatik, ijkuak otemokeh de ipan tepetl, miekeh gentejtih okinamikitoh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ijkuakó se tlakatl tlen ompa oyaya intzala nochtin gentejtih, okijto chikavak: —Tlamachti, nimitztlatlavtia techitili notelpoch porke san yen se nikpia. ");
INSERT INTO nsu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Se amo kuali ejekatl kikitzkia iva kitzajtzitia iva kitoktia ma mimiki iva ma kamaposoni. Kikojkova iva amo kineki kikajkavas. ");
INSERT INTO nsu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Onikintlatlavti tlen tikinmachtia ma kikixtilikah in amo kuali ejekatl, pero amo ovelikeh. ");
INSERT INTO nsu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús otlanankili: —¡Imejvah seppa amo intlaneltokah iva yonmijtlakavkeh! ¿Asta keman nietos inmovah? ¿Asta keman nimechxikojtos? Nika techvalikili motelpoch. ");
INSERT INTO nsu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero ijkuak in telpochtli yomotokijtiaya inavak Jesús, in amo kuali ejekatl okitlamotlak ipan tlali iva okitokti ma mimiki. Pero Jesús okajvak in amo kuali ejekatl, okipajti in telpochtli iva okimaktili ipapa. ");
INSERT INTO nsu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nochtin sa omotetzavijkeh ijkuak okittakeh ivelitilis in Dios. Mientras nochtin omotetzaviayah por tlen Jesús okichi, ijkuakó Ye okinmilvi in momachtijkeh: ");
INSERT INTO nsu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kuali xikkakikah tlen nimechilvis: IKone in Tlakatl kitemaktiskeh inmak in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero in momachtijkeh amo okajsikamatkeh tlen okinmilvi, porke ayamo otlapovia intlayejyekol para kajsikamatiskeh. Iva okimakasiah de kitlajtlaniiskeh tlán kijtosneki. ");
INSERT INTO nsu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Satepa in momachtijkeh ope motlatlajtolnamikih akin de yejvah okachi weititok. ");
INSERT INTO nsu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero Jesús okimatia tlen yejvah okiyejyekovayah. Ijkuakó okitlali se chokotzi inakastla, ");
INSERT INTO nsu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iva okinmilvi: —Tlen kiselis ika notoka se chokotzi kemi nin, kijtosneki Ne nechselia. Iva tlen nechselia, noijki kiselia tlen onechvaltitlanki. Porke tlen okachi tzikitzi de entre imejvah, yen yejón tlen okachi weititok. ");
INSERT INTO nsu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ijkuakó Juan otlanankili: —Tlamachti, otikittakeh se tlakatl kinkixtia amo kuali ejekameh ika motoka. Iva tejvah otikilvijkeh amo ijkó ma kichiva, porke amo tovah povi. ");
INSERT INTO nsu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús okilvi: —Xikkavakah, porke tlen amo kajki kontra tejvah, tovah kajki. ");
INSERT INTO nsu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ijkuak yoajsia tonali para Jesús tlejkos ilvikak, Jesús ik okitlali yas para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Okintitlanki sekimeh itlatitlanilvah ma tlayakanakah ma viah itech se altepetl tlen kajki itech tlali de Samaria, para ma sa kipixtokah listo nochi tlen kinekis in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero in samaritanos de neká altepetl amo okinekeh okiselijkeh porke okittakeh yavi para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jacobo ivan Juan tlen momachtijkeh, ijkuak ijkó okittakeh, okilvijkeh in Jesús: —ToTeko, ¿tikneki ma timodiostzajtzilikah para ma vetzi tlitl de ilvikak para ma kinmixpolo nochtin, kemi okichi in tiotenejmachti Elías? ");
INSERT INTO nsu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús omokuapki iva okinmajvak. Okinmilvi: —Imejvah amo inkimatih tlán ejekatl inkipiah iva tleka ijkó inkijtovah. ");
INSERT INTO nsu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porke iKone in Tlakatl amo ovala okinmixpoloko in tlaltikpaktlakah, sino ovala okinmakixtiko. Satepa oyajkeh para oksé altepetl. ");
INSERT INTO nsu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ijkuak oyayah itech ojtli, ijkuakó se tlakatl okilvi in Jesús: —NoTeko, nikneki nias mova san kan tias. ");
INSERT INTO nsu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús okinankili: —In astomeh kipiah inchah kan tlakuyo ivan totomeh kipiah intepajsol. Pero iKone in Tlakatl amo kipia kan mosevis. ");
INSERT INTO nsu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús okilvi oksé tlakatl: —Xiviki nova. Pero yejón tlakatl okilvi: —NoTeko, techkavili achto ma niktookati nopapa. ");
INSERT INTO nsu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús okilvi: —Xikinkavili in gentejtih tlen kateh kemi miktokeh yejvah ma kintookakah inmikavah. Te xivia iva xiktematiltiti kenik tlanavatia in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oksé tlakatl okijto: —NoTeko, nikneki nias mova, pero achto techkavili ma nikinnavatiti tlen kateh nokalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús okilvi: —Tlen kitlalia ima itech arado ijkuak tlaxava, iva tlachia ik tlakuitlapa, yejón amo servirova kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Satepa, toTeko okinpejpenki expoali ivan majtlaktli momachtijkeh, iva okintitlanki de ojomeh ma sa tlayakanakah ma viah itech nochtin altepemeh iva ik rancherías kanik Ye panos. ");
INSERT INTO nsu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Okinmilvi: —In pixkalistli sa tlawel wei, pero amo onkateh miekeh tekipanojkeh para pixkaskeh. Por eso, xiktlatlavtikah in Tekova ma kintitlani oksekimeh tekipanojkeh para ma pixkakah. ");
INSERT INTO nsu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xiviah. Ne nimechtitlani kemi inmichkakonemeh kan kateh koyomeh. ");
INSERT INTO nsu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xikvikakah tominbolsa, nion ayatl, nion kakmeh. Iva nion amo ximoketzakah itech ojtli para íkka xiktlajpalokah. ");
INSERT INTO nsu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ijkuak inkalakiskeh kalijtik, achto xitetlajpalokah, xikijtokah: “Xonyekah ika kuali.” ");
INSERT INTO nsu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tla in chanejkeh kuali imechseliah, Dios kintiochivas para ma yekah ika kuali. Pero tla amo imechseliah, Dios amo kintiochivas, iva in tlatiochivalistli mokavas inmovah. ");
INSERT INTO nsu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ximokavakah san itech se kali, iva xikkuakah iva xikonikah tlen yejvah imechmakaskeh. Porke se tekipano kipia de kiselis itlaxtlavil. Amo sentetl ximokalotijtinemikah. ");
INSERT INTO nsu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ijkuak inmajsitivih itech se altepetl kan imechseliskeh, xikkuakah tlen yejvah imechmakaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xikinpajtikah in kokoxkeh tlen ompa yeskeh, iva xikinmilvikah: “Yi kajki serka para Dios pevas tlanavatis inmonavak.” ");
INSERT INTO nsu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero tla inmajsitivih itech se altepetl iva amo imechseliah, xikisakah itech ojtli iva xikijtokah: ");
INSERT INTO nsu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Asta yen tlali de inmoaltepe tlen otechajsik itech tokxi, tiktzejtzelovah para xikmatikah ke amo kuali tlen inkichivah. Pero xikmatikah, nik yi kajki serka para Dios pevas tlanavatis inmonavak.” ");
INSERT INTO nsu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne nimechilvia, ke itech neká tonali, intlajyovilis yejonmeh gentejtih yetos okachi temavti ke intlajyovilis in gentejtih de Sodoma. ");
INSERT INTO nsu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ay de imejvah gentejtih de Corazín! ¡Ay de imejvah gentejtih de Betsaida! Porke tla itech altepetl de Tiro iva itech altepetl de Sidón okinmitaskiah in tetzavimeh tlen imejvah yonkimitakeh, ya ke tiempo oyeskia yomoyolkuapkeh. Okonakiskiah intzotzol tlen tetzojtzopiti iva omotlekonexviskiah itech intzonteko para kiteititiskeh ke ayakmo kinekih kichivaskeh tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, imejvah intlajyoviskeh okachi ke in gentejtih de Tiro iva de Sidón. ");
INSERT INTO nsu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iva imejvah tlen de Capernaum, ¿inkiyejyekovah inkiseliskeh tetlakitalistli itech ilvikak? ¡Pues asta miktla imechtlalchitlaliskeh! ");
INSERT INTO nsu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Tlen imechkaki imejvah, kijtosneki Ne nechkaki. Tlen amo imechselia, kijtosneki Ne amo nechselia. Iva tlen amo nechselia, kijtosneki amo kiselia tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tlen expoali ivan majtlaktli momachtijkeh omokuapatoh ika pakilistli, iva okilvijkeh in Jesús: —¡ToTeko, ijkuak in amo kuali ejekameh otikinnavatijkeh ika motoka ma kisakah de intech in gentejtih, in yejvah okiskeh! ");
INSERT INTO nsu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús okinmilvi: —Ne onikittak in Amo Kuali Tlakatl ovetzki de ilvikak kemi se tlatlatzinili. ");
INSERT INTO nsu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ne nimechmaka velitilistli para inpa inmokejketzaskeh in kovameh ivan kolomeh, iva para inkitlaniliskeh in Amo Kuali Tlakatl ika nochi ivelitilis tlen kipia, iva imejvah amitla inmochivaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero amo xipakikah por invelih inkintlaniliah in amo kuali ejekameh, sino xipakikah porke inmotokah yi kajki ijkuilitok itech ilvikak. ");
INSERT INTO nsu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Itech yejón ora in Tioijyotzintli okimakak in Jesús miek pakilistli, iva okijto: —NoTajtzi, nimitzweijkachiva tejwatzi tlen moaxka in ilvikak ivan tlaltikpaktli. Porke otikinmititih ninmeh tlamantih tlen yolyamankeh kemi oyeskia konemeh, iva amo otikinmititih tlen momachiliah kipiah tlamatilistli iva tlen momachiliah kimatih. Kema, noTajtzi, porke ijkó otikmonekilti. ");
INSERT INTO nsu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’NoTajtzi onechmaktili nochi tlamantli. Iva Ne niiKone amika nechixmati, sino san yen noTajtzi nechixmati. Iva amika kixmati noTajtzi, sino san yen Ne niiKone nikixmati. Iva noijki kixmatiskeh tlen akinmeh Ne nikneki ma kixmatikah noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ijkuakó okinmitak in momachtijkeh iva okinmilvi san yejvah inselti: —Ma pakikah tlen kittah nochi tlen imejvah inkittah. ");
INSERT INTO nsu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porke yi wejkavitl miekeh tiotenejmachtijkeh iva in wejwei tlanavatijkeh okinekiah kittaskeh tlen axka imejvah inkittah, pero amo okittakeh. Okinekiah kikakiskeh tlen axka imejvah inkikakih, pero amo okikakkeh. ");
INSERT INTO nsu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Se tlamachti de itlanavatil Moisés okitlajtlani se tlajtoli in Jesús para kittas tlán kijtos. Okitlajtlan: —Tlamachti, ¿tlán moneki nikchivas para nikpias nemilistli para semijkak? ");
INSERT INTO nsu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús okinankili: —¿Tlán kijtova in tlanavatili de Moisés? ¿Kenomi tikajsikamati? ");
INSERT INTO nsu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","In tlamachti de itlanavatil Moisés okijto: —“Xiktlasojtla in moTeko Dios ika nochi moyolo, ika nochi moanima, ika nochi mochikavalis iva ika nochi motlalnamikilis. Iva xiktlasojtla mokni kemi te timotlasojtla.” ");
INSERT INTO nsu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iva Jesús okilvi: —Kuali otitlanankili. Tla ijkó tikchivas tikpias nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero in tlamachti de itlanavatil Moisés okinekia mokavas kuali, iva okilvi in Jesús: —¿Akin nokni? ");
INSERT INTO nsu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ijkuakó Jesús okinankili: —Se tlakatl oyá de Jerusalén para Jericó, iva itech ojtli okitlachtekijkeh sekimeh ichtekeh iva okivikilijkeh nochi tlen okipiaya, asta itzotzol. Kuali okimagakeh asta yi mero okixpolovayah, ompa okajtejkeh iva oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ijkuakó ik ompa opanok se tiopixki itech yejón ojtli. Pero ijkuak okittak, okitlalkavi iva okipanavi. ");
INSERT INTO nsu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noijki se levita tlen tlapalevia kan templo, noijki ik ompa opanok. Iva ijkuak okittak, noijki okitlalkavi iva okipanavi. ");
INSERT INTO nsu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero se tlakatl de Samaria tlen opanovaya itech yejón ojtli, ijkuak okittak, okiknomatki. ");
INSERT INTO nsu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Omotoki inavak, iva okitlalili aseite iva vino kan okikojkojkeh iva okemilili ika tzotzoli. Satepa okitlejkolti ipan iburro, iva okivikak itech se kali kan tekalotiah iva ompa okikuidaro. ");
INSERT INTO nsu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Omostlatik, ijkuak in tlakatl de Samaria yi yavi, okixti ome tomi iva okimakak in tekova de kan tekalotiah, iva okilvi: “Xikuidaro nin tlakatl, iva tla monekis itla okachi, nimitzajxitilijtejko ijkuak nimokopati.” ");
INSERT INTO nsu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Axka techilvi. De yejonmeh eyi tlakah, ¿katli ye omochi kemi ikni de neká tlakatl tlen okitlachtekijkeh? ");
INSERT INTO nsu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","In tlamachti de itlanavatil Moisés okijto: —Yen tlen okiknomatki. Ijkuakó Jesús okilvi: —Xivia iva noijki ijkó xikchiva. ");
INSERT INTO nsu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ivan momachtijkeh oyayah itech ojtli, iva opanokeh itech se altepetl. Ompa se sivatl itoka Marta okinseli itech ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta okipiaya se ikni itoka María. Iva yejón María omotlali ikxitlan Jesús iva okikaktoka nochi tlen Jesús okijtovaya. ");
INSERT INTO nsu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta omotekipachovaya porke okipiaya miek tekitl tlen kichivas, omotoki inavak Jesús iva okilvi: —NoTeko, ¿amo tikitta ke nokni san ne nechkajtevilia nochi in tekitl ma nikchiva? Xikilvi ma nechpalevi. ");
INSERT INTO nsu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús okinankili: —Marta, Marta, sa tlawel timotekipachova iva timotekimiktia ika miek tlamantli. ");
INSERT INTO nsu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero onka san se tlamantli tlen okachi moneki. María yokipejpenki tlen okachi kuali iva amika velis kikixtilis. ");
INSERT INTO nsu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se tonali Jesús omodiostzajtzilijtoka ik sekka, iva ijkuak otlanki omodiostzajtzili, se momachti okilvi: —NoTeko, techmachti kenik timodiostzajtziliskeh, ijkó kemi Juan okinmachti tlen ye okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús okinmilvi: —Ijkuak inmodiostzajtziliskeh xikijtokah: ToTajtzin Dios, tejwatzi tlen tika ilvikak. Nochipa ma kitlakitakah motokatzi. Xivalmuika xitlanavatiki. Ma mochiva tlen tejwatzi tikmonekiltia itech nin tlaltikpaktli, ijkó kemi mochiva kan ilvikak. ");
INSERT INTO nsu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Techmaka momostla in totlakualtzi tlen totech moneki. ");
INSERT INTO nsu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Techtlapojpolvi de nochi totlajtlakol, ijkó kemi tejvah noijki tikintlapojpolviah tlen techtoktiah tlen amo kuali. Amo techtekavili ma tivetzikah ijkuak techyoltilana tlen amo kuali, sino techpalevi para amo ma tivetzikah imak in Amo Kuali Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús noijki okinmilvi: —Tla se de imejvah yavi kittati ivesino kemi tlajko yovak, iva kilvis: “Vesino, techtlaneti eyi pan, ");
INSERT INTO nsu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porke se noyolikni tlen vitz de wejka yikin oajsiko nokalijtik, iva amo nikpia tlán nikmakas ma kimomajsevi.” ");
INSERT INTO nsu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iva tla ivesino kinankilis: “Amo techkuejso. Ya yi tzaktok in puerta, ne ivan nopilvah yotimoteenkeh. Mach velis nimoketzas para nimitzmakati.” ");
INSERT INTO nsu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yi neli nimechilvia, tla okachi chikavak motlatlavtis, ivesino moketzas iva kimakas tlen kinekis, amo porke yi neli ivan movika, sino porke chikavak motlatlavtia. ");
INSERT INTO nsu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Por eso Ne nimechilvia: Xiktlajtlanilikah in Dios tlen imechpolova iva Ye imechmakas. Xiktemokah iva inkajsiskeh. Xitenotzakah kan puerta iva Dios imechtlatlapolis. ");
INSERT INTO nsu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porke tlen itla kitlajtlani, kiselia. Iva tlen itla kitemova, kajsi. Iva tlen tenotza kan puerta, kitlatlapoliah. ");
INSERT INTO nsu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Kox velis tikmakas mokone se tetl ijkuak mitztlajtlanilis se pan? ¿O noso kox velis tikmakas se kovatl ijkuak mitztlajtlanilis se michi? ");
INSERT INTO nsu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O noso kox tikmakas se kolotl ijkuak mitztlajtlanilis se tekuistli? ");
INSERT INTO nsu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tla imejvah tlen amo inkualmeh, inkimatih inkinmakah inmopilvah itla tlen kuali, ¡kenomi inmoTajtzin Dios tlen kajki ilvikak amo ma kinmaka in Tioijyotzintli tlen akinmeh kitlajtlaniliskeh! ");
INSERT INTO nsu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús okixtijtoka se amo kuali ejekatl de ijtik se tlakatl tlen okinoontilijtoka. Iva ijkuak in amo kuali ejekatl okiski, in tlakatl yovelik otlajto. In gentejtih sa otlatlachixkeh ijkuak ijkó okittakeh. ");
INSERT INTO nsu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero sekimeh okijtojkeh: —Nin tlakatl kinkixtia amo kuali ejekameh ika ivelitilis in Beelzebú, tlen tlayakanki de nochtin amo kuali ejekameh. ");
INSERT INTO nsu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oksekimeh, para kiyejyekoskeh, okilvijkeh ma kichiva se tetzavkaneskayotl para kittaskeh kox yi neli Dios okivaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús okimatia tlen yejvah okiyejyekovayah, iva okinmilvi: —Tla in gentejtih de se país pevas momijmiktiskeh san mismo yejvah, yejón país popolivis. Iva tla se familia pevas kimomagaskeh san mismo yejvah, yejón familia mach wejkavas yeskeh san sekka. ");
INSERT INTO nsu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ijkó noijki, tla in Amo Kuali Tlakatl san ye mismo motlajkoxelos, tonses nochi tlen ye kinavatia amo wejkavas. Ijkí nimechilvia porke imejvah inkijtovah ke Ne nikinkixtia amo kuali ejekameh ika ivelitilis in Beelzebú. ");
INSERT INTO nsu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tla yi neli oyeskia Ne nikinkixtia amo kuali ejekameh ika ivelitilis in Beelzebú, tonses, ¿tlen imejvah inkinmachtiah de akin ivelitilis ika kinkixtiah in amo kuali ejekameh? Yejvah innevia kiteititiah nik mach yompa tlen imejvah inkijtovah. ");
INSERT INTO nsu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero tla Dios nechmaka ivelitilis para ma nikinkixti amo kuali ejekameh, tonses kijtosneki ke itlanavatijkayo in Dios yoejkok inmonavak para tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ijkuak se tlakatl tlen chikavak kikuidarova ikalijtik ika nochi iteposvah, nochi tlen kipia kuali tlaatitok. ");
INSERT INTO nsu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tla ivan mokitzkis íkka oksé tlen okachi chikavak ke ye iva kitlanilis, tonses kinkixtilis iteposvah tlen ika mopalevia, iva nochi tlen kikixtilis kixejxelos. ");
INSERT INTO nsu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Tlen amo kajki nova, kajki kontra Ne. Iva tlen amo nechpalevia para kinnotzas oksekimeh para ma nechseguirokah, kijtosneki san kinchochololtia. ");
INSERT INTO nsu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ijkuak se amo kuali ejekatl kisa de ijtik se tlakatl, nemi kan tlavaki kitemojtinemi kan mosevis. Iva ijkuak amo kajsi, kijtova: “Nimokuapas oksemi ijtik neká tlakatl de kan onikiski.” ");
INSERT INTO nsu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iva ijkuak mokuapa, konajsi in tlakatl kemi se kali kan yotlachpankeh iva yi tlayektlalitok. ");
INSERT INTO nsu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ijkuakó yavi kinnotzati oksekimeh chikome amo kuali ejekameh tlen okachi fierotikeh, iva nochtin yavih mochantitivih ijtik yejón tlakatl, iva satepa in tlakatl asta okachi mochiva iva amo kemin achto. ");
INSERT INTO nsu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mientras Jesús ijkó otlapojtoka, ijkuakó se sivatl okijto chikavak de intzala in gentejtih: —Ma paki in sivatl tlen omitztlakatili iva omitzchichiti. ");
INSERT INTO nsu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iva Jesús okijto: —Okachi kuali ma pakikah tlen kikakih iva kichivah tlen kijtova itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","In gentejtih ope mololovah okachi inavak Jesús, iva Ye ope kinmilvia: —In gentejtih de nin tiempo sa tlawel amo kuali inyelis, kinekih ma nikinmititi se tetzavkaneskayotl para nechneltokaskeh. Pero san yen tlen itech omochi in tiotenejmachti Jonás, san yen yejón tetzavkaneskayotl nikinmakas. ");
INSERT INTO nsu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tlen okipanok in Jonás oyá kemi se tetzavkaneskayotl para in gentejtih de Nínive nik Dios okititlanki innavak. Ijkó noijki, tlen kipanos iKone in Tlakatl yetos kemi se prueba nik Dios okivaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, in reina tlen ovala de wejka de ik tlatzintla moketzas iva imechteilvis para Dios ma imechtlajyovilti. Ye ovala de wejka para kikakis in wei tlanavati Salomón tlen otlamachtiaya ika tlamatilistli, iva Ne okachi niweititok iva amo kemi Salomón. ");
INSERT INTO nsu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Itech neká tonali ijkuak Dios kijtos akin tlajtlakole iva akin amo, tlen de Nínive noijki moketzaskeh iva imechteilviskeh para Dios ma imechtlajyovilti. Porke yejvah omoyolkuapkeh ijkuak okintlapovi in Jonás, iva Ne okachi niweititok iva amo kemi Jonás. ");
INSERT INTO nsu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Amika kixotlaltia se tlavili para kitlaatis, o noso para kitlalis itlampa se kajo, sino se kitlalia tlakpak, para ma kintlavili nochtin tlen kalakih kalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Inmoixtololovah kateh kemi oyeskia se tlavili tlen kitlavilia inmokuerpo. Tla inmoixtololovah kualmeh, nochi inmokuerpo kipias tlavili. Pero tla inmoixtololovah amo kualmeh, kijtosneki nochi inmokuerpo kajki kan tlayovalotl. ");
INSERT INTO nsu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ijkó pues, tla imejvah inkiyejyekovah inkipiah tlavili, xikpiakah kuidado amo san kichiva yej tlayovalotl inkipiah. ");
INSERT INTO nsu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tla nochi inmokuerpo kipia tlavili, iva nion se parte amo kajki kan tlayova, tonses inmonemilis tentos de tlavili, ijkó kemi ijkuak se tlavili imechtlavilia. ");
INSERT INTO nsu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ijkuak Jesús otlanki otlapo, ijkuakó se fariseo okilvi ma tlakuati ikalijtik. Jesús okalakki ikalijtik in fariseo iva omotlali kan mesa. ");
INSERT INTO nsu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","In fariseo sa otlatlachixki ijkuak okittak ke Jesús amo omomajteki para tlakuas kemi okatka inkostumbre in fariseos. ");
INSERT INTO nsu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iva Jesús okilvi: —Imejvah infariseos inmochipavah san panixko, pero ik inmoijtik imejvah intentokeh de tlen amo kuali iva de ichtekayotl. ");
INSERT INTO nsu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Seppa amo intlayekkakeh! Dios okichi tlen kajki panixko iva noijki tlen kajki tlatlaijtik. ");
INSERT INTO nsu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Imejvah para velis inyeskeh yi neli inchipavakeh, moneki xikinpalevikah tlen prowestih ika tlen inkipiah. ");
INSERT INTO nsu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ay de imejvah infariseos! Imejvah inkitemakah inmodiezmo de menta, de ruda iva de nochi tlamantli xivitl tlen mokua. Pero amo inkitechiviliah tlen kuali iva amo inkitlasojtlah in Dios. Moneki indiezmaroskeh, pero noijki moneki xiktlasojtlakah in Dios iva xiktechivilikah tlen kuali. ");
INSERT INTO nsu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ay de imejvah infariseos! Porke kan tiotlamachtijkaltih, imejvah inkivelitah inmotlaliskeh kan motlaliah tlen tlayakankeh, iva inkinekih ma imechyektlajpalokah ijkuak innemih tiankistli. ");
INSERT INTO nsu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ay de imejvah infariseos iva imejvah intlamachtijkeh de itlanavatil Moisés, inkipiah ome inmoixko! Imejvah inkateh kemi mikatekochtih tlen amo mottah, in gentejtih ipan panovah iva amo kimatih kox tlafiero nik tlatlaijtik. ");
INSERT INTO nsu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ijkuakó otlanankili se tlamachti de itlanavatil Moisés, okilvi: —Tlamachti, ijkuak ijkó tikijtova, tejvah noijki techpijpinatia. ");
INSERT INTO nsu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús okijto: —¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés! Imejvah inkintlamamaltiah in gentejtih ika tlamamali tlen etik, pero imejvah amo inkinekih inkoliniskeh nion se inmomajpil para inkajkuanaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ay de imejvah, tlen inkinchijchivah tlaixneskayomeh kan toktokeh in tiotenejmachtijkeh tlen yi wejkavitl inmokojkolvah okinmiktijkeh! ");
INSERT INTO nsu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ijkó imejvah inkiteititiah ke inkateh de akuerdo de tlen yejvah okichijkeh. Yejvah okinmiktijkeh in tiotenejmachtijkeh, iva imejvah inkinchijchivah tlaixneskayomeh kan toktokeh. ");
INSERT INTO nsu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Por eso, Dios ika itlamatilis okijto: “Nimechintitlanilis tiotenejmachtijkeh iva tiotlatitlaniltih. Sekimeh de yejvah kinmiktiskeh iva oksekimeh kinchochololtiskeh.” ");
INSERT INTO nsu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dios imechtlajtlanilis kuenta imejvah tlen axka inkateh de inmikilis de nochtin tiotenejmachtijkeh tlen okinmiktijkeh desde ijkuak ope in tlaltikpaktli, ");
INSERT INTO nsu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde ijkuak okimiktijkeh in Abel iva asta ijkuak okimiktijkeh in Zacarías, tlen okimiktijkeh entre kan kajki in templo iva kan kajki in artal de sacrificios. Yi neli nimechilvia, Dios imechtlajtlanilis kuenta imejvah tlen axka inkateh de yejvah inmikilis. ");
INSERT INTO nsu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ay de imejvah intlamachtijkeh de itlanavatil Moisés! Porke imejvah amo inkinkaviliah in gentejtih ma kajsikah in ojtli para velis kixmatiskeh in Dios. Nion imejvah amo inkixmatih Dios, iva tlen kinekih kixmatiskeh imejvah amo inkinkaviliah ma kixmatikah. ");
INSERT INTO nsu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ijkuak Jesús okinmilvi nin tlajtoli, in tlamachtijkeh de itlanavatil Moisés ivan fariseos sa tlawel okualankeh, ope kitlajtoltemoliah okitlatlajtlaniayah de miek tlamantli. ");
INSERT INTO nsu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Okitemovayah ken kitoktiskeh para ma kijto itla tlamantli tlen amijtok para ijkó velis kiteilviskeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Satepa miekeh gentejtih ope mololovah, okatkah sa tlawel miekeh asta sa omotojtopevayah sa mismo yejvah. Jesús achto ope kinmilvia in momachtijkeh: —Xikpiakah kuidado de inxokotix in fariseos, kijtosneki kipiah ome inmixko. ");
INSERT INTO nsu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porke nochi tlen tlaatitok kipia de paninesis, iva nochi tlen amo momati kipia de momatis. ");
INSERT INTO nsu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Por eso, nochi tlen imejvah inkijtoskeh kan tlayova, mokakis kan tlanestok. Iva tlen inkijtoskeh ichtaka, kipia de kimatiskeh nochtin. ");
INSERT INTO nsu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Imejvah tlen noyoliknivah nimechilvia, amo xikinmavilikah tlen velis kimiktiskeh inmokuerpo, pero satepa mach ok itla velis imechtoktiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne nimechilvis akin moneki inkimaviliskeh: xikmavilikah yen Dios, porke Ye amo san velis imechixpolos, sino noijki velis imechtitlanis miktla. Yen moneki xikmavilikah. ");
INSERT INTO nsu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Amo monemakah makuili tototzitzintih por ome tomintzitzintih? Pero maski amo okachi itla inpati, Dios amo kilkava nion se tototzi. ");
INSERT INTO nsu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Iva Dios kimati asta keski inmotzonkal inkipiah. Amo ximomavtikah. Imejvah okachi inmopati ke miekeh tototzitzintih. ");
INSERT INTO nsu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ne nimechilvia ke tla íkka nechneltoka iva tlajtos kuali de Ne teixpa, iKone in Tlakatl noijki tlajtos kuali de ye inmixpa iilvikaktlatitlanilvah in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero tlen kijtos teixpa ke amo nechixmati, noijki inmixpan iilvikaktlatitlanilvah in Dios nikijtos ke amo nikixmati. ");
INSERT INTO nsu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Iva tlen tlajtos en kontra de iKone in Tlakatl, Dios velis kitlapojpolvis. Pero tlen tlajtos amo kuali de yen Tioijyotzintli, Dios amo kitlapojpolvis. ");
INSERT INTO nsu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ijkuak imechvikaskeh kan tiotlamachtijkaltih, o noso innavak juesmeh, o noso innavak tekivajkeh, amo ximotekipachokah por kenik intlanankiliskeh o noso tlán inkijtoskeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porke in Tioijyotzintli imechilvis tlen moneki inkijtoskeh ijkuak ajsis ora. ");
INSERT INTO nsu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Se tlen ompa okatka de kan nochtin yejonmeh gentejtih, okilvi in Jesús: —Tlamachti, xikilvi nokni ma nechmaka in erensia tlen nechtokarova. ");
INSERT INTO nsu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iva Jesús okilvi: —Tlakatl, ¿akin onechtlali Ne kemi nijues o noso kemi nitlaxelo? ");
INSERT INTO nsu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iva okinmilvi nochtin: —Xikpiakah kuidado amo xitlaixnekikah. Amo por se kipias miek tlamantli, velis se yolitos wejkavitl iva ika pakilistli. ");
INSERT INTO nsu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Noijki okinmilvi se ejemplo: —Okatka se tlakatl tomine, tlen itlala sa tlawel otlamochi iva opixkak miek. ");
INSERT INTO nsu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iva okiyejyeko: “¿Tlán nikchivas? Mach nikpia kan niktlaatis nochi tlen nikpixkas.” ");
INSERT INTO nsu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iva okijto: “Yi nikmati tlán nikchivas. Nikinxixinis nosinkalvah iva nikinchivas okachi wejweih. Ompa niktlaatis nochi tlen nikpixkas iva nochi tlen nikpia. ");
INSERT INTO nsu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Satepa nikijtos: Nikpia tlaatitok miek tlen noaxka para miek xivitl, ma nimosevi, ma nitlakua, ma natli, iva ma nimopakti.” ");
INSERT INTO nsu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios okilvi: “¡Tzontetl! Nin yovak timikis, iva tlen yotiktlaati, ¿akin kimokavis?” ");
INSERT INTO nsu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ijkó mochivah in gentejtih tlen kololovah miek tlamantli san para yejvah, pero inavak Dios amitla kipiah. ");
INSERT INTO nsu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Satepa Jesús okinmilvi in momachtijkeh: —Amo ximotekipachokah por tlán inkikuaskeh, iva por tlán inkonakiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Inmonemilis okachi ipati ke tlen inkikuah, iva imokuerpo okachi ipati ke tlen inkonakiah. ");
INSERT INTO nsu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xikinmitakah in kakalomeh, amo tookah, amo pixkah, amo kipiah kan motlatlaatiliskeh iva nion amo kipiah insinkal. Pero Dios kintlamaka. Iva imejvah okachi inmopati iva amo kemi totomeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tla íkka de imejvah sa tlawel motekipachova porke kineki moskaltis ok tlajko metro, ¿kox velis moskaltis? ");
INSERT INTO nsu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tla amo invelih inkichivah se tlamantli tzikitzi, ¿tleka inmotekipachovah itech okseki tlamantli? ");
INSERT INTO nsu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Xikinmitakah kenik moskaltiah in xochimeh, amo tekipanovah iva nion amo tlajtzomah. Pero Ne nimechilvia ke nion wei tlanavati Salomón, ika nochi itominkayo, amo keman omotlakenti kualtzi kemi se de ninmeh xochimeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iva tla Dios ijkó kitzotzoltia in xivitl, tlen axka kajki tlala iva mostla viptla kichichinoskeh ijtik tlitl, ¿kenik amo ma imechtzotzolti imejvah? ¡Seppa tzikitzi inmotlaneltokalis! ");
INSERT INTO nsu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tonses, amo ximotekipachokah por tlán inkikuaskeh o noso tlán inkoniskeh, iva amo san ye xikyejyekojtokah. ");
INSERT INTO nsu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","In gentejtih tlen amo kixmatih Dios kitemovah nochi yejón tlamantli. Pero imejvah inkipiah inmoTajtzin Dios tlen yi kimati tlán imechpolova. ");
INSERT INTO nsu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Okachi kuali xikyekixmatikah inmoDios kemi san Ye tlanavati, iva ijkó Dios imechmakas nochi tlen imechpolova. ");
INSERT INTO nsu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Amo ximomavtikah, imejvah maski amo inmiekeh innochkavah, inmoTajtzin Dios kipia pakilistli para imechtlalis xitlanavatikah noijki kan Ye tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xiknemakakah tlen inkipiah, iva in tomi xikinmakakah tlen prowestih. Yejón kemi oyeskia inkitlaliah tlen kipia miek ipati ijtik bolsajtih tlen amo keman tlajtlamih. Yejón tlen kipia miek ipati amo keman tlamis itech ilvikak, kan amo velis kalakis íkka ichtekki iva nion kan amo velis tlakuakualos. ");
INSERT INTO nsu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kan yetos tlen imejvah inkittah kipia miek ipati, ompa yetos noijki inmoyolo. ");
INSERT INTO nsu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Sa xietokah listos, sa xitzotzolejtokah iva sa xikpixtokah inmokandil ma xotlato. ");
INSERT INTO nsu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xiekah kemi sekimeh tlakevaltih tlen inteko oyá kan monamiktiah iva kichixtokeh ma mokopati, para san nima kitlatlapoliskeh ijkuak vitz iva kivijvitekis in puerta. ");
INSERT INTO nsu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma pakikah in tlakevaltih tla inteko kinmajsikih ijsatokeh ijkuak ye mokopati. Yi neli nimechilvia, ke inevia inteko kintlalis ma motlalikah kan mesa iva kintlamakas. ");
INSERT INTO nsu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maski ma mokopati kemi tlajko yovak o noso yi tlanestivitz, iva tla kinmajsikih ijsatokeh, ma pakikah yejonmeh tlakevaltih. ");
INSERT INTO nsu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Xikmatikah pues, tla se chane okimatiskia tlan ora vitz in ichtekki, oijsatoskia iva amo okikaviliskia ma kalaki ikalijtik para kitlachtekis. ");
INSERT INTO nsu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Imejvah noijki ximonejmachtijtokah, porke ijkuak imejvah amo inkiyejyekojtoskeh, ijkuakó valmuikas iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ijkuakó Pedro okitlajtlani: —NoTeko, ¿yejón ejemplo otikijto san para tejvah, o noso para nochtin? ");
INSERT INTO nsu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","In toTeko okijto: —¿Akin tlakevali tlen kichiva in tekitl kemi oyeskia iaxka iva itech se motenmachia? Kijtosneki yen tlen kitlalia iteko ma kinmitili tlen oksekimeh itlakevalvah, iva ma kintlamakah a tiempo. ");
INSERT INTO nsu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma paki in tlakevali tla iteko kajsiki kichijtok tlen okinavati. ");
INSERT INTO nsu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yi neli nimechilvia, ke iteko kitlalis yejón itlakeval ma kitili nochi tlen iaxka. ");
INSERT INTO nsu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero tla itlakeval kiyejyekos ke iteko wejkavas para mokopati, iva pevas kinmagas maitl tlen oksekimeh tlakevaltih tlakah ivan sivameh, iva pevas motlakualtis, iva konis asta motlavantis, ");
INSERT INTO nsu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ijkuakó iteko mokopati ijkuak ye amo kichia, iva itech se ora tlen amo kimati. Sa tlawel kitlajyoviltis iva kititlanis ma yeto kan yeskeh tlen amo tlavelkakih. ");
INSERT INTO nsu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’In tlakevali tlen yi kimati tlán kineki iteko ma kichiva, iva amo moyektlalia iva nion amo kichiva tlen iteko kineki, sa tlawel kivitekiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero in tlakevali tlen amo kimati tlán kineki iteko ma kichiva, iva okichi itla tlen amijtok, kivitekiskeh pero amo sa tlawel. Tlen okimakakeh miek, noijki kitlajtlaniliskeh miek. Iva tlen okimotenmachijkeh miek, noijki okachi miek kitlajtlaniliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ne onivala onikxotlaltiko se tlitl itech nin tlaltikpaktli, iva oniknekiskia ma yi xotlato. ");
INSERT INTO nsu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero achto moneki nipanos itech se tlajyovilistli sa tlawel ovijtitok, iva nipanotok miek neyolkokoli asta ma ajsiki yejón ora. ");
INSERT INTO nsu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Inkiyejyekovah imejvah ke onivala onikchivako ma yeto yolsevilistli itech nin tlaltikpaktli? Amo, sino in gentejtih moxexeloskeh por Ne. ");
INSERT INTO nsu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Porke de nika para tlayakapa, itech se familia de makuiltih, eyih yeskeh kontra omeh ivan omeh yeskeh kontra eyih. ");
INSERT INTO nsu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","In teta kixnamikis ipiltzi iva ipiltzi kixnamikis ipapa. In teena kixnamikis ichpoch iva ichpoch kixnamikis imama. In temonna kixnamikis imo iva imo kixnamikis imonna. ");
INSERT INTO nsu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús noijki okinmilvi in gentejtih: —Ijkuak imejvah inkittah motlalia in mixtli kan onpolivi in tonali, imejvah inkijtovah nik kiavis, iva ijkó tlamochiva. ");
INSERT INTO nsu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iva ijkuak in ejekatl vitz ik tlani, imejvah inkijtovah nik tonas, iva ijkó tlamochiva. ");
INSERT INTO nsu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Imejvah inkipiah ome inmoixko! Imejvah ijkuak inkittah in ilvikak ivan tlaltikpaktli kuali inkimomakah kuenta kox yetos kuali tiempo o noso amo. Tonses, ¿kenik amo inkimomakah kuenta tlán tlamochijtok itech nin tiempo? ");
INSERT INTO nsu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Imejvah mismo omonekia inkimatiskeh katli yen kuali para yen yejón xikchivakah. ");
INSERT INTO nsu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tla se tlakatl mitzteilvia de itla innavak tekivajkeh, moneki achto iva ximoyektlali antes de mitztemaktiti imak in jues. Porke tlamo, in jues kinavatis in mayol ma mitztzakua telpiloya. ");
INSERT INTO nsu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yi neli nimitzilvia, ke amo tikisas de ompa telpiloya asta kan amo xiktlaxtlava nochi in tomi tlen mitztlajtlaniliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Itech nekateh tonaltih, sekimeh tlakah okilvijkeh in Jesús ke Pilato okinmikti sekimeh tlakah de Galilea ijkuak yejvah okimaktilijtokah in toYejwatzi sekimeh yolkatlamiktiltih. ");
INSERT INTO nsu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iva Jesús okinmilvi: —¿Inkiyejyekovah imejvah ke yejonmeh tlen omikkeh okatkah okachi tlajtlakolejkeh ke tlen oksekimeh gentejtih de Galilea? ");
INSERT INTO nsu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ne nimechilvia ke amo. Iva tla imejvah amo inmoyolkuapah, noijki velis inmikiskeh kemi yejvah. ");
INSERT INTO nsu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O noso inkineltokah imejvah ke nekateh kaxtoli ivan eyi tlakah tlen omikkeh ijkuak in torre de Siloé inpa ovetzki, okatkah okachi tlajtlakolejkeh ke tlen oksekimeh tlen chantih Jerusalén? ");
INSERT INTO nsu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ne nimechilvia ke amo. Iva tla imejvah amo inmoyolkuapah, noijki velis inmikiskeh kemi yejvah. ");
INSERT INTO nsu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús noijki okinmilvi nin ejemplo: —Se tlakatl okipiaya se igoskuavitl okatka kan uvajyo. Se tonali oyá okittato kox yotlaki, pero amitla itlakiloyo okajsik. ");
INSERT INTO nsu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ijkuakó okilvi in tlakatl tlen kikuidarova nochi in uvajyo: “Yi kipia eyi xivitl nikvaliita nin igoskuavitl xamo kipia itla itlakilo, iva amo keman itla nikajsi. Xiktzonteki, ¿tlán para san kinejnektok in tlali iva amo tlaki?” ");
INSERT INTO nsu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero in tlakatl tlen tlakuidarova okinankili: “Noteko, ok xikava nin xivitl. Niktlalyamanis iva niktlalilis abono. ");
INSERT INTO nsu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xamo tlakis. Iva tla amo tlakis, ijkuakó kema velis titlanavatis ma kitzontekikah.” ");
INSERT INTO nsu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Se sábado, Jesús otlamachtijtoka itech se tiotlamachtijkali. ");
INSERT INTO nsu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iva ompa okatka se sivatl tlen yokipiaya kaxtoli ivan eyi xivitl de omokokovaya. Se amo kuali ejekatl okitokti ma kuitlapantomotzivi iva amo ovelia omokuitlapanmelavaya. ");
INSERT INTO nsu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ijkuak Jesús okittak, okinotzki iva okilvi: —Sivatl, axka yotipajtik de mokokolis. ");
INSERT INTO nsu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús okintlali imavah ipan yejón sivatl, iva san nima ijkuakó okuitlapanmelavik, iva ope kiweijkachiva in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero in tlayakanki de kan tiotlamachtijkali okualanki porke Jesús okipajti in sivatl ijkuak sábado, iva okinmilvi in gentejtih tlen ompa okatkah: —Onka chikuase tonali para se tekipanos. Itech yejonmeh tonaltih xivikikah para ximopajtikah, iva amo ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","In toTeko okinankili: —¡Imejvah inkipiah ome inmoixko! ¿Amo inkitotomah inmotoro o noso inmoburro ijkuak sábado iva inyavih inkatlititivih? ");
INSERT INTO nsu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iva nin sivatl tlen valajtok familia de Abraham, iva tlen Amo Kuali Tlakatl okilpijtoka ika nin kokolistli yi kaxtoli ivan eyi xivitl, ¿amo omonekia noijki se kitotomas de ikokolis ijkuak sábado? ");
INSERT INTO nsu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ijkuak Jesús ijkó okijto, nochtin tlen kitlavelitah sa tlawel omopinatijkeh. Pero nochtin tlen oksekimeh gentejtih opakiah porke okittayah ke Jesús okinchivaya wejwei tlamantih. ");
INSERT INTO nsu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús noijki okijto: —¿Kenik velis nimechilvis para xikajsikamatikah kenomi nik kajki kan Dios tlanavatia? ¿Tlán ika velis nikparejaros? ");
INSERT INTO nsu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yejón kemi oyeskia se semiyajtzi de mostaza. Ijkuak se tlakatl kitooka itlala, kisa iva moskaltia iva motlami se wei kuavitl, iva asta itech motepajsoltiah in totomeh itech imamayovah. ");
INSERT INTO nsu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús noijki okijto: —¿Tlán ika velis nikparejaros para velis nimechilvis kenomi nik kajki kan Dios tlanavatia? ");
INSERT INTO nsu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yejón kemi ijkuak se sivatl kinelova eyi tlatamachivali de arina iva kitlalilia se tzikitzi xokotixtli, iva yejón xokotixtli kisamava nochi in tixtli. ");
INSERT INTO nsu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ijkuak Jesús oyaya para Jerusalén, opanotiaya itech altepemeh iva itech rancherías otlamachtijtiaya. ");
INSERT INTO nsu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iva se tlakatl okitlajtlani: —NoTeko, ¿amo miekeh tlen momakixtiskeh? Jesús otlanankili: ");
INSERT INTO nsu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Xikchivakah de xikalakikah kan puerta tlen pitzavak. Ne nimechilvia, ke miekeh kinekiskeh kalakiskeh, pero amo veliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yetos kemi se chane tlen moketzas iva kitzakuas in puerta. Iva tla imejvah inyeskeh kiavak, inkivijvitekiskeh in puerta iva inkijtoskeh: “ToTeko, techtlatlapoli.” Pero ye imechnankilis: “Mach nimechixmati akinmeh imejvah, nion amo nikmati de kan invitzeh.” ");
INSERT INTO nsu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ijkuakó imejvah pevas inkijtoskeh: “Tejvah otitlakuajkeh iva otikonikeh mova, iva tejwatzi otitlamachti itech ojmeh de toaltepe.” ");
INSERT INTO nsu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero ye imechnankilis: “Yonimechilvi nik mach nimechixmati. Ximachivakah de Ne innochtin imejvah tlen inkichivah tlen amo kuali.” ");
INSERT INTO nsu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Imejvah inkittaskeh in Abraham, Isaac, Jacob iva nochtin tiotenejmachtijkeh yetoskeh kan Dios tlanavatia. Pero imejvah Dios imechkavas kan kiavak, ompa inchokaskeh iva inmotlantekiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porke vitzeh gentejtih de ik najko, de ik tlani, de kan valkisa in tonali iva de kan onpolivi tonali, para motlaliskeh tlakuaskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iva sekimeh tlen axka kateh asta sa ik tlami satepa yejvah yeskeh achto, iva tlen axka kateh achto satepa yeskeh asta asta sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ijkuakó oajsikoh sekimeh fariseos iva okilvijkeh in Jesús: —Xivia, porke Herodes kineki mitzixpolos. ");
INSERT INTO nsu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero Jesús okinnankili: —Xiviah xikilvitih yejón astotl: “Axka ivan mostla ok nikinkixtijtos amo kuali ejekameh de itech in gentejtih iva ok nikinpajtijtos in kokoxkeh, iva asta ipan eyi tonali nitlamis.” ");
INSERT INTO nsu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero axka, mostla ivan viptla kipia de nikseguiros noojvi asta Jerusalén. De por sí ompa Jerusalén kan kinmiktiah in tiotenejmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén, Jerusalén, te tikinmiktia in tiotenejmachtijkeh, iva tikinmaga ika tetl tlen Dios kivalintitlani monavak! ¡Miek welta oniknekia nikinmololos mopilvah, kemi se poyojtena kinmololova ikonevah itlampa iajasvah, pero amo otikneki! ");
INSERT INTO nsu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xikitta pues, axka mokalijtik mokavas sa tlaijki. Iva nimitzilvia, ke ayakmo kema techitas asta ma ajsiki neká tonali ijkuak tikijtos: “Ma Dios kitiochiva tlen vitz ika itoka in toTeko.” ");
INSERT INTO nsu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Se sábado, Jesús oyá otlakuato kan ikalijtik se tlayakanki fariseo, iva tlen oksekimeh tlen ompa okatkah sa okistlakojtokah in Jesús para kittaskeh tlán kichivas. ");
INSERT INTO nsu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iva ompa okatka iyakapan Jesús se tlakatl tlen otejtenki. ");
INSERT INTO nsu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ijkuakó Jesús okintlajtlani in tlamachtijkeh de itlanavatil Moisés ivan fariseos: —¿Kox techkavilia in tlanavatili ma tikpajtikah se kokoxki ijkuak sábado o noso amo? ");
INSERT INTO nsu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero yejvah amitla okijtojkeh. Ijkuakó Jesús okimakitzki in kokoxki iva okipajti, iva okilvi ma via. ");
INSERT INTO nsu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iva Jesús okintlajtlani tlen ompa okatkah: —¿Akin de imejvah amo kikixtis iburro o noso itoro tla ovetzito kan tlakuyo maski ma yeto sábado? ");
INSERT INTO nsu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero yejvah amitla ovelik okinankilijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús okinmitak tlen okinminvitarojkeh kan monamiktiah, okitemovayah kan okachi kuali lugar para ompa motlaliskeh tlakuaskeh. Jesús okintlapovi ika se ejemplo, okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ijkuak íkka mitzinvitaros itech se ilvitl kan monamiktiah, amo ximotlali kan okachi tlayakapa, porke velis vitz oksé tlen noijki okinvitarojkeh tlen okachi weititok iva amo kemi te. ");
INSERT INTO nsu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Iva tlen omitzinvitaro, velis mitzilvis: “Xikkavili nin tlakatl ma motlali kan tietok.” Ijkuakó te sa tivalixpinavas iva tias timotlaliti asta tlakuitlapa. ");
INSERT INTO nsu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Okachi kuali, ijkuak mitzinvitaroskeh, ximotlali asta tlakuitlapa. Iva ijkuak mitzitas tlen omitzinvitaro, mitzilvis: “Noknitzi, ximotlali nika kan okachi tlayakapa.” Iva ijkó velis mitzyektlakitaskeh tlen ompa invah timotlalis. ");
INSERT INTO nsu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porke tlen momachilis okachi weititok, satepa kitlalchitlaliskeh. Pero tlen motlalchitlalis, satepa kiweijkatlaliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús noijki okilvi in tlakatl tlen okinvitaro: —Ijkuak tiknekis tiktemakas se tlaxkali tlajka o noso yovak, amo xikinminvitaro moyoliknivah, nion moknivah, nion tlen itla tikinmita, iva nion movesinojvah tlen rikojtih. Porke yejvah velis noijki mitzinvitaroskeh, iva ijkó yejvah momakopaskeh mova. ");
INSERT INTO nsu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Okachi kuali, ijkuak tiilvichivas, xikinminvitaro in prowestih, in vilantzitzintih, in koxomeh iva tlen amo tlachiah. ");
INSERT INTO nsu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iva ijkó tikpias pakilistli. Porke yejvah amo velis momakopaskeh mova, pero Dios mitzmakas motlaxtlavil ijkuak moyolitiskeh tlen tlakamelajkeh. ");
INSERT INTO nsu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Se tlakatl tlen oyetoka kan mesa ijkuak ijkó okikakki, okilvi in Jesús: —Ma paki tlen tlakuas kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús okilvi: —Se tlakatl okitemakak se wei tiotlakantlakuali, iva otlanavati ma kinminvitarokah miekeh. ");
INSERT INTO nsu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iva ijkuak oajsik ora para tlakuaskeh, okititlanki se itlakeval ma kinmilviti tlen okinminvitaro: “Xivikikah, porke nochi yi kajki listo.” ");
INSERT INTO nsu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero nochtin ope kijtovah ma kintlapojpolvikah porke amo velis yaskeh. Achto se okijto: “Yikin oniko se tlali, iva nikneki nias nikittati. Techtlapojpolvi, amo velis nias.” ");
INSERT INTO nsu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Oksé okijto: “Onikinkoh makuili yunta in torojtih, iva niav nikinyejyekotih. Techtlapojpolvi, amo velis nias.” ");
INSERT INTO nsu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iva oksé okijto: “Yikin onimonamikti, iva por eso amo velis nias.” ");
INSERT INTO nsu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ijkuak in tlakevali omokopato, okimatilti iteko nochi tlen okilvijkeh. Tonses, iteko okualanki iva okilvi itlakeval: “Xivia totoka kan tiankistih iva itech ojpitzaktih de kan altepetl, iva nika xikinvalika in prowestih, in vilantzitzintih, in koxomeh iva tlen amo tlachiah.” ");
INSERT INTO nsu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ijkuak itlakeval omokopato, okijto: “Noteko, yonikchi kemi otechnavati, iva ok onka miek lugar.” ");
INSERT INTO nsu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tos in tekova okilvi itlakeval: “Xivia itech ojmeh iva itech ojpitzaktih, iva xikinchikavili ma kalakikah para ma temi nokalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iva nikneki nimechilvis ke nion se de nekateh tlen achto onikinminvitaro amo tlakuaskeh itech notiotlakantlakual.” ");
INSERT INTO nsu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miekeh gentejtih oyayah ivan Jesús. Ye omokuapki iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tla íkka kineki vitz nova para yetos momachti de Ne, moneki nechtlasojtlas okachi ke ipapa, imama, itonana, ipilvah, iknivah iva iveltivah. Tlen kineki yetos momachti de Ne kipia de nechtlasojtlas okachi ke inemilis. ");
INSERT INTO nsu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tlen amo kinekis tlajyovis nion amo kinekis mikis itech krus, amo velis yetos momachti de Ne. ");
INSERT INTO nsu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tla íkka de imejvah kineki kichivas se kali wejkapa, ¿amo achto motlalis kichivas kuenta para kiyejyekolis kox kajxilis itomi para velis kitlamis? ");
INSERT INTO nsu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Porke tla achto pevas kalchivas iva satepa valtlamis itomi iva ayakmo kitlamis in kali wejkapa, nochtin tlen kittaskeh pevas kipinaviskeh ");
INSERT INTO nsu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","iva kijtoskeh: “Nin tlakatl ope kalchiva, iva amo ovelik okitlami.” ");
INSERT INTO nsu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O noso tla se wei tlanavati kimati nik kipias guerra ivan oksé wei tlanavati, ¿amo achto motlalis kiyejyekolis kox ika majtlaktli mil soldadojtih velis mokitzkis ivan oksé tlen vitz ika senpoali mil soldadojtih? ");
INSERT INTO nsu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iva tla amo velis, ijkuak ok wejka vitz tlen oksé wei tlanavati, kintitlanis sekimeh itlatitlanilvah para ma motlapojpolvikah para ayakmo kimomagaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ijkó pues, tla se de imejvah amo kikava nochi tlen kipia, amo velis yetos momachti de Ne. ");
INSERT INTO nsu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’In istatl sa tlawel kuali, pero tla in istatl ayakmo yetos poyek, ¿kenomi oksé welta poyeyas? ");
INSERT INTO nsu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mach ok kichivas nion para tlali iva nion para abono, sino sa se kitlamotla. Tlen kimati tlakaki, ma kikaki. ");
INSERT INTO nsu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nochtin tlen kobradortih de impuestos iva tlen oksekimeh tlajtlakolejkeh omololojkeh inavak Jesús para kikakiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","In fariseos iva in tlamachtijkeh de itlanavatil Moisés ope tlapovah de Jesús, okijtovayah: —Nin tlakatl invah mosetilia tlen tlajtlakolejkeh, iva invah tlakua. ");
INSERT INTO nsu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ijkuakó Jesús okinmilvi nin ejemplo: ");
INSERT INTO nsu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Tla se de imejvah kipia se siento ichkameh iva tla okipolo se iichka, ¿amo kinkajteva in noventa y nueve ompa tlala, iva yavi kitemoti tlen opolivik asta kan kajsis? ");
INSERT INTO nsu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iva tla yokajsik, kimokechpanoltia ika pakilistli, ");
INSERT INTO nsu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","iva ajsi ikalijtik, kinmololova iyoliknivah iva ivesinojvah iva kinmilvia: “Nova xipakikah, porke yonikajsik nochka tlen onikpolojka.” ");
INSERT INTO nsu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yi neli nimechilvia, ke itech ilvikak noijki onka miek pakilistli ijkuak se tlajtlakole moyolkuapa, ke por noventa y nueve tlakamelajkeh tlen amo moneki moyolkopaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’¿Tlán kichiva se sivatl tla kipia majtlaktli tomi de plata iva kipolova se? ¿Amo kixotlaltia se kandil iva tlachpana yolik ikalijtik asta kan kajsi in tomi? ");
INSERT INTO nsu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iva ijkuak kajsi, kinmololova iyoliknivah sivameh iva ivesinajvah iva kinmilvia: “Nova xipakikah, porke yonikajsik notomi tlen onikpolojka.” ");
INSERT INTO nsu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ijkó noijki nimechilvia, ke iilvikaktlatitlanilvah in Dios pakih miek ijkuak se tlajtlakole moyolkuapa. ");
INSERT INTO nsu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús noijki okijto: —Se tlakatl okinpiaya ome itelpochvah, ");
INSERT INTO nsu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","iva tlen xokoyotl okilvi ipapa: “Papa, techmaka in erensia tlen nechtokarova.” Tonses, in teta okinxexelili nochi tlen okipiaya. ");
INSERT INTO nsu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kana keski tonali satepa, in telpochtli tlen xokoyotl okinemakak nochi tlen okimakak ipapa, iva oyá wejka itech oksé país. Ompa omopakti, iva okichivaya tlen amo kuali, iva nochi san okavilti itomi. ");
INSERT INTO nsu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ijkuak okitlami nochi itomi, ovala se apistli itech neká país, iva ye ayakmo okipiaya tlán kikuas. ");
INSERT INTO nsu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Satepa oyá okitemoto tekitl inavak se tlakatl de yejón país, yejón tlakatl okimakak tekitl iva okititlanki itlala para ma kintlamaka kochijtih. ");
INSERT INTO nsu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","In telpochtli okinekia kikuas maski yen tlen okikuayah in kochijtih, pero amo okimakayah ma kikua. ");
INSERT INTO nsu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ijkuakó ope moyejyekova, iva okijto: “Kan ikalijtik nopapa itlakevalvah kipiah miek tlen kikuaskeh, iva ne nika napismiki. ");
INSERT INTO nsu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nimokuapas inavak nopapa, iva nikilvis: Papa, onitlajtlakolchi inavak Dios iva onitlajtlakolchi monavak. ");
INSERT INTO nsu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ayakmo notech povi technotzas kemi nimokone, techitta sa kemi se de motlakevalvah.” ");
INSERT INTO nsu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ijkuakó omokuapki para kan ikalijtik ipapa. ’Ijkuak ok wejka ovalaya, ipapa okittak iva okiknomatki. Omotlelo okinamikito, okimonapalolti iva okixpipitzo. ");
INSERT INTO nsu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iva itelpoch okilvi: “Papa, onitlajtlakolchi inavak Dios iva onitlajtlakolchi monavak. Ayakmo notech povi technotza kemi nimokone.” ");
INSERT INTO nsu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ipapa okinmilvi itlakevalvah: “Xikvalikilikah totoka tlen okachi kuali tzotzoli, iva xiktzotzoltikah. Xikaniyojtikah itech imajpil iva xikaktikah. ");
INSERT INTO nsu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xikvalikakah in torojkonetl tlen okachi tomavak iva xikmiktikah. Tiilvichivaskeh iva titlakuaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porke nin nokone kemi oyeskia yomikka, iva axka yomoyoliti. Opolika, iva axka yotikajsikeh.” Iva ope kichivah ilvitl. ");
INSERT INTO nsu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Oksé itelpoch tlen tetiachka otekipanojtoka itlala. Ijkuak omokuapato iva ijkuak yovalajsia ikalijtik, okikakki tlapitzah iva mijtotiah. ");
INSERT INTO nsu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ijkuakó okinotzki se tlakevali iva okitlajtlani tlán kichivah ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","In tlakevali okilvi: “Mokni yomokuapato. Iva mopapa otlanavati ma kimiktikah in torojkonetl tlen okachi tomavak, porke mokni kuali oajsiko iva chikavtok.” ");
INSERT INTO nsu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","In telpochtli tlen tetiachka okualanki iva amo okinekia kalakis ikalijtik. In teta okiski iva ope kitlatlavtia ma kalaki. ");
INSERT INTO nsu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero in telpochtli okilvi ipapa: “Tejwatzi kuali tikmati ke yi miek xivitl nitekipanova para tejwatzi, nochipa nikchiva tlan technavatia, iva amo semi techmaka nion se tentzonkonetl para nikchivas se ilvitl invah noyoliknivah. ");
INSERT INTO nsu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero axka yomokuapato nin mokone, tlen san okavilti motomi ivan avilsivameh, iva asta otikmiktili se torojkonetl tlen okachi tomavak.” ");
INSERT INTO nsu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ijkuakó ipapa okilvi: “Nokone, te nochipa nova tika, iva nochi tlen nikpia moaxka. ");
INSERT INTO nsu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero axka moneki tikchivaskeh ilvitl iva ma tipakikah. Porke mokni yomikka, iva axka yomoyoliti. Opolika, iva axka yotikajsikeh.” ");
INSERT INTO nsu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús noijki okinmilvi tlen momachtijkeh: —Okatka se tomine tlen okipiaya se itlakeval tlen okittaya nochi tlen okipiaya. Pero okilvijkeh in tomine ke itlakeval san kaviltia tlen iaxka. ");
INSERT INTO nsu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ijkuakó in tomine okinotzki itlakeval iva okilvi: “¿Kox yi neli tlen nechilviah de te? Techmaka kuenta de nochi notomi iva de nochi tlen nikpia, porke ayakmo techpalevis.” ");
INSERT INTO nsu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ijkuakó itlakeval okimolvi: “¿Axka tlán nikchivas porke noteko nechkixtilis in tekitl? Amo nitlaxikos nitekipanos ika ajsalon, iva nipinava sa nimijtlanis. ");
INSERT INTO nsu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yi nikmati tlán nikchivas para ke ijkuak noteko nechkixtilis notekiv, ne nikinpias akinmeh nechseliskeh inkalijtik.” ");
INSERT INTO nsu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tonses okinnotzki tlen okivikiliayah iteko. Achto se okinotzki iva okilvi: “¿Kech tikvikilia noteko?” ");
INSERT INTO nsu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iva ye okijto: “Nikvikilia se siento barriltih de aseite.” In tlakevali okilvi: “Nika kajki moresibo. Iva en lugar de se siento barriltih, xikmachioti san de tlajko siento.” ");
INSERT INTO nsu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Satepa okitlajtlani oksé tlen noijki okivikiliaya iteko: “Te, ¿kech tikvikilia noteko?” Iva ye okilvi: “Se siento kostal de trigo.” Tonses, in tlakevali okilvi: “Nika kajki moresibo. Iva en lugar de se siento kostal de trigo, xikmachioti san de navi poali kostal.” ");
INSERT INTO nsu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ijkuak iteko okimatki, otlajto kuali de yejón amo kuali tlakevali porke omotlali listo por yen kenik okichi. Porke tlen povih itech nin tlaltikpaktli, entre yejvah okachi motlaliah listos ika tlen kichivah iva amo kemi tlen ipilvah in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ne nimechilvia ke okachi kuali xiknejnekikah in tominkayotl de nin tlaltikpaktli para ika xikintlanikah inmoyoliknivah. Iva ijkuak tlamis inmotominkayo, velis inmechseliskeh kan inchantiskeh para semijkak. ");
INSERT INTO nsu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tlen tenmachtli ika itla tlamantli tzikitzi, noijki tenmachtli ika itla tlamantli tlen miek. Iva tlen amo tenmachtli ika itla tlamantli tzikitzi, noijki amo yetos tenmachtli ika itla tlamantli tlen miek. ");
INSERT INTO nsu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tla imejvah amo intenmachtih por yen kenik inkinejnekih in tominkayotl de nin tlaltikpaktli, Dios amo imechmotenmachis para imechmakas tlen yi neli kipia miek ipati. ");
INSERT INTO nsu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iva tla imejvah amo intenmachtih kemi para imechmaktiliskeh tlen amo inmoaxka, ¿kenik velis inmechmakaskeh tlen yetos inmoaxka? ");
INSERT INTO nsu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Amika tlakevali velis kinpias ome itekovah. Porke velis kitlasojtlas in se iva tlen oksé amo kitlasojtlas, o noso velis kitlakitas in se iva tlen oksé amo kitlakitas. Amo velis intekipanoskeh para Dios iva intekipanoskeh para inkololoskeh tominkayotl. ");
INSERT INTO nsu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","In fariseos tlen okivelitayah tomi, okikaktokah nochi tlen Jesús okijtovaya iva san okiwetzkiliayah. ");
INSERT INTO nsu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ijkuakó Jesús okinmilvi: —Imejvah teixpa inmochivah kemi oyeskia intlakamelajkeh, pero Dios kixmati inmoyolo. Miek tlamantli tlen gentejtih kiweimatih, in Dios kikualankaita. ");
INSERT INTO nsu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’In gentejtih omonekia kichivaskeh tlen kijtovah itlanavatil Moisés iva tlen okijkuilojkeh in tiotenejmachtijkeh, asta ijkuak ovala in Juan tlen tlabautisaro. Iva desde ijkuakó ope motematiltia kenik in Dios tlanavatia, iva nochtin mochijchikavah kinekih ompa kalakiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’In ilvikak ivan tlaltikpaktli nochi popolivis, pero tlen kajki ijkuilitok itech itlanavatil in Dios amo popolivis sino kipia de mochivas asta yen tzikitzi letra tlen kajki ijkuilitok. ");
INSERT INTO nsu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tla se tlakatl kikajkava itonana iva monamiktia ivan oksé sivatl, kijtosneki kichiva imosa. Iva tlen akin monamiktis ivan se sivatl tlen omokajka ivan itotata, kijtosneki kichiva imosa. ");
INSERT INTO nsu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Okatka se tlakatl tomine, omotlakentiaya ika tlakemitl morado tlen kuali iva patío. Momostlatika okichivaya ilvitl ika kuali tlakuali. ");
INSERT INTO nsu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Okatka noijki se tlakatl prowe itoka Lázaro, tlen nochi ikuerpo otentoka de tzotzotl. Iva omotlaliaya ipan tlali ikaltempa in tomine. ");
INSERT INTO nsu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yejón prowe okinekia kikuas itenpayex tlen ovetzia de kan imesa in tomine. Iva asta in itzkuintih omotokiayah okipajpaliliayah itzotzovah. ");
INSERT INTO nsu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Se tonali in prowe oixpolivik, iva in ilvikaktlatitlaniltih okivikakeh inavak Abraham kan ilvikak. Satepa in tlakatl tomine noijki oixpolivik. Okitookakeh ");
INSERT INTO nsu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","iva oyá miktla kan sa tlawel otlajyoviaya. Oajkotlachixki iva okittak de wejka in Abraham, iva okittak noijki in Lázaro ompa okatka inavak. ");
INSERT INTO nsu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ijkuakó in tomine okijto chikavak: “Papa Abraham, techiknomati, iva xiknavati in Lázaro ma kisiava imajpil, iva ma viki ma kiseseliki nonenepil. Porke sa tlawel nitlajyovia ijtik nin tlitl.” ");
INSERT INTO nsu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham okilvi: “Nokone, xikilnamiki ke te otikpixki miek tlamantli kuali ijkuak otikatka ipan tlaltikpaktli, iva Lázaro sa tlawel otlajyovi. Axka ye nika moyolalia, iva te titlajyovia. ");
INSERT INTO nsu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iva onka se tlamantli tlen sa tlawel wejkatla tlen techtlajkoxelojtok. Iva tlen akinmeh kinekiskeh panoskeh de nika para ompa, amo veliskeh, iva tlen akinmeh kinekiskeh valpanoskeh de ompa para nika, noijki amo veliskeh.” ");
INSERT INTO nsu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","In tomine okilvi: “Tonses, nimitztlatlavtia tejwatzi, papa Abraham, xiktitlani in Lázaro kan ikalijtik nopapa, ");
INSERT INTO nsu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kan nikinpia makuiltih noknivah, para ma kinnejmachti, iva ijkó amo ma vikikah yejvah noijki nika itech nin tlajyovilistli.” ");
INSERT INTO nsu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Iva Abraham okinankili: “Yejvah kipiah tlen okijkuilo Moisés iva tlen okijkuilojkeh in tiotenejmachtijkeh. Ma kilerokah iva ma kichivakah tlen kijtova.” ");
INSERT INTO nsu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","In tomine okijto: “Amo, papa Abraham, porke tla íkka tlen yoixpolivik iva moyolitis iva yas kinnejmachtiti, yejvah moyolkuapaskeh.” ");
INSERT INTO nsu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham okilvi: “Tla amo kineltokah tlen okijkuilo Moisés iva tlen okijkuilojkeh in tiotenejmachtijkeh, noijki amo kineltokiliskeh maski ma moyoliti se tlen yoixpolivik.” ");
INSERT INTO nsu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús okinmilvi in momachtijkeh: —Nochipa yetos miek tlamantli tlen kinyoltilanas in gentejtih para ma tlajtlakolchivakah. Pero ¡prowe in tlakatl tlen kitoktis íkka oksé ma vetzi itech tlajtlakoli! ");
INSERT INTO nsu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Okachi kuali ma kilpilikah se metlatl itech ikech iva ma konkajkavakah kan atl tlen wei, ke ijkó ma kitokti ma vetzi itech tlajtlakoli se de ninmeh tzitzintih tlen nechneltokah. ");
INSERT INTO nsu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Xikpiakah kuidado. ’Tla se mokni omitztokti itla tlen amo kuali, xiknotza iva xikajva. Tla mitzkaki iva kineki xiktlapojpolvi, tonses xiktlapojpolvi. ");
INSERT INTO nsu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tla omitztokti tlen amo kuali chikome welta se tonali, iva chikome welta vitz monavak mitzilviki: “Techtlapojpolvi por tlen onimitztokti”, in te xiktlapojpolvi. ");
INSERT INTO nsu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","In tiotlatitlaniltih okilvijkeh in toTeko: —Techmaka okachi tlaneltokalistli. ");
INSERT INTO nsu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","In toTeko okinmilvi: —Tla imejvah onkipiaskiah tlaneltokalistli, maski seppa tzikitzi kemi isemiya in mostaza, onveliskiah onkilviskiah nin kuavitl sicómoro: “Ximovivitla de nika iva ximotooka kan atl tlen wei”, iva in kuavitl omechvelkakiskia. ");
INSERT INTO nsu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tla íkka de imejvah kipia se itlakeval iva tla yomokuapato yotlaxavato o noso yotlajpiato, ¿kox inkilviah: “Xiviki ximotlali xitlakua”? ");
INSERT INTO nsu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Amo, sino inkilviah: “Techchivili tlen nikuas. Xikonaki momandil iva techtlamaka. Ijkuak tlamis nitlakuas iva nikonis, ijkuakó te velis titlakuas noijki.” ");
INSERT INTO nsu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Kox inkitlasojkamachiliah inmotlakeval por kichiva tlen inkinavatiah? Imejvah kuali inkimatih nik amo. ");
INSERT INTO nsu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijkó noijki imejvah, ijkuak intlamiskeh inkichivaskeh nochi tlen Dios imechnavatia, moneki xikijtokah: “Tejvah san titlakevaltih iva amo totech povi para ma techtlasojkamachilikah. Tejvah san otikchijkeh tlen omonekia tikchivaskeh.” ");
INSERT INTO nsu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ijkuak Jesús oyaya para Jerusalén, opanok ik región de Samaria iva de Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ijkuak oajsito itech se altepetzintli, ijkuakó okinamikikoh majtlaktih tlakah tlen opalania innakayo, pero san wejka omoketzkeh ");
INSERT INTO nsu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","iva chikavak okitzajtzilijkeh: —¡Jesús, Tlamachti, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ijkuak Jesús okinmitak, okinmilvi: —Xiviah ximoteitititih innavak in tiopixkeh. Iva ijkuak yoyayah itech ojtli, opajtikeh iva ochipavik innakayo. ");
INSERT INTO nsu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ijkuakó se de yejvah, ijkuak omottak nik yopajtik, ovalmokuapato kiweijkachijtivitz chikavak in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iva omotlankuaketzki ikxitlan Jesús iva omixtlapacho ipan tlali iva omotlasojkamatki inavak. Iva yejón tlakatl okatka de Samaria. ");
INSERT INTO nsu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ijkuakó Jesús okijto: —¿Ke amo majtlaktih tlen opajtikeh? ¿Kanin kateh tlen ok chiknavih? ");
INSERT INTO nsu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿San yen nin tlakatl tlen amo judío ovalmokuapato para kiweijkachivas in Dios? ");
INSERT INTO nsu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iva Jesús okilvi in tlakatl: —Ximoketza iva xivia. Yotipajtik porke otechneltokak. ");
INSERT INTO nsu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","In fariseos okitlajtlanijkeh in Jesús keman pevas tlanavatis in Dios. Iva Jesús okinnankili: —Ijkuak Dios pevas tlanavatis amo yetos kemi itla tlamantli tlen motta. ");
INSERT INTO nsu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nion amo kijtoskeh: “Nika kajki” o “Nepa kajki”. Porke Dios yope tlanavatia itech inyolo in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iva okinmilvi in momachtijkeh: —Ajsis tonali ijkuak imejvah inkinekiskeh inkittaskeh iKone in Tlakatl maski san se tonali, pero amo inkittaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iva sekimeh imechilviskeh: “Nika kajki”, o “Nepa kajki.” Amo xikneltokakah, iva nion amo xikinseguirokah. ");
INSERT INTO nsu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porke ijkó kemi ijkuak tlapetlani iva tlavia se lado itech ilvikak iva tlavia asta itech oksé lado, ijkó noijki mottas iKone in Tlakatl ijkuak valmuikas. ");
INSERT INTO nsu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero achto moneki tlajyovis miek, iva in gentejtih de nin tiempo amo kiseliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ijkó kemi opanolok itech neká tiempo de Noé, no ijkó tlamochivalos ijkuak valmuikas iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","In gentejtih otlakuajtokah iva okonitokah, oilvichivayah iva omonamiktiayah. Ijkó okichijtokah asta ijkuak Noé okalakki ijtik in wei barko, iva ijkuakó omokajka in kiavitl chikavak iva nochtin omikkeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ijkó noijki opanolok itech neká tiempo de Lot: otlakuajtokah iva okonitokah, omotlakovijtokah iva otlanemakatokah, otlatookatokah iva omokaltijtokah. ");
INSERT INTO nsu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero ijkuak Lot okiski de kan siudad de Sodoma, ovetzki tlitl iva azufre de ilvikak, iva nochtin oixpolikeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijkó noijki tlamochivalos ijkuak valmonextis iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Itech neká tonali, tla íkka yetos ikpak ikal, amo ma temo para kikixtiti tlen kipia itech ikalijtik. Iva tla íkka kajki itlala, amo ma valmokuapa para ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xikilnamikikah tlen okipanok itonana in Lot. ");
INSERT INTO nsu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tlen kinekis kimakixtis inemilis, kipolos. Pero tlen kipolos inemilis por Ne, kimakixtis. ");
INSERT INTO nsu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Nimechilvia ke yejón yovak kochtoskeh omeh itech se kochtlapechtli. Se kivikaskeh iva oksé kikajtevaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ome sivameh sepantistoskeh inkalijtik. Se kivikaskeh iva oksé kikajtevaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ome tlakah sepantekipanojtoskeh intlala. Se kivikaskeh iva oksé kikajtevaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ijkuakó Jesús okitlajtlanijkeh: —ToTeko, ¿kanin ijkó tlamochivalos? Iva Jesús okinmilvi: —Ijkó kemi ijkuak in tzojpilomeh peva mololovah kan vetok se yolkatl tlen yomikki, ijkó noijki yetos ijkuak Ne nivitz porke nochtin kimatiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús okinmilvi se ejemplo para kinmachtis nik moneki se modiostzajtzilis nochipa, iva amo ma se mosotlava. ");
INSERT INTO nsu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Okinmilvi: —Okatka itech se altepetl se jues tlen amo okimakasia Dios iva amo okinchivaya kuenta in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Itech yejón altepetl noijki okatka se iknosivatl, tlen nochipa okoniitaya yejón jues para ma kinyekkava ivan se tlen iva mokualania. ");
INSERT INTO nsu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Opanok miek tonali in jues amo okinekia kipalevis, pero satepa okimolvi: “Maski amo nikimakasi in Dios iva amo nikinchiva kuenta in gentejtih, ");
INSERT INTO nsu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nikpalevis nin iknosivatl, porke sa nochipa nechvalita, para ayakmo okachi ma nechkuejso iva ma nechkuatotonili.” ");
INSERT INTO nsu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iva toTeko okijto: —Xikakikah tlen okijto in amo kuali jues. ");
INSERT INTO nsu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Ke amo velis in Dios noijki kinpalevis tlen Ye yokinpejpenki, tlen ika tonali ika yovali kitlatlavtiah ma kinpalevi? ¿Kox wejkavas para kinpalevis? ");
INSERT INTO nsu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ne nimechilvia nik amo wejkavas. Pero ijkuak valmuikas iKone in Tlakatl itech nin tlaltikpaktli, ¿kinmajsikih in gentejtih tlen kineltokah? ");
INSERT INTO nsu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Okatkah sekimeh tlen omomachiliayah tlakamelajkeh iva okinmitayah tlen oksekimeh kemi oyeskia amitla inpati. Iva Jesús okinmilvi nin ejemplo: ");
INSERT INTO nsu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ome tlakah oyajkeh kan templo omodiostzajtzilitoh: se okatka fariseo, iva oksé okatka kobrador de impuestos. ");
INSERT INTO nsu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","In fariseo omoketoka iva omodiostzajtzilijtoka ijkí: “Dios, nimitztlasojkamachilia porke ne amo nikchiva kemi oksekimeh, tlen tlachtekih, tlen amo kualmeh iva tlen avilnemih itech tlajtlakoli. Iva nion amo nikchiva kemi nin kobrador de impuestos. ");
INSERT INTO nsu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne nimosava ome welta se samana, iva nimitzmaka in diezmo de nochi tlen niktlani.” ");
INSERT INTO nsu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero in kobrador de impuestos san wejka omoketzki iva nion amo omixeviaya ajkotlachias, sino san omoelpanvitekia iva okijtovaya: “¡Dios, techiknomati, porke ne nitlajtlakole!” ");
INSERT INTO nsu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne nimechilvia ke yejón kobrador de impuestos ijkuak omokuapki para ikalijtik, Dios yokitlapojpolvi de itlajtlakol, pero in fariseo amo. Porke tlen momachilis weititok, satepa kitlalchitlaliskeh. Pero tlen motlalchitlalis, satepa kiweijkatlaliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Okinvalikilijkeh in Jesús sekimeh konemeh para ma kintlali imavah inpa. Pero ijkuak in momachtijkeh ijkó okittakeh, ope kinmajvah tlen okinvalikayah in konemeh. ");
INSERT INTO nsu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús okinnotzki iva okinmilvi: —Xikinkavakah in konemeh ma vikikah nonavak, amo xikintzatzakuilikah. Porke tlen kateh kemi ninmeh konemeh, yejvah povih kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yi neli nimechilvia, tlen amo kimokavilis in Dios ma tlanavati itech ijkó kemi se chokotzi kimokavilia, amo velis kalakis kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Se tlayakanki judío okitlajtlani in Jesús: —Kuali Tlamachti. ¿Tlán moneki nikchivas para nikpias nemilistli para semijkak? ");
INSERT INTO nsu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús okilvi: —¿Tleka techilvia nikuali? Amika onka oksé kuali, sino san yen Dios. ");
INSERT INTO nsu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yi tikmati tlen kijtovah in tlanavatiltih: “Amo xiavilnemi itech tlajtlakoli, amo xitemikti, amo xitlachteki, amo xikijto tlen amo neli innavak oksekimeh, xiktlakita mopapa ivan momama.” ");
INSERT INTO nsu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","In tlakatl okilvi: —Nochi yejón nikchijtivitz desde nichokko. ");
INSERT INTO nsu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ijkuak Jesús ijkó okikakki, okilvi: —Oksé tlamantli mitzpolova tikchivas: xiknemaka nochi tlen tikpia iva in tomi xikinmaka in prowestih. Ijkó velis tikpias rikojyotl itech ilvikak. Iva ijkuakó kema xiviki iva techseguiro. ");
INSERT INTO nsu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero in tlakatl ijkuak ijkó okikakki, sa tlawel omoyolkoko, porke okatka sa tlawel tomine. ");
INSERT INTO nsu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ijkuak Jesús okittak in tlakatl nik sa tlawel omoyolkoko, okijto: —In tominejkeh sa tlawel ovijtitok para kalakiskeh kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Okachi amo ovi panos se kameyo kan ixtololo se aguja, ke se tomine ma kalaki kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iva tlen ijkó okikakkeh okijtojkeh: —Tonses, ¿akin velis momakixtis? ");
INSERT INTO nsu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús okinmilvi: —Tlen amo velih kichivah in tlaltikpaktlakah, Dios veli kichiva. ");
INSERT INTO nsu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro okilvi: —Tejvah otikajtejkeh nochi tlen otikpiayah para velis timitzseguiroskeh. ");
INSERT INTO nsu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iva Jesús okinmilvi: —Yi neli nimechilvia, tlen okikajte ikal, ipapa, iknivah, itonana, o noso ipilvah, para tlavelkakis itech tlen Dios tlanavatia, ");
INSERT INTO nsu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kiselis itech nin tiempo okachi miek ke tlen okikajte. Iva itech neká tiempo tlen yetos satepa, kiselis nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús okinvikak ik se lado in majtlaktli ivan ome momachtijkeh, iva okinmilvi: —Axka ma tiviah para Jerusalén, kan mochivas nochi tlen okijkuilojkeh in tiotenejmachtijkeh aserka de yen iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kitemaktiskeh inmak in gentejtih tlen amo judiojtih, kipijpinatiskeh, fiero kilviskeh iva kixchijchaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Iva satepa de kivitekiskeh, kixpoloskeh. Pero ipan eyi tonali, moyolitis. ");
INSERT INTO nsu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero yejvah amo okajsikamatkeh tlen okinmilvi. Amo kakilistli para yejvah, iva por eso amo okimatiah de tlán okintlapoviaya. ");
INSERT INTO nsu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ijkuak Jesús yonajsia kan siudad de Jericó, se tlakatl tlen amo otlachiaya oyetoka itempan ojtli okitlajtlantoka limosna. ");
INSERT INTO nsu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ijkuak okikakki nik ompa panovah miekeh gentejtih, in tlakatl tlen amo otlachiaya otlajtlanki tlán tlamochivalo. ");
INSERT INTO nsu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iva okilvijkeh ke Jesús de Nazaret mero ompa panova. ");
INSERT INTO nsu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ijkuakó chikavak okitzajtzili: —¡Jesús, iKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tlen oyayah tlayakapa okajvakeh para ma kitzakua ikamak, pero ye okachi chikavak okitzajtziliaya: —¡IKone in David, techiknomati! ");
INSERT INTO nsu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ijkuakó Jesús omoketzki iva otlanavati ma kivalikakah. Iva ijkuak oajsiko iyakapa, okitlajtlani: ");
INSERT INTO nsu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tlán tikneki ma nikchiva por te? In tlakatl tlen amo otlachiaya okijto: —NoTeko, nikneki nitlachias. ");
INSERT INTO nsu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús okilvi: —¡Xitlachia! Axka yotipajtik porke otechneltokak. ");
INSERT INTO nsu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","San nima ijkuakó in tlakatl yovelik otlachixki. Satepa oyá ivan Jesús kiweijkachijtiv in Dios. Iva nochtin gentejtih tlen okittakeh, noijki okiweijkachivayah in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Satepa Jesús oajsito kan siudad de Jericó, iva opanotiaya itech yejón siudad. ");
INSERT INTO nsu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ompa okatka se tlakatl tomine itoka Zaqueo, tlen tlayakanki de kobradortih de impuestos. ");
INSERT INTO nsu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iva yejón Zaqueo okinekia kixmatis in Jesús. Pero amo ovelia okittaya porke okatkah sa tlawel miekeh gentejtih iva Zaqueo okatka san tlajtlalchitzi. ");
INSERT INTO nsu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ijkuakó omotlelo tlayakapa serka de kanik panos in Jesús, iva otlejkok itech se kuavitl sicómoro para velis kittas in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ijkuak Jesús opanok ik ompa, oajkotlachixki okittak iva okilvi: —Zaqueo, xitemo totoka, porke axka moneki nimokalotis mokalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ijkuakó Zaqueo otemok totoka, iva okiseli in Jesús ikalijtik ika miek pakilistli. ");
INSERT INTO nsu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ijkuak in gentejtih ijkó okittakeh, nochtin ope kipojpovah in Jesús, okijtovayah ke Jesús okalakki omokalotito kan ikalijtik se tlakatl tlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Satepa Zaqueo omoketzki iva okilvi in toTeko: —NoTeko, nikinmakas in prowestih tlajko de nochi tlen nikpia. Iva tla íkka oniktlachteki ika tlakajkayavalistli, nikkuapilis navi welta okachi de tlen onikixtili. ");
INSERT INTO nsu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús okijto: —Axka yoejkok in temakixtilistli itech nin kalijtik, porke nin tlakatl noijki valajtok de Abraham. ");
INSERT INTO nsu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Porke iKone in Tlakatl ovala okintemoko iva okinmakixtiko tlen politokeh. ");
INSERT INTO nsu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","In gentejtih okikakiah nochi nin tlajtoli tlen Jesús okinmilviaya, iva komo yi mero onajsia Jerusalén, Jesús okinmilvi oksé ejemplo, porke sekimeh okiyejyekovayah ke Dios nima yi pevas tlanavatis itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Okinmilvi: —Okatka se tlakatl tlen weititok, oyá wejka para kiselis itekivajkayo de wei tlanavati iva satepa oksemi valmokuapas. ");
INSERT INTO nsu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antes de yas, okinnotzki majtlaktih itlakevalvah, iva kada se okimakak seki tomi kemi de eyi metztli de tlaxtlavili, iva okinmilvi: “Xiktekipanoltikah nin notomi para xiktlanikah okachi mientras ma nimokuapati.” ");
INSERT INTO nsu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero in gente de ipaís okitlavelitayah, iva por eso okintitlankeh sekimeh tlakah para ma kijtotih: “Mach tiknekih nin tlakatl ma technavati kemi wei tlanavati.” ");
INSERT INTO nsu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero okiseli itekivajkayo, iva omokuapki para ipaís. Ijkuak oajsiko, otlatitlanki ma kinnotzatih itlakevalvah tlen okinmakak in tomi, para kimatis kech okitlanki kada se. ");
INSERT INTO nsu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Achto se ovala iva okijto: “Noteko, motomi okitlanki majtlaktli welta okachi.” ");
INSERT INTO nsu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","In wei tlanavati okilvi: “Kuali kajki. Te kuali tinotlakeval. Iva komo titenmachtli tlen san ika tzikitzi, por eso axka nimitztlalis xitlanavati itech majtlaktih altepemeh.” ");
INSERT INTO nsu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Oksé ovala iva okijto: “Noteko, motomi okitlanki makuili welta okachi.” ");
INSERT INTO nsu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","In wei tlanavati noijki okilvi: “Te noijki nimitztlalis xitlanavati itech makuiltih altepemeh.” ");
INSERT INTO nsu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Satepa ovala oksé iva okijto: “Noteko, nika kajki motomi. Oniktlaati ika se panito. ");
INSERT INTO nsu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Onimitzimakaski, porke tejwatzi sa tlawel titekixneki, iva tikmokavia tlen amo otiktlanki iva tikpixka tlen amo otiktookak.” ");
INSERT INTO nsu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ijkuakó in wei tlanavati okilvi: “Te amo tikuali tinotlakeval, te monevia timotlajtlakolmamaltia por tlen yotikijto. Tla tikmati ke nitekixneki, iva nikmokavia tlen amo niktlani iva nikpixka tlen amo niktooka, ");
INSERT INTO nsu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿tleka amo otikavato notomi kan banko, para ijkuak ne onivalajsiskia, onikseliskia notomi ivan ikoneyo?” ");
INSERT INTO nsu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iva okinmilvi tlen ompa okatkah: “Xikixtilikah in tomi tlen onikmakak, iva xikmakakah tlen yokitlanki majtlaktli welta okachi de tlen onikmakak.” ");
INSERT INTO nsu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Iva yejvah okinankilijkeh: “Pero, toteko, ye yikipia majtlaktli welta okachi de tlen otikmakak.” ");
INSERT INTO nsu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero in wei tlanavati okijto: “Ne nimechilvia, tlen kipia kimakaskeh okachi. Pero tlen amo kipia, asta yen tlen tzikitzi kipia kikixtiliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iva nekateh tlen nechtlavelitah tlen amo kinekih ma nieto niwei tlanavati para ma nikinnavati, xikinvalikakah iva nika noixpa xikinmiktikah.” ");
INSERT INTO nsu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Satepa de ijkó okijto, Jesús oksemi oonnevak para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ijkuak oajsito serka de kan altepetl Betfagé iva Betania, omoketzki kan tepetl tlen itoka Olivos. Iva ijkuakó okintitlanki ome tlen momachtijkeh, ");
INSERT INTO nsu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","okinmilvi: —Xiviah itech neká altepetzintli tlen kajki ne tlayakapantzi, iva ijkuak inmajsitivih inkittaskeh se burrojtzi ompa ilpitok, tlen ayamika ipan motlalia. Xiktotomakah iva xikvalikakah. ");
INSERT INTO nsu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tla íkka imechtlajtlanis tleka inkitotomah, xikilvikah: “In toTeko kinejnekis.” ");
INSERT INTO nsu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","In momachtijkeh oyajkeh, iva okajsitoh nochi kemi Jesús okinmilvi. ");
INSERT INTO nsu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iva ijkuak okitotontokah in burrojtzi, in tekovajkeh okintlajtlanijkeh: —¿Tleka inkitotomah in burrojtzi? ");
INSERT INTO nsu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iva yejvah otlanankilijkeh: —In toTeko kinejnekis. ");
INSERT INTO nsu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iva okivikilijkeh in Jesús. Iva intlakenvah tlen okinmokentiayah okintlalijkeh ipan burrojtzi iva ipan okitlejkoltijkeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ijkuak Jesús yoyaya ipan burrojtzi, in gentejtih okinsojtiayah ipan ojtli intlakenvah tlen okinmokentiayah. ");
INSERT INTO nsu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iva ijkuak Jesús oajsito kan peva in temolistli de kan tepetl tlen itoka Olivos, ijkuakó nochtin tlen okiseguirovayah ope kiweijkachivah in Dios, chikavak otzajtziah ika miek pakilistli por nochtin tetzavimeh tlen yokinmitakeh. ");
INSERT INTO nsu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Okijtovayah: —¡Ma Dios kitiochiva in wei tlanavati tlen vitz ika itoka in Dios! ¡Ma yeto yolsevilistli itech ilvikak! ¡Ma weijkachito in Dios tlen kajki ilvikak! ");
INSERT INTO nsu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","De kan yejonmeh gentejtih, ompa okatkah noijki sekimeh fariseos, iva okilvijkeh in Jesús: —Tlamachti, xikintlakavalti tlen mitzseguirovah amo ijkó ma kijtokah. ");
INSERT INTO nsu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iva Jesús okinnankili: —Yi neli nimechilvia, tla yejvah motenkavaskeh, tonses in temeh tzajtziskeh chikavak. ");
INSERT INTO nsu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ijkuak Jesús oajsito serka de Jerusalén, iva ijkuak okittak in siudad, ochokak, ");
INSERT INTO nsu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","iva okijto: —¡Ay, gente de Jerusalén! ¡Tla sikiera onkimomakaskiah kuenta itech nin tonali tlen oveliskia omechmakaskia yolsevilistli! Pero axka Dios amo imechkavilia xikajsikamatikah. ");
INSERT INTO nsu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Porke ajsis tonali, ijkuak tlen imechtlavelitah imechtlatzakuiskeh ika tepamitl, imechyavaloskeh iva imechmagaskeh ik sentetl. ");
INSERT INTO nsu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kixixititzaskeh inmosiudad iva ayakmo mokavas nepanitos nion oksé tetl. Nochtin imejvah imechmiktiskeh, iva ijkó imechpanos porke amo onkiselijkeh tlen Dios omechmakaya. ");
INSERT INTO nsu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Satepa, Jesús okalakki kan ikiavak in templo iva ope kinkixtia de ompa tlen otlanemakatokah iva tlen otlakojtokah, ");
INSERT INTO nsu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iva okinmilvi: —Itech Tiotlajkuiloli kijtova: “Nokal yetos kali kan modiostzajtziliskeh in gentejtih.” Pero imejvah yonkikuapkeh kemi se kali de ichtekeh. ");
INSERT INTO nsu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nochi tonali Jesús otlamachtiaya kan templo. Pero in tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés, iva oksekimeh tlayakankeh judiojtih, ope kitemovah kenik velis kixpoloskeh. ");
INSERT INTO nsu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero amo okajsiah ken kichivaskeh, porke nochtin gentejtih okatkah inavak Jesús iva okinekiah kikakiskeh de nochi tlen okijtovaya. ");
INSERT INTO nsu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se tonali Jesús okatka kan templo okinmachtijtoka in gentejtih, iva okintlapovijtoka de yen yankuik kuali tlajtoli. Iva ijkuakó ovalajkeh in tlayakankeh tiopixkeh, iva in tlamachtijkeh de itlanavatil Moisés, iva in tlayakankeh tetajmeh, ");
INSERT INTO nsu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","iva okilvijkeh: —Techilvi, ¿ken timixevia tikchiva nin tlamantli? ¿Akin omitzmakak tlanavatijkayotl para ijkó xikchiva? ");
INSERT INTO nsu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús okinnankili: —Ne noijki nimechtlajtlanis se tlajtoli. Technankilikah: ");
INSERT INTO nsu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Akin okinavati in Juan ma tlabautisaro? ¿Yen Dios okinavati, o noso íkka tlakatl okinavati? ");
INSERT INTO nsu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ijkuakó ope michtakatlapoviah entre yejvah: —Tla tikilviskeh ke Dios okinavati, techilvis: “¿Tonses tleka amo onkineltokakeh?” ");
INSERT INTO nsu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iva tla tikijtoskeh ke íkka tlakatl okinavati, nochtin gentejtih techmiktiskeh ika tetl, porke nochtin kineltokah ke Juan okatka tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iva okinankilijkeh ke amo kimatih akin okinavati in Juan ma tlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ijkuakó Jesús noijki okinmilvi: —Ne noijki amo nimechilvis akin onechmakak tlanavatijkayotl para ma nikchiva nin tlamantli. ");
INSERT INTO nsu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Satepa Jesús ope kintlapovia in gentejtih ika nin ejemplo: —Okatka se tlakatl tlen okitookak uvas itlala, iva satepa okintlaneti sekimeh tekipanojkeh, iva ye oyá de viaje iva owejkavato kan oyá. ");
INSERT INTO nsu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ijkuak oajsik tonali para tlatekiskeh ika uvas, okititlanki se itlakeval kan yejonmeh tekipanojkeh ma kikuiti tlen kitokarova. Pero in tekipanojkeh okimagakeh ika maitl iva okivalkuapkeh san ijki. ");
INSERT INTO nsu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Satepa okititlanki oksé itlakeval. Pero noijki okimagakeh ika maitl iva fiero okilvijkeh, iva okivalkuapkeh san ijki. ");
INSERT INTO nsu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iva oksemi okititlanki oksé itlakeval. Pero in tekipanojkeh noijki okikojkojkeh iva okikixtijkeh de kan uvajyo. ");
INSERT INTO nsu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Satepa, in tekova okijto: “¿Tlán nikchivas? Niktitlanis notlasojkakone. Ijkuak kittaskeh xamo kitlakitaskeh.” ");
INSERT INTO nsu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ijkuak in tekipanojkeh okittakeh, okimolvijkeh entre yejvah: “Nin ipiltzi yen kimokavis nin tlali kemi erensia. Ma tikmiktikah para tejvah tikmokaviskeh in tlali.” ");
INSERT INTO nsu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ijkuakó ipiltzi in tekova okikixtijkeh de kan uvajyo iva okimiktijkeh. Satepa Jesús okintlajtlani: —¿Tlán kichivas in tekova ivan yejonmeh tekipanojkeh? ");
INSERT INTO nsu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In tekova yas iva kinmijmiktis nekateh tekipanojkeh, iva satepa kinmaktilis iuvajyo oksekimeh tekipanojkeh. In gentejtih ijkuak ijkó okikakkeh, okijtojkeh: —¡Amo ma Dios kimonekilti! ");
INSERT INTO nsu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús okintlajtlatak, iva okijto: —¿Tlán kijtosneki pues tlen kijtova in Tiotlajkuiloli?: In tetl tlen kalchijkeh amo okivelitakeh, omokuapki yen tetl tlen okachi kichikajtok in kali. ");
INSERT INTO nsu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tlen akin vetzis ipan nin tetl, pojpostekis. Iva tla in tetl vetzis íkka ipa, kikuejkuechos. ");
INSERT INTO nsu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","In tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés okimomakakeh kuenta ke Jesús okinparejaro ika neká ejemplo de tekipanojkeh tlen amo kualmeh. Iva ijkuakó okinekiah kikitzkiskeh, pero amo omixevijkeh porke okinmiimakasiah in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Satepa okintitlankeh sekimeh tlakah para ma kixpixtokah in Jesús. Okinmilvijkeh ma mochivakah kemi oyeskia tlakamelajkeh iva ijkuak kikakiskeh itla tlajtoli tlen amijtok, ijkuakó velis kiteilviskeh iva kitemaktiskeh imak in kobernador. ");
INSERT INTO nsu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Por eso okitlajtlanijkeh in Jesús: —Tlamachti, tikmatih nik yompa tlen tikijtova iva tlen titlamachtia. Iva tinochtin techitta tiiwalestih, iva yi neli titlamachtia kenik se nemis kemi Dios kineki. ");
INSERT INTO nsu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Techilvi: ¿kox kuali se kitlaxtlavas impuestos para in wei tekiva César o noso amo? ");
INSERT INTO nsu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús yokimatia ke yejvah san ik mochivah, iva okinmilvi: —¿Tleka inkinekih ma nikijto itla tlen amijtok? ");
INSERT INTO nsu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Techititikah se tomi. ¿De akin ixko iva akin itoka tlen nestok itech nin tomi? Iva yejvah okinankilijkeh: —De César. ");
INSERT INTO nsu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ijkuakó Jesús okinmilvi: —Pues xikmakakah in César tlen itech povi in César, iva xikmakakah in Dios tlen itech povi in Dios. ");
INSERT INTO nsu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iva amo okajxilijkeh nion se tlajtoli tlen amijtok tlen ika okiteilviskiah de tlen okijto inmixpa gentejtih. Omotetzavijkeh ijkuak ijkó okikakkeh iva ayakmitla okijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Satepa, sekimeh saduceos oyajkeh okittatoh in Jesús. In saduceos amo kineltokah ke in mikameh velis moyolitiskeh. Iva okitlajtlanijkeh in Jesús: ");
INSERT INTO nsu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tlamachti, Moisés otechkajtevili ijkuilitok, tla se tlakatl omonamikti, ixpolivi iva amo okinpixki ipilvah ivan itonana, ikni in difunto kipia de monamiktis ivan iknosivatl para ivan kinpias ipilvah kemi oyeskia ipilvah in difunto. ");
INSERT INTO nsu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ijkó pues, yi semi okatkah chikome iknimeh. Tlen tetiachka achto omonamikti, pero oixpolivik iva amo okinpixki ipilvah. ");
INSERT INTO nsu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oksé ikni tlen kivaltoka omonamikti ivan yejón iknosivatl, iva noijki oixpolivik iva amo okinpixki ipilvah. ");
INSERT INTO nsu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Oksé tlen kivaltoka no ijkó omochi, iva noijki ijkó omochijkeh nochtin tlen chikome iknimeh. ");
INSERT INTO nsu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Satepa noijki oixpolivik in iknosivatl. ");
INSERT INTO nsu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tonses, ijkuak moyolitiskeh in mikameh, ¿katle de yejonmeh iknimeh yetos itonana yejón sivatl, porke nochtin chikomeh iknimeh omonamiktijkeh ivan yejón sivatl? ");
INSERT INTO nsu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ijkuakó Jesús okinnankili: —Itech nin tlaltikpaktli, in tlakah ivan sivameh monamiktiah. ");
INSERT INTO nsu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero tlen Dios kijtos ma moyolitikah para yeskeh itech neká yankuik nemilistli tlen yetos satepa, ijkuakó ayakmika monamiktis. ");
INSERT INTO nsu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porke ompa ayakmo ixpoliviskeh. Yeskeh kemi ilvikaktlatitlaniltih tlen amo semi ixpolivih. Yeskeh tepilvah de Dios porke yomoyolitijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés noijki techititia ke in mikameh moyolitiah, kan tlapova de se kovatlanvitztli tlen otlatlaya. Kan Dios okilvi in Moisés nik yen Dios de Abraham, de Isaac iva de Jacob. ");
INSERT INTO nsu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iva Dios amo Dios de mikameh, sino de tlen yolitokeh. Iva para Dios nochtin yolitokeh tlen Ye iaxkavah. ");
INSERT INTO nsu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ijkuakó sekimeh tlamachtijkeh de itlanavatil Moisés okilvijkeh: —Tlamachti, kuali tlen otikijto. ");
INSERT INTO nsu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iva mach ok omixevijkeh ok itla okitlajtlanijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ijkuakó Jesús okintlajtlani tlen ompa okatkah: —¿Tleka in gentejtih kijtovah ke Cristo yen ikone in David? ");
INSERT INTO nsu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porke inevia in David kijtova itech libro de Salmos: Dios omotlapovi ivan noTeko, okilvi: “Ximotlali ik noyekmapa, ");
INSERT INTO nsu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta kan ma nikintlali itlampa mokxivah tlen mitztlavelitah.” ");
INSERT INTO nsu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Inevia David okinotzki in Cristo iTeko. Tonses, ¿kenik in Cristo ma yeto tekone de David? ");
INSERT INTO nsu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mientras nochtin otlakaktokah, ijkuakó Jesús okinmilvi in momachtijkeh: ");
INSERT INTO nsu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Xikpiakah kuidado de tlen tlamachtijkeh de itlanavatil Moisés, porke kivelitah nemiskeh ika intlakenvah weweyakeh, iva kinekih ma kinyektlajpalokah ijkuak nemih tiankistli. Iva kan tiotlamachtijkaltih kivelitah motlaliskeh kan motlaliah in tlayakankeh, iva itech ilvimeh kitemovah se kuali lugar kan motlaliskeh. ");
INSERT INTO nsu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iva kinkixtiliah inkalvah in iknosivameh, iva san ik mochivah wejkavitl modiostzajtziliah. Por eso, Dios kintlajyoviltis okachi. ");
INSERT INTO nsu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús okatka kan templo iva okinmitak sekimeh tominejkeh okontlaliayah intomi ijtik in kaja kan kitlaliah ofrendajtomi. ");
INSERT INTO nsu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noijki ompa okittak se iknosivatl prowe tlen okontlali ijtik kaja ome tomintzitzintih de cobre tlen amo miek ipati. ");
INSERT INTO nsu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iva Jesús okijto: —Yi neli nimechilvia, ke nin iknosivatl prowe okontlali okachi ke nochtin tlen oksekimeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porke nochtin oksekimeh okontlalijkeh intomi tlen kinsobrarova, pero nin iknosivatl prowe okontlali nochi tlen okipiaya para ika otlakuaskia. ");
INSERT INTO nsu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sekimeh omotlapovijtokah aserka de yen temeh kualtzitzintih tlen ika ochijchitoka in templo, iva de sekimeh tlamantih kualtzitzintih tlen ompa okatkah kemi tlachijchivali. Ijkuakó Jesús okijto: ");
INSERT INTO nsu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ajsis tonali nochi nin tlen imejvah axka inkittah, nochi kixixititzaskeh iva ayakmo mokavas nepanitos nion oksé tetl. ");
INSERT INTO nsu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ijkuakó okitlajtlanijkeh: —Tlamachti, ¿keman ijkó panolos? ¿Katli yen neskayotl tikittaskeh ijkuak pevas ijkó panolos? ");
INSERT INTO nsu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús okijto: —Xikpiakah kuidado de amika ma imechkajkayava. Miekeh vitzeh san kinejnekiskeh notoka, kijtoskeh: “Ne niCristo”, iva noijki kijtoskeh: “Yoajsik ora.” Pero amo xikinneltokilikah. ");
INSERT INTO nsu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ijkuak inkimatiskeh onka guerra iva kimomagah ik nikan nepa, amo ximomavtikah. Ijkó kipia tlen panos, pero ayamo tlamis in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús noijki okinmilvi: —Se país kimomagas ivan oksé país, iva se altepetl kimomagas ivan oksé altepetl. ");
INSERT INTO nsu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Miek lado tlalolinis chikavak, yetos apistli iva yetos miek kokolistli. Iva itech ilvikak mottas miek tlamantli tlen amo keman motta iva yetos temajmavti. ");
INSERT INTO nsu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero antes de ijkó tlamochivalos, imejvah imechochololtiskeh iva imechkitzkiskeh. Imechtemaktiskeh kan tiotlamachtijkaltih iva imechtzakuaskeh telpiloya. Imechvikaskeh innavak in wejwei tlanavatijkeh iva innavak kobernadortih. Ijkó imechtoktiskeh por innechneltokah. ");
INSERT INTO nsu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero ijkuakó imejvah velis inkintlapoviskeh de Ne. ");
INSERT INTO nsu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Iva xikchivakah de amo ximotekipachokah de kenik intlanankiliskeh para inmopaleviskeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porke Ne nimechmakas tlajtoli iva tlamatilistli iva nion se de tlen imechtlavelitah amo velis imechnankilis iva nion kijtos ke amo neli tlen inkijtovah. ");
INSERT INTO nsu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iva asta inmotajvah, iva inmoknivah, iva tlen itla inkimitah, iva inmoyoliknivah yejvah mismo inmechtemaktiskeh. Iva sekimeh de imejvah inmechmiktiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nochtin imechkualankaitaskeh por innechneltokah. ");
INSERT INTO nsu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero amo inkipoloskeh nion se inmotzonkal. ");
INSERT INTO nsu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Imejvah ximoyekketokah itech inmotlaneltokalis, para velis inmomakixtiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ijkuak inkittaskeh in siudad de Jerusalén yokiyavalojkeh miekeh soldadojtih, xikmatikah nik san nima yi kixixititzaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ijkuakó, tlen yeskeh Judea ma cholokah asta kan tepemeh. Tlen yeskeh Jerusalén ma kisakah san nima, iva tlen yeskeh tlala amo ma kalakikah kan yejón siudad. ");
INSERT INTO nsu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porke itech yejonmeh tonaltih yetos tlajyovilistli, iva tlamochivalos ijkó kemi kajki ijkuilitok itech Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Prowestih in sivameh tlen itech nekateh tonaltih kipiaskeh inkone inmijtik iva in sivameh tlen tlaskaltijtoskeh! Porke yetos wei tlajyovilistli itech nin tlaltikpaktli, iva ikualanilis in Dios vitz itech ninmeh gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sekimeh ixpoliviskeh itech guerra, iva sekimeh kinkitzkiskeh iva kinvikaskeh itech oksekimeh países. In gentejtih tlen amo judiojtih tlaijtlakoskeh iva yejvah kinavatijtoskeh in siudad de Jerusalén, asta ijkuak tlamis in tiempo tlen Dios yokitlali para yejvah tlanavatijtoskeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ijkuakó panos miek tlamantli tlen amo keman motta itech tonali, itech metzi iva itech sitlalimeh. Iva itech nochi in tlaltikpaktli in gentejtih motekipachoskeh iva momajmavtiskeh. Mach ok kimatiskeh tlán kichivaskeh, porke in atl tlen wei ijkoyukas chikavak iva motlatlavitekis. ");
INSERT INTO nsu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","In gentejtih asta kuaxivintiskeh de mavkayotl ijkuak kittaskeh tlen tlamochivalos itech nin tlaltikpaktli. Porke in tlamantih tlen chijchikavakeh tlen kateh itech ilvikak viviokaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ijkuakó kittaskeh iKone in Tlakatl vitz itech mixtli ika miek ivelitilis iva ika wei imavissotlanex. ");
INSERT INTO nsu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ijkuak pevas ijkó tlamochivalos, ximoyolchikavakah iva xiajkotlachiakah, porke Dios san nima imechmakixtis. ");
INSERT INTO nsu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús noijki okinmilvi nin ejemplo: —Xikittakah in igoskuavitl, o noso itla oksé kuavitl. ");
INSERT INTO nsu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ijkuak inkittah yi peva moxivyotia, imejvah yinkimatih nik in tonaya yi kajki serka. ");
INSERT INTO nsu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ijkó noijki, ijkuak inkittaskeh yope ijkó tlamochivalo, xikmatikah noijki nik in Dios yi mero pevas tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Yi neli nimechilvia, ke nochi yejón tlamantli panolos antes de ixpoliviskeh in gentejtih de nin tiempo. ");
INSERT INTO nsu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","In ilvikak ivan tlaltikpaktli ayakmo yeskeh, nochi polivis, pero notlajtol amo polivis, sino kipia de mochivas nochi tlen nimechilvia. ");
INSERT INTO nsu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Xikpiakah kuidado. Amo ma tlakuava inmoyolo ika pitzonemilistli nion ika tlavankayotl, iva nion ika netekipacholi de nin nemilistli. Amo san kichiva neká tonali imechonajsiki amo inmonejmachpa. ");
INSERT INTO nsu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porke yetos kemi se trampa tlen kinkitzkis nochtin gentejtih tlen yeskeh itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xiijsatokah pues. Ximodiostzajtzilijtokah nochipa para velis incholoskeh de nochi yejón tlen panolos. Iva ijkó velis inmoteixpantiliskeh ixpan iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús otlamachtiaya de tlajka kan templo, iva de yovak oyaya kan tepetl tlen itoka Olivos iva ompa omokavaya. ");
INSERT INTO nsu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iva nochi kualkanpa in gentejtih oyayah kan templo para kikakiskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yoajsia ilvitl ijkuak mokua in pan tlen amo kipia xokotixtli, kijtosneki yen tlen ilvitl de Pascua. ");
INSERT INTO nsu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","In tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés okitemovayah kenik velis kixpoloskeh in Jesús, pero okinmiimakasiah in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ijkuakó in Amo Kuali Tlakatl okalakki itech iyolo in Judas, tlen okinotzayah Iscariote, tlen okatka se de tlen majtlaktli ivan ome momachtijkeh de Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas oyá omotlapovito invan tlayakankeh tiopixkeh iva noijki invan tlayakankeh de templojmayoltih, kenomi nik kinmaktilis in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yejvah opakeh iva okilvijkeh kimakaskeh tomi. ");
INSERT INTO nsu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas okijto kuali kajki iva ope kitemova keman velis kitemaktis in Jesús, ijkuak amo teixpa. ");
INSERT INTO nsu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oajsik tonali de ilvitl ijkuak mokua in pan tlen amo kipia xokotixtli, iva ijkuak kimiktiah se ichkakonetl para kikuaskeh tiotlaki itech ilvitl de Pascua. ");
INSERT INTO nsu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús okinnotzki in Pedro ivan Juan, iva okinmilvi: —Xiviah xikchivatih in tlakuali de Pascua para tikmomajseviskeh. ");
INSERT INTO nsu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yejvah okitlajtlanijkeh: —¿Kan tikneki ma tikchivatih? ");
INSERT INTO nsu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús okinnankili: —Ijkuak inkalakiskeh kan siudad, ompa inkittaskeh se tlakatl kivika atl ika komitl. Xikseguirokah asta ikalijtik, ");
INSERT INTO nsu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","iva ompa itech yejón kali xiktlajtlaniikah in chane: “In Tlamachti kijtova: ¿Katli yen kuarto kan nikmomajsevis in tlakuali de Pascua Ne ivan tlen nikinmachtia?” ");
INSERT INTO nsu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ijkuakó ye imechititis se wei kuarto tlen kajki tlakpak kan yi tlayektlalitok. Ompa xikchivakah in tlakuali de Pascua. ");
INSERT INTO nsu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yejvah oyajkeh iva okajsitoh nochi kemi Jesús okinmilvi, iva okichijkeh in tlakuali de Pascua. ");
INSERT INTO nsu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ijkuak oajsik ora para tlakuaskeh, Jesús ivan tiotlatitlaniltih omotlalijkeh kan mesa. ");
INSERT INTO nsu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús okinmilvi: —Desde yi wejkavitl niknektivitz nikmomajsevis inmovah nin tlakuali de Pascua antes de nitlajyovis. ");
INSERT INTO nsu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nikneki nimechilvis ke mach ok kema nikmomajsevis oksé tlakuali kemi nin, asta ma ajsi neká tonali ijkuak momatis tlan kijtosneki nin tlakuali kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Satepa okontilanki se kopa de vino, okitlasojkamatki inavak Dios iva okijto: —Innochtin xiksepanonikah nin kopa de vino. ");
INSERT INTO nsu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nikneki nimechilvis ke mach ok nikonis vino, asta ijkuak Dios yi pevas tlanavatis. ");
INSERT INTO nsu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Satepa, okontilanki in pan iva okitlasojkamatki inavak Dios. Okipojpostekki in pan iva okinmajmakak in momachtijkeh, iva okinmilvi: —Nin yen nokuerpo, iva niktemaka por imejvah. Imejvah ijkí xikchivakah para ika techilnamikikah. ");
INSERT INTO nsu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Noijki, ijkuak otlankeh otlakuajkeh yejón tiotlaki, okontilanki se kopa de vino iva okijto: —Nin kopa de vino yen noesso tlen nokivis por imejvah. Iva ika nin noesso Dios kichiva se yankuik moyekkavalistli inmovah. ");
INSERT INTO nsu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero in tlakatl tlen nechtemaktis, nika kajki nova kan mesa. ");
INSERT INTO nsu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yi neli, iKone in Tlakatl ixpolivis ijkó kemi Dios yokijto ma kipano. Pero ¡ay de neká tlakatl tlen kitemaktis! ");
INSERT INTO nsu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ijkuakó ope motlajtlaniah entre yejvah akin ijkó kichivas. ");
INSERT INTO nsu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Noijki ope motlatlajtolnamikih akin de yejvah okachi weititok. ");
INSERT INTO nsu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús okinmilvi: —In wejwei tlanavatijkeh de nin tlaltikpaktli, kivelitah kiteititiskeh nik yejvah tlanavatiah. Iva tlen kalakih tekivajkeh kinmilviah in gentejtih: “Tejvah tikchivah tlen kuali iva timechpaleviah.” ");
INSERT INTO nsu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero imejvah amo ijkó xikchivakah. Tlen okachi weititos, moneki ma mochiva kemi tlen okachi telpochtli. Iva tlen tlanavatia, moneki yetos kemi se tlen tlapalevi. ");
INSERT INTO nsu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Akin okachi weititok, tlen motlalia kan mesa o noso tlen tlapalevia tetlamaka? ¿Amo yen tlen motlalia kan mesa? Pero Ne nika inmovah kemi se tlen tlapalevia. ");
INSERT INTO nsu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Nochi tiempo tlen nikpanotivitz ovijkayotl, imejvah nochipa inkateh nova. ");
INSERT INTO nsu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Por eso, Ne nimechtlalis xitlanavatikah, ijkó kemi noTajtzi onechtlali ma nitlanavati. ");
INSERT INTO nsu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kan Ne nitlanavatia, imejvah intlakuaskeh iva inkoniskeh kan nomesa, inmotlaliskeh ipan tekivajsiyajtih para inkijtoskeh akinmeh tlajtlakolejkeh iva akinmeh amo de tlen majtlaktli ivan ome familias de Israel. ");
INSERT INTO nsu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","In toTeko noijki okijto: —Simón, Simón, xikaki. Satanás yokitlajtlanki ma kikavilikah ma imechtzejtzelo kemi trigo para imechyejyekos xivetzikah itech tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero Ne yoniktlatlavti in Dios por te para ma mitzpalevi ximoyekketza itech motlaneltokalis. Iva ijkuak oksemi timokuapas nonavak, xikinpalevi moknivah para ma moyekketzakah itech intlaneltokalis. ");
INSERT INTO nsu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro okilvi: —NoTeko, ne mova nias maski mova ma nechtzakuakah, iva maski asta mova ma nechmiktikah. ");
INSERT INTO nsu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús okilvi: —Pedro, nikneki nimitzilvis, ke axka antes de tzajtzis in kaxtil, para ijkuakó te yotikijto eyi welta nik amo techixmati. ");
INSERT INTO nsu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ijkuakó Jesús okintlajtlani: —Ijkuak onimechtitlanki iva onimechilvi amo xikvikakah tominbolsa, nion ayatl, nion kaktli, ¿kox itla omechpolo? Yejvah okijtojkeh: —Mach itla. ");
INSERT INTO nsu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús okinmilvi: —Pero axka, moneki xikvikakah inmotominbolsa iva inmoaya. Iva tla amo inkipiah inmoespada, xiknemakakah inmochamarra iva xikmokovikah se. ");
INSERT INTO nsu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nikneki nimechilvis kipia tlen mochivas notech tlen kijtova in Tiotlajkuiloli: “Yejvah okittakeh kemi se tlakatl tlen yi neli tlajtlakole.” Porke nochi tlen kajki ijkuilitok de Ne, kipia tlen mochivas. ");
INSERT INTO nsu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ijkuakó yejvah okijtojkeh: —ToTeko, nika kateh ome espadajtih. Jesús okinmilvi: —Imejvah amo inkajsikamatih. Ya san ijkó xikavakah. ");
INSERT INTO nsu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Satepa Jesús okiski oyá kan tepetl tlen itoka Olivos ijkó kemi Ye okipiaya kostumbre. In momachtijkeh noijki okiseguirojkeh. ");
INSERT INTO nsu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ijkuak Jesús ompa oajsito, okinmilvi: —Ximodiostzajtzilikah, para amo xivetzikah ijkuak imechyoltilanas in tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús okinkajte, iva oyá wejkatzi kemi ijkuak tiktlamotlah se tetl. Ompa omotlankuaketzki iva omodiostzajtzili. ");
INSERT INTO nsu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Okijto: —NoTajtzi, tla tejwatzi tikmonekiltis, techpalevi amo ma nikpano nin tlajyovilistli tekoko. Pero amo ma mochiva kemin Ne nikneki, sino kemi tejwatzi tikmonekiltia. ");
INSERT INTO nsu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ijkuakó okimonextili se ilvikaktlatitlanili de ilvikak para kimakas chikavalistli. ");
INSERT INTO nsu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iva itech itlajyovilis okachi chikavak omodiostzajtziliaya, iva wejwei itonil ochipinia ipan tlali kemi estli. ");
INSERT INTO nsu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ijkuak otlanki omodiostzajtzili, omoketzki iva oyá kan okatkah in momachtijkeh, iva okinmajsito kochtokeh, sa tlawel omoyolkokovayah asta okintlanki kochilistli. ");
INSERT INTO nsu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús okinmilvi: —¿Tleka inkochih? Ximevakah, iva ximodiostzajtzilikah para amo ma imechyoltilana in tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ok otlapojtoka, iva ijkuakó ovalajkeh miekeh gentejtih. Okinvalyakanaya yen tlen itoka Judas, se de tlen majtlaktli ivan ome momachtijkeh. Yejón Judas omotoki inavak Jesús iva okixpipitzo. ");
INSERT INTO nsu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ijkuakó Jesús okilvi: —Judas, ¿ika se ixpipitzolistli tiktemaktia iKone in Tlakatl? ");
INSERT INTO nsu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tlen okatkah ivan Jesús, ijkuak okittakeh tlen yope tlamochivalo, okitlajtlanijkeh: —ToTeko, ¿tikneki invah ma timokitzkikah ika espada? ");
INSERT INTO nsu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iva se de yejvah okinakastzonteki se tlakatl tlen itlakeval in wei tiopixki, okitzontekili tlen iyeknakas. ");
INSERT INTO nsu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús okijto: —Ya, xikinkavakah. Ijkuakó Jesús okikitzkili inakas in yejón tlakatl iva okipajti. ");
INSERT INTO nsu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús okinmilvi in tlayakankeh tiopixkeh, in tlayakankeh de templojmayoltih iva in tlayakankeh tetajmeh, tlen ovalajkeh okikitzkikoh: —¿Onvalajkeh onnechkitzkikoh ika espada iva ika kuavitl kemi oyeskia niichteki? ");
INSERT INTO nsu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nochipa onikatka inmovah kan templo, iva amo semi onnechkitzkijkeh. Pero itech nin ora Dios imechkavilia xikchivakah tlen imejvah inkinekih, iva tlen kineki in Amo Kuali Tlakatl tlen tlanavatia kan tlayova. ");
INSERT INTO nsu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ijkuakó okitzkijkeh in Jesús iva okivikakeh kan ikalijtik in wei tiopixki. Pedro san wejka okinseguirovaya. ");
INSERT INTO nsu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ompa tlatlajko kiavak, okitlalijkeh se tlikuili iva omotlalijkeh okiyavalojkeh. Pedro noijki ompa omotlali intzala. ");
INSERT INTO nsu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Satepa se sivatl tlen ompa tlapalevi, ijkuak okittak in Pedro yetok iyakapan tlikuili, kuali okitlajtlatak iva okijto: —Nin tlakatl noijki onemia ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero in Pedro amo okimokuiti, iva okijto: —Nana, ne mach nikixmati. ");
INSERT INTO nsu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Satepa, oksé tlakatl okittak iva okilvi: —Te noijki se de yejvah. Iva Pedro okijto: —Amo, ne mach niteva. ");
INSERT INTO nsu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kemi se ora satepa, oksé tlakatl noijki okijto: —Yi neli, nin tlakatl onemia ivan Jesús, porke nin tlakatl noijki de Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro okijto: —Tata, mach nikmati tlán tikijtova. Iva san nima ijkuakó, ijkuak in Pedro ok otlapojtoka, ovaltzajtzik in kaxtil. ");
INSERT INTO nsu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ijkuakó in toTeko omokuapki iva okonitak in Pedro, iva Pedro okilnamiki tlen toTeko okilvijka: “Axka, antes de tzajtzis in kaxtil, para ijkuakó te yotikijto eyi welta nik amo techixmati.” ");
INSERT INTO nsu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ijkuakó Pedro okiski iva sa tlawel ochokak. ");
INSERT INTO nsu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","In tlakah tlen okikuidarojtokah in Jesús, okipijpinatiayah iva okivitekiah. ");
INSERT INTO nsu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Okixilpijkeh iva okixvijvitekiah, iva okilviayah: —¡Xikyejyekoli, akin omitzmagak! ");
INSERT INTO nsu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iva san tlen amo fiero okilviayah. ");
INSERT INTO nsu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ijkuak otlaneski, omololojkeh in tlayakankeh tetajmeh, in tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés, iva okivikakeh in Jesús itech injunta in judiojtih. Ompa okitlajtlanijkeh: ");
INSERT INTO nsu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Techilvi, ¿kox te tiCristo? Ye okinnankili: —Tla nimechilvis nik yen Ne, imejvah amo inkineltokaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Iva tla itla nimechtlajtlanis, amo innechnankiliskeh, iva nion amo innechkajkavaskeh. ");
INSERT INTO nsu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iva desde axka iKone in Tlakatl yetos ik iyekmapa in Dios tlen kipia nochi velitilistli. ");
INSERT INTO nsu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ijkuakó nochtin okitlajtlanijkeh: —¿Kijtosneki te tiiKone in Dios? Jesús okinnankili: —Imejvah inmonevia yonkijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ijkuakó yejvah okijtojkeh: —Mach ok monekih testigojtih. Tejvah toneviah yotikakkeh tlen yokijto. ");
INSERT INTO nsu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ijkuakó nochtin omoketzkeh, iva okivikakeh in Jesús inavak Pilato. ");
INSERT INTO nsu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ompa ope kiteilviah, okijtovayah: —Nin tlakatl kintlatlalvijtinemi topaisanojvah. Kijtova ke amo moneki se kitlaxtlavas impuestos para in wei tekiva César, iva kijtova nik yen Cristo, se wei tlanavati. ");
INSERT INTO nsu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iva Pilato okitlajtlani: —¿Te tiwei tlanavati de judiojtih? Jesús okinankili: —Te yotikijto. ");
INSERT INTO nsu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ijkuakó Pilato okinmilvi in tlayakankeh tiopixkeh ivan gentejtih tlen omololojkeh: —Ne amo nikajxilia itla tlamantli para velis nikijtos ke nin tlakatl tlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero yejvah okachi chikavak okijtojkeh: —San kinpajsolova in gentejtih ika itlamachtil itech nochi in tlali de Judea. Ope itech tlali de Galilea iva axka asta nika Jerusalén yoajsiko ika itlamachtil. ");
INSERT INTO nsu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ijkuak Pilato ijkó okikakki, otlajtlanki kox de Galilea in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ijkuak okilvijkeh nik de ompa, ijkuakó okititlanki inavak Herodes, tlen okatka kobernador de Galilea, iva tlen mero omajsia ompa Jerusalén itech yejonmeh tonaltih. ");
INSERT INTO nsu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes sa tlawel opakki ijkuak okittak in Jesús. Yi wejkavitl okinekia kixmatis, porke okikakia otlapovayah de Ye, iva okinekia kittas ma kichiva se tetzavitl. ");
INSERT INTO nsu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes okitlajtlani miek tlamantli, pero Jesús amitla okinankili. ");
INSERT INTO nsu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ompa okatkah noijki in tlayakankeh tiopixkeh iva in tlamachtijkeh de itlanavatil Moisés, tlen omotlajtolchikavayah okiteilviayah. ");
INSERT INTO nsu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ivan isoldadojvah fiero okilvijkeh iva okipijpinatijkeh. Okitlakentijkeh ika se kuali tlakemitl kemi se wei tlanavati. Satepa Herodes oksemi okititlanki inavak Pilato. ");
INSERT INTO nsu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Itech yejón tonali Pilato ivan Herodes omochijkeh yoliknimeh. Porke achto amo omoyekvikayah. ");
INSERT INTO nsu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Satepa Pilato okinmololo in tlayakankeh tiopixkeh, in tlayakankeh judiojtih iva nochtin gentejtih, ");
INSERT INTO nsu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iva okinmilvi: —Imejvah onnechvalikilijkeh nin tlakatl, inkijtovah kinpajsolojtinemi in gentejtih. Pero ne yoniktlatzintoki inmoixpa, iva amo onikajxili itla tlamantli de tlen imejvah ika inkiteilviah. ");
INSERT INTO nsu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nion Herodes amitla okajxili, por eso oksemi onechvaltitlanili. Nin tlakatl amitla okichi iva amo velis niktlajtlakoltis para ma ixpolivi. ");
INSERT INTO nsu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","San nitlanavatis ma kiwitekikah iva satepa nikajkavas. ");
INSERT INTO nsu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato ijkó okinmilvi, porke nochi xivitl itech ilvitl de Pascua in tekivajkeh romanos okipiayah kostumbre de okikajkavayah se de tlen tzaktokeh telpiloya. ");
INSERT INTO nsu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nochtin ope tzajtzih chikavak: —¡Ma miki yejón tlakatl! ¡Xikajkava in Barrabás! ");
INSERT INTO nsu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yejón Barrabás okitzakeh telpiloya porke ompa Jerusalén otetlatlalvi para ipan oyajkeh in kobierno, iva noijki por otemikti. ");
INSERT INTO nsu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato oksemi okintlapovi in gentejtih, porke okinekia kikajkavas in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero yejvah oksemi otzajtzikeh chikavak: —¡Xikrusifikaro! ¡Xikrusifikaro! ");
INSERT INTO nsu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ipan eyi welta in Pilato okinmilvi: —¿Tleka? ¿Kox itla okichi tlen amo kuali? Ne amo nikajxilia itla tlajtlakoli kemi para se kixpolos. Nitlanavatis ma kivitekikah iva satepa nikajkavas. ");
INSERT INTO nsu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yejvah okachi otzajtziah chikavak, okijtovayah ma kikrusifikarokah. Sa tlawel otzajtziah chikavak asta kan omochi tlen yejvah okinekeh. ");
INSERT INTO nsu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ijkuakó Pilato okichi tlen yejvah okinekeh. ");
INSERT INTO nsu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Okikajka in tlakatl tlen yejvah okitlajtlankeh, tlen otzaktoka por ipan oyá in kobierno iva por otemikti. Iva Pilato okinmaktili in Jesús para ma kitoktikah san tlen yejvah kinekiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ijkuak yokivikayah in Jesús para kikrusifikaroskeh, ijkuakó okitzakuilijkeh se tlakatl de Cirene itoka Simón, tlen ovalaya de tlala, iva okichikavilijkeh ma kivika ma kikechpanojtiv in krus ikuitlapan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Miekeh gentejtih okiseguirovayah in Jesús, iva noijki okitokayah miekeh sivameh tlen otzajtziah iva ochokayah de neyolkokoli por Ye. ");
INSERT INTO nsu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesús onmokuapki okoninmitak iva okinmilvi: —¡Sivameh de Jerusalén! Amo xichokakah por Ne, sino xichokakah por imejvah iva por inmopilvah. ");
INSERT INTO nsu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porke ajsis tonali ijkuak ijkí mijtos: “Ma pakikah in sivameh tlen amo velih kinpiah inkonevah, tlen amo kema okinpixkeh inkonevah iva tlen amo kema otlachichitijkeh.” ");
INSERT INTO nsu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ijkuakó in gentejtih pevas kinmilviskeh in tepemeh: “Topah xivetzikih”, iva kinmilviskeh in lomajtih: “Techtlaatikah.” ");
INSERT INTO nsu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tla Ne ijkí nechixpolovah tlen amitla onikchi, ¿tlán amo velis kinpanos tlen kichivah tlen amo kuali? ");
INSERT INTO nsu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Noijki okinvikayah ome tlakah tlen ichtekeh iva temiktijkeh, okinvikayah para kinmixpoloskeh itech krus ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ijkuak oajsitoh kan kilviah Mikatzontekomatl, ompa okikrusifikarojkeh in Jesús, iva noijki ompa okinkrusifikarojkeh tlen omen tlakah amo kualmeh, se ik iyekmapa iva oksé ik iopochmapa. ");
INSERT INTO nsu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús okijto: —NoTajtzi, xikintlapojpolvi, porke amo kimatih tlen kichivah. In soldadojtih omotlatlaankeh para kittaskeh tlán kimokaviskeh kada se de yejvah de itzotzol in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Miekeh gentejtih ompa okitlajtlatokah in Jesús. In tlayakankeh judiojtih san okiwetzkiliayah, okijtovayah: —Okinmakixti oksekimeh. Axka Ye inevia ma momakixti, tla yi neli yen Cristo tlen Dios okipejpenki. ");
INSERT INTO nsu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","In soldadojtih noijki san okiwetzkiliayah in Jesús. Omotokijkeh inavak iva okimakakeh ma koni vino xokok, ");
INSERT INTO nsu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","iva okilvijkeh: —Tla te tiwei tlanavati de judiojtih, te monevia ximomakixti. ");
INSERT INTO nsu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iva ik tlakpak de kan ikrus in Jesús okipiaya se letrero ijkuilitok ika tlajtoli griego, latín iva hebreo, kijtojtok: “NIN YEN WEI TLANAVATI DE JUDIOJTIH.” ");
INSERT INTO nsu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Se de yejonmeh omeh tlen amo kualmeh tlen ompa okrusifikaritoka, noijki fiero okilviaya in Jesús. Okilvi: —Tla te tiCristo, monevia ximomakixti, iva tejvah noijki techmakixti. ");
INSERT INTO nsu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero tlen oksé iyolikni okajvak iva okilvi: —¿Amo tikimakasi in toYejwatzi, maski noijki tika itech nin tlajyovilistli? ");
INSERT INTO nsu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tejvah totech povi titlajyoviskeh porke amo kuali tlen otikchijkeh, pero nin tlakatl amitla okichi. ");
INSERT INTO nsu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iva okilvi in Jesús: —Jesús, techilnamiki ijkuak pevas titlanavatis. ");
INSERT INTO nsu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús okilvi: —Yi neli nimitzilvia, axka tietos nova kan tlaxochiojka itech ilvikak. ");
INSERT INTO nsu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Desde tlajko tonali iva asta las tres de tiotlaki, otlayovak itech nochi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","In tonali ayakmo otlavi, iva in tzotzoltlatzakuili de kan templo otlajkotzayanki. ");
INSERT INTO nsu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ijkuakó Jesús otzajtzik chikavak, okijto: —NoTajtzi, itech momatzi niktlalia notonal. Ijkuak otlanki ijkó okijto, oixpolivik. ");
INSERT INTO nsu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ijkuak in kapita romano okittak tlan opanolok, okiweijkachi in Dios, okijto: —Nin tlakatl yi neli okatka tlakamela. ");
INSERT INTO nsu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nochtin gentejtih tlen ompa okatkah tlen okittakeh nochi tlen opanolok, omokuapkeh para inkalijtik moelpanwitektivih de neyolkokoli. ");
INSERT INTO nsu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero nochtin tlen invah omixmatia in Jesús, iva in sivameh tlen ovalajkeh ivan Jesús desde Galilea, san wejka omokajkeh konitokeh nochi yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Okatka se tlakatl itoka José, de altepetl Arimatea tlen kajki itech tlali de Judea. Okatka kuali tlakatl iva tlakamela, iva okichiaya keman pevas tlanavatis in Dios. José teva opovia itech injunta in judiojtih, iva tlen oksekimeh de yejón junta ijkuak okijtojkeh kixpoloskeh in Jesús, ye amo okatka de akuerdo. ");
INSERT INTO nsu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José oyá okittato in Pilato iva okitlajtlanili ma kimaka ikuerpo in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Satepa de okitemovi de itech krus, okemilo ika se sábana iva okitlali kan se mikatekochtli tlen okichkuakeh ikxitlan se tepejxitl, iva ompa ayamika okitookayah. ");
INSERT INTO nsu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iva itech yejón tonali okatka ijkuak motlayektlaliliah in judiojtih, porke yopevaskia in sábado. ");
INSERT INTO nsu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","In sivameh tlen okiseguirovayah in Jesús desde Galilea, oyajkeh ivan José, iva okittakeh in mikatekochtli iva okittakeh kenik okitlalijkeh ikuerpo in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ijkuak omokuapkeh para inkalijtik, okiyektlalijkeh seki tlapajyotl ajviak iva aseite tlen ajviak para kixaviliskeh ikuerpo in Jesús. Iva ijkuak oajsik sábado, omosevijkeh ijkó kemi kijtova itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tlen primer tonali de yejón samana, in sivameh omokuapkeh kan mikatekochtli seppa kualka, okivikayah in tlapajyotl ajviak tlen okiyektlalijkeh. Oksekimeh sivameh noijki invah oyayah. ");
INSERT INTO nsu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ijkuak oajsitoh, okajsitoh in tetl tlen ika otentzaktoka in mikatekochtli, yokatka ik se lado. ");
INSERT INTO nsu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iva ijkuak okalakeh tlatlaijtik, ayakmo okajsikeh ikuerpo in toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ayakmo okimatiah tlán kichivaskeh, iva ijkuakó okinmitakeh ome tlakah moketokeh ik innakastla, otlakentokah ika intlaken petlantok. ");
INSERT INTO nsu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","In sivameh omomavtijkeh iva omixtlapachojkeh ipan tlali. Iva yejonmeh tlakah okinmilvijkeh in sivameh: —¿Tleka inkitemovah kan mikameh se tlen yolitok? ");
INSERT INTO nsu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús amo nika kajki. Ye yomoyoliti. Xikilnamikikah tlen yomechilvih ijkuak ok okatka Galilea. ");
INSERT INTO nsu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Okijto ke iKone in Tlakatl, okitemaktiskiah inmak tlen tlajtlakolejkeh, iva okikrusifikaroskiah, iva ipan eyi tonali omoyolitiskia. ");
INSERT INTO nsu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ijkuakó in sivameh okilnamikeh tlen Jesús okinmilvi. ");
INSERT INTO nsu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Okiskeh de kan mikatekochtli, iva oyajkeh kan okatkah in majtlaktli ivan se momachtijkeh iva nochtin tlen oksekimeh, iva okinmatiltijkeh nochi yejón tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yejonmeh sivameh kijtosneki yen María tlen de altepetl Magdala, Juana, María imama in Jacobo, iva oksekimeh sivameh. Yejvah okinmilvijkeh in tiotlatitlaniltih nochi tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero amo okinneltokilijkeh, porke okiyejyekojkeh ke nochi tlen okijtovayah in sivameh yejón san puro lokojyotl iva amo yi neli. ");
INSERT INTO nsu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedro okistevak omotlelo oyá kan mikatekochtli. Iva ijkuak ompa oajsito, oontlachixki ik tlatlaijtik, okinmitak san yen tzotzoltih ompa okatkah. Satepa omokuapki para kalijtik iva omotlajtlaniaya tlán kijtosneki tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Itech yejón mismo tonali, ome tlakah tlen onemiah ivan Jesús, onejnentiayah itech ojtli oyayah para kan altepetl de Emaús, tlen okatka de wejka kana majtlaktli ivan se kilómetro de Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Omotlapovijtiayah de nochi tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iva mientras omotlapovijtiayah, Jesús omotoki innavak iva ope nejnemi invah. ");
INSERT INTO nsu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero yejvah amo okiyekixmatkeh, porke Dios amo okinkavili ma kiyekixmatikah. ");
INSERT INTO nsu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ijkuakó Jesús okintlajtlani: —¿De tlán inmotlapoviah mientras innejnemih? ¿Tleka inmoyolkokovah? ");
INSERT INTO nsu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Se de yejvah tlen itoka Cleofas, okinankili: —¿De nochtin tlen ovalajkeh de okseka ompa Jerusalén, san yen tejwatzi amo tikmati tlán opanolok itech ninmeh tonaltih? ");
INSERT INTO nsu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús okintlajtlani: —¿Tlán opanolok? Iva yejvah okinankilijkeh: —Tlen okipanok in Jesús de Nazaret. Para toYejwatzi Dios iva para nochtin gentejtih Ye okatka se wei tiotenejmachti. Ye okijto iva okichi miek tlamantli ika ivelitilis. ");
INSERT INTO nsu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","In tlayakankeh tiopixkeh ivan totlayakankavah okitemaktijkeh para ma kixpolokah, iva okikrusifikarojkeh. ");
INSERT INTO nsu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tejvah otikchiayah Ye kimakixtis topaís de Israel. Pero axka, yi kipia eyi tonali de ijkó opanolok. ");
INSERT INTO nsu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Maski sekimeh sivameh tlen tovah povih sa otechtlatlachialtijkeh de tlen otechmatiltijkeh, porke oyajkeh san kualka kan mikatekochtli, ");
INSERT INTO nsu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","iva komo amo okajsikeh ikuerpo in Jesús, ovalajkeh kalijtik. Iva kijtovah ke okinmonextilijkeh sekimeh ilvikaktlatitlaniltih, tlen okinmilvijkeh ke Jesús yolitok. ");
INSERT INTO nsu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sekimeh tlakah tlen tovah povih oyajkeh kan mikatekochtli, iva okajsitoh ijkó kemi okijtojkeh in sivameh, pero amo okittakeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ijkuakó Jesús okinmilvi: —¡Sa tlawel intzontemeh! ¿Tleka sa tekitl ovi imechkitzkilia para inkineltokaskeh tlen okijtojkeh in tiotenejmachtijkeh? ");
INSERT INTO nsu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Amo okipiaya de tlajyovis in Cristo itech nochi in yejón tlamantli antes de kalakis itech imavissotlanex? ");
INSERT INTO nsu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ijkuakó Jesús ope kinyekilvia tlen kijtova in Tiotlajkuiloli kan tlapova de Ye. Achto okinyekilvi tlen okijkuilo Moisés iva satepa okinyekilvi nochi tlen okijkuilojkeh in tiotenejmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ijkuak oajsitoh kan altepetl kan yejvah oyayah, Jesús okichi kemi oyeskia yavi okachi wejka. ");
INSERT INTO nsu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero yejvah okitlatlavtijkeh ma mokava invah. Okilvijkeh: —Ximokava tovah, porke yotiotlakik, iva yi tlayovas. Tonses, Jesús oyá invah para inkalijtik. ");
INSERT INTO nsu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iva ijkuak invah yoyetoka kan mesa, okontilanki in pan iva okitlasojkamatki inavak Dios, satepa okipojpostekki iva okinmajmakak. ");
INSERT INTO nsu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iva san nima ijkuakó Dios okinmititi nik yen Jesús iva okiyekixmatkeh. Pero Ye san ovalpolivik. ");
INSERT INTO nsu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iva ovalmotlapovijkeh entre yejvah: —Tejvah otikmachiliayah miek pakilistli itech toyolo nepa itech ojtli mientras otechtlapovijtivalaya, iva otechyekilviaya tlen kijtova in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iva san nima ijkuakó omokuapkeh para Jerusalén. Iva okinmajsitoh in majtlaktli ivan se momachtijkeh ivan tlen ompa invah ololitokah. ");
INSERT INTO nsu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iva tlen ololitokah okinmilvijkeh: —Yi neli omoyoliti in toTeko, iva in Simón noijki yokittak. ");
INSERT INTO nsu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ijkuakó, tlen ome tlakah noijki ope kintlapoviah de tlen okinpanok itech ojtli, iva kenik okiyekixmatkeh in Jesús ijkuak okipojpostekki in pan. ");
INSERT INTO nsu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ijkuak ok otlapojtokah de yejón tlamantli, ijkuakó Jesús ovalmonexti ik tlatlajko iva okintlajpalo. Okinmilvi: —Xiekah ika kuali. ");
INSERT INTO nsu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yejvah sa tlawel omomajmavtijkeh, porke yejvah okiyejyekojkeh okittakeh se ejekatl. ");
INSERT INTO nsu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús okinmilvi: —¿Tleka inmomavtiah? ¿Tleka inmoyoloomeviah? ");
INSERT INTO nsu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xikinmitakah nomavah ivan nokxivah. Yen Ne. Techmachilikah iva techitakah. Porke se ejekatl amo kipia inakayo nion iomio, pero Ne nikpia. ");
INSERT INTO nsu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ijkuak ijkó okinmilvi, okinmititi imavah iva ikxivah. ");
INSERT INTO nsu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yejvah sa otlatlachixkeh iva opakeh iva asta amo oveliah okineltokayah kox yen Jesús. Iva Jesús okinmilvi: —¿Kox itla inkipiah tlen nikmomajsevis? ");
INSERT INTO nsu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ijkuakó okimakakeh se pedaso de michi tlivakki. ");
INSERT INTO nsu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús okiseli iva okikua inmixpa. ");
INSERT INTO nsu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iva satepa okinmilvi: —Xikilnamikikah tlen onimechilvi ijkuak ok onikatka inmovah: nik okipiaya tlen mochivas nochi tlen kajki ijkuilitok de Ne itech itlanavatil Moisés, iva itech intlajkuilol in tiotenejmachtijkeh, iva noijki tlen kijtova in Salmos. ");
INSERT INTO nsu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ijkuakó okintlapoli intlayejyekol para ma kajsikamatikah tlen kijtova in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iva okinmilvi: —Kajki ijkuilitok, ke in Cristo okipiaya de oixpoliviskia, iva ipan eyi tonali omoyolitiskia. ");
INSERT INTO nsu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iva ke kipia de tetlapoviskeh de Ye itech nochi in tlaltikpaktli de ma moyolkuapakah para Dios ma kintlapojpolvi de intlajtlakol. Iva se pevas ik Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imejvah onkittakeh nochi nin tlamantli iva moneki inkitematiltiskeh. ");
INSERT INTO nsu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Axka Ne nimechvaltitlanilis tlen noTajtzi omechilvi kivaltitlanis. Pero ximokavakah nika Jerusalén asta xikselikah in velitilistli tlen vitz de ilvikak. ");
INSERT INTO nsu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Satepa, Jesús okinkixti de Jerusalén iva okinvikak asta Betania. Satepa okinmajkuanki imavah iva okintiochi. ");
INSERT INTO nsu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iva mientras okintiochivaya, ijkuakó ope kinkajtejtiv iva oyá otlejkotia para ilvikak. ");
INSERT INTO nsu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yejvah okimavistilijkeh, iva satepa omokuapkeh para Jerusalén ika miek pakilistli. ");
INSERT INTO nsu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iva nochipa oyayah kan templo okiweijkachivayah in toYejwatzi. Ijkó ma yeto.");
INSERT INTO nsu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antes de oyeskia in tlaltikpaktli, yokatka in Tlajtoli, iva yejón Tlajtoli okatka ivan Dios, iva yen Dios. ");
INSERT INTO nsu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","In Tlajtoli okatka ivan Dios desde ijkuak ope in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iva ika yejón Tlajtoli, Dios okichi nochi tlen onka. Iva tlamo por yejón Tlajtoli, nochi tlen onka amo oyeskia. ");
INSERT INTO nsu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Itech yejón Tlajtoli kajki in nemilistli, iva in nemilistli yen tlavili para kintlavilis in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nin tlavili tlavia kan tlayova, iva in tlayovalotl amo veli kisevia. ");
INSERT INTO nsu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Okatka se tlakatl itoka Juan, tlen Dios okivaltitlanki, ");
INSERT INTO nsu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","para ma yeto kemi testigo iva ma tetlapovi de yejón tlavili, para ijkó nochtin ma kineltokakah. ");
INSERT INTO nsu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan amo yen tlavili, sino Dios okititlanki para ma tetlapovi de yejón tlavili. ");
INSERT INTO nsu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Neká tlen yi neli tlavili yoajsitivalaya itech nin tlaltikpaktli para kintlavilis nochtin tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Neká Tlajtoli yokatka itech nin tlaltikpaktli. Iva por yen Tlajtoli Dios okichi in tlaltikpaktli, pero in tlaltikpaktlakah amo okixmatkeh akin Ye. ");
INSERT INTO nsu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ovala itech nin tlaltikpaktli tlen Ye okichi, pero tlen iaxkavah amo okiselijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero nochtin tlen okiselijkeh iva okineltokakeh, okinkavili ma mochivakah Dios ipilvah. ");
INSERT INTO nsu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Oneskeh kemi Dios ipilvah, pero amo oneskeh kemi ijkuak se tlakatl ivan se sivatl mosetiliah para kipiah inkone, sino oneskeh kemi Dios ipilvah porke otlaneltokakeh inavak. ");
INSERT INTO nsu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iva neká Tlajtoli omokuapki tlakatl iva tovah okatka itech nin tlaltikpaktli. Iva otikittakeh imavistilis, iva yejón mavistilistli kipia san yen iKone toTajtzin Dios, porke otechititi nochi itlasojtlalis iva nochi tlen yi neli melajka. ");
INSERT INTO nsu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan otetlapovi aserka de neká Tlajtoli. Iva chikavak okijtovaya: —Ye nin tlakatl tlen ne onimechilviaya: “In tlakatl tlen vitz satepa de ne, Ye okachi weititok iva amo kemin ne, porke Ye yokatka desde antes de ne ninesis.” ");
INSERT INTO nsu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","De nochi tlen kipia, tinochtin tikselijtivitzeh okachi iva okachi de itlatiochivalis. ");
INSERT INTO nsu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios otechmakak itlanavatil por medio de Moisés. Pero itlasojtlalis iva tlen melajkayotl, ovala por medio de Jesucristo. ");
INSERT INTO nsu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Amo keman íkka kitta Dios, pero iKone tlen san Ye se, tlen noijki Dios iva kajki seppa inavak iTajtzi, Ye otechixmatiltiko in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","In tlayakankeh judiojtih de Jerusalén okintitlankeh sekimeh tiopixkeh iva sekimeh levitas para ma kitlajtlaniitih in Juan akin ye. Iva Juan okinmilvi tlen yi neli: —Mach ne niCristo. ");
INSERT INTO nsu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ijkuakó yejvah oksemi okitlajtlanijkeh: —Tonses, ¿akin te? ¿Te tiElías? Juan okinnankili: —Amo, mach ne. Oksé welta okitlajtlanijkeh: —¿Te tiprofeta tlen tikchixtokeh ma viki? Ye okinnankili: —Amo. ");
INSERT INTO nsu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ijkuakó okilvijkeh: —Tonses, ¿akin te? Moneki techilvi para ijkó velis itla tikinmilviskeh tlen otechvaltitlankeh. ¿Tlán velis techilvis de te? ");
INSERT INTO nsu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan okinnankili: —Yen ne tlen nitetzajtzilia chikavak kan tlavaki: “Xikmelavakah iojviv in toTeko” —ijkó kemi okijto in tiotenejmachti Isaías. ");
INSERT INTO nsu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yejonmeh tlen oviah okittatoh in Juan, yejvah in fariseos okintitlankeh, ");
INSERT INTO nsu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","iva okitlajtlanijkeh: —Tla amo te tiCristo, nion amo te tiElías, nion amo te tiprofeta, tonses, ¿akin omitznavati xitlabautisaro? ");
INSERT INTO nsu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan okinnankili: —Ne nitlabautisarova ika atl, pero imovah kajki se tlen imejvah amo inkixmatih, ");
INSERT INTO nsu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iva yen tlen vitz satepa de ne. Iva ne nion amo notech povi para nikintojtomilis ikakvah. ");
INSERT INTO nsu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nochi nin tlamantli otlamochi itech altepetl Betábara, ik nepa lado de kan weyatl Jordán, kan Juan otlabautisarojtoka. ");
INSERT INTO nsu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Omostlatik, Juan okittak in Jesús ompa vitz inavak, iva okijto: —Xikittakah, yen nin iichkakone in Dios, tlen kinkixtilia intlajtlakol in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ne onimechtlapovi de Ye ijkuak onimechilvi: “Satepa de ne vitz se tlakatl tlen okachi weititok iva amo kemin ne, porke Ye yokatka desde antes de ne ninesis.” ");
INSERT INTO nsu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ne amo onikixmatia, pero Dios onechnavati ma nitlabautisaro ika atl para ke in gentejtih de Israel ma veli kimomakakah kuenta akin Ye. ");
INSERT INTO nsu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan noijki okijto: —Ne onikittak in Tioijyotzintli ovaltemok de ilvikak kemi se palomax, iva omotlaliko ipan Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne ayamo onikixmatia. Pero tlen onechvaltitlanki ma nitlabautisaro ika atl, onechilvi: “Ijkuak tikittas in Tioijyotzintli valtemos iva motlaliki ipan se tlakatl, yen tlabautisaros ika Tioijyotzintli.” ");
INSERT INTO nsu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne yonikittak, iva por eso nimechilvia nik yen iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Omostlatik, Juan tlen tlabautisaro oksemi ompa okatka invan ome tlen okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iva ijkuak okittak ke Jesús ik ompa panova, Juan okijto: —Xikittakah, yen nin iichkakone in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yejonmeh ome momachtijkeh de Juan, san nima ijkuak okikakkeh tlen okijto, oyajkeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús omokuapki iva okinmitak okivaltokayah, iva okintlajtlani: —¿Tlán inkinekih? Yejvah okinankilijkeh: —Rabí —kijtosneki Tlamachti—, ¿kan tichanti? ");
INSERT INTO nsu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iva Jesús okinnankili: —Xivikikah iva xikittakah. Tos oyajkeh ivan Jesús iva okittakeh kan chanti, iva ompa omokajkeh ivan Jesús yejón tonali porke yokatka kemi las kuatro de tiotlaki. ");
INSERT INTO nsu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés, tlen ikni in Simón Pedro, okatka se de yejonmeh tlen okikakkeh tlen okijto in Juan iva satepa okiseguirojkeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés san nima oyá okitemoto ikni Simón, iva okilvi: —Yotikajsikeh in Mesías —kijtosneki Cristo o noso tlen Dios okipejpenki. ");
INSERT INTO nsu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés okivikak ikni Simón inavak Jesús, iva ijkuak Jesús okittak okilvi: —Te tiSimón tiipiltzi in Jonás, pero axka motoka yetos Cefas —kijtosneki Pedro o noso Tetl. ");
INSERT INTO nsu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Omostlatik Jesús okijto yas ik tlali de Galilea. Ompa okittak in Felipe, iva okilvi: —Xiviki nova. ");
INSERT INTO nsu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe okatka de Betsaida, ialtepe in Andrés ivan Pedro. ");
INSERT INTO nsu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe okitemoto in Natanael iva okilvi: —Yotikajsikeh in tlakatl tlen Moisés okijkuilo itech itlanavatil, iva tlen okijkuilojkeh in tiotenejmachtijkeh. Yejón tlakatl yen Jesús ipiltzi in José de altepetl Nazaret. ");
INSERT INTO nsu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael okilvi: —¿Velis kisas itla kuali de Nazaret? Felipe okinankili: —Xiviki, xikittaki. ");
INSERT INTO nsu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ijkuak Jesús okittak in Natanael ompa vitz, okijto: —Nika vitz se tlakatl tlen yi neli israelita, tlen amo kimati tlakajkayava. ");
INSERT INTO nsu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael okitlajtlani: —¿Kenik techixmati? Jesús okinankili: —Ijkuak otikatka itlampa igoskuavitl, antes de mitznotzati in Felipe, Ne ipa yonimitzitak. ");
INSERT INTO nsu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael okilvi: —¡Tlamachti, tejwatzi tiiKone in Dios! ¡Tejwatzi tiwei tlanavati de Israel! ");
INSERT INTO nsu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús okinankili: —¿Techneltoka san por onimitzilvi onimitzitak itlampa igoskuavitl? Velis tikinmitas okachi wejwei tlamantih ke ninmeh. ");
INSERT INTO nsu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús noijki okijto: —Yi neli nimechilvia, imejvah inkittaskeh in ilvikak tlapotok, iva inkinmitaskeh in ilvikaktlatitlaniltih tlejkoskeh iva temoskeh ipan iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Oviptlatik okatka se ilvitl kan monamiktiah itech se altepetl itoka Caná tlen kajki itech tlali de Galilea. Imama in Jesús ompa okatka, ");
INSERT INTO nsu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","iva Jesús ivan momachtijkeh noijki okinminvitarojkeh itech yejón ilvitl. ");
INSERT INTO nsu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ijkuak otlanki in vino, imama Jesús okilvi: —Ayakmo kipiah vino. ");
INSERT INTO nsu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero Jesús okinankili: —Nana, ne mach nikpia tlen nikittas. Ayamo ajsi noora para nimoteititis akin ne. ");
INSERT INTO nsu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero imama in Jesús okinmilvi tlen otlaservirojtokah: —Xikchivakah nochi tlen Ye imechilvis. ");
INSERT INTO nsu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ompa okatkah chikuase xoktzimeh de tetl, ivan kada se xoktzi oakia kemi ochenta o noso sien litros de atl. In judiojtih okinnejnekiah in xoktzimeh para omomajtekiayah ijkó kemi kijtova intlanavatil. ");
INSERT INTO nsu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús okinmilvi tlen otlaservirojtokah: —Xikintemitikah de atl in xoktzimeh. Iva ijkuak yejvah kuali okintemitijkeh, ");
INSERT INTO nsu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús okinmilvi: —Axka xikixtikah seki iva xikvikilikah in tetajchi de ilvitl. Iva yejvah ijkó okichijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","In tetajchi okiyeko in atl tlen omokuapki vino, amo okimatia de kan ovala, okimatiah san yejvah tlen otlaservirojtokah porke yejvah okixtitoh yejón atl. Ijkuakó in tetajchi de ilvitl okinotzki in novio. ");
INSERT INTO nsu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Okilvi: —Miekeh achto kitemakah tlen kuali vino, iva ijkuak yokonikeh miek, ijkuakó kinmakah in vino tlen okachi korriente. Pero te otika tlen kuali vino para tiktemakas satepa. ");
INSERT INTO nsu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ye nin yikinika tetzavkaneskayotl tlen Jesús okichi itech altepetl de Caná de Galilea. Ika yejón tetzavkaneskayotl okiteititi ivelitilis, iva in momachtijkeh okineltokakeh. ");
INSERT INTO nsu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Satepa, Jesús ivan imama, ivan iknivah ivan momachtijkeh oyajkeh kan altepetl de Capernaum iva ompa omokajkeh kana keski tonali. ");
INSERT INTO nsu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ijkuak yi mero ajsiki ilvitl de Pascua, inmilviv in judiojtih, Jesús oyá para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iva kan ikiavak in templo okinmajsito in torojnemakakeh, in ichkanemakakeh ivan palomaxnemakakeh, iva tlen okipatlayah tomi oyetokah kan inmesa. ");
INSERT INTO nsu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús okichi se kuarta iva okinkixti de kan templo ika nochi intorojvah iva inmichkavah. Okintlamochili ipan tlali intomi tlen okipatlayah tomi iva okintlatlamochili inmesajvah. ");
INSERT INTO nsu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iva okinmilvi tlen okinnemakatokah palomaxtih: —¡Xikinkixtikah de nika! ¡Amo xikuapakah kemi tiankistli ikalijtik in noTajtzi! ");
INSERT INTO nsu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ijkuakó, in momachtijkeh okilnamikeh ke itech Tiotlajkuiloli ijkuilitok: “In tlasojtlalistli tlen nikpia por mokalijtik nechtlatia kemi se tlitl.” ");
INSERT INTO nsu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ijkuakó in judiojtih okitlajtlanijkeh: —¿Tlán tetzavkaneskayotl velis techititis para tikittaskeh nik yompa tlen tikchiva? ");
INSERT INTO nsu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús okinnankili: —Xikxitinikah nin templo iva san ika eyi tonali oksemi niketzaltis. ");
INSERT INTO nsu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ijkuakó in judiojtih okilvijkeh: —Nin templo owejkajkeh okichijkeh ika ompoali ivan chikuase xivitl. ¿Iva te tikijtova san ika eyi tonali velis tiketzaltis oksemi? ");
INSERT INTO nsu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero in templo tlen Jesús okijtovaya, kijtosneki yen ikuerpo. ");
INSERT INTO nsu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Por eso, ijkuak Jesús omoyoliti, in momachtijkeh okilnamikeh tlen okijtojka, iva okineltokakeh tlen kijtova in Tiotlajkuiloli iva tlen Jesús okimilvijka. ");
INSERT INTO nsu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ijkuak Jesús okatka Jerusalén itech ilvitl de Pascua, miekeh okineltokakeh porke okimitakeh okinchivaya wejwei tetzavkaneskayomeh. ");
INSERT INTO nsu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús mach omokonfiarovaya de yejvah, porke Ye okinmixmatia itech inyolo. ");
INSERT INTO nsu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mach omonekia íkka ma kilvi tlán kiyejyekovah in tlaltikpaktlakah, porke Ye kuali yokimatia tlán kipiah itech inyolo. ");
INSERT INTO nsu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Okatka se tlakatl fariseo itoka Nicodemo, okatka se de tlen tlayakankeh judiojtih. ");
INSERT INTO nsu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo oyá okittato in Jesús de yovak, iva okilvi: —Tlamachti, kuali tikmatih nik Dios omitzvaltitlanki techmachtiki, porke amo oveliskia otikinchivaskia ninmeh tetzavkaneskayomeh, tla Dios amo mova oyeskia. ");
INSERT INTO nsu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús okilvi: —Yi neli nimitzilvia, akin amo nesis oksemi, amo velis kittas kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo okitlajtlani: —Pero ¿kenik velis se tlakatl nesis oksemi tla yi veve? ¿Kox velis oksé welta kalakis ijtik imama iva nesis oksemi? ");
INSERT INTO nsu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús okinankili: —Yi neli nimitzilvia, akin amo nesis de atl iva de Tioijyotzintli, amo velis kalakis kan Dios tlanavatia. ");
INSERT INTO nsu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ijkuak nesi se konetl, kipia inakayo iva iomio kemi itajvah, pero tlen nesi de Tioijyotzintli, kijtosneki nesi ika se yankuik nemilistli de Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo sa xitlatlachia por nimitzilvia: “Nochtin kipiah de nesiskeh oksemi.” ");
INSERT INTO nsu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","In ejekatl yavi san kan ye kineki. Iva tikkaki ijkoyuka, pero amo tikmati kan valeva iva nion kan ik yavi. Ijkó noijki nochtin tlen nesih itech Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo oksemi okitlajtlani in Jesús: —¿Iva yejón kenomi? ");
INSERT INTO nsu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús okinankili: —¿Te tiwei titlamachti de Israel iva amo tikajsikamati? ");
INSERT INTO nsu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yi neli nimitzilvia, tejvah tikijtovah tlen tikmatih, iva titetlapoviah de tlen yotikittakeh, pero imejvah amo inkineltokah tlan timechilviah. ");
INSERT INTO nsu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tla Ne nimechtlapovia itla tlamantli tlen tlamochiva itech nin tlaltikpaktli, iva amo innechneltokah, ¿kenik velis innechneltokaskeh tla nimechtlapovis tlen tlamochiva itech ilvikak? ");
INSERT INTO nsu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Mach ika semi tlejko ilvikak, sino san yen tlen ovaltemok de ilvikak, kijtosneki, yen iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iva ijkó kemi Moisés okajkuanki in kovatl kan tlavaki, ijkó noijki moneki kajkuanaskeh iKone in Tlakatl, ");
INSERT INTO nsu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","para nochtin tlen kineltokaskeh amo ma moixpolokah, sino ma yolitokah para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dios sa tlawel kintlasojtla in tlaltikpaktlakah, iva por eso okitemakak tlen san Ye se iKone, para nochtin tlen kineltokaskeh amo ma moixpolokah, sino ma kipiakah nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios amo okivaltitlanki iKone para kintlajtlakoltis in tlaltikpaktlakah, sino okivaltitlanki para ma kinmakixti. ");
INSERT INTO nsu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Tlen kineltoka iKone toTajtzin Dios, amo kitlajtlakoltiskeh. Pero tlen amo kineltoka, Dios kitlajtlakoltis porke amo kineltoka tlen san Ye se iKone toTajtzin Dios. ");
INSERT INTO nsu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tlen amo kineltokah, Dios kintlajtlakoltis, porke in tlavili ovala itech nin tlaltikpaktli, pero in tlaltikpaktlakah okachi okivelitakeh yeskeh kan tlayova iva amo kan tlanestok, porke kichivah tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nochtin tlen kichivah tlen amo kuali, kijtosneki kikualankaitah in tlavili iva amo motokiah kan tlavili, para amo ma motta nik amo kuali tlen kichivah. ");
INSERT INTO nsu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero tlen kichivah tlen melajkayotl motokiah kan tlavili, para ma motta nik kichijtokeh tlen Dios kimonekiltia. ");
INSERT INTO nsu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Okachi satepa, Jesús ivan momachtijkeh oyajkeh itech tlali de Judea, iva ompa omokajkeh kana keski tonali, iva okinbautisaro miekeh tlakah. ");
INSERT INTO nsu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan noijki otlabautisarojtoka itech altepetl de Enón, tlen kajki inakastla in altepetl de Salim, porke ompa okatka miek atl. Iva miekeh gentejtih oyayah inavak Juan iva ye okinbautisarovaya. ");
INSERT INTO nsu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Itech yejonmeh tonaltih Juan ayamo okitzakuayah telpiloya. ");
INSERT INTO nsu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ijkuakó sekimeh momachtijkeh de Juan ope motlatlajtolnamikih ivan sekimeh judiojtih de kenik se moyolchipavas inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ijkuakó okilvitoh in Juan: —Tlamachti, in tlakatl tlen okatka mova ik nepa lado de kan weyatl Jordán, de tlen tejwatzi otechtlapovi, axka noijki yi tlabautisarova, iva nochtin yope yavih inavak. ");
INSERT INTO nsu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan okinnankili: —Se tlakatl amo velis itla kichivas tla Dios amo kinavatia ma kichiva. ");
INSERT INTO nsu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imejvah mismo onnechkakeh onimechilvi nik mach ne niCristo, sino Dios onechvaltitlanki antes de vitz in Cristo. ");
INSERT INTO nsu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kan monamiktiah, in novio kajki inakastla in novia, iva iyolikni in novio paki sa tlawel ijkuak kikaki tlapova in novio. Ijkó ne noijki axka nipaki porke nika kajki in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ye okachi moweichijtias, iva ne nitemotias ayakmo niweititos. ");
INSERT INTO nsu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Tlen ovala de ilvikak amo onka oksé kemi Ye porke Ye okachi tlayakantok itech nochi. In tlaltikpaktlakah, tlapovah de tlen onka itech nin tlaltikpaktli. Pero tlen ovala de ilvikak amo onka oksé kemi Ye porke Ye okachi tlayakantok itech nochi. ");
INSERT INTO nsu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ye kitematiltia de tlen yokittak iva tlen yokikakki, pero amika kineltokilia tlen Ye kijtova. ");
INSERT INTO nsu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero tlen kineltokilia, kajsikamati nik in Dios kijtova tlen yi neli melajka. ");
INSERT INTO nsu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iva ijkuak iKone in Dios tlajtova, kijtosneki yen Dios techtlapovia, porke in Tioijyotzintli kajki itech iKone ika nochi ivelitilis porke Dios mach kitemaka iTioijyotzi san tzikitzi. ");
INSERT INTO nsu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ToTajtzin Dios kitlasojtla iKone, iva okimakak ma kinavati nochi tlen onka. ");
INSERT INTO nsu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tlen kineltokas iKone toTajtzin Dios yolitos para semijkak. Pero tlen amo kineki kineltokas iKone toTajtzin Dios, mach yolitos para semijkak sino ipan vitz ikualanilis in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesús okimatki ke in fariseos yope motlapoviah de Ye. In fariseos okimatkeh nik yope okachi momiekiliah in momachtijkeh de Jesús iva okachi miekeh yokinbautisarovaya ke Juan. ");
INSERT INTO nsu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero mach yen Jesús okinbautisarovaya, sino tlen okinmachtiaya. ");
INSERT INTO nsu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Por eso, ijkuak Jesús okimatki tlen omotlapoviayah, okiski itech tlali de Judea iva omokuapki oksemi itech tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iva Jesús okipiaya tlen panos ik tlali de Samaria. ");
INSERT INTO nsu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ijkó pues, Jesús oajsito itech se altepetl de Samaria itoka Sicar, serka de kan tlali tlen yi wejkavitl Jacob okimakak ipiltzi José. ");
INSERT INTO nsu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ompa kan okatka in poso de Jacob. Jesús osotlavak de onejnenki iva omotlali inakastla yejón poso. Okatka kemi tlajko tonali. ");
INSERT INTO nsu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mientras in momachtijkeh oyajkeh itech se altepetl okikovatoh tlen kikuaskeh. Ijkuakó se sivatl de Samaria ovala okikixtiko atl kan poso. Iva Jesús okilvi: —Techtliokoli seki moatzi. ");
INSERT INTO nsu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","In sivatl de Samaria okinankili: —¿Tleka techtlajtlanilia ma nimitzmaka atl? ¿Amo tikmati ke ne de Samaria iva tejwatzi de Judea? (Ijkó okijto porke in judiojtih amo movikah ivan samaritanos.) ");
INSERT INTO nsu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iva Jesús okinankili: —Te mach tikmati tlen Dios kineki mitzmakas ivan amo tikmati akin mitztlajtlanilia atl. Tla otikmatiskia, tonses te otiktlajtlaniliskia yen ma nimitzmaka atl, iva ye onimitzmakaskia atl tlen kitemaka nemilistli. ");
INSERT INTO nsu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","In sivatl okilvi: —Tejwatzi, in poso sa tlawel wejkatla iva amo tikpia tlan ika tikixtis atl. ¿Kan tikuiti in atl tlen kitemaka nemilistli? ");
INSERT INTO nsu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tlen yowejka oyá tokojkol Jacob otechkajtevili nin poso. Ye ivan ipilvah ivan iyolkavah nika oatlikeh. ¿Tejwatzi okachi tiweititok ke Jacob? ");
INSERT INTO nsu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús okinankili: —Nochtin tlen nika atlih, oksemi amikiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero tlen konis atl tlen Ne nikmakas, mach ok semi amikis. Porke in atl tlen Ne nikmakas yetos kemi se ameyali tlen meyatos itech iyolo iva kimakas nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ijkuakó in sivatl okilvi: —Tejwatzi, techmaka yejón atl para ayakmo semi namikis, iva ayakmo semi ma nikixtiki atl ijtik nin poso. ");
INSERT INTO nsu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús okilvi: —Xivia xiknotzati mototata iva nika xikvalika. ");
INSERT INTO nsu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","In sivatl okinankili: —Ne mach nikpia nototata. Jesús okilvi: —Yi neli tlen tikijtova, nik amo tikpia mototata. ");
INSERT INTO nsu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porke yotikinpapatlak makuiltih tlakah, iva tlen axka ivan tika noijki amo mototata. Yi neli tlen tikijtova. ");
INSERT INTO nsu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","In sivatl okilvi in Jesús: —Tejwatzi nesi kemi titiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tlen achto tokojkolvah okiweijkachivayah in Dios itech nin tepetl. Pero imejvah tlen de Judea inkijtovah ke tikpiah de tikweijkachivaskeh in Dios kan siudad de Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús okinankili: —Sivatl, moneki techneltoka. Ajsis tonali, mach ok monekis invitzeh itech nin tepetl, iva nion mach ok monekis inyaskeh asta Jerusalén para ompa inkiweijkachivativih in toTajtzin Dios. ");
INSERT INTO nsu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imejvah insamaritanos mach inkimatih akin inkiweijkachivah, pero tejvah tijudiojtih tikmatih akin tikweijkachivah, porke por yejvan judiojtih ovala itlajtol in Dios para ma kimatikah in tlaltikpaktlakah kenik velis momakixtiskeh de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero ajsis tonali ijkuak in tlaltikpaktlakah kiweijkachivaskeh in toTajtzin Dios ika Tioijyotzintli iva ika melajkayotl, iva axka yejón tonali yoajsiko. ToTajtzin Dios kineki ijkó ma kichivakah tlen kiweijkachivah. ");
INSERT INTO nsu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Ye Tioijyotzintli, iva tlen kiweijkachivah moneki ma kiweijkachivakah ika Tioijyotzintli iva ika melajkayotl. ");
INSERT INTO nsu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","In sivatl okilvi: —Ne nikmati nik vitz in Mesías —kijtosneki Cristo—, iva ijkuak Ye vitz, techajsikamatiltis nochi tlamantli. ");
INSERT INTO nsu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús okinankili: —Neká yen Ne, tlen axka nika mova nimotlapovijtok. ");
INSERT INTO nsu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ijkuakó oajsikoh in momachtijkeh iva sa otlatlachixkeh ijkuak okittakeh in Jesús motlapovijtok ivan se sivatl. Pero amika omixevi okitlajtlani tlán okinekia yejón sivatl, o noso de tlán omotlapoviayah. ");
INSERT INTO nsu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ijkuakó in sivatl okikajte iaxoktzi iva oyá totoka kan altepetl okinmilvito in gentejtih: ");
INSERT INTO nsu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Xivikikah, xikittakih se tlakatl tlen onechilvi nochi tlen onikchi. ¡Xamo yen Cristo! ");
INSERT INTO nsu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ijkuakó in gente de yejón altepetl okiskeh okittatoh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yejón ora in momachtijkeh okitlatlavtiayah in Jesús: —Tlamachti, ximotlamajsevi. ");
INSERT INTO nsu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Ye okinmilvi: —In tlakuali tlen Ne nikmomajsevis imejvah amo inkixmatih. ");
INSERT INTO nsu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ijkuakó in momachtijkeh ope motlatlajtlaniah: —¿Xamo íkka itla okaviliko tlen kikuas? ");
INSERT INTO nsu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús okinmilvi: —Notlakual kijtosneki ma nikchiva tlen kimonekiltia tlen onechvaltitlanki, iva ma niktlami in tekitl tlen Ye onechnavati ma nikchiva. ");
INSERT INTO nsu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ijkuak intookah imejvah inkijtovah: “Ok polivi navi metztli para se pixkas.” Pero Ne nimechilvia: Kuali xikintlapokah inmoixtololovah iva xikinmitakah in gentejtih, kateh kemi oyeskia se tlali kan tlamanik kan yotlachikavak iva yi kuali ka para se pixkas. ");
INSERT INTO nsu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tlen pixka kipia itlaxtlavil, iva in tlakilotl tlen kipixka yejvan gentejtih tlen yolitoskeh para semijkak. Iva ijkó, tlen tookas iva tlen pixkas, san sekka pakiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yi neli kemi kijtova in tlajtoli: “Se tooka iva oksé pixka.” ");
INSERT INTO nsu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ne onimechtitlanki xipixkatih kan imejvah amitla onmotekimakakeh ontookakeh. Oksekimeh otlajyovijkeh otekipanojkeh, pero axka imejvah sa inkipakittah tlen yejvah yokichijkeh ika intekiv. ");
INSERT INTO nsu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Miekeh samaritanos otlaneltokakeh inavak Jesús porke in sivatl okinmilvi: “Ye onechilvi nochi tlen yonikchi.” ");
INSERT INTO nsu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Por eso ijkuak in samaritanos ovalajkeh inavak Jesús, okitlatlavtijkeh ma mokava invah. Iva Ye ompa omoka ome tonali. ");
INSERT INTO nsu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iva okachi miekeh okineltokakeh in Jesús por tlen Ye inevia okinmilvi. ");
INSERT INTO nsu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iva okilvijkeh in sivatl: —Axka tikneltokah amo san por tlen te otechilvi, sino porke toneviah yotikakkeh, iva axka kuali tikmatih nik yi neli yen Cristo, tlen kinmakixtis in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ome tonali satepa, Jesús okiski de Samaria iva oyá kan tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús se welta okijto ke se tiotenejmachti mach kitlakitah itech ialtepe. ");
INSERT INTO nsu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ijkuak Jesús oajsito Galilea, in gentejtih okiselijkeh ika pakilistli, porke in gentejtih de Galilea oviah Jerusalén iva ompa okittakeh nochi tlen Jesús okichi itech ilvitl de Pascua. ");
INSERT INTO nsu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ijkuakó Jesús omokuapki oksemi kan altepetl de Caná tlen kajki itech tlali de Galilea, kan okikuapki vino in atl. Itech altepetl de Capernaum okatka se tekiva tlen otekipanovaya inavak in wei tlanavati, iva okipiaya se ipiltzi mokokova. ");
INSERT INTO nsu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ijkuak in tekiva okimatki nik in Jesús yomokuapato de Judea iva yoajsiko Galilea, oyá para Caná okittato in Jesús. Okitlatlavti ma kivika para Capernaum ma kipajtiliti ipiltzi porke yi mero ixpolivi. ");
INSERT INTO nsu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ijkuakó Jesús okilvi: —Imejvah amo intlaneltokah, tla amo inkinmitah neskayomeh o noso tetzavimeh. ");
INSERT INTO nsu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero in tekiva tlen otekipanovaya inavak in wei tlanavati okilvi: —San nima xiviki tejwatzi antes de ixpolivis nopiltzi. ");
INSERT INTO nsu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ijkuakó Jesús okinankili: —Ximokuapa mokalijtik, mopiltzi yopajtik. In tlakatl okineltokak tlen Jesús okilvi, iva omokuapki para ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ijkuak in tekiva ya onajsia ikalijtik, sekimeh itlakevalvah okinamikitoh iva okilvijkeh: —Mopiltzi yopajtik. ");
INSERT INTO nsu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ijkuakó ye okintlajtlani kemi tlán ora ope mijmati ipiltzi. Iva yejvah okilvijkeh: —Yala, kemi la una de tiotlaki okiski in totonik. ");
INSERT INTO nsu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ijkuakó in teta okilnamiki ke mero itech yejón ora Jesús okilvi: “Mopiltzi yopajtik.” Ye iva nochi ifamilia okineltokakeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ika nin, Jesús yi ojpa okichi yejón tetzavkaneskayotl itech tlali de Galilea, okichi satepa de ovala de kan tlali de Judea. ");
INSERT INTO nsu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Satepa, Jesús oyá Jerusalén iva itech yejonmeh tonaltih in judiojtih okichivayah se ilvitl. ");
INSERT INTO nsu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ompa Jerusalén, serka de kan kilviah kaltentli de ichkameh, okatka se tanke tlen ika tlajtoli hebreo kilviah Betesda, iva kan yejón tanke okatkah makuiltih korredortih. ");
INSERT INTO nsu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ompa ovettokah miekeh kokoxkeh. Ompa okatkah sekimeh tlen amo otlachiayah, sekimeh koxomeh iva sekimeh tlen amo oveliah onejnemiah, yejvah okichiayah ma molini in atl. ");
INSERT INTO nsu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porke san kivalchiva se ilvikaktlatitlanili ovaltemovaya iva okoliniaya in atl, iva san akin achto okalakia, opajtia de san tlan kokolistli. ");
INSERT INTO nsu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ompa ovettoka se tlakatl tlen yokipiaya senpoali ivan kaxtoli ivan eyi xivitl mokokova. ");
INSERT INTO nsu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ijkuak Jesús okittak in kokoxki ompa ovettoka iva okimatki nik yi kipia miek xivitl mokokova, okilvi: —¿Tikneki tipajtis? ");
INSERT INTO nsu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","In kokoxki okinankili: —Tejwatzi, amo nikpia akin nechkalakis ijtik tanke ijkuak molinia in atl. Iva nochipa ijkuak nikneki nikalakis, oksé achto kalaktivetzi. ");
INSERT INTO nsu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús okilvi: —Ximeva, xikololo mopetl iva xinejnemi. ");
INSERT INTO nsu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yejón tlakatl san nima ovalpajtik, okololo ipetl iva ope nejnemi. Pero komo okatka sábado, ");
INSERT INTO nsu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","in tlayakankeh judiojtih okilvijkeh in tlakatl tlen opajtik: —Axka sábado, amo xikmama mopetl porke in tlanavatili amo kitekavilia. ");
INSERT INTO nsu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","In tlakatl okinnankili: —In tlakatl tlen onechpajti onechilvi: “Xikololo mopetl iva xinejnemi.” ");
INSERT INTO nsu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ijkuakó okitlajtlanijkeh: —¿Akin yejón tlakatl tlen omitzilvi: “Xikololo mopetl iva xinejnemi”? ");
INSERT INTO nsu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero in tlakatl tlen opajtik amo okimatia akin okipajti, porke ompa okatkah miekeh gentejtih iva Jesús ayakmo ompa okatka. ");
INSERT INTO nsu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Okachi satepa Jesús oksemi okajsito in tlakatl kan templo iva okilvi: —Techkaki, axka yotipajtik, ayakmo xikchiva tlajtlakoli, porke velis mitzpanos itla oksé tlamantli okachi temavti. ");
INSERT INTO nsu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","In tlakatl oyá okinmilvito in tlayakankeh judiojtih nik yen Jesús okipajti. ");
INSERT INTO nsu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por eso, in tlayakankeh judiojtih san tlen amo ope kitoktiah in Jesús iva okinekiah kixpoloskeh, porke okinchivaya tetzavimeh maski sábado. ");
INSERT INTO nsu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús okinmilvi: —NoTajtzi nochipa tekipanova kichiva tlen kuali, por eso Ne noijki ijkó nikchiva. ");
INSERT INTO nsu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ijkuak ijkó okinmilvi, in tlayakankeh judiojtih okachi okualankeh iva okinekiah kixpoloskeh. Amo okinekiah porke amo okitlakitaya in sábado, iva porke okijtovaya ke in Dios yen iTajtzi, iva por eso Ye noijki Dios. ");
INSERT INTO nsu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús okinmilvi: —Yi neli nimechilvia: iKone in Dios, mach itla velis kichivas san tlen Ye kinekis, sino Ye kichiva tlen kitta kichiva iTajtzi. Nochi tlen kichiva iTajtzi Ye noijki ijkó kichiva. ");
INSERT INTO nsu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ITajtzi kitlasojtla iva kititia nochi tlen Ye kichiva, iva kititis okachi wejwei tlamantih iva amo kemi ninmeh iva imejvah sa intlatlachiaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ijkó kemi iTajtzi kinyolitia tlen yomikkeh iva kinmaka nemilistli, ijkó noijki iKone kinmaka nemilistli tlen Ye kineki kinmakas. ");
INSERT INTO nsu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ITajtzi amo kijtova akin tlajtlakole, sino Ye okitlali iKone yen ma kijto akin tlajtlakole, ");
INSERT INTO nsu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","para ijkó nochtin tlaltikpaktlakah ma kitlakitakah iKone ijkó kemi kitlakitah iTajtzi. Tlen amo kitlakita iKone in Dios, kijtosneki noijki amo kitlakita in iTajtzi tlen okivaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Yi neli nimechilvia: Tlen kikaki notlajtol iva kineltoka tlen onechvaltitlanki, yolitos para semijkak. Ayakmo kitlajtlakoltiskeh, porke yokiski de kan mikilistli iva axka yi kipia yankuik nemilistli. ");
INSERT INTO nsu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yi neli nimechilvia, ajsiki tonali, iva yejón tonali yoajsiko. Axka, tlen kateh kemi oyeskia yomikkeh kikakiskeh itlajtol iKone in Dios, iva tla kichivaskeh tlen kijtova, kipiaskeh nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ijkó kemi iTajtzi kipia nemilistli iva veli kitemaka nemilistli, ijkó noijki okichi ke iKone ma kipia nemilistli iva ma kitemaka nemilistli. ");
INSERT INTO nsu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Noijki okitlali Ye ma kijto akinmeh tlajtlakolejkeh de nochtin gentejtih, porke Ye mochijtok iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo sa ximotlatlachialtikah de tlen nimechilvia, porke ajsis tonali ijkuak nochtin tlen toktokeh kikakiskeh itlajtol, ");
INSERT INTO nsu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","iva kisaskeh de kan toktokeh. Tlen okichijkeh tlen kuali, moyolitiskeh iva yeskeh ivan Dios para semijkak. Pero tlen okichijkeh tlen amo kuali, moyolitiskeh para kintlajtlakoltiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ne amitla nikchiva tlen san Ne ma nikmoyejyekoli. Ne nikijtova akin tlajtlakole ijkó kemi noTajtzi nechilvia. Iva nikijtova akin tlajtlakole ijkó kemi kipia de yetos porke amo nikchiva san tlen Ne nikneki, sino tlen kimonekiltia noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tla onimechtlapoviskia de itla, tlen san Ne notech onikixtiskia, tonses amo ovaleroskia kemi se prueba nik yi neli tlen nimechtlapovia. ");
INSERT INTO nsu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Onka oksé akin tetlapovia de Ne, iva nikmati ke tlen Ye tetlapovia de Ne, yi neli. ");
INSERT INTO nsu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Imejvah onkintitlankeh sekimeh tlakah ma kitlajtlaniitih in Juan akin ye, iva ye okijto tlen yi neli aserka de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero mach moneki íkka tlakatl ma imechilvi akin Ne, sino Ne san nimechilnamiktia tlen Juan okijto para techneltokakah iva ximomakixtikah. ");
INSERT INTO nsu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan okatka kemi se tlavili tlen oxotlatoka iva otlavijtoka, iva imejvah onpakeh kana keski tonali ika itlavil. ");
INSERT INTO nsu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero onka se tlamantli tlen okachi weititok ke tlen okijto in Juan iva yejón tlamantli kijtova akin Ne. Porke nochi tlen noTajtzi onechnavati ma nikchiva, iva tlen yi nikchijtok, nochi yejón tlamantli kiteititia nik yi neli noTajtzi onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","NoTajtzi tlen onechvaltitlanki Ye noijki tlapova aserka de Ne, maski imejvah amo kema inkitenkakih ivan nion amo kema inkittah, ");
INSERT INTO nsu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","iva nion itlajtol amo veli kalaki itech inmoyolo porke imejvah amo inkineltokah tlen Ye okivaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Imejvah kuali inkimomachtiah in Tiotlajkuiloli, iva inkiyejyekovah ke yejón Tiotlajkuiloli imechmakas nemilistli para semijkak. Pero yejón Tiotlajkuiloli tlajtova de Ne, ");
INSERT INTO nsu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","iva imejvah amo inkinekih invitzeh nonavak para inkipiaskeh nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Weijkachivalistli tlen kisa de tlaltikpaktlakah Ne amo nikselia. ");
INSERT INTO nsu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Porke Ne kuali nimechixmati iva kuali nikmati nik mach inkipiah itlasojtlalis in Dios itech inmoyolo. ");
INSERT INTO nsu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne onivala ika itoka noTajtzi, iva imejvah amo innechseliah. Pero tla vitz íkka oksé ika ye itoka, imejvah yej yen okachi inkiseliah. ");
INSERT INTO nsu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imejvah inkivelitah kuali ma imechtlakitakah in tlaltikpaktlakah, pero amo inkitemovah kenik velis imechtlakitas in Dios tlen san Ye se onka. Tonses, ¿kenik velis innechneltokaskeh? ");
INSERT INTO nsu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo xikyejyekokah ke Ne nimechteilvis inavak noTajtzi, sino onka se akin imechteilvis, yen Moisés, porke imejvah inmotenmachiah itech tlen Moisés okijkuilo. ");
INSERT INTO nsu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Porke tla yi neli onkineltokaskiah tlen okijkuilo in Moisés, tonses imejvah onnechneltokaskiah, porke tlen ye okijkuilo tlapova de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tla imejvah amo inkineltokah tlen Moisés okijkuilo, ¿kenik velis inkineltokaskeh tlen Ne nimechilvia? ");
INSERT INTO nsu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Okachi satepa, Jesús oyá ik nepa lado de kan atl tlen wei de Galilea tlen noijki itoka Tiberias. ");
INSERT INTO nsu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Miekeh gentejtih oyayah ivan Jesús, porke okittayah in wejwei tetzavkaneskayomeh tlen okinchivaya ijkuak okinpajtiaya in kokoxkeh. ");
INSERT INTO nsu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús otlejkok itech se tepetl iva ompa omotlali invan momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ijkuakó yi ajsitivitz inmilviv in judiojtih tlen itoka Pascua. ");
INSERT INTO nsu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ijkuak Jesús okittak nik miekeh gentejtih ope vitzeh inavak, okilvi in Felipe: —¿Kan tikovativih pan para tikintlamakaskeh nochtin ninmeh gentejtih? ");
INSERT INTO nsu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ijkó okilvi in Felipe para kittas tlán kijtos, porke Jesús yokimatia tlán kichivas. ");
INSERT INTO nsu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ijkuakó Felipe okinankili: —Tla tikovaskeh ome siento denario de pan, kemi tlen kitlani se tlakatl tlen tlapalevia chikome metztli, amo kajxilis nion para tikinmajmakaskeh ajachitzi. ");
INSERT INTO nsu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ijkuakó Andrés ikni in Simón Pedro, tlen noijki okatka momachti de Jesús, okijto: ");
INSERT INTO nsu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Nika kajki se telpotzintli kipixtok makuili pan de cebada iva ome michimeh, pero amo kajxilis para nochtin. ");
INSERT INTO nsu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ijkuakó Jesús okijto: —Xikinmilvikah nochtin ma motlalikah. Itech yejón lugar okatka sakayo, iva omotlalijkeh kemi makuili mil tlakah. ");
INSERT INTO nsu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ijkuakó Jesús okontilanki in makuili pan iva okitlasojkamatki inavak Dios, satepa okinmakak in momachtijkeh, iva yejvah ope kinxejxeliliah nochtin tlen ompa oyejyetokah. Noijki ijkó okichi ika michimeh, iva nochtin kuali otlakuajkeh asta kan oixvikeh. ");
INSERT INTO nsu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iva ijkuak nochtin yoixvikeh, Jesús okinmilvi in momachtijkeh: —Xikololokah in pedasos tlen osobraro, amitla ma ijtlakavi. ");
INSERT INTO nsu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","In momachtijkeh okololojkeh in pedasos tlen osobraro de yejón makuili pan de cebada, iva okintemitijkeh majtlaktli ivan ome chikimeh. ");
INSERT INTO nsu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iva ijkuak in gentejtih okittakeh in wei tetzavkaneskayotl tlen Jesús okichi, okijtojkeh: —Yi neli, ye nin tiotenejmachti tlen otikchixtokah ma viki itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero Jesús okimomakak kuenta nik yejvah afuersa okinekiah kivikaskeh para ma yeto wei tlanavati. Por eso Jesús oksé welta oyá ipan tepetl para ompa yetos iselti. ");
INSERT INTO nsu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ijkuak yotlayovak, in momachtijkeh otemokeh kan atl tlen wei de Galilea. ");
INSERT INTO nsu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Otlejkokeh itech se barko iva ope nejnemih para panoskeh oksé lado para ajsitivih kan altepetl de Capernaum. Yotlayovak, iva Jesús ayamo yoejkoya. ");
INSERT INTO nsu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ijkuakó ope ejeka chikavak ivan atl ope motlatlaviteki. ");
INSERT INTO nsu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iva ijkuak yoyajkeh kemi se makuili o noso chikuase kilómetro itech atl, okittakeh in Jesús nejnentivitz ixko atl iva yokivalajsia in barko. Yejvah sa tlawel omomavtijkeh, ");
INSERT INTO nsu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","pero Ye okinmilvi: —Amo ximomavtikah, Ne niJesús. ");
INSERT INTO nsu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ijkuakó yejvah opakeh miek iva okitlejkoltijkeh itech barko. Iva san nima oajsitoh kan tlali kan yejvah oyayah. ");
INSERT INTO nsu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Omostlatik, in gentejtih tlen omokajkeh ik nepa lado de kan atl tlen wei, okilnamikeh ke okatka san se barko, iva Jesús amo otlejkok ivan momachtijkeh, porke okinmitakeh ke in momachtijkeh oyajkeh inselti. ");
INSERT INTO nsu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Satepa, oksekimeh barkotih de altepetl de Tiberias, oajsikoh serka kan antes okikuajkeh in pan satepa de ijkuak in toTeko okitlasojkamatki inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Por eso, ijkuak in gentejtih okittakeh ke Jesús amo ompa okatka nion tlen momachtijkeh, otletlejkokeh itech sekimeh barkojtih iva oyajkeh okitemotoh kan altepetl de Capernaum. ");
INSERT INTO nsu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Iva ijkuak okajsitoh in Jesús ik nepa lado de kan atl tlen wei, okitlajtlanijkeh: —Tlamachti, ¿keman otajsiko nika? ");
INSERT INTO nsu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero Jesús okinmilvi: —Yi neli nimechilvia, imejvah innechtemovah amo por onkajsikamatkeh tlán kijtosneki in tetzavkaneskayotl tlen onikchi, sino porke onimechtlamakak iva asta onmixvikeh. ");
INSERT INTO nsu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amo xitekipanokah san por yen tlakuali tlen niman tlami, sino por yen tlakuali tlen amo keman tlami iva kitemaka nemilistli para semijkak. Yejón tlakuali velis imechmakas iKone in Tlakatl, porke toTajtzin Dios imechititia nik san yen iKone velis imechmakas yejón tlakuali. ");
INSERT INTO nsu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yejvah okitlajtlanijkeh: —¿Tlán kineki in Dios ma tikchivakah? ");
INSERT INTO nsu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús okinnankili: —Dios kineki imejvah techneltokakah porke Ye onechvaltitlanki. Yen yejón tlen Dios kineki xikchivakah. ");
INSERT INTO nsu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yejvah okilvijkeh: —¿Tlán tetzavkaneskayotl velis techititis para ma tikittakah iva ma timitzneltokakah? ¿Tlán velis tikchivas? ");
INSERT INTO nsu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tlen achto tokojkolvah okikuajkeh in maná kan tlavaki, ijkó kemi kijtova in Tiotlajkuiloli: “Pan de ilvikak okinmakak ma kikuakah.” ");
INSERT INTO nsu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús okinmilvi: —Yi neli nimechilvia: Mach yen Moisés okinmakak in pan de ilvikak, sino yen noTajtzi okinmakak, yen kitemaka tlen yi neli pan de ilvikak. ");
INSERT INTO nsu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porke in pan tlen Dios kitemaka yen tlen ovaltemok de ilvikak iva kinmaka nemilistli in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ijkuakó yejvah okilvijkeh: —ToTeko, nochipa techmaka yejón pan. ");
INSERT INTO nsu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús okinmilvi: —Ne nipan tlen niktemaka nemilistli. Tlen vitz nonavak ayakmo keman tiojsivis. Iva tlen nechneltokas ayakmo keman amikis. ");
INSERT INTO nsu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero ijkó kemi yonimechilvi, maski imejvah yonnechitakeh amo innechneltokah. ");
INSERT INTO nsu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochtin tlen noTajtzi nechinmakas yejvah nechtemoskeh iva vitzeh nonavak, iva amo nikijtos ke amo nikinselis. ");
INSERT INTO nsu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porke amo onivaltemok de ilvikak para nikchivas san tlen Ne niknekis, sino para nikchivas tlen kimonekiltia noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iva noTajtzi tlen onechvaltitlanki, amo kineki ma nikpolo nion se de nochtin tlen onechinmakak, sino kineki ma nikinyoliti itech neká tonali tlen yetos sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pos tlen kimonekiltia noTajtzi tlen onechvaltitlanki yen nin: ke nochtin tlen kittaskeh iKone in Dios iva tlaneltokaskeh inavak, kipiaskeh nemilistli para semijkak. Iva Ne nikinyolitis itech neká tonali tlen yetos sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ijkuakó in tlayakankeh judiojtih ope tlapovah en kontra de Jesús por okijto: “Ne nipan tlen onivaltemok de ilvikak.” ");
INSERT INTO nsu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iva okijtojkeh: —¿Amo ye nin Jesús, ipiltzi in José? Tejvah tikixmatih ipapa iva imama. ¿Tos kenik kijtova ke ovaltemok de ilvikak? ");
INSERT INTO nsu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús okinmilvi: —Ayakmo techpojpovakah por tlen onimechilvi. ");
INSERT INTO nsu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Amika tlakatl velis vitz nonavak san por kinekis, sino san yen noTajtzi tlen onechvaltitlanki velis kichivas íkka tlakatl ma viki nonavak. Iva Ne nikyolitis itech neká tonali tlen yetos sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Itech intlajkuilol in tiotenejmachtijkeh ijkuilitok: “Dios kinmachtis nochtin.” Por eso, nochtin tlen kikakiskeh noTajtzi iva kajsikamatiskeh tlen kijtova, vitzeh nonavak. ");
INSERT INTO nsu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Amo kijtosneki ke íkka yokittak noTajtzi. San yen tlen ovala kan Ye kajki, yen yokittak. ");
INSERT INTO nsu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yi neli nimechilvia, tlen nechneltoka kipia nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne nipan tlen niktemaka nemilistli. ");
INSERT INTO nsu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tlen achto inmokojkolvah okikuajkeh in pan tlen itoka maná kan tlavaki, iva maski okikuajkeh, oixpolikeh. ");
INSERT INTO nsu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero tlen kikuah in pan tlen valtemotok de ilvikak, amo ixpolivih. ");
INSERT INTO nsu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne nipan tlen niktemaka nemilistli para semijkak tlen onivaltemok de ilvikak. Tlen kikuas nin pan, yolitos para semijkak. Iva nin pan tlen niktemakas, yen nokuerpo, para ijkó in tlaltikpaktlakah velis kipiaskeh nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ijkuakó in judiojtih ope motlatlajtolnamikih, okijtovayah: —¿Kenik velis techmakas ikuerpo ma tikuakah? ");
INSERT INTO nsu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús okinmilvi: —Yi neli nimechilvia: Tla imejvah amo inkikuaskeh ikuerpo in iKone in Tlakatl iva tla amo inkoniskeh iesso, mach velis inkipiaskeh nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tlen kikua nokuerpo iva koni noesso, kipias nemilistli para semijkak, iva Ne nikyolitis itech neká tonali tlen yetos sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porke nokuerpo yi neli tlakuali, iva noesso yi neli tlakonili. ");
INSERT INTO nsu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tlen kikua nokuerpo iva koni noesso, kijtosneki yolitok nonavak iva Ne niyolitok inavak. ");
INSERT INTO nsu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","NoTajtzi tlen onechvaltitlanki yen tlen kitemaka nemilistli iva Ne nikpia nemilistli por Ye. Ijkó noijki tlen kimomajsevis nokuerpo, noijki kipias nemilistli nonavak. ");
INSERT INTO nsu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ne nipan tlen onivaltemok de ilvikak, pero nin pan amo kemi in maná tlen okikuajkeh tlen achto inmokojkolvah iva satepa oixpolikeh. Tlen kikuas nin pan yolitos para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ye nin tlen Jesús okinmachti in gentejtih ompa Capernaum kan tiotlamachtijkali. ");
INSERT INTO nsu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ijkuak ijkó okikakkeh, miekeh tlen onemiah ivan Jesús, okijtojkeh: —Sa tlawel ovijtitok para se kajsikamatis. ¡Akin kineltokilis tlen kijtova! ");
INSERT INTO nsu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús okimatia nik amo okivelitakeh tlen okijto, iva okinmilvi: —¿Inkualanih por tlen nimechilvia? ");
INSERT INTO nsu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tlán inkiyejyekoskeh imejvah tla inkittaskeh iKone in Tlakatl tlejkos ilvikak kan okatka? ");
INSERT INTO nsu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tlen kitemaka nemilistli yen Tioijyotzintli, ikuerpo de se tlakatl amitla kipalevia para kimakas nemilistli. Notlajtol tlen Ne yonimechilvi vitz de yen Tioijyotzintli iva por eso kitemaka nemilistli. ");
INSERT INTO nsu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero sekimeh de imejvah amo innechneltokah. Jesús ijkó okijto porke yokimatia desde antes akinmeh amo kineltokah iva akin kitemaktis. ");
INSERT INTO nsu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iva okijto: —Por eso, nimechilvia nik amika velis vitz nonavak, tla noTajtzi amo kimonekiltis. ");
INSERT INTO nsu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde ijkuakó, miekeh tlen onemiah ivan Jesús okikajkeh iva ayakmo onemiah Iva. ");
INSERT INTO nsu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ijkuakó Jesús okintlajtlani in majtlaktli ivan ome momachtijkeh: —¿Imejvah noijki inkinekih inyaskeh? ");
INSERT INTO nsu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro okinankili: —NoTeko, ¿akin oksé inavak tiaskeh? San yen motlajtol kitemaka nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tejvah tikneltokah iva tikmatih nik tejwatzi tiyolchipavak tiiKone in Dios tlen yolitok. ");
INSERT INTO nsu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ijkuakó Jesús okinnankili: —Ne onimechpejpenki imejvah inmajtlaktih iva inmomeh, pero se de imejvah itlakeval in Amo Kuali Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús otlajtovaya de Judas Iscariote ipiltzi in Simón, porke satepa ye okitemakti in Jesús maski okatka se de yejvah tlen majtlaktli ivan ome momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Satepa de yejón, Jesús onemia itech tlali de Galilea. Mach okinekia nemis itech tlali de Judea, porke ompa sekimeh judiojtih okinekiah kixpoloskeh. ");
INSERT INTO nsu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iva komo yi ajsiki inmilviv in judiojtih tlen itoka ilvitl de Sakakaltih, ");
INSERT INTO nsu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","iknivah in Jesús okilvijkeh: —Amo ximokava nika, xivia kan tlali de Judea, para ke tlen tikinmachtia ma kittakah tlen tikchiva. ");
INSERT INTO nsu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porke se tlen kineki ma kixmatikah, mach kichiva itla tlamantli san ichtaka. Moneki xikinchiva tetzavkaneskayomeh inmixpa nochtin tlaltikpaktlakah para ijkó nochtin ma kittakah tlen tikchiva. ");
INSERT INTO nsu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iknivah in Jesús ijkó okilviayah, porke nion yejvah amo okineltokiliayah. ");
INSERT INTO nsu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ijkuakó Jesús okinmilvi: —Mach ya ajsi noora para nias ompa, pero imejvah san tlan ora velis inyaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","In tlaltikpaktlakah mach velis imechkualankaitaskeh, pero Ne nechkualankaitah porke Ne nikinmilvia ke yejvah kichivah tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Imejvah xiviah ilvitl. Ne mach nias porke mach yi ajsi noora para nias ompa. ");
INSERT INTO nsu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Satepa de ijkó okinmilvi, Jesús ompa omoka itech tlali de Galilea. ");
INSERT INTO nsu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Satepa, ijkuak iknivah in Jesús yoonevakeh ilvitl, Ye noijki oyá pero san ichtaka. ");
INSERT INTO nsu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","In tlayakankeh judiojtih okitemovayah in Jesús ompa itech ilvitl iva omotlajtlaniayah: —¿Kanin kajki neká tlakatl? ");
INSERT INTO nsu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iva miekeh omotlapoviayah de Ye. Sekimeh okijtovayah: “Jesús yi neli tlakamela.” Pero oksekimeh okijtovayah: “Amo, porke san kinkajkayava in gentejtih.” ");
INSERT INTO nsu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero amika omixeviaya tlajtos de Ye teixpa, porke okinmiimakasiah in tlayakankeh judiojtih. ");
INSERT INTO nsu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ijkuak yoyaya tlajko ilvitl, Jesús okalakki kan templo iva ope tlamachtia. ");
INSERT INTO nsu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","In tlayakankeh judiojtih sa otlatlachixkeh iva okijtovayah: —¿Kenomi nin tlakatl sa tlawel kimati miek, iva nion amo omomachti? ");
INSERT INTO nsu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús okinnankili: —Notlamachtilis mach kisa de Ne, sino kisa de yen tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tla íkka kinekis kichivas tlen Dios kimonekiltia, kajsikamatis notlamachtilis kox kisa de Dios, o noso nikijtova san tlen Ne nikmoyejyekolia. ");
INSERT INTO nsu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tlen tlajtova san tlen ye kimoyejyekolia, kijtosneki kineki kuali ma tlajtokah de ye. Pero tlen kineki kuali ma tlajtokah de neká tlen okivaltitlanki, kijtosneki kijtova tlen yi neli iva amo tlakajkayava. ");
INSERT INTO nsu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés omechmakak in tlanavatili, iva nion se de imejvah amo kichiva tlen kijtova yejón tlanavatili. ¿Tleka pues inkinekih innechixpoloskeh? ");
INSERT INTO nsu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","In gentejtih okinankilijkeh: —Te tikpia se amo kuali ejekatl, ¿akin kineki mitzixpolos? ");
INSERT INTO nsu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús okinnankili: —Nochtin imejvah sa intlatlachiah san por onikpajti se kokoxki ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés omechmakak in tlanavatili para ximosirkunsidarokah, maski yejón tlanavatili amo valevatok de Moisés, sino valevatok de inmokojkolvah tlen okachi achto opanokeh. Iva valeva imejvah inkisirkunsidarovah se konetl maski ma yeto sábado. ");
INSERT INTO nsu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Imejvah inkinekih inmokavaskeh kuali itech itlanavatil Moisés iva inkisirkunsidarovah se konetl maski sábado porke mero itech yejón tonali okitokaro mosirkunsidaros, tonses, ¿tleka inkualanih nova por onikpajti se tlakatl ijkuak sábado? ");
INSERT INTO nsu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amo san nima xiktlajtlakoltikah se tlakatl san por imejvah xikmoyejyekolikah, sino xiktlajtlakoltikah tla yi neli inkimatih nik okichi tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ijkuakó sekimeh gentejtih de Jerusalén okimolviayah: —¿Amo ye nin tlakatl tlen kitemojtinemih para kimiktiskeh? ");
INSERT INTO nsu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero, xikittakah, tlapojtok teixpa iva amitla kilviah. ¿Xamo in totlayakankavah yokimomakakeh kuenta ke nin tlakatl yen Cristo? ");
INSERT INTO nsu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero tejvah kuali tikmatih de kan ovala nin tlakatl. Pero ijkuak vitz in Cristo, amika kimatis de kan vitz. ");
INSERT INTO nsu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús otlamachtijtoka kan templo, iva ijkuak ijkó okikakki, okijto chikavak: —¡Imejvah inkijtovah innechixmatih iva inkimatih de kan onivala! Pero Ne amo onivala san por Ne oniknekki, sino onivala porke onechvaltitlanki noTajtzi tlen itech onka tlen melajkayotl, ivan tlen imejvah amo inkixmatih. ");
INSERT INTO nsu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne nikixmati porke Ne onivala de inavak, iva Ye onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ijkuakó okinekiah kikitzkiskeh in Jesús. Pero amika omixevi okikitzki, porke ayamo oajsia iora para kikitzkiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero miekeh okineltokakeh, iva okijtovayah: —Ijkuak vitz in Cristo, ¿kox kinchivas okachi wejwei tetzavkaneskayomeh ke nin tlakatl? ");
INSERT INTO nsu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","In fariseos okikakkeh tlen okijtovayah in gentejtih de yen Jesús, por eso yejvah omotlatlalvijkeh invan tlayakankeh tiopixkeh, iva okintitlankeh sekimeh templojmayoltih para ma kikitzkikah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ijkuakó Jesús okijto: —Ne nietos inmovah sa kana keski tonali, satepa oksemi nimokuapas inavak noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Imejvah innechtemoskeh, pero amo innechajsiskeh, porke mach velis inyaskeh kan Ne nias. ");
INSERT INTO nsu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ijkuakó in tlayakankeh judiojtih omotlajtlaniayah: —¿Kan yas nin tlakatl kan tejvah amo velis tikajsiskeh? ¿Kox yas kan kateh in judiojtih tlen chantih itech oksekimeh países, iva noijki kinmachtis tlen amo judiojtih? ");
INSERT INTO nsu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tlán kijtosneki tlen otechilvi: “Innechtemoskeh pero mach innechajsiskeh, porke mach velis inyaskeh kan Ne nias”? ");
INSERT INTO nsu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sa ik tlami tonali de yejón ilvitl okatka okachi wei ilvitl. Jesús omoketzki iva chikavak okijto: —Tla íkka amiki, ma viki nonavak iva ma atli. ");
INSERT INTO nsu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kemi kijtova in Tiotlajkuiloli, tlen nechneltokas, tonses de itech iyolo kisas atl kemi se weyatl tlen kitemakas nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús ijkó okijto kijtosneki akinmeh kineltokaskeh in Jesús kiseliskeh in Tioijyotzintli. Ijkuakó ayamo ovalaya in Tioijyotzintli porke in Jesús ayamo oyaya para ilvikak ika miek mavistilistli. ");
INSERT INTO nsu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ijkuakó sekimeh tlen ompa okatkah, ijkuak okikakkeh nin tlajtoli, okijtojkeh: —Yi neli, nin tlakatl yen tiotenejmachti tlen otikchixtokah ma viki. ");
INSERT INTO nsu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sekimeh okijtovayah: —Nin yen Cristo. Pero oksekimeh okijtovayah: —Mach neli porke in Cristo mach velis vitz de Galilea. ");
INSERT INTO nsu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","In Tiotlajkuiloli kijtova nik in Cristo kipia tlen valajtos de David, de altepetl de Belén kan ochantia in David. ");
INSERT INTO nsu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ijkuakó, in gentejtih ope moxexelovah porke amo nochtin okineltokayah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sekimeh okinekiah kikitzkiskeh, pero amika omixevi okikitzki. ");
INSERT INTO nsu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","In templojmayoltih, omokuapkeh innavak in fariseos iva innavak in tlayakankeh tiopixkeh, iva okintlajtlanijkeh in templojmayoltih: —¿Tleka amo onkivalikakeh? ");
INSERT INTO nsu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","In templojmayoltih otlanankilijkeh: —¡Amo kema tikkakih nion se tlakatl ma tlajto kemi Ye tlajtova! ");
INSERT INTO nsu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ijkuakó in fariseos okinmilvijkeh in templojmayoltih: —¿Noijki imejvah yomechkajkayah? ");
INSERT INTO nsu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Kox íkka de totlayakankavah o noso íkka de tejvah tifariseos yotitlaneltokakeh inavak Jesús? ");
INSERT INTO nsu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero tlen amo kixmatih itlanavatil Moisés iva tlaneltokah inavak Jesús, Dios kintlajtlakoltis iva kintlajyoviltis. ");
INSERT INTO nsu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Se fariseo itoka Nicodemo, tlen okachi achto ovia okittato in Jesús de yovak, okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Totlanavatil amo techkavilia ma tiktlajtlakoltikah se tlakatl, tla achto amo tikkakih tlan ika kiteilviah. ");
INSERT INTO nsu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yejvah okinankilijkeh: —¿Te noijki xamo tivitz de Galilea? Kuali xikmomachti in Tiotlajkuiloli iva tikittas ke de Galilea amo keman kisa nion se tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Iva ijkuakó nochtin ope yavih para inkalijtik. ");
INSERT INTO nsu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero Jesús oyá kan Olivostepetl, ");
INSERT INTO nsu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","iva omostlatik san kualka, oksemi oyá kan templo. Miekeh omotokijkeh inavak, iva Ye omotlali ope kinmachtia. ");
INSERT INTO nsu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ijkuak Jesús otlamachtijtoka, in tlamachtijkeh de itlanavatil Moisés iva in fariseos okivalikilijkeh se sivatl tlen okajsitoh ivan imekav itech tlajtlakoli. Yejvah okiketzkeh tlatlajkotia, ");
INSERT INTO nsu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","iva okilvijkeh in Jesús: —Tlamachti, nin sivatl otikajsitoh ivan imekav itech tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Itlanavatil Moisés technavatia ma tikinmiktikah ika tetl in sivameh tlen ijkó kichivah. Te, ¿tlán tikijtova? ");
INSERT INTO nsu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yejvah ijkó okilvijkeh para kittaskeh tlán kichivas, iva ijkó kipiaskeh tlen ika velis kiteilviskeh. Ijkuakó Jesús omotoolo iva ope tlajkuilova ipan tlali ika imajpil. ");
INSERT INTO nsu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero komo okachi okitlajtlaniayah, Ye omoyekketzki iva okijto: —Tla íkka de imejvah amo kipia nion se tlajtlakoli, yen achto ma kimaka ika tetl. ");
INSERT INTO nsu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús oksemi omotoolo iva oksemi ope tlajkuilova ipan tlali. ");
INSERT INTO nsu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pero ijkuak okikakkeh tlen Jesús okinmilvi, ijkuakó se por se ope yavih porke kuali okimatiah nik yejvah noijki tlajtlakolejkeh. Achto ope yavih tlen okachi yi vevemeh, iva omokajkeh sa yen Jesús ivan sivatl tlen ok ompa omoketoka. ");
INSERT INTO nsu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ijkuakó Jesús oksemi omoyekketzki iva okitlajtlani in sivatl: —Sivatl, ¿kanin kateh tlen omitzteilviayah? ¿Ayakmika okijto nik moneki timikis? ");
INSERT INTO nsu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","In sivatl okinankili: —Amó, noTeko, ayakmika. Ijkuakó Jesús okilvi: —Nion Ne mach nikijtos nik moneki timikis. Axka xivia iva ayakmo xikchiva tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús oksemi ope kintlapovia in gentejtih, okijto: —Ne nika kemi nitlavili para nikintlavilis in tlaltikpaktlakah. Tlen vitz nonavak, kipias tlavili tlen kitemaka nemilistli, iva amo kema nemis kan tlayova. ");
INSERT INTO nsu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","In fariseos okilvijkeh: —Tlen te tikijtova kisa san de te motlayejyekol. San te tikijtova ke yejón tlamantli yi neli. Tonses, yejón tlen tikijtova amitla ipati. ");
INSERT INTO nsu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús okinnankili: —Tlen Ne nikijtova yi neli kipia ipati, maski kisa de Ne mismo. Porke Ne nikmati de kan onivala iva nikmati kan niav. Pero imejvah amo inkimatih de kan onivala iva nion amo inkimatih kan niav. ");
INSERT INTO nsu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Imejvah intetlajtlakoltiah ijkó kemi kichivah in tlaltikpaktlakah. Ne amika niktlajtlakoltia. ");
INSERT INTO nsu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero tla Ne nitetlajtlakoltis, nikchivas ika tlen yi neli melajka, porke amo nitetlajtlakoltia san Ne, sino nitetlajtlakoltia Ne ivan noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Itech imotlanavatil inkipiah ijkuilitok, ke ijkuak ome testigojtih san se tlajtoli kijtovah, tonses tlen kijtovah kipia ipati. ");
INSERT INTO nsu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ijkó pues, Ne nika kemi se testigo tlen nikijtova de Ne mismo, ivan noTajtzi tlen onechvaltitlanki kajki kemi oksé testigo. ");
INSERT INTO nsu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iva yejvah okitlajtlanijkeh: —¿Kanin kajki moTajtzi? Jesús okinnankili: —Imejvah mach innechixmatih, nion amo inkixmatih noTajtzi. Tla imejvah onnechixmatiskiah, noijki onkixmatiskiah noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús okijto nin tlajtoli ijkuak otlamachtijtoka kan templo kan okitlaliayah in ofrendajtomi. Iva amika okikitzki porke ayamo oajsia tonali para kikitzkiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús oksemi okinmilvi: —Ne nias, iva imejvah innechtemoskeh, pero imejvah inmikiskeh porke ok inyeskeh intlajtlakolejkeh. Por eso, kan Ne nias, imejvah amo velis ompa inyaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","In tlayakankeh judiojtih okijtojkeh: —¿Xamo kineki momiktis, por eso kijtova ke kan Ye yas tejvah amo velis ompa tiaskeh? ");
INSERT INTO nsu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ijkuakó Jesús okinmilvi: —Imejvah de nika, pero Ne nivitz de tlakpak. Imejvah de nin tlaltikpaktli, pero Ne amo. ");
INSERT INTO nsu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por eso onimechilvi ke imejvah inmikiskeh porke ok inyeskeh intlajtlakolejkeh. Porke tla imejvah amo inkineltokah nik Yen Ne niCristo, tonses imejvah inmikiskeh porke ok inyeskeh intlajtlakolejkeh. ");
INSERT INTO nsu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ijkuakó oksemi okitlajtlanijkeh: —¿Akin te? Jesús okinnankili: —Ne yonimechilvi desde achto akin Ne. ");
INSERT INTO nsu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne nikpia miek tlamantli tlen moneki nimechilvis en kontra de imejvah. Pero tlen onechvaltitlanki, kijtova tlen melajkayotl, iva tlen Ne nikinmilvia in tlaltikpaktlakah yen yejón noijki tlen Ne onikakki de Ye. ");
INSERT INTO nsu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero yejvah amo okajsikamatkeh ke Jesús okintlapoviaya de iTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Por eso Jesús okinmilvi: —Ijkuak imejvah inkajkuanaskeh tlakpak para inkixpoloskeh iKone in Tlakatl, ijkuakó inkajsikamatiskeh nik Yen Ne niCristo. Iva inkajsikamatiskeh ke amitla nikchiva san tlan Ne nikmoyejyekolia, sino Ne nikijtova san yen tlen noTajtzi yonechmachti. ");
INSERT INTO nsu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porke tlen onechvaltitlanki nova kajki iva amo semi nechkava noselti, porke Ne nochipa nikchiva tlen Ye kipaktia. ");
INSERT INTO nsu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ijkuak Jesús ijkó okinmilvi, miekeh okineltokakeh. ");
INSERT INTO nsu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ijkuakó Jesús okinmilvi in judiojtih tlen okineltokakeh: —Tla imejvah nochipa inkichivaskeh tlen Ne nimechilvia, tonses yi neli inyeskeh inmomachtijkeh de Ne, ");
INSERT INTO nsu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","iva inkixmatiskeh tlen melajkayotl, iva tlen melajkayotl kichivas xikajkatokah. ");
INSERT INTO nsu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yejvah okinankilijkeh: —Tejvah tivalajtokeh de Abraham, iva mach kema íkka tikpiah kemi toteko, ¿kenik tikijtova in te ke tikajkatoskeh? ");
INSERT INTO nsu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús okinmilvi: —Yi neli nimechilvia, nochtin tlen kichivah tlajtlakoli, kijtosneki in tlajtlakoli yen inteko tlen kinnavatijtok. ");
INSERT INTO nsu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Se tlakatl tlen yokikojkeh para tekipanos inavak iteko mach kema povis kemi de familia, pero se tlakatl tlen tekone yejón semijkak povi de familia. ");
INSERT INTO nsu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tonses, tla iKone in Dios imechkajkavas de inavak inmoteko tlen tlajtlakoli, tonses imejvah yi neli inkajkatoskeh. ");
INSERT INTO nsu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kuali nikmati ke imejvah invalajtokeh de Abraham. Pero inkinekih innechixpoloskeh porke amo inkiseliah itech inmoyolo tlen Ne nimechilvia. ");
INSERT INTO nsu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne nimechtlapovia de tlen noTajtzi nechititia, iva imejvah inkichivah tlen inmopapa imechnavatia. ");
INSERT INTO nsu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yejvah okilvijkeh: —¡Tejvah topapa yen Abraham! Pero Jesús okinnankili: —Tla yi neli oyeskia intepilvah de Abraham, tonses onkichivaskiah tlen ye okichi. ");
INSERT INTO nsu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero maski yonimechilvi tlen yi neli tlen Dios nechititia, imejvah inkinekih innechixpoloskeh. ¡Abraham mach kema ijkó okichi! ");
INSERT INTO nsu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Imejvah inkichivah tlen kichiva inmopapa. Yejvah okinankilijkeh: —Tejvah mach tiichtakakonemeh, tejvah tikpiah san se topapa, yen Dios. ");
INSERT INTO nsu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús okinnankili: —Tla yi neli oyeskia yen Dios inmopapa, onnechtlasojtlaskiah, porke Ne nivitz de inavak Dios iva onivala itech nin tlaltikpaktli. Iva amo onivala san por Ne oniknekki, sino porke Dios onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Inkimatih tleka amo inkajsikamatih tlen Ne nimechilvia? Amo inkajsikamatih porke amo inkinekih inkikakiskeh notlajtol. ");
INSERT INTO nsu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Imejvah inmopapa yen Amo Kuali Tlakatl, ivan imejvah inkichivah tlen ye kineki. In Amo Kuali Tlakatl ye temikti desde ijkuak ope in tlaltikpaktli. Mach kema kijtova itla melajkayotl porke itech iyolo mach itla kipia tlen melajkayotl. Nochipa san tlakajkayava porke yen yejón itekiv, porke ipa tekajkaya, iva yen teta de nochtin tlen tlakajkayavah. ");
INSERT INTO nsu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero komo Ne nikijtova tlen yi neli, por eso imejvah amo innechneltokah. ");
INSERT INTO nsu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Akin de imejvah velis kijtos ke nikpia itla tlajtlakoli? Iva tla Ne nikijtova tlen melajkayotl, ¿tleka amo innechneltokah? ");
INSERT INTO nsu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Se tekone de Dios, kichiva tlen Dios kilvia. Pero imejvah komo amo intepilvah de Dios, por eso amo inkichivah tlen Dios imechilvia. ");
INSERT INTO nsu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ijkuakó sekimeh judiojtih okilvijkeh: —Yompa tlen tejvah tikijtovah, te mach tikuali porke te de Samaria iva tikpia se amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús okinnankili: —Ne mach nikpia nion se amo kuali ejekatl. Ne kuali nitlajtova de noTajtzi, pero imejvah intlajtovah amo kuali de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne amo nikchiva ke in tlaltikpaktlakah kuali ma tlajtokah de Ne. Pero onka se tlen akin yi neli kineki kuali ma tlajtokah de Ne, iva yen jues. ");
INSERT INTO nsu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yi neli nimechilvia, tlen akin kichivas tlen Ne nikijtova, amo kema ixpolivis. ");
INSERT INTO nsu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ijkuakó in tlayakankeh judiojtih okinankilijkeh: —Axka kema kuali tikmatih nik yi neli tikpia se amo kuali ejekatl. Abraham iva nochtin tiotenejmachtijkeh oixpolikeh, iva te tikijtova: “Tlen kichivas tlen Ne nikijtova, amo kema ixpolivis.” ");
INSERT INTO nsu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Okachi tiweititok te ke topapa Abraham? Ye oixpolivik, iva in tiotenejmachtijkeh noijki oixpolikeh. ¿Akin timomachilia in te? ");
INSERT INTO nsu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús okinnankili: —Tla Ne onikchivaskia ke in tlaltikpaktlakah kuali ma tlajtokah de Ne, tonses amitla ipati oyeskia. Pero noTajtzi Ye kuali tlajtova de Ne, noTajtzi yen tlen imejvah inkijtovah yen inmoDios. ");
INSERT INTO nsu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero imejvah amo inkixmatih. Ne yi neli nikixmati, iva tla onikijtoskia nik amo nikixmati, onieskia noijki nitekajkaya kemi imejvah. Pero Ne yi neli nikixmati, iva nikchiva tlen Ye kijtova. ");
INSERT INTO nsu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Achto ijkuak okatka inmokojkol Abraham, ye sa tlawel opakki ijkuak okittak ke okachi tlayakapa nivitz itech nin tlaltikpaktli. Ye okittak iva sa tlawel opakki. ");
INSERT INTO nsu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ijkuakó in tlayakankeh judiojtih okilvijkeh in Jesús: —Ayamo tikpia ompoali ivan majtlaktli xivitl, ¿kenomi tikijtova ke otikittak in Abraham? ");
INSERT INTO nsu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús okinnankili: —Yi neli nimechilvia, antes de oyeskia in Abraham, Ne ipa yonikatka. ");
INSERT INTO nsu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ijkuakó yejvah okonintilankeh sekimeh temeh para ika kimakaskeh, pero Jesús okalakki intzala in gentejtih omotlaati iva satepa okiski de kan templo iva oyá. ");
INSERT INTO nsu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ijkuak Jesús opanovaya itech se ojtli, okittak se tlakatl tlen amo otlachiaya desde oneski. ");
INSERT INTO nsu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iva in momachtijkeh okitlajtlanijkeh: —Tlamachti, ¿tleka ijkó oneski nin tlakatl? ¿Por okichijkeh tlajtlakoli itajvah, o noso porke ye okichi tlajtlakoli? ");
INSERT INTO nsu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús okinnankili: —Mach por ye okichi tlajtlakoli o noso por itajvah okichijkeh tlajtlakoli, sino ijkó oneski para xikittakah kenomi ivelitilis in Dios velis kipajtis. ");
INSERT INTO nsu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mientras ok tlanestok, moneki tikchivaskeh in tekitl tlen noTajtzi onechvaltitlanki ma nikchiva, porke ijkuak tlayovas ijkuakó amo ok íkka velis tekipanos. ");
INSERT INTO nsu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mientras Ne nika itech nin tlaltikpaktli, nika kemi se tlavili tlen kintlavilia in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ijkuak Jesús ijkó okijto, ochijchak ipan tlali, okipaatilti se tzikitzi tlali, iva okitlalili itech ixtololovah in tlakatl tlen amo tlachia, ");
INSERT INTO nsu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","iva okilvi: —Ximixamiti kan tanke Siloé —Siloé kijtosneki Tlatitlanili. In tlakatl tlen amo otlachiaya omixamito, iva ijkuak ovalmokuapato, yi veli tlachia. ");
INSERT INTO nsu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ijkuakó ivesinojvah iva nochtin tlen achto okittayah okitlajtlania limosna, omotlajtlaniayah: —¿Amo yen nin tlen omotlaliaya okitlajtlania limosna? ");
INSERT INTO nsu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sekimeh okijtovayah: —Ajá ye. Oksekimeh okijtovayah: —Motta kemi ye, pero mach ye. Pero ye inevia okinmilviaya: —Ajá, ne. ");
INSERT INTO nsu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ijkuakó okitlajtlanijkeh: —¿Kenik yi veli titlachia? ");
INSERT INTO nsu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ye okinnankili: —In tlakatl tlen itoka Jesús, okipaatilti se tzikitzi tlali, onechtlalili itech noixtololovah iva onechilvi: “Ximixamiti kan tanke Siloé.” Ne onia iva ijkuak onimixami, yovelik onitlachixki. ");
INSERT INTO nsu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iva oksemi okitlajtlanijkeh: —¿Kanin kajki yejón tlakatl? Ye okinmilvi: —Mach nikmati. ");
INSERT INTO nsu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ijkuakó in tlakatl tlen achto amo otlachiaya okivikakeh innavak in fariseos. ");
INSERT INTO nsu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Okatka sábado ijkuak Jesús okipaatilti in tlali iva okichi ma tlachia in tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ijkuakó in fariseos okitlajtlanijkeh yejón tlakatl kenik otlachixki. Ye okinnankili: —Okipaatilti se tzikitzi tlali, onechtlalili itech noixtololovah, onimixami, iva axka yi nitlachia. ");
INSERT INTO nsu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ijkuakó sekimeh fariseos okilvijkeh: —Yejón tlakatl amo Dios okivaltitlanki, porke amo kitlakita in sábado. Pero oksekimeh okijtovayah: —¿Kenik velis ijkó kichivas se tlakatl tlen tlajtlakole? Amo nochtin okatkah de akuerdo iva omoxexelojkeh. ");
INSERT INTO nsu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ijkuakó oksemi okitlajtlanijkeh in tlakatl tlen amo otlachiaya: —¿Iva te tlán tikijtova de neká tlakatl tlen omitztlachialti? Iva ye okinnankili: —Ne nikijtova ke Ye se tiotenejmachti. ");
INSERT INTO nsu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","In tlayakankeh judiojtih mach okineltokayah kox yi neli amo otlachiaya. Por eso okinnotzkeh itajvah, ");
INSERT INTO nsu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","iva okintlajtlanijkeh: —¿Yen nin imopiltzi tlen imejvah inkijtovah amo otlachiaya ijkuak oneski? ¿Iva axka kenik yi tlachia? ");
INSERT INTO nsu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","In tetajmeh otlanankilijkeh: —Kuali tikmatih nik topiltzi, iva kuali tikmatih nik amo otlachiaya ijkuak oneski. ");
INSERT INTO nsu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero amo tikmatih kenik yi veli tlachia iva nion amo tikmatih akin okitlachialti. Ye inevia xiktlajtlaniikah, ya yi wei, ye velis imechilvis kenik opajtik. ");
INSERT INTO nsu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","In tetajmeh ijkó otlanankilijkeh porke okinmiimakasiah in tlayakankeh judiojtih. Porke in tlayakankeh judiojtih yomotlatlalvijkah tla íkka kijtos ke Jesús yen Cristo, kikixtiskeh para semijkak de kan intiotlamachtijkal. ");
INSERT INTO nsu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por eso itajvah okijtojkeh: “Ye inevia xiktlajtlaniikah, ya yi wei, mach ok konetl.” ");
INSERT INTO nsu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ijkuakó in tlayakankeh judiojtih oksemi okinotzkeh in tlakatl tlen amo otlachiaya, iva okilvijkeh: —Techilvi tlen yi neli ixpan Dios. Tejvah tikmatih ke yejón tlakatl tlen omitzpajti, tlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ijkuakó in tlakatl okinnankili: —Ne mach nikmati kox tlajtlakole o noso amo. Lo ke tlen nikmati, es ke achto amo onitlachiaya iva axka ya yi nitlachia. ");
INSERT INTO nsu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Iva oksemi okitlajtlanijkeh: —¿Tlán omitztokti? ¿Kenik omitztlachialti? ");
INSERT INTO nsu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ye okinnankili: —Ne yonimechilvi iva amo innechkakih. ¿Tleka inkinekih oksemi ma nimechilvi? ¿Imejvah noijki inkinekih inyeskeh inmomachtijkeh de Ye? ");
INSERT INTO nsu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ijkuakó yejvah ope fiero kilviah, iva okilvijkeh: —Te yotimochi timomachti de yejón tlakatl, pero tejvah timomachtijkeh de Moisés. ");
INSERT INTO nsu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tejvah tikmatih nik in Dios okitlapovi in Moisés. Pero yejón tlakatl, mach tikmatih de kan ovala. ");
INSERT INTO nsu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ijkuakó in tlakatl okinnankili: —Amo nikneltoka tlen inkijtovah. Kenik imejvah amo inkimatih de kan ovala, iva ne asta yonechtlachialti. ");
INSERT INTO nsu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kuali tikmatih nik in Dios amo kinkaki tlen tlajtlakolejkeh. Dios kinkaki tlen kitlakitah iva kichivah tlen Ye kimonekiltia. ");
INSERT INTO nsu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde ijkuak Dios okichi in tlaltikpaktli mach semi momati íkka tlakatl ma kitlachialti se tlen amo tlachia desde oneski. ");
INSERT INTO nsu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tla nin tlakatl amo Dios okivaltitlanki, amitla oveliskia okichivaskia. ");
INSERT INTO nsu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yejvah okilvijkeh: —Te ipa titlajtlakole otineski, ¿iva axka tikneki techmachtis? Iva okikixtijkeh para semijkak de kan tiotlamachtijkali. ");
INSERT INTO nsu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús okimatki ke in tlakatl tlen amo otlachiaya okixtijkeh de kan tiotlamachtijkali, iva ijkuak okinamikki okilvi: —¿Tikneltoka iKone in Dios? ");
INSERT INTO nsu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ye okinankili: —Tejwatzi, techilvi akin Ye para nikneltokas. ");
INSERT INTO nsu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús okinankili: —Yotikittak, yen Ne, tlen axka nika mova nimotlapovijtok. ");
INSERT INTO nsu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ijkuakó in tlakatl omotlankuaketzki inavak Jesús, okimavistili iva okilvi: —Ajá, noTeko, nimitzneltoka. ");
INSERT INTO nsu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iva Jesús okilvi: —Ne onivala itech nin tlaltikpaktli para nikinmilvis kox kuali o noso amo kuali tlen kichivah in tlaltikpaktlakah. Iva ijkó, tlen amo tlachiah ma tlachiakah iva tlen tlachiah ayakmo ma tlachiakah. ");
INSERT INTO nsu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ijkuakó sekimeh fariseos tlen ompa okatkah, ijkuak ijkó okikakkeh okitlajtlanijkeh: —¿Kijtosneki tejvah noijki amo titlachiah? ");
INSERT INTO nsu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús okinnankili: —Tla imejvah yi neli oyeskia amo intlachiah, tonses Dios amo omechtlajtlakoltiskia por yen inmotlajtlakol. Pero komo imejvah inkijtovah ke kuali intlachiah, tonses Dios imechtlajtlakoltis por yen inmotlajtlakol porke inkijtovah inkimatih tlen inkichivah. ");
INSERT INTO nsu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Yi neli nimechilvia, tlen amo kalaki kan kaltentli de ichkakorral, sino tzikuini iva kalaki oksé lado, yejón kijtosneki ichtekki iva san yejón itekiv. ");
INSERT INTO nsu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero in tlajpixki kalaki kan kaltentli. ");
INSERT INTO nsu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tlen tlakuidarova kan kaltentli kitlatlapolia in tlajpixki para ma kalaki, iva iichkavah kitenkakih. In tlajpixki kinnotza iichkavah ika intoka, iva kinkixtia de ijtik inkorral. ");
INSERT INTO nsu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Iva ijkuak nochtin yokinkixti iichkavah, kinvika kinyakana. Iva iichkavah kitokah porke kitenkakih. ");
INSERT INTO nsu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero se tlen amo kixmatih mach ivan yavih, sino kicholiliah porke amo kitenkakih se tlen amo kixmatih. ");
INSERT INTO nsu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús okinmilvi nin ejemplo, pero yejvah amo okajsikamatkeh tlen Jesús okinekia ma kajsikamatikah. ");
INSERT INTO nsu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ijkuakó Jesús oksemi okinmilvi: —Yi neli nimechilvia: Ne nika kemi se kaltentli kan kalakih ichkameh. ");
INSERT INTO nsu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nochtin tlen ovalajkeh antes de Ne nivitz, oyajkeh ichtekeh. Pero in ichkameh mach okintenkakeh ijkuak okinnotzkeh. ");
INSERT INTO nsu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne nika kemi nikaltentli. Iva akin notech kalakis, momakixtis. Velis kalakis iva kisas kan kaltentli iva nochipa kajsis tlen kikuas. ");
INSERT INTO nsu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’In ichtekki vitz san para tlachtekis, para temiktis iva para teixpolos. Pero Ne onivala para ke in tlaltikpaktlakah ma kipiakah nemilistli, iva yejón nemilistli ma momiekili itech inyolo. ");
INSERT INTO nsu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ne kuali nitlajpixki. Se tlen kuali tlajpixki kitemaka inemilis por iichkavah. ");
INSERT INTO nsu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero se tlen san tetlajpialia, ijkuak kitta vitz in koyotl, kinkakajteva in ichkameh iva cholova, porke mach yi neli tlajpixki iva mach iaxkavah in ichkameh. In koyotl kinkitzkia sekimeh ichkameh iva oksekimeh kinchochololtia. ");
INSERT INTO nsu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","In tlajpixki cholova porke san tetlajpialia iva kitlaxtlaviah, iva por eso amo kinchiva kuenta in ichkameh. ");
INSERT INTO nsu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Ne kuali nitlajpixki iva nikinmixmati nochkavah, iva yejvah nechixmatih, ");
INSERT INTO nsu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ijkó kemi noTajtzi nechixmati iva Ne nikixmati noTajtzi. Ne niktemaka nonemilis por nochkavah. ");
INSERT INTO nsu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noijki nikinpia oksekimeh ichkameh, tlen amo kateh ijtik nin korral iva moneki nikinvalikas noijki. Yejvah nechtenkakiskeh, iva nochtin yeskeh san sekka, iva yetos san se tlajpixki. ");
INSERT INTO nsu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’NoTajtzi nechtlasojtla, porke Ne nonevia niktemaka nonemilis, para ijkó satepa oksemi nikpias nonemilis ijkuak nimoyolitis. ");
INSERT INTO nsu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amika velis nechkixtilis nonemilis, sino Ne nonevia niktemaka. Ne velis nikchivas de niktemakas nonemilis iva de nikpias oksemi nonemilis. NoTajtzi ijkó onechnavati ma nikchiva. ");
INSERT INTO nsu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","In tlayakankeh judiojtih oksemi ope mokualaniah porke amo okatkah de akuerdo por tlen okijtovaya in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sekimeh okijtovayah: —Nin tlakatl kipia se amo kuali ejekatl iva yokuatlapolo. ¿Tlán para inkikakiliah? ");
INSERT INTO nsu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero oksekimeh okijtovayah: —Se tlakatl tlen kipia se amo kuali ejekatl amo ijkó tlajtova. Se amo kuali ejekatl amo velis kitlachialtis se tlakatl tlen amo veli tlachia. ");
INSERT INTO nsu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ompa Jerusalén okichijtokah ilvitl tlen okichivayah kada xivitl para kilnamikih ijkuak okiyankuilijkeh in templo. Iva okatka mero ijkuak seva. ");
INSERT INTO nsu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ik ompa onemia kan templo, kan kilviah korredor de Salomón. ");
INSERT INTO nsu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ijkuakó in tlayakankeh judiojtih okiyavalojkeh iva okitlajtlanijkeh: —¿Asta keman kuali tikmatiskeh akin te? Tla yi neli te tiCristo seppa techilvi. ");
INSERT INTO nsu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús okinnankili: —Ne yonimechilvi akin Ne, pero imejvah amo innechneltokah. Nochi tlen noTajtzi onechnavati ma nikchiva yen yejón nikchiva iva yejón kiteititia akin Ne. ");
INSERT INTO nsu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero imejvah amo innechneltokah, porke imejvah amo innochkavah, ijkó kemi achto yonimechilvi. ");
INSERT INTO nsu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nochkavah nechtenkakih, iva Ne nikinmixmati iva yejvah vitzeh nonavak. ");
INSERT INTO nsu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne nikinmaka nemilistli para semijkak. Amo kema mikiskeh, iva amika velis nechinkixtilis. ");
INSERT INTO nsu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NoTajtzi yen onechinmaktili, Ye okachi velitini ke nochtin, iva amika velis kinkixtilis. ");
INSERT INTO nsu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne ivan noTajtzi timochijtokeh san se. ");
INSERT INTO nsu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ijkuakó in tlayakankeh judiojtih oksemi okonintilankeh sekimeh temeh para ika kimakaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iva Jesús okinmilvi: —Inmoixpa nikchijtivitz miek tlamantli tlen kuali ika ivelitilis noTajtzi. ¿Katli yen tlamantli inkijtoskeh ke amo kuali tlen onikchi iva por eso innechmakaskeh ika tetl? ");
INSERT INTO nsu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In tlayakankeh judiojtih okinankilijkeh: —Amo timitzmakaskeh ika tetl por tlen kuali yotikchi, sino porke titlapova kontra Dios. Te san titlakatl iva timoteneva tiDios. ");
INSERT INTO nsu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús okinnankili: —Itech inmotlanavatil kajki ijkuilitok kan Dios kijtova: “Ne onikijto imejvah indiosmeh.” ");
INSERT INTO nsu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tikmatih ke tlen kijtova in Tiotlajkuiloli amo velis se kipatlas porke kijtova tlen yi neli, iva Dios okinnotzki diosmeh tlen okiselijkeh itlajtol. ");
INSERT INTO nsu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iva tla Dios onechpejpenki iva onechvaltitlanki itech nin tlaltikpaktli, tonses, ¿kenomi imejvah inkijtovah ke nitlapova kontra Dios por onikijto nik Ne niiKone in Dios? ");
INSERT INTO nsu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tla amo nikinchiva in chivalistih kemi noTajtzi kinchiva, amo techneltokilikah. ");
INSERT INTO nsu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero tla nikinchiva, tonses maski Ne amo techneltokilikah, sino xikinneltokakah in chivalistih tlen nikinchiva, para ijkó kuali xikmatikah ke noTajtzi yi neli nova kajki iva Ne nika Iva. ");
INSERT INTO nsu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oksemi okinekiah kikitzkiskeh, pero Jesús okincholili. ");
INSERT INTO nsu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ijkuakó Jesús oksemi oyá ik nepa lado de kan weyatl Jordán, kan achto in Juan otlabautisarovaya iva ompa omoka. ");
INSERT INTO nsu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Iva miekeh oyajkeh ompa okittatoh in Jesús iva okijtovayah: —Maski in Juan amo okichi nion se tetzavkaneskayotl, pero nochi tlen okijto de nin tlakatl yi neli melajka. ");
INSERT INTO nsu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iva miekeh otlaneltokakeh inavak Jesús itech yejón lugar. ");
INSERT INTO nsu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Itech altepetl de Betania okatka se tlakatl tlen omokokovaya itoka Lázaro, ochantia ivan iveltivah María ivan Marta. ");
INSERT INTO nsu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nin María ikni in Lázaro, yen okiteekili ajviakayotl itech ikxivah in toTeko iva okinvajvachili ika itzonkal. ");
INSERT INTO nsu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tonses, yejonmeh iknivah in Lázaro otlatitlankeh ma kilvitih in Jesús: —ToTeko, moyolikni Lázaro chikavak mokokova. ");
INSERT INTO nsu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ijkuak Jesús okikakki, okijto: —Yejón kokolistli mach kixpolos, sino ika moteititis imavistilis in Dios, iva ika yejón kokolistli noijki ika moteititis imavistilis iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús sa tlawel okintlasojtlaya in Marta, María ivan Lázaro, ");
INSERT INTO nsu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","iva maski okilvijkeh nik Lázaro chikavak mokokova, Ye ok omoka ome tonali kan okatka. ");
INSERT INTO nsu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Satepa Jesús okinmilvi in momachtijkeh: —Ma tiviah oksemi para Judea. ");
INSERT INTO nsu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ijkuakó in momachtijkeh okilvijkeh: —Tlamachti, ayamo wejkava in tlayakankeh judiojtih okinekiah mitzixpoloskeh ika tetl, ¿iva oksemi tikneki tias ompa? ");
INSERT INTO nsu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús okinmilvi: —Se tonali kipia majtlaktli ivan ome ora. Tla se tlakatl nemis ijkuak tlanestok, mach motepotlamis porke tlanestok. ");
INSERT INTO nsu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero tla se nemis kan tlayova, velis se motepotlamis porke amo kipia in tlavili. ");
INSERT INTO nsu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Satepa Jesús okinmilvi: —Toyolikni Lázaro ye kochi, pero Ne nikijxitis. ");
INSERT INTO nsu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ijkuakó in momachtijkeh okilvijkeh: —ToTeko, tla san kochi, kijtosneki pajtis. ");
INSERT INTO nsu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero tlen Jesús okinmilvi kijtosneki in Lázaro yoixpolivik, pero yejvah okiyejyekojkeh ke Jesús okinmilvijtoka nik in Lázaro kochi. ");
INSERT INTO nsu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ijkuakó Jesús okinyekilvi: —Lázaro yoixpolivik. ");
INSERT INTO nsu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Iva nipaki porke amo ompa onikatka, yejón se kuali para imejvah para okachi xitlaneltokakah nonavak. Tiavih, ma tikittatih. ");
INSERT INTO nsu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ijkuakó Tomás tlen okilviayah Nenetl, okinmilvi tlen oksekimeh momachtijkeh: —Ma tiviah tejvah noijki, para tiixpoliviskeh ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ijkuak Jesús oajsito Betania, okimatki nik in Lázaro yokivikaya navi tonali tooktok. ");
INSERT INTO nsu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania okatka serka de Jerusalén, san kana eyi kilómetro, ");
INSERT INTO nsu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","iva miekeh judiojtih oyajkeh otetlajpalotoh ichan Marta ivan María, para kinyolaliskeh por oixpolivik in Lázaro. ");
INSERT INTO nsu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ijkuak Marta okimatki nik Jesús yompa ovalaya, okinamikito, pero María omoka kalijtik. ");
INSERT INTO nsu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Iva Marta okilvi in Jesús: —NoTeko, tla nika otieskia, nokni amo oixpoliviskia. ");
INSERT INTO nsu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ne kuali nikmati ke nochi tlen tejwatzi tiktlajtlanilis in Dios, Ye mitzmakas. ");
INSERT INTO nsu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús okilvi: —Mokni moyolitis. ");
INSERT INTO nsu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta okilvi: —Ne nikmati nik moyolitis ijkuak nochtin mikameh moyolitiskeh itech neká tonali tlen yetos sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ijkuakó Jesús okilvi: —Yen Ne tlen niktemaka nemilistli iva yen Ne tlen niteyolitia. Tlen nechneltokas maski ma ixpolivi, satepa moyolitis. ");
INSERT INTO nsu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Iva nochtin tlen ok yolitokeh iva nechneltokah, amo kema ixpoliviskeh. ¿Tikneltoka tlen nimitzilvia? ");
INSERT INTO nsu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta okilvi: —Ajá, noTeko, ne nikneltoka ke tejwatzi tiCristo iKone in Dios, tlen tejvah otikchiayah ma viki itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ijkuak otlanki ijkó okijto, Marta oyá okinotzato ikni María iva okilvi san ichtakatzi: —In Tlamachti nika kajki, mitznotza. ");
INSERT INTO nsu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ijkuak María okikakki tlen Marta okilvi, omoketevak oyá okittato in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ayamo okalakia kan altepetl, ok okatka kan Marta okinamikki. ");
INSERT INTO nsu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","In judiojtih tlen okatkah kalijtik tlen okiyolalijtokah in María, ijkuak okittakeh in María omoketevak iva okistevak, yejvah noijki okikistevakeh iva okitokakeh. Yejvah okiyejyekojkeh yavi chokati kan toktok in Lázaro. ");
INSERT INTO nsu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ijkuak María oajsito kan okatka in Jesús, omotlankuaketzki ikxitla iva okilvi: —NoTeko, tla nika otieskia, nokni amo oixpoliviskia. ");
INSERT INTO nsu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús okittak in María sa tlawel choka, iva in judiojtih tlen okivaltokayah noijki chokah. Ijkuakó Jesús oyoltilinki iva sa tlawel omoyolkoko. ");
INSERT INTO nsu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iva okintlajtlani: —¿Kan onkitookakeh? Yejvah okilvijkeh: —ToTeko, xiviki xikittaki. ");
INSERT INTO nsu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iva Jesús ochokak. ");
INSERT INTO nsu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Sekimeh judiojtih okijtojkeh: —Xikittakah, yi neli okitlasojtlaya. ");
INSERT INTO nsu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Iva sekimeh de yejvah okijtojkeh: —Tla ovelik okitlachialti in tlakatl tlen amo otlachiaya, ¿amitla ovelik okichi para amo ma ixpolivi in Lázaro? ");
INSERT INTO nsu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ok ijkó moyolkokojtok, omotoki kan okitookakeh in Lázaro. Okatka ijtik se kuevajtzi iva otentzaktoka ika se tetl patlaktik. ");
INSERT INTO nsu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús okinmilvi: —Xikachivakah in tetl. Marta, ikni in Lázaro, okilvi in Jesús: —NoTeko, yi tzojyaxtos porke yi kipia navi tonali de oixpolivik. ");
INSERT INTO nsu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero Jesús okilvi: —Yonimitzilvi, tla techneltokas velis tikittas imavistilis in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ijkuakó okachijkeh in tetl. Jesús oajkotlachixki ik ilvikak iva okijto: —NoTajtzi, nimitztlasojkamati porke techkaki. ");
INSERT INTO nsu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne nikmati nik nochipa techkaki, iva ijkí nikijtova para ke in gentejtih tlen nika kateh ma kineltokakah nik tejwatzi otechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ijkuak otlanki ijkó okijto, chikavak okitzajtzili: —¡Lázaro, xivalkisa de ompa! ");
INSERT INTO nsu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ijkuakó Lázaro tlen oixpolika ovalkiski kemilitivitz ika tzotzoli itech ikxivah iva itech imavah, iva oixkemilitivalaya ika se tzotzoli. Iva Jesús okinmilvi: —Xiktotomakah iva xikavakah ma via. ");
INSERT INTO nsu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ijkuakó otlaneltokakeh inavak Jesús miekeh judiojtih tlen otetlajpalotoh inavak María porke okittakeh tlen Jesús okichi. ");
INSERT INTO nsu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero sekimeh oyajkeh okinmitatoh in fariseos iva okinmilvijkeh tlen Jesús okichi. ");
INSERT INTO nsu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ijkuakó in tlayakankeh tiopixkeh, ivan fariseos ivan tlen povih itech injunta in judiojtih, omololojkeh para omotlapovijkeh. Okijtojkeh: —¿Tlán tikchivaskeh? Nin tlakatl kinchiva miekeh tetzavkaneskayomeh. ");
INSERT INTO nsu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tla tikaviliskeh ijkó ma kichijtinemi, nochtin pevas kineltokaskeh, iva in tekivajkeh de Roma vitzeh iva kixixiniskeh in templo iva nochi topaís. ");
INSERT INTO nsu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero se de yejvah itoka Caifás, tlen okatka wei tiopixki itech yejón xivitl, okinmilvi: —Imejvah amitla inkimatih. ");
INSERT INTO nsu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Amo inkimomakah kuenta ke para tejvah okachi kuali ma ixpolivi san se tlakatl por nochtin toknivah, iva amo nochi in topaís ma ixpolivi. ");
INSERT INTO nsu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero tlen okijto in Caifás mach san por ye ijkó okiyejyeko okijto, sino komo okatka wei tiopixki itech yejón xivitl, Dios okichi ma kijto in Caifás ke Jesús ixpolivis por nochtin gentejtih de Israel. ");
INSERT INTO nsu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iva amo ixpolivis san por yen gentejtih de Israel, sino noijki ixpolivis para kinmololos nochtin ipilvah in Dios tlen xixintokeh sentetl itech nochi nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Por eso desde yejón tonali ope kitemovah kenik velis kixpoloskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por eso, Jesús ayakmo omoteititiaya inmixpa in judiojtih. Okiski de itech yejón tlali de Judea iva oyá kan se altepetl itoka Efraín, tlen kajki serka kan tlavaki, iva ompa omoka invan momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Opolitoka sa kana keski tonali para ajsiki inmilviv in judiojtih tlen itoka Pascua. Miekeh gentejtih de miekeh altepemeh yovalajtokah Jerusalén para mochipavaskeh antes de pevas ilvitl de Pascua. ");
INSERT INTO nsu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ijkuakó okitemovayah in Jesús, iva ijkuak yokatkah nochtin kan templo, omotlajtlaniayah: —¿Imejvah, tlán inkiyejyekovah? ¿Vitz ilvitl in Jesús o noso amo? ");
INSERT INTO nsu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","In fariseos ivan tlayakankeh tiopixkeh otlanavatijkeh tla íkka kimatis kanin kajki in Jesús, ma kinmatilti para kikitzkiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chikuase tonali antes de ajsiki ilvitl de Pascua, Jesús oyá Betania kan ochantia in Lázaro, tlen Jesús okiyoliti. ");
INSERT INTO nsu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ompa okitemakakeh se tlaxkali para motlasojkamatiskeh inavak Jesús. Marta okintlateekiliaya iva Lázaro noijki ompa okatka inakastla in Jesús otlakuajtokah kan mesa. ");
INSERT INTO nsu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ijkuakó María okivalikak kemi tlajko litro de ajviakayotl de nardo tlen patío, iva okiteekili itech ikxivah in Jesús, satepa okinvajvachili ika itzonkal. Iva nochi otlaajviayak in kalijtik ika yejón ajviakayotl. ");
INSERT INTO nsu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ijkuakó Judas Iscariote ipiltzi in Simón, tlen okatka se de tlen momachtijkeh iva tlen satepa okitemakti in Jesús, okijto: ");
INSERT INTO nsu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Tleka amo omonemakak nin ajviakayotl ika eyi siento denario kemi tlen se kitlani de se xivitl tlen tlapalevia, iva se okinmakaskia in tomi tlen prowestih? ");
INSERT INTO nsu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero Judas ijkó okijto amo porke yi neli okinmiknomatia in prowestih, sino porke okatka ichtekki. Judas yen okittaya in tominbolsa iva ichtaka okimotlaatiliaya seki tomi. ");
INSERT INTO nsu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ijkuakó Jesús okilvi: —Xikava, porke ye yokitlaatijtoka nin ajviakayotl para kixavilis nokuerpo para ijkuak nechtookaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","In prowestih nochipa yeskeh, pero Ne amo nochipa inmovah nietos. ");
INSERT INTO nsu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Miekeh judiojtih okimatkeh nik Jesús okatka kan altepetl de Betania, iva oyajkeh okittatoh. Amo oyajkeh san para kittaskeh in Jesús, sino noijki para kittaskeh in Lázaro, tlen Jesús okiyoliti. ");
INSERT INTO nsu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ijkuakó in tlayakankeh tiopixkeh omotlatlalvijkeh noijki para kimiktiskeh in Lázaro. ");
INSERT INTO nsu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porke ijkuak Lázaro omoyoliti, miekeh judiojtih ope moxelovah de yejvah iva ope tlaneltokah inavak Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Miekeh gentejtih oyajkeh Jerusalén itech ilvitl de Pascua. Omostlatik, ijkuak okimatkeh ke Jesús vitz ompa Jerusalén, ");
INSERT INTO nsu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ijkuakó okitekitoh seki soyatl iva oyajkeh okinamikitoh in Jesús. Iva okijtovayah chikavak: —¡Viva! ¡Ma Dios kitiochiva tlen vitz ika itoka toTajtzin Dios! ¡Ma Dios kitiochiva in wei tlanavati de Israel! ");
INSERT INTO nsu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús okajsik se burrojtzi iva ipan omotlali. Kemi kijtova in Tiotlajkuiloli: ");
INSERT INTO nsu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Gente de Sión amo ximomavtikah. Xikittakah inmowei tlanavati yompa valmuika, yetivitz ipan se burrojtzi. ");
INSERT INTO nsu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Itech yejón tonali in momachtijkeh amo okajsikamatkeh tlán kijtosneki tlen otlamochivalok, pero satepa ijkuak Jesús oixpolivik iva omoyoliti ika wei imavistilis, okilnamikeh ke nochi yejón tlamantli yokatka ijkuilitok itech Tiotlajkuiloli, iva ijkó otlamochivalok. ");
INSERT INTO nsu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Okatkah miekeh gentejtih ijkuak Jesús okilvi in Lázaro ma kisa de kan otoktoka iva okiyoliti. Iva yejvah ope tetlapoviah de tlen okittakeh otlamochi. ");
INSERT INTO nsu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Por eso, miekeh gentejtih oyajkeh okinamikitoh in Jesús, porke okimatkeh nik okichi se wei tetzavkaneskayotl. ");
INSERT INTO nsu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero in fariseos okimolviayah entre yejvah: —Xikittakah, nochtin gentejtih yavih inavak Jesús. Iva tejvah amo veli itla tikchivah. ");
INSERT INTO nsu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Itech yejón ilvitl de Pascua noijki ompa okatkah sekimeh gentejtih de Grecia tlen noijki oyajkeh okimavistilitoh in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ninmeh gentejtih de Grecia omotokijkeh inavak Felipe tlen okatka de altepetl de Betsaida de tlali de Galilea, iva okitlatlavtijkeh okilvijkeh: —Tejwatzi, tiknekih tikittaskeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe oyá okilvito in Andrés, iva satepa nochtin ome oyajkeh okilvitoh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús okinnankili: —Yoajsik ora para kimavistiliskeh iKone in Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yi neli nimechilvia, tla se semiya amo kitookaskeh, amo mikis iva nochipa yetos ijkó san se semiya. Pero tla kitookaskeh, mikis iva tlakis miek. ");
INSERT INTO nsu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tlen kitekipachos okachi inemilis iva amo kichivas tlen nikijtova, amo velis kipias nemilistli para semijkak. Pero tlen kiyejyekos ke amo moneki motekipachos por inemilis iva kichivas tlen nikijtova, tonses kipias nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tlen kinekis nechtekipanos, moneki ma nechseguiro. Iva kan Ne nietos, ompa yetos noijki tlen nechtekipanova. Tla íkka nechtekipanos, noTajtzi kitlakitas. ");
INSERT INTO nsu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Axka sa tlawel nimoyolkokova, iva amo nikmati tlán nikijtos. Iva amo velis nikilvis noTajtzi ma nechpalevi de itech nin tlajyovilistli. Porke para yejón nik onivala. ");
INSERT INTO nsu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","NoTajtzi, xikinmititi in gentejtih momavistilis. Ijkuakó omokakki se tlajtoli de ilvikak okijto: —Yonikinmititi nomavistilis iva oksemi nikinmititis. ");
INSERT INTO nsu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","In gentejtih tlen ompa okatkah okijtojkeh okikakkeh otlatikuinki, iva oksekimeh okijtovayah: —Se ilvikaktlatitlanili okitlapovi. ");
INSERT INTO nsu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ijkuakó Jesús okinmilvi: —Yejón tlen onkikakkeh amo omokakki para Ne ma nikkaki, sino para imejvah xikkakikah. ");
INSERT INTO nsu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yoajsik in tonali para Dios kijtos akinmeh tlajtlakolejkeh iva akinmeh amo itech nin tlaltikpaktli, iva nikixtilis itekiv in Amo Kuali Tlakatl tlen tlanavatia itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iva ijkuak nechajkuanaskeh tlakpak itech krus, nikchivas ke nochtin gentejtih ma tlaneltokakah nonavak. ");
INSERT INTO nsu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ika nin tlajtoli Jesús okinmajsikamatilti kenik ixpolivis. ");
INSERT INTO nsu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","In gentejtih okinankilijkeh: —In Tiotlajkuiloli kijtova nik in Cristo yolitos para semijkak. ¿Kenik in te tikijtova ke iKone in Tlakatl kajkuanaskeh tlakpak? ¿Akin yejón iKone in Tlakatl? ");
INSERT INTO nsu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús okinmilvi: —In tlavili ok yetos imovah sa kana keski tonali. Tos xinemikah itech tlavili mientras invelih, para amo inmopah vitz in tlayovalotl. Porke tlen nemih kan tlayova, amo kimatih kan yavih. ");
INSERT INTO nsu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xitlaneltokakah inavak in tlavili mientras ok kajki inmovah, para xiekah intepilvah de yen tlavili. Ijkuak Jesús otlanki okijto nin tlajtoli, oyá de ompa iva okinmonetlatili. ");
INSERT INTO nsu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maski Jesús okinchi miekeh tetzavkaneskayomeh inmixpa in judiojtih, yejvah amo okineltokiliayah. ");
INSERT INTO nsu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ijkó otlamochivalok para ma mochiva tlen okijto in tiotenejmachti Isaías: NoTeko, ¿akin kineltoka motlajtol tlen tejvah tiktematiltiah? ¿Akin yotikititi movelitilis? ");
INSERT INTO nsu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yejvah amo oveliah okineltokayah, iva Isaías noijki okijto: ");
INSERT INTO nsu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios okintokti amo ma tlachiakah iva ma yoltlakuavakah, okintokti amo ma tlachiakah, iva nion amitla ma kajsikamatikah, para amo ma mokuapakah nonavak, iva amo ma nikinpajti. ");
INSERT INTO nsu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías ijkó okijto porke okittak imavistilis in Jesús, iva otlajto de Ye. ");
INSERT INTO nsu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iva miekeh judiojtih otlaneltokakeh inavak Jesús, asta in tlayakankeh judiojtih noijki otlaneltokakeh, pero amika otlajtovaya de yejón tlamantli porke okinmiimakasiah in fariseos, porke amo okinekiah ma kinkixtikah para semijkak de kan tiotlamachtijkali. ");
INSERT INTO nsu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yejvah okinekiah kuali mokavaskeh innavak in gentejtih maski amo ma mokavakah kuali inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ijkuakó Jesús chikavak okijto: —Tlen nechneltokilia, amo san Ne nechneltokilia, sino noijki kineltokilia noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iva tlen nechitta, noijki kitta noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne onivala itech nin tlaltikpaktli kemi se tlavili. Iva nikintlavilia nochtin tlen nechneltokah, iva amo kema yeskeh kan tlayova. ");
INSERT INTO nsu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero tla íkka kikaki notlajtol iva amo kichiva tlen nikijtova, amo Ne niktlajtlakoltis. Porke Ne amo onivala onikintlajtlakoltiko in tlaltikpaktlakah, sino Ne onivala onikinmakixtiko de itech tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tlen amo nechneki iva amo kineki kikakis notlajtol, onka akin kitlajtlakoltis, kijtosneki yen notlajtol tlen Ne nikijtova, ye kitlajtlakoltis itech neká tonali tlen yetos sa ik tlami. ");
INSERT INTO nsu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porke Ne amo nikijtova san tlen Ne nikneki. NoTajtzi tlen onechvaltitlanki, Ye onechnavati tlen moneki nikijtos iva tlen moneki nitlamachtis. ");
INSERT INTO nsu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iva Ne nikmati ke tlen kichivah tlen kijtova itlajtol de noTajtzi, kinmaka nemilistli para semijkak. Tonses, tlen Ne nikijtova, nikijtova ijkó kemi noTajtzi onechilvi ma nikijto. ");
INSERT INTO nsu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Antes de ilvitl de Pascua, Jesús yokimatia nik yoajsik ora para yaski de itech nin tlaltikpaktli iva yas inavak iTajtzi. Ye nochipa okintlasojtlak tlen iaxkavah itech nin tlaltikpaktli, sa tlawel okintlasojtlak asta omotemakti ma kixpolokah por yejvah. ");
INSERT INTO nsu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yejón yovak, ijkuak Jesús ivan momachtijkeh otlakuajtokah, in Amo Kuali Tlakatl ipa yokitlalijka itech iyolo in Judas Iscariote, ipiltzi in Simón, para ma kitemakti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iva Jesús yokimatia ke iTajtzi yokimaktili nochi velitilistli itech nochi tlamantli, iva okimatia nik Ye ovala de Dios iva oksemi mokuapas inavak. ");
INSERT INTO nsu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ijkuakó Jesús omoketzki de kan mesa, okixti itlaken tlen okimokentiaya, iva omotlajkoilpi ika se toaya. ");
INSERT INTO nsu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ijkuakó okitlali atl ika se ajpatzintli iva ope kinmikxipajpaka in momachtijkeh iva satepa okinvajvachili ika toaya tlen ika omotlajkoilpijka. ");
INSERT INTO nsu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ijkuak Jesús yokikxipajpakaskia in Simón Pedro, okilvi: —NoTeko, ¿tejwatzi techikxipajpakas? ");
INSERT INTO nsu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús okinankili: —Tlen nikchijtok, te axka amo tikajsikamati, pero satepa tikajsikamatis. ");
INSERT INTO nsu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero Pedro okilvi: —Tejwatzi amo kema techikxipajpakas. Jesús okinankili: —Tla amo nimitzikxipajpakas, amitla tikpias nova. ");
INSERT INTO nsu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ijkuakó Simón Pedro okilvi: —NoTeko, tla ijkó, amo san nokxivah xikinpajpaka, sino noijki nomavah iva notzonteko. ");
INSERT INTO nsu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Jesús okilvi: —Se tlen yikin omalti, moneki san ikxivah ma kinpajpaka, porke ya chipavak. Iva imejvah yinchipavakeh, maski amo innochtin. ");
INSERT INTO nsu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús okimatia akin kitemaktis, por eso okijto: “Amo innochtin inchipavakeh.” ");
INSERT INTO nsu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ijkuak otlanki okimikxipajpaki in momachtijkeh, oksemi okimokenti itlaken iva omotlalito kan mesa, iva okinmilvi: —¿Inkajsikamatih tlán kijtosneki tlen onikchi inmovah? ");
INSERT INTO nsu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Imejvah innechnotzah nimoTlamachti iva nimoTeko, iva kuali tlen inkijtovah, porke yi neli Ne nimoTlamachti iva Ne nimoTeko. ");
INSERT INTO nsu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iva tla Ne nimoTeko iva nimoTlamachti onimechikxipajpaki, tonses imejvah noijki moneki ijkó xikchivakah entre imejvah. ");
INSERT INTO nsu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ne nimechmaka se ejemplo para imejvah noijki ijkó xikchivakah kemin Ne yonikchi inmovah. ");
INSERT INTO nsu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yi neli nimechilvia, se tlen san tlapalevia mach velis okachi weititos ke iteko, iva se tlen san kititlanih mach velis okachi weititos ke tlen tlatitlani. ");
INSERT INTO nsu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tla inkajsikamatih iva inkichivah tlen nimechilvijtok, tonses xipakikah. ");
INSERT INTO nsu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Tlen nikijtova amo nikijtova para innochtin. Ne nikmati akinmeh onikinpejpenki. Pero kipia tlen mochivas kemi kijtova in Tiotlajkuiloli: “In tlakatl tlen nova otlakua, omochi nokontra.” ");
INSERT INTO nsu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Desde axka nimechilvia maski ayamo ijkó tlamochiva, para ijkuak ijkó tlamochivas, xikneltokakah nik Yen Ne niCristo. ");
INSERT INTO nsu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yi neli nimechilvia, tla íkka kiselis tlen Ne niktitlani, kijtosneki Ne nechselia, iva tlen Ne nechselia, noijki kiselia tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ijkuak Jesús okijto nin tlajtoli, sa panova omotekipacho iva okinyekimilvi: —Yi neli nimechilvia, se de imejvah nechtemaktis. ");
INSERT INTO nsu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ijkuakó in momachtijkeh ope motlatlajtlatah, porke amo okimatiah akin ijkó kichivas. ");
INSERT INTO nsu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Se de yejvah tlen Jesús sa tlawel okitlasojtlaya, omonakasiktekak itech Jesús mientras otlakuayah. ");
INSERT INTO nsu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","In Simón Pedro okichivili señas para ma kitlajtlani in Jesús de akin tlapojtok. ");
INSERT INTO nsu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ijkuakó okachi omotoki asta kan ielpa Jesús iva okitlajtlani: —NoTeko, ¿akin mitztemaktis? ");
INSERT INTO nsu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús okinankili: —Nikapachos seki pan, iva akin Ne nikmakas, yen yejón. Ijkuakó Jesús okapacho se pedaso pan iva okimakak in Judas Iscariote, ipiltzi in Simón. ");
INSERT INTO nsu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iva ijkuak Judas okikua in pan, in Amo Kuali Tlakatl okalakki itech iyolo. Iva Ijkuakó Jesús okilvi: —Xikchijtivetzi san nima tlen tikchivas. ");
INSERT INTO nsu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero nion se de yejvah tlen otlakuajtokah kan mesa amo okajsikamatkeh tleka ijkó okilvi. ");
INSERT INTO nsu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Komo Judas yen okittaya in tominbolsa, sekimeh okiyejyekojkeh xamo in Jesús okilvi ma via ma kikovati tlen monekis para ilvitl de Pascua, o noso itla ma kinmaka tlen prowestih. ");
INSERT INTO nsu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ijkuak Judas otlanki okikua in pan tlen Jesús okimakak, san nima okiski. Iva ijkuakó yokatka yi yovak. ");
INSERT INTO nsu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Satepa ijkuak Judas yokiski, Jesús okijto: —Axka moteititis imavistilis iKone in Tlakatl, iva noijki moteititis imavistilis in Dios itech Ye. ");
INSERT INTO nsu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iva tla ikone in Tlakatl kiteititis imavistilis in Dios, in Dios noijki kiteititis imavistilis iKone in Tlakatl. Iva san nima kichivas. ");
INSERT INTO nsu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nopilvah, mach ok wejkavas nietos inmovah. Imejvah innechtemoskeh. Pero ijkó kemi onikinmilvi tlen tlayakankeh judiojtih, axka imejvah noijki nimechilvia: Kan Ne niav, imejvah amo velis inyaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ne nimechmaka se yankuik tlanavatili: Ximotlasojtlakah entre imejvah. Ijkó kemin Ne nimechtlasojtla, imejvah noijki ijkó ximotlasojtlakah. ");
INSERT INTO nsu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tla imejvah yi neli inmotlasojtlaskeh, tonses nochtin kimomakaskeh kuenta ke imejvah yi neli inmomachtijkeh de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro okitlajtlani in Jesús: —NoTeko, ¿kan timuikas? Jesús okinankili: —Kan Ne nias, axka mach velis tias nova. Pero satepa velis tias. ");
INSERT INTO nsu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro okilvi: —NoTeko, ¿tleka axka amo velis nias mova? Tla moneki, asta velis nimotemaktis ma nechmiktikah por tejwatzi. ");
INSERT INTO nsu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús okinankili: —¿Timotemaktis ma mitzmiktikah por Ne? Yi neli nimitzilvia, antes de tzajtzis in kaxtil, para ijkuakó te yotikijto eyi welta nik amo techixmati. ");
INSERT INTO nsu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Amo ximoyolkokokah. Xikneltokakah Dios iva Ne noijki techneltokakah. ");
INSERT INTO nsu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kan ikalijtik noTajtzi onka miek lugar kan se chantis. Tla amo ijkó oyeskia, amo onimechilviskia. Ne niav ompa nitlayektlaliti para imejvah noijki ompa xikpiakah se lugar. ");
INSERT INTO nsu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Iva satepa ijkuak yonia iva yi tlayektlalitos, oksemi nivalmokuapas iva nimechvikas, para imejvah noijki xietokah kan Ne nietos. ");
INSERT INTO nsu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Imejvah yinkixmatih in ojtli iva yinkimatih kan niav. ");
INSERT INTO nsu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ijkuakó Tomás okilvi: —NoTeko, tejvah mach tikmatih kan tiav, ¿kenomi tikmatiskeh katli yen ojtli? ");
INSERT INTO nsu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús okinankili: —Ne niojtli tlen tevika ilvikak, Ne nitlamachtia tlen melajkayotl, iva Ne niktemaka nemilistli para semijkak. San Ne velis nimechvikas inavak noTajtzi, iva tla amo por Ne amo velis inmajsitivih inavak. ");
INSERT INTO nsu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tla imejvah yonnechixmatkeh, tonses imejvah noijki inkixmatiskeh noTajtzi. Iva desde axka yinkixmatih, porke yinkonitokeh. ");
INSERT INTO nsu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ijkuakó Felipe okilvi: —ToTeko, techkavili ma tikittakah moTajtzi. San yen yejón tlen tejvah tiknekih. ");
INSERT INTO nsu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús okilvi: —Yowejka nika inmovah, ¿iva ayamo techixmati Felipe? Tlen yonechitak, kijtosneki yokittak noTajtzi. Tonses, ¿kenik in te tikijtova ma nimechititi in noTajtzi? ");
INSERT INTO nsu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Amo tikneltoka ke Ne ivan noTajtzi timochijtokeh san se? Nochi tlen Ne nimechilvia, mach nikijtova san tlen Ne nikmoyejyekolia. NoTajtzi yen kichiva nochi in tekitl por medio de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Techneltokilikah ijkuak nimechilvia ke Ne nika ivan noTajtzi, iva noTajtzi kajki nova. Iva tlamo, sikiera techneltokilikah por nochi tlen yonikchi. ");
INSERT INTO nsu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yi neli nimechilvia, tlen nechneltoka, noijki velis kinchivas in tlamantih tlen Ne nikinchiva. Iva velis kinchivas okachi wejwei tlamantih, porke Ne niav inavak noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nochi tlen inkitlajtlaniliskeh noTajtzi ika notoka, Ne nimechmakas. Para ijkó imavistilis noTajtzi ma motta itech iKone. ");
INSERT INTO nsu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tla itla inkitlajtlaniskeh ika notoka, Ne nimechmakas. ");
INSERT INTO nsu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tla imejvah innechtlasojtlah, tonses xikchivakah tlen kijtovah notlanavatilvah. ");
INSERT INTO nsu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iva Ne niktlatlavtis noTajtzi ma imechtitlanili in Teyolchika para nochipa ma yeto inmovah. ");
INSERT INTO nsu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","In Teyolchika yen Tioijyotzintli tlen kiteititia tlen yi neli melajka. In tlaltikpaktlakah tlen amo noaxkavah amo velis kipiaskeh yejón Tioijyotzintli, porke amo kittah iva nion amo kixmatih. Pero imejvah inkixmatih porke kajki inmovah iva nochipa yetos inmovah. ");
INSERT INTO nsu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Amo nimechkavas kemi inmiknomeh. Ne oksemi nivalmokuapas iva inmovah nietos. ");
INSERT INTO nsu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mach ok wejkavas in tlaltikpaktlakah ayakmo nechitaskeh, pero imejvah innechitaskeh. Ne niyolitok nochipa, iva por eso imejvah noijki inyolitoskeh nochipa. ");
INSERT INTO nsu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Itech neká tonali imejvah inkajsikamatiskeh ke Ne nika ivan noTajtzi, iva imejvah inkateh nova, iva Ne nika inmovah. ");
INSERT INTO nsu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tlen kinselia notlanavatilvah iva kinvelkaki, kiteititia nik yi neli nechtlasojtla. Iva tlen nechtlasojtla, noTajtzi kitlasojtlas, iva Ne noijki niktlasojtlas iva nimoteititis inavak. ");
INSERT INTO nsu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ijkuakó Judas, amo Judas Iscariote sino tlen oksé Judas, okitlajtlani: —NoTeko, ¿tleka timoteixmatiltis tonavak iva amo innavak in tlaltikpaktlakah? ");
INSERT INTO nsu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús okinankili: —Tlen nechtlasojtla kijtosneki kichiva tlen nikijtova. NoTajtzi kitlasojtlas, iva noTajtzi ivan Ne tivitzeh tichantikivih inavak. ");
INSERT INTO nsu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Akin amo nechtlasojtla, kijtosneki amo kichiva kuenta tlen nikijtova. In tlajtoli tlen imejvah inkikakih mach Ne notlajtol sino itlajtol noTajtzi tlen onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ne nimechilvia nochi nin tlajtoli mientras ok nika inmovah. ");
INSERT INTO nsu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero in Teyolchika, in Tioijyotzintli tlen noTajtzi kivaltitlanis ika notoka, Ye imechmachtis de nochi, iva imechilnamiktis nochi tlen Ne yonimechilvi. ");
INSERT INTO nsu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Nimechkajteva xietokah ika yolsevilistli. In yolsevilistli tlen Ne nimechmaka amo kemi in yolsevilistli tlen kitemakah in tlaltikpaktlakah. Amo ximotekipachokah iva nion amo ximomavtikah. ");
INSERT INTO nsu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Imejvah yonkikakeh tlen onikijto, onimechilvi nias iva oksemi nivalmokuapas para nietos inmovah. Tla yi neli onnechtlasojtlaskiah, onpakiskiah ijkuak onimechilvi niav inavak noTajtzi, porke noTajtzi okachi wei ke Ne. ");
INSERT INTO nsu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ne yonimechilvi nochi nin tlamantli antes de ijkó tlamochivalos, iva ijkuak ijkó tlamochivalos, imejvah xitlaneltokakah nonavak. ");
INSERT INTO nsu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ayakmo wejkavas nimechtlapovis, porke ompa vitz in Amo Kuali Tlakatl tlen kinnavatia in tlaltikpaktlakah. Pero ye amitla velis nechtoktis. ");
INSERT INTO nsu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero Ne nikchivas tlen nechnavatia noTajtzi, para ijkó ma kimatikah in tlaltikpaktlakah nik yi neli niktlasojtla noTajtzi. Ximoketzakah, ma tiviah de nika. ");
INSERT INTO nsu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Ne nika kemi se tlen yi neli uvaskuavitl iva noTajtzi kajki kemi se tekipano tlen kikuidarova in uvaskuavitl. ");
INSERT INTO nsu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tla se nomamayo amo tlaki, noTajtzi kitzonteki. Pero tla kuali tlaki kichijchipava para okachi ma tlaki. ");
INSERT INTO nsu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iva imejvah yonmochipajkeh, ika notlajtol tlen Ne yonimechilvi. ");
INSERT INTO nsu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xisetitokah nova, kemin Ne nisetitok inmovah. Se imamayo in uvaskuavitl amo velis tlakis iselti. Moneki setitos itech itlaktzonyo. Ijkó noijki, tla imejvah amo insetitoskeh nova, amo velis intlakiskeh, kijtosneki amitla velis inkichivaskeh tlen kuali. ");
INSERT INTO nsu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ne nika kemi se uvaskuavitl iva imejvah inkateh kemi nomamayovah. Tlen setitos nova iva Ne nisetitos iva, tlakis miek. Porke tla amo insetitoskeh nova, amitla velis inkichivaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tlen amo setitos nova, kitzontekiskeh iva kitlamotlaskeh sekka kemi se imamayo in uvaskuavitl tlen amo kuali, iva vakis. Satepa kololoskeh iva kitlamotlaskeh ijtik tlitl para ma tlatla. ");
INSERT INTO nsu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tla imejvah insetitoskeh nova iva inkinchivaskeh tlen nimechilvia, xiktlajtlanikah nochi tlen inkinekiskeh iva Dios imechmakas. ");
INSERT INTO nsu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","NoTajtzi kipias miek pakilistli tla imejvah inkipiaskeh miek tlakilotl, iva ijkó mottas nik yi neli imejvah inmomachtijkeh de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ne nimechtlasojtla imejvah ijkó kemi noTajtzi nechtlasojtla. Xietokah ika notlasojtlalis tlen Ne ika nimechtlasojtla. ");
INSERT INTO nsu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tla inkichivaskeh tlen nimechnavatia, kijtosneki inyeskeh ika notlasojtlalis, ijkó kemin Ne noijki nikchiva tlen nechnavatia noTajtzi iva nika ika itlasojtlalis. ");
INSERT INTO nsu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ne nimechilvia nochi nin tlajtoli para xipakikah kemin Ne nipaki, iva ijkó yi neli xikpiakah pakilistli. ");
INSERT INTO nsu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ye nin tlen nimechnavatia: Ximotlasojtlakah innochtin ijkó kemin Ne nimechtlasojtla. ");
INSERT INTO nsu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tlen motemakas ma kixpolokah por iyoliknivah kijtosneki sa panova kintlasojtla. ");
INSERT INTO nsu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Imejvah yi neli innoyoliknivah, tla inkichivah tlen nimechnavatia. ");
INSERT INTO nsu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayakmo nimechnotzas innotlakavah, porke se tlen san tetlakav amo kimati tlen kichiva iteko. Ne Nimechnotzas innoyoliknivah, porke yonimechtlapovi nochi tlen noTajtzi onechilvi. ");
INSERT INTO nsu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mach imejvah onnechpejpenkeh, sino Ne onimechpejpenki iva nimechnavatia xiviah kan Ne nimechtitlani iva xitlakikah miek. Iva nikneki nochipa xitlaktokah. Iva ijkó nochi tlen inkitlajtlaniliskeh noTajtzi ika notoka, Ye imechmakas. ");
INSERT INTO nsu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ximotlasojtlakah entre imejvah. Ye nin tlen nimechnavatia. ");
INSERT INTO nsu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tla in tlaltikpaktlakah imechkualankaitah, xikmatikah ke Ne achto yonechkualankaitakeh. ");
INSERT INTO nsu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tla imejvah onyeskiah noijki kemi yejvah tlen amo kixmatih Dios, tonses yejvah omechtlasojtlaskiah ijkó kemi yejvah motlasojtlah. Pero imejvah ayakmo inkichivah kemi yejvah kichivah, porke Ne onimechpejpenki para amo xietokah kemi yejvah, iva por eso yejvah imechkualankaitah. ");
INSERT INTO nsu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xikilnamikikah tlen onimechilvi: “Se tlen san tlapalevia amo velis okachi weititos ke iteko.” Tla Ne onechochololtijkeh, imejvah noijki imechochololtiskeh. Iva tla okivelkakeh notlajtol, noijki kivelkakiskeh inmotlajtol. ");
INSERT INTO nsu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Imejvah imechtoktiskeh nochi yejón porke innechneltokah, iva porke yejvah amo kixmatih akin onechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tla Ne amo onivalaskia iva nion amo onikintlapoviskia, tonses amo okipiaskiah tlajtlakoli. Pero axka ayakmitla onka tlen ika velis motenpaleviskeh de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Porke tlen nechkualankaita, kijtosneki noijki kikualankaita noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tla Ne amo onikchivaskia inmixpa itla tlamantli tlen amo kema íkka veli kichiva, tonses yejvah amo okipiaskiah tlajtlakoli. Pero maski yokittakeh yonikchi miek tlamantli, yejvah nechkualankaitah iva noijki kikualankaitah noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ijkí tlamochiva para ma mochiva tlen ijkuilitok itech intlanavatil, kan kijtova: “Onechkualankaitakeh maski amitla onikchi tlen amo kuali.” ");
INSERT INTO nsu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ijkuak vitz in Teyolchika, in Tioijyotzintli tlen tlamachtia tlen melajkayotl, tlen Ne nimechvaltitlanilis de inavak noTajtzi, Ye imechmatiltis de Ne. ");
INSERT INTO nsu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Iva imejvah noijki inkitematiltiskeh de Ne, porke imejvah onkatkah nova desde ijkuak ope nitlamachtia. ");
INSERT INTO nsu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ne nimechilvia nochi nin tlajtoli para mostla viptla amo xikavakah de intlaneltokaskeh nonavak. ");
INSERT INTO nsu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Imechkixtiskeh para semijkak de kan tiotlamachtijkaltih. Ajsis tonali tla íkka imechixpolos kijtos ke ika yejón kichiva se kuali tekitl para Dios. ");
INSERT INTO nsu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ijkó kichivaskeh porke amo kixmatih noTajtzi iva nion Ne amo nechixmatih. ");
INSERT INTO nsu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ijkí nimechilvia para ijkuak ijkó tlamochivalos xikilnamikikah nik Ne yonimechilvi desde achto. ’Achto amo onimechilvi tlen axka nimechilvia, porke onikatka inmovah. ");
INSERT INTO nsu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero axka Ne niav inavak noTajtzi tlen onechvaltitlanki. Iva nion se de imejvah amo nechtlajtlania kan niav. ");
INSERT INTO nsu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yej yope inmoyolkokovah por tlen yonimechilvi. ");
INSERT INTO nsu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero Ne nimechilvia tlen yi neli melajka, nik okachi kuali para imejvah ma nivia. Porke tla amo nias, in Teyolchika mach vitz para yetos inmovah. Pero tla nias, Ne nikvaltitlanis. ");
INSERT INTO nsu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ijkuak Ye vitz, kinmajsikamatiltis in tlaltikpaktlakah nik kateh itech tlajtlakoli. Kinmajsikamatiltis akinmeh kateh kuali inavak Dios. Iva kinmajsikamatiltis nik in Dios se tonali kijtos akin tlajtlakole iva akin amo. ");
INSERT INTO nsu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kinmajsikamatiltis nik kateh itech tlajtlakoli porke amo nechneltokah. ");
INSERT INTO nsu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kinmajsikamatiltis akinmeh kateh kuali inavak Dios porke Ne niav inavak noTajtzi, iva ayakmo innechitaskeh. ");
INSERT INTO nsu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kinmajsikamatiltis nik in Dios se tonali kijtos akin tlajtlakole iva akin amo, porke in Amo Kuali Tlakatl tlen tlanavatijtok itech nin tlaltikpaktli, yokitlajtlakoltijkeh iva yas miktla. ");
INSERT INTO nsu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nikpia okachi tlen moneki nimechilvis, pero axka imejvah amo velis inkajsikamatiskeh. ");
INSERT INTO nsu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero ijkuak vitz in Tioijyotzintli tlen kiteititia tlen yi neli melajka, Ye imechyakanas itech nochi tlen yi neli melajka. Porke amo kijtos itla tlen san Ye kiyejyekos, sino nochi tlen kikakis yen yejón kijtos, iva imechmatiltis nochi tlen satepa tlamochivalos. ");
INSERT INTO nsu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ye kiteititis nomavistilis, porke kiselis de Ne nochi tlen Ye imechmatiltis. ");
INSERT INTO nsu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nochi tlen kipia noTajtzi, Ne noaxka. Por eso onimechilvi ke in Tioijyotzintli kiselis de Ne nochi tlen Ye imechmatiltis. ");
INSERT INTO nsu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Polivi sa kana keski tonali iva imejvah ayakmo innechitaskeh, pero amo wejkavas, oksemi innechitaskeh porke Ne niav inavak noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ijkuakó, sekimeh momachtijkeh omotlatlajtlanijkeh: —¿Tlán kijtosneki tlen techilvia? Kijtova sa kana keski tonali ayakmo tikittaskeh iva amo wejkavas oksemi tikittaskeh, iva kijtova yaski inavak iTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tlán kijtosneki tlen kijtova ke ayakmo wejkavas? Mach tikajsikamatih tlen kijtova. ");
INSERT INTO nsu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús okajsikamatki nik yejvah okinekiah kitlajtlaniiskeh tlán kijtosneki tlen okinmilvi. Ijkuakó okinmilvi: —Ne yonimechilvi polivi sa kana keski tonali iva imejvah ayakmo innechitaskeh, pero amo wejkavas oksemi innechitaskeh. ¿Yen yejón tlen imejvah inmotlajtlaniah? ");
INSERT INTO nsu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yi neli nimechilvia, imejvah inchokaskeh iva inmoyolkokoskeh, pero in tlaltikpaktlakah pakiskeh. Pero maski imejvah inmoyolkokoskeh, inmoneyolkokol mokuapas pakilistli. ");
INSERT INTO nsu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ijkuak se sivatl yi mokokos ika ikone, kikokova ikuerpo porke yoajsik ora para mokokos. Pero satepa ijkuak yokipixki ikone, mach ok kilnamiki kox okikoko ikuerpo, sino yi kipia pakilistli porke yoneski oksé konetl itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ijkó noijki imejvah, axka inmoyolkokovah, pero Ne oksemi nimechitas iva imejvah inpakiskeh, iva amika velis imechkixtilis inmopakilis. ");
INSERT INTO nsu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ijkuak ajsis yejón tonali, ayakmitla innechtlajtlaniiskeh. Yi neli nimechilvia, noTajtzi imechmakas nochi tlen inkitlajtlaniliskeh ika notoka. ");
INSERT INTO nsu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta axka imejvah ayamitla inkitlajtlaniliah ika notoka. Xiktlajtlanikah iva inkiseliskeh, para ijkó yi neli xikpiakah pakilistli. ");
INSERT INTO nsu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nochi nin yonimechtlapovi ika ejemplos, pero vitz in tonali ijkuak ayakmo nimechtlapovis ika ejemplos, sino nimechtlapovis ika seki tlajtoli tlen okachi amo ovi para inkajsikamatiskeh aserka de noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Itech neká tonali imejvah velis itla inkitlajtlaniliskeh noTajtzi ika notoka. Mach nimechilvia nik moneki Ne niktlajtlanilis noTajtzi por imejvah. ");
INSERT INTO nsu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","¡Amo!, porke noTajtzi de por sí imechtlasojtla porke imejvah innechtlasojtlah, iva porke inkineltokah nik Ne nivitz de Dios. ");
INSERT INTO nsu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne onikiski inavak noTajtzi iva onivala itech nin tlaltikpaktli, iva axka nikajteva nin tlaltikpaktli iva nimokuapas oksemi inavak noTajtzi. ");
INSERT INTO nsu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ijkuakó in momachtijkeh okilvijkeh: —Axka kema yi techtlapovijtok ika tlajtoli tlen okachi amo ovi para se kajsikamati, iva ayakmo techtlapovia ika ejemplos. ");
INSERT INTO nsu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Axka yi tikmatih nik tejwatzi nochi tikmati. Tla íkka kineki itla mitztlajtlanis tejwatzi yi tikmati tlen kineki mitztlajtlanis. Por eso tikneltokah nik tivitz de Dios. ");
INSERT INTO nsu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús okinnankili: —¿Axka kema yinnechneltokah? ");
INSERT INTO nsu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya ajsitivitz ora, iva ayakmo wejkavas, ijkuak imejvah inxixiniskeh iva kada se kitzkis iojviv, iva innechkajtevaskeh noselti. Pero amo nika noselti, porke noTajtzi kajki nova. ");
INSERT INTO nsu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nochi nin nimechilvia, para ijkó imejvah xietokah ika kuali nonavak. Imejvah intlajyoviskeh itech nin tlaltikpaktli, pero ximoyolchikavakah porke Ne yoniktlanili in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ijkuak otlanki okintlapovi in momachtijkeh, Jesús oajkotlachixki iva okijto: —NoTajtzi, yoajsik ora. Xikmavistili moKone, para Ye noijki ma mitzmavistili. ");
INSERT INTO nsu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tejwatzi otiktlali ma tlanavati itech nochtin tlaltikpaktlakah, para ma kinmaka nemilistli para semijkak nochtin tlen yotikinmakak. ");
INSERT INTO nsu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","In nemilistli para semijkak kijtosneki ma mitzixmatikah tejwatzi tlen yi neli tiDios, iva noijki ma kixmatikah in Jesucristo tlen otikvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ne yonimitzmavistili itech nin tlaltikpaktli, porke yoniktlami notekiv tlen otechnavati ma nikchiva. ");
INSERT INTO nsu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Axka pues, noTajtzi, techmaka monavak in mavistilistli tlen onikpiaya mova desde ijkuak ayamo okatka nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ninmeh gentejtih tlen otikinpejpenki de nin tlaltikpaktli tlen tejwatzi otechinmakak, Ne yonikinmatilti akin tejwatzi. Yejvah okatkah moaxkavah, pero tejwatzi otechinmakak, axka kineltokah iva kichivah tlen kijtova motlajtol. ");
INSERT INTO nsu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Axka yi kimatih ke nochi tlen nikpia tejwatzi otechmakak. ");
INSERT INTO nsu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Porke nochi tlen tejwatzi otechilvi, Ne yonikinmilvi, iva yejvah yokineltokakeh. Iva yokajsikamatkeh nik yi neli onivala de monavak, iva yokineltokakeh nik tejwatzi otechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ne nimitztlatlavtia por yejvah. Amo nimitztlatlavtia por tlen oksekimeh tlaltikpaktlakah, sino por tlen tejwatzi otechinmakak, porke moaxkavah. ");
INSERT INTO nsu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nochi tlen noaxka, noijki moaxka, iva tlen moaxka, noijki noaxka. Iva nomavistilis motta intech yejvah. ");
INSERT INTO nsu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ne ayakmo nietos itech nin tlaltikpaktli porke yi niav monavak, pero yejvah ok mokavah itech nin tlaltikpaktli. NoTajtzi, tejwatzi tichipavak, tejwatzi xikinkuidaro ika movelitilis tlen otechinmakak, para ma setitokah san sekka ijkó kemi tejvah tisetitokeh san sekka. ");
INSERT INTO nsu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ijkuak Ne onikatka invah itech nin tlaltikpaktli, Ne onikinkuidarovaya ika movelitilis tlen otechinmakak. Ne onikinkuidaro para amo ma moixpolokah, iva nion se de yejvah amo omoixpolo, sino omoixpolo san yen tlen yokatka para moixpolos, para ma mochiva tlen kijtova in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Pero axka ya niav monavak. Iva nikijtova nin tlajtoli mientras ok nika itech nin tlaltikpaktli, para ma velikah ma kipiakah nopakilis, nochi nopakilis tlen nikpia. ");
INSERT INTO nsu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne yonikinmakak motlajtol tlen momachtijkeh, pero in tlaltikpaktlakah kinkualankaitah, porke yejvah ayakmo povih de nin tlaltikpaktli, ijkó kemin Ne noijki amo nipovi de nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amo nimitztlatlavtia xikinkixti de itech nin tlaltikpaktli, sino xikinpalevi para amo ma kinkajkayava in Amo Kuali Tlakatl. ");
INSERT INTO nsu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ijkó kemin Ne amo nipovi de nin tlaltikpaktli, yejvah noijki ayakmo povih de nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xikintlali ma yetokah itech tlen yi neli melajka para ma yekah yolchipavakeh iva ma tekipanokah san para tejwatzi. Motlajtol yen yejón tlen yi neli melajka. ");
INSERT INTO nsu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ijkó kemi tejwatzi otechvaltitlanki innavak in tlaltikpaktlakah, ijkó noijki Ne nikintitlani innavak in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ne nimotemaktia por yejvah para nikchivas tlen tejwatzi tikneki, para ijkó yejvah noijki ma motemaktikah ma kichivakah tlen tejwatzi tikneki por yen motlajtol tlen melajkayotl. ");
INSERT INTO nsu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ne amo nimitztlatlavtia san para yejvah tlen nikinmachtia, sino noijki para tlen satepa tlaneltokaskeh nonavak ijkuak kikakiskeh intlajtol de tlen nikinmachtia. ");
INSERT INTO nsu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ne nimitztlatlavtia ke nochtin yejvah ma setitokah san sekka. Ijkó kemi tejwatzi ivan Ne, tisetitokeh san sekka. Nimitztlatlavtia yejvah noijki ma setitokah tovah. Iva ijkó in tlaltikpaktlakah ma kineltokakah nik tejwatzi otechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","In mavistilistli tlen otechmakak tejwatzi, Ne noijki yonikinmakak para ma setitokah san sekka ijkó kemi tejwatzi ivan Ne tisetitokeh san sekka. ");
INSERT INTO nsu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne nietos innavak, iva tejwatzi tietos nonavak para ijkó yi neli ma setitokah san sekka. Iva ijkó in tlaltikpaktlakah ma kajsikamatikah nik tejwatzi otechvaltitlanki, iva nik yi neli tikintlasojtla ijkó kemi tejwatzi techtlasojtla. ");
INSERT INTO nsu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’NoTajtzi, nikneki ke tlen tejwatzi otechinmakak noijki ma yetokah nova kan Ne nietos, para ma kittakah nomavistilis tlen otechmakak porke nochipa techtlasojtla desde ijkuak ayamo okatka nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","NoTajtzi, tejwatzi titlakamela, in tlaltikpaktlakah amo mitzixmatih, pero Ne nimitzixmati, iva ninmeh tlen otechinmakak yokimatkeh nik tejwatzi otechvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne yonikinmatilti akin tejwatzi, iva ok nikinmatiltijtos, para ke in tlasojtlalistli tlen ika techtlasojtla ma yeto intech yejvah, iva Ne noijki nietos intech yejvah. ");
INSERT INTO nsu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ijkuak Jesús otlanki okijto nin tlajtoli, okiski invan momachtijkeh iva oyajkeh ik nepa lado de kan barranka de Cedrón. Ompa okatka se tlatokkuavyo, iva Jesús ivan momachtijkeh ompa okalakeh. ");
INSERT INTO nsu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, tlen okitemakti in Jesús, okixmatia yejón lugar, porke Jesús ivan momachtijkeh miek welta ompa omololovayah. ");
INSERT INTO nsu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ijkuakó Judas ompa oajsito kinvika miekeh soldadojtih iva sekimeh templojmayoltih. Yejonmeh okintitlankeh in tlayakankeh tiopixkeh ivan fariseos. Ompa oajsitoh ika inkandil iva ika okotl motlavilijtivih, iva okinvikayah intejteposvah. ");
INSERT INTO nsu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero komo Jesús yokimatia nochi tlen omochivaskia, okiski okinnamikito iva okinmilvi: —¿Akin inkitemovah? ");
INSERT INTO nsu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yejvah okinankilijkeh: —Tiktemovah Jesús de Nazaret. Ye okinmilvi: —Yen Ne. Judas, tlen okitemakti in Jesús, ompa omoketoka invan soldadojtih ivan templojmayoltih. ");
INSERT INTO nsu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iva ijkuak Jesús okinmilvi: “Yen Ne”, yejvah otzinkiskeh iva oajketiajkeh ovetzitoh ipan tlali. ");
INSERT INTO nsu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ijkuakó Jesús oksemi okintlajtlani: —¿Akin inkitemovah? Iva yejvah okilvijkeh: —Tiktemovah Jesús de Nazaret. ");
INSERT INTO nsu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús oksemi okinmilvi: —Yonimechilvi nik yen Ne. Tla Ne innechtemovah, tonses xikinkavakah ninmeh ma viah. ");
INSERT INTO nsu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ijkó okijto para ma mochiva tlen Jesús okijtojka: “Tlen tejwatzi otechinmakak, nion se amo omoixpolo.” ");
INSERT INTO nsu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ijkuakó Pedro okixti iespada iva okinakastzonteki in Malco, okitzontekili iyeknakas. Malco okatka itlakeval in wei tiopixki. ");
INSERT INTO nsu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús okilvi in Pedro: —¡Xikalaki moespada kan okatka! Tla noTajtzi kineki ijkó ma nikpano nin tlajyovilistli, tonses moneki ijkó nikpanos. ");
INSERT INTO nsu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ijkuakó in kapita ivan isoldadojvah, iva sekimeh templojmayoltih, okikitzkijkeh in Jesús iva okijilpijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Achto okivikakeh ikalijtik Anás. Anás okatka temonta de Caifás. Iva Caifás okatka wei tiopixki itech yejón xivitl. ");
INSERT INTO nsu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yejón Caifás yen tlen okachi achto okinmilvijka in tlayakankeh judiojtih ke okachi kuali ma ixpolivi san se tlakatl por nochtin toknivah, iva amo nochi topaís ma ixpolivi. ");
INSERT INTO nsu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro ivan oksé momachti okiseguirojkeh in Jesús. Tlen oksé momachti omoixmatia ivan wei tiopixki, por eso ye okalakki ivan Jesús kan ikiavak in wei tiopixki. ");
INSERT INTO nsu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero Pedro omoka kiavak kaltempa. Por eso, tlen oksé momachti tlen iva omixmatia in wei tiopixki, okiski iva omotlapovi ivan se sivatl tlen tlakuidarova kan kaltentli, iva okavili ma kalaki in Pedro. ");
INSERT INTO nsu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ijkuakó yejón sivatl okitlajtlani in Pedro: —¿Te amo noijki titeva timomachti de neká tlakatl? Pedro okinankili: —Amo, ne amo. ");
INSERT INTO nsu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tlen tekipanovah itech yejón kali ivan templojmayoltih, okitlalijkeh tlitl iva omoskojtokah mokejketokeh porke chikavak osevaya. Pedro noijki ompa invah omoskojtoka. ");
INSERT INTO nsu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","In wei tiopixki ope kitlatzintokia in Jesús aserka de tlen momachtijkeh iva de itlamachtil. ");
INSERT INTO nsu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús okinankili: —Ne nochipa onitetlapoviaya inmixpa nochtin gentejtih iva amo san ichtaka. Ne nochipa onitlamachti kan tiotlamachtijkaltih iva kan templo kan mololovah nochtin judiojtih. Amitla onikijto san ichtaka. ");
INSERT INTO nsu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tleka yej Ne techtlatzintokia? Xikintlatzintoki tlen onechkakeh. Yejvah velis mitzilviskeh tlen Ne onikinmilvi. ");
INSERT INTO nsu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ijkuak Jesús ijkó okijto, ijkuakó se templojmayol tlen ompa okatka, okixtlatzini in Jesús iva okilvi: —¿Ijkó timixevia tiknanankilia in wei tiopixki? ");
INSERT INTO nsu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús okinankili: —Tla onikijto itla tlen amo kuali, xikijto tlán amo yompa tlen onikijto. Pero tla onikijto tlen yompa, ¿tleka techixtlatzinia? ");
INSERT INTO nsu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Satepa Anás okititlanki in Jesús ijilpitiv inavak in wei tiopixki Caifás. ");
INSERT INTO nsu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro ok omoketoka omoskojtoka. Iva ompa okitlajtlanijkeh: —¿Te amo titeva timomachti de neká tlakatl? Pedro amo okimokuiti, iva okijto: —Amo, ne amo. ");
INSERT INTO nsu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ijkuakó se itlakeval in wei tiopixki, tlen itla ivan mottah in tlakatl tlen Pedro okinakastzonteki, okitlajtlani: —¿Ke amo te onimitzitak ivan Jesús kan tlatokxochío? ");
INSERT INTO nsu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro oksé welta amo okimokuiti, iva san nima ijkuakó ovaltzajtzik in kaxtil. ");
INSERT INTO nsu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesús okikixtijkeh de ikalijtik in Caifás iva okivikakeh kan palacio kan ochantia in kobernador Pilato. Iva komo yotlanestivalaya, in judiojtih amo okinekeh okalakeh kan palacio para amo mijtlakoskeh porke okinekiah yeskeh chipavakeh para velis kikuaskeh in tlakuali de Pascua. ");
INSERT INTO nsu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por eso Pilato okiski kiavak, iva okintlajtlani: —¿De tlan ik inkiteilviah nin tlakatl? ");
INSERT INTO nsu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yejvah okinankilijkeh: —Nin tlakatl kichiva tlen amo kuali, por eso nika timitzvalikiliah. ");
INSERT INTO nsu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ijkuakó Pilato okinmilvi: —Xikvikakah iva imejvah xikittakah kox tlajtlakole o noso amo, ijkó kemi kijtova inmotlanavatil. In tlayakankeh judiojtih okilvijkeh: —Tejvah tijudiojtih amo techkaviliah íkka ma tikmiktikah. ");
INSERT INTO nsu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ijkó opanolok kemi Jesús okijtojka de kenik ixpolivis. ");
INSERT INTO nsu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato oksemi okalakki kan palacio. Okinotzki in Jesús iva okitlajtlani: —¿Te tiwei tlanavati de judiojtih? ");
INSERT INTO nsu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús okilvi: —¿De te motech kisa techtlajtlania o noso íkka omitzilvi nik Ne niwei tlanavati? ");
INSERT INTO nsu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato okinankili: —Ne mach nijudío. Mopaisanojvah ivan tlayakankeh tiopixkeh yejvah omitztemaktikoh nonavak. ¿Tlán otikchi? ");
INSERT INTO nsu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús okinankili: —Ne amo nitlanavatia itech nin tlaltikpaktli. Tla ijkó oyeskia, notlakavah onechpaleviskiah para amo ma nechtemaktikah inmak in judiojtih. Pero Ne amo nitlanavatia itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ijkuakó Pilato okitlajtlani: —Tonses, ¿kijtosneki tiwei tlanavati? Jesús okinankili: —Te yotikijto ke Ne niwei tlanavati. Para yejón nik onineski iva onivala itech nin tlaltikpaktli para niktematiltis tlen melajkayotl. Nochtin tlen kixmatih iva kijtovah tlen melajkayotl, kimatih nechkakih. ");
INSERT INTO nsu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato okitlajtlani: —¿Iva tlán kijtosneki yejón tlen melajkayotl? Ijkuak Pilato ijkó okitlajtlani in Jesús, oksé welta okiski omotlapovito invan judiojtih, iva okinmilvi: —Ne amo nikajxilia itla tlamantli para velis nikijtos ke nin tlakatl tlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero imejvah inkipiah kostumbre innechtlajtlaniliah kada xivitl itech ilvitl de Pascua ma nikajkava se de yejvah tlen tzaktokeh telpiloya. ¿Inkinekih ma nikajkava in wei tlanavati de judiojtih? ");
INSERT INTO nsu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ijkuakó nochtin otzajtzikeh chikavak, okijtojkeh: —¡Amo, ye amo! ¡Xikajkava in Barrabás! Yejón Barrabás okatka ichtekki. ");
INSERT INTO nsu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ijkuakó Pilato otlanavati ma kivikakah in Jesús iva ma kivitekikah. ");
INSERT INTO nsu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","In soldadojtih okichijchijkeh se korona de vitztli iva okitlalilijkeh itech itzonteko in Jesús, iva okikentijkeh se tlakemitl chichilkatlilmiktik. ");
INSERT INTO nsu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Omotokijkeh inavak Jesús iva okilviayah: —¡Viva in wei tlanavati de judiojtih! Iva okixtlajtlatziniayah. ");
INSERT INTO nsu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato oksemi ovalkiski iva okinmilvi in judiojtih: —Xikittakah, yonikvalkixti nika kiavak, para xikmatikah ke amo nikajxilia itla tlamantli para velis nikijtos ke nin tlakatl tlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús ovalkiski ika se korona de vitztli ipan itzonteko iva okikentivalaya in tlakemitl chichilkatlilmiktik. Ijkuakó Pilato okinmilvi: —¡Nika kajki nin tlakatl! ");
INSERT INTO nsu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ijkuak okittakeh in tlayakankeh tiopixkeh ivan templojmayoltih, ope tzajtzih chikavak: —¡Xikrusifikaro, xikrusifikaro! Pilato okinmilvi: —Imejvah xikvikakah, iva imejvah xikrusifikarokah, porke ne nikitta amitla okichi. ");
INSERT INTO nsu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero in tlayakankeh judiojtih okinankilijkeh: —Tejvah tikpiah se tlanavatili kan kijtova nik kipia tlen mikis, porke kijtova ke Ye iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ijkuak Pilato okikakki tlen okilvijkeh, okachi omomavti. ");
INSERT INTO nsu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilato oksemi okalakki kan palacio iva okitlajtlani in Jesús: —¿Te de kan tivitz? Pero Jesús amo okinankili. ");
INSERT INTO nsu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ijkuakó Pilato okilvi: —¿Amo technankilis? ¿Ke amo tikmati ke ne velis nitlanavatis ma mitzkrusifikarokah o noso ma mitzkajkavakah? ");
INSERT INTO nsu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús okinankili: —Amo otikpiaskia nion itla tlanavatijkayotl itech Ne, tla Dios amo omitzmakaskia tlanavatijkayotl. Por eso, tlen momak onechtemakti, okachi tlajtlakole ke te. ");
INSERT INTO nsu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Desde ijkuakó Pilato ope kitemova kenik velis kikajkavas in Jesús, pero in judiojtih okachi otzajtziah chikavak, okijtovayah: —¡Tla tikajkavas yejón tlakatl, kijtosneki amo moyolikni in César, porke tlen kineki motenevas kemi wei tlanavati, kijtosneki kikualankaita in César, tlen wei tekiva! ");
INSERT INTO nsu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ijkuak Pilato ijkó okikakki, otlanavati ma kivalkixtikah in Jesús, iva Pilato omotlali kan teyekankavah. Kan omotlali, yejón lugar itoka ika tlajtoli hebreo Gabata, kijtosneki piso de tetl. ");
INSERT INTO nsu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yejón tonali yomotlayektlalilijtokah para mostlatis yi ilvitl de Pascua, iva ijkuakó yokatka kemi tlajko tonali. Iva Pilato okinmilvi in judiojtih: —¡Nika kajki nimowei tlanavati! ");
INSERT INTO nsu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero yejvah otzajtzikeh chikavak: —¡Ma miki! ¡Ma miki! ¡Xikrusifikaro! Pilato okinmilvi: —¿Inkinekih ma nikrusifikaro nimowei tlanavati? Pero in tlayakankeh tiopixkeh otlanankilijkeh: —¡Tejvah mach tikpiah oksé wei tlanavati, san yen César! ");
INSERT INTO nsu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ijkuakó Pilato okinmaktili in Jesús para ma kikrusifikarokah, iva yejvah okivikakeh. ");
INSERT INTO nsu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús okiski kikechpanojtiv ikrus asta kan kilviah Mikatzontekomatl tlen ika tlajtoli hebreo itoka Gólgota. ");
INSERT INTO nsu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ompa okikrusifikarojkeh in Jesús iva noijki ompa okinkrusifikarojkeh ok ome tlakah tlanajnakastla, iva Jesús tlatlajkotia. ");
INSERT INTO nsu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato okichi se letrero iva otlanavati ma kitlalikah ikuapak in krus. In letrero okijtovaya: “JESÚS DE NAZARET, WEI TLANAVATI DE JUDIOJTIH.” ");
INSERT INTO nsu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Miekeh judiojtih okilerojkeh yejón letrero porke kan okikrusifikarojkeh in Jesús okatka serka de Jerusalén, iva oijkuilitoka ika hebreo, ika griego iva ika latín. ");
INSERT INTO nsu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","In tlayakankeh tiopixkeh judiojtih okilvijkeh in Pilato: —Amo xikijkuilo: “Wei tlanavati de judiojtih”, sino xikijkuilo: “Tlen moteneva wei tlanavati de judiojtih.” ");
INSERT INTO nsu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato okinnankili: —Tlen yonikijkuilo ijkó ma mokava. ");
INSERT INTO nsu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","In soldadojtih satepa de okikrusifikarojkeh in Jesús, okontilankeh itzotzol in Jesús, okitzotzomonijkeh omotlanki navi pedaso iva okimoxejxelilijkeh entre navi soldadojtih. Noijki okontilankeh itlaken tlen okimokentiaya tlen amo kana oijtzontoka iva okatka ajsitok san se tzotzoli. ");
INSERT INTO nsu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","In soldadojtih okimolvijkeh: —Amo mach tiktzotzomoniskeh, okachi kuali ma timotlanikah, a ver akin kitlanis. Otlamochi ijkó kemi kijtova in Tiotlajkuiloli: “Okimoxejxelilijkeh notlaken iva omotlankeh para kittaskeh akin kimokavis notlaken tlen onikmokentiaya.” Ijkó okichijkeh in soldadojtih. ");
INSERT INTO nsu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ik ikxitla ikrus in Jesús ompa okatka imama, noijki ompa okatka se sivatl ikni de imama, ompa okatka María itonana in Cleofas, iva noijki ompa okatka in María tlen de altepetl Magdala. ");
INSERT INTO nsu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ijkuak Jesús okittak imama okatka inakastlan momachti tlen Jesús sa tlawel okitlasojtlaya, ijkuakó okilvi imama: —Sivatl, nonka kajki mokone. ");
INSERT INTO nsu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Satepa okilvi in momachti: —Nonka kajki momama. Desde ijkuakó yejón momachti okiseli kemi imama iva okivikak para ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Satepa de yejón, komo Jesús yokimatia ke nochi itekiv yotlanki, iva para ma mochiva tlen kijtova in Tiotlajkuiloli, okijto: —¡Namiki! ");
INSERT INTO nsu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ompa okatka se xoktzintzi otentoka de vinagre. Yejvah okapachojkeh se esponja ijtik yejón vinagre, iva okitzikojkeh itech imayo in isopojkuavitl iva okonmakakeh itech iten para ma koni. ");
INSERT INTO nsu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ijkuak Jesús okiyeko in vinagre okijto: —¡Nochi notekiv yotlanki onikchi! Omotzonpilo iva oixpolivik. ");
INSERT INTO nsu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","In judiojtih omotlayektlalilijtokah se tonali antes de ilvitl de Pascua, iva in judiojtih okijtojkeh amo ma mokavakah in mikameh itech inkrus ijkuak sábado, porke wei ilvitl. Por eso okilvijkeh in Pilato ma tlanavati ma kinmetzpojpostekikah tlen okinkrusifikarojkeh para ma mikikah iva ma kintemovikah de kan krus. ");
INSERT INTO nsu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","In soldadojtih oyajkeh iva okinmetzpojpostekeh tlen ome tlakah tlen okinkrusifikarojkeh tlanajnakastla de Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iva ijkuak in soldadojtih omotokijkeh kan okatka in Jesús, okittakeh yoixpolivik. Iva por eso ayakmo okimetzpojpostekeh. ");
INSERT INTO nsu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero se de nonmeh soldadojtih okitzopiti ika se kuavitl yakavitztik kan iomijsikuilpa in Jesús iva niman okiski estli iva atl. ");
INSERT INTO nsu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ne nochi kuali onikittak, iva nimechilvia tlen yi neli, para imejvah noijki xikneltokakah. ");
INSERT INTO nsu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nochi yejón ijkó opanolok para ma mochiva tlen kijtova in Tiotlajkuiloli: “Nion se iomio amo kipostekiliskeh.” ");
INSERT INTO nsu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Iva oksé lado itech Tiotlajkuiloli noijki kijtova: “Kitaskeh tlen okitzopitijkeh kan iomijsikuilpa.” ");
INSERT INTO nsu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Satepa de yejón, José de altepetl Arimatea, tlen okatka momachti de Jesús san ichtaka porke okinmiimakasia in judiojtih, okitlatlavti in Pilato ma kikavili ma kivika ikuerpo in Jesús. Tonses, Pilato okikavili ma kivika. José oyá iva okivikak ikuerpo in Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo noijki oyá ivan José. Nicodemo yen tlen se welta ovia okittato in Jesús de yovak. Ye okivikak kemi senpoali ivan majtlaktli kilo de ajviakayotl, tlen nelitok de mirra ika áloes. ");
INSERT INTO nsu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","José ivan Nicodemo okikemilojkeh ikuerpo in Jesús ika tzotzoli tlen patío tlen okinsiajkeh ika yejón ajviakayotl. Okichijkeh ijkó kemi kipiah kostumbre in judiojtih ijkuak kitooka se mikatl. ");
INSERT INTO nsu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kan okikrusifikarojkeh in Jesús ik ompa serka okatka se tlatokxochío, iva kan yejón tlatokxochío ompa okatka se mikatekochtli yankuik kan ayamika ompa okitookayah. ");
INSERT INTO nsu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ompa okitookakeh in Jesús porke yejón mikatekochtli okatka serka, iva porke yopevaskia in tonali sábado ijkuak in judiojtih omotlayektlaliliayah para moseviskeh. ");
INSERT INTO nsu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","In primer tonali de yejón samana ijkuak ok tlayovatok, María tlen de altepetl Magdala oyá kan mikatekochtli iva okittak ayakmo tentzaktok ika tetl. ");
INSERT INTO nsu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ijkuakó María omotlelo oyá kan okatka Simón Pedro ivan oksé momachti tlen Jesús okitlasojtlaya, iva okinmilvi: —Okivikakeh ikuerpo in toTeko de kan mikatekochtli, iva amo tikmatih kan okavatoh. ");
INSERT INTO nsu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ivan oksé momachti okiskeh iva oyajkeh kan mikatekochtli. ");
INSERT INTO nsu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nochtin omeh omotlelojkeh san sekka, pero tlen oksé momachti omotlelo okachi ke Pedro iva achto oajsito kan mikatekochtli. ");
INSERT INTO nsu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Omotoolo para ontlachias ijtik mikatekochtli, iva okinmitak in tzotzoltih ompa okatkah, pero amo okalakki. ");
INSERT INTO nsu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Satepa oajsito in Simón Pedro, tlen sa ikuitlapa oyaya, iva okalakki kan mikatekochtli. Ye noijki okinmitak in tzotzoltih ompa okatkah. ");
INSERT INTO nsu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iva noijki okittak in tzotzoli tlen ika okuakemilitoka in Jesús, mach okatka ivan tzotzoltih tlen ika okemilojkeh, sino okatka sekka ololitok. ");
INSERT INTO nsu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ijkuakó noijki okalakki tlen oksé momachti tlen achto oajsito kan mikatekochtli. Okittak nochi, iva okineltokak. ");
INSERT INTO nsu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","In momachtijkeh de Jesús ayamo okajsikamatiah tlen kijtova in Tiotlajkuiloli, nik Jesús omoyolitiskia satepa. ");
INSERT INTO nsu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Satepa in Pedro ivan oksé momachti omokuapkeh para inkalijtik. ");
INSERT INTO nsu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María tlen de altepetl Magdala omoka chokatok inakastla mikatekochtli. Iva ijkuak omotoolo para oontlachixki ik tlatlaijtik, ");
INSERT INTO nsu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","okinmitak ome ilvikaktlatitlaniltih ika intlaken istak. Oyejyetokah kan okatka ikuerpo in Jesús, se ik ikuatzontla iva oksé ik ikxitla. ");
INSERT INTO nsu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","In ilvikaktlatitlaniltih okitlajtlanijkeh in María: —Sivatl, ¿tleka tichoka? Ye okinnankili: —Okivikakeh ikuerpo in noTeko iva amo nikmati kan okikavatoh. ");
INSERT INTO nsu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ijkuak María ijkó okinmilvi, omokuapki iva okittak in Jesús ompa moketok, pero amo okixmatki kox Ye. ");
INSERT INTO nsu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ijkuakó Jesús okitlajtlani: —Sivatl, ¿tleka tichoka? ¿Akin tiktemova? María okiyejyeko xamo yen tlakatl tlen kikuidarova in tlatokxochío, iva okilvi: —Tla tejwatzi otikvikak in kuerpo, techilvi kan otikavato, iva ne nikuiti. ");
INSERT INTO nsu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iva Jesús okilvi: —¡María! Ye omokuapki iva okilvi ika tlajtoli hebreo: —¡Raboni! —kijtosneki Tlamachti. ");
INSERT INTO nsu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús okilvi: —Techkajkava, porke ayamo niav ilvikak inavak noTajtzi. Pero xivia xikinmilviti noknivah ke niav kan kajki noTajtzi tlen imejvah noijki inmoTajtzi, tlen Ne noDios iva tlen imejvah noijki inmoDios. ");
INSERT INTO nsu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ijkuakó María tlen de altepetl Magdala oyá okinmilvito in momachtijkeh nik okittak in toTeko, iva okinmilvi nochi tlen Jesús okilvi. ");
INSERT INTO nsu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","In primer tonali de yejón samana ijkuak otlayovak, in momachtijkeh omololojkeh iva omokaltzajtzakeh porke okinmiimakasiah in tlayakankeh judiojtih. Ijkuakó Jesús ovalmonexti ik tlatlajko de kan yejvah okatkah iva okintlajpalo, okinmilvi: —¡Xietokah ika kuali! ");
INSERT INTO nsu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Satepa de ijkó okinmilvi, okimititi imavah iva iomijsikuilpa. Yejvah sa tlawel opakeh ijkuak okittakeh in toTeko. ");
INSERT INTO nsu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús oksemi okinmilvi: —¡Xietokah ika kuali! Ijkó kemi noTajtzi onechvaltitlanki, ijkó Ne noijki nimechtitlani. ");
INSERT INTO nsu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ijkuak ijkó okijto, okinmijpitzki iva okinmilvi: —Xikselikah in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tlen imejvah inkitlapojpolviskeh de itlajtlakol, kipias tlapojpolvilistli. Iva tlen amo inkitlapojpolviskeh de itlajtlakol, mokavas tlajtlakole. ");
INSERT INTO nsu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, se de tlen majtlaktli ivan ome momachtijkeh, tlen okilviayah Nenetl, mach ompa okatka ivan momachtijkeh ijkuak Jesús okinmonextili. ");
INSERT INTO nsu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Satepa, tlen oksekimeh momachtijkeh okilvijkeh in Tomás: —Yotikittakeh in toTeko. Pero ye okinmilvi: —Ne mach nikneltoka. Moneki achto nikinmitas imavah kan okimakojkuyonijkeh ika klavos iva moneki nikalakis nomajpil ompa kan okimakojkuyonijkeh. Iva noijki moneki nikalakis noma kan iomijsikuilpa, para nikneltokas. ");
INSERT INTO nsu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ovalchikometik, in momachtijkeh oksemi omololojkeh itech se kali iva Tomás noijki ompa okatka. Nochtin kaltenmeh otzajtzaktokah, iva Jesús oksemi ovalmonexti ik tlatlajko, iva okinmilvi: —¡Xietokah ika kuali! ");
INSERT INTO nsu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Satepa okilvi in Tomás: —Xikinmita nomavah iva xikalaki momajpil itech noma. Noijki xikalaki moma ik noomijsikuilpa. Xitlaneltoka, amo xieto seppa amo titlaneltokak. ");
INSERT INTO nsu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ijkuakó Tomás okilvi: —¡Tejwatzi tinoTeko iva tinoDios! ");
INSERT INTO nsu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús okilvi in Tomás: —Axka tikneltoka porke otechitak. ¡Ma pakikah tlen amo nechittah iva nechneltokah! ");
INSERT INTO nsu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús okinchi miekeh oksekimeh tetzavkaneskayomeh inmixpan momachtijkeh, tlen amo ijkuilitokeh itech nin libro. ");
INSERT INTO nsu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero nochi nin tlen ijkuilitok itech nin libro, omijkuilo para imejvah xikneltokakah ke Jesús yen Cristo, iKone toTajtzin Dios. Iva tla imejvah intlaneltokaskeh inavak, velis inkipiaskeh nemilistli para semijkak por medio de Ye. ");
INSERT INTO nsu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Satepa de yejón, Jesús oksemi okinmonextili in momachtijkeh itempan atl tlen wei de Tiberias. Ijkí nik opanolok: ");
INSERT INTO nsu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","In momachtijkeh okatkah san sekka, okatka in Simón Pedro, Tomás tlen okilviayah Nenetl, Natanael tlen de Caná de Galilea, itelpochvah in Zebedeo iva ok ome momachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro okinmilvi: —Niav nikinkitzkiti michimeh. Yejvah okinankilijkeh: —Ma tiviah mova. Tonses oonnevakeh, otlejkokeh itech se barko. Pero yejón yovak mach itla michi okajsikeh. ");
INSERT INTO nsu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ijkuak yotlanestivalaya, Jesús okinmonextili itempan atl tlen wei, pero in momachtijkeh amo okimatiah kox yen Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús okinmilvi: —Telpokameh, ¿onkinmajsikeh michimeh? Yejvah okinankilijkeh: —Amo. ");
INSERT INTO nsu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ijkuakó Jesús okinmilvi: —Xikontlamotlakah inmored ik iyekmapa in barko iva inkinmajsiskeh michimeh. Tonses, yejvah ijkó okichijkeh, iva satepa ayakmo oveliah okikixtiayah inred, porke okinkitzkijkeh sa tlawel miekeh michimeh. ");
INSERT INTO nsu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ijkuakó in momachti tlen Jesús okitlasojtlaya okilvi in Pedro: —¡Yen toTeko! Ijkuak ijkó okikakki in Simón Pedro nik yen inTeko, san nima okonakijtivetzki itzotzol, porke okatka xipetztik iva omotlamotlak ijtik atl. ");
INSERT INTO nsu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tlen oksekimeh momachtijkeh oajsitoh atentli itech barko, okitilantiayah in red tentok de michimeh. Okatka sa kana se sien metros de kan atentli. ");
INSERT INTO nsu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ijkuak otemokeh de itech barko, okittakeh se michi iva se pan ipan tlixochtli. ");
INSERT INTO nsu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús okinmilvi: —Xikinvalikakah sekimeh michimeh tlen yikin onkoninkitzkijkeh. ");
INSERT INTO nsu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro otlejkok kan barko iva okitilanki in red asta atentli tentok de wejwei michimeh. Okinpoh, okinkitzkijkeh se siento ivan ompoali ivan majtlaktli ivan eyi michimeh. Maski okinkitzkijkeh miekeh michimeh, in red mach otzomonki. ");
INSERT INTO nsu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ijkuakó Jesús okinmilvi: —Xivikikah xitlakuakih. Nion se momachti amo omixevi okitlajtlani akin Ye, porke kuali yokimatiah nik yen Jesús. ");
INSERT INTO nsu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Satepa Jesús omotoki, okontilanki in pan iva okinmajmakak. Noijki okontilanki in michi iva okinmajmakak. ");
INSERT INTO nsu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ika yejón omochi ya eyi welta okinmonextili in momachtijkeh satepa de omoyoliti. ");
INSERT INTO nsu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Satepa de otlankeh otlakuajkeh, Jesús okitlajtlani in Simón Pedro: —Te Simón, tiipiltzi in Jonás, ¿techtlasojtla okachi ke yejvah? Pedro okinankili: —Ajá, noTeko, tejwatzi kuali tikmati nik nimitzneki. Jesús okilvi: —Xikintlamaka tlen nechseguirovah, porke kateh kemi nochkakonevah. ");
INSERT INTO nsu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús oksemi okitlajtlani: —Te Simón, tiipiltzi in Jonás, ¿techtlasojtla? Pedro okinankili: —Ajá, noTeko, tejwatzi kuali tikmati nik nimitzneki. Jesús okilvi: —Xikinkuidaro tlen nechseguirovah, porke kateh kemi nochkavah. ");
INSERT INTO nsu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús oksemi okitlajtlani ya eyi welta: —Te Simón, tiipiltzi in Jonás, ¿techneki? Pedro omoyolkoko porke Jesús ya ipan eyi welta okitlajtlani kox kineki. Iva okinankili: —NoTeko, tejwatzi kuali tikmati nik ne nimitzneki. Jesús okilvi: —Xikintlamaka tlen nechseguirovah, porke kateh kemi nochkavah. ");
INSERT INTO nsu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yi neli nimitzilvia, ijkuak otikatka titelpochtli, te monevia otikonakiaya motzotzol iva otiaya san kan te otiknekia. Pero ijkuak tivevejtis, tikintlatztilanas momavah iva oksé mitzonakiltis motzotzol, iva mitzvikas kan amo tiknekis tias. ");
INSERT INTO nsu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús ijkó okilvi, kijtosneki kenik ixpolivis in Pedro satepa, iva kenik kimavistilis in Dios ika imikilis. Iva satepa de ijkó okitlapovi, Jesús okilvi: —Xiviki nova. ");
INSERT INTO nsu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ijkuak Pedro omokuapki, okittak tlen oksé momachti tlen Jesús okitlasojtlaya, oyaya inkuitlapa, tlen achto omonakasiktekak itech Jesús ijkuak okikuajkeh in tlakuali de Pascua, iva okitlajtlanijka: “¿Akin mitztemaktis tejwatzi?” ");
INSERT INTO nsu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ijkuak Pedro okittak yejón momachti, okitlajtlani in Jesús: —NoTeko, ¿iva ye tlán mochivas? ");
INSERT INTO nsu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús okinankili: —Tla Ne niknekis ma yolito asta ijkuak nivalmokuapas oksemi, te mach motekiv. Te xiviki nova. ");
INSERT INTO nsu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ijkuakó yejón tlajtoli niman oxitinki itech nochtin toknivah tlaneltokakeh, ke neká momachti amo ixpolivis. Pero Jesús mach okijto ke amo ixpolivis, sino Ye okijto: “Tla Ne niknekis ma yolito asta ijkuak nivalmokuapas oksemi, te mach motekiv.” ");
INSERT INTO nsu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Neká tlen oksé momachti kijtosneki yen ne. Ne onikittak tlen opanolok iva onikijkuilo itech nin libro. Iva imejvah inkimatih ke nochi tlen nikijtova, yi neli. ");
INSERT INTO nsu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús okichi okseki miek tlamantli. Iva tla okijkuiloskiah itech librojtih nochi tlen Jesús okichi, yejonmeh librojtih amo oakiskiah itech nochi nin tlaltikpaktli. Ijkó ma yeto.");
INSERT INTO nsu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nokni Teófilo, itech tlen yikinika libro, onikijkuilo nochi tlen Jesús okichi iva nochi tlen otlamachti desde ijkuak okipevalti itekiv, ");
INSERT INTO nsu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","iva asta ijkuak oyá ilvikak. Antes de oyaskia ilvikak, Jesús okintlapovi itiotlatitlanilvah tlen Ye okinpejpenki. Iva ika yen Tioijyotzintli okinnavatijtevak tlán moneki kichivaskeh. ");
INSERT INTO nsu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ompoali tonaltih satepa de oixpolivik, Jesús okinmonextili itiotlatitlanilvah miek welta para ma kimomakakah kuenta nik in Ye yolitok. Iva okintlapovi de kenik tlanavatia in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Se welta ijkuak Jesús ok okatka invan tiotlatitlaniltih, okinnavati amo ma viah de Jerusalén. Okinmilvi: —Nika xikchiakah asta ma mochiva tlen noTajtzi yomechkakiti, ijkó kemin Ne noijki yonimechilvi. ");
INSERT INTO nsu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan otlabautisaro ika atl, pero ayakmo wejkavas imejvah inmobautisaroskeh ika Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tlen omololojkeh ivan Jesús, okitlajtlanijkeh: —ToTeko, ¿tikmakixtis itech ninmeh tonaltih in topaís de Israel para oksejpa sa iselti ma monavati? ");
INSERT INTO nsu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús okinnankili: —San yen noTajtzi kimati keman mochivas tlen Ye kineki ma mochiva. Imejvah amo inmechtokarova inkimatiskeh. ");
INSERT INTO nsu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ijkuak in Tioijyotzintli vitz inmotech, imejvah inkiseliskeh velitilistli iva inyaskeh intetlapovitivih de Ne ik Jerusalén, ik nochi in región de Judea iva de Samaria, iva asta kan sa ik tlami in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Satepa de otlanki ijkó okinmilvi, Jesús oyá otlejkotia para ilvikak. Mientras yejvah okajkovitokah, se mixtli okimokenki iva ayakmo okittakeh. ");
INSERT INTO nsu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iva ijkuak ok okajkovitokah kenomi nik oyaya itech ilvikak, ijkuakó ome tlakah tlakentokeh de istak omonextijkeh ik innakastla, ");
INSERT INTO nsu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","iva okintlajtlanijkeh: —Tlakah de Galilea, ¿tleka onkajkovitokeh in ilvikak? Nin Jesús tlen okatka inmovah iva tlen yokivikakeh para ilvikak, vitz oksemi ijkó kemi imejvah onkittakeh oyá. ");
INSERT INTO nsu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","In tiotlatitlaniltih omokuapatoh de kan tepetl tlen itoka Olivos iva oyajkeh para Jerusalén, kemi se kilómetro de wejka ijkó kemi itlanavatil Moisés okitekaviliaya ma se nejnemi ijkuak sábado. ");
INSERT INTO nsu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ijkuak oajsitoh Jerusalén, okalakeh kalijtik iva otlejkokeh tlakpak itech oksé piso kan yejvah okalotitokah. Ompa okatka in Pedro, Juan, Jacobo, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo ipiltzi in Alfeo, Simón tlen opovia invan cananistas, iva Judas ipiltzi in Jacobo. ");
INSERT INTO nsu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nochtin yejvah omololovayah nochipa para modiostzajtziliskeh san sekka ivan sekimeh sivameh, ivan María imama in Jesús, iva noijki ivan iknivah in Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Itech yejonmeh tonaltih omololojkeh in toknivah tlaneltokakeh kemi se siento ivan senpoali. Pedro omoketzki tlatlajko iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Noknivah, yomochi tlen kijtova in Tiotlajkuiloli, ijkuak in Tioijyotzintli okijto por medio de David tlen okipanoskia in Judas, tlen okinyakanki tlen okitzkijkeh in Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas opovia tovah iva noijki tovah otekipanovaya. ");
INSERT INTO nsu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero in tomi tlen okimakakeh por okichi tlen amo kuali, ika omotlalkovi. Iva satepa ompa ovetzito ika itzonteko, otlalixtzayanki iva asta okiski nochi itoxi. ");
INSERT INTO nsu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","In chanejkeh de Jerusalén ijkuak okimatkeh, okitokayotijkeh yejón tlali Acéldama, ika intlajtol arameo kijtosneki Tlali de Estli. ");
INSERT INTO nsu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Itech libro de Salmos ijkuilitok: Ikalijtik ma mokava iselti kali, iva amika ompa ma chanti. Itech oksé Salmo noijki ijkuilitok: Tlen de ye itekiv ma kiseli oksé tlakatl. ");
INSERT INTO nsu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nika kateh sekimeh tlakah tlen tovah onemiah nochipa ijkuak otinemiah ivan toTeko Jesús, ");
INSERT INTO nsu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde ijkuak in Juan okibautisaro in Jesús iva asta ijkuak otlejkok para ilvikak. Tonses moneki se de yejvah tovah ma mosetili, para ijkó tovah ma kitematilti ke Jesús omoyoliti. ");
INSERT INTO nsu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ijkuakó okinpejpenkeh ome tlakah. Se itoka José Barsabás tlen okinotzayah Justo, iva oksé itoka Matías. ");
INSERT INTO nsu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Satepa omodiostzajtzilijkeh okijtojkeh: —ToTeko, tejwatzi tikinmixmati nochtin gentejtih itech inyolo, techititi katli ye de ninmeh ome tlakah tlen yotikpejpenki ");
INSERT INTO nsu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para ma tekipano kemi tiotlatitlanili ipatka in Judas, tlen okipolo itekiv de tiotlatitlanili iva oyá kan omonekia yetos. ");
INSERT INTO nsu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ijkuakó omotlaankeh, iva otlatlanki in Matías, iva desde ijkuakó omosetili invan oksekimeh majtlaktli ivan se tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ijkuak oajsik ilvitl de Pentecostés, nochtin toknivah tlaneltokakeh okatkah san sekka itech se lugar. ");
INSERT INTO nsu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","San de repente, ovala de ilvikak se tlaijkoyukalistli kemi se ejekatl chikavak. Yejón tlaijkoyukalistli omokakki chikavak itech nochi kalijtik kan yejvah okatkah. ");
INSERT INTO nsu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iva ovalmonextijkeh sekimeh tlimeh mimilintokeh tlen omoxexelojkeh iva omotlalijkeh intech kada sejse de yejvah. ");
INSERT INTO nsu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iva nochtin otenkeh de Tioijyotzintli iva ope tlapovah ika oksekimeh tlajtoltih. Kada se otlapovaya ijkó kemi in Tioijyotzintli okinekia ma tlapova. ");
INSERT INTO nsu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Itech yejonmeh tonaltih okatkah Jerusalén miekeh judiojtih tlen sa tlawel omotemaktiayah inavak Dios. Yejonmeh judiojtih ovalajkeh de sentetl de itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ijkuak okikakkeh otlaijkoyukak, san nima omololojkeh miekeh gentejtih. Omotetzavijkeh porke okinkakeh toknivah tlaneltokakeh otlajtovayah ika intlajtol de kada sejsen de yejonmeh gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sa otlatlachixkeh iva omotetzavijkeh, iva okimolviayah: —¿Amo ovalajkeh de Galilea nochtin ninmeh tlen tlapojtokeh? ");
INSERT INTO nsu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pero kada se de tejvah tikinkakih techtlapoviah ika totlajtol, ¿kenik velih? ");
INSERT INTO nsu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tejvah otivalajkeh de miek países de itech nin tlaltikpaktli. Sekimeh ovalajkeh de país de Partia, de Media, de Elam, de Mesopotamia, de Judea, de Capadocia, de Ponto iva de Asia, ");
INSERT INTO nsu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","sekimeh de Frigia, de Panfilia, de Egipto iva de regionmeh de Africa serka kan kajki in altepetl de Cirene. Noijki nika kateh sekimeh de Roma tlen nika chantih. Sekimeh de yejvah judiojtih iva sekimeh tlen okalakeh itech intiotlamachtil in judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Noijki ovalajkeh sekimeh de Creta iva de Arabia. Tinochtin tivelih tikajsikamatih in wejwei tlamantih tlen yejvah kijtovah de Dios. ");
INSERT INTO nsu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nochtin sa otlatlachiayah iva omotetzaviayah, iva omotlajtlaniayah: —¿Tlán kijtosneki nochi nin tlamantli tlen tlamochivalo? ");
INSERT INTO nsu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero sekimeh okinpinaviayah, okijtovayah: —¡Ninmeh ivintih! ");
INSERT INTO nsu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ijkuakó Pedro omoketzki ivan tlen oksekimeh majtlaktli ivan se tiotlatitlaniltih, iva chikavak okijto: —Imejvah tlen injudiojtih iva nochtin tlen inchantih Jerusalén, kuali xikakikah porke nikneki nimechilvis se tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ninmeh mach ivintih kemi imejvah inkiyejyekovah, porke yikin las nueve. ");
INSERT INTO nsu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nika tlamochijtok tlen yi wejkavitl okijto in tiotenejmachti Joel: ");
INSERT INTO nsu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ToYejwatzi kijtova: Itech sa ik tlami tonaltih, nikinmakas noTioijyotzi nochtin tlaltikpaktlakah. Inmochokojvah iva inmotakojvah tiotlanejmachtiskeh de notlajtol. Inmotelpokavah kittaskeh tetzavistlachialistih, inmokojkolvah kiteemikiskeh tlen Ne nikinmititis. ");
INSERT INTO nsu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Itech nekateh tonaltih nikinmakas noTioijyotzi tlen notekipanojkavah, tlakah ivan sivameh, iva tiotlanejmachtiskeh de notlajtol. ");
INSERT INTO nsu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nikinchivas wejwei nexkuitiltih itech ilvikak, iva neskayomeh itech tlaltikpaktli: mottas estli, tlitl iva miek poktli. ");
INSERT INTO nsu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","In tonali ayakmo tlavis, iva in metzi chichilevis kemi estli. Ijkó tlamochivalos antes de ajsis in tonali ijkuak vitz in toTeko, yejón tonali yetos wei iva mavissotlanexo. ");
INSERT INTO nsu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iva nochtin tlen kinotzaskeh ika itoka in toTeko para ma kinmakixti, Ye kinmakixtis. ");
INSERT INTO nsu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Imejvah tlen de Israel, xikakikah tlen nimechilvis: Kemi imejvah kuali inkimatih, toYejwatzi okiteititi inmoixpa itlanavatijkayo in Jesús de Nazaret, iva yejón toYejwatzi omechititi ika tlamantih tlen tetlatlachialtijkeh, nexkuitiltih iva neskayomeh, tlen Jesús okinchi. ");
INSERT INTO nsu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Desde achto, toYejwatzi okimonekilti ke Jesús ma tlajyovi iva ma kitemaktikah inmomak. Tonses, imejvah onkikitzkijkeh in Jesús iva in gentejtih tlen amo kuali inyelis omechpalevijkeh para onkixpolojkeh itech se krus. ");
INSERT INTO nsu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero toYejwatzi okitotonki de itech itonevilis mikilistli tlen okilpijkah iva okiyoliti. Porke in mikilistli amo okipixki velitilistli para kipixtos imak. ");
INSERT INTO nsu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yi wejkavitl David okijto aserka de Jesús: Nochipa onikittaya in noTeko noyakapa. Amika velis itla nechtoktis porke Ye kajki ik noyekmapa para nechpalevis. ");
INSERT INTO nsu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por eso paki noyolo iva nitlakuika ika pakilistli. Nokuerpo mosevis ika nechialistli. ");
INSERT INTO nsu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porke amo tikavas noanima kan kateh mikameh, nion amo tikavas ma ijtlakavi ikuerpo de motekipano yolchipavak. ");
INSERT INTO nsu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Otechititi in ojtli kan nias para nikpias nemilistli, iva monavak nikpias miek pakilistli. ");
INSERT INTO nsu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Noknivah, techkavilikah ma nimechtlapovi tlen yi neli melajka de yen David, tlen okatka weititok tokojkol, ye oixpolivik iva okitookakeh, iva asta axka tikmatih kan toktok. ");
INSERT INTO nsu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David okatka tiotenejmachti, iva okimatia nik in toYejwatzi okimakak itlajtol ke se de iwejkaixvi tlen satepa nesis yetos wei tlanavati kemi ye. ");
INSERT INTO nsu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tonses, kemi oyeskia okonittoka, David okijto nik omoyolitiskia in Cristo. Okijto nik in toYejwatzi amo okikavaskia kan kateh mikameh iva ikuerpo amo oijtlakaviskia. ");
INSERT INTO nsu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iva tejvah tinochtin titestigojtih nik toYejwatzi okiyoliti in Jesús, ");
INSERT INTO nsu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","iva okivikak para ilvikak iva okitlali ik iyekmapa. ToTajtzin Dios okiteekili toTeko Jesús in Tioijyotzintli. Iva axka Jesús yotechmakak noijki yejón Tioijyotzintli tlen desde achto yotechilvi techmakas. Iva yen yejón tlen axka imejvah inkittah iva inkikakih. ");
INSERT INTO nsu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porke amo yen David tlen otlejkok ilvikak, porke ye inevia okijto: In toYejwatzi okilvi in noTeko: “Ximotlali ik noyekmapa, ");
INSERT INTO nsu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta kan ma nikintlali itlampa mokxivah tlen mitztlavelitah.” ");
INSERT INTO nsu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Innochtin imejvah tlen de Israel moneki xikmatikah, ke Jesús tlen imejvah onkixpolojkeh itech krus, toYejwatzi okitlali ma yeto yen toTeko iva yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ijkuak okikakkeh yejón tlajtoli, sa tlawel omoyolkokojkeh, iva okitlajtlanijkeh in Pedro ivan oksekimeh tiotlatitlaniltih: —Noknivah, ¿tlán moneki tikchivaskeh? ");
INSERT INTO nsu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro okinnankili: —Ximoyolkopakah, iva ximobautisarokah kada se de imejvah ika itoka in Jesucristo para ijkó toYejwatzi ma imechtlapojpolvi de inmotlajtlakol. Iva ijkó Ye imechmakas in Tioijyotzintli kemi se tlatliokolili. ");
INSERT INTO nsu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","In toYejwatzi okijto imechmakas in Tioijyotzintli imejvah iva inmopilvah, iva noijki nochtin tlen kateh wejka, kijtosneki nochtin tlen toYejwatzi kijtos kinnotzas. ");
INSERT INTO nsu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro okinmilvi okseki miek tlamantli iva okinnajnavati, okinmilvi: —Ximachivakah de intzalan tlajtlakolejkeh para amo imechajsis in tlajyovilistli tlen yejvah kinchia. ");
INSERT INTO nsu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tonses, tlen okineltokakeh tlen okijto in Pedro, omobautisarojkeh. Yejón tonali otlaneltokakeh kemi eyi mil gentejtih iva omosetilijkeh ivan oksekimeh tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iva nochtin okimochikaviliayah momachtiskeh tlen okinmachtiayah in tiotlatitlaniltih, omololovayah san sekka, okikuayah in tlakuali de toTeko iva omodiostzajtziliayah. ");
INSERT INTO nsu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nochtin gentejtih ope kimakasih in Dios por yen tetlatlachialistih ivan neskayomeh tlen okinchivayah in tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nochtin tlaneltokakeh okatkah san sekka iva okimoxejxeliliayah nochi tlen okipiayah. ");
INSERT INTO nsu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Okinnemakayah intlalvah iva okseki tlamantli tlen inmaxka iva in tomi okinxejxeliliayah tlen okachi okinpolovaya. ");
INSERT INTO nsu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nochi tonali omololovayah kan templo, iva itech inkajkalijtik okikuayah in tlakuali de toTeko, iva otlakuayah san sekka ika kuali inyolo iva ika pakilistli, ");
INSERT INTO nsu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","iva okiweijkachivayah in Dios, iva nochtin gentejtih okintlakitayah in tlaneltokakeh. Nochi tonali in toTeko okichivaya ke tlen momakixtijtivih ma mosetilikah invan tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Se tonali, Pedro ivan Juan oyajkeh kan templo de Jerusalén kemi las tres de tiotlaki para modiostzajtziliskeh. ");
INSERT INTO nsu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ompa kan templo okatka se vilantzi desde oneski, nochi tonali okivikayah iva okitlaliayah ompa kaltempa kan kilviah Kualtzin Kaltentli, iva okintlajtlaniliaya tomi tlen ompa okalakiah. ");
INSERT INTO nsu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ijkuak in vilantzi okinmitak in Pedro ivan Juan yi kalaktivih kan templo, okintlajtlanili limosna. ");
INSERT INTO nsu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro ivan Juan okitlajtlatakeh itech ixtololovah in vilantzi, iva Pedro okilvi: —Techvalita. ");
INSERT INTO nsu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","In vilantzi okinyekittak, iva okichixtoka ma kimakakah itla tomi. ");
INSERT INTO nsu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero in Pedro okilvi: —Amo nikpia plata nion oro, pero tlen nikpia nimitzmaka: ika itoka in Jesucristo de Nazaret, ximoketza iva xinejnemi. ");
INSERT INTO nsu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ijkuakó Pedro okontilanki itech iyekma iva okiketzalti. San nima ijkuakó omochikajkeh ikxivah iva ikxikechtlanvah. ");
INSERT INTO nsu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Oajkotzikuinki iva omoketzki iva ope nejnemi kuali. Okalakki kan templo ivan tiotlatitlaniltih, nejnentiv iva ajkotzikuintiv iva okiweijkachijtiaya in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ijkuak nochtin gentejtih okittakeh yi nejnemi iva kiweijkachiva in Dios, ");
INSERT INTO nsu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","okiyekixmatkeh nik yen tlakatl tlen ompa omotlaliaya okitlajtlania limosna kan templo kaltempa kan kitokayotiah Kualtzi Kaltentli. Iva yi neli omotetzavijkeh iva omomavtijkeh por tlen otlamochivalok. ");
INSERT INTO nsu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","In tlakatl tlen opajtik ayakmo okinkavaya in Pedro ivan Juan. Nochtin gentejtih sa omotetzaviayah iva omotlelojkeh oyajkeh okinmitatoh kan kitokayotiah Korredor de Salomón. ");
INSERT INTO nsu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","In Pedro ijkuak ijkó okittak, okinmilvi: —Tatanmeh de Israel, ¿tleka inmotetzaviah? ¿Tleka intechtlajtlatah kemi oyeskia tejvah otikchijkeh ma nejnemi nin tlakatl ika tovelitilis o noso ika totemaktilis inavak toYejwatzi? ");
INSERT INTO nsu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yen toYejwatzi Dios okipajti. Tlen Dios de Abraham, de Isaac, iva de Jacob, tlen yi wejkavitl tokojkolvah, okimakak wei tetlakitalistli itekipano Jesús, tlen imejvah onkitemaktijkeh para ma kixpolokah. Iva ijkuak Pilato okinekia kikajkavas, imejvah amo onkinekeh. ");
INSERT INTO nsu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Imejvah yej onkitlajtlankeh ma kikajkavakah se tlakatl tlen temiktiani, iva amo onkinekeh ma kikajkavakah tlen omotemakti inavak toYejwatzi iva oyá tlakamela. ");
INSERT INTO nsu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Imejvah onkixpolojkeh tlen techmaka nemilistli, pero toYejwatzi okiyoliti, iva de yejón tejvah titestigojtih. ");
INSERT INTO nsu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Por yen tlaneltokalistli ika itoka in Jesús, nin tlakatl opajtik, iva imejvah inkimatih ke okatka vilantzi. In tlaneltokalistli tlen otechmakak Jesús okipajti nin tlakatl inmoixpa innochtin. ");
INSERT INTO nsu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Noknivah, nikmati ke ijkuak imejvah ivan inmotekivajkavah onkixpolojkeh in Jesús, amo onkimatkeh tlán onkichijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ijkó toYejwatzi Dios okichi tlen achto okitematilti por medio de nochtin tiotenejmachtijkeh, nik in Cristo otlajyoviskia. ");
INSERT INTO nsu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por eso, ximoyolkopakah iva ximokuapakah inavak toYejwatzi, para ma imechtlapojpolvi de inmotlajtlakol. Iva ijkó Ye imechvaltitlanilis tiempos de yolsevilistli, ");
INSERT INTO nsu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","iva imechvaltitlanilis oksemi in Cristo tlen Temakixti, yen Jesús tlen toYejwatzi okipejpenki desde achto para kivaltitlanis inmonavak. ");
INSERT INTO nsu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Maski axka in Jesús kipia de yetos ilvikak asta ma tlami ma kiyektlali in toYejwatzi nochi tlamantli. Yi wejkavitl ijkó okijto por medio de itiotenejmachtijkavah. ");
INSERT INTO nsu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés okinmilvi tlen yi wejkavitl tokojkolvah: “InmoTeko Dios kichivas ma kisa de imejvah se tiotenejmachti kemin ne. Xikneltokilikah yejón tiotenejmachti nochi tlen imechilvis, ");
INSERT INTO nsu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","porke tlen amo kineltokilis yejón tiotenejmachti, ayakmo povis invan tlen de Israel.” ");
INSERT INTO nsu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Iva nochtin tiotenejmachtijkeh, desde Samuel para nika, otlapojkeh noijki de tlen axka tlamochijtok itech ninmeh tonaltih. ");
INSERT INTO nsu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Imejvah onkiseliskeh kemi erensia tlen okijtojkeh in tiotenejmachtijkeh iva de neká moyekkavalistli tlen toYejwatzi okichi invan tokojkolvah. In toYejwatzi okilvi in Abraham: “Por medio de se de mowejkaixvivah nikintiochivas nochtin tlaltikpaktlakah.” ");
INSERT INTO nsu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ijkuak toYejwatzi okiyoliti itekipano, achto omechvaltitlanili imejvah tlen de Israel para ma imechtiochiva iva para kada se de imejvah ayakmo ma kichiva tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro ivan Juan ok okintlapovijtokah in gentejtih, iva ijkuakó oajsikoh in tiopixkeh iva saduceos, iva in tlayakanki de templojmayoltih. ");
INSERT INTO nsu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nochtin okualaniah porke Pedro ivan Juan okinmachtiayah in gentejtih, iva okinmilviayah nik in mikameh moyolitiskeh ijkó kemi Jesús omoyoliti. ");
INSERT INTO nsu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ijkuakó okinkitzkijkeh, pero komo yi tiotlaki, okintzakeh telpiloya iva ompa okinkajtejkeh asta ipan oksé tonali kualkampa. ");
INSERT INTO nsu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Miekeh tlen okikakkeh tlen okijtojkeh in Pedro ivan Juan de itlajtol in Dios, okineltokakeh. Iva san yejvah tlakah okinpojkeh okatkah kemi makuili mil tlen otlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Omostlatik omololojkeh ompa Jerusalén in tlanavatijkeh judiojtih, in tlayakankeh tetajmeh iva in tlamachtijkeh de itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ompa okatka in wei tiopixki Anás, iva noijki ompa okatka Caifás, Juan, Alejandro, iva nochtin infamiliajvah in wejwei tiopixkeh. ");
INSERT INTO nsu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro ivan Juan okinketzkeh tlatlajko iva okintlajtlanijkeh: —¿Akin omechanavati, o noso akin omechmakak velitilistli para xikpajtikah in vilantzi? ");
INSERT INTO nsu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro tentok de Tioijyotzintli okinnankili: —Imejvah tlen intlanavatijtokeh iva tlen intlayakankeh tetajmeh de Israel: ");
INSERT INTO nsu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","imejvah intechtlajtlaniah aserka de yen tlakatl tlen okatka vilantzi iva kenik axka yopajtik. ");
INSERT INTO nsu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pues axka, xikmatikah imejvah iva nochi gente de Israel, ke nin tlakatl tlen nika kajki inmoyakapa, opajtik ika itoka in Jesucristo de Nazaret, tlen imejvah onkimiktijkeh itech se krus, pero toYejwatzi okiyoliti. ");
INSERT INTO nsu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nin Jesús, yen “tetl tlen imejvah tlen inkalchijkeh amo onkinekeh, pero omokopki yen tetl tlen okachi kichikajtok in kali.” ");
INSERT INTO nsu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Amo onka oksé tlen velis techmakixtis, porke toYejwatzi amo okitlali íkka oksé itech nin tlaltikpaktli tlen ma veli ma techmakixti. ");
INSERT INTO nsu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","In tekivajkameh omotetzavijkeh ijkuak okinkakkeh tlen okijtovayah in Pedro ivan Juan iva nik amo omomavtiayah, maski okatkah amo ipanitalistih iva amo ixtlamatkeh. Iva okimomakakeh kuenta ke yejvah onemiah ivan Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Iva amo ovelia ok itla okinmilviayah en kontra, porke ompa invah omoketoka in tlakatl tlen opajtik. ");
INSERT INTO nsu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Iva otlanavatijkeh ma koninkixtikah se tzikitzi de kan junta, iva in tekivajkameh sa yejvah ope motlapoviah. ");
INSERT INTO nsu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Okijtojkeh: —¿Tlán tikchivaskeh ivan ninmeh tlakah? Nochtin tlen chantih Jerusalén kimatih nik okichijkeh se wei tetzavkaneskayotl, iva amo velis tikijtoskeh ke amo neli. ");
INSERT INTO nsu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero para amo okachi ma xitini nin tlajtoli, ma tikinmajmavtikah, para ke de nika para tlayakapa ayakmika ma kitlapovikah de Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ijkuakó oksemi okinnotzkeh ma kalakikah in Pedro ivan Juan iva okinnavatijkeh ayakmo ma tetlapovikah iva ayakmo ma tlamachtikah de itoka in Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro ivan Juan otlanankilijkeh: —Kuali xikyejyekokah imejvah, kox kuali ixpan toYejwatzi yej imejvah ma timechvelkakikah iva amo yen toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tejvah mach velis tikavaskeh de tikijtoskeh tlen yotikittakeh iva tlen yotikakkeh. ");
INSERT INTO nsu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","In tekivajkameh oksemi okinmajmavtijkeh in Pedro ivan Juan iva okinkajkajkeh ma viah. Amo okajsikeh kenik kintlajyoviltiskeh, porke nochtin gentejtih okiweijkachivayah in Dios por tlen opanolok. ");
INSERT INTO nsu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","In tlakatl tlen opajtik de yejón tetzavitl okipiaya okachi de ompoali xivitl. ");
INSERT INTO nsu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro ivan Juan, ijkuak okinkajkajkeh, oyajkeh kan okatkah tlen oksekimeh inkompañerojvah, iva okinmakakeh kuenta de nochi tlen okinmilvijkeh in tlayakankeh tiopixkeh iva in tlayakankeh tetajmeh. ");
INSERT INTO nsu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ijkuak ijkó okikakkeh tlen yejvah okijtojkeh, nochtin omodiostzajtzilijkeh okijtojkeh: —Towei tlanavati Dios, tejwatzi otikchi in ilvikak, in tlaltikpaktli, in atl iva nochi tlen intech onka. ");
INSERT INTO nsu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tejwatzi otikijto por medio de motekipano tlen yi wejkavitl tokojkol David: ¿Tleka sa tlawel kuejsivih in gentejtih de oksekimeh países? ¿Tleka kiyejyekovah kichivaskeh tlen amitla ipati? ");
INSERT INTO nsu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","In wejwei tlanavatijkeh de nochi in tlaltikpaktli motlayektlaliliah para temagaskeh, iva in tekivajkeh mololovah para yaskeh en kontra de toTeko Dios iva de iCristo. ");
INSERT INTO nsu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tikmatih nik yi neli nika Jerusalén omololojkeh in Herodes, in Poncio Pilato, in judiojtih ivan tlen amo judiojtih para yaskeh en kontra de mochipavka tekipano Jesús, tlen tejwatzi otikpejpenki para ma yeto yen toTemakixti. ");
INSERT INTO nsu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yejvah okichijkeh nochi tlen desde achto tejwatzi otikmonekilti ijkó ma mochiva. ");
INSERT INTO nsu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Axka toTeko, xikitta kinekih techmajmavtiskeh. Techyolchikava tejvah tlen timotlakevalvah para amo ma timomavtikah de titetlapoviskeh de motlajtoltzi. ");
INSERT INTO nsu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iva ika movelitilis ma pajtikah in kokoxkeh iva ma mochivakah neskayomeh iva nexkuitiltih ika itoka in mochipavka tekipano Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ijkuak otlanki omodiostzajtzilijkeh, kan oololitokah otlalolinki, iva nochtin otenkeh de Tioijyotzintli, iva ayakmo omaviah de otetlapoviayah de itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nochtin tlaneltokakeh okipiayah san se inyolo iva san se intlayejyekol. Amika okiyejyekovaya ke tlen kipixtok san para ye, sino para nochtin. ");
INSERT INTO nsu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","In tiotlatitlaniltih ika miek velitilistli otetlapoviayah kenik omoyoliti in toTeko Jesús, iva Dios sa tlawel okintiochivaya nochtin. ");
INSERT INTO nsu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nion se de yejvah amitla okipolovaya, porke tlen okinpiayah tlalmeh o noso kalmeh, okinnemakayah ivan tomi nochi okitemakayah. ");
INSERT INTO nsu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","In tomi okinmaktiliayah in tiotlatitlaniltih, para ma kinxejxelilikah in tlaneltokakeh tlen okinpolovaya. ");
INSERT INTO nsu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ijkó okichi se tlakatl itoka José, tlen valajtok familia de Leví iva tlen oneski kan tlali de Chipre tlen yavalitok de atl tlen wei, tlen tiotlatitlaniltih okitokayotijkeh Bernabé, kijtosneki tlen teyolchika. ");
INSERT INTO nsu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yejón tlakatl okinemakak itlal ivan tomi okinmaktili in tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Okatka se tlakatl itoka Ananías, ye ivan itonana Safira omotlalnemakakeh. ");
INSERT INTO nsu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yejón tlakatl omotlatlalvi ivan itonana para kimokaviskeh seki intlaltomi iva okseki okinmakak in tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro okilvi: —Ananías, ¿tleka otikavili ma kalaki itech moyolo in Amo Kuali Tlakatl, iva omitztokti xikajkayava in Tioijyotzintli, para xikmokavi seki tomi de tlen omitztlaxtlavilijkeh in motlal? ");
INSERT INTO nsu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Amo okatka moaxka in tlali? Iva satepa de otiknemakak, ¿amo okatka moaxka in tomi? Tonses, ¿tleka ijkó otikchi? Mach otitlakajkaya innavak in tlakah, sino inavak toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ijkuak ijkó okikakki, Ananías ovetzito ipan tlali iva oixpolivik. Iva nochtin tlen okimatkeh sa tlawel omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ijkuakó omoketzkeh sekimeh telpokameh, okikemilojkeh ikuerpo iva oyajkeh okitookatoh. ");
INSERT INTO nsu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kemi eyi ora satepa oajsiko itonana in Ananías, iva amo okimatia tlan opanolok. ");
INSERT INTO nsu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro okitlajtlani: —Techilvi, ¿yi neli onkinemakakeh in tlali ika yejón ipati kemi imejvah inkijtovah? Iva ye otlanankili: —Yi neli, ika yejón ipati. ");
INSERT INTO nsu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro okilvi: —¿Tleka onmotlatlalvijkeh para inkiyejyekoskeh iTioijyotzi in toTeko? Nika vitzeh tlen okitookatoh mototata, iva axka te noijki mitzvikaskeh mitztookativih. ");
INSERT INTO nsu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","San nima ijkuakó Safira ovetzito ikxitlan Pedro iva oixpolivik. Ijkuak omokuapatoh in telpokameh, okajsikoh yoixpolivik. Okikixtijkeh iva okitookatoh inakastla itotata. ");
INSERT INTO nsu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nochtin tlaneltokakeh iva nochtin tlen okimatkeh tlen opanolok, sa tlawel omomavtijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","In tiotlatitlaniltih okinchivayah miekeh neskayomeh iva nexkuitiltih innavak in gentejtih. Iva nochtin tlaneltokakeh omololovayah kan kitokayotiah Korredor de Salomón. ");
INSERT INTO nsu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tlen oksekimeh gentejtih amo omixeviayah mosetiliskeh invah, pero nochtin okintlakitayah iva kuali otlapovayah de yejvah. ");
INSERT INTO nsu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tlen okineltokayah toTeko okachi omomiekiliayah, tlakah ivan sivameh. ");
INSERT INTO nsu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Por eso, asta okinkixtiayah in kokoxkeh ipan ojtli, okintlaliayah ipan kuavtlapechtli iva ipan petlatl para ijkuak panos in Pedro, sikiera iekavilo ma kinmajsi para ma pajtikah. ");
INSERT INTO nsu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Noijki miekeh gentejtih de oksekimeh altepemeh de ik ompa serka, ovalayah para Jerusalén okinvalikayah kokoxkeh iva tlen okipiayah amo kuali ejekameh, iva nochtin opajtiah. ");
INSERT INTO nsu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","In wei tiopixki iva nochtin iyoliknivah, tlen opoviah invan saduceos, sa tlawel omoxikovayah. ");
INSERT INTO nsu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Okinkitzkijkeh in tiotlatitlaniltih iva okintzakeh telpiloya. ");
INSERT INTO nsu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero yejón yovak, se iilvikaktlatitlanil in toTeko okitlapo in puerta de telpiloya iva okinkixti. Okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Xiviah. Xikalakikah kan templo iva xikinmatiltikah in gentejtih de nochi nin yankuik nemilistli. ");
INSERT INTO nsu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ijkuak otlaneski, in tiotlatitlaniltih okalakeh kan templo ijkó kemi okinmilvi in ilvikaktlatitlanili, iva ope tlamachtiah. Mientras in wei tiopixki iva tlen iva okatkah, okinnotzkeh nochtin tlen povih itech injunta in judiojtih iva okinnotzkeh in tlayakankeh tetajmeh de Israel para ma mololokah. Iva otlanavatijkeh ma kinkixtitih in tiotlatitlaniltih de kan telpiloya iva ma kinvalikakah. ");
INSERT INTO nsu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero ijkuak in templojmayoltih oajsitoh telpiloya, mach ok okinmajsitoh in tiotlatitlaniltih. Tonses omokuapkeh okitematiltitoh, ");
INSERT INTO nsu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","okijtojkeh: —Otikajsitoh in puerta kuali tzaktok, iva in soldadojtih okatkah kan puerta otlakuidarojtokah. Pero ijkuak otiktlapojkeh in puerta, mach ok íkka otikajsikeh tlatlaijtik. ");
INSERT INTO nsu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ijkuak in wei tiopixki iva in tlayakanki de templojmayoltih ivan tlen oksekimeh tlayakankeh tiopixkeh ijkuak ijkó okikakkeh, sa otlatlachixkeh iva omotlajtlaniayah kenomi nik tlamiti nin tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ijkuakó ovala se tlakatl, iva okinmilvi: —Tlen imejvah onkintzakeh telpiloya, kateh kan templo kinmachtijtokeh in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","In tlayakanki de templojmayoltih ivan sekimeh mayoltih, oyajkeh okinkitzkitoh, pero amitla okintoktijkeh, porke okinmiimakasiah in gentejtih de kinmagaskeh ika tetl. ");
INSERT INTO nsu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ijkuak okinvalikakeh in tiotlatitlaniltih kan injunta, in wei tiopixki okintlatzintoki okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Tejvah kuali otimechnavatijkeh ayakmo xitlamachtikah de yejón tlakatl Jesús. Iva xikittakah tlan yonkichijkeh, yonkixitinijkeh inmotlamachtilis itech nochi in siudad de Jerusalén, iva asta intechtlajtlakoltiah nik tejvah otikmiktijkeh yejón tlakatl. ");
INSERT INTO nsu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro ivan oksekimeh tiotlatitlaniltih otlanankilijkeh: —Achto moneki tikvelkakiskeh in toYejwatzi, iva satepa in tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","In toYejwatzi de tlen yi wejkavitl tokojkolvah Ye okiyoliti in Jesús tlen imejvah onkixpolojkeh itech se krus. ");
INSERT INTO nsu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","In toYejwatzi okiweijkatlali in Jesús kan iyekmapa iva okimonekilti yen Jesús ma yeto toTlayakanki iva toTemakixti, para ijkó in gente de Israel ma moyolkuapakah iva ijkó toYejwatzi kintlapojpolvis de intlajtlakol. ");
INSERT INTO nsu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tejvah tikateh kemi titestigojtih de nochi nin tlamantli, iva noijki in Tioijyotzintli. Porke toYejwatzi kinmaka iTioijyotzi nochtin tlen kivelkakih. ");
INSERT INTO nsu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tlen ompa okatkah itech junta, ijkuak okikakkeh yejón tlajtoli, sa tlawel okualankeh iva okinekiah kinmiktiskeh in tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ompa itech injunta okatka se tlakatl fariseo itoka Gamaliel, tlen okatka wei tlamachti itech itlanavatil Moisés, tlen nochtin gentejtih okitlakitayah. Gamaliel omoketzki iva otlanavati ma kinkixtikah se tzikitzi in tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Iva okinmilvi tlen oksekimeh ikompañerojvah: —Tatanmeh de Israel, xikpiakah kuidado de tlen inkinekih inkintoktiskeh ninmeh tlakah. ");
INSERT INTO nsu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xikilnamikikah imejvah, yi wejkavitl omonexti se tlakatl itoka Teudas, tlen omomachiliaya weititok, iva okinyakanaya kemi navi siento tlakah. Pero Teudas okimiktijkeh, iva tlen okitokayah oxixinkeh iva nochi ompa otlanki. ");
INSERT INTO nsu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Satepa de Teudas omonexti Judas tlen de Galilea, mero ijkuak omochi censo, iva noijki okinyakanki miekeh, pero noijki okimiktijkeh, iva nochtin tlen okitokayah oxixinkeh. ");
INSERT INTO nsu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Por eso nimechilvia: xikinkavakah ninmeh tlakah, amo invah ximokalakikah. Porke tla nin tlamachtili san de yejvah intech kisa iva amo vitz de Dios, amo wejkavas iva niman popolivis. ");
INSERT INTO nsu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero tla vitz de Dios, mach velis inkitzakuiliskeh. Xikpiakah kuidado, amo san kichiva yej inkinekih inmokitzkiskeh ivan Dios. ");
INSERT INTO nsu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yejvah okijtojkeh kuali kajki tlen okinmilvi in Gamaliel. Okinnotzkeh in tiotlatitlaniltih, okinwitekeh iva okinmilvijkeh ayakmo ma tetlapovikah de itoka in Jesús, iva okinkajkajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","In tiotlatitlaniltih okiskeh de kan junta ika pakilistli, opakeh porke Dios okinkavili ma tlajyovikah por okineltokayah itoka in Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Momostlatika oyayah kan templo iva kalpa, amo okavayah de otlamachtiayah iva de otetlapoviayah de Jesucristo. ");
INSERT INTO nsu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Itech nekateh tonaltih, komo okachi omomiekiliayah in tlaneltokakeh, noijki ope mokualaniah in tlaneltokakeh tlen otlapovayah griego iva tlen otlapovayah hebreo. Tlen otlapovayah griego okijtovayah ke kada tonali ijkuak okinxejxeliliayah tlen kikuaskeh, in iknosivameh tlen otlapovayah griego amo okinmakayah parejo kemi tlen otlapovayah hebreo. ");
INSERT INTO nsu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ijkuakó in majtlaktli ivan ome tiotlatitlaniltih okinmololojkeh nochtin tlaneltokakeh iva okinmilvijkeh: —Tejvah moneki titetlapoviskeh de itlajtol in toYejwatzi. Amo kuali kajki tla tejvah ok tikinxejxelilijtoskeh nochipa tlen kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Okachi kuali, xikinpejpenakah chikome toknivah tlen kuali kintlakitah, tlen kipiah kuali intlayejyekolis iva ma tentokah de Tioijyotzintli, para yejvah ma kichivakah yejón tekitl. ");
INSERT INTO nsu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tejvah timotemaktiskeh itech diostzajtzilistli iva itech tlamachtilistli de itlajtol in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nochtin okijtojkeh kuali kajki tlen okijtojkeh in tiotlatitlaniltih, iva okipejpenkeh in Esteban, tentok de tlaneltokalistli iva de Tioijyotzintli, noijki okipejpenkeh in Felipe, Prócoro, Nicanor, Timón, Pármenas ivan Nicolás tlen de Antioquía, tlen achto okiselijka in tlaneltokalistli judío. ");
INSERT INTO nsu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Satepa nochtin chikome okinvalikakeh innavak in tiotlatitlaniltih, iva yejvah omodiostzajtzilijkeh iva inpa okintlalijkeh inmavah. ");
INSERT INTO nsu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Itlajtol in Dios ope xitini okachi, iva ompa Jerusalén okachi omomiekiliayah in tlaneltokakeh. Noijki miekeh tiopixkeh judiojtih otlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban otentokah de iknomachilistli iva de velitilistli tlen Dios okimakak, iva okinchivaya nexkuitiltih iva neskayomeh innavak in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero ope ivan motlatlajtolnamikih sekimeh tlakah tlen povih kan tiotlamachtijkali tlen kitokayotiah Tlakah Tlen Ayakmo Ok Kateh Kemi Tlakovaltih, iva sekimeh tlakah de Cirene, de Alejandría, de Cilicia iva de Asia. ");
INSERT INTO nsu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero amo ovelikeh okitlanilijkeh, porke ye otlapovaya ika tlamatilistli tlen okimakaya in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ijkuakó ichtaka okintlaxtlavijkeh sekimeh tlakah para ma kijtokah ke okikakkeh in Esteban otlapovaya fiero de Moisés iva de Dios. ");
INSERT INTO nsu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ijkuakó sa tlawel omokuejsojkeh in gentejtih, in tlayakankeh tetajmeh ivan tlamachtijkeh de itlanavatil Moisés. Okitzkijkeh in Esteban iva okivikakeh itech injunta in judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Okintemojkeh sekimeh testigojtih tekajkayajkeh, tlen okijtojkeh: —Nin tlakatl tlapojtinemi fiero de nin templo tlatiochivali iva tlapova fiero de itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Otikakkeh okijto ke Jesús de Nazaret, kixixinis in templo iva kinpatlas in kostumbres tlen Moisés otechinkajtevili. ");
INSERT INTO nsu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ijkuakó nochtin tlen ompa oyetokah kan junta, ijkuak okittakeh in Esteban, okittakeh ixko kemi oyeskia ixko se ilvikaktlatitlanili. ");
INSERT INTO nsu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","In wei tiopixki okitlajtlani in Esteban: —¿Kox yi neli tlen kijtovah de te? ");
INSERT INTO nsu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ye otlanankili: —Noknivah iva tetajmeh de Israel, techkakikah: Tomavistijkatzi Dios okimonextili in tokojkol Abraham ijkuak okatka itech tlali de Mesopotamia, antes de ochantiskia kan altepetl de Harán, ");
INSERT INTO nsu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","iva okilvi: “Xikajteva motlal iva xikinkajteva tlen itla tikinmita, iva xivia itech oksé tlali tlen Ne nimitzititis.” ");
INSERT INTO nsu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ijkuakó Abraham okiski itech tlali de Caldea iva oyá ochantito itech altepetl de Harán. Satepa de oixpolivik ipapa, in toYejwatzi okivalikak in Abraham itech ninmeh tlalmeh kan imejvah axka inchantih. ");
INSERT INTO nsu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero amitla erensia okimakak itech nin tlali, nion por kan kitlalis se ikxi. Pero toYejwatzi okilvi nik kitlaltis, iva satepa de ijkuak ye mikis in tlali mokavas para ipilvah, maski ijkuakó Abraham ayamo okipiaya nion se ikone. ");
INSERT INTO nsu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","In toYejwatzi noijki okilvi ke iwejkaixvivah chantiskeh itech oksé país iva yeskeh amo de ompa, iva yeskeh kemi tlakovaltih iva kintlajyoviltiskeh sa tlawel kemi navi siento xivitl. ");
INSERT INTO nsu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero toYejwatzi noijki okilvi: “Ne nikintlajyoviltis in gentejtih de yejón país tlen kintekipanoltiskeh mopilvah kemi tlakovaltih. Satepa kisaskeh de ompa iva nechmavistiliskeh itech nin tlali.” ");
INSERT INTO nsu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","In toYejwatzi okichi se moyekkavalistli ivan Abraham iva okinavati ma kichiva in sirkunsisión. Ijkuak ochikueyitik de oneski Isaac, Abraham okisirkunsidaro. Noijki ijkó okichi in Isaac ivan ikone Jacob, iva Jacob noijki ijkó okichi ivan ipilvah tlen oyajkeh tetajmeh de tlen majtlaktli ivan ome familias de Israel. ");
INSERT INTO nsu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Yejonmeh ipilvah in Jacob yejvah tlen yi wejkavitl tokojkolvah, yejvah omoxikojkeh miek de inmikni José iva okinemakakeh para ma kivikakah itech país de Egipto. Pero toYejwatzi okatka ivan José, ");
INSERT INTO nsu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","iva okipalevi itech nochi itlajyovilis. In Faraón, tlen wei tlanavati de Egipto, okipakti tlen José okichivaya porke toYejwatzi okimakak miek tlamatilistli. Por eso in Faraón okitlali in José ma yeto kobernador de Egipto iva ma kitta nochi tlen iaxka in wei tlanavati. ");
INSERT INTO nsu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Satepa ovala miek apistli iva miek tlajyovilistli itech nochi in tlali de Egipto iva itech tlali de Canaán, iva tlen yi wejkavitl tokojkolvah amo okipiayah tlán kikuaskeh. ");
INSERT INTO nsu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero ijkuak Jacob okimatki onka trigo itech país de Egipto, okintitlanki ompa tlen yi wejkavitl tokojkolvah. Ijkuakó yikin se welta oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ijkuak oyajkeh ipan ome welta, José okinmoixmatilti in iknivah, iva ijkó in Faraón okinmixmatki ifamiliajvah in José. ");
INSERT INTO nsu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Satepa, José otlanavati ma kinvalikakah para Egipto ipapa ivan ifamilia. Por nochtin okatkah kemi expoali ivan kaxtoli. ");
INSERT INTO nsu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ijkó, Jacob oyá omochantito Egipto, ompa oixpolivik iva ompa oixpolikeh noijki ipilvah, yejvah tlen yi wejkavitl tokojkolvah. ");
INSERT INTO nsu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","In kuerpojtih okinvikakeh asta Siquem iva okintookakeh kan Abraham okiko se lugar tlen okinemakiltijkeh ipilvah in Hamor ompa Siquem. ");
INSERT INTO nsu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ijkuak yoajsitivalaya in tonali para mochivas tlen toYejwatzi okilvi in Abraham, in gentejtih de Israel sa tlawel omomiekilijkeh ompa Egipto. ");
INSERT INTO nsu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pero itech yejonmeh tonaltih ompa Egipto ope tlanavatia oksé wei tlanavati tlen amitla okimatia de José. ");
INSERT INTO nsu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yejón wei tlanavati okinmonexikitili in toknivah iva okintlajyovilti tlen yi wejkavitl tokojkolvah, okinnavati ma kinkavakah inselikkonevah ik sekka para ma mikikah. ");
INSERT INTO nsu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Itech yejonmeh tonaltih oneski Moisés iva toYejwatzi okittak ika pakilistli yejón konetl. In tetajmeh okiskaltijkeh inkalijtik san eyi metztli. ");
INSERT INTO nsu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Iva ijkuak in tetajmeh okavatoh in konetl se lado para ma miki, ichpoch in Faraón okajsik iva okiskalti kemi oyeskia ikone. ");
INSERT INTO nsu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Iva ijkó Moisés okixtlamachtijkeh ika nochi tlamatilistli tlen okimatiah in egipcios, iva omochi se tlakatl sa tlawel weititok por tlen okijtovaya iva por tlen okichivaya. ");
INSERT INTO nsu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ijkuak Moisés okipixki ompoali xivitl, okimachili itech iyolo yaski kintlajpaloti in gentejtih de Israel tlen ipaisanojvah. ");
INSERT INTO nsu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pero ijkuak okittak se tlakatl egipcio okivitekia se tlakatl israelita, Moisés okipalevi in israelita iva okimikti in egipcio. ");
INSERT INTO nsu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés okijto ke ipaisanojvah kimomakaskeh kuenta nik yen toYejwatzi okititlanki in Moisés para ma kinmakixti, pero yejvah amo okimomakakeh kuenta. ");
INSERT INTO nsu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Omostlatik, Moisés okinmitak ome tlakah de Israel okimomagayah ika maitl, iva ye okinekia kinpalevis iva okinmilvi: “Imejvah inmiknimeh, ¿tleka inkimomagah?” ");
INSERT INTO nsu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ijkuakó tlen otemagaya okitope in Moisés, iva okilvi: “¿Akin omitztlali kemi titlayakanki o noso kemi tijues para ximokalaki tovah? ");
INSERT INTO nsu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Noijki tikneki techmiktis kemi yala otikmikti in egipcio?” ");
INSERT INTO nsu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ijkuak ijkó okikakki, Moisés ocholo iva oyá kan tlali de Madián. Ompa ochantik tealtepe iva ompa okinpixki ome ipilvah. ");
INSERT INTO nsu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ompoali xivitl satepa, Moisés okatka kan tlavaki serka kan tepetl Sinaí, ompa okimonextili se ilvikaktlatitlanili ijtik tlitl kan otlatlaya se kovatlanvitztli. ");
INSERT INTO nsu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés sa otlatlachixki por tlen okittak, iva ijkuak omotoki para kiyekittas okachi, ijkuakó okikakki itlajtol in toTeko: ");
INSERT INTO nsu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ne niDios de tlen yi wejkavitl mokojkolvah. Ne niDios de Abraham, de Isaac iva de Jacob.” Moisés omomavti asta oviviokak iva mach ok omixeviaya ok konittas. ");
INSERT INTO nsu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ijkuakó in toTeko okilvi: “Xikinkixti mokakvah porke kan timoketok in tlali tlatiochivali. ");
INSERT INTO nsu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yonikittak kenik tlajyoviah nopilvah tlen kateh Egipto. Yonikinkakki chokah moyolkokova iva onivaltemok para nikinmakixtis. Axka pues, xiviki, nimitztitlanis para Egipto.” ");
INSERT INTO nsu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Yejvah amo okinekeh in Moisés iva okilvijkeh: “¿Akin omitztlali kemi titlayakanki o noso kemi tijues para ximokalaki tovah?” In toYejwatzi okititlanki in Moisés kemi tlayakanki iva kemi temakixti por medio de yen ilvikaktlatitlanili tlen okimonextili kan kovatlanvitztli tlen otlatlaya. ");
INSERT INTO nsu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yen Moisés okinkixti de Egipto tlen yi wejkavitl tokojkolvah, iva okinchi nexkuitiltih iva neskayomeh kemi ompoali xivitl itech tlali de Egipto, kan Mar Chichiltik iva kan tlavaki. ");
INSERT INTO nsu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yen Moisés tlen achto okinmilvi in gentejtih de Israel: “ToYejwatzi imechvaltitlanilis se tiotenejmachti kemin ne, iva kisas de entre imejvah. Xikchivakah tlen Ye imechilvis.” ");
INSERT INTO nsu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yen nin Moisés tlen okatka invan tlen yi wejkavitl tokojkolvah kan ololitokah kan tlavaki. Ye noijki okatka ivan ilvikaktlatitlanili tlen okitlapovi kan tepetl Sinaí. Moisés okiseli in tlajtoli tlen kitemaka nemilistli iva satepa tejvah otechmakak. ");
INSERT INTO nsu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero tlen yi wejkavitl tokojkolvah amo okivelkakeh in Moisés, amo okinekeh okikakkeh tlen okinmilvi iva okinekiah mokuapaskeh para Egipto. ");
INSERT INTO nsu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Okilvijkeh in Aarón: “Techinchivili sekimeh diosmeh tlen ma techyakanakah, porke amo tikmatih tlán okipanok neká Moisés tlen otechkixti de Egipto.” ");
INSERT INTO nsu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ijkuakó okichijkeh se dios kemi se torojkonetl, okitlamiktilijkeh ika yolkameh yejón dios. Iva omopaktijkeh por tlen yejvah okichijkeh ika inmavah. ");
INSERT INTO nsu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Por eso toYejwatzi okinka, iva okinkavili ma kinmavistilikah in sitlalimeh de ilvikak. Ijkó kemi kajki ijkuilitok itech inlibro in tiotenejmachtijkeh: Gente de Israel, itech yejonmeh ompoali xivitl kan tlavaki, ¿kema onnechtlamiktilijkeh ika yolkameh iva kema onechmakakeh itla tlamanali? ");
INSERT INTO nsu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amo, yej onkimamayah imantajkaltiopa in dios Moloc ivan sitlali de dios Renfán. Yejonmeh diosmeh imejvah onkinchijkeh iva onkinmavistilijkeh. Por eso, Ne nimechtitlanis wejka asta okachi ik nepa de Babilonia. ");
INSERT INTO nsu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Tlen yi wejkavitl tokojkolvah okivikatinemiah kan tlavaki in mantajkaltiopa tlen ijtik okatkah in tlanavatiltih. Moisés okichi in mantajkaltiopa ijkó kemi toYejwatzi okititi kenomi nik kichivas. ");
INSERT INTO nsu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yejón mantajkaltiopa tlen okichi Moisés opanok inmak tlen yi wejkavitl tokojkolvah, iva okivalikakeh nika ijkuak Josué okatka tlayakanki, ijkuak okinmoaxkatijkeh in tlalmeh de oksekimeh gentejtih tlen amo de Israel tlen toYejwatzi okinkixtili. Tokojkolvah okipixtokah in mantajkaltiopa asta ijkuak ok okatka in David. ");
INSERT INTO nsu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David okipakti in toYejwatzi, iva okitlatlavti ma kikavili ma kichivili se templo kan chantis in Dios de Jacob. ");
INSERT INTO nsu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero yen Salomón okichi in templo. ");
INSERT INTO nsu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Maski in toYejwatzi tlen Weijkatlalitok amo chanti itech templojtih tlen kinchivah in tlaltikpaktlakah. Kemi okijto in tiotenejmachti: ");
INSERT INTO nsu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kijtova in toTeko, in ilvikak yen kan Ne niyetok nitlanavatijtok, iva in tlaltikpaktli yen kan tlaksatokeh nokxivah. ¿Tlán kali inkinekih innechchiviliskeh imejvah? ¿Kan velis nimosevis? ");
INSERT INTO nsu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Amo Ne onikchi in ilvikak ivan tlaltikpaktli? ");
INSERT INTO nsu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban okinmilvi: —Pero imejvah sa tlawel inyoltlakuavakeh. Amo inkateh insirkunsidadojtih itech inmoyolo nion itech inmotlakakilis. Nochipa inkateh en kontra de in Tioijyotzintli, ijkó kemi okichivayah tlen yi wejkavitl inmokojkolvah imejvah noijki ijkó inkichivah. ");
INSERT INTO nsu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yejvah okintlajyoviltijkeh nochtin tiotenejmachtijkeh, iva okinmiktijkeh tlen okijtovayah nik se tonali vitz se tlen tlakamela, iva axka yejón tlakamela yovitza, iva imejvah onkitemaktijkeh iva onkixpolojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imejvah onkiselijkeh itlanavatil in toYejwatzi tlen omechmakakeh in ilvikaktlatitlaniltih, pero amo inkivelkakih. ");
INSERT INTO nsu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ijkuak okikakkeh tlen okijto in Esteban, sa tlawel okualankeh asta omotlantekiah. ");
INSERT INTO nsu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Esteban otentoka de Tioijyotzintli, oajkotlachixki para ilvikak iva okittak imavissotlanex in Dios. Okittak in Jesús moketok ik iyekmapa in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iva okijto: —Xikittakah, nikitta in ilvikak tlapotok, iva iKone in Tlakatl moketok ik iyekmapa in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ijkuakó yejvah omonakaspachojkeh iva otzajtzikeh chikavak, iva nochtin ipan oyajkeh in Esteban. ");
INSERT INTO nsu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Okixtijkeh de kan siudad iva okimagakeh ika tetl. Iva tlen otemagakeh ika tetl okinkajtejkeh intlakenvah ma kintlato se telpochtli itoka Saulo. ");
INSERT INTO nsu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ijkuak okimagatokah ika tetl, Esteban omodiostzajtzili, okijto: —NoTeko Jesús, xikseli notonal. ");
INSERT INTO nsu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Satepa omotlankuaketzki iva okijto chikavak: —NoTeko, amo xikinchivili kuenta nin tlajtlakoli tlen kichivah. Ijkuak otlanki ijkó okijto, oixpolivik. ");
INSERT INTO nsu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo okatka de akuerdo ijkuak okimiktijkeh in Esteban. Itech neká tonali ope kinchochololtiah in tlaneltokakeh tlen okatkah Jerusalén. Nochtin ochocholojkeh ik región de Judea iva de Samaria. Sa yejvan tiotlatitlaniltih omokajkeh Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sekimeh tlen motemaktiah inavak Dios okitookatoh in Esteban iva sa tlawel okichokilijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero Saulo ope kinchochololtia in tlaneltokakeh. Okalakia inkajkalijtik iva okinkixtiaya tlakah ivan sivameh iva okintzakuaya telpiloya. ");
INSERT INTO nsu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iva tlen ochocholojkeh de Jerusalén, sentetl otetlapovijtiayah de tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Se de yejvah itoka Felipe, oyá itech se siudad tlen kajki itech tlali de Samaria iva ompa ope tetlapovia de Cristo. ");
INSERT INTO nsu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Miekeh gentejtih omololovayah iva okiyekkakiah tlen okinmilviaya in Felipe. Iva okittayah okinchivaya tetzavkaneskayomeh. ");
INSERT INTO nsu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Miekeh tlen okipiayah amo kuali ejekameh opajtikeh, iva in ejekameh asta otzajtziah ijkuak okisayah. Noijki opajtikeh miekeh koxomeh ivan vilantzitzintih. ");
INSERT INTO nsu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Iva por eso, okatka miek pakilistli itech yejón siudad. ");
INSERT INTO nsu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ompa itech yejón siudad okatka se tlakatl itoka Simón tlen tetlajchivi. Ye okinkajkayavaya in gentejtih de Samaria ika itetlajchivil. Iva omomachiliaya weititok. ");
INSERT INTO nsu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nochtin kuali okikakiliayah in Simón, desde tlen tzitzintih iva asta tlen wejweih, iva okijtovayah: —Itech nin tlakatl tikittah tlen tiknotzah wei ivelitilis in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yowejka kinkajkayajtivitz in gentejtih ika itetlajchivil, iva nochtin okikakiliayah. ");
INSERT INTO nsu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero ijkuak okikakkeh in yankuik kuali tlajtoli tlen Felipe okintlapovi, yejvah okineltokakeh. Felipe okinmilvi kenik in Dios tlanavatia iva okintlapovi de Jesucristo. Miekeh tlakah iva sivameh omobautisarojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón tlen tetlajchivi noijki okineltokak iva omobautisaro, iva ope kivikatinemi in Felipe. Okinmitaya in neskayomeh iva wejwei tetzavimeh, iva sa otlatlachiaya. ");
INSERT INTO nsu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","In tiotlatitlaniltih tlen okatkah Jerusalén okimatkeh ke in gentejtih de Samaria okineltokakeh itlajtol in Dios. Ijkuakó ompa okintitlankeh in Pedro ivan Juan. ");
INSERT INTO nsu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ijkuak ompa oajsitoh, omodiostzajtzilijkeh por tlen yankuikeh tlaneltokakeh de Samaria, para ma kiselikah noijki in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porke ayamo okiseliayah in Tioijyotzintli, porke san ok omobautisarojkeh ika itoka in toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ijkuakó Pedro ivan Juan okintlalijkeh inmavah inpan yejonmeh toknivah, iva ijkuakó okiselijkeh in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón tlen tetlajchivi okinmitak in tiotlatitlaniltih okintlaliayah inmavah inpan tlaneltokakeh iva okiseliayah in Tioijyotzintli. Iva ijkuakó ye okinmijtolti tomi in tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Okinmilvi: —Techmakakah ne noijki yejón velitilistli, para ijkuak ne nikintlalis nomavah íkka ipa, ma kiseli noijki in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro okinankili: —¡Xiviah miktla te ivan motomi! Te tikyejyekova ke tlen toYejwatzi techmaka veli mokova ika tomi. ");
INSERT INTO nsu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Te amo motech povi iva nion amo tikpia tlen tikittas itech nin tlamantli, porke moyolo amo chipavak inavak toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ximoyolkuapa por yen tlajtlakoli tlen tikchijtok, iva ximodiostzajtzili, mixevia toYejwatzi mitztlapojpolvis de tlen tikyejyekova itech moyolo. ");
INSERT INTO nsu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porke nikitta sa tlawel yotiyolchichiyak, iva motlajtlakol seppa mitzilpijtok. ");
INSERT INTO nsu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ijkuakó in Simón okinmilvi: —Ximodiostzajtzilikah por ne, para amitla ma nimochiva de tlen imejvah yonnechilvijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro ivan Juan okitematiltijkeh tlen okimatiah de Jesucristo iva noijki otetlapovijkeh de itlajtol in Dios. Satepa omokuapkeh para Jerusalén. Iva itech miekeh altepemeh de Samaria kanik opanotiayah, ik ompa otetlapovijtiajkeh de tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Satepa se iilvikaktlatitlanil in toTeko okilvi in Felipe: —Ximoketza iva xivia ik tlatzintla. Xivia itech ojtli tlen yavi de Jerusalén para Gaza, in ojtli tlen panotok kan tlavaki. ");
INSERT INTO nsu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe omoketzki iva oyá. Iva itech ojtli okajsito se tlakatl de país de Etiopía. Yejón tlakatl okatka kappo iva okatka wei tekiva tesorero de yen reina de Etiopía. Yejón tlakatl ovia Jerusalén okimavistilito in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Iva yoyaya para ipaís yetiv ipan ikarreta, iva okilerojtiaya itlajkuilol in tiotenejmachti Isaías. ");
INSERT INTO nsu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","In Tioijyotzintli okilvi in Felipe: —Xivia xikajsiti neká karreta. ");
INSERT INTO nsu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe okajsito in karreta, iva okikakki in tlakatl de Etiopía kilerojtiv itlajkuilol in tiotenejmachti Isaías, iva okitlajtlani: —¿Kox tikajsikamati tlen tiklerojtiv? ");
INSERT INTO nsu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","In ye okinankili: —¿Kenik nikajsikamatis? Amika nechilvia tlán kijtosneki. In tlakatl etiope okitlatlavti in Felipe ma tlejko itech ikarreta iva ma motlali inakastla. ");
INSERT INTO nsu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tlen ye okilerojtiaya ijkí kijtova: Okivikakeh kemi se ichka kan tlamiktiah. Iva kemi se ichkakonetl amo tzajtzi ijkuak kiximah, ijkó Ye noijki amitla okijto. ");
INSERT INTO nsu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Okitlalchitlalijkeh, iva amo okipalevijkeh. ¿Kenik velis se tlapovas de ipilvah? Porke inemilis okikixtilijkeh de itech nin tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","In tlakatl de Etiopía okitlajtlani in Felipe: —Nimitztlatlavtia techilvi, ¿de akin tlapova nin tiotenejmachti, tlapova de ye o noso de íkka oksé? ");
INSERT INTO nsu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tonses, Felipe ope de kan etiope okilerojtiaya in Tiotlajkuiloli, ope kiyekilvia in yankuik kuali tlajtoli de Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Okachi tlayakapa, oajsitoh se lado kan onka atl, iva in tlakatl kappo okijto: —Nika onka atl, ¿amo velis techbautisaros? ");
INSERT INTO nsu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe okilvi: —Tla tikneltoka ika nochi moyolo, velis timobautisaros. In tlakatl kappo okilvi: —Nikneltoka ke Jesucristo yen iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","In tlakatl kappo okilvi itlakeval ma kiketzalti ikarreta. Felipe ivan kappo otemokeh ijtik atl, iva Felipe okibautisaro. ");
INSERT INTO nsu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ijkuak okiskeh de ijtik atl, iTioijyotzi in toTeko okivikak in Felipe, iva in tlakatl kappo ayakmo okittak, iva okitokak iojviv ika pakilistli. ");
INSERT INTO nsu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pero Felipe omonextito asta kan siudad de Azoto, iva de ompa oyá para kan siudad de Cesarea. Iva itech nochtin altepemeh kanik opanotiaya, otetlapovijtia de tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo, ok okinmajmavtiaya de kinmiktis in tlaneltokakeh de toTeko. Por eso, oyá okittato in wei tiopixki, ");
INSERT INTO nsu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","iva okitlajtlanili seki tlanavatil amameh para kinteititis itech tiotlamachtijkaltih tlen kateh Damasco, kan kijtojtiv ma kikavilikah ma kinkitzki san akin kajsis, tlakah iva sivameh tlen nemih itech iOjviv in Jesús, para kinvikas kintzakuati Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iva ijkuak yoyaya itech ojtli iva yonnajsia kan siudad de Damasco, ijkuakó okiyavalo se tlavili de ilvikak tlen chikavak opetlania. ");
INSERT INTO nsu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ijkuakó Saulo ovetzito ipan tlali, iva okikakki se tlajtoli, okilvi: —Saulo, Saulo, ¿tleka techtemojtinemi para techtlajyoviltis? ");
INSERT INTO nsu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo otlanankili: —¿Akin tejwatzi? In tlajtoli okinankili: —Ne niJesús, tlen te tiktemojtinemi. ");
INSERT INTO nsu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ximoketza iva xivia kan siudad, ompa mitzilviskeh tlán moneki tikchivas. ");
INSERT INTO nsu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","In tlakah tlen oyayah ivan Saulo, omomavtijkeh iva onoontikeh, okikakkeh in tlajtoli pero amika okittakeh. ");
INSERT INTO nsu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Satepa Saulo omoketzki de ipan tlali, pero ijkuak okintlapo ixtololovah, ayakmo ovelik otlachixki. Sa okimatilantiajkeh okivikakeh para Damasco. ");
INSERT INTO nsu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ompa okatka eyi tonali, mach ok otlachiaya, amo ok itla okikuaya iva nion amo ok itla okonia. ");
INSERT INTO nsu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ompa Damasco ochantia se tlakatl tlaneltokak itoka Ananías, tlen toTeko okimonextili itech se tetzavistlachialistli. Iva okilvi: —¡Ananías! Ye otlanankili: —Nikan nika, noTeko. ");
INSERT INTO nsu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","In toTeko okilvi: —Ximoketza iva xivia itech ojtli tlen itoka Melajka, iva xiktemo kán ikalijtik tlen itoka Judas, iva ompa xitlajtlani por yen Saulo de Tarso. Ye ompa modiostzajtzilijtok. ");
INSERT INTO nsu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ye okittak itech se tetzavistlachialistli se tlakatl itoka Ananías tlen okalakia kalijtik iva okintlaliaya imavah ipa para ma tlachia oksemi. ");
INSERT INTO nsu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ijkuakó Ananías okijto: —NoTeko, miekeh yonechtlapovijkeh de yejón tlakatl Saulo, ke yokintokti miek tlamantli fiero tlen tlaneltokakeh de Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iva axka nika yovala, kivalika se tlanavatil amatl tlen tlayakankeh tiopixkeh okimakakeh para kinkitzkis iva kinvikas nochtin tlen mitznotzah ika motoka. ");
INSERT INTO nsu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero in toTeko okilvi: —Xivia, porke yonikpejpenki yejón tlakatl para ma tetlapovi de Ne. Ye kintlapovis tlen amo judiojtih, noijki tlen wejwei tlanavatijkeh iva tlen gentejtih de Israel. ");
INSERT INTO nsu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne nikititis ke kipia de tlajyovis miek por Ne. ");
INSERT INTO nsu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías oyá kalijtik kan okatka in Saulo. Okalakki iva okintlali imavah ipan Saulo, iva okilvi: —Nokni Saulo, toTeko Jesús, tlen omitzmonextili itech ojtli kan otivalaya, onechvaltitlanki para xitlachia oksejpa iva para xitemi de Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","San nima otepevik de itech ixtololovah in Saulo seki kemi kakapaxtli, iva otlachixki oksejpa. Omoketzki iva omobautisaro. ");
INSERT INTO nsu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Satepa otlakua iva oksejpa okitzki chikavalistli. Saulo omoka invan tlaneltokakeh de Damasco kana keski tonali. ");
INSERT INTO nsu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","San nima Saulo ope tetlapovia kan tiotlamachtijkaltih ke Jesús yen iKone in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nochtin tlen okikakiah sa otlatlachiayah, iva okijtovayah: —¿Amo yen nin tlakatl tlen okintlajyoviltiaya nepa Jerusalén tlen kinotzah itoka in Jesús? ¿Amo ovala nika para kinkitzkis in tlaneltokakeh iva kintemaktis inmak in tlayakankeh tiopixkeh? ");
INSERT INTO nsu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saulo otlapovaya ika yolchikavalistli. In judiojtih tlen ochantiah Damasco ayakmo okimatiah tlán kijtoskeh porke Saulo kuali okinmititiaya ke Jesús yen Cristo tlen Dios okipejpenki para techmakixtis. ");
INSERT INTO nsu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Opanok kana keski tonali, in judiojtih omotlatlalvijkeh para kimiktiskeh in Saulo, ");
INSERT INTO nsu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pero ye niman okimatki. Ika tonali ika yovali sa okichixtokah kan puerta de kan yejón siudad para kimiktiskeh. ");
INSERT INTO nsu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero in momachtijkeh de Saulo, okikalakijkeh ijtik se chikivitl iva okitemovijkeh de yovak kan tepamitl tlen kiyavalojtok in siudad. Iva ijkó ovelik ocholo. ");
INSERT INTO nsu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ijkuak in Saulo oajsito Jerusalén, okinekia mosetilis invan tlaneltokakeh. Pero nochtin okimakasiah, porke amo okineltokayah ke ye noijki yomochi tlaneltokak. ");
INSERT INTO nsu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero Bernabé okivikak in Saulo okinmixpantilito in tiotlatitlaniltih. Okinmakak kuenta kenik okittak in toTeko iva kenik okitlapovi itech ojtli ijkuak oyaya para Damasco, iva kenik otetlapovi de Jesús ika yolchikavalistli ompa Damasco. ");
INSERT INTO nsu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ijkó, Saulo omoka ompa Jerusalén iva onemia invan tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Otetlapoviaya de toTeko ika yolchikavalistli. Okintlapoviaya iva omotlatlajtolnamikia invan judiojtih tlen otlapovayah griego. Pero yejvah okitemovayah kenik kimiktiskeh. ");
INSERT INTO nsu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Iva ijkuak okimatkeh in toknivah tlaneltokakeh, okivikakeh in Saulo para Cesarea, iva de ompa okititlankeh para Tarso. ");
INSERT INTO nsu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Itech yejonmeh tonaltih in tlaneltokakeh de región de Judea, de Galilea iva de Samaria, okipiayah yolsevilistli. Omoskaltiayah itech intlaneltokalis iva okimakasiah in Dios. Iva ika ipalevilis in Tioijyotzintli omomiekiliayah okachi tlen tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ijkuak Pedro okintlajpalojtinemia nochtin toknivah, noijki oyá okinmitato in toknivah tlaneltokakeh tlen chantih Lida. ");
INSERT INTO nsu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa okajsito se tlakatl vilantzi itoka Eneas, tlen yokivikaya chikueyi xivitl vetok ipan kochtlapechtli. ");
INSERT INTO nsu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ijkuakó Pedro okilvi: —Eneas, Jesucristo mitzpajtia. Ximeva iva xikyeksova mokochtlapech. Eneas san nima ovalmejtevak. ");
INSERT INTO nsu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iva nochtin tlen ochantiah siudad de Lida iva siudad de Sarón okittakeh kenik opajtik in Eneas iva otlaneltokakeh inavak toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kan siudad de Jope okatka se sivatl tlaneltokak itoka Tabita, ika griego itoka Dorcas kijtosneki masatl. Ye okichivaya miek tlamantli tlen kuali iva okinpaleviaya tlen amitla okipiayah. ");
INSERT INTO nsu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Itech nekateh tonaltih, Dorcas omokoko iva oixpolivik. Satepa de okipakeh ikuerpo, okitlalijkeh tlakpak kan se kuarto. ");
INSERT INTO nsu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","In siudad de Jope ivan siudad de Lida mach wejka motlatokeh. Iva ijkuak in tlaneltokakeh okimatkeh ke Pedro kajki Lida, ijkuakó okintitlankeh ome tlakah ma kilvitih: —Timitztlatlavtiah san nima xiviki para Jope. ");
INSERT INTO nsu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro invah oyajki iva ijkuak ompa oajsito, okivikakeh tlakpak kan kuarto kan okatka in kuerpo. Nochtin iknosivameh okiyavalojkeh in Pedro ochokayah iva okinmititiayah in kuemeh ivan tlakemeh tlen kimokentiah tlen Dorcas okinchi ijkuak ok onemia. ");
INSERT INTO nsu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro okinkixti nochtin. Omotlankuaketzki iva omodiostzajtzili. Satepa onmokuapki para kan kajki in mikatl, iva okilvi: —¡Tabita, ximeva! Ijkuakó Tabita okintlapo ixtololovah, iva ijkuak okittak in Pedro, omotlali. ");
INSERT INTO nsu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro okimakitzki iva okiketzalti. Satepa okinnotzki in tlaneltokakeh ivan iknosivameh, iva okinmixpantili yolitok. ");
INSERT INTO nsu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yejón tlen opanolok omomatki itech nochi in siudad de Jope, iva miekeh otlaneltokakeh inavak toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro omoka miek tonali ompa Jope. Omoka kan ikalijtik se tlakatl itoka Simón tlen kinyektlalia kuetlaxtih. ");
INSERT INTO nsu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kan siudad de Cesarea okatka se tlakatl itoka Cornelio. Okatka kapita de se siento soldadojtih, iva yejón grupo de soldadojtih okitokayotiayah Batallón Italiano. ");
INSERT INTO nsu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ye ivan nochi ifamilia omotemaktiayah iva okimaviliayah in Dios. Ye okitemakaya miek tomi para okinpaleviaya in judiojtih tlen amitla okipiayah, iva nochipa omodiostzajtziliaya. ");
INSERT INTO nsu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Se tonali, kemi las tres de tiotlaki Cornelio okittak se tetzavistlachialistli kan yi neli kuali okittak se ilvikaktlatitlanili de Dios tlen okalakki ikalijtik kan ye okatka iva okilvi: —¡Cornelio! ");
INSERT INTO nsu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio okitlajtlatak in ilvikaktlatitlanili ika nemavtili iva okinankili: —¿Tlán tikneki, noTeko? In ilvikaktlatitlanili okilvi: —Dios yomitzchivili kuenta modiostzajtzilis iva tlen tikchiva por tikinpalevia tlen prowestih. ");
INSERT INTO nsu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Axka xikintitlani sekimeh tlakah kan siudad de Jope para ma kinotzatih in Simón, tlen noijki kinotzah Pedro. ");
INSERT INTO nsu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kalotitok ichan se tlakatl tlen noijki itoka Simón, tlen kinyektlalia kuetlaxtih, iva chanti itempan atl tlen wei. Ye mitzilvis tlán moneki tikchivas. ");
INSERT INTO nsu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ijkuak in ilvikaktlatitlanili oyá, Cornelio okinnotzki ome itlakevalvah iva se soldado. In soldado okatka tenmachtli iva yi neli omotemaktiaya inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Okintlapovi de nochi tlen okittak, iva satepa okintitlanki para Jope. ");
INSERT INTO nsu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Omostlatik, kemi tlajko tonali, ijkuak yejvah oyayah itech ojtli iva yonajsiah Jope, ijkuakó Pedro otlejkok tlakpak ikpak kali omodiostzajtzilito. ");
INSERT INTO nsu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sa tlawel otiojsivia iva okinekia tlakuas, iva mientras okichiviliayah tlan kikuas, okittak se tetzavistlachialistli, ");
INSERT INTO nsu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","okittak in ilvikak otlapovik iva ovaltemovaya ipan tlali kemi se wei tzotzoli ilpitivitz itech navi iyakyovah. ");
INSERT INTO nsu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Itech yejón tzotzoli okatkah miekeh yolkameh de navi inmikxivah, noijki tlen motilanah ipan tlali iva tlen patlanih. ");
INSERT INTO nsu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ijkuakó Pedro okikakki se tlajtoli, okilvi: —Ximoketza Pedro, xikinmikti iva xikinkua. ");
INSERT INTO nsu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro otlanankili: —¡Amo, noTeko! Ne amo keman nikua itla yolkatl tlen amo chipavak. ");
INSERT INTO nsu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","In tlajtoli oksemi okilvi: —Amo xikijto amo chipavak tlen Dios yokichipa. ");
INSERT INTO nsu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ijkó opanok eyi welta, iva satepa in tzotzoli oksemi otlejkok ilvikak. ");
INSERT INTO nsu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ijkuak Pedro ok okiyejyekojtoka tlan kijtosneki tlen okittak, ijkuakó oajsikoh kaltempa itlatitlanilvah in Cornelio, tlajtlantivitzeh kán ikalijtik in Simón. ");
INSERT INTO nsu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ijkuak oajsikoh otlajtlankeh kox ompa kalotitok se tlakatl itoka Simón, tlen noijki kinotzah Pedro. ");
INSERT INTO nsu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mientras Pedro ok okiyejyekojtoka tlán kijtosneki yejón tetzavistlachialistli, in Tioijyotzintli okilvi: —Xikaki, mitztemovah eyi tlakah. ");
INSERT INTO nsu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ximoketza, xitemo iva xikinvika iva amo xikijto kox tias o noso amo tias, porke Ne onikinvaltitlanki. ");
INSERT INTO nsu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro otemok iva okinmilvi itlatitlanilvah in Cornelio: —Yen ne tlen imejvah innechtemovah. ¿Tlán para innechtemovah? ");
INSERT INTO nsu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yejvah okinankilijkeh: —Otechvaltitlanki in kapita Cornelio, tlen tlakamela iva tlen kimavilia in Dios, tlen nochtin judiojtih kitlakitah. Se ilvikaktlatitlanili de Dios okilvi ma tlanavati ma mitznotzatih para xivia kan ikalijtik in Cornelio, para ma kikaki tlan tejwatzi tikilvis. ");
INSERT INTO nsu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ijkuakó Pedro okinmilvi ma kalakikah, iva yejón yovak ompa omokajkeh. Omostlatik Pedro okinvikak. Noijki invan oyajkeh oksekimeh toknivah tlaneltokakeh de Jope. ");
INSERT INTO nsu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Omostlatik oajsitoh Cesarea. Cornelio okinchixtoka, iva yokinmololo tlen itla kinmita ivan sekimeh iyoliknivah. ");
INSERT INTO nsu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ijkuak Pedro oajsito kaltempa, Cornelio okiski okinamikito iva omotlankuaketzki ikxitla para kimavistilis. ");
INSERT INTO nsu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro okiketzalti, iva okilvi: —Ximoketza, ne noijki nitlakatl kemi te. ");
INSERT INTO nsu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iva mientras omotlapoviayah, Pedro okalakki kalijtik iva okinmitak miekeh ompa ololitokeh. ");
INSERT INTO nsu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ijkuakó Pedro okinmilvi: —Imejvah inkimatih ke itlanavatil Moisés amo kitekavilia ma mosetili se judío ivan se tlen amo judío. Pero toYejwatzi onechititi ke amo ma nikitta nion se tlakatl kemi amo tlatiochivali o noso amo chipavak inavak Ye. ");
INSERT INTO nsu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por eso, san nima ijkuak ontlatitlankeh ma nechnotzatih, onivala iva amitla onikijto. Nikneki nikmatis pues, tleka onnechnotzatoh. ");
INSERT INTO nsu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio okinankili: —Yi kipia navi tonali, kemi nin ora de las tres de tiotlaki, ne nika onikatka nokalijtik onimosavtoka iva onimodiostzajtzilijtoka, iva ijkuakó onechmonextili se tlakatl tlen opetlania itlaken. ");
INSERT INTO nsu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iva onechilvi: “Cornelio, Dios yokikakki modiostzajtzilis iva kilnamiktok tlen tikchiva por tikinpalevia tlen prowestih. ");
INSERT INTO nsu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xitlatitlani kan siudad de Jope, ma kinotzatih in Simón tlen noijki kinotzah Pedro, kalotitok ikalijtik tlen oksé Simón, tlen kinyektlalia kuetlaxtih iva chanti itempan atl tlen wei.” ");
INSERT INTO nsu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Por eso san nima onitlatitlanki ma mitznotzatih, iva niktlasojkamati por otivala. Axka nika tikateh tinochtin ixpan Dios, iva tiknekih tikakiskeh nochi tlen toTeko omitzilvi techilviki. ");
INSERT INTO nsu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ijkuakó Pedro ope kintlapovia, okijto: —Axka yi neli nikmomaka kuenta nik in toYejwatzi amo techichikotlasojtla, ");
INSERT INTO nsu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sino itech nochi in tlaltikpaktli toYejwatzi kinneki tlen kimaviliah iva tlen kichivah tlen kuali. ");
INSERT INTO nsu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ToYejwatzi otechtlapovi tejvah tlen de Israel, iva otechmakak in yankuik kuali tlajtoli tlen kitemaka yolsevilistli por medio de Jesucristo, yen tlen mochijtok inTeko de nochtin tlaltikpaktlakah. ");
INSERT INTO nsu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Imejvah kuali inkimatih nochi tlen opanolok itech nochi in tlali de Judea. Nochi opejki itech tlali de Galilea satepa de ijkuak Juan otetlapovi iva otlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Imejvah inkimatih ke Jesús de Nazaret, toYejwatzi okipejpenki iva okitemiti de Tioijyotzintli iva okimakak velitilistli. Iva inkimatih ke Jesús okichijtinenki tlen kuali iva okinpajti nochtin tlen okintlajyoviltiaya in Amo Kuali Tlakatl. Jesús ovelik okichi nochi yejón porke toYejwatzi okatka Iva. ");
INSERT INTO nsu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tejvah titestigojtih de nochi tlen okichi itech región de Judea iva kan siudad de Jerusalén. Pero satepa okipilojkeh itech se krus iva ijkó nik okixpolojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero toYejwatzi okiyoliti ipan eyi tonali, iva okichi ma techmonextili. ");
INSERT INTO nsu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Amo okinmonextili nochtin, sino san tejvah tlen toYejwatzi desde yi wejkavitl otechpejpenki para satepa ma tiktematiltikah tlen otikittakeh. Yen tejvah tlen otitlakuajkeh iva otikonikeh ivan Jesús satepa de omoyoliti. ");
INSERT INTO nsu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iva Ye otechtitlanki ma tikintlapovikah in gentejtih, iva ma tikinmatiltikah nik yen toYejwatzi okitlali in Jesús kemi jues para yen kijtos akin tlajtlakole iva akin amo de nochtin tlen yolitokeh iva tlen yoixpolikeh. ");
INSERT INTO nsu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yi wejkavitl nochtin tiotenejmachtijkeh otlapojkeh de Jesús. Okijtojkeh ke nochtin tlen tlaneltokaskeh inavak, toYejwatzi kintlapojpolvis de intlajtlakol ijkuak kinotzaskeh ika itoka. ");
INSERT INTO nsu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mientras Pedro ok otlapojtoka, ijkuakó in Tioijyotzintli ovala intech nochtin tlen okikaktokah itlajtol. ");
INSERT INTO nsu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iva in tlaneltokakeh judiojtih tlen ovalajkeh ivan Pedro, sa otlatlachixkeh porke okittakeh ke in Tioijyotzintli noijki ovala intech tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porke okinkakiah otlapovayah ika oksekimeh tlajtoltih iva okiweichivayah in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ijkuakó Pedro okijto: —¿Akin velis kintzakuilis para amo ma mobautisarokah, tla yokiselijkeh in Tioijyotzintli noijki kemi tejvah otikselijkeh? ");
INSERT INTO nsu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iva otlanavati ma kinbautisarokah ika itoka in Jesucristo. Satepa okitlatlavtijkeh in Pedro ma mokava invah kana keski tonali. ");
INSERT INTO nsu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","In tiotlatitlaniltih ivan toknivah tlaneltokakeh tlen okatkah Judea, okimatkeh ke tlen amo judiojtih noijki yokiselijkeh itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iva ijkuak Pedro oajsito Jerusalén, sekimeh tlaneltokakeh judiojtih ivan omotlatlajtolnamikeh. ");
INSERT INTO nsu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Okilvijkeh: —¿Tleka otivia kan inkalijtik tlen amo judiojtih iva asta invah otitlakua? ");
INSERT INTO nsu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro ope kinmaka kuenta de nochi tlen opanolok iva okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ne onikatka kan siudad de Jope onimodiostzajtzilijtoka, iva onikittak se tetzavistlachialistli, onikittak se wei tzotzoli ilpitivitz itech navi iyakyovah, iva ovaltemovaya de ilvikak asta kan ne onikatka. ");
INSERT INTO nsu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Onikonyekittak para nikmatis tlán kipia ijtik, iva onikinmitak sekimeh yolkameh de navi inmikxivah, sekimeh yolkameh tlen tekuanimeh, sekimeh tlen motilanah ipan tlali iva sekimeh tlen patlanih. ");
INSERT INTO nsu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iva onikakki se tlajtoli onechilvi: “Ximoketza Pedro, xikinmikti iva xikinkua.” ");
INSERT INTO nsu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero ne onitlanankili: “Amo, noTeko. Ne amo keman nikua itla yolkatl tlen amo chipavak.” ");
INSERT INTO nsu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ijkuakó in tlajtoli de ilvikak ipan ojpa onechilvi: “Amo xikijto amo chipavak tlen Dios yokichipa.” ");
INSERT INTO nsu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ijkó opanok eyi welta, iva satepa nochi oksemi otlejkok para ilvikak. ");
INSERT INTO nsu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ijkuakó eyi tlakah de Cesarea oajsitoh kalijtik kan ne onikatka porke okintitlankeh de Cesarea ma nechtemotih. ");
INSERT INTO nsu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","In Tioijyotzintli onechnavati ma nivia invah iva amo ma nikijto kox nias o noso amo nias. Noijki oyajkeh nova ninmeh chikuasemeh toknivah. Ijkuak otajsitoh Cesarea, otikalakeh kan ikalijtik se tlakatl itoka Cornelio. ");
INSERT INTO nsu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ye otechtlapovi kenik okittak itech ikalijtik se ilvikaktlatitlanili tlen omoketoka iva okilvi: “Xikintitlani sekimeh tlakah kan siudad de Jope para ma kinotzatih in Simón, tlen noijki kinotzah Pedro, ");
INSERT INTO nsu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","iva ye mitzilvis kenik velis timomakixtis te ivan nochtin tlen kateh mokalijtik.” ");
INSERT INTO nsu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ijkuak ope nikintlapovia, in Tioijyotzintli ovala intech ijkó kemi tejvah noijki totech ovala. ");
INSERT INTO nsu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ijkuakó onikilnamiki tlen okijto in toTeko: “Juan otlabautisaro ika atl, pero imejvah inmobautisaroskeh ika Tioijyotzintli.” ");
INSERT INTO nsu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Iva axka, tla toYejwatzi kinmaka yejvah noijki in Tioijyotzintli, tlen tejvah noijki otechmakak ijkuak otikneltokakeh in toTeko Jesucristo, ¿akin ne para ma niktzakuli in toYejwatzi tlen Ye kineki kichivas? ");
INSERT INTO nsu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ijkuak in tlaneltokakeh de Jerusalén okikakkeh yejón tlajtoli, ayakmitla okijtojkeh iva okiweichijkeh in Dios, iva okijtojkeh: —¡Axka tikajsikamatih ke tlen amo judiojtih, Dios kinkavilia noijki ma moyolkuapakah para velis kipiaskeh nemilistli para semijkak! ");
INSERT INTO nsu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ijkuak okimiktijkeh in Esteban, ope noijki kinchochololtiah tlen oksekimeh tlaneltokakeh. Sekimeh ocholojkeh oyajkeh para Fenicia, Chipre iva Antioquía. Itech yejonmeh lugartih otetlapovijkeh de tlen yankuik kuali tlajtoli, pero okintlapovijkeh san yejvah tlen judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero sekimeh tlaneltokakeh de Chipre iva de Cirene oajsitoh kan siudad de Antioquía, iva okintlapovijkeh tlen amo judiojtih de tlen yankuik kuali tlajtoli de toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ivelitilis in toTeko intech okatka, iva miekeh otlaneltokakeh iva omokuapkeh inavak toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","In tlaneltokakeh de Jerusalén okimatkeh tlen otlamochijtoka Antioquía, iva ijkuakó okititlankeh in Bernabé ma via ompa. ");
INSERT INTO nsu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ijkuak Bernabé oajsito ompa Antioquía, okitajsik kenik in Dios okintiochivaya, iva sa tlawel opakki. Okinyolchika nochtin, okinmilvi amo kema ma kipolokah intlaneltokalis inavak toTeko iva ma kivelkakikah ika nochi inyolo. ");
INSERT INTO nsu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé okatka kuali tlakatl, tentok de Tioijyotzintli iva tentok de tlaneltokalistli. Iva ijkó okachi miekeh omosetilijkeh inavak toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Satepa, Bernabé oyá kan siudad de Tarso okitemoto in Saulo. Ijkuak okajsik, okivikak para kan siudad de Antioquía. ");
INSERT INTO nsu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ompa omokajkeh invan toknivah tlaneltokakeh se xivitl, iva okinmachtijkeh miekeh gentejtih. Ompa Antioquía in tlaneltokakeh yikinika ope kintokayotiah kristianojtih. ");
INSERT INTO nsu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Itech yejonmeh tonaltih, sekimeh tiotenejmachtijkeh oyajkeh de Jerusalén asta Antioquía. ");
INSERT INTO nsu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Se de yejvah itoka Agabo, omoketzki iva okitematilti ika Tioijyotzintli nik yetos miek apistli itech nochi in tlaltikpaktli. Iva ijkó opanolok itech yejonmeh tonaltih ijkuak Claudio okatka wei tekiva de Roma. ");
INSERT INTO nsu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tonses in tlaneltokakeh de Antioquía, okijtojkeh kinpaleviskeh in toknivah tlen chantih itech tlali de Judea, ijkó kemi tlen oveliskia okitemakaskia kada se. ");
INSERT INTO nsu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iva ijkó okichijkeh. Bernabé ivan Saulo yejvah okivikakeh in tomi tlen okololojkeh Antioquía, iva okinvikilijkeh in tlayakankeh tlaneltokakeh tlen chantih itech tlali de Judea. ");
INSERT INTO nsu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Noijki itech yejonmeh tonaltih, in wei tlanavati Herodes ope kinchochololtia sekimeh tlaneltokakeh para kintlajyoviltis. ");
INSERT INTO nsu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Herodes otlanavati ma kimiktikah ika espada in Jacobo ikni in Juan. ");
INSERT INTO nsu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Komo okittak okinpakti in judiojtih, tonses noijki otlanavati ma kitzkikah in Pedro. Ijkó opanolok mero itech ilvitl ijkuak mokua in pan tlen amo kipia xokotixtli. ");
INSERT INTO nsu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ijkuak Herodes okikitzki in Pedro, okitzaki telpiloya. Okintlali navi grupos de nanavi soldadojtih para ma kikuidarojtokah. Herodes okijto kinmixpantilis in gentejtih san ma pano in ilvitl de pascua. ");
INSERT INTO nsu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","In soldadojtih kuali okikuidarojtokah in Pedro kan telpiloya. Pero in toknivah tlaneltokakeh amo okavayah de omodiostzajtziliayah inavak Dios por yen Pedro. ");
INSERT INTO nsu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yejón yovak antes de tlanesis para Herodes kinmixpantilis in gentejtih, Pedro okochtoka ilpitok ika ome kadenajtih iva okikuidarojtokah ome soldadojtih ik inajnakastla, iva oksekimeh soldadojtih okatkah kaltempa de kan telpiloya otlakuidarojtokah. ");
INSERT INTO nsu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ijkuakó ovalmonexti se iilvikaktlatitlanil in toTeko iva otlapetlanki ijtik telpiloya. In ilvikaktlatitlanili okitilko in Pedro kan iomijsikuilpa, okijxiti iva okilvi: —¡Ximeva totoka! Iva in kadenajtih tlen ika oilpitoka itech imavah in Pedro ovetzkeh. ");
INSERT INTO nsu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","In ilvikaktlatitlanili okilvi: —Ximotzotzolti iva ximokakti. Pedro ijkó okichi, iva in ilvikaktlatitlanili oksemi okilvi: —Xikmokenti motlaken iva xiviki nova. ");
INSERT INTO nsu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro oyá ivan ilvikaktlatitlanili, iva amo okimatia kox yi neli tlen otlamochijtoka o noso xamo san okittaya se tetzavistlachialistli. ");
INSERT INTO nsu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Okipanavijkeh tlen primer grupo de soldadojtih tlen otlakuidarojtokah iva satepa okipanavijkeh oksé grupo, iva para ompa oajsitoh kan wei puerta de tepostli kan se kisa para kan siudad. In puerta omotlapo iselti, in ilvikaktlatitlanili ivan Pedro okiskeh, iva satepa de okipanavijkeh se kaye, in ilvikaktlatitlanili san ovalpolivik iva Pedro omoka iselti. ");
INSERT INTO nsu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ijkuakó Pedro okimomakak kuenta tlen opanolok, iva okijto: —Axka yi neli nikajsikamati nik in toTeko okivaltitlanki iilvikaktlatitlanil para nechmakixtis de imak Herodes, iva de tlen okinekiah nechtoktiskeh in judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ijkuak Pedro okimomakak kuenta de yejón tlamantli, oyá para kan ikalijtik in María, imama in Juan, tlen noijki okinotzayah Marcos, kan miekeh oololitokah omodiostzajtzilijtokah. ");
INSERT INTO nsu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ijkuak Pedro okitokaro in puerta de kan kiavak, se ichpochtli itoka Rode oyá otlachiato akin tlatokarova. ");
INSERT INTO nsu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ijkuak okitenkaki nik yen Pedro, sa tlawel opakki asta amo okitlatlapoli, yej omotlelo kalijtik okinmilvito nik in Pedro kajki kan puerta. ");
INSERT INTO nsu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ijkuakó okilvijkeh in Rode: —¡Te tiloka! Pero ye okinmilvi nik yi neli. Iva yejvah okijtojkeh: —Xamo yen ilvikaktlatitlanili tlen kipalevia. ");
INSERT INTO nsu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro ok otlatokarojtoka kan puerta. Iva ijkuak okitlatlapolijkeh, okittakeh iva sa otlatlachixkeh. ");
INSERT INTO nsu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero ye okinchivili señas ika ima de ma motenkavakah, iva okintlapovi de kenik in toTeko okikixti de kan telpiloya. Iva okinmilvi: —Xiktlapovikah in Jacobo iva noijki in toknivah tlaneltokakeh de tlan onechpanolok. Satepa okiski de ompa iva oyá oksé lugar. ");
INSERT INTO nsu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ijkuak otlaneski, in soldadojtih ope mopajsolovah sa tlawel porke amo okimatiah kanik oyá in Pedro. ");
INSERT INTO nsu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes otlanavati kuali ma kitemokah, pero amo okajsikeh. Okintlatzintoki in soldadojtih iva satepa otlanavati ma kinmiktikah. Satepa Herodes okiski de Judea iva oyá ochantito Cesarea. ");
INSERT INTO nsu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes okualantoka innavak in gente de Tiro iva de Sidón, pero in gentejtih omotlatlalvijkeh yaskeh kittativih in Herodes asta Cesarea. Se itlakeval in Herodes tlen okachi tlayakantok itoka Blasto, okichijkeh inyolikni para ye ma kitlapovi in Herodes para ayakmo ma kualani, porke in gentejtih de Tiro iva de Sidón nochi tlen okuayah ovalaya de ipaís in Herodes. ");
INSERT INTO nsu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes okitlali se tonali para invah motlapovis. Iva yejón tonali, Herodes omotzotzolti kemi wei tlanavati iva omotlali kan teyekankavah, iva ope kintlapovia. ");
INSERT INTO nsu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ijkuakó in gentejtih ope tzajtzih chikavak: —¡Nin tlen techtlapovijtok, amo se tlakatl sino se dios! ");
INSERT INTO nsu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","San nima ijkuakó, iilvikaktlatitlanil in toTeko okichi in Herodes ma valmokoko, porke amo okiweijkachi in Dios, ochakalovak iva omikki. ");
INSERT INTO nsu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Itlajtol in Dios okachi oxitinki iva in tlaneltokakeh okachi omomiekiliayah. ");
INSERT INTO nsu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ijkuak Bernabé ivan Saulo yokitlamijkeh intekiv ne Jerusalén, omokuapkeh para Antioquía. Okivikayah in Juan tlen noijki okinotzayah Marcos. ");
INSERT INTO nsu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","In toknivah tlaneltokakeh tlen okatkah Antioquía, ompa okatkah Bernabé, Simón tlen okitokayotijkeh Negro, Lucio de Cirene, Saulo iva Manaén tlen iva omoskalti in kobernador Herodes. Nochtin yejvah okatkah tiotenejmachtijkeh iva tlamachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Se tonali, ijkuak okimavistilijtokah toTeko iva omosavtokah, in Tioijyotzintli okijto: —Xikinxelokah in Bernabé ivan Saulo para kichivaskeh se tekitl porke para yejón nik onikinnotzki. ");
INSERT INTO nsu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Satepa de omosavkeh iva omodiostzajtzilijkeh, okintlalijkeh inmavah ipan Bernabé iva ipan Saulo, iva satepa okinmakajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Satepa in Tioijyotzintli okintitlanki in Bernabé ivan Saulo kan altepetl de Seleucia, iva de ompa otlejkokeh itech se barko iva oyajkeh kan tlali de Chipre tlen yavalitok de atl tlen wei. ");
INSERT INTO nsu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ijkuak oajsitoh kan altepetl de Salamina, ompa ope tetlapoviah de itlajtol in Dios kan intiotlamachtijkalvah in judiojtih. Bernabé ivan Saulo okivikakeh in Juan Marcos para ma kinpalevi. ");
INSERT INTO nsu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Onenkeh itech nochi in tlali de Chipre iva oajsitoh asta kan altepetl de Pafos, ompa okajsitoh se tetlajchivi judío itoka Barjesús, tlen otlakajkayavaya okijtovaya ke ye se tiotenejmachti de Dios. ");
INSERT INTO nsu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yejón tetlajchivi omovikaya ivan kobernador Sergio Paulo tlen okipiaya tlamatilistli. Iva yejón kobernador otlatitlanki ma kinotzatih in Bernabé ivan Saulo, porke okinekia kikakis itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero in tetlajchivi Barjesús, tlen ika tlajtoli griego itoka Elimas, omoketzki inyakapa para okintzakuili in Bernabé ivan Saulo, porke amo okinekia ke in kobernador ma kineltoka itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ijkuakó Saulo tlen noijki kinotzah Pablo, tentok de Tioijyotzintli, okiyektlajtlatak in tetlajchivi ");
INSERT INTO nsu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","iva okilvi: —¡Te tiikone in Amo Kuali Tlakatl, titekajkaya iva amo tikuali, iva tiktlavelita tlen kuali! ¿Asta keman tikavas de tikijtlakojtos in ojtli tlen melavak de toTeko? ");
INSERT INTO nsu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Axka in toTeko mitztlajyoviltis, tiixkopitzivis iva ayakmo velis tikittas itlavil in tonali por se tiempo. San nima ijkuakó Elimas ovalixkopitzivik kemi oyeskia ovaltlayovak, iva sa otlamatemovaya okinekia íkka ma kipalevi ma kimatilantiv. ");
INSERT INTO nsu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ijkuak in kobernador okittak tlen opanolok, okineltokak. Yi neli okimotetzavi itlamachtil in toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo ivan ikompañerojvah oyajkeh itech barko para altepetl de Pafos iva oajsitoh kan altepetl de Perge tlen kajki kan región de Panfilia. Pero Juan Marcos ompa okinkajte iva omokuapki para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Satepa yejvah oyajkeh de Perge asta Antioquía, tlen kajki kan región de Pisidia. Iva se sábado, okalakeh itech se tiotlamachtijkali ivan ompa omotlalijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Satepa de okilerojkeh in libro de Moisés iva tlen okijkuilojkeh in tiotenejmachtijkeh, in tlayakankeh de yejón tiotlamachtijkali otlatitlankeh ma koninmilvitih in Pablo ivan Bernabé: —Noknivah, tla inkipiah se tlajtoli para ma moyolchikavakah in gentejtih, xikijtokah. ");
INSERT INTO nsu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ijkuakó Pablo omoketzki iva okajkuanki ima para ayakmo ma tlajtokah. Okijto: —Xikakikah imejvah, gente de Israel, iva imejvah tlen inkimakasih in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","In Dios de Israel okinpejpenki tlen yi wejkavitl tokojkolvah, iva okinmiekili ijkuak ok okatkah itech país de Egipto tlen amo inpaís. Satepa toYejwatzi okinkixti de ompa ika wei ivelitilis. ");
INSERT INTO nsu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ToYejwatzi okinxiko de nochi tlen yejvah okichivayah kan tlavaki kemi ompoali xivitl, ");
INSERT INTO nsu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","iva okinpopolo tlen ochanchivayah itech chikomeh tlalmeh de Canaán, iva yejonmeh tlalmeh okinmakak tlen yi wejkavitl tokojkolvah kemi erensia. ");
INSERT INTO nsu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nochi yejón opanolok kemi 450 años. Satepa toYejwatzi okinmakak tlayakankeh asta itech nekateh tonaltih ijkuak okatka in tiotenejmachti Samuel. ");
INSERT INTO nsu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tlen yi wejkavitl tokojkolvah okitlajtlankeh se wei tlanavati para ma kinnavati, iva toYejwatzi okinmakak in Saúl ikone in Cis tlen familia de Benjamín, iva ye otlanavati ompoali xivitl. ");
INSERT INTO nsu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Satepa okipatlak in Saúl, iva okitlali in David kemi wei tlanavati, iva toYejwatzi okijto: “Yonikittak in David tlen ikone in Isaí, se tlakatl tlen nechyolpaktia, tlen kichivas nochi tlen Ne nikneki.” ");
INSERT INTO nsu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","’ToYejwatzi okijto ke se de iwejkaixvi in David yen kitlalis para ma kinmakixti in gentejtih de Israel. Iva yejón iwejkaixvi in David yen Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes de vitz in Jesús, in Juan tlen tlabautisaro okintlapovi nochtin gentejtih de Israel, okinmilviaya ma moyolkopakah iva ma mobautisarokah. ");
INSERT INTO nsu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ijkuak Juan yokitlamijtokah itekiv, okijto: “Mach ne tlen imejvah inkiyejyekovah. Pero satepa de ne vitz oksé tlakatl, tlen amo notech povi nion para nikintojtomilis ikakvah.” ");
INSERT INTO nsu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Noknivah, imejvah tlen invalajtokeh de Abraham, iva imejvah tlen inkimakasih in toYejwatzi, para tejvah nin tlajtoli tlen temakixtia. ");
INSERT INTO nsu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tlen chantih Jerusalén iva intlayakankavah, amo okinekiah kimatiskeh akin Jesús, iva nion amo okajsikamatiah intlajtol in tiotenejmachtijkeh maski nochipa okilerovayah ijkuak sábado. Ijkuak okixpolojkeh in Jesús, amo okimomakakeh kuenta ke okichijkeh tlen yi wejkavitl okijtojkeh in tiotenejmachtijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maski amo okajxilijkeh nion se tlajtlakoli para kixpoloskeh, yejvah okitlajtlanilijkeh in Pilato ma tlanavati ma kixpolokah. ");
INSERT INTO nsu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Satepa de okichijkeh nochi kemi kijtova in Tiotlajkuiloli de tlen okipanoskia, okitemovijkeh ikuerpo de itech krus iva okitookakeh. ");
INSERT INTO nsu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero toYejwatzi okiyoliti. ");
INSERT INTO nsu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iva ok miek tonali okinmonextili tlen Iva onemiah desde Galilea asta Jerusalén. Axka, yejvah tetlapoviah de Jesús para nochtin ma kimatikah. ");
INSERT INTO nsu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Iva axka tejvah noijki timechmatiltiah nin yankuik kuali tlajtoli, tlen Dios okinkakiti kinmakas in yi wejkavitl tokojkolvah. ");
INSERT INTO nsu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tejvah tlen tiwejkaixvimeh de tlen yi wejkavitl tokojkolvah, toYejwatzi yokichi tovah tlen achto okinmilvi. ToYejwatzi okichi ijkuak okiyoliti in Jesús. Kemi kijtovah ipan ome salmo: “Te tinoKone, desde axka Ne nimoTajtzi.” ");
INSERT INTO nsu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ToYejwatzi ipa yokijtojka ke kiyolitis para amo ma ijtlakavi ikuerpo. ToYejwatzi ijkí okijto: “Imejvah nimechmakas nochi in tlatiochivalistli tlen onikilvi nikmakas in David.” ");
INSERT INTO nsu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Por eso noijki kijtova itech oksé Salmo: “Amo tikavas ma ijtlakavi ikuerpo in motekipano yolchipavak.” ");
INSERT INTO nsu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Yi neli, David okinpalevi tlen okatkah itech ye itiempo ijkó kemi toYejwatzi okinekia, iva ijkuak oixpolivik okitookakeh kan otoktokah ikojkolvah, iva ikuerpo oijtlakavik. ");
INSERT INTO nsu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero tlen toYejwatzi okiyoliti amo oijtlakavik ikuerpo. ");
INSERT INTO nsu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ijkó pues noknivah, moneki xikmatikah ke por medio de Jesús, toYejwatzi velis imechtlapojpolvis de inmotlajtlakol. Nochtin tlen tlaneltokah inavak Jesús, mokavah kuali ivan toYejwatzi, amo kemi itlanavatil Moisés tlen amo keman ovelik íkka okika kuali inavak toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Xikpiakah kuidado pues, para amitla imechpanos de tlen okijtojkeh in tiotenejmachtijkeh. Yejvah okijtojkeh: ");
INSERT INTO nsu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Xikittakah, imejvah tlen san invetzkah, ximotetzavikah iva xipopolivikah. Porke itech nin tiempo ijkuak imejvah ok inkateh, Ne nikchivas se tlamantli iva imejvah amo inkineltokaskeh maski íkka ma imechyekilvi. ");
INSERT INTO nsu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ijkuak Pablo ivan Bernabé okiskeh de kan intiotlamachtijkal in judiojtih, tlen amo judiojtih okintlatlavtijkeh ke para ipan chikomika sábado oksemi ma kintlapovikah de yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ijkuak yokiskeh de kan tiotlamachtijkali, miekeh judiojtih oyajkeh ivan Pablo ivan Bernabé. Noijki invah oyajkeh sekimeh tlen okalakeh itech intiotlamachtil judiojtih iva omotemaktiayah inavak Dios. Pablo ivan Bernabé okinmilvijkeh nochtin ma motenmachijtokah itech itlasojtlalis in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ovalchikometik sábado, kasi nochtin gentejtih de siudad de Antioquía omololojkeh para kikakiskeh itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sekimeh judiojtih ijkuak okittakeh nik miekeh omololojkeh, sa tlawel omoxikojkeh. Ope kijtovah ke amijtok tlen Pablo okijtovaya, iva noijki ope kivikaltiah. ");
INSERT INTO nsu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ijkuakó Pablo ivan Bernabé otlajtojkeh ika yolchikavalistli. Okijtojkeh: —Imejvah tlen injudiojtih omonekia yen imejvah achto timechtlapoviskeh de itlajtol in toYejwatzi. Pero komo imejvah amo inkinekih inkiseliskeh iva inkiyejyekovah ke amo imotech povi para inkipiaskeh nemilistli para semijkak, axka tejvah tikintlapoviskeh tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porke toTeko ijkó otechnavati, okijto: Onimitztlali kemi se tlavili para xikintlavili tlen amo judiojtih, para xikinvikili notlajtol de temakixtilistli asta kan ontlantok in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tlen amo judiojtih, ijkuak ijkó okikakkeh, sa tlawel opakeh iva ope kijtovah ke itlajtol in toTeko sa tlawel kuali. Iva otlaneltokakeh nochtin tlen yokatkah para kipiaskeh nemilistli para semijkak. ");
INSERT INTO nsu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Itlajtol in toTeko omotematilti itech nochi neká tlali. ");
INSERT INTO nsu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero in judiojtih okintlatlalvijkeh sekimeh sivameh tlen wejweititokeh tlen okitlakitayah Dios, iva noijki okintlatlalvijkeh tlen okachi tlatlayakantokeh de yejón siudad. Okintlatlalvijkeh para ma kinchololtikah in Pablo ivan Bernabé, iva ma kinkixtikah de kan yejón región. ");
INSERT INTO nsu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tonses, Pablo ivan Bernabé okintzejtzelojkeh inmikxivah, kemi se señas ke yejvah ayakmo kipia tlen kittaskeh invan yejonmeh gentejtih. Iva satepa oyajkeh para kan siudad de Iconio. ");
INSERT INTO nsu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero in tlaneltokakeh de Antioquía otentoka inyolo ika pakilistli iva ika Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kan siudad de Iconio Pablo ivan Bernabé okalakeh san sekka kan intiotlamachtijkal in judiojtih, sa tlawel kuali otlapojkeh ke miekeh judiojtih iva tlen amo judiojtih otlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero in judiojtih tlen amo otlaneltokakeh, okintlatlalvijkeh tlen amo judiojtih para ma kiyejyekokah tlen amo kuali en kontra de toknivah. ");
INSERT INTO nsu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Por eso, Pablo ivan Bernabé omokajkeh ompa miek tonali. Otetlapovijkeh ika yolchikavalistli porke omotenmachiayah inavak toTeko. Ye okinmakaya velitilistli para ma kinchivakah neskayomeh iva nexkuitiltih, iva ijkó toTeko okinmititi in gentejtih ke in tlajtoli tlen okinmilviayah de iiknomachilis yi neli melajka. ");
INSERT INTO nsu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","In gentejtih tlen de Iconio omoxexelojkeh: sekimeh okatkah de akuerdo ivan judiojtih iva sekimeh ivan tiotlatitlaniltih. ");
INSERT INTO nsu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Satepa, sekimeh judiojtih iva tlen amo judiojtih, iva intekivajkavah omotlatlalvijkeh para fiero kintoktiskeh in tiotlatitlaniltih iva para kinmakaskeh ika tetl. ");
INSERT INTO nsu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero Pablo ivan Bernabé, ijkuak okimatkeh, ocholojkeh iva oyajkeh kan siudad de Listra iva kan siudad de Derbe tlen kateh itech tlali de Licaonia, iva itech oksekimeh altepemeh tlen ik ompa kateh. ");
INSERT INTO nsu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Iva ik ompa noijki okitematiltijkeh in yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kan siudad de Listra okatka se tlakatl tlen amo ovelia onejnemia. Okatka koxo desde oneski. Yejón tlakatl ompa oyetoka ");
INSERT INTO nsu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","okikaktoka tlen Pablo okijtovaya. Pablo okiyekittak iva okimomakak kuenta ke yejón koxo okipiaya tlaneltokalistli para velis pajtis. ");
INSERT INTO nsu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ijkuakó Pablo okilvi chikavak: —¡Ximoyekketza! In tlakatl omoketevak iva ope nejnemi. ");
INSERT INTO nsu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ijkuak okittakeh tlen okichi in Pablo, in gentejtih de Licaonia ope tzajtzih chikavak ika de yejvah intlajtol, okijtojkeh: —¡In diosmeh ovaltemokeh kemi oyeskia tlaltikpaktlakah! ");
INSERT INTO nsu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé okitokayotijkeh dios Júpiter, ivan Pablo okitokayotijkeh dios Mercurio, porke yen otlapovaya. ");
INSERT INTO nsu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","In tiopixki de dios Júpiter, tlen okipiaya itiopa sa tlatentli de kan siudad, okinvalikak torojtih iva xochikoskameh, okinmajxitiko kan kaltentli de kan siudad. In tiopixki iva nochtin gentejtih okinekiah kinmavistiliskeh in Pablo ivan Bernabé iva okinekiah kinmiktiliskeh torojtih para kinmakaskeh kemi se tlamanali. ");
INSERT INTO nsu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero ijkuak in Pablo ivan Bernabé okimomakakeh kuenta tlen okinekiah kichivaskeh, omotzotzoltzomonijkeh iva okalakeh intzala in gentejtih, tzajtzitivih chikavak: ");
INSERT INTO nsu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Tatanmeh! ¿Tleka ijkó inkichivah? Tejvah noijki titlaltikpaktlakah kemi imejvah. Tejvah otivalajkeh otimechilvikoh ke moneki inkikavaskeh tlen amitla ipati iva ximokuapakah inavak toYejwatzi Dios tlen yolitok. Ye okichi in ilvikak, in tlaltikpaktli, in atl iva nochi tlen intech onka. ");
INSERT INTO nsu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yi wejkavitl in toYejwatzi okinkavili in gentejtih ma kichivakah san tlen yejvah okinekiah. ");
INSERT INTO nsu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero, Ye nochipa okinmititiaya akin Ye, ika tlen kuali tlen okichivaya por yejvah. Ye kichiva ma kiavi iva ma tlatlaki, para ijkó nochtin ma kipiakah tlán kikuaskeh iva ma yekah ika pakilistli. ");
INSERT INTO nsu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pablo ivan Bernabé ijkó okijtojkeh, pero ovi para okintlakavaltijkeh in gentejtih, para amo ma kinmiktilikah in torojtih para kinmakaskeh kemi tlamanali. ");
INSERT INTO nsu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ijkuakó oajsikoh sekimeh judiojtih de Antioquía iva de Iconio, iva okintlatlalvijkeh in gentejtih de Listra iva okimagakeh in Pablo ika tetl. Yejvah okiyejyekojkeh yokimiktijkeh, iva okitilantiajkeh ipan tlali okikixtijkeh asta tlatentli de kan siudad. ");
INSERT INTO nsu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero in tlaneltokakeh okiyavalojkeh in Pablo, ye omoketzki iva okalakki oksejpa kan siudad. Omostlatik Pablo ivan Bernabé okiskeh de ompa iva oyajkeh para Derbe. ");
INSERT INTO nsu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ompa kan siudad de Derbe okitematiltijkeh in yankuik kuali tlajtoli iva miekeh ope kitokah iojviv in Jesús. Satepa omokuapkeh oksejpa para Listra, Iconio iva Antioquía. ");
INSERT INTO nsu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Itech yejonmeh siudades okinyolchikajkeh in tlaneltokakeh, okinmilvijkeh ma moyekketokah itech intlaneltokalis. Noijki okinmilvijkeh ke para se kalakis kan Dios tlanavatia kipia tlen se tlajyovis miek. ");
INSERT INTO nsu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pablo ivan Bernabé okintlalijkeh sekimeh tlayakankeh itech kada lugar kan omololovayah in tlaneltokakeh. Satepa de omodiostzajtzilijkeh iva omosavkeh, okintlalijkeh ipan imatzin toTeko, tlen inavak otlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Satepa Pablo ivan Bernabé opanokeh ik región de Pisidia iva oajsitoh kan región de Panfilia. ");
INSERT INTO nsu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Otetlapovijkeh de itlajtol in Dios kan siudad de Perge iva para ompa oyajkeh kan siudad de Atalia. ");
INSERT INTO nsu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ompa Atalia otlejkokeh itech barko iva oyajkeh para Antioquía de Siria, kan antes in tlaneltokakeh okitlatlavtijkeh in Dios ma kinpalevi in Pablo ivan Bernabé itech intekiv tlen axka yokitlamijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ijkuak oajsitoh Antioquía, okinmololojkeh in tlaneltokakeh iva okinmilvijkeh nochi tlen Dios okichi invah, iva kenik in Dios yokintlapoli puerta tlen amo judiojtih para ke yejvah noijki ma kineltokakah. ");
INSERT INTO nsu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo ivan Bernabé ompa omokajkeh miek tonali invan tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Itech yejonmeh tonaltih, sekimeh tlen de Judea oajsitoh Antioquía iva ope kinmachtiah in tlaneltokakeh tlen amo judiojtih, okinmilviayah ke para velis momakixtiskeh kipia de mosirkunsidaroskeh ijkó kemi kijtova itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pero Pablo ivan Bernabé chikavak omotlatlajtolnamikeh invah. Por eso in tlaneltokakeh de Antioquía okinmilvijkeh in Pablo, in Bernabé ivan oksekimeh tlaneltokakeh ma viah Jerusalén, ma kiyektlalitih yejón tlamantli innavak in tiotlatitlaniltih iva innavak in tlayakankeh tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","In tlaneltokakeh de Antioquía okintitlankeh ma viah. Iva ijkuak oyajkeh, opanokeh ik región de Fenicia iva de Samaria, okintlajpalojtiajkeh in tlaneltokakeh. Okinmatiltijkeh ke tlen amo judiojtih yomokuapkeh inavak Dios. Iva nochtin toknivah sa tlawel opakiah ijkuak ijkó okikakiah. ");
INSERT INTO nsu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ijkuak Pablo ivan Bernabé oajsitoh Jerusalén, in tlaneltokakeh ivan tiotlatitlaniltih ivan tlayakankeh tlaneltokakeh okinselijkeh. Pablo ivan Bernabé okintlapovijkeh nochi tlen Dios okichi innavak. ");
INSERT INTO nsu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero sekimeh tlaneltokakeh tlen achto opoviah invan fariseos, omoketzkeh iva okijtojkeh: —Kipia de mosirkunsidaroskeh in tlaneltokakeh tlen amo judiojtih, iva kipia de kichivaskeh tlen kijtova itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ijkuakó omololojkeh in tiotlatitlaniltih ivan tlayakankeh tlaneltokakeh para moyektlapoviskeh de yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Satepa de omotlatlajtolnamikeh miek, Pedro omoketzki iva okinmilvi: —Noknivah, imejvah inkimatih ke yi kipia tiempo in toYejwatzi onechpejpenki de entre imejvah, para nikintlapovis tlen amo judiojtih de tlen yankuik kuali tlajtoli, para ijkó yejvah ma kikakikah ivan ma kineltokakah. ");
INSERT INTO nsu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ToYejwatzi tlen techixmati itech toyolo, techititia ke noijki kinselia tlen amo judiojtih porke okinmakak in Tioijyotzintli ijkó kemi tejvah noijki otechmakak. ");
INSERT INTO nsu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ToYejwatzi techselia tinochtin iva amo san sekimeh, porke yejvah noijki yokinyolchipa ijkuak otlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Axka imejvah inkinekih inkinavatiskeh in toYejwatzi? Imejvah inkinmakah se tlamamali tlen amo judiojtih, tlen nion tokojkolvah iva nion tejvah amo tivelih tikmamah. ");
INSERT INTO nsu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tejvah tikneltokah ke toTeko Jesús techmakixtia ika iiknomachilis, ijkó kemi yejvah noijki kinmakixtia ika iiknomachilis. ");
INSERT INTO nsu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nochtin sa otlakaktokah. Iva noijki okikakkeh tlen Pablo ivan Bernabé okijtovayah de yen neskayomeh iva nexkuitiltih tlen Dios okinchi por medio de yejvah innavak tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ijkuak otlanki otlapojkeh in Pablo ivan Bernabé, Jacobo okijto: —Noknivah, techkakikah. ");
INSERT INTO nsu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro otechtlapovi kenik in toYejwatzi, desde achto, kuali okintrataro tlen amo judiojtih, iva okinpejpenki para ke yejvah noijki ma povikah kemi iaxkavah. ");
INSERT INTO nsu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Noijki ijkó okijtojkeh in tiotenejmachtijkeh, kemi kajki ijkuilitok: ");
INSERT INTO nsu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Satepa de nin, nivalmokuapas. Nikyektlalis itlanavatijkayo in David kemi oyeskia se kali tlen yovetzki. Nikyektlalis tlen yovetzki, iva oksejpa niketzaltis. ");
INSERT INTO nsu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Para ijkó nochtin tlen oksekimeh tlaltikpaktlakah ma kitemokah in toTeko, nochtin tlen amo judiojtih tlen onikinnotzki ma povikah nova. ");
INSERT INTO nsu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ijkó kijtova in toTeko, iva asta yi wejkavitl ipa ijkó yokitematiltijka nin tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Por eso, ne nikijtova, ke amo moneki tikinkuejsoskeh tlen amo judiojtih tlen yomokuapkeh inavak toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","San se kintlajkuililis para amo ma kikuakah itla tlamanali tlen kinmaniliah in diosmeh tlen tlamachivaltih, amo ma avilnemikah itech tlajtlakoli, amo ma kikuakah nakatl de yolkameh tlen san kinkechpatzkah, iva nion amo ma kikuakah estli. ");
INSERT INTO nsu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porke desde yi wejkavitl itech nochtin altepemeh kateh tlen akinmeh tetlapoviah de itlanavatil Moisés, iva nochi sábado kilerovah kan tiotlamachtijkaltih. ");
INSERT INTO nsu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","In tiotlatitlaniltih ivan tlen tlayakankeh tlaneltokakeh, iva nochtin tlen tlaneltokakeh, okijtojkeh kinpejpenaskeh sekimeh de yejvah para ma viah ivan Pablo ivan Bernabé para Antioquía. Okipejpenkeh in Judas tlen okinotzayah Barsabás, ivan Silas, ninmeh omeh okatkah tlayakankeh de tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yejvah okivikakeh in amatlajkuiloli, tlen ijkí okijtovaya: “Tejvah titiotlatitlaniltih ivan tlayakankeh tlaneltokakeh ivan toknivah de Jerusalén, timechontlajkuililiah iva timechontlajpalovah imejvah intlaneltokakeh tlen amo injudiojtih tlen inchantih Antioquía, Siria iva Cilicia. ");
INSERT INTO nsu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Otikmatkeh ke sekimeh de nika oyajkeh ompa inmonavak tlen tejvah amo otikintitlankeh. Yejvah omechpajsolotoh ika intlajtol iva axka imejvah amo inkimatih tlán inkichivaskeh. Omechilvitoh ke moneki ximosirkunsidarokah iva xikvelkakikah itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Por eso, tinochtin otimotlalijkeh de akuerdo iva otikinpejpenkeh sekimeh toknivah para ma viah ma imechitatih san sekka invan totlasojkaiknivah Pablo ivan Bernabé. ");
INSERT INTO nsu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pablo ivan Bernabé yokitlalijkeh innemilis maski san tlán ma kinpano por yen toTeko Jesucristo. ");
INSERT INTO nsu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Por eso timechintitlaniliah in Judas ivan Silas, yejvah imechilviskeh noijki de tlan tejvah nika otimotlapovijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","In Tioijyotzintli iva tejvah noijki tikittah ke amo moneki timechmakaskeh itla oksé tlamamali para xikchivakah, sino solamente ");
INSERT INTO nsu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","amo xikuakah itla tlen kinmaniliah in diosmeh tlen tlamachivaltih. Amo xikuakah estli iva nakatl de yolkameh tlen san kinkechpatzkah. Amo xiavilnemikah itech tlajtlakoli. Tla inkichivaskeh tlen timechilviah, kijtosneki inkichivah tlen kuali. Kuali xonyekah.” ");
INSERT INTO nsu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Satepa, Pablo, Bernabé, Judas ivan Silas oyajkeh para Antioquía. Iva ompa Antioquía okinmololojkeh nochtin toknivah tlaneltokakeh iva okinmaktilijkeh in amatlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ijkuak in toknivah okilerojkeh, sa tlawel opakeh por tlen okijtovaya in amatlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iva komo Judas ivan Silas noijki okatkah tiotenejmachtijkeh, ika miek tlajtoli okinyolchikajkeh in tlaneltokakeh para ma moyekketzakah itech intlaneltokalis. ");
INSERT INTO nsu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Judas ivan Silas opanokeh ompa Antioquía kana keski tonali. Iva ijkuak okijtojkeh mokuapaskeh oksemi para Jerusalén innavak toknivah tlen okintitlankeh, tonses okinmakajkeh iva okinmilvijkeh ma viah ika kuali. ");
INSERT INTO nsu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero Silas okijto mokavas ompa Antioquía. ");
INSERT INTO nsu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo ivan Bernabé noijki omokajkeh ompa Antioquía. Yejvah iva miekeh oksekimeh tlaneltokakeh otlamachtiayah de itlajtol toTeko iva okitematiltiayah tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Keski tonali satepa, Pablo okilvi in Bernabé: —Oksemi ma tiviah ma tikintlajpalotih in toknivah itech nochtin in siudades kan otiktematiltijkeh itlajtol in toTeko, para tikmatiskeh kox kuali kateh. ");
INSERT INTO nsu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé okinekia kivikas in Juan tlen noijki okinotzayah Marcos, ");
INSERT INTO nsu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pero Pablo amo okinekki ma kivikakah porke achto okinkajte kan región de Panfilia iva ayakmo okinekki ok tekipanos invah. ");
INSERT INTO nsu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iva komo amo ovelik omotlajtolajsikeh, okachi kuali omotlajkoxelojkeh. Bernabé okivikak in Juan Marcos, otlejkokeh itech se barko iva oyajkeh para Chipre. ");
INSERT INTO nsu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo okipejpenki in Silas para ma kivika. In tlaneltokakeh de Antioquía omodiostzajtzilijkeh para Dios ma kinpalevi, iva satepa oyajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Opanokeh ik región de Siria iva ik región de Cilicia. Okinyolchikajtiayah in toknivah tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo ivan Silas oajsitoh kan siudad de Derbe iva kan siudad de Listra, ompa okajsitoh se tlaneltokak itoka Timoteo, itelpoch de se sivatl tlaneltokak judía iva ipapa griego. ");
INSERT INTO nsu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","In toknivah de Listra iva de Iconio otlajtovayah kuali de Timoteo. ");
INSERT INTO nsu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo okinekki ma kivika in Timoteo, pero achto okisirkunsidaro porke in judiojtih de neká región okimatiah ke ipapa in Timoteo ye griego. ");
INSERT INTO nsu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Itech nochtin altepemeh kanik yejvah opanotiayah, okinmatiltijkeh in tlaneltokakeh aserka de tlen omotlapovijkeh in tiotlatitlaniltih ivan tlayakankeh tlaneltokakeh de Jerusalén, para yejón ma kichivakah. ");
INSERT INTO nsu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","In tlaneltokakeh omochikavayah okachi itech intlaneltokalis, iva momostla omomiekiliayah in tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Komo in Tioijyotzintli amo okinkavili ma tetlapovikah de itlajtol in Dios itech tlali de Asia, Pablo iva tlen ivan okatkah opanokeh ik región de Frigia iva ik región de Galacia, ");
INSERT INTO nsu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","iva oajsitoh kan monamiktokeh in tlalmeh de Misia iva de Bitinia. Satepa okijtojkeh yaskeh kan tlali de Bitinia, pero iTioijyotzi in Jesús amo okinkavili. ");
INSERT INTO nsu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ijkó, san opanokeh ik tlali de Misia, iva oajsitoh kan siudad de Troas. ");
INSERT INTO nsu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yejón yovak, Pablo okittak se tetzavistlachialistli, okittak se tlakatl de Macedonia omoketoka iyakapa iva okitlatlavtiaya: “Xipano ik Macedonia iva techpalevi.” ");
INSERT INTO nsu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ijkuak Pablo okittak yejón tetzavistlachialistli, san nima otimotlayektlalilijkeh para tiaskeh Macedonia. Kuali otikmatiah nik toYejwatzi otechnotoka para ompa ma tiktematiltitih de tlen yankuik kuali tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Otikiskeh de Troas itech se barko, iva otiajkeh melajka kan tlali de Samotracia tlen yavalitok de atl tlen wei. Omostlatik otiajkeh para Neápolis. ");
INSERT INTO nsu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iva de ompa otiajkeh para Filipos, se siudad weititok tlen kajki itech tlali de Macedonia, kan chantih miekeh romanos. Iva ompa otimokajkeh kana keski tonali. ");
INSERT INTO nsu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Se sábado, otikiskeh de kan siudad, iva otiajkeh itempan weyatl. Otikyejyekojkeh xamo ik ompa mololovah in judiojtih para modiostzajtziliah. Sekimeh sivameh ompa oololitokah, ompa otimotlalijkeh iva ope tikintlapoviah. ");
INSERT INTO nsu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Se de yejonmeh sivameh itoka Lidia. Yejón sivatl okatka de Tiatira iva okatka tzotzolnemakak de tlen kuali tzotzoli morado, iva okimavistiliaya in toYejwatzi. Ompa otlakaktoka, iva in toTeko okiyoltlapo para kuali ma kikaki tlen Pablo okijtovaya. ");
INSERT INTO nsu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ye ivan nochi ifamilia omobautisarojkeh. Iva satepa Lidia otechtlatlavti, otechilvi: —Tla imejvah inkiyejyekovah nik yi neli nitlaneltokak inavak toTeko, tonses ximokavakah nokalijtik. Sa tlawel otechtlatlavti, iva ompa otimokajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Se welta ijkuak otiayah kan modiostzajtziliah, otiknamikeh se ichpochtli tlen okipiaya se ejekatl tlen tlayejyeko. Iva ijkó itekovah okitlaniah miek tomi. ");
INSERT INTO nsu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yejón ichpochtli ope kitoka in Pablo ivan tejvah, iva okijtovaya chikavak: —Ninmeh tlakah tekipanovah para Dios tlen Weijkatlalitok, iva imechmatiltiah kenik velis inmomakixtiskeh. ");
INSERT INTO nsu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ijkó okichijtinenki miek tonali, asta kan okikuejso in Pablo, omokuapki iva okilvi in amo kuali ejekatl: —Ika itoka in Jesucristo, nimitznavatia xikisa de itech. Iva san nima ijkuakó okiski in amo kuali ejekatl. ");
INSERT INTO nsu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero ijkuak in tekovajkeh de yejón ichpochtli okittakeh ke ayakmo velis kitlaniskeh tomi por yen ichpochtli, ijkuakó okinkitzkijkeh in Pablo ivan Silas iva okinvikakeh kan tekivajkeh, kan sentro kan tiankistli. ");
INSERT INTO nsu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Iva okinteixpantitoh innavak juesmeh, iva okijtojkeh: —Ninmeh judiojtih san otlapajsolokoh itech nin siudad. ");
INSERT INTO nsu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tlamachtiah de oksé tlamantli kostumbre tlen tejvah amo velis tikseliskeh iva nion amo velis tikchivaskeh, porke tejvah tiromanos. ");
INSERT INTO nsu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","In gentejtih oyajkeh inpan Pablo ivan Silas. In juesmeh otlanavatijkeh ma kinxijxipetzokah iva ma kinvitekikah ika tlakotl. ");
INSERT INTO nsu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iva satepa de okinvitekeh miek, okintzakeh telpiloya. Iva okinavatijkeh in tetzakki kuali ma kinkuidaro. ");
INSERT INTO nsu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ijkuak ijkó okinavatijkeh in tetzakki, ye okinkalaki okintzakuato asta kan okachi tlatlaijtik de kan telpiloya, iva okinmikxitzikojkeh itech se tablón. ");
INSERT INTO nsu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pero kemi tlajko yovak, Pablo ivan Silas omodiostzajtzilijtokah iva okitlakuikilijtokah in Dios, iva oksekimeh tlen otzaktokah okinkaktokah. ");
INSERT INTO nsu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","San nima ijkuakó otlalolinki chikavak asta okitzejtzelo itlakxitlanyo in telpiloya. Nochtin ipuertajvah in telpiloya otlapovikeh. Iva okojkotonkeh in kadenajtih tlen ika oilpitokah tlen ompa otzaktokah. ");
INSERT INTO nsu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","In tetzakki oijsak iva okinmitak nochi in puertajtih tlajtlapotokeh. Ijkuakó okikixti iespada para momiktis, porke okijto yocholojkeh tlen otzaktokah. ");
INSERT INTO nsu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero Pablo okitzajtzili chikavak: —¡Amo ximomikti! Nika tikateh tinochtin. ");
INSERT INTO nsu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ijkuakó in tetzakki okitlajtlanki se tlavili, iva omotlelo ik tlatlaijtik viviokativ ika nemavtili, iva omotlankuaketzki inmikxitla in Pablo ivan Silas. ");
INSERT INTO nsu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Satepa okinkixti kiavak iva okintlajtlani: —Tatanmeh, ¿tlán moneki nikchivas para nimomakixtis? ");
INSERT INTO nsu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yejvah okinankilijkeh: —Xikneltoka in toTeko Jesús, iva velis timomakixtis te ivan nochtin tlen kateh mokalijtik. ");
INSERT INTO nsu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iva okintlapovijkeh de itlajtol in toTeko in tetzakki iva nochtin tlen okatkah ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","San nima yejón yovak, in tetzakki okinpakili kan okinmejeskixtijkeh, iva san nima ye iva nochtin tlen de ikalijtik omobautisarojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Satepa in tetzakki okinvikak in Pablo ivan Silas ikalijtik iva okintlamakak. In tetzakki ivan ifamilia opakeh miek por otlaneltokakeh inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ijkuak otlaneski, in juesmeh okintitlankeh sekimeh mayoltih para ma kilvitih in tetzakki ma kinkajkava in Pablo ivan Silas. ");
INSERT INTO nsu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","In tetzakki okilvi in Pablo: —In juesmeh onechnavatijkeh ma nimechkajkava. Axka yi velis inkisaskeh iva xiviah ika kuali. ");
INSERT INTO nsu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero Pablo okinmilvi in mayoltih: —Tejvah tiromanos, iva otechvitekeh teixpa iva amo achto otechtlatzintokijkeh, iva otechtzakeh. ¿Iva axka kinekih techkajkavaskeh san ichtaka? ¡Amo! Ma vikikah yejvah innevia ma techkixtikih. ");
INSERT INTO nsu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","In mayoltih okinmatiltitoh in juesmeh. Iva in juesmeh omomavtijkeh ijkuak okimatkeh nik in Pablo ivan Silas yejvah romanos. ");
INSERT INTO nsu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tonses in juesmeh oyajkeh omotlapojpolvitoh ivan Pablo ivan Silas, okinkixtijkeh de telpiloya iva okintlatlavtijkeh ma kisakah de kan yejón siudad. ");
INSERT INTO nsu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ijkuak in Pablo ivan Silas okiskeh de telpiloya, oyajkeh para ikalijtik in Lidia. Ompa okinmitakeh in toknivah iva okinyochikajkeh, satepa okiskeh de itech yejón siudad. ");
INSERT INTO nsu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo ivan Silas satepa de opanokeh ik Anfípolis iva ik Apolonia, oajsitoh Tesalónica, kan okatka se tiotlamachtijkali de judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo oyá kan tiotlamachtijkali kan mololovah in judiojtih ijkó kemi ye okimatia okichivaya. Itech eyi sábado, Pablo invah omotlapovi aserka de tlen kijtova in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Okinyekilviaya ke in Tiotlajkuiloli kijtova nik Cristo okipiaya de ixpolivis iva noijki okipiaya de moyolitis. Okinmilvi: —Nin Jesús tlen ne nimechtlapovia, yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sekimeh judiojtih otlaneltokakeh iva omosetilijkeh ivan Pablo ivan Silas. Noijki otlaneltokakeh miekeh griegojtih tlen yi neli omotemaktiayah inavak Dios, iva noijki otlaneltokakeh miekeh sivameh tlen wejweititokeh de yejón siudad. Nochtin yejvah noijki omosetilijkeh ivan Pablo ivan Silas. ");
INSERT INTO nsu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero in judiojtih tlen amo otlaneltokakeh, omoxikojkeh miek, iva okintlatlalvijkeh sekimeh tlakah tlatzivkeh tlen san onentinemiah itech ojtli iva tlen amo kuali inyelis. Okichijkeh se olololistli iva okinpajsolojkeh in gentejtih de yejón siudad. Oyajkeh melajka kan ikalijtik in Jasón, okintemotoh in Pablo ivan Silas, para kinkixtiskeh iva kintemaktiskeh inmak in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero komo amo okinmajsitoh, tonses okinvikakeh a fuersa in Jasón ivan oksekimeh toknivah. Okinvikakeh kan tekivajkeh de yejón siudad, tzajtzitivih chikavak: —¡Ninmeh tlakah san kitemovah tlajtoli sentetl ik novian iva axka nika yovalajkeh! ");
INSERT INTO nsu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Jasón okinkaloti ikalijtik! Iva kichivah nochi tlen kajki en kontra de tlen kijtova itlanavatil in towei tekiva César. Yejvah kijtovah ke onka oksé wei tlanavati, itoka Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ijkuak ijkó okikakkeh, omopajsolojkeh in gentejtih ivan tekivajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pero Jasón ivan oksekimeh toknivah okitlaxtlajkeh para okinkajkajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","San nima yejón yovak in toknivah okintitlankeh in Pablo ivan Silas ma viah para Berea. Ijkuak oajsitoh, oyajkeh kan tiotlamachtijkali de judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","In judiojtih de Berea okipiayah okachi kuali inyelis iva amo kemi in judiojtih de Tesalónica, iva ika pakilistli okiselijkeh itlajtol in Dios. Nochipa okimomachtiayah in Tiotlajkuiloli para kittaskeh kox yi neli tlen Pablo ivan Silas okinmilviayah. ");
INSERT INTO nsu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Iva ijkó, miekeh judiojtih otlaneltokakeh. Noijki otlaneltokakeh miekeh griegojtih, tanto tlakah tanto sivameh tlen okachi wejweititokeh. ");
INSERT INTO nsu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero ijkuak in judiojtih de Tesalónica okimatkeh nik in Pablo otetlapovijtoka de itlajtol in Dios noijki kan siudad de Berea, oyajkeh para ompa, iva okinpajsolotoh in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pero in toknivah san nima okititlankeh in Pablo ma via asta kan atl tlen wei, pero in Silas ivan Timoteo omokajkeh ompa Berea. ");
INSERT INTO nsu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tlen okivikayah in Pablo okikajkavatoh asta kan siudad de Atenas, pero Pablo okinmilvi ke ijkuak mokuapaskeh para Berea ma kilvikah in Silas ivan Timoteo ma kajsitih san nima ompa Atenas. ");
INSERT INTO nsu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ijkuak Pablo okinchixtoka in Silas ivan Timoteo ompa Atenas, sa tlawel omoyolkoko porke okinmitak miekeh diosmeh tlamachivaltih itech yejón siudad. ");
INSERT INTO nsu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Por eso, kan tiotlamachtijkali invan omotlapoviaya in judiojtih iva tlen amo judiojtih tlen omotemaktiayah inavak Dios. Noijki momostla okintlapoviaya tlen omololovayah kan tiankistli. ");
INSERT INTO nsu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sekimeh ixtlamatkeh tlen kintokayotiah epicúreos iva tlen estoicos, ope motlatlajtolnamikih ivan Pablo. Sekimeh okijtovayah: —¿Tlán kineki techilvis nin tlen wel tlapova? Iva oksekimeh okijtovayah: —Nesi tlapova de oksekimeh diosmeh. Ijkó okijtovayah porke Pablo okintlapoviaya de Jesús iva de moyolitilistli. ");
INSERT INTO nsu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ijkuakó okivikakeh in Pablo kan Areópago, kan kichivah junta itech yejón siudad, iva okitlajtlanijkeh: —¿Velis tikmatiskeh tlán kijtosneki nin yankuik tlamachtili tlen titlapova? ");
INSERT INTO nsu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Porke te techtlapovia tlen tejvah amo keman tikkakih, iva tiknekih tikmatiskeh tlán kijtosneki nochi yejón. ");
INSERT INTO nsu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ijkó okijtojkeh porke nochtin tlen de Atenas iva tlen amo de Atenas tlen ompa chantih, amitla oksé tlamantli okichivayah, sino san yen okikakiah iva omotlapoviayah de itla tlamantli yankuik. ");
INSERT INTO nsu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ijkuakó Pablo omoketzki tlatlajko kan Areópago, iva okijto: —Tatanmeh de Atenas, nikitta ke imejvah sa tlawel inkintlakitah inmodiosvah. ");
INSERT INTO nsu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mientras nitlajtlachixtinemi itech nin siudad, onikinmittak miekeh tlamantih tlen imejvah inkinmavistiliah, iva asta onikittak se artal tlen itech ijkuilitok: “Dios tlen amika kixmati”. Iva axka, in Dios tlen imejvah inkimavistiliah iva amo inkixmatih, de yejón Dios tlen ne nikneki nimechtlapovis. ");
INSERT INTO nsu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’In toYejwatzi Dios tlen okichi in tlaltikpaktli iva nochi tlen itech onka, yen Tekova iaxka in ilvikak ivan tlaltikpaktli. Amo chanti itech tiopanmeh tlen kinchivah in tlaltikpaktlakah, ");
INSERT INTO nsu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nion amo moneki íkka ma kipalevi. Porke Ye techmaka tonemilis, toijyoyo iva nochi tlen tiknejnekih. ");
INSERT INTO nsu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’San itech se tlakatl, toYejwatzi Dios okinchi nochtin in tlaltikpaktlakah para ma chantikah sentetl itech nin tlaltikpaktli, iva Ye okijto kanin chantiskeh iva kemania yeskeh. ");
INSERT INTO nsu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","In toYejwatzi ijkó okichi para ke nochtin tlaltikpaktlakah ma kitemokah, maski san ma kimatemokah mixevia velis kajsiskeh. Pero tlen yi neli, in toYejwatzi amo kajki wejka de kada se de tejvah. ");
INSERT INTO nsu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porke ika ivelitilis in toYejwatzi tiyolitokeh, timoliniah iva tikateh. Ijkó kemi sekimeh de imejvah tlen tlayejyekolejkeh tlajkuilojkeh, okijtojkeh: “Tejvah titepilvah de Dios.” ");
INSERT INTO nsu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tonses, tla tejvah titepilvah de Dios, amo ma tikyejyekokah ke Ye tlachivali de oro, de plata o noso de tetl kemi kinchivah in tlaltikpaktlakah, iva kiyejyekovah ke Dios ijkó nik kajki. ");
INSERT INTO nsu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yi wejkavitl in toYejwatzi Dios amo okinchivili kuenta intlajtlakol in tlaltikpaktlakah, porke amo okimatiah tlan okichivayah, pero axka kinnavatia nochtin tlaktikpaktlakah, ma moyolkopakah. ");
INSERT INTO nsu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porke toYejwatzi yokitlali se tonali ijkuak Ye kijtos akinmeh tlajtlakolejkeh iva akinmeh amo, iva kichivas kemi moneki. ToYejwatzi ijkó kichivas por medio de Jesús tlen Ye yokipejpenki. ToYejwatzi yotechititi nik ijkó kichivas ijkuak okiyoliti in Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ijkuak okikakkeh ke Jesús oixpolivik iva omoyoliti, sekimeh san okivevetzkilijkeh, iva oksekimeh okijtojkeh: —Okachi kuali oksé tonali techtlapovis. ");
INSERT INTO nsu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ijkuakó Pablo okiski de ompa kan ololitokah. ");
INSERT INTO nsu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero sekimeh otlaneltokakeh inavak toTeko iva oyajkeh ivan Pablo. Se de yejvah tlen otlaneltokak itoka Dionisio tlen povi kan Areópago, iva noijki otlaneltokak se sivatl itoka Dámaris, iva noijki otlaneltokakeh oksekimeh. ");
INSERT INTO nsu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Satepa, Pablo okiski de Atenas iva oyá para kan siudad de Corinto. ");
INSERT INTO nsu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ompa okixmatki se judío itoka Aquila, de región de Ponto. Ijkuakó ayamo wejkava, Aquila ivan itonana Priscila ovalajkeh de Italia, porke Claudio tlen wei tekiva de Roma, otlanavati ma kinkixtikah nochtin judiojtih de itech yejón siudad de Roma. Pablo oyá okintlajpaloto, ");
INSERT INTO nsu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","iva komo okimatia okichivaya in tekitl kemi yejvah, invah omoka iva invah otekipanovaya, okinchivayah mantajkaltih. ");
INSERT INTO nsu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Iva nochi sábado, Pablo oyaya kan tiotlamachtijkali iva okintlapoviaya in judiojtih ivan griegojtih, Pablo okinekia ma tlaneltokakah inavak Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ijkuak Silas ivan Timoteo oajsikoh de Macedonia, Pablo okika itekiv iva sa okixkavi tetlapovia de itlajtol in Dios, iva okinmilviaya in judiojtih ke Jesús yen Cristo tlen temakixti. ");
INSERT INTO nsu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero in judiojtih amo okinpakti tlen Pablo okinmachtiaya iva ope kivikaltiah. Pablo omotlakentzejtzelo kemi se señas ke amo okiselijkeh itlajtol in Dios, iva okinmilvi: —Imejvah inmotlajtlakol tla amo inmomakixtiskeh, ayakmo ne notlajtlakol. De axka para tlayakapa ne nikintlapovis de itlajtol in toYejwatzi tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pablo okiski de ompa iva oyá kan ikalijtik se tlakatl itoka Ticio Justo, tlen okimavistiliaya in Dios iva ochantia inakastlan tiotlamachtijkali. ");
INSERT INTO nsu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispo tlen tlayakanki de kan tiotlamachtijkali, ye ivan nochi ifamilia otlaneltokakeh inavak toTeko. Noijki miek gente de Corinto, ijkuak okikakkeh itlajtol in Dios, otlaneltokakeh iva omobautisarojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Se yovak in toTeko okilvi in Pablo itech se tetzavistlachialistli: —Amo ximomavti, xitetlapovi de notlajtol, amo san ximokava. ");
INSERT INTO nsu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Porke Ne mova nika iva amika velis itla mitztoktis. Porke itech nin siudad kateh miekeh gentejtih tlen noaxkavah. ");
INSERT INTO nsu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tonses, Pablo omoka ompa Corinto se xivitl ivan tlajko, okinmachtiaya de itlajtol in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pero ijkuak Galión okatka kobernador itech estado de Acaya, sekimeh judiojtih omololojkeh iva ipan oyajkeh in Pablo, okitzkijkeh iva okivikakeh kan teyekankavah. ");
INSERT INTO nsu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Iva okilvijkeh in kobernador: —Nin tlakatl kintlaneltokitia in gentejtih para ma kimavistilikah in Dios ika oksé tlamantli iva amo kemi kijtova in tlanavatili. ");
INSERT INTO nsu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo yi mero otlajtoskia, pero ijkuakó Galión okinmilvi in judiojtih: —Tla onkiteilviskiah nin tlakatl por okichi itla amo kuali o noso por otemikti, tonses yi neli onimechkakiliskia imejvah tlen injudiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tla san por yen tlen ik tlamachtia nin tlakatl tlen ika inmokualaniah, san por seki tlajtoli iva seki tokayotl iva de imotlanavatil, ompa imejvah xikittakah, ne mach nikneki nimokalakis inmovah. ");
INSERT INTO nsu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iva Galión otlanavati ma kinkixtikah nochtin de kan teyekankavah. ");
INSERT INTO nsu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ijkuakó nochtin okitzkijkeh in Sóstenes tlen tlayakanki de kan tiotlamachtijkali, okimagakeh ompa teixpa kan teyekankavah. Pero in kobernador Galión amo okinchi kuenta. ");
INSERT INTO nsu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo ok omoka Corinto miek tonali. Oajsik tonali invah omomaka in toknivah iva oyá para kan región de Siria. Priscila ivan Aquila noijki oyajkeh ivan Pablo. Pero ijkuak ok okatkah kan altepetl de Cencrea, Pablo omopelonxinki porke ik okitlali kichivas se tlamantli inavak Dios. ");
INSERT INTO nsu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ijkuak oajsitoh kan siudad de Éfeso, Pablo okinkajte in Priscila ivan Aquila iva ye oyá kan tiotlamachtijkali, iva ompa omotlapovi invan judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yejvah okilviayah ma mokava kana keski tonali invah, pero ye amo okinekki. ");
INSERT INTO nsu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ijkuak yonnevaya, okinmilvi: —Tla Dios kineki, oksemi nimechitaki. Satepa otlejkok itech se barko iva okiski de Éfeso. ");
INSERT INTO nsu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Satepa oajsito kan siudad de Cesarea, ompa otemok de itech barko iva oyá para Jerusalén okintlajpaloto in tlaneltokakeh. Satepa oyá para kan siudad de Antioquía. ");
INSERT INTO nsu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ompa Antioquía omoka kana keski tonali. Satepa oksemi okiski iva oyá kan región de Galacia iva kan región de Frigia, okinyolchikajtiah nochtin tlen tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ijkuakó oajsiko kan siudad de Éfeso se judío itoka Apolos, tlen oneski Alejandría. Yi neli kuali otlapovaya iva kuali okixmatia in Tiotlajkuiloli. ");
INSERT INTO nsu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kuali omomachti itech iojviv in toTeko, iva otetlapoviaya ika nochi iyolo iva mero ijkó tlen otlamachtiaya de Jesús, pero okimatia san yen kenik se mobautisaros kemi Juan otlabautisarovaya. ");
INSERT INTO nsu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ope tetlapovia ika yolchikavalistli kan tiotlamachtijkali. Pero ijkuak Priscila ivan Aquila okikakkeh, okinotzkeh sekantzi iva okachi kuali okiyekilvijkeh de iojviv in toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ijkuak Apolos okijto yas ik región de Acaya, in toknivah de Éfeso okiyolchikajkeh pues ma via. Okintlajkuililijkeh in tlaneltokakeh de Acaya para ma kiselikah ika kuali. Ijkuak oajsito ompa, okinpalevi miek tlen otlaneltokakeh ika Dios iiknomachilis. ");
INSERT INTO nsu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Inmixpan nochtin Apolos omokitzkiaya invan judiojtih okinmilviaya nik in yejvah tlapolojtokeh iva okinmititiaya ika Tiotlajkuiloli ke Jesús yen Cristo. ");
INSERT INTO nsu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mientras Apolos ok okatka Corinto, Pablo opanotia itech tepeyo iva oajsito kan siudad de Éfeso, iva ompa okinmajsito sekimeh tlaneltokakeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pablo okintlajtlani: —¿Onkiselijkeh in Tioijyotzintli ijkuak ontlaneltokakeh? Yejvah okinankilijkeh: —Mach kema tikakih kox onka Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ijkuakó Pablo okintlajtlani: —Tonses, ¿tlán bautismo onkiselijkeh imejvah? Yejvah otlanankilijkeh: —In bautismo ijkó kemi otlamachti in Juan tlen tlabautisaro. ");
INSERT INTO nsu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo okinmilvi: —Juan okinbautisarovaya in gentejtih tlen omoyolkopayah. Pero noijki okinmilvi kipia tlen tlaneltokaskeh inavak Jesús tlen Cristo, tlen ovalaskia satepa de Juan. ");
INSERT INTO nsu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ijkuak ijkó okikakkeh, omobautisarojkeh ika itoka in toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Iva ijkuak Pablo okintlali imavah inpa, in Tioijyotzintli ovala inpa, iva ope tlapovah ika oksekimeh tlajtoltih, iva ope kijtovah tlen Dios okinmilviaya ma kijtokah. ");
INSERT INTO nsu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Por nochtin okatkah kemi majtlaktli ivan ome tlakah. ");
INSERT INTO nsu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo oyaya kan tiotlamachtijkali kana eyi metztli, ompa okintlapoviaya ika yolchikavalistli. Okintlapoviaya iva okinekia ma kineltokakah de kenik tlanavatia in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero sekimeh oyoltlakuavakeh iva amo okinekeh otlaneltokakeh, iva teixpa otlajtovayah fiero de iojviv in Dios. Tonses Pablo ompa okinkajte, iva okinvikak in tlaneltokakeh kan itlamachtijkal se tlakatl itoka Tirano. Pablo ompa okintlapoviaya nochi tonali. ");
INSERT INTO nsu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ijkó okichi kemi ome xivitl. Iva ijkó nochtin tlen ochantiah itech región de Asia, judiojtih iva tlen amo judiojtih, okikakkeh itlajtol in toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios okinejneki in Pablo para okinchi wejwei tetzavimeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Asta in panitojtih ivan mantiltih tlen Pablo yokinnejneki, okinvikiliayah in kokoxkeh iva opajtiah, iva in amo kuali ejekameh okisayah de intech. ");
INSERT INTO nsu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pero sekimeh judiojtih onemiah kalpa tlen okinkixtiayah amo kuali ejekameh, noijki okinekiah kinkixtiskeh in amo kuali ejekameh ika itoka in toTeko Jesús. Okinmilviayah in ejekameh: —¡Timechnavatiah xikisakah ika itoka in Jesús, de tlen Pablo tetlapovia! ");
INSERT INTO nsu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ijkó okichivayah tlen chikome itelpochvah in Esceva, se tiopixki tlayakanki judío. ");
INSERT INTO nsu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero in amo kuali ejekatl okinnankili: —Nikixmati in Jesús, iva nikmati akin Pablo, pero imejvah, ¿inmakinmeh? ");
INSERT INTO nsu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","San nima ijkuakó, in tlakatl tlen okipiaya amo kuali ejekatl inpa oajkotzikuinki iva sa tlawel okinmagak asta okinkojko iva okikistevakeh de kan kalijtik, sa xijxipetzikeh iva sa ejeskistivih. ");
INSERT INTO nsu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nochtin tlen ochantiah Éfeso, judiojtih iva tlen amo judiojtih, ijkuak okimatkeh, sa tlawel omomavtijkeh. Iva nochtin ope kitlakitah itoka in toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Noijki miekeh tlen otlaneltokakeh okimokuitijkeh teixpa nochi tlen amo kuali tlen tlan okichijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Iva miekeh tlen okatkah tetlajchivijkeh okinvalikakeh inlibrojvah de tetlajchivilistli iva okinchichinojkeh inmixpa nochtin gentejtih. Iva ijkuak okichijkeh kuenta por nochi tlen ipati in librojtih, okiski kemi cincuenta mil tomi de plata. ");
INSERT INTO nsu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ijkó pues, itlajtol in toTeko oxitinia okachi, iva okachi miekeh okineltokayah, porke okittayah nik okipiaya velitilistli. ");
INSERT INTO nsu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Satepa de yejón, Pablo okijto yas kan región de Macedonia iva kan región de Acaya, iva satepa ajsiti asta Jerusalén. Iva noijki okijto, ke satepa de yas Jerusalén, noijki moneki yas para Roma. ");
INSERT INTO nsu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tonses, Timoteo ivan Erasto tlen okipaleviayah, okintitlanki para región de Macedonia, iva ye ok omoka kana keski tonali itech región de Asia. ");
INSERT INTO nsu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Itech nekateh tonaltih tlen chantih Éfeso sa tlawel omopajsolojkeh por yen iOjviv in Cristo. ");
INSERT INTO nsu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Okatka se tlakatl itoka Demetrio tlen okitekipanovaya plata. Ye okinchivaya ika plata itiopantzitzivah in diosa Diana, iva tlen ivan otekipanovayah kuali okitlaniah. ");
INSERT INTO nsu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio okinmololo itlakevalvah iva oksekimeh tlen noijki otekipanovayah kemi ye, iva okinmilvi: —Tatanmeh, imejvah kuali inkimatih ke tiktlanih miek tomi itech nin tekitl. ");
INSERT INTO nsu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pero imejvah yonkikakeh iva yonkittakeh, Pablo kijtojtinemi ke in diosmeh tlen kinchivah in tlaltikpaktlakah mach yi neli diosmeh, iva miekeh gentejtih yokintlaneltokiti. Amo san nika Éfeso sino noijki itech nochi in región de Asia. ");
INSERT INTO nsu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iva in gentejtih velis pevas kittaskeh in totekiv kemi amo kuali. Noijki in tiopa de todiosa Diana kittaskeh kemi ayakmitla ipati. Iva ayakmika kimavistilis in todiosa tlen kimavistiliah itech nochi in tlali de Asia iva itech nochi in tlaltikpaktli. ");
INSERT INTO nsu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ijkuak ijkó okikakkeh, sa tlawel okualankeh iva otzajtzikeh chikavak: —¡Viva todiosa Diana! ¡Todiosa de Éfeso! ");
INSERT INTO nsu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ijkuakó nochi in gente de yejón siudad omokuejsojkeh. Okinkitzkijkeh in Gayo ivan Aristarco, ome tlakah de región de Macedonia ikompañerojvah in Pablo, iva okintilantiajkeh asta kan teatro kan omololovayah in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo okinekia kalakis ompa para kintlapovis in gentejtih, pero in tlaneltokakeh amo okikavilijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Sekimeh tekivajkeh de ompa Asia, tlen invah omovikaya in Pablo, otlatitlankeh ma kilvitih amo ma kalaki ompa kan teatro. ");
INSERT INTO nsu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Sekimeh okijtovayah se tlamantli iva oksekimeh oksé tlamantli. Ayakmo okimokakiliayah de tlán omotlapoviayah, iva miekeh nion amo okimatiah de tleka ompa okatkah. ");
INSERT INTO nsu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pero sekimeh judiojtih okitopejkeh in Alejandro tlayakapa para ma kintlapovi. Tonses, Alejandro okinchivili señas ika ima para ayakmo ma tzajtzikah para velis kintlajtolpalevis in judiojtih inmixpan gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero ijkuak in gentejtih okimomakakeh kuenta ke Alejandro ye judío, nochtin otzajtzikeh chikavak kemi ome ora: —¡Viva todiosa Diana! ¡Todiosa de Éfeso! ");
INSERT INTO nsu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ijkuak in amatlajkuilo de yejón siudad ovelik okintlakavalti in gentejtih, okinmilvi: —Tatanmeh de Éfeso, nochtin kimatih ke tosiudad de Éfeso kikuidarovah in tiopa de towei diosa Diana, iva itlaixkopinkayo de tetl tlen ovetziko de ilvikak. ");
INSERT INTO nsu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iva amika velis kijtos ke amo neli. Moneki ximotlakavaltikah iva kuali xikyejyekokah antes de itla inkichivaskeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Porke ninmeh tlakah tlen imejvah nika onkinvalikakeh, amitla okichtekeh kan tiopankalijtik iva nion amo otlajtojkeh fiero de todiosa. ");
INSERT INTO nsu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tla Demetrio iva tlen ivan tekipanovah kinekih kiteilviskeh íkka, para yejón kateh juesmeh iva kan teyekankavah para ompa ma moteilvikah. ");
INSERT INTO nsu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Iva tla inkipiah itla oksé tlamantli para ik inmoyektlaliskeh, moneki inkiyektlaliskeh ijkuak mololovah in tekivajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tlen axka opanolok velis timoovijtiliskeh iva techteilviskeh ke tejvah tikinmajkuanah in gentejtih en kontra de yen wei tekiva César. Iva tla techtlajtlaniskeh tleka otimopajsolojkeh, amo tikmatiskeh tlán titlanankiliskeh. ");
INSERT INTO nsu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Satepa de otlanki otlapo in amatlajkuilo, okinmakah nochtin. ");
INSERT INTO nsu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ijkuak otlanki in pajsololistli, Pablo okinnotzki in tlaneltokakeh iva okinyolchika. Satepa invah omomaka iva oyá ik región de Macedonia. ");
INSERT INTO nsu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pablo okinyolchikajtiah nochtin toknivah itech nekateh altepemeh kanik ye opanotiaya. Iva satepa oajsito kan país de Grecia, ");
INSERT INTO nsu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","iva ompa omoka eyi metztli. Ijkuak yokatka para tlejkos itech barko para yas Siria, Pablo okimatki ke in judiojtih omotlatlalvijkeh para kimiktiskeh ijkuak yas itech barko. Ijkuakó ye okijto okachi kuali yas oksemi ik Macedonia. ");
INSERT INTO nsu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Oksekimeh toknivah oyajkeh ivan Pablo asta Asia. Oyá in Sópater de Berea, itelpoch in Pirro. Oyá in Aristarco ivan Segundo de Tesalónica. Oyá in Gayo de Derbe. Oyá in Timoteo. Iva noijki oyajkeh in Tíquico ivan Trófimo de región de Asia. ");
INSERT INTO nsu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yejonmeh toknivah otlayakankeh iva otechchiatoh asta siudad de Troas. ");
INSERT INTO nsu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ijkuak otlanki in ilvitl ijkuak mokua in pan tlen amo kipia xokotixtli, tejvah otikiskeh de Filipos iva otiajkeh itech se barko. Makuili tonali satepa otikinmajsitoh ompa kan siudad de Troas, iva ompa otimokajkeh chikome tonali. ");
INSERT INTO nsu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","In domingo otimololojkeh para tikuaskeh in tlakuali de toTeko. Pablo ope kintlapovia, iva komo yoyaskia para mostlatika, owejka okintlapovi asta tlajko yovak. ");
INSERT INTO nsu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tinochtin otikatkah itech se kuarto tlen okatka tlakpak, kan okatkah miekeh tlaviltih xotlatokeh. ");
INSERT INTO nsu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Se telpochtli itoka Eutico oyetoka kan bentana. Iva komo Pablo owejka otlapojtoka, in telpochtli okitlanki in kochilistli, iva ovetziko desde ipan eyi piso. Iva ijkuak okajkuankeh, yoixpolivik. ");
INSERT INTO nsu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablo otemotikiski, iva ipan omixiktekak in telpochtli iva okimonapalolti. Iva okijto: —Amo ximomavtikah, yolitok. ");
INSERT INTO nsu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Satepa Pablo oksemi otlejkok tlakpak. Iva nochtin san sekka okikuajkeh in tlakuali de toTeko. Pablo ok okintlapovi asta otlaneski, iva satepa oyá. ");
INSERT INTO nsu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","In telpochtli okivikakeh para ikalijtik yolitok, iva yejón okinyolchika miek. ");
INSERT INTO nsu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tejvah otitlayakankeh otiajkeh itech barko iva otajsitoh asta siudad de Asón para ompa tiknotikisah in Pablo ijkó kemi otimokajkeh, porke ye okijto yas nejnentias asta ompa. ");
INSERT INTO nsu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ijkuak otimonamikeh ivan Pablo ompa Asón, otlejkok tovah itech barko iva otiajkeh asta kan siudad de Mitilene. ");
INSERT INTO nsu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","De ompa, otiajkeh itech barko iva omostlatik otajsikeh iyakapan tlali de Quío tlen yavalitok de atl tlen wei. Ipan oksé tonali otajsitoh kan tlali de Samos tlen yavalitok de atl tlen wei. Otiajkeh oksé tonali itech barko iva otajsitoh asta Mileto. ");
INSERT INTO nsu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo okijto amo panos ik Éfeso para amo wejkavas itech región de Asia. Pablo okinekia san nima ajsiti Jerusalén tla velis, para ompa yetos itech ilvitl de Pentecostés. ");
INSERT INTO nsu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ijkuak Pablo yokatka kan siudad de Mileto, otlanavati ma kinnotzakah in tlayakankeh tlaneltokakeh de Éfeso. ");
INSERT INTO nsu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Iva ijkuak ovalajkeh, Pablo okinmilvi: —Imejvah kuali inkimatih kenik oninemia ijkuak onikatka inmovah, desde yikinika tonali ijkuak onajsiko nika itech región de Asia. ");
INSERT INTO nsu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nochipa oniktekipano noTeko ika yolyamanilistli. Miek welta onichokak. Iva onitlajyovi miek por tlen onechtoktijkeh in judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pero amo keman onika de nimechilvis nochi tlen kuali para imejvah, nochipa onimechmachti teixpa iva kan inmokalijtik. ");
INSERT INTO nsu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","In judiojtih iva tlen amo judiojtih onikinmilvi ma moyolkuapakah inavak toYejwatzi, iva ma kineltokakah in toTeko Jesucristo. ");
INSERT INTO nsu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iva axka niav Jerusalén, in Tioijyotzintli nechnavatia ma nivia, iva amo nikmati tlán nechpanos ompa. ");
INSERT INTO nsu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","San yen nikmati ke itech kada siudad kanik nipanotivitz in Tioijyotzintli nechilvijtivitz ke nechtzakuaskeh telpiloya iva nechpanos miek tlajyovilistli. ");
INSERT INTO nsu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pero nonemilis amo nechtekipachova. Tlen nechtekipachova yen niktlamis notekiv tlen toTeko Jesús onechnavati ma nikchiva, kijtosneki niktematiltis in yankuik kuali tlajtoli de iiknomachilis in toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Iva axka kuali nikmati, ke nion se de imejvah, tlen onimechtlapovi de kenik in Dios tlanavatia, ayakmo kema innechitaskeh. ");
INSERT INTO nsu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Iva nikneki nimechilvis ke ayakmo notlajtlakol tla íkka de imejvah amo momakixtis. ");
INSERT INTO nsu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Porke ne amo keman onikka de onimechilvi nochi tlen toYejwatzi okinekia xikmatikah. ");
INSERT INTO nsu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Axka, xikpiakah kuidado imejvah mismo iva xikinkuidarokah iichkavah in toTeko, tlen Ye okinko ika iesso, iva in Tioijyotzintli omechtlali kemi intlajpixkeh. ");
INSERT INTO nsu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ne nikmati ke ijkuak ne nias, vitzeh oksekimeh tlen kalakiskeh inmotzala iva kinekiskeh kintlamiskeh in tlaneltokakeh kemi oyeskia koyomeh tlen kinkuah ichkameh. ");
INSERT INTO nsu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Iva monextiskeh sekimeh de imejvah tlen tlakajkayavaskeh, tlamachtiskeh tlen amo neli para ke in tlaneltokakeh ma kintokakah. ");
INSERT INTO nsu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Por eso, xikpiakah kuidado. Xikilnamikikah ke por eyi xivitl, ika tonali ika yovali, amo keman onika de onimechtlajtlapovi kada se de imejvah ika miek noixayo. ");
INSERT INTO nsu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Axka, noknivah, nimechtlalia ipan imatzin toYejwatzi iva itech itlajtol de iknomachilistli, tlen kipia velitilistli para imechiskaltis itech inmotlaneltokalis, iva imechmakas in erensia san sekka invan nochtin tlen iaxkavah. ");
INSERT INTO nsu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne amo onikixneki íkka itomi o noso íkka itzotzol. ");
INSERT INTO nsu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Imejvah kuali inkimatih ke ne onitekipano ika nomavah para onikpixki tlen omonekia para ne iva para tlen nova onemiah. ");
INSERT INTO nsu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nochipa onimechmachti nik moneki se tekipanos para velis se kinpalevis tlen amitla kipiah. Ma tikilnamikikah tlen okijto in toTeko Jesús: “Ma paki okachi tlen itla kitemaka ke tlen itla kiselia.” ");
INSERT INTO nsu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Satepa de otlanki otlapo, Pablo omotlankuaketzki iva omodiostzajtzili ivan nochtin toknivah. ");
INSERT INTO nsu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nochtin sa tlawel ochokakeh, okimonanapaloltijkeh iva okixpipitzojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sa tlawel omoyolkokojkeh porke okinmilvi ke ayakmo kema kittaskeh. Satepa okikajkavatoh asta kan barko. ");
INSERT INTO nsu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ijkuak otikinkajtejkeh in toknivah, otitlejkokeh itech barko iva otiajkeh melajka asta kan tlali de Cos tlen yavalitok de atl tlen wei. Omostlatik otiajkeh itech oksé tlali itoka Rodas tlen yavalitok de atl tlen wei, iva de ompa otajsitoh kan altepetl Pátara. ");
INSERT INTO nsu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ompa Pátara otikajsikeh oksé barko tlen oyaya para kan región de Fenicia, itech otitlejkokeh iva otiajkeh. ");
INSERT INTO nsu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Otipanokeh serka de kan tlali de Chipre tlen yavalitok de atl tlen wei, tlen otikpanavijkeh ik toopochmapa, pero otipanokeh otiajkeh melajka asta kan región de Siria. Iva komo in barko okikajtikiski seki tlamamali kan siudad de Tiro, tonses ompa otitemokeh. ");
INSERT INTO nsu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ompa otikinmajsikeh sekimeh tlaneltokakeh iva otimokajkeh invah chikome tonali. Yejvah okilvijkeh in Pablo amo ma via Jerusalén ijkó kemi okinmilvi in Tioijyotzintli. ");
INSERT INTO nsu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ochikometik otikiskeh de ompa. Nochtin toknivah invan intonanavah ivan inpilvah, okiskeh de kan siudad otechmakavatoh. Otajsitoh itempan atl tlen wei otimotlankuaketzkeh iva otimodiostzajtzilijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Satepa de otimomakajkeh, otitlejkokeh itech barko iva otiajkeh, iva yejvah omokuapkeh para inkalijtik. ");
INSERT INTO nsu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Otikseguirojkeh otiajkeh itech barko, otikiskeh de Tiro iva satepa otajsitoh kan siudad de Tolemaida. Ompa Tolemaida otikintlajpalojkeh in toknivah iva otimokajkeh invah se tonali. ");
INSERT INTO nsu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Omostlatik otiajkeh para kan siudad de Cesarea. Otiajkeh kan ikalijtik in Felipe iva ompa otimokajkeh. Felipe okatka tetlapovi de tlen yankuik kuali tlajtoli, iva okatka se de tlen chikome tlapalevijkeh. ");
INSERT INTO nsu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipe okinpiaya navi ichpochvah tlen okatkah tiotenejmachtijkeh, tlen ayamo okinpiayah intotatavah. ");
INSERT INTO nsu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ompa yotikatkah kana keski tonali, iva ijkuakó oajsiko se tiotenejmachti itoka Agabo tlen ovalaya de región de Judea. ");
INSERT INTO nsu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ijkuak otechajsiko, okontilanili itlajkoilpika in Pablo, omomaijilpi iva omokxijilpi, iva okijto: —In Tioijyotzintli kijtova ke kan siudad de Jerusalén, in judiojtih kijilpiskeh ijkí iteko nin tlajkoilpikatl, iva kitemaktiskeh inmak in gentejtih tlen amo judiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ijkuak ijkó otikakkeh, tejvah ivan toknivah de Cesarea otiktlatlavtijkeh in Pablo amo ma via para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Iva Pablo otechnankili: —Amo xichokakah porke innechyolkokovah. Ne nimotemaka amo san para ma nechijilpikah, sino asta para ma nechixpolokah ompa Jerusalén por yen toTeko Jesús. ");
INSERT INTO nsu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pero komo amitla ovelik otikchijkeh para amo ma via Jerusalén, sa ijkó otikajkeh iva otikijtojkeh: —Ma mochiva tlen kimonekiltia toTeko. ");
INSERT INTO nsu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Satepa, otimotlayejtlalilijkeh iva otiajkeh para Jerusalén. ");
INSERT INTO nsu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Oyajkeh tovah sekimeh tlaneltokakeh de Cesarea, tlen otechvikakeh kan ikalijtik se tlakatl de Chipre itoka Mnasón, tlen desde yi wejkavitl yokatka tlaneltokak. Iva otimokalotijkeh ompa ikalijtik. ");
INSERT INTO nsu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ijkuak otajsitoh Jerusalén, in toknivah otechselijkeh ika miek pakilistli. ");
INSERT INTO nsu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Omostlatik, otiajkeh ivan Pablo otiktlajpalotoh in Jacobo. Nochtin tlayakankeh tlaneltokakeh noijki ompa okatkah. ");
INSERT INTO nsu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Satepa de okintlajpalo, Pablo nochi okintlapovi tlen Dios okichi innavak tlen amo judiojtih por medio de ye. ");
INSERT INTO nsu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ijkuak ijkó okikakkeh, okiweijkachijkeh in Dios, iva okilvijkeh in Pablo: —Tokni Pablo, yi tikitta ke sa tlawel miekeh judiojtih yotlaneltokakeh, pero yejvah kinekih ma mochiva tlen kijtova itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Yejvah okimatkeh ke nochtin judiojtih tlen kateh wejka itech oksekimeh países, ke te tikinmachtia ayakmo ma kichivakah tlen kijtova itlanavatil Moisés, iva ke tikinmilvia ayakmo ma mosirkunsidarokah inpilvah, iva ayakmo ma kichivakah in kostumbres de tejvah tlen tijudiojtih. ");
INSERT INTO nsu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Tlán tikchivaskeh? Porke nochtin kimatiskeh nik otivala. ");
INSERT INTO nsu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mejor ijkí xikchiva: Nika kateh navi tlakah tlen ik okitlalijkeh kichivaskeh se tlamantli inavak toYejwatzi. ");
INSERT INTO nsu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Xikinvika, iva ximochipava invah, iva xikintlatlaxtlavili para in yolkatlamiktiltih tlen monekis, para ma mopelonximakah. Tla ijkó tikchivas nochtin kimomakaskeh kuenta nik amo neli tlen kijtovah de te, sino ke kittaskeh nik te tikchiva tlen kijtova itlanavatil Moisés. ");
INSERT INTO nsu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Iva in tlaneltokakeh tlen amo judiojtih, yotikintlajkuililijkeh. Tikinmilviah amo ma kikuakah itla tlen kinmaniliah in diosmeh tlen tlamachivaltih, amo ma kikuakah estli, amo ma kikuakah nakatl de yolkameh tlen san kinkechpatzkah, iva amo ma avilnemikah itech tlajtlakoli. ");
INSERT INTO nsu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tonses Pablo okinvikak in navi tlakah, omostlatik omochipajkeh san sekka ivan yejonmeh tlakah. Satepa Pablo okalakki kan templo para okilvito in tiopixki itech tlán tonali tlamis mochipavaskeh, iva tlen sa ik tlami tonali kinmiktiskeh yolkameh kemi se tlamanali para Dios. ");
INSERT INTO nsu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ijkuak yotlamiskia in chikome tonali de omochipajtokah, sekimeh judiojtih de Asia okittakeh in Pablo kan templo. Okinpajsolojkeh nochtin gentejtih iva okitzkijkeh in Pablo. ");
INSERT INTO nsu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Iva otzajtzikeh chikavak: —¡Tatanmeh de Israel, techpalevikah! Nin tlakatl sentetl tetlapovijtinemi en kontra de topaís, en kontra de itlanavatil Moisés, iva en kontra de nin templo. Iva axka yokinkalaki kan templo sekimeh tlen amo judiojtih, yotlaijtlakokoh kan tlatiochitok. ");
INSERT INTO nsu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ijkó okijtojkeh porke achto okittakeh in Pablo ompa Jerusalén ivan Trófimo tlen de Éfeso, iva okiyejyekojkeh ke Pablo okikalaki kan templo. ");
INSERT INTO nsu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nochtin gentejtih de Jerusalén omopajsolojkeh, omotlelojkeh iva okitzkijkeh in Pablo. Okixtijkeh de kan templo okitilantiajkeh ipan tlali, iva san nima okintzakeh ipuertajvah in templo. ");
INSERT INTO nsu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Iva okinekiah kimiktiskeh, pero in wei tlayakanki de soldadojtih okimatki ke nochi in gente de Jerusalén sa tlawel omopajsolojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","San nima okinmololo sekimeh soldadojtih iva kapitanmeh, iva omotlelojkeh oyajkeh kan ololitokah in gentejtih. Ijkuak okittakeh in wei tlayakanki de soldadojtih ivan isoldadojvah, ijkuakó okikajkajkeh in Pablo iva ayakmo okimagakeh. ");
INSERT INTO nsu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","In wei tlayakanki de soldadojtih okitzki in Pablo iva okinnavati isoldadojvah ma kijilpikah ika ome kadenajtih. Satepa otlajtlanki akin yejón tlakatl iva tlán okichi. ");
INSERT INTO nsu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pero sekimeh otzajtziah chikavak okijtovayah se tlamantli iva oksekimeh oksé tlamantli. In wei tlayakanki de soldadojtih amo ovelik okimatki tlán panolo porke sa nochtin otzajtziah chikavak. Okachi kuali otlanavati ma kivikakah kan kuartel. ");
INSERT INTO nsu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ijkuak oajsitoh kan eskalones de kan kuartel, in soldadojtih okajkovantiajkeh tlakpak in Pablo para amo kitzkiskeh in gentejtih porke sa tlawel okualaniah. ");
INSERT INTO nsu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Iva nochtin oyayah inkuitlapa otzajtzitiayah chikavak okijtovayah: —¡Xikmiktikah! ");
INSERT INTO nsu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ijkuak yokikalakiskiah kan kuartel, in Pablo okitlajtlani in wei tlayakanki de soldadojtih: —¿Velis achitzi mova nimotlapovis? Iva ye okinankili: —¿Veli titlapova griego? ");
INSERT INTO nsu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Amo te tiegipcio tlen yi tlan tonali ipan otía in kobierno iva otikinvikak navi mil temiktijkeh kan tlavaki? ");
INSERT INTO nsu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo okilvi: —Amo, mach ne. Ne nijudío onineski kan siudad de Tarso, se siudad wei tlen kajki itech región de Cilicia. Nimitztlatlavtia techkavili ma nikonintlapovi in gentejtih. ");
INSERT INTO nsu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","In wei tlayakanki de soldadojtih okavili ma kintlapovi. Tonses Pablo omoketzki kan eskalones de kan kuartel, okinchivili señas ika ima para ma motenkavakah. Iva ijkuak omotenkajkeh, Pablo okintlapovi ika tlajtoli hebreo. Okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Noknivah judiojtih iva imejvah tlen intekivajkeh, xikakikah tlen nimechilvis para nimopalevis. ");
INSERT INTO nsu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ijkuak okikakkeh ope kintlapovia ika intlajtol hebreo, okachi sa ovalmotenkajkeh. Iva Pablo okinmilvi: ");
INSERT INTO nsu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Ne nijudío. Onineski kan siudad de Tarso, tlen kajki itech tlali de Cilicia, pero ne onimoskalti nika Jerusalén. Ne onikatka nimomachti de Gamaliel iva ye kuali onechixtlamachti itech intlanavatilvah in tokojkolvah. Ika nochi noyolo oniktekipanovaya in toYejwatzi, ijkó kemi nochtin imejvah axka inkichivah. ");
INSERT INTO nsu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Achto ne onikintemojtinemia tlen nemih itech iojviv in Jesús para nikinmiktis. Tlakah ivan sivameh onikinkitzkiaya iva onikintzakuaya telpiloya. ");
INSERT INTO nsu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","In wei tiopixki iva nochtin tetajmeh tlen povih itech injunta in judiojtih kuali kimatih nik ijkó onikchivaya. Se tonali yejvah onechmakakeh seki tlanavatil amameh para in toknivah judiojtih tlen chantih Damasco, para ma nechkavilikah ma nikinkitzki in tlaneltokakeh iva ma nikinvalika nika Jerusalén para ma kintlajyoviltikah. ");
INSERT INTO nsu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Ijkuak oniaya itech ojtli iva yonajsitiaya Damasco, kemi tlajko tonali, san de repente se chikavak tlavili ovala de ilvikak opetlanki iva onechyavalo ");
INSERT INTO nsu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","iva onivetzito ipan tlali. Iva onikakki se tlajtoli, onechilvi: “Saulo, Saulo, ¿tleka techtemojtinemi para techtlajyoviltis?” ");
INSERT INTO nsu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ijkuakó ne onitlanankili: “¿Akin tejwatzi?” In tlajtoli onechnankili: “Ne niJesús de Nazaret, tlen te tiktemojtinemi.” ");
INSERT INTO nsu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tlen nova oyayah okittakeh in tlavili iva omomavtijkeh, pero amo okajsikamatkeh in tlajtoli tlen ne onechtlapovi. ");
INSERT INTO nsu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne oniktlajtlani: “¿Tlán nikchivas, noTeko?” Iva in toTeko onechilvi: “Ximoketza iva xivia kan siudad de Damasco. Ompa mitzilviskeh tlán moneki tikchivas.” ");
INSERT INTO nsu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","In tlavili onechixmikti iva ayakmo ovelik onitlachixki. Iva in tlakah tlen nova oyayah sa onechmatilantiajkeh onechvikakeh para Damasco. ");
INSERT INTO nsu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Ompa okatka se tlakatl itoka Ananías, tlen yi neli okivelkakia itlanavatil Moisés, iva nochtin judiojtih tlen ompa chantih otlajtovayah kuali de ye. ");
INSERT INTO nsu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ye ovala onechittako iva onechilvi: “Nokni Saulo, xitlachia oksejpa.” Iva san nima ijkuakó onitlachixki oksejpa, iva ovelik onikittak. ");
INSERT INTO nsu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ijkuakó ye onechilvi: “In toYejwatzi de yi wejkavitl tokojkolvah yomitzpejpenki para xikmati tlen Ye kimonekiltia, para xikitta in Jesús tlen tlakamela iva para xikakili itlajtol. ");
INSERT INTO nsu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Porke te tikintlapovis nochtin tlaltikpaktlakah de tlen otikittak iva de tlen otikakki. ");
INSERT INTO nsu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Iva axka, amo ximochia okachi. Ximoketza iva ximobautisaro. Xiktlatlavti in toTeko ma mitzchipava de motlajtlakol.” ");
INSERT INTO nsu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Ijkuak onimokuapki para Jerusalén, onivia kan templo onimodiostzajtzilito, iva onikittak in toTeko itech se tetzavistlachialistli. ");
INSERT INTO nsu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Iva onechilvi: “Xikisa totoka de Jerusalén, porke amo kiseliskeh tlen tikintlapovis de Ne.” ");
INSERT INTO nsu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Iva ne oniknankili: “NoTeko, yejvah kimatih ke ne oniaya itech nochtin tiotlamachtijkaltih iva onikinkitzkiaya tlen mitzneltokah, onikintzakuaya telpiloya iva onikinvitekia. ");
INSERT INTO nsu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Iva ijkuak okimiktijkeh in Esteban tlen otetlapoviaya de tejwatzi, ne ompa onikatka iva onikijto kuali ka ma kimiktikah iva asta onikinkuidarojtoka intlakenvah tlen otemiktijkeh.” ");
INSERT INTO nsu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pero in toTeko onechilvi: “¡Xivia! Ne nimitztitlanis wejka, kan kateh tlen amo judiojtih.” ");
INSERT INTO nsu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Asta ompa okikakilijkeh itlajtol, iva ijkuakó ope tzajtzih chikavak: —¡Ma miki yejón tlakatl! ¡Mach ok itech povi ma yolito! ");
INSERT INTO nsu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Otzajtziah chikavak iva okinmajkotlamotlayah intlakenvah iva okajkotlamotlayah tlalpinoli, ");
INSERT INTO nsu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","in wei tlayakanki de soldadojtih otlanavati ma kikalakikah in Pablo kan kuartel. Iva otlanavati ma kivitekikah para ma kijto tleka in gentejtih okualaniah iva otzajtziah inavak. ");
INSERT INTO nsu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Iva ijkuak yokijilpijkah para kivitekiskeh, in Pablo okitlajtlani in kapita tlen ompa okatka: —¿Velis inkivitekiskeh se tlakatl romano maski ayamo inkimatih kox tlajtlakole o noso amo? ");
INSERT INTO nsu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ijkuak ijkó okikakki in kapita, oyá okimatiltito in wei tlayakanki de soldadojtih. Okilvi: —Xikpia kuidado de tlen tikchivas porke nin tlakatl romano. ");
INSERT INTO nsu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","In wei tlayakanki de soldadojtih okittato in Pablo iva okitlajtlani: —¿Kox yi neli in te tiromano? Pablo okinankili: —Neli, ne niromano. ");
INSERT INTO nsu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ijkuakó in wei tlayakanki de soldadojtih okilvi in Pablo: —Ne oniktlaxtla miek tomi para onimochi niromano. Pablo okijto: —Ne niromano desde onineski. ");
INSERT INTO nsu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","In tlakah tlen okivitekiskiah in Pablo san nima okikajkajkeh ijkuak okimatkeh nik in ye romano, noijki in wei tlayakanki de soldadojtih omomavti porke yotlanavatijka ma kijilpikah iva ma kivitekikah. ");
INSERT INTO nsu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Omostlatik, in wei tlayakanki de soldadojtih otlanavati ma mololokah in tlayakankeh tiopixkeh iva nochtin tetajmeh tlen povih itech injunta in judiojtih, porke okinekia kuali kimatis tleka okiteilviayah in Pablo. Satepa otlanavati ma kinkixtilikah in kadenajtih iva ma kixtikah de kan telpiloya para kinmixpantilis. ");
INSERT INTO nsu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo okintlajtlatak nochtin tlen okatkah kan junta iva okinmilvi: —Noknivah, ne nochipa ninemi inavak toYejwatzi ika chipavak notlalnamikilis. ");
INSERT INTO nsu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ijkuakó in wei tiopixki Ananías, okinnavati tlen ompa okatkah inakastlan Pablo, ma kitentlatzinikah. ");
INSERT INTO nsu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pablo okilvi: —¡ToYejwatzi mitztentlatzinis te, tlen tikpia ome moixko! Te ompa tietok para techtlatzintokis kemi kijtova in tlanavatili, ¿tonses tleka titlanavatia ma nechtentlatzinikah? ¿In tlanavatili kox kijtova ijkó xikchiva? ");
INSERT INTO nsu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Tlen ompa okatkah okilvijkeh: —¿Kenik timixevia ijkó tiknankilia in wei tiopixki de Dios? ");
INSERT INTO nsu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo okijto: —Noknivah, ne amo onikmatia kox yen wei tiopixki. In Tiotlajkuiloli kijtova: “Amo titlajtos fiero de se tlayakanki de moaltepe.” ");
INSERT INTO nsu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ijkuakó Pablo okimomakak kuenta ke ompa itech junta okatkah sekimeh saduceos iva sekimeh fariseos, iva okijto chikavak: —Noknivah, ne nifariseo, ne nivalajtok familia de fariseos. Imejvah innechtlatzintokiah porke ne nikchia ke se tonali moyolitiskeh in mikameh. ");
INSERT INTO nsu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ijkuak ijkó okijto in Pablo, in fariseos ivan saduceos sa yejvah ope motlatlajtolnamikih, iva omotlajkoxelojkeh nochtin tlen ompa omololojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porke in saduceos amo kineltokah kox onkateh ilvikaktlatitlaniltih o noso ejekameh o noso kox velis moyolitiskeh in mikameh. Pero in fariseos yejvah yi neli kineltokah nochi yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nochtin otzajtziah chikavak. Sekimeh tlamachtijkeh de itlanavatil Moisés, tlen opoviah invan fariseos, omoketzkeh iva okijtojkeh: —Nin tlakatl amitla fiero okichi. Xamo yi neli okitlapovi se ejekatl o noso se ilvikaktlatitlanili. Okachi kuali amo ma tiekah ikontra in Dios. ");
INSERT INTO nsu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Iva komo sa tlawel okachi omotlajtolnamikiah, in wei tlayakanki de soldadojtih omomavti amo san kichiva kitzkiskeh iva kipedasojchivaskeh in Pablo. Ijkuakó otlanavati ma vikikah sekimeh soldadojtih ma kixtikah de ompa iva ma kivikakah oksemi para kan kuartel. ");
INSERT INTO nsu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yejón yovak, in toTeko okimonextili in Pablo iva okilvi: —Ximoyolchikava, Pablo, porke ijkó kemi otitlapo de Ne nika Jerusalén, ijkó noijki moneki titetlapovis kan siudad de Roma. ");
INSERT INTO nsu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Omostlatik, sekimeh judiojtih omotlatlalvijkeh para kimiktiskeh in Pablo. Okijtojkeh: —Amitla tikuaskeh iva nion amitla tikoniskeh asta kan amo ma tikmiktikah in Pablo, iva ma techpano tlen amo kuali tla amo ijkó tikchivaskeh. ");
INSERT INTO nsu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Okatkah okachi de ompoali tlakah tlen ijkó okijtojkeh. ");
INSERT INTO nsu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Oyajkeh okinmitatoh in tlayakankeh tiopixkeh ivan tlayakankeh tetajmeh judiojtih. Iva okinmilvijkeh: —Tejvah ik yotiktlalijkeh amitla tikuaskeh iva amitla tikoniskeh asta kan amo tikmiktiskeh in Pablo, iva tla amo ijkó tikchivaskeh, ma techpano tlen amo kuali. ");
INSERT INTO nsu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Axka imejvah iva tlen povih itech junta xiktlajtlanilikah in wei tlayakanki de soldadojtih mostla oksejpa ma kivalika in Pablo inmonavak. San ik xikchivakah ke inkinekih inkitlatzintokiskeh okachi. Tejvah sa timochixtoskeh para tikmiktiskeh antes de ajsiki nika. ");
INSERT INTO nsu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pero se isobrino in Pablo okimatki nik kinekih kimiktiskeh itio, iva nima omotlelo okimatiltito kan kuartel. ");
INSERT INTO nsu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pablo okinotzki se kapita, iva okilvi: —Xikvika nin chokko inavak in wei tlayakanki de soldadojtih porke kineki kimatiltis se tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","In kapita okivikak in chokko inavak in wei tlayakanki de soldadojtih iva okilvi: —Pablo tlen tzaktok telpiloya onechnotzki iva onechilvi ma nikvalika nika nin chokko. Kineki mitzilvis se tlajtoli. ");
INSERT INTO nsu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","In wei tlayakanki de soldadojtih okimatilanki in chokko okivikak ik sekka iva okitlajtlani: —¿Tlán tikneki techilvis? ");
INSERT INTO nsu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","In chokko okilvi: —In judiojtih yomotlatlalvijkeh para mitztlatlavtikivih xikvika in Pablo mostla kan junta, san ik mochivaskeh kinekiskeh kitlatzintokiskeh okachi para kiyekmatiskeh tlán okichi. ");
INSERT INTO nsu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pero amo xikinneltokili. Porke kemi ompoali tlakah sa kichixtokeh para kimiktiskeh ichtaka. Iva yokijtojkeh ke amitla kikuaskeh iva amitla koniskeh tla achto amo kimiktiah in Pablo, iva tla amo ijkó kichivaskeh ma kinpano itla tlen amo kuali. Axka sa kichixtokeh tlán tikijtos. ");
INSERT INTO nsu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ijkuakó in wei tlayakanki de soldadojtih okimaka in chokko. Iva okinavati amika itla ma kilvi de yejón tlamantli. ");
INSERT INTO nsu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","In wei tlayakanki de soldadojtih okinnotzki ome kapitanmeh, iva okinnavati sa ma moyektlalikah ome siento soldadojtih tlen san nejnemiskeh, expoali ivan majtlaktli tlen yaskeh ipan kavayo, iva ome siento tlen yaskeh ika inkuavah yakateposojkeh. Okinmilvi nochtin ma viah para Cesarea a las nueve de yovak. ");
INSERT INTO nsu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Noijki otlanavati ma kiyektlalikah se kavayo para ipan yetias in Pablo, iva otlanavati amitla ma kipano iva ma kivikakah ika kuali inavak in kobernador Félix. ");
INSERT INTO nsu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iva okinmakak ma kivikakah se amatlajkuiloli tlen ijkí kijtova: ");
INSERT INTO nsu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ne niClaudio 