﻿USE sofia;
DROP TABLE IF EXISTS sofia.nss_vpl;
CREATE TABLE nss_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nss_vpl WRITE;
INSERT INTO nss_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Koluw-koluw mamu kinna, Ngindrai imangsani kol pwan pe hu kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pe kol pwan ara, iro ko mwaihei o, pe nimnim para aliy ara kinto tehe mahapo pwi. Pe sinon namandran iramburuhi ndrita mwekeu, pe Mwoiwa Ngindrai iho makaiye ndrita hu ndran ara. ");
INSERT INTO nss_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Pwen Ngindrai ipa, <<Ngana lang kilenganiy.>> Pwen o ilenganiy. ");
INSERT INTO nss_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ngindrai inimei tehe ngana lang irayah hiyan, pwen irandrokomatne ndrokolo ngana lang pe ping. ");
INSERT INTO nss_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ngindrai ipohowe ngana lang ara <<lang>> pe ping ara <<ping.>> Piyahon iyamasan ndroulang ara irayah langsih imu iya melit masih. ");
INSERT INTO nss_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Pwen Ngindrai ipa, <<Melit handra kirayah kiho ndrokolo hu ndran, para hu ndran kandrih kaya malkah.>> ");
INSERT INTO nss_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Pwen Ngindrai imbusi melit ara, pe iykiy iho ndrokolo hu ndran para koro pwan pe hu ndran para koho paingan. Pe irayah tehen aliy. ");
INSERT INTO nss_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pe Ngindrai ipohowe paingan ara <<yang.>> Piyahon iyamasan ndroulang ara irayah lang luwoh. ");
INSERT INTO nss_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Pwen Ngindrai ipa, <<Hu ndran masih hutora pahandra yang kayawule, pe pwan posowen kirayah.>> Pe irayah tehen aliy. ");
INSERT INTO nss_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ngindrai ipohowe pwan posowen ara <<pwan,>> pe hu ndran masih huyawule ipohowe hu ara ndras. Pe Ngindrai inimei tehe kintayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Pwen Ngindrai ipa, <<Hu melit para kalek karayah ndrita pwan: ndromwindriu handra-handra mapekehu hu kalek, pe hu kei handra-handra mambuwahu pe mapekehu toraliy kalek, pe kapo soiwihu mwensehu tehe yihu kopu.>> Pe irayah tehen aliy. ");
INSERT INTO nss_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Pwen hu ndromwindriu handra-handra ara hurayah ndrita pwan pe huiki pekehu para hu kalek pe kapo soiwihu mwensehu tehe yihu kopu; pe hu kei handra-handra hurayah pe huiki mbuwahu mapekehu toraliy para hu kalek pe kapo soiwihu mwensehu tehe yihu kopu. Pe Ngindrai inimei tehe kintayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Piyahon iyamasan ndroulang ara irayah lang toyoh. ");
INSERT INTO nss_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Pwen Ngindrai ipa, <<Hu ngana lang karayah koho yang para hu kaiki ndrokomatne lang pe ping. Pe hu koho ariya para hu karanonoye kaipisa hu melit, pe walehe hu melit, pe hu lang sih-sih, pe hu hayou sih-sih. ");
INSERT INTO nss_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Pe hu melit manganahu ara, andre hu koho yang para hu kalengani kol pwan.>> Pe irayah tehen aliy. ");
INSERT INTO nss_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ngindrai imangsani melit malndra namandran mangana hilu. Imangsani melit nganan namandran para kiho yat lang, pe melit nganan mendreheh para kiho yat ping. Pe imangsani hu piriy huyapolon i. ");
INSERT INTO nss_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ngindrai iyki melit masih ara kene hora yang para hu kalengani kol pwan, ");
INSERT INTO nss_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","pe para hu koho mu kili lang pe ping, pe para kaiyki ndrokomatine ngana lang kiho mawen kili ping. Ngindrai inimei tehe kintayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Piyahon iyamasan ndroulang ara irayah lang haahiu. ");
INSERT INTO nss_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Pwen Ngindrai ipa, <<Hu ndras pe hu ndran kahon kata hu kan handra-handra mepo mwalehu; pe hu norukan kohowoh yang ndrita kol pwan.>> ");
INSERT INTO nss_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Pwen Ngindrai imangsani hu kan namandran handra-handra mwalehu para ndras pe ndran, mepo ngara hu karangangai, para hu kapo soiwi hu mwensehu tehe yihu kopu. Pe imangsani hu norukan makapenehu hurayah para hu kapo soiwihu mwensehu tehe yihu kopu. Pe Ngindrai inimei tehe kintayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Pwen Ngindrai itoholi hu pe ipa, <<Akahon pe ndromwoya wawu karayah kaya soyon koro ndras. Pe hu norukan karayah kaya soyon koro kol pwan i.>> ");
INSERT INTO nss_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Piyahon iyamasan ndroulang ara irayah lang yimah. ");
INSERT INTO nss_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Pwen Ngindrai ipa, <<Hu kan handra-handra makunuwehu karayah pe kapo soiwi hu mwensehu tehe yihu kopu koro kol pwan—hu kan para hanghang pe hu kan masih para seselek ndrita pwan, pe hu kan puyap, ara hu masih karayah para hu kapo soiwihu mwensehu tehe yihu kopu.>> Pe irayah tehen aliy. ");
INSERT INTO nss_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ngindrai imangsani hu kan puyap hurayah para hu kapo soiwi hu mwensehu tehe yihu kopu, pe hu kan para hanghang ara hurayah para hu kapo soiwi hu mwensehu tehe yihu kopu. Pe imangsani hu kan para seselek ndrita pwan hurayah para hu kapo soiwi hu mwensehu tehe yihu ko yi. Pe Ngindrai inimei tehe kintayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Pwen napwai, Ngindrai ipa, <<Worou kamangsani hu ndramat, kaipisahu pe mwensehu karayah tehe worou opu. Pe andre hu karayah tamahu ni para ndras, pe hu norukan para kohowoh yang, pe hu kan para hanghang, pe hu kan masih para seselek ndrita pwan; pe hu ndramat ara andre karayah tamahu melit masih koro kol pwan masih, pe andre hu kan masih aro ara koro pahandra hu ndramat.>> ");
INSERT INTO nss_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Pwen pe Ngindrai imangsani hu ndramat, mwensehu ara tehe yiy opu. Pe imangsani hu ndramat malpat, kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Pwen Ngindrai itoholi hu ndramat pe ipwai iya kili hu ipa, <<Akapo noru wawu hu pe ndromwoya wawu karayah soyon pe kasilihi kol pwan, pe wawu karayah mbukena kol pwan. Akoho mu kiya tahu ni para ndras, pe hu norukan para kohowoh yang, pe koho mu kili hu kan masih mwalehu mepo ngara kaselek ndrita pwan.>> ");
INSERT INTO nss_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Pwen Ngindrai ipa, <<Yo uhungini wawu hu ndromwindriu masih handra-handra mapekehu tora ndrita kol pwan masih pe hu kei mepo mambuwahu pe mapekehu toraliy. Pe andre hu karayah anandrina wawu. ");
INSERT INTO nss_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pe hu kan masih para pwan, pe hu norukan masih para wohowoh, pe hu kan masih para seselek ndrita pwan–hu melit masih mepo makunuwehu tora aliy–ara uhungini hu hu ndromwindriu pe hu youkei salau para karayah anandrinahu.>> Pe irayah tehen aliy. ");
INSERT INTO nss_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Pe Ngindrai inime melit masih kene kinmangsaniy ara irayah hiyan iya. Piyahon iyamasan ndroulang ara irayah lang anoh. ");
INSERT INTO nss_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tehen tora ko, kol pwan pe hu kol paingan yang, pe hu melit masih kene mepo Ngindrai kinmangsani hu kantayah hutora aliy, ara kansahapwen topwei. ");
INSERT INTO nss_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nondriya lang manonoh ara, mbuluya Ngindrai kinhipwen topwei. Pwen pe lang sih i ara ingoh iya mbulyan masih. ");
INSERT INTO nss_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Pe Ngindrai itoholi lang andrtoyoh ara pe ihaiyaniy, paratesah, kinmangsani melit masih kene kinhipwen, pe lang ara ingoh iya mbulyan. ");
INSERT INTO nss_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iye ara titiye para Ngindrai imangsani kol pwan pe hu kol paingan yang hurayah. Tandrohonga YAPAN Ngindrai imbusi kol pwan pe hu kol yang ara, ");
INSERT INTO nss_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hu kei, hu malikei, pe hu ndromwindriu handra-handra ara hu kanilek ndrita pwan mapu, pe mbulou mapu kindrut, pe hamou ndramat para kipo mbulen kiya ndrita pwan ara kintayah mapu. ");
INSERT INTO nss_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Hapeko ndran ara ngara kisuw mbulu pwan pe ngara kingas kisa paingan, pe ndrita pwan masih ara ipep iya ndran. ");
INSERT INTO nss_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Pwen pe YAPAN Ngindrai imangsani ndramat iyau kohu pwan, pe ihili ngohan para taleh iya ngara ndrohongun, pe ndramat ara, ara irayah ndramat mwalen. ");
INSERT INTO nss_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Pe YAPAN Ngindrai ihisi piyang hambut iro kol hakol ngalan Yiten iyapwen te kup, pwen iyki ndramat mepo kinmangsani yiy ara, ara iya iyen aliy. ");
INSERT INTO nss_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Pe YAPAN Ngindrai imangsani hu kei handra-handra hu lek ndrita pwan–hu kei ara, ara lahayahu iya, pe hiyan para hu kaiyki anandrinai. Pe Ngindrai iyki kei para kiyki taleh ara iro ndrokolo piyang imwonen, iyapolo kei para kasapahasani hiyan pe mwomwan. ");
INSERT INTO nss_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Pe ndran handrang itarah iyau Yiten, ngara kiyki ndran kiya piyang; pe sohopele ndran ara, ara mahaandrang. ");
INSERT INTO nss_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ngala ndran handrang ara Pison, irah irakayani kol namandran Hawila mepo kolt ita aliy. ");
INSERT INTO nss_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Kolt para kol Hawilah ara hiyan iya, pe kei hakou ita aliy, ngonoho ndreyen ara layin iya. Pe pat handra mepo kennen namandran ita aliy yi, ngalan ara karniliyan ");
INSERT INTO nss_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Pe ndran lundrang ngalan ara Kihon, pe irah irakayani kol namandran Kus. ");
INSERT INTO nss_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Pe ndran tindrang ngalan ara Taikris; pe irah irakaiyani ngilse kol namandran Assiriya iyapwen te kup. Pe ndran haandrang ngalan ara Yuperetis. ");
INSERT INTO nss_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Pwen YAPAN Ngindrai iwiri ndramat ara pe iyki yiy iye nondriya piyang iro kol Yiten, para kiropo mbulen pe kiro nimnim kaliy. ");
INSERT INTO nss_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Pwen YAPAN Ngindrai ipwandrandrahani ndramat ara ipa, <<Hiyan para ayan hu mbuwakei para hu kei masih kene hutopo nondriya piyang iye; ");
INSERT INTO nss_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","hapeko nonombun para apopo kiyau kei para kasapahasani hiyan pe mwomwan, paratesah, kapa ayan, lang ara ko andre amat imwonen.>> ");
INSERT INTO nss_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Pwen YAPAN Ngindrai ipa, <<Kinna hiyan para ndramat ara kiro yiy hamou o pwi. Andre kumangsani hamou kilahiy para kisopwat yiy.>> ");
INSERT INTO nss_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Pe YAPAN Ngindrai kinwiri pwan pe kinmangsani hu kan masih para yangiy pe hu norukan para hu kohowoh yang ara huyau aliy. Pwen iwiri hu huya kili ndramat ara para nakiyirowei tehe ndramat ara nakipohowe ngalahu tapeh; pe sehe ngala kan hamou-hamou mepo ndramat ara ipohowei pe iykiy, ara irayah ngalan ara ko. ");
INSERT INTO nss_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Pwen ndramat ara ipohowe ngalahu kan masih para hanghang, pe hu norukan masih para kohowoh yang, pe hu kan masih para yangiy. Hapeko mwalinga hu kan masih kene ara, ara hamou tahu kinlahiy para kisopwat Atam pwi. ");
INSERT INTO nss_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Pwen pe YAPAN Ngindrai imbusi ndramat ara imatin turut, pe tandrohongan iro ndron nondriya matiliu, YAPAN Ngindrai iwiri ndruwin hakou para kesen, pe irapairani sangin imui iya nokun. ");
INSERT INTO nss_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Pe YAPAN Ngindrai imangsani pihin hamou iya ndruwi ndramat mepo iwiriy iyau kesen. Pwen iyaiki yiy iya kili ndramat ara. ");
INSERT INTO nss_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Pe ndramat ara ipa, <<Napwai, yiy ara! Yiy ara ndruwin iyau ndruwi, pe sangin iyau sangi; pe andre kapohowe yiy <pihin,> paratesah, yiy ara iyau kili kamai.>> ");
INSERT INTO nss_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Pwen tehen tora ko, andre kamai kitali taman hilu tinan, pe andre hilu pihin tan karayah hapat, pe nombuwe hilu kirayah hamou o. ");
INSERT INTO nss_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Pe ndramat ara hilu nambuyun, ara hilu malmou kene mwaye hilu pwi, hapeko hilu kanmasi ta hilu pwi. ");
INSERT INTO nss_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Pe mwat ara kan hamou mepo YAPAN Ngindrai kinmangsaniy, pe kultuw tan para kisuhuri nongan ara namandran iya, pe iramwaitini hu kan puyap masih. Pe mwat isike pihin ipa, <<Ndrokonan tehe Ngindrai kinpwai kinsata walu tehe nonombun para walu kayan mbuwakei para hu kei masih hutopo ndraipiyang iye, ndre?>> ");
INSERT INTO nss_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Pwen pe pihin ipwai iya kili mwat ipa, <<Ilahi para youlu kayan mbuwakei para hu kei masih hutopo nondriya piyang; ");
INSERT INTO nss_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","hapeko Ngindrai kinpwai kinsa kili youlu kinpa, <Kei hakou opu, iripo ndrokolo piyang, ara nonombun para walu kayan mbuwan ndre kambultuwei; kapa walu kambusiy tehen tora, andre walu kamat.> >> ");
INSERT INTO nss_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pe mwat ipwai iya kili pihin ipa, <<Pukene; walu andre kanmat pwi yoh! ");
INSERT INTO nss_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ngindrai tanan kapa walu kayan, andre mara walu kileu, pe walu andre karayah tehe Ngindrai, pe walu andre kapahasani hiyan pe mwowan.>> ");
INSERT INTO nss_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tandrohonga pihin inime mbuwakei para kei ara, ara mwayih para kaniyai pe ilimiri maran, pe ilohonganiy tehe ara hiyan i para kiyki lolohongai waison, pwen irihi hayah pe iyniy. Pe iyki hayah iya kili nambuyun mepo irosura yiy, pe iyniy. ");
INSERT INTO nss_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pwen pe mara hilu malmou kene ara ileu pe hilyirowei tehe mwaye hilu pwi. Pwen pe hilu siy hu you pik hayah iyawule pe hilu rahasi hilu iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kol ipiyah pe inowu, pwen hilu hilingi ngasa YAPAN Ngindrai isa iho rokai ndraipiyang. Pe hilu malohowe hilya hilro mwalinga hu kei para piyang. ");
INSERT INTO nss_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Hapeko YAPAN Ngindrai iyoh iya kili Atam pe ipa, <<Wou ataleheh?>> ");
INSERT INTO nss_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Pwen Atam isomwi yiy ipa, <<Yo uhilingi ngasam aripo nondriya piyang, pe yo ara mwaye pwi; pwen pe unoh pe urupo kohon.>> ");
INSERT INTO nss_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Pe Yapan Ngindrai isike yiy ipa, <<Hiyeh ipwai satam tehe mwayem pwi? Wou matisan aniyan mbuwakei para kei mepo kunpwandrandrahani wou para mbuna ayan ara, ndre?>> ");
INSERT INTO nss_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Pwen Atam ipa, <<Pihin mepo aiki yiy isa iripo kili yo ara, ara iyki mbuwakei para kei ara isa kili yo pe uiniy.>> ");
INSERT INTO nss_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Pwen pe YAPAN Ngindrai ipwai iya kili pihin ipa, <<Aripo tesah anmbusiy yeh?>> Pe ipwai kilin ipa, <<Mwat ara ipwahihiri yo pe uiniy.>> ");
INSERT INTO nss_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pwen pe YAPAN Ngindrai ipwai iya kili mwat ipa, <<Wou anmbusiy tehen tora, pwen pe mahapo uten anam, pe koram nakuniy ara iramwaitini nopwaran tahu kan para hanghang masih, pe hu kan puyap masih kene! Pe andre aroselek kiya pulndriyam pe andre aroyan kohu pwan nondriya hu lang tam masih itapo isa kamulan. ");
INSERT INTO nss_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Pe andre kuiki hingas kiho mwalingam pe mwalinga pihin, pe mwalinga ndrayem hu pe mwalinga ndrayen hu. Pe ndraye pihin hamou andre kiraluluwi payam, pe wou andre ayantani mbutikan.>> ");
INSERT INTO nss_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Pe yiy ipwai iya kili pihin ipa, <<Yo andre kuiki ngandran kingas kiya namandran iya, tandrohonga mapundriyam; pe tandrohonga namwalahiy kiyata mbunah, andre ahangoruwe ngandran namandran i. Pe wou andre aro namili nambuyum manau, pe andre kiho mu pe wou andre aro pahandran.>> ");
INSERT INTO nss_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Pe yiy ipwai iya kili Atam ipa, <<Wou anhilingi nongna nambuyum, pe anyani mbuwakei para kei mepo kunpwandrandrahani wou para mbuna ayan ara, pwen pe tunan wou opu, mahapo uten ana pwan; pe andre apo mbulen pwokeyan para apo anandrinam kiyau aliy, nondriya hu lang tam masih itapo isa kamulan. ");
INSERT INTO nss_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pe hu malikei maporon pe hu ndromwindriu mwomwan andre hu kalek koro ndrita pwan pe karaimwani pingem. Pe andre aroyan hu anandrinai handra-handra para pwan. ");
INSERT INTO nss_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Pe wou andre apombulen mabusungereyim para apo anandrinam, kipoo amat pe amui aya pwan, paratesah, uwiri wou ayau aliy asa. Wou ara kohu pwan, pwen andre amui aya kohu pwan paiwe yi.>> ");
INSERT INTO nss_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Pe Atam ipohowe ngala nambuyun ara Ewa, paratesah, yiy ara tinahu ndramat masih kene mepo mwalehu. ");
INSERT INTO nss_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Pe YAPAN Ngindrai isoruwe koyau malmou iyau kapilo kan pe irahasi Atam hilu nambuyun iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Pe YAPAN Ngindrai ipa, <<Ndramat mahapo kinsapahasani hiyan pe mwomwan, pwen pe kinsarayah tehe worou opu. Kinna hiyan para niman kiyawiri mbuwakei para kei para taleh pe kiyan ara pwi yoh; matisan kimbusiy pe andre kinto-kinto.>> ");
INSERT INTO nss_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Pwen pe YAPAN Ngindrai irasses yiy iya mawen piyang para kol Yiten, para kiyapo mbulen kiya pwan mepo imangsani yiy iyau aliy. ");
INSERT INTO nss_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Iyamulan para irasse ndramat ara kinna mawen ihipwen, pwen iyki hu angelou huyapwen te kup para Piyang Yiten, iyapolo semela pahun niwen mamwan iro rapaiwani yiy iya isa, para kiro penani hu ndramat para hu mbuna kasayau sai pe kaya pakeh kili kei para taleh. ");
INSERT INTO nss_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Atam imatin iyapolo nambuyun Ewa, pe nambuyun mapundriyan, pe imwalahiy iyata norun Kain. Pe Ewa ipa, <<Iya hiyan ta YAPAN o, isopwat yo pe uwiri mbunah hamou kamai iye.>> ");
INSERT INTO nss_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Iyamulan imwalahiy ta nalin hamou ngalan Apel. Pe Apel ara yiy ndramat ngara kiro nimnim katahu sipsip, pe Kain ara yiy ndramat para mbulya piyang. ");
INSERT INTO nss_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Iyamulan hape, Kain iya piyang pe iya kuni hu ndroha anandrinai tan iman pe iykiy iya kili YAPAN tehe totohun. ");
INSERT INTO nss_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hapeko Apel iwiri noru sipsip tan hamou ndrohan imuh pe iykiy iya kili YAPAN. Pe YAPAN ara ipwesani totohun ta Apel. ");
INSERT INTO nss_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Hapeko kinpwesani totohun ta Kain pwi yoh. Pwen Kain ara ndrinan ilokuh pe mbulmaran ara ikohut. ");
INSERT INTO nss_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Pwen pe YAPAN ipwai iyata Kain ipa, <<Paratapeh ndrinam ilokuh? Pe paratapeh mbulmaram ikohut? ");
INSERT INTO nss_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kapa wou ambusi melit hiyan, yo andre kupwes kiya aliy. Hapeko kapa ambusi melit kinna hiyan pwi, andre mwomwan kimemerani wou. Pe mwomwan ara ita polndrikam, pe inamili wou pwokeyan iya. Pwen apwoke arapiyaniy; kapa pwi, andre kiramate wou.>> ");
INSERT INTO nss_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Porosih aro, Kain ipwai iyata nalin Apel ipa, <<Kiya, takayau kaya yangiy na.>> Hilya hilto yangiy, pe Kain ihilak o itingundru nalin pe imat. ");
INSERT INTO nss_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Pwen YAPAN isike Kain ipa, <<Nalim Apel kinna aleheh?>> Pe Kain isomwiy ipa, <<Yo ukowu tan o. Apa ndre kuro memerani nali ko?>> ");
INSERT INTO nss_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Pe YAPAN ipa, <<Paratapeh wou ambusiy tehen tora? Ahilingiy! Ndreye nalim imuw ita pwan ara itarang isa kili yo. ");
INSERT INTO nss_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Pwen mahapo uten anam pe urasse wou aya mawen pwan iye, paratapeh, ndreye nalim ara imuw kinsusuhi pwan, pe mwoiwa ndreye nalim ara ita nimam i. ");
INSERT INTO nss_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kapa wou apa amangse piyang kiya ndrita pwan, andre hu anandrinam kasongut topwei. Pe wou andre ohorakohoyou hakol ka hakol tehen tora ko.>> ");
INSERT INTO nss_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pwen Kain ipwai iya kili YAPAN ipa, <<Nopwaran mahapo aniykiy kinsa kili yo ara kunlahiy para kukuniy pwi. ");
INSERT INTO nss_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mahapo napiyani yo nakuya mawen pwan iye, pe andre kunto nondriya pwokere tam pwi; andre kuro rakohoyou kol pwan hakol kiya hakol tora ko. Kapa hamou kipohonani yo ara andre kirayi yo.>> ");
INSERT INTO nss_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Hapeko YAPAN ipwai iyatan ipa, <<Andre pwi yoh. Kapa hiyeh kirayi wou, andre kuiki nopwaran namandran kiya kili yiy.>> Pe YAPAN irakinima Kain para hu ndramat kanime yiy andre hu kantayi yiy pwi. ");
INSERT INTO nss_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Pwen Kain iya mawen mbulmara YAPAN, pe iya iye kol hakol ngalan Not ita sahin iyapwen te kup para kol Yiten. ");
INSERT INTO nss_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain imatin iyapolo pihin tan pe mapundriyan, pe iyamulan imwalahiy iyata norun kamai ngalan Enok. Kain ihi kol hakol namandran pe ipohowe ngala kol ara iya pihisali norun Enok. ");
INSERT INTO nss_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Iyamulan Enok iyki norun hamou kamai isarayah, ngalan ara Irat. Pe Irat iyki Mehuyayel, pe Mehuyayel iyki Metusayel, pe Metusayel iyki Lamek. ");
INSERT INTO nss_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek iwiri pihin malmou, hamou ngalan Atah pe hamou ngalan ara Sillah. ");
INSERT INTO nss_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Atah imwalahiy ta Yapal, pe Yapal ara tumbuhu ndramat masih ngara hu koro yopai pe yihu ngara kahang hu kan para wum. ");
INSERT INTO nss_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ngala nalin hamou ara Yupal pe yiy ara tumbuhu ndramat masih mepo ngara kara ndramiy pe kuwah. ");
INSERT INTO nss_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sillah ara imwalahiy iyata norun hamou kamai ngalan Tupal-Kain; pe Tupal-Kain ara yiy ngara kimbusi hu menmena mbulen iyau kili pras pe hayen. Pe Tupal-Kain ara ma pisun hamou ngalan ara Naamah. ");
INSERT INTO nss_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek isikiye yiy iyata hilu pihin tan malmou ipa, <<Atah pe Sillah, alkahilingi yo na; walu nambuyu malmou kene kahilingi nongno. Ndramat hamou irayi yo pe uwiri neken, hapeko kunitingundrun kinmat; wihou hamou ara ihisili yo, pe kunta yiy kinmat. ");
INSERT INTO nss_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kapa hamou pakirayi Kain andre kiwiri ngandran maporoandrtisap; pe kapa hamou pakirayi Lamek ara, nopwaran tan andre kirayah namandran iya, tehe maporoandrtingui pe andrtisap.>> ");
INSERT INTO nss_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Atam imatin iyasura nambuyun paiwe pe imwalahiy iyata norun hamou kamai yi pe ipohowe ngalan Set. Pe Ewa ipa, <<Ngindrai koyun isikirani yo pe ihingini yo mbunah hamou kamai yi para kiya soiwi Apel, paratesah Kain irayi yiy pe kinmat.>> ");
INSERT INTO nss_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Pe Set ara iyki norun hamou kamai, pe ipohowe ngalan Enos. Tandrohongan ara iya, pwen hu ndramat huyoh ngala YAPAN pe huro totohun iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iye ara titiye ta ndraye noru Atam hu. Iro lang Ngindrai imangsani hu ndramat, imbusi hu pe husarayah tehe yiy opu. ");
INSERT INTO nss_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Imangsani hu ndramat, kamai pe pihin, pe iyoh yihu <<ndramat>>, pe itoholi hu iro mwonen lang mepo imangsani hu. ");
INSERT INTO nss_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Pwen Atam ara iyen pe hayou tan iro sangat pe tingui (130), pe iyki norun hamou kamai isarayah, mwensen tehe yiy opu, pe ipohowe ngalan Set. ");
INSERT INTO nss_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Iyamulan para iyki Set isa iro, Atam iyen pe hayou tan iro mandrolngat i (800), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Pwen Atam ara, hayou tan masih kene iya harong isarayah andrsongat pe tingui (930), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Pwen Set ara iyen pe hayou tan iro sangat pe yimah (105) pe iyki mbunah kamai hamou ngalan Enos. ");
INSERT INTO nss_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pe iyamulan para iyki Enos, Set iyen pe hayou tan iro androlngat pe andrtoyoh i (807), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Pwen Set ara, hayou tan masih kene iya harong isarayah andrsongat songui pe luwoh (912), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Pwen Enos ara iyen pe hayou tan iro andrsongui (90) pe iyki mbunah kamai hamou ngalan Kenan. ");
INSERT INTO nss_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pe iyamulan para iyki Kenan, Enos iyen pe hayou tan iro androlngat songui pe yimah i (815), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Pwen Enos ara, hayou tan masih kene iya harong isarayah andrsongat pe yimah (905), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Pwen Kenan ara iyen pe hayou tan iro andrtingui (70) pe iyki mbunah kamai hamou ngalan Mahalalel. ");
INSERT INTO nss_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pe iyamulan para iyki Mahalalel, Kenan iyen pe hayou tan iro androlngat pe haangui yi (840), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Pwen Kenan ara, hayou tan masih kene iya harong isarayah andrsongat pe songui (910), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Pwen Mahalalel ara iyen pe hayou tan iro annongui pe yimah (65) pe iyki mbunah kamai hamou ngalan Yaret. ");
INSERT INTO nss_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pe iyamulan para iyki Yaret, Mahalalel iyen pe hayou tan iro androlngat pe tingui yi (830), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Pwen Mahalalel ara, hayou tan masih kene iya harong isarayah androlngat andrsongui pe yimah (895), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Pwen Yaret ara iyen pe hayou tan iro sangat annongui pe luwoh (162) pe iyki mbunah kamai hamou ngalan Enok. ");
INSERT INTO nss_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pe iyamulan para iyki Enok, Yaret iyen pe hayou tan iro androlngat i (800), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Pwen Yaret ara, hayou tan masih kene iya harong isarayah andrsongat annongui pe luwoh (962), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Pwen Enok ara iyen pe hayou tan iro annongui pe yimah (65) pe iyki mbunah kamai hamou ngalan Metuselah. ");
INSERT INTO nss_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Pe iyamulan para iyki Metuselah, Enok iro tokai sura Ngindrai nondriya hayou matingat i (300), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Pwen Enok ara, hayou tan masih kene iya harong isarayah tingat annongui pe yimah (365). ");
INSERT INTO nss_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok irotokai sura Ngindrai, pwen yiy ara imun o mwaihei o, paratesah, Ngindrai kinwiri yiy kinnau. ");
INSERT INTO nss_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Pwen Metuselah ara iyen pe hayou tan iro sangat androlngui pe andrtoyoh (187) pe iyki mbunah kamai hamou ngalan Lamek. ");
INSERT INTO nss_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Pe iyamulan para iyki Lamek, Metuselah iyen pe hayou tan iro andrtingat androlngui pe luwoh i (782), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Pwen Metuselah ara, hayou tan masih kene iya harong isarayah andrsongat annongui pe androsih (969), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Pwen Lamek ara iyen pe hayou tan iro sangat androlngui pe luwoh (182) pe iyki mbunah kamai hamou. ");
INSERT INTO nss_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Yiy ipohowe ngalan Nowah pe ipa, <<YAPAN iten anapwan, hapeko mbunah iye andre kipwokarani worou kiya nopwaran pe ngandrahan para pwan.>> ");
INSERT INTO nss_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pe iyamulan para iyki Nowah, Lamek iyen pe hayou tan iro yimingat andrsongui pe yimah i (595), pe iyki mundruwa norun hu hayah kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Pwen Lamek ara, hayou tan masih kene iya harong isarayah andrtingat andrtingui pe andrtoyoh (777), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Iyamulan, Nowah ara hayou tan iro mayimingat (500), pe iyki hu mbunah kamai matimou–Sem, Ham, pe Yapet. ");
INSERT INTO nss_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Iro tandrohonga hu ndramat huro kol pwan ara ndromweyahu iropo iya soyon iya, pe huiki noruhu pihin. ");
INSERT INTO nss_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Pwen hu noru Ngindrai kamai hayah ara hu nime hu mbunah pihin ara lahayahu iya, pe hupo hu iya lohongai tahu ko. ");
INSERT INTO nss_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Pwen pe YAPAN ipa, <<Mwoiwo andre kinto kili hu ndramat lang masih pwi, paratesah yihu kansarayah tehe hu ndramat o mwaihei para kol pwan. Pwen yihu andre konto ndrangan niwen pwi yoh, pe hayou tahu andre kiho sangat pe lungui o (120).>> ");
INSERT INTO nss_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Imwonen tandrohonga lang ara pe kiyamulan i, yihu noru Ngindrai kamai ara huiki hu mbunah iyatahu pihindrahin para kol pwan. Pe noruhu ara husarayah hu ndramat namandran, niwen, pe pwokeyahu iya, pe mangalahu. ");
INSERT INTO nss_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Pe YAPAN inime kultuwayi hu ndramat huro kol pwan ara mwomwan pe namandran iya. Pe hu ndramat masih kene ara lohongahu pe ndriyahu ara huro mwomwan tehen tora ko lang sih tehe sih. ");
INSERT INTO nss_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Pe YAPAN ipa, paratesah umangsani hu ndramat pe hu mbusi tehen tora? Pwen ndriya Yapan ipworu tahu. ");
INSERT INTO nss_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Pwen YAPAN ipa, <<Hu ndramat masih mepo umangsani hu andre kupwalngani hu topwei. Andre kupwasili topwe hu ndramat, hu kan masih kene para wum pe para yangiy, hu kan para seselek, kiyasura hu norukan para wohowoh masih kene. Kapa kunmangsani hu pwi, ara hiyan masih.>> ");
INSERT INTO nss_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hapeko YAPAN ipwes iyata Nowah, pe koyun ara isikirani yiy. ");
INSERT INTO nss_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Iye ara titiye ta Nowah pe norun hu. Noru Nowah hu matimou kamai, ngalahu ara iye: Sem, Ham, pe Yapet. Pwen Nowah ara ndramat hamou imwonen iya kili hu ndramat masih tandrohongan ara. Hu ndramat konoho yirowe mwomwan ta Nowah pwi. Pe Nowah irotokai iyasura Ngindrai lang masih. ");
INSERT INTO nss_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hapeko hu ndramat huropo kol pwan, kultuwayi hu ara mwomwan masih iya mbulmara Ngindrai, pe tahatai ipwoke iro kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Pe Ngindrai inimnim isa kol pwan pe inime kultuw tahu ndramat masih kene para kol pwan masih ara mwomwan opu. ");
INSERT INTO nss_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Pwen Ngindrai ipwai iya kili Nowah ipa, <<Yo andre kupwasili topwe hu ndramat masih kiyasura kol pwan i, paratesah, kol pwan ipep iya tahatai pe kultuw mwomwan tahu ko. ");
INSERT INTO nss_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kiya, Nowah, asah pe aselehe hakou ndroyem kiya kei pwokeyan pe ndrisiyon. Arandrihi nondriyan, pe awiri nalit pe apene nondriyan pe ngawan kene. ");
INSERT INTO nss_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ambusi ndrohonga ndroi ara tehe toro: andrtingui pe yimingah ara niwen, pe mulai para aliy ara songui pe lungah pe haroh. Pe niwen para mbulu ndroi iro pwan pe iya paingan ara andrtingah pe haroh. ");
INSERT INTO nss_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Pe kapa ambusi ndrindroh kihipwen, pwen aiki mwalinga ndrupwokou pe kanuh ara pwopwowe lumou kiho paingan. Aiki papai ara kiho ngilse ndroi, pe arandrihi nondriya ndroi kiya matisap–kiro pwan, ndrokolon, pe paingan. ");
INSERT INTO nss_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Pe yo andre kuiki non namandran kirasumuluwani kol pwan kiyasura memelit masih makunuwehu, andre hu kahapwen topwei. ");
INSERT INTO nss_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Yo andre kurapaniu tisingiy kisa kili wou, pwen pe wou, nambuyum, norum hu pe mbuyu norum hu ara andre wawu masih kene kaya nondriya ndroi. ");
INSERT INTO nss_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Pe awiri hu kan hamou handra-hamou handra makunuwehu–hamou kamai pe hamou pihin–awiri hu kaya nondriya ndroi ka polo wou, pwen andre hu kanmat pwi. ");
INSERT INTO nss_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Hu norukan para wohowoh malmou-malmou, hu kan para yangiy pe para wum malmou-malmou, pe hu kan para seselek malmou-malmou andre hu masih kasa kili wou pe kaya nondriya ndroi, pwen andre hu kanmat pwi. ");
INSERT INTO nss_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Awiri anandrinai masih para kaniyai handra-handra ana wawu pe anahu kan i, pe aikiy kiya kaisowa anandrinai.>> ");
INSERT INTO nss_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Pwen Nowah ihilingiy pe imbusi melit masih tehe Ngindrai ipwatisingiy iyatan. ");
INSERT INTO nss_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Pwen YAPAN ipwai iyata Nowah ipa, <<Yo unime wou opu ata hiyan pe imwonen iya mwalinga hu ndramat masih para kol pwan. Pwen pe awiri wawu hapat o pe akaya kene nondriya ndroi. ");
INSERT INTO nss_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pe awiri hu kan para kaniyai–manandrtimou kamai pe manadritimou pihin. Pe yihu kan mepo konoho yan pwi ara awiri malmou–hamou kamai pe hamou pihin. ");
INSERT INTO nss_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Pe hu norukan ara tehen aliy yi; awiri hu manandrtimou kamai pe manandrtimou pihin, para hu kapo noruhu paiwe koro kol pwan. ");
INSERT INTO nss_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kiro lang manandrtoyoh andre kuiki mbulou kindrut kisa pwan. Pe andre kindrut kiya manne lang mahaangui pe ping mahaangui. Tehen tora ko andre kupwasili topwe memelit masih makunuwe hu iripo kol pwan mepo umangsani hu.>> ");
INSERT INTO nss_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Pwen Nowah imbusi melit masih tehe YAPAN kinpwatisingiy kinnatan. ");
INSERT INTO nss_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Iro tandrohonga mbulou indrut isa kol pwan, Nowah ara hayou tan iho mannongat (600). ");
INSERT INTO nss_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowah iyapolo nambuyun, norun hu pe mbuyu ngundran hu, yihu masih kene huya nondriya ndroi, paratesah, non pakeh nakirah. ");
INSERT INTO nss_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Hu kan para kaniyai pe hu kan para kaniyai pwi, iyasura hu kan masih para seselek pe norukan mepo para wohowoh, ");
INSERT INTO nss_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ara hu masih kene kamai pe pihin huya kili Nowah pe huya nondriya ndroi, tehe Ngindrai kinpwatisingiy kinna tan. ");
INSERT INTO nss_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pwen lang manandrtoyoh ara ihipwen, pwen non irah kol pwan. ");
INSERT INTO nss_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nowah hayou tan iro mannongat (600), pe iro mwonen lang songui pe andrtoyoh para walah luwoh, pwen pwan iramburing pe ndran isuw pe irambumbusau pe ingas isa ndrita pwan, pe mbulou indrut ikas iro paingan yang pe isa kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mbulou irondrut, irondrut, irondrut ipoo lang mahaangui pe ping mahaangui. ");
INSERT INTO nss_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Pe iro mwonen lang nepo mbulou indrut, Nowah, nambuyun pe norun hu matimou Sem, Ham, pe Yapet, iyasura nambuyu hu, huya nondriya ndroi. ");
INSERT INTO nss_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Pe hu kan para wum pe hu kan puyap para yangiy, pe hu kan para seselek iyasura hu norukan masih kene huya nondriya ndroi. ");
INSERT INTO nss_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Hamou kamai pe hamou pihin para kan handra-handra pe norukan handra-handra, hu memelit masih kene makunuwehu ara husa kili Nowah pe huya nondriya ndroi. ");
INSERT INTO nss_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Melit masih, hamou kamai pe hamou pihin, huya nondriya ndroi tehe Ngindrai ipwatisingiy iyata Nowah, pwen pe YAPAN iwari papai. ");
INSERT INTO nss_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Non irotah, irotah ipoo lang mahaangui, pe non ingas pe irasumuluwani kol pwan pe ihiri ndroi iho hin ndrita pwan. ");
INSERT INTO nss_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Non irah iya namandran iya iro kol pwan, pe ndroi ara iho raipit ndrita non. ");
INSERT INTO nss_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Non ingas iya paingan masih, pe iramburihi hu ngondron namandran masih kene para kol pwan. ");
INSERT INTO nss_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Irah pe ingas iya paingan masih pe irasumuluwani hu ngondron topwei. Pe ndrohonga ngondron pe ndrita non ara pakeh mahaangah. ");
INSERT INTO nss_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Melit masih makunuwehu iripo kol pwan ara humat topwei–hu norukan masih, hu kan namandran pe mendreheh masih para wum pe para yangiy, iyapolo hu ndramat masih, ara hu masih kene hu hupwen topwei. ");
INSERT INTO nss_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Pe melit masih mepo huro pwan posowen pe ma kunuwe hu huro luwi ngohahu ara hu mat topwei. ");
INSERT INTO nss_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Pe YAPAN ipwasili topwe memelit masih makunuwehu huro kol pwan–hu ndramat pe hu kan masih, hu kan para seselek pe hu norukan masih. Hapeko Nowah iyapolo hu masih kene huro nondriya ndroi ara huro mwalen. ");
INSERT INTO nss_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pe non ara kintamat pwi ipoo iya lang sangat pe yimingui (150). ");
INSERT INTO nss_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hapeko Ngindrai ara ilohongani Nowah iyasura hu kan pe hu melit masih makunuwehu huropolo yiy nondriya ndroi. Pwen Ngindrai imbusi nohai imayum, pe ndras pe non iro tayos iya pwan. ");
INSERT INTO nss_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pwan mepo iramburing pe ndran isuw pe irambumbusau isa paingan ara ihipwen, pe mbulou indrut ikas ara ihipwen i. ");
INSERT INTO nss_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Lang sangat pe yimingui (150) ihipwen, pwen non ara iro tayos hape, ");
INSERT INTO nss_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","pe lang songui pe andrtoyoh para walah andrtoyoh ihipwen, pwen ndroi ara iya kuw iya ngondron Hararat. ");
INSERT INTO nss_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pe non iro tayos isa pwan, pe hu ngondron sih-sih husarayah iro lang sih para walah songui. ");
INSERT INTO nss_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Iyamulan para lang mahaangui ihipwen, pwen Nowah itipe marasip para ndroi nepo imbusiy. ");
INSERT INTO nss_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Pe Nowah ipwandrisa norukan hamou lokuran iya pe kinmui pwi; yiy iya ihowoh pe irakayani ndroi ipoo non irayos pe pwan ipwasau. ");
INSERT INTO nss_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Pwen ipwandrisa pai hamou iya, para kinimei tehe non kintayos pwen kinna ndrita pwan ndre mapu. ");
INSERT INTO nss_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Hapeko non ara iro sumuluwani kol pwan ndron, pe pai ara kinnime hape kol pwosowen para kimpwan aliy ara pwi. Pwen iwoh imui iya ndroi, pe Nowah niman iyah iya ngawan pe iwiri pai imui isa nondriya ndroi, paratesah, non ara iro ndrita pwan manau. ");
INSERT INTO nss_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowah ilonge ipoo lang manandrtoyoh ihipwen i, pwen iyki pai iwoh iya ngawan paiwe. ");
INSERT INTO nss_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pwen kol iro piyah pe iwoh imui isa kili Nowah, pe iwiri kaimbuwe youkei hakap para kei holip iho pohon. Pwen Nowah inimei pe ipahasani tehe non ara kintayos kinna pwan hape yi. ");
INSERT INTO nss_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Pe Nowah ilonge iya lang manandrtoyoh ihipwen i, pwen ipwandrisa pai iwoh imui iya ngawan paiwe. Tandrohongan ara pai iya ko kinnayau masih, pe kinimui pwi. ");
INSERT INTO nss_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Pe Nowah hayou tan iro annongat pe sih (601), pe iro mwonen lang sih imu para wala sih imu, non ara kinhipwen masih, hapeko pwan ara kinpwasau hiyan mapu. Pe Nowah iwiri tamburuha ndroi hape iya mawen, pe maran iya pwan pe inime ndran kinsapak pe pwan ara iro pwasau. ");
INSERT INTO nss_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pe iro lang lungui pe andrtoyoh para walah luwoh, pwen kol pwan ara kinpwasau topwei. ");
INSERT INTO nss_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Pe Ngindrai ipwai iya kili Nowah ipa, ");
INSERT INTO nss_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","<<Akasa ngawan–wou pe nambuyum, norum hu pe mbuyu norum hu. ");
INSERT INTO nss_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pe melit masih makunuwehu tora nondriya ndroi ara awiri hu kasa pwan kiyasura wou–hu kan pe hu norukan para wohowoh, iyasura hu kan para seselek ara, hu masih kasa pwan, pe hu kapo noruhu pe hu kahon koro kol pwan pe hu kaya soyon iya.>> ");
INSERT INTO nss_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Pwen Nowah isa pwan iyasura nambuyun, norun hu, pe mbuyu norun hu. ");
INSERT INTO nss_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Yihu kan handra-handra, iyapolo hu kan para seselek pe hu norukan masih ara hu masih kene husa pwan topwei. Hu kan masih mepo ngara hu karikai pe kaselek ndrita pwan ara hunnon hayoi-hayoi pe hutuh ndroi husa pwan. ");
INSERT INTO nss_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Pwen Nowah isoye pere tuntun para yukyuk iya kili YAPAN. Pe iwiri hu kan pe hu norukan handra-handra para kaniyai, pe itimwi hu iya aliy tehe totohun iya kili YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Pe YAPAN ihingi ngonoho kosumwan itinam pe ndriyan ipwesaniy. Pe ipa, <<Konan kapa hu ndramat kambusi melit mwomwan mawihou tahu, hapeko yo andre kunuten ana pwan paiwe ara pwi. Pe yo andre kuntamari melit masih makunuwehu paiwe pwi tehe mahapo umbusiy.>> ");
INSERT INTO nss_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","<<Lang para kahasiy pe lang para karihiy, lang para kawulen pe lang para kangandrah, lang para mwandrai pe lang para mbulou, pe lang pe ping– melit masih aro andre kinihipwen pwi yoh. Andre kiro tehen tora ko kipoo kol pwan kihipwen.>> ");
INSERT INTO nss_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ngindrai itoholi Nowah iyasura norun hu pe ipwai iyatahu ipa, <<Akapo noru wawu; akahon pe ndromweya wawu kaya soyo soyon pe akapep kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Pe maram kiro nimnim ka tahu kan masih–hu norukan masih hora woh paingan, iyasura melit masih hu tora selek ndrita pwan pe hu ni masih tora ndras–yihu melit masih kene ara andre hu kanoh turut ta wawu ndramat. ");
INSERT INTO nss_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hu kan masih makunuwehu mepo hutora selek, hutora tokai, pe huhora woh, andre karayah anandrina wawu ndramat kiyasura menmena piyang tehe mamu. ");
INSERT INTO nss_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hapeko wou mbunayan sangi kan mepo ndrai itandron aliy, paratesah, ndrai ara ndroiyi taleh. ");
INSERT INTO nss_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Pe kapa sehe ndramat ndre kan kitingundru hamou ndramat kimat andre kiro tine mbulmoro pe kikuni nopwaran kiya melit mepo imbusiy. ");
INSERT INTO nss_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kapa hiyeh kirayi hamou ndramat kimat andre hu ndramat hu katingundrun kiya soiwin, paratesah, Ngindrai imangsani ndramat mwensen tehe yiy opu. ");
INSERT INTO nss_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pe wawu andre kapo noru wawu hu kaya soyon, pe ndromweya wawu kihon pe ndraye wawu hu andre kapep kol pwan masih.>> ");
INSERT INTO nss_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Pwen Ngindrai ipwai iya kili Nowah iyapolo norun hu ipa, ");
INSERT INTO nss_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","<<Mahapo yo nakurapaniu kiyasura norum hu pe ndrayem hu mepo andre hu kasarayah kamulan, ");
INSERT INTO nss_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","pe kiyasura melit masih makunuwehu–hu norukan pe hu kan para wum iyapolo hu kan para yangiy nepo husa mawen nondriya ndroi–pe melit masih makunuwehu topo ndrita kol pwan. ");
INSERT INTO nss_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yo uiki nongan para tapaniu isa kili wawu; pe yo andre kunmbusi non kingas pe kipwasili melit masih kene makunuwehu paiwe ara pwi; pe upwatisingi nongno tehe non andre kinrah pe kinrasumuluwani kol pwan paiwe ara pwi yoh.>> ");
INSERT INTO nss_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Pe Ngindrai ipa, <<Iye ara ndraikiya tapaniu to pwokeyan, urupo mbusiy mwelengo pe mwalinga wawu pe hu kan makunuwehu tora kili wawu; pe andre kinto-kinto hasap kiyau hasap. ");
INSERT INTO nss_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yo umbusi mwollou to hira kokom para ndraikiya tapaniu kiro mwele pe mwalinga kol pwan. ");
INSERT INTO nss_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kapa akanime uiki mburah kiramburuhi kol pwan pe maparamwandrayen, andre mwollou kisarayah kiho aliy. ");
INSERT INTO nss_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Pe andre kuro lohongani nongan para tapaniu mepo nakiro mwelengo pe mwalinga wawu kayasura hu kan masih makunuwehu handra-handra. Yo upwatisingi nongno tehe non andre kinrah paiwe para kipwasili topwe hu melit masih kene ara pwi. ");
INSERT INTO nss_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kapa mwollou kisarayah kiho kokom, andre kunimei pe kulohongani nongno para tapaniu andre kinto-kinto mwelengo pe mwalinga hu melit masih makunuwehu handra-handra hu tora kol pwan.>> ");
INSERT INTO nss_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Pwen Ngindrai ipwai iyata Nowah ipa, <<Mwollou iye ara ndraikiya lohonge pe nongan pwokeyan para tapaniu to mepo yo kuniykiy mwele pe mwalinga hu melit masih makunuwehu tora kol pwan.>> ");
INSERT INTO nss_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Pe ngala noru Nowah hu huro nondriya ndroi pe husa pwan ara iye: Sem, Ham, pe Yapet. (Ham ara tama Kenaan.) ");
INSERT INTO nss_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Yihu noru Nowah matimou ara husarayah tumbuhu ndramat masih pe hu silihi kol pwan masih kene. ");
INSERT INTO nss_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowah ara, yiy ndramat para mbulya piyang, pe ihisi piyang hambut iya mwisi wain. ");
INSERT INTO nss_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Iyamulan Nowah irapaiwani ndrunu wain ngahan, iyin pe maran imbui, pe iye matin yumwan pe mwayen pwi. ");
INSERT INTO nss_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Pe Ham, tama Kenaan, iya pe inime taman iye matin pe mwayen pwi. Pwen iyapwai iyata nalin malmou hilto ngawan. ");
INSERT INTO nss_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Hapeko Sem pe Yapet hilu wiri koyau hamou pe hiluikiy iye tondrih payandrupwese hilu. Pe hilu torokai te ndruwa hilu pe hilu ndrutihi tama hilu iya aliy. Pe hilu rikai te mara hilu imui, para hilu mbuna kanime tama hilu tehe mwayen pwi. ");
INSERT INTO nss_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Pwen pe pwoke para wain ihipwen, pe Nowah isatine pe ihilong sehe melit norun kopwan kinmbusi kinnatan. ");
INSERT INTO nss_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Pwen pe yiy iten ana Kenaan ipa, <<Wou andre aro pahandra nalim hu pe aya ndramat para poya mbulyahu ko mwaihei.>> ");
INSERT INTO nss_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Pe Nowah ipa toro: <<Kahari ngala YAPAN, Ngindrai ata Sem! Pe Kenaan ara andre kirayah ndramat para poya mbulya Sem o mwaihei. ");
INSERT INTO nss_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Pe Ngindrai andre kimbusi ndraye Yapet hu kaya soyon, pe ndrayen hu andre kampwan sura kamaye Sem. Pe Kenaan ara andre kirayah ndramat para poya mbulya Yapet o mwaihei yi.>> ");
INSERT INTO nss_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Iyamulan para non namandran, Nowah iyen pe hayou tan iro tingat pe yimingui yi (350). ");
INSERT INTO nss_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Hayou ta Nowah masih kene iya harong, ara irayah andrsongat pe yimingui (950), pwen pe imat. ");
INSERT INTO nss_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iye ara titiye ta noru Nowah hu–Sem, Ham, pe Yapet. Noru Nowah hu matimou ara hupo noruhu iyamulan para non namandran irasumuluwani kol pwan masih ihipwen. ");
INSERT INTO nss_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iye ara ngala noru Yapet hu kamai: Komer, Makok, Matai, Yawan, Tupal, Mesek, pe Tiras. ");
INSERT INTO nss_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Pe iye ara ngala noru Komer hu kamai: Askenas, Ripat, pe Tokarmah. ");
INSERT INTO nss_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Iye ara ngala noru Yawan hu kamai: Elisah, Tarsis iyapolo hu ndramat para Saiprus pe hu Totan. ");
INSERT INTO nss_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Pe ndraye noru Yapet hu, hu masumbuwe iya leng pe mbuson. Pe huyempwan kolohu hakol-hakol pe nongna kolohu ara handra-handra. ");
INSERT INTO nss_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Iye ara ngala noru Ham hu kamai: Kus, Misrayim, Put, pe Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Iye ara ngala noru Kus hu kamai: Sepa, Hawilah, Saptah, Raamah, pe Sapteka. Pe Raamah ara, ngala norun hilu malmou ara Sepa pe Tetan. ");
INSERT INTO nss_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ara iyki norun hamou i ngalan Nimrot. Yiy irayah ndramat hamou pwokeyan para pahun. ");
INSERT INTO nss_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","YAPAN iyki pwoke iya kili Nimrot pe irayah ndramat hamou pwokeyan para poya yohou. Pwen mahapo kapa hamou kisikiye hamou andre kipa, <<Wou tehe Nimrot imwonen, yiy ndramat para kahaya yohou mbulmara YAPAN.>> ");
INSERT INTO nss_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrot ara irayah yapene hu kol mahaakol iye: Papel, Erek, Akkat, pe Kalneh. Pe isarayah tehe king para kol mahaakol ara, hutora nondriya kol namandran Papilon. ");
INSERT INTO nss_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Pwen itali Papilon pe iya Assiriya pe imangsani hu kol namandran iye kene: Niniweh, Rehopot-ir, Kalah, ");
INSERT INTO nss_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","iyapolo Resen ara, ita mwalinga Niniweh pe mwalinga kol namandran Kalah. ");
INSERT INTO nss_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Hu noru Misrayim ara hu ndramat para Litiya, Anam, Lehap, Naptu, ");
INSERT INTO nss_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","pe iyapolo Patrus, Kasluh, pe hu para Kaptor. (Hu ndramat para Pilistiya ara husarayah ndrayehu Kasluh.) ");
INSERT INTO nss_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenaan ara iyki norun ndrihou ngalan Siton. Pe Kenaan ara tumbuhu Hit, ");
INSERT INTO nss_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","hu Yepus, hu Amor, hu Kirkas, ");
INSERT INTO nss_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","iyapolo hu Hipi, hu Ark, hu Sini, ");
INSERT INTO nss_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","pe iyapolo hu Arwat, hu Semar, pe hu Hamat. Iyamulan hu tumbu Kenaan ara hu masumbuwe. ");
INSERT INTO nss_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ndringa pwanehu Kenaan ara iro Siton, pe iya pakeh Kerar pe Kasa, pwen irapaiwaniy iyapwen te Sotom, Komorra, Atmah, pe Sepoyim, pe iya manne Lasa. ");
INSERT INTO nss_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ariyo ara noru Ham hu kamai, yihu yempwan kamayehu hawum-hawum, pe nongna kolohu ara handra-handra, pe huro kolohu hakol-hakol. ");
INSERT INTO nss_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem ara iyki norun hayah kamai pe isarayah tumbuhu Eper masih. Pe Yapet, nalin namandran ara Sem. ");
INSERT INTO nss_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Iye ara ngala noru Sem hu kamai: Elam, Assur, Arpaksat, Litiya, pe Aram. ");
INSERT INTO nss_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Pe ngala noru Aram hu ara Us, Hul, Keter, pe Mesek. ");
INSERT INTO nss_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksat iyki norun Selah, pe Selah iyki norun Eper. ");
INSERT INTO nss_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eper ara iyki norun malmou kamai: Pelek pe Yoktan. Iro tandrohonga Pelek isarayah iro, hu ndramat masih para kol pwan hu masumbuwe huya marakol. Pwen pe hupohowe ngalan ara Pelek, paratesah, mbulundroiyi nongan para ngalan <<Pelek>> iya nongna kolohu ara ipa <<masumbuwe.>> ");
INSERT INTO nss_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan ara iyki norun hu kamai, ngalahu ara iye: Almotat, Selep, Hasarmawet, ");
INSERT INTO nss_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","iyapolo Yerah, Hatoram, Usal, ");
INSERT INTO nss_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","iyapolo Tikla, Opal, Apimayel, ");
INSERT INTO nss_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","iyapolo Sepa, Opir, Hawilah, pe Yopap. Ariyo kene ara ngala noru Yoktan hu. ");
INSERT INTO nss_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kol mepo huro aliy ara ndringan iro Mesa iya manne Separ, ita mwalinga hu pahayi iyayau te paramwandrai ingas. ");
INSERT INTO nss_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ariyo ara ndraye noru Sem hu kamai, yihu yempwan kamayehu hawum-hawum, pe nongna kolohu ara handra-handra, pe huro kolohu hakol-hakol. ");
INSERT INTO nss_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Pe ariyo kene ara ndraye noru Nowah hu para wum hawum-hawum pe kol hakol-hakol. Iyamulan para non namandran ingas ihipwen, hu masih kene hurayah iro kili noru Nowah hu ko, pe hu masumbuwe huya kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Koluw kinna, hu ndramat masih para kol pwan nongna kol tahu ara handra ko, pe pohoweyan ara iya wule handra ko. ");
INSERT INTO nss_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Yihu rotokai yapwen te sahin para paramwandrai ingas, pe huyarayah iya pwan hambut ita Papilon, hu ndramat kenyen aliy pwi. Pwen pe huya hu mipwan aliy. ");
INSERT INTO nss_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Iyamulan huyen pe hamou ipwai iyata hamou hupa, <<Kiya, worou tukapo pwan nakak tiken, pe tukasuluyaniy kiyapolo memelit tiken. Pwen tukarangandrihiy kiya ngandraha mwan, pe kiya pwokeyan tehe hambut pat.>> Pwen tehen tora ko hu pwili wum tahu iya memelit tehe pat, pe melit handra tehe nalit. Pwen pe hu pene mwalinga pat iyawule pe iya pwokeyan masih. ");
INSERT INTO nss_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Pwen hupa, <<Kiya, mahapo natukambusi kol hakol namandran kiya kolorou pe natukapwili hawum wum namandran niwen pe payandrohan kiya wiri yang. Pwen hu ndramat masih para kol pwan andre hu kanimei pe kahari ngalarou pe andre tukanmasumbuwe kanna kene kol hakol-hakol pwi; andre tukeye wule ko.>> ");
INSERT INTO nss_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pwen YAPAN isa kol pwan, pe inime kol namandran pe wum niwen hu ndramat masih para kol pwan hu pwiliy iya iyoho paingan pakeh yang. ");
INSERT INTO nss_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Pwen YAPAN ipa, <<Mahapo hu ndramat masih iye ara hu hapat o, pe nongna kol tahu ara handra ko, pe hu ngara kapo mbuluyahu kawule. Kindrou pwi andre hu kambusi sehe lohonge kiya lohogai tahu ko. ");
INSERT INTO nss_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kiya, tukaya pwan pe tukaya peiwani nongna kol tahu. Pwen andre hamou kinlahiy para kipahasani nongna hamou pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Pwen YAPAN irasumbuwani hu, pe hu masumbuwe huya kene kol pwan masih. Pe hu hupwen mbulen o, pe kol namandran ara hu kanmangsaniy pwi. ");
INSERT INTO nss_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Iyamulan hupohowe ngala kol ara Papel, paratesah YAPAN irapaiwani nongna kol tahu imapaiwe para hamou andre kinhilingi nongna hamou pwi. Pe irasumbuwani hu pe hu masumbuwe huya kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iye ara titiye ta Sem. Tandrohonga hayou malwoh ihipwen para non namandran ingas kol pwan, pe noru Sem hamou kamai ngalan Arpaksat irayah imwonen hayou ta taman ara masangat (100). ");
INSERT INTO nss_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Iyamulan para norun Arpaksat, Sem iyen hayou mayimingat i (500), pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Pe Arpaksat hayou tan iho tingui pe yimah (35), pe iyki norun hamou kamai ngalan Selah. ");
INSERT INTO nss_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Pwen iyamulan para norun Selah, Arpaksat iyen hayou haangat pe royoh i (403) pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selah iyen pe hayou tan iho matingui (30), pe iyki norun hamou kamai ngalan Eper. ");
INSERT INTO nss_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Iyamulan para norun Eper, Selah iyen hayou haangat pe royoh i (403), pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eper iyen pe hayou tan iho tingui pe haahiu (34), pe iyki norun hamou kamai ngalan Pelek. ");
INSERT INTO nss_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Iyamulan para norun Pelek, Eper iyen hayou haangat pe tingui yi (430), pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek iyen pe hayou tan iho matingui (30) pe iyki norun hamou kamai ngalan Reu. ");
INSERT INTO nss_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Iyamulan para norun Reu, Pelek iyen hayou lungat pe androsih i (209), pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu iyen pe hayou tan iho tingui pe luwoh (32), pe iyki norun hamou kamai ngalan Seruk. ");
INSERT INTO nss_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Iyamulan para norun Seruk, Reu iyen hayou lungat pe andrtoyoh i (207) pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Pwen Seruk iyen pe hayou tan iho matingui (30) pe iyki norun hamou kamai ngalan Nahor. ");
INSERT INTO nss_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Pwen iyamulan para norun Nahor, Seruk iyen hayou malungat i (200) pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor iyen pe hayou tan iho lungui pe androsih (29) pe iyki norun hamou kamai ngalan Terah. ");
INSERT INTO nss_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Iyamulan para norun Terah, Nahor iyen hayou sangat songui pe androsih i (119), pe iyki norun hu hayah kamai pe pihin, iyamulan imat. ");
INSERT INTO nss_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah iyen pe hayou tan iho manandrtingui (70) pe iyki norun hu kamai matimou ngalahu Apram, Nahor, pe Haran. ");
INSERT INTO nss_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iye ara titiye ta Terah, tama Apram, Nahor, pe Haran. Iyamulan Haran iyki norun hamou kamai ngalan Lot. ");
INSERT INTO nss_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Iyamulan Haran iye sura taman Terah, pe imat iro kol Ur, mepo iyki yiy iro aliy. Kol Ur ara ita nondriya kol namandran tahu Kaltiya. ");
INSERT INTO nss_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Apram pe Nahor hilu yen, pe hilu yesou. Apram iwiri pihin hamou ngalan Sarai pe Nahor iwiri pihin hamou ngalan Milkah, nali Yiskah; tama hilu ara hamou o, Haran. ");
INSERT INTO nss_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai ara kinkun hamou mbunnah pwi masih. ");
INSERT INTO nss_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Pwen Terah iwiri norun kamai Apram, pe tumbun Lot, mepo noru Haran, pe mbuyu norun Sarai, nambuyu Apram, huyasura yiy, pe huyau. Terah iyasura hu masih, hutine pe hutali kol hakol ngalan Ur ita nondriya kol namandran Kaltiya, pe huyau hu pakaya kol namandran Kenaan. Hapeko huyau huya huye kol Haran pe hu mipwan aliy namu. ");
INSERT INTO nss_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Huya huyen aliy, pe Terah hayou tan iho lungat pe yimah (205) pwen iyamat iro Haran. ");
INSERT INTO nss_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","YAPAN ipwai iyata Apram ipa, <<Atine pe atali kolom pe yowem hu pe pwane tamam, pe aya kol hakol nakupwainganiy kisa kili wou. ");
INSERT INTO nss_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yo andre kumbusiy, pe ndrayem hu andre karayah soyon iya, pe andre kutoholi wou pe andre kumbusi ngalam kiya namandran, pe wou andre arayah lomwes kiya kili hu ndramat. ");
INSERT INTO nss_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yo andre kutoholi hiyeh kapa kitoholi wou, pe andre kuten ana hiyeh kapa kiten anam. Pe hu ndraye ndramat masih para kol pwan ara yo andre kutoholi hu kiyau hiyan atam.>> ");
INSERT INTO nss_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Apram ara hayou tan manandrtingui pe yimah (75) pe itali Haran pe iyau iya kol tehe YAPAN kinpwai kinna tan mamu. Pe Lot irikai iyasura yiy. ");
INSERT INTO nss_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Pwen Apram iwiri nambuyun Sarai pe noru nalin Lot iyasura meltahu masih pe hu ndramat masih para mbulyan mepo iwiri hu iro Haran pe huyau huya kol namandran Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Pwen huyarayah huyaliy pe Apram irotokai iya manne kei hakou namandran ngalan Moreh ita kol Sekem. Tandrohonga tokuyai tan iya nondriya kol namandran Kenaan ara hu ndramira Kenaan ara huro ndron aliy. ");
INSERT INTO nss_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","YAPAN isarayah iya kili Apram pe ipwai iyatan ipa, <<Yo andre kuhingini ndrayem hu kiya pwan iye kamulan.>> Pwen pe Apram isoye pere tuntun para yukyuk pe itohun iya kili YAPAN mepo isarayah isa kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Iyamulan Apram iyau iyapwen te kup, pe iyarayah iya pahayi sih namandran ita pakeh kol hakol ngalan Petel. Pwen pe iyen aliy pe ipwili wum tan iho ndrokolo kol malkol, Petel pe Ai. Petel ara ita sahin iyapwen te rai. Ai ara ita sahin iyapwen te kup. Pwen iyen aliy pe isoye pere tuntun para yukyuk paiwe pe itohun iya ngala YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Iyamulan Apram irakuhuye pe irikai iro hakol iya hakol ipoo iyarayah iya kol hakol namandran hape ngalan Nekep. ");
INSERT INTO nss_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Apram isa iro kol namandran Kenaan pe mundruwai namandran isarayah, pe itali Kenaan pe iya pwen masih iya Yisip para kimpwan aliy hape na. ");
INSERT INTO nss_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Apram irotokai nakiya pakeh Yisip pe ipwai iyata nambuyun ipa, <<Yo upahasaniy tehe wou ara pihin hamou lahayam iya. ");
INSERT INTO nss_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mahapo kapa takayarayah kaya Yisip, andre hu ndramat para Yisip kanime wou, pe hu kapa, <Pihin hira nambuyu Apram.> Pwen pe andre hu karayi yo kumat pe wou ayen. ");
INSERT INTO nss_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kapa hu kasok wou, apwai kiyatahu tehe wou pisu. Pwen andre hu kambusi hiyan sato pe hu kantayi yo pwi, paratesah, andre hu kanime wou pihin mwayih, pe hu kanamili wou.>> ");
INSERT INTO nss_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Apram isarayah isa Yisip pe hu ndramat para Yisip hu nime Sarai ara pihin hamou lahayan iya. ");
INSERT INTO nss_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Hu ndramat namandran para poho mbulen ta king tahu Yisip hu nime Sarai ara lahayan iya pe huya pwai iyata king, pe hu wiri yiy iya nondriya seu ta king. ");
INSERT INTO nss_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","King inime Sarai ara lahayan iya, pe iwiri yiy iya nambuyun pe ipomene Apram iya hiyan; ihang Apram hu sipsip, hu meme, hu mbulmwakau, hu tongkiy kamai pe pihin, pe hu kamel, pe hu ndramat para mbulyan–kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hapeko YAPAN ndrinan ilokuh, pe irakultuwani hu ndramat masih para wum ta king, paratesah king iwiri Sarai, nambuyu Apram, iya nambuyun. ");
INSERT INTO nss_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pwen king iyoh Apram isa kili yiy pe ipwai iyatan ipa, <<Paratesah pe wou apwasike yo apa Sarai ara pisum? Mbuwalim apwai sato ngawan tehe yiy ara nambuyum? ");
INSERT INTO nss_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Paratapeh pe wou apwasoyou apa Sarai ara pisum, pwen uwiri Sarai iya nambuyu? Kiya, iye; awiri nambuyum pe walu kayau.>> ");
INSERT INTO nss_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pwen pe king ipwandrisa hu ndramiran pe huya pwai iyata Apram para kiwiri nambuyun pe meltan masih pe hu kaya mawen Yisip. ");
INSERT INTO nss_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Pwen Apram iwiri nambuyun, noru nalin Lot, iyasura meltan masih, pe itine Yisip pe iyau iya kol ndrohoyin ngalan Nekep. ");
INSERT INTO nss_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Apram ara yiy ndramat hamou menmenan soyon iya; pe hu kan atan ara soyon, iyasura silwa pe kolt. ");
INSERT INTO nss_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Pwen irakuhuye pe itali Nekep pe iyeses ta hape ta hape ipoo iyarayah iya kol hakol ngalan Petel. Pe impwan kol mamu iyen aliy ndrokolo kol malkol Petel pe Ai, ");
INSERT INTO nss_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","kol mepo isoye pere tuntun para yukyuk iro aliy. Pwen pe itohun paiwe iya kili YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot ara irikai iyapolo Apram, pe meltan pe kannen pe hu ndramiran para poya mbulyan ara soyon iya i. ");
INSERT INTO nss_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Hapeko pwan mepo hilu yen aliy ara mbusukau o. Kinlahi hilu malmou kene pwi, paratesah, hilu malmou kene melta hilu ara soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Yihu ye wule pe takokowai irayah ndrokolo hu ndramat para mbulya Lot pe hu ndramat para mbulya Apram. Tandrohongan ara, ara yihu ndramira Kenaan pe yihu ndramira Peris ara huro pwan ara pe huro namnam iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Huyen pe Apram ipwai iyata Lot ipa, <<Talu hapat o; mbuna talu karakokowai mwalinga talu pe yihu ndramat para mbulya talu. ");
INSERT INTO nss_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Anime pwan namandran ita ko mwaihei? Talu nakasopat ara. Wou aya pwen te nimam mot pe yo kuya pwen te nimo kamou; pe kapa mbuwalim para aya pwen te nimam mot, kiya, aya pwen te nimam kamou pe yo kuya pwen te nimo mot.>> ");
INSERT INTO nss_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lang ara Lot itine pe maran isalti pwan hambut namandran ita pakeh ngilse Ndran Yortan. Pwan ara, ara ndrunun soyon iya, iya mane kol hakol ngalan Sowar ita pakeh Yisip, pe ndran para aliy ara tehe piyang ta YAPAN ngalan Yiten. (Lang ara, YAPAN kintakultuwani kol ngawan malkol Sotom pe Komorrah mapwi.) ");
INSERT INTO nss_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Pwen Lot inamili pwan namandran ariya, pe irakuhuye pe iyau iyapwen te kup. Pwen tehen tora ko pe Apram hilu Lot hilu sopat. ");
INSERT INTO nss_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Apram impwan Kenaan pe Lot iya impwan ndrokolo hu kol namandran huro ngilse ndran, pe ipwili yumwan iho pakeh kol ngwawan Sotom. ");
INSERT INTO nss_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Hu ndramat para kol Sotom ara kultuwayihu mwomwan namandran masih iya mbulmara YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Iyamulan para Lot kintali Apram, YAPAN isarayah iya kili Apram pe ipwai iyatan ipa, <<Orotine ndrohonokum pe maram kiyapwen te kup, hai, tolau, pe rai. ");
INSERT INTO nss_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Pwan masih mepo maram ita nimei ara andre kuikiy kisatam pe ndrayem hu kamulan, hasap kiyau hasap. ");
INSERT INTO nss_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yo andre kumbusiy pe ndrayem hu andre kasarayah soyon iya; tehe kohu pwan, pe kapa hamou ndramat kilahi kindromwa kohu pwan masih ita kol pwan, pwen andre kilahi kindromwa ndrayem hu yi. ");
INSERT INTO nss_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Atine pe arikai nondriya kol ara haroh kiya haroh pe sahin kiya sahin, paratesah, yo nakuiki pwan masih ara kisatam.>> ");
INSERT INTO nss_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Pwen Apram irakuhuye yiy pe iyeses ipoo iya Hepron pe ipwili yumwan iro pakeh kili hu kei namandran ata Mamre. Iyamulan iyen aliy pe isoye pere tuntun para yukyuk iya kili YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Lang ara Amrapel king tahu para kol hakol ngalan Sinar, Ariyok king tahu Ellasar, Ketorlawomer king tahu Elam, pe Tital king tahu Koyim, ");
INSERT INTO nss_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","hu king mahaamou ara huyapo pahun iyasura hu king mayimou iye: Pera king tahu Sotom, Pirsa king tahu Komorrah, Sinap king tahu Atmah, Semeper king tahu Sepoyim, pe king tahu Pela (mahapo hu pohowe ngala kol ara Sowar). ");
INSERT INTO nss_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hu king mayimou aro ara huya rawure hu ndramat tahu para pahun huya pwenten hambut ngalan Sittim ita ngilse ndras namandran. (Mahapo hu tora pohowe ngalan ara <<Ndras meren>>.) ");
INSERT INTO nss_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yihu king mayimou aro, ara ngara hu koro pahandra King Ketorlawomer hayou songui pe luwoh, pe hayou tahu pakiya songui pe royoh ndrinahu ilokuh ta King Ketorlawomer pe hu kanhilingi nongnan pwi. ");
INSERT INTO nss_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Iro hayou songui pe haahiu pwen Ketorlawomer iyoh hu king matimou husa kili yiy–Amrapel king tahu Sinar, Ariyok king tahu Ellasar, pe Tital king tahu Koyim. Husa huyasura hu ndramat tahu para pahun, pe hupo pahun huyasura hu Repa huro kol Asterot-Karnayim, pe huramwaitini hu. Pwen hungas kol Ham pe hupopahun pe huramwaitini hu ndramira Sus; pe hungas yangiy para kol Kiriyatayim pe hupopahun pe huramwaitini hu ndramira Em. Pwen pe hupopahun pe huramwaitini hu ndramira Hor huye pahayi namandran para Seyir, pe husani hu pe huwop iyapwen te kol Elparan, pakeh kili kol mepo ndramat konohoyen aliy pwi. ");
INSERT INTO nss_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Iyamulan Ketorlawomer pe hu ndramat para pahun tan hu peiwani hu pe humui huya kol Kates, ngalan handra mamu ngara hu kapohowei Enmispat. Hupopahun pe huramwaitini hu ndramat para pwan masih tahu Amalek pe huramwaitini hu Amor i, huro kol Hasason Tamar. ");
INSERT INTO nss_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Pwen hu king mayimou tahu Sotom, Komorrah, Atmah, Sepoyim, pe Pela iyapolo hu ndramat tahu para pahun huya rawure hu huya pwenten hambut ngalan Sittim. ");
INSERT INTO nss_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Pwen huya huyen aliy pe huya popahun iyapolo hu king mahaamou, Ketorlawomer king tahu Elam, Tital king tahu Koyim, Amrapel king tahu Sinar, pe Ariyok king tahu Ellasar. Hu king mahamou iye ara hupo pahun iyapolo hu king mayimou. ");
INSERT INTO nss_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Hupo pahun huya, pe king tahu para Sotom pe king tahu Komorrah hilu wop iyasura hu ndramat ta hilu hayah para pahun. Hapeko hu hayah huya yos iya ngat hayah mburan iro pwenten para Sittim, pe hu masih huwop huya ngondron. ");
INSERT INTO nss_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ketorlawomer iyasura hu king matimou aro ara yihu wiri meltahu ndramat para Sotom pe Komorrah iyasura anandrinahu pe huyau. ");
INSERT INTO nss_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Pwen pe hu wiri noru nali Apram, Lot, pe meltan masih, paratesah, irosura hu. ");
INSERT INTO nss_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hapeko ndramat hamou iwop pe iyarayah iya kili Apram pe iya nese ndrainga Apram. Ndramat mepo iwop ara, ara yiy hamou Hipuruw. Apram iye pakeh kili hu kei namandran ata Mamre. Mamre ara, yiy hamou ndramira Amor. Yiy pe nalin hilu, Eskol pe Aner, yihu matimou kene ara, ara yihu kowase Apram. ");
INSERT INTO nss_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Apram ihilingi nongan iro kili ndramat aro ipwai iyatan tehe pahun namandran irayah iro Sotom pe hu kanwiri noru nalin Lot pe meltan masih pe hu kanyau. Pwen pe Apram ndrinan ilokuh pe iyoh hu ndramiran tingat songui pe androlmou (318), hu ndramat para pahun para wum tan. Pwen huya po pahun iyapolo hu king mahamou mepo hu wiri Lot iyasura hu pe husani hu iya matne kol hakol ngalan Tan. ");
INSERT INTO nss_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kol iping pe Apram iwong iyatahu ndramat para pahun, pe ipwai iyatahu para hu hayah hu kayau hasai pe hu hayah hu kayau hasai, pe huyau huya popahun. Husani King Ketorlawomer iyasura yowen hu pe huwop iyapwen te kol hakol ngalan Hopah. Hopah ara kol hakol iyapwen te hai ndruwa kol namandran Tamaskus. ");
INSERT INTO nss_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Pwen pe iwiri melit masih mepo hu pahanowei iyasura noru nalin Lot pe meltan masih iyapolo hu pihin pe ndramiran hu. ");
INSERT INTO nss_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Iyamulan para Apram isani King Ketorlawomer iyasura hu king matimou hu kanyau, yiy imui isa, pe king tahu Sotom iya pohonani yiy iro pwenten sih ngalan Sapeh ngara hu kapohowei <<Pwenten ta King.>> ");
INSERT INTO nss_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Pwen Melkisetek, mepo king para Salem pe yiy ndramat hamou para mbulya Ngindrai iyera Paingan Masih, ara isap ana Apram ndrinanohun pe wain isa ngawan kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Pwen pe itoholi Apram ipa, <<Ngindrai iyera Paingan Masih, mepo imbusi kol pwan pe yang andre kitoholi wou. ");
INSERT INTO nss_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Pe tukahari ngala Ngindrai kiya paingan masih, paratesah, yiy irosura wou pe apo pahun iyapolo hu ndram para pahun pe arayi hu pe asani hu huyau topwei.>> Pwen Apram itaingani memelit masih mepo iro kili yiy iya pwelekei masongui pe iyki pwelekei sih ara iyata Melkisetek. ");
INSERT INTO nss_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Iyamulan king tahu Sotom ipwai iyata Apram ipa, <<Aiki hu ndramiro kamui, pe melit masih ara atam.>> ");
INSERT INTO nss_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Hapeko Apram ipwai iyata king tahu Sotom ipa, <<Uhuri nimo iya paingan pe upwai ngawan iya mbulmara YAPAN, Ngindrai iyera Paingan Masih mepo imbusi kol pwan pe paingan yang, pe urandrangan ");
INSERT INTO nss_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","tehe, yo andre kunpo handra meltam pwi masih. Matisan kamulan apa, <Yo ko umbusi Apram pe iya ndramat hamou namandran pe meltan soyon!> ");
INSERT INTO nss_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Yo andre kunpo handra melit pwi masih. Yo andre kuwiri memelit mepo hu ndramat to kanyaniy, pe iyasura memelit hayah tahu ndramat matimou ngalahu ara iye: Aner, Eskol, pe Mamre. Yihu matimou ara ko andre hu kapo memelit.>> ");
INSERT INTO nss_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Iyamulan YAPAN iwong iya kili Apram iya taltal, pe ipwai iyatan ipa, <<Apram, mbuna anoh. Andre kupenani wou iya sehe mwomwan kisarayah kili wou, pe andre kuiki memelit soyon iya kiya kasawem.>> ");
INSERT INTO nss_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Hapeko Apram ihilingiy pe ipa, <<O, YAPAN NGINDRAI, wou naiki tesah ndrokonan kisa to? Konan. Yo noru pwi pe melto masih kene iripo andre sehe ndramat maran kiro aliy? Yo ndramiro hamou o ara Eliyeser para kol Tamaskus. ");
INSERT INTO nss_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pe anhang yo hamou mbunah pwi. Pwen andre ndramat para poya mbuluyo ara andre maran kiro melto masih.>> ");
INSERT INTO nss_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pwen pe Apram ihilingi YAPAN iwong iya kili yiy paiwe ipa, <<Ndramat para poya mbulyam ara andre kinwiri meltam masih kene pwi yoh. Norum, ndreyem imwonen andre kiwiri nokum pe kinimnim kiya meltam masih.>> ");
INSERT INTO nss_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Pwen YAPAN iwiri yiy iya ngawan pe ipwai iyatan ipa, <<Maram kiya paingan pe anime piriy masih hora yang. Alahi andromwa hu? Pwi yoh! Tehen tora ko ndrayem hu andre karayah tehen aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Apram ihilingiy pe ilohongani tisingi nongna YAPAN ara ndrokonan masih. Pwen pe YAPAN ipohowe Apram ara ndramat hamou imwonen masih. ");
INSERT INTO nss_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Pwen YAPAN ipwai iyatan ipa, <<Yo YAPAN mepo uwiri wou asa mawen kol Ur, ita nondriya kol namandran Kaltiya, para kuiki pwan iye kisatam pe kiya pwanem.>> ");
INSERT INTO nss_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Hapeko Apram ipwai iyatan ipa, <<YAPAN NGINDRAI, yo andre kupahasaniy tehe tapeh mepo pwan aro nakiya mbukenan yo?>> ");
INSERT INTO nss_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Pwen YAPAN ipwai iyata Apram ipa, <<Aya wiri mbulmwakau hamou pihin, meme hamou, pe sipsip hamou kamai, hu kan masih, ara hayou tahu maroyoh, pe kiyasura pai malmou.>> ");
INSERT INTO nss_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Apram iya wiri hu kan masih tehe YAPAN ipwai iyatan, pe iwiri hu husa kili yiy. Pwen iralle hu iya maltoh pe iyki hu haroh iya sahin pe haroh iya sahin, haroh iye ngilse haroh, pe hilu pai o ara kintalle hilu pwi. ");
INSERT INTO nss_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pwen hu mannah tiken huwoh husa pwan pakasa sap ana hu, hapeko Apram imbultahahu pe huwoh. ");
INSERT INTO nss_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lang ara paramwandrai pakeh nakiyalai, pe matiliu irayi Apram, pe iye pwan pe imatin turut. Pwen inime melit handra mburuhan-mburuhan isarayah isa kili yiy tehe nihinih pe inoh turuwe yiy. ");
INSERT INTO nss_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Pwen YAPAN iwong iya kili yiy ipa, <<Wou apahasaniy tehe ndrayem hu andre kampwan kol hakol mepo kolohu pwi, pe andre kapo mbulen kaya pahandra hu ndramat para kol ara. Pe andre hu karayah hu ndramat para poya mbulen o mwaihei tahu, pe hu ndramat para kol ara andre hu karandrondroyani ndrayem hu kipoo hayou mahaangat. ");
INSERT INTO nss_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kiyamulan andre kurakultuwani hu ndramat masih para kol namandran ara kiya mwomwan masih. Pe kamulan para aliy andre ndrayem hu kasa mawen kol namandran ara kiyasura meltahu soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pe wou ara andraya parangoloh masih, pe kimat tam ara andre kisarayah waison o. Pe norum hu andre hu karoni wou oho ndruwa tamam pe tumbum hu. ");
INSERT INTO nss_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Pwen kiyamulan masih ndrayehu mahaasap andre hu kamui kasa kol aripo. Hapeko mahapo ara, takultuw mwomwan tahu Amor ara hiramwak ndron.>> ");
INSERT INTO nss_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Paramwandrai kinna lai pe kol kinlokuh, pwen Apram inime kosumwan irotinam kohoyonga mwan, pe mwan iro yat paisui. Melit malndra ara hilu ro yau mwalinga hu kan mepo kintalle hu pwen huro pwan. ");
INSERT INTO nss_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Iro mwonen lang ara YAPAN ipwai iyata Apram ipa, <<Mahapo talu nakaramwaniye kiya hiyan–tehe yo andre kuiki pwan kiro matne Ndran Yisip kiya matne Ndran Namandran Yuprates kiyata ndrayem hu. ");
INSERT INTO nss_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Pwan ara mahapo yihu ndramira Ken, Kenis, Katmon, ");
INSERT INTO nss_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit, Peris, Repa, ");
INSERT INTO nss_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor, Kenaan, Kirkas pe Yepus hu yerampwan aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai ara nambuyu Apram hilyesou ndrangan niwen iya, hapeko Sarai kinkun hamou noru Apram ara pwi. Pwen Sarai ma pihin tan hamou pihi Yisip para poya mbulyan, ngalan ara Hakar. ");
INSERT INTO nss_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Iyamulan Sarai ipwai iyata Apram ipa, <<YAPAN mbuwalin para yo kukun hamou mbunah. Pwen pe lohongai to ipa ndre hiyan para amatin kiyapolo Hakar pe yiy andre kikun mbunah kiya soiwim.>> Apram ihilingiy pe ipa hiyan iya lohonga Sarai. ");
INSERT INTO nss_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Pwen Sarai iyki Hakar pihi Yisip iya kili Apram tehe nambuyun para hilkapo mbunah. Hayou masongui ihipwen para Apram iye Kenaan, pwen lohonge aro irayah. ");
INSERT INTO nss_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Pwen Apram iwiri Hakar pe imatin sura yiy. Pe Hakar ipahasaniy tehe yiy ara mapundriyan, pwen iya pe iho timwak pe iho tingani ndriyan mbulmara Sarai. Pwen pe Sarai ndrinan ilokuh. ");
INSERT INTO nss_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Pwen Sarai ipwai iyata Apram ipa, <<Wou ambusiy pe Hakar hira rapwespwes mbulumoro pe imbusi yo tehe hamou pihin mwaihei. YAPAN o andre kiramwaniye mwalinga talu.>> ");
INSERT INTO nss_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Apram ipwai iyata Sarai ipa, <<Hiyan. Hakar, pihin para poya mbulyam ara, ita pahandram o. Ita lohongai tam o apambusi tapeh kiyatan.>> Pwen Sarai ihilingi nongna Apram, pe irasisingat ana Hakar pe Hakar iwop. ");
INSERT INTO nss_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hakar iyau iya iye kol mwaihei pakeh sohomwiying handrang ngilse sai iya kol Sur. Pe angelou ta YAPAN hamou iyarayah iya kili yiy ");
INSERT INTO nss_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","pe ipa, <<Hakar, wou ara pihin para poya mbulya Sarai. Pe wou ayau aleheh pe naya aleheh?>> Hakar ipwai iyata angelou ipa, <<Yo uwop ta Sarai, paratesah, yiy irasisingat ano.>> ");
INSERT INTO nss_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Pwen angelou ta YAPAN ipwai iyata Hakar ipa, <<Amui aya kili Sarai; ahalingi yiy pe aro pahandran para poya mbulyan.>> ");
INSERT INTO nss_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Pe ipwai iyatan paiwe ipa, <<Yo andre kumbusiy pe ndrayem hu andre karayah soyon iya pe kinlahi hamou kindromwa hu pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pwen angelou ta YAPAN ipwai iyatan paiwe ipa, <<Wou mapundriyam, pe wou andre amwalahiy kiyata mbunah hamou kamai, pe andre apohowe ngalan ara Yismayel, paratesah, YAPAN kinhilingi ndringem para koisirai. ");
INSERT INTO nss_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hapeko norum andre kiyen pe mipwan tan andre kimbus tehe hamou puyap para yangiy. Yiy andre kihimwomwan kiyatahu ndramat masih pe hu ndramat masih andre hu kahamwomwan kiya kili yiy. Yiy andre kinikuw sura nalin hu hiyan pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Angelou iwong ihipwen pe kinyau, pe Hakar iyen, iro lolohonge. Pwen ipohowe ngala YAPAN mepo iwong isa kili yiy ara, <<Ngindrai mamaran pe inime yo;>> paratesah, ipa, <<Yo unime hiyeh ngara kinime yo.>> ");
INSERT INTO nss_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Pwen pe mahapo hu ndramat hu pohowe ngala ndrikou ara <<Peer-Lahai-Roi,>> ita tehen tora ko ita ndrokolo kol malkol, Kates pe Peret. ");
INSERT INTO nss_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Pwen Hakar imwalahiy iyata noru Apram kamai, pe Apram ipohowe ngalan ara Yismayel. ");
INSERT INTO nss_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Pwen pe Apram hayou tan iho androlngui pe anoh (86) pwen Hakar imwalahiy iyata norun kamai, Yismayel. ");
INSERT INTO nss_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Apram hayou tan andrsongui pe androsih pe YAPAN iyarayah iya kili yiy pe ipwai iyatan ipa, <<Yo ara Ngindrai Pwokeyan Masih. Ahalingi yo pe oho ndruwa nongno pe ambusi melit masih hiyan. ");
INSERT INTO nss_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Pwen andre kumbusi tapaniu mwalinga talu pe andre kumbusi ndrayem hu kasarayah soyon iya.>> ");
INSERT INTO nss_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Apram itukuruhu pe payan iya iye ndrita pwan pe Ngindrai ipwai iyatan ipa, ");
INSERT INTO nss_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","<<Mahapo talu nakarapaniu, pe upwai ndrokonan tehe wou andre arayah tumbu hu ndraye ndramat soyon andre hu koro kene kol pwan. ");
INSERT INTO nss_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kiro matinen mahapo kiya andre hu kanpohowe ngalam Apram pwi; andre hu kapohowe ngalam ara kiya <<Apraham,>> paratesah, yo andre kumbusiy pe wou ara andre arayah tumbuhu ndraye ndramat soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Pe yo andre kumbusi ndrayem hu kasarayah soyon, pe hayah tahu andre hu kasarayah hu king. ");
INSERT INTO nss_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Yo nakurapaniu mwalinga talu kiya nongan to, andre kiro kili wou kiya lang kamulan pe nongan to andre kinhipwen pwi. Yo ara Ngindrai tam pe Ngindraye ndrayem hu mepo nakasarayah kamulan. ");
INSERT INTO nss_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yo andre kuiki pwan masih para Kenaan satam. Mahapo atampwan aliy tehe hamou ndramat mawen. Hapeko andre kuikiy kisatam pe ndrayem hu kamulan, hasap kiyau hasap, pe kiya kolohu. Pe hu keyen aliy lang masih, pe yo andre kurayah Ngindrai tahu.>> ");
INSERT INTO nss_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Pwen Ngindrai iwong iya kili yiy ipa, <<Wou pe ndrayem hu kamulan, wawu masih kahilingi tapaniu to pe kapotisingiy kiya hiyan. ");
INSERT INTO nss_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Wou pe ndrayem hu kamulan, wawu masih nongna wawu pe lohonga wawu masih kiya handra ko para kasondriti kapilo wawu kamai masih. ");
INSERT INTO nss_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Pe wou ara andre hamou kisondriti kapilom, pe andre kipwainganiy tehe nongna talu pe lohonge tatalu ara handra ko tehe talu tapaniu. ");
INSERT INTO nss_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Pe hu mbunah kamai masih mepo tinahu kinmwalahiy tahu, pe lang tahu iro mandrolwoh ara, andre kasondriti kapilohu masih–hu mbunah noruhu ndramat para wum tam, pe noruhu ndramat para poya mbulyam, pe kiyasura hu mbunah tahu ndramat mepo asou hu, huro kol hayah mawen mepo ndrayem imwonen pwi. ");
INSERT INTO nss_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hu mbunah kamai masih tinahu humwalahiy iyatahu huro wum tam, pe hu kamai masih atasou hu huro kol mwanan ara hu masih kahilingiy pe kasondriti kapilo hu. Pwen andre nongan to uikiy ara andre kisarayah kiro sangi wawu pe andre kipwaingani tapaniu to, pe andre kinihipwen pwi. ");
INSERT INTO nss_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kapa hamou kinhilingi nongan ato pwi pe hu kansondriti kapilon pwi, ara andre kiya mawen kili ndramiro hu mepo hu kansondriti kapilohu pwen. Pe andre kintayah yowe pwi, paratesah, yiy kintanuhuyani tapaniu to pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Pwen Ngindrai ipwai iyata Apraham ipa, <<Mahapo mbuna apohowe ngala nambuyum Sarai, kiro mahapo kiya apohowe ngalan kiya Sarah. ");
INSERT INTO nss_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yo andre kutoholi yiy, pe yiy andre kimwalahiy kiyata norum hamou kamai. Pe andre kutoholi Sarah, pe ndrayen hu andre kasarayah soyon iya, pe hu king hayah andre karayah kili ndrayen hu.>> ");
INSERT INTO nss_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Apraham itukuruhu pe payan iya iye ndrita pwan pe ilohonganiy pe ihai, pe ipa, <<Sehe ndramat ndrokonan mepo hayou tan kinna masangat pwen pe andre kipo mbunah? Sarah, hayou tan andrsongui, ita ilahi para kimwalahiy kiyata hamou mbunah?>> ");
INSERT INTO nss_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yiy ipwai iyata Ngindrai ipa, <<Konan. Hiyan para maram kiro ta Yismayel pe atoholi yiy?>> ");
INSERT INTO nss_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Hapeko Ngindrai ipwai iyatan ipa, <<Pwi yoh! Nambuyum Sarah ara andre kimwalahiy kiyata norum hamou kamai, pe andre apohowe ngalan ara kiya Yisak. Pwen andre kurapaniu kiyasura yiy, pe tapaniu to andre kinto-kinto kili ndrayen hu kamulan pe andre kinihipwen pwi. ");
INSERT INTO nss_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pe yo kunhilingi nongnam mamu asike yo iyata Yismayel. Pwen yo andre kutoholi yiy pe andre kuhingini yiy hu mbunah soyon pe ndrayen hu andre kasarayah soyon iya. Pe yiy andre kiya tamahu ndramat namandran songui pe lumou pe andre kumbusi yowen hu karayah pwokeyahu iya. ");
INSERT INTO nss_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hapeko yo andre kuiki nongan to para tapaniu ara kiya kili norum Yisak. Pe walah songui pe luwoh kihipwen, noru Sarah ara kinsarayah.>> ");
INSERT INTO nss_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Iyamulan para Ngindrai iwong iyata Apraham ihipwen, Apraham iyen pe yiy iyau. ");
INSERT INTO nss_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Iro lang ara ko, Apraham ihilingi nongna Ngindrai pe isondriti kapilo norun Yismayel iyapolo hu kamai masih para wum kili yiy, iyasura hu kamai para poya mbulyan mepo kinsowani hu. ");
INSERT INTO nss_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Apraham ara hayou tan iro andrsongui pe androsih pe hu sondriti kapilon, ");
INSERT INTO nss_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","pe norun Yismayel ara hayou tan iro songui pe royoh. ");
INSERT INTO nss_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Hilu malmou kene hu sondriti kapilo hilu iro nondriya lang sih o, ");
INSERT INTO nss_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","iyasura hu kamai masih para wum tan, pe hu kamai masih para poya mbulyan. ");
INSERT INTO nss_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lang sih ndrokolo lang pe paramwandrai ara ngandrahan iya, pwen YAPAN iyarayah iya kili Apraham. Apraham iyempwan pohomara kamai tan iro pakeh kili hu kei namandran ata Mamre. ");
INSERT INTO nss_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Apraham iyempwan pe payan pakitandras pwi, inime hu ndramat matimou huro tine. Pwen ihimbuh iya pe iyarapohonani hu, pe itukuruhu pe payan iya iho ndrita pwan. ");
INSERT INTO nss_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Pwen pe ipwai ipa, <<Yapane, kapa apwes sato, hiyan para kusopwat wawu. ");
INSERT INTO nss_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Wawu keyen iye pe yo kuyapwai kiyata hamou para kipo hape ndran kisa. Pe wawu kasungani ndrika wawu kihipwen, pwen wawu kayangoh kaya pahandra kei iye. ");
INSERT INTO nss_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Akamin; pe yo kuyapo hape anandrinai kisa pe wawu kainiy pe andre kipwokeyani wawu para wawu kayau. Wawu sa kol to pe yo upwes para kusopwat wawu.>> Pwen hupwai iyatan hupa, <<Hiyan, apo. Yowu rawuloh iya lohongai tam.>> ");
INSERT INTO nss_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Apraham ileheleh iya kamai tan, pe ipwai iyata Sarah ipa, <<Kileh, aya wiri palawa sahat namandran mepo anrahiy pe kinna wawan masih, ara awiriy kisa, asulyaniy, pe atun hayah ndrinanohun.>> ");
INSERT INTO nss_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pe yiy ingap iya kili hu mbulmwakau tan pe ipirani noru mbulmwakau hamou mepo sangin imuh. Pe iwiriy iya kili ndramat hamou para poya mbulyan pe imbusiy leheleh pe iya mwan. Imayis ihipwen, pwen iwiriy pe iyaikiy iya kili Apraham. ");
INSERT INTO nss_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Pwen Apraham iwiri sis, pe susu mbulmwakau pe noru mbulmwakau ariya pe yiy mbukenan iykiy iya kili hu matimou pe huyan. Huro namam pe yiy ara iro tine pahandra kei hakou ngilse hu. ");
INSERT INTO nss_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Pwen hu sike yiy hupa, <<Nambuyum Sarah aleheh?>> Apraham ipwai iyatahu ipa, <<Yiy iyera kamai.>> ");
INSERT INTO nss_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Hamou tahu ipwai iyatan ipa, <<Walah songui pe luwoh kihipwen, pe kumui kusa, pwen andre noru Sarah hamou kamai kiro.>> Sarah iro pohomara kamai ndruwa ndramat mepo iro wong ara, pe ihilingi nongan masih ndramat ara iropwai. ");
INSERT INTO nss_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Apraham pe Sarah ara hilu kanna parangoloh pwen pe hilu kanlahiy para kapo mbunah pwi, pe Sarah ara kinhipwen sapiya walah tan. ");
INSERT INTO nss_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Pwen Sarah ihaisani yiy mbukenan pe ipa, <<Mahapo kunna pihi parangoloh masih, pe nomwule pwen. Pe namandran ato kinna parangoloh pwen i. Pe andre kumatin kuyapolo kamai to pe youlu kapwes pe kapo mbunah tapeh?>> ");
INSERT INTO nss_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pwen YAPAN isike Apraham ipa, <<Paratapeh Sarah ihai pe ipa, <Yo andre kupo mbunah tapeh, mepo yo kunna pihi parangoloh pwen?> ");
INSERT INTO nss_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Sehe melit pwokeyan mepo kinlahiy para YAPAN kimbusiy pwi yeh? Tehe kunpwai, walah songui pe luwoh kihipwen, pe pakusa, pwen andre noru Sarah hamou kamai kinsarayah pwen kiro.>> ");
INSERT INTO nss_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah ihilingi nongna YAPAN pe inoh. Pwen pe ipwasoyou ipa, <<Pwi yoh, yo kunhai pwi!>> Pwen YAPAN ipwai iyatan ipa, <<Pwi; wou ahai ndrokonan.>> ");
INSERT INTO nss_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pwen hu ndramat matimou huyau huya ngondron pe marahu iya kol ngawan Sotom, pe Apraham irikai iya surahu pe iyaiki hu huya sai. ");
INSERT INTO nss_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pwen YAPAN iwong iya lohongan ipa, <<Yo andre kunkohoni handra lohongai kili Apraham pwi, para sehe lohongai nakumbusiy. ");
INSERT INTO nss_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ndraye Apraham hu andre karayah soyon pe pwokeyahu ya, pe andre kutoholi kol pwan masih kiyau kili Apraham. ");
INSERT INTO nss_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Yo kunpohowe yiy para kiwong pwokeyan kiya kili norun hu masih pe ndrayen hu, para hu kahilingi yo pe kambusi melit masih hiyan pe kimwonen. Kapa hu kambusi lohongai masih tehe kunpwai, yo andre kumbusi memelit masih tehe kunpwatisingiy kinna tan.>> ");
INSERT INTO nss_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Pwen YAPAN ipwai iya kili Apraham ipa, <<Yo kunhilong nongan soyon tehe kol Sotom pe Komorrah ara kultuw tahu mwomwan pe namandran masih. ");
INSERT INTO nss_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Yo andre kuyapwan pe andre kuya nime kultuwayihu tehe kunhilong ara ndrokonan ndre pwi, pe andre kupahasaniy.>> ");
INSERT INTO nss_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pwen hilu ndramat malmou hilyau hilya pwen te Sotom, pe Yapan o irondron sura Apraham. ");
INSERT INTO nss_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Pwen Apraham iya pakeh kili YAPAN pe isike yiy ipa, <<Apwai ndrokonan–andre apwasili hu ndramat hiyan kiyapolo hu ndramat mwomwan? ");
INSERT INTO nss_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Pe kapa hu ndramat hiyan tora kol ara hu mayimingui, andre apwasili hu topwei, ndre konan, hu koro?–paratesah, hu ndramat hiyan ara mayimingui hu toraliy. ");
INSERT INTO nss_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ndrokonan upahasaniy tehe wou anlahiy para arayi hu ndramat hiyan kiyasura hu ndramat mwomwan pwi. Ara tehen tapeh! Wou anlahiy para ambusi kultuw tora kiyawule kili hu ndramat hiyan pe mwomwan kene pwi. Andre kintayah tehen tora pwi. Ndramat namandran para tamwaniye para kol pwan masih ara andre kimbusi lohongai masih kimwonen pe kihisoule, ndre?>> ");
INSERT INTO nss_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Pwen YAPAN ipwai iyata Apraham ipa, <<Kapa kunime hu ndramat hiyan tora kol Sotom koho mayimingui andre kunmbusi hapesah kinna tahu masih kene pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Pwen Apraham ipwai paiwe iya kili yiy ipa, <<O Yapan, ndrinam mbuna kilokuh kiya nongan masih kunwong kinna aliy, koyum kisikirani yo. Yo ndramat mwaihei o tehe kohu pwan pe palam, pe kunlahiy para kuwong kiya handra lohongai pwi. ");
INSERT INTO nss_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kapa hu ndramat hiyan mayimingui pukene pe hu koho haangui pe yimou, andre apwalngani kol masih ara topwei kiyasura hu ndramat mwomwan?>> Pwen yiy isomwiy ipa, <<Andre yo kunpwalngani kol Sotom pwi, kapa kunime hu haangui pe yimou o.>> ");
INSERT INTO nss_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Apraham iwong paiwe ipa, <<Kapa anime yihu mahaangui o?>> Pwen ipwai ipa, <<Andre kunmbusi hapesah pwi kapa yihu mahaangui o.>> ");
INSERT INTO nss_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pwen Apraham iwong paiwe ipa, <<Yapan, ndrinam mbuna kilokuh to. Yo nakuwong paiwe kisa kili wou. Andre ambusi tapeh kapa yihu matingui o?>> Pwen ipwai ipa, <<Andre kunmbusiy pwi kapa kunime hu matingui hu toraliy.>> ");
INSERT INTO nss_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Apraham iwong imui paiwe iya kili Yapan ipa, <<Ndrinam mbuna kilokuh to para uwong soyon. Kapa anime yihu malungui o?>> Pwen ipwai ipa, <<Iya hiyan atahu malungui, andre kunpwalngani topwe hu pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iyamulan ipa, <<O Yapan ndrinam mbuna kilokuh to. Yo nakuwong porosih iye ko pe nongno nakihipwen. Kapa anime hu masongui o, andre ambusi tapeh?>> Pwen ipwai ipa, <<Andre kunpwalngani topwe hu pwi iya hiyan atahu masongui o.>> ");
INSERT INTO nss_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","YAPAN iwong iya kili Apraham ihipwen, iyamulan iyau pe Apraham imui iya kamai tan. ");
INSERT INTO nss_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kol ipiyah, pe Lot iyempwan pohomara papai namandran para kol namandran Sotom, pe inime hilu angelou malmou hilu rotokai nakasa kol Sotom. Pwen itine pe irikai iya kili hilu, pe itukruhu pe payan iya pwan, ");
INSERT INTO nss_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","pe iwong iya kili hilu ipa, <<Walu yapan to, walu kasa seu to pe kasungani ndrika walu pe kaye seu to mepo kiping. Moh makohun o, walu katine pe walu karikai.>> Pe hilpa, <<Pwi yoh, youlu andre koro matin ndrokolo kol aripo ndrohonoku mbultere.>> ");
INSERT INTO nss_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Hapeko Lot nongnan ipwoke pe hilyapolo yiy pe huya seu tan. Pwen Lot ipwai iya kili hu ndramat para poya mbulyan para hu kattun hayah ndrinanohun, yis aliy pwi. Pwen hu mbusi anandrina hilu pe hilyan. ");
INSERT INTO nss_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Iyamulan para namnam, hilu angelou malmou pakaya matin, pe hu kamai masih para kol namandran Sotom husa seu ta Lot. Yihu parangoloh pe wihou masih, ara hu hupwen husa pe hu rakayani seu. ");
INSERT INTO nss_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Pe huyoh iya kili Lot pe husike yiy hupa, <<Hilu ndramat malmou kansa tora kili wou mahapo yoping ara hilu aleheh? Awiri hilu kasa ngawan kili yowu para yowu kapopilah kiyasura hilu.>> ");
INSERT INTO nss_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot iya ngawan kili hu, pe iwari papai iro ndruwan. ");
INSERT INTO nss_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Pe ipwai iya kili hu ndramat para Sotom ipa, <<Wawu kowase, wawu mbuna kambusi melit mwomwan tora. ");
INSERT INTO nss_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Akanimei; noru malmou pihin ara hilu kanmatin kinnapolo hu kamai mapu. Kuya wiri hilu kasa ngawan kili wawu pe wawu kambusi sehe lohongai ta wawu kiya kili hilu. Hapeko wawu mbuna akambusi handra melit mwomwan kiya kili hilu kamai malmou iye. Hilu ara topo seu to pe yo andre kuponokulani hilu.>> ");
INSERT INTO nss_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Hapeko yihu ndramat ara hamou ipwai iya kili hamou hupa, <<Ndramat ita, kolon iye pwi. Ipa ndre yiy hiyeh, mepo ita wong pe ipa tukahilingi yiy?>> Pwen hu pwai iyatan hupa, <<Lot, aya mawen! Kapa anna mawen pwi, andre yowu kambusi mwomwan kiya kili hilu malmou ara, pe yowu karakultuwani wou kiya mwomwan masih.>> Pwen hu tinihi Lot pe yihu pakaya tumbuwe papai para seu. ");
INSERT INTO nss_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Hapeko hilu malmou ara hilu hileh o, pe hilu luwi Lot iro ngawan isa nondriya seu pe hilwari papai. ");
INSERT INTO nss_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pwen pe hilu yohi marahu ndramat huro ngawan ara iyoh masih, pe yihu kanlahi kanime papai para seu pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Pwen hilu angelou malmou hilu pwai iya kili Lot hilpa, <<Kapa wou manorum hu kamai ndre pihin, ndre noru sowam hu, ndre hamou para wum tam iripo kol namandran iye, awiri hu pe wawu masih kaya mawen. ");
INSERT INTO nss_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","YAPAN ipwandrisa youlu para youlu kapwalngani kol namandran iye kiya mwomwan masih; paratesah, YAPAN kinihilong tehe kultuwayihu ara mwomwan masih.>> ");
INSERT INTO nss_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Pwen Lot irikai iya kili hilu ndramat malmou hilu pakayesou kiya kili norun malmou pihin, pe ipwai iya kili hilu ipa, <<Walu kaleheleh pe kaya mawen kol iye. YAPAN andre kipwalngani kol Sotom kiya mwomwan masih.>> Hapeko hilu ndramat ara hilu hilingi Lot iwong, pe hilupa ndre Lot ara ipwasesemit iya kili hilu. ");
INSERT INTO nss_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Makohu ping o, hilu angelou malumou hilu pwai iyata Lot para kileheleh pe hilpa, <<Kileh! Awiri nambuyum pe norum malmou pihin pe wawu kaya mawen kol iye. Matisan YAPAN kipwasili kol namamdran iye pe wawu kakuni nopwaran.>> ");
INSERT INTO nss_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot ihindrundru pe kinihileh pwi, hapeko Yapan koyun isikirani yiy. Pwen pe hilu angelou malmou hilu mbultuwe nima Lot, nambuyun, pe norun hilu malmou pihin pe hilu luwi hu huya ngawan kol Sotom. ");
INSERT INTO nss_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Pwen hamou ta hilu angelou malmou ara ipwai iyata Lot pe norun hu ipa, <<Wawu kawop kileh kaya mwanan; matisan wawu kamat. Mara wawu mbuna kimui kiyamulan, pe wawu mbuna akayangoh kaya kol pwenten. Wawu kawop kaya paingan ngondron pe andre wawu kanmat pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Hapeko Lot ipwai iyata hilu malmou ipa, <<Pwi yoh, walu Yapane; kaha nokule hape satowu. ");
INSERT INTO nss_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Walu kanmbusi hiyan sato pe kunmat pwi, hapeko kol ngondron ara mwanan iya. Andre kunnarayah naliy mapwi pe mwomwan kisa kirayi yo pe kumat.>> ");
INSERT INTO nss_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Pwen ipwai iyata angelou paiwe ipa, <<Anime kol hakol mendreheh hira? Ara hira pakeh masih; animei? Hiyan para kuya kohon kuyaliy? Pwen pe andre kunmat pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Pe angelou ipwai iyatan ipa, <<Hiyan, yo upwes iya lohongam. Yo andre kunmbusi mwomwan kinna kol mendreheh ara pwi. ");
INSERT INTO nss_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kiya, aleheleh! Angap! Andre kunmbusi hapesah pwi kipoo ayarayah aya kol ara.>> Lot inime kol pe ipa kol ara mbusikau o. Pwen hupohowe ngala kol ara Sowar. ");
INSERT INTO nss_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Paramwandrai iro ngas nakisa paingan pe Lot iyarayah iya Sowar. ");
INSERT INTO nss_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","YAPAN imbusi mwan iro yat sombule pat pe ilon iro paingan yang pe isa pwan, ara tehe mbulou indrut, pe itimwi kol malkol Sotom pe Komorrah. ");
INSERT INTO nss_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tehen tora ko pe YAPAN ipwalngani kol malkol ara iyasura hu ndramat masih huro aliy pe mbuwakei masih kene iro ndrita pwan ara husongut topwei. ");
INSERT INTO nss_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nambuyu Lot maran imui iyamulan pe YAPAN irapaiwani yiy pe irayah tehe pat sou pe iro tine tehe sih ndruw. ");
INSERT INTO nss_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mandroulang sih i, Apraham itine pe iya kol mepo mamu iro tine aliy pe iwong iyasura YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Iya iro tine kol ara pe maran pakiya kol pwenten masih para pwan Sotom pe Komorrah pwi, kosumwan irotinam aliy, ara tehe iro yau sih ndrohomwan namandran. ");
INSERT INTO nss_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ngindrai ilohongani nongna Apraham pe neren iyata Lot. Pwen pe Lot iwop iya Sowar pe iya kohon tandrohonga Ngindrai itimwi Sotom pe Komorrah isongut iya mwomwan. ");
INSERT INTO nss_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot inoh para kiye Sowar, pe ipwai iyata norun malmou pihin, pe huwop huya ngondron pe huya kohon huya nondriya ngat sih. ");
INSERT INTO nss_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lang sih norun pihi namandran ipwai iyata pihi mendreheh ipa, <<Tama talu kinna parangoloh. Mahapo nondriya kol pwan masih hamou kamai kinto aliy pwi para kiwiri talu, pe talu kakun mbunah tehe hu ndramat para koluw ngara kambusiy. ");
INSERT INTO nss_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kiya, takahang tama talu ndran ngandrahan ngahan pe kiyin para kimbusi yiy pe lohongan kiya pwi, pe talu kamatin kiyasura yiy pe takakun mbunah.>> ");
INSERT INTO nss_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Huyen kol iping, pe hilu hang tama hilu ndran ngandrahan ngahan, pe iyin pe lohongan iya pwi masih. Pe yiy pihi namandran iyamatin iyapolo yiy. Tama hilu ara iyin ndran ngandrahan pe iyki lohonga pwi iyatan pe tanan hapesah pwi. Yiy kinpahasaniy tehe norun pihin kinmatin sura yiy pe kinsa mawen ara pwi. ");
INSERT INTO nss_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mandroulang, pihi namandran ipwai iyata nalin pihi mendreheh ipa, <<Pinge ping yo umatin iyasura yiy, pe mepo kiping takahang yiy ndran ngandrahan paiwe pe wou aya matin ayasura yiy. Pwen talu malmou kene andre kakun mbunah kili tama talu.>> ");
INSERT INTO nss_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Pwen ping ara hilu hang yiy ndran ngandrahan paiwe para lohongan kiya pwi, pe iyin pe lohongan iya pwi masih, pe tannan hapesah pwi, pe norun pihi mendreheh iya pe imatin iyasura yiy. Pe yiy kinpahasaniy porosih i tehe norun kinmatin sura yiy pe kinsa mawen ara pwi. ");
INSERT INTO nss_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Pwen hilu malmou kene hilu mwalahiy iyata noru tama hilu. ");
INSERT INTO nss_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yiy pihi namandran imwalahiy iyata norun hamou kamai pe ipohowe ngalan ara Mowap. Mbunah aro ara isarayah tumbuhu ndramira Mowap mahapo hutora. ");
INSERT INTO nss_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yiy pihi mendrehe imwalahiy iyata norun hamou kamai pe ipohowe ngalan ara Pen-Ammi. Yiy ara isarayah tumbuhu ndramira Amon mahapo hutora. ");
INSERT INTO nss_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Iyamulan Apraham irakuhuye pe itine iyau iya kol namandran Nekep, pe ipwili yumwan iro ndrokolo kol malkol, Kates pe Sur. Lang sih Apraham iya kol hakol ngalan Kerar, ");
INSERT INTO nss_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","pe ipwai iyatahu ndramat para kol ara tehe Sarah ara pisun. Pwen pe King Apimelek para kol Kerar ipwai iyatahu ndramiran pe huya wiri Sarah isa kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pe Ngindrai iyarayah iya kili Apimelek iya nihinih pe ipwai iyatan ipa, <<Wou andre amat, paratesah, pihin mepo anwiri yiy ita kili wou ara kinyesou.>> ");
INSERT INTO nss_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hapeko Apimelek ara kinmatin kinna sura Sarah ara mapu. Apimelek iyen pe ilolohonge pe ipwai iyata Ngindrai ipa, <<Yapan to, kunmbusi handra melit mwomwan pwi yoh! Wou narayi yo pe hu ndramat to ko mwaihei? ");
INSERT INTO nss_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Apraham mbukenan ipa Sarah ara pisun, pe Sarah ipwai isa kili yo tehe Apraham ipwai. Sarah ipa Apraham ara wayin. Pwen pe umbusi lohonge iye ara iyau sai hiyan, pe hingorowa mwoiwo ara ileu. Yo kunmbusi handra lohongai mwomwan pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Pwen Ngindrai ipwai iyatan iho nondriya nihinih ipa, <<Upahasaniy tehe wou ambusi lohongai iye ara iyau sai imwonen pe hingorowa mwoiwam ara ileu. Pwen pe upahasaniy pe kunna hiyan satam para ambultuwe yiy pwi, pe antakultuwani yiy pwi. ");
INSERT INTO nss_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hapeko mahapo ko ayaiki pihin ara kimui kiya kili nambuyun. Nambuyun ara yiy hamou pohon para mbulyo. Pwen ndramat ara andre kitoholi wou pe andre anmat pwi. Pe kapa anaiki yiy kimui pwi, upwai satam imwonen, wou pe hu ndramat tam masih ara andre wawu kamat topwei.>> ");
INSERT INTO nss_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Makohuping o, Apimelek iyoh hu ndramat namandran para poho mbulen tan husa pe itiyani melit masih tehe kinhilingi Ngindrai kinpwai kinnatan iya nihinih pe hunoh mimiri hu. ");
INSERT INTO nss_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pwen Apimelek iyoh Apraham iya kili yiy, pe isike yiy ipa, <<Wou apambusi tesah kisa kili yowu yeh? Yo umbusi tesah mwomwan isa kili wou pe apambusi kultuw ara kisa kili yo pe melto masih? Lohongai ara anlahiy para ambusiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Pwen Apimelek isike Apraham ipa, <<Paratapeh pe wou ambusi lohongai tehen tora?>> ");
INSERT INTO nss_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Apraham ipwai iyatan ipa, <<Yo upa ndre hu ndramat para kol iye ara konhonoh ta Ngindrai pwi. Pe andre karayi yo pe kawiri nambuyu. ");
INSERT INTO nss_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pe Sarah ara pisu ndrokonan. Youlu malmou kene tama youlu ara hamou o, hapeko tina youlu ara malmou, pe uwiri yiy iya nambuyu. ");
INSERT INTO nss_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tandrohonga Ngindrai iyoh yo pe utali wum ta tomo pe hu yowe, ara upwai iyata Sarah upa, <Kapa talu kaya kol hakol-hakol, ara ayoh yo wayim. Pwen lohongai ara andre kiyinganiy tehe wou ara anamili yo namandran iya.> >> ");
INSERT INTO nss_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Pwen Apimelek iyki Sarah imui iya kili Apraham, pe lang ara ko iyki hu mbulmwakau pe sipsip hayah, iyasura hu ndramat hayah para poya mbulyan iya kili Apraham. ");
INSERT INTO nss_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Pe Apimelek ipwai iyata Apraham ipa, <<Pwan namandran iye ara ato ko. Wou ayampwan hape aleheh kapa anamiliy.>> ");
INSERT INTO nss_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Pwen ipwai iyata Sarah ipa, <<Yo mahapo ko nakuiki sombule pat silwa masopou (1,000) nakiyata wayim, pe hu yowem masih andre hu kapahasaniy tehe wou anmbusi handra kultuw mwomwan ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Apimelek pakiwiri Sarah pakiya nambuyun, pe YAPAN irakultuwani hu pihin masih para wum tan para hu andre kankun mbunah pwi. Hapeko iyamulan Apraham koyun isikirani Apimelek pe itohun iya kili Ngindrai, pe Ngindrai imbusi Apimelek iya hiyan. Pwen pe nambuyu Apimelek iyasura hu pihin masih para poya mbulyan ara, hu lahiy para hu kakun mbunah paiwe. ");
INSERT INTO nss_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Pwen YAPAN imbusi hiyan iyata Sarah tehe kinpwai; pe imbusiy tehe kinpwatisingiy kinna tan. ");
INSERT INTO nss_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Apraham ara kinna parangoloh masih, hapeko Sarah ara mapundriyan pe imwalahiy iyata mbunah kamai. Pe imwalahiy iyatan ara imwonen lang tehe Ngindrai kinpwai para kimwalahiy. ");
INSERT INTO nss_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Pe Apraham ipohowe ngala norun, mepo Sarah imwalahiy iyatan, ara Yisak. ");
INSERT INTO nss_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pwen pe lang mandrolwoh ta Yisak ihipwen, Apraham isondriti kapilo Yisak tehe Ngindrai kinpwatisingiy kinna tan. ");
INSERT INTO nss_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Apraham hayou tan ara iro masangat, pwen Sarah imwalahiy iyata Yisak. ");
INSERT INTO nss_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah ipa, <<Ngindrai iyki pwesai pe haisai iripo kili yo. Pwen kapa hiyeh kihilingiy, andre kipwes kisasura yo.>> ");
INSERT INTO nss_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Pwen Sarah ipwai porosih i ipa, <<Koluw hiyeh ilahiy para kipwai kiyata Apraham toro: <Pihin tam Sarah ara andre kimwalahiy kiyata mbunah hamou, pe kiyuk sus kiyatan?> Apraham kinna parangoloh pwen, hapeko yo umwalahiy iyata norun hamou kamai.>> ");
INSERT INTO nss_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Pe mbunah kinmandra, pwen Apraham imbusi yon iro mwonen lang Yisak ihipwen sus. ");
INSERT INTO nss_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hakar, pihi Yisip, imwalahiy iyata noru Apraham kamai, Yismayel. Pe lang sih Sarah inime Ismayel iro nonoyou. ");
INSERT INTO nss_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Pwen Sarah ipwai iya kili Apraham ipa, <<Arasse pihin para pwandrendres ara, pe hilu norun kene hilkayau. Mbunah ara andre kinpo handra meltam kamulan ara pwi. Yisak o andre kiro nimnim kiya meltam masih.>> ");
INSERT INTO nss_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yismayel ara noru Apraham i, pwen pe nongna Sarah, ara imbusi Apraham iporu. ");
INSERT INTO nss_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Hapeko Ngindrai ipwai iyata Apraham ipa, <<Mbuna alohonge soyon kiyata mbunah kamai pe pihin para poya mbulyam. Ambusiy tehe Sarah kinpwai satam, paratesah, ndrayem hu masih nakasarayah kamulan, ara andre hu kayau kili Yisak o. ");
INSERT INTO nss_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hapeko yo andre kumbusi ndraye noru Hakar hu kasarayah soyo-soyon iya, paratesah, yiy ara norum i.>> ");
INSERT INTO nss_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Makohuping sih, Apraham iwiri pwendran ipep iya ndran iyasura anandrinai pe iykiy iya pwese Hakar. Pe Apraham iyki wihou iya kili Hakar pe irasse hilu pe hilyau. Hakar hilu norun hilya hiltorokai kol pwosowen Peersepa mepo ndramat aliy pwi. ");
INSERT INTO nss_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Pwen ndran ihipwen masih pe Hakar iyki norun wihou iya pe imi pahandra kei hakou mendreheh. ");
INSERT INTO nss_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Pwen Hakar iyau iya mawen hape pe impwan aliy, pe ilolohonge soyon toro: <<Yo mbuwali para kunime noru kimat.>> Pe Hakar impwan pe iro rang memesun. ");
INSERT INTO nss_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Pe wihou ara irang pe Ngindrai ihilingiy. Pwen angelou hamou ta Ngindrai iho paingan yang pe iyoh Hakar ipa, <<Hakar, ariya tehen tapeh? Mbuna anoh; wihou iyera pwan pe ita rang yoro, ara Ngindrai kinhilingi ndringen pwen. ");
INSERT INTO nss_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Atine pe aya soli yiy kitine pe kisa kili wou. Yo andre kumbusi yiy pe ndrayen hu andre kasarayah soyon iya.>> ");
INSERT INTO nss_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pwen Ngindrai imbusi mara Hakar ileu pe inime ndrikou sih. Pe Hakar iwiri pwisindran iya, imwaniy, isa pe norun iyin. ");
INSERT INTO nss_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Pe Ngindrai irosura yiy pe iro mandra. Iye kol pwosowen mwaihei o mepo ndramat aliy pwi, pe irayah ndramat para piyeya tapuiwe. ");
INSERT INTO nss_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yiy iya irondron kol mwaihei para Paran mepo ndramat aliy pwi, pe tinan iwiri pihi Yisip hamou pe isokomburani yiy iya nambuyu norun. ");
INSERT INTO nss_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Iya lang ara King Apimelek iyasura Pikol, namandran hamou ngara kimu para singora pahun, hilu hilya kili Apraham. Pe king ipwai iyata Apraham ipa, <<Ngindrai ita sura wou iya melit masih ambusiy. ");
INSERT INTO nss_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Mahapo apwatisingiy kiya mbulmara Ngindrai, pe apwai ngawan tehe wou andre anmbusi kultuw pwasoyou kisa kili yo, ndre noru hu, ndre ndraye hu pwi; paratesah, yo kunmbusi hiyan kinsa kili wou pwen. Tehen tora ko ambusi kultuw hiyan kisa kili yo pe kol namandran mepo asa aripo aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Pe Apraham ipwai iyatan ipa, <<Yo upwatisingi nongno toro: andre kumbusiy tehe anpwai.>> ");
INSERT INTO nss_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Pwen Apraham iya pohowe lohongai tan iya kili Apimelek iya ndran ndrikou mepo hu ndramat para poya mbulya Apimelek hu kanwiriy pwen. ");
INSERT INTO nss_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Pe Apimelek ipwai iyata Apraham ipa, <<Yo tono pwi. Anpwai sato pwi yoh; mepo ko uhulong.>> ");
INSERT INTO nss_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Pwen Apraham iyki sipsip pe mbulmwakau hayah iya kili Apimelek para hilu karapaniu pe hilu koro hiyan. ");
INSERT INTO nss_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Pe Apraham iwiri noru sipsip pihin manandrtimou mepo iro nondriya hu sipsip tan, pe iykiy iya iro mawen hape. ");
INSERT INTO nss_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Pe Apimelek isike Apraham ipa, <<Paratapeh ambusiy tehen tora?>> ");
INSERT INTO nss_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Pe Apraham ipwai ipa, <<Wou awiri noru sipsip manandrtimou iye. Iya lohonge tehen tora ko andre apwai ngawan tehe yoko usoye ndran ndrikou ara.>> ");
INSERT INTO nss_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Pe hilu tapaniu iro kol ara para hilu koro hiyan. Pwen pe hu pohowe ngala kol ara Peersepa. ");
INSERT INTO nss_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hilu tapaniu iro kol Peersepa ihipwen, pwen pe Apimelek iyasura Pikol, namandran tan, hilmui hilya pwan tahu Pilistiya. ");
INSERT INTO nss_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Pe Apraham iyki kei hakou mendreheh iro Peersepa, pe yiy iro totohun iya kili YAPAN, yiy Ngindrai andre kinto-kinto. ");
INSERT INTO nss_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Pe Apraham iye manau kol tahu Pilistiya, ara ndrangan niwen iya. ");
INSERT INTO nss_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hayou masahayeh ihipwen, Ngindrai pakihinonou lohonga Apraham. Pwen pe Ngindrai iyoh iya kili yiy ipa, <<Apraham.>> Pe Apraham isomwi yiy ipa, <<Apwai. Yo urupo.>> ");
INSERT INTO nss_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pwen Ngindrai ipa, <<Awiri norum hamou opu, ngalan Yisak, mepo ndriyam imbuluhi yiy pwokeyan iya, pe alkaya kol namandran hape Moriyah. Andre kuyingani ngondron sih ita aliy. Pwen atingundrun kiro ara, pe aiki yiy kisa kili yo tehe yukyuk para mwan andre kitimwiy masih.>> ");
INSERT INTO nss_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Pwen makohuping para lang sih i, Apraham iya pe ihara kihiy lumwat para tuntun, pe imwaniyani tongkiy tan. Pwen iwiri Yisak, pe hilu ndramat para poya mbulyan malmou, pe huyau para hukaya kol mepo Ngindrai kinpwai kinna tan. ");
INSERT INTO nss_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Hu yerokai, yerokai, ipoo iro mwonen lang maroyoh, pwen Apraham maran itandras pe inime kol ara iho ndron mwanan hape. ");
INSERT INTO nss_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Pwen Apraham ipwai iyata hilu ndramiran malmou para poya mbulyan ipa, <<Walu keye ndron iye kapolo tongkiy. Youlu wihou iye, andre youlu kaya totohun kaya yoro. Kihipwen, andre youlu kamui kasa kili walu.>> ");
INSERT INTO nss_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Pe Apraham iwiri kihiya yukyuk para mwan andre kitimwiy masih, pe ihiriy iya pwese norun Yisak, pe yiy mbukenan ara irokun semen pe mwan. Pwen tandrohonga hilu yerokai hilyau, ");
INSERT INTO nss_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisak ipwai iya kili taman, Apraham ipa, <<Tomo?>> Pe Apraham isomwi yiy ipa, <<Tesah, noru? Apwai.>> Pe Yisak ipa, <<Mwan pe kihiy iripo, hapeko noru sipsip nakirayah yukyuk para mwan andre kitimwiy masih ara, aleheh?>> ");
INSERT INTO nss_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Apraham isomwi yiy ipa, <<Noru, Ngindrai mbukenan andre kihang noru sipsip nakirayah yukyuk para mwan andre kitimwiy masih.>> Pwen pe hilu yerokai iyawule hilyau. ");
INSERT INTO nss_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Pwen hilyarayah hilya kol mepo Ngindrai kinpwai pwen kinnata Apraham ara, pe Apraham isoye pere tuntun iro ariya, pe imwaniyani kihiy iya ndritan. Pwen iwasi tiriyi norun kamai Yisak pe iyki yiy iya ndrita kihiy iro pere tuntun. ");
INSERT INTO nss_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Pwen niman iya pe iwiri semen para pakitingundru norun . ");
INSERT INTO nss_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Hapeko angelou ta YAPAN hamou iho paingan yang, iyoh isa kili yiy ipa, <<Apraham! Apraham!>> Pe Apraham isomwi yiy ipa, <<Tesah? Yo urupo.>> ");
INSERT INTO nss_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Pe angelou ipwai ipa, <<Mbuna atingundrun! Pe mbuna ambusi hapesah kiya ta wihou ara. Paratesah, mahapo upahasaniy tehe wou ara ngara aro pahandra nohowai ta Ngindrai, pe norum mepo ndriyam imbuluhi yiy imwonen ara, ara nerem kinna tan pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Apraham maran itandras pe inime sipsip kamai hamou, ndrosuwan ara indrap iho ndrungak mwalinga hu ndrandra kei hayah mendreheh. Pwen iya pe iwiri sipsip ara, pe iyki yiy tehe yukyuk para mwan andre kitimwiy masih iya soiwi norun. ");
INSERT INTO nss_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Pwen pe Apraham ipohowe ngala kol ara, <<YAPAN andre kihang.>> Iro mwonen lang ara isa matne mahapo, hu ndramat ngara hu kapa, <<YAPAN andre kihang kiya ngondron atan.>> ");
INSERT INTO nss_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Pwen angelou ta YAPAN iyoh iya kili Apraham iyau paingan yang porosih i, ipa, ");
INSERT INTO nss_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","<<YAPAN ipwai ipa, <Yo mbukeno urandrangan iya ngolo, toro: wou nerem kinnata norum pwi, pe apaiki yiy masih kisa kili yo; ");
INSERT INTO nss_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","pwen pe andre kutoholi wou, pe andre kumbusi ndrayem hu kasarayah soyo-soyon iya, tehe hu piriy hora yang, pe hu kalayeng para pwakileng. Pe ndrayem hu ara andre hu kapo pahun kiya kili hu ndram tahu, pe andre hu kawiri kolo hu ndram ara, karayah kolohu. ");
INSERT INTO nss_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pe yihu ndraye ndramat masih para kol pwan andre kutoholi hu kiyau kili ndrayem hu, paratesah, wou ahalingi yo.> >> ");
INSERT INTO nss_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Pwen Apraham hilu, hilmui hilya kili hilu ndramat malmou para poya mbulyan. Pe humui huya kol Peersepa, pe Apraham ikuw iyen aliy. ");
INSERT INTO nss_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Iyamulan hape, Apraham ihilong tehe Milkah, nambuyu nalin Nahor, ara imwalahiy iyata norun hu hayah kamai. ");
INSERT INTO nss_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Pe ndrihou tahu ara ngalan Us, mundruwa ndrohan ara ngalan Pus, pe isa parahara ndrohan, ara ngalan Kemuwel (mepo tama Aram). ");
INSERT INTO nss_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Pe husarayah mulan, ara ngalahu iye kene: Keset, Haso, Piltas, Yitlap pe Petuwel. ");
INSERT INTO nss_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Petuwel ara iyamulan irayah tama Repekah. Nali Apraham Nahor ara, iwiri Milkah, pe Milkah imwalahiy iyata norun kamai mandrolmou ara. ");
INSERT INTO nss_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Pe hayah husa suran ara noru Nahor nondriya Reumah, pihin para poya mbulyan. Pe ngalahu ara iye kene: Tepah, Kaham, Tahas pe Maakah. ");
INSERT INTO nss_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah iyen pe hayou tan iho sangat pe lungui pe andrtoyoh (127). ");
INSERT INTO nss_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Pwen iyamat iro kol namandran Kiriyat Arpa (ngalan handra ara Hepron), ita nondriya pwan Kenaan. Pe Apraham koyun isikirani yiy pe irangsi yiy. ");
INSERT INTO nss_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Pwen iyki nombuwe Sarah irondron kei, pe Apraham itine pe iya wong iya kili hu ndramira Hit ipa, ");
INSERT INTO nss_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","<<Yo ara ndramat para kol mawen, hapeko usa pe umpwan mwalinga wawu. Pe pihin to ara kinmat, pe nakuarapaya pwan hambut kili wawu para kuroni yiy kiyen aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Pwen hu ndramira Hit hu pwai iyatan hupa, ");
INSERT INTO nss_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","<<Yapan, ahalingi yowu; yowu nimei tehe wou ara yapanewu hamou hiyan iya. Hiyan, aroni nambuyum kiya sehe ngat sou mepo animei hiyan masih para aya pe aroni yiy kiya aliy. Hamou towu andre kinpa tehen tapeh kinna ngat sou atan para aroni nambuyum kiya aliy ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Apraham itine pe itukuruhu iyatahu ndramat para kol Hit. ");
INSERT INTO nss_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Pe ipwai iyatahu ipa, <<Kapa wawu kanpa hiyan para kuroni nambuyu kiya ngat sou sih iripo aripo, pwen wawu kaya pe kasike Epron, noru Sohar ");
INSERT INTO nss_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kapa kipa hiyan para kurapaya ngat sou atan ita mbusongo pwan hambut ngalan Makpela kisa kili yo. Kapa kiya hiyan katan, pwen asike yiy para kiyki kennen kimwonen para kusowaniy kili yiy. Tehen tora ko pwan andre kisa mbukenan yo para tona yowu.>> ");
INSERT INTO nss_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Epron irompwan mwalinga hu ndramira Hit hu tora kol para tawuwure, pakeh pohomara papai para kol namandran ara. Pwen Epron isomwi Apraham pe ipwai ipa, ");
INSERT INTO nss_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","<<Yapan, ahalingi yo. Mbuna alohonge soyon para arapaya pwan; konan. Andre kuiki pwan ara kisatam o mwaihei kiyasura ngat ita aliy. Andre kuikiy kisatam kiya mbulmarahu to, hu topo, pe wou aroni nambuyum kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pwen Apraham itukuruhu iya kili hu ndramira kol ara porosih i. ");
INSERT INTO nss_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Pe yiy ipwai iyata Epron iya mbulmarahu ndramat masih ipa, <<Kiya. Epron, ahalingi yo namu. Yo nakurapaya pwan tam ara. Pwen awiri sombule pat ato pe andre kuroni nambuyu kiyen aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron ara isomwi nongna Apraham ipa, ");
INSERT INTO nss_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","<<Yapan, ahalingi yo. Pwan ara, kennen ara sombu silwa mahaangat. Hapeko mwalinga talu ara namandran pe pwan ara mwaihei o. Konan! Awiri pwan pe aroni nambuyum kaliy.>> ");
INSERT INTO nss_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Apraham ipa hiyan iya nongna Epron. Pwen irapaya pwan ara iya kennen tehe Epron ipwai iya mbulmarahu ndramira Hit. Nopwaran para silwa ara hu ranonoye tehe hu ndramat ngara hu karanonoye melit, pe irayah mahaangat. ");
INSERT INTO nss_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Melit masih kene ata Epron ita Makpela ita paheh kol Mamre ara kinna ta Apraham. Pwan pe ngat sou, iyasura hu kei pe melit masih ita ndrita pwan ara kinna tan. ");
INSERT INTO nss_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Pwen hu ndramira Hit masih hu tora kol para tawuwure ara, ara hu pahasaniy tehe pwan kintan kinna kili Apraham. ");
INSERT INTO nss_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Iyamulan, Apraham ironi nambuyun Sarah, iya ngat sou ita pwan ngalan Makpela, pakeh kili kol Mamre ita nondriya kol namandran Kenaan. (Ngala kol Mamre handra ara hu pohowe Hepron.) ");
INSERT INTO nss_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Pwan pe ngat sou tahu Hit ara, hu kantaliy kinnata Apraham pe kinna mbukenan yiy, para tona hu ndramiran hu. ");
INSERT INTO nss_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Apraham ara kinna parangoloh pwen. Pe YAPAN kintoholi yiy kinna melit masih kene kinmbusiy. ");
INSERT INTO nss_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Pwen Apraham ipwai iya kili ndramat iya pohon tahu ndramat masih para poya mbulyan mepo ngara kinimnim kiya melit masih atan, ara ipa, <<Aiki nimam kiya pahandra mbupo, pe apwatisingiy ndrokonan kisa kili yo. ");
INSERT INTO nss_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Yo unamili wou para awong ndrokonan kiya mbulmara YAPAN, Ngindrai para paingan yang pe kol pwan, tehe wou andre anna seyeh hamou nambuyu noru mwalinga hu pihindrahin hutopo kol Kenaan aripo ara pwi masih. ");
INSERT INTO nss_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Amui aya kolo mamu pe aseyeh hamou pihindrahin mwalinga hu ndraye imwonen pe kiya nambuyu noru Yisak.>> ");
INSERT INTO nss_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pwen pe ndramat para poya mbulyan ipwai ipa, <<Kapa pihindrahin ara mbuwalin para kitali kolon pe kisa kol iye sura yo, pwen andre tehen tapeh? Hiyan para kuwiri norum kiya pe kiyayesou kaliy?>> ");
INSERT INTO nss_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Hapeko Apraham ipa, <<Pwi yoh! Mbuna awiri noru kimui kiya kol ara. ");
INSERT INTO nss_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","YAPAN, Ngindrai para paingan yang, ara kinwiri yo kunsa mawen pwan kili yowe tomo hu. Pe kinpwatisingiy pe kintandrangan kinsa kili yo, para yiy andre kiyki pwan iye kiyata tumbuhu. Ngindrai andre kipwandrisa angelou tan kimu pe wou andre aro ndruwan para aya pe awiri nambuyu noru. ");
INSERT INTO nss_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kapa pihindrahin ara mbuwalin para kisa suram, pwen nongan napwatisingiy mahapo ara andre kiya mwaihei opu. Hapeko wou mbuna awiri noru kiya kol ara.>> ");
INSERT INTO nss_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Pwen pe ndramat para poya mbulyan iyki niman iya pahandra mbupa namandran tan, Apraham. Pe ipwatisingi nongan pwokeyan tehe Apraham kinpwai. ");
INSERT INTO nss_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pwen ndramat para poya mbulyan iwiri kamel masongui ata Apraham, iyapolo hu melit ata namandran tan handra-handra, hiyan masih pe soyon iya. Pe iyau iya kol ta Nahor ita nondriya kol Mesopotemiya. ");
INSERT INTO nss_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pwen iyarayah, pe iyki hu kamel huye pwan ngilse ndrikou pakehekeh kol. Pe kol ipiyah pe hu pihindrahin nakasa mwe ndran. ");
INSERT INTO nss_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Pe yiy itohun ipa, <<O YAPAN, Ngindrai ta namandran to Apraham. Wou koyum kisikirani namandran to, pe lang mepo ambusi mbulen to kiyarayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Animei! Yo uropo tine ngilse ndrikou iye, pe hu pihindrahin para kol iye hu nakasa mwe ndran. ");
INSERT INTO nss_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Pwen pe yo andre kupwai kiyata hamou pihindrahin kupa, <Hiyan para awiri pwendran tam kisa pe kuyin?> Pe kapa kipa, <Hiyan, ayin, pe andre kuhang ndran kiyatahu kamel tam i.> pwen andre kupahasaniy tehe pihindrahin ara ko anpwaingni yiy para kiyata yau tam, Yisak. Iya lohongai ara ko, ayinganiy tehe koyum ara isikirani namandran to, Apraham.>> ");
INSERT INTO nss_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Pwen pe iro totohun manau, pe Repekah isarayah iyasura pwendran tan iro pwesen. Repekah ara noru Petuwel, pe Petuwel ara noru Milkah nambuyu Nahor, pe Nahor ara nali Apraham. ");
INSERT INTO nss_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Repekah ara yiy hamou pihindrahin lahayan iya pe yiy ara kinmatin kinna sura hamou kamai mapu. Pe ilai iya ndrikou pe imwani ndran tan ihipwen pe imui iya paingan. ");
INSERT INTO nss_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Pwen ndramat para mbulen ihileh iya pohonani yiy pe ipa, <<Hiyan para hape ndran ita pwendran tam kisa pe kuyin?>> ");
INSERT INTO nss_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Pe Repekah ipa toro: <<Yapan to, ayin.>> Pwen ihileh pe isoli pwendran isa pwan iro niman, pe iykiy iya kili yiy pe iyin. ");
INSERT INTO nss_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iyin ihipwen, pwen Repekah ipa, <<Andre kumwe ndran kiyatahu kamel tam i, kipoo hu kahamosu hu.>> ");
INSERT INTO nss_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Pwen ihimbuh pe itilingi ndran iho ndrohonoku kuimwahu, pe ihileh imui iya ndrikou pe iwiri pwendran tan pe iromwaniy para kiyatahu kamel masih. ");
INSERT INTO nss_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Pe ndramat ara kinwong sahin nongan pwi. Hapeko maran irotis para kinimei tehe YAPAN andre kimbusi lohonge aro andre kisarayah mannan ndre pwi. ");
INSERT INTO nss_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pwen pe hu kamel huyin ndran ihipwen, pe ndramat ara iwiri soyou sih hu mbusiy iyau kolt pe iykiy iya ndrohongu Repekah. Pwen iwiri mbunahai maluwoh hu mbusiy iyau kolt pe iykiy iya mbunahan. Pwen nopwaran para soyou ara mayimah pe nopwaran para mbunahai maluwoh ara masangat. ");
INSERT INTO nss_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Pwen ndramat ara isike yiy ipa, <<Wou noru hiyeh? Hape yokyok ita seu ta tamam ndre pwi, para yo pe ndramiro hu kasa pe koro matin aliy mepo kiping?>> ");
INSERT INTO nss_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Pe Repekah ipwai ipa, <<Tomo ara Petuwel, yiy noru Nahor pe Milkah.>> ");
INSERT INTO nss_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Pe ipwai paiwe iya kili yiy ipa, <<Kalsiu kili yowu ara ndromwindriu pe anandrinahu kan ara soyon iya ita aliy para hu kamel tam hu kayan. Pe seu towu sahin ara hiyan para wawu kasa pe koro matin aliy mepo kiping.>> ");
INSERT INTO nss_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Pwen ndramat ara itukuruhu iya pwan pe yiy itotohun iya kili YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ipa, <<Urawuloh ata YAPAN, Ngindrai ta namandran to, Apraham. Yiy koyun isikrani namandran to pe imbusi hiyan iyatan; tehe yo, ara YAPAN imu iya tokuyo, pe iwiri yo usa mwonen usa wum kili yowehu namandran to.>> ");
INSERT INTO nss_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Pwen pihindrahin ara ingap imwonen iya seu kili tinan, pe inese ndraingahu iya melit masih mepo irayah iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Repekah ara wayin hamou ngalan Lapan. Yiy inime soyou pe mbunahai iro mbunaha pisun, pe ihilingi Repekah inese nongna ndramat ara ipwai iyatan. Pwen Lapan ingap iya ngawan pe iya kili ndramat para poya mbulya Apraham ara iro tine sura hu kamel tan ngilse ndrikou. ");
INSERT INTO nss_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Pe Lapan ipa, <<Asa. YAPAN kintoholi wou pwen. Paratapeh aripo tine ngawan iye? Yo kunmwaniyani nokum pe noku kamel tam hu yi.>> ");
INSERT INTO nss_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Pwen pe ndramat para poya mbuluya Apraham ara iya seu. Pe Lapan ipwai iyatahu ndramat para mbulyan pe hu lokihi menmenahu masih iro ndrita kamel isa pwan, pe yihu yuk ndromwindriu pe anandrinahu kamel para hu kayan. Yiy ipwai iyatahu para hu kapo ndran kisa kili ndramat para poya mbulya Apraham pe yowen hu para hu kasungani polondrika hu kaliy. ");
INSERT INTO nss_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Pwen hu wiri anandrinan isa, hapeko ndramat para poya mbulya Apraham ara ipwai ipa, <<Yo andre kunnamnam kileh pwi, kipoo kuwong kiya sehe nongan iripo kili yo. Yo nakuwong hape na.>> Pe Lapan ipa, <<Hiyan, awong namu.>> ");
INSERT INTO nss_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Pe ndramat ara ipa toro: <<Yo ara ndramat hamou para poya mbulya Apraham. ");
INSERT INTO nss_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","YAPAN itoholi namandran to pe iyki meltan ara soyon iya. Ihingini yiy iya hu sipsip pe hu mbulmwakau, pe silwa pe kolt, hu ndramat para poya mbulyan kamai pe pihin, iyasura hu kamel pe tongkiy. ");
INSERT INTO nss_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Pihin ta namanadran to, Sarah, ara imwalahiy iyata mbunah hamou kamai iro mwonen yiy kinna pihiparangoloh pwen. Pe namandran to andre kiyki hu meltan masih kiya kili norun pe andre kinimnim kaliy. ");
INSERT INTO nss_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pwen yapane iyki nongan pwokeyan sato toro: ipa, <Mahapo uropo kol Kenaan, hapeko mbuna akah hamou pihi Kenaan kiya nambuyu noru, pwi yoh! ");
INSERT INTO nss_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Hapeko wou aya kili ndraye tomo hu, pe aya seyeh hamou nambuyun.> Yapane ipwai sato tehen toro, pe upwatisingiy iyatan tehe yo andre kumbusiy tehe kinpwai. ");
INSERT INTO nss_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Pwen pe upwai iya kili yapane upa, <Kapa pihindrahin ara mbuwalin para kisapolo yo, pwen andre tehen tapeh?> ");
INSERT INTO nss_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Pe yiy isomwiy ipa <Yo ara ndramira YAPAN pe ngara kuhilingi nongnan. Pwen pe yiy andre kipwandrisa angelou tan kiyapolo wou para kimbusi mbulyam kirayah hiyan. Pe wou andre awiri nambuyu noru kamai kiro kili yowe tomo hu. ");
INSERT INTO nss_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Aya kili hu pe ayapa nongno. Kapa yihu kasomwiy, ara hiyan. Pe kapa yihu kansomwiy pwi, ara amui mwaihei opu. Pwen andre nongan pwokeyan apwatisingiy ara, andre kiniyki nopwaran kinsa kili wou pwi.> ");
INSERT INTO nss_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Pwen lang nepo usarayah usa ndrikou yoro, pe utohun upa, <YAPAN, Ngindrai ta yapane Apraham, wou ambusi mbulen to kirayah hiyan. ");
INSERT INTO nss_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Uro tine ngilse ndrikou, pe upa toro: Kapa hamou pihindrahin kisa mwe ndran, pe yo kupwai katan kupa, <<Hiyan para kuyin hape ndran ita pwendran tam?>> ");
INSERT INTO nss_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","pe kapa yiy kipwai sato kipa, <<Hiyan, ayin, pe andre kuhang ndran kiyatahu kamel tam i,>> pwen pihindrahin ara, ara pihin mepo YAPAN kinpiraniy tehe yiy andre kirayah nambuyu noru yapane.> ");
INSERT INTO nss_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Pe yo uro totohun manau, pe Repekah isarayah. Yiy ikuni pwisindran iro pwesen pe isapwen iyamwe ndran iya ndrikou. Pe yo upwai iyatan upa, <Hiyan para hape ndran ita pwendran tam kisa pe kuyin?> ");
INSERT INTO nss_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Pwen pe yiy ileheleh para kisoli pwendran iro pwesen isa pwan pe ipa, <Ayin, pe yo andre kumwe ndran kiyatahu kamel tam i.> Pwen uyin pe yiy iyuk iyatahu kamel ato yi. ");
INSERT INTO nss_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Pe yo usike yiy, <Wou noru hiyeh?> Pwen pe yiy ipwai ipa, <Tomo ara Petuwel, yiy noru Nahor pe Milkah.> Pwen pe yo uiki soyou iya ndrohongun pe mbunahai iya mbunahan. ");
INSERT INTO nss_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Pwen pe yo utukuruhu iya pwan pe utohun iya kili YAPAN. Pe yo urawuloh iya kili YAPAN, Ngindrai ta yapane Apraham, paratesah, yiy iwiri yo usamwonen usa suwe nali Apraham. Pwen pe usa para kuwiri norum pihindrahin para kiya nambuyu noru yapane. ");
INSERT INTO nss_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kapa wawu kalohonganiy hiyan, pe kambusiy kimwonen kiya kili yapane, pwen wawu kawong kimwonen sato. Kapa pukene, wawu kapwai ngawan kisato yi. Pwen yo andre kulohongani sehe melit para kumbusiy.>> ");
INSERT INTO nss_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Pwen lohonga ndramat ara itiyaniy masih ihipwen topwei, pwen pe Lapan pe Petuwel hilu pwai imui iyatan hilpa, <<Sehe melit mepo isarayah isa kili wou ara YAPAN imbusiy. Pwen youlu kanlahiy para kapa handra nongan hiyan ndre mwomwan pwi. ");
INSERT INTO nss_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Hiyan, Repekah impo. Pwen awiri yiy kiya nambuyu noru yapanem, Apraham, tehe YAPAN kinpwainganiy pwen.>> ");
INSERT INTO nss_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pwen ndramat para poya mbuluya Apraham ihilingi sehe nongan hupwai, pe yiy itukuruhu iya pwan pe itotohun iya kili YAPAN. ");
INSERT INTO nss_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Pwen ndramat para poya mbulen ara iwiri hu memelit hayah tehe kolt, silwa pe hu koyau hayah pe iyki hu iya kili Repekah. Pe yiy iyki melit hayah kennen namandran iya, iya kili wayin pe tinan. ");
INSERT INTO nss_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Pwen yiy iyapolo hu ndramat hurosura yiy, yihu namnam pe huyin ndran ihipwen, pwen huye matin. Iya mandroulang para lang sih, yihu satine pe ndramat para poya mbulya Apraham ipwai iyatahu ipa toro: <<Yo andre kumui kuya kili yapane.>> ");
INSERT INTO nss_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hapeko wayi Repekah pe tinan hilpwai iyatan hilpa, <<Pihindrahin ara andre kimindron sura yowu na. Kiromatine lang masongui kamulan, pwen awiri yiy pe wawu kayau.>> ");
INSERT INTO nss_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Hapeko yiy ipwai iyatahu ipa, <<Mbuna akakaituwe yo. Mahapoko YAPAN kinmwanyani soyo masih kinsamwonen pwen kinsa kili yo. Pwen nakumui kuya kili yapane.>> ");
INSERT INTO nss_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Pwen yihu pwai toro: <<Tukayoh pihindrahin ara kisa pe tukasike yiy.>> ");
INSERT INTO nss_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Pwen huyoh Repekah isa pe husok yiy hupa, <<Hiyan para nayasura ndramat iye?>> Pwen ipa, <<Ehe, andre kuya.>> ");
INSERT INTO nss_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Pwen yihu pwandrisa Repekah iyasura pihin para kipwokarani yiy pe hilyau hilyasura ndramat para poya mbulya Apraham pe yowen hu. ");
INSERT INTO nss_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pwen hutoholi Repekah pe hupwai toro iyatan: <<Pisu, wou ara andre asarayah tinahu ndramat pusangat kiyau pusangat, pe ndrayem hu andre kasarayah ndramat para pahun kiyatahu ndram para pahun, pe andre hu kawiri hu kol namandran tahu ndram kiya mbukenan hu.>> ");
INSERT INTO nss_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Pwen Repekah iyapolo hu pihin para poya mbulyan hu mipwan ndrita kamel pe huro ndruwa ndramat para poya mbulya Apraham. Pwen ndramat para poya mbulya Apraham iwiri Repekah pe huyau. ");
INSERT INTO nss_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tandrohongan ara ko, Yisak kintali ndran ndrikou ngalan Peer-Lahai-Roi, pe yiy iya iro kol pwosowen ngalan Nekep. ");
INSERT INTO nss_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Piyahon sih yiy ihorokai kol ngawan pe maran pakiya paingan pwi, inime hu kamel huropo husa. ");
INSERT INTO nss_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Pwen Repekah inime Yisak pe itali kamel tan, pe ilai isa pwan. ");
INSERT INTO nss_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Pe yiy isike ndramat para poya mbulya Apraham ipa, <<Yohou sehe ndramat hiratokai kol ngawan yoro pe nakisa pohonani rou?>> Pe isomwi yiy ipa, <<Yiy ara yapane.>> Pwen Repekah iwiri koyau tan pe ikulani mbulmaran iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Pwen ndramat para poya mbulen ara ipwai iya kili Yisak iya melit masih kinmbusiy pwen. ");
INSERT INTO nss_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yisak iwiri Repekah iya kamai ta tinan, Sarah. Pwen hilu yesou. Yisak inamili Repekah pwokeyan iya, pwen pwesai imui iya kili yiy yamulan para kimat ta tinan, Sarah. ");
INSERT INTO nss_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Pwen Apraham ara iyesou paiwe yi, pe iwiri pihin hamou ngalan Keturah. ");
INSERT INTO nss_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Keturah imwalahiy iyata norun hu, ngalahu ara iye kene: Simran, Yoksan, Metan, Mitiyan, Yispak pe Suwah. ");
INSERT INTO nss_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan ara tama Sepa pe Tetan. Pe Tetan ara ndrayehu Assur, hu Letus pe yihu Leyum. ");
INSERT INTO nss_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mitiyen ara norun hu iye kene: Epah, Eper, Hanok, Apita pe Elitaah. Ariyo ara ndraye Keturah hu masih. ");
INSERT INTO nss_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Pe Apraham ara iyki meltan masih iya kili norun Yisak. ");
INSERT INTO nss_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Hapeko Apraham ara kinmat mapu, pe iyki yukyuk hayah iya kili norun hu kamai para nondriya pihi mulan. Pwen pe ipwandrisa hu huyau huya pwen te Kup huya mawen kili Yisak. ");
INSERT INTO nss_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Apraham iyen pe hayou tan masih iya harong ara sangat andrtingui pe yimah (175). ");
INSERT INTO nss_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Pe Apraham ara iya parangoloh masih, pe hayou tan ara hiyan pe soyon iya. Pwen pe imat iho ndruwa tumbun hu. ");
INSERT INTO nss_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Norun malmou Yisak pe Yismayel ara hilya hiltoni yiy iro ngat sou para Makpelah pakeh Mamre, mepo pwan ta Epron koluw, yiy noru Sohar ndramira Hit. ");
INSERT INTO nss_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Pwen pwan hambut tahu Hit nepo Apraham isowaniy, ara Yisak iyasura Yismayel ara hiltoni Apraham iya ngat sou mepo Apraham ironi Sarah iro aliy mamu. ");
INSERT INTO nss_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Hiltoni Apraham ihipwen, pwen Ngindrai itoholi Yisak. Yisak ara impwan ngilse ndran ndrikou iro kol Nekep, ngalan Peer-Lahai-Roi. ");
INSERT INTO nss_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iye ara titiye ta Yismayel hu, noru Apraham nondriya Hakar pihi Yisip, pihin para poya mbulya Sarah. ");
INSERT INTO nss_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Iye ara ngala noru Yismayel hu kamai: yiy ndrihou ara ngalan Nepayot, mundruwa Nepayot ara Ketar, Atpeel, Mipsam, ");
INSERT INTO nss_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Tuma, Masa, ");
INSERT INTO nss_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hatat, Tema, Yetur, Napis pe Ketemah. ");
INSERT INTO nss_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ariyo ara ngala ndraye noru Yismayel hu kamai songui pe lumou. Pe ngalahu ara kinrayah ngalahu kol mendre-mendreheh mepo humimpwan aliy. ");
INSERT INTO nss_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Yismayel iyen pe hayou tan iho sangat tingui pe andrtoyoh (137) pwen pe imat pe iho ndruwa tumbun hu. ");
INSERT INTO nss_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Pe ndraye Yismayel hu huya pe huye kol namandran ndrokolo Hawilah pe Sur. Pe Sur ara ita pakeh Yisip ngilse sai iyapwen te Asiriya. Hapeko yihu ara hu konohompwan hiyan pwi. ");
INSERT INTO nss_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iye ara titiye ta noru Apraham, Yisak. Apraham ara tama Yisak. ");
INSERT INTO nss_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Pwen Yisak ara hayou tan iro mahaangui pe iwiri Repekah, mepo noru Petuwel pihin. Pe Petuwel ara ndramira Aram hamou, mepo para kol Mesopotemiya, pe Repekah ara pisu Lapan. ");
INSERT INTO nss_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Repekah ara kinlahiy para kikun mbunah pwi. Pwen Yisak itohun iya kili YAPAN iyata Repekah, pe YAPAN ihilingi totohun tan, pe Repekah ara mapundriyan. ");
INSERT INTO nss_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Yiy ara norun mwan, pe mapu kinmwalahiy ta hilu, hilu sopaiwe iro nondriya tina hilu, pe yiy ipa, <<Weh, aripo tapeh? Sehe melit iriporayah isa kili yo? Pwen yiy iya sike YAPAN para kiyki lohongai para aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Pe YAPAN ipwai iyatan ipa, <<Hilu ndramat malpat hiltora ndriyam. Pe hilu malpat ara, ara andre hilu konto wule pwi. Andre hu hapat kaya pwokeyahu katahu hapat. Pe yiy mepo nakisarayah mu andre kiya pwandrendres ta yiy para mulan.>> ");
INSERT INTO nss_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Pwen pe iro mwonen lang nakimwalahiy kiyata norun kamai malmou mwan, ");
INSERT INTO nss_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","imwalahiy tan imu ara sangin laman pe yomun soyon iramburuhi yiy, tehe hasai koyau. Pwen pe hupohowe ngalan ara Esau. ");
INSERT INTO nss_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Pwen Repekah imwalahiy iyata nalin hamou paiwe, pe yiy imbultuwe tisingi mbutika Esau. Pwen pe hupohowe ngalan ara Yakop. Yisak hayou tan iro manongui (60), pwen norun mwan malmou hilsarayah. ");
INSERT INTO nss_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Hilu mbunah malmou kanna wihou pwen, pe Esau irayah ndramat hamou para kahaya yohou iya kene yangiy masih. Yakop ara mbunah hamou waison pe ngara kiye wum o. ");
INSERT INTO nss_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisak ara ngara kinamili Esau, paratesah yiy ndramat para kahaya yohou para namnam, hapeko Repekah ara ngara kinamili Yakop. ");
INSERT INTO nss_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lang sih aro Yakop ara iro tuwe suw hayah, pe Esau iro yangiy pe isarayah isa wum mamundruwan. ");
INSERT INTO nss_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Pe Esau ipwai iyata Yakop ipa, <<Kileh, kunmundrui turuwe yo. Aiki suw hayah mahapo anruwaniy ita, ara kisa.>> Ndroiyin ara ko pe hupohowe ngala Esau handra i ara <<Etom.>> ");
INSERT INTO nss_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Pe Yakop ipwai iya kili yiy ipa, <<Aiki ndrohonokum tehe ndrohan ara kisa kili yo pe andre kuiki suw kisa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Pe Esau ipwai ipa, <<Animei! Yo ara pakeh nakumat. Kapa kumat, tesah ndrokonan andre kiwiri soiwi noku tehe ndrohan?>> ");
INSERT INTO nss_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Pwen Yakop ipa, <<Apwatisingiy ndrokonan, pwen aiki ndrohonokum tehe ndrohan ara kisa kili yo.>> Pwen Esau ipwatisingiy ndrokonan, pe iyki ndrohonokun tehe ndrohan ara iya kili Yakop. ");
INSERT INTO nss_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Pwen Yakop iyki ndrinanohun hayah iyasura suw mepo kinmbusiy iyau mbuwa malikei handra para kaniyai, pe iykiy iya kili Esau. Pe Esau inamnam pe iyin ndran, pwen itine pe iyau. Tehen tora ko, Esau inime ndrohonokun tehe ndrohan ara kinna mwaihei o. ");
INSERT INTO nss_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Pe mundruwai namandra-namandran isarayah iro kol Kenaan paiwe, pe irayah tehe koluw mamu kintayah pwen, iro tandrohonga Apraham. Pwen pe Yisak iya kili King Apimelek para kol Kerar ita nondriya kol namandran Pilistiya. ");
INSERT INTO nss_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Pe YAPAN isarayah isa kili Yisak pe ipa, <<Wou mbuna alai aya pwan Yisip. Aye sehe kol mepo nakupwai kisatam para ayen aliy. ");
INSERT INTO nss_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ayen ndron kol iye na, pe andre kuro sura wou pe andre kutoholi wou. Yo andre kuiki pwan iye kisa kili wou pe ndrayem hu mepo nakasarayah kamulan. Pe andre kuramwaniyani tapaniu to mepo kunpwai kinna ta tamam Apraham. ");
INSERT INTO nss_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Andre kumbusi ndromweya ndrayem hu kasarayah soyo-soyon iya, tehe hu piriy hora yang; pe pwan masih iye ara andre kuikiy kiyatahu. Pe hu ndramat para kol masih topo kol pwan ara andre kutoholi hu kiyau kili ndrayem hu ko; ");
INSERT INTO nss_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","paratesah, Apraham ihilingi nongno pe ipwotisingi pwahanou to masih.>> ");
INSERT INTO nss_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Pwen Yisak iyen ndron Kerar. ");
INSERT INTO nss_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Pwen hu ndramat hayah para kol ara husike Yisak iyata Repekah, pe Yisak ipa, <<Yiy ara pisu.>> Yisak ara inoh para kipohowe Repekah ara nambuyun, paratesah, lohonge tan ara ipa, <<Matisan hu ndramat para kol ara hu katingundru, paratesah, Repekah ara pihin lahayan iya.>> ");
INSERT INTO nss_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yisak iro kol ara ndrangan niwen iya, pe King Apimelek para kol Pilistiya ara, maran iyau marasip pe inime Yisak iro tokonani nambuyun Repekah. ");
INSERT INTO nss_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Pe Apimelek iyoh Yisak isa pe ipa, <<Mahapo upahasaniy tehe pihin ara, ara pisum pwi; yiy ara nambuyum. Paratesah pe apohowe yiy ara pisum?>> Pe Yisak ipa, <<Ulolohonge pe upa, kapa kupa yiy ara nambuyu andre hu katingundru.>> ");
INSERT INTO nss_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Pwen Apimelek ipa, <<Wou apambusi tesah kisa kili yowu? Kapa hamou ndramiro kirandroyani nambuyum, pwen apaiki nopwaran ara kisa kili yowu ko mwaihei, hapeko ndrokonan para aliy ara wou mbukenam.>> ");
INSERT INTO nss_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Pwen pe Apimelek ipwatisingiy iya kili hu ndramat masih pe ipa, <<Kapa hamou ndramat kirandroyani Yisak ndre nambuyun, ara andre yiy kimat.>> ");
INSERT INTO nss_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Pe Yisak ara ihisi piyang hambut pe iro mwonen hayou ara, anandrinai soyo-soyon iya isarayah iro pwan ara, paratesah, YAPAN itoholi yiy. ");
INSERT INTO nss_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Pe yiy ara irayah ndramat hamou namandran iya, pe meltan iro tayah iya soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Pe hu sipsip pe hu mbulmwakau tan, iyapolo hu ndramiran para poya mbulyan ara hu soyon iya. Pwen pe hu Pilistiya ara hu ndrangis iyatan. ");
INSERT INTO nss_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Pwen hutalon pwan pe huratulungi hu ndran ndrikou masih mepo hu ndramira Apraham husoyei koluw. ");
INSERT INTO nss_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Pe Apimelek ipwai iyata Yisak ipa, <<Wawu karakuhuye pe kaya mawen kili yowu, paratesah, pwoke ta wawu kinsarayah pwokeyan iya isa kili yowu.>> ");
INSERT INTO nss_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Pwen Yisak irakuhuye pe iyau iya pwenten para Kerar pe ipwili yumwan pe iyen aliy. ");
INSERT INTO nss_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Koluw Apraham isoye hu ndran ndrikou iro aliy ara, pe yiy kinmat pe hu Pilistiya huya pe huratulungi hu ndran ndrikou ara. Pwen Yisak iya pe ikaihi hu ndran ndrikou ara paiwe pe ipohowe ngala hu ndrikou ara tehe taman kinpohowe hu mamu kinna. ");
INSERT INTO nss_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Pe hu ndramat para poya mbulya Yisak ara, huro talon pwan iro Pwenten Kerar pe ndran isuw mbulu pwan isa paingan pe ihou aliy. ");
INSERT INTO nss_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Hapeko hu ndramat mepo huro nimnim iyatahu mbulmwakau tahu Kerar ara, hurakokowai iyasura hu ndramat ngara hu kanimnim kiyata hu mbulmwakau ta Yisak ara hupa, <<Ndran ndrikou ara, ara atowu!>> Pwen Yisak ipohowe ngala ndran ndrikou ara <<Takokowai,>> paratesah, hu ndramat hurakokowai iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Pwen pe hu ndramira Yisak husoye ndran ndrikou sih paiwe, pe hurakokowai yi. Pwen Yisak ipohowe ngala ndran ndrikou ara, <<Songot.>> ");
INSERT INTO nss_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Pwen pe Yisak itali hape ara pe iya soye ndran ndrikou sih paiwe; iro tandrohongan ara, ara hu kanrakokowai pwi. Pe Yisak ipohowe ngala ndran ndrikou ara, <<Ndrohonoku para pwanpwan hiyan.>> Paratesah, ipa toro: <<Mahapo YAPAN kiniyki pwan hape iye kinsa torou. Pe menmenarou ara, andre kisarayah hiyan iya kiro aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Pwen Yisak itali kol ara pe iyau iya kol Peersepa. ");
INSERT INTO nss_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ping ara ko Ngindrai iyarayah iya kili yiy pe ipa, <<Yo ara Ngindrai ta tamam Apraham. Mbuna anoh. Yo uropo sura wou; pe yo andre kutoholi wou pe ndromweya ndrayem hu andre kasarayah soyo-soyon iya, paratesah, unamili ndramiro, Apraham.>> ");
INSERT INTO nss_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yisak isoye pere tuntun sih para totohun, pe itotohun iya ngala YAPAN. Pwen ipuli seu hawum pe hu yau tan husoye ndran ndrikou sih. ");
INSERT INTO nss_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Iyamulan Apimelek itali kol Kerar pe iwiri Ahussat, ndramat para pwahanou yiy, iyapolo Pikol, ndramat ngara kiya mu para singora pahun, pe huya nime Yisak. ");
INSERT INTO nss_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisak isok hu ipa, <<Koluw wawu kanpwayi yo pe kanrasse yo kunnau, pe paratapeh wawu mui wawu sa kili yo paiwe?>> ");
INSERT INTO nss_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Pe yihu somwi yiy hupa, <<Yowu nimei tehe YAPAN ara itasura wou, pwen yowu pa tukarapaniu mwalinga rou. Yowu andre karapaniu kiyasura wou, ");
INSERT INTO nss_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","pe wou mbuna ambusi mwomwan kisa kili wou, paratesah, yowu kantandroyani wou pwi. Yowu kanmbusi hiyan o kinsa tam, pe yowu pwandrisa wou ayau ayapolo koisirai. Pe mahapo YAPAN itatoholi wou.>> ");
INSERT INTO nss_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Pwen Yisak ipo yon namandran iyatahu, pwen huya pe hunamnam pe huyin ndran iyawule. ");
INSERT INTO nss_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Pe hutine makohu ping o para lang sih, pe hupwatisingi nongan para tapaniu iro mwele hu. Pe Yisak ipwandrisa hu huyau, pe huyau huyapolo koisirai. ");
INSERT INTO nss_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Lang ara ko hu ndramat para poya mbulya Yisak huya kili yiy pe hupa, <<Yowu soye ndran ndrikou pe ndran ara kinisuw kinsa hiraliy.>> ");
INSERT INTO nss_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Pwen Yisak ipohowe ngala ndran ndrikou ara <<Sipah.>> Iro tandrohonga lang ara isa matne mahapo, hutora pohowe ngala kol ara <<Peersepa.>> ");
INSERT INTO nss_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tandrohongan ara, Esau iyen pe hayou tan mahaangui; pe yiy iwiri Yutit SuPeeri iya nambuyun, iyapolo Pasemat SuElon. Peeri hilu Elon ara hilu ndramira Hit. ");
INSERT INTO nss_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Kultuwayi mbuyungundra Yisak hilu Repekah ara ngara kimbusi ndrina hilu kimwa. ");
INSERT INTO nss_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisak ara, kinna parangoloh pwen, pe maran ara kinyoh pe kinlahiy para kinnime handra melit pwi. Pwen pe iyoh Esau, norun ndrihou kamai, pe ipwai iyatan ipa, <<Noru!>> Pe Esau isomwiy ipa, <<Tesah? Yo urupo.>> ");
INSERT INTO nss_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Pe Yisak ipa toro: <<Yo kunna parangoloh pwen, pe ukowu sehe lang andre kumat kaliy. ");
INSERT INTO nss_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Wou awiri kei tapuiwe kiyasura nah tam, pe aya yangiy pe ayakah ano hamou yohou. ");
INSERT INTO nss_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Pwen awiri yohou ara pe aruwaniy kiyasura anandrinai kapan iya mepo ngara kunamiliy, pwen awiriy kisa kili yo. Pe anandrino kuiniy kihipwen, pwen andre kuiki lomwes to kisa kili wou; kiyamulan andre kumat.>> ");
INSERT INTO nss_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Yisak iro wong iyata Esau manau, pe Repekah ara iro hilingiy. Pwen Esau kinyau kinna yangiy para kiyakah yohou kisa, ");
INSERT INTO nss_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","pe Repekah ipwai iyata Yakop ipa, <<Nahapoko yo uhilingiy tamam ipwai iyata Esau ipa, ");
INSERT INTO nss_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","<Awiri hamou yohou pe aruwaniy kiyapolo hayah anandrinai pe awiriy kisa kili yo. Andre yo kuiniy kihipwen, pwen andre yo kuiki lomwes to kisa kili wou kiya mara YAPAN; kiyamulan andre kumat.>> > ");
INSERT INTO nss_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Pwen Repekah ipa, <<Kiya, noru, wou ahalingi nokulani sehe melit nakupwai kisa tam para nambusiy mahapo. ");
INSERT INTO nss_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Aya kou pe apirani noru meme malmou mepo nombuwe hilu imuh, pe awiriy kisa kili yo. Pe andre yo kuruwaniy kiyasura anandrinai kapan iya, mepo tamam ngara kinamiliy. ");
INSERT INTO nss_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Pe wou awiriy kiya kili tamam, pe andre kiyniy. Pwen andre kiyki lomwes tan kisa kili wou; kamulan andre kimat.>> ");
INSERT INTO nss_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Hapeko Yakop irapaiwani poho tinan pe ipwai iyatan ipa, <<Wou apahsaniy tehe Esau ara yomyomun soyon, hapeko yo ara pwi–yo mondro saiyon o. ");
INSERT INTO nss_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Matisan tomo andre kihingoruwe yo pe kipa yo ara upwasike yiy; pwen yo mbukeno andre kumbusiy tehen tora pe andre kiten ano–pwen andre kunwiri lomwes tan pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hapeko tinan ipwai iyatan ipa, <<Noru, wou mbuna alohonge. Yo andre kukuni nopwaran ara. Ambusi sehe melit kunpwai; aya kou pe ayawiri meme malmou kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Pwen Yakop iya pe iyawiri meme malmou pe iyaikiy iya kili tinan. Pe Repekah iruwani anandrinai kapan iya mepo tama Yakop ngara kinamiliy. ");
INSERT INTO nss_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pwen Repekah iyawiri koyau hamou lahayan ata Esau iro seu, pe isuluyani Yakop iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Pe yiy ikulani nima Yakop pe koyun saiyon iya kapilo meme. ");
INSERT INTO nss_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Pe Repekah iwiri anandrinai mepo kapan, iyasura ndrinanohun mepo kinruwaniy ara, pe iyaikiy iya kili Yakop. ");
INSERT INTO nss_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Pwen Yakop iya kili taman pe iyoh ipa, <<Tomo!>> Pe Yisak isomwiy ipa, <<Apwai, noru. Wou hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakop ipwai iyata taman ipa, <<Yo Esau, norum ndrihou kamai. Yo kunmbusi melit masih tehe anpwai kinsa kili yo. Kiya, atine, ampwan, pe aini anam yohou. Kihipwen, aiki lomwes atam kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hapeko Yisak isok norun ipa, <<Noru, indrou sah, awiri yohou ara isa?>> Pe Yakop ipwai iyatan ipa, <<YAPAN, Ngindrai atam ara, ihingini yo yohou kileh.>> ");
INSERT INTO nss_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pwen Yisak ipa toro iyata Yakop: <<Asa pakeh pe kusehe mandram pe kuhungorwe wou na. Wou noru ndrihou kamai Esau ndrokonan ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Pe Yakop iya pakeh kili taman, pe taman ihingorwe sangin pe ipa toro: <<Wou ngasa mbulukoyum ara tehe Yakop. Hapeko yo uhungorwe nimam ara tehe nima Esau.>> ");
INSERT INTO nss_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yisak kinyorowe Yakop pwi, paratesah, yomu meme ara ikulani nima Yakop, pe imbusi niman ara yomyomun soyon iya tehe ata Esau. Pwen pe itoholi yiy. ");
INSERT INTO nss_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Hapeko isok yiy paiwe ipa, <<Wou ara noru Esau ndrokonan ndre pwi?>> Pe Yakop isomwiy ipa, <<Ehe, yo kopu.>> ");
INSERT INTO nss_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Pwen Yisak ipa, <<Arai ano hape yohou kisa. Yo kuiniy kihipwen, pwen andre kuiki lomwes to kisa kili wou.>> Yakop iwiriy iya kili yiy, pe iyniy; pe isap hayah ndrunu wain iyapairin pe iyin. ");
INSERT INTO nss_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Iyamulan taman ipwai iyatan ipa, <<Noru, asa pakeh pe arahunghung kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Pe Yakop iya pakeh pe irahunghung iya kili yiy, pe Yisak ihingi koyau ta Esau iro sangi Yakop. Pwen pe Yisak iyki lomwes iyatan pe ipa toro: <<Ngonoho melit hiyan ata noru, ara tehe ngonoho piyang YAPAN kintoholi pwen. ");
INSERT INTO nss_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Andre Ngindrai kimbusi nayak para ping kiyau yang kisa pe kimbusi anandrinai soyon kirayah kiro piyang tam masih. Pe andre yiy kihingini wou wit pe wain kisahapuh ara soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Andre hu ndramat para kol pwan masih andre hu karayah pwandrendres tam, pe andre hu katukuruhu kisa kili wou. Pe andre nalim hu pe ndraye tinam hu masih ara andre hu koro pahandram o. pe andre hu katukuruhu kisa kili wou. Kapa hiyeh kitten anam, andre Ngindrai kitten anan. Pe kapa hiyeh kitoholi wou ara andre Ngindrai kitoholi hu yi.>> ");
INSERT INTO nss_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisak iyki lomwes iyata Yakop ihipwen, pe Yakop itali yiy nakiyau, pwen nalin Esau iro yangiy ara isarayah. ");
INSERT INTO nss_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Yiy iruwani anandrinai hayah kapan, pe iyaikiy iya kili taman. Pwen ipwai iyata taman ipa, <<Tomo, atine pe aini anam yohou iripo kili yo ye, pwen pe aiki lomwes tam kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Pe taman Yisak isok yiy ipa, <<Wou hiyeh?>> Pe isomwiy ipa, <<Yo yeh, yo norum ndrihou kamai, Esau.>> ");
INSERT INTO nss_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisak ara, sangin ilelen namandran iya, pe ipa, <<Ara hiyeh ndrokonan mepo iwiri yohou pe isaikiy isa kili yo mamu? Yo uniy iroho pwen o, pe wou asarayah. Yo kuniyki lomwes to kinna kili yiy pwen, pe lomwes ara, ara atan masih.>> ");
INSERT INTO nss_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ihilingi nongna taman, pe yiy ara irang turut pe ipa, <<Tomo, wou aiki lomwes tam kisa kili yo yi.>> ");
INSERT INTO nss_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Hapeko yiy ipa, <<Nalim isa pe ipwaske yo pe kinwiri topwe lomwes tam.>> ");
INSERT INTO nss_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Pwen Esau ipa, <<Ngalan <Yakop> ara ilahi yiy imwonen, paratesah, kinpwasike yo maporoluwoh pwen ara. Yiy kinwiri noku tehe yiy ara ndrohan, pe nahapo kiniwiri lomwes to yi.>> Pwen yiy isok ipa, <<Lomwes tiken ita ndron ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisak ipwai iyatan ipa, <<Yo kunbmusi yiy kintayah pohon ta walu kene. Pe yo kunbmusi yowem hu andre karayah pwandrendres tan, pe kuniyki wit pe wain soyon kinna tan. Nahapo apa ndre sehe melit ndrokonan iripo ndron para kuikiy kisa kili wou, Noru?>> ");
INSERT INTO nss_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau ipwai iyata taman ipa, <<Tehen tapeh Tomo, lomwes ariya ko ndre ita ndron? Kapa kiro ndron, Tomo, aiki lomwes kisa kili yo yi!>> Pwen Esau irang turut paiwe. ");
INSERT INTO nss_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Pwen Yisak ipa toro iyatan, <<Andre kolom ara kiro mawen pwan hiyan, pe nayak para ping kiyau paingan yang ara kinlahiy para kisa ndrita pingem pwi. ");
INSERT INTO nss_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Wou andre apopahun kiya semela pahun niwen opu para apo anandrinam pe mipwan hiyan; pe wou andre aro pahandra nalim. Hapeko kamulan wou andre anto pahandra pwokere ta nalim pwi, pe kapa kiwong, andre anhilingi yiy pwi yi.>> ");
INSERT INTO nss_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ara ndrinan ilokuh ta Yakop, paratesah, taman iyki lomwes masih kinna tan. Lohongan ilohonganiy pe ipa, <<Pakeh tomo nakimat. Pe koisirai tan kihipwen, andre kutingundru Yakop.>> ");
INSERT INTO nss_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Hapeko Repekah ara kinhilingi lohonga Esau pwen, pe iyoh Yakop pe ipa, <<Ahilingiy! Nalim Esau ara ndriyan ita kiskis para kitingundrum. ");
INSERT INTO nss_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Noru, ambusiy sehe melit nakupwai satam: Atine kileh pe awop aya kili wayi Lapan ita kol Haran. ");
INSERT INTO nss_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Aya pe aro sura yiy kipoo ndrina lokuh ta nalim kihipwen. ");
INSERT INTO nss_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kapa ndrina lokuh ta nalim ara kihipwen, pe koyun kirut sehe melit ambusiy iyatan, pwen andre yo kupwanos wou pe amui asa yi. Tehen tapeh, andre kupiyani walu noru malmou kene porosih o?>> ");
INSERT INTO nss_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Pwen Repekah ipwai iyata Yisak ipa, <<Yo ara wele kinimai kinata hilu pihi Hit ara. Kapa Yakop kiyesou kiyatahu pihi Hit i, ara hiyan para kumat.>> ");
INSERT INTO nss_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yisak iyoh Yakop pe iyki lomwes iya kili yiy, pe ipwatisingiy iyatan ipa, <<Wou mbuna ayesou kiya kili hamou pihi Kenaan; konan! ");
INSERT INTO nss_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mahapoko aya Pattan Aram, aya wum ta tama tinam, Petuwel. Aro kili salim, Lapan, pe awiri norun hamou pihin kiya nambuyum. ");
INSERT INTO nss_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ngindrai Pwokeyan Masih andre kitoholi yesou tam, pe norum hu ara andre kasarayah soyon iya, pe wou andre asarayah tumbu hu yau soyon. ");
INSERT INTO nss_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngindrai andre kihingini lomwes ta Apraham kisa kili wou pe ndrayem hu kamulan. Pe pwan mamu mepo Ngindrai kiniykiy kinna ta Apraham, mahapo asa amiraliy, ara andre awiriy kiya pwanem.>> ");
INSERT INTO nss_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Pwen Yisak ipwandrisa Yakop iyau iya Pattan Aram, iya kili Lapan noru Petuwel, yiy ndramira Aram. Pe Lapan ara wayi Repekah, tina Yakop pe Esau. ");
INSERT INTO nss_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Napwai Esau kinpahasaniy pwen tehe Yisak kiniyki lomwes kinna ta Yakop, pe kinpwandrisa yiy kinna Pattan Aram para kiya yesou. Iro tandrohonga iyki lomwes iya kili yiy, ipwatisingiy iyatan ipa, <<Mbuna ayesou kiya kili hu pihi Kenaan.>> ");
INSERT INTO nss_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Pe Yakop ihilingi nongna taman pe tinan, pe kinyau kinna kol Pattan Aram. ");
INSERT INTO nss_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Napwai Esau kinpahsaniy pwen tehe taman Yisak ara kinoho namili hu pihi Kenaan ara pwi yoh; ");
INSERT INTO nss_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","pwen Esau iya kili hu yowe Yismayel NdraApraham pe iya wiri Mahalat SuYismayel, pisu Nepayot, iya nambuyun. Pe iwiri yiy iya paiwa hilu pihi mu tora kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakop itali kol Peersepa pe iyau para kiya kol Haran. ");
INSERT INTO nss_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yiy irotokai ipoo iyarayah iya kol hakol, pe yiy iro aliy para kimatin, paratesah, paramwandrai ara kinpiyah pwen. Pwen pe iwiri pat sih pe iykiy iye pwan iya waingan pe iye matin aliy. ");
INSERT INTO nss_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yiy imatin pe inihiyani kannen sih, sahin iro pwan, pe sahin ara iya paingan yang, pe hu angelou ta Ngindrai ara soyon iya huro ngas ya paingan, pe hurolai sapwan. ");
INSERT INTO nss_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Pwen yiy inime YAPAN iho tine pakeh pe ipa, <<Yo ara YAPAN, Ngindrai ta tumbum Apraham pe Ngindrai ta tamam Yisak. Pwan mepo ayera matin aliy, ara andre yo kuikiy kisa tam pe ndrayem hu. ");
INSERT INTO nss_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ndrayem hu ara andre kasarayah soyon iya tehe kohu pwan, pe andre yihu kamasumbuwe kaya rai, kup, hai, pe tolau. Hu ndramat para kol pwan masih andre hu kawiri lomwes ara kiyau kili wou pe ndrayem hu. ");
INSERT INTO nss_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Hape aleheh naya aliy ara uta sura wou, pe uta pwokarani wou, pe andre yo kuwiri wou amui asa pwan iye yi. Pe andre kuntali wou pwi kipoo kumbusi melit masih tehe upwai satam.>> ");
INSERT INTO nss_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakop isapoyoi pe ipa, <<Ndrokonan tehe YAPAN ara iripo kol iye, pe yo ara ukowu!>> ");
INSERT INTO nss_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yiy inoh pe ipa, <<Kol iye tehen tapeh ndrokonan; andre ndrohonoku yumwa Ngindrai! Ndrokonan! Hape aro ara andre ndrohonoku karam para yang.>> ");
INSERT INTO nss_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakop itine mandroulang pe iwiri pat iye waingan ara, pe isondritiyaniy iro tine para kiho rokai pe lohongan kiro aliy. Pwen pe itilingi ndraikei para holip iya ndritan para kipwaingani pat ara tehe ata Ngindrai. ");
INSERT INTO nss_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Koluw hupohowe kol ara <<Lus,>> pe lang ara Yakop ipaiwani ngala kol ara iya <<Petel.>> ");
INSERT INTO nss_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Pe Yakop irapaniu iya kili Ngindrai toro: <<Kapa Ngindrai kiro sura yo, pe kipwokarani yo para tokuyo uropo mbusiy, pe kapa kihang yo anandrino pe koiwe, ");
INSERT INTO nss_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","pe kapa yo kuro hiyan o pe kumui kuyarayah kuya kol ta tomo, pwen andre YAPAN kisarayah Ngindrai to. ");
INSERT INTO nss_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kol mepo usondritiyani pat ita tine aliy ara para kulohonganiy tehe aro ara yumwa Ngindrai. Pe melit masih nahang yo ara andre kuiki sih kiyau mwele melit masongui ara kimui kisa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakop iro rokai manau iropo iya, pe iyarayah iya kili hu ndramat para kup. ");
INSERT INTO nss_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Pe maran pakiya pwi, inime ndran ndrikou iro kol ngawan. Pe yihu sipsip hurawure hu huya mandrairoyoh pe huye matin ndrahasa ndran ndrikou, paratesah, ngara hu kayin ndran ara. Hapeko pat namandran ara iye ndrita pohomara ndrikou. ");
INSERT INTO nss_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Pwen kapa hu sipsip masih kasa harong, hu ndramira sipsip ngara hu kasa pe katiriyani pat kiya mawen pohomara ndrikou, pe hu sipsip kayin ndran. Kihipwen, hu ndramira sipsip ngara katiriyani pat kimui kiya nokun paiwe. ");
INSERT INTO nss_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakop isok hu ndramira sipsip ipa, <<Wawu nali, wawu paraleheh?>> Pe yihu somwiy hupa, <<Yowu para kol Haran.>> ");
INSERT INTO nss_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Pwen Yakop isok hu ipa, <<Wawu pahasani tumbu Nahor kamai ngalan Lapan, ndre pwi?>> Yihu somwiy hupa, <<Ehe, yowu pahasani yiy.>> ");
INSERT INTO nss_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Pe ipwai iyatahu ipa, <<Yiy hiyan o, ndre?>> Yihu pa, <<Ehe, yiy ara hiyan o. Animei! Norun pihin Rahel isayau yohou iyasura hu sipsip ta taman.>> ");
INSERT INTO nss_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakop ipwai iyatahu ipa, <<Akanimei, paramwandrai iripondron paingan pe paramwandrai para hu sipsip karawurehu ara mapu. Akahang hu ndran pe akawiri hu kamui kaya yan ndromwindriu.>> ");
INSERT INTO nss_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Yihu pa, <<Yowu kanlahiy para kambusiy pwi, kipoo yihu sipsip masih kasa harong. Pwen andre yowu kawiri pat kiya mawen pe yihu sipsip kayin ndran.>> ");
INSERT INTO nss_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakop iro wong iyasura hu manau, pe Rahel isarayah iyasura hu sipsip ta taman, paratesah, ngara kipwokerani hu. ");
INSERT INTO nss_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakop inime noru salin pihin iyasura hu sipsip tan, pwen iya ndrikou pe itiriyani pat iya mawen, pe iyuk ndran iyatahu sipsip ta salin Lapan. ");
INSERT INTO nss_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Pwen pe Yakop irahunghung iyata Rahel pe irang namandran. ");
INSERT INTO nss_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yiy ipwai iyata Rahel ipa, <<Yo pe tamam ara youlu hapat o. Yo ara noru Repekah.>> Pwen pe Rahel ingap iya pe inese ndrainga taman. ");
INSERT INTO nss_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lapan ihilingiy tehe noru pisun, Yakop, isa, pe ileheleh iya pe iya pohonani yiy iho sai. Lapan indrohosi yiy, pe irahunghung iyatan, pe iwiri yiy iya seu. Pwen Yakop itiyani melit masih irayah kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lapan ipa, <<Ndrokonan! Talu ara ndriya sih opu.>> Pwen pe Yakop iye manau sura yiy walah sih imwonen. ");
INSERT INTO nss_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lapan ipwai iyata Yakop ipa, <<Mahisan apa ndre wou ara ndraiye pe apo mbulyo ko mwaihei, ara pwi yoh. Apwai sato, kennem ara masahayeh?>> ");
INSERT INTO nss_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Pe Lapan ara manorun malmou pihin–pihi namandran ngalan Leyah, pe pihi mendreheh ngalan Rahel. ");
INSERT INTO nss_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leyah ara maran lahin, hapeko Rahel, ara yiy lahayan masih, pe iramwaitini Leyah. ");
INSERT INTO nss_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakop ara inamili Rahel pwokeyan iya, pe ipa, <<Andre kupo mbulyam nondriya hayou manandrtoyoh. Kihipwen, pwen kuwiri Rahel, norum kopwan pihin.>> ");
INSERT INTO nss_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Pwen Lapan ipa, <<Hiyan! Andre kuniyki yiy kinna tahu hayah pwi. Hiyan para kuiki yiy kisa tam. Pwen andre aro sura yo.>> ");
INSERT INTO nss_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakop ipo mbulen iya mane hayou andrtoyoh para kiwiri Rahel. Hapeko, hayou manandrtoyoh ara tehe lang masahayeh o, paratesah ndriyan imbuluhi Rahel namandran pe pwokeyan iya. ");
INSERT INTO nss_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Pwen Yakop ipwai iya kili Lapan ipa, <<Hayou manandrtoyoh pwen; awiri Rahel kisa pe youlu nakayesou ara.>> ");
INSERT INTO nss_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Pwen pe Lapan ipo kowase hilu pe imbultani hu ndramat masih para kol ara husawule pe hunamnam. ");
INSERT INTO nss_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ping ara kiniwiri Rahel pwi, hapeko iwiri Leyah isa kili Yakop, pe Yakop imatin iyasura yiy. ");
INSERT INTO nss_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lapan iyki pihin hamou para poya mbulyan, ngalan Silpah, ara iya kili Leyah para kipo mbulyan. ");
INSERT INTO nss_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ndroulang para ping ara, Yakop inimei tehe yiy ara Leyah! Pwen Yakop iya kili Lapan pe ipa, <<Paratesah pe ambusi tora isa kili yo? Yo upo mbulyam para kuwiri Rahel. Paratesah apwasike yo?>> ");
INSERT INTO nss_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lapan ipa, <<Kowase yowu, ara konohoiki noru yowu pihi mendreheh kiyesou kimu kiya kili pihi namandran ara pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Alonge na kipoo kowase yesou para sandre sih kisayau na. Pwen andre kuiki Rahel kisa tam kapa ambuluyani mbulen nondriya hayou manandrtoyoh paiwe yi.>> ");
INSERT INTO nss_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakop ipwes. Iya sandre para kowase hilu Leyah ilon, pwen Lapan iyki norun pihin Rahel iya kili Yakop iya nambuyun. ");
INSERT INTO nss_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lapan iyki pihin hamou para poya mbulyan, ngalan Pilhah, iya kili Rahel para kipo mbulyan. ");
INSERT INTO nss_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakop imatin iyasura Rahel, pe inamili Rahel namandran iya iyata Leyah. Pwen pe ipo mbulen ta Lapan hayou manandrtoyoh paiwe yi. ");
INSERT INTO nss_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","YAPAN inimei tehe Yakop welen imai ta Leyah. Tehen tora ko pe YAPAN isopwat Leyah para kipo mbunah. Hapeko Rahel ara norun pwi. ");
INSERT INTO nss_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leyah ara mapundriyan pe imwalahiy iyata norun kamai hamou, pe yiy ipa, <<YAPAN inime nopwaran ato, pe mahapo ara nambuyu andre kinamili yo.>> Pe ipohowe ngala mbunah ara Rupen. ");
INSERT INTO nss_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yiy mapundriyan paiwe pe imwalahiy iyata mbunah kamai hamou, pe ipa, <<YAPAN iyki noru kamai yi. YAPAN ihilingiy tehe Yakop kinnamili yo pwi.>> Pwen pe yiy ipohowe ngala mbunah ara <<Simeyon.>> ");
INSERT INTO nss_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Pwen Leyah ara mapundriyan pe imwalahiy iyata norun kamai hamou paiwe yi. Pe yiy ipa, <<Matisan nambuyu mahapo welen kiso to, paratesah, yo kunmwalahiy pwen kinna tahu mbunah matimou.>> Pe ipohowe ngala mbunah ara <<Lepi.>> ");
INSERT INTO nss_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Pwen iyamulan, yiy mapundriyan paiwe pe imwalahiy iyata norun kamai hamou i. Leyah ipa, <<Mahapo andre kuhuri ngala YAPAN.>> Pe ipohowe ngala mbunah ara <<Yutah.>> Pwen pe Leyah ingoh para kipo mbunah hape, pe ihou. ");
INSERT INTO nss_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Pwen Rahel ara inimei tehe kinkun hamou noru Yakop pwi. Pe Rahel ara ingongowani nalin Leyah, pe ipwai iyata Yakop ipa, <<Ahang yo hamou mbunah! Kapa pwi, andre kumat.>> ");
INSERT INTO nss_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakop ndrinan ilokuh ta Rahel pe ipa, <<Apa ndre yo Ngindrai? Ngindrai mbukenan iparuwe wou pe ankun mbunah pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Pe Rahel ipa, <<Iye ara Pilhah, pihin para poya mbuluyo. Amatin kiyasura yiy pe alkapo mbunah kanoru pe yo andre kurayah tina hu mbunah ara.>> ");
INSERT INTO nss_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Pwen pe Rahel iwiri Pilhah, pihin para poya mbuluyan, pe iyki yiy iya kili Yakop, pe Yakop imatin iyasura yiy. ");
INSERT INTO nss_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Pe Pilhah mapundriyan pe imwalahiy iyata norun hamou kamai. ");
INSERT INTO nss_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Pwen Rahel ipa, <<Ngindrai kinnime yo pwen, pe yiy kinpahasani kultuw ato. Yiy kinhilingi totohun to pe iyki mbunah kamai iye isa kili yo.>> Pwen pe Rahel ipohowe ngalan ara <<Tan.>> ");
INSERT INTO nss_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Pe Pilhah mapundriyan paiwe, pe imwalahiy iyata noru Yakop hamou kamai yi. ");
INSERT INTO nss_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel ipa, <<Ndriyo itayi nali pe kuntamwaitini yiy.>> Pwen pe ipohowe ngalan ara <<Naptali.>> ");
INSERT INTO nss_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lang ara Leyah inimei tehe yiy kinihipwen mbunah i. Pe yiy iyki Silpah, pihin para poya mbulyan, iya kili Yakop tehe nambuyun. ");
INSERT INTO nss_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Iyamulan, Silpah imwalahiy iyata mbunah kamai hamou noru Yakop. ");
INSERT INTO nss_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Pwen pe Leyah ipa, <<Mwakan kuntamwaitini yiy.>> Pwen pe ipohowe ngalan ara <<Kat.>> ");
INSERT INTO nss_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Pihin para poya mbulya Leyah, Silpah, ara imwalahiy iyata noru Yakop hamou kamai paiwe yi. ");
INSERT INTO nss_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Pe Leyah ipwai ipa, <<Yo upwes, pe andre yihu pihin masih hu kapa yo ara pihin para pwesai.>> Pwen pe ipohowe ngalan ara <<Aser.>> ");
INSERT INTO nss_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Imwonen lang para poya wit pe Rupen iya piyang pe inime mbuwa nonou hayah, irihiy, pe iwiriy pe isaikiy isa kili tinan Leyah. Pe Rahel ipwai iyata Leyah ipa, <<Yo unamili nonou ta norum kamai ara; ahang yo hayah.>> ");
INSERT INTO nss_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leyah ipa, <<Wou anwiri nambuyu pwen, pe ara kinlahi wou pwi? Pe mahapo apawiri nonou ta noru kapolon i?>> Rahel ipa, <<Hiyan, nepo kiping amatin sura Yakop pe apo soiwi nonou ta norum.>> ");
INSERT INTO nss_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kol ipiyah, Yakop itali piyang pe isarayah. Leyah iya pohonani yiy pe ipa, <<Wou andre amatin kiyasura yo nepo kiping, paratesah, kunsowani wou kinna nonou ta noru kamai pwen.>> Pwen pe ping ara Yakop imatin iyasura yiy. ");
INSERT INTO nss_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ngindrai ihilingi totohun ta Leyah, pe imwalahiy iyata noru Yakop kamai paiwe iyasura hu mahaamou i. ");
INSERT INTO nss_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Pwen Leyah ipa, <<Ngindrai iyki ndraimo isa kili yo, paratesah, yo uiki pihin para mbuluyo iya kili kamai to.>> Pwen ipohowe ngala norun ara Yissakar. ");
INSERT INTO nss_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leyah imwalahiy paiwe iyata noru Yakop hamou kamai. Ndromweyahu masih iya harong nahapo ara hu mannomou. ");
INSERT INTO nss_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Pe Leyah ipa, <<Yukyuk ta Ngindrai ara ihingini yo melit handra hiyan iya. Nepo aro nambuyu andre kinamili yo, paratesah, yo kunmwalahiy kinnata norun hu mannomou kamai.>> Pwen pe ipohowe ngalan ara Sepulun. ");
INSERT INTO nss_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Iyamulan imwalahiy iyata norun hamou pihin, pe ipohowe ngalan ara Tainah. ");
INSERT INTO nss_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Pwen pe Ngindrai ilohongani Rahel, pe ihilingi totohun tan pe ipaiwani mundropwa ndriyan para kipo mbunah. ");
INSERT INTO nss_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yiy mapundriyan pe imwalahiy iyata norun hamou kamai. Pe ipa, <<Ngindrai kinrapiyani masirai to kinnau pe ihingini noru hamou kamai. ");
INSERT INTO nss_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Andre YAPAN kiyki noru kamai hamou i.>> Pwen ipohowe ngalan ara Yosep. ");
INSERT INTO nss_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Iyamulan para Rahel imwalahiy ta Yosep, Yakop ipwai iyata Lapan ipa, <<Hiyan para apwai pe kumui kuya kolo pe pwane imwonen. ");
INSERT INTO nss_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Wou anpahasaniy tehe yo uropo po mbulyam isa matne mahapo. Pe mbulyam masih apwai ara umbulyaniy topwei. Pwen mahapo apa hiyan para kuwiri nambuyu hu pe noru hu pe yowu kayau ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Hapeko Lapan ipwai iya kili yiy ipa, <<Andre kupa handra lohongo kisa kili wou na; yo urakowem pe unimei tehe YAPAN imbusi hiyan isa kili yo, paratesah, wou aropo kili yo. ");
INSERT INTO nss_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nahapo apohowe kennem masehayeh, pwen pe andre kusowani wou.>> ");
INSERT INTO nss_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakop ipwai iyatan ipa, <<Wou anpahasaniy tehe sipsip tam masih huya soyon ara iya pahandra mbulen pe pwokere to ko. ");
INSERT INTO nss_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Koluw hu sipsip tam ara kanhon tehe mahapo pwi yoh. YAPAN ara itoholi wou iya mbulen urupo mbusiy pe hu sipsip tam kansarayah soyon iya. Hapeko nahapo yo mbukeno ara unamiliy para kupo mbuluyo imwonen.>> ");
INSERT INTO nss_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lapan isok yiy ipa, <<Andre kusowani wou kiya tesah?>> Yakop ipa, <<Yo mbuwali para asowani yo, hapeko andre kupokarani hu sipsip porosih i kapa apwes kiya lohongai to nakupwai mahapo iye; ");
INSERT INTO nss_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nahapo andre kuya nime hu sipsip pe meme tam hutora kowahu pe kuwiri hu noru sipsip lokuran, kiyasura hu noru sipsip pe meme soluhuyai; yihu masih andre kuwiri hu kaya sowo. ");
INSERT INTO nss_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pe kamulan kapa asa pe anime hu sipsip pe meme para sowo, andre apahasaniy tehe nongan upwai satam mahapo ara ndrokonan ndre pwi. Kapa asanime hu sipsip ndre meme to mepo lokuran pwi ndre soluhuyai pwi, pwen ara ipwaingani tehe kunpahanowe hu.>> ");
INSERT INTO nss_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lapan ipa, <<Yo upwes; talu kambusi tehe apwai.>> ");
INSERT INTO nss_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Hapeko iro mwonen lang ara ko, Lapan ihirani hu meme iyapolo hu sipsip lokuran, pe ipwai iyata norun hu kamai para hu kaluwi hu sipsip pe hu meme ara kaya hape mwanan pe marahu koro tahu. ");
INSERT INTO nss_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Pwen pe Lapan iyasura norun hu hutali kol ara pe huyau pe huye rokai lang maroyoh huya mawen kili Yakop. Pe Yakop ara maran iro tahu sipsip pe meme hayah ta Lapan. ");
INSERT INTO nss_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iyamulan Yakop iwiri hu sino ndraikei mwandran tiken para hu kei matikou, pwen irapelei pe irakaiyani kapilohu–hape iyau, hape iro, hape iyau, hape iro–pe ndrinan pallen ara isarayah. ");
INSERT INTO nss_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yakop iyki hu ndrandra kei ara iro mu iyatahu sipsip pe meme; iyki hu ara iro ndrohonoku pwelekei mepo ngara hu kayin ndran kiro aliy. Iyki hu iro ara, paratesah, yihu sipsip pe meme kapa hu kasa para kayin ndran kiro mwonen walahehu, pwen andre hu hamou kiya kili hamou. ");
INSERT INTO nss_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Pwen iyamulan pe hu meme huya kili hamou-hamou iro mu para ndrandra kei ara, pwen pe hu meme hurosus noruhu ara soluhuyai o. ");
INSERT INTO nss_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakop ara ipirani noru hu sipsip pe meme mendreheh pe soluhuyai, ara iya mawen kili hu namandran. Pe irapaiwani hu sipsip pe meme namandran ara marahu iya ndrandra kei mepo hu kan lokuran ta Lapan iro aliy. Tehen tora ko Yakop iyki hu sipsip pe meme tan iro mawen iyata Lapan. ");
INSERT INTO nss_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Walehe hu sipsip namandran isarayah para hamou kiya kili hamou, Yakop ngara kiyki ndrandra kei kiro mu kiya pakeh kili pwelekei tahu para ndran. Pwen andre hu hamou kiya kili hamou. ");
INSERT INTO nss_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Hapeko Yakop ara kinohoiki ndrandra kei kinto mwalinga hu sipsip pe meme mepo humbuyei para hamou kiya kili hamou, ara pwi yoh. Iyamulan yihu sipsip pe meme ta Lapan ara hu masih kanmbuyei topwei, hapeko ta Yakop ara mandrahu saiyon pe pwokeyan. ");
INSERT INTO nss_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Tehen tora ko Yakop ara irayah ndramat hamou namandran pe mangalan. Yiy imbusiy pe hu sipsip pe meme pe ndramiran para poya mbulyan, pe hu kamel iyapolo hu tongkiy tan ara husarayah huya soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakop ihilingiy tehe noru Lapan hu kamai ara huro pwahaltani yiy hupa, <<Yakop kinpo topwe memelit masih ta tama yowu. Yiy irayah ndramat namandran pe melit tan iya soyon, ara iro kili tama yowu ko.>> ");
INSERT INTO nss_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Pe Yakop inime pakut ta Lapan ara imeu pe kinmbus tehe koluw pwi. ");
INSERT INTO nss_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Pwen YAPAN ipwai iyata Yakop ipa, <<Amui aya kolo tamam hu pe yowem hu, pe andre kuro sura wou.>> ");
INSERT INTO nss_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Pwen Yakop ipwanos nongan iya kili Rahel pe Leyah para hilu kasa nime yiy kasa kol mepo hu sipsip pe meme tan iro aliy. ");
INSERT INTO nss_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ipwai iyata hilu ipa, <<Ngindrai ta tomo hu ara iripo sura yo, pe yo unumei tehe tama walu ara kinnamili yo tehe koluw kinna pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Walu pahasaniy tehe umbulyani mbulya tama walu iyasura pwoke to masih. ");
INSERT INTO nss_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Pe tama walu ara ipwasike yo pe kenne ara irapaiwaniy maporosongui. Hapeko Ngindrai ara ikaituwe yiy pe kinmbusi handra melit mwomwan kinsa kili yo pwi. ");
INSERT INTO nss_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mamu Lapan ipa hiyan para hu meme mepo soluhuyai ara ato para sowo. Hapeko iyamulan hu meme hurosus pe noruhu ara hurayah soluhuyai opu. Pwen ipa hiyan para hu meme mepo kinima soluhuyai iro mandrahu niwen, ara kiya para sowo. Pwen iyamulan yihu meme ara hurosus pe noruhu husarayah pe kinima soluhuyai iho mandrahu ara niwen opu. ");
INSERT INTO nss_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Pwen tehen tora ko pe Ngindrai iwiri hu sipsip pe meme ta tama walu isa mawen kili yiy pe iyki hu sato. ");
INSERT INTO nss_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Porosih aro, imwonen walehe hu meme kamai ngara hu kaya kili hu meme pihin isarayah, pe yo unihinih pe unime hu meme kamai mepo yomuhu soluhuyai opu ara huya kili hu meme pihin. ");
INSERT INTO nss_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Pe yo unihiyani angelou hamou ta Ngindrai isa pe iyoh isa kili yo ipa, <Yakop!> Pe yo upa, <Tesah; yo ye.> ");
INSERT INTO nss_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Pe yiy ipa, <Animei! Yihu meme kamai mepo hu torapo iya kili hu meme pihin yomuhu ara soluhuyai opu. Yo umbusiy pe isarayah tehen tora ko, paratesah, unimei tehe Lapan ngara kirakultuwani wou. ");
INSERT INTO nss_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yo ara Ngindrai mepo usarayah usa kili wou aro Petel, pe arapaniu isa kili yo pe atilingi ndraikei para holip iya ndrita pat sih para lolohonge. Nahapo amui aya kolom mepo amwalahiy aro aliy.> >> ");
INSERT INTO nss_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Pwen Rahel pe Leyah hilu somwi Yakop hilpa, <<Pe youlu ara kanlahiy para kapo hayah melta tama youlu pwi. ");
INSERT INTO nss_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yiy imbusi youlu ara tehe hu pihi mawen. Yiy kinwiri kenne youlu pwen, hapeko yiy kinirasumbuwaniy topwei. ");
INSERT INTO nss_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Hiyan, melit masih mepo Ngindrai iwiriy iro kili tama youlu ara kinna torou pe noru worou hu. Wou ambusi sehe melit mepo Ngindrai kinpwai kinsatam.>> ");
INSERT INTO nss_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Pwen Yakop iyki hu pihin tan pe norun hu ara huya ndrita hu kamel hayah, ");
INSERT INTO nss_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","pe irakuhuyani hu para hu nakayau kaya kolo taman Yisak ita kol Kenaan. Pe imbultaha hu kan tan masih ara huro mu kili yiy, iyasura melit masih mepo iwiriy iro Pattan Aram. ");
INSERT INTO nss_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Iro mwonen lang ara, Lapan kinyau kinna san yomuhu sipsip tan, pe Rahel iya pe ipahanowe hu kerewek ata taman mepo ngara kiykiy kiro memerani suwen. ");
INSERT INTO nss_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakop kinnese ndrainga Lapan ndramira Aram tehe yiy nakiyau ara pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yiy iwiri menmenan masih pe iwop kokohe ko, pe isingondriti ndran namandran Yuprates. Pwen pe irikai iyapwen te ngondron para pahayi Kileyat. ");
INSERT INTO nss_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Lang malwoh ihipwen, pe iya lang maroyoh hutiye ndrainga Lapan tehe Yakop ara kinwop. ");
INSERT INTO nss_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Pwen Lapan iwiri hu ndriya sih o, pe huro ndruwa Yakop. Lang manandrtoyoh ihipwen, huyarayah huya kili Yakop iro kol pahayi ngondron para Kileyat. ");
INSERT INTO nss_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ping ara Ngindrai iyarayah iya kili Lapan iya nihinih pe ipa, <<Maram kiro tam; mbuna apa hapesah hiyan ndre mwomwan kiya kili Yakop.>> ");
INSERT INTO nss_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Pwen Yakop hu, hu kanpwili yopeyehu pwen iro kol pahayi ngondron para Kileyat. Pe Lapan hu husako, hunime Yakop, pe hupwili yopeyehu iho ngilse hu tehen aliy yi. ");
INSERT INTO nss_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Pwen Lapan ipwai iyata Yakop ipa, <<Tehen tapeh ndrokonan apakarawani yo pe apahanowe noru malmou pihin pe wawu yau, tehe hu ndramat para pahun ngara kambusiy? ");
INSERT INTO nss_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Paratapeh ansike yo pwi pe wawu wop kokohon opu? Kapa anese hape, pwen kupwai kiyatahu yau to pe yowu kapwesani wawu kiya ndramiy, kuwah, pe waliy pe wawu kayau. ");
INSERT INTO nss_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wou anpa hiyan kinsato para kuhunghung kiyata tumbu hu pe noru hilu pihin ara pwi. Ambusi kultuw ara tehe ndramat lohonga pwi. ");
INSERT INTO nss_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yo uhungorowe pwoke to ara ilahiy para kumbusi mwomwan kisa kili wou. Hapeko pinge ping Ngindrai ta tamam ipwai isa kili yo ipa, <Mbuna apa hapesah hiyan ndre mwomwan kiya kili Yakop.> ");
INSERT INTO nss_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nahapo anamiliy para amui aya kili tamam pe yowem hu. Ara hiyan. Hapeko, paratapeh apahanowe hu kerewek to?>> ");
INSERT INTO nss_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakop ipwai iya kili Lapan ipa, <<Unohowaniy matisan aratuwe norum hilu. ");
INSERT INTO nss_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kiya, kapa akahi hiyeh iwiri hu kerewek tam, ara andre katingundrun kimat. Hu yowe tolu topo, pe kapa anime handra melit tam iripo kili yo, pwen awiriy.>> Hapeko Yakop ara ikowu tehe Rahel kinpahanowe hu kerewek ta taman. ");
INSERT INTO nss_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Pwen Lapan isong imu iya kamai ta Yakop, pwen iya kamai ta Leyah. Pwen iyamulan isong iya nondriya kamai ata hilu pihin para poya mbulya hilu malmou. Hapeko iya kinkahi hu kerewek tan pwi. Iyamulan isa ngawan pe isong iya kamai ta Rahel. ");
INSERT INTO nss_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel ara iwiri hu kerewek ta taman pe ikohoni hu iro pahandra melit para hatina mbulu ndramat mepo ngara hu kaiki kiro ndrita kamel. Pe Rahel irompwan ndritan. Lapan ara ipokekelah nondriya kamai masih hapeko kininimei pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Pe Rahel ipwai iya kili taman ipa, <<Ndrinam mbuna kilokuh to, tomo, yo kunlahiy para kutine kiro mbulmaram pwi, paratesah, mwamwa towu pihin ara iwiri yo.>> Pwen pe taman ara ikah, ikah, ikah ndrit. ");
INSERT INTO nss_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Pwen Yakop irandrokomat iyata Lapan ipa, <<O nono, umbusi sehe kultuw mwomwaneh, pe aro ndruwo? ");
INSERT INTO nss_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wou anmbuingiri nondriya suwe yowu pwen, pe antele hu kerewek tam? Kapa antelei, kiya, awiriy kisa ngawan pe hu yowe talu hu kanimei pe karamwaniyani talu. ");
INSERT INTO nss_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yo uro sura wou hayou malungui, pe yihu sipsip pe meme tam ara hurosus hiyan o. Pe yo ara kunyan hamou sipsip tam kamai pwi. ");
INSERT INTO nss_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kapa hu kan mwomwan para yangiy hu karayi hamou sipsip ndre meme ara yo kunohosap kisa kili wou pwi. Yo ngara kuwiriy ato mbukeno pe ngara kupo soiwin. Pe wou akekeyani yo para kusowani sehe melit hu pahanowei, lang ndre ping. ");
INSERT INTO nss_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lang sih tehe sih ngara mwandrai kitimwi yo, pe ngara kuwulen kiping, pe kunho matin hiyan pwi. ");
INSERT INTO nss_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yo uro sura wou hayou malungui. Pe upo mbulyam hayou songui pe haahiu ara para kuwiri norum hilu pihin malmou. Pe hayou manonoh iyapolon ara para kuwiri hu meme pe sipsip tam hayah. Hapeko wou lang masih ngara arapaiwani kenne. ");
INSERT INTO nss_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kapa Ngindrai ta tumbu Apraham mepo tomo Yisak ngara kitohun kiyatan ara kintosura yo pwi, ara andre kunyau o mwaihei, pe andre kunkun hapesah pwi. Hapeko Ngindrai inime sehe mbulen ngandrahan umbusiy iya nimo. Pwen pinge ping isaiki nongan pwokeyan isa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lapan iwong imui iya kili Yakop ipa, <<Hilu pihin malmou ara noru, pe hu mbunah ara tumbu; pe hu sipsip pe meme ara ato yi. Melit masih ata nimei ara ato. Hapeko mahapo andre kumbusi tesah para kukaituwe noru hilu malmou pihin kiyapolo noru hilu hu? ");
INSERT INTO nss_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Asa talu kasoye pat para kipwaingani tapaniu mwele rou.>> ");
INSERT INTO nss_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Pwen Yakop itine pe iwiri pat sih niwen pe isoyei para kipwaingani tapaniu. ");
INSERT INTO nss_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Pe ipwai iya kili yowen hu pe humbultani pat hayah. Huwiri hu pat hayah ara pe humbultani hu huya ndrohos sih. Pwen hu masih huya mbultere hu pe hunamnam huro pakeh kili ndrohos ara. ");
INSERT INTO nss_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lapan ipohowe ngala hape ara, ara <<Yekar Sahatuta.>> Pe Yakop ipohowei ngalan, ara <<Kaleet.>> ");
INSERT INTO nss_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lapan ipwai iyata Yakop ipa, <<Ndrohos iye ara andre kinima tapaniu ta talu.>> Tehen tora ko hupohowe ngala kol ara <<Kaleet.>> ");
INSERT INTO nss_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Pe Lapan ipa tehen toro yi, <<Mara YAPAN andre kiro kili talu tandrohonga talu koro mawen kili hamou-hamou.>> Pwen hupohowe ngala ndrohos ara <<Mispah>> i. ");
INSERT INTO nss_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Pe Lapan iwong ipa, <<Kapa ambusi mwomwan kiya kili noru malmou, ndre ayesou kiya kili hu pihin hayah i; alohonganiy tehe Ngindrai ara maran iripo kili talu.>> ");
INSERT INTO nss_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Pe Lapan iwong paiwe iya kili Yakop ipa, <<Animei, pat niwen kunsoyei, iyapolo ndrohos iye. ");
INSERT INTO nss_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Pat niwen ara, pe ndrohos iye, ara kinima tapaniu talu mbusiy mwalinga talu. Yo andre kuntamwaitini kinima tapaniu ta talu para kusa popahun kisa kili wou, ara pwi. Pe wou tehen aliy yi; mbuna aramwaitini kinima tapaniu ta talu pe asa popahun kisa kili yo, ara pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ngindrai ta Apraham pe Ngindrai ta Nahor ara andre kiramwaniye mwalinga talu.>> Pwen Yakop irandrangan iya ngala Ngindrai mepo Yisak ngara kitotohun kiya tan. ");
INSERT INTO nss_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yiy itingundru kan hamou pe iykiy tehe yukyuk iro pahayi ara, pe ipwanos hu ndramiran husa namnam iyasura yiy. ");
INSERT INTO nss_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Makohuping para lang sih, Lapan irahunghung iyata tumbun hu pe norun hilu pihin malmou. Pwen itali hu pe imui iya kolon. ");
INSERT INTO nss_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Pe Yakop hu, huro tokai huya pe hu angelou hayah ta Ngindrai husa rapohonani hu huro sai. ");
INSERT INTO nss_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Inime hu, pe ipa, <<Iye ara kolo Ngindrai.>> Pwen pe ipohowe ngala kol ara <<Mahanayim.>> ");
INSERT INTO nss_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakop nakipwandrisa hu ndramiran hayah para huro mu tahu pe huya kili nalin Esau iro kol Seyir, ita nondriya kol Etom. ");
INSERT INTO nss_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Pwen ipwai iya kili hu ipa, <<Iye ara nongno para akaya pwai kiyata yapane Esau. Akapa toro: <Yo Yakop, pwandrendres tam. Uro sura Lapan ipoo iya matne mahapo, pe nakumui kusa ara. ");
INSERT INTO nss_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yo mamenmeno masih kene: tehe hu mbulmwakau, tongkiy, sipsip, pe meme iyapolo hu ndramat kamai pe pihin. Yapane, nongno isa kili wou, pe mahapo nakusok wou: koyum ara andre kisikirani yo ndre pwi?> >> ");
INSERT INTO nss_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Pwen hu ndramat mepo Yakop ipwandrisa hu ara, humui huya kili yiy pe hupa, <<Yowu ya kili nalim Esau, pe yiy mahapo ara itapo isa para kisa pohonani wou, iyasura hu ndramat mahaangat (400).>> ");
INSERT INTO nss_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Pe Yakop ilolohonge soyon pe inoh. Pe irahihiri hu ndramiran ara iya malpat, iyasura hu kan para hanghang, pe hu kamel tehen aliy yi. ");
INSERT INTO nss_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yiy iro lohonge ipa, <<Kapa Esau kisa pe kitingundru hu hapat, pwen andre hu hapat, ara hu kawop.>> ");
INSERT INTO nss_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Pwen Yakop itohun pe ipa, <<O Ngindrai ta tumbu Apraham pe tomo Yisak, wou YAPAN mepo apwai sato apa, <Amui aya kolom pe yowem hu pe andre kumbusi hiyan satam;> ");
INSERT INTO nss_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","yo ndramat para poya mbulyam; kultuwayi ara hiyan pwi, hapeko hiyan tam pe koisirai tam isa kili yo ara pwokeyan iya. Koluw usingondriti ndran Yortan, ara urukai iyasura nes sih opu. Pakumui kusa ko, yo kunna malpat ara. ");
INSERT INTO nss_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Utohun tehe wou apwokarani yowu, paratesah, unoh ta nali Esau, matisan kipo pahun kisa kili yowu pe kitingundru yowu masih kiyasura hu pihin pe hu mbunah. ");
INSERT INTO nss_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wou alohongani tapaniu tam hiyan mepo anpwai pwen kinsa kili yo: <Pe ndrayem hu kamulan ara andre kasarayah soyon iya, tehe kalayeng ita poholeng.> >> ");
INSERT INTO nss_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Pwen Yakop imatin iya masan ndroulang; pwen ipirani hu melit atan para kaikiy kiya kili nalin Esau tehe yukyuk: ");
INSERT INTO nss_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ipirani hu meme pihin malungat (200) pe hu kamai malungui (20), pe hu sipsip pihin malungat (200) pe hu kamai malungui (20), ");
INSERT INTO nss_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","pe hu kamel pihin matingui (30) iyasura noru hu, pe hu mbulmwakau pihin mahaangui (40) pe hu kamai masongui (10), pe hu tongkiy pihin malungui (20) iyasura hu kamai masongui (10). ");
INSERT INTO nss_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Pwen irahihiri hu kan ara hayoi iro wule hape pe hayoi iro wule hape, pe ipwai iyatahu ndramiran para poya mbulyan para marahu korotahu. Pe ipwai iyatahu ipa, <<Akeyemu kili yo pe akaiki mwele hu kan ara hayoi-hayoi.>> ");
INSERT INTO nss_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Pe Yakop ipwandrandrahaniy iya kili ndramat para poya mbulyan iye mu ipa, <<Kapa nali Esau kipohonani wou pe kipa, <Wou ara ndramat para pwandrendres ta hiyeh? Pe wou nayaleheh? Yihu kan masih huyera mu ara ata hiyeh?>– ");
INSERT INTO nss_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","pwen, kapa kisike wou, apwai kiya kili yiy toro, apa, <Yihu kan masih kene ara ata pwandrendres tam Yakop. Yiy ita mulan, pe iyki hu satam tehe yukyuk.> >> ");
INSERT INTO nss_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Pe yiy ipwandrandrahani ndrainga hu ndramat hamou-hamou huro mu iyata hu hayoi-hayoi, ara toro: <<Kapa wawu kanna pohonani Esau, wawu masih ara andre kayapa nongan handra ko. ");
INSERT INTO nss_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Pe wawu andre kapwai kapa, <Ehe, ndramat para pwandrendres tam, Yakop, ara ita mulan.> >> Yakop ipa tehen toro, paratesah, iro lohonge pe ipa, <<Lohongai para yukyuk to nakimu, ara para kurambumbuni nali kaliy, pe kamulan kunime yiy, ara matisan koyun kisikirani yo.>> ");
INSERT INTO nss_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Pe yiy iyki yukyuk tan iro mu pe yiy ara iro matin ndrohonoku ngohongoh. ");
INSERT INTO nss_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Pwen ping ara ko, Yakop itine pe irakuhuyani nambuyun malmou iyasura pihin malmou para poya mbulya hilu pe norun hu kamai songui pe hamou pe husingondriti ndran Yappok. ");
INSERT INTO nss_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Iyaiki hu huya matne ndramwiying kanna haroh ihipwen, pe ipwai iyata hu ndramat para poya mbulyan pe hukuni melit tan masih iya haroh i. ");
INSERT INTO nss_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Hapeko yiy opu iyendron haroh, pe ndramat hamou isa pe iposisiwe iyasura yiy, ipoo lang ileu. ");
INSERT INTO nss_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ndramat ara iposisiwe iya pe inimei tehe yiy andre kinlahiy pwi, pwen pe iti ndruwi yipwoke Yakop pe imatihise. ");
INSERT INTO nss_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ndramat ara ipwai ipa, <<Atali yo pe nakuyau; lang kinileu ara.>> Hapeko Yakop ipa, <<Andre kuntali wou pwi kipoo atoholi yo.>> ");
INSERT INTO nss_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ndramat ara isok yiy ipa, <<Wou ngalam hiyeh?>> Pe ipa, <<Yo ngolo Yakop.>> ");
INSERT INTO nss_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Pwen pe ndramat ara ipa, <<Ngalam mamu ara Yakop, hapeko mahapo ara ngalam howen ara nakiya <Yisrayel>. Paratesah, wou anposisiwe iyasura ndramat pe Ngindrai yi, pe anpwoke pwen.>> ");
INSERT INTO nss_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Pwen Yakop ipa, <<Mahapo apohowe ngalam kisa kili yo.>> Hapeko yiy ipa, <<Paratapeh pe wou apa pahasani ngolo?>> Pwen iro mwonen ara ndramat ara itoholi yiy. ");
INSERT INTO nss_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakop ipa, <<Yo unime Ngindrai iya moro, hapeko kunmat pwi yoh.>> Pwen yiy ipohowe ngala kol ara <<Peniyel.>> ");
INSERT INTO nss_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Paramwandrai kiningas pe Yakop pakitali kol Peniyel, pwen irakoltip, paratesah, ndruwi pwoken ara iro matihise manau. ");
INSERT INTO nss_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yihu ndraye Yisrayel mahapo ara hu konohoyan sangi ndruwi yipwoke kan ara pwi. Paratesah, ndramat ara irayi Yakop iya sangi yipwoken. ");
INSERT INTO nss_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Pwen Yakop maran itandras pe inime Esau iyasura ndramiran hu mahaangat ara huropo husa. Pwen itaingani norun hu masih para hu kaya pe koro tine sura tina hu; ata Leyah ara huya kili yiy, ata Rahel ara yiy iya kili yiy, pe ata hilu pihin para poya mbulyan malmou ara huya kili hilu yi. ");
INSERT INTO nss_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Pe iyki hilu pihin para poya mbulyan pe noru hilu ara huro mu, pe Leyah pe norun hu ara huro ndrokolon; pe Rahel iyasura norun Yosep ara hilye ndruwa hu masih. ");
INSERT INTO nss_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Pe yiy iye mu iya pe itukuruhu pe payan iya pwan ara maporoandrtoyoh, ipoo iya pakeh mbulmara nalin. ");
INSERT INTO nss_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Hapeko Esau ingap iya pe indrohosi nalin Yakop, pe irahunghung iyatan. Pwen hilu malmou kene hilrang. ");
INSERT INTO nss_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Pwen Esau maran iya pe inime hu pihin pe hu mbunah; pe isok ipa, <<Hutora sura wou ara hiyeh hu ko yeh?>> Yakop ipa, <<Yapane, yihu iye ara noru hu, Ngindrai itoholi yo pe ihingini yo yaliy. Pe yo ara pwandrendres tam.>> ");
INSERT INTO nss_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Pwen hilu pihin para poya mbulyan hilsa iyasura noru hilu, pe hu masih hutukuruhu iro mbulmara Esau. ");
INSERT INTO nss_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Iyamulan Leyah pe norun hu husa pe hutukuruhu yi. Pwen Rahel pe norun Yosep ara tehen aliy yi, hilsa pe hilu tukuruhu. ");
INSERT INTO nss_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau isok ipa, <<Tehen tapeh uhis pe urapohonani hu ndramat yapolo hu kan huro mu? Ara ndroiyin tesah ndrokonan?>> Pwen Yakop ipa, <<Ara para kusopwi wou para ndriyam kimbuluhi yo.>> ");
INSERT INTO nss_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Hapeko Esau ipa, <<Nali, melto ara soyon iya; hiyan para awiri meltam masih hu kamui.>> ");
INSERT INTO nss_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Pwen Yakop ipa, <<Pwi, Nali, wou ndriyam kimbuluhi yo, pe hiyan para awiri yukyuk to iye. Yo unume mbulmaram ara tehe mbulmara Ngindrai, paratesah, anamili yo. ");
INSERT INTO nss_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngindrai ara imbusi hiyan sato pe ihingini yo melit masih. Pe yo upa hiyan para awiri yukyuk to masih mepo nakuikiy kisa kili wou.>> Yakop iro kekei ipoo Esau isomwiy. ");
INSERT INTO nss_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Pwen Esau ipa, <<Kiya, tukayau; pe yo andre kuyapolo wawu.>> ");
INSERT INTO nss_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Hapeko Yakop ipa, <<Wou apahasaniy tehe noruhu masih ara hu payamulai o. Pe ulohongani hu sipsip iyasura hu kan masih pe noruhu mepo hutora yin sus manau, ara matisan hu karikai nomun nondriya lang sih sesek pe hu masih kamat. ");
INSERT INTO nss_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yapane, wou aye mu kili talu pe yo andre kuro tokai nokule-nokule kuyendruwam, kiyasura hu kan masih pe noruhu, kipoo kusarayah kusa kili wou kusa Etom.>> ");
INSERT INTO nss_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Pe Esau ipa, <<Kiya, kapa tehen tora pwen hu ndramiro hayah hu koro ndron sura wou.>> Hapeko Yakop ipa, <<Paratesah apambusiy tehen tora? Konan. Yapane, hiyan para ndriyam imbuluhi yo.>> ");
INSERT INTO nss_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Pe iro mwonen lang ara, Esau irikai iyemu ipoo iyarayah iya Etom. ");
INSERT INTO nss_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Hapeko Yakop iya Sukkot pe ipun suwen iyapolo youpeye hu kan tan masih. Tehen tora ko ngala kol ara irayah Sukkot. ");
INSERT INTO nss_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Pwen tehen tora ko, Yakop kintali kol Pattan Aram, pe iyarayah iya kol namandran Kenaan. Pe iya yih kalsuwan iro pakehekeh ngilse kol Sekem ita nondriya kol namandran Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yiy isowani pwan hambut ara iro kili Hamor tama Sekem, iya sombule pat silwa masangat (100). ");
INSERT INTO nss_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Pwen isoye pere tuntun para yukyuk iro ara, pe ipohowe ngala pere tuntun ara <<El Elohe Yisrayel.>> Ipa toro: <<Ngindrai para Yisrayel.>> ");
INSERT INTO nss_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Pwen lang sih aro, noru Yakop hilu Leyah pihin, ngalan Tainah ara, iya saisai iyapolo hu pihi Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamor ara pohon tahu Hipi, pe norun kamai hamou ngalan Sekem, ara inime Tainah, pe iya luwi yiy pe imbusi kultuw mwomwan iyatan. ");
INSERT INTO nss_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pwen Sekem inime Tainah ara pihin lahayan iya pe inamili yiy. Pe iro hinonou para kiwiri lohonga Tainah para kimbuluhi yiy. ");
INSERT INTO nss_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Pwen ipwai iya kili taman ipa, <<Yo unamiliy para awiri pihin aro kiya nambuyu.>> ");
INSERT INTO nss_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Pe Yakop ihilingiy tehe Sekem imbusi kultuw mwomwan iyata norun pihin, hapeko norun hu kamai masih ara huro ndron ndrohonoku mbulen, iyasura hu kan para hanghang tahu. Pwen Yakop ara kinpo hapesah pwi ipoo norun hu masih husarayah. ");
INSERT INTO nss_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Pwen Hamor, tama Sekem, iya pe iwong iyasura Yakop. ");
INSERT INTO nss_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Hilu ro wong ndron, pe noru Yakop hu kamai husarayah. Hu ara kanhilong pwen tehe Sekem imbusi kultuw mwomwan iyata pisuhu. Pwen pe husa nun o huro, pe ndrinahu ara ilokuh pe hundrangis, paratesah, kultuw ara iya lohonga hu Yisrayel, ara nonombun masih. ");
INSERT INTO nss_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor ipwai iyatahu toro, <<Noru ara inamili norum pihin, pwen usok lohonga wawu; hiyan para hilu kayesou ndre pwi? ");
INSERT INTO nss_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Worou tukapa hiyan kiya handra lohongai, pe noru tou hu pihin ara hu kayesou kaya kasa. ");
INSERT INTO nss_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pwen andre wawu korosura yowu pe akambusi sehe melit kiro pwan iye ara kiya lohonga wawu ko. Pe akamangse ndroho peheya wawu, pe andre kiya mbukenan wawu.>> ");
INSERT INTO nss_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Pwen Sekem ipwai iya kili tama Tainah pe wayin hu ipa, <<Kapa wawu kasomwi soksok to iye, pwen andre kuiki sehe melit mepo wawu namiliy. ");
INSERT INTO nss_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kapa wawu kaya hiyan sato para kuwiri Tainah; pwen akapwai kisato sehe melit wawu namiliy. Wawu kapohowe kenne Tainah kiya masahayeh kiya lohonga wawu, hapeko andre kuiki sehe melit wawu kasok kiya aliy. Hapeko akaiki pihin ara ko kisato tehe nambuyu.>> ");
INSERT INTO nss_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sekem ara kinmbusi kultuw mwomwan kinnata pisuhu pwen, pe yihu noru Yakop kamai ara hupwandrandraman para hu kapwasike Sekem pe taman Hamor. ");
INSERT INTO nss_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Pwen hupwai iyatan hupa, <<Kinlahiy para yowu kaiki pisu yowu kiyesou kiya kili hu ndramat mepo hu kansodriti kapilohu pwi, ara pwi yoh. Andre kiyki masirai kisa mwalinga yowu. ");
INSERT INTO nss_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Yowu andre kapa hiyan kiya soksok tam, kapa wawu kasomwi yowu kiya lohongai handra iye: hu kamai tawawu masih, ara andre kasodriti kipilohu pe hu karayah tehe yowu. ");
INSERT INTO nss_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tehen tora ko, andre yowu kapa hiyan para noru tou hu pihin andre kayesou kaya kasa. Pe yowu andre kampwan sura wawu pe tukasarayah hapat o. ");
INSERT INTO nss_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Hapeko kapa wawu kansomwi lohongai para sosondrih iye pwi, pwen ara andre yowu kawiri pisu yowu pe yowu kayau.>> ");
INSERT INTO nss_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Pe Hamor, iyapolo norun Sekem, ara hilpa hiyan iya lohongai ara. ");
INSERT INTO nss_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Pwen Sekem ara kinlonge ndrangan niwen pwi, paratesah, inamili noru Yakop pihin ara namandran iya. Yiy ara ndramat hamou ngara hu kasikiye yiy nondriya wum tan. ");
INSERT INTO nss_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor pe norun Sekem hilya ndrohonoku mbultere pakeh kili pohomara karam para kol ngawan ara, pe hilu wong iya kili hu kamai masih para kolohu. ");
INSERT INTO nss_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Pe hilu pa, <<Yihu ndramat ara yihu hiyan iya; hiyan para hu keyempwan sura tou pe hu kambusi melit kiya lohongahu ko. Pwanerou ara namandran pe ilahi hu yi. Andre tukayesou kaya kasa. ");
INSERT INTO nss_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Hapeko hu ndramat ara hupwes iya lohongai sahin o para hu korosura tou. Tehen tora ko, andre tukasondriti kapilo sangi hu kamai torou masih tehe yihu kansondriti kapilohu pwen. ");
INSERT INTO nss_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Pwen andre hu sipsip pe hu mbulmwakau tahu masih andre kasa torou. Kapa tukasomwi nongna hu, pwen andre hu koro sura tou.>> ");
INSERT INTO nss_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yihu ndramat masih para kol ngawan ara, hupa hiyan iya sehe nongan Hamor hilu norun Sekem hilwong iya aliy. Pwen yihu masih huro nondriya kol namandran ara, ara hu sondriti kapilohu topwei. ");
INSERT INTO nss_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Iro mwonen nondriya lang maroyoh, pe hu ndramat, neken tahu ara iro lek ndron, pwen wayi Tainah malmou kamai, Simeyon hilu Lepi, hilu wiri semela pahun niwen pe hilya nondriya kol namandran ara. Pe mwoiwahu masih ara ihin, pe hamou ndramat kinlahiy para kinmbultuwe hilu pwi. Pwen hilu tingundru hu kamai masih para kol namandran ara, ");
INSERT INTO nss_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","iyasura Hamor pe norun Sekem iya semela pahun niwen. Pwen hilu wiri Tainah iro wum ta Sekem pe huyau. ");
INSERT INTO nss_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Pwen iyamulan para hu kamai masih kanmat topwei, noru Yakop hu kamai masih, huya nondriya kol ara para kaya pahana melit iya konoha kultuw mwomwan humbusi iyata pisuhu. ");
INSERT INTO nss_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Hu wiri hu meme, hu sipsip, hu mbulmwakau pe hu tongkiy iyasura melit masih iro nondriya kol ngawan ara, iyapolo hu melit masih iro ngawan i. ");
INSERT INTO nss_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Huya pe hulokuhuyani topwe melit masih mepo kennehu namandran pe lahayan, iyapolo hu pihin pe hu mbunah pe melit masih iro nondriya hu seu. ");
INSERT INTO nss_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakop ipwai iyata Simeyon hilu Lepi ipa, <<Walu kaniyki nopwaran kinsa kili yo ara. Mahapo yihu para Kenaan, pe hu Peris, iyasura hu masih hutopo kol iye ara andre hu karasisingat ano. Yo ara ndramiro soyon pwi, pe kapa hu masih kaya wule pe hu kasa popahun kasa kili yo, andre hu katingundru yowu masih.>> ");
INSERT INTO nss_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Hapeko hilu pwai hilpa, <<Tehen tapeh; hiyan para hu koro raminmini pisu yowu tehe hamou pihin para sai, ndre?>> ");
INSERT INTO nss_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Pwen Ngindrai ipwai iya kili Yakop toro: <<Atine pe aya kol Petel pe ampwan aliy, pe asoye pere tuntun sih ato kiro aliy. Yo ara Ngindrai mamu urosura wou tandrohonga awop ta nalim Esau.>> ");
INSERT INTO nss_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Pwen Yakop ipwai iya kili norun hu pe hu ndramat huro sura yiy ipa, <<Wawu kapiyani hu paira wawu masih kene ita kili wawu kayau, pe akasuluye wawu kiya koyau howen pe koro ndruwa kultuw hiyan. ");
INSERT INTO nss_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kiya, wawu kasa, pe tukatali kol iye pe tukaya kol Petel. Pwen andre kusoye pere tuntun sih kiya kili Ngindrai. Tehe Ngindrai kinsopwat yo kinna nopwaran kinsarayah kili yo. Pe iro sura yo iya hape aleheh uya aliy.>> ");
INSERT INTO nss_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Pwen huiki pairahu masih iya kili Yakop, iyapolo kowa kahandraingahu pe ironi hu iya pahandra kei hakou nonombun ngalan hok, ita pakeh kol Sekem. ");
INSERT INTO nss_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pwen Yakop iyapolo yowen hu huro tokai nakayau. Pe Ngindrai imbusi nohowai namandran isarayah isa kili hu ndramat masih para kol mendreheh pakeh kili kol Sekem. Pwen pe yihu ara kanngaplani yowe Yakop hu pwi. ");
INSERT INTO nss_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Pwen Yakop iyapolo yowen hu ara huyarayah huya kol Lus, ara ita nondriya kol namandran Kenaan. Kol Petel, ara mamu hupohowe ngalan Lus. ");
INSERT INTO nss_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Pwen Yakop isoye pere tuntun sih pe ipohowe ngala kol ara, <<Ngindrai para Petel,>> paratesah, Ngindrai isarayah isa kili yiy mamu iro kol ara tandrohonga iwop ta nalin. ");
INSERT INTO nss_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Pwen iyamulan hape, Teporah, pihin para poya mbulya Repekah, imat iro hape ariya. Pe huroni yiy iro pahandra kei namandran hakou ngalan hok iyapwen te kup para kol Petel. Ndroiyin ara ko pe hupohowe ngala kei ara, <<Kei para ndriyang.>> ");
INSERT INTO nss_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tandrohonga Yakop kintali Pattan Aram pe kinmui kinsa Kenaan, pe Ngindrai isarayah isa kili yiy porosih i pe itoholi yiy tehe mamu. ");
INSERT INTO nss_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Pwen Ngindrai ipwai iya kili yiy ipa, <<Ngalam mamu ara Yakop, hapeko mahapo kunrapaiwani ngalam kinna Yisrayel pe andre kanpohowe ngalam Yakop pwi.>> Tehen tora ko Ngindrai ipohowe ngalan ara Yisrayel. ");
INSERT INTO nss_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Pe Ngindrai ipwai ipa, <<Yo ara Ngindrai Pwokeyan Iya. Pe wou andre aiki ndrayem hu kasarayah soyon pe ndromweyahu, ara andre kiya soyo-soyon iya. Pe andre hu kahon kaya mara kol hakol-hakol, pe tumbum hu andre hu karayah king pe pohon para kol. ");
INSERT INTO nss_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Pe pwan koluw mepo kuniykiy kinna kili Apraham hilu Yisak; mahapo andre kuikiy satam, kiyasura ndrayem hu kamulan i.>> ");
INSERT INTO nss_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pwen Ngindrai iwong iya kili Yakop iro kol ara ihipwen, pe itali yiy pe imui iya paingan. ");
INSERT INTO nss_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Pwen Yakop isondritiyani pat sih niwen pe itilingi ndrunu wain pe ndraikei para holip iya ndritan tehe yukyuk. ");
INSERT INTO nss_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ngindrai iwong iya kili Yakop iro kol ara, pwen pe Yakop ipohowe ngala kol ara Petel. ");
INSERT INTO nss_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Pwen Yakop iyapolo yowen hu ara hutali Petel pe huyau huya kol Eprat. Huro tokai ndron pe Rahel ihingotou iyata mbunah para nakimwalahiy kiyatan, pe ihingoruwe ngandran ara namandran iya. ");
INSERT INTO nss_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Pe tandrohonga irohingorowe ngandran, pe pihi yondrop tan ipwai iya kili yiy ipa, <<Mbuna anoh; norum iye ara kamai yi.>> ");
INSERT INTO nss_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pwen Rahel pakeh nakimat pe ngohan hape irondron pe ipohowe ngala mbunah ara, ara Penoni. Hapeko iyamulan taman ipohowe ngalan ara Penyamin. ");
INSERT INTO nss_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Pwen Rahel imat pe huroni yiy iro pakeh sai iyapwen te Eprat; (ngalan handra yi, ara Petlehem). ");
INSERT INTO nss_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tandrohongan ara Yakop isondritiyani pat sih iro ariya; pat ara irakinima ngare Rahel. Pe ita ipoo isa matnen mahapo. ");
INSERT INTO nss_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Pwen hurukai huya ngilse seu niwen para Eter, pe huya ngoh hape pe hupwili yumwahu iro aliy. ");
INSERT INTO nss_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Pwen Yisrayel irondron ara, pe Rupen imatin iyapolo Pilhah, paiwa nambuyu taman hamou. Pwen pe taman Yisrayel ara ihilingi kultuw mwomwan Rupen imbusiy. Pe Yakop ara norun hu kamai songui pe lumou. ");
INSERT INTO nss_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Iye ara ngala noru Leyah hu: Rupen ara ndrihou ta Yakop; pe mundruwan hu ara Simeyon, Lepi, Yutah, Issakar, pe Sepulun. ");
INSERT INTO nss_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Pe Rahel ara norun malmou kamai, ngala hilu ara Yosep pe Penyamin. ");
INSERT INTO nss_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Pilhah, pihin para poya mbulya Rahel, ara norun malmou, ngala hilu ara Tan pe Naptali. ");
INSERT INTO nss_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Pe Silpah, pihin para poya mbulya Leyah, ara norun malmou, ngala hilu ara Kat pe Aser. Yakop ara iro Pattan Aram pe iyki hu mbunah songui pe lumou. ");
INSERT INTO nss_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Pwen Yakop imui isa kili taman Yisak iro kol Mamre. Mamre ara kolo Apraham pe Yisak hilyen aliy mamu, pe ita pakeh kol Kiriyat Arpa. Hepron, ara koluw hupohowe ngalan ara Kiriyat Arpa. ");
INSERT INTO nss_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Pwen hayou ta Yisak ara iro sangat pe androlngui (180). ");
INSERT INTO nss_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Pe iya parangoloh masih pe imat. Pe norun hilu malmou, Esau hilu Yakop, ara hiltoni yiy. ");
INSERT INTO nss_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Pe iye ara titiye ta Esau. Pe ngalan handra ara hupohowei Etom. ");
INSERT INTO nss_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ara iyesou iya Kenaan, pe iwiri pihin hamou ngalan Atah SuElon. Elon ara yiy hamou ndramira Hit. Pwen iyesou paiwe pe iwiri Oholipamah SuAnah, pe Anah ara noru Sipeyon, yiy ara hamou ndramira Hipi. ");
INSERT INTO nss_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Pwen iyesou paiwe yi, pe iwiri Pasemat SuYismayel, pe wayin hamou ara ngalan Nepayot. ");
INSERT INTO nss_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Pe Atah ara imwalahiy iyata noru Esau kamai hamou ngalan Elipas. Pe Pasemat ara imwalahiy iyata norun hamou kamai ngalan Ruwel. ");
INSERT INTO nss_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Pe Oholipamah ara imwalahiy iyata norun hu kamai iye kene: Yewus, Yalam, pe Korah. Yihu ara noru Esau kamai, husarayah huro kol Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Pwen Esau itine pe iwiri nambuyun hu, norun hu kamai pe pihin pe hu ndramat masih huro sura yiy, pe iyasura hu kan tan masih pe iyapolo memelit masih kene mepo iro nimnim iyatahu iro pwan Kenaan, ara irakuhuyani hu masih pe huyau huya pwan hambut mwanan hape kili nalin Yakop. ");
INSERT INTO nss_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau iya mawen kili nalin Yakop, paratesah, menmena hilu iyasura hu kan ta hilu ara soyon iya. Pe pwan hape ara, ara kinlahi hilu pwi. ");
INSERT INTO nss_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Pwen Esau (ngalan handra ara Etom) iyau iya pe iyempwan kol hakol ngondron ita pahayi para Seyir. ");
INSERT INTO nss_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Pe iye ara titiye ta Esau, tama hu Etom masih ita kol ngondron para pahayi Seyir. ");
INSERT INTO nss_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Pe iye ara ndraye noru Esau hilu kamai malmou, ngala hilu ara Elipas noru Atah pe Ruwel noru Pasemat. ");
INSERT INTO nss_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Pe Elipas, ara norun hu kamai mayimou ngalahu ara iye: Teman, Omar, Sepo, Katam, pe Kenas. ");
INSERT INTO nss_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Pe Timna ara pihin hamou iya paiwa Elipas. Pe Timna ara imwalahiy iyata Amalek. Yihu ara tumbu Esau husarayah iro kili Atah. ");
INSERT INTO nss_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Pe noru Ruwel hu kamai mahaamou ngalahu ara iye: Nahat, Serah, Samah, pe Missah. Yihu ara husarayah iro kili Pasemat, nambuyu Esau. ");
INSERT INTO nss_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholipamah ara nambuyu Esau hamou i, pe norun hu ara matimou, ngalahu ara iye kene: Yewus, Yalam, pe Korah. Oholipamah ara noru Anah, pe Anah ara noru Sipeyon. ");
INSERT INTO nss_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Pe iye ara ngala ndraye noru Esau hu, mepo husarayah pohon tahu. Pe hu noru Elipas, mepo ndrihou ta Esau, ara husarayah pohon para paiyumwa wum hawum-hawum tahu; ngalahu ara iye: Teman, Omar, Sepo, Kenas, ");
INSERT INTO nss_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Katam pe Amalek. Yihu masih husarayah pohon, pe hu masih ara ndraye Elipas opu, hunimnim iya kol namandran Etom. Pe yihu ara mangmbu Atah, nambuyu Esau. ");
INSERT INTO nss_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Pe noru Ruwel hu, ngalahu ara iye: Nahat, Serah, Sammah, pe Missah. Yihu sarayah pohon para payumwa wum hawum-hawum pe hunimnim iya kili yowehu tora Etom. Yihu ara mangmbu Pasemat nambuyu Esau. ");
INSERT INTO nss_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Pe hu noru Oholipamah SuAnah, nambuyu Esau hamou i, ngalahu ara iye kene: Yewus, Yalam, pe Korah. Yihu ara husarayah pohon para payumwa wum tahu hawum-hawum. ");
INSERT INTO nss_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Pe yihu ndramat masih ara, ara hu ndraye noru Esau (ngalan handra Etom). Yihu ara husarayah pohon para payumwa wum hawum-hawum tahu. ");
INSERT INTO nss_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Pe iye ara ndromweya ngala hu mbunah kamai noru Seyir. Yihu noru Seyir ara husarayah pohon para payumwa wum tahu Hor ita kol Etom. Pe ngalahu ara iye kene: Lotan, Sopal, Sipeyon, Anah, ");
INSERT INTO nss_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Tison, Eser, pe Tisan. Yihu ara hu noru Seyir kamai, pe husarayah pohon para payumwa wum tahu Hor ita nondriya kol namandran Etom. ");
INSERT INTO nss_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Pe noru Lotan hilu malmou kamai, ngala hilu ara iye: Hori pe Hemam. Pe pisu Lotan hamou ara ngalan Timna. ");
INSERT INTO nss_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Pe noru Sopal hu kamai, ngalahu ara iye: Alpan, Manahat, Epal, Sepo, pe Onam. ");
INSERT INTO nss_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Pe noru Sipeyon hilu malmou kamai, ngala hilu ara iye: Aiyah pe Anah. Anah ara ngara kiro nimnim kiyatahu tongkiy ta taman Sipeyon, pe ngara kiro kol ndrohoyin. Pwen inime hu ndran ndrikou hayah ara ndran ngandrahan iro aliy. ");
INSERT INTO nss_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Pe noru Anah hilu malmou, ngala hilu ara iye: Tison pe Oholipamah. Oholipamah, ara noru Anah pihin. ");
INSERT INTO nss_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Pe noru Tison hu kamai, ngalahu ara iye: Hemtan, Espan, Yitran pe Keran. ");
INSERT INTO nss_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Pe noru Eser hu kamai, ngalahu ara iye: Pilhan, Saapan, pe Akan. ");
INSERT INTO nss_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Pe noru Tisan hilu kamai, ngala hilu ara iye: Us pe Aran. ");
INSERT INTO nss_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Pe hu ndramat mepo hurayah pohon para payumwa wum tahu Hor, ita nondriya kol namandran Etom, ngalahu ara iye kene: Lotan, Sopal, Sipeyon, Anah, ");
INSERT INTO nss_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Tison, Eser, pe Tisan. ");
INSERT INTO nss_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tandrohongan ara, hamou kintayah king tahu Yisrayel mapu, pe yihu ndramat iye ara husarayah king para kol namandran Etom. ");
INSERT INTO nss_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Pela NdraPeyor; yiy ara isarayah king tahu Etom. Pe hupohowe ngala kolon ara Tinhapah. ");
INSERT INTO nss_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pwen Pela imat pe Yopap NdraSera para kol Posrah ara iwiri nokun tehe king. ");
INSERT INTO nss_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pwen Yopap imat pe Husam para kol Teman ara iwiri nokun tehe king. ");
INSERT INTO nss_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pe Husam imat pe Hatat NdraPetat isarayah king. Hatat ara iya kol Mowap para kiya popahun kiyasura hu para Mitiyan, pe irahu topwei. Pe kolon ara Apit. ");
INSERT INTO nss_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pwen Hatat ara imat pe Samlah para kol Masrekah isarayah king. ");
INSERT INTO nss_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pwen Samlah imat pe Sol para kol Rehopot, ngilse ndran Yupretis, ara isarayah king. ");
INSERT INTO nss_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Pwen Sol imat pe Paal-hanan NdraAkpor isarayah king. ");
INSERT INTO nss_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pwen Paal-hanan NdraAkpor ara imat pe Hatar iwiri nokun pe isarayah tehe king iro kolon Pau. Pe nambuyu Hatar ara ngalan Mehetapel, yiy ara noru Materet pihin nondriya Mesahap. ");
INSERT INTO nss_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Pe hu ndramat iye kene ara husarayah pohon para payumwa wum hawum-hawum ta Esau: Timna, Alpah, Yetet, ");
INSERT INTO nss_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholipamah, Elah, Pinon, ");
INSERT INTO nss_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mipsar, ");
INSERT INTO nss_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Maktiyel, pe Iram. Yihu sarayah pohon para kol Etom. Pe Esau ara tumbuhu Etom masih. Pe aro ara ndraye Etom hu masih husarayah pohon para payumwa wum hawum-hamwum pe kolohu hakol-hakol. ");
INSERT INTO nss_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakop ara iro pwan Kenaan, kolo taman Yisak mepo koluw impwan aliy. ");
INSERT INTO nss_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iye ara titiye ta Yakop pe norun hu. Yosep ara manoru wihou o, pe hayou tan ara iro songui pe andrtoyoh. Yiy iro nimnim iyata hu sipsip pe meme iyasura nalin hu, yihu noru Pilhah hilu Silpah, hilu pihin malmou ta taman. Pe Yosep ara ngara kiya nese ndrainga taman kiya kultuw mwomwan ata nalin hu. ");
INSERT INTO nss_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakop, ngalan handra Yisrayel, yiy ngara ndriyan kimbuluhi Yosep namandran iya, iyata norun hu masih; paratesah, tandrohonga tinan imwalahiy iyatan ara Yisrayel kinna parangoloh pwen. Pwen pe isoruwe koyau hamou lahayan iya, iro matne koyun, iya niman, pe iya hapwen iya ndrikan; pe inowi norun Yosep iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nalin hu hunimei tehe tamahu ara ndriyan imbuluhi Yosep pwokeyan iya, iyata hu masih. Pwen pe ndrinahu ara ilokuh namandran iyatan, pe yihu konohowong hiyan kinna tan pwi. ");
INSERT INTO nss_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lang sih Yosep inihinih pe yiy itiyaniy iyata nalin hu, pe ndrinahu ara ilokuh namandran iya, iyatan. ");
INSERT INTO nss_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosep ipwai iyatahu ipa, <<Wawu kahilingi nihinih to namu. ");
INSERT INTO nss_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Worou masih tora piyang hambut, tu tora was wit. Pwen wit to hapus ara itatine imwonen pe atawawu ara irahakowa wit to pe pelehu iwayiu isa kili wit to.>> ");
INSERT INTO nss_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Pe nalin hu ara huhilingi yiy, pe hupwai iyata Yosep hupa, <<Wou ata lohonganiy para narayah king, pe animnim kisa towu pe yowu kaya pwandrendres tam, ndreh?>> Pwen ndrinahu ara ilokuh iyatan, paratesah, iwong iyatahu iya nihinih tan ara. ");
INSERT INTO nss_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Pwen iyamulan Yosep inihinih paiwe pe yiy itiyaniy iyata nalin hu ipa, <<Yo unihinih pe unime paramwandrai, walah, pe hu piriy songui pe sih, ara hutukuruhu isa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yosep itiyani nihinih tan iya kili taman pe nalin hu. Pwen pe taman ipwayi yiy ipa, <<Ara sehe nihinih ndrokonan? Apa ndre yo, pe tinam, pe nalim hu masih katukuruhu kisa kili wou, ndreh?>> ");
INSERT INTO nss_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Pwen nalin hu, ara hundrangis iyatan. Hapeko taman ara ilohongani hu nihinih tan iro manau payan. ");
INSERT INTO nss_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Porosih aro, nali Yosep hu huya kol Sekem para kaya hang hu sipsip ta tamahu. ");
INSERT INTO nss_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Pe Yisrayel ipwai iyata Yosep ipa, <<Nalim hu kanna hang hu sipsip kanna sahin iyapwen te kol Sekem. Kiya, nakupwandrisa wou para aya nime hu.>> Pe Yosep ipa, <<Hiyan, Tomo; andre kuya.>> ");
INSERT INTO nss_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Pe taman ipwai iyatan ipa, <<Wou aya nime nalim hu, pe hu sipsip torou; ara hu tora hiyan ndre pwi? Wou aya nime hu, pe amui asa nese ndraingo.>> Pwen Yisrayel ipwandrisa Yosep, pe itali Pwenten Hepron pe iyerokai ipoo iyarayah iya kol Sekem. ");
INSERT INTO nss_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Pe yiy iho makaiye sahin ara, pe ndramat hamou inime yiy pe isike yiy ipa, <<Wou ata ten tesah ndrokonan?>> ");
INSERT INTO nss_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Pe Yosep isomwi yiy ipa, <<Yo uropo ten nali hu. Ilahi para apwai kisato hape aleheh ndrokonan hu tora hang hu sipsip tahu yaliy?>> ");
INSERT INTO nss_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Pe ndramat ara ipwai iyatan ipa, <<Yihu kantali kol aripo. Uhilingi huro wong hupa, <Tukaya kol Totan.> >> Pwen Yosep iho ndruwa nalin hu pe iya nime hu huro kol Totan. ");
INSERT INTO nss_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yiy iho ndron mwanan pe nalin hu, ara hunime yiy iropo isa. Pwen pe nalin hu, humburi lohongahu para karayi yiy kimat. ");
INSERT INTO nss_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Pwen yihu ro wong mwalinga hu ko, hupa, <<Kanimei, ndramat para nihinih kinsa. ");
INSERT INTO nss_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kiya tukarayi yiy kimat, pe tukapiyani yiy kiya ngat sih ita. Kamulan tukapa kan hamou mwomwan kinitingundrun pe kinyani yiy. Pe worou kanime tesah andre kirayah kiya nihinih tan.>> ");
INSERT INTO nss_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rupen ihilingi nongnahu pe koyun isikirani Yosep pe pakisopwat yiy. Pwen pe ipwai ipa, <<Worou mbuna karayi yiy kimat. Konan, kimwa. ");
INSERT INTO nss_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Worou mbuna katingundrun. Hapeko tukapiyani yiy kiya ngat sih aro ita kol ndrohoyin. Hapeko mbuna tukambusi mwomwan kiyatan.>> Rupen ilolohonge para kiwiri Yosep kimui kiya kili taman. ");
INSERT INTO nss_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Pwen pe Yosep iyarayah iya kili nalin hu, pe nalin hu ara humbultuwe yiy pe yihu tali koiwen iyau–koiwen mwayih mepo taman isuluye yiy iya aliy ara. ");
INSERT INTO nss_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Pwen yihu wiri yiy pe huya piyani yiy iya ngat sih, mepo ndran kinho aliy pwi. ");
INSERT INTO nss_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Pwen yihu pakampwan para hu nakanamnam pe yihu nime hu ndraye Yismayel huropo husa, iyasura hu kamel tahu. Yihu ndramat ara huyau sahin para kol namandran hape Kileyat, pe huropo nakaya kol namandran masih Yisip. Hu nakaya Yisip para hu kaya sou kennahu tiken tehe muluw, koiyo, pe ndraikei mangonohon layin. ");
INSERT INTO nss_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Pe Yutah ipwai iya kili nalin hu ipa, <<Kapa worou karayi nalirou kimat pe tukakulani mwomwan torou, pwen andre tukawiri tesah hiyan ndrokonan kiyau aliy? ");
INSERT INTO nss_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kiya, worou kaiki yiy kiya kili hu Yismayel pe yihu kasowani yiy, pe kirayah tehe ndramat hamou para pwandrendres tahu. Pe worou mbuna kambusi mwomwan kiyatan, paratesah, yiy ara nalirou ndrokonan pe ndreyerou.>> Pwen pe nalin hu, ara hupa hiyan iya nongan tehe ipwai. ");
INSERT INTO nss_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pwen nalin hu huro wong ndron, pe yihu ndraye Yismayel para kol Mitiyan husarayah. Pwen pe nalin hu huluwi yiy iro ngat isa paingan, pe huiki yiy iya kili hu Yismayel. Yihu Yismayel husowani yiy iro kili nalin hu iya sombule pat silwa malungui (20), pe yihu wiri Yosep huyau huya Yisip. ");
INSERT INTO nss_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Pwen Rupen imui isa ngat ndrikou ara, hapeko kinnime Yosep kinto aliy pwi. Pwen pe koyun isikirani nalin pe niman iya koiwen pe indrohomwiriy. ");
INSERT INTO nss_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Pe imui iya kili nalin hu pe ipa, <<Yosep kinto ngat ndrikou pwi yoh! Mahapo andre kumbusi tapeh ndrokonan?>> ");
INSERT INTO nss_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Pwen hutingundru meme hamou, pe huwiri koyau niwen pe lahayan ata Yosep ara, pe hutumwiy iya ndreyen. ");
INSERT INTO nss_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pwen yihu wiri koyau mepo ndrai iro aliy ara imui iya kili tamahu pe hupa, <<Yowu noni koyau hamou iye, pe animei na; ata norum ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yiy ituluwaniy pe ipa, <<Ara koyau ata noru kamai! Andre hamou puyap kintingundrun pe kintamumuruwe yiy!>> ");
INSERT INTO nss_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Pwen Yakop indrohomwiri koyau tan pe isuluye yiy iya koyau para koisirai. Pe lang sih tehe sih koyun ngara kitti norun. ");
INSERT INTO nss_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Pwen hu norun kamai pe pihin husa kili yiy para karambunmbuni tamahu. Hapeko yiy mbuwalin masih pe ipa, <<Pwi yoh! Koisirai to ara andre kiro kipoo kumat kasura noru.>> Pwen taman irangsi yiy. ");
INSERT INTO nss_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yihu Mitiyan ara huwiri Yosep huya Yisip pe Potipar isowani yiy iro kili hu. Pe Potipar ara namandran tahu makundrayin mepo ngara hu koro nimnim kiya nondriya seu namandran ta King tahu Yisip. ");
INSERT INTO nss_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Porosih aro Yutah itali nalin hu pe iyau iya iye sura Hirah, ndramat hamou para kol Atullam. ");
INSERT INTO nss_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Pwen Yutah ara inime pihi Kenaan hamou pe iwiri yiy iya nambuyun pe iro sura yiy. Pihin ara, ara noru ndramat hamou ngalan Suwa, yiy ndramira Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Pe SuSuwa ara mapundriyan, pe imwalahiy iyata norun hamou kamai pe ipohowe ngalan ara Er. ");
INSERT INTO nss_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Pe imwalahiy iyata norun kamai hamou paiwe, pe ipohowe ngalan ara Onan. ");
INSERT INTO nss_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Pwen SuSuwa ara mapundriyan porosih i pe imwalahiy iyata norun kamai hamou, pe ipohowe ngalan ara Selah. Pe Yutah iro ndron kol Kesip pe nambuyun ara imwalahiy ta Selah. ");
INSERT INTO nss_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iyamulan Yutah iwiri pihin hamou ngalan Tamar iya nambuyu norun ndrihou ngalan Er. ");
INSERT INTO nss_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Hapeko Er, ara kultuwayin pwassin masih iya mbulmara YAPAN, pwen pe YAPAN irayi yiy pe imat. ");
INSERT INTO nss_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pwen pe Yutah ipwai iyata Onan ipa, <<Wou aya matin kiyasura nambuyu nalim, paratesah, pwayan ipwai tehen aliy. Pwen pe kipo hamou mbunah kiya soiwi nalim.>> ");
INSERT INTO nss_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Hapeko Onan ara welen imai para kipo mbunah mepo norun imwonen pwi. Pwen pe yiy imatin iyasura nambuyu nalin, hapeko ndran tan ara imuw o mwaihei iya pwan, paratesah, mbuwalin para kipo soiwi noru nalin. ");
INSERT INTO nss_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Pwen pe YAPAN inime kultuw mepo Onan imbusiy ara, ara mwomwan masih iya mbulmaran. Pwen pe YAPAN ara irayi yiy imat i. ");
INSERT INTO nss_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Pwen pe Yutah ipwai iyata mbuyu norun ipa, <<Wou anna pihinau, pe amui aya kili yowem hu, pe alonge noru Selah kimandra na.>> Yutah ipa toro, paratesah, inohowani norun Selah, matisan kimat i. Pwen pe Tamar ara imui iya iye suwe taman. ");
INSERT INTO nss_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Pe iya ndrangan niwen hape ihipwen, pe nambuyu Yutah, SuSuwa, ara imat. Pwen merei pe koisirai ta Yutah ihipwen, pwen Yutah iya kol Timnah para kiya nime hu ndramat huro sondrih yomu hu sipsip tan. Pe irikai iyapolo kowasen Hirah, ndramira Atullam. ");
INSERT INTO nss_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Pwen pe ndramat hamou inese ndrainga Tamar ipwai ipa, <<Tama nambuyum ara ita rokai nakiya Timnah para nakiya sondrih yomuhu sipsip tan.>> ");
INSERT INTO nss_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Pwen Tamar ara kinpahasaniy tehe Selah ara kinmandra kinna wihou, hapeko hu kanramwaniye para kisawiri yiy ara pwi. Pwen pe Tamar itali koiwe pihinau tan, pe indrutuhi mbulmaran iya koyau hasai, pe iya imi parasanga sai, iyapwen te Enayim. Enayim ara kol hakol ita sai iyapwen te Timnah. ");
INSERT INTO nss_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yutah iro tokai iropo iya, pe inime pihin ara, pe ipa ndre yiy pihin hamou para payangosai. Pe pihin ara indrutuhi mbulmaran iya koyau hasai mendreheh. ");
INSERT INTO nss_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Pe Yutah ara, tanan tehe yiy mbuyu ngundran, ara pwi yoh. Pwen pe Yutah iya kili yiy ngilse sai pe ipwai iyatan ipa, <<Asa na, nakumatin kuyasura wou.>> Pwen pe pihin ara ipa, <<Wou naiki tesah kiya ndraimo?>> ");
INSERT INTO nss_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Pwen Yutah ipa, <<Yo andre kuiki noru meme to hamou kiyau kowa meme to kisatam.>> Pe pihin ara ipa, <<Kiya, arandranga hapesah kisa kili yo tehe kinimam. Pe kapa wou asaiki noru meme kisa to tehe anpwai, pwen yo andre kuiki melit ara kimui kisa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yutah ipa, <<Yo po, andre kuiki tesah kisatam tehe kinimo?>> Pe pihin ara ipa, <<Aiki ndraimam kiyasura malkeyen kiyapolo nesem, ara kisa kili yo tehe kinimam mahapo.>> Pwen Yutah iyki melit matindra ara iya kili yiy pe imatin iyasura yiy. Pe iyamulan pihin ara mapundriyan. ");
INSERT INTO nss_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Pwen Yutah iya kili yiy ihipwen, pe pihin ara itine pe iyau, pe itali koyau hasai mepo iwasiy iya ndrutuha maran ara iya mawen. Pe isohongani koiwe pihinau tan imui. ");
INSERT INTO nss_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Pe Yutah irapiyani noru meme hamou iya nima Hirah para kiyaikiy pe kiwiri menmenan kimui. Hapeko Hirah ara kinnime pihin ara pwi. ");
INSERT INTO nss_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Pwen yiy isok hu ndramira Enayim ipa, <<Wawu nime pihine wum para totohun mepo ngara kimpwan ngilse sai ita Enayim, ndre pwi?>> Pwen husomwiy hupa, <<Hamou pihin tehen tora kinto aripo pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Pwen Hirah imui iya kili Yutah pe ipa, <<Yo ara kunnime yiy pwi. Pe usok hu ndramira Enayim pe hupa, <Hamou pihin tehen tora kinto aripo pwi.> >> ");
INSERT INTO nss_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Pe Yutah ipa, <<Hiyan, konan. Melto masih ara kiro ndron kili yiy. Matisan hu ndramat kahilingiy pe hu kapwasimiri youlu. Pe yo ara pakurapiyani noru meme aro kiya kili yiy, hapeko aya pe yiy kinto pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Pe iya walah maroyoh ihipwen, pwen hu ndramat hayah huya nese ndrainga Yutah hupa, <<Animei, mbuyungundram, Tamar, ara ipo pilah pe mapundriyan yoro.>> Pwen pe Yutah iyki nongan pwokeyan ipa, <<Akawiri yiy pe akatimwi yiy kiya mwan pe kimat.>> ");
INSERT INTO nss_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pwen lang ara yihu pakawiri yiy, pe yiy ipwanos iya kili tama nambuyun ipa, <<Yo mapundriyo ara iyata ndramat mepo melit tan iye kene. Anime nes, pe ndraiman iyapolo malkeyen iye. Melit matindra iye ara ata hiyeh ndrokonan?>> ");
INSERT INTO nss_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Pwen Yutah ara iyirowe melit matindra ara, pe ipahasaniy tehe ara hu meltan mbukenan. Pe ipa, <<Melit ara, ara ato kopu. Kultuwayin ara imwonen–pe ato ara mwomwan. Paratesah, yo kunsokomburani noru Selah, ara kinna tan pwi.>> Pwen yiy kinmatin kinna sura yiy paiwe pwi. ");
INSERT INTO nss_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Pwen irahihini lang para nakimwalahiy, huyirowei tehe norun ara mwan. ");
INSERT INTO nss_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Imwonen nakimwalahiy, nima norun hamou ara isa ngawan. Pwen pihiyondrop ara imbultuwe nima mbunah pe iwasi komu malikei laman iho ngondro niman. Pe yiy ipa, <<Mbunah iye imu.>> ");
INSERT INTO nss_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Hapeko iluwi niman imui, pe nalin isa pwan imu. Pwen pe pihiyondrop ipa, <<Aripo tapeh ndrokonan pe aramwaitini nalim pe asa pwan imu!>> Pwen ipohowe ngalan ara Peres. ");
INSERT INTO nss_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Pwen iyamulan, nalin mepo komu malikei laman iho ngondro niman ara isa pwan. Pwen pe hupohowe ngalan ara Serah. ");
INSERT INTO nss_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Pe yihu Yismayel para kol Mitiyan ara huwiri Yosep pe huluwi yiy iya kol namandran masih Yisip. Pwen Potipar isowani yiy iro kili hu para kirayah ndramat para poya mbulyan o mwaihei. Potipar ara makundrayin hamou ngara kiyamu tahu makundrayin masih mepo ngara hu koro nimnim kiya seu ta king. ");
INSERT INTO nss_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hapeko YAPAN ara irosura Yosep, pe melit masih Yosep iro mbusiy iya suwe Potipar, ara irayah hiyan o. ");
INSERT INTO nss_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Pe Potipar ara inimei tehe YAPAN irosura Yosep, pe melit masih iro mbusiy ara ngara kisarayah hiyan o. ");
INSERT INTO nss_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Pwen pe Potipar ara, welen iso iyata Yosep. Pwen pe yiy iyki Yosep iro mu iya pohombulen, para maran kiro suwen pe kiro meltan masih. ");
INSERT INTO nss_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Iro tandrohonga Yosep irayah pohon para wum ta Potipar pe iro nimnim iya meltan masih, pwen YAPAN itoholi Potipar, paratesah, Yosep irosura hu. Pe YAPAN itoholi melit masih para seu, piyang, pe menmena Potipar masih. ");
INSERT INTO nss_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Pwen tehen tora ko Potipar iyki melit tan masih kene iro pahandra pwokere ta Yosep para maran kiro aliy. Pe Potipar ara kinho lohongani melit masih iro nondriya seu pwi, paratesah, melit masih ita nima Yosep, pe Potipar ara ngara kilohongani anandrinan o. Yosep ara sangin lalahayan pe kaipisan ara mwayih iya. ");
INSERT INTO nss_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Pe iyamulan hape nambuyu Potipar maran ilimiri Yosep pe inamili yiy, pwen ipwai iyatan ipa, <<Asa matin kasura yo.>> ");
INSERT INTO nss_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Hapeko Yosep ipa pwi iya nongna nambuyu Potipar, pe ipa, <<Animei; yapane ara iyki melit masih para seu iye, ara iripo pahandra pwokere to ko. Pe yiy ara ngara kinho lohongani meltan masih ara pwi. ");
INSERT INTO nss_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Yo ko ara mangolo tehe yiy o, urupo seu iye. Pe yiy ipa hiyan sato para moro kiro melit masih kene iripo seu, hapeko wou opu, kinpa hiyan sato para kumatin kisa suram pwi. Tehen tapeh ndrokonan pe andre kumbusi kultuw ara? Ara kinna mwonen kinna mbulmara Ngindrai pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pe lang sih tehe sih pihin ara ngara kisike Yosep para kimatin kiyasura yiy. Pe ngara kipwahihiri yiy, hapeko Yosep ara kinho hilingi yiy pwi, pe kinmatin kinna sura yiy pwi. Pe kinohopo kinna pakeh kili yiy pwi masih. ");
INSERT INTO nss_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pwen lang sih Yosep iya nondriya seu para kiyapo mbulen, pe lang ara hamou ndramat para poya mbulen ara kinto seu pwi. ");
INSERT INTO nss_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Pwen pe nambuyu Potipar isa pe imbultuwe koyau ta Yosep, pe ipwai ipa, <<Asa matin kapolo yo.>> HapekoYosep iwop iya ngawan, pe itali ndrohan ara iro ndron nima nambuyu Potipar. ");
INSERT INTO nss_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Nambuyu Potipar inimei tehe Yosep ara itali ndrohan pe iwop iya ngawan. ");
INSERT INTO nss_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Pwen pe yiy iyoh iya kili hu ndramira mbulen para seu ipa, <<Akanime iye na! Ndramira Hipuruw mepo nambuyu iwiri yiy isa iripo seu ara imbusi mwomwan isa torou. Yiy isa kili yo nondriya seu pe ipa yo kumatin kiyasura yiy. Hapeko uwayeh pwokeyan iya. ");
INSERT INTO nss_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Pwen ihilingi uwayeh pe iwop iya ngawan pe iyki ndrohan o, ara iro ndron ndrahaso.>> ");
INSERT INTO nss_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Pwen nambuyu Potipar iwiri ndroha Yosep ara iro ndrahasan ipoo namandran tan isarayah isa seu. ");
INSERT INTO nss_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Pwen yiy itiyani titiye masih ipa, <<Ndramira Hipuruw para mbuliyam mepo awiri yiy isa pe iropo po mbulen, ara isong isa seu pe isike yo. ");
INSERT INTO nss_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Hapeko yo uwayeh pe yiy iwop iya ngawan, pe iyki ndrohan o, ara iro ndron ndrahaso.>> ");
INSERT INTO nss_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potipar ihilingi nongan masih mepo nambuyun itiyaniy iyatan, pwen pe ndrinan ara ilokuh. ");
INSERT INTO nss_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Pwen namandran ta Yosep ara iwasi yiy, pe iwiri yiy iya kou ta king mepo hu ndramat para tandroindroi huro aliy. ");
INSERT INTO nss_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Hapeko YAPAN ara irosura Yosep i, pe itoholi yiy. Pwen pe namandran tahu makundrayin para nondriya kou ta king, ara welen iso iyata Yosep. ");
INSERT INTO nss_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Pwen pe iyki Yosep ara iromu iyata hu ndramat para tandroindroi mepo huro nondriya kou, pe iro nimnim iya melit masih mepo ngara kirayah kiro nondriya kou. ");
INSERT INTO nss_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","YAPAN ara irosura Yosep pe isopwat yiy, pe melit masih Yosep iro mbusiy, ara irayah hiyan opu. Pwen pe namandran tahu makundrayin mepo ngara kiro nimnim kiya nondriya kou, ara kinoho lolohonge kiya hapesah pwi, paratesah, Yosep ngara kiro mbusi melit masih ara irayah hiyan o. ");
INSERT INTO nss_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Iya ndrangan niwen hape, pe ndramat ngara kiro nimnim kiya ndrunu wain ta king tahu Yisip, pe ndramat mepo ngara kiro nimnim kiya ndrinanohun ta king, ara hilu mbusi melit handra mwomwan, pe king ara welen imai ta hilu. ");
INSERT INTO nss_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pe yiy ara ndrinan ilokuh ta hilu ndramat namandran ara–hamou ngara kiro mu para yukiya wain ta king, pe hamou ngara kiro mu para mbusiya ndrinanohun ta king. ");
INSERT INTO nss_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Pwen pe huiki hilu iya nondriya kou. Kou ara, ara ita nondriya seu ta pohon tahu makundrayin mepo ngara hu koro nimnim kiya seu ta king. Kou ara ko, ara Yosep iro aliy yi. ");
INSERT INTO nss_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pe namandran tahu makundrayin ipwai iyata Yosep para maran kiro ta hilu ndramat ara. Pe yihu ro nondriya kou ara ndrangan niwen hape. ");
INSERT INTO nss_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Iro nondriya ping sih, hilu ndramat mepo hilro nimnim iya wain pe ndrinanohun ara hilu malmou kene hilu nihinih. Pe nihinih ta hamou ara handra pe ta hamou ara handra. ");
INSERT INTO nss_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pwen Yosep isa kili hilu mandroulang pe inime saiyani hilu tehe hilu lomwa. ");
INSERT INTO nss_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Pe isike hilu ipa, <<Walu hisah, mara walu isuwas yesah?>> ");
INSERT INTO nss_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Pe hilu somwi hilpa, <<Ehe, youlu malmou kene ara youlu nihinih, pe kinlahi hamou ndramat iripo iye kitiyani ndroiyi nihinih toulu pwi.>> Pwen Yosep ipwai iyata hilu ipa, <<Ngindrai opu ngara kipwaingani ndroiyi nihinih. Kiya, walu katiyani nihinih ta walu kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Pwen pe ndramat ngara kiro nimnim kiya wain ta king ara itiyani nihinih tan ipa, <<Yo ara unihinih pe unime mwisi wain hamou mandrandran iyapolo yowin isa iho mbulumoro. ");
INSERT INTO nss_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Pe mwisi wain ara pelen maroyoh, pe kaimbuwen husarayah, pe indrou pwi iyki nonowen pe hupwai pe sangin ipep iho aliy. ");
INSERT INTO nss_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pwen umbultuwe pweniu ta king; pe uwiri mbuwa wain pe upisa ndrunun iya aliy pe uikiy iya kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosep ipa, <<Ndroiyi nihinih tam ara ipa toro: pelen maroyoh ara iranonoyani lang maroyoh. ");
INSERT INTO nss_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Andre kiho nondriya lang maroyoh, king ara andre kiwiri wou aya mawen nondriya kou pe kiyki wou amui aya mbulyam koluw aro aliy. Pe wou andre aroyuk pweniu para wain kiya nima king tehe koluw ngara aro mbusiy. ");
INSERT INTO nss_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hapeko alohongani yo, kapa melit masih kisarayah hiyan kisa kili wou; pe koyum kisikirani yo, pwen apwai kiyata king para kisa wiri yo kuya mawen nondriya kou aro. ");
INSERT INTO nss_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mamu kinna hu ndramat huluwi tarahani yo uro pwan tahu Hipuruw pe usa uropo kol iye; pe yo kunmbusi handra kultuw mwomwan pwi, hapeko huiki yo ko mwaihei usa nondriya kou aro.>> ");
INSERT INTO nss_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pwen ndramat imu tahu para timwa ndrinanohun ihilingi ndroiyi nihinih ta ndramat para mbulya wain ara mwayih iya. Pwen pe ipa, <<Yo unihinih i. Pe yo ara unimei tehe ukuni keyeh matihat iro poyo, pe hu keyeh ara, ara hupep iya ndrinanohun. ");
INSERT INTO nss_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Keyeh sahat iro ndritan masih ara ipep iya ndrinanohun handra-handra mepo king ngara kinamiliy. Hapeko hu norukan husa pe huroiniy.>> ");
INSERT INTO nss_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Pwen Yosep ipa, <<Ndroiyi nihinih tam ara ipa toro: Keyeh matihat ariya iranonoyani lang maroyoh. ");
INSERT INTO nss_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kiho nondriya lang maroyoh king andre kiwiri wou asa mawen, pe yihu andre kandrusuwam! Pwen yihu andre kandruyani nombuwem kiho ndrungak mandra pahut, pe hu norukan andre kasa pe kainiy.>> ");
INSERT INTO nss_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Pwen lang maroyoh ara, isarahaihai lang para King tahu Yisip nakipwesani lengen mepo tinan imwalahiy iyatan. Pwen pe imbusi kowase yon namandran iyatahu ndramat para poya mbulyan. Pe ndramat para mbulya ndrinanohun, pe ndramat para mbulya wain, ara huwiri hilu sa ngawan iro mbulmara hu ndramat namandran masih para poya mbulya king. ");
INSERT INTO nss_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Pe king iwiri ndramat para mbulya wain tan ara imui iya mbulen tan mamu iro aliy. ");
INSERT INTO nss_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Hapeko iwiri ndramat para timwa ndrinanohun ara, pe huwasi yiy iho ndrungak mandra pahut. Pwen tehen tora ko, ndroiyi nihinih ta hilu kansarayah mannan tehe Yosep kintiyaniy kinnata hilu. ");
INSERT INTO nss_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Hapeko ndramat para mbulya wain ara kinlohongani Yosep pwi, pe koyun ara irut tan masih. ");
INSERT INTO nss_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hayou malwoh kinhipwen, pe iyamulan King tahu Yisip inihinih tehe iro tine ngilse Ndran Nayil. ");
INSERT INTO nss_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Pe inime hu mbulmwakau manandrtimou, ara huro ndran pe husa paingan pwaki ndran, pe huroyan ndromwindriu. Yihu mbulmwakau ara, ara husai iya, pe nombuwehu, ara imuh. ");
INSERT INTO nss_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Pwen hu mbulmwakau manandrtimou i, ara husarayah mulan pe huro ndran husa paingan, pe yihu ara ndruwi-ndruwihu ko, pe sangihu ara imwiling. Yihu sa pe huro tine iyasura hu mbulmwakau para mamu, pe huro ngilse Ndran Nayil. ");
INSERT INTO nss_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Pwen hu mbulmwakau mepo humwiling ara, ara huini topwe hu mbulmwakau mepo nombuwehu imuh pe isai ara. King inime nihinih ara ihipwen pe itine. ");
INSERT INTO nss_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pwen pe imatin porosih i pe inihinih paiwe. Pe inime pele mbuwa youyou manandrtikou ara hu masih huro wule pweye pele hakou o. Pe mbuwa youyou ara hupwai hiyan, pe hurayah namandran pe mwayih. ");
INSERT INTO nss_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Pwen iyamulan hape yi, pe pele mbuwa youyou manandrtikou husarayah i; pe nimnim tahu pele mbuwa youyou ara, ara tehe ngandraha nohai iro kol pwosowen kintimwi hu masih kene. Pe huiki mbuwahu ara hurayah mendreheh o. ");
INSERT INTO nss_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Pe pele mbuwa youyou mepo mendreheh masih ara, huro pe hundrimi hu mbuwa youyou mepo mbuwahu namandran. Pwen king ara itine pe ipahasaniy tehe inihinih. ");
INSERT INTO nss_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pwen mandroulang ara iro pe ilolohonge soyon iya. Pwen iyoh hu ndramat para lohonge hiyan para kol Yisip–yihu ndramat mepo ngara hu karakau. Pwen itiyani nihinih tan iya kili hu para yihu katiyaniy, hapeko hamou tahu kinlahiy para kitiyani ndroiyi nihinih tan pwi. ");
INSERT INTO nss_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Pwen pe ndramat iro mu para yukiya wain ta king ipa, <<Yo mepo andre kupohopoh kiya sehe melit ukose iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wou koluw ara ndrinam ilokuh to pe ta ndramat mepo para timwa ndrinanohun. Pwen pe aiki youlu ya pe youlu ro nondriya kou kili pohon tahu makundrayin mepo ngara kiro nimnim kiya nondriya seu tam. ");
INSERT INTO nss_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Pwen ping sih yo pe yiy youlu nihinih, pe nihinih to ara handra pe atan ara handra. ");
INSERT INTO nss_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Pe wihou hamou para Hipuruw ara irosura yowu. Yiy ara ndramat hamou ngara kiropo mbulen nondriya seu ata pohon tahu makundrayin . Pe youlu tiyani nihinih toulu, pe yiy itiyani ndroiyi nihinih isato pe ata ndramat para timwiya ndrinanohun ara. ");
INSERT INTO nss_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Melit masih kinsarayah mannan tehe kintiyaniy kinsa kili youlu–tehe yo ara umui usa mbulyo, pe yiy ara hundruyani yiy.>> ");
INSERT INTO nss_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pwen king ipwai iyatahu ndramat para poya mbulyan, pe huya wiri Yosep iro nondriya kou isa ngawan. Pwen Yosep irasingi yiy pe isuluye koiwen, pwen isa mbulmara king. ");
INSERT INTO nss_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pe king ipwai iya kili yiy ipa, <<Yo ara unihinih pe kinlahi hamou para kitiyani meresaya nihinih to ara pwi. Yo ara uhulong tehe ngara wou ahalingi nihinih pe alahiy para aratiyani ndroiyin.>> ");
INSERT INTO nss_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Pwen Yosep ipa, <<Yo ara kunlahiy para kumbusi hapesah pwi, hapeko Ngindrai opu ara andre kipwaingani topwe nihinih tam masih mepo ata lohonganiy.>> ");
INSERT INTO nss_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pwen king ipa, <<Yo unihinih pe unime utatine ngilse Ndran Nayil. ");
INSERT INTO nss_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Pwen pe unime hu mbulmwakau manandrtimou, huro ndran pe husa paingan pwaki ndran pe huro yan ndromwindriu. Yihu mbulmwakau ara husai pe lalahayahu iya pe nombuwehu ara imuh. ");
INSERT INTO nss_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Pwen hu mbulmwakau manandrtimou i husa paingan, ara ndruwi-ndruwihu ko pe sangihu ara imwiling. Yo ara kunoho nime hu mbulmwakau tehen tora koro Yisip pwi. ");
INSERT INTO nss_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Pe hu mbulmwakau mepo ndruwi-ndruwihu ko ara huini hu mbulmwakau mepo nombuwehu imuh ara. ");
INSERT INTO nss_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Hapeko iyamulan para huini hu topwei, kinlahi hamou para kiyirowei pwi; nimnim tahu ara iro manau nokuhu ko tehe mamu. Pwen usa tine. ");
INSERT INTO nss_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Pe yo unihinih porosih i, pe unime pele mbuwa youyou manandrtikou ara hu masih huro wule pweye hakou o. Pe mbuwa youyou ara hupwai soyon, pe hurayah namandran pe mwayih. ");
INSERT INTO nss_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Pwen iyamulan hape yi, pe pele mbuwa youyou manandrtikou isarayah i, pe nimnim tahu pele mbuwa youyou ara, ara tehe ngandraha nohai iro kol pwosowen kintimwi hu masih kene. ");
INSERT INTO nss_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Pwen pe pele mbuwa youyou mepo mendreheh masih ara hundrimi hu mbuwa youyou mepo mbuwahu namandran. Yo utiyani nihinih to aro iya kili hu ndramat para takau, hapeko hamou tahu kinlahiy para kitiyani ndroiyi nihinih to pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Pwen Yosep ipwai iyata king ipa, <<Nihinih malndra kene ndroiyi hilu ara handra kopu. Ngindrai ara ipwainganiy isatam sehe melit yiy nakimbusiy. ");
INSERT INTO nss_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Pe hu mbulmwakau manandrtimou hiyan ara iranonoyani hayou manandrtoyoh; pe hu pele mbuwa youyou manandrtikou hiyan ara tehen aliy opu. Nondriya nihinih malndra kene ara ipwaingani melit handra ko. ");
INSERT INTO nss_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Pe hu mbulmwakau manandrtimou pe iyasura pele mbuwa youyou manandrtikou iro ngawan o, pe ngandraha nohai itimwiy hu, ara iranonoyani hayou manandrtoyoh andre mundruwai namandra-namandran kisarayah. ");
INSERT INTO nss_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kiya, tehe upwai satam–Ngindrai ara ipwainganiy isatam sehe melit yiy nakimbusiy. ");
INSERT INTO nss_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nondriya hayou manandrtoyoh ara, andre anandrinai kisarayah soyon iya kiro kol Yisip masih. ");
INSERT INTO nss_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hapeko kiyamulan, andre mundruwai namandra-namandran kisarayah nondriya hayou manandrtoyoh i; pe hu hayou isarayah hiyan mamu ara, andre koyumowu kimayit aliy. Mundruwai namandran ara andre kipwalngani kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Yihu ndramat masih andre koyuhu kirut hu hayou hiyan kanna mepo anandrinai soyon iya isarayah iro aliy, paratesah, mundruwai namandran nakisarayah kamulan, ara nakirayah namandra-namandran iya pe andre kipwalngani kol masih. ");
INSERT INTO nss_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Pe nihinih tam kinsarayah malndra ara, paratesah Ngindrai kinlohonganiy pwen tehe nakimbusiy, pe yiy andre kimbusiy ndrokonan. Pe iyinganiy tehe kindrou pwi melit ara andre kisarayah. ");
INSERT INTO nss_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Pe mahapo ara, hiyan para wou aten hamou ndramat mepo lohongan hiyan, para kiro nimnim kiya kol namandran masih Yisip. ");
INSERT INTO nss_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pe wou arakinima hu ndramat hayah hukasarayah pohon para kol hakol-hakol para nondriya kol namandran masih iye. Pe nondriya hayou manandrtoyoh mepo anandrinai nakisarayah soyon kiro aliy, pwen andre yihu ndramat huro mu iya pohombulen ara andre hu kawiri piyang hasai kiro nondriya piyang mayimisai tahu ndramat masih. ");
INSERT INTO nss_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yihu ndramat hu kaya mu para pohombulen ara, hu kambultani anandrinai masih kiyawule nondriya hu yumwa anandrinai ta king. Pe hu koropo mbulen kiya pahandram pe hu karawurani mbuwa youyou handra-handra, pe hu kaikiy kiya wum namandran kiro kol hakol-hakol para anandrinai. ");
INSERT INTO nss_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Pe anandrinai ara, ara andre yihu kaikiy kiro. Pe kiro mwonen hayou manandrtoyoh para mundruwai namandran nakisarayah kiro Yisip, pwen andre hu ndramat masih andre kanmat kinna mundruwai pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pwen King para Yisip iyasura hu ndramat namandran huya mu para pohombulen, yihu hilingi nongna Yosep pe hupwes iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pe king isok yihu ipa, <<Worou andre tukaten hiyeh hira ndron? Mwoiwa Ngindrai ita kili ndramat iye ko.>> ");
INSERT INTO nss_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pwen king ipwai iyata Yosep ipa, <<Ngindrai ara kinpwaingani melit masih kinsa kili wou; pwen hamou ndramat waison pe lohongan hiyan para kiratiyani melit kiwayis tehe wou ara kinto iye pwi. ");
INSERT INTO nss_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Yo andre kuiki wou aya mu para kol namandran masih iye, pe andre hu ndramiro masih hu koro hilingi wou o. Melit masih ita pahandram, pe ngolo kopu, ara iyerahin kili wou.>> ");
INSERT INTO nss_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pwen king ipwai iyata Yosep ipa, <<Yo mahapo uiki wou aro yapane kol namandran masih Yisip.>> ");
INSERT INTO nss_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pwen king ite pwenah iro ndrakopweniman, pe iykiy iya ndrakopwenima Yosep. Pwenah ara, ara kinima king iyeraliy. Pe king inowi Yosep iya koyau lahayan iya, pe iyki sowiy hasou humbusiy iyau kolt pe inosi Yosep iya aliy. ");
INSERT INTO nss_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Pwen king iwiri karis hakou isa, karis mepo iho mulan iya karis atan, pe iykiy iya kili Yosep pe iho saisai iya aliy. Pe hu ndramat huro mu kili yiy ara huyoh hupa, <<Akaya mawen sai!>> Iya lohonge aro ko king iyinganiy tehe Yosep kinsarayah yapane kol Yisip. ");
INSERT INTO nss_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pe king ipwai iyatan ipa, <<Yo kopu ara king; hapeko kinlahi hamou ndramat iripo Yisip kimbusi handra melit kiya lohonge tan o mwaihei ara pwi. Kapa hiyeh nakimbusi sehe melit ara andre kisok wou kimu.>> ");
INSERT INTO nss_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pe king ipohowe ngala Yosep handra ara Sapenat-Paneyah, pe iyki Asenat SuPotipera iya nambuyun. Potipera ara, yiy hamou pris para nondriya kol namandran Heliyopolis. ");
INSERT INTO nss_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Pwen King tahu Yisip iyki mbulen iya kili Yosep, ara ndrohonga hayou ta Yosep iro matingui. Pwen king iro pe Yosep irikai iya kene nondriya kol masih para Yisip. ");
INSERT INTO nss_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Iro manne hayou manandrtoyoh, hu anandrinai husahapuh pe huhon huya soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Pe iro mwonen hayou ara, Yosep imbultani hu anandrinai soyon iya huro pinge hamou-hamou pe irawuraniy pe iykiy hu huro yumwa anandrinai huro nondriya kol namandran hakol-hakol. ");
INSERT INTO nss_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Pe anandrinai ara iya soyo-soyon iya tehe kalayeng ita poholeng. Pwen pe Yosep koyun iyarut ndromwoyahu. ");
INSERT INTO nss_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Pwen hayou para mundruwai namandran kinsarayah mapu, pe nambuyu Yosep, Asenat SuPotipera, imwalahiy iyata noru Yosep kamai malmou. ");
INSERT INTO nss_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yiy ipa, <<Ngindrai imbusiy, pe koyu ara irut iya nopwaran to iyapolo tomo pe nali hu.>> Pwen pe ipohowe ngala norun ndrihou kamai ara Manasseh ");
INSERT INTO nss_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Iyamulan para norun kopwan isarayah pe Yosep ipa, <<Ngindrai iyki noru hilu malmou, iro nondriya kol para nopwaran ato.>> Pwen pe ipohowe ngala norun kopwan ara Eprayim. ");
INSERT INTO nss_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Pe hayou manandrtoyoh para anandrinai soyon ara kinhipwen nondriya kol Yisip, ");
INSERT INTO nss_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","pe isarahaihai hayou manadrtoyoh para mundruwai namandra-namandran isarayah, tehe Yosep kinpwai. Mundruwai namandran ara iro kol hakol-hakol, hapeko anandrinai ara iro nondriya kol Yisip masih. ");
INSERT INTO nss_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tandrohongan ara yihu Yisip ara humundrui. Pwen yihu rang iya kili king para kihang hu anandrinai. Pe yiy ipwai iyatahu ipa, <<Akaya kili Yosep, pe akambusi sehe melit nakipwai kisa kili wawu.>> ");
INSERT INTO nss_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mundruwai ara, ara isilihi kol masih. Pwen pe Yosep itipe yumwa anandrinai, pe hu ndramat masih para Yisip husa sou anahu anandrinai. ");
INSERT INTO nss_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pe hu ndramat para kol hakol-hakol nondriya kol pwan masih ara husa Yisip para hu kasou anandrinai iro kili Yosep, paratesah, mundruwai namandran ara isilihiy pe ipwalngani topwe kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Pwen tandrohongan ara, Yakop ihilong tehe mbuwa youyou ara iro Yisip. Pe ipwai iya kili norun hu ipa, <<Paratapeh pe wawu mirampwan o mwaihei pe wawuiki koisari? ");
INSERT INTO nss_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Uhulong tehe mbuwa youyou ara ita Yisip. Akayaliy pe akaya sou antou hayah. Mahin tukamat kiya mundruwai.>> ");
INSERT INTO nss_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Pwen nali Yosep hu masongui ara huya Yisip para kaya sou mbuwa youyou. ");
INSERT INTO nss_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Hapeko Yakop kinpwandrisa Penyamin kinna surahu pwi yoh. Yiy ara nali Yosep imwonen. Pe Yakop ara inoh, ipa ndre matisan Penyamin kiya pohonani mwomwan kiho mwalinga sai. ");
INSERT INTO nss_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Pwen noru Yakop hu ara, huya sura hu ndramat hayah mepo hu pakaya sou mbuwa youyou, paratesah, mundruwai namandran ara kintayah iro kol Kenaan i. ");
INSERT INTO nss_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosep ara kintayah pohon para kol Yisip, pe iropo peheya mbuwa youyou iya kili hu ndramat masih mepo ngara hu kaya sou. Pwen pe nali Yosep hu ara husa pe hutukuruhu pe payahu iya pwan. ");
INSERT INTO nss_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Pe Yosep inime nalin hu pe iyirowei tehe ara yihu ko, hapeko imbusi yiy tehe tanan tahu pwi. Pwen yiy isike hu pwokeyan iya ipa, <<Wawu yau aleheh?>> Pe yihu pa, <<Yowu pwen te Kenaan para kasa sou anandrinai.>> ");
INSERT INTO nss_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Pe Yosep ipahasaniy tehe yihu ara nalin, hapeko yihu ara kanyirowei tehe yiy Yosep pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Pwen yiy ara ilohongani nihinih tan mepo inime nalin hu husa pe hutukuruhu iya kili yiy. Pe yiy ara ipa, <<Wawu ara ndramat para tandrihindrih! Wawu pakasa tuluwani nondriya kolo yowu–tehe ipwoke ndre pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Pe yihu pa, <<Pwi yoh, yapane yowu! Yowu sa pahandram para kasa sou anandrinai opu. ");
INSERT INTO nss_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yowu ara noru ndramat hamou o. Yowu ara ndramat para nongan ndrokonan opu–hapeko yowu ndramat para tandrihindrih pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosep ipwai iyatahu ipa, <<Pwi yoh! Wawu ara pakasa tuluwani nondriya kolo yowu, mepo pwokeyan ndre pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Pe yihu pa, <<Yapane yowu, tama yowu ara hamou o, yapane kol Kenaan. Pe yowu norun kamai ara songui pe lumou. Nali yowu hamou ara kinto pwi, pe nali yowu kopwan ara mawihou o pe kinyera ndron sura tama yowu.>> ");
INSERT INTO nss_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Pwen Yosep ipwai iyatahu paiwe ipa, <<Nongno tehe kunpwai mamu ara; wawu ara ndramat para tandrihindrih! ");
INSERT INTO nss_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mahapo upahasani sai para kupakarawani wawu. Yo upwai ndrokonan, iya ngala King towu Yisip, tehe andre wawu kaniyau pwi kipoo nali wawu kopwan ara kisa iye. ");
INSERT INTO nss_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hamou ta wawu kiya pe kiwiri nali wawu kopwan kisa. Pe wawu masih ara akaya pe koyoro nondriya kou, pe yowu andre kakahiy tehe nongan ara ndrokonan ndre pwi. Kapa yowu kakahi nongan ara pwasoyou, pwen upwai ndrokonan iya ngala King towu Yisip, wawu ara ndramat para tandrihindrih.>> ");
INSERT INTO nss_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tehen tora ko, yiy iyki hu huro nondriya kou ipoo lang maroyoh. ");
INSERT INTO nss_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pwen pe lang maroyoh ihipwen, pe Yosep ipwai iyatahu ipa, <<Kapa akayau ndruwa nongno, andre wawu koro hiyan, paratesah, yo ara ndramat hamou ngara kunoh ta Ngindrai. ");
INSERT INTO nss_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kapa nongna wawu ara ndrokonan, pwen hamou ta wawu ara andre kiro ndron nondriya kou. Pe wawu masih akakuni mbuwa youyou ta wawu pe akayaikiy kiya kili hu kontora wum mepo hu tora mundrui. ");
INSERT INTO nss_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Akaya pe akawiri kopwan ta wawu kisa kili yo. Pwen andre kupahasaniy tehe wawu wong ndrokonan, pe andre kunmbusi wawu kanmat pwi.>> Pe yihu ara hupwes iya nongnan. ");
INSERT INTO nss_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Pe hamou iro pwai iyata hamou hupa, <<Animei, koluw tumbusi mwomwan iya kili nali tou. Pe worou tunime yiy irang pe iyoh worou para tukasopwat yiy, hapeko tukanhilingi yiy pwi. Kapa sehe mwomwan kisarayah kiltou, ara iposoiwi mwomwan torou opu.>> ");
INSERT INTO nss_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Pe Rupen ipwai ipa, <<Yo kunpwai kinsa ta wawu tehe wawu ara mbuna akambusi mwomwan kiyata wihou ara; hapeko wawu kanhilingi yo pwi yoh. Pwen pe worou mahapo turopo wiri nopwaran ara iyau kimat tan.>> ");
INSERT INTO nss_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosep ara iro hilingi nongna nalin hu, hapeko yihu tanahu tehe Yosep iro hilingi hu ara pwi yoh, paratesah, Yosep ngara kiwong kiya nongna kol tahu Yisip, pe ndramat hamou para tapaiwe iro tapaiwani nongnan imui iya kili nalin hu. ");
INSERT INTO nss_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Pwen pe Yosep ara itali hu iya mawen pe iya rang. Irang ihipwen, pwen imui iya kili hu pe iwong iya kili hu ndramat para mbulyan, pe humbultuwe Simeyon pe huwasi yiy iro mbulmara nalin hu. ");
INSERT INTO nss_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Pwen Yosep ipwai iyatahu ndramat para poya mbulyan para hu kanihi mbuwa youyou kiya ndropwa nalin hu masih. Pe ipwai iyatahu para hu kaiki singayai ta hamou-hamou ara kimui kiya ndropwahu imwonen, pe para hukayuk anandrinai para sohoya hu yi. Pwen hu ndramat para poya mbulya Yosep humbusi melit masih tehe ipwai. ");
INSERT INTO nss_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Pwen nalin hu huiki mbuwa youyou mepo husou ara iya ndrita hu tongkiy tahu pe huyau. ");
INSERT INTO nss_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Huro tokai huro tokai huya, ipoo kol iya ping tahu. Pwen hungoh huro aliy para hu kamatin. Pwen hamou tahu ara inik ndropwan pe pakiyuk namnam kiyata tongkiy tan, pe inime singayai tan ara iro mara ndrop. ");
INSERT INTO nss_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Pwen iyoh iya kili nalin hu ipa, <<Singayai to ara imui isa kili yo yi. Akanimei, iripo mara ndropwo.>> Pwen yihu ara hunimei pe nerehu imama pe hunoh turut. Pe hamou iro pwai iyata hamou ipa, <<Aripo sehe melit Ngindrai imbusi isa kili tou eh?>> ");
INSERT INTO nss_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pwen huyarayah huya kili tamahu iro Kenaan, pe hunese ndraingan iya melit masih kintayah kili hu. ");
INSERT INTO nss_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Hupa, <<Tomo, ndramat imu iya pohon tahu Yisip ara, iwong pwokeyan iya isa kili yowu ipa, <Wawu ndra pakasa tandrihindrih kasa kolo yowu?> ");
INSERT INTO nss_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pe yowu pa, <Yowu ara ndramat para tandrihindrih pwi yoh, yowu ara ndramat para nongan ndrokonan o. ");
INSERT INTO nss_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tama yowu ara hamou o. Pe yowu norun kamai ara yowu songui pe lumou. Nali yowu hamou ara kinto pwi, pe nali yowu hamou ara kopwan kinyera ndron Kenaan kili tama yowu.> ");
INSERT INTO nss_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Pwen pe ndramat namandran ara ipwai ipa, <Kiya, kapa wawu tora pwai ndrokonan, pwen hamou ta wawu ara andre kiro. Pe wawu masih ara akakun mbuwa youyou pe wawu kayau kaya kili hu ta wawu mepo hu kontora mundrui. ");
INSERT INTO nss_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Akaya pe akawiri nali wawu kopwan kisa kili yo. Pwen pe andre kupahasaniy tehe wawu ara ndramat para tandrihindrih pwi, wawu ara ndramat para nongan ndrokonan. Pwen andre kuiki nali wawu kimui kisa kili wawu, pe wawu andre koro tokai kol iye kiya lohonga wawu ko.> >> ");
INSERT INTO nss_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Pwen hu masih ara pakarayuwani ndropwahu namandran pwi, hunime ndropwa singayai mendreheh ta hamou-hamou tahu iro pohomara ndropwahu sahat-sahat. Pwen yihu yapolo tamahu ara hunimei pe hunoh. ");
INSERT INTO nss_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Pwen tamahu ipwai iyatahu ipa, <<Wawu mbusi tehen tora pe kunpiyani noru hilu. Yosep kinto pwi; Simeyon kinto pwi; pwen nahapo nakawiri Penyamin kiya yi. Melit masih ara iraporuwi yo!>> ");
INSERT INTO nss_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Pwen Rupen ipwai iya kili taman ipa, <<Kapa yo kunsaiki Penyamin kinmui kinsa kili wou pwi, pwen wou atingundru noru hilu kamai malmou ara kaya soiwin. Aiki yiy kisa kili yo pe andre kiro pahandra pwokere to; pwen andre yo kusaiki yiy kimui.>> ");
INSERT INTO nss_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Hapeko Yakop ipa, <<Noru ara andre kinna sura wou pwi. Nalin hamou kinmat pe yiy hamou o ara iripo ndron. Yo ara kunna parangoloh pwen, pe matisan hapesah kirayah kili yiy kiho mwalinga sai, pwen andre kiyki ndriyang kisa kili yo pe andre kumat.>> ");
INSERT INTO nss_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Pwen mundruwai namandran iro Kenaan ara irorayah namandran iya, ");
INSERT INTO nss_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","pe Yakop iyasura norun hu ara huini topwe mbuwa youyou mepo hukun mamu iro Yisip isa. Pwen tamahu ipwai iya kili norun hu ipa, <<Akamui kaya pe akayasou antou hayah mbuwa youyou paiwe.>> ");
INSERT INTO nss_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pwen pe Yutah ipwai ipa, <<Yapene Yisip ara ipwatisingiy isa kili yowu, tehe yowu ara kanlahiy para kayarayah kaya mbulmaran o mwaihei pwi, kipoo yowu kawiri nali yowu kopwan kiyasura yowu. ");
INSERT INTO nss_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kapa apa hiyan para nali yowu kirikai sura yowu, pwen andre yowu kaya sou anandrinai tam. ");
INSERT INTO nss_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Hapeko kapa aniyki yiy kinsa sura yowu pwi, ara andre yowu kanna pwi, paratesah, ndramat ara ipwai isa kili yowu ipa, <Kapa nali wawu kinsa sura wawu pwi, pwen andre kunnime wawu pwi.> >> ");
INSERT INTO nss_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Pwen Yakop, ngalan handra Yisrayel ara, isike hu ipa, <<Paratesah pe wawu pwai iyata yapane kol ara tehe nali wawu hamou iripo ndron? Wawu mbusi tora pe nopwaran namandran iripo rayah kili yo!>> ");
INSERT INTO nss_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yihu pwai iya kili yiy hupa, <<Pe ndramat ara isok yowu soyon iya, ipa <Kiya, tama wawu imirandron? Pe nali wawu hamou ita ndron?> Yiy isok yowu toro pe yowu somwi yiy o. Yowu ara, kanpahasani pwi tehe yiy andre kipa, <Wawu kawiri nali wawu kisa.> >> ");
INSERT INTO nss_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Pwen Yutah ipwai iya kili taman Yisrayel ipa, <<Aiki wihou ara kisa sura yo pe yowu masih kaya kileh. Pwen yowu pe wou pe noru worou hu andre kanmat pwi. ");
INSERT INTO nss_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Awiri yiy kisa pe moro kiro tan. Kapa yo kunwiri yiy kimui kisa kili wou pwi, pwen andre kukuni nopwaran para aliy lang masih. ");
INSERT INTO nss_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kapa ankaituwe yowu pwi, ara yowu kanna pe kansa maporoluwoh pwen.>> ");
INSERT INTO nss_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Pwen tamahu, Yisrayel, ipwai iyatahu ipa, <<Kapa sai hasai pwi, kiya, wawu kambusi toro: kapo hayah melit mwayih para kolorou, pe akanihiy kiya ndropwa wawu pe akayaikiy kiya kili ndramat ara tehe yukyuk. Akawiri melit masih mwayih tehe: kunan, pe ndrunu kei handra-handra para katumwiy kiya mandra ndramat, pe ndraikei mangonohon layin, pe mbuwakei tehe nengei pe nangiyou. ");
INSERT INTO nss_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Akawiri ndromwoya singayai mandrayiluwoh kiro kili wawu; singayai mamu wawu wiriy imui isa, ara kiyapolo singayai para mahapo yi; matisan hu potiriyis pe hunihiy iya ndropwa wawu. ");
INSERT INTO nss_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Akawiri nali wawu pe kamui kileh kaya kili ndramat ara. ");
INSERT INTO nss_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Pe Ngindrai Pwokeyan Masih kiyki koisirai kiya ndriya ndramat ara, para kitali nali wawu kiyapolo Penyamin hilu kamui kasa sura wawu. Pe kapa noruhu masih katali yo, hiyan, hu katali yo.>> ");
INSERT INTO nss_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Pe yihu huwiri topwe yukyuk tahu ara, iyapolo singayai mandrayiluwoh, pe huwiri Penyamin iya polon i. Pwen hu leheleh o huya Yisip, pe huya yingani hu iya kili Yosep. ");
INSERT INTO nss_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Pwen Yosep inime Penyamin iro surahu, pe ipwai iyata ndramat imu iya pohombulen para nondriya suwen, ipa, <<Ayawiri hu ndramat tora kaya suwe, pe atingundru hamou kan pe akaruwaniy para namnam; yihu andre kanamnam kiyasura yo ndrokololang.>> ");
INSERT INTO nss_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Pe ndramat ara imbusiy tehe Yosep ipwai iyatan, pe iwiri hu iya seu ta Yosep. ");
INSERT INTO nss_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pe nali Yosep hu ara huropo huya nondriya seu pe hunoh pe huro pa, <<Worou tusa seu iye, ara andre iya konoha singayai para mamu imui isa nondriya ndropwarou? Yiy matisan pakipanohowani worou, pe tukarayah ndramat para poya mbulyan o mwaihei, pe kiwiri hu tongkiy torou i.>> ");
INSERT INTO nss_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Pwen yihu ya seu ta Yosep, pe hupwai iyata ndramat imu iya pohombulen para yumwan, mepo irotine pohokaram ara, hupa, ");
INSERT INTO nss_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","<<O yapane, koluw kinna ara yowu sa iye para kasa sou anandrinai. ");
INSERT INTO nss_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Yowu ya pe kol iyaping pwen yowu ngoh. Yowu ro ara, pe yowu nikiri ndrop; pwen hamou-hamou towu inime singayai towu iro pohomara ndrop. Ndromwoya singayai ara iro mwonen nokun o, pwen yowu wiriy imui yi. ");
INSERT INTO nss_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Mahapo ara yowu po singayai hayah iya suran i, para pakasa sou anandrinai. Hapeko yowu kanpahasaniy pwi, sehe ndramat ndrokonan inihi singayai imui iya ndropwa yowu.>> ");
INSERT INTO nss_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ndramat ara ihilingi nongnahu pe ipa, <<Ara hiyan; wawu mbuna akanoh. Ngindrai ta wawu pe Ngindrai ta tama wawu ara iyki singayai iya ndropwa wawu. Singayai ta wawu para mamu ara kunwiriy.>> Pwen iya wiri Simeyon pe iyki yiy imui iya kili hu. ");
INSERT INTO nss_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Pe ndramira mbulen ara iwiri hu pe huya nondriya seu ta Yosep. Pe iyki ndran para sungeya ndrikahu, pe iya yuk anandrinai iyata hu tongkiy tahu yi. ");
INSERT INTO nss_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Pe yihu hulong tehe Yosep ara andre kisa namnam kisapolo hu ndrokololang, pwen yihu ara huramwaniye yukyuk tahu ko pe humin. ");
INSERT INTO nss_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Pwen Yosep isa wum, pe yihuiki hu yukyuk mepo huwiriy isa seu, ara iya kili yiy. Pe yihu tukuruhu iya kili yiy pe payahu ara iya pwan. ");
INSERT INTO nss_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Pwen Yosep ipa ndrokololang iyatahu, pe isok hu ipa, <<Tama wawu koluw mepo wawu nese ndraingo iyatan, ara iyerandron?>> ");
INSERT INTO nss_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Pe hupwai iya kili yiy hupa, <<Yapanewu, tama yowu ara ita hiyan.>> Pwen hutukuruhu pe payahu ara iya pwan paiwe yi. ");
INSERT INTO nss_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pwen Yosep inime nalin ndrokonan, Penyamin, mepo tina hilu hamou o, pe isike hu ipa, <<Nali wawu kopwan, mepo koluw wawu sa pe wawu nese ndraingo iyatan ara, aripo, ndre?>> Pwen yiy ipa, <<Noru, koisirai ata Ngindrai ara ita sura wou.>> ");
INSERT INTO nss_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Pe Yosep ara koyun isikirani nalin pwokeyan iya, pe ileheleh o iya kah hape nokun iro nondriya suwen para kiya aliy pe kirang. Pwen iya rang iya ndrohonoku matiliu tan. ");
INSERT INTO nss_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Irang ihipwen, ihitih, pe isungani mbulmaran. Pwen mandran ipwoke pe isa ngawan. Pe ipwai iyatahu ndramat para poya mbulyan ipa, <<Akawiri anandrinai kisa ngawan.>> ");
INSERT INTO nss_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Pwen hurai anan ara iya keyau sih, pe ana nalin hu ara iya keyau sih i. Pe anahu Yisip huro sura yiy ara iya keyau sih i, paratesah, yihu Yisip ara hu konoho namnam kinna sura hu Hipuruw pwi yoh. Pakut ara, ara kinmwonen mbulmara hu Yisip pwi. ");
INSERT INTO nss_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosep kinpwai kinna tahu ndramat para poya mbulyan pe huiki nalin hu, ara hu humpwan iyau ndruwa mamandra tahu–iro kili ndrohan pe iyahapwen iya kili kopwan. Pwen pe nalin hu hunimei tehe humipwan tehen tora pe hamou ituluwani hamou pe mwoiwahu ihin. ");
INSERT INTO nss_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hu ndramat para mbulya Yosep huwiri anandrinai iro keyau ta Yosep pe hurai iya pwelekeya nalin hu ara weneyan o. Hapeko ata Penyamin ara hurai ihohin iya, iya tahu masih; isahapwas masih tehe ilahi hu ndramat mayimou hu kainiy. Pwen huro namnam pe huro yin ndran pe huro pwes iyasura Yosep. ");
INSERT INTO nss_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Pwen pe Yosep ara iyki nongan iya kili ndramat imu para poho mbulen iro nondriya suwen ipa, <<Anihi anandrinai kiya ndropwahu hamou-hamou ara kiya weneyan o, ilahiy para hu kakuniy. Pe aiki singayai tahu hamou-hamou ara kimui kiya mara ndropwahu masih kene. ");
INSERT INTO nss_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pwen awiri pweniu silwa to pe aikiy kiya ndropwa kopwan tahu, kiyasura singayai mepo pakisasou mbuwa youyou kiya aliy.>> Pwen pe yiy imbusiy tehe Yosep ipwai. ");
INSERT INTO nss_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pe makoluhun o hupwandrisa nali Yosep hu iyasura hu tongkiy tahu huyau. ");
INSERT INTO nss_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pwen nalin hu ara hutali kol namandran pe hu kanna mwanan mapwi, pe Yosep ipwai iyata ndramat imu para pohombulen ipa, <<Atine pe ahaleh aro ndruwa hu ndramat ara. Ayarayah aya kili hu, pe asike hu toro: <Yowu kanmbusi hiyan kinsa kili wawu, pe paratesah wawu mbusi kultuw ara isa kili yowu? ");
INSERT INTO nss_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Pweniu nepo wawu kanwiriy, ara pweniu ta yapane yowu mepo ngara kiyinyin kiya aliy. Pe yiy ara ngara kiwiri lohongai hiyan para tayakau kiyau pweniu silwa ara ko. Wawu mbusi kultuw ara, ara mwomwan masih.> >> ");
INSERT INTO nss_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Pwen ndramira Yosep ara, ihilleh pe iyambultuwe nali Yosep hu huhondron sai sahin. Pe iyapwai topwe nongan masih mepo Yosep kinpwai kinnatan. ");
INSERT INTO nss_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Pe hupwai iya kili yiy hupa: <<Paratapeh pe apwai tehen tora isa kili yowu? Yowu ara kanlahiy para kambusi kultuw ara pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Wou tanam tehe singayai mepo yowu wiriy iro mara ndrop towu iro kol Kenaan, ara yowu kansaikiy kinimui iho nondriya tokuyai maporolusap. Tehen tapeh, apa ndre yowu pahanowe silwa ndre kolt iro nondriya seu ta yapanem? ");
INSERT INTO nss_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Namandran, kapa anime hiyeh towu ndramat para pwandrendres tam, ara iwiri pweniu pe inihiy iya ndropwan, pwen akarayi ndramat ara kimat, pe yowu masih andre karayah ndramat para poya mbulyam o mwaihei.>> ");
INSERT INTO nss_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Pe ndramat para pohombulen ta Yosep ara ipa, <<Nongna wawu imwonen. Hapeko kapa kunime hiyeh ta wawu iwiri pweniu ara, yiy opu andre kisa pe kirayah ndramat para poya mbulyo ko mwaihei. Pe wawu masih mepo kantandroindroi pwi, ara wawu masih kayau.>> ");
INSERT INTO nss_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Pwen o, yihu hamou-hamou ara huiki ndropwahu iya pwan pe hutipei. ");
INSERT INTO nss_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Pwen ndramat imu iya poho mbulen ta Yosep inime nondriya ndropwahu masih–iro kili ndrohan ipoo iya matne kopwan. Pe inime pweniu ara iro nondriya ndrop ta kopwan tahu, Penyamin. ");
INSERT INTO nss_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pwen nalin hu ara hunime pweniu iro kili yiy, pe hu ndrohomwiri koiwe hu, paratesah, ndriyahu ara irangsi yiy. Pwen huiki ndrop tahu imui iya ndrita hu tongkiy tahu pe humui huya kol namandran ara paiwe. ");
INSERT INTO nss_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Pwen Yutah pe nalin hu, humui huya seu ta Yosep pe hunime yiy ara iye ndron aliy. Pe hunoh turut pe hulah huya pwan mbulmaran. ");
INSERT INTO nss_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Pe Yosep ipwai iya kili hu ipa, <<Wawu mbusi kultuw ara paratesah ndrokonan! Wawu kanpahasaniy tehe ndramat hamou tehe yo, ara ulahiy para kurakau pe kupahasani hu melit kokohon ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Pe Yutah ipa toro: <<Yapane, yowu andre kapa tesah kiya nongnam? Yowu ara kanlahiy para kanpa hapesah pwi. Ngindrai ara kinpwaingani mwomwan towu pwen. Yapane, andre yowu, pe yiy mepo iwiri pweniu tam, ara yowu masih karayah ndramat para poya mbulyam o mwaihei.>> ");
INSERT INTO nss_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hapeko Yosep ipa, <<Pwi yoh, andre kunmbusi tehen tora kisa kili wawu pwi! Andre ndramat o, mepo iwiri pweniu to, ara andre kirayah ndramat para poya mbulyo ko mwaihei. Pe wawu masih ara ndriya wawu kiwayis pe akamui kaya kili tama wawu.>> ");
INSERT INTO nss_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Pwen Yutah iya ndrahasa Yosep pe ipa, <<Yapane, ahalingi yo na; ndrinam mbuna kilokuh to, yo nakuwong hape na. Wou ara pohon para Yisip, imwonen tehe King o. ");
INSERT INTO nss_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Yapane, koluw wou asike yowu tehe toro: <Wawu ma tama wawu pe ma nali wawu ndre pwi?> ");
INSERT INTO nss_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Pe yowu pa, <Ehe, tama yowu ara kinna parangoloh. Pe yiy kinna parangoloh pwen pe iyki nali yowu hamou kopwan. Yiy kopwan ara iyera, pe nalin hamou ara kinmat; tina hilu ara hamou o. Pe taman ara inamili yiy namandran iya.> ");
INSERT INTO nss_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Yapane, wou mbukenam apwai pe yowu wiri nali yowu kinsa para anime yiy. ");
INSERT INTO nss_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Pe yowu pwai isa kili wou, tehe taman ara kinoho piyani yiy pwi. Kapa kitali taman, andre taman kimat. ");
INSERT INTO nss_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hapeko wou apwai isa kili yowu apa, <Kapa nali wawu kinsa sura wawu pwi, pwen andre wawu kanlahiy para kasa mbulmoro iye pwi.> ");
INSERT INTO nss_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Pwen yowu mui yowu ya kili tama yowu, ndramat para pwandrendres tam, pe yowu nese ndraingan iya sehe melit apwai. ");
INSERT INTO nss_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Pe tama yowu ara ipwandrisa yowu para kamui pe kasasou anandrinai tiken yi. ");
INSERT INTO nss_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Pe yowu pwai yatan yowu pa, <Kapa nali yowu kopwan ara kinto sura yowu pwi, pwen yowu kanlahiy para kanna pwi. Kinlahiy para yowu kayarayah kaya mbulmara ndramat namandran ara pwi, kipoo yowu kaya kapolo nali yowu kopwan.> ");
INSERT INTO nss_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Pe tama yowu, ndramat para pwandrendres tam, ara ipwai isa kili yowu ipa, <Wawu pahasani tehe nambuyu imwalahiy iyata noru kamai malmou opu. ");
INSERT INTO nss_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Hamou ara kinna mawen kili yo, pe upa ndre hamou kan kintayiy kinmat, pe kinyani yiy topwei. ");
INSERT INTO nss_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Pe kapa wawu kawiri hamou iye kiya mawen kili yo yi, andre wawu kaiki koisirai kisa kili yo, pe andre yo kumat kileh.> ");
INSERT INTO nss_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kapa yowu kanwiri mbunah ara kinmui kinna sura yowu pwi, tama yowu ara andre kimat, paratesah, kopwan tan ara tehe neren imwonen. ");
INSERT INTO nss_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Kapa tama yowu kinnime mbunah kamai kinto sura yowu pwi, yiy andre kikoi. Pwen tehen tora ko pe yowu andre kaiki nopwaran kiya kili tama yowu, pe yiy andre kiyki koisariy pe kimat kileh! ");
INSERT INTO nss_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yo ara upwatisingiy iya kili tomo tehe andre kuro pwokarani kopwan pe kuwiri yiy kimui kiya kili yiy. Pe yo upa, <Kapa yo kunwiri yiy kimui pwi, pwen andre mwomwan ara kiro ndrito lang masih.> ");
INSERT INTO nss_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Pwen pe yo usike wou, Yapane, para kuwiri noku kopwan towu, pe yo ara kurayah ndramat para poya mbulyam o mwaihei. Pe hiyan para wou aiki yiy kimui kiyasura nalin hu. ");
INSERT INTO nss_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kapa kopwan ara kinna sura yo pwi, tehen tapeh pe andre kumui kuya kili tomo? Pwi yoh! Mbuwali para kunime nopwaran ara kirayah kili tomo.>> ");
INSERT INTO nss_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosep ara koyun isikirani nalin hu pe ihingorowei tehe pakirang. Pwen pe iyoh iya kili hu yau tan ipa, <<Wawu masih kaya ngawan namu.>> Pe yiy hamou o iro sura nalin hu, pe ipwaingani yiy iya kili hu. ");
INSERT INTO nss_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yosep irang namandran iya pe hu para Yisip huhilingiy. Pwen yihu ya seu ta king pe huya nese ndraingan. ");
INSERT INTO nss_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosep ipwai iya kili nalin hu ipa, <<Yo ara Yosep; tomo iyera?>> Hapeko nalin hu, nongnan ara ilohori hu, pe yihu kanlahiy para kasomwi yiy pwi. ");
INSERT INTO nss_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosep ipwai iyatahu paiwe ipa, <<Akasa pakeh kili yo.>> Pwen huya pakeh kili yiy pe ipa, <<Yo ara nali wawu, Yosep. Koluw wawuiki yo tehe kenna wawu pe husowani yo pe husaiki yo usa Yisip. ");
INSERT INTO nss_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Pe mahapo mbuna akoro lohonge soyon pe ndrina wawu mbuna kilokuh ta wawu mbukena wawu iya kultuw mepo wawu mbusiy isa kili yo mamu; paratesah, Ngindrai ara ipwandrisa yo umu ta wawu para kusopwat hu ndramat pe andre hu kanmat pwi. ");
INSERT INTO nss_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Mundruwai ara kinngas kol pwan nondriya hayou malwoh pwen; pe hayou mayimah itandron, ara andre hu ndramat kanlahiy para kapo anandrinai kiro piyang pwi. ");
INSERT INTO nss_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ngindrai ara imbusi melit namandran pe iya handra masih isa kili wawu, paratesah, ipwandrisa yo umu usa urupo iye ara para kusopwat wawu, pe andre wawu kanmat pwi. ");
INSERT INTO nss_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Pwen pe wawu kanpwandrisa yo kunsa kol iye pwi, Ngindrai mbukenan ara ipwandrisa yo usa. Pe yiy o imbusi yo usarayah tehe tama King tahu Yisip. Yo urupo nimnim iyatahu ndramat masih para nondriya suwen, pe yo uya namandran tahu kol masih iripo nondriya kol namandran masih Yisip. ");
INSERT INTO nss_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Mahapo akahalleh kaya kili tomo pe akapwai katan toro: <Yo, norum Yosep, uiki nongan iye isa kili wou: Ngindrai imbusi yo urayah yapane kol namandran Yisip. Pe mbuna alonge, wou ahaleh asa kili yo. ");
INSERT INTO nss_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Andre wou ampwan kol Kosen, pakeh kili yo–wou pe norum hu, pe tumbum hu masih, wawu andre kampwan kol ara, kiyasura hu meme pe hu mbulmwakau pe kiyasura meltam masih. ");
INSERT INTO nss_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Asa pe wawu kampwan kol Kosen pe andre yo kuro nimnim kisatam; paratesah, hayou mayimah para mundruwai namandran ara mapu kinsa, pe yo mbuwali para wawu norum pe hu kan masih ara hu kamundrui.> >> ");
INSERT INTO nss_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Pe Yosep ipwai iya kili nalin hu ipa, <<Wawu lahi kayirowe yo, pe Penyamin ara tehen aliy yi, tehe yo ara Yosep ndrokonan uropo wong isa kili wawu. ");
INSERT INTO nss_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Wawu kayapwai kata tomo, tehe yo ara mangolo urupo nondriya kol namandran masih Yisip. Pe akapwai katan kiya melit masih mepo wawu kannimei topwei. Wawu kaya pe kawiri yiy kisa kileh.>> ");
INSERT INTO nss_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yosep iwong ihipwen pe indrohosi nalin Penyamin, pe Penyamin ara imbusiy tehen aliy yi; pe hilu rangsi hilu. ");
INSERT INTO nss_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Pe Yosep irakunani nalin hu pe irahunghung iyatahu pe irang. Pwen nalin hu ara hungoruwe hiyan para hu kawong kawule. ");
INSERT INTO nss_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pwen King para Yisip ihilong tehe nali Yosep hu ara hu kansa, pe king iyasura hu ndramiran namandran ara hu masih hupwes. ");
INSERT INTO nss_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pe king ipwai iyata Yosep ipa, <<Aya pe apwai kiyata nalim hu toro: <Wawu kamwaniyani wawu kapolo hu tongkiy, pe akamui kaya kol Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Pe wawu kayawiri tama wawu pe noru wawu hu masih, pe wawu masih kamui kasa kili yo. Pe andre yo kupwainge hape pwan hiyan masih iripo nondriya Yisip kiyata wawu. Pe pwan ara anandrinai andre kirayah kiro aliy soyon iya, pe andre hu koroyan lang masih.> >> ");
INSERT INTO nss_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Pe king ipwai paiwe iya kili Yosep ipa, <<Wou apwai kiyatahu toro: Wawu kawiri hu karis hayah para Yisip kiyapolo wawu, pe wawu kayawiri hu nambuyu wawu hu pe noru wawu hu kiyasura tama wawu pe akasa. ");
INSERT INTO nss_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wawu mbuna akalohonge kiya melit masih para kol Kenaan, paratesah, melit hitun iripo nondriya kol Yisip ara andre kuikiy kisata wawu.>> ");
INSERT INTO nss_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Pwen noru Yisrayel hu ara, ara yihu mbusiy tehe king kinpwai. Pe Yosep ihilingi nongna king pe yiy iyki hu karis hayah iya kili hu, iyapolo anandrinai tiken para sohoya sai. ");
INSERT INTO nss_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Pe iyuk koyau hamou-hamou iyatahu, hapeko ata Penyamin o ara iyki koyau mayimou, iyasura sombule pat silwa matingat. ");
INSERT INTO nss_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Pe Yosep iwiri melit soyon mwayih para Yisip pe iykiy iya ndrita hu tongkiy kamai masongui pe yiy irapiyaniy iya kili taman. Pe yiy iwiri ndrinanohun pe melit tehe mbuwa youyou handra-handra, pe ikiy iya ndrita hu tongkiy pihin masongui, pe irapiyaniy para kisopwat taman kiho sai. ");
INSERT INTO nss_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pwen Yosep ipwandrisa nalin hu huyau, pe ipwai iya tahu ipa, <<Wawu kayau pe mbuna akahangas mwalinga wawu koho sai.>> ");
INSERT INTO nss_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Pwen nalin hu ara hutali kol Yisip pe huyau humui huya kili tamahu, Yakop, iro kol Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Pwen yihu pwai iyata tamahu hupa, <<Yosep ara kinimat pwi yoh! Yiy ara iyera ndron, pe ita nimnim iya kol Yisip masih!>> Yakop ihilingi nongan aro pe lohongan indrap. Pe kiniyki ndriyan kinna nongnahu pwi. ");
INSERT INTO nss_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pe yihu tiyani melit masih kene iya kili tamahu tehe Yosep kinpwai kinnatahu. Pwen Yakop inime hu karis mepo Yosep ipwandrisa hu husa para kiwiri yiy kiya Yisip, pe lohongan ara imui. ");
INSERT INTO nss_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Pwen Yisrayel ipa, <<Ndrokonan! Mahapo upahasaniy tehe noru, Yosep, ara iyera ndron. Ma uye po ndron, pwen andre kuya nime yiy.>> ");
INSERT INTO nss_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Pe Yakop irakuhuyani hu meltan masih iyasura norun hu, pe huropo hu nakaya kol Yisip. Pwen huyarayah huya kol Peersepa pe Yakop ara itingundru hu kan hayah pe iyki hu iya kili Ngindrai ta taman Yisak tehe yukyuk. ");
INSERT INTO nss_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Pwen ping ara Ngindrai iwong iya kili Yakop iya taltan, pe ipa, <<Yakop! Yakop!>> Pe Yakop isomwi Ngindrai ipa, <<Tesah? Yo urupo.>> ");
INSERT INTO nss_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Pe yiy ipa, <<Yo ara Ngindrai–Ngindrai ta tamam. Wou mbuna anoh para aya kol Yisip. Yo ara andre kumbusi wawu karayah soyon iya, koro ariya. ");
INSERT INTO nss_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yo andre kuya Yisip sura wou, pe andre kuwiri wou amui asa mawen paiwe. Pwen kapa amat, andre Yosep mbukenan kironi wou.>> ");
INSERT INTO nss_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Pwen Yakop itali Peersepa, pe noru Yisrayel hu kamai ara huwiri tamahu, Yakop, iyasura nambuyuhu pe noruhu masih pe huhis huya hu karis mepo King tahu Yisip kinpwandrisa hu para kasuni hu kaliy. ");
INSERT INTO nss_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Pe yihu ara hulokuhuyani hu mbulmwakau iyasura melit masih tahu mepo iro kol Kenaan. Pe Yakop iyasura tumbun hu masih ara huya Yisip. ");
INSERT INTO nss_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yiy iwiri norun hu kamai pe pihin, iyapolo tumbun hu kamai pe pihin masih kene pe hu masih huyau. ");
INSERT INTO nss_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Iye ara ngala noru Yisrayel hu masih kene mepo huya sura yiy pe huya Yisip (Yakop iyasura norun hu): Ndrihou ta Yakop ara Rupen. ");
INSERT INTO nss_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Pe noru Rupen hu kamai, ngalahu ara iye: Hanok, Pallu, Hesron pe Karmi. ");
INSERT INTO nss_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Pe noru Simeyon hu kamai, ngalahu ara iye: Yemuwel, Yamin, Ohat, Yakin, Sohar, pe Sol–yiy ara noru pihi Kenaan hamou. ");
INSERT INTO nss_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Pe noru Lepi hu kamai, ngalahu ara iye: Kerson, Kohat, pe Merari. ");
INSERT INTO nss_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Pe noru Yutah hu kamai, ngalahu ara iye: Er, Onan, Selah, Peres pe Serah, (hapeko Er pe Onan ara hilu kanmat pwen iro ndron kol Kenaan). Pe ngala noru Peres hilu kamai, ngala hilu ara iye: Hesron pe Hamul. ");
INSERT INTO nss_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Pe noru Yissakar hu kamai, ngalahu ara iye: Tola, Puwah, Yasup, pe Simron. ");
INSERT INTO nss_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Pe noru Sepulun hu kamai, ngalahu ara iye: Seret, Elon pe Yahleel. ");
INSERT INTO nss_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ariya kene ara ngala noru Yakop hu mwaniye husarayah iro kili Leyah mepo imwalahiy iyatahu irondron kol Pattan Aram. Pe Leyah ara imwalahiy iyata mbunah hamou pihin i, ngalan Tainah. Pwen pe noru Yakop hu pe tumbun hu masih husarayah kili Leyah ara, ndromwoyahu masih kene iyawule ara tingui pe timou (33). ");
INSERT INTO nss_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Pe noru Kat hu kamai ngalahu ara iye: Sepon, Hakki, Suni, Espon, Eri, Aroti pe Areli. ");
INSERT INTO nss_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Pe noru Aser hu kamai, ngalahu ara iye: Yimnah, Yispah, Yispi pe Periyah, pe pisuhu ara Serah. Pe noru Periyah hilu kamai, ngala hilu ara iye: Heper pe Malkiyel. ");
INSERT INTO nss_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ariya kene ara ngala noru Yakop hu pe tumbun hu masih husarayah iro kili Silpah mepo Lepan iykiy iya kili norun Leyah. Ndromwoyahu masih iyawule ara songui pe anomou (16). ");
INSERT INTO nss_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Pe noru Yakop hilu hilsarayah iro kili nambuyun Rahel ngala hilu ara iye: Yosep pe Penyamin. ");
INSERT INTO nss_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosep ara iro Yisip pe iwiri Asenat SuPotipera pe iyki Manasseh hilu Eprayim. (Potipera ara yiy pris hamou para kol Heliyopolis.) ");
INSERT INTO nss_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Pe noru Peniyamin hu kamai, ngalahu ara iye: Pela, Peker, Aspel, Kera, Naaman, Ehi, Ros, Muppim, Huppim, pe Art. ");
INSERT INTO nss_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ariya kene ara ngala noru Yakop hu pe tumbun hu masih husarayah iro kili Rahel. Ndromwoyahu masih iyawule ara songui pe haamou (14). ");
INSERT INTO nss_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Pe noru Tan kamai, ngalan ara iye: Husim. ");
INSERT INTO nss_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Pe noru Naptali hu kamai, ngalahu ara iye: Yahsiyel, Kuni, Yeser, pe Sillem. ");
INSERT INTO nss_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ariya kene ara ngala noru Yakop hu pe tumbun hu masih husarayah iro kili Pilhah mepo Lepan iykiy iya kili norun Rahel. Ndromwoyahu masih iyawule ara manandrtimou (7). ");
INSERT INTO nss_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ariya kene ara noru Yakop hu pe tumbun hu imwonen mepo huya Yisip. Pe ndromwoyahu masih kene iyawule ara anongui pe anomou (66). Hapeko hu mbuyu ngundra Yakop ara ndromwoyahu kinto nondriya ndromndrom iye pwi. ");
INSERT INTO nss_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pe iyapolo hilu mbunah kamai ta Yosep mepo tina hilu imwalahiy ta hilu iro Yisip, pwen ndromwoya tumbu Yakop hu masih huro Yisip ara manandrtingui (70) imwonen. ");
INSERT INTO nss_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Pwen Yakop ara ipwandrisa Yutah para kiyamu kiyatan para kiya sike Yosep iya meresai iyapwen te Kosen. Pwen huyarayah huya Kosen, ");
INSERT INTO nss_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","pe Yosep imwaniyani karis tan pe iya pohonani taman, Yisrayel, iya kol Kosen. Pwen Yosep iyarayah iya kili taman o, indrohosi yiy pe irang mali yiy. ");
INSERT INTO nss_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Pwen Yisrayel ipwai iyata Yosep ipa, <<Mahapo andre kuyen o pe kuye longe kimat o; paratesah, kunsa nime wou pwen, pe upahasaniy tehe ayepondron.>> ");
INSERT INTO nss_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pwen Yosep ipwai iyata nalin hu pe hu para wum ta taman masih ipa, <<Mahapoko andre kuya pe kupwai kiyata King tahu Yisip kupa, <Tomo pe nali hu ara hu kantali Kenaan pe hu masih kansarayah kansa kili yo topwei. ");
INSERT INTO nss_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yihu ara hu ndramat para pwokereya hu sipsip. Pe yihu lokuhuyani hu sipsip pe hu mbulmwakau yasura meltahu masih pe hu kansa.> ");
INSERT INTO nss_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Yo nakupwai kiyata king tehen toro, pe kapa king kiyoh wawu pe kisike wawu kiya sehe mbulen wawu pahasaniy para kambusiy, ");
INSERT INTO nss_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","pwen wawu kapwai kapa, <Yapane yowu, yowu ara ndramat para kapwokerani hu sipsip pe hu mbulmwakau. Yowu ngara kambusi mbulen tehen toro mambunah towu ipoo isa mannen mahapo; paratesah, tama yowuhu koluw ngara hu kambusiy tehen aliy.> Kapa wawu kapwai kiyata king toro, pwen andre kiyki wawu kampwan kol mendreheh Kosen, paratesah, hu ndramat para Yisip ara mbuwalihu para hu kanime hu ndramat para pwokereya hu sipsip.>> ");
INSERT INTO nss_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Pwen Yosep ara iya pe iya pwai iyata King tahu Yisip ipa, <<Tomo pe nalihu ara hu kantali kol Kenaan pe hu kansa. Husa yasura hu sipsip, hu mbulmwakau, pe iyapolo meltahu masih, pe mahapo hu tora kol Kosen.>> ");
INSERT INTO nss_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Pwen Yosep irakinima nalin hu mayimou pe iwiri hu pe iya pwaingani hu iya mbulmara king. ");
INSERT INTO nss_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pe King tahu Yisip ara isike hu ipa, <<Mbulya wawu ara tesah ndrokonan?>> Pe yihu pwai iya kili king hupa, <<Yapane yowu, yowu ara ndramat para pwokereya hu sipsip, tehe tama yowu hu ngara hu kambusiy koluw.>> ");
INSERT INTO nss_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pwen yihu pwai iyatan hupa, <<Yowu nakoro kol iye hape na, paratesah, mundruwai namandran ara ipwalngani kol Kenaan. Pe ndromwindriu, mepo anandrina hu sipsip towu, ara kinihipwen topwei. Yapane yowu, kapa welem kiso towu, yowu namiliy para yowu kampwan kol Kosen.>> ");
INSERT INTO nss_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pwen king ipwai iyata Yosep ipa, <<Tamam pe nalim hu, ara hu kansa pwen, pe andre hu koro sura wou. ");
INSERT INTO nss_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Pe wou alohongani hambut pwan hiyan masih hira hapeleheh iripo nondriya pwan Yisip, pe wou apwai kiyatahu para hu kampwan aliy. Kapa anamiliy, hiyan; aiki hu kampwan kol Kosen. Pe kapa hiyeh tahu lohongahu iman para hangna hu mbulmwakau, apwai katahu kasa pe kapwokere to yi.>> ");
INSERT INTO nss_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Pwen Yosep iwiri taman iya kili king, pe yiy itoholi king. ");
INSERT INTO nss_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pe king isike yiy ipa, <<Hayou tam masahayeh?>> ");
INSERT INTO nss_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Pe Yakop ipwai iyatan ipa, <<Hayou to urupo kol pwan ara sangat pe tingui(130) opu. Hayou to ara mullai o, pe ngandrahan hape kopu. Hapeko, hayou ata tumbu hu ara soyon iya iramwaitini hayou to.>> ");
INSERT INTO nss_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pwen Yakop itoholi king ihipwen, itali yiy pe iyau. ");
INSERT INTO nss_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iyamulan, Yosep imbusiy tehe king ipwai iyatan; pe iwiri taman pe nalin hu pe huya huye kol namandran masih Yisip. Pe iyki pwan iya kili hu iro nondriya kol namadran hape Rameses. Pe pwan ara, ara hiyan iya, pe iramwaitini pwan masih hira nondriya kol Yisip. ");
INSERT INTO nss_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Pwen Yosep ara ngara kinimnim kiyata ndrayen hu kiya anandrinai. Pe yiy ngara kiyuk anandrinai kiya kili taman, nalin hu, nambuyu nalin hu, pe noru nalin hu ara iwene hu ko. ");
INSERT INTO nss_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mundruwai namandran irorayah manau pe anandrinai masih para kol ara ihipwen. Tandrohongan ara ipwalngani kol namandran Yisip pe Kenaan kene. ");
INSERT INTO nss_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Pe hu ndramat masih para kol Yisip pe Kenaan, singayai tahu masih kene ara hupiye topwei iya sowa mbuwa youyou iro hu wum namandran mepo Yosep iro nimnim iya aliy. Pe Yosep iwiri topwe singayai tahu ara, pe iyaikiy iro seu ta king. ");
INSERT INTO nss_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Pwen singayai tahu ndramat para kol Yisip pe Kenaan ara ihipwen masih, pe hu ndramat para Yisip huya kili Yosep. Pe hupwai iyatan hupa, <<Wou ahang yowu anandrinai; kapa pwi, andre mundruwai namandra-namandran iye kipwalngani yowu, pe andre yowu kayos pe kamat koro mbulmaram! Asopwat yowu, paratesah, singayai towu masih ara kinihipwen topwei.>> ");
INSERT INTO nss_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Pwen Yosep ipwai ipa, <<Kapa singayai tawawu kinihipwen, kiya, akawiri hu kan ta wawu kisa pe akasulye kaliy pe akapo anandrinai.>> ");
INSERT INTO nss_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Pwen yihu ya yuk hu hos, hu sipsip, hu meme, hu mbulmwakau, pe hu tongkiy tahu ara iya kili Yosep. Pwen hayou ara, ara huro mbusi tehen tora ko, pe huro po anandrinai. ");
INSERT INTO nss_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pwen pe hayou ara isayau pe humui huya kili Yosep pe hupwai iyatan hupa, <<Yapane yowu, yowu ara kanlahiy para kakulani hapesah mbulmaram pwi. Wou anwiri topwe singayai towu pe hu kan towu masih. Hapesah kinto pwi; melit malndra iripo ndron ara yowu ndramat pe pwane yowu ko. ");
INSERT INTO nss_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Wou mbunandronge yowu ndramat kamat koro mbulmaram, pe yowu kasura pwane yowu kaya mwomwan masih. Kiya, asowani yowu pe pwane yowu para kasulye anandrinai kaliy. Hiyan para king kiwiri yowu pe pwane yowu kaya pahandran. Akahang yowu mbuwa youyou pe andre yowu kanmat pwi, pe pwane yowu andre kinna mwomwan pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Pwen iro tandrohongan ara, Yosep isowani topwe pwan masih tahu Yisip. Yihu ndramat masih kene para Yisip ara huiki topwe pwanehu masih ara iya pwane king; paratesah, mundruwai namandran ara irayah namandran iya. ");
INSERT INTO nss_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Pe Yosep ara imbusi hu ndramira Yisip masih ara husarayah ndramat para poya mbulya king, iro mbusungo kol sahin iya matne sahin para Yisip. ");
INSERT INTO nss_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hapeko pwan tahu pris opu ara Yosep kinsowaniy pwi; paratesah, king ngara kiyuk singayai kiya kili hu pris, pe yihu sowani anandrinahu iya aliy. Tehen tora ko pe hu pris kaniyki pwanehu kinna kili king pwi. ");
INSERT INTO nss_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Pwen Yosep ipwai iya kili hu ndramat ipa, <<Mahapo yo kunsowani pwan tawawu masih. Pe wawu ara kansarayah ndramat para poya mbulya king o mwaihei. Iye ara mbuwa youyou tawawu; akawiriy kaya pe akayahasiy kiya pinge wawu. ");
INSERT INTO nss_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pe kapa anandrinai kiro piyang kiman, pwen wawu kawiri piyang hasai kiro nondriya piyang mayimisai pe akaikiy kiya kili king. Pe piyang mahaasai iro ndron ara ata wawu para akahas paiwe yi, pe para sohoya wawu pe noru wawu hu.>> ");
INSERT INTO nss_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Pwen hu ndramat hupwai hupa, <<Yapane yowu, wou ara asopwat yowu hiyan iya, pe mahapo yowu masih topo hiyan o. Kapa welem kiso towu, pwen hiyan para yowu karayah ndramat para poya mbulya king.>> ");
INSERT INTO nss_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Pwen Yosep iyki pwandrendrehe handra pwokeyan, iya kili hu ndramat para Yisip pe pwandrendrehe ara, ara ita ipoo isa mannen mahapo. Pwandrendrehe ara ipwai tehe hu kawiri piyang hasai kiro nondriya piyang mayimisai pe hu kaikiy kiya kili king. Hapeko pwanehu pris opu ara king kinwiriy pwi. ");
INSERT INTO nss_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Pe noru Yisrayel hu ara humpwan Yisip iro nondriya kol Kosen, pe huwiri pwan iho ariya. Pe hupo noruhu ara soyo-soyon iya pe ndromwoyahu ara iya hitun iya. ");
INSERT INTO nss_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Pe Yakop impwan Yisip hayou songui pe andrtoyoh (17), pe hayou tan masih iyawule ara irayah sangat haangui pe andrtoyoh (147). ");
INSERT INTO nss_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yiy ihingorowei tehe pakeh nakimat, pwen pe iyoh Yosep isa kili yiy. Pe ipwai iyatan ipa, <<Kapa welem kiso to ndrokonan, kiya, aiki nimam kiya pahandra mbupo pe apwatisingiy ndrokonan kisa kili yo tehe andre ambusi hiyan iya kisa kili yo. Mbuna aroni yo kuro Yisip. ");
INSERT INTO nss_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Pe kapa kumat kasura tomo hu kanmat, pwen awiri nombuwe kiya mawen kol Yisip pe aroni yo kiyapolo tumbu hu.>> Pe Yosep isomwi yiy ipa, <<Andre kumbusiy tehe anpwai.>> ");
INSERT INTO nss_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Pe Yakop ipwai paiwe ipa, <<Wou arandranga paingan tehe andre ambusiy ndrokonan tehe kunpwai.>> Pwen Yosep irandranga paingan, pe Yakop itukuruhu pe payan iya pwan ndrita yokyok. ");
INSERT INTO nss_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Iyamulan hape hu nese ndrainga Yosep hupa, <<Tamam ara imwa.>> Pwen Yosep iwiri norun hilu malmou kamai ara, Manasseh hilu Eprayim, hilya sura yiy pe huya nime Yakop. ");
INSERT INTO nss_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Hu ndramat hupwai iyata Yakop hupa, <<Norum Yosep ara kinsa pwen para kisanime wou.>> Pe Yakop ipwoke kopu, itine, pe impwan yokyok para kinime Yosep. ");
INSERT INTO nss_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakop ipwai iyata Yosep ipa, <<Ngindrai Pwokeyan Masih ara isarayah isa kili yo iro kol Lus ita nondriya kol namandran Kenaan. Pe yiy itoholi yo ");
INSERT INTO nss_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","pe ipwai sato ipa, <Yo andre kuiki norum hu karayah soyon, pe ndromweya ndraye norum hu ara andre kisahon soyo-soyon iya. Pe andre kuiki pwan iye kiya kili ndrayem hu pe andre kiro pwanehu lang masih.> ");
INSERT INTO nss_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Mahapo norum malmou mepo hilsarayah iro Yisip makunsa mapu, ara andre hilu karayah tehe noru imwonen; Eprayim pe Manasseh ara hilu karayah tehe noru imwonen, mwensen tehe noru hilu Rupen pe Simeyon. ");
INSERT INTO nss_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Hapeko hu sehe mbunah nakasarayah kamulan kiro kili Eprayim hilu Manasseh ara norum hu imwonen. Kiya lang para nakaramburungi pwan kiya kili hu hapat-hapat, pwen andre hu mbunah hunakasarayah mulan ara, andre hu koro pahandra Eprayim hilu Manasseh, hilu nalihilu imwonen. ");
INSERT INTO nss_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yo upowong iye, paratesah, koyu isikirani tinam, Rahel. Yowu tali kol Pattan Aram pe yowu mui nakasa Kenaan, pe yowu ho ndron sai pe yiy imat iho mwanan hape ko kili kol Eprat. Pwen pe uroni yiy iro ngilse sai nakiya Eprat.>> (Eprat ara ngala Petlehem mamu.) ");
INSERT INTO nss_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Pwen Yisrayel inime noru Yosep malmou, pe yiy isikei ipa, <<Hilu wihou ara noru hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Pe Yosep ipwai iyata taman ipa, <<Ariya ara noru malmou mepo usa uropo Yisip, pe YAPAN ihingini yo iya aliy.>> Pwen Yisrayel ipa, <<Awiri hilu kasa kili yo para kutoholi hilu.>> ");
INSERT INTO nss_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yisrayel ara kinna parangoloh pwen, pe maran tehe pakeh nakiyoh, pe kinlahiy para kinimnim hiyan pwi. Pwen pe Yosep iluwi norun hilu, hilsa pakeh kili taman pe Yakop indrohosi hilu pe irahunghung iya ta hilu. ");
INSERT INTO nss_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Pe Yisrayel ipwai iyata Yosep ipa, <<Koluw yo upa ndre kunlahiy para kunime wou paiwe pwi. Hapeko mwakan Ngindrai imbusiy pe mahapo yo unime wou pe iyapolo norum hilu yi.>> ");
INSERT INTO nss_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Pwen Yosep iluwi hilu mbunah malmou hilsa mawen ngondroka Yisrayel, pe yiy iyki payan itukuruhu iya pwan. ");
INSERT INTO nss_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Pe Yosep iwiri hilu malmou kene hilya kili taman. Pe iwiri norun ndrihou, Manasseh, iro niman kamou pe iyki yiy iyapwen te nima taman mot. Pe iwiri norun mulan, Eprayim, iro niman mot pe iyki yiy iyapwen te nima taman kamou. ");
INSERT INTO nss_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Hapeko Yisrayel irapaiwani niman mot pe iykiy iya paya Eprayim, pe iyki niman kamou iya paya nalin namandran Manasseh. ");
INSERT INTO nss_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Pwen iyki lomwes iya kili Yosep pe ipa, <<O Ngindrai, tumbu Apraham pe tomo Yisak ara hilu ho pahandram o, pe yo uro pahandra pwokere tam tandrohonga nano imwalahiy sato ipoo isa mannen mahapo. ");
INSERT INTO nss_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Pe wou asarayah asa kili yo tehe hamou angelou, pe apwokarani yo iya sehe melit mwomwan mepo pakisarayah kili yo. Mahapo aiki lomwes tam kiya kili noru hilu aro, pe ambusi yowe noru hilu karayah soyon kiro kol pwan. Pe andre koyu hu ndramat andre kinmayit ngolo pe ngala Yisak pe Apraham pwi.>> ");
INSERT INTO nss_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pe Yosep inime nima taman mot ara iro paya Eprayim pe kinpwes pwi; pwen pe imbultuwe nima taman mot iro paya Eprayim pe pakiykiy kiya paya Manasseh. ");
INSERT INTO nss_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Pe Yosep ipwai iyatan ipa, <<O Tomo, mbuna ambusi tehen tora. Iye ara yiy ndrihou, aiki nimam mot kiya payan.>> ");
INSERT INTO nss_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hapeko taman mbuwalin, pe ipwai iyata Yosep ipa, <<Pukene, Noru. Yo upahasani sehe melit uropo mbusiy. Upahasaniy. Pe yihu ndraye Manasseh ara, andre yihu ndramiran karayah soyon iya. Hapeko nalin mendreheh, Eprayim, ara andre kiramwaitini yiy, pe ndrayen hu andre kasarayah soyo-soyon iya pe andre hu kahon koro kol hakol-hakol.>> ");
INSERT INTO nss_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Iyki lomwes iya kili hilu lang ara, pe ipa, <<Yo Yisrayel andre kupwai mahapo, pe kiyamulan kapa hiyeh nakiyki lomwes kiyata hamou andre kipwai tehen toro: <Ngindrai andre kimbusi wou asarayah tehe Eprayim hilu Manasseh.> >> Iya lohonge tehen tora pe Yakop iyki Eprayim ara isa mu iya kili Manasseh. ");
INSERT INTO nss_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Pwen Yakop ipwai iya kili Yosep ipa, <<Yo pakeh andre kumat ara. Hapeko Ngindrai andre kiro sura wawu pe andre kiwiri wawu kamui kaya pwane tumbu wawu imwonen. ");
INSERT INTO nss_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Pe yo andre kuiki kol hakol para ngondron Sekem kisa tam, paratesah, wou ara ata mu iyata nalim hu. Pwan ara, ara kunpopahun kinna aliy iyasura semela pahun niwen to pe keye tapuiwe, pe uwiriy iyau kili hu Amor.>> ");
INSERT INTO nss_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Pwen Yakop iyoh norun hu husa kili yiy, pe ipwai iyatahu ipa, <<Akasa pakeh kili yo, pe nakutitiye ndrainga wawu kiya sehe melit andre kisarayah kili wawu kiyamulan. ");
INSERT INTO nss_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Wawu kasa pakeh pe wawu kahilingiy; noru Yakop hu kamai; Akahilingi tama wawu, Yisrayel. ");
INSERT INTO nss_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rupen wou ara noru ndrohan, Uiki wou ara tandrohonga manoru wihou to; pe arakinima pwoke ato. Ngalam ara pwokeyan iya pe iyera hin iya. ");
INSERT INTO nss_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pakut tam ara tehe non irah pwokeyan iya, pe kinlahi hamou para kisingoriy pwi, hapeko wou andre anto yokum tehe ndrohan pwi yoh. Paratesah, amatin iyasura nambuyu tamam, pe aiki masirai isa kili yo. Kultuw anmbusi ara mwomwan masih. ");
INSERT INTO nss_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyon pe Lepi ara hilu nali hilu. Semela hilu ara semela pahun, hilu wiriy pe hilu pongengei iyataya hu ndramat. ");
INSERT INTO nss_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yo kunpwes para hilu mburi lohonga hilu pwi, pe kunlahiy para kuya sura hilu para hilu tawulani lohonga hilu iyawule pwi; Paratesah, ndrina hilu ngara kilokuh, pe ngara hilu katingundru hu ndramat. Pe ngara hilu katumbuwe ndrika hu mbulmwakau kiya lohongai ta hilu ko. ");
INSERT INTO nss_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ndrina lokuh ta hilu ara andre kipwalngani hilu. Pe takokowai ta hilu ara andre kiyki ndriyang o kimui kiya kili hilu. Andre kurasumbuwani ndraye hilu kaya nondriya Yakop, pe andre hu kamasumbuwe kaya nondriya Yisrayel. ");
INSERT INTO nss_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yutah, nalim hu ara andre hu kasomwani wou, pe andre nimam kindrek koyu hu ndramat mepo humwisnani wou, Noru tamam hu kamai, ara andre hu katukuruhu kisatam. ");
INSERT INTO nss_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yutah ara kaipisam tehe hamou noru layon, Ngara kira hu yohou, pe kiyan, pe ngara kimui kisa, pe sangin kipwoke; Ngara kiwayis pe ngara kimemere, pe hamou ndramat kinoho tandroindroi kiya mbulmaram pwi. ");
INSERT INTO nss_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nes mepo irakinima pwoke ta king ara, ara kinlahi para kiya mawen kili Yutah pwi, pe yiy andre kiro king lang masih. Pe andre kiro kipoo kiya manne mbukena nes ara kisa. Pe hu ndramat para kol masih andre koro hilingi yiy opu. ");
INSERT INTO nss_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Hu para mwisi wain tan ara soyon iya. Pwen pe pakiwasi tongkiy tan, ara ngara kiwasiy kiya mwisi ndrandra wain mepo hiyan masih. Pe yiy andre kirihi hu mbuwa wain tan, pe kipisai, pe andre kisungani koyau tan kiya aliy. ");
INSERT INTO nss_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Peke maran malwoh ara ilam tehe pekemara mbusiy, pe iramwaitini wain. Pe yahan ara pallen iya, iramwaitini sus. ");
INSERT INTO nss_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Pe Sepulun ara andre kiye pakeh poho leng, pe pohomara ndras kayou tan, ara andre hu ndroi namandran hu kasa pe hu kohoraipit aliy. Pe ndringa pwanen ara andre kiyapwen te kol Siton. ");
INSERT INTO nss_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Yissakar ara yiy pwokeyan iya tehe hamou tongkiy, ngara kiye matin mwalinga ndrop malhat. ");
INSERT INTO nss_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Pe inime ndrohonoku ngohongoh tan ara hiyan iya, pe pwanen ara mwayih masih, pwen andre kiwayani yiy kiya mbulen namandran pe nopwaran. Pe kamulan andre kirayah ndramat para kipo mbulen o mwaihei pwokeyan pe ngandrahan. ");
INSERT INTO nss_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Tan ara ndramat para tamwaniye kiro mwalinga ndramiran hu, tehe wum para tamwaniye tahu Yisrayel. ");
INSERT INTO nss_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Pe Tan ara tehe hamou mwat para ngilse sai, tehe hamou yawiy para pwaki sai mendreheh. Ngara kitani ngondro ndrika hu hos. Pe andre ndramira hos ara andre kipwang te ndruwan. ");
INSERT INTO nss_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","YAPAN, yo urupo longe para wou asopwat yo. ");
INSERT INTO nss_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kat ara andre hu ndramat para pahana hu karayiy, hapeko andre kipopahun kimui kiya kili hu paiwe, pe andre hu kawop kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser ara anandrinai tam andre kirayah mwayih iya, Pe andre apo anandrinai handra-handra hiyan tehe ana hu king. ");
INSERT INTO nss_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptali kaipisan ara tehe hamou meme puyap pihin pe andre kiro rakohoyou kiya lohongai tan o. Pe ngara kikun norun hu ara lahayahu iya. ");
INSERT INTO nss_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosep ara irayah hiyan iya tehe hakou kei hira ndran ndrikou sih. Mbuwan ara ngara kirayah soyon iya. Pe ndrandran ara husinot iya naiwen, iyah, pe iroh iramburuhi kou. ");
INSERT INTO nss_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Pe hu ndramat para pahun iya tapuiwe ara hupopahun iya kili yiy, pe humbusi mwomwan iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Hapeko kei tapuiwe ta Yosep ara niman kinhitan aliy pwi, pe ipwotisingiy iro nokun o, paratesah, pwoke namandran ta Ngindrai ta Yakop ara iro pe iyki pwoke iyatan. Ngindrai ara tehe Ndramat para pwokere yiy, pe tehe Pat sih para lohowan. ");
INSERT INTO nss_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Paratesah, Ngindrai ata tamam ara yiy pwokeyan iya pe ngara kisopwat wou. Pe yiy opu ngara kitoholi wou pe kiyki lomwes para paingan, pe lomwes para mbulu pwan, pe lomwes para hu kapo hu mbunah kaya soyon iya. ");
INSERT INTO nss_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Lomwes ta tamam ara mambuniyan iya, tehe pahayi, pe iramwaitini lomwes para piyang pe yangiy para koluw. Yosep, melit masih aro andre hu karayah koro kili wou, pe wou ara ansarayah yapane nalim hu masih. ");
INSERT INTO nss_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Pe Penyamin ara kaipisan tehe mwiy hamou puyap mundruwan soyon para yangiy. Ndroulang masih ngara kiyan hu yohou mepo ngara kitingundrun, Pe ipiyah ngara kitaingani hu yohou mepo iyapo.>> ");
INSERT INTO nss_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Aro ara hu poho payumwa wum hawum-hawum tahu Yisrayel songui pe luwum. Pe aro ara nongan mepo tamahu itoholi hu iya aliy, pe iyki lomwes tahu iwene kaipisa norun hu hamou-hamou imwonen. ");
INSERT INTO nss_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Pwen Yakop itoholi norun hu ihipwen pe ipwai iyatahu ipa, <<Yo ara pakeh nakumat kuyasura tumbu hu. Pe akaroni yo kuya ngat mepo kansowaniy pwen ita pwan ta Epron mamu, yiy ndramira Hit. ");
INSERT INTO nss_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ngat ara, iro pwan hape mepo Apraham kinsowaniy pwen iyapolo ngat para tonton iro kili Epron. Pe pwan ariya ara ngalan Makpelah, ita ngilse Mamre nondriya kol Kenaan. ");
INSERT INTO nss_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ngat ara hu kantoni Apraham pe nambuyun Sarah ita aliy, iyasura Yisak hilu Repekah. Pe Leyah ara uroni yiy ita aliy yi. ");
INSERT INTO nss_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Pwan mepo ngat ita aliy ara kansowaniy pwen iro kili hamou ndramira Hit.>> ");
INSERT INTO nss_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pwen Yakop itiyani ndrainga norun hu ihipwen, pe isoli ndrikan iya nokun, pe imat iyasura tumbun hu. ");
INSERT INTO nss_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Pwen Yosep inime taman imat, pe iyah iya ndritan, irang, pe irahunghung iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Iyamulan, Yosep iyapwai iyatahu ndramiran para tamwaniye nombuwe ndramat para hu kaiki marasin kiya nombuwe taman, Yisrayel. Marasin ara, ara para kimbusi nombuwe taman andre kinpwala pwi. Pe hu ndramat ara humangsaniy tehe Yosep ipwai. ");
INSERT INTO nss_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Pe huroiki marasin ara ipoo iya lang mahaangui (40), paratesah, mbulen para yukuya marasin ara ngara kiwiri lang mahaangui imwonen. Pe hu ndramat para Yisip ara huro rangsi tama Yosep ipoo lang manandrtingui (70). ");
INSERT INTO nss_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Pwen lenge koisirai ara isayau, pe Yosep iyapwai iyatahu ndramat huro mu iya pohombulen ta king ipa, <<Yo unamiliy para wawu kayapwai kiya kili king toro: ");
INSERT INTO nss_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","<Tomo kinmat mapu, pe ipwatisingi nongnan pwokeyan isato ipa, <<Kapa kumat andre kakuni nombuwe pe kaya roni yo kuya ngare imwonen, mepo kunmbusiy pwen ita pwan para Kenaan.>> Pwen pe kapa welem kiso to, nakuya roni tomo; kihipwen, kamulan andre kumui.> >> ");
INSERT INTO nss_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pwen king isomwi nongna Yosep pe ipwai iyatan ipa, <<Ahalingi nongna tamam tehe kinpwatisingiy kinsatam; akuni nombuwen pe akaya roniy kiya ngat ita kol Kenaan tehe kinpwai.>> ");
INSERT INTO nss_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Pwen hu ndramat huya mu iya poho mbulen ta king, pe hu ndramat namandran para poya mbulya king, iyapolo hu poh para kol Yisip, ara hu masih hurikai yasura Yosep para kayaroni taman. ");
INSERT INTO nss_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Pe nalin hu pe yowe taman hu masih ara huyasura yiy. Hapeko hu mbunah mbusikau iyapolo hu sipsip, meme pe mbulmwakau ara hurondron kol Kosen. ");
INSERT INTO nss_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Hu ndramat ngara hukoro karis pe hu ndramat ngara hu kampwan ndrita hos ara huya yi. Hu ndramat soyo-soyon iya ara huya. ");
INSERT INTO nss_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pwen huyarayah iya kol Atat, haroh iyapwen te kup para Ndran Yortan. Hape ariya ara ndrohonoku yihiya pwisi mbuwa youyou. Pwen hu ndramat ara huye rang namandran pe huye rang turut. Pe Yosep ilohongani ping manandrtoyoh iro ariya para koisirai ta taman. ");
INSERT INTO nss_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Pwen pe hu ndramira Kenaan ara hunime hu Yisip huro rang ndrohonoku mangseya wit ita kol Atat, pe hupa toro: <<Hu Yisip ara hutora mbultere pe huyera tang turut iya.>> Pwen ndroiyin ara pe hupohowe ngala kol hape ara iya Apel-Misrayim. ");
INSERT INTO nss_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Pwen noru Yakop hu ara huhilingi nongna tamahu pe humbusiy tehe kinpwai kinnatahu. ");
INSERT INTO nss_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Pe hukuni nombuwen iya Kenaan, pe huroni yiy iya ngat ita Makpelah pakeh Mamre. Pwan ara, ara ndrohonoku tonton mepo Apraham kinsowaniy pwen kili ndramira Hit hamou ngalan Epron. ");
INSERT INTO nss_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pwen merei ta taman ihipwen, pe Yosep imui iya Yisip iyasura nalin hu pe hu ndramat masih mepo huya sura yiy huya tonton ta taman. ");
INSERT INTO nss_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Pe nali Yosep hu ara hunimei tehe tamahu kinmat pe hupwai hupa, <<Tehen tapeh; matisan Yosep kipo soiwi mwomwan mepo tumbusiy iya kili yiy ara kimui kisa kili tou.>> ");
INSERT INTO nss_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Pwen hupwannos nongan iya kili Yosep hupa, <<Koluw tomorou kinmat mapu pe iyki nongan sahin isa kili yowu. ");
INSERT INTO nss_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Pe yiy ipwai isatowu para kaiki nongan iye kisa kili wou: <Yosep, upwai satam para atali hu pakut pe kultuw mwomwan namandran mepo yihu mbusiy isa kili wou.> Mahapo yowu ndramira Ngindrai ta tama worou, ara yowu sikei para atali hu pakut mwomwan mepo yowu kanmbusiy kinsa kili wou.>> Pe Yosep ihilingi nongna nalin hu pe iyerang o. ");
INSERT INTO nss_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Pwen iyamulan nalin hu imwonen huya, pe hulah ya pwan mbulmaran. Pe hupwai iyatan hupa, <<Yowu ara hu ndramat para poya mbulyam o mwaihei.>> ");
INSERT INTO nss_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Hapeko Yosep ipwai iyata nalin hu ipa, <<Wawu mbuna akanoh. Yo ara kunwiri noku Ngindrai pwi yoh. ");
INSERT INTO nss_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wawu mburi lohongai mamu para pakarawani yo. Hapeko Ngindrai isulyani lohongai mwomwan ara isarayah hiyan para kisopwat hu ndramat masih. Wawu kannimei pwen sehe mbulen kinmbusiy. ");
INSERT INTO nss_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pwen wawu mbuna akanoh. Yo andre kuponokulani wawu kiyasura noru wawu hu.>> Pwen Yosep iyki nongan para koisirai ara iya kili nalin hu, pe imbusi ndriyahu ara iwayis. ");
INSERT INTO nss_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Pwen Yosep irosura yowe taman hu huro Yisip, pe hayou tan masih iyaharong ara isarayah sangat pe songui (110). ");
INSERT INTO nss_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Pwen Yosep inime salsalin hu–yihu tumbu Eprayim. Pe hu noru Makir ara, ara huwiri hu mamalaman o, pe huiki humimpwan mbupan. Makir ara noru Manasseh kamai. ");
INSERT INTO nss_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Pwen Yosep ipwai iyata nalin hu ipa, <<Pakeh nakumat, hapeko YAPAN andre kiponokulani wawu kamulan pe andre kiwiri wawu kaya mawen kol iye. Pe andre kiwiri wawu kaya pwan mepo koluw kinpwatisingiy pwokeyan kinna kili Apraham, Yisak, pe Yakop.>> ");
INSERT INTO nss_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Pwen Yosep ipwai iya kili hu noru Yisrayel para hu karandranga paingan, ipa, <<Yo upahasaniy ndrokonan-ndrokonan tehe Ngindrai ara andre kisopwat wawu kamulan; pwen akawiri ndruwi kiyasura wawu pe wawu kaya mawen kol iye.>> Yosep ipwai pe nalin hu ara hurandranga paingan iya nongan tehe ipwai. ");
INSERT INTO nss_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosep imat, pe iro tandrohongan ara hayou tan ara sangat pe songui (110). Pwen huiki marasin iya nombuwen, para nombuwen andre kinpwala pwi. Pe huiki nombuwen iyera kokou pe iro Yisip. ");
INSERT INTO nss_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aro, ara ndromwoya ndraye Yesu Mesayah. Yiy, ara iyau ndraye Tepit, pe Tepit, ara iyau ndraye Apraham. ");
INSERT INTO nss_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apraham, ara tama Yisak, pe Yisak, ara tama Yakop, pe Yakop, ara tama Yutah, pe nalin hu. ");
INSERT INTO nss_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pe Yutah, ara tama Peres hilu Serah, pe tina hilu, ara Tamar. Pe Peres, ara tama Hesron, pe Hesron ara tama Ram. ");
INSERT INTO nss_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Pe Ram, ara tama Amminatap, pe Amminatap, ara tama Nahson, pe Nahson, ara tama Salmon, ");
INSERT INTO nss_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","pe Salmon, ara tama Powas, mepo tinan, ara Rahap. Pe Powas, ara tama Opet, mepo tinan ara Rut. Pe Opet, ara tama Yessi, ");
INSERT INTO nss_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","pe Yessi, ara tama King Tepit. Pe Tepit, ara tama Solomon, pe tina Solomon, ara yiy mepo nambuyu Uriyah mamu. ");
INSERT INTO nss_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, ara tama Rehopowam, pe Rehopowam, ara tama Apiyah, pe Apiyah, ara tama Asa. ");
INSERT INTO nss_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Pe Asa, ara tama Yehosapat, pe Yehosapat, ara tama Yehoram, pe Yehoram, ara tama Ussayah, ");
INSERT INTO nss_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","pe Ussayah, ara tama Yotam, pe Yotam, ara tama Ahas, pe Ahas ara tama Hesekayah, ");
INSERT INTO nss_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","pe Hesekayah, ara tama Manasseh, pe Manasseh, ara tama Amon, pe Amon, ara tama Yosayah. ");
INSERT INTO nss_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Pe Yosayah, ara tama Yekoniyah iyapolo nalin hu. Pe tandrohongan ara, yihu para Papilon, ara huwiri hu Yisrayel huya mawen kolo hu pe huya huro pahandra hu Papilon. ");
INSERT INTO nss_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pe iyamulan para huya huro pahandra hu para Papilon: Yekoniyah, ara tama Seyaltiyel, pe Seyaltiyel, ara tama Seruppapel, ");
INSERT INTO nss_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","pe Seruppapel, ara tama Apiyut, pe Apiyut, ara tama Eliyakim, pe Eliyakim, ara tama Asor, ");
INSERT INTO nss_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","pe Asor, ara tama Satok, pe Satok, ara tama Akim, pe Akim, ara tama Eliyut, ");
INSERT INTO nss_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","pe Eliyut, ara tama Eleyasar, pe Eleyasar, ara tama Mattan, pe Mattan, ara tama Yakop, ");
INSERT INTO nss_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","pe Yakop, ara tama Yosep. Pe Yosep, ara nambuyu Mariya mepo imwalahiy ta Yesu, mepo hupohowe yiy Mesayah. ");
INSERT INTO nss_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pwen pe ndromwoya ndraye Apraham hu iya matne King Tepit, ara songui pe haamou. Pe ndromwoya ndraye Tepit hu iro kili yiy pe iya matne yihu Yisrayel huya huro pahandra hu para Papilon, ara songui pe haamou. Pe ndromwoya ndraye hu mepo huya huro pahandra hu para Papilon isa matne Mesayah, ara songui pe haamou i. ");
INSERT INTO nss_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iye ara titiye ta Mariya imwalahiy ta Yesu Mesayah. Pe irayah toro: tina Yesu, Mariya, ara hu kansokomburani yiy pwen para kiwiri Yosep. Hapeko hilu kanna wule mapu, pe hu ndramat husa yirowei tehe Mariya mapundriyan pwen imin. Pe Mariya mapundriyan, ara iyau pwoke ta Mwoiwan Haiyan. ");
INSERT INTO nss_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pe Yosep, ara ndramat hamou imwonen, pe mbuwalin para kipwaingani nambuyun, pe Mariya kiwiri masirai kiya aliy kiro mbulmara hu ndramat. Pwen ilohonganiy para kitali Mariya nokule ko. ");
INSERT INTO nss_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pwen Yosep iro lohonge ndron iya aliy, pe angelou hamou ata Yapan isarayah isa kili yiy iho nondriya nihinih, pe ipa, <<Yosep, noru Tepit, wou mbuna ahandrundru para awiri Mariya kiya wum tehe nambuyum. Ahalingiy, mbunah ita ndriyan, ara Mwoiwan Haiyan iykiy. ");
INSERT INTO nss_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pe yiy andre kimwalahiy ta mbunah kamai hamou, pe andre apohowe ngalan kiya Yesu, paratesah, yiy andre kisopwat ndramiran hu para hu kasa mawen hu pakut mwomwan tahu.>> ");
INSERT INTO nss_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Melit masih aro irayah mannan tehe Yapan kinpwai pwen kinyau kili poropet toro: ");
INSERT INTO nss_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Ahalingiy, pihindrahin hamou mepo kinna sura kamai mapu, ara andre kimwalahiy kiyata mbunah kamai hamou, pe andre kapohowe ngalan kiya Immanuwel.>> Ndroiyi ngalan Immanuwel, ara ipa toro: <<Ngindrai ara iripo sura tou.>> ");
INSERT INTO nss_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pwen Yosep isa poyoi, pe imbusi tesah mepo angelou ta Yapan kinpwandrandrahaniy kinna kili yiy. Pe iwiri Mariya iya seu tehe nambuyun. ");
INSERT INTO nss_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hapeko Yosep, ara kinmatin kinna sura yiy pwi, ipoo imwalahiy ta norun kamai. Pe Yosep ipohowe ngalan, ara Yesu. ");
INSERT INTO nss_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pwen pe Mariya ara imwalahiy ta Yesu iro kol ngawan Petlehem, ita nondriya kol namandran hape Yutiya. Pe iro mwonen Herot iro king, hu ndramat hayah lohongai waison iro kili hu, ara huyau te kup, pe husa Yerusalem. ");
INSERT INTO nss_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pwen husok, hupa, <<King tahu Yutah mepo tinan kinmwalahiy kinnatan ara, ara ita aleheh? Yowu nime piriy tan iho kup, pe yowu sa ara para katotohun kiya kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pe iro mwonen king Herot ihilong nongan aro, pwen lohongan ara ikairut, iyapolo yihu para Yerusalem masih i. ");
INSERT INTO nss_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pwen iyoh hu pris huhohin ta hu pris masih, iyapolo hu namandran para hinuwani nongan para pwahanou, ara husa harong. Pe isok hu para hape aleheh tina Mesayah kinmwalahiy kinna tan. ");
INSERT INTO nss_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pwen husomwi yiy hupa, <<Tinan imwalahiy iyatan ita Petlehem nondriya kol namandran hape Yutiya. Paratesah, iye ara tesah poropet kintatuluwiy pwen ipa: ");
INSERT INTO nss_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<Pe wawu ndramira Petlehem, tora pwan para Yutiyah, ara wawu mbuna akapa ndre ngala wawu pwi ita mwalinga hu pohon para Yutiyah, paratesah, andre pohon hamou kiyau kili wawu, pe yiy andre kipwokarani ndramiro hu para Yisrayel.> >> ");
INSERT INTO nss_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pwen Herot iyoh hu ndramat lohongahu waison para kup ara kokohon opu, para pakipahas kiya piriy ara isarayah sehe lang ndrokonan. ");
INSERT INTO nss_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pwen ipwandrisa hu huya kol Petlehem pe ipwai iya kili hu ipa, <<Akaya pe akaya telei nokulani mbunah ara. Pe kapa akankahi yiy, pwen akasa nese ndraingo. Pwen pe yo ara andre kuya totohun kiya kili yiy i.>> ");
INSERT INTO nss_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yihu hilingi nongna king ihipwen, pwen huyau. Pe piriy mepo hu kannimei ingas te kup, ara iye mu tahu ipoo iya kuw iho hape aleheh mepo mbunah ara iro aliy. ");
INSERT INTO nss_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pe iro mwonen hunime piriy, ara hupwes namandran iya. ");
INSERT INTO nss_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pwen husarayah husa seu, pe hunime mbunah iyapolo tinan Mariya, pe hu tukuruhu huya pwan, pe hu totohun iya kili yiy. Pe hu rehe ndropwahu pe huiki hu yukyuk tehe kolt, pe paura para kambusi kosumwan ngonohon layin kaliy, pe ndraikei mangonohon layin. ");
INSERT INTO nss_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pwen Ngindrai ipwandrandrahani hu iho nondriya nihinih, para hu mbuna kamui kaya kili Herot. Pwen pe humui huyayau sai hasai yi, pe huya kolo hu. ");
INSERT INTO nss_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pe hu ndramat lohongai waison iro kili hu ara hu kannau, pwen angelou hamou ta Yapan iyarayah iya kili Yosep iho nondriya nihinih pe ipa, <<Atine, awiri mbunah kiyapolo tinan pe akawop akaya Yisip. Pe akayen ara kipoo kuwong kisa kili wou, paratesah, Herot, ara andre kiten mbunah ara, para kitingundrun.>> ");
INSERT INTO nss_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pwen pe iho makohuping opu, Yosep ihilak o, iwiri mbunah iyasura tinan, pe huyau huya Yisip. ");
INSERT INTO nss_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pe iya iro manau aliy ipoo Herot imat. Melit aro, irayah mannan tehe Yapan kinpwai pwen kinyau kili poropet toro: <<Yo uyoh noru kamai isa mawen Yisip.>> ");
INSERT INTO nss_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pwen Herot isa yirowei tehe yihu ndramat lohongahu waison ara, ara hu kanpakarawani yiy. Pwen ndrinan ilokuh, pe ipwandrandrahani hu ndramat para katingundru hu mbunah kamai para nondriya kol ngawan Petlehem, mepo hayou tahu iho pahandra hayou maluwoh. Ndroiyi lohongai para Herot isok hu ndramat lohongahu waison iya sehe lang ndrokonan hunime piriy, ara para pakitingundru hu mbunah mepo tinahu imwalahiy tahu iho nondriya lang ara. ");
INSERT INTO nss_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pwen tesah mepo Ngindrai kinpwai pwen kinna kili poropet Yeremayah, ara kintayah mannan toro: ");
INSERT INTO nss_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Ngasa ndriyang irayah, iyasura mangaliye namandran iya ita nondriya kol ngawan Ramah. Rahel itarang turut iyata norun hu, pe mbuwalin para karambumbuni yiy, paratesah, norun hu konto pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pe iya mulan para Herot kinmat, angelou ta Yapan iyarayah iya kili Yosep iho nondriya nihinih iro Yisip, ");
INSERT INTO nss_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","pe ipwai, ipa, <<Atine, awiri mbunah kiyapolo tinan, pe akamui akaya pwene hu Yisrayel. Paratesah, hu mepo hu pakatingundru mbunah ara, ara hu kanmat.>> ");
INSERT INTO nss_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pwen pe itine, iwiri mbunah iyapolo tinan pe humui huya kol namandran iya Yisrayel. ");
INSERT INTO nss_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hapeko Yosep, ara kinhilong tehe Arkelawus, ara iwiri ndrohonoku taman Herot pe iro king iro kol Yutiya. Pwen pe inoh para kiya aliy. Hapeko angelou ipwandrandrahani yiy iho nondriya nihinih, pe iya kol namandran hape Kaliliy. ");
INSERT INTO nss_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pe iya pe ikuw iye kol ngawan Nasaret. Pwen pe sehe melit mepo hu poropet kanpwai, ara kintayah mannan toro: <<Andre hu kapohowe yiy ndramira Nasaret hamou.>> ");
INSERT INTO nss_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pe iho nondriya hu lang ara, Yohanes Ndramat Para Paptais isarayah, pe iro pohowe nongan iya kili hu ndramat iro nondriya kol ndrohoyin para kol namandran hape Yutiya. ");
INSERT INTO nss_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Pe yiy iro pwai ipa, <<Akarapaiwani ndriya wawu, paratesah, kolo king mepo andre Ngindrai kiro mu kiya aliy para kol paingan yang ara kinsa pakeh.>> ");
INSERT INTO nss_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pe Yohanes iye ara yiy mepo poropet Yisayah kinwong pwen kinna tan toro: <<Ngasa mbulukoyu hamou ita yoh iyau kol ndrohoyin ita pa, <Karamwaniyani saya Yapan, pe kasani meresayan kiro mwonen.> >> ");
INSERT INTO nss_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pe koyau ta Yohanes, ara husoruwei iyau yomu kamel, pe kondrei irakayani kundrayin, ara humangsaniy iyau kapilo mbulmwakau. Pe anandrinan ara hu kaspou pe kunan para yangiy. ");
INSERT INTO nss_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pe hu ndramat huya kili yiy ara huyau Yerusalem pe Yutiya masih, pe hu kol masih mendreheh para pakeh ndran Yortan. ");
INSERT INTO nss_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pe huya pohopoh iya hu pakut mwomwan tahu iya ngawan, pwen isumuluwani hu iya Ndran Yortan. ");
INSERT INTO nss_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hapeko iro mwonen inime hu ndramira Parisiy pe hu Satyusiy soyon husa hape aleheh mepo iro sumuluwani hu ndramat iro aliy, pwen ipwai iya kili hu, ipa, <<Wawu ndraye hu mwat mapairahu! Hiyeh kinpomwanye kinsa kili wawu, pe andre akawop kaya mawen ndrinalokuh ta Yapan mepo itapo isa? ");
INSERT INTO nss_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pe akantapaiwani ndriya wawu ndrokonan, pwen kultuwaye wawu kipwaingani kaipisa wawu tehen aliy i. ");
INSERT INTO nss_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pe wawu mbuna akahaterena wawu pe akapa, <Apraham ara tumbu yowu.> Yo upwai isa kili wawu tehe, iyau kili hu pat aripo, Ngindrai ilahiy para kimbusi hu karayah hu tumbu Apraham. ");
INSERT INTO nss_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pe semen kapereu, ara kinna pwen ita ndroiyi kei, pe hu kei masih mepo hu konhoppwai hiyan pwi, ara andre katihihu kaya pwan pe kapiyani hu kaya nondriya mwan. ");
INSERT INTO nss_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pe yo ara urupo sumuluwani wawu iya ndran, pe ipwainganiy tehe wawu kantapaiwani ndriya wawu. Hapeko ndramat yiy mepo nakisa kamulan, ara pwoke tan pwokeyan pe iho hin kili yo. Pe hatna pwelekan, ara kunlahiy para kutaliy pwi. Yiy andre kisumuluwani wawu kiya Mwoiwan Haiyan pe kiya mwan. ");
INSERT INTO nss_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pe yiy iya ndrohona ponokuleya wit, pe imbultuwe suweleya pwan tan ita niman, para kisuwali pwisi wit kiya mawen, pe andre kimbultani sangi wit tan kiya nondriya kaisowan. Hapeko pwisi wit, ara andre kitimwiy kiya mwan mepo kinoho mat pwi masih.>> ");
INSERT INTO nss_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pwen Yesu iyau Kaliliy pe iya Ndran Yortan para Yohanes kisumuluwani yiy. ");
INSERT INTO nss_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hapeko Yohanes, ara pakipa pwi kiyatan, pe ipa, <<Hiyan para wou asumuluwani yo, paratapeh pe wou apasa kili yo?>> ");
INSERT INTO nss_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hapeko Yesu isomwi yiy, ipa; <<Kirayah mahapo toro; Paratesah, imwonen masih para hu kultuw imwonen masih, ara andre karayah manan.>> Pwen Yohanes iho ndruwa nongna Yesu. ");
INSERT INTO nss_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pe kinsumuluwani Yesu kinna ndran, pwen isa paingan, pe hape pwi ko, kol paingan yang, ara ite, pe inime Mwoiwa Ngindrai isa pwan mwensen tehe nombuwe pai hamou, pe iya ndrita Yesu. ");
INSERT INTO nss_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pe ngasa mbulukoyu hamou iyau kol paingan yang isa, ipa, <<Aro, ara Noru mepo ndriyo imbuluhi yiy. Ndriyo ipwes iyatan namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pwen Mwoiwan Haiyan iluwani Yesu iya kol ndrohoyin, para Sinai kinohonou yiy. ");
INSERT INTO nss_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pe Yesu, ara iyuh anandrinai iho nondriya lang mahaangui pe ping mahaangui, pwen iyamulan imundrui. ");
INSERT INTO nss_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pe ndramat para nohonou yiy ara isa kili yiy, pe ipa, <<Kapa wou Noru Ngindrai Kamai ndrokonan, apwandrandrahani hu pat aro, pe hu kapaiwani hu para karayah ndrinanohun.>> ");
INSERT INTO nss_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hapeko Yesu isomwi yiy, ipa, <<Pwayan kinpwai pwen kinna, ara ipa toro: <Taleh ta ndramat andre kinyau anandrinai o, ara pwi, hapeko ngara kawiri taleh kiya hu nongna Ngindrai masih mepo ngara kiyau pohon.> >> ");
INSERT INTO nss_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pwen Sinai iwiri Yesu iya kol namandran haiyan, pe iyki yiy iya iro tine payandroha yumwa totohun namandran mepo paingan masih. ");
INSERT INTO nss_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pwen ipwai iya kili yiy, ipa, <<Kapa wou Noru Ngindrai Kamai ndrokonan, pwen apiyani wou aya pwan. Paratesah, pwayan kinpwai pwen toro: <Yiy andre kipwandrandrahani hu angelou tan, pe andre hu kasopwari wou kiho nima hu, pwen pe andre antuwani ndrikam kinna pat sih, ara pwi yoh.>>> ");
INSERT INTO nss_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu isomwi yiy, ipa, <<Pwayan handra yi, ara ipa toro: <Wou mbuna anohonou Yapan, Ngindrai atam.>>> ");
INSERT INTO nss_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pwen porosih i, Sinai iwiri yiy iya ngondron sih mepo paingan masih, pe ipwaingani hu kolo king mepo hu ngara koro mu para kol pwan masih iyapolo nonowahu. ");
INSERT INTO nss_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pe ipwai iya kili yiy, ipa, <<Kapa atukuruhu kiya pwan, pe atohun kisa kili yo, pwen hu melit masih kene aro, ara andre kuiki hu kasatam.>> ");
INSERT INTO nss_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pwen Yesu ipwai iya kili yiy, ipa, <<Sinai! Aya mawen kili yo! Paratesah pwayan, ara kinpwai pwen toro: <Atotohun kiya kili Yapan Ngindrai atam, pe aro pahandra yiy hamou opu.>>> ");
INSERT INTO nss_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pwen Sinai itali Yesu, pe hu angelou husa pe husopwat yiy. ");
INSERT INTO nss_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pe iro mwonen Yesu ihilong tehe yihu kaniyki Yohanes kinna nondriya kou, pwen yiy imui iya kol namandran hape Kaliliy. ");
INSERT INTO nss_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pwen itali Nasaret, pe iya pe ikuw iro kol ngawan Kapernawum, ita ngilse Ndran Makaiye Kaliliy. Kapernawum, ara ita pwene hu Sepulun pe Naptali. ");
INSERT INTO nss_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pe melit aro irayah, ara para kimbusi tesah poropet Yisayah kinpwai, ara kirayah mannan toro: ");
INSERT INTO nss_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Yihu ndramat para pwan Sepulun pe pwan Naptali, pe sai iya yau te ndras ngilse ndrokomatne Ndran Yortan, yihu ndramat ara, para kol namandran hape Kaliliy, mepo pwenehu Ndramira Lah,— ");
INSERT INTO nss_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yihu ndramat ara, mepo hutora lokuhan, ara hu kannime nganan namandran. Pe yihu mepo hutora lokuhan mepo hukowu ta Ngindrai, ara nganan kinlengani hu.>> ");
INSERT INTO nss_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pe iro mwonen lang ara iya, Yesu ara iro pohowe nongan iya kili hu ndramat, ipa toro: <<Akarapaiwani ndriya wawu, paratesah, kolo king Ngindrai mepo ngara kiro mu kiya aliy para kol paingan yang, ara kinsa pakeh.>> ");
INSERT INTO nss_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pwen porosih aro, Yesu iro tokai pwaki Ndran Makaiye Kaliliy, pe inime hilu ndramat malmou hilnali hilu; hamou, ara Simon, ngalan handra yi, ara Pita, pe nalin Antruw. Hilro piye kahu sih iya ndran makaiye, paratesah, hilu ara ndramat para poya ni. ");
INSERT INTO nss_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pwen Yesu ipwai iya kili hilu, ipa, <<Walu kasa koho ndruwo, pe andre kuhunuwani walu para alkarayah ndramat para poya ndramat.>> ");
INSERT INTO nss_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pwen indrou pwi ko, hilu tali kahu ta hilu pe hilu ho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pe Yesu iropo iya, pe inime hilu ndramat malmou hilnali hilu yi. Hilu ara NdraSepetiy malmou, Yamis pe nalin Yohanes. Hiluro nondriya ndroi hakou iyapolo tama hilu Sepetiy, pe huro soro hu kahu tahu. Pwen Yesu iyoh hilu, ");
INSERT INTO nss_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","pe hape pwi ko, hilu tali tama hilu pe ndroi, pe hilu ho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pe Yesu ara iya yau nondriya kol namandran hape Kaliliy, pe iro hinuwani hu ndramat iro hu yumwa mbultere tahu Yuta, pe iro pohowe nongan hiyan para kolo king Ngindrai mepo ngara kiro mu kiya aliy. Pe isopwoyani hu ndramat masih humwa iya hu mwamwa handra-handra, pe hu masih hiyeh humbuyei. ");
INSERT INTO nss_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pwen nola Yesu ara ingau iya kol Siriya masih, pe hu ndramat huwiri hu mepo humwa iya mwamwa handra-handra, pe hu mepo huro nondriya ngandran, pe hu mepo payit isilihihu masih, pe hu mepo melit ngara kilowayani hu, pe hu mepo mandrahu imat, ara hu masih kene husa kili Yesu pe isopwoyani hu. ");
INSERT INTO nss_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pe hu ndramat soyo-soyon iya para Kaliliy, pe para kol namandran hape Tekapolis, pe para Yerusalem, pe Yutiya, pe hu kol hora haroh para Ndran Yortan, ara huho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pwen iro mwonen Yesu inime hu ndramat soyo-soyon iya husa mbultere hu, pwen iya paingan ngondron sih, pe impwan aliy. Pe ndramiran hu husa kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pe ihinuwani hu, ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Lomwes ita kili hu mepo tanahu tehe menmenahu pwi iya melit para mwoiwahu, paratesah, kolo king Ngindrai mepo ngara kiro mu kiya aliy para kol paingan yang, ara atahu. ");
INSERT INTO nss_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lomwes ita kili hu mepo hutora mangaliye, paratesah, Ngindrai andre kirambumbuni hu. ");
INSERT INTO nss_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lomwes ita kili hu mepo huiki hu huya pwan, paratesah, andre hu kawiri kol pwan masih kiya mbukenan hu. ");
INSERT INTO nss_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lomwes ita kili hu mepo hu mundrui pe koyu hu isapak iya kultuw imwonen, paratesah, andre Ngindrai kimbusiy pe hu kahamosuhu. ");
INSERT INTO nss_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lomwes ita kili hu mepo koyuhu ngara kisikirani hu ndramat, paratesah, Ngindrai andre koyun kisikirani hu. ");
INSERT INTO nss_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lomwes ita kili hu hiyeh ndriyahu howen, paratesah, andre yihu kanime Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lomwes ita kili hu mepo hu ngara karamwanye mwalinga hu ndramat para ndriya wayis kirayah, paratesah, Ngindrai andre kiyoh hu norunhu. ");
INSERT INTO nss_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lomwes ita kili hu mepo humbusi kultuw imwonen pe hu ndramat ngara karandroyani hu kiya aliy, paratesah, kolo king ngara kiro mu kiya aliy para kol paingan yang, ara atahu. ");
INSERT INTO nss_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Lomwes ita kili wawu hiyeh wawu topo kili yo, pe, tunan ara ko, pwen hu ndramat ngara kapwasimiri wawu, pe karandroyani wawu, pe karasusut hu nongan pwasoyou handra-handra pwassin kisa kili wawu. ");
INSERT INTO nss_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Akapwes, pe pwesai ara kiro manau, paratesah, kenne wawu namandran iya, ara ita kol paingan yang. Paratesah, yihu kantandroyani hu poropet huho mu kili wawu tehen aliy i. ");
INSERT INTO nss_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wawu, ara tehe ndras para kanyai iripo kol pwan. Hapeko kapa ndras kankanan kiya pwi, pwen tehen tapeh pe andre kanan kimui paiwe? Ndras tehen tora, ara mbulyan pwi, andre hu ndramat karahaliy kiya ngawan, pe andre hu kangastoro kiya ndritan. ");
INSERT INTO nss_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wawu, ara tehe ngana kol pwan. Akalohonganiy, wawu, ara tehe kol hakol namandran ita ndrita ngondron sih, mepo kinlahiy para kikohon pwi. ");
INSERT INTO nss_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pe hu ndramat konho tolmwani paisui pe kaikiy kiro pahandra pwelekei, ara pwi, andre hu kaikiy kiro tine kakan, pe paisui ara, nganan andre kilengani hu ndramat masih tora nondriya seu. ");
INSERT INTO nss_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pwen tehen tora kopu, akapwaingani ngana wawu kilenganiy kiro mbulmara hu ndramat, pe andre hu kanime kultuw hiyan tawawu, pe hu kahari Tama wawu iyera kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Pe wawu mbuna akapa ndre yo usa, ara para kurapiyani nongan para pwahanou, pe nongan atahu poropet. Yo kunsa, ara para kurapiyani nongan para pwahanou pwi yoh, hapeko usa, ara para kumbusiy kirayah mannan. ");
INSERT INTO nss_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yo upwai ndrokonan isa kili wawu, konan kapa kol paingan yang pe kol pwan kimun, hapeko hape nongan sahin para nongan para pwahanou, ara andre kinimun pwi. Pe hape ngana nongan hu kantatuluwiy, ara andre kinna yohun pwi, kipoo hu melit masih karayah mannan. ");
INSERT INTO nss_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pe kapa ndramat hamou kindrihisani nongan hape mendreheh para nongan para pwahanou aro, pe kihinuwani hu ndramat hayah pe hu kambusiy ihisoule ko tehe imbusiy, pwen ndramat ara, ngalan andre kiya mendreheh masih kiro nondriya kolo king mepo ngara kiro mu kiya aliy para kol paingan yang. Hapeko kapa hiyeh kiro tokuyani hu nongan para pwahanou pe kiro hinuwani hu ndramat kiya aliy, andre ngalan kiyahin kiya namandran masih kiro kolo king mepo ngara kiro mu kiya aliy para kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pwen tehen tora ko upwai isa kili wawu, kapa kultuwayi wawu imwonen kintamwaitini kultuwayi hu ndramat para hinuwani nongan para pwahanou pe hu Parisiy pwi, ara andre wawu kanlahiy para akaya nondriya kolo king mepo ngara kiro mu kiya aliy para kol paingan yang pwi. ");
INSERT INTO nss_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wawu kanhilingiy tehe nongan para pwahanou kinpwai pwen kinna kili hu tumbu wawu hu koluw kinna, ipa toro: <Mbuna atingundru ndramat kimat, pe kapa hiyeh kitingundru ndramat hamou kimat, ara andre kiro tine nongan.> ");
INSERT INTO nss_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hapeko upwai isa kili wawu: kapa ndramat hamou ndrinan kilokuh kiyata nalin, yiy andre kiro tine nongan. Pe ndramat hiyeh kipwati nalin, pe kipwai, kipa, <Lohongam pwi!>, ara andre kiro tine mbulmara hu Sanhetrin. Pe ndramat hiyeh kipwai kiya kili ndramat hamou, kipa, <Wou tehe ngou!> ara pakeh nakiya nondriya kol mwomwan mepo mwan ita yat aliy. ");
INSERT INTO nss_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tehen tora ko, kapa wou nayaiki yukyuk tam kiya pere tuntun, pe alohonganiy tehe mwalinga walu nalim ita, ");
INSERT INTO nss_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pwen atali yukyuk tam kiye ndron ngilse pere tuntun, pe amui aya kili nalim pe alkaramwanye walu kimu na. Pwen amui aya pe ayaiki yukyuk tam. ");
INSERT INTO nss_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kapa ndramat hamou kirakokowai kiyapolo wou pe pakiyki wou kiya nongan, ara mawalu koho ndron sai, pwen ahaleh pe aramwanye kiyasura yiy. Matisan ndramat ara, kiyki wou kiya nima ndramat para tamwanye, pe ndramat para tamwanye kiyki wou kiya kili makundrayin, pe makundrayin kipiyani wou aya nondriya kou. ");
INSERT INTO nss_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Upwai ndrokonan isa kili wou, tehe wou andre ansa ngawan nondriya kou pwi, kipoo aiki sombule pat masih mepo hu kanpwai kinsa kili wou para aikiy. ");
INSERT INTO nss_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Wawu kanhilingiy tehe nongan para pwahanou kinpwai pwen kinna, ipa toro: <Mbuna apo pilah.> ");
INSERT INTO nss_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hapeko yo upwai isa kili wawu toro: Kapa kamai hamou kinime pihin hamou, pe lohongan inamiliy para kipo memeng kiyapolo yiy, ara kamai ara kinpo pilah pwen kinna lohongan. ");
INSERT INTO nss_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pwen pe kapa maram mot kimbusi wou pe ayos aya pakut mwomwan, ara hiyan para atangihiy, pe apiyaniy kiyau. Kapa sangim hape kitali nombuwem, ara mwomwan, hapeko kapa nombuwem masih hu kapiyaniy kiya nondriya ngat mepo mwan itayat aliy, ara mwomwan masih. ");
INSERT INTO nss_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pe kapa nimam mot kimbusi wou ayos aya pakut mwomwan, ara hiyan para asondritiy pe apiyaniy kiyau. Kapa sangim hape kitali nombuwem, ara mwomwan, hapeko kapa nombuwem masih hu kapiyaniy kiya nondriya ngat mepo mwan itayat aliy, ara mwomwan masih. ");
INSERT INTO nss_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nongan para pwahanou, kinpa toro: <Kapa sehe ndramat pakitali nambuyun kiyau, hiyan para kiratuluwi nongan para yesou kimut, pe kiykiy kiya kili nambuyun.> ");
INSERT INTO nss_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hapeko upwai isa kili wawu: sehe ndramat mepo kitali nambuyun, pe pihin tan kinpo pilah pwi, pwen ndramat ara, ara indrihisani nongan para pwahanou para yesou. Paratesah, kapa pihin tan kiya wiri kamai hamou, pwen pihin ara, ara ipo pilah. Pe kamai hiyeh kiyesou kiya kili pihin hamou i, mepo nambuyun kintali yiy, ara indrihisani nongan para pwahanou para yesou, pe ipo pilah i. ");
INSERT INTO nss_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wawu kanhilingiy tehe nongan para pwahanou kinpwai pwen kinna kili hu tumbu wawu hu koluw kinna, ipa toro yi: <Mbuna akarandrangan kiya paingan, pe kiyamulan akanto ndruwa nongna wawu pwi; hapeko akaro ndruwa tesah mepo akantandrangan pwen kinna kili Yapan.> ");
INSERT INTO nss_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hapeko upwai isa kili wawu: wawu mbuna akarandrangan; mbuna akarandrangan kiya kol paingan yang para kipwokeyani nongna wawu, paratesah, kol paingan yang, ara ndrohonoku pwanpwan ta King Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pe wawu mbuna akarandrangan kiya kol pwan para kipwokeyani nongna wawu, paratesah, kol pwan, ara ndrohonoku ndrika Ngindrai. Pe wawu mbuna akarandrangan kiya Yerusalem para kipwokeyani nongna wawu, paratesah, Yerusalem, ara kol namandran ata King Namandran Masih. ");
INSERT INTO nss_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pe wawu mbuna akarandrangan kiya paya wawu para kipwokeyani nongna wawu, paratesah, wawu kanlahiy para kambusi kompaya wawu kirayah kolou ndre lokuran, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pe kapa akasomwiy ndrokonan, pwen akasomwiy, pe akapa pwi, ara pwi. Pe tesah wawu pakapo suran kiramwaitini nongan aro, ara iyau kili Sinai. ");
INSERT INTO nss_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Wawu kanhilingiy tehe nongan para pwahanou kinpwai pwen kinna, ipa toro: <Kapa hamou kirapwasingi mara hamou, ara wawu karapwasingi maran i, pe kapa hamou kiranonoke yaha hamou, ara wawu karanonoke yahan i.> ");
INSERT INTO nss_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hapeko upwai isa kili wawu: wawu mbuna akapo soiwi mwomwan ta hu ndramat mepo humwisnani wawu. Pe kapa hiyeh kihisuli kaipam mot, pwen apaiwani haroh i kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pe kapa ndramat hamou pakiwiri wou oro tine nongan para kiwiri koiwem, ara atali ndroham kiya suran i. ");
INSERT INTO nss_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pe kapa ndramat hamou kirakekeyani wou para arakai sura yiy ndrohonga kilomita sih, ara arakai aya sura yiy kiropo kiya manau kiya ndrohonga kilomita maluwoh. ");
INSERT INTO nss_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pe kapa hiyeh kisok wou kiya melit handra, ara aikiy. Pe hiyeh pakisa popo kili wou, ara mbuna apa pwi kiyatan. ");
INSERT INTO nss_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Wawu kanhilingiy tehe nongan para pwahanou kinpwai pwen kinna, ipa toro: <Ndriyam kimbuluhi hiyeh para pakeh kili wou, pe amwisnani yoyou atam mepo imwisnani wou.> ");
INSERT INTO nss_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hapeko upwai isa kili wawu: ndriya wawu kimbuluhi hu hiyeh mepo humwisnani wawu, pe akatohun kiya kili Ngindrai, para Ngindrai kitoholi hu hiyeh mepo hu tandroyani wawu. ");
INSERT INTO nss_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pwen andre wawu karayah noru Tama wawu iyera kol paingan yang. Paratesah, yiy imbusi mwandrai tan ingas pe nganan ilengani hu ndramat hurakultuw mwomwan, pe hu ndramat hurakultuw hiyan kene; pe imbusiy pe mbulou indrut iya kili hu ndramat imwonen, pe hu ndramat kanmwonen pwi. ");
INSERT INTO nss_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pe kapa ndriya wawu kimbuluhi hu mepo ndriyahu imbuluhi wawu, pwen andre akawiri kenne wawu tapeh? Hu ndramat para poya takis, ara hu ngara kambusi kultuw tehen tora yi. ");
INSERT INTO nss_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pe kapa wawu karawulohani nali wawu hu kopu, pwen tesah wawu tora mbusiy, ara andre kiramwaitini hu hayah tapeh? Hu ndramat tanahu ta Yapan pwi, ara ngara hu kambusiy tehen aliy i, ndre? ");
INSERT INTO nss_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pwen pe wawu koro mwonen masih tehe Tama wawu iyera kol paingan yang, ara yiy imwonen masih. ");
INSERT INTO nss_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mara wawu kiro, wawu mbuna akapwaingani hu kultuwayi wawu imwonen kiya mbulmara hu ndramat para hu kanimei. Kapa wawu kambusiy tehen tora, pwen andre wawu kanwiri kenne wawu ita kili Tama wawu iyera kol paingan yang, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pwen pe kiro mwonen naiki yukyuk kiya kili hu hiyeh mepo hundroisiy, ara mbuna apwandrisa hamou kirandrah kimu, para kipwaingani tesah nambusiy, tehe hu ndramat para pwandrandraman ngara hu kambusiy kiro nondriya hu yumwa mbultere, pe hu sai para hu ndramat kasikiye hu. Upwai ndrokonan isa kili wawu, hu ndramat tehen tora, ara kennehu, hu kanwiriy topwei. ");
INSERT INTO nss_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hapeko kiro mwonen naiki yukyuk kiya kili hu hiyeh mepo hundroisiy, ara nimam kamou mbuna kipahasani tesah nimam mot ita mbusiy. ");
INSERT INTO nss_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pe tesah naikiy, ara aikiy kokohe ko. Pwen Tamam andre kinime tesah aikiy kokohe, pwen andre kiyki kennem. ");
INSERT INTO nss_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pe kiro mwonen wawu nakatohun, ara wawu mbuna akambusiy tehe hu ndramat para pwandrandraman ngara kambusiy. Paratesah, yihu namiliy para hu koro tine nondriya hu yumwa mbuletere, ndre koro tine ngilse hu payango sai, pe katohun, para hu ndramat kanime hu pe kasikiye hu. Upwai ndrokonan isa kili wawu, hu ndramat tehen tora, ara kennehu hu kanwiriy topwei. ");
INSERT INTO nss_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Hapeko kiro mwonen wou natohun, ara asong aya nondriya suwem sahin, pe awari papai, pe atohun kiya kili Tamam kokohe ko. Pwen Tamam kinime tesah ambusiy kokohe, pe andre kiyki kennem. ");
INSERT INTO nss_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pe kiro mwonen wawu nakatohun, ara wawu mbuna akapwasosohou o mwaihei, tehe hu ndramat tanahu ta Yapan pwi, paratesah, hupa ndre kapa hu kawong soyon, pwen andre Ngindrai kihilingi hu. ");
INSERT INTO nss_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pwen pe wawu mbuna akarayah tehe yihu, paratesah, mapu akansok Tama wawu, ara kinpahasani tesah wawu ndroisiy. ");
INSERT INTO nss_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pwen pe akatohun toro: Tama yowu ayera kol paingan yang, Ngalam ara haiyan. ");
INSERT INTO nss_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yowu tohun tehe kultuwayi kolo king tam mepo ngara aro mu kiya aliy kisa yelan, pe namiliwam pwokeyan kirayah mannan kiro kol pwan, kihisoule ko tehe ita kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Lang nepo ahang yowu anandrinai, anowu para lang sih tehe sih. ");
INSERT INTO nss_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pe atali hu pakut mwomwan towu, tehe yowu ngara katali hu pakut mwomwan tahu ndramat mepo hu ngara kambusi pakut mwomwan kisa kili yowu. ");
INSERT INTO nss_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pe mbuna aluwani yowu kaya nondriya nohonou, hapeko asopwat yowu kasa mawen kili Sinai. Paratesah, kolo king mepo ngara aro mu kiya aliy, pe pwoke namandran, iyapolo nonowa nganam, ara masih atam, pe andre kinto-kinto. Ndrokonan. ");
INSERT INTO nss_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Akahilingiy, kapa wawu katali pakut mwomwan tahu hiyeh mepo humbusi pakut mwomwan isa kili wawu, pwen andre Tama wawu iyera kol paingan yang, ara andre kitali hu pakut mwomwan tawawu yi. ");
INSERT INTO nss_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Hapeko kapa wawu kantali hu pakut mwomwan tahu ndramat pwi, pwen Tama wawu iyera kol paingan yang, ara andre kintali hu pakut mwomwan ta wawu pwi yi. ");
INSERT INTO nss_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kiro mwonen wawu pakayuh anandrinai, ara mbulmara wawu mbuna kilomwa, tehe hu ndramat para pwandrandraman ngara kambusiy. Yihu ngara kambusi mbulmarahu kilomwa, para kiyinganiy kiya kili hu ndramat, para hu kanimei tehe yihu, ara huro yuh anandrinai. Upwai ndrokonan isa kili wawu, kennehu, ara hu kanwiriy topwei. ");
INSERT INTO nss_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hapeko kiro mwonen wou apayuh anandrinai, ara atumwi ndraikei kiya payam, pe asingani mbulmaram. ");
INSERT INTO nss_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pwen tehen tora ko, andre anpwainganiy kinna kili hu ndramat tehe wou oro yuh anandrinai, ara pwi. Hapeko Tamam mepo anho nime yiy pwi, ara yiy hamou opu andre kipahasaniy. Pe Tamam, ara ita nime tesah ata mbusi kokohe, pwen andre kiyki kennem. ");
INSERT INTO nss_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Pe wawu mbuna akarawurani hu melit lahayan kennen namandran para kol pwan, mepo yih andre kiyni hu, pe andre hu kamwiyih kaya mwomwan masih, pe hu ndramat para pahana, ara andre hu katumbuwe papai, pe hu kaya pe hu kapahanowei. ");
INSERT INTO nss_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hapeko wawu karawurani hu melit lahayan kennen namandran para kol paingan yang, mepo selei kinwenei para kiseleyaniy pwi, pe ngara hu konho muyih pwi, pe hu ndramat para pahana hu kanwenei para katumbuwe papai, pe kaya pahanowe hu pwi. ");
INSERT INTO nss_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Paratesah, hape aleheh mepo menmena wawu mwayih ita aliy, ara ndriya wawu andre kiro aliy yi. ");
INSERT INTO nss_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mara ndramat ara tehe paisui para nombuwe ndramat. Kapa maram kiro hiyan, ara nombuwem masih andre kipep kiya nganan. ");
INSERT INTO nss_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Hapeko kapa maram kiro mwomwan, pwen andre nombuwem masih kilokuh topwei. Pe kapa nganan ita nondriyam kilokuh, pwen lokuhan ara, ara namandran iya, ita kili wou! ");
INSERT INTO nss_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ndramat hamou kinlahiy kiro pwandrendres ta hilu namandran malmou, ara pwi. Yiy andre kihimwisnani hamou pe kinamili hamou, ndre andre welen kiso kiyata hamou, pe welen kimai kiyata hamou. Wawu kanlahiy para karayah pwandrendres ta Ngindrai, pe pwandrendres para menmena kol pwan kene, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Pwen tehen tora ko, upwai isa kili wawu, lohonga wawu mbuna kimwa kiya mipwan tawawu; kiya tesah wawu andre kayan, ndre kiya tesah wawu andre kayin; ndre nombuwe wawu, kiya tesah wawu nakasuluye wawu kiya aliy. Mwoiwa wawu, ara iramwaitini anandrinai, pe nombuwe wawu, ara iramwaitini koyau, ndre? ");
INSERT INTO nss_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Akayirowe hu norukan hu hora woh yang, yihu konhohas, pe hu konhopo anandrinai pwi, pe hu konho mbultere anandrinai kinna kaisowa hu pwi yi, hapeko Tama wawu iyera kol paingan yang, ngara kihang hu anandrinai. Pe wawu ndramat, ara wawu ho hin iya, iyata hu norukan, ndre? ");
INSERT INTO nss_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hiyeh tawawu kapa lohongan kimwa, ara ilahiy para kiposura lenge mwoiwan kiya niwen hape? ");
INSERT INTO nss_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pe paratapeh lohonga wawu imwa iya koyau? Akayirowe hu nonou hu tora lek piyang tapeh. Yihu konhopo mbulen pwi, pe hu konho mangse koiwehu pwi. ");
INSERT INTO nss_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hapeko upwai isa kili wawu, tehe nowiya nosa Solomon masih lahayan iya, ara kintamwatini lahaya hu nonou iye pwi yoh. ");
INSERT INTO nss_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pwen kapa Ngindrai ngara kinowi hu ndromwindriu para piyang tehen tora, mepo topo lang nepo ko, pe kiya moh, ara andre kapiyani hu kaya nondriya mwan, pwen wawu pahasaniy ndrokonan tehe Ngindrai andre kinowi wawu kiramwaitini nowiya hu nonou ara, ndre? Wawu tana wawu tehe ara ndrokonan, konan kapa wawu tora pwotisingi lohonga wawu hape kopu. ");
INSERT INTO nss_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pe lohonga wawu mbuna kimwa, pe akapa, <Andre yowu kaini tesah?> ndre <Andre yowu kaimwi tesah?> ndre <Andre yowu kasuluye yowu kiya tesah?> ");
INSERT INTO nss_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yihu ndramat mepo hukowu ta Ngindrai, ara yihu ngara kanimanga hu melit masih tehen tora. Hapeko melit masih wawu ndroisiy, ara Tama wawu para kol paingan yang kinpahasaniy pwen. ");
INSERT INTO nss_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hapeko wawu katele kolo king Ngindrai mepo ngara kiro mu kiya aliy, pe kiyasura kultuwayin imwonen, pwen hu melit masih kene aro, ara andre kihang wawu yi. ");
INSERT INTO nss_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pwen tehen tora ko, lohonga wawu mbuna kimwa kiya tesah para moh, paratesah, lohongai para moh, ara ita lang moh. Lang sih-sih, ara ma nopwaran para aliy. ");
INSERT INTO nss_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wawu mbuna akarasusut nongan kiya kili hu ndramat, pwen pe andre Ngindrai kintasusut nongan kimui tehen aliy opu kisa kili wawu pwi. ");
INSERT INTO nss_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Paratesah, Ngindrai andre kirasusut nongan kisa kili wawu, ara andre kihisoule ko, tehe wawu ngara karasusut nongan kiya kili hu ndramat. Pe sehe nongan pwahanou ngara apiyaniy kiya kili hu ndramat, ara andre Ngindrai kipiyani nongan ara ko, kimui kisa kili wawu yi. ");
INSERT INTO nss_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Paratesah, pe ngara aro nime konu kei hape ita mara nalim hamou, pe akowu tehe kei hamwat ita maram? ");
INSERT INTO nss_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tehen tapeh apa pwai kiya kili nalim, apa, <Nakute konu kei ita maram,> hapeko akowu tehe kei hamwat ita maram mbukenam? ");
INSERT INTO nss_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wou ndramat para pwandrandraman! Wou ate kei hamwat ita maram kiyau kimu na, kihipwen, pwen andre alahiy para atuluwani nokulani konu kei ata nalim, pe atei. ");
INSERT INTO nss_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pe wawu mbuna akaiki hu memelit haiyan kiya kili hu mwiy. Pe wawu mbuna akapiyani hu sowiy lahayan tawawu, kiya kili hu puw. Kapa akambusiy tehen tora, matisan hu kangastoro ndrita hu melit ara, pe karahatuwe hu, pe andre hu kapaiwani hu, pe kawisi wawu pe karamumuruwe wawu. ");
INSERT INTO nss_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Akasok pe andre kaikiy kisata wawu, akaten pe andre akaya kahiy, akaralikiri papai pe andre papai kite kisa kili wawu. ");
INSERT INTO nss_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Paratesah, hiyeh kisok, ara andre kiwiriy, pe hiyeh kiten, ara andre kiya kahiy, pe hiyeh kiralikiri papai, ara andre papai kite kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hiyeh tawawu, kapa norun kisok ndrinanohun, andre kihang yiy pat sih? Pwi yoh. ");
INSERT INTO nss_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pe kapa kisok ni hamou, andre kihang yiy mwat hamou? Pwi yoh! ");
INSERT INTO nss_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pe kapa wawu tana wawu topwei para wawu kaiki hu yukyuk mwayih kiya kili noru wawu hu, konan wawu ndramat ngara kambusi kultuw mwomwan, pwen tehen tora ko, Tama wawu ita kol paingan yang, ara andre kihang hu yukyuk hiyan kiramwaitini hu melit hiyan ta wawu, kiya kili hu mepo hu ngara kasok yiy! ");
INSERT INTO nss_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pwen pe sehe kultuw wawu namiliy para hu ndramat kambusiy kisa kili wawu, hu kultuw tehen tora ko, ara wawu kambusiy kiya kili hu. Pe iye ara ndroiyi nongan para pwahanou, pe ndroiyi nongna hu poropet. ");
INSERT INTO nss_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Akasong akaya karam indrupep. Paratesah, karam para sai iyapwen te kol mepo hu ndramat andre kawiri ngandran kinto-kinto, ara maihan, pe sayan, ara waison; pe hu ndramat soyon, ara ngara hu kayasong aliy. ");
INSERT INTO nss_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hapeko karam para sai iyapwen te kol para taleh, ara indrupep, pe sayan ara ngandrahan; pe hu ndramat noye kopu, ngara hu kayasong aliy. ");
INSERT INTO nss_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Pe mara wawu kiro ta hu poropet pwasoyou. Yihu andre karapihiye hu tehe hu sipsip, pe kasa kili wawu; hapeko ndrokonan para aliy, nondriyahu, ara tehe hu mwiy puyap. ");
INSERT INTO nss_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wawu andre kayirowe hu, ara kiya kultuwayihu. Yihu ndramat konoho rih mbuwa ndrinai kiho porokulun, ndre konoho rih sakei kiho poropalan, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pwen tehen tora ko, kei masih hiyan, ara huppwai pe sangihu hiyan. Pe kei masih mwomwan, ara huppwai pe sangihu mwomwan. ");
INSERT INTO nss_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kei hiyan kinohoppwai pe sangin mwomwan, ara pwi. Pe kei mwomwan kinohoppwai pe sangin hiyan, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pe hu kei masih mepo hu konhoppwai hiyan pwi, ara andre katihihu pe kapiyani hu kaya nondriya mwan. ");
INSERT INTO nss_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pwen tehen tora ko, andre akayirowe hu poropet pwasoyou, ara kiyau kultuwayihu ko. ");
INSERT INTO nss_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wawu mbuna akapa ndre hu mepo hu ngara kayoh yo: <Yapan, Yapan,> ara andre hu kasong kaya kolo king mepo ngara kiro mu kiya aliy para kol paingan yang. Pwi yoh! Hapeko hu ndramat mepo ngara hu koro ndruwa namiliwa Tomo ita kol paingan yang, ara yihu kopu andre kasong kaya aliy. ");
INSERT INTO nss_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pwen kiro mwonen lenge tamwanye, hu ndramat soyon, ara andre hu kapwai, kapa toro: <Yapan, Yapan, iyau ngalam, yowu wong tehe hu poropet; pe iyau ngalam, yowu rapiyani hu payit; pe iyau ngalam, yowu mbusi hu ndraikiya pwoke soyon.> ");
INSERT INTO nss_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pwen andre kupwai ngawan kiya kili hu, kupa toro: <Yo ukowu ta wawu. Wawu ndramat para takultuw mwomwan, akaya mawen kili yo!> ");
INSERT INTO nss_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pwen tehen tora ko, hiyeh ihilingi nongno pe itokuyaniy, ara tehe ndramat mepo lohongan waison pe ipuli suwen iro ndrita pat. ");
INSERT INTO nss_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe mbulou indrut, pe ndran irah, pe nohai imum pwokeyan pe iyahawan iya seu, hapeko seu kiniwuh pwi, paratesah, isoye ngara ndruw para seu tan iya mbulun iya, pe iro ndrita pat. ");
INSERT INTO nss_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hapeko hiyeh mepo ihilingi nongno, pe kintokuyaniy pwi, ara yiy tehe ndramat mepo lohongan waison pwi, pe ipuli suwen iro ndrita kolkolai. ");
INSERT INTO nss_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe mbulou indrut, pe ndran irah, pe nohai imum iya pwokeyan pe iyahawan iya seu, pe seu iwuh pe imaloiwe masih.>> ");
INSERT INTO nss_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pe iro mwonen Yesu iwong hu nongan aro ihipwen, hu ndramat soyon mepo huro hilingi yiy, ara hulohonge ndrit iya hinonou tan. ");
INSERT INTO nss_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Paratesah, kinwong tehe ndramat hamou para hinuwani nongan para pwahanou tahu pwi, hapeko iro wong tehe ndramat mepo nongnan nopwaran. ");
INSERT INTO nss_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pwen iro mwonen Yesu itali ngondron, pe ilai isa pwan, ara hu ndramat soyo-soyon iya huho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pe ndramat hamou mwamwa kawa iro kili yiy, ara isa pe itukuruhu iro mbulmaran, pe ipa, <<Yapan, kapa welem kiso, alahiy para ambusi yo kurayah howen kiya mbulmara Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Pwen Yesu niman iyah iya, pe iyahatek iyatan, pe ipa, <<Wele iso. Arayah howen!>> Pwen hape pwi ko, mwamwa kawa mepo iro kili ndramat ara, ara itali yiy. ");
INSERT INTO nss_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pwen Yesu ipwai iya kili yiy, ipa, <<Mbuna aya nese ndrainga hamou, hapeko aya yingani wou aya kili pris, para kitimwi yukyuk mepo Mose kinpwandrandrahaniy para arayah howen kiya mbulmara Ngindrai. Pe andre kirayah tehe tiyeyam kiya kili hu pris.>> ");
INSERT INTO nss_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pe iro mwonen Yesu iya nondriya kol ngawan Kapernawum, ndram hamou mepo ihohin tahu ndram masangat, ara isa kili yiy pe isok Yesu para kisopwat yiy. ");
INSERT INTO nss_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Pe ipa, <<Yapan, ndramat para poya mbulyo ara mandran kinmat, pe iyera seu, pe ita nondriya ngandran namandran.>> ");
INSERT INTO nss_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Pe Yesu ipwai iya kili ndramat ihohin iyata hu ndram masangat ara, ipa, <<Andre kuya pe kusopwoyani yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pe ndramat ihohin tahu ndram, ara isomwiy, ipa, <<O Yapan, toimwam. Mbuna ambusi wou angandrah. Yo kunna hiyan para alahi asa nondriya suwe pwi. Hapeko hiyan para apwatisingi nongan opu, pe ndramat para poya mbulyo, andre kirayah hiyan. ");
INSERT INTO nss_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Upwai tehen toro, paratesah, yo ara ndramat hamou uta pahandra namandran hamou ihohin isato, pe hu ndram hayah topo pahandro yi. Kapa kupwai kiya kili hamou, kupa, <Aya,> pwen andre kiya; pe kapa kupwai kiya kili hamou yoro, kupa, <Asa,> pwen andre kisa. Pe kapa kupwai kiya kili ndramat para poya mbulyo, kupa, <Ambusiy iye,> pwen andre kimbusiy.>> ");
INSERT INTO nss_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pwen iro mwonen Yesu ihilingi nongan aro, ilohonge soyon, pe ipwai iya kili hu ndramat mepo huho ndruwan, ara ipa toro: <<Upwai ndrokonan isa kili wawu, kunnime ndramat hamou iripo Yisrayel mepo kinpwotisingi lohongan ndrisiyon tehe ndramat aro, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pe upwai isa kili wawu, tehe hu ndramat soyon iya andre hu kayau te kup pe rai kasa, pe andre hu kampwan ndrohonokuhu koro yon kasura Apraham, Yisak, pe Yakop koro nondriya kolo king mepo ngara kiro mu kiya aliy para kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hapeko hu ndramira kolo king mepo ngara kiro mu kiya aliy ara, ara andre kipiyani hu kayau kaya kol mawen lokuhan, mepo andre hu koro rang malihu pe koro yandrisingi koltahu.>> ");
INSERT INTO nss_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pwen Yesu ipwai iya kili ndram ihohin iyata hu ndram masangat ara, ipa, <<Ayau! Anpwotisingi lohongam pwen, pwen pe andre kirayah tehen aliy.>> Pwen iro mwonen paramwandrai ara, ndramat para poya mbulyan ara, ingoh. ");
INSERT INTO nss_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pe iro mwonen Yesu isong iya nondriya seu ta Pita, pwen inime nossu Pita iye matin yokyok pe mandran ara ingandrah. ");
INSERT INTO nss_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pwen Yesu iyki niman iyahatek iya niman opu, pe mandran mepo iro ngandrah, ara ingoh. Pwen itine pe ipo mbulyan. ");
INSERT INTO nss_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pwen kol iro piyah pe huwiri hu ndramat soyon mepo hu payit huro ndritahu, ara husa kili Yesu. Pe irasses hu payit huyau iya nongan handra kopu, pe isopwoyani hu ndramat masih mepo humwa. ");
INSERT INTO nss_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tehen tora ko, nongan mepo poropet Yisayah kinpwai, ara kintayah mannan: <<Yiy isoli hu mwamwa torou, pe ikuni hu nopwaran torou.>> ");
INSERT INTO nss_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pe iro mwonen Yesu inime hu ndramat soyon iya husa rakayani yiy, pwen ipwatisingiy iya kili ndramiran hu para hu kasingondriti ndran makaiye kaya haroh. ");
INSERT INTO nss_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pwen ndramat hamou para hinuwani nongan para pwahanou, ara isa kili yiy, pe ipa, <<Ndramat para hinonou, hape aleheh naya aliy, ara andre kuho ndruwam.>> ");
INSERT INTO nss_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Pe Yesu isomwi yiy, ipa, <<Yihu mwiy puyap, ara mangarehu, pe hu norukan para wohowoh, ara mayumwahu. Hapeko Noru Ndramat, ndrohonokun para matiliu, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pe ndramiran hamou i, ara ipwai iya kili yiy, ipa, <<Yapan, atali yo kuya roni tomo kimu na.>> ");
INSERT INTO nss_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hapeko Yesu ipwai iya kili yiy, ipa, <<Oho ndruwo, hu ndramat para kimat, ara hu koro roni ndramirahu mbukenahu mepo humat.>> ");
INSERT INTO nss_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pwen Yesu ihis iya nondriya ndroi hakou pe ndramiran hu huho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pwen indrou pwi ko, pe nohai namandran imum iya ndrita ndran makaiye, pwen pe nowei iro talon iya nondriya ndroi. Hapeko Yesu, ara iye matin. ");
INSERT INTO nss_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pe ndramiran hu huya kili yiy pe huhungini yiy, pe hupa, <<Yapan! Asopwat tou! Worou nakayuh ara!>> ");
INSERT INTO nss_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pe Yesu isomwi hu, ipa, <<Lohonga wawu ndrisiyon, ara hape kopu. Paratapeh pe wawu tora noh turuwe wawu?>> Pwen itine, pe ipomate nohai pe nowei, pe hilmaito. ");
INSERT INTO nss_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pwen ndramiran hu, ara lohongahu indrap pe husok, hupa, <<Aripo sehe ndramat ndrokonan? Pwen pe nohai pe nowei hilu hilingi nongnan i!>> ");
INSERT INTO nss_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pwen Yesu iyarayah iya haroh para ndran makaiye, pakeh pwene hu Katara. Pe hilu ndramat malmou mepo payit iro ndrita hilu, ara hilyau hu ngare hu ndramat kanmat pe hilsa pohonani yiy. Pe hilu ngara karambumbungas, pe hamou kinhopo kinna yau sai ara, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pwen hilpalngai, hilpa, <<Noru Ngindrai Kamai, wou apapo tesah kisa kili yowu yeh? Paratapeh pe asa iye? Asa para naiki ngandran kisa kili yowu, ma lang kintayah mapu, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pe lang ara, hu puw hayoi soyon iya ara huro mwanan hape kili hu, pe huro namnam. ");
INSERT INTO nss_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pe hu payit hurakamam iya kili Yesu, hupa, <<Kapa narasses yowu kayau, ara apwandrisa yowu kaya ndrita hu puw.>> ");
INSERT INTO nss_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pe Yesu isomwi hu, ipa, <<Akaya!>> Pwen o, hu payit ara, ara hutali hilu pe husa mawen pe huya ndritahu puw. Pwen hu puw hayoi mwanye ara, ara huwop turut hurapak mbusupahayi huya pwan, pe huya nondriya ndran makaiye pe huya mat. ");
INSERT INTO nss_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pwen hu ndramat para hangna puw ara, ara huwop huya nondriya kol ngawan, pe huya tiyani melit masih kintayah, pe tesah kintayah kili hilu ndramat malmou mepo payit iro ndrita hilu ara. ");
INSERT INTO nss_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pe hu ndramat masih para kol ngawan ara, ara husa pohonani Yesu, pe iro mwonen hunime yiy, hurakekeyani yiy para kitali kolohu. ");
INSERT INTO nss_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pe iyamulan Yesu ihis iya nondriya ndroi hakou, pe isingondriti ndran makaiye iya haroh, pe isa kolon imwonen. ");
INSERT INTO nss_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pe hu ndramat hayah husap ndramat hamou iye matin ndrita pasup, mandran, ara imat. Pe iro mwonen inime lohongahu ndrisiyon, pwen ipwai iya kili ndramat mepo mandran imat ara, ipa, <<Noru, ndriyam kipwoke; kuntali hu pakut mwomwan atam.>> ");
INSERT INTO nss_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pwen hu ndramat hayah para hinuwani nongan para pwahanou, ara huro wong mwalingahu mbukenahu, hupa, <<Ndramat iye ara ita pwasisiman ana Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pe Yesu, ara tanan lohongahu pwen; pe isok hu, ipa, <<Paratapeh pe wawu tora lohongani hu lohongai mwomwan tora, ita ndriya wawu?>> ");
INSERT INTO nss_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tesah waison eh, para kupa, <Kuntali hu pakut mwomwan tam,> ndre kupa, <Atine pe arakai>? ");
INSERT INTO nss_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hapeko yo unamiliy para wawu kapahasaniy tehe Noru Ndramat, ara pwoke nopwaran iripo kili yiy iripo kol pwan, para kitali hu pakut mwomwan. Pwen ipwai iya kili ndramat mandran imat ara, ipa, <<Atine, awiri nokum, pe ayau aya suwem.>> ");
INSERT INTO nss_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pwen ndramat ara, itine pe iyau iya suwen. ");
INSERT INTO nss_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pe iro mwonen hu ndramat soyon, ara hunime melit aro kintayah, pwen lohongahu ikairut; pe huhuri ngala Ngindrai, hiyeh iyki pwoke nopwaran tora iya kili hu ndramat. ");
INSERT INTO nss_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pe Yesu iyau iropo iya, pwen inime ndramat hamou ngalan Mattiu iro mipwan ndrohonoku poya takis. Pwen ipwai iya kili yiy, ipa, <<Oho ndruwo!>> Pwen Mattiu itine, pe iho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe iyamulan Yesu iya namnam iya suwe Mattiu, pe hu ndramat soyon para poya takis pe hu ndramat pakut tahu mwomwan, ara husa pe huro namnam iyasura Yesu pe ndramiran hu. ");
INSERT INTO nss_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pe iro mwonen hu Parisiy hunimei tora, pwen husok hu ndramira Yesu, hupa, <<Paratapeh pe ndramat para hinuwani wawu, ara iripo namnam iyasura hu ndramat para poya takis, pe hu ndramat pakut tahu mwomwan?>> ");
INSERT INTO nss_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pe iro mwonen Yesu ihilingi nongan aro, pwen ipa, <<Yihu ndramat mepo mwamwa kili hu pwi, ara andre hu kanna nime hu ndrokta pwi, hapeko hu mepo humwa, hu ara kopu andre hu kaya nime ndrokta. ");
INSERT INTO nss_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pwen akaya pe akakahi ndroiyi nongan iye: <Unamili koisirai; ara ihohin iya kultuw para yukyuk.> Paratesah, yo kunsa para kuyoh hu ndramat kultuwayi hu imwonen pwi, hapeko usa, ara para kuyoh hu ndramat mepo pakut tahu mwomwan.>> ");
INSERT INTO nss_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pwen hu ndramira Yohanes ara husa pe husok Yesu, hupa, <<Yowu pe yihu Parisiy, ara ngara kayuh anandrinai, hapeko paratapeh pe ndramiram hu, ara hu konho yuh anandrinai pwi?>> ");
INSERT INTO nss_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Pe Yesu isomwi hu, ipa, <<Kapa ndramat hamou nakipo kowase yesou, pwen tehen tapeh, andre ndriya yowen hu koro poru, ma iro ndron kili hu? Hapeko lang itapo isa, kapa hu kawiri mbukena kowase yesou ara kiyau, pwen andre hu kayuh anandrinai. ");
INSERT INTO nss_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pe ndramat hamou kinho sorowe koyau hasai howen, kiyasura ndrihiyap hasai saken, ara pwi. Paratesah, koyau howen, ara andre kindrohomwiri koyau saken ara, pe andre kindrohomwiriy, pe kiramurumwut masih. ");
INSERT INTO nss_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pe hu ndramat konho songorani wain howen kiya pwisi wain saken, ara pwi. Kapa hu kambusiy, pwen wain andre kitaluwe pwisi wain saken ara, pe wain andre kimuw, pe pwisi wain andre kiya mwaihei opu. Pwen iya lohongai ara ko, hu ndramat ngara kasongorani wain howen ara kiya nondriya pwisi wain howen, pe andre melit malndra kene koro hiyan.>> ");
INSERT INTO nss_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pe Yesu iro wong manau, pe pohon hamou isa tukuruhu isa mbulmaran, pe ipa, <<Noru pihin mahapo ko kinmat. Hapeko asa pe aiki nimam kiya ndritan, pwen andre kisa mwalen.>> ");
INSERT INTO nss_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pwen Yesu itine pe iho ndruwan iya, pe ndramiran hu tehen aliy i. ");
INSERT INTO nss_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pwen iro mwonen ara, pihin hamou mepo mwamwa ndrai iro kili yiy iho nondriya hayou songui pe luwoh, ara isa pakeh ndruwa Yesu, pe iyki niman iyahatek iya payango koiwen. ");
INSERT INTO nss_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Paratesah, ipwai iya kili yiy mbukenan, ipa, <<Kapa nimo kiyahatek kiya payango koiwen opu, andre kungoh.>> ");
INSERT INTO nss_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pwen Yesu ipaiwani yiy pe inime pihin ara, pe ipa, <<Noru, lohongam ndrisiyon, ara imbusi wou antayah hiyan.>> Pe iro mwonen paramwandrai ara ko, pihin ara, iya hiyan. ");
INSERT INTO nss_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pwen iro mwonen Yesu isong iya nondriya seu ta pohon ara, inime hu ndramat soyon iya, ara hurora kuwah, pe huro lossou. ");
INSERT INTO nss_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Pwen ipa, <<Akaya mawen, mbunah pihin ara, ara kinmat pwi, hapeko ita matin.>> Hapeko huhaisani yiy. ");
INSERT INTO nss_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pe hupwandrisa hu ndramat hu kanna ngawan, pwen Yesu iya nondriya seu pe niman iya mbultuwe nima mbunah pihin ara, pe isa tine. ");
INSERT INTO nss_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pe nola tesah mepo Yesu imbusiy ara, ara ingau kol namandran hape ara topwei. ");
INSERT INTO nss_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pwen Yesu iro tokai iropo iya, pe hilu ndramat malmou mara hilu iyoh, ara hilho ndruwan, pe hilu yoh, hilpa, <<Noru Tepit, koyum kisikirani youlu.>> ");
INSERT INTO nss_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pe Yesu kinna nondriya seu, pwen hilu ndramat malmou mepo mara hilu iyoh ara, ara hilsa kili yiy. Pe isok hilu, ipa, <<Walu pwotisingi lohonga walu tehe ulahiy para kumbusi melit iye, ndre pwi?>> Pe hilu somwi yiy, hilpa, <<Ehe, Yapan.>> ");
INSERT INTO nss_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pwen niman iyahatek iya mara hilu, pe ipa, <<Iyau lohongai ndrisiyon ta walu ko, andre kirayah tehen aliy kisa kili walu.>> ");
INSERT INTO nss_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pwen mara hilu ileu, pe Yesu ipwandrandrahani hilu pwokeyan, ipa toro: <<Hamou mbuna kipahasani tesah kintayah aro.>> ");
INSERT INTO nss_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hapeko hilyau pe hilya tiyani titiye ta Yesu, pe ingau kol namandran hape masih ara. ");
INSERT INTO nss_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pe iro mwonen hilu ndramat malmou ara, hilropo hilya, ndramat hamou mepo payit iro ndritan pe pohon imum, ara huwiri yiy isa kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pe iro mwonen Yesu kinrasses payit kinna mawen, pwen ndramat mepo pohon imum ara, ara iwong. Pe hu ndramat, ara huro lohonge soyon, pe hupa, <<Melit tehen toro, ara konho nimei kirayah kiro Yisrayel pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hapeko hu Parisiy, hupa, <<Ita rasses hu payit, ara iyau pwoke ta payit mepo yapane hu payit masih.>> ");
INSERT INTO nss_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pe Yesu, ara iya yau hu kol ngawan pe hu kol mendreheh masih, pe iro hinuwani hu ndramat iro nondriya hu yumwa mbultere tahu Yuta, pe iro pohowe nongan hiyan para kolo king Ngindrai mepo ngara kiro mu kiya aliy. Pe isopwoyani hu neken handra-handra pe hu mwamwa handra-handra. ");
INSERT INTO nss_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pe iro mwonen Yesu inime hu ndramat soyon iya, pwen koyun isikirani hu, paratesah, lohongahu imwakaikai, pe huiki koisariy, tehe hu sipsip mepo ndramat para pwokereyahu, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pwen ipwai iya kili ndramiran hu, ipa, <<Anandrinai soyon iya, ara hu kaniman pwen hutora piyang, hapeko hu ndramat para poya mbulen, ara noye ko. ");
INSERT INTO nss_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pwen pe akatohun kiya kili Yapan, mepo mbukena piyang, para kipwandrisa hu ndramat para poya mbulen, para hu kayapo mbulen kaya nondriya pingen.>> ");
INSERT INTO nss_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pwen Yesu iyoh ndramiran hu songui pe lumou huya kili yiy pe iyki pwoke nopwaran iya kili hu para hu karasses hu payit, pe para hu kasopwoyani hu ndramat masih mepo humwa, pe hu neken handra-handra iro kili hu. ");
INSERT INTO nss_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pe iye, ara ngala hu aposel songui pe lumou: Imu, ara Simon, mepo ngalan handra yi ara Pita, pe nalin Antruw, Yamis noru Sepetiy pe nalin Yohanes, ");
INSERT INTO nss_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip pe Partolomeu, Tomas pe Mattiu mepo ndramat para poya takis, Yamis NdraAlpeyus pe Tatteyus, ");
INSERT INTO nss_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon mepo ndramat hamou para kili hu Selot, pe Yutas Yiskariyot mepo iyamulan iratuni Yesu. ");
INSERT INTO nss_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yihu songui pe lumou aro, ara Yesu ipwandrisa hu para hu kaya, pe ipomwanye iya kili hu, ipa: <<Wawu mbuna akaya kili hu Ndramira Lah, pe mbuna akaya nondriya kol hakol para Samariya. ");
INSERT INTO nss_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hapeko wawu kaya kili hu ndraye Yisrayel, mepo hu kansongsin tehe hu sipsip. ");
INSERT INTO nss_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Akaya, pe akoro pohowe nongan aro: <Kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara kinsa pakeh.> ");
INSERT INTO nss_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pe akasopwoyani hu ndramat humwa, pe akahangini hu ndramat kanmat kasa tine, pe akasopwoyani hu mepo mwamwa kawa ita kili hu, para hu karayah howen. Pe akarasses hu payit kaya mawen kili hu ndramat. Pwoke mepo akanwiriy, ara kennen pwi; pwen pe apakasopwat hu ndramat, ara kennen pwi yi. ");
INSERT INTO nss_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wawu mbuna akapo sombule kolt, ndre sombule silwa, ndre sombule kopa kiro ndropwa sombule pat tawawu pe akaya. ");
INSERT INTO nss_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pe wawu mbuna akasap ndropwa kunkun, pe mbuna akapo susura koiwe wawu, ndre susura hatna pweleka wawu, ndre kapo nes sih kiyapolo wawu. Paratesah, ndramat ngara kipo mbulen, ara andre kiwiri hiyan kiyau aliy. ");
INSERT INTO nss_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pwen sehe kol ngawan ndre sehe kol mendreheh wawu nakaya nondriyan, ara akaten ndramat hamou pahalan kiro ara, pe akoro suwen kipoo akatali kol ara. ");
INSERT INTO nss_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pe kiro mwonen wawu nakasong kaya nondriya seu, ara akarawulohani hu ndramira seu ara. ");
INSERT INTO nss_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pe kapa hu para seu ara, hu karawulohani wawu, akapwai para lomwes para ndriya wayis kiro sura hu. Pe kapa hu kantawulohani wawu pwi, pwen akawiri lomwes para ndriya wayis tawawu kimui. ");
INSERT INTO nss_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pe kapa hamou kintawulohani wawu pwi, ndre kinhilingi nongna wawu pwi, pwen akaratolohani kohu pweleka wawu kiro mwonen wawu nakatali seu ara ndre kol ngawan ara. ");
INSERT INTO nss_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yo upwai ndrokonan isa kili wawu, kora nopwaran para kol ara, ara andre kiramwaitini nopwaran para Sotom pe Komorrah, kiro mwonen lang para tamwanye. ");
INSERT INTO nss_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yo nakupwandrisa wawu tehe hu sipsip para akaya mwalinga hu mwiy puyap. Pwen pe lohonga wawu kipahas tehe hu mwat, pe akoro mwonen tehe hu pai. ");
INSERT INTO nss_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pe wawu koro hinehes kiyata hu ndramat, andre hu karatuni wawu pe kaiki wawu kaya nongan koro mbulmara hu pohon para kol, pe andre hu kamwiri wawu koro hu yumwa mbultere tahu Yuta. ");
INSERT INTO nss_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tunan yo kopu, andre hu kaluwi tarahani wawu kaya mbulmara hu yapane hu kol namandran iya, pe kaya mbulmara hu king. Pwen tehen tora ko, andre wawu katiyani tiyeyo kiya kili hu, pe kiya kili hu Ndramira Lah. ");
INSERT INTO nss_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hapeko kiro mwonen yihu kambultuwe tahatini wawu, para wawu koro tine nongan, ara lohonga wawu mbuna kimwa kiya sehe nongan para wawu nakapwai, ndre wawu nakawong tapeh. Kiro mwonen paramwandrai ara, Ngindrai andre kiyki nongan para wawu kapwai. ");
INSERT INTO nss_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Paratesah, andre wawu kanwong pwi, hapeko Mwoiwa Tama wawu, ara andre kiwong kiyau poho wawu. ");
INSERT INTO nss_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pe hilu ndramat malmou hilu nali hilu, ara andre hamou kiratuni hamou para hu ndramat katingundrun kimat. Pe tama mbunah hamou, ara andre kimbusiy tehen aliy kiya kili norun i. Hu mbunah andre hu karasisingat ana tamahu pe tinahu, para hu ndramat katingundru hilu kamat. ");
INSERT INTO nss_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pe tunan yo kopu, pwen andre hu ndramat masih kahangasi wawu. Hapeko sehe ndramat kiro tine pwokeyan, kipoo lang nakiyahapwen, ara andre Ngindrai kisopwat yiy. ");
INSERT INTO nss_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pe kiro mwonen hu pakarandroyani wawu koro kol hakol, akawop kaya hakol. Yo upwai ndrokonan isa kili wawu, tehe wawu andre kanlahiy para kasalti topwe hu kol masih kene para Yisrayel mapu, kipoo andre Noru Ndramat kisa. ");
INSERT INTO nss_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ndramat mepo ngara kiwiri hinonou, ara kinhohin kili ndramat mepo iro hinuwani yiy pwi. Pe ndramat para poya mbulen, ara kinhohin ta namandran tan pwi. ");
INSERT INTO nss_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hiyan para ndramat iro wiri hinonou, ara kirayah tehe ndramat iro hinuwani yiy. Pe hiyan para ndramat para poya mbulen kirayah tehe namandran tan. Pe kapa hu kapohowe tama seu ara, Peelsepul, pwen andre ngala yowen hu masih kene ara, ara andre kiya pwalngengei o mwaihei! ");
INSERT INTO nss_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pwen pe wawu, ara mbuna akanoh tahu ndramat ara. Paratesah, sehe melit mepo kantamburuhiy, ara andre karehei. Pe sehe melit mepo ita kohon, ara andre kisa yelan ngawan. ");
INSERT INTO nss_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pe tesah upwai isa kili wawu kiro lokuhan, ara akapohowei kiro ngana lang. Pe tesah mepo ndrainga wawu ihilingiy iro mwalinga wawu ko, ara akapwaharai kiho payandroha hu seu. ");
INSERT INTO nss_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wawu mbuna akanoh ta hu mepo hulahiy para katingundru nombuwe wawu, hapeko kanlahiy para katingundru mwoiwa wawu pwi. Hapeko akanoh ta Ngindrai opu, yiy mepo ilahiy para kipwalngani mwoiwa wawu pe nombuwe wawu kene, kiya nondriya ngat mepo mwan ita yat aliy. ");
INSERT INTO nss_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wawu pahasaniy tehe norupep malmou, ara andre hu ndramat kapo pehei kiyata hilu kiya sombule pat hambut, ndre? Hapeko kinlahi hamou ta hilu norupep ara, kimat pe Tama wawu kikowu, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pe tehen aliy opu, hu kompai hutora paya wawu, ara Tama wawu kindromwahu topwei. ");
INSERT INTO nss_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pwen pe wawu mbuna akanoh, wawu ho hin iya, iyata hu norupep soyon. ");
INSERT INTO nss_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Pe hiyeh ngara kiwong ngawan kiro mbulmara hu ndramat tehe yiy ndramiro, ara andre kuwong ngawan kiro mbulmara Tomo kiro kol paingan yang tehe yiy ndramiro yi. ");
INSERT INTO nss_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pe hiyeh ngara kipwai tehe ikowu to kiro mbulmara hu ndramat, ara andre kupwai tehe ukowu tan, kiro mbulmara Tomo kiro kol paingan yang i. ");
INSERT INTO nss_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Wawu mbuna akapa ndre usa kol pwan, ara para kuiki ndriya wayis kiya mwalinga hu ndramat. Pwi yoh! Kunsa para kuiki ndriya wayis pwi, hapeko usa, ara para kusaiki tahatai. ");
INSERT INTO nss_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Paratesah, usa, ara para kumbusiy, pe <mbunah kamai andre kihingas ana taman, pe andre mbunah pihin kihingas ana tinan, pe andre mbuyunorun kihingas ana mbuyungundran. ");
INSERT INTO nss_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Pe hu ndraisih ta ndramat hamou, ara andre hu karayah hu ndramat para kamwisnani yiy.> ");
INSERT INTO nss_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pe hiyeh ndriyan imbuluhi yo, hapeko ndriyan imbuluhi taman ndre tinan iya namandran iya isato, ara kinlahiy para kirayah ndramiro pwi. Pe hiyeh ndriyan imbuluhi yo, hapeko ndriyan imbuluhi norun kamai ndre norun pihin iya namandran iya isato, ara kinlahiy para kirayah ndramiro pwi. ");
INSERT INTO nss_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pe hiyeh kinwiri kei tondrih tan pe kinho ndruwo pwi, ara kinlahiy para kirayah ndramiro pwi. ");
INSERT INTO nss_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pe hiyeh neren kiya mwoiwan mbukenan, andre mwoiwan kitali yiy. Pe hiyeh kilohongani yo, pe tunan yo kopu kitali mwoiwan, pwen andre kisopwat mwoiwan mbukenan. ");
INSERT INTO nss_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pe yiy hiyeh irawulohani wawu, ara irawulohani yo. Pe yiy mepo irawulohani yo, ara irawulohani yiy mepo ipwandrisa yo. ");
INSERT INTO nss_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pe Ngindrai andre kiyki kenne hiyeh kapa kipokere poropet hamou. Pe andre kiyki kenne ndramat ara, kihisoule ko tehe kenne poropet hamou. Pe Ngindrai andre kiyki kenne hiyeh kapa kipokere ndramat hamou imwonen. Pe andre kiyki kenne ndramat ara, kihisoule ko tehe kenne ndramat hamou imwonen. ");
INSERT INTO nss_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pe kapa hiyeh kimbusi melit mendreheh, tehe kiyki ndran wawen hape kiya kili hamou tahu mbunah mendreheh aripo, paratesah, mbunah aro, ara ndramiro hamou, pwen upwai ndrokonan isa kili wawu, Ngindrai, ara andre koyun kinmayit kennen pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ipomwanye iya kili ndramiran hu songui pe lumou ihipwen, pwen itali kol ara, para kiya hinuwani hu ndramat pe kiya pohowe nongan kiya nondriya hu kol ngawan para Kaliliy. ");
INSERT INTO nss_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohanes, ara iro nondriya kou, pe iro mwonen ihilong hu melit Mesayah iro mbusiy, pwen ipwandrisa ndramiran hu ");
INSERT INTO nss_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para hu kaya pe kaya sok yiy, hu kapa, <<Wou ndramat mepo Ngindrai kintandrangan para kisa ara, ndre yowu koro sohoni hamou hira ndron i?>> ");
INSERT INTO nss_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pe Yesu isomwi hu, ipa, <<Akamui pe akaya nese ndrainga Yohanes kiya sehe melit wawu hilingiy pe wawu nimei. ");
INSERT INTO nss_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yihu mepo marahu iyoh, ara hunimnim. Pe yihu mepo ndrikahu mwomwan, ara hu topo rokai. Pe yihu mepo mwamwa kawa iro kili hu, ara huya howen. Pe yihu mepo ndraingahu iyui, ara ndraingahu ileu. Pe yihu mepo humat, ara hutine paiwe. Pe yihu mepo hundroisiy, ara huhilingi nongan hiyan. ");
INSERT INTO nss_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pe ndramat mepo ipwotisingi lohongan isa kili yo pe lohongan kinhindrundru pwi, ara lomwes kiro kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pe hu ndramira Yohanes huropo huyau, pwen Yesu iwong iya kili hu ndramat soyon iya, iyata Yohanes, pe ipa toro: <<Wawu yau iya kol ndrohoyin para kaya nime tesah? Parah hakou mepo nohai ita mbuiwaniy? ");
INSERT INTO nss_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kapa pwi, pwen wawu ya para kaya nime tesah? Ndramat hamou mepo isuluye yiy iya koyau lahayan? Pwi! Yihu mepo husuluye hu iya koyau lahayan, ara hutora nondriya suwe hu king. ");
INSERT INTO nss_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pwen wawu ya ndra para kaya nime tesah? Para kaya nime poropet hamou, ndre? Ehe! Pe yo upwai isa kili wawu tehe yiy poropet hamou, pe mbulyan ara ihou i. ");
INSERT INTO nss_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohanes ara yiy ndramat ara, mepo pwayan kinpwai pwen, ipa toro: <Yo andre kupwandrisa ndramat para sapiya nongno, kiho mu kili wou, pe andre kiramwaniyani meresayam.> ");
INSERT INTO nss_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yo upwai ndrokonan isa kili wawu, mwalinga hu ndramat mepo hu pihin hu kanmwalahiy kinna tahu, ara hamou kinhohin kili Yohanes Ndramat para Paptais, ara pwi. Hapeko sehe ndramat mepo ngalan pwi, kiro kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara yiy ihohin iyata Yohanes. ");
INSERT INTO nss_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Iro lenge Yohanes Ndramat para Paptais isarayah, isa matnen mahapo, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara iropo isa iyapolo pwoke pwokeyan, pe hu ndramat para pwoke pwokeyan, ara hu hinonou para kambultuwei. ");
INSERT INTO nss_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Paratesah, yihu poropet masih pe nongan para pwahanou i, ara huro pohowe nongna poropet, ipoo isa matne lenge Yohanes isarayah. ");
INSERT INTO nss_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pe kapa lohonga wawu kilahiy para kipwotisingiy, Yohanes, ara yiy poropet Eliyah, mepo pwayan kinpwai para andre kisa ara. ");
INSERT INTO nss_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hiyeh mandraingan, ara kihilingi nongan iye. ");
INSERT INTO nss_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yo andre kuranonoye hu ndramat hasap para mahapo tehen tapeh? Yihu ara tehe hiyeh hu yi? Yihu, ara tehe hu mbunah ngara kampwan koro nondriya hu ndroho pehei, pe ngara kayoh kiya kili hu hayah, hu kapa toro: ");
INSERT INTO nss_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Yowu, yowu ra ndramiya wawu, hapeko mbuwali wawu ndraniyai; yowu pwandreundreu, hapeko mbuwali wawu para akarang mali wawu.> ");
INSERT INTO nss_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Paratesah, Yohanes isa, pe kinho namnam soyon pwi, pe kinho yin wain pwi. Hapeko hupa, <Payit ita ndritan.> ");
INSERT INTO nss_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hapeko Noru Ndramat isa pe iro namnam, pe iro yin wain, pe hupa, <Akanime yiy! Yiy ara komkom, pe ndramat para kuimwa wain. Yiy ara kowase hu ndramat para poya takis, pe hu ndramat pakut tahu mwomwan.> Hapeko yihu hiyeh huwiri lohongai waison ta Ngindrai, ara hupwainganiy tehe lohongan, ara ndrokonan masih.>> ");
INSERT INTO nss_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pwen Yesu ipomate hu ndramat para kol hayah, mepo imbusi hu ndraikiya pwoke tan hitun iro aliy, paratesah, yihu kantapaiwani ndriyahu pwi. Pe ipa, ");
INSERT INTO nss_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<O wawu ndramira kol Korasin! O wawu ndramira kol Petsaita! Toimwa wawu. Nopwaran namandran ita ndrita wawu. Kapa ndramat hamou kinna kol malkol Tayar pe Siton, pe kinmbusi hu ndraikiya pwoke kiro aliy tehe kinsarayah kinsa kili wawu pwen, ara andre hu kantapaiwani ndriyahu pwen ndrukoluw kinna, pe andre hu kansuluye hu pwen kinna koyau para koisirai, pe andre hu kantumwi hu pwen kinna palam i, para kipwainganiy tehe hu kantapaiwani ndriyahu. ");
INSERT INTO nss_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hapeko upwai isa kili wawu, kiro mwonen lang para tamwanye, koran nopwaran wawu nakakuniy, ara andre kiramwaitini kora nopwaran tahu para Tayar pe Siton. ");
INSERT INTO nss_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pe wawu para Kapernawum, wawu pakasikiye wawu kaya paingan yang, ndre? Pwi yoh. Wawu andre kaya pwan masih ndrohonoku hu ndramat kanmat. Kapa ndramat hamou kinna kol Sotom, pe kinmbusi hu ndraikiya pwoke kiro aliy tehe kinsarayah kinsa kili wawu pwen, pwen kol ara, ara andre kinto, kipoo kisa matnen lang nepo. ");
INSERT INTO nss_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hapeko upwai isa kili wawu, kiro mwonen lang para tamwanye, kora nopwaran wawu nakakuniy, ara andre kiramwaitini kora nopwaran para kol Sotom.>> ");
INSERT INTO nss_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pe iro mwonen lang ara, Yesu ipa, <<Tomo, urawuloh isatam, Yapane kol paingan yang pe kol pwan, paratesah, wou ankulani hu melit aro kene, kinna kili hu mepo lohongahu waison, pe hu mepo huwiri hinonou soyon. Pe wou, ara anpwaingani hu melit ara, kinna kili hu mbunah mendreheh. ");
INSERT INTO nss_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ehe, Tomo, iye ara tesah hiyan mepo anamiliy para kirayah. ");
INSERT INTO nss_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Melit masih, Tomo kiniyki hu topwei kansa kili yo. Hamou kinpahasani Norun pwi, Taman opu ipahasani yiy; pe hamou kinpahasani Taman pwi, Norun opu ipahasani yiy. Pe hu mepo Norun inamiliy para kiyingani Taman kiya yelan kiya kili hu, ara yihu ara ko, hupahasani yiy. ");
INSERT INTO nss_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Akasa kili yo, wawu ndramat mepo mandra wawu ipalat, pe kona wawu nopwaran, pe andre kuiki ngohongoh kisa kili wawu. ");
INSERT INTO nss_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pe talu kakuni pulukuwo, pe awiri hinonou kiyau kili yo. Paratesah, kultuwayi ara waison, pe ngara kuiki yo kusa pwan. Pe andre mwoiwam kiwiri ngohongoh. ");
INSERT INTO nss_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Paratesah, pulukuwo, ara waison, pe kono, ara mwakin opu.>> ");
INSERT INTO nss_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iro mwonen lang Sapat sih, Yesu iyasura ndramiran hu huyayau ndraipinge wit hambut. Pe ndramiran hu, ara humundrui pe huro rih hu mbuwa wit pe huro yan. ");
INSERT INTO nss_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pe iro mwonen hu Parisiy hunimei, pwen hupwai iya kili Yesu, hupa, <<Animei! Ndramiram hu, ara humbusi melit mepo nonombun para kambusiy kiho nondriya lang Sapat.>> ");
INSERT INTO nss_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pe Yesu isomwi hu, ipa, <<Wawu kannime titiye ta Tepit iyapolo ndramiran hu mepo humundrui ara, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tepit, ara isong iya nondriya yumwa Ngindrai, pe iwiri ndrinanohun mepo kanmbusiy kintayah haiyan; pwen yiy pe ndramiran hu, ara huiniy. Ndrinanohun ara, ara nonombun para hu kayan; hapeko hu pris opu andre hu kayan. ");
INSERT INTO nss_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pe wawu kannime titiye ara pwi, ndre? Pe wawu kannimei pwi yi, ita nongan para pwahanou, ara ipa hu pris hu koropo mbulen kiro nondriya yumwa totohun namandran kiho nondriya lang Sapat, ndre? Hapeko mbulen mepo hu ngara kambusiy, ara imwonen, pe nonombun pwi. ");
INSERT INTO nss_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pwen pe upwai isa kili wawu, tehe yiy mepo ihohin iya, iya yumwa totohun namandran, ara iripo. ");
INSERT INTO nss_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kapa wawu kapahasani ndroiyi nongan iye, <Unamili koisirai; ara ihohin iya kultuw para yukyuk,> pwen wawu ara kanlahiy para karasusut nongan kiya kili hu ndramat mepo kanmbusi hapesah mwomwan pwi. ");
INSERT INTO nss_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Paratesah, Noru Ndramat, ara yiy Yapane lang Sapat.>> ");
INSERT INTO nss_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu itali kol ara, pe iyau iya nondriya yumwa mbultere tahu Yuta, ");
INSERT INTO nss_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","pe ndramat hamou iro aliy, ara niman imat. Hu ndramat hayah huro ten sai para hu kaiki Yesu kiya nongan, pwen pe husok yiy, hupa, <<Nonombun para kasopwoyani ndramat kiro nondriya lang Sapat, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu ipwai iya kili hu, ipa, <<Kapa hamou tawawu ma sipsip tan hamou, pe kiyos kiya ngat kiho nondriya lang Sapat, ara andre kiluwi yiy kisa ngawan, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pwen ndramat hamou, ara iho hin iya, iyata sipsip hamou, ndre? Tehen tora ko, hiyan para kambusi kultuw hiyan kiho nondriya lang Sapat, pe nonombun pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pwen ipwai iya kili ndramat ara, ipa, <<Amwaniyani nimam.>> Pwen imwaniyani niman, pe niman irayah hiyan tehe niman hakai yi. ");
INSERT INTO nss_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hapeko hu Parisiy, ara huya ngawan pe humburi nongan para katingundru Yesu. ");
INSERT INTO nss_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu isapahas iya tesah hu Parisiy hu pakambusiy kiya kili yiy, pwen itali kol ara, pe iyau. Pe hu ndramat soyon iya huho ndruwan, pe isopwoyani hu ndramat masih, mepo mwamwa iro kili hu pe hungoh. ");
INSERT INTO nss_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pe ipwandrandrahani hu para hu mbuna katiyani yiy. ");
INSERT INTO nss_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pe hu melit aro hurayah, ara para kimbusi nongna Poropet Yisayah kirayah mannan, ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Iye ara ndramat para poya mbulyo mepo kuntakiniman. Yiy hiyeh ndriyo imbuluhi yiy pe upwes iyatan; pe andre kuiki Mwoiwo kiya ndritan, pe andre kipohowe nongan para tamwanye kultuw imwonen, kiya kili hu ndraye ndramat masih. ");
INSERT INTO nss_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pe andre kintakokowai pe kinpalngai pwi, pe hamou andre kinhilingi mbulukoyun kiho hu payango sai, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pe parah hakou mepo ipuyui, ara andre kintumbuwei pwi, pe mwan mepo nakimonon, ara andre kinsumatei pwi, kipoo kimbusi kultuw imwonen kiramwaitini kultuw masih kene. ");
INSERT INTO nss_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pe iya ngalan opu, hu ndraye ndramat masih, andre hu kapwotisingi lohongahu kaya kili yiy, pe koro longe sopwat tan itapo isa.>> ");
INSERT INTO nss_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pwen huwiri ndramat hamou payit iro ndritan, mepo pohon imum pe maran iyoh. Pe Yesu isopwoyani ndramat ara iya hiyan, pe ilahiy para kiwong pe kinimnim. ");
INSERT INTO nss_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pe hu ndramat masih, ara lohongahu indrap, pe hupa, <<Ndramat aro, ara yiy noru Tepit, mepo andre kisopwat hu ndramat kamui ara, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hapeko iro mwonen hu Parisiy huhilingi nongan aro, pwen hupa, <<Ndramat iye ita rasses hu payit, ara iyau pwoke ta Peelsepul opu, payit mepo yapane hu payit masih.>> ");
INSERT INTO nss_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu kinpahasani lohongahu, pwen ipwai iya kili hu, ipa, <<Kapa hu ndramira king para kol hakol hu kamasilpat kaya malpat, pe hu kahangas mwalinga hu mbukenahu, pwen kolo king mepo ngara kiro mu kiya aliy ara, andre kiya mwaihei o. Pe kapa hu ndramat para kol hakol, ndre hu ndraisih, hu kamasilpat kaya malpat, pe hu kahangas mwalinga hu mbukenahu, pwen hu ndramira kol ara, ndre hu ndraisih ara, ara andre hu kanlahiy para koro tine pwokeyan pwi. ");
INSERT INTO nss_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pwen kapa Sinai kirasses Sinai, ara yiy mbukenan kinmasilpat. Pe andre kolo king tan mepo ngara kiro mu kiya aliy ara andre kiro tine pwokeyan tapeh? ");
INSERT INTO nss_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Pe kapa kurasses hu payit kiyau pwoke ta Peelsepul, pwen yowe wawu hu ngara karasses hu payit kiyau pwoke ta hiyeh? Pwen pe hu yowe wawu mbukena wawu, andre hu kapwainganiy tehe nongna wawu ara, ara kinmwonen pwi. ");
INSERT INTO nss_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hapeko kapa kurasses hu payit, kiyau pwoke ta Mwoiwa Ngindrai, pwen pwoke para kolo King Ngindrai mepo ngara kiro mu kiya aliy, ara kinsa kili wawu pwen. ");
INSERT INTO nss_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hiyeh ilahiy para kisong kiya nondriya suwe ndramat hamou pwokeyan, pe kiya kuni hu menmenan? Hamou kinlahiy pwi! Hapeko kapa kiwasi tiriyi ndramat pwokeyan ara namu, pwen andre kilahiy para kiya pe kilokihi topwe menmena ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pe hiyeh mepo kinto sura yo pwi, ara andre kirasisingat ano. Pe hiyeh mepo kinho mbultani hu ndramat pwi, ara ngara kirasumbuwani hu. ");
INSERT INTO nss_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pwen pe upwai isa kili wawu tehe hu pakut mwomwan masih, pe hu nongan masih para pwasisiman, ara Ngindrai ilahiy para kitali hu pakut mwomwan ara. Hapeko hiyeh kipwasisiman ana Mwoiwan Haiyan, ara andre Ngindrai kintali pakut mwomwan tan ara, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pe hiyeh kipa nongan sahin para kipwasisiman ana Noru Ndramat, ara Ngindrai ilahiy para kitali pakut mwomwan tan ara. Hapeko hiyeh kipa nongan sahin kipwasisiman ana Mwoiwan Haiyan, andre Ngindrai kinlahiy para kitali pakut mwomwan tan ara, ara pwi, kiro nondriya lang mahapo, ndre kiho nondriya lang itapo isa. ");
INSERT INTO nss_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kapa kei hakou ara hiyan, pwen sangin ara hiyan; pe kapa kei hakou ara mwomwan, pwen sangin ara mwomwan. Paratesah, ngara kayirowe kei hakou hiyan ndre mwomwan, ara kiyau sangin. ");
INSERT INTO nss_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wawu noru mwat mapairan, wawu ndramat mwomwan, andre kawong nongan hiyan tapeh? Tesah ipep ita ndriya ndramat, ara poho ndramat ngara kipohowei. ");
INSERT INTO nss_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ndramat hiyan, ara andre kiyingani kultuw hiyan mepo kiyau mbulkura ndriyan. Pe ndramat mwomwan, ara andre kiyingani kultuw mwomwan mepo kiyau mbulkura ndriyan. ");
INSERT INTO nss_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hapeko upwai isa kili wawu, tehe hu ndramat masih andre koro tine nongan, kiho nondriya lang para tamwanye, kiya hu nongan masih mwomwan mepo hu kanpwai o mwaihei. ");
INSERT INTO nss_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Paratesah, kiyau hu nongnam opu, andre Ngindrai kipohowe wou ndramat imwonen, pe kiyau hu nongnam opu, andre Ngindrai kiyki konam kisa ndritam.>> ");
INSERT INTO nss_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pwen hu Parisiy hayah pe hu ndramat para hinuwani nongan para pwahanou, ara hupwai iya kili yiy, hupa, <<Ndramat para Hinonou, yowu nakanime kaipisa ndraikiya pwoke handra kiyau kili wou.>> ");
INSERT INTO nss_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pe isomwi hu, ipa, <<Hu hasap mepo kultuwayihu pwassin pe hu kantali Ngindrai, ara yihu ngara kasok kaipisa ndraikiya pwoke. Hapeko yihu andre kannime kaipisa hapesah pwi; kaipisa poropet Yonah kopu andre hu kanimei. ");
INSERT INTO nss_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Paratesah, Yonah ara iro nondriya ndriya ni hamou namandran, lang maroyoh pe ping maroyoh. Pwen tehen tora ko, Noru Ndramat andre lang maroyoh pe ping maroyoh kiro mbulu pwan. ");
INSERT INTO nss_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pe kirahihini lang para tamwanye, yihu ndramira kol Ninipe andre hu kasa koro tine, pe kasopwat nongan para tamwanye, pe katiyani titiye mwomwan tahu hasap para mahapo, pe andre hu karasusut nongan kiya kili hu. Paratesah, yihu kanhilingi nongna Yonah pe hu kantapaiwani ndriyahu; hapeko hamou iripo mahapo, ara ihohin iya, iya kili Yonah. ");
INSERT INTO nss_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pe kiro lang para tamwanye, Kwin para Tolau andre kisa, pe andre kitiyani titiye mwomwan tahu hasap para mahapo, paratesah, yiy iyau mbusungo kol pwan isa para kisa hilong lohongai waison ta Solomon. Hapeko hamou iripo mahapo, ara ihohin iya, iya kili Solomon. ");
INSERT INTO nss_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Pe kiro mwonen mwoiwa payit hamou kisa mawen kili ndramat hamou, ara andre kiya hu kol ndrohoyin para kiya ten noku ngohongoh. Hapeko andre kiten ndrit. ");
INSERT INTO nss_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pwen andre kipa, <Yo andre kumui kuya seu mepo kuntaliy mamu ara.> Pe kiro mwonen kiyarayah, ara andre kinimei tehe seu ara, ara iro ko mwaihei, pe yihu kanpwasiliy kinna hiyan pe iro mwoimwoi. ");
INSERT INTO nss_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pwen imui iya pe iya wiri hu payit manandrtimou i huya sura yiy; hu payit ara, ara kultuwayihu pwassin masih iramwaitini yiy. Pe husong huya nondriya seu ara, pe huyen aliy. Pe iyamulan para aliy, ara mipwan ata ndramat ara, ara kintewihiy pwi masih, pe iramwaitini mipwan tan para mamu. Yihu hasap pwassin para mahapo aro, ara andre kirayah tehen tora ko kiya kili hu yi.>> ");
INSERT INTO nss_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pwen pe Yesu iro wong ndron iya kili hu ndramat soyon ara, pwen tinan pe nalin hu, ara husa pe huro tine ngawan para hu nakawong kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pwen hamou inese ndrainga Yesu, ipa, <<Tinam pe nalim hu, ara hutora tine ngawan pe hu nakawong kisa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hapeko Yesu isomwi ndramat mepo inese ndraingan ara, ara ipa, <<Hiyeh ara tino, pe hiyeh hu ara nali hu?>> ");
INSERT INTO nss_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pwen isuwe ndramiran hu, pe ipa, <<Tino pe nali hu, ara yihu aripo. ");
INSERT INTO nss_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Paratesah, sehe ndramat ngara kimbusi namiliwa Tomo ita kol paingan yang, ara yiy nali, pe yiy pisu, pe yiy tino.>> ");
INSERT INTO nss_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iro mwonen lang ara ko, Yesu itali seu iya ngawan pe iya pe impwan ngilse ndran makaiye. ");
INSERT INTO nss_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pe hu ndramat soyo-soyon iya, ara husa rawure pe hurahakowan. Pwen iya pe ihis iya nondriya ndroi hakou pe impwan aliy, pe hu ndramat masih, ara huro tine pwaki leng. ");
INSERT INTO nss_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pwen itiyani hu titiye soyon, iya kili hu iya nongan pwandritiye. Pe ipa, <<Ndramat hamou para mbulya piyang iya piye hu peke wit tan. ");
INSERT INTO nss_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pe iro mwonen iro piye hu peke wit, hu tiken para aliy, ara hulon huro sai. Pe hu norukan husa pe huiniy topwei. ");
INSERT INTO nss_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pe hu tiken i, ara hulon huro ndrita pwan sosolou, mepo pwan soyon kinto aliy pwi. Pe indrou pwi ko, husahambunet, paratesah, pwan kinna hangoh mbulun pwi. ");
INSERT INTO nss_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hapeko iro mwonen mwandrai ingas, ara ngandraha mwandrai itimwi hu wit hulek ara, pe huwayiu, paratesah, ngondrohu kansin hiyan pwi, pe humang. ");
INSERT INTO nss_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pe hu peke wit tiken, ara hulon huya mwalinga hu malkei maporon, pwen hu malkei maporon, ara hulek iyasura hu peke wit ara, pe huraimwani hu pe humang. ");
INSERT INTO nss_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pe hu peke wit tiken i, ara hulon huya ndrita pwan hiyan, pe hulek pe huppwai, pe sangihu ihon iya soyon iya, tehe peke wit sih iyki peken masangat ndre manongui ndre matingui. ");
INSERT INTO nss_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hiyeh mandraingan, ara kihilingi nongan iye.>> ");
INSERT INTO nss_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pe ndramiran hu husa kili yiy pe husok, hupa, <<Paratapeh atawong iya kili hu ndramat iya hu nongan pwandritiye?>> ");
INSERT INTO nss_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pe isomwi hu, ipa, <<Lohongai kokohon para kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara Ngindrai kiniykiy kinsa leu kinsa kili wawu, hapeko yihu, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Paratesah, sehe ndramat mamenmenan, ara andre kipo suran. Hapeko yiy mepo menmenan pwi, konan hape sohoyan kimin, ara andre kawiriy topwei kiya mawen kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pwen tehen tora ko, urupo wong hu nongan pwandritiye iya kili hu: <Ngara hu koro nimei, hapeko tehe hu kannimei pwi; pe ngara hu koro hilingiy, hapeko tehe hu kanhilingiy pwi, pe lohongahu kanileu pwi.> ");
INSERT INTO nss_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pe nongan sahin ta poropet Yisayah, ara irayah mannan isa kili hu ndramat aripo, ara ipa toro: <Lang masih wawu andre koro hilingiy, hapeko lohonga wawu, ara andre kinileu pwi. Pe lang masih andre wawu koro nimei, hapeko tehe wawu kanyirowei pwi. ");
INSERT INTO nss_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Paratesah, ndriya hu ndramat aripo, ara kanpwoke, pe ndraingahu, ara pakeh kayui, pe marahu, ara kanpwasi. Matisan marahu kanimei, pe ndraingahu kahilingiy, pe lohongahu kaleu, pe hu karapaiwani ndriyahu pe hu kasa kili yo, pe andre kusopwoyani hu.> ");
INSERT INTO nss_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Hapeko lomwes, ara ita mara wawu, paratesah, mara wawu ita nimei. Pe lomwes, ara ita ndrainga wawu, paratesah, ndrainga wawu ita hilingiy. ");
INSERT INTO nss_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yo upwai ndrokonan isa kili wawu, tehe hu poropet soyon pe hu ndramat soyon hu mwonen, ara hunamiliy tisingiy para hu kanime tesah mepo wawu topo nimei, hapeko hu kannimei pwi. Pe ndraingahu inamiliy tisingiy para hu kahilingi tesah mepo wawu topo hilingiy, hapeko yihu kanhilingiy pwi. ");
INSERT INTO nss_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pwen pe akahilingi mbulndroiyi nongan pwandritiye ta ndramat para piyeya wit. ");
INSERT INTO nss_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hiyeh mepo ihilingi nongan hiyan para kolo King Ngindrai mepo ngara kiro mu kiya aliy, pe lohongan kinileu kinna aliy pwi, ara Sinai isa pe ilohi nongan iro ndriyan iya mawen kili yiy. Lohongai para peke wit mepo ilon iro sai, ara ndroiyin aro ko. ");
INSERT INTO nss_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hu peke wit mepo hulon huro pwan sosolou, ara tehe ndramat mepo ihilingi nongan, pe hape pwi ko ipwes iya aliy. ");
INSERT INTO nss_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hapeko ngondron, ara kinsin hiyan pwi, pe kinto ndrangan niwen pwi. Pe tunan nongna Ngindrai, hu ndramat huiki nopwaran iya ndritan pe hu karandroyani yiy, pwen pe indrou pwi ko, lohongan ndrisiyon, ara itali yiy. ");
INSERT INTO nss_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pe hu peke wit mepo hulon huro mwalinga hu malkei maporon, ara tehe ndramat mepo ihilingi nongna Ngindrai, hapeko ilohongani mipwan hiyan para lang nepo, pe melit soyon para kol pwan ara ipakarawani yiy, pwen pe iraimwani nongna Ngindrai, pe kinippwai pwi. ");
INSERT INTO nss_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pe hu peke wit mepo hulon huro pwan hiyan, ara tehe ndramat mepo ihilingi nongna Ngindrai, pe lohongan ileu iya aliy. Pe wit ara ippwai, pe iyki peken iya masangat ndre manongui ndre matingui.>> ");
INSERT INTO nss_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pwen Yesu itiyani nongan pwandritiye handra yi iya kili hu, ipa toro: <<Kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe ndramat hamou ipiye peke wit hiyan iya pingen. ");
INSERT INTO nss_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hapeko iro mwonen hu ndramat masih huro matin, yoyou tan isa pe ipiye peke ndromwindriu mwomwan iya mwalinga hu wit tan pe kinnau. ");
INSERT INTO nss_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pe iro mwonen hu peke wit husahambunet pe hu pakappwai, hu ndromwindriu mwomwan, ara husarayah huro surahu yi. ");
INSERT INTO nss_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pwen hu ndramat para poya mbulya mbukena piyang, ara huya kili yiy, pe hupa, <Namandran, wou apiye hu peke wit hiyan opu iya pingem, ndre? Pwen paratapeh pe hu ndromwindriu aripo, ara hu topo lek iye?> ");
INSERT INTO nss_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pe isomwi hu, ipa, <Yoyou hamou ara imbusi aro.> Pe hu ndramat para poya mbulyan husok yiy, hupa, <Wou anamiliy para yowu kaya pe kaloli hu?> ");
INSERT INTO nss_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pe isomwiy, ipa, <Pwi! Paratesah, matisan akorolo hu ndromwindriu mwomwan, pe andre akaloli hu wit kayapolon i. ");
INSERT INTO nss_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Konan, maldra kene koro lek kiyawule, kipoo kiya rahihini lang para poya wit. Kiro mwonen lang ara, yo andre kupwai kiya kili hu ndramat para poya wit toro: Andre akaloli hu ndromwindriu kimu, pe akawasi hapus-hapus kayawule para katimwiy, kihipwen akambultani wit pe akawiriy kisa nondriya kaisowa anandrinai to.> >> ");
INSERT INTO nss_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pwen Yesu itiyani nongan pwandritiye handra yi iya kili hu, ipa toro: <<Kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe peke mbuwa mastet sih mepo ndramat hamou iwiriy pe iya hasiy iya pingen. ");
INSERT INTO nss_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Konan peke mbuwa mastet ara mbuskau masih, iya peke mbuwa hu kei masih, hapeko kiro mwonen kilek, ara andre kirayah namandran pe kiramwaitini anandrinai masih para piyang pe kirayah kei hakou. Pwen pe hu norukan ngara hu kasa pe kapun yumwahu koho ndrandran.>> ");
INSERT INTO nss_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pe Yesu itiyani nongan pwandritiye handra yi iya kili hu, ipa toro: <<Kolo king mepo ngara kiro mu kiya aliy para kol paingan yang ara tehe yis mepo pihin hamou isuluyaniy iya palawa soyon iya, kipoo yis ara kisilihi palawa masih.>> ");
INSERT INTO nss_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ipohowe nongan masih aro iya kili hu ndramat soyon ara, ara iya nongan pwandritiye ko. Iro pohowe nongan masih iya kili hu, ara kintali nongan pwandritiye pwi. ");
INSERT INTO nss_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pwen pe nongan mepo poropet Yisayah kinpwai, ara irayah mannan toro: <<Andre kuwong kiya nongan pwandritiye ko. Andre kutiyani hu melit mepo hutora kohon ndrukoluw kinna, tandrohonga kol pwan irayah.>> ");
INSERT INTO nss_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pwen Yesu itali hu ndramat soyon ara, pe isong iya nondriya seu. Pe ndramiran hu husa kili yiy, pe hupa, <<Apwaingani ndroiyi nongan pwandritiye para hu ndromwindriu mwomwan ita piyang kisa leu kisa kili yowu.>> ");
INSERT INTO nss_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Pe isomwi hu, ipa, <<Yiy mepo ipiye peke wit hiyan, ara yiy Noru Ndramat. ");
INSERT INTO nss_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pe piyang, ara kol pwan, pe hu peke wit hiyan, ara hu ndramira kolo King Ngindrai mepo ngara kiro mu kiya aliy. Pe peke ndromwindriu mwomwan, ara hu ndramira Sinai. ");
INSERT INTO nss_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pe yoyou mepo ipiye hu peke ndromwindriu mwomwan, ara Sinai. Pe lang para poya anandrinai, ara lang nakiyahapwen. Pe yihu mepo nakapo anandrinai, ara hu angelou. ");
INSERT INTO nss_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pwen andre hu kaloli hu ndromwindriu mwomwan, pe andre hu katimwi hu kaya mwan. Pe tehen aliy opu, andre kirayah kiro mwonen lang para kol pwan nakiyahapwen. ");
INSERT INTO nss_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noru Ndramat andre kipwandrisa hu angelou tan kaya, pe kawiri hu hiyeh tora kolo King Ngindrai mepo ngara kiro mu kiya aliy, mepo hu ngara kambusi hu pakut mwomwan karayah, pe hu masih mepo ngara kandrihisani nongnan. ");
INSERT INTO nss_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pwen hu angelou andre kapiyani hu kaya nondriya noku mwan ngandrahan iya. Pe andre hu koro ara, pe koro rang malihu pe koro yandrisingi koltahu. ");
INSERT INTO nss_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pwen pe kiro mwonen lang ara, andre hu ndramat imwonen, ara andre nganahu karayah tehe ngana mwandrai koro nondriya kolo king mepo ngara kiro mu kiya aliy ta Tamahu. Hiyeh mandraingan, ara kihilingi nongan iye. ");
INSERT INTO nss_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pe kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe melit mepo kennen namandran ikohon ita pwan hambut. Pe iro mwonen ndramat hamou iya nimei, pwen ikulaniy paiwe. Pwen iyau iyapolo pwesai, pe ipopehei iya menmenan masih, pe iwiri singayai para aliy, pe isowani pwan ara. ");
INSERT INTO nss_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Pwen nakupwai porosih i, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe ndramat hamou para poya pehei mepo ita ten hu sowiy lahayan kennen namandran. ");
INSERT INTO nss_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pe iro mwonen iya kahi sih, mepo kennen ihohin iya, ara iya pe iyapo pehei iya menmenan masih, pe iwiri singayai para aliy, pe isowani sowiy lahayan kennen namandran ara. ");
INSERT INTO nss_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Pwen nakupwai porosih i, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe kahu hamou mepo hupiyaniy iya ndran makaiye, pe ilokihi hu ni handra-handra. ");
INSERT INTO nss_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pe iro mwonen kahu ara ipep, hu ndramat para poya ni, ara huluwiy iya paingan leng. Pwen humpwan pe hulokihi hu ni hiyan, huya nondriya hu ndrop, pe hupiyani hu ni mwomwan huyau. ");
INSERT INTO nss_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pe tehen aliy opu, andre kirayah kiro mwonen lang para kol pwan nakiyahapwen. Hu angelou andre hu kasa pe hu kahirani hu ndramat pwassin kaya mawen kili hu ndramat imwonen. ");
INSERT INTO nss_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pwen hu angelou andre kapiyani hu kaya nondriya noku mwan ngandrahan iya. Pe andre hu koro ara, pe koro rang malihu pe koro yandrisingi koltahu.>> ");
INSERT INTO nss_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pe Yesu isike hu, ipa, <<Lohonga wawu ileu iya hu melit masih kene iye, ndre pwi?>> Pe husomwi yiy, hupa, <<Ehe.>> ");
INSERT INTO nss_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pwen ipwai iya kili hu, ipa, <<Tehen tora ko, sehe ndramat para hinuwani nongan para pwahanou, mepo kinwiri nongan pomwanye para kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe mbukena seu hamou, mepo iwiri hu memelit kennen namandran huro mbulkura suwen husa ngawan, hu melit howen pe saken kene.>> ");
INSERT INTO nss_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pwen iro mwonen Yesu ipohowe hu nongan pwandritiye aro ihipwen, itali kol ara pe iyau. ");
INSERT INTO nss_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pwen imui iyarayah iya ndrohokolon imwonen, pe iro hinuwani hu ndramat iro nondriya yumwa mbultere tahu Yuta, pe huro lohonge ndrit. Pe husok, hupa, <<Ndramat aripo iwiri lohongai waison pe pwoke para kimbusi hu ndraikiya pwoke aro, ara iyau aleheh? ");
INSERT INTO nss_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yiy noru ndramat para puliya seu, ndre? Pe ngala tinan, ara Mariya, pe nalin hu, ara Yamis, Yosep, Simon, pe Yutas, ndre? ");
INSERT INTO nss_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pe pisun hu masih, ara huro surarou, ndre? Ndramat iye iwiri hu melit masih aro, ara iyau aleheh?>> ");
INSERT INTO nss_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pwen hu ndramat ara welehu imai tan. Hapeko Yesu ipwai iya kili hu, ipa, <<Poropet hamou kapa kiro ndrohokolon ndre kiro sura yowen hu, ara andre hu kantanuhuyani yiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pe yiy kinmbusi hu ndraikiya pwoke soyon kinto kol ara pwi, paratesah, yihu kanpwotisingi lohongahu pwi. ");
INSERT INTO nss_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nondriya hu lang ara, Herot, pohon para kol Kaliliy, ara ihilong titiye ta Yesu. ");
INSERT INTO nss_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pe ipwai iya kili ndramiran hu, ipa, <<Aro ara Yohanes Ndramat para Paptais! Yiy kinsa tine paiwe! Pwen ndroiyin ara ko, hu ndraikiya pwoke, ara hutora tayah kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mamu kinna, Herot ara kinpwandrisa hu ndramat, pe hu kanmbultuwe tahatini Yohanes pe kanwasi yiy, pe kaniyki yiy kinna nondriya kou, paratesah, Herot ara kinwiri nambuyu nalin Pilip, ngalan Herotiyas, iya nambuyun. ");
INSERT INTO nss_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Pe Yohanes, ara ngara kipomate Herot, kipa, <<Wou anwiri pihin ara, hapeko nongan para pwahanou, ara ipwai tehe nonombun para awiri yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pe Herot, ara pakitingundru Yohanes, hapeko inoh tahu ndramat, paratesah, hupa ndre Yohanes ara poropet hamou. ");
INSERT INTO nss_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iro lang para hu kalohongani lang mepo tina Herot imwalahiy tan, noru Herotiyas pihin isa pe iho ndran mbulmarahu. Pe Herot ara ipwes iya ndraniyan namandran iya. ");
INSERT INTO nss_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pwen irandrangan pe ipwatisingiy iya kili yiy tehe andre kiyki tesah mepo inamiliy pe isok yiy iya aliy. ");
INSERT INTO nss_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pwen Herotiyas iyki lohongai iya kili norun pihin, pe pihin ara, ipwai, ipa, <<Aiki paya Yohanes Ndramat Para Paptais, kiya pwelekei sih pe kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pwen king ihilingi nongan aro, pe ndriyan ipworu. Hapeko kintandrangan pwen iro mbulmara hu ndramat mepo kinpwanos hu husa namnam iyapolo yiy. Pwen pe ipwatisingiy tehe tesah mepo pihin ara isok yiy iya aliy, ara hu kaikiy opu kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pwen ipwai iya kili ndramat hamou para kipwai kiya kili hu ndram para hu kaya sondriti koyu Yohanes iro nondriya kou. ");
INSERT INTO nss_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pe huhuri payan, iro ndrita pwelekei sih, pe huikiy iya kili pihin ara. Pwen ikuniy iya kili tinan. ");
INSERT INTO nss_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pe hu ndramira Yohanes husa pe huhuri nombuwen pe huyaroniy. Pwen pe huya nese ndrainga Yesu. ");
INSERT INTO nss_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pe iro mwonen Yesu ihilong tesah kintayah kili Yohanes, pwen itali kol ara, pe ihis ndroi nokule ko, pe iyau iya kol hape lohowayin. Pe hu ndramat soyon iya huhulong, pe hutali hu kol ngawan pe hurukai huho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pwen Yesu ituh ndroi iya pwan, pe inime hu ndramat soyon iya, hu kansa mbultere hu huro. Pe koyun ara isikirani hu pe isopwoyani hu tahu mepo humwa. ");
INSERT INTO nss_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pe kol iro piyah pe ndramiran hu husa kili yiy, pe hupa, <<Kol aripo ara ndramat aliy pwi, pe mwandrai nakiya lai ara. Apwandrisa hu ndramat hu kayau, pwen pe andre hu kaya hu kol mendreheh pe hu kaya sou hayah anandrinahu.>> ");
INSERT INTO nss_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pe Yesu isomwi hu, ipa, <<Kinlahiy para hu kayau pwi. Akahang hu hapesah para hu kayan.>> ");
INSERT INTO nss_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pe husomwi yiy, hupa, <<Ndrinanohun mayimah pe ni malmou opu iripo kili yowu.>> ");
INSERT INTO nss_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pe Yesu ipwai, ipa, <<Akawiriy kisa kili yo aripo.>> ");
INSERT INTO nss_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pwen Yesu ipwai iya kili hu ndramat para hu kampwan ndrita ndromwindriu. Pe yiy iwiri ndrinanohun mayimah pe ni malmou ara, pe maran itandras iya kol paingan yang, pe itoholiy, pwen iramburingi ndrinanohun ara. Pe iykiy iya kili ndramiran hu, pe hutainganiy iya kili hu ndramat. ");
INSERT INTO nss_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pe hu ndramat masih kene, ara huyan pe isihi hu. Pwen ndritikehu mepo iro ndron, ara hunihiy iya hu ndrop mandropwa songui pe luhat. ");
INSERT INTO nss_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pe ndromwoya hu kamai mepo hunamnam ara, ara iho tehe mayipou (5,000). Hu pihin pe hu mbunah, ara kanndromwa hu pwi. ");
INSERT INTO nss_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hape pwi ko, Yesu ipwai iya kili ndramiran hu, para hu kahis kaya nondriya ndroi pe hu koro mu kili yiy kaya haroh. Pe yiy iro ndron, pe ipwai iya kili hu ndramat para hu kalon. ");
INSERT INTO nss_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pe hu ndramat ara, ara hu kannau, pwen yiy hamou opu ingas iya ngondron sih pe iya tohun. Pe iro mwonen kol iro piyah, yiy hamou opu iro ariya. ");
INSERT INTO nss_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pe ndroi, ara kintali leng pwen, pe kinna mwanan hape ndrokolo ndran makaiye. Pe nowei, ara iro mbuiwani ndroi, paratesah, nohai imum te ngondroi isa. ");
INSERT INTO nss_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pe lang iro mbungahiy, pe Yesu, ara iya pe ihorokai ndrita ndran makaiye iropo iya kili hu. ");
INSERT INTO nss_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hapeko ndramiran hu hunime yiy iro tokai ndrita ndran makaiye, pwen hunoh turuwehu. Pe huwayeh iyapolo nohowai, hupa, <<Mwomwoyou hamou yohou.>> ");
INSERT INTO nss_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hape pwi ko, Yesu ipwai iya kili hu, ipa, <<Wawu mbuna akanoh! Aripo yo kopu; ndriya wawu kipwoke.>> ");
INSERT INTO nss_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita isomwi yiy, ipa, <<Yapane, kapa ara wou, pwen apwai kisa kili yo para kurukai ndrita ndran kusa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pe Yesu ipwai, ipa, <<Asa.>> Pwen Pita itali ndroi iya pwan ndrita ndran, pe irikai iropo iya kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hapeko Pita inime nohai, pwen pe inoh pe iro somun. Pwen iyoh pwokeyan iya kili Yesu, ipa, <<Yapan, asopwat yo!>> ");
INSERT INTO nss_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hape pwi ko, nima Yesu iyah iya, pe isoli Pita, pe ipwai iya kili yiy, ipa, <<Wou lohongam ndrisiyon hape kopu. Paratapeh pe ahindrundru?>> ");
INSERT INTO nss_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pwen iro mwonen hilu his hilya nondriya ndroi, nohai ara imaito. ");
INSERT INTO nss_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pwen hu ndramat huro nondriya ndroi, ara huhuri ngalan, pe hupa, <<Ndrokonan masih, wou ara Noru Ngindrai Kamai.>> ");
INSERT INTO nss_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pwen yihu singondriti ndran makaiye huya haroh, pe husarayah husa kol hakol mendreheh ngalan Kennesaret. ");
INSERT INTO nss_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pe hu ndramat para kol ara, ara huyirowe Yesu, pwen hu pwanos nongan iya kene hu kol mepo huro pakeh. Pe huwiri ndramirahu masih kene mepo humwa, husa kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pe hurakamam iya kili yiy, para kipa hiyan para hu ndramat humwa, ara nimahu ko kiyahatek kiya payango koiwen. Pwen hu masih mepo nimahu iyahatek iya kili yiy, ara hungoh topwei. ");
INSERT INTO nss_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pwen hu Parisiy hayah pe hu ndramat para hinuwani nongan para pwahanou, ara huyau Yerusalem, pe husa kili Yesu pe husok yiy, hupa, ");
INSERT INTO nss_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Paratesah, pe ndramiram hu, ara hundrihisani kultuwayi tumburou hu? Kiro mwonen yihu nakanamnam, ara yihu konho sungani nimahu pwi!>> ");
INSERT INTO nss_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hapeko Yesu isomwi hu, ipa, <<Pe paratesah pe wawu ho ndruwa kultuwayi wawu mbukena wawu, pe wawu ndrihisani nongan para pwahanou ta Ngindrai? ");
INSERT INTO nss_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Paratesah, Ngindrai kinpa, <Wou ahaiyani tamam hilu tinam,> pe <hiyeh kiten ana taman ndre tinan, ara andre katingundrun kimat.> ");
INSERT INTO nss_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hapeko wawu, ngara wawu kapa, <Kapa ndramat hamou kiwong kiya kili taman ndre tinan, kipa, <<Tesah yo pakusopwat walu kaliy, ara yukyuk mepo kunhaiyaniy para kuikiy kiya kili Ngindrai,>> ");
INSERT INTO nss_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","pwen ndramat ara mbuna kihaiyani taman hilu tinan kiya aliy.> Pwen tehen tora ko, wawu ngara karanuhuyani kultuwayi tumbu wawu hu, pe wawu mbusi nongna Ngindrai, ara irayah tehe nongan mwaihei o. ");
INSERT INTO nss_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wawu ndramat para pwandrandraman! Yisayah ipwai imwonen pe ipwaingani kultuwayi wawu toro: ");
INSERT INTO nss_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<Yihu ndramat aro, ara hu haiyani yo iyau poho hu ko, hapeko ndriyahu, ara ita mawen kili yo. ");
INSERT INTO nss_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yihu tora hari ngolo, hapeko ara mwaihei opu; paratesah, hu hinonou tahu pe pwahanou tahu, ara iyau lohonga ndramat opu.>>> ");
INSERT INTO nss_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pwen Yesu iyoh hu ndramat soyon ara husa kili yiy, pe ipa, <<Akahilingiy, pe lohonga wawu kileu. ");
INSERT INTO nss_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sehe melit isong iya poho ndramat, ara kinlahiy para kimbusi yiy kirayah pwalan kiya mbulmara Ngindrai pwi, hapeko sehe melit mepo iyau pohon isa ngawan, ara kopu ilahiy para kimbusi yiy kirayah pwalan kiya mbulmara Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pwen ndramiran hu husa kili yiy pe husok, hupa, <<Wou akowu, tehe hu Parisiy huhulong nongan aro, pe imbusi welehu imai, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pe Yesu isomwi hu, ipa, <<Sehe kei mepo Tomo ita kol paingan yang kinhasiy pwi, ara andre kaloliy mangondron. ");
INSERT INTO nss_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Akatali hu. Yihu ara ndramat para luwani hu ndramat, hapeko marahu iyoh. Kapa ndramat hamou maran iyoh kiluwani ndramat hamou maran iyoh i, ara hilu malmou kene andre hilkayos kaya nondriya ngat.>> ");
INSERT INTO nss_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pe Pita ipwai, ipa, <<Apwaingani ndroiyi nongan pwandritiye ara, kisa leu kisa kili yowu.>> ");
INSERT INTO nss_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pe Yesu isok hu, ipa, <<Lohonga wawu ita nun manau, ndre? ");
INSERT INTO nss_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pe lohonga wawu kinileu pwi, ndre? Sehe melit isong poho ndramat, ara iya pura ndramat, pwen kamulan andre kisa ngawan nombuwen. ");
INSERT INTO nss_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hapeko sehe melit mepo isayau poho ndramat, ara iyau ndriya ndramat. Hu melit ara kopu ngara kimbusi ndramat kiya pwalan kiya mbulmara Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Hu lohongai pwassin mepo iro ndriya ndramat pe isa ngawan, ara tehen iye: lohongai para katingundru ndramat, lohongai para kapo pilah, lohongai para kapahana, nongan pwasoyou para tamwanye, pe kultuw para karasusut nongan pwasoyou kiya kili ndramat. ");
INSERT INTO nss_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hu melit tehen aro, ara ngara kimbusi ndramat kirayah pwalan kiya mbulmara Ngindrai. Hapeko kapa ansungani nimam pwi pe anamnam, ara kinlahiy para kimbusi wou arayah pwalan kiya mbulmara Ngindrai pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pwen Yesu itali kol ara, pe iya kol namandran hape mepo irakayani kol malkol Tayar pe Siton. ");
INSERT INTO nss_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pe pihi Kenaan hamou para kol ara, ara isa kili yiy pe iwayeh, ipa, <<Yapan, Noru Tepit, koyum kisikirani yo! Noru pihin, ara payit ikohis ita ndritan pe ngara kipwalngani yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pe Yesu kinsomwi nongan handra pwi. Pwen pe ndramiran hu husa kili yiy pe hurakokowani yiy, hupa toro: <<Apwandrisa yiy kiya mawen; paratesah yiy ara ita waiyani yoholai ndruwarou.>> ");
INSERT INTO nss_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hapeko Yesu isomwiy, ipa, <<Ngindrai ipwandrisa yo usa, ara para kuya kili hu sipsip para Yisrayel opu, mepo hu kansongsin.>> ");
INSERT INTO nss_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hapeko pihin ara, ara isa pe itukuruhu iya pwan mbulmara Yesu, pe ipa, <<Yapan, asopwat yo!>> ");
INSERT INTO nss_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pe Yesu isomwi yiy, ipa, <<Kinna hiyan para kawiri anandrinahu mbunah pe kapiyaniy kiya anahu mwiy, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pe pihin ara, ipa, <<Yapan, ara ndrokonan; hapeko hu mwiy, ara ngara hu kayan konkonu anandrinai mepo ngara kilon keyau ata namandran tahu yi.>> ");
INSERT INTO nss_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pwen Yesu isomwi yiy, ipa, <<Nam, lohongam ndrisiyon ara namandran iya! Tesah mepo ansok, ara anwiriy pwen.>> Pe norun pihin, ara ingoh iro mwonen paramwandrai ara. ");
INSERT INTO nss_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pwen Yesu itali kol ara, pe iyerokai ngilse Ndran Makaiye Kaliliy. Pwen iya paingan ngondron sih pe impwan aliy. ");
INSERT INTO nss_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pe hu ndramat soyo-soyon iya, ara husa kili yiy. Huwiri hu ndramat mepo ndrikahu mwomwan, pe hu ndramat mepo marahu iyoh, pe hu ndramat mepo ndruwihu ikou, pe hu ndramat mepo pohohu imum, pe hu ndramat mepo mwamwa handra-handra yi iro kili hu, pe husaiki hu huro pakeh ngondroka Yesu. Pe isopwoyani hu huya hiyan. ");
INSERT INTO nss_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pe hu ndramat ara, huro lohonge ndrit iro mwonen hunime hu ndramat pohomum ara huro wong, pe ndruwihu ikou, ara hurayah imwonen, pe ndrikahu mwomwan, ara huro tokai, pe marahu iyoh, ara hunimnim. Pwen huhuri ngala Ngindrai para Yisrayel. ");
INSERT INTO nss_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu iyoh ndramiran hu husa kili yiy, pe ipa, <<Koyu isikirani hu ndramat aripo. Hu topo sura yo lang maroyoh pwen, pe hapesah para hu kayan, ara pwi. Yo mbuwali para kupwandrisa hu kayau o mwaihei mamundruwahu, matisan marahu kayapalau pe hu kayayos kaya sai. >> ");
INSERT INTO nss_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pe ndramiran hu hupwai iya kili yiy, hupa, <<Kol aripo ndroisan, pe andre tukapo anandrinai kiro hape aleheh para kaikiy kiya ana hu ndramat soyo-soyon aripo?>> ");
INSERT INTO nss_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pe Yesu isok hu, ipa, <<Ndrinanohun ita kili wawu, ara masahayeh?>> Pe husomwi yiy, hupa, <<Ndrinanohun manandrtoyoh, pe noru ni lumou opu iripo.>> ");
INSERT INTO nss_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pwen Yesu ipwai iya kili hu ndramat soyo-soyon iya ara, para hu kampwan ndrita pwan. ");
INSERT INTO nss_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pwen iwiri ndrinanohun manandrtoyoh pe hu ni ara, pe irawuloh ihipwen, pwen iramburingiy, pe iykiy iya kili ndramiran hu. Pe hutainganiy iya kili hu ndramat. ");
INSERT INTO nss_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pe yihu masih ara hunamnam pe isihi hu. Iyamulan ndramiran hu hulokihi ndritikehu iya hu ndrop mandropwa andrtihat. ");
INSERT INTO nss_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pe ndromwoyahu kamai mepo hunamnam, ara mahaapou (4,000). Pe hu pihin pe hu mbunah, ara kanndromwa hu pwi. ");
INSERT INTO nss_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pe Yesu ipwandrisa hu ndramat soyon ara, huyau ihipwen, pwen ihis iya nondriya ndroi, pe iyau iyapwen te kol Makatan. ");
INSERT INTO nss_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hu Parisiy pe hu Satyusiy husa kili Yesu, para hu pakanohonou yiy, pe husok yiy para kipwaingani kaipisa pwoke handra kiyau kol paingan yang kiya kili hu. ");
INSERT INTO nss_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pe Yesu isomwi hu, ipa. <<Iro mwonen kol iro piyah, wawu ngara kapa, <Lang andre kiya hiyan, paratesah, yang ara ilam.> ");
INSERT INTO nss_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pe kiya mandroulang ara wawu ngara kapa toro: <Lang nepo, ara andre mbulou manohayen, paratesah, yang ara ilam pe mara kol ilokuh.> Pwen wawu pahasaniy para karanonoye nimnim para mara kol, hapeko akanlahiy para karanonoye hu kaipisa hu lang para mahapo pwi. ");
INSERT INTO nss_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hu hasap mepo kultuwayihu pwassin, pe hu kantali Ngindrai, ara yihu ngara kasok kaipisa pwoke. Hapeko yihu andre kannime hapesah pwi, kaipisa poropet Yonah kopu andre hu kanimei.>> Pwen Yesu itali hu pe iyau. ");
INSERT INTO nss_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pwen huyarayah huya haroh para ndran makaiye, pe ndramira Yesu hu, ara koyuhu imayit para kapo ndrinanohun. ");
INSERT INTO nss_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pe Yesu ipwai iya kili hu, ipa, <<Mara wawu kiro. Akoro rapapahan kiya yis tahu Parisiy pe Satyusiy.>> ");
INSERT INTO nss_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pwen huro panguluwaniy mwalingahu, pe hupa, <<Matisan ita wong tehen toro, paratesah, worou kanpo ndrinanohun pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pe Yesu ara ipahas iya tesah huro wong iya aliy, pe ipa, <<Wawu ndramat para lohongai ndrisiyon hape kopu, paratapeh pe wawu tora panguluwaniy mwalinga wawu tehe ndrinanohun pwi? ");
INSERT INTO nss_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lohonga wawu kinileu mapu ko? Wawu lohongani ndrinanohun mayimbut iya anahu ndramat mayipou, pe iyasura hu ndrop masahayeh wawu nihi ndritiken, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ndre wawu lohongani hu ndrinanohun manandrtipai iya anahu ndramat mahaapou, pe iyasura hu ndrop masahayeh wawu nihi ndritiken, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pwen paratapeh pe lohonga wawu kinileu mapu ko yeh. Yo ara uwong isa kili wawu, ara kinna ndrinanohun pwi, hapeko para akoro rapapahan kiya yis tahu Parisiy pe Satyusiy.>> ");
INSERT INTO nss_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pwen lohongahu isa leu tehe Yesu iro wong iya kili hu, ara para hu kapenani hu kiya yis mepo ngara kaikiy kiya ndrinanohun, ara pwi, hapeko iwong, ara para hu kapenani hu kiya hinonou tahu Parisiy pe tahu Satyusiy. ");
INSERT INTO nss_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pwen Yesu isa kol namandran hape Sisariya Pilipai, pe isok ndramiran hu, ipa, <<Hu ndramat, hupa ndre Noru Ndramat, ara hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pe husomwi yiy, hupa, <<Yihu hayah, ara hupa Yohanes Ndramat para Paptais, pe hu hayah, ara hupa Eliyah, pe hu hayah tahu yi, ara hupa Yeremayah ndre hamou tahu poropet para koluw.>> ");
INSERT INTO nss_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pe Yesu isok hu, ipa, <<Pe wawu, ara wawu pa ndre yo hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pwen Simon Pita, ara ipa, <<Wou, ara Mesayah—ndramat mepo Ngindrai kintakiniman para kisopwat hu ndramat—wou ara Noru Ngindrai Kamai mepo yiy mwalen.>> ");
INSERT INTO nss_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pe Yesu isomwiy, ipa, <<Lomwes, ara ita kili wou, Simon NdraYonah. Ndramat hamou kinpwainganiy kinsa kili wou pwi, hapeko Tomo ita kol paingan yang, ara yiy opu kinpwainganiy. ");
INSERT INTO nss_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pe yo upwai isa kili wou tehe wou, ara Pita, pe kiro ndrita pat iye, yo andre kupuli sios ato, pe poho karam para kolo kimat, ara andre kinlahiy para kiramwaitini sios ta Ngindrai pwi. ");
INSERT INTO nss_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yo andre kuiki hu kiy para kolo king mepo ngara kiro mu kiya aliy para kol paingan yang kisa kili wou. Pwen tesah awasiy kiro kol pwan, ara kol paingan yang kinwasiy. Pe kapa tesah ataliy kiro kol pwan, ara kol paingan yang kintaliy.>> ");
INSERT INTO nss_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pe Yesu ipwandrandrahaniy iya kili ndramiran hu, para hu mbuna kaya tiyaniy kiya kili hamou tehe yiy ara Mesayah. ");
INSERT INTO nss_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pe iro mwonen lang ara iya, Yesu iro ranonoye iya kili ndramiran hu tehe andre kiya Yerusalem, pe kiya nondriya hu nopwaran soyon kiro nima hu yapane kol, pe hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou. Pe andre hu katingundrun pe kiro mwonen lang maroyoh, andre kitine paiwe. ");
INSERT INTO nss_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pwen Pita iwiri yiy iya pwakin pe iro pomate yiy, iro pa, <<Yapan, ara pwi! Melit ara, andre kintayah kili wou pwi yoh!>> ");
INSERT INTO nss_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pe Yesu ipaiwani yiy iya kili Pita, pe ipa, <<Sinai, asaya ndruwo! Wou ndramat para apasingori yo. Wou anto ndruwa lohonga Ngindrai pwi, hapeko ata ndruwa lohonga ndramat opu.>> ");
INSERT INTO nss_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pwen Yesu ipwai iya kili ndramiran hu, ipa, <<Kapa sehe ndramat pakiho ndruwo, ara andre kipa pwi kiya tan mbukenan, pe kisap kei tondrih tan, pe kisa kiho ndruwo. ");
INSERT INTO nss_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Paratesah, hiyeh neren kiya mwoiwan mbukenan, andre mwoiwan kitali yiy. Pe hiyeh kilohongani yo, pe tunan yo kopu kitali mwoiwan, pwen andre kisopwat mwoiwan mbukenan. ");
INSERT INTO nss_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kapa ndramat hamou kiwiri hu memelit para kol pwan masih kiya mbukenan yiy, pe kiyamulan kimat pe kitali mwoiwan, pwen andre melit masih kene ara, andre kisopwat yiy tapeh? Sehe melit ndrokonan ndramat hamou ilahiy para kiykiy, para kisuliyani mwoiwan kimui? ");
INSERT INTO nss_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pe Noru ndramat andre kisa kiyasura nonowa ngana Taman, pe kiyasura hu angelou tan i. Pwen andre kiyki kenne ndramat hamou-hamou kiho ndruwa sehe melit mepo yiy kinmbusiy. ");
INSERT INTO nss_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Upwai ndrokonan isa kili wawu, tehe hayah mepo hutopo tine iye, ara andre hu kanhingorowe kimat kileh pwi, kipoo hu kanime Noru Ndramat kiro kolo king tan mepo ngara kiro mu kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pwen lang manonoh ihipwen, pe Yesu iwiri Pita, Yamis, pe Yohanes nali Yamis, pe iluwani hu huya ngondron sih paingan, pe yihu kopu, huya huro aliy. ");
INSERT INTO nss_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pe huya huro ara, pe nombuwe Yesu ipiy iro mbulmarahu. Pe kombuyen, ara ngannganan iya tehe mwandrai, pe koiwen ara nganan pallen tehe ngana lang. ");
INSERT INTO nss_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pwen iro mwonen ara, Mose pe Eliyah hilsarayah hilsa mbulmarahu, pe hilro wong iyasura Yesu. ");
INSERT INTO nss_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pe Pita ipwai iya kili Yesu, ipa, <<Yapan, hiyan para yowu koro iye. Kapa welem kiso, andre kupuli yopai matiwum—hawum atam, hawum ata Mose, pe hawum ata Eliyah.>> ");
INSERT INTO nss_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pe iro wong manau pe kokom hasai nganan iya, ara isa pe iramburuhi hu. Pe yoholai sahin iyau kokom, ipa, <<Iye ara Noru mepo ndriyo imbuluhi yiy; pe yo upwes iyatan namandran iya. Akahilingi yiy!>> ");
INSERT INTO nss_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pe iro mwonen ndramiran hu huhilingi nongan aro, ara hunoh turuwehu pe huyos te mbulmarahu iya pwan. ");
INSERT INTO nss_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hapeko Yesu isa, pe niman iyahatek iya kili hu, pe ipa, <<Akatine; wawu mbuna akanoh.>> ");
INSERT INTO nss_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pwen mara hu itandras, pe yihu kannime hamou pwi; Yesu ko iro. ");
INSERT INTO nss_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pe hurolai ngondron huropo husa pwan, pe Yesu ipwatisingiy iya kili hu, ipa, <<Wawu mbuna akatiyani sehe melit mepo wawu kannimei kiya kili hamou, kipoo Noru Ndramat kitine kimat.>> ");
INSERT INTO nss_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pe ndramiran hu husok yiy, hupa, <<Paratapeh pe hu ndramat para hinuwani nongan para pwahanou ngara hu kapwai, tehe Eliyah andre kisa kimu?>> ");
INSERT INTO nss_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Pe Yesu isomwi hu, ipa, <<Ndrokonan para aliy, ara Eliyah kisa pe andre kiramwaniyani hu melit masih kene. ");
INSERT INTO nss_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hapeko upwai isa kili wawu tehe, Eliyah, ara kinsa pwen, hapeko yihu kanyirowe yiy pwi. Pe humbusi melit masih mepo hulohonganiy para kambusiy kiya kili yiy. Pwen tehen tora ko, andre hu kaiki Noru Ndramat kiya nondriya ngandran.>> ");
INSERT INTO nss_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pwen ndramiran hu, ara lohongahu isa leu tehe yiy iro wong iya kili hu, ara iyata Yohanes Ndramat para Paptais. ");
INSERT INTO nss_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pwen iro mwonen yihu sarayah husa kili hu ndramat soyon, pe ndramat hamou isa pe itukuruhu iro mbulmara Yesu. ");
INSERT INTO nss_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Pe ipa, <<Yapan, koyum kisikirani noru kamai. Yiy ngara kilohori yiy, pe ngara kiya nondriya ngandran namandran iya. Pe lang hitun ngara kiyos kiya nondriya mwan ndre kiya nondriya ndran. ");
INSERT INTO nss_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pe uwiri yiy iya kili ndramiram hu, hapeko yihu kanlahiy para kasopwoyani yiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Pe Yesu isomwi hu, ipa, <<O wawu hasap para mahapo, ara wawu kanpwotisingi lohonga wawu pwi, pe lohonga wawu imwakaikai. Mwalaiheh pe andre kuro sura wawu ko? Pe maporosahayeh andre kuro kuni nopwaran tawawu ko yeh? Wawu kawiri mbunah kamai ara, kisa kili yo iye.>> ");
INSERT INTO nss_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pe Yesu ipomate payit ara, pe payit itali mbunah ara; pe iro mwonen payit itali yiy o, ingoh. ");
INSERT INTO nss_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pwen pe hu ndramira Yesu husa kili yiy nokule ko, pe husok yiy, hupa, <<Paratapeh pe yowu kanlahiy para karasses payit ara, kiyau pwi?>> ");
INSERT INTO nss_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Pe ipwai iya kili hu, ipa, <<Paratesah, wawu pwotisingi lohonga wawu, ara hape ko. Yo upwai ndrokonan isa kili wawu, kapa lohongai ndrisiyon tawawu ara mendreheh tehe peke mbuwa mastet sih, pwen wawu lahiy para akapwai kiya kili ngondron iye, akapa, <Atali iye pe aya yoro> pwen andre kises. Pe melit masih, ara andre wawu kawenei para akambusiy.>> ");
INSERT INTO nss_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pwen Yesu iyasura ndramiran hu husa wule husa kol namandran hape Kaliliy. Pe ipwai iya kili hu, ipa, <<Andre hu karatuni Noru Ndramat, pe hu kaiki yiy kiya nima hu ndramat. ");
INSERT INTO nss_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pe andre hu katingundrun kimat, pe kiro mwonen lang toyoh andre kitine paiwe.>> Pe ndramiran hu huhilingiy pe ndriyahu iporu. ");
INSERT INTO nss_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pe iyamulan Yesu iyapolo ndramiran hu huyarayah huya kol Kapernawum, pe hu ndramat para poya takis mepo ngara hu kapo takis para kisopwat yumwa totohun namandran, ara husa kili Pita pe husok, hupa, <<Ndramat para hinonou ta wawu, ngara kiyki takis para yumwa totohun namandran, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pe Pita isomwi yiy, ipa, <<Ehe, ngara kimbusiy.>> Pe iro mwonen Pita isong isa nondriya seu, Yesu iwong imu, ipa, <<Simon, wou alohonganiy tapeh? Yihu king para kol pwan, ara yihu ngara kapo takis kiyau kili hu noruhu mbukenahu, ndre kiyau kili hu ndramat hayah i?>> ");
INSERT INTO nss_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pe Pita isomwi Yesu, ipa, <<Andre hu kapo takis kiyau kili hu ndramat hayah.>> Pe Yesu ipwai iya kili yiy, ipa, <<Pwen, hu noruhu, ara andre hu kanyuk takis pwi. ");
INSERT INTO nss_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hapeko matisan tukambusi hu, pe welehu kaya mai; pwen pe aya ndran makaiye pe aya piye kou. Pwen ni mepo akowiy imu ara, awiriy pe atipe pohon, pe andre anime sombule pat para takis, ilahiy ndramat malmou. Awiriy pe ayaikiy kiya kili hu ndramat para poya takis, para sowa takis atatalu.>> ");
INSERT INTO nss_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pe iro mwonen paramwandrai ara, hu ndramira Yesu, ara husa pe husok yiy, hupa, <<Hiyeh ndrokonan, ara ihohin iya, ita kolo king mepo ngara kiro mu kiya aliy para kol paingan yang?>> ");
INSERT INTO nss_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pwen iyoh mbunah hamou mendreheh isa, pe iyki yiy iro tine mwalingahu. ");
INSERT INTO nss_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Pe Yesu ipwai, ipa, <<Yo upwai ndrokonan isa kili wawu, kapa akantapihiye wawu pe akantayah tehe hu mbunah mendreheh pwi, pwen andre akanlahiy para akasong kaya kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pwen tehen tora ko, kapa hiyeh kiyki yiy kiya pwan tehe mbunah iye, ara ihohin iya, ita kolo king mepo ngara kiro mu kiya aliy para kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pe hiyeh kirawulohani mbunah hamou mendreheh tehen iye kiya ngolo, ara irawulohani yo. ");
INSERT INTO nss_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hapeko kapa hiyeh kimbusi hamou tahu mbunah mendreheh iye, mepo ipwotisingi lohongan isa kili yo, para kiyos kiya pakut mwomwan, ara iya hiyan para hu kandruyani pat sih namandran kiho koyun, pe kapiyani yiy para kimut pe kiyuh kiya mbulu mwekeu. ");
INSERT INTO nss_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Toimwa hu ndramat para kol pwan, nopwaran ita kili hu, iyau hu melit mepo ngara kambusi hu ndramat kayos kaya pakut mwomwan! Hu melit tehen tora, ara andre hu kasa. Hapeko toimwa sehe ndramat mepo imbusiy, pe hu melit tehen tora hurayah! ");
INSERT INTO nss_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kapa nimam ndre ndrikam kimbusi wou, pe ayos aya pakut mwomwan, pwen asondritiy pe apiyaniy kiyau. Iya hiyan masih para awiri taleh kinto-kinto, kiyapolo nombuwem mwomwan ndre ndrikam mwomwan. Matisan nimam malkai pe ndrikam malkai kiro hiyan, hapeko hu kapiyani wou kiya mwan mepo kinoho mat pwi. ");
INSERT INTO nss_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pe kapa maram sih kimbusi wou, pe ayos aya pakut mwomwan, ara hiyan para atangihiy pe apiyaniy kiyau. Iya hiyan masih para awiri taleh kinto-kinto, kiyapolo maram sih o. Matisan maram malwoh kiro hiyan, hapeko hu kapiyani wou kiya nondriya ngat mepo mwan ita yat aliy. ");
INSERT INTO nss_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ndriya wawu mbuna kitayi hu mbunah mendreheh iye. Paratesah, yo upwai isa kili wawu tehe hu angelou tahu, ara lang masih ngara hu koro mbulmara Tomo ita kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wawu lohonganiy tapeh? Kapa ndramat hamou masipsip tan masangat, pe hamou tahu kiyasongsin, pwen tehen tapeh? Andre kitali hu androsongui pe androsomou hu koro ngondron, pe kiyaten hamou mepo iyasongsin, ndre? ");
INSERT INTO nss_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pe kapa kiya kahiy, yo upwai ndrokonan isa kili wawu, tehe hu androsongui pe androsomou, ara ipwesani hu ihomwak o, hapeko kapa sipsip mepo iyasongsin ara kimui, ara andre kipwes namandran iya. ");
INSERT INTO nss_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tehen tora ko, Tama wawu iyera kol paingan yang, ara mbuwalin para hamou tahu mendreheh iye, kiyasongsin pe kitali yiy. ");
INSERT INTO nss_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kapa nalim hamou kimbusi kultuw mwomwan kisa kili wou, ara aya, pe apwaingani mwomwan atan, kiho mwalinga walu kopu. Pwen kapa kihilingi wou, ara hiyan; anwiri nalim kinimui. ");
INSERT INTO nss_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Hapeko kapa mbuwalin para kihilingi wou, pwen awiri ndramat hamou ndre malmou i, hilkaya suram; pwen <titiye para tamwanye masih ara, ara ndramat malmou ndre matimou, ara andre hu karayah ndramat para kapwokeyani nongan.> ");
INSERT INTO nss_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pe kapa kihimbuwalin para kihilingi hu, apwai kiya kili hu ndramat para sios. Pe kapa kinhilingi nongnahu pwi yi, pwen aro nime yiy, ara tehe ngara aro nime ndramat hamou mepo tanan ta Yapan pwi, pe tehe hamou ndramat para poya takis. ");
INSERT INTO nss_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Pwen upwai ndrokonan isa kili wawu, tesah akawasiy kiro kol pwan, ara kol paingan yang kinwasiy. Pe tesah wawu kataliy kiro kol pwan, ara kol paingan yang kintaliy. ");
INSERT INTO nss_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pe nakupo sura nongno yi, tehe kapa walu malmou koro kol pwan, lohonga walu kiro handra ko pe alkasok hapesah, ara andre Tomo ita kol paingan yang kimbusiy tehen aliy opu kisa kili walu. ");
INSERT INTO nss_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pe kapa hilu malmou ndre hu matimou hu kasa rawurehu kiya ngolo, ara utasura hu.>> ");
INSERT INTO nss_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pwen Pita isa kili Yesu pe isok, ipa, <<Yapan, maporosahayeh imwonen andre kutali hu pakut mwomwan ta nali mepo imbusiy isa kili yo? Matisan kiya maporoandrtisap?>> ");
INSERT INTO nss_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pe Yesu isomwi yiy, ipa, <<Upwai isa kili wou, tehe maporoandrtisap pwi; hapeko maporoandrtingui pe andrtisap. ");
INSERT INTO nss_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pwen tehen tora ko, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe king hamou nakiramwanye nahanah tan kiya polo hu ndramat para poya mbulyan. ");
INSERT INTO nss_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pe iro mwanye nahanah tan, pe huwiri ndramat hamou nahanah tan iramwaitini mapwesi isa kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pe ndramat ara kinlahiy para kipo soiwi nahanah tan pwi. Pwen namandran tan ipwatisingiy tehe yiy, nambuyun, norun, pe menmenan masih kene, ara andre kapo pehei kaliy para kipo soiwi nahanah tan. ");
INSERT INTO nss_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pwen ndramat para poya mbulen ara, ara itukuruhu iya mbulmaran, pe irakamam iya kili yiy ipa, <Alonge hape na, pwen andre kupo soiwi melit masih kimui.> ");
INSERT INTO nss_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pwen namandran tan, ara koyun isikirani ndramiran para poya mbulyan ara. Pwen itali nahanah tan iyau o mwaihei, pe itali ndramiran ara iyau. ");
INSERT INTO nss_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Hapeko iro mwonen ndramat para poya mbulen ara iya ngawan, pwen iya kahi ndramat hamou para poya mbulen iyawule, mepo nahanah tan iro kili yiy ara masangat. Pe imbultuwe tahatini yiy pe niman indrek koyun pe irakekeyani yiy, ipa, <Apo soiwi nahanah tam iripo kili yo!> ");
INSERT INTO nss_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pwen ndramat para poya mbulen ara, ara itukuruhu iya kili yiy pe irakamam, ipa, <Alonge hape na, pwen andre kupo soiwin kimui.> ");
INSERT INTO nss_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hapeko yiy ara mbuwalin. Pwen pe iwiri ndramat para poya mbulen hamou ara, pe iyaiki yiy iya nondriya kou para kiro ara, kipoo kiyki nahanah tan. ");
INSERT INTO nss_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pwen pe hu ndramat para poya mbulen hayah i, ara hunime tesah kintayah, pe ndriyahu isin namandran iya. Pwen huya kili namandran tahu pe huya tiyani melit masih mepo kintayah ara. ");
INSERT INTO nss_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pwen namandran ara iyoh ndramat para poya mbulyan ara, isa nondriyan. Pe ipa, <Wou pwassi ndramat para poya mbulen! Yo kuntali nahanah tam masih, paratesah, arakamam isa kili yo.> ");
INSERT INTO nss_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Koyu isikirani wou, pwen tehen aliy opu, paratesah, pe koyum kinsikirani ndramat mepo walu ropo mbulen iyawule, ara pwi? ");
INSERT INTO nss_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pe namandran tan ndrinan ilokuh, pe iyki yiy iya nima hu ndramat para memerani kou, para hu kaiki nopwaran kiya kili yiy, kipoo, kiyki nahanah tan topwei. ");
INSERT INTO nss_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pwen pe kapa ngara atali hu pakut mwomwan ata nalim, kiyau ndriyam imwonen, pwen tehen tora ko, Tomo ita kol paingan yang andre kimbusiy tehen aliy opu, kisa kili wawu hamou-hamou.>> ");
INSERT INTO nss_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pwen Yesu ipohowe nongnan aro ihipwen, pe itali kol namandran hape Kaliliy, pe iya kol namandran hape Yutiya, ita haroh para Ndran Yortan. ");
INSERT INTO nss_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pe hu ndramat soyo-soyon iya, ara huho ndruwan, pe isopwoyani hu iro hape ariya. ");
INSERT INTO nss_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pwen hu Parisiy hayah husa kili yiy para kanohonou yiy. Pwen husok, hupa, <<Nongan para pwahanou ta Ngindrai, ara ipa hiyan para ndramat hamou kitali nambuyun kiya sehe lohongan?>> ");
INSERT INTO nss_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pe Yesu isomwi hu, ipa, <<Wawu kannime Nongna Ngindrai mepo kinpwai pwen, kinpa, <Koluw-koluw kinna, Ngindrai imangsani hu ndramat malpat—kamai pe pihin,> ndre pwi? ");
INSERT INTO nss_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pwen Ngindrai ipwai, ipa, <Pwen tunan ara ko, andre kamai kitali taman hilu tinan, pe hilu pihin tan andre karayah hapat, pe nombuwe hilu kirayah hamou o,> ndre? ");
INSERT INTO nss_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pwen pe tehen tora ko, hilu konto tehe malmou pwi; nombuwe hilu kintayah hamou o. Pwen tesah mepo Ngindrai kiniykiy kinna wule, ara ndramat mbuna kimbusi mwalinga hilu kimut.>> ");
INSERT INTO nss_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pe hu Parisiy husok, hupa, <<Pwen paratapeh pe Mose ipwandrandrahaniy, tehe ndramat hamou andre kiratuluwi nongan para yesou kimut, pe kiykiy kiya kili pihin tan, pe kirasse pihin tan kiyau?>> ");
INSERT INTO nss_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pe Yesu isomwi hu, ipa, <<Mose ipa hiyan para akatali pihin ta wawu hu, paratesah, ndriya wawu ara ipwoke. Hapeko koluw-koluw kinna, ara tehen tora pwi. ");
INSERT INTO nss_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yo upwai isa kili wawu, kapa sehe kamai kitali pihin tan, pe kiya yesou kiya kili pihin hamou, ara imbusi kultuw para pilah. Hapeko, kapa pihin tan kinpo pilah kimu, pwen tunan ara ko, ilahiy para kitali pihin tan, pe mwomwan, ara kinto kili yiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pwen hu ndramira Yesu, ara hupwai iya kili yiy, hupa, <<Kapa ara ndroiyi lohongai para kamai pe pihin kayesou, pwen hiyan masih para kona yesou.>> ");
INSERT INTO nss_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pe Yesu isomwi hu, ipa, <<Yihu ndramat masih andre hu kanlahiy para hu kapa hiyan kiya nongan iye pwi. Hapeko iya hiyan, iya kili hu ndramat opu mepo Ngindrai kiniyki nongan ara. ");
INSERT INTO nss_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pe hu ndramat hayah, ara tinahu imwalahiy tahu, pe namiliwa pihin, ara kinto kili hu pwi. Pe hu hayah tahu, ara hu ndramat hurasangi hu, pe namiliwa pihin, ara kinto kili hu pwi yi. Pe hu hayah i, ara mbuwalihu para kayesou, paratesah, hunamiliy para hu koro ko para poya mbulya kolo king mepo ngara kiro mu kiya aliy para kol paingan yang. Pe hiyeh ilahiy para kipa hiyan kiya nongan iye, ara kipa hiyan.>> ");
INSERT INTO nss_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pwen huwiri hu mbunah mendreheh huya kili Yesu para niman kiya ndrita hu, pe kitoholi hu. Hapeko ndramiran hu, ara hupomate hu mepo huwiri hu mbunah huya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pe Yesu ipwai, ipa, <<Wawu katali hu mbunah kasa kili yo, pe wawu mbuna akakaituwe hu. Paratesah, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara atahu ndramat tehe hu mbunah aro.>> ");
INSERT INTO nss_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pe iyki niman iya ndritahu, pe itoholi hu ihipwen, pwen itali hape ara, pe iyau. ");
INSERT INTO nss_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pwen ndramat hamou isa kili Yesu pe isok yiy, ipa, <<Ndramat para hinonou, yo andre kumbusi sehe kultuw hiyan, pwen pe andre kuwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Pwen Yesu isomwi yiy, ipa, <<Paratesah, pe wou asok yo iya melit hiyan? Ngindrai hamou opu, ara yiy hiyan. Kapa nawiri taleh kinto-kinto, pwen oho ndruwa hu nongan para pwahanou ata Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pe ndramat ara, ipwai, ipa, <<Hu sehe nongan para pwahanou eh?>> Pe Yesu isomwi yiy, ipa, << <Mbuna atingundru ndramat kimat, pe mbuna apo pilah, pe mbuna apahana, pe mbuna apwandrandraman, ");
INSERT INTO nss_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pe aranuhuyani tamam hilu tinam, pe ndriyam kimbuluhi hiyeh para pakeh kili wou tehe ndriyam ngara kimbuluhi wou mbukenam.> >> ");
INSERT INTO nss_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pe ndramat ara ipwai, ipa, <<Yo ngara kuho ndruwa hu nongan para pwahanou masih ara; pe tesah hira ndron para andre kumbusiy i?>> ");
INSERT INTO nss_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Pe Yesu isomwiy, ipa, <<Kapa wou anamiliy para narayah imwonen masih tehe Ngindrai inamiliy, ara ayapo pehei kiya hu melit tam masih, pe awiri singayai para aliy, pe atainganiy kiyata hu ndramat mepo hundroisiy, pe andre awiri hu melit mwayih kennen namandran, ita kol paingan yang. Kihipwen, asa oho ndruwo.>> ");
INSERT INTO nss_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pe iro mwonen ndramat aro ihilingiy, iyau iyapolo ndriya pworu, paratesah, menmenan, ara hitun iya. ");
INSERT INTO nss_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pwen Yesu ipwai iya kili ndramiran hu, ipa, <<Yo upwai ndrokonan isa kili wawu, tehe ingandrah para ndramat hamou menmenan soyon kisong kiya nondriya kolo king mepo ngara kiro mu aliy para kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pe upwai isa kili wawu paiwe, tehe ingandrah para kamel hamou kisong kiya ngara kannih sih, hapeko ingandrah masih, para ndramat hamou menmenan soyon, kisong kiya nondriya kolo King Ngindrai mepo ngara kiro mu kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pe iro mwonen ndramiran hu huhilingi nongan aro, ara lohongahu indrap namandran iya, pe husok, hupa, <<Kapa tehen tora, pwen andre hiyeh ndrokonan kilahiy para kiwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pe Yesu maran itis tahu, pe ipa, <<Hu ndramat, ara kanwenei pwi, hapeko Ngindrai, ara iwenei para kimbusi melit masih kene.>> ");
INSERT INTO nss_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pe Pita isomwi yiy, ipa, <<Yowu kantali hu melit masih para yowu koho ndruwam! Andre yowu kawiri tesah hiyan kiyau aliy yeh?>> ");
INSERT INTO nss_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Pe Yesu ipwai iya kili hu, ipa, <<Yo upwai ndrokonan isa kili wawu, tehe kiro lang para melit masih hu nakarayah howen, kiro mwonen Noru Ndramat kirompwan ndrohonoku mipwan ta king tan, mepo nonowan iya, ara wawu mepo ngara akoho ndruwo, ara andre wawu kampwan sura yo, koro ndrohonoku pwanpwan ta king songui pe luwoh, pwen andre wawu karayah ndramat para tamwanye, pe akaramwanye nongan tahu ndraye hu Yisrayel songui pe lupat. ");
INSERT INTO nss_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pe tunan yo ko, sehe ndramat mepo kitali suwen, ndre nalin, ndre pisun, ndre taman, ndre tinan, ndre norun, ndre pingen, ara andre kiposura melit tan maporosangat, pe andre kiwiri taleh kinto-kinto. ");
INSERT INTO nss_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hapeko hu ndramat soyon hutora mu, ara andre hu kaya mulan; pe hu ndramat soyon hutora mulan, ara andre hu kaya mu. ");
INSERT INTO nss_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Paratesah, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe mbukena pwan hamou mepo iyau iya ngawan makohuping, para kiyapo hu ndramat para hu kayapo mbulen kaya pinge wain tan. ");
INSERT INTO nss_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yiy ipa hiyan para kisowani hu, kiya kenne ndramat hamou-hamou para lang sih sesek. Pwen ipwandrisa hu huya nondriya pingen. ");
INSERT INTO nss_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pe paramwandrai ara iho tehe mandrosih, pe iya ngawan pe inime hu ndramat hayah, ara huro tine ndrohopah pe hu kanmbusi hapesah pwi. ");
INSERT INTO nss_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pe ipwai iya kili hu, ipa, <Wawu yi, ara akayapo mbulen kaya pinge wain to, pe andre kusowani wawu, ara kiwene mbulya wawu ko.> ");
INSERT INTO nss_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pwen pe huyau huya. Pe paramwandrai iho ndrokolo lang, pe namandran ara iyau iya, pe paramwandrai iya iho tehe maroyoh, pe iyau iya paiwe yi, pe imbusiy tehen aliy opu, tehe mamu kinmbusiy. ");
INSERT INTO nss_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pe iya piyahon, paramwandrai iho tehe mayimah, pwen iya ngawan, pe inimei tehe hu hayah i, ara huro tine ko mwaihei. Pe isok hu, ipa, <Paratapeh pe lang sih sesek wawu topo tine ko mwaihei?> ");
INSERT INTO nss_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pe husomwi yiy, hupa, <Paratesah, hamou kinsa sok yowu para kayapo mbulen pwi.> Pwen ipwai iya kili hu, ipa, <Kiya, wawu yi, akayapo mbulen kaya pinge wain to.> ");
INSERT INTO nss_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pwen kol ipiyah pe mbukena pinge wain, ara ipwai iya kili ndramat mepo imu iya pohomara mbulyan ara, ipa, <Ayoh hu ndramat para poya mbulen hu kasa, pe aiki kenne hu kiya kili hu. Aiki kenne hu mepo husa mulan kimu na, pwen aiki kenne hu mepo husa mu.> ");
INSERT INTO nss_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pwen hu ndramat para poya mbulen mepo husapo mbulen piyahon, paramwandrai iho tehe mayimah, ara hamou-hamou tahu iwiri kennen, ara tehe kenne ndramat para lang sih sesek. ");
INSERT INTO nss_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pwen pe yihu mepo namandran iwiri hu husapo mbulen imu, ara husa pe koyu hu isosoyo, pe hupa ndre sowahu andre kihohin. Hapeko hamou-hamou tahu, ara iwiri kennen tehe ata ndramat hamou ngara kipo mbulen para lang sih sesek. ");
INSERT INTO nss_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pe iro mwonen huwiri kenne hu, ara hurakokowai ana mbukena pwan ara. ");
INSERT INTO nss_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Pwen hupa, <Hu ndramat mepo husapo mbulen mulan, ara hupo mbulen iho nondriya paramwandrai sih opu. Hapeko aniyki kennehu, ara ihisoule ko tehe kenne yowu, mepo yowu po mbulen ngandrahan iya, pe mwandrai isingi yowu.> ");
INSERT INTO nss_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pe isomwi hamou tahu, ipa, <Kowase, yo kunpakarawani wawu pwi. Talu pa hiyan para apo mbulen, pe kusowani wou kiya kenne ndramat para lang sih sesek, ndre? ");
INSERT INTO nss_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kiya, awiri kennem pe ayau. Unamiliy para kuiki kenne ndramat mepo isa mulan, ara kihisoule ko tehe kunuikiy pwen kinsatam. ");
INSERT INTO nss_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yo ara mbukena singayai, pe tesah unamiliy para kumbusiy kaliy, ara andre kumbusiy opu. Yo pahalo ko, pwen pe wou amaimai ano, ndre?> ");
INSERT INTO nss_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pwen pe hu hiyeh hutora mulan, ara andre hu kaya mu, pe hu hiyeh hutora mu, ara andre hu kaya mulan.>> ");
INSERT INTO nss_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pwen Yesu iropo iya paingan Yerusalem, pe iwiri ndramiran hu songui pe lumou huya pwakin hape, pe ipwai iya kili hu, ipa, ");
INSERT INTO nss_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Akahilingiy! Worou nakaya paingan Yerusalem, pe andre hu karatuni Noru ndramat kiya nima hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou. Pe andre hu kaiki yiy kiya nongan, pe kamburi nongan para katingundrun kimat, ");
INSERT INTO nss_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","pe andre hu kaiki yiy kiya kili hu Ndramira Lah, para hu kapwasimiri yiy pe kamwiri yiy, pe karapaingi yiy kiya kei tondrih. Pe kiro mwonen lang toyoh, ara andre kisa tine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pwen tina noru Sepetiy kamai malmou, ara isa kili Yesu iyapolo norun hilu, pe itukuruhu iya pwan mbulmaran pe isok melit kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pe Yesu isok yiy, ipa, <<Wou anamili sehe melit?>> Pe tina hilu ipa, <<Apa hiyan para hamou ta noru hilu kamai malmou iye, ara hamou kimpwan kiyapwen te nimam mot pe hamou kiyapwen te nimam kamou kiro kolo king tam mepo ngara aro mu kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pe Yesu ipwai iya kili hu, ipa, <<Wawu kowu tesah wawu tora sok iya aliy ara. Walu lahiy para kayin kiya pweniu mepo pakeh nakuyin kiya aliy?>> Pe hilsomwiy, hilpa, <<Youlu lahiy.>> ");
INSERT INTO nss_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Pwen pe Yesu ipwai iya kili hilu, ipa, <<Ndrokonan tehe walu andre kayin kiya pweniu mepo nakuyin kiya aliy. Hapeko para walu kampwan kapwen te nimo mot ndre kamou, ara yo kunlahiy para kusomwi walu pwi. Hu ndrohonoku pwanpwan ara, ara atahu mepo Tomo kinmwaniyaniy pwen.>> ");
INSERT INTO nss_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pe iro mwonen ndramiran hu songui ara, huhilingi nongan aro, ara ndrinahu ilokuh ta hilu malmou mepo hilnali hilu ara. ");
INSERT INTO nss_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pwen Yesu iyoh hu masih husa wule kili yiy, pe ipwai iya kili hu, ipa, <<Wawu pahasaniy tehe hu yapane hu Ndramira Lah, ara ngara hu karandrokomat ana ndramirahu, pe hu pohon tahu, ara ngara hu karakekeyani hu, iyapolo pwoke nopwaran, para hu koho ndruwa nongnahu. ");
INSERT INTO nss_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hapeko mbuna kirayah tehen aliy mwalinga wawu. Hiyeh tawawu pakirayah namandran, ara andre kirayah ndramat para poya mbulya wawu. ");
INSERT INTO nss_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pe hiyeh ta wawu pakimu ta wawu masih, ara andre kirayah ndramat para pwandrendres tawawu ko mwaihei, ");
INSERT INTO nss_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","iro mwonen tehe Noru Ndramat kinsa, ara para hu ndramat kasopwat yiy pwi; hapeko yiy isa, ara para kisopwat hu ndramat, pe para kiyki mwoiwan para kikonuhi hu ndramat soyon hu kamui.>> ");
INSERT INTO nss_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pe iro mwonen Yesu iyapolo ndramiran hu, ara hu nakatali Yeriko, hu ndramat soyon iya huho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pe hilu ndramat malmou mara hilu iyoh, ara hilrompwan ngilse sai, pe iro mwonen hilu hilingi Yesu iropo isayau, pwen hilu yoh, hilpa, <<Yapan, Noru Tepit, koyum kisikirani youlu!>> ");
INSERT INTO nss_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pe yihu ndramat ara, ara huhilingi hilyoh, pe hupomate hilu para hilu kamun opu. Hapeko hilu wayeh iya namandran iya, hilpa, <<Yapan, Noru Tepit, koyum kisikirani youlu!>> ");
INSERT INTO nss_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pwen Yesu iro tine, pe iyoh hilu pe isok, ipa, <<Walu namiliy para kumbusi tesah kisa kili walu?>> ");
INSERT INTO nss_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pe hilu somwiy, hilpa, <<Yapan, youlu namiliy para mara youlu kileu.>> ");
INSERT INTO nss_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pwen Yesu koyun isikirani hilu, pe iyki niman iyahatek iya mara hilu. Pe hape pwi ko, mara hilu ileu, pe hilu ho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pe Yesu iyapolo ndramiran hu, huropo husa pakeh Yerusalem, pe husarayah husa kol Petpake iro Ngondron para hu Holip. Pwen Yesu ipwandrisa ndramiran malmou, ");
INSERT INTO nss_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","pe ipwai iya kili hilu, ipa, <<Walu kaya kol mendreheh yoho mu kili walu, pe hape pwi ko, andre walu kanime tongkiy hamou hu kanwasiy pwen ita, iyapolo norun ita ndrahasan. Alkalombuli hilu pe alkaluwi hilu kasa kili yo. ");
INSERT INTO nss_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pe kapa ndramat hamou kipa hapesah kisa kili walu, alkapwai kiya kili yiy tehe, Yapan inamiliy, pe hape pwi ko, andre kipwandrisa hilu kasa.>> ");
INSERT INTO nss_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Melit aro irayah para nongan mepo poropet kinpwai, andre kirayah mannan, ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Akapwai kiya kili hu ndramat para kol namandran Sayon, akapa, <Akanimei, King tawawu itapo isa, nakisa kili wawu. Kultuwayin waison, pe itampwan ndrita tongkiy hamou, ita ngaplani noru tongkiy hamou.> >> ");
INSERT INTO nss_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pwen ndramiran malmou, ara hilyau, pe hilya mbusi tesah mepo Yesu kinpomwanye pwen kinna kili hilu. ");
INSERT INTO nss_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pe ndramiran hilu, hilu luwi tongkiy iyapolo norun hilsa, pe hilpwalani hu koyau ta hilu iya ndrita tongkiy malmou ara, pe Yesu iya impwan ndrita hilu. ");
INSERT INTO nss_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pe hu ndramat soyon iya, ara hupwalani hu koyau tahu huye ndrita sai. Pe hu hayah tahu yi, ara husondriti hu ndrandra hu kei, pe humwaniyani hu huye ndrita sai. ");
INSERT INTO nss_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pe hu ndramat soyon mepo huho mu kili yiy, pe hu hiyeh huho ndruwan, ara huwayeh, hupa, <<Hosanna, kahari ngala Noru Tepit!>> <<Lomwes ita kili yiy mepo isa iya ngala Yapan!>> <<Hosanna, kahari ngala Ngindrai iyera paingan masih!>> ");
INSERT INTO nss_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pe iro mwonen Yesu isong iya nondriya Yerusalem, yihu ndramat masih kene para kol namandran ara, ara pwesai namandran iya iwiri hu, pe huro sok, hupa, <<Aripo hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pe hu ndramat soyon ara, ara husomwi hu, hupa, <<Aripo, ara Yesu, yiy ara poropet para kol ngawan Nasaret ita nondriya kol Kaliliy.>> ");
INSERT INTO nss_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pe Yesu isong iya nondriya kowa yumwa totohun namandran, pe irasses hu ndramat huropo pehei, pe huro sousou nondriyan. Pe itipiyani hu keyau tahu ndramat huro sulye sombule pat, pe itipiyani hu pwapwai tahu mepo huropo pehei iya hu pai. ");
INSERT INTO nss_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pwen pe ipwai iya kili hu, ipa, <<Pwayan kinpwai tehe, <Suwe, ara hu ngara kapohowei Seu para katohun.> Hapeko wawu kanmbusiy kintayah ndrohona kokohon tahu ndramat para pahana.>> ");
INSERT INTO nss_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pe Yesu iro yumwa totohun namandran, pe hu ndramat mara hu iyoh, pe hu ndramat ndrikahu mwomwan, ara husa kili yiy pe isopwoyani hu huya hiyan. ");
INSERT INTO nss_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hapeko hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, ara hunime hu kinima pwoke mepo imbusiy. Pe hunime hu mbunah, ara huro wayeh iro nondriya kowa yumwa totohun namandran, huro pa, <<Hosanna, kahari ngala Noru Tepit,>> pwen hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, ara hundrangis. ");
INSERT INTO nss_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Pe husok Yesu, hupa, <<Wou ahalingi sehe melit hu mbunah iye hutora pwai, ndre pwi?>> Pe Yesu isomwi hu, ipa, <<Wawu kannime nongan iye pwi, ndre? <Iyau poho hu mbunah mendreheh pe hu mbunah malaman, ara Ngindrai kintakinimahu para hu kahari ngalan.>>> ");
INSERT INTO nss_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pe Yesu itali kol namandran Yerusalem, pe iyau iya kol ngawan Petaniy, pe iya marisih iro aliy. ");
INSERT INTO nss_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pe makohuping opu, Yesu iropo imui nakiya kol namandran, pe imundrui. ");
INSERT INTO nss_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pe inime kei pik hakou iro ngilse sai, pe iya pakeh aliy, hapeko kinnime mbuwan pwi, yowin opu iro aliy. Pwen Yesu ipwai iya kili kei ara, ipa, <<Wou andre anippwai paiwe pwi!>> Pe hape pwi ko, kei ara imang. ");
INSERT INTO nss_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pwen iro mwonen ndramiran hu hunimei, ara huro lohonge ndrit. Pwen pe husok, hupa, <<Tehen tapeh pe kei pik ara, hape pwi ko imang?>> ");
INSERT INTO nss_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pe Yesu isomwiy, ipa, <<Yo upwai ndrokonan isa kili wawu, kapa akapwotisingi lohonga wawu, pe akanhindrundru pwi, pwen sehe melit mepo kintayah mahapo, ara andre kintayah kinna kili kei pik o, ara pwi, hapeko ilahiy para akapwai kiya kili ngondron iye, akapa, <Aya pe ayapiyani wou aya nondriya ndras,> pwen andre kirayah tehe wawu pwai. ");
INSERT INTO nss_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pe kapa akapwotisingi lohonga wawu pe akatohun, pwen andre akawiri sehe melit mepo wawu sok iya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pe Yesu isong iya nondriya kowa yumwa totohun namandran, pe iro hinuwani hu ndramat. Pe iro hinuwani hu ndron, pwen hu pris huhohin ta hu pris masih, pe hu yapane hu ndramat, ara husa kili yiy. Pe husok yiy, hupa, <<Wou awiri pwoke nopwaran ara, iyau aleheh? Pe hiyeh iyki pwoke nopwaran ara, isa kili wou?>> ");
INSERT INTO nss_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pe Yesu isomwi hu, ipa, <<Yo nakusike wawu kiya soksok sahin. Pe kapa akasomwi yo, pwen andre kupwai kisa kili wawu, hape aleheh uwiri pwoke nopwaran aro iyau aliy, pe urupo mbusi hu melit aro. ");
INSERT INTO nss_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohanes ngara kisumuluwani hu ndramat, pe wawu pa ndre kultuw para paptais ta Yohanes ara, ara iyau aleheh? Iyau kol paingan yang, ndre iyau kili ndramat opu?>> Pe huro panguluwaniy mwalingahu ko, huro pa, <<Kapa, tukapa, <Iyau kol paingan yang,> pwen andre kisok, kipa, <Pwen tehen tapeh pe lohonga wawu kinpwotisingi nongnan pwi?> ");
INSERT INTO nss_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hapeko kapa tukapa, <Iyau kili hu ndramat,> pwen andre tukanoh tahu ndramat, paratesah, hu masih ara hupa ndre Yohanes ara yiy poropet hamou.>> ");
INSERT INTO nss_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pwen pe husomwi Yesu, hupa, <<Yowu tana yowu pwi.>> Pwen isomwi hu, ipa, <<Pwen pe yo andre kunpwai kinsa kili wawu pwi yi, iyau hape aleheh uwiri pwoke nopwaran pe urupo mbusi hu melit aro.>> ");
INSERT INTO nss_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Wawu lohongani tapeh? Ndramat hamou iyen, pe manorun kamai malmou. Pwen iya kili hamou na, pe ipwai iya kili yiy, ipa, <Noru, lang nepo, ayapo mbulen aya pinge wain.> ");
INSERT INTO nss_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pe norun isomwiy, ipa, <Pwi; andre kunna pwi,> hapeko iyamulan ipaiwani lohongan pe iya. ");
INSERT INTO nss_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pwen ndramat ara, iya kili norun hamou i, pe ipwai tehen aliy opu iya kili yiy. Pe norun isomwiy, ipa, <Ehe, Tomo, andre kuya,> hapeko kinna pwi. ");
INSERT INTO nss_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pwen hiyeh ta hilu malmou ara, ara imbusi namiliwa taman?>> Pe hupa, <<Yiy imu ara.>> Pe Yesu ipwai iya kili hu, ipa, <<Upwai ndrokonan isa kili wawu, hu ndramat para poya takis, pe hu pihin para payango sai, ara hu tora song imu kili wawu tora po iya kolo King Ngindrai mepo ngara kiro mu kiya aliy. ");
INSERT INTO nss_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Paratesah, Yohanes isa kili wawu, ara para kipwaingani sai para kultuw imwonen kisa kili wawu, pe wawu kanpwotisingi lohonga wawu kinna nongnan pwi. Hapeko hu ndramat para poya takis, pe hu pihin para payango sai, ara hupwotisingi lohongahu. Pe wawu kannime hu melit ara pwen, hapeko wawu kanpaiwani lohonga wawu pe kanpwotisingi lohonga wawu kinna nongnan pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Akahilingi nongan pwandritiye handra aro yi: Mbukena pwan hamou iyen, pe ihisi pinge wain hambut. Pe irahakowa piyang ara, pe ipaltani kupwiy sih para haliya mbuwa wain. Pe ipuli seu hawum sohun niwen para hu ndramat keyen aliy, para kamemerani piyang. Pwen iyki piyang aro iro kili hu ndramat hayah para poya mbulya piyang, para hu koro nimnim, pe kapo mbulen kiya aliy. Pe yiy ara iyau iya, pe kinhora tokai tan. ");
INSERT INTO nss_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pwen pakeh lang para rihiya wain irayah. Pe mbukena pwan ara ipwandrisa ndramiran hu, huya kili hu mepo huropo mbulen iya piyang, para hu kaya wiri mbuwa wain, ita piyang hasui tan, kisa kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pwen hu mepo huropo mbulen iya piyang ara, ara humbultuwe tahatini hu ndramat mepo ipwandrisa hu. Pe hamou, ara hurayi yiy iya mwomwan, pe hamou hutingundrun, pe hamou i, ara husolpwa yiy iya pat. ");
INSERT INTO nss_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pwen ipwandrisa hu ndramat para poya mbulyan hayah i, mepo ndromwoyahu ihohin iyata hu para mamu. Pe humbusiy ihisoule ko, iya kili hu. ");
INSERT INTO nss_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pe iyamulan masih, ipwandrisa norun kamai iya kili hu. Pe ipa, <Andre hu karanuhuyani noru.> ");
INSERT INTO nss_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hapeko iro mwonen hu ndramat huropo mbulen iya piyang, ara hunime norun, pwen hamou ipwai iya kili hamou, hupa, <Iye ara norun, soiwi taman; pe yiy andre kiwiri hu meltan masih. Kiya, tukatingundrun, pe tukawiri menmena taman masih kiya mbukenan worou.> ");
INSERT INTO nss_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pwen pe huwiri yiy pe husoyau iyatan iya ngawan piyang, pe hutingundrun imat. ");
INSERT INTO nss_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pwen pe kapa mbukena piyang ara kisa, ara andre kimbusiy tapeh kiya kili hu ndramat para poya mbulen ara?>> ");
INSERT INTO nss_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pwen husomwi yiy, hupa, <<Yiy andre kipwalngani hu, pe kirutngundru hu ndramat mwomwan ara, hu kamat topwei. Pe andre kiyki piyang ara, kiya kili hu ndramat para poya mbulya piyang hayah i, mepo kiro mwonen lang para rihiya wain, ara andre hu kaiki hasui kiya tan.>> ");
INSERT INTO nss_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pe Yesu ipwai iya kili hu, ipa, <<Wawu kannime nongan iye mepo ita Nongna Ngindrai pwi, ndre? <Pat mepo yihu ndramat para puliya seu hulowaniy, ara kintayah pat para sotuna seu. Yapan kinmbusi melit aro kintayah, pe ara mwayih iya, iya mara tou.> ");
INSERT INTO nss_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pwen tehen tora ko, upwai isa kili wawu, tehe kolo King Ngindrai mepo ngara kiro mu kiya aliy, ara andre Ngindrai kiwiriy kiya mawen kili wawu, pe kiykiy kiya kili hu ndramat, mepo andre yihu kambusiy kihisangin. ");
INSERT INTO nss_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndramat hiyeh kiyos kiya ndrita pat aro, ara andre kimwalulut. Pe kapa pat ara kiyos kiya ndrita ndramat hamou, ara andre kirapisa yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pwen iro mwonen hu pris huhohin ta hu pris masih pe hu Parisiy, ara huhilingi hu nongan pwandritiye ta Yesu, pwen husa yirowei tehe yiy iro wong tora, ara itiyani hu. ");
INSERT INTO nss_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pwen huro ten sai para hu kambultuwe tahatini yiy, hapeko hunoh tahu ndramat soyon ara, paratesah, hu ndramat hupa ndre yiy ara poropet hamou. ");
INSERT INTO nss_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pwen pe Yesu itiyani nongan pwandritiye paiwe yi, ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe king hamou ihikule yiy iya kowase yon ta norun kamai nakiyesou. ");
INSERT INTO nss_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pwen ipwandrisa hu ndramat para poya mbulyan, para hu kaya pwai kiya kili hu ndramat mepo kinpwanos hu para hu kasa kowase yon, hapeko yihu ndrihisaniy para hu kasa. ");
INSERT INTO nss_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pwen ipwandrisa hu ndramat para poya mbulyan hayah i, ara ipa, <Akayapwai kiya kili hu mepo kunpwanos hu para hu kasa ara, tehe yo kunponokulani anandrina kowase yon to pwen. Hu mbulmwakau pe hu kan ato mepo sangihu imuh, ara kanitingundruhu, pe hu melit masih, ara kinmwoimwoi o iripo. Wawu kasa kowase yon para yesou.> ");
INSERT INTO nss_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hapeko hu kaniyki lohongahu kinna nongna hu ndramat para poya mbulyan pwi, pe huyau—hamou para kiyapo mbulya piyang, pe hamou, ara para kiyapo mbulyan para kipo singayai. ");
INSERT INTO nss_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pe hu masih humbultuwe tahatini hu ndramat para poya mbulya king, pe hurandroyani hu pe hutingundruhu. ");
INSERT INTO nss_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pwen king ndrinan ilokuh, pe ipwandrisa hu ndram huya, pe hupwalngani topwe hu ndramat para tingundru hu ndramat ara, pe hutimwi kol namandran tahu. ");
INSERT INTO nss_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pe ipwai iya kili hu ndramat para poya mbulyan, ipa, <Yon para kowase yesou ara kinmwoimwoi iripo, hapeko yihu mepo upwanos hu, ara hu kantewihiy para hu kasa pwi. ");
INSERT INTO nss_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pe akaya hu payango sai, pe akapwanos hu mepo akanime hu, para hu kasa kowase yon.> ");
INSERT INTO nss_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pwen hu ndramat para poya mbulyan, ara huya hu payango sai, pe hurawure hu ndramat masih mepo hulahiy para hu kakahi hu, hu hiyan pe hu mwomwan kene. Pe yumwa yesou, ara ipep iyata hu ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hapeko iro mwonen king isa nondriyan para kinime hu ndramat mepo hupwanos hu ara, ara iyirowei tehe ndramat hamou iro ariya, kinsuluye yiy kinna koiwe yesou pwi. ");
INSERT INTO nss_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pwen isok, ipa, <Kowase, paratapeh asa nondriyan iye, pe ansuluye wou kinna koiwe yesou pwi?> Pe ndramat ara inun o iro. ");
INSERT INTO nss_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pwen king ipwai iya kili hu ndramat para poya mbulyan, ipa, <Akawasi tiriyi niman pe ndrikan, pe akasoyau kiya tan kiya ngawan kiya nondriya kol lokuhan, mepo ngara hu koro rang malihu pe koro yandrisingi koltahu.> ");
INSERT INTO nss_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Akahilingiy, Ngindrai kinpwanos hu ndramat soyon, hapeko irakinima hu hayah opu.>> ");
INSERT INTO nss_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pwen hu Parisiy huya ngawan pe humburi nongan para hu karatuni Yesu kiya nongnan. ");
INSERT INTO nss_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pe hupwandrisa hu ndramira Parisiy hayah huyapolo hu ndramat hayah para kili Herot, pe huya kili Yesu, pe hupa, <<Ndramat Para Hinonou, yowu pahasaniy tehe wou, ara ndramat para nongan ndrokonan opu, pe ngara ahanuwani hu ndramat kiya meresaya Ngindrai kiho ndruwa nongan ndrokonan. Pe wou anhoyos kinna nima hamou pwi, paratesah, wou anoho hire hu ndramat pwi. ");
INSERT INTO nss_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pwen apwai kisa kili yowu na; lohongam tapeh? Hiyan para yowu kayuk takis kiya kili Sisar, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hapeko Yesu ara kinyirowe lohongai para pwakekeriu mwomwan tahu, pe ipa, <<Wawu ndramat para pwandrandraman, paratapeh pe wawu pakanohonou para karatuni yo? ");
INSERT INTO nss_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Akapwaingani sombule pat mepo ngara kayuk takis kiya aliy kisa kili yo.>> Pwen huwiri sombule pat hambut iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pe Yesu ipwai iya kili hu, ipa, <<Aripo sumwoiwa hiyeh, pe ngala hiyeh iripo aliy?>> ");
INSERT INTO nss_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pe husomwi yiy, hupa, <<Ata Sisar.>> Pwen Yesu ipwai iya kili hu, ipa, <<Pwen pe akaiki tesah ta Sisar kiya kili Sisar, pe tesah ata Ngindrai kiya kili Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pe iro mwonen huhilingi nongan aro, pe lohongahu indrap. Pwen hutali Yesu pe huyau. ");
INSERT INTO nss_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iho nondriya lang ara ko, hu Satyusiy, mepo hupa ndre hu ndramat kanmat pwen, ara andre hu kantine paiwe pwi, ara husa kili Yesu iyapolo soksok sahin. ");
INSERT INTO nss_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Pwen hupa, <<Ndramat para hinonou, Mose kinpwai kinsa kili yowu, tehe kapa ndramat hamou kiyesou, hapeko kinpo norun hamou pwi, pe kimat, andre nalin kisoli paranawe nalin, pe kipo hamou mbunah kiya soiwi nalin. ");
INSERT INTO nss_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hu ndramat manandrtimou hu nalihu huye mwalinga yowu. Yiy ndrohan ara iyesou pe imat, pe kinpo norun pwi. Pe nambuyun ihou pe nalin iwiri yiy. ");
INSERT INTO nss_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pe irayah tehen aliy opu iya kili mundruwa ndrohan, pe parahara mundruwa ndrohan, pe hu manandrtimou kene. Hu masih ara huwiri pihin ara, pe noruhu pwi ko, pe humat topwei. ");
INSERT INTO nss_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pe iyamulan masih pihin ara, ara imat i. ");
INSERT INTO nss_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pwen pe kiro mwonen lang para hu ndramat kasa tine paiwe, pwen pihin ara, ara andre kirayah nambuyu hiyeh ndrokonan, paratesah, hu manandrtimou kene ara, ara hamou-hamou tahu iwiri pihin ara tehe nambuyun?>> ");
INSERT INTO nss_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pwen Yesu isomwi hu, ipa, <<Wawu kanpwotisi nongan, paratesah, wawu kanpahasani hu Nongna Ngindrai pe pwoke ta Ngindrai pwi. ");
INSERT INTO nss_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kiro mwonen hu ndramat hu kasa tine paiwe, ara yihu andre kanyesou pwi, pe andre hu kansokombut yesou pwi yi. Yihu andre hu koro ko tehe hu angelou tora kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Hapeko iya lohongai para hu ndramat kanmat pe kasa tine paiwe—wawu kannime tesah mepo Ngindrai kinpwai kinsa kili wawu pwi, ndre? ");
INSERT INTO nss_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ipwai, ipa, <Yo urupo Ngindrai ta Apraham, pe urupo Ngindrai ta Yisak, pe urupo Ngindrai ta Yakop.> Akanimei! Yiy ara Ngindrai tahu ndramat mepo hu kanmat, ara pwi. Hapeko yiy ara Ngindrai tahu ndramat hutopo mwalen, tehe Apraham, Yisak pe Yakop.>> ");
INSERT INTO nss_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pe iro mwonen yihu ndramat soyon ara, huhilingi nongan aro, lohongahu, ara indrap iya hinonou tan. ");
INSERT INTO nss_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pe iro mwonen yihu Parisiy huhilingiy tehe Yesu iyki tamum iyata hu Satyusiy, pwen yihu Parisiy hurawurehu. ");
INSERT INTO nss_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pwen hamou tahu mepo lohongan iman iya nongan para pwahanou, ara inohonou Yesu iya soksok sahin, ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","<<Ndramat para hinonou, sehe nongan para pwahanou, ara ihohin iya, ita nondriya hu nongan para pwahanou masih?>> ");
INSERT INTO nss_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Pe Yesu isomwi yiy, ipa, << <Ndriyam kimbuluhi Yapan Ngindrai tam kiya ndriyam masih kene, pe kiya mwoiwam masih kene, pe kiya lohongam masih kene.> ");
INSERT INTO nss_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nongan para pwahanou sahin aro, ara iya mu pe ihohin iya, ita nondriya hu nongan para pwahanou masih. ");
INSERT INTO nss_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pe nongan para pwahanou luhin para aliy i, ara ipa toro: <Ndriyam kimbuluhi hiyeh para pakeh kili wou, tehe ndriyam ngara kimbuluhi wou mbukenam.> ");
INSERT INTO nss_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nongan para pwahanou malhin aro, ara ihohin iya, pe nongan ara, ara ndroiyi Nongan para Pwahanou pe Nongna hu Poropet masih.>> ");
INSERT INTO nss_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pwen iro mwonen hu Parisiy hurawure hu huro harong, Yesu isok hu, ipa, ");
INSERT INTO nss_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Wawu lohongani tapeh iyata Mesayah? Yiy ara noru hiyeh?>> Pe husomwi yiy, hupa, <<Noru Tepit.>> ");
INSERT INTO nss_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pe Yesu ipwai iya kili hu, ipa, <<Tehen tapeh ndrokonan pe Mwoiwan Haiyan iwong iyau poho Tepit, pe Tepit ipohowe Mesayah, ara <Yapan>? Akanimei, Tepit, ara ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<Yapan ipwai iya kili Yapan to, ipa, <<Asampwan kapwen te nimo mot, kipoo kuiki hu hiyeh huhingasi wou, ara hu kaya pahandra ndrikam.>> > ");
INSERT INTO nss_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pwen pe kapa Tepit iyoh yiy <Yapan,> pwen tehen tapeh pe ilahiy para kirayah norun?>> ");
INSERT INTO nss_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pe kinlahi hamou tahu kisomwi nongna Yesu aro, ara pwi. Pe iro matne lang ara iya, yihu hindrundru para hu kasok Yesu kiya nongan sahin paiwe pwi. ");
INSERT INTO nss_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pwen pe Yesu ipwai iya kili hu ndramat soyon pe ndramiran hu, ipa toro: ");
INSERT INTO nss_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Yihu ndramat para hinuwani nongan para pwahanou pe hu Parisiy, ara ngara hu kahanuwani wawu iya tesah mepo Mose kintatuluwiy. ");
INSERT INTO nss_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pwen tehen tora ko, wawu kahilingi nongnahu, pe akoho ndruwa hu melit masih mepo hupwai para akambusiy. Hapeko wawu mbuna akambusi sehe melit yihu ngara kambusiy. Paratesah, yihu ngara konho ndruwa tesah mepo ngara hu kapohowei, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yihu ngara kawasi hu tasusu nopwaran, pe ngara hu kaikiy kiro ndrita pwese hu ndramat. Hapeko yihu mbukenahu, ara yihu mbuwalihu para kaiki ndrakopwenimahu hakip para kasopwat hu, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Melit masih hu ngara kambusiy, ara para hu ndramat kanimei. Yihu ngara kasokomburani pwenah para totohun kiya namandran, pe ngara hu kambusi komu koiwehu para totohun, kiya niwen pe kiho liuliu. ");
INSERT INTO nss_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pe ngara hu kanamiliy para korompwan ndrohonoku pwanpwan hiyan koro hu yon, pe kampwan hu pwapwai hiyan hu ndramat ngara hu kahaiyaniy i, tora nondriya hu yumwa mbultere tahu Yuta . ");
INSERT INTO nss_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hu ndramat aro, ara hunamiliy para hu ndramat karawulohani hu koro hu ndroho pehei, pe hu ndramat kapohowe hu <Ndramat para Hinonou.> ");
INSERT INTO nss_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Hapeko hu ndramat mbuna kapohowe wawu <Ndramat para Hinonou,> paratesah, Namandran tawawu ara hamou opu, pe wawu masih, ara wawu nali wawu. ");
INSERT INTO nss_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pe wawu mbuna akapohowe hamou iripo kol pwan <tama yowu,> paratesah, Tama wawu, ara hamou opu, pe iyera kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pe mbuna akapohowe hamou tawawu <Ndramat para hinonou,> paratesah, Mesayah, yiy hamou opu, ara Ndramat para Hinonou tawawu. ");
INSERT INTO nss_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pe yiy mepo ihohin masih kili wawu, ara andre kirayah ndramat para poya mbulya wawu. ");
INSERT INTO nss_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pe hiyeh pakisap ngalan mbukenan, ara andre ngalan kiya pwi. Pe hiyeh kiyki yiy kiya pwan, ara andre Ngindrai kihiri ngalan kiya paingan. ");
INSERT INTO nss_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Wawu ndramat para hinuwani nongan para pwahanou pe wawu Parisiy, toimwa wawu, wawu ndramat para pwandrandraman! Wawu wari papai para kolo king mepo ngara kiro mu kiya aliy para kol paingan yang iro mbulmara hu ndramat. Pe wawu mbukena wawu, ara konhosong kanna nondriyan pwi. Pe yihu mepo hunohonou para kasong kaya nondriyan, ara wawu ngara kapenani hu, para hu mbuna kasong kaya nondriyan. ");
INSERT INTO nss_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wawu ndramat para hinuwani nongan para pwahanou pe wawu Parisiy, toimwa wawu, wawu ndramat para pwandrandraman! Wawu ngara karakayani ndras pe kol pwan masih, para katele ndramat hamou opu para kirayah ndramira wawu. Pe kiro mwonen kiyki ndriyan para kiho ndruwa wawu, ara wawu ngara kambusi yiy, pe kultuwayin kiramwaitini kultuw mwomwan tawawu maporolusap, pe kirayah ndramat hamou para kiya mwonen kiya ngat mepo mwan itayat aliy. ");
INSERT INTO nss_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Wawu ndramat para luwani hu ndramat, hapeko mara wawu iyoh, toimwa wawu! Wawu ngara kapwai, kapa, <Kapa hamou kirandrangan kiya yumwa totohun namandran, ara tehe melit o mwaihei opu. Hapeko kapa hiyeh kirandrangan kiya kolt para yumwa totohun namandran, ara tesah irandrangan iya aliy, ara andre kiro ndruwa nongnan tehe kinpwai.> ");
INSERT INTO nss_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wawu tehe ngou pe mara wawu iyoh! Tesah ihohin, eh?—kolt ara, ndre yumwa totohun namandran mepo imbusi kolt ara irayah haiyan? ");
INSERT INTO nss_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wawu ngara kapwai, kapa, <Kapa hamou kirandrangan kiya pere tuntun, ara tehe melit o mwaihei opu. Hapeko kapa hiyeh kirandrangan kiya yukyuk kiro pere tuntun, ara tesah irandrangan iya aliy, ara andre kiro ndruwa nongnan tehe kinpwai.> ");
INSERT INTO nss_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wawu ndramat mara wawu iyoh! Tesah ihohin, eh?—yukyuk, ndre pere tuntun mepo imbusi yukyuk irayah haiyan? ");
INSERT INTO nss_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pwen tehen tora ko, hiyeh kirandrangan kiya pere tuntun, ara irandrangan iya aliy, pe iya melit masih iro ndritan i. ");
INSERT INTO nss_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pe yiy hiyeh kirandrangan kiya yumwa totohun namandran, ara irandrangan iya aliy, pe iya ngala Ngindrai mepo ngara kiyen aliy yi. ");
INSERT INTO nss_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pe yiy hiyeh kirandrangan kiya kol paingan yang, ara irandrangan iya ndrohonoku pwanpwan ta Ngindrai, pe iya kili Yiy mepo iyerampwan aliy. ");
INSERT INTO nss_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Wawu ndramat para hinuwani nongan para pwahanou pe wawu Parisiy, toimwa wawu, wawu ndramat para pwandrandraman! Wawu ngara kataingani melit sih nondriya ndrokoyirayi masongui para melit mendreheh tehe parahiy, koyo, pe hu melit kankanahu layin handra-handra. Hapeko wawu kanndrihisani hu melit namandran para nongan para pwahanou mepo huhohin masih—tehe lohongai para tamwanye hiyan, pe lohongai para koisirai, pe kultuw para weleso. Hiyan para wawu koro ndruwa hu kultuw hiyan namandran tehen tora, pe koyu wawu mbuna kirut hu melit mendre-mendreheh ara yi. ");
INSERT INTO nss_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wawu ndramat para luwani hu ndramat, hapeko mara wawu iyoh! Wawu ngara karahi mwalsing hamou kiho suw, hapeko wawu konho nime kamel hamou kiho suw pwi. Pwen o, ngara wawu kandrimiy. ");
INSERT INTO nss_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Wawu ndramat para hinuwani nongan para pwahanou pe wawu Parisiy, toimwa wawu, wawu ndramat para pwandrandraman! Wawu ngara kasungani ngawan para pweniu pe pwelekei, hapeko nondriyan, ara ipep iya mwolou pe kultuw para akapwesani wawu mbukena wawu. ");
INSERT INTO nss_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wawu Parisiy para marayoh! Akasungani nondriya pweniu pe pwelekei kimu na, kihipwen, pwen andre ngawan para aliy yi, ara andre kiya howen. ");
INSERT INTO nss_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wawu ndramat para hinuwani nongan para pwahanou pe wawu Parisiy, toimwa wawu, wawu ndramat para pwandrandraman! Wawu, ara tehe hu pohomara ngat mepo hutumwi kohoh pallen iya aliy. Nimiyan para ngawan, ara lahayan iya, hapeko nondriyan, ara ndruwi hu ndramat pe melit masih pwalan ipep ita aliy. ");
INSERT INTO nss_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pwen tehen aliy opu, ngawan tawawu, ara wawu ya yingani wawu iya kili hu ndramat tehe imwonen. Hapeko nondriya wawu, ara ipep iya pwandrandraman pe kultuw pwassin. ");
INSERT INTO nss_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Wawu ndramat para hinuwani nongan para pwahanou pe wawu Parisiy, toimwa wawu, wawu ndramat para pwandrandraman! Wawu ngara kara hu ngat para tona hu poropet, pe wawu ngara kanowi hu ngat tahu ndramat imwonen. ");
INSERT INTO nss_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pe wawu ngara kapa, <Kapa yowu koro nondriya hu lang ta tumbu yowu hu, ara andre yowu kansopwat yihu para katingundru hu poropet pwi.> ");
INSERT INTO nss_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pwen wawu kanpwaingani wawu tehe wawu, ara tumbu yihu ndramat mepo hu tingundru hu poropet. ");
INSERT INTO nss_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kiya, hiyan, akapo sura pakut mwomwan ta tumbu wawu hu, kipoo kiya hapwen topwei! ");
INSERT INTO nss_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wawu mwat! Wawu mwat hayoi mapaira wawu! Wawu andre kawop kasa mawen kora kultuw mwomwan tapeh? Kora mwomwan tawawu, ara andre kiyki wawu kaya ngat mepo mwan itayat aliy. ");
INSERT INTO nss_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pwen pe tunan ara ko, yo andre kupwandrisa hu poropet, pe hu ndramat lohongahu waison, pe hu ndramat para hinuwani wawu, ara hu kasa kili wawu. Yihu hayah tahu, andre wawu katingundruhu, pe karapaingi hu kaya kei tondrih. Pe yihu hayah i, ara andre akamwiriyani hu koro nondriya hu yumwa mbultere tahu Yuta , pe akoho san hu, pe andre hu koho wop kol hakol kaya hakol. ");
INSERT INTO nss_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pwen hu ndramat masih mepo hu kanitingundru hu ndramat kultuwayihu imwonen, pe ndreyehu kinimuw iripo kol pwan, ara koran andre kiro ndrita wawu--iro ndreye Apel, yiy ndramat imwonen, pe isa matne ndreye Sekarayah NdraPerekayah, yiy mepo wawu tingundrun iro mwalinga yumwa totohun namandran pe pere tuntun, ara andre wawu kakuni korahu topwei. ");
INSERT INTO nss_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Upwai ndrokonan isa kili wawu, tehe kora melit masih kene mwomwan aro, ara andre kisa kona wawu hasap para mahapo. ");
INSERT INTO nss_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Yerusalem, Yerusalem! Wawu mepo wawu ngara katingundru hu poropet, pe hu ndramat mepo Ngindrai ipwandrisa hu husa kili wawu, ara ngara akasolpwa hu kiya pat: Lang hitun ara ndriyo inamiliy para kurawurani noru wawu hu kasawule, tehe tutut pihin hamou ngara kipwokarani norun hu koro pahandra kapenen. Hapeko wawu ngara kahambuwali wawu. ");
INSERT INTO nss_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akahilingiy, kolo wawu, ara kinna mwomwan pe kinna marakah. ");
INSERT INTO nss_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Paratesah, yo upwai isa kili wawu tehe andre akannime yo paiwe pwi, kipoo akapa, <Lomwes ita kili yiy mepo isa iya ngala Yapan.>>> ");
INSERT INTO nss_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pwen Yesu itali yumwa totohun namandran, pe iro tokai nakiyau. Pe ndramiran hu husa kili yiy pe huwiri lohongan iya yumwa totohun namandran, pe hu wum mepo huro kene aliy. ");
INSERT INTO nss_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pe Yesu isomwi hu, ipa, <<Wawu tora nime hu melit masih kene aro, ndre? Upwai ndrokonan isa kili wawu, tehe pat sih andre kinye ndron ndrita sih pwi. Hu pat masih kene aro, andre hu katipiyani hu topwei kaya pwan.>> ");
INSERT INTO nss_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pwen Yesu impwan Ngondron para hu Holip, pe ndramiran hu husa kili yiy nokule ko, pe hupa, <<Apwai kisa kili yowu, sehe lang ndrokonan andre hu memelit masih mepo anpwai ara andre karayah? Pe sehe kaipisa melit andre kipwaingani lengem para nasa, pe para kol pwan nakiyahapwen?>> ");
INSERT INTO nss_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Pwen Yesu isomwi hu, ipa, <<Mara wawu kiro, matisan ndramat hamou kipakarawani wawu. ");
INSERT INTO nss_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Paratesah, yihu ndramat soyon andre hu kasa kiya ngolo, pe andre hu kapa, <Yo ara Mesayah,> pe andre hu kapakarawani hu ndramat soyon. ");
INSERT INTO nss_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pe andre wawu kahilingi nola hu pahun, pe hu nguluwa hu pahun, hapeko nere wawu mbuna kihilim. Hu melit tehen tora andre hu karayah, hapeko lenge kol pwan nakiyahapwen, ara mapu. ");
INSERT INTO nss_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pe hu ndraye ndramat hayah, andre hu kapo pahun kiya kili hu ndraye ndramat hayah i; pe hu ndramira kolo king mepo ngara kiro mu kiya aliy para hu kol hayah, ara andre kapo pahun kaya kili hu ndramira kolo king para hu kol hayah i. Pe hu song pe hu nunuw namandran iya, ara andre hu karayah koro hu kol hakol-hakol. ");
INSERT INTO nss_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hu melit masih aro kene, ara andre karayah kimu na, tehe pihin hamou ihingotou para nakimwalahiy. ");
INSERT INTO nss_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pwen andre hu kambultuwe tahatini wawu para karandroyani wawu, pe katingundru wawu kamat. Pe tunan yo kopu, pwen andre hu ndramat para kol pwan masih kene, ara andre hu kahangasi wawu. ");
INSERT INTO nss_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pe kiro mwonen lang ara, yihu ndramat soyon, andre hu katali lohongai ndrisiyon sato. Pe andre hamou kiratuni hamou, pe hamou kihingasi hamou. ");
INSERT INTO nss_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pe hu poropet pwasoyou andre hu karayah, pe kapakarawani hu ndramat soyon iya. ");
INSERT INTO nss_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pe kultuw para kanamili hamou-hamou mwalinga hu ndramat hitun, ara andre kissau, paratesah, kultuw pwassin iripo po iya namandran iya. ");
INSERT INTO nss_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Hapeko sehe ndramat mepo kiro tine pwokeyan, kipoo kiya matne lang kiyahapwen, ara andre Ngindrai kisopwat yiy. ");
INSERT INTO nss_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pe nongan hiyan para kolo King Ngindrai mepo ngara kiro mu kiya aliy iye, ara andre kapohowei kisalti kol pwan masih, tehe titiye to kiya kili hu ndraye ndramat masih kene, pwen lang para kol pwan nakiyahapwen andre kisa. ");
INSERT INTO nss_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pwen pe kiro mwonen wawu kanime melit mwomwan, mepo poropet Taniyel kinpohowei koluw kinna, ara kiro tine nondriya Seu Sahin Haiyan ita nondriya yumwa totohun namandran ta Ngindrai—<melit pwalan masih mepo andre kipwalngani yumwa totohun namandran>—hiyeh kinime nongan ara, ara lohongan kileu— ");
INSERT INTO nss_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pwen yihu mepo hutora kol namandran hape Yutiya, ara hu kawop kaya hu ngondron. ");
INSERT INTO nss_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pe sehe ndramat mepo kiro payandroha suwen lang ara, ara mbuna kilai kiya pwan, pe kiya nondriya suwen para kiyapo handra melit tan kisa ngawan. ");
INSERT INTO nss_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pe sehe ndramat mepo kiro pingen lang ara, ara mbuna kimui para kiyapo koiwen. ");
INSERT INTO nss_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Toimwa hu pihin mepo mapundriyahu, pe hu mepo hutora hisuwe noruhu malaman, ara andre hu kaiki koisariy kiho nondriya hu lang ara. ");
INSERT INTO nss_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Akatohun tehe wowop tawawu, ara mbuna kisarayah kiro mwonen lenge nowou ndre kiho lang Sapat. ");
INSERT INTO nss_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Paratesah, lang ara, andre nopwaran namandran iya kirayah. Pe nopwaran ara, ara andre kinhisoule tehe nopwaran masih mepo kintayah pwen, ara pwi--iro mwonen kol pwan irayah, ipoo isa matnen mahapo. Pe kiyamulan, nopwaran tehen tora, ara andre kintayah paiwe kihisoule tehen aliy, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pe kapa Ngindrai kinsondriti hu lang para hu nopwaran ara kinna mulai pwi, ara andre hamou kinto mwalen pwi. Hapeko ilohongani hu mepo kinpirani hu pe kintakinimahu pwen, pwen pe isan nowen, ara iya mulai. ");
INSERT INTO nss_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pe kiro mwonen lang ara, kapa ndramat hamou kisa pe kipwai kisa kili wawu, kipa, <Akahilingiy! Mesayah iripo iye!> ndre kipa, <Mesayah ita yoro!> pwen lohonga wawu mbuna kipwotisingi nongnan. ");
INSERT INTO nss_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Paratesah, hu kristus pwasoyou, pe hu poropet pwasoyou, ara andre hu kasarayah; pe andre hu kambusi hu kaipisa pwoke namandran, pe hu kinima pwoke yi, para hu kapakarawani hu mepo Ngindrai kintakinimahu pwen—kapa ilahiy para hu kambusiy tehen aliy. ");
INSERT INTO nss_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Akanimei, lang mapu kinsa, pe yo kunpwai mamu kinsa kili wawu. ");
INSERT INTO nss_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pwen pe kapa hamou kipwai kisa kili wawu, kipa, <Akanimei! Yiy iyoro kol ndrohoyin,> wawu mbuna akaya; ndre kapa kipa, <Yiy ita nondriya seu sahin ita nondriya seu aro,> pwen mbuna akapwotisingi lohonga wawu kiya aliy. ");
INSERT INTO nss_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Paratesah, kiro mwonen ngara akanime kamit kikamiriy kiyau kup, pe ngannganan kilenganiy kiya toton kiya rai, pwen pe lang para Noru Ndramat nakisa, ara andre kirayah tehen aliy opu. ");
INSERT INTO nss_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hape aleheh mepo paramuw kirahis kiro aliy, ara andre hu mondrtoi kahalun kaya aliy. ");
INSERT INTO nss_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kiya ndruwa lenge hu nopwaran ara kahapwen, pwen hape pwi ko, <mwandrai andre kilokuh, pe walah andre kiniyki nganan pwi, pe hu piriy andre kayos kayau yang kasa pwan, pe hu pwoke para yang, ara andre hu kamemeyeu.> ");
INSERT INTO nss_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pe kiho nondriya lang ara, ara kaipisa Noru Ndramat andre kisarayah kiho paingan yang. Pe hu ndraye ndramat para kol pwan masih, ara andre hu karang malihu. Pe andre hu kanime Noru Ndramat kisa kiho ndrita hu kokom para yang, kiyapolo pwoke pe nonowa nganan namandran. ");
INSERT INTO nss_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pe ndrah andre kiro tang namandran iya, pe Noru Ndramat andre kipwandrisa hu angelou tan, pe andre hu karawurani hu mepo kintakinimahu pwen atan, hu kayau hu mbusungo kol pwan mahaasai, pe kiro yang haroh kiyandrek kiya haroh. ");
INSERT INTO nss_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Akapo lohongai kiyau nongan pwandritiye para kei pik toro: Kiro mwonen ndrandran kituhuruh pe kiyki kaimbuwen, ara akapahasaniy, tehe lang para mwandrai nakising, ara kinsa pakeh. ");
INSERT INTO nss_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tehen tora ko, kapa akanime hu melit masih kene aro koro tayah, ara akapahasaniy tehe Noru Ndramat, ara kinsa pakeh, pe ita poho karam. ");
INSERT INTO nss_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Upwai ndrokonan isa kili wawu, hu ndraye ndramat hasap para mahapo aro, ara andre hu masih kanmat pwi, kipoo hu melit masih aro karayah topwei. ");
INSERT INTO nss_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kol paingan yang pe kol pwan, ara andre kihipwen, hapeko hu nongno, ara andre kanhipwen pwi. ");
INSERT INTO nss_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hapeko ndramat hamou kinpahasani sehe lang, ndre sehe paramwandrai hu melit aro kene nakarayah, ara pwi. Pe Norun pe hu angelou hutora kol paingan yang, ara hukowu i. Taman hamou opu, ara ipahasaniy. ");
INSERT INTO nss_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pe sehe kultuw mepo ngara hu koro mbusiy kiro lenge Nowah, ara andre kirayah kihisoule ko, kiro mwonen lang mepo Noru Ndramat nakisa. ");
INSERT INTO nss_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Paratesah, tandrohonga hu lang mepo non kintah mapu, ara yihu ndramat huro namnam, pe huro yin ndran, pe huro yesou, pe huro sokombut yesou, ipoo iya lang mepo Nowah isong iya nondriya ndroi. ");
INSERT INTO nss_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pe hu kanyirowe sehe melit mepo pakeh nakirayah, ara pwi, ipoo non irah pe isurahi hu masih huya mawen. Pwen lang para Noru Ndramat nakisa, ara andre kirayah tehen aliy opu. ");
INSERT INTO nss_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hilu ndramat malmou andre hilu koro piyang; Ngindrai andre kiwiri hamou, pe hamou andre kiye ndron. ");
INSERT INTO nss_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hilu pihin malmou andre hilu koro puluw palawa para ndrinanohun; Ngindrai andre kiwiri hamou, pe hamou andre kiye ndron. ");
INSERT INTO nss_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pwen tehen tora ko, mara wawu kiro, paratesah, sehe lang Yapan nakisa kiya aliy, ara wawu kowu. ");
INSERT INTO nss_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hapeko lohonga wawu kileu kiya nongan aro: kapa mbukena seu kinpahasaniy pwen kimu, iya sehe paramwandrai ndramat para pahana nakisa, ara andre mbukena seu ara kiro poyoi; pwen suwen ara andre kinlahiy para hamou kitumbuwei pe kiya nondriyan pwi. ");
INSERT INTO nss_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pwen ndroiyin ara ko, wawu yi, ara akoro hinehes, paratesah, Noru Ndramat nakisa, ara andre kiho nondriya paramwandrai mepo wawu kowu para nakisa kiya aliy. ");
INSERT INTO nss_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pwen, sehe ndramat para poya mbulen mepo maran pahalan pe lohongai waison iripo kili yiy, ara andre namandran tan kiyki mbulen kiya kili yiy? Namandran tan andre kiyki ndramat tehen tora, para kiro nimnim kiyata hu ndramat para poya mbulen kiro nondriya suwen, pe para kiro hang hu anandrinai kiho mwonen paramwandrai para yukuya anandrinai. ");
INSERT INTO nss_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hiyan masih kapa ndramat para poya mbulen ara, ara namandran tan kimui kisa, pe kinimei tehe yiy iropo mbulyan. ");
INSERT INTO nss_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Upwai ndrokonan isa kili wawu, tehe namandran tan andre kiyki yiy kiro nimnim kiya hu menmenan masih kene. ");
INSERT INTO nss_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hapeko kapa ndramat para poya mbulen, ara kultuwayin pwassin, pe kipanguluwaniy kiyatan mbukenan, kipa, <Namandran to, ara ita mawen ndrangan niwen iya pe kinsa mapu,> ");
INSERT INTO nss_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","pe iya pe iro tandroyani susuran hu para poya mbulen, pe iya iro namnam pe iro yin ndran iyapolo hu ndramat para kuimwa ndran, ");
INSERT INTO nss_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","pwen namandran ta ndramat para poya mbulen ara, ara andre kisa kiho nondriya lang mepo ikowu iya aliy, pe kiho nondriya paramwandrai mepo kinpahas kinna aliy pwi. ");
INSERT INTO nss_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pe andre namandran tan kiringi yiy kiya mendre-mendreheh, pe kiyaiki yiy kiya polo hu ndramat para pwandrandraman, kiya kol mepo andre hu koro rang malihu pe koro yandrisingi koltahu. ");
INSERT INTO nss_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kiro lang ara, kolo king mepo ngara kiro mu kiya aliy para kol paingan yang, ara tehe hu pihindrahin masongui mepo huwiri hu paisui makakan tahu, pe huyau huya para kaya pohonani ndramat para nakiyesou. ");
INSERT INTO nss_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pe hu mayimou tahu, ara lohongahu waison pwi; pe hu mayimou tahu, ara lohongahu waison. ");
INSERT INTO nss_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pe yihu mepo lohongahu waison pwi, ara huwiri hu paisui makakan tahu, hapeko hu kanwiri ndraikei para aliy kinnasurahu pwi. ");
INSERT INTO nss_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pe yihu mepo lohongahu waison, ara huwiri ndraikei iro hu pwisi ndraikei iyasura hu paisui makakan tahu. ");
INSERT INTO nss_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pe ndramat para nakiyesou ara, ara kinsa kileh pwi. Pwen marahu pihindrahin ara, inun pe humatin. ");
INSERT INTO nss_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pwen iho ndrokolo put, ndramat hamou iyoh, ipa, <Ndramat para nakiyesou, ara itapo isa! Akasa ngawan para kaya pohonani yiy!> ");
INSERT INTO nss_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pwen hu pihindrahin masih ara husa poyoi, pe hu mwaniyani hu paisui makakan tahu. ");
INSERT INTO nss_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pwen yihu mepo lohongahu waison pwi, ara hupwai iya kili hu mepo lohongahu waison, ara hupa, <Akahang yowu hape ndraikei tawawu na; paisui towu, ara hu nakamat.> ");
INSERT INTO nss_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pe hu pihindrahin lohongahu waison ara, ara husomwiy, hupa, <Pwi yoh! Andre kinlahi wawu pe yowu kene, ara pwi. Akaya kili hu mepo hu tora po pehei iya ndraikei pe akasou hayah tawawu mbukena wawu.> ");
INSERT INTO nss_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hapeko iro mwonen huropo huya, para hu nakaya sou ndraikei, ndramat para nakiyesou, ara kinsarayah pwen iro. Pe hu pihindrahin mepo hu kanmwaniyani hu pwen huro, ara husong huyapolo yiy huya nondriya suwe yon para yesou. Pe hu para seu ara, huwari papai. ");
INSERT INTO nss_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Iyamulan hu pihindrahin lohongahu waison pwi ara, ara husa, pe hupa, <Namandran! Namandran! Atipe papai kili yowu!> ");
INSERT INTO nss_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hapeko isomwi hu, ipa, <Upwai ndrokonan isa kili wawu tehe ukowu tawawu.> ");
INSERT INTO nss_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pwen tehen tora ko, mara wawu kiro, paratesah, wawu kowu sehe lang ndre sehe paramwandrai Yapan tawawu nakisa. ");
INSERT INTO nss_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Pwen nakupwai paiwe yi, kolo King Ngindrai ita kol paingan yang, ara tehe ndramat hamou iyen, pe iyau iya kinhora tokai tan. Pe iyoh hu ndramat para poya mbulyan husa pe iyki menmenan iya nima hu. ");
INSERT INTO nss_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pwen iyki singayai mapuyimingui pe ndromwan iya kili hamou, pe iyki singayai mapulungui pe ndromwan iya kili hamou, pe iyki mapusongui pe ndromwan iya kili hamou. Pe iyki singayai ara, ara ilahi pwoke para mbulyahu hamou-hamou. Pwen iyau iya tokuyan. ");
INSERT INTO nss_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pwen yiy hamou mepo kinwiri singayai tehe mapuyimingui ara, ara hape pwi ko, iyapo mbulen iya aliy, pe iposuran irayah mapuyimingui yi. ");
INSERT INTO nss_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pwen yiy mepo iwiri singayai tehe mapulungui ara, ara tehen aliy opu, ipo mbulen iya aliy, pe iposuran irayah mapulungui yi. ");
INSERT INTO nss_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hapeko yiy mepo iwiri singayai tehe mapusongui ara, ara iya pe ira ngat iya mbulu pwan, pe ikulani singayai ta namandran tan iro aliy. ");
INSERT INTO nss_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pe namandran tahu ndramat para poya mbulen, ara iya iro ndrangan niwen iya, pwen imui isa pe imwanye lohongai para singayai mepo iykiy iya nimahu ara. ");
INSERT INTO nss_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pwen ndramat mepo kinwiri singayai mapuyimingui ara, ara isaikiy iyapolo mapuyimingui mepo ipo suran ara, pe ipa, <Namandran, animei na! Wou aiki mapuyimingui isa nimo, pe uyapo mbulen iya aliy, pe uposuran irayah mapuyimingui yi.> ");
INSERT INTO nss_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pe namandran tan isomwi yiy, ipa, <Wou ndramat hiyan pe ndramat para weleso! Mbulyam hiyan! Wou apo mbulen iya melit noniy, pwen andre aro nimnim kiya hu melit soyon. Asa pe talu kapwes kawule!> ");
INSERT INTO nss_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pwen ndramat mepo iwiri singayai mapulungui ara isa yi, pe ipa toro: <Namandran, animei na! Wou aiki mapulungui isa nimo, pe uyapo mbulen iya aliy, pe uposuran irayah mapulungui yi.> ");
INSERT INTO nss_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pe namandran tan isomwi yiy, ipa, <Wou ndramat hiyan pe ndramat para weleso! Mbulyam hiyan! Wou apo mbulen iya melit noniy, pwen andre aro nimnim kiya hu melit soyon. Asa pe talu kapwes kawule!> ");
INSERT INTO nss_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pwen ndramat mepo iwiri singayai mapusongui ara, ara isa, pe ipa, <Namandran, upahasaniy tehe wou ara ndramat hamou ngandrahan, mepo ngara ayapo anandrinai mepo anhohas pwi. Pe wou ngara ayambultani peke anandrinai mepo anhopiye pwi. ");
INSERT INTO nss_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pwen unoh pe uya kulani singayai ara iro mbulu pwan, Animei na, singayai tam iye.> ");
INSERT INTO nss_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hapeko namandran tan isomwi yiy, ipa, <Wou ndramat para welemai pe kultuwayim pwassin! Pwen pe wou anpahasaniy tehe yo ngara kupo anandrinai mepo ndramat hamou ihisiy, pe ngara kumbultani anandrinai mepo ndramat hamou ipiye peken. ");
INSERT INTO nss_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pwen hiyan para aiki singayai to kiya nondriya yumwa singayai, pwen lang mepo nakumui kusa, ara andre kuwiri suran kiyapolon i.> ");
INSERT INTO nss_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pwen pe namandran tan ipwai, ipa, <Akawiri singayai kiya mawen kili yiy, pe akaikiy kiya kili yiy mepo atan mapusangat. ");
INSERT INTO nss_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Paratesah, hiyeh mamenmenan, ara andre Ngindrai kipo sura menmenan, pe atan, ara andre kihon kiya soyon iya. Hapeko yiy mepo menmenan pwi, konan hape sohoyan kimin, ara andre kawiriy topwei kiya mawen kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pe akasoyau kiyata ndramat para poya mbulen mepo ndrinameren soyon ara, ara kiya ngawan, pe kiya nondriya kol lokuhan, mepo andre hu koro rang malihu pe koro yandrisingi koltahu.> ");
INSERT INTO nss_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Pwen kiro mwonen Noru Ndramat nakisa kiyapolo nonowa nganan, pe hu angelou masih kene hu kasapolo yiy, ara andre kimpwan ndrohonoku mipwan tan, kiyapolo nonowa ngana kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pe hu ndraye ndramat para kol masih kene, ara andre hu kasa rawurehu koro mbulmaran, pe andre kisopat hu ndramat kaya malpat, tehe ndramat hamou para pwokereya hu sipsip, ngara kisopat hu sipsip kaya mawen kili hu meme. ");
INSERT INTO nss_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pe andre kiyki hu sipsip kaya pwen te niman mot, pe hu meme kaya pwen te niman kamou. ");
INSERT INTO nss_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pwen King andre kipwai kiya kili hu mepo huya pwen te niman mot, kipa, <Wawu mepo Tomo iripo toholi wawu, ara akasa pe akasawiri kolo king mepo ngara kiro mu kiya aliy, mepo Ngindrai kinmwaniyaniy pwen ata wawu, tandrohonga imangsani kol pwan irayah. ");
INSERT INTO nss_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Paratesah, yo umundrui pe wawu hang yo hapesah para kuyan. Pe koyu isapak pe wawu hang yo hapesah para kuyin. Pe yo ara tehe lah hamou, pe wawu wiri yo uya nondriya suwe wawu. ");
INSERT INTO nss_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Pe yo koiwe pwi, pe wawu hang yo koyau; pe yo umwa pe wawu sa pe wawu pwokarani yo. Yo uro nondriya kou, pe wawu sa koyum yo.> ");
INSERT INTO nss_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pwen hu ndramat hu mwonen, ara andre hu kasomwi yiy, hu kapa, <Yapan, yowu nime wou amundrui, pe yowu hang wou anandrinai, kahaleh? Ndre koyum isapak, pe yowu hang wou hapesah para ayin, kahaleh? ");
INSERT INTO nss_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pe yowu nime wou tehe lah hamou, pe yowu wiri wou asa nondriya suwe yowu, kahaleh? Ndre wou androisi koyau, pe yowu hang wou koyau, kahaleh? ");
INSERT INTO nss_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pe yowu nime wou amwa, ndre aro nondriya kou, pe yowu sa koyum wou, kahaleh?> ");
INSERT INTO nss_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pe King andre kisomwiy, kipa, <Yo upwai ndrokonan isa kili wawu, sehe melit wawu mbusiy iya kili nali hu aro, mepo ngalahu pwi masih, ara wawu mbusiy isa kili yo.> ");
INSERT INTO nss_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pwen King andre kipwai kiya kili hu mepo huya pwen te niman kamou, kipa, <Akaya mawen kili yo; Ngindrai kiniten ana wawu. Wawu kaya nondriya mwan mepo andre kinto-kinto, mepo Ngindrai kinmwaniyaniy pwen ata Sinai pe hu angelou tan. ");
INSERT INTO nss_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Paratesah, yo umundrui pe wawu kanhang yo hapesah para kuyan pwi. Pe koyu isapak, pe akanhang yo hapesah para kuyin pwi. ");
INSERT INTO nss_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yo tehe lah hamou, pe wawu mbuwali wawu para kusa nondriya suwe wawu. Yo undroisi koyau, pe wawu kanhang yo koyau pwi. Yo umwa, pe uro nondriya kou, pe wawu kansa pwokarani yo pwi.> ");
INSERT INTO nss_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pe andre hu kasomwi yiy, hu kapa, <Yapan, yowu nime wou amundrui, ndre koyum isapak, ndre wou lah hamou, ndre androisi koyau, ndre amwa, ndre aro nondriya kou, pe yowu kansopwat wou pwi, kahaleh?> ");
INSERT INTO nss_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pe andre kisomwiy, kipa, <Yo upwai ndrokonan isa kili wawu, sehe melit akanmbusiy kinna kili hu mepo ngalahu pwi masih aro pwi, ara akanmbusiy kinsa kili yo pwi yi.> ");
INSERT INTO nss_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pwen hu ndramat aro, ara andre hu kaya mawen pe kawiri kora nopwaran mepo andre kinto-kinto. Hapeko yihu ndramat imwonen, ara andre hu kawiri taleh mepo andre kinto-kinto.>> ");
INSERT INTO nss_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pe iro mwonen Yesu iwong iya hu melit masih kene aro ihipwen, pwen ipwai iya kili ndramiran hu, ipa, ");
INSERT INTO nss_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Wawu pahasaniy, tehe lenge Pasopa, ara lang maluwoh o hira ndron—pe Noru Ndramat, ara andre hu kaiki yiy kiya nimahu ndramat para hu karapaingi yiy kiya kei tondrih.>> ");
INSERT INTO nss_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pwen hu pris huhohin ta hu pris masih, pe hu yapane kol, ara husa rawurehu husa nondriya suwe pris ihohin ta hu pris masih kene, ngalan Kayapas. ");
INSERT INTO nss_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pe huro mburi nongan pe huro ten lohongai kokohe para kambultuwe tahatini Yesu pe katingundrun. ");
INSERT INTO nss_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pe hupa, <<Hapeko mbuna tukambusiy kiro nondriya Yon, matisan hu ndramat karambumbuwat pe karahatai.>> ");
INSERT INTO nss_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pwen Yesu iro kol Petaniy, iro nondriya seu ta ndramat hamou mepo ngara hu kapohowe yiy, Simon ndramat para Mwamwa Kawa. ");
INSERT INTO nss_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pe pihin hamou isa kili yiy iyapolo pwisi ndraikei sih mepo ndraikei mangonohon layin iro aliy, pe kenne ndraikei ara, ara namandran iya. Pe Yesu iyeroh ngilse keyau, pe pihin ara, ara itilingi ndraikei ara iya payan. ");
INSERT INTO nss_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pwen iro mwonen ndramiran hu, hunimei, ndrinahu, ara ilokuh. Pe husok, hupa, <<Paratesah pe itilingi ndraikei mangonohon layin ara, ara iya mwaihei opu? ");
INSERT INTO nss_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ndraikei mangonohon layin aro, ara ilahiy para kapopehei kiya aliy kiya singayai namandran, pe kaiki singayai para aliy kiya kili hu ndramat mepo hundroisiy.>> ");
INSERT INTO nss_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pe Yesu iyirowe tesah mepo huro wong iya aliy, pe ipwai iya kili hu, ipa, <<Paratapeh pe wawu tora wong ana pihin aro? Yiy, ara imbusi kultuw hiyan iya isa kili yo. ");
INSERT INTO nss_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yihu ndramat mepo hundroisiy, ara andre hu koro polo wawu lang masih, hapeko yo, ara andre kunto polo wawu waiye pwi. ");
INSERT INTO nss_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pihin aro itilingi ndraikei mangonohon layin aro isa mondro, ara imbusiy para kimwaniyani yo para toniyo. ");
INSERT INTO nss_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yo upwai ndrokonan isa kili wawu, hape aleheh nondriya kol pwan masih mepo hu kaya, pe hu kapohowe nongan hiyan aro kiya aliy, pwen tesah pihin aro kinmbusiy, ara andre hu katiyani tiyeyan, pe kalohongani yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pwen hamou tahu Songui Pe Lumou—mepo hupohowe ngalan Yutas Yiskariyot—ara iya kili hu pris huhohin ta hu pris masih, ");
INSERT INTO nss_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","pe isok, ipa, <<Wou andre aiki tesah kisato kapa kuratuni Yesu, pe kuiki yiy kisa nima wawu?>> Pwen pe husomwi yiy, pe husowani yiy iya sombule silwa matingui. ");
INSERT INTO nss_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pe iro lang ara iya, Yutas iro ten sehe sai hiyan para kiyki Yesu kiya nimahu. ");
INSERT INTO nss_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Iro nondriya lang imu para Yon para Lang Para Ndrinanohun Mepo Yis Aliy Pwi, hu ndramira Yesu husa kili yiy pe husok, hupa, <<Wou anamiliy para yowu karamwaniyani anandrinai tam para ayan kiro lenge Pasopa, kiro hape aleheh?>> ");
INSERT INTO nss_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pe Yesu isomwi hu, ipa, <<Akaya nondriya kol namandran, pe akaya kili ndramat aro, pe akapwai kiya kili yiy, akapa, <Ndramat para Hinonou ipa toro: Pakeh nakisa rahihini lenge ara. Pe yo nakulohongani lenge Pasopa kiyapolo ndramiro hu koro suwem.> >> ");
INSERT INTO nss_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pwen pe ndramiran hu humbusiy tehe Yesu kinpomwanye kinna kili hu, pe humwaniyani hu melit para Pasopa. ");
INSERT INTO nss_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pwen kol ipiyah, pe Yesu iyeroh ngilse keyau, iyapolo hu Songui pe Lumou. ");
INSERT INTO nss_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pe huro namnam manau pe ipwai, ipa, <<Upwai ndrokonan isa kili wawu, tehe hamou tawawu andre kiratuni yo.>> ");
INSERT INTO nss_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pe ndriyahu ara ipworu namandran iya, pe hamou iro pwassohi nongna hamou iya kili Yesu, huro pa, <<Yapan, andre yo, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pwen Yesu ipwai, ipa, <<Yiy mepo kintaimani niman kinna nondriya pwelekei sura yo, ara andre kiratuni yo. ");
INSERT INTO nss_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Noru Ndramat, ara andre kiyau ndruwa nongan tehe pwayan kinpwai, pe kintiyani tiyeyan. Hapeko toimwa sehe ndramat mepo andre kiratuni Noru Ndramat! Iya hiyan masih iyata ndramat ara, kapa tinan kinmwalahiy kinna tan pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pwen Yutas, ndramat mepo nakiratuni Yesu ara, ara ipa, <<Ndramat para Hinonou, andre yo, ndre?>> Pe Yesu isomwi yiy, ipa, <<Tehe anpwai ara.>> ");
INSERT INTO nss_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pe iro mwonen huro namnam, Yesu iwiri ndrinanohun pe itoholiy, pe iramburingiy, pe iykiy iya kili ndramiran hu, pe ipa, <<Akawiriy pe akainiy; iye ara nombuwe.>> ");
INSERT INTO nss_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pwen iwiri pweniu wain sih, pe irawuloh iya kili Ngindrai, pe iykiy iya kili hu, pe ipa, <<Wawu masih kene, akayin kiyau aliy. ");
INSERT INTO nss_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iye ara ndreye para tapaniu, mepo utilingiy para kisopwat hu ndramat soyon, para kitali hu pakut mwomwan tahu. ");
INSERT INTO nss_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yo upwai isa kili wawu, kiro mahapo kiya, andre kunyin kiyau ndrunu mbuwa wain iye paiwe pwi, kipoo kuyin kiyasura wawu kiya nimnim howen kiro nondriya kolo king mepo ngara kiro mu kiya aliy ta Tomo.>> ");
INSERT INTO nss_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pe hupowaliy sahin ihipwen, pwen huyau huya Ngondron para hu Holip. ");
INSERT INTO nss_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pwen Yesu ipwai iya kili hu, ipa, <<Nepo kiping, tunan yo ko, andre wawu masih kene kahandrundru pe akatali yo. Paratesah, pwayan kinpwai pwen, kinpa toro: <Andre kutingundru ndramat para pwokereya hu sipsip, pe andre hu sipsip kamasumbuwe.> ");
INSERT INTO nss_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hapeko kamulan kutine, ara andre kuro mu kili wawu kuya Kaliliy.>> ");
INSERT INTO nss_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pe Pita isomwi yiy, ipa, <<Konan kapa tunan wou, pe yihu masih kene aro hu kahandrundru, hapeko yo, andre kunhindrundru satam pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pe Yesu ipwai iya kili Pita, ipa, <<Yo upwai ndrokonan isa kili wou, tehe nepo kiping, pe tutut kintang mapu, andre apwai maporotisap tehe akowu to.>> ");
INSERT INTO nss_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pe Pita ipwai, ipa, <<Konan kapa kumat kiyasura wou, hapeko andre kunpwai tehe ukowu tam, ara pwi yoh.>> Pe ndramiran hu masih, ara hupwai iyawule tehen aliy yi. ");
INSERT INTO nss_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pwen Yesu iyau iyapolo ndramiran hu huya pinge holip hape, mepo hupohowei Ketsemani. Pe ipwai iya kili hu, ipa, <<Akorompwan iye, pe yo kuya yoro kuya tohun.>> ");
INSERT INTO nss_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pe iwiri Pita iyapolo NdraSepetiy malmou huyapolo yiy. Pe iro hingorowe ngandran, pe ndriyan ara iroporu. ");
INSERT INTO nss_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pwen pe yiy ipwai iya kili hu, ipa, <<Ndriyo, ara iporu namandran iya, pe pakeh tehe pakumat. Akoro iye kiyapolo yo, pe mara wawu kiro.>> ");
INSERT INTO nss_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pe iya hangoh hape mendreheh, pe iyos te kombuyen iya pwan pe itohun, ipa, <<O Tomo, kapa ilahiy, pwen awiri pweniu iripo kili yo aro kiya mawen. Hapeko mbuna kiho ndruwa namiliwo, konan; oho ndruwa namiliwam.>> ");
INSERT INTO nss_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pwen imui iya kili ndramiran hu matimou, pe inime hu huro matin. Pwen pe ipwai iya kili Pita, ipa, <<Wawu kanlahiy para mara wawu kiro, pe akoro memere kiyapolo yo kiho paramwandrai sih o, ndre? ");
INSERT INTO nss_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mara wawu kiro pe akatohun, pwen pe andre wawu kanyos kanna nondriya nohonou pwi. Weleso ita mwoiwa wawu, hapeko nombuwe wawu, ara imbuyei.>> ");
INSERT INTO nss_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pwen iya mawen poroluwoh i, pe itohun, ipa toro: <<O Tomo, kapa kinlahiy para awiri pweniu iripo kili yo aro kinna mawen pwi, andre kipoo kuimwiy, hiyan, oho ndruwa namiliwam pwokeyan.>> ");
INSERT INTO nss_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pwen imui isa, pe inime hu kanmatin paiwe yi, paratesah, marahu inun. ");
INSERT INTO nss_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pwen itali hu huro, pe iyau iya mawen porosih i, pe iya tohun porotoyoh i, pe iho ndruwa totohun tan para mamu ko. ");
INSERT INTO nss_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pwen imui iya kili ndramiran hu, pe ipwai iya kili hu, ipa, <<Wawu tora matin pe tora ngoh manau, ndre? Akanimei, lang kinsa pakeh pe Noru Ndramat, ara yihu nakaratuni yiy kiya nimahu ndramat pakut tahu mwomwan. ");
INSERT INTO nss_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Akatine, tukayau! Akanimei! Ndramat nakiratuni yo, ara kinsa!>> ");
INSERT INTO nss_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pwen Yesu iro wong manau, pe Yutas, hamou tahu Songui pe Lumou, ara isarayah. Yiy iyapolo hu ndramat soyon iya husa iyasura hu semela pahun niwen pe hu parakei. Hu pris huhohin ta hu pris masih, pe hu yapane hu ndramat, ara hupwandrisa hu husa. ");
INSERT INTO nss_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pe ndramat mepo nakiratuni yiy, ara kinpomwanye kinna kili hu kinna kaipisa melit handra, pe ipa toro: <<Ndramat mepo nakurahunghung kiya kili yiy, ara yiy ara kopu; akambultuwe tahatini yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pe Yutas iya mwonen iya kili Yesu pe irawulohani yiy, ipa, <<Yoping, Ndramat para Hinonou!>> Pwen irahunghung iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pe Yesu isomwi yiy, ipa, <<Kowase, ambusi tesah mepo asa iya aliy.>> Pwen hu ndramat ara, huhulun husa kili Yesu, pe hupwahatini yiy, pe humbultuwe tahatini yiy. ");
INSERT INTO nss_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pwen o, susuya Yesu hamou, ara niman iya semela pahun tan, pe iluwiy isa ngawan, pe isondriti ndrainga ndramat para pwandrendres ta pris ihohin ta hu pris masih kene, ara imut. ");
INSERT INTO nss_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pe Yesu ipwai iya kili yiy, ipa, <<Aiki semelam kimui kiya nokun. Paratesah, hu mepo hupo pahun iya semen, ara andre hu kamat kiya semen. ");
INSERT INTO nss_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wou akowu tehe ulahiy para kuyoh kiya kili Tomo, pe kihilingi yo, pe porosih o, andre kipwandrisa hu angelou soyon mepo ndromwoyahu iramwaitini mapuandrtingui pe lupou (72,000), ndre? ");
INSERT INTO nss_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hapeko kapa kumbusiy tehen tora, pwen Nongan Haiyan ta Ngindrai mepo kinpwai tehe andre kirayah tehen toro, ara andre kirayah mannan tapeh?>> ");
INSERT INTO nss_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pwen Yesu ipwai iya kili hu ndramat soyon iya, ipa, <<Yo ngara kuya mu kili hu ndramat para kangas marapahun, pwen pe wawu sa iyapolo hu semela pahun niwen, pe hu parakei para kasa mbultuwe yo, ndre? Lang masih ngara kurompwan nondriya kowa yumwa totohun namandran, pe ngara kuro hinuwani hu ndramat, pe wawu kansa mbultuwe tahatini yo pwi. ");
INSERT INTO nss_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Hapeko hu melit masih aro, ara irayah para hu nongna hu poropet mepo kantatuluwiy, ara karayah mannan.>> Pwen hu ndramira Yesu ara hutali yiy pe huwop topwei. ");
INSERT INTO nss_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pwen yihu mepo humbultuwe tahatini Yesu, ara huwiri yiy iya suwe Kayapas, yiy pris ihohin ta hu pris masih kene. Pe hu ndramat para hinuwani nongan para pwahanou, pe hu yapane kol, ara hu kansa rawurehu pwen huro aliy. ");
INSERT INTO nss_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pe Pita, ara iho ndruwa Yesu, hapeko iho ndron mwanan hape. Pe iya tusuye iya kowa yumwa pris ihohin. Pwen isong iya nondriyan, pe impwan iyapolo hu makundrayin, para kinime tesah nakirayah. ");
INSERT INTO nss_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pe hu pris huhohin ta hu pris masih, iyasura hu Sanhetrin masih tahu Yutah, ara huro ten lohongai pwasoyou iya tesah Yesu kinmbusiy; pwen pe tunan ara ko, andre hu kalahiy para katingundrun kimat. ");
INSERT INTO nss_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pe konan hu ndramat soyon para tasusut nongan pwasoyou iya kili Yesu, ara husa, hapeko yihu Sanhetrin, ara huten lohongai ndrit. Pwen iyamulan hilu ndramat malmou hilsa, ");
INSERT INTO nss_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","pe hilpa, <<Ndramat aro ipa, <Yo ulahiy para kuloiwani yumwa totohun namandran ta Ngindrai, pe kiho nondriya lang maroyoh o, andre kupuliy paiwe.> >> ");
INSERT INTO nss_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pwen pris ihohin ta hu pris masih kene, ara itine pe ipwai iya kili Yesu, ipa, <<Wou andre asomwiy, ndre pwi? Aripo sehe titiye mepo hu ndramat aro topo ratuni wou iya aliy?>> ");
INSERT INTO nss_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hapeko Yesu ihun o iro. Pwen pris ihohin ta hu pris masih kene, ara ipwai iya kili yiy, ipa, <<Yo upwatisingiy isa kili wou, para arandrangan kiya ngala Ngindrai mwalen—kiya, apwai ndrokonan kisa kili yowu, wou ara Mesayah, Noru Ngindrai Kamai, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Pe Yesu isomwi yiy, ipa, <<Tehe anpwai ara. Hapeko upwai isa kili wawu masih kene toro: Lang itapo isa kamulan, wawu andre kanime Noru Ndramat kirompwan kiyapwen te nima Ngindrai mot, mepo yiy Pwokeyan Masih, pe andre kisa kiho ndrita hu kokom para yang.>> ");
INSERT INTO nss_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pwen pris ihohin ta hu pris masih kene, ara ile koiwen pe, ipa, <<Yiy kinpwasisiman ana Ngindrai! Paratesah andre tukaten hu ndramat para kapwokeyani nongan i? Akanimei! Wawu kanhilingiy mahapo tehe kinpwasisiman ana Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wawu lohonganiy tapeh?>> Pe husomwiy, hupa, <<Yiy ilahiy para kimat kiya nongnan ara.>> ");
INSERT INTO nss_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pwen husokombunuhi mbulmaran, pe hu hukuwani mbutimahu pe hurayi yiy iya aliy. Pe hayah tahu, ara huhusili yiy. ");
INSERT INTO nss_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Pe hupa, <<Mesayah, kapa wou poropet hamou, pwen apwai: hiyeh iripo rayi wou eh?>> ");
INSERT INTO nss_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pwen Pita iyempwan ngawan, nondriya kowa suwe pris ihohin, pe pihin hamou para poya mbulen isa kili yiy, pe ipa, <<Wou aro sura Yesu para Kaliliy yi.>> ");
INSERT INTO nss_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hapeko Pita ipwasarahaniy iro mbulmarahu masih, ipa, <<Ukowu sehe nongan atapwai.>> ");
INSERT INTO nss_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pwen pe iyau iya poho mara karam para kowa seu ara, pe pihin hamou i inime yiy pe ipwai iya kili hu ndramat huro ara, ipa, <<Ndramat aro ara iro sura Yesu para Nasaret.>> ");
INSERT INTO nss_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pe Pita irandrangan pe ipwasarahaniy paiwe, ipa, <<Yo ukowu ta ndramat ara.>> ");
INSERT INTO nss_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iyamulan hape yi, yihu mepo huro tine ara, ara huya kili Pita, pe hupa, <<Pe wou ara hamou tahu yi, paratesah, mbulukoyum, ara iyingani wou.>> ");
INSERT INTO nss_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pwen iten anan pe irandrangan iya kili hu, ipa, <<Yo ukowu ta ndramat ara!>> Pe hape pwi ko, tutut irang. ");
INSERT INTO nss_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pwen Pita ilohongani nongna Yesu mepo kinpwai, kinpa, <<Tutut kintang mapu, andre apwai maporotisap tehe akowu to.>> Pwen iyau iya ngawan pe iya rang turuwe yiy. ");
INSERT INTO nss_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pwen makohuping o, hu pris masih mepo huhohin ta hu pris masih, pe hu yapane hu ndramat, ara humburi lohongai para katingundru Yesu kimat. ");
INSERT INTO nss_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pwen huwasi yiy pe huluwani yiy iya mawen, pe huyaiki yiy iya kili Pailat, yiy mepo pohon para kol namandran iya ara. ");
INSERT INTO nss_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pe iro mwonen Yutas, mepo kintatuni Yesu, ara inimei tehe hu kanmburi lohongai para kaiki koran kiya ndrita Yesu, pwen hingorowan iramari yiy iya namandran iya, pe iyaiki sombule silwa matingui ara, imui iya kili hu pris huhohin ta hu pris masih, pe hu yapane kol. ");
INSERT INTO nss_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Pe ipa, <<Yo kunmbusi pakut mwomwan, paratesah, yo kuntatuni ndramat mepo kinmbusi handra mwomwan pwi.>> Pe hupwai iya kili yiy, hupa, <<Ara handra lohonga yowu pwi; kinna konam ara.>> ");
INSERT INTO nss_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pwen pe Yutas ihindrikirani singayai ara, ara iya nondriya yumwa totohun namandran, pe iyau. Pwen iyau iya mawen, pe iya ndrusuwan. ");
INSERT INTO nss_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pe hu pris huhohin ta hu pris masih, ara hulokihi hu sombule silwa ara, pe hupa, <<Nongan para pwahanou ipwai tehe singayai aro, ara kenne ndreye ndramat mepo kanitingundrun ara. Pe nonombun para kaikiy kiya ndrohonoku singayai para yumwa totohun.>> ");
INSERT INTO nss_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pwen humburi lohongai para kawiri singayai ara, pe karapaya pwan ta ndramat para peneya kohoi, para kirayah ndrohonoku tona hu ndramat para mawen. ");
INSERT INTO nss_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pwen tehen tora ko, pwan hape ara, hu ngara kapohowe ngalan ara Ndroho Ndrondroi, iro tandrohongan ara, ipoo isa matnen mahapo. ");
INSERT INTO nss_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pwen nongan mepo poropet Yeremayah kinpwai kinna, ara kintayah mannan, ipa toro: <<Huwiri hu sombule silwa matingui, kennen mepo yihu ndramira Yisrayel kaniykiy para sowa ndramat ara, ");
INSERT INTO nss_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","pe huwiri singayai ara, pe hurapaya pwene ndramat para peneya kohoi, tehe Yapan kinpwandrandrahaniy kinsa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pe Yesu iro tine mbulmara Pailat, pe Pailat isok yiy, ipa, <<Wou king tahu Yutah, ndre?>> Pe Yesu isomwiy, ipa, <<Tehe anpwai ara.>> ");
INSERT INTO nss_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pwen hu pris huhohin ta hu pris masih, pe hu yapane kol, ara hu tasusut nongan iya kili Yesu, hapeko kinsomwi hu pwi. ");
INSERT INTO nss_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pwen Pailat isok yiy, ipa, <<Wou anhilingi titiye soyon mepo hutora tasusut isa kili wou pwi, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hapeko Yesu kinsomwi handra nongan mepo huro tasusut iya kili yiy, ara pwi masih—pe imbusi Pailat irapayan ndrit. ");
INSERT INTO nss_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kiro mwonen Yon Para Pasopa nondriya hayou sih tehe sih, Pailat ngara kitali ndramat hamou kiro nondriya kou kisa ngawan. Hu ndramat masih ngara hu karakinima sehe ndramat mepo hunamiliy para kisa ngawan, pwen Pailat andre kitali ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iro lang ara, ndramat hamou iro kou, ngalan Parappas, kultuwayin ara mwomwan masih, pe hu ndramat hupahas iyatan. ");
INSERT INTO nss_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pwen pe iro mwonen hu ndramat soyon hu kansa rawurehu, Pailat isok hu, ipa, <<Wawu namiliy para kutali hiyeh ta hilu malmou aro kisa kili wawu, Parappas ndre Yesu mepo hupohowe yiy Mesayah?>> ");
INSERT INTO nss_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ipahasaniy tehe huiki Yesu iya niman, paratesah, humaimai anan. ");
INSERT INTO nss_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat, ara irompwan manau ndrita pwapwai ndrohonoku tamwanye, pe nambuyun ipwanos nongan iya kili yiy, ipa toro: <<Wou mbuna ambusi hapesah kiya kili ndramat mepo kinmbusi handra mwomwan pwi ara, paratesah, yo unihiyani yiy lang nepo ko, pe imbusi yo uhungorowe ngandran namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hapeko hu pris huhohin ta hu pris masih, pe hu yapane kol, ara hurakekeyani hu ndramat soyon para hu kasok Pailat para kitali Parappas, pe kipwai para hu katingundru Yesu. ");
INSERT INTO nss_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pwen Pailat isok hu, ipa, <<Hiyeh ata hilu malmou aro wawu namili para kutali yiy kisa kili wawu?>> Pwen husomwiy, hupa, <<Parappas.>> ");
INSERT INTO nss_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pe Pailat isok, ipa, <<Pwen, yo andre kumbusi tapeh kiya kili Yesu, mepo hupohowe yiy Mesayah?>> Pe hu masih husomwiy, hupa, <<Karapaingi yiy kiya kei tondrih!>> ");
INSERT INTO nss_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pe Pailat isok, ipa, <<Paratesah? Yiy imbusi sehe kultuw mwomwan?>> Hapeko hupalngai namandran iya, hupa, <<Karapaingi yiy kiya kei tondrih.>> ");
INSERT INTO nss_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pe Pailat, ara ipahasaniy tehe andre yihu kanhilingi yiy pwi. Hapeko huro tambumbuwat pe hu pakarahatai. Pwen iwiri ndran pe isungani niman iro mbulmarahu, pe ipa, <<Ndreyen andre kinto nimo pwi! Kinna kona wawu ara!>> ");
INSERT INTO nss_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pe hu ndramat masih husomwiy, hupa, <<Ndreyen, ara kinna kona yowu pe ndraye yowu hu.>> ");
INSERT INTO nss_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pwen itali Parappas iya kili hu Yutah. Hapeko ipwai para hu ndram kamwiriyani Yesu, pe iyki yiy iya nimahu para hu karapaingi yiy kiya kei tondrih. ");
INSERT INTO nss_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pwen hu ndram ata kapman, ara huwiri Yesu iya nondriya suwe kapman, pe hu ndram para pahun masih husa rahakowan. ");
INSERT INTO nss_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pe huhutasak iya koiwen, pe husuluye yiy iya koyau laman hamou. ");
INSERT INTO nss_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pe huwiri malkei hamou maporon, pe hurakayaniy tehe kasapai ta king, pwen huikiy iya payan. Pe huiki nes sih iya niman mot, pe hutukuruhu huro mbulmaran, pe hupwasimiri yiy, hupa, <<O yapane yowu, wou king tahu Yutah!>> ");
INSERT INTO nss_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pe husokombunuhi yiy pe huwiri nes ara, pwen huti payan ken iho ken. ");
INSERT INTO nss_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hupwasimiri yiy ihipwen, pwen hutali koyau laman ara isa mawen kili yiy, pe husuluye yiy iya koiwen mbukenan. Pwen huluwani yiy iyau iya mawen, para hu kaya rapaingi yiy kiya kei tondrih. ");
INSERT INTO nss_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pwen huropo huya ngawan pe hupohonani ndramat hamou para kol namandran Sairini, ngalan Simon. Pe hurakekeyani yiy para kikuni kei tondrih ta Yesu. ");
INSERT INTO nss_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pe husa hape aleheh mepo hopohowei Kolkota, (mbulndroiyi nongan ara, ara ipa, Ndroho Ndruwi Paya Ndramat). ");
INSERT INTO nss_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pe huhang Yesu wain, mepo kansulyaniy kinnapolo ndran ngahan, para kiyin, hapeko ihingoruwe kanan, pe mbuwalin para kiyin. ");
INSERT INTO nss_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pe hu kantapaingi yiy kinna kei tondrih ihipwen, pwen hunonoyou satu para karahihiri koiwen. ");
INSERT INTO nss_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe hurompwan ara, pe huro memerani yiy. ");
INSERT INTO nss_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pe huratuluwi nongan para koran, pe huikiy iho ndrita payan, ara ipa toro: <<ARO, ARA YESU, KING TAHU YUTAH.>> ");
INSERT INTO nss_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pe hilu ndramat malmou para pahana, ara hurapaingi hilu hilho polo yiy, hamou iyapwen te niman mot, pe hamou iyapwen te niman kamou. ");
INSERT INTO nss_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pe hu ndramat huropo husayau, ara hupwasimiri yiy, pe hupatumbuye payahu iyatan, ");
INSERT INTO nss_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","pe huro pa, <<O, wou mepo apa andre aloiwani yumwa totohun namandran, pe kiho nondriya lang maroyoh o, andre apuliy paiwe, kiya, asopwat wou mbukenam! Kapa wou Noru Ngindrai Kamai, pwen asapwan kei tondrih!>> ");
INSERT INTO nss_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pwen tehen aliy opu, hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, pe hu yapane kol, ara hupwasimiri yiy. ");
INSERT INTO nss_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pe hupa, <<Yiy kinsopwat hu hayah, hapeko kinlahiy para kisopwat yiy mbukenan pwi! Yiy, ara King tahu Yisrayel! Mahapo ko, kisapwan kei tondrih, pwen andre tukapwotisingi lohonga rou kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Lohongan ipwotisingi Ngindrai, pwen mahapo Ngindrai kisopwat yiy, kapa kinamili yiy. Paratesah, kinpwai, kinpa, <Yo Noru Ngindrai Kamai.> >> ");
INSERT INTO nss_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pwen tehen aliy opu, hilu ndramat para pahana mepo hurapaingi hilu iya kei tondrih hilho polo yiy, ara hiluro hindringndring anan. ");
INSERT INTO nss_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pe paramwandrai iho ndrokololang, pwen kol ilokuh ipoo iya piyahon, pe paramwandrai iya iho tehe maroyoh. ");
INSERT INTO nss_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pe paramwandrai iya iho tehe maroyoh, pe Yesu iwayeh pwokeyan iya, pe ipa, <<Eli, Eli, lama sapaktani?>>—Nongan aro, iya nongna kolon, ara ipa toro: <<Ngindrai to, Ngindrai to, paratesah antali yo?>> ");
INSERT INTO nss_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pe iro mwonen yihu hayah huro tine pakeh ara huhilingiy, pwen hupa, <<Yiy ita yoh Eliyah.>> ");
INSERT INTO nss_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hape pwi ko, hamou tahu ingap iya, pe iwiri nanmam. Pe itaimaniy iya wain susuwen, pe iwasiy iya kou sih, pe ihiriy iya kili Yesu para kiyin. ");
INSERT INTO nss_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pe hu masih tahu, ara hupa, <<Kiro tahandren tora. Tukoro pe kanimei na, matisan Eliyah kisa pe kisopwat yiy.>> ");
INSERT INTO nss_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pwen Yesu iwayeh pwokeyan paiwe, pe itali mwoiwan iyau pe imat. ");
INSERT INTO nss_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iro mwonen paramwandrai ara ko, ndrihiyap namandran iho ndrungak nondriya yumwa totohun namandran, ara ilen iya maltoh. Ilen iho paingan, pe isandrek isa pwan. Pe kol pwan inunuw, pe hu pat ara humbuterenging. ");
INSERT INTO nss_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pe hu ngat sou para tona ndramat, ara hute, pe nombuwe hu ndramat haiyan soyon mepo hu kanmat, ara husa tine paiwe. ");
INSERT INTO nss_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pe husa ngawan ngarehu, pe iyamulan para Yesu isa tine paiwe, yihu ndramat ara, ara huya nondriya kol namandran haiyan Yerusalem, pe huyarayah huya kili hu ndramat soyon. ");
INSERT INTO nss_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pe iro mwonen ndram mepo ihohin tahu ndram masangat, pe hu mepo huro memerani Yesu, ara hunime nunuw, pe hu melit masih kantayah, pwen hunoh turuwehu, pe hupa, <<Ndrokonan masih, yiy Noru Ngindrai Kamai!>> ");
INSERT INTO nss_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pe hu pihin soyon huro ariya, pe huro ndron mwanan hape pe huro nimnim. Hu pihin ara, huho ndruwa Yesu huro Kaliliy pe husa, para hu kapwokere yiy. ");
INSERT INTO nss_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pe iro mwalinga hu pihin ara, ara Mariya para Maktala, pe Mariya tina Yamis hilu Yosep, pe tina NdraSepetiy malmou. ");
INSERT INTO nss_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pwen kol iro piyah, pe ndramat hamou menmenan soyon para kol Arimateya, ngalan Yosep, ara isa. Pe yiy kintayah ndramira Yesu hamou. ");
INSERT INTO nss_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pe iya kili Pailat, pe isok para kiwiri nombuwe Yesu, pwen Pailat ipwandrandrahaniy iya kili hu ndram para hu kaiki nombuwe Yesu kiya kili Yosep. ");
INSERT INTO nss_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pe Yosep iwiri nombuwe Yesu, pe isumwai iya koyau hamou howen, ");
INSERT INTO nss_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","pe iyaikiy iya nondriya ngat sou howen atan mbukenan mepo kinsoyei pwen iro. Pe itiriyani pat sih namandran iya, pe iwari pohomara ngat ara, iya aliy, pwen iyau. ");
INSERT INTO nss_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pe Mariya para Maktala iyasura Mariya hamou i, ara hilrompwan iyapwen haroh para ngat ara. ");
INSERT INTO nss_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pwen Lang Para Ponokule Sapat ihipwen, pe iya lang sih i, hu pris huhohin ta hu pris masih kene pe hu Parisiy, ara huya kili Pailat. ");
INSERT INTO nss_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pe hupwai iya kili yiy, hupa, <<Namandran, yowu lohonganiy tehe ndramat para pwakeriu ara, ara mapu kinmat, yiy ipa, <Lang maroyoh kihipwen, andre kusatine paiwe.> ");
INSERT INTO nss_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pwen pe apwatisingiy para koro memerani ngat, kipoo kiya lang maroyoh. Matisan ndramiran hu, ara hu kasa, pe kapahanowe nombuwen, pe hu kapwai kiya kili hu ndramat tehe yiy kintine paiwe. Pwandrandraman aro, ara andre kiramwaitini pwandrandraman para mamu.>> ");
INSERT INTO nss_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pe Pailat isomwi hu, ipa, <<Akawiri hu ndram pe akaya mbusi sehe melit mepo wawu lahiy para kambusiy, para akoro memerani ngat kiya hiyan.>> ");
INSERT INTO nss_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pwen pe huya singori ngat para tona ndramat ara, pe hurapairani kinima songot iro pat, pe huiki hu ndram para hu koro memeraniy. ");
INSERT INTO nss_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iyamulan para lang Sapat, pe lang iro mbungahiy, para lang iho mu para sandre sih, pwen Mariya para Maktala pe Mariya hamou i, ara hilya para kaya nime ngat. ");
INSERT INTO nss_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pe indrou pwi ko, nunuw namandran iya irayah, paratesah, angelou hamou ta Yapan iyau kol paingan yang isa pwan, pe iya ngat pe itiriyani pat iya mawen, pe impwan ndritan. ");
INSERT INTO nss_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pe kaipisan tehe kamit, pe koiwen ara pallen iya tehe koh. ");
INSERT INTO nss_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pe hu ndramat para memere, ara hunoh turuwehu iyatan, pe hulelen pe mwensehu, ara hurayah tehe hu ndramat kanmat. ");
INSERT INTO nss_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pe angelou ipwai iya kili hilu pihin malmou ara, ipa, <<Walu mbuna alkanoh, paratesah, tono tehe walu tora ten Yesu mepo hu kantapaingi yiy kinna kei tondrih. ");
INSERT INTO nss_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yiy kinto iye pwi, yiy kintine, imwonen tehe kinpwai. Walu kasa nime nokun mepo iyen aliy. ");
INSERT INTO nss_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kiya, walu kaleheleh pe kaya pwai kaya kili ndramiran hu toro: <Yiy kintali kimat pe kintine paiwe, pe andre kiro mu kili wawu kiya Kaliliy. Pe wawu andre kaya nime yiy kaya aliy.> Kiya, yo kunese ndrainga walu ara.>> ");
INSERT INTO nss_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pwen pe hilu pihin malmou ara, ara hilu himbuh o, hilyau hilya mawen ngat. Pe hilu noh, hapeko pwesai namandran iwiri hilu, pe hilu ngap para hilkaya tiyaniy kiya kili ndramira Yesu hu. ");
INSERT INTO nss_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pe indrou pwi ko, Yesu ipohonani hilu, pe ipa, <<Mandroulang!>> Pwen hilya kili yiy pe hilu mbultuwe ngondrokan, pe hilhiri ngalan. ");
INSERT INTO nss_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pwen Yesu ipwai iya kili hilu, ipa, <<Walu mbuna alkanoh. Walu kaya pwai kaya kili nali hu para hu kaya Kaliliy, pe andre hu kaya nime yo kaya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hilu pihin malmou, ara hilro tokai manau hilya, pe hu ndram hayah para memere, ara huya nondriya kol namandran, pe huya tiyaniy iya kili hu pris huhohin ta hu pris masih, iya hu melit masih mepo hu kantayah. ");
INSERT INTO nss_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pwen hu pris huhohin ta hu pris masih, ara huya rawure huyapolo hu yapane kol, pe humburi lohongai, pe huiki singayai namandran iya, iyata hu ndram. ");
INSERT INTO nss_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pe hupwai iya kili hu, hupa, <<Wawu katiyaniy, akapa toro: <Ndramiran hu, ara husa pinge ping pe hupahanowe yiy kinnau, iro mwonen yowu ro matin.> ");
INSERT INTO nss_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pe kapa titiye iye kiyarayah kiya ndrainga pohon para kapman, pwen andre yowu karamwanye lohongan, pe wawu andre kanwiri nopwaran pwi.>> ");
INSERT INTO nss_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pwen pe hu ndram huwiri singayai ara, pe humbusi tesah mepo hu pris huhohin ta hu pris masih pe hu Parisiy, hu kanpomwanye kinnata hu kinna aliy. Pe titiye aro, kinsilihi hu Yutah masih, ita ipoo isa matnen lang mahapo yi. ");
INSERT INTO nss_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pwen hu ndramiran songui pe hamou, ara huya Kaliliy, pe huya ngondron mepo Yesu kinpwai para hu kaya aliy. ");
INSERT INTO nss_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pe iro mwonen hunime yiy, ara huhuri ngalan, hapeko hu hayah tahu, ara huhindrundru. ");
INSERT INTO nss_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pwen Yesu isa kili hu, pe ipa, <<Pwoke nopwaran masih ita kol paingan yang pe iripo kol pwan, ara Ngindrai kiniykiy topwei kinsa kili yo. ");
INSERT INTO nss_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pwen ndroiyin aro ko, akaya pe akahanuwani hu ndraye ndramat masih kene para hu karayah ndramiro. Pe akasumuluwani hu kiya ngala Tomo, pe Norun, pe Mwoiwan Haiyan. ");
INSERT INTO nss_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pe akahanuwani hu para hu koho ndruwa nongan masih kene, mepo kunpwandrandrahaniy kinsa kili wawu. Pe ndrokonan masih, yo, ara urupo sura wawu lang masih, kipoo kiya matne lang kiyahapwen.>> ");
INSERT INTO nss_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aro ara ndroiyi nongan hiyan ta Yesu Kristus, noru Ngindrai Kamai. ");
INSERT INTO nss_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Poropet Yisayah kinratuluwiy pwen, ipa toro: <<Animei, yo andre kupwandrisa ndramat para sapiya nongno kiho mu kili wou, pe andre kiramwaniyani meresayam. ");
INSERT INTO nss_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ngasa mbulukoyu hamou itayoh iyau kol ndrohoyin, ipa, <Karamwaniyani saya Yapan, pe kasani meresayan kiro mwonen.> >> ");
INSERT INTO nss_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pwen pe Yohanes Ndramat para Paptais, isa pe iro sumuluwani hu ndramat iyapwen te kol ndrohoyin, pe iro pohowe nongan para hu ndramat karapaiwani ndriyahu, pe kawiri paptais para Ngindrai kitali hu pakut mwomwan tahu. ");
INSERT INTO nss_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hu ndramat masih para Yerusalem iyasura hu ndramat para kol hakol-hakol nondriya kol namandran hape Yutiya ara huya kili Yohanes. Pe huya pohopoh iya hu pakut mwomwan tahu iya ngawan, pwen isumuluwani hu iya Ndran Yortan. ");
INSERT INTO nss_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes, ara koiwen husoruwei iyau yomu kamel, pe kondrei irakayani kundrayin, ara humangsaniy iyau kapilo mbulmwakau. Pe ngara kiyan hu kaspou pe kunan para yangiy. ");
INSERT INTO nss_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pe iye, ara nongnan: <<Ndramat hamou mepo nakisa kamulan, ara pwoke tan pwokeyan pe iho hin kili yo. Yo kunlahiy para kutukuruhu, pe kulombuli malkeye hatna pwelekan pwi. ");
INSERT INTO nss_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yo urupo sumuluwani wawu iya ndran, hapeko yiy, ara andre kisumuluwani wawu kiya Mwoiwan Haiyan.>> ");
INSERT INTO nss_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lang sih aro, Yesu ipwen te Nasaret, kol hakol ita nondriya kol namandran hape Kaliliy, pe isa kili Yohanes. Pwen Yohanes isumuluwani Yesu iya Ndran Yortan. ");
INSERT INTO nss_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu itine iro ndran iropo isa paingan, pe hape pwi ko, inime yang ite, pe Mwoiwa Ngindrai isa pwan kili yiy tehe nombuwe pai hamou. ");
INSERT INTO nss_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pwen ngasa mbulukoyu hamou iyau kol paingan yang isa, pe ipa, <<Wou ara Noru, pe ndriyo imbuluhi wou. Yo upwes satam namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Indrou pwi, Mwoiwa Ngindrai ipwandrisa Yesu iya kol ndrohoyin. ");
INSERT INTO nss_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iya iyen aliy iya matne lang mahaangui, pe nondriya lang mahaangui ara, Sinai isa pe pakipakarawani yiy. Yesu iro aliy iyasura hu kan puyap, pe hu angelou husa pe husopwat yiy. ");
INSERT INTO nss_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Iyamulan para Yohanes iya nondriya kou, Yesu iya nondriya kol namandran hape Kaliliy pe ipohowe nongan hiyan ta Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ipwai, ipa, <<Lang kintayah pwen, pe kolo king Ngindrai mepo andre kiro mu kiya aliy, ara kinsa pakeh. Wawu karapaiwani kultuwayi wawu, pe lohonga wawu kipwotisingi nongan hiyan.>> ");
INSERT INTO nss_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pwen porosih aro, Yesu iropo iya pwaki Ndran Makaiye Kaliliy, pe inime Simon iyapolo nalin Antruw. Hilro piye kahu iya nondriya ndran makaiye Kaliliy, paratesah, hilu, ara ndramat para poya ni. ");
INSERT INTO nss_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pwen Yesu ipwai iya kili hilu, ipa, <<Walu kasa koho ndruwo, pe andre kuhunuwani walu para alkarayah ndramat para poya ndramat.>> ");
INSERT INTO nss_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Indrou pwi ko, hilu tali kahu ta hilu pe hilu ho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu iropo iya hangoh hape, pe inime NdraSepetiy malmou, Yamis pe nalin Yohanes. Hiluro nondriya ndroi hakou, pe hiluro soro hu kahu tahu. ");
INSERT INTO nss_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Indrou pwi ko, iyoh hilu pe hilu tali tama hilu, Sepetiy. Tama hilu, iyapolo ndramiran hu para poya mbulyan, ara huro ndron nondriya ndroi, pe hilu ho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pe huya kol hakol ngawan ngalan Kapernawum. Iro mwonen lang Sapat isarayah, Yesu iya nondriya yumwa mbultere tahu Yuta iro ara, pe iro hinuwani hu ndramat. ");
INSERT INTO nss_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hu ndramat ariya, ara huro lohonge ndrit iya nongnan mepo iro hinuwani hu iya aliy, paratesah, kinwong tehe hamou ndramat para hinuwani nongan para pwahanou tahu pwi, hapeko iro wong, ara tehe ndramat mepo nongnan nopwaran. ");
INSERT INTO nss_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Indrou pwi, ndramat hamou iro nondriya yumwa mbultere tahu Yuta, ara payit iro ndritan, pe iwayeh ipa, ");
INSERT INTO nss_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Yesu para Nasaret! Wou nasahaye yowu? Wou asa para apwalngani yowu, ndre? Yo ara upahasani wou hiyeh—wou ara Ndramat Haiyan ata Ngindrai!>> ");
INSERT INTO nss_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pe Yesu ipalngai ana payit, ipa, <<Amun opu! Pe atali yiy asa ngawan!>> ");
INSERT INTO nss_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pe payit ileleyani ndramat ara, pe iwayeh pwokeyan iya, pwen itali yiy. ");
INSERT INTO nss_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pwen hu ndramat masih huro lohonge ndrit, pe hamou iro pwai iya kili hamou, huro pa, <<Aripo tesah? Hinonou handra howen ara—iyapolo pwoke nopwaran! Ndramat ara ipwandrandrahani hu payit i, pe huhilingi nongnan.>> ");
INSERT INTO nss_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pwen pe nola Yesu, ara ingau, pe hape pwi ko, isilihi kol masih ita nondriya kol namandran hape Kaliliy. ");
INSERT INTO nss_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iro mwonen hutali yumwa mbultere tahu Yuta husa ngawan, hurukai huya sura Yamis hilu Yohanes huya seu ta Simon hilu Antruw. ");
INSERT INTO nss_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Huya pe nossu Simon imwa, pe mandran ingandrah pe iye pwan. Yesu iya pe hutiye ndraingan. ");
INSERT INTO nss_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pwen Yesu iya, pe imbultuwe niman, pe isoli yiy itine. Pwen pe mandran mepo iro ngandrah, ara itali yiy. Pwen itine pe ipo mbulyan. ");
INSERT INTO nss_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kol kinpiyah pwen, pe paramwandrai kinna lai, pwen pe huwiri hu ndramat masih humwa, pe hu ndramat masih mepo hu payit huro ndritahu, ara husa kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Hu ndramat masih para kol aro, husa wule huro pohomara karam. ");
INSERT INTO nss_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu isopwoyani mwamwa handra-handra tahu ndramat soyon iya, pe irasses hu payit soyon iya, huya mawen. Hapeko Yesu isiyi poho hu payit para hu mbuna kawong, paratesah, hupahasani yiy hiyeh. ");
INSERT INTO nss_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Makohuping para lang sih, pe kol imbungahiy, Yesu itine pe iyau iya kol hape imanun mepo ndramat aliy pwi; pwen iya pe iro tohun. ");
INSERT INTO nss_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pwen Simon iyasura yowen hu ara huya ten yiy. ");
INSERT INTO nss_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pwen hukahi Yesu pe hupwai iya kili yiy, hupa, <<Hu ndramat masih huropo ten wou.>> ");
INSERT INTO nss_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu ipwai imui iya kili hu, ipa, <<Worou tukaya hu kol hayah mendreheh pakeh, para kuya tiyani nongan kiya kili hu yi. Ndroiyin ara ko, usa iya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pwen iya kol namandran hape Kaliliy masih, pe iro pohowe nongan iya nondriya hu yumwa mbultere tahu Yuta, pe iro rasses hu payit huyau. ");
INSERT INTO nss_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pwen ndramat hamou mepo mwamwa kawa iro mandrakuyun, ara isa pe itukuruhu iya mbulmara Yesu, pe ipa, <<Kapa welem kiso, alahiy para ambusi yo kurayah howen kiya mbulmara Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu ara, koyun isikirani yiy, pe niman iyah iya, pe iyahatek iyatan, pe ipa, <<Wele iso. Arayah howen.>> ");
INSERT INTO nss_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Indrou pwi ko, mwamwa kawa itali yiy, pe mandran iya howen. ");
INSERT INTO nss_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pwen Yesu ipwandrisa yiy iyau, pe ipwatisingiy pwokeyan iya kili yiy ipa, ");
INSERT INTO nss_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","<<Mbuna aranenese kiya kili hamou iya tesah kinsarayah kili wou. Hapeko aya yingani wou aya kili pris, para kitimwi yukyuk mepo Mose kinpwandrandrahaniy para arayah howen kiya mbulmara Ngindrai. Pe andre kirayah tehe tiyeyam kiya kili hu pris.>> ");
INSERT INTO nss_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hapeko pwi; ndramat ara itiyani titiye aro pe ingau iya ngawan iya marakol masih. Pwen tehen toro ko pe Yesu kinlahiy kinna kol ngawan mbulmara hu ndramat pwi. Yiy iro ndron kol mawen mepo ndramat aliy pwi, hapeko hu ndramat huyau kol masih kene, pe ngara hu kasa kili yiy. ");
INSERT INTO nss_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lang hayah iyamulan, Yesu imui iya Kapernawum, pe nongan ingau tehe Yesu kinmui kinsa wum. ");
INSERT INTO nss_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pwen ndramat hitun husa wule, pe nondriya seu iyapolo pohokaram kene, ara masih ipep topwei tahu ndramat. Pe Yesu iro tiyani nongnan iya kili hu. ");
INSERT INTO nss_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pwen hu ndramat hayah husa kili Yesu, iyapolo hu mahaamou mepo huhuri ndramat hamou mandran imat. ");
INSERT INTO nss_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pe wum indrap tahu ndramat, pe hu kanlahiy para kahari ndramat ara, kisa pakeh kili Yesu pwi. Pwen pe huhuri yiy iya payandroha wum, pe hurambuskehe payandroha wum hape, pe huyuwani yiy ma nokun iya pwan mbulmara Yesu. ");
INSERT INTO nss_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pwen Yesu inime lohongahu ndrisiyon, pe ipwai iya kili ndramat mepo mandran imat ara, ipa, <<Noru, kuntali hu pakut mwomwan atam.>> ");
INSERT INTO nss_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hu ndramat hayah para hinuwani nongan para pwahanou hurompwan ara, pe huro lohonge soyon iro ndriyahu, hupa, ");
INSERT INTO nss_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Tehen tapeh ndramat aro iwong tehen tora? Yiy ipwasisiman ana Ngindrai, ndre? Ngindrai hamou opu ara ilahiy para kitali hu pakut mwomwan.>> ");
INSERT INTO nss_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Indrou pwi ko, Yesu ara mwoiwan kinpahasani tesah mepo huro lohonganiy iya ndriyahu, pe ipwai iya kili hu, ipa, <<Paratapeh pe wawu tora lohongani hu melit aro kene ita ndriya wawu? ");
INSERT INTO nss_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sehe nongan, ara waison para kupwai kiya kili ndramat sangin imat? Ara waison para kupa, <Kuntali hu pakut mwomwan tam,> ndre kupa, <Atine, awiri nokum pe arakai>? ");
INSERT INTO nss_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hapeko yo unamiliy para wawu kapahasaniy tehe Noru Ndramat, ara pwoke nopwaran iripo kili yiy iripo kol pwan para kitali hu pakut mwomwan. >> Pwen ipwai iya kili ndramat mandran imat ara, ipa, ");
INSERT INTO nss_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<Yo upwai isa kili wou, atine, awiri nokum, pe ayau aya suwem.>> ");
INSERT INTO nss_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pwen itine, iwiri nokun, pe iyau iya mawen mbulmarahu masih. Pwen hu ndramat masih mwoiwahu ihin, pe huhuri ngala Ngindrai, hupa, <<Yowu ara konoho nime memelit tehen toro pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Porosih aro, Yesu iyau imui iya poholeng para Ndran Makaiye Kaliliy, pe hu ndramat hitun iya husa kili yiy pe iro hinuwani hu. ");
INSERT INTO nss_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pwen iro tokai iya pe inime ndramat hamou ngalan Lepi NdraAlpeyus. Yiy iro mipwan ndrohonoku poya takis, pe Yesu ipwai iya kili yiy, ipa, <<Asa, oho ndruwo.>> Pwen pe Lepi itine pe iho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iyamulan hape, Yesu iro namnam iya suwe Lepi. Pe hu ndramat para poya takis soyon, iyapolo hu ndramat soyon pakut tahu mwomwan, ara huro namnam iyasura Yesu pe ndramiran hu. Hu ndramat soyon tehen ara, ngara hu koho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pwen hu ndramira Parisiy hayah para hinuwani nongan para pwahanou, ara hunimei tehe Yesu iro namnam iyapolo hu ndramat pakut tahu mwomwan, pe hu ndramat para poya takis. Pe hupwai iya kili hu ndramira Yesu, ara hupa, <<Paratesah pe Yesu ita namnam iyasura hu ndramat para poya takis, pe hu ndramat pakut tahu mwomwan?>> ");
INSERT INTO nss_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ihilingi hu, pe ipwai iya kili hu, ipa, <<Hu ndramat mwanyehu hiyan, ara andre hu kanna nime hu ndrokta pwi. Hapeko hu ndramat humwa, kopu andre hu kaya nime ndrokta. Yo kunsa para kuyoh hu ndramat hu mwonen pwi, hapeko usa, ara para kuyoh hu ndramat mepo pakut tahu mwomwan.>> ");
INSERT INTO nss_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nondriya hu lang ara, hu ndramira Yohanes, pe hu ndramira hu Parisiy, ara huyuh anandrinai. Pe hu ndramat hayah husa, pe hupwai iya kili Yesu, hupa, <<Paratapeh hu ndramira Yohanes, pe hu ndramira hu Parisiy, ara hutora yuh anandrinai, hapeko hu ndramiram, ara hu konho yuh anandrinai pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ipwai iya kili hu, ipa, <<Kapa ndramat hamou nakipo kowase yesou, tehen tapeh andre yowen hu kayuh anandrinai ma iro ndron kili hu? Pwi yoh! Yihu kanlahiy para kayuh anandrinai pwi, paratesah, iro ndron kili hu. ");
INSERT INTO nss_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hapeko lang itapo isa andre hu kawiri mbukena kowase yesou, ara kiya mawen kili hu, pe andre kinto kili yowen hu pwi. Pwen kiro mwonen lang ara, andre yowen hu kayuh anandrinai. ");
INSERT INTO nss_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ndramat hamou kinho sorowe koyau hasai howen, pe kirapairaniy kiyasura koyau saken, ara pwi. Kapa tehen tora, koyau hasai howen ara, andre kindrohomwiri koyau saken, pe kiya mwomwan masih. ");
INSERT INTO nss_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pe ndramat hamou kinho songorani wain howen kiya nondriya pwisi wain saken, ara pwi. Kapa tehen tora, pwen wain howen andre mbusi hu pwisi wain saken karahis; pe wain howen kiyapolo pwisi wain saken, ara maluwoh kene andre kaya mwaihei opu. Pwen iya lohongai ara ko, hu ndramat ngara kasongorani wain howen kiya nondriya hu pwisi wain howen opu.>> ");
INSERT INTO nss_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lang Sapat sih, Yesu iyapolo ndramiran hu huro tokai nondriya piyang hambut. Pe ndramiran hu huro rih mbuwa wit tiken. ");
INSERT INTO nss_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pwen pe hu Parisiy husok yiy, hupa toro: <<Akahilingiy! Paratapeh pe yihu tora mbusi tesah mepo nonombun para kambusiy kiho nondriya lang Sapat?>> ");
INSERT INTO nss_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu isomwi hu, ipa, <<Wawu kannime titiye ta Tepit, ndre pwi? Titiye ipa tehe Tepit iyapolo ndramiran hu, ara anandrinahu pwi pe humundrui. ");
INSERT INTO nss_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aro, ara irayah tandrohonga Apiyatar iro ndron tehe pris ihohin ta hu pris masih kene. Pwen Tepit isong iya nondriya yumwa Ngindrai pe iwiri ndrinanohun nonombun. Nongan para pwahanou, ara ipa tehe hu pris opu andre kayan ndrinanohun ara, hapeko Tepit iya pe iya wiri ndrinanohun ara pe iyan pe ihang ndramiran hu i. Wawu nime titiye ara, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pwen ipwai iya kili hu, ipa, <<Lang Sapat, ara irayah para kisopwat hu ndramat; hapeko hu ndramat hu kantayah para kasopwat lang Sapat, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pwen pe Noru Ndramat, ara yiy Yapane lang Sapat.>> ");
INSERT INTO nss_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Porosih aro, Yesu iya nondriya yumwa mbultere tahu Yuta , pe ndramat hamou iro aliy, ara niman hakip imat. ");
INSERT INTO nss_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hu ndramat hayah huro ten sai para hu kaiki Yesu kiya nongan. Pwen pe huro memerani yiy, paratesah, lohongahu hupa ndre kiya pe kirakultuwani nima ndramat ara, kiya hiyan kiho nondriya lang Sapat. ");
INSERT INTO nss_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pwen Yesu ipwai iya kili ndramat ara, ipa, <<Asoro tine mbulmara hu ndramat masih iye.>> ");
INSERT INTO nss_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pwen Yesu isike hu, ipa, <<Tesah ndrokonan ita nongan para pwahanou para Sapat? Kambusi hiyan ndre kambusi mwomwan? Kasopwat ndramat ndre katingundru ndramat kimat?>> Hapeko hu ndramat masih, ara huhun o huyen. ");
INSERT INTO nss_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu maran ihiselep iya kili hu, pe ndrinan ilokuh. Inimei tehe ndriyahu kanpwoke, pwen pe ndriyan irang. Pwen ipwai iya kili ndramat aro, ipa, <<Amwaniyani nimam.>> Pwen ndramat ara, ara imwaniyani niman, pe niman irayah hiyan masih tehe mamu. ");
INSERT INTO nss_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pwen hu Parisiy huya ngawan, pe yihu iyasura hu ndramira King Herot, humburi nongan para katingundru Yesu tapeh. ");
INSERT INTO nss_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pwen Yesu itali kol ara, iyapolo ndramiran hu, pe huyau huya Ndran Makaiye Kaliliy. Pe hu ndramat soyo-soyon iya para kol malkol namandran hape Kaliliy pe Yutiya, ara huho ndruwa Yesu, ");
INSERT INTO nss_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","iyapolo hu ndramat soyon mepo huyau te Yerusalem, Yitumeya, haroh para Ndran Yortan, pe pakeh kili kol malkol Tayar pe Siton, ara husa kili yiy, paratesah, huhulong melit masih Yesu iro mbusiy. ");
INSERT INTO nss_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hu ndramat hurohon huya soyon iya; pwen pe Yesu ipwai iya kili ndramiran hu para hu kamwaniyani ndroi hakou mendreheh kiro mwoimwoi, paratesah, kol ipep pe huro tandrapndrap iya kili yiy, pe matisan hu katinihi yiy. ");
INSERT INTO nss_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Paratesah, Yesu isopwoyani hu ndramat soyon iya, hu kanna hiyan, pwen pe hu ndramat humwa iya mwamwa handra-handra, ara huro rasisinge hu huropo huya para nimahu kahatek katan. ");
INSERT INTO nss_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pe hu ndramat mepo hu payit iro ndritahu, ara hunime Yesu, pe hulah huya pwan huro mbulmaran, pe huwayeh namandran iya, hupa <<Wou ara Noru Ngindrai Kamai.>> ");
INSERT INTO nss_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hapeko Yesu ipwandrandrahani hu payit pe isiyi poho hu para mbuna katiyani yiy. ");
INSERT INTO nss_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ingas iya iro ngondron sih, pe iyoh hu ndramat mepo inamili hu ko, para hu kasa kili yiy. ");
INSERT INTO nss_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pwen Yesu irakinima hu ndramat songui pe lumou para hu koro sura yiy, pe karayah ndramat para kipwandrisa hu para pohoweya nongna Ngindrai. Pwen pe iyoh hu, ara hu aposel. ");
INSERT INTO nss_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pe iyki pwoke nopwaran iya kili hu, para hu karasses hu payit kaya mawen. ");
INSERT INTO nss_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hu ndramat ara, ara ngalahu iye kene: Simon (Yesu ipohowe ngalan handra yi, ara Pita); ");
INSERT INTO nss_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yamis NdraSepetiy iyapolo nalin Yohanes—Yesu, ara iyoh hilu tehe Powanerkes. Ndroiyi lohonga ngala hilu, iya nongna kol tahu, ara ipa <hilu noru palan>— ");
INSERT INTO nss_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Antruw, Pilip, Partolomeu, Mattiu, Tomas, Yamis NdraAlpeyus, Tatteyus, pe Simon yiy hamou ta hu Selot, ");
INSERT INTO nss_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pe Yutas Yiskariyot, mepo iyamulan iratuni Yesu. ");
INSERT INTO nss_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pwen Yesu iyau iya nondriya wum hawum, pe hu ndramat soyon iya, ara husa mbultere hu paiwe. Pwen pe Yesu iyasura ndramiran hu, hu kanlahiy para hu kangoh hape para hu kanamnam, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pwen hu ndraisih imwonen ta Yesu huhulong, pwen pe husa pakasa wiri yiy, paratesah, huro pa, <<Lohongan kinna pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hu ndramat para hinuwani nongan para pwahanou ara hupwen Yerusalem husa pwan, pe hupa, <<Peelsepul ita ndritan. Pwen pe ita rasses hu payit, ara iyau pwoke ta payit mepo yapane hu payit masih.>> ");
INSERT INTO nss_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pwen Yesu iyoh hu husa pakeh kili yiy, pe iwong nongan pwandritiye sahin iya kili hu, ipa, <<Tehen tapeh andre sinai kirasses sinai? ");
INSERT INTO nss_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kapa kolo king mepo ngara kiro mu kiya aliy ara, ara kihingas kiya kili yiy mbukenan, pe kamasilpat kiya malpat, pwen andre hu kinlahiy para kiro tine pwokeyan pwi. ");
INSERT INTO nss_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pe kapa wum hawum kahangas mwalingahu, pe kamasilpat kaya malpat, pwen andre wum, ara kinlahiy kiro tine pwokeyan pwi. ");
INSERT INTO nss_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pe kapa Sinai kipo pahun kiya kili yiy mbukenan, pwen andre yiy kinlahiy kipwokeyani yiy mbukenan pwi. Andre yiy kihipwen masih. ");
INSERT INTO nss_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tehen tora ko, kinlahi ndramat kisong kiya nondriya suwe ndramat hamou pwokeyan, pe kiya po hu meltan, ara pwi. Kapa nakimbusiy tehen tora, ara andre kiwasi tiriyi ndramat pwokeyan ara kimu na. Pwen andre kilahiy para kiya pe kilokihi topwe menmena ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Upwai ndrokonan sa kili wawu toro: Ngindrai ilahiy para kitali hu pakut mwomwan handra-handra masih, pe nongan handra-handra ngara hu ndramat kipwasisiman ana hu ndramat kaliy. ");
INSERT INTO nss_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Hapeko kapa ndramat hamou kipwasisiman ana Mwoiwan Haiyan, ara Ngindrai andre kintali mwomwan ariya pwi. Mwomwan aro, ara andre kinto-kinto. Pakut tan ariya, andre kiro manau ndritan. >> ");
INSERT INTO nss_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ipa toro, paratesah, huro pa, <<Payit iro ndritan.>> ");
INSERT INTO nss_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pwen tina Yesu iyasura nalin hu husarayah husa pe huro tine ngawan, pe hupwandrisa ndramat hamou para kiya pwai kiya kili Yesu para kisa kili hu. ");
INSERT INTO nss_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hu ndramat soyon iya hurompwan pe hurahakowan, pe hupwai iya kili yiy, hupa, <<Tinam pe nalim hu, ara hutora ten wou ngawan.>> ");
INSERT INTO nss_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu isomwi hu pe isike hu, ipa, <<Hiyeh ndrokonan ara tino pe nali hu?>> ");
INSERT INTO nss_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pwen maran ihiselep iya kili hu hiyeh hurompwan pe hurakayani yiy, pe ipa, <<Akanimei, hu iye ara tino pe nali hu. ");
INSERT INTO nss_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kapa sehe ndramat kimbusi namiliwa Ngindrai, yiy ara nali, pisu, pe tino.>> ");
INSERT INTO nss_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pwen Yesu iro hinuwani hu ndramat paiwe, ngilse ndran makaiye. Pe hu ndramat soyo-soyon iya, ara husa rawure hu husa kili yiy. Pwen pe ihis iya nondriya ndroi hakou iho pit, pe impwan aliy. Pe hu ndramat masih, ara huro poholeng pwaki ndran makaiye. ");
INSERT INTO nss_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pe Yesu ihinuwani hu iya nongan pwandritiye soyon. Pwen ipwai iya kili hu iya nondriya nongan para hinonou tan, ipa, ");
INSERT INTO nss_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Wawu kahilingiy! Ndramat hamou para mbulya piyang iya piye peke wit. ");
INSERT INTO nss_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pe iro mwonen iro piye hu peke wit, hu tiken para aliy, ara hulon huro sai, pe hu norukan husa pe huiniy. ");
INSERT INTO nss_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pe hu tiken i hulon huro ndrita pwan sosolou, mepo pwan soyon kinto aliy pwi. Pe indrou pwi ko husahambunet, paratesah, pwan kinna hangoh mbulun pwi. ");
INSERT INTO nss_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hapeko iro mwonen mwandrai ingas, ara ngandraha mwandrai itimwi hu peke wit, ara pe huwayiu, paratesah, ngondrohu kansin kanna pwan pwi, pe humang. ");
INSERT INTO nss_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pe hu peke wit tiken, ara hulon huya mwalinga hu malkei maporon; pe hu malkei maporon, ara huraimwani hu pe hu kanippwai pwi. ");
INSERT INTO nss_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hapeko tiken tahu mepo hulon huro pwan hiyan, ara hulek pe hu mandra pe huppwai. Hu huppwai pe sangihu hurayah tehe mapeke tingui, ndre mapeke anongui, ndre mapeke sangat.>> ");
INSERT INTO nss_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pwen Yesu ipwai iya kili hu, ipa, <<Hiyeh mandraingan, ara kihilingi nongan iye.>> ");
INSERT INTO nss_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iyamulan hape, Yesu opu iro mwoimwoi pe ndramiran hu huya pe hurahakowan, iyapolo hu ndramat hayah i, pe husike yiy iya nongan pwandritiye ara. ");
INSERT INTO nss_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pe ipwai iya kili hu, ipa, <<Lohongai kokohon para kolo King Ngindrai mepo ngara kiro mu kiya aliy ara kinsa kili wawu. Hapeko hu ndramat hutora ngawan, melit masih mepo urupo pwai, ara itapo iya kili hu iya nongan pwandritiye ko. ");
INSERT INTO nss_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Pwen pe, andre hu koro ten, hapeko andre hu kankahiy pwi; pe andre hu koro hilingiy, hapeko andre hu kanpahasaniy pwi. Kapa pwi, matisan hu karapaiwani hu pe Ngindrai kitali mwomwan tahu.>> ");
INSERT INTO nss_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pwen Yesu isike hu, ipa, <<Wawu kanpahasani nongan pwandritiye iye pwi, ndre? Pwen andre wawu kapahasani ndroiyi nongan masih ita nongan pwandritiye tehen tapeh i? ");
INSERT INTO nss_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Akahilingiy; ndramat para piyeya peke wit, ara ihasi nongna Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hu peke wit mepo hulon huro sai, ara tehe ndramat hayah mepo huhulong nongna Ngindrai, pe indrou pwi Sinai isa pe iwiri nongan mepo Ngindrai kiniykiy kinhan iro ndriyahu, iya mawen. ");
INSERT INTO nss_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pe hu peke wit tiken hulon huro ndrita pwan sosolou, ara tehe ndramat hayah mepo huhulong nongan, pe indrou pwi ko huwiriy pe hupwes. ");
INSERT INTO nss_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hapeko ngondrohu, ara kinsin pwi, pwen kinto ndrangan niwen pwi. Pe tunan nongna Ngindrai opu, pwen nopwaran andre kipwalngani hu, pwen pe indrou pwi ko, andre hu kayos. ");
INSERT INTO nss_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pwen hu peke wit tiken hulon huya mwalinga hu malkei maporon, ara tehe hu ndramat hayah huhulong nongna Ngindrai, ");
INSERT INTO nss_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","hapeko hunimanga hu melit handra-handra para kol pwan, pe singayai ipakarawani hu pe lohongahu imeu iya aliy, pe hunamili melit handra-handra. Pwen pe melit masih tehen tora, ara iraimwani nongna Ngindrai pe kinippwai pwi. ");
INSERT INTO nss_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hapeko hu peke wit hulon iya pwan hiyan ara tehe hu ndramat mepo huhilingi nongan pe hupwotisingi nongan ara, pwen huppwai. Hayah, ara huppwai pe sangihu hurayah tehe mapeke tingui, pe hayah hurayah tehe mapeke anongui, pe hayah, ara hurayah tehe mapeke sangat.>> ");
INSERT INTO nss_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pwen Yesu ipwai iya kili hu, ipa, <<Iya hiyan para ndramat hamou kiwiri paisui kisa pe kikulani ngana mwan kiya pahandra pwelekei, ndre kiya pahandra sousou? Ara pwi yoh! Hiyan para kiykiy kiro ndrita kakan. ");
INSERT INTO nss_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Melit masih ita kohon, ara andre kamulan kirayah ngawan, pe melit hundrutuhiy, ara andre kamulan kisa yelan ngawan. ");
INSERT INTO nss_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hiyeh mandraingan, ara kihilingi nongan iye.>> ");
INSERT INTO nss_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pwen pe ipwai iya kili hu paiwe, ipa, <<Mara wawu kiro melit masih wawu topo hilingiy. Sehe ndrohongan mepo wawu nakaikiy kiya kili hamou, ndrohongan tehen tora ko, ara andre kimui kisa kili wawu kihisoule ko yi—pe andre kiho hin hape. ");
INSERT INTO nss_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hiyeh mepo mamenmenan, ara andre Ngindrai kipo sura menmenan. Hapeko yiy mepo menmenan pwi, konan hape sohoyan kimin, ara andre kawiriy topwei kiya mawen kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pwen ipa, <<Kultuwayi kolo king ta Ngindrai mepo ngara kiro mu kiya aliy, ara pwen tehe ndramat hamou ipiye hu peke wit, pe hulon huya ndrita pwan. ");
INSERT INTO nss_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ping iro matin pe lang itine pe ipo mbulyan, hapeko hu peke wit huro lek pe huro mandra, pe ndramat ara, ikowu tehen tapeh irayah. ");
INSERT INTO nss_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pwan mbukenan, ara ihingini hu peke wit pe hulek, pwen iyamulan huppwai. Yowihu husarayah, pe huiki nonowehu, pwen iyamulan huiki sangihu. ");
INSERT INTO nss_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pwen iro mwonen hu sangi wit human, indrou pwi ko, ndramat ara, iwiri semen pe isondritiy, paratesah, lang para rihiyan kinsarayah pwen.>> ");
INSERT INTO nss_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pwen Yesu iwong paiwe, ipa, <<Yorou andre tukapa tesah kiya kultuwayi kolo King Ngindrai mepo ngara kiro mu kiya aliy? Sehe nongan pwandritiye andre tukatiyaniy para kiyinganiy? ");
INSERT INTO nss_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ara tehe peke mbuwa mastet sih. Peke mbuwa mastet ara mendreheh masih iya kili hu peke mbuwakei masih mepo ngara kayuk. ");
INSERT INTO nss_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hapeko kapa tukahas peke mastet, pwen andre kimandra kiya namandran kili hu kei masih para piyang. Ndrandran, ara namandran, pe ilahi hu norukan hu kaya pe kapuli yumwahu koho aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ngara kiwong kiya nongan pwandritiye soyon iya tehen tora ko, mepo ilahi lohongahu. ");
INSERT INTO nss_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nongan masih iro wong iya kili hu, ara iya nongan pwandritiye ko; kinho wong ngawan pwi. Kapa yiy pe ndramiran hu ko hu koro, pwen ngara kitiyani melit masih kileu. ");
INSERT INTO nss_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Piyahon para lang ara, pwen ipwai iya kili ndramiran hu, ipa, <<Tukayau kaya singondriti ndran makaiye pe tukaya haroh.>> ");
INSERT INTO nss_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ndramiran hu huhis huya ndroi mepo Yesu iro aliy, pe hutali hu ndramat soyon huro ndron pe huyau. Pe hu ndroi hayah, ara huya surahu yi. ");
INSERT INTO nss_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pwen nohai namandran ingas pe nowei iro talon iya nondriya ndroi, pe ndroi, ara pakisomun. ");
INSERT INTO nss_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pe Yesu iye kuwi ndroi pe iyki payan iye ndrita wayung pe kinmatin turut. Ndramiran hu huhungini yiy, pe hupa, <<Ndramat Para Hinonou, pakeh worou nakayuh ara; alohongani worou ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pwen itine pe ipomate nohai, pe ipwai iya kili nowei iro talon, ipa, <<Mosun! Awayis!>> Iwong ihipwen pe nohai imaito pe ndras imat. ");
INSERT INTO nss_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pe ipwai iya kili ndramiran hu, ipa, <<Paratapeh pe wawu noh? Wawu kanpwotisingi lohonga wawu pwi, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pwen hunoh mimiri hu, pe hamou iro sok hamou, ipa, <<Aripo sehe ndramat? Nohai pe nowei kene, ara hilu hilingi nongnan i!>> ");
INSERT INTO nss_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pwen Yesu iyapolo ndramiran hu, hutali haroh para Ndran Makaiye Kaliliy, pe huya haroh iyapwen te kol namandran hape ngalan Kerasa. ");
INSERT INTO nss_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Huyarayah o, pe Yesu iropo isa mawen nondriya ndroi, pe ndramat hamou isa mawen hu ngare hu ndramat kanmat. Ndramat ara, ara payit iro ndritan, pe isa pe ipohonani Yesu. ");
INSERT INTO nss_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pe yiy ngara kiro matin nondriya ngat sou ariya, pe kinlahi hamou para kiwasi yiy kiya wasiu ndre malkei handra-handra pwi. Konan kapa hu kawasi yiy kiya malkei hayen ndrahandringon, hapeko malkei masih, ara kinlahiy pwi ko. ");
INSERT INTO nss_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hu kanwasi yiy pwen lang soyon kinna iya wasiu pwokeyan iya. Huwasi niman pe ndrikan iya kondrei hupaltaniy iyau hayen, pe malkei hayen i, hapeko kinlahiy pwi yi. Masih kene ara, ara indrohomwiri hu topwei, pe hamou kinlahiy para kipwahatini yiy pwi masih. ");
INSERT INTO nss_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lang pe ping sih tehe sih ngara kihombui ngarasou sih kiya sih pe ngondron sih kiya sih, pe ngara kilomei pe kisondriti yiy mbukenan kiya pat. ");
INSERT INTO nss_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yiy inime Yesu iho ndron mwanan hape, pe ingap isa kili yiy pe ihikuwani ngundrun iya ngondro ndrika Yesu . ");
INSERT INTO nss_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Pe iwayeh namandran iya, ipa, <<Yesu, Noru Ngindrai Kamai Iyera Paingan Iya, wou nasa sahaye yo? Upwai tisingiy isa kili wou iya ngala Ngindrai, mbuna aiki ngandran sato.>> ");
INSERT INTO nss_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Iwayeh toro, paratesah, Yesu kinpwai kinna kili yiy, ipa, <<Wou payit mwomwan, asa mawen kili ndramat ara.>> ");
INSERT INTO nss_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pwen Yesu isike yiy, ipa, <<Ngalam hiyeh?>> Pe ipwai, ipa, <<Ngolo, ara Hundram, paratesah, yowu soyon iya.>> ");
INSERT INTO nss_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pwen yiy iro rakekeyani Yesu ken iho ken para mbuna kirapiyani yihu payit mwomwan kaya mawen kili kol namandran ariya. ");
INSERT INTO nss_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pwen hu puw hayoi soyon iya, ara huro susuwan iya sese parangondron haroh pakeh kili hu. ");
INSERT INTO nss_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pwen pe hu payit hurakekeyani Yesu, hupa, <<Apa hiyan kisata yowu para yowu kaya ndrita hu puw.>> ");
INSERT INTO nss_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pwen Yesu ipa hiyan para hu kaya. Pwen hu payit hutali ndramat ara, pe huya nondriya hu puw. Ndromwoya hu puw ara iho pakeh malpou (2,000). Pe hu puw, ara huwop turut, pe hurapak mbusupahayi huya pwan, pe huya yos huya ndran makaiye. Pwen pe huya mut topwei. ");
INSERT INTO nss_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hu ndramat para hangna puw hunimei pe huwop, pe huya tiyaniy iya kol ngawan pe hu kol mendreheh pakeh kili hu. Pwen pe hu ndramat para hu kol ara, ara husa nime sehe melit irayah. ");
INSERT INTO nss_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pwen husarayah husa kili Yesu, pe hunime ndramat mepo mamu hu payit soyon iya iro ndritan, ara kinsuluyani yiy kinna koyau, pe lohongan kinileu pe irompwan. Pwen hunime ndramat ara pe hunoh. ");
INSERT INTO nss_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hu ndramat mepo hunime melit masih kintayah, ara hutiyani melit masih kene irayah iro kili ndramat mepo payit iro ndritan; pe hutiyani titiye tahu puw i. ");
INSERT INTO nss_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pwen pe hurakekeyani Yesu para kitali kolohu pe kiyau kiya mawen. ");
INSERT INTO nss_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pwen Yesu iro his nakiya nondriya ndroi, pe ndramat mepo mamu payit iro ndritan, ara irakekeyani Yesu para kihis kiyasura yiy. ");
INSERT INTO nss_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hapeko Yesu ara kinsomwi yiy pwi, pe ipwai iya kili yiy, ipa, <<Amui aya kili ndramiram hu, pe apwai kiya kili hu kiya melit masih Yapan kinmbusiy pwen kinsa kili wou, pe atiyani koisirai tan mepo kinsopwat wou kinna aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pwen ndramat ara, ara iyau iya hu kol namandran Tekapolis pe iro tiyani melit masih Yesu kinmbusiy kinna kili yiy. Pe hu ndramat, ara huhilingiy pe huro lohonge ndrit. ");
INSERT INTO nss_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pwen Yesu imui iya ndran makaiye haroh, pe hu ndramat soyon iya huya rawure hu huro sura yiy. Pe huro pakeh pwaki ndran makaiye, ");
INSERT INTO nss_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","pe ndramat mepo pohon hamou para yumwa mbultere tahu Yuta tahu Yuta isa kili yiy; yiy ara ngalan Yairus. Tandrohonga inime Yesu, ilah iya pwan ngondrokan. ");
INSERT INTO nss_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pe irakekeyani yiy, ipa, <<Noru pihindrahin, ara imwa kinna mwomwan masih, pe pakeh nakimat. Asa pe aiki nimam kiya kili yiy pe asopwoyani yiy pe andre kingoh pe kiro mwalen.>> ");
INSERT INTO nss_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pwen Yesu irikai iyapolo yiy. Pe hu ndramat soyon iya huho ndruwan, pe hurakayani yiy pe huro tandrapndrap. ");
INSERT INTO nss_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pe pihin hamou iro mwalingahu, ara mwamwa ndrai iro kili yiy iho nondriya hayou songui pe luwoh. ");
INSERT INTO nss_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iropo iya nime hu ndrokta soyon, hapeko huroiki ngandran namandran iya imui iya kili yiy. Pe singayai tan masih iro kili yiy, ara iro piye topwei o mwaihei iya kili hu. Hapeko mwamwa tan, ara kinhipwen pwi yoh; iro wiri yiy iya mwomwan masih. ");
INSERT INTO nss_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pihin ara, ara ihilong titiye ta Yesu, pwen pe isa iho yau mwalinga hu ndramat soyon iya ara. Yiy isa pakeh ndruwa Yesu pe niman iyahatek iya payango koiwen. ");
INSERT INTO nss_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yiy mbukenan, ipa, <<Kapa kuiki nimo ko kiyahatek kiya payango koiwen, pwen andre kurayah hiyan.>> ");
INSERT INTO nss_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pwen iro mwonen niman iyahatek iya koiwe Yesu, indrou pwi ko, mwamwa tan ihipwen; pe ihingorowei tehe mwamwa ndrai iro mandran, pe iro nondriya ngandran, ara kiningoh. ");
INSERT INTO nss_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Indrou pwi ko, Yesu ihingorowei tehe pwoke kintali yiy kinna mawen, pe ipaiwani yiy iho mwalinga hu ndramat, pe isok hu, ipa, <<Hiyeh ndrokonan niman kinsahatek kinsa koiwe?>> ");
INSERT INTO nss_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pwen ndramiran hu husike yiy, hupa, <<Paratapeh asok tora? Animei, hutopo tandrapndrap sura wou.>> ");
INSERT INTO nss_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hapeko Yesu maran iro hiselep pe iro ten hiyeh ndrokonan imbusiy. ");
INSERT INTO nss_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pwen pihin ara, ara ipahasani sehe melit kintayah kili yiy, pe inoh turuweyiy. Pwen ilah iya pwan mbulmara Yesu, pe itiyani melit masih ndrokonan kintayah kili yiy iya ngawan kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pe Yesu ipwai iya kili yiy, ipa, <<Noru, lohongam ndrisiyon, ara imbusi wou antayah hiyan. Ayau ayapolo ndriya wayis. Pe ngandran aro nondriyan ara kintali wou.>> ");
INSERT INTO nss_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu iro wong manau, pe hu ndramat hayah husarayah. Hu ndramat ara, huyau seu kili Yairus, yiy pohon para yumwa mbultere tahu Yuta. Husa pe hupwai iya kili yiy, hupa, <<Norum pihin kinmat pwen. Konan. Paratapeh pe atarakekeyani ndramat para hinonou ara para kisa manau.>> ");
INSERT INTO nss_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu iro hilingi hu, hapeko kiniyki ndraingan kinna nongnahu pwi. Pe ipwai iya kili Yairus, ipa, <<Mbuna anoh; apwotisingi lohongam opu.>> ");
INSERT INTO nss_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pe ipa mbuna hu ndramat masih kene hu koho ndruwan. Hu ndramiran matimou opu—Pita, Yamis, pe iyasura nalin Yohanes—hu ara ko, ipa hiyan para hu kaya sura yiy. ");
INSERT INTO nss_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Huyarayah huya seu ta Yairus, pe Yesu inimei tehe hu kanpiye hu kanna ndriyang; pe huro rang turut pe ngaliya hu iropo iya namandran iya. ");
INSERT INTO nss_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pwen Yesu iya nondriya seu pe ipwai iya kili hu, ipa, <<Paratesah wawu rang, pe ngaliya wawu, ara iya namandran iya? Mbunah ara, ara kinimat pwi; yiy ara ita matin opu.>> ");
INSERT INTO nss_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pe huhaisani yiy. Pwen irasses hu masih huya ngawan, pe iwiri tama mbunah pe tinan, iyapolo ndramiran hu matimou, huya nondriyan hapeleheh mepo mbunah iyen aliy ara. ");
INSERT INTO nss_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pwen imbultuwe nima mbunah ara pe ipwai iya kili yiy, ipa, <<Talita, koum.>> Iya nongna kol tahu, ara ipa toro: <<Pihindrahin, upwai isa kili wou, atine.>> ");
INSERT INTO nss_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pwen indrou pwi ko, pihindrahin, ara itine pe irikai. Pihindrahin aro, ara hayou tan songui pe luwoh. Pe hunimei, mwoiwahu ihin, pe hunun. ");
INSERT INTO nss_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pwen Yesu ipwatisingi nongnan iya kili hu para hu mbuna karanenese sehe melit irayah. Pe ipwai iya kili hu para hu kahang pihindrahin ara hape anandrinai. ");
INSERT INTO nss_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu itali kol ara, pe imui iya kolon, pe ndramiran hu huho ndruwan huyapolo yiy pe huya. ");
INSERT INTO nss_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lang Sapat isarayah, pe Yesu iro hinuwani nongan iya nondriya yumwa mbultere tahu Yuta. Hu ndramat soyon iya huhilingi yiy pe huro lohonge ndrit, pe hupa, <<Ndramat ara, iwiri hu nongan ara, ipwen aleheh? Lohongai waison hira kili yiy ara sehe lohongai? Pe ita pwaingani hu ndraikiya pwoke iyau niman, ara tehen tapeh? ");
INSERT INTO nss_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yiy ara ndramat para puliya seu, ndre? Pe yiy ara noru Mariya, pe nalin hu, ara Yamis, Yosep, Yutas, pe Simon, ndre? Pe pisun hu, hutopo sura tou iye yi, ndre?>> Pwen welehu imai tan. ");
INSERT INTO nss_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ipwai iya kili hu, ipa, <<Poropet hamou, kapa kiro kol mawen, ara andre hu karanuhuyani yiy. Hapeko kapa kiro ndrohokolon imwonen, pe nondriya ndrayen hu pe yowen hu, ara andre hu kantanuhuyani yiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pwen pe kinlahiy para kimbusi hu ndraikiya pwoke namandran kiro ariya pwi; hapeko iyki niman iya ndrita hu ndramat hayah humwa, pe isopwoyani hu hungoh. ");
INSERT INTO nss_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pe ilohonge soyon tehe hu ndramat kanpwotisingi lohongahu pwi. Pwen Yesu irakayani hu kol mendreheh hakol iya hakol pe iro hinuwani nongan. ");
INSERT INTO nss_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pwen iyoh hu Songui pe Lumou husa kili yiy, para kipwandrisa hu malmou-malmou. Pe iyki pwoke nopwaran iya kili hu, para hu payit mwomwan hu kahilingi nongnahu. ");
INSERT INTO nss_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pe ipwatisingiy iya kili hu para hu kasap nes opu, hapeko hu mbuna kasap hu melit handra-handra yi—tehe ndrinanohun, ndrop, singayai kiro ndropwa sombule pat—melit masih tehen ara, ara konan. ");
INSERT INTO nss_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ipa hiyan para hu kaiki hatna pwelekahu, hapeko ipwai para hu mbuna kapo susura suluyahu. ");
INSERT INTO nss_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pe ipwai iya kili hu, ipa, <<Kapa wawu kayarayah kaya kol hakol ara, pe akasong kaya nondriya seu hawum, pwen akoro seu ara ko, kipoo akatali kol ara. ");
INSERT INTO nss_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hapeko kapa akaya kol hakol pe yihu kantawulohani wawu pwi, pe hu kanhilingi nongna wawu pwi, pwen akatali kol ara; pe kiro mwonen wawu pakataliy, akaratolohani pweleka wawu. Pwen andre kipwainganiy tehe andre hu kawiri koran.>> ");
INSERT INTO nss_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pwen ndramiran hu, ara huya pe hutiyani nongan iya kili hu ndramat, hupa, <<Wawu karapaiwani ndriya wawu.>> ");
INSERT INTO nss_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pe hurasses hu payit soyon huya mawen ndrita hu ndramat, pe hutumwi ndraikei iya kili hu ndramat soyon mepo humwa, pe husopwoyani hu hungoh. ");
INSERT INTO nss_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pwen king Herot ihilong, paratesah ngala Yesu kiningau marakol. Ndramat hayah, hupa, <<Yohanes Ndramat para Paptais, ara kintine! Pwen ndroiyin ara ko, hu ndraikiya pwoke, ara hutora tayah kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pe hu hayah hupwai, hupa, <<Yiy ara Eliyah, ndre?>> Pe hu hayah i, ara hupwai, hupa, <<Yiy, ara poropet hamou, tehe yihu poropet para koluw kinna.>> ");
INSERT INTO nss_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hapeko Herot ihilong, pe ipwai, ipa, <<Yohanes, ndramat mepo kunsondriti koyun, ara mahapo kinsa tine yi!>> ");
INSERT INTO nss_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Titiye ta Herot isondriti koyu Yohanes, ara ipa toro: Koluw Herot mbukenan kinpwatisingiy, pe humbultuwe tahatini Yohanes, pe huwasi yiy pe huiki yiy iya nondriya kou. Imbusiy tora, paratesah, Herot ara kinwiri nambuyu nalin Pilip, ngalan Herotiyas, iya nambuyun. ");
INSERT INTO nss_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pe Yohanes ngara kipwayi Herot, kipa, <<Nongan para pwahanou ipa, ara nonombun para awiri nambuyu nalim.>> ");
INSERT INTO nss_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pwen Herotiyas lohongan imwa ta Yohanes pe pakitingundrun, hapeko kinlahiy pwi, ");
INSERT INTO nss_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","paratesah, Herot ara inoh ta Yohanes. Herot ipahasaniy tehe Yohanes, ara ndramat imwonen pe haiyan, pe ngara kipenani Herotiyas para mbuna kimbusi hapesah kiya tan. Pe imwonen Herot ngara kihilingi nongna Yohanes, yiy ngara kilohonge soyon pe ndriyan, ara iporu; hapeko yiy ara ngara kinamiliy para kihilingi nongnan i. ");
INSERT INTO nss_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pwen napwai, iyamulan hape, lang para Herotiyas nakimbusi lohongan, ara isarayah. Pe irahihini lang namandran sih mepo hu nakapwesani lang para hu kalohongani lang mepo tina Herot imwalahiy tan. Pwen Herot ipo yon sih iya tahu namandran tan para mbulen, iyapolo hu ndramat huho hin tahu ndram para pahun, pe iyasura hu yapane kol Kaliliy. ");
INSERT INTO nss_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pwen huro namnam pe noru Herotiyas pihin isa nondriyan, pe iho ndran iya mbulmara Herot pe yowen hu, pe iluwi lohongahu. Pwen King ipwai iya ta pihindrahin, ara ipa, <<Kapa asike yo kiya sehe melit anamiliy, ara andre kuikiy.>> ");
INSERT INTO nss_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pe irandrangan iya kili yiy, ipa, <<Upwai ndrokonan isa kili wou, kapa asike yo kiya hapesah andre kuikiy kisatam; pe kapa asike yo para kuiki kolo king to mepo ngara kuro mu kiya aliy, pe haroh mwanye para aliy, ara andre kuikiy kisatam.>> ");
INSERT INTO nss_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pwen noru Herotiyas, ara iya ngawan kili tinan pe isike yiy, ipa, <<Sehe melit ndrokonan andre kusoyingiy?>> Pwen tinan isomwiy, ipa, <<Asoyingi paya Yohanes Ndramat para Paptais.>> ");
INSERT INTO nss_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Indrou pwi ko, pihindrahin aro ihimbuh iya nondriyan kili King, pe ipa, <<Yo unamili paya Yohanes Ndramat para Paptais. Aikiy kiya pwelekei sih, pe kisa kili yo mahapo ko.>> ");
INSERT INTO nss_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pihindrahin ipa toro, pwen pe King, ara ndriyan iporu namandran iya. Hapeko ilohongani nongnan mamu kintandrangan kinna mbulmara yowen hu mepo huro namnam sura yiy, pe mbuwalin para kipa pwi kiya soksok ta pihindrahin ara. ");
INSERT INTO nss_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Indrou pwi ko, King ipwandrisa makundrayin hamou mepo ngara kitingundru hu ndramat, pe ipwatisingiy para kiya pe kiwiri paya Yohanes kisa. Pe makundrayin, ara iya pe isondriti koyu Yohanes iro nondriya kou. ");
INSERT INTO nss_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pwen iyki payan iro ndrita pwelekei sih, pe ihiriy iya kili pihindrahin ara. Pwen pihindrahin ara, isap iya kili tinan. ");
INSERT INTO nss_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pe hu ndramira Yohanes huhulong, pwen huhuri nombuwen pe huya roniy iya ngat sou. ");
INSERT INTO nss_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pwen iyamulan hu aposel humui husa mbultere hu yasura Yesu. Pe hutiyani hu mbulen humbusiy, pe hu melit masih huhinuwani hu ndramat iya aliy. ");
INSERT INTO nss_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pe Yesu iyasura ndramiran hu, hu pakaya namnam, hapeko hu ndramat soyon iya huropo huya husa, pwen pe hu kanlahiy para kanamnam pwi. Pwen ipa, <<Worou opu tukayau kaya hape lohowayin, pe tukaya ngoh hape.>> ");
INSERT INTO nss_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pwen huya his ndroi hakou pe yihu ko huya kol hape lohowayin. ");
INSERT INTO nss_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hapeko hu ndramat soyon iya hunime hu huyau pe huyirowe hu. Pwen hu ndramat, ara huyau kol namandran masih pe hungap pe huya rayah imu iya hapeleheh mepo Yesu pe ndramiran hu nakasa aliy. ");
INSERT INTO nss_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pwen Yesu ituh ndroi iya pwan, pe inime hu ndramat soyon iya hu kansa mbultere hu huro. Pe koyun ara isikirani hu, paratesah, yihu ara tehe hu sipsip mepo ndramat para pwokereyahu pwi. Pwen Yesu ihinuwani hu iya nongan soyon iya. ");
INSERT INTO nss_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pwen kol iro piyah masih, pe ndramira Yesu hu husa kili yiy pe hupwai iya kili yiy, hupa, <<Kinpiyah pwen ara, pe worou turopo kol mepo ndramat aliy pwi. ");
INSERT INTO nss_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kiya, hiyan para apwai kiya kili hu ndramat para hu kaya hu kol mendreheh pe hu kalsiu hopo pakeh, pe kaya sou anandrinahu.>> ");
INSERT INTO nss_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pe Yesu ipa, <<Wawu kahang hu hapesah para hu kayan.>> Pwen husok yiy, hupa, <<Wou apa ndre hiyan para yowu kaya sowani ndrinanohun, pe yowu kayaikiy kiya anahu pe hu kainiy, ndre? Anandrinai ara, andre kennen kirayah tehe kenne ndramat hamou ngara kiwiriy nondriya walah mandrolwoh!>> ");
INSERT INTO nss_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hapeko Yesu isike hu, ipa, <<Ndrinanohun, ara masahayeh ita? Wawu kaya nimei.>> Pwen huya nimei ihipwen, pe husa pwai iya kili yiy, hupa, <<Ndrinanohun mayimah, pe ni malmou.>> ");
INSERT INTO nss_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pwen Yesu ipwai iya kili ndramiran hu para hu karawurani hu ndramat koro ndrokoyirayi sih-sih, pe hu kampwan ndrita ndromwindriu salau. ");
INSERT INTO nss_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pwen humpwan tasangat-tasangat pe yimingui-yimingui iro ndrokoyirayi sih-sih. ");
INSERT INTO nss_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pwen Yesu iwiri ndrinanohun mayimah pe ni malmou ara, pe maran iya paingan pe itoholiy. Pwen iramburingi ndrinanohun, pe iykiy iya kili ndramiran hu para hu katainganiy kata hu ndramat masih. Pwen iramburingi ni malmou pe itainganiy iya tahu masih kene yi. ");
INSERT INTO nss_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hu ndramat masih hunamnam pe isihi hu. ");
INSERT INTO nss_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pwen ndramira Yesu hu huwiri ndrop mandropwa songui pe luhat, pe hunihi ndritike ndrinanohun pe ni iya aliy. ");
INSERT INTO nss_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hu ndramat kamai mepo huiniy, ndromwoyahu, ara iho tehe mayipou (5,000). ");
INSERT INTO nss_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Indrou pwi ko, Yesu ipwai iya kili ndramiran hu, para hu kahis kaya nondriya ndroi, pe hu koro mu kili yiy kaya kol Petsaita, ita haroh para ndran makaiye. Pe yiy opu iro ndron para kipwandrisa hu ndramat para hukalon. ");
INSERT INTO nss_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iyamulan para hu kannau topwei, yiy iyau iya ngondron sih pe iya tohun. ");
INSERT INTO nss_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pe Yesu hamou o, ara iro ndron pwan, pwen iro mwonen nakilokuh pe ndroi iya iho ndrokolo ndran makaiye. ");
INSERT INTO nss_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pe Yesu inime ndramiran hu huro lowayani hu iya pahau pwokeyan, paratesah, nohai imum te ngondroi isa, pe ndramiran hu, ara huro lowayani hu iya pahau pwokeyan iya. Lang iro mbungahiy, pe Yesu, ara iya pe ihorokai ndran makaiye iropo iya kili hu. Iro tokai isa, pe pakiramwaitini hu. ");
INSERT INTO nss_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Hapeko ndramiran hu hunime yiy iro tokai ndrita ndran makaiye, pe hupa ndre yiy ara mwomwoyou hamou. Pwen huwayeh, Ndramiran hu hunime yiy iro tokai ndrita ndran makaiye, pe hupa ndre yiy ara mwomwoyou hamou ... ");
INSERT INTO nss_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","paratesah, yihu masih hunime yiy pe hunoh mimiri hu. Indrou pwi ko, iwong iya kili hu, ipa, <<Wawu mbuna akanoh! Aripo yo kopu; ndriya wawu kipwoke.>> ");
INSERT INTO nss_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pwen Yesu ihis iya nondriya ndroi kili hu pe nohai imaito. Ndramiran hu ara huro lohonge ndrit masih, ");
INSERT INTO nss_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","paratesah, hu kannime sehe melit imbusiy iya ndrinanohun, hapeko lohongahu ara kinileu pwi. Ndriyahu iro pwoke manau. ");
INSERT INTO nss_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pwen yihu singondriti ndran makaiye huya haroh, pe husarayah husa kol hakol mendreheh ngalan Kennesaret, pe huwasi ndroi iro aliy. ");
INSERT INTO nss_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pwen iro mwonen huro ndroi husa pwan, ara hu ndramat huyirowe Yesu. ");
INSERT INTO nss_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pwen hungap huya nondriya hu kol ara kene, pe huya wiri hu ndramat humwa, pe husap hu iya hu pasup, pe husa hapeleheh mepo huhilingiy tehe Yesu iro aliy. ");
INSERT INTO nss_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pe hu kol namandran, hu kol mendreheh, pe hu kol masih mepo Yesu irikai aliy topwei, ara huwiri hu ndramat masih humwa huya ndroho pehei. Pe hurakamam iya kili yiy, para kipa hiyan para hu ndramat humwa nima hu ko kiyahatek kiya payango koiwen. Pwen hu masih mepo nima hu iyahatek iya kili yiy, ara hurayah hiyan. ");
INSERT INTO nss_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hu Parisiy hayah iyapolo hu ndramat hayah para hinuwani nongan para pwahanou, ara hupwen te Yerusalem husa rawurehu pe hurahakowa Yesu. ");
INSERT INTO nss_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pe hunimei tehe hu ndramira Yesu hayah, ara huro namnam, hapeko hu kansungani nimahu pwi, tehe nongan para pwahanou kinpwai. ");
INSERT INTO nss_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hu Parisiy pe hu Yutah masih, ara ngara hu karanuhuyani kowase tumbuhu, para sungeya nimahu, tehe kapa hu kansungani nimahu pwi, pwen andre hu kanlahiy para kanamnam pwi. ");
INSERT INTO nss_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pe kapa hu koro pehei pe hu kamui kasa, pe hu kansombungi hu pwi, ara andre hu kannamnam pwi. Pe ngara hu koro ndruwa kultuwayi tumbuhu hayah, para koluw kinna yi, tehe ngara hu kasungani pweniu, kohoi, pe pwelekei. ");
INSERT INTO nss_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pwen pe hu Parisiy pe hu ndramat para hinuwani nongan para pwahanou, ara husok Yesu, hupa, <<Paratapeh, pe ndramiram hu ara hu konoho ndruwa kultuwayi tumburou hu pwi, pe nimahu kas o pe hunamnam?>> ");
INSERT INTO nss_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pwen Yesu isomwi hu, ipa, <<Poropet Yisayah ipwai imwonen pe kinpwaingani kultuwayi wawu pwen, tehe wawu, ara ndramat para pwandrandraman. Pwayan kinpwai, kinpa toro: <Yihu ndramat aro, ara hu haiyani yo iyau poho hu ko, hapeko ndriyahu, ara ita mawen kili yo. ");
INSERT INTO nss_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yihu tora hari ngolo, hapeko ara mwaihei opu; paratesah, hu hinonou tahu pe pwahanou tahu, ara iyau lohonga ndramat opu.> ");
INSERT INTO nss_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Akanimei, wawu ara kantali topwe nongan para pwandrendrehe ta Ngindrai, pe wawu tora mbultuwe tisingi kultuwayi hu ndramat para kol pwan opu.>> ");
INSERT INTO nss_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu ipwai iya kili hu, ipa, <<Wawu pahasani pohosai hiyan para kahandrisani nongan para pwahanou ata Ngindrai kiya mawen, pe ngara wawu koho ndruwa kultuwayi wawu mbukena wawu. ");
INSERT INTO nss_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tehe Mose kinpwai, kinpa, <Wou ahaiyani tamam hilu tinam> pe <kapa hiyeh kiten ana taman ndre tinan, ara andre katingundrun kimat.> ");
INSERT INTO nss_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Hapeko wawu, ngara wawu kapwai, kapa, <Kapa ndramat hamou masombule pat ndre melit para pakisopwat taman pe tinan kiya aliy, hapeko kipwai kiya kili hilu, kipa, <<Yukyuk iye, ara kunhaiyaniy para kiya ta Ngindrai,>> > ");
INSERT INTO nss_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","pwen wawu kanpa hiyan para kipwokarani taman ndre tinan pwi. ");
INSERT INTO nss_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tehen tora ko pe wawu pwalngani nongna Ngindrai, pe wawu tora tokuyani kultuwayi tumbu wawu hu ko, mepo hutaliy isa kili wawu. Pe ngara wawu kambusi hu kultuw soyon iya tehen tora ko.>> ");
INSERT INTO nss_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pwen Yesu iyoh iya kili hu ndramat soyon iya mepo huro ariya, ipa, <<Wawu masih kene, kahilingi nongno pe lohonga wawu kileu. ");
INSERT INTO nss_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Melit iro ngawan pe iya nondriya ndramat, ara kinlahiy para kimbusi yiy kirayah pwalan kiya mbulmara Ngindrai pwi. Hapeko sehe melit mepo iyau pohon isa ngawan, ara andre kimbusi yiy kirayah pwalan kiya mbulmara Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wawu hiyeh mandrainga wawu, akahilingi nongan iye.>> ");
INSERT INTO nss_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pwen Yesu itali hu ndramat soyon ariya, pe iya nondriya seu. Pe ndramiran hu huya sike yiy iya ndroiyi lohongai para nongan pwandritiye ara. ");
INSERT INTO nss_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pe Yesu isomwi hu, ipa, <<Lohonga wawu ita nun, ndre? Wawu tana wawu pwi tehe hu memelit iro ngawan pe iya nondriya ndramat, ara kinlahiy para kimbusi ndramat kirayah pwalan kiya mbulmara Ngindrai pwi, ndre? ");
INSERT INTO nss_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Paratesah, melit iro ngawan pe iya nondriya ndramat, ara kinhopo kinna neren pwi; hapeko iya iro puran opu, pe isa mawen nombuwen.>> (Tehen tora ko, ara Yesu iyinganiy tehe anandrinai masih, ara hiyan opu para kaniyai.) ");
INSERT INTO nss_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pwen Yesu iro wong manau, ipa, <<Melit mepo iro nondriya ndramat isa ngawan, ara ngara kimbusi ndramat kiya pwalan kiya mbulmara Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yo upa, melit handra-handra iro lohonga ndramat pe isa ngawan, ara hu melit tehe toro kene: hu lohonge mwomwan, tandroindroi, pahana, taya ndramat imat, ");
INSERT INTO nss_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kultuw para pilah, pe kultuw para kalimiriy, pe hu kultuw mwomwan handra-handra, pe pwasoyou, mbusihisih, ndrangsai, pwaturut, sikiye, pe ngou. ");
INSERT INTO nss_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hu kultuw mwomwan masih kene tora, ara iro nondriya ndramat pe isa ngawan, pe ngara kimbusi ndramat kirayah pwalan kiya mbulmara Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pwen Yesu itine pe itali kol ara, pe iya pakeh kol hakol ngawan ngalan Tayar. Yiy iya pe isong iya nondriya seu hawum, pe yiy mbuwalin para ndramat hamou kipahasaniy tehe yiy iya iro aliy; hapeko yiy, ara kinlahiy para kikohon kili hu pwi yoh. ");
INSERT INTO nss_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Indrou pwi ko, pihin hamou ihilingi nongan tehe Yesu iro aliy. Pihin ara, ma norun hamou pihin mepo payit iro ndritan, pwen pe iro mwonen ihilingiy, ihileh isa, pe itukuruhu iya ngondro ndrika Yesu. ");
INSERT INTO nss_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pihin iye, ara hamou pihi Krik, pe tinan imwalahiy tan iro kol namandran hape Ponisiya, ita nondriya kol namandran iya Siriya. Pe yiy irakekeyani Yesu para kirasses payit kiya mawen ndrita norun pihin. ");
INSERT INTO nss_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hapeko Yesu ipwai iya kili yiy, ipa, <<Hu mbunah kanamnam kimu na; kinna hiyan para kawiri anandrinahu mbunah pe kapiyaniy kiya anahu mwiy, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pwen pihin ara isomwi yiy, ipa, <<Yapan, Ndrokonan; hapeko hu mwiy mepo ngara hu koro pahandra keyau, ara ngara hu kaini konkonu hu mbunah i.>> ");
INSERT INTO nss_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pwen Yesu ipwai iya kili yiy, ipa, <<Wou ansomwiy hiyan; pwen pe amui ayau. Payit, ara kintali norum.>> ");
INSERT INTO nss_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pwen imui iya wum, pe inime norun iye matin nokun, pe payit, ara kintali yiy kinnau. ");
INSERT INTO nss_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pwen Yesu itali kol mepo pakeh kol ngawan Tayar ara, pe iyapwen te kol namandran Siton pe ilai iya Ndran Makaiye Kaliliy. Pwen irikai iya nondriya kol namandran hape mepo hupohowei Tekapolis. ");
INSERT INTO nss_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pwen hu ndramat hayah huwiri ndramat hamou isa kili Yesu; ndramat ara, ndraingan iyui pe kinlahiy para kinwong pwi. Pe hurakekeyani Yesu para kiyki niman kiya ndritan. ");
INSERT INTO nss_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pwen Yesu iwiri ndramat ara iya mawen kili hu ndramat soyon, pe iyki ndrakopweniman iya ndrainga ndramat ara. Pwen isokombunuh iya nimam i, pe iyki niman iyahatek iya kalame ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pwen pe mara Yesu itandras iya kol paingan yang, pe ihiri ngohan tehe pakirang. Pwen ipwai iya kili ndramat ara, ipa, <<Eppata!>> Nongan aro iya nongna kol tahu, ara ipa, <<Kite!>> ");
INSERT INTO nss_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Indrou pwi ko, pe ndrainga ndramat ara ite, pe melit mepo irandrikipiri kalamen, ara itan, pe iwong ileu. ");
INSERT INTO nss_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pwen Yesu ipwandrandrahani hu para hu mbuna katiyaniy kiya ta hamou. Yesu iro pa toro, hapeko huro pwoke para hu kaya pe kapwaharai manau. ");
INSERT INTO nss_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pwen hu ndramat masih huhilingi nongan ara, pe mwoiwahu ihin turuwehu. Pe hupa, <<Hu melit masih kinmbusiy ara hiyan o. Hu ndramat ndraingahu iyui, ara hurahihilong. Pe hu ndramat pohohu pwi, ara hu kanwong topwei yi.>> ");
INSERT INTO nss_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pwen iho nondriya hu lang ara, hu ndramat soyon iya yi, husa rawure hu paiwe, pe anandrinahu pwi. Pe Yesu iyoh ndramiran hu husa, pe ipwai iya kili hu, ipa, ");
INSERT INTO nss_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Koyu isikirani hu ndramat aripo. Hu topo sura yo lang maroyoh pwen, pe hapesah para hu kayan, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pe kapa kupwandrisa hu kamui kaya wum mamundruwahu, pwen andre marahu kawuh pe andre hu kaya yos kaya sai, paratesah, hayah tahu, ara hupwen mwanan husa.>> ");
INSERT INTO nss_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pwen ndramiran hu husomwi yiy, pe hupa, <<Worou turopo kol mwanan, pe andre tukawiri ndrinanohun kiyau aleheh kisa, para kaikiy kiya ana hu ndramat masih kene tora kaliy?>> ");
INSERT INTO nss_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pe Yesu isok hu, ipa, <<Ndrinanohun ita kili wawu, ara masahayeh?>> Pe husomwi yiy, hupa, <<Ndrinanohun manandrtoyoh iripo.>> ");
INSERT INTO nss_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pwen Yesu ipwai iya kili hu ndramat masih para hu kampwan ndrita pwan. Pwen iwiri ndrinanohun manandrtoyoh ara, pe irawuloh; pwen iramburingiy, pe iykiy iya kili ndramiran hu para hu katainganiy kiya kili hu ndramat masih. Pwen hutainganiy. ");
INSERT INTO nss_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pe anahu ni hayah mendreheh iro sura hu yi. Pwen Yesu iwiri hu pe irawuloh, pe ipwai iya ta ndramiran hu para hu kaya tainganiy. ");
INSERT INTO nss_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pe yihu masih, ara hunamnam pe isihi hu. Iyamulan ndramiran hu hurawurani ndritike anandrinai tahu iyawule, pe hunihiy iya ndrop manandrtihat. ");
INSERT INTO nss_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pwen ndromwoya hu ndramat masih kene huro ara, ara iho pakeh tehe mahaapou (4,000). Pwen ipwandrisa hu huyau, ");
INSERT INTO nss_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","pe indrou pwi ko, Yesu ihis iya nondriya ndroi iyasura ndramiran hu, pe huyau huya pwen te kol namandran hape Talmanuta. ");
INSERT INTO nss_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hu Parisiy husa pe humu iya ndroiyi takokowai iyapolo Yesu. Hu pakanohonou yiy, pwen pe husike yiy para kipwaingani kaipisa pwoke handra kiyau kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu ihiri kunuwen pwokeyan iya, pe ipa, <<Tehen tapeh pe hu ndramat hasap para mahapo husok para hu pakanime kaipisa pwoke? Upwai ndrokonan isa kili wawu, andre yihu kannime kaipisa hapesah pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pwen Yesu itali hu pe ihis iya nondriya ndroi paiwe, pe humui huya haroh para ndran makaiye. ");
INSERT INTO nss_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pwen ndramiran hu koyuhu imayit para kapo ndrinanohun. Ndrinanohun hapus opu iro nondriya ndroi surahu. ");
INSERT INTO nss_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pe Yesu ipa nongan pwandrendrehe, ipa, <<Akoro rapapahan kiya yis tahu Parisiy pe yis ta Herot i.>> ");
INSERT INTO nss_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pwen pe huro panguluwaniy mwalinga hu hamou-hamou, huro pa, <<Matisan ndrinanohun pwi pe ita wong tora.>> ");
INSERT INTO nss_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hapeko Yesu kinpahasaniy pwen sehe nongan huro wong yaliy. Pwen ipwai iya kili hu, ipa, <<Paratesah wawu tora panguluwaniy tehe ndrinanohun pwi? Wawu kannimei mapu pe lohonga wawu kinileu mapu, ndre? Pe ndriya wawu pwokeyan iya, ndre? ");
INSERT INTO nss_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mamara wawu, hapeko wawu konoho nimei pwi, ndre? Pe mandrainga wawu, hapeko wawu konoho hilingiy pwi, ndre? Pe koyu wawu kintut, ndre? ");
INSERT INTO nss_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tandrohonga uramburingi ndrinanohun mayimah iya kili hu ndramat mayipou ara (5,000), pwen wawu nihi ndritiken iya ndrop masahayeh?>> Pe hupa, <<Songui pe luhat.>> ");
INSERT INTO nss_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","<<Pe tandrohonga uramburingi ndrinanohun manandrtoyoh iya kili hu ndramat mahaapou ara, pwen wawu nihi ndritiken iya ndrop masahayeh?>> Pe hupa, <<Manandrtihat.>> ");
INSERT INTO nss_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pwen ipwai iya kili hu, ipa, <<Lohonga wawu kinileu mapu ko, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu iyasura ndramiran hu huyarayah huya kol mendreheh Petsaita. Pe hu ndramat hayah huwiri ndramat hamou maran iyoh isa kili yiy. Pe hurakekeyani Yesu para kiyki niman kiyahatek kili ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pwen Yesu imbultuwe nima ndramat mepo maran iyoh ara, pe iluwi yiy pe hiltali kol mendreheh ara, hilya ngawan. Pwen Yesu isokombunuhi maran, pe iyki niman iya ndritan. Pwen isike yiy, ipa, <<Anime hapesah, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ndramat ara maran itandras, pe ipa, <<Unime hu ndramat, hapeko nimnim tahu ara tehe hu kei hutora tokai huya-husa.>> ");
INSERT INTO nss_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pwen Yesu iyki niman paiwe iya mara ndramat ara. Pe maran isa leu, pe isarayah hiyan paiwe, pe inime memelit masih ileu. ");
INSERT INTO nss_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pwen Yesu ipwandrisa yiy iyau iya wum, pe ipa, <<Mbuna amui aya nondriya kol mendreheh ara.>> ");
INSERT INTO nss_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pwen Yesu iyapolo ndramiran hu huyau huya kol hayah mendreheh, pakeh kili kol ngawan Sisariya Pilipai. Huro tokai sai huya, pe Yesu isike hu, ipa, <<Akapwai kisa kili yo, hu ndramat masih hutora pa ndre yo hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pwen hupwai, hupa, <<Hu hayah hupa wou Yohanes Ndramat para Paptais; pe hu hayah i, hupa wou Eliyah; pe hu hayah i, ara hupa wou hamou tahu poropet.>> ");
INSERT INTO nss_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pwen Yesu isike hu, ipa, <<Pe wawu, ara wawu pa ndre yo hiyeh?>> Pwen Pita isomwi yiy ipa, <<Wou ara Kristus.>> ");
INSERT INTO nss_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pwen Yesu ipwandrandrahani hu para hu mbuna katiyaniy kiya kili hamou tehe yiy hiyeh. ");
INSERT INTO nss_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pwen Yesu iro hinuwani hu tehe Noru Ndramat, ara andre kiya nondriya hu ngandran soyon, pe andre hu yapane kol, hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, ara andre hu kahamwisnani yiy, pe andre hu katingundrun kimat; pe lang maroyoh kihipwen, andre kisa tine paiwe. ");
INSERT INTO nss_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pe itiyani nongan ara, iya ngawan kili hu. Pwen Pita iwiri yiy iya pwakin pe iro pomate yiy. ");
INSERT INTO nss_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hapeko Yesu ipaiwani maran iya kili ndramiran hu, pwen ipomate Pita, ipa, <<Sinai, asaya ndruwo! Wou anto ndruwa lohonga Ngindrai pwi, hapeko ata ndruwa lohonga ndramat opu.>> ");
INSERT INTO nss_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pwen Yesu iyoh hu ndramat masih husa kili yiy, iyapolo ndramiran hu, pe ipwai iya kili hu, ipa, <<Kapa sehe ndramat pakiho ndruwo, ara andre kipa pwi katan mbukenan, pe kisap kei tondrih tan, pe kisa kiho ndruwo. ");
INSERT INTO nss_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Paratesah, Pe hiyeh kihimbusani mwoiwan mbukenan, andre mwoiwan kitali yiy. Pe hiyeh kilohongani yo, pe kirikai kiya nongan hiyan ato, pe kitali mwoiwan kisa kili yo, pwen andre kisopwat mwoiwan mbukenan. ");
INSERT INTO nss_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sehe melit hiyan andre ndramat hamou kiwiriy kapa memelit masih para kol pwan kiya mbukenan yiy, hapeko yiy kitali mwoiwan pe kimat? ");
INSERT INTO nss_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sehe melit ndrokonan ndramat hamou ilahiy para kiykiy para kisuliyani taleh tan kimui? ");
INSERT INTO nss_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pe kapa ndramat hamou kimasi to, pe kimasi kiya nongno kiya nondriya hu lang mwomwan aripo—hu lang para pilah pe pakut mwomwan tahu hasap mahapo—ara andre Noru Ndramat kimasi ta ndramat ara yi, kiya lang mulan—kirahihini lang para yiy nakisa, kiyapolo nonowa ngana Taman pe kiyapolo hu angelou haiyan.>> ");
INSERT INTO nss_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pwen Yesu ipwai iya kili hu, ipa, <<Upwai ndrokonan isa kili wawu, tehe hu hayah mepo hutopo tine iye, ara andre hu kanhingorowe kimat kileh pwi, kipoo hu kanime kolo King Ngindrai mepo ngara kiro mu kiya aliy kisarayah kisa sura pwoke tan.>> ");
INSERT INTO nss_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pe lang manonoh ihipwen, Yesu iwiri Pita, Yamis, pe Yohanes huya polo yiy, pe iluwani hu huya ngondron sih paingan. Yihu kopu huya pe huro aliy. Pe nombuwe Yesu ipiy iro mbulmarahu. ");
INSERT INTO nss_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pe koiwen, ara isarayah pallen pe ngannganan iya. Kinlahi ndramat hamou para kol pwan kisungani koyau kisarayah pallen tehen tora, ara pwi. ");
INSERT INTO nss_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pe Eliyah iyasura Mose ara hilsarayah hilsa mbulmarahu, pe hilro wong iyasura Yesu. ");
INSERT INTO nss_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pe Pita ipwai iya kili Yesu, ipa, <<Ndramat para Hinonou, hiyan para yowu koro iye. Pwen yowu kapuli yopai matiwum—hawum atam, pe hawum ata Mose, pe hawum ata Eliyah.>> ");
INSERT INTO nss_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita ipa toro, paratesah, hunoh mimiri hu, pe ikowu sehe nongan para kiwong kiya aliy. ");
INSERT INTO nss_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pwen kokom isa pe iramburuhi hu, pe yoholai sahin iyau nondriya kokom, ipa, <<Iye, ara noru mepo ndriyo imbuluhi yiy. Wawu kahilingi yiy.>> ");
INSERT INTO nss_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Indrou pwi ko, pe marahu ihiselep, pe hu kannime hamou pwi; Yesu ko iro surahu. ");
INSERT INTO nss_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pwen hutali ngondron pe huro tuh nakamui kasa pwan, pe Yesu ipwatisingiy iya kili hu tehe hu mbuna kanese ndrainga hamou kiya sehe melit hu kannimei, kipoo Noru Ndramat kimat pe kitine paiwe. ");
INSERT INTO nss_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Humbultuwe tisingi nongan ara, pe huro panguluwaniy mwalingahu, hupa, <<Ndroiyi nongan ara, ara ipa tesah ndrokonan—<kimat pe kitine paiwe>?>> ");
INSERT INTO nss_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pwen husok Yesu, hupa, <<Paratapeh pe hu ndramat para hinuwani nongan para pwahanou ngara hu kapwai tehe Eliyah andre kisa kimu?>> ");
INSERT INTO nss_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Pwen Yesu ipwai iya kili hu, ipa, <<Nongan ara ndrokonan; Eliyah andre kimu kisa pe kimwaniyani hu melit masih. Hapeko tehen tapeh, nongan ita nongna Ngindrai koluw, ara kinpwai tehe Noru Ndramat andre kikuni nopwaran pe andre hu ndramat kamwisnani yiy?>> ");
INSERT INTO nss_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hapeko upwai isa kili wawu toro: Eliyah, ara kinsa pwen. Pe hu kanmbusi kultuw handra-handra kinna kili yiy tehe pwayan hu kantatuluwiy kinnatan. ");
INSERT INTO nss_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pwen Yesu iyasura hu matimou, ara humui husarayah husa kili ndramiran hu hayah i; pe hunime hu ndramat soyon iya hurahakowahu. Pe hu ndramat para hinuwani nongan para pwahanou hayah, ara huro takekei iyasura hu ndramira Yesu. ");
INSERT INTO nss_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pe iro mwonen hu ndramat ara, huho nime Yesu ko, pe huteleh mwomwan, pe hungap huya, pe hupohonani yiy. ");
INSERT INTO nss_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pe Yesu isike hu, ipa, <<Wawu tora takekei iyapolohu, ara ndroiyin tesah ndrokonan?>> ");
INSERT INTO nss_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ndramat hamou iro mwalingahu isomwi Yesu, ipa, <<Ndramat Para Hinonou, yo uwiri noru kamai isa kili wou, paratesah, payit para pohomum iripo ndritan. ");
INSERT INTO nss_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kiro mwonen lang para memelit mwomwan ngara kikohis kiya ndritan, ara ngara kimbultuwe yiy pwokeyan pe kipiyani yiy kiya pwan. Pe ngara mbusas kiro wet pohon, pe kiyantani koltan, pe mandran kisiyan. Usok ndramiram hu para hu karasses payit kiya mawen, hapeko hu kanwenei pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Pwen Yesu iwong imui iya kili hu, ipa, <<O wawu hasap para mahapo, ara wawu kanpwotisingi lohonga wawu pwi, pe lohonga wawu imwakaikai. Mwalaiheh pe andre kuro sura wawu ko yeh? Pe maporosahayeh andre kuro kuni nopwaran tawawu ko yeh? Wawu kawiri mbunah kamai ara, kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pwen huwiri wihou ara, iya kili Yesu. Pe payit ariya inime Yesu pe indrou pwi ko, ilosani wihou iya mwomwan; ipiyani yiy iya pwan pe iro tiriyani yiy, pe mbusas iro wet pohon. ");
INSERT INTO nss_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pwen Yesu isike taman, ipa, <<Maporosahayeh kintayah kili yiy?>> Pe taman isomwiy, ipa, <<Yiy mamendreheh o pe irayah. ");
INSERT INTO nss_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lang hitun kinna ngara kipiyani yiy kiya mwan pe ndran kene, pe pakitingundrun kimat. Hapeko kapa alahiy para amwaniyani yiy, pwen koyum kisikirani youlu pe asopwat youlu.>> ");
INSERT INTO nss_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pe Yesu ipwai iya kili yiy, ipa, <<Paratapeh pe apa, <Kapa alahiy?> Melit masih andre karayah kapa ndramat hamou kipwotisingi lohongan.>> ");
INSERT INTO nss_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Indrou pwi ko, tama wihou ara, ara iwayeh, ipa, <<Yo upwotisingi lohongo; hapeko lohongo, ara mulai opu. Asopwat yo.>> ");
INSERT INTO nss_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pwen Yesu inime hu ndramat soyon huro ngap husa pakeh kili hu, pwen ipomate payit ara, pe ipwai iya kili yiy, ipa, <<Wou payit para pohomum pe ndrainga pwi, upwandrandrahaniy isa kili wou, atali yiy aya mawen, pe mbuna amui asa ndritan paiwe.>> ");
INSERT INTO nss_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pwen payit ara, iwayeh iya namandran masih, pe wihou ara, iro lokuwai pwokeyan iya. Pe payit isa mawen kili yiy. Pe wihou ara, imbuyei tehe kinimat pwen. Pe hu ndramat soyon iya hunime yiy pe hupa ndre kinimat. ");
INSERT INTO nss_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hapeko Yesu iyki niman iya kili yiy pe isoli yiy pe itine. ");
INSERT INTO nss_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iyamulan para aliy, Yesu iya nondriya seu, pe ndramiran hu husok yiy nokule ko, hupa, <<Paratapeh pe yowu kanlahiy para karasses payit ara, kiyau pwi?>> ");
INSERT INTO nss_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pwen Yesu ipwai iya kili hu, ipa, <<Melit iye ara andre kirayah kiyau totohun opu.>> ");
INSERT INTO nss_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pwen hutali kol ara, pe husayau nondriya kol namandran hape Kaliliy. Pe Yesu, ara mbuwalin para ndramat hamou kipahasani sehe kol ndrokonan huro aliy, ");
INSERT INTO nss_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","paratesah, yiy iro hinuwani ndramiran hu. Yesu ipwai iya kili hu, ipa, <<Noru Ndramat, ara andre hu karatuni pe kaiki yiy kiya kili hu ndramat pe andre hu katingundrun. Hu katingundrun kihipwen, pwen kiho nondriya lang maroyoh andre kitine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hapeko ndramiran hu ara hu kanpahasani ndroiyi nongan ara pwi, pe hunoh para kasok yiy kiya aliy. ");
INSERT INTO nss_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pe husarayah husa Kapernawum pe husoro nondriya seu. Pwen Yesu isike hu, ipa, <<Wawu ro tokai sai wawu sa, pe wawu ro takekei iya nongna tesah?>> ");
INSERT INTO nss_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hapeko humun opu, paratesah, huro pwen sai husa pe huro takekei mwalingahu para hiyeh tahu iho hin. ");
INSERT INTO nss_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pwen Yesu impwan pe iyoh hu Songui pe Lumou husa kili yiy, pe ipwai iya kili hu, ipa, <<Kapa hamou tawawu nakiho hin, pwen andre kiyki yiy kisa pwan masih, pe kirayah tehe ndramat para poya mbulya hu ndramat masih.>> ");
INSERT INTO nss_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pwen iwiri mbunah hamou mendreheh, pe iyki yiy iro tine mwalingahu. Pe ipwokarani yiy iro niman, pe ipwai iya kili ndramiran hu, ipa, ");
INSERT INTO nss_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Kapa sehe ndramat kimbusi hiyan kiya kili mbunah mendreheh hamou tehen iye kiya ngolo, pwen imbusi hiyan isa kili yo; pe hiyeh kimbusi hiyan sato, ara kinmbusiy sato ko pwi, hapeko imbusiy iya kili hiyeh mepo ipwandrisa yo usa.>> ");
INSERT INTO nss_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pwen Yohanes ipwai, ipa, <<Ndramat Para Hinonou, yowu nime ndramat hamou iro rasses hu payit huyau iya ngalam. Pe yowu pwayi yiy para kihitohai, paratesah, yiy hamou para sura tou pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hapeko Yesu ipwai, ipa, <<Wawu mbuna akasingori yiy. Kapa ndramat hamou kimbusi ndraikiya melit kiya ngolo, pwen kinlahiy para kipwahaltani yo kileh pwi. ");
INSERT INTO nss_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hiyeh mepo kintasisingat anarou pwi, ara yiy para susura tou. ");
INSERT INTO nss_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pe kapa sehe ndramat kinime wawu ndramira Kristus, pe kihang wawu ndran wawen hape kiya ngolo, pwen upwai ndrokonan isa kili wawu, tehe Ngindrai, ara andre koyun kinmayit kennen pwi. ");
INSERT INTO nss_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kapa hiyeh kimbusi hamou tahu mbunah mendreheh iye, mepo hupwotisingi lohongahu isa kili yo, para kiyos kiya pakut mwomwan, pwen sehe ndramat kimbusiy tehen tora, kora tandroindroi tan ara, ara toro: hiyan para hu kandruyani pat sih namandran kiya koyun, pe kapiyani yiy kiya nondriya ndras. Hapeko koran ndrokonan nakiwiriy, ara mwomwan masih. ");
INSERT INTO nss_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kapa nimam hakai kimbusi wou ayos aya pakut mwomwan, pwen hiyan para asondriti nimam ara, kiyau. Hiyan para aya paingan kapolo nimam hakai o. Matisan aya kapolo nimam malkai pe hu kapiyani wou aya nondriya ngat mepo mwan itayat aliy. ");
INSERT INTO nss_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Pe kapa ndrikam hakai kimbusi wou ayos aya pakut mwomwan, pwen hiyan para asondriti ndrikam ara, kiyau. Hiyan para aya paingan kapolo ndrikam hakai o. Matisan aya kapolo ndrikam malkai, pe kapiyani wou aya nondriya ngat mepo mwan itayat aliy. ");
INSERT INTO nss_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tehen aliy opu, kapa maram sih kimbusi wou pe ayos aya pakut mwomwan, pwen hiyan para atangihi maram ara, kiyau. Hiyan para wou aya kolo King Ngindrai mepo ngara kiro mu kiya aliy kiyapolo maram sih o, Matisan maram malwoh kiro hiyan, hapeko hu kapiyani wou kiya nondriya ngat mepo mwan ita yat aliy. ");
INSERT INTO nss_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kol ara, <wiy ipep ita aliy pe hu konoho mat pwi. Pe mwan ita yat aliy yi, ara andre kinto-kinto.> ");
INSERT INTO nss_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pe ndramat masih andre mwan kitimwi hu tehe ndras ngara kimbusi melit kirayah haiyan. ");
INSERT INTO nss_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ndras para kanyai, ara hiyan, hapeko kapa ndras kankanan pwi, pwen andre tukambusi tesah para kana ndras kimui? Pwen wawu karayah tehe ndras, pe ndriya wayis kiro sura wawu hamou-hamou.>> ");
INSERT INTO nss_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pwen Yesu itali kol ara, pe iya kol namandran hape Yutiya ita haroh para ndran Yortan. Pe hu ndramat soyon iya husa mbultere hu porosih i. Pe ihinuwani hu iya nongna Ngindrai, paratesah, kultuwayi kowasen, ara tehen tora ko. ");
INSERT INTO nss_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hu Parisiy hayah husa kili Yesu pe hunohonou Yesu iya nongan sahin. Pe husike yiy, hupa, <<Nongan para pwahanou ta Ngindrai ipa hiyan para kamai hamou kitali nambuyun, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu isomwi hu, ipa, <<Mose kinpwandrandrahani tapeh ita nongan para pwahanou kinsa kili wawu?>> ");
INSERT INTO nss_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pe hupwai, hupa, <<Mose, ara kinpa hiyan para ndramat hamou kiratuluwi nongan para yesou kimut pe kitali nambuyun kiyau.>> ");
INSERT INTO nss_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hapeko Yesu ipwai iya kili hu, ipa, <<Mose kinpahasaniy tehe ndriya wawu, ara ipwoke, pwen pe yiy iratuluwi nongan para pwahanou ara isa kili wawu. ");
INSERT INTO nss_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hapeko koluw-koluw mamu kinna, Ngindrai imangsani hu ndramat malpat—kamai pe pihin. ");
INSERT INTO nss_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","<Pwen tehen tora ko, andre kamai kitali taman hilu tinan, pe andre hilu pihin tan karayah hapat, pe nombuwe hilu kirayah hamou o.> ");
INSERT INTO nss_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Pwen tehen tora ko hilu konto tehe malmou pwi; hapeko nombuwe hilu kintayah hamou o. ");
INSERT INTO nss_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pwen sehe melit Ngindrai kiniykiy kinna wule, ara ndramat mbuna kimbusi mwalinga hilu kimut.>> ");
INSERT INTO nss_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pwen humui huya nondriya seu i, pe hu ndramira Yesu husok yiy porosih i iya lohongai ara. ");
INSERT INTO nss_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pe Yesu ipwai iya kili hu, ipa, <<Kapa kamai hamou kitali nambuyun, pe kiyesou kiya kili pihin hamou paiwe, ara ipo pilah pe irandroyani nambuyun. ");
INSERT INTO nss_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pe tehen aliy o, kapa pihin hamou kitali nambuyun pe kiyesou kiya kili kamai hamou paiwe, ara ipo pilah.>> ");
INSERT INTO nss_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hu ndramat hayah huwiri hu mbunah mendreheh husa kili Yesu para Yesu kiyki niman kiya ndritahu. Hapeko ndramiran hu hunimei pe hupomate hu ndramat ara. ");
INSERT INTO nss_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pwen Yesu inimei tora pe ndriyan kinipwes pwi, pe ipwayi ndramiran hu, ipa, <<Wawu katali hu mbunah kasa kili yo, pe mbuna akakaituwe hu, paratesah, kolo King Ngindrai mepo ngara kiro mu kiya aliy, ara atahu tehen aro kene. ");
INSERT INTO nss_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yo upwai ndrokonan isa kili wawu, kapa ndramat hamou kinwiri kultuwayi kolo King Ngindrai mepo ngara kiro mu kiya aliy tehe mbunah hamou tehen iye pwi, ara kinlahiy para kiya nondriyan pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pwen ipwokarani hu mbunah husa ndrahasa niman, pe iyki niman iya ndritahu pe itoholi hu. ");
INSERT INTO nss_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pwen Yesu itine iro tokai iya iho sai, pe ndramat hamou ingap isa pe itukuruhu iya mbulmaran, pe isok yiy, ipa, <<Ndramat Hiyan Para Hinonou, yo andre kumbusi tapeh para kuwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Pwen Yesu ipwai, ipa, <<Paratapeh wou apohowe yo hiyan? Hamou hiyan pwi. Ngindrai hamou opu, ara yiy hiyan. ");
INSERT INTO nss_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wou tanam hu nongan para pwahanou: mbuna atingundru ndramat kimat, mbuna apo pilah, mbuna apahana, mbuna apakarawani ndramat hamou kiya nongan, mbuna apwokoiwe, pe ahaiyani tamam hilu tinam.>> ");
INSERT INTO nss_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pe ndramat aro, ipa, <<Ndramat Para Hinonou, mawihou to ko isa matne mahapo, pe kunmbusi melit masih atapohowei ara.>> ");
INSERT INTO nss_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu maran iya kili yiy pe ndriyan imbuluhi yiy pe ipwai iya kili yiy, ipa, <<Melit handra ko ita ndron para ambusiy. Ayau aya, pe ayapo pehei kiya hu melit masih atam, pe awiri singayai para aliy, pe atainganiy kiyata hu ndramat mepo hundroisiy, pe andre awiri hu melit lahayan kennen namandran ita kol paingan yang. Pwen asa, oho ndruwo.>> ");
INSERT INTO nss_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ndramat aro ihilingi nongan ariyo pe mbulmaran ilomwa, pe iyau iyapolo ndriya pworu, paratesah, menmenan ara soyon iya. ");
INSERT INTO nss_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pwen Yesu maran ihiselep iya kili ndramiran hu pe ipwai, ipa, <<Hu ndramat mepo menmenahu soyon, ara ingandrah pwokeyan iya para hu kaya nondriya kolo King ta Ngindrai mepo ngara kiro mu kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ipa toro, pe ndramiran hu mwoiwahu ihin iya nongnan. Hapeko Yesu ipwai paiwe, ipa, <<Wawu noru, ndramat mepo iyki ndriyan iya meltan soyon iya, ara ingandrah para kiya nondriya kolo King ta Ngindrai mepo ngara kiro mu kiya aliy. ");
INSERT INTO nss_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ingandrah para kamel hamou kisong kiya ngara kannih, hapeko ngandrahan iya para ndramat hamou menmenan soyon iya kisong kiya nondriya kolo King ta Ngindrai mepo ngara kiro mu kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pe ndramiran hu, ara huro lohonge ndrit pe huro wong mwalingahu ko, hupa, <<Kapa tehen tora, pwen andre hiyeh ndrokonan kilahiy para kiwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pwen Yesu maran iya kili hu pe isomwi hu, ipa, <<Hu ndramat, ara kanwenei pwi, hapeko Ngindrai, ara pwi, yiy ara iwenei para kimbusi melit masih kene.>> ");
INSERT INTO nss_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pwen Pita iwong iya kili Yesu, ipa, <<Kiya, animei; yowu kantali melit masih para koho ndruwam.>> ");
INSERT INTO nss_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pe Yesu ipwai iya kili yiy, ipa, <<Upwai ndrokonan isa kili wawu; kapa sehe ndramat kilohongani yo pe nongan hiyan, pe kitali suwen, ndre nalin hu, ndre pisun hu, ndre taman, ndre tinan, ndre norun hu, ndre pwenen, ");
INSERT INTO nss_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","pwen andre yiy kipo suluya melit soyon iya, kirayah tehe sangat, andre kirayah kili yiy mahapo iripo kol pwan. Ngindrai andre kiyki melit soyon iya andre kiramwaitini melit para koluw. Andre ndramat ara kiwiri suluya seu, suluya nalin, suluya pisun, suluya tinan, suluya norun, pe suluya pwenen soyon iya. Pe andre kiya nondriya nopwaran i, nopwaran mepo hu ndramat andre hu karandroyani yiy kiya aliy. Pwen lang mulan nakisarayah, andre yiy kiwiri taleh mepo andre kinto-kinto. ");
INSERT INTO nss_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hapeko hu ndramat soyon hutora mu, ara andre hu kaya mulan; pe hu ndramat soyon hutora mulan, ara andre hu kaya mu.>> ");
INSERT INTO nss_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pwen huro tokai sai nakaya Yerusalem pe Yesu ara iye mu tahu. Pe ndramiran hu ara lohongahu indrap, pe hu ndramat huro ndruwahu, ara hunoh. Pwen iwiri hu Songui pe Lumou huya pwakin hape pe itiyaniy iya kili hu iya sehe melit andre kirayah kili yiy. ");
INSERT INTO nss_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Pe ipwai iya kili hu, ipa, <<Akahilingiy! Worou nakaya paingan Yerusalem pe andre hu ndramat karatuni Noru Ndramat kiya nima hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou. Pe andre hu kaiki yiy kiya nongan pe kamburi nongan para katingundrun kimat. Pe andre hu kaiki yiy kiya nima hu Ndramira Lah. ");
INSERT INTO nss_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pe andre hu kapwasimiri yiy, pe kasokombunuhi yiy, pe andre hu kamwiri yiy kiya malkei; pwen andre hu katingundrun kimat. Pe lang maroyoh kihipwen, andre kisatine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pwen hilu NdraSepetiy malmou, Yamis hilu Yohanes, hilu sa kili Yesu pe hilu pwai iya kili yiy, hilu pa, <<Ndramat Para Hinonou, sehe melit youlu nakasok wou kaliy, ara youlu namiliy para ambusiy kisa kili youlu.>> ");
INSERT INTO nss_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pe ipwai iya kili hilu, ipa, <<Walu namiliy para kumbusi tesah kisa kili walu?>> ");
INSERT INTO nss_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pe hilu pwai iya kili yiy, hilpa, <<Kiro mwonen wou narayah king kiyapolo nonowam, pwen youlu namiliy tehe hamou toulu kimpwan kapwen te nimam mot, pe hamou kiyapwen te nimam kamou.>> ");
INSERT INTO nss_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hapeko Yesu ipwai iya ta hilu, ipa, <<Walu tana walu tesah walu tora sok iya aliy pwi. Walu lahiy para kayin kiya pweniu iye mepo pakeh nakuyin kaliy? Ndre walu lahiy para kaya nondriya paptais mepo nakuya aliy aro yi?>> ");
INSERT INTO nss_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pe hilu pwai iya kili yiy, hilpa, <<Ehe, ara youlu lahiy.>> Pe Yesu ipwai iya ta hilu, ipa, <<Ndrokonan; pweniu mepo nakuyin kiya aliy, ara andre walu kayin kaliy yi. Pe sehe paptais nakuwiriy, ara andre walu kawiriy i. ");
INSERT INTO nss_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hapeko para walu kampwan kapwen te nimo mot ndre kamou, ara yo kunlahiy para kusomwi walu pwi. Ndrohonoku pwanpwan ara, ara Ngindrai kinmwaniyaniy pwen nakiya ta hilu sehe ndramat mepo hilu nakaya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pwen ndramiran hu masongui, ara huhilingi nongan aro, ara ndrinahu ilokuh ta Yamis hilu Yohanes. ");
INSERT INTO nss_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hapeko Yesu iyoh hu masih husa wule kili yiy, pe ipwai iya kili hu, ipa, <<Wawu pahasaniy tehe hu yapane hu Ndramira Lah, ara ngara hu kaya mu kata ndramirahu tora pahandrahu. Pe hu pohon tahu, ara ngara hu karakekeyani hu, iyapolo pwoke nopwaran, para hu koho ndruwa nongnahu. ");
INSERT INTO nss_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Hapeko wawu, ara tehe yihu pwi. Hiyeh tawawu pakirayah namandran, ara andre kirayah ndramat para poya mbulya wawu. ");
INSERT INTO nss_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pe hiyeh ta wawu pakimu ta wawu masih, ara andre kirayah ndramat para pawandrendres o mwaihei tawawu masih. ");
INSERT INTO nss_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Paratesah, Noru Ndramat kinsa para hu ndramat kasopwat yiy pwi, hapeko isa, ara para kisopwat hu ndramat, pe para kiyki mwoiwan para kikonuhi hu ndramat soyon hu kamui.>> ");
INSERT INTO nss_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pwen husa kol ngawan Yeriko, pe iyamulan Yesu iyasura ndramiran hu nakatali kol ara, iyapolo hu ndramat soyon iya huro ndruwahu. Pe ndramat hamou maran iyoh, ngalan Partimeyus, yiy noru ndramat hamou ngalan Timeyus, ara yiy impwan pwaki sai pe iro rakamam iya kili hu ndramat. ");
INSERT INTO nss_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yiy ihilong tehe Yesu ndramat para kol Nasaret, iropo isa. Pwen iyoh iya namandran iya, ipa, <<Yesu, noru Tepit, koyum kisikirani yo!>> ");
INSERT INTO nss_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hu ndramat soyon iya hupomate yiy para kimun opu, hapeko iwayeh namandra-namandran iya, ipa, <<Yesu, noru Tepit, koyum kisikirani yo!>> ");
INSERT INTO nss_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pwen Yesu ihilingi yiy pe iro tine pe, ipa, <<Akayoh yiy kisa.>> Pwen huyoh ndramat maran iyoh ara isa, pe hupwai iya kili yiy, hupa, <<Apwokeyani wou pe atine; yiy ita yoh wou.>> ");
INSERT INTO nss_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pwen itali tamburuhan iya mawen, ikohis, pe isa kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu isomwi yiy, pe ipa, <<Wou anamiliy para kumbusi tesah kisatam?>> Pwen ndramat maran iyoh ara, ipwai, ipa, <<Ndramat Para Hinonou, yo unamiliy para kunimnim.>> ");
INSERT INTO nss_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Pe Yesu ipwai iya kili yiy, ipa, <<Kiya, ayau; lohongam ndrisiyon, ara kinsopwat wou.>> Hape pwi ko, maran inimnim paiwe. Pwen iho ndruwa Yesu, pe huro tokai sai huyau. ");
INSERT INTO nss_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yihu ropo husa pakeh Yerusalem, pwen husa kol malkol hira Pahayi Holip, ngala kol malkol ara, Petpake pe Petaniy. Pwen Yesu ipwandrisa ndramiran hilu malmou, ");
INSERT INTO nss_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","pe ipwai iya kili hilu, ipa, <<Walu kaya mu kaya kol mendreheh yoho mu kili walu, pe kiro mwonen walu nakaya nondriyan, andre walu kanime noru tongkiy hamou hu kanwasi yiy ita; pe tongkiy ara, ara ndramat hamou kinmipwan ndritan mapu. Alkatali yiy pe alkaluwi yiy kisa. ");
INSERT INTO nss_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kapa hamou kisike walu, kipa, <<Walu tora po tesah?>> Pwen walu kapwai kiya kili yiy, alkapa, <Yapan inamiliy namu, pwen andre kindrou pwi ko kimui kisa nokun.> >> ");
INSERT INTO nss_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pwen hilya pe hilu nime noru tongkiy hamou, iro tine sai, mepo hu kanwasi yiy pwen iho pohomara seu hawum. Pwen hiluro lombuliy, ");
INSERT INTO nss_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","pe ndramat hayah huro tine pakeh, ara husike hilu, hupa, <<Walu tora lombuli tongkiy ara—walu nakasahaye walu kaliy eh?>> ");
INSERT INTO nss_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hilu pwai imui iya kili hu sehe nongan Yesu kinpwai kinna kili hilu. Pwen hupa hiyan para hilu kawiriy kiya. ");
INSERT INTO nss_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pwen hilu wiri tongkiy isa kili Yesu, pe hilu tali ndroha hilu pe hilu pwalaniy iya ndrita tongkiy pe Yesu iya mipwan aliy. ");
INSERT INTO nss_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pe hu ndramat soyon iya hupwalaniy koyau tahu iya ndrita sai. Pe hu hayah tahu huya piyang pe huya sondriti ndrandra nonou hayah pe hupwalaniy iya sai yi. ");
INSERT INTO nss_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pe hu ndramat huro mu pe hu ndramat huro ndruwan kene ara huro wayeh, hupa tehe toro: <<Hosanna! Lomwes ita kili yiy mepo isa iya ngala Yapan. ");
INSERT INTO nss_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ngindrai andre kiyki lomwes kiya kolo king mepo ngara kiro mu kiya aliy ta tamarou Tepit. Hosanna, kahari ngala Ngindrai iyera paingan masih!>> ");
INSERT INTO nss_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu iya nondriya Yerusalem pe isong iya nondriya yumwa totohun namandran, pe maran ituluwani melit masih. Hapeko kol iro piyah, pwen yiy imui iya Petaniy, iyasura hu Songui pe Lumou. ");
INSERT INTO nss_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mandroulang para lang sih, huro tali Petaniy huyau pe Yesu ihingorowe yiy imundrui. ");
INSERT INTO nss_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pe inime kei pik hakou ara iho mawen hape, pe yowin iramburuhiy. Pwen pe iya pakeh, ipa ndre mbuwan iho pwoyen, hapeko iya pe inimei tehe kei aro kinippwai pwi. Hitun yowin opu; paratesah, nowen para kippwai, ara mapu. ");
INSERT INTO nss_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pwen Yesu ipwai iya kili kei ara, ipa, <<Kiro matne mahapo kiya, ndramat hamou andre kinyan sangim paiwe pwi.>> Pe ndramiran hu huhilingi nongan ipwai ara. ");
INSERT INTO nss_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pwen Yesu iyasura ndramiran hu huyarayah huya Yerusalem. Pe Yesu isong iya nondriya kowa yumwa totohun namandran, pe iro rasses hu ndramat mepo huropo pehei pe huro sousou memelit iya aliy. Pe itipiyani hu keyau tahu ndramat huro sulye sombule pat, pe itipiyani pwapwai tahu ndramat huro sousou pai tahu. ");
INSERT INTO nss_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pe ipwayi hu ipa nonombun para hu mbuna kakun melit para sousou kohorokai kaya kasa nondriya kowa yumwa totohun namandran. ");
INSERT INTO nss_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pwen ipwahanou hu, pe ipa, <<Nongna Ngindrai mepo hu kantatuluwiy, ara pwayan ipa toro, ndre? Ngindrai ipa, <Suwe, ara andre kapohowei tehe seu para katohun ta hu ndramat masih para kol pwan masih, para hu katohun kisa kili yo.> Hapeko wawu kanmbusiy kintayah ndrohona kokohon tahu ndramat para pahana.>> ");
INSERT INTO nss_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pe hu pris huhohin ta hu pris masih iyasura hu ndramat para hinuwani nongan para pwahanou, ara huhilingi nongan ariyo pe huro ten lohongai para katingundru Yesu kimat. Hunohowani yiy, paratesah, hunimei tehe hu ndramat soyon huteleh mwomwan iya nongan iro tiyaniy. ");
INSERT INTO nss_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pwen kol ipiyah pe Yesu iyasura ndramiran hu hutali Yerusalem. ");
INSERT INTO nss_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pwen iya ndroulang para aliy, huro tokai sai huya, pe hunimei tehe kei pik mepo Yesu iten anan ara, ara kinimang pwen te wiyin iya, ipoo ita ngondron. ");
INSERT INTO nss_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pe Pita ilohongani sehe melit Yesu kinmbusiy, pwen ipwai iya kili Yesu, ipa, <<Ndramat Para Hinonou, animei! Kei pik mepo aten anan ara kinimang masih.>> ");
INSERT INTO nss_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pwen Yesu isomwi hu, pe ipa, <<Lohonge ta wawu kipwotisingi Ngindrai. ");
INSERT INTO nss_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Upwai ndrokonan isa kili wawu, kapa hamou kipwai kiya ta pahayi ita para kiret kisa paingan pe kikohis kiya ndras, pe kapa kinhindrundru pwi, hapeko lohongan kipwotisingiy tehe andre kirayah, pwen sehe melit ipwai, ara andre kirayah mannan kili yiy tehe ipwai. ");
INSERT INTO nss_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pwen pe upwai isa kili wawu, melit masih mepo wawu sok iya totohun, ara lohonga wawu kipwotisingiy tehe akanwiriy pwen, pe andre kirayah mannan kisa kili wawu. ");
INSERT INTO nss_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Pwen kapa wawu koro tine pe akatohun, pe akalohongani sehe melit mwomwan mepo hiyeh kinmbusiy kinsa kili wawu, ara akatali mwomwan tan; pwen pe tama wawu iyera kol paingan yang, ara andre kitali mwomwan ta wawu yi.>> ");
INSERT INTO nss_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pwen humui husarayah husa Yerusalem paiwe, pe Yesu iya ihorokai nondriya kowa yumwa totohun namandran. Pe hu pris huhohin ta hu pris masih, iyasura hu ndramat para hinuwani nongan para pwahanou, pe hu yapane kol, ara hu masih huya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Pe husok yiy, hupa, <<Wou awiri pwoke nopwaran ara, iyau aleheh? Pe hiyeh iyki pwoke nopwaran ara, isa kili wou para ambusi melit aro?>> ");
INSERT INTO nss_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Pe Yesu isomwi hu, ipa, <<Yo nakusike wawu kiya soksok sahin. Pe kapa akasomwi yo, pwen andre kupwai kisa kili wawu, hape aleheh uwiri pwoke nopwaran aro iyau aliy, pe urupo mbusi hu melit aro. ");
INSERT INTO nss_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Akapwai kisa kili yo na: Yohanes ngara kisumuluwani hu ndramat, pe wawu pa ndre kultuw para paptais ta Yohanes ara, ara iyau kol paingan yang, ndre iyau kili ndramat opu?>> ");
INSERT INTO nss_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pe huro panguluwaniy mwalingahu ko, huro pa, <<Kapa tukapa, <Iyau kol paingan yang,> pwen andre kisok, kipa, <Pwen tehen tapeh pe lohonga wawu kinpwotisingi nongnan pwi?> ");
INSERT INTO nss_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hapeko mbuna tukapa, <Iyau kili hu ndramat opu>—ara konan.>> (Hupwai tehen toro, paratesah, hunoh tahu ndramat masih, ara hunimei tehe Yohanes, ara yiy poropet hamou ndrokonan.) ");
INSERT INTO nss_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pwen pe husomwi Yesu, hupa, <<Yowu tana yowu pwi.>> Pe Yesu ipwai iya kili hu, ipa, <<Pwen pe yo andre kunpwai kinsa kili wawu pwi yi, iyau hape aleheh uwiri pwoke nopwaran pe urupo mbusi hu melit aro.>> ");
INSERT INTO nss_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pwen Yesu iwong imu iya nongan pwandritiye iya kili hu, ipa toro: <<Ndramat hamou ihisi piyang hambut para wain, pe irahakowan. Pe yiy ipaltani kupwiy sih para haliya mbuwa wain, pe isoye keyeu sih niwen para hu ndramat keyen aliy para kamemerani piyang. Pwen iyki piyang aro iro kili hu ndramat hayah, para hu koro nimnim pe kapo mbulen kiya aliy. Pe yiy ara iyau iya kol hakol mwanan iya. ");
INSERT INTO nss_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pe irahihini lang para rihiya mbuwa mwisi wain aro, pwen ipwandrisa ndramiran hamou para poya mbulyan. Ipwai iya kili yiy para kiya pe kipo mbuwa wain hayah iro kili hu ndramat, mepo ipwai iya kili hu para hu koro nimnim kaliy. ");
INSERT INTO nss_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hapeko hu ndramat huropo mbulen iya piyang ara humbultuwe tahatini yiy, hurayi yiy iya mwomwan, pe hupwandrisa yiy iyau o mwaihei. ");
INSERT INTO nss_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pwen ndramira piyang ara ipwandrisa ndramiran hamou iya paiwe, pwen hutaluwe payan, hurandroyani yiy, pe hupwasimiri yiy. ");
INSERT INTO nss_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pe ipwandrisa ndramiran hamou iya paiwe yi, pe hutingundrun. Iyamulan, ipwandrisa hu soyon iya huya paiwe yi, pe hayah tahu hurayi hu, pe hayah tahu hutingundruhu humat. ");
INSERT INTO nss_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pwen hamou opu iro ndron para kipwandrisa yiy, ara norun imwonen mepo ndriyan imbuluhi yiy. Pwen iyamulan masih ipwandrisa norun, pe ilohonganiy, ipa, <Andre hu karanuhuyani noru.> ");
INSERT INTO nss_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hapeko hu ndramat para mbulya piyang ara huro wong mwalingahu, hupa, <Iye ara norun, soiwi taman; pe yiy andre kiwiri hu meltan masih. Kiya, tukatingundrun, pe tukawiri menmena taman masih kiya mbukenan worou.> ");
INSERT INTO nss_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pwen pe huwiri yiy pe husoyau iyatan iya ngawan piyang, pe hutingundrun imat.>> ");
INSERT INTO nss_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pwen Pe Yesu isike hu, ipa, <<Mbukena piyang andre kisa pe kitingundru hu ndramat huropo mbulen iya piyang ara pe hu kamat. Pe andre kiwiri pingen pe kiykiy kiyata hu ndramat hayah para hu koro nimnim kaliy. ");
INSERT INTO nss_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wawu kannime nongna Ngindrai sahin ara, ndre pwi? Nongan ara, ipa toro: <Pat mepo yihu ndramat para puliya seu hulowaniy, ara kintayah pat para sotuna seu. ");
INSERT INTO nss_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yapan kinmbusi melit aro kintayah, pe ara mwayih iya, iya mara tou.> >> ");
INSERT INTO nss_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pe hu pris huhohin ta hu pris masih kene, pe hu ndramat para hinuwani nongan para pwahanou, pe hu yapane kol, ara huro ten sai para hu kambultuwe tahatini yiy, paratesah, huyirowei tehe Yesu iro wong nongan pwandritiye ara, ara iyingani hu imwonen. Hapeko hunohowani hu iya mbulmara hu yau, pwen pe hutali Yesu pe huyau. ");
INSERT INTO nss_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Porosih aro hu pohon para Yutah hu pwandrisa hu Parisiy hayah pe hu ndramat hayah para kili Herot, para hu kaya kili Yesu pe hu kapakarawani yiy, pe hu karatuni yiy kiya nongnan. ");
INSERT INTO nss_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pwen huyarayah huya kili yiy, pe hupa, <<Ndramat Para Hinonou, yowu pahasaniy tehe wou ndramat para nongan ndrokonan. Pe wou anhoyos kinna nima hamou pwi, paratesah, wou anoho hire hu ndramat pwi. Pe wou ngara ahanuwani kultuwayi Ngindrai masih ndrokonan opu. Kiya; alohonganiy tapeh? Hiyan para yowu kayuk takis kiya kili Sisar, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tehen tapeh, yowu kayuk ndre konan?>> Hapeko Yesu ara kinpahasaniy tehe yihu ara ndramat para pwandrandraman. Pwen isok hu, ipa, <<Paratapeh wawu pakaratuni yo? Akawiri sombule pat hambut kisa pe kunimei na.>> ");
INSERT INTO nss_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pwen huwiri sombule pat hambut iya kili Yesu, pe ipwai iya kili hu, ipa, <<Kiya, iye, ara sumwoiwa hiyeh pe ngala hiyeh iripo aliy?>> Pe husomwi yiy, hupa, <<Ata Sisar.>> ");
INSERT INTO nss_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pwen Yesu ipwai iya kili hu, ipa, <<Kiya, akaiki sehe melit ata Sisar kiya kili Sisar, pe ata Ngindrai kiya kili Ngindrai.>> Pwen pe yihu hilingiy isomwi hu, pe lohongahu indrap iyatan. ");
INSERT INTO nss_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pwen hu Satyusiy hayah husa kili Yesu. Yihu Satyusiy ara, ngara hu kapa tehe ndramat kanmat ara kanlahiy para hu katine paiwe pwi. ");
INSERT INTO nss_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Pwen yihu pwai iya kili Yesu, hupa, <<Ndramat Para Hinonou, Mose kintatuluwi nongan sahin kinsa kili yorou toro: kapa ndramat hamou kimat pe nambuyun kihou pe norun pwi, pwen nalin andre kiwiri pihinau tan pe kipo mbunah kiya soiwi ngala nalin. ");
INSERT INTO nss_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hu ndramat manandrtimou hu nalihu huyen. Yiy ndrohan, ara iwiri pihin hamou iya nambuyun, pe norun pwi, pe imat. ");
INSERT INTO nss_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pwen parahara ndrohan iwiri pihinau ta nalin, hapeko imat pe norun pwi yi. Pe parahara hilu iho mulan tehen aliy yi. ");
INSERT INTO nss_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pwen tehen tora ko hu manandrtimou kene, ara huwiri pihin hamou opu, hapeko hu masih noruhu pwi pe humat topwei. Pe iyamulan masih pihin ara, ara imat i. ");
INSERT INTO nss_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pwen kiro mwonen lang para hu ndramat kasa tine paiwe, pe hu masih kasa tine, pwen pihin ara andre kirayah nambuyu hiyeh ndrokonan? Animei! Yiy nambuyu hu manandrtimou kene!>> ");
INSERT INTO nss_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pwen Yesu ipwai imui iya kili hu, ipa, <<Akanimei, wawu kanpwotisi nongan, paratesah, wawu kanpahasani hu Nongna Ngindrai pe pwoke ta Ngindrai pwi. ");
INSERT INTO nss_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pe kamulan hu ndramat masih kanmat andre hu kasa tine paiwe, yihu andre kanyesou pwi, pe andre hu kansokombut yesou pwi yi, hapeko andre hu koro ko tehe hu angelou tora kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Hapeko iya lohonge para kamat pe katine, wawu kannime nongan mepo Mose kinratuluwiy pwi, ndre? Akalohongani titiye para kei hakou mwan iyat aliy, ara Ngindrai ipwai iya kili Mose, ipa, <Yo urupo Ngindrai ta Apraham, pe urupo Ngindrai ta Yisak, pe urupo Ngindrai ta Yakop.> ");
INSERT INTO nss_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Akanimei! Yiy ara Ngindrai tahu ndramat mepo hu kanmat, ara pwi. Hapeko yiy ara Ngindrai tahu ndramat hutopo mwalen, tehe Apraham, Yisak pe Yakop. Wawu kanpwotisi nongan.>> ");
INSERT INTO nss_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pwen ndramat hamou para hinuwani nongan para pwahanou isa kili hu, pe ihilingi hu Satyusiy huro takekei mwalingahu. Ihilingi Yesu isomwi hu hiyan masih, pwen pe isike Yesu, ipa, <<Sehe nongan para pwahanou ihohin masih iya nongna Ngindrai masih?>> ");
INSERT INTO nss_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Pe Yesu isomwiy, ipa, <<Andre karanuhuyani nongnan para pwahanou iye, <Wawu Yisrayel, akahilingiy! Yapan Ngindrai torou, yiy hamou opu, ara Yapan. ");
INSERT INTO nss_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pe ndriyam kimbuluhi Yapan Ngindrai atam kiyau ndriyam masih, mwoiwam masih, lohongam masih pe pwoke tam masih.> ");
INSERT INTO nss_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pe nongan para pwahanou luhin para aliy, ara iye, <Ndriyam kimbuluhi hiyeh para pakeh kili wou, tehe ndriyam ngara kimbuluhi wou mbukenam.> Nongan para pwahanou sahin namandran, ara kinho ramwaitini nongan para pwahanou malhin iye pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pwen ndramat para hinuwani nongan para pwahanou ipwai iya kili Yesu, ipa, <<Nongnam ara imwonen masih. Ngindrai ara yiy hamou opu, pe hamou tehe yiy pwi yi. ");
INSERT INTO nss_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pe tukambuluhi Ngindrai kiyau ndriyarou masih, lohongarou masih, pe pwoke torou masih; pe ndriyarou ngara kimbuluhi hu hiyeh para pakeh kiltou tehe ndriya worou ngara kimbuluhi worou mbukenarou—kapa tukaranuhuyani pwahanou malhin iye, ara iramwaitini yukyuk masih worou ngara katimwi hu, pe worou ngara katohun kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pwen Yesu inimei tehe lohonga ndramat ara, ara waison masih. Pwen isomwi yiy, ipa, <<Wou ara anto mwanan kili kolo King ta Ngindrai mepo ngara kiro mu kiya aliy, ara pwi.>> Pwen hu ndramat masih yihu hindrundru para kasike yiy kiya hu soksok. ");
INSERT INTO nss_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pwen Yesu iro hinuwani hu ndramat nondriya kowa yumwa totohun namandran. Pwen yiy ipwai, ipa, <<Tehen tapeh pe hu ndramat para hinuwani nongan para pwahanou hupa Kristus ara noru Tepit? ");
INSERT INTO nss_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mwoiwan Haiyan iyki lohongai iya kili Tepit pe yiy mbukenan ipwai, ipa, <Yapan ipwai iya kili Yapan to, ipa, <<Asampwan kapwen te nimo mot, kipoo kuiki hu hiyeh huhingasi wou, ara hu kaya pahandra ndrikam.>> > ");
INSERT INTO nss_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pwen pe kapa Tepit mbukenan kiyoh yiy <Yapan,> pwen tehen tapeh ilahiy kiya norun?>> Pe hu ndramat soyon iya huro ara, ara huhilingi yiy pe hupwes. Hu ndramat soyon iya huhilingi nongna Yesu pe hupwes. ");
INSERT INTO nss_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu iro hinuwani hu pe ipwai iya kili hu, ipa, <<Mara wawu kiro ta hu ndramat para hinuwani nongan para pwahanou. Yihu namiliy para hu kohorokai kiyapolo koyau niwen kiro koliuliu pwan, pe hunamiliy para hu ndramat karawulohani hu koro hu ndroho pehei. ");
INSERT INTO nss_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tehen aliy opu hu ngara kanamiliy para hu kampwan ndrohonoku mipwan hiyan nondriya hu yumwa mbulere, pe pwapwai hiyan hu ndramat ngara hu kahaiyaniy ita nondriya lang para yon. ");
INSERT INTO nss_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wawu ngara kapakaiwani hu menmena hu pihinau topwei. Pe ngara wawu kawaiyani totohun kiro mbulmara hu ndramat. Pwen pe wawu andre kawiri koran namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pwen Yesu iya pe impwan nondriya yumwa totohun namandran pakeh kokou para sombule pat, pe iro nime hu ndramat huro yuk sombule pat iya nondriyan. Pe hu ndramat soyon menmena hu soyon iya, ara huro yuk singayai soyon iya nondriya kokou. ");
INSERT INTO nss_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pwen pihinau hamou menmenan pwi masih, ara isa pe iwiri sombule pat malmbut mbuskau, irayah tehe sombule pat hambut, pe iyaikiy iya nondriya kokou. ");
INSERT INTO nss_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pwen Yesu iyoh ndramiran hu husa kili yiy pe ipwai iya kili hu, ipa, <<Yo upwai ndrokonan isa kili wawu, tehe pihinau menmenan pwi ara, ara iyki sombule pat iya nondriya kokou ara, ara iho hin iya, iya kili hu ndramat masih. ");
INSERT INTO nss_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hu ndramat masih, ara huiki tahape-tahape iyau menmena hu soyon pe husaikiy tehe yukyuk. Hapeko pihinau aro, konan menmenan pwi masih, sohoyan hape imin, ara iykiy topwei.>> ");
INSERT INTO nss_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iro mwonen Yesu itali yumwa totohun namandran pe isa mawen, ndramiran hamou ipwai iya kili yiy, ipa, <<Ndramat Para Hinonou! Animei! Hu pat namandra-namandran iya! Pe hu wum nonowan iya!>> ");
INSERT INTO nss_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pwen Yesu isomwi yiy, ipa toro: <<Anime hu seu namandran masih, ndre? Andre hu ndramat hayah hu kasa, pe hu kataluwe hu pat namandran ara, pe andre pat sih andre kinye ndron ndrita sih pwi; andre hu katipiyaniy masih kiya pwan, pe kamasumbuwe topwei.>> ");
INSERT INTO nss_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pwen Yesu iyampwan iya Ngondron para hu Holip, pe maran iya haroh pe inime yumwa totohun namandran. Pwen pe Pita, Yamis, Yohanes, pe Antruw, ara huya kili yiy nokulaniy, pe husok yiy nokule ko, hupa: ");
INSERT INTO nss_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Apwai kisa kili yowu, sehe lang ndrokonan andre hu memelit masih mepo anpwai ara andre karayah? Pe sehe kaipisa melit ndrokonan andre kisa kimu, pe kipwainganiy tehe hu melit ara, ara pakeh hu nakarayah?>> ");
INSERT INTO nss_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pwen Yesu ipwai iya kili hu, ipa, <<Mara wawu kiro, matisan ndramat hamou kipakarawani wawu. ");
INSERT INTO nss_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hu ndramat soyon andre hu kasa kiya ngolo, pe hu kapa <Yo ko ara ndramat ara.> Pe andre hu kapakarawani hu ndramat soyon. ");
INSERT INTO nss_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pe kapa kamulan wawu kahalong nola hu pahun, pe hu nguluwa pahun koropo kasa, nere wawu mbuna kihilim. Hu melit tehen tora andre hu karayah, hapeko lenge kol pwan nakiyahapwen, ara mapu. ");
INSERT INTO nss_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hu ndramira kol namandran masih hayah, andre kapo pahun kiya kili hu ndramira kol namandran masih hayah i; pe kolo king mepo ngara kiro mu kiya aliy para kol hakol andre kipo pahun kiya kili kolo king mepo ngara kiro mu kiya aliy para kol hakol i. Pe hu nunuw andre karayah kili hu kol hayah, pe hu mundruwai namandran andre karayah i. Hu melit masih aro, ara andre karayah kimu, tehe pihin hamou ihingotou para nakimwalahiy. ");
INSERT INTO nss_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kiro nondriya lang ara, ara akoro hinehes. Andre hu karatuni wawu pe hu kaiki wawu kaya nongan koro mbulmara hu pohon para kol. Pe andre hu kamwiriyani wawu kiro yumwa mbultere tahu Yuta , pe hu kaiki wawu kiya mbulmara hu pohon para hu kol namandran iya, pe hu king, paratesah, wawu pwotisingi yo. Pe tunan yo ko, pwen andre wawu katiyani tiyeyo kiya kili hu. ");
INSERT INTO nss_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pe nongan hiyan ta Ngindrai, ara andre hu kapohowei pe kisilihi kol pwan masih namu. ");
INSERT INTO nss_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kapa hu kambultuwe wawu pe kawiri wawu kiya nongan, lohonga wawu mbuna kimwa kiya sehe nongan para wawu nakapwai. Kirahihini lang ara imwonen, sehe nongan Ngindrai kiykiy kisa kili wawu, ara wawu kapohowei. Paratesah, nongan wawu nakapwai, ara nongna wawu pwi, hapeko Mwoiwan Haiyan andre kiyki nongan kisa kili wawu para akapwai. ");
INSERT INTO nss_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pe hilu ndramat malmou hilu nali hilu, ara andre hamou kiratuni hamou para hu ndramat katingundrun kimat. Pe tama mbunah, ara andre kimbusiy tehen aliy kiya kili norun i. Hu mbunah andre hu karasisingat ana tamahu pe tinahu, para hu ndramat katingundru hilu kamat. ");
INSERT INTO nss_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pe tunan yo kopu, pwen andre hu ndramat masih kahangasi wawu. Hapeko sehe ndramat kiro tine pwokeyan, kipoo lang kiya pwomwiriy, ara andre Ngindrai kisopwat yiy. ");
INSERT INTO nss_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pe kiro lang ara ko, melit pwalan masih mepo andre kipwalngani yumwa totohun namandran, ara andre kisa pe kiro tine hapeleheh mepo nonombun para kiro aliy (hiyeh kinime nongan ara, ara lohongan kileu). Pwen pe wawu para kol namandran hape Yutiya ara wawu kawop kaya hu ngondron. ");
INSERT INTO nss_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pe sehe ndramat mepo kiro payandroha seu, ara mbuna kilai kiya pwan pe kisong kiya nondriya seu para kiya wiri melit kiya ngawan. ");
INSERT INTO nss_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pe sehe ndramat mepo kiro pingen lang ara, ara mbuna kimui para kiyapo koiwen. ");
INSERT INTO nss_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Toimwa hu pihin mepo mapundriyahu, pe hu hiyeh huhusuwe noruhu malaman, ara andre hu kaiki koisariy kiho nondriyahu lang ara. ");
INSERT INTO nss_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Akatohun tehe melit masih ara mbuna kisarayah kiro mwonen lenge nowou. ");
INSERT INTO nss_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nondriya lang ara, nopwaran namandran iya andre kirayah. Pe nopwaran ara, ara andre kinhisoule tehe hu nopwaran masih mepo kantayah pwen—iro ndroiyi lang Ngindrai imangsani melit masih kene isarayah, isa manne mahapo—ara pwi. Pe nopwaran tehen tora andre kintayah paiwe pwi yi. ");
INSERT INTO nss_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kapa Yapan kinsondriti hu lang para hu nopwaran ara kinna mulai pwi, ara andre kinlahi hamou ndramat kiyen pwi. Hapeko ilohongani hu mepo kinpirani hu pe kintakinimahu pwen, pwen pe imbusi nowen ara iya mulai. ");
INSERT INTO nss_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pe kiro mwonen lang ara, kapa ndramat hamou kipwai kisa kili wawu, kipa, <Akanimei! Iye ara Kristus,> ndre <Akanimei! Yoro, ara Kristus,> pwen lohonga wawu mbuna kipwotisingi nongnan. ");
INSERT INTO nss_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Paratesah, hu Kristus pwasoyou, pe hu poropet pwasoyou, ara andre hu karayah; pe andre hu kambusi hu kaipisa pwoke pe ndraikiya pwoke tahu, para hu kapakarawani hu mepo Ngindrai kintakinimahu—kapa ilahiy para hu kambusiy tehen aliy. ");
INSERT INTO nss_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pwen pe mara wawu koro hinehes. Yo kunpwai mamu kinsa kili wawu, tehe melit masih ara, andre kasarayah kamulan. ");
INSERT INTO nss_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kiyamulan para nopwaran namandran ara, <mwandrai andre kilokuh, ");
INSERT INTO nss_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","pe walah andre kiniyki nganan pwi, pe hu piriy andre kayos kayau yang kasa pwan, pe hu pwoke para yang, ara andre hu kamemeyeu.> ");
INSERT INTO nss_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pwen kiro mwonen lang ara, hu ndramat andre kanime Noru Ndramat kituh komkom kisa kol pwan, kiyapolo pwoke pe nonowa nganan namandran. ");
INSERT INTO nss_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pwen andre Ngindrai kipwandrisa hu angelou tan hu kaya, pe andre hu karawurani hu mepo kintakinimahu atan, hu kayau hu mbusungo kol pwan mahaasai, kiro haroh para kol pwan kiyandrek kiya haroh para kol paingan. ");
INSERT INTO nss_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Akapo lohongai kiyau nongan pwandritiye para kei pik toro: Kiro mwonen hu ndrandran kituhuruh pe kiyki kaimbuwehu, ara akapahasaniy, tehe lang para mwandrai nakising, ara kinsa pakeh. ");
INSERT INTO nss_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tehen tora ko, kapa akanime hu melit aro koro tayah, ara akapahasaniy tehe Noru Ndramat, ara kinsa pakeh, pe ita poho karam. ");
INSERT INTO nss_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Upwai ndrokonan isa kili wawu, hu ndraye hasap para mahapo aro, ara andre hu masih kanmat pwi, kipoo hu melit masih aro karayah topwei. ");
INSERT INTO nss_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kol paingan yang pe kol pwan, ara andre kihipwen, hapeko hu nongno, ara andre kanhipwen pwi. ");
INSERT INTO nss_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hapeko ndramat hamou kinpahasani sehe lang ndre sehe paramwandrai hu melit aro kene nakarayah, ara pwi. Pe Norun pe hu angelou hutora kol paingan yang, ara hukowu yi. Taman hamou opu, ara ipahasaniy. ");
INSERT INTO nss_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mara wawu kiro, pe akoro hinehes, paratesah, wawu kowu sehe lang hu melit aro andre karayah. ");
INSERT INTO nss_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lohongai iye ara pakirayah tehe ndramat hamou pakitali suwen, pe kiyau kiya mwanan. Pe kiyki hu ndramat para poya mbulyan, ara para mara hu koro meltan. Pe kitaingani mbulen kiya kili hu hamou-hamou tahu, pe kipwandrandrahani hiyeh mepo kiro pohokaram para yiy kiro hinehes. ");
INSERT INTO nss_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pwen tehen tora ko mara wawu kiro, paratesah, sehe lang ndrokonan mbukena seu nakisa kaliy, ara wawu kowu. Andre kisa kipiyah, ndre ndrokolo ping, ndre tutut kirang, ndre ndroulang—ara tana wawu pwi. ");
INSERT INTO nss_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Matisan kisa kileh pe kinimei tehe wawu tora matin manau. ");
INSERT INTO nss_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sehe nongan kunpwai kinsa kili wawu iye, ara ngara kutiyaniy tehen tora ko kiya kili hu ndramat masih: <Wawu koro hinehes!> >> ");
INSERT INTO nss_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lang malwoh iho ndron para kirahihini mbultere tahu Yisrayel para Pasopa, kiyapolo lang para hu kalohongani Yon Para Ndrinanohun Mepo Yis Aliy Pwi. Pe hu pris huhohin ta hu pris masih pe hu ndramat para hinuwani nongan para pwahanou, ara huramburi nongan para hu kakorip kokohe para kambultuwe Yesu pe katingundrun kimat. ");
INSERT INTO nss_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hapeko hupa, <<Hapeko worou mbuna kambusiy kiro nondriya Yon, paratesah, kapa tukambusiy, matisan hu ndramat karambumbuwat.>> ");
INSERT INTO nss_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pwen Yesu iro kol Petaniy, iro nondriya seu ta ndramat hamou mepo ngara hu kapohowe ngalan, Simon ndramat para Mwamwa Kawa. Pwen huroh huye ngilse keyau, pe pihin hamou isa isap pwisi ndraikei sih, ndraikei mangonohon layin iro nondriyan mepo kennen ara namandran iya. Ndraikei ara, ara hupohowei nart. Pwen itumbuwe mara pwisi ndraikei ara, pe itilingi ndraikei iya paya Yesu. ");
INSERT INTO nss_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pe hu ndramat hayah huro ara, hunimei pe ndrinahu ilokuh. Pe huro panguluwaniy mwalingahu, huro pa, <<Paratesah pe itilingi ndraikei mangonohon layin ara mwaihei opu? ");
INSERT INTO nss_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kapa yiy kinpwalngani ndraikei mangonohon layin ara pwi, pwen hiyan para tukawiriy kiya pehei, pe andre yihu kasowaniy kiya sombule silwa matingat (300). Pwen singayai ara, ara iya hiyan para tukatainganiy kiyata hu ndramat mepo hundroisiy.>> Pwen pe hupomate pihin ara iya mwomwan. ");
INSERT INTO nss_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hapeko Yesu ipwai iya kili hu, ipa, <<Akatali yiy kiro. Paratapeh pe wawu tora wong anan? Yiy ara imbusi kultuw hiyan isa kili yo. ");
INSERT INTO nss_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yihu ndramat mepo hundroisiy, ara andre hu koro polo wawu lang masih. Pe ita weleso ta wawu ko, sehe lang apakasopwat hu, akasopwat. Hapeko yo, ara andre kunto polo wawu waiye pwi. ");
INSERT INTO nss_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pihin ara imbusi sehe melit ilahiy para kimbusiy. Yiy itilingi ndraikei mangonohon ara, isa mondro para kimwaniyani yo para toniyo. ");
INSERT INTO nss_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yo upwai ndrokonan isa kili wawu, hape aleheh nondriya kol pwan masih mepo hu kaya pe hu kapohowe nongan hiyan aro kiya aliy, pwen tesah pihin aro kinmbusiy, ara andre hu katiyani tiyeyan, pe kalohongani yiy.>> ");
INSERT INTO nss_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pwen Yutas Yiskariyot, yiy hamou tahu Songui pe Lumou ara, ara iya kili hu pris huhohin ta hu pris masih, pe iya mburi lohongai para yiy kiratuni Yesu kiya nimahu. ");
INSERT INTO nss_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pe huhilingi nongna Yutas pe hupwes namandran iya; pe hurandrangan para hu kasowani yiy kiya singayai. Pwen yiy ara iro ten sehe sai hiyan, para kiratuni Yesu kiya nimahu. ");
INSERT INTO nss_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pwen lang sih imu iya lenge Yon Para Ndrinanohun Mepo Yis Aliy Pwi, ara irayah. Lang ara ngara hu katingundru noru sipsip para Pasopa. Pwen hu ndramira Yesu husike yiy, hupa, <<Hape aleheh welem iso para yowu kaya karamwaniyani anandrinai para aya pe ayan Pasopa kaliy?>> ");
INSERT INTO nss_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pwen ipwandrisa hilu ndramiran malmou, pe ipa, <<Walu kaya nondriya kol namandran pe ndramat hamou mepo ikuni kohoyonga ndran, ara andre kipohonani walu; pwen walu koho ndruwan. ");
INSERT INTO nss_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pwen sehe seu ndramat ara nakisong kaliy, pwen walu kasok ndramira seu ara, alkapa, <Ndramat Para Hinonou ipwai, ipa, <<Ndrohonoku mbultere, ara ita hape aleheh, mepo andre kunamnam kiyapolo ndramiro hu, kiro mwonen Lang para Pasopa?>> > ");
INSERT INTO nss_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pwen yiy andre kiyingani nondriya seu sahin, hongan namandran, hira nondriya seu paingan. Hu kanmwaniyani melit masih tehe keyau pe pwapwai pwen ita mwoimwoi. Pwen alkamwaniyani menmena Pasopa kiro ariya.>> ");
INSERT INTO nss_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pwen hilu ndramiran hilya nondriya kol namandran pe hilu nime memelit masih ara kinmwonen tehe Yesu kinpwai. Pwen pe hilu mwaniyani hu melit para Pasopa. ");
INSERT INTO nss_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pwen kol ipiyah, Yesu iyapolo hu Songui pe Lumou huya seu ara. ");
INSERT INTO nss_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pwen huya pe huyeroh ngilse keyau pe humi namnam, pe Yesu ipwai iya kili hu, ipa, <<Upwai ndrokonan isa kili wawu, tehe hamou tawawu, mepo impo namnam sura yo mahapo, ara andre kiratuni yo kiya nima hu ndramat para hingasi yo.>> ");
INSERT INTO nss_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ndramiran hu ara huhilingi nongan aro pe ndriyahu ara ipworu. Pe hamou-hamou tahu husok yiy, hupa, <<Andre yo, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pwen pe ipa, <<Yiy ara hamou tawawu Songui pe Lumou mepo iripo taimani ndrinanohun iya nondriya pwelekei sura yo. ");
INSERT INTO nss_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Noru Ndramat, ara andre kiyau ndruwa nongan tehe pwayan kinpwai pe kintiyani tiyeyan. Hapeko toimwa sehe ndramat mepo andre kiratuni Noru Ndramat! Iya hiyan masih iyata ndramat ara, kapa tinan kinmwalahiy kinna tan pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iro mwonen huro namnam, pe Yesu iwiri ndrinanohun, itoholiy pe iramburingiy. Pwen iykiy iya kili hu, pe ipwai, ipa, <<Akawiriy; iye ara nombuwe.>> ");
INSERT INTO nss_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pwen iwiri pweniu wain sih, pe irawuloh iya kili Ngindrai, pe iykiy iya kili hu. Pe hu masih ara huyin yaliy. ");
INSERT INTO nss_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pwen Yesu ipwai iya kili hu, ipa, <<Iye ara ndreye para tapaniu, mepo utilingiy para kisopwat hu ndramat soyon. ");
INSERT INTO nss_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Upwai ndrokonan isa kili wawu, yo andre kunyin ndrunu mbuwa wain aro paiwe pwi, kipoo kiya lang para kuyin kiya nimnim howen kiro mwonen yo kuya nondriya kolo king ta Ngindrai mepo ngara kiro mu kiya aliy.>> ");
INSERT INTO nss_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pe hupowaliy sahin ihipwen, pwen huyau huya Ngondron para hu Holip. ");
INSERT INTO nss_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pe Yesu ipwai iya kili hu, ipa, <<Wawu masih andre katali yo topwei. Pwayan hu kantatuluwiy, ara ipa toro: <Andre kutingundru ndramat para pwokereya hu sipsip, pe andre hu sipsip, ara hu kamasumbuwe topwei.> ");
INSERT INTO nss_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Hapeko kamulan kutine, ara andre kuro mu kili wawu kuya Kaliliy.>> ");
INSERT INTO nss_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pwen Pita ipwai iya kili yiy, ipa, <<Konan, kapa hu masih kunhindrundru, hapeko yo, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pwen Yesu ipwai iya kili yiy, ipa, <<Upwai ndrokonan isa kili wou, tehe nepo kiping, pe tutut kintang maporolusap mapu, andre apwai maporotisap tehe akowu to.>> ");
INSERT INTO nss_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hapeko Pita irakekei pwokeyan, ipa, <<Konan kapa kumat kiyasura wou, hapeko andre kunpwai tehe ukowu tam, ara pwi yoh!>> Pwen hu ndramira Yesu masih, ara hupwai iyawule tehen aliy. ");
INSERT INTO nss_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pwen huya pinge holip hape mepo ngalan Ketsemani. Pe Yesu ipwai iya kili ndramiran hu, ipa, <<Akamin iye, pe yo nakuya tohun.>> ");
INSERT INTO nss_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pwen iwiri Pita, Yamis, pe Yohanes huya sura yiy. Pwen ihingorowe nopwaran mwomwan namandran iya, pe ndriyan, ara iroporu. ");
INSERT INTO nss_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Pwen Yesu ipwai iya kili hu, ipa, <<Ndriyo ara iporu namandran iya pakeh tehe pakumat. Akoro iye, pe mara wawu kiro.>> ");
INSERT INTO nss_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pwen iya hangoh hapeko mendreheh, pe ihikuwani ngundrun pe itukuruhu iya ndrita pwan. Iro tohun pe isikei kapa hape meresai kihou para kihindrisani lang para nopwaran ara. ");
INSERT INTO nss_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pe iro tohun, ipa, <<O, Tomo! Alahiy para ambusi melit masih. Pwen pe awiri pweniu iripo kili yo aro kiya mawen. Hapeko mbuna kirayah kiya namiliwo pwokeyan; pwi yoh. Kirayah namiliwam pwokeyan.>> ");
INSERT INTO nss_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pwen imui iya kili ndramiran hu matimou pe inime hu huro matin. Pwen ipwai iya kili Pita, ipa, <<Simon, wawu tora matin, ndre? Wawu lahiy para koro poyoi kiho nondriya paramwandrai sih o? ");
INSERT INTO nss_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mara wawu kiro pe akatohun, pwen pe andre wawu kanyos kanna nondriya nohonou pwi. Weleso ita mwoiwa wawu, hapeko nombuwe wawu ara imbuyei.>> ");
INSERT INTO nss_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pwen iya mawen paiwe, pe iya tohun. Pe iro ndruwa totohun tan para mamu ko. ");
INSERT INTO nss_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pwen imui isa, pe inime hu kanmatin paiwe yi, paratesah, marahu, ara imwanunun. Pe hu kanpahasani sehe nongan para hu kapwai kiya kili yiy pwi. ");
INSERT INTO nss_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pwen imui porotoyoh, pe ipwai iya kili hu, ipa, <<Wawu tora matin manau, pe tora ngoh, ndre? Hiyan; pwen ara. Lengen kinsarayah. Akanimei, Noru Ndramat, ara yihu nakaratuni yiy kiya nimahu ndramat pakut tahu mwomwan. ");
INSERT INTO nss_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Akatine, tukayau! Akanimei! Ndramat nakiratuni yo, ara kinsa!>> ");
INSERT INTO nss_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu iro wong manau o, indrou pwi ko Yutas, hamou tahu Songui pe Lumou, ara isarayah. Yiy iyapolo hu ndramat soyon iya husa iyasura hu semela pahun niwen pe hu parakei. Hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, pe hu yapane kol ara hupwandrisa hu. ");
INSERT INTO nss_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pe ndramat mepo nakiratuni yiy, ara kinpomwanye kinna kili hu kinna kaipisa melit handra toro: <<Ndramat mepo nakurahunghung kiya kili yiy, ara yiy ara kopu; akambultuwe tahatini yiy; mara wawu kiro tan, pe akaluwani yiy kiya.>> ");
INSERT INTO nss_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Indrou pwi ko, Yutas isarayah pe iya mwonen iya kili Yesu, pe ipwai, ipa, <<Ndramat Para Hinonou.>> Pwen irahunghung iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pwen hupwahatini yiy, pe humbultuwe tahatini yiy. ");
INSERT INTO nss_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pwen humbultuwe tahatini Yesu, pe hamou iro tine ngilsen ara iwiri semela pahun niwen, pe isondriti ndrainga ndramat hamou para pwandrendres ta pris ihohin ta hu pris masih kene, ara imut. ");
INSERT INTO nss_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pwen Yesu isomwi hu pe ipwai iya kili hu, ipa, <<Yo ngara kuya mu kili hu ndramat para kangas marapahun, pwen pe wawu sa iyapolo hu semela pahun niwen, pe hu parakei para kasa mbultuwe yo, ndre? ");
INSERT INTO nss_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lang masih ngara kuro sura wawu pe ngara kuhunuwani wawu kuro nondriya kalsuwa yumwa totohun namandran, hapeko wawu kansa mbultuwe tahatini yo pwi. Hapeko pwayan kinpwai ita nongna Ngindrai, ara andre kirayah mannan.>> ");
INSERT INTO nss_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pwen o, hu ndramira Yesu masih, ara hutali yiy pe huwop topwei. ");
INSERT INTO nss_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Iro mwonen lang ara, wihou hamou iye ndruwa Yesu, ara isumwa yiy iya koyau hamou pallen. Hu makundrayin humbultuwe yiy, ");
INSERT INTO nss_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hapeko itali koyau tan, pe iwop mwaheh o iyau. ");
INSERT INTO nss_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pwen huluwani Yesu iya seu kili pris ihohin ta hu pris masih kene. Pe hu pris huhohin ta hu pris masih, hu yapane kol, pe hu ndramat para hinuwani nongan para pwahanou ara hu masih kansa rawurehu pwen huro aliy. ");
INSERT INTO nss_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pwen pe Pita iho ndruwa Yesu, hapeko iho ndron mwanan hape. Pe irikai ipoo iya nondriya kou para kalsuwa pris ihohin ta hu pris masih kene. Pwen irompwan sura hu makundrayin pe iro ling mwan. ");
INSERT INTO nss_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pe hu pris huhohin ta hu pris masih, iyasura hu Sanhetrin masih tahu Yutah, ara huten hu ndramat hayah para hu katiyani kultuw mwomwan ta Yesu para kipwokeyani lohongai para hu katingundru Yesu kimat. Hapeko hukah ndrit. ");
INSERT INTO nss_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pe hitun tahu, ara hurasusut nongan; hapeko titiye tahu, ara kinna wule handra ko pwi. ");
INSERT INTO nss_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pe hayah tahu, ara hurasusut nongan pwasoyou para kapwasimiri yiy kaliy. Pe hupwai, hupa toro: ");
INSERT INTO nss_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Yowu hilingi yiy ipwai, ipa, <Andre kutumbuwe yumwa totohun namandran mepo hu ndramat hu kanpwiliy iya nimahu; pwen, nondriya lang maroyoh o, andre kupuli hawum paiwe, hapeko andre kunpuliy kinna nimo pwi.> >> ");
INSERT INTO nss_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hapeko nondriya titiye tahu aro imasumbuwe pe kinna wule handra ko pwi. ");
INSERT INTO nss_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pwen pris ihohin ara itine iro mbulmarahu pe isok Yesu, ipa, <<Wou andre asomwiy, ndre pwi? Aripo sehe titiye mepo hu ndramat aro topo ratuni wou iya aliy?>> ");
INSERT INTO nss_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hapeko Yesu ihun o iro, pe kinsomwi hu kinna nongan sahin pwi. Pwen pris ihohin ta hu pris masih kene isok yiy paiwe, ipa, <<Wou ara Kristus, Noru Ngindrai Kamai Haiyan, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Pe Yesu isomwi yiy, ipa, <<Yo ara; yo kopu. Pwen kamulan andre wawu kanime Noru Ndramat kimpwan kiyapwen te nima Ngindrai mot, mepo yiy Pwokeyan Masih. Pe andre akanime yiy kisa kiyapolo kokom para yang.>> ");
INSERT INTO nss_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pwen pris ihohin ta hu pris masih kene ara, indrohomwiri koiwen, pe ipwai, ipa, <<Paratesah, andre tukaten hu ndramat para kapwokeyani nongan i? ");
INSERT INTO nss_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wawu kanhilingiy tehe yiy kinpwasisiman ana Ngindrai. Pwen wawu lohonganiy tapeh?>> Pwen hu masih hupwai tisingiy tehe Yesu irakultuw mwomwan, pwen pe andre katingundrun kimat. ");
INSERT INTO nss_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pwen hu hayah tahu, ara husokombunuhi yiy. Pe husumwa maran iya koyau pe huhukuwani mbutimahu, pe huro rayi yiy, pe hupwai iya kili yiy, hupa, <<Kapa wou poropet hamou, pwen apwai!>> Pwen hu makundrayin hayah ara huwiri yiy pe huhusili yiy. ");
INSERT INTO nss_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita iro ndron nondriya kou, pe pihin hamou para poya mbulen ta pris ihohin ta hu pris masih kene, ara irikai isa ");
INSERT INTO nss_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pwen maran iya pe inime Pita iro ling mwan. Pe ituluwani yiy pe ipwai iya kili yiy, ipa, <<Wou ara, aro sura Yesu para Nasaret i.>> ");
INSERT INTO nss_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hapeko Pita ipwasarahani nongnan, ipa, <<Yo ukowu pe kunpahasani sehe nongan ata wong iya aliy, ara pwi.>> Pwen iyau iya poho mara karam para kou. ");
INSERT INTO nss_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pwen pihin para pwandrendres ara, inime yiy paiwe, pe ipwai iya kili hu hiyeh huro tine ngilsen, ipa, <<Yiy ita, ara hamou tahu.>> ");
INSERT INTO nss_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hapeko ipa pwi paiwe yi. Iyamulan hape, yihu hiyeh huro tine ngilsen hupwai iya kili Pita, hupa, <<Ndrokonan, wou ara hamou tahu yi, paratesah, wou ara ndramira Kaliliy.>> ");
INSERT INTO nss_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pwen Pita iten anan pe irandrangan iya kili hu, ipa, <<Upwai ndrokonan, ndramat mepo wawu tora wong anan, ara ukowu tan. Urandrangan tehe kapa kupwasoyou pwen Ngindrai andre kiten ano.>> ");
INSERT INTO nss_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pwen indrou pwi pe tutut irang paiwe, pe Pita ilohongani nongna Yesu kinpwai mamu kinna tan, ipa, <<Tutut kintang maporolusap mapu, andre apwai maporotisap tehe akowu to.>> Pwen Pita ilohonganiy pe irang turuwe yiy. ");
INSERT INTO nss_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pwen, makohuping sahin opu, hu pris huhohin ta hu pris masih pe hu yapane kol, pe hu ndramat para hinuwani nongan para pwahanou, pe hu Sanhetrin masih, huya mbultere hu para hu karawurani lohongahu. Pwen huwasi Yesu, pe huluwi yiy iya mawen pe huyaiki yiy iya nima ndramat para tamwanye ngalan Pailat. ");
INSERT INTO nss_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pe Pailat isok Yesu, ipa, <<Wou king tahu Yutah, ndre?>> Pe Yesu isomwiy, ipa, <<Tehe anpwai ara.>> ");
INSERT INTO nss_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pe hu pris huhohin ta hu pris masih hurasusut nongan soyon iya kili Yesu. ");
INSERT INTO nss_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pwen Pailat isok yiy porosih i, ipa, <<Wou andre asomwi nongan sahin, ndre pwi? Anime hurasusut nongan soyon mwomwan isa ndritam!>> ");
INSERT INTO nss_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hapeko Yesu kinsomwi nongan sahin pwi, pe Pailat ilohonge soyon. ");
INSERT INTO nss_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pwen irahihini lang para Yon para Pasopa, hayou sih tehe sih, Pailat ngara kitali ndramat hamou kiro kou kisa ngawan. Kapa hu ndramat masih kapohowe ngala sehe ndramat hunamiliy ita nondriya kou, pwen yiy ara ko, ara andre Pailat kitali yiy kisa ngawan. ");
INSERT INTO nss_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Koluw hu kaniyki hu ndramat hayah kanna nondriya kou. Hu ndramat ara hutandroindroi pe hupo pahun iyasura hu yapane kol, pe hutingundru hu ndramat hayah humat. Pe ndramat hamou ngalan Parappas, ara yiy hamou tahu yi. ");
INSERT INTO nss_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pwen hu ndramat hayah husarayah husa kili Pailat, pe husike yiy para kimbusiy sehe lohongai ngara kimbusiy hayou sih tehe sih kiya kili hu. ");
INSERT INTO nss_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hapeko Pailat isomwi hu, pe ipa, <<Wawu namiliy para kutali King ta wawu Yutah kisa kili wawu?>> ");
INSERT INTO nss_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat ipahasaniy tehe hu pris huhohin ta hu pris masih, ara huiki Yesu iya niman, paratesah, huhingasi yiy. ");
INSERT INTO nss_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hapeko hu pris huhohin ta hu pris masih, ara husuhuri hu ndramat huro wule para hu kasok Pailat tehe mbuna kitali Yesu, hapeko kitali Parappas kisa ngawan kili hu. ");
INSERT INTO nss_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat isok hu paiwe, ipa, <<Pwen pe wawu namili yo para kumbusi tesah kata ndramat ita, mepo wawu pohowe yiy King tahu Yutah?>> ");
INSERT INTO nss_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pe hupalngai anan, hupa, <<Karapaingi yiy kiya kei tondrih!>> ");
INSERT INTO nss_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hapeko Pailat iro pwai iya kili hu, ipa, <<Paratesah? Yiy imbusi sehe kultuw mwomwan?>> Hapeko hupalngai namandran iya, hupa, <<Karapaingi yiy kiya kei tondrih!>> ");
INSERT INTO nss_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pwen pe Pailat irambumbuni hu para hu kapwes. Pwen itali Parappas iya ngawan kili hu, pe ipwai para hu ndram kamwiriyani Yesu, pe iyki yiy iya nimahu para hu karapaingi yiy kiya kei tondrih. ");
INSERT INTO nss_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pwen hu ndram para pahun huluwi yiy iya ngawan, pe huwiri Yesu iya nondriya kou para suwe kapman. Pwen huyoh hu ndram para pahun masih husa wule. ");
INSERT INTO nss_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pwen huwiri koyau anandritan hasai, pe husuluye Yesu iya aliy. Pe huwiri hu malkei maporon pe hurakayaniy tehe kasapai, pe huikiy iya payan. ");
INSERT INTO nss_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pwen huro palngai anan pe hupwasimiri yiy, hupa, <<O yapane yowu, wou king tahu Yutah!>> ");
INSERT INTO nss_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pwen huti payan iya parah ken iho ken, pe husokombunuhi yiy. Pe hutumbuwe ngundruhu pe hutukuruhu iyatan. ");
INSERT INTO nss_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hupwasimiri yiy ihipwen, pwen hutali koyau anandritan ara, isa mawen kili yiy, pe husuluye yiy iya koiwen mbukenan. Pwen husuluye yiy paiwe iya koiwen imwonen, pe huluwani yiy iya ngawan para hu kaya rapaingi yiy kiya kei tondrih. ");
INSERT INTO nss_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Huropo huya pe hupohonani ndramat hamou ngalan Simon, ndramira Sairini. Yiy ara tama Aleksanter hilu Rupus. Yiy ipwen te kol ngawan iropo isa nakiya kol namandran. Pwen hu ndram para pahun ara hurakekeyani yiy para kikuni kei tondrih ta Yesu. ");
INSERT INTO nss_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pwen huwiri Yesu iya kol hakol ngalan Kolkota. Pe ndroiyi ngala kol ara, ara <<Ndroho Ndruwi Paya Ndramat.>> ");
INSERT INTO nss_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pe hu pakahang Yesu wain mepo husuluyaniy iyasura marasin para kiyin, hapeko kinimwiy pwi yoh. ");
INSERT INTO nss_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pwen hurapaingi yiy iya kei tondrih pe hutaingani koiwen tehe toro: hunonoyou satu para kipwaingani hiyeh tahu andre kiwiri menmenan. ");
INSERT INTO nss_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iho mandroulang, paramwandrai iro mandrosih, pwen hurapaingi yiy iya kei tondrih. ");
INSERT INTO nss_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pe huratuluwi koran iho ndrita payan, ara ipa toro, <<KING TAHU YUTAH.>> ");
INSERT INTO nss_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pe hurapaingi hilu ndramat malmou para pahana, ara hilya kei tondrih sura yiy. Huiki hamou iyapwen te niman mot pe hamou iyapwen te niman kamou. ");
INSERT INTO nss_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pwen nongan mepo Ngindrai kinpwai koluw kinna, kinsarayah ndrokonan, ara ipa toro: <<Hundromwa yiy iyapolo hu ndramat para tandroindroi.>> ");
INSERT INTO nss_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pe hu ndramat huropo husayau, ara hupwasimiri yiy pe hupatumbuye payahu iyatan, pe huro pa <<Weh! Wou mepo apa andre aloiwani yumwa totohun namandran, pe kiho nondriya lang maroyoh o, andre apuliy paiwe; ");
INSERT INTO nss_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kiya, asopwat wou mbukenam, pe asapwan kei tondrih.>> ");
INSERT INTO nss_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pwen tehen aliy i hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, ara huye pwasimiri yiy mwalingahu, hupa, <<Yiy kinsopwat hu hayah, hapeko kinlahiy para kisopwat yiy mbukenan pwi! ");
INSERT INTO nss_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kiya, ndramat para kisopwat hu ndramat hira, mepo ipa yiy King tahu Yisrayel, ara hiyan para mahapo ko kisapwan kei tondrih. Pwen andre yowu kanime yiy pe lohonga yowu kipwotisingi yiy.>> Pe hilu malmou mepo hu rapaingi hilu iya kei tondrih hilho polo yiy, ara hiluro ndringani yiy. ");
INSERT INTO nss_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pwen iho ndrokolo lang pe paramwandrai iro songui pe luwoh, ara kol pwan masih ilokuh topwei, ipoo iya piyahon pe paramwandrai iya iho tehe maroyoh. ");
INSERT INTO nss_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iho nondriya paramwandrai maroyoh, Yesu iwayeh pwokeyan iya, ipa toro: <<Eloyi, Eloyi, lama sapaktani?>> Ndroiyi nongna kolo hu, ara ipa toro: <<Ngindrai to, Ngindrai to, paratapeh antali yo?>> ");
INSERT INTO nss_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pe hayah tahu mepo huro tine ngilsen, ara huhilingiy pwen, hupa, <<Akahilingiy; ita yoh Eliyah, ndre?>> ");
INSERT INTO nss_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pwen hamou iro mwalingahu ingap iya, pe itaimani nanmam iya wain susuwen pe iwasiy iya kou sih, pe ihiriy iya kili Yesu para kiyin. Pwen pe ipwai, ipa, <<Kiro tahandren tora. Tukoro pe kanimei na, matisan Eliyah kisa pe kitali yiy kisa pwan.>> ");
INSERT INTO nss_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pwen Yesu iwayeh pwokeyan paiwe, pe ngohan ihipwen pe imat. ");
INSERT INTO nss_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iro mwonen paramwandrai ara, ndrihiyap namandran iho ndrungak nondriya yumwa totohun namandran, ara ilen iya maltoh. Ilen iho paingan pe isandrek isa pwan. ");
INSERT INTO nss_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pwen ndram mepo ihohin tahu ndram masangat mepo iro tine haroh ngilse Yesu, ara inime kaipisa kimat ta Yesu, pe ipa, <<Ndrokonan masih! Ndramat aro, ara Noru Ngindrai Kamai.>> ");
INSERT INTO nss_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pe hu pihin hayah ara, huro ndron mwanan hape pe huro nimnim. Mwalinga hu pihin ara, ara Mariya para Maktala, Mariya mepo tina Yamis mbuskau pe Yoses, pe iyasura Salome. ");
INSERT INTO nss_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hu pihin ara, ngara hu koho ndruwa Yesu, pe ngara hu kasopwat yiy ma iro ndron Kaliliy. Pe hu pihin soyon i, huro aliy ara, ara hu kantokai pwen huyapolo Yesu husa Yerusalem. ");
INSERT INTO nss_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pe kol iho piyah, pe ponokule para lang Sapat nakisarayah. ");
INSERT INTO nss_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Pwen Yosep para kol Arimateya isarayah. Yiy ara poh hamou hiyan tahu Yutah. Pe yiy ara hamou tahu hiyeh iro sohoni kolo king ta Ngindrai mepo ngara kiro mu kiya aliy mepo andre kisa. Pwen yiy ara ndriyan ipwokeyani yiy pe iya nime Pailat, pe isok yiy para kiwiri nombuwe Yesu. ");
INSERT INTO nss_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ara ilohonge soyon, pe ipa, <<Yesu, ara kinimat, ndre?>> Pwen iyoh iya kili pohon tahu ndram para pahun, pe isike yiy para kipahasaniy tehe Yesu kinimat ndre mapu. ");
INSERT INTO nss_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pwen ihilingi nongna pohon tahu ndram para pahun, pe isomwiy, pe ipa hiyan para nombuwe Yesu kiya kili Yosep. ");
INSERT INTO nss_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pwen Yosep isowani koyau hamou pallen, pe itali nombuwe Yesu isa pwan, pe isumwa nombuwen iya koyau ara. Pe iwiri nombuwen pe iyaikiy iya ngat sih mepo hu kansoyei iro pat sou. Pwen itiriyani pat sih isingori poho mara ngat ara. ");
INSERT INTO nss_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pe Mariya para Maktala pe Mariya tina Yoses, ara huro nime hapeleheh mepo huroni Yesu iya aliy. ");
INSERT INTO nss_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pwen lang para Sapat kinhipwen pe Mariya para Maktala, Mariya tina Yamis, pe Salome, huya sowani ndraikei pe melit hayah mangonohon layin, pe hu pakaya tumwiy kiya nombuwe Yesu. ");
INSERT INTO nss_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Makohuping o, para lang iho mu para sandre sih, hu pihin ara, huya ngat maparamwandrai iro sisiyaniy o. ");
INSERT INTO nss_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pwen huro wong mwalingahu, hupa, <<Hiyeh ndrokonan andre kitiriyani pat kiltou kiya mawen poho mara ngat?>> ");
INSERT INTO nss_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pwen huyarayah pe marahu pakitandras o, hunime pat ara, ara hu kantiriyaniy kinna mawen. Pe pat ara namandra-namandran iya. ");
INSERT INTO nss_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pe husong huya nondriya ngat, pe hunime wihou hamou, koiwen pallen pe niwen, ara imimpwan iyapwen te mot. Pwen pe hunoh turuwehu. ");
INSERT INTO nss_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hapeko wihou ara ipwai iya kili hu, ipa, <<Mbuna akanoh turuwe wawu. Yo upahasaniy tehe wawu tora ten Yesu, ndramira Nasaret, hiyeh hu kantapaingi yiy kinna kei tondrih. Yiy kinto iye pwi. Yiy kintine. Akanime nokun huiki yiy iyen aliy, ara iye. ");
INSERT INTO nss_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pwen wawu kaya mahapo ko, pe akayapwai kaya kili ndramiran hu, pe Pita i, tehe Yesu andre kiro mu kili wawu kiya Kaliliy. Pe wawu andre kaya nime yiy kaya aliy, tehe mamu kinpwai kinsa kili wawu.>> ");
INSERT INTO nss_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pwen husong ngat husa ngawan, pe huwop huya mawen. Paratesah, hulelen pe lohongahu indrap. Pe hu kannese ndrainga hamou pwi, paratesah, hunoh. ");
INSERT INTO nss_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu itine kimat makohuping o, iya lang sih imu para sandre sih. Pe yiy iyarayah imu kinna kili Mariya para Maktala mepo koluw kintapiyani payit manandrtimou iro ndritan iya mawen. ");
INSERT INTO nss_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pwen Mariya para Maktala ara, iya pe inese ndrainga hu mepo hu ngara koro sura Yesu, iro mwonen huro nondriya yumwa merei pe huro rang. ");
INSERT INTO nss_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Iro mwonen ara, huhulong kili Mariya tehe Yesu kintine, pe kinnime yiy pwen. Hapeko ndriyahu kanpwotisingi nongnan pwi. ");
INSERT INTO nss_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pe iyamulan hape, yiy ipiy pe iyarayah iya kili hilu ndramiran malmou hilu ro tokai nakatali kol namandran kaya ngawan. ");
INSERT INTO nss_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pwen hilya pe hilnese ndrainga hu ndramira Yesu masih, hapeko ndriyahu kanpwotisingi nongna hilu pwi yi. ");
INSERT INTO nss_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iyamulan para aliy, Yesu iyarayah iya kili ndramiran hu songui pe hamou hurompwan hurakayani keyau para namnam. Pwen ipomate hu, paratesah, hu kanpwotisingi lohongahu pwi, pe payahu ara pwokeyan iya. Ipwai tehen toro, paratesah, ndriyahu kanpwotisingi nongnahu pwi, mepo hiyeh hunime yiy imu pe husa nese iya kili hu tehe kintine. ");
INSERT INTO nss_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pwen ipwai iya kili hu, ipa, <<Akaya kene kol pwan masih, pe akapohowe nongan hiyan kiya kili hu masih kene mepo Ngindrai imangsaniy. ");
INSERT INTO nss_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hiyeh ndriyan kipwotisingi yo pe kiwiri paptais ara andre kiro hiyan. Hapeko hiyeh mepo ndriyan kinpwotisingi yo pwi, ara andre kikuni kora kultuwayin. ");
INSERT INTO nss_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pe hu ndraikiya pwoke to iye, ara andre kiro ndruwa hiyeh hu kapwotisingi yo: kiya ngolo, andre hu karasses hu payit, pe andre hu kawong kiya nongna kol hakol-hakol. ");
INSERT INTO nss_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pe andre hu kasap mwat para taya ndramat, pe kapa hu kayin melit ngahan tunguyan, ara andre kinngahi hu pwi. Pe andre hu kaiki nimahu kaya ndrita hu ndramat humwa, pe andre hu kangoh i.>> ");
INSERT INTO nss_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pwen Yapan iwong iya kili hu ihipwen, pe Ngindrai isoli yiy iya kol paingan yang, pe iya impwan iyapwen te nima Ngindrai mot. ");
INSERT INTO nss_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pwen ndramiran hu huya kol pwan masih, pe huya pohowe nongnan. Yapan iropo mbulen iyasurahu, pe iyki ndraikiya pwoke ara para kipwokeyani nongnahu. ");
INSERT INTO nss_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wuloh, Teyopilus; wou ndramat hamou namandran pe mangalam. Yihu ndramat soyon huro ratuluwi hu melit mepo hu kantayah pwen mwalinga yowu. ");
INSERT INTO nss_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yihu ratuluwi titiye para melit mepo hu hiyeh kannimei mamu kinna, kinna marahu. Yihu ara, ara hurayah ndramat para poya mbulen para nongna Ngindrai, pe huratiyaniy isa kili yowu. ");
INSERT INTO nss_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pwen pe yo mbukeno ukahi nokulani titiye masih iye iro ndroiyin pe isa, pwen unimei tehe hiyan para kuratuluwiy, pe kuramwaniyaniy kiro mwonen o, pe kisarayah kisa kili wou, Teyopilus. ");
INSERT INTO nss_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pwen pe wou alahiy para apahasaniy tehe hu melit mepo hu kanhinuwani wou kinna aliy, ara ndrokonan. ");
INSERT INTO nss_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Iro mwonen Herot iro king tahu para kol namandran iya Yutiya, Sekarayah ara yiy pris hamou, pe yiy ara pris iyau ndrokoyirayi Apiyah. Pe nambuyun Elisapet ara iyau ndraye Aaron i. ");
INSERT INTO nss_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pe kultuwayi hilu malmou kene ara imwonen o iya mbulmara Ngindrai, pe ngara hilu koho ndruwa nongan para pwahanou ta Yapan, pe hilu konoho mbusi kultuw handra mwomwan para kultuwayi totohun ta Ngindrai, ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hapeko hilu kanpo noru hilu pwi, paratesah, Elisapet ara ihikamai. Pe hayou ata hilu malmou kene, ara kintamwaitini lenge hilu para hilu kapo mbunah. ");
INSERT INTO nss_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pwen irahihini lenge hu pris para ndrokoyirayi Apiyah mepo Sekarayah ngara kiropo mbulen kiyasura hu, ara isarayah. Pwen Sekarayah ara nakiya po mbulen kiya mbulmara Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pe kultuwayi hu pris, ara ngara hu karakau para kiyingani sehe pris andre kiya nondriya yumwa totohun namandran ta Yapan, para kiya timwi yukyuk mepo ngonohon layin. Pe kau, ara ipwaingani Sekarayah. ");
INSERT INTO nss_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pwen irahihini paramwandrai para nakitimwi yukyuk mepo ngonohon layin, ara yihu ndramat soyon iya husa rawure hu huro ngawan pe huro tohun. ");
INSERT INTO nss_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pwen pe angelou hamou ta Yapan isarayah isa kili Sekarayah, pe iro tine iyapwen te mot para kamwan para tuntun para kosumwan ngonohon layin ara. ");
INSERT INTO nss_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Iro mwonen Sekarayah inime yiy, mwoiwan ara ihin pe inoh turuwe yiy. ");
INSERT INTO nss_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hapeko angelou ipwai iya kili yiy, ipa, <<Sekarayah, mbuna anoh; Ngindrai ara kinhilingi totohun tam pwen. Pe nambuyum Elisapet, ara andre kipo norum kamai hamou, pe andre apohowe ngalan Yohanes. ");
INSERT INTO nss_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pe mbunah ara andre kiyki pwesai kisa kili wou, pe ndriyam andre kimbuluhi yiy. Pe kiro mwonen lang para nakisarayah, ara andre hu ndramat soyon iya hu kapwes, ");
INSERT INTO nss_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","paratesah, yiy andre kirayah ndramat hamou mangalan kiya mbulmara Yapan. Pe mbuna kiyin wain ndre ndran tunguyan. Pe mapu tinan kinmwalahiy tan, Mwoiwan Haiyan, ara andre kipep kiro kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pe yiy andre kiwiri hu ndramira Yisrayel soyon iya hu kamui kasa pe koho ndruwa Yapan, Ngindrai tahu. ");
INSERT INTO nss_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pe yiy andre kiho mu kili Yapan kiya pwoke pe mwoiwa Eliyah. Pe yiy andre kirapaiwani ndriya tama hu mbunah para kimbuluhi noruhu. Pe andre kirapaiwani hu ndramat para ndraingapwi, para hu kawiri lohongai waison tehe tahu ndramat imwonen. Pe yiy andre kimwaniyani hu ndramat para hu koro hinehes para kalonge Yapan nakisa.>> ");
INSERT INTO nss_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pwen Sekarayah isok angelou, ipa, <<Yo andre kusapahasani melit aro tapeh? Yo kunna parangoloh pwen, pe nambuyu ara yiy kinhi pihi parangoloh i.>> ");
INSERT INTO nss_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pwen angelou isomwi yiy, ipa, <<Yo ngolo Kapriyel. Yo ngara kuro tine mbulmara Ngindrai, pe ipwandrisa yo para kusa nese ndraingam kiya nongan hiyan iye. ");
INSERT INTO nss_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pwen pe kiro mahapo kiya, andre amun o pe anlahiy para awong pwi, kipoo lenge melit aro kirayah. Paratesah, lohongam ara kinpwotisingi nongno pwi, mepo nakisa rahihini lengen para kirayah mannan.>> ");
INSERT INTO nss_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lang ara, ara hu ndramat masih huye ngawan huro longe Sekarayah, pe huro lohonge soyon, hupa paratapeh pe yiy ita manau nondriya yumwa totohun namandran ndrangan niwen iya. ");
INSERT INTO nss_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iro mwonen isa ngawan, ara kinlahiy para kiwong kiya kili hu pwi. Pe yihu ara huyirowei tehe yiy ara kinnime taltan handra iro nondriya yumwa totohun. Pe iro mbusi hu kaipisa melit masih iya kili hu, ara iya niman opu. Hapeko imun iro tehen tora ko. ");
INSERT INTO nss_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pe lengen para kiropo mbulen, ara isahapwen, pwen imui iya kolon. ");
INSERT INTO nss_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iyamulan para aliy, nambuyun Elisapet ara mapundriyan imin, pe iho nondriya walah mayimah ara iro kohon o. ");
INSERT INTO nss_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Pe Elisapet ipa, <<Yapan imbusi melit aro isa kili yo, nondriya hu lang aro, para kirapiyani masiro kiya mawen mbulmara hu ndramat masih.>> ");
INSERT INTO nss_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapet ara walahen iho manonoh, pe Ngindrai ipwandrisa angelou Kapriyel iya Nasaret, kol hakol ngawan ita nondriya kol namandran hape Kaliliy. ");
INSERT INTO nss_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pe angelou ara iyarayah iya kili pihindrahin hamou mepo kinnapolo kamai hamou mapu. Pe hu kansokomburani yiy para kiyesou kiya kili ndramat hamou ngalan Yosep; yiy ara iyau ndraye Tepit. Pe pihindrahin ara, ara ngalan Mariya. ");
INSERT INTO nss_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pwen angelou ara iya kili yiy pe irawulohani yiy, ipa, <<Yapan ita sura wou, pe koyun iti wou namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pe Mariya ara ndriyan ipworu namandran iya, iya sehe nongan angelou kinpwai kinna kili yiy; pe iro lohonge soyon iya sehe ndroiyi nongan isa polohori yiy iya aliy. ");
INSERT INTO nss_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hapeko angelou ipwai iya kili yiy, ipa, <<Mariya, mbuna anoh. Pahas ta Ngindrai ita kili wou. ");
INSERT INTO nss_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kamulan mapundriyam, pe andre amwalahiy kiyata mbunah kamai hamou, pe andre apohowe ngalan, ara Yesu. ");
INSERT INTO nss_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yiy andre kirayah ndramat hamou namandran pe mangalan, pe andre hu kapohowe yiy Noru Yiy Hiyeh Iyera Paingan Masih. Pe Yapan Ngindrai andre kiyki yiy kirayah King, pe andre kiwiri ndrohonoku tumbun Tepit. ");
INSERT INTO nss_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pe yiy andre kiro King kili hu ndraye Yakop kinto-kinto, pe ndrohonoku pwanpwan ta King mepo andre kinhipwen pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pwen Mariya isok angelou, ipa, <<Melit aro andre kirayah tapeh? Paratesah, yo kunna polo hamou kamai mapu.>> ");
INSERT INTO nss_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Pe angelou isomwi yiy, ipa, <<Pwoke ta Ngindrai Iyera Paingan Masih ara andre kiramburihi wou, pe Mwoiwan Haiyan andre kisa ndritam. Pwen pe yiy haiyan mepo namwalahiy kiyatan ara, ara andre kapohowe yiy Noru Ngindrai Kamai. ");
INSERT INTO nss_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Animei, nayim Elisapet ara kinhi pihi parangoloh pwen, hapeko yiy mapundriyan, pe andre kipo norun kamai hamou. Pe yiy mepo hupa kinhopo norun pwi ara, ara walehen manonoh pwen imira. ");
INSERT INTO nss_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sehe melit pwokeyan mepo Ngindrai kinlahiy para kimbusiy pwi yeh?>> ");
INSERT INTO nss_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pwen Mariya isomwi yiy, ipa, <<Yo pihin para poya mbulya Yapan. Nongan mepo anpwai, ara hiyan para kirayah mannan kisa kili yo.>> Pwen angelou itali yiy pe iyau. ");
INSERT INTO nss_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iro mwonen ara, Mariya ihikule yiy, pe ileheleh iya kol hakol ngawan ita nondriya hu ngondron para kol namandran hape Yutiya. ");
INSERT INTO nss_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pe iyarayah iya pe isong iya nondriya suwe Sekarayah, pe irawulohani Elisapet. ");
INSERT INTO nss_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iro mwonen Elisapet ihilingi yohola Mariya, pwen mbunah iro ndriyan ara ilohori yiy. Pe Elisapet ara ipep iyata Mwoiwan Haiyan. ");
INSERT INTO nss_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pe iwayeh namandran iya, ipa, <<Ngindrai ara kintoholi wou pwen mwalinga hu pihin masih. Pe norum mepo namwalahiy kiyatan, ara kintoholi yiy. ");
INSERT INTO nss_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yo po hiyeh, pwen pe tina Yapan to isarayah isa kili yo? ");
INSERT INTO nss_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pe iro mwonen ndraingo ihilingi yoholam, pwen mbunah iro ndriyo ara ilohori yiy iyapolo pwesai. ");
INSERT INTO nss_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yapan kitoholi yiy mepo kinpwotisingi lohongan tehe sehe melit mepo Yapan kinpwai kinna kili yiy, ara andre kirayah mannan.>> ");
INSERT INTO nss_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pwen Mariya ipa, <<Lohongo ihiri ngala Yapan, ");
INSERT INTO nss_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","pe mwoiwo ipwesani Ngindrai, Yiy Ngara Kisopwat Yo. ");
INSERT INTO nss_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yo pihin mwaihei para poya mbulyan, pe lohongan ngara kiti yiy mepo iyki yiy iya pwan. Pe kiro matne mahapo kiya, hasap kiyau hasap, ara andre hu kapa tehe Yapan kiniyki lomwes kinsa kili yo. ");
INSERT INTO nss_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yiy Hiyeh Mepo Pwokeyan Masih ara, ara kinmbusi melit namandran iya kinsa kili yo— pe ngalan ara haiyan. ");
INSERT INTO nss_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pe koisirai tan ara andre kisalti hu mepo huro pahandra nohowai tan, hu hasap kiyau hasap. ");
INSERT INTO nss_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pe yiy imbusi hu mbulen pwokeyan iya, pe irasumbuwani hu mepo ngara hu kasikiye hu koro nondriya lohongahu. ");
INSERT INTO nss_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pe irapiyani hu king pwokeyan iya husa pwan husa mawen ndrohonokuhu, pe ihiri hu ndramat mepo ngalahu pwi. ");
INSERT INTO nss_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pe hu ndramat mepo hu mundrui, ara iyki hu melit hiyan iya kili hu, pe isihi hu. Hapeko irasses hu ndramat mameltahu soyon iya, ara huyau o mwaihei. ");
INSERT INTO nss_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pe kinsopwat ndramiran hu para Yisrayel, pe koyun kintut koisirai tan pwi, pe andre kinto-kinto kiya kili ");
INSERT INTO nss_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Apraham pe ndrayen hu, tehe kinpwai pwen kinna kili tamarou hu.>> ");
INSERT INTO nss_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pe Mariya ara iyepolo Elisapet iho pakeh tehe walah maroyoh. Pwen iyamulan imui iya kolon. ");
INSERT INTO nss_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pwen irahihini lenge Elisapet para nakimwalahiy ta mbunah, pwen imwalahiy ta norun kamai. ");
INSERT INTO nss_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pe yowen hu pe hu mepo huro pakeh kili Elisapet, ara huhilingiy tehe Yapan kiniyki koisirai tan namandran kinna kili yiy. Pwen yihu masih ara, ara hupwes iyasura yiy. ");
INSERT INTO nss_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pe iro mwonen lang mandrolwoh para yihu nakasondriti kapilo mbunah, ara yihu pakayoh ngalan kiya pihisali taman Sekarayah. ");
INSERT INTO nss_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hapeko tinan ipwai iya hu, ipa, <<Pwi yoh! Andre kayoh ngalan Yohanes.>> ");
INSERT INTO nss_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pwen hupwai iya kili yiy, hupa, <<Hamou kinho mwalinga yowem hu, ara ngalan tehen tora pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pwen huwong kaipisa nongan iya nima hu iya kili taman, para hu pakayirowei tehe inamili ngala mbunah kiya hiyeh. ");
INSERT INTO nss_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pe ipwai iya kili hu para hu kawiri melit handra kisa para kiratuluwi nongan kaliy, pe mwoiwahu masih ara ihin tehe iratuluwiy, ipa toro: <<Ngalan ara Yohanes.>> ");
INSERT INTO nss_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pwen hape pwi ko, poho Sekarayah ite pe kalamen imemeyeu pe iwong imwonen, pe ihari ngala Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pe hu ndramat masih mepo huro pakeh kili yiy, ara nohowai iwiri hu. Pe tiyeya hu melit masih ara, ara ingau pe isalti ngondron para kol namandran hape Yutiya, pe hu ndramira kol ara huye pwahaltaniy. ");
INSERT INTO nss_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hu ndramat masih ara huhulong pe huro lohonge soyon pe huro sok, hupa, <<Mbunah aro ara andre kirayah hiyeh ndrokonan?>> Huro sok tehen tora, paratesah, pwoke ata Yapan ara iro kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pe Sekarayah, tama Yohanes, ara ipep iya Mwoiwan Haiyan, pe iwong tehe poropet hamou, ipa toro: ");
INSERT INTO nss_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Kahari ngala Yapan Ngindrai para Yisrayel, paratesah, yiy ara kinsa pwen pe kinsopwat worou ndramiran. ");
INSERT INTO nss_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yiy ara kiniyki pwoke kinna kili ndramat hamou para kisopwat tou iripo nondriya kamaye Tepit, ndramat para poya mbulyan, ");
INSERT INTO nss_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","tehe kinpwai pwen kinna kili hu poropet haiyan tan para koluw kinna, ");
INSERT INTO nss_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tehe andre kisopwat rou kasa mawen kili hu hiyeh humwisnani rou, pe kasa mawen nima hu mepo huhingasi rou. ");
INSERT INTO nss_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ilohongani koisirai tan kiniykiy pwen kinna kili tumburou hu, pe ilohongani tapaniu tan haiyan, ");
INSERT INTO nss_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","pe nongan kintandrangan kinna kili tamarou Apraham, ");
INSERT INTO nss_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","para kisa sopwat tou kasa mawen kili hu hiyeh humwisnani rou, pe kirakelehani rou para tukambusi mbulyan, pe andre tukannoh pwi. ");
INSERT INTO nss_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pwen pe nondriya hu lenge rou masih, andre tukambusi mbulen kiyapolo kultuw imwonen pe haiyan kiya mbulmaran. ");
INSERT INTO nss_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pe noru, wou ara andre hu kapohowe wou poropet hamou ta Ngindrai Iyera Paingan Masih; pe wou andre oho mu kili Yapan, pe aramwaniyani meresayan. ");
INSERT INTO nss_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pwen pe ndramiran hu masih andre Yapan kitali hu kultuw mwomwan tahu kayau, pe tehen tora ko andre hu kasa yirowe sopwat ta Yapan. ");
INSERT INTO nss_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nondriya koisirai para namiliwa Ngindrai, pwen andre mwandrai kiyat kiyau kol paingan yang kisa pwan kiltou, ");
INSERT INTO nss_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para kilengani hu mepo hutora nondriya lokuhan, pe hu tora nondriya nohowai para kimat. Pe andre kiponokulani tokuya rou kiro meresai para ndriya wayis.>> ");
INSERT INTO nss_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pwen mbunah ara imandra pe ipwoke iya mwoiwan, pe iye kol ndrohoyin ipoo lengen para kisa pwaingani yiy kisa ngawan mbulmara hu Yisrayel. ");
INSERT INTO nss_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tandrohongan ara, Sisar Aukustus ipwandrandrahani nongan iya kili hu ndramat masih huro pahandra kol namandran masih kene Rom, para hu kaya yuk ngalahu. ");
INSERT INTO nss_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Aro ara irandroiyi yukuya ngala hu ndramat tandrohonga Kwiriniyus iro pohon para kol namandran iya Siriya.) ");
INSERT INTO nss_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pwen pe hu ndramat masih kene, ara humui huya ndroho kolohu hamou-hamou, para hu kaya yuk ngalahu. ");
INSERT INTO nss_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosep ara iyau wum ta ndraye King Tepit, pwen pe itali kol ngawan Nasaret ita nondriya kol namandran hape Kaliliy, pe iya paingan iya kol namandran hape Yutiya, pe iya kol ngawan ata Tepit ngalan Petlehem. ");
INSERT INTO nss_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pe Yosep iya kol ara iyapolo Mariya para hilkaya yuk ngala hilu. Mariya ara hu kansokomburani yiy pwen para kiwiri Yosep, pe Mariya ara mapundriyan imin. ");
INSERT INTO nss_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iro mwonen hilto ndron aliy, pwen lenge Mariya para nakimwalahiy ta mbunah isarayah, ");
INSERT INTO nss_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","pe imwalahiy ta norun ndrihou kamai. Pwen isumwa yiy iya ndrihiyap, pe iyki yiy iye matin pwelekeya mbulmwakau, paratesah, hu noku matiliu masih para nondriya seu, ara hu kanpep topwei kinna tahu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pe iro mwonen ping ara, ara yihu ndramat hayah para pwokereya hu sipsip, ara huro pakeh kol ngawan Petlehem, pe huro memerani hu sipsip tahu. ");
INSERT INTO nss_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pe angelou hamou ta Yapan iyarayah iya kili hu, pe nonowa nganngana Yapan isarahakowahu pe ilengani hu, pe hunoh mimiri hu. ");
INSERT INTO nss_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hapeko angelou ipwai iya kili hu, ipa, <<Wawu mbuna akanoh. Yo usaiki nongan hiyan para pwesai namandran iya, isa kili wawu ndramat masih kene. ");
INSERT INTO nss_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lang nepo ita nondriya kol ngawan ta Tepit, pihin hamou kinmwalahiy kinna ta Ndramat Hamou Para Sopwat; yiy ara Yapan Kristus. ");
INSERT INTO nss_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pe wawu andre kanime kaipisan tehe toro: Wawu andre kanime mbunah hamou hu kansumwa yiy iya hu ndrihiyap, pe iyera matin nondriya pwelekeya mbulmwakau.>> ");
INSERT INTO nss_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Indrou pwi ko, yihu angelou para pahun soyon iya para kol paingan yang, ara husarayah husa polo hamou para mamu, pe huhuri ngala Ngindrai huro pa, ");
INSERT INTO nss_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Kahari ngala Ngindrai iyera paingan masih, pe kiro kol pwan, ndriya wayis kiro mwalinga hu ndramat mepo namiliwai tan itapolo hu.>> ");
INSERT INTO nss_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pwen hu angelou masih hutali hu, pe humui kannau kanna kol paingan yang, pe hu ndramat para pwokereya hu sipsip, ara hamou iro pwai iya kili hamou, huro pa, <<Kiya, tukaya Petlehem pe tukaya nime melit mepo kintayah aro, tehe Yapan kinnese ndraingarou pwen kinna aliy.>> ");
INSERT INTO nss_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pwen huhumbuh huya pe huya nime Mariya hilu Yosep pe mbunah ara iye matin nondriya pwelekeya mbulmwakau. ");
INSERT INTO nss_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iro mwonen huya koyum yiy ihipwen, pwen huya tiyani nongan mepo hu kanhilingiy iyata mbunah ara. ");
INSERT INTO nss_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pe hu ndramat masih huhilingiy, ara huro lohonge ndrit iya sehe melit mepo hu ndramat para pwokereya hu sipsip hu kantiyaniy kinna kili hu. ");
INSERT INTO nss_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Hapeko Mariya iyki hu nongan masih kene ara, ara iro ndriyan pe ngara kiro lohonge kiya aliy. ");
INSERT INTO nss_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pwen hu ndramat para pwokereya hu sipsip ara humui huyau, pe huro hari ngala Ngindrai pe huro pwesani yiy iya hu melit masih mepo hu kanhilingiy, pe hu kannimei; ara hu kantayah imwonen o tehe hu angelou kannese ndraingahu pwen. ");
INSERT INTO nss_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iro mwonen lang mandrolwoh para nakasondriti kapilon, hupohowe ngalan iya Yesu, ngalan mepo angelou kinpohowei pwen ma kintayah ndriya tinan mapu. ");
INSERT INTO nss_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Iro mwonen lang kinsa pwen para kambusi kultuw para karayah howen kiya mbulmara Ngindrai, iho ndruwa Nongan para Pwahanou ta Mose, pwen Yosep hilu Mariya hilu wiri mbunah iya Yerusalem para kayaiki yiy kiya kili Yapan. ");
INSERT INTO nss_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hilu ho ndruwa Nongan para Pwahanou ata Yapan, ipa toro: <<Hu mbunah ndrihou kamai masih kene, ara kayaiki hu tehe yukyuk haiyan kiya kili Yapan.>> ");
INSERT INTO nss_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pwen hilu wiri pai malmou, para hilu kambusi yukyuk tehe pwayan kinpwai pwen ita Nongan para Pwahanou ata Yapan, ipa toro: <<pai malmou ndre noru ngai malmou.>> ");
INSERT INTO nss_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pwen ndramat hamou iye Yerusalem, ngalan, ara Simeyon. Yiy ara ndramat imwonen, pe ngara kiho ndruwa nongan para pwahanou masih ata Yapan. Yiy ara iro longe ndramat mepo Yapan kintakiniman para kisa pe kisopwat hu Yisrayel. Pe Mwoiwan Haiyan ara iro kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mwoiwan Haiyan ara kinpwainganiy pwen kinna kili yiy, tehe yiy andre kinmat kileh pwi, kipoo kinime Yapan Kristus. ");
INSERT INTO nss_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pwen pe Mwoiwan Haiyan iluwani Simeyon iya nondriya yumwa totohun namandran. Pwen iro mwonen ara, Mariya hilu Yosep hilu wiri noru hilu malaman Yesu, para koro ndruwa kowase hu, tehe nongan para pwahanou kinpwai, ");
INSERT INTO nss_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","pwen Simeyon iwiri mbunah pe isap yiy iho niman. Pe irawuloh iya kili Ngindrai, ipa: ");
INSERT INTO nss_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<O Yapane, yo ndramat para poya mbulyam; mahapo nimam kihitan to kiyapolo ndriya wayis, tehe antandrangan pwen kinna. ");
INSERT INTO nss_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Paratesah, moro ara kinnime sopwat tam pwen. ");
INSERT INTO nss_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Wou antamwaniyani melit ariya pwen iro mbulmara hu ndramat para kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pe ngannganan andre kilengani hu Ndramira Lah, pe andre kihari ngala ndramiram hu para Yisrayel.>> ");
INSERT INTO nss_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Pwen pe tama mbunah pe tinan, ara hilhilingiy pe hilu lohonge soyon iya, iya sehe melit Simeyon kinpwai pwen iyata mbunah ara. ");
INSERT INTO nss_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pwen Simeyon iyki lomwes iya kili hu, pe ipwai iya kili tina mbunah, Mariya, ipa, <<Ahilingiy; mbunah iye, ara Ngindrai kintakiniman pwen para kimbusi hu soyon iya koro nondriya Yisrayel hu kayos, pe hu soyon iya hu katine. Yiy andre kirayah tehe kaipisa melit handra mepo andre hu karasisingat anan. ");
INSERT INTO nss_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pwen pe lohongai kokohon tahu ndramat soyon iya ita ndriyahu, ara andre kisa kiro yelan ngawan. Pe andre ahangoruwei tehe semela pahun niwen hapai kissi nerem i.>> ");
INSERT INTO nss_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Iro mwonen lang ara, poropet hamou pihin i iro, ngalan ara Ana SuPanuwel. Pe yiy ara iyau wum ta Aser. Pe yiy kinna pihi parangoloh masih, pe mamu iyesou pe iro polo nambuyun ara hayou manandrtoyoh o. ");
INSERT INTO nss_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pwen iya pihinau pe iho tehen tora ko, ipoo hayou tan iya androlungui pe haahiu (84). Pe kinho tali yumwa totohun namandran pwi. Ping pe lang masih ngara kiro po mbulya Ngindrai, pe ngara kiyuh anandrinai pe kiro tohun. ");
INSERT INTO nss_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pwen iro mwonen paramwandrai ara, ara yiy isa kili hu, pe irawuloh iya kili Ngindrai. Pe inese titiye ta mbunah ara, iya kili hu ndramat mepo huro longe hiyeh andre kisopwat hu para Yerusalem. ");
INSERT INTO nss_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pwen Yosep hilu Mariya hilu kanmbusi melit masih iho ndruwa Nongan para Pwahanou ata Yapan kinhipwen, pwen hilmui hilya kolo hilu imwonen—kol ngawan Nasaret, hira nondriya kol namandran hape Kaliliy. ");
INSERT INTO nss_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pe mbunah ara imandra pe mandran ipwoke; pe ipep iya lohongai waison, pe koisirai ta Ngindrai, ara iro ndritan. ");
INSERT INTO nss_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hayou sih iyau sih taman hilu tinan ngara hilu kaya Yerusalem, para kaya Kowase Yon para Pasopa. ");
INSERT INTO nss_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iro mwonen Yesu hayou tan iho songui pe luwoh (12), pwen huya paingan Yerusalem, para hu kaya Kowase Yon para Pasopa, tehe ngara hu koro mbusiy. ");
INSERT INTO nss_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iyamulan para kowase yon ilon, iro mwonen taman hilu tinan hilro mui nakaya kolohu, hilu kowu tehe wihou Yesu ara kinto ndron Yerusalem. ");
INSERT INTO nss_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pe hilu pa ndre yiy ara iro polo hu masih mepo huyau ara. Pe yihu ye rokai ipoo iya lang sih sesek mwanye. Pwen hiluro seyeh yiy mwalinga yowe hilu pe kowase hilu hu. ");
INSERT INTO nss_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pe iro mwonen hilu seyeh yiy ndrit, pwen hilu mui paiwe, para kaya ten yiy kaya Yerusalem. ");
INSERT INTO nss_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pwen lang maroyoh para hilro seyeh yiy isayau, pwen hilya kahi yiy iro nondriya yumwa totohun namandran. Pe hilu nime yiy imimpwan mwalinga hu ndramat para hinonou, pe iro tahilong hu pe iro sok hu iya hu soksok hayah. ");
INSERT INTO nss_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pe yihu masih mepo huro hilingi yiy, ara huro lohonge ndrit, paratesah, lohongan ileu pe ipahas iya nongan mepo iro somwi hu iya aliy. ");
INSERT INTO nss_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iro mwonen taman hilu tinan hilu nime yiy, ara lohonga hilu indrap. Pe tinan ipwai iya kili yiy, ipa, <<Noru, paratesah pe arakultuwani youlu tamam tehen tora? Ambusiy pe youlu ngandrah para teleyam.>> ");
INSERT INTO nss_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pe yiy ipa, <<Walu tora ten yo paratesah? Walu kowu tehe usa para kuro suwe Tomo?>> ");
INSERT INTO nss_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hapeko hilu kanyirowe sehe nongan mepo iro pwai iya kili hilu iya aliy, ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pwen pe Yesu iyau iyapolo hilu pe huya pwan kol Nasaret, pe iho ndruwa nongna hilu masih. Hapeko tinan, ara iyki nongan masih ara iro manau lohongan. ");
INSERT INTO nss_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pe Yesu iro mandra, pe lohongai waison pe namiliwa Ngindrai pe namiliwa hu ndramat kene, ara huro has kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iro mwonen hayou songui pe yimah ta Sisar Tiperiyus, iro king tahu kol masih hutora pahandra kol namandran masih kene Rom, ara Pontiyus Pailat iro pohon para kol namandran hape Yutiya, pe Herot iro pohon para kol namandran hape Kaliliy, pe nalin Pilip, ara iro pohon para kol namandran hape Yituraya pe Trakonitis, pe Lisaniyas, ara iro pohon para kol namandran hape Apilene. ");
INSERT INTO nss_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas hilu Kayapas ara hilu pris hilhohin ta hu pris masih kene. Pe tandrohongan ara, nongna Ngindrai, ara isa kili Yohanes noru Sekarayah iro kol ndrohoyin. ");
INSERT INTO nss_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pe Yohanes irikai irakayani hu kol masih huro pakeh Ndran Yortan, pe iro pohowe nongan para hu ndramat karapaiwani ndriyahu pe kawiri paptais para Ngindrai kitali hu pakut mwomwan tahu. ");
INSERT INTO nss_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tehe pwayan kinpwai pwen ita puk ta poropet Yisayah, ipa toro: <<Ngasa mbulukoyu hamou ita yoh iyau kol ndrohoyin, ita pa, <Karamwaniyani saya Yapan, pe kasani meresayan kiro mwonen. ");
INSERT INTO nss_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pe karatulungi hu pwenten masih, pe kataluwe hu ngondron pe pahayi masih ara hu kasapwan. Pe hu sai mepo humakaiye, ara karamwaniyani hu pe hu koro mwonen, pe hu sai mepo humasusuwat, ara karalohori hu pe hu kameh. ");
INSERT INTO nss_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pe hu ndramat para kol pwan masih, andre hu kanime mbulya Ngindrai para kisopwat worou.> >> ");
INSERT INTO nss_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pwen Yohanes ipwai iya kili hu ndramat soyon mepo husa kili yiy para kisumuluwani hu ara, ara ipa, <<Wawu ndraye hu mwat mapairahu! Hiyeh kinpomwanye kinsa kili wawu pe apakawop kaya mawen ndrinalokuh ta Yapan mepo itapo isa? ");
INSERT INTO nss_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pe kapa wawu kantapaiwani ndriya wawu ndrokonan, pwen kultuwayi wawu kipwaingani kaipisa wawu tehen aliy i. Pe wawu mbuna akahaterena wawu, pe akapa, <Apraham ara tumbu yowu.> Yo upwai isa kili wawu tehe, iyau kili hu pat aripo, Ngindrai ilahiy para kimbusi hu karayah hu tumbu Apraham. ");
INSERT INTO nss_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pe semen kapereu, ara kinna pwen ita ndroiyi kei yi, pe hu kei masih mepo hu konhoppwai hiyan pwi, ara andre katihihu kaya pwan pe kapiyani hu kaya nondriya mwan.>> ");
INSERT INTO nss_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pe hu ndramat soyon huro ara, husok yiy, hupa, <<Pwen pe yowu po andre kambus tehen tapeh ara?>> ");
INSERT INTO nss_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pwen Yohanes isomwi hu, ipa, <<Yiy mepo suluyan malmou, ara kiyki hamou kiyata hiyeh mepo suluyan pwi, pe hiyeh mepo anandrinan soyon, ara kimbusiy tehen aliy i.>> ");
INSERT INTO nss_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pe yihu ndramat hayah para poya takis, ara husa yi para kawiri paptais. Pe husok yiy, hupa, <<Ndramat para hinonou, yowu andre kambus tehen tapeh?>> ");
INSERT INTO nss_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pwen Yohanes ipwai iya kili hu, ipa, <<Wawu kambulte sombule pat kiya weneyan o, pe mbuna kiramwaitiniy tehe wawu ngara koropo.>> ");
INSERT INTO nss_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pwen hu ndram hayah husike yiy, hupa, <<Pe yowu andre kambus tehen tapeh?>> Pe isomwi hu, ipa, <<Wawu mbuna akarakekeyani hu ndramat pe kawiri sombule pat tahu. Pe wawu mbuna akaiki hu ndramat kiya nongan o mwaihei, para akawiri sombule pat kiyau kili hu. Akalohonganiy tehe kenne wawu mepo wawu tora wiriy, ara ilahi wawu.>> ");
INSERT INTO nss_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pe hu ndramat masih huro longe pe huro sohe, ara huro lohonge soyon iro ndriyahu, pe huro pa, <<Matisan Yohanes ara Kristus, ndre?>> ");
INSERT INTO nss_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pwen Yohanes isomwi hu masih, ipa, <<Yo urupo sumuluwani wawu iya ndran. Hapeko ndramat hamou pwoke tan pwokeyan pe iho hin kili yo, ara andre kisa, pe yo ara kunlahiy para kulombuli malkeye hatna pwelekan pwi. Yiy andre kisumuluwani wawu kiya Mwoiwan Haiyan pe kiya mwan. ");
INSERT INTO nss_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pe yiy iya ndrohonoku ponokuleya wit pe imbultuwe suweleya pwan tan ita niman para kisuwali pwisi wit kiya mawen, pe andre kimbultani sangi wit, kiya nondriya kaisowan. Hapeko pwisi wit, ara andre kitimwiy kiya mwan mepo kinoho mat pwi masih.>> ");
INSERT INTO nss_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pe Yohanes ara ipohowe nongan soyon handra-handra yi, para kirakelehani ndriya hu ndramat. Pe ipohowe nongan hiyan, iya kili hu yi. ");
INSERT INTO nss_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohanes ara ngara kipomate Herot, pohon para kol namandran hape Kaliliy, kiya hu melit mwomwan ngara kimbusiy. Pwen ipomate Herot paiwe, iya mwomwan mepo imbusi iya kili Herotiyas, paratesah, Herot iwiri Herotiyas iya nambuyun, hapeko Herotiyas ara yiy nambuyu nalin. ");
INSERT INTO nss_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pwen pe Herot iposura hu mwomwan mepo kinmbusiy pwen kinna, ara iyki Yohanes iya nondriya kou i. ");
INSERT INTO nss_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Iro mwonen hu ndramat masih huro wiri paptais, Yohanes isumuluwani Yesu yi. Pe Yesu iro tohun manau, pwen kol paingan yang ara ite, ");
INSERT INTO nss_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","pe Mwoiwan Haiyan isa pwan mwensen tehe nombuwe pai hamou, pe iya ndrita Yesu. Pe ngasa mbulukoyu hamou iyau kol paingan yang isa, ara ipa, <<Wou ara Noru, pe ndriyo imbuluhi wou. Yo upwes satam namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pwen Yesu hayou tan ara iho tehe matingui, pe irandroiyi mbulyan. Pe yihu pa ndre yiy ara noru Yosep, pe Yosep ara noru Heli, ");
INSERT INTO nss_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","pe Heli ara noru Mattat, pe Mattat ara noru Lepi, pe Lepi ara noru Melki, pe Melki ara noru Yannai, pe Yannai ara noru Yosep, ");
INSERT INTO nss_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","pe Yosep ara noru Mattatiyas, pe Mattatiyas ara noru Amos, pe Amos ara noru Nahum, pe Nahum ara noru Esli, pe Esli ara noru Nangai, ");
INSERT INTO nss_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","pe Nangai ara noru Maat, pe Maat ara noru Mattatiyas, pe Mattatiyas ara noru Semeyin, pe Semeyin ara noru Yosek, pe Yosek ara noru Yota, ");
INSERT INTO nss_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","pe Yota ara noru Yowanan, pe Yowanan ara noru Resa, pe Resa ara noru Seruppapel, pe Seruppapel ara noru Seyaltiyel, pe Seyaltiyel ara noru Neri, ");
INSERT INTO nss_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","pe Neri ara noru Melki, pe Melki ara noru Atti, pe Atti ara noru Kosam, pe Kosam ara noru Elmatam, pe Elmatam ara noru Er, ");
INSERT INTO nss_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","pe Er ara noru Yosuwa, pe Yosuwa ara noru Eliyeser, pe Eliyeser ara noru Yorim, pe Yorim ara noru Mattat, pe Mattat ara noru Lepi, ");
INSERT INTO nss_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","pe Lepi ara noru Simeyon, pe Simeyon ara noru Yutah, pe Yutah ara noru Yosep, pe Yosep ara noru Yonam, pe Yonam ara noru Eliyakim, ");
INSERT INTO nss_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","pe Eliyakim ara noru Meleya, pe Meleya ara noru Menna, pe Menna ara noru Mattata, pe Mattata ara noru Natan, pe Natan ara noru Tepit, ");
INSERT INTO nss_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","pe Tepit ara noru Yessi, pe Yessi ara noru Opet, pe Opet ara noru Powas, pe Powas ara noru Salmon, pe Salmon ara noru Nahson, ");
INSERT INTO nss_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","pe Nahson ara noru Amminatap, pe Amminatap ara noru (Atmin), (pe Atmin ara noru Arni,) pe (Arni) ara noru Hesron, pe Hesron ara noru Peres, pe Peres ara noru Yutah, ");
INSERT INTO nss_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","pe Yutah ara noru Yakop, pe Yakop ara noru Yisak, pe Yisak ara noru Apraham, pe Apraham ara noru Terah, pe Terah ara noru Nahor, ");
INSERT INTO nss_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","pe Nahor ara noru Seruk, pe Seruk ara noru Reu, pe Reu ara noru Pelek, pe Pelek ara noru Eper, pe Eper ara noru Selah, ");
INSERT INTO nss_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","pe Selah ara noru Kayinan, pe Kayinan ara noru Arpaksat, pe Arpaksat ara noru Sem, pe Sem ara noru Nowah, pe Nowah ara noru Lamek, ");
INSERT INTO nss_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","pe Lamek ara noru Metuselah, pe Metuselah ara noru Enok, pe Enok ara noru Yaret, pe Yaret ara noru Mahalalel, pe Mahalalel ara noru Kenan, ");
INSERT INTO nss_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","pe Kenan ara noru Enos, pe Enos ara noru Set, pe Set ara noru Atam, pe Atam ara noru Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ipep iya Mwoiwan Haiyan, pe itali ndran Yortan pe imui iya. Pe Mwoiwan Haiyan ara iluwani yiy iya kol ndrohoyin. ");
INSERT INTO nss_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pe iya iro kol ndrohoyin lang mahaangui, pe Sinai inohonou yiy. Nondriya hu lang ara, ara kinyan hapesah pwi; pe hu lang ara isahapwen, pwen imundrui. ");
INSERT INTO nss_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pwen pe Sinai ipwai iya kili yiy, ipa, <<Kapa wou Noru Ngindrai Kamai ndrokonan, apwandrandrahani pat ita, pe kipaiwaniy kirayah ndrinanohun.>> ");
INSERT INTO nss_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pe Yesu isomwi yiy, ipa, <<Pwayan kinpwai pwen kinna, ara ipa toro: <Taleh ta ndramat andre kinyau anandrinai o, ara pwi.> >> ");
INSERT INTO nss_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pwen Sinai iluwani Yesu iya paingan, pe indrou pwi ko, iyingani hu kol namandran iya, tahu king masih kene para kol pwan masih, iya kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pe ipwai iya kili yiy, ipa, <<Andre kuiki pwoke nopwaran tahu kol namandran masih ara, kiyasura nonowahu, kisa kili wou. Pe hu melit masih kene ara, ara kaniykiy pwen kinsa kili yo, pe andre kuikiy kiya kili hiyeh unamiliy para kuikiy kiyatan. ");
INSERT INTO nss_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pwen pe kapa atukuruhu pe atohun kisa kili yo, melit masih kene iye, ara andre kuikiy kisatam.>> ");
INSERT INTO nss_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pwen pe Yesu isomwi yiy, ipa, <<Pwayan kinpwai pwen toro: <Atohun kiya kili Yapan Ngindrai atam pe aro pahandra yiy hamou opu.> >> ");
INSERT INTO nss_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pe Sinai iluwani Yesu iya Yerusalem pe iyki yiy iya iro tine payandroha yumwa totohun namandran pe paingan masih. Pwen ipwai iya kili yiy, ipa, <<Kapa wou noru Ngindrai ndrokonan, pwen aro iye pe apiyani wou aya pwan. ");
INSERT INTO nss_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Paratesah, pwayan kinpwai pwen toro: <Yiy andre kipwandrandrahani hu angelou tan, para hu kapenani wou pe kasopwat wou; ");
INSERT INTO nss_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","pe andre hu kasopwari wou kiho nima hu, pwen pe andre antuwani ndrikam kinna pat sih pwi yoh.> >> ");
INSERT INTO nss_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu isomwi yiy, ipa, <<Pwayan kinpwai toro: <Wou mbuna anohonou Yapan, Ngindrai atam.> >> ");
INSERT INTO nss_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pe sinai ara inohonou yiy iya hu melit masih ara kene ihipwen, pwen itali yiy pe iyau, kipoo kiyarahihini lang sih hiyan hira ndron. ");
INSERT INTO nss_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pe Yesu imui iya Kaliliy iro nondriya pwoke ta Mwoiwan Haiyan, pe nolan ara ingau pe isilihi kol namandran hape ara kene. ");
INSERT INTO nss_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pe iro hinuwani hu ndramat nondriya hu yumwa mbultere tahu Yuta, pe hu masih ara huro hari ngalan. ");
INSERT INTO nss_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pe Yesu ara imui iya Nasaret, kol mepo imandra iro aliy. Pe iro mwonen lang Sapat, yiy iya nondriya yumwa totohun, tehe ngara kiro mbusiy. Pwen itine para kipohowe nongan. ");
INSERT INTO nss_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pe huiki puk maiye ata poropet Yisayah iya kili yiy. Pwen ilombuliy, pe ikahi nongan sahin mepo Yisayah kinratuluwiy pwen ita, ara ipa toro: ");
INSERT INTO nss_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Mwoiwa Yapan ara iripo ndrito, paratesah, kintakinimo pwen para kupohowe nongan hiyan kiya kili hu mepo hundroisiy. Yiy ipwandrisa yo usa, para kupwahara nongan kiya kili hu ndramat hu tora nondriya kou, para hu kasa ngawan, pe hu ndramat marahu iyoh ara hu kanimnim paiwe, pe hu hiyeh hutora nondriya nopwaran ara hu koro mwoimwoi. ");
INSERT INTO nss_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pe para kupwahara nongan tehe hayou iye ara lenge Yapan para kipwaingani pahas tan kiya kili ndramiran hu.>> ");
INSERT INTO nss_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pwen imaiyani puk ara, pe iykiy imui iya kili ndramat para ponokule hu puk, pe yiy impwan. Pe marahu ndramat masih huro nondriya yumwa mbultere tahu Yuta , ara itis tan. ");
INSERT INTO nss_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pe Yesu ipwai iya kili hu, ipa, <<Mahapo nongan haiyan iye ara kintayah mannan kinsa tahilong tawawu.>> ");
INSERT INTO nss_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pwen hu masih husikiye yiy, pe huro lohonge soyon iya nongan para koisirai mepo iyau pohon. Pe huro sok, hupa; <<Aripo noru Yosep, ndre?>> ");
INSERT INTO nss_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pwen Yesu ipwai iya kili hu, ipa, <<Matisan wawu pakatiyani paya nongan sahin iye kisa kili yo: <Ndrokta, asopwoyani wou mbukenam!> Tesah mepo anmbusiy pwen iro Kapernawum, ara ambusiy tehen aliy opu kiro kolom imwonen iye. ");
INSERT INTO nss_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Upwai ndrokonan isa kili wawu toro: poropet hamou kiro ndrohokolon imwonen, ara ndramiran hu andre kanhilingi nongnan pwi. ");
INSERT INTO nss_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yo upwai ndrokonan isa kili wawu, tehe hu pihinau soyon iya huro nondriya Yisrayel, iro mwonen lenge Eliyah. Pe iro tandrohongan ara, karam para kol paingan yang ara Yapan iwariy, pe mbulou ara kindrut hayou royoh pe sahin pwi, pe mundruwai namandran iya, ara isilihi kol masih. ");
INSERT INTO nss_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hapeko Ngindrai kinpwandrisa Eliyah kinna kili pihinau hamou para Yisrayel pwi; ipwandrisa yiy iya kili pihinau hamou iro kol ngawan Sarepat ita nondriya kol namandran hape Siton. ");
INSERT INTO nss_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pe tandrohonga Elisa ara iro poropet, hu ndramat soyon iya huro Yisrayel, ara mwamwa kawa ilopwa hu. Hapeko iho mwalinga hu masih ara, Naaman ndramira Siriya kopu, ara mwamwa kawa iro kili yiy ihiwin.>> ");
INSERT INTO nss_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hu ndramat masih huro yumwa mbultere tahu Yuta ara, ara huhilingi nongnan aro, pe ndriyahu isin. ");
INSERT INTO nss_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pwen hutine pe hurasses yiy iya ngawan kol ara. Pe huwiri yiy iya mbusupahayi mepo kol ngawan iro aliy, para hu pakatinihi yiy kiya pwan. ");
INSERT INTO nss_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hapeko irasisinge yiy mwalingahu ko, pe iyau. ");
INSERT INTO nss_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pwen Yesu iyau iya kol ngawan Kapernawum ita nondriya kol namandran hape Kaliliy. Pwen lang Sapat isarayah pe yiy iya pe iro hinuwani hu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pe yihu ara huro lohonge ndrit iya nongnan mepo iro hinuwani hu iya aliy, paratesah, nongnan ara nopwaran. ");
INSERT INTO nss_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pe ndramat hamou iro yumwa mbultere tahu Yuta ariya, ara payit mwomwan iro ndritan, pe iwayeh namandran iya ipa, ");
INSERT INTO nss_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Yah! Yesu para Nasaret! Wou nasahaye yowu? Wou asa para apwalngani yowu, ndre? Yo ara upahasani wou hiyeh—wou ara Ndramat Haiyan ata Ngindrai!>> ");
INSERT INTO nss_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pe Yesu ipalngai ana payit, ipa, <<Amun opu! Pe atali yiy asa ngawan!>> Pwen payit ara ipiyani ndramat ara iro pwan mbulmara hu masih, pe isa ngawan kili yiy pe kinpotisi ndramat ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pwen hu ndramat masih huro lohonge ndrit, pe hamou iro pwai iya kili hamou, huro pa, <<Aripo sehe nongan, eh? Ipwandrandrahani hu payit iyapolo nongan nopwaran pe pwokeyan, pwen husa mawen!>> ");
INSERT INTO nss_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pwen pe nola Yesu ara ingau pe isilihi kol namandran hape ara. ");
INSERT INTO nss_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu itali yumwa mbultere tahu Yuta mepo iro aliy, pe isong iya nondriya seu ta Simon. Pe nossu Simon, ara iro nondriya ngandran pe mandran ingandrah iya. Pwen pe husike Yesu para kisopwat yiy. ");
INSERT INTO nss_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pwen Yesu iya pe iro tine ngilsen, pe ipomate mandran ngandrahan ara, pe itali yiy. Pwen pihin ara itine porosih o, pe ipo mbulyan. ");
INSERT INTO nss_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iro mwonen paramwandrai nakiya lai, pwen hu ndramat huwiri hu mepo mwamwa handra-handra iro kili hu, ara husa kili Yesu. Pe iyki niman iya ndrita hamou-hamou tahu, pe isopwoyani hu pe hungoh. ");
INSERT INTO nss_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pe hu payit husa mawen kili hu ndramat soyon iya, pe hu payit huro wayeh, huro pa, <<Wou ara Noru Ngindrai Kamai!>> Hapeko ipomate hu, pe isiyi pohohu para hu mbuna kawong, paratesah, tanahu tehe yiy ara Kristus. ");
INSERT INTO nss_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pe lang imbungahiy o, Yesu yiy opu iyau iya pe iro kol hape imanun. Pe hu ndramat huro ten yiy, pe iro mwonen husa hape aleheh mepo iro aliy, pwen hu pakakaituwe yiy para mbuna kitali hu. ");
INSERT INTO nss_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hapeko ipwai iya kili hu, ipa, <<Nongan hiyan para kolo King Ngindrai iye, ara andre kuya pohowei kiya hu kol ngawan hayah i, paratesah, Ngindrai ipwandrisa yo usa, ara para kumbulyani mbulen iye.>> ");
INSERT INTO nss_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pe yiy iro pohowe nongan manau, iya nondriya hu yumwa mbultere tahu Yuta para kol namandran hape Yutiya. ");
INSERT INTO nss_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lang sih aro, Yesu iya iro tine ngilse Ndran Makaiye Kennesaret. Pe hu ndramat soyo-soyon iya, ara husa huro tandrapndrap pe hurahakowan, para hu kahilingi nongna Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pwen inime ndroi malkou iro pwaki leng, hapeko hu ndramat para poya ni para ndroi malkou ara, ara hu kanna mawen ndroye hu, pe huro sungani hu kahu tahu. ");
INSERT INTO nss_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pwen iya pe ihis iya nondriya ndroi hakou, pe ndroi mepo ihis iya aliy ara, ara ndroye Simon. Pe Yesu isok Simon para kisuwani ndroi kiya mawen hape pwaki leng. Pwen yiy impwan aliy, pe iro hinuwani hu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pe iro mwonen Yesu iwong ihipwen, ipwai iya kili Simon, ipa, <<Asuwani ndroi kiya ngawan pupura mwekeu, pe akapiyani hu kahu kaya pwan para akapo ni.>> ");
INSERT INTO nss_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pwen Simon isomwi yiy, ipa, <<Namandran, yowu po ping sih sesek mwanye iya pe ingandrah o, pe yowu po ndrit. Hapeko anpwai, pwen pe andre kuho ndruwa nongnam pe kutali hu kahu kaya pwan.>> ");
INSERT INTO nss_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pe iro mwonen humbusiy tehen aliy, pwen hupo hu ni ara soyon iya, pe hu kahu tahu ara hu pakamut. ");
INSERT INTO nss_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pwen pe hurakamiri susuyahu huro ndroi hakou i, para hu kasa pe hu kasopwat hu. Pwen husa pe hulokihi hu ni iya nondriya ndroi malkou kene ara, pe ndroi malkou kene ara, ara ipep, pe pakayuh. ");
INSERT INTO nss_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pe iro mwonen Simon Pita inime sehe melit kintayah, pwen itukuruhu iya ngondro ndrika Yesu, pe ipa, <<Yapan, aya mawen kili yo. Yo ara ndramat hamou mepo pakut to mwomwan!>> ");
INSERT INTO nss_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Paratesah, Pita iyapolo susuyan hu mepo huro ndroyen, ara lohongahu masih kene indrap, iya hu ni mepo hu kanpo ara. ");
INSERT INTO nss_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pe hilu NdraSepetiy malmou para susura Pita, Yamis hilu Yohanes, ara lohonga hilu indrap i. Pwen Yesu ipwai iya kili Simon, ipa, <<Mbuna anoh; kiro mahapo kiya, ara andre apopo hu ndramat.>> ");
INSERT INTO nss_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pwen huluwi ndroyehu malkou iya paingan pwaki leng, pe hutali memelit masih konto, pe huho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iro mwonen Yesu iya iro kol hakol ngawan, pe ndramat hamou iro aliy, ara mandrakuyun masih mwamwa kawa ilopwai. Iro mwonen inime Yesu, itukuruhu iya pwan mbulmaran pe irakamam iya kili yiy, ipa, <<Yapan, kapa welem kiso, alahiy para ambusi yo kurayah howen kiya mbulmara Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pwen Yesu niman iyah iya, pe iyahatek iyatan, pe ipa, <<Wele iso. Arayah howen!>> Pwen hape pwi ko, mwamwa kawa mepo iro kili ndramat ara, ara itali yiy. ");
INSERT INTO nss_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pwen Yesu ipwatisingiy iya kili yiy, ipa, <<Mbuna aya nese ndrainga hamou, hapeko aya yingani wou aya kili pris, para kitimwi yukyuk mepo Mose kinpwandrandrahaniy para arayah howen kiya mbulmara Ngindrai. Pe andre kirayah tehe tiyeyam kiya kili hu pris.>> ");
INSERT INTO nss_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hapeko titiye ta ndramat ara, ara iro ngau iropo iya. Pwen pe hu ndramat soyon iya husa mbultere hu para kasa halong Yesu, pe para kisopwoyani hu mwamwa tahu pe hu kaya hiyan. ");
INSERT INTO nss_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hapeko Yesu ngara kimandrite kili hu pe kiyau kiya hape mawen pe kiya kitohun. ");
INSERT INTO nss_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lang sih aro Yesu iro hinuwani hu ndramat. Pwen yihu Parisiy pe hu ndramat para hinuwani nongan para pwahanou, mepo huyau hu kol mendreheh masih para Kaliliy pe Yutiya pe Yerusalem, ara husa pe hurompwan ara. Pe pwoke ta Yapan ara iro kili Yesu para kisopwoyani hu ndramat humwa. ");
INSERT INTO nss_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pe hu ndramat hayah husap ndramat hamou iro pasup, ara mandran imat. Pe hu pakanohonou para kawiri yiy kiya nondriya seu, pe kaiki yiy kiya kiye pwan mbulmara Yesu. ");
INSERT INTO nss_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yihu ten sai ndrit para kambusiy tehen tora, paratesah, hu ndramat soyon iya huro tandrapndrap. Pwen pe hungas huya payandroha seu, pe hurambuskehei. Pwen hundruyani ndramat ara, mayokun, isong iyau ndrindroh iya pwan mwalinga hu ndramat masih, pe iya mwonen iya mbulmara Yesu. ");
INSERT INTO nss_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu inime lohongahu ndrisiyon, pwen pe ipa, <<Kowase, hu pakut mwomwan atam, ara kuntali hu kannau.>> ");
INSERT INTO nss_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hu Parisiy pe hu ndramat para hinuwani nongan para pwahanou, ara huro lohonge pe huro panguluwaniy mwalingahu, huro pa, <<Aro sehe ndramat mepo ita pwasisiman ana Ngindrai aro? Kinlahi ndramat hamou kitali hu pakut mwomwan ata ndramat hamou ara pwi; Ngindrai opu ilahiy.>> ");
INSERT INTO nss_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu ara tanan tesah ita lohongahu; pe isok hu, ipa, <<Paratapeh pe wawu tora lohongani hu melit aro kene ita ndriya wawu? ");
INSERT INTO nss_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tesah waison eh, para kupa, <Kuntali hu pakut mwomwan tam,> ndre kupa, <Atine pe arakai>? ");
INSERT INTO nss_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hapeko yo unamiliy para wawu kapahasaniy tehe Noru Ndramat Kamai, ara pwoke nopwaran iripo kili yiy iripo kol pwan, para kitali hu pakut mwomwan ...>> Pwen ipwai iya kili ndramat mandran imat ara, ipa, <<Yo upwai isa kili wou: atine, awiri nokum, pe arakai aya suwem.>> ");
INSERT INTO nss_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hape pwi ko, itine iro mbulmara hu, pe iwiri nokun mepo iro matin aliy ara, pe iro hiri ngala Ngindrai, pe iyau iya suwen. ");
INSERT INTO nss_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yihu ndramat masih ara lohongahu indrap, pe huhuri ngala Ngindrai. Pe nohowai iwiri hu, pe hupa, <<Lang nepo, lohonga rou ikairut, paratesah, worou kannime hu melit handra masih.>> ");
INSERT INTO nss_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iyamulan, Yesu irikai iya pe inime ndramat hamou para poya takis ngalan ara Lepi, iro mipwan ndrohonoku poya takis. Pe Yesu ipwai iya kili yiy, ipa, <<Asa, oho ndruwo.>> ");
INSERT INTO nss_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pwen Lepi itine, itali melit masih kene konto, pe iho ndruwa Yesu. ");
INSERT INTO nss_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pwen Lepi ipo yon namandran ana Yesu, iro suwen. Pe hu ndramat para poya takis soyon iya, iyapolo hu ndramat hayah i, husa huro namnam sura hilu. ");
INSERT INTO nss_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pwen hu Parisiy para ndrokoyirayi sih tahu, pe hu ndramat para hinuwani nongan para pwahanou mepo hu para susura hu Parisiy ara, ara hu kokou ana hu ndramira Yesu, hupa, <<Paratapeh pe wawu tora namnam pe wawu tora yin ndran iyasura hu ndramat para poya takis, pe hu ndramat pakut tahu mwomwan?>> ");
INSERT INTO nss_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pwen Yesu isomwi hu, ipa, <<Yihu ndramat mepo mwamwa kili hu pwi, ara andre hu kanna nime ndrokta pwi, hapeko hu hiyeh humwa, hu ara kopu andre hu kaya nime ndrokta. ");
INSERT INTO nss_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yo kunsa para kuyoh hu ndramat hu mwonen pwi, hapeko usa, ara para kuyoh hu ndramat mepo pakut tahu mwomwan, para hu karapaiwani ndriyahu.>> ");
INSERT INTO nss_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pe yihu pwai iya kili Yesu, hupa, <<Yihu ndramira Yohanes ara lang hayah ngara hu kayuh anandrinai pe katohun, pe hu ndramira hu Parisiy, ara tehen aliy i. Hapeko yihu ndramiram, ara hutora namnam pe hutora yin ndran tehen tora kopu.>> ");
INSERT INTO nss_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Pwen Yesu isomwi hu, ipa, <<Kapa ndramat hamou nakipo kowase yesou atan, ara tehen tapeh? Ilahiy para wawu kapwai kiya kili yowen hu para hu kayuh anandrinai, ma iro ndron kili hu? Pwi yoh! ");
INSERT INTO nss_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hapeko lang itapo isa, andre hu kawiri mbukena kowase yesou ara kiya mawen kili yowen hu. Pwen kiho nondriya hu lang ariya, ara andre hu kayuh anandrinai.>> ");
INSERT INTO nss_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pwen pe Yesu itiyani nongan pwandritiye sahin iya kili hu ipa toro: <<Ndramat hamou kinohole koyau hasai howen, pe kisorowe ndrihiyap hasai para aliy kiyasura koyau saken, ara pwi. Kapa hamou kimbusiy tehen tora, pwen koyau howen ara, ara kinilen pwen. Pe ndrihiyap hasai howen mepo isoruwei iyasura koyau saken ara, ara andre ndrihiyap hasai ara, kinhisoule tehe koyau saken pwi. ");
INSERT INTO nss_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pe ndramat hamou kinho songorani wain howen kiya nondriya hu pwisi wain saken ara pwi. Kapa hamou kimbusiy tehen tora, andre wain howen kimbusi hu pwisi wain saken ara hu karahis, pe andre wain kimuw pe hu pwisi wain ara, ara andre hu kaya mwaihei opu. ");
INSERT INTO nss_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pwi yoh! Wain howen ara para kasongoraniy kiya nondriya hu pwisi wain howen opu. ");
INSERT INTO nss_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pe hiyeh mepo kinimwi wain para mamu, ara kinoho namili wain howen pwi. Andre kipa, <Wain para mamu ara hiyan, pe iramwaitini wain howen.> >> ");
INSERT INTO nss_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lang sih Sapat aro, Yesu iro tokai mwalinga hu ndraipinge wit. Pe ndramiran hu, ara huro rih hu mbuwa wit, pe huro sisiyani pwisihu iya nimahu, pe huro yan pekehu. ");
INSERT INTO nss_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pwen yihu Parisiy hayah, hupa, <<Paratapeh pe wawu tora mbusi tesah mepo nonombun para kambusiy kiho nondriya lang Sapat?>> ");
INSERT INTO nss_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pe Yesu isomwi hu, ipa, <<Wawu matisan kannime titiye para sehe melit mepo Tepit kinmbusiy, ndre pwi? Yiy iyapolo susuyan hu humundrui, ");
INSERT INTO nss_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","pe yiy isong iya nondriya yumwa Ngindrai. Pwen iya wiri ndrinanohun nonombun, mepo hu pris opu hulahiy para hu kayan, pe iyniy. Pe iya hang hayah iya kili susuyan hu yi.>> ");
INSERT INTO nss_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pwen Yesu ipwai iya kili hu, ipa, <<Noru Ndramat, ara yiy Yapane lang Sapat.>> ");
INSERT INTO nss_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lang Sapat sih i, Yesu iya nondriya yumwa mbultere tahu Yuta hawum, pe iro hinuwani hu ndramat. Pe ndramat hamou iro aliy, ara niman mot imat. ");
INSERT INTO nss_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pwen yihu Parisiy pe hu ndramat para hinuwani nongan para pwahanou, ara huro ten sai para hu kaiki Yesu kiya nongan. Pe huro memerani yiy tehe lang Sapat ara, ara andre kisopwoyani hu ndramat kaya hiyan, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hapeko Yesu ara tanan lohongahu pwen, pe ipwai iya kili ndramat mepo niman imat ara, ipa, <<Atine, pe asa oro tine iye mbulmara hu ndramat masih.>> Pwen iya mu pe iro tine. ");
INSERT INTO nss_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pwen Yesu ipwai iya kili hu, ipa, <<Nakusok wawu na, tesah nonombun iya lang Sapat: kambusi kultuw hiyan, ndre kambusi kultuw mwomwan; kasopwat mwoiwa ndramat, ndre kapwalnganiy?>> ");
INSERT INTO nss_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pe Yesu maran isalti topwe hu ihipwen, pe ipwai iya kili ndramat ara, ipa, <<Amwaniyani nimam.>> Ndramat aro imbusiy tehen aliy, pe niman ara irayah hiyan masih. ");
INSERT INTO nss_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hapeko yihu ndramira Parisiy pe hu ndramat para hinuwani nongan para pwahanou, ara ndriyahu isin, pe huro panguluwaniy mwalingahu sehe melit yihu nakambusiy kiya kili Yesu. ");
INSERT INTO nss_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lang sih iro mwalinga hu lang ara, Yesu iyau iya ngondron sih para kiya tohun. Pe ping sih sesek mwanye ara, ara iro tohun iya kili Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pe isamasan ndroulang para aliy, iyoh ndramiran hu husa kili yiy, pe ipirani hu songui pe lumou tahu, pe irakinimahu pe iyoh hu ara, hu aposel. ");
INSERT INTO nss_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pe hamou tahu ngalan Simon, mepo Yesu ipohowe ngala handra yi, ara Pita; pe iyapolo nalin Antruw, pe Yamis, pe Yohanes, pe Pilip, pe Partolomeu, ");
INSERT INTO nss_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","pe Mattiu, pe Tomas, pe Yamis NdraAlpeyus, pe Simon ndramat hamou para ndrokoyirayi hu Selot, ");
INSERT INTO nss_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","pe Yutas NdraYamis, pe Yutas Yiskariyot, ndramat mepo iyamulan irasaya Yesu para kiya nima hu ndram. ");
INSERT INTO nss_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pwen Yesu iyapolo ndramiran hu, hulai huya pwan, pe iro tine pwenten hape. Pe ndramiran hu soyon iya huro ara, iyapolo hu ndramat soyo-soyon iya para kol namandran hape Yutiya masih, pe para kol namandran Yerusalem, pe para poholeng para kol ngawan malkol Tayar pe Siton. ");
INSERT INTO nss_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pe hu ndramat masih ara husa para kahalong yiy, pe para kisopwoyani hu mwamwa tahu handra-handra para hu kangoh. Pe hu mepo hu payit huro ndritahu, ara huya hiyan i. ");
INSERT INTO nss_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pe hu ndramat pakanohonou para nimahu kahatek kiyatan, paratesah, pwoke ara iro yau kili yiy pe iro sopwoyani hu ndramat masih huya hiyan. ");
INSERT INTO nss_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pe Yesu maran iya kili ndramiran hu, pe ipa, <<Wawu ndramat mepo menmena wawu pwi, ara lomwes ita kili wawu, paratesah, kolo King Ngindrai ara ata wawu. ");
INSERT INTO nss_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pe wawu mepo wawu tora mundrui mahapo, ara lomwes ita kili wawu, paratesah, wawu andre kahamosu wawu. Pe wawu hiyeh mahapo wawu tora rang, ara lomwes ita kili wawu, paratesah, wawu andre kahai. ");
INSERT INTO nss_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pe wawu mepo wawu topo kili Noru Ndramat, ara kiho nondriya hu lang para hu ndramat kamwisnani wawu, pe karasses wawu, pe kapwasimiri wawu, pe welehu kaya mai ta wawu tehe ngala wawu kiya pwalngengei, ara lomwes ita kili wawu. ");
INSERT INTO nss_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pe wawu kapwes kiho nondriya lang ara, pe akakohis kiyapolo pwesai. Paratesah, kenne wawu namandran iya, ara ita kol paingan yang. Paratesah, tehen tora ko tumbuhu hu, koluw kinna, ara hurandroyani hu poropet tehen aliy i. ");
INSERT INTO nss_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Hapeko wawu mepo menmena wawu soyon iya, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, wawu kanwiri pwesai pwen. ");
INSERT INTO nss_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pe wawu hiyeh mahapo wawu tora wiri anandrinai hiyan, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, kamulan andre wawu kamundrui. Pe wawu hiyeh tora hai mahapo, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, andre wawu karang pe ndruimara wawu kilon. ");
INSERT INTO nss_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pe wawu mepo hu ndramat ngara kasikiye wawu, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, tehen tora ko tumbuhu hu, koluw kinna, ara husikiye hu poropet pwasoyou tehen aliy i. ");
INSERT INTO nss_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hapeko, nakupwai kisa kili wawu mepo wawu tora hilingi yo: ndriya wawu kimbuluhi hu ndramat para mwisnani wawu; pe akambusi hiyan kiya kili hu mepo huhungasi wawu; ");
INSERT INTO nss_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","pe akatoholi hu mepo huten ana wawu; pe akatohun kiya kili Ngindrai para kiyki koisirai kiya kili hu mepo hurandroyani wawu. ");
INSERT INTO nss_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pe kapa hamou kihisuli kaipam haroh, arapaiwani haroh i kiya kili yiy; pe kapa hamou kisa pe kilohi ndroham, ara mbuna ahambusani koiwem i. ");
INSERT INTO nss_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pe hiyeh kisok wou kiya melit handra, ara aikiy. Pe kapa hamou kiwiri meltam handra, ara mbuna arakekei para kimui. ");
INSERT INTO nss_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pe sehe kultuw wawu namiliy para hu ndramat kambusiy kisa kili wawu, ara wawu kambusi kultuw ara ko kiya kili hu. ");
INSERT INTO nss_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kapa ndriya wawu kimbuluhi hu mepo ndriyahu imbuluhi wawu kopu, tesah hiyan andre wawu kawiriy kiyau aliy, yeh? Yihu ndramat pakut tahu mwomwan, ara ndriyahu ngara kimbuluhi hu mepo ndriyahu imbuluhi hu yi. ");
INSERT INTO nss_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pe kapa wawu koro mbusi hiyan kiya kili hu mepo hu ngara kambusi hiyan kisa kili wawu, tesah hiyan andre akawiriy kiyau aliy, yeh? Yihu ndramat pakut tahu mwomwan, ara ngara hu kambusiy tehen aliy i. ");
INSERT INTO nss_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pe kapa hu ndramat kasa nahanah kasa kili wawu, pe wawu namiliy para hu kapo soiwin kimui, ara andre akapo tesah hiyan kiyau aliy, yeh? Hu ndramat pakut tahu mwomwan, ara ngara hu kanahanah kaya kili hu ndramat pakut tahu mwomwan i, paratesah, hupahasaniy tehe andre hu kapo soiwin kimui. ");
INSERT INTO nss_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hapeko ndriya wawu kimbuluhi hu mepo hu mwisnani wawu, pe akambusi hiyan o kiya kili hu. Pe wawu kapa hiyan kiya kili hu hiyeh pakanahanah kili wawu, pe wawu mbuna akalohonganiy para wawu kapo soiwin kimui. Pwen kenne wawu, ara andre kihin kiya namandran iya, pe andre wawu karayah hu noru Ngindrai Iyera Paingan, paratesah, koyun ngara kisikirani hu hiyeh hu konho rawuloh kinna kili yiy pwi, pe hu mepo kultuwayihu pwassin. ");
INSERT INTO nss_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pe koyu wawu kisikirani hu ndramat tehe Tama wawu ngara koyun kisikirani hu. ");
INSERT INTO nss_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Wawu mbuna akarasusut nongan kiya kili hu ndramat, pe Ngindrai andre kintasusut nongan kimui tehen aliy opu kisa kili wawu pwi. Pe wawu mbuna akaiki konoha hu ndramat kiya kili hu, pe Ngindrai andre kiniyki konoha wawu kimui tehen aliy opu kisa kili wawu pwi. Akatali pakut mwomwan tahu ndramat, pwen andre Ngindrai kitali pakut mwomwan ta wawu. ");
INSERT INTO nss_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wawu kayuk kiya kili hu ndramat, pwen andre Ngindrai kiyuk kisa kili wawu. Pe yiy andre kiyki ndrohongan hiyan o, pe andre kindrokomatnaniy, kilohoyaniy kiya-kisa, pe andre kisapep pe kisalon, pe andre kirahun kisa kili wawu. Pwen sehe ndrohongan wawu kaikiy kiya, ara andre Ngindrai kiyki ndrohongan kihisoule ko yi, kimui kisa kili wawu.>> ");
INSERT INTO nss_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pe Yesu iwong nongan pwandritiye yi, iya kili hu tehe toro: <<Ilahi ndramat hamou maran iyoh kiluwani ndramat hamou maran iyoh i? Pwi yoh! Andre hilu malmou kene hilkaya yos kaya nondriya ngat, ndre? ");
INSERT INTO nss_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pe ndramat mepo iro wiri hinonou, ara kinhohin kili ndramat mepo ita hinuwani yiy pwi. Hapeko yiy mepo kinwiri hinonou hiyan pwen, ara andre kirayah tehe ndramat mepo iro hinuwani yiy. ");
INSERT INTO nss_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Paratesah, pe ngara aro nime konu kei hape ita mara nalim hamou, pe akowu tehe kei hamwat ita maram mbukenam? ");
INSERT INTO nss_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kapa anlahiy para anime kei hamwat hira maram mbukenam pwi, pwen tehen tapeh pe alahiy para apwai kiya kili nalim, apa, <Nakute konu kei ita maram.> Wou ndramat para pwandrandraman! Wou ate kei hamwat ita maram kiyau kimu na, kihipwen, pwen andre alahiy para atuluwani nokulaniy ata nalim pe atei. ");
INSERT INTO nss_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kei hiyan ara kinohoppwai pe sangin mwomwan pwi; pe kei mwomwan ara kinohoppwai pe sangin hiyan pwi. ");
INSERT INTO nss_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hu ndramat ngara kayirowe kei hakou-hakou pe kapahasani hu, ara kiyau sangihu. Yihu ndramat konoho rih mbuwa pik kiho porokulun, ndre konoho rih sakei kiho poropalan, ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pe ndramat hiyan, ngara kipwaingani hu melit hiyan mepo ita ndriyan, hu kasa ngawan. Pe ndramat mwomwan, ngara kipwaingani hu melit mwomwan mepo ita ndriyan, hu kasa ngawan. Tesah ipep ita ndriyan, ara andre pohon kipwai. ");
INSERT INTO nss_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Paratapeh pe wawu ngara kayoh yo, <Yapan, Yapan,> hapeko wawu konho ndruwa nongno pwi? ");
INSERT INTO nss_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mahapo, yo nakupwaingani kaipisa hiyeh mepo isa kili yo pe ihilingi nongno pe itokuyaniy. ");
INSERT INTO nss_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yiy ara tehe ndramat hamou ipun seu, pe isoye ngara ndruw tan iya mbulun iya, pe iye ndrita pat. Pe iro mwonen non irah isa, pe iyahawan iya seu, ara imariu o iro, paratesah, puliyan ara hiyan pe pwokeyan masih. ");
INSERT INTO nss_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hapeko ndramat ihilingi nongno pe kintokuyaniy pwi, ara tehe ndramat ipun seu iro ndrita kolkolai o mwaihei. Pe iro mwonen non irah isa, pe iyahawan iya seu, seu ara iyos pe imaloiwe iya mwomwan masih.>> ");
INSERT INTO nss_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu ipohowe nongnan masih aro iya tahilong tahu ndramat ihipwen, pwen iya nondriya kol ngawan Kapernawum. ");
INSERT INTO nss_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pe ndram hamou mepo ihohin ta hu ndram masangat, ara iro aliy, pe ndramiran hamou para poya mbulyan, ara imwa pe pakeh nakimat. ");
INSERT INTO nss_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pe ndramat mepo ihohin ta hu ndram masangat ara ihilong nola Yesu. Pwen ipwandrisa hu yapane kol hayah ta hu Yutah huya kili Yesu, para kaya sok yiy para kisa pe kisopwoyani ndramiran para poya mbulyan. ");
INSERT INTO nss_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Iro mwonen husarayah husa kili Yesu, yihu rakamsi yiy tisingiy para kiya kili yiy, hupa, <<Ndramat ihohin iya kili hu ndram ara, ara yiy hiyan iya, pe ilahiy para aya sopwat yiy. ");
INSERT INTO nss_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Paratesah, yiy ara inamili worou Yutah, pe ipuli yumwa mbultere tahu Yuta towu.>> ");
INSERT INTO nss_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pwen pe Yesu iyau iyapolo hu. Pe yiy iya pakeh suwe ndramat mepo ihohin ta hu ndram masangat ara, pwen ndramat ara ipwandrisa kowasen hu huya kili Yesu, pe hupa, <<O Yapan, toimwam. Mbuna ambusi wou angandrah. Yo kunna hiyan para alahi asa nondriya suwe pwi. ");
INSERT INTO nss_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tehen tora ko, kolso kintewihiy para kusa nime wou pwi yi. Hapeko hiyan para apwatisingi nongan opu, pe ndramat para poya mbulyo, andre kirayah hiyan. ");
INSERT INTO nss_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Upwai tehen toro, paratesah, yo, ara ndramat hamou mepo huiki yo uta pahandra namandran hamou ihohin isato, pe hu ndram hayah topo pahandro yi. Kapa kupwai kiya kili hamou, kupa, <Aya,> pwen andre kiya; pe kapa kupwai kiya kili hamou yoro, kupa, <<Asa,>> pwen andre kisa. Pe kapa kupwai kiya kili ndramat para poya mbulyo, kupa, <<Ambusiy iye,>> pwen andre kimbusiy.>> ");
INSERT INTO nss_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pwen iro mwonen Yesu ihilingi nongan aro, pe ilohonge soyon. Pe ipaiwani yiy iya kili hu ndramat huho ndruwan pe ipwai iya kili hu, ipa, <<Upwai isa kili wawu, kunnime ndramat hamou iripo Yisrayel kinpwotisingi lohongan ndrisiyon tehe ndramat aro, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pwen yihu ndramat mepo ndramat ihohin iyata hu ndram ipwandrisa hu ara, ara humui huya seu pe huya nimei tehe ndramat para poya mbulen ara, ara kintayah hiyan. ");
INSERT INTO nss_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pwen iyamulan hape, Yesu iyau iya kol ngawan hakol ngalan Nain. Pe ndramiran hu iyapolo hu ndramat soyon iya ara huyapolo yiy. ");
INSERT INTO nss_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesu iropo isa mwonen pohomara karam namandran para kol ngawan ara, pwen huro sap nombuwe ndramat hamou huropo husa ngawan. Pe ndramat imat ara, ara noru pihinau hamou, pe yiy norun kamai hamou opu ara. Pe hu ndramira kol ara, ara soyo-soyon iya huro sura pihinau ara. ");
INSERT INTO nss_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iro mwonen Yapan inime pihinau ara, koyun iti yiy, pe ipwai iya kili yiy, ipa, <<Mbuna arang.>> ");
INSERT INTO nss_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pwen Yesu irikai iya ngilse pasup, pe niman iyahatek iya aliy, pe hu mepo huro sap, ara hunim o huro. Pe ipa, <<Wihou, upwai isa kili wou, atine!>> ");
INSERT INTO nss_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pwen ndramat kinmat ara, isa tine pe impwan pe iwong, pe Yesu iwiri yiy pe iyaiki yiy imui iya kili tinan. ");
INSERT INTO nss_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pe hu masih lohongahu ikairut, pe huro hari ngala Ngindrai, huro pa, <<Poropet hamou namandran iya ara kinsarayah iripo mwalingarou. Ngindrai kinsa para kisopwat ndramiran hu.>> ");
INSERT INTO nss_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pe nola Yesu ara ingau pe isilihi topwe kol namandran hape Yutiya, pe iyasura hu kol masih hu hora pakeh aliy. ");
INSERT INTO nss_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pe hu melit masih kene ara, ara yihu ndramira Yohanes huya nese ndraingan iya aliy. Pwen iyoh hilu ndramiran malmou hilsa kili yiy, ");
INSERT INTO nss_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pe ipwandrisa hilu, hilya kili Yapan para kaya sok yiy, kapa, <<Wou ndramat mepo Ngindrai kintandrangan para kisa ara, ndre yowu koro sohoni hamou hira ndron i?>> ");
INSERT INTO nss_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pwen hilu ndramat ara hilsa kili Yesu, pe hilpa, <<Yohanes Ndramat para Paptais, ipwandrisa youlu para kasa kili wou para kasok wou tehe toro: <Wou ara ndramat mepo Ngindrai kinpwatisingiy para andre kisa ara, ndre yowu koro sohoni hamou hira ndron i?> >> ");
INSERT INTO nss_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iro mwonen lang ara, Yesu isopwoyani hu ndramat mepo neken handra-handra ilopwa hu, pe mwamwa handra-handra iro kili hu, pe irapiyani hu payit soyon iya huro ndritahu huya mawen. Pe isopwi hu ndramat soyon marahu iyoh, ara hunimnim. ");
INSERT INTO nss_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pwen pe ipwai imui iya kili hilu ndramat para sapiya nongan ta Yohanes malmou ara, ipa, <<Walu kamui pe kaya nese ndrainga Yohanes kiya sehe melit walu kannimei pe kanhilingiy. Yihu mepo marahu iyoh, ara hunimnim; pe yihu mepo ndrikahu mwomwan, ara huropo tokai; pe yihu mepo mwamwa kawa iro kili hu, ara huya howen; pe yihu mepo ndraingahu iyui, ara ndraingahu ileu; pe yihu mepo humat, ara hutine paiwe; pe yihu mepo hundroisiy, ara huhilingi nongan hiyan. ");
INSERT INTO nss_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pe ndramat mepo ipwotisingi lohongan isa kili yo pe kinhindrundru pwi, ara lomwes kiro kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iyamulan para hilu ndramat para sapiya nongan ta Yohanes, ara hilu kanmui, pwen o Yesu iwong iya kili hu ndramat soyon huro ara, iya titiye ta Yohanes toro: <<Wawu yau iya kol ndrohoyin para kaya nime tesah? Parah hakou mepo nohai ita mbuiwaniy? ");
INSERT INTO nss_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kapa pwi, pwen wawu ya para kaya nime tesah? Ndramat hamou mepo isuluye yiy iya koyau lahayan? Pwi! Yihu mepo ngara hu kasuluye hu kaya hu koyau mepo kennehu namandran, pe ngara hu kapwes kiya melit mwayih tahu, ara ngara hu koro nondriya hu seu nonowan ata hu king. ");
INSERT INTO nss_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pwen wawu ya ndra para kaya nime tesah? Para kaya nime poropet hamou, ndre? Ehe! Pe yo upwai isa kili wawu tehe yiy poropet hamou, pe mbulyan ara ihou i. ");
INSERT INTO nss_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pwayan hu kantatuluwiy mepo itiyani yiy ara iye: <Animei, yo andre kupwandrisa ndramat para sapiya nongan to kiho mu kili wou, pe andre kiho mu kili wou, pe andre kiramwaniyani meresayam.> ");
INSERT INTO nss_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yo upwai isa kili wawu, mwalinga hu ndramat mepo hu pihin hu kanmwalahiy kinna tahu, ara hamou kinhohin kili Yohanes pwi. Hapeko sehe ndramat mepo ngalan pwi kiro kolo King Ngindrai, ara yiy ihohin iyata Yohanes.>> ");
INSERT INTO nss_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Hu ndramat masih, pe hu ndramat para poya takis i, ara iro mwonen huhilingi nongna Yesu, ara husa pahasaniy tehe kultuwayi Ngindrai ara imwonen masih, paratesah, yihu ara, Yohanes kinsumuluwani hu. ");
INSERT INTO nss_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hapeko yihu Parisiy pe yihu mepo hupahas iya nongan para pwahanou, ara huiki ndruwahu iya sai hiyan mepo Ngindrai ipwainganiy iya kili hu, paratesah, Yohanes kinsumuluwani hu pwi.) ");
INSERT INTO nss_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pwen Yesu iro wong manau, ipa, <<Yo andre kuranonoye hu ndramat hasap para mahapo ara kiya tesah? Mwensehu tehe hiyeh? ");
INSERT INTO nss_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yihu tehe hu mbunah ngara hu kampwan ndroho pehei pe hutora yoh iya kili hu hamou-hamou toro: <Yowu, yowu ra ndramiya wawu, hapeko wawu mbuwali wawu ndraniyai; yowu pwandreundreu, hapeko mbuwali wawu para karang mali wawu.> ");
INSERT INTO nss_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohanes Ndramat Para Paptais, ara isarayah pe kinho yan ndrinanohun pwi, pe kinho yin wain pwi. Pwen pe wawu pa, <Payit ita ndritan.> ");
INSERT INTO nss_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pe Noru Ndramat isa pe iro namnam pe iro yin wain, pe wawu pa, <Yiy ara komkom—ndramat para namnam, pe ndramat para kuimwa wain. Yiy ara kowase hu ndramat para poya takis, pe hu ndramat pakut tahu mwomwan.> ");
INSERT INTO nss_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hapeko yihu hiyeh huwiri lohongai waison ta Ngindrai, ara hupwainganiy tehe lohongan, ara ndrokonan masih.>> ");
INSERT INTO nss_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pwen Parisiy hamou ipwanos Yesu para kisa namnam kisasura yiy kipiyah. Pwen pe iya seu ta Parisiy ara, pe iroh iye ngilse keyau para kinamnam. ");
INSERT INTO nss_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lang ara, pihin hamou para kol ngawan ara, mepo ngara kimbusi pakut mwomwan handra-handra, ara ihilong tehe Yesu iro namnam nondriya seu ata Parisiy aro. Pe isap ndraikei mangonohon layin isa, mepo iro pwisin mwayih iya, pe kennen ara namandran iya. ");
INSERT INTO nss_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pe isa pe iro tine ndruwa Yesu, pakeh ngondrokan, pe iro rang memesun. Pe ndruimaran ara itun iya ngondroka Yesu, pe iwiri kompayan pe iro kuwei ndruimaran iya aliy. Pe iro rahunghung iya ndrika Yesu pe itumwi ndraikei mangonohon layin ara iya aliy. ");
INSERT INTO nss_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pwen Parisiy mepo ipwanos Yesu isa kili yiy ara inimei. Pwen yiy imipanguluwaniy, ipa, <<Kapa ndramat aro ara poropet hamou, pwen andre kipahasani kultuwayi pihin mepo niman itapo iya kili yiy ara, tehe yiy pihin hamou mepo pakut tan ara mwomwan.>> ");
INSERT INTO nss_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pwen pe Yesu isomwi lohongan, ipa, <<Simon, nongnam handra iripo kili yo, nakupwai kisa kili wou.>> Pe Simon ipa, <<Kiya, ndramat para hinonou, apwai kisa kili yo.>> ");
INSERT INTO nss_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Pwen pe Yesu ipwai, ipa, <<Ndramat malmou hilu nahi sombule pat ta ndramat hamou. Hamou inahi mayipou, pe hamou inahi mayimingat. ");
INSERT INTO nss_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hilu malmou kene ariya, ara kanlahiy para kapo soiwi nahanah ta hilu kimui pwi. Pwen ndramat ara itali nahanah ta hilu malmou kene. Kiya, hiyeh tahilu andre ndriyan kimbuluhi yiy pwokeyan?>> ");
INSERT INTO nss_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Pe Simon isomwi yiy, ipa, <<Yo upa ndre yiy mepo itali nahanah tan ihohin ara.>> Pwen Yesu ipa, <<Wou ahirani lohongai ara, ara imwonen.>> ");
INSERT INTO nss_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pwen pe Yesu ipaiwani yiy iya kili pihin ara, pe ipwai iya kili Simon, ipa, <<Anime pihin iye? Yo usa nondriya suwem, pe wou anpo ndran para sungeya ndriko pwi. Hapeko pihin iye, ara isungani ndriko iya ndruimaran pe ikuwei iya kompayan. ");
INSERT INTO nss_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wou antahunghung kinsa kili yo pwi. Hapeko pihin aro, iro mwonen usa suwem, ara iripo waiyani tahunghung isa ngondroko. ");
INSERT INTO nss_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wou antumwi ndraikei kinsa poyo pwi, hapeko pihin aro, ara itilingi ndraikei mangonohon isa ngondroko. ");
INSERT INTO nss_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pwen pe upwai sa kili wou tehe, pihin aro, ara ndriyan imbuluhi yo namandran iya, pwen pe hu pakut mwomwan soyon atan, ara Ngindrai kintaliy. Pe hiyeh mepo Ngindrai kintali hu pakut mwomwan tan hape ko, ara andre ndriyan kimbuluhi yiy hape ko yi.>> ");
INSERT INTO nss_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pwen Yesu ipwai iya kili pihin ara, ipa, <<Kuntali hu pakut mwomwan tam.>> ");
INSERT INTO nss_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pwen pe yihu ndramat mepo huye roh pe huyewule ngilse keyau ara, ara huro panguluwaniy mwalingahu, hupa, <<Yiy hiyeh, mepo ita tali hu pakut mwomwan?>> ");
INSERT INTO nss_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pwen Yesu ipwai iya kili pihin ara, ipa, <<Lohongam ndrisiyon kinmbusi wou antayah hiyan kinna mbulmara Ngindrai. Ayau, ayasura ndriya wayis.>> ");
INSERT INTO nss_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iyamulan hape, Yesu irikai iro hu kol ngawan pe hu kol mendreheh hakol iya hakol, pe iro pohowe nongan hiyan para kolo King Ngindrai. Pe hu Songui pe Lumou ara, ara huro polo yiy. ");
INSERT INTO nss_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pe yihu pihin hayah, ara huyapolo Yesu yi. Yihu pihin ara, Yesu kintapiyani hu payit iro ndrita hu kanna mawen, pe kinsopwoyani hu mwamwa tahu. Hamou tahu ngalan Mariya (yiy para kol Maktala pe hupohowe ngalan handra ara Mariya Maktalena). Yiy ara hu payit manandrtimou huro ndritan, pe Yesu kintapiyani hu kanna mawen. ");
INSERT INTO nss_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pe hamou tahu yi, ara ngalan Yohana nambuyu Susa. Susa ara ndramat hamou mepo ngara kiro nimnim kiya suwe Herot. Pe pihin hamou i ngalan Susana, pe hu pihin hayah i huro polo hu. Yihu pihin aro kene, ara iyau menmenahu mbukenan, ngara hu kasopwat Yesu pe ndramiran hu kaliy. ");
INSERT INTO nss_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hu ndramat soyon iya huyau kol hakol-hakol husa mbultere husa kili Yesu, pe itiyani nongan pwandritiye iye iya kili hu, ipa toro: ");
INSERT INTO nss_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Ndramat hamou para mbulya piyang iya para kiya piye hu peke wit tan. Pe iro mwonen iro piye hu peke wit, hu tiken para aliy ara hulon huro sai, pe hu ndramat hurahatuwehu pe hu norukan para wohowoh huiniy. ");
INSERT INTO nss_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pe hu peke wit tiken, ara hulon huya ndrita pat perembun, pe husahambunet o pe humang, paratesah, pwan ara ndran kinto aliy pwi. ");
INSERT INTO nss_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pe hu peke wit tiken, ara hulon huya mwalinga hu malkei maporon, pwen hu malkei maporon, ara hulek iyasura hu peke wit ara, pe huraimwani hu. ");
INSERT INTO nss_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pe hu peke wit tiken i, ara hulon huya ndrita pwan hiyan, pe hulek pe huppwai, pe sangin ihon iya soyon iya, tehe peke wit sih iyki peken masangat.>> Itiyani nongan pwandritiye ara ihipwen, pwen iwayeh, ipa, <<Hiyeh mandraingan, ara kihilingi nongan iye.>> ");
INSERT INTO nss_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pwen ndramiran hu ara husike yiy tehe ndroiyi nongan pwandritiye ara, ipa tesah. ");
INSERT INTO nss_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pe Yesu ipwai iya kili hu, ipa, <<Lohongai kokohon para kolo King Ngindrai, ara kisa leu kisa kili wawu. Hapeko kiya kili hu hayah, ara kutiyaniy kiya nongan pwandritiye opu; pwen <ngara hu koro nimei, hapeko tehe hu kanyirowei pwi; pe ngara hu koro hilingiy, hapeko tehe lohongahu kanileu pwi.> ");
INSERT INTO nss_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pe ndroiyi nongan pwandritiye aro, ara iye: Hu peke wit ara tehe nongna Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hu peke wit hulon huro sai, ara tehe hu mepo huhilingi nongna Ngindrai, hapeko Sinai isa pe iwiri nongna Ngindrai iya mawen ndriyahu. Pwen pe andre hu kanpwotisingi lohongahu pwi, pe Ngindrai andre kinsopwat hu pwi. ");
INSERT INTO nss_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pe tiken hulon huro ndrita pat perembun, ara tehe hu mepo huhilingi nongna Ngindrai pe huwiriy pe hupwesaniy. Hapeko yihu ara tehe hu peke wit mepo ngondrohu kansin pwi. Yihu pwotisingi lohongahu hape ko, pe kapa nohonou kisa, ara andre hu kayos. ");
INSERT INTO nss_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pe hu peke wit tiken mepo hulon huya mwalinga hu malkei maporon, ara tehe yihu mepo huhilingi nongna Ngindrai, hapeko huro tokai o, pe lohongai para mipwan hiyan, pe nonowa kol pwan, pe pwesai para menmena kol pwan, ara iraimwanihu. Pwen pe yihu kanilek hiyan pwi. ");
INSERT INTO nss_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hapeko hu peke wit mepo hulon iya ndrita pwan hiyan, ara tehe hu hiyeh ndriyahu hiyan pe imwonen, pe huhilingi nongna Ngindrai pe hupwotisingiy, ara ngara hu koro tine pwokeyan pe ngara hu koroppwai hiyan. ");
INSERT INTO nss_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ndramat hamou kinoho tolmwani paisui pe kikulaniy kiya pahandra pwelekei, ndre kiykiy kiya pahandra yokyok, ara pwi. Hiyan para kiykiy kiro tine, ndre kiye ndrita keyau, pwen pe yihu hiyeh hu kasa nondriya seu, ara andre hu kanime nganan. ");
INSERT INTO nss_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pe sehe melit mepo ita kohon, ara andre kisa ngawan, pe sehe melit ita kohon pe kanpahasaniy pwi, ara andre kisa yelan ngawan. ");
INSERT INTO nss_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pwen pe akahalong nokulani nongan. Hiyeh mepo tesah iro kili yiy, ara andre kipo suran; pe hiyeh mepo hapesah kili yiy pwi, hape mendreheh ilohongani ipa ndre imira kili yiy, ara andre kawiriy topwei kiya mawen kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pe tina Yesu pe nalin hu ara husa para kasa nime yiy, hapeko yihu kanlahiy para kaya pakeh kili yiy pwi, paratesah, hu ndramat soyon iya huro rahakowan. ");
INSERT INTO nss_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pwen hamou ipwai iya kili Yesu, ipa, <<Tinam pe nalim hu hutora tine ngawan para hu nakasa nime wou.>> ");
INSERT INTO nss_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pwen Yesu isomwiy, ipa, <<Tino pe nali hu ara hu mepo huhilingi nongna Ngindrai pe hu tokuyaniy.>> ");
INSERT INTO nss_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lang sih aro, Yesu ipwai iya kili ndramiran hu, ipa, <<Tuka his ndroi pe kasingondriti ndran makaiye pe tukaya haroh.>> Pwen huhis huya nondriya ndroi hakou pe huyau. ");
INSERT INTO nss_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pe iro mwonen huro ngap huya, ara Yesu iye matin. Pwen nohai namandran imum iya ndrita ndran makaiye, pwen pe isumbuiwani ndroi pe ndroi pakiyuh. ");
INSERT INTO nss_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pwen ndramiran hu huya kili yiy pe huhungini yiy, pe hupa, <<Namandran, Namandran, worou nakayuh ara!>> Pwen Yesu itine pe ipomate nohai iro mum pe nowei iro talon, pe nohai imaito pe ndras imat. ");
INSERT INTO nss_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pe ipwai iya kili ndramiran hu, ipa, <<Lohonga wawu ndrisiyon, ara italeheh?>> Pwen hunoh pe huro lohonge ndrit. Pe hamou isike hamou, huro pa, <<Aripo sehe ndramat? Mepo ipwandrandrahani nohai pe ndras, pe hilu hilingi nongnan i.>> ");
INSERT INTO nss_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pwen Yesu iyapolo ndramiran hu huyarayah huya kol namandran hape ngalan Kerasa, ita haroh para Ndran Makaiye Kaliliy. ");
INSERT INTO nss_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iro mwonen Yesu ihoiki ndrikan iya ndrita leng o, ipohonani ndramat hamou para kol ngawan ara mepo hu payit huro ndritan. Ndramat ara, ara iro mwaheh opu ndrangan niwen iya, pe kinoho ye nondriya seu pwi, hapeko ngara kiye nondriya hu ngare hu ndramat kanmat. ");
INSERT INTO nss_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Iro mwonen inime Yesu, pwen ipalngai, pe iyos iya ngondro ndrika Yesu, pe iwayeh namandran masih, ipa, <<Yesu, Noru Ngindrai Kamai Iyera Paingan Iya, wou nasa sahaye yo yeh? Yo urakamam isa kili wou tehe mbuna aiki ngandran kisa kili yo!>> ");
INSERT INTO nss_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Paratesah, Yesu ara kinpwandrandrahani payit ara para kisa ngawan kili ndramat ara. Lang soyon iya ngara hu kawasi nima ndramat ara pe ndrikan kiya kondrei humbusiy iyau hayen, pe ngara hu koro memerani yiy; hapeko yiy ngara kindrohomwiri hu kondrei ara topwei. Pe payit ara ngara kiluwani yiy kiya hu kol ndrohoyin. ");
INSERT INTO nss_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pwen Yesu isike yiy, ipa, <<Ngalam hiyeh?>> Pwen ipa, <<Ngolo, ara Hundram,>> paratesah, hu payit soyon iya ara huro ndritan. ");
INSERT INTO nss_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pwen yihu payit ara, ara hurakamam iya kili Yesu ken iho ken para mbuna kipwandrandrahani hu para hu kaya ngat mepo mbulun pwi. ");
INSERT INTO nss_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pe hu puw hayoi soyon iya, ara huro susuwan iya sese pahayi haroh kili hu. Pwen hu payit ara hurakamam iya kili Yesu para kipa hiyan para hu kaya ndrita hu puw ara; pwen ipa hiyan para hu kaya. ");
INSERT INTO nss_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pe hu payit hutali ndramat ara, pe huya kili hu puw. Pe hu puw ara, ara hurapak mbusupahayi huya pwan, pe huya song huya nondriya ndran makaiye, pe huya mut topwei. ");
INSERT INTO nss_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pwen hu ndramat para hangna puw ara hunimei pe huwop huya nondriya kol ngawan ara, iyapolo hu kol mendreheh i, pe huya tiyaniy. ");
INSERT INTO nss_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pwen yihu ndramat huyau huya para kaya nime tesah kintayah. Yihu yarayah iya kili Yesu pe hunimei tehe ndramat mepo hu payit huro ndritan mamu ara, ara hu kantali yiy. Pe impwan pakeh ngondroka Yesu, pe kinsuluye yiy kinna koyau, pe lohongan kinileu pe kiningoh. Pwen pe hu ndramat para kol ara hunimei pe hunoh. ");
INSERT INTO nss_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pe yihu ndramat mepo hu kannime tesah kintayah, ara huro tiyani titiye para payit itali ndramat ara pe ingoh tapeh. ");
INSERT INTO nss_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pwen pe yihu ndramat masih para kol namandran hape Kerasa, ara husike Yesu para kitali hu, paratesah, hunoh turut. Pwen pe Yesu ihis iya nondriya ndroi para kiyau. ");
INSERT INTO nss_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pwen ndramat mepo hu payit kantali yiy ara, ara irakamam para kiho ndruwa Yesu, hapeko Yesu ipwandrisa yiy iyau, pe ipa, ");
INSERT INTO nss_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<Amui aya kolom, pe aya tiyani melit masih mepo Ngindrai kinmbusiy pwen kinsa kili wou.>> Pwen ndramat ara iyau iya, pe iya tiyani melit masih mepo Yesu kinmbusiy, pe kinsopwat yiy kinna aliy. ");
INSERT INTO nss_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pwen Yesu imui iya haroh, pe hu ndramat soyon iya ara hurawulohani yiy, paratesah, huro aliy pe huro sohoni yiy. ");
INSERT INTO nss_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pwen pe ndramat hamou ngalan Yairus, yiy pohon para yumwa mbultere tahu Yuta hawum, ara isa pe iyos iya ngondro ndrika Yesu, pe irakamam para Yesu kisa suwen. ");
INSERT INTO nss_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Paratesah, yiy manorun hamou opu, pe hayou ta pihindrahin ara, ara kiho pakeh tehe songui pe luwoh, pe pakeh nakimat. Pwen Yesu, ara iro tokai iropo iya, pe hu ndramat soyon iya ara huro tandrapndrap ngilsen. ");
INSERT INTO nss_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pe pihin hamou iro ara, ara mwamwa ndrai iro manau kili yiy iho nondriya hayou songui pe luwoh, pe hamou kinlahiy para kisopwoyani yiy pwi. ");
INSERT INTO nss_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pe iyau ndruwa Yesu isa, pe niman iyahatek iya payango koiwen, pe hape pwi ko, mwamwa ndrai ara itali yiy pe ingoh. ");
INSERT INTO nss_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pwen Yesu isok, ipa, <<Hiyeh niman kinsahatek kinsa kili yo ye?>> Pwen hu masih hupa pwi iya aliy. Pe Pita ipa, <<Namandran, hu ndramat soyon hutopo rahakowam pe hutopo tandrapndrap husa kili wou.>> ");
INSERT INTO nss_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hapeko Yesu ipa, <<Nima hamou kinsahatek kinsa kili yo. Tono tehe pwoke ara kintan kili yo pe kinna mawen.>> ");
INSERT INTO nss_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pwen pihin ara, ara inimei tehe yiy ara kinlahiy para kikulaniy pwi, pe inoh turuwe yiy, pe isa pe ihikuwani ngundrun isa mbulmara Yesu. Pe iro mbulmara hu ndramat masih, pe itiyani ndroiyin tesah iyki niman iyahatek iya kili Yesu. Pe itiyaniy tehe indrou pwi ko, pe mwamwa tan kintali yiy pe kiningoh. ");
INSERT INTO nss_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pwen pe Yesu ipwai iya kili yiy, ipa, <<Noru, lohongam ndrisiyon, ara imbusi wou antayah hiyan. Ayau ayapolo ndriya wayis.>> ");
INSERT INTO nss_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pwen Yesu iro wong manau, ndramat hamou iyau seu ta Yairus, pohon para yumwa mbultere tahu Yuta , ara isa pe ipwai, ipa, <<Norum pihin, ara kinimat. Konan. Mbuna arakekeyani ndramat para hinonou ara para kisa manau.>> ");
INSERT INTO nss_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pwen Yesu ihilingiy pe ipwai iya kili Yairus, ipa, <<Mbuna anoh; apwotisingi lohongam opu, pwen yiy andre kingoh.>> ");
INSERT INTO nss_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pe Yesu iyarayah iya seu ata Yairus, pe ipa pwi para hamou kiya nondriya seu. Pwen iwiri Pita, Yohanes pe Yamis, pe tama mbunah pe tinan opu huyapolo yiy huya nondriyan. ");
INSERT INTO nss_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iro lang ara, yihu ndramat masih ara huro rang turut pe huro mangalye iya kili mbunah pihin ara. Pe Yesu ipa, <<Wawu kahatih; yiy kinimat pwi yoh. Yiy iyera matin o.>> ");
INSERT INTO nss_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pwen yihu ndramat ara, huhaisani Yesu, paratesah, hupahasaniy tehe mbunah pihin ara, ara kinimat. ");
INSERT INTO nss_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hapeko Yesu niman iya mbultuwe nima mbunah ara, pe ipa, <<Noru, atine!>> ");
INSERT INTO nss_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pwen mwoiwan imui iya kili yiy, pe indrou pwi ko, isa tine. Pwen Yesu ipwai iya kili hu para hu kahang yiy hapesah para kiyan. ");
INSERT INTO nss_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pe taman hilu tinan, ara lohonga hilu indrap. Hapeko Yesu ipwandrandrahani hilu para hilu mbuna kanese ndrainga hamou iya tesah kintayah. ");
INSERT INTO nss_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu iyoh hu Songui pe Lumou husa wule pe iyki pwoke pwokeyan pe nopwaran iya kili hu para hu karasses hu payit, pe kasopwoyani hu mwamwa handra-handra ata hu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pe ipwandrisa hu huyau para hu kaya pohowe nongan para kolo King Ngindrai, pe kasopwoyani hu ndramat humwa. ");
INSERT INTO nss_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pe ipwai iya kili hu, ipa, <<Wawu mbuna akasap melit handra kiyasura wawu, tehe nes, ndre ndrop, ndre ndrinanohun, ndre sombule pat, ndre susura koyau. ");
INSERT INTO nss_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pe sehe seu wawu nakasong kaya koro aliy, ara wawu koro aliy kipoo akatali kol ngawan ara. ");
INSERT INTO nss_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pe kapa hu ndramat kantawulohani wawu pwi, pwen lang mepo wawu nakatali kol ngawan ara, ara akaratolohani kohu pweleka wawu kiyau, pe andre kirayah tehe tiyeya wawu para kiyingani mwomwan tahu.>> ");
INSERT INTO nss_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pwen huyau huya hu kol mendreheh hakol iya hakol, pe huro pohowe nongan hiyan pe huro sopwoyani mwamwa tahu ndramat huro kol masih kene. ");
INSERT INTO nss_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pwen Herot, pohon para kol Kaliliy, ara ihilong hu titiye para hu melit masih huro tayah. Pwen lohongan imapaiwe, paratesah, hu hayah huro pa tehe Yohanes mepo kinmat ara, ara kinsa tine paiwe. ");
INSERT INTO nss_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pe hu hayah ara huro pa ndre Eliyah kinsarayah, pe yihu hayah i, ara huro pa ndre hamou poropet para koluw kinna kinsa mwalen. ");
INSERT INTO nss_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hapeko Herot ipa, <<Yo kunsondriti koyu Yohanes pwen. Pe aripo sehe ndramat ndrokonan, urupo hilingi hu melit iripo mbusiy aro yeh?>> Pe iro hinonou para pakinime Yesu. ");
INSERT INTO nss_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pwen hu aposel humui, pe huya tiyaniy iya kili Yesu iya tesah mepo hu kanmbusiy. Pwen iwiri hu ko huya sura yiy, pe huya kol ngawan mepo hupohowe ngalan Petsaita. ");
INSERT INTO nss_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hapeko yihu ndramat soyon iya, ara husa pahasani tokuya hu; pwen huho ndruwan. Pe irawulohani hu, pe iwong iya kili hu iya titiye para kolo King Ngindrai, pe isopwoyani hu mepo hunamiliy para hu kangoh kiya hu mwamwa tahu. ");
INSERT INTO nss_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Paramwandrai kinpiyah, pwen yihu Songui pe Lumou ara, ara husa kili Yesu, pe hupa, <<Apwandrisa hu ndramat soyon aro kene hu kayau, pwen pe andre hu kaya hu kol mendreheh pe hu kol para parangondron, para hu kaya ten anandrinahu pe hu kayan. Paratesah, worou ara turopo kol mwanan mepo hu ndramat konto aliy pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pe Yesu ipwai iya kili hu, ipa, <<Wawu kahang hu hapesah para hu kayan.>> Pwen husomwi yiy, hupa, <<Ndrinanohun mayimah pe ni malmou opu iripo. Wou apa ndre yowu kaya sousou ana hu ndramat soyon masih aripo?>> ");
INSERT INTO nss_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pe hu kamai huro ara, ara ndromwoyahu iho tehe mayipou (5,000). Hapeko ipwai iya kili ndramiran hu, ipa, <<Akaiki hu korompwan tehe mayimingui koro ndrokoyirayi sih-sih.>> ");
INSERT INTO nss_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pwen ndramiran hu humbusiy tehen aliy, pe hu ndramat masih ara humpwan. ");
INSERT INTO nss_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pe Yesu iwiri ndrinanohun mayimah pe ni malmou ara, pe maran itandras iya kol paingan yang, pe itoholiy. Pwen iramburingiy pe iykiy iya kili ndramiran hu para hu katainganiy kiya ana hu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pwen hu ndramat masih kene ara hunamnam pe isihi hu. Pe hu ndramira Yesu huwiri keyeh mandropwa songui pe luhat pe hunihi ndritike hu iya aliy. ");
INSERT INTO nss_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lang sih aro, Yesu iya kol lohowayin pe iro tohun. Pe ndramiran hu ara huro polo yiy, pe isok hu, ipa, <<Yihu ndramat masih ara hu tora pa ndre yo hiyeh?>> ");
INSERT INTO nss_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pe husomwi yiy, hupa, <<Hayah tahu ara hupa ndre wou Yohanes Ndramat para Paptais. Pe hayah tahu ara hupa ndre wou Eliyah. Pe hu hayah i, ara hupa matisan wou ara hamou tahu poropet para koluw kinna, mepo kinsa tine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pe isok hu, ipa, <<Kiya, pe wawu, ara wawu pa ndre yo hiyeh?>> Pe Pita isomwiy, ipa, <<Wou ara Kristus ata Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pe Yesu ipa mwanye tisingi iya kili hu para hu mbuna katiyaniy kiya kili hamou tehe yiy ara hiyeh. ");
INSERT INTO nss_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pe ipwai, ipa, <<Noru Ndramat andre kiya nondriya hu nopwaran soyon iya, pe andre hu yapane kol, pe hu pris huhohin ta hu pris masih pe hu ndramat para hinuwani nongan para pwahanou, ara andre hu kamwisnani yiy. Pe andre katingundrun kimat, pe kiro mwonen lang maroyoh, andre kisatine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pwen ipwai iya kili hu ndramat masih, ipa, <<Kapa hiyeh pakiho ndruwo, ara kipa pwi kiya namiliwan mbukenan, pe kisap kei tondrih tan, pe kiho ndruwo lang sih tehe sih. ");
INSERT INTO nss_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pe hiyeh pakihimbusani mwoiwan mbukenan, andre mwoiwan kitali yiy. Pe hiyeh kilohongani yo, pe kitali mwoiwan kisa kili yo, pwen andre kisopwat mwoiwan mbukenan. ");
INSERT INTO nss_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kapa ndramat hamou kiwiri hu memelit para kol pwan masih kiya mbukenan yiy, pe kiyamulan kimat pe kitali mwoiwan, pwen andre memelit masih kene ara, andre kisopwat yiy tehen tapeh? ");
INSERT INTO nss_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pe kapa hiyeh kimasi to pe kimasi kiya nongno, pwen Noru Ndramat andre kimasi tan, kiro mwonen lang mepo nakisa kiyapolo nonowa nganan, pe nonowa ngana Taman, pe nonowa ngana hu angelou haiyan. ");
INSERT INTO nss_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Upwai ndrokonan isa kili wawu, tehe hayah mepo hutopo tine iye, ara andre hu kanhingorowe kimat kileh pwi, kipoo hu kanime kolo King Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu iwong tehen tora ihipwen, pwen tehe lang mandrolwoh iyamulan para aliy, Yesu iwiri Pita, Yohanes pe Yamis, hu matimou ara huyapolo yiy pe huya paingan ngondron sih para hu kaya tohun. ");
INSERT INTO nss_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pe Yesu iro tohun, pe kombuyen ipiy iya handra masih, pe koyau tan, ara irayah palpalen pe ngannganan iya. ");
INSERT INTO nss_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Pwen ndramat malmou, Mose pe Eliyah, ara hilsarayah iyasura nonowa ngana hilu, pe hilro wong iyasura Yesu. Pe hilro wong iya sehe melit mepo andre kimbusiy kirayah mannan kiro Yerusalem, pe hilro wong i, iya lengen para kitali kol pwan pe kiyau. ");
INSERT INTO nss_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pe Pita iyapolo susuyan hilu ara marahu inun pe humatin turut. Hapeko iro mwonen husa poyoi, hunime nonowa nganngana Yesu pe hilu ndramat malmou hilro tine sura yiy. ");
INSERT INTO nss_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pwen iro mwonen hilu pakatali Yesu, Pita ipwai iya kili Yesu, ipa, <<Namandran, hiyan para yowu koro iye. Pwen yowu kapuli yopai matiwum: hawum atam, hawum ata Mose, pe hawum ata Eliyah.>> Pita ara iwong, hapeko ikowu iya sehe nongan iro pwai. ");
INSERT INTO nss_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita iro wong manau, pwen o kokom hasai isa pe iramburuhi hu, pe huro nondriya kokom ara, pe hunoh. ");
INSERT INTO nss_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pwen ngasa mbulukoyu hamou iyau kokom isa, pe ipa, <<Iye ara Noru, yiy mepo kuntakiniman para kipo mbulyo. Akahilingi yiy.>> ");
INSERT INTO nss_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pe ngasa mbulukoyun ara ihipwen, pwen husa yirowei tehe Yesu hamou opu iro. Pe ndramiran hu, ara hukaituwe sehe melit hu kannimei, pe hu kantiyaniy pwi. ");
INSERT INTO nss_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pwen iya lang sih i, huro ngondron pe hulai huya pwan, pe hu ndramat soyon iya huya pohonani Yesu. ");
INSERT INTO nss_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pe ndramat hamou iro mwalinga hu ndramat soyon ara, ara iwayeh pwokeyan, ipa, <<Ndramat Para Hinonou, urakamam para asanime noru kamai. Paratesah, noru ara hamou opu. ");
INSERT INTO nss_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pe payit hamou ngara kikohis kiya ndritan, pe indrou pwi ko, ngara kilomei. Pe ngara kipiyani yiy kiya pwan pe kileleyani yiy, pe mbusas ngara kirowet pohon. Pe ngara kipokasiyani yiy, pe mbuwalin para kitali yiy kileh. ");
INSERT INTO nss_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yo urakamam iya kili ndramiram hu para hu karasses payit ara kiya mawen, hapeko hu kanlahiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pwen Yesu isomwiy, ipa, <<O wawu hasap para mahapo, ara wawu kanpwotisingi lohonga wawu pwi, pe lohonga wawu imwakaikai. Mwalaiheh pe andre kuro sura wawu ko yeh? Pe maporosahayeh andre kuro kuni nopwaran tawawu ko yeh? Wawu kawiri mbunah kamai ara, kisa aripo.>> ");
INSERT INTO nss_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pe iro mwonen mbunah ara, iro tokai manau iya kili Yesu, payit ara, ipiyani yiy iya ndrita pwan, pe ileleyani yiy. Hapeko Yesu ipomate payit ara, pe isopwoyani wihou ara, pe iyki yiy imui iya kili taman. ");
INSERT INTO nss_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pe yihu ndramat masih hu nime pwoke namandran ta Ngindrai, pwen lohongahu indrap. Pwen hu ndramat masih ara huro lohonge manau iya hu melit mepo Yesu kinmbusiy, pe ipwai iya kili ndramiran hu ipa, ");
INSERT INTO nss_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Akahilingiy nokulani sehe melit nakupwai kisa kili wawu: Noru Ndramat, ara andre hu karatuni yiy pe kaiki yiy kiya nima hu ndramat.>> ");
INSERT INTO nss_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hapeko lohongahu, ara kinileu kinna ndroiyi nongan aro pwi. Ndroiyi nongan ara, ara ikohon kili hu, para hu kanlahiy para kapwotisingiy pwi. Pe hunoh para hu kasok yiy kiya nongan ara. ");
INSERT INTO nss_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Porosih aro, takokowai irayah iro mwalinga ndramiran hu, tehe hiyeh tahu ndrokonan, ara iho hin. ");
INSERT INTO nss_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pe Yesu kinyirowe lohongahu pwen, pe iwiri mbunah hamou mendreheh isa pe iyki yiy iro tine ngilsen. ");
INSERT INTO nss_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pe ipwai iya kili hu, ipa, <<Sehe ndramat kirawulohani mbunah iye kiya ngolo, ara irawulohani yo. Pe hiyeh irawulohani yo, ara irawulohani hiyeh mepo ipwandrisa yo usa. Paratesah, yiy hiyeh ita mamwore mwalinga wawu, ara yiy iho hin.>> ");
INSERT INTO nss_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pwen Yohanes, ipa, <<Namandran, yowu nime ndramat hamou iro rasses hu payit huyau, iya ngalam; pe yowu pwayi yiy para kihitohai, paratesah, yiy ara para sura tou pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pe Yesu ipa, <<Wawu mbuna akasingori yiy. Hiyeh mepo kintasisingat ana wawu pwi, ara yiy para susura wawu.>> ");
INSERT INTO nss_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pwen lenge Yesu iropo isa pakeh para nakiya kol paingan yang, pwen lohongan itiy pwokeyan para kiya Yerusalem. ");
INSERT INTO nss_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pwen ipwandrisa hu ndramat para sapiya nongan huro mu kili yiy, pe huya nondriya kol hakol mendreheh ita nondriya kol Samariya, para hu kaya ramwaniyani hu melit koro mwoimwoi para yiy kiya aliy. ");
INSERT INTO nss_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hapeko yihu ndramat huro kol ara, ara hu kantawulohani yiy pwi, paratesah, yiy ara nakiya mwonen kiya Yerusalem. ");
INSERT INTO nss_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iro mwonen ndramiran hilu, Yamis pe Yohanes hilnime kultuwayi hu Samariya, pwen hilsok yiy, hilpa, <<Yapan, wou anamiliy para yowu kayoh mwan kiyau kol paingan yang kisa pwan, pe kitimwi hu, ndre?>> ");
INSERT INTO nss_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hapeko Yesu ipaiwani yiy iya kili hilu, pe ipomate hilu. ");
INSERT INTO nss_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pwen huyau huya kol hakol mendreheh i. ");
INSERT INTO nss_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iro mwonen huro tokai sai huropo huya, ndramat hamou ipwai iya kili yiy, ipa, <<Hape aleheh naya aliy, ara andre kuho ndruwam.>> ");
INSERT INTO nss_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pe Yesu ipwai iya kili yiy, ipa, <<Yihu mwiy puyap, ara mangarehu, pe hu norukan para wohowoh, ara mayumwahu. Hapeko Noru Ndramat, ndrohonokun para matiliu, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pwen Yesu ipwai iya kili ndramat hamou i, ipa, <<Asa pe oho ndruwo.>> Hapeko ndramat ara isomwi yiy, ipa, <<Yapan, atali yo kuya roni tomo na.>> ");
INSERT INTO nss_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pe Yesu ipwai iya kili yiy, ipa, <<Hu ndramat para kimat, ara hu koro roni ndramirahu mbukenahu mepo humat. Hapeko wou aya, pe aya pohowe nongna kolo King Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pe hamou i ipwai, ipa, <<Yapan, yo andre kuho ndruwam, hapeko kumui pe kuya pomwanye kiya kili hu ndraisih ato na.>> ");
INSERT INTO nss_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pe Yesu isomwi yiy, ipa, <<Ndramat mepo imbultuwe nes para taluweya pwan, pe inimnim imui iya ndruwan, ara kinlahiy para kipo mbulen kiro nondriya kolo King Ngindrai, ara pwi yoh.>> ");
INSERT INTO nss_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iyamulan Yapan irakinima hu ndramat andrtingui pe lumou i, pe ipwandrisa hu malmou-malmou huho mu kili yiy huya kene hu kol ngawan pe hu kol hakol-hakol mepo andre kamulan kiya aliy. ");
INSERT INTO nss_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pe ipwai iya kili hu, ipa, <<Anandrinai soyon iya, ara hu kaniman pwen hutora piyang, hapeko hu ndramat para poya mbulen, ara noye ko. Pwen pe akatohun kiya kili Yapan mepo mbukena piyang, para kipwandrisa hu ndramat para poya mbulen para hu kayapo mbulen kaya nondriya pingen. ");
INSERT INTO nss_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Akaya! Yo nakupwandrisa wawu tehe hu noru sipsip, para akaya mwalinga hu mwiy puyap. ");
INSERT INTO nss_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pe wawu mbuna akasap ndropwa sombule pat, ndre ndrop, ndre hu hatna pwelekai. Pe wawu mbuna akarawulohani hamou kiho sai. ");
INSERT INTO nss_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pe kapa wawu kasong kaya nondriya seu hawum, pwen wawu kapwai kimu, akapa, <Ndriya wayis, ara kiro polo wawu topo seu iye.> ");
INSERT INTO nss_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pe kapa ndramat para ndriya wayis kiro seu ara, ara andre ndriya wayis kiro polo yiy, pe kapa pwi, andre nongna wawu kimui kisa kili wawu. ");
INSERT INTO nss_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Akoro ndron seu ara ko, pe akayan sehe anandrinai, ndre akayin sehe ndran mepo hu nakahang wawu, paratesah, ndramat ngara kipo mbulen, ara andre kiwiri kennen. Pe wawu mbuna akangas seu hawum kiya hawum. ");
INSERT INTO nss_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pe kapa wawu kaya nondriya kol hakol ngawan, pe hu karawulohani wawu, pwen sehe anandrinai hu kasaikiy kisa kili wawu, ara akayan opu. ");
INSERT INTO nss_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pe akasopwoyani mwamwa tahu ndramat humwa hutora ara, pe akapwai kiya kili hu, akapa, <Kolo King Ngindrai, ara kinsa pakeh kili wawu.> ");
INSERT INTO nss_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hapeko kapa wawu kaya kol hakol ngawan pe hu kantawulohani wawu pwi, ara akaya kene payango sai tahu pe akapa, ");
INSERT INTO nss_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Kohu pwan para kolo wawu mepo ipai iripo polndrika yowu, ara yowu topo tolohaniy pe wawu andre kawiri koran. Hapeko akalohonganiy kiya hiyan: kolo King Ngindrai ara kinsa pakeh kili wawu.> ");
INSERT INTO nss_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yo upwai isa kili wawu, kiro mwonen lang para tamwanye, kora kol ara, ara andre kiramwaitini koran nopwaran para kol Sotom. ");
INSERT INTO nss_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","O wawu para Korasin! O wawu para Petsaita! Toimwa wawu. Nopwaran namandran ita ndrita wawu. Kapa ndramat hamou kinna kol malkol Tayar pe Siton, pe kinmbusi hu ndraikiya pwoke kiro aliy, tehe kintayah kinsa kili wawu pwen, ara andre hu kantapaiwani ndriyahu pwen ndrukoluw kinna, pe andre hu kansuluye hu kanna koyau para koisirai, pe andre hu kantumwi hu kanna palam i. ");
INSERT INTO nss_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hapeko kiro mwonen lang para tamwanye, koran nopwaran wawu nakakuniy, ara andre kiramwaitini kora nopwaran tahu para Tayar pe Siton. ");
INSERT INTO nss_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pe wawu para Kapernawum, wawu pakasikiye wawu kaya paingan yang, ndre? Pwi yoh! Wawu andre kaya pwan masih ndrohonoku hu ndramat kanmat. ");
INSERT INTO nss_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sehe ndramat kihilingi wawu ara ihilingi yo yi, pe sehe ndramat mbuwalin ta wawu, ara mbuwalin to yi; pe hiyeh mbuwalin to, ara mbuwalin ta hiyeh ipwandrisa yo usa iyapolo pwoke nopwaran.>> ");
INSERT INTO nss_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yihu ndramat andrtingui pe lumou ara humui huyapolo pwesai, pe hupa, <<Yapan, yowu pohowe ngalam, pe hu payit ara huhilingiy pe huho ndruwa nongna yowu.>> ");
INSERT INTO nss_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pwen pe Yesu isomwi hu, ipa, <<Yo unime Sinai iyos iro kol paingan yang isa pwan tehe kamit. ");
INSERT INTO nss_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yo ara kunuiki pwoke nopwaran iya, kinsa kili wawu pwen, para wawu andre kangastoro pe karahatuwe hu mwat pe hu supwalngai, pe andre wawu karamwaitini pwoke masih ata Sinai; pe andre hapesah mwomwan kintayah kili wawu pwi yoh. ");
INSERT INTO nss_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pwen wawu mbuna akapwes kata hu payit huhilingi wawu, hapeko wawu kapwes tehe ngala wawu, ara Ngindrai kinratuluwiy pwen ita kol paingan yang.>> ");
INSERT INTO nss_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iro mwonen lang ara Mwoiwan Haiyan iyki pwesai namandran ipep ndriya Yesu, pe Yesu ipa, <<Tomo, Yapane kol pwan pe kol paingan yang, yo uhuri ngalam, paratesah, wou ankulani hu melit aro kinna kili hu ndramat mepo lohongahu iman pe hupahas iya lohongai, hapeko aniyki hu melit kansa yelan ngawan kinna kili hu mbunah mendreheh. Ehe, Tomo, anmbusiy tehen tora, ara iho ndruwa namiliwam opu. ");
INSERT INTO nss_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Melit masih, Tomo kiniyki hu topwei kansa kili yo. Pe hamou tanan ta Norun pwi, Taman opu tanan ta norun. Pe hamou tanan ta Taman pwi, Norun opu tanan ta Taman. Pe hu mepo Norun inamiliy para kiyingani Taman kiya yelan kili hu, ara yihu ara ko, hupahasani yiy.>> ");
INSERT INTO nss_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pwen Yesu ipaiwani yiy iya kili ndramiran hu, pe iwong nokule ko, ipa, <<Yihu mepo hunime tesah wawu topo nimei, ara lomwes ita kili hu. ");
INSERT INTO nss_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yo upwai isa kili wawu tehe hu poropet soyon pe hu king para koluw, ara hunamiliy para hu kanime tesah mepo wawu topo nimei, hapeko hu kannimei pwi. Pe yihu pakahilingi tesah mepo wawu topo hilingiy, hapeko yihu kanhilingiy pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Porosih aro, ndramat hamou ipahas iya nongan para pwahanou ara itine para pakinohonou lohonga Yesu, pe isok yiy, ipa, <<Ndramat para hinonou, yo andre kumbusi tesah para kuwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pe Yesu isomwi yiy, ipa, <<Pwayan kinpwai pwen ita nongan para pwahanou, ara ipa tesah? Pe wou animei tehen tapeh?>> ");
INSERT INTO nss_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pe ndramat ara isomwi yiy, ipa, << <Ambuluhi Yapan Ngindrai atam kiyau ndriyam masih kene, pe kiya mwoiwam masih kene, pe kiya pwoke tam masih kene, pe kiya lohongam masih kene>; pe <ndriyam kimbuluhi hiyeh para pakeh kili wou tehe ndriyam ngara kimbuluhi wou mbukenam.> >> ");
INSERT INTO nss_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Pe Yesu ipwai iya kili yiy, ipa, <<Wou ansomwiy imwonen masih. Pwen, ambusiy tehen tora, pe andre awiri taleh.>> ");
INSERT INTO nss_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hapeko ndramat ara, ara pakimbusi yiy mbukenan tehe kultuwayin imwonen, pwen pe isok Yesu, ipa, <<Pe ndramat para pakeh kili yo, ara hiyeh imwonen?>> ");
INSERT INTO nss_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pe Yesu isomwi yiy, ipa, <<Lang sih aro, ndramat hamou itali Yerusalem para pakilai kiya kol ngawan Yeriko. Pe yihu ndramat para pahana hu kohon huho sai pe hurayi yiy, pe huwiri topwe meltan masih iyapolo koiwen. Pwen hutali yiy kinto pwan tehe pakeh nakimat, pe hu kantan. ");
INSERT INTO nss_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pe pris hamou ara ilai sai ara ko isa pwan, pe inime ndramat ara. Pwen pe iyayau te sai haroh, pe kinnau. ");
INSERT INTO nss_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pwen hamou tahu Lepi yi, ara isa mwonen isa ara, pe inime yiy. Pwen pe indrihisani yiy iyapwen te sai haroh i, pe kinnau. ");
INSERT INTO nss_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hapeko ndramat hamou para Samariya iro tokai sai, pe isarayah isa mwonen isa hape aleheh mepo ndramat ara iro aliy. Pe inime yiy, pe koyun isikirani yiy. ");
INSERT INTO nss_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pwen iya ngilsen, pe itilingi ndraikei pe wain iya hu neken tan pe iwasi hu. Pwen iyki ndramat ara iya ndrita tongkiy tan mbukenan, pe iwiri yiy iya seu para pwokereya hu ndramat, pe iponokulani yiy. ");
INSERT INTO nss_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pe iya lang sih i, iwiri sombule silwa malmbut, pe iykiy iya kili ndramat iro nimnim iya seu para pwokereya hu ndramat ara. Pe ipwai iya kili yiy, ipa, <Apwokarani yiy kipoo kumui kusa, pwen andre kupo sura soiwi sombule pat tam mepo anpiyaniy pwen para asopwat yiy.> >> ");
INSERT INTO nss_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pwen Yesu isok ndramat ara, ipa, <<Kiya, alohonganiy na; hiyeh tahu matimou ara, ara irayah tehe ndramat para pakeh kili ndramat aro, mepo iyos iya nima hu ndramat para pahana pe hurayi yiy?>> ");
INSERT INTO nss_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pwen ndramat ipahas iya nongan para pwahanou ara isomwi Yesu, ipa, <<Ndramat mepo koyun iti yiy pe isopwat yiy ara.>> Pwen pe Yesu ipwai iya kili yiy, ipa, <<Ayau aya, pe ambusiy tehen aliy yi.>> ");
INSERT INTO nss_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu iyapolo ndramiran hu huro tokai huya, pe husa kol hakol mendreheh mepo pihin hamou ngalan Marta iro aliy. Pe pihin ara iwiri Yesu iya suwen. ");
INSERT INTO nss_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pe Marta ma nalin hamou ngalan Mariya, pe Mariya iya pe irompwan pakeh ngondroka Yesu, pe iro hilingi sehe nongan Yesu iro wong iya aliy. ");
INSERT INTO nss_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hapeko Marta ara lohongan kinikuw pwi, iya sehe melit mepo iro mwanye hu ara—tehe pwokeikei pe melit handra-handra yi. Pwen pe isa kili Yesu, pe ipwai, ipa, <<Yapan, alohonganiy tapeh? Nali ara itali yo, pe yo kopu urupo pet iya mbulen iye. Apwai kiya kili yiy para kisa sopwat yo!>> ");
INSERT INTO nss_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pe Yapan isomwi yiy, ipa, <<Marta, Marta; wou ara ata lohonge soyon, pe ndriyam ipworu iya hu melit soyon iya. ");
INSERT INTO nss_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Hapeko melit handra kopu, ara ihohin para aro lohonganiy. Pe Mariya ara inamiliy para kiwiri melit handra hiyan masih aro. Pe kinlahi hamou kiwiriy kiya mawen kili yiy, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lang sih aro, Yesu iya kol hape pe iro tohun. Itohun ihipwen, iyamulan ndramiran hamou ipwai iya kili yiy, ipa, <<Yapan, ahanuwani yowu kiya totohun tehe Yohanes kinhinuwani ndramiran hu kinna aliy.>> ");
INSERT INTO nss_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pwen ipwai iya kili hu, ipa, <<Kapa wawu nakatohun, ara wawu kapa: <Tomo, ngalam ara haiyan. Kultuwayi kolo king tam kisa. ");
INSERT INTO nss_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ahang yowu anandrinai para lang sih tehe sih. ");
INSERT INTO nss_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pe atali hu pakut mwomwan towu, tehe yowu ngara katali hu pakut mwomwan tahu ndramat masih, mepo hu ngara kambusi pakut mwomwan kisa kili yowu. Pe mbuna aluwani yowu kiya nondriya nohonou.> >> ");
INSERT INTO nss_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pwen ipwai iya kili hu, ipa, <<Kapa hamou tawawu ara makowasen, pe kiho ndrokolo put kiya kili hamou, pe kipa, <Kowase, aiki ndrinanohun matipai kisa kili yo; ");
INSERT INTO nss_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","paratesah, kowase hamou iyeyau sai o, pe isarayah isa kili yo, pe hapesah para kuhang yiy pwi.> ");
INSERT INTO nss_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pwen ndramat mepo iro nondriya seu ara isomwi yiy, ipa, <Mbuna asa tandroyani yo. Papaye yowu, ara kanwariy, pe yowu noru ara yowu kanmatin pwen topo yokyok towu. Pe kunlahiy para kutine pe kuhang wou hapesah pwi.> Pwen tehen tapeh? ");
INSERT INTO nss_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Upwai isa kili wawu, welen imai para kitine pe kiyki ndrinanohun kiyatan, konan yiy ara kowasen, hapeko iya pwoke ata ndramat mepo iro rakekeyaniy manau ara, pwen andre kitine pe kiyki weneyan o tehe inamiliy. ");
INSERT INTO nss_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Pwen tehen tora ko, upwai isa kili wawu: Akasok pe andre kaikiy kisata wawu, akaten pe andre akaya kahiy, akaralikiri papai pe andre papai kite kisa kili wawu. ");
INSERT INTO nss_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Paratesah, hiyeh mepo kisok, ara andre kiwiriy, pe hiyeh mepo kiten ara andre kiya kahiy, pe hiyeh mepo kiralikiri papai, ara andre papai kite kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kapa noru wawu hamou kisok taman kiya ni hamou, pwen andre kihang yiy mwat hamou? Pwi yoh! ");
INSERT INTO nss_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pe kapa kisok kiya nairu norukan sih, pwen andre taman kihang supwalngai hamou kiya anan? Pwi yi! ");
INSERT INTO nss_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe kapa wawu tana wawu topwei para wawu kaiki hu yukyuk mwayih kiya kili noru wawu hu, konan wawu ndramat ngara kambusi kultuw mwomwan, pwen tehen tora ko, Tama wawu iyera kol paingan yang, ara andre kiyki Mwoiwan Haiyan kiya kili hu mepo hu ngara kasok yiy!>> ");
INSERT INTO nss_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu iro rapiyani payit hamou para pohomum iyau iya mawen kili ndramat hamou, pe payit ara itali yiy kinnau. Pwen o, ndramat mepo pohon imum ara, ara iwong, pe hu ndramat masih, ara huro lohonge soyon. ");
INSERT INTO nss_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hapeko hu hayah tahu hupa, <<Ita rasses hu payit, ara iyau pwoke ta Peelsepul, payit mepo yapane hu payit masih.>> ");
INSERT INTO nss_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pe hayah tahu ara hu pakanohonou yiy, pe huro sok yiy para kipwaingani kaipisa pwoke handra kiyau kol paingan yang. ");
INSERT INTO nss_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu kinpahasani lohongahu pwen, pe ipwai iya kili hu, ipa, <<Kapa hu ndramira king para kol hakol, hu kamasilpat kaya malpat pe hu kahangas mwalingahu, pwen andre kolo king ara kiya pwalngengei o mwaihei. Pe kapa yihu ndraisih hu kahangas anahu mbukenahu, hu ndraisih ara, ara andre hu kalon. ");
INSERT INTO nss_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pe kapa yihu yowe Sinai hu kamasilpat kaya malpat, pwen andre kolo king tan kiro tine pwokeyan tapeh? Yo upwai tehen toro, paratesah, wawu pa ndre yo urasses hu payit huyau, ara iyau pwoke ta Peelsepul. ");
INSERT INTO nss_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hapeko kapa kurasses hu payit kiyau pwoke ta Peelsepul, pwen yowe wawu hu ngara karasses hu payit kiyau pwoke ta hiyeh? Pwen pe hu yowe wawu mbukena wawu, andre hu kapwainganiy tehe nongna wawu ara, ara kinmwonen pwi. ");
INSERT INTO nss_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hapeko kapa Ngindrai kiniyki pwoke nopwaran tan kinsa kili yo, pe ngara kurasses hu payit hu kayau kaliy, pwen pwoke para kolo King Ngindrai, ara kinsa kili wawu pwen. ");
INSERT INTO nss_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pe kapa ndramat hamou pwokeyan kimbultuwe memelit para pahun kiro kili yiy, pe kiro penani suwen mbukenan, pwen memelit tan masih andre kiro hiyan. ");
INSERT INTO nss_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hapeko kapa ndramat hamou pwokeyan iya pe ihohin iyatan kisa, pe kipo pahun kiyasura yiy pe kiramwaitini yiy, pwen ndramat pwokeyan ara, andre kiwiri hu melit para pahun ata ndramira seu ara, mepo lohongan ipa ndre hu koro penani yiy. Pwen ndramat pwokeyan ara, andre kiya pe kirahihiri melit masih para seu ara. ");
INSERT INTO nss_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pe hiyeh mepo kinto sura yo pwi, ara andre kirasisingat ano. Pe hiyeh mepo kinho mbultani hu ndramat pwi, ara ngara kirasumbuwani hu. ");
INSERT INTO nss_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kapa payit hamou kisa mawen kili ndramat hamou, ara andre kiya kol ndrohoyin para kiya ten noku ngohongoh. Hapeko kapa kinlahiy kikahi noku ngohongoh pwi, pwen andre kipa, <Andre kumui kuya seu kuntaliy mamu ara.> ");
INSERT INTO nss_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pwen iyarayah iya, pe iya nimei tehe seu ara, ara yihu kanpwasiliy kinna hiyan pe iro mwoimwoi. ");
INSERT INTO nss_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pwen imui iya pe iya wiri hu payit manandrtimou i, mepo kultuwayihu pwassin masih pe iramwaitini yiy, pe husong huya nondriyan pe huyen aliy. Pe iyamulan para aliy, ara mipwan ata ndramat ara, ara kintewihiy pwi masih, pe iramwaitini mipwan tan para mamu.>> ");
INSERT INTO nss_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pwen Yesu iro tiyani hu melit aro ndron, pe pihin hamou iro mwalinga hu ndramat soyon ara, iwayeh, ipa, <<Pihin mepo imwalahiy tam pe ipwokere wou, ara lomwes ita kili yiy.>> ");
INSERT INTO nss_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hapeko Yesu isomwi yiy, ipa <<Hiyan para tukapwai toro: yihu mepo huhilingi nongna Ngindrai pe huho ndruwan, ara lomwes ita kili hu.>> ");
INSERT INTO nss_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pe yihu ndramat ara hurohon huropo huya soyon, pe Yesu ipa, <<Yihu ndramat hasap para mahapo, kultuwayihu ara pwassin. Yihu sok kaipisa pwoke handra, hapeko andre hu kannimei pwi; kaipisa poropet Yonah kopu andre hu kanimei. ");
INSERT INTO nss_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Paratesah, Yonah ara kintayah tehe kaipisa melit iya kili hu ndramira Ninipe; pwen pe Noru Ndramat andre kirayah tehen aliy opu, kiya kili hu ndramat hasap para mahapo. ");
INSERT INTO nss_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pe kiro lang para tamwanye, Kwin para Tolau andre kisa pe andre kitiyani titiye mwomwan ta hu ndramat hasap para mahapo, paratesah, yiy iyau mbusungo kol pwan isa para kisa hilong lohongai waison ta Solomon. Hapeko hamou iripo mahapo, ara ihohin iya, iya kili Solomon. ");
INSERT INTO nss_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pe kirahihini lang para tamwanye, yihu ndramira kol Ninipe andre hu kasa koro tine, pe kasopwat nongan para tamwanye, pe katiyani titiye mwomwan tahu hasap para mahapo, pe andre hu karasusut nongan kiya kili hu. Paratesah, yihu kanhilingi nongna Yonah pe hu kantapaiwani ndriyahu, hapeko hamou iripo mahapo, ara ihohin iya, iya kili Yonah. ");
INSERT INTO nss_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ndramat hamou kinoho tolmwani paisui pe kikulaniy kiro hape, ndre kiykiy kiye pahandra pwelekei sih, ara pwi. Andre kiykiy kiro tine ndrita keyau, pwen hu ndramat masih hu kasa nondriyan, andre hu kanime nganan. ");
INSERT INTO nss_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mara ndramat ara tehe paisui para nombuwe ndramat. Kapa maram kiro hiyan, ara nombuwem masih andre kipep kiya nganan. Hapeko kapa maram kiro mwomwan, pwen andre nombuwem masih kilokuh topwei. ");
INSERT INTO nss_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Maram kiro tam kiya hiyan, matisan ngana maram ita nondriyam ara kilokuh. ");
INSERT INTO nss_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pwen tehen tora ko, kapa nombuwem masih kipep kiya nganan, pe hape para aliy kinilokuh pwi, pwen nombuwem masih andre ngannganan kiyat topwei, tehe ngana paisui kiho yat ndritam.>> ");
INSERT INTO nss_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu iwong ihipwen, pwen Parisiy hamou ipwanos yiy para kiya namnam kiyapolo yiy. Pwen Yesu iya nondriya suwen, pe iyeroh ngilse keyau. ");
INSERT INTO nss_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hapeko Parisiy ara, ara inimei tehe Yesu kinsungani niman kimu pwi, pe inamnam; pwen ilohonge soyon. ");
INSERT INTO nss_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pwen pe Yapan ipwai iya kili yiy, ipa, <<Wawu Parisiy ara ngara wawu kasungani ngawan para pweniu pe para pirou, hapeko nondriya wawu ara ipep iya mwolou pe hu kultuw pwassin masih. ");
INSERT INTO nss_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lohonga wawu pwi! Yiy mepo imangsani ngawan para hu melit, ara imangsani nondriya hu melit tehen aliy yi, ndre? ");
INSERT INTO nss_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Hapeko aiki sehe melit mepo ita nondriya pwelekei kiya kili hu mepo hundroisiy, pwen pe meltam masih andre kiro howen. ");
INSERT INTO nss_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Wawu Parisiy, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, wawu taingani melit tehe koyo pe parahiy pe hu kaimbuwe kei para piyang handra-handra mendreheh tehen tora kiya masongui, pe ngara akaiki hape para aliy kiya kili Ngindrai tehe yukyuk tawawu. Hapeko wawu ngara katali kultuw imwonen, pe kultuw para kambuluhi Ngindrai. Hiyan para wawu koro ndruwa hu kultuw hiyan namandran tehen tora, pe koyu wawu mbuna kirut hu melit mendre-mendreheh ara yi. ");
INSERT INTO nss_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Wawu Parisiy, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, wawu namiliy para korompwan pwapwai hiyan hu ndramat ngara hu kahaiyaniy nondriya hu yumwa mbultere tahu Yuta , pe wawu namiliy para hu ndramat karawulohani wawu koro hu ndroho pehei. ");
INSERT INTO nss_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Toimwa wawu; nopwaran ita ndrita wawu. Wawu ara tehe hu ndrohonoku tona ndramat mepo yihu ndramat kanyirowe ndraikiya hu pwi, pe ngara hu karakai ndritahu.>> ");
INSERT INTO nss_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pwen ndramat hamou ipahas iya nongan para pwahanou isomwi Yesu, ipa, <<Ndramat para Hinonou, nongan masih mepo atapwai iya kili hu Parisiy, ara ipwasimiri yowu yi.>> ");
INSERT INTO nss_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pwen Yesu isomwi yiy, ipa, <<Wawu ndramat hiyeh wawu pahas iya nongan para pwahanou, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, ngara wawu kaiki nopwaran kiya ndrita hu ndramat pe ipworu hu, pe hu tora ngandrah para kuniyan. Pe wawu mbukena wawu, ara wele wawu kinho so para wawu kaiki ndrakopwenima wawu hakip para kasopwat hu, ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Toimwa wawu; nopwaran ita ndrita wawu, paratesah, wawu sondritiyani ngarehu hu poropet, pe tumbu wawu hu, ara hu kanitingundruhu. ");
INSERT INTO nss_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pwen wawu yinganiy tehe kultuwayi tumbu wawu hu mepo hu kanmbusiy, ara wawu pa ndre hiyan, tehe hutingundru hu poropet, pe wawu tora sondritiyani ngarehu. ");
INSERT INTO nss_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pwen tehen tora ko, nondriya lohongai waison ta Ngindrai, yiy kinpwai toro: <Yo andre kupwandrisa yihu poropet pe yihu aposel para hu kaya kili hu, pe hayah tahu andre hu katingundruhu, pe hayah tahu andre hu karandroyani hu.> ");
INSERT INTO nss_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pwen pe yihu ndramira hasap para mahapo, ara andre hu kakuni kora ndreye hu poropet masih kene mepo hu kanitingundruhu, iro tandrohonga kol pwan irayah, ipoo isa matnen mahapo. ");
INSERT INTO nss_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pe iro kili ndreye Apel imuw, ipoo isa matne ndreye Sekarayah imuw, mepo hu kanitingundrun iho mwalinga pere tuntun pe yumwa totohun ara—yo upwai isa kili wawu tehe hu ndramira hasap para mahapo, andre hu kakuni kora melit masih kene ara. ");
INSERT INTO nss_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wawu ndramat hiyeh wawu pahas iya nongan para pwahanou, ara toimwa wawu; nopwaran ita ndrita wawu, paratesah, wawu kanwiri kiy para papai para kaya nondriya lohongai hiyan, ara kinna mawen. Wawu mbukena wawu, ara mbuwali wawu para akaya nondriyan, hapeko yihu mepo hunamiliy para hu kasong kaya nondriyan, ara wawu tora singori hu yi.>> ");
INSERT INTO nss_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pwen Yesu itali seu ara, pe yihu Parisiy pe yihu ndramat hupahas iya nongan para pwahanou, ara hurasisingat anan pwokeyan iya, pe huro sok yiy iya hu soksok handra-handra iyapolo ndrangsai, ");
INSERT INTO nss_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","para hu pakaratuni yiy para kipa hapesah, pwen pe hu kalahiy para hu kaiki yiy kiya nongan. ");
INSERT INTO nss_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pwen iro lang ara ko, hu ndramat sopou-sopou husa tawurehu pe huro tandrapndrap, pe huro rahatuwe pwelekahu hamou-hamou. Pwen Yesu iwong imu iya kili ndramiran hu, ipa, <<Akoro rapapahan kiya yis tahu Parisiy. Yis ara, ara iyingani pwandrandraman tahu. ");
INSERT INTO nss_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pe sehe melit mepo hu ndramat kantamburuhiy ita, ara andre Ngindrai kirehei. Pe sehe melit ita kohon pe kanpahasaniy pwi, ara andre kisa yelan ngawan. ");
INSERT INTO nss_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pwen pe sehe nongan wawu kapwai kiro lokuhan, ara akapohowei kiro ngana lang. Pe sehe nongan wawu kanpahulhun kinna aliy, kinna ndrainga hamou kiro mbulkura hu seu, ara andre kapwaharai kiho payandroha hu seu. ");
INSERT INTO nss_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wawu kowase, upwai isa kili wawu, tehe wawu mbuna akanoh tahu mepo hulahiy para katingundru nombuwe wawu, pe kiyamulan, andre yihu kanlahiy para hu kapo suran pwi yi. ");
INSERT INTO nss_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hapeko nakupwainganiy kisa kili wawu sehe ndramat para akoro nohowani yiy. Kapa hu katingundru nombuwe wawu, ara konan. Hapeko akanohowani Ngindrai, yiy mepo kamulan para kimat ta wawu, ara pwoke nopwaran hira kili yiy para kipiyani wawu kaya nondriya ngat mepo mwan itayat aliy. Ndrokonan, upwai isa kili wawu tehe akoro nohowani yiy ara ko. ");
INSERT INTO nss_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wawu pahasaniy tehe hu norupep mayimou, ara andre hu ndramat kapo pehei kiya tahu, kiya sombule pat malmbut, ndre? Hapeko Ngindrai ara koyun kinoho mayit kinnata hamou tahu pwi. ");
INSERT INTO nss_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pe tehen aliy i, hu kompai hutora paya wawu, ara Ngindrai kindromwahu topwei. Pwen wawu mbuna akanoh, wawu ho hin iya, iyata hu norupep soyon. ");
INSERT INTO nss_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yo upwai isa kili wawu tehe, sehe ndramat ngara kiwong ngawan kiro mbulmara hu ndramat tehe yiy ndramiro, ara andre Noru Ndramat kiwong ngawan kiro mbulmara hu angelou ta Ngindrai, tehe yiy ara ndramiran. ");
INSERT INTO nss_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pe kapa hiyeh ngara kipwai tehe ikowu to kiro mbulmara hu ndramat, ara andre kupwai tehe ukowu tan, kiro mbulmara hu angelou ata Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pe kapa hiyeh kipwasisiman ana Noru Ndramat, ara andre Ngindrai kitali pakut mwomwan atan; hapeko kapa hiyeh kipwasisiman ana Mwoiwan Haiyan, ara andre Ngindrai kintali mwomwan tan pwi. ");
INSERT INTO nss_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pe kapa hu nakaiki wawu kaya nongan koro nondriya hu yumwa multere, pe kaya mbulmara hu pohon para kol pe hu yapane kol, ara mbuna akalohonge soyon kiya sehe nongan para wawu nakapenani wawu kaliy, ");
INSERT INTO nss_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","paratesah, kiro mwonen paramwandrai ara, Mwoiwan Haiyan andre kihinuwani wawu, kiya sehe nongan imwonen para wawu nakapwai.>> ");
INSERT INTO nss_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pwen ndramat hamou iro mwalinga hu ndramat soyon ara ipwai iya kili Yesu, ipa, <<Ndramat para Hinonou, apwai kiya kili nali para kirahihiri hu memelit ta tama youlu kiho mwalinga youlu.>> ");
INSERT INTO nss_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pwen Yesu isomwi yiy, ipa, <<Tehen tapeh? Sehe ndramat irakinimo para kurayah ndramat para tanonoye ndre ndramat para tamwanye ndrokolo walu?>> ");
INSERT INTO nss_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pwen ipwai iya kili hu, ipa, <<Mara wawu kiro! Pe akoro hinehes. Matisan wou ahamwolou kiya hu melit soyon handra-handra. Ndramat hamou mepo menmenan soyon, ara kinlahiy para kiwiri taleh kiyau kili hu meltan, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pwen itiyani nongan pwandritiye iya kili hu, ipa toro: <<Pinge ndramat hamou menmenan soyon, ara hu anandrinai para aliy ara hurayah soyon iya. ");
INSERT INTO nss_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pwen yiy mbukenan iro lohonge, ipa, <Andre kumbusi tapeh? Hape kaisowa anandrinai to para kuratto hu koro aliy, ara pwi.> ");
INSERT INTO nss_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pwen ipa, <Yo andre kumbusiy tehe toro: andre kuloiwani hu kaisowa anandrinai ato, pe kupulihu kaya namandran, pwen andre kuratto hu mbuwa wit to pe hu memelit to hiyan hu koro aliy. ");
INSERT INTO nss_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pe andre kupwai kisato mbukeno, kupa, <<Menmeno ara hu kanna soyon iya hutopo, pe ilahiy para kiwiri yo hayou hitun iya hu tora po husa. Pwen andre kuro mwoimwoi o, pe kuro namnam pe kuro yin ndran pe kuro pwes.>> > ");
INSERT INTO nss_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hapeko Ngindrai ipwai iya kili yiy, ipa, <Payam kinmbui! Kiro mahapo kiping o, andre mwoiwam kitali wou. Pwen hiyeh ndrokonan andre kiwiri memelit masih kene atam, mepo anmwaniyani hu pwen tora.> ");
INSERT INTO nss_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aro ara iyingani tesah nakirayah kiya kili hiyeh iratto memelit soyon atan mbukenan, hapeko iya mbulmara Ngindrai, ara yiy ndramat menmenan soyon pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu ipwai iya kili ndramiran hu, ipa, <<Upwai isa kili wawu, lohonga wawu mbuna kimwa kiya mipwan tawawu, kiya tesah wawu andre kayan, ndre kiya tesah wawu nakasuluye wawu kiya aliy. ");
INSERT INTO nss_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mwoiwa wawu ara iramwaitini anandrinai, pe nombuwe wawu ara iramwaitini koyau. ");
INSERT INTO nss_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Akayirowe hu pihinan: yihu konhohas, pe hu konhopo anandrinai pwi. Pe kaisowa anandrinahu ara pwi yi. Hapeko Ngindrai ngara kihang hu anandrinai manau. Pe wawu ndramat, ara wawu ho hin iyata hu norukan. ");
INSERT INTO nss_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hiyeh tawawu, kapa lohongan kimwa, ara ilahiy para kiposura lenge mwoiwan kiya niwen hape? ");
INSERT INTO nss_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pe kapa wawu kanlahiy para kambusi melit mbuskau aro pwi, pwen tehen tapeh pe lohonga wawu imwa iya hu memelit masih ara. ");
INSERT INTO nss_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Akayirowe hu nonou hu tora lek tapeh. Yihu konhopo mbulen pwi, pe hu konho mangse koiwehu pwi. Hapeko upwai isa kili wawu tehe nowiya nosa Solomon masih lahayan iya, ara kintamwatini lahaya hu nonou iye pwi yoh. ");
INSERT INTO nss_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Akanimei; Ngindrai ngara kinowi hu ndromwindriu para piyang tehen tora, mepo topo lang nepo ko, pe kiya moh, ara andre kapiyani hu kaya nondriya mwan. Pwen wawu pahasaniy ndrokonan tehe Ngindrai andre kinowi wawu kiramwaitini nowiya hu nonou ara, ndre? Wawu tana wawu tehe ara ndrokonan, konan kapa lohonga wawu ndrisiyon, ara mulai opu. ");
INSERT INTO nss_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pe lohonga wawu mbuna kimwa kiya sehe anandrinai para wawu nakayan, ndre sehe ndran para wawu nakayin; ara wawu mbuna akanimanga hu melit ara. ");
INSERT INTO nss_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yihu ndramat para kol pwan masih, ara yihu ngara hu kanimanga hu melit tora. Hapeko namiliwa wawu iya hu melit tehe ndran pe anandrinai, ara Tama wawu kinpahasaniy pwen. ");
INSERT INTO nss_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hapeko wawu katele kolo king Ngindrai kimu, pwen hu melit aro, ara andre kihang wawu yi. ");
INSERT INTO nss_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wawu ndrokoyirayi sipsip hapat mendreheh, wawu mbuna akanoh. Tama wawu, ara kinlohonganiy pwen tehe andre kipwes para kiyki kolo King Ngindrai kisata wawu. ");
INSERT INTO nss_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akapo pehei kiya hu menmena wawu, pe akaiki sombule pat para aliy, ara kiyata hu ndramat mepo hundroisiy. Pe akapo hu ndropwa sombule pat para kol paingan yang, mepo andre kinimut pwi. Pe akaratto hu melit lahayan para kol paingan yang, mepo andre kinwenei para kihipwen pwi, pe hu ndramat para pahana kanwenei para kapahanowei pwi, pe hu selei kanwenei para kaseleyani hu pwi. ");
INSERT INTO nss_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Paratesah, hape aleheh mepo menmena wawu lahayan ita aliy, ara ndriya wawu andre kiro aliy yi. ");
INSERT INTO nss_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Akasuluye wawu pe kawasi tisingi kundrayi wawu, pe hu suya wawu ara hu koro yat, pe akoro hinehes para mbulen. ");
INSERT INTO nss_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pe akoro tehe hu ndramat hutora longe namandran tahu ita kowase yon para yesou sih, pe andre kimui kisa. Pwen kapa kimui pe kiralikiri papai, kindrou pwi ko, andre hu katipe papai kiya kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pe kapa namandran tahu kimui kisa pe kinimei tehe hu ndramat para poya mbulyan hu koro hinehes, ara andre hu koro hiyan. Yo upwai ndrokonan isa kili wawu, tehe namandran mbukenan andre kisuluye yiy pe andre kipwai kiya kili hu para hu karoh keye ngilse keyau, pe andre kisa pe kihang hu anandrinai. ");
INSERT INTO nss_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pe hu ndramat para poya mbulen mepo namandran tahu isa pe iyirowei tehe huro hinehes, konan kisa kiho ndrokolo put ndre pakeh lang, ara andre hu koro hiyan. ");
INSERT INTO nss_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hapeko lohonga wawu kileu kiya nongan aro: Kapa mbukena seu kinpahasaniy pwen kimu iya sehe paramwandrai ndramat para pahana nakisa, pwen suwen ara andre kinlahiy para hamou kitumbuwei pe kiya nondriyan pwi. ");
INSERT INTO nss_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pwen wawu yi, ara akoro hinehes, paratesah, Noru Ndramat nakisa, ara andre kiho nondriya paramwandrai mepo wawu kowu para nakisa kaliy.>> ");
INSERT INTO nss_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pwen Pita isok Yesu, ipa, <<Yapan, nongan pwandritiye atatiyaniy ara, ara isa kili yowu ko, ndre iya kili yihu ndramat masih i?>> ");
INSERT INTO nss_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pwen Yapan isomwiy, ipa, <<Hiyeh ara pohon para mbulen, mepo maran pahalan pe lohongan waison? Namandran ata ndramat tehen tora, andre kiyki yiy para kiro nimnim kiyata hu ndramat para poya mbulen, pe para kiro hang hu anandrinai kiho mwonen paramwandrai para yukuya anandrinai. ");
INSERT INTO nss_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hiyan masih kapa ndramat para poya mbulen ara, ara namandran tan kimui kisa, pe kinimei tehe yiy iropo mbulyan. ");
INSERT INTO nss_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Upwai ndrokonan isa kili wawu, tehe namandran tan andre kiyki yiy kiro nimnim kiya hu menmenan masih kene. ");
INSERT INTO nss_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hapeko, kapa ndramat para poho mbulen ara kipanguluwaniy kiyatan mbukenan, kipa, <Namandran to, ara ita mawen ndrangan niwen iya pe kinsa mapu,> pe kapa kirandroyani hu kamai pe hu pihin para poya mbulen, pe kiro namnam pe kiro yin ndran tunguyan pe maran kimbui, ");
INSERT INTO nss_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","pwen namandran ta ndramat para poya mbulen ara, ara andre kisa kiho nondriya lang mepo ikowu iya aliy, pe kiho nondriya paramwandrai mepo kinpahas kinna aliy pwi. Pe andre namandran tan kiringi yiy kiya mendre-mendreheh, pe kiyaiki yiy kiya polo hu mepo hu kanpwotisingi lohongahu pwi. ");
INSERT INTO nss_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ndramat para poya mbulen mepo kinpahasani namiliwa namandran tan, hapeko kinto hinehes pe kinmbusi namiliwa namandran tan pwi, ara andre namandran tan kimwahi tisingi yiy. ");
INSERT INTO nss_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hapeko ndramat mepo kinpahasani namiliwa namandran tan pwi, pe imbusi melit mepo ilahiy kiwiri koran kaliy, pwen namandran tan, ara andre kimwahi yiy kiho mwak o. Pe kapa ndramat kiwiri melit soyon, ara andre kiyuk melit soyon tehen aliy yi. Pe kapa hu ndramat kaiki melit soyon kiya nima hamou, pwen soiwin hu nakasok para kimui, ara andre kiho hin pe kiramwaitiniy. ");
INSERT INTO nss_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yo usa, ara para kusa piyani mwan kisa kol pwan; pe kapa mwan kinsayat pwen, ara hiyan. ");
INSERT INTO nss_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pe yo andre kuya nondriya paptais sih, mepo mapu kunna nondriyan, hapeko nopwaran para aliy, ara iripo poruwi yo, kipoo kuya pwosomwiliy. ");
INSERT INTO nss_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Upwai isa kili wawu, wawu pa ndre yo usarayah usa kol pwan, ara para kusaiki ndriya wayis, ndre? Pwi! Usa, ara para kumbusi wawu kamasilpat. ");
INSERT INTO nss_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kiro mahapo kiya, andre hu mayimou para nondriya ndraisih andre hu kamasilpat kaya malpat. Hu matimou andre kahangas ana hilu malmou, pe hilu malmou andre kahangas ana hu matimou. ");
INSERT INTO nss_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Andre hu kamasilpat; taman andre kihingas ana norun kamai, pe norun kamai andre kihingas ana taman. Pe tinan andre kihingas ana norun pihin, pe norun pihin andre kihingas ana tinan. Pe mbuyungundran andre kihingas ana mbuyunorun. Pe mbuyunorun andre kihingas ana mbuyungundran.>> ");
INSERT INTO nss_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pwen Yesu ipwai iya kili hu ndramat soyon, ipa, <<Kapa wawu kanime mburah kingas te rai kisa, hape pwi ko, wawu pa, <Andre mbulou kindrut.> Pwen o ngara kindrut. ");
INSERT INTO nss_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe kapa nohai kimum kiyau te tolau kisa, wawu ngara kapa, <Andre mwandrai kising.> Pwen o ngara kising. ");
INSERT INTO nss_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wawu ndramat para pwandrandraman! Wawu ya hiyan para karanonoye kaipisa melit para kol pwan pe para yang. Pe paratapeh pe wawu kanpahasaniy para karanonoye ndroiyi hu melit, hutopo rayah lang mahapo pwi? ");
INSERT INTO nss_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Paratapeh pe wawu mbukena wawu kanpahasaniy para kaharani kultuw hiyan pwi? ");
INSERT INTO nss_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kapa wou pe ndramat mepo irakokowai isapolo wou, ara walu nakaya kili ndramat para tamwanye, ara walu koho ndron sai pe ahanonou pwokeyan para aramwanye kiyapolo yiy. Kapa pwi, andre kiluwi tarahani wou kiya mbulmara ndramat para tamwanye, pe ndramat para tamwanye ara andre kiyki wou aya nima makundrayin, pe makundrayin kipiyani wou aya nondriya kou. ");
INSERT INTO nss_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Upwai isa kili wou, tehe wou andre ansa ngawan nondriya kou pwi, kipoo aiki sombule pat masih mepo hu kanpwai kinsa kili wou para aikiy.>> ");
INSERT INTO nss_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesu ipohowe nongan ihipwen, pwen yihu ndramat hayah huro ara, ara hunese ndraingan iya kili hu ndramat hayah para Kaliliy mepo Pailat kinitingundruhu. Pailat kinpwai kinna kili hu ndram tan para hu katingundru hu ndramat ara, iro mwonen huro mbusi yukyuk iya kili Ngindrai. Pwen ndreyehu, ara imuw iya ndrita ndreye hu kan para yukyuk. ");
INSERT INTO nss_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pe Yesu isomwi hu, ipa, <<Wawu, wawu pa ndre hu ndramira Kaliliy mepo hukuni nopwaran ara, pakut tahu mwomwan iramwaitiniy tahu para Kaliliy masih, pwen tunan ara ko, pe hukuni koran, ndre? ");
INSERT INTO nss_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yo upwai isa kili wawu: pwi yoh! Pe kapa akantapaiwani ndriya wawu pwi, pwen andre wawu masih kamat tehen aliy o. ");
INSERT INTO nss_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pe yihu ndramat songui pe androlmou ara, mepo huro seu sohokan niwen iro Silowam, pe iput pe irahatuwe hu pe humat, ara wawu pa ndre kultuw mwomwan tahu ara iramwaitini kultuw mwomwan tahu masih hiyeh hutora Yerusalem? ");
INSERT INTO nss_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pwi yoh! Upwai isa kili wawu tehe kapa akantapaiwani ndriya wawu pwi, pwen andre wawu masih kamat tehen aliy o.>> ");
INSERT INTO nss_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pwen Yesu itiyani nongan pwandritiye sahin i, ipa, <<Ndramat hamou ihisi kei pik hakou iro pingen, pe iyamulan iya aliy para kiyaten mbuwan, hapeko iya pe kinnime mbuwan sih pwi. ");
INSERT INTO nss_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pwen pe ipwai iya kili ndramat mepo iro pwokere pingen ara, ipa, <Yo kunsa hayou maroyoh pwen, pe usa nimei tehe pik iye, ara kinippwai pwi ko. Katihiy kiyau! Paratesah ita pe ita wiri pwoke para pwan?> ");
INSERT INTO nss_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pwen ndramat ara isomwi yiy, ipa, <Namandran, aikiy kihou hayou sih na, pe andre kuro talon pwan kurakayani ndroiyin, pe kurorahun ndre tutut kiya aliy. ");
INSERT INTO nss_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pwen kapa kippwai hayou mulan, konan, kihou! Pe kapa pwi, pwen atihiy kiya pwan.> >> ");
INSERT INTO nss_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iho nondriya lang Sapat sih, Yesu iro hinuwani hu ndramat iro nondriya yumwa multere hawum. ");
INSERT INTO nss_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pe pihin hamou iro ara, ara payit iro ndritan hayou songui pe androlwoh, pe payit ara ihikuwani ndruwin pe kinlahiy para kintandras pwi masih. ");
INSERT INTO nss_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pwen Yesu inime yiy, pe iyoh pihin ara isa kili yiy, pe ipa, <<Nam, nopwaran tam kinnau, pe aningoh.>> ");
INSERT INTO nss_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pwen Yesu iyki niman iya ndritan, pe hape pwi ko, pihin ara itandras pe itine imwonen pe ihiri ngala Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pwen pohon para yumwa mbultere tahu Yuta, ara ndrinan ilokuh, paratesah, Yesu isopwoyani pihin ara iro mwonen lang Sapat. Pwen ipwai iya kili hu ndramat, ipa, <<Lang manonoh ara lenge mbulen, pwen wawu kasa pe kisopwoyani wawu kiho nondriya hu lang ara, hapeko kiro mwonen lang Sapat, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pe Yapan isomwi yiy, ipa, <<Wawu ndramat para pwandrandraman! Wawu ngara katali hu mbulmwakau ndre hu tongkiy tawawu kiho nondriya lang Sapat, pe kasa mawen yumwahu, pe kaluwani hu kaya para kahang hu ndran, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pe tapeh, pihin aro ara yiy noru Apraham hamou. Pe Sinai, ara iro ndritan hayou songui pe androlwoh. Pwen, ilahiy para kutali melit mepo iwasi yiy, kiyau kiya mawen kili yiy kiho nondriya lang Sapat, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu iwong tehen tora ihipwen, pwen hu ndramat mepo hurasisingat anan, ara humasi turuwehu. Hapeko hu ndramat masih, ara hupwes iya hu melit hiyan masih iro mbusiy. ");
INSERT INTO nss_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pwen Yesu isok, ipa <<Kultuwayi kolo King Ngindrai ara tehen tapeh? Pe andre kuranonoye kaliy kiya tesah? ");
INSERT INTO nss_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ara tehe peke mbuwa mastet sih, mepo ndramat hamou iwiriy pe ipiyaniy iya pingen. Pwen ilek pe irayah kei hakou namandran, pe hu norukan para wohowoh hupun yumwahu huho ndrandran.>> ");
INSERT INTO nss_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pwen Yesu isok paiwe, ipa, <<Sehe melit ndrokonan andre kuranonoye kaliy kiya kultuwayi kolo King Ngindrai? ");
INSERT INTO nss_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ara tehe yis mepo pihin hamou isuluyaniy iya palawa soyon iya, kipoo yis ara kisilihi palawa masih.>> ");
INSERT INTO nss_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pwen Yesu iro tokai nakiya Yerusalem, pe iho nondriya tokuyan ara, ara iya nondriya hu kol ngawan pe hu kol mendreheh, hakol iya hakol, pe iro hinuwani hu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pwen ndramat hamou isok yiy, ipa, <<Yapan, Ngindrai andre kisopwat hu ndramat hayah opu, ndre?>> Pe Yesu ipwai iya kili hu ipa, ");
INSERT INTO nss_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Wawu karapwopwoke, para akaya nondriya karam mendreheh. Yo upwai isa kili wawu tehen toro, paratesah, andre hu ndramat soyon pakanohonou para kaya nondriyan, hapeko andre hu kanlahiy pwi. ");
INSERT INTO nss_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kapa mbukena seu kitine pe kiwari papai, pwen andre wawu koro tine ngawan pe akaralikiri papai, pe andre arakamam pe andre akapa, <Namandran, atipe papai kili yowu.> Hapeko andre kisomwi wawu, kipa, <Yo ukowu tawawu, pe tono hapeleheh wawu yau aliy wawu sa pwi.> ");
INSERT INTO nss_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pwen andre wawu kapwai, kapa, <Yowu kannamnam pe yowu kanyin ndran kinnasura wou, pe anhinuwani yowu iho mwalinga hu payango sai towu.> ");
INSERT INTO nss_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hapeko andre kisomwi wawu, kipa, <Yo ukowu tawawu, pe tono hapeleheh wawu yau aliy wawu sa pwi. Wawu ndramat para tandroindroi, akaya mawen kili yo!> ");
INSERT INTO nss_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pwen wawu andre kanime Apraham, Yisak, pe Yakop pe yihu poropet masih kene koro nondriya kolo King Ngindrai; hapeko wawu, ara andre hu kapiyani wawu kaya ngawan, pe andre akarang memesun pe andre akayan ndrisingi kolta wawu. ");
INSERT INTO nss_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yihu ndramat andre hu kapwen te kup pe rai pe hai pe tolau hu kasa, pe andre hu kampwan ndrohonokuhu, koro nondriya yon namandran, koro nondriya kolo King Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Akahilingiy, hu hiyeh hutora mulan, ara andre hu kaya mu, pe hu hiyeh hutora mu, ara andre hu kaya mulan.>> ");
INSERT INTO nss_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iro nondriya hu lang ara, hu Parisiy hayah husa kili Yesu pe hupwai iya kili yiy, hupa, <<Atali kol iye pe ayau aya hape mawen, paratesah, Herot pakitingundrum.>> ");
INSERT INTO nss_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pwen isomwiy ipa, <<Akaya pe akapwai kiya kili mwiy puyap ara toro: <Nepo pe moh andre kurapiyani hu payit pe kusopwoyani hu ndramat, pe kiho mwonen lang maroyoh, andre kumbusi mbulyo kisahapwen.> ");
INSERT INTO nss_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yo andre kuro wayaniy manau, lang nepo pe moh pe liping, paratesah, andre poropet hamou kinho mat kinna ngawan para Yerusalem pwi. ");
INSERT INTO nss_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Yerusalem, Yerusalem! Wawu mepo wawu ngara katingundru hu poropet, pe hu ndramat mepo Ngindrai ipwandrisa hu husa kili wawu, ara ngara akasolpwa hu kaya pat. Lang hitun ara ndriyo inamiliy para kurawurani noru wawu hu kasawule, tehe tutut pihin hamou ngara kipwokarani norun hu, koro pahandra kapenen. Hapeko wawu ngara kahambuwali wawu. ");
INSERT INTO nss_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akahilingiy, kolo wawu kinna mwomwan pe kinna marakah. Yo upwai isa kili wawu tehe andre akannime yo paiwe pwi, kipoo akapa, <Lomwes ita kili yiy mepo isa iya ngala Yapan.> >> ");
INSERT INTO nss_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lang Sapat sih, Yesu iya namnam iya suwe namandran hamou tahu Parisiy, pe hu ndramat huro ara, ara marahu iro nime sayani yiy. ");
INSERT INTO nss_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pe ndramat hamou iro pakeh mbulmara Yesu, ara mandran isama. ");
INSERT INTO nss_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pwen Yesu isike yihu ndramat lohongahu ipahas iya nongan para pwahanou pe yihu Parisiy, ara ipa, <<Nongan para pwahanou ipa hiyan para tukasopwoyani hu ndramat kaya hiyan kiho nondriya lang Sapat, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hapeko huhun o huro. Pwen Yesu imbultuwe ndramat ara, pe isopwoyani yiy iya hiyan, pe ipwandrisa yiy iyau. ");
INSERT INTO nss_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pwen isok hu, ipa, <<Kapa hamou tawawu, norun kamai ndre mbulmwakau tan hamou kiyos kiya nondriya ndrikou soso hangai kiho mwonen lang Sapat, pwen andre kindrou pwi ko wou aya pe ayaluwi yiy kisa ngawan, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pe yihu kanlahiy para kapa nongan sahin pwi. ");
INSERT INTO nss_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pe Yesu iyirowei tehe hu ndramat mepo ndramat ara kinpwanos hu para hu kasa namnam, ara hupire ndrohonokuhu para mipwan ndrahasa keyau, iro mu iyata hu hayah. Pwen Yesu iwong nongan pwandritiye toro: ");
INSERT INTO nss_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Kapa ndramat hamou kinpwanos wou para aya kowase yesou tan, ara mbuna aya mipwan ndrohonoku mipwan hira mu, matisan kinpwanos pwen kinnata ndramat hamou mepo mangalan pe ihohin isatam. ");
INSERT INTO nss_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pwen ndramat mepo ipwanos wou iyapolo ndramat mepo mangalan ara, para walu malmou kene kasa, ara andre kisa pe kipwai kisa kili wou, kipa, <Aiki ndrohonoku pwanpwan mepo amirampwan aliy iripo mu iye, kiya kili yiy.> Pwen andre arakai ayau, ayapolo masirai, pe aya mipwan ndruwan masih. ");
INSERT INTO nss_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hapeko kapa hu kanpwanos wou para asa namnam, ara aya pire ndrohonokum aya ndruwan masih. Pwen kapa mbukena kowase yesou kisa, ara andre kipwai kisa kili wou, kipa, <Kowase, atali ndrohonoku mipwan tam ara, pe asa pe aya wiri ndrohonoku mipwan tam hiyan hira mu.> Pwen andre kihaiyani wou kiro mbulmara hu ndramat masih ipwanos hu, pe husa ara. ");
INSERT INTO nss_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pe hiyeh pakisap ngalan mbukenan, ara andre ngalan kiya pwi. Pe hiyeh kiyki yiy kiya pwan, ara andre Ngindrai kihiri ngalan kiya paingan.>> ");
INSERT INTO nss_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pwen Yesu ipwai iya kili ndramat mepo ipwanos yiy, ara ipa, <<Kapa namangse yon, ara mbuna apwanos kowasem hu, pe nalim hu, pe yowem hu, pe hu ndramat menmenahu soyon mepo hutora pakeh kili wou. Kapa ambusiy tehen tora, pwen matisan hu kapwanos wou pe hu kapo soiwin kimui kisa kili wou. ");
INSERT INTO nss_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Konan. Kapa namangse yon, ara apwanos hu ndramat menmenahu pwi, pe hu ndramat mandrahu imat, pe hu ndramat ndrikahu mwomwan, pe hu ndramat marahu iyoh, ");
INSERT INTO nss_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","pwen andre awiri lomwes kiyau aliy. Yihu ndramat tora kene, ara hu kanlahiy para kapo soiwin pwi. Konan. Andre Ngindrai kipo soiwin kiro lang mepo hu ndramat imwonen, hu kasa tine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pwen ndramat hamou imi ndrahasa keyau iyapolo Yesu, ara ihilingiy, pwen ipwai iya kili Yesu, ipa, <<Ndramat mepo andre kinamnam kiro yon namandran kiro kolo King Ngindrai, ara andre kipwes.>> ");
INSERT INTO nss_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hapeko Yesu itiyani nongan pwandritiye, ipa, <<Ndramat hamou nakipo yon namandran. Pwen iro mwaniyaniy, pe ipwanos hu ndramat soyon para hu kasa. ");
INSERT INTO nss_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pwen isa rahihini lang para yon, pwen ipwandrisa ndramat para poya mbulyan, para kiya pwai kiya kili hu ndramat mepo kinpwanos hu pwen para hu kasa ara, ara kipa, <Akasa, melit masih kinmwoimwoi pwen iripo.> ");
INSERT INTO nss_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hapeko yihu ndramat masih ara, ara hamou-hamou tahu hupa husoltere. Ndramat hamou ipa, <Yo kunsowani piyang hambut, pe andre kuya nimei na. Pwen pe usok wou, kapa apa hiyan sato para andre kunto pwi.> ");
INSERT INTO nss_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pe ndramat hamou i ipa, <Yo kunsowani mbulmwakau to masongui, ma ndrokomwayit mayimwat; pwen andre kuya pe kunohonou hu kiya mbulen na. Pwen pe usok wou, kapa apa hiyan sato para andre kunto pwi.> ");
INSERT INTO nss_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pe hamou i ipa, <Yo ara mahapo ko uyesou uwiri pihin hamou, pwen tunan ara ko, pe kunlahiy para kusa pwi.> ");
INSERT INTO nss_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pwen ndramat para poya mbulyan, ara imui iya pe iya tiyaniy iya kili namandran tan. Pwen mbukena seu ara ndrinan ilokuh, pe ipwandrandrahani yiy, ipa, <Ahaleh aya hu sai masih, pe hu meresai mendreheh para kol ngawan. Pwen awiri hu ndramat menmenahu pwi, pe hu ndramat mandrahu imat, pe hu ndramat ndrikahu mwomwan, pe hu ndramat marahu iyoh, ara hu kasa.> ");
INSERT INTO nss_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pwen ndramat para poya mbulyan ipa, <Namandran, tesah anpwandrandrahani yo kinna aliy, ara kunmbusiy, hapeko honga nondriya seu, ara iripo ndron.> ");
INSERT INTO nss_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pwen namandran tan ipwai iya kili yiy, ipa, <Amui aya hu sai masih, pe aya hu meresai mendre-mendreheh para hu kol hakol-hakol, pe arandrokomarahu para hu kasa; pwen andre nondriya suwe kipep. ");
INSERT INTO nss_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Upwai isa kili wawu, andre hamou tahu ndramat mepo kunpwanos hu mamu para hu kasa ara, ara andre hu kanyan hape ndritike yon to pwi.> >> ");
INSERT INTO nss_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hu ndramat soyo-soyon iya huro tokai iyapolo Yesu. Pwen ipaiwani yiy iya kili hu, pe ipa: ");
INSERT INTO nss_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Kapa ndramat hamou pakisa kili yo, hapeko kinmwisnani taman hilu tinan pwi, pe kinmwisnani nambuyun pe norun pwi, pe kinmwisnani nalin pe pisun pwi, pe kinmwisnani mwoiwan mbukenan pwi, ara andre kinlahiy para kirayah ndramiro pwi. ");
INSERT INTO nss_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pe kapa ndramat hamou kinkun kei tondrih tan pe kinho ndruwo pwi, ara kinlahiy para kirayah ndramiro pwi. ");
INSERT INTO nss_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kapa hamou tawawu pakipun seu hawum sohun niwen para memere, ara andre kimpwan na, pe kindring lohongai para kinimei tehe sombule pat tan, ara ilahiy para kipun suwen kiya hapwen, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pe kapa kimwaniyani ndrohonoku seu, pe kinsoyei hape, hapeko kinlahiy para kipuliy kiyahapwen pwi, pwen hu ndramat masih andre hu kanimei pe hu kapwasimiri yiy. ");
INSERT INTO nss_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pwen andre hu kapa, <Ndramat aro, ara isoye suwen hape, hapeko kinlahiy para kipuliy kiyahapwen pwi.> ");
INSERT INTO nss_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pe kapa king hamou pakiyapo pahun kiya kili king hamou, ara andre kimpwan pe kindring lohongai na, tehe ndramiran hu mapusongui (10,000) hulahiy para kayapo pahun kaya kili hu ndram mapulungui (20,000) ata king hamou ara, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pe kapa lohongan kipa tehe hu kanlahiy pwi, pwen andre kipwanos nongan kiya kili king hamou ara, para kikaituwe yiy, ma ndramiran hu huyera ndron mwanan, pe kisok king ara para hilu karapaniu pe kona pahun. ");
INSERT INTO nss_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pwen tehen tora ko, kapa hamou tawawu kiniyki ndruwan kinna melit tan masih pwi, ara andre kinlahiy para kirayah ndramiro pwi. ");
INSERT INTO nss_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ndras para kanyai ara hiyan, hapeko kapa kankanan kiya pwi, pwen andre tukambusi kanan kimui tapeh? ");
INSERT INTO nss_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pwen ndras tora, ara kinlahiy para kasuluyaniy kiya polo lohulohu pwan, ara pwi. Pe kinlahiy para kasuluyaniy kiya polo ndre tutut para kaikiy kiya piyang, ara pwi yi. Ndras tora, ara andre karahaliy kiyau o mwaihei. Hiyeh mandraingan, ara kihilingi nongan iye.>> ");
INSERT INTO nss_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hu ndramat para poya takis, pe hu ndramat mepo pakut tahu mwomwan, ara hu masih husa mbultere hu, pe hurahakowa Yesu para hu kahalong nongnan. ");
INSERT INTO nss_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hapeko yihu Parisiy pe hu ndramat para hinuwani nongan para pwahanou, ara ndriyahu isin, pe huro panguluwaniy mwalingahu, huro pa, <<Ndramat aro irawulohani hu ndramat pakut tahu mwomwan, pe ngara kinamnam kiyasura hu.>> ");
INSERT INTO nss_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pwen Yesu itiyani nongan pwandritiye iya kili hu toro: ");
INSERT INTO nss_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Kapa hamou tawawu, ma sipsip tan masangat, pe hamou kiyasongsin, ara tehe tapeh? Andre kitali hu androsongui pe androsomou ara hu koro kol hape mwaihei, pe kiya ten sipsip mepo kinnasongsin ara, kipoo kiya kahi yiy, ndre? ");
INSERT INTO nss_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pe iro mwonen ikahi yiy, ara andre kipwes namandran iya, pe kisap yiy kiye ngundrun. ");
INSERT INTO nss_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pwen kimui kiya wum, pe andre kiyoh kowasen hu kiyapolo hu ndramat para pakeh kili yiy, ara hu kasa wule, pe andre kipa, <Akapwes kiyasura yo; yo kunkahi sipsip to mepo isongsin ara!> ");
INSERT INTO nss_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yo upwai isa kili wawu, tehen aliy o, pwesai namandran iya andre kiro kol paingan yang, kapa ndramat hamou mepo pakut tan mwomwan kirapaiwani ndriyan. Ara ndrokonan—yihu para kol paingan yang ngara hu kapwes kata hu ndramat hu mwonen androsongui pe androsomou, pe kinlahiy para hu karapaiwani ndriyahu pwi. Hapeko kapa ndramat hamou pakut tan mwomwan kirapaiwani ndriyan, ara pwesai para aliy iramwaitini pwesai masih. ");
INSERT INTO nss_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pe kapa pihin hamou ma sombule silwa tan masongui pe hambut para aliy kiyos, pwen andre tapeh? Ara andre kitolmwani paisui sahin pe kipwasili seu pe kiten nokulaniy, kipoo kiya kahiy, ndre? ");
INSERT INTO nss_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pe kiro mwonen kikahiy, andre kiyoh kowasenhu pe hu ndramat para pakeh kili yiy, ara hu kasawule, pe kipa, <Akapwes kiyasura yo; yo kunkahi sombule pat to mepo iyos ara.> ");
INSERT INTO nss_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pwen pe upwai isa kili wawu, tehen tora ko, kapa ndramat hamou pakut tan mwomwan kirapaiwani ndriyan, andre pwesai namandran iya kirayah kiro mbulmara hu angelou ata Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pe Yesu iposura nongnan ipa, <<Ndramat hamou ma norun kamai malmou. ");
INSERT INTO nss_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pwen norun kopwan, ara ipwai iya kili taman, ipa, <Tomo, ataingani menmenam, pe ato haroh, ara unamiliy para aikiy kisa kili yo.> Pwen pe itainganiy mwalinga hilu. ");
INSERT INTO nss_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pwen iyamulan hape, norun kopwan ara ihikule menmenan masih, pe iyau iya kol namandran masih mawen hape. Pwen iya iro ara, pe irakultuw handra-handra, pe irasumbuwani topwe menmenan masih kene, ihisolou o mwaihei. ");
INSERT INTO nss_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pe iro ara, pe menmenan masih iyahasolou topwei, pe iro mwonen lang ara mundruwai namandran irayah iro kol namandran masih ara, pe iho mamwore ko mwaihei. ");
INSERT INTO nss_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pwen pe iya ten mbulen, pe iyki yiy iya kili ndramat hamou para kol namandran masih ara, para kirayah ndramat para poya mbulyan. Pe ndramat ara, ipwandrisa yiy iya kowa hu puw tan para kiro hang anandrina hu puw. ");
INSERT INTO nss_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pe inime hu puw huro yan hu pwisi mbuwah, pe ndriyan ingah para kiyanuh puran kiya hu pwisi mbuwah ara. Hapeko, ndramat hamou kinhang yiy hapesah pwi. ");
INSERT INTO nss_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pe iro mwonen lohongan imui isa kili yiy, pwen ipa, <Yihu ndramat para poya mbulya tomo, ara ma anandrinahu ipep pe ndromwan ita, pe yo urupo aripo pe kunumat ndriyo. ");
INSERT INTO nss_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Konan ara! Yo andre kutine pe kuyau kumui kuya kili tomo pe andre kupwai kiya kili yiy, kupa toro: Tomo, yo ara umbusi pakut mwomwan iya kili Ngindrai pe isa kili wou i. ");
INSERT INTO nss_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pwen kinna hiyan para apohowe yo tehe norum pwi. Ambusi yo kurayah tehe ndramat hamou para poya mbulyam o mwaihei.> ");
INSERT INTO nss_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pwen pe itine pe imui iya kili taman. Hapeko iho ndron mwanan iya, pwen taman ara inime yiy iro tokai iropo isa. Pe koyun isikirani yiy, pe ingap iya kili norun pe indrohosi yiy, pe irahunghung iyatan. ");
INSERT INTO nss_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pe norun kamai ipwai iya kili yiy, ipa, <Tomo, yo ara umbusi pakut mwomwan iya kili Ngindrai pe isa kili wou i. Pwen kinna hiyan para apohowe yo tehe norum pwi.> ");
INSERT INTO nss_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hapeko taman ipwai iya kili hu ndramat para poya mbulyan, ipa, <Akahaleh! Akawiri koyau hamou niwen mepo mwayih iya, pe iramwaitini hu koyau masih, pe akasuluye yiy kiya aliy. Pe akaiki pwenah sih kiya ndrakopweniman, pe akaiki hatna pwelekai malpai kiya pwelekan. ");
INSERT INTO nss_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Akaya wiri noru mbulmwakau mepo imuh kisa, pe katingundrun. Pe tukanamnam pe tukapwes. ");
INSERT INTO nss_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Paratesah, noru kamai iye, ara kinnamat pwen, pe mahapo kinimui kinsa mwalen paiwe. Pe isongsin, pe kankahi yiy.> Pwen pe hupiye hu iya pwesai. ");
INSERT INTO nss_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Iro mwonen lang ara, nalin ndrohan ara iro ndrai piyang. Pwen imui isa pakeh ngilse seu, pe ihilingi ngasa ndramiy pe ndraniyai iropo iya. ");
INSERT INTO nss_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pwen pe iyoh ndramat hamou para poya mbulen iya kili yiy, pe isok tehe hu tora po tesah. ");
INSERT INTO nss_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pe ndramat para poya mbulen ara, ipa, <Nalim ara kinsa pe tamam itingundru noru mbulmwakau imuh, paratesah, yiy ara iro hiyan o pe imui.> ");
INSERT INTO nss_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pwen nalin ndrohan ihilingi nongan aro, pe ndrinan ilokuh, pe welen imai para kiya nondriyan. Pwen pe taman iya ngawan pe iya rambunmbuni yiy. ");
INSERT INTO nss_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hapeko isomwi taman, ipa, <Animei na! Hayou soyon iya kinna, ara urayah tehe ndramat para pwandrendres tam. Pe kunoho ndrihisani hape nongnam ngara apwatisingiy kisa kili yo, ara pwi. Hapeko anpo hamou noru meme mendreheh para ahang yo para kupwes kiyasura kowase hu, ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hapeko norum kamai mepo kinna solpwarani hu memelit tam masih, kinna kultuw para pilah ara isa, pwen mahapo atingundru noru mbulmwakau imuh iya anan!> ");
INSERT INTO nss_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pe taman ipa, <Noru, wou ara aripo sura yo lang masih, pe hu melto masih kene, ara atam! ");
INSERT INTO nss_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hapeko ndriya worou ara kiro hiyan pe tukapwes, paratesah, nalim aro, ara kinnamat, pe mahapo kinimui kinsa mwalen paiwe; iyasongsin, pe kankahi yiy.> >> ");
INSERT INTO nss_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu itiyani nongan pwandritiye iya kili ndramiran hu, ipa, <<Ndramat hamou namandran mamenmenan soyo-soyon iya, ara iyki ndramat hamou iro mu para kiro ponokulani hu menmenan. Pe hu ndramat hayah husa kili namandran ara, pe hurasusut nongan iya kili yiy, tehe ndramat iro mu ara, ara kinsalpwarani hu menmenan. ");
INSERT INTO nss_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pwen pe namandran ara iyoh yiy iya nondriyan pe isok yiy, ipa, <Wou apo tesah, mepo uhulong titiye tam? Wou aro mu iya pohombulen, pe atiyaniy kisa kili yo na; aro ngaplaniy tapeh? Paratesah, wou ara anlahiy para aye ndron pohombulen iye pwi.> ");
INSERT INTO nss_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pwen ndramat iro mu iya pohombulen ara, ara ipwai iya kili yiy mbukenan, ipa, <Yo mahapo andre kupo tesah ara? Namandran to nakiwiri mbulyo kiya mawen kili yo. Yo ara pwokeyo pwi para kutalon pwan, pe umasi para kuro rasosoying i. ");
INSERT INTO nss_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yo ara upahasani sehe lohongai para kumbusiy mahapo, pwen andre hu ndramat karawulohani yo kuya nondriya suwe hu, kiro mwonen lang mepo namandran to kiwiri yo kuya mawen mbulyo.> ");
INSERT INTO nss_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pwen pe iyoh hu mepo nahanah ata namandran tan iro kili hu, ara husa kili yiy. Pe isok yiy isa mu tahu ara, ipa, <Wou nahanah tam ita kili namandran to, ara masahayeh?> ");
INSERT INTO nss_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Pe yiy isa mu ara, ipa, <Nopwaran para nahanah to, ara tehe ndraikei holip iho kohoyongan masangat.> Pwen ndramat iro mu iya pohombulen ara, ipa, <Ahaleh pe ayampwan, pe awiri pepa mepo hu kanratuluwi nongan para nahanah tam ita aliy, pe aratuluwi nahanah tam kiya mayimingui opu.> ");
INSERT INTO nss_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pwen isok yiy mepo iho ndruwan ara, ipa, <Wou, nahanah tam masahayeh?> Pe ipa, <Nopwaran para nahanah to, ara tehe wit mandropwa sangat.> Pe ipwai iya kili yiy, ipa, <Ahaleh pe ayampwan, pe awiri pepa mepo hu kanratuluwi nongan para nahanah tam ita aliy, pe aratuluwi nahanah tam kiya mandrolngui opu.> ");
INSERT INTO nss_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pe iyamulan, namandran tan iya yirowe sehe melit kintayah ara, pwen isomwani ndramat mwomwan para pohombulen ara, paratesah, yiy imbusi kultuw ara tehe ndramat lohongan ileu. Akanimei, yihu ndramat para kol pwan, ara lohongahu ileu iya kultuw handra-handra, para hu kasusuye kiya kili hu hasap para mahapo. Pe huramwaitini hu mepo ngara hu koro ndruwa kultuwayi kolo King Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yo upwai isa kili wawu, akataingani hu sombule pat pe hu melit handra-handra pwassin para kol pwan, para akapo kowase wawu hu kayau aliy. Pwen kapa hu melit pwassin ara kene hu kahapwen, andre Ngindrai kirawulohani wawu koro nondriya hu seu mepo andre kinto-kinto. ");
INSERT INTO nss_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kapa hiyeh maran kiwayis para kiponokulani hu melit mendreheh, ara andre maran kiwayis para kiponokulani hu melit namandran i. Pe hiyeh ngara kimbusi kultuw kinmwonen pwi kiya hu melit mendreheh, ara andre kimbusiy tehen aliy o kiya hu melit namandran i. ");
INSERT INTO nss_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pwen pe kapa mara wawu kinwayis para akaponokulani hu melit pwassin para kol pwan pwi, pwen hiyeh andre kipa ndre mara wawu kiwayis para akaponokulani hu memelit ndrokonan. ");
INSERT INTO nss_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pe kapa mara wawu kinwayis para akaponokulani menmena hamou pwi, pwen hiyeh andre kiyki melit kisata wawu para akarayah mbukenan? ");
INSERT INTO nss_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kinlahi ndramat hamou para poya mbulen kiro pahandra hilu namandran malmou, ara pwi. Yiy andre kihimwisnani hamou pe kinamili hamou, ndre andre welen kiso kiyata hamou pe welen kimai kiyata hamou. Wawu kanlahiy para karayah pwandrendres ta Ngindrai, pe pwandrendres para menmena kol pwan kene, ara pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pe yihu Parisiy mepo hu ngara kanamili singayai, ara huhilingi hu nongan masih aro kene, pe hu patumbuye Yesu. ");
INSERT INTO nss_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pwen Yesu ipwai iya kili hu, ipa, <<Wawu ndramat ariya ko mepo wawu pakasomwani wawu koro mbulmara hu ndramat, hapeko Ngindrai ara tanan ndriya wawu pwen. Tesah mepo haiyan iya mbulmara hu ndramat, ara melit mwomwan masih iya mbulmara Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nongan para pwahanou pe nongan tahu Poropet ara huro pohowei, ipoo isa matne lenge Yohanes. Hapeko iro mwonen lenge Yohanes isa, nongan hiyan para kolo King Ngindrai, ara huro pohowei iya kol masih. Pe hu ndramat masih hurasisinge hu para hu kaya nondriyan. ");
INSERT INTO nss_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kol pwan pe yang, ara iya waison para kimun o mwaihei, hapeko kinlahiy para nongan para pwahanou sahin ata Ngindrai kitan, ara pwi. ");
INSERT INTO nss_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Pe kapa ndramat hamou kitali nambuyun, pe kiyesou kiya kili pihin hamou paiwe, ara ipo pilah. Pe kapa ndramat kiyesou kiya kili pihin mepo kintali nambuyun, ara ipo pilah. ");
INSERT INTO nss_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ndramat hamou iyen, mamenmenan soyon, pe ngara kisuluye yiy kiya hu ndrohan anandritan pe koyau lahayan iya, pe lang masih ngara kimpwan ndrita hu melit mwayih pe lahayan handra-handra. ");
INSERT INTO nss_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pe ndramat hamou ngalan Lasarus ngara kiyempwan pohomara karam namandran ta ndramat menmenan soyon ara, pe ngara kiro rakamam. Mandrakuyun masih ara neken iniy topwei. ");
INSERT INTO nss_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pe Lasarus ndriyan ngara kingah para kiyan hu konkonu anandrinai mepo ngara kilon kiro keyau ata ndramat mepo menmenan soyon ara. Hapeko hu mwiy, ngara hu koro ndramani hu neken tan. ");
INSERT INTO nss_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pwen irahihini lenge Lasarus, ndramat para rakamam ara, imat. Pe hu angelou husap yiy iya pe imi ndrahasa Apraham. Pe ndramat menmenan soyon iya ara, ara imat i, pe huroni yiy. ");
INSERT INTO nss_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pe iya pe iro kolo hu ndramat kanmat pe iro nondriya ngandran namandran. Pwen maran itandras iya paingan pe inime Apraham iro mwanan iya, iyasura Lasarus iro ndrahasan. ");
INSERT INTO nss_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pwen pe iyoh iya kili Apraham, ipa, <Tomo Apraham, koyum kisikirani yo, pe apwandrisa Lasarus pe kiyki ndrakopweniman kiya ndran, pe kisa kalame pe kimbusiy kiwou. Paratesah, mwan urupo aliy iye, ara iripo iyki ngandran namandran iya, isa kili yo.> ");
INSERT INTO nss_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hapeko Apraham ipwai iya kili yiy, ipa, <Noru, alohongani mipwan tam kinna, ma aro ndron mwalen, ara awiri hu melit tam hiyan opu; hapeko Lasarus, ara iwiri hu melit tan mwomwan opu. Hapeko mahapo, yiy ara iripo mwoimwoi iye, pe wou ata nondriya ngandran namandran. ");
INSERT INTO nss_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pe melit handra yi, ara toro: mwalinga yowu pe wawu, ara Ngindrai kiniyki ngat sih mbulun pwi ita pwen. Pwen pe kinlahiy para ndramat hamou kiro iye pe kihis ndrokomatne ngat iye kiya haroh kili wawu, ara pwi; pe kinlahiy para hamou kisingondritiy kiro ara pe kisa kili yowu, ara pwi yi.> ");
INSERT INTO nss_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pwen ndramat menmenan soyon ara isomwiy, ipa, <Tomo Apraham, urakamam satam, apwandrisa Lasarus kiya suwe tomo, ");
INSERT INTO nss_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","paratesah, yo ma nali hu mayimou. Pwen hiyan para kiya pe kipwandrandrahani hu. Matisan yihu yi kasa kol aripo, mepo ngandran namandran iya iripo aliy.> ");
INSERT INTO nss_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pwen pe Apraham ipwai paiwe iya kili yiy, ipa, <Nongan ata Mose iyasura hu Poropet, ara ita sura nalim hu. Hu koroiki ndrainga hu kaliy.> ");
INSERT INTO nss_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hapeko ipa, <Pwi! Tomo Apraham; kapa ndramat hamou kitine kimat pe kiya kili hu, pwen andre hu karapwaiwani ndriyahu.> ");
INSERT INTO nss_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hapeko Apraham ipwai iya kili yiy, ipa, <Kapa yihu kanhilingi nongna Mose pe hu Poropet pwi, pwen andre hu kanlahiy para hu kapwotisingi lohongahu pwi, konan kapa ndramat hamou kimat pe kisa tine.> >> ");
INSERT INTO nss_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ipwai iya kili ndramiran hu, ipa, <<Hu melit mepo andre kimbusi hu ndramat kayos kaya pakut mwomwan, ara andre karayah. Hapeko toimwa sehe ndramat mepo imbusiy, pe hu melit tehen tora hu karayah. Nopwaran, ara ita ndritan. ");
INSERT INTO nss_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hiyan para kandruyani pat kiya koyun pe kapiyani yiy kiya mbulu ndras pe kimat. Pwen andre kinlahiy para kirandroyani hamou tahu mbunah mendreheh aripo, pe kiyos kiya pakut mwomwan pwi. ");
INSERT INTO nss_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pwen pe akoro hinehes. Kapa nalim kimbusi pakut mwomwan, pwen apomate yiy; pe kapa kirapaiwani ndriyan, pwen atali mwomwan tan. ");
INSERT INTO nss_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pe kapa kimbusi pakut mwomwan kisa kili wou maporoandrtisap kiho nondriya lang sih, pe maporoandrtisap kimui kisa kili wou, pe kipa, <Nakusa pohopoh; pe nakurapaiwani ndriyo,> pwen atali mwomwan tan.>> ");
INSERT INTO nss_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pwen hu aposel hupwai iya kili Yapan, hupa, <<Ambusi lohonga yowu ndrisiyon, ara kiya namandran!>> ");
INSERT INTO nss_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pe Yapan isomwi hu, ipa, <<Kapa lohongam ndrisiyon mendreheh pwen tehe peke mbuwa mastet sih, ara andre alahiy para apwai kiya kili kei namandran, para ngondron kiret pe kiyahasi yiy kiya ndras, pe andre kihilingi wou. ");
INSERT INTO nss_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kapa hamou tawawu ma ndramiran hamou para poya mbulyan, pe kipwai kiya kili yiy para kiya talon pwan kiya piyang, ndre kiya pwokere hu sipsip, pwen kiro mwonen ndramat para poya mbulyan ara kimui kisa, andre namandran tan kipwai kiya kili yiy, kipa, <Asampwan kileh pe anamnam>? Andre kiwong tehen toro, ndre pwi? ");
INSERT INTO nss_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pwi! Andre kipa, <Amwaniyani anandrino na, pe ahakule wou pe aro longe yo para kuyin ndran pe kunamnam. Pwen kiyamulan andre anamnam pe ayin ndran.> ");
INSERT INTO nss_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pwen sehe melit ipwandrandrahani ndramat para poya mbulyan para kimbusiy ara, ara andre namandran tan kirawulohani yiy, ndre pwi? Pwi! ");
INSERT INTO nss_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pwen pe wawu tehen aliy i; kapa wawu kanmbusi hu melit masih mepo Ngindrai kinpwandrandrahani wawu para akambusiy kihipwen, ara wawu kapa, <Yowu ara ndramat o mwaihei para poya mbulyam. Mbulen yowu mbusiy, ara mbulya yowu ara ko.> >> ");
INSERT INTO nss_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pwen Yesu iro tokai nakiya Yerusalem, pe iya yau ngilse ndrokomatnet para mwalinga kol malkol namandran hape, Samariya pe Kaliliy. ");
INSERT INTO nss_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iro mwonen nakiya nondriya kol hakol mendreheh, yihu ndramat masongui mepo mwamwa kawa ilopwa hu, ara husa pohonani yiy, pe huro tine mwanan hape. ");
INSERT INTO nss_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Pe huyoh namandran iya, hupa, <<Yesu! Namandran! Koyum kisikirani yowu!>> ");
INSERT INTO nss_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pwen iro mwonen Yesu inime hu, ipwai iya kili hu, ipa, <<Akaya pwaingani wawu kaya kili hu pris.>> Pe iro mwonen huropo huya, ara mandrakuyuhu masih kene irayah howen. ");
INSERT INTO nss_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pe hamou tahu inimei tehe mandrakuyun kinna howen, pwen imui isa, pe iro wayeh namandran pe iro hari ngala Ngindrai. ");
INSERT INTO nss_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pe isa piyani yiy iya ngondro ndrika Yesu, pe irawuloh iyatan. Pe yiy ara ndramira Samariya hamou. ");
INSERT INTO nss_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pe Yesu isok, ipa, <<Upa ndre wawu masongui wawu kanna howen; pe hu manandrosomou hu kontora aleheh? ");
INSERT INTO nss_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tehen tapeh? Ndramat hamou hira ndron para kimui kisa pe kisahari ngala Ngindrai, ndre pwi? Ndre ndramat para mawen iye kopu?>> ");
INSERT INTO nss_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pwen Yesu ipwai iya kili yiy, ipa, <<Atine pe ayau; lohongam ndrisiyon kinmbusi wou anna hiyan.>> ");
INSERT INTO nss_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hu Parisiy hayah husok Yesu tehe sehe lang imwonen andre kolo King Ngindrai kisa. Pwen Yesu isomwi hu, ipa, <<Kolo King Ngindrai nakisa, ara wawu andre kanyirowe kaipisan pwi. ");
INSERT INTO nss_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pe yihu ndramat kanlahiy para kapa: <Akanimei! Iripo iye,> ndre <Ita yoro,> ara pwi. Hapeko akahilingiy! Kolo King Ngindrai, ara ita mwalinga wawu.>> ");
INSERT INTO nss_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pwen ipwai iya kili ndramiran hu, ipa, <<Lang itapo isa, ara andre wawu karakamsiy para wawu pakanime lang sih, para nondriya lenge Noru Ndramat, hapeko wawu andre kannimei pwi yoh. ");
INSERT INTO nss_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pe hu ndramat andre hu kapwai kisa kili wawu, hu kapa, <Akanimei! Yiy ita yoro!> ndre <Yiy iripo iye!> Wawu mbuna akangap koho ndruwa hu kaya. ");
INSERT INTO nss_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Lenge Noru Ndramat ara mwensen tehe kamit; kikamiriy, pe kilengani yang kiro mbusungon haroh kiyandrek kiya haroh. ");
INSERT INTO nss_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Hapeko Noru Ndramat andre kiya nondriya hu nopwaran namandran soyon kimu, pe hu hasap para mahapo, andre hu kamwisnani yiy. ");
INSERT INTO nss_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hu kultuw mepo kantayah kinna iro lenge Nowah, ara andre kihisoule ko, kiho nondriya lenge Noru Ndramat. ");
INSERT INTO nss_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iro tandrohonga lenge Nowah, ara yihu ndramat huro namnam, pe huro yin ndran, pe huro yesou, pe huro sokombut yesou, ipoo iya lang mepo Nowah isong iya nondriya ndroi. Pwen pe non namandran irah pe ipwalngani hu masih. ");
INSERT INTO nss_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pe andre kihisoule ko tehe lenge Lot i. Hu ndramat huro namnam pe huro yin ndran, pe huropo pehei pe huro sousou, pe huro has anandrinai pe huro pun seu. ");
INSERT INTO nss_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hapeko iro mwonen lang mepo Lot itali Sotom, mwan ilon tehe mbulou indrut iyau yang isa pwan, pe ipwalngani hu masih kene. ");
INSERT INTO nss_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pwen kiho mwonen lang mepo Noru Ndramat nakisa yelan ngawan, ara andre kihisoule ko. ");
INSERT INTO nss_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kiro mwonen lang ara, ndramat hiyeh kiro payandroha suwen, ara mbuna kilai kiya pwan, pe kiya nondriya suwen para kiya wiri hu menmenan. Tehen tora ko, sehe ndramat mepo kiro pingen lang ara, ara mbuna kipaiwani yiy kimui. ");
INSERT INTO nss_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wawu kalohongani nambuyu Lot! ");
INSERT INTO nss_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hiyeh pakisopwat mwoiwan, ara andre mwoiwan kitali yiy; pe kapa hiyeh kitali mwoiwan, ara andre mwoiwan kiye ndron. ");
INSERT INTO nss_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yo upwai isa kili wawu, tehe ndramat malmou andre hilu keye matin yokyok hayok kiro mwonen ping ara. Pwen Ngindrai andre kiwiri hamou, pe hamou andre kiye ndron. ");
INSERT INTO nss_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Pe pihin malmou andre hilkorowule pe hilkoro puluw palawa. Pwen andre Ngindrai kiwiri hamou, pe hamou andre kiye ndron.>> ");
INSERT INTO nss_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pwen ndramiran hu husok yiy, hupa, <<Yapan, hu melit aro kene andre hu karayah koro aleheh?>> Pwen Yesu isomwi hu, ipa, <<Hape aleheh mepo nombuwe tesah imat iro aliy, ara andre hu pihinan kahalun kaya aliy.>> ");
INSERT INTO nss_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pwen Yesu itiyani nongan pwandritiye sahin iya kili ndramiran hu, para kihinuwani hu para hu koro tohun lang masih, pe welehu mbuna kimai. ");
INSERT INTO nss_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesu ipa toro: <<Ndramat hamou para tamwanye, ara iye kol hakol ngawan. Pe yiy ara kinho noh ata Ngindrai pwi, pe kinoho lohonge kinnata hu ndramat pwi yi. ");
INSERT INTO nss_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pe pihinau hamou iro kol ngawan ara, ngara kisa kili yiy ken iho ken, pe kipa, <Asopwat yo, pe aramwaniyani mwalingo pe mwalinga yiy mepo pakiyki yo kuya nongan.> ");
INSERT INTO nss_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ndramat para tamwanye ara, ara mamu ipa pwi iya kili yiy. Hapeko iyen pe ilohonge, ipa, <Yo ara kunho noh ata Ngindrai pwi, pe kunoho lohonge kinnata hu ndramat pwi yi. ");
INSERT INTO nss_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hapeko pihinau aro, ngara kiro waiyani yo manau. Pwen hiyan para kuramwanye yiy kileh. Matisan kiropo kisa ken iho ken pe kipwonomwili yo topwei!> >> ");
INSERT INTO nss_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pe Yapan ipwai, ipa, <<Akahilingi nongan mepo ndramat kinho tamwanye hiyan pwi ara, kinpwai. ");
INSERT INTO nss_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pwen tehen tapeh? Hu ndramat mepo Ngindrai kintakinimahu pwen atan, pe kapa hu koro rang kiya kili yiy para kisopwat hu ping pe lang, ara andre kihilingi hu, ndre pwi? Pe andre kiyindronge hu koro longe para kisopwat hu kiya ndrangan niwen? Pwi yoh! ");
INSERT INTO nss_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yo upwai isa kili wawu tehe andre kinkose para kiramwanye hu kileh pwi. Hapeko, kapa Noru Ndramat kisa, andre kinimei tehe hu ndramat hutopo kol pwan, ara lohongahu ndrisiyon, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yihu ndramat hayah ara husikiye hu tehe kultuwayihu ara imwonen iya, iyata hu hayah i mepo hunime hu tehe hu mwaihei opu. Pwen Yesu itiyani nongan pwandritiye iya kili hu ndramat ara, toro: ");
INSERT INTO nss_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","<<Hilu ndramat malmou, hilya yumwa totohun namandran para hilkaya tohun. Yiy hamou, ara hamou tahu Parisiy, pe yiy hamou i, ara ndramat hamou para poya takis. ");
INSERT INTO nss_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisiy aro, itine pe iro tohun iyatan mbukenan, ipa toro: <Ngindrai, yo urawuloh tehe yo ara tehe hu ndramat hayah pwi. Yihu ngara kapahana, pe karandroindroi, pe kapo pilah. Hapeko yo, ara pwi! Pe yo tehe ndramat para poya takis aro pwi yi. ");
INSERT INTO nss_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yo ngara kuyuh anandrinai maporoluwoh kiho nondriya sandre sih. Pe melit masih ngara kuwiriy, ara ngara kuwiri hambut para nondriya masongui ara, pe ngara kuikiy kisatam.> ");
INSERT INTO nss_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hapeko ndramat para poya takis ara iro tine mwanan hape. Yiy mbuwalin para maran kitandras kiya kol paingan yang. Hapeko iti wiyineren, pe ipa, <Ngindrai, koyum kisikirani yo. Yo ndramat pakut to mwomwan.> ");
INSERT INTO nss_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yo upwai isa kili wawu tehe ndramat para poya takis aro, ara imui iya suwen, pe yiy opu ara irayah ndramat imwonen iya mbulmara Ngindrai. Hapeko Parisiy aro, ara pwi. Paratesah, hiyeh pakisap ngalan mbukenan, ara andre ngalan kiya pwi. Pe hiyeh kiyki yiy kiya pwan, ara andre Ngindrai kihiri ngalan kiya paingan.>> ");
INSERT INTO nss_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pe yihu ndramat ara huro wiri hu mbunah mendreheh iyapolo hu mbunah malaman i, ara huya kili Yesu para niman kiya ndrita hu. Pe iro mwonen ndramiran hu hunimei, pwen hupomate hu ndramat ara. ");
INSERT INTO nss_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hapeko Yesu iyoh hu mbunah husa kili yiy, pe ipa, <<Akatali hu mbunah kasa kili yo, pe mbuna akakaituwe hu, paratesah, kolo King Ngindrai, ara atahu tehen aro kene. ");
INSERT INTO nss_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yo upwai ndrokonan isa kili wawu, kapa ndramat hamou kinwiri kultuwayi kolo King Ngindrai tehe mbunah hamou tehen iye pwi, ara kinlahiy para kiya nondriyan pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pwen pohon hamou para kol isok Yesu, ipa, <<Ndramat Hiyan para Hinonou, yo andre kumbusi tapeh, pwen pe andre kuwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Pe Yesu isomwi yiy, ipa, <<Paratapeh wou apohowe yo hiyan? Hamou hiyan pwi. Ngindrai hamou opu, ara yiy hiyan. ");
INSERT INTO nss_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wou tanam hu nongan para pwahanou: <Mbuna apo pilah, mbuna atingundru ndramat kimat, mbuna apahana, mbuna apakarawani ndramat hamou kiya nongan, pe ahaiyani tamam hilu tinam.> >> ");
INSERT INTO nss_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pwen pohon para kol ara, ara ipa, <<Nongan para pwahanou masih kene ara, ara mawihou to ko, pe ngara kuhaiyaniy.>> ");
INSERT INTO nss_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iro mwonen Yesu ihilingi nongan aro, pwen ipwai iya kili yiy, ipa, <<Melit handra ko hira ndron, ara anmbusiy mapu. Ayapo pehei kiya hu melit tam masih, pe awiri singayai para aliy, pe atainganiy kiyata hu ndramat mepo hundroisiy, pe andre awiri hu melit lahayan kennen namandran ita kol paingan yang. Pwen asa, oho ndruwo.>> ");
INSERT INTO nss_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Iro mwonen ihilingi nongan aro, ndriyan ara ipworu masih, paratesah, yiy ndramat hamou menmenan soyon iya. ");
INSERT INTO nss_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu maran iya kili yiy, pe ipa, <<Yihu ndramat mepo menmenahu soyon, ara ingandrah iyatahu para hu kaya nondriya kolo King Ngindrai! ");
INSERT INTO nss_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel hamou, ingandrah para kisong kiya ngara kannih; hapeko ndramat hamou menmenan soyon iya, ara ngandrahan iya para kisong kiya nondriya kolo King Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pwen hu hiyeh huro hilingiy, ara husok, hupa, <<Kapa tehen tora, pwen andre hiyeh ndrokonan kilahiy para kiwiri taleh mepo andre kinto-kinto?>> ");
INSERT INTO nss_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pe Yesu ipa, <<Sehe melit hu ndramat kanwenei para kambusiy pwi, ara Ngindrai iwenei para kimbusiy.>> ");
INSERT INTO nss_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pwen Pita ipwai iya kili Yesu, ipa, <<Yowu ara kantali hu melit towu masih kene para koho ndruwam!>> ");
INSERT INTO nss_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pe Yesu ipa, <<Yo upwai ndrokonan isa kili wawu, kapa sehe ndramat kitali kolon ndre nambuyun, ndre kitali taman hilu tinan, ndre kitali nalin hu, ndre kitali norun hu, para nakiya nondriya kolo King Ngindrai, ");
INSERT INTO nss_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ara andre kiwiri hu melit soyo-soyon iya kiro lang mahapo, pe kiya lang itapo isa kamulan, ara andre kiwiri taleh mepo andre kinto-kinto.>> ");
INSERT INTO nss_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pwen Yesu iwiri hu Songui pe Lumou huya pwakin hape, pe ipwai iya kili hu, ipa, <<Andre worou tukaya paingan Yerusalem, pe melit masih mepo hu poropet kantatuluwiy pwen kinna ta Noru Ndramat, ara andre kirayah mannan. ");
INSERT INTO nss_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tehe andre hu kaiki yiy kiya nima hu Ndramira Lah. Pe andre yihu kapwasisiman anan, pe kapatumbuye yiy, pe kasokombunuhi yiy, pe kamwiri yiy, pe andre hu katingundrun kimat. ");
INSERT INTO nss_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pe kiro mwonen lang toyoh, ara andre kisatine paiwe.>> ");
INSERT INTO nss_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pe ndramiran hu, ara lohongahu kanileu kinna nongan masih aro, ara pwi yoh. Mbulndroiyi lohongai ara, ara ikohon kili hu, pe yihu kanpahasani sehe melit mepo iro wong iya aliy pwi. ");
INSERT INTO nss_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pwen Yesu iropo nakiya kol ngawan Yeriko, pe ndramat hamou maran iyoh, ara iyempwan ngilse sai, pe iro rakamam. ");
INSERT INTO nss_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pe iro mwonen ihilingi hu ndramat soyon iya husoroyau, pwen isok tehe tesah ndrokonan iripo tayah. ");
INSERT INTO nss_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pe hupwai iya kili yiy, hupa, <<Yesu, ndramira Nasaret, ara nakisayau aripo.>> ");
INSERT INTO nss_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pwen ndramat ara iyoh, ipa, <<Yesu, Noru Tepit, koyum kisikirani yo!>> ");
INSERT INTO nss_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pe yihu ndramat mepo huro luwani Yesu, ara hupomate yiy pe hupwai iya kili yiy para kihun o, hapeko iyoh, ipa, <<Noru Tepit, koyum kisikirani yo!>> ");
INSERT INTO nss_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pwen Yesu iro tine, pe ipwandrandrahaniy para hu kawiri ndramat maran iyoh ara, kisa kili yiy. Pe iro mwonen isa pakeh, pwen Yesu isok yiy ipa, ");
INSERT INTO nss_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Anamiliy para kumbusi tesah kisa kili wou?>> Pe ipa, <<Yapan, yo unamiliy para kunimnim paiwe.>> ");
INSERT INTO nss_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pe Yesu ipwai iya kili yiy, ipa, <<Kiya, animnim! Lohongam ndrisiyon, ara kinsopwat wou.>> ");
INSERT INTO nss_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hape pwi ko, maran inimnim paiwe, pe iho ndruwa Yesu pe iro hari ngala Ngindrai. Iro mwonen yihu ndramat masih kene hunimei, pwen yihu masih huhuri ngala Ngindrai yi. ");
INSERT INTO nss_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu iya nondriya kol ngawan Yeriko, para pakiya yau tusuye. ");
INSERT INTO nss_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pe ndramat hamou iro kol ara, ara ngalan Sakiyus. Yiy ara ndramat hamou ihohin iyata hu ndramat para poya takis, pe mameltan soyon iya. ");
INSERT INTO nss_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yiy inamiliy para kinime Yesu ara hiyeh, hapeko yiy, ara mulai sahin opu, pe kinlahiy para kinime Yesu pwi, paratesah, hu ndramat soyon iya, ara huro tandrapndrap. ");
INSERT INTO nss_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pwen pe ingap iya mu pe ingas kei sikamor hakou, pe iye parasangan para kinime Yesu, paratesah, Yesu andre kisayau sai ara. ");
INSERT INTO nss_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iro mwonen Yesu isarayah iro hape ara, maran itandras iya paingan pe inime Sakiyus, pe ipwai iya kili yiy, ipa, <<Ahaleh o, asa pwan. Mahapo ko andre kuya kuro suwem.>> ");
INSERT INTO nss_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pwen Sakiyus ihimbuh o, pe ituh isa pwan. Pwen irawulohani Yesu iyapolo pwesai. ");
INSERT INTO nss_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yihu ndramat masih hunimei, pe huro panguluwani Yesu, huro pa, <<Yiy kinna kintora suwe ndramat hamou mepo pakut tan mwomwan.>> ");
INSERT INTO nss_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hapeko Sakiyus itine pe ipwai iya kili Yapan, ipa, <<Yapan! Animei na! Yo mahapo andre kutaingani hu memelit to haroh mwanye kiya kili hu ndramat mepo hu ndroisiy, pe kapa kunpwasike hamou pe kunpahanowe hu meltan, ara andre kupo soiwin kiya maporohaasap.>> ");
INSERT INTO nss_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pwen pe Yesu ipwai iya kili yiy, ipa, <<Lang nepo, sopwat ta Ngindrai ara kinsarayah kinsa seu iye, paratesah, ndramat aripo, ara yiy noru Apraham hamou i. ");
INSERT INTO nss_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Noru Ndramat isa, ara tunan iye: para kiten pe kisopwat hu ndramat mepo husongsin.>> ");
INSERT INTO nss_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hu ndramat huroholong Yesu manau, pe itiyani nongan pwandritiye sahin, paratesah, yiy iropo iya pakeh Yerusalem, pe hu ndramat ara, huro pa ndre kindrou pwi ko, kolo King Ngindrai nakisarayah. ");
INSERT INTO nss_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Pe Yesu ipa toro: <<Ndramat hamou mangalan, ara iyau iya kol hakol namandran masih hira mwanan, para hu karakiniman pe kirayah king. Pwen kiyamulan, andre kimui kisa kolon paiwe. ");
INSERT INTO nss_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pwen pe iyoh hu ndramat para poya mbulyan masongui husa kili yiy, pe iyki sombule pat tasongui-tasongui iya kili hamou-hamou tahu. Pe ipa, <Akawiri singayai iye pe akapo mbulen kiya aliy, kipoo kumui kusa.> ");
INSERT INTO nss_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hapeko yihu ndramat para kolon imwonen, ara humwisnani yiy. Pwen hupwanos hu ndramat hayah para sapiya nongan huro ndruwan huya, pe huya pa, <Yowu mbuwali yowu para ndramat aro kirayah king towu.> ");
INSERT INTO nss_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hapeko yiy ara irayah king manau, pwen pe imui iya kolon i. Pe ipwanos nongan iya kili hu ndramat mepo kiniyki singayai kinna kili hu ara, para nakinimei hiyeh tahu ndrokonan kinpo sura singayai kinyau aliy. ");
INSERT INTO nss_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pwen ndramat hamou imu isa, pe ipa, <Yapane, yo uwiri sombule pat masongui, pwen kunpo suran pe kintayah tehe masongui yi.> ");
INSERT INTO nss_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pe king ipwai iya kili yiy, ipa, <Ndramat para poya mbulyo, anmbusiy hiyan masih! Wou ara anpwokarani melit mendreheh, pwen pe hu kol namandran masongui, ara andre aro nimnim kiya tahu.> ");
INSERT INTO nss_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pe hamou i iro mulan isa, pe ipa, <Yapane, yo uwiri sombule pat masongui, pe kunpo suran pe kintayah tehe mayimbut i.> ");
INSERT INTO nss_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pwen king ipwai iya kili yiy, ipa, <Wou andre aro nimnim kiya hu kol namandran hape mayimikol.> ");
INSERT INTO nss_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pwen pe ndramat hamou i para poya mbulyan isa, pe ipa, <Yapane, singayai tam iye; kunkulaniy kinna koyau hasai pe iripo mwonen. ");
INSERT INTO nss_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Paratesah, yo unoh tam; wou ara ndramat hamou ngandrahan. Pe ngara aniyi tesah mepo anhohas pwi, pe ngara arihi tesah mepo anhopiye pwi.> ");
INSERT INTO nss_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pe king ipwai iya kili yiy, ipa, <Wou ndramiro hamou mepo kultuwayim pwassin! Yo andre kuiki wou kiya nongan ara kiho ndruwa nongnam opu! Wou anpahasaniy pwen tehe yo ara ndramat hamou ngandrahan; pe ngara kuniyi tesah mepo kunho has pwi, pe ngara kurihi tesah mepo kunho piye pwi. ");
INSERT INTO nss_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pwen pe paratapeh pe wou aniyki sombule pat to kinna yumwa singayai pwi? Pwen kapa kumui, andre kusa pe kuwiri suran kiyapolon i.> ");
INSERT INTO nss_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pwen pe king ipwai iya kili hu ndramat mepo huro tine ngilsen ara, ipa, <Akawiri sombule pat masongui ara kisa mawen kili yiy, pe akaikiy kiya kili yiy mepo atan malungui.> ");
INSERT INTO nss_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hapeko yihu pwai, hupa, <Yapan, yiy ara, atan malungui pwen!> ");
INSERT INTO nss_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pwen king isomwi hu, ipa, <Yo upwai ndrokonan isa kili wawu, tehe yihu masih mepo mamenmenahu, ara andre Ngindrai kipo sura menmenahu; hapeko yiy mepo menmenan pwi, konan hape sohoyan kimin, ara andre kawiriy topwei kiya mawen kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hapeko yihu hiyeh hu kanmwisnani yo, pe mbuwalihu para yo kurayah tehe king tahu, ara akawiri hu kasa mbulmoro pe akatingundru hu!> >> ");
INSERT INTO nss_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu itiyani nongan pwandritiye ara ihipwen, pwen irikai iye mu iya paingan Yerusalem. ");
INSERT INTO nss_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iro mwonen Yesu iropo isa pakeh kol malkol Petpake pe Petaniy, isa parangondron sih mepo hupohowei Ngondron para hu Holip. Pwen ipwandrisa ndramiran malmou, pe ipwai iya kili hilu ipa, ");
INSERT INTO nss_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","<<Alkaya kol mendreheh yoho mu kili walu. Pe kiro mwonen walu nakaya nondriyan, ara andre walu kanime noru tongkiy hamou hu kanwasiy pwen ita, mepo ndramat hamou kinihis aliy mapu. Pwen alkatali yiy pe kawiriy kisa iye. ");
INSERT INTO nss_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pe kapa hamou kisok walu, kipa, <Paratesah pe walu tora tali tongkiy ara?> Pwen alkapwai kiya kili yiy, alkapa, <Yapan inamiliy.> >> ");
INSERT INTO nss_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pe hilu ndramat malmou mepo ipwandrisa hilu hilto mu ara, ara hilya nimei tehe sehe melit kinpwai kinnata kili hilu, ara iro mwonen tehe kinpwai. ");
INSERT INTO nss_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pwen hiluro tali malkeye tongkiy, pe ndramira tongkiy isok hilu, ipa, <<Paratesah pe walu tora tali tongkiy ara?>> ");
INSERT INTO nss_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pe hilsomwi yiy, hilpa, <<Yapan inamiliy.>> ");
INSERT INTO nss_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pwen hilu luwi tongkiy isa kili Yesu, pe hupwalani koiwe hu iya ndrita tongkiy ara, pe huiki Yesu impwan ndritan. ");
INSERT INTO nss_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pe iropo iya, pe hu ndramat hupwalani hu koyau tahu huya ndrita sai. ");
INSERT INTO nss_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pe isa pakeh kol hape mepo sai para Ngondron para hu Holip ilai iya pwan, pe hu ndramiran soyo-soyon iya huhuri ngala Ngindrai iyapolo pwesai namandran, paratesah, hulohongani hu ndraikiya pwoke masih mepo hu kannimei pwen. ");
INSERT INTO nss_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pe huwayeh hupa toro: <<Lomwes ita kili King mepo isa iya ngala Yapan! Ndriya wayis ita kol paingan yang, pe Yapan ma ngannganan, iyera paingan masih!>> ");
INSERT INTO nss_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pwen yihu Parisiy hayah huro mwalinga hu ndramat soyon iya ara, ara hupwai iya kili Yesu, hupa, <<Ndramat para Hinonou, apomate ndramiram hu para hu kahun o!>> ");
INSERT INTO nss_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pe Yesu isomwi hu, ipa, <<Upwai isa kili wawu tehe, kapa hu kahun o, pwen andre hu pat kawayeh.>> ");
INSERT INTO nss_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pwen Yesu iropo iya pakeh Yerusalem, pe inime kol namandran iya ara, pe irangsiy. ");
INSERT INTO nss_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Pe ipa, <<Lang nepo, kapa wawu kapahasani tesah ilahiy para kiyki ndriya wayis kisa kili wawu—hapeko mahapo ara kinkohon mbulmara wawu. ");
INSERT INTO nss_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lang itapo isa andre hu mepo hu ngara kamwisnani wawu, ara hu ndram tahu andre hu kambultani pwan pe karahakowa kou namandran para kol tawawu, pe andre hu karakayani wawu kiro sese wawu haroh-haroh. ");
INSERT INTO nss_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pe andre yihu kasoyau kiyata wawu kaya pwan, wawu kiyapolo noru wawu hu koro nondriya kowa kol. Pe yihu andre kantali pat sih kiro ndrita sih pwi, paratesah, wawu kanyirowe lenge Ngindrai kinsa kili wawu pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pwen Yesu isong iya nondriya yumwa totohun namandran pe iro rasses hu ndramat mepo huropo pehei iya aliy. ");
INSERT INTO nss_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Pe ipwai iya kili hu, ipa, <<Pwayan kinpwai pwen, kinpa, <Suwe, ara yumwa totohun.> Hapeko wawu kanmbusiy kintayah ndrohona kokohon tahu ndramat para pahana.>> ");
INSERT INTO nss_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pe lang masih ngara kiro hinuwani nongan kiro yumwa totohun namandran. Hapeko hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, pe yihu pohon tahu, ara huro hinonou para pakatingundru Yesu. ");
INSERT INTO nss_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yihu pakambusiy, hapeko hukah sai ndrit, paratesah, yihu ndramat masih ara huro pwahatini tisingi hu nongnan. ");
INSERT INTO nss_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lang sih, Yesu iro hinuwani hu ndramat iro nondriya kowa yumwa totohun namandran, pe iro pohowe nongan hiyan ta Yapan. Pwen pe hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, iyapolo hu yapane kol, ara husa kili yiy. ");
INSERT INTO nss_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pe hupwai iya kili yiy, hupa, <<Wou awiri pwoke nopwaran ara, iyau aleheh? Pe hiyeh iyki pwoke nopwaran ara, isa kili wou?>> ");
INSERT INTO nss_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pe Yesu isomwi hu, ipa, <<Yo nakusike wawu kiya soksok sahin i; akapwai kisa kili yo, ");
INSERT INTO nss_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes ngara kisumuluwani hu ndramat, pe wawu pa ndre kultuw para paptais ta Yohanes ara, ara iyau kol paingan yang, ndre iyau kili ndramat opu?>> ");
INSERT INTO nss_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pe huro panguluwaniy mwalingahu ko, huro pa, <<Kapa tukapa, <Iyau kol paingan yang,> pwen andre kisok, kipa, <Pwen tehen tapeh pe lohonga wawu kinpwotisingi nongnan pwi?> ");
INSERT INTO nss_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hapeko kapa tukapa, <Iyau kili ndramat,> yihu ndramat masih, ara andre hu kasolpwa rou kiya pat, paratesah, lohongahu ara kinpwoke tehe Yohanes ara yiy poropet hamou.>> ");
INSERT INTO nss_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pwen pe husomwi yiy, hupa, <<Yowu tana yowu pwi, iyau tapeh isa.>> ");
INSERT INTO nss_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pe Yesu ipa, <<Pwen pe yo andre kunpwai kinsa kili wawu pwi yi, iyau hape aleheh uwiri pwoke nopwaran pe urupo mbusi hu melit aro.>> ");
INSERT INTO nss_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pwen itiyani nongan pwandritiye aro, iya kili hu ndramat, ipa toro: <<Ndramat hamou ihisi pinge wain hambut, pe iykiy iya kili hu ndramat hayah para poya mbulya piyang, pe yiy iyau iya hape mwanan, ndrangan niwen iya. ");
INSERT INTO nss_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pwen iya lang para rihiya mbuwa wain, yiy ipwandrisa ndramat hamou para poya mbulen iya kili hu ndramat huropo mbulen iya piyang ara, para hu kawiri mbuwa wain hayah kiyau pinge wain ara kisa kili yiy. Hapeko yihu ndramat para poya mbulen ara, ara humwiri yiy, pe hupwandrisa yiy imui iyau o mwaihei. ");
INSERT INTO nss_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pwen ipwandrisa ndramat hamou i para poya mbulen iya, hapeko yihu rayi yiy pe hupwasimiri yiy, pe hupwandrisa yiy ara iyau o mwaihei. ");
INSERT INTO nss_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pwen ipwandrisa hamou porosih i, pe hupotisi yiy pe hupiyani yiy iya ngawan. ");
INSERT INTO nss_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pwen pe mbukena pinge wain ara, ara ipa, <Yo andre kumbusiy tehe tapeh? Yo andre kupwandrisa noru mbukenan, mepo ndriyo imbuluhi yiy; matisan kiya pe yihu karanuhuyani yiy.> ");
INSERT INTO nss_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hapeko yihu ndramat mepo huropo mbulen iya piyang ara, ara hunime yiy pe huro panguluwaniy mwalingahu, huro pa, <Iye ara norun, soiwi taman; pe yiy andre kiwiri hu meltan masih. Kiya, tukatingundrun, pe tukawiri menmena taman masih kiya mbukenan worou.> ");
INSERT INTO nss_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pwen pe huwiri yiy pe husoyau iyatan iya ngawan piyang, pe hutingundrun imat.>> Pe Yesu isike hu, ipa, <<Kiya, pwen andre mbukena piyang kimbusiy tapeh kiya tahu? ");
INSERT INTO nss_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mbukena piyang andre kisa pe kitingundru hu ndramat huropo mbulen iya piyang ara pe hu kamat. Pe andre kiwiri pingen pe kiykiy kiyata hu ndramat hayah para hu koro nimnim kaliy.>> Yihu ndramat huhilingi Yesu iwong tehen toro, pe hupa, <<Melit aro, mbuna kirayah!>> ");
INSERT INTO nss_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pwen pe Yesu maran iya mwonen iya kili hu, pe isok, ipa, <<Pwayan kinpwai, tehe Pat mepo yihu ndramat para puliya seu hulowaniy, ara kintayah pat para sotuna seu. Pe mbulndroiyi nongan mepo hu kantatuluwiy aro, ara tesah? ");
INSERT INTO nss_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kapa sehe ndramat kiyos kiya ndrita pat aro, ara andre kimwalulut. Pe kapa pat ara kiyos kiya ndrita ndramat hamou, ara andre kirapisa yiy.>> ");
INSERT INTO nss_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yihu ndramat para hinuwani nongan para pwahanou, pe hu pris huhohin ta hu pris masih, ara huro ten sai para hu kambultuwe yiy kileh. Paratesah, yihu kanyirowei tehe nongan pwandritiye kinpwai ara, ara iyingani hu imwonen. Hapeko hunoh iyata hu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pwen pe hu pris huhohin ta hu pris masih, pe yihu ndramat para hinuwani nongan para pwahanou, ara huro memerani Yesu. Pe hu pwandrisa hu ndramat para tandrihindrih huya, pe hurapihiye hu tehe kultuwayihu imwonen. Hapeko, huro longe para Yesu kipa nongan sahin, mepo ilahiy para hu karatuni yiy kaliy. Pwen pe andre hu kambultuwe tahatini yiy, pe hu kaiki yiy kiya pahandra pwoke nopwaran ata pohon para kol, para kiyki yiy kiya nongan. ");
INSERT INTO nss_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pwen yihu ndramat para tandrihindrih ara, ara husok Yesu, hupa, <<Ndramat para Hinonou, yowu pahasaniy tehe nongan ngara apwai pe tesah ngara ahanuwaniy, ara imwonen opu. Pe tesah ngara ambusiy, ara masih ihisoule ko iya kili hu ndramat masih. Pe ngara ahanuwani hu ndramat kiya nongan para kultuwayi Ngindrai iho ndruwa nongan ndrokonan masih.>> ");
INSERT INTO nss_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pwen husok, hupa, <<Hiyan para yowu kayuk takis kiya kili Sisar, ndre pwi?>> ");
INSERT INTO nss_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hapeko Yesu kinyirowe pwakekeriu tahu pwen, pe ipwai iya kili hu ipa, ");
INSERT INTO nss_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Akapwaingani sombule pat hambut kisa kili yo na. Sombule pat aro, ara sumwoiwa hiyeh pe ngala hiyeh iripo aliy?>> ");
INSERT INTO nss_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pe husomwi yiy, hupa, <<Ata Sisar.>> Pwen ipwai iya kili hu, ipa, <<Akaiki tesah ata Sisar kiya kili Sisar, pe tesah ata Ngindrai, ara kiya kili Ngindrai.>> ");
INSERT INTO nss_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pe yihu ara kanlahiy para yihu karatuni yiy kiya nongan sahin ipwai iro mbulmara hu ndramat, ara pwi. Pe lohongahu indrap iya nongan isomwi hu iya aliy, pe hu kanpalat o huro. ");
INSERT INTO nss_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yihu Satyusiy hayah husa kili Yesu para hu kasok yiy kiya soksok sahin. Yihu Satyusiy masih, ara hupa ndre hu ndramat humat andre hu kansa tine paiwe pwi. ");
INSERT INTO nss_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pwen husok yiy, hupa, <<Ndramat para Hinonou, Mose kintatuluwi nongan sahin kinsa kili worou, ipa toro: kapa ndramat hamou nalin kimat pe nambuyun kihou, pe norun pwi, ndramat ara, kiwiri pihinau ata nalin pe kipo mbunah kiya soiwi ngala nalin.>> ");
INSERT INTO nss_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pwen ipwai, ipa, <<Hu ndramat manandrtimou hu nalihu huyen. Yiy ndrohan, ara iwiri pihin hamou iya nambuyun, pe norun pwi, pe imat. ");
INSERT INTO nss_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pwen parahara ndrohan iwiri nambuyu nalin pe norun pwi yi. ");
INSERT INTO nss_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pwen yiy iho ndruwa parahara ndrohan, ara iwiri nambuyu nalin i. Pwen tehen tora ko, yihu manandrtimou kene huwiri pihin ara ko, pe hu masih kene noruhu pwi, pe humat topwei. ");
INSERT INTO nss_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pe iyamulan masih pihin ara, ara imat i. ");
INSERT INTO nss_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kapa yihu manandrtimou kene yihu wiri yiy tehe nambuyuhu, pwen kiro mwonen lang para hu ndramat kasa tine paiwe, pwen pihin ara, andre kirayah nambuyu hiyeh ndrokonan?>> ");
INSERT INTO nss_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pwen Yesu ipwai, ipa, <<Yihu ndramat hasap hu topo mahapo, ara ngara yihu kasokombut yesowai pe kayesou. ");
INSERT INTO nss_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hapeko lang itapo isa, yihu mepo Ngindrai kintakinimahu, para hu kasa tine kimat paiwe, kiya lang mulan, ara yihu andre kanyesou pwi, pe andre hu kansokombut yesou pwi yi. ");
INSERT INTO nss_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pe yihu kanlahiy para hu kanmat pwi, paratesah, yihu, andre hu koro ko tehe hu angelou. Pe yihu, ara tehe noru Ngindrai, paratesah, yihu kantali kimat pe kansa tine paiwe. ");
INSERT INTO nss_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hapeko Mose kinyinganiy tehe yihu ndramat kanmat, ara ngara yihu kasatine paiwe. Pe ipwainganiy iya kei mendreheh ara, mepo mwan iyat aliy, pe iratuluwi nongna Yapan, ipa, <Yo urupo Ngindrai ta Apraham, pe urupo Ngindrai ta Yisak, pe urupo Ngindrai ta Yakop.> ");
INSERT INTO nss_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Akanimei! Yiy ara Ngindrai tahu ndramat mepo hu kanmat, ara pwi. Hapeko yiy ara Ngindrai tahu ndramat hutopo mwalen, tehe Apraham, Yisak pe Yakop. Iya mbulmara Ngindrai, hu ndramat masih ara hu topo mwalen.>> ");
INSERT INTO nss_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pwen yihu ndramat hayah para hinuwani nongan para pwahanou, ara husomwi yiy, hupa, <<Ndramat para hinonou, nongnam, ara imwonen!>> ");
INSERT INTO nss_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pe yihu ndramat masih ara, yihu hindrundru para hu kasok yiy kiya nongan handra paiwe. ");
INSERT INTO nss_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pwen Yesu ipwai iya kili hu, ipa, <<Paratesah, pe hu ndramat ngara hu kapa tehe Kristus, ara noru Tepit? ");
INSERT INTO nss_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pe Tepit mbukenan, ara kinpwai pwen ita Puk Waliy, ipa toro: <Yapan ipwai iya kili Yapan to, ipa, <<Asampwan kapwen te nimo mot, ");
INSERT INTO nss_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kipoo, kuiki hu hiyeh huhingasi wou, ara hu kaya pahandra ndrikam.>> > ");
INSERT INTO nss_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pwen pe kapa Tepit iyoh yiy <Yapan,> pwen tehen tapeh ilahiy para kiya norun?>> ");
INSERT INTO nss_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yihu ndramat huro tahilong manau, pwen Yesu iwong iya kili ndramiran hu ipa, ");
INSERT INTO nss_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Mara wawu kiro tahu ndramat para hinuwani nongan para pwahanou. Yihu namiliy para hu koho rokai kiyapolo koyau niwen kiro koliuliu pwan, pe hunamiliy para hu ndramat karawulohani hu koro hu ndroho pehei Pe ngara hu kanamiliy para hu kampwan koro hu pwapwai hiyan hu ndramat ngara hu kahaiyaniy, para nondriya hu yumwa totohun . Pe yihu ngara kapirani hu ndrohonoku mipwan hiyan tora mu, koro nondriya hu yon. ");
INSERT INTO nss_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wawu ngara kapakaiwani hu menmena hu pihinau topwei. Pe ngara wawu kawaiyani totohun kiro mbulmara hu ndramat. Pwen pe wawu andre kawiri koran namandran iya.>> ");
INSERT INTO nss_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu maran iya pe inime hu ndramat menmenahu soyon, ara huroiki hu yukyuk tahu iya nondriya kokou para sombule pat, iro nondriya yumwa totohun namandran. ");
INSERT INTO nss_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pe yiy inime pihinau hamou menmenan pwi, ara iyaiki sombule pat malmbut mbuskau. ");
INSERT INTO nss_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pwen Yesu ipa, <<Yo upwai ndrokonan isa kili wawu, tehe pihinau menmenan pwi aro, yukyuk tan ara, ara iho hin iya, iya kili hu ndramat masih. ");
INSERT INTO nss_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hu ndramat masih, ara huiki tahape-tahape iyau menmena hu soyon pe husaikiy tehe yukyuk iya nondriya kokou para sombule pat. Hapeko pihinau aro, konan menmenan pwi masih, sohoyan hape imin, ara iykiy topwei.>> ");
INSERT INTO nss_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yihu ndramira Yesu hayah, ara huro tiyani nonowa yumwa totohun namandran, mepo hunowiy iya hu pat mepo lahayan iya, pe iyapolo hu yukyuk kanhaiyaniy pwen kinnata Ngindrai. Hapeko Yesu ipa, ");
INSERT INTO nss_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Sehe melit mepo wawu tora nimei mahapo ara, ara lang itapo isa, andre pat sih kinye ndron ndrita sih pwi. Andre hu pat masih kene ara, andre katipiyani hu topwei kaya pwan.>> ");
INSERT INTO nss_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pwen pe husok yiy, hupa, <<Ndramat para hinonou, hu melit aro kene, andre hu karayah kahaleh? Pe sehe kaipisa melit nakisa kimu, para kipwainganiy tehe pakeh hu nakarayah?>> ");
INSERT INTO nss_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Pwen isomwi hu, ipa, <<Mara wawu kiro; matisan hu kapakarawani wawu. Yihu ndramat soyon andre hu kasa kiya ngolo, pe andre hu koro pa, <Ara Yo!> Pe andre hu koro pa, <Lang ara, kinsa pakeh!> Hapeko wawu mbuna akoro ndruwa hu. ");
INSERT INTO nss_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kapa wawu kahilingiy tehe hu pahun koro tayah, pe hu koro rapiyani hu pohon para hu kol namandran masih, ara wawu mbuna akanoh. Hu melit aro kene, ara andre hu karayah kimu; hapeko lang para hu melit masih kene kisahapwen, ara andre kinsa kileh pwi.>> ");
INSERT INTO nss_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pwen ipwai iya kili hu, ipa, <<Kol hakol namandran masih, andre kipo pahun kiya kili kol hakol namandran masih, pe king para kol hakol andre kipo pahun kiya kili king para kol hakol. ");
INSERT INTO nss_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pe hu nunuw namandran iya andre karayah, pe hu mundruwai namandran pe hu mwamwa handra-handra andre karayah kiro nondriya hu kol hayah. Pe andre wawu kanime hu melit namandran handra-handra para kipanohowani wawu, pe andre wawu kanime hu kaipisa melit hayah namandran hu karayah koho yang. ");
INSERT INTO nss_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hapeko hu melit masih aro kantayah mapu, pwen andre hu ndramat hu kapwalngani wawu, pe karandroyani wawu. Andre hu kaiki wawu kaya nongan koro nondriya hu yumwa totohun, pe kaiki wawu kaya nondriya hu kou. Pe andre hu kawiri wawu koro tine mbulmara hu king pe hu pohon para kol. Iya ngolo kopu, andre wawu kawiri hu nopwaran masih aro. ");
INSERT INTO nss_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Melit masih ara andre karasaya wawu, para wawu katiyani tiyeyo kiya kili hu. ");
INSERT INTO nss_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hapeko wawu hamou-hamou kasarayah kiya lohongai sahin, para wawu mbuna akalohonge soyon pe akamwanye wawu kimu, kiya sehe nongan para wawu nakapenani wawu kaliy. ");
INSERT INTO nss_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Paratesah, andre kuiki hu nongan pe lohongai waison, pwen yihu hiyeh nakaiki wawu kaya nongan, ara andre hu kanlahiy para kakaituwe nongna wawu, pe karapaiwani nongna wawu pwi. ");
INSERT INTO nss_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pe tama wawu hu pe tina wawu hu, iyapolo nali wawu hu, pe yowe wawu hu, pe kowase wawu hu, ara andre hu kaiki wawu kiya nima hu ndramat hiyeh hu hingasi wawu, pe andre hu katingundru hayah tawawu kamat. ");
INSERT INTO nss_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tunan yo kopu, pwen andre hu ndramat masih kahangasi wawu. ");
INSERT INTO nss_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hapeko kompai hamou ita paya wawu, ara andre kinmut pwi. ");
INSERT INTO nss_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pe kapa wawu koro tine pwokeyan, pwen andre wawu kawiri taleh. ");
INSERT INTO nss_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kiro mwonen wawu kanime hu ndramira pahun hu karakayani Yerusalem, pwen andre wawu kapahasaniy tehe lengen para hu kapwalngani kol namandran ara, ara kinsa pakeh. ");
INSERT INTO nss_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pwen wawu hiyeh tora kol Yutiya lang ara, ara wawu kawop kileh kaya hu ngondron, pe hu mepo hutora nondriya kol namandran Yerusalem, ara hu kawop kaya mawen. Pe hu mepo hutora hu kol para parangondron ngawan, ara hu mbuna kaya nondriya kol namandran. ");
INSERT INTO nss_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kiro mwonen ara, ara lang para Ngindrai kiyki koran; pwen pe nongan masih mepo hu kantatuluwiy mamu kinna, ara andre kirayah mannan. ");
INSERT INTO nss_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Toimwa hu pihin mepo mapundriyahu, pe hu hiyeh huhusuwe noruhu malaman, ara andre hu kaiki koisariy kiho nondriyahu lang ara. Paratesah, nopwaran namandran andre kirayah kiro kol pwan, pe ndrinalokuh ta Ngindrai, ara andre kiro ndrita hu ndramat hasap aripo. ");
INSERT INTO nss_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pe andre hu karut ngundruhu kiya semela pahun niwen, pe andre hu kambultuwe tahatini hu pe kaluwani hu kaya kene hu kol namandran masih para kol pwan. Yihu Ndramira Lah, andre yihu kangastoro kaya Yerusalem tehen tora ko, kipoo Ngindrai kipwai tehe lenge hu Ndramira Lah hu koro Yerusalem, ara kiyahapwen. ");
INSERT INTO nss_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Pe kaipisa melit hayah andre karayah koho paramwandrai, walah, pe hu piriy. Pe kiro kol pwan, ara hu ndraye ndramat para hapat-hapat masih, andre hu kahilingi ngasangasa nowei kiro rambumbusau ndrita ndras pe kiro talon; pwen andre lohongahu kamwakaikai kiya nopwaran mepo nakisa raporuwi hu. ");
INSERT INTO nss_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Andre koyu hu ndramat kimwa, kiya hu melit mepo nakarayah kiro kol pwan. Pe hu ndramat andre kanoh turuwehu, pe andre kimbusi hu pe marahu kawuh. Pe hu pwoke para yang, ara andre hu kamemeyeu. ");
INSERT INTO nss_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kiro mwonen lang ara, andre hu kanime Noru Ndramat kiyau kokom kisa pwan, kiyapolo pwoke pe nonowa nganan namandran. ");
INSERT INTO nss_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pwen kiro lang mepo hu melit ara hu koro tayah, akatine pe paya wawu kitandras, paratesah, lang para Ngindrai nakiwiri wawu kamui, ara kinsa pakeh.>> ");
INSERT INTO nss_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pwen Yesu itiyani nongan pwandritiye iya kili hu toro: <<Mara wawu kiya kei pik pe hu kei masih. ");
INSERT INTO nss_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pe kapa kaimbuwehu kasasunet, wawu masih andre kayirowei tehe lang para mwandrai nakising ara kinsa pakeh. ");
INSERT INTO nss_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tehen tora ko, kapa akanime hu melit aro koro tayah, ara akapahasaniy tehe lenge kolo King Ngindrai, ara kinsa pakeh. ");
INSERT INTO nss_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Upwai ndrokonan isa kili wawu, hu ndraye hasap para mahapo aro, ara andre hu masih kanmat pwi, kipoo hu melit masih aro karayah topwei. ");
INSERT INTO nss_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kol paingan yang pe kol pwan, ara andre kihipwen, hapeko hu nongno ara andre kanhipwen pwi. ");
INSERT INTO nss_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Wawu koro hinehes; namiliwai para nombuwe wawu, pe kultuw para kuimwa ndran ngahan para kiringi wawu, pe koyu wawu kisosoyo kiya mipwan ta wawu, ara matisan melit masih tehen tora, andre kaporuwi wawu. Pwen kindrou pwi ko, andre mwoiwa wawu kihin para lenge Yapan kisa, pe kikami wawu porosih o. ");
INSERT INTO nss_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Paratesah, lang ara andre kisarayah kisa kili hu ndramat masih kene hutopo kol pwan masih. ");
INSERT INTO nss_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wawu koro hinehes lang masih, pe akoro tohun tehe wawu andre kalahiy para akoro mawen hu nopwaran masih nakarayah. Pwen pe andre wawu kalahiy para akoro tine mbulmara Noru Ndramat.>> ");
INSERT INTO nss_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lang sih iyau sih Yesu ngara kiro hinuwani hu ndramat koro yumwa totohun namandran, pe ping sih iyau sih ngara kiyau pe kiya matin kiya ngondron mepo hupohowei Ngondron para hu Holip. ");
INSERT INTO nss_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pe makohun opu, yihu ndramat masih ngara hu kasa yumwa totohun namandran para kahalong yiy. ");
INSERT INTO nss_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pwen lenge Yon Para Ndrinanohun Mepo Yis Aliy Pwi, mepo ngara hu kapohowei Pasopa, ara iropo isa pakeh. ");
INSERT INTO nss_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pe hu pris huhohin ta hu pris masih, pe hu ndramat para hinuwani nongan para pwahanou, ara huro ten sai para katingundru Yesu, hapeko hunoh tahu ndramat. ");
INSERT INTO nss_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pwen Sinai isong iya nondriya Yutas, mepo ngalan handra Yiskariyot; yiy hamou tahu Songui pe Lumou. ");
INSERT INTO nss_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pwen pe Yutas, ara iya kili hu pris huhohin ta hu pris masih, pe hu namandran ta hu makundrayin para yumwa totohun namandran; pwen huro ten sai para Yutas kilahiy para kiratuni Yesu kiya nimahu tapeh. ");
INSERT INTO nss_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pwen hupwes, pe humburi lohongai para hu kahang yiy sombule pat hayah. ");
INSERT INT