﻿USE sofia;
DROP TABLE IF EXISTS sofia.nrz_vpl;
CREATE TABLE nrz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nrz_vpl WRITE;
INSERT INTO nrz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keliso ena pulu kubu idolina, ia Abela'amo mai Davida 'ava'avatai easi. ");
INSERT INTO nrz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abela'amo eta'u Isa'ako evapulua, Isa'ako eta'u Iakobo evapulua, Iakobo nakuna 'eva Iuda mai bo'akalana ita. ");
INSERT INTO nrz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda eta'u Pelese mai Sela evapuluta, sinata 'eva Tamala, Pelese eta'u 'Esalona evapulua, 'Esalona eta'u Lama evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lama eta'u Aminadaba evapulua, Aminadaba eta'u Nasona evapulua, Nasona eta'u Salamona evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamona eta'u Boasi evapulua, sinana 'eva La'aba pulu edea ateatena. Boasi eta'u Obeda evapulua, sinana 'eva Luta pulu edea ateatena. Obeda eta'u Iese evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese eta'u vanua Lovia 'olana Davida evapulua. Davida eta'u Solomona evapulua, ia sinana 'eva 'ana'inai Ulia adana. ");
INSERT INTO nrz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona eta'u Le'oboama evapulua, Le'oboama eta'u Abia evapulua, Abia eta'u Asa evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa eta'u Ie'osabata evapulua, Ie'osabata eta'u Iolama evapulua, Iolama eta'u Usia evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia eta'u Iotama evapulua, Iotama eta'u A'asa evapulua, A'asa eta'u 'Esekia evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","'Esekia eta'u Manase evapulua, Manase eta'u Amona evapulua, Amona eta'u Iosia evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia eta'u Iekonia mai bo'akalana evapuluta, melala kanaua'i Babulono kauta deta'u Isalaela kauta deabita devuata deda'a eta kanobatai. ");
INSERT INTO nrz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Vaida devuata deda'a Babulono mulinai Iekonia eta'u Sealetiele evapulua, Sealetiele eta'u Selubabele evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabele eta'u Abiuda evapulua, Abiuda eta'u Eliakima evapulua, Eliakima eta'u Asolo evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asolo eta'u Sadoka evapulua, Sadoka eta'u Akimi evapulua, Akimi eta'u 'Eliuda evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","'Eliuda eta'u Eleasala evapulua, Eleasala eta'u Matana evapulua, Matana eta'u Iakobo evapulua. ");
INSERT INTO nrz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo eta'u Iosepa evapulua. Iosepa adana Malia eta'u Iesu evapulua, kau vana de'aeia Keliso vamauli kauna. ");
INSERT INTO nrz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kanaua'i Abela'amo enai eda'a Davida enai 'eva ulu 'ouka vani, Davida enai eda'amo deda'a vaita Babulono melalanai vaka ulu 'ouka vani, mune'e devuata deda'a Babulono mulinai eda'amo Keliso enai vaka 'eva ulu 'ouka vani. ");
INSERT INTO nrz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keliso a epulu koma valina 'eva kanania. Sinana Malia 'eva deluva 'ana'i vaia Iosepa beadavala, beia asido'o devaka'onamo laloanai eikabasi Idume Kabukabuna siavunai melo ka beabia. ");
INSERT INTO nrz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosepa 'eva komolo kauna, sia eula Malia bevamalalaia kau mato vailatai 'ounai, eula luva 'ana'i kanaua vunivuniai bevavaia si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lalovai kanaua elalovaia laloanai, Lovia namana ena Anelu niviai kevanai ela'asi e'ouia ediaka, “Iosepa Davida 'ava'avana e, Malia iadavana sia bomakau, 'olana Idume Kabukabuna siavunai melo kanaua beabia. ");
INSERT INTO nrz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ia 'eva melo ka bevapulua, vana oi bo'aea Iesu, 'olana ia 'eva ena kau eta si'avanai bevamaulita.” ");
INSERT INTO nrz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Koa kanania epulu 'eva Lovia namana ena enolea kauna e'ouia luvana evamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Vato makamaka ka besivabu melo ka bevapulua, vana be'aea 'Emanuela.” Anina 'eva ‘Dilava ita kevatai’. ");
INSERT INTO nrz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosepa eibi mulinai, Lovia namana ena Anelu eluva vitaitana evavaia Malia eadavala. ");
INSERT INTO nrz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ia laluana sia deno ka'ona kovo eda'amo Malia melo evapulua. Iosepa melo vana e'aeia Iesu. ");
INSERT INTO nrz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","'Eloda Lovia 'olana Iuda eloviala melalanai, Iesu 'eva Iuda laloanai Betele'emai epulu. Boni kanaua'i aoneka kauta dae duasi kanobata edeana ai deasi deda'a Ielusalema ");
INSERT INTO nrz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","inoku delavuai lavuai dediaka, “Iuda emui Lovia 'olana epulu melona 'eva a'i? Ia ena visiu dae duasi lai aikala 'ounai lai a'asi bakukudivo venia”. ");
INSERT INTO nrz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","'Eloda Lovia 'olana luva kanaua eika koanai nuana ebata, mai Ielusalema ai kau boutai vaka nuata debata. ");
INSERT INTO nrz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Eloda eta'u Iuda eta kabukabu kauta namata mai talavatu 'ola kauta boutai e'aeta deasi dedo'u inoku elavuaita ediaka, “Keliso 'eva a'i bepupulu?” ");
INSERT INTO nrz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ia ena luva devamuea dediaka, “Iuda, Betele'ema laloanai. Enolea kauna kanania eleleia koma. ");
INSERT INTO nrz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Oni Betele'ema, Iuda kanona laloanai, Iuda deikala kao vanuata viloatai oni 'eva sia okiki vaika, 'olana oni emuai 'eva 'ola'ana'i kauna ka be'asi ia 'eva e'u Isalaela kauta be'ana'ia vaita mamoe i'imata kauna boina.’” ");
INSERT INTO nrz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Inoku 'Eloda aoneka kauta e'aeta vunivuniai dedo'u elavuaita beikabasi kave'i melala davana umaunai 'eva visiu kanaua ela'asi. ");
INSERT INTO nrz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Esinita beda'a Betele'ema inoku e'outa ediaka, “Oi boda'a melo 'oma'omana kanaua oi bokavua kave'i. Oi bodavalia koanai oi bovaikabasi'u, inoku lau vaka bada'a ia bakukudivo venia.” ");
INSERT INTO nrz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aoneka kauta 'Eloda lovia 'olana lelena deika mulinai dalai deda'a laloanai visiu kanaua dae duasi deikaia davana e'ana'ia vaita eda'amo melo emia 'abunai evuakao. ");
INSERT INTO nrz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Visiu kanaua deikaia koanai lalota denama keini. ");
INSERT INTO nrz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Luma kanaua laloanai dedodo koanai melo sinana Malia ita deikata inoku dekuidula melo dekukudivo venia. Mulinai eta lavo deluvuta inoku veniveni davata kolo, mulamula bonana mediana, mai mulamula kula'ilana kauani bedavua davana dedalata isi deainama venia. ");
INSERT INTO nrz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Inoku Dilava niviai e'outa kao sia bemumue 'Eloda kevana, inoku dala edeana deda'aia demue deda'a eta kanobata. ");
INSERT INTO nrz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aoneka kauta deda'a mulitai Lovia namana ena Anelu niviai Iosepa kevanai ela'asi e'ouia ediaka, “Ko'isi melo sinana ita vada'ata oveauovo oda'a Aikupito. Ua'i oi bomimia beda'amo lau ba'oumu, 'olana 'Eloda 'eva 'ani melo bekavua beaku bala.” ");
INSERT INTO nrz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Inoku, Iosepa eko'isi melo sinana ita evada'ata boni kanaua'i deda'a Aikupito, ");
INSERT INTO nrz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ua'i demia beda'amo 'Eloda bebaba. Kanaua 'eva Lovia namana ena enolea kauna nutunai eluvavaia luvana ivamomo'aina, “Lau Aikupito ai Naku'u a'aeia la'asi.” ");
INSERT INTO nrz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","'Eloda eikabasi aoneka kauta delebaia mai sia bemumue kevana 'ounai, ia nuana e'avala si'asi'a, aoneka kauta elavuaita bonina elalovaia vitaitanai luva eveni ena kuali kauta Betele'ema mai vanua kele'enai davata laloatai melo boutai vikauta lua mai venuai kauta deakubata. ");
INSERT INTO nrz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Melala kanaua'i enolea kauna Ielimaia eluvavaia luvana 'eva emomo'ai, ");
INSERT INTO nrz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lele ka Lama ai deika kani mai vilalo nama vaikana, La'ela nakuna ekani diata, ia nuana bevakula'ilala 'eva sia eula 'olana boutai 'ani deba palu.” ");
INSERT INTO nrz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","'Eloda eba mulinai Aikupito ai Lovia namana ena anelu Iosepa kevanai niviai ela'asi, ");
INSERT INTO nrz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","e'ouia ediaka, “Ko'isi melo sinana ita vada'ata omue oda'a Isalaela kanonai, 'olana melo beaku bala kauta kataua 'eva 'ani deba”. ");
INSERT INTO nrz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Inoku Iosepa eko'isi melo sinana ita evada'ata deda'a Isalaela. ");
INSERT INTO nrz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Beia Akelao kamana 'Eloda 'abuna eabia Iuda eikaia kao valina eika koanai, beda'a Ielusalema 'eva emakau. Inoku niviai vaikabasi eabia 'ounai ekeini eda'a Kalilea. ");
INSERT INTO nrz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ia deda'a vanua ka vana Nasaleta ua'i demia, kanaua 'eva enolea kauta deluvaia luvana emomo'ai ia 'eva be'aea Nasaleta kauna. ");
INSERT INTO nrz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Boni kataua'i Ioane Vaidi'u kabukabu kauna ela'asi Iuda kano'akunai ena ilolo emakavala ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Emui si'avanai olalo 'udai, 'olana Dilava ena lovia vanuana 'eva 'ani ekevai.” ");
INSERT INTO nrz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kanania 'eva enolea kauna Isaia eta'u eluvavaia makava ediaka, “Kau ka kano'akunai evaoi ediaka, ‘Lovia namana ena dala ova'olua, Ena da'a dalana ovakomoloa.’” ");
INSERT INTO nrz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioane ena tubu'a 'eva Kamela vuinai evavaia, mai kukuana 'apana 'eva bolomakau avana elioia, ena iani 'eva 'oasi'o mai metunu veina. ");
INSERT INTO nrz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ielusalema kauta mai Iuda laloanai vanua boutai, maivaka Iolidana nutu kele'enai vanua boutai kauta deasi kevana lelena be'ika. ");
INSERT INTO nrz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eta si'avana e'ou kao, mai Iolidana nutunai evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ioane Palisea kauta mai Sadukea kauta doutamo deasi kevanai bevaidi'uta kabukabu dekoma koanai e'outa ediaka, “Kau'asi nakuna kaumui e. Dai e'oumui anaana Dilava 'ani besinia kanaua kele'enai oi boveau tau? ");
INSERT INTO nrz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lalo'udai vuavuana ovala'asia. ");
INSERT INTO nrz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nuamuiai sia oi bodiaka oi 'eva Abela'amo 'ava'avana 'ounai anaana kanaua kele'enai oi boveau tau. Lau oi a'oumui Dilava 'eva mai siavuna bika'a katania'i Abela'amo 'ava'avana bevavaita! ");
INSERT INTO nrz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ila 'eva 'ani e'olu au 'olanai, vuavua nama'ita sia devapulu auta boutai 'eva beuku'eko 'alova laloanai bekapota dodo. ");
INSERT INTO nrz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lau 'eva veiai mo avaidi'umui kabukabu emui lalo'udai koana, beia lau muli'uai e'asi kauna 'eva Idume Kabukabuai mai 'alovai bevaidi'umui kabukabu. Ia ena siavu 'eva lau ekeini'u, lau sia anama'ina vaika ena tamaka bavuata. ");
INSERT INTO nrz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ena witi iaku mukamukata auna imanai eabia, ena witi 'abuna bevavaia kave'i, ena witi nama'ita 'eva idoubouta vakavakanai bedoubou, beia lu'ulu'uta 'eva sia ebo'o kovo 'alovanai betotou.” ");
INSERT INTO nrz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Boni kanaua'i Iesu 'eva Kalilea ai easi Iolidana nutuna ai Ioane kevana bevaidi'ua kabukabu ekoma. ");
INSERT INTO nrz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Beia Ioane eula Iesu nuana bevamuea 'ounai ediaka, “Oni lau bomavaidi'u'u kabukabu 'eva bemanama'ina. Beia dava 'ounai oasi lau keva'u.” ");
INSERT INTO nrz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu Ioane ena luva evamuea ediaka, “Vali'u kanania 'eva oni bovavaia. Vinaula kanania'i Dilava ena komolo vinaulata boutai ekavamomo'aita.” Inoku Ioane eta'u Iesu evaidi'ua kabukabu. ");
INSERT INTO nrz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu eidi'u kabukabu mulinai, veiai ele'au koanai komolonai vutuvutu eviluvu inoku Dilava Idumena e'ovu easi akanai itani boiomalo boina eikaia. ");
INSERT INTO nrz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Inoku lele ka vutuvutuai e'aeasi ediaka, “Kanania 'eva lau Naku'u umauna, E'u lalo'au. Lau 'eva ia alalonama venia.” ");
INSERT INTO nrz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Inoku Idume Kabukabuna eta'u Iesu evada'ala deda'a kano'akunai diabolo betata'u bevakovoa. ");
INSERT INTO nrz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu boni vaninavui mai lani vaninavui elove sia iani kena eania mulinai ia 'eva vikolo eaku si'ala. ");
INSERT INTO nrz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Laloanai ivakovo kauna easi Iesu kevana e'ouia ediaka, “Bema oni Dilava nakuna koanai, bika'a katania outa palaoa be'ao.” ");
INSERT INTO nrz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Beia Iesu ediaka, “Puka kabukabunai 'ani ilelena ‘Kau 'eva sia ianiai mo bemauli, Beia Dilava nutunai dela'asi luvata boutai ai bemauli.” ");
INSERT INTO nrz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kanaua'i diabolo eta'u Iesu evada'ala Ielusalema vanua kabukabunai, Lo'e kabukabuna kubuanai evalavala 'au, ");
INSERT INTO nrz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","inoku diabolo Iesu e'ouia ediaka, “Bema oni Dilava nakuna koanai, sibomu kanana'i lovo asi. 'Olana Puka kabukabunai 'ani ilelena, ‘Dilava ena anelu be'outa be'imamu imatai beabimu isi, kanaua'i aemu bika'ai sia boakua.’” ");
INSERT INTO nrz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu ia ena luva evamuea ediaka, “Puka kabukabunai vaka kanania ilelena koma, ‘Lovia namana emu Dilava sia bovakovoa.’” ");
INSERT INTO nrz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Inoku mune'e diabolo eta'u Iesu evada'ala lolo lakavaikana toilinai evalavala'au, inoku kanobata vanuata boutai nuavita evaikala. ");
INSERT INTO nrz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Diabolo ediaka, “Bema bokuidula bokukudivo veni'u koanai, katania boutai oni bavenimu.” ");
INSERT INTO nrz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu diabolo e'ouia ediaka, “Satani e, da'atau! Puka kabukabunai 'ani ilelena, ‘Lovia namana emu Dilava sibonamo bokukudivo venia, mai da'alana bo'abi.’” ");
INSERT INTO nrz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kanaua'i diabolo Iesu kele'enai eda'a ovo, inoku anelu deasi deduluia. ");
INSERT INTO nrz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu Ioane vabuto'o lumanai de'alavua valina eika koanai emue eda'a Kalilea kanonai. ");
INSERT INTO nrz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sia ua'i Nasaleta vanuanai emia, beia eda'a Sebulona mai Napatali kanotai Kalilea 'ovu 'aba'abanai vanua ka vana Kapelanauma ua'i emia. ");
INSERT INTO nrz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kanania epulu 'eva Isaia enolea kauna eluva luvana 'eva bemomo'ai, ");
INSERT INTO nrz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulona kanonai mai Napatali kanonai, 'ovu 'aba'abanai, Iolidana nutu avekenai, Kalilea pulu edea kauta eta kanoai! ");
INSERT INTO nrz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kau vabuto'oai demia kauta 'eva 'ailala nama vaikana 'ani deikaia. Mai ba va'ava'ana kanonai demimia kauta akatai 'eva 'ailala 'ani ela'asi.” ");
INSERT INTO nrz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Melala kanaua'i Iesu ena ilolo emakavala ediaka, “Emui si'avanai olalo 'udai, 'olana Dilava ena lovia vanuana 'eva 'ani ekevai!” ");
INSERT INTO nrz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu Kalilea 'ovu 'aba'abana eda'aia eda'a koanai, a'a mai kadi lalua eikata, Simona vana ka 'eva Petelo, kadina Andelea ita eta vuo 'ovu laloanai denaia, 'olana ia 'eva va'eka kauta. ");
INSERT INTO nrz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu e'outa ediaka, “Muli'uai omai. Lau batata'u kau iva'eka venita kaumuiai bavaaomui.” ");
INSERT INTO nrz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Komolonai mo eta vuo devikanita mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eda'a ilulao 'eva a'a kadi lalua Iakobo mai Ioane kamata Sebedeo ita eta asi akanai eta vuo delaumeta eikata inoku e'aeta. ");
INSERT INTO nrz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Komolonai eta asi mai kamata devikania Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu Kalilea kanona itoina laloana eda'aia, Iuda kauta eta lo'e laloatai evaikabasi, Dilava ena lovia vanuana valina nama'ina eilolo vaia, mai kau eta 'olele edeata edeata mai anana edeata edeata boutai evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sulia kanobatana itoina laloanai valina dekava odaoda, kanaua'i kau deta'u 'olele edeata edeata kauta, anaana edeata edeata kauta, nuatai ka'uba si'avata vaika kauta, lalamamalo kauta, mai 'eko kauta devuata deasi Iesu kevana, inoku ia eta'u boutai evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kau mato nama vaikana Kalileai mai Vanua Oukana kataua'i, Ielusalemai mai Iudai, mai Iolidana nutuna avekenai kanota kauta Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu kau mato eikata koanai loloai ele'au emiadivo. Ibanona kauta deasi kevana, ");
INSERT INTO nrz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","inoku ena vaikabasi eabi lamala, ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Idume enai detabu kauta 'eva denama'ina, 'olana Dilava ena lovia vanuana 'eva ia eta. ");
INSERT INTO nrz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dekakani kauta 'eva denama'ina, 'olana Dilava bevakula'ilata. ");
INSERT INTO nrz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sibota deva kikita kauta 'eva denama'ina, 'olana eluva'ana'i vaia kanona 'eva ia eta. ");
INSERT INTO nrz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vinaula komolona devikolo vaia mai deveiba vaia kauta 'eva denama'ina, 'olana Dilava betata'u bo'ata bevakubu. ");
INSERT INTO nrz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vilalo kauta 'eva denama'ina, 'olana Dilava vaka ia 'ani belalota. ");
INSERT INTO nrz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nuata demakamaka kauta 'eva denama'ina, 'olana ia 'eva Dilava beikala. ");
INSERT INTO nrz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nua'elu vinaulana devavaia kauta 'eva denama'ina, 'olana ia 'eva be'aeta Dilava nakuna. ");
INSERT INTO nrz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vinaula komolona devavaia 'ounai devavaita si'asi'a kauta 'eva denama'ina, 'olana Dilava ena lovia vanuana 'eva ia eta. ");
INSERT INTO nrz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Lau muli'uai oi odada'a 'ounai kau benunulaimui, bevaiviivimui mai dede luvata si'avata vaika edeata edeata be'oumui 'eva oi onama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lalomui benanama mai oi bolalonama, 'olana vutuvutuai 'eva tavamui namavaikana. 'Ana'inai enolea kauta demia koanai kanania devavaita koma. ");
INSERT INTO nrz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Oi 'eva kanobata damenana. Bema damena dia'ana be'ole koanai, a bedia'a 'udai koma? Kevatai eta vinaula asi'i davata 'eva eka itota'au inoku kau akatai bemoi'au moi'au. ");
INSERT INTO nrz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Oi 'eva kanobata kauta eta 'ailala. Lolo akanai vanua devavaia vanuana 'eva sia bevunia bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kau ka lamepa betoua koanai olaka venunai sia bene'eadivo. Beia ikau'auna 'abunai bekaua'au, inoku kau boutai luma laloanai 'eva 'ailala bevenita. ");
INSERT INTO nrz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dala kanania vitaitanai, emui 'ailala kau vailatai ovala'asia beva'ailalata, kanaua'i vinaula nama'ita oi ovavai 'eva be'ika inoku Kamamui vutuvutuai bevanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sia oi bolalovaia lau asi 'eva Mose ena Talavatu mai enolea kauta eta vaikabasi babiovo. Lau asi 'eva sia babiovo beia eta vaikabasi bavamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Lau oi luva umauna a'oumui, kanobata mai vutuvutu betaule, beia lelelele kikina ka 'o luva kikina vaika ka talavatu laloanai sia betaule bedada'a mo dava boutai anita bepulu palu. ");
INSERT INTO nrz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kanaua 'ounai kau ka talavatu kikina vaika eukua inoku kau vaida vaikabasi kanaua vitaitana evaikata 'eva Dilava ena lovia vanuanai ia 'eva bekiki vaika. Beia dai talavatu 'olana e'aku mai vaikabasi kanaua vitaitana evaikata 'eva Dilava ena lovia vanuanai ia 'eva namana be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lau oi a'oumui, beia oi emui komolo vinaulata ai Palisea kauta mai talavatu 'ola kauta eta komolo vinaulata sia oi bokeinita koanai Dilava ena lovia vanuanai sia oi boda'a dodo kovo. ");
INSERT INTO nrz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ana'inai 'ava'avamui kele'etai deluvaia luvana 'ani oi oika. “Sia Boakuaku, beia beakuaku kauna 'eva lavuai 'abunai belalava.” ");
INSERT INTO nrz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Beia vali'u lau a'oumui. Kau ka bo'akalana ebaduvenia 'eva bevuala beda'a lavuai 'abuna. Mune'e kau ka bo'akalana bo'ona be'oua 'eva bevuala beda'a lavuai namana de'imala kauta kevatai. Beia kau ka bo'akalana be'oua bediaka, “Obo'o vaika.” 'eva bevuala beda'a 'abu si'avana vaika, ua 'eva 'alova sia ebo'o kovo 'abuna. ");
INSERT INTO nrz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kanaua 'ounai emu veniveni davana vala kabukabuna akanai oveveni laloanai bo'akalamu kele'enai emu va'eva ka emimia davana olaloaune koanai, ");
INSERT INTO nrz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","emu veniveni davana ua'i vala kabukabuna vailanai bovikania. Boda'a makava bo'akalamu kele'ena laluana oi boluvaluva mai oi bovaka'onamo, inoku bomumue emu veniveni davana boveveni. ");
INSERT INTO nrz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kau ka oni lavuai 'abunai bene'emu kauna vali'u oi laluana lavuai 'abuna oi oda'ala koanai, bova'amea va'eva kanaua oi bovakomoloa kaokao, vakaia lavuai vailanai bolavadivo. Kanaua sia bovavaia koanai, oni emu 'ou kauna lavuai e'imala kauna imanai beudamu, lavuai e'imala kauna betata'u vabuto'o lumana e'imala kauna imanai beudamu, inoku oni 'eva vabuto'o lumanai be'ulemu. ");
INSERT INTO nrz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lau luva umauna a'oumu, oni 'eva sia bola'asi kovo beda'amo emu va'eva tavana pene olena boveveni. ");
INSERT INTO nrz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Oi luva 'ani oika 'eva kanania eluva koma, ‘Oni kau ka adana sia bokulala.’ ");
INSERT INTO nrz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Beia lau oi a'oumui kau ka ateate eikala inoku elalovai si'asi'a 'eva nuanai 'ani kulakula koana ateate kanaua kevanai evavaia. ");
INSERT INTO nrz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Makamu idibana si'avanai ene'emu divo koanai, boia asi boitoa'au. Kauanimu le'ena ka betaule 'eva emediana 'olana kaumu itoina 'alova sia ebo'o kovo 'abuna laloanai asi'i emakapomu dodo. ");
INSERT INTO nrz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mai imamu idibana si'avanai ene'emudivo koanai, botaua uku boitoa'au. Kauanimu le'ena ka betaule 'eva emediana 'olana kaumu itoina 'alova sia ebo'o kovo 'abuna laloanai asi'i emakapomu dodo. ");
INSERT INTO nrz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Maivaka kanania eluva koma, ‘Kau ka adana eva'ovua koanai iva'ovu malelena ka belelea bevenia.’ ");
INSERT INTO nrz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Beia lau oi a'oumui, kau ka adana sia emaka si'a beia eva'ovua 'avaea ia 'eva eva'eva adana kulakula ai ene'eadivo, mai kau ka edeana betata'u deva'ovua ateatena kanaua beadavala koanai ia vaka kulakula koana evavaia. ");
INSERT INTO nrz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mune'e 'ana'inai 'ava'avamui etai deluvaia luvana 'ani oi oika, ‘Emui luva 'ana'i 'eva sia oi boluvala. Beia Lovia namana enai oi oluva 'ana'i davana 'eva oi bovavaia.’ ");
INSERT INTO nrz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Beia lau oi a'oumui. Sia oi boluva 'ana'i. Sia luva 'ana'i ka vutuvutuai oi bovavaia, 'olana ua 'eva Dilava ena mia'au 'abuna. ");
INSERT INTO nrz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'O kanobata ai luva 'ana'i sia ka oi boluvala, 'olana ia 'eva Dilava aena ivalavadivona 'abuna, 'o Ielusalema ai luva 'ana'i sia ka oi boluvala, 'olana ia 'eva lovia 'ola 'ou'ouna ena vanua. ");
INSERT INTO nrz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mai oni 'olamu ai luva 'ana'i sia boluvala, 'olana oni vuimu ka'onamo bovadeva'ia 'o bova'uma'umala 'eva sia oikabasia. ");
INSERT INTO nrz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Oni mo boluluva, ‘'O’ 'o ‘Asi'i’. Dava katania vaida akatai oluvavai 'eva kau si'avana kele'enai de'asi. ");
INSERT INTO nrz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Oi luva kanania 'ani oi oika ediaka, ‘Maka tavana 'eva maka, mai nike tavana 'eva nike.’ ");
INSERT INTO nrz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Beia lau oi a'oumui, kau ka ena si'avana tavana 'eva sia bovamuea. Kau ka metemu idibana bepi'ala koanai, metemu 'ealina vaka bovenia bepi'ala. ");
INSERT INTO nrz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kau ka e'ula emu ivadodo beabia 'ounai lavuai abunai bene'emu divo koanai, emu 'elutubu'a vaka bovenia. ");
INSERT INTO nrz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kau ka beva asiasimu maela ka'onamo boda'ala koanai, laluana maela lua oi boda'ata. ");
INSERT INTO nrz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kau denoimu davana 'eva bovenita, mai kele'emuai dava ka eula venia beabia 'avaea 'eva 'ouna sia bovavaia. ");
INSERT INTO nrz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Oi luva kanania 'uluna 'ani oi oika ediaka, ‘Kevamui kauta oi bolalo'au venita, inoku emui 'ou kauta 'eva oi bovaiviivita.’ ");
INSERT INTO nrz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Beia lau oi a'oumui, emui 'ou kauta oi bolalo'au venita mai devavaimui si'asi'a kauta daitai oi bomeamea. ");
INSERT INTO nrz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dala kanaua'i oi 'eva Kamamui vutuvutuai nakunai oi bo'ao. Ia 'eva si'avana kauta mai nama'ina kauta akatai ena melala evakalala, mai lamu evaakua komolo kauta mai va'eva kauta akatai. ");
INSERT INTO nrz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Oi kau delalo'au venimui kauta mo oi olalo'au venita koanai tavamui 'eva dava oi boabia? Moni visi kauta vaka kanaua devavai koma. ");
INSERT INTO nrz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Oi bo'akalamui mo ovanama'inata koanai, emui nama'ina 'eva dava kau vaida etai? Sia deabiveni kauta vaka kanaua devavai koma. ");
INSERT INTO nrz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kanaua 'ounai Kamamui vutuvutuai emimia kauna ekomolo vaika vitaitanai oi vaka oi bokomolo vaika.” ");
INSERT INTO nrz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Oi bo'imamui kave'i, emui komolo vinaulata kau vailatai sia oi bovavai be'ika. Kanaua oi bovavai koma koanai oi 'eva Kamamui vutuvutuai kauna kele'enai tavamui asi'i. ");
INSERT INTO nrz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kanaua 'ounai ainama davana ta'ovala kauna bovenia koanai, kau vailatai sia bo'apa, vitaitana apa kauta lo'e laloatai mai vanua bo'adatai devavaia boina kau ia vanama'ina bevenita 'ounai. Lau oi luva umauna a'oumui, ia 'eva tavata itoina 'ani deabia. ");
INSERT INTO nrz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Beia oi ta'ovala kauta oi oduluta koanai, imamu 'ealina sia beikabasi imamu idibana 'eva dava evavaia. ");
INSERT INTO nrz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kanaua'i emu ainama 'eva nuamuai bovunia. Inoku Kamamu dava vunivuniai depupulu eikata kauna oni tavamu beveveni. ");
INSERT INTO nrz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Oi bomeamea koanai sia apa kauta boitai oi bo'ao. Ia eta ula namana 'eva lo'e laloatai mai vanua bo'adatai belavadivo bemeamea kau beikata 'ounai. Lau oi luva umauna a'oumui, tavata itoinai 'ani deabia. ");
INSERT INTO nrz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Beia bomeamea koanai, emu laloa laloanai bodododo inoku emu nutuala bo'alavua bomeamea Kamamu sia oikala kauna kele'enai. Kamamu dava vunivuniai depupulu e'ika kauna tavamu beveveni. ");
INSERT INTO nrz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Oi omeamea laloanai luva anita asi'i davata doutamo sia oi bo'oulai itani pulu edea kauta devavaia boina. Delalovaia eta meamea elaka'ina 'eva Dilava leleta 'ani eika. ");
INSERT INTO nrz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sia ia boitai oi bo'ao. Oi Kamamui asido'o oi onoia laloanai 'ani eikabasi oi dava oi oula venia. ");
INSERT INTO nrz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Oi 'eva kanania oi bomeamea koma. ‘Kamamai e, vutuvutuai omimia. Oni vamu 'eva lai bavakabukabua. ");
INSERT INTO nrz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Emu lovia vanuana emai, boumaiai emu ula lai bavavaia kanobatai, vitaitana vutuvutuai devavaia boina. ");
INSERT INTO nrz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vali'u melala kanania amai lai aulaveni davata bovenimai. ");
INSERT INTO nrz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kau kataua kele'emaiai devavai si'asi'a kauta eta si'avana lai a'ou kao, vitaitana emai si'avana lai avavai davata 'ou kao. ");
INSERT INTO nrz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sia bovada'amai ivakovo laloatai, beia diabolo enai bovamaulimai. (Lovia vanuana oni emu, Siavu oni emu, Nuavi oni emu, beda'amo bemia keinikeini. Amen.)’ ");
INSERT INTO nrz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kau kataua kevamuiai devavai si'asi'a kauta eta si'avana oi bo'ou kao koanai, Kamamui vutuvutuai kauna emui si'avana vaka be'ou kao. ");
INSERT INTO nrz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Beia, bema oi kau eta si'avana sia oi bo'ou kao koanai, Kamamui vutuvutuai emimia kauna vaka emui si'avana sia be'ou kao. ");
INSERT INTO nrz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Oi ololove koanai vailamui sia oi bovavilalo itani apa kauta boita. Ikata koata devaedeanata kau boutai beikata beikabasi ia 'eva delolove. Lau oi luva umauna a'oumui, tavata itoina 'ani deabi. ");
INSERT INTO nrz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Beia oni bololove koanai, vailamu bodeini mai deolo ai 'olamu bovavaia. ");
INSERT INTO nrz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kau sia beikabasi oni 'eva oani kabu, ia Kamata sia kaikala kauna mo beikabasi. Inoku Kamamu dava vunivuniai depupulu eikata kauna betata'u tavamu beveveni. ");
INSERT INTO nrz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Emui lavo kanobatai sia oi bodoutabou, ua'i koekoe mai 'eme'eme betata'u bevasi'avanata, mai vinao kauta betata'u luma beaku papala bevinaota. ");
INSERT INTO nrz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Beia emui lavo 'eva vutuvutuai oi bodoubou, ua'i 'eva koekoe mai 'eme'eme sia bevavai si'asi'a, mai vinao kauta luma sia beaku papala inoku bevinaota. ");
INSERT INTO nrz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Inoku oni emu lavo 'abu davanai 'eva nuamu vaka ua'i. ");
INSERT INTO nrz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Maka 'eva kauani ena lamepa, oni makamu denama'ina koanai kauanimu itoinai 'eva 'ailala laloanai. ");
INSERT INTO nrz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Beia, bema makamu besi'avana koanai kauanimu itoinai 'eva vabuto'o laloanai. Inoku, bema oni nuamu 'ailalana evabula koanai vabula kanaua 'eva bevabulaavu. ");
INSERT INTO nrz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kau ka 'ola kauta lalua melala ka'onamoai da'alata sia be'abi. Ka ulana sia be'ula ia ka belalo'au venia, 'o ka lelena be'ika ia ka 'eva beva si'avanala. Oi Dilava mai lavo laluana melala ka'onamoai da'alata sia oi bo'abi. ");
INSERT INTO nrz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kanaua 'ounai lau oi a'oumui. Nuamui sia bebavunu, emui mauli 'ounai dava oi boma ani 'o dava oi bomainu, 'o kauanimuiai dava oi bomavadodo davata sia oi bolalovaita. Mauli 'eva bokama ekeinia, mai kauani 'eva tubu'a ekeinia. ");
INSERT INTO nrz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Akai delolovo manumanuta oikata. Ia kea sia devavado, sia de'ua'ua mai iani doubou doubou abutai sia de'ule, beia Kamamui vutuvutuai kauna 'eva e'imata kave'i. Beia oi emui nama'ina 'eva manumanu ekeinita. ");
INSERT INTO nrz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oi ka kena boma mauli dau'a lalovaina onua mekau vaia? ");
INSERT INTO nrz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mai dava 'ounai tubu'a enai nuamui ebavunu? La'uka vela a dekubu koma oi boikata. Ia sia debavunu 'o sibota tubu'ata sia devavai. ");
INSERT INTO nrz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Beia lau oi a'oumui, Solomona ena nuaviai tubu'a nama'ina evadodoa, ia vela katania 'eva denama'ina vaika. ");
INSERT INTO nrz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kanaua'i la'uka duvuta vali'u develavela mala 'ani belamoda 'alova laloanai bekapota dodo belo'olo'o davata tubu'ata Dilava etata'u kanania evadodota koma koanai, oi emui tubu'a kanaua sia bevavadodomui koma, una? Emui abiveni dekiki kaumui. ");
INSERT INTO nrz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanaua 'ounai nuamui sia bebavunu, sia oi bodiaka, “Ita dava eka ani?” 'o “Ita dava ekainu?” 'o “Ita dava ekavadodoa?” ");
INSERT INTO nrz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pulu edea kauta dava katania boita boutai dekakavu, beia oi Kamamui vutuvutuai 'ani eikabasi dava katania 'eva oi oula venita. ");
INSERT INTO nrz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Oi 'eva Dilava ena lovia vanuana mai ena ula vinaulana komolona oi bokavua makava, vakaia dava katania boita boutai 'eva oi bevenimui. ");
INSERT INTO nrz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kanaua 'ounai nuamu sia bebavunu mala enai. Mala 'eva sibona ena nua mekau. Boni ka ka eta mekau 'eva sibota eta.” ");
INSERT INTO nrz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Vaida va'eva 'abunai sia oi bone'etadivo 'olana Dilava oi vaka va'eva 'abunai asi'i emane'emuidivo. ");
INSERT INTO nrz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","'Olana oi vaida va'evai oi one'etadivo koanai dalana vitaitanai Dilava betata'u oi va'evai bene'emuidivo. Mai oi emui koakoa vaida kele'etai vitaitatai Dilava betata'u kevamuiai vaka bevavai. ");
INSERT INTO nrz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dava 'ounai bo'akalamu makana laloanai au na'ina'ina oikala, beia oni sibomu makamu laloanai au ubana lalovaina sia olalovaia? ");
INSERT INTO nrz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Dava 'ounai oni bo'akalamu o'oua, “Makamu laloanai au na'ina'ina babia ovo”? Ia oni 'eva makamu laloanai au ubana emimia. ");
INSERT INTO nrz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oni apa kaumu! Sibomu makamu laloanai au ubana boabia asi makava, vakaia boikaika kave'i inoku bo'akalamu makana laloanai au na'ina'ina boabia asi. ");
INSERT INTO nrz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kabukabu davana 'oveka sia oi bovenita, bekai'udai asi'i dema alamui 'ounai. Emui maili sia oi bokapota asi boloma vailatai. Aetai asi'i demamoikai moikaita 'ounai. ");
INSERT INTO nrz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Oi bonoinoi 'eva bevenimui, oi bokavua 'eva oi bodavalia, oi boakuaku 'eva nutualamui 'ani beluvu. ");
INSERT INTO nrz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kau ka ka benoinoi kauta 'eva bevenita, kavu kavu kauta 'eva bedavalia, mai beakuaku kauta 'eva nutualata beluvua. ");
INSERT INTO nrz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Oni kau davamu, nakumu bokama bemanoinoi koanai bika'a bomavenia, una? ");
INSERT INTO nrz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'O sisi bemanoinoi koanai kau'asi bomavenia, una? ");
INSERT INTO nrz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oi si'avana kaumui, beia nakumui dava nama'ita oi bovenita 'eva oi oikabasi. Kanaua 'ounai Kamamui vutuvutuai kauna betata'u benoinoi kauta dava nama'ita vida umauta bevenita, una? ");
INSERT INTO nrz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kau vaida kevamuiai dava oi oula venia bevavaia davana 'eva oi vaka kele'etai vitaitana oi bovavaia. Kanania 'eva Mose ena Talavatu mai enolea kauta eta vaikabasi luvana anina umauna. ");
INSERT INTO nrz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Oi 'eva nutuala omoomona laloanai oi boda'a dodo. 'Olana ba keinikeini eda'ala nutualana 'eva epalapala mai dalana namana, kau doutamo 'eva ua'i deda'adodo. ");
INSERT INTO nrz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Beia mauli keinikeini eda'ala nutualana 'eva eomoomo, mai dalana ida'ana 'eva epasisi, kau vavidamo dedavalia. ");
INSERT INTO nrz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Enolea dedeta kauta oi boikata kave'i, be'asi kele'emui ikata itani mamoe boita, beia nuata 'eva 'oveka 'asita aivalata boita. ");
INSERT INTO nrz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Oi 'eva kau kataua vuavuatai oi boikata une. Kavakava 'eva veivei vuana sia bevapulua, 'o 'ini auma 'eva moika vuana sia bevapulua. ");
INSERT INTO nrz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Vitaitana au nama'ita boutai 'eva vuata nama'ita devapulu, beia au si'avata 'eva vuata si'avata devapuluta. ");
INSERT INTO nrz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'A au nama'ina 'eva vuavua si'avana sia bevapulua maivaka au si'avana 'eva vuavua nama'ina sia bevapulua. ");
INSERT INTO nrz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Au kataua boutai vuavua nama'ita sia devapuluta davata 'eva be'uku 'alova laloanai bekapota dodo. ");
INSERT INTO nrz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kanaua 'ounai vuavua kataua boita 'eva enolea kauta dedeta 'ani oi boikabasita. ");
INSERT INTO nrz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kau boutai de'ae'u, ‘Lovia namana e, Lovia namana e,’ kau kataua boutai 'eva Dilava ena lovia vanuana laloanai sia beda'adodo, beia dai Kama'u vutuvutuai emimia kauna ena ula vinaulana bevavaia kauna 'eva beda'adodo. ");
INSERT INTO nrz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Melala kanaua'i doutamo be'ou'u bediaka, “Lovia namana e, Lovia namana e, oni vamuai lai aenolea, vamuai ka'uba si'avata lai alo'ota asi, maivaka vamuai vatabulovo koata edeata edeata lai avavai!” ");
INSERT INTO nrz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Inoku lau 'eva vailatai ba'outa kave'i badiaka, “Lau oi sia aikabasimui. Keva'uai oda'atau, oi si'avana ivavaina kaumui!” ");
INSERT INTO nrz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kanaua 'ounai kau ka e'u luva kanania 'uluna e'ika maivaka vinaulata evavai 'eva itani aoneka kauna boina ena luma bika'a akanai evalavala. ");
INSERT INTO nrz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lamu eaku abaka ela'asi maivaka lani namana eunu luma euteia, beia sia e'eko, 'olana luma 'eva bika'a akanai evalavala 'au. ");
INSERT INTO nrz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Beia kau ka e'u luva kanania 'uluna e'ika, inoku vinaulana sia evavaia 'eva itani bo'o kauna boina ena luma kano akanai evalavala. ");
INSERT INTO nrz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lamu eaku abaka ela'asi, mai lani eunu luma euteia inoku e'eko eakuia mukamuka.” ");
INSERT INTO nrz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu luva kanaua evapuala koanai kau mato boutai ena vaikabasiai detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","'Olana ia ena vaikabasi 'eva sia talavatu 'ola kauta eta vaikabasi boita, ena luva 'eva mai siavuna. ");
INSERT INTO nrz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu loloai e'ovu koanai kau mato nama vaikana mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Loki kauna ka easi Iesu vailanai ekuidula e'ouia ediaka, “Lovia namana e, bo'ula koanai bovanama'ina'u.” ");
INSERT INTO nrz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu imana eisia lao eabia kovo inoku ediaka, “Lau a'ula kaumu benama'ina.” Komolonaimo loki kauna enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Inoku Iesu kau kanaua e'ouia ediaka, “Sia kau ka makanai boluluva, beia sibomu boda'a kabukabu kauna kele'enai kaumu bovaikala, maivaka ainama Mose eluvavaia davana bovenia inoku bevamomo'aimu oni 'eva 'ani onama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Kapelanauma vanuanai eda'adodo koanai, Loma kuali 'olana kauna ka easi kevana enoia bedulua. ");
INSERT INTO nrz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ia Iesu e'ouia ediaka, “Lovia namana e, e'u da'ala abi kauna e'eko lumai e'eno, kauna eanana vaika.” ");
INSERT INTO nrz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu ia e'ouia ediaka, “Bavasi bavanama'inala.” ");
INSERT INTO nrz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kuali 'olana kauna Iesu e'ouia ediaka, “Lovia namana e, lau sia anama'ina oni bo'asi e'u luma, beia boluluva mo ua'i e'u da'ala abi kauna benama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Olana lau 'eva siavu kauna ka venunai amimia maivaka kuali kauta vaida lau venu'uai demimia. Lau kau kanania a'oua, ‘Da'a’ 'eva edada'a, mai kau kanaua a'oua, ‘Oni mai.’ 'eva e'asi. Maivaka e'u da'ala abi kauna a'oua, ‘Kanania vavaia.’ 'eva ia evavaia.” ");
INSERT INTO nrz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu luva kanaua eika koanai etabulovo si'asi'a, inoku mulinai deda'a kauta e'outa ediaka, “Lau oi luva umauna a'oumui, Isalaela laloanai kau ka kele'enai abiveni kanania boina sia ka adavalia kovo. ");
INSERT INTO nrz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lau oi a'oumui kau doutamo vaika daeai maivaka divoai be'asi Dilava ena lovia vanuana laloanai nadu 'abunai Abela'amo, Isa'ako mai Iakobo ita bemiadivo ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Beia kau kataua Dilava ena lovia vanuana eva'olua ia eta kauta 'eva mulimuliai bekapota asi vabulaai ua'i bekakani mai 'asi'asita beala'oi ala'oi.” ");
INSERT INTO nrz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesu kuali 'olana kauna e'ouia ediaka, “Da'a emu luma, oabiveni vitaitanai kevamuai 'ani bepupulu.” Ena da'ala abi kauna melala ka'onamoai komolonai enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu Petelo ena lumai eda'adodo koanai, Petelo lavana ateatena eikaia e'olele kauna desiavu eno. ");
INSERT INTO nrz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu eta'u ateate imana eabi kovo, inoku 'olele evikania, ateate eko'isi Iesu ana iani evavai. ");
INSERT INTO nrz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lavilavi eda'avenia koanai kau doutamo ka'uba si'avata vaika nuatai demia kauta devuata deasi Iesu kevana. Iesu ena luvai ka'uba si'avata vaika elo'ota asi maivaka 'olele kauta boutai evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nia 'eva Isaia enolea kauna ena luva ivamomo'aina kanania eluva koma, ‘Ia sibona eta badebade beabi tau maivaka eta 'olele evanama'inata.’ ");
INSERT INTO nrz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu kau mato namavaikana delavaia kaiukaiu eikata koanai ibanona kauta e'outa bekeini 'ovu avekena beda'ala. ");
INSERT INTO nrz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Talavatu 'ola kauna ka easi Iesu e'ouia ediaka, “Vaikabasi kaumu e, 'abu davana boda'ala beia lau 'eva oni mulimuai badada'a.” ");
INSERT INTO nrz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu ia ena luva evamuea ediaka, “'Oveka 'asita 'eva mai eta va'ala, mai aka manumanuta 'eva mai eta ni'i, beia lau kau nakuna 'eva 'ola'u bane'eadivo la'u ba'ani 'abuna asi'i.” ");
INSERT INTO nrz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ibanona kauna ka Iesu e'ouia ediaka, “Lovia namana e, bamada'a kama'u bamakolea 'ana'i.” ");
INSERT INTO nrz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Beia Iesu ia e'ouia ediaka, “Muli'uai mai, ba kauta 'eva vikanita sibota eta ba dekoleia.” ");
INSERT INTO nrz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kanaua'i Iesu asiai ele'au inoku ibanona kauta ita deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","'Ovuai lani nama vaikana eunu, ka'uda namata deko'isi asi komanimo devaukua, beia Iesu 'eva emuinai tabu. ");
INSERT INTO nrz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ibanona kauta deda'a dekuia inoku de'ouia dediaka, “Lovia namana e, vamaulita! 'Ani eka ba.” ");
INSERT INTO nrz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Beia eta luva evamuea ediaka, “Emui abiveni ekiki kaumui, dava 'ounai oi omakau?” Inoku Iesu eko'isi lani mai ka'uda e'ovenita, kanaua'i komolonai de'olo. ");
INSERT INTO nrz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kau asiai kataua detabulovo si'asi'a inoku dediaka, “Nia 'eva kau davana, lani mai ka'uda vaka lelena de'ika.” ");
INSERT INTO nrz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesu 'ovu avekenai Kadalene kanonai ela'asi koanai, kau lalua nuatai ka'uba si'avata vaika demia kauta mitavai deasi kevana. Ia 'eva deaivala vaika 'ounai sia kau ka dala kanaua'i ekeini. ");
INSERT INTO nrz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ia devaoi dediaka, “Dilava nakuna e, kevamai ai dava oula venia? Melala asido'o edaia beia oni o'asi 'eva lai bovaananamai, una?” ");
INSERT INTO nrz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Abu kanaua'i viloana sia edau'a 'eva boloma 'ito namavaikana ka deaniani. ");
INSERT INTO nrz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Inoku ka'uba si'avata Iesu denoia dediaka, “Oni bovala'asimai koanai, bosinimai lai bada'a boloma 'itona kanaua laloatai lai badododo.” ");
INSERT INTO nrz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Inoku e'outa ediaka, “Oda'a.” Inoku ia dela'asi deda'a boloma nuatai dedodo. Boloma 'itona deveau de'ovu ke'eke'eai delovo asi 'ovu laloanai delovo uku veiai dedono ba. ");
INSERT INTO nrz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Boloma i'imata kauta deveau ovo vanua namanai vali kanania mai ka'uba si'avata kau nuatai demia kauta valita vaka dekava. ");
INSERT INTO nrz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Inoku vanua namana kauta boutai deasi Iesu beikala. Deasi deikaia koanai denoia eta kano bevikania. ");
INSERT INTO nrz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu asi ai ele'au 'ovuai ekeini eda'a Kapelanauma, ena vanua umauna. ");
INSERT INTO nrz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kau vaida 'eko kauna ka toto'ai devuaia deda'a kevana. Iesu eta abiveni eikaia koanai, 'eko kauna e'ouia ediaka, “Naku'u e, sia bomakau, emu si'avana 'ani i'ou kaota.” ");
INSERT INTO nrz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kanaua'i talavatu 'ola kauta vaida sibota viloatai deluvaluva dediaka, “Kau kanania 'eva Dilava enai eluva si'asi'a.” ");
INSERT INTO nrz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu 'eva eta lalovai eikabasi inoku ediaka, “Dava 'ounai lalovai si'avata nuamuiai oi olalovaita? ");
INSERT INTO nrz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Davana 'eva eveavea, badiaka ‘Emu si'avana i'ou kaota.’ 'o badiaka ‘Ko'isi da'a.’ ");
INSERT INTO nrz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Beia oi boikabasi lau kau nakuna 'eva mai e'u siavu kanobata kauta eta si'avana ba'ou kao.” Inoku Iesu 'eko kauna e'ouia ediaka, “Ko'isi, emu toto'a abia, inoku da'a emu luma.” ");
INSERT INTO nrz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ia eko'isi, inoku eda'a ena luma. ");
INSERT INTO nrz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kau mato koa kanaua deikaia koanai detabulovo si'asi'a, inoku siavu kanaua boina kau evenita Dilavana devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu 'abu kanaua evikania inoku eda'a koanai kau ka eikaia, ia vana 'eva Mataio, moni visi 'abunai emiadivo, e'ouia ediaka, “Muli'uai mai.” Mataio eko'isi mulinai eda'a. ");
INSERT INTO nrz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iesu Mataio ena lumai eaniani laloanai, moni visi kauta doutamo mai si'avana kauta vaka deasi ia mai ibanona kauta ita deaniani ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Palisea kauta vaida koakoa kanaua deikaia koanai ibanona kauta delavuaita dediaka, “Dava 'ounai emui vaikabasi kauna moni visi kauta mai si'avana kauta katania boita ita deaniani ka'ona?” ");
INSERT INTO nrz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu 'ulu kanania eika koanai eta luva evamuea ediaka, “Sia de'olele kauta 'eva mulamula veni kauna sia deula venia, beia de'olele kauta mo deula venia. ");
INSERT INTO nrz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oi oda'a Puka kabukabuna luvana kanania anina dava 'eva oi bokavua, ‘Lau vilalo aula venia ia sia veniveni davana.’ Lau asi 'olana 'eva komolo kauta sia ba'aeta, beia si'avana kauta ba'aeta.” ");
INSERT INTO nrz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Inoku Ioane ibanona kauta deasi Iesu kevana delavuaia dediaka, “Dava 'ounai lai mai Palisea kauta ita lai alolove, beia oni ibanomu kauta 'eva sia delolove?” ");
INSERT INTO nrz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu eta luva evamuea ediaka, “Kamoane makamaka kauna ena da'a'au kauta kele'etai emimia koanai ia a bekani koma? 'A melalana be'asi kamoane makamaka kauna kele'etai beabia tau koanai ia belolove. ");
INSERT INTO nrz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kau ka tubu'a makamakana si'ana tubu'a 'ana'ina ita sia bekuli ka'ona, 'olana ikulina 'abuna be'idi ovo 'eva 'ile 'ani namana beao. ");
INSERT INTO nrz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kau vine veina makamakana pute 'ana'inai sia belaiauda, 'olana pute be'idi 'eva vine veina be'itabu maivaka pute asi'i bemasi'avana, 'a vine veina makamakana 'eva pute makamakatai belaiuda inoku luana benama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu luva kanania eluvaia koanai, lo'e 'ola kauna ka easi vailanai ekuidula e'ouia ediaka, “Naku'u vatona 'eva vali'u mo ebaba, beia mai imamu akanai bokao'au inoku bemauli.” ");
INSERT INTO nrz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Inoku Iesu eko'isi mulinai eda'a, ibanona kauta vaka deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ua'i 'a'ate eta 'olele edavalia vikau ouka lua ateatena ka Iesu mulinai eda'a easi ena tubu'a si'ana eabia kovo. ");
INSERT INTO nrz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","'Olana sibona nuanai ediaka, “Ena tubu'a si'ana mo babia kovo 'eva banama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","'A Iesu ekai 'udai eikaia inoku e'ouia ediaka, “Naku'u e, bokula'ila, emu abiveni eta'u evanama'inamu.” Ateate komolonai mo enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Inoku Iesu lo'e 'ola kauna ena lumai edodo, siau uvani kauta mai kanikani kauta 'uluta devua eikata, ");
INSERT INTO nrz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","inoku e'outa ediaka, “Ola'asi, vato 'eva sia eba, ia 'eva emuinai.” Beia ia 'eva Iesu deikaia demamai. ");
INSERT INTO nrz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Inoku ia eta'u kau mato evala'asita mulimuliai mulinai, eda'a dodo vato ena laloa laloanai, vato imanai eabi, evako'isia. ");
INSERT INTO nrz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kano kanaua bounai laloanai valina kanania dekavaia odaoda. ");
INSERT INTO nrz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu 'abu kanaua'i ela'asi koanai maka 'ede kauta lalua mulinai deda'a devaoi dediaka, “Davida nakuna e, bomalalomai.” ");
INSERT INTO nrz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ia lumai edodo koanai maka 'ede kauta deasi kevana, inoku Iesu elavuaita ediaka, “Oi ovamomo'ai'u lau oi 'ani bavanama'inamui, una?” Ia dediaka, “'O, Lovia namana, lai avamomo'aimu.” ");
INSERT INTO nrz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iesu ia makata eabita kovo inoku ediaka, “Emui abiveni vitaitana kevamuiai epulu.” ");
INSERT INTO nrz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Inoku makata deata. Iesu e'outa kao ediaka, “Sia kau ka oi bovaikabasia.” ");
INSERT INTO nrz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Beia ia 'eva dela'asi deda'a kano kanaua itoina laloanai Iesu valina dekava. ");
INSERT INTO nrz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ia dela'asi deda'a koanai, kau vaida deta'u nutububu kauna ka nuanai ka'uba si'avana emia 'ounai devuaia deda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ka'uba si'avana elo'oia asi mulinai nutububu kauna enama'ina inoku eluvaluva, kau boutai detabulovo inoku dediaka, “Isalaela laloanai koa kanania boina sia ka kaikaia kovo.” ");
INSERT INTO nrz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Beia Palisea kauta dediaka, “Ia 'eva ka'uba si'avata eta 'ola kauna 'ounai ka'uba si'avata elo'ota asi.” ");
INSERT INTO nrz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Inoku Iesu eda'a vanua namata mai kikita boutai laloatai eda'a to'ato'a, eta lo'e laloatai evaikabasi, Dilava ena lovia vanuana valina nama'ina eilolo vaia, 'olele mai anana edeata edeata boutai evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iesu kau mato kanaua eikaia koanai elalota 'olana ia 'eva delalo to'ato'a mai sia mai iduluta, itani mamoe sia mai i'imata kauta boita. ");
INSERT INTO nrz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Inoku ia ibanona kauta e'outa ediaka, “Lobai iani doutamo 'ani de'olu, beia vinaula kauta 'eva sia douta. ");
INSERT INTO nrz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kanaua 'ounai loba 'uala kauna oi bonoia vinaula kauta besinita ena lobai be'ua'ua.” ");
INSERT INTO nrz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu ibanona kauta 'ouka lua e'aeta deasi kevana, siavu evenita ka'uba si'avata belo'ota asi maivaka 'olele mai anaana edeata edeata boutai bevanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Veauneke kauta 'ouka lua vata 'eva katania, lava'ana'ia 'eva Simona, de'aeia vaka Petelo, mai kadina Andelea, Sebedeo nakuna Iakobo mai kadina Ioane. ");
INSERT INTO nrz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo, Batolomeo, Toma mai moni visi kauna Mataio, Alepeo nakuna Iakobo, mai Tadeo. ");
INSERT INTO nrz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Selote kauna Simona, mai Isakaliote kauna Iuda, Iesu venina eveni mai kouna ekou kauna. ");
INSERT INTO nrz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu kau 'ouka lua katania esinita mai e'outa ediaka, “Sia oi boda'a pulu edea kauta eta kanoai maivaka Samalia vanuata sia ka laloanai oi boda'a dodo. ");
INSERT INTO nrz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Beia oi boda'a Isalaela iduvuna ena mamoe detaule kauta kele'etai. ");
INSERT INTO nrz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Oi bodada'a koanai oi boilolo bodiaka, ‘Dilava ena lovia vanuana 'eva 'ani ekevai.’ ");
INSERT INTO nrz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","'Olele kauta oi bovanama'inata, ba kauta oi bovamaulita, loki deabia kauta kauanita oi bovanama'inata, mai ka'uba si'avata oi bolo'ota asi. Oi oabi 'avaea 'ounai oi boveni 'avaea. ");
INSERT INTO nrz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Emui idavala laloatai moni namata 'o kikita sia oi bo'uda. ");
INSERT INTO nrz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Emui da'a to'ato'a 'ounai voina, tubu'a ivadodo ivaluana, tamaka, mai ikoko'a sia oi bo'abi, 'olana vinaula kauna 'eva mai inana'ana. ");
INSERT INTO nrz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vanua davanai oi oda'a dodo koanai beabimui dae kauna oi bokavua kele'enai oi bomimia beda'amo 'abu kanaua oi bovikania. ");
INSERT INTO nrz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Luma kanaua'i oi oda'a dodo koanai vanama'ina oi boveveni. ");
INSERT INTO nrz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Luma kauta beabimui dae koanai emui vanama'ina akatai bemimia, beia sia beabimui dae koanai emui vanama'ina 'eva oi boabia 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mai vaida sia beabimui dae 'o lelemui sia be'ika koanai vanua 'o luma kanaua oi bovikania laloanai aemui apulolota oi bodavudavu ovo. ");
INSERT INTO nrz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lau oi luva umauna a'oumui, lavuai olena melalanai Sodomo mai Gomola vanuata eta mekau kena bekiki, beia vanua kanaua ena mekau 'eva namavaikana. ");
INSERT INTO nrz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lau oi asinimui 'eva vitaitana itani mamoe boita oi oda'a 'oveka 'asita viloatai. Kanaua 'ounai oi boaoneka itani kau'asi boita mai boiomalo boita oi bo'ao nuamuiai si'avana sia oi bolalovaia. ");
INSERT INTO nrz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kau kevatai oi bo'imamui kave'i, 'olana ia beabimui beda'a lavuai 'abunai bene'emuidivo maivaka lo'e laloatai be'odimui. ");
INSERT INTO nrz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lau dai'uai oi bevuamui beda'a 'ola kauta namata mai lovia kauta namata vailatai belavuaimui, beia ia mai puluedea kauta kele'etai vali nama'ina oi bo'outa. ");
INSERT INTO nrz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bevuamui beda'a lavuai 'abuna koanai luva davana oi boluvala 'o a oi boluva koma 'eva nuamui sia bebavunu. Melala kanaua'i Dilava betata'u luva dava oi boluvala luvana 'eva bevenimui. ");
INSERT INTO nrz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","'Olana iluvana 'eva sia oi, beia Kamamui Dilava Idumena nuamuiai kauna beluluva. ");
INSERT INTO nrz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bo'akalana ka betata'u bo'akalana venina beveveni mai kouna bekokou beaku bala, kama betata'u nakuna kanaua bekomala, naku betata'u kamata mai sinata bevaiviivita ba 'abunai be'uleta. ");
INSERT INTO nrz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kau boutai lau dai'uai bevaiviivimui, beia dai lau dai'uai belava 'ini kauna beda'a to'onai ia 'eva bemauli. ");
INSERT INTO nrz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vanua kai bevaiviivimui koanai, oi bo'ulu oi boda'a vanua edeana ka. Lau oi luva umauna a'oumui, Isalaela vanuata boutai sia oi boda'a dodo palu laloanai lau kau nakuna 'eva ba'asi. ");
INSERT INTO nrz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Malele melona ena vaikabasi kauna sia bekeinia 'o da'ala abi kauna ena 'ola kauna sia bekeinia. ");
INSERT INTO nrz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Malele melona ena vaikabasi kauna ita bevitaita 'eva enama'ina, mai da'ala abi kauna ena 'ola kauna ita bevitaita 'eva enama'ina. Bema luma 'olana kauna be'aea Belesebulo koanai luma kauta vaka va si'avata be'ae. ");
INSERT INTO nrz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kanaua 'ounai sia oi bomakau venita. Dava devaakububu davata boutai 'eva bevala'asita mai devuni davata boutai 'eva beikabasita. ");
INSERT INTO nrz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dava vabulai a'oumui davata 'eva 'ailala laloanai oi boluva vaita mai luva kaiamuiai oi o'ika luvata 'eva luma 'uvinai oi boilolo vaita. ");
INSERT INTO nrz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kauani beaku bala kauta kataua sia oi bomakau venita 'olana idume 'eva sia beaku bala. Beia Dilava oi bomakau venia ia 'eva kauani mai idume luana bevabata 'alova laloanai. ");
INSERT INTO nrz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bisili lua 'eva pene ka'onamoai betavata. Beia Kamamui e'imata koanai sia ka be'eko asi kanoai. ");
INSERT INTO nrz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Inoku vuimui boutai 'olamuiai 'eva 'ani evaku paluta. ");
INSERT INTO nrz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kanaua 'ounai sia oi bomakau, oi 'eva bisili doutamo vaika oi okeinita. ");
INSERT INTO nrz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kau ka kau vailatai bediaka ia lau ebano'u kauna 'eva lau vaka Kama'u vutuvutuai emimia kauna vailanai badiaka ia 'eva lau ebano'u. ");
INSERT INTO nrz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Beia kau ka kau vailatai lau be'ou'u avuavu kauna 'eva lau vaka Kama'u vutuvutuai emimia kauna vailanai ia ba'oua avuavu. ");
INSERT INTO nrz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sia oi bolalovaia lau asi 'eva nua'elu asi vaia kanobatai. Lau 'eva nua'elu sia asi vaia beia kuali lepona asi vaia. ");
INSERT INTO nrz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lau asi 'olana 'eva kanania, melo betata'u kamana bevaiviivia, vato betata'u sinana bevaiviivia, melo adana betata'u lavana ateatena bevaiviivia. ");
INSERT INTO nrz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kau ka ena luma kauta 'eva ena 'ou kautai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kau ka kamana 'o sinana elalo'au venita vaika vakaia lau, ia 'eva kele'e'uai sia bedaia. Kau ka nakuna oleolena 'o vatona elalo'au venia vaika vakaia lau, ia 'eva kele'e'uai sia bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kau ka ena au ido'o valaukuna sia evuala muli'uai edada'a kauna, ia 'eva kele'e'uai sia bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kau ka ena mauli beabi 'inia kauna 'eva ena mauli bevatauleia, kau ka ena mauli bevatauleia lau dai'uai kauna 'eva ena mauli bedavalia. ");
INSERT INTO nrz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kau davana oi eabimuidae kauna 'eva lau eabi'udae mai lau eabi'udae kauna 'eva esini'u Dilavana vaka eabiadae. ");
INSERT INTO nrz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kau ka enolea kauna ka eabiadae 'olana ia enolea kauna 'ounai, ia 'eva enolea tavana vitaitana beabia, mai kau ka komolo kauna ka eabiadae 'olana ia komolo kauna 'ounai, ia 'eva komolo kauna tavana vitaitana beabia. ");
INSERT INTO nrz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kau ka vei 'eluna 'ouai melo kikita katania ka bevenia 'olana ia lau ibano'u kauta 'ounai, lau oi luva umauna a'oumui, tava iabina laloanai ia sia betatabu.” ");
INSERT INTO nrz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu ibanona kauta 'ouka lua luva katania'i evaidibata mulinai, 'abu kanaua evikania eda'a Kalilea vanuata laloatai ua'i bevaikabasi mai beilolo. ");
INSERT INTO nrz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioane vabuto'o lumana laloanai Keliso ena vinaula valita eika koanai ibanona kauta esinita deda'a kevana, ");
INSERT INTO nrz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iesu delavuaia dediaka, boma 'oumai “Be'asi kauna 'eva oni? 'O edeana ka lai ba'imala?” ");
INSERT INTO nrz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu eta luva evamuea ediaka, “Omue oda'a, dava oi o'asi makamuiai oi o'ika mai kaiamuiai uluta oi o'ika 'eva Ioane vailanai oi boluvavai. ");
INSERT INTO nrz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Ede kauta 'ani deikaika 'udai, 'ome'ome kauta dedada'a, loki kauta 'ani denama'ina, kaia bubu kauta lele de'ika, ba kauta deko'isi demauli 'udai, mai ta'ovala kauta kevatai vali nama'ina deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kau ka kele'e'uai nuana sia elalo to'ato'a kauna Dilava bevanama'inala.” ");
INSERT INTO nrz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioane ibanona kauta deda'a mulili laloanai, Iesu kau mato vailatai Ioane luvana eluva ediaka. “Oi dava boikala 'ounai oi oda'a kano'akunai? Lani 'ebavala eva'iuvai 'iuvaita oi boikata, una? ");
INSERT INTO nrz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Asi'i koanai, oi oda'a 'eva dava oi boikala? Kau ka tubu'a pudalo pudalota evadodota kauna, una? Kau kataua tubu'a pudalo pudalota devadodo kauta 'eva lovia 'olana ena lumai demimia. ");
INSERT INTO nrz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Inoku dava oi boikala 'ounai oi oda'a? Enolea kauna ka? 'O, lau oi a'oumui, Ioane 'eva enolea kauta boutai ekeinita. ");
INSERT INTO nrz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ia valina Puka kabukabunai kanania deleleia koma, ‘Lau e'u veauneke kauna basinia 'ana'i vailamuai, ia betata'u emu dala beva'olua kave'i.’ ");
INSERT INTO nrz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Lau oi luva umauna a'oumui, 'a'ate devapuluta kauta viloatai ka vaidi'u kabukabu kauna Ioane sia bekeinia, beia ua'i Dilava ena lovia vanuanai ekiki kauna 'eva Ioane bekeinia. ");
INSERT INTO nrz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Vaidi'u kabukabu kauna Ioane ena melalai easimo vali'u, Dilava ena lovia vanuana 'eva deadedua vaia, vavai 'avaea kauta 'eva dekovoia bebuku vaita. ");
INSERT INTO nrz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","'Olana enolea kauta mai Mose ena talavatu boutai laloatai Dilava ena lovia vanuana valina deluvavaia 'eva easimo Ioane ena melalai. ");
INSERT INTO nrz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Oi oabia dae koanai oi boikabasi Ioane 'eva Elia be'asi kauna. ");
INSERT INTO nrz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mai kaiana kauna 'eva lele be'ika. ");
INSERT INTO nrz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ulu kanania kauta davai bavavitaitata? Ia 'eva itani melo kikita tavatava 'abunai demiadivo banota de'aeta dediaka, ");
INSERT INTO nrz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Oi daimuiai siau lai auvani, beia oi sia oneneva. Ba masita lai a'abi, beia sia oi okakani.’ ");
INSERT INTO nrz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioane easi 'eva elove, inoku ia dediaka, ‘Ka'uba si'avana ka ia nuanai.’ ");
INSERT INTO nrz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lau Kau nakuna asi aniani mai ainuinu 'eva ia dediaka, ‘Ia 'eva aniani si'asi'ana mai inuinu si'asi'ana, moni visi mai si'avana kauta eta kau.’ Beia aoneka 'eva vuavuana etata'u ena komolo evamomo'aia.” ");
INSERT INTO nrz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesu vanua laloatai vatabulovo koata doutamo evavai vanuata kataua kauta e'ovenita, 'olana ia eta si'avanai sia delalo 'udai 'ounai. ");
INSERT INTO nrz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolasina e, kele'emuai besi'avana vaika! Betesaida e, oni vaka kele'emuai besi'avana vaika! Vatabulovo koata kevamuiai avavai davata Tulo mai Sidono kauta kevatai bamavavai koanai, ia 'eva 'ani siako vaikai bemalalo 'udai, tubu'a maputa bemavadodo mai 'olatai lavu bemane'edivo. ");
INSERT INTO nrz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Beia lau oi a'oumui, Dilava ena lavuai namana melalanai Tulo mai Sidono kauta eta mekau 'eva kena bekiki beia oi 'eva besi'avana vaika. ");
INSERT INTO nrz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapelanauma e, oni beabimu isi boda'a vutuvutu akanai, una? Asi'i, oni 'eva beitomu 'ovu 'alova laloanai. Vatabulovo koata kataua kele'emuai avavai davata Sodoma kele'enai bamavavai koanai, ia 'eva bemamia mo bema asi vali'u melala kanania. ");
INSERT INTO nrz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Beia lau oi a'oumui, Dilava ena lavuai namana melalanai Sodoma ena mekau 'eva kena bekiki ia oi emui 'eva besi'avana vaika. ");
INSERT INTO nrz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Melala kanaua'i Iesu ena meameai ediaka, “Kama'u e, vutuvutu mai kanobata Loviana. Lau oni avanama'inamu 'olana dava katania ovunita ikabasi mai idiba kauta kevatai, beia melo kikita kevatai ovala'asita. ");
INSERT INTO nrz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kama'u e, luva umauna, 'olana kanania 'eva oni emu ula vitaitanai 'ani epulu. ");
INSERT INTO nrz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dava boutai 'eva Kama'u 'ani eveni'u. Sia kau ka Nakuna eikabasia beia Kamana mo sibona, mai kau ka Kamana sia eikabasia Nakuna mo sibona mai Nakuna edilata kauta kataua mo sibota kele'etai Kamana bevala'asia.” ");
INSERT INTO nrz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bavunu kaumui mai mekau oi ovuala kaumui, boumuiai keva'u omaia, lau oi laani bavenimui. ");
INSERT INTO nrz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","E'u eveve oabia voumuiai ovuaia mai kele'e'uai ikabasi oi boabia 'olana lau 'eva a'eluovo mai 'ulu'u asi'i. Inoku idumemui lata be'ani. ");
INSERT INTO nrz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","'Olana e'u eveve 'eva eveavea mai tamu 'eva sia emekau.” ");
INSERT INTO nrz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Melala kanaua'i Iesu 'eva melala kabukabunai witi lobana laloanai eda'a keini. Ibanona kauta vikolo deakuta 'ounai witi vuata debuku deani. ");
INSERT INTO nrz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Palisea kauta koakoa kanaua deikaia koanai Iesu de'ouia dediaka, “Ikala, oni ibanomu kauta 'eva melala kabukabunai dava sia bevavaia davana 'eva devavaia.” ");
INSERT INTO nrz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu eta luva evamuea ediaka, “Oi 'eva Davida debanoia kauta ita vikolo deakuta laloanai dava evavaia davana sia oi ovakua? ");
INSERT INTO nrz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ia Dilava ena lumai edodo, ua'i palaoa kabukabuna eabia, palaoa kanaua 'eva ekabukabu, kabukabu kauta sibota mo beania davana, ia mai debanoia kauta ita deania. ");
INSERT INTO nrz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mai kabukabu kauta lo'e kabukabuna laloanai melala kabukabuna vinaulana sia devavaia kave'i beia sia deva'eva, talavatuna kanaua 'eva sia oi ovakua? ");
INSERT INTO nrz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lau oi a'oumui, nia'i kau ka 'eva lo'e kabukabuna ekeinia. ");
INSERT INTO nrz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Lau a'ula vilalo, ia sia a'ula veniveni davata.’ Hos 6.6 Puka kabukabunai luva katania anita oi bomaikabasi koanai kau sia deva'eva kauta va'evai sia oi bomane'etadivo. ");
INSERT INTO nrz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Olana lau Kau nakuna 'eva melala kabukabuna loviana.” ");
INSERT INTO nrz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu 'abu kanaua evikania eda'a Iuda eta lo'e laloanai edodo, ");
INSERT INTO nrz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","kau ka imana badena vaka ua'i, kau vaida deula Iesu va'eva 'abunai bene'eadivo, inoku Iesu delavuaia dediaka, “Melala kabukabunai 'olele ekavanama'inala 'eva mai va'evana 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu e'outa ediaka, “Oni ka emu mamoe melala kabukabunai 'uliai bema'ekouda koanai sia bomaabiaisi, una? ");
INSERT INTO nrz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kau 'eva mamoe ekeinia. Kanaua 'ounai melala kabukabunai nama'ina ekavavai 'eva ekomolo.” ");
INSERT INTO nrz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Inoku Iesu kau kanaua e'ouia ediaka, “Imamu isia komolo.” Inoku imana eisia komolo 'eva itoinai enama'ina vitaitana imana avekena boina. ");
INSERT INTO nrz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Beia Palisea kauta dela'asi deda'a lova deaku aboina Iesu beakubala. ");
INSERT INTO nrz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu 'ani eikabasi 'ounai 'abu kanaua'i eda'atau. Kau doutamo vaika mulinai deda'a, eta 'olele boutai evanama'inata, ");
INSERT INTO nrz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","e'outa kao kau ka vailanai sia beluluva ia 'eva dai. ");
INSERT INTO nrz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kanania 'eva Isaia enolea kauna eluvavaia luvana ivamomo'aina. ");
INSERT INTO nrz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Oikaia ia 'eva adilaia e'u da'ala abi kauna, alalo'au venia maivaka alalonama venia. Lau Idume'u Kabukabuna basinia ia akanai, kanobata kauta kele'etai komolo beilolovaia. ");
INSERT INTO nrz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ia 'eva sia bevina 'o sia bevaoi maivaka lelena vanua dalatai sia be'ika. ");
INSERT INTO nrz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ia sia beba'iuku itani silibo 'ani emoku davana badebade kauta boita, maivaka 'ita 'ani ebo'o davana itani eta nuabata ekiki kauta boita ena nuabata sia bevabo'oa beda'amo komolo vinaulana bevala'asia. ");
INSERT INTO nrz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanobata kauta boutai eta nuabata ia vana akanai bene'etadivo.’ ");
INSERT INTO nrz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kau ka nuanai ka'uba si'avana emia kauna devuaia deda'a Iesu kevana ia 'eva makana de'ede mai malana esi'avana, Iesu eta'u evanama'inala, ua'i ia eluva luva mai eikaika 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kau boutai detabulovo si'asi'a dediaka, “Ama'i kau kanania 'eva Davida Nakuna.” ");
INSERT INTO nrz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Beia Palisea kauta vali kanania de'ika koanai dediaka, “Kanania 'eva ka'uba si'avata eta 'ola kauna Belesebulo ena siavuai ka'uba si'avata katana elo'ota asi.” ");
INSERT INTO nrz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu eta lalovai eikabasi 'ounai e'outa ediaka, “Kanobata ka sibona beva'alamaia inoku beviaku 'eva sia bemiadau'a, mai vanua ka sibona 'o iduvu ka sibona beva'alamaia beviaku koanai sia belava'ini bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Inoku Diabolo betata'u Diabolo belo'oa asi koanai ia 'eva sibona eva'alamaia, kanaua'i ena kanobata 'eva abelava 'ini koma? ");
INSERT INTO nrz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lau Belesebulo siavunai ka'uba si'avata alo'ota asi koanai dai ena siavuai oi emui kau ka'uba si'avata vaika delo'ota asi? Kanaua 'ounai emui kau betata'u va'evai bene'emuidivo. ");
INSERT INTO nrz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Beia lau Dilava idumena siavunai ka'uba si'avata alo'ota asi koanai Dilava ena lovia vanuana 'eva 'ani easi oi akamuiai. ");
INSERT INTO nrz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kau ka kula'ila kauna ena luma sia beva'alamaia ena dava beabi tau beda'amo ia kula'ila kauna beabia bedo'oa makava, inoku ena dava bevinaota. ");
INSERT INTO nrz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kau ka lau dai'uai sia edadai kauna 'eva lau ebaduveni'u, mai kau ka lai laluana sia avalalo ka'ona kauna 'eva ekapo odaoda. ");
INSERT INTO nrz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kanaua 'ounai lau oi a'oumui, kau eta si'avana mai eta luva si'avata boutai 'eva be'ou kao bedaia, beia Idume Kabukabuna kele'enai eluva si'asi'a kauna 'eva ena si'avana sia be'oukao diba. ");
INSERT INTO nrz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kau ka beluva si'asi'a Kau nakuna kele'enai 'eva ena si'avana be'oukao bedaia, beia kau ka Idume Kabukabuna kele'enai beluva si'asi'a kauna 'eva ena si'avana sia be'oukao diba vali'u mauli kanania'i maivaka mauli vailai be'asi maulina. ");
INSERT INTO nrz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Au nama'ina 'eva vuavua nama'ita bevapulu, au si'avanai 'eva vuavua si'avata bevapulu, 'olana au aboita 'eva vuavuatai ekaikabasi. ");
INSERT INTO nrz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kau'asi nakuta e, emui lalovai 'eva desi'avana aboina luva nama'ita oi bo'oulai? 'Olana nutu 'eva nuai evonu davana luvana eluvala. ");
INSERT INTO nrz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kau nama'ina nuanai dava nama'ita e'uda davata nama'ita evala'asi, kau si'avana nuanai dava si'avata e'uda davata si'avata evala'asi. ");
INSERT INTO nrz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lau oi a'oumui, kau luva 'avaeata deluluva kauta boutai Dilava ena lavuai melalanai tavata beveni dokadoka. ");
INSERT INTO nrz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kanaua 'ounai emu luva betata'u komolo bevenimu maivaka emu luva betata'u mekauta bevenimu.” ");
INSERT INTO nrz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Inoku Palisea kauta mai talavatu 'ola kauta vaida Iesu de'ouia dediaka, “Vaikabasi kaumu e, lai a'ula oni kele'emuai siavu koana ka bomavavaia lai bamaikala.” ");
INSERT INTO nrz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu eta luva evamuea ediaka, “Ulu kanania si'avana maivaka sia maiemui abiveni kaumui, dava 'ounai siavu koana oi olavuai vaia? Beia koa bavenimui davana 'eva enolea kauna Iona mo ena koa. ");
INSERT INTO nrz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iona melala koi mai boni koi sisi namana bo'ana laloanai emia, vitaitana mo lau kau nakuna vaka melala koi mai boni koi kano laloanai bamimia. ");
INSERT INTO nrz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lavuai melalana be'asi Nineva kauta ulu kanania kaumui va'eva 'abunai bene'emuidivo, 'olana Iona ena iloloai delalo 'udai. Beia vali'u Iona ekeinia kauna 'eva nia'i. ");
INSERT INTO nrz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Divo kanobatana loviana ateatena lavuai 'abunai beko'isi ulu kanania kaumui va'eva 'abunai bene'emuidivo, 'olana ia kanobata to'onai easi Solomona ena aoneka luvata e'ika. Beia vali'u Solomona ekeinia kauna 'eva nia'i.” ");
INSERT INTO nrz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ka'uba si'avana ka kau ka nuanai ela'asi koanai eda'a kano'akunai eda'a to'ato'a laani 'abuta ekavu, beia sia 'abu ka edavalia, ");
INSERT INTO nrz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","inoku sibona ediaka, ‘Lau 'eva bamumue bada'a e'u luma avikania lumana’, Inoku emue eda'a luma 'avaeana 'ani dedaloia kave'i mai e'olu edavalia. ");
INSERT INTO nrz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Inoku ela'asi eda'a banona kalakoi ka desi'avana vaika kauta evuata deasi dedodo ua'i demia. Kau kanaua 'ana'inai ena mia esi'avana, beia valiu 'eva esi'avana vaika. Kanaua 'eva ulu si'avana kanania kauta kele'etai kanaua bepulu koma.” ");
INSERT INTO nrz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu kau eluva venita do'o laloanai sinana mai bo'akalana deasi dela'asi. Mulimuliai delava deula Iesu ita beluvaluva. ");
INSERT INTO nrz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kau ka ia e'ouia ediaka, “Sinamu mai bo'akalamu 'eva mulimuliai delalava, deula venimu oi boluvaluva.” ");
INSERT INTO nrz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu ia ena luva evamuea ediaka, “Lau sina'u 'eva dai, mai lau bo'akala'u 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Imana ibanona kauta eisivenita inoku ediaka, “Katania kauta 'eva lau sina'u mai lau bo'akala'u. ");
INSERT INTO nrz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","'Olana kau ka lau Kama'u vutuvutuai emimia kauna ena ula evavaia kauna 'eva lau bo'akala'u, lovu'u mai sina'u.” ");
INSERT INTO nrz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Melala ka'onamo kanaua'i Iesu lumai ela'asi eda'a 'ovu nabuanai emia divo. ");
INSERT INTO nrz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kau mato namavaikana delavaia kaiukaiu 'ounai eko'isi asi kai ele'au emia 'au, kau boutai 'eva nabuai delava. ");
INSERT INTO nrz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Inoku ia eta'u dava doutamo luva ivavitaitatai e'outa ediaka, “Loba vavai kauna ka ela'asi eda'a ena lobai kea bevavado. ");
INSERT INTO nrz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ena witi keata ekapo odaoda koanai, vaida 'eva dalai de'ekoasi, ua'i manumau deasi deani paluta. ");
INSERT INTO nrz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Vaida kano bika'a bika'anai de'ekoasi, dekubu molaumolau 'olana kano ekevekeve. ");
INSERT INTO nrz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Inoku melala ele'au koanai kopita delamoda maivaka de'ibu 'olana lamuta asi'i. ");
INSERT INTO nrz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kea vaida 'iniauma laloatai de'ekoasi, beia 'iniauma dekubu inoku devavilita kaiukaiu. ");
INSERT INTO nrz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Beia kea vaida 'eva kano nama'inai de'ekoasi. Inoku devua vaida vuata 'eva sinavu ka (100), vaida kalakoinavui (60), mai vaida koinavui (30). ");
INSERT INTO nrz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Maikaiana kauna 'eva lele be'ika.” ");
INSERT INTO nrz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Inoku ibanona kauta deasi Iesu kevana delavuaia dediaka, “Dava 'ounai kau luva ivavitaitata o'outa?” ");
INSERT INTO nrz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu eta luva evamuea ediaka, “Dilava ena lovia vanuana ikabasina vunita 'eva 'ani avenimui, beia ia kele'etai 'eva asi'i. ");
INSERT INTO nrz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","'Olana kau ka maiena dava kauna, doutamo bevenia, inoku ia ena dava 'eva bedoutamo vaika. Kau ka kevanai asi'i kauna kele'enai kava'ina emimia davana 'eva beabia ovo. ");
INSERT INTO nrz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Luva ivavitaitata a'oumui 'olana 'eva kanania, beikala beia sia beikala une, lele be'ika beia sia beika une mai sia beikabasi. ");
INSERT INTO nrz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kanaua 'ounai Isaia ena enolea luvana 'eva easi emomo'ai, ‘Kaiamuiai lele oi oika beia nuamui sia de'eko'ovi, oi boikata 'udai'udai beia sia oi boikata une. ");
INSERT INTO nrz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","'Olana kau katania nuata 'eva devabula, kaiata 'eva de'ou bubu mai makata 'eva de'alavu, makatai asi'i demaikaika, kaiatai lele asi'i demaika, nuata asi'i dema'eko'ovi, kanaua 'ounai asi'idemalalo 'udai keva'uai, amavamaulita 'ounai.’ ");
INSERT INTO nrz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Oi 'eva Dilava evanama'inamui, 'olana makamuiai oi oika mai kaiamuiai lele oi o'ika 'ounai. ");
INSERT INTO nrz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lau luva umauna a'oumui, enolea kauta mai komolo kauta doutamo deula vaika dava oi oikala davana bemaikala, beia sia deikala, maivaka kaiamuiai lele oi o'ika davana bemaika, beia sia de'ika.” ");
INSERT INTO nrz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ Lele oika, luva ivavitaitatai vadovado anina 'eva dava. ");
INSERT INTO nrz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kau Dilava ena lovia vanuana valina de'ika beia nuata sia de'eko'ovi koanai diabolo e'asi dava nuatai devadota davata eabi tau. Kanania 'eva kea kataua dalai de'ekoasi boita. ");
INSERT INTO nrz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kano bika'a bika'ana akanai kea de'ekoasi 'eva itani kau ka Dilava ena luva 'uluna e'ika inoku mailalonamana alimo eabia dae. ");
INSERT INTO nrz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Beia lamuna sia de'ovu kave'i 'ounai sia emia dau'a. Dilava ena luva 'ounai adedua 'o vaivivi de'asi koanai komolonai mo e'ekoasi. ");
INSERT INTO nrz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mai kea 'iniauma viloatai de'ekoasi 'eva itani kau ka Dilava ena luva 'uluna e'ika beia kanobata nua anina mai lavona lalovaita detata'u luva kanaua de'alavua inoku sia evuvua. ");
INSERT INTO nrz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Beia kea kano medianai de'ekoasi 'eva itani kau ka Dilava ena luva 'uluna e'ika mai nuana e'eko'ovi. Ia 'eva evuvua vuavuana sinavu ka (100), vaida kalakoinavui (60), mai vaida koinavui (30).” ");
INSERT INTO nrz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu luva ivavitaitana ka vaka e'outa. “Dilava ena lovia vanuana 'eva itani kau ka kea nama'ita ena lobai evadota. ");
INSERT INTO nrz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Beia kau boutai demuinai tabu laloanai, ena 'ou kauna easi witi viloatai ava evadota inoku eda'a. ");
INSERT INTO nrz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Witi dekubu vuata devua koanai, ava vaka dekubu. ");
INSERT INTO nrz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Loba 'uala kauna ena da'ala abi kauta deasi kevana de'ouia dediaka, ‘'Ola kaumu e, oni emu lobai 'eva kea nama'ita ovadota, beia ava kataua 'eva a'i deasi?’ ");
INSERT INTO nrz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ia eta luva evamuea ediaka, ‘'Ou kauna ka kanana evavaia.’ Ena da'ala abi kauta dediaka, ‘O'ula lai bada'a ava lai babukuisi?’ ");
INSERT INTO nrz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ia e'outa ediaka, ‘Asi'i, 'olana ava oi bobukuta isi koanai witi vaka ava ita asi'i oi omabukuta isi ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ovikanita lalua dekubu ka'ona beda'amo witi i'alita melalana. Melala kanaua'i 'eva i'alina kauta ba'outa, “Makavana 'eva ava oi bodoutabou oi bodo'o 'inita botouta be'ani, inoku witi oi bodoutabou oi boabita bo'asi e'u aile'e laloanai.” ’” ");
INSERT INTO nrz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu luva ivavitaitana ka vaka e'outa. “Dilava ena lovia vanuana 'eva itani tuava keana boina. Kau ka eabia inoku ena lobai evadoia. ");
INSERT INTO nrz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kea boutai viloatai ia 'eva ekiki vaika, beia ekubu koanai ia lobai 'eva namavaikana vadovado davata boutai evavele kanita, au ai eao aka manumanuta deasi ua'i le'enai lata de'ani.” ");
INSERT INTO nrz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu luva ivavitaitana ka mune'e e'outa. “Dilava ena lovia vanuana 'eva itani vakubu mulamulana boina. Ateate ka vakubu mulamulana eabia vodu namana laloanai palaoa doutamo ita eiuia lavo'i eda'amo palaoa itoina ekubu.” ");
INSERT INTO nrz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu dava katania boutai kau mato e'outa 'eva sia luva umautai, beia luva ivavitaitatai mo e'outa. ");
INSERT INTO nrz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kanania 'eva enolea kauna eluvavaia luvana evamomo'aia. “Baluva venita koanai luva ivavitaitanai baluva venita, kanobata epulu easi mo vali'u 'eva dava vunita davata lau batata'u ba'outa dae.” ");
INSERT INTO nrz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Inoku Iesu kau mato evikanita eda'a luma laloanai edodo, ibanona kauta deasi kevana de'ouia dediaka, “Luva ivavitaitana kanania loba laloanai ava anina 'eva dava 'oumai kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu enu'ovi ediaka, “ Kau kea nama'ina evadoia kauna 'eva lau kau nakuna. ");
INSERT INTO nrz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Loba 'eva kanobata, kea nama'ita 'eva Dilava ena lovia vanuana kauta, ava 'eva kau si'avana ena kau. ");
INSERT INTO nrz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","'Ou kauna kanaua ava evadota kauna 'eva diabolo. I'alina melalana 'eva kanobata to'ona, i'alina kauta 'eva anelu. ");
INSERT INTO nrz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ava ibukuta isi mai idoubouta 'alovai be'ani 'eva kanobata to'onai bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lau kau nakuna e'u anelu basinita la'asi e'u vanua laloanai va'eva devavai kauta mai si'avana devavai kauta boutai bevalalota. ");
INSERT INTO nrz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ia betata'u 'alova sia ebo'o kovo 'abuna laloanai bekapota dodo, ua'i bekakani mai 'asi'asita beala'o'i ala'o'i. ");
INSERT INTO nrz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Inoku komolo kauta 'eva Kamata ena lovia vanuana laloanai be'ailala itani melala boina. Mai kaiana kauna lele be'ika. ");
INSERT INTO nrz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Dilava ena lovia vanuana 'eva itani lavo nama'ina loba laloanai ikolena boina. Kau ka edavalia koanai ekoleia 'udai, mailalonamana eda'a ena dava boutai etavatava vaita moninai kano kanaua mailobana etavaia. ");
INSERT INTO nrz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mai Dilava ena lovia vanuana 'eva itani tavatava kauna ka 'emo'alu nama'ita ekavuta boina. ");
INSERT INTO nrz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Inoku 'emo'alu nama'ina vaika ka edavalia koanai, eda'a ena dava boutai etavatava vaita moninai 'emo'alu kanaua etavaia. ");
INSERT INTO nrz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Maivaka Dilava ena lovia vanuana 'eva itani vuo 'ovuai denaia inoku sisi edeata edeata dekoa boina. ");
INSERT INTO nrz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Va'eka kauta vuo evonu koanai nabuai develia 'au, inoku demiadivo sisi nama'ita alavu laloanai deudata, beia si'avata 'eva deitota'au. ");
INSERT INTO nrz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kanobata ena oleai 'eva kanaua bepulu koma. Anelu be'asi komolo kauta mai si'avana kauta beva'alamata. ");
INSERT INTO nrz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Si'avana kauta 'eva 'alova sia ebo'o kovo 'abuna laloanai bekapota dodo, ua'i bekakani mai 'asi'asita beala'o'i ala'o'i.” ");
INSERT INTO nrz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Inoku Iesu elavuaita ediaka, “Luva katania boutai nuamuiai 'ani de'eko'ovi?” Ena luva devamuea dediaka, “'O, nuamai 'ani de'eko'ovi.” ");
INSERT INTO nrz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ia e'outa ediaka, “Kanaua 'ounai talavatu 'ola kauta kataua Dilava ena lovia vanuana valina 'ani deikabasi kauta ka ka 'eva itani luma 'uala kauna boina, ena doubou doubou laloanai lavo makamakata mai 'ana'ita bedalata isi.” ");
INSERT INTO nrz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu luva ivavitaitata katania e'outa mulinai 'abu kanaua evikania, ");
INSERT INTO nrz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","easi ena vanuai Iuda eta lo'e laloanai kau evaikabasita 'eva detabulovo si'asi'a. Delavuai lavuai dediaka, “Kau kanania aoneka mai vatabulovo vinaulata katania a'i eabita? ");
INSERT INTO nrz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ia 'eva kamuta kauna nakuna umauna, ia sinana vana Malia, bo'akalana 'eva Iakobo, Iosepa, Simona mai Iuda. ");
INSERT INTO nrz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lovuna boutai 'eva nia'i ita kamimia. Inoku kau kanania 'eva dava katania boutai a'i eabita?” ");
INSERT INTO nrz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Inoku ia deta'u Iesu devaivivia. Beia Iesu ia e'outa ediaka, “Enolea kauna 'eva 'abu boutai ai 'olana be'aku, ena vanuai mai ena luma kauta 'eva 'olana sia be'aku.” ");
INSERT INTO nrz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'Olana eta abiveni asi'i 'ounai vatabulovo vinaulata doutamo ua'i sia evavai. ");
INSERT INTO nrz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Melala kanaua'i lovia 'olana 'Eloda 'eva Kalilea e'ola vaia koanai Iesu valina eika. ");
INSERT INTO nrz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Inoku ena vinaula kauta e'outa ediaka, “Ioane vaidi'u kabukabu kauna akubala 'eva ba ai eko'isi 'udai, kanaua 'ounai vatabulovo vinaulata siavuna katania ia nuanai devinaula.” ");
INSERT INTO nrz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","'Ana'inai Eloda 'eva bo'akalana Pilipo adana Elodia eadavala. Inoku Ioane vaidi'u kabukabu kauna Eloda e'ouia ediaka, “Ateate kanania oadavala 'eva sia ekomolo.” Kanaua 'ounai Eloda luva eveni Ioane delioia vabuto'o lumanai de'alavua. ");
INSERT INTO nrz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eloda ena ula Ioane beaku bala, beia kau makauta emakau, 'olana Ioane 'eva enolea kaunai devaoa. ");
INSERT INTO nrz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Eloda ena pulu melalana nadunai Elodia nakuna vatona kau mato vailatai eneva, inoku Eloda evalalonamala keini. ");
INSERT INTO nrz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kanaua'i Eloda vato eluva 'ana'i venia ediaka, ena luva 'ana'i kula'ilana vato e'ouia 'eva dava benoinoi vaia davana 'eva bevenia mo. ");
INSERT INTO nrz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sinana ena luvai vato Eloda enoia ediaka, “Vali'u mo Ioane vaidi'u kabukabu kauna 'olana nauai boudala boveni'u.” ");
INSERT INTO nrz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eloda lovia 'olana nuana evilalo. Beia ena luva 'ana'i e'aeta kauta vailatai eluvavaia 'ounai, luva eveni vato ena noinoi vinaulana bevavaia. ");
INSERT INTO nrz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kanaua 'ounai esinita vabuto'o lumana laloanai Ioane 'atona detauia uku. ");
INSERT INTO nrz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ioane 'olana nau nuanai deudaia deabia deasi vato devenia, inoku vato evuaia eda'a sinana evenia. ");
INSERT INTO nrz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ioane ibanona kauta deasi kauanina deabia devuaia deda'a dekoleia. Inoku deda'a Iesu de'ouia. ");
INSERT INTO nrz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu vali kanaua eika koanai asiai ele'au sibona eda'a 'abu 'avaeana ka, kau doutamo 'ulu kanania deika koanai eta vanuai aetai Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu asiai e'ovu kau mato namana eikaia koanai elalota mai eta 'olele evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","'Ani elavilavi 'ounai ibanona kauta deda'a Iesu kevana de'ouia dediaka, “Kanania 'eva 'abu 'avaeana maivaka 'ani eboboni. Do'u kauta sinita deda'a, vanua vaida laloatai sibota eta iani betatava 'eva benama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu e'outa ediaka, “Ia 'eva sia basinita, oi dava kena oi bovenita beania.” ");
INSERT INTO nrz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ibanona kauta de'ouia dediaka, “Lai kele'emaiai 'eva palaoa ima mai sisi lua mo.” ");
INSERT INTO nrz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu e'outa ediaka, “Oabi omai kele'e'u.” ");
INSERT INTO nrz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Inoku kau e'outa ava akanai bemiadivo, palaoa ima mai sisi luana eabita e'a'adae vutuvutu eikaia Dilava evanama'inala inoku palaoa ekovita, ibanona kauta evenita deda'a kau devenita. ");
INSERT INTO nrz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ia boutai deaniani deani vunu, ibanona kauta iani kalita dedoubou aleka boutai 'ouka lua devavonuta. ");
INSERT INTO nrz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kau deaniani kauta 'eva sinavu imanavui (5,000) boina, kau mo 'avaena devakuta ia 'a'ate mai melo 'eva sia devakuta. ");
INSERT INTO nrz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kanaua mulinai Iesu komolonai ibanona kauta asiai evaeleta 'au be'ana'ia beda'a 'ovu avekenai, laloanai ia 'eva kau esinita bedada'a. ");
INSERT INTO nrz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kau esinita deda'a mulinai, ia sibona lolo ka ai ele'au bemeamea. Eboni koanai ia 'eva sibona ua'i. ");
INSERT INTO nrz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Beia asi kano evikania 'ani ela'asi vaika 'ovuai laloanai, ka'uda eko'isi asi eakuia ua eda'aia nia easia 'olana lani 'eva vailatai easi. ");
INSERT INTO nrz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","'Avu'avu vabulanai 'o'oloko ivakoina e'alala vitaitanai Iesu vei akanai eda'a kele'eta. ");
INSERT INTO nrz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ibanona kauta Iesu vei akanai eda'a deikaia koanai demakau si'asi'a, inoku devilavila dediaka, “Ei, ka'uba.” ");
INSERT INTO nrz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iesu komolonai mo e'outa ediaka, “Ovapasisi, nia lau, sia oi bomakau.” ");
INSERT INTO nrz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petelo eko'isi e'ouia ediaka, “Lovia namana e, oni umaumu koanai luva inoku vei akanai bavasi kele'emu.” ");
INSERT INTO nrz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu e'ouia ediaka, “Mai.” Inoku Petelo asiai e'ovu vei akanai eda'a keke Iesu kevana eda'aia. ");
INSERT INTO nrz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Beia ka'uda namana eikaia koanai emakau, veiai ebulubulu laloanai evaoi ediaka, “Lovia namana e, bomavamauli'u!” ");
INSERT INTO nrz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Komolonaimo Iesu imana eisialao Petelo eabia e'ouia ediaka, “Emu abiveni ekiki, dava 'ounai nuamu elalo to'ato'a?” ");
INSERT INTO nrz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Inoku laluana asi akanai dele'au 'eva lani eto'o. ");
INSERT INTO nrz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ibanona kauta ua'i asi nuanai Iesu dekukudivo venia dediaka, “Momo'ai dokadoka oni 'eva Dilava Nakuna.” ");
INSERT INTO nrz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Ovuai dekeini deasi Kenesaleta kanonai dela'asi. ");
INSERT INTO nrz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'Abu kanaua kauta Iesu deikaia une 'eva luva desinia eda'a vanua kele'etai kauta kevata, inoku kau kataua eta 'olele kauta boutai devuata deasi Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kau Iesu denoia 'olele kauta ena tubu'a tolina mo bema abia kovo. Inoku Iesu ena tubu'a tolina deabia kovo kauta boutai 'eva denama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Inoku Palisea kauta mai talavatu 'ola kauta vaida Ielusalemai deasi Iesu kevana delavuaia dediaka, ");
INSERT INTO nrz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dava 'ounai ibanomu kauta koakoa 'ai'aita talavatuta deukuta? Imata sia dedeini makava ia deaniani.” ");
INSERT INTO nrz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu eta luva evamuea ediaka, “Dava 'ounai oi Dilava ena talavatu luvana oukua, beia emui koakoa 'ana'ita oabi dae? ");
INSERT INTO nrz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","'Olana Dilava ediaka, ‘Kamamu mai sinamu 'olata bo'aku,’ maivaka ediaka ‘Kau ka kamana 'o sinana besivada venia kauna 'eva beaku bala.’ ");
INSERT INTO nrz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Beia oi 'eva emui vaikabasiai oi odiaka, ‘Kau ka kamana 'o sinana be'outa bediaka, “Lavo katania'i bamadulumui davata 'eva baveveni Dilava ena.” ");
INSERT INTO nrz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Inoku kau kanaua 'eva kamana mai sinana 'eva dava kanaua'i 'olata sia be'aku.’ Dala kanaua boinai Dilava ena luva 'eva sia oi oabia dae, ia koakoa 'ana'ita mo oabi dae. ");
INSERT INTO nrz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dede kaumui e, Isaia 'eva ekomolo ena enolea luvatai oi akamuiai 'eva ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Kau katania 'eva nututa bibi'atai mo va'u devanama'inala, beia nuata 'eva dau'ai vaikai. ");
INSERT INTO nrz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dekukudivo veni'u 'avaea, 'olana devaikabasi talavatuta 'eva kau eta talavatu luvata mo.” ");
INSERT INTO nrz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu kau mato e'aeta deda'a kevana inoku e'outa ediaka, “Lele oika maivaka ovona oi bo'ovo. ");
INSERT INTO nrz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dava nutuai edodo edada'a nuai davana 'eva Dilava vailanai kau sia eva'obua, beia dava nutuai ela'asi davana 'eva kau eva'obua.” ");
INSERT INTO nrz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Inoku ibanona kauta deasi kevana delavuaia dediaka, “Palisea kauta lelemu deika koanai nuata de'avala 'eva oikabasi?” ");
INSERT INTO nrz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eta luva evamuea ediaka, “Kama'u vutuvutuai emimia kauna sia evadota auta boutai 'eva mailamuta bebuluta isi. ");
INSERT INTO nrz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ovikanita. Ia makata de'ede 'ounai 'ede kauta devada'ata. Bema 'ede kauna ka betata'u 'ede kauna ka bevada'ala koanai laluana 'uliai be'ekouda.” ");
INSERT INTO nrz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Inoku Petelo ediaka, “Luva ivavitaitana kanania anina 'oumai kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu ia e'outa ediaka, “Oi vaka nuamui sia de'eko'ovi? ");
INSERT INTO nrz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dava boutai nutuai dedododo deda'a bo'ai davata 'eva bo'ai dela'asi de'asi mulimuliai 'eva sia oi oikabasi? ");
INSERT INTO nrz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Beia dava nutuai dela'asi davata 'eva nuai de'asi dela'asi, inoku davata kataua detata'u kau deva'obuta. ");
INSERT INTO nrz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Inoku nuai ela'asi davana 'eva lalovai si'avata kau evada'ata beakuaku, bekulakula, bemaka si'a, bevinao, bededede mai be'oukeinikeini. ");
INSERT INTO nrz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Koakoa kataua 'eva Dilava vailanai kau deva'obuta, beia imata sia kadeini kaniani 'eva kau sia eva'obua.” ");
INSERT INTO nrz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu 'abu kanaua evikania eda'a Tulo mai Sidono kanotai. ");
INSERT INTO nrz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Abu kanaua'i Kanaana ateatena ka easi kevana inoku e'aeia ediaka, “Lovia namana Davida Nakuna e, lalo'u, ka'uba si'avana naku'u vatona nuanai 'eva evaana anala vaika.” ");
INSERT INTO nrz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Beia Iesu ateate ena luva sia evamuea, inoku ibanona kauta Iesu denoia 'udai 'udai dediaka, “Lo'oa eda'a tau, 'olana mulitai e'asi e'aeta basibasi.” ");
INSERT INTO nrz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu ediaka, “Dilava lau esini'u 'eva Isalaela mamoeta detaule mo daitai.” ");
INSERT INTO nrz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ateate easi Iesu vailanai ekuidula, ediaka, “Lovia namana e, dulu'u.” ");
INSERT INTO nrz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu ateate ena luva evamuea ediaka, “Melo eta iani ekaito'au 'oveka be'ani 'eva sia enama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ateate ediaka, “Luva umauna Lovia namana, beia lovia kauna ena vakai, iani 'ika'ikata de'ekoasi venuai 'eva 'oveka vaka de'ani.” ");
INSERT INTO nrz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Inoku Iesu e'ouia ediaka. “Ateate e, emu abiveni 'eva namavaikana, emu ula davana 'eva bepupulu.” Melala kanaua'i mo nakuna vatona emauli. ");
INSERT INTO nrz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu 'abu kanaua evikania eda'a Kalilea 'ovu nabuana eda'aia, inoku loloai ele'au emiadivo. ");
INSERT INTO nrz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kau mato namavaikana deasi kevana, devuata deasi kauta 'eva 'ome'ome, maka 'ede, ima bade, malata desi'avana, maivaka 'olele kauta edeata edeata Iesu aena 'olanai dene'etadivo, inoku ia eta'u evamaulita. ");
INSERT INTO nrz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Malata desi'avana kauta deluvaluva, ima bade kauta imata dekomolo, 'ome'ome kauta dedada'a, makata de'ede kauta deikaika. Kau koa katania deikata koanai detabulovo si'asi'a, inoku Isalaela eta Dilava devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ibanona kauta e'aeta deasi kevana, e'outa ediaka, “Lau kau katania 'eva alalota, 'olana ia 'eva 'ani melala koi lau kele'euai demimia mai sia dava ka deania, maivikolota basinita bedada'a 'eva sia a'ula, 'olana ka dalai asi'i ema'eko.” ");
INSERT INTO nrz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ibanona kauta dediaka, “Nia 'eva kano'akuna, iani a'i eka abita kau mato kanania boina ekavananita?” ");
INSERT INTO nrz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu elavuaita ediaka, “Iani kevamuiai vida?” Ia dediaka, “Palaoa kalakoi ka mai sisi kikita vitalua mo.” ");
INSERT INTO nrz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Inoku Iesu eta'u kau mato e'outa kanoai bemiadivo. ");
INSERT INTO nrz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inoku palaoa kalakoi ka mai sisi eabita Dilava evanama'inala, mulinai ekovita mukamuka, ibanona kauta evenita inoku ibanona kauta kau devenita. ");
INSERT INTO nrz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kau boutai deaniani deani vunu, ibanona kauta iani kalita aleka kalakoi ka devavonuta. ");
INSERT INTO nrz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ua'i deaniani kauta devakuta 'eva sinavu vani navui (4,000), beia 'a'ate mai melo 'eva sia devakuta. ");
INSERT INTO nrz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iesu kau mato esinita deda'a mulinai asiai ele'au ekeini Makadana kanona eda'aia. ");
INSERT INTO nrz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palisea mai Sadukea kauta vaida deasi Iesu kevana dekovoia, denoia koa ka bevaikata 'eva bevamomo'aia ia vutuvutuai easi. ");
INSERT INTO nrz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Beia Iesu eta luva evamuea ediaka, “Lavilavi melala ena ulu eda'a venia koanai, oi odiaka, ‘Mala melala benama'ina 'olana vutuvutu ebailua.’ ");
INSERT INTO nrz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Belani 'avu'avu oi bodiaka, ‘Vali'u melala kanania'i 'eva lamu mai lani be'asi 'olana vutuvutu e'aola mai oli e'alavua.’ Koa davata vutuvutuai bepupulu 'eva oi oikabasi, beia dava 'ounai melala katania'i koa dava bepupulu davata 'eva sia oi oikabasita? ");
INSERT INTO nrz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abiveni asi'i mai si'avana uluna kaumui, koa oi okakavu, beia koa sia ka bavaikamui, enolea kauna Iona ena koa mo bavaikamui.” Inoku Iesu evikanita kele'etai eda'atau. ");
INSERT INTO nrz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Inoku ibanona kauta dekeini 'ovu avekenai koanai palaoa debolabolata sia deabi. ");
INSERT INTO nrz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Inoku Iesu e'outa ediaka, “Makamui oi bovaata, Palisea mai Sadukea kauta eta vakubu mulamulana kele'enai oi bo'imamui kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ibanona kauta sibota deluvaluva dediaka, “Luva kanania eluvala 'olana palaoa ka sia kabia ka'asi.” ");
INSERT INTO nrz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu eta lalovai eikabasia 'ounai e'outa ediaka, “Abiveni kiki kaumui e, dava 'ounai sibomui palaoa sia ka oi oabia 'ounai oi oluvaluva? ");
INSERT INTO nrz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nuamui sia de'ailala maivaka palaoa ima kau sinavu imanavuiai (5,000) deani vunu mai kalita aleka vida oi ovavonu 'eva sia oi olalovai 'ini, una? ");
INSERT INTO nrz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Maivaka palaoa kalakoi ka kau sinavu vaninavuiai (4,000) deani vunu, kalita aleka vida oi ovavonuta 'eva sia oi olalovai 'ini, una? ");
INSERT INTO nrz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Dava 'ounai nuamui sia de'ailala? Lau 'eva palaoa lovana sia akua, beia Palisea mai Sadukea kauta eta vakubu mulamulanai oi bo'imamui kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Inoku luva kanaua'i nuata de'ailala, deikabasi ia 'eva palaoa ivakubuna mulamulana lovana sia eakuia beia ia 'eva Palisea mai Sadukea kauta eta vaikabasi luvatai be'imata kave'i lovata eakuia. ");
INSERT INTO nrz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu Kaisalea Pilipi kanotai ela'asi koanai, ibanona kauta elavuaita ediaka, “Kau dava dekoma, lau kau nakuna 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ena luva devamuea dediaka, “Vaida dediaka Ioane vaidi'u kabukabu kauna, vaida dediaka Elia, maivaka vaida dediaka Ielemia 'o enolea kauna ka.” ");
INSERT INTO nrz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iesu mune'e elavuaita 'udai ediaka, “Beia oi 'eva dava oi okoma, lau 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petelo e'ouia ediaka, “Oni 'eva Keliso, mauli Dilavana Nakuna.” ");
INSERT INTO nrz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu ediaka, “Simona Ioane nakuna e, Dilava evanama'inamu, 'olana sia kau ka luva kanania oni evaikabasimu beia Kama'u vutuvutuai emimia kauna evaikabasimu. ");
INSERT INTO nrz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A'oumu, oni 'eva Petelo, Bika'a kanania akanai e'u lo'e bavalavala, ba ena siavu 'eva e'u lo'e kanania sia beva'iuvai 'iuvaia. ");
INSERT INTO nrz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Lau batata'u Dilava ena lovia vanuana iluvuna siavuna bavenimu, inoku kanobata ai boliota davata 'eva vutuvutuai beliota, kanobatai boluvuta davata 'eva vutuvutuai beluvuta.” ");
INSERT INTO nrz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Inoku Iesu ibanona kauta e'outa kao, sia kau ka vailanai bediaka ia 'eva Keliso. ");
INSERT INTO nrz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Melala kanaua'i Iesu ibanona kauta evaikabasita makava ia 'eva beda'a dokadoka Ielusalema ai ua'i Iuda eta kau namata, kabukabu kauta namata maivaka talavatu 'ola kauta beva anaanala vaika inoku beaku bala, beia melala ivakoinai Dilava betata'u ia bevako'isia 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petelo eta'u Iesu evuaia eda'a 'aba'abai inoku e'ovenia ediaka, “Lovia namana e, kanaua sia bekoma, oni 'eva kanaua sia bekomamu.” ");
INSERT INTO nrz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu elava 'udai Petelo e'ovenia ediaka, “Satani e, kele'euai da'atau, oni lau e'u dala o'alavua, 'olana emu lalovai lalovai 'eva sia Dilava enai beia kau etai deasi.” ");
INSERT INTO nrz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Inoku Iesu ibanona kauta e'outa ediaka, “Kau ka be'ula lau muli'uai bedada'a koanai ia sibona ena mauli bevikania, ena au ido'o valaukuna bevuala lau muli'uai bedada'a. ");
INSERT INTO nrz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kau ka sibona ena mauli sia e'ula bevikania kauna 'eva bevatauleia, beia kau ka lau dai'uai sibona ena mauli bevikania kauna 'eva beabi 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kau ka kanobata itoinai iabinai ena mauli bevatauleia 'eva ena nama'ina dava? 'O kau ka ena mauli davai betavala 'udai? ");
INSERT INTO nrz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Lau Kau Nakuna 'eva Kama'u nuavinai e'u anelu ita lai ba'asi, melala kanaua'i kau ka ka eta vinaula vitaitatai tavata baveveni. ");
INSERT INTO nrz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lau oi luva umauna a'oumui, vaida nia'i delalava kauta sia bebaba beda'amo Lau Kau Nakuna vutuvutu vanuana lovia siavunai ba'asi kau viloatai 'eva beika'u.” ");
INSERT INTO nrz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Melala kalakoi mulitai Iesu eta'u Petelo, Iakobo mai kadina Ioane ita mo sibota evada'ata deda'a lolo namana ka ai dele'au. ");
INSERT INTO nrz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Inoku ua'i ia vailatai Iesu ikana edeana, vailana e'ailala ovo itani melala boina maivaka ena tubu'a dedeva'i si'asi'a de'amale 'amale. ");
INSERT INTO nrz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Komolonaimo Mose mai Elia dela'asi ia vailatai, Iesu ita deluvaluva. ");
INSERT INTO nrz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Inoku Petelo Iesu e'ouia ediaka, “Lovia namana e, ita nia'i kamimia 'eva emanama'ina, oni bo'ula koanai lau aiole koi bavavaita ka oni emu ka Mose ena ka Elia ena.” ");
INSERT INTO nrz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petelo eluva do'o laloanai, oli deva'i ovona easi e'alavuta, inoku lele ka oli laloanai easi ediaka, “Kanania 'eva lau naku'u, e'u lalo'au, lau ia alalonamavenia, lelena oi boika.” ");
INSERT INTO nrz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ibanona kauta lele kanaua deika koanai de'eko kanoai depakadivo, demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Beia Iesu eda'a easi kele'etai, eabita kovo e'outa ediaka, “Sia oi bomakau, oko'isi.” ");
INSERT INTO nrz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inoku ia de'a'a dae 'eva sia kau ka deikaia beia Iesu mo sibona. ");
INSERT INTO nrz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Loloai de'ovu koanai Iesu e'outa kao ediaka, “Dava oi oikala davana 'eva sia kau ka vailanai oi boluvala beda'amo lau kau nakuna ba ai bako'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Inoku ibanona kauta delavuaia dediaka, “Dava 'ounai talavatu 'ola kauta dediaka Elia 'eva beasi 'ana'i?” ");
INSERT INTO nrz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu eta luva evamuea ediaka, “Luva umauna, Elia 'eva be'asi inoku dava boutai beva'oluta kave'i. ");
INSERT INTO nrz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Beia lau oi a'oumui, Elia 'eva 'ani easi, kau ia sia deikala une beia kele'enai eta ula vinaulata 'eva devavaita, vitaitana kanaua boina lau kau nakuna vaka kanaua bevaanaana'u koma.” ");
INSERT INTO nrz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Inoku ibanona kauta deikabasi, ia 'eva Ioane va'idiu kabukabu kauna lovana eakuia. ");
INSERT INTO nrz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Inoku demue deda'a kau mato kele'etai dela'asi koanai, kau ka easi Iesu vailanai ekuidula e'ouia ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lovia namana e, Naku'u laloa 'olana ia 'eva 'olana ebo'obo'o mai evaanaanaia vaika, melala vaida sibona e'eko 'alova akanai 'o veiai edodovu. ");
INSERT INTO nrz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Avuaia ada'a ibanomu kauta kele'etai, beia bevanama'inala 'eva ia sia edaita.” ");
INSERT INTO nrz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu e'outa ediaka, “Oi sia maiemui abiveni mai kaia bo'o uluna kaumui, lau kevamuiai abamia dau'a koma? Melo oabia omai keva'u.” ");
INSERT INTO nrz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu ka'uba sia'avana e'ovenia, inoku ka'uba si'avana melo nuanai ela'asi, melo komolonai enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kanaua mulinai ibanona kauta vunivuniai deda'a Iesu delavuaia dediaka, “Dava 'ounai ka'uba si'avata vaika lai balo'ota asi ako 'eva sia edaimai?” ");
INSERT INTO nrz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu eta luva evamuea ediaka, “'Olana emui abiveni dekiki vaika. Lau oi luva umauna a'oumui, emui abiveni 'eva itani tuava keana boina koanai, lolo kanania oi boma'oua, ‘Ilu da'amo ua'i’ 'eva komolonai bemailu bemada'a, sia dava ka kele'emuiai bemapasisi vaika. ");
INSERT INTO nrz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Beia dava katania boita 'eva sibota sia bela'asi kovo, ia meamea ai mai loveai 'eva bela'asi.” ");
INSERT INTO nrz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ibanona kauta boutai deasi Kalileai devaka'onamo, inoku Iesu e'outa ediaka, “Lau kau Nakuna 'eva kou'u bekokou mai veni'u beveveni inoku beaku ba'u, ");
INSERT INTO nrz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","beia melala ivakoinai Dilava bevako'isi'u 'udai bamauli.” Kanaua deika koanai ibanona kauta devilalo. ");
INSERT INTO nrz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu mai ibanona kauta deda'a Kapelanaumai dela'asi koanai, lo'e kabukabuna monina devisia kauta deasi Petelo kevana delavuaia dediaka, “Emui vaikabasi kauna Lo'e Kabukabuna monina eveveni?” ");
INSERT INTO nrz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petelo ediaka, “'O, eveveni.” Inoku Petelo eda'a luma laloanai edodo asido'omo eluva laloanai, Iesu Petelo elavuaia ediaka, “Simona e, oni dava oko? Kanobata loviata 'eva nakuta kele'etai moni de'abi 'o kau edeata kele'etai de'abi?” ");
INSERT INTO nrz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petelo ediaka, “Kau edeata kele'etai deabi.” Iesu ediaka, “Oluva kave'i, kanaua 'ounai melo 'eva moni sia bene'edivo. ");
INSERT INTO nrz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Beia kau katania nuata asi'i kamavabaduta 'ounai, da'a 'ovuai emu kimai valona boitoa, sisi makavana bovelia'au sisina nutuna boluvua laloanai moni bodavalia, boabia bovenita laluana eta moni tavana.” ");
INSERT INTO nrz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Melala kanaua'i ibanona kauta deasi Iesu kevana delavuaia dediaka, “Dilava ena lovia vanuana laloanai dai 'eva namana be'ao?” ");
INSERT INTO nrz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Inoku Iesu melo kikina ka e'aeia easi viloatai evalavadivo. ");
INSERT INTO nrz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Inoku Iesu e'outa ediaka, “Lau oi luva umauna a'oumui, bema emui koakoa sia oi bovaedeana inoku melo kikita boitai sia oi bo'ao koanai oi 'eva Dilava ena lovia vanuanai sia oi boda'a dodo. ");
INSERT INTO nrz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kanaua 'ounai kau ka 'uluna asi'i melo kikina kanania boinai be'ao kauna, ia 'eva Dilava ena lovia vanuanai namana be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kau ka lau vau'ai melo kikina kanania boina eabia dae kauna 'eva lau vaka 'ani eabi'u dae. ");
INSERT INTO nrz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Beia lau deabiveni'u melona kanania boina ka va'eva ai bene'eadivo kauna 'eva bika'a namana 'atonai bedo'oa 'au inoku 'atubatai bekapoa uku bedono ba 'eva benama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kanobata kanania 'eva besi'avana vaika, 'olana ia betata'u kau bevada'ata si'avanai bene'etadivo. Vikovo kataua boita 'eva bepupulu, beia vikovo bevavaia kauna enai besi'avana vaika. ");
INSERT INTO nrz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Imamu 'o aemu si'avanai bene'emudivo koanai botaua uku boitoa 'au. Inoku imamu ka'onamo 'o aemu ka'onamo ai mauli keinikeini 'abunai boda'adodo 'eva enama'ina, ia sia enama'ina imamu luata 'o aemu luata bevada'amu sia ebo'o kovo mai eani keinikeini 'alovanai bekapomu dodo. ");
INSERT INTO nrz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Makamu ka si'avanai bene'emudivo koanai boia asi boitoa 'au. Makamu ka'onamoai mauli keinikeini 'abunai boda'adodo 'eva enama'ina, ia makamu luata nama'itai sia ebo'o kovo 'alovanai bekapomu dodo 'eva sia enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Oi bo'imamui kave'i melo kikita katania sia ka oi boikala 'iu'iu, 'olana ia eta anelu vutuvutuai 'eva melala boutai Kama'u vutuvutuai emimia kauna deluvavenia. ");
INSERT INTO nrz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Lau kau Nakuna 'eva detaule kauta bavamaulita 'ounai asi. ");
INSERT INTO nrz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Oi a olalovai koma? Kau ka ena mamoe sinavu ka, inoku ka'onamo bemataule koanai, kalavani ka navui kalavani ka (99) loloai bemavikanita inoku bemada'a etaule davana bemakavua. ");
INSERT INTO nrz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Lau oi luva umauna a'oumui, bema edavalia koanai, kalavani ka navui kalavani ka daita sia bemalalonama ia edavalia davana dainai 'eva bemalalonama si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vitaitanai Kamamui vutuvutuai e'ula melo kikita katania sia ka betaule. ");
INSERT INTO nrz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Bo'akalamu si'avana evavai kele'emuai koanai boda'a kevana laluana mo oi boluvaluva vaia ena si'avana vailanai boluvala kave'i, inoku lelemu beabidae koanai oni 'eva bo'akalamu ita 'ani oi ovaka'onamo 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Beia lelemu sia be'ika koanai kau ka 'o lua bovuata boda'a kevana, inoku kau kataua lua 'o koi luva oi boluva vaita davata boutai bevamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Beia sia be'ula lelemui be'ika koanai, lo'eai boluvala asi, inoku sia be'ula leleta be'ika koanai pulu edeana kaunai 'o si'avana kaunai oi bova aoa. ");
INSERT INTO nrz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Lau oi luva umauna a'oumui, dava kanobatai oi oliota 'eva vutuvutuai vaka beliota mai dava kanobatai oi boluvuta 'eva vutuvutuai vaka beluvuta. ");
INSERT INTO nrz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mai a'oumui 'udai, kanobatai laluana dava ka nuamui ka'onamoai oi bonoinoi vaia davana 'eva Kama'u vutuvutuai emimia kauna bevavaia oi emui. ");
INSERT INTO nrz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kau lua 'o koi lau vau'ai devaka'onamo, lau 'eva ua'i ia ita.” ");
INSERT INTO nrz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Inoku Petelo eda'a Iesu kevana elavuaia ediaka, “Lovia namana e, bo'akala'u bevavai si'asi'a kele'e'uai 'eva melala vida ena si'avana ba'ou kao? Melala kalakoi ka, una?” ");
INSERT INTO nrz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu ediaka, “ Melala sia kalakoi ka, beia melala kalakoi ka navui kalakoi ka (77). ");
INSERT INTO nrz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Olana Dilava ena lovia vanuana 'eva itani lovia 'olana ka boina, ena da'alabi kauta kele'enai dava vida deabi kauta 'eva bevakomolota. ");
INSERT INTO nrz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kanaua 'ounai ena vinaula emakavala laloanai kau ka ia kevanai sinavu boutai sinavu (10,000) eabi kauna devuaia deasi kevana. ");
INSERT INTO nrz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ia 'ola kauna ena moni tavana beveveni 'eva imanai sia edaia, 'ounai 'ola kauna ia e'ouia ediaka, ‘Oni mai adamu ita, nakumu mai emu dava boutai betavamui monitai moni oabia monina tavana boveveni.’ ");
INSERT INTO nrz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Inoku da'alabi kauna ena 'ola kauna vailanai ekuidula enoia ediaka, ‘Lalo'u melala kava'inamo boveni'u, inoku abia monina tavana itoina baveveni.’ ");
INSERT INTO nrz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Ola kauna da'alabi kauna elaloia, inoku moni eabia davana e'ouia kao inoku esinia eda'a. ");
INSERT INTO nrz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Inoku da'alabi kauna kanaua ela'asi eda'a koanai banona ka edavalia kau kanaua 'eva ia kele'enai kolo monina sinavu ka eabia, eko'isi kau kanaua eabi 'inia 'atona eveveia e'ouia ediaka, ‘E'u moni oabi monina tavana veni.’ ");
INSERT INTO nrz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Inoku ia banona ekuidula enoia, ‘Lalo'u melala kava'inamo vi'ima tavana 'ani baveni.’ ");
INSERT INTO nrz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Beia ia sia eula, kau kanaua evuaia eda'a vabuto'o 'abunai ene'eiadivo ua'i bemimia beda'amo moni tavata beveni palu. ");
INSERT INTO nrz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Da'alabi kauta vaida koa kanaua deikaia koanai nuata deanana, deda'a eta 'ola kauna kevana dava epulu davana de'ouia. ");
INSERT INTO nrz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Inoku 'ola kauna da'alabi kauna kanaua e'aeia easi, e'ouia ediaka, ‘Oni da'alabi kaumu si'avamu vaika, onoi'u 'ounai moni oabia monina itoinai a'ouia kao. ");
INSERT INTO nrz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Beia dava 'ounai banomu sia olaloia vitaitana lau alalomu boina?’ ");
INSERT INTO nrz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Ola kauna ebadu si'asi'a da'alabi kauna evavabuto'oa anaana bevenia beda'amo moni kanaua eabia monina tavana itoinai beveni palu. ");
INSERT INTO nrz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kanaua 'ounai oi ka ka bo'akalamui nuamui umautai eta si'avana sia oi bo'outa kao koanai Kama'u vutuvutuai emimia kauna vaka kanaua bekomamui.” ");
INSERT INTO nrz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu luva kataua eluva koa mulinai, Kalilea evikania eda'a Iuda kanonai Iolidana nutu avekena duasi. ");
INSERT INTO nrz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kau mato namavaikana ia mulinai deda'a u'ai eta 'olele evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Inoku Palisea kauta vaida deasi Iesu kevana devakovoa delavuaia dediaka, “Kau ka ena lalovai vaida daitai adana beva'ovua 'eva mai ena komolo ka 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu eta luva evamuea ediaka, “Oi Puka Kabukabuna sia oi ovakua, una? Makavana umaunai dava boutai ivavaita Dilavana eta'u kau evavaita 'eva moluane mai ateate evavaita. ");
INSERT INTO nrz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Inoku ediaka, ‘Kanaua 'ounai kau betata'u kamana mai sinana bevikanita, ia adana ita bevaka'onamo, laluana 'eva kauani ka'onamo.’ ");
INSERT INTO nrz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kanaua 'ounai ia 'eva sia lua ia ka'onamo. 'Ounai Dilava eta'u evaka'onamota kauta 'eva sia kau ka beva'alamata kovo.” ");
INSERT INTO nrz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Palisea kauta delavuaia 'udai dediaka, “Dava 'ounai Mose e'oumai ediaka, kau be'ula koanai iva'ovu malelena belelea adana bevenia inoku beva'ovua?” ");
INSERT INTO nrz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu eta luva evamuea ediaka, “Oi emui nua pasisi 'outai Mose komolo evenimui adamui oi bova'ovuta, beia makavanai 'eva sia kanaua boina. ");
INSERT INTO nrz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lau oi a'oumui, kau ka adana sia ekulakula beia eva'ovua 'avaea inoku ia mune'e ateate makamakana ka eadavala, kau kanaua 'eva kulakula koana evavaia.” ");
INSERT INTO nrz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ibanona kauta Iesu de'ouia dediaka, “Moluane mai ateate viloatai kanaua eko koanai, kau sia bemakamoane 'eva bemanama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu eta luva evamuea ediaka, “Luva kanana kau boutai kevatai 'eva sia beabia dae, beia Dilava evenita kautamo kele'etai 'eva bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kau vaida 'eva sia bekamoane, kau vaida 'eva kanaua boinai depulua sia bekamoane, kau vaida 'eva kau deta'u deivata sia bekamoane, kau vaida 'eva Dilava ena lovia vanuana 'ounai kamoane sia delalovaia. Dai kele'enai edaia kauna luva kanania beabia dae.” ");
INSERT INTO nrz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Melala kanaua'i kau vaida nakuta devuata deasi Iesu kevana akatai bekao'au bemeamea, beia ibanona kauta deta'u kau kataua de'ovenita, ");
INSERT INTO nrz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu ediaka, “Melo kikita ovikanita, demai kele'e'u sia oi bo'alavuta, 'olana Dilava ena lovia vanuana 'eva katana boita kauta eta.” ");
INSERT INTO nrz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iesu imana melo kikita akatai ekao'au evanama'inata, mulinai Iesu 'abu kanaua evikania. ");
INSERT INTO nrz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Inoku kau ka easi Iesu kevana elavuaia ediaka, “Vaikabasi kaumu e, vinaula nama'ina davana bavavaia 'eva mauli keinikeini babia?” ");
INSERT INTO nrz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu ena luva evamuea ediaka, “Dava 'ounai lau kele'e'uai vinaula nama'ina olavuai lavuai vaia? Dilava mo sibona enama'ina, oni bo'ula mauli keinikeini bo'abia koanai, talavatu luvata bo'ima kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ia ediaka, “Talavatu luvata davata?” Iesu ediaka, “Talavatuta katania, sia boakuaku, sia bokulakula, sia bovinao, sia bodede. ");
INSERT INTO nrz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kamamu mai sinamu 'olata bo'aku, maivaka kevamu kauna bolalo'au venia itani oni sibomu olalo'au venimu vitaitana.” ");
INSERT INTO nrz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kau alu'aluna ediaka, “Katania boutai 'ani a'ima kave'i, inoku davai 'eva atabu?” ");
INSERT INTO nrz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu ia e'ouia ediaka, “Bo'ula bonama'ina kave'i kave'i koanai da'a emu dava boutai tavatava vaita monita ta'ovala kauta bovenita, inoku emu lavo 'eva 'ani ua'i vutuvutuai boabia, inoku bo'asi muli'uai bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kau 'alu'aluna lele kanaua eika koanai nuana ebavunu eda'a tau, 'olana ia kevana lavo doutamo. ");
INSERT INTO nrz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Inoku Iesu ibanona kauta e'outa ediaka, “Lau oi luva umauna a'oumui. Lavo kauna Dilava ena lovia vanuanai beda'adodo 'eva bepasisi vaika. ");
INSERT INTO nrz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mai a'oumui 'udai. Sisi vana Kamela nila ilenai bedodo 'eva edaia, beia lavo kauna Dilava ena lovia vanuanai beda'adodo 'eva bepasisi vaika.” ");
INSERT INTO nrz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ibanona kauta luva kanaua deika koanai detabulovo si'asi'a delavuai lavuai dediaka, “Inoku dai 'eva mauli beabia?” ");
INSERT INTO nrz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu eika 'inita ediaka, “Kau etai kanania bevavaia 'eva sia bedaia, beia Dilava enai 'eva dava boutai bevavai bedaia.” ");
INSERT INTO nrz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petelo Iesu elavuaia ediaka, “Lai dava boutai avikanita inoku oni mo mulimuai lai adada'a, mulimuai lai adada'a 'eva dava lai babia?” ");
INSERT INTO nrz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu e'outa ediaka, “Lau oi luva umauna a'oumui. Dava boutai eta makamaka melalanai, lau Kau Nakuna e'u mia'au davana nuavina akanai bamia'au koanai, oi kaumui 'ouka lua muli'uai oi odada'a vaka mia'au davata 'ouka lua akatai oi bomia'au, Isalaela iduvuta 'ouka lua kauta oi bolavuaita. ");
INSERT INTO nrz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kau ka lau dai'uai ena luma 'o bo'akalana 'o lovuna 'o kamana 'o sinana 'o nakuna 'o ena kano bevikanita kauna 'eva sinavu sinavu akatai bedavalita 'udai, maivaka mauli keinikeini beabia. ");
INSERT INTO nrz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Beia doutamo de'ana'ia kauta 'eva bemulikai, inoku doutamo demulikai kauta 'eva be'ana'ia.” ");
INSERT INTO nrz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Dilava ena lovia vanuana 'eva kanania boina. Kano 'ula kauna 'avu'avu avulanai ela'asi eda'a vinaula kauta ekavuta ena vine kulanai bevinaula. ");
INSERT INTO nrz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kano 'uala kauna ita luva devaka'onamo tavata melala kaonamo laloanai kina 'ouka be'abi, inoku esinita deda'a ena kula. ");
INSERT INTO nrz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Melala koana kalavani ka (9) boina 'eva ela'asi eda'a tavatava 'abunai ua'i kau vaida delava 'avaea eikata. ");
INSERT INTO nrz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Inoku e'outa ediaka, ‘Oi vaka oda'a e'u kulai ovinaula, tavamui baveveni.’ ");
INSERT INTO nrz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Inoku ia vaka deda'a bevinaula. Ado'alavuni ela'asi eda'a mai vaka melala avekenai koana koi (3) boina ela'asi 'udai eda'a koa ka'onamo kanaua evavaia. ");
INSERT INTO nrz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mai lavilavi melala koana ima (5) boina ela'asi eda'a 'eva vaida mo delava 'avaea eikata, elavuaita ediaka, ‘Dava 'ounai nia'i oi olava boni 'avaea sia dava ka oi ovavaia?’ ");
INSERT INTO nrz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ena luva devamuea dediaka, ‘'Olana sia kau ka vinaula ka evenimai.’ Inoku e'outa ediaka, ‘Oi vaka oda'a e'u kulai ovinaula.’ ");
INSERT INTO nrz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Melala eulu koanai, kula 'uala kauna kula i'imana kauna e'ouia ediaka, ‘Devinaula kauta bo'aeta tavata bovenita, muliai vaika deasi devinaula kauta etai bomakavala beda'amo deasi makava kauta etai bovapuala.’ ");
INSERT INTO nrz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lavilavi melala koana ima (5) boina dedodo devinaula kauta deasi ka ka kina 'ouka 'ouka evenita de'abi. ");
INSERT INTO nrz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Inoku devinaula 'ana'i kauta deasi, eta lalovai 'eva tavata namata be'ao, beia ia vaka ka ka kina 'ouka 'ouka deabita. ");
INSERT INTO nrz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eta moni deabita koanai kula 'uala kauna denunulaia, ");
INSERT INTO nrz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","dediaka, ‘Muliai deasi kauta 'eva melala koana ka'onamo devinaula, lai 'eva melala kanania itoina ena mekau mai siavuna lai akoala, beia ia ita tavamai 'eva ovavitaita.’ ");
INSERT INTO nrz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kula 'ola kauna vinaula kauna ka ena luva evamuea ediaka, ‘E'u kau e, kele'emuai sia ava'eva. Ita laluana luva 'ani kavamomo'aia bovinaula melala ka'onamo koanai kina 'ouka bavenimu. ");
INSERT INTO nrz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oni tavamu abi inoku da'a. Lau a'ula muliai e'asi evinaula kauna ena bavenia oni emu avenimu vitaitanai. ");
INSERT INTO nrz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lau sibo'u e'u dava e'u ulai sibo'u sia bavavaia, una? 'O lau e'u nama'ina vaida etai 'ounai omamama, una? ");
INSERT INTO nrz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dala vitaitanai demulikai kauta be'ana'ia, ia de'ana'ia kauta bemulikai.’” ");
INSERT INTO nrz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu dalai eda'a Ielusalema koanai ibanona kauta 'ouka lua evalavatatau 'aba'abai e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Vali'u ita 'eva Ielusalema ai eka la'asi, lau Kau Nakuna 'eva kabukabu kauta namata mai talavatu 'ola kauta imatai beuda'u va'evai bene'e'udivo beaku ba'u. ");
INSERT INTO nrz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Lau 'eva pulu edeana kauta imatai beuda'u bemediamedia vai'u be'odi'u mai au ido'o valaukuna akanai beaku ba'u, beia melala ivakoinai bako'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Inoku Sebedeo nakuna lua sinata ita deasi Iesu kevana, sinata Iesu vailanai ekuidula ena 'ula davana ka enoinoi vaia. ");
INSERT INTO nrz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu ia elavuaia ediaka, “Dava o'ula?” Ia ediaka, “Naku'u katania luana komolo bovenita ka idibamu avekenai ka 'ealimu avekenai bemimia emu vutuvutu vanuana laloanai.” ");
INSERT INTO nrz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu ediaka, “Oi sia oikabasi dava oi onoinoi vaia? Anaana 'ouna bainua davana oi boinua bedaia, una?” Laluana dediaka, “Lai bainua bedaia.” ");
INSERT INTO nrz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu ia e'outa ediaka, “Luva umauna e'u 'ou 'eva oi boinua, beia idiba'u mai 'eali'u avekenai bemimia kauta 'eva lau sia badilata, ia 'abu kanaua 'eva 'ani Kama'u eva'olua edilata kauta mo bevenita.” ");
INSERT INTO nrz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ibanona kauta 'ouka luva kanaua deika koanai banota kataua laluana debadu venita. ");
INSERT INTO nrz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanaua 'ounai Iesu ibanona kauta boutai e'aeta deasi kevana e'outa ediaka, “Oi oikabasi pulu edea kauta eta lovia kauta 'eva eta ulai kau de'olavaita eta kau namata maivaka eta siavuai devaeleta 'au kau devasiavuta. ");
INSERT INTO nrz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Beia oi emuiai 'eva sia kanaua bekoma, kau ka viloamuiai e'ula namana be'ao kauna kanaua 'eva boumuiai emui da'alabi kaunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Maivaka kau ka viloamuiai e'ula be'ana'ia kauna kanaua 'eva boumuiai emui da'ala abi kaunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Vitaitana lau Kau Nakuna asi 'eva da'ala'u sia be'abi beia kau da'alata ba'abi, maivaka e'u mauli baveveni kau eta si'avanai bavamaulita 'ounai.” ");
INSERT INTO nrz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu ibanona kauta ita Ieliko devikania laloanai kau mato namavaikana ia mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Maka 'ede kauta lua dala 'aba'abanai demiadivo inoku Iesu kele'etai ekeini 'uluna deika koanai, de'ae'ae 'unu'unu dediaka, “Lovia namana, Davida Nakuna e! Lalomai!” ");
INSERT INTO nrz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Beia kau mato ia de'ovenita lele bevuvunu. Ia laluana de'ae 'udai 'ae 'udai, “Lovia namana, Davida Nakuna e! Lalomai!” ");
INSERT INTO nrz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu elavadivo e'aeta deasi kevana, inoku elavuaita ediaka, “Oi o'ula dava emuiai bavavaia?” ");
INSERT INTO nrz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ia dediaka, “Lovia namana e, lai a'ula makamai beluluvu.” ");
INSERT INTO nrz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu elalota, makata eabi kovo. Komolonai makata deluvu inoku deikaika, inoku Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu ibanona kauta ita 'ani Ielusalema dekevaia laloanai Olive lolonai Betepake ai dela'asi, ua'i Iesu eta'u ibanona kauta lua esinita de'ana'ia, ");
INSERT INTO nrz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","e'outa ediaka, “Oi boda'a vanua vailamuiai kanaua'i doniki ka mai nakuna ita dedo'ota oi bodavalita, oi boluvuta oi bovuata bo'asi keva'u. ");
INSERT INTO nrz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kau ka luva ka beluvala koanai oi bodiaka, ‘Lovia namana eula venita,’ inoku komolonai bevenimui.” ");
INSERT INTO nrz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kanania 'eva Enolea kauna ena luva ivamomo'aina ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siona vanua kauta bo'outa, Oikaia, emui lovia 'olana e'asi kevamui. Ia maimanauna doniki kabenai emia'au, doniki nakuna akanai emia'au.” ");
INSERT INTO nrz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ibanona kauta deda'a Iesu e'outa vinaulata vitaitana devavaita. ");
INSERT INTO nrz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Doniki nakuna ita devuata deasi, eta tubu'a akatai delavalita 'au inoku Iesu emia'au. ");
INSERT INTO nrz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kau mato eta tubu'a dalai delavalita, mai vaida au le'eta dekalata ovo dalai delavalita. ");
INSERT INTO nrz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iesu vailanai mai mulinai deda'a kauta devaoi dediaka, “'Osana, Davida Nakuna ena! Lovia namana vanai e'asi kauna Dilava betata'u bevanama'inala! 'Osana aka umau umaunai!” ");
INSERT INTO nrz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu Ielusalemai eda'adodo koanai vanua kauta 'ulu namavaikana devavaia inoku delavuai lavuai dediaka, “Nia 'eva kau davana?” ");
INSERT INTO nrz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kau mato dediaka, “Nia 'eva Iesu enolea kauna Kalilea Nasaleta ai easi.” ");
INSERT INTO nrz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu lo'e kabukabuna laloanai eda'adodo ua'i detavatava kauta boutai elo'ota asi, moni abi keini kauta eta vaka mai boiomalo detavatavavai kauta eta mia'au davata eva'i'itolita. ");
INSERT INTO nrz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","E'outa ediaka, “Puka kabukabunai 'ani ilelena, ‘E'u luma 'eva be'aea meamea lumana,’ beia oi 'eva vinaovinao kauta eta vunivuni 'abunai oi ovaaoa.” ");
INSERT INTO nrz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Makata desi'avana kauta mai 'ome'ome kauta deda'a Iesu kevana lo'e kabukabuna laloanai, inoku ia eta'u evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kabukabu kauta namata mai talavatu 'ola kauta Iesu vamauli koata evavai deikaia maivaka melo lo'e laloanai devaoi dediaka, ‘'Osana Davida Nakuna ena!’ ia 'eva debadu, ");
INSERT INTO nrz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","dediaka, “Oni melo dava deko leleta o'ika?” Iesu eta luva evamuea ediaka, “'O, leleta 'ani aika. Luva kanania 'ani oi ovakua? ‘Melo kikita mai 'oma'omata debabae do'o bibi'atai vamu devanama'inala.’” ");
INSERT INTO nrz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Inoku Iesu evikanita vanua namanai ela'asi eda'a Betani ai eboni ua'i emia. ");
INSERT INTO nrz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Elani 'avu'avu vabulanai Iesu emue eda'a vanua namana laloanai vikolo eakuia. ");
INSERT INTO nrz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Suke auna ka dala 'aba'abanai eikaia eda'a kevana. Beia vuana sia ka eikaia uauana mo eikata, inoku e'ouia ediaka, “Oni sia bovua 'udai!” Au kanaua komolonai uauana delamoda inoku de'ibu. ");
INSERT INTO nrz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ibanona kauta koa kanaua deikaia koanai detabulovo si'asi'a inoku dediaka, “Dava 'ounai alimo au kanaua 'ani e'ibu?” ");
INSERT INTO nrz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu e'outa ediaka, “Lau oi luva umauna a'oumui, oi boma abiveni nuamui sia bemalalo to'ato'a koanai, Sia suke auna sibona kele'enai mo epupulu, ia lolo oi boma'oua, ‘Da'a 'atuai eno uku,’ inoku kanaua vaka bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dava boutai 'eva meamea ai oi bonoinoivaita inoku maiemui abiveni koanai 'ani oi boabita.” ");
INSERT INTO nrz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu mune'e Lo'e Kabukabunai eda'adodo evaikabasi laloanai, kabukabu kauta namata mai Iuda eta kau namata deasi kevana delavuaia dediaka, “Siavu davanai vinaula katania ovavai, maivaka dai siavu evenimu?” ");
INSERT INTO nrz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu eta luva evamuea ediaka, “Lau vaka oi lavuai ka'onamo bavenimui, e'u lavuai oi bovamuea koanai lau siavu davanai vinaula katania avavai davana 'eva ba'oumui. ");
INSERT INTO nrz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioane ena vaidi'u kabukabu siavuna 'eva a'ia'i easi? Vutuvutuai easi 'o kau etai easi?” Ia sibota viloatai deluvaluva dediaka, “Ekadiaka, ‘Vutuvutuai easi.’ ia belavuaita bediaka, ‘Dava 'ounai sia oi oabia dae?’ ");
INSERT INTO nrz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Beia Ekadiaka, ‘Kau etai easi koanai,’ kau katania 'eva kamakauvaita, 'olana ia boutai devamomo'ai Ioane 'eva enolea kauna.” ");
INSERT INTO nrz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kanaua 'ounai ia Iesu ena luva devamuea dediaka, “Lai sia aikabasi.” Inoku Iesu e'outa ediaka, “Lau vaka siavu davanai vinaula katania avavai 'eva sia ba'oumui.” ");
INSERT INTO nrz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Oi dava olalovaia? Kau ka nakuna 'eva lua, inoku eda'a 'aida'aidana kevana e'ouia ediaka, ‘Naku'u e, vali'u melala kanania boda'a e'u vine kulanai bovinaula.’ ");
INSERT INTO nrz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Melo kamana ena luva evamuea ediaka, ‘Sia badada'a.’ Beia muliai elalovai lalovai kave'i inoku eda'a evinaula. ");
INSERT INTO nrz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kamata mune'e eda'a nakuna ivaluana kevana inoku luva vitaitana eluvavaia, inoku melo ediaka, ‘'O, kama'u, badada'a.’ Beia sia eda'a. ");
INSERT INTO nrz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ia laluana viloatai davana kauna 'eva kamata ena ula vinaulana evavaia?” Ia dediaka, “'Aida'aidana kauna.” Iesu ia e'outa ediaka, “Lau oi luva umauna a'oumui, moni visi kauta mai maka si'a 'a'ateta 'eva Dilava ena lovia vanuanai beda'adodo makava vakaia oi. ");
INSERT INTO nrz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","'Olana vaidi'u kabukabu kauna Ioane easi kele'emui inoku komolo dalana evaikamui, beia oi sia ovamomo'aia ia moni visi kauta mai maka si'a 'a'ateta 'eva devamomo'aia. Oi vaka koakoa kanaua oi oikaia, beia sia oi olalo 'udai mai sia oi ovamomo'aia.” ");
INSERT INTO nrz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kaiamui ovala luva ivavitaitana ka kanania. Kano kauna ka ena vine kulana evavaia, alana ekoia kaiukaiu, vine vuata bekali mukamuka 'ulina eoia mai vi'ima lumana edauia. Kula 'eva vinaula kauta vaida eva'imata, beia ia 'eva ekalima eda'a 'abu edeanai. ");
INSERT INTO nrz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vine vuana iabina melalana ekevai koanai, kula 'ula kauna eko'isi ena da'alabi kauta vaida esinita vuata iabita deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kula de'imaia kauta deta'u da'alabi kauta deabi 'inita ka deaku si'ala ka deaku bala ka 'eva bika'ai deakuia. ");
INSERT INTO nrz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kula 'uala kauna mune'e da'alabi kauta vaida vaka esinita deda'a, makava 'eva vida mo vali'u 'eva doutamo deda'a, beia koa vitaitanamo ia kevatai devavaia. ");
INSERT INTO nrz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","To'ona umaunai 'eva kula 'uala kauna nakuna esinia eda'a kele'etai 'eva ediaka, ‘Lau naku'u 'ounai 'olana 'ani beaku.’ ");
INSERT INTO nrz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kula de'imaia kauta kula 'uala kauna nakuna deikaia koanai sibota deluvaluva dediaka, ‘Be'olavai kauna kanania. Omai kakubala, inoku kula 'eva ita eta be'ao.’ ");
INSERT INTO nrz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Inoku ua'i deabia kula laloanai dedo'oia devuaia deda'a deitoia asi maku mulinai deakubala. ");
INSERT INTO nrz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Inoku oi olalovaia, kula 'uala kauna be'asi koanai kula de'imala kauta kevatai dava bevavaia?” ");
INSERT INTO nrz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ia ena luva devamuea dediaka, “'Ola kauna betata'u kula de'imaia kauta si'avata vaika boutai beakubata, ia kula 'eva kula 'ima kauta edeata bevenita be'imala, vine vuata be'abi melalanai ia ena vaka be'abi beda'a bevenia.” ");
INSERT INTO nrz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu ia e'outa ediaka, “Oi puka kabukabuna sia oi ovakua kovo, una? Kanania deleleia koma, ‘luma vavai kauta devavaia si'asi'a bika'ana 'eva 'ani bika'a namana umaunai eao. Kanania 'eva Lovia namana evavaia davana, ekaikala 'eva 'ani eta tabulovo!’ ");
INSERT INTO nrz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kanaua 'ounai lau oi a'oumui, Dilava ena lovia vanuana kevamuiai beabia tau, vuavua evapuluta iduvuna kauta bevenita. ");
INSERT INTO nrz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kau ka be'eko bika'a kanania akanai 'eva kauanina be'alama, beia bika'a be'eko kau ka akanai kauna 'eva bemukamuka apuloloai be'ao.” ");
INSERT INTO nrz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kabukabu kauta namata mai Palisea kauta Iesu ena luva ivavitaitana kanaua eluvavaia 'uluna de'ika koanai deikabasi ia lovata eakuia. ");
INSERT INTO nrz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ia deula beabia belioa, beia kau mato makauta demakau 'olana kau delalovaia Iesu 'eva enolea kauna ka. ");
INSERT INTO nrz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu mune'e luva ivavitaitana e'outa 'udai ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dilava ena lovia vanuana 'eva itani lovia kauna ka nakuna ena kamoane naduna evavaia boina. ");
INSERT INTO nrz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ia ena da'alabi kauta esinita deveau veau eula venita kauta de'outa, beia eula venita kauta deba'oa sia deasi. ");
INSERT INTO nrz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Inoku ia mune'e ena da'alabi kauta edeata vaida esinita ediaka, ‘Aveauta kauta oi bo'outa 'udai bodiaka, E'u bolomakau mai e'u sisi nama'ita akuta 'ani deivata mukamuka dava boutai 'ani de'olu, kamoane naduna oi bo'asi.’ ");
INSERT INTO nrz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Beia eveauta kauta kataua 'eva ia lovana sia deakuia deda'a mulili, ka eda'a ena loba ka eda'a ena vinaula 'abuna. ");
INSERT INTO nrz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kalina 'eva da'alabi kauta deabi 'inita de'odita inoku deakubata. ");
INSERT INTO nrz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lovia kauna ebadu si'asi'a, inoku eko'isi ena kuali kauta esinita, akuaku kauta kataua deakubata eta vanua vaka detouia. ");
INSERT INTO nrz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Inoku ia ena da'alabi kauta e'outa ediaka, ‘Kamoane ianina 'ani e'olu, beia aveauta kauta be'asi 'eva sia bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oda'a vanua bo'adanai daidai oi bodavalita kauta oi boveauta be'asi kamoane naduna kanania'i.’ ");
INSERT INTO nrz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kanaua 'ounai da'alabi kauta deda'a vanua bo'adanai dedavalita kauta nama'ina kauta mai si'avana kauta boutai devuata deasi, da'a'au kauta kamoane lumana devavonua 'au. ");
INSERT INTO nrz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Beia lovia kauna eda'a da'a'au kauta eikata koanai kau ka eikaia une kamoane naduna tubu'ana sia evadodoa. ");
INSERT INTO nrz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Elavuaia ediaka, ‘E'u kau e! Kamoane naduna tubu'ana sia ka ovadodoa ia aboina odododo?’ Kau kanaua beluluva 'eva sia edaia. ");
INSERT INTO nrz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lovia kauna ena da'alabi kauta e'outa ediaka, ‘Aena imana oliota mulimuli vabulanai oi bokapoa asi, ua'i bekakani mai 'asi'asina beala'o'i ala'o'i.’” ");
INSERT INTO nrz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesu ena luva to'onai ediaka, “Dounamo e'aeta beia vida mo edilata.” ");
INSERT INTO nrz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Palisea kauta dedo'u lova deaku aboina Iesu ena luvai bemavaviua. ");
INSERT INTO nrz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eta kau vaida mai 'Eloda mulinai deda'a kauta ita desinita deda'a Iesu kevana de'ouia dediaka, “Vaikabasi kaumu e, lai aikabasi oni 'eva luva momo'ai kaumu, Dilava ena dala umauna ovaikabasi vaita maivaka kau daitai sia odadai 'olana ia kau aboita 'eva lovata sia o'aku. ");
INSERT INTO nrz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kanaua 'ounai emu lalovai dava 'eva vaikabasimai, moni devisia davana Kaisala bevenia 'eva ekomolo 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Eta lalovai si'avana vaika kanaua Iesu 'ani eikabasia 'ounai ediaka, “Oi dede kaumui, dava 'ounai oi ovakovo'u oi bovaviu'u oko? ");
INSERT INTO nrz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi oi oveveni monina ka ovaika'u.” Inoku siliva monina ka deabia deasi devenia. ");
INSERT INTO nrz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iesu ia elavuaita ediaka, “Kanania 'eva dai va'ava'ana maivaka dai vana?” ");
INSERT INTO nrz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ia dediaka, “Kaisala ena.” Inoku Iesu ia e'outa ediaka, “Kaisala ena Kaisala oi bovenia, Dilava ena Dilava oi bovenia.” ");
INSERT INTO nrz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Luva kanania 'uluna de'ika koanai detabulovo si'asi'a inoku devikania deda'a. ");
INSERT INTO nrz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Melala ka'onamo kanaua'i Sadukea kauta deasi Iesu kevana, ia 'eva bai ko'isi 'udai sia devamomo'aia kauta, Iesu delavuaia, ");
INSERT INTO nrz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","dediaka, “Vaikabasi kaumu e, Mose kanania e'oumai koma. Kau ka ekamoane beia nakuna sia ka evapulua eba koanai bo'akalana betata'u obu kanaua beadavala melo ka bevapulua bo'akalana eba kauna nakunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vali'u a'a kadi kauta boutai kalakoi ka viloamaiai demimia. 'Aida'aidana ekamoane, sia melo ka evapulua laloanai eba inoku obu bo'akalana ivaluana kele'enai evikania, inoku eadavala. ");
INSERT INTO nrz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mune'e bo'akalana ivaluana vaka nakuna asi'i eba, dala vitaitanai mo bo'akalana ivakoina kele'enai eda'amo bo'akalana ivakalakoi kana enai epua. ");
INSERT INTO nrz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","To'ona umaunai ateate vaka eba. ");
INSERT INTO nrz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vali'u ko'isi 'udai melalanai ateate kanaua 'eva dai adanai be'ao, 'olana kauta kalakoi kana ateate kanaua deadavala?” ");
INSERT INTO nrz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu eta luva evamuea ediaka, “Oi 'ani ova'eva 'olana Puka kabukabunai delele luvata mai Dilava ena siavu sia oi oikabasita 'ounai. ");
INSERT INTO nrz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ko'isi 'udai ai kau 'eva sia bekamoane. Ia 'eva vutuvutu aneluta boitai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ba kauta beko'isi 'udai luvana Dilava e'oumui 'eva sia oi ovakua, una? Ia ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Lau 'eva Abela'amo ena Dilava, Isa'ako ena Dilava, Iakobo ena Dilava’. Ia 'eva sia ba kauta eta Dilava, ia 'eva mauli kauta eta Dilava.” ");
INSERT INTO nrz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kau mato luva kanania deika koanai ia ena vaikabasi luvanai detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iesu Sadukea kauta e'outa inoku lele devunu vaika valina Palisea kauta deika koanai ia vaka dedo'u. ");
INSERT INTO nrz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Banota ka talavatu kauna Iesu ekovoia elavuaia ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Vaikabasi kaumu e, talavatu luvana davana 'eva nama vaikana?” ");
INSERT INTO nrz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu ediaka, “Lovia namana emu Dilava bolalo'au venia mainuamu bounai mai idumemu bounai maiemu lalovai bounai ita. ");
INSERT INTO nrz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kanania 'eva talavatu luvana namana maivaka lava'ana'ina. ");
INSERT INTO nrz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Talavatu luvana namana ivaluana 'eva kanania, kevamu kauna bolalo'au venia sibomu olalo'au venimu boina. ");
INSERT INTO nrz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Talavatu luvata boutai mai enolea luvata boutai 'eva talavatu katania lua akatai delava 'au.” ");
INSERT INTO nrz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Palisea kauta dedodo'u mo laloanai Iesu ia elavuaita ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Oi 'eva Keliso a oi olalovaia koma? Maivaka ia 'eva dai nakuna?” Ia de'ouia dediaka, “Davida nakuna.” ");
INSERT INTO nrz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Inoku Iesu elavuaita ediaka, “Dava 'ounai Idume Kabukabuna Davida nuana evavonu 'eva ia Keliso e'aeia Lovia namana? 'Olana Davida ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Lovia namana 'eva e'u Lovia e'ouia ediaka, “Idiba'u avekenai bomimia beda'amo emu 'ou kauta aemu palapalata venutai bane'eta divo.” ");
INSERT INTO nrz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davida Keliso e'aeia e'u Lovia koanai, a boina Keliso 'eva Davida nakunai be'ao?” ");
INSERT INTO nrz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kau ka Iesu ena luva bevamuea 'eva sia edaia, maivaka melala kanaua'i sia kau ka eula lavuai ka Iesu belavuaia. ");
INSERT INTO nrz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Inoku Iesu eta'u kau mato mai ia ibanona kauta e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Talavatu 'ola kauta mai Palisea kauta 'eva Mose ena mia'au davanai demia'au kau de'ola vaita. ");
INSERT INTO nrz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kanaua 'ounai leleta oi bo'ika, de'oumui vinaulata boutai oi bovavai, beia devavai koakoata 'eva sia oi bovavai, 'olana ia deilolovai vinaulata 'eva sia devavaita. ");
INSERT INTO nrz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eveeveai mekau namata dedo'o 'au inoku kau voutai dene'eta 'au, beia ia sibota 'eva sia de'ula imata li'uli'una kai beabia isi beduluta. ");
INSERT INTO nrz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Eta dava devavai boutai 'eva kau beikata davata, puka kabukabuna luvata deleleta eta 'ola davatai meamea laloanai ba'utai dedo'o 'au 'eva devanamata maivaka eta meamea tubu'ata valota 'eva lakavaikata. ");
INSERT INTO nrz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nadu 'abutai 'eva mia'au davata nama'ita ulata de'ula, maivaka lo'e laloatai mia'au davata mediata umauta deula veni. ");
INSERT INTO nrz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eta ula 'eva tavatava 'abutai kau betata'u bevanama'inata mai 'olata be'aku mai bediaka ia 'eva vaikabasi kauta. ");
INSERT INTO nrz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Beia oi 'eva kau sia be'aemui vaikabasi kaumui, 'olana oi emui vaikabasi kauna 'eva ka'onamo maivaka oi boumuiai 'eva a'a mai kadi. ");
INSERT INTO nrz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kanobatai sia kau ka oi bo'aea kamamui, 'olana oi kamamui 'eva ka'onamo vutuvutuai emimia. ");
INSERT INTO nrz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Maivaka sia bediaka, oi 'eva 'ola kaumui, 'olana oi emui 'ola kauna 'eva ka'onamo, Keliso. ");
INSERT INTO nrz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Viloamuiai kau ka namana be'ao kauna kanaua 'eva oi emui da'ala abi kaunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kau ka sibona evanamala kauna 'eva Dilava betata'u ia bevakikia, ia sibona evakikia kauna Dilava betata'u ia bevanamala.” ");
INSERT INTO nrz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Talavatu 'ola kaumui mai Palisea kaumui oi dede kaumui, kevamuiai besi'avana vaika, Dilava ena lovia vanuana nutualana kau vailatai oi o'alavua, oi sibomui sia oi odododo maivaka kau de'ula bedododo kauta oi o'alavuta. ");
INSERT INTO nrz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Talavatu 'ola kaumui mai Palisea kaumui, dede kaumui, kevamuiai besi'avana vaika, obu eta luma oi ovadoeta, emui meamea oiova laka'ina inoku kau oiova akuleata. Kanaua 'ounai mekau namana oi boabia. ");
INSERT INTO nrz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Talavatu 'ola kaumui mai Palisea kaumui oi dede kaumui, kevamuiai besi'avana vaika, kanobata itoinai oi oda'aia kau ibanomui kautai oi ovaaota, inoku kanaua oi ovavaia 'eva kau ena si'avana melala lua oi ovanamala ia beda'a 'alova sia ebo'o kovo 'abuna oi boimui. ");
INSERT INTO nrz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Maka 'ede ivada'ata kaumui, kevamuiai besi'avana vaika, oi odiaka kau ka lo'e kabukabuna vanai beluva 'ana'i 'eva lovana sia oi boakua, beia kolo lo'e kabukabuna laloanai davana vanai beluva 'ana'i 'eva oi boabi 'inia. ");
INSERT INTO nrz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oi obo'o maivaka makamui de'ede, davana 'eva namana? Kolo 'o lo'e kabukabuna kolo evakabukabua davana? ");
INSERT INTO nrz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mai oi odiaka, kau ka vala kabukabuna vanai beluva 'ana'i 'eva lovana sia oi boakua, beia ainama davana vala kabukabuna akanai vanai beluva 'ana'i 'eva oi boabi 'inia. ");
INSERT INTO nrz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Oi a o'ede koma, davana 'eva namana? Ainama davana vala kabukabuna akanai 'o vala kabukabuna ainama davana evakabukabua davana? ");
INSERT INTO nrz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kanaua 'ounai vala kabukabuna vanai eluva 'ana'i kauna 'eva vala kabukabuna mai akanai demimia davata boutai vatai eluva 'ana'i. ");
INSERT INTO nrz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Maivaka lo'e kabukabuna vanai eluva 'ana'i kauna 'eva lo'e kabukabuna mai laloanai emimia kauna vanai eluva 'ana'i. ");
INSERT INTO nrz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Maivaka vutuvutu vanai eluva 'ana'i kauna 'eva Dilava ena mia'au davana mai emia'au kauna vanai eluva 'ana'i. ");
INSERT INTO nrz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Talavatu 'ola kaumui mai Palisea kaumui oi dede kaumui, kevamuiai besi'avana vaika, loba ianita iani devadia'a davata 'eva oi ova'oukata ka'o ka'o oi oveveni Lovia namana ena valalo ai, beia talavatu vinaulata namata, komolo, vilalo mai abiveni oi obolabolata, inoku katania oi bomavavai 'eva bemanama'ina, kataua vaka sia oi bomabolabolata. ");
INSERT INTO nrz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Maka 'ede ivada'ata kaumui, diudiu vaeavaea ai oi o'adoa isi ia sisi vana kamela 'eva oi odonoa. ");
INSERT INTO nrz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Talavatu 'ola kaumui mai Palisea kaumui oi dede kaumui, kevamuiai besi'avana vaika, 'ou mai nau mulita oi odeinita beia nuata 'eva vinao mai idonoai oi oabi davatai devonu. ");
INSERT INTO nrz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Palisea kaumui makamui de'ede, 'ou mai nau nuata odeinita makava inoku mulita vaka 'ani bemakamaka. ");
INSERT INTO nrz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Talavatu 'ola kaumui mai Palisea kaumui oi dede kaumui, kevamuiai besi'avana vaika, oi 'eva mitava deva'ideva'ita boita, mulita 'eva demakamaka beia laloata 'eva ba kauta kuliata mai pedata boutai ai devonu. ");
INSERT INTO nrz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dala vitaitanai kau oi kauanimui de'ika 'eva komolo kaumui boina, beia nuamui 'eva dede mai si'avanai devonu. ");
INSERT INTO nrz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Talavatu 'ola kaumui mai Palisea kaumui oi dede kaumui, kevamuiai besi'avana vaika, enolea kauta eta mitava oi ovavai kave'i mai komolo kauta eta mitava oi ovavelavelata kave'i. ");
INSERT INTO nrz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Oi odiaka, ‘Kubumai eta melalai lai amapulu koanai enolea kauta deakubata laloanai lai 'eva sia bamaduluta.’ ");
INSERT INTO nrz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kanaua'i 'eva oi sibomui oi o'umuidae, oi 'eva enolea kauta deakubata kauta 'ava'avata. ");
INSERT INTO nrz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kubumui kamamui eta si'avana demakavala davana oi bovaolea kave'i. ");
INSERT INTO nrz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Oi 'eva kau'asi mai kau'asi nakuta kaumui, Dilava e'oumui 'abu oi boda'ala 'abuna 'alova sia ebo'o kovo kanaua enai a oi boveau 'akauma koma? ");
INSERT INTO nrz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Enolea kauta, aoneka kauta mai vaikabasi kauta basinita bevasi kevamui, vaida oi boakubata, vaida au ido'o valaukunai oi bokokota 'au, vaida lo'e laloatai oi bo'odita, maivaka vanua ka ai oi bolo'ota beda'a vanua ka. ");
INSERT INTO nrz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kanaua 'ounai komolo kauta lalata boutai kanobata akanai de'itabu mekauna 'eva oi akamuiai be'ovu, vinaula komolo kauna Abela lalanai bemakavala beda'amo Belekia nakuna Sekalaia, ia 'eva lo'e kabukabuna mai vala kabukabuna viloatai oi oaku bala kauna enai bepupua. ");
INSERT INTO nrz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lau oi luva umauna a'oumui, akuaku katania boutai eta mekau 'eva ulu kanania kauta akatai be'ovu. ");
INSERT INTO nrz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ielusalema e, Ielusalema e, enolea kauta oakubata maivaka Dilava veauneke kauta esinita devasi kevamu kauta bika'ai oakuta, melala vaida a'ula nakumu bavalalota itani 'o'oloko ka vanina venunai nakuna epakakaita boina, beia sia o'ula. ");
INSERT INTO nrz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kanaua 'ounai emu lo'e kabukabuna 'eva bavikania 'avaea maivaka be'aku. ");
INSERT INTO nrz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Lau oni a'oumu, sia boika'u 'udai beda'amo oni bodiaka, “Dilava betata'u Lovia namana vanai easi kauna bevanama'inala!” ");
INSERT INTO nrz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu lo'e kabukabunai ela'asi dalai eda'a laloanai ibanona kauta deda'a ilulao kevana inoku lo'e kabukabuna lumana lovana deaku. ");
INSERT INTO nrz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu ia e'outa ediaka, “Dava katania boutai oi oikata? Lau oi luva umauna a'oumui, bika'a ka bika'a ka akanai sia beno'au bemimia, boutai 'eva be'ekoasi be'ovu.” ");
INSERT INTO nrz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu olive lolonai emia divo laloanai ibanona kauta vunivuniai deda'a kevana delavuaia dediaka, “'Oumai, dava katania aida bepupulu? Emu mue'udai maivaka kanobata to'ona koana 'eva a boina?” ");
INSERT INTO nrz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu eta luva evamuea ediaka, “Oi bo'imamui kave'i, kau ka asi'i emalebamui. ");
INSERT INTO nrz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","'Olana lau vau'ai kau doutamo be'asi beluluva bediaka, ‘Lau 'eva Keliso kanania,’ inoku kau doutamo belebata. ");
INSERT INTO nrz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kuali 'uluta mai valita oi bo'ika koanai nuamui sia bebabata, dava kataua boita bepupulu beia to'ona 'eva vailai. ");
INSERT INTO nrz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kanobata ka betata'u kanobata ka bekualivenia, iduvu ka betata'u iduvu ka bevaiviivia. 'Abu edeata edeatai vikolo bepupulu mai 'abu dounamoai kanokau bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Katania boutai 'eva melo epupulu anaanana makavana boina. ");
INSERT INTO nrz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Inoku oi 'eva bevuamui beda'a beva anaanamui, beakubamui, lau dai'uai kanobata boutai oi bevaiviivimui. ");
INSERT INTO nrz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Melala kanaua'i kau doutamo eta abiveni be'ekoasi kaka sibota venita beveveni kouta bekokou, maivaka bevaiviivita. ");
INSERT INTO nrz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Inoku enolea kauta dedeta doutamo bela'asi kau doutamo belebata. ");
INSERT INTO nrz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Si'avana vinaulana 'eva namana be'ao 'ounai kau doutamo eta lalo'au bebadebade. ");
INSERT INTO nrz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Beia belava 'ini beda'a to'onai kauna 'eva mauli beabia. ");
INSERT INTO nrz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dilava ena lovia vanuana valina nama'ina kanania 'eva kanobata itoina laloanai beilolo vaia, iduvu boutai beikabasi, inoku mulinai kanobata to'ona be'asi. ");
INSERT INTO nrz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kanaua 'ounai kaivakuku si'avana vaika kanaua enolea kauna Daniela luvana eluva davana 'abu kabukabunai belavadivo oi boikala koanai, (vaku vaku kauna emaikabasi.) ");
INSERT INTO nrz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Iudai demimia kauta kataua 'eva beveau lolo beda'ala. ");
INSERT INTO nrz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kau luma 'uvinai kauna 'eva sia be'ovu luma laloanai ena dava be'abi. ");
INSERT INTO nrz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mai kau lobai kauna 'eva sia bemumue ena lumai ena tubu'a iabina bedada'a. ");
INSERT INTO nrz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Melala kataua laloatai 'a'ate maibo'ata mai melo 'oma'omata devabaeta 'a'ateta etai 'eva besi'avana vaika. ");
INSERT INTO nrz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Oi bomeamea Dilava kele'enai, asi'i oi oma veau ovo 'elu melalanai 'o melala kabukabunai. ");
INSERT INTO nrz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","'Olana adedua nama vaikana bepupulu, kanobata emakavala easi mo vali'u kanaua boina sia ka epulu, muliai vaka vitaitana sia ka bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dilava melala kataua sia bemavato'oto'ota koanai sia kau ka bemamauli, beia ia edilata kauta daitai melala kataua 'eva bevato'oto'ota. ");
INSERT INTO nrz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Melala kanaua'i kau ka be'oumui bediaka, ‘Oikaia, Keliso kanania’, 'o ‘Ia kanaua,’ koanai sia oi bovamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","'Olana Keliso dedeta mai enolea dedeta 'eva bela'asi vatabulovo vinaulata mai koa namata bevavai, Dilava edilata kauta vaka belebata bedaia. ");
INSERT INTO nrz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Oi bolalovai 'inia Lau 'ani avaikabasimui makava. ");
INSERT INTO nrz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kanaua 'ounai ia be'oumui bediaka, ‘Keliso ua'i kano'akunai’ koanai sia oi bodada'a, 'o ‘Ia laloai nia’, koanai sia oi bovamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","'Olana Lau Kau Nakuna e'u asi koana 'eva itani vutuvutu daeai e'amalea edada'amo divoai boina. ");
INSERT INTO nrz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ba kauanina a'i e'eno 'abunai, 'e'ekavala vaka ua'i bevaboua. ");
INSERT INTO nrz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Melala kataua adeduata be'ole mulitai komolonai melala bevabula, vuia sia bekakala, visiu vutuvutuai be'ekoasi, mai vutuvutuai siavu davata boutai be'iuvai 'iuvai. ");
INSERT INTO nrz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Inoku Lau Kau Nakuna e'u asi koana 'eva vutuvutuai bela'asi, inoku kanobata kauta boutai 'eva bekakani, Lau Kau Nakuna siavu mai nuavi namana laloanai oli akatai ba'asi beika'u. ");
INSERT INTO nrz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bisi beuvanita 'uluta namata laloanai e'u anelu basinita vutuvutu to'onai beda'a vutuvutu to'ona vanina vani laloatai adilata kauta bevalalota. ");
INSERT INTO nrz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","'Ova auna enai ikabasi oi boabia. Bosi betutua 'au koanai, oi 'ani boikabasi avala 'ani ekevai. ");
INSERT INTO nrz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dala vitaitanai dava katania oi boikata koanai, oi 'ani boikabasi melala 'eva 'ani ekevai lau 'eva 'ani nutuala kele'enai. ");
INSERT INTO nrz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lau oi luva umauna a'oumui, ulu kanania sia bebapalu beda'a mo dava katania boutai bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Vutuvutu mai kanobata 'eva betaule, beia lau e'u luva 'eva sia betaule. ");
INSERT INTO nrz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","E'u asi melalana maivaka melala koana sia kau ka eikabasi, vutuvutu aneluta sia deikabasi Nakuna vaka sia eikabasi, ia Kama'u sibona mo eikabasi. ");
INSERT INTO nrz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa ena melalai boina, lau kau nakuna e'u asi melalana vaka kanaua bekoma. ");
INSERT INTO nrz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Abaka namana asido'omo ela'asi laloanai kau 'eva deaniani, deinuinu mai dekamoane eda'a mo melala kanaua'i Noa aunakoiai edodo. ");
INSERT INTO nrz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sia deikabasi kovo dava bepupulu eda'a mo abaka namana ela'asi, inoku boutai dedono ba. Lau kau nakuna e'u asi melalanai vaka kanaua bekoma. ");
INSERT INTO nrz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Melala kanaua'i kau lua lobai bevinaula, Dilava betata'u ka'onamo beabia isi banona bevikania. ");
INSERT INTO nrz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ateate lua witi iuduna bika'ana be'iloa laloanai, Dilava betata'u ka'onamo beabia isi banona bevikania. ");
INSERT INTO nrz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kanaua 'ounai makamui be'ata 'olana emui Lovia namana ena asi melalana 'eva sia oi oikabasia. ");
INSERT INTO nrz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Beia kanania oi bolalovai 'inia, luma 'uala kauna bemaikabasi melala koana davanai vinao kauna be'asi koanai ia 'ani makana bemaata, inoku ena luma sia bemava'alamaia bemadodo. ");
INSERT INTO nrz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kanaua 'ounai melala boutai oi vaka bova'olu, 'olana lau kau nakuna 'eva melala kanaua'i oi sia oabiva'ai laloanai ba'asi. ");
INSERT INTO nrz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Dai 'eva da'alabi kauna nama'ina mai eidiba ia ena 'ola kauna betata'u bedilala ena luma i'imanai be'ao, da'alabi melota eta iani bevenita aniani melalana umaunai? ");
INSERT INTO nrz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ia vinaula kanaua evavaia laloanai ena 'ola kauna bemumue beikala koanai ia bevanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lau oi luva umauna a'oumui, 'ola kauna betata'u ia bedilala ena dava boutai i'imata kaunai bevaoa. ");
INSERT INTO nrz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Beia da'alabi kauna si'avana vaika 'eva bediaka, ‘E'u 'ola kauna asido'o easi.’ ");
INSERT INTO nrz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Inoku ia betata'u banona da'alabi kauta beakuta maivaka inuinu kauta ita beaniani mai beinuinu ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Melala ka da'alabi kauna kanaua ena 'ola kauna sia elalovaia maivaka melala koana sia eikabasia laloanai ia be'asi. ");
INSERT INTO nrz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Ola kauna betata'u ia beaku si'ala belo'oa la'asi dede kauta ita 'abu ka'onamoai, ua'i ia bekakani mai 'asi'asina beala'oi ala'oi.” ");
INSERT INTO nrz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Melala kanaua'i Dilava ena lovia vanuana 'eva itani vato 'ouka boita, eta lamepa deabi deda'a kamoane makamaka kauna ita bevidavali. ");
INSERT INTO nrz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ima 'eva debo'o ia ima 'eva deidiba. ");
INSERT INTO nrz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Inoku bo'o vavatota eta lamepa deabita, beia kelesini kalita sia vaida deabi. ");
INSERT INTO nrz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Idiba vavatota eta lamepai kelesini delai inoku kelesini kalita deabi. ");
INSERT INTO nrz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kamoane makamaka kauna 'eva sia ali easi, inoku vavato makata demuinai delatolao delatomai inoku denodivo demuinai. ");
INSERT INTO nrz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Malolua umaunai vaoi 'uluna de'ika ediaka, ‘Kamoane makamaka kauna 'ani e'asi, ola'asi ita oi bovidavali.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Inoku vavato boutai deibi deko'isi, eta lamepa devavai kave'i. ");
INSERT INTO nrz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Inoku bo'o vavatota deta'u aoneka vavatota denoita dediaka, ‘Emui kelesini vitalua ovenimai ke emai lamepa 'ani debobo'o.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ia eta luva devamuea dediaka, ‘Asi'i. Oi mai lai ita ekalai 'eva sia bedaia. Nama'ina 'eva oda'a detatava 'abunai emui vitalua otava.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bo'o vavatota deda'a tavatava 'abuna laloanai kamoane makamaka kauna ela'asi, deva'olu vavatota ima sibota deda'a kamoane naduna laloanai dedodo inoku nutuala de'alavua. ");
INSERT INTO nrz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mulinai bo'o vavatota deasi inoku de'ae'ae dediaka, ‘'Ola kaumu e, 'Ola kaumu e, nutuala luvua laibadodo.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Beia ia eta luva evamuea ediaka, ‘Lau oi luva umauna a'oumui, lau oi sia aikabasimui.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kanaua 'ounai makamui be'ata, melalana mai melala koana 'eva sia oi oikabasia. ");
INSERT INTO nrz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Inoku Dilava ena lovia vanuana 'eva kanania boina. Itani kau ka kalima bedada'a 'abu dau'anai boina, ena da'alabi kauta e'aeta, e'outa ena dava boutai be'imata. ");
INSERT INTO nrz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Ola kauna kanaua eta'u ena da'alabi kauta ka ka eta kula'ila vitaitatai kolo monina evenita, ka kolo monina ima evenia, ka kolo monina lua, ka 'eva kolo monina ka'onamo evenia inoku ia kalima eda'a. ");
INSERT INTO nrz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kolo monina ima eabiata kauna 'eva komolonai eda'a vinaulana evavaia inoku akanai kolo monina ima evavai. ");
INSERT INTO nrz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kolo monina lua eabita kauna vaka kanaua ekoma, inoku akanai kolo monina lua evavai. ");
INSERT INTO nrz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Beia kolo monina ka'onamo eabia kauna eda'a 'uli e'uaia inoku 'ola kauna ena moni ekoleia. ");
INSERT INTO nrz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Melala edau'a mulinai da'alabi kauta kataua eta 'ola kauna emue easi ena moni lavuaita elavuai. ");
INSERT INTO nrz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kolo monina ima eabi kauna kolo monina ima akatai ita eabita easi ediaka, ‘'Ola kaumu e, kolo monina ima oveni'u. Inoku ikala, akanai kolo monina ima katania avavaita.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Ola kauna ediaka, ‘Da'alabi kaumu mediamu vinaula komolo kaumu, vinaula ovavai kave'i, dava kikita o'ima kave'i 'ounai vali'u dava namata i'imatai bavaaomu. Mai e'u lalonama laloanai dodo.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kolo monina lua eabi kauna vaka easi ediaka, ‘'Ola kaumu e, kolo monina lua oveniu. Inoku ikala, akanai kolo monina lua katania avavaita.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Ola kauna ediaka, ‘Da'alabi kaumu nama'imu vinaula komolo kaumu, vinaula ovavai kave'i, dava kikita o'imata kave'i 'ounai vali'u dava namata i'imatai bavaaomu. Mai e'u lalonama laloanai dodo.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Beia kolo monina ka'onamo eabia kauna easi ediaka, ‘'Ola kaumu e, lau aikabasi oni 'eva kau pasisimu, kau edeata devadovado 'abutai o'ua'ua mai kau edeata kea dekapo odaoda 'abutai ovalalovalalo. ");
INSERT INTO nrz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kanaua 'ounai lau amakau ada'a emu kolo monina ka'onamo kano laloanai akoleia inoku abia a'asi. Ikala oni emu kolo moni 'abunai mo kanania.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Ola kauna ediaka, ‘Da'alabi kaumu si'avamu vaika maivaka balea kaumu, oni olalovaia lau kau vaida devadovado 'abutai a'ua'ua mai kau dekapo odaoda 'abutai avalalovalalo, una? ");
INSERT INTO nrz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kanaua boina koanai moni i'uleta 'abunai bomane'edivo inoku amue'udai asi koanai akanai kikina ka bemapulu ita bamaabi ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vali'u kele'enai kolo monina ka'onamo 'eva obuku vaia, kolo monina 'ouka eabi kauna ovenia. ");
INSERT INTO nrz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Olana maiena kauna 'eva doutamo bavenia, ena dava bedoutamo vaika, beia etabu kauna 'eva kikina kele'enai emimia davana vaka babuku vaia. ");
INSERT INTO nrz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Da'alabi kauna kanania ena nama'ina asi'i oitoia asi eda'a 'abu vabulanai ua'i bekakani mai 'asi'asina beala'oi ala'oi’. ");
INSERT INTO nrz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Lau kau nakuna mainuavi'u e'u anelu boutai ita lai ba'asi koanai e'u mia'au davana nuavina akanai bamia'au. ");
INSERT INTO nrz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kanobatai iduvu boutai lau vaila'uai bevaboua, inoku lau batata'u kau bava'alamata, mamoe 'ima kauna mamoe mai nani eva'alamata boina. ");
INSERT INTO nrz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Lau batata'u mamoe 'eva idiba'u avekenai bane'etadivo, nani 'eva 'eali'u avekenai bane'etadivo. ");
INSERT INTO nrz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Inoku lau Lovia 'olana batata'u idiba'u avekenai kauta ba'outa badiaka, ‘Kama'u evanama'inamui kaumui, omai kanobata evavaia koanai vutuvutu vanuana kanania eva'olua oi emui oabia avumui ai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","'Olana lau avikolo 'eva oi iani oveni'u ani, vei ba'u aba 'eva oi vei oveni'u ainu. Lau kau edea'u 'eva oi oabi'u dae emui lumai. ");
INSERT INTO nrz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kele'e'u tubua asi'i 'eva oi tubu'a ovavadodo'u. Lau a'olele 'eva oi lau o'ima'u. Lau vabuto'o lumanai 'eva oi oasi oika'u.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Inoku komolo kauta ena luva bevamuea bediaka, ‘Lovia namana e, aida melalanai ovikolo inoku lai avananimu, 'o aida melalanai vei bamu oba inoku vei lai avenimu oinu? ");
INSERT INTO nrz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aida melalanai lai aikamu kau edeana inoku lai abimu dae emai lumai, 'o aida melalanai kele'emuai tubu'a asi'i inoku tubu'a lai avenimu ovadodo? ");
INSERT INTO nrz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aida melalanai o'olele lai a'imamu 'o ovabuto'o inoku lai avasi aikamu?’ ");
INSERT INTO nrz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Inoku lau Lovia 'olana ia ba'outa badiaka, ‘Lau oi luva umauna a'oumui. Bo'akala'u ulaluta katania ka kele'enai kanaua oi ovavaia koma koanai 'eva lau kele'e'uai vaka 'ani kanaua oi ovavaia koma.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Inoku lau Lovia 'olana batata'u 'eali'u avekenai kauta ba'outa badiaka, ‘Dilava evaiviivimui kaumui, kele'e'uai oda'atau oda'a eani keinikeini 'alovana deva'olua diabolo maiena melo ita eta davana kanaua laloanai ododo. ");
INSERT INTO nrz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","'Olana lau vikolo eaku'u 'eva sia oi ovanani'u, maivaka vei ba'u aba 'eva vei sia oi oveni'u ainu. ");
INSERT INTO nrz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Lau kau edea'u 'eva emui lumai sia oabi'u dae, kele'e'uai tubu'a asi'i 'eva tubu'a sia ka oi ovavadodo'u. Lau a'olele 'eva sia oi o'ima'u maivaka vabuto'o lumanai 'eva sia oi oasi oika'u.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ia vaka ena luva bevamuea bediaka, ‘Lovia 'olana e, aida melalanai lai aikamu, vikolo eakumu, 'o vei bamu oba, 'o kau edeamu, 'o tubu'a kele'emuai asi'i, 'o o'olele maivaka vabuto'o lumai, inoku sia lai adulumu?’ ");
INSERT INTO nrz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Inoku lau ia ba'outa badiaka, ‘Lau oi luva umauna a'oumui, bo'akala'u ulaluta katania ka kele'enai kanaua sia oi ovavaia koma 'eva lau vaka kele'e'uai kanaua sia oi ovavaia koma.’ ");
INSERT INTO nrz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Inoku kau kataua 'eva basinita anaana keinikeini 'abuna beda'ala, ia komolo kauta 'eva basinita mauli keinikeini 'abuna beda'ala.” ");
INSERT INTO nrz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Inoku Iesu luva katania boutai eluva vai koa mulinai ibanona kauta e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Oi oikabasi La'au keini naduna 'eva melala luamo vailai. Inoku lau kau nakuna 'eva veni'u beveveni kou bekokou au ido'o valaukunai akanai bekoko'u 'au bababa.” ");
INSERT INTO nrz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Melala kanaua'i kabukabu kauta namata mai Iuda eta kau namata ita kabukabu kauta 'olatai kauna vana Kaiapa ena lumai dedo'u. ");
INSERT INTO nrz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ia vunivuniai eta luva devaka'onamo aboina Iesu beabia beaku bala. ");
INSERT INTO nrz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Beia ia sibota dediaka, “Nadu laloanai sia ekavavaia kau asi'i bemaviala.” ");
INSERT INTO nrz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu Betani ai loki kauna Simona ena lumai emia laloanai, ");
INSERT INTO nrz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ateate ka kavapu maideolona tavana namana bematavala davana eabia easi Iesu aniani 'abunai emia divo 'eva 'olanai esisia. ");
INSERT INTO nrz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ibanona kauta deikaia koanai debadu dediaka, “Dava 'ounai deolo kanania eitoa'au 'avaea? ");
INSERT INTO nrz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Deolo kanania tavana namanai bematavatava vaia inoku monina ta'ovala kauta bemavenita.” ");
INSERT INTO nrz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Beia Iesu eikabasi dava luvana deluva 'ounai e'outa ediaka, “Dava 'ounai ateate nuana oi ovabavunua? Ia 'eva vinaula nama'ina vaika lau e'uai evavaia. ");
INSERT INTO nrz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ta'ovala kauta 'eva melala boutai oi kevamuiai bemimia, beia lau 'eva sia melala boutai kevamuiai bamimia. ");
INSERT INTO nrz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Deolo kanania ia esisia lau kau'uai 'eva ikole'u vinaulana eva'olua vaika. ");
INSERT INTO nrz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lau oi luva umauna a'oumui, kanobata itoinai laloanai vali nama'ina kanania beilolo vaia 'eva ateate vinaula kanania evavaia vinaulana 'eva be'oua ia ilalovainai be'ao.” ");
INSERT INTO nrz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Melala kanaua'i ibanona kauta 'ouka lua (12) banota ka vana Iuda Isakaliote kauna 'eva eda'a kabukabu kauta namata kele'etai, ");
INSERT INTO nrz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","elavuaita ediaka, “Iesu imamuiai baudala koanai dava oi boveni'u?” Inoku siliva monita 'ouka koi (30) devaku devenia. ");
INSERT INTO nrz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Melala kanaua easi laloanai Iuda dala ekavu melala mediana davanai Iesu ia imatai beudala. ");
INSERT INTO nrz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Palaoa 'avaeana naduna melalana lava'ana'inai, ibanona kauta deasi Iesu kevana delavuaia dediaka, “La'au keini naduna ianina a'i lai bava'olua boania?” ");
INSERT INTO nrz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ia eta luva evamuea ediaka, “Oda'a vanuai kau kanaua kele'enai oi bo'oua bodiaka, ‘Emai vaikabasi kauna ediaka, “E'u melala 'ani ekevai, lau mai ibano'u kauta ita emu lumai La'au keini naduna lai bavavaia.’ ");
INSERT INTO nrz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kanaua 'ounai ibanona kauta Iesu e'outa vinaulana vitaitanai devavaia, La'au keini naduna ianina deva'olua. ");
INSERT INTO nrz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Elavilavi koanai Iesu mai ibanona kauta 'ouka lua ita aniani 'abunai demiadivo deaniani. ");
INSERT INTO nrz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Deaniani laloanai ia ediaka, “Lau oi luva umauna a'oumui, oi ka 'eva lau veni'u boveveni mai kou'u bokokou.” ");
INSERT INTO nrz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ibanona kauta devilalo si'asi'a ka ka delavuaia dediaka, “Lovia namana e, olalovaia lau, una?” ");
INSERT INTO nrz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ia ediaka, “Kau kanaua imana mai lau ima'u nau ka'onamoai lai auda ka'ona kauna veni'u beveveni mai kou'u bekokou. ");
INSERT INTO nrz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lau Kau Nakuna 'eva Puka kabukabunai deleleia vitaitanai bababa, beia kau nakuna venina beveveni mai kouna bekokou kauna enai 'eva besi'avana vaika, ia sia bemapulu 'eva bemanama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","E'ouia kauna Iuda ediaka, “Vaikabasi kaumu e, olalovaia lau, una?” Iesu ediaka, “'Ani oluva mo kanana.” ");
INSERT INTO nrz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ia deaniani laloanai Iesu palaoa eabia evanama'inala inoku ekovia, ibanona kauta evenita inoku ediaka, “Oabia oania, kanania 'eva lau kauani'u.” ");
INSERT INTO nrz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Inoku 'ou ka eabia evanama'inala evenita ediaka, “Boumuiai kanania oinuia. ");
INSERT INTO nrz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kanania 'eva lau lala'u, luva 'ana'i lalana kau mato daitai be'itabu si'avana i'ou kaona. ");
INSERT INTO nrz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lau oi a'oumui, vine veina kanania lau sia bainua 'udai beda'a mo Kama'u ena vanuai vine veina makamakana oi ita ekainua ka'ona.” ");
INSERT INTO nrz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kanaua'i masi ka deabia mulinai dela'asi, deda'a Olive lolona. ");
INSERT INTO nrz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Inoku Iesu e'outa ediaka, “Vali'u boni kanania'i emui abiveni be'ekoasi inoku oi bovikani'u, 'olana Puka kabukabunai 'ani ilelena, ‘Lau mamoe i'imana kauna baku bala inoku mamoe 'itona 'eva beveau siusiu.’ ");
INSERT INTO nrz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Beia lau bako'isi 'udai mulinai lau 'eva ba'ana'ia bada'a Kalilea vakaia oi bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petelo eko'isi ediaka, “Ama'i boutai oni bevikanimu inoku beveau ovo, lau 'eva oni sia bavikanimu kovo.” ");
INSERT INTO nrz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu Petelo ena luva evamuea ediaka, “Lau oni luva umauna a'oumu, vali'u boni kanania'i o'oloko asido'omo be'alala laloanai, oni melala koi lau bo'ou'u avuavu. Bodiaka oni lau sia oikabasi'u.” ");
INSERT INTO nrz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petelo mune'e ediaka, “Luvana asi'i, laluana kamaba ka'ona, beia lau 'eva oni sia ba'oumu avuavu.” Inoku ibanona kauta vaka luva ka'onamo kanaua deluvaia. ");
INSERT INTO nrz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu ibanona kauta ita deda'a 'abu vana Ketesemane, inoku e'outa ediaka, “Lau bada'a ua'ia'i bameamea laloanai oi 'eva nia'i oi bomimia.” ");
INSERT INTO nrz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ia Petelo mai Sebedeo nakuna luana evada'ata deda'a. Inoku ia 'eva evilalo vaika mai nuana eanana, ");
INSERT INTO nrz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","inoku e'outa ediaka, “Lau nua'u 'eva eanana vaika itani bamaba. Nia'i oi bomimia makata be'ata inoku ekavi'ima.” ");
INSERT INTO nrz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eda'a ilulao laloanai kanoai epakadivo emeamea ediaka, “Kama'u e, kele'emuai bedaia koanai anaana 'ouna kanania e'uai bomabia ovo. Beia oula venia davana bovavaia, ia sia lau e'u ula bovavaia.” ");
INSERT INTO nrz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Inoku emue 'udai easi ibanona kauta kele'etai 'eva demuinai eikata, ia eta'u Petelo e'ouia ediaka, “Dava 'ounai oi kakoina mai lau melala koana ka'onamo sia kavi'ima? ");
INSERT INTO nrz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Oi bovi'ima oi bomeamea ivakovo laloanai asi'i oi omadodo 'ounai. Idumemui 'eva de'ula beia kauanimui 'eva debadebade.” ");
INSERT INTO nrz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Emue eda'a melala ivaluana emeamea 'udai ediaka, “Kama'u e, anaana 'ouna kanania iabi ovona dalana asi'i koanai banana. Inoku emu ula vinaulana bepupulu.” ");
INSERT INTO nrz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Emue easi koanai demuinai eikata 'udai 'olana makata demuinai vaika. ");
INSERT INTO nrz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kanaua 'ounai evikanita emue melala ivakoina emeamea, luva ka'o ka'o mo kataua eluva 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Inoku emue 'udai easi ibanona kauta kele'etai e'outa ediaka, “Oi omuinai mai lamui oi o'ani do'o mo? Oikaia, melalana 'ani eabia, lau Kau Nakuna 'eva 'ani si'avana kauta imatai beuda'u. ");
INSERT INTO nrz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Oko'isi, kada'a. Oikaia veni'u eveveni kou'u ekokou kauna 'ani e'asi.” ");
INSERT INTO nrz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu eluva do'omo laloanai ibanona kauta 'ouka lua banota ka Iuda ela'asi, kau doutamo ita lepo mai uku deabita deasi. Ia 'eva kabukabu kauta namata mai Iuda eta kau namata desinita kauta. ");
INSERT INTO nrz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Veni mai kou ekou kauna koa ka evaikabasita ediaka, “Baba'ua kauna 'eva kauna mo kanaua oi boabia.” ");
INSERT INTO nrz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iuda komolonai eda'a Iesu kevana ediaka, “Vaikabasi kaumu e, oni onama'ina?” Inoku eba'uia. ");
INSERT INTO nrz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu Iuda ena luva evamuea ediaka, “E'u kau e, oasi vaia vinaulana vavaia.” Inoku deda'a deilulao kau deasi dela'asi Iesu deabi 'inia delioia. ");
INSERT INTO nrz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Inoku Iesu debanoia kauta ka ena lepo evelia asi kabukabu kauta akatai kauna ena da'alabi kauna ka kaiana epaia ovo. ");
INSERT INTO nrz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu ia e'ouia ediaka, “Emu lepo 'abunai 'ulea, 'olana lepoai deviaku kauta boutai lepoai bebaba. ");
INSERT INTO nrz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lau kama'u bamanoia koanai ia komolonai anelu iduvuna 'ouka lua kuali aneluta sinavu boutai kalakoi navui (6,000) bemasinita bemaasi keva'u 'eva sia oi oikabasi, una? ");
INSERT INTO nrz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kanaua bemapulu koma koanai, Puka kabukabunai deleleia lau e'uai bepulu dokadoka davana 'eva a bemomo'ai koma?” ");
INSERT INTO nrz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Melala ka'onamo kanaua'i Iesu eta'u do'u kauta e'outa ediaka, “Lau vinaovinao kau'u 'ounai oi imamui mai lepota mai maiukuta oi o'asi oi boabi'u, una? Melala bounai lau 'eva oi ita lo'e kabukabuna laloanai kamia avaikabasi, beia sia oi oabi'u olio'u. ");
INSERT INTO nrz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Beia enolea kauta eta lelelele bemomo'ai 'ounai katania boutai kanania depulu koma.” Inoku ibanona kauta boutai Iesu devikania deveau 'akauma. ");
INSERT INTO nrz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kau kataua Iesu deabia 'eva devuaia deda'a kabukabu kauta akatai kauna Kaiapa kevana, talavatu 'ola kauta mai Iuda eta kau namata 'eva ua'i deakubou ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Beia Petelo mulitai dau'ai eda'a, deda'amo kabukabu kauta akatai kauna ena ala laloanai deda'adodo. Ia edodo 'abu de'imala kauta ita demia dava bepupulu 'eva beikala. ");
INSERT INTO nrz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kabukabu kauta namata mai talavatu 'ola kauta dede luvata dekavu Iesu va'eva 'abunai bene'eadivo bevabala. ");
INSERT INTO nrz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kau doutamo dela'asi dede luvata enai deluva, sia dava ka dedavalia inoku to'onai 'eva kau lua dela'asi, ");
INSERT INTO nrz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","dediaka, “Kau kanania ediaka Dilava ena lo'e kabukabuna 'eva bevelia'ovu inoku melala koi laloatai bevalavala 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kabukabu kauta akatai kauna eko'isi Iesu elavuaia ediaka, “Mai emu luva ka? Kau katania ivava'evamu luvana deluvala 'eva eta luva tavana bovamuea 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Beia Iesu sia luva ka eluvavaia. Kabukabu kauta akatai kauna e'ouia 'udai ediaka, “Mauli Dilavana vanai alavuaimu luva umauna boluvala. Oni 'eva Keliso Dilava nakuna koanai, luva!” ");
INSERT INTO nrz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu ediaka, “'Ani oluva mo kanana. Boumuiai a'oumui, vali'u melala kanania'i mai vaila eda'ala laloanai lau Kau Nakuna 'eva siavu Dilavana idibanai bamimia mai vutuvutu vanuanai oli akanai ba'asi oi boika'u.” ");
INSERT INTO nrz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Inoku kabukabu kauta akatai kauna sibona ena tubu'a e'idia ediaka, “Ia 'eva Dilava vana evavaia si'asi'a. Dava 'ounai vamomo'ai luvata kakakavu? Vali'u sibomui kaiamuiai Dilava vana evavaia si'asi'a lelena 'ani oi oika. ");
INSERT INTO nrz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Oi dava oi oko?” Kau ena luva devamuea dediaka, “Ia 'eva eva'eva 'ounai bebaba.” ");
INSERT INTO nrz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Inoku Iesu vailana de'anodia mai deakuia, mai vaida depi'aia, ");
INSERT INTO nrz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dediaka, “Oni Keliso, 'oumai dai epi'amu kauna 'oua dae.” ");
INSERT INTO nrz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Boni kanaua'i Petelo 'eva ala laloanai luma vailanai emia, inoku da'alabi vatona ka easi kevana e'ouia ediaka, “Oni vaka Iesu Kalilea kauna obanoia.” ");
INSERT INTO nrz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petelo kau boutai vailatai e'ou avuavu ediaka, “Lau sia aikabasi oni dava luvana oluluva.” ");
INSERT INTO nrz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Inoku Petelo ela'asi eda'a nutuala aunai, ua'i da'alabi vatona edeana ka ia eikaia inoku kau e'outa ediaka, “Kau kanania 'eva Iesu Nasaleta kauna ebanoia.” ");
INSERT INTO nrz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petelo mune'e e'ou avuavu 'udai eluva pasisi ediaka, “Aka kauna eikabasi, lau kau kanaua sia aikabasia.” ");
INSERT INTO nrz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Melala sia edau'a mulinai ua'i delava kauta deda'a Petelo kevana dediaka, “Luva umauna oni vaka banota ka, 'olana oni emu luvaluva 'ulunai lai aikabasi.” ");
INSERT INTO nrz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Inoku ia eluva pasisi ediaka, “Aka kauna eikabasi luva umauna a'oumui. Asi'i koanai Dilava beva anaana'u. Kau kanana lau sia aikabasia.” Komolonai o'oloko e'alala. ");
INSERT INTO nrz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Inoku Petelo Iesu ena luva eluvaia luvana elaloia une, “O'oloko asi do'omo be'alala laloanai oni melala koi bo'ou'u avuavu.” Kanaua'i ela'asi eda'a mulimuliai ekani si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","'Avu'avuni vabulanai kabukabu kauta namata mai Iuda eta kau namata boutai lova deaku luva devaka'onamoa Iesu bevabala. ");
INSERT INTO nrz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Inoku Iesu delioia devada'ala deda'a Kavana kauna Pilato imanai deudaia. ");
INSERT INTO nrz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Beia Iuda veni mai kou ekou kauna Iesu eikaia va'eva ai de'uleia mai bebaba koanai elalo vunu, Siliva monina koi navui eabita eda'a kabukabu kauta namata mai Iuda eta kau namata bevenita, ");
INSERT INTO nrz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ediaka, “Lau 'ani si'avana avavaia, 'olana ena va'eva asi'i kauna venina aveni kouna akou.” beia ena luva devamuea dediaka, “Kanaua 'eva sia lai ia oni sibomu emu mekau.” ");
INSERT INTO nrz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kanaua 'ounai Iuda moni kataua lo'e kabukabuna laloanai ekapota dodo inoku ia ela'asi eda'a sibona edo'o ba. ");
INSERT INTO nrz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kabukabu kauta namata moni deabi isi inoku dediaka, “Kanania 'eva ita eta talavatu, moni kanania lo'e kabukabuna mauanai sia ekaudala 'olana ba tavanai eao.” ");
INSERT INTO nrz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Moni kanaua lovana deaku mulinai 'eva vodu vavai kauna kele'enai kano detavaia, kano kanaua 'eva kau edeata eta mitavai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanaua 'ounai kano vana de'aeia ‘Lala Kanona’ easi mo vali'u. ");
INSERT INTO nrz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ielemia enolea kauna eluvavaia luvana 'eva easi emomo'ai ediaka, ‘Isalaela kauta tava de'ouia ia tavanai be'ao davana Siliva monina koinavui deabia, ");
INSERT INTO nrz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","inoku moni kanaua vodu vavai kauna ena kano detavaia Lovia namana e'ou'u vitaitana.’ ");
INSERT INTO nrz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Melala kanaua'i Iesu Kavana vailanai elavadivo, Kavana kauna eta'u Iesu elavuaia ediaka, “Oni 'eva Iuda kauta eta lovia 'olana, una?” Iesu ia ena luva evamuea ediaka, “'O, 'ani oluvalamo kanana.” ");
INSERT INTO nrz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Beia kabukabu kauta namata mai Iuda eta kau namata vuvua devakoala koanai Iesu sia luva ka eluvaia. ");
INSERT INTO nrz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Inoku Pilato eta'u Iesu e'ouia ediaka, “Luva edeata edeatai vuvua devakoamu 'eva leleta sia o'ika?” ");
INSERT INTO nrz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Beia Iesu sia luva ka eluvaia kovo, 'ounai Kavana kauna etabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","La'au keini naduta melalatai Kavana kauna ena koakoa dainai vabuto'o kauna ka deula venia kauna 'eva bevala'asia 'avaea. ");
INSERT INTO nrz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Melala kanaua'i vabuto'o kauna ka vana Balaba kau boutai deikabasia kave'i kauna vabuto'o lumanai emia. ");
INSERT INTO nrz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kau mato ua'i dedo'u laloanai Pilato elavuaita ediaka, “Oi o'ula dai bavala'asia 'avaea, Balaba 'o Iesu oi o'aea Keliso?” ");
INSERT INTO nrz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","'Olana Pilato eikabasi kave'i Iuda eta kau namata 'eva Iesu demama venia 'ounai imanai deudaia. ");
INSERT INTO nrz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ia lavuai mia'aunai emia laloanai adana luva esinia eda'a kevana, “Kau kanana sia maiena va'eva kevanai sia dava ka bovavaia, 'olana boniai ia anivia 'eva nua'u ebavunu si'asi'a.” ");
INSERT INTO nrz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Beia kabukabu kauta namata mai Iuda eta kau namata kau mato devaasiasita Balaba denoinoi vaia bevala'asia ia Iesu 'eva ba ai bene'eadivo. ");
INSERT INTO nrz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Inoku mune'e Pilato kau mato elavuaita ediaka, “Laluana katania dai oi oula venia kauna bavala'asia?” Ia ena luva devamuea dediaka, “Balaba.” ");
INSERT INTO nrz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ediaka, “Inoku Iesu oi o'aea Keliso kele'enai dava bavavaia?” Boutai dediaka, “Au ido'o valaukuna akanai bokokoa 'au!” ");
INSERT INTO nrz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Beia Pilato elavuaita 'udai ediaka, “Dava 'ounai, va'eva dava evavaia?” Beia ia devaoi 'unu'unu dediaka, “Au ido'o valaukuna akanai bokokoa 'au!” ");
INSERT INTO nrz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato eikabasi ena siavu 'ani asi'i, inoku 'ulu namana 'ani evua. 'Ounai vei eveliamai kau mato vailatai imana edeinita ediaka, “Lau kau kanania ena ba vuona sia bakoala, nia 'eva oi sibomui emui ula.” ");
INSERT INTO nrz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kau boutai dediaka, “Ia ena ba mekauna lai mai nakumai ita lai bakoala.” ");
INSERT INTO nrz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Inoku Pilato Balaba evala'asia eda'a kele'etai, ia Iesu evenita be'odia au ido'o valaukuna akanai bekoko 'au. ");
INSERT INTO nrz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kavana kauna ena kuali kauta Iesu deabia devuaia deda'a Kavamani lumanai, inoku kuali kauta boutai deasi delavaia kaiukaiu. ");
INSERT INTO nrz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ia deta'u Iesu ena tubu'a devadada ovo ia tubu'a 'aolana devavadodoia. ");
INSERT INTO nrz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","'Olanai be'ulea davana 'iniauma devavilia inoku 'olanai dene'eia 'au. Olo ka imana idibanai devaabia, vailanai dekuidula devabo'oa dediaka, “Iuda kauta eta lovia 'olana e, oni 'eva onama'ina?” ");
INSERT INTO nrz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Inoku de'anodia olo debuku vaia, 'olanai deaku 'udai 'udai. ");
INSERT INTO nrz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Devabo'oa mulinai tubu'a 'aolana kanaua devadadala asi, ena tubu'a umauta devavadodoia. Devada'ala au ido'o valaukuna akanai bekokoa 'au. ");
INSERT INTO nrz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kuali kauta Iesu devada'ala laloanai Kulene kauna vana Simona dedavalia devasiasia Iesu ena au ido'o valaukuna bevuala. ");
INSERT INTO nrz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Abu kai dela'asi vana Kolokota. (Anina 'eva ‘'Ola kuliata 'abuna’.) ");
INSERT INTO nrz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ua'i vine veina mulamula vamaina ka ita delai ka'ona Iesu devenia beinua, edemalia kovo mo beia sia einuia. ");
INSERT INTO nrz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kuali kauta Iesu au ido'o valaukuna akanai dekokoia 'au mulinai sibota ena tubu'a punipuniai dekole. ");
INSERT INTO nrz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kanaua mulinai demiadivo makata 'eva ia deika 'inia. ");
INSERT INTO nrz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iesu 'olana akanai ia ivava'evana luvana deleleia 'au dediaka, ‘Nia 'eva Iesu, Iuda Kauta Eta Lovia 'Olana.’ ");
INSERT INTO nrz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Melala kanaua'i vinaovinao kauta lua Iesu ita ka ka eta au idau valaukuta akatai dekokota 'au, ka idibana avekenai mai ka 'ealina avekenai. ");
INSERT INTO nrz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kau ua'i dekeini kauta 'olata deka'eka'e mai vabo'obo'o luvata Iesu de'ouia, ");
INSERT INTO nrz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","dediaka, “Oni odiaka lo'e kabukabuna boakua mukamuka inoku melala koi laloanai bovalavala 'udai kaumu, oni Dilava nakuna koanai sibomu vamaulimu, au ido'o valaukuna akanai ovu mai.” ");
INSERT INTO nrz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kabukabu kauta namata talavatu 'ola kauta mai Iuda eta kau namata vaka devabo'oa dediaka, ");
INSERT INTO nrz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ia kau vaida evamaulita, beia dava 'ounai sibona sia evamaulia? Ia 'eva Isalaela eta lovia 'olana, vali'u au ido'o valaukuna akanai e'ovu emai 'eva ekabivenia. ");
INSERT INTO nrz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ia Dilava eabivenia inoku Dilava ia eulavenia koanai vali'u evamaulia, 'olana ediaka ia 'eva Dilava nakuna.” ");
INSERT INTO nrz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vinaovinao kauta luana au ido'o valaukuna akanai dekokota 'au kauta vaka ia deluva pasisi venia. ");
INSERT INTO nrz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ado'alavuni laloanai vabuto'o namavaikana kanobata itoina e'alavua eda'amo melala elava keini koana koi. ");
INSERT INTO nrz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Melala koana koi laloanai Iesu evaoi ediaka, “Eloi eloi lama sabakatani!” Anina 'eva ‘E'u Dilava e, E'u Dilava e, dava 'ounai 'ani ovikani'u!’ ");
INSERT INTO nrz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kau vaida ua'i delava lelena deika kauta dediaka, “Kau kanania 'eva Elia e'aea.” ");
INSERT INTO nrz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Komolonai banota ka eveau eda'a dapulu ka eabia vine veina vamainai eudaiauku, inoku auai eisia 'au Iesu beinua. ");
INSERT INTO nrz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Beia vaida dediaka, “Vikania, Elia be'asi bevamaulia koanai ekaikala.” ");
INSERT INTO nrz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu evaoi 'unu'unu 'udai mulinai eba. ");
INSERT INTO nrz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Melala kanaua'i lo'e kabukabuna laloanai bo'adai ikekebili tubu'ana kanaua bo'adanai e'idi lua akai e'ovu eda'a mo venuai. Kanokau eko'isi bika'a de'alama. ");
INSERT INTO nrz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mitava 'ulita dela Dilava ena kabukabu kauta doutamo deba kauta demauli deko'isi. ");
INSERT INTO nrz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iesu eko'isi 'udai mulinai eta mitavai dela'asi Ielusalema ai dedadodo inoku kau doutamo etai devaila. ");
INSERT INTO nrz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kuali 'ola kauna ena kuali kauta ita Iesu de'imaia, kanokau eko'isi mai dava depulu davata boutai deikata koanai demakau si'asi'a dediaka, “Luva umauna kau kanania 'eva Dilava nakuna.” ");
INSERT INTO nrz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'A'ate doutamo vaka ua'i dau'ai delava deikaia, Ia 'eva Kalilea ai Iesu mulinai deda'a mai da'alana deabi 'a'ateta. ");
INSERT INTO nrz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Viloatai 'eva Malia Makadala ateatena mai Malia ka Iakobo mai Iosepa sinata mai Sebedeo nakuna laluana sinata. ");
INSERT INTO nrz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lavilavi kanaua'i lavo kauna ka easi vana Iosepa Alimatea kauna ia vaka Iesu debanoia kauna ka. ");
INSERT INTO nrz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ia eda'a Pilato kevana inoku Iesu kauanina enoinoi vaia, Pilato luva eveni 'eva Iesu kauanina Iosepa bevenia. ");
INSERT INTO nrz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inoku Iosepa Iesu kauanina eabia ovo, tubu'a makamakana medianai e'umia. ");
INSERT INTO nrz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ia sibona ena mitava makamakana bika'a abunai e'uaia mitavana laloanai ekoleia, bika'a namana ka eva'ulea eda'a nutuala evaakububua inoku eda'a. ");
INSERT INTO nrz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia Makadala ateatena banona Malia ka ita 'eva ua'i mitava avekenai demia deikaia. ");
INSERT INTO nrz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Elani 'avu'avuni melala kabukabunai kabukabu kauta namata mai Palisea kauta deda'a Pilato kevana, ");
INSERT INTO nrz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","dediaka, “Kau namana e, lai dede kauna kanaua maulinai emia laloanai ena luva eluvavaia luvana lai alalovai 'inia ediaka, ‘Melala ivakoinai bako'isi 'udai.’ ");
INSERT INTO nrz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kanaua 'ounai bo'outa mitava be'imala kave'i beda'a mo melala ivakoinai. 'Olana sia enama'ina, ibanona kauta beda'a Iesu kauanina bevinaoa inoku kau vailatai bediaka ‘Ia 'eva ba kauta viloatai 'ani eko'isi 'udai.’ Dede kanania muliai adeduana besi'avana vaika vakaia 'ana'inai davana.” ");
INSERT INTO nrz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato e'outa ediaka, “'Ima'ima kauta ovuata oda'a, mitava be'imala kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kanaua 'ounai deda'a mitava i'alavuna bika'ana de'alavua kave'i akanai talavatu koana dene'e'iadivo, inoku 'ima'ima kauta ua'i devikanita beikala kao. ");
INSERT INTO nrz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Melala kabukabuna eole mulinai masi melalana lava'ana'iana 'avu'avu vabulanai, Malia Makadala ateatena mai Malia ka ita deda'a mitava beikala. ");
INSERT INTO nrz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Melala kanaua'i kanokau nama vaikana eko'isi laloanai Lovia namana ena anelu ka vutuvutuai e'ovu easi mitava nutualana bika'ana eva'uleatau akanai emia'au. ");
INSERT INTO nrz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ia vailana e'ailala ovo itani e'amalea boina mai ena tubu'a dedeva'i ovo itani oli deva'ina boina. ");
INSERT INTO nrz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mitava de'imaia kauta anelu deikaia koanai demakau si'asi'a de'ululu nuata detaule de'eko kanoai deno itani deba boina. ");
INSERT INTO nrz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Beia anelu 'eva 'a'ate e'outa ediaka, “Sia omakau, lau aikabasi oi Iesu au ido'o valaukuna akanai dekokoia 'au kauna oi okavua. ");
INSERT INTO nrz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia 'eva sia nia'i. Ia 'eva 'ani eko'isi makavanai e'oumui vitaitana. Omai eno 'abuna oikaia. ");
INSERT INTO nrz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Inoku oda'a kaokao ibanona kauta oi bovaikabasita, Ia 'eva ba kauta viloatai 'ani eko'isi 'udai inoku 'ani e'ana'ia eda'a Kalilea, ua'i oi boikala. Luva kanania ba'oumui ako 'ounai asi.” ");
INSERT INTO nrz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kanaua 'ounai 'a'ate mitavai dela'asi molau maimakauta mai mailalonamata deveau deda'a ibanona kauta bevaikabasita. ");
INSERT INTO nrz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dalai deda'a laloanai Iesu ita devidavali. E'outa ediaka, “Mediamui!” Inoku deda'a kevana depakadivo aena deabi 'ini inoku dekukudivo venia. ");
INSERT INTO nrz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Inoku Iesu e'outa ediaka, “Sia omakau, oi boda'a bo'akala'u oi bovaikabasita beda'a Kalilea ua'i beika'u.” ");
INSERT INTO nrz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","'A'ate dalaiai deda'a koanai, kuali kauta mitava de'imaia kauta vaida demue deda'a vanua namanai makatai dava depulu davata boutai kabukabu kauta namata vailatai deluvavaita. ");
INSERT INTO nrz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kabukabu kauta namata 'eva Iuda eta kau namata ita dedo'u deluvaluva eta lalovai devalavala kuali kauta kataua 'eva moni namana ka bevenita, ");
INSERT INTO nrz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","inoku de'outa dediaka, “Oi bodiaka, ‘Boniai lai amuinai tabu laloanai ibanona kauta deasi Iesu kauanina devinaoa.’ ");
INSERT INTO nrz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Vali kanania Kavana kauna be'ika koanai lai ba'oua, oi 'eva kau 'avaeamui, maivaka nuamui sia bebavunu sia dava ka oibolalovaia.” ");
INSERT INTO nrz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kuali kauta moni deabia inoku de'outa vitaitana devavaia. Kanaua 'ounai luva kanania Iuda kauta viloatai deluvaia odaoda melala kanaua'i easi mo vali'u. ");
INSERT INTO nrz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inoku ibanona kauta 'ouka ka deda'a Kalileai Iesu e'outa lolona deda'a venia. ");
INSERT INTO nrz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ibanona kauta ia deikaia koanai dekukudivo venia, beia vaida 'eva nuata delaloto'ato'a. ");
INSERT INTO nrz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu eda'a ilulao kele'etai inoku e'outa ediaka, “Dilava siavu davata boutai vutuvutuai mai kanobatai 'ani eveni'u. ");
INSERT INTO nrz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kanaua 'ounai oi boda'a kanobata boutai kauta ibano'u kautai oi bovaota, Kamana Nakuna mai Idume Kabukabuna vatai oi bovaidi'uta kabukabu, ");
INSERT INTO nrz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","a'oumui luvata boutai oi bovaikabasita vinaulata bevavai. Kaiamui ovala, lau 'eva melala bounai oi kevamuiai beda'a mo kanobata to'ona.” ");
INSERT INTO nrz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dilava Nakuna Iesu Keliso valina nama'ina lava ana'ina 'eva kanania. ");
INSERT INTO nrz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enolea kauna Isaia eleleia ediaka, “Dilava ediaka, ‘ E'u veauneke kauna asinia 'ana'i evavasi, emu dala beva'olua kave'i.’ ");
INSERT INTO nrz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lele ka kano'akunai e'ae'ae ediaka, ‘Lovia namana ena dala ova'olua. Ena da'a dalana ovakomoloa.’” ");
INSERT INTO nrz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kanaua 'ounai Vaidi'u kabukabu kauna Ioane kano'akunai evailaasi, evaidi'u kabukabu mai eilolo ediaka, “Emui si'avanai olalo 'udai, oi boidi'u kabukabu, Dilava emui si'avana be'ou kao.” ");
INSERT INTO nrz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kau doutamo Iudea kanonai mai Ielusalemai deda'a Vaidi'u kabukabu kauna Ioane lelena deika, eta si'avana de'ou dae, mai Iolidana nutunai evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioane evadodoa tubu'ana 'eva Kamela vuina. Kukuana 'apana 'eva Bolomakau avana, ena iani 'eva 'oasi'o mai metunu veina. ");
INSERT INTO nrz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kau vailatai kanania eilolo koma. “Kau ka lau muli'uai be'asi kauna 'eva lau e'u siavu bekeinia. Lau 'eva sia anama'ina vaika batoludivo ena tamaka valonata baluluvu. ");
INSERT INTO nrz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Lau 'eva oi veiai avaidi'umui kabukabu, beia ia 'eva Idume Kabukabunai bevaidi'umui kabukabu.” ");
INSERT INTO nrz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Melala kanaua'i Iesu 'eva Kalilea kanona ka Nasaletai easi. Ioane eta'u evaidi'uia kabukabu Iolidana nutunai. ");
INSERT INTO nrz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesu veiai ele'au koanai, vutuvutu eviluvu eikaia mai Idume Kabukabuna e'ovu easi ia akanai ikana vitaitana boiomalo boina. ");
INSERT INTO nrz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Maivaka lele ka vutuvutuai easi, ediaka, “Oni 'eva Lau Naku'u, e'u lalo'au. Lau oni alalonama venimu vaika.” ");
INSERT INTO nrz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Komolonai Idume Kabukabuna Iesu evada'ala deda'a kano'akunai. ");
INSERT INTO nrz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iesu ua'i emia melala vaninavui, Satani ia evakovoa, 'asi davata ita demia, beia anelu deasi inoku deduluia. ");
INSERT INTO nrz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Vaidi'u kabukabu kauna Ioane vabuto'o lumanai de'alavua mulinai, Iesu 'eva eda'a Kalileaai Dilava valina nama'ina eilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ediaka, “Luva 'ana'i bonina 'ani ele'au, Dilava ena lovia vanuana 'ani ekevai, emui si'avanai olalo 'udai, Vali Nama'ina ovamomo'aia.” ");
INSERT INTO nrz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu Kalilea 'ovu nabuanai eda'a laloanai, Simona mai kadina Andelea ita eikata, vuo 'ovuai denaia, 'olana laluana 'eva va'eka kauta. ");
INSERT INTO nrz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu e'outa ediaka, “Muli'uai omai, lau batata'u oi kau iva'ekata bavaikabasimui.” ");
INSERT INTO nrz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Alimo eta vuo devikanita mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ia eda'a ilulao Sebedaio nakuna Iakobo mai kadina Ioane ita eikata asiai eta vuo delaume. ");
INSERT INTO nrz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Inoku Iesu komolonai laluana e'aeta, kamata Sebedaio mai vinaula melota asiai devikanita ia mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu mai ibanona kauta ita deda'a Kapelanauma vanuanai. Melala Kabukabunai Iesu 'eva Iuda kauta eta lo'e laloanai eda'adodo inoku evaikabasi. ");
INSERT INTO nrz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kau kataua ena vaikabasi 'uluta deika koanai detabulovo si'asi'a, 'olana ena vaikabasi 'eva maisiavuta, mai sia talavatu de'olavaia kauta boita. ");
INSERT INTO nrz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kau ka nuanai ka'uba si'avana emia kauna edodo lo'e laloanai inoku evaoi ediaka, ");
INSERT INTO nrz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu Nasaleta kaumu e! O'ula dava kevamaiai? Oni lai bovasi'avanamai 'ounai oasi, una? Aikabasi oni 'eva dai, oni 'eva Kabukabu kaumu Dilava edilamu.” ");
INSERT INTO nrz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu ka'uba si'avana e'ovenia ediaka, “Lele vunu, kau kanana nuanai la'asi!” ");
INSERT INTO nrz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka'uba si'avana kau kanaua eva'ululu si'ala, evilavila si'asi'a inoku kau kanaua nuanai ela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kau ua'i boutai detabulovo si'asi'a, ka ka sibota devilavuai viveni dediaka, “Kanania 'eva dava? Vaikabasimo makamakata vaida mai siavuta. Ka'uba si'avata vaika e'outa koanai lelena de'ika.” ");
INSERT INTO nrz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanaua 'ounai Iesu valina alimo Kalilea kanona itoina laloanai dekavaia odaoda. ");
INSERT INTO nrz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesu ibanona kauta Ioane mai Iakobo ita lo'e devikania komolotai deda'a Simona mai Andelea eta lumai. ");
INSERT INTO nrz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona lavana ateatena 'eva e'olele, kauna desiavu ena lumai eno. Iesu easi koanai, ena 'olele luvana de'ouia. ");
INSERT INTO nrz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu eda'a ia kevana, imanai eabi eduluia evelia kole. Kauna siavuta deole, ateate eko'isi inoku eta iani evavai. ");
INSERT INTO nrz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Melala eulu lavilavinai 'olele kauta mai kau nuatai ka'uba si'avata vaika demia kauta devada'ata deda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vanua kauta boutai deasi luma kanaua vailanai dedo'u. ");
INSERT INTO nrz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","'Olele edeata edeata kauta doutamo Iesu evanama'inata, maivaka ka'uba si'avata vaika doutamo elo'ota asi, beia ka'uba si'avata vaika 'eva Iesu deikabasia 'ounai e'alavuta sia beluluva. ");
INSERT INTO nrz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","'Avu'avuni vabulanai, sia elani kave'i koanai Iesu eko'isi luma evikania, eda'a 'abu 'akuna kai, ua'i emeamea. ");
INSERT INTO nrz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Beia Simona banona ita dela'asi ikavuna deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Inoku dedavalia koanai de'ouia dediaka, “Kau boutai 'eva oni dekavumu.” ");
INSERT INTO nrz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Beia Iesu eta luva evamuea ediaka, “Ita kada'a vanua kevatai kataua, laloatai vaka bailolo, vinaula kanania dainai asi.” ");
INSERT INTO nrz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iesu 'eva Kalilea laloana itoinai eda'aia, Iuda kauta eta lo'e laloatai eilolo mai ka'uba si'avata vaika kau nuatai kataua elo'olo'ota asi. ");
INSERT INTO nrz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Loki kauna ka easi Iesu vailanai ekuidula, enoia ediaka, “Bema bo'ula koanai, bomavanama'ina'u.” ");
INSERT INTO nrz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu eikaia elaloia, 'ounai imana eisia lao eabia kovo, e'ouia ediaka, “'O. Lau a'ula bonama'ina. Kaumu enama'ina!” ");
INSERT INTO nrz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Alimo loki kau kanaua evikania, kauna enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu kau kanaua esinia koanai e'ouia kao ediaka, ");
INSERT INTO nrz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Lele'u o'ika, kau ka vailanai sia boluva kovo. Komolomuai boda'a Kabukabu kauna kevanai, kaumu beikala. Mose ena talavatu vitaitana, onama'ina 'ounai ainama Dilava bovenia oni emu nama'ina ivamomo'aina.” ");
INSERT INTO nrz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Beia kau kanaua eda'a 'abu bounai ena nama'ina valina ekavaia odaoda. Ena valikava kanaua 'ounai Iesu 'eva vanua laloatai sia eda'adodo. Ia 'abu 'avaeatai mo emia, 'abu edeata edeata kauta 'eva deda'a kevana. ");
INSERT INTO nrz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Melala vaida deole mulitai Iesu mune'e emue eda'a Kapelanauma vanuana, kau luvana deika ia 'eva lumai. ");
INSERT INTO nrz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kau doutamo vaika deasi dedo'u luma evonu vaika, mia 'abuta 'eva asi'i vaika eda'a mo nutuala aunai eole Iesu eilolo lelena deika. ");
INSERT INTO nrz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kau vani 'eko kauna ka devuaia deasi. ");
INSERT INTO nrz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","'Olana kau dounamo vaika 'ounai, kau kanaua bevuala beda'a Iesu kevanai 'eva sia edaia. Kanaua 'ounai Iesu 'olana akanai luma 'uvinai 'ile ka devavaia. 'Eko kauna mai 'etana ua'i deva'ovua eda'a Iesu vailanai. ");
INSERT INTO nrz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu ia eta abiveni nama vaikana eikaia 'ounai, 'eko kauna e'ouia ediaka, “Naku'u e! Emu si'avana 'ani i'ou kaota.” ");
INSERT INTO nrz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Talavatu de'olavaia kauta vaida ua'i demia, sibota delalovai lalovai. ");
INSERT INTO nrz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Dava 'ounai kau kanania kanaua eluva koma? Ia Dilava 'olana sia e'aku. Dilava mo sibona si'avana be'ou kao.” ");
INSERT INTO nrz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu alimo nuata lalovaita eikabasi, 'ounai e'outa, ediaka, “Dava 'ounai kanania oi olalovai koma? ");
INSERT INTO nrz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","'Eko kauna i'ounai, davana 'eva eveavea, ‘Emu si'avana 'ani i'oukaota,’ o, ‘Ko'isi emu 'eta abia da'a’? ");
INSERT INTO nrz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Beia lau a'ula oi boikabasi, Kau nakuna 'eva mai siavuna kanobatai si'avana be'ou kaota.” Inoku 'eko kauna e'ouia ediaka, ");
INSERT INTO nrz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Lau oni a'oumu. Ko'isi, emu 'eta abia isi, da'a emu luma!” ");
INSERT INTO nrz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kau vailatai eko'isi, ena 'eta elo'uia eabiaisi eda'a. Boutai detabulovo si'asi'a, Dilava devanama'inala dediaka, “Ita koa kanania boina ka sia kaikaia kovo.” ");
INSERT INTO nrz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu mune'e emue eda'a Kalilea 'ovu nabuanai. Kau doutamo vaika deasi kevana inoku evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ia eda'a ilulao koanai, takisi abi kauna Levi Alepeo ena vinaula 'abunai emia divo eikaia, Iesu ia e'ouia ediaka, “Muli'uai mai!” Levi komolonai mo eko'isi mulinai eda'a. ");
INSERT INTO nrz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mulinai ia 'eva Levi ena lumai deaniani, takisi abi kauta mai si'avana kauta doutamo Iesu mai ibanona kauta ita deaniani, 'olana kau douta Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Talavatu de'olavaia kauta Palisea iduvunai deasi Iesu si'avana kauta mai takisi abi kauta ita deaniani ka'ona deikata koanai, ibanona kauta delavuaita dediaka, “Dava 'ounai Iesu takisi abi kauta mai si'avana kauta ita deaniani ka'ona?” ");
INSERT INTO nrz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu leleta eika koanai, eta luva evamuea ediaka, “Kau sia de'olele kauta 'eva mulamula veni kauna sia deula venia, beia 'olele kauta mo deula venia. Lau komolo kauta daitai sia asi, ia lau 'eva si'avana kauta daitai asi.” ");
INSERT INTO nrz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vaidi'u kabukabu kauna Ioane ibanona kauta mai Palisea kauta 'eva delove. Kanaua 'ounai kau vaida deasi Iesu delavuaia dediaka, “Vaidi'u kabukabu kauna Ioane ibanona kauta mai Palisea kauta ibanota kauta 'eva delolove, ia oni ibanomu kauta dava 'ounai sia delolove?” ");
INSERT INTO nrz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu eta luva evamuea, ediaka, “Olalovai kave'i! Kamoane makamaka kauna ena ula kauta lalonama kanaua laloanai koanai a belove koma? Asi'i vaika! Boutai ita demia ka'ona koanai sia belolove. ");
INSERT INTO nrz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Beia melalana be'asi koanai kamoane makamaka kauna kevatai beabia tau. Kanaua melalanai ia vaka belolove. ");
INSERT INTO nrz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tubu'a makamakana si'asi'ana ka tubu'a ana'ina 'idina sia bekuli avua, 'olana tubu'a makamakana si'asi'ana beveli bou tubu'a ana'ina be'idia. 'Idi namana bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mai sia kauka vine makamakana vine veina ilaiudana putena ana'inai belaiauda, 'olana vine makamakana betata'u vine veina ilaiudana putena ana'ina bevamukamukala, vine mai putena besi'avana. Kanaua 'ounai vine makamakana 'eva vine veina putena makamakanai mo belaiauda.” ");
INSERT INTO nrz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Melala Kabukabunai Iesu Witi lobanai ekeini, ibanona kauta da'atai Witi vuata debubulu deani. ");
INSERT INTO nrz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Palisea kauta 'eva Iesu de'ouia dediaka, “Ikala! Dava 'ounai oni ibanomu kauta 'eva Melala Kabukabunai talavatu deva'alamaia?” ");
INSERT INTO nrz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu eta luva evamuea ediaka, “Davida ena kau ita melala kanaua'i vikolo deakuta, eko'isi dava evavaia davana valina sia oi ovakua kovo? ");
INSERT INTO nrz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kabukabu kauna namana Abiata ena melalai, Davida eko'isi eda'a Lo'e Kabukabunai palaoa kabukabuna ua'i kabukabu kauta mo be'ani davata eani, vaida ena kau evenita deani.” ");
INSERT INTO nrz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesu mune'e e'outa 'udai ediaka, “Dilava eta'u Melala Kabukabuna evavaia 'eva kau eta nama'ina 'ounai, ia kau 'eva Melala Kabukabuna 'ounai sia evavaia. ");
INSERT INTO nrz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kanaua 'ounai Kau Nakuna 'eva Melala Kabukabuna vaka belovia vaia.” ");
INSERT INTO nrz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu mune'e emue eda'a Iuda kauta eta lo'eai eda'adodo, ua'i 'eva kau ka imana badena eikaia. ");
INSERT INTO nrz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kau vaida ua'i Iesu de'idimala va'eva ka bevavaia koanai beikala, bema kau kanaua bevamaulia Melala Kabukabunai koanai va'evai bene'ea divo. ");
INSERT INTO nrz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu ima bade kauna e'ouia ediaka, “Ko'isi, mai nia'i kau vailatai.” ");
INSERT INTO nrz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Inoku Iesu eta'u kau elavuaita ediaka, “Eta Talavatu dava eluva vaia ekavavai Melala Kabukabunai? Nama'ina ekavavaia 'o si'avana ekavavaia? Kau ekavamaulia 'o ekavabaia?” Beia sia luva ka deluvaia, leleleleta asi'i. ");
INSERT INTO nrz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu mai badunaita ete'eta, mai elalota vaika, 'olana eta nua pasisi 'ounai. Ima bade kauna e'ouia ediaka, “Imamu isia pailolo!” Imana eisia pailolo koanai komolonai enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kanaua 'ounai Palisea kauta lo'eai dela'asi, komolonai deda'a 'Eloda enai de'au kauta ita dedo'u, Iesu iaku bana dalana deluvaluva vaia. ");
INSERT INTO nrz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ibanona kauta ita dela'asi deda'a Kalilea 'ovunai koanai, mato nama vaikana Kalileai mai Iudeai mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Maivaka kau Iudeai, Ielusalemai, Idumeai, Iolidana nutu avekena daenai kauta, Tulo mai Sidono kauta vaka deasi, 'olana 'eva Iesu koa kataua evavai valita deika 'outai. ");
INSERT INTO nrz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mato nama vaikana 'ounai, Iesu ibanona kauta e'outa asi ka beva'olua, kau dala asi'i dema lavalavua makauna. ");
INSERT INTO nrz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesu kau doutamo vaika evamaulita 'ounai, 'olele kauta dala dekavu koanai devidoliviveni, eta ula Iesu beabia kovo. ");
INSERT INTO nrz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Maivaka nuatai ka'uba si'avata vaika demia kauta Iesu deikaia koanai, deasi vailanai de'eko devaoi dediaka, “Oni 'eva Dilava Nakuna!” ");
INSERT INTO nrz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Beia Iesu 'eva ka'uba si'avata vaika e'outa kao, valina sia bekakava ia 'eva dai. ");
INSERT INTO nrz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu loloai ele'au eula venita kauta e'aeta, deda'a kevana. ");
INSERT INTO nrz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kauta 'ouka lua edilata, vata e'oulai Veauneke kauta, ia bebanoa, besinita la'asi beilolo, ");
INSERT INTO nrz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","maivaka siavu bevenita ka'uba si'avata vaika belo'ota asi. ");
INSERT INTO nrz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","'Ouka luana kauta katania. Simona (Iesu va ivaluana evenia Petelo), ");
INSERT INTO nrz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeo nakuna Iakobo, kadina Ioane ita (Iesu va evenita 'eva Boanele, anina 'eva ‘Vutuvutu e'ulua nakuna.’) ");
INSERT INTO nrz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andelea, Pilipo, Batolomeo, Mataio, Toma, Alepeo nakuna Iakobo, Tadeo, Kanana kauna Simona, ");
INSERT INTO nrz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mai Kaliote kauna Iuda Iesu venina eveni kouna ekou kauna. ");
INSERT INTO nrz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu lumai edodo, kau mune'e dedo'u 'udai, ibanona kauta ita beaniani 'eva sia edaia. ");
INSERT INTO nrz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kadi'a'ana valina deika koanai deda'a bevua muea, 'olana kau dediaka ia 'eva 'olana esi'avana. ");
INSERT INTO nrz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Talavatu de'olavaia kauta vaida Ielusalemai deasi deluva dediaka, “Ka'uba si'avata vaika e'olavaita ka'ubana Belesebulo Iesu nuanai edodo, siavu evenia, ka'uba si'avata vaika elo'ota asi.” ");
INSERT INTO nrz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kanaua 'ounai Iesu e'aeta deasi kevana luva ivavitaitatai e'outa ediaka, “A boina Satani 'eva Satani belo'oa asi? ");
INSERT INTO nrz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kanobata ka sibona beva'alamaia inoku lalua bekuali koanai, kanobata kanaua 'eva sia belava 'ini. ");
INSERT INTO nrz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iduvu ka vaka sibona beva'alamaia inoku beviaku koanai, iduvu kanaua vaka sia belava 'ini. ");
INSERT INTO nrz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satani vaka ena iduvu beva'alamaia inoku sibota bekualita koanai, ena iduvu sia belava 'ini, ia bepupua. ");
INSERT INTO nrz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kau ka sia betata'u kula'ila kauna ena luma bedodoa kovo ena luma lavota be'abi, beda'a mo ia belioa 'ana'i vakaia ena luma davata bevinaota. ");
INSERT INTO nrz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Luva umauna mo lau oi a'oumui, Dilava 'eva kau eta si'avana boutai mai eta luva si'avata vaika boutai be'ou kao mai dalana. ");
INSERT INTO nrz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ia kau ka Idume Kabukabuna kevanai beluva si'asi'a kauna 'eva ena si'avana sia be'ou kao kovo bemimia beda'a mo bemia keinikeini.” ");
INSERT INTO nrz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu kanaua eluva koma, 'olana vaida dediaka, “Ia nuanai 'eva ka'uba si'avana vaika emimia.” ");
INSERT INTO nrz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Inoku Iesu sinana mai kadina deasi mulimuliai delava, luva mo desinia eda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Do'u nama vaikana Iesu demiaia kaiukaiu kauta de'ouia dediaka, “Oni sinamu mai kadimu 'eva mulimuliai, deula venimu.” ");
INSERT INTO nrz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu eta luva evamuea ediaka, “Dai 'eva lau sina'u mai kadi'u?” ");
INSERT INTO nrz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iesu kau demiaia kaiukaiu kauta eikata inoku e'outa ediaka, “Katania 'eva lau sina'u mai bo'akala'u. ");
INSERT INTO nrz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dilava ena ula vinaulata devavai kauta 'eva lau bo'akala'u, lovu'u mai sina'u.” ");
INSERT INTO nrz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu mune'e eda'a Kalilea 'ovu nabuanai evaikabasi 'udai. Mato nama vaikana deda'a kevana delava bubua 'ounai, Iesu asi ka akanai ele'au emiadivo. Asi kena eiluasi 'oulai, kau boutai 'eva nabuai delavalaia. ");
INSERT INTO nrz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu 'eva dava doutamo luva ivavitaitatai kau evaikabasita. Ena vaikabasi laloanai kanania eluva koma. ");
INSERT INTO nrz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kaiamui ovala. Vinaula kauna ka eda'a ena kea bevavado. ");
INSERT INTO nrz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ia kea lobai ekapo odaoda koanai, vaida 'eva dalai de'eko asi, inoku manumanu deasi deani paluta. ");
INSERT INTO nrz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Vaida 'eva kano bika'a bika'anai de'ekoasi, dekubu molau, 'olana kano ekevekeve vaika. ");
INSERT INTO nrz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Beia melala edae ekalata koanai delamoda, 'olana lamuta sia de'ovu kave'i. ");
INSERT INTO nrz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Vaida 'eva ava 'ini'inita laloatai de'eko asi. Debudi'au, ia ava 'ini'inita depaka bubuta 'ounai, sia devua. ");
INSERT INTO nrz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mune'e vaida 'eva kano medianai de'eko asi, inoku debudi kave'i devua, vaida vuata koinavui, vaida kalakoinavui, mai vaida sinavu ka.” ");
INSERT INTO nrz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Luva to'onai Iesu e'outa ediaka, “Mai kaiana kauna 'eva lele be'ika.” ");
INSERT INTO nrz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesu sibonamo koanai, ibanona kauta 'ouka lua mai kau vaida mulinai deda'a kauta sibota deda'a kevana delavuaia luva ivavitaitata anita be'oulai kave'i. ");
INSERT INTO nrz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu e'outa ediaka, “Dilava ena lovia vanuana luvata vuniata 'eva oi a'oumui kave'i, beia muliai demimia kauta 'eva dava boutai luva ivavitaitatai mo a'outa. ");
INSERT INTO nrz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kanaua 'ounai kau katania, ‘Beikala beikala beia sia beikala une, mai lele be'ika be'ika beia sia beikabasi. Bema beikala une mai beikabasi koanai, asi'i dema lalo'udai Dilava enai inoku eta si'avana ema 'ou kao 'ounai.’” ");
INSERT INTO nrz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesu mune'e elavuaita ediaka, “Luva ivavitaitana kanania sia oi oikabasia, una? Aboina 'eva luva ivavitaitata vaida a oi boikabasi koma? ");
INSERT INTO nrz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vinaula kauna kea kataua ekapo odaoda 'eva Dilava ena luva ekapoia odaoda. ");
INSERT INTO nrz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kea kataua dalai de'eko asi 'eva kau vaida boita Dilava ena luva 'uluna de'ika, beia Satani e'asi koanai eabita tau. ");
INSERT INTO nrz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kau vaida 'eva itani kea kano bika'abika'anai de'ekoasi boita, Dilava ena luva 'uluna de'ika koanai, mailalonamata ita alimo deabia dae. ");
INSERT INTO nrz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Beia lamuta asi'i, mai sia demia dau'a, inoku Dilava ena luva 'ounai bebadu venita 'o beva ananata koanai, 'ani be'eko. ");
INSERT INTO nrz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kea kataua ava 'ini'inita laloatai de'eko asi davata 'eva kau vaida boita Dilava ena luva 'uluna deika. ");
INSERT INTO nrz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Beia kanobata ena nuanana mai ena lavo ilalo'vaita mai dava vaida iula venita detata'u Dilava ena luva nuatai kataua eabi tau. Kanaua 'ounai vuata 'eva asi'i. ");
INSERT INTO nrz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Beia kau vaida 'eva itani kea kano medianai de'ekoasi boita, Dilava ena luva 'uluna de'ika deabia dae, mai devuvua 'eva vuata vaida koinavui, vaida kalakoinavui, vaida sinavu ka.” ");
INSERT INTO nrz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu mune'e e'outa ediaka, “Kau ka lamepa betoua koanai, vodu laloanai sia beudala 'o maua laloanai sia beudala, Ia lamepa ikau 'auna 'abuna dokadokai bekaua 'au. ");
INSERT INTO nrz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","'Olana dava devuni davata boutai bela'asi, mai de'alavu davata boutai vaka bela'asi, dava ka sia bevunia kovo. ");
INSERT INTO nrz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bema mai kaiamu, 'eva lele ika.” ");
INSERT INTO nrz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","E'outa vaka ediaka, “Oi oika luvata 'eva olalo vaita kave'i. Emui veniveni vitaitatai mo Dilava bevenimui, maivaka kataua akatai doutamo bene'e 'au. ");
INSERT INTO nrz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Olana mai ena dava kauna akatai bene'e 'au bevenia, ia kevanai dava asi'i kauna 'eva enaiai kava'ina emimia davana vaka beabi ovo.” ");
INSERT INTO nrz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu e'outa 'udai ediaka, “Dilava ena lovia vanuana 'eva kau ka kea ena lobai ekapo odaoda boina. ");
INSERT INTO nrz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kau kanaua boni eomuinai lani ai eomia, ia kea 'eva debudi dekubu, sia eikabasi a dekubu koma. ");
INSERT INTO nrz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kano sibona anina evapulua, kea evabudia, kubuna eva elea'au, vakaia mulinai vuana evapulua. ");
INSERT INTO nrz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Vuana e'aiva iukuna melalanai koanai, vinaula kauna ena lepo eabia eda'a, eukuia.” ");
INSERT INTO nrz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu mune'e eluva 'udai ediaka, “Dilava ena lovia vanuana 'eva davai ekavavitaitala? Luva ivavitaitana davanai ekavavitaitala? ");
INSERT INTO nrz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dilava ena lovia vanuana 'eva itani tuava keana boina, kea boutai viloatai 'eva ia mo kikina vaika, kanoai evadoia, ");
INSERT INTO nrz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","muliai ia ekukubu koanai, aniani auta boutai evele kanita, maivaka nama vaikana, le'ena namata 'elu'elutai aka manumanuta boutai de'asi ni'ita devavai.” ");
INSERT INTO nrz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu 'eva kau kataua eta ikabasi vitaitanai luva ivavitaitatai doutamo evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Beia ia luva ivavitaitatai mo eluva venita, ibanona kauta ita demiatau koanai luva anita e'oulai kave'i. ");
INSERT INTO nrz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Melala kanaua'i makani 'eali'ealinai Iesu ibanona kauta e'outa ediaka, “Kakeini kada'a 'ovu avekenai.” ");
INSERT INTO nrz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ibanona kauta ita mato devikania deda'a, Iesu emia'au vaia asinai dele'au inoku ita deda'a. Asi vaida vaka mulitai deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lani nama vaikana eunu, ka'uda eko'isi vei asi laloanai edodo, kevai mo deuku. ");
INSERT INTO nrz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu 'eva ena i'uina e'uinaia asi mulinai eno emuinai. Ibanona kauta deda'a kevana, dekuia dediaka, “Vaikabasi kaumu e, ita ekadono 'eva sia olalovaia?” ");
INSERT INTO nrz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu eko'isi lani mai ka'uda eluva pasisi venita ediaka, “O'olo!” Lani e'olo, ka'uda vaka eno kave'ikave'i. ");
INSERT INTO nrz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Inoku Iesu ibanona kauta e'outa ediaka, “Dava 'ounai oi omakau? Mai emui abiveni 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Beia ia boutai demakau si'asi'a, devika viveni dediaka, “Nia 'eva dai? Lani mai ka'uda vaka lelena deika!” ");
INSERT INTO nrz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu mai ibanona kauta ita dekeini Kalilea 'ovu avekenai, Kelasa kanonai dela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesu asiai e'ovu koanai, kau ka ka'uba si'avata vaika nuanai demia kauna mitavai ela'asi easi Iesu ita devidavali. ");
INSERT INTO nrz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ena mia 'abuna 'eva mitava, sia kauka bedo'o 'inia bedaia mai seiniai vaka bedo'oa 'eva sia bedaia. ");
INSERT INTO nrz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","'Olana melala doutamo 'eva seini mai 'onauai delioia, beia 'onau evamokuta mai seini eva'alamata, ia ivamadanana 'eva kau ka sia eikabasi. ");
INSERT INTO nrz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Boni mai lani ia 'eva mitavai mai loloai melala boutai eovaoi, mai ia sibona kauna telaleai eoivala pau'apau'a. ");
INSERT INTO nrz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kau kanaua Iesu dau'ai easi eikaia koanai, eveau eda'a vailanai ekuidula. ");
INSERT INTO nrz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Iesu ka'uba si'avana vaika e'ouia ediaka, “Ka'uba si'avana vaika! Kau kanana nuanai la'asi.” Kau kanaua evaoi 'unu'unu ediaka, “Iesu Akai vaika Dilavana Nakuna e! Keva'uai dava bovavaia? Dilava vanai anoimu, sia bovanana'u.” ");
INSERT INTO nrz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu eta'u elavuaia ediaka, “Oni vamu 'eva dai?” Ia ena luva evamuea ediaka, “Va'u 'eva Mato, 'olana lai 'eva doumai vaika.” ");
INSERT INTO nrz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ia Iesu enoia 'udai 'udai 'abu kanaua'i sia belo'ota asi. ");
INSERT INTO nrz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Boloma 'itona nama vaikana lolo 'aba'abanai deaniani. ");
INSERT INTO nrz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ka'uba si'avata vaika kataua deta'u Iesu denoia dediaka, “Bosinimai, boloma kataua kevatai inoku laloatai lai badododo.” ");
INSERT INTO nrz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kanaua 'ounai Iesu ena luvai ka'uba si'avata vaika kau kanaua nuanai dela'asi deda'a boloma nuatai dedodo, boloma 'itona 'eva sinavu boutai luanavui (2,000) deveau deda'a ke'eke'eai delovoasi 'ovuai dedovu, dedono ba. ");
INSERT INTO nrz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Boloma 'ima kauta deveau deda'a vanua kauta mai lobai devanua kauta kevatai vali dekava, kanaua 'ounai kau develi deda'a dava epulu davana beikala. ");
INSERT INTO nrz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Deda'a Iesu kevanai dela'asi koanai, 'ana'inai kau kanaua nuanai Ka'uba si'avata vaika demia kauna ena lalovai 'ani dekomolo, ena tubu'a evadodota emia divo deikaia, demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kau kataua Iesu dava evavaia deikaia davata kau vaida vailatai kau kanaua ka'uba si'avata vaika nuanai demia kauna luvana mai boloma luvata deluva. ");
INSERT INTO nrz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Vanua kauta deta'u Iesu denoia eta kano bevikania. ");
INSERT INTO nrz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu asiai ele'au koanai ka'uba si'avata vaika nuanai demia kauna eta'u Iesu enoia bebanoa ita bedada'a. ");
INSERT INTO nrz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Beia ia e'ouia kao ediaka, “Bomumue boda'a emu luma kauta kevata, Dilava a elalomu koma maivaka evamaulimu luvana kadi'a'amu bovaikabasita.” ");
INSERT INTO nrz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kanaua 'ounai kau kanaua eda'a Dekapoli vanuata 'ouka laloatai Iesu dava kevanai evavaia davana valina eilolo vaia, kau boutai detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu mune'e asiai ele'au inoku dekeini 'ovu avekenai, devadai'au koanai, mato namana 'eva ua'i nabuai maivaka dedo'u 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lo'e 'ola kauna ka vana Iailo, eda'a ua'i Iesu eikaia koanai aena 'olanai ekuidula, ");
INSERT INTO nrz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mai nuana itoinai enoia ediaka, “Naku'u vatovatona 'eva 'ani bebaba, kamada'a kaunai bomakao'au bemamauli.” ");
INSERT INTO nrz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iesu eko'isi Iailo ita deda'a, ia mato namana vaka Iesu dedabubua deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ateate ka vaka ua'i 'a'ate eta 'olele eanana vaia vikau boutai 'ouka lua. ");
INSERT INTO nrz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mulamula veni kauta doutamo ia ena 'olele bevanama'inala beia sia edaita, ena moni mai lavo boutai evaoleta, beia ena 'olele sia enama'ina, 'olele 'eva namana eao. ");
INSERT INTO nrz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ia Iesu valina eika koanai, mato viloatai ia mulinai eda'a inoku ena tubu'a eabiakovo. ");
INSERT INTO nrz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","'Olana ia elalovaia, ‘Bema ena tubu'a mo babiakovo koanai bamauli.’ ");
INSERT INTO nrz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ena tubu'a eabiakovo komolonai lala eto'o, kauna eonovaia ena 'olele 'eva 'ani enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iesu komolonai eonovaia vamauli siavuna nuanai davana ela'asi 'ounai elava 'udai inoku elavuai lavuai ediaka, “Dai e'u tubu'a eabiakovo?” ");
INSERT INTO nrz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ibanona kauta deluva dediaka, “Mato nama vaikana devi'avi vi'avi kele'emuai, dava 'ounai olavuai lavuai, dai eabimu kovo.” ");
INSERT INTO nrz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Beia Iesu 'eva ekai to'ato'a dai ia eabiakovo. ");
INSERT INTO nrz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ateate kevanai epulu koakoana 'ani eikabasi 'ounai, emakau si'asi'a mai 'ululu 'ululuna eda'a Iesu vailanai ekuidula, ena 'olele luvana bounai eluvavaia. ");
INSERT INTO nrz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu ia e'ouia ediaka, “Naku'u e, 'olana emu abiveni 'ounai 'ani omauli. Mai mainomu da'a. Emu anana boutai 'ani deole.” ");
INSERT INTO nrz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu eluvaluva do'o laloanai, Iailo ena lumai kau vaida deasi kevana inoku de'ouia dediaka, “Nakumu 'eva 'ani eba. Vaikabasi kauna sia vabavunua.” ");
INSERT INTO nrz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Beia Iesu luva kanaua eika koanai sia eabia dae, lo'e 'ola kauna e'ouia ediaka, “Sia makau, ia abiveni mo.” ");
INSERT INTO nrz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ia eta'u boutai e'outa kao ka sia bebanoa, ia Petelo, Iakobo mai bo'akalana Ioane kauta kakoina bebanoa. ");
INSERT INTO nrz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Deda'a lo'e 'ola kauna ena lumai dele'au, kau eikata dekani vilalo mai dekani si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu luma laloanai eda'adodo, kau e'outa ediaka, “Dava 'ounai oi okakani, 'ulu nama vaikana oi ovavaia, vato kanania sia eba, ia 'eva emuinai.” ");
INSERT INTO nrz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Beia ia 'eva Iesu deikaia demamai. Kau boutai e'outa dela'asi, mulinai vatovato kamana mai sinana ia mai ibanona kauta koina ita deda'a vatovato eno 'abunai dedodo. ");
INSERT INTO nrz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iesu vatovato imanai eabi inoku e'ouia ediaka, “Dalita Kumi!” (Anina 'eva ‘Vatovato e, a'oumu, ko'isi.’) ");
INSERT INTO nrz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Vatovato kanaua komolonai mo eko'isi inoku eda'a to'ato'a. Deikaia kauta boutai detabulovo si'asi'a. Vatovato vikauna 'eva 'ouka lua. ");
INSERT INTO nrz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu e'outa kao dava epulu davana 'eva sia kau ka be'oua. Mune'e e'outa vatovato ana iani kena bevenia beania. ");
INSERT INTO nrz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu 'abu kanaua evikania, ibanona kauta ita deda'a ia ena vanua umauna Nasaleta. ");
INSERT INTO nrz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Melala kabukabunai ia ena vaikabasi eabi sinala. Lo'eai lelena deika kauta boutai detabulovo si'asi'a, dediaka, “Aoneka kanania dai evenia? Siavu a'ia'i easi koa katania evavai.” ");
INSERT INTO nrz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia delavuaia dediaka, “Ia 'eva kamuta kauna, Malia nakuna, Iakobo, Iosepa, Iuda mai Simona 'a'ata, lovuna vaka nia'i kevatai?” ");
INSERT INTO nrz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu e'outa ediaka, “Enolea kauna 'eva 'abu boutai laloatai beabia dae, beia ena vanua umaunai mai dona mai kadi'a'ana umauta 'eva sia beabia dae.” ");
INSERT INTO nrz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ua'i 'eva koa doutamo sia evavai, ia 'olele kauta vida mo akatai ekao'au, evamaulita. ");
INSERT INTO nrz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eda'unai si'asi'a 'olana eta abiveni asi'i 'ounai. Inoku ia eda'a vanua edeata vaida laloatai evaikabasi. ");
INSERT INTO nrz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mune'e Iesu ibanona kauta 'ouka lua e'aeta deasi kevana, siavu evenita, lalua lalua esinita idume si'avata vaika belo'ota asi. ");
INSERT INTO nrz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Evaidibata ediaka, “Emui da'a to'ato'a laloatai dava ka sia oi boabia, ikokoa mo ka'onamo oi boabia. Voina, iani maivaka moni ka sia oi boabia. ");
INSERT INTO nrz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Emui tamaka oi bolavauda, beia ivadodo ivaluata sia oi bo'abi. ");
INSERT INTO nrz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Oi boele'au lumana kanaua'i mo oi bomimia beda'a mo vanua kanaua oi bovikania. ");
INSERT INTO nrz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bema sia beabimui dae 'o lelemui sia beika koanai oi bovikanita, aemui apulolota oi bodavu davu ovo eta va'evai be'ao eta si'avana ivamomo'aina.” ");
INSERT INTO nrz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Inoku ibanona kauta deda'a, deilolo kau bevalalota 'udai, ");
INSERT INTO nrz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","maivaka ka'uba si'avata vaika doutamo delo'ota asi, 'olele kauta doutamo deoloai kauta deuku devamaulita. ");
INSERT INTO nrz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lovia 'olana kauna 'Eloda vali kanaua eika, 'olana Iesu vana 'eva 'ani 'abu bounaiai deluva vaia. Vaida dediaka, “Vaidi'u kabukabu kauna Ioane bai 'ani eko'isi 'udai, mai kanaua 'ounai siavu vinaulata katania evavaita.” ");
INSERT INTO nrz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vaida dediaka, “Ia 'eva Elia.” Vaida mune'e dediaka, “Ia 'eva enolea kauna ka, itani enolea kauta ana'ita boita.” ");
INSERT INTO nrz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Beia 'Eloda 'ulu kanaua eika koanai, ediaka, “Ioane, 'atona atauia uku kauna bai 'ani eko'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","'Ana'inai Ioane sia eba koanai, 'Eloda 'eva 'ani luva esini, Ioane deabia delioia vabuto'o lumanai de'alavua, kanaua evavaia 'olana 'eva 'Elodia dainai. 'Eloda eta'u kadina Pilipo adana 'Elodia eadavala. ");
INSERT INTO nrz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Inoku Ioane eta'u 'Eloda e'ouia ediaka, “Oni kadimu adana oadavala 'eva ova'eva.” ");
INSERT INTO nrz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","'Ounai 'Elodia 'eva Vaidi'u kabukabu kauna Ioane ebadu venia, iaku bana dalana ekavuia, beia sia mai dalana. ");
INSERT INTO nrz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","'Olana 'Eloda 'eva Ioane makauna emakau, eikabasi ia 'eva vinaula kave'i maivaka kabukabu kauna, kanaua 'ounai ia e'imaia kave'i. Melala doutamo 'Eloda Ioane ena luva 'uluta eika koanai, nuana ebavunu beia eula lelena be'ika. ");
INSERT INTO nrz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Eloda ena pulu melalana edaia 'ounai nadu namana ka devavaia, vanua loviata, kuali 'ola kauta, maivaka Kalilea kauta namata deveauta deasi. ");
INSERT INTO nrz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'Elodia nakuna vatona easi do'u kauta vailatai eneva. 'Eloda mai ena ula kauta boutai lalota denama, inoku 'Eloda eta'u vato kanaua e'ouia ediaka, “Oula venia davana bo'oua koanai bavenimu.” ");
INSERT INTO nrz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mai eluva ana'i ediaka, “Dava boula venia 'eva bavenimu, itani e'u kanobata avekena bonoinoi vaia vaka bavenimu.” ");
INSERT INTO nrz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Vato ela'asi eda'a sinana elavuaia ediaka, “Lau dava banoinoi vaia?” Sinana e'ouia ediaka, “Vaidi'u kabukabu kauna Ioane 'olana bonoinoi vaia. ");
INSERT INTO nrz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Vato emue edodo molau eda'a 'Eloda lovia 'olana kauna e'ouia ediaka, “Lau a'ula, vali'unai mo Vaidi'u kabukabu kauna Ioane 'olana nau ai boudala, boveni'u.” ");
INSERT INTO nrz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Lovia 'olana kauna 'Eloda ena lalovai sia ekomolo, beia 'olana 'ani eluva ana'i vato dava beula venia davana 'eva beveveni mo, mai ena vosi kauta ua'i deaniani ka'ona kauta vaka ena luva ana'i 'uluna deika 'ounai sia be'ula 'eva dalana asi'i. ");
INSERT INTO nrz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kanaua 'ounai lovia 'olana kauna 'Eloda kuali kauna ka esinia bedada'a Vaidi'u kabukabu kauna Ioane 'olana beabia be'asi. Kuali kauna kanaua eda'a vabuto'o lumanai Vaidi'u kabukabu kauna Ioane 'atona etauia 'uku. ");
INSERT INTO nrz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'Olana nau ai eudaia eabia eda'a vato evenia, vato eta'u eabia eda'a sinana evenia. ");
INSERT INTO nrz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Vaidi'u kabukabu kauna Ioane ibanona kauta valina deika koanai deda'a kauanina deabia deda'a mitavai dekoleia. ");
INSERT INTO nrz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesu ena veauneke kauta demue deda'a kevanai dedo'u 'udai, devavai davata mai devaikabasi luvata boutai vailanai deluvavai. ");
INSERT INTO nrz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mato namana deda'a de'asi 'ounai Iesu mai ibanona kauta ita eta aniani 'abuna asi'i, ia eko'isi e'outa ediaka, “Kada'a 'abu 'avaeana kai, ua'i lamui oi bo'ani.” ");
INSERT INTO nrz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanaua 'ounai asiai dele'au, deveau keini 'abu 'avaeana ka deda'aia. ");
INSERT INTO nrz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Beia kau doutamo deikata mai deikabasi ia 'eva adeda'aia, 'ounai vanua kauta boutai deveau laia de'ana'ia deda'a 'abu kanaua'i dela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Devadai 'au koanai Iesu mato namavaikana eikaia 'eva elalota vaika itani mamoe sia mai i'imata kauna ka boina. Kanaua 'ounai dava doutamo evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lavilavi melala 'ani be'ulu 'eva ibanona kauta deasi kevana, de'ouia dediaka, “Nia 'eva kano'akuna maivaka melala 'ani beboboni. ");
INSERT INTO nrz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'Ounai kau katania bomasinita demada'a lobai maivaka vanua kevatai u'ai eta iani dematava dema ani.” ");
INSERT INTO nrz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iesu e'outa ediaka, “Oi sibomui iani kena ovenita, deania.” Ia ibanona kauta ia deluva venia dediaka, “Lai batata'u moni sinavu lua (200 denali) ianina lai batavala bavenita be'ani, una?” ");
INSERT INTO nrz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu e'outa ediaka, “Iani vida kevamuiai? Oda'a, oika.” Deda'a deika kave'i demue deasi, de'ouia dediaka, “Palaoa i'abuta ima mai sisi lua.” ");
INSERT INTO nrz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iesu ibanona kauta e'outa, kau okoleta iduvu kikita ka ka duvu akatai bemiadivo. ");
INSERT INTO nrz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kanaua 'ounai kau boutai sinavu ka ka mai imanavui ka ka devamiata. ");
INSERT INTO nrz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inoku ia eko'isi palaoa ima mai sisi lua eabita e'a'a dae vutuvutu eikaia iani evanama'inata. Palaoa ekovita ibanona kauta evenita dekole mato boutai devenita. Sisi luana vaka kanaua ekoleta koma. ");
INSERT INTO nrz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Boutai deaniani, deani vunu. ");
INSERT INTO nrz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iesu ibanona kauta palaoa mai sisi kalita dedoubou, aleka boutai 'ouka lua devonu. ");
INSERT INTO nrz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Deaniani kauta viloatai momoluane 'avaeana 'eva sinavu imanavui (5,000). ");
INSERT INTO nrz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesu alimo ibanona kauta esinita asiai bele'au be'ana'ia beda'a Betesaida avekena. 'A ia 'eva do'u kauta esinita. ");
INSERT INTO nrz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kau deda'a mulitai ia ele'au eda'a loloai bemeamea. ");
INSERT INTO nrz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lavilavi evabula vabula koanai asi 'eva 'ovu bo'adanai, 'a Iesu sibona 'eva kanoai. ");
INSERT INTO nrz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ia eikata 'eva debala debavunu 'olana lani vailatai easi 'ounai. O'oloko eta alala vitaitanai Iesu 'atu akanai eda'a kevata itani asi kevanai bemada'a keinimo boina. ");
INSERT INTO nrz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ia 'atu akanai eda'a deikaia delalovaia ka'uba, demakau devaoi. ");
INSERT INTO nrz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","'Olana ia boutai deikaia nuata debata. Ia alimo e'outa ediaka, “Sia omakau, nuamui ovapasisi. Nia Lau.” ");
INSERT INTO nrz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Asiai elava'au kevatai inoku lani eto'o 'eva detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","'Olana Iesu kau palaoa evenita deani, ibanona kauta koa kanaua ovonai sia deovo, nuata depasisi vaika. ");
INSERT INTO nrz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iesu ibanona kauta ita asiai deveau keini Kenesaleta nabuanai do'o dene'eia. ");
INSERT INTO nrz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Asiai de'ovu koanai kau alimo Iesu deikaiaune. ");
INSERT INTO nrz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Deda'a odaoda kano kanaua laloanai, eta 'olele kauta toto'ai deovuata deoda'a Iesu a'i eomia valina deoika 'abuta. ");
INSERT INTO nrz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesu eda'a 'abuta boutai vanua kikita mai vanua namata. Kau 'olele kauta devuata deda'a tavatava 'abutai dene'eta divo, denoia ena tubu'a tolina mo bemabia kovo. Ena tubu'a deabia kovo kauta boutai 'eva demauli. ");
INSERT INTO nrz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palisea mai talavatu 'ola kauta vaida Ielusalemai deasi Iesu kevanai dedo'u. ");
INSERT INTO nrz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iesu ibanona kauta vaida imata sia dedeini mai 'obuta deaniani, kanaua 'eva Iuda eta koakoai sia dekomolo Palisea kauta vailatai. ");
INSERT INTO nrz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Palisea mai Iuda kauta boutai 'eva sia deaniani 'avaea, ia eta vaikabasi vitaitanai imata dedeini ana'ia vakaia deaniani kubutai 'ava'avata eta koakoa vitaitana. ");
INSERT INTO nrz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tavatava 'abutai de'asi koanai eta tavatava davata sia deanita, ia dedeini makava mai ia vaka deidi'u inoku deaniani. Kubuta eta talavatu doutamo vaka de'ima kave'i, itani 'ou, olaka mai iuduta davata vaka dedeini. ");
INSERT INTO nrz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kanaua 'ounai Palisea mai talavatu 'ola kauta Iesu delavuaia dediaka, “Ibanomu kauta kubuta 'ava'avata devavai vinaulata sia devavai, dava 'ounai imata mai 'obuta deaniani?” ");
INSERT INTO nrz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu eta luva evamuea ediaka, “Isaia ena enoleai oi dede kaumui lovamui eakuia. Kanania eleleia koma. ‘Kau katania 'eva nututai mo Lau devanama'ina'u. 'Beia nuata umauta 'eva dau'ai vaika. ");
INSERT INTO nrz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dekukudivo veni'u 'avaea mo, 'olana talavatu katania kau devaikabasita 'eva kau devavai talavatuta.’ ");
INSERT INTO nrz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Oi 'eva Dilava ena talavatu 'ani oi ovikanita, beia kau eta talavatu mo oi oabi 'inita.” ");
INSERT INTO nrz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mai vaka e'outa ediaka, “Oi Dilava ena talavatu ivuninai 'eva oi oidiba vaika, kanaua 'ounai sibomui emui vaikabasi koakoata oi oabi 'inita. ");
INSERT INTO nrz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Olana Mose eluva ediaka, ‘Kamamu sinamu 'olata bo'aku’, ‘kau ka kamana 'o sinana enai beluva si'asi'a kauna 'eva oi bo'aku bala.’ ");
INSERT INTO nrz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Beia oi odiaka, ‘Kau ka kamana 'o sinana be'oua, vidulu davata bamavenimui ia 'ani Koban.’ (Koban anina 'eva ‘Ainama davata Dilava ena’.) ");
INSERT INTO nrz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kanaua 'ounai kau oi o'alavuta kamata, sinata sia beduluta. ");
INSERT INTO nrz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Koakoa kanania oi ovavai 'eva oi sibomui emui ikabasi kau oi ovaikabasita, Dilava ena luva oi ovunia. Mai kataua boita doutamo vaka oi ovavai.” ");
INSERT INTO nrz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mune'e Iesu mato e'aeta deda'a kevana, e'outa ediaka, “Boumuiai kaiamui ovala, oi boikabasi kave'i. ");
INSERT INTO nrz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dava ka mulimuliai edododo kau nuanai davana kau sia eva'obua, beia dava ka kau nuanai ela'asi davana kau eva'obua. ");
INSERT INTO nrz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mai kaiana kauna lele be'ika.” ");
INSERT INTO nrz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu do'u kauta evikanita lumai edodo koanai ibanona kauta deda'a kevana, luva ivavitaitana kanaua anina delavuai lavuai vaia. ");
INSERT INTO nrz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu e'outa ediaka, “Oi nuamui sia de'ailala, una? Sia oi oikabasia? Iani edododo kau nuanai davana kau sia eva'obua. ");
INSERT INTO nrz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","'Olana kanaua 'eva nuanai sia edododo, ia bo'a laloanai edododo vakaia bela'asi.” (Iesu luva kanania eluvavaia 'olana 'eva iani boutai denama'ina eka ani, sia beva'obuta.) ");
INSERT INTO nrz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eluva 'udai ediaka, “Dava kau nuanai bela'asi davana betata'u kau beva'obuta. ");
INSERT INTO nrz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lalovai si'avata vaika kau nuanai dela'asi davata 'eva katania, kulakula, vinao, akuaku, ");
INSERT INTO nrz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","demali, lalovai va'eva, dede, bo'o, kani, apa, 'oukeinikeini, mai vavai 'avaea. ");
INSERT INTO nrz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dava si'avata vaika boutai nuai dela'asi davata detata'u kau deva'obuta.” ");
INSERT INTO nrz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu 'abu kanaua evikania eda'a Tulo kanonai, ia ena ula sia kau ka beikabasi ia 'eva ua'i, kanaua 'ounai luma ka laloanai eda'a dodo, beia ena pode dalana asi'i. ");
INSERT INTO nrz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ateate ka nakuna vatona nuanai ka'uba si'avana vaika emia, Iesu valina eika koanai, komolonai easi inoku aena 'olanai ekuidula. ");
INSERT INTO nrz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ateate kanaua 'eva sia Iuda ateatena, beia ia 'eva 'Elene ateatena Sulofenise ai epulu. Iesu enoia ka'uba si'avana vaika nakuna nuanai belo'oa 'asi. ");
INSERT INTO nrz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Beia Iesu ia e'ouia ediaka, “Melo demaniani makava, 'olana melo eta iani ekabi ekaitoasi oveka be'ani 'eva sia enama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ateate ediaka, “Lovia namana e, luva umauna, beia oveka vaka melo deaniani 'ika'ikata vakavaka venunai davata deani.” ");
INSERT INTO nrz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iesu ia e'ouia ediaka, “Kanaua oluva koma 'ounai, mue mo da'a emu luma, ka'uba si'avana vaika nakumu nuanai davana 'ani ela'asi.” ");
INSERT INTO nrz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ateate emue eda'a ena luma koanai nakuna 'ani enama'ina edavalia ena muinai 'abunai, ka'uba si'avana vaika 'ani ela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mune'e Iesu Tulo evikania Sidono mai Dekapoli kanotai ekeini eda'a Kalilea 'ovunai ela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kau vaida deta'u kau ka kaiana debubu maivaka malana elevo kauna devuaia deasi Iesu kevana, denoia akanai bekao'au bevanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu kau kanaua do'u viloatai evamiala tau, inoku imana li'uli'una kaiana laloanai eisia dodo, mune'e imana e'anodia kau kanaua malana eabia kovo. ");
INSERT INTO nrz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iesu ea'adae vutuvutu eikaia elavodi, inoku kau kanaua e'ouia ediaka, “Efata!” (Anina 'eva, “Luvu!”) ");
INSERT INTO nrz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Alimo kau kanaua kaiana ileta deluvu mai malana enama'ina eluvaluva kave'i. ");
INSERT INTO nrz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu e'outa kao vali kanania sia kau ka vailanai beluva vaia. E'outa kao beia ia lelena sia deika, ia valina dekava. ");
INSERT INTO nrz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kau boutai detabulovo si'asi'a deluva dediaka, “Ia dava boutai evavai kave'i! Kaiata debubu kauta lele deika vaka mala levo kauta deluvaluva kave'i.” ");
INSERT INTO nrz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Melala kanaua'i kau doutamo mune'e deda'a Iesu kevanai dedo'u 'udai. Ia iani asi'i 'ounai, Iesu ibanona kauta e'aeta deasi kevanai e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kau katania 'eva alalota vaika, 'olana melala 'ani koi kele'e'uai demimia eta iani 'eva 'ani eole. ");
INSERT INTO nrz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bema mai vikolota basinita dalai 'eva vaida asi'i dema'eko, 'olana vaida 'eva 'abu dau'anai deasi.” ");
INSERT INTO nrz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ibanona kauta de'ouia dediaka, “Ita 'eva kano'akunai. Iani a'ia'i ekabi, kau katania ekavananita?” ");
INSERT INTO nrz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu elavuaita ediaka, “Emui iani boutai vida?” Ia dediaka, “Palaoa kalakoi ka.” ");
INSERT INTO nrz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu kau e'outa kanoai bemiadivo. Inoku palaoa kalakoi ka kataua eabi isi vanama'ina luvana Dilava evenia, inoku ekovita mukamuka ibanona kauta evenita bekokole, kau bevenita. Eluva vitaitana devavaia. ");
INSERT INTO nrz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eta sisi kikita vaka vitalua, evanama'inata, inoku ibanona kauta evenita bekokole. ");
INSERT INTO nrz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Boutai deaniani, deani vunu. Ibanona kauta iani kalita dedoubou 'eva aleka kalakoi ka. ");
INSERT INTO nrz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kauta 'eva boutai sinavu vani navui (4,000) boita. Inoku kaka esinita deda'a eta 'abu. ");
INSERT INTO nrz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Inoku ibanona kauta ita asiai dele'au deda'a Dalmanuta kanona. ");
INSERT INTO nrz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Palisea kauta deasi Iesu delavuaia bevakovoa, koa ka bevavaia beikala, bevamomo'aia ena siavu 'eva Dilava kevanai easi. ");
INSERT INTO nrz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu elavodi mai nua'avalana, eluva ediaka, “Dava 'ounai ulu kanania kaumui koa oi okakavu? Luva umauna lau oi a'oumui, ulu kanania kaumui koa ka sia bavaikamui.” ");
INSERT INTO nrz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Inoku ia evikanita asiai ele'au 'udai ekeini eda'a 'ovu avekena. ");
INSERT INTO nrz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ibanona kauta palaoa boutai debolabolata, palaoa ka'onamo mo asiai emia. ");
INSERT INTO nrz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu ia evaidibata ediaka, “Makamui oi bovata, Palisea kauta mai 'Eloda eta vakubu mai eta nuani koakoata asi'i oi omavavai makauna.” ");
INSERT INTO nrz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ibanona kauta sibota viloatai deluvaluva dediaka, “Iani sia ka kabiakasi 'ounai kanania eluva koma.” ");
INSERT INTO nrz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu eikabasi davai deluva, e'ovenita ediaka, “Dava 'ounai iani kele'emui asi'i davana luvana oi oluluva? Oi sia oi oikabasi 'o ovonai sia oi o'ovo? Nuamui depasisi vaika? ");
INSERT INTO nrz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mai makamui, beia sia oi oikala? Mai kaiamui, beia lele sia oi oika? Dava sia oi olalovai 'ini? ");
INSERT INTO nrz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Lau palaoa ima akovi mukamuka kau sinavu ima navui (5,000) deani vunu koanai kalita aleka vida oi ovavonu?” Ia deluva dediaka, “Aleka 'ouka lua.” ");
INSERT INTO nrz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ia e'outa ediaka, “Maivaka palaoa kalakoi ka akovi mukamuka kau sinavu vaninavui (4,000) deani vunu, kalita aleka vida oi ovavonu?” Ia dediaka, “Aleka kalakoi ka.” ");
INSERT INTO nrz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ia e'outa ediaka, “Oi dava 'ounai nuamui sia de'ailala?” ");
INSERT INTO nrz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Deasi Betesaida vanuanai dela'asi koanai, kau vaida maka ede kauna ka devada'ala deasi Iesu kevana denoia akanai bekao'au makana bevanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu maka ede kauna imanai eabi evada'ala dela'asi vanua mulinai, makana e'anodi mai imana akanai ekao'au inoku elavuaia ediaka, “Dava 'ani oika?” ");
INSERT INTO nrz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Maka ede kauna ea'adae, eluva ediaka, “Kau aikata deda'a to'ato'a itani au boita.” ");
INSERT INTO nrz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mune'e makanai ekao'au 'udai, ia eika to'ato'a koanai ena ikaika 'ani enama'ina, dava boutai eikata kave'i. ");
INSERT INTO nrz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Esinia beda'a ena luma, e'ouia ediaka, “Vanua laloanai sia boda'a dodo.” ");
INSERT INTO nrz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu ibanona kauta ita deda'a Kaisalea Pilipo vanuata, dalai ibanona kauta elavuaita ediaka, “Kau 'eva dava dekoma, lau 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ena luva devamuea dediaka, “Vaida dediaka, oni 'eva Vaidi'u kabukabu kauna Ioane, 'a vaida dediaka, oni 'eva Elia, maivaka vaida dediaka, oni 'eva enolea kauna ka.” ");
INSERT INTO nrz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Beia ia elavuaita ediaka, “Ia oi odiaka, lau 'eva dai?” Petelo ia e'ouia ediaka, “Oni 'eva Keliso, Dilava edilamu kaumu.” ");
INSERT INTO nrz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu e'outa kao ia luvana kau ka sia be'oua. ");
INSERT INTO nrz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ia ibanona kauta evaikabasita makava, Kau Nakuna 'eva anana doutamo beananavaita, vanua 'ola kauta, kabukabu kauta namata, mai talavatu 'ola kauta bevaivivia maivaka beaku bala, beia boni ivakoinai 'eva beko'isi 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Luva kanania e'ouia dae kave'i koanai, Petelo Iesu evamiala tau 'aba'abai eluva pasisi venia. ");
INSERT INTO nrz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Beia Iesu 'eva elava 'udai, ibanona kauta eikata, Petelo e'ovenia ediaka, “Satani, Da'atau, muli'u da'ala! 'Olana emu lalovai 'eva sia Dilava enai, ia kau eta.” ");
INSERT INTO nrz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Inoku Iesu mato e'aeta maivaka ibanona kauta ita e'outa ediaka, “Kau ka be'ula lau bebano'u koanai, ia sibona ena mauli bevikania, ena au ido'o valaukuna beabia 'isi bevuala, lau muli'uai bedada'a. ");
INSERT INTO nrz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bema ena mauli beabi 'inia kauna ena mauli bevataulea, beia lau 'ou'uai mai vali nama'ina 'ounai ena mauli beitoa'au kauna 'eva ena mauli beabia. ");
INSERT INTO nrz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kau ka kanobata itoina bema abia ia ena mauli bemavataulea 'eva enai ena nama'ina dava? ");
INSERT INTO nrz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","'O kau ka dava beveveni ena mauli beabia 'udai? ");
INSERT INTO nrz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lau dai'uai 'o e'u luva daitai kau ka kulakula maivaka ulu sia'avana kanania vailatai bemalalai veni'u kauna, Kama'u ena nuavi ena anelu kabukabuta ita be'asi koanai Lau Kau Nakuna vaka ia bamalalai venia.” ");
INSERT INTO nrz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Maivaka Iesu e'outa ediaka, “Luva umauna mo lau oi a'oumui, vaida nia'i delalava kauta sia bebaba beda'a mo Dilava ena lovia vanuana mai siavuna be'asi 'eva beikala.” ");
INSERT INTO nrz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Melala kalakoi de'ole mulinai, Iesu 'eva Petelo, Iakobo mai Ioane mo evada'ata lolo namana kai dele'au, ua'i demiatau koanai vailatai ikana evaedea, ");
INSERT INTO nrz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ena tubu'a e'amale 'amale edeva'i ovo, edeva'i si'asi'a kanobatai tubu'a deini kauna ka kanaua sia bemavadeva'ia koma. ");
INSERT INTO nrz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Inoku Elia mai Mose devaila divo ia vailatai dela'asi, laluana Iesu ita deluvaluva. ");
INSERT INTO nrz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petelo eta'u Iesu e'ouia ediaka, “Vaikabasi kaumu e, ita nia'ia'i 'eva enama'ina vaika, aiole koi lai bavavai, ka oni emu, ka Mose ena, ka Elia ena.” ");
INSERT INTO nrz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Beia demakau si'asi'a 'ounai, Petelo a beluva koma 'eva sia eikabasi. ");
INSERT INTO nrz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Oli ka easi e'alavuta, maivaka lele ka oli laloanai easi, ediaka, “Kanania 'eva lau naku'u, e'u lalo'au kauna, lelena oi bo'ika.” ");
INSERT INTO nrz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Alimo dekailao dekaimai beia ia sia kau ka deikaia, Iesu sibona mo ia viloatai. ");
INSERT INTO nrz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Loloai de'ovu koanai, Iesu e'outa kao deika davata 'eva kau ka vailanai sia beluluva, beda'a mo Kau Nakuna bai beko'isi 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ena luva delalovai 'inia, ia sibota mo deluvaluva vaia, bai ko'isi 'udai anina 'eva dava. ");
INSERT INTO nrz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ia deta'u Iesu delavuaia dediaka, “Dava 'ounai talavatu 'ola kauta deluva Elia 'eva beasi makava?” ");
INSERT INTO nrz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu e'outa ediaka, “Luva umauna. Elia 'eva beasi makava, dava boutai bevavai kave'i. Ia dava 'ounai Kau Nakuna luvana Puka Kabukabunai deleleia beanana si'asi'a vaika maivaka bevaivivia? ");
INSERT INTO nrz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lau oi a'oumui, Elia 'eva 'ani easi, maivaka kau eta ula vinaulata boutai kevanai devavai, ia luvana deleleia vitaitanai.” ");
INSERT INTO nrz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Deasi ibanona kauta vaida kevatai koanai, kau doutamo vaika delavata kaiukaiu, talavatu 'ola kauta mai ibanona kauta ita devina deikata. ");
INSERT INTO nrz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Do'u kauta Iesu deikaia koanai, detabu lovo si'asi'a deveau deda'a kevana devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu ibanona kauta elavuaita ediaka, “Dava vinana oi ovina vaia?” ");
INSERT INTO nrz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Do'u laloanai kau ka eluva ediaka, “Vaikabasi kaumu e! Lau naku'u abia a'asi oni kevamu, 'olana nuanai mala si'avana ka'ubana emimia 'ounai sia eluvaluva. ");
INSERT INTO nrz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Melala vaida ka'uba si'ava vaikana e'iuvai 'iuvai 'eva eva'ekoa kanoai enodivo nutunai budo budo mai nikena eala'ini kauna epasisi ovo. Ibanomu kauta anoita ka'uba si'avana vaika belo'oa asi, beia sia edaita.” ");
INSERT INTO nrz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu e'outa ediaka, “Ulu kanania kaumui emui abiveni asi'i, kevamuiai bamimia beda'a mo melala davanai? Bakau anana kevamuiai beda'a mo melala davanai? Melo oabia omai keva'u.” ");
INSERT INTO nrz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Melo deabia deda'a Iesu kevana, ka'uba si'avana vaika Iesu eikaia koanai, melo evatakutaku si'ala, e'eko kanoai e'ule keini 'ule keini, nutunai budo budo dela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu melo kamana elavuaia ediaka, “Aida koanai kanania boina eabi sinala?” Ia ediaka, “'Ani 'oma'omanai melalanai. ");
INSERT INTO nrz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Melala doutamo ka'uba si'avana vaika etata'u 'alova akanai ekapoa 'au mai veiai ekapoa uku bevabala ekoma. Beia 'ani bovavaia koanai, lalomai, mai dulumai.” ");
INSERT INTO nrz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu e'ouia ediaka, “Dava 'ounai 'ani bavavaia bedaia okoma! Dilava eabivenia kauna kevanai dava boutai bevavai 'eva bedaia.” ");
INSERT INTO nrz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Alimo melo kamana evaoi ediaka, “Lau 'eva 'ani abiveni, bomadulu'u e'u abiveni kikina abivenina vanamaia.” ");
INSERT INTO nrz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu do'u kauta eikata, develi molau deda'a kevana koanai, ia ka'uba si'avana vaika e'ovenia ediaka, “Mala levo mai kaia bo'o ka'ubana, lau oni a'oumu. Melo nuanai la'asi, kanana'i sia bododo 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka'uba si'avana vaika evaoi, melo evatakutaku si'ala, inoku ia ela'asi, melo eno itanimo eba, kau dediaka melo 'ani eba vaika. ");
INSERT INTO nrz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Beia Iesu melo imanai eabi evelia isi, alimo eko'isi elavadivo. ");
INSERT INTO nrz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesu luma laloanai eda'a dodo, ibanona kauta vunivuniai delavuaia dediaka, “Dava 'ounai lai ka'uba si'avana lai balo'oa asi 'eva sia edaia?” ");
INSERT INTO nrz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ia e'outa ediaka, “Dava katania boita ilo'o asita dalana ka asi'i, meamea mo sibona.” ");
INSERT INTO nrz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu ibanona kauta ita 'abu kanaua devikania, Kalilea kanonai dekeini. Iesu sia eula kau ka beikabasi ia 'eva a'ia'i, ");
INSERT INTO nrz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","'olana ibanona kauta evaikabasita, e'outa ediaka, “Kau ka lau Kau Nakuna veni'u beveveni kou'u bekokou kau imatai beuda'u, beaku ba'u. Beia melala ivakoinai lau 'eva bako'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Beia ia 'eva sia deikabasi dava eluvavaia maivaka belavuaivaia 'eva demakau. ");
INSERT INTO nrz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapelanauma vanuanai dela'asi, luma laloanai Iesu ibanona kauta elavuaita ediaka, “Vali'u dalai ka'asi 'eva dava oi oviadedua vaia?” ");
INSERT INTO nrz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Beia sia deluva, 'olana dalai deasi 'eva dai vana namana be'ao deviadedua vaia. ");
INSERT INTO nrz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu emia divo, ibanona kauta 'ouka lua e'aeta, e'outa ediaka, “Dai e'ula be'ana'ia kauna, ia sibona muliai vaika bene'ea divo maivaka kau boutai eta da'alabi kaunai be'ao.” ");
INSERT INTO nrz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Inoku Iesu melo kikina ka eabia vailatai evalavala divo kukuanai eabi vakaia e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kau ka lau va'uai melo kikina kanania boina eabia dae kauna lau vaka eabi'u dae, lau eabi'u dae kauna 'eva sia lau mo sibo'u, beia esini'u Dilavana vaka eabia dae.” ");
INSERT INTO nrz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioane eta'u e'ouia ediaka, “Vaikabasi kaumu e, kau ka lai aikaia, vamuai ka'uba si'avata vaika elo'ota asi, lai ata'u a'ouia bevapuala, 'olana ia 'eva sia ita banota.” ");
INSERT INTO nrz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu e'outa ediaka, “Sia oi boma'alavuia, 'olana lau va'uai siavu vinaulata evavai kauna, muliai lau va'u sia bevasi'avanala. ");
INSERT INTO nrz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","'Olana sia evaivivita kauna 'eva ita banota. ");
INSERT INTO nrz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Luva umauna lau oi a'oumui. Va'uai kau ka vei 'ou ka bevenimui oi boinua 'olana oi 'eva Keliso ena, kau kanaua 'eva mai tavana.” ");
INSERT INTO nrz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ Bema dai lau keva'uai deabiveni melota ka si'avanai bene'eadivo kauna 'eva bika'a nama vaikana ka 'atonai bedo'oa 'au bekapoa uku 'atuai 'eva bemanama'ina. ");
INSERT INTO nrz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Imamu ka bevava'evamu koanai, botaua uku, imamu ka'onamoai mauli nama'ina laloanai bodododo, inoku sia enama'ina imamu luai boda'a 'alova sia ebobo'o kovo 'abuna. ");
INSERT INTO nrz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'Abu kanaua 'imolo 'imolota kau deanita davata 'eva sia deba kovo, maivaka 'alovana sia ebo'o kovo. ");
INSERT INTO nrz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aemu ka bevava'evamu koanai, botaua uku, aemu ka'onamoai mauli nama'ina laloanai bodododo, inoku sia enama'ina aemu luana nama'itai 'alova 'abunai bekapomu dodo. ");
INSERT INTO nrz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'Abu kanaua 'imolo'imolota kau deanita davata 'eva sia deba kovo, maivaka 'alovana sia ebo'o kovo. ");
INSERT INTO nrz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Makamu ka bevava'evamu koanai, boiasi, makamu ka'onamoai Dilava ena lovia vanuanai bodododo maivaka sia enama'ina makamu luana nama'itai 'alova 'abunai bekapomu dodo. ");
INSERT INTO nrz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'Abu kanaua 'imolo 'imolota kau deani davata 'eva sia deba kovo, maivaka 'alovana sia ebo'o kovo. ");
INSERT INTO nrz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Inoku mekau 'alova boina betata'u kau boutai bevaananata vaika itani dedamenata boina.” ");
INSERT INTO nrz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Damena 'eva dava nama'ina, beia bema damena sia bedia'a koanai ivadia'a 'udai dalana asi'i. Oi 'eva sia kanaua boinai oi bo'ao, ia damena oi boabia viloamuiai, oi bovaka'onamo.” ");
INSERT INTO nrz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu 'abu kanaua evikania eda'a Iuda kanonai ekeini eda'a Iolidana duasi. Kau doutamo deasi Iesu kevanai dedo'u 'udai, mune'e evaikabasita melala boutai evavai vitaitata. ");
INSERT INTO nrz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Palisea kauta vaida deda'a kevana devakovoa dediaka, “Eta talavatuai kau ka adana bema eva'ovua koanai mai ena komolo, 'o?” ");
INSERT INTO nrz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu e'outa ediaka, “Mose ena talavatu laloanai dava ekoma?” ");
INSERT INTO nrz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ia ena luva devamuea dediaka, “Mose ena talavatu ediaka, kau ka adana beva'ovua koanai malelena belelea beda'a ateate kevana, inoku ateate beva'ovua.” ");
INSERT INTO nrz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu e'outa ediaka, “'Olana emui nua pasisi 'ounai Mose talavatu kanania evenimui. ");
INSERT INTO nrz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Beia Dilava kanobata evavaia melalanai, kau evavaita moluane mai ateate. ");
INSERT INTO nrz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kanaua 'ounai kau 'eva kamana sinana bevikanita, ia adana ita bemia ka'ona. ");
INSERT INTO nrz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ia laluana kauanita 'eva ka'onamo boina. Kanaua 'ounai laluana kauanita 'eva ka'onamo, beia sia lua. ");
INSERT INTO nrz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dilava eta'u evaka'onamota davana kau sia beva'alamaia.” ");
INSERT INTO nrz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Deda'a luma ka laloanai, ibanona kauta 'eva Iesu kevanai luva kanaua anina delavuai lavuai vaia 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu e'outa ediaka, “Kau ka adana eva'ovua mune'e ateate ka eadavala 'udai ia 'eva mo'a kauna. ");
INSERT INTO nrz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ateate vaka adana bevikania kau ka beadavala ia vaka 'eva mo'a ateatena.” ");
INSERT INTO nrz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kau vaida nakuta devada'ata deda'a Iesu kevana akatai bekao'au bevanama'inata, beia ibanona kauta deta'u de'ovenita. ");
INSERT INTO nrz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu koa kanaua eikaia koanai ebadu, ediaka, “Melo kikita ovikanita, demai lau keva'u, sia olo'ota, 'olana katania boita 'eva Dilava ena lovia vanuana kauta. ");
INSERT INTO nrz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Luva umauna lau oi a'oumui, Dilava ena lovia vanuana iabinai kau ka melo kikina boina sia be'ao koanai, ia 'eva sia beda'adodo kovo.” ");
INSERT INTO nrz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Inoku Iesu melo eabita, imana akatai ekao'au evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu dalai eda'a laloanai, kau ka eveaua nanadi eda'a vailanai ekuidula elavuaia ediaka, “Vaikabasi kaumu nama'imu e, lau dava bavavaia mauli keinikeini babia?” ");
INSERT INTO nrz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu eta'u e'ouia ediaka, “Dava 'ounai lau nama'i'u o'oua? Kau ka sia enama'ina, ia Dilava sibona mo enama'ina. ");
INSERT INTO nrz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Talavatu 'ani oikabasia. Sia Boakuaku, sia bokulakula, sia bovinao, sia bo'ou keinikeini, sia bodedede, kamamu sinamu 'olata bo'aku.” ");
INSERT INTO nrz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kau kanaua eluva ediaka, “Vaikabasi kaumu e, talavatu katana 'eva kiki'u koanai a'imata kave'i easi mo vali'u.” ");
INSERT INTO nrz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu ia eika 'inia mai lalo'auna inoku eluva ediaka, “Dava ka'onamo otabu vaia 'eva kanania, emu lavo botavatava vaita, monita ulalu kauta bovenita koanai vutuvutuai tavamu boabia, inoku bo'asi muli'uai bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Luva kanaua eika koanai, vailana maivilalona eda'a ovo mainua ananana, 'olana ia 'eva lavo kauna. ");
INSERT INTO nrz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu ekai to'ato'a, ibanona kauta e'outa ediaka, “Lavo kauta Dilava ena lovia vanuana laloanai bedododo 'eva epasisi vaika” ");
INSERT INTO nrz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ibanona kauta luva kanaua deika 'eva detabu lovo si'asi'a, beia mune'e e'outa 'udai ediaka, “Naku'u e, Dilava ena lovia vanuana ida'a dodona 'eva epasisi vaika. ");
INSERT INTO nrz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela nila 'ilenai bekeini 'eva bedaia, beia lavo kauna Dilava ena lovia vanuanai bedododo 'eva epasisi vaika.” ");
INSERT INTO nrz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ibanona kauta detabu lovo si'asi'a, sibota viloatai deluvaluva dediaka, “Dai 'eva mauli beabia?” ");
INSERT INTO nrz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu eika 'inita, inoku ediaka, “Dava ivavaita kau kevatai sia bedaia, beia Dilava kevanai 'eva edaia. 'Olana dava boutai ivavaita Dilava kevanai 'eva edaia.” ");
INSERT INTO nrz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petelo eta'u Iesu e'ouia ediaka, “Lai emai dava boutai lai avikanita, oni mulimuai lai adada'a.” ");
INSERT INTO nrz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu e'outa ediaka, “Luva umauna lau oi a'oumui, kau ka betata'u lau dai'uai mai vali nama'ina dainai ena luma, 'o bo'akalana, 'o lovuna, 'o sinana, 'o kamana, 'o nakuna, 'o ena kano bevikanita, ");
INSERT INTO nrz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","vali'u melala kanania'i ia 'eva dava doutamo be'abi, ena luma, bo'akalana, lovuna, sinana, nakuna mai ena kano boutai sinavu sinavu be'abi, maivaka beva ananala, inoku melalana be'asi koanai ia 'eva mauli keinikeini beabia. ");
INSERT INTO nrz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Beia doutamo de'ana'ia kauta 'eva bemulikai, maivaka demulikai kauta 'eva be'ana'ia.” ");
INSERT INTO nrz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dalai Ielusalema kokona deda'a koanai Iesu 'eva e'ana'ia ibanona kauta nuata ebavunu si'asi'a, maivaka mulinai deda'a kauta 'eva demakau, kanaua Iesu eta'u ibanona kauta e'aeta tau, kevanai dava bepupulu davana valina 'eva vailatai eluvavaia. ");
INSERT INTO nrz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ediaka, “Ita vali'u kaele'au Ielusalemai ua'i kau ka lau Kau Nakuna veni'u beveveni kou'u bekokou kabukabu kauta mai talavatu de'olavaia kauta kevatai, iaku ba'u luvana bevamomo'aia, pulu edea kauta bevenita. ");
INSERT INTO nrz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kau kataua lau bemedia media vai'u, be'anodi'u, be'odi'u inoku beaku ba'u, beia melala ivakoinai 'ani bako'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedeo nakuna lalua Iakobo mai Ioane deasi Iesu kevana, de'ouia dediaka, “Vaikabasi kaumu e, emai ula davana ka kevamuai lai banoinoi vaia 'eva bovavaia.” ");
INSERT INTO nrz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu e'outa ediaka, “Oi o'ula dava kevamuiai bavavaia?” ");
INSERT INTO nrz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ia deluva dediaka, “Emu nuavi oabia koanai, lai laluana ka oni idibamuai ka 'ealimuai lai bamamia.” ");
INSERT INTO nrz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Beia Iesu ia e'outa ediaka, “Oi onoinoi vaia davana 'eva sia oi oikabasia. Lau bainua 'ouna oi boinua bedaimui? Maivaka lau bevaidi'u kabukabu'u idi'u kabukabuna oi bevaidi'u kabukabumui bedaia?” ");
INSERT INTO nrz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Laluana deluva dediaka, “'O, Bedaimai.” Inoku Iesu e'outa ediaka, “Lau bainua 'ouna 'eva oi vaka oi boinua, maivaka lau bevaidi'u kabukabu'u idi'u kabukabuna oi vaka bevaidi'u kabukabumui. ");
INSERT INTO nrz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Beia idiba'uai mai 'eali'uai bemimia kauta 'eva lau sia badilata. Mia 'abuta kataua 'eva Dilava 'ani eva'oluta, ia ena ula kauta mo eta.” ");
INSERT INTO nrz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ibanona kauta 'ouka 'ulu kanaua deika koanai Iakobo mai Ioane itana debadu venita. ");
INSERT INTO nrz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu e'aeta deasi kevana e'outa ediaka, “Oi oikabasi Pulu edeana kauta eta kau delovia vaita, ia 'eva kula'ilai kau de'ana'ia vaita, maivaka eta siavuai kau de'imata. ");
INSERT INTO nrz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Beia oi viloamuiai 'eva sia kanaua boina, dai namana belalovaia kauna 'eva da'alamui iabinai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maivaka bema dai e'ula be'ana'ia kauna 'eva oi boumuiai da'alamui iabina kaunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Lau Kau Nakuna asi 'eva da'ala'u sia be'abi, beia da'ala ba'abi 'ounai asi, maivaka e'u mauli baveveni kau doutamo batavata bemauli.” ");
INSERT INTO nrz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ia Ielikoai dela'asi. Iesu mune'e ibanona kauta mai kau doutamo ita Ieliko devikania, dala 'aba'abanai maka'ede kauna vana Batimeo (ua 'eva Timeo nakuna) emia divo ua'i enoi va'ame. ");
INSERT INTO nrz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kau kanaua Iesu Nasaleta kauna vana de'ouia 'uluna eika koanai, alimo e'ae ediaka, “Iesu Davida nakuna e! Lalo'u.” ");
INSERT INTO nrz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kau deta'u depilaia lele bevuvunu, beia ia 'eva e'ae 'udai 'ae 'udai e'ae 'unu'unu ediaka, “Davida nakuna e! Lalo'u.” ");
INSERT INTO nrz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu elavadivo, e'outa ediaka, “O'aeia.” Kanaua 'ounai ia deta'u maka ede kauna de'ouia, “Lalomu denama, ko'isi, ia 'eva oni e'aemu.” ");
INSERT INTO nrz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Komolonai ena ikalu eitoia 'au, eko'isi eda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu ia elavuaia ediaka, “O'ula dava bavavaia kele'emuai?” Maka ede kauna eluva ediaka, “Vaikabasi kaumu e. A'ula maka'u bomavanama'inata.” ");
INSERT INTO nrz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu e'ouia ediaka, “Da'a, emu abiveni eta'u 'ani evamaulimu.” Makana 'ani deata, kanaua'i Iesu mulinai eda'a. ");
INSERT INTO nrz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ielusalema dekavuia deda'a, deasi Olive lolonai, Betefage Betani kevatai, ua'i Iesu ibanona kauta lalua esinita 'ana'i, ");
INSERT INTO nrz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","e'outa ediaka, “Oi boda'a vanua kanaua vailatai vanuana laloanai oi boda'a dodo, doniki nakuna ka oi bodavalia kau ka sia emia'au kovo donikina ua'i 'ani dedo'oia 'au, oi boluvua oi boabia bo'asi. ");
INSERT INTO nrz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bema kau ka belavuaimui, bediaka, ‘Dava 'ounai kanana oi ovavaia?’ koanai, oi bo'oua bodiaka, ‘Lovia namana eula venia, melala kikinamo vakaia bevamuea.’” ");
INSERT INTO nrz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Laluana deda'a doniki nakuna ka dedavalia vanua bo'adanai luma ka nutualana aunai ido'o 'auna deikaia. Deluvuia laloanai, ");
INSERT INTO nrz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","kau vaida ua'i delava kauta delavuaita, dediaka, “Dava 'ounai doniki nakuna oi oluvua?” ");
INSERT INTO nrz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iesu eluvavaia vitaitanai mo kau kataua de'outa 'eva devikanita. ");
INSERT INTO nrz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Doniki nakuna deabia deasi Iesu kevana koanai, kabenai eta tubu'a delavalita, inoku Iesu emia'au. ");
INSERT INTO nrz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kau doutamo eta tubu'a dalai delavali, vaida 'eva dala 'aba'abanai au uauata detauku delavalita. ");
INSERT INTO nrz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vailanai mai mulinai deda'a kauta deva'oi dediaka, “'Osana! Lovia namana vanai e'asi kauna kavanama'inala. ");
INSERT INTO nrz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","'Ava'avata Davida ena lovia vanuana 'ani e'asi kauna kavanama'inala. 'Osana, aka umaunai Dilavana kavanama'inala.” ");
INSERT INTO nrz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu Ielusalemai ela'asi Lo'e Kabukabuna laloanai eda'a dodo, dava boutai eika, beia melala e'iu'iu 'ounai ibanona kauta 'ouka lua ita demue deda'a Betani. ");
INSERT INTO nrz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Elani Betani devikania laloanai Iesu vikolo eakuia. ");
INSERT INTO nrz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Suke mai uauana dau'ai eikaia, eda'a kevana beikala kave'i bema vuana ka itani, beia uauana 'avaeata mo sia dava ka edavalia, 'olana Suke sia eta vua melalana. ");
INSERT INTO nrz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesu au kanaua e'ouia ediaka, “Oni vuamu kau ka sia beania 'udai beda'a mo to'ona asi'i.” Ibanona kauta lelena kanaua deika. ");
INSERT INTO nrz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ielusalemai dela'asi, Iesu Lo'e Kabukabunai eda'adodo tavatava kauta elo'ota asi, moni deabi keini kauta eta vakavaka eva'i'itolita mune'e boiomalo detavatava vaita kauta eta mia'au davata edolita 'i'itolita. ");
INSERT INTO nrz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iesu eta dala e'alavuta ka ena tavatava davana sia bevuala keini Lo'e Kabukabuna ikekebilina laloanai. ");
INSERT INTO nrz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kau evaikabasita ediaka, “Puka Kabukabunai deleleia, Dilava ediaka, ‘E'u luma 'eva kau boutai be'oua eta meamea lumana’, beia oi 'ani abi'avaea kauta eta pode 'abuna oi ovaoa.” ");
INSERT INTO nrz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kabukabu kauta namata mai talavatu de'olavaia kauta 'ulu kanania deika 'ounai, iakubana dalana dekavuia, ia demakau vaia 'olana kau boutai 'eva ena vaikabasi luvata kataua delalonama vaita 'ounai. ");
INSERT INTO nrz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lavilavi 'eva vanua namana kanaua devikania. ");
INSERT INTO nrz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","'Avu'avuni deda'a keini koanai, Suke kanaua deikaia 'ani e'ibu eda'a mo lamunai. ");
INSERT INTO nrz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petelo elaloune inoku Iesu e'ouia ediaka, “Vaikabasi kaumu e! Ikala. Suke o'ovenia auna 'eva 'ani e'ibu.” ");
INSERT INTO nrz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu e'outa ediaka, “ Dilava oiboabivenia. ");
INSERT INTO nrz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Luva umauna lau oi a'oumui. Kau ka lolo kanania bema'oua, ‘Sibomu ko'isi 'atu laloanai eno uku’, bevamomo'aia nuana sia belalo to'ato'a koanai davana bepupulu. Ia eula vaia 'eva beabia. ");
INSERT INTO nrz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kanaua 'ounai lau oi a'oumui, oi oula veni davata boutai meameai oi bonoinoi, inoku oi boabiveni 'eva oi bodavalita oi emui. ");
INSERT INTO nrz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Meamea laloatai oi bolalava koanai, devasi'avanamui kauta eta si'avana oi bo'ou kao, inoku Kamamui vutuvutuai kauna emui si'avana vaka be'ou kao. ");
INSERT INTO nrz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Beia eta si'avana sia oi bo'ou kao koanai, Kamamui vutuvutuai emimia kauna emui si'avana vaka sia be'ou kao.” ");
INSERT INTO nrz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mune'e Ielusalemai dela'asi, Iesu eda'a Lo'e Kabukabuna vailanai eda'a keini koanai, kabukabu kauta namata, talavatu de'olavaia kauta, maivaka vanua kauta namata deda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Delavuaia dediaka, “Siavu davanai vinaula katania ovavaita, maivaka dai siavu katania evenimu?” ");
INSERT INTO nrz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu ediaka, “Lau vaka lavuai ka bavenimui, bema anina oi bo'ou'u koanai dai ena siavuai vinaula katania avavai 'eva bavaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioane ena vaidi'u kabukabu 'eva vutuvutuai easi 'o kau kevatai easi? Oluva.” ");
INSERT INTO nrz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sibota viloatai delovaku vaia dediaka, “‘Ekadiaka vutuvutuai easi’ koanai belavuaita ‘Dava 'ounai sia oi ovamomo'aia?’ ");
INSERT INTO nrz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'O ekadiaka ‘Beia bema Kau kevatai easi.” Beia kau mo demakau vaita, 'olana kau boutai deikabasi Ioane 'eva enolea kauna umauna. ");
INSERT INTO nrz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ia Iesu de'ouia dediaka, “Sia lai aikabasi.” Iesu mune'e e'outa ediaka, “Lau vaka siavu davanai vinaula katania avavai 'eva sia bavaikabasimui.” ");
INSERT INTO nrz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu eta'u luva ivavitaitanai e'outa ediaka “Kau ka vine kulana evavaia, alana eko bubua, vine vuata ivakali mukamukata 'ulina eoia, mai ika kaona lumana evavaia. Kau vaida evenita be'imala, beia ia 'eva kalima eda'a. ");
INSERT INTO nrz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vine de'aiva koanai kau kanaua ena da'ala iabina kauna ka esinia eda'a kula de'imala kauta kevata. Vine anita vitalua kevatai be'abi. ");
INSERT INTO nrz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Beia kula i'imana kauta deta'u da'ala iabina kauna deabia kao, de'odia, desinia imana 'avaeana emue. ");
INSERT INTO nrz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mune'e 'ola kauna da'ala iabina kauna ka esinia eda'a kevata 'eva 'olana dekalaia ulu maivaka devamalalaia. ");
INSERT INTO nrz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mune'e ena da'ala iabina kauna ka esinia eda'a 'eva deaku bala. Doutamo esinita deda'a, vaida deaku si'ata, ia vaida 'eva deaku bata. ");
INSERT INTO nrz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ka'onamo emia besinia kauna 'eva nakuna elalo'au venia kauna. To'ona umaunai ia esinia, ediaka, ‘Naku'u kanania basinia bedada'a 'eva 'ani 'olana be'aku.’ ");
INSERT INTO nrz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Beia kula i'imana kauta delovaku, dediaka, ‘Omai, kanania 'eva kula 'ola kauna nakuna, kaku bala, ena kula kanania mai dava boutai 'eva ita etai be'ao.’ ");
INSERT INTO nrz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kanaua 'ounai deabia kao, deaku bala, kauanina dekapoia keini kula mulinai.” ");
INSERT INTO nrz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesu ia elavuaita ediaka, “Oi olalovaia, kula 'ola kauna 'eva dava bevavaia? Ia be'asi kula i'imana kauta beaku bata, vine kulana beabia kau vaida bevenita be'imala. ");
INSERT INTO nrz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Puka Kabukabunai deleleia davana sia oi ovakua? Kanania eluva koma, ‘Luma ivavaina kauta devaivivia bika'ana 'eva luma ivua 'inina kubuana bika'ana medianai e'ao. ");
INSERT INTO nrz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kanania 'eva Lovia namana evavaia, kaikala katabulovo!’” ");
INSERT INTO nrz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iuda kauta namata Iesu iliona delalovaia 'olana deikabasi luva ivavitaitana 'eva ia akatai eluvavaia. Beia kau demakau vaita 'ounai devikania deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muliai ia deta'u Palisea kauta mai 'Eloda enai de'au kauta vaida desinita deda'a Iesu kevana lavuailavuai ai bevaviua. ");
INSERT INTO nrz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inoku deda'a kevana delavuaia dediaka, “Vaikabasi kaumu e, lai aikabasi oni 'eva luva umauta oluluva, kau eta lalovai luvata sia omakau vaita, ia a boita lovata sia o'aku, beia Dilava ena dala umaunai mo ovaikabasi. Inoku tava ekaveni Kaisala kevanai 'eva ekomolo 'o asi'i? ");
INSERT INTO nrz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tava ekaveni 'o asi'i?” Beia Iesu eta dede kanaua eikabasia, elavuaita ediaka, “Dava 'ounai oi ovakovo'u! Moni ka oabia omai, baikaia.” ");
INSERT INTO nrz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Moni ka deabia deasi devenia 'eva elavuaita ediaka, “Kanania 'eva dai va'ava'ana? Mai dai vana?” Ia dediaka, “Kaisala.” ");
INSERT INTO nrz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu e'outa ediaka, “Kaisala ena Kaisala oi bovenia, Dilava ena Dilava oi bovenia.” Kanaua deika 'eva detabu lovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukea kauta ko'isi 'udai sia devamomo'aia kauta vaida eta lavuailavuai ka dainai deda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Delavuaia dediaka, “Vaikabasi kaumu e, Mose kanania eleleia koma, ‘Kau ka nakuna asi'i bebaba obuna bemimia, ba kauna kadina betata'u obu kanaua beadavala nakuna bevapuluta ba kauna nakunai beva aota.’ ");
INSERT INTO nrz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Inoku vali'u 'a'a kadi boutaina kalakoi ka. Batani kauna ekamoane, nakuna asi'i eba. ");
INSERT INTO nrz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kadina ivaluana obu kanaua eadavala, nakuna asi'i eba. Kadita ivakoina vaka kanaua boina kevanai epulu. ");
INSERT INTO nrz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kalakoi ka kataua ateate kanaua ka'onamo deadavala, beia sia ka nakuna ka evapulua inoku ia deba. To'onai ateate vaka eba. ");
INSERT INTO nrz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kau kalakoi ka boutaina deadavala, inoku ko'isi 'udai 'eva dai adana umaunai be'ao?” ");
INSERT INTO nrz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu e'outa ediaka, “Oi 'eva ova'eva 'olana Puka Kabukabuna anina sia oi oikabasia maivaka Dilava ena siavu sia oi oikabasia. ");
INSERT INTO nrz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ba kauta beko'isi koanai ia 'eva anelu vutuvutuai kauta boita, sia bekamoane. ");
INSERT INTO nrz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bai beko'isi 'udai luvana sia oi oikabasia, Mose ena Pukai sia oi ovakua? La'uka eani 'abunai Dilava Mose eluva venia, ‘Lau 'eva Abela'amo ena Dilava, Aisaka ena Dilava, Iakobo ena Dilava.’ ");
INSERT INTO nrz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ia 'eva sia ba kauta eta Dilava, beia mauli kauta eta Dilava. Oi boumuiai 'eva oi ova'eva.” ");
INSERT INTO nrz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Talavatu de'olavaia kauna ka ua'i eta viala 'uluna eika, eikabasi, Iesu kau kataua eta lavuai tavana evamuea kave'i. Inoku ia eta'u Iesu elavuaia ediaka, “Talavatu boutai davana 'eva talavatu katania boutai akatai emimia?” ");
INSERT INTO nrz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu e'ouia ediaka, “Boutai akatai 'eva kanania. ‘Isalaela kaumui e, lele oika. Lovia namana eta Dilava 'eva Lovia namana ka'onamo mo. ");
INSERT INTO nrz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lovia namana emu Dilava bolalo'au venia, mai nuamu bounai, mai idumemu bounai, mai emu lalovai bounai, mai kula'ilamu bounai.’ ");
INSERT INTO nrz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ivaluana 'eva kanania. ‘Kevamuai kauna vaka bolalo'au venia, sibomu olalo'au venimu boina.’ Talavatu ua'i ka sia emimia katania luana akatai.” ");
INSERT INTO nrz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kau kanaua eluva ediaka, “Vaikabasi kaumu e, oni 'eva okomolo. Oluva kave'i, Dilava 'eva ka'onamo mo, sia ka ua'i. ");
INSERT INTO nrz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Maivaka Dilava ekalalo'au venia mai nuata bounai, mai lalovaita bounai, mai kula'ilata bounai, kevata kauna ekalalo'au venia sibota kalalo'au venita boina, talavatu namavaikata 'eva veniveni i'abuta mai iakuba venivenita katania vinaulata boutai ekeinita.” ");
INSERT INTO nrz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu kau kanaua eikaia, eluva kave'i koanai e'ouia ediaka, “Oni mai Dilava ena lovia vanuana 'eva viloamui sia edau'a.” Kanaua mulinai kau ia belavuaia 'eva demakau. ");
INSERT INTO nrz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu Lo'e Kabukabuna laloanai evaikabasi koanai kau elavuaita ediaka, “Aeko 'ounai talavatu de'olavaia kauta dediaka ‘Keliso 'eva Davida Nakuna’? ");
INSERT INTO nrz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kanaua 'eva Idume Kabukabuna siavunai Davida nutunai eluva ediaka, ‘Lovia namana e'u lovia e'ouia ediaka, Idiba'u duasi mia beda'a mo emu 'ou kauta boutai aemu'abuna venunai bane'eta divo.’ ");
INSERT INTO nrz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davida sibona eta'u Keliso e'aeia ‘Lovia namana’ koanai, a mo boina Keliso nakunai be'ao?” Mato kaiata devala kauta mai lalonamata ia lelena deika. ");
INSERT INTO nrz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu mune'e evaikabasita 'udai, ediaka, “Talavatu de'olavaia kauta kevatai oi bo'imamui kave'i, ia 'eva tubu'a laka'ita devadodota dekeinikeini dalai mai tavatava 'abutai, eta ula 'eva kau ia beikata 'olata be'aku. ");
INSERT INTO nrz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mune'e lo'e laloatai eta ula mia'au nama'itai bemia'au, nadu laloatai maivaka 'abu namata nama'itai mo bemia'au. ");
INSERT INTO nrz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Obu eta luma devadoeta, eta meamea devalaka'i vaikata beikata 'ounai. Kau kataua boita 'eva mekau nama vaikana bedavalia.” ");
INSERT INTO nrz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu Lo'e Kabukabuna laloanai ainama mauana vailanai emia divo, do'u kauta eta moni mauai deuda eikata, lavo kauta doutamo 'eva eta moni doutamo deuda. ");
INSERT INTO nrz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Beia obu ulaluna ka easi, ena moni kikita lua eabita easi eudata, eta vitaita 'eva pene ka'onamo boina. ");
INSERT INTO nrz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu Ibanona kauta e'aeta deda'a kevana e'outa ediaka, “Luva umauna lau oi a'oumui, obu ulaluna kanaua eudala davana 'eva nama vaikana ia boutaina de'uda davata 'eva kikita. ");
INSERT INTO nrz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","'Olana lavo kauta eta moni doutamo beia kikita mo de'uda, obu ulaluna 'eva ena davali davana beaniani vaia davana itoinai eudala.” ");
INSERT INTO nrz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu Lo'e Kabukabunai ela'asi laloanai, ibanona kauna ka eta'u e'ouia ediaka, “Vaikabasi kaumu e, Lo'e Kabukabuna bika'a nama'ina vaikai devavaia, ikala!” ");
INSERT INTO nrz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu enu'ovi ediaka, “Luma nama vaikata katania o'ika? Boutai be'eko benodivo palu, be'ule tau, bika'a ka bika'a ka akanai sia beno'au sia bemimia.” ");
INSERT INTO nrz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu Olive lolonai emia divo Lo'e Kabukabuna evailala, Petelo, Iakobo, Ioane mai Andelea vaka deda'a kevana vunivuniai delavuaia. ");
INSERT INTO nrz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Vaikabasimai, dava katania aida bepupulu? Maivaka bepupulu bonina koana 'eva a boina?” ");
INSERT INTO nrz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu e'outa ediaka, “Oi bo'imamui kave'i, kau ka asi'i emalebamui. ");
INSERT INTO nrz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kau doutamo lau va'uai beasi beluluva bediaka, ‘Lau 'eva Keliso’, kau doutamo belebata. ");
INSERT INTO nrz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kuali 'uluta mai valita oi bo'ika koanai, nuamui sia bebabata, dava katania bepupulu, beia to'ona 'eva vailai. ");
INSERT INTO nrz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Iduvu ka beko'isi iduvu ka bekualia, kanobata ka beko'isi kanobata ka bekualia. Kanokau bedada'a 'abu edeata edeata, vikolo namata bepupulu. Katania 'eva itani melo epupulu anana lava'ana'ina boina. ");
INSERT INTO nrz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Sibomui oi bo'imamui kave'i. Beliomui valuva 'abutai bene'emuidivo, lo'e laloatai be'odimui. Lau dai'uai talavatu kauta mai kanobata loviata vailatai oi bolalava, kevatai vali'u oi bokakava. ");
INSERT INTO nrz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","To'ona 'eva sia be'asi beda'a mo vali nama'ina beilolo vaia iduvu boutai kevatai. ");
INSERT INTO nrz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Beliomui valuva 'abunai bene'emui divo koanai, dava oi bokoma luvana sia oi bolalovaia, melala bedaia bevenimui luvana mo oi boluvala, 'olana oi sia boluluva, beia Idume Kabukabuna beluluva. ");
INSERT INTO nrz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","'A'a kadi betata'u sibota venita beveveni kouta bekokou, kama betata'u nakuta venita beveveni kouta bekokou beaku bata. Naku betata'u sinata kamata bebo'o kaita beabita beda'a beaku bata. ");
INSERT INTO nrz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lau dai'uai kau boutai bebadu venimui, ia dai bevapasisi beda'a to'onai kauna 'eva bemauli. ");
INSERT INTO nrz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Vasi'avana mai vamakau kauna sia bemalava divo 'abunai belava divo oi boikala. (Vakuvaku kaumu, luva kanania anina boikabasia kave'i.) Melala kanaua'i Iudeai demimia kauta 'eva beveau lolo beda'ala. ");
INSERT INTO nrz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bema kau ka ena luma akanai ia 'eva sia be'ovu luma laloanai bedododo ena dava be'abi, ia beveau. ");
INSERT INTO nrz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lobai evinaula kauna vaka sia bemumue lumai ena tubu'a beabia. ");
INSERT INTO nrz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Melala kataua laloatai ateate mai bo'ata maivaka vadudu 'a'ateta kevatai 'eva besi'avana vaika. ");
INSERT INTO nrz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Oi bomeamea Dilava kevanai dava katania avala laloanai sia bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","'Olana melala kataua eta si'avana 'eva besi'avana vaika 'a Dilava kanobata evavaia makava melalanai easi mo vali'u melala kanania ena si'avana ita sia bevitaita, muliai vaka kataua boina ka sia bepulu 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bema Lovia namana melala kataua sia bemavato'ota 'eva ka sia bemamauli kovo, beia ia edilata kauta 'outai melala kataua bevato'ota. ");
INSERT INTO nrz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Melala kanaua'i kau ka bema 'oumui, ‘Oikaia, Keliso kanania’ 'o ‘Oikaia, Keliso kanaua’ 'eva sia oi bovamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Keliso dedeta mai enolea dedeta kauta be'asi, koa edeata edeata mai siavu edeata edeata bevavai, eta ula 'eva Dilava edilata kauta belebata, beia sia bedaita. ");
INSERT INTO nrz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kanaua 'ounai oi bo'imamui kave'i, vailai bepulu davata boutai 'ani avaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Si'avana kataua be'ole mulinai, Melala 'eva bevabula avu, maivaka vuia sia bekakala. ");
INSERT INTO nrz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Visiu vutuvutuai be'ekoasi, maivaka vutuvutuai siavu davata edeata edeata be'iuvai'iuvai. ");
INSERT INTO nrz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Melala kanaua'i kau 'eva lau Kau Nakuna beika'u oli akanai ba'asi mai siavu'u maivaka mai nuavi'u. ");
INSERT INTO nrz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","E'u anelu basinita beda'a 'unipuata vani lani de'asi 'abutai, adilata kauta bevado'uta kanobata si'ana beda'a si'ana. ");
INSERT INTO nrz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“'Ova kevanai ikaika nama'ina oi boikala, 'Ova bedidimu uauana makamakata oi boikata 'eva oi boikabasi vikau 'ani ekevai. ");
INSERT INTO nrz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Oi vaka dava katana boita oi boikata koanai oi boikabasi ia ena mue'udai 'ani ekevai nutuala aunai. ");
INSERT INTO nrz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Luva umauna lau oi a'oumui, ulu kanania sia be'ole beda'a mo dava katania boutai bepupulu. ");
INSERT INTO nrz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Vutuvutu mai kanobata betaule, beia lau e'u luva 'eva sia betaule. ");
INSERT INTO nrz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Melala koana 'o bonina kau ka sia eikabasia, ena anelu vutuvutuai sia deikabasia, Nakuna vaka sia eikabasia, beia Kamana sibona mo eikabasia. ");
INSERT INTO nrz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Makamui be'ata, oi bovi'ima, melalana be'asi 'eva oi sia oikabasia. ");
INSERT INTO nrz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Vitaitana kau ka kalima eda'a koanai, ena da'alabi kauta siavu evenita ena luma be'imala, ka ka eta vinaula bevavai maivaka nutuala i'imana kauna e'ouia makana be'ata bevi'ima. ");
INSERT INTO nrz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kanaua 'ounai oi bovi'ima, 'olana luma kauna ena mue 'eva sia oi oikabasia, boniai, maloluai, 'o'oloko ena 'alalai, 'o 'avu'avu avekenai be'asi. ");
INSERT INTO nrz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bema ia bevada'unai be'asi itani, muinai tabumuiai asi'i emadavalimui. ");
INSERT INTO nrz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oi a'oumui luvana kau boutai vaka a'outa adiaka, ‘Makamui be'ata!’” ");
INSERT INTO nrz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Melala luamo vailai demia La'au keini mai Palaoa 'avaeana naduna. Kabukabu kauta namata mai talavatu de'olavaia kauta vunivuniai dala dekavu Iesu beabia beaku bala. ");
INSERT INTO nrz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dediaka, “Ita nadu kanaua laloanai sia ekavavaia. Kau asi'i 'ulu namana demavavaia ounai.” ");
INSERT INTO nrz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu 'eva Betaniai, loki kauna Simona ena lumai, ua'i eaniani laloanai, ateate ka deolo vana Nado bonana mediana maivaka tavana nama vaikana davana kavapuna nama'ina vaika eabia eda'a. Inoku kavapuna eaku papala Iesu 'olanai esisia. ");
INSERT INTO nrz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kau vaida ua'i 'eva debadu, sibota deluvaluva dediaka, “Dava 'ounai deolo kanania evaolea 'avaea? ");
INSERT INTO nrz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bematavatava vaia ama'i denali sinavu koi bemadavali, monina kanaua 'eva ta'ovala kauta bemavenita.” Ia ateate kanaua de'ovenia si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Beia Iesu e'outa ediaka, “Ovikania! Dava 'ounai oi obadu venia? Ia 'eva vinaula nama'ina lau keva'uai evavaia. ");
INSERT INTO nrz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ta'ovala kauta 'eva melala bounai kevamuiai demimia, oi bo'ula koanai melala doutamo emui vanama'ina davata oi bovenita. Beia lau 'eva melala bounai kevamuiai sia bamimia. ");
INSERT INTO nrz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ena kula'ila vitaitanai keva'uai evavaia. Asido'o dekole'u, ia kau'u deoloai eukua, vailai bepupulu davana 'eva eva'olua vaika. ");
INSERT INTO nrz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Luva umauna lau oi a'oumui, a'ia'i Vali Nama'ina beilolo vaia kanobata itoinai ateate kanania vaka vinaula evavaia vinaulana beluvavaia, ia ilalovaina.” ");
INSERT INTO nrz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kaliote kauna Iuda 'ouka lua kauta banota ka eda'a kabukabu kauta namata kevatai Iesu venina beveveni mai kouna bekokou. ");
INSERT INTO nrz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kabukabu kauta namata Iuda kevanai 'ulu kanaua deika 'eva lalota denama si'asi'a, deluva 'ana'i moni bevenia, kanaua 'ounai Iuda dala ekavu, dala nama'ina davanai 'eva Iesu kabukabu kauta namata imatai beudala beabia. ");
INSERT INTO nrz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Palaoa 'avaeana naduna melalana lava'ana'ina La'au keini ianina mamoeta iaku bata melalanai, Iesu ibanona kauta delavuaia dediaka, “Olalovaia La'au keini ianina a'i lai bava'olua boania?” ");
INSERT INTO nrz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iesu ibanona kauta lalua esinita, ediaka, “Oi boda'a vanua laloanai oi boda'a dodo, ua'i kau ka oi boikala vodu mai veina bevuala, mulinai oi bodada'a. ");
INSERT INTO nrz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bedodo lumanai luma biakuna oi bo'oua bodiaka, ‘Vaikabasi kauna elavuai, da'a'au laloana a'ia'i? Ibano'u kauta ita La'au keini naduna ianina lai bania.’ ");
INSERT INTO nrz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Inoku ia sibona laloa namana ka akai 'ani e'olu davana bevaikamui. Ua'i eta iani oi bova'olua.” ");
INSERT INTO nrz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ibanona kauta laluana deda'a, vanua laloanai deda'adodo 'eva Iesu e'outa davata boutai dedavalita. La'au keini ianina deva'olua. ");
INSERT INTO nrz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lavilavi eda'a venia koanai, Iesu ibanona kauta 'ouka lua ita deasi. ");
INSERT INTO nrz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aniani 'abunai demiadivo deaniani laloanai, Iesu e'outa ediaka, “Luva umauna lau oi a'oumui, viloamuiai laluana lai aniani ka'ona kauna lau veni'u beveveni kou'u bekokou.” ");
INSERT INTO nrz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ibanona kauta nuata debavunu, ka ka delavuaia, “Olalovaia lau, 'o?” ");
INSERT INTO nrz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu eta luva evamuea ediaka, “Oi 'ouka lua kaumui ka, laluana nau ka'onamoai lai akao uda kauna. ");
INSERT INTO nrz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Lau Kau Nakuna 'eva bababa Puka Kabukabunai eleleia vitaitana, beia lau Kau Nakuna veni'u beveveni kou'u bekokou kauna 'eva ilalona mo, si'avana nama vaikana bedavalia, sia bemapulu 'eva bemanama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Deaniani laloanai, Iesu palaoa eabia, Dilava evanama'inala inoku ekovia, ibanona kauta evenita, ediaka, “Oabia, oania! Kanania 'eva lau kauani'u.” ");
INSERT INTO nrz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mune'e 'ou eabia, Dilava evanama'inala ibanona kauta evenita, boutai deinuia. ");
INSERT INTO nrz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iesu ediaka, “Kanania 'eva lau lala'u kau doutamo daitai be'itabu. Lau lala'u 'eva kau mai Dilava eta vaka'ona luva'ana'ina makamakana ivamomo'aina koana. ");
INSERT INTO nrz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lau oi a'oumui, vine veina ka sia bainua 'udai beda'amo Dilava ena lovia vanuana laloanai makamakana bainua.” ");
INSERT INTO nrz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Masi ka deabia eole mulinai, dela'asi deda'a Olive lolona. ");
INSERT INTO nrz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu ibanona kauta e'outa ediaka, “Boumuiai oi bovikani'u oi boveau siusiu, 'olana Puka Kabukabunai deleleia, ‘Lau mamoe i'imata kauna bako bala, kanaua'i mamoe bounai beveau siusiu.’ ");
INSERT INTO nrz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Beia lau bai bako'isi 'udai mulinai ba'ana'ia bada'a Kalilea.” ");
INSERT INTO nrz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petelo Iesu e'ouia ediaka, “Bema bano'u katania boutai oni bevikanimu, beia lau 'eva sia bavikanimu kovo.” ");
INSERT INTO nrz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu Petelo e'ouia ediaka, “Luva umauna lau oni a'oumu, vali'u boni kanania o'oloko ivaluana asido'o be'alala laloanai, oni melala koi lau bo'ou'u avuavu.” ");
INSERT INTO nrz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Beia Petelo eluva pasisi ediaka, “Bema ita laluana eka ba ka'ona, lau oni sia ba'oumu avuavu.” Ibanona kauta boutai vaka kanaua deluva koma. ");
INSERT INTO nrz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Abu ka vana Ketesemaneai dela'asi. Kanaua'i Iesu ibanona kauta e'outa ediaka, “Oi nia'i omia, lau bada'a bameamea.” ");
INSERT INTO nrz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Inoku Petelo, Iakobo, mai Ioane mo evada'ata, ia nuana eanana maivaka ebavunu. ");
INSERT INTO nrz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kanaua 'ounai e'outa ediaka, “Lau 'eva idume'u eanana itani bamaba mo boina. Nia'i oi bomimia, makamui be'ata oi bovi'ima.” ");
INSERT INTO nrz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kava'ina mo eilulao eda'a, inoku kanoai epakadivo emeamea, bema mai dalana anana bonina kanaua ia kevanai bema da'a tau. ");
INSERT INTO nrz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ia emeamea ediaka, “Kama'u e, Kama'u e, dava boutai kele'emuai 'eva dedaia. 'Ou kanania kele'e'uai bomabia tau. Sia lau e'u ula, beia oni emu ulai.” ");
INSERT INTO nrz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iesu emue easi ibanona kauta koi muinai tabutai edavalita, ia Petelo e'ouia ediaka, “Simona e, oni omuinai, una? Melala kikinamo makamu demata bomavi'ima bemadaia 'o asi'i? ");
INSERT INTO nrz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oi bomeamea oi bovi'ima, 'olana vikovoai asi'i oi omadodo. Nuamu 'eva eula vaika, beia kauanimu 'eva ebade bade.” ");
INSERT INTO nrz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mune'e emue eda'a emeamea, ena meamea luvata ka'oka'omo eluvata 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Emue easi koanai, kauta koi muinai tabutai edavalita, 'olana makata demuinai 'ounai, luva dava be'oua 'eva sia deikabasi. ");
INSERT INTO nrz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Melala ivakoina emue easi, e'outa ediaka, “Oi omuinai do'o mai lamui oi o'ani? 'Ani edaia, bonina 'ani ela'asi. Kau Nakuna 'eva si'avana kauta imatai 'ani enouda. ");
INSERT INTO nrz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oko'isi kada'a, veni'u eveni kou'u ekou kauna 'ani e'asi.” ");
INSERT INTO nrz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu eluva do'o mo laloanai, Iuda 'ouka lua kauta banota ka ela'asi, mato namana imata mai ukuta maivaka mai kuali lepota mulinai deda'a, boutai 'eva kabukabu kauta namata mai talavatu de'olavaia kauta mai vanua kauta namata desinita deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Venina eveni mai kouna ekou kauna mato kanaua 'ani e'outa ediaka, “Baba'ua kauna 'eva kauna kanaua oi bolioa oi boabia bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iuda ela'asi komolonai eda'a Iesu kevana, ediaka, “Vaikabasi kaumu e.” Inoku eba'uia. ");
INSERT INTO nrz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mulinai Iesu deabia inoku delioia. ");
INSERT INTO nrz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Inoku Iesu ita delava ka'ona kauna ka eko'isi lepo evelia asi kabukabu kauta 'olatai kauna ena da'alabi kauna kaiana ekalaia ovo. ");
INSERT INTO nrz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu e'outa ediaka, “Oi imamui mai kuali lepota mai ukuta oi o'asi lau oi boabi'u vitaitana lau 'eva vinaovinao kau'u. ");
INSERT INTO nrz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Melala boutai lau 'eva oi ita Lo'e Kabukabuna laloanai avaikabasi, beia sia oi oabi'u. Kanania 'eva Puka Kabukabunai deleleia 'ana'i luvana bemomo'ai dainai.” ");
INSERT INTO nrz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kanaua'i ibanona kauta boutai Iesu devikania deveau siusiu. ");
INSERT INTO nrz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kau 'alu'aluna ka Iesu mulinai eda'a, tubu'a ka'onamo mo evadodoa. Kau kanaua delioia koanai, ");
INSERT INTO nrz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ena tubu'a imatai evikania inoku kauna 'avaeana eveau ovo. ");
INSERT INTO nrz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ia Iesu devada'ala deda'a kabukabu kauta 'olatai kauna kevana, inoku kabukabu kauta namata, vanua kauta namata mai talavatu de'olavaia kauta boutai ua'i dedo'u. ");
INSERT INTO nrz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petelo 'eva Iesu mulinai eda'a, beia mai viloata deda'amona kabukabu kauta 'olatai kauna ena ala laloanai, ua'i vi'ima kauta vaida ita demia ka'ona, 'alova enanaia. ");
INSERT INTO nrz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kanaua'i kabukabu kauta namata mai Iuda eta lovia kauta Iesu ivabana dalana dekavuia, beia va'eva ka sia dedavalia. ");
INSERT INTO nrz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kau doutamo vaika oukeinikeini luvata dedeta deluva kevanai, beia eta oukeinikeini luvata 'eva ka sia emomo'ai. ");
INSERT INTO nrz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kau vaida mune'e deko'isi eta dede luvana deluvaia Iesu kevanai, dediaka, ");
INSERT INTO nrz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Lai lelena aika, ediaka, ‘Lau Lo'e Kabukabuna kanania kau imatai devavaia davana 'eva baluvua, melala koi laloanai kau imatai sia bedaua Lo'ena Kabukabuna ka badaua.’” ");
INSERT INTO nrz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Beia eta dede luvata katania vaka sia demomo'ai. ");
INSERT INTO nrz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Inoku kabukabu kauta 'olatai kauna eko'isi kau vailatai elavadivo Iesu elavuaia ediaka, “Oni emu luva ka 'o asi'i boluvala luva katania deluluva akatai?” ");
INSERT INTO nrz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Beia Iesu sia luva ka eluvaia maivaka ena luva sia evamuea. Kabukabu kauta 'olatai kauna mune'e elavuai 'udai ediaka, “Oni Keliso, devanama'inala Dilavana Nakuna, una?” ");
INSERT INTO nrz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu ediaka, “Lau mo kau'u kanania, boumuiai 'eva lau Kau Nakuna oi boika'u akaiai siavu boutai Dilavana imana idibanai bamiadivo inoku vutuvutu olinai ba'asi.” ");
INSERT INTO nrz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kabukabu kauta 'olatai kauna luva kanaua 'uluna eika koanai nuana e'avala si'asi'a, sibona ena tubu'a e'idia, evaoi ediaka, “Luva davana kakavua? ");
INSERT INTO nrz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dilava evasi'avanala luvana 'ani oi oika, emui lalovai 'eva dava?” Ia boutai dediaka, bebaba. ");
INSERT INTO nrz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Inoku vaida Iesu de'anodia mai makana de'apa avu maivaka deakuia, delavuai dediaka, “Luva, dai eakumu?” Vi'ima kauta vaka depi'aia. ");
INSERT INTO nrz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petelo 'eva ala laloanai koanai, kabukabu kauta 'olatai kauna ena da'alabi vatona ka easi. ");
INSERT INTO nrz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ia Petelo 'alova enanaia eikaia koanai, eikaia basibasi e'ouia ediaka, “Oni vaka Nasaleta kauna Iesu obanoia.” ");
INSERT INTO nrz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Beia Petelo 'eva e'ou avuavu ediaka, “Dava luvana oluluva davana 'eva lau sia aikabasia.” Inoku eda'atau eda'a nutuala aunai. ");
INSERT INTO nrz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Da'alabi vatona kanaua mune'e eikaia 'udai koanai, vialulu kauta e'outa ediaka, “Kau kanania 'eva ia banota ka.” ");
INSERT INTO nrz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ia mune'e e'ou avuavu. Sia edau'a laloanai Petelo ita delava ka'ona kauta de'ouia dediaka, “Luva umauna, oni vaka ia banota ka. 'Olana oni vaka Kalilea kaumu.” ");
INSERT INTO nrz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Inoku Petelo ia eluva pasisi venita ediaka, “Oi dava o'oua davana 'eva lau sia aikabasi. Bema adedede koanai Dilava bevaanana'u.” ");
INSERT INTO nrz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Inoku 'o'oloko ivaluana e'alala. Kanaua'i Petelo Iesu e'ouia luvana elaloiaune, ‘'O'oloko ivaluana asido'o be'alala laloanai, oni melala koi bo'ou'u avuavu.’ Inoku Petelo ekani. ");
INSERT INTO nrz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Avu'avuni vabulanai kabukabu kauta namata, vanua kauta namata, talavatu de'olavaia kauta mai do'u kauta boutai dedo'u molau luva devaka'onamoa. Iesu delioia deda'a Pilato devenia. ");
INSERT INTO nrz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Iesu elavuaia ediaka, “Oni Iuda kauta eta Lovia 'olana kaumu, una?” Iesu enu'ovi ediaka, “'Ani oluva mo kanaua.” ");
INSERT INTO nrz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kabukabu kauta namata luva doutamo Iesu akanai deluvavai. ");
INSERT INTO nrz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato mune'e Iesu elavuaia 'udai ediaka, “Oni sia boluluva, una? Oni oikabasi luva edeata edeata oni akamuai deluvavai.” ");
INSERT INTO nrz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Beia Iesu sia luva ka evamuea, kanaua 'ounai Pilato elaloto'ato'a. ");
INSERT INTO nrz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato ena koakoa melala bounai nadu laloatai vabuto'o kauna ka deula venia kauna 'eva evala'asia. ");
INSERT INTO nrz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Melala kanaua'i kau ka vana Balaba devavabuto'oa. Ia 'eva Loma kauta ita 'ou deviabi viveni, viaku laloanai kau vaida eaku bata. ");
INSERT INTO nrz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Inoku do'u kauta Pilato denoia melala bounai koakoa kanaua evavaia davana bevavaia. ");
INSERT INTO nrz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato elavuaita ediaka, “Oi o'ula Iuda Lovia 'olana kauna bavala'asia?” ");
INSERT INTO nrz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","'Olana Pilato 'ani eikabasi kabukabu kauta namata 'eva Iesu demama venia 'ounai deabia ia imanai deudaia. ");
INSERT INTO nrz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Beia kabukabu kauta namata deko'isi do'u kauta devasiasita bediaka, Pilato Balaba bevala'asia ia Iesu 'eva bemimia. ");
INSERT INTO nrz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato do'u kauta elavuaita 'udai ediaka, “Oi o'ula dava Iuda eta lovia 'olana oi okoma kauna kevanai bavavaia?” ");
INSERT INTO nrz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Boutai devaoi, “Au ido'o valaukuna akanai vabaia!” ");
INSERT INTO nrz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato elavuaita 'udai ediaka, “Dava 'ounai, ena va'eva dava?” Beia ia devaoi 'unu'unu dediaka, “Au ido'o valaukuna akanai vabala!” ");
INSERT INTO nrz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato eula mato nuata bevanama'ina 'ounai Balaba eluvuia. Iesu e'odia kuali kauta evenita au ido'o valaukuna akanai beaku bala. ");
INSERT INTO nrz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kuali kauta Iesu devada'ala deda'a talavatu lumana namana laloanai ua'i eta kau boutai devado'uta. ");
INSERT INTO nrz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tubu'a 'aolana devavadodoia maivaka 'ini auma deabia devakuia 'olanai dene'eia 'au. ");
INSERT INTO nrz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eta vabo'obo'o demakavala dediaka, “Iuda lovia 'olana e, bomia keinikeini.” ");
INSERT INTO nrz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Moloveai 'olana de'odia de'anodia, vailanai dekuidula dekukudivo venia dededede. ");
INSERT INTO nrz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Devabo'oa mulinai, tubu'a 'aolana kaunai devadadala asi, ena tubu'a umauna devavadodoia devala'asia au ido'o valaukuna akanai beaku bala deko deda'a. ");
INSERT INTO nrz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kulene kauna ka vana Simona 'uniai easi Ielusalema kokona eda'a, ia 'eva Alesanda mai Lufo kamata. Kuali kauta Simona ita devidavali koanai devasiasia Iesu ena au ido'o valaukuna bevuala. ");
INSERT INTO nrz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iesu devada'ala deda'a 'abu ka vana Kolokota, anina 'eva, 'Ola Kuliana 'Abuna. ");
INSERT INTO nrz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ia vine veina vamaina mai anana ivakikina mulamulana itana deiu lavo'i devenia beinua, beia Iesu 'eva sia einuia. ");
INSERT INTO nrz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Inoku Iesu au ido'o valaukuna akanai dekokoia au. Eole mulinai kuali kauta ena tubu'a punipuniai dekoleta deito dai 'eva davana beabia. ");
INSERT INTO nrz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","'Avu'avuni melala esiavu laloanai (9 a.m.) Iesu au ido'o valaukuna akanai dekokoia au. ");
INSERT INTO nrz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ia 'olana akanai va'eva malelena kanania deleleia koma. ‘Iuda kauta eta Lovia 'olana.’ ");
INSERT INTO nrz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vinaovinao kauta lalua Iesu ita melala ka'onamo au ido'o valaukuta akatai dekokota 'au, ka idibanai ka 'ealinai. ");
INSERT INTO nrz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Puka Kabukabuna luvana 'ani emomo'ai ediaka, ‘Si'avana kauta ita devakuta ka'ona.’ ");
INSERT INTO nrz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dekeinikeini kauta luva si'avata vaika de'ouia, maivaka 'olata deka'eka'e dediaka, “Oni kaumu kanania odiaka Lo'e Kabukabuna boluvua inoku boni koi laloatai bodaua 'udai. ");
INSERT INTO nrz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Vali'u kanana'i au ido'o valaukuna akanai 'ovu, sibomu vamaulimu!” ");
INSERT INTO nrz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Dala vitaitanai mo kabukabu kauta namata mai talavatu de'olavaia kauta Iesu demedia media vaia dediaka, “Kau vaida evamaulita, beia sibona bevamaulia 'eva sia edaia. ");
INSERT INTO nrz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keliso Isalaela eta Lovia 'olana, vali'u ua'i au ido'o valaukuna akanai e'ovu kaikaia maivaka ekavamomo'aia.” Iesu ita au ido'o valaukuna akanai dekokota 'au kauta laluana vaka kevanai luva si'ava vaikata deluva. ");
INSERT INTO nrz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ado'alavuni umaunai kanobata itoinai evabula avu eda'a mo melala elava keini koana koi boina. ");
INSERT INTO nrz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Melala vitaitanaimo Iesu e'ae'ae 'unu'unu ediaka, “Eloi Eloi, lama sabakatani?” Anina 'eva ‘E'u Dilava e, E'u Dilava e, dava 'ounai ovikani'u?’ ");
INSERT INTO nrz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kevanai delava kauta vaida Iesu lelena deika, dediaka, “Kaiamui ovala, ia 'eva Elia e'aea.” ");
INSERT INTO nrz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kau ka eveau eda'a dapulu eabia vine veina vamaina laloanai ekaoia uku, silibo ai ekoia 'au inoku eisia 'au Iesu evenia beinua inoku ediaka, “Kavi'ima kaikaia. Elia ama'i be'asi beabia ovo.” ");
INSERT INTO nrz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu evaoi 'unu'unu inoku eba. ");
INSERT INTO nrz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Melala kanaua'i Lo'e Kabukabuna laloana tubu'ana bo'adanai e'idi luala akai e'ovu eda'a venu. ");
INSERT INTO nrz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kuali de'olavaia kauna ka Iesu kevanai vaika elavadivo eikaia ia evaoi lelena eika, kanaua eba koma eikaia koanai ediaka, “Kau kanania 'eva Dilava Nakuna umauna.” ");
INSERT INTO nrz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","'A'ate vaida 'eva dau'ai delava devialulu, viloatai 'eva Makadala ateatena Malia Iakobo kikina Iosepa ita sinata Malia mai Salome. ");
INSERT INTO nrz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'A'ate katania 'eva Kalileai Iesu mulinai deda'a deduluia. Iesu ita Ielusalemai dela'asi ka'ona 'a'ateta doutamo vaka 'eva ua'i. ");
INSERT INTO nrz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Melala kanaua 'eva va'olu melalana, belani 'eva Melala Kabukabuna. Melala 'ani be'ulu ekoma koanai, ");
INSERT INTO nrz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimatea kauna Iosepa nuana ebubuia eda'a Pilato vailanai enoia Iesu kauanina dainai. Ia 'eva Iuda eta lovia 'olana kauna ka kau vaka 'olana de'aku, Dilava ena lovia vanuana be'asi e'imala kauna ka. ");
INSERT INTO nrz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato Iesu alimo eba valina eika koanai etabulovo si'asi'a. Ia eko'isi kuali e'olavaia kauna e'aeia Iesu ena ba melalana elavuai lavuai vaia. ");
INSERT INTO nrz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato Iesu ena ba 'uluna kuali e'olavaia kauna kevanai eika koanai, ia Iosepa e'ouia Iesu kauanina beabia. ");
INSERT INTO nrz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iosepa tubu'a nama'ina ka etavaia, Iesu kauanina eabia ovo tubu'a kanaua'i e'umia evuaia eda'a mitava bika'a ioi vaikana laloanai ene'eia divo, bika'a namana ka eva'ulea inoku e'alavua. ");
INSERT INTO nrz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makadala ateatena Malia mai Iosepa sinana Malia laluana Iesu kauanina dene'eiadivo 'abuna deikaia. ");
INSERT INTO nrz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Melala Kabukabuna eole mulinai Makadala ateatena Malia Iakobo sinana Malia mai Salome deolo bonata mediata detava beda'a Iesu kauanina beukua. ");
INSERT INTO nrz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Masi melalana 'avu'avu vabulanai, melala edae laloanai, 'a'ate kataua dala ai deda'a mitava kokona deda'a koanai, ");
INSERT INTO nrz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","sibota deluvaluva dediaka, “Dai beduluta, mitava nutualana bika'ana bedolia tau.” ");
INSERT INTO nrz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Beia dekailao koanai, mitava nutualana bika'a nama vaikana 'ani idoli tauna deikaia. ");
INSERT INTO nrz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ia mitava laloanai deda'a dodo 'eva kau 'alu'aluna ka tubu'a deva'ita evadodo idiba duasi emia divo deikaia koanai demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kau kanaua ediaka, “Sia omakau. Oi Nasaleta kauna Iesu dekokoia 'au kauna oi okavua. Ia 'eva 'ani eko'isi. Sia nia'i. Dene'eia divo 'abuna oikaia. ");
INSERT INTO nrz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oda'a ibanona kauta mai Petelo oi bo'outa, oi bodiaka, ‘Oi boda'a Kalileai, Iesu 'ani be'ana'ia ua'i, oi boikala eluva vitaitanai!’” ");
INSERT INTO nrz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kanaua 'ounai 'a'ate kataua dela'asi mitava devikania mai lalovailalovaita maivaka mai makauta. Demakau 'ounai sia kau ka de'ouia. ");
INSERT INTO nrz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Masi melalana 'avu'avuni vabulanai, Iesu ba ai eko'isi mulinai, Makadala ateatena Malia kevanai ela'asi makava, ia 'eva 'ana'inai Iesu ka'uba si'avata vaika kalakoi ka nuanai elo'ota asi ateatena. ");
INSERT INTO nrz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Makadala ateatena Malia eda'a Iesu debanoia kauta devilalo dekani kevatai Iesu valina ekava. ");
INSERT INTO nrz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Malia kevanai vali deika Iesu 'ani emauli, mune'e eikaia ekoma, beia ena luva sia deabia dae. ");
INSERT INTO nrz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Muliai kau lalua dalai deda'a 'uni laloanai Iesu ikana evaedeaia kevatai ela'asi. ");
INSERT INTO nrz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Inoku laluana demue deda'a banota vailatai deluva. Beia ia vaka sia devamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kanaua mulinai kauta 'ouka ka deaniani laloanai, Iesu ela'asi kevatai. Eta abiveni asi'i maivaka eta nua pasisi 'ounai e'ovenita. 'Olana eko'isi 'udai mulinai deikaia kauta leleta sia devamomo'ai. ");
INSERT INTO nrz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Inoku ia e'outa ediaka, “Oi boda'a kanobata itoinai Vali Nama'ina kau boutai kevatai oi boilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Eabiveni mai eidi'u kabukabu kauna 'eva mauli beabia, beia sia eabiveni kauna 'eva mekau bekoala. ");
INSERT INTO nrz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Deabiveni'u kauta 'eva siavu vinaulata katania boita bevavai. Lau va'uai ka'uba si'avata vaika belo'olo'ota asi, maivaka mala edeata edeatai beluluva, ");
INSERT INTO nrz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","imatai kau'asi beabita mai mulamula si'avata vaika be'inu, beia kevatai sia dava ka bepupulu, maivaka imata 'olele kauta akatai bekao'au 'eva eta 'olele benama'ina.” ");
INSERT INTO nrz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lovia namana Iesu ia e'outa mulinai, ele'au eda'a vutuvutu, Dilava idibana duasi emia divo. ");
INSERT INTO nrz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ibanona kauta boutai ua'i dela'asi 'abu boutai laloatai deilolo. Lovia namana 'eva ia kevatai 'ounai koa edeata edeata devavai, vinaula kataua'i eta ilolo evamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lovia kaumu Teofilo e. Kau doutamo viloamaiai dava umauta 'ani depulu davata deleleta, ");
INSERT INTO nrz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","kau kataua makavanai vinaula kanania makata ai deikaia mai deilolo vaia davata vitaitata de'oumai. ");
INSERT INTO nrz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lau vaka makavana umaunai emakavalai depulu luvata boutai akavu kave'i. Inoku alalovaia enama'ina 'ounai oni emu malele ka balelea. ");
INSERT INTO nrz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kanaua 'ounai oi boikabasi komolo dava devaikabasimu luvata 'eva umauta. ");
INSERT INTO nrz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","'Eloda Iuda eloviala melalanai kabukabu kauna ka ua'i vana Sakalia, Abia ena iduvu kauna, adana Elisabeta 'eva Alona ena pulu ai easi ateatena. ");
INSERT INTO nrz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ia laluana 'eva vinaula komolo kauta Dilava vailanai, Lovia namana ena talavatu mai vaidiba de'ima kave'i, si'avana sia ka devavaia. ");
INSERT INTO nrz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Beia ia laluana 'eva nakuta asi'i 'olana Elisabeta 'eva e'opa'opa mai laluana 'eva 'ani demotu. ");
INSERT INTO nrz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sakalia ena iduvu kauta eta vinaula melalanai, ia eta'u kabukabu vinaulata evavai Dilava vailanai. ");
INSERT INTO nrz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kabukabu kauta eta koakoa daitai, punipuniai ia deabia isi Lovia namana ena lo'e kabukabuna laloanai bedododo mulamula bonana mediana be'abua. ");
INSERT INTO nrz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","I'abuna melalana edaia koanai, meamea kauta boutai mulimuliai deakubou demeamea. ");
INSERT INTO nrz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lovia namana ena anelu ka Sakalia kevanai evailaasi mulamula bonana mediana i'abuna valana avekenai idibana duasi elava. ");
INSERT INTO nrz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakalia anelu eikaia koanai, nuana ebata maivaka emakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Beia anelu ia e'ouia ediaka, “Sakalia e, sia bomakau. Emu meamea 'uluna 'eva Dilava 'ani eika, oni adamu Elisabeta 'eva nakumu moluanena ka bevapulua, inoku oni ia vana bo'aea Ioane. ");
INSERT INTO nrz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lalomu 'eva benanama, mai bolalonama si'asi'a, kau mato vaka ena puluai belalonama. ");
INSERT INTO nrz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","'Olana Lovia namana vailanai ia 'eva namana be'ao, vine 'o mulamula pasisita sia be'inu, maivaka sinana bo'anai asido'o bepupulu laloanai Idume Kabukabunai bevovonu. ");
INSERT INTO nrz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ia betata'u Isalaela kauta doutamo vaika bevalalota 'udai Lovia namana eta Dilava kevana beda'ala. ");
INSERT INTO nrz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Be'ana'ia Lovia namana vailanai Elia idumena mai ena siavu vitaitanai, kama mai naku nuata bevaka'onamota, mai lele sia de'ika kauta komolo kauta eta aoneka dalanai bevada'ata, kau beva'oluta Lovia namana ena.” ");
INSERT INTO nrz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakalia anelu elavuaia ediaka, “Kanania 'eva a baikabasi kave'i koma? Lau 'eva 'ani amotu mai ada'u vaka 'ani emotu.” ");
INSERT INTO nrz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anelu ena luva 'evamuea ediaka, “Lau 'eva Kabiela, Dilava vailanai alalava, esini'u vali nama'ina kanania abia a'asi kevamu bavaikamasimu. ");
INSERT INTO nrz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vali'u oni 'eva malamu besi'avana mai sia boluvaluva beda'amo dava katania eta pulu melalana bedaia. 'Olana e'u luva melala kanaua'i bemomo'ai luvana 'eva sia ovamomo'aia 'ounai.” ");
INSERT INTO nrz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kau 'eva Sakalia de'ima vunua maivaka nuata debavunu 'olana lo'e kabukabuna laloanai emia dau'a. ");
INSERT INTO nrz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ia ela'asi koanai, beluluva 'eva sia edaia. Kanaua 'ounai deikabasi ia 'eva lo'e kabukabuna laloanai dava ka eikaia. Koakoa mo imanai evavai beia sia eluvaluva. ");
INSERT INTO nrz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ena vinaula melalana evaolea koanai, ia emue eda'a ena luma. ");
INSERT INTO nrz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kanaua mulinai ia adana Elisabeta esivabu inoku vuia ima luma laloanai mo emia. ");
INSERT INTO nrz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Eluva ediaka, “Kanania 'eva Lovia namana ena ula koana keva'uai, kau viloatai e'u malalai beabia tau.” ");
INSERT INTO nrz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeta vuiana kalakoi laloanai Dilava eta'u anelu ka vana Kabiela esinia eda'a Kalilea laloanai vanua ka vana Nasaletai. ");
INSERT INTO nrz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Vato ka ua'i deluva'ana'i vaia kau ka beadavala, vana Iosepa Davida ena pulu ai easi, vato kanaua vana 'eva Malia. ");
INSERT INTO nrz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anelu eda'a kevana e'ouia ediaka, “Lalomu benanama. Oni 'eva eula venimu vaika. Lovia namana 'eva oni kevamuai.” ");
INSERT INTO nrz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Luva kanaua Malia nuana evabavunua, mai elalovai lalovai vanama'ina kanaua anina 'eva dava. ");
INSERT INTO nrz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Beia anelu ia e'ouia ediaka, “Malia e, sia bomakau, Dilava ena ula 'ani oabia. ");
INSERT INTO nrz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oni 'eva bosivabu inoku melo moluanena ka bovapulua, inoku vana bo'aea Iesu. ");
INSERT INTO nrz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia 'eva beakai vaika mai be'aea Akai vaika Kauna Nakuna, Dilava Lovia namana betata'u 'ava'avana Davida ena lovia bevenia. ");
INSERT INTO nrz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mai ia Iakobo ena iduvu beloviala keinikeini, ena lovia vanuana 'eva sia bepupua.” ");
INSERT INTO nrz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia anelu e'ouia ediaka, “Lau kau ka sia aikabasia. Kanania 'eva a bepulu koma?” ");
INSERT INTO nrz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anelu enu'ovi ediaka, “Idume Kabukabuna be'ovu oni akamuai, mai Akai vaika Kauna ena siavuai beva'elu'elumu. Kanaua 'ounai Kabukabu Kauna bepupulu vana be'aea Dilava Nakuna. ");
INSERT INTO nrz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oni kadi'a'amu Elisabeta ena motu motuai 'eva melo ka beabia, mai dediaka ia 'eva e'opa'opa beia ia 'eva vali'u vuiana 'ani kalakoi. ");
INSERT INTO nrz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dilava enai 'eva sia dava ka epasisi.” ");
INSERT INTO nrz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia enu'ovi ediaka, “Lau 'eva Lovia namana ena da'alaabi ateate'u. Emu luva vitaitana keva'uai epulu.” Inoku anelu Malia evikania. ");
INSERT INTO nrz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Melala kanaua'i Malia eva'olu inoku emolau eda'a vanua ka lolo ai Iudea kanobatanai. ");
INSERT INTO nrz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ia Sakalia ena lumai edodo inoku Elisabeta evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeta Malia ena vanama'ina 'uluna eika koanai, bo'ana laloanai melo e'iuvai 'iuvai, mai Idume Kabukabuna Elisabeta nuana evavonua. ");
INSERT INTO nrz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Inoku eluva 'unu'unu ediaka, “'A'ate boutai viloatai oni 'eva evanama'inamu, melo bovapulua melona vaka evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","E'u nama'ina 'eva dava e'u Lovia namana sinana easi keva'u! ");
INSERT INTO nrz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Emu vanama'ina 'uluna a'ika koanai, komolonai melo bo'a'u laloanai mailalonamana e'iuvai'iuvai. ");
INSERT INTO nrz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","'Ani evanama'inamu 'olana ovamomo'ai Lovia namana ena luva eluvaia kevamuai 'eva bemomo'ai.” ");
INSERT INTO nrz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia ediaka, “Lau nua'u Lovia namana evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mai idume'u vaka e'u vamauli Dilavana enai elalonama, ");
INSERT INTO nrz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","'olana ena ulalu mai da'alaabi ateate'u elalo'u une 'ounai. Vali'u melala kanania'i beda'a ulu boutai nama'i'u be'oua, ");
INSERT INTO nrz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","'olana siavu Dilavana dava namata e'uai evavai. Ia vana 'eva ekabukabu, ");
INSERT INTO nrz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ulu ka beda'a ulu ka ena vilalo 'eva eveveni kau 'olana de'aku kauta etai. ");
INSERT INTO nrz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ia imana siavunai ena kula'ila evala'asia, apa kauta kataua eta lalovai si'avatai elo'ota siusiu. ");
INSERT INTO nrz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ia eta'u lovia kauta kula'ilata eta lovia imia'autai eva'ovuta, mai ulalu kauta evaeleta'au. ");
INSERT INTO nrz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vikolo deakuta kauta dava nama'itai bo'ata evakubu, inoku lavo kauta 'eva imata 'avaeata esinita tau. ");
INSERT INTO nrz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ena luva 'ana'i elaloia une inoku ena da'alaabi iduvuna Isalaela kauta eduluta. ");
INSERT INTO nrz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Keketa kevatai ena vilalo eluva 'ana'i vaia davana 'eva evala'asia Abela'amo mai 'ava'avana kevatai bemia keinikeini.” ");
INSERT INTO nrz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia Elisabeta ita demia vuia koi boina inoku emue eda'a ena vanua. ");
INSERT INTO nrz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeta ena mauli bonina edaia koanai nakuna moluanena evapulua. ");
INSERT INTO nrz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lovia namana ena vilalo nama vaikana enai evala'asia 'eva kevanai demia kauta mai kadi'a'ana vali deika ita delalonama vaia ka'ona. ");
INSERT INTO nrz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Melala ivakalavaninai 'eva boutai deasi melo ivana do'una, mai kamana Sakalia vanai be'aea. ");
INSERT INTO nrz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Beia sinana eko'isi ediaka, “Asi'i, ia vana eka'aea Ioane.” ");
INSERT INTO nrz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Boutai de'ouia dediaka, “Kadi'a'amu sia ka vana kanaua boina.” ");
INSERT INTO nrz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Makata devailu kamana kevanai melo va dava be'aea. ");
INSERT INTO nrz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakalia lelelele bika'ana elavuai lavuai vaia, akanai kanania eleleia koma, “Vana 'eva Ioane,” deikaia koanai boutai detabu lovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Komolonai nutuna eluvuia, malana ekomolo eluva luva 'udai, Dilava evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kevatai demia kauta boutai demakau si'asi'a, mai Iudea lolo vanuana boutai vali kanania deluvaia odaoda. ");
INSERT INTO nrz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vali deika kauta nuatai delalovai lalovai dediaka, “Melo kanania a boinai be'ao.” 'Olana Dilava imana 'eva ia akanai. ");
INSERT INTO nrz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Melo kamana Sakalia Idume kabukabuna nuana evavonua, inoku enolea luvana eluvaia ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Lovia namana Isalaela eta Dilava ekavanama'inala, 'olana ia 'ani easi ena kau etavata 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ivamaulita kauna kula'ilana evako'isia ita eta ena da'alaabi kauna Davida ena iduvuai. ");
INSERT INTO nrz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'Ani siako melalanai ena luva enolea kabukabuta nututai deluvaia boina. ");
INSERT INTO nrz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Eta 'ou kauta mai ulata sia de'ula kauta boutai imatai bevamaulita. ");
INSERT INTO nrz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ena vilalo kubuta bevaikata mai ena luva 'ana'i kabukabuna 'eva elalovai 'inia. ");
INSERT INTO nrz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kubuta Abela'amo kevanai ena luva'ana'i eluvavaia ita daitai: ");
INSERT INTO nrz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eta 'ou kauta imatai bevamaulita, sia ekamakau ena vinaula ekavavaia ");
INSERT INTO nrz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","eta mia melalata boutai laloatai ia vailanai kabukabuai mai komoloai ekamia. ");
INSERT INTO nrz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Mai naku'u e, oni 'eva be'aemu akai vaika kauna ena enolea kaumu. 'Olana oni bo'ana'ia Lovia namana vailanai ena dala bovavaia kave'i, ");
INSERT INTO nrz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ena kau vamauli luvana bovaikabasita eta si'avana be'oukao koanai. ");
INSERT INTO nrz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ita eta Dilava ena vilalo dainai. Melala ele'au 'ailalana vutuvutuai be'ovu be'asi kevata, ");
INSERT INTO nrz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ba va'ava'anai mai vabuto'oai demimia kauta akatai bekakala, aeta be'ima bevada'ata nua'elu dalanai bevada'ata dodo.” ");
INSERT INTO nrz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ioane e'aida'aida mai idumeai ekula'ila. Ia kano'akunai emia eda'amo ia Isalaela kau mato kevatai evailaasi. ");
INSERT INTO nrz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Melala kanaua laloanai Kaisala Aukusto, Loma lovia 'olana talavatu luvana ka esinia eda'a Loma ena ikakao kanobatata boutai ai kau vata belelele. ");
INSERT INTO nrz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nia 'eva va lele lava'ana'ina Kavana kauna Kulene Sulia kanobatana eikaia kao koanai. ");
INSERT INTO nrz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Inoku kau boutai vata beveveni 'ounai demue deda'a itaumo eta vanua. ");
INSERT INTO nrz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosepa vaka Nasaleta vanuana ai Kalilea kanonai eko'isi eda'a Davida ena Vanua Betele'ema Iudea ai, 'olana ia 'eva Davida ena iduvu mai ena pulu kauna. ");
INSERT INTO nrz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Vata beveveni 'ounai de'ouia 'ana'i beadavala ateatena Malia ita deda'a, Malia 'eva maibo'ana. ");
INSERT INTO nrz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Laluana ua'i Betele'emai demia laloanai bemauli melalana edaia. ");
INSERT INTO nrz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Inoku emauli 'eva melo moluanena batani kauna evapulua, tubu'ai de'umia inoku bolomakau eta aniani asiasinai devaenoa uda, 'olana 'ima'ima lumanai 'abu asi'i. ");
INSERT INTO nrz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kano ka'onamo kanaua laloanai mamoe 'ima kauta vaida 'eva duvuai demia, boniai eta mamoe de'imata. ");
INSERT INTO nrz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lovia namana ena anelu ka kevatai evailaasi, Lovia namana nuavinai eva'ailalata koanai demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anelu ia e'outa ediaka, “Sia omakau. Lau vali nama'ina abia a'asi kau boutai lalota bevanama si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vali'u melala kanania'i Davida ena vanuai emui Vamauli kauna 'eva 'ani epulu, ia 'eva Keliso Lovia namana. ");
INSERT INTO nrz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Koana 'eva kanania boina emuiai, melo 'oma'omana ka oi bodavalia, tubu'ai de'umia inoku bolomakau eta aniani asiasinai devaenoa uda.” ");
INSERT INTO nrz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Alimo vutuvutuai anelu doutamo vaika dela'asi anelu kanaua ita devaka'onamo, Dilava devanama'inala dediaka, ");
INSERT INTO nrz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“nuavi 'eva Dilava akai vaika vutuvutuna laloanai, kanobatai nua'elu 'eva elalonama venita kauta etai.” ");
INSERT INTO nrz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anelu boutai ia devikanita demue deda'a vutuvutu koanai mamoe 'ima kauta sibota deluvaluva dediaka, “Ita kada'a Betele'ema, Lovia namana e'outa dava epulu davana ekaikala.” ");
INSERT INTO nrz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Deda'a molau deda'a Malia mai Iosepa dedavalita mai melo 'oma'omana bolomakau eta aniani asiasinai enouda deikaia. ");
INSERT INTO nrz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Deikaia koanai anelu melo lovana eakuia luvana kau de'outa, ");
INSERT INTO nrz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","mamoe 'ima kauta vali kanaua deluva vaia koanai lele deika kauta boutai detabu lovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Malia 'eva luva kataua boutai nuanai elalovai 'inita mai elalovai lalovai vaita. ");
INSERT INTO nrz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mamoe 'ima kauta demue Dilava devanama'inala mai deapa vaia 'olana dava kataua 'uluta deika mai deika davata boutai e'outa vitaitana umauta depulu. ");
INSERT INTO nrz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Melala ivakalavaninai beivala melalanai, melo vana de'aeia Iesu, sinana bo'anai asido'o epulu laloanai anelu va kanania evenia. ");
INSERT INTO nrz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mose ena talavatu vitaitana ivanama'inata bonina eole mulinai melo devuaia deda'a Ielusalema Lovia namana vailanai bevala'asia. ");
INSERT INTO nrz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Lovia namana ena talavatuai ilelena vitaitana, “Batanikau melota moluaneta boutai 'eva beveveni Lovia namana ena.” ");
INSERT INTO nrz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maivaka Lovia namana ena talavatu eluva vitaitana vakabukabu davata beveveni 'eva popouda lua 'o boiomalo nakuta lua. ");
INSERT INTO nrz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ua'i Ielusalemai kau ka vana Simeona, ia 'eva komolo kauna mai Dilava 'olana e'aku. Isalaela ena vamauli kauna e'imaia, Idume Kabukabuna 'eva ia akanai. ");
INSERT INTO nrz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Idume Kabukabuna ia e'ouia sia bebaba beda'amo Lovia namana ia ena Keliso beikala makava. ");
INSERT INTO nrz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Idume Kabukabu ia evada'aladodo Lo'e Kabukabuna laloanai. Mose ena talavatu luvana vitaitana Malia mai Iosepa 'eva Iesu devuaia deda'a Lo'e Kabukabuna ai. ");
INSERT INTO nrz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeona imanai melo ela'uia inoku Dilava evanama'inala ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lovia namana e, emu luva'ana'i vitaitana emu da'alaabi kauna vali'u mainua'elu'u bovikani'u. ");
INSERT INTO nrz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","'Olana maka'u ai emu Vamauli 'Olana 'ani aikaia, ");
INSERT INTO nrz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","oni 'ani ova'olua kau boutai vailatai. ");
INSERT INTO nrz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Ailalana kanania 'eva pulu edea kauta ivaikabasita mai nuavi 'eva emu kau Isalaela kauta eta.” ");
INSERT INTO nrz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Melo kamana mai sinana luva kataua deika 'eva detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeona eta'u laluana evanama'inata inoku sinana Malia e'ouia ediaka, “Melo kanania 'eva Dilava edilaia Isalaela kauta doutamo beva'ekota mai bevako'isita, maivaka ena koakoai bevaiviivia, ");
INSERT INTO nrz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kau doutamo eta lalovai vuniata bevala'asita. Mai itani lepo 'ido'idona betata'u oni nuamu vaka bevaanaanala.” ");
INSERT INTO nrz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ua'i vaka enolea ateatena ka vana 'Ana, Panuela nakuna, ia ena iduvu 'eva Asele, ia 'ani emotu, adana ita dekamoane vikau kalakoika demia, ");
INSERT INTO nrz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","inoku eobu emia vali'u vikauna kalavani navui vani (84). Ia lo'e kabukabuna sia evikania kovo ia Dilava ekukudivo venia boni mai lani eolove mai eomeamea. ");
INSERT INTO nrz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Melala ka'onamo kanaua laloanai 'Ana easi lo'e kabukabuna laloanai Dilava evanama'inala inoku kau boutai Ielusalema bevamaulia kauna de'imaia kauta kevatai melo valina ekava. ");
INSERT INTO nrz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosepa mai Malia laluana Lovia namana ena talavatu eluva vitaitanai vinaula boutai devaoleta koanai demue deda'a Kalilea kanonai eta vanua umauna Nasaleta. ");
INSERT INTO nrz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Melo e'aida'aida mai ekula'ila, aonekai evonu, Dilava ena iulaveni ia akanai emia. ");
INSERT INTO nrz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vikau boutai kamana mai sinana deoda'a Ielusalemai la'au keini naduna 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu vikauna ouka lua koanai, kauta kakoina deda'a Ielusalema ia eta nadu koakoana dainai. ");
INSERT INTO nrz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nadu eole mulinai kamana mai sinana demue ia Iesu 'eva Ielusalemai emia, kamana mai sinana sia deikabasi. ");
INSERT INTO nrz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ia delalovaia 'eva ia kau viloatai, melala itoina deda'avaia mulinai ia banota mai kadi'a'ata kevatai dekavuia. ");
INSERT INTO nrz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sia dedavalia 'ounai demue deda'a Ielusalemai ua'i bekavua. ");
INSERT INTO nrz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Melala koi de'ole mulitai lo'e kabukabuna laloanai dedavalia vamalele kauta viloatai emia divo luva leleta eika mai elavuaita. ");
INSERT INTO nrz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ena ikabasi mai luva evamue lelena deika kauta boutai detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kamana mai sinana deikaia koanai detabulovo si'asi'a. Sinana ia e'ouia ediaka, “Naku'u e, dava 'ounai kanania boina kevamaiai ovavaia? Lau oni kamamu ita nuamai maikanita lai akavu vunumu.” ");
INSERT INTO nrz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu e'outa ediaka, “Dava 'ounai lau oi okavu'u? Oi sia oikabasi lau 'eva kama'u ena luma laloanai amimia, una?” ");
INSERT INTO nrz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Beia ia dava eluvavaia luvana ovonai sia deovo. ");
INSERT INTO nrz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Inoku e'ovu ita deda'a Nasaleta, ua'i leleta daitaimo edai, beia sinana 'eva depulu davata kataua boutai nuanai elalovai 'inita. ");
INSERT INTO nrz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu 'eva kauaniai mai idibai e'aida'aida, maivaka Dilava mai kau ia deula venia. ");
INSERT INTO nrz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibelio lovia 'olana Loma kanobatana eloviala vikau 'ouka ima laloanai Pontio Pilato 'eva Iudea eta Kavana. 'Eloda 'eva Kalilea eloviala, maivaka kadina Pilipo 'eva Itulea mai Talakonito eloviata, Lusania 'eva Abilene vanuata elovia vaita. ");
INSERT INTO nrz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kabukabu kauta 'olatai kauta 'Ana mai Kaiapa eta melalai, kano'akunai Dilava ena luva easi Sakalia nakuna Ioane kevana. ");
INSERT INTO nrz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ioane eda'a Iolidana nutu 'aba'abana kanota boutai laloatai lalo'udai mai vaidi'u kabukabu eilolo vaia eta si'avana i'ou kaota 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Enolea kauna Isaia ena pukai eleleia luvana vitaitana: “Lele ka kano'akunai e'ae'ae ediaka, ‘Lovia namana ena dala ova'olua, ena da'a dalana ovakomoloa. ");
INSERT INTO nrz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lava boutai bebubuta, lolololo mai lolo boutai beva'ovuta venuai bevitaita. Dala deva'eva 'eva bekomolo, mai 'abu si'avata 'abuta bevavai kave'i kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kau boutai Dilava ena vamauli siavuna beikala.’” ");
INSERT INTO nrz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kau mato dela'asi deasi Ioane kevana bevaidi'uta kabukabu, eilolo venita ediaka, “Kau'asi nakuta e, dai e'oumui badu e'asi davana kevanai oiboveau tau? ");
INSERT INTO nrz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lalo'udai laloanai oibomimia vuavuamui bepupulu, ia sia oi bodiaka ‘Abela'amo 'eva ita 'ava'avata.’ Sia oibolalovaia 'ani oibonama'ina. 'Olana lau oi a'oumui, Dilava maiena siavu bika'a katania'i Abela'amo nakuna bevavaita. ");
INSERT INTO nrz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ila 'eva 'ani e'olu au 'olanai, au boutai vuavuata nama'ita sia devapulu auta 'eva beukuta, 'alovai bekapota dodo.” ");
INSERT INTO nrz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Inoku do'u kauta ia delavuaia dediaka, “Inoku lai 'eva dava lai bavavaia?” ");
INSERT INTO nrz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ioane e'outa ediaka, “Maiena ivadodo lua kauna 'eva banona sia maiena kauna 'eva ka bevenia, maiena iani kauna vaka kanaua bevavai koma.” ");
INSERT INTO nrz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Moni visi kauta vaka deasi bevaidi'uta kabukabu deko koanai, delavuaia dediaka, “Vaikabasi kaumu e, lai dava bavavaia?” ");
INSERT INTO nrz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ioane e'outa ediaka, “Moni boabia koanai vitaitana mo boabia, sia boabi keini.” ");
INSERT INTO nrz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kuali kauta vaida vaka delavuaia dediaka, “Lai 'eva dava lai bavavaia?” Ioane e'outa ediaka, “Aivalai 'o luva dedetai kau sia oi bolebata eta moni oi bo'abi. Nuamui mediatai tavamui umauta mo oi bo'abi.” ");
INSERT INTO nrz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kau 'eva devi'ima 'ounai nuatai delalovai lalovai dediaka Ioane 'eva ama'i Keliso. ");
INSERT INTO nrz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ioane ia boutai e'outa ediaka, “Lau 'eva veiai oi avaidi'umui kabukabu, beia muli'uai e'asi kauna ena siavu 'eva lau e'u siavu ekeinia, ena tamaka valota vaka baluluvu 'eva keva'uai sia edaia. Ia 'eva Idume Kabukabuna mai 'alova ai bevaidi'umui kabukabu. ");
INSERT INTO nrz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ena witi ivavai kave'ita auna 'eva imanai, witi iaku mukamukata 'abuna bevavaia kave'i, witi keata bevalalota makuai bedoubou, ia lu'ulu'uta 'eva sia ebo'o kovo 'alovanai betouta.” ");
INSERT INTO nrz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ioane vaidiba luvata doutamoai kau e'outa mai kevatai vali nama'ina eilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ioane eta'u Kalileia eta lovia 'olana 'Eloda e'ovenia, 'olana ia kadina adana 'Elodia eadavala mai vinaula si'avata vaika doutamo evavai 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","'Eloda ena si'avana kataua boutai akatai si'avana umauna ka evavaia 'udai, Ioane vabuto'o lumanai e'alavua. ");
INSERT INTO nrz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kau boutai evaidi'uta kabukabu laloanai, Iesu vaka evaidi'ua kabukabu. Iesu ena meamea laloanai vutuvutu eluvu. ");
INSERT INTO nrz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Idume Kabukabuna boiomalo ikaikana vitaitana e'ovu easi ia akanai. Inoku lele ka vutuvutuai easi eluva ediaka, “Oni 'eva Lau Naku'u. E'u Lalo'au, alalonama venimu.” ");
INSERT INTO nrz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu vikauna koinavui koanai ena vinaula emakavala. Kau delalovaia Iesu 'eva Iosepa nakuna. Iosepa kamana 'eva 'Eli, ");
INSERT INTO nrz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","kamana Matata, kamana Levi, kamana Meleki, kamana Ianai, kamana Iosepa, ");
INSERT INTO nrz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","kamana Matatia, kamana 'Amosa, kamana Nauma, kamana 'Eseli, kamana Nakai, ");
INSERT INTO nrz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","kamana Mata, kamana Matatia, kamana Semeina, kamana Ioseka, kamana Ioda, ");
INSERT INTO nrz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","kamana Ioanana, kamana Lesa, kamana Solobabela, kamana Salatiele, kamana Neli, ");
INSERT INTO nrz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","kamana Meleki, kamana 'Adi, kamana Kosama, kamana 'Elamadama, kamana 'Ele, ");
INSERT INTO nrz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","kamana Iosua, kamana 'Eliesele, kamana Iolima, kamana Matata, kamana Levi, ");
INSERT INTO nrz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","kamana Simeona, kamana Iuda, kamana Iosepa, kamana Ionama, kamana 'Eliakima, ");
INSERT INTO nrz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","kamana Melea, kamana Mena, kamana Matata, kamana Natana, kamana Davida, ");
INSERT INTO nrz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","kamana Iese, kamana 'Obeda, kamana Boa, kamana Salamone, kamana Nasona, ");
INSERT INTO nrz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","kamana 'Aminadaba, kamana 'Adamina, kamana 'Aleni, kamana 'Esalona, kamana Pale, kamana Iuda, ");
INSERT INTO nrz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","kamana Iakobo, kamana Isako, kamana Abela'amo, kamana Tela, kamana Na'olo, ");
INSERT INTO nrz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","kamana Seluka, kamana Leu, kamana Peleka, kamana 'Ebele, kamana Sala, ");
INSERT INTO nrz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","kamana Kainana, kamana 'Apasada, kamana Sema, kamana Noa, kamana Lameka, ");
INSERT INTO nrz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","kamana Metusala, kamana Enoka, kamana Ialeta, kamana Ma'alale, kamana Kainana, ");
INSERT INTO nrz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kamana 'Eno, kamana Seta, kamana 'Adamu, kamana Dilava. ");
INSERT INTO nrz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Iolidana nutunai emue 'udai koanai Idume Kabukabuna ia nuana evavonua, inoku Idume Kabukabuna eta'u evada'ala deda'a kano'akunai, ");
INSERT INTO nrz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","melala vani navui ua'i diabolo eta'u ekovoia. Melala kataua'i iani sia ka eania kovo, to'onai ia vikolo eakuia. ");
INSERT INTO nrz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Diabolo eta'u ia e'ouia ediaka, “Bema oni Dilava Nakuna koanai bika'a katania boma'outa ianiai bemaao.” ");
INSERT INTO nrz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu ia e'ouia ediaka, “'Ani puka kabukabunai ilelena, ‘kau 'eva sia ianiai mo bemauli.’” ");
INSERT INTO nrz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Diabolo eta'u Iesu evada'ala dele'au loloai inoku melala kava'inamo kanobata vanuata boutai evaikala. ");
INSERT INTO nrz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Inoku Diabolo ia e'ouia ediaka, “Lau batata'u siavu mai nuavi katania boutai bavenimu, 'olana dava katania boutai 'eva lau ima'u ai eudata, Inoku lau dai aula venia kauna bavenia. ");
INSERT INTO nrz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bema oni lau bokukudivo veni'u koanai, dava katania boutai 'eva oni emu.” ");
INSERT INTO nrz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu ena luva evamuea ediaka, “'Ani puka kabukabunai ilelena, ‘Lovia namana oni emu Dilava mo bokukudivo venia, ia mo sibona da'alana bo'abi.’” ");
INSERT INTO nrz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mune'e evada'ala deda'a Ielusalema lo'e kabukabuna uvinai evalavala 'au, e'ouia ediaka, “Bema oni Dilava Nakuna koanai nia'i sibomu lovo asi. ");
INSERT INTO nrz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","'Olana 'ani puka kabukabunai ilelena, ‘ia ena anelu be'outa be'imamu. ");
INSERT INTO nrz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Maivaka ia imatai beabimu isi, asi'i aemu bika'ai omaakua 'ounai.’” ");
INSERT INTO nrz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu ia e'ouia ediaka, “'Ani puka kabukabunai eluva, ‘Lovia namana emu Dilava vikovo 'abunai sia bone'eadivo.’” ");
INSERT INTO nrz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diabolo ena vikovo boutai evaoleta koanai ia kevanai eda'atau beda'amo melala nama'ina ka be'asi vakaia. ");
INSERT INTO nrz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Idume Kabukabuna siavunai Iesu emue eda'a Kalileai ua'i kano kanaua vanuata boutai laloatai ia valina dekava odaoda. ");
INSERT INTO nrz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iuda kauta eta lo'e laloatai evaikabasi, kau boutai ia devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu eda'a e'aida'aida vanuana Nasaleta ai, ena koakoa dainai Melala Kabukabunai Iuda kauta eta lo'e laloanai edodo, elavadivo Puka bevakua. ");
INSERT INTO nrz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaia enolea kauna ena puka devenia, puka eluvuia, kanania eleleia koma 'abuna edavalia 'eva evakua ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Lovia namana Idumena 'eva lau aka'uai, 'olana edila'u vali nama'ina bailolo vaia ulalu kauta kevatai. Esini'u deliota kauta ivala'asita bailolo vaia mai maka 'ede kauta beikaika 'udai, anaana laloanai demimia kauta bavala'asita, ");
INSERT INTO nrz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Lovia namana ena kau bevamaulita vikauna 'ani edaia valina bailolo vaia.” ");
INSERT INTO nrz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu puka e'alavua i'imana kauna evenia inoku emia divo, lo'e laloanai kau boutai makata ia deika 'inia. ");
INSERT INTO nrz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ia 'ani e'outa makava ediaka, “Puka Kabukabunai luva oi o'ika luvana 'eva vali'u melala kanania'i 'ani emomo'ai.” ");
INSERT INTO nrz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Luva nama'ita e'outa 'ounai boutai ia devanama'inala mai detabulovo si'asi'a delavuai lavuai dediaka, “Nia 'eva Iosepa nakuna, una?” ");
INSERT INTO nrz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu ia e'outa ediaka, “Lau aikabasi dokadoka oi luva kanania 'ani oi bo'ou'u bodiaka, ‘Mulamula veni kaumu e, sibomu vamaulimu.’ maivaka oi bo'ou'u bodiaka, ‘Dava dava ua'i Kapelanauma ai ovavai 'uluta lai aika davata, nia'i emu vanua umaunai vaka bovavaita.’” ");
INSERT INTO nrz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ia ediaka, “Luva umauna lau oi a'oumui, enolea kauna ena vanua umaunai 'eva sia beabiadae. ");
INSERT INTO nrz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Luva umauna lau oi a'oumui, 'Elia ena melalai obu 'a'ateta doutamo Isalaelai demia, vikau koi mai vuia kalakoi vutuvutu e'alavua lamu sia eaku 'eva kanobata itoinai doe namavaikana epulu. ");
INSERT INTO nrz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Inoku 'Elia sia esinia eda'a kataua ka kevana, beia eda'a Salepata vanuana Sidono kanonai obu ateatena ka kevana. ");
INSERT INTO nrz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Maivaka enolea kauna Elisa ia ena melalai Isalaela laloanai ua'i 'eva loki kauta doutamo, sia ka enama'ina, ia Sulia kauna Na'amana sibona mo enama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lo'e laloanai kau boutai luva kataua deika koanai debadu si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Deko'isi vanuai dedolia asi devada'ala deda'a devanua lolona akanai etaula 'eva ke'eke'eai bekapoa asi. ");
INSERT INTO nrz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Beia ia 'eva kau mato viloata umaunai eda'a ovo. ");
INSERT INTO nrz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Inoku e'ovu eda'a Kalilea vanuana ka Kapelanauma ua'i melala kabukabunai Iuda kauta eta lo'eai kau evaikabasita makamaka. ");
INSERT INTO nrz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ena vaikabasi luvatai detabulovo si'asi'a 'olana ena luvaluva 'eva maisiavuta. ");
INSERT INTO nrz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kau ka nuanai ka'uba si'avana vaika edodo kauna ua'i lo'e laloanai evaoi 'unu'unu, ");
INSERT INTO nrz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ediaka, “'A! Iesu Nasaleta kauna e, lai dava kevamaiai bovavaia? Oni o'asi 'eva lai boakubamai, una? Lau aikabasi oni 'eva Dilava ena Kabukabu kauna.” ");
INSERT INTO nrz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu ia e'ovenia ediaka, “'Ulumu. Ia nuanai la'asi.” Boutai vailatai ka'uba si'avana vaika kau kanaua eva'eko'a si'asi'a inoku kauaninai ela'asi, sia dua ka evenia. ");
INSERT INTO nrz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kau boutai detabulovo si'asi'a, deviluva viveni dediaka, “Nia 'eva vaikabasi davana? Maisiavuna mai maikula'ilana ka'uba si'avata vaika e'outa 'eva kau nuatai dela'asi.” ");
INSERT INTO nrz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kano kanaua itoinai Iesu valina dekava odaoda. ");
INSERT INTO nrz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu lo'e evikania eda'a Simona ena luma. Simona lavana ateatena kauna desiavu si'asi'a e'olele, Iesu denoia bedulua. ");
INSERT INTO nrz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu eda'a ateate kevanai elavadivo inoku 'olele kanaua epilaia be'ole, inoku 'olele eole, komolonai ateate eko'isi eta iani evavai. ");
INSERT INTO nrz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Melala ena ulu eda'a venia koanai kau boutai 'olele edeata edeata kauta boutai devuata deasi Iesu kevana, Iesu imana ka ka akatai ekao'au evamaulita. ");
INSERT INTO nrz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka'uba si'avata vaika vaka kau doutamo nuatai dela'asi devaoi dediaka, “Oni 'eva Keliso Dilava Nakuna.” Iesu epilata e'outa kao sia beluluva 'olana deikabasi ia 'eva Keliso. ");
INSERT INTO nrz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Taba elele laloanai Iesu ela'asi eda'a 'abu 'akuna kai bemeamea. Kau mato namavaikana ia ikavuna deda'a, dedavalia koanai de'ouia ia kevatai sia bemada'a tau. ");
INSERT INTO nrz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Beia Iesu e'outa ediaka, “Lau 'eva Dilava ena lovia vanuana valina vanua edeata edeata kevatai bailolo vaia 'olana kanaua 'ounai lau esini'u.” ");
INSERT INTO nrz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Inoku Iudea lo'eta laloatai eilolo. ");
INSERT INTO nrz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Melala ka Iesu Kenesaleta 'ovuna 'aba'abanai elava eilolo laloanai kau mato delavaia kaiukaiu Dilava ena luva 'uluna be'ika. ");
INSERT INTO nrz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ia asi lua 'ovu 'aba'abanai dedai'au eikata, va'eka kauta devikanita nabuai eta vuo dedeinita. ");
INSERT INTO nrz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu 'eva Simona ena asiai ele'au, inoku e'ouia kava'inamo betoa asi, ia asiai emiadivo inoku kau mato evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iesu eluvaluva koa mulinai Simona e'ouia ediaka, “'Oula kada'aia, emu vuo ua'i bonana sisi vaida bovakota.” ");
INSERT INTO nrz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simona ia ena luva evamuea ediaka, “'Ola kaumu e, lai boni itoinai lai abavunu lani ia sia dava ka lai abia, beia oluluva 'ounai vuo bava'ovuta.” ");
INSERT INTO nrz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Vuo dene'eta 'eva sisi doutamo vaika devakoata, eta vuo kevaimo bema'idi. ");
INSERT INTO nrz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Banota vaida asi ka ai kauta dekapota be'asi beduluta, inoku deasi asita lua devavonuta kevaimo deuku. ");
INSERT INTO nrz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simona Petelo koa kanaua eikaia koanai Iesu aena 'olanai ekuidula inoku ediaka, “Lovia namana e, lau 'eva si'avana kau'u, keva'uai da'a tau.” ");
INSERT INTO nrz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simona banona ita 'eva detabulovo si'asi'a 'olana sisi kataua boita doutamo vaika devakoata 'ounai, ");
INSERT INTO nrz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simona ita deva'eka ka'ona kauta Sebedeo nakuna Iakobo mai Ioane vaka detabulovo si'asi'a. Beia Iesu Simona e'ouia ediaka, “Sia bomakau. Vali'u beda'amo vaila melalatai oni 'eva kau bova'ekata.” ");
INSERT INTO nrz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eta asi develi'au nabuai, dava boutai devikanita Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesu vanua ka laloanai emia laloanai, ua'i kau ka kauna itoina 'eva eloki, inoku Iesu eikaia koanai e'eko aena 'olanai epakadivo inoku enoia ediaka, “Lovia namana e, bomaula koanai bomavanama'ina'u.” ");
INSERT INTO nrz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu imana eisia lao eabia kovo, e'ouia ediaka, “A'ula, bonama'ina.” Komolonai loki kau kanaua evikania. ");
INSERT INTO nrz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ia e'ouia kao ediaka, “Sia kau ka vailanai boluluva, beia boda'a kabukabu kauna kevanai beikamu, mai vanama'ina venivenina davana Mose eluva vitaitana boveveni, inoku kau bevamomo'aia oni 'ani onama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Beia Iesu valina dekava odaoda inoku kau mato namavaikana deasi lelena be'ika mai eta 'olele bevanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Beia Iesu eda'atau eda'a 'abu 'avaeana kai ua'i emeamea. ");
INSERT INTO nrz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Melala ka Iesu evaikabasi laloanai Palisea kauta mai talavatu 'ola kauta vaida ua'i demia, ia 'eva Kalilea vanuata boutai ai, Iudea mai Ielusalema laloatai deasi. Lovia namana siavuna 'eva Iesu akanai 'olele kauta evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kau vaida 'eko kauna ka toto'ai devuaia deda'a dalana dekavu bedodo vaia Iesu vailanai bene'eadivo. ");
INSERT INTO nrz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bedodo vaia deko beia sia dala ka dedavalia 'olana kau mato namavaikana 'ounai, inoku devuaia dele'au deda'a luma 'uvinai, 'uvi deiuia isi inoku maitoto'ana deva'ovua eda'a Iesu vailanai kau mato bo'adatai. ");
INSERT INTO nrz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu eta abiveni namavaikana kanaua boina eikaia koanai eluva ediaka, “E'u kau e, emu si'avana 'ani iou kaota.” ");
INSERT INTO nrz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Talavatu 'ola kauta mai Palisea kauta nuatai delalovai lalovai dediaka, “Nia 'eva kau davana Dilava evasi'avanala? Dai si'avana be'ou kao, Dilava mo sibona.” ");
INSERT INTO nrz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Beia Iesu eta lalovai eikabasia 'ounai e'outa ediaka, “Dava 'ounai lalovai katania boita nuamuiai oi olalovaita? ");
INSERT INTO nrz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Davana ba'oua 'eva eveavea, emu si'avana 'ani i'ou kaota 'o ko'isi da'a. ");
INSERT INTO nrz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Beia oi boikabasi Lau Kau Nakuna 'eva kanobatai maisiavu'u si'avana ba'ou kao.” Ia 'eko kauna e'ouia ediaka, “Lau oni a'oumu, ko'isi emu toto'a abia, da'a emu luma.” ");
INSERT INTO nrz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Komolonai mo vailatai eko'isi ena enokai toto'ana eabia isi eda'a ena luma Dilava evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boutai detabulovo si'asi'a mai Dilava devanama'inala, maimakauta deluva dediaka, “Vali'u koa edeana umauna kaikala.” ");
INSERT INTO nrz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kanaua mulinai Iesu ela'asi eda'a moni visi kauna ka vana Levi moni visi 'abunai emiadivo eikaia, e'aeia ediaka, “Muli'uai mai.” ");
INSERT INTO nrz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi eko'isi dava boutai evikanita Iesu mulinai eda'a. ");
INSERT INTO nrz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ua'i Levi ena lumai nadu namana ka evavaia Iesu dainai, moni visi kauta doutamo mai kau edeata vaida vaka ia ita demia deaniani ka'ona. ");
INSERT INTO nrz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Palisea kauta mai talavatu 'ola kauta deta'u Iesu ibanona kauta kevatai denunuvai nunuvai dediaka, “Dava 'ounai oi moni visi kauta mai si'avana kauta ita oi oaniani mai oi oinuinu ka'ona?” ");
INSERT INTO nrz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu ia eta luva 'uluta eika inoku eta luva evamuea ediaka, “Kau nama'ita 'eva mulamula veni kauna sia dekavua, beia de'olele kauta mo 'eva mulamula veni kauna dekavua. ");
INSERT INTO nrz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Lau asi 'eva sia komolo kauta ba'aeta, beia si'avana kauta belalo'udai 'ounai asi.” ");
INSERT INTO nrz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kau vaida Iesu de'ouia dediaka, “Ioane ibanona kauta melala doutamo delove mai demeamea, Palisea ibanota kauta vaka vitaitana devavaia, beia oni ibanomu kauta deaniani mai deinuinu.” ");
INSERT INTO nrz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu e'outa ediaka, “Oi olalovaia kamoane makamaka kauna ena da'a'au kauta ita demia ka'ona laloanai belolove 'eva bedaia, una? ");
INSERT INTO nrz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Beia melalana be'asi koanai kamoane makamaka kauna kevatai beabia tau, inoku melala kataua'i ia 'eva belolove.” ");
INSERT INTO nrz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu luva ivavitaitana kanania e'outa, “Kau ka tubu'a makamakana si'ana sia be'idia ovo tubu'a 'ana'ina 'idina bekuli bubua 'olana tubu'a makamakana be'idia ovo koanai tubu'a makamakana 'ani be'idi mai tubu'a 'ana'ina mai tubu'a makamakana luana 'eva ikata sia bevitaita. ");
INSERT INTO nrz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kau ka vine veina makamakana popo'o 'ana'inai sia belaia uda, kanaua bevavaia koanai vine veina makamakana bekukubu popo'o 'ana'ina beva'alamala inoku be'itabu popo'o besi'avana. ");
INSERT INTO nrz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Beia vine veina makamakana 'eva popo'o makamakanai belaia, inoku luana benama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kau ka vine veina 'ana'ina beinua mulinai vine veina makamakana sia beula venia 'olana bediaka vine veina 'ana'ina 'eva nama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Melala Kabukabunai Iesu mai ibanona kauta ita witi lobana ka laloanai dekeini, ibanona kauta witi vuata debukuta avata imata ai demuduta ovo deani. ");
INSERT INTO nrz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Palisea kauta vaida deluva dediaka, “Oi dava 'ounai Melala Kabukabunai sia oi bovavaia vinaulana oi ovavaia?” ");
INSERT INTO nrz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu ia eta luva evamuea ediaka, “Oi ama'i Davida sisibana sia oi ovakua kovo. Ia mai banona ita vikolo de'akuta koanai dava evavaia? ");
INSERT INTO nrz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ia Dilava ena lumai edodo devakabukabu palaoata kabukabu kauta sibota mo be'ani davata eabita eanita mai ibanona kauta evenita deani.” ");
INSERT INTO nrz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Maivaka e'outa ediaka, “Lau Kau Nakuna 'eva Melala Kabukabuna Loviana.” ");
INSERT INTO nrz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Melala kabukabuna edeana kai Iesu Iuda kauta eta lo'eai edodo evaikabasi. Kau ka ua'i imana idibana 'eva ebade. ");
INSERT INTO nrz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Talavatu 'ola kauta mai Palisea kauta Iesu de'idimala Melala Kabukabunai bevanama'inala 'o asi'i, 'olana Iesu va'eva 'abunai bene'eadivo dalana dekavuia. ");
INSERT INTO nrz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Beia Iesu ia eta lalovai eikabasi, kanaua 'ounai ima bade kauna e'ouia ediaka, “Ko'isi vailatai lavadivo.” Inoku eko'isi elavadivo. ");
INSERT INTO nrz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iesu e'outa ediaka, “Lau oi alavuaimui, davana 'eva ekomolo Melala Kabukabunai, ekavanama'ina 'o ekavavai si'asi'a, ekavamauli 'o ekavaba?” ");
INSERT INTO nrz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu boutai eikata nekeneke mulinai ima bade kauna e'ouia ediaka, “Imamu isia komolo.” Ia evavaia 'eva imana ekomolo 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ia 'eva nuata debadu si'asi'a, sibota deluvaluva Iesu kevanai dava bevavaia. ");
INSERT INTO nrz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Melala kanaua'i Iesu loloai ele'au bemeamea, boni itoina Dilava kevanai emeamea. ");
INSERT INTO nrz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lani ekevai laloanai ia ibanona kauta e'aeta deasi kevana, viloatai ouka lua edilata mai e'aeta veauneke kauta. ");
INSERT INTO nrz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ia 'eva Simona vana e'aeia Petelo, mai kadina Andelea, Iakobo mai Ioane, Pilipo mai Batolomeo, ");
INSERT INTO nrz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio, Toma, Alepeo nakuna Iakobo, mai Simona de'aeia Selote kauna, ");
INSERT INTO nrz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iakobo nakuna Iuda mai Isakaliote kauna Iuda ia venina eveni kouna ekou kauna. ");
INSERT INTO nrz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu ena veauneke kauta ita loloai de'ovu kano komolonai delavadivo. Ua'i 'eva ibanona kauta mato namavaikana mai kau doutamo vaika 'eva Iudea vanuata boutai laloatai, Ielusalema ai, Tulo mai Sidono 'atu kanota boutai laloatai deasi, ");
INSERT INTO nrz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","deasi 'eva lelena be'ika mai eta 'oleleai benama'ina. Ka'uba si'avata vaika devabavunuta kauta vaka deasi evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Inoku kau boutai eta ula 'eva ia beabia kovo 'olana siavu 'eva ia enai ela'asi inoku ia boutai evamaulita. ");
INSERT INTO nrz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu ibanona kauta eikata inoku ena luva emakavala ediaka, “Oi oulalu kaumui 'eva oi onama'ina, 'olana Dilava ena lovia vanuana 'eva oi emui. ");
INSERT INTO nrz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Vali'u oi ovikolo kaumui 'eva oi onama'ina, 'olana oi 'eva bo'amui bekukubu. Vali'u oi okakani kaumui 'eva oi onama'ina, 'olana oi bomamai. ");
INSERT INTO nrz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Lau Kau Nakuna 'ou'uai bema kau devaiviivimui, viloamui edau'a, luva si'avata de'oumui, vamui devavai si'asi'a 'eva oi onama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Melala kanaua'i lalomui benanama mai oi bolalonama si'asi'a oi boneneva, 'Olana vutuvutuai tavamui nama vaikana. Ia 'ava'avata enolea kauta kevatai kanaua devavaita koma. ");
INSERT INTO nrz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Beia vali'u oi lavo kaumui kevamuiai 'eva besi'avana vaika, 'olana emui mauli mediana itoinai 'ani oi oabia. ");
INSERT INTO nrz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Vali'u oi oani vunu kaumui kevamuiai 'eva besi'avana vaika, 'olana oi bovikolo. Vali'u oi omamai kaumui kevamuiai 'eva besi'avana vaika, 'olana nuamui beanana mai oi bokakani. ");
INSERT INTO nrz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kau boutai vamui devanama'inata kaumui kevamuiai 'eva besi'avana vaika, 'olana ia 'ava'avata koa kanania vitaitana devavaia enolea kauta dedeta kevatai. ");
INSERT INTO nrz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Beia lele'u oi oika kaumui a'oumui. Emui 'ou kauta oi bolalo'au venita, ulamui sia de'ula kauta kataua kevatai oi bovavai kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Denunuvai nunuvaimui kauta kataua oi bovanama'inata, mai devavaimui si'asi'a kauta akatai oi bomeamea. ");
INSERT INTO nrz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kau ka metemu avekena bepi'ala koanai, avekena vaka bovenia bepi'ala. Mai kau ka emu kouti beabia koanai, emu ivadodo 'ouna sia bovavaia. ");
INSERT INTO nrz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kau dava kevamuai denoinoi davata 'eva oi bovenita, mai kau ka emu dava ka eabia koanai sia bo'oua bevenimu 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Oi o'ula kau kevamuiai kanaua boina bemavavai koma vitaitana oi vaka kanaua boina kau kevatai oi bovavai. ");
INSERT INTO nrz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ Kau delalo'au venimui kauta kataua mo oi bolalo'au venita koanai ena mediana 'eva dava oi kevamuiai? Si'avana kauta vaka delalo'au venita kauta kanaua delalo'au venita koma. ");
INSERT INTO nrz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mai devavaimui kave'i kauta kataua mo oi ovavaita kave'i koanai ena mediana 'eva dava kevamuiai? Si'avana kauta vaka kanaua devavai koma. ");
INSERT INTO nrz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kau dava devenimui kauta kataua mo oi ovenita koanai ena mediana 'eva dava oi kevamuiai? Si'avana kauta vaka si'avana kauta devenita inoku eta ula 'eva vitaitata tavata bevamue. ");
INSERT INTO nrz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Beia emui 'ou kauta oi bolalo'au venita, mai oi bovavaita kave'i, mai oi boveveni davata tavata ivamueta sia oi bolalovai. Inoku tavamui 'eva namata vutuvutuai oi bo'abi, mai oi 'eva akai vaika Dilavana nakunai oi bo'ao, 'olana ia 'eva sia devanama'inala kauta mai si'avana kauta vaka elalota. ");
INSERT INTO nrz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vilalo vinaulata oi bovavai itani Kamamui boina, ia 'eva mai ena vilalo. ");
INSERT INTO nrz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Banomui sia oi bovaluvata inoku Dilava vaka oi sia bevaluvamui, banomui sia oi bovasi'avanata inoku Dilava vaka oi sia bevasi'avanamui, banomui eta si'avana oi bo'ou kao inoku Dilava vaka oi emui si'avana be'ou kao. ");
INSERT INTO nrz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Banomui oi bovenita inoku Dilava vaka oi bevenimui, vitaitana dava ka bevonu vaika bekao 'inia, beaku 'inia, be'itabu 'itabu, kanaua boina bevenimui koma. 'Olana oi oveveni vitaitana Dilava vaka oi bevenimui 'udai.” ");
INSERT INTO nrz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu luva ivavitaitana kanania e'outa ediaka, “Maka 'ede kauna ka betata'u maka 'ede kauna ka sia bevada'ala, kanaua bevavaia koanai laluana 'uli laloanai be'ekouda. ");
INSERT INTO nrz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Malele melona ka ena vaikabasi kauna sia bekeinia, ia malele melota 'eva eta malele bevaole kave'i koanai eta vaikabasi kauna ita bevitaita. ");
INSERT INTO nrz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Dava 'ounai au na'ina'ina banomu makana laloanai kanaua oikala beia au ubana namana oni makamu laloanai davana sia olalovaia? ");
INSERT INTO nrz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Oni sibomu makamu laloanai au ubana namana kanaua sia oikala koanai, aboina bo'akalamu bo'oua bodiaka, ‘Bo'akala'u e, makamu laloanai au na'ina'ina babia ovo.’ Dede kaumu e, makamu laloanai au ubana namana abia ovo makava vakaia, mulinai makamu nama'itai bo'akalamu makana laloanai au na'ina'ina boikala kave'i boabia ovo.” ");
INSERT INTO nrz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Au nama'ina vuavua si'avana vaika sia bevapulua, maivaka au si'avana vaika vuavua nama'ina sia bevapulua. ");
INSERT INTO nrz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","'Olana au ka ka vuavuatai ikabasi epupulu, kau 'eva 'ini aumai veivei sia debuku ovo, mai ava 'ini'iniai ive'alu sia deabia. ");
INSERT INTO nrz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kau nama'ina etata'u dava namaita evala'asi 'olana nuanai 'eva dava nama'ita demimia, kau si'avana etata'u dava si'avata evala'asi 'olana nuanai 'eva dava si'avata demimia. 'Olana nutuai dela'asi luvata boutai 'eva nuai demimia. ");
INSERT INTO nrz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Oi dava 'ounai oi o'ae'u, ‘Lovia namana e, Lovia namana e,’ ia e'u luva sia oi oabia dae? ");
INSERT INTO nrz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kau de'asi keva'u inoku e'u luva leleta de'ika mai vinaulata devavai kauta 'eva aboita bavaikamui. ");
INSERT INTO nrz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ia 'eva itani kau ka luma edauia boina, 'uli e'uia e'ovu vaika venuai inoku bika'a akanai kovolo evalavata'au, abaka ela'asi koanai luma edolia beia luma sia euteute, 'olana luma edauia kave'i 'ounai elava 'ini. ");
INSERT INTO nrz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Beia e'u luva e'ika inoku vinaulata sia evavai kauna 'eva itani kau ka luma kano akanai evalavala kovolona asi'i boina, abaka ela'asi luma edolia koanai komolonai luma epalu, luma epalu 'eva abaka edaloia ovo.” ");
INSERT INTO nrz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu ena luva boutai kau kevatai eluvasi palu mulinai ia eda'a Kapelanaumai edodo. ");
INSERT INTO nrz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Loma kuali 'ola kauna ka ua'i ena da'alaabi kauna elalo'au venia vaika kauna 'eva e'olele si'asi'a itani 'ani bebaba. ");
INSERT INTO nrz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ia Iesu valina e'ika koanai Iuda kauta namata vaida esinita Iesu benoia be'asi ena da'alaabi kauna bevamaulia. ");
INSERT INTO nrz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ia deasi Iesu kevana koanai denoia 'udai 'udai dediaka, “Kau kanania bomadulua 'eva bemanama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","'Olana ia emai iduvu elalo'au venia, mai ia eta'u emai lo'e evalavala.” ");
INSERT INTO nrz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kanaua 'ounai Iesu ia ita deda'a, Iesu luma ekevaia koanai kuali 'olana kauna ena kau esinita Iesu de'ouia dediaka, “Lovia namana e, sia bovabavunu, 'olana lau 'eva sia anama'ina bo'asi e'u lumai bodododo. ");
INSERT INTO nrz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kanaua 'ounai bavavasi kevamu 'eva sia edaia. Beia luvamo boluvala inoku e'u da'alaabi kauna benama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Lau 'eva kau ka ena siavu venunai, inoku kuali kauta 'eva lau venu'uai. Lau kau kanania ka a'oua da'a 'eva ia edada'a, banona a'oua mai 'eva ia e'asi. E'u da'alaabi kauna a'oua kanania vavaia 'eva ia evavaia.” ");
INSERT INTO nrz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu luva kanaua eika koanai etabulovo si'asi'a, ekai'udai kau mato mulinai deda'a kauta kataua e'outa, “Lau oi a'oumui, Isalaela laloanai abiveni kanania boina sia ka adavalia.” ");
INSERT INTO nrz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","'Ola kauna esinita kauta kataua demue deda'a luma koanai, da'alaabi kauna 'ani enama'ina dedavalia. ");
INSERT INTO nrz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Melala kava'inamo eole mulinai Iesu eda'a vanua ka vana Naina, ibanona kauta mai kau mato ia ita deda'a. ");
INSERT INTO nrz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vanua nutualana 'ani dekevaia laloanai, ba kauna ka devuaia dela'asi, ua 'eva obu ka nakuna ka'oukukunamo, vanua kauta doutamo obu debanoia. ");
INSERT INTO nrz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lovia namana obu eikaia koanai elalo si'ala, inoku e'ouia ediaka, “Sia bokakani.” ");
INSERT INTO nrz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ia eda'a ilulao eda'a to'o eabia kovo, inoku to'o devuaia kauta delavadivo. Iesu eluva ediaka, “Kau 'alu'aluna e, lau a'oumu, ko'isi.” ");
INSERT INTO nrz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ba kauna eko'isi emiadivo inoku eluvaluva, Iesu melo eabia sinana evenia 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Boutai demakau si'asi'a, Dilava devanama'inala dediaka, “Enolea namana ka viloatai evailaasi.” Maivaka dediaka, “Dilava 'eva 'ani easi ena kau kevata.” ");
INSERT INTO nrz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iesu valina kanania Iudea kanona itoina mai kevanai 'abuta boutai laloatai deluvaia odaoda. ");
INSERT INTO nrz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioane ibanona kauta dava katania boutai ia de'ouia. ");
INSERT INTO nrz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Inoku ibanona kauta lua e'aeta esinita Lovia namana belavuaia bediaka, “Be'asi kauna 'eva oni, 'o kau edeana ka lai ba'imala?” ");
INSERT INTO nrz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ia deasi Iesu kevana koanai de'ouia dediaka, “Vaidi'u Kabukabu kauna Ioane esinimai lai a'asi kevamuai lai balavuaimu, ‘Be'asi kauna 'eva oni, 'o kau edeana ka lai ba'imala?’” ");
INSERT INTO nrz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Melala kanaua'i Iesu 'eva kau doutamo vaika eta 'olele, kauta deanana mai ka'uba si'avata vaika nuatai kauta evanama'inata, maivaka maka 'ede kauta doutamo makata evanama'ina deikaika 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iesu ia laluana eta luva evamuea ediaka, “Oda'a, dava makamuiai oi o'ika mai kaiamui ai 'uluta oi o'ika davata Ioane oi bo'oua. Maka 'ede kauta 'ani deikaika, 'ome'ome kauta 'ani dedada'a, loki kauta 'ani kauta denama'ina, kaia bubu kauta lele 'ani de'ika, ba kauta 'ani deko'isi demauli, maivaka ulalu kauta kevatai vali nama'ina ailolo vaia.” ");
INSERT INTO nrz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Maivaka eluva ediaka, “Nuana sia elalo to'ato'a keva'uai kauna 'eva enama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioane esinita kauta demue 'udai mulinai, Iesu mune'e kau mato kevatai Ioane luvana eluva ediaka, “Oi oda'a kano 'akunai 'eva dava oi boikala oko? Lani eunu 'ebavala eva'ekota oi boikata, una? ");
INSERT INTO nrz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Asi'i koanai, dava oiboikala oko 'ounai oi oda'a ua'i? Kau ka tubu'a tavana namana evadodoa oi boikala, una? Kau kataua tubu'a nama'ita vaika devadodota mai eta lovia davata doutamo kauta 'eva lovia 'olana kauna ena lumai oi bodavalita. ");
INSERT INTO nrz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dava oi boikala oko 'ounai oi oda'a ua'i? Enolea kauna ka, una? Momo'ai dokadoka, luva umauna, lau oi a'oumui, kau kanania 'eva enolea kauta ekeinita. ");
INSERT INTO nrz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kau kanania valina 'eva Puka Kabukabunai deleleia, ‘E'u veauneke kauna basinia be'ana'ia, emu dala beva'olua makava.’ ");
INSERT INTO nrz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Lau oi a'oumui. 'A'ate nuatai depupulu kauta boutai viloatai sia kau ka Ioane ekeinia. Beia Dilava ena lovia vanuana laloanai ekiki vaika kauna mo Ioane ekeinia”. ");
INSERT INTO nrz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kau boutai mai moni visi kauta 'eva Iesu ena luva 'uluna deika koanai devamomo'ai Dilava ena dala 'eva umauna 'olana Ioane eta'u ia evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Beia Palisea kauta mai talavatu 'ola kauta sibota Ioane ena vaidi'u kabukabu sia deula venia 'ounai Dilava ena ula ia etai davana sia deabiadae. ");
INSERT INTO nrz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu mune'e eluva ediaka, “Ulu kanania kauta 'eva davai bavavitaitata? Ia 'eva aboita? ");
INSERT INTO nrz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ia 'eva itani melo kikita vanua bo'adanai demimia boita banota de'aeta dediaka, ‘Siau lai auvanita, beia oi sia oneneva, ba masita lai a'abi, beia oi sia okakani.’ ");
INSERT INTO nrz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","'Olana vaidi'u kabukabu kauna Ioane easi koanai sia iani mediana ka eania mai sia vine veina mediana ka einuia, inoku oi odiaka, ‘Ia nuanai ka'uba si'avana vaika ka emimia.’ ");
INSERT INTO nrz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kau Nakuna easi eaniani mai einuinu 'eva oi oluva odiaka, ‘ Kau kanania 'eva eaniani vaika mai einuinu vaika maivaka moni visi kauta mai si'avana kauta eta kau.’ ");
INSERT INTO nrz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Beia Dilava ena aoneka 'eva beabia dae kauta etai bela'asi bemomo'ai.” ");
INSERT INTO nrz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisea kauna ka Iesu eula venia ena lumai ia ita beaniani ka'ona, inoku Iesu eda'a lumai edodo aniani 'abunai emiadivo. ");
INSERT INTO nrz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Vanua kanaua laloanai si'avana ateatena ka, Iesu Palisea kauna ena lumai beaniani valina eika koanai, ia bika'a kavapuna laloanai mulamula bonana mediana davana eabia easi. ");
INSERT INTO nrz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eda'a Iesu mulinai aena 'olanai esilidivo ekani inoku ilulu makanai aena evaveita, vuinai evaladata maivaka ebauta, mulamula bonana mediana esisia akatai. ");
INSERT INTO nrz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Palisea kauna Iesu e'aeia kauna kanaua ateate ena koakoa eikaia koanai, ia sibona nuanai elalovaia ediaka, “Bema kau kanania 'eva enolea kauna umauna koanai, ia 'ani beikabasi, ateate davana ia eabia kovo, 'olana ia 'eva si'avana ateatena.” ");
INSERT INTO nrz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu eta'u e'ouia ediaka, “Simona e, lau luva ka oni ba'oumu.” Ia ediaka, “Vaikabasi kaumu e, luva.” ");
INSERT INTO nrz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu ediaka, “Kau lua moni veni kauna ka kevanai moni deabita, ka 'eva siliva monina sinavu ima eabi, ka 'eva siliva monina imanavui eabi. ");
INSERT INTO nrz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tavata bevamue 'eva sia edaita 'ounai laluana moni bevamueta davata e'oukao, inoku kau davana ia ulana beula vaika?” ");
INSERT INTO nrz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simona ediaka, “Alalovaia, ama'i ena abitole namana kauna e'ouia kao kauna kanaua.” Iesu ia e'ouia ediaka, “'Ani oluva kave'i.” ");
INSERT INTO nrz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iesu ekai 'udai ateate eikaia, inoku Simona e'ouia, “Ateate kanania oikala? Lau asi emu lumai adodo 'eva ae'u badeini veita sia oveni'u. Beia ia 'eva ilulu makanai ae'u edeinita maivaka vuinai evaladata. ");
INSERT INTO nrz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Oni sia oba'u'u, beia ateate kanania ada'adodo koanai ae'u iba'utai sia emia laloka kovo. ");
INSERT INTO nrz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oni 'ola'u deoloai sia osisia, beia ia deolo bonana medianai ae'u esisita. ");
INSERT INTO nrz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanaua 'ounai lau oni a'oumu, ena si'avana doutamo vaika 'eva 'ani i'ou kaota 'olana ia ena lalo'au nama vaikana evala'asia beia dai ia ena si'avana kava'inamo e'oua kao kauna 'eva ena lalo'au kikinamo evala'asia.” ");
INSERT INTO nrz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Inoku Iesu ateate e'ouia ediaka, “Emu si'avana 'ani i'ou kaota.” ");
INSERT INTO nrz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aniani 'abunai demiadivo kauta sibota viloatai deluvaluva dediaka, “Nia 'eva dai, si'avana vaka e'ou kao.” ");
INSERT INTO nrz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu ateate e'ouia ediaka, “Emu abiveni eta'u evamaulimu, mai nua'elumu da'a.” ");
INSERT INTO nrz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Melala kava'inamo mulinai, Iesu vanua namata mai kikita laloatai eda'a keinikeini Dilava ena lovia vanuana valina nama'ina eilolo vaia. Ibanona kauta 'ouka lua 'eva ia ita deda'a, ");
INSERT INTO nrz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mai 'a'ate vaida vaka, ka'uba si'avata vaika nuatai elo'ota asi mai 'olele edeata edeatai evanama'inata 'a'ateta, ka 'eva Malia Makadala ateatena nuanai ka'uba si'avata vaika kalakoi ka elo'ota asi ateatena, ");
INSERT INTO nrz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ka 'eva Ioana, adana Kusa 'eva 'Eloda lovia 'olana ena luma davata e'ola vaita kauna, mai Susana, mai 'a'ate doutamo vaida. 'A'ate katania sibota eta davai Iesu mai ibanona kauta deduluta. ");
INSERT INTO nrz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kau mato vanua ka ka ai deasi Iesu kevanai do'u namana devavaia laloanai, Iesu luva ivavitaitana kanania eluvavaia ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Loba vinaula kauna ka eda'a ena kea bevavado. Eito kapokapo koanai vaida dalai de'ekoasi, inoku kau akatai deneke'au mai aka manumanuta deani paluta. ");
INSERT INTO nrz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kea vaida kano bika'a bika'ana akanai de'ekoasi, dekubu beia delamoda 'olana kano sia eveivei. ");
INSERT INTO nrz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kea vaida ava 'ini'inita laloatai de'ekoasi, ava 'ini'inita ita dekubu ka'ona inoku ava 'ini'inita de'alavuta. ");
INSERT INTO nrz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kea vaida kano medianai de'ekoasi, dekubu kave'i devua vuata sinavu ka ka boina.” Iesu ena luva to'onai eluva 'unu'unu ediaka, “Mai kaiana kauna 'eva lele be'ika mai beikabasi.” ");
INSERT INTO nrz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ibanona kauta Iesu delavuaia luva ivavitaitana kanania anina 'eva dava. ");
INSERT INTO nrz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ia ediaka, “Dilava ena lovia vanuana ikabasina vunita 'eva 'ani oi evenimui, beia vaida kevatai 'eva luva ivavitaitatai mo a'outa, kanaua 'ounai, ‘beikala mo beia sia beikala une lele be'ika beia ovona sia be'ovo.’ ");
INSERT INTO nrz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Luva ivavitaitana anina 'eva kanania. Kea 'eva Dilava ena luva. ");
INSERT INTO nrz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kea dalai de'ekoasi davata 'eva kau kataua, luva de'ika ia Diabolo e'asi luva nuatai eabia ovo 'olana asi'i demaabiveni mai asi'i demamauli 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kea kano bika'a bika'ana akanai de'ekoasi davata 'eva kau kataua, luva de'ika koanai mailalonamata deabia, beia lamuta asi'i 'ounai melala kava'ina mo deabiveni inoku vikovo e'asi koanai de'eko. ");
INSERT INTO nrz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kea ava 'ini'inita laloatai de'ekoasi davata 'eva kau kataua, luva de'ika beia mauli kanania ena nua mekau, ena lovia davata, mai ena lalonama davatai nuata e'alavu 'ounai vuavuata delamoda. ");
INSERT INTO nrz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Beia kea kano medianai de'ekoasi davata 'eva kau kataua, nuata komolotai mai mediatai luva 'uluna de'ika deabi 'inia, dekula'ila vaia edada'amo vuavuata devapulu.” ");
INSERT INTO nrz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu e'outa ediaka, “Kau ka lamepa etoua koanai olaka laloanai sia evaakububua 'o muinai vakana venunai sia evalavala divo ia lamepa ikau'auna 'abunai eka'ua 'au inoku kau bedododo kauta 'eva 'ailala beikala. ");
INSERT INTO nrz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dava devunita davata boutai 'eva bevala'asi makaanai, dava devaku avu davata boutai 'eva bevala'asi 'ailalai. ");
INSERT INTO nrz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Luva aoika koma 'eva bo'imala kave'i, 'olana maiena dava kauna 'eva akanai vaida Dilava bene'e 'au bevenia, ia sia maiena dava kauna 'eva kevanai kava'inamo elalovaia emimia davana 'eva beabia ovo.” ");
INSERT INTO nrz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inoku Iesu sinana mai kadina deasi beikala beia sia edaita 'olana kau mato namavaikana 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kau ka Iesu e'ouia ediaka, “Oni sinamu mai kadimu 'eva mulimuliai delalava de'ula beikamu.” ");
INSERT INTO nrz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Inoku Iesu ia ena luva evamuea ediaka, “Dilava ena luva 'uluna de'ika mai vinaulana devavaia kauta katania 'eva lau sina'u mai lau kadi'u.” ");
INSERT INTO nrz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Melala ka Iesu ibanona kauta ita asiai dele'au inoku e'outa ediaka, “Ita ekada'a 'ovu avekena.” Inoku deveau asi deda'a. ");
INSERT INTO nrz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Deveau do'o laloanai, Iesu 'eva enodivo inoku emuinai tabu. Inoku levo nama vaikana 'ovuai eunu, vei asi laloanai elaia uda kevaimo deuku. ");
INSERT INTO nrz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ibanona kauta deda'a Iesu dekuia dediaka, “'Ola kaumu e, 'ola kaumu e, ita 'ani ekadono ba.” Inoku ia eko'isi lani mai ka'uda namata e'ovenita, lani e'olo ka'uda enodivo. ");
INSERT INTO nrz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Inoku ibanona kauta e'outa ediaka, “Emui abiveni a'i?” Ia detabulovo si'asi'a maivaka demakau si'asi'a mai sibota viloatai delavuai lavuai dediaka, “Nia 'eva kau davana, lani mai ka'uda e'ovenita 'eva lelena de'ika.” ");
INSERT INTO nrz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu ibanona kauta ita asiai deveau keini deda'a Kelasenesa kanonai, ua 'eva Kalilea 'ovu avekenai. ");
INSERT INTO nrz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu ele'au nabuai koanai, vanua kauna ka nuanai ka'uba si'avata vaika demia kauna easi ita devidavali. 'Ani siako vaika kau kanania sia tubu'a ka evadodoa mai lumai sia eomia, ia 'eva mitavai eomia. ");
INSERT INTO nrz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ia Iesu eikaia koanai ekani si'asi'a mai e'eko aena 'olanai evaoi 'unu'unu ediaka, “Iesu aka umaunai Dilavana Nakuna e, o'ula dava keva'uai bovavaia. Anoimu mekau sia boveni'u.” ");
INSERT INTO nrz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","'Olana Iesu ka'uba si'avana 'ani e'ovenia kau kanaua nuanai bela'asi 'ounai. Melala doutamo ka'uba si'avana evada'ala, kau deta'u imana mai aena seiniai deliota de'imaia beia seini evamokuta inoku ka'uba si'avana evaasiasia eveau eda'a kano'akunai edodo. ");
INSERT INTO nrz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu ia elavuaia ediaka, “Vamu dai?” Ia ediaka, “Va'u 'eva Mato.” 'Olana ka'uba si'avata vaika doutamo vaika nuanai demia. ");
INSERT INTO nrz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Beia ka'uba si'avata vaika Iesu denoia sia besinita beda'a 'uli to'ona asi'i laloanai bedododo. ");
INSERT INTO nrz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Boloma 'itona ka ua'i devananita lolo 'aba'abanai deaniani, inoku ka'uba si'avata vaika Iesu denoia besinita beda'a boloma nuatai bedododo 'ounai esinita deda'a. ");
INSERT INTO nrz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Inoku ka'uba si'avata vaika kau kanaua nuanai dela'asi deda'a boloma nuatai dedodo, boloma 'itona deveau ke'eke'eai delovo asi, inoku 'ovu laloanai dedono ba. ");
INSERT INTO nrz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Boloma 'ima kauta dava kanaua epulu deikaia koanai deveau ovo vanuai mai lobai vali kanania dekavaia. ");
INSERT INTO nrz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kau deda'a dava epulu davana beikala deko inoku Iesu kevanai dela'asi koanai, kau kanaua nuanai ka'uba si'avata vaika dela'asi kauna Iesu aena 'olanai emiadivo tubua evadodoa maivaka nuana 'ani ekomolo deikaia inoku boutai demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kau kataua dava epulu deikaia kauta kau kanaua nuanai ka'uba si'avata vaika demia kauna a enama'ina koma 'eva valina kau vailatai dekava. ");
INSERT INTO nrz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kelasenesa kauta boutai demakau si'asi'a 'ounai Iesu denoia kano kanaua'i beda'atau. Kanaua 'ounai ia asiai ele'au bemumue. ");
INSERT INTO nrz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ka'uba si'avata vaika kau nuanai dela'asi kauna kanaua Iesu enoia bemabanoa, beia Iesu eta'u evamuea e'ouia ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bomumue emu vanua, Dilava dava evavaia kevamuai davana valina bokakava.” Kanaua 'ounai kau kanaua eda'a vanua itoina laloanai Iesu dava evavaia kevanai davana valina ekava. ");
INSERT INTO nrz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu emue koanai, kau mato deta'u deabia dae 'olana boutai 'eva ia de'imaia. ");
INSERT INTO nrz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ua'i kau ka vana Iailo, ia 'eva lo'e e'ola vaia kauna, easi inoku Iesu aena 'olanai ekuidula 'eva enoia beda'a ena luma. ");
INSERT INTO nrz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","'Olana nakuna vatona ka'oukukuna mo vikauna ouka lua 'eva 'ani bebaba. Iesu eda'a do'o laloanai kau mato nama vaikana devidolividoli mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Inoku ateate ka ua'i, ia 'eva 'a'ate eta 'olele eabia 'ani vikau ouka lua, mulamula veni kauta kevatai ena dava evaole, sia kau ka ia evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ia Iesu mulinai enanadia eda'a ena tubu'a si'ana eabia kovo, komolonai mo ena 'olele e'olo. ");
INSERT INTO nrz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu elavuai lavuai ediaka, “Dai eabi'u kovo?” Boutai de'ouavuavu laloanai Petelo ediaka, “'Ola kaumu e, kau delavamu kaiukaiu mai depedamu.” ");
INSERT INTO nrz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Beia Iesu ediaka, “Kau ka eabi'u kovo 'olana aikabasi 'eva siavu kau'uai davana 'ani ela'asi.” ");
INSERT INTO nrz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ateate eikabasi bepopode 'eva dalana asi'i 'ounai mai 'ululu 'ululuna eda'a e'eko Iesu aena 'olanai, dava 'ounai eabia kovo maivaka alimo a enama'ina koma valina kau boutai vailatai ekava. ");
INSERT INTO nrz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Inoku Iesu ateate kanaua e'ouia ediaka, “Naku'u ateatena e, emu abiveni eta'u 'ani evanama'inamu 'ounai nua'elumu ita da'a.” ");
INSERT INTO nrz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu eluva do'o laloanai kau ka Iailo ena lumai easi Iailo e'ouia ediaka, “Nakumu 'ani eba. Vaikabasi kauna sia vabavunua 'avaea.” ");
INSERT INTO nrz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu lele kanaua e'ika inoku Iailo e'ouia ediaka, “Sia bomakau, boabiveni'u mo. Nakumu 'eva benama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iesu Iailo ena lumai ele'au koanai kau boutai evamueta sia ka ia mulinai bedododo, beia Petelo, Iakobo, mai Ioane mai vato kamana sinana mo debanoia dedodo. ");
INSERT INTO nrz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kau boutai ua'i 'eva vato dekani diala mai delaloia. Iesu ediaka, “Kani ovapuala, vato 'eva sia eba, ia emuinai.” ");
INSERT INTO nrz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kau deikabasi vato 'eva 'ani eba dokadoka 'ounai Iesu deikaia demamai. ");
INSERT INTO nrz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iesu vato imanai eabi inoku e'aeia ediaka, “Naku'u e, ko'isi.” ");
INSERT INTO nrz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Vato idumena emue 'eva komolonai eko'isi, inoku Iesu e'outa dava kena bevenia beania. ");
INSERT INTO nrz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Vato kamana mai sinana detabulovo si'asi'a, beia Iesu e'alavuta dava epulu davana 'eva sia kau ka vailanai beluvala. ");
INSERT INTO nrz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu eta'u ibanona kauta 'ouka lua e'aeta, evado'uta, kula'ila mai siavu evenita ka'uba si'avata vaika boutai belo'ota asi mai 'olele edeata edeata bevanama'inata, ");
INSERT INTO nrz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","inoku esinita Dilava ena lovia vanuana valina beilolo vaia maivaka 'olele kauta bevanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","E'outa ediaka “Emui kalima ai, ikoko'a, voina, iani mai moni sia ka oiboabia, maivaka emui ivadodo ivaluata sia oi bo'abi. ");
INSERT INTO nrz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Luma davanai oi boele'au koanai kanaua'imo oi bomimia beda'amo vanua kanaua oi bovikania. ");
INSERT INTO nrz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Inoku kau sia beabimui dae koanai eta vanua oi bovikania 'eva aemui apulolota oi boaku ovo ia eta va'evai be'ao maivaka ia eta si'avana ivamomo'aina koana.” ");
INSERT INTO nrz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Inoku ibanona kauta deko'isi deda'a vanua kaka laloatai vali nama'ina deilolo vaia maivaka kau devanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","'Eloda Lovia 'olana kauna 'eva Iesu dava boutai evavai valita e'ika koanai nuana ebavunu, 'olana vaida de'ouia vaidi'u kabukabu kauna Ioane 'ani bai eko'isi 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Vaida dediaka Elia 'ani evailaasi, mai vaida dediaka enolea kauna 'ana'ina ka vali'u eko'isi 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Beia 'Eloda ediaka, “Ioane 'atona 'eva 'ani atauia uku, beia 'ulu a'ika vinaula katania evavai kauna 'eva dai?” Inoku eula 'eva Iesu beikala. ");
INSERT INTO nrz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Veauneke kauta demue koanai, ia dava devavai davata boutai Iesu vailanai deluvavaita. Inoku ia eta'u evada'ata tau ia ita deda'a vanua ka vana Betesaida ai. ");
INSERT INTO nrz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Beia kau deikabasi Iesu 'eva 'ani ua'i 'ounai boutai ia mulinai deda'a. Iesu eabita dae, Dilava ena lovia vanuana luvana eluvavaia maivaka nama'ina deula kauta evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Melala elavilavi laloanai ibanona kauta 'ouka lua deasi Iesu kevana inoku de'ouia dediaka, “Kau katania sinita deda'a vanua 'o loba kevai kauta kevatai bemimia inoku sibota eta iani bekakavu 'olana 'abu kanania 'eva kano'akuna.” ");
INSERT INTO nrz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iesu ia eta luva evamuea ediaka, “Oi dava kena ovenita deania.” Ia dediaka, “Lai kevamaiai demimia davata 'eva palaoa ima mai sisi lua mo, o'ula lai bada'a kau katania eta iani lai batatava, una?” ");
INSERT INTO nrz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Momoluane 'avaeana 'eva sinavu boutai imanavui (5,000) boina. Iesu ibanona kauta e'outa ediaka, “Kau katania kauta imanavui (50) imanavui (50) oi bovamiata.” ");
INSERT INTO nrz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eluva dalana vitaitanai ibanona kauta devavaia inoku kau boutai demiadivo. ");
INSERT INTO nrz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu eta'u palaoa ima mai sisi luana eabita inoku e'a'a dae vutuvutu eikaia 'eva evanama'inata, mulinai ekovita mukamuka. Inoku ibanona kauta evenita bekokole kau bevenita. ");
INSERT INTO nrz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kau boutai deaniani eda'amo deani vunu, ibanona kauta iani kalita alavu 'ouka lua devavonuta. ");
INSERT INTO nrz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Melala ka Iesu sibona emeamea, ibanona kauta 'eva ia kevanai demia inoku elavuaita ediaka, “Kau 'eva dava dekoma lau 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ia ena luva devamuea dediaka, “Vaida dediaka Vaidi'u kabukabu kauna Ioane, vaida dediaka Elia, vaida dediaka enolea kauna 'ana'inai ka vali'u eko'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iesu ia elavuaita, “Beia oi 'eva dava oi okoma? Lau 'eva dai?” Petelo ia ena luva evamuea ediaka, “Oni 'eva Keliso Dilava esinimu kaumu.” ");
INSERT INTO nrz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ia eta'u e'outa kao sia kau ka be'oua kovo. ");
INSERT INTO nrz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mai ediaka, “Lau Kau Nakuna 'eva banana vaika, vanua kauta namata, kabukabu kauta namata mai talavatu 'ola kauta bevaiviivi'u maivaka beaku ba'u, beia melala ivakoinai 'eva bako'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Inoku Iesu ia boutai e'outa ediaka, “Kau ka e'ula lau bebano'u koanai, ia sibona ena mauli bebolabolala melala bounai ena au ido'o valaukuna beabia 'isi bevuala lau muli'uai bedada'a. ");
INSERT INTO nrz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","'Olana dai ena mauli beabi 'inia kauna 'eva ena mauli bevataulea, beia dai lau dai'uai ena mauli beitoa'au kauna 'eva mauli beabia. ");
INSERT INTO nrz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kau ka kanobata davata boutai bema abita inoku ena mauli bema vataulea 'o bema vasi'avanala koanai ena nama'ina 'eva dava? ");
INSERT INTO nrz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kau ka lau dai'uai 'o e'u luva 'outai bemalalai koanai, Lau Kau Nakuna e'u nuaviai maivaka Kamana ena nuaviai mai anelu kabukabuta eta nuaviai ia ena mue melalanai bemalalai veni'u. ");
INSERT INTO nrz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Luva umauna lau oi a'oumui, nia'i delalava kauta vaida 'eva sia bebaba beda'amo Dilava ena lovia vanuana beikala.” ");
INSERT INTO nrz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Luva katania eluvavai mulitai melala kalavani deole 'eva Iesu eta'u Petelo, Ioane mai Iakobo evuata ia ita deda'a loloai dele'au bemeamea 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Emeamea laloanai ia vailana edeana mai ena tubu'a edeva'i si'asi'a e'amale 'amale. ");
INSERT INTO nrz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Alimo kau lua ia ita deluvaluva, kauta 'eva Mose mai Elia. ");
INSERT INTO nrz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mainuavita dela'asi Iesu ita Dilava ena ula vitaitanai Ielusalemai Iesu ena ba luvana deluvaluva vaia. ");
INSERT INTO nrz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petelo banona ita 'eva demuinai tabu inoku deibi kave'i laloanai, Iesu nuavina mai kau luana kevanai delava vaka deikata. ");
INSERT INTO nrz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kau luana Iesu 'ani bevikania laloanai, Petelo eta'u Iesu e'ouia ediaka, “'Ola kaumu e, ita nia'i kamimia 'eva emediana vaika! Lai aiole koi lai bavavai, ka oni emu, ka Mose ena, ka Elia ena.” Ia sia eikabasi dava luvana eluva. ");
INSERT INTO nrz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ia eluva do'o laloanai oli easi boutai e'alavuta, inoku ia oli laloanai 'eva demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lele ka oli laloanai easi ediaka, “Nia 'eva Lau Naku'u, adilaia kauna, lelena oi bo'ika.” ");
INSERT INTO nrz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lele kanaua eole mulinai Iesu sibona mo deikaia. Ibanona kauta 'ulu 'uluta asi'i, maivaka melala kanaua'i dava deikata davata 'eva sia kau ka de'ouia. ");
INSERT INTO nrz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Elani ia loloai de'ovu koanai Iesu kau doutamo ita devidavali. ");
INSERT INTO nrz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kau ka kau viloatai evaoi ediaka, “Vaikabasi kaumu e, lau oni anoimu, naku'u kanania ikala, naku'u ka'oukukuna mo kanania. ");
INSERT INTO nrz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Melala vaida ka'uba ka melo kanania eabia koanai komolonai evaoi, evatakutaku si'ala, nutunai budobudo dela'asi, sia evikania edada'amo kauna etatalo pa'apa'a. ");
INSERT INTO nrz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lau debanomu kauta anoita ka'uba si'avana vaika belo'oa la'asi, beia ia sia edaita.” ");
INSERT INTO nrz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu e'outa ediaka, “Abiveni asi'i mai kaia bo'o uluna kaumui, kevamuiai ita ekamia ka'ona beda'amo melala davanai? Nakumu vuala mai keva'u.” ");
INSERT INTO nrz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Melo eda'a ilulao koanai ka'uba si'avana vaikana eta'u melo kanoai ebalaia divo eva'ululu si'ala, Iesu eta'u ka'uba si'avana vaika e'ovenia inoku melo evamaulia, evuaia eda'a kamana evenia. ");
INSERT INTO nrz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dilava ena siavu nama vaikanai kau boutai deda'unai si'asi'a. Ia Iesu dava evavaia davana deda'unai vaia do'o laloanai ibanona kauta e'outa, ");
INSERT INTO nrz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Luva kevamuiai 'ani baluva vaia luvana 'eva kaiamui ovaala kave'i. Lau Kau Nakuna 'eva veni'u beveveni mai kou'u bekokou kau kevatai.” ");
INSERT INTO nrz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Beia ena luva kanania anina sia deikabasia. Ia kevatai dava eluva vaia davana 'eva evuni 'ounai ovona sia deovo, inoku belavuaia 'eva demakau. ");
INSERT INTO nrz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Melala ka ibanona kauta sibotamo viloatai deviala dai 'eva namana be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu eta lalovai kanaua eikabasia 'ounai melo kikina ka evuaia easi kevanai evalavaladivo. ");
INSERT INTO nrz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Inoku e'outa ediaka, “Kau ka lau va'uai melo kikina kanania eabia dae kauna 'eva lau eabi'u dae, lau eabi'u dae kauna 'eva esini'u Dilavana vaka eabia dae. Oi boumuiai viloamuiai ka ekiki vaika kauna ia 'eva namana be'ao.” ");
INSERT INTO nrz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioane Iesu e'ouia ediaka, “'Ola kaumu e, lai kau ka lai aikaia oni vamuai ka'uba si'avata vaika elo'ota asi. Inoku lai a'ouia bevapuala 'olana ia 'eva sia ita banota.” ");
INSERT INTO nrz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu e'outa ediaka, “Sia oi boma'alavuia, 'olana sia evaiviivimui kauna 'eva oi banomui.” ");
INSERT INTO nrz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu bemumue vutuvutu beda'ala melalana ekevai laloanai ia nuana evakula'ilala eko'isi eda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Inoku ena veauneke kauta esinita makava deda'a Samalia vanuana ka laloanai ia dainai dava boutai beva'oluta. ");
INSERT INTO nrz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Beia kau ua'i kauta sia deabia dae, 'olana ia deikabasi Iesu 'eva edada'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ibanona kauta Iakobo mai Ioane koa kanaua deikaia koanai delavuaia dediaka, “Lovia namana e, o'ula 'alova vutuvutuai lai ba'aea, be'ovu be'abuta uku'uku, una?” ");
INSERT INTO nrz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Beia Iesu ekai 'udai laluana e'ovenita. ");
INSERT INTO nrz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Inoku ia ibanona kauta ita deda'a vanua edeana ka. ");
INSERT INTO nrz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ia dalai deda'a laloanai kau ka Iesu e'ouia ediaka, “Lau oni a oda'ala 'eva mulimuai badada'a.” ");
INSERT INTO nrz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Beia Iesu ia e'ouia ediaka, “'Oveka 'asita 'eva mai eta 'uli, aka manumanuta vaka mai eta ni'i, beia Lau Kau Nakuna baenodivo la'u ba'ani 'abuna 'eva asi'i.” ");
INSERT INTO nrz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mai Iesu kau ka e'ouia ediaka, “Muli'uai mai.” Beia kau kanaua ediaka, “Lovia namana e, bada'a makava kama'u bakoleia 'ana'i.” ");
INSERT INTO nrz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu ia e'ouia ediaka, “Debaba kauta 'eva sibota eta ba bekolea, beia oni 'eva da'a Dilava ena lovia vanuana valina boilolo vaia.” ");
INSERT INTO nrz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mune'e kaumo ka ediaka, “Lovia namana e, lau mulimuai badada'a, beia bada'a makava e'u pulu kauta ba'outa no'olo.” ");
INSERT INTO nrz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu ena luva evamuea ediaka, “Kau ka voi isivana imanai eabia, ia bekai 'udai basibasi kauna 'eva Dilava ena lovia vanuana vinaulana bevavaia 'eva sia bedaia.” ");
INSERT INTO nrz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kanania mulinai Lovia namana eta'u vaida edeata kauta kalakoi ka navui lua edilata, boutai viloatai lua lua esinita be'ana'ia beda'a ia sibona bedada'a vanuata mai 'abuta boutai. ");
INSERT INTO nrz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","E'outa ediaka, “Loba ianina 'eva edounamo vaika beia vinaula kauta 'eva sia dounamo, kanaua 'ounai loba 'ola kauna oi bonoia, ia betata'u vinaula kauta besinita ena lobai bevinaula. ");
INSERT INTO nrz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Oda'a! Lau oi asinimui vitaitana mamoe nakuta boita 'oveka asita viloatai. ");
INSERT INTO nrz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Idavala, 'o tamaka ka sia oi boabia. Dalai vaka sia kau ka ita oi boluvaluva. ");
INSERT INTO nrz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Luma davanai oi boele'au koanai, oi boluvala makavana luvana 'eva kanania, ‘Nua'elu 'eva luma kanania'i!’ ");
INSERT INTO nrz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kau kanaua nuana nua'elu emimia koanai, oi emui nua'elu 'eva ia akanai bemimia. Bema asi'i koanai emui nua'elu 'eva bemumue kevamui. ");
INSERT INTO nrz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ita luma kanaua'i oi bomia ka'ona, dava deveveni davata oi bo'ani mai oibo'inu, 'olana vinaula kauna mai tavana 'eva enama'ina. Luma ka ka sia oi boda'a neke. ");
INSERT INTO nrz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Vanua davana laloanai oi boda'a dodo inoku beabimui dae koanai, vailamuiai dava devalavala davana oi boania, ");
INSERT INTO nrz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","vanua kanaua'i 'olele kauta oi bovamaulita, maivaka oi bo'outa, bodiaka, ‘Dilava ena lovia vanuana 'eva 'ani e'asi kele'emui.’ ");
INSERT INTO nrz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Beia vanua ka laloanai oi boda'a dodo inoku sia beabimui dae koanai dalanai oi bola'asi oi bodiaka, ");
INSERT INTO nrz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Emui vanua 'apulolona aemaiai deavu 'au davana 'ani lai adavua ovo evavasi kele'emui. Inoku oi boikabasi Dilava ena lovia vanuana 'eva 'ani ekevai.’ ");
INSERT INTO nrz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lau oi a'oumui, lavuai melalanai Sodoma ena anaana 'eva kena benama'ina beia vanua kanaua ena anaana 'eva namana be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kolasina e! Kevamuai 'eva besi'avana vaika. Betesaida e! Oni vaka kevamuai 'eva besi'avana vaika. Inoku vatabulovo vinaulata katania kevamuiai avavai davata ua'i Tulo mai Sidono laloatai bamavavai koanai, 'ani siako ia bemalalo 'udai, tubu'a si'avata bemavadodota lavuai bemato'ata bemamia. ");
INSERT INTO nrz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lavuai melalanai Tulo mai Sidono eta anaana kena benama'ina beia oi emui 'eva namana be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapelanauma e! Oni vaka. Sibomu bomaele'au bomada'a vutuvutu akanai okoma. Beia sia bedaia. Oni 'eva bedolimu 'ovo bo'ovu ba 'abuna.” ");
INSERT INTO nrz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu ibanona kauta e'outa ediaka, “Oi lelemui e'ika kauna lau lele'u vaka 'ani e'ika, oi devaiviivimui kauta lau vaka devaiviivi'u, beia lau evaiviivi'u kauna esini'u kauna vaka evaiviivia.” ");
INSERT INTO nrz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kauta kalakoi ka navui lua deda'a inoku mai lalonamata demue kevana de'ouia dediaka, “Lovia namana e, oni vamuai ka'uba si'avata vaika lai alo'ota 'asi 'eva lelemai deika.” ");
INSERT INTO nrz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu ia e'outa ediaka, “Lau Satani vutuvutuai e'ekoasi aikaia 'eva itani e'amalea boina. ");
INSERT INTO nrz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lau siavu oi 'ani avenimui, kau'asi 'o 'a'ava oi bomoi kaita mai 'ou kauna vaka ena siavu bounai oi bokeinita, dava sia ka beudupa'amui. ");
INSERT INTO nrz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ka'uba si'avata vaika lelemui de'ika 'ounai sia oi bolalonama, beia vamui vutuvutuai 'ani deleleta davata 'eva oi bolalonama vaita.” ");
INSERT INTO nrz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Melala kanaua'i Iesu Idume Kabukabuna dainai lalona denama si'asi'a inoku ediaka, “Kama'u e, vutuvutu mai kanobata Loviana avanama'inamu, 'olana dava katania aoneka mai nuakomolo kauta kevatai ovunita davata melo kikita kevatai ovala'asita. 'O, kama'u, 'olana kanania 'eva oni emu ula nama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dava boutai 'eva Kama'u 'ani eveni'u keva'uai, Nakuna 'eva sia kau ka eikabasia beia Kamana sibonamo, Kamana vaka sia kau ka eikabasia Nakuna mo mai nakuna edilata kauta ia bevala'asia kauta mo sibota.” ");
INSERT INTO nrz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Inoku Iesu ekai 'udai ibanona kauta e'outa ediaka, “Dava katania oi o'ika kaumui 'eva oi onama'ina 'ounai oi oikata une. ");
INSERT INTO nrz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","'Olana lau oi a'oumui, enolea kauta mai vanua loviata doutamo de'ula oi o'ika davata bemaika beia sia deika, de'ula leleta oi o'ika davata vaka bemaika beia leleta sia deika.” ");
INSERT INTO nrz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Talavatu 'ola kauna ka eko'isi Iesu ekovoia ediaka, “Vaikabasi kaumu e, dava bavavaia 'eva mauli keinikeini babia?” ");
INSERT INTO nrz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu ia ena luva evamuea ediaka, “Talavatu pukana laloanai a deleleia koma? A oikabasi koma?” ");
INSERT INTO nrz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ia Iesu ena luva evamuea ediaka, “Lovia namana emu Dilava bolalo'au venia mainuamu bounai, mai idumemu bounai, mai kula'ilamu bounai, mai emu lalovai bounai, maivaka kevamu kauna bolalo'au venia oni sibomu olalo'au venimu boina.” ");
INSERT INTO nrz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu ia ena luva evamuea ediaka, “Emu luva 'eva ekomolo, kanania bovavai koma koanai bomauli.” ");
INSERT INTO nrz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Talavatu 'ola kauna sibona eapavaia elavuai lavuai ediaka, “Inoku keva'u kauna 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu ia ena luva evamuea ediaka, “Kau ka Ielusalema ai e'ovu eda'a Ieliko laloanai vinaovinao kauta delavaia avu, ena tubu'a devadada ovo, deaku si'ala kevaimo bemaba inoku devikania. ");
INSERT INTO nrz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Melala kanaua'i kabukabu kauna ka dala kanaua'i eda'a, eikaia koanai dala 'aba'abanai ekeini. ");
INSERT INTO nrz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vitaitana vaka Levi iduvuna kauna ka dala kanaua'i eda'a, eikaia koanai dala 'aba'abanai ekeini. ");
INSERT INTO nrz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Beia Samalia kauna ka ena da'a to'ato'ai dala kanaua'i easi kau kanaua kevanai ela'asi, eikaia koanai elaloia vaika. ");
INSERT INTO nrz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eda'a kevana inoku kauna loita deolo mai vine veinai eukuta inoku e'apata. Inoku ena doniki akanai evamiala'au, evuaia eda'a ikakao lumanai ua'i e'imaia. ");
INSERT INTO nrz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Elani kau kanaua eta'u siliva monita lua edala isi luma ikakaona kauna evenia inoku e'ouia ediaka, ‘Bo'imala kave'i, kevanai vida bonene'e 'eva e'u mueai tavata bavenimu.’” ");
INSERT INTO nrz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu ia elavuaia ediaka, “Oni dava okoma? Kau kataua kakoina laloatai davana 'eva vinaovinao kauta deakuia kauna kevana kaunai evaaoa?” ");
INSERT INTO nrz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ia ediaka, “Elaloia vaika kauna kanaua.” Iesu ia e'ouia ediaka, “Da'a evavaia vitaitanamo bovavaia.” ");
INSERT INTO nrz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu ibanona kauta ita dalai deda'a vanua edeana kai dela'asi, ua'i ateate ka vana Maleta eta'u eabita dae ena lumai. ");
INSERT INTO nrz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ia kadina vana Malia 'eva eda'a Lovia namana aena 'olanai emia divo ena vaikabasi luvata leleta eika. ");
INSERT INTO nrz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Beia Maleta iabi dae vinaulata evavaitai 'eva nuana ebavunu, inoku eko'isi eda'a Iesu e'ouia ediaka, “Lovia namana e, oni sia olalovaia kadi'u kanana evikani'u sibo'u vinaula boutai avavai. 'Oua edulu'u.” ");
INSERT INTO nrz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lovia namana ia ena luva evamuea ediaka, “Maleta e, Maleta e, oni 'eva dava doutamo ilalovaitai nuamu ovabavunua, ");
INSERT INTO nrz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","beia dava ka'onamo mo ka'ula davana 'eva Malia 'ani eula venia, ia kevanai sia beabia tau kovo.” ");
INSERT INTO nrz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Melala ka Iesu 'abu ka ai emeamea, emeamea koa mulinai ibanona kauta ka eta'u e'ouia ediaka, “Lovia namana e, meamea vaikabasimai Ioane ibanona kauta evaikabasita boina.” ");
INSERT INTO nrz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Inoku Iesu ia e'outa ediaka, “Oi bomeamea koanai kanania oi boluva koma. ‘Kamamai e. Oni vamu 'eva lai bavakabukabua. Emu lovia vanuana emai. ");
INSERT INTO nrz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Melala ka ka laloatai lai aula veni ianita bovenimai. ");
INSERT INTO nrz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Devasi'avanamai kauta eta si'avana lai a'outa kao vitaitanai emai si'avana bo'ou kao. Maivaka vikovo laloanai sia bovadodomai.’” ");
INSERT INTO nrz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mai mune'e e'outa ediaka, “Oi kaumui ka malolua ai bemada'a ena kau ena lumai bemanoia bemadiaka, ‘E'u kau e, palaoa koi mo veni'u. ");
INSERT INTO nrz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","'Olana e'u kau ka ena da'a to'ato'a laloanai easi keva'u, bavanania beia keva'u iani asi'i.’ ");
INSERT INTO nrz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Inoku ua'i laloai bediaka, ‘Sia bovabavunu'u, nutuala 'eva 'ani i'alavuna maivaka lau naku'u ita 'eva lai amuinai. Sia 'ani bako'isi dava ka bavenimu.’ ");
INSERT INTO nrz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Lau oi a'oumui, ena kau 'ounai ia sia beko'isi dava ka bevenia, beia ena noinoi 'udai'udai 'ounai beko'isi, ia e'ula davata boutai bevenia. ");
INSERT INTO nrz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mai lau oi a'oumui, oi bonoinoi 'eva oi boabia, oibokavua 'eva oi bodavalia, oi boakuaku 'eva emui nutuala beluvua. ");
INSERT INTO nrz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kau kataua boutai denoinoivai davata 'eva de'abi, ekakavu kauna 'eva edavali, ekuaku kauna 'eva nutualana beluvua. ");
INSERT INTO nrz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Oi kama kaumui ka nakumu sisi bemanoimu koanai, kau'asi bomavenia, una? ");
INSERT INTO nrz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'O akoi bemanoimu koanai 'a'ava bomavenia, una? ");
INSERT INTO nrz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oi si'avana kaumui beia, dava nama'ita nakumui ivenita oi oikabasi. Kamamui vutuvutuai emimia kauna nama'ina vida denoia kauta Idume Kabukabuna bevenita.” ");
INSERT INTO nrz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu eta'u nutububu mu'umu'una kau ka nuanai elo'oia asi, mu'umu'u kanaua ela'asi inoku nutububu kauna eluvaluva, deikaia kauta detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Beia kau vaida dediaka, “Belesebulo mu'umu'u eta lovia 'olana ena siavuai ia mu'umu'u katania elo'ota asi.” ");
INSERT INTO nrz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vaida Iesu devakovoa eta ula vutuvutuai koa ka bevavaia beikala. ");
INSERT INTO nrz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Beia Iesu 'eva eta lalovai eikabasi, 'ounai e'outa ediaka, “Kanobata ka sibona bekole luala inoku sibota bevaiviivita 'eva besi'avana, maivaka iduvu ka sibona bekole luala inoku bevaiviivita 'eva be'eko asi. ");
INSERT INTO nrz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satani sibona bekole luala inoku sibota bevaiviivita koanai, ena kanobata a belava 'ini koma? Luva kanania aluvala 'olana oi odiaka ‘Belesebulo ena siavuai mu'umu'u alo'ota asi.’ ");
INSERT INTO nrz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lau Belesebulo ena siavuai mu'umu'u alo'ota asi koanai, dai ena siavuai oi ibanomui kauta detata'u mu'umu'u delo'ota asi? Kanaua 'ounai ia betata'u oi bevakomolomui. ");
INSERT INTO nrz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bema lau Dilava ena siavuai mu'umu'u alo'ota asi koanai, Dilava ena lovia vanuana 'eva 'ani easi kevamui. ");
INSERT INTO nrz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kula'ila kauna maiena uku inoku ena luma be'imala koanai ena dava boutai 'eva bemia kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Beia ekula'ila si'asi'a kauna ka ia bekuali venia inoku beakua koanai, ena uku imanai beabita ovo inoku ena dava boutai bekole siusiu. ");
INSERT INTO nrz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Dai'uai sia edadai kauna 'eva lau evaiviivi'u, lau ita sia lai adoubou doubou kauna 'eva ekapota odaoda. ");
INSERT INTO nrz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ka'uba si'avana vaika kau ka nuanai ela'asi koanai, 'abu ladata ai eda'a to'ato'a, ena ula 'eva lana be'ani beia sia 'abu ka edavalia. Sibona ediaka, ‘Bamumue bada'a avikania lumana.’ ");
INSERT INTO nrz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Inoku emue eda'a luma koanai, luma 'eva 'ani idalona maivaka iva'olu kave'ina edavalia. ");
INSERT INTO nrz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Inoku ia eda'a ka'uba si'avata vaika umauta kalakoi ka evuata deasi, inoku deda'a dedodo ua'i demia, kau kanaua ena mauli 'ana'inai kena esi'avana, beia vali'u ena mauli 'eva 'ani esi'avana vaika.” ");
INSERT INTO nrz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu luva katania eluva laloanai ateate ka kau mato viloatai evaoi ediaka, “Oni evapulumu mai evabaemu ateatena 'eva enama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Beia Iesu ena luva evamuea ediaka, “Sia kanaua bekoma, momo'ai dokadoka Dilava ena luva de'ika maivaka deabidae kauta 'eva denama'ina vaika.” ");
INSERT INTO nrz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kau mato Iesu delavaia kaiukaiu laloanai, ena luva emakavala ediaka, “Ulu kanania 'eva ulu si'avana vaika, vatabulovo koata ekakavu, beia sia ka bepupulu kevatai, Iona sibona mo 'eva vatabulovo koanai be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iona 'eva vatabulovo koanai eda'a Nineva kauta kevata vitaitanai Kau Nakuna 'eva ulu kanania kevanai. ");
INSERT INTO nrz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Valuva melalana laloanai lovia ateatena Seba ai beko'isi ulu kanania kauta va'eva abunai bene'etadivo, 'olana ia 'eva kanobata to'onai easi Solomona ena aoneka luvata be'ika, beia vali'u nia'i ka 'eva Solomona ekeinia. ");
INSERT INTO nrz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Valuva melalana laloanai Nineva kauta 'eva beko'isi ulu kanania kauta va'eva 'abunai bene'etadivo, 'olana Iona ena iloloai 'eva delalo 'udai, beia vali'u nia'i ka 'eva Iona ekeinia. ");
INSERT INTO nrz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kau ka lamepa betoua koanai luma venunai 'o olaka laloanai sia bevalavala uda, beia lamepa ikau 'auna 'abuna umaunai bekaua 'au inoku ua'i dedododo kauta 'eva 'ailala kanaua beikala. ");
INSERT INTO nrz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oni makamu 'eva kauanimu ena lamepa, inoku oni makamu enama'ina koanai kauanimu itoina vaka 'ailala laloanai, beia makamu besi'avana koanai kauanimu itoina 'eva vabuto'o laloanai. ");
INSERT INTO nrz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kanaua 'ounai bo'imamu kave'i 'ailala nuamuiai davana asi'i emavabula avu makauna. ");
INSERT INTO nrz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oni kauanimu itoinai e'ailala ovo sia kava'ina kena vabuto'o laloanai koanai, itoina 'eva be'ailala ovo kave'i itani lamepa 'ailalana itoinai evenimu eva'ailalamu boina.” ");
INSERT INTO nrz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu eluva koa koanai, Palisea kauna ka ia enoia laluana beaniani ka'ona 'ounai edodo eda'a emia divo beaniani. ");
INSERT INTO nrz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Palisea kauna Iesu eikaia 'eva etabulovo si'asi'a, 'olana asido'o eaniani laloanai imana sia edeini. ");
INSERT INTO nrz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Inoku Lovia namana ia e'ouia ediaka, “Vali'u oi Palisea kaumui 'eva 'ou mai olaka mulita mo oi odeini kave'i, beia nuamui 'eva idono mai si'avanai devonu. ");
INSERT INTO nrz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bo'o kaumui, ia mulina evavaia 'eva, laloana vaka sia evavaia, una? ");
INSERT INTO nrz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Beia laloatai demimia davata ulalu kauta oi bovenita. Inoku dava boutai 'ani bemediana oi emuiai. ");
INSERT INTO nrz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Palisea kaumui e, kevamuiai 'eva besi'avana vaika! 'Olana emui iani ivanama'inata mai ivasiavu siavuta kikita oi ovakuta 'ouka laloanai ka'onamo Dilava oi ovenia, ia Dilava kevanai komolo mai lalo'au oi boma vavaia davata oi ovikani. Ia kanania vaka oibovavaia, ia kanaua vaka sia oibovikania. ");
INSERT INTO nrz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Palisea kaumui e, kevamuiai 'eva besi'avana vaika! 'Olana emui ula 'eva lo'e laloanai miadivo 'abuta nama'itai oi bomimia, maivaka tavatava 'abutai 'olamui be'aku mai bevanama'inamui. ");
INSERT INTO nrz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Kele'emuiai besi'avana vaika! 'Olana oi 'eva vitaitana mitava 'ai'aita umauta, ia sia deikabasi kau akatai dedada'a de'asi inoku Dilava vailanai 'ani de'obu.’” ");
INSERT INTO nrz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Talavatu 'ola kauna ka ia e'ouia ediaka, “Vaikabasi kaumu e, oni kanania oluva koma 'eva lai vaka ovamalalaimai.” ");
INSERT INTO nrz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu ediaka, “Talavatu 'ola kaumui e, kevamuiai 'eva besi'avana vaika! Oi kau eveeve mekauta oi ovavua vaita, beia oi sibomui ka eveeve kanaua ena mekau aboina boma dulua 'eva imamui li'uli'una ka'onamo sia evalelea kovo. ");
INSERT INTO nrz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kele'emuiai besi'avana vaika! Oi kamamui enolea kauta deaku bata, inoku oi otata'u eta mitava oi odadau. ");
INSERT INTO nrz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kanaua 'ounai kamamui devavai vinaulata oi ovamomo'ai oi ovavaita, 'olana ia deaku bata, oi 'eva eta mitava oi odadau. ");
INSERT INTO nrz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kanaua 'ounai Dilava ena aoneka luvana ediaka, ‘Lau enolea kauta mai veauneke kauta basinita bedada'a, vaida 'eva beaku bata, vaida bevavaita si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kanaua 'ounai kanobata epulu easi mo vali'u enolea kauta boutai lalata de'itabu laloanai, mekauna 'eva ulu kanania kauta beko'ala. ");
INSERT INTO nrz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abela lalanai emakavala easi mo Sakalia lalanai, ia 'eva vanama'ina vakana mai lo'e kabukabuna viloatai deaku bala. 'O, lau oi a'oumui, mekauna 'eva ulu kanania kauta beko'ala. ");
INSERT INTO nrz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Talavatu 'ola kaumui e, kevamuiai 'eva besi'avana vaika! 'Olana aoneka dalana 'ani oi o'alavua, oi sibomui sia oi bodododo, bedododo kauta eta dala vaka oi olavala avu.” ");
INSERT INTO nrz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu 'abu kanaua evikania koanai, talavatu 'ola kauta mai Palisea kauta devaiviivia, eta lavuai luvata edeata edeata delavuaia. ");
INSERT INTO nrz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ena luva de'idima, ka be'oua si'asi'a koanai bevakoala. ");
INSERT INTO nrz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Melala kanaua'i kau doutamo vaika Iesu delavaia kaiukaiu mai sibota demoikai moikaita laloanai, Iesu ibanona kauta evaikabasita makava ediaka, “Palisea kauta eta dede vinaulana kevanai oibo'imamui kave'i, kanaua 'eva itani vakubu mulamulana boina. ");
INSERT INTO nrz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ia devakubu davata boutai bela'asi maivaka devunita davata boutai beikabasi. ");
INSERT INTO nrz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Vabuto'o laloanai luva dava oluvala luvana 'eva melala 'ailalanai lelena be'ika maivaka laloai kaianai oteteo luvana 'eva luma 'uvinai beilolovaia. ");
INSERT INTO nrz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“E'u kau e, lau oi a'oumui. Kauani iakubana mo deikabasi beia mulinai sia dava ka 'ani akanai bevavai 'udai 'ounai sia oi bomakau venita. ");
INSERT INTO nrz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Beia oi bomakau venia kauna lau batata'u bavaikabasimui. 'O, lau oi a'oumui, Dilava mo oi bomakau venia. Ia 'eva kauanimui beaku bala mulinai maiena siavu eani keini keini 'alovana laloanai bekapomui dodo. ");
INSERT INTO nrz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bisili ima kamatavata tavata pene lua mo. Beia Dilava 'eva kataua sia ka bebolabolala. ");
INSERT INTO nrz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Luva umauna, vui vida olamuiai 'eva 'ani evaku palu. Sia oi bomakau, oi 'eva bisili doutamo 'ani oi okeinita. ");
INSERT INTO nrz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Lau oi a'oumui. Kau ka kau vailatai lau vali'u bekakava, Lau Kau Nakuna vaka Dilava ena anelu vailatai ia valina bakakava. ");
INSERT INTO nrz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Beia kau vailatai lau bevuni'u kauna vaka Dilava ena anelu vailatai lau ia bavunia. ");
INSERT INTO nrz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kau ka Lau Kau Nakuna keva'uai luva si'avata beluluva 'eva ena si'avana 'ani ba'oua kao beia kau ka Idume Kabukabuna kevanai luva si'avata beluluva 'eva ena si'avana sia be'oua kao. ");
INSERT INTO nrz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bevuamui beda'a lo'eai, 'ana'iava kauta mai siavu kauta vailatai koanai, nuamu sia beba vunu eta luva a oi bovamuea koma 'o a oi boluva koma. ");
INSERT INTO nrz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","'Olana melala kanaua'i Idume Kabukabuna betata'u oni luva dava boluvala luvana 'ani bevaikabasimu.” ");
INSERT INTO nrz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kau mato laloatai kau ka Iesu e'ouia ediaka, “Vaikabasi kaumu e. 'A'u 'oua emai dava kamamai ebakanita davata laluana viloamaiai ekoleta.” ");
INSERT INTO nrz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu ia ena luva evamuea ediaka, “E'u kau e, dai lau eabi'u isi bavaluvamui maivaka emui dava bakoleta?” ");
INSERT INTO nrz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Inoku kau e'outa ediaka, “Oi bo'ika dava sia oi boidonovai, 'olana kau ena mauli umauna 'eva ena dava dounamoai sia easi.” ");
INSERT INTO nrz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iesu luva ivavitaitana ka e'outa. “Kevanai lavo dounamo kauna ka ena kanoai loba anita doutamo edavalita. ");
INSERT INTO nrz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Inoku sibona nuanai elalovai lalovai ediaka, ‘Dava bavavaia? 'Abu asi'i, 'abu davanai e'u iani ba'ule.’ ");
INSERT INTO nrz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Inoku ediaka, ‘Kanania bavavai koma, iani doubou lumana a'ia'ina baluvua inoku namana makamakana ka bavavaia, inoku e'u vinaula ianita mai e'u dava boutai ua'i ba'ule. ");
INSERT INTO nrz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lau sibo'u badiaka, “Lau 'eva dava nama'ita keva'uai 'ani doutamo vaika adoubou vikau doutamo eta. Vali'u la'uba'ani, baniani, bainuinu mai balalonama vaika.” ’ ");
INSERT INTO nrz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Beia Dilava eta'u e'ouia ediaka, ‘Bo'o kaumu e! Vali'u boni kanania'i lau oni emu mauli babia ovo koanai odoubou davata katana 'eva dai be'abi?’” ");
INSERT INTO nrz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Inoku Iesu ena luva to'onai ediaka, “Kanania 'eva kau ka sibona ena dava edoubou 'eva ia sibona ena, beia Dilava vailai ena doubou davata 'eva sia dounamo.” ");
INSERT INTO nrz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Inoku Iesu ibanona kauta e'outa ediaka, “Kanaua 'ounai lau oi a'oumui. Emui mauliai oi boma ani 'o kaumuiai oi boma vadodo davata daitai 'eva nuamui sia beva bavunua. ");
INSERT INTO nrz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","'Olana mauli 'eva namana vakaia iani mai kauani 'eva namana vakaia tubu'a. ");
INSERT INTO nrz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","'Alo oibolalovaita. Iani sia devavado 'o 'ua'ua melalanai iani sia de'ua maivaka eta doubou doubou lumana 'eva asi'i beia Dilava ia eta iani evenita. Inoku oi 'eva manumanu oi okeinita. ");
INSERT INTO nrz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oni dai emu nua bavunu betata'u emu mauli kena bevalaka'inala koanai 'ani bedaia 'o? ");
INSERT INTO nrz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kanaua 'ounai dava kikita katania ivavaita sia oi oikabasi koanai dava 'ounai dava edeata edeata nuamui devabavunuta. ");
INSERT INTO nrz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Velavela dekukubu 'eva oi boikata. Sibota tubu'a vinaulana sia devavaia. Beia lau oi a'oumui. Solomona lovia 'olana ena tubu'a denuavi si'asi'a, beia vela kanania 'eva enama'ina vaika vakaia Solomona ena tubu'a. ");
INSERT INTO nrz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dilava sibona duvu evavela velata vali'u demauli mala belamoda 'alovai ekakapota dodo belo'olo'o. Dilava eta'u kanaua evavelata koma, ia oi tubu'a sia evadodomui, una? Oi abiveni 'iu'iu kaumui. ");
INSERT INTO nrz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nuamuiai dava oi boma ani mai oi bomainu davata sia oi bokakavu, kataua sia oi bonua bavunuvai. ");
INSERT INTO nrz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kanobata kanania laloanai Dilava sia deabivenia kauta dava boutai katania dekakavu, Kamamui vutuvutuai oi oula venita davata katania 'eva 'ani eikabasi. ");
INSERT INTO nrz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Beia Dilava ena lovia vanuana oi bokavua makava vakaia katania boutai oi bevenimui.” ");
INSERT INTO nrz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mato kikina kaumui e. Sia oi bomakau, 'olana Kamamui mai lalonamana ena vanua bevenimui. ");
INSERT INTO nrz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Emui dava oi botava tavavaita monita ulalu kauta oi bovenita, sibomui emui idavala sia besi'avana kovo davana oi bova'olua, inoku vutuvutu lavona sia eole kovo 'abunai oi bo'ulea. Sia vinao kauna ka edada'a ua'i maivaka koekoe sia davaka ua'i devasi'avanala. ");
INSERT INTO nrz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","'Olana emui lavo demimia 'abuna 'eva oi nuamui vaka ua'i.” ");
INSERT INTO nrz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Emui tubu'a oi bovadodo maivaka emui lamepa 'eva oi bototou bovi'ima. ");
INSERT INTO nrz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Oi 'eva vitaitana vi'ima kauta boita, eta 'ola kauna kamoane makamaka 'abunai de'imala bemumue be'asi. Inoku be'asi nutuala beakuakua koanai nutuala komolonai mo beluvua. ");
INSERT INTO nrz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Da'alaabi kauta devi'ima do'o laloanai eta 'ola kauna be'asi bedavalita 'eva enama'ina. Luva umauna lau oi a'oumui. 'Ola kauna sibona ena tubu'a bevadodoa aniani 'abunai bevamiata divo, bevananita eta vinaula bevavaia. ");
INSERT INTO nrz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Boni malolua 'o o'oloko de'alala laloanai da'alaabi kauta devi'ima do'o laloanai eta 'ola kauna bedavalita 'eva enama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kanania oi boikabasi kave'i. Luma 'ola kauna vinao kauna ena asi melalana beikabasia makava koanai ena luma be'imala inoku sia be'alama. ");
INSERT INTO nrz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oi vaka bova'olu, 'olana sia oi oikabasi melala davanai Lau Kau Nakuna ba'asi.” ");
INSERT INTO nrz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petelo Iesu elavuaia ediaka, “Lovia namana e, luva ivavitaitana kanania lai sibomai kevamaiai oluvala 'o kau boutai vaka?” ");
INSERT INTO nrz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lovia namana ediaka, “Dai lele eika mai e'ima'ima kauna, ia ena 'ola kauna siavu evenia ena luma davata beika kao, da'alaabi kauta eta iani 'eva aniani melalata umautai bevenita? ");
INSERT INTO nrz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Da'alaabi kauna ena 'ola kauna ena mueai kanaua evinaula kave'i koma bedavalia koanai enama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Luva umauna lau oi a'oumui. 'Ola kauna betata'u 'ima'ima kauna 'olai bevaoa ena dava boutai bei'imata. ");
INSERT INTO nrz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Beia da'alaabi kauna sibona bediaka, “E'u 'ola kauna asido'o be'asi,” inoku ia betata'u da'alaabi kauta mai 'a'ateta be'odita beaniani beinuinu beinu ba. ");
INSERT INTO nrz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Melala ka da'alaabi kauna sia elalovaia mai sia eva'olu laloanai ena 'ola kauna bela'asi koanai ia betaua ukuuku, bevaanaanala itani lele sia de'ika kauta boita. ");
INSERT INTO nrz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Da'alaabi kauna ena 'ola kauna ena ula vinaulana eikabasia bevavaia beia sia eva'olu mai sia evavaita koanai, kau kanaua 'eva i'odi doutamo bevenia. ");
INSERT INTO nrz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Beia ikabasi asi'i kauna ena vinaula si'avana 'ounai be'odia beia i'odi sia douta bevenia. Dava doutamo devenia kauna kevanai 'eva dava doutamo beula venita, dava doutamo be'imata kauna kevanai 'eva dava doutamo benonoi.” ");
INSERT INTO nrz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Lau asi 'eva 'alova kanobata akanai batoua, e'u ula 'eva beani kaokao. ");
INSERT INTO nrz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lau 'eva vaidi'u kabukabu ka babia kanaua 'eva banua mekau vaia beda'amo bavaolea kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Oi olalovaia Lau asi 'eva lua'elu abia asi kanobata, una? Lau oi a'oumui, asi'i. Nua'elu 'eva asi'i ia vaivivi. ");
INSERT INTO nrz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Vali'u vailata ekada'ala laloanai, luma ka laloanai kauta ima viloatai sibota bevaiviivita, koi betata'u lua bevaiviivita maivaka lua betata'u koi bevaiviivita. ");
INSERT INTO nrz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ia viloatai sibota bevaiviivita, kama betata'u nakuna bevaiviivia, nakuna betata'u kamana bevaiviivia, sina betata'u nakuna ateatena bevaiviivia, nakuna ateatena betata'u sinana bevaiviivia, melo sinana betata'u lavana ateatena bevaiviivia, lavana ateatena betata'u adana sinana bevaiviivia.” ");
INSERT INTO nrz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu mune'e do'u kauta e'outa ediaka, “Divoduasi avekenai oli ka eko'isi oi oikala koanai komolonai oi odiaka, ‘Lamu be'aku,’ 'eva epupulu. ");
INSERT INTO nrz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dae duasi valea lanina e'unu koanai oi odiaka, ‘Melala bekakala,’ 'eva epupulu. ");
INSERT INTO nrz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dede kaumui e. Oi kanobatai mai vutuvutuai dava depupulu 'eva luvata anita oi oikabasi, beia dava 'ounai vali'u melala kanania'i epupulu davana luvana anina sia oi oikabasia? ");
INSERT INTO nrz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Dava 'ounai oi sibomui ivakomolomui lalovaina sia oi ovavaia? ");
INSERT INTO nrz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Oni va'evai ene'emu divo kauna bevuamu beda'a valuva 'abuna koanai, asido'o evuamu edada'a valuva 'abuna laloanai dala nama'ina bokavua laluana emui vina bovakomoloa, asi'i koanai bevuamu beda'a valuva kauna kevanai, inoku valuva kauna betata'u bevuamu beda'a vabuto'o luma e'imala kauna kevana, inoku vabuto'o luma e'imala kauna vabuto'o lumanai bene'emu divo. ");
INSERT INTO nrz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Lau oi a'oumui, ua'i sia oibola'asi kovo beda'amo tava itoinai oi boveni palu.” ");
INSERT INTO nrz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Melala kanaua'i kau vaida Iesu vailanai Kalilea kauta luvata deluva, eta veniveni devavaia Dilava enai koanai Pilato ena kuali kauta esinita deaku bata lalata sisi lalata ita deuda ka'ona. ");
INSERT INTO nrz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu eta luva evamuea ediaka, “'Olana Kalilea kauta kataua 'eva kanaua deakuta koma 'ounai, oi olalovaia deba kauta eta si'avana 'eva nama vaikata vakaia Kalileai demimia kauta eta si'avana dekeinita, una? ");
INSERT INTO nrz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lau oi a'oumui. Asi'i. Sia oi bolalo 'udai koanai boumuiai 'eva kanaua bevaolemui koma. ");
INSERT INTO nrz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Oi olalovaia kau 'ouka kalavani Siloama ai luma lakavaikana e'eko koanai eakubata kauta kataua eta si'avana 'eva nama vaikata vakaia Ielusalema ai demimia kauta, una? ");
INSERT INTO nrz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lau oi a'oumui. Asi'i. Sia oi bolalo 'udai koanai, boumuiai 'eva kanaua bevaolemui koma.” ");
INSERT INTO nrz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu luva ivavitaitana ka eluvavaia ediaka, “Kau ka suke auna ka ena vine kulana laloanai evadoia, muliai eda'a vuana ekavuta beia sia ka edavalia. ");
INSERT INTO nrz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Ounai kula e'imaia kauna e'ouia ediaka, ‘Teko, vikau koi laloatai a'asi au kanania vuana akakavu, ia sia ka adavalia. Uku 'ekoa. Dava 'ounai kano nama'ina bevaolea 'avaea?’ ");
INSERT INTO nrz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kula i'imana kauna ediaka, ‘E'u 'ola kaumu e. Vikania 'avaea vikau ka'onamo kanania emia. Lau 'olana bavoia kaiu kaiu kano mediata ba'ule. ");
INSERT INTO nrz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bema vikau vailai vuana vaida bepupulu 'eva enama'ina, asi'i koanai ia 'eva bouku 'ekoa. ” ");
INSERT INTO nrz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Melala kabukabuna kai 'eva Iesu Iuda kauta eta lo'e ka laloanai evaikabasi, ");
INSERT INTO nrz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ateate ka ua'i ka'uba si'avana ka eta'u eva'oleleia vikau 'ouka kalavani kabena eva'eva, sibona bevakomoloa 'eva sia edaia. ");
INSERT INTO nrz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu ateate kanaua eikaia koanai, e'aeia ediaka, “Ateate e! Emu 'olele ai 'ani onama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Inoku ia imana ateate akanai ekao 'au koanai, komolonai kabena ekomolo, inoku eko'isi Dilava evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lo'e i'olavaina kauna 'eva ebadu, 'olana Iesu 'olele kauna melala kabukabunai evanama'inala 'ounai. Ia kau e'outa ediaka, “Melala kalakoi 'eva oi emui vinaula melalata. Melala kataua'i oi bo'asi bevanama'inamui, sia melala kabukabunai.” ");
INSERT INTO nrz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lovia namana ia ena luva evamuea ediaka, “Oi dede kaumui! Oi ka ka Melala kabukabunai emu bolomakau 'o emu doniki 'abunai sia oluvua inoku sia oi ovuala oda'a vei 'ulina, una? ");
INSERT INTO nrz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ateate kanania 'eva Abela'amo ena iduvu ateatena. Satani ia vikau 'ani 'ouka kalavani eva'oleleia. Inoku Melala kabukabunai ia mauli sia beabia, una?” ");
INSERT INTO nrz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu ia ena luva kanaua evamuea koma 'eva devaiviivia kauta boutai demalalai si'asi'a, beia do'u kauta boutai delalonama dava nama'ita umauta kataua evavai 'outai. ");
INSERT INTO nrz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu elavuai ediaka, “Dilava ena lovia vanuana 'eva aboina? Davai bavavitaitala? ");
INSERT INTO nrz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ia 'eva vitaitana tuava keana kikina boina, kau ka eabia ena lobai evadoia. Ekubu inoku au namanai eao, le'enai manumanu ni'ita devavai.” ");
INSERT INTO nrz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Maivaka elavuai 'udai ediaka, “Dilava ena lovia vanuana davai bavavitaitala? ");
INSERT INTO nrz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ia 'eva vitaitana ateate ka vakubu mulamulana eabia palaoa doutamo vaika ita eiuta ka'ona, inoku palaoa kanaua itoinai ekubu inoku namana eao.” ");
INSERT INTO nrz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Inoku Iesu Ielusalema eda'aia laloanai, dalai vanua namata mai kikita laloatai kau evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kau ka Iesu elavuaia ediaka, “Lovia namana e! Kau vida 'ani bemauli, 'o?” Ia ena luva evamuea ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Oi bokovokovo kula'ila nutuala omoomonai oi bodododo. Lau oi a'oumui, 'olana kau doutamo bekovokovo bedododo beia sia bedaita. ");
INSERT INTO nrz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Luma 'uala kauna beko'isi nutuala be'alavua koanai, oi mulimuliai oibolalava inoku nutualai oi boakuakua bodiaka, ‘Loviamu e, nutuala luvua lai badodo.’ Beia ia emui luva bevamuea bediaka, ‘lau oi sia aikabasimui, a'ia'i oi o'asi.’ ");
INSERT INTO nrz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Inoku oi bodiaka, ‘Lai oni ita 'eva kaniani mai kainuinu ka'ona, maivaka emai vanuai ovaikabasi.’ ");
INSERT INTO nrz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Beia ia bediaka, ‘lau oi sia aikabasimui, a'ia'i oi o'asi, si'avana ivavaina kaumui boumuiai keva'uai oda'atau.’ ");
INSERT INTO nrz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Inoku beitomui asi koanai, Abela'amo, Isa'ako, Iakobo mai enolea kauta boutai ua'i Dilava ena Lovia Vanuanai 'ani oi boikata inoku oi bokakani mai nikemui oi boala 'o'i' alao'i. ");
INSERT INTO nrz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kau 'eva melala daenai, melala 'ovunai, dodoai mai 'atuai be'asi, inoku Dilava ena Lovia Vanuanai nadu laloanai 'abuta be'abi. ");
INSERT INTO nrz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Inoku daidai demulikai kauta 'eva be'ana'ia, ia daidai de'ana'ia kauta 'eva bemulikai.” ");
INSERT INTO nrz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Melala kanaua'i Palisea kauta vaida deasi Iesu kevana de'ouia dediaka, “'Abu kanania bovikania boda'a 'abu edeana, 'olana 'Eloda e'ula beaku bamu.” ");
INSERT INTO nrz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu eta luva evamuea ediaka, “Oda'a, 'oveka 'asina kanaua oi bo'oua. Lau vali'u mai mala 'eva ka'uba si'avata balo'ota asi mai 'olele kauta bavanama'inata, inoku melala ivakoinai e'u vinaula bavaolea. ");
INSERT INTO nrz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Beia lau vali'u, mala mai umalani 'eva e'u vinaula mo bavavaia bedada'a, 'olana enolea kauna 'eva 'abu edeanai sia beaku bala, Ielusalemai mo.” ");
INSERT INTO nrz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ielusalema e, Ielusalema e, oni ota'u enolea kauta oaku bata, maivaka Dilava esinita kauta bika'ai oaku bata. Melala vida lau aula nakumu boutai bapaka kaita itani 'o'oloko sinana nakuna vaninai epaka kaita boina, beia oni 'eva sia oula veni'u. ");
INSERT INTO nrz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Emu luma kabukabuna 'eva keva'uai ivikanina 'avaea i'imana asi'i. Lau oi a'oumui, sia oi boika'u 'udai beda'amo melalana be'asi koanai oi bodiaka, ‘Lovia namana vanai e'asi kauna 'eva bevanama'inala.’” ");
INSERT INTO nrz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Melala kabukabuna kai Iesu eda'a Palisea eta 'ola kauna ka ena lumai deaniani ka'ona koanai, kau 'eva ia deika 'inia kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ua'i Iesu vailanai 'eva kau ka imana mai aena 'aleta emia. ");
INSERT INTO nrz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu Palisea kauta mai talavatu 'ola kauta elavuaita ediaka, “Talavatu laloanai Melala Kabukabunai kau eka vanama'inata 'eva ekomolo 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Beia ia sia luva ka deluvaia. 'Ounai Iesu kau kanaua eabia evanama'inala inoku esinia eda'a. ");
INSERT INTO nrz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Inoku e'outa ediaka, “Bema melala kabukabunai oi ka nakumu 'o emu bolomakau 'uliai e'ekouda koanai, sia 'ani bo'ileolo vaia bovelia 'au, una?” ");
INSERT INTO nrz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ena luva kanania bevamuea 'eva dalana asi'i. ");
INSERT INTO nrz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu da'a 'au kauta eta miadivo 'abuta nama'ita dedilata eikata, 'ounai luva ivavitaitana kanania e'outa. ");
INSERT INTO nrz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kau ka ena veauveau be'asi kevamu inoku boda'a ena kamoane naduna koanai, miadivo 'abuna nama'ina vaikai sia bomia'au, 'olana oni akamuai kauna ka vaka veauveau 'ani eabia. ");
INSERT INTO nrz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Inoku nadu 'ola kauna, oi laluana eveaumui kauna be'asi kevamu be'oumu bediaka, ‘'Abumu kau kanania venia.’ Inoku oni 'eva mai malalaimu boda'a muliai demimia kauta kevatai ua'i oi bomimia. ");
INSERT INTO nrz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Beia veauveau be'asi kevamu koanai, boda'a muliai bomiadivo, inoku eveaumu kauna be'asi kevamu koanai bediaka, ‘E'u kau e, da'a akai 'abunai mia'au.’ Nadu kanaua laloanai dedododo kauta boutai oni 'olamu be'aku. ");
INSERT INTO nrz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bema kau ka sibona bevanamala 'eva beva'ovua, ia sibona beva'ovua kauna 'eva bevanamala.” ");
INSERT INTO nrz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Inoku Iesu ena nadu 'ola kauna e'ouia ediaka, “Ado'alavuni 'o lavilavi ianina bova'olua koanai, emu kau, bo'akalamu, kadi'a'amu 'o kevamuai lavo kauta sia boveauta, 'olana ia vaka oni beveaumu, inoku tavana bevamuea. ");
INSERT INTO nrz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Beia oni nadu ka bovavaia koanai, ulalu kauta, daisi'a kauta, 'ome'ome kauta mai 'ede kauta boveauta. ");
INSERT INTO nrz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kanaua'i ia tavana sia bevamuea diba inoku komolo kauta ivako'isita 'udai ai oni tavamu vanama'inana 'eva Dilava bevenimu.” ");
INSERT INTO nrz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ita deaniani ka'ona kauna ka lele kanania eika koanai, ia Iesu e'ouia ediaka, “Dilava ena lovia vanuana nadunai beaniani kauna 'eva benama'ina.” ");
INSERT INTO nrz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu ena luva evamuea ediaka, “Kau ka nadu nama vaikana ka evavaia, inoku kau doutamo eveauta. ");
INSERT INTO nrz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nadu ianita deva'oluta koanai, ena da'alaabi kauna esinia da'a 'au kauta be'outa bediaka, ‘Omai, dava boutai 'ani de'olu.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Beia ia boutai de'ou to'ato'a. Inoku lava'ana'ia kauna da'alaabi kauna e'ouia ediaka, ‘Lau 'eva kano ka 'ani atavaia, kanaua 'ounai bada'a baikala. Loviamu, sia bonua anaana.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ka ediaka, ‘Lau 'eva vali'u mo e'u bolomakau 'ouka atavata, inoku 'ani adada'a bavakovota, loviamu, sia bonua anaana.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mune'e ka ediaka, ‘Lau 'eva vali'u mo akamoane, 'ounai sia 'ani bavasi.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Da'alaabi kauna emue easi ena 'ola kauna evaikabasia, inoku 'ola kauna ebadu si'asi'a, ena da'alaabi kauna esinia ediaka, ‘Da'a kaokao da'a vanua bo'adatai mai vanuai da'a keini dalatai, ulalu kauta, daisi'a kauta, 'ede kauta mai 'ome'ome kauta bovuata oi bo'asi.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Inoku da'alaabi kauna eda'a vinaula kanaua evavaia mulinai emue easi ia e'ouia ediaka, ‘'Ola kaumu e, o'ou'u vinaulana 'ani avavaia, beia luma laloana 'eva asido'o evonu.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Inoku 'ola kauna mune'e ena da'alaabi kauna e'ouia ediaka, ‘La'asi da'a mulimuli vanuata dalatai mai ala mulimulitai demimia kauta bo'outa mo bovuata oi bo'asi ia sia bemimia, kanaua'i 'eva e'u luma bevovonu. ");
INSERT INTO nrz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Lau oi a'oumui, aveauta makava kauta sia ka lau e'u nadu ianina kena beania kovo.’” ");
INSERT INTO nrz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mato namana Iesu ita deda'a, ia elava 'udai inoku e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bema kau ka keva'u beasia inoku ia kamana, sinana, adana, nakuna, bo'akalana, lovuna, maivaka ia sibona ena mauli lau dai'uai sia bebolabolala kauna 'eva sia lau ibano'u kaunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Maivaka kau ka ena au ido'o valaukuna umauna sia bevuala muli'uai be'asi kauna 'eva sia lau ibano'u kauna be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bema oi ka o'ula luma namana ka bovalavala koanai, oni bomiadivo makava inoku tavana vida 'eva boduala, luma kanaua bovaolea monina 'ani bedaia o? ");
INSERT INTO nrz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bema oni luma kanaua omakavala, kovolona ovalava inoku akana sia bovaolea koanai beikala kauta boutai bemamai vaimu, ");
INSERT INTO nrz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be'oumu bediaka, ‘Kau kanania luma emakavala edauia, beia luma vinaulana sia evaolea.’ ");
INSERT INTO nrz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“'O bema lovia 'olana ka bemako'isi lovia 'olana ka bemakuali venia koanai, bemamiadivo makava bemalalovai lalovai ia ena kuali kauta sinavu boutai sinavu ka (10,000) ai betata'u kuali kauta kataua sinavu boutai sinavu lua (20,000) de'asi kauta bekuali venita 'eva 'ani bedaia 'o? ");
INSERT INTO nrz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bema sia bedaia koanai, ua'i dau'ai demimia do'o laloanai, ena veauneke kauna ka besinia bedada'a, nua'elu luvana belovaku vaia. ");
INSERT INTO nrz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Vitaitanaimo oi ka emu dava boutai sia bovikanita koanai, oni 'eva lau ibano'u kaumuai sia bo'ao. ");
INSERT INTO nrz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Damena 'eva mediana, beia bema damena dia'ana betaule koanai a ekavadia'ala 'udai koma? ");
INSERT INTO nrz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ia 'eva sia kano 'o vadovado davata ivanama'inata davana, ia 'eva ekaitoa'au. Mai kaiana kauna 'eva lele be'ika mai beikabasi.” ");
INSERT INTO nrz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Moni visi kauta mai si'avana kauta boutai deasi Iesu kevana lelena be'ika. ");
INSERT INTO nrz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Beia Palisea kauta mai Talavatu 'ola kauta 'eva denunuvai nunuvai dediaka, “Kau kanania 'eva si'avana kauta eabitadae mai ita 'abu ka'onamoai deaniani.” ");
INSERT INTO nrz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Inoku Iesu luva ivavitaitana kanania e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kau ka oi viloamuiai ena mamoe sinavu ka. Ia ka'onamo bemataule koanai, kalavani ka navui kalavani ka (99) 'abu 'avaeanai bemavikanita, ia etaule davana kanaua mulinai bemada'a bemakavua bemada'amo bemadavalia. ");
INSERT INTO nrz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bemadavalia koanai mai lalonamana ita bemaabia isi vounai bema'ulea, ");
INSERT INTO nrz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bemavuala bemada'a ena luma. Ena kau mai kevanai demimia kauta bemaveauta, bemaasi kevana inoku bemaluva venita bemadiaka, ‘Lau ita eka lalonama ka'ona, 'olana e'u mamoe etaule davana 'ani adavalia.’ ");
INSERT INTO nrz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Lau oi a'oumui. Vitaitanai mo ua'i vutuvutuai lalonama namana be'ao, 'olana nia'i si'avana kauna ka'onamo elalo 'udai 'ounai, vakaia komolo kauta kalavani ka navui kalavani ka kauta kataua sia de'ula belalo 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ateate ka ena silini 'ouka, inoku ka bemavataulea koanai, lamepa bematoua, ena luma laloana bemadaloa, 'abu itoina bemaikala kave'i bemada'amo bemadavalia. ");
INSERT INTO nrz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bemadavalia koanai, ena kau mai kevanai demimia kauta bemaveauta, bemaasi kevana, bema'outa bemadiaka, ‘Lau ita eka lalonama ka'ona, 'olana e'u silini ka'onamo etaule davana 'ani adavalia.’ ");
INSERT INTO nrz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lau oi a'oumui. Vitaitanai mo, Dilava ena anelu vailatai lalonama namana be'ao 'olana si'avana kauna ka elalo'udai 'ounai.” ");
INSERT INTO nrz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu mune'e ediaka, “Kau ka nakuna lua. ");
INSERT INTO nrz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Melo i'inikauna kamana e'ouia ediaka, ‘Kama'u e, emu dava bomakole, lau e'u 'eva boveni'u.’ Kanaua'i kamana eta'u ena dava ekoleta laluana kevatai. ");
INSERT INTO nrz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Boni vaida deole mulinai, melo i'inikauna ena dava boutai evalalota ka'ona, eko'isi eda'a kanobata edeana ka dau'ana, ua'i mauli si'avana vaikai ena dava evaoleta 'avaea. ");
INSERT INTO nrz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ena dava boutai evaole mulinai, kano kanaua'i doe namana epulu, ia 'eva 'ani vidulu eula. ");
INSERT INTO nrz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Ounai eko'isi eda'a kano kanaua kauna ka kevanai emia, kau kanaua eta'u esinia eda'a ena boloma 'ima 'abunai boloma e'imata. ");
INSERT INTO nrz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Vikolo eakuia 'ounai boloma eta iani vitalua bemaani bo'ana bemakubu davana elalovaia, sia kau ka ia iani evenia. ");
INSERT INTO nrz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kanaua'i ia ena lalovai demue 'udai koanai sibona e'ouia ediaka, ‘Kama'u ena vinaula kauta 'eva doutamo, maieta iani kalita, ia lau nia'i vikolo bevaba'u. ");
INSERT INTO nrz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lau bako'isi bada'a kama'u kevana ba'oua badiaka, Kama'u e, Dilava vailanai mai oni vailamuai lau 'eva 'ani si'avana avavaia. ");
INSERT INTO nrz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Lau 'eva sia anama'ina vaika bo'ae'u nakumuai ba'ao, beia emu vinaula kauna ka ai bovaao'u.’ ");
INSERT INTO nrz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kanaua'i eko'isi beda'a kamana kevana. Dalai eda'a do'o laloanai, kamana ekailao dau'ai nakuna easi eikaia 'eva elaloia eveau eda'a nakuna 'atonai ela'u'au eba'uia. ");
INSERT INTO nrz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ia melo ediaka, ‘Kama'u e, Dilava vailanai mai oni vailamuai lau 'eva 'ani si'avana avavaia. Lau 'eva sia anama'ina vaika bo'ae'u nakumuai ba'ao.’ ");
INSERT INTO nrz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Beia kamana 'eva ena da'alaabi kauta e'outa ediaka, ‘Oda'a, tubu'a nama'ina vaika ka oabia omai kaokao oi bovavadodoa, imana li'uli'unai lini ka oibone'ea divo, mai tamaka vaka ka aenai oi bovalavalauda. ");
INSERT INTO nrz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aniani bolomakauna nakuna nama'ina ka oi boabia bo'asi inoku oi boaku bala, ekanadu ekalalonama. ");
INSERT INTO nrz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","'Olana naku'u kanania 'eva eba beia emauli 'udai, etaule beia adavalia 'udai.’ Inoku lalonama demakavala. ");
INSERT INTO nrz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Melala kanaua'i melo batanikauna 'eva ua'i lobai. Ena mueai, eda'a luma kevanai 'eva masi mai neva 'uluta eika. ");
INSERT INTO nrz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Inoku eko'isi da'alaabi kauna ka e'aeia elavuaia, ‘Kanaua 'eva dava epupulu?’ ");
INSERT INTO nrz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Da'alaabi kauna eluva ediaka, ‘Oni kadimu 'ani emue easi vanua, kamamu eta'u aniani bolomakauna nakuna nama'ina ka eaku bala, 'olana ia 'eva maulina maivaka nama'ina emue edavalia.’ ");
INSERT INTO nrz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Melo batanikauna ebadu si'asi'a, evako sia eda'adodo. Inoku kamana ela'asi eda'a kevana eva'amea. ");
INSERT INTO nrz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Beia ia kamana e'ouia ediaka, ‘Ikala! Vikau katania boutai lau oni da'alamu abi mai lelemu daitai adai. Ia oni sia nani nakuna ka oveni'u, e'u kau ita sia lai alalonama. ");
INSERT INTO nrz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Beia nakumu kanana 'eva maka lea 'a'ateta kevatai emu dava evaole kauna, easi luma koanai oko'isi aniani bolomakauna nakuna nama'ina oaku bala ia ena.’ ");
INSERT INTO nrz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kamana ediaka, ‘Naku'u e, oni 'eva melala bounai lau keva'uai omimia, lau e'u dava katania boutai 'eva oni emu. ");
INSERT INTO nrz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Beia ita 'eva ekalalonama, ekalalonama si'asi'a, 'olana oni kadimu kanania 'eva eba beia emauli, etaule beia kadavalia.’” ");
INSERT INTO nrz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu ibanona kauta e'outa ediaka, “Lavo kauna ka 'eva mai ena dava i'imana kauna ka, inoku ia 'eva kau vaida deta'u de'ouia dae dava i'imana kauna 'eva ena 'ola kauna ena dava eveni 'avaea veni 'avaea. ");
INSERT INTO nrz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Inoku lavo kauna ia e'aeia easi 'eva e'ouia ediaka, ‘Kanania 'eva dava ovavaia lau valimu a'ika, emu dava i'imata vinaulata luvata bovaikabasi'u 'olana oni 'eva 'ani babimu ovo.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Dava 'ima kauna nuanai eluva ediaka, ‘Lau vali'u dava bavavaia? E'u 'ola kauna vinaula kanania'i 'ani bevato'o'u, lau sia mai kula'ila'u bavovoi mai noinoiai amalalai. ");
INSERT INTO nrz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Lau aikabasi dava bavavaia. E'u vinaulai beabi'u ovo mulinai, e'u kau vaida betata'u beabi'u dae eta lumai.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kanaua'i ena 'ola kauna kevanai deabi 'avaea makava kauta ka ka e'aeta. E'ana'ia kauna elavuaia ediaka, ‘Oni e'u 'ola kauna kevanai 'eva vida oabi 'avaea?’ ");
INSERT INTO nrz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ia enu'ovi ediaka, ‘Deolo voduta sinavu ka (100).’ Inoku 'ima'ima kauna e'ouia ediaka, ‘Oabi 'avaea makava pepana kanania, miadivo kaokao, pepa kanana'i ima navui bolelea.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mune'e kau ivaluana elavuaia ediaka, ‘Oni oabi 'avaea makava 'eva vida?’ Ia ediaka, ‘Witi puteta sinavu 'ouka.’ Ia e'ouia ediaka, ‘Oabi 'avaea makava pepana kanania, miadivo, pepai sinavu kalavani bolelea.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“'Ola kauna eta'u 'ima'ima kauna dedena ena vinaulana eabia dae, 'olana vinaula kanaua mai aonekana evavaia. Vali'u kanobata kanania kauta eta aonekai 'ailala kauta eta aoneka be'olavaia. ");
INSERT INTO nrz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iesu e'outa 'udai ediaka, “Lau oi a'oumui, kanobata ena lovia davatai kau ita oi bovikau, inoku oi kevamuiai beda'aovo koanai, mia keinikeini lumanai beabimui dae.” ");
INSERT INTO nrz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Vinaula kikina ka evavaia kave'i kauna betata'u vinaula namana vaka bevavaia kave'i, inoku vinaula kikina sia evavaia kave'i kauna betata'u vinaula namana vaka sia bevavaia kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bema kanobata ena dava si'avata vaika sia oi bo'imata kave'i koanai, dai betata'u vutuvutu davata nama'ita bevenimui oi bo'imata? ");
INSERT INTO nrz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bema kau edeata eta dava sia oi bo'imata kave'i koanai, dai betata'u emui dava umauta bevenimui? ");
INSERT INTO nrz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Da'alaabi kauna ka 'ola kauta lua da'alata sia be'abi, 'olana ka bevaiviivia beia ka 'eva belalo'au venia, 'o ka bevadai venia beia ka belavala mulili. Dilava mai moni melala ka'onamoai da'alata sia oi bo'abi.” ");
INSERT INTO nrz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Palisea kauta lele kanaua deika koanai Iesu demedia media vaia, 'olana ia 'eva moni delalo'au venita 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu e'outa ediaka, “Oi 'eva kau vailatai sibomui oi okomolo okoma, beia Dilava 'eva oi nuamui eikabasita, kau dava tavata namata delalonama vai davata 'eva Dilava sia eula venita. ");
INSERT INTO nrz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Talavatu luvata mai enolea kauta eta luva 'eva deilolo vaita, easimo Ioane Vaidi'u kabukabu kauna ena melalai. Kanaua mulinai 'eva Dilava ena lovia vanuana valina nama'ina deilolo vaia, kau boutai 'eva kula'ilatai dala dekakavu bedododo. ");
INSERT INTO nrz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Vutuvutu mai kanobata betaule 'eva eveavea beia talavatu vana kikina sia ka betaule kovo. ");
INSERT INTO nrz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kau ka adana ebo'okaia inoku ateate edeana ka eadavala 'eva kulakula koana evavaia. Mai kau ka iva'ovu ateatena ka eadavala kauna vaka kulakula koana evavaia. ");
INSERT INTO nrz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Lavo kauna ka ua'i tubu'a nama'ita vaika evadodota maivaka melala boutai dava nama'itai emauli. ");
INSERT INTO nrz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ena nutuala aunai 'eva va'ame kauna ka vana Lasalo ua'i eno, ia kauanina 'eva duadua evonu, ");
INSERT INTO nrz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ena ula 'eva lavo kauna ena vaka ai iani 'ika'ikata de'ekoasi davata ka bemaania. 'Oveka deasi kauna duata dedemalita. ");
INSERT INTO nrz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Melalana easi laloanai va'ame kauna eba koanai anelu devuaia deda'a Abela'amo kevanai. Lavo kauna vaka eba dekoleia. ");
INSERT INTO nrz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lavo kauna ba 'abunai ua'i anaana nama vaikana laloanai emia, e'a'a dae dau'ai vaika Abela'amo eikaia, Lasalo 'eva ia 'aba'abanai. ");
INSERT INTO nrz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ia e'ae'ae ediaka, ‘Kama'u Abela'amo e, bomalalo'u, Lasalo sinia imana li'uli'una veiai eisiauku emai mala'u mo bava'elua, 'olana lau 'eva anana si'asi'a 'alovana kanania laloanai.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Beia Abela'amo ediaka, ‘Naku'u e, bolalovaia emu mauli melalatai oni 'eva dava nama'ita oabi ia Lasalo 'eva dava si'avata vaika eabi. Beia vali'u ia 'eva elalonama laloanai oni 'eva oanana. ");
INSERT INTO nrz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Maivaka ita viloatai 'eva 'uli 'oulana nama vaikana ka emimia, sia kau ka nia'i bekeini bevasi kanana'i, maivaka sia kau ka kanana'i bekeini be'asi nia'i.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Lavo kauna ediaka, ‘Kama'u Abela'amo e, anoimu, bemanama'ina Lasalo sinia eda'a kama'u ena luma. ");
INSERT INTO nrz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","'Olana lau bo'akala'u ima ua'i, bevaikabasita kanaua'i ia vaka sia be'asi anaana 'abuna kanania'i.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abela'amo ediaka, ‘Mose mai enolea kauta 'eva ua'i ia kevatai leleta demaika.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ia eluva ediaka, ‘Asi'i, kama'u Abela'amo e, beia bema kau ka ba ai beko'isi beda'a kevatai koanai 'ani belalo 'udai.’ ");
INSERT INTO nrz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Beia Abela'amo eluva ediaka, ‘Bema Mose mai enolea kauta leleta sia de'ika koanai, nia'i ba ai kauna ka bedada'a 'eva lelena vaka sia be'ika.’” ");
INSERT INTO nrz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu ibanona kauta e'outa ediaka, “Dava kau bevava'evata davana 'eva 'ani deasi, beia kau kanaua kau va'evai ene'eta divo kauna 'eva besi'avana vaika. ");
INSERT INTO nrz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bemanama'ina 'atonai bika'a namana bemado'oa 'au 'atuai bemakapoa 'uku, 'olana kikita katania ka asi'i emavasi'avanala. ");
INSERT INTO nrz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sibomui oi bo'imamui kave'i, bo'akalamu si'avana bevavaia koanai, boda'a kevana bovaidibala kave'i. Ia belalo 'udai koanai, ena si'avana bo'ou kao. ");
INSERT INTO nrz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bema melala ka'onamoai melala kalakoi ka kevamuai si'avana bevavaia, mune'e bemumue kevamuai melala kalakoi ka bediaka ‘Lau alalo 'udai’ koanai, oni 'eva ia ena si'avana bo'outa kao.” ");
INSERT INTO nrz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Veauneke kauta Lovia namana de'ouia dediaka, “Emai abiveni namana bomavaoa.” ");
INSERT INTO nrz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lovia namana eta luva evamuea ediaka, “Bema oi emui abiveni 'eva itani sinapi keana kikina boina koanai au namana kanania oi boma'oua, vali'u bulumu isi da'a 'atuai vadomu koanai lelemui bemaika. ");
INSERT INTO nrz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Oi olalovaia, oi ka emu da'alaabi kauna voi 'abunai 'o mamoe 'ima 'abunai bemaasi koanai, boma'oua bomadiaka, ‘Oni mai kaokao miadivo aniani’? ");
INSERT INTO nrz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Asi'i, kanaua sia bomaluva koma, beia bomadiaka, ‘E'u iani bonanadu bova'olu, bovavai kave'i bo'ado, lau baniani e'u mami bainua bepupua mulinai, inoku oni boaniani emu mami boinua.’ ");
INSERT INTO nrz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E'oulai vinaulata evavaita 'ounai ena da'ala abi kauna vanama'ina luvana bemavenia una? Asi'i. ");
INSERT INTO nrz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vitaitanai oi vaka e'oumui vinaulata boutai oi ovaoleta koanai oi boluluva oi bodiaka, ‘Lai 'eva da'alaabi kaumai mo sia lai akomola, emai vinaula o'oumai davata mo lai avavai.’” ");
INSERT INTO nrz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu dalai eda'a Ielusalema laloanai, Samalia mai Kalilea vaikoatai ekeini. ");
INSERT INTO nrz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Vanua kikina kai eda'adodo laloanai, loki kauta 'ouka ita devidavali. Ia dau'a duasi delava, ");
INSERT INTO nrz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","devaoi 'unu'unu Iesu de'aeia dediaka, “Iesu 'ola kaumu e, lalomai.” ");
INSERT INTO nrz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu eikata koanai e'outa ediaka, “Oda'a, kabukabu kauta kele'etai kaumui oi bovaikata.” Inoku deda'a laloanai 'eva kauta denama'ina. ");
INSERT INTO nrz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Viloatai kau ka'onamo kauna eikaia 'ani enama'ina 'eva emue easi lelena aka umaunai Dilava evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kau kanaua Iesu vailanai ekuidula evanama'inala, ia 'eva Samalia kauna. ");
INSERT INTO nrz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Inoku Iesu elavuaia ediaka, “Kaumui 'ouka oi onama'ina, una? Beia kalavani ka 'eva a'ia'i? ");
INSERT INTO nrz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dava 'ounai pulu edeana kauna kanania mo emumue e'asi Dilava evanama'inala?” ");
INSERT INTO nrz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iesu Samalia kauna e'ouia ediaka, “Ko'isi da'a, emu abiveni eta'u 'ani evanama'inamu.” ");
INSERT INTO nrz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisea kauta vaida Iesu delavuaia dediaka, “Dilava ena lovia vanuana aida be'asi?” Ia eta luva evamuea ediaka, “Dilava ena lovia vanuana be'asi koanai itani sia dava ka kaikala boina. ");
INSERT INTO nrz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sia kau ka bediaka, ‘Davana ena,’ 'o ‘Davana 'eva,’ 'olana Dilava ena lovia vanuana 'eva oi nuamui ai.” ");
INSERT INTO nrz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Inoku Iesu ibanona kauta e'outa ediaka, “Melalana be'asi koanai, emui ula Lau Kau Nakuna e'u melala kataua ka oi bomaikala, beia sia oi boikala. ");
INSERT INTO nrz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kau be'oumui bediaka, ‘Kauna 'eva, oikaia.’ 'o ‘Kauna nia, oikaia.’ Beia sia oi bola'asi mulitai oi bodada'a. ");
INSERT INTO nrz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Lau Kau Nakuna e'u melala ai 'eva itani e'amalea boina, vali'u mo vutuvutu avekenai e'amalea alimo edada'a vutuvutu itoina eva'ailalala. ");
INSERT INTO nrz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Beia vali'u lava'ana'ina 'eva bevaanaana'u vaika, maivaka ulu kanania kauta bevaiviivi'u. ");
INSERT INTO nrz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Vitaitana Noa ena melalai epulu boina Lau Kau Nakuna e'u melalai vaka kanaua bekoma. ");
INSERT INTO nrz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kau 'eva deaniani, deinuinu, dekamoane mai 'a'ate momoluane devenita beadavata eda'amo Noa aunakoi ai edodo, inoku lamu eaku abaka ela'asi kau boutai dedono palu mai 'abu evavaia si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lota ena melalai vaka kanaua boina, kau 'eva deaniani, deinuinu, detavatava, devadovado mai luma dedau. ");
INSERT INTO nrz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Melala kanaua'i Lota Sodomo vanuana evikania ela'asi melalanai, 'alova mai bika'a mai'alovata vutuvutuai lamu boina deaku inoku kau boutai deaku bata. ");
INSERT INTO nrz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lau Kau Nakuna bavailaasi melalanai vaka kanaua bekoma. ");
INSERT INTO nrz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Melala kanaua'i, kau ka luma 'uvinai koanai ia sia be'ovu luma laloanai ena dava ka beabi, vitaitana mo kau ka lobai koanai ia sia bemumue beda'a lumai ena dava ka beabia. ");
INSERT INTO nrz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lota adana oi bolalovaia! ");
INSERT INTO nrz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kau ka e'ula ena mauli beabi 'inia 'eva ena mauli bevataulea, ia ena mauli beitoa'au 'eva ena mauli beabia. ");
INSERT INTO nrz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Lau oi a'oumui, boni kanaua'i kau lua 'eta ka'onamoai bemuinai, ka beabia ia ka bevikania. ");
INSERT INTO nrz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","'A'ate lua witi ivamukamukata bika'ana be'iloa, ka beabia ia ka bevikania. ");
INSERT INTO nrz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kau lua lobai bevinaula, ka beabia ia ka bevikania.” ");
INSERT INTO nrz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ibanona kauta delavuaia dediaka “Lovia namana e, a'i?” Lovia namana eta luva evamuea ediaka, “Ba davata a'i 'eva 'alo vaka ua'i deakubou.” ");
INSERT INTO nrz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu ibanona kauta luva ivavitaitana ka e'outa 'eva bevaikabasita melala bounai bemeamea mai meamea 'eva sia bevikania. ");
INSERT INTO nrz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Eluva ediaka, “Vanua ka laloanai valuva kauna ka emia, ia Dilava makauna sia emakau mai kau 'olata sia e'aku. ");
INSERT INTO nrz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Vanua kanaua laloanai obu ka vaka emia, melala bounai eda'a valuva kauna kevanai enoia ediaka, ‘Dulu'u, evaiviivi'u kauna kevanai bomavakomoloa.’ ");
INSERT INTO nrz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Melala dounamo valuva kauna 'eva sia eula dava ka bevavaia, muliai 'eva sibona eluva ediaka, ‘Lau 'eva Dilava makauna sia amakau maivaka kau 'olata sia a'aku. ");
INSERT INTO nrz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Beia obu kanania evabavunu'u 'ounai ena valuva ivakomolona vinaulana bavavaia, asi'i emamue 'udai 'udai emaasi emavabavunu'u.’” ");
INSERT INTO nrz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Lovia namana ediaka, “Valuva kauna si'ava vaikana ena luva 'uluna o'ika. ");
INSERT INTO nrz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dilava eabita dae kauta de'aea boni de'aea lani kauta eta ula sia bevakomolota, una? Oi olalovaia sia beduluta kaokao, una? ");
INSERT INTO nrz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Lau oi a'oumui, Dilava eta ula bevakomolota kaokao. Beia Lau Kau Nakuna ba'asi koanai kanobatai abiveni kauta 'ani badavalita, una? Asi'i.” ");
INSERT INTO nrz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Maivaka Iesu luva ivavitaitana kanania eluvavaia kau kataua kevatai sibota eta komolo vinaulata deapa vaita ia kau vaida deikata 'iu'iu. ");
INSERT INTO nrz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kau lua deda'a Lo'e Kabukabuna laloanai bemeamea, ka 'eva Palisea kauna ia ka moni visi kauna. ");
INSERT INTO nrz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Palisea kauna 'eva sibona elava tau inoku emeamea ediaka, ‘Dilava e, lau 'eva oni avanama'inamu, 'olana lau 'eva sia kau vaida boita, abi'avaea kauta, vavai 'avaea kauta, kulakula kauta 'o sia moni visi kauna kanania boina. ");
INSERT INTO nrz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lau masi ka'onamo laloanai boni lua alolove, maivaka e'u davali davali davata boutai 'ouka laloatai dava ka'onamo aveveni oni emu.’ ");
INSERT INTO nrz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Beia moni visi kauna 'eva dau'ai elava, sia eula be'a'a dae vutuvutu beikala ia ekukudivo pedena epouia inoku ediaka, ‘Dilava e, lau 'eva si'avana kau'u, lalo'u.’” ");
INSERT INTO nrz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Inoku Iesu ediaka, “Lau oi a'oumui, kauta laluana deda'a eta luma koanai, moni visi kauna 'eva Dilava vailanai ekomolo, beia sia Palisea kauna. 'Olana sibona evanamala kauna kanaua Dilava betata'u bevakikia, inoku sibona evakikia kauna kanaua Dilava betata'u bevanamala.” ");
INSERT INTO nrz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kau vaida nakuta kikita devuata deda'a Iesu kevana akatai bekao'au, beia ibanona kauta deikata koanai de'ovenita. ");
INSERT INTO nrz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Beia Iesu melo kikita e'aeta deasi kevana inoku ediaka, “Melo kikita 'eva be'asi lau keva'u, sia oi bo'outa kao, 'olana Dilava ena lovia vanuana 'eva kau katania boita eta. ");
INSERT INTO nrz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lau oi luva umauna a'oumui, kau ka Dilava ena lovia vanuana sia eabia dae itani melo kikina boina koanai, ia 'eva sia beda'adodo kovo.” ");
INSERT INTO nrz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda kauta eta 'ola kauna ka Iesu elavuaia ediaka, “Vaikabasi kauna mediana e, lau dava bavavaia 'eva mauli keinikeini babia?” ");
INSERT INTO nrz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu ediaka, “Dava 'ounai lau o'ae'u mediana? Sia kau ka 'eva mediana, Dilava mo sibona. ");
INSERT INTO nrz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Talavatu 'eva oikabasita, ‘sia bokulakula, sia boakuaku, sia bovinao, sia bodedede, kamamu, sinamu 'olata bo'aku.’” ");
INSERT INTO nrz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ia ediaka, “Lau melo'u ai koanai talavatu katania boutai 'eva a'imata kave'i easimo vali'u.” ");
INSERT INTO nrz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu luva kanaua eika koanai e'ouia ediaka, “Dava ka'onamo kanania asido'o ovavaia. Emu dava boutai botavatava vaita monita ulalu kauta bovenita. Kanaua'i vutuvutu lavona boabia, inoku bo'asi muli'u ai bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kau luva kanaua eika koanai evilalo si'asi'a mai nuana ebavunu 'olana ia ena lavo doutamo vaika. ");
INSERT INTO nrz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu kau ena nua mekau kanaua eikaia inoku ediaka, “Eta lavo doutamo vaika kauta Dilava ena lovia vanuanai beda'adodo 'eva epasisi vaika. ");
INSERT INTO nrz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ena lavo doutamo vaika kauna Dilava ena lovia vanuanai beda'adodo 'eva epasisi vaika vakaia kamela nila 'ilenai beda'a keini.” ");
INSERT INTO nrz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lelena deika kauta delavuaia dediaka, “Inoku dai 'eva mauli beabia?” ");
INSERT INTO nrz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu eta luva evamuea ediaka, “Dava vaida kau sia bevavaita bedaita davata 'eva Dilava 'ani bevavaita bedaia.” ");
INSERT INTO nrz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petelo Iesu e'ouia ediaka, “Lai emai dava boutai lai avikanita, oni mulimuai lai adada'a.” ");
INSERT INTO nrz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu e'outa ediaka, “Lau luva umauna mo oi a'oumui, kau ka 'eva ena luma, adana, bo'akalana, kamana, sinana 'o nakuna evikanita Dilava ena lovia vanuana 'ounai, ");
INSERT INTO nrz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ia 'eva vali'u melala kanania'i dava doutamo be'abi maivaka melala vailai be'asi melalatai 'eva mauli keinikeini beabia.” ");
INSERT INTO nrz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu ibanona kauta 'ouka lua evuata eda'a 'aba'abai inoku e'outa ediaka, “Ita 'eva vali'u ekaele'au ekada'a Ielusalema, enolea kauta deleleta davata boutai vali'u Lau Kau Nakuna keva'uai bemomo'ai. ");
INSERT INTO nrz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lau 'eva pulu edeana kauta imatai beuda'u, bemediamedia vaia'u, bevamalalaia'u, be'anodi laia'u, be'odi'u mai beaku ba'u. ");
INSERT INTO nrz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Beia Melala ivakoinai lau 'eva bako'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ibanona kauta dava katania ovota sia deovo kovo. Luva kataua anita ia kevatai 'eva devuni, maivaka sia deikabasi ia 'eva luva dava eluva vaia. ");
INSERT INTO nrz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu eda'a Ieliko vanuana ekevaia koanai, 'ede kauna ka dala 'aba'abanai emia eva'ame, ");
INSERT INTO nrz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","kau mato deda'a keini da'a keini 'uluta eika, inoku elavuailavuai dava epupulu. ");
INSERT INTO nrz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","De'ouia dediaka, “Nasaleta kauna Iesu eda'a keini.” ");
INSERT INTO nrz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Ede kauna e'ae'ae, “Davida Nakuna Iesu e, lalo'u!” ");
INSERT INTO nrz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vailai deda'a kauta depilaia inoku de'ouia lele bevuvunu, beia ia 'eva e'ae'ae 'unu'unu, “Davida Nakuna e, lalo'u!” ");
INSERT INTO nrz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu elavakao inoku kau kanaua e'ouia 'eva bevuala be'asi kevana. Ia easi kevai koanai Iesu ia elavuaia, ");
INSERT INTO nrz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O'ula dava kevamuai bavavaia?” Ia enu'ovi ediaka, “Lovia namana e, lau a'ula baikaika.” ");
INSERT INTO nrz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu ia e'ouia ediaka, “Boikaika, emu abiveni eta'u evanama'inamu.” ");
INSERT INTO nrz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Komolonaimo eikaika, inoku Iesu mulinai eda'a, Dilava evanama'inala. Kau boutai deikaia koanai, ia vaka Dilava devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Ieliko vanuanai eda'adodo inoku eda'a keini laloanai, ");
INSERT INTO nrz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kau ka ua'i vana 'eva Sakaio, ia 'eva moni visi kauta eta 'ola kauna ka mai ena lavo doutamo vaika. ");
INSERT INTO nrz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ia eula Iesu 'eva dai beikala, beia kau mato 'ounai sia edaia 'olana ia 'eva kau to'oto'ona. ");
INSERT INTO nrz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kanaua 'ounai eveau 'ana'i eda'a au ai edae Iesu dala kanaua'i be'asi 'eva beikala. ");
INSERT INTO nrz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu easi 'abu kanaua'i ela'asi koanai, e'a'a dae inoku e'ouia ediaka, “Sakaio e, 'ovu kaokao mai. Vali'u melala kanania'i lau 'eva oni emu lumai bamimia.” ");
INSERT INTO nrz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Komolonai e'ovu easi inoku mai lalonamana Iesu evuaia eda'a ena luma. ");
INSERT INTO nrz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kau boutai deikaia 'eva denunuvai nunuvai, “Ia 'eva eda'a si'avana kauna ena da'a'au kaunai e'ao.” ");
INSERT INTO nrz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Beia Sakaio elavadivo inoku Lovia namana e'ouia, “Lovia namana e. Vali'u e'u lavo avekena ulalu kauta bavenita, maivaka bema kau ka dava vaidai alebaia, melala vani tavata baveni muea.” ");
INSERT INTO nrz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu ia e'ouia ediaka, “Vali'u melalana kanania'i vamauli luma kanania'i 'ani epulu, 'olana kau kanania, ia vaka Abela'amo nakuna. ");
INSERT INTO nrz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Lau Kau Nakuna 'eva detaule kauta bakavuta mai bavamaulita dainai asi.” ");
INSERT INTO nrz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kau luva kataua leleta deika laloanai 'eva ia luva ivavitaitana ka e'outa 'olana ia Ielusalema 'ani ekevaia inoku kau delalovaia Dilava ena lovia vanuana 'eva komolonaimo bevailaasi. ");
INSERT INTO nrz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Inoku Iesu ediaka, “Lovia kauna ka eda'a kanobata edeana ka ua'i ena lovia 'olana koana beabia, inoku bemumue be'asi. ");
INSERT INTO nrz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ena da'alaabi kauta 'ouka e'aeta inoku kolo monita ka ka evenita. E'outa ediaka, ‘Moni katania 'eva oi bovinaulavai beda'amo lau bamumue ba'asi.’. ");
INSERT INTO nrz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Beia ena vanua kauta 'eva ia devaiviivia inoku veauneke kauta vaida ia mulinai desinita deda'a 'eva bediaka, ‘Sia lai a'ula kau kanania emai lovia 'olanai be'ao.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kau kanaua lovia 'olanai eao inoku emue easi, luva esinia da'alaabi kauta moni evenita kauta kataua kevatai, ia eula beikabasi moni vida 'ani devavai. ");
INSERT INTO nrz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kau lava'ana'ina easi inoku ediaka, ‘E'u 'ola kaumu e, emu kolo monina ka'onamo akanai kolo monina 'ouka adavalita.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Ola kauna ia ena luva evamuea ediaka, ‘E'u da'alaabi kaumu mediamu, ovavaia kave'i. Dava kikina vaika ia o'imaia kave'i 'ounai vanua 'ouka bo'olavaita.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kau ivaluana easi inoku ediaka, ‘E'u 'ola kaumu e, emu kolo monina ka'onamo akanai kolo monina ima adavalita.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ena 'ola kauna enu'ovi ediaka, ‘Oni 'eva vanua ima bo'olavaita.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Inoku da'alaabi kauna ka vaka easi inoku ediaka, ‘E'u 'ola kaumu e, emu kolo monina ka'onamo 'eva 'ena, tubu'ai a'apaia inoku avunia kave'i. ");
INSERT INTO nrz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Lau 'eva oni makaumu amakau, 'olana oni 'eva kau pasisimu, sia o'ulea divo davana oabia isi mune'e sia ovadoa davana otaua uku.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Ola kauna ia e'ouia ediaka, ‘Oni da'alaabi kaumu si'avamu, lau oni oluluva luvatai bavaluvamu. Oni oikabasi, lau 'eva kau pasisi'u, sia a'ulea divo davana abia isi mune'e sia avadoa davana ataua uku, una? ");
INSERT INTO nrz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Inoku dava 'ounai e'u kolo monina i'uleta lumanai sia one'edivo, kanaua'i amumue a'asi koanai, ne'e'au monina kena ita bamaabi 'udai.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Inoku kevanai delava kauta e'outa ediaka, ‘Ena kolo monina oabia inoku kolo monina 'ouka evavaia kauna ovenia.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ia dediaka, ‘'Ola kaumu e, ia kolo monina 'ouka 'ani eabi.’ ");
INSERT INTO nrz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ia eta luva evamuea ediaka, ‘Lau oi a'oumui, kau ka mai ena dava kauna 'eva dava doutamo bevenia, beia kevana dava asi'i kauna, 'eva dava kikina emimia kevanai davana vaka beabia ovo. ");
INSERT INTO nrz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maivaka e'u 'ou kauta sia de'ula lau ia eta lovia 'olanai ba'ao kauta kataua, ovuata omai nia'i inoku lau vaila'uai oi boaku bata.’” ");
INSERT INTO nrz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu luva katania e'outa mulinai, ia e'ana'ia vaita dele'au deda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ia eda'a Olive lolonai Betepake mai Betania vanuata ekevaita, ia ibanona kauta lua esinita, e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Oi bo'ana'ia boda'a vailamui ai vanuana kanaua, inoku oi boda'adodo ai, doniki nakuna ka ido'ona'au ua'i oi bodavalia, asido'o kau ka evaveaua kovo, oi boluvua inoku oi boabia bo'asi nia'i. ");
INSERT INTO nrz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bema kau ka belavuaimui bediaka, ‘Dava 'ounai oi oluvua?’ Oi bo'oua bodiaka, ‘Lovia namana eula venia.’” ");
INSERT INTO nrz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Esinita 'ana'i kauta kataua deda'a 'eva e'outa vitaitanai dedavalia. ");
INSERT INTO nrz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Doniki nakuna deluvuia laloanai doniki biakuna deta'u delavuaita, “Dava 'ounai doniki nakuna oi oluvua?” ");
INSERT INTO nrz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ia eta luva devamuea dediaka, “Lovia namana eula venia.” ");
INSERT INTO nrz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Inoku devuaia deda'a Iesu kevana, eta tubu'a doniki nakuna kabenai delavalita 'au inoku Iesu deduluia emia 'au. ");
INSERT INTO nrz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eda'a laloanai kau eta tubu'a dalai delavalita. ");
INSERT INTO nrz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ia easi Olive lolonai dala e'ovu edada'a 'abuna kanaua ekevaia koanai, kau mato ia debanoia kauta boutai leleta akai vaikai mailalonamata ita Dilava devanama'inala vinaula siavuta vaika boutai deika 'outai. ");
INSERT INTO nrz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ia dediaka, “Lovia namana vanai e'asi Lovia 'olana kauna 'eva bevanama'inala. Nua'elu vutuvutuai mai nuavi 'eva akai vaikai.” ");
INSERT INTO nrz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Palisea kauta vaida mato viloatai Iesu de'ouia dediaka, “Vaikabasi kaumu e, debanomu kauta 'ovenita lele devunu.” ");
INSERT INTO nrz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu eta luva evamuea ediaka, “Lau oi a'oumui, bema ia lele bevuvunu koanai bika'a bevaoi.” ");
INSERT INTO nrz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu easi Ielusalema kevanai inoku vanuana eikaia 'eva ekani diala. ");
INSERT INTO nrz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ediaka, “O Ielusalema, vali'u melalana kanania emu nua'elu ena asi 'olana bomaikabasia, beia vali'u 'eva kevamuai 'ani evuni. ");
INSERT INTO nrz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Anaana melala be'asi kevamu koanai, oni emu 'ou kauta ikekebilimu bekoa kaiukaiu mai belavamu kaiu inoku 'aba'aba boutai ai be'ilu bedododo be'asi be'alavumu. ");
INSERT INTO nrz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bevelimu 'ovu boda'a kuai bo'alama mukamuka mai nakumu maku laloanai demimia kauta 'eva beitota asi beda'a kuai beaku bata. Bika'a ka bika'a ka akanai sia bevikania, 'olana Dilava ena asi kevamuai melalana sia oi oikabasia.” ");
INSERT INTO nrz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Inoku Iesu Lo'e Kabukabuna laloanai eda'adodo, tavatava kauta elo'ota asi, ");
INSERT INTO nrz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E'outa ediaka, “Puka Kabukabunai 'ani ilelena, ‘E'u luma 'eva meamea lumanai be'ao’, beia oi 'eva abi'avaea kauta eta pode abunai oi ovaaoa.” ");
INSERT INTO nrz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Melala bounai Iesu Lo'e Kabukabuna laloanai evaikabasi, beia kabukabu kauta namata, talavatu 'ola kauta mai vanua kauta namata 'eva dala dekavu ia beaku bala. ");
INSERT INTO nrz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Beia bevavaia dalana sia ka dedavalia, 'olana kau boutai deula vaika ia lelena ikatai. ");
INSERT INTO nrz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Melala ka Iesu 'eva Lo'e Kabukabuna laloanai kau evaikabasita mai vali nama'ina eilolo vaia, inoku kabukabu kauta namata mai talavatu 'ola kauta, vanua kauta namata ita devaka'onamo dele'au deda'a ia kevana. ");
INSERT INTO nrz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","De'ouia dediaka, “'Oumai, siavu davanai vinaula katania ovavaita, siavu kanania dai evenimu?” ");
INSERT INTO nrz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu eta luva evamuea ediaka, “Lau vaka oi lavuai ka balavuaimui, oi bo'ou'u. ");
INSERT INTO nrz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioane ena vaidi'u kabukabu 'eva vutuvutuai easi 'o kau kevatai easi?” ");
INSERT INTO nrz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sibota viloatai deluvaluva vaia dediaka, “Bema ekadiaka ‘vutuvutuai easi,’ koanai ia bediaka, ‘Dava 'ounai sia oi ovamomo'aia?’ ");
INSERT INTO nrz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Beia bema ekadiaka, ‘Kau kevatai easi,’ koanai kau katania boutai ita bika'ai beakuta, 'olana ia devamomo'aia, ‘Ioane 'eva enolea kauna.’” ");
INSERT INTO nrz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kanaua 'ounai Iesu ena luva devamuea dediaka, “Lai sia aikabasi a'i easi.” ");
INSERT INTO nrz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu ediaka, “Lau vaka oi sia ba'oumui, dai ena siavuai dava katania avavaita.” ");
INSERT INTO nrz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu luva ivavitaitana kanania'i kau e'outa ediaka, “Kau ka vine kulana ka evadoia, vinaula kauta vaida eabita be'imala inoku ia 'eva eda'aovo eda'a kanobata edeana kai ua'i emia dau'a. ");
INSERT INTO nrz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vine vuata eta maku'a melalanai, kula kauna vine vuata vaida bevenia 'ounai ena da'alaabi kauna ka esinia eda'a kula i'imana kauta kevatai. Beia kula i'imana kauta deta'u da'alaabi kauna deakuia inoku imana 'avaeana desinia emue. ");
INSERT INTO nrz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Inoku ena da'alaabi kauna edeana ka esinia, beia ia vaka deakuia mai devamalalaia inoku imana 'avaeana desinia emue. ");
INSERT INTO nrz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Da'alaabi kauna ivakoina esinia, deaku si'ala inoku deitoia asi. ");
INSERT INTO nrz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kanaua'i kula 'ola kauna ediaka, ‘Dava bavavaia? Lau Naku'u, e'u lalo'au kauna basinia 'eva ama'i 'ani ia 'olana beaku.’ ");
INSERT INTO nrz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Beia kula i'imana kauta ia deikaia koanai sibota deluvaluva vaia dediaka, ‘Kanania 'eva kula 'ola kauna nakuna ia 'abuna beabia, kaku bala, inoku kula 'eva ita etai be'ao.’ ");
INSERT INTO nrz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kanaua 'ounai deko'isi deitoia asi kula mulinai inoku deaku bala. Inoku kula 'ola kauna 'eva kula i'imana kauta kevatai dava bevavaia? ");
INSERT INTO nrz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ia be'asi 'eva kula i'imana kauta kataua beaku bata inoku kula kau edeata bevenita.” Kau luva kanaua deika koanai dediaka, “Kanania 'eva sia kanaua bekoma.” ");
INSERT INTO nrz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu eika 'inita inoku elavuaita ediaka, “Puka Kabukabunai deleleia luvana anina 'eva dava? ‘Luma ivavaina kauta devaiviivia bika'ana 'eva 'ani luma ivua'inina bika'anai eao.’ ");
INSERT INTO nrz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kau ka be'eko asi bika'a kanaua akanai 'eva beaku ba'ia, beia bika'a kanaua be'eko asi kau ka akanai kauna kanaua 'eva bevamukamukala.” ");
INSERT INTO nrz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Talavatu 'ola kauta mai kabukabu kauta namata 'eva deikabasi luva ivavitaitana kanaua 'eva ia akatai eluvavaia, kanaua 'ounai melala kanaua'i dala dekavu deula Iesu belioa, beia ia kau makauta demakau. ");
INSERT INTO nrz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iesu deika 'inia, dede kauta vaida desinita belavuaia dededede itani komolo kauta boita. Eta ula Iesu luva ka beluvala 'eva beabia, kanaua'i bevenia keini siavu loviana imanai beudala. ");
INSERT INTO nrz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kanaua 'ounai dede kauta delavuaia dediaka, “Vaikabasi kaumu e, lai aikabasi oni luva dava oluvala mai ovaikabasi 'eva dekomolo, oni 'eva sia kau ka enai o'au mai Dilava ena dala luvana umauna ovaikabasi vaia. ");
INSERT INTO nrz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kaisala lovia 'olana kauna takisi monina eka venia 'eva ekomolo 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Beia Iesu eta dede kanaua 'ani eikabasia, inoku e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni ka ovaika'u. Akanai 'eva dai va'ava'ana mai dai vana?” ");
INSERT INTO nrz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ia dediaka, “Kaisala,” Iesu e'outa ediaka, “Inoku Kaisala ena 'eva Kaisala oi bovenia, mai Dilava ena 'eva Dilava oi bovenia.” ");
INSERT INTO nrz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kau vailatai ena luvai bevaviua 'eva sia edaita, ia ena luvai mo 'eva detabulovo si'asi'a inoku lele devunu. ");
INSERT INTO nrz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukea kauta vaida, bai ko'isi 'udai sia devamomo'aia kauta, deasi Iesu kevanai delavuaia, ");
INSERT INTO nrz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Dediaka “Vaikabasi kaumu e, Mose eta talavatu kanania eleleia koma, bema kau ka bo'akalana adana beba kania beia nakuna asi'i, inoku kau kanaua betata'u obu beadavala 'eva melo bevapulua eba kauna nakuna. ");
INSERT INTO nrz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Melala kai kadi'a'a kalakoi ka demia, 'aida'aidana kauna ateate ka eadavala nakuna asi'i laloanai eba. ");
INSERT INTO nrz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ivaluana kauna obu kanaua eadavala inoku eba, ");
INSERT INTO nrz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ivakoina kauna vaka obu kanaua eadavala, inoku dala ka'onamoaimo kauta kalakoi ka deadavala nakuta asi'i deba. ");
INSERT INTO nrz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","To'onai ateate kanaua vaka eba. ");
INSERT INTO nrz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Inoku ko'isi 'udai koanai ateate kanaua 'eva dai ia adanai be'ao? 'Olana kauta kalakoi ka 'eva deadavala.” ");
INSERT INTO nrz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu eta luva evamuea ediaka, “Kanobata kanania kauta dekamoane mai 'a'ate momoluane devenita beadavata. ");
INSERT INTO nrz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Beia komolo kauta kanobata vailai kanaua'i mai bai ko'isi 'udai bemiala kauta 'eva sia bekamoane mai sia 'a'ate momoluane bevenita beadavata, ");
INSERT INTO nrz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","inoku ia sia beba 'udai, 'olana ia 'eva anelu vitaitata maivaka 'ani bai deko'isi 'udai melota 'eva Dilava nakuna. ");
INSERT INTO nrz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bai ko'isi 'udai 'eva Mose evaikala la'uka eani sisibana laloanai. Ia Lovia namana eluva vaia, Abela'amo ena Dilava, 'Isa'ako ena Dilava mai Iakobo ena Dilava. ");
INSERT INTO nrz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ia 'eva sia ba kauta eta Dilava, beia mauli kauta eta Dilava, Ia dainai kau boutai 'eva demauli.” ");
INSERT INTO nrz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Talavatu 'ola kauta vaida deluva dediaka, “Vaikabasi kaumu e, luva mediana vaika oluvala.” ");
INSERT INTO nrz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Inoku sia kau ka 'eva eaoneka vaika lavuai vaidai belavuaia. ");
INSERT INTO nrz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Inoku Iesu ia elavuaita ediaka, “Dava 'ounai kau dediaka Keliso 'eva Davida Nakuna? ");
INSERT INTO nrz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davida sibona Salamo pukanai eluva, ‘Dilava e'u Lovia namana 'eva e'ouia ediaka, Ima'u idibana duasi miadivo ");
INSERT INTO nrz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","beda'amo emu 'ou kauta oni aemu palapalata ine'e'auna davanai bavaaota.’ ");
INSERT INTO nrz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davida ia e'aea Lovia namana. Inoku a boinai Keliso 'eva Davida nakuna?” ");
INSERT INTO nrz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kau boutai lele deika laloanai, Iesu debanoia kauta e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Talavatu 'ola kauta kevatai oibo'imamui kave'i. Ia de'ula 'eva tubu'a laka'ita bevadodo inoku tavatava 'abutai beda'a to'ato'a 'eva kau ia bevanama'inata, mune'e lo'eai mai nadu 'abutai mia'au 'abuta nama'itai mo bemia'au. ");
INSERT INTO nrz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Obu eta lumai dava deabi paluta, mai kau ia beikata dainai eta meamea devalaka'ina. Kau kataua boita kauta 'eva mekau nama vaikana beabia.” ");
INSERT INTO nrz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu ekailao 'eva lavo kauta eta veniveni lo'e monina iudana mauana laloanai deuda eikata. ");
INSERT INTO nrz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Maivaka obu ulaluna ka ena pene kikita lua euda eikaia. ");
INSERT INTO nrz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iesu eluva ediaka, “Lau oi luva umauna a'oumui, obu ulaluna kanania eudala davana 'eva namavaikana vakaia ia boutai. ");
INSERT INTO nrz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kau katania boutai eta lavoai veniveni monita kikita dene'edivo, beia obu kanania ena ulaluai bemiavaia davana itoina ene'eiadivo.” ");
INSERT INTO nrz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ibanona kauta vaida lo'e kabukabuna luvana deluva aboina bika'a si'amobalavenitai devavelala mai veniveni davata Dilava devenia. Beia Iesu ediaka, ");
INSERT INTO nrz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Vali'u oi o'ika davata katania, melala be'asi koanai sia bika'a ka bika'a ka akanai bemimia, itoinai belulu palu.” ");
INSERT INTO nrz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Delavuaia dediaka, “Vaikabasi kaumu e, melala davanai dava katania bepupulu? Maivaka dava katania 'ani bepupulu melalanai koana 'eva aboina?” ");
INSERT INTO nrz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu ediaka, “Oi bo'imamui kave'i, asi'i demalebamui, 'olana kau doutamo lau va'uai be'asi, bededede bediaka, ‘Lau 'eva Keliso,’ mune'e ‘Melala 'ani ekevai,’ 'eva mulitai sia oibodada'a. ");
INSERT INTO nrz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kuali mai viaku 'uluta oi bo'ika koanai, sia oibomakau. Dava katania 'eva 'ani bepulu makava, beia to'ona 'eva asido'o.” ");
INSERT INTO nrz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mune'e e'outa ediaka, “Kanobata ka beko'isi kanobata ka bekuali venia, iduvu ka beko'isi iduvu ka bekuali venia. ");
INSERT INTO nrz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Abu edeata edeata laloatai kanokau namavaikata, doe mai 'olele si'avata vaika bepupulu, maivaka makau davata mai koa namata vutuvutuai bepupulu. ");
INSERT INTO nrz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Beia dava katania boutai asido'o bepupulu laloanai, lau dai'uai oi beliomui mai bevaanaanamui, bevuamui beda'a lo'eai inoku vabuto'o lumai bene'emui divo, maivaka bevuamui beda'a lovia 'olata mai 'olavai kauta vailatai. ");
INSERT INTO nrz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Beia melala kanania 'eva Vali Nama'ina ia oi bo'outa. ");
INSERT INTO nrz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nuamui ovavai kave'i sia oibonua bavunu 'ana'i a oi boluva koma. ");
INSERT INTO nrz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","'Olana Lau batata'u nua'oula luvata bavenimui, kanaua'i emui 'ou kauta 'eva emui luva beva'ekotau 'o be'ou avuavu vaita 'eva sia bedaia. ");
INSERT INTO nrz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Kamamui, sinamui, bo'akalamui, kadi'a'amui mai emui kau venimui beveveni koumui bekokou, inoku oi vaida beaku bamui. ");
INSERT INTO nrz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kau boutai lau dai'uai bevaiviivimui. ");
INSERT INTO nrz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Beia 'olamuiai sia vuimui ka'onamo ka betaule. ");
INSERT INTO nrz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Emui vapasisiai mauli keinikeini oi boabi. ");
INSERT INTO nrz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Iesu ediaka, “Kuali kauta Ielusalema belavala kaiukaiua oi boikata koanai, oi boikabasi ivavaina si'asi'a melalana 'ani ekevai. ");
INSERT INTO nrz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Inoku Iudeai kauta kataua 'eva lolo beveau venia, vanua namana laloanai kauta kataua 'eva bela'asi mulimuliai, mai mulimuliai kauta kataua 'eva vanua namanai sia beda'adodo. ");
INSERT INTO nrz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","'Olana anaana melalata 'eva katania, Puka Kabukabunai 'ani ileleta davata boutai bevamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Melala kataua laloatai sivabu 'a'ate mai vadudu 'a'ateta kevatai 'eva besi'avana vaika, anaana nama vaikata kano kanania'i bepupulu maivaka Dilava ena badu be'ovu kau katania akatai. ");
INSERT INTO nrz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vaida kuali leponai bekala bata mai vaida beabita vabuto'o kautai be'ao beda'a kanobata edeata edeata ai. Pulu edea kauta 'eva Ielusalema beda'ala'au beda'amo pulu edea kauta eta melala be'ole. ");
INSERT INTO nrz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Koa edeata vaida melala, vuia mai visiu laloatai bepupulu. Ka'uda bepouta'au inoku 'atu 'uluna bevuvuai 'eva kanobata kauta boutai nuata bebavunu maivaka nuata bebabata. ");
INSERT INTO nrz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kanobatai dava bepupulu davana ilalovailalovainai kau makau ai bebamauli, 'olana vutuvutuai siavu davata 'eva be'iuvai'iuvai. ");
INSERT INTO nrz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Melala kanaua'i kau 'eva Lau Kau Nakuna mai siavu'u mai nuavi'u namavaikana ita oli akanai ba'asi beika'u. ");
INSERT INTO nrz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dava katania depulu makava koanai, oi bolalava 'olamui oi boabi isi, 'olana ivamaulimui 'ani ekevai.” ");
INSERT INTO nrz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Inoku Iesu luva ivavitaitana kanania e'outa, “'Ova auna mai au boutai oi boikata. ");
INSERT INTO nrz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ia uauata debudi'au oi boikata koanai oi boikabasi diolo 'ani ekevai. ");
INSERT INTO nrz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vitaitanaimo, oi dava katania bepupulu oiboikata koanai, oi boikabasi Dilava ena lovia vanuana 'eva 'ani ekevai. ");
INSERT INTO nrz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Lau oi luva umauna a'oumui, ulu kanania kauta asido'o debapalu laloanai dava katania boutai bepupulu. ");
INSERT INTO nrz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Vutuvutu mai kanobata 'eva betaule, beia e'u luva 'eva sia betaule kovo. ");
INSERT INTO nrz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sibomui oi bo'imamui kave'i, asi'i naduai, inuinuai maivaka mauli kanania ena nua mekau ai oi nuamui bemavamekauta, inoku melala kanaua be'asi eva vatabulovoai beabimui itani viu boina. ");
INSERT INTO nrz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","'Olana melala kanaua 'eva kanobata akanai demimia kauta kataua boutai kevatai bela'asi. ");
INSERT INTO nrz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Melala bounai oi bo'imamui kave'i, maivaka oi bomeamea kanaua'i bepupulu davata boutai kevatai oi boveauovo, inoku Lau Kau Nakuna vaila'uai oi bolalava.” ");
INSERT INTO nrz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iesu melala bounai 'eva lo'e kabukabunai evaikabasi, ia lavilavitai 'eva ela'asi eda'a Olive lolonai boni itoina ua'i emia, ");
INSERT INTO nrz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","kau boutai 'avu'avuni avulatai deda'a lo'e kabukabunai ia lelena be'ika. ");
INSERT INTO nrz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Palaoa 'avaeana naduna, de'aeia La'au keini naduna, 'ani ekevai, ");
INSERT INTO nrz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","inoku kabukabu kauta namata mai talavatu 'ola kauta 'eva Iesu iaku bana dalana vaida vunivuniai dekavu, 'olana ia kau makauta demakau. ");
INSERT INTO nrz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Inoku Satani 'eva Iuda, Kaliote kauna, Iesu ibanona 'ouka lua kauta ka nuanai edodo. ");
INSERT INTO nrz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Inoku Iuda eda'a kabukabu kauta namata mai lo'e kabukabuna de'imala kauta eta 'ola kauta ita delova aku aboina ia Iesu venina beveveni kouna bekokou. ");
INSERT INTO nrz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ia delalonama si'asi'a inoku deluva'ana'i moni bevenia. ");
INSERT INTO nrz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iuda eta luva eabia dae, inoku dala ekavu melala nama'ina davanai 'eva ua'i kau mato asi'i koanai Iesu imatai beudala. ");
INSERT INTO nrz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Inoku Palaoa 'avaeana naduna melalana easi kanaua'i La'au keini naduna mamoeta 'eva beaku bata. ");
INSERT INTO nrz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu Petelo mai Ioane esinita ediaka, “Oda'a La'au keini naduna ianina eka ania dainai ova'olua.” ");
INSERT INTO nrz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Laluana delavuai, “O'ula a'i lai bava'olua.” ");
INSERT INTO nrz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ia e'outa ediaka, “Vanua namanai oi boda'adodo, kau ka vodu veina evuala kauna ita oi bovidavali, ia mulinai oi bodada'a edododo lumana kanaua'i oi bodododo. ");
INSERT INTO nrz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Inoku luma 'uala kauna oi bo'oua, ‘Vaikabasi kauna elavuaimu. Da'a'au daiutuna 'eva a'i, kanaua'i lau ibano'u kauta ita La'au keini naduna ianina lai bania.’ ");
INSERT INTO nrz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ia akai daiutuna namana ka 'ani iva'oluna bevaikamui, ua'i iani oi bova'oluta.” ");
INSERT INTO nrz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Laluana deda'a 'eva Iesu e'outa vitaitatai dedavalita, inoku La'au keini naduna ianina deva'olua. ");
INSERT INTO nrz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Melala koana eabia koanai Iesu ena veauneke kauta ita aniani 'abunai demiadivo. ");
INSERT INTO nrz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Inoku e'outa ediaka, “Lau e'u ula umauna 'eva La'au keini naduna ianina kanania oi ita eka ania ka'ona makava mulinai lau bevaanaana'u. ");
INSERT INTO nrz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lau oi a'oumui 'olana lau La'au keini naduna ianina sia bania 'udai beda'amo ia anina umauna Dilava ena lovia vanuanai bemomo'ai.” ");
INSERT INTO nrz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'Ou ka eabia, evanama'inala inoku ediaka, “Kanania oabia inoku boumuiai oi boinua. ");
INSERT INTO nrz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Lau oi a'oumui 'olana vine vuana veina sia bainua 'udai beda'amo Dilava ena lovia vanuana be'asi.” ");
INSERT INTO nrz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Inoku palaoa ka eabia, evanama'inala mune'e ekovia, evenita ediaka, “Kanania 'eva lau kauani'u oi daimuiai aveveni. Kanania oi bovavaia lau ilalovai'u.” ");
INSERT INTO nrz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dala vitaitanaimo, deaniani mulinai ia 'ou ka eabia, ediaka, “'Ou kanania 'eva vamomo'ai makamakana lau lala'uai, oi daimuiai be'itabu asi. ");
INSERT INTO nrz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Beia lau veni'u beveveni kou'u bekokou kauna imana 'eva nia'i lau ima'u ita aniani 'abunai. ");
INSERT INTO nrz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Lau Kau Nakuna 'eva badada'a Dilava nuana evadaia vitaitana, beia veni'u beveveni kou'u bekokou kauna kanaua kevanai 'eva si'avana namavaikana bepupulu.” ");
INSERT INTO nrz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ia sibota viloatai devilavuai viveni, dai 'eva koakoa kanaua bevavaia. ");
INSERT INTO nrz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ibanona kauta viloatai ia ka namanai be'ao deko dainai vaka deadedua vaia. ");
INSERT INTO nrz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu e'outa ediaka, “Pulu edea kauta eta lovia 'olata 'eva eta siavuai kau delovia vaita, inoku 'olavai kauta eta ula eta 'olavai siavunai 'eva kau ia be'aeta kau nama'ita. ");
INSERT INTO nrz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Beia oi 'eva sia kanaua boinai oi bo'ao. Viloamuiai namana be'ao kauna 'eva beva'iu'iua, maivaka 'ana'iavai kauna 'eva da'alaabi kauna boinai be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dai 'eva namana, aniani 'abunai emimia kauna 'o da'alata e'abi kauna? Aniani 'abunai emimia kauna 'eva namana? Beia lau 'eva oi viloamuiai da'alamui a'abi boina. ");
INSERT INTO nrz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“E'u vikovo boutai laloatai oi 'eva lau ita kamia ka'ona. ");
INSERT INTO nrz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kanaua 'ounai Kama'u siavu eveni'u balovia, vitaitanaimo vali'u Lau siavu bavenimui oi bolovia, ");
INSERT INTO nrz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kanaua'i e'u lovia vanuanai 'eva e'u aniani 'abunai oi boaniani mai boinuinu mune'e lovia imia'aunai oi bomia'au, Isalaela iduvuna 'ouka lua ivaluvata kaumuiai oi bo'ao. ");
INSERT INTO nrz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simona e, Simona e, Satani 'ani enoinoi boumuiai bekovomui vitaitana witi bepoua lu'ulu'una bevalovota boina. ");
INSERT INTO nrz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Beia Simona e, lau oni daimuai 'ani ameamea, emu abiveni sia be'ekoasi. Inoku oni bolalo 'udai koanai, bo'akalamu bovakula'ilata.” ");
INSERT INTO nrz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Beia Petelo Iesu e'ouia ediaka, “Lovia namana e, lau 'eva a'olu oni ita ekada'a vabuto'o luma mai ekada'a ekaba.” ");
INSERT INTO nrz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu ena luva evamuea ediaka, “Petelo e, lau oni a'oumu, vali'u boni kanania'i 'o'oloko asido'o e'alala laloanai, oni melala koi lau bo'ou'u avuavu, lau sia oikabasi'u bokoma.” ");
INSERT INTO nrz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesu eta'u ibanona kauta elavuaita ediaka, “Makavana sia mai idavalamui, voinamui 'o tamakamui asinimui oi oda'a koanai, dava kai oi otabu, una?” Ia dediaka, “Asi'i.” ");
INSERT INTO nrz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ia e'outa ediaka, “Beia vali'u bema dai mai ena idavala 'eva idavala beabia, mai voina vaka beabia, mai dai kevana kuali lepona asi'i kauna 'eva ena tubu'a betavatava vaia moninai kuali lepona ka betavala. ");
INSERT INTO nrz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","'Olana lau oi a'oumui, 'ani deleleia ‘Abi'avaea kaunai devaaoa,’ luvana kanania 'eva lau keva'uai bemomo'ai, dava deleleia lau aka'uai davana ivamomo'aina melalana 'ani e'asi.” ");
INSERT INTO nrz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ibanona kauta dediaka, “Lovia namana e, ikala, kuali lepota lua nia.” Ia e'outa ediaka, “Na 'ani edaia.” ");
INSERT INTO nrz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu melala dounamo evavaia vitaitanai ela'asi Olive lolona eda'aia, ibanona kauta ia mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Deasi 'abu kanaua'i koanai ia e'outa ediaka, “Omeamea vikovo laloanai asi'i oi omadodo.” ");
INSERT INTO nrz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kevatai eda'a ovo viloata ena dau'a 'eva itani bika'a ka kamaitoa bemada'a bema'ovu vitaitanai ua'i ekuidula inoku emeamea. ");
INSERT INTO nrz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ediaka, “Kama'u e, bo'ula koanai anaana 'ouna kanania e'uai boabia ovo, sia lau e'u ulai bovavaia, beia oni emu ula bovavaia.” ");
INSERT INTO nrz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Inoku anelu ka vutuvutuai easi Iesu kevanai ela'asi, evakula'ilala. ");
INSERT INTO nrz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nuana eanana vaika, emeamea mune'e emeamea kula'ila, inoku siavulina dedaidai de'ovu kanoai vitaitana lala dekokoko boina. ");
INSERT INTO nrz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Emeamea koa mulinai eko'isi eda'a ibanona kauta kevata, vilaloai 'ani demano si'asi'a 'ounai muinai tabutai edavalita. ");
INSERT INTO nrz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E'outa ediaka, “Oi dava 'ounai omuinai? Oko'isi omeamea, vikovo laloanai asi'i oi omadodo.” ");
INSERT INTO nrz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu eluva do'o laloanai ibanona 'ouka lua kauta ka vana Iuda 'eva kau mato e'ana'ia vaita deasi, inoku easi eda'a Iesu kevanai beba'ua. ");
INSERT INTO nrz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Beia Iesu ia e'ouia ediaka, “Iuda e, oni 'eva viba'uai Lau Kau Nakuna veni'u oveni kou'u okokou, una?” ");
INSERT INTO nrz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kevanai delava kauta kataua dava 'ani bepupulu kanaua deikaia une koanai, dediaka, “Lovia namana e, kuali leponai lai bakalata, una?” ");
INSERT INTO nrz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Inoku ibanona ka kabukabu kauta 'olatai kauna ena da'alaabi kauna kaiana idibana epaia ovo. ");
INSERT INTO nrz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Beia Iesu eluva ediaka, “Kanana vapuaia.” Inoku ia kau kanaua kaiana eabia kovo evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Inoku Iesu eta'u ia iabina deasi kauta kataua kabukabu kauta namata, lo'e kabukabuna de'imala kauta eta 'ola kauta mai vanua kauta namata e'outa ediaka, “Mai kuali lepomui mai ukumui oi o'asi itani vinao kauna oi boabia boina, una? ");
INSERT INTO nrz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Melala boutai lau 'eva oi ita lo'e kabukabuna laloanai 'eva sia oi oabi'u kao. Beia vali'u 'eva oi emui melala, vabuto'o ena siavu melalana.” ");
INSERT INTO nrz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ia Iesu deabia devada'ala deda'a kabukabu kauta 'olatai kauna ena lumai. Petelo 'eva mulitai eda'a beia mai viloata. ");
INSERT INTO nrz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vaida ala laloana bo'adanai 'alova detouia inoku demiaia kaiu, Petelo vaka ua'i ia viloatai emia. ");
INSERT INTO nrz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Inoku da'alaabi vatona ka 'alova 'ailalanai Petelo emia eikaia, ete 'inia 'eva ediaka, “Kau kanania 'eva Iesu banona ka.” ");
INSERT INTO nrz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Beia Petelo e'ou avuavu ediaka, “Vato e, lau ia sia aikabasia.” ");
INSERT INTO nrz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sia edau'a laloanai, kau ka ia eikaia 'eva ediaka, “Oni vaka ia banota ka.” Petelo ediaka, “Kau e, lau 'eva asi'i.” ");
INSERT INTO nrz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Melala koana ka eda'a boina kau ka ia eikaia inoku eluva kula'ila ediaka, “Momo'ai dokadoka kau kanania 'eva ia banona ka, 'olana ia vaka Kalileia kauna.” ");
INSERT INTO nrz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Inoku Petelo ediaka, “Kau e, lau sia aikabasi oni dava lovana oakua.” Eluva do'o laloanai 'o'oloko e'alala. ");
INSERT INTO nrz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kanaua'i Lovia namana ekai 'udai Petelo eikaia. Inoku Petelo Lovia namana eluva luvana elaloia une, “Vali'u boni kanania'i 'o'oloko asido'o e'alala laloanai oni melala koi lau bo'ou'u avuavu.” ");
INSERT INTO nrz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kanaua'i Petelo ela'asi eda'a mulimuliai ekani si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iesu deabia kao kauta kataua ia devabo'oa mai de'odia. ");
INSERT INTO nrz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Makana de'apa bubuta inoku deakuia 'eva delavuaia dediaka, “'Oumai. Oni dai eakumu?” ");
INSERT INTO nrz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Maivaka luva si'avata vaika doutamo kevanai deluvata. ");
INSERT INTO nrz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Elani laloanai vanua kauta namata, kabukabu kauta namata mai talavatu 'ola kauta dedo'u ka'ona inoku Iesu devuaia deasi do'u namana kauta vailatai. ");
INSERT INTO nrz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Do'u namana kauta delavuaia dediaka, “'Oumai. Oni 'eva Keliso, una?” Iesu enu'ovi ediaka, “Bema lau oi ba'oumui, sia 'ani oi bovamomo'ai'u. ");
INSERT INTO nrz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Maivaka bema lavuai ka bavenimui, sia 'ani oi bonu'ovi. ");
INSERT INTO nrz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Beia vali'u melala kanania'i vailata eda'ala, Lau Kau Nakuna 'eva siavu Dilavana imana idibana duasi bamimia.” ");
INSERT INTO nrz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ia boutai delavuaia dediaka, “Inoku oni 'eva Dilava Nakuna, una?” Iesu ia e'outa ediaka, “'O, 'ani oi oluvamo kanaua 'eva lau.” ");
INSERT INTO nrz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Inoku ia dediaka, “Dava 'ounai 'ou dae luvata kakakavu? Ita sibota 'ani ia umauna nutunai eluluva lelena ka'ika.” ");
INSERT INTO nrz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Inoku do'u namana kauta boutai deko'isi Iesu devuaia deda'a Pilato kevana. ");
INSERT INTO nrz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Inoku demakavala vuvua devakoala dediaka, “Kau kanania lai adavalia emai kanobata kauta nuata eani vanua 'uluna devavuala mai lovia 'olana ena takisi lai baveveni davana e'oua kao, maivaka sibona eluva ia 'eva Keliso, lovia 'olana.” ");
INSERT INTO nrz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Inoku Pilato Iesu elavuaia, “Oni Iuda kauta eta lovia 'olana, una?” Iesu ena luva evamuea ediaka, “'Ani oluvamo kanaua.” ");
INSERT INTO nrz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato kabukabu kauta namata mai kau mato e'outa ediaka, “Lau kau kanania kevanai sia va'eva ka adavalia.” ");
INSERT INTO nrz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ia deluva kula'ila dediaka, “Ena vaikabasi luvatai Iuda kauta boutai evaasiasita 'ulu devavua, ua'i Kalileiai emakavala easi mo 'ani 'abu kanania'i ela'asi.” ");
INSERT INTO nrz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato luva kanaua 'uluna eika 'eva elavuai lavuai, kau kanania 'eva Kalileia kauna, una? ");
INSERT INTO nrz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato eikabasi Iesu 'eva 'Eloda ena ikakao kanona venunai 'ounai esinia devuaia deda'a 'Eloda kevana, melala kanaua'i 'Eloda vaka ua'i Ielusalemai. ");
INSERT INTO nrz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Eloda Iesu eikaia koanai elalonama si'asi'a 'olana siako vaika Iesu valina eika, eula ia bemaikala maivaka enuabata Iesu koa vaida bevavai beikata. ");
INSERT INTO nrz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kanaua 'ounai lavuai doutamo evenia, beia Iesu ia ena luva sia ka evamuea. ");
INSERT INTO nrz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kabukabu kauta namata mai talavatu 'ola kauta ua'i delava deluva pasisi vuvua devakoala. ");
INSERT INTO nrz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Inoku 'Eloda mai ena kuali kauta Iesu devabo'oa, luva si'avata edeata edeata deluva mulinai, lovia tubu'ana ka devavadodoia, mune'e esinia devuaia demue deda'a Pilato kevana. ");
INSERT INTO nrz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","'Ana'inai 'Eloda mai Pilato 'eva vibodala, melala kanaua'i ia laluana 'eva devikau. ");
INSERT INTO nrz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato eta'u kabukabu kauta namata, vanua kauta namata mai vanua kauta e'aeta evado'uta. ");
INSERT INTO nrz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","E'outa ediaka, “Kau kanania oi ovuaia oasi keva'uai oi odiaka, kau nuata e'ani vanua 'uluna evavuala, beia lau vailamuiai oi oluva luvata kataua'i alavuaia 'eva sia ena va'eva ka adavalia. ");
INSERT INTO nrz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","'Eloda vaka kanaua boina 'ounai esini muea easi kevata, oi boikala, ia sia dava ka evavaia si'asi'a kanaua'i ia ivaba be'ao. ");
INSERT INTO nrz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kanaua 'ounai ba'odia inoku bavikania bedada'a.” ");
INSERT INTO nrz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Melala bounai La'au keini nadunai Pilato ena koakoa 'eva vabuto'o kauna ka evala'asia 'avaea. ");
INSERT INTO nrz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Beia kau mato devaoi ka'ona dediaka, “Kau kanania aku bala! Balaba luvua venimai!” ");
INSERT INTO nrz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba 'eva vabuto'o lumanai emia 'olana vanua namana laloanai viala evapulu mai eakuaku. ");
INSERT INTO nrz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato eula 'eva Iesu bevala'asia 'ounai kau mato e'outa 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Beia kau mato devaoi 'udai 'udai dediaka, “Au ido'o valaukuna akanai bebaba! Au ido'o valaukuna akanai bebaba!” ");
INSERT INTO nrz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato melala ivakoina kau mato e'outa 'udai, “Kau kanania va'eva dava evavaia? Ia bebaba va'evana sia ka adavalia. Kanaua 'ounai ba'odia inoku bavikania bedada'a.” ");
INSERT INTO nrz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Beia kau mato devaoi basibasi leleta aka umaunai Iesu au ido'o valaukuna akanai bebaba. Eta vaoiai Pilato ekeinia. ");
INSERT INTO nrz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanaua 'ounai Pilato eta ula evavaia Iesu va'evai ene'eiadivo. ");
INSERT INTO nrz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato eta'u viala mai akuaku 'ounai vabuto'o lumanai dene'eiadivo kauna kanaua evala'asia eta noinoi vitaitanai, inoku Iesu evenita eta ula vinaulana bevavaia. ");
INSERT INTO nrz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kuali kauta Iesu devada'ala dela'asi deda'a 'eva Kulene kauna ka vana Simona, ia 'eva 'uniai easi Ielusalema eda'a venia laloanai deabiakao inoku au ido'o valaukuna devavua vaia Iesu mulinai eda'a vaia. ");
INSERT INTO nrz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kau doutamo vaika Iesu mulinai deda'a viloatai 'a'ate vaida ia delaloia dekani. ");
INSERT INTO nrz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu ekai'udai e'outa ediaka, “Ielusalema nakuna 'a'atemui e, lau dai'uai sia okani, beia oi mai nakumui daimuiai okani. ");
INSERT INTO nrz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","'Olana melala be'asi koanai kau bediaka, ‘De'opa'opa 'a'ateta, melo sia devapulu 'a'ateta mai sia devabae vabae 'a'ateta 'eva denama'ina.’ ");
INSERT INTO nrz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Inoku ‘lolo namata be'outa, “O'eko akamaiai”, mai lolo kikita be'outa, “Ovaakuavumai.” ’ ");
INSERT INTO nrz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Lau au maulina boina keva'uai kanaua devavaia koma koanai, oi au 'ibuna boina kevamuiai a bemavavaia koma?” ");
INSERT INTO nrz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Va'eva kauta lua vaka devuata deda'a Iesu ita beaku bata. ");
INSERT INTO nrz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Deasi 'abu vana ‘'Ola kuliana’ ai dela'asi koanai, Iesu au ido'o valaukuna akanai dekokoia 'au, va'eva kauta lua vaka dekokota 'au, ka idibanai, ka 'ealinai. ");
INSERT INTO nrz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Inoku Iesu eluva ediaka, “Kama'u e, eta si'avana 'oukao 'olana ia sia deikabasi dava devavaia.” Inoku kuali kauta punipuniai ena tubu'a dekole. ");
INSERT INTO nrz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kau delava devialulu, vanua kauta namata Iesu devabo'oa dediaka, “Ia kau edeata evamaulita, bema ia 'eva Keliso Dilava ia edilaia kauna koanai sibona evamaulia.” ");
INSERT INTO nrz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kuali kauta vaka devabo'oa, deasi kevanai vine vamaina devenia. ");
INSERT INTO nrz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Inoku dediaka, “Bema oni Iuda eta lovia 'olana koanai sibomu vamaulimu.” ");
INSERT INTO nrz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iesu 'olana akanai malele ka vaka ua'i, kanania deleleia koma, KANANIA 'EVA IUDA ETA LOVIA 'OLANA! ");
INSERT INTO nrz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Va'eva kauta ua'i detaba kauna ka Iesu evabo'oa ediaka, “Oni vamauli kaumu, una? Sibomu vamaulimu mai lai vaka vamaulimai.” ");
INSERT INTO nrz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Beia banona eta'u e'ovenia ediaka, “Oni Dilava makauna sia omakau, una? Oni mekau oabia vitaitana ia vaka. ");
INSERT INTO nrz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ita laluana ekaba 'eva ekomolo, 'olana mekau ka'abi davata 'eva eta vavai vitaitatai, beia kau kanania 'eva sia va'eva ka evavaia.” ");
INSERT INTO nrz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mune'e ediaka, “Iesu e, emu lovia vanuanai boda'a dodo koanai lau bolalovai'u.” ");
INSERT INTO nrz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu ia e'ouia ediaka, “Lau oni luva umauna a'oumu, vali'u melala kanania'i oni mai lau ita laluana 'eva paladaiso laloanai ekamia.” ");
INSERT INTO nrz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ado'alavuni lakalaka laloanai melala sia ekala, vabuto'o easi kanobata itoinai e'alavua eda'amo melala koana koi. ");
INSERT INTO nrz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Maivaka lo'e kabukabuna laloanai iveli keinina tubu'ana bo'adanai e'idi lua. ");
INSERT INTO nrz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu e'ae 'unu'unu ediaka, “Kama'u e, idume'u imamuai audala.” Kanaua eluva koma mulinai eba. ");
INSERT INTO nrz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kuali kauta i'olavaita kauna dava depulu eikata koanai Dilava evanama'inala ediaka, “Momo'ai dokadoka kau kanania 'eva komolo kauna.” ");
INSERT INTO nrz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vialulu kauta ua'i delava bou makatai dava depulu deikata koanai, pedeta depoupouta mai vilalota demue deda'a vanua. ");
INSERT INTO nrz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Beia Iesu deikabasia kauta mai Kalileiai 'a'ate ia mulinai deda'a kauta kataua boutai dau'ai delava dava depulu davata deikata. ");
INSERT INTO nrz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Do'u namana kauna ka vana Iosepa, ia kau nama'ina maivaka vinaula komolo kauna, ");
INSERT INTO nrz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ena vanua 'eva Alimatea Iudea vanuana ka, ia Dilava ena lovia vanuana e'imala be'asi. Ia do'u namana kauta eta lalovai mai koakoa sia eabitadae. ");
INSERT INTO nrz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kau kanania eda'a Pilato kevana, Iesu kauanina enoinoivaia. ");
INSERT INTO nrz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Inoku ia Iesu kauanina eabia ovo, tubu'a imusinai e'apaia mitava kanaua bika'a ioina 'ulina laloanai ene'eia divo, 'uli kanaua'i 'eva asido'o kau ka dekoleia. ");
INSERT INTO nrz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Melala kanaua 'eva va'olu melalana maivaka melala kabukabuna 'ani bemakavala. ");
INSERT INTO nrz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kalileiai Iesu mulinai deda'a 'a'ateta kataua 'eva Iosepa mulinai deda'a, mitava mai Iesu kauanina a devaenoa koma deikaia. ");
INSERT INTO nrz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Inoku demue deda'a vanua 'eva mulamula bonata nama'ita mai kauna bedavua deolota deva'oluta. Beia talavatu luvana vitaitanai melala kabukabunai lata deani. ");
INSERT INTO nrz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Masi melalana 'avu'avu avulai 'a'ate mulamula bonata nama'ita deva'oluta davata deabi deda'a mitava. ");
INSERT INTO nrz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mitava i'alavuna bika'ana 'ani e'ule tau 'aba'abai deikaia. ");
INSERT INTO nrz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Beia mitava laloanai dedodo koanai Lovia namana Iesu kauanina sia deikaia. ");
INSERT INTO nrz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanaua 'ounai ia nuata debavunu laloanai kau lua eta tubu'a de'amale 'amale komolonai kevatai delavadivo. ");
INSERT INTO nrz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'A'ate demakau si'asi'a dekukudivo vailata kano eda'aia, kau luana 'a'ate delavuaita dediaka, “Mauli kauna dava 'ounai ba kauta viloatai oi okavua? ");
INSERT INTO nrz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ia 'eva sia nia'i. Ia 'ani eko'isi 'udai! Kalileiai emia do'o laloanai oi e'oumui luvana olalovaia. ");
INSERT INTO nrz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ediaka, ‘Lau Kau Nakuna 'eva si'avana kauta imatai beuda'u, au ido'o valaukuna akanai beaku ba'u inoku melala ivakoinai bako'isi 'udai.’” ");
INSERT INTO nrz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kanaua'i ia Iesu ena luva delalota une. ");
INSERT INTO nrz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mitavai demue deasi koanai dava katania boutai ibanona kauta 'ouka ka mai banona vaida kevatai de'outa. ");
INSERT INTO nrz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","'A'ate katania Makadala ateatena Malia, Dioana, Iakobo sinana Malia mai debanota 'a'ateta vaida ita vali kanania veauneke kauta kevatai dekavaia. ");
INSERT INTO nrz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Beia veauneke kauta 'a'ate eta luva 'eva sisiba 'avaeanai devaaoa 'ounai sia devamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Beia Petelo eko'isi eveau eda'a mitava. Ekukudivo laloana enovoia, de'apaia tubu'ata mo ua'i sibota deno 'avaea eikata, emue eda'a ena luma laloanai sibona nuana ebavunu dava kanaua epulu davana 'ounai. ");
INSERT INTO nrz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Melala ka'onamo kanaua laloanai Iesu ibanona kauta lua deda'a vanua ka vana Emausa, vanua kanaua mai Ielusalema viloata ena dau'a 'eva kilomita 'ouka ka boina. ");
INSERT INTO nrz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dalai deda'a laloanai dava depulu davata katania boutai laluana viloatai deluvaluva vaita. ");
INSERT INTO nrz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Inoku laluana deluvaluva mai delovaaku laloanai Iesu sibona easi kevatai ita deda'a ka'ona. ");
INSERT INTO nrz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ia deikaia beia sia deikabasia ia 'eva Iesu. ");
INSERT INTO nrz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu ia elavuaita, “Oi laluana da'a da'amuiai dava lovana oi oakua?” Laluana delava kao vailata mai vilalota. ");
INSERT INTO nrz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Inoku ka vana Kaleopa ia elavuaia, “Ielusalema laloanai ama'i oni mo sibomu melala mulitai dava depulu davata sia oikabasita?” ");
INSERT INTO nrz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ia elavuaita, “Dava epulu?” Kau luana dediaka, “Nasaleta kauna Iesu valina. Ia 'eva enolea kauna, Dilava mai kau boutai vailatai ena luva mai vinaula desiavu si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kabukabu kauta namata mai emai vanua kauta namata ia deabia valuva 'abunai dene'eia inoku au ido'o valaukuna akanai deaku bala. ");
INSERT INTO nrz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Beia lai alalovaia ia kauna 'eva ita Isalaela kauta bevamaulita. Inoku dava katania depulu mulitai melala koi deole. ");
INSERT INTO nrz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Emai 'a'ate vaida lai devatabulovomai. Ia 'avu'avuni avulai deda'a mitava ");
INSERT INTO nrz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","beia Iesu kauanina sia dedavalia, demue deasi dediaka anelu deikata maivaka anelu kataua ia de'outa, ‘Iesu 'eva 'ani emauli 'udai.’ ");
INSERT INTO nrz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Inoku banomai vaida deda'a mitava deikaia 'eva 'a'ate deluva vitaitanai mo dedavalia, beia Iesu kauanina sia deikaia.” ");
INSERT INTO nrz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iesu e'outa ediaka, “A oi obo'o koma, mai nuamui a demaka'i koma enolea kauta deluva davata boutai ivamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keliso kanaua beanana koma makava inoku ena nuavi laloanai bedododo, kanaua sia oi oikabasia, una?” ");
INSERT INTO nrz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iesu 'eva Mose mai enolea eta leleleleai emakavala Puka Kabukabuna laloanai ia sibona luvana bounai kau luana evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vanua deda'a venia vanuana 'ani dekevaia inoku Iesu 'eva beda'a komolo ekoma. ");
INSERT INTO nrz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Beia laluana denoia dediaka, “Melala 'ani e'ulu maivaka 'ani eboboni 'ounai, ita kamamia.” Inoku ia eda'adodo ia ita bemimia. ");
INSERT INTO nrz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iesu aniani 'abunai ia ita demia divo koanai palaoa eabia, evanama'inala, ekovia inoku laluana evenita. ");
INSERT INTO nrz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Inoku makata deata nuata de'ailala ua'i deikabasi ia 'eva Iesu, mune'e vailatai etaule 'avaea. ");
INSERT INTO nrz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ia laluana sibota deviluva viveni dediaka, “Dalai eluva venita maivaka Puka Kabukabuna luvata evaikabasita koanai itani 'alova nuatai evuvule boina, una?” ");
INSERT INTO nrz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Laluana komolonai deko'isi demue deda'a Ielusalema, ua'i ibanona kauta 'ouka ka banota vaida ita dedo'u dedavalita. ");
INSERT INTO nrz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ia de'outa dediaka, “Lovia namana 'eva eko'isi dokadoka, Simona kevanai evailaasi.” ");
INSERT INTO nrz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Inoku ia laluana maivaka dalai dava epulu mai palaoa ekovia koanai nuata de'ailala Iesu deikabasia valina dekava. ");
INSERT INTO nrz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kau luana kataua deluva do'o mo laloanai Iesu sibona ia viloatai elavadivo inoku ediaka, “Nua'elu oi kevamuiai!” ");
INSERT INTO nrz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ia boutai deda'unai 'eva demakau si'asi'a, delalovaia ka'uba deikaia. ");
INSERT INTO nrz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Beia Iesu e'outa ediaka, “Dava 'ounai oi omakau mai nuamui delaloto'ato'a? ");
INSERT INTO nrz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ima'u mai ae'u oikata, oabi'u kovo inoku oi boikabasi, nia 'eva lau umau'u, 'olana ka'uba 'eva sia mai vidiona mai sia mai kuliana, beia oi oika'u vitaitanai lau 'eva mai vidio'u mai maikulia'u.” ");
INSERT INTO nrz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Luva kanaua eluvaia mulinai imana mai aena evaikata. ");
INSERT INTO nrz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ia delalonama si'asi'a ia nuata lalovai lalovai evonu 'ounai Iesu asido'o devamomo'aia, inoku Iesu ia elavuaita, “Oi mai emui iani kena nia'i o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sisi idalana kava'ina kena devenia. ");
INSERT INTO nrz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inoku eabia vailatai eania. ");
INSERT INTO nrz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Inoku Iesu ia e'outa ediaka, “Lau oi kevamuiai amia do'o laloanai dava lovata aku davata katania, Mose ena talavatuai, enolea kauta eta leleleleai mai Salamo laloanai Lau vali'u deleleta davata boutai bemomo'ai.” ");
INSERT INTO nrz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Inoku nuata eva'ailalata Puka Kabukabuna ovona be'ovo. ");
INSERT INTO nrz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mune'e Iesu ia e'outa ediaka, “Puka Kabukabunai kanania deleleia koma. Vamauli kauna 'eva bevaanaanala inoku melala ivakoinai bai beko'isi 'udai. ");
INSERT INTO nrz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ielusalema ai bemakavala beda'amo kanobata boutai laloatai 'eva keliso vanai lalo'udai mai si'avana i'ou kaota beilolo vaita. ");
INSERT INTO nrz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Oi 'eva dava katania valita i'outa dae kaumui. ");
INSERT INTO nrz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Lele'u oika. Kama'u Idume Kabukabuna e'ouia'ana'i kauna basinia be'asi akamuiai, beia oi 'eva Ielusalemai oi bomimia beda'amo siavu akai be'asi davana oi boabia.” ");
INSERT INTO nrz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iesu vanua namanai ia evuata ela'asi deda'a Betani kevanai, inoku imana eabi isi 'eva evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Evanama'inata laloanai 'eva evikanita inoku ele'au eda'a vutuvutu. ");
INSERT INTO nrz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dekukudivo venia inoku mai lalonamata namavaikana ita demue deda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Melala bounai deda'a Lo'e Kabukabuna laloanai demia Dilava devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Makavana umaunai kanobata asido'o epulu laloanai Luva 'eva 'ani ua'i, Luva 'eva Keliso, Luva 'eva Dilava ita demia, mai Luva 'eva Dilava. ");
INSERT INTO nrz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ia 'eva makavana umaunai Dilava ita demia. ");
INSERT INTO nrz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dilava evavaita davata boutai 'eva Luva kanaua'i depulu, depulu davata boutai 'eva sia ka sibona epulu. ");
INSERT INTO nrz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Luva 'eva mauli 'olana, inoku mauli kanaua 'eva kau 'ailala evenita. ");
INSERT INTO nrz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","'Ailala 'eva vabuto'o laloanai e'ani, beia vabuto'o 'eva 'ailala sia evabo'oa. ");
INSERT INTO nrz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dilava kau ka esinia easi, ia vana 'eva Ioane. ");
INSERT INTO nrz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ia enai kau boutai 'ailala valina be'ika inoku bevamomo'aia 'ounai ia easi kau kevatai 'ailala beluva vaia kanaua'i kau boutai ia enai bema abivenia. ");
INSERT INTO nrz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ia sibona 'eva sia 'ailala kanaua, beia 'ailala valina bekakava 'ounai easi. ");
INSERT INTO nrz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","'Ailala umauna 'eva easi kanobatai kau boutai beva'ailalata. ");
INSERT INTO nrz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Luva 'eva kanobatai, inoku kanobata 'eva ia enai ivavaina, beia kanobata kauta 'eva ia sia deikabasia. ");
INSERT INTO nrz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ia easi ena kanobata umauna, beia ia ena kanobata kauta umauta 'eva ia sia deabia dae. ");
INSERT INTO nrz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Beia kau vaida ia deabia dae, mai vana deabivenia kauta kataua boutai 'eva ia komolo evenita Dilava nakunai be'ao. ");
INSERT INTO nrz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Dilava nakunai deao kauta 'eva sia kau eta pulu dalanai, 'o sia kauani ena ulai, 'o sia kau ka ena ulai, beia Dilava ena ulai depulu. ");
INSERT INTO nrz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Luva kanaua 'eva kau kauaninai easi, viloamaiai ita lai amia. Ena nuavi lai aikaia, nuavina kanaua 'eva Kamana kevanai easi Nakuna ka'onamo enai, iulaveni mai luva umaunai evonuvonu 'au. ");
INSERT INTO nrz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioane eta'u ia valina ekava 'eva evaoi ediaka, “Lau valina akava kauna 'eva kanania, adiaka, ‘Lau muli'uai e'asi kauna 'eva ekeini'u 'olana ia emia makava vakaia lau apulu.’” ");
INSERT INTO nrz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ia iulaveniai evonuvonu dae ai 'eva ita boutai melala ka ka laloatai vanama'ina kabi 'udai abi 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dilava 'eva talavatu Mose enai evenita, beia iulaveni mai luva umauna 'eva Iesu Keliso enai deasi. ");
INSERT INTO nrz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sia kau ka Dilava eikaia kovo, beia Nakuna ka'onamo mo sibona, Dilava kevana umauna emimia mai ia sibona vaka Dilava, ia eta'u Dilava ita evaikata. ");
INSERT INTO nrz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Inoku Ielusalemai Iuda kauta namata deta'u kabukabu kauta mai Levi kauta desinita deda'a Ioane belavuaia ia 'eva dai. ");
INSERT INTO nrz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ioane sia e'ou avuavu beia e'ou dae ediaka, “Lau 'eva sia Keliso.” ");
INSERT INTO nrz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ia delavuaia dediaka, “Inoku oni 'eva dai? Oni Elia?” Ia ediaka, “Lau sia Elia.” Ia delavuaia 'udai dediaka, “Oni enolea kaumu, una?” Ia eta luva evamuea ediaka, “Asi'i.” ");
INSERT INTO nrz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kanaua 'ounai ia de'ouia dediaka, “Inoku 'oumai oni 'eva dai. Emu nu'ovi lai babi muea bada'a desinimai kauta lai ba'outa. Oni sibomu a oluva vaimu koma?” ");
INSERT INTO nrz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ioane eta luva evamuea ediaka, “Lau 'eva enolea kauna Isaia ena lelelele luvana, ia eluva ediaka, ‘Lele ka kano'akunai evaoi ediaka, Lovia namana ena dala ovakomoloa.’” ");
INSERT INTO nrz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Palisea kauta vaida vaka desinita, ");
INSERT INTO nrz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","delavuaia dediaka, “Bema oni sia Keliso, 'o sia Elia, 'o sia enolea kaumu koanai dava 'ounai ovaidi'u kabukabu?” ");
INSERT INTO nrz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioane e'outa ediaka, “Lau veiai avaidi'u kabukabu, beia oi sia oikabasia kauna ka oi viloamuiai elalava. ");
INSERT INTO nrz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia 'eva lau muli'uai e'asi, beia ia lau ekeini'u, lau 'eva sia anama'ina ia ena tamaka valota baluvuta.” ");
INSERT INTO nrz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Katania boutai 'eva Betaniai, Iolidana nutu avekenai Ioane evaidi'u kabukabu laloanai depulu. ");
INSERT INTO nrz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Elani Ioane 'eva Iesu eikaia ia kokona easi inoku e'outa ediaka, “Oikaia, Dilava ena mamoe nakuna kanobata ena si'avana iabina ovo kauna. ");
INSERT INTO nrz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ualavi lau lovana aku kauna kanania, adiaka, ‘Muli'uai e'asi kauna 'eva lau ekeini'u, 'olana ia emia makava vakaia lau apulu.’ ");
INSERT INTO nrz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lau sibo'u ia sia aikabasia, beia lau asi veiai bavaidi'u kabukabu 'eva ia bavala'asia Isalaela kauta ia beikabasia 'ounai.” ");
INSERT INTO nrz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Inoku Ioane ia valina ekava ediaka, “Lau Idume Kabukabuna aikaia boiomalo boina vutuvutuai e'ovu ia akanai esili'au. ");
INSERT INTO nrz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Lau asido'o ia aikabasia, beia esini'u veiai bavaidi'u kabukabu kauna eta'u e'ou'u ediaka, ‘Idume Kabukabuna be'ovu boikala inoku kau ka akanai besili'au kauna boikabasi ia 'eva Idume Kabukabunai bevaidi'u kabukabu.’ ");
INSERT INTO nrz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Lau maka'uai 'ani aikaia inoku a'ou dae kanania 'eva Dilava Nakuna.” ");
INSERT INTO nrz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Elani Ioane mune'e ua'i ibanona kauta lua ita delava. ");
INSERT INTO nrz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ia Iesu eda'a keini eikaia koanai ediaka, “Oikaia, Dilava ena mamoe nakuna.” ");
INSERT INTO nrz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ioane ibanona kauta lua ia eluva lelena deika koanai deda'a Iesu mulinai deda'a. ");
INSERT INTO nrz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu ekai 'udai mulinai deda'a eikata inoku elavuaita ediaka, “Oi o'ula dava?” Ia ena luva devamuea dediaka, “Labi e, oni a'i omimia?” (Leletai Labi anina 'eva Vaikabasi kauna.) ");
INSERT INTO nrz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ia e'outa ediaka, “Omai oikaia.” Inoku deda'a ena mia 'abuna deikaia, 'ani elavilavi melala koana vani 'ounai ia ita demia. ");
INSERT INTO nrz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kau luana Ioane eluva lelena deika inoku Iesu mulinai deda'a kauta ka 'eva Andelea, ia 'eva Simona Petelo kadina. ");
INSERT INTO nrz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andelea komolonai 'a'ana Simona edavalia inoku e'ouia ediaka, “Lai Mesaia 'ani lai adavalia.” (Mesaia anina 'eva Keliso, Vamauli kauna.) ");
INSERT INTO nrz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Inoku ia Simona evuaia deda'a Iesu kevana. Iesu Simona eteia basibasi inoku ediaka, “Oni 'eva Simona, Ioane nakuna, vali'u oni vamu be'aea Kepa.” (Kepa 'eva vitaitana Petelo, anina 'eva bika'a.) ");
INSERT INTO nrz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Elani Iesu eula beda'a Kalilea laloanai, Pilipo edavalia inoku e'ouia ediaka, “Muli'uai mai.” ");
INSERT INTO nrz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo 'eva Betesaida kauna, Andelea mai Petelo eta vanua kauna. ");
INSERT INTO nrz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo eta'u Natanaela edavalia inoku e'ouia ediaka, “Mose talavatu laloanai valina ekava maivaka enolea kauta eta pukai deleleia kauna 'ani lai adavalia. Ia 'eva Nasaleta kauna Iesu, Iosepa nakuna.” ");
INSERT INTO nrz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaela elavuai ediaka, “Nasaleta ai dava nama'ina ka ua'i bepupulu bedaia, una?” Pilipo ediaka, “Oni mai ikala.” ");
INSERT INTO nrz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu Natanaela eikaia kokona easi koanai luvana eluva ediaka, “Ia 'eva Isalaela kauna umauna. Ia nuanai 'eva sia dede koana ka.” ");
INSERT INTO nrz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaela ia elavuaia, “Lau aboina oikabasi'u?” Iesu ia ena luva evamuea ediaka, “Oni suke auna venunai do'o laloanai aikamu vakaia mulinai Pilipo e'aemu.” ");
INSERT INTO nrz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Inoku Natanaela enu'ovi ediaka, “Vaikabasi kaumu e, oni 'eva Dilava Nakuna. Oni 'eva Isalaela eta Lovia 'olana.” ");
INSERT INTO nrz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu ia e'ouia ediaka, “Oni ovamomo'ai 'olana adiaka suke auna venunai aikamu 'ounai, una? Sia kanania mo, vailai oni 'eva dava namata boikata.” ");
INSERT INTO nrz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mune'e ediaka, “Lau oi luva umauna a'oumui, vutuvutu beluluvu, inoku Dilava ena anelu Lau Kau Nakuna aka'uai bele'au be'ovu oi boikata.” ");
INSERT INTO nrz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Melala lua deole mulinai Kalilea laloanai Kana vanuanai kamoane naduna ka epulu. Iesu sinana 'eva ua'i, ");
INSERT INTO nrz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iesu mai ibanona kauta ita vaka deveauta deda'a kamoane naduna kanaua'i. ");
INSERT INTO nrz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nadu laloanai vine veina bounai deinu palua koanai Iesu sinana eta'u Iesu e'ouia ediaka, “Ia eta vine veina 'ani eole.” ");
INSERT INTO nrz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu ediaka, “Sina'u e, dava 'ounai eta bavunu davana lau oveni'u? Lau e'u melala asido'o edaia.” ");
INSERT INTO nrz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ia sinana da'alaabi kauta e'outa ediaka, “Ia be'oumui davata boutai oi bovavai.” ");
INSERT INTO nrz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ua'i bika'a voduta namata kalakoi delava, Iuda kauta eta koakoa daitai vodu kataua'i vei be'adoisi imata mai aeta bedeini, vodu namata ka ka laloatai itani vodu kikita luanavui 'o koinavui boita vakaia belaivonu. ");
INSERT INTO nrz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu da'alaabi kauta e'outa ediaka, “Vodu vei ai olai vonuta.” Inoku delai vonuta eda'amo bibi'atai. ");
INSERT INTO nrz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Inoku ia e'outa ediaka, “Vali'u vei vitalua o'adoisi, oabi oda'a nadu ikakaona kauna ovenia.” Inoku vitalua de'ado deda'a ia devenia. ");
INSERT INTO nrz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nadu eikaiakao kauna vine veinai eao veina kanaua einuia kovo, ia sia eikabasi a'i easi, da'alaabi kauta vei de'ado kauta sibota mo deikabasi. Inoku nadu eikaiakao kauna kamoane makamaka kauna e'aeia tau, ");
INSERT INTO nrz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e'ouia ediaka, “Kau boutai 'eva vine veina nama'ina devenita makava, inoku da'a'au kauta deinu ba mulinai vine veina veaveana devenita, beia oni 'eva vine veina nama'ina ovamaua easimo vali'u oveveni.” ");
INSERT INTO nrz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesu vatabulovo koana lava'ana'ina kanania evavaia Kalilea laloanai Kana vanuanai. Ena nuavi evala'asia inoku ibanona kauta ia deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nadu kanaua mulinai Iesu, ia sinana, kadina mai ibanona kauta ita deda'a Kapelanauma, boni vida mo ua'i demia. ");
INSERT INTO nrz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iuda kauta eta La'au keini naduna melalana ekevai 'ounai Iesu ele'au eda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lo'e kabukabuna laloanai 'eva bolomakau, mamoe mai boiomalo detavatava vaita kauta mai moni deabivai'ade kauta eta vakai demia eikata. ");
INSERT INTO nrz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanaua 'ounai 'onau ai 'odi'odi davana ka evavaia, inoku lo'e kabukabuna laloanai kau boutai maibolomakauta mai maimamoeta ita elo'ota asi, moni deabivai'ade kauta eta moni epovuta siusiu inoku eta vaka evaakuta keini. ");
INSERT INTO nrz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Boiomalo detavatava vaita kauta kataua e'outa ediaka, “Dava katania 'abu kanania'i oabita tau. Kama'u ena luma 'eva sia emui tavatava 'abunai oi bovaaoa!” ");
INSERT INTO nrz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Inoku ibanona kauta Puka kabukabunai 'ani ilelena luvana delaloia une, “Oni emu luma ilalo'au venina 'eva 'alova boina lau nua'uai e'ani.” ");
INSERT INTO nrz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Inoku Iuda kauta namata deta'u Iesu delavuaia dediaka, “Vatabulovo koana davana lai bovaikamai 'eva lai bavamomo'aimu oni maiemu siavu dava katania boutai ovavai?” ");
INSERT INTO nrz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu eta luva evamuea ediaka, “Lo'e kabukabuna kanania oi bosiua, lau melala koi laloanai bavalavala 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iuda kauta namata deluva dediaka, “Lo'e kabukabuna kanania 'eva vikau vaninavui kalakoi (46) devavaia, beia oni melala koi laloanai bovalavala 'udai okoma, una?” ");
INSERT INTO nrz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Beia Iesu lo'e kabukabuna lovana eakuia davana 'eva ia kauanina. ");
INSERT INTO nrz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iesu bai eko'isi 'udai mulinai, ia ibanona kauta ena luva eluvaia luvana delaloia une. Inoku Puka kabukabuna mai Iesu eluva luvata devamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesu La'au keini nadunai Ielusalemai emia laloanai, kau doutamo ia deikaia vatabulovo koata evavai inoku ia devamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Beia Iesu sibona 'eva kau sia evamomo'aita 'olana ia kau boutai eikabasita. ");
INSERT INTO nrz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ia sibona 'eva kau nuatai demimia davata 'ani eikabasita dainai, sia kau ka betata'u ia kevanai kau valita bekakava. ");
INSERT INTO nrz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Palisea kauna ka vana Nikodemo, ia 'eva Iuda kauta eta kau namana ka. ");
INSERT INTO nrz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Boni ka ia eda'a Iesu kevana inoku e'ouia ediaka, “Vaikabasi kaumu e, lai aikabasi oni 'eva Dilava kevanai oasi. Olana sia kau ka 'eva vatabulovo koata oni ovavai katana bemavavaita diba bema Dilava eva sia ia ita.” ");
INSERT INTO nrz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu ia ena luva evamuea ediaka, “Lau oni luva umauna a'oumu, kau ka sia bepulu 'udai koanai ia 'eva Dilava ena lovia vanuana sia beikala kovo.” ");
INSERT INTO nrz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo elavuai ediaka, “Kau 'ani namana koanai ia aboina bepulu 'udai koma? Momo'ai dokadoka melala ivaluana ia sinana bo'anai sia bedodo 'udai mune'e sia bepupulu.” ");
INSERT INTO nrz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu ia ena luva evamuea ediaka, “Lau oni luva umauna a'oumu, kau 'eva veiai mai Idume Kabukabunai sia bepulu 'udai koanai ia 'eva Dilava ena lovia vanuanai sia bedodo kovo. ");
INSERT INTO nrz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kauani etata'u kauani evapulua, beia Idume Kabukabuna etata'u idume evapulua. ");
INSERT INTO nrz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bopulu 'udai luvana aluvala 'eva sia botabulovo vaia. ");
INSERT INTO nrz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lani e'unu 'eva eula venia 'abuna eda'ala, ia oni 'eva 'uluna mo o'ika, beia a'i e'asi 'o a eda'ala 'eva sia oikabasi. Idume Kabukabunai depulu kauta boutai vaka kataua boita.” ");
INSERT INTO nrz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ia elavuaia 'udai ediaka, “Dava katania aboina bepupulu?” ");
INSERT INTO nrz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu ia e'ouia ediaka, “Oni 'eva Isalaela ena vaikabasi kauna namana ka, ia dava 'ounai dava katania sia oikabasita? ");
INSERT INTO nrz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Lau oni luva umauna a'oumu, lai aikabasi davatai lai aluva vaita, inoku lai aika davatai lai a'oulai, beia emai luva lai aluva vaita davata oi sia ka oi oabita dae. ");
INSERT INTO nrz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Lau atata'u kanobata davatai aluva venimui ia sia oi ovamomo'aita, bema vutuvutu davatai ba'oumui 'eva aboina oi bovamomo'aita? ");
INSERT INTO nrz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lau Kau Nakuna sibo'u mo vutuvutuai a'ovu asi beia sia kau ka vutuvutuai ele'au kovo. ");
INSERT INTO nrz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kano'akunai Mose kau'asi va'ava'ana eisia 'au vitaitanai lau Kau Nakuna vaka beisi'u 'au. ");
INSERT INTO nrz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Inoku deabiveni'u kauta boutai 'eva mauli keinikeini beabia. ");
INSERT INTO nrz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“'Olana Dilava kanobata elalo'au venia vaika 'ounai Nakuna ka'onamo mo eveni, beabivenia kauta boutai 'eva sia bebaba, beia mauli keinikeini beabia. ");
INSERT INTO nrz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dilava nakuna esinia kanobatai 'eva sia kanobata mekau bevenia, beia ia enai kanobata bevamaulia. ");
INSERT INTO nrz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ia deabivenia kauta boutai 'eva mekau sia bevuala, beia sia deabivenia kauta boutai 'eva 'ani mekau devuaia, 'olana Dilava Nakuna ka'onamo mo vanai sia deabivenia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Valuva 'eva kanania boina. 'Ailala 'ani easi kanobata laloanai, inoku kau vabuto'o ulana de'ula beia 'ailala sia deula venia, 'olana eta koakoa 'eva desi'avana. ");
INSERT INTO nrz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Si'avana devavai kauta boutai 'ailala devaiviivia inoku sia de'asi 'ailala laloanai 'olana ia eta koakoa si'avata vaika asi'i demavala'asita une makauna. ");
INSERT INTO nrz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Beia momo'ai vinaulatai demauli kauta 'eva de'asi 'ailala laloanai, 'olana Dilava lelena daitai dedadai 'eva eta koakoai bevala'asi kau be'ika.” ");
INSERT INTO nrz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kanania mulinai, Iesu ibanona kauta ita dela'asi deda'a Iudea kanona, ua'i ia ita kena demia inoku kau evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Vaidi'u kabukabu kauna Ioane vaka Salima avekenai Aenonai evaidi'u kabukabu, 'olana ua'i 'eva vei namana inoku kau dedada'a 'eva evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kanaua 'eva Ioane vabuto'o lumanai asido'o de'alavua koanai. ");
INSERT INTO nrz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Inoku Ioane ibanona kauta vaida 'eva Iuda kauna ka ita eta koakoa Dilava vailanai bevamakamakata 'udai idi'una deviala vaia. ");
INSERT INTO nrz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kanaua 'ounai ia deasi Ioane kevanai inoku de'ouia dediaka, “Vaikabasi kaumu e, Iolidana nutuna avekenai kau kanaua ita oi omia, valina okava kauna 'eva vali'u ia kau evaidi'uta kabukabu, inoku kau boutai 'eva ia kevana deda'ala.” ");
INSERT INTO nrz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioane eta luva evamuea ediaka, “Kau 'eva Dilava beveveni davana mo bedavalia. ");
INSERT INTO nrz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Oi sibomui vaka 'ani oi ovamomo'ai'u 'eva lau adiaka, ‘lau 'eva sia Keliso, beia lau 'eva esini'u 'ana'i vakaia ia.’ ");
INSERT INTO nrz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kamoane makamaka ateatena kanaua 'eva ia eadavala kauna ena, inoku kamoane makamaka kauna ena kau ia kevanai elalava 'eva lelena e'ika koanai elalonama si'asi'a. Lalonamana kanania 'eva lau e'u, inoku vali'u nua'u lalonama 'ani evonu. ");
INSERT INTO nrz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ia 'eva namana be'ao, beia lau 'eva kiki'u ba'ao.” ");
INSERT INTO nrz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Akai easi kauna 'eva kau boutai akatai, kanobatai epulu kauna 'eva kanobata ena, inoku kanobata davata mo eluva vaita. Vutuvutuai easi kauna 'eva kau boutai akatai. ");
INSERT INTO nrz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ia eika mai e'ika davata valita ekakava, beia sia kau ka ia ena luva eabita dae. ");
INSERT INTO nrz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Beia ena luva eabi dae kauna 'eva evamomo'aia Dilava 'eva momo'ai Dilavana. ");
INSERT INTO nrz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dilava esinia kauna 'eva Dilava ena luva eluvavai, 'olana Dilava etata'u Idume Kabukabuna ia nuanai evavonua. ");
INSERT INTO nrz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kamana eta'u nakuna elalo'au venia inoku dava boutai ia imanai 'ani eudata. ");
INSERT INTO nrz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nakuna evamomo'aia kauna 'eva mauli keinikeini 'ani eabia, beia nakuna lelena daitai sia edadai kauna 'eva mauli sia beikala kovo, inoku Dilava ena badu ia akanai bemimia.” ");
INSERT INTO nrz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Palisea kauta vali deika 'eva Iesu kau doutamo eabita debanoia mai evaidi'uta kabukabu beia vaidi'u kabukabu kauna Ioane 'eva sia dounamo eabita. ");
INSERT INTO nrz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Beia umauna 'eva Iesu sibona sia evaidi'u kabukabu, ia ibanona kauta mo devaidi'u kabukabu. ");
INSERT INTO nrz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesu eikabasi Palisea kauta 'eva vali kanania 'ani deika koanai ia Iudea evikania, emue mune'e beda'a Kalilea. ");
INSERT INTO nrz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Vali'u ia 'eva Samalia kanonai 'ani beda'a keini bedada'a. ");
INSERT INTO nrz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ia easi Samalia vanuana ka vana Sukala ai ela'asi, vanua kanaua 'eva Iakobo eta'u nakuna Iosepa eva'oula venia kanona kevanai. ");
INSERT INTO nrz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iakobo ena vei 'ulina 'eva ua'i, inoku Iesu vei 'ulina 'aba'abanai emia divo 'olana 'ani ebavunu vaika dala laka'ina ida'anai. Melala 'eva 'ani eado'alavuni. ");
INSERT INTO nrz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samalia ateatena ka vei 'ado easi inoku Iesu ia enoia ediaka, “Vei vitalua veni'u bainu.” ");
INSERT INTO nrz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ia ibanona kauta 'eva deda'a vanuai iani betatava. ");
INSERT INTO nrz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samalia ateatena ia ena luva evamuea ediaka, “Oni 'eva Iuda kaumu ia lau 'eva Samalia ateate'u, inoku dava 'ounai keva'uai vei onoinoi?” ('Olana Iuda kauta 'eva Samalia kauta ita sia devaka'onamo.) ");
INSERT INTO nrz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu enu'ovi ia e'ouia ediaka, “Bema Dilava ena ainama bomaikabasia mai dai kevamuai vei enoinoi kauna bomaikabasia koanai, ia bomanoia inoku ia mauli veina bemavenimu.” ");
INSERT INTO nrz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ateate ediaka, “Kau namamu e, sia mai emu vei 'ado davana ka maivaka vei 'ulina kanania 'eva e'ovu vaika. Mauli veina kanaua 'eva a'i boabia? ");
INSERT INTO nrz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lai 'ava'avamai Iakobo 'eva vei 'ulina kanania evenimai, ia sibona einuia, nakuna deinuia, ena mamoe mai bolomakau vaka deinuia, inoku oni Iakobo okeinia, una?” ");
INSERT INTO nrz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu ena luva evamuea ediaka, “Vei kanania deinuia kauta boutai 'eva vei bata beba 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Beia lau baveveni veina beinua kauna 'eva vei bana sia beba kovo. Momo'ai dokadoka, lau baveveni veina 'eva ia nuanai mauli veinai be'ao bebubudi be'itabu'itabu mauli keinikeini bevenia.” ");
INSERT INTO nrz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ateate Iesu e'ouia ediaka, “Kau namamu e, vei kanaua veni'u, inoku vei ba'u sia baba 'udai maivaka sia ba'asi nia'i vei ba'ado 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu ia e'ouia ediaka, “Da'a adamu 'aea inoku laluana oi bo'asi.” ");
INSERT INTO nrz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ateate ediaka, “Lau sia mai ada'u.” Iesu ia e'ouia ediaka, “Oni sia mai adamu okoma 'eva okomolo. ");
INSERT INTO nrz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","'Olana oni adamu boutai ima, inoku vali'u kevamuai emimia kauna 'eva sia oni adamu umauna. Vali'unai oluvala luvana 'eva luva umauna.” ");
INSERT INTO nrz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ateate ediaka, “Kau namamu e, vali'u nua'u 'ani e'ailala, oni 'eva enolea kaumu. ");
INSERT INTO nrz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lai 'ava'avamai 'eva lolo kanania akanai Dilava dekukudivo venia, beia oi Iuda kaumui oi odiaka kukudivo 'abuna 'eva ka'onamo Ielusalemai mo.” ");
INSERT INTO nrz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu ediaka, “Ateate e, e'u luva abia dae, bonina e'asi koanai sia lolo kanania akanai 'o sia Ielusalemai Kamata oi bokukudivo venia. ");
INSERT INTO nrz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Oi Samalia kaumui sia oi oikabasia kauna oi okukudivo venia, lai Iuda kaumai lai aikabasia kauna lai akukudivo venia, 'olana Dilava ena vamauli dalana 'eva Iuda kauta kevatai e'asi. ");
INSERT INTO nrz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Beia melalana e'asi inoku vali'u 'ani ela'asi, bekukudivo venia dokadoka kauta 'eva idumeai mai luva umaunai Kamata bekukudivo venia. 'Olana Kamata 'eva kanaua boinai dekukudivo venia kauta ekavuta. ");
INSERT INTO nrz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dilava 'eva Idume, kanaua 'ounai dekukudivo venia kauta 'eva idumeai mai luva umaunai bekukudivo venia.” ");
INSERT INTO nrz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ateate ediaka, “Lau aikabasi Mesia, vamauli kauna vana Keliso be'asi, ia be'asi koanai dava boutai be'oulai kave'i kevamaiai.” ");
INSERT INTO nrz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Inoku Iesu ia e'ouia ediaka, “Kauna 'eva lau kau'u kanania vali'u aluva venimu.” ");
INSERT INTO nrz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Melala kanaua'i ia ibanona kauta demue deasi 'eva detabulovo si'asi'a, 'olana Iesu ateate ka ita deluvaluva deikaia. Beia sia kau ka elavuaia, “O'ula dava?” 'o “Ia ita dava 'ounai oi oluvaluva?” ");
INSERT INTO nrz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Inoku ateate ena vodu evikania, emue eda'a vanuai kau e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Omai kada'a kau ka oikaia, 'ana'inai avavai koakoata kataua boutai eluva vaita, ama'i Keliso kanaua?” ");
INSERT INTO nrz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Inoku kau vanuai dela'asi Iesu kokona deda'a. ");
INSERT INTO nrz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kanaua laloanai ibanona kauta Iesu denoia dediaka, “Vaikabasi kaumu e, iani kena ania.” ");
INSERT INTO nrz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Beia ia e'outa ediaka, “Lau mai e'u iani bania davana 'eva sia oi oikabasia.” ");
INSERT INTO nrz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Inoku ibanona kauta sibota viloatai devilavuai vai'ade dediaka, “Ama'i kau ka 'ani iani kena eabi easi evenia.” ");
INSERT INTO nrz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu e'outa ediaka, “E'u iani 'eva esini'u kauna ena ula bavavaia maivaka ia eveni'u vinaulana bavaolea. ");
INSERT INTO nrz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Oi odiaka, ‘Vuia vani mo demimia inoku iukuta bonina bedaia.’ Beia lau a'oumui, Makamui ovaaku isi loba oikata kave'i, iani 'ani demaku'a beukuta. ");
INSERT INTO nrz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ukuuku kauna tavana eabia inoku loba ianina edouabou mauli keinikeini 'abunai, kanaua 'ounai ivadona kauna mai iukuna kauna 'eva belalonama ka'ona. ");
INSERT INTO nrz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Deluvaia luvana 'eva luva umauna, ‘Vadovado kauna edeana ia eukuku kauna 'eva edeana.’ ");
INSERT INTO nrz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lau asinimui sia oi obavunu vaia lobanai iani oi bo'uku. Vaida loba kanaua bavununa 'ani devavaia inoku oi otata'u eta bavunu ianina oi oabia.” ");
INSERT INTO nrz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vanua kanaua laloanai Samalia kauta doutamo Iesu deabivenia 'olana ateate ena vali kava luvana 'ounai, ateate ediaka, “Ia eta'u avavai koakoata boutai eluva vaita.” ");
INSERT INTO nrz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kanaua 'ounai Samalia kauta deasi kevana koanai, ia denoia ia ita bemimia, inoku Iesu boni lua ua'i emia. ");
INSERT INTO nrz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iesu ena luva 'uluta deika laloanai kau doutamo vaka deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kau kataua ateate de'ouia dediaka, “Vali'u ia lai abivenia 'eva sia oni oluva luvana 'ounai, beia vali'u lai sibomai kaiamai ai lai a'ika, maivaka lai aikabasi kau kanania 'eva momo'ai dokadoka kanobata ivamaulina kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Boni ivaluana eole mulinai Iesu eko'isi eda'a Kalilea. ");
INSERT INTO nrz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu sibona eluva ediaka, “Enolea kauna ena vanua umauna kauta 'eva 'olana sia be'aku.” ");
INSERT INTO nrz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iesu Kalileai ela'asi koanai, Kalilea kauta ia deabia dae, 'olana Ielusalemai La'au keini naduna laloanai ia vaka deda'a ua'i inoku ia evavai davata boutai 'eva makatai deika 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesu mune'e emue eda'a Kalileai Kana vanuanai, ua'i vei evakeinia vine veinai eao. Ua'i Kapelanauma laloanai lovia 'olana kauna ka nakuna moluanena e'olele. ");
INSERT INTO nrz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kau kanaua Iesu Iudeai easi Kalileai luvana eika koanai, ia eda'a Iesu kevana enoia beda'a nakuna bevanama'inala 'olana ia 'ani bebaba. ");
INSERT INTO nrz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu ia e'ouia ediaka, “Oi koa mai vatabulovo koata sia oi bo'ika koanai sia oi boabiveni kovo.” ");
INSERT INTO nrz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Lovia kauna ediaka, “Kau namana e, mai kada'a ke naku'u 'eva 'ani bebaba.” ");
INSERT INTO nrz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu ia e'ouia ediaka, “Da'a, nakumu 'eva 'ani bemauli.” Lovia kauna Iesu ena luva evamomo'aia inoku eda'a. ");
INSERT INTO nrz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ia dala kanaua eda'aia laloanai ena da'alaabi kauta deasi dalai devidavali, nakuna emauli luvana de'ouia. ");
INSERT INTO nrz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ia elavuaita melala koana vida nakuna enama'ina, inoku ia dediaka, “Lavi ado'alavuni melala koana ka'onamo 'eva kauna 'oleleta deole.” ");
INSERT INTO nrz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kamana elaloune melala koana kanaua'i 'eva Iesu ia e'ouia ediaka, “Nakumu 'eva 'ani bemauli.” Kanaua 'ounai ia mai ena luma kauta boutai Iesu deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iesu Iuda evikania mulinai easi Kalileia laloanai 'eva vatabulovo koana ivaluana kanania evavaia. ");
INSERT INTO nrz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Boni vaida deole mulinai, Iuda kauta eta nadu dainai Iesu ele'au eda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ua'i Ielusalemai nutuala ka vana ‘Mamoe nutualana’ kevanai 'ovu kikina ka 'Ebelu leletai vana de'aeia ‘Betesaida’, inoku kevanai 'eva laani aioleta ima delavaia kaiukaiu. ");
INSERT INTO nrz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","'Abu kataua'i 'olele kauta doutamo deno, maka 'ede kauta, 'ome kauta, bade kauta, (devi'ima vei be'ilo'iloa. ");
INSERT INTO nrz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","'Olana melala ka ka anelu e'ovu 'ovu veina e'ilo'iloa, mulinai 'olele kauna ka 'ovuai be'ovu makava kauna 'eva ena 'olele dava beia benama'ina.) ");
INSERT INTO nrz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","'Abu kanaua'i kau ka vikauna boutai koi navui kalavani (38) e'olele eno. ");
INSERT INTO nrz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu 'olele kauna kanaua'i eno eikaia koanai eikabasi ia 'eva siako mo kanaua boina eno, inoku Iesu ia elavuaia ediaka, “Oni o'ula bonama'ina, una?” ");
INSERT INTO nrz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Olele kauna Iesu ena luva evamuea ediaka, “Kau namana e, vei e'ilo'iloa koanai lau sia mai idulu'u kauna ka 'ounai lau akovokovo ba'ovu laloanai kau ka 'ani e'ana'ia vaila'uai.” ");
INSERT INTO nrz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Inoku Iesu ia e'ouia ediaka, “Ko'isi, emu 'eta lo'ua abia da'a.” ");
INSERT INTO nrz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Komolonai kau kanaua enama'ina, inoku eko'isi ena 'eta elo'uia eabia eda'a. Ua 'eva melala kabukabunai koa kanania epulu. ");
INSERT INTO nrz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kanaua 'ounai Iuda kauta namata kau kanaua 'oleleai enama'ina kauna de'ouia dediaka, “Vali'u 'eva melala kabukabuna, ia oni emu 'eta ovuala 'eva eta talavatu oukua.” ");
INSERT INTO nrz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Beia ia eta luva evamuea ediaka, “Evanama'ina'u kauna e'ou'u ediaka, ‘Emu 'eta abiaisi da'a.’” ");
INSERT INTO nrz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Inoku ia delavuaia dediaka, “Kau davana oni e'oumu, ‘Emu 'eta abiaisi da'a.’? ” ");
INSERT INTO nrz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Enama'ina kauna sia eikabasi ia dai evanama'inala 'olana Iesu ua'i do'u laloanai eneke dodo eda'a ovo. ");
INSERT INTO nrz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muliai Iesu kau kanaua lo'e kabukabuna laloanai edavalia inoku e'ouia ediaka, “Lele'u ika, oni 'eva 'ani onama'ina, si'avana sia bovavai 'udai, dava si'avana vaika ka kevamuai asi'i emapulu 'udai makauna.” ");
INSERT INTO nrz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Inoku kau kanaua eda'a Iuda kauta namata kevatai e'outa ia evanama'inala kauna 'eva Iesu. ");
INSERT INTO nrz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kanaua 'ounai Iuda kauta namata 'eva Iesu devaiviivia 'olana ia melala kabukabunai dava katania evavai 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iesu e'outa ediaka, “Lau Kama'u 'eva melala bounai evinaula easimo vali'u melala kanania. Lau vaka avinaula.” ");
INSERT INTO nrz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Luva kanania 'ounai Iuda kauta namata 'eva deula Iesu beaku bala. Sia melala kabukabuna mo talavatuna eukuia 'ounai, beia ia Dilava e'aeia ia kamana umauna maivaka ia sibona Dilava ita evavitaitata. ");
INSERT INTO nrz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kanaua 'ounai Iesu eta luva kanania evamuea koma, “Lau oi luva umauna a'oumui. Nakuna 'eva sia dava ka sibona bevavaia bedaia. Ia 'eva Kamana evavai vinaulata kataua mo e'ika evavaita. Kamana dava evavai 'eva Nakuna vaka evavai. ");
INSERT INTO nrz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","'Olana Kamana 'eva Nakuna elalo'au venia 'ounai evavai davata boutai evaikala. 'O, sia katania mo, dava namata vaida vaka bevaikala, inoku oi bo'ika 'eva oi botabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kamana etata'u ba kauta evako'isita 'udai inoku mauli evenita vitaitanai mo Nakuna etata'u eula venita kauta mauli evenita. ");
INSERT INTO nrz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mune'e Kamana sibona sia kau ka evaluvala, beia valuva siavuna itoinai 'ani Nakuna evenia, ");
INSERT INTO nrz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kanaua'i Kamana 'olana de'aku vitaitanai kau boutai Nakuna 'olana be'aku, Nakuna 'olana sia e'aku kauna 'eva Kamana kanaua Nakuna esinia kauna vaka 'olana sia e'aku. ");
INSERT INTO nrz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Lau oi luva umauna a'oumui, e'u luva e'ika mai esini'u Dilavana eabivenia kauna 'eva mauli keinikeini 'ani eabia inoku mekau sia bevuala. Ia 'eva ba ai 'ani ekeini inoku 'ani mauli laloanai edodo. ");
INSERT INTO nrz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Lau oi luva umauna a'oumui, bonina 'eva 'ani e'asi, inoku vali'u bonina 'ani ele'au, ba kauta 'eva Dilava Nakuna lelena be'ika, inoku lele ika kauta kataua 'eva bemauli. ");
INSERT INTO nrz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kamana sibona 'eva mauli 'olana, vitaitanai ia eta'u Nakuna mauli 'olanai evaaoa. ");
INSERT INTO nrz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Maivaka Dilava eta'u Nakuna valuva siavuna 'ani evenia 'olana ia 'eva Kau Nakuna 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","E'u luva kanania 'ounai sia oi botabulovo. Melalana 'ani e'asi, mitavai ba kauta kataua boutai Nakuna lelena be'ika, ");
INSERT INTO nrz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","inoku mitavatai bela'asi. Nama'ina devavai kauta kataua 'eva beko'isi mauli keinikeini beabia, inoku si'avana devavai kauta kataua 'eva beko'isi mekau bevuala. ");
INSERT INTO nrz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Lau sibo'u e'uai sia dava ka bavavaia. Lau a'ika luvana vitaitanai mo valuva vinaulata avavai, kanaua 'ounai e'u valuva 'eva ekomolo, 'olana lau sibo'u e'u nama'ina sia akavua, beia esini'u kauna ena ula akavua. ");
INSERT INTO nrz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Lau sibo'u vali'u bakakava koanai, e'u vali kava 'eva sia bevamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lau 'ou'uai vali'u ekakava kauna 'eva edeana, inoku lau aikabasia ia eluvala luvana 'eva momo'ai. ");
INSERT INTO nrz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Oi 'ani ovisini Ioane kevana inoku ia eta'u luva umauna luvana eluvavaia. ");
INSERT INTO nrz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Lau vali'u ikavana 'eva sia kau kevatai e'asi, beia lau Ioane ena vali kava luvana aluvala kanaua'i oi vamauli oi bodavalia. ");
INSERT INTO nrz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioane 'eva lamepa boina e'ani 'ailala eveni, ia oi 'eva melala kava'ina mo ena 'ailala oi olalonama vaia. ");
INSERT INTO nrz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Lau dai'uai vali'u ikavana kanaua 'eva Ioane ekeinia. Kama'u vinaula eveni'u bavaoleta vinaulata avavaita katania detata'u Kama'u esini'u valina dekakava. ");
INSERT INTO nrz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Inoku Kama'u esini'u kauna ia sibona eta'u lau vali'u ekava. Asido'o melala kai ia lelena oi oika kovo maivaka asido'o ia vailana oi oikaia, ");
INSERT INTO nrz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'o ena luva vaka nuamuiai sia emia, 'olana ia esinia kauna sia oi oabivenia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Puka kabukabunai oi okavua kave'i 'olana oi olalovaia luva kataua laloatai mauli keinikeini oi bodavalia. Puka kabukabuna kanania 'eva lau mo vali'u ekakava, ");
INSERT INTO nrz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","beia sia oi o'ula oibo'asi keva'uai mauli oiboabia. ");
INSERT INTO nrz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Lau 'eva kau etai vanama'ina luvata sia abitadae, ");
INSERT INTO nrz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","beia lau 'eva oi aikabasimui kave'i, oi nuamuiai Dilava ilalo'au venina sia emimia. ");
INSERT INTO nrz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Lau 'ani Kama'u vanai asi, beia lau sia oi oabi'udae. Beia bema kau ka sibona vanai be'asi koanai 'ani oi boabiadae. ");
INSERT INTO nrz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Oi ka ka sibomui viloamuiai ivanama'inamui luvata oi okakavu, beia Dilava mo sibona kevanai vanama'ina e'asi kanaua 'eva sia oi okavua, kanaua boina koanai a oi boabiveni'u koma? ");
INSERT INTO nrz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Beia nuamuiai sia oi bolalovaia lau Kama'u vailanai va'evai bane'emui divo. Asi'i, oi va'evai bene'emui divo kauna 'eva Mose, ia enai emui nuabata oi o'uleta. ");
INSERT INTO nrz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bema oi Mose oabivenia dokadoka koanai lau vaka oi boabiveni'u, 'olana ia 'eva lau vali'u eleleia. ");
INSERT INTO nrz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Beia ia eleleia davana bema sia oi boabivenia koanai lau e'u luva aboina oi boabivenia?” ");
INSERT INTO nrz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Boni vaida deole mulinai Iesu ekeini eda'a Kalilea 'ovu avekenai. ('Ovu kanaua vana ka 'eva Tibelia 'ovuna), ");
INSERT INTO nrz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","inoku kau mato namavaikana Iesu mulinai develi deda'a 'olana ia 'olele kauta evanama'inata vatabulovota koata kataua deika 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Inoku Iesu loloai ele'au eda'a inoku ibanona kauta ita demiadivo. ");
INSERT INTO nrz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iuda kauta eta La'au keini naduna 'eva 'ani ekevai. ");
INSERT INTO nrz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu ekailao kau mato namavaikana deasi venia eikata koanai, Ia Pilipo elavuaia ediaka, “Iani a'i eka tava kau katania ekavananita?” ");
INSERT INTO nrz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ia siako eikabasi dava bevavaia, beia Pilipo bevakovoa 'ounai kanaua elavuaia koma. ");
INSERT INTO nrz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipo ia ena luva evamuea ediaka, “Moni doutamo vaika iani kamatava beia sia bedaia, iani kava'ita mo 'ani beani.” ");
INSERT INTO nrz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ibanona kauta ka vana Andelea, Simona Petelo kadina eko'isi ediaka, ");
INSERT INTO nrz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Melo kikina ka nia'i 'eva mai ena palaoa kikita ima mai sisi kikita lua. Beia kataua 'eva a eka komata 'olana kau 'eva doutamo vaika?” ");
INSERT INTO nrz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu ibanona kauta e'outa ediaka, “Kau ovamiata divo.” Ua 'eva teleai, inoku kau boutai demiadivo, momoluane 'avaeana boutai 'eva sinavu boutai imanavui (5,000). ");
INSERT INTO nrz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu palaoa eabita, Dilava evanama'inala, inoku demiadivo kauta kataua eta ula vitaitanai evenita, inoku sisi vaka kanaua boina evavaia. ");
INSERT INTO nrz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Boutai deani vunu koanai Iesu ibanona kauta e'outa ediaka, “Iani kalita boutai oi bodoubou, sia kikina ka oi bovikania.” ");
INSERT INTO nrz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kanaua 'ounai palaoa imai deani vunu kalita kataua dedoubouta aleka 'ouka lua devavonuta. ");
INSERT INTO nrz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iesu vatabulovo koana kanaua evavaia kau deikaia mulinai deluva dediaka, “Momo'ai dokadoka, enolea kauna be'asi kanobatai kauna 'eva kanania.” ");
INSERT INTO nrz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu eikabasi ia eta ulai be'asi beabia kao eta lovia 'olana kaunai bevaaoa, kanaua 'ounai ia sibona mune'e eda'a ovo eda'a loloai ele'au. ");
INSERT INTO nrz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Elavilavi koanai ibanona kauta de'ovu deda'a 'ovuai, ");
INSERT INTO nrz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","asiai dele'au deveau keini Kapelanauma deda'aia 'eva 'ani evabulala divo, Iesu 'eva sia ia viloatai. ");
INSERT INTO nrz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lani namavaikana eunu 'eva 'ovu evaka'udaia. ");
INSERT INTO nrz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ia maela koi 'o vani boita debala ilulao koanai Iesu vei akanai eda'a, asi kokona easia, deikaia 'eva demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Beia Iesu e'outa ediaka, “Nia 'eva lau. Sia oi bomakau.” ");
INSERT INTO nrz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Inoku ia mailalonamata ita asiai devaelea'au, komolonaimo deula venia 'abuna nabuanai devadai'au. ");
INSERT INTO nrz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Elani kau mato ua'i 'ovu avekenai demia kauta deikabasi asi ka'onamo mo ua'i, inoku Iesu 'eva ibanona kauta ita sia ele'au, ibanona kauta sibota mo deveauasi deda'a. ");
INSERT INTO nrz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Inoku asi vaida Tibeliai deasi deda'a Lovia namana palaoa evanama'inala kau evenita deani 'abuna kevanai dela'asi. ");
INSERT INTO nrz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kau mato deikabasi Iesu mai ibanona kauta ita ua'i vailata asi'i, inoku asi kataua'i dele'au deda'a Kapelanauma Iesu dekavuia. ");
INSERT INTO nrz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ia 'ovu avekenai ua'i Iesu dedavalia koanai delavuaia dediaka, “Vaikabasi kaumu e, oni aida mo okeini oasi nia'i?” ");
INSERT INTO nrz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu eta luva evamuea ediaka, “Lau oi luva umauna a'oumui, oi lau okavu'u 'olana 'eva sia vatabulovo koata oi oikata 'ounai beia palaoa oi oani bo'amui dekubu 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Iani besi'avana davana kanaua dainai sia oi bovinaula beia iani bemimia beda'a mauli keinikeini dainai oi bovinaula, Lau Kau Nakuna 'eva iani kanania bavenimui. Kama'u Dilava ena siavu koana aka'uai 'ani e'uleia.” ");
INSERT INTO nrz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Inoku ia delavuaia dediaka, “Lai dava bavavaia 'eva Dilava eulavai vinaulata lai bavavaita?” ");
INSERT INTO nrz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu eta luva evamuea ediaka, “Dilava ena vinaula 'eva kanania. Esinia kauna mo oi boabivenia.” ");
INSERT INTO nrz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kanaua 'ounai ia delavuaia dediaka, “Vatabulovo koana davana bovavaia lai baikala inoku lai babivenimu? Davana bovavaia? ");
INSERT INTO nrz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ita 'ava'avata kano'akunai mana deania, Puka kabukabunai ilelena vitaitana, ‘Vutuvutuai easi manana Mose evenita deania.’” ");
INSERT INTO nrz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu e'outa ediaka, “Lau oi luva umauna a'oumui, sia Mose vutuvutu bokamana oi evenimui, beia lau Kama'u eta'u vutuvutu bokamana umauna oi evenimui. ");
INSERT INTO nrz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","'Olana Dilava ena bokama 'eva vutuvutuai e'ovu easi kauna inoku kanobatai mauli eveveni.” ");
INSERT INTO nrz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ia de'ouia dediaka, “Lovia namana e, bokama kanania 'eva melala boutai bovenimai.” ");
INSERT INTO nrz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Inoku Iesu ia e'outa ediaka, “Lau 'eva mauli bokamana, beasi veni'u kauna 'eva sia bevikolo kovo, maivaka beabiveni'u kauna 'eva sia beveiba kovo. ");
INSERT INTO nrz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Beia lau 'ani oi a'oumui, 'ani oi oika'u inoku sia oi oabiveni'u. ");
INSERT INTO nrz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kama'u eveni'u kauta boutai 'eva be'asi keva'u, inoku easi veni'u kauna 'eva lau sia 'ani balo'oia kovo. ");
INSERT INTO nrz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'Olana lau vutuvutuai a'ovu asi 'eva sia sibo'u e'u ula bavavaia, beia esini'u kauna ena ula vinaulana bavavaia. ");
INSERT INTO nrz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Inoku esini'u Dilavana ena ula 'eva kanania, eveni'u kauta kataua boutai 'eva sia ka bavataulea, beia melala to'onai bavako'isita 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Olana lau Kama'u ena ula 'eva kanania, Nakuna beikala mai beabivenia kauta boutai 'eva mauli keinikeini beabia, inoku melala to'onai 'eva bavako'isita 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Luva kanania 'ounai Iuda kauta Iesu denunu vaia, 'olana ia ediaka, “Lau 'eva vutuvutuai e'ovu easi bokamana.” ");
INSERT INTO nrz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Inoku ia dediaka, “Nia 'eva Iesu, Iosepa nakuna, ia kamana mai sinana kaikabasita. Vali'u ia aboina ediaka, ‘Lau vutuvutuai a'ovu asi.’?” ");
INSERT INTO nrz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu eta luva evamuea ediaka, “Sibomui viloamuiai nunuvai nunuvai kanana ovapuala. ");
INSERT INTO nrz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sia kau ka 'ani beasi keva'u beia Kama'u esini'u kauna betata'u bevuala be'asi keva'u, inoku melala to'onai bavako'isia 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Enolea kauta Puka kabukabunai 'ani deleleia, ‘Dilava ia boutai 'ani bevaikabasita.’ Kama'u lelena de'ika maivaka kevanai ikabasi deabia kauta boutai 'eva be'asi keva'u. ");
INSERT INTO nrz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sia kau ka Kamata eikaia kovo, beia Dilava kevanai easi kauna mo sibona Kamata eikaia. ");
INSERT INTO nrz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Lau oi luva umauna a'oumui. Deabiveni'u kauta 'eva 'ani mauli keinikeini deabia. ");
INSERT INTO nrz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Lau 'eva mauli bokamana. ");
INSERT INTO nrz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Oi 'ava'avamui kano'akunai mana deania, beia deba. ");
INSERT INTO nrz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Beia vutuvutuai e'ovu easi bokamana kanania, beania kauna 'eva sia bebaba. ");
INSERT INTO nrz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Lau 'eva mauli bokamana, vutuvutuai a'ovu asi. Bema kau ka bokama kanania beania 'eva bemauli keinikeini. Bokama kanania 'eva lau vidio'u, kanobata kauta mauli beabia dainai baveveni.” ");
INSERT INTO nrz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Inoku Iuda kauta sibota viloatai deadedua dediaka, “Kau kanania aboina vidiona bevenita eka ania?” ");
INSERT INTO nrz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu e'outa ediaka, “Lau oi luva umauna a'oumui. Lau Kau Nakuna vidio'u sia oi boania mai lala'u sia oi boinua koanai oi nuamuiai mauli sia bemimia. ");
INSERT INTO nrz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lau vidio'u eania mai lala'u einua kauna 'eva mauli keinikeini 'ani eabia inoku melala to'onai 'eva bavako'isia 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","'Olana lau vidio'u 'eva iani umauna maivaka lala'u 'eva inuinu veina umauna. ");
INSERT INTO nrz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Lau vidio'u eania mai lala'u einua kauna 'eva lau nua'uai emimia maivaka lau ia nuanai amimia. ");
INSERT INTO nrz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kama'u emauli kauna eta'u esini'u, lau 'eva Kama'u 'ounai amauli vitaitanai lau kauani'u beania kauna 'eva lau 'ou'uai bemauli. ");
INSERT INTO nrz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Vutuvutuai e'ovu easi bokamana 'eva kanania. Oi 'ava'avamui mana deania inoku deba, beia bokama kanania beania kauna 'eva bemauli keinikeini.” ");
INSERT INTO nrz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu Kapelanaumai evaikabasi laloanai Iuda kauta eta lo'e ai luva katania eluvavaita. ");
INSERT INTO nrz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Debanoia kauta doutamo lelena deika inoku dediaka, “Luva kanania 'eva epasisi, luva kanania dai betata'u beabiadae?” ");
INSERT INTO nrz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu 'ani eikabasi debanoia kauta luva kanaua denunuvai nunuvaia 'ounai e'outa ediaka, “Luva kanania nuamui evabavunua, una? ");
INSERT INTO nrz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Lau Kau Nakuna bamaele'au amia makava 'abuna bamada'ala oi bomaika'u koanai a oi bomakoma? ");
INSERT INTO nrz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Idume Kabukabuna 'eva mauli eveveni, kauani 'eva sia dava ka evapulua. Luva katania a'oumui 'eva idume luvata mai mauli luvata. ");
INSERT INTO nrz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Beia oi vaida 'eva sia oi oabiveni'u.” 'Olana siako Iesu 'ani eikabasi kau davata sia deabivenia mai dai ia venina beveveni mai kouna bekokou. ");
INSERT INTO nrz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Maivaka ia eluva ediaka, “Kanaua 'ounai 'ani a'oumui adiaka, ‘Kama'u sia kau ka bevuala be'asi koanai sia kau ka 'ani beasi keva'u.’” ");
INSERT INTO nrz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Melala kanaua'i Iesu debanoia kauta doutamo ia devikania maivaka mulinai sia deda'a 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Inoku Iesu ibanona kauta 'ouka lua elavuaita ediaka, “Oi vaka oi o'ula oi bovikani'u, una?” ");
INSERT INTO nrz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Petelo enu'ovi ediaka, “Lovia namana e, lai dai kevana lai bada'ala? Mauli keinikeini luvata 'eva oni kevamuai demimia. ");
INSERT INTO nrz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lai 'ani abivenimu mai lai aikabasi oni 'eva Dilava ena Kabukabu Kaumu.” ");
INSERT INTO nrz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Inoku Iesu e'outa ediaka, “Lau oi kaumui 'ouka lua adilamui. Beia oi ka 'eva diabolo.” ");
INSERT INTO nrz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ia eluvavaia kauna 'eva Iuda Isakaliote kauna, Simona nakuna, ia ibanona 'ouka lua kauta ka, muliai Iesu venina beveveni mai kouna bekokou kauna. ");
INSERT INTO nrz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kanaua mulinai Iesu Kalileia laloanai eda'a to'ato'a, ia sia eula beda'a Iudea 'olana Iuda kauta namata 'eva de'imaia beaku bala. ");
INSERT INTO nrz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iuda kauta eta Aiole naduna 'ani ekevai koanai, ");
INSERT INTO nrz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesu kadina deta'u de'ouia dediaka, “'Abu kanania bovikania boda'a Iudea inoku debanomu kauta ua'i vatabulovo koata bovavai be'ika. ");
INSERT INTO nrz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","'Olana kau ka sibona e'ula bevala'asia koanai ia sia dava ka vunivuniai evavaia, dava katania 'ani ovavaita 'ounai sibomu vala'asimu kanobata itoinai deikabasimu.” ");
INSERT INTO nrz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kanaua deluva koma 'olana ia kadina umauta vaka ia sia deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Inoku Iesu e'outa ediaka, “Asido'o e'u melala umauna easi. Beia melala boutai oi kevamuiai 'eva dedaia. ");
INSERT INTO nrz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kanobata 'eva sia oi evaiviivimui beia lau evaiviivi'u, 'olana ia evavaia davana kanaua lau aluva vaia 'eva si'avana. ");
INSERT INTO nrz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Oi oda'a nadu 'abuna, lau 'eva sia 'ani bavasi nadu 'abuna kanana 'olana e'u melala umauna 'eva asido'o edaia.” ");
INSERT INTO nrz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ia luva kanania eluvaia inoku Kalileiai emia. ");
INSERT INTO nrz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesu kadina deda'a nadu 'abuna mulinai ia vaka eda'a nadu 'abuna beia vunivuniai eda'a, sia ela'asi do'u vailatai. ");
INSERT INTO nrz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Inoku nadu kanaua laloanai Iuda kauta namata 'eva Iesu dekavuia delavuai lavuai vaia, “Kau kanaua 'eva a'i?” ");
INSERT INTO nrz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ua'i do'u laloanai 'eva deteoteo vaia, vaida dediaka, “Ia 'eva kau nama'ina.” Vaida mune'e dediaka, “Asi'i, ia 'eva kau e'ana'ia vaita va'eva.” ");
INSERT INTO nrz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Beia Iuda kauta namata makauta demakau dainai, sia kau ka do'u vailatai ia luvana eluva kovo. ");
INSERT INTO nrz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nadu kukuanai Iesu ele'au eda'a lo'e kabukabunai ena vaikabasi emakavala. ");
INSERT INTO nrz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Inoku Iuda kauta namata 'eva detabulovo si'asi'a dediaka, “Kau kanania sia eda'a malele 'abuna ka, beia aboina ia eikabasi vaika?” ");
INSERT INTO nrz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu eta luva evamuea ediaka, “E'u vaikabasi luvata 'eva sia lau sibo'u e'u, beia esini'u Dilavana enai de'asi. ");
INSERT INTO nrz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kau ka Dilava ena ula vinaulana bevavaia koanai ia 'ani beikabasi, lau e'u vaikabasi 'eva Dilava kevanai easi 'o lau sibo'u e'u luva. ");
INSERT INTO nrz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kau ka sibona ena ula luvana eluvala kauna 'eva sibona ena nama'ina ekavua beia esinia kauna ena nama'ina ekavua kauna 'eva momo'ai kauna, ia nuanai 'eva va'eva asi'i. ");
INSERT INTO nrz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose talavatu 'ani evenimui, una? Beia sia kau ka talavatu kanania oabi'inia. Dava 'ounai oi o'ula boaku ba'u?” ");
INSERT INTO nrz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Do'u kauta ena luva devamuea dediaka, “Oni 'eva 'olamu esi'avana, dai e'ula beaku bamu?” ");
INSERT INTO nrz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu e'outa ediaka, “Lau melala kabukabunai vatabulovo koana ka'onamo avavaia, inoku oi boumuiai otabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose ivaiva vinaulana evenimui 'ounai melala kabukabunai melo kikita oi oivata. (Ivaiva vinaulana 'eva sia Mose kevanai easi, beia oi kubumui 'ava'avamui kevatai easi.) ");
INSERT INTO nrz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Vali'u melala kabukabuna laloanai melo oi oivata 'eva Mose ena talavatu asi'i oi omaukua makauna. Dava 'ounai melala kabukabuna laloanai kau ka kauanina itoinai avanama'inala dainai oi obaduveni'u? ");
INSERT INTO nrz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sia Dava ikata koatai oi bovaluvata, beia dava eta komolo umautai oi bovaluvata.” ");
INSERT INTO nrz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Boni kanaua'i Ielusalema kauta vaida delavuai lavuai dediaka, “De'ula beaku bala kauna 'eva kanania, una? ");
INSERT INTO nrz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kauna 'eva kanana do'u vailatai eilolo, inoku sia luva ka ia kevanai deluvala kovo, ama'i kau namata 'ani delalovaia dokadoka ia 'eva Keliso 'o? ");
INSERT INTO nrz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Keliso be'asi koanai ena asi 'abuna 'eva sia kau ka beikabasia, beia kau kanania ena asi 'abuna 'eva ita kaikabasia.” ");
INSERT INTO nrz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Inoku Iesu lo'e kabukabunai evaikabasi laloanai evaoi ediaka, “'O, oi lau oikabasi'u, a'i asi vaka oi oikabasia. Lau sia sibo'u e'u ulai asi, beia esini'u Dilavana 'eva momo'ai. Ia sia oi oikabasia, ");
INSERT INTO nrz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","beia lau 'eva ia aikabasia 'olana lau ia kevanai asi maivaka ia lau esini'u.” ");
INSERT INTO nrz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Luva kanania 'ounai ia deula belioa beia sia kau ka ia kaunai ekao'au 'olana ena melala 'eva asido'o edaia. ");
INSERT INTO nrz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Do'u laloanai kau doutamo ia deabivenia inoku dediaka, “Keliso be'asi koanai, ia vatabulovo koata doutamo bevavai kau kanania bekeinia, una?” ");
INSERT INTO nrz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Palisea kauta 'eva mato Iesu deteoteo vaia leleta deika inoku kabukabu kauta namata mai Palisea kauta deta'u lo'e kabukabuna de'imala kauta desinita Iesu belioa. ");
INSERT INTO nrz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Inoku Iesu ediaka, “Lau 'eva melala kava'ina mo oi ita ekamia vakaia bamumue bada'a esini'u kauna kevana. ");
INSERT INTO nrz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Oi bokavu'u beia sia 'ani oi bodavali'u. Sia 'ani oi boasi lau bamimia 'abuna.” ");
INSERT INTO nrz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Inoku Iuda kauta namata sibota devilavuai viveni dediaka, “Kau kanania 'eva a beda'ala kanaua'i ita ia sia ekadavalia? Beda'a ua'i Iuda kauta deda'aia odaoda 'Elene kauta viloatai demimia kauta kevatai inoku 'Elene kauta bevaikabasita, 'o? ");
INSERT INTO nrz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Luva kanania anina 'eva dava, ia ediaka, ‘Oi bokavu'u beia sia oi bodavali'u,’ maivaka ‘Sia 'ani oi boasi lau bamimia 'abuna.’” ");
INSERT INTO nrz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nadu melalana to'onai 'eva melala namana, Iesu elavadivo inoku eluva 'unu'unu ediaka, “Bema kau ka vei bana ebaba 'eva be'asi lau keva'u inoku vei be'inu. ");
INSERT INTO nrz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Puka kabukabunai deleleia boina, ‘Lau eabiveni'u kauna 'eva ia nuanai mauli veina be'alu itani nutu boina.’” ");
INSERT INTO nrz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Luva kanania 'eva Idume Kabukabuna eluvavaia ia deabivenia kauta kataua 'eva muliai bevenita, 'olana Iesu ena nuavi asido'o eabia 'ounai Idume Kabukabuna 'eva asido'o eveni. ");
INSERT INTO nrz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kau vaida Iesu ena luva katania 'uluta deika koanai dediaka, “Momo'ai dokadoka kau kanania 'eva Enolea kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vaida dediaka, “Ia 'eva Keliso.” Beia vaida delavuai dediaka, “Keliso 'eva aboina Kalileiai be'asi? ");
INSERT INTO nrz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Puka kabukabunai kanania eluva koma. Keliso 'eva Davida kekenai bepupulu Davida emia vanuana Betele'ema laloanai.” ");
INSERT INTO nrz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kanaua 'ounai Iesu dainai kau viloata e'alama. ");
INSERT INTO nrz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ia vaida deula belioa, beia sia kau ka ia kaunai ekao'au. ");
INSERT INTO nrz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mulinai lo'e kabukabuna de'imala kauta kataua demue deda'a kabukabu kauta namata mai Palisea kauta kevata, inoku ia deta'u delavuaita dediaka, “Dava 'ounai ia sia oi ovuala o'asi?” ");
INSERT INTO nrz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Ima'ima kauta eta luva devamuea dediaka, “Kanaua koanai easimo vali'u sia kau ka kanaua boina eluva kovo kau kanania eluluva boinai.” ");
INSERT INTO nrz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Inoku Palisea kauta denu'ovi dediaka, “Oi vaka 'ani evada'amui va'eva, una? ");
INSERT INTO nrz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Oi olalovaia kau namata 'o Palisea kauta ka ia eabivenia? Asi'i. ");
INSERT INTO nrz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Beia do'u kauta kataua Mose ena talavatu sia deikabasia kauta 'eva Dilava ena sivada ia akatai bemimia.” ");
INSERT INTO nrz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ia banota ka Nikodemo, melala ka eda'a Iesu kevana kauna, eta'u e'outa ediaka, ");
INSERT INTO nrz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ita eta talavatu avekenai sia kau ka mekau ekavenia 'avaea, ia lelena ekaika makava, ia dava evavaia davana ekaikabasia makava.” ");
INSERT INTO nrz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ia de'ouia dediaka, “Oni vaka Kalileia kaumu, una? Puka kabukabuna boikala inoku bodavalia sia enolea kauna ka 'eva Kalileiai be'asi.” ");
INSERT INTO nrz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Inoku kau boutai demue itaumo ena luma deda'aia. ");
INSERT INTO nrz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Beia Iesu 'eva eda'a Olive lolona. ");
INSERT INTO nrz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Elani 'avu'ani vabulanai Iesu mune'e eda'a lo'e kabukabuna laloanai kau boutai deda'a ia dedabubua, inoku ia emiadivo evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Talavatu 'ola kauta mai Palisea kauta ateate ka ekulakulai dedavalia devuaia deasi. Do'u vailatai devalavala, ");
INSERT INTO nrz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","inoku Iesu de'ouia dediaka, “Vaikabasi kaumu e, ateate kanania 'eva ekulakulai lai adavalia. ");
INSERT INTO nrz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Inoku Mose ena talavatu laloanai 'eva kanania eluva koma, katania boita 'a'atete 'eva bika'ai eka aku bata. Vali'u oni 'eva dava okoma?” ");
INSERT INTO nrz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Lavuai kanania deabia deda'a Iesu kevanai 'eva bevaviua, kanaua'i va'evai bene'eadivo. Beia Iesu 'eva esilidivo imana li'uli'unai kanoai elelelele. ");
INSERT INTO nrz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ia delavuaia basibasi koanai, ia elavadivo inoku e'outa ediaka, “Viloamuiai kau ka sia mai emu si'avana kaumu, bika'a itoa makava ateate kanania akua.” ");
INSERT INTO nrz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mune'e esilidivo kanoai elelelele 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Luva kanania deika kauta 'eva ka'oka'o deda'a ovo motunai emakavala eda'amo 'alu'alunai epua, Iesu mo sibona devikania ateate ia kevanai elava. ");
INSERT INTO nrz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu elavadivo inoku ateate elavuaia ediaka, “Ateate e, kau katania a'i? Sia kau ka mekau evenimu?” ");
INSERT INTO nrz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ateate ediaka, “Lovia namana e, sia kau ka.” Iesu ia e'ouia ediaka, “Lau vaka oni sia mekau ka bavenimu, da'a sia si'avana ka bovavaia 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu kau eluva venita 'udai koanai ediaka, “Lau 'eva kanobata 'ailalana. Kau ka lau muli'uai bedada'a kauna 'eva vabuto'o laloanai sia bedada'a, beia mauli 'ailalana beabia.” ");
INSERT INTO nrz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Palisea kauta ia de'ovenia dediaka, “Oni sibomu valimu okakava, emu vali kava 'eva sia momo'aina.” ");
INSERT INTO nrz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu enu'ovi ediaka, “Lau sibo'u vali'u akakava 'eva momo'aina 'olana lau a'i asi mai a bada'ala 'abuna 'eva aikabasia beia oi 'eva lau a'i asi 'o a bada'ala 'abuna sia oi oikabasia. ");
INSERT INTO nrz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Oi kau eta koakoa vitaitanai oi ovaluvata. Lau 'eva sia kau ka avaluvala. ");
INSERT INTO nrz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Beia lau valuva bavavaia koanai, e'u valuva 'eva bekomolo, 'olana lau 'eva sia sibo'u, Kama'u esini'u kauna vaka keva'uai. ");
INSERT INTO nrz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Emui talavatu laloanai kanania eleleia koma, kau lua eta luva beka'onamo 'eva momo'ai luvana. ");
INSERT INTO nrz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lau sibo'u vali'u akakava mai Kama'u esini'u kauna vaka vali'u ekakava.” ");
INSERT INTO nrz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Inoku ia delavuaia dediaka, “Kamamu 'eva a'i?” Iesu enu'ovi ediaka, “Oi sia oikabasi'u 'ounai Kama'u sia oikabasia. Bema oi lau bomaikabasi'u koanai Kama'u vaka oi bomaikabasia.” ");
INSERT INTO nrz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu lo'e kabukabuna laloanai veniveni monina ine'edivona 'abuna kevanai evaikabasi laloanai luva katania eluvavai. Beia sia kau ka ia elioia 'olana ia ena melala asido'o edaia. ");
INSERT INTO nrz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu ia e'outa 'udai ediaka, “Lau 'ani bada'a tau, inoku oi lau bokavu'u beia emui si'avanai oi bobaba. Sia 'ani oi boda'a lau badada'a 'abuna.” ");
INSERT INTO nrz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Luva kanania 'ounai Iuda kauta namata sibota devilavuai viveni dediaka, “Ia kanania eluva koma, ‘Lau badada'a 'abuna sia 'ani oi boasi,’ Kanaua anina 'eva ia sibona beaku bala, 'o?” ");
INSERT INTO nrz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu ediaka, “Oi 'eva venuai oasi lau 'eva akai asi, oi 'eva kanobata kanania kaumui, lau 'eva sia kanobata kanania kau'u. ");
INSERT INTO nrz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lau 'ani a'oumui, ‘Emui si'avanai oi bobaba,’ Kauna 'eva Lau kau'u sia oi boabiveni'u koanai emui si'avanai oi bobaba.” ");
INSERT INTO nrz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ia delavuaia dediaka, “Inoku oni 'eva dai?” Iesu eta luva evamuea ediaka, “Lau siako a'oumui lau 'eva dai. ");
INSERT INTO nrz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Oi daimuiai lau luva doutamo bamaluva maivaka mekau namana bamavenimui, beia esini'u kauna 'eva momo'ai umauna, lau ia kevanai aika luvana mo kanobata kauta a'outa.” ");
INSERT INTO nrz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesu Kamana lovana eakuia 'eva ia nuata sia de'eko'ovi. ");
INSERT INTO nrz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kanaua 'ounai Iesu ediaka, “Lau Kau Nakuna oi boisi'u 'au koanai 'ani oi boikabasi kauna 'eva lau kau'u, maivaka lau sibo'u sia dava ka avavaia beia Kama'u dava evaikabasi'u vitaitatai aluvavaita. ");
INSERT INTO nrz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Maivaka esini'u kauna 'eva ebano'u, ia lau sia evikani'u 'avaea, 'olana melala boutai ia ivalalonamana vinaulata avavai.” ");
INSERT INTO nrz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Luva katania e'outa 'eva kau doutamo ia deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Inoku Iesu Iuda kauta ia deabivenia kauta e'outa ediaka, “E'u vaikabasi luvata daitai oi bodadai koanai oi 'eva lau ibano'u kaumui umaumui. ");
INSERT INTO nrz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Inoku luva umauna oi boikabasia, maivaka luva umauna betata'u beluvune'emui.” ");
INSERT INTO nrz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ia denu'ovi dediaka, “Lai Abela'amo kekena kaumai maivaka sia kau ka da'alana lai ba'abi. Lai aboina beluvune'emai okoma?” ");
INSERT INTO nrz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu e'outa ediaka, “Lau oi luva umauna a'oumui, si'avana evavaia kauna 'eva si'avana da'alana e'abi. ");
INSERT INTO nrz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Da'alaabi kauna 'eva 'ola kauna ena lumai sia bemia keinikeini, 'ola kauna nakuna 'eva luma kanaua'i bemia keinikeini. ");
INSERT INTO nrz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kanaua 'ounai Nakuna betata'u beluvune'emui koanai oi 'ani eluvune'emui vaika. ");
INSERT INTO nrz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Lau aikabasimui oi Abela'amo kekena kaumui, beia e'u luva nuamuiai sia emimia 'ounai oi o'ula boaku ba'u. ");
INSERT INTO nrz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Lau Kama'u vailanai aikata davata a'oumui, inoku oi kamamui enai oi oika davata oi ovavaita.” ");
INSERT INTO nrz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ia Iesu ena luva devamuea dediaka, “Lai kamamai 'eva Abela'amo.” Inoku ia e'outa ediaka, “Oi Abela'amo nakuna koanai Abela'amo evavai vinaulata oi bomavavai. ");
INSERT INTO nrz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dilava enai luva momo'aina aika davana a'oumui, beia oi dala okakavu oi boaku ba'u. Abela'amo sia kanaua boina evavaia. ");
INSERT INTO nrz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Oi kamamui evavai davata 'eva oi ovavaita.” Ia Iesu de'ouia dediaka, “Lai sia apulu tauasi, lai kamamai 'eva ka'onamo Dilava mo sibona.” ");
INSERT INTO nrz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu mune'e ediaka, “Oi kamamui Dilava koanai oi bomalalo'au veni'u. 'Olana lau Dilava enai asi nia'i. Lau 'eva sia sibo'u e'u ulai asi beia Kama'u esini'u. ");
INSERT INTO nrz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dava 'ounai aluvavai luvata 'eva nuamui sia de'eko'ovi? 'Olana e'u luva iabidaena sia oi oula venia. ");
INSERT INTO nrz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Oi kamamui 'eva diabolo, oi o'ula kamamui ena ula vinaulana oi bovavaia. Ia 'eva akuaku kauna makavanai easimo vali'u, ia sia luva umautai eluluva, 'olana ia nuanai sia luva umauna ka emimia. Ia dede luvana eluvala 'eva ia ena koakoa umauna, 'olana ia 'eva dede kauna maivaka dede boutai kamata. ");
INSERT INTO nrz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Lau luva umauna aluvala 'ounai lau e'u luva sia oi ovamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inoku kau ka lau e'u si'avana 'ani odavalia 'eva bovala'asia. Lau luva umauna aluvala koanai dava 'ounai e'u luva sia oi ovamomoaia? ");
INSERT INTO nrz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dilava nakuna kauna 'eva Dilava ena luva leleta be'ika, beia oi lele sia o'ika 'olana oi sia Dilava nakuna.” ");
INSERT INTO nrz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iuda kauta namata Iesu ena luva devamuea dediaka, “Oni 'eva Samalia kaumu inoku ka'uba si'avana vaika nuamuai emimia, 'ani lai aluva komolo, una?” ");
INSERT INTO nrz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Inoku Iesu ediaka, “Sia ka'uba si'avana vaika ka lau nua'uai emimia. Lau Kama'u 'olana a'aku beia oi lau 'ola'u sia oi o'aku. ");
INSERT INTO nrz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Lau sia sibo'u e'u nuavi akavua, beia Dilava betata'u e'u nuavi bekavua maivaka ia 'eva lau 'ou'uai valuva bevavaia kauna. ");
INSERT INTO nrz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Lau oi luva umauna a'oumui, e'u luva eabi'inia kauna 'eva sia beba kovo.” ");
INSERT INTO nrz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kanaua'i Iuda kauta namata dediaka, “Vali'u lai aikabasimu kave'i ka'uba si'avana vaika oni nuamuai emimia. Abela'amo eba mai enolea kauta vaka deba beia oni odiaka emu luva beabi'inia kauna 'eva ba aviavina sia beonovaia. ");
INSERT INTO nrz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oni lai kamamai Abela'amo okeinia, una? Ia eba mai enolea kauta vaka deba, inoku olalovaia oni 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu enu'ovi ediaka, “Bema lau sibo'u baku'uabalai, e'u akuabalai anina asi'i. Lau Kama'u, ia kauna eta'u lau eaku'uabalai. Inoku oi odiaka, ia 'eva ‘Emui Dilava’. ");
INSERT INTO nrz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Oi ia sia oi oikabasia, lau 'eva ia aikabasia. Inoku lau bamadiaka lau ia sia aikabasia koanai lau dede kau'u itani oi boimui. Beia lau ia aikabasia maivaka ena luva abi'inita. ");
INSERT INTO nrz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Oi kamamui Abela'amo e'u boni beikala 'ounai elalonama, inoku eikaia 'eva elalonama si'asi'a.” ");
INSERT INTO nrz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iuda kauta namata dediaka, “Oni vikaumu asido'o imanavui (50) eabia, ia Abela'amo aboina 'eva oikaia?” ");
INSERT INTO nrz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu e'outa ediaka, “Lau oi luva umauna a'oumui. Abela'amo asido'o epulu lau 'eva 'ani amia.” ");
INSERT INTO nrz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Luva kanaua deika koanai ia bika'a deabisi Iesu beakua, beia ia sibona do'u viloatai epode eda'a ovo lo'e kabukabuna evikania eda'a. ");
INSERT INTO nrz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu dala eda'aia eda'a laloanai maka 'ede kauna ka eikaia, ia 'eva makana 'edetai epulu. ");
INSERT INTO nrz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ibanona kauta Iesu delavuaia dediaka, “Vaikabasi kaumu e, dai ena si'avana 'ounai kau kanania makana 'edenai epulu? Kau kanania ena si'avanai 'o sinana kamana eta si'avanai?” ");
INSERT INTO nrz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu eta luva evamuea ediaka, “Sia kau kanania ena si'avanai maivaka sia sinana kamana eta si'avanai, beia Dilava ena siavu vinaulata ia kaunai bevala'asi beikala 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lau esini'u Dilavana ena vinaula laniai ekavavaia. Boni be'asi koanai sia kau ka bevinaula. ");
INSERT INTO nrz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lau kanobatai amimia laloanai lau 'eva kanobata ena 'ailala.” ");
INSERT INTO nrz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu luva kanania eluvavaia mulinai kanoai e'anodi inoku 'anodinai 'ika'ika emataia, 'ede kauna makana luana eukuta. ");
INSERT INTO nrz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Inoku e'ouia ediaka, “Da'a, Siloama 'ovunai vailamu bokaovai.” (Siloama anina 'eva sinia.) Kau kanaua eda'a vailana ekaovai, emue easi makana 'ani denama'ina. ");
INSERT INTO nrz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kevanai kauta mai 'ana'inai ia enoi va'ame deikaia kauta delavuai lavuai dediaka, “'Ana'inai ua'i emia enoi va'ame kauna ka'onamo kanania, una?” ");
INSERT INTO nrz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vaida dediaka, “Kauna ka'onamo kanana.” Vaida dediaka, “Asi'i, ikana ia mo delaovenia.” Beia ia sibona e'outa ediaka, “Kauna 'eva lau kau'u kanania.” ");
INSERT INTO nrz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ia deta'u delavuaia dediaka, “Vali'u makamu a deko oikaika?” ");
INSERT INTO nrz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ia eta luva evamuea ediaka, “Kau vana de'aea Iesu kauna eta'u 'ika'ika emataia maka'u eukuta, inoku e'ou'u bada'a Siloama 'ovunai vaila'u bakaovai. Kanaua 'ounai ada'a vaila'u akaovai inoku aikaika.” ");
INSERT INTO nrz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ia delavuaia dediaka, “Kau kanaua 'eva a'i?” Ia ediaka, “Lau sia aikabasi.” ");
INSERT INTO nrz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ia deta'u kau kanaua 'ana'inai makana de'ede kauna devuaia deasi Palisea kauta kevata. ");
INSERT INTO nrz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Boni kanaua'i Iesu 'ika'ikai 'ede kauna makana eukuta deata 'eva melala kabukabuna. ");
INSERT INTO nrz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kanaua 'ounai Palisea kauta vaka ia delavuaia aboina makana denama'ina. Maka 'ede kauna ediaka, “Ia 'ika'ikai maka'u eukuta, akaovai inoku vali'u 'ani aikaika.” ");
INSERT INTO nrz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Palisea kauta vaida dediaka, “Kau kanania 'eva sia Dilava kevanai easi 'olana ia melala kabukabuna sia eabi'inia.” Beia vaida dediaka, “Si'avana kauna ka aboina vatabulovo koata katania boita bevavai?” Kanaua 'ounai ia viloata e'alama. ");
INSERT INTO nrz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mune'e Palisea kauta maka 'ede kauna delavuaia 'udai dediaka, “Ia eta'u makamu eva ata, inoku oni olalovaia ia 'eva dai?” Kau kanaua ediaka, “Ia 'eva enolea kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iuda kauta namata sia devamomo'ai ia 'eva maka 'ede kauna inoku 'ani makana denama'ina eda'amo kau kanaua sinana kamana de'aeta deasi. ");
INSERT INTO nrz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Inoku ia delavuaita dediaka, “Nia oi nakumui, una? Makana 'edetai epulu kauna kanania, a? Vali'u ia makana 'eva aboina denama'ina inoku eikaika?” ");
INSERT INTO nrz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ia sinana kamana ia eta luva devamuea dediaka, “Lai aikabasi ia 'eva lai nakumai maivaka ia makana 'edetai epulu. ");
INSERT INTO nrz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Beia vali'u aboina eikaika maivaka dai eta'u ia makana evanama'inata 'eva lai sia aikabasi. Olavuaia, ia 'ani e'aida'aida sibona lovana eakuia.” ");
INSERT INTO nrz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ia sinana mai kamana 'eva Iuda kauta namata makauta demakau 'ounai kanaua deluva koma. 'Olana Iuda kauta 'ani devamomo'aia kau ka be'oudae Iesu 'eva Keliso koanai Iuda kauta eta lo'eai bevala'asia. ");
INSERT INTO nrz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kanaua 'ounai sinana kamana dediaka, “Ia 'ani e'aida'aida olavuaia.” ");
INSERT INTO nrz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Maka 'ede kauna melala ivaluana de'aeia inoku de'ouia dediaka, “Dilava boakuabalai. Lai aikabasi evanama'inamu kauna kanania 'eva si'avana kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kau kanaua eta luva evamuea ediaka, “Lau sia aikabasi, ia si'avana kauna 'o asi'i. Dava ka'onamo lau aikabasia 'eva maka'u de'ede beia vali'u 'ani aikaika.” ");
INSERT INTO nrz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inoku ia delavuaia dediaka, “Oni kevamuai dava evavaia? Makamu aboina eva ata?” ");
INSERT INTO nrz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ia eta luva evamuea ediaka, “Lau siako 'ani a'oumui, beia lele'u sia oi oika. Vali'u dava 'ounai oi o'ula boika 'udai? Oi vaka o'ula ia ibanona kaumuiai oi bo'ao, una?” ");
INSERT INTO nrz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ia deta'u depilaia si'ala dediaka, “Oni 'eva kau kanaua ibanona kaumu, lai 'eva Mose ibanona kaumai. ");
INSERT INTO nrz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Lai aikabasi Dilava eta'u Mose eluvavenia, beia lai sia aikabasi kau kanana a'i easi.” ");
INSERT INTO nrz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kau kanaua eta luva evamuea ediaka, “Vali'u dava edeana umauna epupulu 'olana ia maka'u evanama'inata beia oi sia oikabasia ia a'i easi. ");
INSERT INTO nrz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ita kaikabasi Dilava si'avana kauta leleta sia e'ika. Ia dekukudivo venia kauta maivaka ena ula vinaulana devavaia kauta mo kataua leleta e'ika. ");
INSERT INTO nrz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","'Ana'inai kanobata emakavala koanai easimo vali'u sia kau ka eta'u makana 'edetai epulu kauna ka makana evanama'inata valina ka kaika kovo. ");
INSERT INTO nrz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kau kanania 'eva sia Dilava kevanai easi koanai ia vinaula kanania boina sia bemavavaia.” ");
INSERT INTO nrz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ia deta'u kau kanaua ena luva devamuea dediaka, “Oni 'eva si'avana laloanai opulu inoku oni otata'u lai bovamalelemai, una?” Ia deta'u Iuda kauta eta lo'eai dedolia asi. ");
INSERT INTO nrz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu kau kanaua dedolia asi valina eika inoku edavalia koanai ia elavuaia ediaka, “Oni Lau Kau Nakuna oabiveni'u, una?” ");
INSERT INTO nrz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kau kanaua Iesu ena luva evamuea ediaka, “Loviamu e, ia 'eva dai? 'Ou'u lau batata'u ia babivenia.” ");
INSERT INTO nrz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu ediaka, “Oni vali'u ia 'ani oikala kauna kanania oni eluva venimu.” ");
INSERT INTO nrz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Inoku kau kanaua ediaka, “Lovia namana e, lau abiveni.” Inoku ia Iesu ekukudivo venia. ");
INSERT INTO nrz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu mune'e ediaka, “Valuva dainai lau asi kanobata kanania'i, kanaua'i maka 'ede kauta beikaika inoku deikaika kauta kataua makata be'ede.” ");
INSERT INTO nrz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Palisea kauta vaida ia kevanai kauta kataua 'eva luva kanaua deika inoku delavuaia, “Lai vaka makamai de'ede, una?” ");
INSERT INTO nrz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu e'outa ediaka, “Oi Makamui dema'ede koanai kevamuiai si'avana bemaasi'i. Beia vali'u oi odiaka oi oikaika 'ounai emui si'avana 'eva demimia do'o.” ");
INSERT INTO nrz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu ediaka, “Lau oi luva umauna a'oumui. Kau ka mamoe alana nutualanai sia eda'adodo beia ala kukuanai etakeini kauna 'eva vinao mai abi'avaea kauna. ");
INSERT INTO nrz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ia nutualai eda'adodo kauna 'eva mamoe i'imana kauna. ");
INSERT INTO nrz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nutuala eikalakao kauna 'eva kau kanaua nutualana eluvua inoku mamoe ia lelena de'ika. Ia ena mamoe vata umautai e'aeta inoku e'ana'iavaita dela'asi. ");
INSERT INTO nrz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ia ena mamoe boutai evala'asi paluta koanai, ia vailatai edada'a inoku ena mamoe ia mulinai dedada'a 'olana ia lelena deikabasia. ");
INSERT INTO nrz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ia sia kau edeana ka mulinai bedada'a, kau kanaua kevanai beveau akauma 'olana kau edeana kauna lelena sia deikabasia.” ");
INSERT INTO nrz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu luva ivavitaitana kanania'i e'outa, beia ia eluvavaia luvana ovonai sia deovo. ");
INSERT INTO nrz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kanaua 'ounai Iesu eluva 'udai ediaka, “Lau oi luva umauna a'oumui. Lau 'eva mamoe eta nutuala. ");
INSERT INTO nrz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Deasi 'ana'i kauta boutai kataua 'eva vinao kauta mai abi'avaea kauta, kanaua 'ounai mamoe ia leleta sia deika. ");
INSERT INTO nrz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Lau 'eva nutuala, lau e'uai dedododo de'asi kauta boutai 'eva bemauli. Ia 'eva beda'adodo mai bela'asi iani bedavali. ");
INSERT INTO nrz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Vinao kauna 'eva bevinaomo, beakuakumo mai bevasi'avanalamo 'ounai easi. Lau asi 'eva mamoe mauli beabia mai mauli nama'ina itoina beabia. ");
INSERT INTO nrz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Lau 'eva mamoe i'imata kauna mediana, mamoe i'imata kauna mediana 'eva ena mauli ene'ea divo ena mamoe daitai. ");
INSERT INTO nrz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tava ekakavu kauna 'eva sia mamoe i'imata kauna umauna, sia mai ena mamoe, kanaua 'ounai 'oveka 'asina e'asi eikala koanai ia mamoe evikanita inoku eveau 'akauma, inoku 'oveka 'asina mamoe ealata 'eva deveau siusiu. ");
INSERT INTO nrz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kau kanaua eveau 'akauma 'olana ia 'eva tava ekakavu kauna maivaka mamoe naota sia e'aku. ");
INSERT INTO nrz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Lau 'eva mamoe i'imata kauna mediana, lau e'u mamoe aikabasita maivaka e'u mamoe vaka lau deikabasi'u. ");
INSERT INTO nrz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Vitaitanai Kama'u lau eikabasi'u maivaka lau Kama'u aikabasia, inoku e'u mauli ane'ea divo e'u mamoe daitai. ");
INSERT INTO nrz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Lau maie'u mamoe edeata vaida 'eva sia ala kanania laloanai demimia, kataua vaka bavuata ba'asi inoku ia vaka lele'u be'ika, ua'i mamoe 'itona beka'onamo mai mamoe i'imata kauna beka'onamo. ");
INSERT INTO nrz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kama'u elalo'au veni'u 'olana lau e'u mauli ane'eia divo, kanaua'i lau batata'u babia 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sia kau ka e'u mauli bebuku vai'u, beia lau sibou e'u ulai e'u mauli ane'eia divo. Lau mai e'u siavu e'u mauli bane'ea divo maivaka mai e'u siavu e'u mauli babia 'udai. Kama'u enai abia luvana 'eva kanaua.” ");
INSERT INTO nrz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Luva katania'i Iuda kauta viloata 'ani e'alama 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kau doutamo dediaka, “Ka'uba si'avana vaika ia nuanai emimia kanaua'i ia 'olana esi'avana. Dava 'ounai ia lelena oi o'ika?” ");
INSERT INTO nrz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Beia vaida dediaka, “Luva katania 'eva sia kau nuanai ka'uba si'avana vaika emimia kauna beluluva luvata. Inoku ka'uba si'avana vaika maka 'ede kauna makana 'ani beva ata?” ");
INSERT INTO nrz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Inoku Ielusalemai Lo'e Ivakabukabuna Naduna bonina eabia, ua 'eva 'elu bonina, ");
INSERT INTO nrz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","inoku Iesu 'eva Lo'e kabukabuna laloanai vaka ka akanai eda'a, vaka kanaua 'eva Solomona ena vaka. ");
INSERT INTO nrz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iuda kauta namata deasi Iesu delavaia kaiukaiu inoku delavuaia dediaka, “Ovalalo to'ato'amai, aida melalanai bo'oumai kave'i? Bema oni Keliso 'eva 'oumai kave'i.” ");
INSERT INTO nrz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Inoku Iesu eta luva evamuea ediaka, “Lau oi 'ani a'oumui, beia oi 'eva sia oabiveni'u. Lau Kama'u vanai vatabulovo vinaulata avavaita davata 'eva lau vali'u dekakava. ");
INSERT INTO nrz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Beia oi sia oabiveni'u 'olana oi 'eva sia lau e'u mamoe. ");
INSERT INTO nrz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","E'u mamoe 'eva lele'u de'ika. Lau aikabasita, maivaka ia lau muli'uai dedada'a. ");
INSERT INTO nrz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Lau mauli keinikeini avenita, ia 'eva sia bebaba maivaka sia kau ka ima'uai bebukuvai'u. ");
INSERT INTO nrz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kama'u mamoe kataua eveni'u kauna 'eva dava boutai ekeinita, sia kau ka Kama'u imanai bebukuvaita. ");
INSERT INTO nrz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Lau mai Kama'u lai laluana 'eva ka'onamo.” ");
INSERT INTO nrz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iuda kauta luva kanania deika melalanai bika'a deabisi ia beaku bala. ");
INSERT INTO nrz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Beia Iesu e'outa ediaka, “Kama'u kevanai vatabulovo vinaulata namata doutamo avaikamui, vinaula katania davana dainai bika'ai oi boaku'u?” ");
INSERT INTO nrz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ia ena luva devamuea dediaka, “Sia vinaula nama'ita ovavai dainai bika'ai lai bakumu, beia Dilava ovasi'avanala dainai, 'olana oni 'eva kau mo beia oni sibomu Dilavai ovaaomu.” ");
INSERT INTO nrz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu eta luva evamuea ediaka, “Emui Talavatu laloanai 'ani deleleia, Dilava ediaka, ‘Oi 'eva dilava.’ ");
INSERT INTO nrz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dilava ena luva easi kevatai kauta e'aeta dilava, inoku Puka kabukabuna luvana kanaua 'eva sia ekaukua. ");
INSERT INTO nrz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dilava evasiavu'u mai esini'u asi kanobatai inoku adiaka, ‘Lau 'eva Dilava Nakuna,’ koanai, dava 'ounai oi odiaka lau Dilava avasi'avanala? ");
INSERT INTO nrz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bema Kama'u ena vinaula sia bavavaia koanai sia oiboabiveni'u. ");
INSERT INTO nrz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Beia Kama'u ena vinaula avavai koanai, bema sia oi oabiveni'u beia vinaula avavai kataua oi boabivenita. Kanaua'i oi boikabasi maivaka ovota oi bo'ovo Kama'u 'eva lau nua'uai maivaka lau 'eva Kama'u nuanai.” ");
INSERT INTO nrz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iuda kauta namata dala dekavu 'udai Iesu belioa. Beia Ia kevatai eda'a ovo. ");
INSERT INTO nrz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iesu Iolidana nutuna ekeinia avekenai emue eda'a makavanai Ioane evaidi'u kabukabu 'abunai ua'i emia, ");
INSERT INTO nrz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","kau doutamo deasi ia kevana inoku dediaka, “Ioane vatabulovo koana sia ka evavaia, ia kau kanania lovana eakuia davata boutai 'eva demomo'ai.” ");
INSERT INTO nrz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Inoku 'abu kanaua'i kau doutamo Iesu deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kau ka vana Lasalo 'eva e'olele, ia 'eva Betani kauna, Malia 'a'ana Maleta ita eta vanua. ");
INSERT INTO nrz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia kanaua eta'u deolo bonana medianai Lovia namana Iesu aena esisita inoku vuinai eukuta lada ateatena, ia lovuna Lasalo 'eva e'olele kanaua. ");
INSERT INTO nrz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kanaua 'ounai lovuna luana luva desinia eda'a Iesu kevana dediaka, “Lovia namana e, olalo'au venia kauna 'eva e'olele.” ");
INSERT INTO nrz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesu vali kanania eika koanai ediaka, “'Olele kanania 'eva sia Lasalo bevabala vaika, kanania epulu 'eva Dilava ena nuavi bevala'asia, kanaua'i Dilava Nakuna nuavi beabia.” ");
INSERT INTO nrz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu 'eva Maleta kadina Malia ita maivaka lovuta Lasalo elalo'au venita. ");
INSERT INTO nrz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Iesu Lasalo ena 'olele valina eika koanai, ia boni lua vaka ua'i emia 'abunai emia. ");
INSERT INTO nrz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Inoku Iesu ibanona kauta e'outa ediaka, “Ita ekamue ekada'a Iudea.” ");
INSERT INTO nrz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ibanona kauta dediaka, “Vaikabasi kaumu e, ualavi mo Iuda kauta namata deula bika'ai beaku bamu, beia oni emu lalovai 'eva bomumue boda'a ua'i?” ");
INSERT INTO nrz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu enu'ovi ediaka, “Melala ka'onamo laloanai melala koana 'eva 'ouka lua (12), kau ka laniai edada'a kauna 'eva sia betatai, 'olana ia kanobata ena 'ailala eikala. ");
INSERT INTO nrz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Beia boniai bedada'a kauna 'eva betatai, 'olana ia nuanai 'eva 'ailala asi'i.” ");
INSERT INTO nrz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu luva kanaua eluvaia mulinai e'outa ediaka, “Eta kau Lasalo 'eva 'ani emuinai tabu. Beia lau bada'a ua'i bakuia.” ");
INSERT INTO nrz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ibanona kauta dediaka, “Lovia namana e, ia e'olele emuinai koanai ia 'ani benama'ina 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu 'eva Lasalo ena ba lovana eakuia, beia ibanona kauta delalovaia ia 'eva emuinai tabu. ");
INSERT INTO nrz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kanaua 'ounai Iesu e'outa kave'i ediaka, “Lasalo 'ani eba, ");
INSERT INTO nrz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","oi 'oumuiai lau ua'i asi'i 'eva lalo'u denanama, 'olana oi botata'u lau oi boabiveni'u. Ita kada'a ia kevana.” ");
INSERT INTO nrz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Inoku Toma (de'aea vi'apala) banona vaida kataua e'outa ediaka, “Ita vaka kada'a, ia ita ekaba ka'ona.” ");
INSERT INTO nrz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu ua'i ela'asi koanai de'ouia Lasalo 'ani eba kauanina boni vani mitava laloanai 'ani emia. ");
INSERT INTO nrz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ielusalema mai Betani viloata 'eva sia edau'a itani maela lua boina. ");
INSERT INTO nrz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Maleta mai Malia lovuta Lasalo eba 'ounai Iuda kauta doutamo deasi ia kevatai nuata bevakula'ilata. ");
INSERT INTO nrz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maleta Iesu easi valina eika koanai, ia ela'asi eda'a ita bevidavali, beia Malia 'eva lumai emia. ");
INSERT INTO nrz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maleta Iesu e'ouia ediaka, “Lovia namana e, oni nia'i bomamia koanai lovu'u sia bemaba. ");
INSERT INTO nrz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Beia lau aikabasi vali'u Dilava kevanai dava bonoinoi vaia davana ia betata'u bevenimu.” ");
INSERT INTO nrz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu Maleta e'ouia ediaka, “Oni lovumu 'eva beko'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maleta enu'ovi ediaka, “Lau aikabasi melala to'onai ba kauta boutai beko'isi 'udai koanai ia vaka beko'isi 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu Maleta e'ouia ediaka, “Lau 'eva ko'isi 'udai maivaka mauli. Lau eabiveni'u kauna 'eva bemaba, beia bemauli. ");
INSERT INTO nrz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Inoku demauli mai deabiveni'u kauta boutai 'eva sia beba kovo beia bemauli keinikeini. Oni luva kanania oabivenia, una?” ");
INSERT INTO nrz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maleta enu'ovi ediaka, “'O, Lovia namana, lau abivenimu, oni 'eva Keliso, Dilava Nakuna be'asi kanobatai kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Luva kanania eluvaia mulinai emue eda'a kadina Malia e'aeia 'aba'abai e'ouia ediaka, “Vaikabasi kauna 'ani easi oni lavuaimu elavuai.” ");
INSERT INTO nrz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia luva kanaua eika koanai alimo eko'isi eda'a Iesu kevana. ");
INSERT INTO nrz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Melala kanaua'i Iesu 'eva asido'o vanuai eda'adodo, ia ua'i Maleta ita devidavali 'abunai emia do'o. ");
INSERT INTO nrz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iuda kauta kataua Malia ita lumai demia nuana devakula'ilala kauta ia deikaia alimo eko'isi ela'asi koanai mulinai deda'a, delalovaia ia edada'a mitavai ua'i bekakani. ");
INSERT INTO nrz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia eda'a Iesu emia 'abunai ela'asi inoku eikaia koanai komolonai aena 'olanai epakadivo 'eva ediaka, “Lovia namana e, oni nia'i bomamia koanai lovu'u 'eva sia bemaba.” ");
INSERT INTO nrz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu Malia ekani eikaia mai Iuda kauta kataua ia ita deasi kauta vaka dekani eikata koanai nuana evilalo mai emanomano. ");
INSERT INTO nrz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ia elavuaita ediaka, “A'i oi okoleia?” Ia ena luva devamuea dediaka, “Lovia namana e, mai ikala.” ");
INSERT INTO nrz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Inoku Iesu ekani. ");
INSERT INTO nrz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iuda kauta dediaka, “Oikaia a elalo'au venia koma.” ");
INSERT INTO nrz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Beia ia vaida dediaka, “Kau kanania maka 'ede kauna makana evanama'inata inoku ia bemata'u Lasalo bai bema'alavuia sia bemaba.” ");
INSERT INTO nrz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu nuana evilalo si'asi'a. Inoku eda'a mitava, mitava kanaua 'eva bika'a va'alana ka inoku bika'a namana kai nutualana devaakububua. ");
INSERT INTO nrz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu ediaka, “Bika'a oabia tau!” Beia ba kauna lovuna Maleta ediaka, “Lovia namana e, ia 'ani epeda, 'olana ia vali'u 'ani boni ivavanina ikolena.” ");
INSERT INTO nrz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Inoku Iesu ia e'ouia ediaka, “Lau 'ani a'oumu, oni boabiveni'u koanai Dilava ena nuavi oi boikala.” ");
INSERT INTO nrz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kanaua 'ounai ia deta'u bika'a deabia tau. Inoku Iesu e'a'a dae ediaka, “Kama'u e, lau avanama'inamu 'olana lele'u 'ani o'ika. ");
INSERT INTO nrz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Lau aikabasi oni 'eva melala bounai lele'u o'ika, beia nia'i kau delalava daitai lau luva kanania aluvala. Ia beabiveni 'eva oni ota'u lau osini'u.” ");
INSERT INTO nrz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu luva kanania eluvaia mulinai e'ae 'unu'unu ediaka, “Lasalo e, la'asi mai!” ");
INSERT INTO nrz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Inoku ba kauna ela'asi easi, imana mai aena 'eva mitava tubu'anai de'umita maivaka vailana tubu'a kai de'umia. Iesu e'outa ediaka, “Mitava tubu'ata oabita ovo inoku ovikania eda'a.” ");
INSERT INTO nrz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iuda kauta doutamo deasi Malia deikaia kauta 'eva Iesu koa kanaua evavaia deikaia inoku deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Beia vaida deda'a Palisea kauta kevatai inoku de'outa Iesu dava evavaia. ");
INSERT INTO nrz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Inoku kabukabu kauta namata mai Palisea kauta valuva namana de'imala kauta de'aeta ita dedo'u, “Kau kanaua 'ani vatabulovo koata doutamo evavaita 'eva vali'u ita dava ekavavaia. ");
INSERT INTO nrz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ita ia ekavikania koa katania bevavai 'udai vavai 'udai koanai kau boutai ia beabivenia, inoku Loma kauta be'asi eta lo'e kabukabuna mai eta kanobata bebuku vaita.” ");
INSERT INTO nrz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Inoku ia banota ka vana Kaiapa, vikau kanaua laloanai ia 'eva kabukabu kauta namata 'olatai kauna ka eko'isi ediaka, “Oi sia dava ka oi oikabasia. ");
INSERT INTO nrz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sia oi olalovaia kau ka'onamo bemaba kau daitai 'eva enama'ina vakaia kanobata itoina besi'avana.” ");
INSERT INTO nrz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sia ia sibona ena lalovai ai luva kanania eluvaia, beia vikau kanaua laloanai ia 'eva kabukabu kauta 'olatai kauna dainai, ena enoleai kanaua eluva koma Iesu bebaba Iuda kauta daitai, ");
INSERT INTO nrz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","sia Iuda kauta mo sibota daitai, beia Dilava nakuna 'abu edeata edeatai demimia kauta vaka bevado'uta mai bevaka'onamota. ");
INSERT INTO nrz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Melala kanaua'i eabilamala eda'a laloanai Iuda kauta namata 'eva delovaku Iesu beaku bala. ");
INSERT INTO nrz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kanaua 'ounai Iesu Iuda kauta viloatai sia evaila. Ia eda'a tau eda'a kano'akuna kevanai vanua ka vana Epalaima, ua'i ibanona kauta ita demia. ");
INSERT INTO nrz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iuda kauta eta La'au keini naduna 'ani ekevai laloanai Iuda kauta doutamo vanua edeata edeatai dela'asi deda'a Ielusalemai beva'olu kave'i bekabukabu makava vakaia nadu bepupulu. ");
INSERT INTO nrz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ia Iesu dekavuia inoku lo'e kabukabuna laloanai delava sibota viloatai devilavuai viveni dediaka, “Oi dava olalovaia? Ia nadu dainai 'ani beasi 'o asi'i?” ");
INSERT INTO nrz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Beia kabukabu kauta namata mai Palisea kauta luva deveni, kau ka Iesu ena mia 'abuna eikabasia koanai ia bevaikabasita, ia betata'u belioa. ");
INSERT INTO nrz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Melala kalakoi vailai demia La'au keini naduna bepupulu 'eva Iesu eda'a Betani, bai evako'isia kauna Lasalo ena vanua. ");
INSERT INTO nrz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iesu iabidaena koana lavilavi ianina ka deva'olua, inoku Maleta 'eva ia da'alata eabi, ia Lasalo mai kau vaida 'eva Iesu ita aniani 'abunai demia. ");
INSERT INTO nrz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Inoku Malia eta'u deolo kavapuna ka'onamo tavana namavaikana deolona eabia Iesu aena palapalatai esisia inoku vuinai Iesu aena palapalata eukuta lada. Deolo bonana mediana kanaua luma laloana itoinai ekaolia. ");
INSERT INTO nrz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iesu ibanona kauna ka Iuda Isakaliote kauna muliai Iesu venina beveveni mai kouna bekokou kauna ediaka, ");
INSERT INTO nrz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dava 'ounai deolo kanania moni namavaikanai sia etavatava vaia inoku monina ta'ovala kauta bemavenita.” ");
INSERT INTO nrz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ia sia ta'ovala kauta elalovaita 'ounai luva kanania eluvaia, beia ia 'eva vinao kauna, moni iko'unina e'imala kauna, deudala 'ovu davana 'eva eabia ia sibona eduluvaia. ");
INSERT INTO nrz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Inoku Iesu ediaka, “Ovikania 'avaea, lau ikole'u bonina dainai deolo kanania eva'olua. ");
INSERT INTO nrz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Melala boutai ta'ovala kauta 'eva oi viloamuiai demimia, beia lau 'eva sia melala boutai oi viloamuiai bamimia.” ");
INSERT INTO nrz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iuda kauta mato namavaikana Iesu valina deika ia 'eva 'ani Betani ai, inoku deda'a ua'i. Sia Iesu mo sibona beikala, beia Lasalo bai evako'isia 'udai kauna vaka beikala. ");
INSERT INTO nrz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kanaua 'ounai kabukabu kauta namata delovaku Lasalo vaka beaku bala, ");
INSERT INTO nrz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","'olana Lasalo kevanai koa kanaua epulu 'ounai Iuda kauta doutamo ia devikanita dekeini Iesu deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Elani kau mato namavaikana nadu dainai deasi kauta 'ulu deika Iesu 'eva Ielusalema easi venia. ");
INSERT INTO nrz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kanaua 'ounai ia vakolo uauata deabi dela'asi deda'a Iesu ita bevidavali, inoku devaoi dediaka, “'Osana! Dilava betata'u Lovia namana vanai e'asi kauna bevanama'inala! Dilava betata'u Isalaela eta Lovia 'olana bevanama'inala!” ");
INSERT INTO nrz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu doniki nakuna ka edavalia inoku akanai emia'au. Kanaua 'eva Puka kabukabunai ilelena vitaitana ediaka, ");
INSERT INTO nrz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Siona vanuana namana kaumui e, sia oi bomakau. Oikaia, emui lovia 'olana 'eva doniki nakuna akanai emia'au e'asi.” ");
INSERT INTO nrz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kanaua melalanai ibanona kauta luva katania ovotai sia deovo eda'amo Iesu ena nuavi ai eko'isi 'udai mulinai vakaia ia lovana deakuia luvata deleleta davata mai ia kevanai devavai davata kataua delalota une. ");
INSERT INTO nrz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesu eta'u Lasalo bai evako'isia 'udai deikaia kauta deta'u ia valina dekava odaoda. ");
INSERT INTO nrz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kau doutamo dela'asi deda'a Iesu beikala 'olana ia vatabulovo koana kanaua evavaia valina deika 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kanaua 'ounai Palisea kauta sibota deviluva viveni dediaka, “Oikaia, ita sia dava ka ekavavaia bedaita, kau boutai 'ani ia mulinai dedada'a.” ");
INSERT INTO nrz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nadu kanaua laloanai deda'a Ielusalema Dilava bekukudivo venia kauta kataua viloatai 'eva 'Elene kauta vaka vaida. ");
INSERT INTO nrz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ia deasi Kalileiai Betesaida kauna Pilipo kevana de'ouia dediaka, “Loviamu e, lai a'ula Iesu lai baikala.” ");
INSERT INTO nrz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipo eda'a Andelea e'ouia inoku laluana deda'a Iesu de'ouia. ");
INSERT INTO nrz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu eta luva evamuea ediaka, “Lau Kau Nakuna nuavi namana babia melalana 'ani easi. ");
INSERT INTO nrz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lau oi luva umauna a'oumui, witi keana ka be'ekoasi kanoai inoku sia bebaba koanai ia keana 'eva 'avaeana mo bemimia. Beia ebaba koanai kea doutamo bevapuluta. ");
INSERT INTO nrz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kau ka ena mauli elalo'au venia kauna 'eva ena mauli bevataulea, kanobata kanania'i kau ka ena mauli evaiviivia kauna 'eva ena mauli beabi 'inia beda'amo mauli keinikeini. ");
INSERT INTO nrz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Lau da'ala'u be'abi kauna 'eva muli'uai bedada'a, inoku lau a'i koanai e'u da'alaabi kauna vaka ua'i. Kama'u betata'u lau da'ala'u e'abi kauna bevanama'inala. ");
INSERT INTO nrz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Vali'u lau nua'u 'eva ebavunu si'asi'a inoku luva dava baluvala? Lau badiaka, ‘Kama'u, melala koana kanania laloanai vamauli'u?’ Asi'i. Lau asi 'olana umauna 'eva melala koana kanania'i banana. ");
INSERT INTO nrz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kama'u e, vamu vanuavia.” Inoku vutuvutuai lele ka ediaka, “Lau 'ani avanuavia, maivaka bavanuavia 'udai.” ");
INSERT INTO nrz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kau mato ua'i delava lele kanaua deika koanai dediaka, “E'ulua,” vaida dediaka, “Anelu ka Iesu eluva venia.” ");
INSERT INTO nrz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu e'outa ediaka, “Lele kanania e'asi 'eva oi bevanama'inamui 'ounai, ia sia lau. ");
INSERT INTO nrz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vali'u melala kanania 'eva kanobata bevaluvala melalana, inoku kanobata kanania eloviala kauna Satani vali'u belo'oa asi. ");
INSERT INTO nrz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kanobatai lau beabi'u isi koanai kau boutai bavelita be'asi keva'u.” ");
INSERT INTO nrz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ia luva kanania eluvaia 'eva ia a beba koma dalana eluva vaia. ");
INSERT INTO nrz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kau mato dediaka, “Talavatuai luva lai aika ediaka Keliso 'eva bemia keinikeini, oi aboina odiaka, ‘Kau Nakuna 'eva beabia isi.’ Kau Nakuna kanania 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Inoku Iesu eta luva evamuea ediaka, “Melala kava'ina mo 'eva 'ailala ita oi bomimia. 'Ailala oi oabia laloanai oda'a, vabuto'o betata'u asi'i ema'alavumui makauna. Vabuto'o laloanai edada'a kauna 'eva sia eikabasi ia a eda'ala. ");
INSERT INTO nrz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","'Ailala oi oabia do'o laloanai oabivenia, kanaua'i oi 'eva 'ailala nakunai oi bo'ao.” Iesu eluva koa mulinai kevatai eda'a ovo eda'a epode. ");
INSERT INTO nrz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu vatabulovo koata doutamo vailatai evavai, beia ia sia deabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kanania 'eva Isaia enolea kauna ena luva ivamomo'aina kanania eluva koma, “Lovia namana e, dai emai luva lai aluvaia luvana eabivenia, maivaka Lovia namana imana siavuna 'eva dai kevanai bevala'asia?” ");
INSERT INTO nrz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kanaua 'ounai kau mato beabiveni 'eva sia edaia, 'olana Isaia vaka eluva vitaitanai ediaka, ");
INSERT INTO nrz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dilava eta'u makata eva'edeta, mai nuata e'alavu, asi'i makatai dava demaika nuatai demalalovai 'eva demalalo'udai, inoku amavanama'inata makauna, Dilava kanaua eluva koma.” ");
INSERT INTO nrz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia luva kanania eluvaia 'olana Iesu ena nuavi eikaia inoku eluvavaia. ");
INSERT INTO nrz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Melala kanaua'i Iuda kauta namata doutamo Iesu deabivenia. Beia Palisea kauta makauta demakau 'ounai eta abiveni sia de'ou dae, 'olana Iuda kauta eta lo'eai asi'i demavala'asita makauna, ");
INSERT INTO nrz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","'olana ia kau etai akuabalai deula venia vaika vakaia Dilava ena akuabalai. ");
INSERT INTO nrz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Inoku Iesu evaoi 'unu'unu ediaka, “Kau ka lau eabiveni'u kauna 'eva sia lau mo eabiveni'u beia esini'u kauna kanaua vaka eabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kau ka lau eika'u kauna 'eva lau esini'u kauna kanaua vaka eikala. ");
INSERT INTO nrz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Lau 'eva 'ailala boina asi kanobatai, kanaua ounai lau deabiveni'u kauta boutai 'eva sia vabuto'o laloanai bemimia. ");
INSERT INTO nrz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kau ka e'u luva 'uluta e'ika beia sia eabidaeta kauna 'eva lau ia sia bavaluvala. Lau sia kanobata bavaluvala dainai asi beia kanobata bavamaulia. ");
INSERT INTO nrz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kau ka lau sia e'ula veni'u mai e'u luva sia eabita dae kauna 'eva mai ivaluvana kauna ka emimia, melala to'onai aluvavai luvata kataua betata'u ia bevaluvala. ");
INSERT INTO nrz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","'Olana sia lau sibo'u e'u ulai aluluva, beia Kama'u esini'u kauna etata'u e'ou'u luva davana baluvala maivaka aboina baluvala. ");
INSERT INTO nrz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Inoku lau aikabasi ia ena luva pasisi 'eva bevada'amui mauli keinikeini 'abuna, kanaua 'ounai aluvavai luvata kataua 'eva Kama'u e'ou'u luvata vitaitatai aluvavaita.” ");
INSERT INTO nrz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Belani 'eva La'au keini naduna, Iesu eikabasi kanobata kanania bevikania beda'a Kamana kevana melalana 'ani edaia. Ia melala bounai kanobatai ia ena kau kauta elalo'au venita, vali'u ia ena lalo'au itoinai bevaikata beda'amo bebaba. ");
INSERT INTO nrz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lavilavi deaniani laloanai, diabolo 'ani Simona nakuna Iuda Isakaliote kauna nuana eania Iesu venina beveveni mai kouna bekokou. ");
INSERT INTO nrz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu eikabasi 'eva Kamana eta'u dava boutai ia ena siavu venunai e'uleta, inoku ia 'eva Dilava enai easi maivaka bemumue beda'a Dilava kevana. ");
INSERT INTO nrz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Inoku Iesu aniani 'abunai eko'isi, ena ivadodo tubu'ana akanai davana eabia ovo ene'eia divo inoku ikulada tubu'ana eabia kukuanai elioia. ");
INSERT INTO nrz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Vei nauai elaia uda inoku ibanona kauta aeta edeini makava, ikulada tubu'ana kukuanai elioia tubu'anai aeta eukuta lada. ");
INSERT INTO nrz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iesu easi Simona Petelo kevanai ela'asi koanai Petelo ediaka, “Lovia namana e, oni lau ae'u bodeinita, una?” ");
INSERT INTO nrz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu Petelo ena luva evamuea ediaka, “Vali'u lau dava avavaia davana oni ovonai sia o'ovo, beia beda'a muliai 'eva ovonai 'ani bovo.” ");
INSERT INTO nrz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petelo ediaka, “Asi'i, oni lau ae'u sia bodeini kovo.” Iesu enu'ovi ediaka, “Aemu sia badeinita koanai oni 'eva sia lau ibano'u kaumu.” ");
INSERT INTO nrz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Petelo ia e'ouia ediaka, “Lovia namana e, sia ae'u mo sibota, beia ima'u mai 'ola'u vaka bodeinita.” ");
INSERT INTO nrz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu enu'ovi ediaka, “Kau 'ani eidi'u kauna 'eva kauna itoina 'ani emakamaka inoku aena mo bedeinita. Oi 'eva 'ani oi omakamaka, beia oi ka 'eva asido'o omakamaka.” ");
INSERT INTO nrz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","'Olana Iesu eikabasi dai 'eva ia venina beveveni mai kouna bekokou, kanaua 'ounai ia ediaka, “Beia oi ka 'eva asido'o omakamaka.” ");
INSERT INTO nrz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aeta edeini koa mulinai ena ivadodo tubu'ana eabia evadodoa 'udai. Emue 'abunai emiadivo. Ia eta'u elavuaita ediaka, “Lau dava kevamuiai avavaia davana anina oi oikabasia? ");
INSERT INTO nrz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oi lau o'ae'u emui vaikabasi kau'u mai Lovia namana, kanaua oi oluva koma 'eva ekomolo, 'olana lau 'eva kanaua boi'u. ");
INSERT INTO nrz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Inoku lau emui Lovia namana mai emui vaikabasi kau'u 'ani aemui adeinita koanai oi vaka banomui ka ka aeta oi bodeinita. ");
INSERT INTO nrz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Lau oi kevamuiai koa kanania avavaia oi oikala koana vitaitanai mo oi bovavaia. ");
INSERT INTO nrz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Lau oi luva umauna a'oumui, da'alaabi kauna 'eva ena 'ola kauna sia ekeinia, maivaka veauneke kauna 'eva esinia kauna sia ekeinia. ");
INSERT INTO nrz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Vali'u avavai koata katania anita 'ani oi oikabasita, inoku oi bovavaita koanai Dilava oi bevanama'inamui. ");
INSERT INTO nrz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Lau sia oi boumuiai lovamui a'aku, lau adilata kauta kataua 'eva aikabasita. Beia Puka kabukabunai deleleia luvana kanaua 'eva bemomo'aia, ‘Laluana palaoa lai ani ka'ona kauna eta'u lau evaiviivi'u.’ ");
INSERT INTO nrz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Vali'u dava kanania asido'o epupulu laloanai lau oi a'oumui vaika, kanaua 'ounai bepupulu koanai oi boabiveni lau 'eva lau. ");
INSERT INTO nrz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Lau oi luva umauna a'oumui, kau ka lau asinia kauna eabia dae kauna 'eva lau eabi'u dae, mai kau ka lau eabi'u dae kauna 'eva esini'u kauna vaka eabia dae.” ");
INSERT INTO nrz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu luva kanania eluvaia mulinai ia nuana ebavunu inoku eluva asi ediaka, “Lau oi luva umauna mo a'oumui. Oi kaumui ka 'eva lau veni'u beveveni mai kou'u bekokou.” ");
INSERT INTO nrz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kanaua 'ounai ibanona kauta sibota deviika viveni sia deikabasi ia 'eva dai lovana eakuia. ");
INSERT INTO nrz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ia ibanona kauta ka Iesu ena lalo'au kauna Iesu kevanai emiadivo. ");
INSERT INTO nrz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simona Petelo makana evailu ia kevanai inoku ediaka, ‘Lavuaia ia dai lovana eakua.’ ");
INSERT INTO nrz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iesu kevanai emiadivo kauna kanaua eilu keke eda'a Iesu kevana elavuaia ediaka, “Lovia namana e, oni dai lovana oakua?” ");
INSERT INTO nrz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu ia ena luva evamuea ediaka, “Palaoa kena nau laloanai baudala uku bavenia kauna 'eva kanaua.” Inoku Iesu eta'u palaoa eabia nau laloanai eudaia uku inoku Iuda evenia, ia 'eva Simona nakuna Isakaliote kauna. ");
INSERT INTO nrz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Komolonai Iuda palaoa eabia eania 'eva Satani ia nuanai edodo. Inoku Iesu Iuda e'ouia ediaka, “Dava bovavaia davana 'eva vavaia kaokao.” ");
INSERT INTO nrz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Aniani 'abunai demia kauta sia deikabasi Iesu luva kanaua dava 'ounai ia e'ouia. ");
INSERT INTO nrz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iuda 'eva moni iko'unina e'imaia 'ounai vaida delalovaia Iesu ia e'ouia nadu dainai dava deula venita davata betatava, 'o dava vaida ta'ovala kauta bevenita. ");
INSERT INTO nrz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iuda palaoa kena eabia eania mulinai, komolonai eko'isi ela'asi, 'eva 'ani eboni. ");
INSERT INTO nrz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iuda ela'asi eda'a koanai, Iesu ediaka, “Vali'u 'eva lau Kau Nakuna e'u nuavi bela'asi mai lau e'uai Dilava ena nuavi vaka bela'asi. ");
INSERT INTO nrz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Inoku lau e'uai Dilava ena nuavi bela'asi koanai Dilava vaka lau Kau Nakuna e'u nuavi bevala'asia, inoku komolonai mo bevavaia. ");
INSERT INTO nrz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Naku'u e, lau 'eva melala kava'ina mo oi ita ekamia. Inoku oi lau bokavu'u. Iuda kauta a'outa vitaitanai vali'u oi a'oumui, lau badada'a 'abuna 'eva sia 'ani oi boda'a. ");
INSERT INTO nrz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lau oi talavatu luvana makamakana avenimui, oi bovilalo'au viveni. Lau oi alalo'au venimui vitaitanai oi vaka oi bovilalo'au viveni. ");
INSERT INTO nrz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Oi bovilalo'au viveni koanai, kau boutai beikabasi oi 'eva lau ibano'u kaumui.” ");
INSERT INTO nrz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Petelo ia elavuaia ediaka, “Lovia namana e, a boda'ala?” Iesu ediaka, “Vali'u lau adada'a 'abuna oni lau muli'uai sia 'ani boasi, beia muliai 'eva muli'uai bo'asi.” ");
INSERT INTO nrz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petelo elavuai ediaka, “Lovia namana e, vali'u mulimuai dava 'ounai sia 'ani bavasi? Oni daimuai Lau e'u mauli bane'ea divo.” ");
INSERT INTO nrz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Inoku Iesu ia ena luva evamuea ediaka, “Lau dai'uai oni emu mauli bone'ea divo dokadoka, una? Lau oni luva umauna a'oumu, o'oloko asido'o be'alala laloanai oni melala koi lau bo'ou'u avuavu.” ");
INSERT INTO nrz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu ediaka, “Nuamui sia oi bovabavunu. Dilava oi boabivenia, lau vaka oi boabiveni'u. ");
INSERT INTO nrz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kama'u ena lumai 'eva mia 'abuta doutamo, bema asi'i koanai lau oi 'ani bama'oumui. Lau bada'a oi emui 'abu ka bava'olua. ");
INSERT INTO nrz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lau bada'a oi emui 'abu ka bava'olua, mulinai bamumue ba'asi bavuamui ekada'a lau a'i bamimia 'eva oi vaka ua'i lau ita ekamia. ");
INSERT INTO nrz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lau badada'a 'abuna dalana 'eva oi 'ani oikabasia.” ");
INSERT INTO nrz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma Iesu e'ouia ediaka, “Lovia namana e, lai sia aikabasi oni 'abu dava boda'ala, inoku dalana 'eva a lai baikabasia koma?” ");
INSERT INTO nrz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu enu'ovi ediaka, “Dala 'eva lau, luva umauna 'eva lau, mai mauli vaka lau. Kamata kevana beda'ala kauta boutai eta dala 'eva lau. ");
INSERT INTO nrz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Oi lau bomaikabasi'u dokadoka koanai, Kama'u vaka oi bomaikabasia, vali'u vailata beda'ala laloanai ia 'ani oi oikabasia maivaka 'ani oi oikaia.” ");
INSERT INTO nrz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipo Iesu e'ouia ediaka, “Lovia namana e, Kamata vaikamai kanaua'i 'eva emai ula bounai bedaia.” ");
INSERT INTO nrz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu enu'ovi ediaka, “Pilipo e, lau oi ita 'ani kamia dau'adau'a, beia oni 'eva lau sia oikabasi'u, una? Kau ka lau eika'u kauna 'eva Kama'u 'ani eikaia, oni aboina odiaka, Kamata vaikamai? ");
INSERT INTO nrz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Lau 'eva Kama'u nuanai mai Kama'u 'eva lau nua'uai kanaua 'eva sia oabivenia? Aluva venimui luvata katania 'eva sia lau sibo'u e'u ulai aluluva, nia 'eva Kama'u lau nua'uai emimia kauna ena vinaula evavaita. ");
INSERT INTO nrz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lau badiaka lau 'eva Kama'u nuanai mai Kama'u 'eva lau nua'uai koanai oi boabiveni'u, asi'i koanai avavaita vinaulata 'outai oabiveni'u. ");
INSERT INTO nrz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Lau oi luva umauna mo a'oumui, kau ka lau eabiveni'u kauna 'eva avavaita vinaulata kataua ia vaka bevavai. Mune'e vinaula namata umauta vaka bevavai, 'olana lau adada'a Kama'u kevana. ");
INSERT INTO nrz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Inoku lau va'uai oi bonoinoi vai davata boutai bavavaita. Kanaua'i Kama'u ena nuavi 'eva bela'asi Nakuna dainai. ");
INSERT INTO nrz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Lau va'uai dava ka oi bonoinoi vaia 'eva lau batata'u bavavaia. ");
INSERT INTO nrz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Bema oi lau bolalo'au veni'u koanai e'u talavatu luvata daitai oi bodadai. ");
INSERT INTO nrz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lau batata'u Kama'u banoia inoku Vidulu idumena ka bevenimui, ia 'eva oi ita bemia keinikeini. ");
INSERT INTO nrz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ia 'eva luva umauna Idumena Kabukabuna, kanobata kauta 'eva sia 'ani beabiadae 'olana sia deikaia mai sia deikabasia, beia oi 'eva ia oi oikabasia 'olana ia ita oi omimia mai oi nuamuiai bemimia. ");
INSERT INTO nrz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Lau sia bavikanimui 'avaea itani melo sinana kamana asi'i melona boina, lau 'ani bamue basi kevamui. ");
INSERT INTO nrz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Melala kava'inamo laloanai kanobata kauta 'eva lau sia beika'u 'udai, beia oi 'eva lau oi boika'u, 'olana lau amauli 'ounai oi vaka bomauli. ");
INSERT INTO nrz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Melala kanaua be'asi laloanai oi bolaloune lau 'eva Kama'u nuanai, oi 'eva lau nua'uai, maivaka lau 'eva oi nuamuiai. ");
INSERT INTO nrz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kau ka lau e'u talavatu luvata eabita dae mai daitai edadai kauna 'eva lau elalo'au veni'u, lau elalo'au veni'u kauna 'eva Kama'u betata'u ia belalo'au venia. Inoku lau vaka ia balalo'au venia, mai ia kevanai sibo'u bavala'asi'u.” ");
INSERT INTO nrz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iuda beia sia Isakaliote kauna, Iuda edeana ka Iesu elavuaia ediaka, “Lovia namana e, lai mo kevamaiai dava 'ounai bovala'asimu beia kanobata kauta kevatai 'eva sia bovala'asimu?” ");
INSERT INTO nrz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu Iuda ena luva evamuea ediaka, “Kau ka lau elalo'au veni'u kauna 'eva e'u vaikabasi luvata daitai bedadai, Kama'u betata'u ia belalo'au venia, maivaka lau Kama'u ita lai ba'asi kevanai ita lai bamimia. ");
INSERT INTO nrz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kau ka lau sia elalo'au veni'u kauna 'eva e'u vaikabasi luvata daitai sia edadai. Luva 'uluta oi o'ika luvata katania 'eva sia lau sibo'u e'u luva beia Kama'u esini'u kauna ena luva. ");
INSERT INTO nrz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Lau oi ita kamimia do'o laloanai dava katania 'ani a'oumui. ");
INSERT INTO nrz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Beia Vidulu Idumena Kabukabuna, lau va'uai Kama'u besinia kauna betata'u dava boutai bevaikabasimui, mai a'oumui luvata boutai bevalalomui une. ");
INSERT INTO nrz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Vaka'ona oi kevamuiai avikania. Lau e'u vaka'ona oi avenimui, vaka'onana 'eva sia kanobata eveveni boina. Nuamui sia oi bovabavunuta mai sia oi bomakau. ");
INSERT INTO nrz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aluluva lele'u 'ani oi oika, Lau 'ani bavikanimui badada'a inoku 'ani bamue'udai basi kevamui. Oi lau olalo'au veni'u koanai, lau adada'a Kama'u kevana 'eva lalomui bemanama 'olana ia 'eva lau ekeini'u vaika. ");
INSERT INTO nrz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lau dava katania vali'u 'ani avaikabasimui makava vakaia muliai bepupulu, kanaua 'ounai depupulu koanai oi 'ani oabiveni'u. ");
INSERT INTO nrz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Lau oi ita sia ekaluvaluva dau'a 'olana kanobata kanania eloviala kauna 'ani e'asi. Ia lau keva'uai ena siavu asi'i, ");
INSERT INTO nrz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","beia kanobata beikabasi, lau 'eva Kama'u alalo'au venia mai Kama'u eluva veni'u davata vitaitatai avavaia. Oko'isi kada'a.” ");
INSERT INTO nrz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu ediaka, “Lau 'eva vine auna umauna, mai Kama'u 'eva vine kulana i'imana kauna. ");
INSERT INTO nrz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ia etata'u lau kau'uai sia devuvua le'eta boutai 'eva ekalata ovo inoku devuvua le'eta boutai 'eva eloleta bemakamaka kanaua'i ia vuata doutamo bevuvua. ");
INSERT INTO nrz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lau oi a'oumui luvata 'outai 'ani oi omakamaka. ");
INSERT INTO nrz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Oi lau nua'uai oi bomimia, inoku lau vaka oi nuamuiai bamimia. Sia le'e ka sibona 'ani bevua 'avaea, le'e 'eva vine auna akanai belava 'au kave'i 'eva bevuvua. Kanaua vitaitanai mo oi lau kau'uai sia oi bolava 'au kave'i 'eva vuavuamui sia bepupulu. ");
INSERT INTO nrz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Lau 'eva vine auna oi 'eva le'ena. Bema kau ka lau nua'uai emimia, mai lau ia nuanai amimia kauna 'eva vuana doutamo bevapuluta, oi lau bovikani'u koanai sia dava ka 'ani oi bovavaia bedaia. ");
INSERT INTO nrz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kau ka lau nua'uai sia bemimia koanai, ia 'eva vitaitana au le'ena deitoa 'au inoku e'ibu boina. Au le'eta kataua boita 'eva devisita, 'alova laloanai bekapota dodo inoku de'ani. ");
INSERT INTO nrz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Oi lau nua'uai oi bomimia mai e'u luva oi nuamuiai bemimia koanai oi oulavai davata boutai oi bonoinoivai 'eva bevenimui. ");
INSERT INTO nrz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Oi vuavuamui bedoutamo lau ibano'u kaumui ai oi bo'ao koanai Kama'u ena nuavi bela'asi. ");
INSERT INTO nrz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kama'u lau elalo'au veni'u vitaitanai lau vaka oi alalo'au venimui. E'u lalo'au laloanai oi bomimia. ");
INSERT INTO nrz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Lau Kama'u ena talavatu luvata daitai adadai 'ounai ena lalo'au laloanai amimia, vitaitanai oi e'u talavatu luvata daitai oi bodadai koanai, oi vaka lau e'u lalo'au laloanai oi bomimia. ");
INSERT INTO nrz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Lau luva kanania 'ani a'oumui kanaua 'ounai e'u lalonama 'eva oi nuamuiai bemimia, kanaua'i emui lalonama 'eva benama vaika. ");
INSERT INTO nrz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lau e'u talavatu luvana 'eva kanania. Lau oi alalo'au venimui vitaitanai banomui ka ka oi bolalo'au venita. ");
INSERT INTO nrz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kau ka ena lalo'au namavaikana ena kau kevatai kauna 'eva ena mauli beveveni ia daitai. ");
INSERT INTO nrz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lau a'oumui davana oi bovavaia koanai, oi 'eva lau e'u kau. ");
INSERT INTO nrz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Vali'u vailata eda'ala laloanai lau sia ba'aemui 'udai da'alaabi kaumui, 'olana da'alaabi kauna 'eva sia eikabasi ia ena 'ola kauna dava evavaia. Beia lau oi ba'aemui e'u kau, 'olana Kama'u enai aikabasita davata boutai 'ani avaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Oi lau sia oi odila'u beia lau oi adilamui mai abimui isi oi bodada'a vuavuamui oi bovapulu, vuavua kataua bemia keinikeini. Inoku lau va'uai oi bonoinoi vaita davata Kama'u betata'u bevenimui. ");
INSERT INTO nrz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","E'u talavatu luvana 'eva kanania. Banomui ka ka oi bolalo'au venita. ");
INSERT INTO nrz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kanobata kauta bevaiviivimui koanai, oi boikabasi 'eva ia lau devaiviivi'u makava. ");
INSERT INTO nrz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Oi kanobata enai oi bo'ao koanai, ia betata'u oi belalo'au venimui vitaitana ia ena umauna. Beia oi 'eva sia kanobata ena. Lau oi kanobatai adilamui kanaua 'ounai kanobata etata'u oi evaiviivimui. ");
INSERT INTO nrz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","A'oumui luvata oi bolalovai'inita, da'alaabi kauna 'eva ena 'ola kauna sia ekeinia. Lau devaanaana'u koanai, oi vaka bevaanaanamui. Lau e'u luva daitai bemadai koanai oi vaka emui luva daitai bemadai. ");
INSERT INTO nrz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Oi 'eva lau e'u 'ounai koakoa katania kevamuiai bevavaita, 'olana esini'u kauna sia deikabasia. ");
INSERT INTO nrz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Lau sia bama asi bama'outa koanai ia si'avanai sia bema va'eva. Beia vali'u ia eta si'avanai be'ou to'ato'a dalana 'ani asi'i. ");
INSERT INTO nrz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kau ka lau evaiviivi'u kauna 'eva Kama'u vaka evaiviivia. ");
INSERT INTO nrz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sia kau ka evavai vinaulata 'eva lau ia viloatai vinaulata sia bama vavai koanai ia si'avanai sia bema va'eva. Beia valiu vatabulovo koata katania 'ani deikata, inoku lau Kama'u itana, lai laluana 'eva devaiviivimai do'o. ");
INSERT INTO nrz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Beia ia kanania devavaia 'eva eta talavatu pukana laloanai deleleia luvana kanaua bevamomo'aia, ‘Sia mai aninai lau devaiviivi'u 'avaea.’ ");
INSERT INTO nrz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Vidulu kauna luva umauna Idumena Kabukabuna, Kama'u kevanai be'asi basinia bevasi kele'emui, inoku ia 'eva lau vali'u bekakava. ");
INSERT INTO nrz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Oi vaka lau vali'u oi bokakava 'olana oi lau ita makavanai kamia easimo vali'u.” ");
INSERT INTO nrz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iesu e'outa ediaka, “Lau oi luva katania boutai 'ani a'oumui 'olana 'eva emui abiveni asi'i emataule makauna. ");
INSERT INTO nrz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Oi 'eva Iuda kauta eta lo'eai bevala'asimui. Luva umauna, melalana be'asi laloanai oi beaku bamui kauta belalovaia ia 'eva Dilava da'alana de'abi. ");
INSERT INTO nrz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ia oi kevamuiai dava katania bevavai 'olana ia 'eva Kama'u 'o lau sia deikabasimai. ");
INSERT INTO nrz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Beia lau oi luva katania 'ani a'oumui 'eva melalana be'asi koanai lau avaikabasimui luvata 'ani oi bolalota une. “Beia 'ana'inai 'eva sia a'oumui 'olana lau oi ita kamia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Beia vali'u lau 'ani adada'a esini'u Dilavana kevana, beia oi sia ka olavuai'u odiaka, ‘Oni a oda'ala?’ ");
INSERT INTO nrz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Olana lau oi luva katania 'ani a'oumui 'ounai nuamui 'eva vilaloai evonu. ");
INSERT INTO nrz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Beia lau oi luva umauna a'oumui, oi emui nama'ina dainai 'eva lau 'ani bada'a tau. 'Olana lau sia badada'a koanai vidulu kauna sia be'asi kele'emui, beia lau badada'a koanai ia basinia be'asi kele'emui. ");
INSERT INTO nrz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ia be'asi koanai, kanobata kauta 'eva si'avana, komolo mai Dilava ena valuva dalana sia deikabasia kauta bevaikabasita. ");
INSERT INTO nrz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ia si'avana lovana beakua 'olana kau lau sia deabiveni'u. ");
INSERT INTO nrz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Komolo lovana beakua 'olana lau adada'a Kama'u kevana inoku oi 'ani lau sia oi boika'u 'udai. ");
INSERT INTO nrz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Valuva lovana beakua 'olana kanobata kanania eloviala kauna 'ani valuva eabia mekau evuala 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Lau oi luva doutamo bama'oumui, beia vali'u oi bo'abi 'eva sia bedaimui. ");
INSERT INTO nrz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Beia luva umauna Idume Kabukabuna be'asi koanai, ia betata'u luva umauta boutai laloatai be'ana'ia vaimui. Ia sia sibona ena lalovaiai beluluva, ia kaianai e'ika davana mo beluva vaia mai bepupulu davana oi bevaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ia betata'u e'u nuavi bevala'asia 'olana lau e'uai luva be'abi inoku oi bevaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kama'u ena dava boutai 'eva lau e'u. Kanaua 'ounai lau adiaka, Idume Kabukabuna lau keva'uai luva be'abi inoku oi bevaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Melala kava'ina mo laloanai oi lau sia boika'u, inoku melala kava'ina mo mulinai 'eva oi lau boika'u.” ");
INSERT INTO nrz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ia ibanona kauta vaida sibota viloatai devilavuai viveni dediaka, “Eluluva ediaka, ‘melala kava'ina mo laloanai oi lau sia boika'u, inoku melala kava'ina mo mulinai 'eva oi lau boika'u,’ ‘'olana lau 'eva Kama'u kevana ada'ala,’ luva kanaua anina 'eva dava?” ");
INSERT INTO nrz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ia sibota devilavuai 'udai 'udai dediaka, “Melala kava'ina mo anina 'eva dava? Ia dava eluvavaia 'eva ita ovonai sia ka'ovo.” ");
INSERT INTO nrz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu eikabasi ibanona kauta deula belavuaia 'ounai e'outa ediaka, “E'u luva kanania, ‘melala kava'ina mo laloanai oi lau sia boika'u inoku melala kava'ina mo mulinai oi lau boika'u’ 'eva oi sibomui viloamuiai oi ovilavuai viveni, una? ");
INSERT INTO nrz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Lau oi luva umauna a'oumui, oi 'eva bokakani mai nuamui bevilalo, laloanai kanobata kauta 'eva belalonama. Oi 'eva nuamui bevilalo, beia emui vilalo 'eva lalonamai be'ao. ");
INSERT INTO nrz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ateate ka melo bevapulua koanai eanana 'olana ena mauli bonina 'ani edaia, beia melo 'ani epulu koanai ena anaana ebolabolala ia lalona denanama 'olana melo ka kanobatai 'ani epulu. ");
INSERT INTO nrz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vitaitana kanaua boina vali'u 'eva emui vilalo melalana, beia lau 'eva oi baikamui 'udai oi bolalonama, inoku sia kau ka emui lalonama kanaua beabia tau. ");
INSERT INTO nrz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Melala kanaua be'asi laloanai oi lau keva'uai sia dava ka oi bolavuai vaia. Lau oi luva umauna a'oumui, lau va'uai dava ka oi bonoinoi vaia 'eva Kama'u betata'u bevenimui. ");
INSERT INTO nrz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lau va'uai sia dava ka oi onoinoi vaia 'ani easimo vali'u. Oi bonoia 'eva bevenimui oi boabia, inoku lalonama nuamui bevavonua. ");
INSERT INTO nrz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Lau a'oumui luvata boutai 'eva luva ivavitaitatai aluvavai, bonina be'asi laloanai lau oi luva ivavitaitatai sia ba'oumui, beia Kama'u valina bakava kave'i. ");
INSERT INTO nrz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Melala kanaua laloanai lau va'uai oi bonoinoi, beia lau sia adiaka 'eva Kama'u banoia oi bedulumui, ");
INSERT INTO nrz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","'olana oi lau olalo'au veni'u maivaka lau Dilava kevanai asi 'eva oi ovamomo'ai'u dainai Kama'u sibona oi elalo'au venimui. ");
INSERT INTO nrz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lau Kama'u kevanai asi kanobatai, vali'u kanobata bavikania bamue'udai badada'a Kama'u kevana.” ");
INSERT INTO nrz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Inoku ibanona kauta de'ouia dediaka, “Vali'u emu luva 'eva e'ailala kave'i, sia 'ana'inai luva ivavitaitatai oluva boina. ");
INSERT INTO nrz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vali'u lai 'eva oni sia balavuaimu 'udai, inoku 'ani lai aikabasi oni 'eva dava boutai oikabasita, kanaua dainai lai abivenimu oni 'eva Dilava enai oasi.” ");
INSERT INTO nrz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu eta luva evamuea ediaka, “Vali'u 'ani oi oabiveni'u, una? ");
INSERT INTO nrz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Beia melalana 'eva e'asi, mai 'ani easi, oi boumuiai oi boda'a odaoda, ka ka oi boda'a emui vanua. Lau sibo'u oi bovikani'u. Beia lau 'eva sia sibo'u, 'olana Kama'u 'eva lau ita. ");
INSERT INTO nrz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lau oi luva katania 'ani a'oumui, oi lau ita ekavaka'onamo ai vaka'ona oi boabia. Kanobata kanania'i oi bevaiviivimui, beia oi bovapasisi, lau 'eva kanobata 'ani akaokaia.” ");
INSERT INTO nrz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu luva kanania eluvaia mulinai, e'a'a dae vutuvutu eikaia inoku emeamea ediaka, “Kama'u e, melalana 'ani edaia nakumu ena nuavi vala'asia, inoku nakumu vaka oni emu nuavi bevala'asia. ");
INSERT INTO nrz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","'Olana oni siavu ovenia kau boutai be'ana'ia vaita, oni ota'u ovenia kauta boutai kataua mauli keinikeini bevenita. ");
INSERT INTO nrz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mauli keinikeini 'eva kanania, kau oni beikabasimu, oni mo sibomu 'eva Dilava umaumu, maivaka Iesu Keliso oni osinia kauna beikabasia. ");
INSERT INTO nrz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Vinaula oveni'u bavavaia vinaulana 'ani avaolea, inoku emu nuavi kanobata akanai 'ani avala'asia. ");
INSERT INTO nrz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kama'u e, kanobata asido'o epulu laloanai lau oni ita kamiavaia nuavina kanaua vali'u vailamuai nuavina e'uai vala'asia. ");
INSERT INTO nrz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kanobatai oveni'u kauta kataua kevatai oni vamu 'ani avaikabasita, ia 'eva oni emu oni ota'u lau oveni'u, inoku ia emu luva dainai dedadai. ");
INSERT INTO nrz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vali'u ia 'ani deikabasi oveni'u davata boutai 'eva oni kevamuai de'asi. ");
INSERT INTO nrz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","'Olana o'ou'u luvata ia avaikabasita 'eva deabitadae, inoku deikabasi lau oni kevamuai asi maivaka devamomo'aia oni lau osini'u. ");
INSERT INTO nrz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Lau ia daitai ameamea. Lau 'eva sia kanobata kauta daitai ameamea, beia oveni'u kauta kataua daitai ameamea 'olana ia 'eva oni emu. ");
INSERT INTO nrz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Lau e'u dava boutai 'eva oni emu, oni emu dava boutai 'eva lau e'u, inoku ia etai e'u nuavi ela'asi. ");
INSERT INTO nrz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Lau 'eva kanobatai sia bamia dau'a, avavasi oni kevamu, beia ia 'eva kanobatai bemimia do'o. Kama'u Kabukabuna e, oni vamu oveni'u vana siavunai botautaavu ia beka'onamo vitaitana ita kavaka'onamo boina. ");
INSERT INTO nrz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lau ia ita lai amia laloanai a'imata kave'i oni vamu oveni'u vana siavunai atautaavu. Sia ka etaule, beia betaule kauna ka'onamo mo etaule, puka kabukabuna luvana bevamomo'aia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lau 'eva vali'u avavasi oni kevamu, beia kanobatai amimia do'o laloanai luva katania aluvavai, ia nuatai e'u lalonama itoina beabia. ");
INSERT INTO nrz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Emu luva 'ani ia avaikabasita inoku kanobata 'eva ia evaiviivita, 'olana lau 'eva sia kanobata ena vitaitanai ia vaka sia kanobata ena. ");
INSERT INTO nrz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","E'u meamea 'eva kanobatai sia boabita tau beia diabolo kevanai botautaavu. ");
INSERT INTO nrz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Lau 'eva sia kanobata ena vitaitanai ia vaka sia kanobata ena. ");
INSERT INTO nrz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Emu luva umaunai bovakabukabuta, emu luva 'eva luva umauna. ");
INSERT INTO nrz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Oni lau osini'u asi kanobata kauta viloatai amia vitaitanai lau ia asinita deda'a kanobata kauta viloatai demimia. ");
INSERT INTO nrz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ia daitai lau sibo'u avakabukabu'u, ia vaka sibota emu luva umaunai bevakabukabuta. ");
INSERT INTO nrz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“E'u meamea 'eva sia ia mo sibota daitai, ia eta luvai lau bevamomo'ai'u kauta kataua vaka daitai ameamea. ");
INSERT INTO nrz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kama'u e, oni 'eva lau nua'uai mai lau 'eva oni nuamuai, vitaitanai ia boutai 'eva nuata beka'onamo. Ia vaka be'asi ita nuatai kanaua'i kanobata kauta beikabasi oni 'eva lau osini'u. ");
INSERT INTO nrz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nuavi oveni'u nuavina 'eva ia avenita, ita nuata eka'onamo vitaitana ia nuata beka'onamo. ");
INSERT INTO nrz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lau 'eva ia nuatai inoku oni 'eva lau nua'uai. Inoku ia nuata beka'onamo kave'i kanobata kauta bevaikabasita oni 'eva lau osini'u, lau olalo'au veni'u vitaitanai ia vaka olalo'au venita. ");
INSERT INTO nrz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Kama'u e, lau a'ula 'ani oveni'u kauta kataua lau a'i 'eva ia vaka ua'i lau ita, inoku ua'i ia e'u nuavi oveni'u nuavina kanaua beikala 'olana kanobata asido'o ovavaia laloanai oni lau olalo'au veni'u 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kama'u komolo kaumu e, kanobata kauta 'eva oni sia deikabasimu, beia lau 'eva oni aikabasimu mai muli'uai dedada'a kauta katania deikabasi oni 'eva lau osini'u. ");
INSERT INTO nrz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lau 'eva oni vamu ia avaikabasita maivaka bavaikabasita basibasi, 'olana emu lalo'au kele'e'uai lalo'auna 'eva ia kevatai vaka bemimia, inoku lau vaka ia nuatai bamimia.” ");
INSERT INTO nrz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu ena meamea evaolea koanai ia ibanona kauta ita Kidilona lavanai dekeini deda'a Olive kulana laloanai deda'adodo. ");
INSERT INTO nrz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Venina eveni mai kouna ekou kauna Iuda vaka 'abu kanaua eikabasia, 'olana melala doutamo Iesu mai ibanona kauta ita 'abu kanaua'i dedo'u. ");
INSERT INTO nrz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kabukabu kauta namata mai Palisea kauta deta'u lo'e kabukabuna de'imala kauta mai kuali kauta 'itona desinita 'eva Iuda eta'u kau kataua evada'ata deda'a, imata mai 'alovata, mai lamepata maivaka kuali davata deabi kula kanaua laloanai deda'adodo. ");
INSERT INTO nrz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu kevanai bepupulu davata boutai 'ani eikabasi, kanaua 'ounai eda'a keke eda'a kevatai elavuaita ediaka, “Oi dai okavua?” ");
INSERT INTO nrz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ia denu'ovi dediaka, “Iesu Nasaleta kauna.” Inoku Iesu ediaka, “Lau kau'u kanania.” Venina eveni mai kouna ekou kauna Iuda vaka ua'i ia ita delava. ");
INSERT INTO nrz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesu ediaka, “Lau kau'u kanania.” koanai ia delava dua de'eko kanoai denodivo. ");
INSERT INTO nrz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu mune'e elavuaita 'udai ediaka, “Oi dai okavua?” Inoku ia deluva 'udai dediaka, “Iesu Nasaleta kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu enu'ovi ediaka, “'Ani a'oumui ‘lau kau'u kanania.’ Oi lau okavu'u koanai, kau katania oi bovikanita bedada'a.” ");
INSERT INTO nrz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kanania epulu 'eva eluvavaia luvana bemomo'ai ediaka, “'Ani oveni'u kauta kataua sia ka avataulea.”. ");
INSERT INTO nrz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simona Petelo 'eva mai ena kuali lepona, inoku evelia asi, kabukabu kauta namata 'olatai kauna ena da'alaabi kauna kaiana idibana epaia ovo. Da'alaabi kauna kanaua vana 'eva Malaku. ");
INSERT INTO nrz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu Petelo e'ovenia ediaka, “Kuali lepona kanana iudana 'abunai udala. Anaana 'ouna kanania Kama'u eveni'u davana sia bainua, una?” ");
INSERT INTO nrz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kuali kauta eta 'ola kauna ita mai Iuda kauta namata lo'e kabukabuna de'imala kauta ita Iesu deabia delioia, ");
INSERT INTO nrz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","devuaia makava deda'a Ana kevana, 'olana Ana 'eva Kaiapa lavana. Vikau kanaua'i Kaiapa 'eva kabukabu kauta 'olatai kauna. ");
INSERT INTO nrz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'Ana'inai Kaiapa ena lalovaiai Iuda kauta namata e'outa ediaka, “Nama'ina 'eva kau ka'onamo bemaba kau boutai 'outai.” ");
INSERT INTO nrz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petelo mai Iesu ibanona kauna ka ita Iesu mulinai deda'a. Ibanona kauna kanaua 'eva kabukabu kauta 'olatai kauna eikabasia kave'i 'ounai ia 'eva Iesu mulinai eda'a kabukabu kauta 'olatai kauna ena luma alana laloanai eda'adodo. ");
INSERT INTO nrz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Beia Petelo 'eva ua'i nutuala aunai evi'ima, ibanona kauna kanaua kabukabu kauta 'olatai eikabasia kave'i kauna emue easi nutuala e'imaia vatona e'ouia, inoku Petelo evadodoa ala laloanai. ");
INSERT INTO nrz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nutuala e'imaia vatona kanaua Petelo elavuaia ediaka, “Oni vaka kau kanaua ibanona kaumu ka, una?” Petelo ediaka, “Sia lau.” ");
INSERT INTO nrz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","'Elu namavaikana 'ounai da'alaabi kauta mai lo'e kabukabuna de'imaia kauta 'alova detouia kevanai delava kauta devasiavusiavuta. Petelo vaka ia viloatai 'alova enanata. ");
INSERT INTO nrz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Melala kanaua'i kabukabu kauta 'olatai kauna Ana, Iesu kevanai ibanona kauta mai ena vaikabasi luvata elavuai lavuai vaita. ");
INSERT INTO nrz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu ia ena luva evamuea ediaka, “Lau 'eva melala bounai kau mato vailatai aluvaluva, lau melala boutai Iuda kauta de'asi deakubou 'abutai ua'i Iuda kauta eta lo'e laloatai mai lo'e kabukabuna laloanai avaikabasi, lau sia luva ka vunivuniai aluvala. ");
INSERT INTO nrz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Oni lau dava 'ounai olavuai'u? E'u luva deika kauta kataua bomalavuaita, ia deikabasi lau luva dava aluvaia.” ");
INSERT INTO nrz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu kanaua eluva koma koanai ua'i lo'e kabukabuna de'imaia kauna ka eko'isi Iesu vailana epi'aia inoku ediaka, “Kabukabu kauta 'olatai kauna ena luva sia kanaua bovamuea koma.” ");
INSERT INTO nrz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu ena luva evamuea ediaka, “Lau aluva va'eva koanai, luvana kanaua luvala asi. Beia lau luva umauna aluvala koanai dava 'ounai opi'a'u?” ");
INSERT INTO nrz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Inoku Ana eta'u Iesu imana ido'o 'initai esinia eda'a Kaiapa kabukabu kauta 'olatai kauna kevana. ");
INSERT INTO nrz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Petelo 'eva ua'i 'alova kevanai elava enanaia laloanai delavuaia dediaka, “Oni vaka ia ibanona kaumu ka, una?” Ia e'ou avuavu ediaka, “Lau 'eva asi'i.” ");
INSERT INTO nrz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kabukabu kauta 'olatai kauna ena da'alaabi kauna kaiana Petelo epaia ovo kauna kadi'a'ana ka eta'u Petelo elavuaia ediaka, “Oni Iesu ita kula kanaua laloanai aikamui, una?” ");
INSERT INTO nrz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petelo mune'e e'ou avuavu 'udai laloanai, o'oloko komolonai e'alala. ");
INSERT INTO nrz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iuda kauta namata Kaiapa ena lumai Iesu devala'asia devada'ala deda'a Kavana kauna ena luma namanai. Kavana kauna 'eva Lomai easi. Ua 'eva 'ani taba elele inoku Iuda kauta namata 'eva Kavana ena luma laloanai sia deda'adodo, 'olana ia eta koakoa daitai Dilava vailanai sia be'obu La'au keini naduna laloanai beaniani 'ounai. ");
INSERT INTO nrz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kanaua 'ounai Pilato ela'asi eda'a kevatai elavuaita ediaka, “Kau kanania va'eva dava evavaia 'ounai oi ovuala o'asi keva'u?” ");
INSERT INTO nrz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ia ena luva devamuea dediaka, “Ia si'avana sia bemavavaia koanai sia lai bamavuala bama asi oni kevamu.” ");
INSERT INTO nrz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato e'outa ediaka, “Oi sibomui ovuaia oda'a emui talavatu vitaitanai oi bovaluvala.” Iuda kauta namata dediaka, “Lai sia mai siavumai kau ka lai bava bala.” ");
INSERT INTO nrz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kanania epulu 'eva Iesu a beba koma luvana eluvavaia luvana kanaua bemomo'ai. ");
INSERT INTO nrz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato luma namanai edodo 'udai inoku Iesu e'aeia, elavuaia ediaka, “Oni Iuda kauta eta lovia 'olana, una?” ");
INSERT INTO nrz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu ia ena luva evamuea ediaka, “Oni sibomu emu lalovaiai lavuai kanana oluvala, 'o kau vaida oni kevamuai lau lova'u deakuia luvana oluva vaia?” ");
INSERT INTO nrz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato Iesu ena luva evamuea ediaka, “Inoku oni olalovaia lau 'eva Iuda kau'u? Oni emu kau umauta mai kabukabu kauta namata oni devuamu deasi keva'u. Oni va'eva dava ovavaia?” ");
INSERT INTO nrz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu enu'ovi ediaka, “E'u lovia vanuana 'eva sia kanobata kanania enai. Bema e'u lovia vanuana kanobata kanania enai koanai, e'u kau dai'uai bemaviaku, Iuda kauta namata imatai bemavamauli'u, beia e'u lovia vanuana 'eva sia kanobata kanania'i.” ");
INSERT INTO nrz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato ia elavuaia ediaka, “Oni 'eva lovia 'olana ka, una?” Iesu ia ena luva evamuea ediaka, “Luvana mo kanana 'ani oluvala, lau 'eva lovia 'olana ka, lau apulu asi kanobatai 'olana 'eva luva umauna bavala'asia. Luva umaunai demimia kauta 'eva lau lele'u be'ika.” ");
INSERT INTO nrz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato elavuaia ediaka, “Luva umauna 'eva dava?” Kanaua eluva koma, inoku ela'asi 'udai eda'a Iuda kauta namata e'outa ediaka, “Kau kanania kevanai sia va'eva ka adavalia. ");
INSERT INTO nrz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Oi emui koakoa daitai La'au keini naduna bonina edaia koanai vabuto'o kauna ka avala'asia. Inoku oi o'ula Iuda kaumui emui lovia 'olana bavala'asia, una?” ");
INSERT INTO nrz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Inoku ena luva vaoiai devamuea dediaka, “Asi'i. Sia ia. Lai a'ula Balaba bovenimai.” Balaba 'eva abi'avaea kauna. ");
INSERT INTO nrz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato kuali kauta luva evenita Iesu deabia devuaia deda'a de'odia. ");
INSERT INTO nrz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kuali kauta 'ini auma ilo'una ia 'olanai deva'olala, maivaka tubu'a 'aolana ka ia devavadodoia. ");
INSERT INTO nrz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Inoku kevanai delava basia dediaka, “Iuda kauta eta Lovia 'olana e, bomauli keinikeini!” Inoku vailana depi'aia. ");
INSERT INTO nrz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato mune'e ela'asi, Iuda kauta namata e'outa ediaka, “Kaiamui ovaala, lau batata'u oi vailamuiai ia bavala'asia kanaua'i oi boikabasi ia kevanai sia va'eva ka adavalia kovo.” ");
INSERT INTO nrz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Inoku Iesu ela'asi koanai 'olanai 'ini auma ilo'una e'olaia mai kaunai tubu'a 'aolana ivavadodona. Pilato e'outa ediaka, “Kau kanania oikaia.” ");
INSERT INTO nrz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kabukabu kauta namata mai lo'e kabukabuna de'imala kauta Iesu deikaia koanai devaoi dediaka, “Au ido'o valaukuna akanai oaku bala, au ido'o valaukuna akanai oaku bala!” Pilato ia e'outa ediaka, “Oi sibomui oabia, au ido'o valaukuna akanai oi boaku bala, 'olana lau ia kevanai sia va'eva ka adavalia.” ");
INSERT INTO nrz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Iuda kauta namata ia ena luva devamuea dediaka, “Lai 'eva mai emai talavatu. Talavatu kanaua vitaitanai ia 'eva bebaba, 'olana ia sibona Dilava nakunai evaaoa.” ");
INSERT INTO nrz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato lele kanaua eika koanai emakau si'asi'a, ");
INSERT INTO nrz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","inoku ena vinaula lumanai eda'adodo 'udai, Iesu elavuaia ediaka, “Oni a'i oasi?” Beia Iesu sia luva ka eluvaia. ");
INSERT INTO nrz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ediaka, “Oni okokono mo sia boluva veni'u, una? Oni sia oikabasi lau 'eva mai e'u siavu oni baluvumu 'o au ido'o valaukuna akanai baku bamu?” ");
INSERT INTO nrz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu ia ena luva evamuea ediaka, “Dilava oni siavu sia bemavenimu koanai oni lau boaku ba'u siavuna 'eva kevamuai bema asi'i. Kanaua 'ounai oni imamuai euda'u 'ovu kauna kanaua ena si'avana 'eva oni emu si'avana ekeinia.” ");
INSERT INTO nrz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Melala kanaua'i Pilato dala ekavu Iesu beluvua. Beia Iuda kauta namata devaoi basibasi dediaka, “Kau kanana boluvua koanai oni 'eva sia lovia 'olana Kaisala ena kau. Kau ka ia sibona lovia 'olanai evaaoa kauna 'eva Kaisala ena 'ou kauna.” ");
INSERT INTO nrz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato luva kanania eika koanai Iesu evala'asia, inoku ia 'eva ena valuva 'abuna mia'aunai emia divo, 'abu kanaua vana de'aeia 'eva ‘bika'a palapalana’, 'Ebelu leletai vana 'eva ‘Kabata’. ");
INSERT INTO nrz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Melala kanaua 'eva La'au keini naduna iva'oluna kave'i melalana, melala 'eva 'ani eado'alavuni, Pilato Iuda kauta e'outa ediaka, “Emui lovia 'olana kanania oikaia.” ");
INSERT INTO nrz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ia devaoi dediaka, “Oaku bala, oaku bala, au ido'o valaukuna akanai oaku bala!” Pilato elavuaita ediaka, “Oi o'ula emui lovia 'olana kanana au ido'o valaukuna akanai baku bala?” Kabukabu kauta namata deluva dediaka, “Lai sia mai emai lovia 'olana kauna ka, Kaisala mo sibona.” ");
INSERT INTO nrz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Inoku Pilato eta'u Iesu kuali kauta imatai eudaia au ido'o valaukuna akanai beaku bala. Inoku kuali kauta Iesu devada'ala devuaia deda'a. ");
INSERT INTO nrz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu sibona ena au ido'o valaukuna evuaia deda'a 'abu ka vana ‘'Ola kuliana’, 'Ebelu leletai 'eva ‘Kolokota’. ");
INSERT INTO nrz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kanaua'i Iesu au ido'o valaukuna akanai dekokoia 'au, kau lua vaka ia ita dekokota 'au, ka avekenai ka avekenai, Iesu 'eva bo'adatai. ");
INSERT INTO nrz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato eta'u malele ka ua'i au ido'o valaukunai eakuia 'au, kanania eleleia koma, ‘IESU NASALETA KAUNA, IUDA KAUTA ETA LOVIA 'OLANA.’ ");
INSERT INTO nrz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iuda kauta doutamo malele kanaua devakua, 'olana Iesu dekokoia 'au 'abuna mai Ielusalema vanuana viloata 'eva sia edau'a. Maivaka malele kanaua 'eva 'Ebelu leletai, Loma leletai mai 'Elene leletai deleleia. ");
INSERT INTO nrz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Inoku Iuda kauta eta kabukabu kauta namata Pilato de'ouia dediaka, “‘Iuda kauta eta Lovia 'olana’ sia bomalelea. Beia kanania boina bomalelea, ‘Kau kanania sibona ediaka, Lau 'eva Iuda kauta eta Lovia 'olana.’” ");
INSERT INTO nrz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato eta luva evamuea ediaka, “'ani aleleia 'au davana kanaua boina mo bemimia.” ");
INSERT INTO nrz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kuali kauta Iesu dekokoia 'au mulinai ena tubu'a deabia de'idia vitavani ka ka si'ata deabi. Ia ena tubu'a ivadodo laloanai tubu'ana 'eva sia ikuli 'inina, itoina 'eva akai dekulia easimo venuai. ");
INSERT INTO nrz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kuali kauta sibota deluvaluva dediaka, “Sia eka 'idia beia punipuniai ekaikabasi dai beabia.” Kanania epulu koma 'eva Puka kabukabunai deleleia luvana kanaua bemomo'ai luvana ediaka, “Ia e'u tubu'a dekoleia, e'u ivadodo 'eva depunipuni vaia” Sal 22.18 Kanaua 'ounai kuali kauta 'eva kanania devavaia koma. ");
INSERT INTO nrz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Au ido'o valaukuna kevanai delava 'a'ateta 'eva Iesu sinana mai sinana kadina, inoku Kolopa adana Malia mai Malia Makadala ateatena. ");
INSERT INTO nrz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu ia sinana mai ibanona elalo'au venia kauna ua'i delava eikata koanai, sinana e'ouia ediaka, “Sina'u e, nakumu kanana.” ");
INSERT INTO nrz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ibanona kauna kevanai vaka e'ouia ediaka, “Lele'u ika, sinamu kanana.” Melala kanaua'i ibanona kauna kanaua eta'u Malia evada'ala deda'a ena lumai demia. ");
INSERT INTO nrz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kanaua mulinai Iesu eikabasi vinaula boutai 'ani evaoleta, inoku Puka kabukabuna luvana bevamomo'aia 'ounai ediaka, “Vei ba'u aba.” ");
INSERT INTO nrz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vodu ka ua'i vine veina vamaina devavonua, inoku dapulu ka deabia vine veina vamaina laloanai dekaoia uku, vakaia siliboai dedo'oia 'au, deisia 'au eda'a Iesu bibi'anai. ");
INSERT INTO nrz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu vine veina vamaina einuia mulinai ediaka, “'Ani eole.” Inoku 'etuna elo'easi, eba vaika. ");
INSERT INTO nrz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vali'u 'eva va'olu kave'i melalana inoku mala 'eva La'au keini naduna, ba kauta ua'i au ido'o valaukuna akanai bemimia beda'amo mala 'eva sia benama'ina 'ounai, Iuda kauta namata Pilato denoia, au ido'o valaukuna akanai dekokota 'au kauta aeta kuliata beaku mokuta inoku kauanita beabita ovo. ");
INSERT INTO nrz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kuali kauta deda'a Iesu ita dekokota 'au kauta kevatai, inoku kau lava'ana'ina aena kuliata devamoku, mune'e deda'a banona ka kevanai aena kuliata devamoku. ");
INSERT INTO nrz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Beia deda'a Iesu kevanai deikaia 'ani eba 'ounai aena kuliata sia devamoku. ");
INSERT INTO nrz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kuali kauna ka eta'u Iesu duluna ioai ekoia ulu, komolonaimo lala mai vei de'itabu ka'ona. ");
INSERT INTO nrz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Makanai eikaia kauna 'ani valina ekava, inoku ia ena vali kava 'eva momo'aina, ia eikabasia 'eva luva umauna eluvala, inoku oi ia evamomo'aia davana oi boabivenia. ");
INSERT INTO nrz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Koa kanania epulu 'eva Puka kabukabuna luvana evamomo'aia ediaka, “Sia kuliana ka devamokua kovo”. ");
INSERT INTO nrz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Puka kabukabuna kai mune'e ediaka, “Duluna dekoia ulu kauna 'eva kau beikala.” ");
INSERT INTO nrz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iosepa Alimatea kauna vaka Iesu ibanona kauna ka, beia vunivuniai 'olana Iuda kauta namata makauta emakau. Dava kataua mulitai ia eda'a Pilato kevanai enoia Iesu kauanina beabia ovo. Inoku Pilato ena luvai Iosepa eda'a Iesu kauanina eabia ovo. ");
INSERT INTO nrz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo 'ana'inai boni ka eda'a Iesu kevana kauna vaka Iosepa ebanoia nopa mai 'aloe mulamula bonata kula'ilata lua deula venita mulamulata eabi eda'a, ena mekau 'eva kiloglam koinavui (30) boina. ");
INSERT INTO nrz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inoku kauta laluana Iesu kauanina deabia mulamulai deto'aia mai tubu'a nama'ina ba kauta de'umita tubu'anai de'umia, Iuda kauta eta ba kauta devavaita kave'i vinaulana vitaitanai devavaia. ");
INSERT INTO nrz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesu au ido'o valaukuna akanai dekokoia 'au 'abuna kevanai 'eva kula ka, kula kanaua laloanai mitava makamakana ka 'eva asido'o ba kauna ka dekoleia. ");
INSERT INTO nrz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Inoku Iesu ua'i dekoleia, 'olana mitava kanaua 'eva ekevai maivaka melala kanaua 'eva La'au keini naduna iva'oluna kave'i melalana. ");
INSERT INTO nrz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Masi melalana 'avu'avuni vabulanai Malia Makadala ateatena eda'a mitava beikala, ekailao 'uli de'alavua bika'ana 'ani deabia tau eikaia. ");
INSERT INTO nrz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ia eveau emue'udai eda'a Simona Petelo mai ibanona ka Iesu elalo'au venia kauna kevatai e'outa ediaka, “Lovia namana mitavai 'ani deabia tau, lai sia aikabasi a'i dene'eiadivo.” ");
INSERT INTO nrz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petelo mai ibanona kauna ka deko'isi deda'a mitava. ");
INSERT INTO nrz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Laluana deveau ka'ona deda'a beia banona eta'u Petelo eveau kania e'ana'ia eda'a mitava. ");
INSERT INTO nrz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Beia sia edodo, ia 'uli nutualanai ekai dodo, tubu'a nama'ita kanoai deno tubu'ata eika. ");
INSERT INTO nrz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simona Petelo muliai eveau easi komolonai eda'a mitava 'ulina laloanai edodo, tubu'a nama'ita deno tubu'ata eika. ");
INSERT INTO nrz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Maivaka tubu'a ka Iesu 'olana de'umia tubu'ana 'eva sia tubu'a nama'ita ita deno ka'ona, beia ilo'u kave'ina 'abu edeanai eno. ");
INSERT INTO nrz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kanaua laloanai ibanona ka mitavai ela'asi makava kauna edodo eda'a eikata inoku eabiveni. ");
INSERT INTO nrz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Beia Puka kabukabuna luvana asido'o ovonai deovo luvana ediaka ‘Ia 'eva bai beko'isi 'udai’. ");
INSERT INTO nrz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Inoku ibanona kauta lua demue deda'a eta luma. ");
INSERT INTO nrz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia 'eva mitava kevanai elava ekani, ekani laloanai enovo dodo mitava laloana eikaia. ");
INSERT INTO nrz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Inoku ia anelu lua tubu'a deva'ita devadodota eikata, Iesu kauanina dene'eia divo 'abunai demia, ka 'eva aena duasi ka 'eva 'olana duasi. ");
INSERT INTO nrz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ia delavuaia dediaka, “Ateate e, dava 'ounai okakani?” Ia enu'ovi ediaka, “E'u Lovia namana 'ani deabia tau, sia aikabasi a'i dene'ea divo.” ");
INSERT INTO nrz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kanaua eluva koma inoku elava 'udai 'eva Iesu ua'i elava eikaia, beia sia eikabasi ua 'eva Iesu. ");
INSERT INTO nrz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu ia elavuaia ediaka, “Ateate e, dava 'ounai okakani? Dai okavua?” Malia elalovaia ia 'eva kula i'imana kauna ka, inoku ediaka, “Loviamu e, oni ia ovuaia oda'a a'i one'eia divo 'eva lau vaikabasi'u. Inoku lau bada'a babia.” ");
INSERT INTO nrz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu e'aeia ediaka, “Malia e!” Malia elava 'udai inoku 'Ebelu lelenai ediaka, “Laboni!” (Luva kanania anina 'eva vaikabasi kauna) ");
INSERT INTO nrz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu Malia e'ouia ediaka, “Sia boabi'u kovo, 'olana asido'o aele'au Kama'u kevana. Beia boda'a bo'akala'u bo'outa, lau 'eva baele'au lau Kama'u mai oi Kamamui maivaka e'u Dilava mai emui Dilava kevana bada'ala.” ");
INSERT INTO nrz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Inoku Malia Makadala ateatena eda'a ibanona kauta e'outa ia Lovia namana eikaia, mune'e Iesu luva eluvata luvata ia e'outa. ");
INSERT INTO nrz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Melala ka'onamo kanaua'i melala 'ani eulu laloanai, ibanona kauta boutai 'abu ka'onamoai deakubou, luma nutualata de'alavuta, 'olana Iuda kauta namata makauta demakau. Inoku Iesu eda'a viloatai elavadivo e'outa ediaka, “Nua'elu kevamuiai bemimia.” ");
INSERT INTO nrz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Luva kanania eluvaia mulinai imana luana mai duluna evaikata. Ibanona kauta Lovia namana deikaia koanai delalonama si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu mune'e e'outa ediaka, “Nua'elu kevamuiai bemimia. Kama'u lau esini'u vitaitanai, lau vaka oi asinimui.” ");
INSERT INTO nrz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kanaua eluva koma mulinai ladaena epululuta, ediaka, “Idume Kabukabuna oabia. ");
INSERT INTO nrz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kau eta si'avana oi bo'ou kao koanai eta si'avana 'eva i'ou kaota, beia eta si'avana sia oi bo'ou kao koanai eta si'avana 'eva sia i'ou kaota.” ");
INSERT INTO nrz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ibanona kauta 'ouka lua ka vana Toma, de'aea vi'apala, Iesu do'u kanaua kevatai eda'a dodo boninai 'eva ia sia ua'i viloatai. ");
INSERT INTO nrz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ibanona kauta vaida ia de'ouia dediaka, “Lai Lovia namana lai aikala.” Beia Toma ediaka, “Lau ikoko loita imanai ba'ika mai ima'u li'uli'uta ikoko 'abutai baisi dodo, mune'e ia dulunai ima'u baisia dodo, bema asi'i koanai lau 'eva ia sia babivenia.” ");
INSERT INTO nrz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Masi ka eole mulinai ibanona kauta luma laloanai dedo'u 'udai, Toma vaka ua'i ia ita. Nutuala de'alavu 'inia. Beia Iesu 'eva eda'a ia viloatai elavadivo ediaka, “Nua'elu kevamuiai bemimia.” ");
INSERT INTO nrz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Inoku ia Toma e'ouia ediaka, “Imamu li'uli'una emai ima'u kanania abia kovo, maivaka imamu emai dulu'uai isia dodo, inoku nuamu sia belalo to'ato'a beia boabiveni'u.” ");
INSERT INTO nrz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma Iesu ena luva evamuea ediaka, “Oni 'eva e'u Lovia namana, lau e'u Dilava!” ");
INSERT INTO nrz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu ia e'ouia ediaka, “Oni oika'u 'ounai oabiveni'u. Sia deika'u beia deabiveni'u kauta kataua 'eva denama'ina.” ");
INSERT INTO nrz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu vatabulovo koata doutamo ibanona kauta vailatai evavai davata 'eva puka kanania laloanai sia aleleta 'au. ");
INSERT INTO nrz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Beia katania aleleta 'olana 'eva oi boabiveni Iesu 'eva Keliso, Dilava Nakuna. Inoku ia oi boabivenia 'eva vanai mauli oi boabia. ");
INSERT INTO nrz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kanaua mulinai, Iesu Tibelia 'ovunai ibanona kauta kevatai ela'asi 'udai, kanania ela'asi koma. ");
INSERT INTO nrz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petelo, Toma de'aea vi'apala, Natanaela Kalileai Kana kauna, Sebedeo nakuna luana, mai ibanona kauta lua vaka ua'i ita 'abu ka'onamoai demia. ");
INSERT INTO nrz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Petelo eta'u ia e'outa ediaka, “Lau 'ani adada'a bava'eka.” Ia dediaka, “Lai vaka oni ita ekada'a.” Deda'a asiai dele'au, beia boni kanaua laloanai 'eva sia sisi ka devakoala. ");
INSERT INTO nrz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Taba elele laloanai Iesu 'eva nabuai elava, beia ibanona kauta sia deikabasi ua 'eva Iesu. ");
INSERT INTO nrz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Inoku Iesu elavuaita ediaka, “E'u kau e, sisi ka oi ovakoala?” Ia denu'ovi dediaka, “Dava asi'i.” ");
INSERT INTO nrz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iesu mune'e e'outa ediaka, “Emui vuo asi idibana duasi onaia, inoku sisi vaida 'ani oi bovakoata.” Kanaua devavaia koanai vuo bevelia 'au 'eva sia edaita, 'olana sisi doutamo vaika. ");
INSERT INTO nrz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Inoku Iesu ibanona kauna elalo'au venia kauna kanaua eta'u Petelo e'ouia ediaka, “Ua 'eva Lovia namana.” Simona Petelo 'eva ena tubu'a evadada ovo eva'eka, inoku luva kanania eika ‘Ia 'eva Lovia namana’ koanai eko'isi ena tubu'a elioia komolonai veiai elovo uku. ");
INSERT INTO nrz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ibanona kauta vaida 'eva asiai vuo sisiai evonu vuona develia 'ovu deda'a nabua, 'olana nabua 'eva sia edau'a, lova sinavu ka boina. ");
INSERT INTO nrz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ia nabuai dele'au koanai dekailao 'alova 'itana akanai sisi ine'e'auta deikata, palaoa vaida vaka ua'i. ");
INSERT INTO nrz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu ia e'outa ediaka, “Vali'u oi oakuta sisita vaida oabi omai.” ");
INSERT INTO nrz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simona Petelo emue'udai asiai ele'au vuo evelia 'au nabuai, vuoai sisi namata mo 'avaeana boutai sinavu ka imanavui koi (153), sisi namata 'avaeana beia eta vuo 'eva sia e'idi. ");
INSERT INTO nrz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu ia e'aeta ediaka, “Omai oaniani!” Inoku ibanona kauta sia deula belavuaia bediaka, ‘Oni dai?’ 'olana 'ani deikabasia ia 'eva Lovia namana. ");
INSERT INTO nrz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu eda'a palaoa eabia inoku evenita, maivaka sisi vaka kanaua evavaia koma. ");
INSERT INTO nrz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kanania 'eva Iesu bai eko'isi 'udai mulinai melala ivakoina ia ibanona kauta kevatai evaila. ");
INSERT INTO nrz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Deaniani koa mulinai Iesu Simona Petelo elavuaia ediaka, “Simona Ioane nakuna e, oni momo'ai lau olalo'au veni'u vaika vakaia vaida katania eta lalo'au, una?” Petelo ediaka, “'O, Lovia namana, oni oikabasi lau oni ulamu a'ula.” Inoku Iesu ediaka, “E'u mamoe nakuta bovananita.” ");
INSERT INTO nrz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Melala ivaluana elavuai 'udai ediaka, “Simona Ioane nakuna e, oni lau olalo'au veni'u, una?” Petelo ediaka, “'O, Lovia namana, oni oikabasi lau oni ulamu a'ula.” Inoku Iesu ediaka, “E'u mamoe bo'imata kave'i.” ");
INSERT INTO nrz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu melala ivakoina Petelo elavuaia ediaka, “Simona Ioane nakuna e, oni lau olalo'au veni'u, una?” Petelo nuana eanana 'olana 'ani melala ivakoina elavuaia ediaka, “Oni lau ula'u o'ula?” Petelo ediaka, “Lovia namana e, oni 'eva dava boutai oikabasita, oni oikabasi lau oni ulamu a'ula.” Iesu ediaka, “E'u mamoe bovananita. ");
INSERT INTO nrz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Lau oni luva umauna a'oumu, 'alu'alumu koanai oni sibomu tubu'amu ovadodo maivaka oulavenia 'abuna 'eva oda'ala. Beia bomomotu koanai imamu boisi pailolo, kau ka betata'u tubu'amu bevavadodomu, bevuamu sia oula venia 'abuna boda'ala.” ");
INSERT INTO nrz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu luva kanania eluvaia 'eva Petelo a beba koma Dilava ena nuavi bevala'asia beikala. Inoku e'ouia ediaka, “Mai muli'uai da'a.” ");
INSERT INTO nrz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petelo ekai 'udai 'eva Iesu ibanona elalo'au venia kauna mulitai eda'a eikaia, ia 'eva ani bouai Iesu kaunai ekabe'au, inoku elavuaia ediaka, “Lovia namana e, dai oni venimu beveveni mai koumu bekokou?” ");
INSERT INTO nrz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petelo kau kanaua eikaia koanai Iesu elavuaia ediaka, “Lovia namana e, kau kanaua 'eva a beko?” ");
INSERT INTO nrz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu eta'u Petelo e'ouia ediaka, “Bema lau ba'ula ia bemimia beda'amo lau bamue'udai ba'asi, beia oni kevamuai kanaua 'eva dava? Oni 'eva mai muli'uai da'a.” ");
INSERT INTO nrz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Luva kanania 'ounai ibanona kauta sibota viloatai deluvaluva vaia dediaka, ibanona kauna kanaua sia bebaba. Beia Iesu 'eva sia ediaka kau kanaua sia bebaba, ia ediaka, “Bema lau ba'ula ia bemimia beda'amo lau bamue'udai ba'asi, beia oni kevamuai kanaua 'eva dava?” ");
INSERT INTO nrz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ibanona kauna kanaua eta'u luva katania boutai e'ou asi maivaka eleleta, inoku ita kaikabasi luva katania eluva vaita luvata 'eva umauta. ");
INSERT INTO nrz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu 'eva koa doutamo vaika evavai. Lau alalovaia kataua boutai ka'o ka'o demalele 'au koanai, kanobata itoina puka katania bemadoubou 'eva sia bedaia. ");
INSERT INTO nrz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo e, e'u puka makavana laloanai Iesu ena vinaula mai ena vaikabasi emakavala evavai davata, ");
INSERT INTO nrz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","eda'amo ia eabia isi ele'au vutuvutu eda'aia koanai valina boutai aleleta. Asido'o ele'au laloanai, Idume Kabukabuna siavunai ena veauneke ia edilata kauta kevatai vinaula bevavaita vinaulata lovata eaku. ");
INSERT INTO nrz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ena ba mulinai, bevamomo'aia ia 'eva emauli dokadoka 'ounai boni vaninavui (40) laloatai ia sibona melala doutamo ena veauneke kau kevatai evala'asia, maivaka kevatai Dilava ena lovia vanuana valina ekava. ");
INSERT INTO nrz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Melala ka eta miado'u laloanai Iesu luva kanania evenita ediaka, “Ielusalema sia oi bovikania, beia Kama'u eluva'ana'i vaia Idumena Kabukabuna oi bo'imala, luvana kanaua lau oi 'ani a'oumui. ");
INSERT INTO nrz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ioane 'eva veiai kau evaidi'uta kabukabu, beia boni vidamo laloatai oi 'eva Idume Kabukabuna ai oi boidi'u kabukabu.” ");
INSERT INTO nrz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iesu ibanona kauta ita dedo'u koanai ia delavuaia dediaka, “Lovia namana e, vali'u mo kanania'i Isalaela kanobatana ena siavu bovenia 'udai, una?” ");
INSERT INTO nrz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu eta luva evamuea ediaka, “Kama'u sibona siavunai melalata mai bonita 'ani eva'oluta, oi sia mai emui komolo dava kanania aida bepupulu davana oi boikabasia. ");
INSERT INTO nrz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Beia Idume Kabukabuna be'ovu oi akamuiai koanai siavu oi boabia, lau vali'u oi bokava odaoda Ielusalemai, Iudea mai Samalia vanuata itoinai, maivaka beda'a mo kanobata to'ona.” ");
INSERT INTO nrz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iesu luva kanania eluvavaia mulinai, ia makata umaunai eabia isi ele'au vutuvutu eda'aia deikaia, inoku oli ka ia e'alavua, kanaua'i ia sia deikaia 'udai. ");
INSERT INTO nrz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ia vutuvutuai ele'au 'abuna deika 'inia laloanai, komolonai kau lua tubu'a deva'ita devadodota 'eva ia delava basita. ");
INSERT INTO nrz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Inoku de'outa dediaka, “Kalilea kaumui e. Dava 'ounai nia'i oi olalava oi o'a'ali dae vutuvutu oi oikala? Iesu vali'u kevamuiai eabia isi vutuvutu eda'ala kauna mune'e bemumue be'asi 'eva vali'u ele'au vutuvutu eda'ala oi oikala vitaitanai be'asi.” ");
INSERT INTO nrz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Inoku veauneke kauta Olive lolonai de'ovu deda'a Ielusalema, 'abu kataua viloata eta dau'a 'eva kilomita ka'onamo boina. ");
INSERT INTO nrz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ielusalemai deda'adodo koanai deda'a demia vaia lumanai dele'au deda'a aka daiutuna. Kauta kataua vata 'eva katania, Petelo, Ioane, Iakobo, Andelea, Pilipo, Toma, Batolomeo, Mataio, Alepeo nakuna Iakobo, Simona Selote kauna, mai Iakobo nakuna Iuda. ");
INSERT INTO nrz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ia boutai 'abu ka'onamoai devaka'ona mai'a'ateta ita mai Iesu sinana Malia mai kadina ita demeamea kevanai kevanai. ");
INSERT INTO nrz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Melala kanaua'i abiveni kauta 'avaeana boutai sinavu ka luanavui (120) dedo'u, inoku Petelo eko'isi vailatai elavadivo eilolota. ");
INSERT INTO nrz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ediaka, “Bo'akala'u e! Puka Kabukabuna luvana be'asi bemomo'ai davana Idume kabukabuna eta'u Davida nutunai Iuda lovana ka 'ani eakuia makava Iesu iabina bedada'a kauta 'eva ia be'ana'ia vaita. ");
INSERT INTO nrz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iuda 'eva lai banomai ka, 'olana ia vaka edilaia lai ita lai avinaula ka'ona vinaula kanania laloanai.” ");
INSERT INTO nrz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Iuda ena si'avana moninai kano ka etavaia, inoku ua'i e'eko 'olana e'ana'ia, bo'ana epou silina boutai dedouasi mulimuliai. ");
INSERT INTO nrz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ielusalemai demia kauta boutai vali kanania deika, kanaua 'ounai kano kanaua vana de'aeia ‘Akeledama’, ita leletai luva kanaua anina 'eva ‘Lala Kanona’.) ");
INSERT INTO nrz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“'Olana Salamo pukanai 'ani ilelena ediaka, ‘Ena luma 'eva be'avaea. Sia kau ka ua'i bemimia.’ Sal 69.25 Mune'e eleleia, ‘Ia 'abuna 'eva kau ka betata'u beabia.’ ");
INSERT INTO nrz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kanaua dainai vali'u 'eva ita viloatai banota ka ekabiaisi. Kau kanaua 'eva Lovia namana Iesu ena da'a to'ato'a itoina eikaia kauna mai ");
INSERT INTO nrz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ioane ena vaidi'u kabukabu ai epulu melalanai easimo Iesu ele'au vutuvutu eda'aia koanai ia vaka ua'i kauna ka. Lai ita lai bavinaula ka'ona Iesu ena ko'isi 'udai valina ikavana dainai.” ");
INSERT INTO nrz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kanaua 'ounai kau lua deula venita ka beabia isi, ka vana Iosepa vaida de'aea Balasaba mune'e de'aea Iusto, mai ka 'eva vana Matia. ");
INSERT INTO nrz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Inoku demeamea dediaka, “Lovia namana e! Oni 'eva kau boutai nuata oikabasi, kau katania luana viloatai davana odilala kauna 'eva vali'u bovaikamai. ");
INSERT INTO nrz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ia 'eva vidulu mai veauneke vinaulana kanania Iuda evikania vinaulana bevavaia, 'olana Iuda 'eva 'ani eda'aovo ena 'abu umauna eda'aia.” ");
INSERT INTO nrz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Inoku depunipuni, laloanai va ela'asi 'eva Matia, inoku veauneke kauta 'ouka ka'onamo 'eva eva'ouka luata. ");
INSERT INTO nrz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikosi melalanai abiveni kauta boutai 'abu ka'onamoai deakubou. ");
INSERT INTO nrz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Inoku vutuvutuai 'ulu ka alimo easi itani lani namana ka eunu 'uluna boina, ia demia do'u lumana bounai evavonua. ");
INSERT INTO nrz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Maivaka dava ka deikaia ikana itani 'alova vulena malana boina eda'a ka ka laikubuatai. ");
INSERT INTO nrz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ia boutai Idume Kabukabunai 'ani devonu, inoku Idume Kabukabuna evenita vitaitanai vanua edeata edeata leletai deluva. ");
INSERT INTO nrz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kanaua melalanai Iuda kauta Dilava makauna demakau kauta kanobata edeata edeatai demia kauta deasi Ielusalemai. ");
INSERT INTO nrz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","'Ulu kanania deika koanai, 'abu ka'onamoai deakubou maivaka do'u 'eva nama vaikana, do'u kauta delalo toatoa, 'olana ka ka leleta umaunai abiveni kauta vali kanaua deluvaia 'uluna deika. ");
INSERT INTO nrz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Boutai detabulovo si'asi'a mai nuata debavunu dediaka, Deluluva kauta katania 'eva Kalilea kauta, una? ");
INSERT INTO nrz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A boina ita boutai 'eva ka ka leleta umaunai deluluva leleta ka'ika? ");
INSERT INTO nrz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ita 'eva kanobata edeata edeata ai kasi, Patia, Media, Elama, Mesopotamia, Iudea, Kapadokia, Ponto, Asia, ");
INSERT INTO nrz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pelikia, Pamupulia, Aikupito ai maivaka Kulene ai, ua 'eva Libia eta 'abu ka. Loma ai deasi kauta, vaida 'eva Iuda kauta vaida 'eva sia Iuda kauta beia kukudivo dalanai Iuda kautai devaaota kauta, ");
INSERT INTO nrz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","vaida 'eva Kelete mai Alabia ai deasi. Kau kataua Dilava koa namata evavai koata lelemai umaunai deluva vai leleta lai aika.” ");
INSERT INTO nrz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Boutai detabulovo mai delalo to'ato'a, ia ka ka sibota delavuai lavuai dediaka, “Kanania 'eva dava?” ");
INSERT INTO nrz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Beia vaida 'eva abiveni kauta demediamedia vaita dediaka, “'Ani deinu ba.” ");
INSERT INTO nrz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Inoku Petelo mai banona 'ouka ka ita deko'isi, ia mato eilolo venita 'unu'unu ediaka, “Iuda kaumui mai Ielusalemai oi omimia kaumui e. Kaiamui ovaala kave'i. Dava kanania a epulu koma davana valina bavaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lai kaumai katania 'eva sia lai ainu ba, oi olalovaia boina, maivaka vali'u mo 'avu'avuni melala koana kalavani ka. ");
INSERT INTO nrz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Beia enolea kauna Ioela kanania eluva koma ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Dilava ediaka, Melala to'ona be'asi koanai, Lau Idume'u 'eva kau boutai akatai bava'ovua. Nakumui momoluaneta mai 'a'ateta benolea, emui kau 'alu'aluta 'eva bemakakeini, maivaka emui kau momotuta benivinivi. ");
INSERT INTO nrz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mune'e melala kanaua'i lau Idume'u 'eva e'u da'alaabi kauta momoluaneta mai 'a'ateta akatai bava'ovua inoku ia 'eva benolea. ");
INSERT INTO nrz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Vatabulovo davata vaida vutuvutu akanai bavala'asita, maivaka kanobata akanai koa namata vaida bavapuluta, lala, 'alova maivaka vaitabu imusina. ");
INSERT INTO nrz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lovia namana ena melala namana mai nuavina e'avi e'asi koanai, melala 'eva bevabulaavu, vuia 'eva be'aola itani lala boina. ");
INSERT INTO nrz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Inoku Lovia namana vanai be'ae'ae kauta 'eva bemauli.’ ");
INSERT INTO nrz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isalaela kaumui e, kaiamui ovaala kave'i. Iesu Nasaleta kauna 'eva Dilava ia nuanai evinaula vatabulovo vinaulata mai koa namata vaida evavaita, koakoata oi viloamuiai evala'asita 'eva oi boumuiai oi oikabasita kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dilava ena ula maivaka ena ikabasi ai Iesu kanania 'ani siako eva'olua dalanai oi evenimui. Oi ota'u si'avana kauta imatai oi oudaia au ido'o valaukuna akanai dekokoia 'au eba. ");
INSERT INTO nrz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Beia Dilava eta'u bai evako'isia 'udai, ba ena anaana ai eluvu ne'ea, 'olana ba ia beabi 'inia ua'i vabuto'o 'abunai 'eva sia edaia. ");
INSERT INTO nrz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davida ia valina ekava ediaka, ‘Lovia namana 'eva melala bounai vaila'uai aikala. 'Olana ia 'eva lau idiba'u duasi, lau sia bamakau kovo. ");
INSERT INTO nrz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kanaua 'ounai nua'u elalonama, mai mala'u 'eva lalonama luvata eluvavaita, kau'u 'eva nuabata laloanai bemimia. ");
INSERT INTO nrz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","'Olana idume'u 'eva mitavai sia bovikania, maivaka emu Kabukabu kauna sia ua'i bovikania bepepeda. ");
INSERT INTO nrz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oni ota'u mauli dalana ovaika'u, vailamuai 'eva lalonamai bovavonu'u.’ ");
INSERT INTO nrz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Bo'akala'u e! Lau 'eva oi kevamuiai 'ava'avata Davida valina bakava kave'i. Oi oikabasi ia 'eva eba inoku dekoleia, mitavana 'eva vali'u nia'i ita kevatai emimia. ");
INSERT INTO nrz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Beia Davida 'eva enolea kauna inoku eikabasia 'eva Dilava eta'u ia eluva'ana'i pasisi evenia, ia kekena ka 'eva ia ena mia'au 'abunai ua'i bemia'au. ");
INSERT INTO nrz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davida eta'u vailai dava bepupulu davana eikaia 'ana'i 'eva Keliso ena ko'isi 'udai luvana eluvavaia ediaka, ‘Ia 'eva mitavai ua'i sia bevikania, ia kauanina sia bepepeda.’ ");
INSERT INTO nrz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dilava eta'u Iesu kanania ba ai evako'isia 'udai. Lai boumaiai lai aikaia maivaka lai aikabasi. ");
INSERT INTO nrz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dilava eta'u ia eabia isi imana idibana duasi evamiala. Kamana eluva'ana'i vaia Idumena Kabukabuna 'ani eabia. Inoku 'ani esinia 'ovu, vali'u ena siavu makamuiai 'ani oi oikala maivaka kaiamuiai 'ani oi o'ika. ");
INSERT INTO nrz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","'Olana Davida 'eva sia ele'au eda'a vutuvutuai beia ia ediaka, ‘Lovia namana 'eva e'u Lovia e'ouia ediaka, Lau idiba'u duasi miadivo, ");
INSERT INTO nrz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","beda'amo oni emu 'ou kauta aemu ivalavana 'au davanai bavaaota.’ ");
INSERT INTO nrz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kanaua 'ounai Isalaela kaumui boumuiai oi boikabasi komolo 'eva oi ota'u Iesu au ido'o valaukuna akanai oi okokoia 'au kauna 'eva Dilava eta'u 'ani Lovia namana mai Keliso ai evaaoa.” ");
INSERT INTO nrz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kau luva kataua leleta deika koanai nuata debata inoku Petelo mai veauneke kauta delavuaita dediaka, “Bo'akalamai e! Lai dava lai bavavaia?” ");
INSERT INTO nrz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petelo ia e'outa ediaka, “Oi boumuiai oi bolalo 'udai, ka ka Iesu Keliso vanai oi boidi'u kabukabu emui si'avana i'ou kaota dainai. Inoku Idume Kabukabu ena ainama 'ani oi boabia. ");
INSERT INTO nrz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Luva'ana'i kanania 'eva oi mai nakumui daitai maivaka dau'ai vaika demimia kauta kataua Lovia namana eta Dilava be'aeta kauta boutai daitai.” ");
INSERT INTO nrz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petelo luva doutamo vaidai kau e'outa kave'i maivaka evakula'ilata ediaka, “Ulu si'avana kanania'i oi bovamaulimui.” ");
INSERT INTO nrz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Petelo ena luva deabia dae kauta boutai vaidi'u kabukabu koana deabia, melala kanaua'i kau 'eva sinavu boutai koinavui (3,000) abiveni kauta eta do'u laloanai dedodo. ");
INSERT INTO nrz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ia 'eva melala boutai veauneke kauta eta vaikabasi luvata lelete ikata deulaveni mai deakubou ka'ona 'abu ka'onamoai, ita deaniani ka'ona maivaka demeamea ka'ona. ");
INSERT INTO nrz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Veauneke kauta vatabulovo vinaulata mai koa vinaulata doutamo devavaita inoku kau boutai 'eva Dilava makauna demakau. ");
INSERT INTO nrz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Inoku abiveni kauta boutai deakubou ka'ona 'abu ka'onamoai mai eta dava boutai dekole vidavena. ");
INSERT INTO nrz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eta lavo mai kano detavatavavai inoku kau ka ka eulavenia monina vitaitanai devenia. ");
INSERT INTO nrz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Melala bounai Dilava ena lo'e kabukabuna laloanai deakubou, maivaka luma ka ka laloatai mailalonamata ita mai nuata nama'inata ita deviani vidavena, ");
INSERT INTO nrz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dilava devanama'inala, kau boutai ia delalonama venita. Melala bounai Lovia namana etata'u evamaulita kauta kataua 'eva abiveni kauta ita evaka'onamota. ");
INSERT INTO nrz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Melala ka lavilavi melala koana koi boina meamea melalana, Petelo mai Ioane deda'a Dilava ena Lo'e kabukabuna. ");
INSERT INTO nrz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ua'i kau ka epulu 'ome'ome 'eva melala bounai devuala deasi lo'e kabukabuna nutualana vana ‘Si'amobalaveni nutualana’ aunai ua'i devamiala. Kau lo'e kabukabuna deda'a venia kauta kataua kevatai enoi va'ame. ");
INSERT INTO nrz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Petelo mai Ioane lo'e kabukabuna ai deda'a dodo eikata koanai kevatai moni enoinoi. ");
INSERT INTO nrz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petelo mai Ioane ia deteia basibasi. Inoku Petelo ia e'ouia ediaka, “Lai ikamai!” ");
INSERT INTO nrz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","'Ome kauna elalovaia 'eva dava ka bevenia 'ounai eikata. ");
INSERT INTO nrz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petelo ia e'ouia ediaka, “Lau keva'u moni asi'i. Beia keva'uai dava emimia davana bavenimu. Iesu Keliso Nasaleta kauna vanai, ko'isi da'a!” ");
INSERT INTO nrz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Inoku Petelo ia imana idibanai eabi eduluia isi, komolonai aena mai aena 'ato'atota dekula'ila. ");
INSERT INTO nrz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ia elovo isi elavadivo, eda'a kokovo. Ia ita lo'e kabukabuna laloanai deda'a dodo, eda'a maivaka elovo isi lovo isi inoku Dilava evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Do'u kauta boutai deikaia eda'a maivaka Dilava evanama'inala. ");
INSERT INTO nrz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Deikabasia ia 'eva melala bounai lo'e kabukabuna kanaua nutualana vana ‘Si'amobalaveni nutualana’ aunai emia divo enoi va'ame kauna, inoku detabulovo si'asi'a dava kevanai epulu davana dainai. ");
INSERT INTO nrz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aena enama'ina kauna eta'u Petelo mai Ioane e'avaleta laloanai, kau doutamo vaika detabulovo si'asi'a inoku deveau deda'a vaka ka vana Solomona ena vakai ua'i deikaia. ");
INSERT INTO nrz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petelo ia eikata koanai ediaka, “Isalaela kaumui e, dava 'ounai dava kanania'i oi otabulovo si'asi'a? Maivaka dava 'ounai oi lai oalulumai? Oi olalovaia lai sibomai emai siavuai 'o emai ka'uba siavutai kau kanania lai avako'isia edada'a, una? ");
INSERT INTO nrz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abela'amo, Isa'ako mai Iakobo eta Dilava maivaka ita 'ava'avata eta Dilava eta'u ena da'alaabi kauna Iesu nuavi evenia. Beia oi ota'u Pilato oi ovenia, maivaka Pilato eula bevala'asia lalovaina evavaia koanai oi o'ouia avuavu. ");
INSERT INTO nrz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kabukabu mai Komolo kauna oi o'ouia kao, inoku akuaku kauna beluvune'ea dainai oi onoinoivaia. ");
INSERT INTO nrz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Oi ota'u mauli 'olana kauna oi oaku bala, beia Dilava eta'u ba ai evako'isia 'udai, lai aikaia kaumai katania. ");
INSERT INTO nrz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu vana siavunai 'ome kauna kanania kula'ila eabia, kauna kanania 'ani oi oikala maivaka oi oikabasia. Luva umauna lai Iesu abivenia 'ounai oi boumuiai vailamuiai kau kanania evanama'inala kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bo'akala'u e, lau aikabasi oi mai emui 'ana'iavai kauta ita Iesu kevanai dava oi ovavaia davana 'eva sia oi oikabasia. ");
INSERT INTO nrz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Beia Dilava eta'u enolea kauta boutai etai 'ani eluvaia 'ana'i luvana easi emomoai, ia ediaka, Keliso 'eva bevaanaanala. ");
INSERT INTO nrz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Kanaua 'ounai olalo 'udai, oi bo'ilo Dilava kevana oi boasia, kanaua'i emui si'avana besiuta ovo. Melalana be'asi koanai Lovia namana kula'ila makamakana bevenimui. ");
INSERT INTO nrz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dilava betata'u Iesu mune'e besinia be'asi oi kevamui, makavanai oi daimuiai edilaia kauna Keliso. ");
INSERT INTO nrz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iesu vutuvutu ai bemimia beda'amo Dilava dava boutai bevamakamakata melalana be'asi. Siako vaika ena enolea kauta kabukabuta kevatai eluva'ana'i vitaitanai. ");
INSERT INTO nrz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“'Olana Mose ediaka, ‘Lovia namana emui Dilava 'eva enolea kauna ka oi daimuiai emui kau umauta viloatai bevako'isia vitaitana lau boi'u, ia beluluva davata boutai 'eva lelena oi bo'ika. ");
INSERT INTO nrz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Enolea kauna kanaua lelena sia be'ika kauta boutai 'eva Dilava ena kau viloatai beba palu.’ ");
INSERT INTO nrz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Luva umauna, enolea kauta boutai kataua Samuela ena melala ai easi mo vali'u 'eva melala kanania 'ani deluvaia 'ana'i vaia. ");
INSERT INTO nrz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Oi 'eva enolea kauta 'ava'avata. Dilava eta'u oi 'ava'avamui ita luva'ana'i devavaia 'eva oi daimuiai. Ia Abela'amo e'ouia ediaka, ‘Oni kekemu 'outai kanobatai kau boutai bavanama'inata.’ ");
INSERT INTO nrz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dilava ena Da'alaabi kauna evako'isia koanai esinia 'ana'i easi oi kevamuiai bevanama'inamui kanaua'i oi ka ka emui mauli si'avata vaika dalatai oi boda'a tau.” ");
INSERT INTO nrz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petelo mai Ioane kau deluva venita laloanai, kabukabu kauta mai lo'e kabukabuna i'imana kauta eta 'ola kauna maivaka Sadukea kauta 'eva deasi ia kevata. ");
INSERT INTO nrz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ia 'eva debadu si'asi'a 'olana veauneke kauta kataua 'eva Iesu ena ko'isi 'udai 'ounai ba kauta ba ai beko'isi 'udai valina kau devaikabasita. ");
INSERT INTO nrz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Inoku ia laluana deabita deliota vabuto'o lumanai de'alavuta beda'amo belani, 'olana 'ani elavilavi 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Beia kau doutamo luva kanaua deika mai deabivenia kauta 'eva sinavu boutai imanavui (5,000) boina. ");
INSERT INTO nrz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Elani 'eva vanua 'ola'ana'ita, vanua kauta namata mai talavatu 'ola kauta boutai Ielusalemai deakubou. ");
INSERT INTO nrz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kabukabu kauta 'olatai kauna Ana, Kaiapa, Ioane, Alesanda mai kabukabu kauta 'olatai kauna ena iduvu kauta vaida, ia boutai 'eva ua'i. ");
INSERT INTO nrz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Laluana devuata deda'a vailatai devalavata inoku delavuaita dediaka, “Siavu davai 'o dai vanai vinaula kanania oi ovavaia?” ");
INSERT INTO nrz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petelo 'eva Idume Kabukabuna ai evonu, ia eta luva evamuea ediaka, “Vanua 'ola'ana'imui mai vanua kaumui namamui e. ");
INSERT INTO nrz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vali'u oi lai olavuaimai 'ome kauna kevanai koa nama'ina ivavaina dainai mai aboina enama'ina koanai, ");
INSERT INTO nrz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","oi boikabasi maivaka Isalaela kauta boutai beikabasi, Iesu Keliso Nasaleta kauna, au ido'o valaukuna akanai oi oaku bala beia Dilava eta'u ba ai evako'isia 'udai kauna vanai 'eva 'ome kauna kanania 'ani enama'ina vailamuiai elalava oi oikala. ");
INSERT INTO nrz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu 'eva ‘luma idauna kaumui oi ovasi'avanala bika'ana, luma kubuana bika'anai eao.’ ");
INSERT INTO nrz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vamauli 'eva ia sibona mo enai ekadavalia, 'olana kanobata bounai laloanai Dilava sia va edeana ka eveni ita bevamaulita.” ");
INSERT INTO nrz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iuda kauta namata delalovaia Petelo mai Ioane sia malele 'abuna ka namana deda'aia, eta ikabasi asi'i kauta, beia sia demakau luva deluva kave'i deikata 'eva detabulovo si'asi'a. Maivaka deikabasi kau katania 'eva Iesu ita devidoka. ");
INSERT INTO nrz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Beia kau 'ani enama'ina kauna ua'i ia laluana ita delava deikaia 'ounai sia luva ka deluvaia. ");
INSERT INTO nrz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kanaua 'ounai ia deta'u Petelo, Ioane mai kau enama'ina kauna de'outa do'u namana 'abunai bela'asi, inoku dela'asi mulinai kau kataua sibota deluvaluva. ");
INSERT INTO nrz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Dediaka, “Kau katania kevatai dava ekavavaia? 'Olana Ielusalemai demimia kauta boutai 'ani deikabasi ia 'eva vatabulovo vinaulana edeana vaika ka devavaia, sia 'ani eka 'ouavuavu diba. ");
INSERT INTO nrz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Beia kau kevatai vali kanania ikavana bevapuala, ita 'eva kau katania ekavamakauta sia kau ka kevanai Iesu vana beluva vaia kovo.” ");
INSERT INTO nrz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Inoku de'aeta 'udai dedodo, de'outa Iesu vana sia beilolo vaia kovo maivaka sia kena bevaikabasi vaia kovo. ");
INSERT INTO nrz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Beia Petelo mai Ioane eta luva devamuea dediaka, “Oi olalovaia oi lelemui daitai lai badadai 'o Dilava lelena daitai lai badadai. Dilava vailanai davana 'eva ekomolo? ");
INSERT INTO nrz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","'Olana lai aika mai lele lai aika davata lai bavunita 'eva sia bedaia.” ");
INSERT INTO nrz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ivamakauta luvatai de'outa mulinai devala'asita, bevaanaanata dalana sia ka dedavalia 'olana dava epulu davana dainai kau boutai 'eva Dilava devanama'inala. ");
INSERT INTO nrz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Vatabulovo vinaulanai enama'ina kauna vikauna 'eva vaninavui (40) ekeinia. ");
INSERT INTO nrz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Devala'asita mulinai, Petelo mai Ioane demue'udai deda'a banota kevatai, kabukabu kauta namata mai vanua kauta namata luva dava deluvaia luvata boutai de'outa. ");
INSERT INTO nrz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Leleta deika mulinai, boutai nuata devaka'onamo Dilava kevanai demeamea 'unu'unu dediaka, “Akai vaika umauna Loviana e, vutuvutu mai kanobata mai 'atubata maivaka laloatai demimia davata boutai 'eva oni ovavaita. ");
INSERT INTO nrz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Idume Kabukabuna siavunai emu da'alaabi kauna 'ava'avamai Davida nutunai emu luva eluva vaia ediaka, ‘Pulu edea kauta dava 'ounai debadu, maivaka kau dava anita asi'i davata dava 'ounai delalovaita namavaikana? ");
INSERT INTO nrz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kanobata loviata 'olata deko'isi inoku vanua kauta namata ita devaka'onamo Lovia namana mai ia ena Keliso devibodala vaita.’ ");
INSERT INTO nrz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Momo'ai dokadoka, 'Eloda mai Pontio Pilato 'eva pulu edea kauta mai Isalaela kauta ita vanua namana kanania laloanai demiado'u. Emu da'alaabi kauna kabukabuna Iesu, oni odilaia Kelisoai ovaaoa kauna devasi'avanala. ");
INSERT INTO nrz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ia 'eva oni emu siavu ai mai ulai 'ani ova'olua vinaulana bepupulu davana devavaia. ");
INSERT INTO nrz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kanaua 'ounai, Lovia namana e, ia eta vamakau luvata lalovaita, inoku lai oni emu da'alaabi kaumai vakula'ilamai, sia lai bamakau oni emu luva lai baluvala. ");
INSERT INTO nrz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Imamu isipailolo emu siavu vala'asia 'olele kauta vanama'inata maivaka vatabulovo vinaulata mai koa namata oni emu da'alaabi kauna kabukabuna Iesu vanai vavai.” ");
INSERT INTO nrz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ia demeamea koa mulinai do'u lumana e'iuvai 'iuvai, ia boutai 'eva Idume kabukabuna evavonuta inoku mai kula'ilata ita Dilava luvana deluvaia. ");
INSERT INTO nrz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abiveni kauta boutai 'eva lalovai ka'onamo ai mai nuata ka'onamo ai, sia kau ka sibona ena dava ka 'ouna evavaia beia eta dava boutai 'eva devikole viveni. ");
INSERT INTO nrz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Veauneke kauta mai siavuta namavaikana ita Lovia namana Iesu ena ko'isi 'udai valina deilolo vaia. Inoku Dilava ena vanama'ina 'eva ia boutai akatai. ");
INSERT INTO nrz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ia viloatai 'eva sia kau ka etabu, 'olana mai eta kano 'o luma kauta kataua 'eva detavatava vaita monita kataua deabita deda'a, ");
INSERT INTO nrz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","veauneke kauta vailatai de'uleta, inoku dekole kave'i ka ka ena ulalu vitaitanai. ");
INSERT INTO nrz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kau ka vana Iosepa, Lebi iduvuna kauna Kupulo ai epulu, veauneke kauta 'eva ia vana de'aeia Banaba (anina 'eva ‘Vakula'ila kauna’.) ");
INSERT INTO nrz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ena kano etavatavavaia monina bounai eabia eda'a veauneke kauta vailatai e'uleia. ");
INSERT INTO nrz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kau ka vana Anania adana Sapila ita eta kano ka detavatava vaia. ");
INSERT INTO nrz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ia adana ita deikabasi 'eva kano kanaua monina kalina ia eabia kao, kalina mo eabia eda'a veauneke kauta vailatai e'uleia. ");
INSERT INTO nrz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Inoku Petelo ia e'ouia ediaka, “Anania e! Satani nuamu aeko 'ani evavonua vaika, Idume Kabukabuna 'ani olebaia inoku kano monina kalina 'eva oni sibomu daimuai 'ani oabia kao? ");
INSERT INTO nrz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Asido'o kano kanaua otavatava vaia koanai, kano kanaua 'eva oni emu, inoku otavatava vaia mulinai monina vaka oni emu. Koa kanania dava 'ounai nuamuai olalovaia? Oni 'eva sia kau olebata beia Dilava olebala.” ");
INSERT INTO nrz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania luva kanaua eika koanai e'eko 'eva eba, inoku vali kanaua deika kauta boutai demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","'O'ole vaida dela'asi deasi kauanina tubu'ai de'umia inoku devuaia dela'asi deda'a dekoleia. ");
INSERT INTO nrz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Melala koana koi boita deole mulinai adana eda'adodo, ia sia eikabasi 'eva dava epulu. ");
INSERT INTO nrz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petelo ia elavuaia ediaka, “Lau 'ou'u, oni adamu ita emui kano oi otavatava vaia 'eva tavana kanania, una?” Ia ediaka, “O, tavana kanana.” ");
INSERT INTO nrz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petelo ia e'ouia ediaka, “Dava 'ounai oni adamu ita nuamui oi ovaka'onamo Lovia namana Idumena oi ovakovoa? Lele'u o'ika, adamu dekoleia kauta 'eva nutuala aunai delalava, oni vaka bevuamu bela'asi.” ");
INSERT INTO nrz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ia komolonai e'eko Petelo aena 'olanai 'eva eba. 'O'ole dedodo deasi 'eva banai dedavalia, inoku devuaia dela'asi deda'a adana 'aba'abanai dekoleia. ");
INSERT INTO nrz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Melala kanaua'i abiveni kauta boutai mai vali kanaua deika kauta boutai 'eva demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Veauneke kauta vatabulovo vinaulata mai koa namata doutamo kau vailatai devavai, abiveni kauta boutai nuata ka'onamoai Solomona ena vakai deakubou. ");
INSERT INTO nrz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Beia kau vaida 'eva demakau sia deda'a kevata, ia eta 'ola aku 'eva namavaikana kau kataua kevatai. ");
INSERT INTO nrz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Beia kau mai 'a'ate doutamo Lovia namana deabivenia kauta deda'a 'eva ia kauta devadouta. ");
INSERT INTO nrz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kanaua 'ounai 'olele kauta devuata deda'a dalai inoku toto'a mai 'eta akatai devaenota 'au kanaua'i Petelo kevatai beda'a keini koanai va'ava'ana beda'a akatai. ");
INSERT INTO nrz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ielusalema 'aba'abanai vanuata kauta doutamo vaika vaka deasi, 'olele kauta mai ka'uba si'avata vaika nuatai dedodo kauta kataua devuata deasi ua'i, inoku boutai 'eva denama'ina. ");
INSERT INTO nrz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kabukabu kauta 'olatai kauna mai ia ibanona kauta, Sadukea iduvuna kauta ita 'eva veauneke kauta demama venita. ");
INSERT INTO nrz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Inoku veauneke kauta deliota devuata deda'a vabuto'o lumana laloanai de'alavuta. ");
INSERT INTO nrz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Beia boni kanaua'i Lovia namana ena anelu ka eta'u vabuto'o lumana nutualana eluvuia inoku evala'asita, ");
INSERT INTO nrz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ediaka, “Oda'a, Dilava ena Lo'e Kabukabuna laloanai mauli makamakana luvana kanania itoina kau vailatai oi boluva vaia.” ");
INSERT INTO nrz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Luva kanaua deika vitaitanai devavaia, 'avu'ani vabulanai Lo'e Kabukabunai deda'adodo inoku kau devaikabasita. Melala kanaua'i kabukabu kauta 'olatai kauna mai banona ita deda'a do'u namana kauta mai Isalaela kauta namata ita dedo'u, luva desinia eda'a veauneke kauta vabuto'o lumanai bevuata be'asi. ");
INSERT INTO nrz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lo'e Kabukabuna i'imana kauta deda'a vabuto'o lumanai dela'asi 'eva ia ua'i sia dedavalita, kanaua 'ounai demue'udai deda'a inoku do'u namana kauta de'outa dediaka, ");
INSERT INTO nrz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Vabuto'o lumana 'eva i'alavu 'ininai lai adavalia mai nutuala i'imana kauta vaka ua'i nutualai delava, beia nutuala lai aluvuia lai ada'adodo koanai sia kau ka ua'i lai adavalia.” ");
INSERT INTO nrz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lo'e Kabukabuna i'imana kauta eta 'ola kauna mai kabukabu kauta namata luva kanaua deika koanai, delalo to'ato'a namavaika, koa kanaua anina 'eva dava. ");
INSERT INTO nrz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Inoku kau ka edodo easi 'eva e'outa ediaka, “Vabuto'o lumanai oi o'alavuta kauta kataua 'eva Lo'e Kabukabuna laloanai delalava kau devaikabasita.” ");
INSERT INTO nrz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lo'e Kabukabuna de'imala kauta eta 'ola kauna ita deda'a veauneke kauta devuata kave'i deasi, sia dava ka devavaia 'olana demakau kau bika'ai asi'i demaakuta makauna. ");
INSERT INTO nrz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Veauneke kauta devuata deda'a do'u namana vailanai devalavata, inoku kabukabu kauta 'olatai kauna eta'u elavuaita. ");
INSERT INTO nrz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ediaka, “Lai oi atalavatumui, kau kanania vanai sia oi bovaikabasi. Beia vali'u emui vaikabasi luvatai Ielusalema bounai vali kanania 'ani edaonala, inoku oi o'ula ena ba vuvuana oi bovakoamai.” ");
INSERT INTO nrz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petelo mai veauneke kauta vaida denu'ovi dediaka, “Lai 'eva Dilava lelena daitai lai badadai, sia kau leleta daitai lai badadai. ");
INSERT INTO nrz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Oi ota'u Iesu au akanai oi okokoia oi oaku bala kauna, ita 'ava'avata eta Dilava eta'u ba ai 'ani evako'isia 'udai. ");
INSERT INTO nrz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dilava ia eabia isi imana idibanai evamiala ita i'ana'iavaita mai ivamaulita kaunai evaaoa kanaua'i Isalaela kauta belalo'udai inoku eta si'avana be'oukao. ");
INSERT INTO nrz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Lai mai Idume Kabukabuna 'eva dava katania vuta iakuta kaumai, Dilava eta'u Idume Kabukabuna kanaua eveni ia lelena daitai dedadai kauta kataua kevatai.” ");
INSERT INTO nrz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Luva kanaua deika koanai, debadu si'asi'a inoku deula veauneke kauta beaku bata. ");
INSERT INTO nrz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Beia Palisea kauna ka vana Kamaliela, talavatu 'ola kauna ka, kau boutai ia 'olana deaku kauna, do'u namana laloanai eko'isi veauneke kauta e'outa bela'asi mulimuliai melala kava'inamo bevi'ima. ");
INSERT INTO nrz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Inoku ia do'u namana kauta e'outa ediaka, “Isalaela kaumui e, kau katania kevatai dava oi bovavaia 'eva oi bolalovaia kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","'Ana'inai Teuda eko'isi ediaka ia vaka kau ka, kau boutai sinavu vani (400) boina mulinai deda'a. Ia deaku bala koanai ibanona kauta boutai deveau siusiu, inoku sia davana ka epulu. ");
INSERT INTO nrz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ia mulinai Kalilea kauna ka vana Iuda, kau vata ilelena melalanai eko'isi, kau doutamo nuata eani ia mulinai deda'a, ia vaka deaku bala, inoku mulinai deda'a kauta boutai deveau siusiu. ");
INSERT INTO nrz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kanaua 'ounai vali'u lau oi a'oumui, kau katania kevatai sia dava ka oi bovavaia, oi bovikanita 'avaea bedada'a, bema ia eta vinaula katania devavai 'eva kau eta lalovaiai be'asi koanai anita sia 'ani bepulu. ");
INSERT INTO nrz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Beia Dilava enai be'asi koanai, kau katania sia 'ani oi bo'outa kao bedaia. Asi'i sibomui mo oi omadavalimui 'eva oi Dilava oviaku venia.” ");
INSERT INTO nrz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ia Kamaliela lelena deabia dae, veauneke kauta de'aeta dedodo, de'odita mulinai detalavatuta Iesu vanai sia bevaikabasi 'udai, inoku devala'asita deda'a. ");
INSERT INTO nrz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Veauneke kauta do'u namana kauta devikanita 'eva delalonama si'asi'a, 'olana Dilava 'ani ia eabita isi 'eva Iesu vanai devamalalaita. ");
INSERT INTO nrz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Melala bounai Lo'e Kabukabuna laloanai mai kau ka ka eta luma laloatai Iesu 'eva Keliso valina nama'ina kanaua devaikabasi vaia mai deilolo vaia basibasi. ");
INSERT INTO nrz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Melala kataua'i Iesu ibanona kauta eta mato 'eva ele'au vaika koanai Iuda kauta vaida 'Elene leletai deluvaluva kauta deta'u Iuda kauta vaida 'Ebelu leletai deluvaluva kauta ita devina, 'olana iani dekoleta koanai eta obu 'eva devatabuta. ");
INSERT INTO nrz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Veauneke kauta 'ouka lua deta'u Iesu deabivenia kauta boutai devamiatado'u inoku dediaka, “Sia enama'ina iani ikoleta dainai Dilava ena luva ilolo vaina vinaulana ekavikania. ");
INSERT INTO nrz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kanaua 'ounai bo'akalamai e, oi viloamuiai kau kalakoika valita denama'ina kauta aonekai mai Idume Kabukabunai devonu kauta oi bodilata, vinaula kanania ekavenita be'ana'ia vaia. ");
INSERT INTO nrz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Beia lai 'eva melala bounai meamea mai ilolo vinaulata mo lai bavavai.” ");
INSERT INTO nrz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Veauneke kauta eta lalovai luvana devamomo'aia, inoku kau katania dedilata, Sitiveni abiveni mai Idume Kabukabunai evonu kauna, Pilipo, Polokolo, Nikanolo, Timona, Pamena, mai Nikolao ia 'eva pulu edea kauna Antiokai easi Iuda kaunai evaaoa kauna. ");
INSERT INTO nrz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kau kalakoika katania devuata deda'a veauneke kauta vailatai devalavata, inoku veauneke kauta deta'u imata ia laikubuatai dekao'au demeamea devanama'inata. ");
INSERT INTO nrz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Dilava ena luva 'eva 'abu bounai edaonala, Ielusalema laloanai Iesu deabivenia kauta 'eva ekubu ele'aumo mai kabukabu kauta doutamo vaka Iesu deabivenia. ");
INSERT INTO nrz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiveni 'eva Dilava ena iulaveni mai siavu ai evonu, ia eta'u kau vailatai koa namata mai vatabulovo vinaulata evavai. ");
INSERT INTO nrz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Beia kau vaida 'eva deva'ekotau vaika, kau kataua 'eva Iuda kauta eta lo'e vana ‘La'asi 'avaea’ kauta, ia vaida 'eva Kulene mai Alesandeleai deasi, vaida Silisia mai 'Eisiai deasi, ia deta'u Sitiveni ita deadedua. ");
INSERT INTO nrz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Beia ia Sitiveni bevadeduala 'eva sia edaita 'olana Idume Kabukabuna eta'u aoneka evenia 'eva eluva vaita. ");
INSERT INTO nrz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kanaua 'ounai ia deta'u kau vaida nuata deani beluluva bediaka, “Lai 'eva ia Mose mai Dilava akatai luva si'avata vaika eluva lelena lai a'ika.” ");
INSERT INTO nrz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kanaua'i vanua kauta mai vanua kauta namata maivaka talavatu 'ola kauta devabaduta, ia deko'isi deda'a Sitiveni deabia kao devuaia deda'a do'u namana kauta vailatai. ");
INSERT INTO nrz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Inoku kau vaida devuata deasi 'eva dede luvatai de'ouia dediaka, “Kau kanania 'eva Kabukabu 'abuna kanania mai Mose ena talavatu ivasi'avanata luvana eluvala basibasi. ");
INSERT INTO nrz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Lai ia lelena lai aika ediaka, Iesu Nasaleta kauna betata'u Lo'e Kabukabuna kanania bevasi'avanala maivaka Mose ita evenita koakoata boutai bevaedeanata.” ");
INSERT INTO nrz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Do'u namana 'abunai demia kauta boutai Sitiveni deteia 'eva ia vailana ikana itani anelu ka vailana boina. ");
INSERT INTO nrz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kabukabu kauta 'olatai kauna Sitiveni elavuaia ediaka, “Luva katania 'eva momo'aita, una?” ");
INSERT INTO nrz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiveni ena luva evamuea ediaka, “Bo'akala'u mai kama'u boumuiai e, lele'u oika. Ita 'ava'avata Abela'amo asido'o eda'a 'Alana, ia Mesopotamiai emia do'o laloanai, nuavi Dilavana ia kevanai evailaasi, ");
INSERT INTO nrz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","e'ouia ediaka, ‘Emu kano mai domu bovikanita, boda'a lau oni bavaikamu kanonai.’ ");
INSERT INTO nrz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Kanaua 'ounai Abela'amo eta'u Kaledea kauta eta kano evikania, eko'isi eda'a 'Alanai emia. Kanaua'i emia eda'amo kamana eba, inoku Dilava eta'u esinia easi kano kanania'i vali'u oi omimia 'abuna. ");
INSERT INTO nrz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dilava Abela'amo sia kano kava'ina kena evenia, sia aena ivalavanadivo 'abuna vitaitana vaka kena eva'oula venia. Beia Dilava eluva'ana'i 'eva kano kanaua ia mai ia kekena bevenita. Melala kanaua'i Abela'amo 'eva sia mai nakuna. ");
INSERT INTO nrz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dilava eta'u ia kanania boina e'ouia ediaka, ‘Oni kekemu 'eva 'abu edea kauta eta kanoai bemimia, vikau sinavu vani (400) laloanai kano kanaua kauta da'alata be'abi mai bevaanaanata.’ ");
INSERT INTO nrz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Beia Dilava eluva vaka ediaka, ‘Eta da'ala iabinai devaaota kauta kataua 'eva lau batata'u bavaluvata, kanaua mulinai ia kano kanaua'i bela'asi inoku 'abu kanania'i lau bekukudivo veni'u.’ ");
INSERT INTO nrz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Inoku Dilava Abela'amo e'ouia iva bevavaia 'eva Dilava ena luva'ana'i ivamomo'aina koana. Kanaua 'ounai Aisaka epulu melalana ivakalavaninai koanai iva koana evavaia. Aisaka nakuna Iakobo evapulua, maivaka Iakobo nakuna 'ouka lua Isalaela iduvuna 'olata depulu. ");
INSERT INTO nrz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Iduvu 'olana kauta 'eva kadita Iosepa demama venia, Aikupito kauta kevatai detavatava vaia da'alaabi kaunai eao. Beia Dilava 'eva Iosepa ebanoia, ");
INSERT INTO nrz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","maivaka ena mekau boutai laloatai evamaulia. Koakoa nama'ina mai aoneka evenia Palao Aikupito lovia 'olana vailanai, Palao eta'u Iosepa siavu evenia Aikupito kanobatana mai ena luma kauta boutai be'ola vaita. ");
INSERT INTO nrz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Inoku Aikupito mai Kanaana kanota itoinai doe nama vaikana epulu inoku anaana nama vaikana evapulua. Ita 'ava'avata sia iani kena dedavalia. ");
INSERT INTO nrz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iakobo luva eika iani 'eva Aikupito ai ua'i, inoku ita 'ava'avata esinita eta melala makavana da'ana. ");
INSERT INTO nrz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Eta melala ivaluana da'anai 'eva Iosepa sibona bo'akalana vailatai eluvasi ia 'eva dai, inoku Palao Iosepa kadi'a'ana eikabasita. ");
INSERT INTO nrz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Inoku Iosepa luva esinia kamana Iakobo mai kadi'a'ana kauta boutai kalakoika navui ima (75) be'asi Aikupito. ");
INSERT INTO nrz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Inoku Iakobo eko'isi eda'a Aikupito, ua'i eba mulinai ita 'ava'avata vaka ua'i deba. ");
INSERT INTO nrz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba kauta kauanita 'eva devuata deda'a Sekema mitavanai dekoleta. Mitava kanaua 'eva Abela'amo eta'u 'Amolo nakuna imatai moniai etavaia. ");
INSERT INTO nrz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Dilava ena luva'ana'i Abela'amo kevanai ivamomo'aina melalana ekevai laloanai, ita 'ava'avata Aikupitoai 'eva kauta mato namavaikana. ");
INSERT INTO nrz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Eda'amo to'onai lovia 'olana edeana ka Aikupito eloviala, ia 'eva Iosepa sia eikabasia. ");
INSERT INTO nrz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Lovia 'olana kanaua ita 'ava'avata elebata inoku evaanaanata, evaasiasita sibota nakuta 'oma'omata beitota asi kanaua'i bebaba. ");
INSERT INTO nrz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Melala kanaua'i Mose epulu, melo si'amobalavenina Dilava vailanai, vuia koi kamana ena lumai de'imaia. ");
INSERT INTO nrz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Inoku devala'asia mulimuliai devikania koanai Palao nakuna vatona eabia inoku eva'aida'aidala ia sibona nakunai evaaoa. ");
INSERT INTO nrz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kanaua 'ounai Mose 'eva Aikupito kauta eta aoneka boutai laloatai devaikabasia, inoku ia ena luvai mai ena koai 'eva desiavu vaika. ");
INSERT INTO nrz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mose vikauna vaninavui eabia koanai ia eula dona Isalaela kauta beikata. ");
INSERT INTO nrz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ia banona ka Aikupito kauna ka eta'u evasiavanala 'eva eikaia, kanaua 'ounai ia eda'a kau kanaua eduluia inoku Aikupito kauna eaku bala. ");
INSERT INTO nrz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose elalovaia 'eva ia dona belaloune Dilava betata'u Mose imanai ia bevamaulita, beia ia sia deikabasi. ");
INSERT INTO nrz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Elani Isalaela kauta lua deviaku, Mose eda'a kevatai eabita kao inoku ediaka, ‘Kau e, oi laluana 'eva kadi'a'a, oi sibomui dava 'ounai oi ovaanaanamui?’ ");
INSERT INTO nrz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Beia ekula'ila kauna eta'u Mose edolia tau inoku elavuaia ediaka, ‘Oni dai eva'oula venimu lai bolovia vaimai maivaka bovaluvamai kaunai evaaomu? ");
INSERT INTO nrz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Oni o'ula lau boaku ba'u vitaitana lavi Aikupito kauna oaku bala boina?’ ");
INSERT INTO nrz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose luva kanaua eika koanai, komolonai eveau akauma eda'a Midiana kanonai emia vitaitana 'abu edea kauna boina, ua'i nakuna momoluaneta lua depulu. ");
INSERT INTO nrz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Vikau vaninavui (40) deole mulinai, Sinai lolona kevanai kano'akunai au 'ini'ininai 'alova evule laloanai anelu ka Mose kevanai evailaasi. ");
INSERT INTO nrz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose eikaia koanai etabulovo, eilulao eda'a kevanai beikala kave'i laloanai, Lovia namana lelena eika. ");
INSERT INTO nrz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ediaka, ‘Lau 'eva 'ava'avamu eta Dilava, Abela'amo, Aisaka mai Iakobo eta Dilava.’ Mose emakau si'asi'a e'ululu 'ululu, sia eula beikala. ");
INSERT INTO nrz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lovia namana eta'u ia e'ouia ediaka, ‘Emu tamaka abita ovo, 'olana olalava 'abuna 'eva ekabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Lau e'u kau Aikupitoai deanana aikata maivaka eta kani leleta a'ika, kanaua 'ounai a'ovu asi bavamaulita, vali'u ko'isi basinimu bomue'udai boda'a Aikupito.’ ");
INSERT INTO nrz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose ka'onamo kanania kauna ia deta'u delavuaia dediaka, ‘Oni dai eva'oula venimu lai bolovia vaimai maivaka bovaluvamai?’ Dilava eta'u ia esinia ia belovia vaita mai ivamaulita kaunai be'ao, au 'ini'inina eani laloanai ia kevanai evailaasi aneluna ena vidulu ai. ");
INSERT INTO nrz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose kauna kanaua Isalaela kauta Aikupitoai evala'asita, inoku vatabulovo vinaulata mai koa namata vaida Aikupitoai, 'Atu 'Aolanai maivaka vikau vaninavui kano'akunai evavaita. ");
INSERT INTO nrz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose mo kanaua eta'u Isalaela kauta e'outa ediaka, ‘Dilava betata'u enolea kauna ka oi viloamuiai besinia, vitaitana lau boi'u.’ ");
INSERT INTO nrz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ia kauna kanaua 'eva Isalaela kauta itana kano'akunai demia bou, mai Sinai Lolona akanai ia eluva venia aneluna itana maivaka ita 'ava'avata ita, inoku ia mauli luvana eabia eveni keini ita kevatai. ");
INSERT INTO nrz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Beia ita 'ava'avata sia deula Mose lelena be'ika, ia sia deabia dae, ia deula bemue'udai beda'a Aikupito. ");
INSERT INTO nrz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ia deta'u Alona de'ouia dediaka, ‘Ita be'ana'ia vaita dilavata vaida vavaita, 'olana Mose Aikupitoai evada'ata asi kauna 'eva sia lai aikabasi ia kevanai 'ani dava epulu?’ ");
INSERT INTO nrz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Melala kanaua'i ia deta'u bolomakau nakuna va'ava'ana ka devavaia, veniveni davata devuata deasi dilava dedena kanaua vailanai dene'eta divo, imatai devavaia davana vailanai delalonama. ");
INSERT INTO nrz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dilava ia kevatai eda'a ovo inoku evikanita sibota vutuvutu davata bekukudivo venita. Enolea kauna ena pukai ilelena luvana vitaitanai ediaka, ‘Isalaela kaumui e, vikau vaninavui kano'akunai ainama mai vanama'ina sisita 'eva oi lau sia oainama veni'u. ");
INSERT INTO nrz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Oi dilava vana Moloka ena aiole lo'ena oi ovuala, maivaka emui visiu dilavana vana Lepana va'ava'ana vaka oi ovuala, dilava dedeta oi ovavaita kataua 'eva oi okukudivo venita. Kanaua 'ounai Lau batata'u oi bavada'amui tau oi boda'a Babulonia avekenai.’ ");
INSERT INTO nrz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ita 'ava'avata kano'akunai kevatai 'eva Dilava ena aiole lo'ena ka, Dilava eta'u Mose e'ouia aiole kanaua bevavaia vitaitanai devavaia, Mose eikaia koana vitaitanai. ");
INSERT INTO nrz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mulinai ita 'ava'avata deta'u ia kamata imatai aiole lo'ena kanaua deabia devuaia Iosua ita deda'a pulu edea kauta eta kanoai dela'asi, Dilava eta'u vailatai kano kauta elo'ota asi, inoku ia demia vaia easimo Davida ena melalai. ");
INSERT INTO nrz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dilava ena nama'ina 'eva Davida evenia, inoku ia Dilava enoia 'eva Iakobo ena Dilava ena luma ka bedaua. ");
INSERT INTO nrz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Beia Solomona eta'u luma evalavala. ");
INSERT INTO nrz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Beia aka umauna Dilavana 'eva kau imatai devavaia lumana laloanai sia emimia. Enolea kauna ena luva vitaitana ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Lovia namana kanania eluva koma, Vutuvutu 'eva e'u mia'au 'abuna, kanobata 'eva ae'u ivalavadivona 'abuna. Lau e'u luma davana oi bodaua? E'u laani 'abuna 'eva a'i? ");
INSERT INTO nrz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Dava katania boutai 'eva sia Lau ima'uai avavai, una?’ ");
INSERT INTO nrz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“'Ola pasisi kaumui, nuamui mai kaiamui oi o'alavuta kave'i vitaitana Dilava sia deikabasia kauta boita. Oi otata'u melala boutai Idume Kabukabuna oi otauavua. 'Ava'avamui devavai koakoata 'eva oi vaka oi ovavai. ");
INSERT INTO nrz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Oi 'ava'avamui enolea kauna sia ka devasi'avanala, una? Vinaula komolo kauna be'asi luvana deluva vaia kauta deaku bata, vali'u oi ota'u komolo kauna venina oi oveni kouna oi okou inoku oi oaku bala. ");
INSERT INTO nrz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Oi kaumui 'eva Dilava ena talavatu anelu eveni 'eva oi oabia beia lelena daitai sia oi odai.” ");
INSERT INTO nrz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Do'u namana kauta Sitiveni lelena deika koanai debadu si'asi'a inoku adeta deala'opa devaikala. ");
INSERT INTO nrz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Beia Sitiveni 'eva Idume Kabukabunai evonu, e'a'a dae vutuvutu eikaia inoku Dilava nuavina maivaka Iesu Dilava idibana duasi elava eikaia. ");
INSERT INTO nrz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ia ediaka, “Oikaia! Vutuvutu eviluvu inoku Kau Nakuna Iesu Dilava idibana duasi elalava aikala.” ");
INSERT INTO nrz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ia devaoi 'unu'unu imatai kaiata de'oububuta inoku ia boutai Sitiveni deveau venia, ");
INSERT INTO nrz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","deabia develiasi vanua mulimulinai inoku demakavala bika'ai deakuia, dede luvata deluva kauta kataua 'eva eta tubu'a ivadodo devadada ovo kau 'alu'aluna ka vana Saulo aena 'olanai dene'edivo. ");
INSERT INTO nrz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bika'ai deakuia laloanai Sitiveni emeamea ediaka, “Lovia namana Iesu e, lau idume'u abia.” ");
INSERT INTO nrz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ekuidula inoku evaoi ediaka, “Lovia namana e! Si'avana kanania tavana sia bovenita.” Kanaua eluva koma mulinai eba. ");
INSERT INTO nrz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo eta'u evamomo'aia Sitiveni 'eva deaku bala. Melala ka'onamo kanaua'i Ielusalemai Dilava ena lo'e kauta devaanaanata vaika, inoku abiveni kauta boutai devaveauta siusiu deda'a Iudea mai Samalia kanotai demia, veauneke kauta sibota mo Ielusalemai demia. ");
INSERT INTO nrz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dilava 'olana deaku kauta vaida Sitiveni deabia dekanidiala inoku devuaia deda'a dekoleia. ");
INSERT INTO nrz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Beia Saulo eula Dilava ena lo'e kauta beabi siata, luma ka ka laloatai edodo, momoluane mai 'a'ate evelita la'asi, evuata eda'a vabuto'o lumana laloanai e'alavuta. ");
INSERT INTO nrz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abiveni kauta devaveauta siusiu 'eva deda'a 'abuta ka ka laloatai vali nama'ina deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipo eda'a Samalia vanuana namanai ela'asi, ua'i kau kevatai Keliso valina eilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kau mato Pilipo lelena deika mai vatabulovo vinaulata evavai deikata koanai ia boutai 'eva ia eluva luvata leleta deika kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kau doutamo nuatai ka'uba si'avata vaika kevatai mai vaoivaoita dela'asi, inoku 'eko kauta mai 'ome kauta dounamo 'eva denama'ina. ");
INSERT INTO nrz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kanaua 'ounai ua'i vanua namana kanaua laloanai lalonama namavaikana epulu. ");
INSERT INTO nrz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kau ka vana Simona 'eva vanua namana kanaua'i emia, ia siako vaikai eoada inoku Samalia kauta boutai 'eva detabulovo. Ia sibona evanamala, ");
INSERT INTO nrz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","inoku kau boutai, namanai eda'amo kikinai epua, ia lelena de'ika mai dediaka, “Dilava ena siavu 'eva kauna kanania vana Siavu Namavaikana.” ");
INSERT INTO nrz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Siako vaika sinosino vinaulatai evatabulovota 'ounai ia lelena deika. ");
INSERT INTO nrz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Beia Pilipo Dilava ena lovia vanuana valina nama'ina mai Iesu Keliso vana eilolo vaia koanai, deabivenia, inoku momoluane mai 'a'ate evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona vaka eabiveni inoku evaidi'ua kabukabu, Pilipo ebanoia deda'a to'ato'a 'eva koa namata mai vatabulovo vinaulata evavai eikata 'eva etabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ielusalemai veauneke kauta luva deika 'eva Samalia kauta vaka Dilava ena luva deabia dae, kanaua 'ounai Petelo mai Ioane desinita deda'a Samalia. ");
INSERT INTO nrz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Laluana deda'a Samaliai dela'asi koanai, abiveni kauta daitai demeamea 'eva Idume Kabukabuna beabia, ");
INSERT INTO nrz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","'olana Idume Kabukabuna 'eva asido'o e'ovu ia ka akatai, ia 'eva Lovia namana Iesu vanai mo devaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kanaua 'ounai Petelo mai Ioane imata ia akatai dekao'au demeamea 'eva Idume Kabukabuna deabia. ");
INSERT INTO nrz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simona 'eva veauneke kauta imata abiveni kauta laikubuatai dekao'au demeamea 'eva Idume Kabukabuna deabia eikata koanai, ia eta'u moni vaida eabita easi veauneke kauta evenita 'eva ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Lau vaka siavu kanana oi boveni'u kanaua'i lau ima'u ia akatai bakao'au bameamea kauta boutai 'eva Idume Kabukabuna beabia.” ");
INSERT INTO nrz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Beia Petelo ia e'ouia ediaka, “Oni emu moni itana oi boba ka'ona 'olana oni olalovaia Dilava ena ainama davana 'eva moni ai botavala. ");
INSERT INTO nrz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Oni vinaula kanania laloanai sia mai 'abumu 'o avumu, 'olana Dilava vailanai oni nuamu 'eva sia ekomolo. ");
INSERT INTO nrz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Emu si'avanai lalo'udai inoku Lovia namana noia, ama'i nuamu lalovaina si'avanana be'oua kao. ");
INSERT INTO nrz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","'Olana oni aikamu 'eva nuamuai mama evonu vaika maivaka si'avana 'ani evavilimu kaiu.” ");
INSERT INTO nrz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simona enu'ovi ediaka, “Lau dai'uai Lovia namana enai oi bomeamea kanaua'i oi oluvavai luvata 'eva sia ka keva'uai bepupulu.” ");
INSERT INTO nrz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petelo mai Ioane Lovia namana ena luva deluvasi vaia maivaka deilolo vaia mulinai, demue'udai deda'a Ielusalema. Eta dalai da'a laloanai 'eva Samalia vanuata doutamo laloatai vali nama'ina deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lovia namana ena anelu ka Pilipo e'ouia ediaka, “Ko'isi divo duasi boda'ala, Ielusalemai eda'a Kasa dalana 'eva kano'akuna.” ");
INSERT INTO nrz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kanaua 'ounai Pilipo eko'isi eda'a, dalai Etiopia kauna ka eikaia. Ia 'eva kau namana ka Etiopia eta lovia 'olana ateatena Kanadake ena dava e'ima kauna. Ia 'eva eda'a Ielusalemai emeamea, ");
INSERT INTO nrz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","inoku ena mue'udai ai 'eva ena kalioteai emia'au, enolea kauna Isaia ena puka evakua. ");
INSERT INTO nrz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Idume Kabukabuna eta'u Pilipo e'ouia ediaka, “Da'a kaliote kauna kanaua 'aba'abanai bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Inoku Pilipo eveau eda'a kau kanaua kevanai 'eva enolea kauna Isaia pukana evakua lelena eika. Inoku elavuaia ediaka, “Oni ovakua davana 'eva anina ovonai o'ovo, una?” ");
INSERT INTO nrz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kau namana kanaua ediaka, “Lau a baikabasi koma? Sia mai ivaikabasi'u kauna ka.” Inoku ia eta'u Pilipo enoia bele'au kevanai bemimia. ");
INSERT INTO nrz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Puka Kabukabuna laloanai evakua luvana 'eva kanania boina deleleia. “Ia 'eva itani mamoe boina sia mai 'uluna bevada'ala beda'a beaku bala, 'o itani mamoe nakuna boina vuina beukua kauna vailanai 'eva 'ulu'uluna asi'i, kanaua 'ounai ia nutunai sia luva ka eluvaia kovo. ");
INSERT INTO nrz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ena lele vunu 'ounai valuva laloanai ena komolo deabia ovo. Sia kau ka ia kekena lovata be'aku 'olana kanobatai ena mauli 'ani deabia ovo.” ");
INSERT INTO nrz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kau namana kanaua Pilipo elavuaia ediaka, “'Ou'u, enolea kauna 'eva dai lovana eakua? Ia sibona lovana eakua 'o kau ka lovana eakua?” ");
INSERT INTO nrz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Inoku Pilipo eta'u puka ivakuna pukana kanaua 'abunai emakavala, maivaka Iesu valina nama'ina evaikabasia. ");
INSERT INTO nrz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Laluana dalai deda'a laloanai, deasi vei 'abuna kai dela'asi, inoku kau namana kanaua ediaka, “Ikala, vei nia, lau dava 'ounai sia baidi'u kabukabu?” ");
INSERT INTO nrz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Pilipo ena luva evamuea ediaka, “Bema mai nuamu bounai boabiveni koanai vaidi'u kabukabu boabia 'eva enama'ina.” Inoku kau namana kanaua ediaka, “Lau mai nua'u bounai abiveni Iesu Keliso 'eva Dilava Nakuna.”) ");
INSERT INTO nrz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Inoku e'ouia kaliote bevalavala kao, Pilipo mai kau namana laluana de'ovu deda'a vei laloanai, Pilipo eta'u kau kanaua evaidi'ua kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kauta laluana veiai dele'au deasi koanai, Lovia namana Idumena eta'u Pilipo eabia tau. Inoku kau namana kanaua Pilipo sia eikaia 'udai, beia dalai mai lalonamana eda'a. ");
INSERT INTO nrz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Beia Pilipo 'eva Asoto vanuanai evailaasi, inoku eda'a vanua boutai laloatai edodo vali nama'ina eilolo vaia eda'amo Kaisalea vanuanai ela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Melala kanaua'i ua'i Ielusalema laloanai Saulo 'eva Lovia namana ibanona kauta ivamakauta mai iaku bata luvata eluva 'aku'aku, kanaua 'ounai ia eda'a kabukabu kauta 'olatai kauna kevana, ");
INSERT INTO nrz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","inoku enoia malele ka belelea bevenia beabia beda'a Iuda kauta eta lo'e Damaseko ai. Ua'i Iesu deabivenia dala kanania'i deda'avaia kauta mai 'a'ateta beliota bevuata bemue'udai beda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo dalai eda'a Damaseko vanuana 'ani ekevaia laloanai alimo 'ailala ka vutuvutuai e'ovu ia eduia. ");
INSERT INTO nrz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo e'eko kanoai, lele ka eika ia e'ouia ediaka, “Saulo e! Saulo e! Lau dava 'ounai ovaanaana'u?” ");
INSERT INTO nrz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo elavuai ediaka, “Lovia namana e, oni dai?” Ena luva evamuea ediaka, “Lau 'eva Iesu, ovaanaana'u kau'u. ");
INSERT INTO nrz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Vali'u ko'isi boda'a vanua laloanai bodododo, ua'i kau ka betata'u oni bovavaita davata vinaulata be'oumu.” ");
INSERT INTO nrz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo ita eda'a kauta ua'i delava sia luva ka deluvaia, lele deika beia sia kau ka deikaia. ");
INSERT INTO nrz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo kanoai eko'isi, beia makana evaata koanai ia sia dava ka eikaia kovo. Kanaua 'ounai imanai deabi devada'ala deda'a Damaseko. ");
INSERT INTO nrz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Melala koi emia laloanai makana 'eva de'ede, mai sia eaniani 'o dava ka einuia. ");
INSERT INTO nrz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasekoai abiveni kauna ka vana Anania, ena makakeini ai Lovia namana ia e'aeia ediaka, “Anania e!” Anania enu'ovi ediaka, “O! Lovia namana, lau nia.” ");
INSERT INTO nrz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Inoku Lovia namana ia e'ouia ediaka, “Ko'isi da'a dala vana ‘Komolo’ ua'i Iuda ena lumai Taso kauna ka vana Saulo bolavuailavuai vaia. 'Olana vali'u ia 'eva emeamea. ");
INSERT INTO nrz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ena makakeini ai 'eva kau ka vana Anania eikaia easi ia akanai ekao'au emeamea 'eva makana eviluvu.” ");
INSERT INTO nrz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Beia Anania Lovia namana ena luva evamuea ediaka, “Lau kau kanania valina melala doutamo 'ani aika, ia Ielusalemai emu kabukabu kauta doutamo 'ani evaanaanata vaika. ");
INSERT INTO nrz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Maivaka kabukabu kauta namata eta siavuai 'ani easi nia'i inoku oni vamuai de'ae'ae kauta boutai beliota.” ");
INSERT INTO nrz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Beia Lovia namana ia e'ouia ediaka, “Da'a. 'Olana lau 'ani ia adilaia da'ala'u be'abi, pulu edea kauta, lovia 'olata kauta maivaka Isalaela kauta vailatai lau va'u beilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Lau batata'u ia bavaikala 'eva lau va'u dainai ia beanana vaika.” ");
INSERT INTO nrz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kanaua 'ounai Anania eko'isi eda'a lumai edodo, imana luana Saulo akanai ekao'au 'eva ediaka, “Bo'akala'u Saulo e! Dalai oasi laloanai Lovia namana Iesu kevamuai evailaasi kauna esini'u a'asi, oni makamu bevaata boikaika 'udai maivaka Idume Kabukabunai bevavonumu.” ");
INSERT INTO nrz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Komolonai itani sisi unata boina Saulo makanai de'ekoasi, inoku makana denama'ina, ena ikaika enama'ina 'udai. Eko'isi inoku eidi'u kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Inoku eaniani mulinai 'eva kauanina ekula'ila 'udai. Saulo boni vida boita abiveni kauta ita Damaseko ai demia. ");
INSERT INTO nrz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Komolonai Saulo eko'isi Iuda kauta eta lo'e ka ka laloatai eilolo Iesu 'eva Dilava Nakuna. ");
INSERT INTO nrz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lelena deika kauta boutai detabulovo si'asi'a dediaka, “Nia 'eva Ielusalemai Iesu dekukudivo venia kauta evavaita si'asi'a vaika kauna. Inoku easi nia'i vaida vaka beliota bevuata beda'a kabukabu kauta namata kevatai, una?” ");
INSERT INTO nrz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Beia Saulo ena ilolo ena siavu 'eva namana eao, inoku Damasekoai Iuda kauta demia kauta sia delalo to'ato'a Iesu 'eva Keliso ivamomo'ainai. ");
INSERT INTO nrz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Melala vaida deole mulinai, Iuda kauta dedo'u Saulo iaku bana lovana deakuia, ");
INSERT INTO nrz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","beia Saulo 'eva ia eta luvaluva 'ani eikabasi. Boni mai lani ia vanua alana nutualana deikaia kao Saulo beaku bala 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ia mulinai dedada'a kauta boni laloanai Saulo aleka laloanai deudaia ala akanai valoai deva'ovua. ");
INSERT INTO nrz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo eda'a Ielusalemai ela'asi koanai ia eula abiveni kauta ita bevaka'ona, beia ia boutai 'eva ia demakau venia 'olana sia devamomo'aia ia 'ani eabiveni dokadoka. ");
INSERT INTO nrz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Beia Banaba eta'u evada'ala deda'a veauneke kauta kevatai. Inoku Saulo Lovia namana dalai a eikaia koma, mai Lovia namana eta'u ia e'ouia luvata, maivaka Damaseko ai Iesu vanai eilolo mai kula'ilana ita luvata e'outa. ");
INSERT INTO nrz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kanaua 'ounai Saulo ua'i ia ita demia inoku Ielusalema bounai deda'aia kaiu, Iesu vanai eilolo mai kula'ilana ita. ");
INSERT INTO nrz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iuda kauta 'Elene malatai deluluva kauta Saulo ita deluvaluva mai deadedua, kanaua 'ounai deula beaku bala. ");
INSERT INTO nrz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bo'akalana deikabasia koanai, Saulo devuaia deda'a Kaisalea ua'i desinia eda'a Taso. ");
INSERT INTO nrz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Inoku Iudea, Kalilea mai Samalia kanota boutai laloatai Dilava ena lo'e kauta nua'elu deabia. Lovia namana makauna demakau inoku Idume Kabukabuna eduluta vitaitanai eta kula'ila 'eva ebata'ina mai Dilava ena lo'e kauta eta mato 'eva ele'au. ");
INSERT INTO nrz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petelo eda'a vanua ka ka laloatai ekeini eda'a Dilava ena kabukabu kauta Ludai kevatai ela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","'Abu kanaua'i 'eko kauna ka vana Aenea edavalia. Ia vikau kalavani 'eva kanaua boina eno. ");
INSERT INTO nrz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Inoku Petelo ia e'ouia ediaka, “Aenea e! Iesu Keliso 'ani evanama'inamu. Ko'isi, emu enokai davata lo'uta.” Komolonaimo Aenea eko'isi. ");
INSERT INTO nrz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Luda mai Salonai demia kauta boutai koa kanaua deikaia koanai, delalo 'udai deda'a Lovia namana kevana. ");
INSERT INTO nrz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iopa vanuanai abiveni ateatena ka emia, ia vana 'eva Tabita. ('Elene malatai 'eva Doleka.) Ia 'eva melala boutai vinaula nama'ita evavai mai ulalu kauta eduluta. ");
INSERT INTO nrz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Melala kanaua'i ia e'olele inoku eba. Kauanina devaidi'ua kave'i inoku aka daiutuna ka laloanai devaenoa. ");
INSERT INTO nrz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Luda mai Iopa viloata 'eva sia edau'a. Kanaua 'ounai Iopa ai abiveni kauta vaida deikabasi Petelo 'eva ua'i Luda ai, inoku deko'isi kau lua desinita deda'a Petelo kevana, denoia beda'a kaokao beda'a kevata. ");
INSERT INTO nrz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kanaua 'ounai Petelo eko'isi ia ita deda'a, inoku dela'asi koanai devuaia deda'a luma laloanai devaelea'au eda'a aka daiutunai. Obu vaida vaka ua'i delava dekani, Doleka maulinai laloanai ivadodo mai tubu'a ekulita tubu'ata kataua Petelo devaikala. ");
INSERT INTO nrz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petelo eta'u ia boutai esinita dela'asi inoku ekuidula emeamea. Mulinai ba ateatena evailala inoku ediaka, “Tabita e! Ko'isi.” Ia makana evaata Petelo eikaia inoku eko'isi emia divo. ");
INSERT INTO nrz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petelo eta'u imanai eabi inoku eduluia evalavala kole. Abiveni kauta mai obu e'aeta deasi kevana, ateate evamaulia ateatena evaikata. ");
INSERT INTO nrz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Vali kanania 'eva Iopa vanuana bounai laloanai deluvaia odaoda, inoku kau doutamo Lovia namana deabivenia. ");
INSERT INTO nrz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petelo 'eva Iopai bolomakau avata ekulita kauna vana Simona kevanai ua'i kena emia dau'a. ");
INSERT INTO nrz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisalea vanuanai Loma kuali kauna ka vana Konelio, Italia kuali kauta boutai sinavu ka (100) e'olavaita kauna. ");
INSERT INTO nrz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ia mai ena luma kauta boutai 'eva Dilava lelena daitai dedadai mai makauna demakau, ia ena dava doutamo Iuda kauta ulaluta eainama venita, maivaka melala boutai Dilava kevanai emeamea. ");
INSERT INTO nrz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Melala ka ado'alavuni avekenai melala koana koi boina, ia emakakeini 'eva Dilava ena anelu ka eikaia une easi ia ena lumai edodo 'eva e'ouia ediaka, “Konelio e.” ");
INSERT INTO nrz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ia mai makauna anelu eteia inoku elavuaia ediaka, “Lovia namana e, davaka dainai o'asi?” Anelu enu'ovi ediaka, “Emu meamea mai ulalu kauta oainama venita davata 'eva dele'au deasi Dilava vailanai vitaitana ainama ilalovaikaota davata boita. ");
INSERT INTO nrz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vali'u emu kau vaida sinita deda'a Iopa, kau ka vana Simona vana ivaluana 'eva Petelo be'oua ita be'asi. ");
INSERT INTO nrz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia 'eva Simona ka bolomakau avatai dava edeata edeata ekulita kauna ena 'abuai emimia, ena luma 'eva 'atu 'aba'abanai.” ");
INSERT INTO nrz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anelu luva kanaua eveni inoku eda'a mulinai, Konelio eta'u ena lumai da'alaabi kauta lalua mai kuali kauna ka Dilava lelena daitai edadai kauna e'aeta. ");
INSERT INTO nrz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konelio kevanai depulu davata boutai kau koina kataua e'outa mulinai, esinita deda'a Iopa. ");
INSERT INTO nrz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Elani ado'alavuninai kau kataua deasi Iopa 'ani dekevaia 'eva Petelo ele'au eda'a luma 'uvinai laani 'abunai ua'i bemeamea. ");
INSERT INTO nrz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Vikolo eakuia inoku eula iani kena beania, iani deva'olu do'o laloanai ia dava ka eikaia itani enivinivi boina. ");
INSERT INTO nrz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Vutuvutu eluvu eikaia mai dava ka tubu'a namavaikana boina kaiana si'ata vani iabi kaota e'ovu easi kanobata. ");
INSERT INTO nrz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ua'i tubu'a kanaua laloanai 'eva sisi aeta vani vani sisita boutai, kanoai delalau davata boutai mai akai delolovo manumanuta boutai iudata. ");
INSERT INTO nrz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Inoku lele ka ia e'ouia ediaka, “Petelo e, ko'isi, akuta anita.” ");
INSERT INTO nrz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Beia Petelo lele kanaua ena luva evamuea ediaka, “Lovia namana e, lau sia 'ani bavavaia, Dilava vailanai de'obu sisita 'o sia dekabukabu sisita asido'o ka ania kovo.” ");
INSERT INTO nrz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lele kanaua melala ivaluana ia e'ouia ediaka, “Dilava 'ani evamakamakata davata 'eva oni 'obuta sia bo'oulai.” ");
INSERT INTO nrz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Melala koi koa kanania epulu inoku komolonai tubu'a kanaua 'eva deabi muea eda'a vutuvutu. ");
INSERT INTO nrz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petelo makakeini anina kanaua ilalovainai nuana evabavunua laloanai, Konelio esinita kauta Simona ena luma dedavalia inoku deasi ena ala nutualana vailanai delavadivo. ");
INSERT INTO nrz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","De'ae lavuai dediaka, bema kau ka vana Simona, ia vana ka 'eva Petelo na'i emimia 'o asi'i? ");
INSERT INTO nrz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petelo makakeini kanaua elalovaia do'o laloanai Idume Kabukabuna eta'u ia e'ouia ediaka, “Simona e, kau koi 'eva oni dekavumu. ");
INSERT INTO nrz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ko'isi, 'ovu da'a kevata, ia ita oi bodada'a 'eva sia bolalo to'ato'a, 'olana lau ia asinita.” ");
INSERT INTO nrz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petelo e'ovu eda'a inoku kau kataua e'outa ediaka, “Oi okavua kauna 'eva lau kau'u kanania. Emui lalovai ka 'ounai oi o'asi, una?” ");
INSERT INTO nrz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Inoku ia ena luva devamuea dediaka, “Lai 'eva Konelio kuali kauta sinavu ka (100) e'olavaita kauna esinimai lai a'asi. Ia 'eva komolo kauna mai Dilava makauna emakau kauna inoku Iuda kauta boutai 'eva ia 'olana de'aku. Dilava ena anelu kabukabuna ka ia e'ouia oni daimuai bevisini boda'a ia ena luma, kanaua'i oni luva dava boluvala 'eva lelemu be'ika.” ");
INSERT INTO nrz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petelo eta'u kau kataua eabita dodo lumai deno. Elani 'avu'avuninai Petelo deko'isi inoku ia ita deda'a, Iopai abiveni kauta vaida vaka ia debanoia ita deda'a. ");
INSERT INTO nrz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Melala ivaluanai 'eva Kaisalea vanuanai dela'asi. Konelio 'eva kadi'a'ana mai ena kau umauta vaida eveauta ita demia bou Petelo de'imaia. ");
INSERT INTO nrz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petelo lumai eneke dodo laloanai Konelio ita devidavali inoku Petelo aena 'olanai epakadivo ekukudivo venia. ");
INSERT INTO nrz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Beia Petelo Konelio evelia isi 'eva e'ouia ediaka, “Ko'isi, lau 'eva kau mo oni boimu.” ");
INSERT INTO nrz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Laluana mai luvaluvata lumai deda'adodo laloanai ua'i kau doutamo demiado'u eikata. ");
INSERT INTO nrz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Inoku Petelo e'outa ediaka, “Oi oikabasi 'eva ita Iuda kauta eta talavatu 'eva pulu edea kauna ka ita sia ekamia ka'ona, maivaka sia ekada'a kevana. Beia Dilava eta'u lau evaika'u 'eva sia kau ka 'obuna 'o sia ekabukabu luvana baluvala kovo. ");
INSERT INTO nrz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kanaua 'ounai lau dai'uai oi ovisini koanai komolonai asi sia a'ouba'oa. Lau a'ula oi balavuaimui 'eva lau dai'uai dava ounai oi ovisini?” ");
INSERT INTO nrz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konelio ia ena luva evamuea ediaka, “Melala vani 'ani deda'a laloanai, ado'alavuni avekenai melala koana koi boina vitaitana vali'u boina 'eva lau e'u lumai ameamea laloanai komolonaimo kau ka tubu'ana de'amale'amalea elava vaila'uai aikaia. ");
INSERT INTO nrz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Inoku e'ou'u ediaka, ‘Konelio e, Dilava 'ani emu meamea leleta eika maivaka ulalu kauta oainama venita davata 'eva elalovaikao. ");
INSERT INTO nrz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kanaua 'ounai luva bosinia beda'a Iopa, kau ka vana Simona de'aea Petelo kevanai, ia 'eva kau ka vana Simona bolomakau avata ekuli kauna ena lumai emimia ua'i 'atu 'aba'abanai.’ ");
INSERT INTO nrz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kanaua 'ounai lau oni daimuai luva asinia kaokao evasi, inoku o'asi 'eva enama'ina. Vali'u lai boumaiai 'eva Dilava vailanai nia'i lai amiado'u, Lovia namana 'ani eluva pasisi venimu luvata boutai 'eva lai bo'oumai lelemu lai ba'ika.” ");
INSERT INTO nrz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petelo ena luva emakavala ediaka, “Luva umauna, vali'u lau aikabasi kave'i 'eva Dilava kau boutai dala vitaitanai eabita dae. ");
INSERT INTO nrz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Beia iduvu boutai laloatai Dilava makauna demakau kauta maivaka vinaula komolo devavai kauta 'eva Dilava betata'u beabita dae. ");
INSERT INTO nrz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dilava luva esinia eda'a Isalaela kauta kevatai 'eva oi oikabasi, Iesu Keliso enai nua'elu valina nama'ina eilolo vaia, ia 'eva kau boutai eta Lovia namana. ");
INSERT INTO nrz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Iudea kanobatanai dava namavaikata 'ani epulu davata 'eva katania, Ioane kau vailatai vaidi'u kabukabu eilolo vaia mulinai 'eva Kalilea ai demakava. ");
INSERT INTO nrz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dilava eta'u Iesu Nasaleta kauna evasiavua 'eva oi oikabasi, inoku Idume Kabukabuna mai siavu ia akanai eva'ovua, Iesu eda'a to'ato'a 'abuta boutai nama'ina vinaulata evavai mai Diabolo ena siavu venunai kauta boutai evanama'inata, 'olana Dilava 'eva ia ita. ");
INSERT INTO nrz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Iudea vanuata boutai laloatai mai Ielusalemai evavai davata boutai makamaiai lai aikata. Iuda kauta deta'u au ido'o valaukuna akanai dekokoia 'au eba. ");
INSERT INTO nrz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Beia melala ivakoinai Dilava eta'u Iesu ba ai evako'isia inoku evala'asia kau kevatai, ");
INSERT INTO nrz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sia kau boutai ia deikaia, beia lai Dilava 'ani edilamai kaumai mo lai aikaia. Ia ba ai eko'isi mulinai ia ita lai aniani maivaka vei lai ainu ka'ona kaumai kataua 'eva ia lai aluvasi vaia. ");
INSERT INTO nrz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ia lai e'oumai kau kevatai vali nama'ina lai bailolo vaia maivaka lai baluvasi 'eva Dilava eta'u ia edilaia mauli kauta mai ba kauta ivaluvata kaunai evaaoa. ");
INSERT INTO nrz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Enolea kauta boutai ia deluvasi vaia 'eva ia beabivenia kauta boutai 'eva ia vanai eta si'avana be'ou kao.” ");
INSERT INTO nrz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petelo luva katania eluva do'o laloanai, Idume Kabukabuna e'ovu kaiata devaala kauta kataua boutai akatai. ");
INSERT INTO nrz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iuda kauta Iesu deabivenia kauta Petelo debanoia ita deasi kauta kataua 'eva detabulovo si'asi'a 'eva Idume Kabukabuna ena ainama 'eva pulu edea kauta akatai vaka 'ani iva'ovuna, ");
INSERT INTO nrz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","'olana ia mala edeata edeatai deluvaluva leleta deika mai Dilava devanama'inala. Inoku Petelo ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kau katania 'eva Idume Kabukabuna 'ani deabia vitaitana ita 'ani kabia boina. Inoku dai ia be'outa kao veiai sia beidi'u kabukabu?” ");
INSERT INTO nrz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Petelo ia e'outa Iesu Keliso vanai beidi'u kabukabu. Inoku deidi'u kabukabu mulinai Petelo denoia melala vidamo ua'i ia ita bemimia. ");
INSERT INTO nrz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iudeai Veauneke kauta mai bo'akalana demimia kauta luva deika 'eva pulu edea kauta vaka Dilava ena luva 'ani deabia dae. ");
INSERT INTO nrz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kanaua 'ounai Petelo eda'a Ielusalemai koanai, Iuda kauta Iesu deabivenia kauta kataua ia de'ovenia, ");
INSERT INTO nrz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","dediaka, “Oni oda'a iva sia deabi kauta eta lumai inoku ia ita oi oaniani ka'ona.” ");
INSERT INTO nrz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petelo eta'u ia vailatai dava depulu davata boutai e'oulai kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ediaka, “Lau 'eva Iopa vanuanai ua'i ameamea inoku amakakeini 'eva vutuvutuai dava ka itani tubu'a namavaikana boina kaiana si'ata vani i'abi kaota e'ovu aikaia, inoku e'ovu easi keva'uai. ");
INSERT INTO nrz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Laloanai akaidodo 'eva kanobata sisita aeta vani vani, aivala sisita, kanobatai delalau davata mai akai delolovo manumanuta aikata. ");
INSERT INTO nrz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Inoku lele ka aika e'ou'u ediaka, ‘Petelo e, ko'isi, akuta anita.’ ");
INSERT INTO nrz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Beia ia ena luva avamuea adiaka, ‘Lovia namana e, lau sia 'ani bavavaia, lau asido'o de'obu davata 'o sia dekabukabu davata ka nutu'uai edodo.’ ");
INSERT INTO nrz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Beia melala ivaluana vutuvutuai lele kanaua ediaka, ‘Dilava 'ani evamakamakata davata 'eva oni 'obuta sia bo'oulai.’ ");
INSERT INTO nrz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Melala koi kanania epulu. Inoku dava kataua boutai 'eva develi 'au 'udai deda'a vutuvutu. ");
INSERT INTO nrz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Melala kanaua'i Kaisaleai kau koi desinita deasi keva'u kauta deasi lau amia lumanai delavadivo. ");
INSERT INTO nrz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Inoku Idume Kabukabuna e'ou'u ia ita lai badada'a sia ba'ouba'oa. Bo'akalata kalakoina katania vaka ita lai ada'a Kaisaleai kau ka vana Konelio ena lumai lai ada'adodo. ");
INSERT INTO nrz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ia e'oumai ediaka, anelu ka ena lumai evailaasi eikaia inoku ia e'ouia ediaka, ‘Kau ka vana Simona 'eva de'aea Petelo dainai bovisini beda'a Iopa. ");
INSERT INTO nrz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia betata'u luva beabia be'asi luvanai oni mai emu luma kauta boutai bevamaulimui.’ ");
INSERT INTO nrz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","E'u luva amakavala laloanai Idume Kabukabuna easi ia akatai e'ovu vitaitana makavanai easi ita akatai e'ovu boina. ");
INSERT INTO nrz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Inoku Lovia namana eluva luvana alaloia une, ‘Ioane veiai evaidi'u kabukabu, beia oi 'eva Idume Kabukabunai oi bovaidi'uta kabukabu.’ ");
INSERT INTO nrz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kanaua 'ounai Lovia namana Iesu Keliso deabivenia kauta kataua 'eva bema Dilava ita ainama evenita ainamana vitaitanai vaka ia evenita. Inoku lau kau a boi'u 'eva Dilava ena vinaula kanaua ba'alavua?” ");
INSERT INTO nrz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ia luva kanaua deika koanai eta 'ovede luvata devapuata inoku Dilava devanama'inala dediaka, “Dilava 'ani pulu edea kauta evalalota'udai inoku mauli evenita.” ");
INSERT INTO nrz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sitiveni deaku bala koanai abiveni kauta 'eva devaanaanata vaika inoku deda'a odaoda, vaida deda'a dau'adau'a deda'a Poenikia, Kupulo mai Antioka, Iuda kauta mo kevatai vali nama'ina deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Beia abiveni kauta vaida 'eva Kupulo mai Kulene kauta. Ia deda'a Antioka inoku pulu edea kauta kevatai Lovia namana Iesu valina nama'ina deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Lovia namana siavuna 'eva ia ita inoku kau doutamo vaika eta mauli deveni Lovia namana kevanai inoku ia deabivenia. ");
INSERT INTO nrz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ielusalemai Dilava ena lo'e kauta vali kanania deika, inoku Banaba desinia beda'a Antioka. ");
INSERT INTO nrz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ia Antiokai ela'asi koanai Dilava ena iulaveni koana eikaia, ia lalona denama, inoku ia boutai evakula'ilata mai nuata bounai Lovia namana beabivenia. ");
INSERT INTO nrz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba 'eva kau mediana, Idume Kabukabunai evonu mai ena abiveni namavaikana. Kanaua 'ounai kau doutamo eta mauli Lovia namana devenia. ");
INSERT INTO nrz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Inoku Banaba 'eva Saulo ikavuna eda'a Taso. ");
INSERT INTO nrz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Inoku edavalia koanai evuaia eda'a Antioka. Vikau ka itoina ia laluana ua'i abiveni kauta ita demiado'u maivaka kau doutamo devaikabasita. Ua'i Antiokai abiveni kauta vata de'aeta makava 'eva Keliso ena kau. ");
INSERT INTO nrz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Melala kanaua'i Ielusalemai enolea kauta vaida de'ovu deasi Antioka. ");
INSERT INTO nrz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kau kataua ka vana 'eva Akabo, eko'isi elavadivo inoku Idume Kabukabuna siavunai 'eva doe namavaikana kanobata itoinai bepupulu davana eluvaia 'ana'i. (Doe kanaua 'eva Kalaudio elovia melalanai epulu.) ");
INSERT INTO nrz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Antiokai abiveni kauta 'eva ka ka eta kula'ila vitaitanai deula vidulu besisini beda'a ia bo'akalata deabiveni kauta Iudea ai demimia kauta kataua kevatai. ");
INSERT INTO nrz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Inoku kanania boina devavaia. Banaba mai Saulo imatai ainama kataua desinita kole deabi deda'a 'ana'iavai kauta devenita. ");
INSERT INTO nrz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Melala kanaua'i Lovia 'olana kauna 'Eloda eta'u lo'e kauta vaida bevaanaanata si'asi'a 'ounai eabita. ");
INSERT INTO nrz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ia eta'u Ioane 'a'ana Iakobo kuali leponai ekala bala, ");
INSERT INTO nrz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ia vinaula kanaua'i Iuda kauta evalalonamata eikata koanai, ia eda'a Petelo vaka belioa. Nia 'eva Iuda kauta eta nadu vana Palaoa Sia Ivakubuna Naduna melalanai epulu. ");
INSERT INTO nrz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Elioia mulinai, vabuto'o lumanai e'alavua, kuali kauta 'ouka kalakoi imatai eudaia, vani vani be'imala. 'Eloda elalovaia 'eva nadu mulinai bevala'asia kau mato vailatai bevaluvala. ");
INSERT INTO nrz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kanaua 'ounai Petelo vabuto'o lumanai deabi 'inia, beia lo'e kauta 'eva ia dainai Dilava kevanai demeamea kula'ila. ");
INSERT INTO nrz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Belani koanai 'Eloda 'eva Petelo bevala'asia valuva vailanai inoku boninai Petelo 'eva seini luai dedo'oia inoku kuali kauta lua viloatai eno emuinai. Inoku kuali kauta lua nutuala aunai delava. ");
INSERT INTO nrz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Komolonai Lovia namana ena anelu evailaasi inoku 'ailalana ka daiutu laloana eduia, anelu eta'u Petelo panai eaku inoku evaibia 'eva e'ouia ediaka, “Ko'isi kaokao,” inoku ia imana 'ato'atotai seini de'eko asi. ");
INSERT INTO nrz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Anelu eta'u Petelo e'ouia ediaka, “Tubu'amu mai tamakamu vadodota.” Petelo koakoata evavai, inoku anelu ediaka, “Ivadodomu ai lope inoku muli'uai bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petelo anelu mulinai eda'a vabuto'o lumanai ela'asi, beia anelu evavai davata depulu dokadoka 'eva ia ovotai sia eovo, ia eko ia 'eva emakakeini. ");
INSERT INTO nrz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","'Ima kauta makavana mai ivaluana deda'ata vikani inoku deasi deda'a 'auli nutualana ekeini vanua namana kokona edada'a kanaua'i 'eva nutualana sibona eviluvu, inoku laluana dela'asi vanua dalana deda'aia deda'a koanai, komolonai anelu ia evikania. ");
INSERT INTO nrz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petelo nuana e'ailala 'eva ediaka, “Vali'u lau aikabasi komolo 'eva Lovia namana eta'u ena anelu esinia inoku 'Eloda ena siavu venunai mai Iuda kauta lau keva'uai bevavaia lalovaita davata boutai laloatai evamauli'u.” ");
INSERT INTO nrz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ia nuana e'eko'ovi koanai, komolonai eda'a Malia ena luma, Malia kanaua 'eva Ioane Maleko sinana, abiveni kauta doutamo ua'i deakubou inoku demeamea. ");
INSERT INTO nrz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petelo luma kanaua nutualanai eakuaku, inoku da'alaabi vatona ka vana Loda eda'a nutuala beikala. ");
INSERT INTO nrz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ia Petelo lelena eikaune koanai lalona denama keini vaika 'eva nutuala sia eluvuia, ia eveau emue'udai inoku e'outa ediaka, “Petelo 'eva nutualai elalava.” ");
INSERT INTO nrz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ia vato de'ouia dediaka, “Oni obobo'o!” Beia ia eluva kula'ila ua 'eva ia umauna. Kanaua 'ounai ia deluva dediaka, “Ama'i ua Petelo eikalakao aneluna.” ");
INSERT INTO nrz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Beia Petelo eakuaku do'o 'ounai nutuala deluvuia 'eva deikaia koanai, detabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petelo imanai e'outa kao 'uluta beasi'i, inoku Lovia namana vabuto'o lumanai a evala'asia koma luvana e'outa, maivaka e'outa ediaka, “Luva kanaua Iakobo mai bo'akalata kevatai oi boluva vaia. Inoku evikanita eda'a 'abu ka. ");
INSERT INTO nrz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","'Avu'avuni avulai kuali kauta sibota viloatai laloto'ato'a mai makau namavaikana epulu 'eva Petelo kevanai dava epulu 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","'Eloda e'outa bekavua, beia sia dedavalia, kanaua 'ounai i'imana kauta elavuaita inoku ena luvai deaku bata. Kanaua mulinai 'Eloda Iudea evikania eda'a Kaisaleai ua'i kena emia. ");
INSERT INTO nrz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","'Eloda 'eva Tulo mai Sidono kauta ebadu venita vaika, kanaua 'ounai boutai nuata devaka'onamoa beda'a ia kevana. Lava'ana'iana deda'a 'Eloda ena luma e'ola vaia kauna vana Balasto kevanai deva'amea beduluta, inoku deda'a 'Eloda kevanai nua'elu denoinoi vaia. 'Olana ia eta iani 'eva lovia 'olana kauna kanaua ena kanobatai de'asi. ");
INSERT INTO nrz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","'Eloda edilaia melalanai, ia eta'u ena lovia tubu'ana evadodoa inoku ena lovia imia'aunai emia'au 'eva kau eilolota. ");
INSERT INTO nrz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Inoku vanua kauta devaoi dediaka, “Nia 'eva dilava ka lelena, sia kau lelena.” ");
INSERT INTO nrz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Komolonai Lovia namana ena anelu 'Eloda eakuia, 'olana ia Dilava sia evanama'inala, inoku 'imolo'imolo ia kauanina deania 'eva eba. ");
INSERT INTO nrz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Beia Dilava ena luva 'eva ekula'ila inoku abiveni kauta numelana ekubu 'abu bounai edaonala. ");
INSERT INTO nrz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba mai Saulo desinita vinaulana bevavaia vinaulana kanaua devaolea koanai Ielusalema devikania, Ioane vana ka Maleko vaka devuaia ita demue'udai deda'a Antioka. ");
INSERT INTO nrz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioka ai lo'e kauta vaida 'eva enolea kauta mai vamalele kauta vata katania, Banaba, Simeona (avata 'umabobokota kauta), Lukio (Kulene kauna), Manaena ('Eloda ita de'aida'aida ka'ona kauna) mai Saulo. ");
INSERT INTO nrz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ia deta'u Lovia namana dekukudivo venia mai delove laloanai, Idume Kabukabuna e'outa ediaka, “Lau dai'uai Banaba mai Saulo oi boabita dae, lau adilata vinaulana bevavaia dainai.” ");
INSERT INTO nrz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Delove mai demeamea mulinai, imata ia laluana akatai dekao'au inoku desinita la'asi. ");
INSERT INTO nrz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Idume Kabukabuna eta'u Banaba mai Saulo esinita de'ovu deda'a Seleukia, ua'i aunakoiai dele'au dekeini deda'a Kupulo motumotunai. ");
INSERT INTO nrz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salami ai dela'asi koanai, Iuda kauta eta lo'e laloatai Dilava ena luva deilolo vaia. Ioane Maleko 'eva ia kevatai evidulu. ");
INSERT INTO nrz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Motumotu itoinai dekeinia deda'amo Papo ai dela'asi, ua'i Iuda kauta eta sinosino kauna mai enolea dedena kauna ka vana Baliesu dedavalia. ");
INSERT INTO nrz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ia 'eva motumotu kanaua ena Kavana kauna Selekio Paulo, nuakomolo kauna ena kau. Kavana kauna kanaua eta'u Banaba mai Saulo daitai luva esinia, 'olana ia eula Dilava ena luva 'uluna beika. ");
INSERT INTO nrz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Beia Baliesu vana ivaluana 'eva 'Elimasi ('Elene malatai anina 'eva sinosino kauna) sia eula Kavana kauna beabiveni 'ounai ia laluana e'alavuta. ");
INSERT INTO nrz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Beia Saulo, ia vana ivaluana 'eva Paulo, 'eva Idume Kabukabuna ai evonu, inoku sinosino kauna kanaua ete'inia, ");
INSERT INTO nrz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","e'ouia ediaka, “Oni 'eva Diabolo nakuna! Komolo vinaulata boutai eta 'ou kaumu, dede mai kau ilebata vinaulatai ovonu. Lovia namana ena luva umauta boutai 'eva dede ai ovaaota. ");
INSERT INTO nrz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Vali'u Lovia namana imana 'eva oni akamuai bene'ea 'au inoku makamu be'ede, melala kava'inamo melala 'ailalana sia boikala.” Komolonai 'Elimasi eonovaia vaitabu boita mai vabuto'o makana de'alavua, kau ekavuta imanai be'abi bevada'ala. ");
INSERT INTO nrz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kavana kauna koa kanaua epulu eikaia koanai, eabiveni, 'olana Lovia namana ena vaikabasi luvatai etabulovo si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo mai debanoia kauta ita Papo ai aunakoiai dele'au deda'a Peleka, Pamupulia kanonai dela'asi, ua'i Ioane Maleko ia evikanita emue'udai eda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulo mai Banaba Peleka ai deko'isi deda'a Pisidia kanona Antioka ai dela'asi. Ua'i melala kabukabunai deda'a Iuda kauta eta lo'eai deda'adodo inoku demiadivo. ");
INSERT INTO nrz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mose ena talavatu pukana mai enolea kauta deleleta pukata devakuta mulinai, Iuda kauta eta lo'e i'olavaina kauta luva desinia eda'a kevatai dediaka, “Bo'akalamai e, mai emui vakula'ila luvana ka kau katania daitai koanai, anoimui oi boluvala asi.” ");
INSERT INTO nrz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo eko'isi imanai koakoa evavaita inoku ediaka, “Isalaela kaumui mai oi pulu edea kaumui Dilava oi okukudivo venia kaumui e, lele'u oika. ");
INSERT INTO nrz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isalaela kauta eta Dilava eta'u kubuta 'ava'avata edilata inoku Aikupito ai demia laloanai kauta evavovo'o, maivaka ia ena siavu namavaikanai Aikupito ai evala'asita. ");
INSERT INTO nrz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Vikau vaninavui (40) boina kano'akunai kevatai evapasisi. ");
INSERT INTO nrz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ia eta'u Kanaana kanobatata kalakoika evavaita si'asi'a. Kanota ekoleta Isalaela kanotai deao vikau sinavu vani imanavui (450) boina laloanai. ");
INSERT INTO nrz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dava katania depulu mulitai, Dilava eta'u valuva kauta evenita be'ana'ia vaita easimo enolea kauna Samuela ena melalai. ");
INSERT INTO nrz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Inoku ia deta'u lovia 'olana ka denoinoi vaia 'eva Dilava eta'u Beniamina iduvuna kauna ka, Kisa nakuna Saulo evenita, vikau vaninavui elovia. ");
INSERT INTO nrz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dilava Saulo eabia ovo mulinai, Davida ia eta lovia 'olanai evaaoa. Ia eluva vaia ediaka, ‘Iese nakuna Davida 'ani adavalia lau nua'u eula venia kauna, ia 'eva lau aula vaita vinaulata boutai bevavaita.’ ");
INSERT INTO nrz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dilava ena luva'ana'i vitaitanai Davida ena pulu kaunai Isalaela kauta bevamaulita kauna evako'isia, kauna kanaua 'eva Iesu. ");
INSERT INTO nrz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Iesu ena vinaula asido'o emakavala laloanai, Ioane 'eva Isalaela kauta boutai kevatai lalo 'udai mai idi'u kabukabu eilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ioane ena vinaula 'ani bevaolea laloanai kau e'outa ediaka, ‘Oi olalovaia lau 'eva dai? Lau 'eva sia Keliso. Ia 'eva lau muli'uai e'asi, lau 'eva sia anama'ina vaika ia ena tamaka valota baluvuta.’ ");
INSERT INTO nrz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Bo'akala'u, Abela'amo kekena maivaka oi pulu edea kaumui Dilava makauna oi omakau kaumui e, Dilava eta'u vamauli luvana kanania esinia easi ita kevatai. ");
INSERT INTO nrz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ielusalema ai demimia kauta mai ia i'ana'ia vaita kauta Iesu sia deikaiaune. Inoku enolea kauta deleleia luvana melala kabukabuna boutai devakua luvana ovonai sia deovo. Kanaua 'ounai ia Iesu vinaula si'avana kaunai devaaoa 'eva enolea kauta eta luva ivamomo'aina vitaitanai. ");
INSERT INTO nrz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iesu bevabala dalana sia ka dedavalia, beia Pilato denoia beakubala. ");
INSERT INTO nrz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ia luvana puka kabukabunai deleleia vinaulata boutai devaoleta mulinai, au ido'o valaukuna akanai deabia ovo 'eva mitavai dekoleia. ");
INSERT INTO nrz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Beia Dilava eta'u ba ai evako'isia 'udai. ");
INSERT INTO nrz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Inoku melala doutamo ia ita Kalilea ai deda'a Ielusalema kauta kataua 'eva ia deikala. Vali'u kau kataua 'eva Isalaela kauta kevatai ia luvana deluvasi vaia. ");
INSERT INTO nrz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Inoku lai 'eva Dilava ita 'ava'avata kevatai eluva'ana'i vaia valina nama'ina kanaua lai abia a'asi oi kevamuiai lai aluvasi vaia. ");
INSERT INTO nrz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dilava eta'u Iesu ba ai evako'isia kanaua'i ita 'ava'avata kevatai ena luva'ana'i evamomo'aia. Salamo ivaluana laloanai vaka Iesu valina ekava ediaka, ‘Oni 'eva lau Naku'u. Vali'u melalanai lau 'eva oni Kamamu.’ ");
INSERT INTO nrz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dilava Iesu ba ai evako'isia, inoku mitava laloanai sia bepeda 'udai. Ua 'eva ia ena luva puka kabukabunai eluva vaia ediaka, ‘Davida kevanai aluva'ana'i vaia kabukabuna mai vanama'inana 'eva oi vaka bavenimui.’ ");
INSERT INTO nrz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Salamo ka laloanai vaka kanania eluva koma, ‘Emu Kabukabu Kauna 'eva sia bovapedala 'avaea.’ ");
INSERT INTO nrz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davida maulinai koanai, ia Dilava ena ula da'alata eabi, mulinai eba 'eva kubuna 'ava'avana kevatai dekoleia, inoku kauanina 'uliai epeda. ");
INSERT INTO nrz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Beia Dilava ba ai evako'isia 'udai kauna 'eva kauanina sia epeda. ");
INSERT INTO nrz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kanaua 'ounai bo'akala'u e, lai a'ula oi boikabasi 'eva Iesu dainai si'avana i'ou kaota valina 'eva oi kevamuiai lai ailolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Dilava eta'u Iesu deabivenia kauta kevatai komolo evenita, 'olana Mose ena talavatu 'abuta boutai laloatai komolo sia oi bodavalia. ");
INSERT INTO nrz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kanaua 'ounai oi bo'imamui kave'i 'eva enolea kauta deta'u deluva vaia davana 'eva kevamuiai sia bepupulu. Ia dediaka, ");
INSERT INTO nrz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘'Ouvo'ouvo kaumui, oi botabulovo si'asi'a inoku oi bobaba. Lau oi emui melalai dava ka bavavaia, bema kau ka be'oumui, beia sia 'ani oi boabivenia.’” ");
INSERT INTO nrz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo mai Banaba Iuda kauta eta lo'e ai dela'asi laloanai, kau ia denoita melala kabukabuna vailai 'eva dava kataua vaida vaka beluva vai. ");
INSERT INTO nrz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kukudivo eole mulinai, Iuda kauta doutamo mai pulu edea kauta Dilava dekukudivo venia kauta Paulo mai Banaba mulitai deda'a. Ia laluana kau kataua deluva venita inoku devakula'ilata Dilava ena iulaveni laloanai bemimia. ");
INSERT INTO nrz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Melala kabukabuna ivaluanai kevaimo vanua namanai demia kauta boutai deasi deakubou Dilava ena luva lelena be'ika. ");
INSERT INTO nrz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Beia Iuda kauta kau mato deikata koanai demama si'asi'a, Paulo eluva luvata deva'ekotau maivaka luva si'avata vaika de'ouia. ");
INSERT INTO nrz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Beia Paulo mai Banaba deluva kula'ila dediaka, “Lai atata'u Dilava ena luva oi lai a'oumui makava, beia sia oi oabivenia inoku sibomui si'avana 'abunai oi one'emui divo mauli keinikeini sia oi oula venia, kanaua 'ounai vali'u lai 'ani akai 'udai pulu edea kauta kevatai. ");
INSERT INTO nrz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Lovia namana lai kanania e'oumai koma, ‘Lau oni ane'emu divo pulu edea kauta eta ailalai bo'ao, maivaka vamauli boabia boda'a kanobata to'ona.’” ");
INSERT INTO nrz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pulu edea kauta luva kanaua deika koanai lalota denama inoku Lovia namana ena luva 'olana deaku. Mauli keinikeini dainai Dilava 'ani edilata kauta boutai 'eva deabiveni. ");
INSERT INTO nrz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Inoku Lovia namana ena luva 'eva kano kanaua itoina laloanai dekavaia odaoda. ");
INSERT INTO nrz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Beia Iuda kauta deta'u 'a'ate mai vata namata 'a'ateta ia Dilava makauna demakau mai vanua namana de'olavaia kauta nuata deani, Paulo mai Banaba devaiviivita inoku kano kanaua laloanai delo'ota asi. ");
INSERT INTO nrz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulo mai Banaba aeta apulolota deaku ovo 'eva vanua namana kauta kataua davaiviivita si'avanana koana inoku deda'a Aikonio. ");
INSERT INTO nrz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antiokai abiveni kauta kataua 'eva lalota denama mai Idume Kabukabunai devonu. ");
INSERT INTO nrz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulo mai Banaba Antiokai devavaia vitaitanai Aikonio ai vaka Iuda kauta eta lo'e laloanai deda'adodo inoku deilolo, Iuda kauta mai pulu edea kauta doutamo vaika deabiveni. ");
INSERT INTO nrz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Beia Iuda kauta vaida sia deabiveni kauta deta'u pulu edea kauta nuata deani inoku deabiveni kauta debadu venita. ");
INSERT INTO nrz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ia laluana ua'i kena demia dau'a inoku Lovia namana valina dekava kula'ila maivaka vatabulovo vinaulata mai koa namata devavaita, ua'i Lovia namana ena iulaveni ai ia luvana deilolo vaia davana evamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Vanua namana kauta sibota devi'alama, vaida Iuda kauta ita, vaida veauneke kauta ita. ");
INSERT INTO nrz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pulu edea kauta mai Iuda kauta ia i'ana'iavaita kauta ita delovaku veauneke kauta luana bevaanaanata inoku bika'ai beaku bata. ");
INSERT INTO nrz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Beia laluana luva deika koanai, deveau'ovo deda'a Lukaonia kanona laloanai Lusitela mai Delebe maivaka 'aba'abata vanuata. ");
INSERT INTO nrz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ua'i vali nama'ina deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ua'i Lusitela vanuanai 'eva 'ome kauna ka emia, ia epulu 'ome'ome 'ounai sia kena eda'a to'ato'a. ");
INSERT INTO nrz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Paulo eluvaluva laloanai kau kanaua kaiana evaala. Paulo ia ete'inia, inoku kau kanaua eikaia 'eva ena abiveni Dilava enai betata'u bevanama'inala. ");
INSERT INTO nrz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Eluva 'unu'unu ediaka, “Ko'isi lavadivo!” Komolonai kau kanaua elovo isi inoku aenai eda'a to'ato'a. ");
INSERT INTO nrz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kau mato Paulo deikaia koa kanaua evavaia koanai, Lukaonia malatai devaoi dediaka, “Dilava 'ani kauai deao de'ovu deasi ita kevatai.” ");
INSERT INTO nrz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Inoku Banaba vana de'aeia Seo, ua 'eva ia eta dilava ka vana, mai Paulo vana de'aeia 'Eleme, ua 'eva ia eta dilava ka vana vaka de'aeia 'olana ia 'eva luva iluvana kauna. ");
INSERT INTO nrz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Seo ena lo'e 'eva vanua namana nutualana auna vailanai, ena kabukabu kauna bolomakau labauta vaida maivelavelata evuata eda'a nutuala aunai, 'olana ia kau mato ita deula veauneke kauta kevatai ainama vinaulata bevavaita. ");
INSERT INTO nrz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Beia Paulo mai Banaba luva deika koanai, tubu'ata de'idita inoku kau mato viloatai deveau dodo, devaoi dediaka, ");
INSERT INTO nrz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kau e, koa kanania dava 'ounai oi ovavaia? Lai 'eva kau mo, vitaitana oi boimui. Lai vali nama'ina lai abia a'asi oi lai a'oumui 'eva dava si'avata vaikata katania kevatai oi bokai 'udai oi boda'a mauli Dilavana kevana, ia vutuvutu mai kanobata mai 'atu maivaka laloatai davata boutai evavaita kauna. ");
INSERT INTO nrz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","'Ana'ina melalanai Dilava kanobata ka ka kauta eikata vadae sibota eta ula dalatai demauli. ");
INSERT INTO nrz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Beia vinaula nama'ita ivavaitai 'eva ia ua'i sibona evala'asia, ena iulaveni evala'asia 'eva vutuvutuai lamu evaakua inoku kano ianita eta melala umautai, iani doutamo evenimui maivaka nuamui lalonamai evavonu.” ");
INSERT INTO nrz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Laluana luva kataua deluva beia kau mato ia kevatai ainama vinaulata devavai i'alavutai debavunu vaika. ");
INSERT INTO nrz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Beia Iuda kauta vaida Antioka mai Aikonio ai deasi inoku kau mato nuata deani 'eva Paulo bika'ai deakuia inoku develia deda'a vanua namana alana mulimulinai, delalovaia ia 'ani eba. ");
INSERT INTO nrz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Beia abiveni kauta Paulo delavaia kaiu koanai, ia eko'isi inoku emue'udai eda'a vanua namana laloanai edodo. Elani ia Banaba ita deda'a Delebe. ");
INSERT INTO nrz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo mai Banaba ua'i Delebe ai vali nama'ina deilolo vaia 'eva kau doutamo devuata deasi Iesu ibanona kautai devaaota. Kanaua mulinai demue'udai deda'a Lusitela, Aikonio mai Pisidia Antiokai. ");
INSERT INTO nrz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","'Abu kataua'i ia deta'u Iesu ibanona kauta devakula'ilata maivaka nuata devapasisita abiveni umaunai bemimia, de'outa dediaka, “Ita 'eva anaana doutamo laloatai ekadodo makava inoku Dilava ena lovia vanuanai ekada'adodo.” ");
INSERT INTO nrz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo mai Banaba Dilava ena lo'e ka ka laloatai 'eva 'ana'iavai kauta vaida dedilata inoku deloveai 'eva demeamea, Lovia namana deabivenia kauna imanai deudata. ");
INSERT INTO nrz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Laluana Pisidia kanonai deda'a keini deda'a Pamupulia kanonai dela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Inoku ua'i Pelekai vali nama'ina deilolo vaia mulinai, de'ovu deda'a Atalia vanuanai. ");
INSERT INTO nrz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ua'i laluana aunakoiai dele'au deveau demue deda'a Antioka, makavanai ua'i Antioka ai dedilata Dilava ena iulaveni laloanai bevinaula, inoku vali'u vinaula kanania 'ani devaolea. ");
INSERT INTO nrz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiokai dela'asi koanai, ia laluana deta'u lo'e kauta devado'uta, Dilava ia etai dava evavaia davata boutai mai pulu edea kauta kevatai abiveni dalana aboina eluvuia 'eva valita dekava. ");
INSERT INTO nrz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Inoku kauta laluana abiveni kauta ita ua'i kena demia dau'a. ");
INSERT INTO nrz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Iudeai abiveni kauta vaida deasi Antiokai abiveni kauta devaikabasita dediaka, “Mose ena talavatu vitaitanai iva sia oi boabia koanai oi 'eva vamauli sia oi boabia.” ");
INSERT INTO nrz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Luva kanaua 'ounai Paulo mai Banaba kau kataua ita deadedua eda'amo devina si'asi'a, kanaua 'ounai Dilava ena lo'e kauta deta'u Paulo mai Banaba deabita isi abiveni kauta vaida ita beda'a Ielusalema, ua'i veauneke kauta mai 'ana'iavai kauta kevatai luva kanaua belavuai lavuai vaia. ");
INSERT INTO nrz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dilava ena lo'e kauta deta'u ia desinita, Poenikia mai Samalia kanotai dekeini laloanai, pulu edea kauta eta mauli aboina deveni luvata deluva. Abiveni kauta boutai vali kanania deika 'eva delalonama si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ia Ielusalemai dela'asi koanai, Dilava ena lo'e kauta, veauneke kauta mai 'ana'iavai kauta deta'u ia deabitadae, inoku Paulo mai Banaba Dilava dava evavaia ia imatai davata boutai ia vailatai valina dekava. ");
INSERT INTO nrz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Inoku Palisea iduvunai abiveni kauta vaida deko'isi inoku dediaka, “Pulu edea kauta 'eva iva beabia maivaka Mose ena talavatu vitaitanai bedadai.” ");
INSERT INTO nrz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Veauneke kauta mai 'ana'iavai kauta deakubou mekau kanaua lovana deaku. ");
INSERT INTO nrz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Deluvaluva vaia dau'a mulinai, Petelo eko'isi inoku ediaka, “Bo'akala'u e, oi oikabasi 'eva siako Dilava eta'u oi viloamuiai lau edila'u 'eva pulu edea kauta nutu'uai vali nama'ina bakavala 'uluna be'ika inoku beabiveni. ");
INSERT INTO nrz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kau nuata eikabasita Dilavana eta'u ita kevatai evavaia vitaitanai pulu edea kauta vaka Idume Kabukabuna evenita, koa kanaua'i Dilava ia eabita isi kauna evamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ia mai ita viloata sia evaedeanata, eta abiveniai 'ounai ia nuata evamakamakata. ");
INSERT INTO nrz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vali'u dava 'ounai oi o'ula Dilava oi bovakovoa, ita 'ava'avata 'o ita sia 'ani ekavuala bedaia eveevena 'eva abiveni kauta 'atotai oi one'ea 'au? ");
INSERT INTO nrz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ita kabiveni 'eva Lovia namana Iesu ena iulaveni ai mauli ekaabia, vitaitanai ia vamauli deabia boina.” ");
INSERT INTO nrz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Do'u kauta boutai lele devunu laloanai, Banaba mai Paulo etai Dilava eta'u pulu edea kauta viloatai vatabulovo vinaulata mai koa namata evavaita luvata deluva vaita 'eva leleta deika. ");
INSERT INTO nrz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ia deluva koa koanai, Lovia namana kadina Iakobo eko'isi ediaka, “Bo'akala'u e, lele'u oika. ");
INSERT INTO nrz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simona 'ani ita e'outa kave'i Dilava eta'u pulu edea kauta kevatai ena lalovai a evala'asia makava koma mai ia viloatai kau eabita ia ena kauai evaaota. ");
INSERT INTO nrz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Luva kanania 'eva enolea kauta eta luva ita devitaita, kanania deleleia koma, ");
INSERT INTO nrz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kanania mulinai lau bamumue ba'asi inoku Davida ena aiole e'eko aiolena badaua 'udai. Demukamuka davata badauta 'udai mai bavalavala 'udai. ");
INSERT INTO nrz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kau kalina demauli kauta boutai mai pulu edea kauta kataua lau ata'u a'aeta lau e'u umautai be'ao kauta boutai 'eva lau Lovia namana bekavu'u. ");
INSERT INTO nrz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Lovia namana kanaua eluva koma, siako vaika luva kataua evaikabasivai.’ ");
INSERT INTO nrz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kanaua 'ounai lau alalovaia 'eva pulu edea kauta dekai 'udai Dilava kevana deda'ala kauta 'eva sia kama vamekauta. ");
INSERT INTO nrz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nama'ina 'eva kamalele venita inoku kama'outa, imatai devavaita dilavata deainama venita ianita Dilava vailanai 'ani de'obu ianita sia be'ani, sia bekulakula, mai sisi 'atotai dedo'o bata sisita sia be'ani, maivaka lalata sia be'inu. ");
INSERT INTO nrz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","'Olana Mose ena talavatu makavana melalanai easimo vali'u 'eva vanua boutai laloatai deilolo vaia maivaka melala kabukabuta boutai laloatai Iuda kauta eta lo'e ka ka laloatai devakuta.” ");
INSERT INTO nrz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Inoku veauneke kauta, 'ana'iavai kauta mai Dilava ena lo'e kauta boutai deula ia viloatai kau vaida bedilata inoku besinita Paulo mai Banaba ita beda'a Antioka, inoku dedilata kauta katania, Iuda vana de'aea Balasaba mai Sila, ia laluana 'eva bo'akalata viloatai kau i'ana'ia vaita kauta. ");
INSERT INTO nrz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Malele kanania boina deleleia 'eva da'a kauta devenita, “Lai veauneke kaumai mai 'ana'iavai kaumai, oi bo'akalamui, emai vanama'ina luvana evavasi oi bo'akalamai pulu edea kaumui Antiokai, Suliai mai Kilikiai oi omimia kaumui kevamui. ");
INSERT INTO nrz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Lai valimui 'ani lai aika 'eva banomai vaida nia'i devasi, eta luvai nuamui devaanaanata maivaka devabavunuta, beia lai sia luva kanaua boina ka lai avenita. ");
INSERT INTO nrz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kanaua 'ounai lai boumaiai lai avamomo'aia kau vaida lai badilata inoku lai basinita eta lalo'au kauta Banaba mai Paulo ita bevasi kevamui. ");
INSERT INTO nrz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Kau luana katania Banaba mai Paulo 'eva ita eta Lovia namana Iesu Keliso vana dainai eta mauli sia delalovaita. ");
INSERT INTO nrz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kanaua 'ounai Iuda mai Sila lai asinita maleleai lai aleleia luvata ivamomo'aita 'eva ia nututai beluvavaia. ");
INSERT INTO nrz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Enama'ina vaika Idume Kabukabuna eta'u lai evaikamai 'eva talavatu katania akatai sia mekau ka lai bane'ea 'au. ");
INSERT INTO nrz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Imatai devavaita dilavata deainama venita ianita sia oi bo'ani, sisi mai lalata sia oi bo'ani, sisi 'atotai dedo'o bata sisita sia oi bo'ani, maivaka sia oi bokulakula. Oi dava katania sia oi bovavai 'eva emui vinaula bekomolo. 'Ani lai alelelele koa. Kaeno.” ");
INSERT INTO nrz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Lo'e kauta deta'u kau katania desinita 'eva de'ovu deda'a Antiokai, ua'i abiveni kauta devado'uta inoku malele devenita. ");
INSERT INTO nrz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Malele devakua laloanai, vakula'ila luvata 'uluta deika 'eva lalota denama vaika. ");
INSERT INTO nrz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iuda mai Sila 'eva enolea kauta, abiveni kauta nuata devakula'ila maivaka vakula'ila luvatai kena deluva venita dau'a. ");
INSERT INTO nrz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ua'i kena demia dau'a mulinai, abiveni kauta deta'u ia mai nua'eluta ita desinita demue'udai deda'a Ielusalema ia desinita kauta kataua kevata. ");
INSERT INTO nrz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Beia Sila eula 'ounai emia.) ");
INSERT INTO nrz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo mai Banaba 'eva Antiokai demia, ua'i ia laluana mai kau doutamo itana Lovia namana valina devaikabasi vaia mai deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Melala vaida deole mulitai Paulo eta'u Banaba e'ouia ediaka, “Ita kamue'udai kada'a Lovia namana valina kailolo vaia vanuata kataua boutai laloatai ua'i bo'akalata a devavai koma ekaikata.” ");
INSERT INTO nrz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Inoku Banaba eula Ioane vana de'aea vaka Maleko 'eva bevuala ia ita beda'a ka'ona. ");
INSERT INTO nrz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Beia Paulo sia elalovaia komolo 'eva ia bevuala ia ita bedada'a 'olana ia ua'i Pamupuliai evikanita inoku sia emue'udai eda'a ia ita devinaula. ");
INSERT INTO nrz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kanaua 'ounai ia laluana deviala 'eva viloata e'alama. Inoku Banaba eta'u Maleko evuaia eda'a aunakoiai dele'au deda'a Kupulo. ");
INSERT INTO nrz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Beia Paulo eta'u Sila edilaia inoku bedada'a laloanai, bo'akalata deta'u Lovia namana ena iulaveni laloanai dene'eta 'au. ");
INSERT INTO nrz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ia laluana Sulia mai Kilikia kanotai dekeini deda'a, Dilava ena lo'e kauta ua'i devakula'ilata. ");
INSERT INTO nrz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo eda'a Delebe vakaia eda'a Lusitela ai ela'asi, ua'i abiveni kauna ka emia ia vana 'eva Timoteo, ia sinana 'eva Iuda ateatena mai abiveni ateatena, beia kamana 'eva 'Elene kauna. ");
INSERT INTO nrz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abiveni kauta ua'i Lusitela mai Aikonio ai demia kauta Timoteo ena nama'ina deluva vaia. ");
INSERT INTO nrz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo eula Timoteo bevuala ia ita bedada'a, mai eivaia 'olana ua'i Iuda kauta demimia kauta deikabasi ia kamana 'eva 'Elene kauna. ");
INSERT INTO nrz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Vanua ka ka laloatai dekeini laloanai, Ielusalemai veauneke kauta mai 'ana'iavai kauta devamomo'aita talavatu kataua 'eva ia deta'u kau de'outa talavatu kataua daitai bedadai. ");
INSERT INTO nrz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kanaua 'ounai Dilava ena lo'e kauta eta abiveni 'eva ekula'ila maivaka melala boutai eta mato 'eva ekukubu. ");
INSERT INTO nrz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo banona ita deda'a Pelikia mai Kalatia kanota laloatai dekeini 'olana Idume Kabukabuna eta'u e'outa kao 'Aisia kanonai Dilava ena luva sia beilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Deda'a Musia kanona vaikoanai dela'asi koanai, deula Bitunia kanona beda'ala, beia Iesu idumena e'outa kao. ");
INSERT INTO nrz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kanaua 'ounai Musia kanonai dekeini de'ovu deda'a Toloa vanuana. ");
INSERT INTO nrz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Boni kanaua'i Paulo emakakeini 'eva Makedonia kauna ka ia vailanai elava eikaia inoku ia enoia ediaka, “Bokeini bo'asi Makedoniai lai bodulumai.” ");
INSERT INTO nrz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo emakakeini mulinai, komolonai dala lai akavu lai bada'a Makedonia, 'olana to'onai lai aikabasi 'eva Dilava eta'u lai e'aemai vali nama'ina ua'i lai bailolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ua'i Toloai aunakoiai lai aele'au lai aveau keini komolo lai ada'a Samotlake. Inoku elani lai aveau lai ada'a Neapoliai lai ala'asi. ");
INSERT INTO nrz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","'Abu kanaua lai avikania lai ada'a Pilipo, ua 'eva Makedonia kanona vanuana namana lava'ana'ina maivaka Loma ena ikakao venunai emia. Inoku ua'i boni vaida lai amia. ");
INSERT INTO nrz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Melala Kabukabunai vanua namana nutualanai lai ala'asi ada'a lava 'aba'abanai, lai alalovaia 'eva meamea 'abuna ka ua'i. 'Abu kanaua'i lai amia divo inoku 'a'ate vaida ua'i demiado'u 'a'ateta ita lai aluvaluva. ");
INSERT INTO nrz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kaiata devaala lelemai deika 'a'ateta kataua ka vana 'eva Lidia, ena vanua 'eva Tuatila. Ia 'eva tubu'a 'aolata etavatavavaita. Ia vaka Dilava ekukudivo venia ateatena ka. Lovia namana eta'u nuana eva'ailalala inoku Paulo ena luva eabia dae. ");
INSERT INTO nrz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ia mai ena luma kauta boutai lai avaidi'uta kabukabu mulinai, enoimai lai bada'a ena luma, lai e'oumai ediaka, “Bema oi olalovaia lau Lovia namana abivenia ateate'u koanai, oi bo'asi ua'i e'u lumai oi bomimia.” Inoku ia lai eva asiasimai lai ada'a ia ena luma. ");
INSERT INTO nrz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Melala ka lai ada'a meamea 'abuna laloanai, da'alaabi vatona ka nuanai ka'uba si'avana vaika emia vatona ita lai avidavali. Vato kanaua 'eva vailai bepupulu davata e'ou asita, vinaula kanaua'i ia ena 'ola kauna ena moni doutamo evavai. ");
INSERT INTO nrz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Vato kanaua Paulo mai lai boumaiai mulimaiai eda'a 'eva evaoivaoi ediaka. “Kau katania 'eva akai vaika Dilavana ena da'alaabi kauta, oi kevamuiai bevamaulimui dalana deluva vaia.” ");
INSERT INTO nrz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Melala doutamo ia kanaua boina evavaia. Inoku Paulo kaiana evabo'o 'ounai elava 'udai ka'uba si'avana vaika e'ouia ediaka, “Iesu Keliso vanai lau a'oumu dokadoka, vato kanana nuanai la'asi!” Komolonai ka'uba si'avana vaika vato evikania ela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vato ena 'ola kauna eikabasi ia ena moni davali dalana 'ani eole koanai, Paulo mai Sila deabita deliota inoku develita deda'a tavatava 'abunai 'ana'iavai kauta vailatai. ");
INSERT INTO nrz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Valuva kauta vailatai devalavata inoku dediaka, “Kau luana katania 'eva Iuda kauta, inoku ita eta vanua laloanai devasi'avanala. ");
INSERT INTO nrz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Maivaka koakoa devaikabasita davata 'eva ita Loma kauta eta talavatu avekenai sia kabidae mai sia kamaulivai davata.” ");
INSERT INTO nrz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Do'u kauta deko'isi Paulo mai Sila de'ou si'ata, inoku valuva de'ana'ia vaia kauta deluva ia laluana eta tubu'a be'idita inoku 'odi'odi auna ai be'odita. ");
INSERT INTO nrz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","De'odi si'ata mulinai, devuata deda'a vabuto'o lumanai dedolita dodo, vabuto'o lumana e'imala kauna de'ouia be'imata kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Vabuto'o lumana i'imana kauna kanaua boina de'ouia 'ounai ia laluana evuata eda'a laloai vaika daiutuna laloanai evadodota, au ubata viloatai aeta eva'akuta uda edo'o 'inita kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Boni malolua laloanai Paulo mai Sila 'eva demeamea mai Dilava ivanama'inana masita deabi, inoku vabuto'o kauta 'eva kaiata devaala ia leleta deika. ");
INSERT INTO nrz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Komolonai kanokau namavaikana epulu 'eva vabuto'o lumana itoina euteute, nutuala boutai deviluvu mai vabuto'o kauta boutai imata aeta dedo'ota 'eva deodi. ");
INSERT INTO nrz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Vabuto'o lumana e'imala kauna muinaitabunai eibi, inoku nutuala boutai deviluvu eikata koanai, eko'isi ena kuali lepona evelia asi sibona beaku bala 'olana ia elalovaia vabuto'o kauta 'ani deveau ovo. ");
INSERT INTO nrz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Beia Paulo evaoi 'unu'unu ediaka, “Ovapuala! Sibomu sia oi boaku bamu, lai boumaiai 'eva nia.” ");
INSERT INTO nrz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Vabuto'o lumana e'imala kauna lamepa 'ae'aena e'ae'ae, inoku eveau dodo eda'a 'eva mai 'ululu 'ululuna Paulo mai Sila vailatai ekuidula. ");
INSERT INTO nrz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Inoku evuata ela'asi eda'a mulimuliai elavuaita ediaka, “Loviamui e, dava bavavaia 'eva vamauli badavalia?” ");
INSERT INTO nrz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ia laluana de'ouia dediaka, “Lovia namana Iesu boabivenia 'eva vamauli boabia oni mai emu luma kauta boutai.” ");
INSERT INTO nrz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Inoku laluana Lovia namana ena luva ia mai ena luma kauta boutai kevatai deilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Boni kanaua'i laluana evuata eda'a, deakuta pau'apau'a 'abuta edeinita kave'i, inoku komolonai Paulo mai Sila deta'u ia mai ena luma kauta boutai devaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Vabuto'o lumana i'imana kauna ia laluana evuata eda'a ena lumai evananita, inoku ia mai ena luma kauta boutai delalonama 'olana Dilava deabivenia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Elani 'avu'avuni laloanai, valuva de'ana'ia vaia kauta deta'u kau 'uma'umata desinita deda'a vabuto'o lumana i'imana kauna kevanai de'ouia dediaka, “Kau katana bovala'asita bedada'a.” ");
INSERT INTO nrz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Vabuto'o lumana i'imana kauna Paulo e'ouia ediaka, “Valuva de'ana'ia vaia kauta luva deveni 'eva oni mai Sila bavala'asimui oi bodada'a, vali'u oi bola'asi mai nua'elumui oi bodada'a.” ");
INSERT INTO nrz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Beia Paulo kau 'uma'umata e'outa ediaka, “Lai 'eva Loma kaumai, ia valuva 'abunai lai sia devalavamai emai va'eva ka dedavalia beia kau vailatai deakumai 'avaea inoku vabuto'o lumanai de'alavumai. Inoku vali'u de'ula vunivuniai lai bevala'asimai, una? Sia bedaia, ia sibota be'asi lai bevala'asimai.” ");
INSERT INTO nrz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kau 'uma'umata kataua demue deda'a valuva de'ana'ia vaia kauta kevatai de'outa ia laluana 'eva Loma kauta, luva kanania deika koanai demakau si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Valuva de'ana'ia vaia kauta deko'isi deda'a laluana kevatai de'outa kave'i asi'i demabadu, inoku vabuto'o lumanai devala'asita, denoita vanua kanaua bevikania. ");
INSERT INTO nrz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo mai Sila vabuto'o lumanai dela'asi mulinai, deda'a Lidia ena luma ua'i abiveni kauta vaida ita devidavali, devakula'ilata inoku devikanita deda'a. ");
INSERT INTO nrz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo mai Sila deda'a Amepipoli mai Apolonia kanotai dekeini deda'a Tesalonika, ua'i 'eva Iuda kauta eta lo'e ka. ");
INSERT INTO nrz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo ena koakoa dainai, eda'a lo'e laloanai edodo. Ua'i melala kabukabuta koi laloatai kau ita delovaku Puka Kabukabunai deleleia luvata umautai eluvaluva, ");
INSERT INTO nrz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","eluvavaita kave'i mai luvata evala'asita kave'i Keliso 'eva beanana mai ba ai beko'isi 'udai, ediaka, “Iesu kanania oi kevamuiai lau valina akakava kauna 'eva Keliso.” ");
INSERT INTO nrz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iuda kauta vaida nuata devadai Paulo mai Sila ita devaka'onamo, 'Elene kauta Dilava makauna demakau kauta doutamo vaka ia ita devaka'onamo maivaka lovia 'a'ateta doutamo vaka ia ita devaka'onamo. ");
INSERT INTO nrz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Beia Iuda kauta vaida 'eva demama, kanaua 'ounai tavatava 'abunai mia 'avaea kauta eta koa desi'avana vaika kauta vaida devalalota, kau doutamo devabouta 'eva vanua namana laloanai viala namavaikana devapulua. Deda'a molaumolau maibaduta kau ka vana Iasoni ena lumai Paulo mai Sila bekavuta bevuata bela'asi kau mato vailatai. ");
INSERT INTO nrz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Beia sia dedavalita 'ounai Iasoni mai abiveni kauta vaida luma kanaua'i develita asi devuata deasi vanua namana de'olavaia kauta vailatai, devaoi dediaka, “Kau vaida kanobata itoinai devalipulipua kauta vali'u 'ani deasi eta vanua namana laloanai, ");
INSERT INTO nrz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","inoku Iasoni eabita dae ena lumai evadodota. Kau kataua 'eva Kaisala ena talavatu deva'alamala, ia dediaka 'eva Lovia 'olana edeana ka emimia, ia vana 'eva Iesu.” ");
INSERT INTO nrz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kau mato mai vanua namana de'olavaia kauta luva kanania deika koanai, 'ulu namavaikana devavuala. ");
INSERT INTO nrz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Vanua namana de'olavaia kauta deta'u Iasoni mai banona ita de'outa moniai valuva tavana deveni inoku devikanita deda'a. ");
INSERT INTO nrz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Boni kanaua laloanai abiveni kauta deta'u Paulo mai Sila desinita deda'a Belea. Ua'i dela'asi koanai, komolotai deda'a Iuda kauta eta lo'e. ");
INSERT INTO nrz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Iuda kauta Beleai demimia kauta kataua 'eva maieta leleika vakaia Tesalonika kauta, nuata umautai vali nama'ina deika inoku melala boutai Puka Kabukabuna luvata demalele vaita beikabasi Paulo eluva luvata 'eva momo'ai. ");
INSERT INTO nrz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kanaua 'ounai ia doutamo deabiveni, 'Elene lovia 'a'ateta doutamo mai 'Elene kauta doutamo vaka deabiveni. ");
INSERT INTO nrz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Beia Iuda kauta Tesalonikai demimia kauta luva deika Paulo 'eva Dilava ena luva Belea laloanai eilolo vaia koanai, ia deasi ua'i kau mato nuata deani va'eva devapulu. ");
INSERT INTO nrz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Komolonaimo abiveni kauta deta'u Paulo desinia 'atu duasi eda'a, beia Sila mai Timoteo 'eva Beleai demia. ");
INSERT INTO nrz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Kau vaida Paulo devuaia deda'a Atene, inoku ia 'eva demue deda'a Belea, Paulo ena luva deabia deda'a Sila mai Timoteo kevatai beda'a kaokao beda'a Paulo kevana. ");
INSERT INTO nrz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo 'eva Sila mai Timoteo Ateneai e'imata laloanai, vanua namana laloanai dilava dedeta evonu vaika eikata 'eva nuana eanana vaika. ");
INSERT INTO nrz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kanaua 'ounai Paulo Iuda kauta eta lo'e laloanai Iuda kauta mai 'Elene kauta Dilava makauna demakau kauta ita delovaku, maivaka melala bounai dedada'a ua'i tavatava 'abunai kauta ita delovaku. ");
INSERT INTO nrz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikulo kauta mai Stoiko vaikabasi kauta vaida Paulo ita devi'oudoli. Vaida delavuai dediaka, “Luva 'avaea 'avaea kauna kanania dava e'oua?” Vaida dediaka, “Ia 'eva kanobata edeata dilavata lovata e'aku.” Luva kanania deluvaia 'olana Paulo 'eva Iesu mai ena ko'isi 'udai valina nama'ina eilolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kanaua 'ounai Paulo deabia devuaia deda'a do'u 'abuna ka vana Aleopako, ua'i de'ouia dediaka, “Lai a'ula lai baikabasi oni vaikabasi makamakana kanania davana lovana oakua? ");
INSERT INTO nrz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Dava vaida o'oulai lai kevamaiai 'uluta lai aika 'eva dedeana vaika, kanaua 'ounai lai a'ula lai baikabasi dava kataua anita 'eva dava.” ");
INSERT INTO nrz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atene kauta boutai mai 'abu edea kauta ua'i demimia kauta 'eva sia dava edeata vaida lovata de'aku, ia melala bounai dava makamakata valita de'ika mai lovata de'aku.) ");
INSERT INTO nrz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo 'eva Aleopako kauta dedo'u vailatai eko'isi elavadivo inoku eluva ediaka, “Oi Atene kaumui e, lau aikamui 'eva oi okula'ila vaika kukudivo vinaulata dalata boutai laloatai. ");
INSERT INTO nrz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","E'u da'a to'ato'a emui vanua namana laloanai emui kukudivo 'abuta aikata laloanai, emui kabukabu vakana ka akanai kanania boina deleleia ‘Sia kaikabasi Dilavana kevana’ davana adavalia. Oi sia oikabasia kauna oi okukudivo venia, 'ounai vali'u oi kevamuiai bailolo vaia. ");
INSERT INTO nrz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Dilava kanobata mai laloanai davata boutai evavai kauna 'eva vutuvutu mai kanobata Loviana namana inoku kau imatai devavai lo'eta laloatai sia emimia. ");
INSERT INTO nrz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Maivaka ia sia dava ka etatabu ita dava imatai kamavenia davana sia elalovaia, 'olana ia sibona mauli, ladae mai dava edeata edeata boutai eveveni kau boutai kevatai. ");
INSERT INTO nrz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kau ka'onamo enai kanobata kauta boutai evavaita 'eva kanobata itoina akanai bemimia. Ia sibona eta'u ia eta melala mai eta mia 'abuta umauta eva'olu makava. ");
INSERT INTO nrz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dilava vinaula katania evavai 'eva kau boutai be'asi ia bekavua 'eva bedavalia, luva umauna Dilava ita ka ka kevatai 'eva sia edau'a. ");
INSERT INTO nrz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kau vaida kanania deluva koma, ‘Ia enai kamauli, ka'iuvai'iuvai mai kamimia.’ Itani emui sisiba kao kauta deluva boina, ‘Ita 'eva ia nakuna.’ ");
INSERT INTO nrz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Inoku ita Dilava nakuna melalanai, Dilava 'eva sia kolo 'o siliva 'o bika'a aoneka kauta imatai devavaita kataua boitai ekavaoa. ");
INSERT INTO nrz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“'Ana'inai Dilava 'eva kau ia sia deikabasia koanai, eta bo'o 'eva eikata vadai, beia vali'u 'eva 'abu boutai kau boutai e'outa pasisi belalo'udai. ");
INSERT INTO nrz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ia valuva melalana ka 'ani eva'olua, ia 'ani edilaia kauna betata'u kanobata itoina dala komolonai bevaluvala. Dilava eta'u kau kanaua ba ai evako'isia 'udai 'eva vinaula kanania kau boutai vailatai evamomo'aia.” ");
INSERT INTO nrz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bai ko'isi 'udai luvana Paulo eluvavaia deika koanai, kau vaida ia demamai vaia, beia vaida dediaka, “Lai a'ula luva katania boluvavai lai baika 'udai.” ");
INSERT INTO nrz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kanaua'i Paulo ia evikanita eda'a. ");
INSERT INTO nrz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kau vaida deabiveni inoku Paulo ita deda'a. Ia viloatai 'eva valuva kauna ka vana Dionusio, ia valuva 'abuna Aleopako de'olavaia kauta ka, maivaka ateate ka vana Damali mai kau vaida vaka deabiveni. ");
INSERT INTO nrz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kanaua mulinai Paulo Atene vanuana evikania eda'a Kolinto vanuana. ");
INSERT INTO nrz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ua'i ia Iuda kauna ka Pontoai epulu kauna vana Akuila ita devidavali, ualavi mo adana Plisila ita Italiai deasi, 'olana melala kanaua'i lovia 'olana kauna vana Klaudio luva eveni Iuda kauta boutai Loma bevikania. Paulo eda'a ia beikata, ");
INSERT INTO nrz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ua'i ia ita demia mai devinaula, 'olana ia 'eva aiole ivavaita kauna vitaitana ia laluana boita. ");
INSERT INTO nrz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Melala kabukabuta boutai 'eva Paulo eda'a Iuda kauta eta lo'e laloanai delovaku, eula Iuda kauta mai 'Elene kauta nuata beva'ailalata. ");
INSERT INTO nrz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila mai Timoteo Makedoniai deasi koanai, Paulo ena melala itoinai eveni iloloai vali nama'ina eilolo vaia, Iuda kauta kevatai eluvasi Iesu 'eva Keliso. ");
INSERT INTO nrz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Beia Iuda kauta Paulo ena luva deakuavu mai kevanai luva si'avata vaika deluva koanai, ena tubu'a apulolota eakuakuta ovo inoku e'outa ediaka, “Oi bobaba koanai ua 'eva oi sibomui emui va'eva, lau vuvuana sia bakoala. Vali'u vaila eda'ala melalanai lau 'eva pulu edea kauta kevata bada'ala.” ");
INSERT INTO nrz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Inoku Iuda kauta eta lo'e evikania eda'a pulu edeana kauna ka vana Tito Iusto ena lumai ua'i bemimia, ia 'eva Dilava ekukudivo venia kauna ka, inoku ena luma 'eva Iuda kauta eta lo'e kevanai. ");
INSERT INTO nrz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Iuda kauta eta lo'e e'olavaia kauna Kelisopo mai ena luma kauta boutai ita Lovia namana deabivenia maivaka Kolinto kauta doutamo vaka Paulo eilolo lelena deika 'eva deabiveni inoku devaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Boni kai Paulo emakakeini 'eva Lovia namana ia eluva venia ediaka, “Sia bomakau, boluluva mo, lele sia bovuvunu. ");
INSERT INTO nrz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","'Olana lau 'eva oni ita 'ounai, sia kau ka oni bevasi'avanamu, vanua namana kanania laloanai lau e'u kau 'eva dounamo.” ");
INSERT INTO nrz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kanaua 'ounai Paulo vikau ka mai vuia kalakoi ua'i emia, Dilava ena luva kau evaikabasita. ");
INSERT INTO nrz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kalio 'eva Akaia kanona eta kavana laloanai, Iuda kauta devaka'ona Paulo deabia devuaia deda'a valuva 'abunai. ");
INSERT INTO nrz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Deluva dediaka, “Kau kanania 'eva Iuda kaumai emai talavatu eukua, kau nuata e'ani Dilava dala edeatai bekukudivo venia.” ");
INSERT INTO nrz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo 'ani beluluva laloanai, Kalio eta'u Iuda kauta e'outa ediaka, “Oi Iuda kaumui e, bema kau kanania va'eva evavai 'o koakoa si'avata vaika evavai koanai, lau oi lelemui bama ika diba. ");
INSERT INTO nrz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Beia nia 'eva luva mai va mai oi sibomui emui talavatu oi oadedua vaita koanai, oi sibomui oi bovakomoloa. Lau dava katana boita 'eva sia avaluvata.” ");
INSERT INTO nrz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Inoku ia eta'u Iuda kauta valuva 'abunai evala'asita. ");
INSERT INTO nrz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ia boutai deko'isi Iuda kauta eta lo'e e'olavaia kauna Sosotene deabia kao valuva 'abuna vailanai deaku si'ala. Beia Kalio 'eva koa kanaua lovana sia eakuia. ");
INSERT INTO nrz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo Kolintoai kena emia dau'a mulinai, bo'akalana evikanita inoku Plisila mai Akuila 'eva ia debanoia ita aunakoiai bekeini Sulia beda'ala. Asido'o aunakoiai deveau asi laloanai Kenakelea vanuanai vuina itoina detalia ovo 'olana luva'ana'i ka Dilava vailanai evavaia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Epesoai dela'asi laloanai, Paulo eta'u Plisila mai Akuila ua'i evikanita. Ia sibona eda'a Iuda kauta eta lo'eai eda'adodo ua'i Iuda kauta ita delovaku. ");
INSERT INTO nrz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Iuda kauta Paulo denoia ia ita kena bemia dau'a koanai, ia sia eula. ");
INSERT INTO nrz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ia 'ani bedada'a laloanai, e'outa ediaka, “Bema Dilava ena ulai koanai bamue'udai ba'asi kevamui.” Inoku aunakoiai ele'au Epeso evikania. ");
INSERT INTO nrz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulo Kaisaleai ela'asi koanai, eda'a Ielusalemai ua'i Dilava ena lo'e kauta vanama'ina luvana evenita inoku e'ovu eda'a Antioka. ");
INSERT INTO nrz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ua'i Antiokai kena emia dau'a mulinai, eda'a Kalatia mai Pulukia kanota itoinai laloanai eda'a 'abu ka ka laloatai abiveni kauta boutai evakula'ilata. ");
INSERT INTO nrz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iuda kauna ka vana Apolo, ia 'eva Alesandeleai epulu kauna, easi Epeso. Ia 'eva luvaluva kave'i kauna maivaka Puka kabukabuna luvata eikabasita kave'i kauna. ");
INSERT INTO nrz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ia 'eva Lovia namana ena dalai devaikabasi vaia, inoku Iesu valina nama'ita komolota evaikabasivai mainuana umauna ita eilolovai, beia ia 'eva Ioane ena vaidi'u kabukabu mo eikabasia. ");
INSERT INTO nrz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ia Iuda kauta eta lo'e laloanai eilolo kula'ila. Plisila mai Akuila ia lelena deika koanai, devuaia deda'a ia eta lumai inoku Dilava ena dala ia kevanai deluva vaia kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo eula beda'a Akaia vanuana koanai, Epesoai abiveni kauta deko'isi ia devakula'ilala mai malele ka deleleia eda'a Akaiai abiveni kauta kevatai uai ia edada'a koanai beabiadae. Ia ua'i ela'asi koanai, Dilava ena iulaveniai deabiveni kauta kataua 'eva eduluta namavaikana. ");
INSERT INTO nrz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ia ena luva kula'ilai 'eva kau vailatai Iuda kauta eta luva eva'ekotau, ia Puka kabukabuna luvanai evamomo'aia Iesu 'eva Keliso. ");
INSERT INTO nrz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo Kolintoai emia laloanai, Paulo 'eva Asia kanona lolota bo'adatai ekeini eda'a Epesoai ela'asi. Ua'i abiveni kauta vaida ita devidavali. ");
INSERT INTO nrz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paulo elavuaita ediaka, “Oi oabiveni koanai Idume Kabukabuna oi oabia, una?” Ia dediaka, “Asi'i. Lai 'eva Idume Kabukabuna luvana 'uluna sia ka lai aika kovo.” ");
INSERT INTO nrz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Inoku ia elavuaita 'udai ediaka, “Vaidi'u kabukabu davanai devaidi'umui kabukabu?” Ia deluva dediaka, “Ioane eluva vaia vaidi'u kabukabunai devaidi'umai kabukabu.” ");
INSERT INTO nrz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo ediaka, “Ioane ena vaidi'u kabukabu 'eva lalo'udai koana. Ioane kau e'outa ia mulinai e'asi kauna beabivenia, ua 'eva Iesu.” ");
INSERT INTO nrz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Luva kanaua deika koanai, Lovia namana Iesu vanai evaidi'uta kabukabu. ");
INSERT INTO nrz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo imana ia akatai ekao'au koanai, Idume Kabukabuna easi ia akatai, inoku mala edeata edeatai deluvaluva maivaka denolea Dilava enai luvata deluvavaita. ");
INSERT INTO nrz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ua'i 'eva kau boutai 'ouka lua boina. ");
INSERT INTO nrz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Vuia koi laloatai Paulo Iuda kauta eta lo'e laloanai edodo kau kevatai Dilava ena lovia vanuana valina eilolovaia mai evaikabasi vaia kula'ila. ");
INSERT INTO nrz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Beia kau vaida 'eva nuata depasisi, sia deabiveni maivaka kau boutai vailatai Iesu iabivenina Dalanai luva si'avata vaika deluva. Kanaua 'ounai Paulo kau kataua evikanita, abiveni kauta mo evuata deda'a Tulano malelena lumana laloanai ua'i melala bounai evamaleleta. ");
INSERT INTO nrz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Vikau lua 'eva ua'i evamalele, kanaua 'ounai Iuda kauta mai 'Elene kauta Asia kanonai demimia kauta boutai Lovia namana luvana deika. ");
INSERT INTO nrz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dilava eta'u siavu Paulo evenia vatabulovo vinaulata edeata vaika bevavai. ");
INSERT INTO nrz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kau Paulo ena muko mai ena tubu'a liolio kauaninai demia tubu'ata deabita deda'a 'olele kauta akatai dene'e'au 'eva eta 'olele denama'ina maivaka ka'uba si'avata vaika nuatai dela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Iuda kauta vaida eta vinaula 'eva vanua laloatai deda'a to'ato'a inoku dekovokovo Lovia Namana Iesu vana de'ouia kau nuatai ka'uba si'avata vaika delo'ota asi. Kanania de'outa koma, “Paulo eilolo vaia kauna Iesu vanai a'oumu pasisi. La'asi!” ");
INSERT INTO nrz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iuda kauta eta kabukabu kauta 'olatai kauna Sikeva nakuna kalakoika 'eva vinaula kanania devavaia. ");
INSERT INTO nrz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Melala ka ka'uba si'avana vaika eta luva evamuea ediaka, “Lau Iesu aikabasia, inoku Paulo vaka aikabasia. Beia oi 'eva dai?” ");
INSERT INTO nrz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Inoku kau nuanai ka'uba si'avana vaika emimia kauna kanaua ia akatai elovo 'au mai ena siavu boutai ekeinita. Ia eaku si'ata 'eva mai'okota mai mailalalalata ena lumai deveau la'asi. ");
INSERT INTO nrz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Iuda kauta mai 'Elene kauta Epesoai demimia kauta vali kanania deika koanai, boutai demakau si'asi'a, inoku Lovia namana Iesu vana 'eva aka umaunai deakuia abalai. ");
INSERT INTO nrz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Abiveni kauta doutamo deasi inoku eta si'avana devavai si'avanata kau vailatai de'ou asi. ");
INSERT INTO nrz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ua'i sinosino kauta doutamo eta mena pukata devuata deasi kau vailatai detouta. Puka kataua tavata devakuta 'eva siliva monina imanavui boutai 'ouka (50,000) boina. ");
INSERT INTO nrz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Dala kanania'i 'eva Lovia namana ena luva dekavaia odaoda maisiavuna ekubu. ");
INSERT INTO nrz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Dava katania boutai depulu mulinai, Paulo nuana evavaia kave'i eula Makedonia mai Akaia kanotai bekeini beda'a Ielusalema. Ia sibona ediaka, “Bada'a ua'i mulinai, lau 'eva bada'a Loma vaka baikala.” ");
INSERT INTO nrz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paulo ena vidulu kauta lua Timoteo mai Elasito esinita de'ana'ia deda'a Makedonia, beia ia 'eva ua'i Asiai kena emia dau'a. ");
INSERT INTO nrz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Melala kanaua'i Lovia namana ena dala dainai Epesoai adedua namavaikana epulu. ");
INSERT INTO nrz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uai kau ka vana Demetelio, ia 'eva siliva vinaulana evavaia, ena vinaula kauta deta'u dilava ateatena Atemi ena luma silivai devavaia, vinaula kanaua'i moni doutamo deabita. ");
INSERT INTO nrz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Melala ka Demetelio eta'u ena vinaula kauta mai kau vaida vinaula vitaitana devavaia kauta e'aeta ka'ona deasi ia kevana, inoku e'outa ediaka, “E'u kau e, oi oikabasi ita vinaula kanania'i moni nama'ita ka'abi. ");
INSERT INTO nrz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Beia kau kanania Paulo oi oikala mai valina oi o'ika 'eva nia'i Epesoai mai Asia kanona itoina laloanai kau doutamo nuata aboina e'ilota mai evada'ata tau, ia ediaka 'eva kau imatai devavai dilavata kataua 'eva sia dilava umauta. ");
INSERT INTO nrz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Vailai si'avana ka bepupulu 'eva eta vinaula kanania vana nama'ina beabi si'ala, beia dilava ateatena namana Atemi ena lo'e mai ia sibona vana vaka beabi si'ata. Ia 'eva Asia kanona itoina laloanai mai kanobata itoina laloanai dekukudivo venia dilavana ena nama'ina 'ani betaule 'avaea.” ");
INSERT INTO nrz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Deakubou kauta luva kanaua deika koanai, debadu si'asi'a inoku devaoi dediaka, “Epeso kaumai emai dilava ateatena Atemi e, oni 'eva onama vaika!” ");
INSERT INTO nrz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Vanua namana kauta boutai devaoi laialaia inoku nuata ka'onamoai deko'isi deda'a Kaio mai Alisitako deabita kao develita deda'a do'u lumana laloanai. Kau luana katania 'eva Makedonia kauta, Paulo debanoia kauta. ");
INSERT INTO nrz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo eula bela'asi beda'a kau mato vailatai, beia abiveni kauta ia de'alavua. ");
INSERT INTO nrz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Maivaka 'abu kanaua'i 'ola kauta vaida 'eva Paulo ena kau, ia luva desinia eda'a Paulo kevana deva'amea do'u lumana kanaua laloanai sia bedododo. ");
INSERT INTO nrz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Do'u kauta 'eva delalo to'ato'a, ia vaida dava ka devaoi vaia, vaida 'eva dava edeana mo ka devaoi vaia. Beia ia doutamo 'eva sia deikabasi dava 'ounai deda'a ua'i. ");
INSERT INTO nrz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iuda kauta vaida kau vana Alesanda dedoliasi kau mato vailatai. Alesanda imana eabia isi do'u kauta eta vaoi devapuala, inoku ia eula Iuda kauta vuvua sia bemakoala luvana kau vailatai beluva vaia. ");
INSERT INTO nrz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Beia deikaiaune ia 'eva Iuda kauna koanai, melala koana lua vitaitana 'eva ia boutai devaoi ka'ona luva ka'onamo devaoi vaia dediaka, “Epeso kaumai emai dilava ateatena Atemi e, oni 'eva onama vaika!” ");
INSERT INTO nrz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mulinai vanua kauta eta luvaluva ilelena kauna do'u kauta e'outa lele devunu 'eva e'outa ediaka, “Epeso kaumui e, kanobata kauta boutai 'ani deikabasi Epeso vanuana 'eva dilava ateatena Atemi Lo'ena mai ia va'ava'ana vutuvutuai easi davana eikata kao. ");
INSERT INTO nrz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Dava kanania 'eva sia 'ouavuavu davana, kanaua 'ounai lele oi bovuvunu. Maivaka sia bo'omuiai dava ka oi bovavaia 'ileolo. ");
INSERT INTO nrz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kau katania oi ovuata oasi nia'i kauta 'eva lo'e davana sia ka devinaoa, maivaka eta dilava ateatena kevanai luva si'avana vaika sia ka deluvaia. ");
INSERT INTO nrz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bema Demetelio mai ena vinaula kauta sibota deula kau ka va'evai bene'eadivo koanai, valuva 'eva iluvuna mai valuva i'olavaita kauta vaka ua, ia betata'u va'eva kanaua bekavua. ");
INSERT INTO nrz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Dava ka ua'i lovana oi boakua koanai, oi bovuala boda'a vanua kauta eta do'u namana vailatai bevakomoloa. ");
INSERT INTO nrz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Vali'u 'ulu kanania epupulu 'ounai 'ola kauta ita asi'i va'evai dema'uleta. Kanaua bekoma koanai sia mai dalana ia eta luva ekavamueia, 'olana 'ulu kanania 'eva sia mai 'olana.” ");
INSERT INTO nrz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Luva kanania eluvaia mulinai, do'u kauta boutai esinita la'asi. ");
INSERT INTO nrz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Viala mai 'ulu kanaua epua mulinai, Paulo luva esinia eda'a abiveni kauta kevata deasi kevana, evakula'ilata mulinai, e'outa no'olo inoku evikanita eda'a Makedonia. ");
INSERT INTO nrz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","'Abu ka ka laloatai ekeini eda'a koanai, vakula'ila luvata doutamoai abiveni kauta eluva venita, mulinai eda'a 'Elene ai ela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Paulo vuia koi ua'i 'Elene ai emia, ia eva'olu aunakoiai bele'au beda'a Sulia laloanai, Iuda kauta vaida delovaku ia beaku bala valina eika, kanaua 'ounai ia eula bemue'udai beda'a Makedoniai bekeini beda'a Sulia. ");
INSERT INTO nrz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Debanoia kauta 'eva katania, Pulo nakuna Sopatele ia 'eva Belea kauna, Alisitako mai Sekundo ia 'eva Tesalonika kauta, Kaio ia 'eva Delebe kauna, Tukiko mai Tolopimo ia 'eva Asia kauta, mai Timoteo. ");
INSERT INTO nrz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kau katania de'ana'ia deda'a Toloa ai lai de'imamai. ");
INSERT INTO nrz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Palaoa 'avaeana naduna mulinai Pilipo ai aunakoiai lai aveau asi boni ima mulinai ua'i Toloa ai lai avidavali. Ua'i melala ima lai amia. ");
INSERT INTO nrz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Masi kanaua bonina lava'ana'inai lai boumaiai lai amiado'u palaoa kabukabuna lai bania. Paulo do'u kauta eluva venita eda'amo malolua, 'olana belani 'eva ia bevikanita. ");
INSERT INTO nrz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Aka laloanai lai amiado'u 'abunai ua'i 'eva lamepa doutamo deani. ");
INSERT INTO nrz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kau 'alu'aluna ka vana Eutuko 'eva ua'i kaiasi 'abunai emia. Paulo eluvaluva keini laloanai, Ia luma vakana ivakoina akana kanaua'i emuinai tabu 'eva e'ekoasi eda'a kuai. Deabia isi koanai, ia 'ani eba. ");
INSERT INTO nrz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo e'ovu eda'a Eutuko akanai epaka 'au inoku imana kukuanai ela'u keini 'eva ediaka, “Nuamui sia bebavunu, ia 'eva maulina do'o.” ");
INSERT INTO nrz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Paulo ele'au 'udai eda'a lumai 'eva palaoa ekovia inoku deania. Eluvaluva eda'amo taba elele mulinai, evikanita eda'a. ");
INSERT INTO nrz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kau 'alu'aluna mauli maulina devuaia deda'a luma, nuata mailalonamata ita. ");
INSERT INTO nrz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulo eluva ia 'eva aenai beda'a Aso 'ounai ena luva lai abiadae, lai aunakoi ai lai aele'au lai aveau 'ana'i lai ada'a, ua'i lai a'imaia bele'au. ");
INSERT INTO nrz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso ai lai avidavali koanai, aunakoiai ele'au inoku lai ada'a Mitulene. ");
INSERT INTO nrz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Elani lai aveau lai ada'a Kioso motumotuna kevanai lai aveau keini inoku boni ivaluanai lai akeini lai ada'a Samo inoku boni ivakoinai 'eva Mileto ai lai ala'asi. ");
INSERT INTO nrz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo elalovaia 'eva Epesoai lai baveau keini, ia sia eula ua'i Asia kanonai melala namavaikana lai bavaolea 'avaea, 'olana ia 'ilena deolo eula mai dalana koanai, Pentikos melalanai 'eva Ielusalemai bela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ua'i Mileto ai Paulo luva esinia eda'a Epeso lo'ena de'olavaia kauta kevatai be'asi kevana. ");
INSERT INTO nrz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ia dela'asi koanai, e'outa ediaka, “Melala makavanai lau asi Asia kanonai ala'asi easimo vali'u melalana oi kevamuiai a amia koma 'eva oi oikabasi kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Iuda kauta vaida eta aivala dekovota keva'uai melalatai, maimanau'u mai maka'u maiveitai Lovia namana da'alana abi. ");
INSERT INTO nrz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Oi oikabasi oi idulumui luvata 'eva kau vailatai mai luma ka ka laloatai ailolo vai mai avaikabasi vai 'eva sia ka avunia. ");
INSERT INTO nrz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Lau Iuda kauta mai 'Elene kauta kevatai a'ou asi kave'i 'eva ia belalo'udai beda'a Dilava kevana mai eta Lovia namana Iesu beabivenia. ");
INSERT INTO nrz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Vali'u Idume Kabukabuna lelena daitai badadai bada'a Ielusalema, sia aikabasi ua'i keva'uai dava bepupulu. ");
INSERT INTO nrz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Lau aikabasi 'eva vanua ka ka laloatai Idume Kabukabuna e'ou'u 'eva vailai bevaanaana'u mai bevavabuto'o'u. ");
INSERT INTO nrz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Beia e'u mauli 'eva alalovaia sia mai anina, lau a'ula veau vilo'o mo bavaolea inoku Lovia namana Iesu 'ani eveni'u vinaulana bavaolea kave'i, vinaula kanaua 'eva Dilava ena iulaveni valina nama'ina ba'oua asi. ");
INSERT INTO nrz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Lau oi boumuiai viloamuiai ada'a keinikeini Dilava ena lovia vanuana ailolo vaia, vali'u aikabasi oi sia ka 'eva lau oi boika'u 'udai. ");
INSERT INTO nrz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kanaua 'ounai vali'u oi vailamuiai a'ou asi oi ka bobaba si'avana 'abuna boda'ala 'eva sia lau e'u va'eva. ");
INSERT INTO nrz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","'Olana Dilava ena ula itoina 'ani ailolo vaia oi kevamuiai sia dava ka avunia. ");
INSERT INTO nrz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sibomui oi bo'imamui kave'i mai Idume Kabukabuna eta'u mamoe emui ikakao venunai e'uleta kataua oi bo'imata kave'i. Dilava ena lo'e kauta, kataua 'eva Dilava nakuna ena ba ai 'ani etavata. ");
INSERT INTO nrz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Lau aikabasi bavikanimui mulinai, vaikabasi kauta dedeta vaida 'oveka 'asita aivalata boita be'asi oi viloamuiai inoku abiveni kauta kataua itani mamoe boita beabi si'ata. ");
INSERT INTO nrz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Maivaka emui kau umauta vaida ia ita oi ovinaula ka'ona kauta beko'isi abiveni kauta vaida dede luvatai bevada'ata tau ia mulitai bedada'a. ");
INSERT INTO nrz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kanaua 'ounai oi bo'imamui kave'i, oi bolalovai 'inia vikau koi laloanai boni mai lani sia avapuala maka'u maiveitai melala boutai oi boumuiai avaikabasimui. ");
INSERT INTO nrz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Vali'u lau oi Dilava imana laloanai mai ia ena iulaveni luvana laloanai audamui 'ovu, luva kanaua 'eva oi boumuiai 'ani bevalavamui 'ini mai Dilava ena kau kabukabuta boutai bevanama'inata vitaitanai oi vaka bevanama'inamui. ");
INSERT INTO nrz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Lau oi viloamuiai amia koanai, lau sia kau ka ena siliva 'o kolo 'o tubu'a ka aula venia 'avaea. ");
INSERT INTO nrz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Oi sibomui oi oikabasi 'eva lau ima'u katania'i avinaula 'eva lau mai ibano'u kauta emai ula davata boutai avapuluta. ");
INSERT INTO nrz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dava boutai avavai laloatai, lau oi avaikamui 'eva vinaula kula'ila kanania boinai debadebade kauta oi boduluta, Lovia namana Iesu eluvavaia luvana oi bolalovai 'inia ediaka, Veniveni 'eva ena nama'ina namavaikana vakaia abiabi.” ");
INSERT INTO nrz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo luva kanania eluvaia mulinai, ia ita dekuidula ka'ona demeamea. ");
INSERT INTO nrz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ia boutai dekani 'unu'unu laloanai Paulo kukuanai dela'u keini deba'uia. ");
INSERT INTO nrz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ia devilalo si'asi'a 'olana ia ediaka vailana sia beikala 'udai. Inoku debanoia ita deda'a aunakoi ai bevaelea'au. ");
INSERT INTO nrz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Lai a'outa no'olo mulinai, aunakoi ai lai aveau asi komolomaiai lai ada'a Koso motumotuna, elani lai akeini lai ada'a Lodo motumotunai inoku ua'i lai ada'a Patala vanuanai lai ala'asi. ");
INSERT INTO nrz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ua'i Poenikia beda'ala aunakoina ka lai adavalia 'eva lai aele'au inoku lai aveau asi. ");
INSERT INTO nrz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kupulo motumotuna lai aikaia inoku lai adivoia lai aveau lai ada'a Sulia, ua'i Tulo ai lai avadai'au 'eva aunakoiai tamu bedadala. ");
INSERT INTO nrz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Abiveni kauta vaida ua'i lai adavalita inoku masi ka ia ita lai amia. Idume Kabukabuna siavunai ia Paulo de'ouia sia beda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Beia emai ko'isi melalana eabia koanai, lai avikanita lai ada'a. Abiveni kauta kataua boutai, ia adata mai nakuta ita lai debanomai vanua namanai lai ala'asi lai ada'a, ua'i nabuai lai akuidula lai ameamea. ");
INSERT INTO nrz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ka ka ita lai avi'ou no'olo mulinai, aunakoiai lai aele'au inoku ia demue'udai deda'a eta luma. ");
INSERT INTO nrz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tulo ai komolomaiai lai aveau ada'a Tolemaia ai lai ala'asi, abiveni kauta ita lai avidavali inoku ua'i boni ka'onamo ia ita lai amia. ");
INSERT INTO nrz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Elani ua'i lai avikanita lai ada'a Kaisalea ai lai ala'asi, inoku evanelia kauna Pilipo ena lumai lai amia, ia 'eva diakono kauta kalakoika banota ka. ");
INSERT INTO nrz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ia nakuna vavatota vani 'eva enolea vavatota. ");
INSERT INTO nrz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ua'i boni vaida lai amia laloanai, enolea kauna ka vana Akabo Iudea ai easi. ");
INSERT INTO nrz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ia easi lai kevamaiai 'eva Paulo kukuana i'apana eabia, sibona imana mai aena edo'ota inoku eluva ediaka, “Idume Kabukabuna ediaka, Ielusalemai Iuda kauta betata'u kukua 'apana kanania 'olana kauna belioa inoku beveni keini pulu edea kauta kevatai.” ");
INSERT INTO nrz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Luva kanaua lai aika koanai, lai mai ua'i kau kataua ita Paulo lai anoia sia beda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Inoku ia lai emai luva evamuea ediaka, “Dava 'ounai oi okakani inoku lau nua'u oi ovamanomanoa? Lau 'ani ava'olu 'eva sia belio'u mo dainai, beia Ielusalemai Lovia namana Iesu vana dainai vaka bababa.” ");
INSERT INTO nrz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ia lelemai sia eabi dae 'ounai lai avikania inoku lai adiaka, “Lovia namana ena ula 'eva epulu.” ");
INSERT INTO nrz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Boni vaida deole mulinai, lai abiva'ai inoku lai ada'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Abiveni kauta vaida Kaisaleai debanomai inoku devuamai lai ada'a Nasona ena lumai ua'i lai bamimia. Ia 'eva Kupulo kauna maivaka abiveni kauna ka 'ana'ina. ");
INSERT INTO nrz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ielusalemai lai ada'adodo koanai, bo'akalata mai lalonamata deabimaidae. ");
INSERT INTO nrz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Elani 'eva Paulo ita lai ada'a Iesu kadina Iakobo lai baikala, ua'i lo'e de'olavaia kauta boutai vaka devaila. ");
INSERT INTO nrz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo vanama'ina luvata evenita mulinai, ia ena vinaula laloanai Dilava eta'u pulu edea kauta viloatai dava evavai davata boutai valita ekava. ");
INSERT INTO nrz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Luva kanaua deika koanai, Dilava devanama'inala. Inoku Paulo de'ouia dediaka, “Bo'akalamai e, 'ani oikabasi Iuda kauta doutamo deabiveni, inoku ia boutai 'eva Mose ena talavatu dainai dedadai. ");
INSERT INTO nrz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Beia Iuda kauta katania 'eva vali dedena kanania boina deika, Iuda kauta pulu edea kauta viloatai demimia kauta o'outa Mose ena talavatu kevanai beda'atau, nakuta momoluaneta iva sia beabia maivaka Iuda kauta demaulivaia koakoatai sia bemauli. ");
INSERT INTO nrz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ia luvamu vali'u be'ika oni 'ani oasi. Dava 'ani ekavavaia? ");
INSERT INTO nrz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kanaua 'ounai lai ba'oumu vinaulana bovavaia. Emai kau vani 'eva Dilava kevanai eta luva'ana'i 'ani devavaia. ");
INSERT INTO nrz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kau katania boabita ia ita kaumu 'obuta iabiovota koakoana oi bovavaia, ia tavata boveveni kanaua'i vuita betaliovo. Inoku kau boutai beikabasi oni akamuai luva kataua deluva 'eva sia momo'aita, beia oni sibomu 'eva Mose ena talavatu dainai odadai. ");
INSERT INTO nrz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pulu edea kauta 'ani deabiveni kauta kataua lai avamomo'aia luvana maleleai lai alele venita asinia 'eva kau iani deveveni dilava dedeta kevatai ianita sia be'ani, maivaka sisi vidiota mailalata sia be'ani, sisi 'atotai dedo'ota ba sisita sia be'ani mai kulakula koakoata sia bevavai.” ");
INSERT INTO nrz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Elani Paulo kau vani kataua evuata ia ita deda'a kauta 'obuta iabiovota koakoana devavaia, inoku ia eda'a lo'e kabukabuna laloanai edodo 'eva ivavaita kave'i koakoana vinaulana aida be'ole maivaka ia ka ka sibota eta veniveni ainamata aida bevavai melalata vaikabasita eveni. ");
INSERT INTO nrz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Melala kalakoi ka vinaulana kanaua 'ani be'ole laloanai, Iuda kauta vaida Asia kanonai deasi inoku Paulo lo'e kabukabuna laloanai deikaia koanai, ia kau mato devaasiasita Paulo deabia kao, ");
INSERT INTO nrz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","devaoi dediaka, “Isalaela kaumui e, odulumai! Kau kanania 'eva 'abu boutai laloatai kau boutai evaikabasita ita eta kau mai Mose ena talavatu mai lo'e kabukabuna kanania e'ou si'ata, maivaka pulu edea kauta vaka evuata easi lo'e kabukabuna laloanai inoku 'abu kabukabuna kanania deva'obua.” ");
INSERT INTO nrz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kanaua deluva koma 'olana 'ana'inai Paulo 'eva Epeso kauna Tolopimo ita Ielusalema vanuana laloanai demia deikata, inoku ia delalovaia 'eva Paulo ia evuaia eda'a lo'e kabukabuna laloanai. ");
INSERT INTO nrz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Luva kanania'i vanua itoinai ai 'ulu namavaikana evavaia, inoku kau 'abu ka ka laloatai deveau deasi. Paulo deabia kao, lo'e kabukabunai develia tatala dela'asi, inoku komolonai lo'e kabukabuna nutualata de'alavuta. ");
INSERT INTO nrz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paulo beakubala deko laloanai valina eda'a Loma eta kuali kauta e'olavaita kauna eika Ielusalema vanuana itoinai 'eva viala namavaikana epupulu. ");
INSERT INTO nrz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Komolonai ia kuali de'olavaia kauta mai kuali kauta ita deveau deda'a kau mato kataua kevata. Kau kataua kuali 'ola kauna mai ena kuali kauta deikata koanai Paulo iakunai devuakao. ");
INSERT INTO nrz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kuali 'ola kauna eda'a Paulo eabia, inoku ena luvai seini lua ai delioia. Elavuaita ia 'eva dai maivaka dava evavaia. ");
INSERT INTO nrz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kau mato laloatai vaida luva edeana devaoi vaia mune'e vaida luva edeana mo devaoi vaia, kanaua'i 'ulu namavaikana devavuala 'ounai, kuali 'ola kauna luva umauna sia ka eika, kanaua 'ounai ia luva eveni Paulo bevuala beda'a kuali kauta eta mia 'abunai. ");
INSERT INTO nrz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo devada'ala deda'a vadai ai eneke'au koanai, kau mato 'eva deaivala si'asi'a 'ounai kuali kauta deta'u devuaia isi dele'au. ");
INSERT INTO nrz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kau mato ia mulinai deda'a 'eva devaoi dediaka, “Oaku bala!” ");
INSERT INTO nrz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kuali kauta Paulo 'ani eta alai bevadodoa laloanai, Paulo kuali 'ola kauna enoia ediaka, “Bemanama'ina luva ka bama'oumu.” Inoku kuali 'ola kauna elavuaia ediaka, “Oni 'Elene malata oikabasi, una? ");
INSERT INTO nrz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Oni Aikupito kaumu kanana 'ana'inai viala ovapulua inoku akuaku kauta boutai sinavu vaninavui (4,000) ovuata oi oda'a kano'akunai, una?” ");
INSERT INTO nrz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo ia ena luva evamuea ediaka, “Asi'i. Lau 'eva Iuda kau'u, Kilikia ai Taso laloanai, vanua namana kanaua kau'u. Anoimu, kau katania bama luva venita.” ");
INSERT INTO nrz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kuali 'ola kauna komolo evenia beluluva, inoku Paulo vadai elava'au imana eabi isi kau lele bevuvunu. Kau mato lele devunu koanai, Paulo 'Ebelu malatai eluva venita. ");
INSERT INTO nrz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bo'akala'u mai kama'u boumuiai e, kaiamui ovaala vali'u bakakava lele'u oi boika.” ");
INSERT INTO nrz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","'Ebelu leletai eluva venita lelena deika koanai, 'uluta asi'i kaiata devaala inoku Paulo ediaka. ");
INSERT INTO nrz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Lau 'eva Iuda kau'u, Taso vanuanai Kilikia kanonai apulu, beia Ielusalema vanuana kanania'i a'aida'aida. Kamaliela 'eva lau e'u vamalele kauna, ita 'ava'avata eta talavatu boutai evamalele'u kave'i maivaka Dilava ena vinaula akula'ila vaia vitaitana vali'u oi okula'ila vaia boina. ");
INSERT INTO nrz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Lau Iesu deabivenia dala kanania'i deda'avaia kauta, 'a'atetaavaiviivita, vaida aku bata, kau mai 'a'ate aliota vabuto'o lumanai akapota dodo. ");
INSERT INTO nrz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kabukabu kauta 'olatai kauna mai do'u namana kauta boutai e'u luva 'ani bevamomo'aia. Ia deta'u malele deveni'u ada'a bo'akalata Damaseko ai kauta kevata, ua'i abiveni kauta bavuata ba'asi Ielusalemai bevabuto'o. ");
INSERT INTO nrz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ado'alavuni boina lau ada'a Damaseko akevaia laloanai, 'ailala namavaikana ka vutuvutuai komolonai e'ovu easi lau edui'u kaiu. ");
INSERT INTO nrz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Komolonai a'eko kanoai 'eva lele ka eluva veni'u lelena aika ediaka, ‘Saulo e, Saulo e, lau dava 'ounai ovaiviivi'u?’ ");
INSERT INTO nrz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Lau alavuaia adiaka, ‘Lovia namana e, oni dai?’ Ia ediaka, ‘Lau Iesu, Nasaleta kau'u, oni lau ovaiviivi'u kau'u.’ ");
INSERT INTO nrz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ibano'u kauta 'ailala kanaua deikaia, beia lau eluva veni'u lelena kanaua 'eva sia deika. ");
INSERT INTO nrz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Lau alavuaia adiaka, ‘Lovia namana e, lau dava bavavaia?’ Ia ediaka, ‘Ko'isi, boda'a Damaseko, kau ka ua'i luva dava be'oumu 'eva vinaulata boutai bovavai.’ ");
INSERT INTO nrz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ibano'u kauta ima'u ai deabi devada'a'u lai ada'a Damaseko, 'olana 'ailala kanaua 'eva e'ailala vaika maka'u eva'edeta. ");
INSERT INTO nrz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kau ka vana Anania easi eika'u. Ia 'eva talavatu luvata daitai edadai mai kabukabu kauna maivaka ua'i Iuda kauta demimia kauta boutai 'eva ia 'olana de'aku. ");
INSERT INTO nrz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ia easi keva'uai elavadivo inoku e'ou'u ediaka, ‘Bo'akala'u Saulo e, boikaika 'udai.’ Melala kanaua'i komolonai lau maka'u enama'ina ia aikaia. ");
INSERT INTO nrz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Inoku ia ediaka, ‘Ita 'ava'avata eta Dilava 'ani oni edilamu ena ula boikabasia mai vinaula komolo kauna Iesu boikala maivaka ia nutunai beluluva lelena bo'ika. ");
INSERT INTO nrz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Oni 'eva ia bovaluala makamuai dava oikala mai kaiamuai dava o'ika 'eva kau boutai kevatai valita bokakava. ");
INSERT INTO nrz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Vali'u oni dava o'imala? Ko'isi, Lovia namana vanai 'ae'ae, boidi'u kabukabu inoku emu si'avana bedeini ovo.’ ");
INSERT INTO nrz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mulinai lau amue ada'a Ielusalema, inoku lo'e kabukabunai ameamea laloanai, amakakeini. ");
INSERT INTO nrz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Lovia namana aikaia e'ou'u ediaka, ‘Molau. Ielusalema bovikania kaokao, 'olana lau vali'u bokakava 'eva kau katania sia beabiadae.’ ");
INSERT INTO nrz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Lau adiaka, ‘Lovia namana e, kau katania deikabasi lau ada'a Iuda kauta eta lo'e ka ka laloatai oni deabivenimu kauta kataua akuta inoku aliota vabuto'o lumanai ane'eta divo. ");
INSERT INTO nrz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Oni valimu ikavana kauna Stipano lalana dekoko koanai, lau vaka ua'i alava, deaku bala kauta avamomo'aita maivaka tubu'ata aika kao.’ ");
INSERT INTO nrz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Inoku Lovia namana e'ou'u ediaka, ‘Da'a, lau oni basinimu boda'a pulu edea kauta dau'ai demimia kauta kevata.’” ");
INSERT INTO nrz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kau mato Paulo lelena deika eda'amo luva kanaua eluvaia koanai devilavila leleta devaele'au akai vaika dediaka, “Oaku bala! Kau kanana boina kauna 'eva sia mai ena nama'ina kanobatai bemimia.” ");
INSERT INTO nrz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ia devilavila, eta tubu'a deito maivaka 'apulolo deito dele'au akai. ");
INSERT INTO nrz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kuali i'olavaina kauna ena kuali kauta e'outa Paulo devuaia deda'a ia eta 'abuai, ua'i be'odia inoku belavuaia kau dava 'ounai ia depilaia. ");
INSERT INTO nrz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ia Paulo delioia be'odia laloanai, kuali kauta sinavu e'ola vaita kauna ia kevanai elava kauna elavuaia ediaka, “Loma kauna asido'o valuva eabia kauna be'odia 'eva ekomolo, una?” ");
INSERT INTO nrz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kuali kauta e'ola vaita kauna luva kanaua eika koanai, ia eda'a ia i'olavaina kauna e'ouia ediaka, “Kau kanaua 'eva Loma kauna. Oni dava bovavaia?” ");
INSERT INTO nrz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kuali i'olavaina kauna eda'a Paulo kevanai inoku elavuaia ediaka, “Bo'ou'u, oni Loma kaumu, una?” Paulo enu'ovi ediaka, “'O.” ");
INSERT INTO nrz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kuali i'olavaina kauna ediaka, “Lau moni nama vaikanai tava aveni 'eva asi Loma kau'uai ao.” Beia Paulo ediaka, “Lau 'eva Loma kauta eta puluta.” ");
INSERT INTO nrz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ua'i delava belavuaia kauta alimo delava tau, kuali i'olavaina kauna 'eva emakau, 'olana ia eikabasi Paulo 'eva Loma kauna, beia seiniai elioia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Elani kuali i'olavaina kauna eula beikabasi kave'i Iuda kauta dava 'ounai Paulo vuvua devakoala. Kabukabu kauta namata mai do'u namana kauta evado'uta, inoku Paulo eluvuia evuaia eda'a ia vailatai evalavala. ");
INSERT INTO nrz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo do'u namana kauta ete 'inita inoku ediaka, “Bo'akala'u e, melala boutai nua'u nama'inai mai sia va'eva ka avavaia Dilava vailanai amia easimo vali'u.” ");
INSERT INTO nrz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kabukabu kauta 'olatai kauna Anania luva kanaua eika 'eva Paulo kevanai delava kauta e'outa nutuna bebalala avu. ");
INSERT INTO nrz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Inoku Paulo ia e'ouia ediaka, “Oni 'eva itani ikekebili deva'inai deto'aia davana boina, Dilava beakumu, talavatu vitaitanai na'i omimia lau bovaluva'u, beia oni sibomu mo talavatu ova'alamaia 'eva luva oveni lau beaku'u.” ");
INSERT INTO nrz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paulo kevanai delava kauta kataua dediaka, “Oni Dilava ena kabukabu kauta 'olatai kauna kevanai oluva si'asi'a?” ");
INSERT INTO nrz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo ediaka, “Bo'akala'u, lau sia aikabasi ia 'eva kabukabu kauta 'olatai kauna. Puka kabukabunai kanania eleleia koma, ‘Emu lovia kauna kevanai sia boluva si'asi'a.’” ");
INSERT INTO nrz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo do'u namana kauta eikata une koanai, vaida 'eva Palisea kauta, vaida Sadukea kauta, inoku vailatai e'ae'ae 'unu'unu ediaka, “Bo'akala'u e! Lau 'eva Palisea kau'u, mai Palisea nakuta, lau e'u nuabata ba kauta 'ani beko'isi 'udai 'ounai vali'u valuva 'abunai alalava.” ");
INSERT INTO nrz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ia luva kanaua eluvaia koanai, Palisea kauta mai Sadukea kauta deviala, inoku do'u kauta devi'alama lua. ");
INSERT INTO nrz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","'Olana Sadukea kauta dediaka ko'isi 'udai 'eva asi'i, maivaka anelu 'o idume vaka asi'i, beia Palisea kauta 'eva kataua boutai devamomo'aita. ");
INSERT INTO nrz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","'Ulu namavaikana epulu, talavatu 'ola kauta vaida 'eva Palisea kauta deko'isi inoku deluva kula'ila dediaka, “Kau kanania kevanai va'eva sia ka lai adavalia. Ama'i anelu ka 'o idume ka 'ani ia eluva venia.” ");
INSERT INTO nrz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Viala eda'a namavaikana, inoku Kuali i'olavaina kauna emakau 'eva Paulo asi'i demavelia mukamuka, kanaua 'ounai kuali kauta esinita de'ovu deda'a ia kevatai Paulo develia tau, devuaia deda'a kuali kauta eta 'abu. ");
INSERT INTO nrz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Boni kanaua'i Lovia namana Paulo kevanai elava inoku ediaka, “Bokula'ila! Ielusalemai vali'u okava vitaitana Lomai vaka vali'u bokakava.” ");
INSERT INTO nrz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Elani 'avu'avuni Iuda kauta demia ka'ona delovaku inoku Dilava vailanai deluva'ana'i, ia sia beaniani maivaka sia dava ka beinua beda'amo Paulo beaku bala. ");
INSERT INTO nrz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kauta boutai vaninavui (40) ekeinia 'eva kanaua boina deluva'ana'i. ");
INSERT INTO nrz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Deda'a kabukabu kauta namata mai vanua kauta namata kevatai inoku dediaka, “Lai Dilava vailanai 'ani lai aluva'ana'i, lai sia dava ka lai bania beda'amo Paulo lai baku bala. ");
INSERT INTO nrz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vali'u oi mai do'u namana kauta luva oi bosinia beda'a kuali i'olavaina kauna kevanai oi bodedede oi bodiaka, Paulo be'asi nia'i kevamuiai luva komolona oi boabia oi bokoma. Ia be'asi asido'o nia'i ela'asi laloanai lai 'ani ava'olu lai baku bala.” ");
INSERT INTO nrz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Beia Paulo uana Paulo vunivuniai beakua 'uluna eika koanai, ia eda'a kuali kauta eta 'abuai Paulo e'ouia. ");
INSERT INTO nrz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Inoku Paulo kuali kauta sinavu e'ola vaita kauna ka e'aeia easi inoku eouia ediaka, “Kau 'alu'aluna kanania bovuala boda'a ua'i kuali i'olavaina kauna kevanai, luva ka be'oua.” ");
INSERT INTO nrz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kanaua 'ounai kuali kauna kanaua Paulo uana evuaia eda'a kuali i'olavaina kauna kevana e'ouia ediaka, “Vabuto'o kauna Paulo luva esinia ada'a ia kevana inoku enoi'u kau 'alu'aluna kanania bavuala ba'asi kevamuai, 'olana ia luva ka oni be'oumu.” ");
INSERT INTO nrz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kuali i'olavaina kauna Paulo uana imanai eabi deda'a 'aba'abai inoku elavuaia, “Luva dava o'ula bo'ou'u?” ");
INSERT INTO nrz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ia ediaka, “Iuda kauta 'ani deluva ka'ona benoimu, ‘Mala Paulo bovuala boda'a do'u namana kauta kevatai, bevaluvala kave'i kevanai luva komolona beabia bekoma.’ ");
INSERT INTO nrz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Leleta sia bo'ika 'olana kau boutai vaninavui (40) ekeinia 'eva belavate'e Paulo be'imala. Dilava vailanai deluva'ana'i sia beaniani 'o sia dava ka beinua beda'amo Paulo beaku bala. Vali'u kau kataua 'ani de'olu bevavaia, kaiata mo devaala inoku oni emu 'eva dava.” ");
INSERT INTO nrz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kuali i'olavaina kauna kau 'alu'aluna kanaua e'ouia kao ediaka, “O'ou'u luvana kanania 'eva sia kau ka bo'oua.” Inoku esinia eda'a. ");
INSERT INTO nrz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kuali i'olavaina kauna eta'u kuali kauta sinavu de'ola vaita kauta lua e'aeta deasi inoku e'outa ediaka, “Kuali kauta sinavu lua (200), osi ai deveau kauta boutai kalakoika navui (70) mai io kauta boutai sinavu lua (200) oi bova'oluta. Vali'u boniai melala koana kalavanika (9) 'eva oi boda'a Kaisalea. ");
INSERT INTO nrz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Osi vaida vaka oi bova'oluta Paulo bemia'au, oi bo'imala kave'i oi bovuala boda'a Kavana kauna Feliki kevana.” ");
INSERT INTO nrz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Inoku kuali i'olavaina kauna malele ka eleleia beda'a Kavana kauna kevana, kanania eleleia koma. ");
INSERT INTO nrz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Lau Kalaudio Lusia, Kavana kaumu Feliki nama'imu e, avanama'inamu. ");
INSERT INTO nrz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Iuda kauta kau kanania deabia kao inoku deula beaku bala, beia aikabasi ia 'eva Loma kauna 'ounai e'u kuali kauta ita lai ada'a inoku lai avamaulia. ");
INSERT INTO nrz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Lau aula baikabasi dava 'ounai vuvua devakoala, kanaua 'ounai avuaia ada'a Iuda kauta eta do'u namana laloanai. ");
INSERT INTO nrz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lau ua'i aikabasi kau kanania sia dava ka evavaia kanaua dainai ia bebaba 'o bevabuto'o vaia, ia sibota eta talavatu laloanai lavuailavuai vaida outai deabia. ");
INSERT INTO nrz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Maivaka Iuda kauta vaida delovaku beaku bala deko valina aika koanai, komolonai mo asinia evasi kevamu. Vuvua devakoala kauta vaka a'outa bevasi vailamuai eta nua mekau luvata beluva vaita.” ");
INSERT INTO nrz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kanaua 'ounai kuali kauta ia i'olavaita kauna lelena daitai dedai, boni kanaua'i Paulo devuaia deda'a Anetipatili ai dela'asi. ");
INSERT INTO nrz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Elani aetai deda'a kauta demue'udai deda'a eta vinaula 'abuna, beia osiai kauta 'eva Paulo devuaia deda'a. ");
INSERT INTO nrz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Osiai kauta Kaisaleai dela'asi koanai, malele kanaua Kavana kauna vana Feliki devenia, maivaka Paulo vaka Feliki ena ikakao venunai devikania. ");
INSERT INTO nrz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kavana kauna malele kanaua evakua mulinai, Paulo elavuaia ia 'eva 'abu dava kauna. Ia eika Paulo 'eva Kilikia kauna koanai, ");
INSERT INTO nrz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ia ediaka, “Oni va'eva 'abunai dene'emu divo kauta be'asi koanai, oni vumu bokokou ba'ika.” Inoku ia ena kuali kauta e'outa Paulo ua'i vabuto'o lumanai lovia kauna 'Eloda ena luma laloanai beikala kao. ");
INSERT INTO nrz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Melala ima deole mulinai kabukabu kauta 'olatai kauna Anania, vanua kauta namata vaida mai Loma eta talavatu eikabasi kave'i kauna vana Teletulo ita de'ovu deda'a Kaisalea, Kavana kauna Feliki vailanai Paulo vuvua devakoala luvata de'ouia. ");
INSERT INTO nrz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Inoku Feliki luva esinia eda'a Paulo devuaia deasi, Teletulo eko'isi vuvua devakoala luvana emakavala ediaka, “Kavana kaumu Feliki nama'imu e, vikau namavaikana o'olavaimai kave'i nua'elu laloanai lai amia. Emu aonekai emai kanobata kanania laloanai dava nama'ita doutamo depulu. ");
INSERT INTO nrz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kanaua 'ounai 'abu boutai mai dala boutai laloatai lai oni lai abimudae. Feliki Kavana kaumu nama'imu vaika, lai nuamai boutai oni lai avanama'inamu. ");
INSERT INTO nrz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Vali'u sia bavabavunumu, beia anoimu bolalomai, emai luva to'oto'ona 'uluna bo'ika. ");
INSERT INTO nrz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kau kanania lai adavalia ia 'eva va'eva ivapuluta kauna. Kanobata bounai laloanai Iuda kauta kevatai viala mai 'ulu namavaikata evapulu kauna, maivaka ia 'eva Nasaleta iduvuna kauta e'olavaita kauna. ");
INSERT INTO nrz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ia etata'u Lo'e Kabukabuna eva'obua 'ounai lai abia. (Emai talavatu vitaitanai lai bavaluvala. ");
INSERT INTO nrz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Beia kuali i'olavaina kauna Lusia mai aivalana ita easi kevamaiai ebuku vaimai. ");
INSERT INTO nrz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Inoku vuvua devakoala kauta e'outa bevasi kevamu.) Inoku oni sibomu kau kanania bolavuaia, vuvua lai avakoa vaia luvata nutunai bela'asi leleta bo'ika 'eva boikabasi.” ");
INSERT INTO nrz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Iuda kauta vaka Teletulo ena luva deduluia dediaka, luva katana boutai 'eva momo'aita. ");
INSERT INTO nrz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kavana kau 'olana eka'uiadae Paulo e'ouia beluluva, inoku Paulo eluva ediaka, “Lau aikabasia vikau namavaikana eta kanobata laloanai valuva doutamo ovavaita 'ounai lau nua'u medianai oni vailamuiai sibo'u vali'u bakakava. ");
INSERT INTO nrz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Oni sibomu 'ulu kanania 'olana bokavua koanai 'ani boikabasia, boni ouka lua 'ani deda'a laloanai lau ala'asi ada'a Ielusalemai bameamea. ");
INSERT INTO nrz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vuvua devakoa'u kauta sia kena dedavali'u lo'e kabukabunai kau ka ita lai avina, 'o lau Iuda kauta eta lo'e laloatai 'o vanua kanaua laloanai sia va'eva ka avavaia. ");
INSERT INTO nrz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Kau katania vali'u oni vailamuai vuvua devakoa'u luvata katania 'eva sia luva momo'aita. ");
INSERT INTO nrz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Beia lau oni vailamuiai ba'ouasi luvana 'eva kanania, kau katania dediaka lau kukudivo dedena dalanai lau 'eva 'ava'avamai eta Dilava akukudivo venia. Mose ena talavatuai mai enolea kauta eta pukai deleleta davata boutai abitadae. ");
INSERT INTO nrz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","E'u nuabata Dilava enai 'eva vitaitana vaka kau katania boina. Emai nuabata 'eva komolo kauta mai si'avana kauta boutai ba ai beko'isi 'udai. ");
INSERT INTO nrz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kanaua 'ounai melala bounai avakula'ila'u nua'u nama'inanai bamimia Dilava mai kau vailatai. ");
INSERT INTO nrz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Vikau namavaikana dau'ai amia mulinai amue ada'a Ielusalema e'u kau kevatai ainama babita ba'asi ulalu kauta bavenita maivaka veniveni ainamata bavavaita. ");
INSERT INTO nrz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Vuvua devakoa'u kauta lau ivavai'u kave'i koakoana avavaia avamakamaka'u mulinai lo'e kabukabunai deika'u, lau sia kau mato ita, maivaka sia 'ulu ka ua'i avavaia. ");
INSERT INTO nrz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Beia Iuda kauta vaida Asia kanonai deasi kauta vaka ua'i, e'u va'eva ka dedavalia koanai vali'u bemaasi nia'i vailamuiai vuvua bemavakoa'u. ");
INSERT INTO nrz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Asi'i koanai, nia'i Iuda kauta katania sibota bemaluva, lau do'u namana kauta vailatai alava devaluva'u koanai e'uai va'eva dava dedavalia. ");
INSERT INTO nrz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ia vailatai alava koanai luva ka'onamo kanania avaoi vaia adiaka, ‘Ba kauta beko'isi 'udai mo 'ounai vali'u oi oabi'u valuva 'abunai oi one'e'u divo.’” ");
INSERT INTO nrz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Inoku Feliki, Lovia Namana ena dala eikabasia kave'i kauna valuva evailulalao inoku ediaka, “Kuali i'olavaina kauna Lusia be'asi koanai emui valuva balovaku vaia.” ");
INSERT INTO nrz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ia eta'u kuali kauta sinavu e'olavaita kauna e'ouia Paulo beikala kao kave'i, beia sia be'alavu 'inia, ena kau oi boikata vadae be'asi bedulua ena ula davata bevenivenia. ");
INSERT INTO nrz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Melala vaida deda'a mulinai Feliki adana Dulusila ita deasi, Dulusila 'eva Iuda ateatena. Feliki evisini eda'a 'eva Paulo easi, inoku Paulo Keliso Iesu laloanai abivenina valina ekava lelena deika. ");
INSERT INTO nrz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paulo eta'u vinaula komolo, kauani ena ula koakoana i'oukaona mai valuva namana be'asi lovana eakuia koanai, Feliki emakau inoku ediaka, “Ani edaia, vali'u bomumue bodada'a, melala nama'ina ka e'uai edaia koanai bavisini 'udai bo'asi.” ");
INSERT INTO nrz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Melala kanaua'i Feliki enuabata 'eva Paulo moni vaida ia bemavenia bemavala'asia, kanaua 'ounai ia melala doutamo evisini Paulo eda'a ia ita deluvaluva. ");
INSERT INTO nrz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Vikau lua deole mulinai Polokio Feseto eta'u Feliki 'abuna eabia. Beia Feliki eula Iuda kauta bevalalonamata 'ounai Paulo vabuto'o lumanai evikania. ");
INSERT INTO nrz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Feseto be'olavaia kanonai ela'asi ena vinaula emakavala, boni koi mulinai Kaisaleai eda'a Ielusalema. ");
INSERT INTO nrz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kabukabu kauta namata mai Iuda kauta namata deda'a ua'i kevanai Paulo vuvua devakoala. ");
INSERT INTO nrz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Feseto denoia va'ame deula vali'u Paulo besinia be'asi Ielusalema. 'Olana ia deva'olu la'ukai demia te'e, Paulo be'asi 'eva dalai beda'ala avu beaku bala delalovaia. ");
INSERT INTO nrz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Beia Feseto eta luva evamuea ediaka, “Paulo 'eva Kaisaleai vabuto'o lumanai de'alavua, melala kava'inamo lau 'ani bamue'udai bada'a ua'i. ");
INSERT INTO nrz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nama'ina 'eva emui 'ola'ana'i kauta ita lai bada'a Kaisalea, inoku kau kanaua dava ka evavaia si'asi'a koanai, ua'i vuvuana bevakoala.” ");
INSERT INTO nrz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Boni kalavani 'o 'ouka boita ia ita demia mulinai, Feseto eda'a Kaisalea. Elani eda'a valuva 'abunai emia divo inoku luva esinia eda'a Paulo bevuala be'asi. ");
INSERT INTO nrz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Inoku Paulo easi koanai, Iuda kauta Ielusalemai deasi kauta deda'a ia delavaia kaiu luva mekauta doutamo vaika deluva kevanai, luva kataua boutai 'eva sia momo'aita. ");
INSERT INTO nrz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo eta luva tavana evamuea ediaka, “Lau sia va'eva ka avavaia, lau Iuda kauta eta talavatu sia ava'alamaia, 'o lo'e kabukabunai sia dava ka avavaia si'asi'a 'o Loma kauta e'olavaita kauna Kaisala kevanai sia va'eva ka avavaia.” ");
INSERT INTO nrz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Beia Feseto eula Iuda kauta lalota bevanama 'ounai Paulo elavuaia ediaka, “Oni o'ula boele'au boda'a Ielusalemai inoku vuvua devakoamu luvata katania 'outai ua'i lau vaila'uai bolalava bavaluvamu, una?” ");
INSERT INTO nrz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo ediaka, “Lau vali'u Kaisala ena valuva 'abuna vailanai alalava, lau bevaluva'u 'abuna 'eva kanania'i. Oni oikabasi dokadoka, lau Iuda kauta kevatai sia va'eva ka avavaia. ");
INSERT INTO nrz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Lau bamava'eva koanai va'eva tavana ba bema'oua, lau sia amakau bababa. Beia Iuda kauta vuvua devakoa'u luvata boutai sia demomo'ai, sia kau ka mai ena komolo lau beabi'u ia imatai beudala. Anoinoi Kaisala vailanai balalava bevaluva'u.” ");
INSERT INTO nrz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Feseto valuva kauta ita delovaku mulinai Paulo e'ouia ediaka, “Oni Kaisala kevanai onoinoi 'ounai boda'a Kaisala kevanai bevaluvamu.” ");
INSERT INTO nrz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Melala vaida deole mulinai lovia 'olana kauna Akilipa lovuna Belenike ita deda'a Kaisaleai eta 'olaaku koana Feseto kevanai bevavaia. ");
INSERT INTO nrz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Boni vovo'o ua'i demia mulinai, Feseto eta'u lovia 'olana Akilipa kevanai Paulo lovana eakuia, ediaka, “Feliki 'eva kau ka nia'i vabuto'o lumanai evikania. ");
INSERT INTO nrz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ada'a Ielusalema koanai, kabukabu kauta namata mai Iuda kauta namata deasi keva'uai vuvua devakoala maivaka denoi'u bavavabuto'oa. ");
INSERT INTO nrz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","A'outa adiaka, ‘Loma kauta eta koakoa 'eva sia kanania boina, kau 'eva sia de'alavua 'avaea beda'amo vuvua devakoala kauna ita valuva 'abunai belavadivo ia mai ena komolo sibona valina bekakava.’ ");
INSERT INTO nrz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ia ita lai asi nia'i koanai, melala sia avadau'ala, elani ada'a valuva 'abunai amiadivo, avisini eda'a kau kanaua bevuala be'asi, inoku easi. ");
INSERT INTO nrz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Vuvua devakoala kauta deko'isi deluva koanai, lau alalovaia ia sia va'eva kai vuvua devakoala. ");
INSERT INTO nrz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Beia ia deadedua vai 'eva eta kukudivo dalanai maivaka ba kauna ka vana Iesu, kauna kanaua 'eva Paulo ediaka emauli kataua ia ita deadedua vai. ");
INSERT INTO nrz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Luva katania ikavuta avavitaitata e'uai sia edaia, kanaua 'ounai Paulo alavuaia be'ula koanai beda'a Ielusalemai ua'i bevaluvala. ");
INSERT INTO nrz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Beia ia enoinoi Kaisala ia bevaluvala, kanaua 'ounai aluva vabuto'o lumanai be'alavua bemimia beda'amo basinia beda'a Kaisala kevana.” ");
INSERT INTO nrz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Inoku Akilipa eta'u Feseto e'ouia ediaka, “Lau vaka a'ula sibo'u kaia'uai kau kanaua ena luva 'uluta ba'ika.” Feseto ia ena luva evamuea ediaka, “Mala ia ena luva 'uluta bo'ika.” ");
INSERT INTO nrz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Elani Akilipa mai Belenike eta tubu'a nama'ita mai nuavita eta bata'ina koana ivala'asina davata devadodota, kuali i'olavaina kauta mai vanua kauta namata ita dedodo deda'a do'u lumana. Feseto ena luvai Paulo devuaia deasi. ");
INSERT INTO nrz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Feseto eko'isi ediaka, “Lovia 'olana kaumu Akilipa mai oi ovaila kaumui boumuiai e! Kau kanania oi oikala. Iuda kauta ua'i Ielusalemai mai nia'i Kaisaleai demimia kauta boutai kau kanania keva'uai vuvua devakoavaia devaoi vaia dediaka, ‘Ia sia mai ena nama'ina bemimia, ia bebaba.’ ");
INSERT INTO nrz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ia bebaba va'evana sia ka adavalia, maivaka sibona enoi'u Kaisala ia bevaluvala, kanaua 'ounai alalovaia basinia beda'a Loma. ");
INSERT INTO nrz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Beia lau sia aikabasi ia akanai luva dava mo balelea beda'a Kaisala kevana. Kanaua 'ounai avuala a'asi oi boumuiai vailamuiai, mai namavaikana 'eva lovia 'olana kauna Akilipa vailamuai, ekalavuaia kave'i ia luvana nama'ina ekadavalia ekalelea. ");
INSERT INTO nrz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","'Olana lau lalovaia sia ekomolo bema vabuto'o kauna basinia 'avaea ia ena va'eva luvana sia balelea une koanai.” ");
INSERT INTO nrz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Akilipa eta'u Paulo e'ouia ediaka, “'Ani komolo avenimu sibomu vumu aku.” Inoku Paulo imana eabita isi inoku ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Lovia 'olana kauna Akilipa e, lau sibo'u alalovaia vali'u melala kanania'i oni vailamuai alalava 'eva enama'ina, 'olana Iuda kauta lau vuvua devakoa'u luvata vailamuai sibo'u vuta ba'aku. ");
INSERT INTO nrz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","'Olana dokadoka Iuda kauta eta koakoa mai eta adedua boutai 'eva oikabasita kave'i, kanaua 'ounai anoimu bovapasisimo kaiamu bovaala baluluva bo'ika. ");
INSERT INTO nrz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Iuda kauta boutai deikabasi'u, lau e'u mauli aboina kiki'uai abilamala easimo vali'u, e'u vanuai maivaka Ielusalemai 'eva deikabasi. ");
INSERT INTO nrz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ia siako 'ani deikabasi'u maivaka de'ula koanai, beluvasi, lau 'eva Palisea kaunai ao, ia eta kukudivo talavatuta pasisita devavai laloatai lau vaka ia daitai adai. ");
INSERT INTO nrz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Vali'u valuva 'abunai alalava 'eva 'olana Dilava ena luva'ana'i 'ava'avamai kevatai evavaia davana anuabata vaia 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Emai iduvu 'ouka lua (12) boni mai lani Dilava dekukudivo venia 'eva luva'ana'i kanania denuabata vaia bepupulu. Lovia 'olana e, nuabata kanaua 'ounai Iuda kauta lau vuvuana devakoa'u. ");
INSERT INTO nrz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Dava 'ounai Dilava ba kauta evako'isita 'udai 'eva sia oi oabivenia oi oko? ");
INSERT INTO nrz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Lau vaka nua'uai alalovaia Iesu Nasaleta kauna vana ivaiviivina vinaulata si'avanata doutamo bamavavaita 'eva bemanama'ina. ");
INSERT INTO nrz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Lau Ielusalemai kanaua boina avavaia, kabukabu kauta namata siavu deveni'u, ada'a Dilava ena kau doutamo abita vabuto'o lumanai a'alavuta, maivaka beaku bata luvana deluvaia koanai lau ima'u abia isi. ");
INSERT INTO nrz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Melala doutamo ada'a Iuda kauta eta lo'e ka ka laloatai akuta avala'asita, avakovoa a'outa eta abiveni bevunita, lau abadu venita vaika, ua'i kanobata edeatai kauta vaka ada'a akuta. ");
INSERT INTO nrz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Vinaula kanaua dainai 'eva melala kai kabukabu kauta namata siavu deveni'u desini'u ada'a Damaseko. ");
INSERT INTO nrz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Loviamu e, ado'alavuniai dalai 'ailala ka vutuvutu akanai aikaia, ena 'ailala 'eva melala ena 'ailala ekeinia, debano'u kauta ita eduimai kaiu. ");
INSERT INTO nrz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Lai boumaiai lai a'eko kanoai, lele ka 'Ebelu malatai e'ou'u aika ediaka, ‘Saulo e, Saulo e, dava 'ounai lau ovaiviivi'u? Lau ovasi'avana'u 'eva sibomu bovaanaanamu vinaulana ovavaia.’ ");
INSERT INTO nrz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Alavuaia adiaka, ‘Lovia namana e, oni dai?’ Lovia namana ediaka, ‘Lau Iesu, oni ovaiviivia kauna. ");
INSERT INTO nrz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ko'isi aemuiai lava, lau kevamuai availaasi 'eva oni adilamu e'u da'alaabi kaunai bo'ao, vali'u lau aoika'u koma mai vailai bavaikamu davata valita kau bo'outa. ");
INSERT INTO nrz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Lau Iuda kauta mai pulu edea kauta imatai oni bavamaulimu, maivaka basinimu boda'a pulu edea kauta kevata. ");
INSERT INTO nrz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Makata bovaata inoku vabuto'oai bovakeinita be'asi 'ailalai, inoku Satani ena siavu kevanai bekeini be'asi Dilava kevana, kanaua'i lau beabiveni'u ia eta si'avana i'ou kaota mai Dilava ena kabukabuta kauta viloatai ia eta 'abu be'abi.’ ");
INSERT INTO nrz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Lovia 'olana kaumu Akilipa e, vutuvutuai aikaia davana kanaua lelena daitai adai. ");
INSERT INTO nrz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Damasekoai ailolo makava, mulinai Ielusalemai, muliai Iudea vanuata boutai laloatai inoku ada'a pulu edea kauta kevatai ailolo 'eva ia belalo'udai inoku bemue'udai beda'a Dilava kevana, vinaula nama'ita bevavaita 'eva ia eta lalo'udai ivamomo'aina. ");
INSERT INTO nrz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kanaua dainai Iudea kauta lo'e kabukabuna laloanai deabi'u kao, de'ula beaku ba'u. ");
INSERT INTO nrz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Beia Dilava lau edulu'u basibasi easimo vali'u nia'i vailamuiai alalava inoku kikinai eda'a namana koanai boutai kevatai aluvasi vaia. Lau 'eva luva ka'onamo mo kanaua enolea kauta mai Mose ia lovana deakuia bepupulu davana luvana a'oumui. ");
INSERT INTO nrz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Keliso 'eva beanana inoku ba ai ko'isi 'udai imakavana, vamauli 'ailalana luvana beabia be'asi Isalaela kauta mai pulu edea kauta boutai kevatai.” ");
INSERT INTO nrz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo sibona valina ekava laloanai, Feseto evaoi ediaka, “Paulo e, oni 'olamu 'ani esi'avana, emu aoneka namavaikana eta'u 'olamu evasi'avanala. ");
INSERT INTO nrz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulo ia e'ouia ediaka, “Feseto Kau namamu e, lau 'ola'u 'eva sia esi'avana, lau aluvavai davata 'eva luva umauta maivaka mai anita. ");
INSERT INTO nrz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Lau aluvavai luvata katania 'eva lovia 'olana kauna vaka dava katania eikabasita 'ounai lau nua'u bounai aluluva. Lau aikabasi ia enai dava katania sia ka evuni, 'olana dava katania 'eva sia ua'i 'aba'abai depulu. ");
INSERT INTO nrz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Akilipa Lovia 'olana kaumu e, oni enolea kauta oabivenita, una? Lau aikabasi oni ia ovamomo'aita.” ");
INSERT INTO nrz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Akilipa Paulo e'ouia ediaka, “Melala kava'inamo kanania laloanai oni olalovaia lau Keliso ena kauai 'ani bovaao'u, una?” ");
INSERT INTO nrz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo ediaka, “Melala eto'oto'o 'o melala edau'a, lau Dilava anoia 'eva sia oni mo beia vali'u melala kanania'i lele'u oi o'ika kaumui boumuiai oi bomaasi lau boi'u oi bomaao, beia lau sia a'ula oi kanania boina beliomui.” ");
INSERT INTO nrz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Inoku Lovia 'olana kauna, Kavana kauna, Belenike mai ua'i demia kauta boutai deko'isi, ");
INSERT INTO nrz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","daiutu kanaua devikania dela'asi mulinai, ia ka ka sibota deviluva viveni dediaka, “Kau kanania 'eva sia dava ka evavaia si'asi'a kanaua'i ia bevabala 'o bevavabuto'oa.” ");
INSERT INTO nrz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Akilipa eta'u Feseto e'ouia ediaka, “Kau kanania 'ani kamavala'asia, beia ia Kaisala vana e'ouia ua'i bevavaluvala.” ");
INSERT INTO nrz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ia eta ula devalavala 'eva lai aunakoiai lai bakalima lai bada'a Italia, inoku Paulo mai vabuto'o kauta vaida 'eva kuali kauta sinavu ka e'olavaita kauna ka vana Iulio imanai deudata, ia 'eva lovia 'olana Aukusto ena kuali kauna ka. ");
INSERT INTO nrz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Lai Adalamutio aunakoina kai lai aele'au inoku Asia aveketa nabuata lai baveauta lai aveau asi, Tesalonikai Makedonia kauna ka vana Alisitako vaka lai viloamaiai. ");
INSERT INTO nrz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Elani 'eva Sidonoai lai avadai'au, inoku ua'i Iulio ena iulaveni koana Paulo kevanai evavaia 'eva beda'a ena kau beikata ena ula davata vaida bevenia. ");
INSERT INTO nrz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","'Abu kanaua lai avikania lai aveau asi 'udai 'eva lai ada'a Kupulo motumotu laloana eva'olo'oloa duasi lai aveaua 'olana lani evailamai easi. ");
INSERT INTO nrz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilikia mai Pamupulia 'atutai lai aveau keini lai avikanita lai ada'a Lukia kanobatanai 'abu vana Mula ai lai avadai'au. ");
INSERT INTO nrz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ua'i 'eva kuali i'olavaina kauna kanaua eta'u Alesandelea aunakoina ka beda'a Italia davana edavalia, inoku kanaua'i evanekemai keini. ");
INSERT INTO nrz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Boni doutamo maka'imaka'i lai aveau inoku mai bavunumai lai ada'a Kenido kevanai. Emai ula 'abuna lai aveau venia laloanai valea vailamaiai easi sia edaimai 'ounai Salamone i'donai lai aveau keini lai ada'a Kelete motumotuna laloana duasi lai aveaua. ");
INSERT INTO nrz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Mai bavunumai nabua 'aba'abana lai aveaua lai asi avadai'au 'abu ka vana ‘Aunakoi Eta Vadai'au 'Abuna Koevana Vaika’, 'abu kanaua mai Lasea vanuana viloata 'eva sia edau'a. ");
INSERT INTO nrz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Boni doutamo ua'i deole inoku lani esi'avanai 'atuai veauna 'ani besi'avana vaika 'olana vali'u Iuda kauta eta ani kabu melalana 'ani ekeinia. Kanaua 'ounai Paulo ia evaikabasita makava ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Kau boumuiai e, lau eta kalima aikala vali'u nia'i ekada'a 'eva besi'avana vaika inoku eta dava doutamo betaule, aunakoi bemukamuka mai eta mauli vaka ekaito'au.” ");
INSERT INTO nrz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Beia kuali i'olavaina kauna 'eva Paulo ena luva sia eabivenia, ia aunakoi 'uala kauna mai aunakoi ikalina kauna mo leleta eda'avai. ");
INSERT INTO nrz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","'Elu namavaikana ua'i aunakoi bevadai'au 'eva emai mia sia benama'ina, kanaua 'ounai kau doutamo 'eva deula lai bamaveau asi 'udai inoku bemadaia koanai Poenikia ai lai bamavadai 'au inoku 'elu namavaikana melalana 'eva ua'i mo lai bamamia. Kelete laloanai aunakoi eta vadai'au 'abuna kanaua mo enama'ina 'olana dae duasi divo duasi ita viloata mai dodo duasi divo duasi ita viloata duasi evailata. ");
INSERT INTO nrz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lani nama'ina divo duasi eunu koanai, ia delalovaia eta ula lanina 'ani eunu, 'ounai do'o develia 'au inoku Kelete nabuana 'aba'abana lai aveaua lai ada'a. ");
INSERT INTO nrz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Beia lai aveau asi sia e'oima 'eva Valea ka vana Eulakuilo 'eva motumotu duasi eunu easi. ");
INSERT INTO nrz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Levo aunakoi edavalia koanai, aunakoi Levo evailala 'eva sia edaia, kanaua 'ounai sia lai aula inoku lani evivumai lai ada'a. ");
INSERT INTO nrz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Motumotu kikina ka vana Kauda laloana eva'olo'oloa duasi lai alu keini koanai, emai ke'epi lai ado'o 'au laloanai bavunu namavaikana lai adavali. ");
INSERT INTO nrz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Inoku ia deta'u ke'epi develia 'au koanai 'onau vaida aunakoi venunai develita keini dedo'o 'inita, asi'i ua'i Libia polenai demaveau'au makauna 'eva palai deva'ovuta mai do'o dene'eia, inoku aunakoi ealu eda'a. ");
INSERT INTO nrz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Levo eunu si'asi'a eda'a boni ivaluanai 'eva kau eta dava vaida dekapoasi. ");
INSERT INTO nrz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mune'e eda'a boni ivakoinai 'eva aunakoi davana umauta vaida dekapoasi. ");
INSERT INTO nrz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Boni doutamo laloatai melala mai visiu sia ka lai aikaia mai Levo pasisina eunu basibasi, emai lalovai boutai deole lai alalovaia sia lai bamauli. ");
INSERT INTO nrz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kau boutai sia deaniani kovo melala edau'a vaika mulinai, Paulo eko'isi ia vailatai elavadivo inoku ediaka, “Kau boumuiai e, oi lau lele'u bomaika Kelete ai sia kamaveau asi koanai, si'avana kanania sia kamadavalia mai sia dava ka bemasi'avana maivaka sia dava ka kamavataulea. ");
INSERT INTO nrz_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Beia vali'u lau oi anoimui, nuamui oi bovakula'ilata, 'olana nia'i sia kau ka ena mauli betaule, aunakoi sibonamo betaule. ");
INSERT INTO nrz_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","'Olana lavi boniai e'u Dilava akukudivo venia Dilavana ena anelu esinia easi keva'uai elavadivo, ");
INSERT INTO nrz_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","inoku e'ou'u ediaka, ‘Paulo e, sia bomakau. Oni 'eva Kaisala vailanai bolalava bevaluvamu, Dilava ena vanama'ina oni akamuai 'ounai aunakoiai oi oele'au kauta katania boutai bemauli.’ ");
INSERT INTO nrz_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kanaua 'ounai kau boumuiai nuamui oi bovakula'ilata, 'olana lau Dilava abivenia 'eva ia lau e'ou'u davata vitaitatai bepupulu. ");
INSERT INTO nrz_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Beia ita 'eva ekaalu ekada'a motumotu kai ekavule'au.” ");
INSERT INTO nrz_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Boni iva'ouka vanina (14) boninai lai 'eva Adalia 'atubatanai lai avule do'o. Malolua laloanai aunakoi kauta deonovaia kanobata 'ani lai akevaia. ");
INSERT INTO nrz_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kanaua 'ounai 'onau deva'ovua eda'a 'atu 'oulana devakovoa 'eva lova lua navui (20), kena lai amia kovo mulinai devakovoa 'udai 'eva e'ovu lova 'ouka ima (15). ");
INSERT INTO nrz_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Aunakoi kauta demakau 'eva emai aunakoi asi'i bika'ai emaakua 'au 'ounai do'o vani aunakoi mulinai lai ava'ovuta, inoku deula bemalani kaokao. ");
INSERT INTO nrz_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aunakoiai devinaula kauta deula beveauovo, ke'epi ka 'atuai deva'ovua 'eva dedede dediaka aunakoi vailanai do'o vaida beva'ovuta. ");
INSERT INTO nrz_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Inoku Paulo kuali kauta mai ia i'olavaita kauna e'outa ediaka, “Kau katania aunakoiai sia bemimia koanai, oi sia oi bomauli.” ");
INSERT INTO nrz_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kanaua 'ounai kuali kauta ke'epi valona detauia uku e'ekoasi 'atuai evuleasi. ");
INSERT INTO nrz_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Melala ena dae ekevai laloanai, Paulo ia boutai enoita iani kena beania, e'outa ediaka, “Vali'u 'ani melala iva'ouka vanina (14) 'eva oi ovi'ima mo oi omimia, sia dava kena oi oania. ");
INSERT INTO nrz_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Vali'u 'eva anoimui iani kena oi bo'ani, oi boaniani 'eva mauli oi boabia. 'Olamuiai vui sia ka'onamo ka betaule.” ");
INSERT INTO nrz_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kanaua eluva koma mulinai, palaoa vaida eabita ia boutai vailatai Dilava kevanai evanama'inata, mulinai ekovia inoku eania makava. ");
INSERT INTO nrz_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Boutai nuata evakula'ilata inoku sibota vaka iani vitalua deabi deani. ");
INSERT INTO nrz_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Lai kaumai boutai sinavu lua kalakoi ka navui kalakoi (276) 'eva aunakoiai lai aele'au. ");
INSERT INTO nrz_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Boutai deaniani bo'ata dekubu kave'i koanai, iani dekapoasi 'atuai aunakoi bevaveaveala. ");
INSERT INTO nrz_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Taba elele koanai, kua deikaia beia 'abu dava sia deikaiaune, beia kanobata ka nabuana nama'ina deikaia, inoku nuata devaka'ona deula aunakoi nabua kanaua'i bemavadaia 'au. ");
INSERT INTO nrz_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Do'o valota detau uku, do'o 'atuai devikanita kali valona devadadata ovo inoku palai develia 'au lani bevivuta beda'a nabuai bevadai'au. ");
INSERT INTO nrz_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Beia aunakoi 'eva nekeneke ai emia'au, vailana emia'au 'ini sia e'iuvai'iuvai kovo, inoku ka'uda namata deta'u aunakoi 'ununa deakuia mukamuka. ");
INSERT INTO nrz_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kuali kauta eta lalovai 'eva vabuto'o kauta beaku bata 'olana asi'i demana'u 'au inoku demaveau 'akauma 'ounai. ");
INSERT INTO nrz_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Beia kuali i'olavaina kauna eula Paulo bevamaulia 'ounai kuali kauta eta lalovai vinaulana bevavaia davana e'alavua. Inoku e'outa na'u deikabasi kauta belovo asi makava benana'u beda'a nabua. ");
INSERT INTO nrz_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kau kalina bounai 'eva vaida aunakoi papa'ona si'asi'ata deabi mai vaida aunakoi davana kikita deabi dena'u. Kanaua boina devavaia 'eva boutai nabuai dela'asi mai nama'inata. ");
INSERT INTO nrz_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Boumaiai mai nama'inamai nabuai lai alavadivo koanai lai aikabasi motumotu kanaua vana 'eva Melita. ");
INSERT INTO nrz_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Motumotu kanaua kauta lai devikau venimai kave'i. Lamu eaku mai 'elu namavaikana 'ounai 'alova detouia lai boumai deabimaidae kaumai lai avasiavuta. ");
INSERT INTO nrz_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo au i'apana eabia 'alovai ene'eia 'au, alaala kau'asina 'alova siavuna eonovaia 'eva au i'apanai elovo asi Paulo imanai eala'au etabataba. ");
INSERT INTO nrz_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Motumotu kanaua kauta kau'asi Paulo imanai eala'au etabataba deikaia koanai ka ka deluva dediaka, “Ama'i kau kanania 'eva akuaku kauna, ia 'atuai sia ebaba maulinai ele'au, vali'u koana 'eva sia bemauli.” ");
INSERT INTO nrz_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Beia Paulo imanai kau'asi kanaua ekapoiaovo eda'a 'alova laloanai e'ekouda, ia sia ealaia. ");
INSERT INTO nrz_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Kau ua'i kauta delalovaia imana 'ani be'ale 'o bevada'unai be'eko bebaba, devi'ima eda'a melala edau'a ia kevanai sia dava ka epulu, inoku nuata devaedeana dediaka, “Ia 'eva dilava ka.” ");
INSERT INTO nrz_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ia demia kevana duasi kano kataua 'eva motumotu loviana kauna vana Pubilio ena 'abu, ia mai lalonamana ena lumai lai eabimaidae inoku boni koi laloanai e'imamai kave'i. ");
INSERT INTO nrz_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pubilio kamana 'eva e'olele lumai eno, ena 'olele 'eva kauna desiavu mai evabo'ane'ea. Paulo eda'a ena daiutu laloanai edodo akanai emeamea, imana ia akanai ekao'au 'eva enama'ina. ");
INSERT INTO nrz_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Koa kanaua epulu mulinai motumotu kanaua laloanai 'olele kauta boutai deasi inoku evanama'inata. ");
INSERT INTO nrz_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ia eta 'olaaku koana dala edeata edeatai lai deainama venimai, maivaka lai aveau asi koanai dalai lai aulavai davata boutai 'eva deuda 'au. ");
INSERT INTO nrz_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Vuia koi mulitai Alesandelea aunakoinai lai aele'au lai aveau asi 'atubatai. Aunakoi kanaua vana 'eva ‘Vi'apala’, ia 'elu melalanai motumotu kanaua'i evadai'au emia. ");
INSERT INTO nrz_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sulakuse ai lai ala'asi, ua'i boni koi lai amia. ");
INSERT INTO nrz_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ua'i emai palai lai akoia isi lai aveau asi lai ada'a Legio ai lai avadai'au, elani 'eva levo eunu, inoku lai aveau asi boni ivaluanai 'eva lai Puteoli ai lai aveau 'au. ");
INSERT INTO nrz_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ua'i bo'akalamai vaida lai adavalita, denoimai lai ada'a kevatai masi ka ia ita lai amia, ua'i lai ako'isi 'eva lai ada'a Loma. ");
INSERT INTO nrz_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ua'i bo'akalamai vaida lai valimai deika 'eva deasi mo vailai vanua vaida vata ‘Apio tavatava 'abuna’ mai ‘Laani lumata koi’ ua'i ia ita lai avidavali. Paulo kau katania eikata koanai Dilava evanama'inala maivaka nuana ekula'ila. ");
INSERT INTO nrz_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Lomai lai ala'asi koanai Paulo 'eva komolo devenia sibona luma kai emia, kuali kauna ka ia e'imaia. ");
INSERT INTO nrz_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Boni koi deole mulitai Paulo eta'u Iuda de'ana'iavaia kauta e'aeta ia ita bedodo'u, dedo'u koanai Paulo eko'isi ediaka, “Bo'akala'u boumuiai e, lau ita eta kau sia ka avasi'avanala 'o ita 'ava'avata eta koakoa sia ka avavaia si'asi'a, beia lau 'eva ua'i Ielusalemai ia delio'u inoku Loma kauta imatai deuda'u. ");
INSERT INTO nrz_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Loma kauta delavuai'u inoku deula bevala'asi'u 'olana sia si'avana ka dedavalia kanaua'i lau bevaba'u. ");
INSERT INTO nrz_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Beia Iuda kauta valuva luvana devasi'avanala, lau devasiasi'u mo Kaisala vana a'ouia, ia vailanai balalava bevaluva'u. Beia lau e'u kau umauta sia a'ou si'ata. ");
INSERT INTO nrz_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kanaua 'ounai lau a'aemui baikamui mai oi ita ekaluvaluva. 'Olana Isalaela kauta denuabata vaia kauna 'ounai seini kanania lau aka'uai.” ");
INSERT INTO nrz_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ia ena luva devamuea dediaka, “Oni luvamu malelena sia ka ua'i Iudeai easi lai adavalia, 'o bo'akalamai vaka ua'i sia luva ka deabia deasi 'o oni emu vavai si'avata vaika sia ka valina deluvavaia. ");
INSERT INTO nrz_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Vali'u lai a'ula oni emu lalovai luvana boluvavaia lelemu lai baika, 'olana lai aikabasi oni abido'u kataua ovavaia davana 'eva 'abu itoinai kau sia deula venia.” ");
INSERT INTO nrz_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Inoku Paulo 'eva do'u kauta ita boni ka dedilaia, boni kanaua eabia koanai kau doutamo develi deasi Paulo emia 'abunai dedo'u. 'Avu'avuni eda'amo eboni 'eva Paulo eta'u Dilava ena lovia vanuana lovana eakuia kau kevatai mai Iesu valina Puka kabukabunai deleleia Mose ena talavatu pukata laloatai mai enolea kauta eta pukai davana evaikabasi vaia bevinaula vaia. ");
INSERT INTO nrz_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kau vaida ena luva deika 'eva deabia dae, beia vaida 'eva ena luva sia deabivenia. ");
INSERT INTO nrz_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ia nuata sia eka'onamoai be'ulu, eta 'ulu laloanai Paulo luva ka'onamo kanania eluvavaia ediaka, “Idume Kabukabuna enolea kauna Isaia nutunai 'ava'avamui kevatai eluvaia kave'i kave'i ediaka, ");
INSERT INTO nrz_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Da'a kau katania kevatai bodiaka, Luva kanania oi boika 'udai'udai beia ovonai sia oi bo'ovo, oi bo'ika 'udai'udai beia sia oi boikala une. ");
INSERT INTO nrz_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","'Olana ulu kanania kauta 'eva nuata devabula avu kaiata debubu, makata de'ede. Sia kanaua bekoma koanai, makatai beikala, kaiatai lele be'ika, nuata beko'ovi, belalo'udai bekai'udai be'asi keva'u lau mauli bavenita.’ ");
INSERT INTO nrz_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kanaua 'ounai oi boikabasi kave'i, Dilava ena vamauli luvana 'eva pulu edea kauta kevata 'ani esinia, ia be'ika.” ");
INSERT INTO nrz_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(Paulo kanaua eluva koma mulinai Iuda kauta de'ulu, ia boutai luva kanaua sibota deviala vaia.) ");
INSERT INTO nrz_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo vikau itoitai lua ua'i emia, luma emia vaia davana sibona tavana eveni, kokona deasi beikala kauta boutai eabitadae. ");
INSERT INTO nrz_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ia Dilava ena lovia vanuana luvana eilolo vaia mai Lovia namana Iesu Keliso valina evaikabasi vaia mai kula'ilana ita, sia kau ka ia e'alavua. ");
INSERT INTO nrz_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Lau Paulo e'u malele kanania. Iesu Keliso ena da'ala iabina kau'u, ena veauneke kaunai ba'ao 'ounai Dilava edila'u e'ae'u ena vali nama'ina bailolo vaia. ");
INSERT INTO nrz_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Vali nama'ina kanania 'eva Dilava eta'u 'ani siako eluva'ana'i vaia ena enolea kauta nututai deluvavaia Puka Kabukabunai deleleia vitaitanai, ");
INSERT INTO nrz_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ia Nakuna valina, eta Lovia namana Iesu Keliso, kauai epulu Davida kekenai easi, ");
INSERT INTO nrz_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ia idumena kabukabunai 'eva ba ai evako'isia inoku evamomo'aia maisiavuna ia 'eva Dilava Nakuna. ");
INSERT INTO nrz_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Iesu Keliso dainai mai ia vanai vidulu namana mai veauneke koana 'ani lai abia, kanaua 'eva pulu edea kauta viloatai kau boutai lai ba'aeta beabiveni mai ia lelena be'ika. ");
INSERT INTO nrz_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Dilava eta'u e'aeta kauta viloatai oi vaka ua'i Iesu Keliso enai. ");
INSERT INTO nrz_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Loma ai oi omimia Dilava elalo'au venimui e'aemui ena kauai eva-aomui kaumui boumuiai, Kamata Dilava mai Lovia namana Iesu Keliso kevatai vilalo koana maivaka nua'elu oi boabia. ");
INSERT INTO nrz_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","E'u luva lava'ana'ina kanania: Iesu Keliso vanai e'u Dilava avanama'inala oi boumuiai daimuiai, 'olana oi emui abiveni valina kanobata bounai 'ani deika. ");
INSERT INTO nrz_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Dilava mainua'u bounai da'alana a'abi kanaua Nakuna valina nama'ina ailolo vaia Dilavana eikabasi e'u meamea ai lau oi alalovaimui, ");
INSERT INTO nrz_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","melala bounai e'u meamea ai Dilava anoia ena ulai dala'u bemaluvua melala ka bamavasi bamaikamui. ");
INSERT INTO nrz_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","'Olana lau e'u ula namana baikamui, idume ena ainama bavenimui inoku bevakula'ilamui. ");
INSERT INTO nrz_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ua 'eva lau oi viloamuiai bamimia laoanai lau mai oi ita sibota ekavidulu viveni, eta abiveniai ka ka ekaduluta. ");
INSERT INTO nrz_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bo'akala'u e, lau a'ula oi boikabasi, melala doutamo aula bavasi kele'emui, idume vuavuana badavali itani pulu edea kauta vaida eta mauli deveni aikata boina, beia dava vaida deta'u de'alavu'u easimo vali'u. ");
INSERT INTO nrz_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Lau 'eva vali nama'ina ikavanai tava baveveni kau boutai kevatai, 'Elene kauta mai 'ailala asi'i kauta maivaka nuata de'avaea kauta mai aoneka kauta kevatai. ");
INSERT INTO nrz_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kanaua 'ounai lau aula vaika oi Loma ai oi omimia kaumui vailamuiai vaka vali nama'ina bailolo vaia. ");
INSERT INTO nrz_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Lau vali nama'ina sia amalalai vaia, 'olana ia 'eva Dilava ena siavu, abiveni kauta boutai bevamaulita, lava'ana'ina 'eva Iuda kauta, muliai 'eva puluedea kauta. ");
INSERT INTO nrz_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","'Olana vali nama'ina enai komolo Dilava kevanai easi davana ela'asi, abiveniai emakavala beda'amo to'ona, puka kabukabunai deleleia boina, “Komolo kauna 'eva abiveniai bemauli.” ");
INSERT INTO nrz_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kau eta da'amulili mai vavai si'asi'a 'outai Dilava ena badu vutuvutuai evala'asia, eta koakoa si'avatai luva umauna dekaokaia kauta etai. ");
INSERT INTO nrz_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Dilava ikabasina ia etai 'eva makanaimo, 'olana Dilava eta'u evaikata. ");
INSERT INTO nrz_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Makavanai kanobata epulu easimo vali'u Dilava enai sia ka'ika davata kataua 'eva ena miakeinikeini siavuna mai idume maulina 'eva ia evavai davata laloatai dela'asi kave'i deikata deikabasita, kanaua 'ounai kau be'ouavuavu 'eva dalana asi'i. ");
INSERT INTO nrz_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Dilava deikabasia beia sia deabia dae maivaka sia devanama'inala ia 'eva Dilava, 'ounai nuata de'avaea mai nuata lalovaita si'avatai vabuto'o eta'u nuata e'alavua. ");
INSERT INTO nrz_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ia sibota delalovaia deaoneka, beia ia 'eva bo'o kautai deao. ");
INSERT INTO nrz_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Miakeinikeini Dilavana ikukudivo venia 'eva debolabolala, ia kau va'ava'ata sia bemiakeinikeini kauta, manumanu, sisi, delalau davata, mai va'ava'a imatai devavai davata dekukudivo venita. ");
INSERT INTO nrz_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kanaua 'ounai Dilava eta'u nuata si'avana eula venia 'abunai evikanita, inoku sibota eta koakoa si'avata vaika pedata vinaulata ka ka kevatai bevavai. ");
INSERT INTO nrz_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Dilava ena luva umauna 'eva ia deta'u dede davanai devaoa, beia Dilava dava evavai davata dekukudivo venita da'alata deabi. Beia evavaita kauna ia sibonamo ekavanama'inala beda'amo to'ona asi'i. Amen. ");
INSERT INTO nrz_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Dilava eta'u evikanita deda'a eta koakoa si'avata vaika laloatai. Eta 'a'ate deta'u 'a'ate dekulata kanaua sia bemakoma davana 'eva devavaia. ");
INSERT INTO nrz_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Dala vitaitanai momoluane vaka 'a'ate ita kamoanena sia deula, ia momoluane 'eva momoluane deula venita vaika. Momoluane sibota banota kevatai koa si'avata vaika devavai. Kanaua tavana 'eva eta koakoa si'avata daitai sibota mekauna dekoaia. ");
INSERT INTO nrz_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ia nuatai 'eva Dilava ilalovai 'ininai sia deula venia, Dilava eta'u eta bo'o lalovaitai evikanita, sia demavavai vinaulata 'eva devavai. ");
INSERT INTO nrz_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vinaula si'avata vaika edeata edeata nuatai devonu, koakoa si'avata vaika, 'oualavu mai lalovai si'avata vaika, mama, akuaku, viaku, dede mai nua vanana vinaulatai devonu. De'oukeinikeini, ");
INSERT INTO nrz_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","mai ka ka vata devavai si'asi'a luvaluvai, Dilava devaiviivia, deaivala 'avaea, de'apa, maivaka deabitaisi, lalovai si'avata vaika 'abu vaidai delalovaita bevavai. Kamata mai sinata leleta sia deika. ");
INSERT INTO nrz_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ia 'eva eta lalovailalovai asi'i, eta luva'ana'i sia deabi 'ini, mai kau etai 'eva nama'ina 'o vilalo sia devaikata. ");
INSERT INTO nrz_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Dilava ena talavatu deikabasia 'eva kau 'abu kanaua boinai demimia kauta 'eva bebaba. Beia si'avana kataua 'eva devavai basibasi inoku kau vaida devavai koanai devakula'ilata. ");
INSERT INTO nrz_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kanaua 'ounai luvai kau ka va'evai one'eadivo kaumu, sia maiemu komolo luvana ka. Oni luvai kau ka va'evai one'eadivo 'eva sibomu mekau ovenimu. 'Olana ia va'evai one'eadivo vinaulana vitaitanai oni vaka ovavaia. ");
INSERT INTO nrz_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ita kaikabasi Dilava 'eva maiena komolo kanaua devavai koma kauta va'evai bene'etadivo. ");
INSERT INTO nrz_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kanaua 'ounai oni luvai kau ka va'evai one'eadivo beia vinaulana vitaitana ovavaia kaumu, olalovaia Dilava va'evai bene'emudivo 'abunai 'ani boda'atau, una? ");
INSERT INTO nrz_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","'O dava 'ounai sia oikabasi Dilava ena nama'ina namavaikana kanaua eta'u e'ana'ia vaimu lalo'udai dalanai ena nama'ina namana, ena vi'ima mai ena vakula'ila oika 'iu'iuta? ");
INSERT INTO nrz_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Beia nuamu evabula, sia olalo'udai 'ounai oni sibomu emu mekau ovalalo, Dilava ena badu mai ena komolo lavuai melalanai bele'au koanai emu mekau ua'i bela'asi. ");
INSERT INTO nrz_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Dilava betata'u kau ka ka eta koakoa vitaitatai tavata bevenita. ");
INSERT INTO nrz_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kau vaida vinaula nama'ita devapasisi mai nuavi mai 'ola-aku maivaka sia bepupua maulina dekavua kauta 'eva Dilava betata'u mauli keinikeini bevenita. ");
INSERT INTO nrz_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Beia kau vaida deidono mai luva umauna ulana sia de'ula, vinaula va'evata deabidae kauta 'eva Dilava ena badu mai ena mekau akatai beva'ovua. ");
INSERT INTO nrz_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Vinaula si'avata vaika devavaia kauta boutai 'eva adedua mai anaana bekoala sia Iuda kautamo mo ia puluedea kauta vaka. ");
INSERT INTO nrz_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ia vinaula nama'ina devavaia kauta boutai 'eva Dilava betata'u nuavi, 'ola-aku mai nua'elu bevenita, makavana 'eva Iuda kauta, mulinai 'eva puluedea kauta. ");
INSERT INTO nrz_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","'Olana Dilava 'eva sia kau ka enai e'au. ");
INSERT INTO nrz_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mose ena talavatuai sia demimia kauta devinaula si'asi'a 'eva vinaula si'asi'a ananana beabia, ia talavatuai demimia kauta devinaula si'asi'a 'eva talavatu bevaluvata. ");
INSERT INTO nrz_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Talavatu 'uluna deika 'avaea kauta 'eva Dilava vailanai komolo sia beabia, ia talavatu vinaulana devavaia kauta 'eva komolota be'oua. ");
INSERT INTO nrz_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Puluedea kauta kevatai Mose ena talavatu 'eva asi'i, ia nuatai talavatu koana vitaitana devavaia koanai, talavatu kevatai asi'i beia ia sibota 'eva talavatuai de'ao. ");
INSERT INTO nrz_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ia talavatu luvana nuatai deleleia davana eta koakoai ela'asi mai nuata vaka kanaua evamomo'aia, eta lalovailalovai kanaua etata'u va'evata e'oua 'o komolota e'oua. ");
INSERT INTO nrz_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Vali nama'ina ailolo vaia vitaitanai, melalana bele'au koanai Dilava betata'u kau eta lalovai vuniatai bevaluvata Iesu Keliso dainai. ");
INSERT INTO nrz_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Oi sibomui oi odiaka oi 'eva Iuda kaumui, talavatuai oi olava 'ini mai Dilava oi oapavaia, ");
INSERT INTO nrz_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","maivaka Dilava dava eula venia davana oi oikabasia mai komolo e'asi 'abuna oi oikabasia 'olana oi talavatu oi omalele vaia. ");
INSERT INTO nrz_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Oi olalovaia oi 'eva maka'ede kauta ivada'ata kave'i mai vabuto'oai demimia kauta eta 'ailala ");
INSERT INTO nrz_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","maivaka bo'o kauta ivaidibata mai sia demalele kauta ivaikabasita kaumui, 'olana talavatu laloanai aoneka mai luva umauna itoinai oi odavalita. ");
INSERT INTO nrz_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Banomui oi ovaikabasita beia dava 'ounai oi sibomui sia oi ovamalelemui? Oi oilolo odiaka sia bevinao, beia oi ovinao? ");
INSERT INTO nrz_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Oi odiaka sia bekulakula, beia oi okulakula? Va'ava'a imatai devavai davata oi ovaivi-ivita, beia oi lo'e laloana davata ovinaota? ");
INSERT INTO nrz_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Oi talavatu emimia 'ounai oi o'apa, beia talavatu oi oukua 'eva Dilava vana oi ovavaia si'asi'a. ");
INSERT INTO nrz_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Puka kabukabuna laloanai ediaka, “Oi Iuda kaumui daimuiai puluedea kauta Dilava vana devavaia si'asi'a.” ");
INSERT INTO nrz_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Talavatu boda'avaia kave'i koanai iva 'eva nama'ina bevenimu, ia talavatu boukua koanai oni 'eva vitaitana iva sia oabia boina. ");
INSERT INTO nrz_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Puluedea kauna ka sia deivaia beia Dilava ena talavatu luvana beda'avaia kave'i koanai Dilava betata'u iva eabia kaunai bevaoa. ");
INSERT INTO nrz_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Inoku kauaninai sia eivaia beia talavatu eda'avai kave'i kauna betata'u oni Iuda kaumu va'evai bene'emu divo, 'olana talavatu deleleia davana kevamuai mai iva oabia beia talavatuna oukua 'ounai. ");
INSERT INTO nrz_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kau kauaninai ikana Iuda kauna beia sia Iuda kauna umauna maivaka kauaninai iva eabia 'eva sia iva umauna. ");
INSERT INTO nrz_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Beia nuana evamakamakala kauna ia 'eva Iuda kauna umauna, maivaka iva momo'aina 'eva nuana itoinai Idume Kabukabuna ai bevavaia, ia sia talavatuai. Kau kanaua boina 'eva vanama'ina Dilava kevanai beabia, ia sia kau kevatai. ");
INSERT INTO nrz_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Kanaua boina koanai Iuda kauta eta nama'ina 'eva dava? Iva ena nama'ina 'eva dava? ");
INSERT INTO nrz_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Dala doutamoai. Lava'ana'ina 'eva Dilava ena luva Iuda kauta kevatai ene'eia divo be'imala. ");
INSERT INTO nrz_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Bema vaida eta abiveni asi'i koanai aboina? Eta abiveni asi'i 'ounai Dilava sibona ena luva'ana'i sia bevamomo'aia, una? ");
INSERT INTO nrz_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kanaua sia bekoma. Kau boutai bededede, beia Dilava sibonamo ivamomo'aina. Puka kabukabunai deleleia vitaitana, “Emu luvai bovamomo'aimu 'eva okomolo. Inoku belavuaimu koanai bokomolo.” ");
INSERT INTO nrz_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Beia ita eta si'avana betata'u Dilava ena vinaula komolona bevala'asia koanai, ita dava ekakoma? Inoku Dilava ana-ana 'abunai ene'eta divo 'eva eva'eva, una? Asi'i. Sia kanaua bekoma. (Kanania 'eva kau eta lalovailalovai a'oua.) ");
INSERT INTO nrz_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Sia kanaua boina. Dilava sia bekomolo koanai, kanobata a belavuaia koma? ");
INSERT INTO nrz_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Vaida dediaka, “Lau e'u dede bemata'u Dilava ena luva umauna bevala'asia mai ena nuavi bevanamala koanai, dava 'ounai lau vinaula si'avana mekauna bavuala si'avana kauna boina?” ");
INSERT INTO nrz_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Vaida lai vuvua devakoamai 'avaea dediaka lai 'eva kanania aluva koma, “Nama'ina ivapuluna dainai si'avana vinaulata ekavavai.” Eta dede mekauna bekoala 'eva benama'ina. ");
INSERT INTO nrz_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kanaua boina koanai dava ekakoma? Ita Iuda kauta 'eva kanama'ina vakaia puluedea kauta? Asi'i vaika. 'Olana Iuda mai puluedea kauta 'eva si'avana laloanai kamimia luvana 'ani aluvaia. ");
INSERT INTO nrz_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Puka Kabukabunai deleleia vitaitana, “Kau ka sia ekomolo vaika Dilava vailanai, asi'i vaika. ");
INSERT INTO nrz_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Maivaka sia kau ka 'eva eaoneka, Dilava ikavuna kauna sia ka. ");
INSERT INTO nrz_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Boutai 'ani deda'a ovo inoku eta mauli 'eva anita asi'i maivaka sia vinaula kave'i kauna ka, asi'i vaika. ");
INSERT INTO nrz_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Eta luva bonata 'eva desi'avana itani mitava iluvuna, malata 'eva dede luvata deluluva. Nututa luvatai 'eva banota deva ana-anata itani kau'asi ivabata mulamulana boina. ");
INSERT INTO nrz_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Nututa 'eva sivada mai nua 'avala luvatai devonu. ");
INSERT INTO nrz_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Kau beva ana-anata mai beaku bata 'eva demolau. ");
INSERT INTO nrz_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","'Abu davana beda'ala 'eva kau bevaiviivita mai bevadeduata. ");
INSERT INTO nrz_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Maivaka nua'elu dalana 'eva sia deikabasia. ");
INSERT INTO nrz_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Dilava sia demakauvaia kovo.” ");
INSERT INTO nrz_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ita kaikabasi talavatu dava e'oua 'eva kau talavatu venunai demimia kauta eluva venita, inoku kau be'ou avuavu dalana 'eva asi'i, kanobata itoinai 'eva Dilava ena lavuai laloanai bedododo. ");
INSERT INTO nrz_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Dilava vailanai sia kau ka ekomolo talavatu ida'avai kave'ina dainai, inoku talavatu 'eva evaikabasita ita si'avana kauta. ");
INSERT INTO nrz_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Vali'u Dilava kau komolo bevenita dalana 'ani evala'asia, sia talavatuai, kanaua 'eva talavatu mai enolea kauta devamomo'aia. ");
INSERT INTO nrz_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Komolo Dilava kevanai easi 'eva Iesu Keliso deabivenia kauta boutai bedavalia, kau boutai kevatai sia ka 'eva bedeana. ");
INSERT INTO nrz_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","'Olana boutai 'ani si'avana devavai 'ounai Dilava ena nuaviai detabu. ");
INSERT INTO nrz_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Beia Dilava ena iulaveni koana 'eva eveni 'avaea, boutai komolo Keliso Iesu dainai deabia, 'olana ia eta'u etavata 'udai. ");
INSERT INTO nrz_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Dilava eta'u Iesu esinia easi kanobatai eba 'eva nua'elu koanai eao, eta si'avana daitai Iesu eba 'ounai eka abivenia kauta 'eva eta si'avana be'ou kao. Kanania evavaia 'eva ia ena komolo koana evaikata. Nuana eabia kao, 'ana'inai kau si'avana devavai kauta evikanita eta si'avana e'oukao. ");
INSERT INTO nrz_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Dilava koa kanaua evavaia 'eva vali'u melala katania daitai 'ounai sibona ena komolo evaikavaika vaia, dala kanaua'i Iesu deabivenia kauta vaka komolo bevenita. ");
INSERT INTO nrz_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kanaua boina koanai dava eka'apavaia? Inoku dala davanai? Talavatu ida'avainai? Asi'i. Sia dava ka ai. Ia abiveni dalanai. ");
INSERT INTO nrz_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Luva umauna ita kaikabasia 'eva Dilava abiveniai kau komolo evenita, ia sia talavatu ida'avainai. ");
INSERT INTO nrz_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Dilava 'eva Iuda kauta mo sibota eta Dilava, una? Ia puluedea kauta eta Dilavai sia be'ao, una? Asi'i. Ia 'eva puluedea kauta vaka eta Dilava. ");
INSERT INTO nrz_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Dilava 'eva ka'onamo iva kauta abiveniai komolo bevenita mai sia iva kauta vaka abiveni vitaitana aimo komolo bevenita. ");
INSERT INTO nrz_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Kanaua boina koanai ita 'eva abiveni kanania'i talavatu kavatauleia, una? As