﻿USE sofia;
DROP TABLE IF EXISTS sofia.nplNT_vpl;
CREATE TABLE nplNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nplNT_vpl WRITE;
INSERT INTO nplNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ninteh iwejkatatawah n Cristo Jesús, non walewatok itech David iwa noijki walewatok itech Abraham. ");
INSERT INTO nplNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ita n Isaac. Isaac ita n Jacob, iwa Jacob ita n Judá iwan oksikimeh ikniwah. ");
INSERT INTO nplNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ipilwah n Judá non okímpixki iwan Tamar, omonotsayah Fares iwa Zara. Fares ita n Esrom, iwa n Esrom ita n Aram. ");
INSERT INTO nplNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ita n Aminadab. Aminadab ita n Naasón. Naasón ita n Salmón. ");
INSERT INTO nplNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón iwa n Rahab okipixkeh inkone non itoka Booz. Booz iwa n Rut okipixkeh inkone non itoka Obed. Obed ita n Isaí. ");
INSERT INTO nplNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ita n rey David. N rey David ita n Salomón. Imamá n Salomón okatka isiwa n Urías. ");
INSERT INTO nplNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ita n Roboam. Roboam ita n Abías, iwa Abías ita n Asá. ");
INSERT INTO nplNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asá ita n Josafat. Josafat ita n Joram, iwa Joram ita n Uzias. ");
INSERT INTO nplNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias ita n Jotám. Jotám ita n Acaz, iwa Acaz ita n Ezequías. ");
INSERT INTO nplNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ita n Manasés. Manasés ita n Amón, iwa Amón ita n Josías. ");
INSERT INTO nplNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ita n Jeconías. Jeconías iwan ikniwah otlakatkeh itech tonatijmeh ijkuak n israelitas okinwikatokah kan tlali de Babilonia. ");
INSERT INTO nplNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Satepa de okinwikakeh Babilonia, Jeconías ita n Salatiel, iwa Salatiel ita n Zorobabel. ");
INSERT INTO nplNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ita n Abiud. Abiud okatka ita n Eliaquim, iwa Eliaquim ita n Azor. ");
INSERT INTO nplNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ita n Sadoc. Sadoc ita n Aquim, iwa Aquim ita Eliud. ");
INSERT INTO nplNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ita n Eleazar. Eleazar ita n Matán, iwa Matán ita n Jacob. ");
INSERT INTO nplNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ita n José. José omonamikti iwan María. María okatka imamá n Jesús non tejwah tikixmatih kemi Cristo. ");
INSERT INTO nplNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Opanokeh májtlaktli iwa n nawi (14) iwejkaixwiwah n Abraham asta otlakatiko David. Iwa satepa májtlaktli iwa n nawi (14) iwejkaixwiwah ijkuak ok onemia n David asta ijkuak okinwikakeh kan tlali de Babilonia. Iwa satepa ok májtlaktli iwa n nawi (14) iwejkaixwiwah ijkuak okinwikakeh n Israelitas kan tlali de Babilonia asta ijkuak otlakatiko n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijkí otlamochi ijkuak otlákatki n Cristo Jesús. María, imamá Jesús, yokichixtoka tonati para monamiktis iwan José. Pero ijkuak ayamó omonamiktiayah, María yokatka kókoxki ika konetl ika iweletilis n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José ya monamiktiskia iwan María, iwa kemi kuali tlakatl, ye amo okinek kipijpinatis n María, yika okimoli kikajkawas san ichtaka. ");
INSERT INTO nplNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ye okimoliaya ijkó kichiwas, pero se iángel n Totajtsi Dios okimonextili ijkuak otejtemiktoka iwa okili: —José, iwejkaixwi n David, amo ximawi tikselis n María kemi mosiwa. N konetl non kichixtok wits ika iweletilis Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María kipias se konetl, iwa te tiktlalilis itoka JESÚS, Ye kinmakixtis itlakaikniwah de intlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nochi ni opanok para mamochiwa tlan okijto Totajtsi Dios ijkuak okijkuilo n tiotlajto: ");
INSERT INTO nplNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Se íchpochtli kipias ijtik se konetl, iwa kitlakatilis, iwa kitlalilis itoka Emanuel. Emanuel kijtosneki: Dios kajki towah. ");
INSERT INTO nplNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ijkuak José oijsak, okichi tlan okinawati iángel Totajtsi Dios, iwa okiseli n María kemi isiwa. ");
INSERT INTO nplNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yejwah mach okochiah sansikah, asta ijkuak yotlákatki n konetl. Iwa José okitlalili itoka Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús otlákatki itech altepetl de Belén non kajki kan tlali de Judea. Itech nonteh tonatijmeh Herodes ye n rey. Ijkuakó owalajkeh kan ik kisa tonati sikimeh ixtlamatkeh. Yejwah okalakikoh Jerusalén, ");
INSERT INTO nplNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","iwa otlajtlankeh: —¿Kanin kajki inrey n judíojteh non yotlakatiko? Kan ik kisa tonati otiktakeh isitlal, yika otonwalajkeh otikweyijkachiwakoh. ");
INSERT INTO nplNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ijkuak n rey Herodes okikak nochi ni, omomojti, iwa nochteh n tlakah de Jerusalén noiwa omomojtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ijkuakó n rey Herodes okinmoololo nochteh n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawátili, iwa okintlajtlani kani tlakatis n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iwa yejwah okilijkeh: —Tlakatis itech altepetl de Belén, non kajki kan tlali de Judea, ijkó okijkuilo n profeta: ");
INSERT INTO nplNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Te Belén non tika itech tlali de Judá, te maya titsijtsikitsi, te okachi tiweyijkatitos. Motech kisas se weyi tlanawati, non kinyakanas nopilwah, n tlakah de Israel. ");
INSERT INTO nplNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ijkuakó Herodes san ichtaka okínnotski n ixtlamatkeh, iwa okinyektlajtlani tlan tonati oneski non sítlali. ");
INSERT INTO nplNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Otlanki okintítlanki mawiah Belén, iwa okinmili: —Xiwiah ompa, iwa xiyektlajtlanikah kanin kajki non konetl, iwa ijkuak nonkajsiskeh, sanima technawatikih ne noiwa nias nikweyijkachiwati. ");
INSERT INTO nplNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ijkuak n ixtlamatkeh okikakeh tlan okinnawati n Herodes, oonewakeh Belén. Iwa n sítlali non okitakeh kan ik kisa tonati, otlayakantia iwa omoketsato kan kajki n konetl. ");
INSERT INTO nplNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ijkuak n ixtlamatkeh okitakeh n sítlali, satlawel oyolpakeh. ");
INSERT INTO nplNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iwa ijkuak okalakeh itech kali, okitakeh n konetl iwan imamá María. Omotolojkeh inawak iwa okiweyijkachijkeh n konetl. Satepa okintlapojkeh inkaxajtsitsiwah iwa okitliokolijkeh oro, kópali iwa ajwiálistli non itoka mirra. ");
INSERT INTO nplNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Satepa, Dios okinnawatih ijkuak otejtemiktokah, iwa okinmili ayakmó mamokopakah kan Herodes, iwa n ixtlamatkeh omokopkeh incha itech ok se ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ijkuak n ixtlamatkeh yomokopkeh incha, se iángel Toteko Dios okimonextili n José ijkuak otejtemiktoka, iwa okili: —José, ximewa, xikonana n konetl iwa imamá, iwa xicholo kan tlali de Egipto. Ompa ximokawakah asta ijkuak ne nimitsnawatis xiwalmokopakah. Herodes kitemojtinemis n konetl para kimiktis. ");
INSERT INTO nplNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","San nima non yúali, José omejtewak, okónanki n konetl iwa imamá, iwa okinwík Egipto. ");
INSERT INTO nplNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iwa ompa omokajkeh asta ijkuak Herodes omikki. Ijkó otlamochi kemi okijto n Toteko ijkuak okijkuilo n profeta, iwa okijto: “De Egipto oníknotski Nokone.” ");
INSERT INTO nplNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ijkuak Herodes okitak okikajkayajkeh n ixtlamatkeh, satlawel okuálanki, iwa otlanawati makinmiktikah nochteh n kokoneh non sikin otlakatkeh iwa asta non ya kipiah ome xiwitl, nochteh non ochantitokah Belén iwa non ik ompa ochanchiwayah. Herodes ijkó okiyejyekoliaya ika tlan okilijkeh n ixtlamatkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijkó otlamochi kemi okijkuilo n profeta Jeremías: ");
INSERT INTO nplNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nochteh non ochantitoka Ramá okikakeh ijkuak chikawak ochokayah iwa omoyolkokoayah. Raquel okojtsajtsitokah, iwa amo okinekia moyolsewis, ken okinmiktilijkeh ipilwah. ");
INSERT INTO nplNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ijkuak Herodes yomikki, se iángel Toteko okimonextili n José ijkuak otejtemiktoka ompa Egipto iwa okili: ");
INSERT INTO nplNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ximewa, xikwika n konetl iwa imamá, iwa ximokopa kan tlali de Israel, porke yomikeh non okinekiah kimiktiskeh n konetl. ");
INSERT INTO nplNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ijkuakó José omejki, okiwík n konetl iwa imamá para Israel. ");
INSERT INTO nplNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ijkuak José okima Arquelao otlanawatijtoka Judea ipatka ita n Herodes, omaujki yas ompa. Iwa oyá Galilea kemi okinawatijkeh ijkuak otejtemik. ");
INSERT INTO nplNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ijkuak ompa okalakitoh, omochantitoh Nazaret. Ijkó omochi tlan okijkuilojkeh n profetas, Jesús kitokayotiskeh Nazareno. ");
INSERT INTO nplNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Itech nekateh tonatijmeh, Juan Bautista owala kan tlaltejtéyinki de Judea, otetlapowiko itlajtol Dios, ");
INSERT INTO nplNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","iwa okimiliaya n tlakah: —Ximoyolpatla inawak Dios, ya walajsi n tonati ijkuak Dios pewas tlanawatis. ");
INSERT INTO nplNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaías okitene Juan iwa okijto: Se tlájtoli tsajtsi kan tlaltejtéyinki: “Xikmajmanilikah se ojtli n Toteko, Xiktlapokah se ojtli milaktik.” ");
INSERT INTO nplNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Itlakeh n Juan ochijchitoka ika itsojmio n kameyo, iwa omotlajkoilpiaya ika se kuítlaxtli. Okinkuaaya chapulimeh iwa nékuitli non onka itech tepetl. ");
INSERT INTO nplNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Miakeh okonkakiah n Juan. Iwa amo oyaya san de Judea, noiwa non ochajchantitokah inakastla n río Jordán. ");
INSERT INTO nplNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iwa ijkuak okinmokuitiayah intlajtlakolwah, Juan okinkuaatekiaya ijtik río Jordán. ");
INSERT INTO nplNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ijkuak Juan okitak miakeh fariseos iwa saduseos owalayah inawak makinkuaateki, ye okinmili: —¡Nomejwah kemi nonkoameh! ¡Akin onomechili noncholoskeh de n temojti tlaijyowílistli non wits nomopah! ");
INSERT INTO nplNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xikchiwakah tlan kuali ijkó motas milák yononmoyolkopkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Iwa amo xikyejyekolikah weletis nonkijtoskeh: “Tejwah titepilwah de Abraham.” De milajka nomechilia asta ninteh temeh, Dios weletis kinkopas ipilwah n Abraham. ");
INSERT INTO nplNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","N acha ya tlatentitok iwa sa mochixtok para nomechnelwayotsontekis. Porke nomejwah amo kuali tlakilo nonkitemakah, yika nomechtsontekiskeh iwa nomechtlamotlaskeh ijtik tletl. ");
INSERT INTO nplNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Milák, ne nomechkuaatekia ika atl porke yononmoyolkopkeh, pero walmuikas ok se Akin okachi weletini ke ne, iwa ne amo ni tlawel kuali para nikkaktojtomas. Ye nomechkuaatekis ika Espíritu Santo iwa ika tletl. ");
INSERT INTO nplNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akin wits satepa, kinxexelos n kualteh iwa non amo kualteh. N kualteh kinmakixtis, pero non amo kualteh kinkajkawas ijtik tletl non amayik sewis. ");
INSERT INTO nplNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Se tonati Jesús okiski de Galilea iwa okalakito kan río Jordán, para makikuaateki n Juan. ");
INSERT INTO nplNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan amo okinekia kikuaatekis n Jesús, iwa okili: —¿Tikneki ne manimitskuaateki? ¡Amó, yej tejwatsi techkuaateki! ");
INSERT INTO nplNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero Jesús okinankili: —Axa ijkó xikchiwa, moneki tiktlakitaskeh tlan Dios otlanawati. Ijkuakó Juan okili kualiká, ");
INSERT INTO nplNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","iwa okikuaateki. Ijkuak Jesús okiski de ijtik atl, okitak owalmotlapo n ilwikak iwa Iespíritu n Dios owaltemok ipan Jesús kemi se palomatsi. ");
INSERT INTO nplNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iwa itech ilwikak omokak se tlájtoli non okijtoaya: —Ye nin Nokone non saikpanoa niktlasojtla, iwa satlawel nechyolpaktia. ");
INSERT INTO nplNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Satepa, n Espíritu okiwík n Jesús kan amaka chanti para n amokualitlakatl kitoktis matlajtlakolchiwa. ");
INSERT INTO nplNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús amo otlakua ome póali tonati iwa ome póali yúali, ompa kan amaka chanti, iwa satepa owalxitlatlak. ");
INSERT INTO nplNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ijkuakó n amokualitlakatl tekajkaya omijkuani inawak Jesús iwa okili: —Tla milák Te Ikone Dios, xikinnawati ninteh temeh mamokopakah paj. ");
INSERT INTO nplNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Jesús okinankili: —Itlajkuilol Dios kijtoa: “N tlakatl amo san ika paj yolitok, yej noiwa ika nochi tlájtoli non Dios kijtoa.” ");
INSERT INTO nplNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Satepa n amokualitlakatl okiwík n Jesús kan Jerusalén, okitlejkolti ikpak n Weyi Tiopa ");
INSERT INTO nplNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","iwa okili: —Tla milák Te Ikone Dios, ximotlamotla, porke itlajkuilol Dios kijtoa: Dios kinnawatis iangelwah mamitsmatsakuilikah, para amo tikmomakati ika itla tetl. ");
INSERT INTO nplNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús okili: —Itlajkuilol Dios noiwa kijtoa: “Amo xikyejyeko Moteko Dios.” ");
INSERT INTO nplNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sa iksemi n amokualitlakatl okiwík n Jesús ipan se tepetl non okachi wejkapa, iwa ompa okimititi nochteh n tlalmeh kan tlanawatiah n tlaltikpaktlakah ika nochi inweyilis, ");
INSERT INTO nplNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","iwa okili: —Nochi ni nimitsmakas, tla techweyijkachiwas iwa timotlankuaketsas nonawak. ");
INSERT INTO nplNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ijkuakó Jesús okili: —¡Xio, satanás!, porke itlajkuilol Dios kijtoa: “Xikweyijkachiwa Moteko Dios, iwa sanwel Ye tiktekichiwilis.” ");
INSERT INTO nplNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ijkuakó n amokualitlakatl okikakajte n Jesús, iwa sikimeh ángelteh omijkuanijkeh okitekichiwilikoh. ");
INSERT INTO nplNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ijkuak Jesús okima n Juan Bautista otsaktoka, oyá kan tlali de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Okiski de Nazaret, iwa oyá ochanchiwato kan se altepetl non itoka Capernaúm, non kajki itempa n weyi atl de Galilea, itech tlalmeh de Zabulón iwa de Neftalí. ");
INSERT INTO nplNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ijkó otlamochi tlan Dios okijto ijkuak okijkuilo n tiotlajto Isaías: ");
INSERT INTO nplNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tlalmeh de Zabulón iwa Neftalí, ojtli non panotok inakastla n atl, ik nepa lado de n río Jordán, tlali de Galilea kan chanchiwah non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","N tlakah non ochanchiwayah kan tlatleyua, okitakeh se weyi tláwili. Akimeh omokajkeh iwa okinmokemih itlasekawilo n mikílistli, axa se tláwili okinmonextili. ");
INSERT INTO nplNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ijkuakó, Jesús opé tlamachtia, iwa okimiliaya: —Ximoyolpatlakah, porke ya walajsi n tonati ijkuak Dios pewas tlanawatis. ");
INSERT INTO nplNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Se tonati Jesús onejnentiaya itempa n atl de Galilea, iwa okinmitak ome iknimeh, Simón akin okinotsayah Pedro iwa ikni Andrés. Yejwah omichmajtokah porke yejwah michmajkeh, ");
INSERT INTO nplNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","iwa Jesús okinmili: —Xiwikih nowa, iwa ya nonkinmichmaskeh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yejwah sa nima okinkajtejkeh inmichayawah iwa oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús ok onejnentiaya itempa n atl, iwa okachi tlayakapa okinmitak ok ome iknimeh, Jacobo iwa Juan, itelpochwah n Zebedeo. Yejwah okintlajtlamanilijtokah inmichayawah ijtik se barka iwan inta. Jesús okínnotski, ");
INSERT INTO nplNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","iwa yejwah sa nima okikakajtejkeh inbarka iwa inta, iwa oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús onemia itech nochteh n altepemeh de Galilea, otlamachtijtiaya itech sinagogas iwa okinmatiltiaya n kualitlájtoli de Dios iwa okimiliaya kenomi moneki timoyekuikaskeh. Iwa okimpajtiaya n tlakah de nochi kokólistli iwa de nochi tlan okinkokoaya. ");
INSERT INTO nplNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Itech nochi tlali de Siria, omoma tlan Jesús okichiwaya, okwalinwikilijkeh nochteh akimeh otlaijyowiayah ika miak kokólistli: non satlawel okinkokoaya inkuerpo, akimeh okimpiayah espíritus amokualteh, akimeh omimikiah iwa akimeh amo oweletiah onejnemiah. Jesús nochteh okimpajtiaya. ");
INSERT INTO nplNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Opé yawih iwan Jesús miakeh tlakah de Galilea, Decápolis, Jerusalén, Judea iwa akimeh ochanchiwayah ik nepa lado de río Jordán. ");
INSERT INTO nplNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ijkuak Jesús okinmitak omoololojkeh miakeh tlakah, otlejkok ipan tepetl iwa ompa omotlali. Ijkuakó itlamachtijkawah omijkuanijkeh inawak. ");
INSERT INTO nplNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ye opé kinmachtia: ");
INSERT INTO nplNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Mapakikah non yolyámankeh, porke yejwah kinmaxkatiliskeh kan Dios tlanawatijtos. ");
INSERT INTO nplNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'Mapakikah akimeh tlaijyowiah, porke Dios kinyolsewis. ");
INSERT INTO nplNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'Mapakikah non moikneliah, porke Dios kinmaxkatilis n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'Mapakikah akimeh kinekih ika nochi inyolo nochi mamochiwa ika milajkachiwálistli, porke Dios kinmakas tlan kitlajtlanih. ");
INSERT INTO nplNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'Mapakikah non teiknomatih, porke Dios noiwa kimiknomatis. ");
INSERT INTO nplNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'Mapakikah non yolchipawakeh, porke yejwah kitaskeh Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'Mapakikah non teyolsewiah, porke yejwah kinnotsaskeh impilwah Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","'Mapakikah akimeh kintotojtokah por kichiwah tlan Dios kineki, porke inmaxka n ilwikak kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","'Mapakikah ijkuak fiero kintenewah, kintotojtokaskeh iwa kinwikaltiskeh por nechtlakitah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ijkuakó xipakikah porke nonkiseliskeh se weyi tlatliokólili kan ilwikak. Ijkó noiwa okintlaijyowiltijkeh n profetas non yonenkeh ijkuak nomejwah ayamó ononkatkah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","'Nomejwah yononmochijkeh istatl itech nin tlaltíkpaktli. Pero tla n istatl ayakmó tlapuyeya, ¿tlan ika tlapuyeyas? Mach ok kuali, sa kitepewah kala iwa nochteh kitlajtlaksah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'Nomejwah non tláwilteh itech nin tlaltíkpaktli. Amo weletis motlaatis se altepetl non kajki ipan se tepetl. ");
INSERT INTO nplNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Amaka kimilintia se kandil iwa kitlaatis itlampa se kajo, yej kitlalia tlakpak para makintlawili nochteh non kateh ijtik kali. ");
INSERT INTO nplNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ijkó noiwa, nomejwah xikintlawilikah n tlakah para makitakah nomejwah nonkichiwah tlan kuali, ijkó n tlakah kitaskeh tlan kuali nonkichiwah. Ijkó yejwah kiweyijkachiwaskeh Nomotajtsi Dios non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","'Amo xikmolikah oniwala onikpojpoloko n tlanawatílistli noso intlajkuilol n profetas. Amo oniwala onikimpojpoloko, yej oniwala para mamochiwa tlan kijtoa. ");
INSERT INTO nplNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","De milajka nomechilia, n ilwikak iwan tlaltíkpaktli pojpoliwiskeh, pero nochi tlan ijkuilitok, maya tlan okachi tsijtsikitsi, saman mochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yika, akin amo kintlakita seme de ninteh tlanawátilteh, maya amo okachi ipati, iwa ijkó kitemachtia, non tlakatl kitaskeh kemi se non amo okachi ipati kan Dios tlanawatia. Pero tla aka kintlakitas nochteh n tlanawátilteh iwa kinmachtis oksikimeh makintlakitakah, yetos weyi kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ne nomechilia, tla amo nonkichiwah tlan Dios kineki, amo nonkalakiskeh ilwikak kan Dios tlanawatia. Moneki nonkiyekchiwaskeh nochi ni, iwa amo tlan okitemachtijkeh n fariseos iwa non kitemachtiah intlanawatil. ");
INSERT INTO nplNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","'Xikilnamikikah yowejka Moisés okinmilijkah nomotatawah: “Amo xitemikti, porke akin temiktis trato kitlajtlakolmakaskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ne nomechilia: Nochi akin kikualankaita se ikni, moneki makitlajtlakoltikah. Iwa akin kilia ikni amo kipia ikuatetex, kitlajtlakolmakaskeh kan Sanedrín. Noiwa akin kinotsa ikni tikuatlapolojtok, yas miktla ijtik tletl. ");
INSERT INTO nplNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Noiwa, tla ya tio tiktemakati motlamanal itech artal iwa tikilnamiki amo timowika iwan mokni, ");
INSERT INTO nplNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ompa xikkawa motlamanal iyakapa n artal iwa achto xio ximotlapojpolwiti iwa mokni. Ijkuakó ya weletis tiwalmokopas kan artal iwa tikyektemakas motlamanal. ");
INSERT INTO nplNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Tla aka mitsteilia iwa kijtoa itla tikwikilia, ximoyekkawa íwa, para amo mamitstemakti imak tekiwa, tlamó n tekiwa tlanawatis mamitstsakuakah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","De milajka nimitsilia, amo tikisas de ompa asta ijkuak yotiktlaxtla nochi tlan mitstlajtlanilia. ");
INSERT INTO nplNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","'Nomejwah yononkikakeh tlan achto omijto: “Amo xikinpapatla siwameh.” ");
INSERT INTO nplNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ne nomechilia, nochi tlakatl non kelewia se siwatl non amo iaxka, kijtosneki yokimomekati itech iyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Noiwa, tla moixtololo non kajki moyekma mitstoktia xitlajtlakolchiwa, wejka xiktlamotla. Okachi kuali xikpolo itla de mokuerpo, iwa amo nochi mokuerpo makontlamotlakah miktla. ");
INSERT INTO nplNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iwa tla momayekma mitstoktia xitlajtlakolchiwa, xikmotekili iwa wejka xikontlamotla. Okachi kuali xikpolo itla de mokuerpo, iwa amo nochi mokuerpo makontlamotlakah miktla. ");
INSERT INTO nplNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","'Moisés okijkuilo: “Akin mosiwakajkawa, moneki makimaka isiwa se amatl non makichijto kikajkawa isiwa.” ");
INSERT INTO nplNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ne nomechilia: tla se tlakatl kikajkawa isiwa, maya isiwa amo kema omomekati, non tlakatl kitopejtok isiwa mamomekatijtinemi. Iwa akin monamiktia iwa non siwatl, san kimomekatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","'Nomejwah yononkikakeh yowejka Dios okinmili nomotatawah: “Tla itla yotiksentlalili Dios, moneki tikchiwas.” ");
INSERT INTO nplNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Axa Ne nomechilia, amitla xiksentlalikah: nion por ilwikak, porke Dios ompa yayantitok. ");
INSERT INTO nplNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nion xiksentlalikah por nin tlaltíkpaktli, porke ompa kan Dios kinsewijtok ikxiwah. Nion xiksentlalikah por Jerusalén, porke non altepetl iaxka n Weyi Rey. ");
INSERT INTO nplNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nion amo ximotlajtolsentlali por motsonteko, porke amo tiweletis tiktlilewiltis nion tikistayaltis nion se motsonkal. ");
INSERT INTO nplNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tla itla nonkichiwaskeh san xikijtokah tla “ejé”, “ejé”, noso tla “amó”, “amó”, porke nochi tlan amo milák nonkajxitiliskeh, walewatok itech amokualitlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","'Nomejwah yononkikakeh kan Moisés okijkuilo: “Tla aka mitskopinilia moixtololo, makikopinilikah ye noiwa. Tla aka tetlantepewa, makitlantepewakah ye noiwa.” ");
INSERT INTO nplNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero axa Ne nomechilia: Amo xikmokopilikah ijkuak itla amo kuali nomechtoktiah. Yej, tla aka mitsixtlatsinia xikkawili mamitsixtlatsini iojkatia moixko. ");
INSERT INTO nplNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tla aka mitsteilia para mitskixtilis motlake, xikkawili noiwa mamitskixtili mokoto. ");
INSERT INTO nplNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iwa tla aka mitstoktia xikwikili itlamamal se kilómetro, te xikwikili ome kilómetro. ");
INSERT INTO nplNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akin mitstlajtlanilis itla, xikmaka. Iwa akin mitstlanewilis itla, xiktlaneti. ");
INSERT INTO nplNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","'Noiwa yononkikakeh tlan yomijto: “Xiktlasojtla non mitstlasojtla, iwa xikkokoli non mitskokolia.” ");
INSERT INTO nplNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero Ne nomechilia: Xikintlasojtlakah akimeh nomechkokoliah, iwa xiktlajtlanilikah Dios makintiochiwa akimeh nomechtotojtokah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ijkó nomejwah nonyetoskeh ipilwah n Totajtsi Dios non kajki ilwikak. Ye kichiwa makisa n tonati impa non kichiwah tlan kuali iwa kichiwah tlan amo kuali. Iwa kualtitlani n kiawitl impa n kualteh tlakah iwa n tlakah non amo kualteh. ");
INSERT INTO nplNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porke tla nomejwah nonkintlasojtlah sanwel akimeh nomechtlasojtlah, ¿tlan tlaxtláwili nonkiseliskeh ika noni? N tominoololojkeh noijkó kichiwah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iwa tla san nonkintlajpaloah nomokniwah, ¿amo nonkichiwah tlan oksikimeh kichiwah? Non amo kixmatih Dios, noijkó kichiwah. ");
INSERT INTO nplNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nomejwah xiyetokah non milajkameh, ijkó kemi Nomotajtsi Dios non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","'Ijkuak nomejwah nonkichiwaskeh itla kuali, amo xiktematiltikah ixpa n tlakah, porke tla ijkó nonkichiwah, Dios ayakmó nomechmakas nomotlatliokolil kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Yika, ijkuak itla tikintliokolis n próbesteh, amo xiktematiltijtinemi kemi kichiwah non kipiah ome imixko. Yejwah kinekih makinmitakah itech sinagogas iwa itech ojtli yejwah milák kitemoah Dios, iwa ijkó kuali matlajtokah de yejwah. Pero de milajka nomechilia, Dios mach ok itla kintliokolis nonteh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero ijkuak te itla tiktetliokolis, amaka xiktlapowi. ");
INSERT INTO nplNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ijkó motlatliokolil yetos san ichtaka, iwa Dios n Teta non kita nochi tlan tikchiwa san ichtaka, Ye mitsmakas motlatliokolil. ");
INSERT INTO nplNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","'Ijkuak nomejwah nonmotiotsajtsiliskeh, amo xikchiwakah tlan kichiwah n íxkopteh, yejwah kiwilitah makinmitakah ijkuak motiotsajtsiliah. Yika motiotsajtsiliah moketokeh itech sinagogas iwa itech ojmeh kan panoah miakeh tokniwah. Kuali xikmatikah, san ijkó kipiaskeh intlatliokolil. ");
INSERT INTO nplNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ijkuak timotiotsajtsilis, xikchiwa moselti. Xikalaki mocha, ximokaltsakua iwa ompa ximotlapowi san ichtaka iwa n Dios Motajtsi, iwa Ye mitsmakas tlan tiktlajtlanilis san ichtaka. ");
INSERT INTO nplNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","'Iwa ijkuak nonmotiotsajtsiliskeh, amo san ompa xikojpatilijtokah nomotlajtol kemi kichiwah non amo kixmatih Dios, yejwah kimoliah tla san ompa kojpatilijtoskeh intlajtol, Dios okachi kinkakis. ");
INSERT INTO nplNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nomejwah amo xikchiwakah kemi yejwah kichiwah, porke Totajtsi Dios ya kimatok tlan nomechpoloa achto de nonkitlajtlaniliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yika, nomejwah ijkí moneki ximotiotsajtsilikah: Totajtsi Dios non timoitstika ilwikak, nochipa makiyektenewakah motoka. ");
INSERT INTO nplNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Xiwalmuika xitlanawatiki, mamochiwa tlan Tejwatsi tikmonekiltia itech nin tlaltíkpaktli, ijkó kemi mochiwa kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Techmaka nochi tonati tlan tikmomajsewiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Techintlapojpolwili totlajtlakolwah, ijkó kemi tejwah noiwa tikintlapojpolwiah akimeh techtoktiah tlan amo kuali. ");
INSERT INTO nplNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amo xiktekawili matechyoltilana n tlajtlákoli, yej techmakixti imak n amokualitlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","'Tla nomejwah nonkintlapojpolwiah non nomechtoktiah tlan amo kuali, Nomotajtsi non kajki ilwikak noiwa nomechtlapojpolwis. ");
INSERT INTO nplNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero tla amo nonkintlapojpolwiah n tlakah, noiwa Nomotajtsi amo nomechtlapojpolwis. ");
INSERT INTO nplNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","'Ijkuak nomejwah nonmosawaskeh, amo xiiknotlachiakah kemi kichiwah non íxkopteh. Yejwah iknotlachiah san para makinmitakah mosaujtokeh. Ne nomechilia, sanwel noni yetos intlatliokolil. ");
INSERT INTO nplNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yika, ijkuak te timosawas, ximotejtema iwa ximixami, ");
INSERT INTO nplNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para amaka makimati kox timosaujtok. Sanwel Dios Motajtsi, Akin kimati nochi tlan se kitlatijtok itech iyolo, Ye kimati timosaujtok iwa mitsmakas motlatliokolil. ");
INSERT INTO nplNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","'Amo xikoololokah miak tomi itech nin tlaltíkpaktli kan tlakuakualoa iwa tlapoxkawi, iwa n ichtekeh techankalakih iwa tetlachtekiah. ");
INSERT INTO nplNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yej xikoololokah itech ilwikak tlan milák ipati. Ompa amo weletis kuakualos iwa amo poxkawi, nion ichtekeh weleti kalakih. ");
INSERT INTO nplNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kan kajki tlan momejwah nonkimoliah ipati, ompa kajki nomoyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","'Nomoixtololowah kateh kemi se tláwili non kitlawiliah nomokuerpo. Yika, tla nomoixtololowah chipawatokeh, kuali kitlawilijtoskeh nochi nomokuerpo. ");
INSERT INTO nplNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero tla nomoixtololowah tlajtlakolchiwah, nochi nomokuerpo kajki kan tleyua. Iwa tla motlawil ayakmó tlawia, kijtosneki nonkateh kan sentleyua, ¡saikpanoa tliliktik yetos non sentleyuálistli nomotech! ");
INSERT INTO nplNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","'Amaka tlakatl weletis kintekitilis ome inteko, porke se kitlawelitas iwa non ok se kitlasojtlas, noso se kitlakitas iwa non ok se mach kitlakitas. Amaka weletis kimopantis Dios tla satlawel momijmiktia para kitlawelpias tomi. ");
INSERT INTO nplNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","'Yika nomechilia: Amo ximotekipachokah por tlan nonkimomajsewiskeh noso tlan nonkoniskeh para ika nonyolitoskeh, noso tlan nonkonakiskeh. ¿Amo okachi ipati nomoyolilis ke nomotlakual, iwa amo okachi ipati nomokuerpo ke nomotlakeh? ");
INSERT INTO nplNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xikinmitakah n totomeh non patlantinemih, yejwah amo tookah nion pixkah, iwa nion amitla kitlaatiah. Iwa Nomotajtsi Dios non kajki ilwikak kintlakualtia. ¡Iwa nomejwah okachi nomopati ke n totomeh! ");
INSERT INTO nplNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Tla aka de nomejwah satlawel motekipachoa, yolitos ok se tonati? ");
INSERT INTO nplNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","'¿Iwa tleka nomejwah saikpanoa nonmotekipachoah por nomotlakeh? Xikinmitakah kenomi moskaltiah n xochimeh, yejwah amo tekitih iwa nion motlajtsomiah. ");
INSERT INTO nplNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Iwa Ne nomechilia nion rey Salomón non saikpanoa omoyektlakentiaya, owéletki omotlakenti kemi ninteh xochimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iwa tla Dios ijkó kitlakentia se xochitl non axa selistok tlajtlala iwa mostla kichichinoah ijtik tletl, ¡okachi miak kichiwas por nomejwah akimeh nonkipiah achitsi tlaneltokálistli! ");
INSERT INTO nplNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yika, amo ximotekipachokah nion xikmolikah: “¿Tlan tikmomajsewiskeh? noso ¿tlan tikoniskeh? noso ¿tlan tikonakiskeh?” ");
INSERT INTO nplNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porke nochteh non amo kixmatih Dios kitemolijtinemih kenomi kipiaskeh nochi ni, pero nomejwah nonkipiah se Nomotajtsi non kajki ilwikak, iwa Ye ya kimatok tlan nomechpoloa. ");
INSERT INTO nplNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nomejwah moneki achto xikchiwakah tlan Dios nomechnawatia iwa xikchiwakah tlan Ye kimonekiltia. Iwa ijkó Dios nomechmakas nochi tlan nomechpolos. ");
INSERT INTO nplNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yika, amo ximotekipachokah kenomi nontlanexiliskeh, porke mostla ok se welta nonmotekipachoskeh. Nochi tonati saman yetos itla tlan ika weletis nonmotekipachoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","'Amo xikimpojpoakah oksikimeh, ijkó noiwa amo manomechpojpoakah nomejwah. ");
INSERT INTO nplNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porke ijkó kemi nomejwah nonkimpojpoaskeh oksikimeh, ijkó nomechpojpoaskeh. Iwa ijkó kemi nomejwah nontlatamachiwah, noiwa ijkó nomechtamachiwaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Tleka tikitilia n tlajsoltsintli non kajki ijtik iixtololo mokni, iwa amo tikita n tláktsontli non kajki ijtik moixtololo? ");
INSERT INTO nplNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¡Kenijki weleti tikilia mokni: “Techkawili manimitskixtili n tlajsoltsintli non tikpixtok ijtik moixtololo,” iwa te ok tikpixtok se tláktsontli ijtik moixtololo! ");
INSERT INTO nplNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Íxkoptli! Achto xikmokixtili n tláktsontli non tikpixtok ijtik moixtololo, iwa ijkó weletis tiyektlachias iwa weletis tikkixtilis n tlajsoltsintli non kipixtok mokni ijtik iixtololo. ");
INSERT INTO nplNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","'Tlan tiochitok iwa chipawak, amo xikinmakakah n chichimeh, amo kichiwa onewaskeh nomopah iwa nomechkuajkuaskeh. Nion xikinmakakah n koskameh patiojkeh n pitsomeh porke san kintlajtlaksaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","'Xiktlajtlanikah tlan nomechpoloa iwa nomechmakaskeh. Xiktemokah tlan nomechpoloa iwa nonkajsiskeh, xitenotsakah kan kaltentli iwa nomechtlatlapoliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yika, akin itla kitlajtlani, kiselia. Iwa akin itla kitemoa, kajsi. Iwa akin tenotsa kan kaltentli, kitlatlapoliah. ");
INSERT INTO nplNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","'¿Akin tlakatl weletis kimakas ikone se tetl ijkuak kitlajtlanilis se paj? ");
INSERT INTO nplNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Noso, ¿weletis kimakas se koatl ijkuak kitlajtlanilis se michi? ");
INSERT INTO nplNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Maya nomejwah amo nonkualteh, nonweleti nonkinmakah nomopilwah tlan kuali, ¡okachi Nomotajtsi Dios non kajki ilwikak, weletis nomechmakas tlan kuali tla nonkitlajtlaniliskeh! ");
INSERT INTO nplNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Xikchiwakah iwan oksikimeh ijkó kemi nomejwah nonkinekih makichiwakah nomowah, ye tlan moneki xikchiwakah. Ye ni itlanawatil Moisés iwa nochi tlan okijkuilojkeh n profetas. ");
INSERT INTO nplNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","'Xikalakikah kan ik kaltentli non tsopijtik, porke patlawak n kaltentli iwa kuyawak n ojtli non tewika kan moixpoloah, iwa miakeh ik ompa yajtokeh. ");
INSERT INTO nplNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero n kaltentli iwa n ojtli non tewika kan nochipa se yolitos, saikpanoa tsopijtik iwa san sikimeh kajsi non ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","'Ximotlachilikah inmak nekateh tiotlajtolteh tekajkayajkeh, non motlakentiah kemi yetoskiah ichkameh, pero ik inmijtik kokoyomeh tekuanimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nomejwah weletis nonkinmixmatiskeh ika tlan kichiwah, porke amo motekih uvas itech witsmeh, nion se tlátsmoli weleti kitemakas igos. ");
INSERT INTO nplNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ijkó kiné, nochi kuali kuawitl, kitemaka kuali itlakilo, iwa n kuawitl non ayakmó kuali, amo kuali itlakilo kitemaka. ");
INSERT INTO nplNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Se kuali kuawitl amo weletis kitemakas amo kuali itlakilo, iwa se kuawitl non ya palantok amo weletis kitemakas kuali itlakilo. ");
INSERT INTO nplNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nochi kuawitl non amo kitemaka kuali itlakilo, motsojtsonteki iwa se kitlamotla ijtik tletl. ");
INSERT INTO nplNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yika nomejwah weletis nonkinmixmatiskeh ika tlan kitlakiltiah. ");
INSERT INTO nplNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","'Amo nochteh akimeh nechiliah: “¡Noteko, Noteko!”, kalakiskeh kan Dios tlanawatia. Sanwel akimeh kichiwah tlan kimonekiltia Notajtsi non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Itech neká tonati, miakeh nechiliskeh: “¡Noteko, Noteko!, tejwah otitetlapowijkeh ika Motoka iwa ika Motoka otikinkixtijkeh espíritus amokualteh, noiwa ika Motoka otikinchijkeh miakeh milagros.” ");
INSERT INTO nplNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ijkuakó Ne nikinmilis: “¡Ayik onomechixma! ¡Ik nepa xiwiah, tlajtlakolchijkeh!” ");
INSERT INTO nplNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","'Ijkó kiné, akin nechkaki iwa nechtlakita, ye kemi se tlakatl non kipia kuali itlalnamikilis, iwa okichijchi ikal itech tetl. ");
INSERT INTO nplNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Owala chikawak kiawitl, iwa opé motleloa miak atl iwa se ejekatl temojti omotlawitekia ipan non kali, pero amo owetski, porke kuali otlakxilitoka itech tetl. ");
INSERT INTO nplNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Iwa akin nechkaki iwa amo nechtlakita, ye kemi se tlakatl amo ixtlamati iwa okichijchi ikal san itech xali. ");
INSERT INTO nplNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Owala chikawak kiawitl, iwa opé motleloa miak atl iwa se ejekatl temojti omotlawitekia ipan non kali, iwa non kali owetski iwa nochi opojpoliwik. ");
INSERT INTO nplNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ijkuak Jesús otlanki okintlapowi, n tlakah san omotlajtlachialtijkeh kenomi okinmachtiaya. ");
INSERT INTO nplNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porke itlajtol n Jesús otlanawatiaya de milajka, iwa amo kemi non kitemachtiah intlanawatil. ");
INSERT INTO nplNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ijkuak Jesús otemok de kan tepetl, miakeh tlakah oyajkeh íwa. ");
INSERT INTO nplNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ijkuakó se tlakatl non okipiaya lepra owalmijkuani inawak Jesús, omotlankuaketski iwa okili: —Noteko, tla tikmonekiltia, techchipawa. ");
INSERT INTO nplNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús okitlali ima ipan non kókoxki iwa okili: —Nikmonekiltia. ¡Ximochipawa! Ijkuak Jesús ijkó okijto, owalpajtik n kókoxki de ikokolis. ");
INSERT INTO nplNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús okili: —Xikkaki, amaka xikmatilti, sanwel xio kan tiópixki, iwa xiktemaka motlatliokolil kemi kijtoa itlanawatil Moisés, para ijkó makimatikah yotimochipa de mokokolis. ");
INSERT INTO nplNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ijkuak Jesús okalak kan altepetl de Capernaúm, ompa owalmijkuani se kapita romano, ");
INSERT INTO nplNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","iwa okili: —Noteko, se notlakewal sa wetok nocha, yotitikak iwa kualo nochi ikuerpo. ");
INSERT INTO nplNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús okinankili: —Nias nikpajtiti. ");
INSERT INTO nplNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","N kapita okinankili: —Tejwatsi, ne amitla nopati kemi para tikalakis nocha. Sanwel xikijto, “mapajti,” iwa notlakewal walpajtis. ");
INSERT INTO nplNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porke ne noiwa nikpia akin nechnawatia, iwa ne noiwa nikinnawatia sikimeh soldadojteh. Iwa tla aka niknawatia mawia, yawi. Iwa tla ok se niknawatia mawiki, wits. Noiwa tla se notlakewal niknawatia makichiwa itla, kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ijkuak Jesús okikak tlan okili n kapita, omotlajtlachialti iwa okinmili non íwa oyayah: —De milajka nomechilia, amo nikkajsitika nion se tlakatl itech nochi n tlali de Israel, non satlawel manechneltoka kemi nin tlakatl nechneltoka. ");
INSERT INTO nplNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne nomechilia miakeh walewaskeh de kan ik kisa tonati iwa de kan ik kalaki tonati, iwa motlamajsewiskeh iwan Abraham, Isaac iwa Jacob ompa ilwikak kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero n tepilwah non ompa moneki yetoskiah, kinkixtiskeh kala kan sentleyua, iwa ompa chokaskeh iwa tlannetsoniskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ijkuakó Jesús okili n kapita: —Ximokopa mocha, iwa mamochiwa kemi otikneltokak. Iwa non ora itlakewal n kapita owalpajtik. ");
INSERT INTO nplNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús oyá icha n Pedro, iwa ompa okajsito imona n Pedro wetok ika miak totonik. ");
INSERT INTO nplNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús okimakitski, iwa n totonik okiski. San nima n siwatl omej iwa opé kitekichiwilia. ");
INSERT INTO nplNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ijkuak otleyuak, okwalinwikilijkeh n Jesús miakeh non okimpiayah espíritus amokualteh. Iwa ika itlajtol okinkixti n espíritus amokualteh iwa okimpajti nochteh non omokokoayah. ");
INSERT INTO nplNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ijkó otlamochi tlan okijkuilo n tiotlajto Isaías, ijkuak okijto: “Ye otechpajti de nochi tokokolis iwa de nochi tlan otechkokoaya.” ");
INSERT INTO nplNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ijkuak Jesús okitak miakeh tlakah okiyawalojtokah, okinnawati itlamachtijkawah makikojchalwikah n lago. ");
INSERT INTO nplNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pero se tlamachti omijkuani ixpa Jesús iwa okili: —Tlamachti, nias mowa san kan ik tejwatsi tias. ");
INSERT INTO nplNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús okinankili: —N ostomeh mochantiah ijtik inkuyok, iwa n totomeh kipiah intepajsol, pero Ne Non onimochi ni tlakatl amo nikpia kan nimosewis. ");
INSERT INTO nplNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iwa seme de itlamachtijkawah okili: —Noteko, achto techonkawili maniktooka nota. ");
INSERT INTO nplNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero Jesús okili: —Xiwiki nowa, iwa xikinkawa non miktokeh makintookakah inmikenwah. ");
INSERT INTO nplNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús iwa itlamachtijkawah otlejkokeh itech barka iwa oyajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","San nima owala se ejekatl chikaktik iwa n atl opé motlatlawiteki itech barka iwa opé atemi. Pero Jesús okochtoka. ");
INSERT INTO nplNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ijkuakó itlamachtijkawah okiijxititoh, iwa okilijkeh: —¡Toteko, techmakixti! ¡Tiapolak tokeh! ");
INSERT INTO nplNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ye okinmili: —¿Tleka nonmomojtiah? ¡Wel achitsi nomotlaneltokalis! Jesús owalmóketski iwa okitlakawalti n ejekatl iwa n atl, iwa san owaltlamoka. ");
INSERT INTO nplNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Omotlajtlachialtijkeh iwa okijtoayah: —¡Akí nin tlakatl, porke asta n ejekatl iwa n atl kitlakitah! ");
INSERT INTO nplNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús okalakito inakastla n lago, itech tlalmeh de gadarenos. Ome tlakah non okimpiayah demóniojteh owalkiskeh kan ik tooktokeh non yomikeh iwa okinamikikoh. Yejwah saikpanoa otemomojtiayah, yika amaka opanoaya itech neká ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iwa opé tsajtsih: —¿Tlan tikneki towah Jesús Tekone de Dios? ¿Otiwala otechtlaijyowiltiko maya ayamó walajsi n iksemi tonati? ");
INSERT INTO nplNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ik ompa okintlakualtijtokah sikimeh pitsomeh. ");
INSERT INTO nplNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iwa n espíritus amokualteh okitlatlautijkeh n Jesús: —Tla techkixtis, techtitlani inmijtik pitsomeh. ");
INSERT INTO nplNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ijkuakó Jesús okinmili: —Xiwiah. N espíritus amokualteh okiskeh iwa okalakeh inmijtik nekateh pitsomeh. Iwa n pitsomeh omokajkawatoh ijtik atl iwa omijmikeh. ");
INSERT INTO nplNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Non okintlakualtijtokah n pitsomeh ocholojkeh, iwa ijkuak okalakitoh kan altepetl opé tetlapowiah de nochi tlan otlamochi, iwa nekateh ome tlakah non okimpiayah espíritus amo kualteh. ");
INSERT INTO nplNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ijkuakó nochteh n tlakah de Gadara okitatoh n Jesús, iwa ijkuak okitakeh, okitlatlautijkeh makinkajtewa intlalwah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ijkuakó Jesús otlejkok itech se barka iwa okikojchalwi n lago, iwa owalmókopki kan altepetl de Capernaúm kan Ye ochantitoka. ");
INSERT INTO nplNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sikimeh tlakah okiwalikiliayah se tlakatl n Jesús. Ye owetotiwalaya ipan ikochpetl porke oikximijmiktoka. Ijkuak Jesús okimitak kenijki otlaneltokayah nonteh tlakah, okili n kókoxki: —Ximoyolchikawa nokone, motlajtlakolwah ya tlapojpolwitokeh. ");
INSERT INTO nplNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ijkuakó sikimeh non kitemachtiah itlanawatil Moisés okimolijkeh: “Kixpanawia Dios ika tlan okijto. Ye tlajtoa kemi yetoskia Dios.” ");
INSERT INTO nplNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús okimatia tlan okimoliayah itech inyolo, yika okinmili: —¿Tleka nonkimoliah tlan amo kuali itech nomoyolo? ");
INSERT INTO nplNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tlan okachi amo owi se kijtos: “Motlajtlakolwah ya tlapojpolwitokeh”, noso: “Ximewa iwa xinejnemi”? ");
INSERT INTO nplNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero xikmatikah, Ne Non onimochi ni tlakatl, nikpia tekiwajyotl itech nin tlaltíkpaktli para nikintlapojpolwis intlajtlakolwah n tlakah. Ijkuakó okili n tlakatl non oikximijmiktoka: —Ximewa, xikajkokui mopetl iwa xio mocha. ");
INSERT INTO nplNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","N kókoxki owalmóketski iwa oyá icha. ");
INSERT INTO nplNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ijkuak n tlakah okitakeh ya nejnemi n kókoxki, omomojtijkeh iwa opé kiweyijkachiwah Dios, porke okinmák tekiwajyotl n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ijkuak Jesús yokistiaya de Capernaúm, okitak se tlakatl non itoka Mateo. Ye okololoaya impuesto para n tekiwa de Roma. Jesús okili: —Xiwiki nowa. Mateo owalmóketski, iwa oyá iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Satepa, Jesús iwa itlamachtijkawah otlakuajtokah icha n Mateo. Miakeh tominoololojkeh iwa oksikimeh tlajtlakolejkeh noiwa ompa otlakuajtokah inwah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ijkuak sikimeh fariseos okitakeh n Jesús otlakuajtoka inwah, okinmilijkeh itlamachtijkawah: —¿Tleka nomotlamachti tlakua iwan tominoololojkeh iwan tlajtlakolejkeh? ");
INSERT INTO nplNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús okinkak iwa okinmili: —Akimeh amo mokokoah mach kinekih se tepajti, yej non mokokoah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xiwiah iwa kuali xikkajsikamatikah tlan kijtosneki itlajkuilol Dios: “Ne nikneki xiteiknomatikah iwa amo techinmiktilikah yolkameh.” Porke amo onikinnotsako n yolchipawakeh, yej n tlajtlakolejkeh para ayakmó matlajtlakolchiwakah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ijkuakó itlamachtijkawah n Juan Bautista omijkuanijkeh inawak Jesús iwa okitlajtlanijkeh: —¿Tleka tejwah iwa n fariseos timosawah iwa motlamachtijkawah, amó? ");
INSERT INTO nplNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús okinmili: —¿Kox weletis moyolkokojtoskeh itlatlalwilwah n novio ijkuak ye ok kajki inwah? Wits tonati ijkuak n novio ayakmó yetos inwah, ijkuakó mosawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","'Amaka kitlamanilia se itlake non ya wewe ika se yankuik tsótsoli, porke n yankuik tsótsoli mokototsoa iwa kitsomonia n tlakemitl non ya wewetsi, iwa okachi weyi tsomoni. ");
INSERT INTO nplNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nion amaka kitlalia n yankuik vino itech se kuilambre ya wewetsi, porke tla ijkó nonkichiwah n kuilambre tsomonis. Ijkuakó n vino toyawi iwa n kuilambre sa motlamotla. Yika, xiktlalikah n yankuik vino itech se yankuik kuilambre, ijkó san ken ome wejkawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ijkuak Jesús ijkó okinmilijtoka n tlakah, owala se tlayákanki de se sinagoga, omotlankuaketski ixpa n Jesús, iwa okili: —Nochpoch tlamitsi omikki, pero tla tejwatsi tiwits nocha iwa tiktlalis moma ipa, moyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús omóketski, Ye iwa itlamachtijkawah oyajkeh icha non tlayákanki. ");
INSERT INTO nplNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ijkuakó se siwatl non yokipiaya májtlaktli iwa n ome xiwitl kókoxki ika esmilawálistli, omijkuani ik ikuitlapa n Jesús iwa okitempantelkoli itlakeh. ");
INSERT INTO nplNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","N siwatl okimoliaya: “Tla san niktempantelkolis itlake, niwalpajtis.” ");
INSERT INTO nplNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús omókopki, okitak n siwatl iwa okili: —Ximoyolchikawa nokone, motlaneltokalis omitspajti. Itech non ora n siwatl opajtik. ");
INSERT INTO nplNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ijkuak Jesús okalakito icha n tlayákanki, okinmitak n tlapitskeh, iwa non otetlajpalotoh sa tlawel omopajsolojtokah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ijkuakó Jesús okinmili: —Xikisakah, nin takotsi amo omikki, san kochtok. N tlakah san okiwetskakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero ijkuak Jesús okinkixti nochteh, okalak iwa okonmakitski n takotsi, iwa ye owalme. ");
INSERT INTO nplNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iwa tlan otlamochi omoma itech nekateh tlalmeh. ");
INSERT INTO nplNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ijkuak Jesús okistiaya de ompa, ome tlakah non amo tlachiah okitokayah iwa okitsajtsilijtiayah: —¡Techiknomati Ikone n rey David! ");
INSERT INTO nplNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ijkuak Jesús okalak itech kali, nonteh tlakah non amo otlachiayah okajsitoh. Jesús okintlajtlani: —¿Nonkineltokah weletis nomechpajtis? Yejwah okilijkeh: —Ejé Tejwatsi. ");
INSERT INTO nplNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ijkuakó Jesús okintelkoli inmixtololowah iwa okinmili: —Mamochiwa ijkó kemi nomejwah nonkineltokah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iwa yejwah owaltlachixkeh. Jesús kuali okinnajnawati: —Xikkakikah, amaka xikilikah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero ijkuak owalkiskeh, opé sentetl tetlapowiah tlan Jesús okichi inwah. ");
INSERT INTO nplNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ijkuak yejwah okistiayah, sikimeh tlakah okwalikilijkeh n Jesús se tlakatl non amo otlajtoaya. Ye okipiaya se espíritu amokuali. ");
INSERT INTO nplNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ijkuak Jesús okikixti n espíritu amokuali, n tlakatl owaltlajto. N tlakah sa tlawel omotlajtlachialtijkeh iwa okimoliayah: —Amayik ijkó motikah itech tlali de Israel. ");
INSERT INTO nplNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero n fariseos okijtoayah: —Kinkixtia espíritus amokualteh ika itekiwajyo n amokualitlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús onentinemia itech nochteh n wejweyi altepemeh iwa itech altepetsitsinteh iwa okinmachtiaya n tlakah itech insinagogas. Okitematiltiaya n kualitlájtoli, iwa okimpajtiaya n tlakah de nochi inkokolis iwa inkualolis. ");
INSERT INTO nplNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ijkuak Jesús okimitak n tlakah, okimiknoma ken sa tlawel osotlawatokah iwa oyetokah inselti kemi ichkameh non amo kipiah tlajpixki non kinyakanas. ");
INSERT INTO nplNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ijkuakó okinmili itlamachtijkawah: —Onkateh miakeh tlakah non moneki makikakikah notlajtol, pero amo onkateh miakeh tlakah akimeh moneki makitematiltikah notlajtol. Onka miak tekitl para mopixkas, pero amo onkateh miakeh akimeh pixkaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yika, xiktlajtlanilikah Dios n Tekowa de kan se pixkas, makintitlani miakeh tekitkeh para mapixkakih. ");
INSERT INTO nplNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús okínnotski májtlaktli iwa n ome (12) itlamachtijkawah iwa okinmák tekiwajyotl para makinkixtikah espíritus amokualteh iwa para makimpajtikah n tlakah de nochi kokólistli iwa kualólistli. ");
INSERT INTO nplNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yejwah ninteh intokah n májtlaktli iwa ome itlamachtijkawah. Achto okínotski n Simón non noiwa itoka Pedro iwa ikni Andrés, Jacobo itelpoch Zebedeo iwa ikni Juan, ");
INSERT INTO nplNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo n tominoololo, Jacobo ipiltsi n Alfeo, Tadeo, ");
INSERT INTO nplNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, non tewa Kananista, iwa Judas Iscariote non satepa okitemakti n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús okintítlanki ninteh májtlaktli iwa ome itlamachtijkawah iwa okinnajnawati: —Amo xiwiah kan amo judíojteh, nion xikalakikah kan altepemeh de Samaria. ");
INSERT INTO nplNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sanwel xikintemojtiwiah n tlakah de Israel non moixpolojtinemih kemi ichkameh. ");
INSERT INTO nplNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xiwiah, iwa xikinmatiltijtiwiah yoajsiko n tonati ijkuak Dios pewas nomechnawatis. ");
INSERT INTO nplNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xikimpajtikah n kokoxkeh, xikinyolitikah non yomikkeh, xikinchipawakah akimeh kipiah lepra, iwa xikinkixtikah espíritus amokualteh. San ijki ononkiselijkeh, san ijki xiktemakakah. ");
INSERT INTO nplNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Amo xikwikakah tomi, ");
INSERT INTO nplNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nion nomotlaxkal. Sanwel se nomotlakeh xikwikakah. Amo xikinwikakah oksikimeh nomokakkuah, nion nomobasto, porke akin tekiti kimotlanilia itlakual. ");
INSERT INTO nplNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","'Ijkuak nonkalakitiweh itech se weyi altepetl noso altepetsintli, xiktemokah aka kuali tlakatl non manomechyekseli icha. Ompa ximokalotijtokah asta ijkuak nonyaskeh ok se altepetl. ");
INSERT INTO nplNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Iwa ijkuak nonkalakiskeh itech se kali, xontetlajpalokah. ");
INSERT INTO nplNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tla n chanejkeh nomechyekseliah, kiseliskeh nomoyolsewilis, pero tla amo nomechyekseliah, nomoyolsewilis mokopas nomowah. ");
INSERT INTO nplNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iwa tla amo nomechseliah nion kikakih nomotlajtol, xikisakah de non kali noso de non altepetl iwa ximoikxitsejtselokah. ");
INSERT INTO nplNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","De milajka nomechilia, itech iksemi tonati, Dios okachi kitlaijyowiltis non altepetl ke non ochantitokah itech altepemeh de Sodoma iwa Gomorra. ");
INSERT INTO nplNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","'¡Techkakikah! Ne nomechtitlani kemi ichkameh intsalko kokoyomeh. Kuali xiijsatokah kemi koameh pero noiwa xiyetokah non yolyamankeh kemi palomajtsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kuali ximotlachilikah, porke n tlakah nomechtemaktiskeh inmak tekiwajkeh, iwa nomechtsonwitekiskeh kan sinagogas. ");
INSERT INTO nplNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Por non nechneltokah, nomechkawatiweh ixpa n wejweyi tekiwajkeh iwan wejweyi tlanawatijkeh. Ijkó nomejwah nonkitetlapowiskeh notlajtol inmixpah, iwa inmixpa non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero ijkuak nomechtemakaskeh inmak tekiwajkeh, amo ximotekipachokah tlan nontlajtoskeh noso tlan nonkijtoskeh. Porke itech non ora Dios momechilis tlan nonkijtoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Amo nomejwah nontlajtoskeh, yej Iespíritu Nomotajtsi akin tlajtos nomotech. ");
INSERT INTO nplNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","'N teikni kitemaktis ikni makimiktikah, iwa n teta kitemaktis ikone makimiktikah. N tepilwah kinmixnamikiskeh intajwah iwa kintemaktiskeh makinmiktikah. ");
INSERT INTO nplNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochteh nomechkokoliskeh por nonkitematiltiah Notoka, pero akin kixikos nochi, Dios kimakixtis. ");
INSERT INTO nplNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ijkuak nomechtotojtokaskeh itech se altepetl, xicholokah iwa xiwiah kan ok se. De milajka nomechilia: mach tlamis nonpapanotinemiskeh itech nochteh n altepemeh de Israel, porke achto nikalakiki Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","'Se momachti amo kixpanawia itlamachti iwa se tlakéwali amo kixpanawia iteko. ");
INSERT INTO nplNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Se momachti yolpaki ijkuak motlami kemi itemachti, iwa n tlakéwali kemi iteko. Tla itech se kali, n teta kitokayotiah beelzebú, ¡noiwa ichantlakawah ijkó kinnotsaskeh! ");
INSERT INTO nplNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","'Yika, amo xikinmawilikah n tlakah. Porke nochi tlan tlatitok satepa nesis, iwa nochi tlan amo momati saman momatis. ");
INSERT INTO nplNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tlan nomechilia de yuak, nomejwah xiktematiltikah ijkuak tlanestok. Iwa tlan Ne nomechilia ichtaka, xiktematiltikah chikawak. ");
INSERT INTO nplNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amo xikinmawilikah akimeh weletis nomechmiktiskeh, porke maya manomechmiktikah, mach weletis kixpoloskeh nomoalma. Yej xikiimakajsikah Dios Akin weletis kixpolos nomokuerpo iwa nomoalma kan miktla. ");
INSERT INTO nplNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","'Omeh tototsitsinteh monamakah ika se tomi, pero nion se de yejwah weleti wetsi ixko tlali tla Totajtsi Dios amo kitekawilia. ");
INSERT INTO nplNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Noiwa Dios kuali kimatok kech tsónkali nonkipiah itech nomotsonteko. ");
INSERT INTO nplNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yika, amo ximomojtikah, porke nomejwah okachi nomopatih ke miakeh tototsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","'Tla aka kijtos inmixpa n tlakah, Ne Iteko, Ne noiwa nikijtos ye noaxka ixpa n Notajtsi non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Iwa tla aka kijtos teixpa, amo nechixmati, Ne noiwa nikijtos ixpan Notajtsi non kajki ilwikak amo nikixmati. ");
INSERT INTO nplNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","'Amo xikmolikah Ne onikwalík yolsewílistli. Amó, yej Ne onikwalík tlanetéwili. ");
INSERT INTO nplNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne oniwala para n tepiltsi kixnamikis ita, n teichpoch kixnamikis ina, iwa n montli kixnamikis imona. ");
INSERT INTO nplNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nomokokolikniwah yetoskeh non chanchiwah nomowah. ");
INSERT INTO nplNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","'Akin kitlasojtla ita noso ina okachi ke Ne, amo makimoli nika íwa. Iwa akin kitlasojtla ipiltsi noso ichpoch okachi ke Ne, amo makimoli nika íwa. ");
INSERT INTO nplNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iwa akin amo kinekis kiselis tlaijyowílistli itech inemilis iwa amo kinekis nowan yas, mach keman yetos noaxka. ");
INSERT INTO nplNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Akin kimalwia inemilis kixpolos, pero akin kipolos inemilis por nechneltoka, kajsis n milájka nemílistli. ");
INSERT INTO nplNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","'Akin nomejwah nomechselia, Ne nechselia, iwa akin Ne nechselia, noiwa kiselia Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Akin kiselia se tiotlajto, kiselis itlatliokolil kemi non kiseliah n tiotlajto. Iwa akin kiselia se tlakatl non kichiwa tlan Dios kineki, kiselis itlatliokolil kemi ye. ");
INSERT INTO nplNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iwa akin kitliokolis maya san siki atl, seme de ninteh notlamachtijkawah tsitsikitikeh, de milajka nomechilia amo kipolos itlatliokolil. ");
INSERT INTO nplNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ijkuak Jesús yokinnajnawati tlan kichiwaskiah n májtlaktli iwa ome itlamachtijkawah, oyajki de ompa. Iwa kan okalakito opé tetlapowia de itlajtol Dios itech nonteh altepemeh. ");
INSERT INTO nplNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ijkuak Juan otsaktoka, okima tlan okichiwaya n Cristo iwa okintítlanki ome itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iwa okitlajtlanitoh: —¿Tejwatsi non tiwalaskia, noso tikchiaskeh ok se? ");
INSERT INTO nplNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús otlanankili: —Xiwiah iwa xikilikah n Juan nochi tlan nonkitah iwa nonkikakih. ");
INSERT INTO nplNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xikilikah, non amo tlachiah ya tlachiah, n koxomeh, ya kuali nejnemih iwa non okipiayah lepra, yochipawakeh. Non amo otlakakiah, ya tlakakih, non omikkeh, yomoyolitijkeh, iwa n próbesteh kinmatiltiah n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Miak pakílistli kipias non kimawistetepewa por Ne. ");
INSERT INTO nplNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ijkuak itlamachtijkawah n Juan oyajkeh, Jesús okintlapowi de Juan non ompa okatkah, iwa okinmili: —¿Tlan ononkitatoh kan amaka chanti? ¿Se akatl non kolinia n ejekatl? ");
INSERT INTO nplNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tlan para ononyajkeh? ¿Ononkitatoh se tlakatl non okonakiaya itlake non kuali? Nomejwah kuali nonkimatokeh, n tlakah non konakiah kuali intlakeh kateh incha n reyes. ");
INSERT INTO nplNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pero ¿tleka ononkiskeh? ¿Ononkitatoh se tiotlajto? Milák, ye okachi weyi ke se tiotlajto. ");
INSERT INTO nplNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Itlajkuilol Dios tlajtoa de Juan ijkuak kijtoa: Ne niktitlani notlatematilti sa matlayakana, para mamitsmajmanili n ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","De milajka nomechilia asta axa itech nin tlaltíkpaktli amo onka ok se tlakatl kemi Juan Bautista. Pero non okachi tsijtsikitsi non kajki ilwikak kan Dios tlanawatia, ye okachi weyi ke Juan. ");
INSERT INTO nplNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","'Ijkuak owala Juan Bautista iwa asta axa, itlajtol Dios chikawak nejnentok itech nin tlali. Iwa non okachi mochijchikawah yejwah kalakih kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nochteh n profetas iwa itlajkuilol Dios otlajtojkeh de Juan. ");
INSERT INTO nplNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iwa tla nonkinekih nonkineltokaskeh, Juan ye n profeta Elías non walaskia. ");
INSERT INTO nplNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'¡Akin de milajka kipia inakas, makajsikamati! ");
INSERT INTO nplNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","'Nomejwah axa nonnemih kemi n pípilteh non motlaliah iwa nonmawiltiah tiánkistli, iwa kintsajtsiliah oksikimeh, ");
INSERT INTO nplNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","iwa kinmiliah: “Otomechtlapichilijkeh iwa amo ononmijtotijkeh. Otomechtlakuikilijkeh se tlakuikali teyolkoko iwa amo ononchokakeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porke owala Juan, non amo otlakuaya nion okonia vino, iwa nomejwah ononkijtojkeh kipia se espíritu amokuali. ");
INSERT INTO nplNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Otlanki Ne oniwala Non onimochi ni tlakatl. Ne nitlakua iwa nikoni vino iwa nomejwah nonkijtoah tlawel niápistli iwa nitláwanki. Noiwa nonkijtoah nimowika iwan tlajtlakolejkeh iwa n tominoololojkeh. Pero ixtlamatilis Dios moixmati ika tlan kichiwah ipilwah akimeh kitlakitah. ");
INSERT INTO nplNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ijkuakó Jesús opé kinmajwa n tlakah non ochantitokah itech altepemeh kan okinchi miakeh milagros. Porke n tlakah non ompa ochantitokah mach omoyolpatlayah inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Miálmasteh tlakah de altepetl de Corazín! ¡Nonpróbesteh tlakah de Betsaida! Tla n milagros non omochijkeh nomonawak mochiwaskiah itech altepemeh de Tiro iwa Sidón, yowejka moyolpatlaskiah, iwa nonmotlakentiskiah ika nomotlakeh wapaktik iwa nonmokuatlekonexwiskiah. ");
INSERT INTO nplNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero ijkuak ajsiki n iksemi tonati ijkuak Dios kintlajtlakoltis, nomejwah tlakah de Corazín iwa Betsaida, okachi nontlaijyowiskeh ke non de Tiro iwa Sidón. ");
INSERT INTO nplNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iwa nomejwah tlakah de Capernaúm, ¿non kimoliah nonyaskeh ilwikak? ¡Sanenka! Nomejwah nonyaskeh miktla. Porke tla kan altepetl de Sodoma mochiwaskiah n milagros non omochijkeh nomonawak, non weyi altepetl asta axa yetoskia. ");
INSERT INTO nplNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero Ne nomechilia, ijkuak kalakiki n iksemi tonati ijkuak Dios kintlaijyowiltis, nomejwah tlakah de Capernaúm okachi nomechtlaijyowiltiskeh ke n tlakah de Sodoma. ");
INSERT INTO nplNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Non tonati, Jesús okijto: —Tlasojkamati miak Notajtsi, Tejwatsi Ti Tekowa de ilwikak iwa de nin tlaltíkpaktli, porke nochi ni otikintlaatili n ixtlamatkeh iwan teajsikamatkeh iwa otikinnextili non tsitsikitikeh. ");
INSERT INTO nplNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ijkó Notajtsi, ijkó Tejwatsi satlawel omitspakti. ");
INSERT INTO nplNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Notajtsi yonechmaktili maniknawati nochi tlan onka. Amaka nechixmati kemi Ikone Dios, sanwel Notajtsi. Nion amaka kixmati Notajtsi, sanwel Ne iwa nekateh tlakah akimeh Ne niknekis makixmatikah. ");
INSERT INTO nplNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xiwikih nonawak nonnochteh akimeh tekitih chikawak iwa yononsotlawakeh, iwa Ne nomechsewis. ");
INSERT INTO nplNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xikwikakah notlamamal, iwa xikchiwakah tlan Ne nikchiwa, porke Ne niyolyámanki iwa niteiknoma. Iwa nonkajsiskeh yolsewílistli itech nomoyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porke n tekitl non Ne nikneki xikchiwakah amo owi se kitlakitas, iwa tlan Ne nomechnawatia, noiwa amo tesotla. ");
INSERT INTO nplNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Se sábado ijkuak mosewia n judíos, Jesús iwa itlamachtijkawah opajpanotiayah kan ik tlatooktok. Itlamachtijkawah owalxitlatlakeh iwa opé miawatekih, okoxkeh n xinatsintli iwa opé kikuah. ");
INSERT INTO nplNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ijkuak n fariseos okimitakeh, okilijkeh n Jesús: —Xikinmita, motlamachtijkawah kichijtokeh tlan amo techkawilia totlanawatil matikchiwakah itech sábado. ");
INSERT INTO nplNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero Jesús okinmili: —¿Ayamó nonkiamapoah tlan okichi n rey David keman owalxitlatlak ye iwa non oyayah íwa? ");
INSERT INTO nplNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Okalakeh ikal Dios, iwa David iwa non iwa oyayah okinkuajkeh n pameh tlatiochíwalteh non okinmanilijkah Dios. Nonteh pameh mach para kinkuaskia yejwah, yej sanwel n tiopixkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Noso ayamó nonkiamapoah tlan kijtoa itlanawatil Moisés, n tiopixkeh noiwa itech nochi sábado ijkuak moneki se mamosewi, tekitih kan Weyi Tiopa? Yejwah mach mosewiah non tonati, iwa maya tekitih, amo kichiwah tlajtlákoli. ");
INSERT INTO nplNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero Ne nomechilia, axa nika nika Ne Non okachi niweyijkatitok ke n Weyi Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nomejwah amo nonkajsikamatih tlan kijtosneki itlajkuilol Dios: “Ne nikneki xiteiknomatikah iwa amo san xipewakah techinmiktilikah yolkameh.” Amo nonkintlajtlakoltiskiah non amo tlajtlakolejkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kuali xikmatikah Ne Non onimochi ni tlakatl nitlanawatia itech sábado. ");
INSERT INTO nplNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús oyá de ompa iwa okalakito kan se sinagoga. ");
INSERT INTO nplNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ompa okatka se tlakatl non omapitswak, iwa kemi n fariseos okitlajtoltemoliayah n Jesús para ika weletis kiteiliskeh, okitlajtlanijkeh: —¿Motekawilia mamotepajti itech n sábado ijkuak moneki se mamosewi? ");
INSERT INTO nplNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús okinnankili: —Tla aka de nomejwah kipia se ichka non moposojwia itech sábado, ¿amo konkixtia? ");
INSERT INTO nplNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Okachi ipati se tlakatl ke se ichka! Yika, tejwah kema weletis tikchiwaskeh tlan kuali ipan sábado. ");
INSERT INTO nplNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ijkuakó Jesús okili n tlakatl: —Xikmilawa moma. Iwa ijkuak okimila ima, opajtik iwa omoka kuali kemi non ok se ima. ");
INSERT INTO nplNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","N fariseos okiskeh iwa opé motlatlalwiah para kipojpoloskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ijkuak Jesús okima tlan okinekiah kitoktiskeh, oyá de ompa, iwa miakeh tlakah oyajkeh íwa. Jesús okimpajtiaya nochteh non omokokoayah, ");
INSERT INTO nplNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","iwa okinnajnawatiaya amo makijtokah Akin Ye. ");
INSERT INTO nplNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ijkó otlamochi kemi okijkuilo n tiotlajto Isaías: ");
INSERT INTO nplNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nika kajki notékipano Akin Ne onikpéjpenki, notlasoj Akin kiyolpaktia noalma. Niktlalis Noespíritu itech Ye, iwa Ye kinmatiltis nochteh n tlaltikpaktlakah kenijki kipiah de yeknemiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Amo mokualanijtos nion tsatsajtsis, nion amaka kikakis itlajtol itech ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nion se akatl non yoxámanki kipostekis, iwa n tláwili non san achitsi xotlatok, amo kisewis, asta mamochiwa nochi tlan kuali kemi Ye kineki. ");
INSERT INTO nplNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iwa itech Itoka, nochteh non amo judíojteh inawak moyolchikajtoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ijkuakó okwalikilijkeh n Jesús se tlakatl non amo otlachiaya nion otlajtoaya iwa okipiaya se espíritu amokuali. Jesús okipajti, iwa n tlakatl owaltláchixki iwa owaltlajto. ");
INSERT INTO nplNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nochteh n tlakah omotlajtlachialtijkeh iwa okijtoayah: —¿Yetos ni, ikone n rey David? ");
INSERT INTO nplNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Keman n fariseos ijkó okikakeh, okijtojkeh: —Nin tlakatl kinkixtia n espíritus amokualteh ika iweletilis beelzebú, non kinnawatia n espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús okimatia tlan yejwah okimoliayah, yika okinmili: —Tla n tlakah de se país pewas momijmiktiskeh san yejwah, non país pojpoliwis. Iwa tla se altepetl noso se familia noiwa pewa moxexeloa, sa nima xitinis. ");
INSERT INTO nplNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijkó noiwa, tla satanás iselti kinkixtijtok n espíritus amokualteh, san ye inewia moixnamiki iwa san nima pojpoliwis. ");
INSERT INTO nplNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tla nomejwah nonkijtoah Ne nikinkixtia espíritus amokualteh ika iweletilis beelzebú, ¿akin kinmaka weletílistli nomotlamachtijkawah ijkuak kinkixtiah espíritus amokualteh? Yika, yejwah makijtokah kox milák noso amo milák tlan nomejwah nonkijtoah. ");
INSERT INTO nplNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero tla Ne nikinkixtia n espíritus amokualteh ika iweletilis Iespíritu Dios, noni kijtosneki Dios yopé tlanawatia nomonawak. ");
INSERT INTO nplNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","'¿Weletis aka kalakis icha n se tlakatl non chikaktik iwa kikixtilis tlan kipia? Sanwel tla achto kijilpia, ijkuakó ya weletis kitlachtekis. ");
INSERT INTO nplNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","'Akin amo kajki nowa, nechixnamiki. Iwa akin amo nowa pixka, tlaxixititsa. ");
INSERT INTO nplNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","'Yika nomechilia, Dios nomechintlapojpolwilis nochteh nomotlajtlakolwah iwa nochi tlan fiero nonkijtoskeh. Pero akin fiero kitenewas n Espíritu, Dios ayik kitlapojpolwis. ");
INSERT INTO nplNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iwa akin fiero nechtenewa Ne Non onimochi ni tlakatl, kitlapojpolwiskeh, pero akin fiero kitenewas n Espíritu Santo, ayik kitlapojpolwiskeh, nion axa, nion satepa. ");
INSERT INTO nplNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","'Se kuali kuawitl kitemaka kuali itlakilo, tla n kuawitl amo kuali, noiwa kitemaka itlakilo amo kuali. Nochi kuawitl moixmati ika tlan kitemaka. ");
INSERT INTO nplNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Nomejwah nonkichiwah ken koameh! ¿Kenomi weletis nonkijtoskeh tlan kuali, tla nomejwah amo non kualteh? Porke tlan kitemitijtok toyolo ye tlan tikijtoah. ");
INSERT INTO nplNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Se kuali tlakatl kikixtia tlan kuali kitlaatitok itech iyolo. Pero n tlakatl amo kuali, kikixtia tlan amo kuali kitlaatitok itech iyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne nomechilia, itech iksemi tonati, ijkuak Dios tlaixkomakas, nochteh nomejwah nonkimokuitiskeh nochi tlájtoli tlan amo kuali ononkijtojkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porke ika tlan tikijtoa mitstlajtlakolmakaskeh, iwa kijtoskeh kox titlajtlakole noso amó. ");
INSERT INTO nplNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ijkuakó sikimeh tlamachtijkeh iwa n fariseos okilijkeh n Jesús: —Tlamachti, tiknekih tikitaskeh se milagro. ");
INSERT INTO nplNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús okinnankili: —N tlakah tlajtlakolchijkeh kitlajtlanih se milagro. Pero mach ok nikinmititis ok se, sanwel tlan yopanok n profeta Jonás. ");
INSERT INTO nplNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iwa ijkó kemi Jonás okatka eyi tonati iwa eyi yúali ijtik se weyi michi, noiwa Ne Non onimochi ni tlakatl, niyetos eyi tonati iwa eyi yúali ijtik tlali. ");
INSERT INTO nplNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","N tlakah non ochantitokah Nínive moyolitiskeh itech iksemi tonati, iwa nomechtlajtlakoltiskeh porke yejwah okikajkeh n Jonás iwa omoyolpatlakeh ijkuak okinmatilti itlajtol Dios. Axa Ne Non nika nika, okachi weyi ke Jonás. ");
INSERT INTO nplNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Noiwa n reina non walewatok kan tlali de Sabá moketsas itech iksemi tonati iwa nomechtlajtlakoltis, porke wejka owalewak okikakiko n Salomón, non satlawel ixtlamati, pero nika ka se non okachi weyi ke Salomón. ");
INSERT INTO nplNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","'Ijkuak se espíritu amokuali kisa ijtik se tlakatl, nentinemi kan tlawakah kitemojtinemi kan mosewis, iwa ken amo kajsi ");
INSERT INTO nplNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kimolia: “Nimokopas oksepa itech neká tlakatl kan oníkiski.” Iwa ijkuak mokopa, konajsi n tlakatl kemi se kali kan amaka chanchiwa, kuali ichpantok iwa tlaajachitok. ");
INSERT INTO nplNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Satepa yawi kualinnotsati chikome espíritus non okachi amokualteh, iwa nochteh kalakih ijtik non tlakatl iwa mochantiah. Satepa non tlakatl mokopa okachi amokuali. Ijkó mochiwaskeh n tlajtlakolejkeh non axa nentinemih. ");
INSERT INTO nplNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ok okintlapowijtoka n tlakah, imamá iwan ikniwah oajsito kan Ye okatka pero omokajkeh kala, porke okinekiah motlapowiskeh íwa. ");
INSERT INTO nplNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ijkuakó se tlakatl okilito: —Jesús, momamá iwa mokniwah kateh kala iwa kinekih motlapowiskeh mowa. ");
INSERT INTO nplNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Jesús okinankili: —¿Akin nomamá, iwa akimeh nokniwah? ");
INSERT INTO nplNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Okinmajpilwi itlamachtijkawah iwa okijto: —Yejwah ninteh nomamá iwa nokniwah. ");
INSERT INTO nplNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Akin kichiwa tlan kimonekiltia Notajtsi Dios non kajki ilwikak, ye nokni, nowelti iwa nomamá. ");
INSERT INTO nplNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Non tonati Jesús okiski kan okalotitoka iwa omotlalito itempa n lago. ");
INSERT INTO nplNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ken miaktikeh omoololojkeh, Jesús omonek tlejkos ipan se barka iwa omotlali, iwa nochteh n tlakah omokajkeh itempa n lago. ");
INSERT INTO nplNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús opé kinmachtia ika tlapoálisteh, iwa okinmiliaya: —Se tlakatl oyá iwa otook. ");
INSERT INTO nplNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ijkuak otook, siki xínachtli owetski ojtentli, iwa owalajkeh n totomeh iwa okikuajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oksiki owetski kan tlateyo, kan san pánixko okipiaya tlali. Non xínachtli sa nima oixwak porke n tlali amo tilawak. ");
INSERT INTO nplNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero ijkuak okiski n tonati, okuitlawik, iwa ken amo wejkatla omonelwayoti, owaki. ");
INSERT INTO nplNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oksiki owetski kan tlawitstla, omoskalti n witstli iwa n tlátoktli oijyomik. ");
INSERT INTO nplNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero siki xínachtli owetski kan kuali tlali, iwa kuali otlaaki. Siki tlátoktli okitemák se siento, oksiki eyi póali (60), iwa oksiki sempóali iwa n májtlaktli (30) por se xínachtli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Akin kipia inakas, makajsikamati. ");
INSERT INTO nplNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ijkuakó itlamachtijkawah n Jesús omijkuanijkeh inawak, iwa okitlajtlanijkeh: —¿Tleka tikintlapowia n tlakah ika tlapoálistli? ");
INSERT INTO nplNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús okinnankili: —Dios nomechkawilia xikmatikah kenomi tlanawatia kan ilwikak, pero n oksikimeh amo kinkawilia makimatikah. ");
INSERT INTO nplNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yika, akin kipia okachi, okachi kimakaskeh, iwa akin amitla kipia, nochi kikixtiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yika, Ne nikintlapowia ika tlapoálisteh, porke maya tlachiah amo kitah, iwa maya tlakakih amo kikakih nion kajsikamatih. ");
INSERT INTO nplNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yika, intech mochiwa tlan okijto n profeta Isaías: Maya miak matlakakikah, amo kajsikamatiskeh; maya kuali matlachiakah amitla kajsiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porke ninteh tlakah oyoltlakuawakeh, omonakastsajtsakeh para amo tlakakiskeh, iwa okintsajtsakeh inmixtololowah para amo matlachiakah nion matlakakikah ika innakaswah, nion kajsikamatih ika inyolo, para moyolpatlaskeh nonawak iwa manikimpajti. ");
INSERT INTO nplNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","'Mapakikah nomoixtololowah porke tlachiah, mapakikah nomonakaswah porke tlakakih. ");
INSERT INTO nplNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","De milajka nomechilia, miakeh profetas iwa tlakah yolchipawakeh okinekiah kitaskeh tlan axa nomejwah nonkitah, iwa amo okitakeh. Okinekiah kikakiskeh tlan axa nonkikakih, iwa amo okikakeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","'Kuali xikkakikah tlan kijtosneki ijkuak otook se tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Akimeh kikakih itlajtol Dios iwa amo kajsikamatih, nonteh kemi n xínachtli non owetski itempa ojtli, wits n diablo iwa kinkixtilia itlajtol Dios non omotook itech inyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","N xínachtli non owetski intsalko temeh, yejwah non kikakih itlajtol Dios iwa sa nima kiseliah ika miak pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero ken amo omonelwayoti, amo tlaxikoah. Ijkuak pewah tlaijyowiah noso kintotojtokah por okiselijkeh itlajtol Dios, walmosotlawah iwa kikawah. ");
INSERT INTO nplNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","N xínachtli non owetski kan tlawitstla, kijtosneki non kikakih itlajtol Dios, pero okachi kintekipachoa tlan onka itech nin tlaltíkpaktli iwa n tomi pewa kinmixkajkayawa. Nochi ni kijyomiktia itlajtol Dios iwa ayakmó kikawilia matlaaki. ");
INSERT INTO nplNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero n xínachtli non omotook itech kuali tlali, noni kijtosneki akin kikakih itlajtol Dios iwa kajsikamatih, iwa miak tlaakih. Siki xínachtli kitemaka mákuili poali (100) xínachtli, oksiki eyi póali (60), iwa oksikimeh kitemakah sempóali iwa n májtlaktli (30), por se xínachtli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús okinmili ok se tlapoálistli: —Ijkó noiwa tlamochiwa ilwikak kan Dios tlanawatia, kemi se tlakatl non okitook itlala kuali xínachtli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero ijkuak itlakawah okochtokah, owala se tlakatl non okikokoliaya n tekowa, iwa okitookili sasaliksakatl itsajtsalko n trigo, iwa ocholo. ");
INSERT INTO nplNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ijkuak n tlátoktli omoskalti iwa omiawatik n trigo, noiwa omoskalti miak sasaliksakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ijkuakó itlakawah okilitoh n tekowa: “Tejwatsi otikontook kuali xínachtli motlala. ¿kan ik okiski n sasaliksakatl?” ");
INSERT INTO nplNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","N tekowa okinmili: “Se tlakatl non nechkokolia ijkí okichi.” Ijkuakó itlakawah okilijkeh: “¿Tikneki matikwiwitlatih n sasaliksakatl?” ");
INSERT INTO nplNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero inteko okinmili: “Amó, porke tla nonkiwiwitlaskeh n sasaliksakatl, weletis noiwa nonkiwiwitlaskeh notrigo. ");
INSERT INTO nplNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Okachi kuali xikkawakah mamoskaltikah sansikah asta ijkuak motlatekis. Ijkuakó nikinnawatis n tlatekeh: “Achto xikololokah n sasaliksakatl, xikijilpikah para mochichinos; iwa n trigo kuali mamotlaati.” ");
INSERT INTO nplNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús noiwa okinmili ok se tlapoálistli: —Itech ilwikak kan Dios tlanawatia, noiwa kemi se xinatsintli de mostaza non se tlakatl okitook itlala. ");
INSERT INTO nplNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nin xinatsintli ye n okachi tsijtsikitsi itech nochteh n xínachteh, pero ijkuak moskaltia, okachi weyi ke se tlátookali, iwa motlami kemi se kuawitl iwa n tototsitsinteh motepajsoltiah itech. ");
INSERT INTO nplNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús okinmili ok se tlapoálistli: —Kan Dios tlanawatia noiwa kemi n levadura non se siwatl okinenelo ika eyi tlatamachíwali arina, iwa kualtsi okisama nochi n textli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nochi ni Jesús okintlapowiaya n tlakah ika tlapoálisteh, iwa tla amo ika tlapoálisteh, amo okintlapowiaya. ");
INSERT INTO nplNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ijkó omochi tlan okijkuilo n profeta: Nitlajtos ika tlapoálisteh, niktematiltis tlan amaka okimatia desde ijkuak Dios okichijchi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús okinmakah nochteh non ompa okatkah. Ijkuakó okalak itech kali iwa sanima omijkuanijkeh itlamachtijkawah iwa okilijkeh: —Techajsikamatiltih tlan kijtosneki itlapoalis n sasaliksakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ijkuakó Jesús okinnankili: —Ne Non onimochi ni tlakatl, Ne oniktook n kuali xínachtli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","N tetlala ye n tlaltíkpaktli. N kuali xínachtli kijtosneki yejwah iaxkawah Dios, iwa n sasaliksakatl, yejwah ipilwah n diablo. ");
INSERT INTO nplNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Non tekokolia ye n diablo akin okitook n sasaliksakatl. N tlapixkalo kijtosneki n iksemi tonati. Iwa akimeh tlatekiskeh yejwah n ángelteh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yika, ijkó kemi mowiwitla n xiwitl non amo kuali iwa mochichinoa, ijkó tlamochiwas ijkuak tlamis nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ne Non onimochi ni tlakatl nikintitlanis noangelwah, iwa kinmoololokiweh kan kateh noaxkawah akimeh kichiwah tlajtlákoli iwa akimeh kintoktiah oksikimeh makichiwakah noiwah. ");
INSERT INTO nplNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iwa kinkajkawaskeh ijtik tletl kan chokaskeh iwa tlannetsoniskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ijkuakó non yolchipawakeh, tsotlaniskeh kemi n tonati ompa kan tlanawatia Totajtsi. ¡Akin kipia inakas, makajsikamati! ");
INSERT INTO nplNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","'Itech ilwikak kan Dios tlanawatia, noiwa kemi se xoktsi non kipia tomi non tlalpachitok tetlala. Ijkuak se tlakatl konajsi non tomi oksepa kitlaatia, iwa ika miak pakílistli yawi kinamaka nochi tlan kipia iwa kikoa n tlali kan okajsik non xoktsi. ");
INSERT INTO nplNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","'Noiwa itech ilwikak kan Dios tlanawatia kemi se tlasémanki non kintemojtinemi perlas non patiojkeh, ");
INSERT INTO nplNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","iwa ijkuak kajsi se perla non patio, motlanajnamakia iwa kikoa non perla. ");
INSERT INTO nplNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","'Noiwa itech ilwikak kan Dios tlanawatia kemi se michayatl non michmajkeh kontlamotlah ijtik atl iwa kinmoololoa nochi michimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ijkuak n michayatl yotenki, n michmajkeh kikixtiah itempa n atl iwa pewa kimpejpenah n michimeh. Non kualteh michimeh konintlaliah ijtik chikimeh, iwa non amo kualteh kintlamotlah. ");
INSERT INTO nplNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ijkó tlamochiwas ijkuak ajsiki n iksemi tonati. Kisaskeh iangelwah Dios iwa kinxexeloskeh n tlajtlakolejkeh iwan yolmilajkameh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Iwa n tlajtlakolejkeh kintlamotlaskeh ijtik tletl, kan chokaskeh iwa tlannetsoniskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ijkuakó Jesús okintlajtlani: —¿Nonkajsikamatih nochi tlan nomechilijtok? Yejwah okilijkeh: —Ejé, tikkajsikamatih. ");
INSERT INTO nplNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ijkuakó Jesús okinmili: —Ijkuak se tlamachti non kitemachtia n tlanawátili kimomachtia kenomi Dios tlanawatia kan ilwikak, mochiwa kemi se chane, ika tlan kitlatijtok kimati kikixtia itla yankuik iwa itla ya wewe. ");
INSERT INTO nplNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ijkuak Jesús otlanki okintlapowi nochi ni, oyá de ompa. ");
INSERT INTO nplNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Okalakito kan ialtépeu. Ompa opé tlamachtia kan sinagoga, iwa n tlakah omotlajtlachialtiayah iwa okimoliayah: —¿Kan okajsik nochi non ixtlamatílistli? ¡Kenomi weleti kinchiwa ninteh milagros! ");
INSERT INTO nplNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Amo ye ipiltsi n kuaujxinki? ¿Amo imamá itoka María? ¿Amo ye ikni n Jacobo, José, Simón iwa n Judas? ");
INSERT INTO nplNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amo nika chanti iweltiwah. ¿Kan okikuito nochi tlan kimati? ");
INSERT INTO nplNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yika, n tlakah omokuejsoayah. Pero Jesús okinmili: —San kan yetos kitlakitah se profeta, pero itech ialtépeu iwa icha, amaka kitlakita. ");
INSERT INTO nplNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iwa amo okinchi miakeh milagros itech ialtépeu, porke amo nochteh okineltokaya. ");
INSERT INTO nplNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Itech nekateh tonatijmeh Herodes Antipas n Tetrarca non otlanawatijtoka Galilea, okima tlan Jesús okichiwaya, ");
INSERT INTO nplNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","iwa okinmili itlakawah: —Neká tlakatl, ye n Juan non otlakuaatekiaya, non yomoyoliti, yika weleti kinchiwa wejweyi milagros. ");
INSERT INTO nplNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes yotlanawatijka makikitskikah n Juan iwa makiijilpikah ika kadena. Ijkó okitokti n Juan porke okiliaya mach kuali tlan okichijtoka iwan ikuñada Herodías, isiwa ikni Felipe. ");
INSERT INTO nplNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan okiliaya n Herodes: —Tlajtlákoli tinepanitos iwan mokuñada. ");
INSERT INTO nplNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes okinekia kimiktis n Juan, pero okinmawiliaya n tlakah porke nochteh okimatiah Juan profeta. ");
INSERT INTO nplNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero ijkuak omoxiujtili Herodes Antipas, ichpoch n Herodías, omijtoti inmixpa nochteh n tlatlálwilteh, iwa satlawel okiwelitak n Herodes. ");
INSERT INTO nplNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ompa Herodes okimák itlajtol, kimakas san tlan ye kitlajtlanilis. ");
INSERT INTO nplNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ijkuakó n íchpochtli achto omotlapowi iwan imamá iwa sanima okili n Herodes: —Techmaka itsonteko n Juan Bautista itech se tlakualkaxitl. ");
INSERT INTO nplNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Semi omoyolkoko n rey ijkuak okikak tlan okitlajtlanili n íchpochtli. Pero ken okimák itlajtol inmixpa nochteh itlatlalwilwah, otlanawati makimakakah tlan okitlájtlanki. ");
INSERT INTO nplNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iwa otlanawati makikechtsontekitih n Juan kan otsaktoka, ");
INSERT INTO nplNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","sanima okualikilijkeh itsonteko n Juan itech se tlakualkaxitl iwa okimaktilijkeh n íchpochtli, iwa n íchpochtli okimaktili ina. ");
INSERT INTO nplNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Satepa owalajkeh itlamachtijkawah n Juan iwa okiwikakeh ikuerpo. Okitookatoh, iwa otlanki okimatiltitoh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ijkuak Jesús okima tlan okitoktijkeh n Juan, otlejkok itech se barka iwa oyá iselti kan amaka kikuejsoskia. Pero ijkuak n tlakah okimatkeh, owalkiskeh iwa oyajkeh okajsitoh nejnentiwih. ");
INSERT INTO nplNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ijkuak Jesús otemok itech barka, okinmitak miakeh tlakah, okimiknoma iwa okimpajti n kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ijkuak opé tiotlati, itlamachtijkawah omijkuanijkeh iwa okilijkeh: —Yotiotlatik, iwa ik nika amaka chanti. Xikintitlani nochteh mawiah itech altepemeh, makimokowitih tlan kikuaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús okinmili: —Mach moneki mawiah, xikintlamakakah nomejwah. ");
INSERT INTO nplNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yejwah okilijkeh: —Sanwel tikpiah mákuili pameh iwa ome michimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús okinmili: —Nika techalinwikilikah. ");
INSERT INTO nplNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Otlanawati mamotlajtlalikah ipan xiwitl. Jesús okinmónanki n mákuili pameh iwa n ome michimeh. Ontlachixki ilwikak iwa omotlasojkama inawak Dios, okintlajkotlápanki n pameh iwa okinmaktili itlamachtijkawah makinxejxelilikah. ");
INSERT INTO nplNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nochteh otlakuajkeh iwa kuali oijixwikeh. Iwa okintetemitijkeh májtlaktli iwa ome chikimeh ika patlatlapanali. ");
INSERT INTO nplNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kemi mákuili mil tlakah otlakuajkeh, ixkoya n siwameh iwa n pípilteh. ");
INSERT INTO nplNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Satepa, Jesús okinnawati itlamachtijkawah matlejkokah itech barka iwa sa matlayakanakah makikojchalwikah n lago, ijkuak Ye ok kinmakawaskia n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Satepa, ijkuak yokinmaakah n tlakah, Jesús otlejkok ipan tepetl omotiotsajtsilito iselti. Ijkuak otleyuak ompa okatka iselti. ");
INSERT INTO nplNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","N barka yotlantiaya itlajko n lago. N atl omotlawitekia itech barka porke n ejekatl okimixnamiktiwalaya. ");
INSERT INTO nplNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sa kualka ijkuak ok tleyua, Jesús onejnentiaya ixko atl iwa okinmajsito itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iwa ijkuak itlamachtijkawah okitakeh nejnentiwits ixko atl, omomojtijkeh iwa otsajtsikeh: —¡Se ekawitl! ");
INSERT INTO nplNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús okínnotski iwa okinmili: —¡Ximoyolchikawakah, Ne Ni Jesús! ");
INSERT INTO nplNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ijkuakó Pedro okili: —Noteko, tla milák Tejwatsi, xitlanawati maninejnemi ixko atl iwa manimitsajsiti. ");
INSERT INTO nplNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iwa Jesús okili: —Xiwiki. Ijkuakó Pedro owaltemok de kan barka iwa opé nejnemi ixko atl, iwa konajsiskia n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero ijkuak okimachili chikawak oejekatoka, omaujki iwa opé apolaki. Ijkuakó otsajtsik: —¡Noteko, techmakixti! ");
INSERT INTO nplNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sannima Jesús okimakitskijtiwetski iwa okili: —¡Amo tiyektlaneltoka!, ¿amo techneltoka? ");
INSERT INTO nplNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ijkuak otlejkokeh itech barka, n ejekatl omóketski. ");
INSERT INTO nplNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ijkuakó, itlamachtijkawah omotlankuaketskeh iyakapa n Jesús iwa okilijkeh: —Milák, Tejwatsi Ikone Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ijkuak otlankeh okojchalwijkeh n lago de Galilea, oajsito kan tlali de Genesaret. ");
INSERT INTO nplNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ijkuak n tlakah non ik ompa ochantitokah okixmatkeh n Jesús, sentetl okitematiltijkeh iwa okwalinwikilijkeh nochteh n kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Okitlatlaujtiayah makinkawili maya san makitempantelkolikah itlakeh, iwa akimeh okitempantelkoayah itlakeh opajtiah. ");
INSERT INTO nplNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ijkuakó sikimeh fariseos iwa non kitemachtiah n tlanawatílistli non owalajkeh de Jerusalén, omijkuanijkeh inawak Jesús iwa okilijkeh: ");
INSERT INTO nplNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Motlamachtijkawah kixpanawiah tlan otechititijkeh totatawah. Yejwah amo momajtekiah ijkuak kikuah paj kemi otechmachtijkeh totatawah. ");
INSERT INTO nplNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pero Jesús okintlajtlani: —¿Tleka noiwa nomejwah nonkixpanawiah itlanawatil Dios, iwa okachi nonkimopantiah tlan yowejka okichiwayah nomotatawah? ");
INSERT INTO nplNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios okijto: “Xiktlakita mota iwa mona”, iwa “akin fiero kitenewas ita noso ina, kuali makimiktikah.” ");
INSERT INTO nplNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero nomejwah nonkijtoah se tlakatl weletis kilis ita noso ina: “Mach weletis nimitspalewis, porke tlan nikpixtok, yonikxelo para Dios.” ");
INSERT INTO nplNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ijkuak nomejwah ijkó nonkijtoah, kijtosneki mach ok moneki se kimpalewis n tetajmeh. Nomejwah ijkó nonkijtlakoah itlanawatil Dios porke nonkichiwah tlan yowejka okichiwayah nomotatawah. ");
INSERT INTO nplNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Íxkopteh! Yompa tlan onomechilih n profeta Isaías ijkuak okijto: ");
INSERT INTO nplNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ninteh tlakah ika inkamak kijtoah nechtlakitah, pero amo nechtlakitah ika inyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sanenka nechweyijkatlaliah, porke tlan kitemachtiah, san intlanawatil n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ijkuakó Jesús okínnotski n tlakah iwa okinmili: —Techkakikah iwa xikkajsikamatikah tlan nomechilis: ");
INSERT INTO nplNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Amo kiyolijtlakoa n tlakatl tlan kalaki itech ikamak, yej teyolijtlakoa tlan kisa itech ikamak n tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ijkuakó itlamachtijkawah n Jesús omijkuanijkeh inawak iwa okilijkeh: —¿Yotikma n fariseos okualankeh ijkuak okikakeh tlan otikijto? ");
INSERT INTO nplNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero Ye okinnankili: —Nochi tlatookali non amo okitookak Notajtsi non kajki ilwikak, kiwiwitlaskeh ika nochi inelwayo. ");
INSERT INTO nplNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xikinkawakah, yejwah noiwa amo tlachiah iwa kinyakanah oksikimeh kemi yejwah. Tla se non amo tlachia kiyakanas ok se kemi ye, san ken ome wetsiskeh itech tékochtli. ");
INSERT INTO nplNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ijkuakó Pedro okili n Jesús: —Techajsikamatilti non tlapoálistli. ");
INSERT INTO nplNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús okijto: —¿Nomejwah noiwa ayamó nonkajsikamatih? ");
INSERT INTO nplNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Amo nonkajsikamatih nochi tlan kalaki ijtik ikamak se tlakatl, kalaki san ijtik itlalax, iwa satepa kisa kala? ");
INSERT INTO nplNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero tlan kisa ijtik ikamak se tlakatl, kisa ijtik iyolo, iwa ye tlan kijtlakolia iyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porke ijtik iyolo n tlakatl kisa tlan amo kuali kiyejyekolia, ijkuak temiktia, noso momekatia, noso tlajtlakolchijtinemi ika ikuerpo, tlachteki, kisentlalia tlan amo milák, noso tepojpoa. ");
INSERT INTO nplNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nochi ni ye tlan kinmijtlakolia inyolo n tlakah, pero tla se tlakatl amo moyekmapajpaka ijkuak tlakua, noni amo kiyolijtlakoa. ");
INSERT INTO nplNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ijkuakó Jesús okiski de ompa, iwa oyá kan tlalmeh de Tiro iwa Sidón. ");
INSERT INTO nplNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Se siwatl de Canaán non ik ompa ochantitoka owala kojtsajtsitiwits inawak Jesús iwa okili: —¡Noteko, tekone de David, techiknomati! Nochpoch kipia se espíritu amokuali iwa sa ik panoa kitlaijyowiltia. ");
INSERT INTO nplNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús mach okinankili. Ijkuakó itlamachtijkawah omijkuanijkeh inawak iwa okitlatlautijkeh: —Xikpalewi neká siwatl porke kojtsajtsitiwits tokuitlapah. ");
INSERT INTO nplNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús okijto: —Dios onechaltítlanki sanwel manikimpalewiki n tlakah de Israel non moixpolojtinemih kemi ichkameh. ");
INSERT INTO nplNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero n siwatl omijkuani iwa omotlankuaketski ixpa n Jesús iwa okili: —¡Noteko, techpalewi! ");
INSERT INTO nplNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iwa Jesús okili: —Amo kuali se kinkixtilis intlakual n pípilteh iwa makinmakakah n chichimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","N siwatl okinankili: —Milák tlan tikijtoa Noteko, asta n chichimeh kikuah n kamapáyaxtli non wetsi itlampa mesa keman tlakuajtokeh intekowajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijkuakó Jesús okili: —¡Siwatl, kema weyi motlaneltokalis! Mamochiwa kemi te tikneki. Ijkuakó, ichpoch non siwatl owalpajtik non ora. ");
INSERT INTO nplNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús okiski de ompa iwa oyá itempa n lago de Galilea. Otlanki otlejkok ipan se tepetl iwa ompa omotlali. ");
INSERT INTO nplNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ijkuakó, miakeh tlakah okalakitoh inawak Ye, iwa okinwikilijkeh non koxomeh, non amo tlachiah, non oikximijmiktokah, non amo otlajtoayah, iwa miakeh oksikimeh kokoxkeh. Okintlalijkeh ikxitla n Jesús, iwa Ye okimpajti. ");
INSERT INTO nplNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ijkuakó n tlakah omotlajtlachialtiayah ken okitakeh akimeh amo otlajtoayah otlajtojkeh, non oikximijmiktokah opajtikeh, non koxomeh onejnenkeh iwa non amo otlachiayah otlachixkeh. Iwa nochteh opé kiweyijkatlaliah iwa motlasojkamatih inawak Dios de Israel. ");
INSERT INTO nplNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ijkuakó Jesús okonínnotski itlamachtijkawah iwa okinmili: —Semi nikinmiknomati ninteh tlakah, porke yopanokeh eyi tonati nowa iwa amo kipiah tlan kikuaskeh. Amo nikneki nikintitlanis incha maapismiktiwiah, amo kichiwa wetsitiweh itech ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ijkuakó itlamachtijkawah n Jesús okilijkeh: —Ik nika amaka chanchiwa. ¿Kan tikkuitiweh tlákuali para tikintlakualtiskeh nochteh ninteh tlakah? ");
INSERT INTO nplNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús okintlajtlani: —¿Kech paj nonkipiah? Yejwah okinankilijkeh: —Chikomeh pameh iwa kanaj kechmeh michintsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ijkuakó Jesús okinnawati mamotlajtlalikah ipan tlali. ");
INSERT INTO nplNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesús okinmónanki n chikome pameh iwa n michimeh iwa omotlasojkama inawak Dios. Otlanki okintlatlajkotlapanki iwa okinmajmák itlamachtijkawah makinxejxelilikah nochteh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nochteh otlakuajkeh iwa kuali oixwikeh. Iwa tlan ayakmó okikuajkeh okoololojkeh iwa okintetemitijkeh chikome chikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kemi nawi mil tlakah otlakuajkeh, ixkoya n siwameh iwa n pípilteh. ");
INSERT INTO nplNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Satepa Jesús okinmaaka nochteh n tlakah, otlejkok itech se barka iwa oyá kan tlali de Magdala. ");
INSERT INTO nplNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","N fariseos iwa n saduseos okinekiah kitlajtoltlapololtiskeh n Jesús, yika okitatoh iwa okitlajtlanilijkeh makinnextili se milagro de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Ye okinmili: —Ijkuak waltiotlati, nomejwah nonkijtoah: “Mostla kualtsi tonas ken tlachichilewi itech ilwikak”, ");
INSERT INTO nplNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","iwa ijkuak tlanesi nonkijtoah: “Axa ejekas iwa kiawis, ken tlachichilewi iwa tlamixtentok.” ¡Íxkopteh! Nomejwah nonweletih nonkiyejyekoliah tlan nonkitah itech ilwikak, pero amo nonweletih nonkitah tlan tlamochijtok itech ninteh tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ninteh tlakah amo kualteh iwa mekatánajteh kinekih kitaskeh se milagro, pero amo kitaskeh ok se milagro, sanwel tlan yopanok n profeta Jonás. Okinkakajte iwa oyá. ");
INSERT INTO nplNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ijkuak itlamachtijkawah n Jesús otlankeh okojchalwijkeh n lago, okualilnamikeh kiwikaskiah itla paj. ");
INSERT INTO nplNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ijkuakó Jesús okinmili: —Techkakikah, ximotlachilikah de inlevadura n fariseos iwa n saduseos. ");
INSERT INTO nplNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Itlamachtijkawah opé kimoliah: —Ijkó techilia porke amo otikwalikakeh paj. ");
INSERT INTO nplNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero Jesús san nima okajsikama iwa okinmili: —¿Tleka nomechtekipachoah amo nonkipiah paj? ¡Nomejwah amo miak nomotlaneltokalis! ");
INSERT INTO nplNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ayamó nonkajsikamatih nion ayakmó nonkilnamikih n mákuili pameh non onikinxejxelili n mákuili mil tlakah, iwa ok kech chikiwitl ononkoololojkeh? ");
INSERT INTO nplNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Noiwa ayakmó nonkilnamikih n chikome pameh non onikinxejxelili n nawi mil tlakah, iwa ok kech chikiwitl ononkoololojkeh? ");
INSERT INTO nplNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tleka amo nonkajsikamatih amo onitlajtojtoka de paj, ijkuak onomechili ximotlachilikah de inlevadura n fariseos iwa n saduseos? ");
INSERT INTO nplNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ijkuakó yejwah okajsikamatkeh Jesús amo okinmilijka mamotlachilikah de ilevadura n paj, yej de intlamachtilis n fariseos iwa n saduseos. ");
INSERT INTO nplNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ijkuak Jesús okalakito kan tlali de Cesarea de Filipo, okintlajtlani itlamachtijkawah: —¿Tlan kimoliah n tlakah de Ne Non onimochi ni tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yejwah okinankilijkeh: —Sikimeh kijtoah Tejwatsi ti Juan Bautista, oksikimeh kijtoah Tejwatsi ti Elías, iwa oksikimeh kijtoah Tejwatsi ti Jeremías noso aka ok se profeta. ");
INSERT INTO nplNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ijkuakó Jesús okinmili: —Iwa nomejwah, ¿tlan non kimoliah, Akin Ne? ");
INSERT INTO nplNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro okinankili: —Tejwatsi Ti Cristo, Ikone Dios non yolitok. ");
INSERT INTO nplNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ijkuakó Jesús okili: —Xiyolpaki te, Simón, ipiltsi Jonás, porke amaka de nin tlaltíkpaktli omitsnextili, yej Notajtsi Dios non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iwa Ne nimitsilia, te ti Pedro, iwa ipan non tetl nikchijchiwas notiopa, iwa nion ichikawalis non tlanawatia kan kateh non yomikkeh weletis kitlanis. ");
INSERT INTO nplNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne nimitsinmakas n yabejteh de ilwikak kan Dios tlanawatia. Iwa nochi tlan tikilpis itech nin tlaltíkpaktli ya ilpitok kan ilwikak, iwa nochi tlan tiktojtomas itech nin tlaltíkpaktli, ya tojtontok kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ijkuakó Jesús okinnawati itlamachtijkawah amaka makilikah Ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ijkuakó Jesús opé kinmilia itlamachtijkawah omonekia yas Jerusalén, iwa ompa chikawak kitlaijyowiltiskeh n tetajmeh tlayakankeh n tiopixkeh tlayakankeh iwa non kitemachtiah n tlanawatílistli. Noiwa okinmili kimiktiskeh, pero ipan eyi tonati moyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ijkuakó Pedro okiwík n Jesús ixkoya, iwa opé kajwa: —¡Noteko, amo Dios makimonekilti! ¡Ayik ijkó ximochiwa! ");
INSERT INTO nplNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús omókopki iwa okili n Pedro: —¡Xio kan ayakmó nimitsitas, satanás! ¡San techtsatsakuilia! Porke amo mitstekipachoa tlan Dios kimonekiltia, yej mitstekipachoa tlan kinekih n tlakah itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Satepa Jesús okinmili itlamachtijkawah: —Tla aka kineki wits nonawak, ayakmó makichiwa san tlan ye kineki. Yej, makixiko nochi tlan panos iwa mawiki nowa, maya makimiktikah itech se krus. ");
INSERT INTO nplNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porke akin kinekis kipalewis inemilis, kipolos. Tla aka kipoloa inemilis por ne, kajsis inemilis. ");
INSERT INTO nplNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Porke mach itla ipati tla se tlakatl kimotlanilia nochi tlan onka itech nin tlaltíkpaktli, iwa satepa mikki iwa kipolos ialma. Porke mach itla onka itech nin tlaltíkpaktli tlan ika weletis kitlaxtlawas ialma. ");
INSERT INTO nplNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porke Ne Non onimochi ni tlakatl niwits ika iweyijkachiwalis Notajtsi iwa n ángelteh, ijkuakó sejse niktlaxtlawis ika tlan okichi. ");
INSERT INTO nplNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","De milajka nomechilia, sikimeh non nika kateh amo mikiskeh asta ijkuak nechitaskeh Ne Non onimochi ni tlakatl, iwa pewas nitlanawatis. ");
INSERT INTO nplNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chikwase tonati satepa, Jesús okiwík n Pedro, iwa ome iknimeh, Jacobo iwa n Juan kan se tepetl wejkapa. ");
INSERT INTO nplNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ompa inyakapah, Jesús omoixpatlak. Ixkotsi otsotlania kemi n tonati iwa itlake omókopki istak kemi tláwili. ");
INSERT INTO nplNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sa nima owalmonextijkeh Moisés iwa n Elías. Omotlapowijtokah iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijkuakó Pedro okili n Jesús: —Noteko, ¡san kuali nika tikateh! Tla tikmonekiltia tikinchijchiwas-keh eyi akákalteh, se para Tejwatsi, se para Moisés iwa ok se para Elías. ");
INSERT INTO nplNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro ok otlajtojtoka ijkuak se mextli okinmokenti ika itlasekawilo. Iwa de kan mextli omokak se tlájtoli non okijto: —Ye ni Nokone non niktlasojtla, non Ne onikpejpenki xikkakikah itlajtol. ");
INSERT INTO nplNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ijkuak itlamachtijkawah okikakeh, saikpanoa omomojtijkeh iwa omotlankuaketskeh asta okitelkoto n tlali ika inmixkuak. ");
INSERT INTO nplNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ijkuakó Jesús owalmijkuani innawak, okonnintelko iwa okinmili: —Ximoketsakah, amo ximomojtikah. ");
INSERT INTO nplNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ijkuak owaltlajtlachixkeh ayakmaka okitakeh, sanwel Jesús iselti. ");
INSERT INTO nplNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ijkuak owaltemotiwalayah itech tepetl Jesús okinnawati: —Amaka xikmatiltikah tlan ononkitakeh, asta ijkuak Ne Non onimochi ni tlakatl, nimikis iwa oksepa nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ijkuakó itlamachtijkawah okitlajtlanijkeh: —¿Tleka non kitemachtiah n tlanawatílistli kijtoah Elías achto wits? ");
INSERT INTO nplNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús okinnankili: —Milák, Elías achto wits iwa ye kiyektlalis nochi. ");
INSERT INTO nplNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero Ne nomechilia Elías yowitsa, iwa n tlamachtijkeh mach okineltokakeh porke amo okiyekixmatkeh, yej okitoktijkeh san tlan yejwah okinekeh. Ijkó noiwa nechtlaijyowiltiskeh Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ijkuakó itlamachtijkawah okajsikamatkeh Jesús okintlapowiaya de Juan Bautista. ");
INSERT INTO nplNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ijkuak okalakitoh kan omoololojkah n tlakah, owalmijkuani se tlakatl inawak Jesús, omotlankuáketski iyakapa iwa okili: ");
INSERT INTO nplNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Noteko, xikiknomati nopiltsi, mimiki iwa saikpanoa tlaijyowia, ya miak welta wetsi itech tletl iwa ijtik atl. ");
INSERT INTO nplNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Onikinwalikili motlamachtijkawah, iwa mach weletih kipajtiah. ");
INSERT INTO nplNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús okinnankili: —¡Nomejwah mach nontlaneltokah iwa mach nontetlakitakeh! ¡Asta kemania niyetos nomowah iwa nomechxikojtos! Techalikilikah nika n télpochtli. ");
INSERT INTO nplNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ijkuakó Jesús okajwak n amokuali espíritu iwa okinawati makikajkawa n télpochtli, iwa sa nima n télpochtli owalpajtik. ");
INSERT INTO nplNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Satepa itlamachtijkawah omotlapowitoh ixkoya iwa n Jesús. Iwa okitlajtlanijkeh: —¿Tleka tejwah amo otiweletkeh otikkixtijkeh non espíritu amokuali? ");
INSERT INTO nplNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús okinmili: —Porke ayamó miak nontlaneltokah. De milajka nomechilia tla nonkipiaskiah tlaneltokálistli maya san kemi se xínatsintli de mostaza, nonkiliskiah nin tepetl: “Ximoachiwa iwa nepa ximomanati.” N tepetl moijkuaniskia. Nochi weletiskiah nonkichiwaskiah. ");
INSERT INTO nplNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Se tonati keman omoololojkeh kan tlali de Galilea, Jesús okinmili itlamachtijkawah: Ne Non onimochi ni tlakatl nechtemaktiskeh inmak tekiwajkeh, ");
INSERT INTO nplNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iwa yejwah nechmiktiskeh, pero ipan eyi tonati nimoyolitis. Ninteh tlájtolteh okinyolkoko itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ijkuak Jesús iwa itlamachtijkawah okalakitoh Capernaúm, non tlakobraroah impuesto para n Weyi Tiopa oyajkeh okitatoh n Pedro iwa okitlajtlanijkeh: —¿Nomotlamachti kitlaxtlawa impuesto para n Weyi Tiopa? ");
INSERT INTO nplNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro otlanankili: —Ejé, kitlaxtlawa. Iwa ijkuak Pedro okalak ijtik kali, Jesús okitlajtlani: —¿Kenomi tikita, Simón? ¿N wejweyi tlanawatijkeh kintlaxtlawaltiah impuesto non nika chantitokeh noso non amo nika chanti? ");
INSERT INTO nplNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro okinankili: —Non amo de nika. Jesús okili: —Ijkó kiné non nika chanchiwa amo kipiah kitlaxtlawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ijkó para amo matikinkualanikah, xio kan lago, ximichma iwa n michi non achto tikkixtis, xikkamatlapo iwa ompa tikajsis se tomi non ika xiktlaxtlawa noimpuesto iwa moimpuesto. ");
INSERT INTO nplNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ijkuakó itlamachtijkawah n Jesús omijkuanijkeh inawak, iwa okitlajtlanijkeh: —¿Akin okachi weyi itech ilwikak kan Dios tlanawatia? ");
INSERT INTO nplNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús okínotski se chokotsi, iwa okontlali tlatlajkotia, ");
INSERT INTO nplNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","iwa okijto: —De milajka nomechilia, tla amo nonmokopah kemi ninteh pípilteh iwa nonkichiwah kemi yejwah, amo nonkalakiskeh ilwikak kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yika, akin yetos yolyámanki kemi nin chokotsi, ye okachi yetos weyi itech ilwikak kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Iwa akin kiselia se chokotsi kemi ni itech Notoka, kijtosneki Ne nechselia. ");
INSERT INTO nplNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","'Tla aka kitoktis mawetsi itech tlajtlákoli, seme de ninteh tsitsikitikeh akin nechneltokah, okachi kuali makilpilikah itech ikech se weyi tetl iwa makonkajkawakah kan weyi atl kan okachi tlawejkatla. ");
INSERT INTO nplNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Miálmasteh tlaltikpaktlakah! Ken sa tlawel onka miak tlan ika se wetsis itech tlajtlákoli, nochipa ijkó yetos. Pero ¡mialma!, neká tlakatl akin kitoktis aka ok se mawetsi itech tlajtlákoli. ");
INSERT INTO nplNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","'Yika, tla moma noso mokxi mitstoktia xiwetsi itech tlajtlákoli, xikmotekili iwa wejka xikontlamotla. Okachi kuali tla tikalakis ilwikak tiikxitepo noso timatepo iwa amo ika ome momawah noso ika ome mokxiwah mamitsonkajkawakah ijtik tletl non ayik sewis. ");
INSERT INTO nplNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iwa tla moixtololo mitstoktia xiwetsi itech tlajtlákoli, xikmokixtili iwa wejka xikontlamotla. Okachi kuali xikalaki ilwikak san ika se moixtololo, iwa amo tiajsitok ika ome moixtololowah mamitsontlamotlakah miktla kan mimilikatok tletl. ");
INSERT INTO nplNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","'Amo xikintlawelitakah seme de ninteh pípilteh. Ne nomechilia, kan ilwikak iangelwah ninteh pípilteh nochipa kateh ixpan Notajtsi non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","'¿Kenomi nonkitah? Tla se tlakatl kimpia se siento iichkawah, iwa kipoloa se, ¿amo kinkajtewa n nawi póali iwa n káxtoli iwa n nawi (99) ichkameh kan tepeyo iwa kontemoa non opoliwik? ");
INSERT INTO nplNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iwa tla okajsik iichkatsi non opolika, okachi paki ke por non oksikimeh ichkameh non amo opolikah. ");
INSERT INTO nplNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ijkó noiwa Totajtsi non kajki ilwikak amo kineki mapoliwi nion se de ninteh pípilteh. ");
INSERT INTO nplNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","'Tla mokni itla mitstoktis, xiktlapowi iselti iwa xikkajsikamatilti itlajtlakol. Tla omitskak, yotikmotlanili iwa timoyekwikas oksepa íwa. ");
INSERT INTO nplNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero tla amo kineki mitskakis, xiknotsa ok se noso ome tokniwah, iwa ijkuak non moyekkawaskeh yejwah makikakikah tlan ye omitstokti. ");
INSERT INTO nplNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tla nion yejwah kinkaki, xikinmoololo nochteh n tokniwah, iwa tla nion tokniwah kinkaki, xikita mokni kemi non amo kineltoka Dios noso kemi se non koololoa impuestos para roma. ");
INSERT INTO nplNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Ne nomechilia, tlan nomejwah nonkilpiskeh itech nin tlaltíkpaktli, noiwa ilpitos kan ilwikak, iwa tlan nomejwah nonkitojtomaskeh itech nin tlaltíkpaktli, noiwa tojtontos kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","'Noiwa nomechilia: tla itech nin tlaltíkpaktli non momeh nonmoyektlapowiah para nonkitlajtlaniskeh itla Notajtsi non kajki ilwikak, Ye nomechmakas tlan nonkitlajtlaniliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porke kan ome noso eyi moololoah ika Notoka, ompa nika inwah. ");
INSERT INTO nplNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ijkuakó Pedro omijkuani inawak Jesús iwa okitlajtlani: —Noteko, ¿kech welta moneki maniktlapojpolwi nokni, tla itla nechtoktia? ¿Asta chikome welta? ");
INSERT INTO nplNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús okinankili: —Amo nimitsilia xiktlapojpolwi san chikome welta, yej eyipóali iwan májtlaktli iwa chikomeh welta xiktlapojpolwi. ");
INSERT INTO nplNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Yika, itech ilwikak kan Dios tlanawatia, kemi se rey, non okinekia makikopilikah tlan okiwikiliayah itlakawah. ");
INSERT INTO nplNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Okualikilijkeh se itlakewal non okiwikiliaya sien sentenario. ");
INSERT INTO nplNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kemi non tlakéwale amo okipiaya tlan ika kitlaxtlawilis tlan okiwikiliaya, n rey otlanawati makinamakakah non tetlakéwale sansikah iwa isiwa, ipilwah iwa nochi tlan okipiaya para ika makimokopili tlan okiwikiliaya. ");
INSERT INTO nplNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ijkuakó itetlakewal omotlankuaketski iyakapa n rey iwa okitlatlauti: “Noteko, techonmochiali iwa nimitstlaxtlawilis nochi tlan nimitswikilia.” ");
INSERT INTO nplNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","N rey okiknoma, iwa okitlapojpolwili nochi tlan okiwikiliaya iwa okikawili mawia. ");
INSERT INTO nplNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero ijkuak okiski non tetlakéwale, okinamik se itlakaikni non okiwikiliaya tlan se kitlani itech se tonati. Okikitski kan itoskak iwa opé kitoskapatska iwa okiliaya: “¡Techtlaxtlawili tlan techwikilia!” ");
INSERT INTO nplNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ijkuakó itlakaikni omotlankuáketski iyakapa iwa okitlatlauti: “Techonchia iwa nimitstlaxtlawilis tlan nimitswikilia.” ");
INSERT INTO nplNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ye mach okinek kichias, yej okitsakuato para makitlaxtlawili nochi tlan okiwikiliaya. ");
INSERT INTO nplNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ijkuak n oksikimeh tekitkeh okimatkeh, miak okinyolkoko iwa okilitoh n rey nochi tlan otlamochi. ");
INSERT INTO nplNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ijkuakó n rey otlatítlanki makinotsatih itlakewal iwa okili: “¡Semi amo tikuali! Ne onimitstlapojpolwili nochi tlan otechwikiliaya por otimotlatlauti nonawak. ");
INSERT INTO nplNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Omonekia te noiwa tikiknomatiskia neká tokni, ijkó kemi ne onimitsiknoma.” ");
INSERT INTO nplNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ijkuakó n rey sa tlawel okuálanki, iwa otlanawati makitsakuatih iwa makikajkawakah asta ijkuak nochi makitlaxtlawili. ");
INSERT INTO nplNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús noiwa okinmili: —Notajtsi non kajki ilwikak, noiwa ijkó kitoktis akin amo kinekis kitlapojpolwis aka ikni ika nochi iyolo. ");
INSERT INTO nplNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ijkuak Jesús otlanki okintlapowi, oyá de Galilea, okikojchalwi n río Jordán iwa okalakito kan tlali de Judea. ");
INSERT INTO nplNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Miakeh okitokakeh n Jesús, iwa ompa okimpajti non omokokoayah. ");
INSERT INTO nplNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ijkuakó sikimeh fariseos omijkuanijkeh inawak Jesús porke okinekiah kitlajtoltlapololtiskeh iwa okitlajtlanijkeh: —¿Kuali kajki tla se tlakatl kikajkawa isiwa san por ayakmó kuali mowikah? ");
INSERT INTO nplNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús okinnankili: —¿Ayamó nonkiamapoah itlajkuilol Dios?, itech ipewaya n tlaltíkpaktli, Dios okinchijchi “tlakatl iwa siwatl.” ");
INSERT INTO nplNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Noiwa okinmili: “Yika n tlakatl kikawas ita iwa ina iwa moseitilis iwa isiwa, iwa yejwah ome mochiwaskeh san se.” ");
INSERT INTO nplNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ijkó kiné, yejwah ayakmó ome, yej sanwel se. Yika, tlan Dios yokiseitili, amaka makinxexelo. ");
INSERT INTO nplNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ijkuakó n fariseos okitlajtlanijkeh: —¿Tleka kiné Moisés okitekawili mamosiwakajkawa se tlakatl, iwa makimajmanili isiwa se amatl kan makijto kikajkawa? ");
INSERT INTO nplNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús okinmili: —Moisés okitekawili ximosiwakajkawakah, porke yokixmatiah tlakuawak nomoyolo; pero achto amo ijkó okatka. ");
INSERT INTO nplNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne nomechilia, sanwel tla isiwa omomekati, weletis itlákau kikajkawas isiwa. Porke akin mosiwakajkawa iwa monamiktia iwan ok se siwatl kijtosneki san kimomekatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Itlamachtijkawah n Jesús okilijkeh: —Tla milák amo kuali se mosiwakajkawas, okachi kuali amo se mamonamikti. ");
INSERT INTO nplNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ijkuakó Jesús okinnankili: —Amo nochteh weletih kajsikamatih nin tlájtoli, yej sanwel non Dios kimpalewia makkajsikamatikah. ");
INSERT INTO nplNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Onkateh tlakah otlakatkeh eunucos. Oksikimeh okintoktijkeh eunucos. Iwa oksikimeh nemih kemi eunucos porke kinekih tekitiskeh para Dios. Akin kinekis kiselis nin tlájtoli, makiseli. ");
INSERT INTO nplNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ijkuakó okwalinwikilijkeh n Jesús sikimeh kokoneh para makintlali imawah impah iwa makintiochiwa, pero itlamachtijkawah opé kinmajwah non okwalinwikayah. ");
INSERT INTO nplNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús okinmili: —Xikinkawilikah n kokoneh mawikih nonawak iwa amo xikintsakuilikah, porke akimeh yolyamankeh kemi kokoneh kalakiskeh ilwikak kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús okintlali imawah ipan kokoneh iwa satepa oyá de ompa. ");
INSERT INTO nplNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Se télpochtli omijkuani inawak Jesús iwa okitlajtlani: —Kuali tlamachti, ¿tlan moneki manikchiwa, para nikpias nemílistli non ayik tlami? ");
INSERT INTO nplNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús okinankili: —¿Tleka techtlajtlania tlan kuali? Sanwel onka se non de milajka kuali, iwa Ye Dios. Pero tla tikneki tiyolitos, xikintlakita n tlanawátilteh. ");
INSERT INTO nplNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","N télpochtli okili n Jesús: —¿Katliejmeh? Jesús okinankili: —Amo xitemikti, amo ximomekati, amo xitlachteki, amo xixolopijti. ");
INSERT INTO nplNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Xiktlakita mopapá iwa momamá, iwa xiktlasojtla mokni ijkó kemi te timotlasojtla. ");
INSERT INTO nplNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","N télpochtli okinankili: —Nochi noni nikchijtiwits, ¿tlan okachi nechpoloa manikchiwa? ");
INSERT INTO nplNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús okili: —Tla de milajka tikneki ti yetos ti kuali tlakatl, xiknamaka nochi tlan tikpia iwa n tomi xikintliokoli n próbesteh. Ijkó tiktlawelpias weyi tlaxtláwili kan ilwikak. Iwa tias nowa. ");
INSERT INTO nplNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Keman n télpochtli okikak tlan Jesús okili, oyá omoyolkokojtia porke okitlawelpiaya. ");
INSERT INTO nplNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ijkuakó Jesús okinmili itlamachtijkawah: —De milajka nomechilia, okachi owi kalakis itech ilwikak kan Dios tlanawatia se non kitlawelpia tomi. ");
INSERT INTO nplNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oksepa nomechilia, okachi amo owi panos se “kameyo” kan ik ixtololo n akuxa, iwa amo se non kipia tomi maweleti makalaki kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ijkuak itlamachtijkawah okikakeh nin tlájtoli, omotlajtlachialtijkeh iwa okimoliayah: —Tla ijkó, ¿akin weletis momakixtis? ");
INSERT INTO nplNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús okintlajtlatak iwa okinmili: —N tlaltikpaktlakah amo weleti kichiwah, pero Dios nochi weleti kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ijkuakó Pedro okili: —Noteko, tejwah otikkajtejkeh nochi tlan otikpiayah iwa mowah tikateh. ¿Tlan tikpiaskeh? ");
INSERT INTO nplNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús okinnankili: —De milajka, nomechilia, ijkuak ajsiki n tonati ijkuak nochi moyankuilis, Ne Non onimochi ni tlakatl nimoyayantis, iwa ompa nitlanawatis ika mawistílistli. Ipan non tonati nomejwah akimeh nonwitseh nowah, noiwa nonmoyayantiskeh itech májtlaktli iwa ome (12) siyajteh. Ompa nonkinmixkomakaskeh n májtlaktli iwa n ome (12) tribus de Israel. ");
INSERT INTO nplNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iwa nochteh akimeh okikakajtejkeh incha, inmikniwah, inweltiwah, intajwah, impilwah noso intlalwah por tetlapowijtinemih notlajtol, kiseliskeh okachi de nochi tlan okikakajtejkeh, iwa mach ayik mikiskeh yej nochipa yolitoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero non axa tlayakantokeh, yejwah yetoskeh iksemi, iwa non axa kateh sa iksemi, yejwah tlayakantoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","'Itech ilwikak kan Dios tlanawatia, noiwa kemi se tekowa non okiski san kualka okintlakewato sikimeh tlakah makitlatekilitih itlala. ");
INSERT INTO nplNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iwa omoyekka iwan tetlakéwalteh kintlaxtlawiskia se denario itech non tonati, iwa okintítlanki matekititih. ");
INSERT INTO nplNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","'Satepa n tekowa okiski kemi las nueve de kuinal, iwa okinmitak tiánkistli sikimeh tlakah non omajxilijtokah. ");
INSERT INTO nplNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iwa okinmili: “Xiwiah notlala xitekititih iwa nomechyektlaxtlawis.” Iwa yejwah oyájkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Oksepa okiski kemi tlajko tonati, noiwa kemi las tres de tiotlak, iwa okintlakewato oksikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","'Iwa kemi las sinko de tiotlak, oksepa okinmajsik oksikimeh non omajxilijtokah, iwa okintlajtlani: “¿Tleka nika ononmokajkeh interojtonati iwa amo onontekititoh?” ");
INSERT INTO nplNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yejwah okinankilijkeh: “Porke amaka otechtlakeh.” Ijkuakó ye okinmili: “Nomejwah noiwa xitekititih kan nouvaskuaujyo.” ");
INSERT INTO nplNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","'Ijkuak otleyuak, inteko okili itlakewal non okinnawatiaya n tlakah: “Xikinnotsa n tlakéwalteh iwa xikintlaxtlawi. Achto xikintlaxtlawi non okalakeh sa iksemi, iwa satepa non achto okalakeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ijkuakó owalajkeh n tetlakéwalteh non okalakeh kemi las sinko de tiotlak, iwa sejse okiseli se denario. ");
INSERT INTO nplNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Satepa, ijkuak owalajkeh akimeh kuinal opé tekitih, yejwah okimolijkeh chamo okachi kintlaxtlawiskiah. Pero yejwah noiwa okiselijkeh se denario. ");
INSERT INTO nplNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","'Yika, ijkuak okiselijkeh intlaxtlawil opé mokuejsoah iwan tekowa, ");
INSERT INTO nplNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","iwa okilijkeh: “Nekateh tlakah non otekitikeh sanwel se ora, otikintlaxtlawi kemi tejwah, non otikxikolijkeh nochi n tekitl ixko tonati.” ");
INSERT INTO nplNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero n tekowa okonili se de yejwah: “Noknitsi, ne amo nimitstlachtekijtok. ¿Amo otimokajkeh tiktlaniskia se denario itech nin tonati? ");
INSERT INTO nplNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xikonana modenario iwa xiajti. Ne nikneki niktlaxtlawis non sa iksemi okalak tlan te onimitsmák. ");
INSERT INTO nplNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mach amo weletis nikchiwas ika tlan noaxka tlan ne niknekis? Noso, ¿tixikojmiki por kuali ni tlakatl?” ");
INSERT INTO nplNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pero non axa amitla impati, satepa kinweyijkatlaliskeh, iwa non axa kinweyijkatlaliah, ijkuakó kinmitaskeh kemi amitla impati. ");
INSERT INTO nplNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ijkuak Jesús oyaya Jerusalén, ixkoya okinwík n májtlaktli iwa ome (12) itlamachtijkawah iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Xikkakikah, axa tiawih Jerusalén, iwa Ne Non onimochi ni tlakatl nechtemaktiskeh inmak tiopixkeh non tlayakantokeh, iwa n tlamachtijkeh de intlanawatil non nechtlajtlakoltiskeh para manechmiktikah. ");
INSERT INTO nplNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nechtemaktiskeh inmak n tlakah non amo judíojteh para manechpijpinawikah iwa manechwitekikah. Yejwah nechmiktiskeh itech krus, pero ipan eyi tonati nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ijkuakó isiwa n Zebedeo iwa itelpochwah, omijkuanijkeh ixpa Jesús iwa omotlankuaketskeh. N siwatl omotlatlaujti inawak. ");
INSERT INTO nplNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús okitlajtlani: —¿Tlan tikmonekiltia? N tena okili: —Nimitstlatlaujtia xitlanawati ninteh ome nopilwah mamoyayantikah monakastla, se ik moyekma iwa ok se kan ik moopochma, keman tejwatsi pewas titlanawatis. ");
INSERT INTO nplNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús okinankili: —Nomejwah amo nonkimatih tlan nonkitlajtlanih. ¿Weletis nontlaijyowiskeh kemi ne nitlaijyowis? Yejwah okinankilijkeh: —Ejé, tiweletiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús okinmili: —Milák, nomejwah nontlaijyowiskeh, pero sanwel Notajtsi weletis kijtos akin moyayantis ik noyekma noso noopochma, iwa amo Ne. Porke Ye yokimpéjpenki akimeh ompa moyayantiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ijkuak n májtlakteh itlamachtijkawah ijkó okikakeh, okualankeh iwan nonteh ome iknimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús okínnotski iwa okinmili: —Nomejwah kuali nonkinmatih n tekiwajkeh non tlanawatiah itech nin tlaltíkpaktli, kinnawatiah n tlakah, iwa n wejweyi tlanawatijkeh kinmapixtokeh ika intlanawatilis. ");
INSERT INTO nplNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero nomejwah amo ijkó nonkichiwaskeh. Akin kinekis nomowa moweyijkatlalis, achto makintekitili oksikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Akin kinekis tlayakantos, achto mamochiwa nomotlakewal. ");
INSERT INTO nplNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ijkó kemi Ne Non onimochi ni tlakatl amo oniwala manechtekitilikah, yej oniwala onitekitiko iwa nimotemakas manechmiktikah iwa ijkó miakeh mamomakixtikah. ");
INSERT INTO nplNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ijkuak yejwah yokistiayah de Jericó, miakeh tlakah oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Itempa n ojtli oewatokah ome tlakah non amo otlachiayah. Ijkuak yejwah okikakeh Jesús ik ompa opanotiaya, okitsajtsilijkeh chikawak: —¡Tejwatsi, ikone n David, techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","N tlakah okoninmajwayah pero yejwah okachi otsajtsiah: —¡Tejwatsi, ikone n David, techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ijkuakó Jesús omóketski, okínnotski n tlakah non amo otlachiayah iwa okintlajtlani: —¿Tlan nonkinekih manomechchiwili? ");
INSERT INTO nplNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yejwah okilijkeh: —Tejwatsi, tiknekih titlachiaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús okinmiknoma, iwa okintelkoli inmixtololowah. San nima owaltlachixkeh, iwa okitokakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ijkuak ya onkalakiah Jerusalén, okalakitoh kan altepetl de Betfagé, non kajki inakastla n olivostepetl. Jesús okintítlanki ome itlamachtijkawah, ");
INSERT INTO nplNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iwa okinmili: —Xiwiah kan neká altepetl non kajki tlayakapa. Ompa nonkajsitiweh se burra ilpitok iwa ikonetsi. Xikintojtomakah iwa techalinwikilikah. ");
INSERT INTO nplNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Iwa tla aka nomechtlajtlania tleka nonkintojtomah, xikilikah Toteko Jesús kintekitiltis, iwa san nima kintekopilis. ");
INSERT INTO nplNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ijkó otlamochi para mamochiwa tlan okijto n profeta Zacarías: ");
INSERT INTO nplNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xikinmilikah n tlakah de Sión: “Xikitakah, Nomorey wits nomonawak, yolyámanki, iwa tlejkotiwits ipan se burrojtsi, ikonetsi se yolkatl non tlamama.” ");
INSERT INTO nplNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ijkuakó itlamachtijkawah oyajkeh iwa okichijkeh kemi Jesús okinnawati. ");
INSERT INTO nplNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Okualikakeh n burra iwa ikonetsi, iwa ika intlakenwah okipejpechtijkeh. Iwa Jesús otlejkok ipan burrojtsi. ");
INSERT INTO nplNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iwa miakeh tlakah oyayah iwan Jesús, okinsoayah intlakenwah itech ojtli. Oksikimeh okintekiah imamayowah n kuameh iwa okinsoayah itech ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","N tlakah non otlayakanayah, iwa non oyayah tlakuitlapa otsajtsitiayah chikawak: —¡Hosanna! ¡Matechmakixti ikone n rey David! ¡Tiochitok akin wits itech Itoka n Toteko Dios! ¡Hosanna kan ilwikak! ");
INSERT INTO nplNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ijkuak Jesús okalak Jerusalén, nochteh n tlakah omopajsolojkeh, iwa okijtoayah: —¿Akin nin tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iwa n tlakah okijtoayah: —Ye n profeta Jesús, non de Nazaret de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús okalak kan Weyi Tiopa iwa okinkixti nochteh non otlakojtokah iwa non otlanamakatokah. Okinxitronkopili inmesajwah non okipatlayah tomi, iwa non okinnamakayah palomajtsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iwa okinmili: —Itech itlajkuilol Dios kijtoa: “Nocha kinotsaskeh kali kan motiotsajtsiliah.” 'Pero nomejwah yononkikopkeh se kali kan motlaatiah ichtekeh. ");
INSERT INTO nplNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kan Weyi Tiopa omijkuanijkeh inawak non amo otlachiayah iwa non amo oweletiah onejnemiah, iwa Jesús okimpajti. ");
INSERT INTO nplNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero ijkuak n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatili, okimitakeh n milagros non okinchiwaya Jesús, iwa okinkakeh otsajtsiah n chochokomeh: “¡Hosanna ikone n David!”, okualankamikeh. ");
INSERT INTO nplNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iwa okilijkeh n Jesús: —¿Tikkaki tlan kijtoah ninteh? Jesús okinnankili: —Ejé, nikinkaki, pero ¿mach ayamó nonkiamapoah itlajkuilol Dios kan kijtoa? Otikchi mamitsweyilikah n pípilteh, iwa n kokoneh non ok chichih. ");
INSERT INTO nplNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ijkuakó Jesús okiski de Jerusalén iwa oyá kan altepetl de Betania iwa ompa omoka non yúali. ");
INSERT INTO nplNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kuinal, ijkuak otlejkoaya Jerusalén, owalxitlatlak. ");
INSERT INTO nplNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ijkuakó okitak se igoskuawitl non okatka iselti itempa n ojtli, Ye okitlatemolito pero amo okajsik nion se igos, yej san tekil omoxiujyoti. Ijkuakó Jesús okili n igoskuawitl: —¡Ayik xiktemaka igos! Iwa n igoskuawitl sa nima owaki. ");
INSERT INTO nplNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ijkuak itlamachtijkawah okitakeh, omotlajtlachialtijkeh iwa okitlajtlanijkeh n Jesús: —¿Kenomi n igoskuawitl sa nima owaki? ");
INSERT INTO nplNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús okinnankili: —De milajka nomechilia, tla nonkipiah tlaneltokálistli, amo sanwel nonkichiwaskeh ijkó, yej noiwa weletis nonkiliskeh nin tepetl: “Ximoachiwa iwa ximotlamotlati ijtik weyi atl”, iwa ijkó tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Iwa nochi tlan nonkitlajtlaniliskeh itech nomotiotsajtsilis, nonkiseliskeh tla nonkineltokah ijkó mochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ijkuakó Jesús okalakito kan Weyi Tiopa de Jerusalén iwa ijkuak otlamachtijtoka, owalmijkuanijkeh inawak sikimeh tiopixkeh non tlayakantokeh iwa sikimeh tetajmeh non tlayakantokeh kan Weyi Tiopa iwa okitlajtlanijkeh: —¿Akin omitstekiwajtlali? ");
INSERT INTO nplNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús okinnankili: —Ne noiwa nomechtlajtlanis, iwa tla nonnechnankiliskeh, ijkuakó Ne noiwa nomechilis akin onechtekiwajtlali. ");
INSERT INTO nplNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Techilikah, ¿akin okinawati n Juan matlakuaateki? ¿Okinawati Dios noso okinawatijkeh n tlakah? Ijkuakó yejwah opé moichtakatlatlapowiah: —Tla tikijtoskeh Dios okinawati, Ye techilis: “¿Tleka kiné amo ononkineltokakeh?” ");
INSERT INTO nplNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iwa tla tikijtoskeh san tlakah okinawatijkeh, matikinmawilikah n tlakah, porke nochteh kimatokeh Juan se profeta. ");
INSERT INTO nplNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iwa okinankilijkeh n Jesús: —Mach tikmatih. Jesús noiwa okinnankili: —Ne noiwa mach nomechilis akin onechnawati ijkó manikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús okinmili: —Kenomi nonkitah. Se tlakatl okimpiaya ome itelpochwah, iwa se okili: “Nokone, xitekititi kan uvaskuajyo.” ");
INSERT INTO nplNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Itelpoch okinankili: “¡Amo nias!” Pero satepa omoyolkopki iwa oyá. ");
INSERT INTO nplNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Otlanki n teta noiwa okinawati non ok se itelpoch, iwa ye okinankili: “Ejé, nias.” Pero mach oyá. ");
INSERT INTO nplNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Akin okichi tlan okinekia n teta? Nochteh okijtojkeh: —Non okitlakitak. Ijkuakó Jesús okinmili: —De milajka nomechilia n tominoololojkeh iwa n awilsiwameh, yejwah achto kalakiskeh kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porke Juan Bautista owala onomechmachtiko kenijki kineki xinemikah Totajtsi Dios, iwa nomejwah amo ononkineltokakeh. Pero n tominoololojkeh non achto otlachtekiah iwa n awilsiwameh okineltokakeh. Iwa maya ijkó ononkitakeh, nomejwah amo ononmoyolpatlakeh nion satepa ononkineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","'Xikkakikah ok se tlapoálistli: Se tekowa okintookak uvas itech itlala iwa nochi okikorralti. Okichijchi se atékochtli kan kimpatskas n uvas, noiwa okichijchi se torre wejkapa kan tlejkos iwa kimokuitlawis iuvaskuajyo. 'Satepa okinkajtewili sikimeh impartidariojwah iwa oyá wejka. ");
INSERT INTO nplNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ijkuak oajsiko n tonati para motlatekis, okintítlanki sikimeh itlakawah para makikuitih tlan ye iaxka. ");
INSERT INTO nplNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero impartidariojwah okinmokitskilijkeh itlakawah n tekowa. Se de yejwah okiwitekeh, ok se okimiktijkeh iwa ok se okimojmotlakeh ika tetl. ");
INSERT INTO nplNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Satepa n tekowa okintítlanki okachi miakeh itlakawah, pero n partidarios noiwa ijkó okintoktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Sa iksemi, okintitlanili ipiltsi iwa okimoli: “Nopiltsi moneki kitlakitaskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ijkuak n partidarios okitakeh ipiltsi n tekowa okimolijkeh: “Ye ni akin kimokawis tlan iaxka ita, matikmiktikah iwa tikmokawiskeh tlan kiaxkatiskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Iwa n partidarios okikitskijkeh ipiltsi n tekowa, okwalkixtijkeh de itlal iwa okimiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ijkuak wits n tekowa de non uvas, ¿tlan kintoktis nonteh partidarios? ");
INSERT INTO nplNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yejwah okinankilijkeh: —Kinmijmiktis nonteh amo kualteh partidarios, iwa ilawerta kinmaktilis oksikimeh partidarios non kiyekmakaskeh tlan iaxka ijkuak motekis n uvas. ");
INSERT INTO nplNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús okinmili: —¿Ayamó nonkiamapoah itlajkuilol Dios kan kijtoa?: N tetl non kalchijchijkeh ik nepa lado okitlakaltechojkeh, yomókopki non okachi tetlakxilia. Ijkó okichi Toteko, iwa techtlajtlachialtia. ");
INSERT INTO nplNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'Yika, ayakmó nonkalakiskeh kan Dios tlanawatia, yej axa kinkawiliskeh makalakikah non de wejka nonkichiwah tlan kimonekiltia Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Akin wetsis ipan nin tetl mopopostekis, pero tla n tetl wetsis ipan se, san semi kikuejkuechos. ");
INSERT INTO nplNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ijkuak n tiopixkeh non tlayakantokeh iwa n fariseos okinkakeh ninteh tlapoálisteh, okajsikamatkeh yejwah okinmilijtoka. ");
INSERT INTO nplNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ijkuakó okinekiah kikitskiskeh n Jesús, pero okinmawiliayah n tlakah, porke n tlakah okineltokayah Jesús Ye profeta. ");
INSERT INTO nplNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús oksepa opé kintlapowia ika tlapoálistli iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Itech ilwikak kan Dios tlanawatia, noiwa kemi tlan okichi se rey itech se ilwitl ijkuak okinamikti itelpoch. ");
INSERT INTO nplNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","N rey okintítlanki itlakawah makinnotsatih itlatlalwilwah, pero yejwah mach okinekeh oyajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Oksepa okintítlanki oksikimeh itlakawah iwa okinnawati: “Xikinmilikah notlatlalwilwah ya kajki n tlákuali. Yonikinmikti notorojwah iwa oksikimeh noyolkawah non okachi tojtomawakeh, iwa yotlatetekakeh, sa mawalmuikakah nika itech ilwitl.” ");
INSERT INTO nplNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero yejwah mach owalajkeh. Se otekitito itlala, ok se otlasemanato. ");
INSERT INTO nplNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iwa oksikimeh okinkitskijkeh itlakawah n rey, okinwitekeh iwa okinmiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ijkuakó n rey sa tlawel okuálanki, iwa okinnawati isoldadojwah makinmijmiktitih nekateh temiktijkeh iwa makinchichinilikah inmaltépeu. ");
INSERT INTO nplNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Otlanki okinmili itlakawah: “Nochi ya kajki, pero notlatlalwilwah non achto onikintlalwi amo yejwah walaskiah. ");
INSERT INTO nplNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xiwiah itech ojtli iwa xikintlalwikah nochteh akimeh nonkinmajsiskeh, iwa mawikih nika itech ilwitl.” ");
INSERT INTO nplNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Itlakawah n rey okinmoololojkeh nochteh n tlakah non okinmajsikeh itech ojtli, non kualteh iwa non amo kualteh. Ijkó nochi n kali kan monamiktilo otenki. ");
INSERT INTO nplNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'Ijkuakó n rey okinmitato non otlakuajtokah. Okitak se tlakatl non amo otlakentitoka kemi omonekia matlakentito itech non ilwitl. ");
INSERT INTO nplNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iwa n rey okitlajtlani: “Noknitsi, ¿kenijki otikalak iwa amo titlakentitiwits kemi moneki itech nin ilwitl?” Pero n tlakatl amo otlanankili. ");
INSERT INTO nplNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ijkuakó n rey okinmili n tetlamakakeh: “Xikijilpikah iwa xikontlamotlakah kan tleyua, ompa chokas iwa tlannetsonis.” ");
INSERT INTO nplNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porke Dios kinnotsa miakeh tlakah, pero san sikimeh kimpejpenah. ");
INSERT INTO nplNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ijkuakó n fariseos oyayajkeh iwa omotlatlalwitoh kenijki kichiwaskeh mamotlapololti itech tlan kijtoa n Jesús iwa ijkó weletis kiteiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yika n fariseos okintitlankeh itlamachtijkawah iwa sikimeh non omowikayah iwan Herodes para makilitih: —Tlamachti, tikmatokeh Tejwatsi tiktemachtia tlan milák, iwa titlamachtia kenomi moneki se yetos kemi Dios kineki. Amo timotlachilia nion mitstekipachoa mamitskakikah. ");
INSERT INTO nplNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Techonili: ¿Kox kuali se kitlaxtlawilis impuesto para n weyi tlanawati César, noso amó? ");
INSERT INTO nplNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús okimatiah san okiyejyekojtokah iwa okinmili: —Íxkopteh, ¿tleka nonnechyejyekoah? ");
INSERT INTO nplNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Techititikah se tomi non ika nonkitlaxtlawah impuesto. Yejwah okititijkeh se denario. ");
INSERT INTO nplNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iwa Ye okintlajtlani: —¿De akin ixko iwa tlan ijkuilitok? ");
INSERT INTO nplNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yejwah okinankilijkeh: —De César. Ijkuakó Jesús okinmili: —Xikmakakah n César tlan iaxka n César, iwa xikmakakah Dios tlan iaxka Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ijkuak okikakeh tlan okinmili, omotlajtlachialtijkeh. Ayakmitla okilijkeh iwa oyayajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Non tonati sikimeh saduseos non kijtoah ke non yomikkeh ayakmó moyolitiah, omijkuanijkeh inawak Jesús iwa okitlajtlanijkeh: ");
INSERT INTO nplNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tlamachti, Moisés okijto tla se tlakatl mikki iwa amo kinkajtewa ipilwah iwan isiwa, n teikni moneki monamiktis iwan iknosiwatl iwa ijkó ijkuak kimpiaskeh impilwah, yetoskeh inmaxka non yomikki. ");
INSERT INTO nplNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Towah ochanchiwayah chikome iknimeh tlakah. Non teteachka omonamikti iwa omikki. Kemi amo okimpixkeh impilwah, okika isiwa, iwa ok se ikni non kualtoka omonamikti iwan iknosiwatl. ");
INSERT INTO nplNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero ye noiwa omikki, iwa non ipan eyi iknimeh noiwa omonamikti iwan iknosiwatl, pero noiwa omikki. Ijkó n chikomeh iknimeh omonamiktijtiajkeh iwan non siwatl, pero nochteh omiktiajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sa iksemi noiwa omikki n siwatl. ");
INSERT INTO nplNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Axa, keman moyolitiskeh non yomikkeh, ¿de akin yetos tesiwa, tla iwa n chikome iknimeh omonamikti? ");
INSERT INTO nplNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús okinmili: —Nomejwah nonmotlapololtijtokeh porke amo nonkajsikamatih itlajkuilol Dios nion iweletilis. ");
INSERT INTO nplNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ijkuak moyolitiskeh, n tlakah iwa n siwameh mach ok monamiktiskeh, porke yetoskeh kemi iangelwah Dios ompa ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero ken ya timotlapowijtokeh moyolitiskeh n mikemeh, ¿mach ayamó nonkiamapoah tlan Dios onomechili? Ye okijto: ");
INSERT INTO nplNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ne Dios de Abraham, Dios de Isaac iwa Dios de Jacob.” Ye amo Dios de non yomikkeh, Ye Dios de akimeh yolitokeh. ");
INSERT INTO nplNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ijkuak nochteh okikakeh, omotlajtlachialtijkeh de kenomi okinmachtiaya. ");
INSERT INTO nplNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","N fariseos omoololojkeh ijkuak okimatkeh n Jesús okinkamatsak n saduceos. ");
INSERT INTO nplNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Seme de yejwah non okitemachtiaya n tlanawátili okinekia kiyejyekos n Jesús iwa okitlajtlani: ");
INSERT INTO nplNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tlamachti, ¿katlie tlanawátili okachi weyi kijtosneki? ");
INSERT INTO nplNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús okili: —“Xiktlasojtla Moteko Dios ika nochi moyolo, ika nochi moalma iwa ika nochi motlalnamikilis.” ");
INSERT INTO nplNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ye nin tlanawátili non okachi tlayakantok iwa okachi weyi kijtosneki. ");
INSERT INTO nplNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iwa onka ok se tlanawátili non kimoiknitia iwa kijtoa: “Xiktlasojtla mokni kemi te timotlasojtla.” ");
INSERT INTO nplNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ninteh ome tlanawátilteh kitlakxiliah itlanawatil Moisés iwa intlamachtilis n profetas. ");
INSERT INTO nplNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ijkuak n fariseos ok omoololojkeh, ");
INSERT INTO nplNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús okintlajtlani: —¿Tlan nonkimatih de Cristo? ¿Cristo akin ikone? ¿Akin ita Cristo? Yejwah okilijkeh: —Walewatok de n rey David. ");
INSERT INTO nplNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ye okinmili: —Tla ijkó, ¿kenijki David por n Espíritu okínotski Noteko? Porke n rey David okijto: ");
INSERT INTO nplNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Toteko Dios okili Noteko: “Ximotlali noyekma, asta manikintlali akimeh mitskokoliah itlampa mokxiwah.” ");
INSERT INTO nplNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tla inewia David kinotsa Noteko n Cristo, ¿kenomi Cristo weletis yetos ikone n David? ");
INSERT INTO nplNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iwa amaka owéletki okinankili nion se tlájtoli, iwa desde non tonati, mach ok aka omixewi itla okitlajtlani. ");
INSERT INTO nplNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ijkuakó Jesús okinmili n tlakah iwa itlamachtijkawah: ");
INSERT INTO nplNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Non kitemachtiah n tlanawátili iwa n fariseos kimoliah san yejwah weleti kajsikamatih tlan kijtoa itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ijkó kiné, xikchiwakah nochi tlan nomechmachtiah, pero amo xikchiwakah tlan yejwah kichiwah. Porke yejwah mach kichiwah tlan kitemachtiah. ");
INSERT INTO nplNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yejwah kinmamaltiliah n tlakah miakeh tlanawátilteh non satlawel owijkeh non yejwah okajxitilijkeh. Iwa kintoktiah n tlakah makimamajtiwiah, pero yejwah nion ika se inmajpil kinekih kinwikaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Teixpa kichiwah tlan kuali san para makinmitakah n tlakah. Iwa ijtik sikimeh kajajtsitsinteh okinwikayah n májtlaktli tlanawatilteh (diez mandamientos) iwa okinmopililtiliayah itech inmixkuak iwa itech inmawah. Noiwa okiwilitayah motlakentiskeh ika intlakeh weyak. ");
INSERT INTO nplNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kimpaktiah moyayantiskeh tlayakapa kan tlatlakualo, noiwa kan sinagogas kiwilitah moyayantiskeh kan nochteh makinmitakah. ");
INSERT INTO nplNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kinekih makinyektlajpalokah iwa makinnotsakah “tlamachtijkeh” itech ojtli iwa itech tiánkistli. ");
INSERT INTO nplNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Pero nomejwah amo xikmokawilikah manomechnotsakah tlamachti, porke non nochteh nonmiknimeh iwa nonkipiah san se Nomotlamachti. ");
INSERT INTO nplNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iwa amaka xikilikah padre itech nin tlaltíkpaktli, porke nonkipiah san se Padre non kajki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nion xikmokawilikah manomechnotsakah “tlayakankeh”, porke sanwel Cristo nomechyakana. ");
INSERT INTO nplNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Akin kinekis tlayakantos nomonawak, achto manomechtekichiwili. ");
INSERT INTO nplNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porke akin inewia moweyilia, satepa moiknomatinemis, pero akin amo moweyilia, kiweyijkatlaliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","'¡Miálmasteh, tlamachtijkeh iwa fariseos, íxkopteh!, porke nonkintsakuiliah n tlakah para amo makalakikah itech ilwikak kan Dios tlanawatia. Nomejwah amo nonkalakih nion nonkinkawiliah makalakikah akimeh kinekih kalakiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","'¡Miálmasteh tlamachtijkeh iwa fariseos, íxkopteh! Nomejwah non nentinemih itech nochi n tlaltíkpaktli para aka nonkichiwaltiskeh makitlakita nomotlamachtilis, iwa ijkuak yononkimotlanilijkeh, nonkikopah ome welta okachi amokuali ke nomejwah iwa ijkó makimotlanili n miktla. ");
INSERT INTO nplNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","'¡Miálmasteh, tlayakankeh ixpojpóyakteh! Nomejwah nonkijtoah: “Akin motlajtolsentlalia por n Weyi Tiopa amitla ipati, pero tla motlajtolsentlalia por n ‘oro’ non kajki itech Weyi Tiopa, moneki makichiwa tlan yokijto.” ");
INSERT INTO nplNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tsontewewemeh ixpojpóyakteh! ¿Tlan okachi ipati: N oro, noso n Weyi Tiopa, non kitiochiwa n oro? ");
INSERT INTO nplNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Noiwa nonkijtoah: “Akin motlajtolsentlalia por n artal, amitla ipati, pero tla motlajtolsentlalia por n tlamánali non kajki ipan artal, moneki makichiwa tlan yokijto.” ");
INSERT INTO nplNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tsontewewemeh ixpojpóyakteh! ¿Tlan okachi ipati, n tlamánali non kajki ipan artal, noso n artal non kitiochiwa n tlamánali? ");
INSERT INTO nplNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Akin motlajtolsentlalia por n artal, noiwa motlajtolsentlalia por nochi tlan kajki itech. ");
INSERT INTO nplNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iwa akin motlajtolsentlalia por n Weyi Tiopa, noiwa motlajtolsentlalia por Akin chantitok itech. ");
INSERT INTO nplNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Iwa akin motlajtolsentlalia por n ilwikak, motlajtolsentlalia por iyayan Totajtsi Dios, iwa por Akin ewatok itech. ");
INSERT INTO nplNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","'¡Miálmasteh, tlamachtijkeh iwa fariseos, íxkopteh! Nomejwah nonkiaxkatiliah Dios nomodiesmo de nomomenta, nomoanis iwa nomokomino, pero mach nonkichiwah tlan okachi weyi kijtosneki inawak Dios, kemi xiyeknemikah, xiteiknomatikah iwa xikneltokakah Dios. Ye ni tlan moneki nonkichiwaskeh, pero tlan nonkitemakatiwitseh ijkó xiktemakatiwiah. ");
INSERT INTO nplNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Teyakankeh ixpojpóyakteh, nomejwah nonkitsejtseloah n atl para makitseko n moyotl pero nonkitoloah se kameyo! ");
INSERT INTO nplNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","'¡Miálmasteh, tlamachtijkeh iwa fariseos, íxkopteh!, porke nonkipopoah san ixko nomovaso iwa nomoplato, pero ik tlaijtik tentokeh ika tlan amokuali, ika tlachtekílistli iwa n tominápistli. ");
INSERT INTO nplNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo ixpojpóyaktli, achto xikijtipopoa n vaso iwa n plato, ijkó noiwa mochipawas kala. ");
INSERT INTO nplNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","'¡Miálmasteh, tlamachtijkeh iwa fariseos, íxkopteh!, porke nomejwah kemi miketékochteh non kinmistayaliah pero ik tlaijtik tentokeh ika iomiowah n miketl iwa nochi tlan yoijtlakawik. ");
INSERT INTO nplNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ijkó nomejwah inyakapah n tlakah nonmotah nonyekmilajkameh, pero ijtik nomoyolo non íxkopteh iwa non pitsotikeh. ");
INSERT INTO nplNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","'¡Miálmasteh, tlamachtijkeh iwa fariseos íxkopteh!, nomejwah nonkinchijchiwiliah intekoch n profetas iwa nontlayekmajmanah kan tooktokeh n kualteh tlakah non yomikkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iwa nonkijtoah: “Tla tejwah tiyetoskiah ijkuak onemiah totatawah, amo tikimpalewiskiah makinmiktikah n profetas.” ");
INSERT INTO nplNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ika tlan nonkijtoah, nomonewiah nonkinextiah nontepilwah de akimeh okinmiktijkeh n profetas. ");
INSERT INTO nplNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Iwa axa sa poliwi xikyakatlamikah tlan okipewaltijkeh nomotatawah! ");
INSERT INTO nplNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'¡Koameh! ¡Nomejwah ken tlilkoameh! ¿Kenijki nonkicholiliskeh nomotlaxtlawil non nomechmakaskeh miktla? ");
INSERT INTO nplNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yika, Ne nikintitlanis, profetas, ixtlamatkeh iwa tlamachtijkeh. Pero nomejwah sikimeh nonkinmiktiskeh iwa nonkinkrusifikaroskeh, iwa oksikimeh nonkinwitekiskeh kan nomosinagogas iwa nonkintotojtokatinemiskeh itech se noso ok se altepetl. ");
INSERT INTO nplNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yika, nomechtlajtlakoltiskeh de inmikilis nochteh n tlakah yolchipawakeh, desde Abel asta Zacarías ikone n Berequías, akin nomejwah ononkimiktijkeh itlajkotia n Weyi Tiopa iwa n artal. ");
INSERT INTO nplNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","De milajka nomechilia, nochi nin tlaijyowílistli wetsiki itech ninteh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","'¡Jerusalén, Jerusalén, te tikinmiktia n profetas iwa tikinmojmotla ika tetl non kintitlani Dios! ¡Miak welta oniknekia nikinmoololos mopilwah kemi n siwapio kinmoololoa ipiotsitsiwah itlampa iajaswah, pero amo otiknek! ");
INSERT INTO nplNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yika, axa nomo Weyi Tiopa mokawas saijki iwa iselti. ");
INSERT INTO nplNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Porke ayakmó nonnechitaskeh asta maajsiki n tonati ijkuak nonkijtoskeh: “Matiochito Akin wits itech Itoka n Toteko Dios.” ");
INSERT INTO nplNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ijkuak Jesús okiski de kan Weyi Tiopa, itlamachtijkawah omijkuanijkeh inawak iwa opé kiititiah kenomi omajmantoka n Weyi Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús okinmili: —¿Nonkitah nochi ni? De milajka nomechilia, mach ok mokawas nion se tetl ipan ok se tetl. Nochi kixixititsaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ijkuak Jesús oewatoka kan Olivostepetl, itlamachtijkawah omijkuanijkeh inawak iwa okitlajtlanijkeh: —Techili, ¿kemania ijkó tlamochiwas, iwa tlan monextis ijkuak ya tiwalmuikas iwa kemania ya tlajtlamis nin tlaltíkpaktli? ");
INSERT INTO nplNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús okinnankili: —Ximotlachilikah, amaka manomechkajkayawa, ");
INSERT INTO nplNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","porke miakeh witseh itech Notoka iwa kijtoskeh: “Ne Ni Cristo”, iwa miakeh kinkajkayawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nomejwah nonkikakiskeh onka guerra iwa motlapowiskeh yetos guerra. Pero amo ximomojtikah, porke ijkó tlamochiwas, pero ayamó tlamis n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Porke se país momakas iwa n ok se, iwa se altepetl momakas iwa n ok se. Yetos apisotl, iwa sentetl tlalolinis. ");
INSERT INTO nplNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero ijkuak ijkó tlamochiwas, sikin pewa n tlaijyowílistli. ");
INSERT INTO nplNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","'Ijkuakó nomechtemaktiskeh para manomechtlaijyowiltikah iwa nomechmiktiskeh. Nochteh n tlaltikpaktlakah nomechkokoliskeh por nonnechneltokah. ");
INSERT INTO nplNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ijkuakó miakeh ayakmó kineltokaskeh Dios, mokokoliskeh iwa motejtemaktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Monextiskeh miakeh profetas tekajkayajkeh iwa miakeh kinkajkayawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Momiakilis n tlajtlákoli, yika miakeh ayakmó tetlasojtlaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero akin nochi kixikos, momakixtis. ");
INSERT INTO nplNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iwa ijkuak nin kualitlájtoli non techilia kenomi Dios tlanawatia, motetlapowis itech nochi n tlaltíkpaktli para nochteh makimatikah. Iwa ijkuakó, tlamis n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","'Ijkuak nomejwah nonkitaskeh tlan pitsotik moketos kan Weyi Tiopa. Makajsikamati akin kiamapoa tlan okijkuilo n profeta Daniel, —akin kikaki makajsikamati—, ");
INSERT INTO nplNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","akimeh yetoskeh kan tlali de Judea, macholojtiwetsikah kan tepemeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Akin yetos ikpak ikal, amo mawaltemo makikixtiki itla, ");
INSERT INTO nplNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","iwa akin yetos itlala amo mawalmokopa icha makikuiki ikoto. ");
INSERT INTO nplNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Miálmasteh n siwameh non itech non ora makichixtokah konetl noso matlachichitijtokah! ");
INSERT INTO nplNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ximotiotsajtsilikah tla noncholoskeh, amo mayeto itech sewaya nion itech sábado, ");
INSERT INTO nplNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","porke n tlaijyowílistli yetos satlawel temojti non ayamaka ijkó okitak desde ijkuak omonexti n tlaltíkpaktli, iwa ayik oksepa ijkó tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iwa tla nonteh tonatijmeh amo motsikitsintiliskiah, amaka yolitoskia, pero Dios kintsikitsintilis nonteh tonatijmeh por akimeh Ye yokinmopejpeni. ");
INSERT INTO nplNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","'Ijkuakó tla se nomechilis: “Xikitakah, nika kajki n Cristo” noso, “nepa” amo xikneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porke monextiskeh cristos iwa profetas tekajkayajkeh, iwa kinchiwaskeh wejweyi señales iwa milagros non ayik motikateh, kinkajkayawaskeh n tlakah iwa kinekiskiah asta akimeh Dios yokimpéjpenki. ");
INSERT INTO nplNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xikilnamikikah tlan Ne yonomechmatiltijka. ");
INSERT INTO nplNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yika, tla se nomechilia: “Xikitakah nepa ka kan tlaltejtéyinki”, amo xiwiah, noso: “Xikitakah, nepa tlaatitok”, amo xikneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porke ijkó kemi ijkuak tlamijmilini mota kan ik kisa tonati asta kan kalaki tonati, ijkó tlamochiwas ijkuak niwalmokopas Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Iwa san kan ik yetos n miketl ompa moololoskeh n tsojpilomeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","'Sa nima ijkuak yopanokeh nonteh tonatijmeh de tlaijyowílistli temojti, n tonati walsewis, n metsi ayakmó tlawis. N sítlalteh wetsiskeh, iwa n chikawálistli non kajki ilwikak bibiokas. ");
INSERT INTO nplNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ijkuakó motas itech ilwikak noneskayo Ne Non onimochi nitlakatl. Iwa nochteh n tlaltikpaktlakah mawiskeh. Iwa nechitaskeh Ne Non onimochi nitlakatl, niwits ipan mextli de ilwikak ika miak weletílistli iwa mawistílistli. ");
INSERT INTO nplNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iwa ijkuak kipitsaskeh n trompeta kintitlanis iangelwah iwa kinmoololos nochteh n tlakah non Ye yokinmopejpenili itech nochi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","'Xikkajsikamatikah tlan kijtosneki nin tlapoálistli: Ijkuak imamayowah n igoskuawitl seliah iwa pewa moxiujyotiah, nomejwah nonkimatokeh ya pewas n tonala. ");
INSERT INTO nplNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yika, ijkuak nochi ni nonkitaskeh, xikmatikah ya tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","De milajka nomechilia, nochi ni tlamochiwas achto de maixpoliwikah n tlakah non yolitokeh itech ninteh tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","N ilwikak iwa n tlaltíkpaktli pojpoliwiskeh, pero notlajtol mach pojpoliwis. ");
INSERT INTO nplNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","'Pero n tonati iwa n ora ijkuak ijkó tlamochiwas amaka kimati, nion ángelteh non kateh ilwikak, nion Ne, yej sanwel Notajtsi kimatok. ");
INSERT INTO nplNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","'Iwa ijkó kemi opanok ijkuak onemia n Noé, ijkó yetos noiwa ijkuak niwits Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Itech nekateh tonatijmeh ijkuak ayamó owalaya n chikawak kiawitl, n tlakah otlakuayah, okoniah, omonamiktiayah iwa okinmijtlaniah ichpokameh, asta n tonati ijkuak Noé okalak kan weyi arka. ");
INSERT INTO nplNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mach okajsikamatkeh asta ijkuak okinmajsiko non kiawitl temojti iwa nochteh okinwík. Ijkó noiwa tlamochiwas ijkuak niwalmuikas, Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Itech non tonati, ome tlakah yetoskeh intlala. Se kiwikaskeh iwa ok se kikajtewaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ome siwameh testoskeh. Se kiwikaskeh iwa ok se kikajtewaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'Xiijsatokah, porke amo nonkimatih kemania walmuikas Nomoteko. ");
INSERT INTO nplNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero xikkajsikamatikah tlan nomechilia: tla se chane kimatiskia tlan oras kalakiki n ichtek, ye ijsatoskia iwa amo kitekawiliskia aka makalaki icha para makitlachteki. ");
INSERT INTO nplNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ijkó nomejwah noiwa xiijsatokah, porke Ne Non onimochi ni tlakatl niwalkalakiki ijkuak nomejwah mach nonnechchiah. ");
INSERT INTO nplNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","'N tekowa kipejpena se tetlakéwali yekmilajka iwa tetlakitani, ye kinawatia makinmokuitlawi n oksikimeh tlakéwalteh iwa makintlakualti ipan ora. ");
INSERT INTO nplNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","¡Miak pakílistli kipia neká tlakéwale non iteko kualajsi kichijtok tlan okinawati! ");
INSERT INTO nplNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","De milajka nomechilia, iteko kitlalis makinawati nochi tlan kipia. ");
INSERT INTO nplNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero tla se amo kuali tetlakéwale, kimolia: “Noteko ok wejkawas”, ");
INSERT INTO nplNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","iwa pewa kintlaijyowiltia n tetlakéwalteh, iwa tlakuajtinemi iwa konitinemi iwan tlawankeh. ");
INSERT INTO nplNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ijkuak n tekowa walmokopa itech tonati ijkuak itlákau amo kichia, iwa itech se ora ijkuak ye amo kimati, ");
INSERT INTO nplNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kitlaijyowiltis chikawak iwa kititlanis kan kateh n íxkopteh. Ijkuakó chokas iwa tlannetsonis. ");
INSERT INTO nplNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","'Itech ilwikak kan Dios tlanawatia, ye kemi omochijkeh májtlakteh ichpokameh non okinmonankeh intlawilwah iwa okinamikitoh n novio. ");
INSERT INTO nplNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mákuili ichpokameh kuali intlalnamikilis iwa mákuili amó. ");
INSERT INTO nplNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Non amo tlalnamikilisejkeh, okinwikakeh intlawilwah pero mach okiwikakeh oksiki aseite. ");
INSERT INTO nplNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero n ichpokameh tlalnamikilisejkeh, ixkoya okiwikakeh oksiki aseite para intlawilwah. ");
INSERT INTO nplNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kemi n novio owejkawaya, nochteh n ichpokameh okinkitski kochílistli, iwa okochtlamilajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kemi ik tlajkoyuak aka owaltsajtsik: “¡Ompa wits n novio, xikonnamikitih!” ");
INSERT INTO nplNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ijkuakó nochteh n ichpokameh omejtewakeh iwa opé kinyektlaliah intlawilwah. ");
INSERT INTO nplNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iwa n mákuilteh ichpokameh non amo tlalnamikilisejkeh okinmilijkeh non tlalnamikilisejkeh: “Techonmakakah siki nomoaseite, porke totlawilwah ya sejseujtokeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero n ichpokameh non tlalnamikilisejkeh okinmilijkeh: “Amó, porke tla tomechmakaskeh, mach ok techajxilis nion nomejwah mach nomechajxilis. Okachi kuali xiwiah kan monamaka iwa xikmokowikah.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero ijkuak n mákuilteh okikoatoh inmaseite, n novio owalkalakiko. N ichpokameh non omotlatlalijkah okalakeh iwa n novio kan monamiktilo iwa owalmotsak n kaltentli. ");
INSERT INTO nplNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Satepa okalakikoh non amo tlalnamikilisejkeh iwa omotlatlautiayah: “¡Noteko, Noteko, techtlatlapoli!” ");
INSERT INTO nplNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero ye okinnankili: “De milajka nomechilia, ne amo nomechixmati.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ijkuakó Jesús okinmili: —Xiijsatokah nomejwah, porke amo nonkimatih tlan tonati nion tlan ora niajsiti. ");
INSERT INTO nplNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","'Itech ilwikak kan Dios tlanawatia, noiwa tlamochiwa kemi se tlakatl non ya onewaskia wejka. Okínnotski itlakawah iwa okinmajmakatewak itomi makitekitilikah. ");
INSERT INTO nplNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Seme de yejwah okimák mákuili sentenario, ok se okimák ome sentenario, iwa non ok se okimák san se sentenario. N tekowa okinmajmaktili itomi kemi ye okiyejyekoli weletis kitekitiltiskeh, iwa oonewak. ");
INSERT INTO nplNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Non okinseli mákuili sentenarios, opé tlasemana ika non tomi iwa okíntlanki ok mákuili sentenario. ");
INSERT INTO nplNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Noiwa non okimakakeh ome, okíntlanki ok ome sentenario. ");
INSERT INTO nplNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero non okimakakeh sanwel se sentenario, okitlalpacho iwa okitlaati n tomi non okimák iteko. ");
INSERT INTO nplNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","'Miakeh tonatijmeh satepa, omokopato inteko, iwa okintlajtlani itlakawah tlan okichijkeh ika itomi. ");
INSERT INTO nplNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Achto okalak non okiselijka mákuili sentenario, iwa okimaktili iteko ok mákuili sentenario iwa okili: “Noteko, tejwatsi otechmák mákuili sentenario, xikita onikíntlanki ok mákuili.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iteko okili: “Kuali otikchi, te kuali tlakéwale iwa titetlakitak. Te kuali otiktekitilti tlan san achitsi onimitsmák, ne nimitsmakas okachi miak. Axa, xikalaki iwa xiyolpaki nowa.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Noiwa omijkuani non okiselijka ome sentenario iwa okijto: “Noteko, tejwatsi otechmák ome sentenario, xikita onikíntlanki ok ome sentenario.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iteko okili: “Kuali otikchi, te kuali tlakéwale iwa titetlakitak. Te kuali otiktekitilti tlan san achitsi onimitsmák, ne nimitsmakas okachi miak. Axa, xikalaki iwa xiyolpaki nowa.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Omijkuani noiwa non okiseli sanwel se sentenario, iwa okili: “Noteko, nikmatok tikuejsi iwa tipixka kan amo titooka, iwa titlaoololoa kan amo otitlatepe. ");
INSERT INTO nplNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yika, onímaujki iwa oniktlalpacho motomi. Axa nika ka tlan moaxka.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iteko okinankili: “Amo tikuali tlakéwale iwa titlátsijki, kuali yotikmatoka nipixka kan amo nitooka, iwa nitlaoololoa kan amo nitlatepewa. ");
INSERT INTO nplNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Okachi kuali tikonkawaskia notomi kan banko, iwa ijkuak nimokopaskia, nikseliskia notomi ika ikoneyo. ");
INSERT INTO nplNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Xikkixtilikah n tomi, iwa xikmaktilikah non kimpia májtlaktli sentenario.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porke akin kipia, kimakaskeh okachi, iwa okachi kitlawelpias. Pero akin achitsi kipia, nochi kikixtiliskeh tlan san achitsi kipia. ");
INSERT INTO nplNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iwa nin tlakéwale non amitla iteki, xikixtikah kala kan tleyua. Ompa chokas iwa tlannetsonis. ");
INSERT INTO nplNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","'Ijkuak Ne Non onimochi ni tlakatl niwalmuikas ika nomawistilis iwan nochteh noangelwah, ijkuakó nimoyayantis ika nochi nomawistilis. ");
INSERT INTO nplNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iwa nochteh n tlaltikpaktlakah moololoskeh noyakapa, iwa Ne nikinxexelos ijkó kemi se tlájpixki kinxexeloa n ichkameh iwa n tentsomeh. ");
INSERT INTO nplNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nikintlalis n ichkameh ik noyekma iwa n tentsomeh ik noopochma. ");
INSERT INTO nplNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ijkuakó Ne n Rey nikinmilis non kateh ik noyekma: “Xiwikih nomejwah, non Notajtsi onomechtiochi. Xikselikah nochi tlan nomechaxkatiliskeh kan ilwikak non Dios onomechmajmanili desde ijkuak okichijchi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porke onixitlatlak iwa ononnechtlakualtijkeh, oniamijmik iwa ononnechatlitijkeh, iwa maya amo ononnechixmatiah, ononnechkalotijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Amo onikpiaya notlake iwa ononnechtlakentijkeh, onimokokoaya iwa ononnechtlajpalotoh. Ijkuak onitsaktoka, ononnechitatoh.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Ijkuakó tlanankiliskeh n yolmilajkameh iwa kijtoskeh: “Toteko, ¿kemania otimitsitakeh otixitlatlak iwa otimitstlakualtijkeh?, noso ¿otiamikkia iwa otimitsatlitijkeh? ");
INSERT INTO nplNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Noso ¿maya amo otimitsixmatiah, otimitskalotijkeh, noso amo otikpiaya tlan tikonakis iwa otimitstlakentijkeh? ");
INSERT INTO nplNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Noso, ¿kemania otimokokoaya, noso otitsaktoka iwa otimitsontlajpalotoh?” ");
INSERT INTO nplNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ijkuakó nikinnankilis: “De milajka nomechilia, ijkuak nomejwah ijkí ononkinchiwilijkeh nokniwah non okachi amitla impati, Ne ononnechchiwilijkeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","'Ijkuakó nikinmilis non kateh ik noopochma: “Ximoachiwakah nonawak, nomejwah amo nonkualteh, xiwiah ijtik tletl non ayik sewis, non Dios okichijchi para n diablo iwa iangelwah. ");
INSERT INTO nplNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porke onixitlatlak iwa amo ononnechtlakualtijkeh, oniamijmik iwa amo ononnechatlitijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Amo ononnechixmatiah iwa amo ononnechkalotijkeh, amo onikpiaya tlan nikonakis iwa mach ononnechtlakentijkeh, onimokokoaya iwa onitsaktoka iwa amo ononnechtlajpalotoh.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ijkuakó yejwah nechiliskeh: “Toteko, ¿kemania otimitsitakeh otixitlatlak noso otiamikia, noso amo otikpiaya kan timokalotis, noso amo otikpiaya motlake, noso otimokoko, noso otitsaktoka iwa amo otimitspalewijkeh?” ");
INSERT INTO nplNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ijkuakó nikinnankilis: “De milajka nomechilia, ijkuak nomejwah amo ononkinchiwilijkeh nokniwah non okachi amitla impati, Ne amo ononnechchiwilijkeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","'Ninteh kintitlaniskeh kan nochipa tlaijyowijtoskeh, iwa n yolmilajkameh yolitoskeh semijkak. ");
INSERT INTO nplNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ijkuak Jesús otlanki okintlapowi, okinmili itlamachtijkawah: ");
INSERT INTO nplNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Nomejwah ya nonkimatokeh, poliwi sa ome tonati pewas n ilwitl de Paskua. Ne Non onimochi ni tlakatl nechtemaktiskeh manechkrusifikarokah. ");
INSERT INTO nplNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ijkuakó n tiopixkeh non tlayakantokeh, non kitemachtiah n tlanawátili, iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa, omoololojkeh icha n Caifás. ");
INSERT INTO nplNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ompa omotlatlalwijkeh kenomi kitlajtlakolmamaltiskeh n Jesús iwa ijkó kikitskiskeh iwa kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Noiwa okimoliayah: —Amo tikkitskiskeh itech ilwitl de Paskua, porke san tikimpajsoloskeh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kan altepetl de Betania, Jesús okatka icha n Simón non achto okipiaya lepra. ");
INSERT INTO nplNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ijkuakó se siwatl okualikaya se itekontsi tentok ika ajwiálistli non satlawel patio. Omijkuani kan otlakuajtoka Jesús iwa okitekili ajwiálistli ipan itsonteko. ");
INSERT INTO nplNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ijkuak ijkó okitakeh itlamachtijkawah okualankeh iwa okijtojkeh: —¿Tleka san okawilti? ");
INSERT INTO nplNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Weletiskia monamakaskia patio, iwa n tomi tikinmakaskiah non próbesteh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús okinkak iwa okinmili: —Amo xikkuejsokah nin siwatl, ye okichi tlan kuali. ");
INSERT INTO nplNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","N próbesteh nochipa yetoskeh nomowah, pero Ne, amo nochipa nonnechpixtoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nin siwatl, ijkuak onechtlalili ajwiálistli itech nokuerpo, yotlayektlali para ijkuak nechtookaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","De milajka nomechilia, itech nochi n tlaltíkpaktli kan motetlapowis nin kualitlájtoli, noiwa motlapowiskeh tlan okichi nin siwatl, iwa ijkó se kilnamikis. ");
INSERT INTO nplNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ijkuakó Judas Iscariote seme de n májtlaktli iwa n ome itlamachtijkawah, oyá kan tiopixkeh non tlayakantokeh ");
INSERT INTO nplNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","iwa okinmili: —¿Kech nonnechmakaskeh tla nomechmaktilis n Jesús? Yejwah okitamachijkeh sempóali iwa n májtlaktli (30) platajtomi. ");
INSERT INTO nplNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ijkuakó, Judas Iscariote okitemoliaya kenomi kitemaktis Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Itech ipewaya n ilwitl de Paskua ijkuak mokua n paj non amo kipia levadura, itlamachtijkawah n Jesús omijkuanijkeh inawak, iwa okitlajtlanijkeh: —¿Kani tikmonekiltia matikchijchiwatih n tlákuali de Paskua? ");
INSERT INTO nplNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ye okinmili: —Xiwiah Jerusalén icha n se tlakatl iwa xikilikah: “N Tlamachti kijtoa: Noora ya walajsitiwits, iwa mocha nikmomajsewis n tlákuali de Paskua iwan notlamachtijkawah.” ");
INSERT INTO nplNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Itlamachtijkawah okichijkeh kemi Jesús okinnawati, iwa okimajmankeh n tlákuali de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ijkuak otleyuak, Jesús omotlali inakastla n mesa iwa n májtlaktli iwa ome itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ijkuak otlakuajtokah okinmili: —De milajka nomechilia, seme de nomejwah nechtemaktis. ");
INSERT INTO nplNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yejwah tlawel omoyolkokojkeh, iwa sejse opé kitlajtlania: —Noteko, ¿kox ne nimitstemaktis? ");
INSERT INTO nplNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús okinnankili: —Akin tlapaloa nowa, ye akin nechtemaktis. ");
INSERT INTO nplNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Milák, Ne Non onimochi ni tlakatl nikpia de nimochiwas kemi kijtoa itlajkuilol Dios, pero ¡mialma n tlakatl non nechtemaktis! Okachi kuali non tlakatl amo tlakatiskia. ");
INSERT INTO nplNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ijkuakó Judas non kitemaktiskia n Jesús okili: —Rabí, ¿kox ne nimitstemaktis? Jesús okinankili: —Te yotikijto. ");
INSERT INTO nplNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ijkuak otlakuajtokah, Jesús okónanki paj iwa omotlasojkama inawak Dios, iwa ijkuak yokitlajtlápanki, okinmák itlamachtijkawah iwa okinmili: —Xikmomajsewikah, ye nin nokuerpo. ");
INSERT INTO nplNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ijkuakó okónanki n kopa, iwa omotlasojkama inawak Dios. Okimpanoltili itlamachtijkawah iwa okinmili: —Nonnochteh xikonikah, ");
INSERT INTO nplNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ye nin noesso non ika nimotlajtolsenkawa nomowah, nin noesso motoyawas para miakeh makintlapojpolwilikah intlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","De milajka nomechilia: Ayakmó nikonis iayo n uvas, asta neká tonati ijkuak oksepa tikmosepanmajsewiskeh n yankuik vino, nepa ilwikak kan Notajtsi tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Satepa, ijkuak yotlankeh okitlakuikakeh se salmo oyájkeh kan Olivostepetl. ");
INSERT INTO nplNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ijkuakó Jesús okinmili: —Nin yúali nochteh nonkikawaskeh nomotlaneltokalis, porke itech itlajkuilol Dios ijkuilitok: “Nikmiktis n tlájpixki, iwa ichkameh moxexeloskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero keman nimoyolitis, Ne nitlayakanas Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ijkuakó Pedro okinankili: —Maya nochteh mamitspinawilikah ne amo nipinawas. ");
INSERT INTO nplNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ijkuakó Jesús okili: —De milajka nimitsilia, axa itech nin yúali achto de tlakuikas n kaxtil, te yotikijto eyi welta amo techixmati. ");
INSERT INTO nplNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro okijto: —Maya mowa manechmiktikah, amayik nikijtos amo nimitsixmati. Iwa nochteh itlamachtijkawah noiwa ijkó okijtojkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Satepa Jesús oyá iwan itlamachtijkawah kan se werto non itoka Getsemaní, iwa okinmili: —Nika ximotlajtlalikah, Ne nepa nio nimotiotsajtsiliti. ");
INSERT INTO nplNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iwa okiwík n Pedro, iwa itelpochwah n Zebedeo, Jacobo iwa n Juan iwa opé moyolkokoa iwa yoltelini. ");
INSERT INTO nplNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Iwa Jesús okinmili: —Satlawel nimoyolkokoa mach ok nikxikoa, nikmachilia kemi nimikis, nika ximokawakah xiijsatokah nowa. ");
INSERT INTO nplNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús oyá ok achitsi tlayakapa, ompa omotlankuáketski asta okitelko n tlali ika ixkuak iwa omotiotsajtsiliaya: —Notajtsi, tla weletis amo manitlaijyowi. Pero amo mamochiwa kemi Ne nikneki, yej kemi Tejwatsi tikmonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Satepa omókopki kan itlamachtijkawah, iwa okinmajsito kochtokeh, iwa okili n Pedro: —¿Nion se ora ononweletkeh ononmijsatokah nowa? ");
INSERT INTO nplNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xiijsatokah iwa ximotiotsajtsilikah, para amo xiwetsikah itech tlajtlákoli. De milajka nomechilia, nomoespíritu mochikajtok, pero nomokuerpo amo chikawak. ");
INSERT INTO nplNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús oksepa omotiotsajtsilito iwa okijto: —Notajtsi, tla weletis tikachiwas nin tlaijyowílistli xikachiwa, pero mamochiwa tlan Tejwatsi tikmonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ye oyá kan itlamachtijkawah, iwa okinmajsito kochtokeh porke satlawel okochmikiah iwa inmixtololowah omotsakuayah. ");
INSERT INTO nplNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ok se welta okinkajteh iwa oyá omotiotsajtsilito ya eyi welta, iwa oksepa omotiotsajtsili ijkó kemi achto. ");
INSERT INTO nplNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Otlanki okinmajsito itlamachtijkawah iwa okinmili: —Xikochikah iwa ximosewikah. Yoajsiko n ora, iwa Ne Non onimochi ni tlakatl nechtemaktiskeh inmak tlajtlakolejkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Ximewakah, tiawih! ¡Ompa wits akin nechtemaktis! ");
INSERT INTO nplNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ok otlajtojtoka ijkuak okalakiko n Judas, seme de itlamachtijkawah. Miakeh okinyakantiwalaya ika espadajteh iwa kuameh. Ninteh okwalintitlankeh n tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas non okitemakti n Jesús, yokinmilijka: —Akin ne nikixtennamikis, Ye n Jesús, ¡xikkitskikah! ");
INSERT INTO nplNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sannima omijkuani inawak Jesús iwa okili: —¡Panolti Rabí! Iwa okiixtennamik. ");
INSERT INTO nplNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús okinankili: —Noknitsi, xikchiwa tlan otikchiwako. Ijkuakó n tlakah omijkuanijkeh inawak Jesús iwa okikitskijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ijkuakó Pedro okwalkixti iespada iwa okinakastek itlákau n weyi tiópixki Caifás. ");
INSERT INTO nplNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ijkuakó Jesús okili: —Xiktlaati moespada, porke akimeh kiwikah iespada, noiwa ika espada kinmiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mach amo tikmati weletis niktlajtlanilis Notajtsi iwa axa Ye nechalintitlanilis eyipóali iwa n májtlaktli mil ángeles? ");
INSERT INTO nplNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tla ijkó, ¿kenomi mochiwas tlan ijkuilitok, kan kijtoa ijkó tlamochiwas? ");
INSERT INTO nplNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ijkuakó Jesús okinmili n tlakah: —¿Tleka ononnechkitskikoh ika espada iwa ika kuawitl kemi niyetoskia ni tlajtlakole? Nochi tonati onitlamachtiaya nomonawak kan Weyi Tiopa, iwa ayik ononnechkitskijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero nochi ni panoa para mamochiwa tlan okijtojkeh n profetas itech tiotlajkuíloli. Ijkuakó nochteh itlamachtijkawah n Jesús okikakajtejkeh iwa ochocholojkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Akimeh okikitskijkeh n Jesús okiwikakeh ixpa n weyi tiópixki Caifás, kan omoololojkeh non kitemachtiah n tlanawatílistli iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro san wejka okitokaya n Jesús asta kan patio icha n Caifás, okalak iwa omotlalito iwan tlamokuitlawijkeh de n Weyi Tiopa iwa ijkó kitas tlan tlamochiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","N tiopixkeh non tlayakantokeh, iwa nochteh non de Sanedrín okitemoliayah kenomi kitlajtlakolmamaltiskeh, iwa ijkó weletis kitlajtlakoltiskeh iwa kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero amitla okajsikeh tlan ika kiteiliskeh, maya miakeh okijtokoh tlan amo milák. Pero sa iksemi owalajkeh ok ome, ");
INSERT INTO nplNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","non okijtokoh: —Nin tlakatl okijto: “Ne niweletis nikxijxitinis itiopa n Dios, iwa ipan eyi tonati oksepa nikajkokuis.” ");
INSERT INTO nplNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ijkuakó n weyi tiópixki Caifás omóketski, iwa okitlajtlani n Jesús: —¿Amo titlanankilis? ¿Milák tlan ninteh kijtojtokeh? ");
INSERT INTO nplNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús amo otlanankili. Ijkuakó n Caifás oksepa okitlajtlani: —Nimitsnawatia ika itoka Totajtsi Dios non yolitok, techili kox Te Ti Cristo, Ikone Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús okinankili: —Ejé, te yotikijto. Iwa Ne nomechilia nomejwah nonnechitaskeh Ne Non onimochi ni tlakatl niewatos iyekma Dios Weletini, iwa nonnechitaskeh niwaltemotiwits de ilwikak ipan mextli. ");
INSERT INTO nplNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ijkuakó n weyi tiópixki Caifás, omotlakentsomoni iwa okijto: —¡Nin tlakatl okixpanawi Dios ika itlajtol! Mach ok moneki aka makiteili, nomonewiah yononkikakeh kenijki okixpanawi Dios. ");
INSERT INTO nplNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tlan nonkijtoah? Yejwah okijtojkeh: —Tlajtlakole, moneki mamikki. ");
INSERT INTO nplNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ijkuakó okiixchijchawijkeh, okitekilmakakeh, iwa oksikimeh okixtlajtlatsinijkeh ");
INSERT INTO nplNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","iwa okijtoayah: —Tla Te Ti Cristo, ¡xikyejyekoli akin omitsmák! ");
INSERT INTO nplNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro oewatoka kala, ijkuakó se iteska n Caifás omijkuani iwa okili n Pedro: —Te noiwa otinemia iwan Jesús non de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro amo okimokuiti iwa inmixpa okijto: —Amo nikmati tlan tikijtoa. ");
INSERT INTO nplNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro yokistiaya itech kaltentli, iwa ok se iteska okitak, iwa okinmili n oksikimeh: —Nin tlakatl noiwa onemia iwan Jesús de Nazaret. ");
INSERT INTO nplNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro oksepa amo okimokuiti, iwa asta okisentlali itlajtol: —Mach nikixmati non tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Satepa sikimeh omijkuanijkeh inakastla n Pedro iwa okilijkeh: —Milák, te seme de yejwah, porke ijkó titlajtoa. ");
INSERT INTO nplNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ijkuakó n Pedro opé tlawikaltia iwa okisentlali: —De milajka, ne mach nikixmati non tlakatl. Sanima otlakuik n kaxtil. ");
INSERT INTO nplNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ijkuakó Pedro okilnamik tlan Jesús yokilijka: “Keman ayamó tlakuika n kaxtil, te yotikijto eyi welta amo techixmati.” Otlanki Pedro okiski iwa otlawelchokak. ");
INSERT INTO nplNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ijkuak otláneski, nochteh n tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa, omoololojkeh iwa okisepantlalijkeh kitemaktiskeh n Jesús para makimiktikah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Okijilpijkeh iwa okiwikakeh kan Poncio Pilato n gobernador non walewa de Roma. ");
INSERT INTO nplNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ijkuak Judas non okitemakti n Jesús, okima okitlajtlakoltijkeh n Jesús, okiyolkua iwa oyá innawak n tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa, iwa okinkopilito n sempóali iwa n májtlaktli (30) platajtomi, ");
INSERT INTO nplNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","iwa okinmili: —Onikchi se weyi tlajtlákoli porke onomechmaktili se tlakatl iwa amitla okitewikiliaya. Pero yejwah okinankilijkeh: —¡Tejwah amo toteki! ¡Ompa te xikita! ");
INSERT INTO nplNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ijkuakó Judas okitlamotlak n tomi ijtik n Weyi Tiopa, iwa omokechpiloto. ");
INSERT INTO nplNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","N tiopixkeh non tlayakantokeh okoololojkeh n tomi iwa okijtojkeh: —Mach weletis tiktlaliskeh nin tomi ijtik kaxa kan kitlaliah n tomi, porke ika okitlaxtlajkeh imikilis se tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Satepa omoyekkajkeh kikoaskeh ika non tomi se tlali, non itoka Xoktsinchijchi para kipiaskeh se lojar kan kintookaskeh non amo de ompa. ");
INSERT INTO nplNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yika, non tlali asta axa kinotsah Éstlali. ");
INSERT INTO nplNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ijkó omochi tlan okijto n profeta: “Okonankeh n sempóali iwa n májtlaktli (30) platajtomimeh. Ijkó kemi n judíojteh okitlalilijkeh ipati. ");
INSERT INTO nplNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iwa ika non tomi, okikojkeh n tlali non itoka Xoktsinchijchi, ijkó kemi onechnawati n Toteko.” ");
INSERT INTO nplNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Okiwikakeh n Jesús ixpa n gobernador Pilato, iwa ye okitlajtlani: —¿Te ti Rey de judíos? Jesús okinankili: —Ejé, ijkó kemi yotikijto. ");
INSERT INTO nplNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","N tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa opé kiteiliah, pero Jesús mach itla okijto. ");
INSERT INTO nplNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ijkuakó n Pilato okili: —¿Amo tikkaki nochi tlan yejwah mitsteiliah? ");
INSERT INTO nplNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús amitla okinankili, yika n gobernador Pilato mach okimatia tlan kijtos. ");
INSERT INTO nplNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nochi xiwitl itech ilwitl de Paskua n gobernador okikajkawaya seme de non tsaktokeh, san akin okipejpenayah n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Itech nonteh tonatijmeh, otsaktoka se tlakatl non itoka Barrabás non sentetl okixmatiah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iwa ken miakeh oolololitokah, Pilato okintlajtlani: —¿Akin nonkinekih manikkajkawa, Barrabás noso n Jesús, non kinotsah Cristo? ");
INSERT INTO nplNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato okimatia okimaktilijkeh porke oxikojmikiah inawak Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ijkuak Pilato oewatoka kan tlaixkomaka, isiwa otlatítlanki makilitih: “Amitla xiktokti non tlakatl yolchipawak, porke axa onitlaijyowi keman oniktejtemik.” ");
INSERT INTO nplNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero n tiopixkeh non tlayakantokeh iwa n tetajmeh okintlatlalwijkeh n tlakah makitlajtlanilikah n Pilato, makikajkawa n Barrabás iwa makimikti n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato okintlajtlani: —¿Katlie de ninteh omeh nonkinekih manikkajkawa? Yejwah okilijkeh: —¡N Barrabás! ");
INSERT INTO nplNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato oksepa okintlajtlani: —¿Iwa tlan niktoktis n Jesús, non kinotsah Cristo? Nochteh otlanankilijkeh: —¡Xikkrusifikaro! ");
INSERT INTO nplNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato okinmili: —¿Tleka, tlan okichi? Pero yejwah okachi okojtsajtsiah: —¡Xikkrusifikaro! ");
INSERT INTO nplNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ijkuak Pilato okitak amo oweletia kintlakawaltis n tlakah, iwa okachi opé mokuejsoah, otlatítlanki makualikilikah atl iwa omomapajpak inyakapah nochteh iwa okijto: —Ne mach nitlajtlakole tla nonkimiktiah nin tlakatl yolchipawak, ompa nomejwah xiktakah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iwa nochteh n tlakah otlanankilijkeh: —¡Mawetsi iesso topah iwa ipan topilwah! ");
INSERT INTO nplNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ijkuakó Pilato okinkajkawili n Barrabás, iwa otlanawati makitsonwitekikah n Jesús, iwa okinmaktili n tlakah para makikrusifikarokah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Satepa isoldadojwah n Pilato okiwikakeh n Jesús kan palasio, iwa ompa okiyayawalojkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Niman okitlakenkixtijkeh, iwa okikentilijkeh se kapa chichiliktik. ");
INSERT INTO nplNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Okichijchijkeh se korona ika witstli iwa okitlalilijkeh itech itsonteko. Noiwa okimakitskiltijkeh se akatl kan imayekma. Omotlankuaketsayah iyakapa, okipijpinawiayah, iwa okijtoayah: —¡Timitsweyijkatlaliah Rey de judíos! ");
INSERT INTO nplNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Noiwa okichijchawiayah, iwa ika n akatl non okimakitskiltijkeh, okikuawijwitekiah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ijkuak otlanki okipijpinawijkeh, okikixtilijkeh n kapa chichiliktik iwa okikonakiltijkeh itlake iwa okiwikakeh okikrusifikarotoh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ijkuak yokistiayah de Jerusalén, okinamikeh itech ojtli se tlakatl de Cirene, non itoka Simón, iwa okitoktijkeh makimamali ikrus n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Okalakitoh kan se lojar non itoka Gólgota non kijtosneki: Miketsontekomatl. ");
INSERT INTO nplNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ompa okimakakeh makoni vino nelitok ika chichik xiwitl. Pero ijkuak Jesús okiyeko, mach okonik. ");
INSERT INTO nplNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Satepa, okikrusifikarojkeh n Jesús, n soldadojteh okimolijkeh matikawiltikah itlake, san akin kitlanis. Ijkó otlamochi tlan okijto n tiotlajto: okimotlatlanilijkeh notlakenwah iwa okinmoxexelilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Otlanki ompa omotlajtlalijkeh iwa okimokuitlawijtokah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iwa ik ikuatsontla okijkuilojkeh tleka okimiktijkeh: “Ye ni n Jesús, Rey de Judíos.” ");
INSERT INTO nplNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noiwa okinkrusifikarojkeh ome ichtekeh inajnakastla, se kan iyekma iwa n ok se kan iopochma. ");
INSERT INTO nplNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iwa non ik ompa opanoayah fiero okitenewayah iwa omokuawiwixoayah, ");
INSERT INTO nplNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","iwa okiliayah: —¿Amo te, otikijto tikxijxitinis n Weyi Tiopa, iwa ipan eyi tonati oksepa tikajkokuis? ¡Monewia ximopalewi! ¡Tla milák Te Ikone Dios, xitemo de kan krus! ");
INSERT INTO nplNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Noiwa n tiopixkeh non tlayakantokeh, n tetajmeh non tlayakantokeh kan tiopa iwa non kitemachtiah n tlanawátili, okipijpinawiayah iwa okiliayah: ");
INSERT INTO nplNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Okinmakixti oksikimeh, pero Ye inewia amo weleti momakixtia. Tla milák Ye n Rey de Israel, matemo de kan krus iwa tikneltokaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Omosenmák imak Dios, axa Dios makimakixti tla de milajka kitlasojtla, porke Ye okijto: “Ne Ikone Dios.” ");
INSERT INTO nplNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","N ichtekeh non okinkrusifikarojkeh iwan Jesús noiwa fiero okitenewaya. ");
INSERT INTO nplNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ijkuakó otleyuak itech nonteh tlalmeh, ik tlajko tonati iwa asta las tres. ");
INSERT INTO nplNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kemi las tres Jesús otsajtsik chikawak: —Elí, Elí ¿lama sabaktani? —noni kijtosneki: Notajtsi, Notajtsi, ¿tleka otechkajte noselti? ");
INSERT INTO nplNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sikimeh non ompa okatkah, okikakeh iwa okijtojkeh: —Nin tlakatl kinotok n profeta Elías. ");
INSERT INTO nplNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ijkuakó seme de yejwah omotlelo okipolakito siki esponja itech vinagre, iwa ika se akatl okonmák makoni n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero oksikimeh okijtojkeh: —Xikkawa, tikitaskeh kox wits kimakixtiki n profeta Elías. ");
INSERT INTO nplNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús oksepa otsajtsik chikawak, iwa omikki. ");
INSERT INTO nplNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iwa sa nima otlajkotsáyanki n tsótsoli non kajki ijtik Weyi Tiopa iwa owaltlalólinki, iwa n temeh otlajtlapankeh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","N tékochteh owalmotlapojkeh iwa miakeh non yomikkeh non okitlakitakeh Dios, omoyolitijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iwa ijkuak Jesús omoyoliti, noiwa miakeh omoyolitijkeh iwa okalakeh Jerusalén, iwa miakeh okimitakeh. ");
INSERT INTO nplNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ijkuak n kapita iwa nochteh non iwa okimokuitlawijtokah n Jesús, okimachilijkeh otlalólinki iwa okitakeh nochi tlan opanotoka, sa tlawel omomojtijkeh iwa okijtojkeh: —¡Milák, nin tlakatl okatka Ikone Dios! ");
INSERT INTO nplNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Noiwa ompa okatkah sikimeh siwameh non san wejka okonitokah. Ninteh siwameh owalajkeh de Galilea iwa okipalewijtiwalayah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ompa inwah okatkah n María de Magdala, María inmamá n Jacobo iwa n José, noiwa ompa okatka inmamá itelpochwah n Zebedeo. ");
INSERT INTO nplNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ijkuak yotleyuatoka, okalakiko José non owalewatoka de Arimatea. Ye okipiaya miak tomi. Nin tlakatl okineltokaya n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nin José okitato n Pilato iwa okitlajtlanili ikuerpo Jesús. Iwa Pilato otlanawati makimaktilikah. ");
INSERT INTO nplNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José okontemowi ikuerpo n Jesús, okimemelo ika se tlakemitl chipawak ");
INSERT INTO nplNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","iwa okitlalito kan se yankuik tékochtli non okikoyonijkeh itech tetl. Satepa, okitentsak ika se weyi tetl tankachtik iwa oyá. ");
INSERT INTO nplNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ompa oewatokah iyakapa n tékochtli, María non owalewatoka de Magdala iwa non ok se María. ");
INSERT INTO nplNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Non ok se tonati, n tiopixkeh non tlayakantokeh sansikah iwa n fariseos, okitatoh n Pilato ");
INSERT INTO nplNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","iwa okilijkeh: —Otimitsonitakoh tejwatsi, porke otikilnamikeh ijkuak oyolitoka neká tekajkaya, okijto ipan eyi tonati moyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yika tejwah tiknekih xitlanawati makimokuitlawijtokah eyi tonati n kúyoktli kan okitookakeh n Jesús. Amo kichiwa itlamachtijkawah yaskeh yuak kikixtitiweh, iwa satepa kijtojtinemiskeh yomoyoliti. Tla ijkó tlakajkayawaskeh okachi techijtlakos. ");
INSERT INTO nplNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato okinmili: —Nomejwah nonkimpiah nomotlamokuitlawijkeh, xikinwikakah iwa xikmokuitlawitih n tékochtli. ");
INSERT INTO nplNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yejwah okiyektentsakuatoh n miketékochtli, iwa itech non tetl okipepechilijkeh se seyo. Iwa ompa okinkajtejkeh sikimeh intlamokuitlawilwah. ");
INSERT INTO nplNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ijkuak yopanok n sábado ijkuak mosewia n judíos, iwa yotlanestiwalaya n domingo, ipewaya n samano, María de Magdala iwa non ok se María owalajkeh okitakoh n miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sannima chikawak otlalólinki, porke se iángel Toteko Dios owaltemok de ilwikak, iwa okalakito kan miketékochtli, okaachi n tetl non ika otentsaktoka iwa ipan omotlali. ");
INSERT INTO nplNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ixko n ángel otsotlania kemi ijkuak tlamijmilini, iwa itlake satlawel istaktik kemi tesiwitl. ");
INSERT INTO nplNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ijkuak n tlamokuitlawijkeh okitakeh, sa tlawel omomojtijkeh iwa asta opé bibiokah iwa omokajkeh kemi yetoskia yomikkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pero n ángel okinmili n siwameh: —Amo ximomojtikah. Ne kuali nikmatok nomejwah nonkitemoah Jesús, non okikrusifikarojkeh. ");
INSERT INTO nplNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mach ok nika kajki, Ye yomoyoliti ijkó kemi okijtojka. Xiwikih, xikitakih kan achto owilantoka. ");
INSERT INTO nplNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Xiajtiwetsikah, xikinmilitih itlamachtijkawah Ye yomoyoliti de kan kateh non yomikkeh. Iwa Ye tlayakanas Galilea iwa ompa nonkitaskeh. Ye nin tlan omonekia nomechilis. ");
INSERT INTO nplNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ijkuakó n siwameh owalkikistiwetskeh de kan tékochtli, majmaujtiwih pero noiwa ika pakílistli. Omotlelojkeh okinmatiltitoh itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ijkuakó Jesús okinmonextili iwa okintlajpalo. N siwameh omijkuanijkeh inawak, okikxinawajtekeh iwa okiweyijkachikeh. ");
INSERT INTO nplNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iwa Jesús okinmili: —Amo ximawikah. Xikinmilitih nokniwah mawiah Galilea, iwa ompa nechitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ijkuak n siwameh oyayah kinmatiltitiweh itlamachtijkawah n Jesús, sikimeh non okimokuitlawijtokah n miketékochtli, okalakitoh Jerusalén iwa okinmatiltitoh n tiopixkeh non tlayakantokeh nochi tlan otlamochi. ");
INSERT INTO nplNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","N tiopixkeh non tlayakantokeh omoololojkeh iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa iwa ompa okimolijkeh tlan kichiwaskeh. Okinmakakeh miak platajtomi intlamokuitlawilwah. ");
INSERT INTO nplNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Noiwa okinmilijkeh: —Nomejwah xikijtokah itlamachtijkawah n Jesús owalajkeh yuak, iwa ijkuak nomejwah ononkochtokah, okichtekikoh n kuerpo. ");
INSERT INTO nplNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iwa tla n gobernador kimatis, amo ximotekipachokah, tejwah timotlapowiskeh iwan ye. ");
INSERT INTO nplNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ijkuakó n tlamokuitlawijkeh okiselijkeh tomi iwa okichijkeh kemi okinnawatijkeh. Iwa n judíojteh asta axa ye noni tlan tetlapowiah. ");
INSERT INTO nplNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ijkó, n májtlaktli iwa n se (11) itlamachtijkawah oyájkeh Galilea, ipan tepetl kan Jesús okinmili mawiah. ");
INSERT INTO nplNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iwa ijkuak okitakeh n Jesús, okiweyijkatlalijkeh, maya sikimeh mach okineltokayah kox Ye n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús omijkuani innawak iwa okinmili: —Notajtsi onechmaktili nochi para Ne manitlanawati itech ilwikak iwa itech tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Axa, xiwiah iwa xikinmachtikah nochteh n tlaltikpaktlakah para mamochiwakah notlamachtijkawah, iwa xikinkuaatekikah itech itoka Totajtsi, itech itoka Ikone, iwa itech itoka n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Xikinmachtikah makiyektlakitakah nochi tlan yonomechnawati, iwa xikilnamiktokah Ne nochipa niyetos nomowah, asta matlami n tlaltíkpaktli.");
INSERT INTO nplNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ijkí opé n kualitlájtoli de Cristo Jesús Ikone Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","N profeta Isaías okijkuilo: Ne niktlayakanaltis akin tlatematiltijtias moyakapa, mamitsyejyektlaliliti n ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mokaki se tlájtoli chikawak non tetsajtsilia kan amaka chanti: “Xikyektlalilikah iwa xikmilawakah iojwiu n Toteko.” ");
INSERT INTO nplNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juan otlanonotinemia kan amaka chanti iwa okinmiliaya n tlakah ayakmó makichiwakah tlan amokuali iwa mamokuaatekikah, para makintlapojpolwilikah intlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nochteh non de Judea iwa de Jerusalén, okualkakiah n Juan iwa okinmokuitiayah intlajtlakolwah, iwa ye okinkuaatekiaya ijtik río Jordán. ");
INSERT INTO nplNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Itlake n Juan ochijchitoka ika itsojmio n de kameyo, iwa omotlajkoilpiaya ika se kuítlaxtli, ye sanwel okinkuaya chapulimeh iwa nékuitli. ");
INSERT INTO nplNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ijkuak otetlapowiaya okijtoaya: —Nokuitlapa wits se tlakatl okachi weletini ke ne, Akin ne mach ni tlawel kuali kemi para nimotolos nikaktojtomas. ");
INSERT INTO nplNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Milák, ne onomechkuaateki ika atl, pero Ye nomechkuaatekis ika n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Itech nonteh tonatijmeh, Jesús owala de Nazaret, non kajki kan tlali de Galilea, iwa n Juan okikuaateki kan río Jordán. ");
INSERT INTO nplNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ijkuak Jesús owálkiski ijtik atl, okitak owalmotlapo n ilwikak iwa n Espíritu owaltemotiwalaya ipan Ye kemi se palomatsi. ");
INSERT INTO nplNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iwa kan ilwikak owalmokak se tlájtoli: —Te Tinokone non niktlasojtla, iwa monawak niyolpaki. ");
INSERT INTO nplNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Satepa n Espíritu okiwík n Jesús kan amaka chanti. ");
INSERT INTO nplNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iwa Jesús ompa omoka ome póali tonati, kan nentinemih n yolkameh tekuanimeh, iwa n amokualitlakatl okinekia matlajtlakolchiwa. Iwa n ángelteh okitekichiwiliayah. ");
INSERT INTO nplNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Satepa ijkuak yotsaktoka n Juan, Jesús oyá kan tlali de Galilea, okitematiltito n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iwa Jesús okijtoaya: —Yoajsiko n tonati, keman Dios pewas tlanawatis. Xikpatlakah nomonemilis. Ayakmó xikchiwakah tlan amokuali, yej xikneltokakah n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Se tonati ijkuak Jesús opajpanotiaya itempa n weyi atl de Galilea, okitak n Simón iwa ikni Andrés okitlamotlayah inmichayawah porke yejwah michmajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús okinmili: —Xiwikih nonawak, axa nonkinmichmaskeh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ijkuakó yejwah san nima okualinkakajtejkeh inmichayawah iwa oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús onéjnenki okachi tlayakapa iwa ompa okimitak n Jacobo iwa ikni Juan, itelpochwah n Zebedeo. Yejwah okintlamanilijtokah inmichayawah itech se barka. ");
INSERT INTO nplNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús okínnotski, iwa yejwah okikakajtejkeh inta Zebedeo ijtik barka iwa itlakawah, iwa oonewakeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Satepa okalakitoh kan altepetl de Capernaúm, iwa itech sábado keman mosewia n judíos, Jesús okalak kan sinagoga iwa opé tlamachtia. ");
INSERT INTO nplNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","N tlakah omotlajtlachialtiayah ijkuak okikakiah itlamachtilis, porke okinmachtiaya ika chikawak itekiwajyo, iwa amo kemi non kitemachtiah n tlanawatílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ompa kan sinagoga de Capernaúm, se tlakatl non okipiaya se amokuali espíritu, owaltsajtsitewak: ");
INSERT INTO nplNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Tlan tikneki towah, Jesús de Nazaret? ¿Otiwala otechpojpoloko? Ne nimitsixmati, Te titiochipawak inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús okajwak n espíritu amokuali, iwa okili: —¡Xiktsakua mokamak iwa xikkawa non tlakatl! ");
INSERT INTO nplNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ijkuakó n espíritu amokuali okitokti n tlakatl mamimiki, otlanki owaltsajtsitewak chikawak iwa okikakajte. ");
INSERT INTO nplNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nochteh omomojtijkeh iwa omotlatlajtlaniayah: —¿Tlan kijtosneki ni? ¿Kualika se yankuik tlamachtílistli? ¡Nin tlakatl chikawak tlanawatia porke asta n espíritus amokualteh, kitlakamatih ijkuak Ye kinnawatia! ");
INSERT INTO nplNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","San nima omoma itech nochi n tlali de Galilea tlan Jesúsokichi. ");
INSERT INTO nplNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ijkuak okiskeh de kan sinagoga, Jesús, Jacobo iwa Juan oyajkeh icha n Simón iwa n Andrés. ");
INSERT INTO nplNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Imona n Simón okipiaya chikawak totonik, yika, okimatiltijkeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús oonmijkuani kan imona n Simón, okimakitski iwa okewalti. Non ora n siwatl owalpajtik, iwa san nima opé kintekichiwilia. ");
INSERT INTO nplNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ijkuak okalak tonati iwa opé tleyua, okwalinwikilijkeh n Jesús nochteh n kokoxkeh iwa non okimpixtokah espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iwa nochteh non ochantitokah itech non altepetl, omoololojkeh kaltempa. ");
INSERT INTO nplNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús okimpajtih miakeh kokoxkeh. Noiwa okinkixti miakeh espíritus amokualteh iwa amo okinkawiliaya matlajtokah, porke yejwah okixmatiah. ");
INSERT INTO nplNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kualka, ijkuak ok otleyuatoka, Jesús omejki iwa oyá iselti omotiotsajtsilito kan amaka ochantitoka. ");
INSERT INTO nplNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón iwa n tlakah non inwah oyayah, okitemotoh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Iwa ijkuak okajsikeh okilijkeh: —Nochteh mitstemojtinemih. ");
INSERT INTO nplNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero Ye okinmili: —Tiawih kan oksikimeh altepemeh, matikinmatiltitih n kualitlájtoli, porke ika no, Ne oniwala. ");
INSERT INTO nplNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yika, Jesús okintlapowiaya de itlajtol Dios itech nochteh n sinagogas de Galilea iwa okinkixtiaya espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Se tlakatl non okipiaya lepra itech inakayo omijkuani inawak Jesús, omotlankuáketski iwa okili: —Tla tikmonekiltia weletis techchipawas de nokokolis. ");
INSERT INTO nplNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús okiknoma n kókoxki, okitelko iwa okili: —Ne nikmonekiltia. ¡Ximochipawa! ");
INSERT INTO nplNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ijkuak ijkó okijto n Jesús, ikokolis n kókoxki okiski, iwa owalchipawak. ");
INSERT INTO nplNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sanima Jesús okimaaka n tlakatl pero okinawati: ");
INSERT INTO nplNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Kuali xikkaki tlan nimitsilis, amaka itla xiktlapowi, sanwel xio inawak n tiópixki, iwa xiktemaka por mochipawalis tlan Moisés otlanawati, para n tiopixkeh makimatikah te yotimochipa de mokokolis. ");
INSERT INTO nplNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ijkuak oyá n tlakatl, opé kintlapowia nochi tlan omochi. Yika, Jesús ayakmó oweletia okalakia teixpa itech altepemeh, yej san kalpa omokawaya, iwa miakeh tlakah de oksikimeh altepemeh owalayah inawak. ");
INSERT INTO nplNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kech tonati satepa, Jesús oksepa omókopki Capernaúm. Iwa ijkuak omoma ye okalakito ijtik se kali, ");
INSERT INTO nplNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","miakeh tlakah omoololojkeh. Iwa ayakmó oakiah n tlakah itech kaltentli, Jesús okinmatiltiaya n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ijkuakó nawi tlakah okwalikilijkeh n Jesús se tlakatl non osentitikak. ");
INSERT INTO nplNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amo oweletkeh okikalakijkeh itech kali kan Jesús okatka, porke miaktikeh tlakah ompa omoololojkeh. N tlakah okikuatlapojkeh n kali iwa ik ompa okitemowijkeh n kókoxki ika nochi ikuaujtlapech. ");
INSERT INTO nplNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ijkuak Jesús okitak nonteh tlakah milák okineltokayah, okili n kókoxki: —Nokone, nimitstlapojpolwia de motlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero sikimeh non kitemachtiah n tlanawatílistli non ompa oewatokah, omokuatlapowijkeh: ");
INSERT INTO nplNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tleka ijkó tlajtoa nin tlakatl?, tlajtoa kemi Ye yetoskia Dios, porke amaka weleti kintlapojpolwia n tlakah de intlajtlakolwah, sanwel Totajtsi Dios.” ");
INSERT INTO nplNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Inewia Jesús okimatia tlan okiyejyekoliayah non kitemachtiah n tlanawatílistli, iwa okinmili: —¿Tleka ijkó nonkiyejyekoliah itech nomoyolo? ");
INSERT INTO nplNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tlan okachi amo owi se kilis n kókoxki: “Yonimitsintlapojpolwili motlajtlakolwah”, noso: “Ximewa, xikonana mokuaujtlapech iwa xio?” ");
INSERT INTO nplNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yika, axa nomechnextilis Ne Non onimochi ni tlakatl, nikpia weletílistli ipan nin tlaltíkpaktli para nikintlapojpolwis n tlakah de intlajtlakolwah. Ijkuakó okili non osentitikak: ");
INSERT INTO nplNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Te nimitsilia, ximewa, xikajkokui mokuaujtlapech iwa xiajti mocha. ");
INSERT INTO nplNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ijkuakó n kókoxki san nima owalme, okónanki ikuaujtlapech iwa inmixpa nochteh, oonewak. Yika, nochteh omotlajtlachialtijkeh, okiweyijkachijkeh Dios, iwa okijtojkeh: —¡Ayik otikitakeh itla ijkó! ");
INSERT INTO nplNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Okachi satepa Jesús oksepa opajpanotiaya itempa n weyi atl de Galilea. Iwa ijkuak nochteh n tlakah omoololojkeh inawak, opé kinmachtia itlajtol Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ijkuak ik ompa opajpanotiaya, okitak n Leví ipiltsi n Alfeo, oewatoka kan okiseliaya impuesto para n tekiwa romano iwa Jesús okili: —Xiwiki nowa. Leví owalmóketski iwa oyá iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Satepa Jesús otlakuato icha n Leví, iwa miakeh tominoololojkeh iwa n oksikimeh tlajtlakolchijkeh noiwa otlakuatoh, omotlalijkeh kan mesa sansikah iwan Jesús iwa itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pero ijkuak non kitemachtiah n tlanawatílistli iwa n fariseos okitakeh n Jesús otlakuajtoka iwan tominoololojkeh iwan tlajtlakolchijkeh, okinmilijkeh itlamachtijkawah: —¿Tleka nomotlamachti tlakua iwa koni iwan tominoololojkeh iwan tlajtlakolchijkeh? ");
INSERT INTO nplNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ijkuak Jesús okinkak okinmili: —N tlakah non chikawakeh amo kimotlakewiah se tepajti, yej akimeh mokokoah. Ne amo oniwala onikinnotsako non kualteh, yej onikinnotsako n tlajtlakolchijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Se tonati itlamachtijkawah n Juan iwa itlamachtijkawah n fariseos omosaujtokah. Sikimeh tlakah owalajkeh okitakoh n Jesús iwa okitlajtlanijkeh: —¿Tleka itlamachtijkawah n Juan iwa itlamachtijkawah n fariseos mosawah, iwa motlamachtijkawah amo mosawah? ");
INSERT INTO nplNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús okinnankili: —¿Kox weletis mosawaskeh n tlatlálwilteh itech se monamiktilo ijkuak n novio kajki inwah? Tla n novio kajki inwah, n tlatlálwilteh, mach weletis mosawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero ajsiki tonati ijkuak n novio mach ok inwah yetos, ijkuakó mosawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","'Amaka kitlamanilia itlake non ya wewe ika se yankuik tsótsoli, porke n yankuik tsótsoli mokototsoa iwa kitsomonia n tlakemitl non ya wewe. Ijkuakó n tlakemitl, okachi weyi tsomoni. ");
INSERT INTO nplNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nion amaka kitlalia n yankuik vino ijtik se kuilambre ya wewetsi. Porke n yankuik vino kitsomonia n kuilambre non ya wewetsi, ijkuakó n vino toyawi iwa n kuilambre tsomoni. Yika, n vino non yankuik, moneki mamotlali itech yankuik kuilambre. ");
INSERT INTO nplNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se sábado ijkuak mosewia n judíos, Jesús iwa itlamachtijkawah opajpanotiayah kan ik otlatooktoka, iwa itlamachtijkawah opé miawatekih. ");
INSERT INTO nplNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ijkuakó n fariseos okilijkeh: —Xikita tlan kichijtokeh motlamachtijkawah, mach para itla kichiwaskeh itech sábado. ");
INSERT INTO nplNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús okinmili: —¿Ayamó nonkiamapoah tlan okichi n David ijkuak owalxitlatlak, ye iwa non inwah oyayah? ");
INSERT INTO nplNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Itech tonatijmeh ijkuak Abiatar weyi tiópixki, David okalak ichan Dios iwa okikua n paj non tlatiochíwali, non sanwel n tiópixkeh weleti kikuah. Pero David okikua iwa asta okinmajmák makikuakah non inwa oyayah. ");
INSERT INTO nplNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús noiwa okinmili: —Dios okichijchi n sábado para makintiochiwa n tlakah, iwa amo okichijchi n sábado para makinnawatikah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yika, Ne Non onimochi ni tlakatl niknawatia n sábado. ");
INSERT INTO nplNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús oksepa okalak kan se sinagoga, iwa ompa okalak se tlakatl mapitswak. ");
INSERT INTO nplNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iwa sikimeh fariseos sa okonitokah n Jesús kox kipajtiskia non tlakatl itech sábado ijkuak mosewia n judíos, iwa ijkó weletis kiteiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús okili n tlakatl non omapitswak: —Ximoketsa tlayakapa. ");
INSERT INTO nplNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Otlanki okintlajtlani n fariseos: —¿Techkawilia matikchiwakah tlan kuali itech sábado noso matikchiwakah tlan amokuali? ¿Techkawilia matitepalewikah noso matitemiktikah? Yejwah mach otlanankilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ijkuakó Jesús okuálanki iwa omoyolkoko, ken otlakuawatokah inyolo n fariseos. Iwa okili n kókoxki: —Xikmilawa moma. N kókoxki okimila ima, iwa opajtik. ");
INSERT INTO nplNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ijkuakó n fariseos owalkiskeh de ompa iwa opé motlatlalwiah iwan sikimeh itekitwah n Herodes para kimiktiskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús iwa itlamachtijkawah oyajkeh itempa n atl de Galilea, iwa miaktikeh tlakah oyajkeh inwah. N tlakah owalayah de Galilea iwa de Judea, ");
INSERT INTO nplNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","de Jerusalén, de Idumea, ik nepa lado n río Jordán, iwa de n tlalmeh de Tiro iwa Sidón. Ninteh tlakah, ijkuak okimatkeh nochi tlan Jesús okichiwaya, owalajkeh inawak. ");
INSERT INTO nplNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ijkuakó Jesús okinnawati itlamachtijkawah sa makitlatlalilitih se barka, iwa ijkó amo makipajpatsokah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Porke Jesús miaktikeh yokimpajtijka, yika n kokoxkeh okipajpatsmiktiayah ken okinekiah kitelkoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iwa ijkuak n espíritus amokualteh okitayah n Jesús, owetsiah ikxitla iwa otsajtsiah: —¡Te, Ti Tekone de Dios! ");
INSERT INTO nplNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús okinkamatsakuaya para amo makiteixmatiltikah teixpa. ");
INSERT INTO nplNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Satepa Jesús otlejkok itech se tepetl, iwa ompa okinmopejpenili akimeh Ye okinek, iwa yejwah owalajkeh inawak. ");
INSERT INTO nplNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ijkó okimpéjpenki májtlaktli iwa ome itlamachtijkawah para mayetokah nochipa iwan Ye, iwa para kintitlanis makitetlapowitih n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Iwa okinmák weletílistli para makinkixtikah espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yejwah ninteh n májtlakteh iwa ome akimeh okimpéjpenki: Simón akin noiwa okitlalili itoka Pedro, ");
INSERT INTO nplNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo iwa ikni Juan itelpochwah n Zebedeo, akimeh Jesús okintokayoti Boanerges, noni kijtosneki kuejsijkeh, ");
INSERT INTO nplNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo (noiwa itoka Leví), Tomás, Jacobo itelpoch Alfeo, Tadeo, Simón non onemia iwan Kananistas, ");
INSERT INTO nplNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","iwa n Judas Iscariote non satepa okitemakti n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Satepa Jesús okalak itech se kali iwa oksepa omoololojkeh miaktikeh tlakah iwa asta ayakmó oweletiah otlakuayah. ");
INSERT INTO nplNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ijkuak okimatkeh non ken okitayah n Jesús, owalajkeh okinotsakoh, porke okimoliayah chamo yokuatlapolo. ");
INSERT INTO nplNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Noiwa non kitemachtiah n tlanawatílistli akimeh owalajkeh de Jerusalén, okijtoayah: —Nin tlakatl kipia iweletilis beelzebú iwa ika non weletílistli kinkixtia n espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ijkuakó Jesús okínnotski mawalmijkuanikah inawak iwa opé kinmajsikamatiltia ika tlapoálistli, iwa okinmili: —¿Kenomi weletis n satanás san ye inewia kualkixtis n satanás? ");
INSERT INTO nplNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tla se país xexelitos, ayik pankisas, ");
INSERT INTO nplNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","iwa tla itech se familia nochteh xexelitokeh, mach wejkawas non familia. ");
INSERT INTO nplNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Porke tla n satanás inewia moixnamiki iwa moxexeloa, ayakmó kipias weletílistli iwa pojpoliwis. ");
INSERT INTO nplNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","'Amaka weletis kalakis icha n se tlakatl chikawak para kitlachtekis, tlamo achto kijilpia iwa ijkuakó ya weletis kitlachtekis. ");
INSERT INTO nplNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'De milajka nomechilia Dios weletis kintlapojpolwis akimeh kichiwah tlajtlákoli, ");
INSERT INTO nplNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero akin fiero kitenewas n Espíritu Santo, ayik kitlapojpolwiskeh iwa nochipa yetos tlajtlakole. ");
INSERT INTO nplNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús ijkó okijto porke yejwah okijtojkeh Ye kipia se espíritu amokuali. ");
INSERT INTO nplNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ijkuakó imamá iwa ikniwah n Jesús, okalakikoh kan otlamachtijtoka. Pero san kaltempa omokajkeh iwa otlatitlankeh makinotsatih. ");
INSERT INTO nplNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ijkuakó, non okiyawalojtokah n Jesús, okilijkeh: —Momamá, mokniwah iwa moweltiwah kateh kala iwa mitsontemoah. ");
INSERT INTO nplNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero Ye okinnankili: —¿Akin nomamá iwa akimeh nokniwah? ");
INSERT INTO nplNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Otlanki, Jesús okintlajtlatak non ompa okiyawalojtokah iwa okijto: —Nikan kateh nomamá iwa nokniwah, ");
INSERT INTO nplNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","nochteh akimeh kichiwah tlan Dios kimonekiltia, ye nokni, nowelti iwa nomamá. ");
INSERT INTO nplNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús oksepa opé tlamachtia itempa n atl de Galilea, iwa miakeh tlakah omoololojkeh inawak. Okatkah miaktikeh, yika Jesús otlejkok itech se barka iwa itech omotlali. N tlakah omokajkeh itempa n atl para kikakiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ijkuakó Ye opé kinmachtia ika miakeh tlapoálisteh. Iwa okinmiliaya: ");
INSERT INTO nplNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kuali xikakikah tlan nomechilis: Se tlakatl otookato. ");
INSERT INTO nplNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ijkuak otook, siki xínachtli owetski inakastla n ojtli, iwa n totomeh owalajkeh iwa okikuajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oksiki xínachtli owetski kan tlateyo iwa niman oixwak porke n tlali amo weltilawak. ");
INSERT INTO nplNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero ijkuak okiski n tonati, owaki, porke amo wejkatla omonelwayoti. ");
INSERT INTO nplNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oksiki xínachtli owetski intsalko witsmeh, iwa n witsmeh omoskaltijkeh iwa okijyomiktijkeh, yika n tlatookali mach otlaaki. ");
INSERT INTO nplNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oksikimeh xinachteh owetskeh itech kuali tlali, iwa ijkuak oixwakeh, kualtsi omoskaltijkeh, iwa miak otlaaki. Siki okitemák sempóali iwa n májtlaktli (30) por se xínachtli, oksiki okitemák eyi póali (60), iwa oksiki okitlakilti se siento. ");
INSERT INTO nplNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ijkuakó okinmili: —¡Akin de milajka kipia inakas, makajsikamati! ");
INSERT INTO nplNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Satepa, ijkuak yokikakajtejkah n Jesús, sikimeh non ok omokajkeh iwan májtlakteh iwa ome itlamachtijkawah, okitlajtlanijkeh tlan kijtosneki n tlapoálistli de non otook. ");
INSERT INTO nplNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús okinmili: —Nomejwah Dios yonomechmatilti tlan yowejkah otlaatitokah, pero n oksikimeh amó. Yejwah okinmachti ika tlapoálisteh. ");
INSERT INTO nplNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yika, maya matlachiakah amo makitakah, iwa maya matlakakikah amo mateajsikamatikah, sanwel kinmajsikamatiltis tla moyolpatlaskeh iwa kitlajtlaniliskeh Dios makintlapojpolwi. ");
INSERT INTO nplNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús noiwa okinmili: —¿Amo nonkajsikamatih nin tlapoálistli? ¿Kenomi nonkinmajsikamatiskeh n oksikimeh tlapoálisteh? ");
INSERT INTO nplNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Akin tooka ye kemi akin tetlapowia n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Onkateh tlakah kemi n xínachtli non owetski inakastla n ojtli, kikakih n kualitlájtoli iwa keman okikakeh, wits satanás iwa kinyolkixtilia n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oksikimeh tlakah kemi n xínachtli non owetski itech tlateyo, kikakih n kualitlájtoli iwa kiseliah ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero kemi amo yektlakxilitokeh, mach wejkawah, porke ijkuak pewa tlaijyowiah por n kualitlájtoli, san nima wetsih. ");
INSERT INTO nplNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Oksikimeh kemi n xínachtli non owetski itsalko witsmeh, yejwah kikakih n kualitlájtoli, ");
INSERT INTO nplNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero okachi kintekipachoa tlan onka itech nin tlaltíkpaktli, iwa kinekih kitlawelpiaskeh tomi. Yika, nochi ni kinyolijtlakoa iwa ayakmó kinkawilia mamotenexti Dios intech yejwah. ");
INSERT INTO nplNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero akimeh kikakih n kualitlájtoli iwa kiyekseliah, yejwah kemi n xínachtli non owetski itech kuali tlali, sikimeh kemi n xínachtli non kitemakah sempóali iwa n májtlaktli xínachtli por se xínachtli, oksikimeh kemi n xínachtli non kitemaka eyi póali, iwa n oksikimeh kemi n xínachtli non kitemaka se siento. ");
INSERT INTO nplNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús noiwa okinmili: —Ijkuak nonkimilintiah se tláwili, ¿mach nonkitlaatiah itlampa se kama noso itlampa se kajo? Nonkimilintiah iwa nonkitlaliah tlakpak para matlawi. ");
INSERT INTO nplNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yika, nochi tlan tlaatitok monextis iwa nochi tlan amo momati saman momatis. ");
INSERT INTO nplNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Akin de milajka kipia inakas, makajsikamati! ");
INSERT INTO nplNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús noiwa okinmili: —Xikitakah nomejwah akimeh nonkikakih nin tlájtoli. Ijkó kemi nomejwah nonkintlatamachiwiliskeh oksikimeh, nomechtamachiwiliskeh iwa okachi nomechmakaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porke akin kipia, okachi kimakaskeh, iwa akin amo kipia, kikixtiliskeh tlan san achitsi kipia. ");
INSERT INTO nplNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús noiwa okijto: —Kan Dios tlanawatia, kemi akin kitepewa xínachtli itech tlali. ");
INSERT INTO nplNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tla yas kochiti nochi yúali, iwa tla mewas noso amo mewas nochi kualka, n tlátoktli kisentoka moskaltijti, pero ye mach kimati kenijki moskaltia. ");
INSERT INTO nplNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Inewia n tlali kiskaltia n tlátoktli, achto ixwa iwa moxiujyotia, tlami miawati iwa iksemi tlaaki. ");
INSERT INTO nplNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ijkuak n tlátoktli yochikawak, kitekih porke yoajsiko n tonati para motekis. ");
INSERT INTO nplNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Satepa Jesús noiwa okinmili: —¿Ika tlan tlájtoli nomechititis kan Dios tlanawatijtok? Noso, ¿ika tlan tlapoálistli weletis nomechixmatiltis? ");
INSERT INTO nplNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kan Dios tlanawatia kemi se xinatsintli de mostaza ijkuak kitlalpachoah. Nin xinatsintli okachi tsijtsikitsi de nochteh n xinachtsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero, ijkuak se kitlalpachoa, ixwa iwa moskaltia okachi weyi ke nochteh n tlátokteh, iwa itech wejweyijtikeh imamayowah n totomeh motepajsoltiah itlampa itlasekawilo. ");
INSERT INTO nplNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ika miakeh tlapoálisteh Jesús okinmachtiaya n kualitlájtoli asta kan yejwah okajsikamatiah. ");
INSERT INTO nplNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nochipa okintlapowiayah ika tlapoálisteh, pero ijkuak sa Ye omokawaya iwan itlamachtijkawah, nochi okinmajsikamatiltiaya. ");
INSERT INTO nplNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Non tonati ijkuak yotlajkajtik Jesús okinmili itlamachtijkawah: —Matikojchalwikah n lago. ");
INSERT INTO nplNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ijkuak yokinmakajkeh n tlakah, itlamachtijkawah okiwikakeh n Jesús itech barka, iwa oksikimeh barkas inwah oyajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ijkuakó owalmokajka se ejekatl chikaktik iwa n atl opé motlatlamotla ijtik barka iwa opé atemi. ");
INSERT INTO nplNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús okochtoka tlakuitlapa iwa okimokpalti se íkpali, iwa itlamachtijkawah okijxititoh iwa okilijkeh: —¡Tlamachti! ¡Xiijsa, tiapolakih! ");
INSERT INTO nplNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ijkuakó Jesús owalme iwa okitlakawalti n ejekatl, iwa okili n atl: —¡Ximoyekmana! Iwa n ejekatl omóketski iwa nochi san owaltlamoka. ");
INSERT INTO nplNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Otlanki Jesús okinmili itlamachtijkawah: —¿Tleka satlawel nonmawih? ¡Ayamó nontlaneltokah! ");
INSERT INTO nplNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero yejwah satlawel omaujtokah iwa omotlajtlaniayah. —¿Akin nin tlakatl, asta n ejekatl iwa n atl kitlakitah? ");
INSERT INTO nplNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús iwa itlamachtijkawah okalakitoh ik nepa lado de n lago, kan tlali de Gadara. ");
INSERT INTO nplNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ijkuak Jesús otemok de kan barka, san nima okinamikiko se tlakatl non okipiaya se espíritu amokuali. Nin tlakatl owálkiski intsalko n miketékochteh, ");
INSERT INTO nplNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ken ompa ochantitoka. Amaka oweletia okilpiaya nion ika kadena. ");
INSERT INTO nplNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Miak welta yokimaijilpijkah iwa okikxiijilpijkah ika kadenajteh, pero ye okinkokototsaya iwa amaka oweletia okitlakawaltiaya. ");
INSERT INTO nplNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tlajka iwa n yuak otsajtsitinemia ik tepeyo iwa kan tooktokeh non yomikkeh, iwa san ye inewia omokojkojtinemia ika tetl. ");
INSERT INTO nplNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pero ijkuak okonitak n Jesús ok wejka tlantiwits, omotlelojtikiski iwa omotlankuaketsato inawak, ");
INSERT INTO nplNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","iwa chikawak okili: —¡Tlan tikneki nowa, Jesús Ikone Dios non weyijkatitok! Nimitstlatlaujtia ika Itoka n Dios, amo techtlaijyowilti. ");
INSERT INTO nplNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ijkó okijto porke Jesús yokilijtoka: —¡Espíritu amokuali, xikkawa nin tlakatl! ");
INSERT INTO nplNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iwa Jesús okitlajtlani: —¿Tlan timotoka? Ye otlanankili: —Ne notoka Miaktikeh, porke timiakeh. ");
INSERT INTO nplNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iwa n espíritu amokuali okitlatlaujti n Jesús, amo makintitlani wejka. ");
INSERT INTO nplNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Iwa kemi miakeh pitsomeh ik ompa otlakuajtinemiah ikxitla n tepetl, ");
INSERT INTO nplNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","n espíritus amokualteh okitlatlautijkeh n Jesús: —Techtitlani matikalakikah inmijtik nekateh pitsomeh. ");
INSERT INTO nplNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ijkuakó Jesús okitekawili, iwa n espíritus amokualteh owalkiskeh ijtik non tlakatl iwa okalakeh inmijtik nonteh pitsomeh. N pitsomeh okistewakeh iwa omoatlanwitoh ijtik weyi atl iwa omikkeh. Ninteh pitsomeh okatkah kemi ome mil. ");
INSERT INTO nplNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ijkuakó n tlajpixkeh de nonteh pitsomeh ochocholojtewakeh iwa oyajkeh otetlapowitoh ik tetlala iwa kan weyi altepetl nochi tlan otlamochi. Iwa miakeh tlakah okitakoh tlan otlamochijka. ");
INSERT INTO nplNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","N tlakah de non altepetl okalakitoh kan Jesús, iwa okitakeh n tlakatl non okimpiaya espíritus amokualteh. Nin tlakatl yoewatoka, yotlakentitoka iwa ika kuali itlalnamikilis, iwa n tlakah omaujkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","N tlakah akimeh okitakeh tlan otlamochi, otetlapowijkeh tlan omochi neká tlakatl non okimpiaya espíritus amokualteh, iwa tlan omochijkeh n pitsomeh. ");
INSERT INTO nplNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ijkuakó okitlatlautijkeh n Jesús mawia de ompa. ");
INSERT INTO nplNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ijkuak Jesús otlejkok itech barka, n tlakatl non okimpiaya espíritus amokualteh, okitlatlaujtiaya n Jesús makiwika. ");
INSERT INTO nplNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús mach okikawili, yej okili: —Xiajti mocha, iwa xikinmatilti mochanikniwah nochi tlan Dios okichi mowa, iwa kenijki omitsiknoma. ");
INSERT INTO nplNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","N tlakatl oyá icha, iwa opé tetlapowia kan altepemeh de Decápolis nochi tlan Jesús okichi por ye, iwa nochteh omotlajtlachialtiayah. ");
INSERT INTO nplNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ijkuak Jesús oksepa owalmókopki itech barka ik nepa lado de n lago, miaktikeh tlakah okinamikikoh, iwa Ye ompa omoka inwah. ");
INSERT INTO nplNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ijkuakó owala se tlayákanki de kan sinagoga, non omonotsaya Jairo. Ijkuak okitak n Jesús omotlankuáketski ikxitla, ");
INSERT INTO nplNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","iwa okitlatlaujti: —Nochpoch ya tlatlantok, xiwiki nocha xikintlaliliki momawah ipan nochpoch, ijkó pajtis iwa yolitos. ");
INSERT INTO nplNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ijkuakó Jesús oyá iwan Jairo, iwa miakeh tlakah oyayah inwa. Yejwah okipajpatsoayah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Noiwa ompa oyaya se siwatl non yokiwikaya májtlaktli iwa ome xiwitl kókoxki ika esmilawálistli. ");
INSERT INTO nplNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ye satlawel yotlaijyowijka inmak tepajtijkeh, iwa yomotomintlamijka, pero mach opajtia yej okachi oowijtiaya. ");
INSERT INTO nplNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ijkuak okima tlan Jesús okichiwaya, omijkuanijtia ik ikuitlapa, iwa ik intsalko n tlakah okitempantelkoli itlake n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Porke okimoliaya: “Tla san niktelkolis itlake, nipajtis.” ");
INSERT INTO nplNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ijkuakó iesmilawalis owalwak iwa san nima ye okimachili opajtik. ");
INSERT INTO nplNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Non ora Jesús okimachili ichikawalis aka okipajti, yika oontláchixki ik ikuitlapa iwa okintlajtlani n tlakah: —¿Akin okitelko notlake? ");
INSERT INTO nplNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ijkuakó itlamachtijkawah okilijkeh: —Miakeh tlakah techpajpatsojtiwitseh iwa Tejwatsi titlajtlani “¿Akin okitelko notlake?” ");
INSERT INTO nplNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús okiixtemo akin okitelko. ");
INSERT INTO nplNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ijkuakó n siwatl kemi okimatia ye okitelko, ika mawílistli omotlankuaketsato ikxitla n Jesús, iwa okili tlan omochiwaya. ");
INSERT INTO nplNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús okili: —Nokone, motlaneltokalis omitspajti. Xiajti ika pakílistli, porke axa yotipajtik de motlaijyowilis. ");
INSERT INTO nplNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús ok otlajtojtoka, ijkuak okalakikoh sikimeh tlakah de icha n Jairo iwa okilijkeh: —Mochpotsi yomikki, ¿tlan ok para tikkuejsoa n tlamachti? ");
INSERT INTO nplNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús san okinkak iwa okili n Jairo: —Amo ximawi, sanwel xitlaneltoka. ");
INSERT INTO nplNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iwa Jesús mach okitekawili mawia aka ok se, sanwel Pedro, Jacobo iwa ikni Juan. ");
INSERT INTO nplNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ijkuak okalakito icha n tlayákanki Jairo, Jesús okinmitak n tetlajpalojkeh saikpanoa ochokatokah iwa otsajtsiah. ");
INSERT INTO nplNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ijkuakó Ye okalak iwa okinmili: —¿Tleka nonmopajsoloah iwa nonchokah? N ichpotsintli mach omikki, sanwel kochi. ");
INSERT INTO nplNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nochteh san okiwetskakeh. Ijkuakó Jesús nochteh okwalinkixti. Sanwel okínnotski íwa itajwah n takotsi iwa itlamachtijkawah. Okalakeh kan okatka n takotsi. ");
INSERT INTO nplNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ijkuakó Jesús okimakitski n takotsi iwa okili: —Talita, kumi —noni kijtosneki: ¡Takotsi, Ne nimitsilia, ximewa! ");
INSERT INTO nplNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","San nima, n takotsi owalme iwa opé nejnemi, iwa nochteh non okitakeh omotlajtlachialtijkeh. N takotsi okipiaya májtlaktli iwa ome xiwitl. ");
INSERT INTO nplNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero Jesús okinnawati amaka makimatiltikah tlan otlamochi, iwa okinnawati itajwah makitlakualtikah n takotsi. ");
INSERT INTO nplNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús okiski de Capernaúm iwa oyá Nazaret kan omoskalti, iwa itlamachtijkawah oyajkeh íwa. ");
INSERT INTO nplNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iwa ijkuak oajsiko n sábado ijkuak mosewia n judíos, Jesús opé tlamachtia kan sinagoga. Miakeh tlakah non okikakeh omotlajtlachialtijkeh iwa okijtojkeh: —¿Kan okikuito nin tlakatl nochi tlan kimati? ¿Iwa kenomi ika imawah weleti kinchiwa milagros? ");
INSERT INTO nplNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Amo Ye ni n karpintero, ipiltsi n María, iwa ikniwah Jacobo, José, Judas iwa Simón? ¿Iwa amo nika chantitokeh iweltiwah? N tlakah okitlawelitayah iwa mach okineltokayah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ijkuakó Jesús okinmili: —Sentetl kiseliah se profeta, pero kan omoskalti noso non ken kita iwa ichanikniwah mach kiseliah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yika, Jesús mach okichi nion se milagro ompa kan omoskalti. Sanwel okintlalili imawah ipan sikimeh kokoxkeh iwa okimpajti. ");
INSERT INTO nplNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús san omotlajtlachialti ijkuak okimitak amo okineltokayah. Satepa Jesús otlamachtijtinemia ik nonteh altepemeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús okínnotski májtlaktli iwa ome itlamachtijkawah, iwa ojomeh okintítlanki matetlapowitih de itlajtol Dios iwa okichi makinkixtikah espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iwa okinnawati amitla makiwikakah, nion inmantajkostal nion intlaxkal, nion itla tomi, sanwel se kuawitl. ");
INSERT INTO nplNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Iwa inkakkuah, iwa amo makinwikakah oksikimeh intlakenwah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Noiwa okinmili: —Ijkuak nonkalakitiweh itech se kali, ompa ximokawakah asta ijkuak nonkikawaskeh non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Iwa tla kana nonkalakitiweh iwa amo nomechseliah nion kinekih nomechkakiskeh, xikisakah iwa ximoikxitsejtselokah, para makimatikah mach kuali tlan okichijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ijkuakó yejwah okiskeh iwa okinmiliayah n tlaltikpaktlakah, makipatlakah innemilis iwa ayakmó matlajtlakolchiwakah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Noiwa okinkixtiayah espíritus amokualteh, iwa okinxawiliayah aseite n kokoxkeh iwa okimpajtiayah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","N rey Herodes Antipas Primero okima tlan okichiwaya n Jesús, ken nochteh omotlapowiayah de Ye. Iwa Herodes okijto: —Juan Bautista yomoyoliti de kan kateh non yomikkeh, yika kipia non weletílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oksikimeh okijtoayah: —Ye n profeta Elías. Oksikimeh okijtoayah: —Ye se profeta kemi non yowejkajkeh profetas. ");
INSERT INTO nplNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ijkuak Herodes ijkó okima, okijto: —Ye n Juan, akin ne onitlanawati makikechtsontekikah, iwa axa yomoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes otlanawatijka makikitskikah n Juan iwa makitsakuakah, ken okilijka amokuali kimomekatijtos ikuñada Herodías. ");
INSERT INTO nplNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan Bautista okiliaya n Herodes: —Tlajtlákoli tikpixtos isiwa mokni Felipe. ");
INSERT INTO nplNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yika n Herodías okikokoliaya n Juan iwa okinekia makimiktikah, pero mach okimatia kenomi kichiwas. ");
INSERT INTO nplNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Noiwa Herodes okimatia Juan ye kuali tlakatl iwa yolmilajka, iwa okimawiliaya. Yika mach okikawiliaya n Herodías itla makitokti. Maya Herodes amo okiyekajsikamatia tlan Juan otlamachtiaya, okiwelitaya tlan okijtoaya. ");
INSERT INTO nplNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Oajsiko se tonati ijkuak Herodes okitlami xiwitl. Iwa okintlalwi matlatlakuakih n tlanawatijkeh de ipalasio, isoldado tlayakanwah noiwa n tekiwajkeh de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Itech non ilwitl ichpoch n Herodías omijtoti inmixpa n tlatlálwilteh iwa saikpanoa okiwilitakeh nochteh. Ijkuakó Herodes okili n íchpochtli: —Techtlajtlanili san tlan tiknekis iwa ne nimitsmaktilis. ");
INSERT INTO nplNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iwa okisentlali kimaktilis san tlan ye kitlajtlaniliskia, maya kitlajtlaniliskia tlajko itekiwajyo. ");
INSERT INTO nplNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","N íchpochtli okitlajtlanito ína: —¿Tlan niktlajtlanilis n Herodes? Ína okili: —Xiktlajtlanili itsonteko n Juan Bautista. ");
INSERT INTO nplNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","San nima n íchpochtli oyá kan Herodes iwa okili: —Techmaka axa san nima itsonteko n Juan Bautista itech se teposkaxitl. ");
INSERT INTO nplNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","N rey Herodes satlawel omoyolkoko. Pero kemi ye okisentlali inmixpa nochteh itlatlalwilwah kimaktilis n íchpochtli san tlan ye kinekis, ayakmó owéletki omotlajtolpatlak. ");
INSERT INTO nplNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Totokatijkak okinawati se soldado, mawia kan otsaktoka Juan makikechtsontekiti iwa makiwalikili itsonteko n Juan. ");
INSERT INTO nplNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","N soldado oyá kan otsaktoka n Juan, okikechtsontek iwa okimaktiliko n íchpochtli itsonteko n Juan itech se teposkaxitl, iwa n íchpochtli okimaktili ína. ");
INSERT INTO nplNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ijkuak itlamachtijkawah n Juan okimatkeh tlan otlamochi, okikuitoh ikuerpo n Juan iwa okitookakeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ijkuak omokopatoh de okitetlapowito n kualitlájtoli, n itlamachtijkawah omoseitilijkeh iwan Jesús. Okimatiltijkeh tlan okichijkeh, iwa tlan okitemachtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iwa Jesús okinmili: —Xiwikih, matimosewitih kan amaka nemi. Ken miaktikeh owalayah inawak, iwa asta mach ok omajxiliayah tlakuaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yika, Jesús iwa itlamachtijkawah oyajkeh itech se barka kan amaka chantitok. ");
INSERT INTO nplNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero ijkuak yoyayah, miakeh tlakah okimitakeh iwa okimixmatkeh. Ijkuakó miakeh tlakah de nonteh altepemeh okintokakeh iwa okalakitoh achto kan Jesús iwa itlamachtijkawah onajsiskiah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ijkuak Jesús owaltemok de kan barka, okimitak miakeh tlakah non sa okichixtokah iwa okimiknoma, ken okimitak kemi ichkameh non kipiah akin kinyakanas. Iwa san miak opé kinmachtia. ");
INSERT INTO nplNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ijkuak yotlajkajtik, itlamachtijkawah n Jesús owalajkeh inawak iwa okilijkeh: —Yotlajkajtik, iwa ik nika amaka chanti. ");
INSERT INTO nplNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xikinmakawa n tlakah mawiah tetlala iwa kan altepemeh non amo wejka kateh iwa makimokowitih tlan kimomajsewiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Jesús okinnankili: —Nomejwah xikintlakualtikah. Yejwah okijtojkeh: —¿Tikneki matikkoatih paj ika ome siento denario, iwa matikintlamakakah nochteh? ");
INSERT INTO nplNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús okintlajtlani: —¿Kechmeh pameh nonkimpiah? Xiwiah xiktatih. Ijkuak okimatkeh kechmeh pameh okimpiayah, okilikoh: —Tikimpiah mákuili pameh iwa ome michimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ijkuakó Jesús otlanawati mamoololokah iwa mamotlajtlalikah ipan xiwitl non kualtsi selistok. ");
INSERT INTO nplNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Iwa nochteh n tlakah omoololojkeh de mamajkuili póali iwa oksikimeh de tlatlajko siento. ");
INSERT INTO nplNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ijkuakó Jesús okinmónanki n mákuili pameh iwa ome michimeh, oontláchixki ilwikak iwa omotlasojkama inawak Dios iwa okintlajtlápanki n pameh, iwa okinmajmák itlamachtijkawah makinxejxelilikah n tlakah. Ijkó noiwa okichi iwa ome michimeh, iwa okinxejxelili nochteh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nochteh otlakuajkeh iwa kuali oixwikeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Satepa okoololojkeh tlan amo okikuajkeh iwa okintetemitijkeh májtlaktli iwa ome chikimeh ika pantlapanalteh iwa michimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mákuili mil tlakah otlakuajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Satepa Jesús okintítlanki itlamachtijkawah itech se barka, iwa okinmili sa makichiati kan altepetl de Betsaida, porke Ye ok kinmakawaskia n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iwa ijkuak yotlanki okinmaaka, omotiotsajtsilito kan tepetl. ");
INSERT INTO nplNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ijkuak otleyuak, n barka yotlajkotlantiaya itech lago. Jesús omoka iselti ixko tlali, ");
INSERT INTO nplNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","iwa okimitak satlawel yokinsotla n barka porke n ejekatl okimixnamiktiwalaya. San kualka Jesús okwalintokaya nejnenti ixko atl iwa okinmajsito itlamachtijkawah iwa yokinekia kimpanawis. ");
INSERT INTO nplNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ijkuak yejwah okitakeh nejnenti ixko atl, okimolijkeh chamo se temomojti okinmonextili iwa otsajtsikeh. ");
INSERT INTO nplNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nochteh okitakeh iwa omomojtijkeh. Pero Ye okínnotski iwa okinmili: —¡Ximoyolchikawakah, amo ximomojtikah, Ne Ni Jesús! ");
INSERT INTO nplNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ijkuakó Jesús oontlejkok itech barka kan itlamachtijkawah, iwa n ejekatl san owalmoka. Yejwah satlawel omotlajtlachialtijkeh, ");
INSERT INTO nplNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porke ayamó okajsikamatiah tlan okitakeh ijkuak Jesús okinmiakili n pameh ken oyoltlakuawatokah. ");
INSERT INTO nplNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ijkuak okalakitoh Genesaret, ompa inakastla n lago okilpijkeh n barka. ");
INSERT INTO nplNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ijkuak yejwah owaltetemokeh, n tlakah san nima okixmatkeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yika, itech nochi non tlali omotletlelojkeh iwa okwalinwikiliayah inkokoxkawah, kan okikakiah Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iwa sentetl kan Ye oyaya, itech wejweyi noso tsitsikitikeh altepemeh, noso ik tetlala, n tlakah okinkixtiayah inkokoxkawah itech ojtli, iwa okitlatlaujtiayah makinkawili maya san makitempantelkolikah itlake para mapajtikah. Nochteh non okitelkoliayah itlake opajtiah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ijkuakó n fariseos iwa sikimeh non kitemachtiah n tlanawatílistli owalajkeh de Jerusalén, omoololojkeh iwa okitatoh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yejwah okitakeh sikimeh itlamachtijkawah n Jesús otlakuayah iwa amo omomajtekiayah asta inmatlankwah kemi yejwah okichiwayah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Porke n fariseos iwa nochteh n judíojteh saikpanoa okitlakitayah tlan okinmachtijkah intatawah. Amo tlakuah tla amo achto momapajpakah miak welta asta kan inmatlankwah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Keman onmokopayah tiánkistli, amo otlakuayah tla amo achto moyekmapajpakah. Iwa kimpiah oksikimeh tlamachtílisteh, kemi ninteh: trato kimpajpakah n xíkalteh, n káxilteh, iwa n axoktsimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yika n fariseos iwa non kitemachtiah n tlanawatílistli owalajkeh okitlajtlanijkeh n Jesús: —¿Tleka motlamachtijkawah amo kitlakitah n tlanáwatili non otechmachtijkeh totatawah? ¿Tleka ijkuak tlakuah amo momapajpakah kemi tejwah? ");
INSERT INTO nplNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús okinnankili: —Mach omotlapololti n profeta Isaías ijkuak okijto nomejwah nonmíxkopteh, iwa ijkí okijkuilo: Ninteh tlakah ika inkamak kijtoah nechtlasojtlah. Pero amo nechtlakitah ika inyolo. ");
INSERT INTO nplNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sanenka nechweyijkachiwah, porke tlan kitemachtiah sanwel intlanawatilwah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Porke nomejwah nonkikawah tlan Dios technawatia matikchiwakah iwa san nonkitlakitah tlan okichiwayah nomotatawah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesús noiwa okinmili: —Nomejwah ik nepa nonkontlakaltechoah itlanawatil Dios, iwa okachi nonkimopantiah tlan yowejka okichiwayah nomotatawah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés okijto: “Xiktlakita mopapá iwa momamá.” Noiwa okijto: “Akin fiero kitenewa ipapá noso imamá, makimiktikah.” ");
INSERT INTO nplNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero nomejwah nonkijtoah kualiká tla aka kilia ita noso ina: “Ayakmó nimitspalewis, porke tlan nimitsmakaskia yonikxelo para niktemakas tiopa.” ");
INSERT INTO nplNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Iwa tla aka ijkó kijtoa, nomejwah nonkikawiliah ayakmó moneki makimpalewi itajwah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ijkó kiné, nomejwah nonkixpanawiah itlanawatil Dios, iwa san nonkinchijtiwitseh tlan okichiwayah nomotatawah. Iwa oksiki kemi ni, nonkichiwah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús oksepa okínnotski n tlakah mawikih inawak, iwa okinmili: —Techkakikah non nochteh iwa xikajsikamatikah: ");
INSERT INTO nplNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tlan kikua se tlakatl, amo ye tlan kijtlakolia iyolo, yej tlan kisa de itech iyolo n tlakatl, ye noni tlan kijtlakolia iyolo. ");
INSERT INTO nplNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tla nonkinekih nonkajsikamatiskeh, xikkasikamatikah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Satepa, ijkuak Jesús okinkajteh n tlakah iwa okalak itech kali, itlamachtijkawah okitlajtlanilijkeh makinmajsikamatilti tlan okijtojka. ");
INSERT INTO nplNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ye okinmili: —¿Nomejwah noiwa amo nonkajsikamatih? ¿Amo nonkajsikamatih tlan kalaki ijtik se tlakatl amo ye tlan kijtlakolia iyolo? ");
INSERT INTO nplNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porke mach kalaki itech iyolo, yej kalaki san kan itlalax, iwa satepa kisa kanik ikuitlaxkolwah. Ika noni okinek okijto nochi tlákuale chipawak. ");
INSERT INTO nplNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Noiwa okijto: —Tlan kisa ijtik iyolo se tlakatl, noni kijtlakolia iyolo. ");
INSERT INTO nplNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porke de ijtik iyolo n tlakatl, kisa tlan amo kuali, awilnemi, tlachteki, temiktia, ");
INSERT INTO nplNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","momekatijtinemi, tominápistli, kichiwa tlan amokuali, tlakajkayawa, kichiwa tlajtlákoli, xíkojtli, xolópijtli, moweyijkachiwa iwa mach kimati tlakaki. ");
INSERT INTO nplNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochteh ninteh amo kualteh tlamachílisteh kisah inmijtik inyolo n tlakah iwa kinyolijtlakoa. ");
INSERT INTO nplNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús oyá kan tlalmeh de Tiro iwa Sidón. Okalak kan se kali, iwa amo okinekia aka makimati kan okatka, pero mach owéletki okinmotlatili. ");
INSERT INTO nplNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Se siwatl non ichpoch okipiaya se espíritu amokuali, okima kan Jesús okatka iwa owala inawak iwa omotlankuáketski ikxitla. ");
INSERT INTO nplNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nin siwatl de Grecia iwa itajwah owalewatokah de sirofenicia. Okitlatlaujtiko n Jesús makikixtili n espíritu amokuali non ichpoch okipiaya. ");
INSERT INTO nplNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús okili: —Xikinkawa achto maixwikah n tepilwah, porke amo kuali matikinkixtilikah intlakual iwa matikinmakakah n chichimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","N siwatl okinankili: —Milák, Noteko, pero noiwa n chichimeh non nemih itlampa mesa kikuah n kamapáyaxtli non kitepewah n tepilwah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ijkuakó Jesús okili: —Kuali tlan otikijto, ya weletis tias. N espíritu amokuali yokikakajte mochpoch. ");
INSERT INTO nplNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ijkuak n siwatl okalakito icha, okajsito ichpoch wetok itech ipetl, iwa n espíritu amokuali yokikakajte. ");
INSERT INTO nplNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús, oksepa okiski de kan tlali de Tíro, iwa opanok kan tlali de Sidón iwa ijkó okalakito kan weyi atl de Galilea, iwa omoka itech tlalmeh de Decápolis. ");
INSERT INTO nplNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ompa okiwikilijkeh se tlakatl kamapojpólochtli iwa amo otlakakia, iwa okitlatlautijkeh n Jesús makitlalili ima itech non kókoxki. ");
INSERT INTO nplNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús ixkoya okimowikili, okinkalaki imajpilwah ijtik inakaswah, iwa ika ichijcha okitelkoli inenepil n tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Otlanki oontláchixki ilwikak, oelsijsiwik iwa okijto: —¡Efatá! —noni kijtosneki: ¡Ximotlapo! ");
INSERT INTO nplNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","San nima, inakaswah owalmotlapojkeh, iwa inenepil opajtik iwa opé yektlajtoa. ");
INSERT INTO nplNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iwa Jesús okinnawati amaka makitlapowikah, pero yejwah okachi otetlapowiayah. ");
INSERT INTO nplNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nochteh san omotlajtlachialtiayah iwa okijtoayah: —Semi kuali nochi tlan okichi, kichiwa matlakakikah non amo otlakakiah, iwa matlajtokah non amo oweletiah otlajtoaya. ");
INSERT INTO nplNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Se tonati miakeh tlakah omoololojkeh inawak Jesús, iwa amo okipiayah tlan kimomajsewiskeh. Ijkuakó Jesús okínnotski itlamachtijkawah iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Satlawel nikinmiknomati ninteh tlakah, porke ya kipiah eyi tonati nika kateh nowa, iwa mach kipiah tlan kikuaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tla nikintitlanis mawiah incha iwa ayamó tlakuah, weletis ik nonka wetsitiweh, porke sikimeh owalajkeh de wejka. ");
INSERT INTO nplNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Itlamachtijkawah okinankilijkeh: —Ik nika amaka chanti, ¿kan tikkuitiweh paj para tikintlakualtiskeh? ");
INSERT INTO nplNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús okintlajtlani: —¿Kech pameh nonkimpiah? Yejwah okilijkeh: —Chikome. ");
INSERT INTO nplNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús otlanawati mamotlajtlalikah nochteh n tlakah itech tlali. Ijkuakó Ye okinmónanki n chikome pameh iwa omotlasojkama inawak Dios. Otlanki okintlajtlápanki iwa okinmaktili itlamachtijkawah, iwa yejwah okinxejxelilijkeh nochteh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noiwa okimpixtokah sikimeh michintsitsinteh, iwa Jesús okintiochi, iwa otlanawati makinxejxelokah. ");
INSERT INTO nplNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nochteh otlakuajkeh iwa kuali oixwikeh, iwa tlan ayakmó okikuajkeh okoololojkeh iwa okintetemitijkeh chikome chikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Non otlakuajkeh okatkah kemi nawi mil. Satepa Jesús okinmaaka. ");
INSERT INTO nplNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iwa Ye otlejkok itech se barka iwa itlamachtijkawah, iwa oyajkeh kan tlali de Dalmanuta. ");
INSERT INTO nplNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ijkuakó n fariseos owalajkeh inawak Jesús iwa opé motlatlajtolkopah íwa. Yejwah okitlajtlaniliayah makinnextili se milagro de ilwikak san para kiyejyekoskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús oelsijsiwik iwa okinmili: —¿Tleka nonkitlajtlanih se milagro? De milajka nomechilia nomejwah mach nonkitaskeh nion se milagro de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ijkuakó okinkakajte iwa oksepa otlejkok itech barka, iwa opanok ik nepa lado de n lago de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Itlamachtijkawah n Jesús okilkajkeh kiwikaskeh n tlákuali itech barka iwa sanwel okiwikayah se paj. ");
INSERT INTO nplNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ijkuakó Jesús okinmili: —Ximotlachilikah de inlevadura n fariseos iwa de ilevadura n Herodes. ");
INSERT INTO nplNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Itlamachtijkawah n Jesús opé kimoliah: —Ijkí techilia porke amo otikwalikakeh paj. ");
INSERT INTO nplNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero Jesús okima tlan okimoliayah iwa okinmili: —¿Tleka non kimoliah amo ononkualikakeh nomopáj? ¿Amo nonkitah nion nonkajsikamatih? ¿Ok nonyoltlakuawatokeh? ");
INSERT INTO nplNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Nonkimpiah nonmoixtololowah iwa nomonakaswah, iwa amo nontlachiah nion nontlakakih? ¿Ayakmó nonkilnamikih? ");
INSERT INTO nplNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xikilnamikikah ijkuak onikintlakualti mákuili mil tlakah san ika mákuili paj, ¿kechmeh chikimeh ononkoololojkeh ika pantlapanalteh? Yejwah okinankilijkeh: —Májtlaktli iwa ome chikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Iwa ijkuak onikintlakualti nawi mil tlakah san ika chikome paj, ¿kech chikimeh ononkoololojkeh ika pantlapanalteh? Yejwah okijtojkeh: —Chikome. ");
INSERT INTO nplNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús oksepa okinmili: —¿Tleka kiné ayamó nonkajsikamatih? ");
INSERT INTO nplNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Satepa okalakitoh Betsaida, ompa okualikilijkeh n Jesús se tlakatl non amo otlachiaya iwa okitlatlautijkeh ipan makintlalili imawah. ");
INSERT INTO nplNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús okimatílanki n kókoxki iwa okikixti de altepetl. Ika ichijcha okinsiawili ixtololowah iwa okintlali imawah ipa, iwa okitlajtlani kox itla okitaya. ");
INSERT INTO nplNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ye opé tlachia, iwa okijto: —Nikinmita tlakah kemi yaskiah miskimeh, pero nejnentiwih. ");
INSERT INTO nplNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús oksepa okintlalili imawah ipan ixtololowah iwa okili matlatlachia, san nima n tlakatl oyektláchixki iwa opajtik. Iwa nochi kuali yokitaya. ");
INSERT INTO nplNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ijkuakó Jesús okitítlanki icha iwa okili: —Amo xikalaki kan altepetl, nion aka xikmatilti. ");
INSERT INTO nplNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Satepa Jesús iwa itlamachtijkawah oyajkeh kan altepemeh de Cesarea itech tlali de Filipo. Iwa ijkuak oyayah itech ojtli okintlajtlani: —¿Akin Ne, kimoliah n tlakah? ");
INSERT INTO nplNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yejwah otlanankilijkeh: —Sikimeh kijtoah Tejwatsi ti Juan Bautista, oksikimeh kijtoah Tejwatsi ti Elías noso ok se profeta. ");
INSERT INTO nplNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ijkuakó Jesús okintlajtlani: —Iwa nomejwah tlan nonkijtoah, ¿Akin Ne? Pedro okili: —Tejwatsi Ti Cristo. ");
INSERT INTO nplNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero Jesús okinnawati: —Amaka xikmatiltikah. ");
INSERT INTO nplNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ijkuakó Jesús opé kinmachtia: —Ne Non onimochi ni tlakatl nitlaijyowis miak iwa nechixnamikiskeh n tetajmeh non tlayakantokeh kan tiopa, iwa n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli nechmiktiskeh, pero ipan eyi tonati nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús ijkó okinmili para makajsikamatikah. Ijkuakó Pedro okiwík ixkoya n Jesús iwa opé kajwa. ");
INSERT INTO nplNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús omókopki iwa okintlajtlatak itlamachtijkawah, opé kajwa n Pedro iwa okili: —¡Xio de nika, satanás!, porke amo mitstekipachoa tlan Dios kimonekiltia, yej tlan kintekipachoa n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ijkuakó Jesús okínnotski n tlakah iwa itlamachtijkawah iwa okinmili: —Tla aka kinekis yetos notlamachtijkau, ayakmó makichiwa san tlan ye kineki, yej mawiki nonawak maya makimiktikah por nechtlakita. ");
INSERT INTO nplNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yika, akin kinekis mopalewis san ye inewia moixpolos. Pero akin kimiktiah por nechtlakita iwa por kitetlapowia itlajtol Dios, Ye kimakixtis. ");
INSERT INTO nplNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Porke ¿tlan ipati tla se tlakatl kitlani nochi tlan onka itech nin tlaltíkpaktli iwa kixpoloa ialma? ");
INSERT INTO nplNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Kech weletis kitlaxtlawas se tlakatl para makimakixti ialma? ");
INSERT INTO nplNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yika, akin pinawa de Ne iwa de notlajtol inmixpa ninteh tlakah tlajtlakolchijkeh iwa mekatánajteh, noiwa Ne Non onimochi ni tlakatl nipinawas de ye ijkuak niwalmuikas itech iweyijkachiwalis Notajtsi iwa iangelwah. ");
INSERT INTO nplNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús noiwa okinmili: —¡De milajka, nomechilia: sikimeh akimeh nika kateh mach mikiskeh asta ijkuak kitaskeh ya tlanawatijtok Dios ika nochi iweletilis! ");
INSERT INTO nplNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chikwase tonati satepa, Jesús oyá kan se tepetl, iwa sanwel okinwík n Pedro, Jacobo iwa n Juan, iwa ompa inyakapa, Jesús omoixpatlak. ");
INSERT INTO nplNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Itlake otsótlanki iwa omókopki istaktik kemi tesiwitl non amaka weletiskia ijkó kikawaskia, maya kitlawelpakaskia. ");
INSERT INTO nplNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Noiwa okitakeh Elías iwan Moisés non omotlapowijtokah iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ijkuakó Pedro okili n Jesús: —Tlamachti, sa kuali nika tikateh. Matikinchijchiwakah eyi akákalteh, se moaxka, se iaxka Moisés iwa ok se iaxka Elías. ");
INSERT INTO nplNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Itlamachtijkawah saikpanoa omomojtijkeh, yika n Pedro mach okimatia tlan okijtoaya. ");
INSERT INTO nplNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ijkuakó owaltemok se mextli iwa okinkemelo. Itech non mextli omokak se tlájtoli non okijtoayah: —Ye ni Nokone non niktlasojtla, xikkakikah. ");
INSERT INTO nplNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","San nima otlatlachixkeh ik nowia, iwa ayakmaka okitakeh, sanwel okitakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Iwa ijkuak owaltemoayah ikpak tepetl, Jesús okinnawati itlamachtijkawah: —Amaka xikmatiltikah tlan ononkitakeh, asta ijkuak Ne Non onimochi ni tlakatl manimoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yika, okitlaatijkeh nin tlájtoli maya omotlajtlaniayah tlan kijtosneki moyolitis oksepa. ");
INSERT INTO nplNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ijkuakó, okitlajtlanijkeh n Jesús: —¿Tleka kijtoah non kitemachtiah n tlanawatílistli achto wits Elías? ");
INSERT INTO nplNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús okinnankili: —Milák, Elías achto wits, iwa kiyektlalis nochi. ¿Iwa tlan kijtoa itlajkuilol Dios de Ne Non onimochi ni tlakatl? Kijtoa satlawel nitlaijyowis iwa n tlakah nechtlawelitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero Ne nomechilia Elías yowitsa, iwa n tlakah okitoktijkeh san tlan yejwah okinekeh, ijkó kemi ijkuilitok mochiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ijkuak okalakikoh kan okatkah miakeh tlakah, okinmajsitoh non oksikimeh itlamachtijkawah. Sikimeh non kitemachtiah n tlanawatílistli non omokualanijtokah iwan yejwah. ");
INSERT INTO nplNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","N tlakah satlawel omotlajtlachialtijkeh ijkuak okitakeh n Jesús iwa omotlelojkeh okitlajpalotoh. ");
INSERT INTO nplNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ijkuakó Jesús okintlajtlani: —¿Tleka nonmonanankiliah iwa n nekateh? ");
INSERT INTO nplNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iwa se tlakatl okijto: —Tlamachti, nika onimitswalikili nopiltsi, porke kipia se espíritu amokuali non amo kikawilia matlajto. ");
INSERT INTO nplNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iwa san kan yetos, n espíritu amokuali kitlamotla, iwa kitoktia makamapoposojkisa. Noiwa manejnetsonikah itlanwah iwa kisentititsa. Yonikintlatlaujtih motlamachtijkawah makikixtilikah n espíritu amokuali pero mach oweletkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús okinmajwak itlamachtijkawah: —¡Nomejwah mach nonnechneltokah! ¿Asta kemania nomechxikojtos? ¡Xikualikakah nika n télpochtli! ");
INSERT INTO nplNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","San nima okiwikakeh n télpochtli inawak Jesús, iwa ijkuak n espíritu amokuali okitak n Jesús, okitokti n télpochtli mamotlalwiteki, omotlalmemelo iwa okitokti makamapoposojkisa. ");
INSERT INTO nplNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ijkuakó Jesús okitlajtlani n teta: —¿Yowejka ijkó mochijtiwits mopiltsi? N teta okinankili: —Desde chokotsi. ");
INSERT INTO nplNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iwa miak welta kitlamotla itech tletl iwa kualchiwa ijtik atl porke kineki kimiktis. Yika, tla Tejwatsi weletis techpalewis, techiknomati iwa techpalewi. ");
INSERT INTO nplNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús okili: —¿Tleka techtlajtlania kox niweletis? Nochi weletis mochiwas para akin nechneltoka. ");
INSERT INTO nplNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ijkuakó ita n télpochtli owaltsajtsik: —¡Nitlaneltoka, pero techpalewi para okachi manitlaneltoka! ");
INSERT INTO nplNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ijkuak Jesús okitak opé moololoah miakeh tlakah, okijto: —Te espíritu amokuali non tiktoktia n télpochtli amo matlajto nion matlakaki, Ne nimitsnawatia xikkajkawa n télpochtli iwa ayakmó oksepa xiwalmokopa itech. ");
INSERT INTO nplNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","N espíritu amokuali otsajtsik iwa okitokti n télpochtli oksepa mamimiki, iwa okikakajte n télpochtli kemi non yomikki. N tlakah okijtoayah yomikki n télpochtli. ");
INSERT INTO nplNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús, okimakitski n télpochtli iwa okipalewi mamoketsa. ");
INSERT INTO nplNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Otlanki Jesús okalak ijtik se kali, iwa itlamachtijkawah okitlajtlanijkeh. —¿Tleka tejwah amo otiweletkeh otikkixtijkeh n espíritu amokuali? ");
INSERT INTO nplNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús okinmili: —Ninteh espíritus amokualteh sanwel mokixtia ika miak tiotsajtsílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ijkuak oyajkeh de ompa, opanokeh ik Galilea. Pero Jesús mach okinekia aka makimati, ");
INSERT INTO nplNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porke okinmachtijtoka itlamachtijkawah: —Ne Non onimochi ni tlakatl nechtemaktiskeh inmak n tlaltikpaktlakah, iwa nechmiktiskeh, pero ipan eyi tonati nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero itlamachtijkawah mach okajsikamatiah tlan Jesús okinmiliaya, iwa okimawiliayah kitlatlajtlaniskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ijkuakó okalakitoh Capernaúm, iwa ijkuak yokatkah ijtik kali, Jesús okintlajtlani itlamachtijkawah: —¿Tlan ononkimolijtiwalayah itech ojtli? ");
INSERT INTO nplNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero mach okinankilijkeh. Itech ojtli omokualanijtiwalayah porke okinekiah kimatiskeh akin okachi weyijkatitok. ");
INSERT INTO nplNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ijkuakó Jesús omotlali, iwa okínnotski n májtlaktli iwa ome itlamachtijkawah, iwa okinmili: —Akin kinekis kinyakanas oksikimeh, achto matetlakita iwa makipalewi san akin yetos. ");
INSERT INTO nplNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Satepa Jesús okónnotski se chokotsi iwa okontlali tlatlajkotia, otlanki okimonapalolti iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Akin kiselia se chokotsi kemi ni itech Notoka, Ne nechselia, iwa akin nechselia amo san Ne nechselia, yej noiwa kiselia Dios Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ijkuakó Juan okili n Jesús: —Tlamachti, otiktakeh se tlakatl non okinkixtiaya espíritus amokualteh itech Motoka. Tejwah otikilijkeh ayakmó ijkó makichiwa, porke ye amo nemi towah. ");
INSERT INTO nplNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero Jesús okinmili: —Amo xiktlakawaltikah, porke akin kichiwa se milagro itech Notoka, mach weletis fiero nechtenejtinemis. ");
INSERT INTO nplNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porke akin amo techtlawelita, kajki towah. ");
INSERT INTO nplNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Akin nomechtliokolis maya san se xikali atl itech Notoka nomejwah akimeh iaxkawah n Cristo. De milajka nomechilia ye kiselis itlaxtlawil. ");
INSERT INTO nplNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","'Akin kitoktis matlajtlakolchiwa se akin nechneltoka, okachi kuali makikechilpilikah se weyi tetl iwa makontlamotlakah ijtik weyi atl. ");
INSERT INTO nplNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tla moma mitstoktia xikchiwa tlajtlákoli, xikmotekili, okachi kuali xikalaki kan ilwikak timatepo, iwa amo tiajsitok mamitsontlamotlakah miktla, kan ayik sewis n tletl. ");
INSERT INTO nplNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Iwa tla mokxi mitstoktia xikchiwa tlajtlákoli, xikmotekili. Okachi kuali xikalaki kan ilwikak ti ikxitepo iwa amo tiajsitok mamitsontlamotlakah miktla. ");
INSERT INTO nplNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Iwa tla moixtololo mitstoktia xikchiwa tlajtlákoli, xikmokixtili. Porke okachi kuali xikalaki ilwikak san ika se moixtololo, iwa amo tiajsitok mamitsontlamotlakah miktla, ");
INSERT INTO nplNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kan okuilimeh ayik mikkih iwa n tletl ayik sewi. ");
INSERT INTO nplNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","'Porke nochteh n tlakah mopuyeliskeh ika tletl. ");
INSERT INTO nplNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","N istatl satlawel kuali, pero tla n istatl mach ok puyak, ¿kenomi weletis ika nontlapuyeliskeh? Nomejwah xiyetokah kemi n istatl non kuali iwa ximoyekwikakah. ");
INSERT INTO nplNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús okiski de Capernaúm iwa oyá kan tlali de Judea ik nepa lado de n río Jordán. Ompa oksepa omoololojkeh miakeh tlakah inawak, iwa Ye opé kinmachtia kemi nochipa okichiwaya. ");
INSERT INTO nplNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ijkuakó sikimeh fariseos omijkuanijkeh inawak Jesús para kitlajtoltlapololtiskeh iwa okitlajtlanijkeh: —¿Kox kuali tla se tlakatl kikajkawa isiwa? ");
INSERT INTO nplNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús okinnankili: —¿Tlan onomechnawati n Moisés? ");
INSERT INTO nplNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yejwah otlanankilijkeh: —Moisés okitekawili mamosiwakajkawa n tlakatl tla kimajmanilia se amatl kan kijtoa kikajkawas. ");
INSERT INTO nplNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ijkuakó Jesús okinmili: —Moisés onomechmák non tlanawátili porke satlawel ononyoltlakuawatokah. ");
INSERT INTO nplNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero itech ipewaya n tlaltíkpaktli, Dios okinchijchi “tlakatl iwa siwatl”. ");
INSERT INTO nplNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Yika n tlakatl kikajtewas ita iwa ina iwa moseitilis iwan isiwa, ");
INSERT INTO nplNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","iwa san ken ome mochiwaskeh se.” Yika ayakmó yetoskeh ome, yej san se. ");
INSERT INTO nplNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yika, tlan Dios yokiseitili, amaka makinxexelo. ");
INSERT INTO nplNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ijkuak yokatkah itech kali, itlamachtijkawah okitlajtlanilijkeh makinmajsikamatilti tlan okimilijka n fariseos. ");
INSERT INTO nplNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús okinmili: —Akin kikajkawa isiwa iwa monamiktia iwan ok se, nin tlakatl san kimomekatijtok iwa tlajtlakolchijtok inawak non achto isiwa, ");
INSERT INTO nplNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","iwa tla n siwatl kikajkawa iokich iwa monamiktia iwa ok se, nin siwatl noiwa san momekatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ijkuakó okwalinwikilijkeh n Jesús sikimeh pípilteh, para makintlalili imawah impah, pero itlamachtijkawah opé kinmajwah akimeh okwalinwikiliayah n pípilteh. ");
INSERT INTO nplNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ijkuak Jesús okimitak, okuálanki iwa okinmili itlamachtijkawah: —Xikinkawilikah n pípilteh mawikih nonawak, iwa amo xikintsakuilikah, porke akimeh yolyamankeh kemi pípilteh kalakiskeh kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","De milajka nomechilia, akin amo kikawilis Dios matlanawati itech iyolo kemi se chokotsi kimokawilia, non tlakatl ayik kalakis kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesús okinmonapaloltiaya n pípilteh iwa okintiochiwaya ijkuak okintlaliliaya imawah impah. ");
INSERT INTO nplNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ijkuak Jesús yoyaya de ompa, okalakiko se tlakatl, omotlankuáketski inawak iwa okili: —Kuali tlamachti, ¿tlan nikchiwas para nikpias n semijkak nonemilis? ");
INSERT INTO nplNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús okili: —¿Tleka techilia nikuali? Sanwel onka se Akin kuali, iwa Ye Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ya tikinmixmati n tlanawatílisteh: “Amo xitemikti, amo ximomekati, amo xitlachteki, amo xixolopijti, amo xitekajkayawa, iwa xikintlakita motajwah.” ");
INSERT INTO nplNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","N telpochtli okinankili: —Tlamachti, nochi noni ya nikchijtiwits desde ni telpochtli. ");
INSERT INTO nplNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús okitlasojkaitak iwa okili: —Ok se mitspoloa tikchiwas: xiknemakati nochi tlan tikpia, iwa n tomi, xikinxejxelili non amitla kipiah, ijkó tiktlawelpias kan ilwikak, iwa tiwits nowa. ");
INSERT INTO nplNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero ijkuak ijkó okikak, n telpochtli omoyolkokojtia porke saikpanoa okitlawelpiaya. ");
INSERT INTO nplNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ijkuakó Jesús okonimitak non okiyawalojtokah iwa okinmili itlamachtijkawah: —¡Kema owi kalakiskeh kan Dios tlanawatia akimeh kitlawelpiah! ");
INSERT INTO nplNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ninteh tlájtolteh san okintlajtlachialti itlamachtijkawah, pero Jesús oksepa okinmili: —Nopilwah, ¡owi kalakiskeh kan Dios tlanawatijtok akimeh kintlawelyoltilana n tomi! ");
INSERT INTO nplNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Okachi amo owi panos kan ixtololo n akuxa se riata iwa amo se non kitlawelpia tomi makalaki kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ijkuak okikakeh tlan okijto, okachi omotlajtlachialtijkeh iwa okimoliayah: —Tla ijkó, ¿akin weletis kalakis ilwikak? ");
INSERT INTO nplNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús okimixtlajtlatak iwa okinmili: —N tlakah kimoliskeh ayik weletis kichiwaskeh, pero Dios nochi weleti kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ijkuakó Pedro opé kilia n Jesús: —Noteko, tejwah otikkakajtejkeh nochi tlan otikpiayah, iwa otimitswaltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús okinankili: —De milajka nomechilia, akin kikawa icha, ikniwah, iweltiwah, itajwah, ipilwah, noso ialtépeu por kitetlapowia n kualitlájtoli, ");
INSERT INTO nplNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kiselis axa itech nin tlaltíkpaktli okachi de se siento: kalmeh, ikniwah, iweltiwah, itajwah, iwa itlalwah, maya noiwa kitotojtokaskeh, iwa itech non ok se tlaltíkpaktli, mach ok ayik mikkis yej nochipa yolitos. ");
INSERT INTO nplNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero miakeh non axa moweyiliah, satepa ayakmó weyijkatitoskeh, iwa miakeh non axa amo moweyiliah satepa kinweyijkatlaliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yoixtlejkotiayah Jerusalén, iwa Jesús okinyakantiaya itlamachtijkawah. Yejwah omotlajtlachaltijkeh iwa oyayah ika miak mawílistli. Ijkuakó Jesús oksepa okintlapowi n májtlaktli iwa ome itlamachtijkawah iwa opé kinmilia tlan mochiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iwa okinmili: —Xikitakah, axa tiixtlejkotiwih Jerusalén, kan Ne Non onimochi ni tlakatl nechtemaktiskeh inmak tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli. Yejwah nechtlajtlakoltiskeh iwa nechtemaktiskeh inmak n tlakah non amo judíojteh para manechmiktikah. ");
INSERT INTO nplNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ompa nechpijpinawiskeh, nechchijchawiskeh, nechtsonwitekiskeh iwa nechmiktiskeh, pero ipan eyi tonati nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ijkuakó Jacobo iwa n Juan, itelpochwah n Zebedeo, owalajkeh inawak Jesús iwa okilijkeh: —Tlamachti, timitsontlatlaujtiah techonchiwili tlan timitsontlajtlaniliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ijkuakó Ye okinmili: —¿Tlan nonkinekih manomechchiwili? ");
INSERT INTO nplNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iwa yejwah okinankilijkeh: —Techonkawili matimotlalikah monajnakastla kan titlanawatijtos, se ik moyekma iwa ok se ik moopochma. ");
INSERT INTO nplNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ijkuakó Jesús okinmili: —Nomejwah mach nonkimatih tlan nonkitlajtlanih. ¿Weletis nontlaijyowiskeh kemi Ne nitlaijyowis?, noso ¿weletis nonmokuaatekiskeh kemi Ne nimokuaatekis? ");
INSERT INTO nplNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yejwah okinankilijkeh: —Tiweletiskeh. Jesús okinmili: —De milajka nomejwah nontlaijyowiskeh iwa nontlaxikoskeh kemi Ne. ");
INSERT INTO nplNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero mach Ne Akin kijtos akin motlalis ik noyekma noso ik noopochma, yej Notajtsi kinmaktilis akimeh Ye yokimpéjpenki. ");
INSERT INTO nplNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ijkuak non ok májtlakteh itlamachtijkawah ijkí okikakeh, okualankeh iwan Jacobo iwa n Juan. ");
INSERT INTO nplNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jesús okínnotski iwa okinmili: —Nomejwah kuali nonkimatokeh itech wejweyi altepemeh, akimeh kintekiwajtlaliah pewa mosijsiniah innawak n tlakah de nonteh altepemeh, iwa akimeh tlayakantokeh chikawak pewa tlanajnawatiah. ");
INSERT INTO nplNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero nomowah amo ijkó yetos. Akin kinekis nomonawak moweyijkatlalis, moneki achto makimpalewi oksikimeh, ");
INSERT INTO nplNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","iwa tla aka de nomejwah kineki tlayakantos nomonawak, moneki makintekitili oksikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porke nonewia Ne Non onimochi ni tlakatl amo oniwala para manechtekitilikah yej para nikintekitilis oksikimeh iwa para nimotemakas manechmiktikah para ika noni niktlaxtlawas intemakixtilis miakeh. ");
INSERT INTO nplNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ijkuakó Jesús iwa itlamachtijkawah okalakitoh Jericó. Iwa ijkuak yokistiayah de Jericó, miakeh tlakah oyayah inwah. Ijkuakó se non amo otlachiaya akin itoka Bartimeo, ipiltsi n Timeo, oewatoka itempa n ojtli omotominijtlanijtoka. ");
INSERT INTO nplNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iwa ijkuak okikak Jesús de Nazaret ik ompa opanotiaya, opé kitsajtsilia: —¡Jesús, Ikone n David techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Miakeh okajwayah makitsakua ikamak, pero ye okachi otsajtsia: —¡Ikone n David, techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ijkuakó Jesús omóketski, iwa otlatítlanki makinotsatih. Yejwah okinotsatoh non amo otlachiaya iwa okilijkeh: —¡Ximoyolchikawa! Ximoketsa. ¡Jesús mitsnotsa! ");
INSERT INTO nplNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","N kókoxki okontlamotlak ikoto, omoketewak iwa omijkuani inawak Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ijkuakó Jesús okitlajtlani: —¿Tlan tikmonekiltia manimitstokti? Ye okinankili: —Tlamachti, nikneki nitlachias. ");
INSERT INTO nplNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús okili: —Ya weletis timuikas, por otechneltokak yotipajtik. San nima non amo otlachiaya owaltláchixki iwa oyá iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ijkuak ya onkalakiah Jerusalén, ayakmó wejka de Betfagé iwa Betania, iyakapa n olivostepetl, Jesús okintítlanki ome itlamachtijkawah, ");
INSERT INTO nplNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","iwa okinmili: —Xiwiah Betfagé, non kajki nepa tlayakapa, iwa san nima kan nonkalakitiweh nonkajsitiweh ilpitok se burro non ayamaka itech tlejkotika. Xiktojtomakah iwa techalikilikah. ");
INSERT INTO nplNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Iwa tla aka nomechtlajtlania tleka nonkitojtomah, xikilikah, n Toteko kimonekiltia, iwa san nima kitekopilis. ");
INSERT INTO nplNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Itlamachtijkawah oyajkeh iwa okajsitoh n burro ilpitok inakastla n kaltentli itech ojtli, iwa okitojtonkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iwa sikimeh non ompa okatkah okimilijkeh: —¿Tlan nonkichijtokeh? ¿Tleka nonkitojtomah n burro? ");
INSERT INTO nplNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yejwah okinnankilijkeh kemi Jesús okimilijka, iwa okinkawilijkeh mawiah. ");
INSERT INTO nplNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Okiwikakeh n burrojtsi ixpa Jesús, iwa okipejpechtilijkeh ika inkotonwah iwa Jesús otlejkok itech. ");
INSERT INTO nplNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Miakeh okisojkeh intlakeh itech ojtli, iwa oksikimeh okintsojtsontekiah inmamayowah n kuaujmeh iwa okinsojsóayah itech ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nochteh non otlayakantiayah iwa non owalayah tlakuitlapa, opé tsajtsih: —¡Hosanna! ¡Tlatiochíwali Akin wits itech Itoka n Toteko Dios! ");
INSERT INTO nplNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dios makitiochiwa Akin ya tlanawatis kemi otlanawati n totata David! ¡Hosanna! ¡Maweyijkachito Totajtsi Dios non moitstika ilwikak! ");
INSERT INTO nplNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús okalakito Jerusalén iwa milaktik okalakito kan Weyi Tiopa. Satepa ijkuak sentetl yotlajtlachiato, oyá kan altepetl de Betania iwa n májtlaktli iwa ome itlamachtijkawah porke yotleyuatoka. ");
INSERT INTO nplNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ijkuak owalmostlatik okiskeh de Betania iwa Jesús owalxitlatlak itech ojtli. ");
INSERT INTO nplNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iwa san wejka okonitak se igoskuawitl non kualtsi oxopiawatoka. Oyá okitlatemolito, pero amitla okajsik, sanwel ixiujyo ken ayamó owalajsia n tonati ijkuak tlaaki. ");
INSERT INTO nplNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ijkuakó Jesús okili n igoskuawitl: —¡Ayik makikuakah motlakilo! Iwa itlamachtijkawah otlakaktokah. ");
INSERT INTO nplNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ijkuak okalakitoh Jerusalén, Jesús oyá kan Weyi Tiopa iwa opé kualinkikixtia akimeh ompa otlanamakatokah iwa otlakojtokah. Okinxitronkopili inmesajwah akimeh otomintlapatlatokah iwa insiyajwah akimeh okinemakatokah palomajtsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iwa amo okitekawiliaya aka makitlajkomilawa n Weyi Tiopa ika itla itlamamal. ");
INSERT INTO nplNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iwa ijkí okinmachtiaya: —Itech itlajkuilol Dios kijtoa: “Nocha kinotsaskeh kali kan motiotsajtsiliskeh nochteh n tlaltikpaktlakah”, pero nomejwah yononkikopkeh se kúyoktli de ichtekeh. ");
INSERT INTO nplNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","N tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli okimatkeh tlan Jesús okichi kan Weyi Tiopa, iwa opé kitemoliah kenijki weletis kimiktiskeh. Yejwah okimawiliayah porke nochteh n tlakah de non altepetl omotlajtlachialtiayah de itlamachtilis. ");
INSERT INTO nplNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iwa ijkuak owaltiotlatik, Jesús iwa itlamachtijkawah okiskeh de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ijkuak owalmostlatik, iwa opanokeh kan igoskuawitl, okitakeh yowaka asta inelwayo. ");
INSERT INTO nplNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ijkuakó Pedro okualilnamik, iwa okili n Jesús: —Tlamachti, xikita, n igoskuawitl non otikajwak yowaki. ");
INSERT INTO nplNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús okinnankili: —Xitlaneltokakah inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","De milajka nomechilia, tla aka kilis nin tepetl: “Ximoachiwa iwa ximomanati itech weyi atl”, iwa ika nochi iyolo kineltoka milák mochiwas, ijkó tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yika nomechilia: Nochi tlan nonkitlajtlaniskeh itech nomotiotsajtsilis, xikneltokakah kemi yaskia yononkiselijkeh, iwa Totajtsi Dios nomechmaktilis. ");
INSERT INTO nplNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iwa ijkuak non motiotsajtsiliskeh, tla aka nonkikokoliah, xiktlapojpolwikah, ijkó noiwa Nomotajtsi Dios non kajki ilwikak manomechtlapojpolwi. ");
INSERT INTO nplNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tla nomejwah amo nontetlapojpolwiah, Nomotajtsi non kajki ilwikak, noiwa amo nomechtlapojpolwis de nomotlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Satepa oksepa omokopkeh Jerusalén. Iwa ijkuak Jesús otlajtlachixtinemia itech n Weyi Tiopa, omijkuanijkeh inawak n tiopixkeh non tlayakantokeh, non kitemachtiah n tlanawatílistli iwa n tetajmeh non tlayakantokeh kan tiopa, ");
INSERT INTO nplNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","iwa okitlajtlanijkeh: —¿Akin omitsmák tekiwajyotl para ijkó tikchiwas? ");
INSERT INTO nplNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús okinnankili: —Ne noiwa nomechtlajtlanis, iwa tla nonnechnankiliskeh, Ne nomechilis akin onechmák nin tekiwajyotl. ");
INSERT INTO nplNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Akin okinawati n Juan matlakuaateki, Dios noso n tlakah? Technankilikah. ");
INSERT INTO nplNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ijkuakó san yejwah opé motlatlajtolkopah, iwa okimoliayah: —Tla tikiliskeh Dios okinawati, Ye techilis: “Tla ijkó, ¿tleka mach ononkineltokakeh?” ");
INSERT INTO nplNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amo weletis tikiliskeh san tlakah okinawatijkeh. Yejwah okinmawiliayah n tlakah porke nochteh okimatiah Juan milák ye se profeta. ");
INSERT INTO nplNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yika, otlanankilijkeh: —Amo tikmatih. Ijkuakó Jesús okinmili: —Ne noiwa mach nomechilis akin onechmák nin tekiwajyotl. ");
INSERT INTO nplNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ijkuakó Jesús opé kintlapowia ika tlapoálisteh iwa okinmili: —Se tlakatl okintojtook uvaskuaujmeh itech itlala iwa nochi okitsatsak. Otlanki okichijchi se tanke kan kimpatskas n uvasteh noiwa okichijchi se torre para kimokuitlawis itlatok. 'Satepa, itlala okinkajtewili makimokuitlawikah sikimeh uvastekitkeh para makitekitilikah, iwa oyá wejka. ");
INSERT INTO nplNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ijkuak oajsiko n tonati para motekis n uvas, n tekowa okitítlanki se itlakewal para makintlajtlaniliti n uvastekitkeh tlan iaxka. ");
INSERT INTO nplNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero yejwah okikitskijkeh iwa okiwitekeh, iwa okonewaltijkeh mapijpilkati. ");
INSERT INTO nplNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","N tekowa okontítlanki ok se itlakewal. Pero nin itlakewal okimojmotlakeh ika tetl, okikuatlapankeh iwa okiwijwikaltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","N tekowa oksepa okontítlanki ok se itlakewal, iwa nin itlakewal okimiktijkeh. Satepa okintitlantiah oksikimeh, sikimeh okinwitekeh iwa oksikimeh okinmiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","'Iwa iksemi sa ipiltsi omokawaya, non san ye se itlasoj, iwa okintitlanili porke okimoliaya: “Nopiltsi, kema kitlakitaskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero nekateh uvastekitkeh okimolijkeh: “Ye ni akin kimokawis nochi; matikmiktikah iwa tejwah tikmokawiskeh tlan kiaxkatiliskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Iwa okikitskijkeh, okimiktijkeh iwa okontlamotlatoh kala. ");
INSERT INTO nplNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ijkuakó Jesús okintlajtlani: —Axa ¿tlan nonkiyejyekoliah kichiwas n tekowa de non lawerta? Wits kinmiktiki nonteh tekitkeh, iwa ilawerta kinmaktilis oksikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Mach ayamó nonkiamapoah itlajkuilol Dios kan kijtoa: N tetl non kalchijchijkeh ik nepa okontlakaltechojkeh, yomochiwako n tetl non okachi tetlakxili. ");
INSERT INTO nplNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ye nin tlan Toteko okichi, iwa techtlajtlachialtia. ");
INSERT INTO nplNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ijkuakó okitemoliayah kenijki kitsakuaskeh n Jesús, porke okajsikamatiah non tlapoálistli yejwah okinmili. Pero yejwah okinmawiliayah n tlakah, yika okikajkeh n Jesús iwa oyajkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Satepa okintitlanilijkeh n Jesús sikimeh fariseos iwa sikimeh itekitwah n Herodes, para kitlajtoltlapololtiskeh iwa ijkó weletis kitlajtlakoltiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yejwah okitakoh n Jesús iwa okilijkeh: —Tlamachti, tikmatokeh Tejwatsi tinemi ika moyolo chipawak iwa tikijtoa tlan milák iwa amo timotlachilia ijkuak mitskakih, yej titemachtia tlan milák. ¿Kox kuali matiktlaxtlawakah impuesto inawak César? ¿Tikpiah tiktlaxtlawaskeh noso amó? ");
INSERT INTO nplNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero ken Jesús yokimatia íxkopteh, yika okinmili: —¿Tleka nonkinekih manimotlapololti? Techalikilikah se platajtomi manikita. ");
INSERT INTO nplNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yejwah okititijkeh n platajtomi, iwa ijkuak Jesús okitak, okintlajtlani: —¿Akin ixko iwa akin itoka nika ijkuilitok? Yejwah okilijkeh: —De César. ");
INSERT INTO nplNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ijkuakó Jesús okinmili: —Xikmakakah n César tlan iaxka n César, iwa xikmakakah Dios tlan iaxka n Dios. Yejwah san omotlajtlachialtijkeh kenijki otlanankili. ");
INSERT INTO nplNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ijkuakó owalajkeh sikimeh saduseos inawak Jesús. Ninteh saduseos kijtoah non yomikkeh ayakmó moyolitiah, yika okitlajtlanijkeh: ");
INSERT INTO nplNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tlamachti, Moisés otechmachtih, tla se tlakatl non ya kipia isiwa mikki, iwa amo okímpixki ipilwah iwan isiwa, se ikni moneki monamiktis iwan iknosiwatl. Ijkó non yomikki ya kimpias ipilwah. ");
INSERT INTO nplNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yowejka okatkah chikome iknimeh. Non teteachka omonamikti pero omikki iwa nion se ikone okikajtewili isiwa. ");
INSERT INTO nplNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ijkuakó itsoyo omonamikti iwan iknosiwatl, pero noiwa omikki iwa amo okikajtewili nion se ikone n iknosiwatl, iwa noijkó omochi non ipan eyi iknimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ijkó n chikome iknimeh omonamiktijtiajkeh iwa non siwatl, pero nion se okikajtewili se ikone. Sa iksemi noiwa omikki n siwatl. ");
INSERT INTO nplNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Axa, ijkuak moyolitiskeh non yomikeh, ¿de akin yetos tesiwa?, porke n chikome iknimeh omonamiktijtiajkeh iwa non siwatl. ");
INSERT INTO nplNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ijkuakó Jesús okinnankili: —Nomejwah nonkuatlapolojtokeh, porke mach nonkajsikamatih itlajkuilol Dios nion iweletilis. ");
INSERT INTO nplNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porke ijkuak non yomikeh moyolitiskeh, mach ok monamiktiskeh nion kintemakaskeh impilwah mamonamiktikah, porke yetoskeh kemi ángelteh non kateh ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero tla nomejwah nonnechtlajtlanijtokeh kox moyolitiah non yomikkeh, ¿mach ayamó nonkiamapoah itlajkuilol Moisés, kan techmatiltia kenijki Dios okitlapowi n Moisés itech n tlátsmoli non otlatlatoka? Dios okili n Moisés: “Ne Idios Abraham, Isaac, iwa Jacob.” ");
INSERT INTO nplNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Dios mach Dios de akimeh yomikkeh, yej de akimeh yolitokeh!, yika nomechilia nomejwah nonkuatlapolojtinemih. ");
INSERT INTO nplNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Seme non kitemachtia n tlanawatílistli, keman okikak Jesús kuali okinnankili n saduseos non okinekia mamotlajtoltlapololti. Omijkuani inawak Jesús iwa okitlajtlani: —¿Katlie itlanawatil Dios okachi weyi kijtosneki? ");
INSERT INTO nplNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús okinankili: —N tlanawátili non okachi weyi kijtosneki, ye ni: “Xikkaki Israel, n Totajtsi Dios sanwel Ye se.” ");
INSERT INTO nplNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","“Xiktlasojtla Moteko Dios ika nochi moyolo, ika nochi moalma, ika nochi motlalnamikilis iwa ika nochi mochikawalis.” ");
INSERT INTO nplNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iwa non ipan ome tlanáwatili noiwa kijtoa: “Xiktlasojtla mokni kemi te timotlasojtla.” Amo onkateh oksikimeh tlanawátilteh okachi wejweyih kemi ninteh ome. ");
INSERT INTO nplNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ijkuakó n tlamachti okili: —Kuali ka, Tlamachti. Milák tlan tikijtoa: Sanwel onka se Dios, iwa amo onka ok se kemi Ye. ");
INSERT INTO nplNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tikpiah tiktlasojtlaskeh Dios ika nochi toyolo, ika nochi totlalnamikilis, ika nochi toalma iwa ika nochi tochikawalis, iwa tiktlasojtlas mokni, kemi te timotlasojtla, ika noni okachi tikyolpaktiah Dios iwa amo ijkuak titlamanah noso tikchichinoah se yolkatl. ");
INSERT INTO nplNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús okikak nin tlamachti otlanankili kemi akin ixtlamati, yika okili: —Te amo tika wejka kan Dios tlanawatijtok. Ijkuakó, ayakmaka omixewi kitlajtlanis itla n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús otlamachtijtoka kan Weyi Tiopa iwa okijto: —¿Kenomi kijtoah non kitemachtiah n tlanawatílistli, Cristo Ikone n rey David? ");
INSERT INTO nplNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porke inewia n David okijto ijkuak n Espíritu Santo okitlajtolyákanki: Toteko Dios okili n Noteko: “Ximotlali ik nomayekma, asta manikintlali moikxitla akimeh mitskokoliah.” ");
INSERT INTO nplNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tla inewia n David kinotsa Noteko n Cristo, ¿kenomi n Cristo weletis yetos ikone n David? Iwa tlawelmiakeh tlakah okikakiah n Jesús ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Itech itlamachtilis n Jesús okijtoaya: —Ximotlachilikah inmak non kitemachtiah n tlanawatílistli, porke kiwilitah nemiskeh ika kuajkualteh tlakemeh weweyakeh, noiwa kiwilitah makintlajpalokah teixpa iwa makintlakitakah miak. ");
INSERT INTO nplNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yejwah kiwilitah moyayantiskeh tlayakapa itech sinagogas iwa itech ilwimeh, ");
INSERT INTO nplNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","iwa kintlakijkixtiliah n iknosiwameh, iwa para kinmixtlaatiskeh intlajtlakolwah saikpanoa motiotsajtsiliah. Yejwah kiseliskeh okachi weyi tlaijyowílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Se tonati Jesús oewatoka iyakapa n kaxajtomi kan Weyi Tiopa de Jerusalén, iwa okintlajtlatoka kenijki okontlaliayah tomi ijtik kaxa. Miakeh non okitlawelpiayah, okontlaliayah miak tomi. ");
INSERT INTO nplNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ijkuakó owala se probe iknosiwatl iwa okonintlali ome tomimeh de kobre, non amo miak impati. ");
INSERT INTO nplNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ijkuakó Jesús okínnotski itlamachtijkawah iwa okinmili: —De milajka nomechilia, nin probe iknosiwatl, okachi okitemák iwa amo kemi oksikimeh. ");
INSERT INTO nplNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porke nochteh okitemakakeh tlan ayakmó kitekitiltiah, pero nin iknosiwatl, okitemák nochi tlan ika panotoskia. ");
INSERT INTO nplNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Keman Jesús okistiaya de kan Weyi Tiopa, se itlamachtijkau okili: —¡Tlamachti, xikoninmita ninteh wejweyi temeh, iwa kuajkualteh n kalmeh! ");
INSERT INTO nplNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús okinankili: —¿Tikinmita nochteh ninteh wejweyijtikeh kalmeh? Mach ok mokawas nion se tetl ipan ok se. Nochi kixixititsaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ijkuakó Jesús iwa itlamachtijkawah oyajkeh kan olivostepetl, non mokawa iyakapa n Weyi Tiopa de Jerusalén. Iwa ijkuak Jesús omosewijtoka, Pedro, Jacobo, Juan iwa Andrés okiichtakatlajtlanitoh: ");
INSERT INTO nplNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Weletis techilis, ¿kemania ijkó tlamochiwas? ¿Iwa tlan achto techmonextilis ijkuak ya pewas ijkó tlamochiwas? ");
INSERT INTO nplNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús opé kinmilia: —Kuali ximotlachilikah, amaka manomechkajkayawa. ");
INSERT INTO nplNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porke miakeh witseh iwa kijtoskeh: “Ne Ni Cristo”, iwa miakeh kinkajkayawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Ijkuak nonkikakiskeh sentetl itech nin tlaltíkpaktli momijmiktilo, amo ximomojtikah saman ijkó tlamochiwas. Pero ayamó tlajtlamis n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porke se nasión momakas iwa ok se nasión, iwa se gobierno momakas iwa ok se gobierno. Sentetl tlalolinis iwa yetos apisotl, ijkó pewas n tlaijyowílistli, kemi se siwatl ijkuak pewa kitsopitia itlalax iwa ya tlakatis ikone. ");
INSERT INTO nplNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'Ximotlachilikah nomonewiah, porke nomechtemaktiskeh inmak tekiwajkeh, iwa nomechtsonwitekiskeh kan sinagogas. Nomejwah nonkalakitiweh innawak gobernadormeh iwa reyes por nonnechtlakitah, ijkó weletis nontetlapowiskeh de Ne. ");
INSERT INTO nplNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero achto moneki mamotematilti n kualitlájtoli itech nochi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Iwa ijkuak nomechtemaktitiweh inawak tekiwajkeh, amo ximotekipachokah nion xikmolikah tlan nonkijtoskeh. Nomejwah xikijtokah tlan Dios nomechilis, amo nomejwah nontlajtoskeh, yej n Espíritu Santo Akin tlajtos. ");
INSERT INTO nplNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","N teikni kitemaktis ikni makimiktikah, iwa n teta kitemaktis ipiltsi makimiktikah, iwa n tepilwah kinmixnamikiskeh intajwah iwa kinmiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nochteh nomechkokoliskeh ken nonnechtlakitah, pero akin mochijchikawas iwa kixikos nochi, momakixtis. ");
INSERT INTO nplNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","'Pero ijkuak nonkitaskeh tlan teyolijtlakoa moketos kan Weyi Tiopa, kan amo moneki yetos, ijkuakó akimeh yetoskeh Judea, macholokah kan tepemeh. Akin kiamapoas makajsikamati, ");
INSERT INTO nplNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","iwa itech non tonati, akin yetos ikpak ikal amo mawaltemo makikixtiki itla; ");
INSERT INTO nplNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","iwa akin yetos itlala amo mawalmokopa icha makikuiki itlake. ");
INSERT INTO nplNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Miálmasteh, n siwameh akimeh itech nonteh tonatijmeh yetoskeh kokoxkeh de konetl noso akimeh kimpiaskeh impilwah non ok chichih! ");
INSERT INTO nplNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ximotiotsajtsilikah, para ijkuak ijkó tlamochiwas amo mayeto itech sewaya. ");
INSERT INTO nplNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porke itech nekateh tonatijmeh yetos tlaijyowílistli satlawel temojti, kemi ayik motika desde ijkuak Dios okichijchi nin tlaltíkpaktli, nion mach ayik oksepa ijkó tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iwa tla Toteko Dios amo kintsikitsintiliskia nonteh tonatijmeh de tlaijyowílistli, amaka makisaskia. Pero okintsikitsintili porke kintlasojtla iaxkawah, non Ye okimpéjpenki. ");
INSERT INTO nplNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","'Ijkuakó, tla aka nomechilia: “Xikitakah nika ka n Cristo”, noso “Xikitakah, nepa ka”, amo xikneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porke monextiskeh tlakah tekajkayajkeh non kijtoskeh yejwah cristos iwa profetas. Yejwah kinchiwaskeh milagros noso kinnextiskeh neskáyolteh para tekajkayawaskeh, iwa tla weletis noiwa asta akimeh Dios yokinmopejpenili kinkajkayawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero ¡kuali ximotlachilikah! Ne yonomechnejmachti. ");
INSERT INTO nplNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","'Itech nekateh tonatijmeh, ijkuak yopanok n tlaijyowílistli, n tonati walsewis iwa n metsi ayakmó techtlawilis. ");
INSERT INTO nplNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","N sítlalteh walwetsiskeh de ilwikak, iwa n chikawálisteh non kateh ilwikak bibiokaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ijkuakó nonnechitaskeh Ne Non onimochi ni tlakatl niwaltemotiwits itech mextli ika weyi weletílistli iwa weyílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tlamis nikwalintitlanis noangelwah makinmoololokih non Ne onikinpéjpenki de n nawi ejekameh itech nin tlaltíkpaktli asta n ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","'Xikajsikamatikah tlan onomechmachti de n igoskuawitl: ijkuak imamayowah seliah, iwa pewa mokopinah, nomejwah nonkimatih ya ajsiki n tonala. ");
INSERT INTO nplNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ijkó noiwa, ijkuak nonkitaskeh ya pewa ijkó tlamochiwa, xikmatikah Ikone n Totajtsi Dios ya walkalakiki. ");
INSERT INTO nplNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","De milajka nomechilia nochi ni tlamochiwas achto de mijmikiskeh n tlakah de ninteh tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","N ilwikak iwa n tlaltíkpaktli pojpoliwiskeh pero tlan Ne yonikijto saman mochiwas. ");
INSERT INTO nplNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","'N tonati iwa n ora ijkuak ijkó tlamochiwas, amaka kimati, nion ángelteh non kateh ilwikak, nion Ikone n Totajtsi Dios. Sanwel Totajtsi kimati. ");
INSERT INTO nplNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","'Yika nomejwah xiijsatokah, xiyektlachixtokah iwa ximotiotsajtsilijtokah, porke mach nonkimatih kemania kalakiki non tonati. ");
INSERT INTO nplNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni tlamochiwas kemi ijkuak se tlakatl yawi wejka, pero ijkuak ya oonewas, achto kinnajnawatijtewah itlakawah makimokuitlawilikah icha, kinmajmakatewa inteki iwa n kaltentlamokuitlawi kilia mayektlamokuitlawi. ");
INSERT INTO nplNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yika nomejwah xiijsatokah, porke mach nonkimatih kemania ajsiki n tekowa de non kali, kox tiótlaki, tlajkoyuak noso kualka ijkuak tlakuika n kaxtil, ");
INSERT INTO nplNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","amo kichiwa walkalakiki iwa nomechajsiki nonkochtokeh. ");
INSERT INTO nplNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tlan nomejwah nomechilia, noiwa nochteh nikinmilia: Xiijsatokah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sa ome tonati opolitoka para n ilwitl de Paskua, ijkuak n judíojteh kikuah n paj non amo kipia levadura. N tiopixkeh non tlayakantokeh iwa n tlamachtijkeh de itlanawatil Moisés, okitemoliayah kenijki tlakajkayawaskeh para kikitskiskeh n Jesús iwa kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero okimoliayah: —Amo tikkitskiskeh itech ilwitl de Paskua, para amo matikimpajsolokah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús okatka Betania icha n Simón non achto okipiayah lepra. Ijkuak Jesús oewatoka kan mesa, owala se siwatl non okwalikaya se tekontsi tentok ika ajwiálistli de nardo non satlawel patío. Okitlápanki n tekontsi iwa n ajwiálistli okikuaxawili n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sikimeh non ompa okatkah okualankeh iwa okimolijkeh: —¿Tleka san okixpolo nin ajwiálistli? ");
INSERT INTO nplNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Weletiskia monamakaskia ika eyi siento denariojtomi, para ika se kimpalewiskia n próbesteh. Iwa okualantokah íwa. ");
INSERT INTO nplNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús okijto: —Xikkawakah; ¿tleka nonkikuejsoah? Tlan onechchiwili satlawel kuali. ");
INSERT INTO nplNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Porke n próbesteh nochipa nonkimpixtoskeh nomowah, iwa weletis nonkimpalewiskeh san ijkuak nonkinekiskeh. Pero Ne amo nochipa nonnechpixtoskeh nomowah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nin siwatl okichi tlan owéletki, porke yonechajwiali para ijkuak nechtookaskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","De milajka nomechilia itech nin tlaltíkpaktli kan motetlapowis n kualitlájtoli de Dios, noiwa sentetl motetlapowis tlan okichi nin siwatl, iwa ijkó se kilnamikis. ");
INSERT INTO nplNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ijkuakó Judas Iscariote, seme de n májtlakteh iwa ome itlamachtijkawah, oyá omotlatlapowito iwan tiopixkeh non tlayakantokeh para kinmaktilis n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ijkuak okikakeh tlan okimilito, opakeh, iwa omokajkeh kimakaskeh tomi. Ijkuakó Judas opé kitemolia kemania okachi kuali para kinmaktilis n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Itech ipewaya n ilwitl de Paskua ijkuak mokua n paj non amo kipia levadura, ijkuak noiwa okimiktiayah n ichkakonetl itech ilwitl de Paskua, itlamachtijkawah n Jesús okitlajtlanijkeh: —¿Kani tikmonekiltia matimitsmajmanilitih n tlákuali de Paskua? ");
INSERT INTO nplNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ijkuakó okintítlanki ome itlamachtijkawah iwa okinmili: —Xiwiah kan altepetl, ompa nonkitaskeh se tlakatl non kimamajti se axoktsi. Xiwiah kan ik ye yawi, ");
INSERT INTO nplNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","iwa kan kalakis, xikilikah n tekowa: “N tlamachti tlajtlani: ¿Katlie n kali kan nikmomajsewis n tlákuali de Paskua iwa notlamachtijkawah?” ");
INSERT INTO nplNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ye nomechititis se weyi kuarto non kajki tlakpak. Non ya tlamajmantok. Ompa xikmajmanakah n tlákuali non tikmomajsewiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Itlamachtijkawah oyajkeh iwa okalakitoh kan altepetl. Yejwah otlaajsikeh ijkó kemi Jesús okinmili, iwa okimajmankeh n tlákuali de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ijkuak owaltiotlatik, Jesús okalakito iwa n májtlakteh iwa ome itlamachtijkawah itech non kali. ");
INSERT INTO nplNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iwa ijkuak otlakuajtokah kan mesa, Jesús okinmili: —De milajka nomechilia non seme, akin tlakuajtok nowa, nechtemaktis. ");
INSERT INTO nplNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ijkuakó yejwah omoyolkokojkeh, iwa se por se opé kitlajtlania: —¿Ne nimitstemaktis? Iwa ok se noiwa okijto: —¿Noso ne nimitstemaktis? ");
INSERT INTO nplNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús okinmili: —Seme de non májtlakteh iwa n ome, akin tlapalojtok itech noplato. ");
INSERT INTO nplNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","De milajka nomechilia, Ne Non onimochi ni tlakatl nimochiwas kemi kijtoa itlajkuilol Dios, pero ¡probe n tlakatl non nechtemaktis! Okachi kuali amo tlakatiskia. ");
INSERT INTO nplNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ijkuak otlakuajtokah, Jesús okónanki n paj, omotlasojkama inawak Dios, okitlajkotlápanki iwa okinmák makimomajsewikah iwa okinmili: —Xikmomasewikah nin paj, ye ni nokuerpo. ");
INSERT INTO nplNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Otlanki okónanki se kopa, iwa ijkuak yomotlasojkama inawak Dios. Okinmaktili itlamachtijkawah iwa nochteh okonikeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iwa okinmili: —Ye ni noesso non ika timotlajtolsenkawa, nin noesso motoyawas para miakeh makintlapojpolwikah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","De milajka nomechilia, ayakmó nikonis iayo n uvas, asta neká tonati ijkuak nikonis n yankuik vino kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Keman okitlakuikakeh se salmo, oyajkeh kan olivostepetl. ");
INSERT INTO nplNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iwa ompa Jesús okinmili: —Nochteh nomejwah nonnechkakajtewaskeh nin yúali, porke itech itlajkuilol Dios kijtoa: “Nikmiktis n tlájpixki, iwa n ichkameh moxexeloskeh.” ");
INSERT INTO nplNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ijkuak nimoyolitis, nomechyakantias para Galilea. ");
INSERT INTO nplNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ijkuakó Pedro okili: —Malki nochteh mamitskakajtewakah, ne amo nimitskakajtewas. ");
INSERT INTO nplNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús okili: —De milajka nimitsilia, nin yúali, achto de tlakuikas n kaxtil ome welta, ijkuakó te yotikijto eyi welta amo techixmati. ");
INSERT INTO nplNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro okachi omotlajtolchijchika iwa okili: —Malki mowa manechmiktikah, mach ayik nikijtos amo nimitsixmati. Noiwa n oksikimeh itlamachtijkawah ijkó okijtojkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Satepa oyajkeh kan se lojar non itoka Getsemaní, iwa n Jesús okinmili itlamachtijkawah: —Nika ximotlalikah, Ne nio nimotiotsajtsiliti. ");
INSERT INTO nplNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ijkuak Jesús omotiotsajtsilito okinwík n Pedro, Jacobo iwa n Juan, iwa ompa opé moyolkokoa iwa omotekipachoaya. ");
INSERT INTO nplNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Niman okinmili: —Satlawel nimoyolkokoa, asta nikmachilia nomikilis. Nika ximokawakah iwa xiijsatokah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iwa n Jesús onéjnenki okachitsi tlayakapa, omotlankuáketski asta okitelko n tlali ika ixkuak, iwa okitlatlaujti Dios, tla Ye okimonekiltiaya amo makikawili matlaijyowi itech non ora. ");
INSERT INTO nplNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iwa itech itiotsajtsilis okijto: —Abba, Notajtsi, Tejwatsi nochi weleti tikchiwa; xikachiwa nin tlaijyowílistli non wits notech, pero amo mamochiwa kemi Ne nikneki, yej kemi Tejwatsi tikmonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Otlanki omókopki kan eyi itlamachtijkawah iwa okinmajsito kojkochtokeh, iwa okili n Pedro: —Simón, ¿tikochtok? ¿Nion se ora amo otikxiko tiijsatok? ");
INSERT INTO nplNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xijsatokah iwa ximotiotsajtsilikah, para amo manomechyoltilana n tlajtlákoli. Nomoespíritu kineki kichiwas tlan kuali, pero nomokuerpo amo tlaxikoa. ");
INSERT INTO nplNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús oksepa omotiotsajtsilito iwa okojpatili itiotsajtsilis. ");
INSERT INTO nplNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ijkuak omokopato, oksepa okinmajsito kochtokeh, porke okochmikiah. Iwa amo okimatiah tlan kinankiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Omokopato ipan eyi welta iwa okinmili: —¿Ok non kochtokeh iwa ok nonmosewiah? ¡Xiijsakah! Yoajsiko n ora, Ne Non onimochi ni tlakatl nechtemaktiskeh inmak tlajtlakolchijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Ximewakah, tiawih! Ompa wits akin nechtemaktis. ");
INSERT INTO nplNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ok otlajtojtoka ijkuak okalakiko n Judas, seme de n májtlakteh iwa ome itlamachtijkawah. Judas okwalinwikaya miakeh tlakah non okinmakitskijtiwalayah espadas iwa kuaujmeh. Ninteh tlakah okwalintitlankeh n tiopixkeh non tlayakantokeh, non kitemachtiah n tlanawatílistli iwa n tetajmeh non tlayakantokeh kan tiopa. ");
INSERT INTO nplNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas non yokiichtakatemakatoka yokinmilijka: —Akin ne nikixtennamikis, ye n Jesús, xikkitskikah iwa kuali xikmokuitlawijtiwiah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ijkuak Judas okalakito inawak Jesús, okili: —Tlamachti. Iwa okiixtennamik. ");
INSERT INTO nplNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ijkuakó okikitskijkeh n Jesús, iwa okiwikakeh. ");
INSERT INTO nplNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero seme de itlamachtijkawah n Jesús, okualkópinki iespada iwa okinakastsontek se itlakewal n tiópixki non okachi otlayakantoka. ");
INSERT INTO nplNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ijkuakó Jesús okinmili n tlakah: —¿Ononwalajkeh ononnechkitskikoh ika espadajteh iwa ika kuawitl kemi niyetoskia nitlachtek? ");
INSERT INTO nplNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nochi tonati onitlamachtiaya nomonawak kan Weyi Tiopa, iwa ayik ononnechkitskijkeh. Pero moneki tlamochiwas kemi kijtoah n tiotlajkuíloli. ");
INSERT INTO nplNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ijkuakó nochteh itlamachtijkawah n Jesús ochocholojkeh iwa okikakajtejkeh iselti. ");
INSERT INTO nplNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Se télpochtli non okikuitlapantokatiaya n Jesús iwa okemelitiaya san ika se mantajtsótsoli, noiwa okikitskijkeh, ");
INSERT INTO nplNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero ye okinmoxolkopinili iwa okinkakajtewili imantajtsótsol iwa ocholo xipetstik. ");
INSERT INTO nplNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ijkuakó okiwikakeh n Jesús inawak n tiópixki non okachi tlayakantok. Iwa ompa omoololojkeh nochteh n tetajmeh non tlayakantokeh kan Weyi Tiopa, iwa non kitemachtiah n tlanawatílistli. ");
INSERT INTO nplNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iwa Pedro san wejka okiichtakatokatia n Jesús asta okalakito kan ipatio n tiópixki non okachi tlayakantok. Ompa omotlali iwan tlamokuitlawijkeh de n Weyi Tiopa, omototonijtokah inakastla n tlékuili. ");
INSERT INTO nplNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","N tiopixkeh non tlayakantokeh iwa n nochteh non de n Sanedrín okitemoliayah tlan ika kitlajtlakolmamaltiskeh n Jesús iwa ijkó weletis kimiktiskeh. Pero amitla okajsiah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Miakeh okijtoayah tlan amo milák, iwa mach san se intlajtol okipiayah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ijkuakó sikimeh owalmokeketskeh iwa opé kiteiliah n Jesús iwa ijkí okijtoayah: ");
INSERT INTO nplNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Tejwah otikkakeh ijkuak okijto: “Ne nikxixinis nin Weyi Tiopa non okichijchijkeh n tlakah, iwa ipan eyi tonati nikajkokuis ok se Weyi Tiopa non amo aka tlakatl kimachijchiwas.” ");
INSERT INTO nplNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Malki ijkó okijtoayah mach san se intlajtol okipiayah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ijkuakó n tiópixki non okachi otlayakantoka omoketsato tlatlajko iwa okitlajtlani n Jesús: —¿Amitla tikijtos de tlan ninteh mitsteiliah? ");
INSERT INTO nplNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús amitla okinankili. Iwa n tiópixki non okachi otlanawatiaya oksepa okitlajtlani: —¿Te ti Cristo, Ikone n Totajtsi Dios Non tiochitok? ");
INSERT INTO nplNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús okinankili: —Milák, Ne. Iwa nomejwah nonnechitaskeh Ne non onimochi ni tlakatl niewatos iyekma n Dios weletini, iwa satepa niwalmuikas itech mextli de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ijkuakó n tiópixki non okachi otlayakantoka omotlakentsomoni iwa okijto: —¿Tlan ok para tikinnekih oksikimeh makijtokih tlan okijto? ");
INSERT INTO nplNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Nomejwah yononkikakeh, Ye tlajtoa kemi yetoskia Dios! ¿Axa, tlan nonkijtoah? Nochteh okitlajtlakoltijkeh iwa okijtojkeh kuali makimiktikah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ijkuakó sikimeh opé kiixchijchawiah, okixtsakuayah, okiixwitekiah. Iwa okiliayah: —¡Axa, xikyejyekoli akin omitsmák! Iwa n tlamokuitlawijkeh de kan tiopa okiixtlatsiniayah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro omoketoka tlatsintla kan patio, iwa owala iteska n tiópixki non okachi otlayakantoka. ");
INSERT INTO nplNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ye okitak n Pedro inakastla n tlékuili, okisentlajtlatak iwa okili: —Te noiwa otinemia iwan Jesús de Nazaret. ");
INSERT INTO nplNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro mach okimokuiti iwa okijto: —Amo nikixmati, iwa amo nikmati tlan tikijtoa. Ijkuakó okiski kaltempa, iwa se kaxtil owaltlakuikak. ");
INSERT INTO nplNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Satepa, iteska n tiópixki oksepa okitak n Pedro iwa opé kinmilia n oksikimeh: —Nin tlakatl seme de yejwah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero n Pedro oksepa mach okimokuiti. Iwa okachi satepa, non ompa okatkah oksepa okilijkeh n Pedro: —De milajka te seme de yejwah, porke noiwa ti galileo, iwa titlajtoa kemi yejwah tlajtoah. ");
INSERT INTO nplNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ijkuakó n Pedro opé tlawijwikaltia, omotlajtolchijchika iwa okijto: —¡Ne mach nikixmati non tlakatl akin nomejwah nonkitenewah! ");
INSERT INTO nplNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ijkuakó n kaxtil oksepa owaltlakuikak, iwa n Pedro okilnamik tlan Jesús okilijka: “Ijkuak n kaxtil tlakuikas ome welta; te eyi welta yotikijto amo nikixmati.” Nima n Pedro opé senchoka. ");
INSERT INTO nplNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Semi san kualka, n tiopixkeh non tlayakantokeh, iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa iwa non kitemachtiah n tlanawatílistli iwa nochteh non okimajmanayah n Sanedrín, omoololojkeh iwa omotlapowijkeh tlan kitoktiskiah n Jesús. Satepa okimailpijkeh iwa okimaktilitoh n Pilato. ");
INSERT INTO nplNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato okitlajtlani: —¿Te tirey de judíojteh? Jesús okinankili: —Ijkó kemi tejwatsi yotikijto. ");
INSERT INTO nplNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pero n tiopixkeh non tlayakantokeh san de miak okiteiliayah. ");
INSERT INTO nplNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato oksepa okitlajtlani Jesús: —¿Amitla tikijtos de nochi tlan yejwah mitsteiliah? ");
INSERT INTO nplNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús amo otlanankili iwa n Pilato san omotlajtlachialti. ");
INSERT INTO nplNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nochi xiwitl itech ilwitl de Paskua, Pilato trato okikajkawaya seme de non tsaktokeh, san akin okitlajtlaniliayah. ");
INSERT INTO nplNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iwa ompa otsaktoka Barrabás iwa sikimeh itlakaikniwah, ninteh okintsakeh ken otemiktijkeh keman omototojtokakeh iwan gobierno. ");
INSERT INTO nplNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ijkuakó, miakeh oyajkeh kan Pilato iwa okilijkeh makichiwa kemi nochi xiwitl kichijtiwits. ");
INSERT INTO nplNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iwa Pilato okinmili: —¿Nonkinekih manikkajkawa n Rey de judíojteh? ");
INSERT INTO nplNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato okiyekmatia n tiopixkeh non tlayakantokeh okimaktilijkeh n Jesús porke oxikojmikiah. ");
INSERT INTO nplNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero n tiopixkeh non tlayakantokeh okintlatlalwijkeh n tlakah para makitlajtlanilikah n Pilato makikajkawa Barrabás. ");
INSERT INTO nplNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ijkuakó Pilato oksepa okintlajtlani: —¿Tlan nonkinekih manikchiwa iwa nin tlakatl akin nomejwah nonkinotsah Rey de n judíojteh? ");
INSERT INTO nplNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yejwah oksepa otlanankilijkeh iwa okojtsajtsikeh: —¡Xikkrusifikaro! ");
INSERT INTO nplNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato okinmili: —¿Tleka? ¿Tlan amokuali okichi? Pero yejwah okojtsajtsikeh okachi chikawak: —¡Xikkrusifikaro! ");
INSERT INTO nplNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pero ken Pilato okinekia mokawas kuali inwa n tlakah, okikajka n Barrabás, otlanki otlanawati makitsonwitekikah n Jesús, iwa okinmaktili para makikrusifikarokah. ");
INSERT INTO nplNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ijkuakó n soldadojteh okiwikakeh n Jesús kan ipatio n palasio iwa ompa okinmoololojkeh nochteh n soldadojteh. ");
INSERT INTO nplNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Okonakiltijkeh itlake morado, iwa okitlalilijkeh se korona non okichijchiwilijkeh ika witstli. ");
INSERT INTO nplNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Otlanki opé kajawiltlajpaloah: —¡Timitsweyiliah Rey de judíojteh! ");
INSERT INTO nplNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iwa okikuawijwitekiah ika se akatl, okiixchijchawiayah iwa omotlankuaketsayah inawak iwa okiweyiliayah. ");
INSERT INTO nplNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ijkuak yotlanki okipijpinawijkeh, okikixtilijkeh n kapa morado iwa okonakiltijkeh itlake. Otlanki okiwikakeh okikrusifikarotoh. ");
INSERT INTO nplNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simón de Cirene inta n Alejandro iwa n Rufo, owalmokopaya de itlala, iwa ijkuak opajpanotiaya ik ompa n soldadojteh okitoktijkeh makiwikili ikrus n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Okiwikakeh n Jesús kan tepeyotl non okiliayah Gólgota non kijtosneki Miketsontekomatl. ");
INSERT INTO nplNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ompa okimakakeh vino nelitok ika mirra pero amo okonik. ");
INSERT INTO nplNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ijkuak yokikrusifikarojkah n Jesús, n soldadojteh okinmotlatlanilijkeh itlakenwah para kitaskeh tlan kimowikiliskiah. ");
INSERT INTO nplNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Okikrusifikarojkeh kualka, kemi las nueve. ");
INSERT INTO nplNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iwa ik ikuatsontla okipepechilijkeh se tlajkuíloli kan onestoka tleka okikrusifikarojkeh, iwa okijtoaya: “N Rey de Judíos.” ");
INSERT INTO nplNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Noiwa okinkrusifikarojkeh ome ichtekeh inajnakastla n Jesús, se kan iyekma iwa ok se kan iopochma. ");
INSERT INTO nplNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iwa akimeh ik ompa opanoayah omokuawiwixoayah, okiwijwikaltiayah iwa okiliayah: —¿Amo Te otikijto tikxixititsas n Weyi Tiopa iwa ipan eyi tonati oksepa tikchijchiwaskia?, ");
INSERT INTO nplNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","axa monewia ximopalewi iwa xiwaltemo de non krus. ");
INSERT INTO nplNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ijkó noiwa n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli, okipijpinawiayah iwa okimoliayah: —Oksikimeh okimpalewi, pero ye inewia, mach weleti mopalewia. ");
INSERT INTO nplNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tla milák Ye n Cristo, n Rey de Israel, mawaltemo de kan krus para matikitakah ijkuakó tikneltokaskeh. Iwa non okrusifikaritokah inajnakastla noiwa fiero okitenewaya. ");
INSERT INTO nplNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ijkuak oajsiko tlajko tonati, itech nochi non tlali otleyuak asta las tres. ");
INSERT INTO nplNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iwa itech non ora Jesús owaltsajtsik chikawak iwa okijto: —Eloi, Eloi, ¿lama sabaktani? —noni kijtosneki: Nodios, Nodios, ¿tleka otechkakajteh noselti? ");
INSERT INTO nplNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sikimeh ijkuak okikakeh, okijtojkeh: —¡Xikkakikah!, kinotok n profeta Elías. ");
INSERT INTO nplNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ijkuakó se omotlelo okisiawato se esponja itech vinagre. Okiyakailpi itech se akatl iwa okonmák n Jesús makoni, iwa okinmili n oksikimeh: —Matikitakah kox n profeta Elías wits kitemowiki. ");
INSERT INTO nplNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ijkuakó n Jesús owaltsajtsik chikawak, iwa omikki. ");
INSERT INTO nplNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","San nima n kortina de n Weyi Tiopa owaltlajkotsáyanki. ");
INSERT INTO nplNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iwa n soldado tlayákanki romano non omoketoka iyakapan Jesús, ijkuak okitak kenijki otsajtsik iwa owalmik, okijto: —¡Milák, nin tlakatl ye Ikone Dios! ");
INSERT INTO nplNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Noiwa sikimeh siwameh san wejka oontlachixtokah. Ompa okatkah María de Magdala, María inmamá n iknimeh José iwa n Jacobo non tsoyotl, iwa n Salomé. ");
INSERT INTO nplNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ninteh siwameh oyayah iwan Jesús iwa okimpalewiayah ijkuak okatka Galilea. Noiwa ompa okatkah oksikimeh siwameh non otlejkokeh Jerusalén iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ijkuak otiotlatik, nochteh yomotlatlalijtokah para n sábado. ");
INSERT INTO nplNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ijkuakó owala n José de n altepetl Arimatea, akin tewa okatka de n Sanedrín. Ye noiwa okichiaya ijkuak pewas tlanawatis Dios, omoyolchika iwa okitlatlaujtito n Pilato makimaktili ikuerpo n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato omotlajtlachialti ijkuak okima Jesús yomikki, ijkuakó okónnotski n soldado tlayákanki romano iwa okiyektlajtlani kox milák yomikki n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ijkuak n soldado tlayákanki okili yomikki, n Pilato okimaktili n José ikuerpo n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ijkuakó José okitemowi n kuerpo de kan krus iwa okikekemelo ika se tlakemitl de lino, non ye okiko. Otlanki okitlalito ikuerpo n Jesús kan se miketékochtli non okichkuakeh ipan tetl, iwa ika se weyi tetl tankachtik iwa patlaktik okitentsakeh n miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María de Magdala iwa María imamá n José okitakeh kan okiwilankeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ijkuak yopanok n sábado, María de Magdala, María imamá n Jacobo, iwa n Salomé. Okikojkeh ajwiálistli para kixawiliskiah ikuerpo n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Iwa san kualka, ijkuak yotlatlanestiwalaya n domingo, oyajkeh kan miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Iwa okimolijtiayah: —¿Akin techachiwilis n tetl non kitentsaktok n miketékochtli? ");
INSERT INTO nplNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero ijkuak oajsitoh, okitakeh n weyi tetl non okitentsaktoka n miketékochtli, mach ok ompa okatka. ");
INSERT INTO nplNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ijkuak n siwameh okalakeh kan miketékochtli, okitakeh ik inyekma se télpochtli ewatok ika itlake weyak iwa istak, iwa omomojtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero ye okinmili: —Amo ximomojtikah, nomejwah nonkitemoah n Jesús de Nazaret akin okikrusifikarojkeh. Pero Ye yomoyoliti. Ayakmó nika ka. Xikitakah kan owilantoka. ");
INSERT INTO nplNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Xiwiah xikinmatiltitih itlamachtijkawah iwa n Pedro: “Jesús tlayakanas Galilea, ompa nonkitaskeh ijkó kemi Ye yonomechili.” ");
INSERT INTO nplNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ijkuakó n siwameh okistewakeh de kan miketékochtli, porke omomojtijkeh iwa sa obibiokatokah, iwa amaka itla okilijkeh porke omawiah. ");
INSERT INTO nplNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús omoyoliti non domingo kualka, iwa achto okimonextili n María de Magdala, ye akin Jesús okinkixtili chikome espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ye oyá okinmatiltito akimeh onemiah iwan Jesús, iwa okimajsito moyolkokojtokeh iwa chokatokeh. ");
INSERT INTO nplNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero ijkuak okinmili yokitak n Jesús yolitok, yejwah mach okineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesús omoixpatlak iwa satepa okinmonextili ome itlamachtijkawah non oyayah intlala. ");
INSERT INTO nplNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ninteh noiwa okinmatiltitoh n oksikimeh itlamachtijkawah non tewa onemiah iwan Jesús, pero mach okineltokakeh tlan yejwah okimilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Satepa Jesús okinmonextili n májtlakteh iwa n se itlamachtijkawah ijkuak otlakuajtokah. Ye okinmajwak por amo okineltokakeh iwa por okitlakuawaltijkeh inyolo ijkuak oksikimeh okimilijkeh Ye yomoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iwa okinmili: —Xiwiah ipan nochi n tlaltíkpaktli iwa xikinmatiltikah itlajtol Dios nochteh n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Akin kineltokas notlajtol iwa mokuaatekis momakixtis, pero akin amo nechneltokas Dios amo kitlapojpolwis. ");
INSERT INTO nplNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iwa akimeh nechneltokaskeh kinchiwaskeh wejweyi milagros: Itech Notoka kinkixtiskeh espíritus amokualteh, tlajtoskeh ika yankuikeh tlájtolteh, ");
INSERT INTO nplNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","iwa tla kinkitskiskeh koameh noso tla koniskeh itla beneno, amitla kintoktis. Kintlaliskeh inmawah ipan kokoxkeh iwa kimpajtiskeh. ");
INSERT INTO nplNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Satepa, ijkuak Toteko Jesús yotlanki okintlapowi itlamachtijkawah, otlejkok ilwikak iwa omoyayanti iyekma n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Satepa, itlamachtijkawah n Jesús sentetl oyajkeh otetlapowitoh de n kualitlájtoli. Iwa n Toteko okimpalewiaya ika neskayolteh tlan tetlajtlachialti okinchiwayah.");
INSERT INTO nplNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Miakeh omochijchikajkeh okijkuilojkeh nochi tlan otlamochi tonawak. ");
INSERT INTO nplNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ijkó kemi otechtlapowijkeh akimeh okitakeh ika inmixtololowah tlan otlamochijtiwalaya desde ijkuak opé motetlapowiah n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ne noiwa yonikmomachti iwa onitlajtlantínenki kenijki opé, iwa onikmoli kuali manimitsontlajkuilili kemi moneki tejwatsi tionweyixtok Teófilo. ");
INSERT INTO nplNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ijkó, okachi xikyekmati tlan milák tlan achto yomitsmachtijkah. ");
INSERT INTO nplNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ijkuak Herodes otlanawatijtoka Judea, ochantitoka se tiópixki non itoka Zacarías, ye tewa iwan tiopixkeh de Abías. Isiwa n Zacarías itoka Elisabet. Ye ojojpaixwi n tiópixki Aarón. ");
INSERT INTO nplNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías iwa isiwa Elisabet oyolmilajkanemiah inawak n Totajtsi Dios, iwa okichiwayah nochi tlan okijtoaya itlanawatil n Toteko. ");
INSERT INTO nplNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero mach okimpiayah impilwah, porke Elisabet mach oweletia okimpiaya, iwa san ken omeh yokatkah tetajtsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Se tonati, Zacarías iwa intiopixkaikniwah kichiwaskiah n tekitl ijtik Weyi Tiopa, iwa ken yomotekpankah, okipejpenke n Zacarías para makichiwa n tekitl ijtik Tiopa inawak Dios, kemi Abías okichijtiwalaya. ");
INSERT INTO nplNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yejwah omotlatlaniah para kichichinoskeh n kópali. Zacarías otlátlanki iwa otlapopochwi kan iartal Toteko. ");
INSERT INTO nplNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ijkuak Zacarías otlapopochwijtoka ijtik Weyi Tiopa, nochteh n tlakah omotiotsajtsilijtokah kala. ");
INSERT INTO nplNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ijkuakó se iángel Toteko okimonextili n Zacarías, nin ángel omoketoka iyekma n artal kan kichichinoah n kópali. ");
INSERT INTO nplNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ijkuak Zacarías okitak n ángel, omotlajtlachialti iwa ayakmó okima tlan kichiwas iwa satlawel omaujki. ");
INSERT INTO nplNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero n ángel okili: —Zacarías, amo ximawi, porke Dios yokikak motiotsajtsilis, iwa mosiwa Elisabet kipias se konetl, iwa te tiktlalilis itoka Juan. ");
INSERT INTO nplNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Te satlawel tiyolpakis, iwa miakeh tlakah noiwa yolpakiskeh ijkuak tlakatis non konetl, ");
INSERT INTO nplNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","porke mokone satlawel weyijkatitos inawak Dios. Ayik konis vino nion tlan tewinti, iwa tentos de Espíritu Santo desde ijkuak yetos ijtik inanyo Elisabet. ");
INSERT INTO nplNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iwa kichiwas mamoyolkopakah miakeh tlakah de Israel inawak Inteko Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ye achto moteixpantiti inawak Toteko ika iespíritu iwa iweletilis n tiotlajto Elías. Kichiwas mamoyekwikakah n tetajmeh iwa impilwah. Iwa kinmititis non amo tetlakitah, matetlakitakah, ijkó kinyolkopas n tlakah para makiselikah n Toteko. ");
INSERT INTO nplNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías okitlajtlani n ángel: —¿Kenomi nikmatis tlan otikijto milák?, ne ya nitetajtsi iwa nosiwa ya tenantsi. ");
INSERT INTO nplNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","N ángel okinankili: —Ne Gabriel, iwa niktekitilia Totajtsi Dios. Ye onechaltítlanki manimitsiliki ninteh kualitlájtolteh. ");
INSERT INTO nplNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero axa, kemi amo otikneltokak tlan onimitsili, mach weletis titlajtos asta matlakati mokone, iwa nochi ni ijkó mochiwas ijkuak ajsiki n tonati. ");
INSERT INTO nplNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iwa kemi Zacarías yowejkajtoka ijtik Weyi Tiopa, n tlakah non kala okichixtokah opé motekipachoah tleka amo owalkisaya. ");
INSERT INTO nplNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ijkuak Zacarías owálkiski, amo owéletki okintlapowi, ijkuakó okajsikamatkeh itla okimonextili ijtik tiopa. Ye sa okinmanotsaya porke ayakmó oweletia otlajtoaya. ");
INSERT INTO nplNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ijkuak Zacarías otlanki okichi iteki ijtik Tiopa, oyá icha. ");
INSERT INTO nplNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Satepa Elisabet omoka kókoxki de konetl, iwa mákuili mestli mach okiski de icha, iwa okimoliaya: ");
INSERT INTO nplNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Axa n Noteko onechchiwili tlan kuali ika itlasojtlalis, para ayakmó manechpijpinawikah por amo oniweletia onikpiaya nokone.” ");
INSERT INTO nplNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ijkuak Elisabet yokipiaya chikwase mestli kókoxki de konetl, n Totajtsi Dios okitítlanki iángel Gabriel mawia Galilea itech se altepetl non itoka Nazaret, ");
INSERT INTO nplNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","para makitlajpaloti se íchpochtli non itoka María. Ye yokisentlalijka monamiktis iwan se tlakatl non itoka José, nin José ojojpaixwi n Rey David. ");
INSERT INTO nplNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","N ángel okalak kan okatka María iwa okili: —¡Xipaki! Dios satlawel omitstiochi. N Toteko kajki mowa. ");
INSERT INTO nplNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero ijkuak María okitak n ángel, saikpanoa omotlajtlachialti iwa mach okimatia tlan kijtos, iwa okimoliaya tleka ijkó okitlajpaloaya. ");
INSERT INTO nplNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ijkuakó n ángel okili: —María, amo ximawi, porke Dios yolpaki monawak. ");
INSERT INTO nplNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","¡Xikkaki!, axa timokawas tikókoxki de konetl, iwa non konetl tiktlalilis itoka Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ye saikpanoa weyijkatitos, iwa kinotsaskeh Tekone de non Weyijkatitok. Dios Toteko kitlalis mayeto Rey ijkó kemi otlanawati David iwejkatata. ");
INSERT INTO nplNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ye nochipa kinawatijtos n país de Israel, iwa itlanawatil mach ayik pojpoliwis. ");
INSERT INTO nplNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ijkuakó María okitlajtlani n ángel: —¿Kenomi manikpia nokone, ne ayamó nikpia nookich? ");
INSERT INTO nplNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","N ángel okinankili: —N Espíritu Santo walmuikas motech, iwa iweletilis n Totajtsi Dios mitsmokemis kemi se mextli. Yika, n konetl non te tikpias yetos yolchipawak iwa kinotsaskeh Tekone de Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Moprima Elisabet, maya ya tenantsi, noiwa kipias se konetl. Ijkó kiné, non okiliayah ayik weletis kipias ikone axa ya kókoxki de konetl iwa ya kipia chikwase mestli. ");
INSERT INTO nplNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porke Totajtsi Dios nochi weleti kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ijkuakó María okili: Ne iteska n Totajtsi Dios. Mamochiwa nowa ijkó kemi yokijto. Ijkuakó n ángel owálkiski. ");
INSERT INTO nplNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Itech nonteh tonatijmeh, María oyá totokatijkak okitlajpaloto iprima Elisabet. Ye ochantitoka itech se altepetl non kajki itech tepeyo de Judea. ");
INSERT INTO nplNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ijkuak oajsito itech non altepetl, María okalak icha n Zacarías, iwa okitlajpalo n Elisabet. ");
INSERT INTO nplNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ijkuak Elisabet okikak itlajtol n María, ikone n Elisabet otsékuinki ijtik inanyo, iwa Elisabet otenki ika n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ijkuakó Elisabet ika pakílistli okualnankili chikawak: —¡Dios omitstiochi okachi ke nochteh n siwameh, iwa n konetl non tikpias, Dios yokitiochi! ");
INSERT INTO nplNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Akin ne, para manechontlajpaloki imamá n Noteko? ");
INSERT INTO nplNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porke san nima ijkuak onikak otechtlajpalo, nokone otsékuinki ijtik nonanyo ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Tlawel xiyolpaki, ken otikneltokak nochi tlan Toteko yokijto! ");
INSERT INTO nplNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ijkuakó María okili: Ika nochi noyolojtsi nikweyilia Noteko, ");
INSERT INTO nplNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iwa miak niyolpaki inawak Dios, Notemakixti. ");
INSERT INTO nplNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porke onechitak kemi iteska, iwa ken niyolyámanki, Dios onechiknoma, iwa desde axa nochteh n tlaltikpaktlakah nechiliskeh niyolpakiliso. ");
INSERT INTO nplNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porke Dios weletini okinchi notech wejweyi milagros. ¡Ye yolchipawak! ");
INSERT INTO nplNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","N Totajtsi Dios nochipa kinmiknomatis akimeh kitlakitah. ");
INSERT INTO nplNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ye okinexti iweletilis ika tlan okichi, kimpijpinawia akimeh kimatih moweyiliah. ");
INSERT INTO nplNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","N wejweyi tekiwajkeh okinkixtili intlanawatil, iwa okinweyijkatlali akimeh san moiknomatih. ");
INSERT INTO nplNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iwa non amitla okipiayah okinmák nochi tlan kuali, iwa akimeh okipiayah tomi amitla okinmák. ");
INSERT INTO nplNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ye okipalewi itlakewal Israel, mach okilka kiknomatis, ");
INSERT INTO nplNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ijkó kemi yowejka okimilijkeh totatawah, Abraham iwa nochteh iojpa ixwiwah nochipa kintlasojtlaskia. ");
INSERT INTO nplNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María omoka iwan Elisabet kemi eyi mestli, iwa satepa omókopki icha. ");
INSERT INTO nplNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Satepa oajsiko n tonati, ijkuak Elisabet okípixki ikone. ");
INSERT INTO nplNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Iwa ijkuak non ik ompa ochanchiwaya iwa non ken kita n Elisabet okimatkeh Toteko Dios satlawel okiknoma, okitlajpalotoh iwa opakeh íwa. ");
INSERT INTO nplNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ijkuak owalchikometik okisirkunsidarotoh n konetl, iwa okinekiah kitlaliliskeh itoka Zacarías, kemi ita. ");
INSERT INTO nplNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero imamá okijto: —¡Amó, tiktlaliliskeh itoka Juan! ");
INSERT INTO nplNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Non ompa okatkah okilijkeh: —¿Tleka ijkó tikneki tiknotsas? nochteh non ken tikinmita, amaka ijkó itoka. ");
INSERT INTO nplNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ijkuakó, okimanotskeh n Zacarías iwa okitlajtlanijkeh kenijki okinekia kitlalilis itoka n konetl. ");
INSERT INTO nplNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pero Zacarías okimatlájtlanki makimakakah itla tlan ipa tlajkuilos, iwa ijkí okijkuilo: “Juan yetos itoka.” Iwa san okintlajtlachialti. ");
INSERT INTO nplNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Non ora Zacarías owaltlajto, iwa opé kiweyijkachiwa Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iwa nochteh non ik ompa ochantitokah omaujkeh, iwa non ochantitokah itech tepeyo de Judea, omotlapowiayah de nochi tlan otlamochi. ");
INSERT INTO nplNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iwa nochteh non okikakiah, okimoliayah: —¿Tlan kichiwas non chokotsi keman motlamiti tlakatl? Porke okajsikamatiah n Toteko okatka íwa. ");
INSERT INTO nplNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, ipapá n chokotsi otenki de Espíritu Santo iwa ijkí okijto: ");
INSERT INTO nplNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Maweyijkachito n Toteko Dios de Israel, porke okinmakixtiko ialtepeikniwah. ");
INSERT INTO nplNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ye otechaltitlanili se chikaktik temakixti, se non iwejkaixwi n Rey David itékitki n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ijkó kemi Dios yokijtojka ya wejkawitl ijkuak iprofetajwah yolchipawakeh otechmatiltijkeh: ");
INSERT INTO nplNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ye techpalewiskia inmak akimeh techkokolia iwa inmak akimeh techtlawelitah. ");
INSERT INTO nplNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Noiwa okijto kinmiknomatiskia totatawah iwa ayik kilkawaskia tlan okisentlali kichiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ye ni tlan Totajtsi Dios okisentlali iwa totata Abraham: ");
INSERT INTO nplNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ye okisentlali techpalewiskia de inmak akimeh techkokoliah, para amo matimawikah ijkuak tiktekitiliskeh, ");
INSERT INTO nplNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","matiyetokah tiyolchipawakeh iwa timilajkameh inawak Dios, asta ijkuak timikiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iwa te, nokone, mitsnotsaskeh profeta de n Totajtsi Dios non weyijkatitok. Porke te tias iyakapa n Totemakixti para matlaneltokakah inawak, ");
INSERT INTO nplNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","iwa tikinmatiltis itlakaikniwah, kintlapojpolwis de intlajtlakolwah, iwa ijkó weletis momakixtiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Porke n Totajtsi Dios kintlapojpolwia ken milák kintlasojtla. Iwa kemi kinmiknomati kinwaltitlanilis n Temakixti non wits de ilwikak, ");
INSERT INTO nplNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para kintlawilis akimeh nemih kan tleyua iwa akimeh kateh kan itlasekawilo n mikílistli, iwa para techyakanas itech se kuali ojtli. ");
INSERT INTO nplNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","N chokotsi Juan omoskaltiaya iwa iespíritu omochikajtiaya. Omochantito kan amaka chanti iwa opé kintlapowia itlajtol Dios asta ijkuak omoteititi innawak n tlakah de Israel. ");
INSERT INTO nplNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Itech nekateh tonatijmeh, n weyi tlanawati romano Augusto César, otlanawati mamomachotikah itech nochteh n altepemeh kan otlanawatiaya n Romanos, ");
INSERT INTO nplNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ye ni n sikinika senso, omochi ijkuak Cirenio gobernador kan tlali de Siria. ");
INSERT INTO nplNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nochteh oyayah inmaltépeu para ompa momachotiskeh itech senso. ");
INSERT INTO nplNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yika, José okiski de Nazaret, tlali de Galilea, iwa oyá kan tlali de Judea, altepetl de Belén, ompa otlákatki n rey David, porke José oyá iojpaixwi n rey David. ");
INSERT INTO nplNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José iwa María sansikah oyajkeh Belén, para momachotiskeh itech senso. María yokatka kokoxki de konetl iwa ya monamiktiskia iwan José. ");
INSERT INTO nplNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ijkuak yejwah okatkah Belén, oajsiko n tonati para tlakatis n konetl. ");
INSERT INTO nplNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iwa ompa otlákatki non sikinika ikonetsi. Iwa n María okikemelo ika tlakemeh iwa okitekak itech se kajo non okipiaya sakatl non ompa otlakuayah n yolkameh. Ompa otlákatki n konetl porke ayakmó lojar itech kali kan tekalotiah. ");
INSERT INTO nplNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Amo wejka de Belén okatkah sikimeh tlajpixkeh non okinmokuitlawijtokah inmichkawah itech tlajtlala. ");
INSERT INTO nplNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ijkuakó okinmonextili se iángel Toteko, iwa itlawilnextilis okintlawili, iwa n tlájpixkeh satlawel omomojtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero n ángel okinmili: —Amo ximomojtikah, porke ne onomechmatiltiko se kualitlájtoli, non kinyolpaktis nochteh n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Axa itech ialtépeu n David yotlákatki se Temakixti, Ye Cristo Toteko. ");
INSERT INTO nplNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nonkajsitiweh n konetl kemelitika ika tsótsolteh, iwa wetotika kan kintlamakah n yolkameh. ");
INSERT INTO nplNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Itech non ora inakastla non ángel, owalmonextijkeh miaktikeh ángelteh de ilwikak non okitlakuikiliayah Dios iwa ijkí okijtoayah: ");
INSERT INTO nplNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Maweyijkatito Dios kan ilwikak, iwa itech tlaltíkpaktli mayetokah ika yolsewílistli nochteh akimeh kiyolpaktiah n Totajtsi Dios! ");
INSERT INTO nplNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","San nima, ijkuak n ángeles omokopkeh ilwikak, n tlajpixkeh opé motlalwiah: —Matiwiah Belén, matikitatih tlan otlamochi, tlan Toteko otechmatiltiko. ");
INSERT INTO nplNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yejwah omotlelojtiwetskeh iwa okajsitoh n María iwa n José, iwa n konetl wetotika kan kintlamakah n yolkameh. ");
INSERT INTO nplNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ijkuak okitakeh n konetl, opé tetlapowiah tlan yokinmatiltijka n ángel, ");
INSERT INTO nplNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","iwa nochteh omotlajtlachialtijkeh ijkuak okikakiah tlan okijtoayah n tlajpixkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María nochi ni okitlaati itech iyolo, iwa nochipa okilnamikia nochi tlan otlamochi. ");
INSERT INTO nplNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Satepa n tlajpixkeh omokopkeh kan okatkah inmichkawah, okiweyijkachiwayah iwa okitlakuikilijtiayah n Totajtsi Dios por nochi tlan okikakeh iwa okitakeh, ijkó kemi okinmili n ángel. ");
INSERT INTO nplNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ijkuak ochikometik de otlákatki n konetl, okisirkunsidarojkeh, iwa okitlalilijkeh itoka JESÚS, ijkó kemi n ángel achto yokilijka n María ijkuak ayamó kókoxki de konetl. ");
INSERT INTO nplNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ijkuak opanokeh n tonatijmeh de omochipajkeh, ijkó kemi kijtoa itlanawatil Moisés, yejwah okiwikakeh n konetl kan Weyi Tiopa de Jerusalén para kiteixpantiskeh inawak Toteko Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ijkó okichijkeh porke itech itlajkuilol n Toteko Dios kijtoa: “Nochi konetl tlakatl teteachka, yetos tlapejpénili ixpan Toteko Dios.” ");
INSERT INTO nplNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Noiwa okintemakakeh ome espiritomeh noso ome kokolotsitsinteh para makinmiktikah ipan artal, ijkó kemi kijtoa itlanawatil Toteko. ");
INSERT INTO nplNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Itech nekateh tonatijmeh, ochantitoka Jerusalén se tlakatl non itoka Simeón. Ye yolmilajka iwa miak okimopantiaya Dios iwa okichiaya matlakati non kimpalewis n tlakah de Israel. Iwa n Espíritu Santo okatka itech Simeón, ");
INSERT INTO nplNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","iwa yokimatiltijka amo mikiskia tla amo achto kitaskia n Cristo, Akin Toteko Dios kualtitlanis. ");
INSERT INTO nplNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","N Espíritu okili n Simeón mawia kan Weyi Tiopa. Ijkuakó José iwa n María okiwikakeh n konetl Jesús kan Weyi Tiopa para kichiwaskeh kemi kijtoa itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón okinapalo n konetl iwa okiweyijkachi Totajtsi Dios, iwa okijto: ");
INSERT INTO nplNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Noteko, axa ya weletis techkawilis manimiki ika yolsewílistli, porke yotikchi tlan otechilijka, ne onia se motékitki. ");
INSERT INTO nplNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ken yonikitak ika noixtololowah motemakixtilis, ");
INSERT INTO nplNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Akin yotiktlali inmixpah nochteh n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ye se tláwili non kintlawilis non amo judíojteh, iwa kichiwas maweyijkatito mopueblo Israel. ");
INSERT INTO nplNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José iwa n María san omotlajtlachialtijkeh ijkuak okikakeh nochi tlan Simeón okijtoaya de n konetl. ");
INSERT INTO nplNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Otlanki n Simeón okintiochi iwa okili n María imamá n Jesús: —¡Xikkaki! Dios okitlali mokone para miakeh de Israel non amo kineltokaskeh moixpoloskeh pero akimeh kineltokaskeh, momakixtiskeh. Ijkuak moteititis kemi Cristo miakeh mach kiseliskeh, ");
INSERT INTO nplNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","iwa ijkó momatis tlanón kiyejyekoliah n tlakah itech inyolo. Iwa te María noni mitstlaijyowiltis, kemi mitstsoponiliskia se tepostlatekini itech moyolo. ");
INSERT INTO nplNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Noiwa ompa okatka se siwatl profeta non ya tena iwa itoka Ana, ye teichpoch de Fanuel, iwa Fanuel iwejkaixwi n Aser. Ana omonamikti wel ok ichpotsintli, pero ijkuak yokiwikayah chikome xiwitl sansikah, iokich omikki. ");
INSERT INTO nplNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yika omoka iknosiwatl, iwa yokipiaya nawi póali iwa n nawi xiwitl. Ixmostla oyaya tiopa, tlajka iwa n yuak okitekichiwiliaya n Toteko, ika itiotsajtsilis iwa ika imosawalis. ");
INSERT INTO nplNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana noiwa okalakito itech non ora iwa opé kiweyijkachiwa Dios. Iwa opé tetlapowia de n konetl Jesús, nochteh n tlakah de Jerusalén okichixtokah mawiki n Cristo para kinmakixtis. ");
INSERT INTO nplNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Satepa, ijkuak yokichijkeh nochi tlan kijtoa itlanawatil n Toteko, owalmokopkeh inmaltépeu de Nazaret, itech tlalmeh de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iwa n chokotsi Jesús omoskaltiaya, omochikawaya iwa okachi oixtlamatia, iwa Totajtsi Dios okachi okitiochiwaya. ");
INSERT INTO nplNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Itajwah n Jesús nochi xiwitl oyayah Jerusalén itech ilwitl de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ijkuak Jesús okípixki májtlaktli iwa ome xiwitl, Ye iwa itajwah oyajkeh Jerusalén, kemi nochi xiwitl okichiwayah. ");
INSERT INTO nplNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ijkuak yotlanki n ilwitl, yejwah owalmokopayah para incha, pero n chokotsi Jesús omoka Jerusalén, iwa nion María nion José okitakeh kox n chokotsi omoka. ");
INSERT INTO nplNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Itajwah okiyejyekoliayah chamo Jesús okwalintokaya iwan oksikimeh non ompa owalayah, yejwah onejnenkeh se tonati. Satepa opé kitemoah inchokotsi inwah non ken okinmitayah iwa non okinmixmatiayah, ");
INSERT INTO nplNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","amo kanaj okajsikeh, yika omokopkeh okitemotoh Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iwa eyi tonati satepa, okajsitoh itech Weyi Tiopa de Jerusalén. Ye oewatoka tlatlajkotia de kan oewatokah non kitemachtiah n tlanawatílistli, okinkaktoka iwa okintlatlajtlaniaya. ");
INSERT INTO nplNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nochteh non okikakiah, omotlajtlachialtiayah porke Ye satlawel oixtlamatia, iwa porke kuali okinnankiliaya. ");
INSERT INTO nplNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ijkuak itajwah okitakeh omotlajtlachialtijkeh, iwa imamá okili: —Nokone, ¿tleka ijkó otechtokti? Mota iwa ne, satlawel otimomojtijkeh, ken amo kanaj otimitsajsiah. ");
INSERT INTO nplNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ijkuakó Jesús okinmili: —¿Tleka ononnechtemoayah? ¿Mach amo nonkimatih nikpia niktekichiwilis Notajtsi? ");
INSERT INTO nplNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yejwah mach okajsikamatkeh tlan okinmili. ");
INSERT INTO nplNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ijkuakó Jesús omókopki Nazaret inwah, ompa okintlakitaya itajwah. Pero María nochi noni okitlaatiaya itech iyolo. ");
INSERT INTO nplNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","N chokotsi Jesús okachi omoskaltijtiaya, iwa okachi oixtlamatia. Okipaktiaya n Totajtsi Dios iwa n tlakah okiseliayah. ");
INSERT INTO nplNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ijkuak César Tiberio yokiwikaya káxtoli xiwitl kemi weyi tekiwa itech Roma, Poncio Pilato okatka gobernador de Judea, Herodes Antipas gobernador de Galilea, iwa ikni Felipe gobernador de Iturea iwa Traconite, iwa Lisanias okatka gobernador de Abilene. ");
INSERT INTO nplNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás iwa n Caifás okatkah weyi tiopixkeh, yejwah otlayakantokah. Itech nonteh tonatijmeh, Dios okitlapowi n Juan ipiltsi n Zacarías, yika Juan otetlapowiaya kan amaka chanti. ");
INSERT INTO nplNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan onentinemia itech nochteh altepemeh non okatkah itempa n río Jordán. Ye okinmiliaya makipatlakah innemilis iwa mamokuaatekikah para Dios makintlapojpolwi de intlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ijkó omochi kemi ijkuilitok itech itlajkuilol n profeta Isaías: Se tlájtoli mokaki chikawak kan amaka chanti: “Xikyektlalilikah iojwiu n Toteko, Xikmilawakah iojwiu. ");
INSERT INTO nplNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kan tlawewejkatla, xikixmanakah, nochi tepemeh iwa n tepetsitsinteh noiwa nonkinmixmanaskeh, n ojmeh nenekuiltikeh xikinmilawakah, iwa n ojmeh kan tlalchikototolonka noiwa xikinmixmanakah. ");
INSERT INTO nplNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iwa nochteh n tlaltikpaktlakah kitaskeh kenomi techmakixtis Dios.” ");
INSERT INTO nplNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Miakeh tlakah owalayah inawak Juan, para makinkuaateki iwa ye okimiliaya: —¡Nomejwah kemi nonkoameh! ¿Akin onomechili nonmakisaskeh imak tlaijyowílistli temojti non nomopah wits? ");
INSERT INTO nplNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xikchiwakah tlan kuali para mamota milák yononmoyolkopkeh inawak Dios, iwa amo xikmolikah: “Tejwah titepilwah de Abraham.” De milajka nomechilia, Totajtsi Dios weletis kinkopas ninteh temeh ipilwah n Abraham. ");
INSERT INTO nplNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","N acha kajki inakastla n kuawitl, iwa nochi kuawitl non amo kitemaka kuali itlakilo, motsontekis iwa motlamotlas ijtik tletl. ");
INSERT INTO nplNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","N tlakah okitlajtlaniayah: —¿Tlan tikchiwaskeh? ");
INSERT INTO nplNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan okinnankili: —Akin kipia ome itlakeh makitliokoli se akin amo kipia. Iwa akin kipia tlan kikuas, makitliokoli akin amo kipia tlan kikuas. ");
INSERT INTO nplNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noiwa omokuaatekikoh sikimeh tominoololojkeh inawak Juan, iwa okitlajtlanijkeh: —Tlamachti, ¿tlan moneki matikchiwakah? ");
INSERT INTO nplNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan okinmili: —Amo okachi xikinkobrarokah san tlan machotitok. ");
INSERT INTO nplNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noiwa sikimeh soldadojteh okitlajtlanijkeh: —Tejwah, ¿tlan tikchiwaskeh? Juan okinmili: —Amaka itla xikkixtilikah, nion aka xikteilikah tla amitla okichi iwa xipakikah ika nomotlaxtlawil. ");
INSERT INTO nplNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kemi n tlakah sa okichixtokah mawiki n Cristo, yejwah okimoliayah chamo Juan ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yika Juan okinmili: —Ne nomechkuaatekia ika atl, pero satepa wits se tlakatl Akin nomechkuaatekis ika n Espíritu Santo iwa ika tletl. Ye okachi weletini, iwa ne mach ni tlawel kuali kemi para nikaktojtomas. ");
INSERT INTO nplNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ye kualika itech ima tlan ika kichipawas n trigo. N trigo non yokichipa kitlaatis, iwa itlajsol n trigo kontlamotlas ijtik tletl non ayik sewis. ");
INSERT INTO nplNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ijkí, iwa ika oksikimeh tlamachtijkeh, Juan Bautista okinmatiltiaya n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Noiwa okajwak n gobernador Herodes Antipas; porke okimosiwati ikuñada Herodías. Nin Herodías okatka isiwa n Felipe, ikni n Herodes. Juan noiwa okajwak Herodes ika tlan amo kuali okichijtinemia. ");
INSERT INTO nplNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes mach okinek okikak tlan okiliaya n Juan, yej okichi tlan amokuali, iwa otlanawati makitsakuakah n Juan. ");
INSERT INTO nplNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan okinkuaatekiaya miakeh tlakah, iwa se tonati noiwa okikuaateki n Jesús. Ijkuak Jesús omotiotsajtsilijtoka, n ilwikak owalmotlapo, ");
INSERT INTO nplNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iwa n Espíritu Santo owaltemok ipan Jesús kemi se palomatsi, iwa itech ilwikak owalmokak se tlájtoli non okijtoaya: —Te Ti Nokone non saikpanoa niktlasojtla, iwa monawak niyolpaki. ");
INSERT INTO nplNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ijkuak Jesús okipiaya kemi sempóali iwa n májtlaktli xiwitl opé tetlapowia de itlajtol n Totajtsi Dios. N tlakah okijtoayah Jesús oyá ipiltsi n José, iwa n José ikone n Elí, ");
INSERT INTO nplNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí ikone Matat, iwa Matat ikone n Leví, Leví ikone Melqui, iwa Melqui ikone n Jana, Jana ikone n José, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ikone Matatías, Matatías ikone n Amós, iwa n Amós ikone Nahúm, Nahúm ikone n Eslí, iwa n Eslí ikone n Nagai, ");
INSERT INTO nplNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ikone Maat, iwa n Maat ikone Matatías, Matatías ikone n Semei, iwa n Semei ikone Joséc, Joséc ikone Judá, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá ikone Joanán, Joanán ikone n Resa, iwa n Resa ikone Zorobabel, Zorobabel ikone n Salatiel, iwa n Salatiel ikone Neri, ");
INSERT INTO nplNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ikone Melquí, iwa n Melquí ikone n Adí, Adí ikone Cosam, iwa n Cosam ikone n Elmadam, Elmadam ikone n Er, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ikone Josué, Josué ikone n Eliezer, iwa n Eliezer ikone Jorim. Jorim ikone Matat, iwa Matat ikone n Leví, ");
INSERT INTO nplNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví ikone n Simeón, iwa n Simeón ikone n Judá. Judá ikone José, iwa n José ikone n Jonán, Jonán ikone n Eliaquim, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ikone Melea. Melea ikone Mainán, iwa n Mainán ikone Matata. Matata ikone Natán, iwa n Natán ikone n David. ");
INSERT INTO nplNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David ikone Isaí, iwa n Isaí ikone Obed, Obed ikone Booz, iwa n Booz ikone Salmón. Salmón ikone n Naasón, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ikone n Aminadab. Aminadab ikone n Admín, iwa n Admín ikone Esrom. Esrom ikone n Fares, Fares ikone n Judá, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ikone n Jacob. Jacob ikone Isaac, iwa n Isaac ikone n Abraham. Abraham ikone n Taré, iwa n Taré ikone Nacor, ");
INSERT INTO nplNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ikone n Serug, iwa n Serug ikone n Ragau. Ragau ikone n Peleg, iwa n Peleg ikone n Heber. Heber ikone n Sala, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ikone n Cainán. Cainán ikone n Arfaxad, iwa n Arfaxad ikone n Sem. Sem ikone Noé, iwa n Noé ikone n Lamec. ");
INSERT INTO nplNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ikone Matusalén, iwa Matusalén ikone n Enok. Enok ikone n Jared, iwa n Jared ikone n Mahalaleel. Mahalaleel ikone n Cainán, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ikone n Enós. Enós ikone n Set, iwa n Set ikone n Adán, iwa n Adán ikone Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ijkuak Jesús owalmokopato kan río Jordán, Ye yotentiwalaya de n Espíritu Santo, iwa n Espíritu okiwík kan amaka chanti. ");
INSERT INTO nplNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ompa omoka ome póali tonati, iwa n diablo okinekia matlajtlakolchiwa. Itech nonteh ome póali tonati Jesús amitla okimomajsewi, iwa satepa owalxitlatlak. ");
INSERT INTO nplNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ijkuakó n diablo okili: —Tla milák Te Ikone Dios, xikili nin tetl mamokopa paj. ");
INSERT INTO nplNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús okinankili: —Itlajkuilol Dios kijtoa: “N tlakatl amo san ika paj yolitos.” ");
INSERT INTO nplNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Otlanki n diablo okiwík n Jesús kan se tepetl wejkapa, iwa okimititi nochteh n altepemeh de nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Iwa n diablo okili n Jesús: —Ne nikchiwas xiknawati nochi tlan onka itech nin tlaltíkpaktli iwa tiweyixtos intech. Porke nochi noaxka, iwa weletis nikmaktilis san akin ne niknekis. ");
INSERT INTO nplNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tla timotlankuaketsas nonawak iwa techweyilis, nochi yetos moaxka. ");
INSERT INTO nplNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ijkuakó Jesús okinankili: —Itlajkuilol Dios kijtoa: “Xikweyijkachiwa Moteko Dios, iwa sanwel Ye tiktekichiwilis.” ");
INSERT INTO nplNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Otlanki okiwík n Jesús kan altepetl de Jerusalén, okitlejkolti ikpak n Weyi Tiopa kan okachi wejkapa iwa okili: —Tla milák Te Ikone Dios, ximokajkawa ixko tlali, ");
INSERT INTO nplNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","porke itlajkuilol Dios kijtoa: Dios kinnawatis iangelwah mamitsmokuitlawikah. ");
INSERT INTO nplNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yejwah mitsmatsakuiliskeh para amo ximoikxitlanwi ika tetl. ");
INSERT INTO nplNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús okinankili n diablo: —Itlajkuilol Dios noiwa kijtoa: “Amo xikyejyeko n Dios Moteko.” ");
INSERT INTO nplNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ijkuak n diablo ayakmó okajsik kenijki weletis kiyejyekos n Jesús, okikakajte kech tonati. ");
INSERT INTO nplNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús omókopki Galilea ika iweletilis n Espíritu, iwa sentetl omotlapowiayah tlan Jesús okichiwaya. ");
INSERT INTO nplNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Otlamachtiaya itech insinagogajwah n judíojteh, iwa nochteh akimeh okikakiah, kuali omotlapowiayah de Ye. ");
INSERT INTO nplNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ijkuakó Jesús oyá Nazaret kan omoskalti. Non sábado okalakito kan sinagoga, kemi nochipa okichiwaya, iwa owalmóketski para kinamapoilis itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ompa okimaktilijkeh itlajkuilol n profeta Isaías, iwa ijkuak Jesús okimila, okajsik kan ijkuilitok: ");
INSERT INTO nplNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Iespíritu n Noteko notech kajki, ken Ye inewia onechpéjpenki para manikinmatilti n kualitlájtoli non amitla kipiah, onechaltítlanki manikinyolchikawaki akimeh moyolkokoah, iwa manikinmatilti kinkixtiskeh non tsaktokeh; iwa manikinmixtlajtlapo akimeh amo tlachiah, iwa manikinpalewi akimeh tlaijyowiah, ");
INSERT INTO nplNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","iwa maniktematilti yoajsiko n tonati keman Dios kintiochiwas nochteh akimeh witseh inawak. ");
INSERT INTO nplNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Otlanki Jesús okimemelo n tiotlajkuilolamatl, okimaktili akin tlapalewia itech non sinagoga iwa omotlali. Iwa nochteh non ompa okatkah, san okitlajtlatakeh, ");
INSERT INTO nplNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ijkuakó Jesús opé kinmilia: —Nin tonati nomoixpa yomochi tlan kijtoa itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nochteh non ompa okatkah kuali otlajtoayah de Jesús iwa omotlajtlachialtiayah kenijki okinmatiltiaya n kualitlájtoli. Iwa omotlajtlaniayah: —¿Amo ye ipiltsi n José? ");
INSERT INTO nplNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús okinmili: —Kuali nikmatok nomejwah nonkinekih nonnechkakitiskeh nin tlájtoli: “Tlapajti, ¡ximopajti te monewia!”, noiwa nonnechiliskeh: “Tlan otikmatkeh otikchi Capernaúm, noiwa xikchiwa nika itech moaltepeu.” ");
INSERT INTO nplNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iwa okinmili: —De milajka nomechilia, nion se profeta kiyekseliah kan ialtépeu. ");
INSERT INTO nplNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ijkuak oyolitoka n profeta Elías, okatkah miakeh iknosiwameh itech nochi tlali de Israel, itech nonteh tonatijmeh eyi xiwitl iwa n tlajko mach okiawik, iwa okatka miak apisotl itech nonteh tlalmeh, ");
INSERT INTO nplNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero Elías mach okititlankeh inawak seme de nonteh iknosiwameh, yej sanwel inawak se iknosiwatl non ochantitoka kan altepetl de Sarepta, itech tlali de Sidón. ");
INSERT INTO nplNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Noiwa ijkuak oyolitoka n profeta Eliseo, okatkah miakeh kokoxkeh de lepra itech nochi tlali de Israel, pero amaka de yejwah opajtik, sanwel Naamán non owalewatoka itech tlali de Siria. ");
INSERT INTO nplNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ijkuak okinkakeh ninteh tlájtolteh, nochteh non okatkah kan sinagoga, okualankamikeh. ");
INSERT INTO nplNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Owalmoketiwetskeh iwa okwalkixtijkeh n Jesús de itech non altepetl, iwa okiwikakeh itempa n tepetl non itech ochijchitoka inmaltépeu, para kontlamotlaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús opanok intlajkotiah iwa oyá. ");
INSERT INTO nplNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ijkuakó Jesús okalakito Capernaúm non kajki itech tlali de Galilea, iwa nochi sábado oontlamachtiaya kan sinagoga. ");
INSERT INTO nplNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","N tlakah omotlajtlachialtiayah ika itlamachtilis porke okinnonotsaya kemi akin kipia tlanawatílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ompa kan sinagoga okatka se tlakatl non okipiaya se espíritu amokuali, non owaltsajtsitewak: ");
INSERT INTO nplNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Techkawa, ¿tleka timokalakia towah, Jesús de Nazaret? ¿Otiwala otechpojpoloko? Ne nimitsixmati, Te tiyolchipawak inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús okajwak n espíritu amokuali, iwa okili: —¡Xiktsakua mokamak, iwa xikisa de non tlakatl! N espíritu amokuali okitlalwitek n tlakatl inyakapah nochteh iwa okiski, iwa amitla okitokti. ");
INSERT INTO nplNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nochteh omotlajtlachialtijkeh, iwa omotlatlajtlaniayah: —¿Tlan weletílistli kipia itlajtol? ¡Nin tlakatl ika weyi tlanawátili kinnawatia n espíritus amokualteh iwa yejwah kisah! ");
INSERT INTO nplNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iwa omotlapowiayah de Jesús itech nonteh tlalmeh. ");
INSERT INTO nplNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ijkuakó Jesús okiski de kan sinagoga iwa oyá icha n Simón Pedro. Ijkuak okalak icha okitlapowijkeh imona n Pedro omokokoaya ika chikawak totonik. ");
INSERT INTO nplNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús omotolo inawak n siwatl iwa okinawati n totonik makisa. N totonik okiski iwa imona n Pedro owalme iwa opé kintekichiwilia. ");
INSERT INTO nplNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ijkuak okalak tonati, nochteh akimeh okimpiayah inkokoxwah okwalinwikilijkeh n Jesús, iwa Ye okintlaliliaya imawah impah n kokoxkeh iwa okimpajtiaya. ");
INSERT INTO nplNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Miakeh de nonteh kokoxkeh okimpiayah espíritus amokualteh, iwa ijkuak okisayah otsajtsiah iwa okijtoayah: —Te Ikone Dios. Pero Jesús okinmajwaya n espíritus amokualteh iwa amo okinkawiliaya matlajtokah, porke yejwah okimatiah Ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ijkuak otláneski, Jesús okiski de kan altepetl iwa oyá iselti kan amaka onemia. Pero n tlakah okitemojkeh, iwa ijkuak okajsitoh, okinekiah kitsakuiliskeh para amo makinkakajtewa. ");
INSERT INTO nplNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús okinmili: —Nikpia nitetlapowiti de kan tlanawatia Dios ika n kualitlájtoli intech oksikimeh altepemeh, ken ika ye onechaltítlanki Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iwa Jesús otlamachtijtinemia itech sinagogas de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Se tonati Jesús oyá itempa n lago de Genesaret, iwa miakeh tlakah asta omotojtopewayah inawak ken okinekiah kikakiskeh itlajtol Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús okoninmitak ome barkas san ijkeh itempa n atl, porke n michmajkeh otetemokah iwa okimpaktokah inmichayawah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ijkuakó Jesús otlejkok itech seme de nonteh barkas iaxkawah n Simón, iwa okitlatlaujti makijkuani ok achitsi kan tlawejkatla. Otlanki Jesús omotlali ijtik n barka iwa opé kinmachtia akimeh omoololojkeh itempa n atl. ");
INSERT INTO nplNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ijkuak Jesús yotlanki okintlapowi, okili n Simón: —Xikijkuani n barka kan okachi tlawejkatla, xikonintlamotlakah nomomichayawah iwa ompa ximichmaakah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón okinankili: —Tlamachti, interojyúali yotikyejyekojkeh timichmaaskeh iwa nion se michi otikkitskijkeh, pero tla Tejwatsi titlanawatia, ye nikonchiwas. ");
INSERT INTO nplNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ijkuak okontlamotlakeh inmichayawah, saikpanoa miakeh michimeh okinkitskijkeh iwa inmichayawah opé kokotokah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ijkuakó okoninmanotskeh sikimeh michmajkeh non ik ompa okatkah itech ok se barka, para makimpalewikih. Yejwah okimpalewikoh, iwa okintemitijkeh inbarkajwah ika miak michimeh iwa asta yoapolakiah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ijkuak Simón Pedro okitak nochi ni, omotlankuáketski iyakapa n Jesús iwa okili: —Noteko, amo xiwalmijkuani nonawak, porke ne nitlajtlakole. ");
INSERT INTO nplNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón ijkó okijto porke Ye iwa non inwah okatka satlawel okinmojtih ijkuak okitakeh senmiaktikeh michimeh okinkitskijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Noiwa n Jacobo iwa n Juan, itelpochwah n Zebedeo non otekitiah iwa n Simón, saikpanoa omomojtijkeh. Pero Jesús okili n Simón: —Amo ximawi, axa te ayakmó timichmas, yej pewas tikinmichmas tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ompa, san nima ijkuak okwalinkixtijkeh inbarkajwah itempa n atl, okikakajtejkeh nochi iwa oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ijkuak Jesús okatka itech se altepetl, okalakiko se tlakatl non okipiaya lepra. Iwa ijkuak okitak n Jesús, omotlankuáketski iyakapa asta okitelkoto n tlali ika ixkuak, iwa ijkí okitlatlaujti: —Noteko, tla Tejwatsi tikmonekiltia, weletis techchipawas de nokokolis. ");
INSERT INTO nplNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ijkuakó Jesús okitelko n kókoxki iwa okijto: —Nikmonekiltia. ¡Ximochipawa! Ijkuak ijkó okijto, isawawah n kókoxki san owalpolikeh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Otlanki Jesús okinawati amaka makimatilti, iwa okili: —Xio ximoteixpantiti inawak n tiópixki, iwa xiktemaka tlan Moisés otlanawati por mochipawalis. Ijkó nochteh makimatikah yotimochipa de mokokolis. ");
INSERT INTO nplNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yika nochi tlan Jesús okichiwaya san kan ik yetos okachi omomatia, iwa miakeh tlakah omoololoayah para kikakiskeh itlajtol iwa para makimpajti. ");
INSERT INTO nplNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús omoixkoyantiaya, iwa oyaya kan amaka okitaya iwa ompa onmotiotsajtsiliaya. ");
INSERT INTO nplNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Se tonati, Jesús otlamachtijtoka iwa ik ompa oewatokah sikimeh fariseos iwa sikimeh tlamachtijkeh de intlanawatil. Yejwah owalajkeh de nochteh altepetsitsinteh de Galilea, de Judea iwa de Jerusalén. Iwa ika ichikawalis Dios, Jesús okimpajtiaya n kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ijkuakó okalakikoh sikimeh tlakah non okualikayah itech ikuaujtlapech se tlakatl non osentitikak. Ijkuak okalakitoh itech kali kan Jesús otlamachtijtoka, yejwah okitemoliayah kenijki kikalakiskeh iwa kitlaliskeh iyakapa n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero mach oweletkeh okikalakijkeh, porke miakeh tlakah okatkah kaltempa. Ijkuakó otlejkokeh ikpak kali, okikuatlapojkeh, iwa ik ompa okitemowijkeh n kókoxki ika nochi ikuaujtlapech, iwa tlatlajkotia okitlalijkeh, kan okatka n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ijkuak Jesús okitak kenijki ninteh tlakah okineltokakeh, okili n kókoxki: —Tlakatl, nimitstlapojpolwia de motlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ijkuakó non kitemachtiah n tlanawatílistli iwa n fariseos opé mokuatlapowiah: “¿Akí nin tlakatl non ika itlajtol kixpanawijtok n Totajtsi Dios?” Amaka weleti kintlapojpolwia tlajtlákolteh, sanwel Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús okimatia tlan yejwah omokuatlapowijtokah, iwa okinmili: —¿Tleka ijkó nonkimoliah itech nomoyolo? ");
INSERT INTO nplNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tlan okachi amo owi se kijtos: “Motlajtlakolwah ya tlapojpolwitokeh”, noso okachi owi se kijtos: “Ximewa iwa xinejnemi”? ");
INSERT INTO nplNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yika xikmatikah, Ne Non onimochi ni tlakatl nikpia weletílistli itech nin tlaltíkpaktli para nikintlapojpolwis tlajtlakolteh. Ijkuakó okili n kókoxki: —Ne nimitsilia, ximewa, xikonana mokuaujtlapech iwa xiajti mocha. ");
INSERT INTO nplNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Inmixpah, n kókoxki owalmóketski, okajkok ikuaujtlapech iwa oyá icha kiweyijkachijti Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iwa nochteh non ompa okatkah omotlajtlachialtijkeh iwa okiweyijkachijkeh Totajtsi Dios, iwa ika miak mawílistli okijtojkeh: —Nin tonati otikinmitakeh wejweyi neskayolteh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Satepa, Jesús okiski de ompa iwa okitak se tominoololo non omonotsaya Leví. Ye oewatoka kan motlaxtlawa impuesto de Roma, iwa Jesús okili: —Xiwiki nowa. ");
INSERT INTO nplNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","San nima n Leví omóketski, okikakajte nochi iwa oyá iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Satepa, Leví okichi se weyi ilwitl para Jesús, iwa miakeh tominoololojkeh iwa n oksikimeh tlakah otlakuajtokah inwah. ");
INSERT INTO nplNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero n fariseos iwa n tlamachtijkeh de intlanawatilis, opé kimpojpoah itlamachtijkawah n Jesús, iwa okimilijkeh: —¿Tleka nontlakuah iwa nonkonih iwan tominoololojkeh iwa n tlajtlakolchijkeh? ");
INSERT INTO nplNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús okinnankili: —N tlakah chikawakeh amo kimotlakewiah se tlapajti, yej non kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne amo onikinnotsako non yekmilajkameh. Ne onikinnotsako n tlajtlakolchijkeh, para mamoyolpatlakah inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ijkuakó yejwah okitlajtlanijkeh n Jesús: —¿Tleka itlamachtijkawah n Juan iwa itlamachtijkawah n fariseos nochipa mosawah iwa motiotsajtsiliah, pero motlamachtijkawah nochipa tlakuah iwa konih? ");
INSERT INTO nplNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús okinnankili: —¿Kox weletis nonkitoktiskeh aka mamosawa itech se monamiktilo ijkuak n novio kajki íwa? ");
INSERT INTO nplNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Witseh tonatijmeh ijkuak kinkixtiliskeh n novio, ijkuakó mosawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Noiwa okinmili nin tlapoálistli: —Amaka kitlamanilia itlake non ya wewe ika se yankuik tsótsoli. Porke tla ijkó kichiwa, okachi kijtlakoa itlake, porke n yankuik tsótsoli mokototsoa iwa mach kinamiki. ");
INSERT INTO nplNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nion amaka kitlalia yankuik vino itech se kuilambre ya wewe. Porke tla se ijkó kichiwa, n yankuik vino kitsomonia n kuilambre, iwa san ken omeh pojpoliwih. ");
INSERT INTO nplNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yika, moneki se kitlalis n yankuik vino itech yankuik kuilambre, iwa ijkó san ken omeh wejkawaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iwa amaka kineki konis n yankuik vino ijkuak yokonik n vino non yowejka tlatitok, porke kijtoa: “N vino non yowejka tlatitok okachi kuali.” ");
INSERT INTO nplNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Se sábado ijkuak mosewia n judíos, Jesús iwa itlamachtijkawah opajpanotiayah kan ik tlatooktok, itlamachtijkawah opé tlakuatejtekih, okimaxotomayah iwa okikuayah itliolyo n tlátoktli. ");
INSERT INTO nplNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ijkuakó sikimeh fariseos okintlajtlanijkeh: —¿Tleka nonkichiwah tlan amo moneki se makichiwa itech sábado? ");
INSERT INTO nplNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús okinnankili: —¿Ayamó nonkiamapoah tlan okichi n David iwa non iwa oyayah, se tonati ijkuak owalxitlatlakeh? ");
INSERT INTO nplNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David okalak ijtik ikal Dios iwa okinmónanki n tlatiochiwalpameh. Otlanki okinkuah, iwa okinmajmák noiwa akimeh oyayah íwa, maya ninteh pameh sanwel n tiopixkeh okinkawiliayah makinkuakah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Noiwa okinmili: —Ne Non onimochi ni tlakatl noiwa niknawatia n sábado. ");
INSERT INTO nplNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ok se sábado ijkuak mosewia n judíos, Jesús okalak itech sinagoga iwa opé tlamachtia. Ompa okatka se tlakatl non opitswak imayekma. ");
INSERT INTO nplNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","N fariseos iwa n tlamachtijkeh, sa okitokatinemiah n Jesús para kitaskeh kox kipajtiskia non tlakatl itech sábado iwa ijkó weletis kiteiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús okimatia tlan yejwah okiyejyekoliayah, iwa okili n tlakatl non okipiaya imayekma pitswak: —Ximoketsa iwa xiwiki nika tlatlajkotia. N tlakatl omijkuani iwa omoketsato tlatlajkotia. ");
INSERT INTO nplNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ijkuakó Jesús okinmili non ompa okatkah: —Ne nikneki nomechtlajtlanis: ¿Tlan moneki se kichiwas itech sábado, tlan kuali noso tlan amokuali? ¿Tikpalewiskeh mayolito se tokni, noso tejwah tikmiktiskeh? ");
INSERT INTO nplNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ijkuakó Jesús okintlatlajtlatak nochteh non okiyawalojtokah, iwa okili n tlakatl: —Xikmilawa moma. N tlakatl okimila ima, iwa san nima owalpajtik. ");
INSERT INTO nplNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","N fariseos okualankamikeh, iwa opé kimoliah tlanón kitoktiskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Itech nekateh tonatijmeh, Jesús otlejkok itech se tepetl iwa omotiotsajtsilito interojyúali. ");
INSERT INTO nplNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ijkuak otláneski, okínnotski itlamachtijkawah iwa okimpéjpenki májtlaktli iwa ome (12) de yejwah, iwa okintlalili intoka apóstoles. ");
INSERT INTO nplNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yejwah ninteh akimeh okimpéjpenki: Simón, akin Jesús noiwa okitlalili itoka Pedro, iwa ikni Andrés; Jacobo iwa n Juan; Felipe iwa n Bartolomé, ");
INSERT INTO nplNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo ipiltsi n Alfeo; Simón akin okitokayotiayah Zelote, iwa n ");
INSERT INTO nplNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ikni n Jacobo; iwa n Judas Iscariote, akin satepa kitemaktiskia n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús otemok itech tepetl iwa itlamachtijkawah, iwa omoketsatoh ixtlawak. Noiwa ompa okatkah miakeh tlakah non owalajkeh de nochteh n altepemeh de Judea, de Jerusalén, de Tiro, iwa Sidón. Yejwah owalajkeh okikakikoh n Jesús iwa para makimpajti de inkokolis. ");
INSERT INTO nplNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Noiwa okimpajtiaya akimeh okimpiayah espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nochteh okinekiah kitelkoskeh n Jesús, porke ika iweletilis okimpajtiaya. ");
INSERT INTO nplNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ijkuakó Jesús okintlajtlatak itlamachtijkawah iwa okinmili: —Miak yolpakílistli nonkipiah nomejwah akimeh non próbesteh, porke nonkipiah tlan nomoaxka kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Miak yolpakílistli nonkipiah nomejwah non axa nonxitlatlah, porke satepa nonmixwiskeh. 'Miak yolpakílistli nonkipiah akimeh axa nonchokah, porke satepa nonwetskaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Miak yolpakílistli nonkipiaskeh ijkuak nomechkokoliskeh, ijkuak nomechtotojtokaskeh, ijkuak nomechwijwikaltiskeh iwa ijkuak nomechtlawelitaskeh por nonnechneltokah Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Xiyolpakikah itech non tonati iwa xiwetskakah, porke yetos weyi nomotlaxtlawil kan ilwikak, porke intatawah akimeh asta axa tlajtlakolchiwah, noijkó okintlaijyowiltijkeh n profetas. ");
INSERT INTO nplNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","'Pero miálmasteh nomejwah akimeh nonkitlawelpiah tomi, porke yononmopaktijkeh kemi ononkinekeh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Miálmasteh akimeh axa nonmixwitokeh, porke satepa nonmapismikiskeh. 'Miálmasteh akimeh axa nonwetskah porke satepa nonchokaskeh ika neyolkókoli. ");
INSERT INTO nplNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Non miálmasteh ijkuak nochteh n tlakah ayakmó kimatiskeh kenomi nomechweyiliskeh. Porke intatawah akimeh asta axa kichiwah tlajtlákoli noijkó satlawel okinweyiliayah n profetas tekajkayajkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","'Pero nomejwah akimeh nonnechtlakitah, Ne nomechilia: Xikintlasojtlakah akimeh amo nomechtlasojtlah, iwa xikinchiwilikah tlan kuali akimeh nomechkokoliah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Noiwa xiktlajtlanilikah Dios makintiochiwa akimeh nomechwijwikaltiah, iwa ximotiotsajtsilikah por akimeh fiero nomechtenewah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tla aka mitsixtlatsinia, xikkawili noiwa mamitsixtlatsini ojkatia, iwa tla aka mitskixtilia mokoto, xikkawili makiwika noiwa mokamisa. ");
INSERT INTO nplNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Akin mitstlajtlanilia itla, xikmaka, iwa tla aka mitskixtilia itla, ayakmó xiktlajtlanili. ");
INSERT INTO nplNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xikchiwakah tlan kuali, ijkó kemi nomejwah nonkinekih makichiwakah tlan kuali nomowah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","'Tla nomejwah nonkintlasojtlah sanwel akimeh nomechtlasojtlah, amo kuali tlan nonkichiwah. Porke non amo kixmatih Dios noijkó kichiwah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tla nonkinchiwiliah tlan kuali sanwel akimeh nomechchiwiliah tlan kuali, amo kuali tlan nonkichiwah. N tlajtlakolchijkeh noijkó kichiwah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Noso tla aka nonkitlanetiah itla, porke non kimoliah satepa ye noiwa nomechmakas itla, amo kuali tlan nonkichiwah. Noiwa n tlajtlakolchijkeh kintlanetiah akimeh iwa mowikah, porke kimatokeh ok se tonati noiwa kintlanetiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ne nomechilia: Xikintlasojtlakah akimeh nomechkokoliah, iwa xikinchiwilikah tlan kuali iwa xiktetlanetikah. Iwa amo xikchiakah itla manomechmakakah. Tla ijkó nonkichiwaskeh, nonkiseliskeh weyi nomotlaxtlawil. N Totajtsi Dios nomechyekselis kemi ipilwah, porke Ye kinmiknomati akimeh amo motlasojkamatih innawak iwa akimeh tlajtlakolchiwah. ");
INSERT INTO nplNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xiteiknomatikah ijkó kemi Nomotajtsi teiknomati. ");
INSERT INTO nplNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","'Amo xikimpojpoakah oksikimeh, ijkó Dios amo nomechpojpoas. Amo xitetlajtlakoltikah ijkó Dios amo nomechtlajtlakoltis. Xitetlapojpolwikah iwa Dios nomechtlapojpolwis. ");
INSERT INTO nplNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xitetlatliokolikah iwa Dios nomechtlatliokolis. Ye nomechmakas se kuali tlatamachíwale, tejtélinki, tetentok iwa kitsonewiltis. Dios nomechkopilis ijkó kemi nomejwah ononkitemakakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús noiwa okinmili nin tlájtoli: —¿Se non amo tlachia weletis kiyakanas ok se kemi ye? ¿Amo motekochwiskeh san ken omeh? ");
INSERT INTO nplNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Se akin momachtia amo okachi kimati ke itlamachti. Pero tla kimokawilia makimachtikah, motlamiti kemi itlamachti. ");
INSERT INTO nplNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","'¿Kenijki weleti tikita n tlajsoltsintli non kipixtok mokni kan ixtololo, iwa amo tikita n tláktsontli non tikpixtok te kan moixtololo? ");
INSERT INTO nplNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iwa tla amo tikita n tláktsontli non tikpixtok kan moixtololo, ¿kenijki timixewia tikilia mokni: “Noknitsi, manimitsonkixtili n tlajsoltsintli non tikpixtok kan moixtololo”? ¡Íxkoptli!, achto xikmokixtili n tláktsontli non tikpixtok kan moixtololo, iwa ijkó ya weletis tiyektlachias para weletis tikixtilis n tlajsoltsintli non kipixtok mokni kan iixtololo. ");
INSERT INTO nplNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","'Se kuali kuawitl, amo weletis kitemakas amokuali itlakilo. Nion se amokuali kuawitl weletis kitemakas kuali itlakilo. ");
INSERT INTO nplNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yika, nochi kuawitl moixmati ika itlakilo, porke amo motekih igos de kan witsmeh, nion tikintekih uvasteh de kan tlatsmolteh. ");
INSERT INTO nplNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Noiwa n kuali tlakatl, ijkuak tlajtoa kitenkixtia tlan kuali kitlaatijtok itech iyolo. Iwa n tlakatl amokuali kinmijtoa tlájtolteh amokualteh porke tlan amokuali kajki itech iyolo. Nochi tlan kitenkixtia se tlakatl, ye noni tlan kipixtok itech iyolo. ");
INSERT INTO nplNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","'¿Tleka nonnechnotsah, “Noteko, Noteko”, iwa amo nonkichiwah tlan Ne nomechilia? ");
INSERT INTO nplNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Axa nomechajsikamatiltis kenomi nonkixmatiskeh n tlakatl non milák wits nonawak, iwa nechkaki iwa kitlakita notlajtol. ");
INSERT INTO nplNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ye kemi se tlakatl akin omokalti. Achto otlachkuak tlawejkatla iwa ikal okitlajtlakxili ipan tetl. Ijkuak owala n kiawitl, n atepiatl omomiakili iwa opé kitsinwiteki n kali, pero n kali amo owetski porke otlakxilitoka ipan tetl. ");
INSERT INTO nplNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero akin nechkaki iwa amo kichiwa tlan nikijtoa, noni kemi se tlakatl akin okichijchi ikal itech tlali iwa amo kuali okitlakxili. Ijkuak omomiakili n atepiatl, okitsinwitek n kali iwa san nima owetski. ");
INSERT INTO nplNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ijkuak Jesús otlanki okinmachti n tlakah, okalakito Capernaúm. ");
INSERT INTO nplNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ompa ochantitoka se soldado romano tlayákanki non okipiaya se itlakewal non satlawel okitlanekiliaya non yomiktoka. ");
INSERT INTO nplNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ijkuak n tlayákanki okikak omotlapowiayah de Jesús, okintítlanki sikimeh tetajmeh non tlayakantokeh kan tiopa para makitlatlaujtitih makipajtiliki itlakewal. ");
INSERT INTO nplNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yejwah okalakikoh inawak Jesús iwa okilijkeh: —Kuali ka tla tikpalewis nin tlayákanki romano, ");
INSERT INTO nplNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porke maya amo israelita, ye satlawel kitlasojtla topaís, iwa ye inewia otlanawati matechchijchiwilikah se tosinagoga. ");
INSERT INTO nplNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ijkuakó Jesús oyá inwah. Pero ijkuak ya onkalakiah itech kali, n tlayákanki romano okintítlanki sikimeh itlakaikniwah makilitih n Jesús: —Noteko, tla amo weletis tias nocha, amo ximotekipacho, porke ne mach ni tlawel kuali para nimitsompanoltis ijtik nocha. ");
INSERT INTO nplNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yika, mach onimixewi onimitstemoto nonewia. Sanwel xikijto “Mapajti”, iwa ye walpajtis. ");
INSERT INTO nplNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porke ne noijki nikpia akin nechnawatia, iwa noijki nikimpia sikimeh soldadojteh akimeh nikinnawatia. Tla seme de yejwah nikilia mawia, yawi; iwa tla ok se nikilia mawiki, wits; iwa ijkuak niknawatia notlakewal makichiwa itla, kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ijkuak Jesús okikak, omotlajtlachialti non tlayákanki romano, iwa okinchikoitak non okwaltokayah iwa okijto: —De milajka nomechilia, itech nochi país de Israel mach nikkajsitika aka non satlawel matlaneltoka kemi ye. ");
INSERT INTO nplNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ijkuak n tlakah non okintitlankeh omokopkeh icha n tlayákanki romano, okajsitoh n tlakéwale yopajtik. ");
INSERT INTO nplNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Okachi satepa, Jesús oyá kan se altepetl non itoka Naín, iwa itlamachtijkawah iwa oksikimeh tlakah oyayah íwa. ");
INSERT INTO nplNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ijkuak Jesús yonkalakia itech non altepetl, okimitak sikimeh tlakah non okiwikayah kitookatiweh se miketl. Ye ikone se iknosiwatl non sanwel se ipiltsi okípixki, iwa miakeh okiwikayah kitookatiweh. ");
INSERT INTO nplNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ijkuak Toteko okitak n iknosiwatl okiknoma, iwa okili: —Ayakmó xichoka. ");
INSERT INTO nplNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ijkuakó Jesús omijkuani iwa okitelko ikaja n miketl, iwa non okimamajtiayah omoketskeh. Iwa Jesús okili n miketl: —Télpochtli, Ne nimitsilia: ¡Ximoketsa! ");
INSERT INTO nplNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","San nima n télpochtli non omiktoka, owalmotlali iwa opé tlajtoa, iwa Jesús okimaktili ina. ");
INSERT INTO nplNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ijkuak ijkí okitakeh, nochteh omaujkeh iwa opé kiweyijkachiwah Dios, iwa okijtoayah: —Se weyi profeta yomonextiko tonawak. Noiwa okijtoayah: —N Totajtsi Dios yowala okipalewiko ialtépeu. ");
INSERT INTO nplNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Itech nochi n tlali de Judea iwa n altepemeh non kiyawalojtokeh omoma tlan Jesús okichi. ");
INSERT INTO nplNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Itlamachtijkawah n Juan okimatiltijkeh nochi tlan otlamochijtoka, iwa ye okínnotski ome itlamachtijkawah, ");
INSERT INTO nplNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","iwa okintítlanki inawak Jesús para makitlajtlanitih kox Ye n Cristo Akin walaskia, noso kichiaskiah ok se. ");
INSERT INTO nplNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","N tlakah non okintítlanki n Juan okalakitoh inawak Jesús iwa okilijkeh: —Juan Bautista otechaltítlanki matimitstlajtlanikih kox Tejwatsi Akin walaskia, noso tikchiaskeh ok se. ");
INSERT INTO nplNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Itech non ora ijkuak yejwah okalakitoh, Jesús okimpajti miakeh kokoxkeh de inkokolis, intlaijyowilis, iwa okinkixtiliaya espíritus amokualteh. Noiwa miakeh non amo otlachiayah okinmák intlachialis. ");
INSERT INTO nplNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ijkuakó Jesús okinmili: —Ximokopakah kan Juan iwa xikilikah tlan yononkitakeh iwa ononkikakeh. Xikmatiltikah: non amo otlachiayah, ya tlachiah, non amo onejnemiah, ya nejnemih; non okipiayah lepra, yopajtikeh; non amo otlakakiah, ya tlakakih. Non yomikkeh, moyolitiah, iwa n próbesteh kinmatiltiah n kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Miak pakílistli kipias akin nechneltokah. ");
INSERT INTO nplNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ijkuak oyajkeh itlamachtijkawah n Juan, Jesús opé kintlapowia n tlakah non ompa okatkah de Juan Bautista: —¿Tlan ononkitatoh kan amaka chanti? ¿Ononkitatoh se akatl non okoliniaya n ejekatl? ");
INSERT INTO nplNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tlan ononkitatoh? ¿Ononkitatoh se tlakatl non yektlakentitok? Nomejwah nonkimatih akimeh moyektlakentiah, chantitokeh incha n reyes. ");
INSERT INTO nplNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tlan ononkitatoh? ¿Ononkitatoh se profeta? Milák, ye se profeta, iwa okachi weyijkatitok ke oksikimeh profetas. ");
INSERT INTO nplNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ye de akin tlajtoa itlajkuilol Dios: Ne niktlayakanaltis akin tlatematiltijtias moyakapa para mamitsmajmanili n ojtli. ");
INSERT INTO nplNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","De milajka nomechilia amo otlakatki ok se okachi weyijkatitok ke Juan, pero akin kimokawilia Dios makiyakana okachi weyijkatitos ke Juan. ");
INSERT INTO nplNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ijkuak okikakeh nochi ni, nochteh n tlakah iwa n tominoololojkeh non okiselijkah itlakuaatekilis n Juan, okajsikamatkeh Dios yekmilajka. ");
INSERT INTO nplNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero n fariseos iwa n tlamachtijkeh de intlanawatilis, amo okiselijkeh itlakuaatekilis n Juan. Okixnamikeh tlan Totajtsi Dios okinekia kichiwaskia inwah. ");
INSERT INTO nplNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iwa okinmili: —¿Kenomi motah n tlakah itech ninteh tonatijmeh? ¿Kenomi akimeh inyalis? ");
INSERT INTO nplNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mota kemi pípilteh non mawiltia tiánkistli iwa motsatsajtsiliah: “Otomechtlapichilijkeh ika akatlapítsali iwa amo ononmijtotijkeh; otomechintlakuikilijkeh tlakuíkalteh teyolkokojkeh iwa amo ononchokakeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Owala n Juan Bautista, ye amo okikuaya paj nion okoniaya vino, iwa nomejwah nonkijtoah kipia se amokuali espíritu. ");
INSERT INTO nplNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Satepa oniwala Ne Non onimochi ni tlakatl, iwa Ne nitlakua iwa nikoni, iwa nomejwah nonkijtoah Ne niápistli iwa tlawel nikoni, nimowikatinemi iwan tlajtlakolchijkeh iwan tominoololojkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero akin de milajka kajsikamati tlan Dios kimonekiltia, kinextia itech tlan kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Se fariseo, non itoka Simón, okontlalwi n Jesús matlakuati icha. Jesús oyá icha iwa omoyayanti inakastla n mesa. ");
INSERT INTO nplNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ijkuakó se siwatl tlajtlakolchi itech non altepetl, okima Jesús otlakuajtoka iwan fariseo. Okalakito ika se itekontsi tentika ika ajwiálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chokati, omotlali ikxitla n Jesús iwa ika ixayo opé kinsiawilia ikxiwah. Otlanki ika itsonkal okinwajwachili ikxiwah. Okintennamik iwa okinxajxawili n ajwiálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ijkuak n fariseo non okitlalwi n Jesús okitak tlan okitoktijtoka non siwatl, okimoli: “Tla nin tlakatl yetoskia n profeta, kimatiskia aki nin siwatl non kikxitelkojtok, porke nin siwatl, ye tlajtlakolchi.” ");
INSERT INTO nplNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ijkuakó Jesús okili n fariseo: —Simón, nikneki nimitsilis itla. N Simón okinankili: —Kuali ka, Tlamachti, techili. ");
INSERT INTO nplNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús okili: —Se tlakatl non okitetlanetiaya tomi, okintlaneti tomi ome tlakah. Se okiwikiliaya mákuili siento denariojtomi, iwa n ok se san tlajko siento denariojtomi. ");
INSERT INTO nplNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iwa kemi amo oweletiah okikopiliayah itomi, san ken omeh okintlapojpolwili tlan okiwikiliayah. Axa monewia techili, ¿katlie de ninteh ome okachi okitlasojtlak? ");
INSERT INTO nplNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón okinankili: —Ne nikijtoa, akin okachi miak okitlapojpolwili. Jesús okili: —Milák kemi otikyejyekoli. ");
INSERT INTO nplNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Otlanki Jesús okonitak n siwatl, iwa okili n Simón: —¿Tikita nin siwatl? Onikalak mocha, iwa amo otechmák atl para nokxiwah. Pero nin siwatl, ika ixayo onechikxipajpak iwa ika itsonkal onechinwajwachili. ");
INSERT INTO nplNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te amo otechixtennamik, pero nin siwatl desde onikalakiko opé nechikxitennamiki. ");
INSERT INTO nplNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te amo otechkuaxawili aseite. Pero nin siwatl onechxawili ajwiak pajtli ipan nokxiwah. ");
INSERT INTO nplNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yika nimitsilia, nochteh itlajtlakolwah ya tlapojpolwitokeh ken miak otetlasojtlak. Pero akin san achitsi kitlapojpolwiah san achitsi tetlasojtla. ");
INSERT INTO nplNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Otlanki Jesús okili n siwatl: —Motlajtlakolwah ya tlapojpolwitokeh. ");
INSERT INTO nplNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iwa n tlatlálwilteh non otlakuajtokah iwa Jesús, opé moichtakatlapowiah: —¿Akin nin tlakatl, non kintlapojpolwia tlajtlakolejkeh? ");
INSERT INTO nplNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús okili n siwatl: —Motlaneltokalis yomitsmakixti, xiajti ika yolsewílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Okachi satepa, Jesús otlamachtijtijtinemia itech miakeh altepemeh. Ye okintlapowijtinemia de n kualitlájtoli de Dios. N májtlakteh iwa ome tlatematiltijkeh íwa oyayah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Noiwa oyayah iwan Jesús sikimeh siwameh non Ye okimpajtijka de miak kokólisteh iwa de espíritus amokualteh. Inwah oyaya n María de Magdala, akin Jesús okinkixtilijka chikome espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Noiwa ompa oyaya n Juana, isiwa n Chuza, akin okitaya nochi tlan okipiaya n Herodes, iwa n Susana, iwa n oksikimeh siwameh non okipalewiayah n Jesús ika tlan okipiayah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miakeh tlakah owalkiskeh de inmaltépeu okitatoh n Jesús; iwa ijkuak omoololojkeh, Jesús okintlapowi ika tlapoálisteh, iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Se tlakatl otookato, iwa ijkuak okitepejtoka xínachtli, siki owetski inakastla n ojtli, akimeh ik ompa opanoayah okitlajtlaksakeh iwa n totomeh okikuajkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oksiki xínachtli owetski kan tlateyo; iwa ijkuak oixwak niman owaki ken amo okipiaya kuichawálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oksiki xínachtli owetski intsalko witsmeh, iwa n witsmeh non inwah omoskaltiayah okimijyomiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero oksiki xínachtli owetski itech kuali tlali; iwa ijkuak omoskalti, kualtsi otlaaki, iwa okitlakilti se siento por se xínachtli. Ijkuak Jesús otlanki okintlapowi, otlajto chikawak iwa okinmili: —¡Akin de milajka kipia inakas, makajsikamati! ");
INSERT INTO nplNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ijkuakó itlamachtijkawah n Jesús okitlajtlanijkeh tlan kijtosneki non tlapoálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús okinmili: —Dios yonomechkawili xikajsikamatikah kenomi Ye tlanawatia. Pero non oksikimeh nikintlapowia ika tlapoálisteh. Yika, maya tlachiah, amitla kitah, iwa maya tlakakih amo kajsikamatih. ");
INSERT INTO nplNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","'Ye ni tlan kijtosneki n tlapoálistli: N xínachtli kijtosneki itlajtol n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","N xínachtli non owetski inakastla n ojtli, yejwah n tlakah akimeh kikakih itlajtol Dios, pero wits n diablo iwa kinyolkixtilia para amo makineltokakah iwa Dios amo makinmakixti. ");
INSERT INTO nplNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","N xínachtli non owetski kan tlateyo, yejwah akimeh kiseliah ika pakílistli itlajtol Dios, pero ken amo nelwayojkeh, san kech tonati tlaneltokah inawak Dios, pero ijkuak kinyejyekoa n diablo, mosotlawah iwa kikawah Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","N xínachtli non owetski intsalko witsmeh, kijtosneki akimeh kikakih itlajtol Dios, pero amo kimokawiliah makinyakana, yej okachi kintekipachoa inteki. Kinekih kitlawelpiaskeh tomi iwa satlawel kinekih mopaktiskeh, yika itech tlan kichiwah ayik kitenextiah itlasojtlalis Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero n xínachtli non owetski itech kuali tlali, yejwah akimeh ika kuali inyolo kikakih n kualitlájtoli iwa kitlakitah, kimokawiliah makinyakana Dios iwa ijkó weletih kitenextiah itlasojtlalis. ");
INSERT INTO nplNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","'Amaka kimilintia se tláwili iwa tlami kitlalia itlampa se chikiwitl noso itlampa se kama, yej kontlalia tlakpak para makintlawili akimeh kalakih itech kali. ");
INSERT INTO nplNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yika, nochi tlan tlaatitok monextis, iwa tlan amo momati saman momatis. ");
INSERT INTO nplNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Ijkó kiné, kuali xikkajsikamatikah, akin kajsikamati kenijki Dios tlanawatia, kinextiliskeh okachi, iwa akin kijtoa san achitsi yokajsikama kitoktiskeh makilkawa tlan achitsi yokajsikamatka. ");
INSERT INTO nplNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ijkuakó imamá iwa ikniwah n Jesús okalakitoh kan otlamachtijtoka, pero amo oweletkeh okalakeh inawak porke miakeh tokniwah ompa okatkah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ijkuakó aka okilito n Jesús: —Momamá iwa mokniwah kateh kaltempa, iwa kinekih mitsitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero Jesús otlanankili: —Akimeh kikakih itlajtol Dios iwa kitlakitah, yejwah nomamá iwa nokniwah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Se tonati Jesús otlejkok itech se barka iwa itlamachtijkawah, iwa okinmili: —Matikojchalwikah n lago. Iwa nochteh oyajkeh, ");
INSERT INTO nplNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","pero ijkuak okikojchalwijtokah n lago, Jesús okochki. Iwa owalajsitiwetsiko se ejekatl chikaktik non okiatemitiaya n barka iwa yoapolakia. ");
INSERT INTO nplNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ijkuakó itlamachtijkawah n Jesús okiijxititoh iwa okilijkeh: —¡Tlamachti, Tlamachti! ¡Tiapolaktokeh! Jesús owalmóketski iwa okintlakawalti n amemélolteh iwa n ejekatl; iwa nochi san owaltlamoka. ");
INSERT INTO nplNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Satepa Jesús okinmili itlamachtijkawah: —¿Kanin kajki nomotlaneltokalis? Pero yejwah omotlajtlachialtijkeh, omomojtijkeh iwa omotlatlajtlaniayah: —¿Akí nin tlakatl, porke asta ejekatl iwa n atl kitlakita? ");
INSERT INTO nplNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yejwah okalakitoh kan tlali de Gadara, non kajki ik nepa lado n lago, iyakapa n Galilea. ");
INSERT INTO nplNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ijkuak Jesús owaltemok de kan barka, se tlakatl de non altepetl owalmijkuani inawak. Nin tlakatl yowejka okimpiaya espíritus amokualteh. Amo omotlakentiaya nion ochanchitoka itech kali, yej san intsalko miketékochteh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ijkuak nin tlakatl okitak n Jesús, omotlankuáketski iyakapa iwa opé tsajtsi: —¿Tlan tikneki nowa, Jesús, Ikone n Totajtsi Dios non weyijkatitok? Nimitstlatlaujtia amo techtlaijyowilti. ");
INSERT INTO nplNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ijkó okijto porke Jesús okinawatijtoka n amokuali espíritu makisa de ijtik non tlakatl. Miak welta n espíritu amokuali yokimoaxkatijka non tlakatl, iwa n tlakatl okimaijilpiayah iwa okikxiijilpiayah ika kadenajteh para amo macholo, pero ye okinkojkotonaya iwa n espíritu amokuali okichololtiaya kan amaka chanti. ");
INSERT INTO nplNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús okitlajtlani: —¿Tlan timotoka? Otlanankili: —Miaktikeh. Ijkó okijto porke miaktikeh espíritus amokualteh okatkah ijtik. ");
INSERT INTO nplNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iwa nonteh espíritus amokualteh okitlatlaujtiayah n Jesús amo makintitlani miktla. ");
INSERT INTO nplNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ik ompa otlakuajtinemiah miakeh pitsomeh, iwa n espíritus amokualteh okitlajtlanilijkeh n Jesús makinkawili makalakikah inmijtik; iwa Jesús okinkawili. ");
INSERT INTO nplNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ijkuakó n espíritus amokualteh okikakajtejkeh n tlakatl iwa okakalakitoh inmijtik n pitsomeh, iwa nochteh nonteh pitsomeh okistewakeh iwa onmokajkawatoh ijtik atl iwa omijmikeh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ijkuak n tlakah non okinmokuitlawijtokah n pitsomeh okitakeh tlan otlamochi, omotlelojkeh otetlapowitoh itech altepetl iwa ik tetlala. ");
INSERT INTO nplNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iwa miakeh tlakah oyajkeh okitatoh tlan otlamochi. Iwa ijkuak okalakitoh kan Jesús, okitakeh n tlakatl non itech okiskeh n espíritus amokualteh. Ye yoewatoka ikxitla n Jesús, yokonakijtoka itlake, porke yotlalnamik, iwa nochteh omaujkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iwa akimeh okitakeh, okintlapowijkeh oksikimeh kenijki opajtik n tlakatl non okimpiaya espíritus amokualteh. ");
INSERT INTO nplNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ijkuakó, nochteh n tlakah de Gadara opé kitlatlaujtiah n Jesús mawia de ompa, ken satlawel omawiah. Yika Jesús otlejkok itech barka iwa oyá. ");
INSERT INTO nplNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","N tlakatl non itech okiskeh n espíritus amokualteh okitlatlaujti n Jesús makiwika, pero Jesús okinawati mamokawa iwa okili: ");
INSERT INTO nplNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ximokopa mocha, iwa xiktetlapowi nochi tlan Dios okichi mowa. N tlakatl oyá, iwa otetlapowi nochi tlan Jesús okichi íwa. ");
INSERT INTO nplNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ijkuak Jesús omokopato, miakeh tlakah okiselijkeh ika pakílistli, porke nochteh sa okichixtokah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ijkuakó oajsiko se tlayákanki de n sinagoga non itoka Jairo. Ye omotlankuáketski iyakapa n Jesús iwa okitlatlaujti mawia icha, ");
INSERT INTO nplNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porke sanwel se itakotsi okipiaya iwa yomiktoka, iwa sikin okipiaya májtlaktli iwa ome xiwitl. Ijkuak Jesús yoyaya icha n Jairo, miakeh tlakah okikuitlapantokakeh iwa sa okipajpatsoayah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Iwa intlajkotiah n tlakah noiwa oyaya se siwatl non yokipiaya májtlaktli iwa ome xiwitl ika esmilawálistli, iwa amaka oweletia okipajtiaya. ");
INSERT INTO nplNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","N siwatl omijkuanijtia ikuitlapa n Jesús iwa okitempantelkoli itlake, iwa san nima iesmilawalis omóketski. ");
INSERT INTO nplNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ijkuakó Jesús otlájtlanki: —¿Akin onechtelko? Kemi nochteh okijtoayah amo okimatiah akin okitelkojka, Pedro okijto: —Tlamachti, nochteh n tlakah mitspajpatsojtiwitseh iwa mitstojtopejtiwitseh, iwa Te titlajtlani: “¿Akin onechtelko?” ");
INSERT INTO nplNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús okijto: —Aka onechtelko, porke onikmachili notech okiski nochikawalis. ");
INSERT INTO nplNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ijkuak n siwatl okitak Jesús yokimatia akin okitelkojka, bibiokatiwits omotlankuáketsato iyakapa. Iwa inmixpah nochteh n tlakah okimokuiti tleka okitlakentelko n Jesús iwa kenijki san totokatijkak owalpajtik. ");
INSERT INTO nplNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ijkuakó Jesús okili n siwatl: —Nokone, axa yotipajtik porke otitlaneltokak. Xio ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús ok otlajtojtoka ijkuak okalakiko se itlakewal n Jairo non okiliko: —Motakotsi yomikki, ayakmó xiktekimaka n Tlamachti. ");
INSERT INTO nplNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero ijkuak Jesús okikak tlan okiliko n tlakatl, okili n Jairo: —Amo ximawi, te xitlaneltoka, iwa motakotsi pajtis. ");
INSERT INTO nplNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ijkuak Jesús okalakito icha n Jairo. Amo okitekawili makalakikah oksikimeh, sanwel Pedro, Jacobo, Juan iwa itajwah n takotsi. ");
INSERT INTO nplNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nochteh omoyolkokojtokah iwa okichokilijtokah n takotsi. Pero Jesús okinmili: —Amo xichokakah; n takotsi mach omikki, sanwel kochi. ");
INSERT INTO nplNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero n tetlajpalojkeh san okiwetskakeh n Jesús porke okimatokah n takotsi yomikki. ");
INSERT INTO nplNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ijkuakó Jesús okimakitski n takotsi iwa okili: —Takotsi, ximewa. ");
INSERT INTO nplNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","N takotsi omoyoliti iwa owalme; iwa n Jesús otlanawati makitlakualtikah. ");
INSERT INTO nplNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Itajwah n takotsi san omotlajtlachialtijkeh. Pero Jesús okinnawati amaka makilikah tlan otlamochijka. ");
INSERT INTO nplNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús okinmoololo májtlakteh iwa ome itlamachtijkawah iwa okinmák weletílistli iwa tlanawatílistli para makinkixtikah n espíritus amokualteh iwa makimpajtikah kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Satepa okintítlanki makitematiltiti itlajtol Dios, iwa makinpajtikah kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iwa okinmili: —Amitla xikwikakah kan ik nonyaskeh, nion nomobasto, nion nomomantajkostal, nion nomotlaxkal, nion nomotomi, sanwel se nomotlakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ijkuak nonkalakitiweh itech se kali, ompa ximokalotikah asta ijkuak non kisaskeh de non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iwa kan amo nomechseliskeh, xikisakah de ompa iwa ximoikxitsejtselokah para makinteilikah por amo onomechselijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ijkó kiné, itlamachtijkawah n Jesús otetlapowijtinemiah n kualitlájtoli itech nochteh n altepemeh, iwa okimpajtiayah kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","N rey Herodes Antipas Primero okima nochi tlan Jesús okichiwaya; iwa amo okimatia tlan kimolis, porke sikimeh okijtoayah Juan Bautista omoyolitijka. ");
INSERT INTO nplNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oksikimeh okijtoayah Elías n profeta akin oksepa yomonextiko, iwa oksikimeh okijtoayah chamo yomoyoliti se improfeta totatawah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes okijto: —Ne nonewia onitlanawati makikechtsontekikah n Juan. ¿Akin yetos non tlakatl non satlawel kitenewah? Iwa Herodes okitemoliaya kenijki kixmatis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ijkuak n májtlakteh iwa ome tlatematiltijkeh omokopatoh, okitlapowijkeh n Jesús tlan okichijkeh, iwa oyajkeh kan amaka kinkuejsoskia, amo wejka de Betsaida. ");
INSERT INTO nplNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero ijkuak n tlakah okimatkeh kan okatka n Jesús, okajsitoh, iwa Ye okinseli iwa okintlapowi kenijki Dios tlanawatia iwa okimpajti n kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ijkuak yotlejtlepuyawatoka, n májtlaktli iwa n ome tlatematiltijkeh onmopachojkeh inawak Jesús iwa okilijkeh: —Xikintitlani n tlakah mamosewitih, mawiah itech altepemeh noso tetlala makimotemolitih tlan kimomajsewiskeh, porke nika amitla onka. ");
INSERT INTO nplNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús okinmili: —Nomejwah xikintlakualtikah. Yejwah okilijkeh: —Sanwel tikimpiah mákuili pameh iwa ome michimeh. Axa, tla mokoati itla tlákuali, tikintlakualtiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ompa okatkah kemi mákuili mil tlakah. Pero Jesús okinmili itlamachtijkawah: —Xikinmilikah mamoololokah iwa mamotlajtlalikah de tlatlajko siento. ");
INSERT INTO nplNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ijkó okichijkeh itlamachtijkawah, iwa nochteh omotlajtlalijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ijkuakó Jesús okinmónanki n mákuili pameh iwan ome michimeh. Oajkotláchixki ilwikak iwa omotlasojkama inawak Totajtsi Dios, sanima okintlajtlápanki n pameh iwa okinmaktili itlamachtijkawah makinxejxelilikah nochteh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nochteh otlakuajkeh iwa kuali oixwikeh. Satepa itlamachtijkawah okoololojkeh n paj tlatlapánali tlan omoka, iwa okintemitijkeh májtlaktli iwa ome chikimeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se tonati ijkuak Jesús omotiotsajtsilijtoka iselti, itlamachtijkawah okalakito kan Ye. Jesús okintlajtlani: —¿Akin Ne? ¿Tlan kimoliah n tlakah? ");
INSERT INTO nplNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yejwah okinankilijkeh: —Sikimeh kijtoah Tejwatsi ti Juan Bautista, oksikimeh kijtoah Tejwatsi ti Elías, iwa oksikimeh kijtoah Tejwatsi tiprofeta non ya wejkawitl omikki iwa axa omoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ijkuakó, Jesús okintlajtlani: —Iwa nomejwah, ¿tlan nonkimoliah? Pedro okili: —Tejwatsi Ti Cristo Akin Dios okwaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús okinnawati amaka makimatiltikah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesús noiwa okinmili itlamachtijkawah: —Ne Non onimochi ni tlakatl moneki nitlaijyowis, iwa nechtlawelitaskeh n tetajmeh non tlayakantokeh kan Weyi Tiopa, iwa n tiopixkeh non tlayakantokeh, iwa non kitemachtiah n tlanawatílistli, nechmiktiskeh. Pero ipan eyi tonati nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Satepa nochteh okinmili: —Tla aka kineki yetos notlamachtijkau, ayakmó makichiwa san tlan ye kineki, yej moneki nochipa manechtlakita, maya makitlaijyowiltikah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Akin kinekis kimakixtis iyolilis kixpolos, pero akin kixpolos iyolilis por nechtematiltia, kimakixtis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Porke, ¿tlan ipati tla se tlakatl kimotlanilia nochi n tlaltíkpaktli pero ye moixpoloa noso yawi miktla? ");
INSERT INTO nplNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","De milajka nomechilia, tla aka pinawa nonawak iwa kipinawilia notlajtol, noiwa Ne Non onimochi ni tlakatl nikmopinawilis ijkuak niwits kemi Rey, ika iweyijkachiwalis Notajtsi iwan iángelwah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","De milajka nomechilia sikimeh non nika kateh amo mikiskeh tlamo achto kitaskeh Dios matlanawati. ");
INSERT INTO nplNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kemi chikweyi tonati satepa, Jesús oyá kan se tepetl omotiotsajtsilito iwa okiwík n Pedro, Jacobo iwa n Juan. ");
INSERT INTO nplNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iwa ijkuak Jesús omotiotsajtsilijtoka, okipatlak ixko iwa itlakeh oistaktiak iwa otsotlania. ");
INSERT INTO nplNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ijkuakó owalmonextijkeh ome tlakah non omotlapowijtokah iwan Jesús. Yejwah okatkah Moisés iwa Elías. ");
INSERT INTO nplNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iwa okinyawalojtoka se tlawilnextílistli, iwa okiliayah n Jesús kenijki kimiktiskiah kan altepetl de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro iwan oksikimeh satlawel okochmikiah, pero ijkuak owaltlajtlachixkeh, okitakeh iweyijkachiwalis Jesús iwan ome tlakah non okatkah íwa. ");
INSERT INTO nplNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ijkuak nekateh tlakah yokikakajtewayah n Jesús, Pedro okili: —Tlamachti, ¡Sa kuali nika tikateh! Matikinchijchiwakah eyi akákalteh, se moaxka, se iaxka Moisés iwa ok se iaxka Elías. Pedro mach okimatia tlan okijtoaya. ");
INSERT INTO nplNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ijkuak Pedro ok otlajtojtoka, se mextli owaltemok iwa okinkemelo, iwa satlawel omomojtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ijkuakó itech mextli owalmokak se tlájtoli non okijtoaya: —Ye ni Nokone non saikpanoa niktlasojtla: xikkakikah tlan Ye nomechilis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ijkuak n tlájtoli san owalmoka, okitakeh n Jesús sa iselti. Yejwah san otlamatokah, iwa amaka okilijkeh tlan okitakeh asta satepa. ");
INSERT INTO nplNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ijkuak owalmostlatik Jesús iwa itlamachtijkawah otemokeh de kan tepetl, iwa miakeh tlakah okinamikitoh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ijkuakó se tlakatl non owalaya intlajko n tlakah, okualtsajtsili n Jesús: —Tlamachti, nimitstlatlaujtia xikonitaki nopiltsi, porke sanwel ye nikpia. ");
INSERT INTO nplNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Se espíritu amokuali kimoaxkatia iwa kitsajtsitia; kitoktia mamimiki iwa kitoktia makikixti posoktli itech ikamak. Semi kitlaijyowiltia iwa owi kikajkawa. ");
INSERT INTO nplNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yonikintlatlaujti motlamachtijkawah makikixtilikah n espíritu amokuali, pero mach oweletkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús okijto: —¡Satlawel amo nonteneltokakeh iwa nontlajtlakolchijkeh! ¿Asta kemania moneki maniyeto nomowah iwa manomechxikojto? Techalikili nika mopiltsi. ");
INSERT INTO nplNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero ijkuak n télpochtli yomijkuanijtiaya inawak Jesús, n espíritu amokuali okitlalwitek iwa opé kitsejtseloa. Ijkuakó n Jesús okitlawelajwak n espíritu amokuali, okipajti n télpochtli iwa okimaktili ita. ");
INSERT INTO nplNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iwa nochteh omotlajtlachialtijkeh ika iweletilis n Totajtsi Dios. Ijkuak nochteh omosentlajtlachialtijtokah, Jesús okinmili itlamachtijkawah: ");
INSERT INTO nplNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kuali xikkakikah tlan nomechilis: Ne Non onimochi ni tlakatl nechtemakaskeh inmak n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero itlamachtijkawah mach okajsikamatiah tlan okimiliaya porke ayamó owalajsia n tonati para makajsikamatikah, iwa omawiah kitlajtlaniskeh tlan kijtosneki tlan okimilijka. ");
INSERT INTO nplNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ijkuakó itlamachtijkawah n Jesús opé motlatlajtolkopah, okinekiah kimatiskeh akin okachi weyijkatitok, ");
INSERT INTO nplNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","pero Jesús yokimatia tlan omokuatlapowijtokah itlamachtijkawah. Ijkuakó okimonapalolti se chokotsi iwa okontlali inakastla ");
INSERT INTO nplNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iwa okinmili: —Akin kiselia se chokotsi itech Notoka, Ne nechselia, iwa akin Ne nechselia, noiwa kiselia akin onechaltítlanki. Porke akin amitla ipati nomonawak, ye akin okachi weyixtos. ");
INSERT INTO nplNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ijkuakó Juan okili: —Tlamachti, otiktakeh se tlakatl akin okinkixtiaya espíritus amokualteh itech Motoka. Pero tejwah otiknawatijkeh ayakmó ijkó makichiwa, porke amo nemi towah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús okinmili: —Amo xiktlakawaltikah, porke akin amo techixnamiki, kajki towah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yowalajsia n tonati ijkuak Jesús tlejkoskia ilwikak. Omoyolchika iwa okónanki ojtli para Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús okintlayakanalti ome itlamachtijkawah kan se altepetl de Samaria makitemolitih kan mokalotis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero n tlakah de Samaria amo okinekeh okiselijkeh, porke okimatkeh Jesús oyaya Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ijkuak itlamachtijkawah Jacobo iwa n Juan, okitakeh amo okinekiah kinseliskeh, okilijkeh n Jesús: —Tejwatsi, ¿tikneki matitlanawatikah mawetsi tletl de ilwikak para makimpojpolo, ijkó kemi okichi n profeta Elías? ");
INSERT INTO nplNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús okonimitak, okinmajwak iwa okinmili: —Nomejwah mach nonkimatih tlan espíritu nomotech kajki. ");
INSERT INTO nplNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porke Ne Non onimochi ni tlakatl amo oniwala para nikimpojpolos n tlaltikpaktlakah, yej oniwala para nikinmakixtis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ijkuak oyayah itech ojtli, se tlakatl okili n Jesús: —Noteko, nikneki nias mowa san kanik timuikas. ");
INSERT INTO nplNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús okili: —N ostomeh kipiah kan motlaatiskeh, iwa n totomeh kipiah intepajsol. Pero Ne Non onimochi ni tlakatl mach nikpia kan nimosewis. ");
INSERT INTO nplNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús okili ok se tlakatl: —Xiwiki nowa. N tlakatl okili: —Noteko, achto techonkawili maniktookati nota. ");
INSERT INTO nplNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús okinankili: —Xikinkawa akimeh ok miktokeh makintookatih akimeh yomikkeh, pero te, xitetlapowi kenomi Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ijkuakó ok se tlakatl okili n Jesús: —Noteko, ne nikneki nias mowah, pero achto techonkawili manimomakawati íwan nochanejkawah. ");
INSERT INTO nplNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Jesús okili: —Akin kitlalia ima itech arado iwa ontlachia ik ikuitlapa, ye mach weletis kalakis kan tlanawatia Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Satepa Jesús okimpéjpenki eyi póali iwa n májtlaktli iwa ome (72) itlamachtijkawah, iwa ojomeh okintítlanki sa matlayakanakah itech nochteh n altepemeh kanik Ye panoskia. ");
INSERT INTO nplNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iwa okinmili: —Onkateh miakeh akimeh moneki makalakikah kan Totajtsi tlanawatia, pero amo miakeh akimeh kitematiltiskeh nin kualitlájtoli. Yika, xiktlajtlanilikah Totajtsi Dios makintitlani oksikimeh tekitkeh para makitematiltiki nin kualitlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xiwiah nomejwah, Ne nomechtitlani kemi nonmichkatsitsinteh intlajko kokoyomeh. ");
INSERT INTO nplNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xikwikakah nomomantajkostal nion nomotomi, nion nomokakkuah; iwa amo ximoketsakah itech ojtli san para aka nonkitlajpaloskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ijkuak nonkalakitiweh itech se kali, achto xitetlajpalokah iwa xikijtokah: “Xiyolseutokah.” ");
INSERT INTO nplNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tla ompa chantitok se kuali tlakatl, nomoyolsewilis mokawas íwa. Pero tla amaka kiselia nomoyolsewilis, oksepa mokopas nomowah. ");
INSERT INTO nplNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ximokawakah itech se kali, iwa xikmomasewikah iwa xikonikah tlan nomechmakaskeh, porke akin tekiti kiselia itlaxtlawil, iwa amo san xipapanotinemikah. ");
INSERT INTO nplNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ijkuak nonkalakitiweh itech se altepetl iwa nomechseliah, xikmomajsewikah san tlan nomechmakaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xikimpajtikah n kokoxkeh non ompa nonkinmajsitiweh, iwa xikinmilikah: “Yoajsiko n tonati ijkuak Dios pewas tlanawatis.” ");
INSERT INTO nplNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero tla nonkalakitiweh itech se altepetl iwa amo nomechseliah, xiwiah itech ojtli iwa xikijtokah: ");
INSERT INTO nplNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nochi n póktlali de nomoaltepeu non omoka itech tokakuah, tiktsejtseloah nomoyakapah para xikmatikah mach kuali tlan nonkichijtokeh. Pero kuali xikmatikah ya walajsi n tonati para Dios pewas tlanawatis nomonawak.” ");
INSERT INTO nplNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne nomechilia, itech neká tonati ijkuak Dios tlayektlalis, n tlakah de non altepetl kiseliskeh okachi tlaijyowílistli ke non okiselijkeh n tlakah de Sodoma. ");
INSERT INTO nplNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","'¡Miálmasteh tlakah de n altepetl de Corazín! ¡Miálmasteh tlakah de Betsaida! Porke tla itech altepemeh de Tiro iwa Sidón mochiwaskiah n milagros non yomochijkeh nomoixpa, n tlakah de ompa yowejka kitlakitaskiah Dios. Iwa kinmokentiskiah intlakenwah tlilikeh iwa wajwapawakeh. Iwa yejwah kimotlaliliskiah tlekónextli ipan intsonteko. ");
INSERT INTO nplNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yika, itech neká tonati ijkuak Dios tlayektlalis, nomejwah nonkiseliskeh okachi weyi tlaijyowílistli ke non okiselijkeh n tlakah de Tiro iwa Sidón. ");
INSERT INTO nplNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwa nomejwah tlakah de Capernaúm, ¿nonkiyejyekoliah nomechajkokuiskeh ilwikak? ¡Amó!, yej nomechonkajkawaskeh miktla. ");
INSERT INTO nplNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Akin nomechkaki nomejwah, Ne nechkaki, iwa akin nomechtlawelita, Ne nechtlawelita, iwa akin Ne nechtlawelita noiwa kitlawelita Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","N eyi póali iwa n májtlaktli iwa n ome itlamachtijkawah omokopatoh ika miak pakílistli iwa okijtoayah: —Tejwatsi, asta n espíritus amokualteh techtlakitah ijkuak tiktenewah Motoka. ");
INSERT INTO nplNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús okinmili: —Milák, Ne onikitak kenijki n diablo owetsiko de ilwikak kemi ijkuak tlapejpetlani. ");
INSERT INTO nplNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","¡Techkakikah! Ne yonomechmák weletílistli para nonkintlajtlaksaskeh koameh iwa kolomeh, iwa nonmakisaskeh imak iweletilis n diablo, iwa mach ok itla nomechtoktis. ");
INSERT INTO nplNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero amo xipakikah porke nomechtlakitah n espíritus amokualteh, yej xipakikah porke nomotokah ya ijkuilitok ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Itech non ora, n Espíritu Santo okiyolpakti n Jesús, iwa okijto: —Notajtsi nimitsweyijkachiwa, Toteko de ilwikak iwan tlaltíkpak, porke otikinmajsikamatilti akimeh amitla kimatih iwa amo akimeh kimoliah ixtlamatih. Nimotlasojkamati Notajtsi, porke Tejwatsi ijkó otikmonekilti. ");
INSERT INTO nplNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Notajtsi yonechmaktili nochi tlan onka. Amaka kimati Akin Tekone, sanwel Notajtsi. Iwa amaka kimati Akin Notajtsi, sanwel n Tekone kimati iwa akimeh Ye kinekis kinmixmatiltis. ");
INSERT INTO nplNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ijkuakó Jesús okintlajtlatak itlamachtijkawah iwa okinmili: —¡Xipakikah nomejwah porke weletih nonkitah ika nomoixtololowah tlan axa panotok! ");
INSERT INTO nplNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ne nomechilia miakeh profetas iwa wejweyi tlanawatijkeh okinekiah kitaskeh tlan nomejwah axa nonkitah, iwa mach okitakeh; okinekiah kikakiskeh tlan nomejwah axa nonkikakih, iwa mach okikakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ijkuakó se non kitemachtia n tlanawatílistli okinek kiyejyekos n Jesús iwa okitlajtlani: —Tlamachti, ¿tlan moneki manikchiwa iwa ijkó niyolitos nochipa kan ilwikak? ");
INSERT INTO nplNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús okinankili: —¿Tlan ijkuilitok itech n tlanawatílistli? ¿Kenijki tikkajsikamati? ");
INSERT INTO nplNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","N tlamachti okinankili: —“Xiktlasojtla Motajtsi Dios ika nochi moyolo, ika nochi moalma, ika nochi mochikawalis iwa ika nochi motlalnamikilis, iwa xiktlasojtla se tokni kemi te timotlasojtla.” ");
INSERT INTO nplNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ijkuakó Jesús okili: —Kuali otitlanankili. Tla ijkó tikchiwas, tiyolitos nochipa kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero n tlamachti okinekia mokawas kuali teixpa, iwa oksepa okitlajtlani n Jesús: —¿Akin nokni? ");
INSERT INTO nplNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ijkuakó Jesús okinankili: —Se tlakatl owaltemoaya de Jerusalén para Jericó, iwa itech ojtli okitlachtekijkeh, iwa asta itlake okikixtilijkeh. Okitekilmakakeh iwa okiwijwilantewakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","'Satepa, se tiópixki opajpanotiaya itech non ojtli, iwa ijkuak okitak n tlakatl non ompa owilantoka, san okipanawi. ");
INSERT INTO nplNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noiwa ik ompa opajpanotiaya se levita, iwa ijkuak okitak non owilantoka noiwa san okipanawi. ");
INSERT INTO nplNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero se tlakatl de altepetl de Samaria akin noiwa opajpanotiaya itech non ojtli, ijkuak okitak n tlakatl non owilantoka okiknoma. ");
INSERT INTO nplNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ijkuakó omijkuani inawak n kókoxki, iwa opé kipajtia ika chiawak iwa ika oktli kan okikojkojkah, iwa okikekemelo ika tsótsoli. Otlanki okitlejkolti itech iburro, okiwík kan tekalotiah iwa ompa okimokuitlawi. ");
INSERT INTO nplNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ipan ok se tonati, ijkuak n samaritano yoonewaya, okinkixti ome denariojtomimeh iwa okinmaktili n tekowa itech kali kan mokalotiah, iwa okili: “Xikmokuitlawi nin tlakatl, iwa tla monekis itla okachi, nimitstlaxtlawilijtejkos ijkuak nimokopati.” ");
INSERT INTO nplNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Axa, techili ¿katlie de ninteh eyi tlakah omochi ikni n tlakatl non okitlachtekijkeh? ");
INSERT INTO nplNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","N tlamachti okili: —Akin oteiknoma. Jesús okili: —Te noiwa ijkó xikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús iwa itlamachtijkawah onejnenkeh okachi tlayakapa, iwa okalakitoh kan se altepetsintli. Ompa, se siwatl non itoka Marta okiseli n Jesús itech icha. ");
INSERT INTO nplNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta okipiaya se iwelti non itoka María akin omotlaliko ikxitla n Jesús para kikakis itlajtol. ");
INSERT INTO nplNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta okachi okitekipachoaya iteki, omijkuani inawak Jesús iwa okili: —Noteko, ¿amo techita nimotekimiktijtok iwa nowelti amo nechpalewia? Xikili manechpalewi. ");
INSERT INTO nplNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesús okinankili: —Marta, Marta, mitstekipachoa moteki iwa timotekimiktia, ");
INSERT INTO nplNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero sanwel onka itla tlan okachi ipati. María yokipéjpenki, iwa amaka weletis kikixtilis. ");
INSERT INTO nplNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se tonati Jesús omotiotsajtsilijtoka, iwa ijkuak otlanki omotiotsajtsili, se itlamachtijkau okili: —Tejwatsi, techmachti kenijki timotiotsajtsiliskeh, ijkó kemi Juan Bautista okinmachti itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús okinmili: —Ijkuak non motiotsajtsiliskeh, ijkí xikijtokah: Totajtsi Dios non timuistika ilwikak, nochipa makiyektenewakah motoka. Xiwalmuika xitlanawatiki. Mamochiwa tlan Tejwatsi tikmonekiltia itech nin tlaltíkpaktli, ijkó kemi mochiwa kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Techmaka nochi tonati tlan tikmomajsewiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Techintlapojpolwili totlajtlakolwah, ijkó kemi tejwah noiwa tikintlapojpolwiah akimeh techtoktiah tlan amokuali. Iwa amo xiktekawili matechyoltilana tlan amokuali. ");
INSERT INTO nplNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús noiwa okinmili: —Matikijtokah, se de nomejwah yawi ik tlajko yúak ichan se non íwa mowika iwa kilia: “Noknitsi, techintlaneti eyi pameh, ");
INSERT INTO nplNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porke se non iwa nimowika onechtlajpaloko, ye wejka wits iwa amo nikpia tlan nikmakas makimomajsewi.” ");
INSERT INTO nplNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iwa neká tlakatl waltlanankilis ijtik icha: “Amo techkuejsolo, yoniktepacho nokalte iwa ne iwa n nopilwantsitsiwah yotimotejtekakeh. Ayakmó weletis itla nimitsmakati.” ");
INSERT INTO nplNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ne nomechilia, n chane maya amo kinekiskia mewas, mewas kimakati tlan kitlajtlanilijtok. Pero amo por iwa mowika, yej para ayakmó makikochkuejsolo. ");
INSERT INTO nplNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yika, Ne nomechilia: Xiktlajtlanilikah Dios, iwa Ye nomechmakas; xiktemokah, iwa nonkajsiskeh; xitlakakalatsakah, iwa nomechtlatlapoliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porke akin kitlajtlani, kiselia; iwa akin tlatemoa, tlaajsi; iwa akin tlakakalatsa, kitlatlapoliah. ");
INSERT INTO nplNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","'¿Kox onka aka de nomejwah non mamixewi makimaka ichokotsi se koatl, ijkuak ichokotsi kitlajtlanilia se michi? ");
INSERT INTO nplNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Noso ijkuak kitlajtlanilia se téksistli, makimaka se kolotl? ");
INSERT INTO nplNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nomejwah mach nonkualteh, iwa nonkinmakah tlan kuali nomopilwah, ¿amo nonkiyejyekoliah Nomotajtsi non kajki ilwikak nomechmakas n Espíritu Santo tla nonkitlajtlaniliskeh? ");
INSERT INTO nplNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús okikixtilijtoka se espíritu amokuali se tlakatl, non amo okikawiliaya matlajto, ijkuak n espíritu amokuali okiski, n tlakatl owaltlajto. Nochteh n tlakah omotlajtlachialtijkeh ijkuak ijkí okitakeh, ");
INSERT INTO nplNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","pero sikimeh okijtojkeh: —Nin tlakatl kinkixtia n espíritus amokualteh ika iweletilis n tlayákanki demonio non itoka beelzebú. ");
INSERT INTO nplNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oksikimeh okinekiah kiyejyekoskeh iwa okitlajtlaniliayah makinnextili se neskayotl de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús okimatia tlan omokuatlapowijtokah, yika okinmili: —Nochteh n tekiwajkeh tla moxexeloah, san nima pojpoliwi; iwa ijkuak moxexeloa itech se kali, san nima moixpoloa. ");
INSERT INTO nplNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ijkó noiwa, tla satanás inewia moixnamiki, iwa iespíritus amokualteh, ¿kenijki wejkawas iweletilis? Ne ijkí nomechilia ken nomejwah nonkijtoah Ne nikinkixtia n espíritus amokualteh ika iweletilis n satanás; ");
INSERT INTO nplNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","pero tla milák yaskia kemi nonkijtoah, ¿akin kinmaka weletílistli nomotlatitlanilwah para makinkixtikah n espíritus amokualteh? Yika, innewiah kixnextiah nomejwah nonkuatlapolojtokeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero tla Ne nikinkixtia n espíritus amokualteh ika iweletilis Dios, noni kijtosneki Ye yotlanawatiko nomonawak. ");
INSERT INTO nplNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","'Ijkuak se tlakatl chikaktik kipixtok iespada iwa kimokuitlawijtok icha, nochi tlan kitlaatijtok amaka weletis kikixtilis. ");
INSERT INTO nplNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tla walkalaki ok se tlakatl okachi chikaktik ke ye iwa kitlanis, ijkuakó kikixtilis iespada non ika omopalewiaya iwa kikixtilis nochi tlan iaxka. ");
INSERT INTO nplNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","'Akin amo kajki nowa, nechixnamiki, iwa akin amo nowa tlaoololoa, tlaxixinia. ");
INSERT INTO nplNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","'Ijkuak se espíritu amokuali kikajkawa se tlakatl, nemi kan amaka chanti kitemojtinemi kan mosewis. Pero ijkuak amo kajsi, kimolia: “Nimokopas nocha, kan oníkiski.” ");
INSERT INTO nplNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iwa ijkuak non amokuali espíritu walmokopa, kualajsi n tlakatl kemi yaskia se kali non sikin okichpankeh iwa otlaajachijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ijkuakó n espíritu amokuali yawi kinnotsatih chikome espíritus okachi amokualteh ke ye, iwa nochteh mochantiah ijtik non tlakatl, iwa non tlakatl mokopa okachi amokuali ke achto. ");
INSERT INTO nplNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ijkuak Jesús otlajtojtoka, se siwatl non ik ompa okatka, okijto chikawak: —¡Miak yolpakílistli kipia n siwatl non omítspixki iwa omitschichiti! ");
INSERT INTO nplNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Jesús okijto: —¡Okachi kuali yolpakilisojkeh akimeh kikakih itlajtol Dios iwa kitlakitah! ");
INSERT INTO nplNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","N tlakah opé kiyawaloah n Jesús, iwa Ye opé kinmilia: —N tlakah amokualteh de ninteh tonatijmeh nechtlajtlaniliah se milagro. Pero mach ok nikinmakas ok se, sanwel non yokinnextili n profeta Jonás. ");
INSERT INTO nplNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Porke ijkó kemi Jonás omochi kemi se neskayotl intech n tlakah de Nínive, ijkó noiwa Ne Akin onimochiwako ni tlakatl nimochiwas kemi se neskayotl para n tlakah de ninteh tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Itech neká iksemi tonati ijkuak Ne nikintlajtlakoltis nochteh n tlakah, n reina de Sabá non walewatok ik tlatsintla majkokuis impah n tlakah de ninteh tonatijmeh iwa kintlajtlakoltis, porke ye wejka owalewak, okikakiko n Salomón non satlawel ixtlamati. Iwa non axa nika kajki, se Akin okachi weyijkatitok ke Salomón. ");
INSERT INTO nplNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Noiwa n tlakah de Nínive majkokuiskeh iwa nomechtlajtlakoltiskeh. Porke n tlakah de Nínive omoyolkopkeh inawak Dios ijkuak Jonás okinmatilti itlajtol, pero axa nika kajki se Akin okachi weyijkatitok ke Jonás. ");
INSERT INTO nplNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","'Amaka kimilintia se tláwili iwa tlami kitlaatia itlampa se kajo, yej kitlalia tlakpak para makintlawili akimeh walkalakih itech kali. ");
INSERT INTO nplNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nomoixtololowah kemi yaskiah tláwilteh itech nomokuerpo. Tla nomoixtololowah kualteh, noiwa nochi nomokuerpo kipia tláwili, pero tla amo kualteh moixtololowah, nomokuerpo kajki itech tleyuálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ximotlachili, amo kichiwa n tláwili non axa tikpixtok walmokopas tleyuálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yika, tla nochi mokuerpo kipia tláwili, iwa amo kipia tleyuálistli, nochi weletis tikyekitas kemi ijkuak se tláwili mitstlawilia. ");
INSERT INTO nplNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ijkuak Jesús otlanki otlajto, se fariseo okitlalwi matlakuati icha. Jesús oyajki icha n fariseo iwa omotlali kan mesa. ");
INSERT INTO nplNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","N fariseo omotlajtlachialti ijkuak okitak Jesús mach omomajteki kemi yejwah omomajtekiayah ijkuak otlakuayah. ");
INSERT INTO nplNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero Toteko Jesús okili: —Nomejwah fariseos, nonkichipawah san ixko n kaxitl iwan tlamana, pero ijtik nomoyolo nonkiwilitah nontlachtekiskeh iwa nonkichiwah tlan amo kuali. ");
INSERT INTO nplNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tsontewewemeh! Dios okichijchi tlan onka ik kala iwa tlan onka ik tlaijtik. ");
INSERT INTO nplNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tla nonkinekiskeh nonyetoskeh nonchipawakeh, xikintlatliokolikah n próbesteh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'¡Miálmasteh fariseos! Nomejwah nonkitemakah nomodiesmo de nomoyerbabuena, de nomoruda iwa de nochi tlan nonkitookah. Pero amo nonkichiwah tlan Dios kimonekiltia nion nontetlasojtlah ijkó kemi Ye tlanawatia. Nochi ni moneki xikchiwakah iwa amo xikkawakah tlan kuali ya nonkichijtiwitseh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","'¡Miálmasteh nomejwah fariseos!, porke nonkiwilitah nonmotlaliskeh ijtik n sinagoga kan motlaliah non satlawel kintlakitah, iwa nonkiwilitah manomechyektlajpalokah teixpa. ");
INSERT INTO nplNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'¡Miálmasteh akimeh non kitemachtiah n tlanawatílistli iwa fariseos, íxkopteh!, nomejwah kemi miketékochteh non amo motah, iwa n tlakah mach kimatih kox nomopah tlaksatokeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Seme de non kitemachtia n tlanawatili okili n Jesús: —Tlamachti, ika tlan tikijtoa, noiwa tejwah techpijpinatia. ");
INSERT INTO nplNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús okijto: —¡Miálmasteh noiwa nomejwah tlamachtijkeh de nomotlanawatil!, porke nonkinmamaltiliah n tlakah miakeh tlanawátilteh non mach kinxikoah, iwa nomejwah nion ika se nomomajpil nonkinekih nonkintelkoskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'¡Nonmiálmasteh!, porke nonkinyekchijchiwiliah inmiketekochwah n profetas, pero san innewiah nomotatawah okinmiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yika, ijkuak nonkinyekchijchiwiliah intekochwah nonkiteajsikamatiltiah nomejwah nonkiyekitah tlan okichijkeh nomotatawah, porke yejwah okinmiktijkeh n profetas. ");
INSERT INTO nplNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","'Yika, Dios kemi nochi kimati okijto: “Nikintitlanilis profetas iwa tlatematiltijkeh, iwa sikimeh de yejwah kinmiktiskeh iwa oksikimeh kintotojtokaskeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Porke n tlakah de ninteh tonatijmeh impah wetsis n tlajtlákoli de inmikilis nochteh n profetas non okinmiktijkeh desde ipewaya n tlaltíkpaktli, ");
INSERT INTO nplNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde imikilis n Abel asta imikilis n Zacarías, akin okimiktijkeh ijtik n Weyi Tiopa, iyakapa n artal. Yika nomechilia Dios kintlaxtlawaltis desde imikilis Abel asta Zacarías. ");
INSERT INTO nplNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'¡Miálmasteh de nomejwah tlamachtijkeh akimeh nonkixmatih nomotlanawatil! Porke amo nonkinkawiliah n tlakah makajsikamatikah tlan Dios technawatia, nion nomejwah mach nonkinekih nonkajsikamatiskeh. Nion amo nonkinkawiliah oksikimeh makajsikamatikah. ");
INSERT INTO nplNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ijkuak Jesús okinmili ninteh tlájtolteh, non kitemachtiah n tlanawatílistli iwa n fariseos opé kualanih iwa san tlan okajsiah opé kitlatlajtlaniah. ");
INSERT INTO nplNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yejwah san okiyejyekoayah porke okinekiah makijto itla tlan ika weletis kiteiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Se tonati opé moololoah miaktikeh tlakah asta omopajpatsoayah, iwa Jesús opé kinmilia itlamachtijkawah: —Ximotlachilikah de n fariseos íxkopteh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porke nochi tlan nonkiichtakachiwaskeh momatis, iwa tla non kimoliah amaka kimatis, saman momatis. ");
INSERT INTO nplNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yika, nochi tlan ononkijtojkeh kan tleyua, momatis kan tlanestok, iwa nochi tlan ononkijtojkeh san ichtaka, saman momatis. ");
INSERT INTO nplNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","'Nokniwah non satlawel nomechtlasojtla, amo xikinmawilikah akimeh weletis nomechmiktiskeh. Pero satepa ayakmitla weletis nomechtoktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne nomechilis akin moneki tikiimakajsiskeh: xikiimakajsikah n Totajtsi Dios Akin satepa de kimiktia n kuerpo noiwa kipia weletílistli para kititlanis miktla. Ye xikiimakajsikah. ");
INSERT INTO nplNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","'Monamakah mákuili tototsitsinteh san ika ome tomi. Pero maya ijkó, n Totajtsi Dios amo kinmilkawa nion seme de yejwah. ");
INSERT INTO nplNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Iwa Dios kimatok kech tsónkali nonkipixtokeh itech nomotsontekoh. Yika amo ximawikah, porke nomejwah okachi miak nomopati ke n tototsitsinteh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","'Ne nomechilia, akin teixpa kijtoa nechixmati, Ne noiwa nikijtos inmixpah iangelwah Dios ye noaxka. ");
INSERT INTO nplNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero tla aka kijtos inmixpah n tlakah amo nechixmati, Ne noiwa nikijtos inmixpah iangelwah Dios amo nikixmati. ");
INSERT INTO nplNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'Iwa akin fiero tlajtos de Ne Non onimochi ni tlakatl, weletis kitlapojpolwiskeh. Pero akin fiero kitenewa n Espíritu Santo, mach kipias tlapojpolwílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","'Ijkuak nomechwikaskeh kan sinagogas, noso innawak tekiwajkeh noso innawak wejweyi tlanawatijkeh, amo manomechtekipacho tlan ika non mopalewiskeh noso kenomi non tlanankiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porke ijkuak monekis xitlajtokah, n Espíritu Santo nomechilis tlan nonkijtoskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Se tlakatl non ompa okatka okili n Jesús: —Tlamachti, xikili nokni makixexelo tlan otechkajtewili tota. ");
INSERT INTO nplNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús okili: —Tlakatl, ¿akin onechtlali kemi teyektlali noso tlaxejxelo nomonawak? ");
INSERT INTO nplNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Noiwa okinmili: —¡Kuali ximotlachilikah! Amo xikmokawilikah manomechyoltilana n tomi, porke n tlakatl amo kipia nemílistli san por kipia miak tomi. ");
INSERT INTO nplNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ijkuakó opé kinmilia nin tlapoálistli: —Okatka se tlakatl non satlawel okipiaya tomi, iwa itlalwah saikpanoa otlatlakia. ");
INSERT INTO nplNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ijkuakó n tlakatl opé mokuatlapowia: “¿Tlan nikchiwas? ¡Amo nikpia kan niktlaatis tlan okitlakiltijkeh notlalwah!” ");
INSERT INTO nplNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iwa okimoli: “Ya nikmatok tlan nikchiwas. Nikinxixinis kan oniktlatiaya notliol iwa tlan noaxka, iwa nikinchijchiwas oksikimeh okachi wejweyi. Ompa niktlaatis nochi tlan okitlakiltijkeh notlalwah iwa nochi tlan nikpia. ");
INSERT INTO nplNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iwa nikilis noyolo: Noyolojtsi, ya tikpia miak tlan ika tipanotos miak xiwitl. Axa, sa ximosewi, xitlakua, xikoni, iwa xipaki.” ");
INSERT INTO nplNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios okili: “¡Tlakatl, tsontewewe! Nin yúali timikkis, iwa nochi tlan tiktlaatijtok ¿akin kimokawis?” ");
INSERT INTO nplNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ijkó mochiwah n tlakah non koololoah miak tomi itech nin tlaltíkpaktli. Pero amitla kipiah ixpa n Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Satepa Jesús okinmili itlamachtijkawah: —Yika, Ne nomechilia: Amo manomechtekipacho tlan nonkimomajsewiskeh noso tlan ika nonyolitoskeh, nion tlan nonkimokentiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nomonemilis inawak Totajtsi Dios okachi ipati ke n tlákuali, iwa nomokuerpo okachi ipati ke n tlakemitl. ");
INSERT INTO nplNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","San xikinmitakah n kakalomeh, amo tookah nion pixkah, nion amo kipiah kan kitlaatiskeh intlakual; iwa maya ijkó, Dios kintlakualtia. ¿Amo okachi nomopati nomejwah ke n totomeh? ");
INSERT INTO nplNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Tla aka de nomejwah satlawel motekipachoa, yolitos ok se tonati? ");
INSERT INTO nplNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tla nomejwah amo nonweletih nonkichiwah tlan amo owi, ¿tleka nomechtekipachoa oksiki tlan mach weletis nonkichiwaskeh? ");
INSERT INTO nplNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Xikimitakah kenijki moskaltiah n liriojteh. Amo tekitih nion tlajtsomah, pero Ne nomechilia nion n rey Salomón ika nochi iweyilis, omotlakenti kemi seme de ninteh xochimeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iwa tla Dios kitlakentia n xiwitl, non axa moskaltia tetlala iwa ok se tonati kichichinoah, amo okachi nomechyektlakentis maya amo nonteneltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yika, amo manomechtekipachojtinemi tlan nonkimomajsewiskeh noso tlan nonkoniskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porke n tlaltikpaktlakah kitemojtinemih nochi ni, pero nomejwah nonkipiah Nomotajtsi iwa Ye ya kimatok nochi tlan nomechpoloa. ");
INSERT INTO nplNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Okachi kuali xiktemokah matlanawati Dios itech nomoyolo, iwa Ye nomechmakas tlan nomechpoloa. ");
INSERT INTO nplNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","'Maya amo nonmiakeh amo ximawikah noichkawah, porke Nomotajtsi kimonekiltia nomechkawilis xikalakikah kan Ye tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xiknemakakah tlan nonkipiah, iwa xikimpalewikah akimeh kimpoloa. Xikinchijchiwakah púxajteh non amayik tsomonih, xiktlaweloololokah kan ilwikak kan amitla kimati soliwi nion kimati tlami, kan amo onka ichtek nion n tlalxinachi tlaixpoloa. ");
INSERT INTO nplNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porke kan yetos tlan nomoaxka, ompa yetos nomoyolo. ");
INSERT INTO nplNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","'Ximotlatlalikah sa maxotlatokah nomotlawilwah. ");
INSERT INTO nplNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xiyetokah kemi itekitwah se tlakatl non oyá kan monamiktilo iwa sa mochixtokeh para kitlatlapoliskeh iteko ijkuak waltlakakalatsas. ");
INSERT INTO nplNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Miak pakílistli kipiaskeh n tekitkeh ijkuak kualinmajsiki inteko kichijtokeh tlan okinnawatijtewak. Ne nomechilia inewia n tekowa pewas kintlateekilis mamotlamajsewikah. ");
INSERT INTO nplNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maya mawalkalakiki n tekowa tlajko yuak, noso sa kualka, miak yolpakílistli kipiaskeh nonteh tekitkeh tla inteko kualinmajsiki ijsatokeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Noiwa kuali xikmatikah, tla se chane kimatoskia kemania kalakiki n tlachtek, ye ijsatoskia interojyúali iwa amo kitekawiliskia makitlachtekikah. ");
INSERT INTO nplNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nomejwah noiwa xiijsatokah, porke mach nonkimatih kemania niwalkalakiki Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ijkuakó Pedro okili: —Noteko, ¿nin tlapoálistli otechkakiti san tejwah, noso tinochteh? ");
INSERT INTO nplNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","N Toteko okinankili: —¿Kanin ka n tetlakéwale yekmilajka iwa tetlakitak, non iteko kinmaktilia itlakawah para makintlamaka ipan ora? ");
INSERT INTO nplNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Satlawel yolpakiliso n tetlakéwale akin iteko kajsiki kichijtok tlan okinawatijtewak. ");
INSERT INTO nplNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","De milajka nomechilia, n tekowa kimaktilis makimokuitlawili nochi tlan iaxka. ");
INSERT INTO nplNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero tla non tetlakéwale kiyejyekolia iteko ok wejkawas kalakiki, iwa pewa kinwiteki n tekitkeh iwa pewa motlakualtia iwa motlawantia. ");
INSERT INTO nplNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ijkuakó n tekowa walkalakiki ijkuak itékitki amo kichia, iwa chikawak kitlaijyowiltis kemi kintlaijyowiltiah non amo tetlakitakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","'N tetlakéwale non ya kimatok tlan kipaktia iteko pero amo motlatlalia nion kitlakita, saikpanoa kitsonwitekiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero n tetlakéwale non amo kimati tlan kipaktia iteko, iwa kichiwa tlan amokuali, amo miak kitlaijyowiltiskeh. Porke akin miak okimaktilijkeh, miak kitlajtlaniliskeh. Iwa akin miak okiseli, okachi miak kitlajtlaniliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","'Ne oniwala onikxotlaltiko tletl ipan nin tlaltíkpaktli. ¡Saikpanoa niknekiskia ya maxotlato! ");
INSERT INTO nplNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero achto moneki manimokuaateki ika tlaijyowílistli iwa ¡satlawel nimotekipachojtinemi asta mamochiwa! ");
INSERT INTO nplNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amo xikyejyekolikah Ne onikualík yolsewílistli itech nin tlaltíkpaktli. Amó, yej Ne nomechilia n tlaltikpaktlakah mokualaniskeh iwa moxexeloskeh porke Ne oniwala. ");
INSERT INTO nplNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Axa ik tlayakapa itech se familia kan chantitoskeh mákuilteh, non eyi amo kinekiskeh mowikaskeh iwa non ome, iwa nonteh ome amo kinekiskeh mowikaskeh iwa nonteh eyi. ");
INSERT INTO nplNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","N teta kixnamikis ipiltsi, iwa n tepiltsi kixnamikis ita. N tena kixnamikis ichpoch, iwa n teichpoch kixnamikis ina. N temona kixnamikis imo, iwa n montli kixnamikis imona. ");
INSERT INTO nplNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús noiwa okinmili n tlakah: —Ijkuak nomejwah nonkitah pewa tlamixtemi kan ik kalaki tonati, niman nonkijtoah kiawis, iwa milák ijkó tlamochiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iwa ijkuak n ejekatl walewa ik tlatsintla, nomejwah nonkijtoah: “Axa kualtsi tonas”, iwa ijkó tlamochiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Íxkopteh! Kenomi nonweletih nonkiyejyekoliah kemania kiawis noso kemania tonas. ¿Tleka amo nonweletih nonkajsikamatih tlan tlamochijtok itech ninteh tonatijmeh? ");
INSERT INTO nplNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","'¿Tleka nomonewiah amo nonkiyejyekoliah tlan kuali? ");
INSERT INTO nplNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tla aka mitsteilia por otiktokti itla amo kuali, ximoyekkawa íwa, ijkuak ayamó mitsteixpantia inawak tekiwa, tlamo n tekiwa mitstemaktis inawak n alwasil para mamitstsakua. ");
INSERT INTO nplNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","De milajka nimitsilia, amo tikisas asta kelamo tiktlaxtlawas nochi tlan mitstlajtlaniliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Itech nekateh tonatijmeh, sikimeh tlakah okitakoh n Jesús iwa okilijkeh Pilato okinmikti sikimeh tlakah de Galilea, iwa inmesso okinenelo ika inmesso n yolkameh non yejwah okinmiktijkeh para tlamanaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús okinmili: —¿Nonkiyejyekoliah nomejwah nonteh tlakah de Galilea ijkó omochijkeh porke okachi tlajtlakolejkeh ke n oksikimeh tlakah de Galilea? ");
INSERT INTO nplNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ne nomechilia amó; iwa tla nomejwah amo nonmoyolpatlah, noijkó nontlamitiweh. ");
INSERT INTO nplNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Noso nonkiyejyekoliah nekateh májtlaktli iwa n chikweyi tlakah non omijmikeh ijkuak impah owetsiko n wejkapa torre de Siloé, okachi tlajtlakolejkeh ke n oksikimeh non ochantitokah Jerusalén? ");
INSERT INTO nplNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ne nomechilia amó, iwa tla nomejwah amo nonmoyolpatlah inawak Dios, non nochteh ijkó nontlamitiweh. ");
INSERT INTO nplNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ijkuakó Jesús okinmili nin tlapoálistli: —Se tlakatl okipiaya se igoskuawitl non otooktoka itlajko iuvaskuauyo, iwa oyá okitlatemolito, pero amitla okajsik. ");
INSERT INTO nplNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ijkuakó okili iuvastékitki: “Techkaki, ika axa ya eyi xiwitl nikwaltlatemolia nin igoskuawitl iwa ayik nikajsi nion se igos. Xiktsonteki, ayakmó san matlatsakuilijto.” ");
INSERT INTO nplNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero n uvastékitki okili: “Noteko, xikkawa sa nin xiwitl; niktlalkaxanis iwa nikkojtlalotis. ");
INSERT INTO nplNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chamo ijkó ya tlaakis. Pero tla amo tlaaki, ijkuakó niktsontekis.” ");
INSERT INTO nplNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Se sábado ijkuak mosewia n judíos, Jesús otlamachtijtoka itech se sinagoga. ");
INSERT INTO nplNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Noiwa ompa okatka se siwatl non yokiwikaya májtlaktli iwa n chikweyi xiwitl ika kokólistli. Se espíritu amokuali okikuitlapantompocho iwa mach oweletia omomilawaya. ");
INSERT INTO nplNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ijkuak Jesús okitak okínotski iwa okili: —Siwatl, yotimákiski de mokokolis. ");
INSERT INTO nplNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ijkuakó Jesús okintlali imawah ipan siwatl, iwa n siwatl san nima owalmomila iwa opé kiweyijkachiwa Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero n tiópixki non okachi otlayakantoka okuálanki, porke Jesús okipajti non siwatl itech sábado, iwa okinmili non ompa okatkah: —Onkateh chikwase tonatijmeh ijkuak weletis se tekitis; itech seme de nonteh tonatijmeh ximopajtikih, pero amo itech tonati ijkuak moneki matimosewikah. ");
INSERT INTO nplNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ijkuakó Jesús okinankili: —¡Íxkopteh!, ¿mach amo nonkintojtomah nomoyolkawah iwa nonkinmatlitiah malki mayeto sábado? ");
INSERT INTO nplNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nin siwatl non walewatok de Abraham, akin satanás okitlaijyowiltijtoka májtlaktli iwa n chikweyi xiwitl, ¿mach amo omonekia se makimakixti maya mayeto sábado? ");
INSERT INTO nplNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ijkuak Jesús ijkó okinmili, nochteh non okikokoliayah opinawakeh. Pero n oksikimeh opakiah ijkuak okitayah n wejweyi neskayolteh non Jesús okinchiwaya. ");
INSERT INTO nplNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ijkuakó Jesús okijto: —¿Tlan ika weletis nikiknitis kan Dios tlanawatia? ");
INSERT INTO nplNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nikchiwas ika se xinatsintli de mostaza non se tlakatl okitookak kan ilawerta, satlawel omoskalti iwa omotlamito se weyi kuawitl iwa n totomeh omotepajsoltijkeh itech imamayowah. ");
INSERT INTO nplNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús noiwa okijto: —¿Tlan ika weletis nikiknitis kan Dios tlanawatia? ");
INSERT INTO nplNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nochi ni kemi n levadura non se siwatl kineloa ika eyi tlatamachiwali arina. Iwa n levadura kisamawaltia nochi n textli. ");
INSERT INTO nplNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ijkuak Jesús oyaya itech ojtli non onkisa Jerusalén, otlamachtijtiah itech nochteh altepemeh kan ik opapanotia. ");
INSERT INTO nplNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iwa se tlakatl okitlajtlani: —Toteko, ¿amo miakeh momakixtiskeh? Jesús okinankili: ");
INSERT INTO nplNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ximochijchikawakah xikalakikah kan ik kaltentli tsopijtik, Ne nomechilia, miakeh kinekiskeh kalakiskeh pero amo weletiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Porke ijkuak n chane mewas iwa kiwaltsakuas n kaltentli, akimeh nonyetoskeh kala, nontlakakalatsaskeh iwa nonkijtoskeh: “Toteko, techtlatlapoli.” Pero Ye nomechnankilis: “Mach nikmati kan nonwalewah.” ");
INSERT INTO nplNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ijkuakó nomejwah pewas nonkijtoskeh: “Tejwah otitlakuajkeh iwa otikonikeh mowah, iwa otitemachti itech toaltepeu.” ");
INSERT INTO nplNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero Ye nomechilis: “Mach amo yonomechili amo nikmati kan nonwalewah. Ximoachiwakah tlajtlakolchiwanih.” ");
INSERT INTO nplNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ompa nonchokaskeh iwa nomotlanwah nejnetsontoskeh ijkuak nonkitaskeh Abraham, Isaac, Jacob iwa nochteh n profetas kan Dios tlanawatijtok. Pero nomejwah nomechontlamotlaskeh kala. ");
INSERT INTO nplNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porke witseh n tlakah de ik tlatsintla iwa de ik tlakpak, kan ik kisa tonati iwa kan ik kalaki tonati, moyayantiskeh iwa motlamajsewiskeh kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Non tonati, sikimeh non axa amitla impati, ijkuakó weyijkatitoskeh, iwa non axa weyijkatitokeh ijkuakó ayakmitla yetos impati. ");
INSERT INTO nplNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Itech non tonati owalajkeh sikimeh fariseos iwa okilijkeh n Jesús: —Xio de nika, porke Herodes Antipas kineki mitsmiktis. ");
INSERT INTO nplNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero Jesús okinnankili: —Xiwiah iwa xikilikah non koyotl: “Xikkaki, axa iwa mostla nikinkixtis espíritus amokualteh iwa nikimpajtis kokoxkeh, iwa biktla niktlamis noteki.” ");
INSERT INTO nplNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero axa, mostla iwa biktla, moneki maniksentoka noteki, porke mach weletis se profeta mamiki oksika tla amo kan weyi altepetl de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","'¡Jerusalén, Jerusalén, mopilwah kinmiktiah n profetas iwa kinmojmotlah ika tetl akimeh Dios kintitlani monawak! ¡Miak welta oniknek nikinmoololos mopilwah, kemi se siwapio kimoololoa ipiotsitsiwah itlampa iajaswah, pero mach okinekeh! ");
INSERT INTO nplNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Axa nomoweyitiopa mokawas sa iselti, iwa Ne nomechilia ayakmó nonnechitaskeh oksepa asta maajsiki n tonati ijkuak nonkijtoskeh: “Matiochito Akin okwaltítlanki Toteko Dios.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Itech se sábado ijkuak mosewia n judíos, Jesús oyá otlakuaato icha n se tlanawati fariseo. Iwa n oksikimeh fariseos sa okiitinemiah tlan kichiwas. ");
INSERT INTO nplNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iwa iyakapa n Jesús okatka se tlakatl kókoxki non oatétenki. ");
INSERT INTO nplNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ijkuakó Jesús okintlajtlani n fariseos iwa non kitemachtiah n tlanawatílistli: —¿Nomotlanawatil kitekawilia se matlapajti itech sábado, noso amó? ");
INSERT INTO nplNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yejwah mach otlanankilijkeh. Ijkuakó Jesús okonkitski n kókoxki, okipajti iwa okili mawia. ");
INSERT INTO nplNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Otlanki Jesús okinmili n fariseos: —Tla se nomoburrojtsi noso se nomotoro moposojwia, ¿amo nonkonkixtiah maya mayeto sábado? ");
INSERT INTO nplNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yejwah mach ok itla oweletkeh okinankilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ijkuak Jesús okimitak kenomi omotlapejpeniayah para motlaliskeh okachi tlayakapa n tlatlálwilteh itech se ilwitl, Ye okinmili ninteh tlajtolteh: ");
INSERT INTO nplNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ijkuak aka mitsontlalwis xitlatlakuaati kan se monamiktilo, amo ximotlapejpeni kan timoyayantis, porke weletis wits ok se tlatlálwili okachi weyijkatitok; ");
INSERT INTO nplNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ijkuakó akin omitstlalwi weletis mitsiliki: “Xonmijkuani, nika motlalis nin notlatlalwil.” Ijkuakó te tipinawas iwa tias timotlaliti asta tlakuitlapa. ");
INSERT INTO nplNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yika, ijkuak mitstlalwiskeh, ximotlaliti tlakuitlapa; ijkó mitsontlajpaloki akin omitstlalwi, iwa mitsilis: “Noknitsi, ximoyayantiti nepa tlayakapa.” Ijkuakó, nochteh akimeh mowah ewatoskeh, kuali tlajtoskeh de te. ");
INSERT INTO nplNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pero akin inewia moweyilia, kipijpinawiskeh; iwa akin moiknelia, kiweyijkatlaliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús noiwa okili n tlakatl non okitlalwi matlakuati icha: —Ijkuak tiilwichiwas, amo xikintlalwi akimeh inwah timowika, noso mokniwah, noso non ken tikimita, noso non kitlawelpiah tomi; porke satepa yejwah noiwa mitstlalwiskeh xitlatlakuaati, iwa ijkó momakopaskeh mowah. ");
INSERT INTO nplNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ijkuak tiilwichiwas xikintlalwi n próbesteh, n matepomeh, n koxomeh iwa non amo weleti tlachiah, ");
INSERT INTO nplNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","iwa tikpias miak pakílistli. Porke yejwah mach weletis momakopaskeh mowah, pero te tikpias motlaxtlawil neká iksemi tonati ijkuak moyolitiskeh n yekmilajkameh. ");
INSERT INTO nplNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ijkuak ijkó okikakeh, seme non ompa otlakuajtokah iwan Jesús, okili: —¡Miak pakílistli kipias akin tlakuas kan Dios tlanawatijtok! ");
INSERT INTO nplNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús okili: —Se tlakatl okichi miak tlákuali iwa otlanawati matetlalwitih matlakuakih icha. ");
INSERT INTO nplNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iwa ijkuak ya tlakuaskiah, okinawati se tetlakéwale makimiliti n tlatlálwilteh: “Xiwalmuikakah, porke nochi yotlaiksik.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero nochteh opé motlapojpolwiah inawak. Se okijto: “Sikin onikko se tlali, iwa nio nikontati; nimitstlatlaujtia techontlapojpolwi.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ok se okijto: “Sikin onikinko mákuili noyuntajwah, iwa nio nikinyejyekoti, nimitstlatlaujtia techontlapojpolwi.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iwa ok se okijto: “Sikin onimonamikti, iwa mach weletis nias.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ijkuak n tetlakéwale omokopato, okitlapowi iteko nochi tlan okilijkeh n tlatlálwilteh. Ijkuakó n tekowa tlawel okuálanki iwa okili itlakewal: “Xiajtiwetsi tiánkistli iwa itech ojmeh de nin altepetl, xikualinwika n próbesteh, n matepomeh, n koxomeh iwa non amo tlachiah.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","N tetlakéwale omokopato iwa okijto: “Noteko, yonikchi tlan otechnawati, iwa ok onka miak lojar.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ijkuakó n tekowa okili itlakewal: “Xiajtiwetsi itech ojmeh, iwa nochteh non tikinnamiktias xikinchijchikawa makalakikah nocha para matemi nocha. ");
INSERT INTO nplNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porke de milajka nomechilia, nion se de akin achto oniktlalwi matlakuaki, kimomasewis n tlákuali non ne nikmomajsewis.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miakeh tlakah okikuitlapantokayah n Jesús, iwa Ye omókopki iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tla aka wits nonawak, iwa amo nechtlasojtla okachi ke ita, ina, isiwa, ipilwah, ikniwah, iweltiwah noso ye inewia, noni mach weletis yetos notlamachtijkau. ");
INSERT INTO nplNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iwa akin amo kinekis tlaijyowis maya makimiktikah por nechtlakita, noni mach weletis yetos notlamachtijkau. ");
INSERT INTO nplNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tla aka de nomejwah kineki kichijchiwas se torre, ¿amo achto kiyejyekolia kox kajxilis itomi para weletis kitlamis? ");
INSERT INTO nplNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Porke tla kualtsimpewaltia iwa san ompa kikawa ken ayakmó okajxili itomi; nochteh akimeh kitaskeh san kiwetskaskeh, ");
INSERT INTO nplNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","iwa kijtoskeh: “Nin tlakatl san okitsimpewalti ikal iwa mach owéletki okitlami.” ");
INSERT INTO nplNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Noso ijkuak se rey kintitlani isoldadojwah mamotekilmakatih iwan isoldadojwah ok se rey, ¿amo achto kiyejyekolia kox ika májtlaktli mil soldadojteh weletis motekilmakas iwa non ok se rey non okwalintítlanki sempóali mil soldadojteh? ");
INSERT INTO nplNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iwa tla amo weleti, ijkuak n ok se rey ok wejka wits, konintitlanilia sikimeh tlatitlaniltih para mamoyekkawakah. ");
INSERT INTO nplNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ijkó kiné, akin amo kikawa nochi tlan kiyoltilana, mach weletis yetos notlamachtijkau. ");
INSERT INTO nplNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'N istatl satlawel kuali, pero tla ayakmó tlapuyeya, ayakmó kuali. ");
INSERT INTO nplNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ayakmó weletis motekitiltis nion itech tláli, nion para motlakojtlalotis, yej sa para motepewas. ¡Akin de milajka kipia inakas, makajsikamati! ");
INSERT INTO nplNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Miakeh tominoololojkeh, non okoololoaya tomi para Roma, iwa sikimeh tlajtlakolchijkeh owalmijkuaniayah inawak Jesús iwa okikakiah, ");
INSERT INTO nplNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","yika n fariseos iwa non kitemachtiah n tlanawatili okipojpoayah iwa okijtoayah: —Nin tlakatl mowika iwan tlajtlakolchijkeh iwa tlakua ínwah. ");
INSERT INTO nplNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ijkuakó Jesús okinmili nin tlapoálistli: ");
INSERT INTO nplNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Tla aka de nomejwah kimpixtok se siento ichkameh iwa kipoloa se, amo kinkakajtewah n nawi póali iwa n káxtoli iwa n nawi (99) ichkameh tetlala iwa kontemoa n ichkatsi non opoliwik? ");
INSERT INTO nplNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iwa ijkuak konajsi, kimokechpanoltia iwa satlawel pakmiki, ");
INSERT INTO nplNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","iwa ijkuak onkalaki icha, kinmoololoa non iwa moiknitia, iwa non ik ompa chanti iwa kinmilia: “Xipakikah nowa, porke yonikajsik n ichkatsi non onikpolojka.” ");
INSERT INTO nplNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne nomechilia onka okachi miak pakílistli kan ilwikak ijkuak se tlajtlakolchi moyolpatla, iwa amo por nawi póali iwa n káxtoli iwa n nawi kualteh n tlakah non ayakmó moneki makipatlakah inyalis. ");
INSERT INTO nplNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","'Noso tla se siwatl kipia májtlaktli platajtomi iwa kualpoloa se, ¿amo kixotlaltia se tláwili, iwa yolik kichpana n kali iwa kitejtemojti asta kan kualajsi? ");
INSERT INTO nplNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iwa ijkuak yokajsik, kinmoololoa non iwa moiknitia iwa non ik ompa chanti iwa kinmilia: “Nowa xipakikah, porke yonikajsik n platajtomi non onikpolojka.” ");
INSERT INTO nplNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ne nomechilia, noiwa iangelwah Dios pakmikih ijkuak se tlajtlakolchi molnamiki iwa ayakmó tlajtlakolchiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús noiwa okinmili: —Se tlakatl okimpiaya ome itelpochwah, ");
INSERT INTO nplNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","iwa non tsoyotl okili ita: “Nota, xikxejxelo tlan tikpia iwa techmaka tlan techaxkatilis.” Ijkuakó n teta okixejxelo tlan okipixtoka, iwa okimák ipiltsi non tsoyotl tlan okitlajtlanili. ");
INSERT INTO nplNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kech tonati satepa, n télpochtli non tsoyotl okinamák nochi tlan okiaxkatilijkah, iwa ika non tomi wejka omopaxialoltito. Ompa okawilti itomi iwan awilsiwameh. ");
INSERT INTO nplNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pero ijkuak omotomintlajtlami, owala se apisotl itech neká tlali kan ye opaxialoto iwa opé kipoloa tlan kikuas. ");
INSERT INTO nplNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ijkuakó okitlajtlanilito tekitl se tlakatl non ochantitoka itech non altepetl, akin okinawati makinmokuitlawiliti ipitsowah. ");
INSERT INTO nplNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","N télpochtli oapismikia iwa okinekia kinkualis intlakual n pitsomeh, pero amaka itla okimakaya. ");
INSERT INTO nplNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ijkuakó opé ijkí mokuatlapowia: “¡Miakeh itlakawah nota, kipiah miak tlan kikuaskeh, iwa ne nika niapismiktok! ");
INSERT INTO nplNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Okachi kuali nimokopas ichan nota, iwa nikilis: nota, onitlajtlakolchi inawak Dios iwa monawak. ");
INSERT INTO nplNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ayakmó techita kemi mokone; yej techita kemi se motlakewal.” ");
INSERT INTO nplNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ijkuak owalmókopki icha n ita. 'Iwa ok wejka owalaya, ita okonitak iwa saikpanoa okiknoma. Omotlelo okinamikito, okinanawajtek iwa okiixtennamik. ");
INSERT INTO nplNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ijkuakó ipiltsi okili: “Nota, onitlajtlakolchi inawak Dios iwa monawak. Ayakmó techita kemi mokone.” ");
INSERT INTO nplNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ijkuakó n teta okinmili itlakawah: “Totokatijkak, xikualikakah non okachi kuali tlakemitl iwa xiktlakentikah; noiwa xiktlalilikah se aniyo iwa xikkaktikah. ");
INSERT INTO nplNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xikualikakah n torojkonetl non tomawak iwa xikmiktikah. ¡Matiilwichiwakah iwa matitlatlakuakah! ");
INSERT INTO nplNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porke nin nopiltsi yomikka, iwa oksepa omoyoliti, yopolika, iwa axa yotikajsikeh.” Iwa opé ilwichiwah. ");
INSERT INTO nplNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","'Pero ipiltsi non teteachka otekititoka itlala; iwa ijkuak owalmokopaya iwa ya onajsia icha, okikak tlatsotsonah iwa mijtotiah. ");
INSERT INTO nplNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ijkuakó okínotski se tlakéwale iwa okitlajtlani tlan okichijtokah icha. ");
INSERT INTO nplNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","N tlakéwale okili: “Mokni yomokopato, iwa mopapá otlanawati makimiktikah n torojkonetl non okachi tomawak, porke mokni okalakiko ika kuali.” ");
INSERT INTO nplNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero n teikni non teteachka okuálanki, iwa kemi amo okinekia kalakis, ita owálkiski iwa okitlatlaujti makalaki. ");
INSERT INTO nplNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero n tepiltsi okili ita: “Tejwatsi kuali tikmatok nochipa nitekititok mowah iwa nimitstlakita, iwa ayik techmakatikah nion se tentsontsi, para maniilwichiwa iwa non inwa nimowika. ");
INSERT INTO nplNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero axa kemi owala mopiltsi, non okawiltito motomi iwan awilsiwameh, okachi otikmiktili n torojkonetl non sa tomaktik.” ");
INSERT INTO nplNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ijkuakó n teta okili ipiltsi: “Nokone, te nochipa tika nowa, iwa nochi tlan nikpia moaxka. ");
INSERT INTO nplNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero axa kuali matiilwichiwakah iwa matipakikah, porke mokni omikka, iwa axa omoyoliti; opolika, pero yotikajsikeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús noiwa okinmili itlamachtijkawah: —Okatka se tlakatl non satlawel okipiaya, iwa okitlali se ichantlamokuitlawi. Pero sikimeh tlakah okilitoh n tekowa ichantlamokuitlawi san okawiltijtoka tlan iaxka. ");
INSERT INTO nplNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ijkuakó n tekowa okónnotski iwa okili: “¿Amo tikmati tlan nechtlapowiah de te? Techili kenomi titekititok, porke ayakmó tikmokuitlawis tlan noaxka.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ijkuakó n techantlamokuitlawi okimoli: “¿Axa tlan nikchiwas tla noteko nechkixtilis noteki? Mach nikxikos nitekitis tetlala, iwa satlawel nipinawas nimijtlanijtinemis. ");
INSERT INTO nplNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya nikmatok tlan nikchiwas, para manechselikah itech incha ijkuak ayakmó nikpias nin tekitl.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ijkuakó n techantlamokuitlawi se por se okinnotiah akimeh okiwikiliayah iteko; iwa non achto owala okitlajtlani: “¿Kech tikuikilia noteko?” ");
INSERT INTO nplNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","N tlakatl okinankili: “Nikkuikilia mákuili poali barril aseite.” Ijkuakó n techantlamokuitlawi okili: “Nika machotitok tlan tiktewikilia, ximotlali iwa xikmajmantiwetsi sa tlajko siento barril.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","San nima ok se okitlajtlani: “Iwa te, ¿kech tiktewikilia?” N tlakatl okinankili: “Se siento tlatamachiwali de trigo.” Ijkuakó n techantlamokuitlawi okili: “Xikonana moamatsi iwa xikmajmana ok se, pero xikmomachotili san nawi póali (80) tlatamachiwali de trigo.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ijkuakó n tekowa omotlajtlachialti ijkuak okima tlan okichi n amokuali techantlamokuitlawi. N tlaltikpaktlakah okachi ixtlamatih itech tlan kichiwah, iwa amo akimeh tepilwah inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","'Ne nomechilia: Xiktekitiltikah tlan onka itech nin tlaltíkpaktli, para nonkimpalewiskeh n próbesteh iwa ijkó nonkimpiaskeh akimeh nomechmoiknitiskeh, para ijkuak amitla nonkipiaskeh, weletis nomechseliskeh ilwikak kan nochipa nonchantitoskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","'Akin san achitsi kiyekmokuitlawia, noiwa weletis kiyekmokuitlawis tlan miak; iwa akin amo kiyekmokuitlawia tlan san achitsi, mach weletis kiyekmokuitlawis tlan miak. ");
INSERT INTO nplNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yika tla amo nonkiyektekitiltiah tlan onka itech nin tlaltíkpaktli, ¿kenomi nomechmaktiliskeh xikmokuitlawikah tlan de milajka ipati? ");
INSERT INTO nplNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iwa tla amo nonkiyekmokuitlawiah tlan amo nomoaxka, ¿akin nomechmakas tlan nomoaxka? ");
INSERT INTO nplNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","'Nion se tlakéwale weletis kinyektekitilis ome tekowajkeh; porke se kikokolis iwa n ok se kitlasojtlas, noso sanwel se kitlakitas iwa n ok se kitlawelitas. Mach weletis nonkiyolpixtoskeh Dios tla nomechyoltilana n tomi. ");
INSERT INTO nplNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","N fariseos san okikaktokah tlan Jesús otetlapowiaya, iwa san okiwetskayah porke yejwah okiweliliayah n tomi. ");
INSERT INTO nplNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ijkuakó Jesús okinmili: —Nomejwah nonmomachiliah nonkualteh n tlakah imixpah n oksikimeh, pero Dios nomechyolixmati, porke nochi tlan kiweyiliah n tlakah, Dios kitlawelita. ");
INSERT INTO nplNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","'N tlanawatílistli iwa n profetas otlamiko ijkuak owala n Juan Bautista. Ijkuakó opé kitematiltia n kualitlájtoli iwa satlawel miakeh tlaltikpaktlakah mochijchikawah iwa kinekih kalakiskeh kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Okachi amo owi pojpoliwis n ilwikak iwa n tlaltíkpaktli, pero tlan ijkuilitok saman mochiwas. ");
INSERT INTO nplNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'Tla se tlakatl kikajkawa isiwa iwa monamiktia iwan ok se siwatl, non tlakatl san kimomekatijtok n siwatl iwa tlajtlakolchijtok. Iwa tla se tlakatl non san iselti, monamiktia iwan se siwatl non yokikajka iokich, noiwa san kimomekatijtok iwa tlajtlakolchijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","'Okatka se tlakatl akin satlawel okipiaya, iwa omotlakentiaya ika tlakemeh patiojkeh; nochipa oilwichiwaya iwa otetlatlakualtiaya. ");
INSERT INTO nplNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Noiwa se tlakatl non satlawel probe non itoka Lázaro, nin tlakatl oajsiltentoka inakayo iwa nochipa owalmotlaliaya ikaltempa n tlakatl non saikpanoa okitlawelpiaya. ");
INSERT INTO nplNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nin probe okinekia ixwis ika n tlákuali non owetsia de kan imesa non tlakatl; iwa n chichimeh okualpajpaliliayah inakayo kan oajsiltentoka. ");
INSERT INTO nplNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Se tonati n Lázaro omikki, iwa iangelwah n Dios okiwikakeh inawak Abraham. Noiwa n tlakatl non okipiaya tomi omikki, iwa okitookakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ijkuak n tlakatl non okipiaya tomi otlaijyowijtoka miktla, oajkotláchixki iwa okitak Abraham iwa n Lázaro inakastla. ");
INSERT INTO nplNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ijkuakó opé kitsajtsilia: “Nota Abraham, techiknomati, iwa xiknawati n Lázaro makisiawa se imajpil iwa makiseseyaliki nonenepil, porke saikpanoa nitlaijyowijtok itech nin tletl.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham okili: “Nokone, xikilnamiki te yotimopaakti ijkuak otinemia itech tlaltíkpaktli, iwa n Lázaro amo okipiaya nion tleno. Yika axa ye nika yolpaktok, iwa te axa titlaijyowijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Noiwa xikmati techxelojtok se weyi barranka, yika non nika kateh mach weletis yaskeh ompa, iwa non ompa kateh mach weletis witseh nika.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ijkuakó n tlakatl non okitlawelpiaya tomi okijto: “Nota Abraham, nimitstlatlaujtia xiktitlani n Lázaro mawia ichan nota, ");
INSERT INTO nplNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","porke nikimpia mákuilteh nokniwah iwa nikneki makintlapowiti, para ijkó yejwah amo mawikih itech nin lojar tetlaijyowilti.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham okili: “Yejwah kipixtokeh itlajkuilol Moisés iwa intlajkuilolwah n profetas; ¡makintlakitakah!” ");
INSERT INTO nplNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pero n tlakatl non okipiaya tomi okinankili: “Milák, tata Abraham, pero tla kintlapowiti se non yomikki, moyolpatlaskeh inawak Dios.” ");
INSERT INTO nplNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham oksepa okili: “Tla amo kinekih kitlakitaskeh itlajkuilol Moisés nion intlajkuilol n profetas, noiwa mach kineltokaskeh maya mamoyoliti se miketl.” ");
INSERT INTO nplNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Satepa Jesús okinmili itlamachtijkawah: —Nochipa yetos tlan kintlajtlakolchiwaltis n tlakah. Pero ¡probe n tlakatl non kichiwas aka matlajtlakolchiwa! ");
INSERT INTO nplNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Okachi kuali makikechilpililikah se weyi tetl, iwa makontlamotlakah ijtik n weyi atl, para amo makitlajtlakolchiwalti seme de ninteh pípilteh. ");
INSERT INTO nplNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Yika, ximotlachilikah! 'Tla mokni mitstoktia itla amokuali, xiknonotsa; tla mitskaki iwa molnamiki, xiktlapojpolwi. ");
INSERT INTO nplNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iwa tla mitstoktia itla amokuali chikome welta itech se tonati, iwa mitstlajtlanilia xiktlapojpolwi chikome welta itech se tonati, xiktlapojpolwi. ");
INSERT INTO nplNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ijkuakó itlamachtijkawah okilijkeh n Jesús: —Xikmiakili totlaneltokalis. ");
INSERT INTO nplNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","N Toteko okinmili: —Tla nonkipiaskiah tlaneltokálistli, maya san kemi se xinatsintli de mostaza, weletis nonkiliskiah nin tlatoókali: “Ximowiwitla de nika iwa ximomanati itech weyi atl”, iwa non tlatoókali nomechtlakitaskia. ");
INSERT INTO nplNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","'Tla aka de nomejwah kipia se itlakewal non okitekitilito itlala noso otlajpiato, mach nonkiliah: “Ximotlali iwa ximotlamajsewi.” ");
INSERT INTO nplNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Amó, yej nonkiliah: “Techtlalili tlan nikkuas, iwa ijkuak nitlamis nitlakuas iwa nikonis ijkuakó te titlakuas iwa tikonis.” ");
INSERT INTO nplNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¡N tekowa mach motlasojkamati inawak itlakewal, por okichi tlan okinawati makichiwa! ");
INSERT INTO nplNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijkó noiwa nomejwah, ijkuak tlamis nonkichiwaskeh tlan Dios nomechnawatia, xikijtokah: “Tejwah mach itla topatih, porke sanwel otikchijkeh tlan omonekia tikchiwaskeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ijkuak Jesús oyaya Jerusalén, opajpanotia kan tlalmeh de Samaria iwa Galilea. ");
INSERT INTO nplNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ijkuak ya onkalakia itech se altepetl, okinamikikoh májtlakteh tlakah non okipiaya lepra, pero san wejka omoketskeh ");
INSERT INTO nplNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","iwa okitsajtsilijkeh: —¡Jesús! ¡Tlamachti! ¡Techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ijkuak Jesús okimitak, okinmili: —Ximoteitititih innawak tiopixkeh. Ijkuak oyayah itech ojtli, owalpajtikeh. ");
INSERT INTO nplNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ijkuakó seme de yejwah ijkuak okitak yopajtik, owalmókopki iwa okiweyijkachiwaya Dios ika chikawak itlajtol, ");
INSERT INTO nplNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","iwa omixtlapacho ikxitla n Jesús, iwa okitlasojkama nin tlakatl samaritano. ");
INSERT INTO nplNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ijkuakó Jesús okitlajtlani: —¿Amo non májtlakteh akimeh onompajtikeh? ¿Kanin kateh n oksikimeh chiknawi? ");
INSERT INTO nplNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Sanwel nin tlakatl non amo israelita owalmókopki okiweyijkachiwako Dios? ");
INSERT INTO nplNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ijkuakó Jesús okili n tlakatl: —Ximoketsa iwa xio, motlaneltokalis omitspajti. ");
INSERT INTO nplNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","N fariseos okitlajtlanijkeh n Jesús, kemania kalakiki itlanawatil Dios. Jesús okinnankili: —Itlanawatil Dios mach motas ijkuak wits. ");
INSERT INTO nplNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Amo kijtoskeh, “Nikan ka”, noso “Nepa ka”, porke itlanawatil Dios ya kajki nomonawak. ");
INSERT INTO nplNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ijkuakó Jesús okinmili itlamachtijkawah: —Ajsiki n tonati ijkuak nonkinekiskeh nonnechitaskeh Ne Non onimochi ni tlakatl maya san se tonati, pero amo nonnechitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iwa nomechiliskeh: “Nikan kajki”, noso “Nepa kajki.” Pero amo xiwiah, nion xikinmotokikah. ");
INSERT INTO nplNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porke ijkó kemi ijkuak tlapejpetlani iwa tlawia de nin lado iwa asta kan ok se lado de ilwikak, ijkó Ne Non onimochi ni tlakatl sentetl nechitaskeh itech neká iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero achto nitlaijyowis iwa nechixnamikiskeh n tlakah de ninteh tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ijkó kemi otlamochi ijkuak Noé onemia, ijkó tlamochiwas ijkuak niwits Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","N tlakah otlatlakuayah iwa okoniayah, omonamiktiayah iwa otenajnamiktiayah, asta n tonati ijkuak Noé okalak itech weyi arka iwa owalmokajka n weyi kiawitl non okimijmiktih nochteh. ");
INSERT INTO nplNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Noijkó otlamochi ijkuak Lot onemia: otlatlakuayah iwa okoniayah, otlanamakayah iwa omotlakojkowiayah, otookayah iwa omokajkaltiayah; ");
INSERT INTO nplNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","pero ijkuak Lot okiski de Sodoma, owetski tletl ika asufre de ilwikak, iwa nochteh omijmikeh non ompa ochantitokah. ");
INSERT INTO nplNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijkó tlamochiwas itech neká tonati ijkuak niwalmonextis, Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'Itech non tonati, akin yetos ikpak ikal, amo mawaltemo makikixtiki tlan kipixtok tlaijtik; iwa tla aka yetos itlala amo mawalmokopa icha. ");
INSERT INTO nplNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xikilnamikikah tlan omochi isiwa n Lot. ");
INSERT INTO nplNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Akin kinekis kipalewis iyolilis kixpolos, pero, akin kipolos iyolilis por nechtlakita momakixtis. ");
INSERT INTO nplNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Ne nomechilia, itech non yúali ome kochtoskeh san sika; se kiwikaskeh iwa n ok se mokawas. ");
INSERT INTO nplNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ome siwameh testoskeh sansikah; se kiwikaskeh iwa n ok se mokawas. ");
INSERT INTO nplNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ome tlakah tekititoskeh sansikah intlala; se kiwikaskeh iwa n ok se mokawas. ");
INSERT INTO nplNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ijkuak ijkí okikakeh, okitlajtlanijkeh n Jesús: —¿Toteko, kan tlamochiwas nochi ni? Jesús okinmili: —Kan yetos n miketl, ompa moololoskeh n tsojpilomeh. ");
INSERT INTO nplNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús okinmili se tlapoálistli para kinmititis nochipa mamotiotsajtsilikah, iwa ayik mamosotlawakah. ");
INSERT INTO nplNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iwa okinmili: —Itech se altepetl okatka se tekiwa, non amo okiimakajsia Dios, nion okintlakitaya n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Itech non altepetl, noiwa ochantitoka se iknosiwatl, akin nochipa okualtlajtlaniliaya n tekiwa makipalewi porke aka okikokoliaya iwa okitlajtoltemoliaya. ");
INSERT INTO nplNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero n tekiwa mach okikakia tlan okiliaya n iknosiwatl, pero satepa okimoli: “Maya amo nikiimakajsi Dios nion aka nechtekipachoa, ");
INSERT INTO nplNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nikpalewis nin iknosiwatl iwa ayakmó mawalajto, para ayakmó manechkuejso, porke tla amo nikpalewis nochipa nechkuejsolojtos.” ");
INSERT INTO nplNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","N Toteko ok okijto: —Ye ni tlan okijto n amokuali tekiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pero Ne nomechilia: ¿Amo kimpalewis Dios akimeh Ye okimpéjpenki, iwa motiotsajtsiliah tlajka iwa n yuak?, noso ¿kintoktis mamochiakah? ");
INSERT INTO nplNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ne nomechilia Ye kimpalewis iwa amo wejkawas. Pero ijkuak Ne Non onimochi ni tlakatl niwalmokopas, ¿kechmeh ok kipiaskeh tlaneltokálistli inawak Dios? ");
INSERT INTO nplNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","N fariseos satlawel omomachiliayah kualteh n tlakah. Yejwah okintlawelitayah oksikimeh tlakah. Ijkó kiné Jesús okinmili: ");
INSERT INTO nplNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ome tlakah omotiotsajtsilitoh kan Weyi Tiopa: se fariseo, iwa n ok se tominoololo. ");
INSERT INTO nplNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","N fariseo omoketoka iwa ijkí omotiotsajtsiliaya: “Notajtsi Dios, nimitstlasojkamati porke ne mach kemi n oksikimeh, yejwah ichtekeh, amokualteh iwa mekatánajteh, iwa ne amo kemi nin tominoololo. ");
INSERT INTO nplNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne nochipa nimosawa ome tonati itech se samano, iwa nimitsmaka májtlaktli de se siento de nochi tlan niktlani.” ");
INSERT INTO nplNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero n tominoololo san wejka omoka iwa amo omixewiaya kajkokuis itlachialis, yej omoelpanwitekiaya iwa okijtoaya: “¡Noteko Dios, techiknomati, ne saikpanoa nitlajtlakolchiwa!” ");
INSERT INTO nplNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne nomechilia, nin tominoololo omókopki icha ika itlapojpolwilis Dios, pero n fariseo amó. Porke akin inewia moweyilia kipijpinatiskeh, iwa akin amo kimati moweyilia, okachi kitlakitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Noiwa okwalinwikiliayah n pípilteh inawak Jesús, para makintlalili imawah intech. Pero ijkuak itlamachtijkawah ijkí okitakeh, opé kimajwah akimeh okwalinwikiliayah n pípilteh. ");
INSERT INTO nplNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús okínnotski itlamachtijkawah iwa okinmili: —Xikinkawilikah n pípilteh mawikih nonawak, amo xikintsakuilikah, porke akimeh yolyamankeh kemi n pípilteh, kalakiskeh kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","De milajka nomechilia, akin amo kikawilis Dios matlanawati itech iyolo kemi se chokotsi kimokawilia makinawatikah, non tlakatl mach kalakis kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Se tlayákanki okitlajtlani n Jesús: —Kuali tlamachti, ¿tlan moneki nikchiwas para niyolitos nochipa kan ilwikak? ");
INSERT INTO nplNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús okili: —¿Tleka techilia nikuali? Sanwel onka se Akin kuali, Ye Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Te tikinmixmati n tlanawatílisteh: “Amo ximomekati; amo xitemikti; amo xitlachteki; amo xixolopijti; xiktlakita mota iwa n mona.” ");
INSERT INTO nplNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","N tlakatl okili: —Ninteh tlanawatílisteh nikinchijtiwits desde ni telpotsintli. ");
INSERT INTO nplNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ijkuak Jesús ijkó okikak, okili n tlakatl: —Ok mitspoloa tikchiwas itla: xiknamaka nochi tlan tikpia iwa xikinxejxelili n próbesteh, ijkó tiktlawelpias kan ilwikak; tlamis xiwiki nowa. ");
INSERT INTO nplNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero ijkuak n tlakatl ijkó okikak, satlawel omoyolkoko, porke okitlawelpiaya tomi. ");
INSERT INTO nplNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ijkuak Jesús okitak omoyolkoko, iwa okijto: —¡Owi kalakiskeh kan Dios tlanawatijtok akimeh kitlawelpiah tomi! ");
INSERT INTO nplNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Okachi amo owi panos se “kameyo” kan ik iixtololo se akuxa, iwa amo se non kitlawelpia tomi makalaki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yika akimeh ijkó okikakeh okijtojkeh: —Tla ijkó, ¿akin kalakis kan Dios tlanawatijtok? ");
INSERT INTO nplNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús okinmili: —Tlan amo weletih kichiwah n tlakah, Dios weleti kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ijkuakó, Pedro okili: —Tejwah otikkakajtejkeh nochi tlan otikpiayah, iwa otiwalajkeh mowah. ");
INSERT INTO nplNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ijkuakó Jesús okinnankili: —De milajka nomechilia, akin kikakajtewa icha, itajwah, ikniwah, isiwa, noso ipilwah, para kichiwas tlan Dios kinawatia, ");
INSERT INTO nplNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","noni kiselis okachi miak itech nin tlaltíkpaktli; iwa itech n tonatijmeh non sikin witseh, yolitos nochipa. ");
INSERT INTO nplNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Satepa, Jesús okinmoololo n májtlakteh iwa ome itlamachtijkawah iwa okinmili: —Xikkakikah, axa tiawih Jerusalén, Ne Non onimochi ni tlakatl nechtoktiskeh nochi tlan okijkuilojkeh n profetas. ");
INSERT INTO nplNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ompa nechtemakaskeh inmak non amo judíojteh, nechpijpinawiskeh, nechwijwikaltiskeh iwa nechchijchawiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nechwitekiskeh, tlamis nechmiktiskeh. Iwa ipan eyi tonati nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Itlamachtijkawah mach itla okajsikamatkeh, nion okimatiah tlan okintlapowiaya. ");
INSERT INTO nplNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ijkuak Jesús ya onajsia kan altepetl de Jericó, se tlakatl non amo otlachiaya omijtlanijtoka inakastla n ojtli. ");
INSERT INTO nplNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ijkuak n tlakatl non amo otlachiaya okinkak panotokeh miakeh tlakah, otlájtlanki tlan otlamochijtoka. ");
INSERT INTO nplNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Okilijkeh Jesús de Nazaret ik ompa opanotoka. ");
INSERT INTO nplNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ijkuakó non tlakatl otsajtsik chikawak iwa okijto: —¡Jesús, Ikone n David, techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","N tlakah non oyayah tlayakapa okajwakeh para makitsakua ikamak. Pero ye okachi chikawak otsajtsik: —¡Ikone n David, techiknomati! ");
INSERT INTO nplNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ijkuakó Jesús omóketski iwa otlanawati makualikilikah n tlakatl; iwa ijkuak okualikilijkeh, Jesús okitlajtlani: ");
INSERT INTO nplNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tlan tikneki manimitstokti? N tlakatl non amo otlachiaya otlanankili: —Noteko, nikneki nitlachias. ");
INSERT INTO nplNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús okili: —¡Xitlachia! Por motlaneltokalis yotipajtik. ");
INSERT INTO nplNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","San nima n tlakatl non amo otlachiaya owaltláchixki, iwa oyá iwan Jesús kiweyijkachijti n Totajtsi Dios. Iwa nochteh n tlakah ijkuak ijkó okitakeh, noiwa okiweyijkachijkeh Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús okalak Jericó, iwa opajpanotiaya itlajko non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ompa ochantitoka se tlakatl non itoka Zaqueo ye okitlawelpiaya tomi porke okinnawatiaya n tominoololojkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ye okinekia kixmatis Jesús. Pero mach oweletia okitaya porke miakeh tlakah oyayah iwan Jesús, iwa n Zaqueo mach wejkapa. ");
INSERT INTO nplNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ijkuakó n Zaqueo otlayákanki omotlejkoltito itech se kuawitl kan ik Jesús panoskia para weletis kitas. ");
INSERT INTO nplNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ijkuak Jesús yopanotoka ik ompa, oajkotláchixki; okitak n Zaqueo iwa okili: —Zaqueo, xitemotiwetsi, porke axa nikneki nimokalotis mocha. ");
INSERT INTO nplNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ijkuakó n Zaqueo owaltemotíwetski, iwa ika miak pakílistli okiseli n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ijkuak okitakeh, nochteh opé kipojpoah n Jesús por otlakuaato icha n se tlajtlakolchi. ");
INSERT INTO nplNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ijkuakó Zaqueo omóketski iwa okili n Toteko: —Noteko, nikinmakas n próbesteh tlajko de nochi tlan nikpia; iwa tla aka oniktlachtekili, nikkopilis nawi welta okachi. ");
INSERT INTO nplNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús okili: —Axa, itech nin tonati, Dios okinmakixtiko akimeh chantitokeh itech nin kali, porke nin tlakatl noiwa walewatok de Abraham. ");
INSERT INTO nplNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ne Non onimochi ni tlakatl oniwala onikintemoko iwa onikinmakixtiko akimeh yopolikah. ");
INSERT INTO nplNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ijkuak n tlakah okikaktokah tlan Jesús okinmilijtoka, Ye okinmili ok se tlapoálistli, porke ya onajsia Jerusalén, iwa yejwah okiyejyekoliayah Dios san nima ya pewaskia tlanawatis ompa. ");
INSERT INTO nplNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yika Jesús okinmili: —Se tlakatl non owalewatoka itech se kuali familia oyá wejka, kan sa okichixtoka kitlaliskeh inrey iwa satepa walmokopaskia. ");
INSERT INTO nplNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Iwa ijkuak yoonewaya, okínnotski májtlakteh itekitwah. Sejse okimaktilijtia se tomi non miak ipati iwa okinmili: “Xiktekitiltijtokah nin tomi para xiktlanikah okachi asta manimokopati.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero n tlakah de ialtépeu okikokoliayah, yika, ijkuak oonewak, okintitlankeh sikimeh tlakah makijtotih: “Mach tiknekih matechnawati nin tlakatl.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero maya ijkó, non tlakatl okitlalijkeh tekiwajtlanawati. Iwa ijkuak owalmokopato iwa oajsiko kan ialtépeu, okínnotski itlakewalwah non okinmajmakatewak itomi, para kimatis kech okitlankeh sejsemeh. ");
INSERT INTO nplNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Itékitki non achto okalakiko okijto: “Noteko, motomi okitlanki májtlaktli welta ipa.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","N rey okinankili: “Kuali tlan otikchi; te kuali titékitki; iwa kemi otikyektekitilti tlan san achitsi onimitsmák, nimitstlalis xikinnawati májtlakteh altepemeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Non ok se noiwa okalakiko iwa okili: “Noteko, ika motomi oníktlanki ok mákuili ipa.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","N rey noiwa okili: “Te tiyetos gobernador iwa tikinnawatijtos mákuili altepemeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ijkuakó owala ok se iwa okijto: “Noteko, nikan kajki motomi. Ne oniktlaati ika nopañito; ");
INSERT INTO nplNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","porke onimitsmawili, nikmatok tejwatsi tikuejsi, iwa tikmoaxkatia tlan amo moaxka, iwa tipixka kan amo titooka.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ijkuakó n rey okili: “Amo kuali tlakéwale, san ika motlajtolwah nikyejyekolia akin te. Yotikmatia nikuejsi, iwa nikmoaxkatia tlan amo noaxka, iwa nipixka kan amo nitooka. ");
INSERT INTO nplNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Tleka amo otiktlaati notomi itech banko, ijkó keman niwalmokopaskia, nikseliskia notomi ika nochi ikoneyo?” ");
INSERT INTO nplNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ijkuakó n rey okinmili akimeh ompa okatkah: “Xikkixtilikah n tomi, iwa xikmaktilikah akin kipixtok májtlaktli.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yejwah okilijkeh: “Noteko, pero ye ya kimpixtok májtlakteh tomimeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","N rey otlanankili: “Ne nomechilia, akin ya kipia, kimaktiliskeh okachi. Iwa akin amo kipia, kikixtiliskeh asta tlan san achitsi kipia. ");
INSERT INTO nplNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iwa nekateh akimeh amo okinekeh maniyeto intlanawati, techinwalikilikah iwa xikinkechtsontekikah noyakapa.” ");
INSERT INTO nplNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ijkuak Jesús otlanki okintlapowi, oyá Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ijkuak Jesús ya onkalakia kan altepemeh de Betfagé iwa Betania, itech olivostepetl, okintlayakanalti ome itlamachtijkawah, ");
INSERT INTO nplNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","iwa okinmili: —Xiwiah kan altepetl non kajki tlayakapa, iwa ijkuak nonkalakitiweh, ompa nonkajsitiweh se burrojtsi ilpitok, non ayamaka ipan tlejkotika. Xiktojtomakah iwa techalikilikah. ");
INSERT INTO nplNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Iwa tla aka nomechtlajtlania tleka nonkitojtomah, xikilikah n Toteko kitekitiltis. ");
INSERT INTO nplNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Itlamachtijkawah oyajkeh iwa okajsikeh nochi kemi Jesús okinmilijka. ");
INSERT INTO nplNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iwa ijkuak yokitojtontokah n burrojtsi, n tekowajkeh okintlajtlanijkeh: —¿Tleka nonkitojtomah n burrojtsi? ");
INSERT INTO nplNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yejwah otlanankilijkeh: —Porke n Toteko kitekitiltis. ");
INSERT INTO nplNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iwa nima, okiwikilijkeh n Jesús non burrojtsi, okipejpechtijkeh ika inkotonwah iwa ipan okitlejkoltijkeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iwa ijkuak Jesús opanotiaya itech ojtli, n tlakah okinsoayah intlakenwah. ");
INSERT INTO nplNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iwa ijkuak ya onajsia kan pewa ixtemoa n olivostepetl, nochteh n tlakah akimeh okineltokayah opé kojtsajtsih ika pakílistli iwa okiweyijkachijkeh Dios por nochteh n milagros non yokimitakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iwa okijtoayah: —¡Matiochito n Weyi Tlanawati Akin wits itech itoka n Toteko! ¡Mayeto yolsewílistli, iwa Weyijkachiwálistli kan ilwikak! ");
INSERT INTO nplNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ijkuakó sikimeh fariseos non okatkah intlajko n tlakah, okilijkeh n Jesús: —Tlamachti, xikintlakawalti nonteh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús okinnankili: —Ne nomechilia, tla yejwah kitsakuaskeh inkamak, n temeh tsajtsiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ijkuak Jesús ya onkalakia Jerusalén, okonitak iwa opé kichokilia. ");
INSERT INTO nplNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Iwa okijto: —¡Tla tikkajsikamatiskia maya san itech nin tonati, tlan weletis mitsmakas yolsewílistli! Pero mach weleti tikita nion tikkajsikamati. ");
INSERT INTO nplNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Porke witseh tonatijmeh, ijkuak mokokolikniwah kichijchiwaskeh se tepamitl non ika mitsyawaloskeh, sentetl mitsmojmotlaskeh ");
INSERT INTO nplNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","iwa mitspojpoloskeh. Kinmiktiskeh non motech chantitokeh, iwa amo kikawaskeh nion se tetl ipan ok se tetl, porke amo otikseli Dios, ijkuak omitstlajpaloko para mitspalewis. ");
INSERT INTO nplNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús okalak kan Weyi Tiopa iwa opé kinkixtia akimeh ompa otlanamakatokah iwa otlakojtokah, ");
INSERT INTO nplNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iwa okinmili: —Itech itlajkuilol Dios kijtoa: “Nocha, kali kan motiotsajtsiliah”, pero nomejwah yononkikopkeh se kúyoktli kan moololoah ichtekeh. ");
INSERT INTO nplNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nochi tonati Jesús otlamachtiaya itech Weyi Tiopa, pero n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli, iwa n tlayakankeh israelitas, okitemolijtinemiah kenijki kimiktiskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero mach okajsiah kenijki kichiwaskeh, porke n tlakah nochipa okiwikatinemiah iwa okikakiah itemachtilis. ");
INSERT INTO nplNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se tonati, ijkuak Jesús okinmachtijtoka n tlakah n kualitlájtoli kan Weyi Tiopa, owalajkeh n tiopixkeh non tlayakantokeh, non kitemachtiah n tlanawatílistli iwa n tetajmeh non tlayakantokeh kan tiopa, ");
INSERT INTO nplNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","iwa okitlajtlanijkeh: —Techili, ¿akin omitsnawati ijkó xikchiwa? Iwa, ¿akin omitsmák non tekiwajyotl? ");
INSERT INTO nplNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús okinnankili: —Ne noiwa nomechtlajtlanis, iwa technankilikah: ");
INSERT INTO nplNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Akin okinawati n Juan matlakuaateki? ¿Okinawati Dios noso n tlakah? ");
INSERT INTO nplNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yejwah opé moichtakatlajtoltiah iwa okijtoayah: —¿Tlan tikijtoskeh? Tla tikijtoskeh Dios okinawati, Ye techilis: “¿Tleka mach ononkineltokakeh?” ");
INSERT INTO nplNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero, tla tikijtoskeh n tlakah okinawatijkeh, nochteh n tlakah techmokitskiliskeh ika tetl iwa techmiktiskeh, porke yejwah kuali kimatokeh Juan iprofeta n Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ijkuakó, yejwah okinankilijkeh mach okimatiah. ");
INSERT INTO nplNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ijkuakó Jesús okinmili: —Ne noiwa mach nomechilis akin onechmák nin tekiwajyotl. ");
INSERT INTO nplNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Otlanki Jesús opé kintlapowia ika nin tlapoálistli: —Se tlakatl okintookak miakeh uvaskuaujmeh itlala. Satepa okinmák partido sikimeh uvastekitkeh, iwa non tekowa wejka oyá, iwa owejkawato. ");
INSERT INTO nplNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Iwa ijkuak oajsiko n tonati para motlatekis, n tekowa okitítlanki se itlakewal makitlajkoxelilikah n uvas. Pero n uvastekitkeh okitekilmakakeh itlakewal n tekowa iwa okikopkeh mapijpilkati. ");
INSERT INTO nplNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Otlanki n tekowa okitítlanki ok se itlakewal. Pero n uvastekitkeh noiwa okitekilmakakeh, okiwijwikaltijkeh iwa okikopkeh noiwa mapijpilkati. ");
INSERT INTO nplNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Niman, n tekowa okitítlanki ok se itlakewal, pero n uvastekitkeh noiwa okikojkojkeh iwa okwalkixtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Ijkuakó n tekowa okijto: “¿Axa tlan nikchiwas? Niktitlanis nopiltsi non satlawel niktlasojtla, ijkuak kitaskeh, ye okachi kitlakitaskeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ijkuak n uvastekitkeh okitakeh ipiltsi n tekowa, okijtojkeh: “Ye ni akin kiselis tlan iaxka n tekowa; matikmiktikah iwa ijkó tejwah tikmokawiskeh n lawerta.” ");
INSERT INTO nplNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ijkuakó, n uvastekitkeh okwalkixtijkeh de kan lawerta iwa okimiktijkeh. Ijkuakó Jesús okintlajtlani: —Axa, ¿tlan nonkiyejyekoliah kintoktis n tekowa nonteh uvastekitkeh amokualteh? ");
INSERT INTO nplNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ye yas iwa kinmijmiktis nonteh uvastekitkeh, iwa ilawerta kinmaktilis oksikimeh. Ijkuak yejwah ijkí okikakeh, okijtojkeh: —¡Amo Dios makimonekilti! ");
INSERT INTO nplNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús okintlajtlatak iwa okinmili: —¿Tlan kijtosneki itlajkuilol Dios kan kijtoa? N tetl non n kalchijchijkeh okontlakaltechojkeh, omochiwako non okachi tetlakxili. ");
INSERT INTO nplNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Akin wetsis ipan non tetl mopopostekis. Pero tla n tetl wetsis ipan se, kikuejkuechos. ");
INSERT INTO nplNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ijkuak n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli, okajsikamatkeh n Jesús okinkakitijtoka non tlájtoli. Satlawel okualankeh iwa okinekiah kikitskiskeh, pero mach okikitskijkeh porke okinmawiliayah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ijkuakó okintitlankeh sikimeh teixkajkayajkeh inawak Jesús para makikajkakitih tlan kijtoa, iwa ijkó weletis kitemaktiskeh inawak n gobernador. ");
INSERT INTO nplNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yika ijkí okitlajtlanijkeh: —Tlamachti, tikmatokeh tlan tikijtoa iwa tlan tiktemachtia milák, iwa amo san tikpejpena motemachtilis. Tejwatsi kuali titlamachtia ijkó kemi Dios kimonekiltia matiyeknemikah. ");
INSERT INTO nplNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Techonili: ¿Kuali ka matiktlaxtlawakah impuestos inawak n romanojtekiwa, noso amó? ");
INSERT INTO nplNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús okajsikama san okiyejyekojtokah iwa okinmili: —¿Tleka nonnechyejyekoah? ");
INSERT INTO nplNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Techititikah se denariojtomi. ¿De akin ixko nikan ka?, iwa ¿akin itoka ijkuilitok? Yejwah okinankilijkeh: —De César. ");
INSERT INTO nplNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ijkuakó Jesús okinmili: —Xikmakakah n César tlan iaxka n César, iwa xikmakakah Dios tlan iaxka n Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iwa n tlakah mach itla okajxililijkeh itech tlan okijtoaya non ika kiteiliskiah, yej omotlajtlachialtijkeh kenijki okinnankili, yika san owalmokakajkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Satepa sikimeh saduseos non amo kineltokah non yomikkeh oksepa moyolitiah, omijkuanijkeh inawak Jesús iwa okitlajtlanijkeh: ");
INSERT INTO nplNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tlamachti, itech itlanawatil Moisés ijkí otechtlajkuilili, tla se tlakatl non ya kipia isiwa, mikki iwa amo okímpixki ipilwah iwan isiwa, n iknosiwatl moneki mamonamikti iwan ikni non yomikki para makinmaka ipilwah ikni non yomikki. ");
INSERT INTO nplNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yowejka okatkah chikome iknimeh. Non teteachka omonamikti pero omikki iwa amo okinkajteh ipilwah. ");
INSERT INTO nplNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Itsoyo non omikki omonamikti iwan iknosiwatl. Pero noiwa omikki iwa amo okinkajtewili ipilwah. ");
INSERT INTO nplNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ijkuakó non ipan eyi iknimeh noiwa omonamikti iwa n iknosiwatl; iwa nochteh n iknimeh omonamiktijtiajkeh iwa non iknosiwatl pero nochteh omijmiktiajkeh, iwa nion seme de yejwah okimák se konetl non siwatl. ");
INSERT INTO nplNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sa iksemi, n siwatl noiwa omikki. ");
INSERT INTO nplNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Axa, ijkuak non yomikkeh moyolitiskeh, nin siwatl ¿de akin yetos tesiwa, tla n chikome iknimeh omonamiktijkeh iwa non siwatl? ");
INSERT INTO nplNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ijkuakó Jesús okinmili: —Itech nin tlaltíkpaktli, n tlakah iwa n siwameh monamiktiah. ");
INSERT INTO nplNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ijkuak moyolitiskeh non yomikkeh, akimeh Dios kinkawilis makalakitih kan ilwikak; ompa ayakmó monamiktiskeh nion kintemakaskeh impilwah mamonamiktikah, ");
INSERT INTO nplNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","porke ompa mach ok mikiskeh. Yetoskeh kemi ángelteh, iwa yetoskeh tepilwah de Dios porke omoyolitijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Inewia n Moisés itech itlajkuilol de n tlátsmoli non otlatlaya, otechmatilti non yomikkeh oksepa moyolitiskeh. Ompa nestok kan Moisés kijtoa n Totajtsi, Ye Idios Abraham, Isaac, iwa Jacob. ");
INSERT INTO nplNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Porke Dios amo Dios de non yomikkeh, yej de akimeh yolitokeh, porke ixpa n Ye nochteh yolitokeh. ");
INSERT INTO nplNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ijkuakó sikimeh non kitemachtiah n tlanawatílistli okilijkeh: —Tlamachti, kuali tlan otikijto. ");
INSERT INTO nplNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iwa ayakmó omixewijkeh okachi kitlatlajtlaniskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús okinmili: —¿Kenomi nonkijtoah Cristo ikone n David? ");
INSERT INTO nplNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porke n David inewia kijtoa itech salmos: N Totajtsi Dios okili n Noteko: “Ximoyayanti noyekma, ");
INSERT INTO nplNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta manikintlali mokokolikniwah itlampa mokxiwah.” ");
INSERT INTO nplNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tla inewia n David kilia n Cristo, Noteko; ¿kenomi n Cristo weletis yetos ikone n David? ");
INSERT INTO nplNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nochteh n tlakah okikaktokah ijkuak Jesús okinmili itlamachtijkawah: ");
INSERT INTO nplNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ximotlachilikah de akimeh kitemachtiah n tlanawatílistli, porke kiwilitah nemiskeh ika intlakeh weweyak, iwa kinekih makinyektlajpalokah ijkuak nemi tiánkistli. Iwa itech sinagogas kiwilitah motlaliskeh kan motlaliah n tlayakankeh, iwa kiwilitah motlaliskeh kan okachi kualteh lojarteh itech ilwimeh. ");
INSERT INTO nplNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Noiwa kintlakijkixtiliah n iknosiwameh, iwa para amaka makimati, satlawel motiotsajtsiliah. Ne nomechilia, ninteh kiseliskeh okachi weyi tlaijyowílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ijtik Weyi Tiopa, Jesús okimitak n tominyojkeh ijkuak okontlalijtokah intomi kan nochteh okitlaliaya. ");
INSERT INTO nplNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noiwa okitak se probe iknosiwatl ijkuak okintlali ome tomintsitsinteh non amo miak impati. ");
INSERT INTO nplNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iwa Jesús okijto: —De milajka nomechilia, nin probe iknosiwatl, okachi okitemák ke n oksikimeh; ");
INSERT INTO nplNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","porke nochteh okitemakakeh tlan ayakmó kitekitiltiah, pero nin probe iknosiwatl okitemák nochi tlan ika panotoskia. ");
INSERT INTO nplNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sikimeh okimolijtokah saikpanoa kualtsitsinteh n temeh non okintekitiltijkeh ijkuak okichijchijkeh n Weyi Tiopa, iwa kenijki kualtsi otlamajmankeh itech itepanwah. Ijkuakó Jesús okijto: ");
INSERT INTO nplNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Wits tonati ijkuak nochi ni tlan nomejwah nonkitlajtlatokeh kixijxitiniskeh, iwa amo mokawas nion se tetl ikpak ok se. ");
INSERT INTO nplNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ijkuakó okitlajtlanijkeh n Jesús: —Tlamachti, ¿kemania ijkó tlamochiwas?, iwa ¿tlan monextis ijkuak ijkó ya tlamochiwati? ");
INSERT INTO nplNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús okijto: —Ximotlachilikah, iwa amo manomechkajkayawakah. Porke miakeh kijtojtiwitseh itech Notoka: “Ne Cristo”; iwa kijtoskeh: “Yoajsiko n tonati.” Amo xikinneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Keman nonkimatiskeh momijmiktilo iwa motekilmakalo, amo ximomojtikah, nochi ni moneki mamochiwa, pero ayamó itlamia n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús noiwa okinmili: —N tlanawatijkeh de se weyi tlali motekilmakaskeh iwa n tlanawatijkeh de ok se weyi tlali, iwa n tekiwajkeh de se altepetl motekilmakaskeh iwan tekiwajkeh de ok se altepetl. ");
INSERT INTO nplNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tlalolinis chikawak, iwa sentetl yetos apisotl iwa kokólistli, iwa itech ilwikak motas tlan temojti non ayik motika. ");
INSERT INTO nplNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","'Pero achto, nomechkitskiskeh iwa nomechtotojtokaskeh. Nomechwikaskeh innawak tekiwajkeh de sinagogas iwa nomechtsakuatiweh. Nomechtemaktiskeh inmak wejweyi tlanawatijkeh iwa gobernadormeh por nonnechtlakitah. ");
INSERT INTO nplNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ijkuakó nomejwah nonweletiskeh nonkintlapowiskeh de Ne. ");
INSERT INTO nplNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Amo sa manomechtekipachojto kenijki nonmotlajtolpalewiskeh ijkuak nonyetoskeh inyakapah n tekiwajkeh, ");
INSERT INTO nplNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porke Ne nomechinmakas n tlájtolteh non nomejwah nonkintenkixtiskeh, iwa nion se de akin nomechkokolia kixikos nion nomechtlajtolkopas. ");
INSERT INTO nplNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Innewiah nomotajwah, nomokniwah, nomotlakaikniwah iwa non ken nonkinmitah nomechtejtemaktiskeh. Iwa sikimeh de nomejwah nomechmiktiskeh, ");
INSERT INTO nplNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","iwa nochteh n tlaltikpaktlakah nomechkokoliskeh por nonnechneltokah, ");
INSERT INTO nplNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","pero nion se nomotsonkal poliwis. ");
INSERT INTO nplNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'Iwa tla nochi nonkixikoskeh, nonmomakixtiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","'Ijkuak nonkinmitaskeh n soldadojteh yokiyayawalojkeh n Jerusalén, ijkuakó kuali xikmatikah ya kixijxitiniskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ijkuakó, akimeh yetoskeh Judea, macholokah kan tepemeh; iwa akimeh yetoskeh Jerusalén noiwa makisakah, iwa akimeh yetoskeh intlala amo mamokopakah Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porke itech nekateh tonatijmeh Dios tetlaijyowiltis, ijkó kemi ijkuilitok itech itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Miálmasteh n siwameh akimeh itech nonteh tonatijmeh kokoxtitoskeh de konetl noso matlachichitijtokah! Porke yetos miak tlaijyowílistli itech nin tlaltíkpaktli, iwa ikualanilis Dios wits ipan ninteh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sikimeh kinmiktiskeh, iwa oksikimeh kintsakuatiweh itech oksikimeh tlalmeh. Iwa non amo judíojteh kitlajtlaksaskeh n Jerusalén, asta ijkuak Dios kijtos matlami tlan kichijtokeh n tlakah non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","'Ijkuakó motaskeh neskáyolteh itech tonati, itech metsi iwa itech sítlalteh; iwa itech n tlaltíkpaktli n tlakah san moixtlapololtijtoskeh iwa momojtiskeh ijkuak ijkuyukas n weyi atl iwa n amemélolteh. ");
INSERT INTO nplNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","N tlakah tlawelmomojtiskeh ijkuak kajsikamatiskeh tlan panos itech nin tlaltíkpaktli; porke asta n chikawálisteh non kateh ilwikak bibiokaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ijkuakó nechitaskeh Ne Non onimochi ni tlakatl, niwaltemotiwits itech se mextli ika noweletilis iwa ika se weyi tláwili. ");
INSERT INTO nplNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ijkuak pewas ijkó tlamochiwas, ximoyolchikawakah iwa xiajkotlachiakah porke san nima nomechmakixtikih. ");
INSERT INTO nplNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús noiwa okinmili nin tlapoálistli: —Xikitakah n igoskuawitl, noso ok se tlatookali. ");
INSERT INTO nplNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ijkuak nonkitah yopé mokopina, nonkimatih ya walajsi n tonala. ");
INSERT INTO nplNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ijkó noiwa, ijkuak nonkitaskeh ijkó ya tlamochijtok, xikmatikah itlanawatil Dios ya walajsi. ");
INSERT INTO nplNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'De milajka nomechilia, nochi ni tlamochiwas, iwa n tlakah non axa yolitokeh kitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","N ilwikak iwa n tlaltíkpaktli pojpoliwiskeh, pero notlajtol ayik pojpoliwis. ");
INSERT INTO nplNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","'Ximotlachilikah; amo xiktlakuawakah nomoyolo ika tlan amo kuali, amo san xitlakuajtinemikah, amo xitlawantinemikah iwa amo xikkawilikah manomechtekipacho tlan onka itech nin tlaltíkpaktli. Porke Ne san nonkisaki itech neká tonati, iwa amo nikneki ijkó nomechajsiki. ");
INSERT INTO nplNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yetos kemi se tékochtli non amo mota iwa wetsiskeh nochteh n tlakah non nemi itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xiijsatokah, iwa nochipa ximotiotsajtsilijtokah para weletis nonmakisaskeh de nochi tlan panos, iwa ijkó nonweletiskeh nonmoketoskeh nonawak Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús otlamachtiaya tlajka kan Weyi Tiopa, iwa de yuak, oyaya kan olivostepetl iwa ompa omokawaya. ");
INSERT INTO nplNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iwa nochi tonati, miakeh oyayah kan Weyi Tiopa san kualka para kikakiskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yowalajsia n ilwitl ijkuak mokua paj non amo kipia levadura, non okiliayah n ilwitl de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","N tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli, okitemoliayah kenijki kimiktiskeh n Jesús. Pero mach oweletiah porke okinmawiliayah n tlakah non iwa onemiah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ijkuakó, satanás okimoaxkati n Judas Iscariote akin tewa iwan májtlaktli iwa n ome tlatematiltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ye okimitato n tiopixkeh non tlayakantokeh iwa non okimokuitlawiayah n Weyi Tiopa, inwah omotlapowito tlan kichiwaskia para kinmaktilis n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yejwah saikpanoa opakmikeh iwa okilijkeh kimakaskeh tomi. ");
INSERT INTO nplNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas omoyekka inwah, iwa opé kitemolia kemania weletis kinmaktilis n Jesús, pero ijkuak amo makitakah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oajsiko n ilwitl de Paskua ijkuak mokua n paj non amo kipia levadura iwa kimiktiah n ichkatsi. ");
INSERT INTO nplNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ijkuakó Jesús okintítlanki n Pedro iwa Juan, iwa okinmili: —Xikmajmanatih n tlákuali de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yejwah okitlajtlanijkeh: —¿Kani tikneki matikmajmanatih? ");
INSERT INTO nplNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús okinnankili: —Ijkuak nonkalakitiweh Jerusalén, nonkinamikiskeh se tlakatl kimamajti iaxoktsi. Xikkuitlapantokakah asta itech kali kan kalakiti, ");
INSERT INTO nplNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","iwa xikilikah n tekowa: “N Tlamachti tlajtlani: ¿Kanin kajki n kuarto kan kimomajsewis n tlákuali de Paskua iwan itlamachtijkawah?” ");
INSERT INTO nplNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ijkuakó ye nomechititis se weyi kuarto kan tlamajmantos, non kajki tlakpak; ompa xikmajmanakah n tlákuali de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yejwah oyájkeh iwa okajsikeh nochi kemi Jesús okinmilijka, iwa okimajmankeh n tlákuali de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ijkuak ya motlamajsewiskiah, Jesús omoyayanti iwa n májtlaktli iwa ome itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iwa okinmili: —¡Satlawel yoniktlawelnektoka nikmomajsewis nin tlákuali de Paskua nomowah, achto de nimikkis! ");
INSERT INTO nplNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porke de milajka nomechilia, amo nikmomajsewis oksepa nin tlákuali asta ijkuak tikmosepanmajsewiskeh kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ijkuakó Jesús okónanki se kopa, omotlasojkama inawak Dios, iwa okijto: —Xikonikah non nochteh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ne nomechilia mach nikonis oksepa iayo n uvas, tlamo asta maajsiki n tonati ijkuak Dios pewas tlanawatis. ");
INSERT INTO nplNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Otlanki okónanki n paj iwa omotlasojkama inawak Dios; okitlatlajkotlápanki iwa okinmajmák itlamachtijkawah iwa okinmili: —Ye ni nokuerpo non niktemaka por nomejwah. Ijkí xikchiwakah para nonnechilnamikiskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ijkuak yokimomajsewijkeh n paj; okónanki n kopa iwa okijto: —Nin kopa ye noesso non ika timotlajtolsenkawa, iwa motoyawas por nomejwah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","'Pero axa, akin nechtemaktis kajki nowa itech mesa. ");
INSERT INTO nplNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Porke Ne Non onimochi ni tlakatl, nimikkis ijkó kemi Dios kimonekiltia, pero, ¡mialma n tlakatl akin nechtemaktis! ");
INSERT INTO nplNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ijkuakó opé motlatlajtlaniah akin kitemaktiskia. ");
INSERT INTO nplNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Otlanki yejwah opé motlatlajtolkopah akin okachi weyijkatitoskia. ");
INSERT INTO nplNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús okinmili: —N reyes moweyiliah iwa kinnajnawatiah n tlakah de non altepetl, iwa n tlakah de non altepetl kinnotsah kualteh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero nomejwah amo ijkó xikchiwakah, yej akin weyijkatitok, amo mamoweyili; iwa akin teyakana, noiwa makimati matetlakita. ");
INSERT INTO nplNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Akin okachi weyijkatitok?, ¿akin sa kitlateekiliah matlakua, noso akin tlateeka? ¿Amo okachi weyijkatitok akin sa kitlateekiliah matlakua? Pero Ne nika nomowah kemi se non tlateeka. ");
INSERT INTO nplNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","'Iwa nomejwah nochipa nontlaijyowijtinemih nowa. ");
INSERT INTO nplNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yika, Ne nomechtlalis xitlanawatikah, ijkó kemi Notajtsi onechtlali manitlanawati, ");
INSERT INTO nplNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","para ximotlamajsewikah iwa xikonikah ipan nomesa kan nitlanawatia. Noiwa para nonmoyayantiskeh iwa nonkinmixkomakaskeh n májtlakteh iwa ome familias de Israel. ");
INSERT INTO nplNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Satepa okijto: —¡Simón, Simón, xikkaki! N satanás yonomechtlájtlanki para nomechtsejtselos kemi kitsejtseloah n trigo; ");
INSERT INTO nplNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pero Ne yonimotiotsajtsili para amo xikpolo motlaneltokalis. Iwa ijkuak timoyolpatlas, xikinyolchikawa mokniwah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro okili n Jesús: —¡Noteko, nimotemaka nias mowa maya manechtsakuakah noso manechmiktikah! ");
INSERT INTO nplNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús okili: —Pedro, Ne nimitsilia achto de tlakuikas n kaxtil, te tikijtos eyi welta, “Amo nikixmati.” ");
INSERT INTO nplNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ijkuakó Jesús okinmili: —Ijkuak onomechtítlanki, amo ononkiwikakeh nomopuxa, nion nomopuxajtomi, nion oksikimeh nomokakkuah, ¿itla onomechpolo? Yejwah otlanankilijkeh: —Amitla otechpoloh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ijkuakó Jesús okinmili: —Pero axa, akin kipia se ipuxa, makimowikili noiwa ipuxajtomi, iwa akin amo kipia iespada, makinamaka se ikoto iwa makimokuili se iespada. ");
INSERT INTO nplNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porke Ne nomechilia moneki mamochiwa tlan ijkuilitok itech itlajkuilol Dios: “Okitakeh kemi yaskia se tlakatl amo kuali.” Porke nochi tlan ijkuilitok de Ne moneki mamochiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ijkuakó yejwah okilijkeh: —Noteko, nika kateh ome espadajteh. Jesús okinnankili: —Ya kuali ka. ");
INSERT INTO nplNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús okiski de Jerusalén iwa oyá kan olivostepetl, kan nochipa onmotiotsajtsiliaya. Itlamachtijkawah noiwa oyajkeh íwa. ");
INSERT INTO nplNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ijkuak okalakitoh kan olivostepetl, Jesús okinmili itlamachtijkawah: —Ximotiotsajtsilikah, para amo manomechyoltilana n tlajtlákoli. ");
INSERT INTO nplNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nima omijkuani ixwejkatsi kemi sempóali metro, iwa ompa omotlankuáketski iwa opé motiotsajtsilia. ");
INSERT INTO nplNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Iwa okijto: —Notajtsi, tla tikmonekiltia, techachiwili nin tlaijyowílistli. Pero amo mamochiwa kemi Ne nikneki, yej kemi Tejwatsi tikmonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ijkuakó okimonextili se ángel de ilwikak non okiyolchikawako. ");
INSERT INTO nplNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iwa ken satlawel otlaijyowijtoka, okachi omotiotsajtsiliaya, iwa itonil omókopki kemi estli iwa owetsia ixko tlali. ");
INSERT INTO nplNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ijkuak Jesús otlanki omotiotsajtsili, omókopki kan itlamachtijkawah; iwa ken satlawel omoyolkokoayah, okochtlamilajkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iwa okinmili: —¿Tleka nonkochtokeh? Ximewakah iwa ximotiotsajtsilikah para amo manomechyoltilana n tlajtlákoli. ");
INSERT INTO nplNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ok okintlapowijtoka itlamachtijkawah ijkuak okalakikoh miakeh tlakah. Judas seme de n májtlakteh iwa ome itlamachtijkawah okwalinyakantiwalaya, niman omijkuani inawak Jesús para kiixtennamikis. ");
INSERT INTO nplNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ijkuakó Jesús okili: —Judas, ¿techixtenamiki para manechkitskikah, iwa ijkó techtemaktia Ne Non onimochi ni tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Akimeh okatkah iwan Jesús, ijkuak okitakeh tlan otlamochijtoka, okitlajtlanijkeh: —Tejwatsi, ¿tikneki matikinkojkokah ika toespadajwah? ");
INSERT INTO nplNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ijkuakó seme de yejwah okikojko se itékitki n tiópixki non okachi otlayakantoka, ni okitekili inakas non iyekma. ");
INSERT INTO nplNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús okili: —Xikinkawakah, ¡ayakmó xikinkojkokah! Ijkuakó Jesús okitelkoli inakas non tlakéwale, iwa owalpajtik. ");
INSERT INTO nplNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Otlanki, Jesús okinmili n tiopixkeh non tlayakantokeh, iwa non otlamokuitlawiayah kan Weyi Tiopa iwa n tetajmeh non tlayakantokeh kan tiopa, non okikitskikoh: —¿Ononwalajkeh ononnechkitskikoh ika espadajteh iwa ika kuawitl kemi niyetoskia se ichtek? ");
INSERT INTO nplNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ixmostla onikatka nomowah kan Weyi Tiopa, iwa ayik ononnechtelkojkeh. Pero ye ni nomoora ijkuak tleyua iwa nomejwah nonweletih nonkichiwah nomoteki. ");
INSERT INTO nplNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ijkuakó okikitskijkeh n Jesús, iwa okiwikakeh icha n tiópixki non okachi otlayakantoka, iwa n Pedro san wejka okintokaya. ");
INSERT INTO nplNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ompa itlajkotia n patio otlatlatijkeh, okiyawalojkeh n tlékuili iwa omotlajtlalijkeh; noiwa n Pedro omotlali inwah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ijkuakó se iteska n tiópixki non okachi otlayakantoka okitak n Pedro ewatok inakastla n tlékuili, okisentlajtlatak iwa okijto: —Nin tlakatl noiwa okatka iwa n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero n Pedro mach okimokuiti, iwa okijto: —Siwatl, ne mach nikixmati. ");
INSERT INTO nplNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Okachi satepa ok se tlakatl okitak n Pedro iwa okili: —Te noiwa seme de yejwah. Pero Pedro okijto: —Mach ne, otimoixtlapololti. ");
INSERT INTO nplNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kemi se ora okachi satepa, ok se tlakatl noiwa okili: —De milajka nin tlakatl tewa íwa, ye noiwa walewatok de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ijkuakó Pedro okijto: —Tlakatl, mach nikmati tlan tikijtojtok. Ijkuak Pedro ok otlajtojtoka, owaltlakuikak n kaxtil. ");
INSERT INTO nplNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ijkuakó n Toteko omókopki iwa okitak n Pedro, ijkuakó Pedro okilnamik tlan Jesús yokilijka: “Ijkuak tlakuikas n kaxtil, te yotikijto eyi welta amo nikixmati.” ");
INSERT INTO nplNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ijkuakó Pedro okiski iwa satlawel ochokak. ");
INSERT INTO nplNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Akimeh okimokuitlawijtokah n Jesús okipijpinawiayah iwa okitekilmakayah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Okiixtsajtsakeh, okiixwijwitekiah iwa okiliayah: —¡Techili, akin omitsmák! ");
INSERT INTO nplNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iwa ika tlájtolteh pitsotikeh okipijpinawiayah. ");
INSERT INTO nplNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ijkuak owaltláneski, omoololojkeh n tetajmeh non tlayakantokeh kan Weyi Tiopa, noiwa n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli, iwa okiixpantitoh n Jesús innawak n Sanedrín. Iwa ompa okitlajtlanijkeh: ");
INSERT INTO nplNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Techili, ¿te ti Cristo? Ye okinnankili: —Tla nomechilis Ne Ni Cristo, mach nonnechneltokaskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Desde tla Ne nomechtlajtlanis itla, mach nonnechnankiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Desde axa, Ne Non onimochi ni tlakatl, niewatos iyekma Totajtsi Dios Akin kipia nochi weletílistli. ");
INSERT INTO nplNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ijkuakó nochteh okitlajtlanijkeh: —¿Tejwatsi Ikone Dios? Jesús okinmili: —Milák, Ne Ikone n Totajtsi Dios kemi nomonewiah yononkijtojkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ijkuakó yejwah okijtojkeh: —¿Tlan ok para tikintlatlajtlaniskeh oksikimeh? Tonewiah yotikkakeh tlan okijto. ");
INSERT INTO nplNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ijkuakó nochteh owalmokeketskeh, iwa okiwikakeh n Jesús inawak Pilato. ");
INSERT INTO nplNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ompa opé kiteiliah, iwa okijtojkeh: —Otikitakeh nin tlakatl kimpajsolojtinemi n tlakah. Ye kijtojtinemi amo matiktlaxtlawilikah impuestos n César, iwa kijtoa ye n Cristo, iwa kijtoa Ye rey. ");
INSERT INTO nplNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ijkuakó Pilato okitlajtlani n Jesús: —¿De milajka te inrey n judíojteh? Jesús okinankili: —Milák, ijkó ken yotikijto. ");
INSERT INTO nplNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ijkuakó Pilato okinmili n tiopixkeh non tlayakantokeh iwa nochteh n tlakah: —Ne amitla amokuali nikajsi itech nin tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero yejwah okachi okualankeh iwa okijtojkeh: —Kimpajsolojtinemi nochteh n judiojteh ika itlamachtilis. Opé Galilea, iwa nika yokalakiko. ");
INSERT INTO nplNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ijkuak Pilato ijkí okikak, otlájtlanki kox non tlakatl walewatok de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ijkuak okilijkeh Jesús owalewatoka de Galilea, okitítlanki kan Herodes, gobernador de Galilea. Itech nonteh tonatijmeh Herodes okatka Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ijkuak Herodes okitak n Jesús satlawel opaki; porke miakeh omotlapowiayah de Jesús iwa yowejka okinekia kixmatis, iwa okinekia kitas se neskayotl. ");
INSERT INTO nplNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes okitlatlajtlani n Jesús, pero Ye machitla okinankili. ");
INSERT INTO nplNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ompa okatkah n tiopixkeh non tlayakantokeh iwa non kitemachtiah n tlanawatílistli, akimeh okitlawelteiliayah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ijkuakó Herodes Antipas Primero iwa isoldadojwah fiero okitoktijkeh n Jesús, iwa para okachi fiero kipijpinawiskeh okitlakentijkeh kemi yetoskia Rey, iwa n Herodes oksepa okitítlanki kan Pilato. ");
INSERT INTO nplNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato iwa n Herodes omokokoliayah, pero non tonati opé moyekwikah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ijkuakó n Pilato okinmoololoh n tiopixkeh non tlayakantokeh, n tekiwajkeh iwa nochteh n tlakah, ");
INSERT INTO nplNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iwa okinmili: —Nomejwah ononnechalikilijkeh nin tlakatl, porke nonkijtoah kimpajsolojtinemi n tlakah. Ne yoniktlatlajtlani nomoixpah, iwa yononkikakeh amitla amokuali nikkajxililia ika tlan nomejwah nonkiteiliah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nion Herodes mach okijto kox tlajtlakole nin tlakatl, yika oksepa otechaltitlanili, porke noiwa amitla okajsik kemi para matikmiktikah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nitlanawatis makitsonwitekikah iwa nikkajkawas. ");
INSERT INTO nplNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nochi xiwitl itech ilwitl de Paskua, Pilato okimpaktiaya n judíojteh ijkuak okinkajkawiliaya seme de non tsaktokeh. ");
INSERT INTO nplNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nochteh otsajtsikeh chikawak: —¡Xikmikti non tlakatl! ¡Xikkajkawa n Barrabás! ");
INSERT INTO nplNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nin Barrabás otsaktoka porke otemikti iwa okimpajsolojka miakeh tlakah para makixnamikikah n gobierno. ");
INSERT INTO nplNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato oksepa okintlapowi n tlakah porke okinekia kikajkawas n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero yejwah oksepa otsajtsikeh: —¡Xikkrusifikaro! ¡Xikkrusifikaro! ");
INSERT INTO nplNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ipan eyi welta Pilato okinmili: —¿Tleka nonkinekih mamikki?, ¿tlan amo kuali okichi? Ne mach nikita satlawel tlajtlakole, kemi para makimotlanili imikilis. Nitlanawatis makitsonwitekikah iwa satepa nikkajkawas. ");
INSERT INTO nplNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yejwah okachi otsajtsiah chikawak iwa okitlajtlaniliayah makikrusifikaro n Jesús; iwa kemi yejwah satlawel otsajtsiah, okinekiltijkeh n Pilato makinchiwili tlan okitlajtlanilijtokah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ijkuakó Pilato okichi tlan yejwah okitlajtlanilijkeh, ");
INSERT INTO nplNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","iwa okikajka n Barrabás, non otsaktoka por okimpajsolojka n tlakah iwa por otemikti, otlanki okinnawati isoldadojwah makikrusifikarokah n Jesús kemi yejwah okinekiah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ijkuak yokiwikayah kikrusifikarotiweh n Jesús, okiyakanamikeh se tlakatl de Cirene non itoka Simón. Ye owalewaya de itlala iwa okitoktijkeh makimama n krus, iwa makikuitlapantoka n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Miakeh tlakah de Jerusalén okwaltokayah n Jesús. Noiwa miakeh siwameh okichokilijtiayah iwa omoyolkokojtiayah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesús okimitak iwa okinmili: —Siwameh de Jerusalén, amo techchokilikah, yej ximochokilikah iwa xikinchokilikah nomopilwah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","¡Xikakikah!, witseh tonatijmeh ijkuak kijtoskeh: “Miak yolpakílistli para akimeh amo okimpixkeh impilwah, nion okonewajtikeh nion otlachichitijkeh.” ");
INSERT INTO nplNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ijkuakó n tlakah pewas kinmiliskeh n tepemeh: “Xiwetsikah topah”; iwa kinmiliskeh n tepeyomeh: “Techtlaatikah.” ");
INSERT INTO nplNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pero tla ijkó kichiwah iwa n kuawitl xoxobik tlan kichiwaskeh ika non yowaki? ");
INSERT INTO nplNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Noiwa okinwikayah ome ichtekeh iwa temiktijkeh para kinkrusifikaroskeh inajnakastla n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ijkuak okalakitoh kan tepetl non kiliah Miketsontekomatl, okikrusifikarojkeh n Jesús. Noiwa ompa okinkrusifikarojkeh ome tlachtekeh, se ik iyekma iwa n ok se ik iopochma. ");
INSERT INTO nplNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iwa ijkuak yokikrusifikarojtokah, Jesús okijto: —Notajtsi, xikintlapojpolwi, porke mach kimatih tlan kichiwah. Iwa n soldadojteh okinmotlatlanilijkeh itlakenwah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","N tlakah de non altepetl okimawisojtokah, iwa asta n tekiwajkeh okipijpinawiayah n Jesús iwa okijtoayah: —Oksikimeh okinmakixti, axa, tla de milajka Ye n Cristo itlapejpenil Dios, mamomakixti inewia. ");
INSERT INTO nplNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","N soldadojteh noiwa okipijpinawiayah n Jesús, omopachoayah inawak iwa okitiayah vinagre, ");
INSERT INTO nplNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","iwa okiliayah: —Tla Te tirey de judíojtih, ximomakixti monewia. ");
INSERT INTO nplNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Noiwa ik ikuatsontla okijkuililijkeh non okijtoaya: “Ye ni inrey n judiojteh.” ");
INSERT INTO nplNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Seme de nonteh ichtekeh non okikrusifikarojkeh inakastla n Jesús, ijkí fiero okiliaya: —Tla te ti Cristo, monewia ximomakixti, iwa tejwah noiwa. ");
INSERT INTO nplNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero non ok se ichtek okajwak iwa okili: —¿Amo tikmawilia Dios, maya ya tikmati san sika timikiskeh? ");
INSERT INTO nplNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tejwah tikijyowijtokeh nin tlaijyowílistli porke otikmotlanilijkeh, pero nin tlakatl mach itla okichi. ");
INSERT INTO nplNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ijkuakó okili n Jesús: —Techilnamiki ijkuak pewas titlanawatis. ");
INSERT INTO nplNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús okinankili: —De milajka axa nimitsilia: tiyetos nowa kan moitstika Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kemi tlajko tonati owaltleyuak itech neká tlali, iwa asta kemi las tres de tiotlak opanok n tleyuálistli. ");
INSERT INTO nplNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","N tonati okualok, iwa n kortina de n Weyi Tiopa, otlajkotsáyanki. ");
INSERT INTO nplNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ijkuakó Jesús ika chikawak tlájtoli okijto: —Notajtsi Dios, momak niktlalia noespíritu. Ijkuak ijkó okijto, omikki. ");
INSERT INTO nplNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ijkuak n soldado tlanawati romano okitak tlan otlamochijka, okiweyijkachi Dios iwa okijto: —Nin tlakatl milák yekmilajka. ");
INSERT INTO nplNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nochteh non ompa otlamawisojtokah, ijkuak okitakeh nochi tlan otlamochijka owalyayajkeh incha iwa omoelpanwitektiayah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero nochteh akimeh okixmatiah n Jesús, iwa n siwameh non owalayah iwan Jesús desde Galilea, san wejka okoniitokah tlan otlamochijtoka. ");
INSERT INTO nplNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Okatka se kualitlakatl non omonotsaya José, owalewatoka de se altepetl non itoka Arimatea. Ye noiwa tewa otekiwajtitoka kan Sanedrín. ");
INSERT INTO nplNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nin José noiwa okichiaya ijkuak Dios pewas tlanawatis, yika mach okipakti tlan okichijkeh non de Sanedrín. ");
INSERT INTO nplNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ijkuakó n José okitato n Pilato iwa okitlajtlanili ikuerpo n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Satepa okitemowito de kan krus iwa okikemelo ika se tlakemitl, otlanki okikalakito kan se miketékochtli non oichkuatoka itech tetl kan ayamaka okitlalpachoayah. ");
INSERT INTO nplNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Non tonati yomotlatlalijtokah para n sábado non yowalajsia. ");
INSERT INTO nplNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","N siwameh akimeh owalajkeh de Galilea iwan Jesús, oyajkeh okitatoh n miketékochtli, iwa okitakeh kenijki okiwilankeh n kuerpo. ");
INSERT INTO nplNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Iwa ijkuak owalmokopkeh incha, okinmajmankeh ajwiakpajmeh, iwa non sábado omosewijkeh ijkó kemi kijtoa n tlanawátili. ");
INSERT INTO nplNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Semi san kuinal, itech ipewaya n samano, n siwameh oyajkeh kan otooktoka n Jesús, iwa okinwikayah ajwiakpajmeh non yejwah yokichijchijkeh, noiwa oksikimeh siwameh oyayah ínwah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ijkuak n siwameh okalakitoh kan okitookakeh Jesús, n tetl non okitentsaktoka n miketékochtli yokachijka. ");
INSERT INTO nplNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iwa okalakeh, pero mach okajsikeh ikuerpo n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yejwah ayakmó okimatiah tlan kichiwaskeh. San nima ome tlakah non otlakentsotlaniah, okinmonextilijkeh innakastla. ");
INSERT INTO nplNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kemi yejwah satlawel omomojtijkeh, omotlankuaketskeh asta okitelkotoh n tlali ika inmixkuak, pero nonteh tlakah okinmilijkeh: —¿Tleka nonkitemoah kan yomikkeh, Akin yolitok? ");
INSERT INTO nplNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mach nikan ka, Ye yomoyoliti. Xikilnamikikah tlan onomechili ijkuak ok okatka Galilea, ");
INSERT INTO nplNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","noiwa onomechili Ye Akin omochi tlakatl kitemaktiskiah inmak n tlajtlakolejkeh, iwa kikrusifikaroskiah, pero ipan eyi tonati moyolitiskia. ");
INSERT INTO nplNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ijkuakó n siwameh okilnamikeh tlan Jesús okimilijka, ");
INSERT INTO nplNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","iwa ijkuak yomokopatoh de kan miketékochtli, nochi tlan yejwah okitakeh ompa, n siwameh okintlapowijkeh n májtlakteh iwa n se itlamachtijkawah iwa akimeh ompa okatkah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","N siwameh yejwah ninteh: María de Magdala, Juana, María, ina n Jacobo, iwa n oksikimeh siwameh. ");
INSERT INTO nplNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero itlamachtijkawah okimoliayah chamo kuatlapolojtokeh, iwa mach okinneltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero n Pedro okistewak iwa omotlelo kan miketékochtli, iwa ijkuak oontláchixki tlaijtik, sanwel okimitak n tsótsolteh tlakaltechitokeh. Ijkuakó omókopki icha, iwa satlawel okitlajtlachialti tlan otlamochijka. ");
INSERT INTO nplNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Non tonati, ome itlamachtijkawah oyayah para n altepetl non itoka Emaús, non omokawaya kemi májtlaktli iwa n se kilómetro wejka de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yejwah omotlatlapowijtiayah tlan otlamochijka. ");
INSERT INTO nplNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iwa ijkuak yejwah omotlatlapowijtiayah iwa omotlatlajtolkopayah, Jesús inewia omijkuani innawak iwa opé nejnemi ínwah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero maya okitayah, mach okixmatkeh. ");
INSERT INTO nplNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ijkuakó Jesús okintlajtlani: —¿Tlan semi nonkimolijtiwih? ¿Tleka nonmoyolkokoah? ");
INSERT INTO nplNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Se de yejwah, non omonotsaya Cleofas, okinankili: —Nochteh n tlakah kimatokeh tlan otlamochi kan Jerusalén itech ninteh tonatijmeh. ¿Te timokalotijtok ompa iwa amo tikmati? ");
INSERT INTO nplNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ijkuakó Jesús okintlajtlani: —¿Tlan otlamochi? Yejwah okinankilijkeh: —¿Amo otikma tlan okitoktijkeh n Jesús non owalewatoka de Nazaret? Ye se profeta weletini itech nochi tlan okijtoaya iwa tlan okichiwaya inawak Dios iwa innawak n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","¿Amo otikma n tiopixkeh non tlayakantokeh sansikah iwa n totekiwajkawah okitemaktijkeh para makitlaijyowiltikah iwa makimiktikah? ");
INSERT INTO nplNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tejwah otimoyolchikawayah itech porke otikneltokayah Ye akin kimakixtiskia nochi Israel. Pero axa ya kipia eyi tonati ijkó otlamochi. ");
INSERT INTO nplNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iwa axa, sikimeh siwameh non towah mopoah yotechmomojtijkeh, porke yejwah san kuinal oyajkeh kan miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Amo okajsikeh ikuerpo Jesús. Ijkuakó owalajkeh otechilikoh okimitakeh sikimeh ángelteh non okimilijkeh Jesús yolitok. ");
INSERT INTO nplNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Okachi satepa, sikimeh tlakah non towah mopoah oyajkeh kan miketékochtli, iwa okajsitoh kemi n siwameh otechilijkeh, pero mach okitakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ijkuakó Jesús okinmili: —¡Nomejwah yolik nonteajsikamatih, tleka owi nonkineltokah tlan okitemachtijkeh n profetas! ");
INSERT INTO nplNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mach amo omonekia matlaijyowi n Cristo iwa satepa kiweyijkachiwaskiah? ");
INSERT INTO nplNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ijkuakó Jesús opé kinmajsikamatiltia itlajkuilol n Moisés iwa n profetas kan tlapoah de Ye. ");
INSERT INTO nplNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ijkuak okalakitoh Emaús, Jesús omochi kemi ok oyaya okachi tlayakapa. ");
INSERT INTO nplNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero yejwah okitlatlautijkeh mamokawa, iwa okilijkeh: —Ximokawa towah, yopé tleyua. Ijkuakó Jesús okalak itech non altepetl iwa omoka inwah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iwa ijkuak yoewatoka inwah kan motlamajsewiskiah, okónanki n paj, omotlasojkama inawak Dios, iwa okinmajmák makimomajsewikah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ijkuakó okimachilijkeh kemi owalmoixtlajtlapojkeh, iwa okiyekixmatkeh Ye n Jesús, pero Ye san owalpoliwik. ");
INSERT INTO nplNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwa yejwah opé kimoliah: —Satlawel otiyoltlatlayah keman otechtlapowijtiwalaya itech ojtli, noiwa kemi otechilijtiwalaya tlan kijtosneki itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ijkuakó, owalmokeketskeh okonankeh ojtli iwa omokopkeh Jerusalén; ompa okinmajsitoh n májtlaktli iwa n se itlamachtijkawah iwa n oksikimeh non ompa okatkah, ");
INSERT INTO nplNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","iwa yejwah okimilijkeh: —Milák, n Toteko Jesús yomoyoliti, iwa n Simón yokitak. ");
INSERT INTO nplNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Satepa yejwah ome okinmatiltijkeh tlan omochijkeh itech ojtli, iwa okimilijkeh kenijki okiyekixmatkeh n Jesús ijkuak okitlajkotlápanki n paj. ");
INSERT INTO nplNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Itlamachtijkawah okimolijtokah tlan omochijkah, ijkuakó Jesús owalmonexti intlajko. ");
INSERT INTO nplNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yejwah saikpanoa omomojtijkeh iwa okiyejyekoliayah chamo okitlajtlatokah se espíritu. ");
INSERT INTO nplNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús okinmili: —¿Tleka nonmotlajtlachialtiah? ¿Amo nonkineltokah kox Ne? ");
INSERT INTO nplNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xikinmitakah nomawah iwa nokxiwah. Techtelkokah iwa techitakah; porke se espíritu amo kipia inakayo nion iomiowah kemi Ne nikimpia. ");
INSERT INTO nplNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ijkuak Jesús ijkó okinmili, okimititih imawah iwa ikxiwah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero ken opakmiktokah iwa ok omotlajtlachialtijtokah, amo okiyekneltokayah kox Ye n Jesús, yika Jesús okinmili: —¿Nonkipiah itla tlan se kimomajsewis? ");
INSERT INTO nplNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ijkuakó okonmakakeh tlajko michi tléwaki, ");
INSERT INTO nplNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","iwa Ye okiseli iwa okimomajsewi inmixpah. ");
INSERT INTO nplNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Otlanki Jesús okinmili: —Tlan yonimochi ye tlan onomechilijka ijkuak onikatka nomowah. Onomechili nochi tlan ijkuilitok itech itlanawatil Moisés iwa itech intlajkuilolwah n profetas iwa itech salmos, ye tlan nimochiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ijkuakó n Jesús okinmajsikamatilti tlan okijtoaya itlajkuilol Dios, ");
INSERT INTO nplNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","iwa okinmili: —Nochi ni ijkuilitok iwa ijkó Ne onimochi, porke saman nimikiskia, iwa ipan eyi tonati nimoyolitiskia. ");
INSERT INTO nplNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Itech Notoka xikimilikah kenijki moyolpatlaskeh inawak Dios iwa kenijki kintlapojpolwiliskeh de intlajtlakolwah. Xipewakah nika Jerusalén iwa satepa itech nochteh tlalmeh de nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nomejwah ononkitakeh tlan onipanok. ");
INSERT INTO nplNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Techkakikah, Ne nomechaltitlanilis tlan Notajtsi onomechkakiti. Pero xiyetokah nika Jerusalén, asta ijkuak nonkiseliskeh n weletílistli non wits de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Satepa, Jesús okinwík itlamachtijkawah asta Betania. Ompa okinmajkok imawah iwa okintiochi. ");
INSERT INTO nplNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iwa ijkuak okintiochijtoka, omoixkoyanti iwa okiwikakeh ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Niman, ijkuak otlankeh okiweyijkachijkeh, omokopkeh Jerusalén ika miak pakílistli, ");
INSERT INTO nplNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","iwa ixmostla okitlakuikiliayah Dios kan Weyi Tiopa.");
INSERT INTO nplNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ijkuak ayamó opewaya n tlaltíkpaktli, yokatka n Tlájtoli, iwa non Tlájtoli okatka iwan Dios, iwa non Tlájtoli Ye Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nin Tlájtoli yokatka iwan Dios ijkuak okichijchi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ika nin Tlájtoli, okichijchi nochi tlan onka, iwa tla amo por Ye, amitla yetoskia. ");
INSERT INTO nplNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Itech Ye onka Yolílistli, iwa non Yolílistli Ye n Tláwili Akin kintlawilia n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nin Tláwili tlawia kan tleyua, iwa n sentleyuálistli mach weleti kisewia non Tláwili. ");
INSERT INTO nplNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Okatka se tlakatl itoka Juan, non Dios okwaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan owala otetlapowiko de nin Tláwili (Cristo), para ijkó nochteh makineltokakah. ");
INSERT INTO nplNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan amo ye n Tláwili, sanwel otetlapowiko de non Tláwili. ");
INSERT INTO nplNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ye n milajka Tláwili, non kintlawilia nochteh n tlakah itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Neka Tlájtoli okatka itech nin tlaltíkpaktli, iwa Ye okichijchi nochi n tlaltíkpaktli pero n tlaltikpaktlakah mach okixmatkeh akin Ye. ");
INSERT INTO nplNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Owala innawak ichanikniwah, pero yejwah mach okiselijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero akimeh okiselijkeh iwa okineltokakeh, Ye okinkawili mamochiwakah ipilwah Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ninteh amo otlakatkeh kemi tlakatih n tlaltikpaktlakah, yej otlakatkeh kemi tepilwah de Dios porke Ye ijkó okimonekilti matlakatikah inawak. ");
INSERT INTO nplNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Non Tlájtoli omókopki Tlakatl, iwa towa ochanchiwako. Tejwah otiktakeh imawistilis, iwa non mawistílistli kipia non san Ye ikone n Totajtsi Dios, porke otechititi nochi itlasojtlalis iwa nochi tlan ye milajka. ");
INSERT INTO nplNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan otetlapowi de non Tlájtoli. Iwa chikawak otlajto, iwa okijto: —Ye nin tlakatl non ne onomechiliaya. N tlakatl non satepa wits, Ye okachi weyijkatitok ke ne, porke Ye yokatka ijkuak ne ayamó onitlakatia. ");
INSERT INTO nplNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nochi tlan Ye kipia tejwah tikselijtiwitseh, nochipa topah momiakilia itlatiochiwalis. ");
INSERT INTO nplNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés otechmák n tlanawátili, pero por Cristo Jesús owala n tlasojtlálistli iwa tlan milák. ");
INSERT INTO nplNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Amaka tlakatl yokitak Totajtsi Dios, pero Ikone non san Ye se Akin noiwa Dios, Akin nochipa nechonitok iwan Itajtsi, Ye Akin otechixmatiltiko. ");
INSERT INTO nplNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ye ni tlan Juan otlapoaya ijkuak n judíojteh de Jerusalén okintitlankeh sikimeh tiopixkeh iwa levitas makitlajtlanitih n Juan akin ye. ");
INSERT INTO nplNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Okimili tlan milák iwa okimokuiti: —Mach ne ni Cristo. ");
INSERT INTO nplNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ijkuakó yejwah oksepa okitlajtlanijkeh: —¿Akin te? ¿Te n profeta Elías? Juan okinnankili: —Amó, mach ne. —Techili, ¿Te n profeta? Ye okinnankili: —Amó. ");
INSERT INTO nplNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ijkuakó okilijkeh: —¿Akin te kiné? Moneki tikinmiliskeh itla akimeh otechaltitlankeh. ¿Techili, akin te? ");
INSERT INTO nplNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan okinnankili: —Ne non nitetsajtsilia kan tlaltejtéyinki iwa nikijtoa: “Xikmilawakah iojwiu n Toteko” —ijkó kemi okijto n profeta Isaías. ");
INSERT INTO nplNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","N fariseos okintitlankeh sikimeh makitlajtlanitih n Juan ");
INSERT INTO nplNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Tla te amo Ti Cristo, nion ti Elías, nion ti profeta, ¿tleka titlakuaatekia? ");
INSERT INTO nplNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan okinnankili: —Ne nitlakuaatekia ika atl, pero nomowah kajki se Akin nomejwah amo nonkixmatih. ");
INSERT INTO nplNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Milák, Ye satepa wits, iwa ne mach nitlawelkuali kemi para nikkaktojtomas. ");
INSERT INTO nplNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nochi ni otlamochi itech altepetl de Betania, ik nepa lado de n río Jordán, kan Juan otlakuaatekijtoka. ");
INSERT INTO nplNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ipan ok se tonati, Juan okitak n Jesús okinamiktiwalaya iwa okijto: —Xikitakah, Ye Ni Iichkatsi Dios, non kitekixtilis nochi intlajtlakol n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","De Ye onitlajto: “Satepa wits se tlakatl Akin okachi weyijkatitok ke ne, porke Ye yokatka ijkuak ne ayamó onitlakatia.” ");
INSERT INTO nplNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ne nonewia amo onikixmatia. Yika onitlakuaatekijtiwalaya ika atl para n tlakah de Israel makixmatikah Ye. ");
INSERT INTO nplNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan noiwa okijto: —Ne onikitak n Espíritu owaltemok de ilwikak kemi se palomatsi, iwa omotlaliko itech Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne ayamó onikixmatia. Pero Akin onechaltítlanki manitlakuaatekiki ika atl, onechili: “Ijkuak tikitas n Espíritu waltemos iwa motlaliki itech se tlakatl, Ye Akin tlakuaatekis ika n Espíritu Santo.” ");
INSERT INTO nplNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne yonikitak, yika, nomechilia nik Ye Ikone Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ijkuak owalmostlatik Juan oksepa ompa okatka iwa ome itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iwa ijkuak okitak Jesús opanoaya, Juan okijto: —Xikitakah, nin tlakatl Ye Iichkatsi n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ijkuak n ome itlamachtijkawah n Juan okikakeh tlan okijto, oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ijkuakó Jesús oontláchixki ik ikuitlapa, iwa ijkuak okinmitak okiwaltokayah, okintlajtlani: —¿Tlan nonkitemoah? Yejwah okinankilijkeh: —Rabí —non kijtosneki tlamachti—, ¿kan tichanti? ");
INSERT INTO nplNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús okinnankili: —Xiwikih iwa xikitakah. Ijkuakó yejwah oyajkeh iwan Jesús iwa okitakeh kan chanti. Yokatka kemi las kuatro de tiotlak. Ompa omokajkeh iwan Jesús non tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés ikni n Simón Pedro, ye seme de nonteh ome non okikakeh tlan okijto n Juan, oyajkeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés achto okajsik ikni Simón, iwa okili: —Yotikajsikeh n Mesías —noni kijtosneki n Cristo noso non Dios okipéjpenki. ");
INSERT INTO nplNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés okiwík ikni Simón inawak Jesús, iwa ijkuak Jesús okitak okili: —Te ti Simón ipiltsi n Jonás, axa yetos motoka Cefas —kijtosneki Pedro. ");
INSERT INTO nplNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Owalmostlatik Jesús okisentlali yas kan tlali de Galilea. Ompa okitak n Felipe, iwa okili: —Xiwiki nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe owalewatoka itech altepetl de Betsaida. Andrés iwa n Pedro noiwa de ompa. ");
INSERT INTO nplNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe okitemoto n Natanael iwa okili: —Yotikajsikeh n tlakatl non okitene Moisés iwa n profetas itech intlajkuilolwah. Ye n Jesús ipiltsi n José non walewatok de Nazaret. ");
INSERT INTO nplNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael okili: —¿Weletis kisas itla kuali de Nazaret? Felipe okinankili: —Xiwiki, iwa xikitaki. ");
INSERT INTO nplNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ijkuak Jesús okitak Natanael okualajsia, okijto: —Nika wits se tlakatl non milák Israelita, non amo kimati tlakajkayawa. ");
INSERT INTO nplNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ijkuakó Natanael okitlajtlani: —¿Kenomi techixmati? Jesús okinankili: —Ijkuak otikatka itlampa n igoskuawitl, achto de mitsonnotsaskia n Felipe, Ne yonimitsitak. ");
INSERT INTO nplNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael okili: —¡Tlamachti, Tejwatsi Ti Tekone de Dios! ¡Tejwatsi Rey de Israel! ");
INSERT INTO nplNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús okinankili: —¿Techneltoka san por onimitsili onimitsitak itlampa n igoskuawitl? Te tikitas itla okachi wejweyi ke ni. ");
INSERT INTO nplNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús noiwa okijto: —De milajka, de milajka nomechilia, nomejwah nonkitaskeh n ilwikak tlapotok, iwa iángelwah n Dios tlejkoskeh iwa temoskeh notech Akin onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Eyi tonati satepa okatka se ilwitl kan monamiktilo itech se altepetl de Caná itech tlali de Galilea. Iwa imamá n Jesús ompa okatka. ");
INSERT INTO nplNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús iwa itlamachtijkawah noiwa okintlalwijkeh itech non ilwitl. ");
INSERT INTO nplNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Iwa ijkuak otlanki n vino, imamá n Jesús okiliko: —Ayakmó kipiah vino. ");
INSERT INTO nplNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero Jesús okinankili: —¿Siwatl, tleka ne techilia? Ayamó ajsi noora. ");
INSERT INTO nplNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero imamá n Jesús okinmili non tetlamakatokeh: —Xikchiwakah nochi tlan Ye nomechilis. ");
INSERT INTO nplNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ompa okatkah chikwase ajpasteh non ika okipixtokah inmau, iwa okintekitiltiayah ijkuak omomapajpakayah noso omochipawayah n judíos, ijkó kemi kijtoa intlanawatil, itech ninteh ajpasteh oakiah mákuili poali litro atl. ");
INSERT INTO nplNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús okinmili non otlatetekatokah: —Xikintetemitikah ika atl n ajpasteh. Yejwah okintetemitijkeh asta opiaujkeh, ");
INSERT INTO nplNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ijkuakó Jesús okinmili: —Axa xikkixtikah siki iwa xikwikilikah akin kiyakantok n ilwitl. Yejwah ijkó okichijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Akin otlayakantoka itech ilwitl okiyeko n atl, non Jesús okíkopki vino. Ye amo okimatia de kan owala, sanwel okimatiah non otlatetekatokah porke yejwah okikixtijkeh non atl. Ijkuakó n tlayakantok okínotski n novio, ");
INSERT INTO nplNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","iwa okili: —San akin yetos achto kitemaka n kuali vino, iwa ijkuak n tlatlálwilteh satlawel yokonikeh, ijkuakó kinmajmakah ok se vino. Pero te sikin otikkixtiko non okachi kuali vino. ");
INSERT INTO nplNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Itech Caná de Galilea, Jesús okichi non sikinika milagro. Ika non milagro omotak milák weletini, yika itlamachtijkawah okineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Satepa, Jesús iwa imamá, iwa ikniwah iwa itlamachtijkawah owaltemokeh kan altepetl de Capernaúm iwa ompa omokajkeh kanaj kech tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ijkuak yowalajsia n ilwitl de Paskua inmilwiu n judíojteh, Jesús otlejkok Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iwa kan Weyi Tiopa okinmajsito non kinnamakah torojteh, ichkameh iwa palomajtsitsinteh, noiwa ompa okatkah n tomintlapatlakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ijkuak Jesús okimitak, okichijchi se chikote iwa okwalinkixti de kan Weyi Tiopa ika nochi intorojwah iwa inmichkawah. Okintlamochili ipan tlali intomi n tomintlapatlakeh. Okinxitronkopili inmesajwah iwa intomi oxixitikak. ");
INSERT INTO nplNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iwa akimeh okinnamakatokah palomajtsitsinteh okinmili: —¡Xikinkixtikah de nika! ¡Amo xiktiankiskopakah icha n Notajtsi Dios! ");
INSERT INTO nplNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ijkuakó, itlamachtijkawah okilnamikeh itech tiotlájtoli ijkuilitok: “Nikchawatilia mochantsi, kemi se tletl nechtlamia.” ");
INSERT INTO nplNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ijkuakó n judíojteh okitlajtlanijkeh: —¿Tlan weletis technextilis para tikitaskeh kox milák te omitsmakakeh non tekiwajyotl? ");
INSERT INTO nplNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús okinnankili: —Xikxixitinikah nin tiopa, iwa ipan eyi tonati oksepa nikajkokuis. ");
INSERT INTO nplNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ijkuakó n judíojteh okilijkeh: —Ome póali iwa n chikwase xiwitl (46) owejkajkeh okichijchijkeh nin tiopa; ¿Iwa Te tikijtoa ipan eyi tonati tikajkokuis? ");
INSERT INTO nplNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Keman Jesús okitene n tiopa, Ye otlajtojtoka de ikuerpo. ");
INSERT INTO nplNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yika, ijkuak Jesús omoyoliti, itlamachtijkawah okilnamikeh tlan okimilijka, iwa okineltokakeh tlan kijtoa itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ijkuak Jesús okatka Jerusalén itech ilwitl de Paskua, miakeh okineltokakeh ijkuak okimitakeh n wejweyi milagros, non Ye okinchiwaya. ");
INSERT INTO nplNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús mach okinneltokaya, porke yokinmixmatia inyolo. ");
INSERT INTO nplNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Amo omonekia aka makitlapowi tlanón okiyejyekoliayah n tlakah, porke Ye yokimatia tlan okipiayah itech inyolo. ");
INSERT INTO nplNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Okatka se tlakatl fariseo non itoka Nicodemo, ye okatka tlayakanki judío. ");
INSERT INTO nplNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ye okitato n Jesús se yúali, iwa okili: —Tlamachti, kuali tikmatokeh Dios omitsaltítlanki techmachtiki, porke amaka weleti kinchiwa ninteh milagros non Tejwatsi tikinchiwa, tla Dios amo kajki iwa. ");
INSERT INTO nplNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús okili: —De milajka, de milajka nimitsilia, amaka weletis kalakis kan Dios tlanawatia, tla amo oksepa tlakati. ");
INSERT INTO nplNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo okitlajtlani: —¿Kenijki weletis se tlakatl non yomochi teta oksepa tlakatis? ¿Weletis oksepa kalakis ijtik imamá iwa oksepa tlakatis? ");
INSERT INTO nplNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús okinankili: —De milajka, de milajka nimitsilia, akin amo tlakati de atl iwa de Espíritu, amo kalakis kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Akin tlakati itech nin tlaltíkpaktli, ye tlaltikpaktlakatl. Pero akin tlakati itech Espíritu, ya kipias espíritu de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo ximotlajtlachialti por tlan onimitsili: “Nochteh kipiah de tlakatiskeh oksepa.” ");
INSERT INTO nplNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","N ejekatl tlaxojpitsa san kan ik kineki, iwa tikkaki ijkuyuka, pero amo tikmati kan ik walewa nion kan ik yawi. Ijkó noiwa mochiwah akimeh tlakatih itech Espíritu. ");
INSERT INTO nplNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo oksepa okitlajtlani n Jesús: —¿Kenijki weletis mochiwas tlan tikijtoa? ");
INSERT INTO nplNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús okinankili: —¿Amo weyi titlamachti de Israel iwa amo tikkasikamati tlan nimitsilijtok? ");
INSERT INTO nplNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","De milajka, de milajka nimitsilia, tejwah tikijtoah tlan tikmatih, iwa titetlapowiah de tlan otiktakeh. Pero nomejwah mach nonkineltokah tlan tomechiliah. ");
INSERT INTO nplNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne nomechtlapowia ika tlan tlamochiwa itech nin tlaltíkpaktli, iwa amo nonnechneltokah, ¿kenijki nonnechneltokaskeh tla nomechtlapowis de tlan tlamochiwa ilwikak? ");
INSERT INTO nplNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","'Amaka tlejkotika ilwikak, sanwel Ne, Akin onimochi ni tlakatl, non oniwaltemok de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iwa ijkó kemi Moisés okajkok n koatl kan tlaltejtéyinki, ijkó noiwa moneki nechajkokuiskeh Ne Non onimochi ni tlakatl, ");
INSERT INTO nplNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","para nochteh akimeh nechneltokaskeh amo mamoixpolokah, yej mayolitokah nochipa kan ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","'Totajtsi Dios saikpanoa okintlasojtlak n tlaltikpaktlakah, yika okitemakti non sanwel Ye se Ikone, para nochteh akimeh kineltokaskeh amo mamoixpolokah, yej makipiakah se yankuik nemílistli non ayik tlami. ");
INSERT INTO nplNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios amo okwaltítlanki Ikone para kintlajtlakoltis n tlaltikpaktlakah, yej okwaltítlanki para kinmakixtis. ");
INSERT INTO nplNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","'Akin kineltoka Ikone n Totajtsi Dios, amo kitlajtlakoltiskeh. Pero akin amo kineltoka, Dios kitlajtlakoltis porke amo okineltokak itech Itoka non san Ye se Ikone n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Akimeh amo kineltokah Dios, kintlajtlakoltis. Porke ijkuak owala n Tláwili itech nin tlaltíkpaktli, okachi okiwilitakeh n tleyuálistli iwa amo n tláwili. Yika okichiwayah tlan amokuali. ");
INSERT INTO nplNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nochteh akimeh kichiwah tlan amokuali, kikokoliah n Tláwili. Amo mijkuaniah inawak n Tláwili, para amo mamota tlan amokuali kichiwah. ");
INSERT INTO nplNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Keman akimeh kichiwah tlan kuali, mijkuaniah inawak n Tláwili, ijkó mamota kichijtokeh tlan Dios kimonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Okachi satepa, Jesús iwa itlamachtijkawah oyajkeh kan tlali de Judea, iwa ompa omokajkeh kech tonati, iwa otlakuaatekiayah. ");
INSERT INTO nplNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan noiwa otlakuaatekijtoka itech altepetl de Enón, inakastla n altepetl de Salim, porke ompa okatka miak atl. Iwa miakeh tlakah oyayah inawak Juan iwa Ye okinkuaatekiaya. ");
INSERT INTO nplNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Itech nonteh tonatijmeh ayamó okitsakuayah n Juan. ");
INSERT INTO nplNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ijkuakó sikimeh itlamachtijkawah n Juan omotlatlajtolkopkeh iwan se tlakatl judío de kenijki se moyolchipawas inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ijkuakó okilitoh n Juan: —Tlamachti, akin okatka mowa ik nepa lado de n río Jordán, de akin tejwatsi otechtlapowi, noiwa ya tlakuaatekijtok, iwa nochteh yawih inawak. ");
INSERT INTO nplNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan okinnankili: —Se tlakatl amo weletis itla kiselis, tla amo kimaktilia de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nomejwah nomonewiah ononnechkakeh ijkuak onomechili nik ne amo ni Cristo, sanwel onechtitlanke iyakapa. ");
INSERT INTO nplNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kan monamiktilo, n novio mokawa iwan novia, iwa iamigo n novio paki ijkuak kikaki itlajtol n novio. Ijkó kiné, ajsitok nopakilis. ");
INSERT INTO nplNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesús moneki okachi maweyixti, iwa ne manitsikitsintia. ");
INSERT INTO nplNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","'Akin walewatok de ilwikak okachi weyijkatitok. Akin walewatok itech nin tlaltíkpaktli, tlajtoa de tlan onka itech nin tlaltíkpaktli. Pero Akin walewatok de ilwikak Ye okachi weyijkatitok ke nochteh. ");
INSERT INTO nplNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ye kitematiltia tlan yokitak iwa yokikak, pero amaka kineltoka tlan kitematiltia. ");
INSERT INTO nplNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero akin kineltoka tlan Ye kitetlapowia, kinextia nik Dios kijtoa tlan milák. ");
INSERT INTO nplNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Porke Akin Dios okwaltítlanki, tlajtoa de itlajtol Dios, porke Dios amo kitemaka n Espíritu san ajachi. ");
INSERT INTO nplNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","N Teta kitlasojtla Ikone, iwa okimák makinawati nochi. ");
INSERT INTO nplNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Akin kineltoka Ikone Dios, yolitos nochipa kan ilwikak. Pero akin amo kineki kitlakitas Ikone Dios, amo yolitos kan ilwikak yej kiselis ikualanilis Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","N fariseos okimatkeh Jesús okimpiaya okachi itlamachtijkawah iwa okachi okinkuaatekiaya ke Juan. ");
INSERT INTO nplNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero Jesús amaka okikuaateki, yej san itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ijkuak Jesús ijkó okima, okiski de Judea iwa omókopki kan tlali de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iwa kan ik yaskia, okipiaya de panos kan tlali de Samaria. ");
INSERT INTO nplNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ijkó kiné, Jesús okalakito itech se altepetl de Samaria non itoka Sicar, inakastla n tlali non Jacob okiaxkatili ipiltsi José. ");
INSERT INTO nplNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ompa okatka n atékochtli non okiliayah poso de Jacob. Jesús omotlali inakastla n atékochtli porke osotlawatoka de onejnentiwalaya. Okatka kemi tlajko tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ijkuakó se siwatl de Samaria okikixtiko atl, Jesús okili: —Techonmaka siki atl, maniatli. ");
INSERT INTO nplNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Itlamachtijkawah yoyajtokah kan altepetl okikuatoh tlan kikuaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ijkuakó n siwatl de Samaria okinankili: —¿Tleka techtlajtlanilia atl, amo tikmati ne de Samaria iwa tejwatsi judío? N judíos amo monotsah iwa non de Samaria. ");
INSERT INTO nplNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ijkuakó Jesús okinankili: —Tla tikixmatiskia tlan Dios kitetliokolia iwa tikmatiskia akin mitstlajtlanilijtok atl, te monewia tiktlajtlaniliskia atl, iwa Ye mitsmakaskia n atl non ika tiyolitos nochipa. ");
INSERT INTO nplNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","N siwatl okili: —Tlakatl, n atékochtli wejkatla iwa amo tikpia tlan ika tikixtis atl. ¿Kan tikixtis nin atl non ika niyolitos nochipa? ");
INSERT INTO nplNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Towejkatata Jacob otechkajtewili nin atékochtli. Ye, ipilwah iwa iyolkawah nika oatlikeh. ¿Mach te okachi tiweyixtok ke ye? ");
INSERT INTO nplNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús okinankili: —Nochteh akimeh nika atlih, oksepa amikiskeh, ");
INSERT INTO nplNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero akin konis n atl non Ne nikmakas, ayik oksepa amikis. Porke n atl non Ne nikmakas, mochiwas itech ye kemi se améyali, kan mextos n atl non ika yolitos nochipa. ");
INSERT INTO nplNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ijkuakó n siwatl okili: —Tlakatl, techmaka kiné non atl, ijkó ayakmó niamikis, iwa ayakmó oksepa nikixtiki atl nika. ");
INSERT INTO nplNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús okili: —Xio xiknotsati mookich iwa oksepa xiwiki. ");
INSERT INTO nplNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","N siwatl okinankili: —Ne mach nikpia nookich. Jesús okili: —Milák tlan tikijtoa, nik amo tikpia mookich, ");
INSERT INTO nplNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","porke yotikimpapatlak mákuilteh tlakah, iwa non axa iwan tika noiwa amo mookich. Milák tlan tikijtoa. ");
INSERT INTO nplNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","N siwatl okili n Jesús: —Tlakatl, nikita tejwatsi tiprofeta. ");
INSERT INTO nplNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Towejkatatawah okiweyiliayah Dios itech nin tepetl. Pero nomejwah non de Judea nonkijtoah moneki matikweyilikah Dios kan Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús okili: —Siwatl, xikneltoka, ajsiki tonati ijkuak nomejwah weletis nonkiweyijkachiwaskeh Dios maya amo nonwitseh itech nin tepetl nion nonyaskeh Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nomejwah mach nonkixmatih akin nonkiweyijkachiwah, pero tejwah tijudíojteh tikixmatih Akin tikweyijkachiwah, porke n temakixtílistli wits por n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero ajsiki n tonati, iwa ya yoajsiko, ijkuak akimeh de milajka kiweyijkachiwah Dios, kiweyijkachiwah Totajtsi ika inmespíritu iwa ika tlan milák, porke Totajtsi kintemoa akimeh kiweyijkachiwaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios, Ye Espíritu, iwa akimeh kiweyijkachiwah moneki makiweyijkachiwakah ika nochi inyolo iwa de milajka. ");
INSERT INTO nplNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","N siwatl okili: —Ne nikmatok wits n Mesías —non Itoka Cristo—, iwa ijkuak Ye wits, techajsikamatiltis nochi. ");
INSERT INTO nplNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús okinankili: —Ye Ne, Akin axa timotlapowijtok íwa. ");
INSERT INTO nplNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ijkuakó oajsikoh itlamachtijkawah n Jesús iwa omotlajtlachialtijkeh ijkuak okitakeh n Jesús motlapowijtok iwan se siwatl. Pero amaka omixewi kitlajtlanis tlan okinekia non siwatl, noso tlan okimolijtokah. ");
INSERT INTO nplNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ijkuakó n siwatl okikakajte iaxoktsi iwa oyá kan ialtépeu, iwa okinmilito n tlakah: ");
INSERT INTO nplNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Xiwikih, xikitakih se tlakatl non onechili nochi tlan onikchi. ¿Amo Ye n Cristo? ");
INSERT INTO nplNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ijkuakó n tlakah de non altepetl okiskeh okitatoh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ijkuakó itlamachtijkawah okitlatlaujtiayah n Jesús: —Tlamachti, ximotlamasewi. ");
INSERT INTO nplNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Ye okinmili: —Ne nikpia itla tlan nikmomajsewis tlan nomejwah amo nonkixmatih. ");
INSERT INTO nplNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ijkuakó itlamachtijkawah opé motlatlajtlaniah: —¿Chamo aka okwalikili tlan kimomajsewis? ");
INSERT INTO nplNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús okinmili: —Notlakual ye manikchiwa tlan kipaktia Akin onechaltítlanki, iwa maniktlami iteki. ");
INSERT INTO nplNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nomejwah nonkijtoah: “Ok poliwi nawi mestli para mopixkas.” Pero Ne nomechilia: Xiyektlachiakah iwa xikimitakah n tlátookteh, yotlachikawak iwa ya kuali se pixkas. ");
INSERT INTO nplNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Akin tlaoololoa kiselia itlaxtlawil, iwa tlan koololoa, koololoa para ayik tlamis, iwa ijkó akin tlatooka iwa akin pixka, sansikah yolpaktoskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Milák, ijkó kemi kijtoa n tlájtoli: “Se akin tooka, iwa ok se akin pixka.” ");
INSERT INTO nplNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ne onomechtítlanki xipixkatih kan amo onontookakeh. Oksikimeh otookakeh, pero axa nomejwah nompixkaskeh kan yejwah otookakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Miakeh tlakah de Samaria okineltokakeh n Jesús por tlan okinmatilti neká siwatl, ijkuak okinmili: “Ye onechili nochi tlan yonikchi.” ");
INSERT INTO nplNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yika ijkuak n samaritanos owalajkeh inawak Jesús, okitlatlautijkeh mamokawa ínwah. Iwa Ye omoka ompa ome tonati, ");
INSERT INTO nplNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","iwa oksikimeh noiwa okineltokakeh n Cristo Jesús ijkuak okikakeh tlan Ye inewia okimiliaya. ");
INSERT INTO nplNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iwa okiliayah n siwatl: —Axa tikneltokah pero amo san por tlan otikijto, yej porke tonewiah yotikkakeh, iwa axa kuali tikmatokeh milák Ye n Cristo, non kinmakixtis n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ome tonati satepa, Jesús okiski de Samaria iwa oyá Galilea. ");
INSERT INTO nplNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porke inewia n Jesús okijtojka, nion se profeta kitlakitah kan otlakatki. ");
INSERT INTO nplNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ijkuak Jesús okalakito Galilea, n tlakah okiyekselijkeh, porke noiwa oyajkeh Jerusalén itech ilwitl de Paskua, iwa ompa okitakeh nochi tlan Ye okichi itech non ilwitl. ");
INSERT INTO nplNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ijkuakó Jesús oksepa omókopki kan altepetl de Caná de Galilea, kan okikopki vino n atl. Ompa okatka se tekiwa de n rey akin okipiaya se itelpoch non omokokoaya. Ye okatka Capernaúm. ");
INSERT INTO nplNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ijkuak n tekiwa okima Jesús omokopato de Judea iwa okalakiko Galilea, okitato iwa okitlatlaujti mawia icha iwa makipajtiti itelpoch porke yomiktoka. ");
INSERT INTO nplNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ijkuakó Jesús okili: —Nomejwah mach nonnechneltokah, tla amo achto nonkitah se milagro. ");
INSERT INTO nplNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero itekiwa n rey okili: —Tejwatsi, xiwalmuikatiwetsi, amo kichiwa mikis notelpoch. ");
INSERT INTO nplNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ijkuakó Jesús okinankili: —Ximokopa mocha, motelpoch yolitok. N tlakatl okineltokak tlan Jesús okili, iwa omókopki icha. ");
INSERT INTO nplNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ijkuak n tekiwa ya onajsia icha, sikimeh itlakawah okinamikikoh iwa okilijkeh: —Mopiltsi yolitok. ");
INSERT INTO nplNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ijkuakó ye okintlajtlani kemi tlan oras opé kuali momachilia itelpoch, iwa yejwah okilijkeh: —Yala, la una de tiotlak, okikajka n totonik. ");
INSERT INTO nplNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ijkuakó n teta okilnamik ipan non ora Jesús okili: “Motelpoch yolitok.” Ye iwa nochi ichantlakawah okineltokakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ika ni, Jesús okinchi ome milagros, ijkuak owalmókopki de Judea iwa okalakiko Galilea. ");
INSERT INTO nplNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Satepa Jesús otlejkok Jerusalén itech tonatijmeh ijkuak n judíojteh okichiwayah se ilwitl. ");
INSERT INTO nplNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ompa Jerusalén kanik kiliah kaltentli de ichkameh, okatka se tanke non itech tlájtoli hebreo monotsa Betesda. Nin tanke okimpiaya mákuili portalteh. ");
INSERT INTO nplNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ompa owejwetokah miakeh kokoxkeh: non amo otlachiayah, koxomeh iwa non oikximijmiktokah, yejwah okichiayah mamolini n atl. ");
INSERT INTO nplNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","San kualchiwa se ángel owaltemoaya iwa okoliniaya n atl, iwa san akin achto omopolakiaya, opajtia. ");
INSERT INTO nplNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ompa owetoka se tlakatl non omokokoaya sempóali iwa n káxtoli iwa n eyi xiwitl (38). ");
INSERT INTO nplNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ijkuak Jesús okitak n kókoxki ompa wetok, okajsikama yowejka omokokoaya, iwa okili: —¿Tikneki tipajtis? ");
INSERT INTO nplNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","N kókoxki okinankili: —Tejwatsi, amo nikpia akin nechapolakis ijtik tanke ijkuak molinia n atl. Iwa ijkuak ya nimopolakiti, ok se achto mopolakia. ");
INSERT INTO nplNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús okili: —Ximewa, xikajkokui mopetl iwa xinejnemi. ");
INSERT INTO nplNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","San nima non tlakatl owalpajtik, okajkok ipetl iwa onéjnenki. Non tonati okatka sábado ijkuak mosewia n judíos. ");
INSERT INTO nplNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pero n tlayakankeh judíojteh okilijkeh n tlakatl non opajtik: —Axa sábado, mach weletis tikmamas mopetl. ");
INSERT INTO nplNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","N tlakatl okinnankili: —Akin onechpajti inewia onechili: “Xikajkokui mopetl iwa xiajti.” ");
INSERT INTO nplNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ijkuakó okitlajtlanijkeh: —¿Akin omitsili: “Xikajkokui mopetl iwa xiajti”? ");
INSERT INTO nplNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero n tlakatl non opajtik mach okimatia akin okipajti, porke ompa okatkah miakeh tlakah iwa n Jesús ayakmó ompa okatka. ");
INSERT INTO nplNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Okachi satepa Jesús okajsito n tlakatl kan Weyi Tiopa iwa okili: —Techkaki, ken axa yotipajtik, ayakmó oksepa xitlajtlakolchiwa, porke weletis mitsajsis ok se kokólistli okachi temojti. ");
INSERT INTO nplNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","N tlakatl oyá, iwa okinmatiltito n tlayakankeh judíojteh Jesús okipajti. ");
INSERT INTO nplNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yika, n tlayakankeh judíojteh okitotojtokayah n Jesús porke okinchiwaya ninteh milagros itech sábado. ");
INSERT INTO nplNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús okinmili: —Notajtsi nochipa tekiti, yika Ne noiwa nitekiti. ");
INSERT INTO nplNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yika, n tlayakankeh judíojteh okachi okinekiah kimiktiskeh, iwa amo san por okixpanawiaya n sábado yej porke noiwa okijtoaya Dios Itajtsi, kemi yetoskia Ye noiwa Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús noiwa okinmili: —De milajka, de milajka nomechilia: Ne Akin Ni Tekone amo niweleti nikchiwa itla, san Ne noselti, yej nikchiwa tlan nikita kichiwa Notajtsi. Porke nochi tlan Notajtsi kichiwa Ne noiwa nikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iwa Notajtsi nechtlasojtla iwa nechititia nochi tlan Ye kichiwa, iwa okachi wejweyi milagros nechnextilis para nomechtlajtlachialtis. ");
INSERT INTO nplNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porke ijkó kemi Notajtsi Dios kinyolitia non yomikkeh, ijkó noiwa ikone n Dios kinmaka yolílistli akimeh Ye kineki kinmakas. ");
INSERT INTO nplNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Porke Notajtsi amaka kiyolkuitia, yej onechmák nochi itlanawatil para Ne maniteyolkuiti, ");
INSERT INTO nplNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","para nochteh n tlaltikpaktlakah makiweyijkachiwakah Ikone Dios ijkó kemi kiweyijkachiwah Dios. Akin amo kiweyijkachiwa n tekone, amo kiweyijkachiwa Dios akin okualtítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","'De milajka, de milajka nomechilia: akin kikaki notlajtol iwa kineltoka Notajtsi Dios Akin onechaltítlanki, ye kipias yolílistli non ayik tlami iwa amaka kitlajtlakoltis. Kijtosneki yomiktoka pero axa ya kipia nemílistli non ayik tlami. ");
INSERT INTO nplNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","De milajka, de milajka nomechilia: ajsitiwits n ora, iwa yoajsiko, ijkuak non yomikkeh nechkakiskeh Ne Akin Ni Tekone de Dios, iwa akimeh nechkakiskeh yolitoskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ijkó kemi Notajtsi inewia kipia yolílistli, Ne Ikone noiwa onechmák weletílistli para maniktemaka yolílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Noiwa onechmák tekiwájyotl para manitetlajtlakolti, Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo ximotlajtlachialtikah, porke ajsiki n ora ijkuak nochteh non yomikkeh iwa tooktokeh kikakiskeh itlajtol. ");
INSERT INTO nplNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Iwa kisaskeh de inmiketekochwah. Akimeh okichijkeh tlan kuali, moyolitiskeh iwa mach ok ayik mikiskeh, iwa akimeh okichijkeh tlan amokuali, moyolitiskeh para kinyolkuitiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","'Ne amitla weleti nikchiwa san tlan notech kisa. Ne nitetlajtlakoltia ijkó kemi Notajtsi Dios nechnawatia, iwa nitetlajtlakoltia kemi moneki, porke mach nikchiwa san tlan ne nikneki, yej nikchiwa tlan kineki Notajtsi Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tla nomechiliskia san tlan kisa itech ne, tlan nikijtoskia amitla ipati. ");
INSERT INTO nplNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero onka ok se akin tlajtoa de Ne, iwa nikmatok nik tlan Ye kijtoa de Ne milák. ");
INSERT INTO nplNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nomejwah ononkintitlankeh sikimeh tlakah makitlajtlanitih n Juan akin ye, iwa ye okijto tlan milák de Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero mach moneki aka tlakatl para makimatikah akin Ne; yej san nomechilnamiktia tlan Juan okijto para weletis nonnechneltokaskeh iwa ijkó ximomakixtikah. ");
INSERT INTO nplNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan okatka kemi se tláwili non oxotlatoka iwa otlawia, iwa nomejwah ononpakeh san kech tonati ika itlawil. ");
INSERT INTO nplNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero Ne nikpia ok se tlájtoli non okachi weyi ke non de Juan: Nochi tlan Ne nikchiwa ye tlan Notajtsi onechnawati manikchiwa, iwa nochi tlan nikchiwa kiteititia nik Notajtsi onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Notajtsi Akin onechaltítlanki, noiwa kiteititia Akin Ne. Nomejwah ayik nonkikaktikateh itlajtol, nion nonkiitikateh, ");
INSERT INTO nplNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nion itlajtol amo onkalaki itech nomoyolo, porke amo nontlaneltokah Itech Akin Notajtsi Dios okwaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nomejwah nonkimomachtiah itlajkuilol Dios porke nonkiyejyekoliah nomechmakas yolílistli non áyik tlami. Pero itlajkuilol Dios ompa tlajtoa de Ne, ");
INSERT INTO nplNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","iwa maya ijkó, nomejwah amo nonkinekih nonwitseh nonawak para nonyolitoskeh nochipa. ");
INSERT INTO nplNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","'Ne mach nikselia manechweyilikah n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Porke Ne nomechixmatok iwa nikmati amo nonkipiah itlasojtlalis Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne oniwala itech itoka Notajtsi iwa nomejwah amo nonnechseliah. Pero tla aka ok se wits itech ye itoka, nomejwah nonkiseliskiah. ");
INSERT INTO nplNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Kenijki weletis nontlaneltokaskeh, tla san nonkitemojtinemih manomechweyilikah oksikimeh iwa amo nonkitemoah n weyílistli non kitemaka Akin sanwel Ye Dios? ");
INSERT INTO nplNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo xikmolikah Ne nomechteilis inawak Notajtsi, yej onka se akin nomechteilis, ye itlanawatil Moisés, akin nomejwah itech nonmoyolchikajtokeh. ");
INSERT INTO nplNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Porke tla milák nonkineltokaskiah tlan okijto n Moisés, noiwa Ne nonnechneltokaskiah, porke ye otlajkuilo de Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tla amo nonkineltokah tlan Moisés okijkuilo, ¿kenijki nonkineltokaskeh tlan Ne nomechilia? ");
INSERT INTO nplNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Satepa, Jesús oyá ik nepa lado de lago de Galilea non noiwa itoka Tiberias. ");
INSERT INTO nplNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iwa miakeh tlakah oyayah iwan Jesús, porke okinmitayah n milagros non Ye okinchiwaya keman okimpajtiaya n kokoxkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Otlanki Jesús otlejkok itech se tepetl iwa ompa omotlali iwan itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ijkuakó yowalajsia n paskua, inmilwiu n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ijkuak Jesús oontláchixki iwa okitak miakeh tlakah omoololojtokah, okili n Felipe: —¿Kani tikkoatiweh paj para tikintlakualtiskeh ninteh tlakah? ");
INSERT INTO nplNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ijkó okili n Felipe san para kitas tlan kijtos, porke Jesús yokimatia tlan kichiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ijkuakó Felipe okinankili: —¡Ome siento denariojtomi paj, amo kajxilis tikinmajmakaskeh ajachitsi! ");
INSERT INTO nplNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés ikni n Simón Pedro, akin noiwa imomachti okilito n Jesús: ");
INSERT INTO nplNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Nika kajki se telpotsintli, non kimpixtok mákuili pameh de sebada iwa ome michimeh, pero ¿kan matechajxili? ");
INSERT INTO nplNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ijkuakó Jesús okijto: —Xikinmilikah nochteh mamotlajtlalikah. Itech non lojar okatka xiujyo, iwa omotlajtlalijkeh kemi mákuili mil tlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ijkuakó Jesús okinmónanki n pameh iwa omotlasojkama inawak Dios, otlanki okinmák itlamachtijkawah, iwa yejwah opé kinxejxeliliah nochteh non ompa oewatokah. Noiwa ijkó okichi iwan michimeh, iwa nochteh omotlamajsewijkeh iwa kuali oijixwikeh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ijkuak yoijixwikeh, Jesús okinmili itlamachtijkawah: —Xikoololokah nochi tlan omoka amo san maawilti. ");
INSERT INTO nplNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Okoololojkeh tlan ayakmó okikuajkeh ika mákuili paj de sebada, iwa okintemitijkeh májtlaktli iwa ome chikimeh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ijkuak n tlakah okitakeh n milagro non Jesús okichi, okijtojkeh: —De milajka, Ye ni n profeta non saman walaskia itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero Jesús okinmitak yejwah omochijchikajtokah kiwikaskeh para mayeto Inrey. Yika, oksepa oyá iwa otlejkok ikpak tepetl san Ye iselti. ");
INSERT INTO nplNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ijkuak opé tleyua, itlamachtijkawah otemokeh okichiatoh itempa n lago de Galilea. ");
INSERT INTO nplNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Otlejkokeh itech se barka iwa opé kikojchalwiah n lago para ajsitiweh kan altepetl de Capernaúm. Ijkuakó yotleyuak, Jesús ayamó okwalinmajsia. ");
INSERT INTO nplNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ijkuakó se ejekatl chikaktik opé kitlatlamotla n atl. ");
INSERT INTO nplNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iwa yoyayah kemi se mákuili noso chikwase kilómetro itech atl. Okitakeh n Jesús nejnentiwits ixko atl iwa yokualinmasia. Ijkuakó yejwah omomojtijkeh, ");
INSERT INTO nplNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","pero Ye okinmili: —Amo ximomojtikah, Ne ni Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ijkuakó yejwah opakeh iwa okitlejkoltijkeh itech barka. Iwa san nima n barka oajsito itech tlali kan oyayah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Owalmostlatik, nochteh n tlakah non omokajkeh ik nepa lado de n lago, okitakeh okatka san se barka, iwa itlamachtijkawah n Jesús oyajkeh inselti, iwa Jesús amo oya inwah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Satepa, oksikimeh barkas non owalaya de Tiberias okalakikoh kan ik okikuajkeh n paj, iwa Jesús omotlasojkamah inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yika, ijkuak n tlakah okitakeh Jesús iwa itlamachtijkawah ayakmó ompa okatkah, otletlejkokeh itech nonteh barkas iwa oyajkeh Capernaúm okitemoto n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ijkuak okajsitoh n Jesús ik nepa lado de n lago, okitlajtlanijkeh: —Tlamachti, ¿kemania otikalakiko nika? ");
INSERT INTO nplNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús okinmili: —De milajka, de milajka nomechilia, nomejwah nonnechtemoah amo por ononkajsikamatkeh tlan kijtosneki n milagro non onikchi, yej porke onomechtlakualti asta kan ononmijixwikeh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amo xitekitikah por n tlákuali non kimati tlami, yej xitekitikah por n tlákuali non ayik tlami iwa kitemaka yolílistli. Non tlákuali Ne nomechmakas porke sanwel Ne Dios onechpéjpenki para nin tekitl. ");
INSERT INTO nplNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ijkuakó yejwah okitlajtlanijkeh: —¿Tlan tekitl moneki matikchiwakah para tiktekitiliskeh Dios? ");
INSERT INTO nplNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús okinnankili: —Ye ni tlan Dios okichi, iwa manechneltokakah Ne Akin Ye okualtítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yejwah okilijkeh: —¿Tlan milagro techititis para matiktakah iwa timitsneltokaskeh? ¿Tlan weletis tikchiwas? ");
INSERT INTO nplNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Towejkatatawah okikuajkeh n paj non itoka maná kan tlaltejtéyinki, ijkó kemi kijtoa itlajkuilol Dios: “Paj de ilwikak okinmák makikuakah.” ");
INSERT INTO nplNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús okinmili: —De milajka, de milajka nomechilia: Moisés amo onomechmák n paj non owaltemok de ilwikak, yej Notajtsi Dios Akin nomechmaka n de milajka paj de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porke n paj non Dios kitemaka ye non waltemoa de ilwikak iwa kinmaka yolílistli n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ijkuakó okilijkeh: —Tejwatsi, techmaka sanwel non paj. ");
INSERT INTO nplNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús okinmili: —Non paj ye Ne, akin niktemaka yolílistli. Akin wits nonawak mach ok ayik xitlatlas, iwa akin nechneltoka ayik amikis. ");
INSERT INTO nplNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero ijkó kemi yonomechili, maya yononnechitakeh amo nonnechneltokah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochi tlan Notajtsi nechmaka wits nonawak, iwa akimeh witseh nonawak, Ne nikinselis. ");
INSERT INTO nplNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porke Ne amo oniwaltemok de ilwikak para nikchiwas tlan Ne nechpaktia, yej para nikchiwas tlan kipaktia Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iwa Notajtsi Akin onechaltítlanki, amo kineki manikpolo nion se de nochteh akimeh onechinmák, yej kineki manikinyoliti itech nekateh iksemi tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Porke tlan Notajtsi Dios kineki Ye ni: nochteh akimeh kitaskeh Ikone Dios iwa kineltokah, maya mamikikah moyolitiskeh porke Ne nikinyolitis itech n iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ijkuakó n judíojteh opé moichtakatlapowiah de Jesús porke okijto: “Ne nipaj non owaltemok de ilwikak.” ");
INSERT INTO nplNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iwa okijtoayah: —¿Amo ye nin Jesús, ipiltsi n José? Tejwah tikinmixmatih ipapá iwa imamá. ¿Kenijki kijtoa owaltemok de ilwikak? ");
INSERT INTO nplNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús okinmili: —Ayakmó ximokualankatlapowikah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Amaka weletis wits nonawak, tla amo kinotsa Notajtsi Akin onechaltítlanki, iwa Ne nikyolitis itech n iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Itech intlajkuilol n profetas ijkuilitok: “Dios kinmachtis nochteh.” Yika, nochteh akimeh kikakih Notajtsi iwa kajsikamatih tlan kinmachtia, witseh nonawak. ");
INSERT INTO nplNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","'Amaka yokitak Notajtsi, sanwel Ne Akin niwalewatok de Dios, Ne yonikitak. ");
INSERT INTO nplNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","De milajka, de milajka nomechilia: Akin Ne nechneltoka kipia yolílistli non ayik tlami. ");
INSERT INTO nplNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne ni paj non kitemaka yolílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nomowejkatatawah kan tlaltejtéyinki okikuajkeh n paj non itoka maná, iwa maya okikuajkeh non paj omikeh. ");
INSERT INTO nplNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero Ye nin paj non waltemoa de ilwikak, akin kikuas non paj, ayik mikis. ");
INSERT INTO nplNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne nonewia non paj yolitok non owaltemok de ilwikak. Tla aka kikua non paj, nochipa yolitos. Nokuerpo ye non paj non niktemaka para mayolitokah nochipa n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ijkuakó n judíojteh opé motlatlajtolkopah iwa okimoliayah: —¿Kenomi weletis techmakas matikkuakah ikuerpo? ");
INSERT INTO nplNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús okinmili: —De milajka, de milajka nomechilia: Tla nomejwah amo nonkikuaskeh nokuerpo, Ne non onimochi ni tlakatl, iwa tla amo nonkoniskeh noesso, amo kipiah yolílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Akin kikua nokuerpo iwa koni noesso kipias yolílistli non ayik tlamis, iwa Ne nikyolitis itech iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porke nokuerpo de milajka tlákuali, iwa noesso de milajka tlaonílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Akin kikua nokuerpo iwa koni noesso, moseitilijtok nowa iwa Ne íwa. ");
INSERT INTO nplNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Notajtsi Akin onechaltítlanki, yolitok, iwa Ne niyolitok por Ye, ijkó noiwa akin kimomajsewis nokueqrpo, yolitos por Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ne Ni paj non owaltemok de ilwikak, pero nin paj amo kemi n maná non okikuajkeh nomotatawah iwa satepa omijmikeh. Akin kikuas nin paj, nochipa yolitos. ");
INSERT INTO nplNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ijkí okitemachti kan se sinagoga kan altepetl de Capernaúm. ");
INSERT INTO nplNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ijkuak ijkó okikakeh itlamachtijkawah n Jesús, miakeh okijtojkeh: —Nin tlamachtílistli kema chikawak, ¿akin weletis kajsikamatis? ");
INSERT INTO nplNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús okimatia itlamachtijkawah omoichtakatlapowiayah ika tlan okijto, iwa okinmili: —¿Ye ni nomechkuejsoa? ");
INSERT INTO nplNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tlan nonkimoliah tla nonnechitaskiah Ne Non onimochi ni tlakatl nitlejkos ilwikak kan achto onikatka? ");
INSERT INTO nplNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","N espíritu kimaka yolílistli se kuerpo. N kuerpo mach itla ipati tla amo kipia espíritu. N tlájtolteh non Ne yonomechili wits de n espíritu iwa kimaka yolílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero miálmasteh nomejwah akimeh amo nontlaneltokah. Jesús ijkó okijto porke desde achto yokimatia akimeh amo kineltokaskiah iwa akin kitemaktiskia. ");
INSERT INTO nplNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iwa okijto: —Yika, yonomechili amaka weletis wits nonawak, tla Notajtsi amo kitekawilia. ");
INSERT INTO nplNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ika noni, miakeh itlamachtijkawah n Jesús okikakajtejkeh iwa ayakmó onemiah íwa. ");
INSERT INTO nplNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ijkuakó Jesús okintlajtlani n májtlakteh iwa ome itlamachtijkawah: —¿Nomejwah noiwa nonkinekih non nechkakajtewaskeh? ");
INSERT INTO nplNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro okinankili: —Noteko, ¿Akin ok se íwa tiaskeh? Sanwel Tejwatsi tikpia non tlájtoli non kitemaka yolílistli non ayik tlami. ");
INSERT INTO nplNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tejwah tikneltokah iwa tikmatih Tejwatsi n Yolchipawak de Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ijkuakó Jesús okinnankili: —Ne onomechpéjpenki nomejwah n májtlakteh iwan ome. Pero seme de nomejwah ye n diablo. ");
INSERT INTO nplNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ijkuak ijkó okijto, Jesús otlajtoaya de Judas Iscariote ipiltsi n Simón, porke ye kitemaktiskia maya okatka seme de n májtlakteh iwa ome itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Satepa ijkuak ijkó yotlamochi, Jesús onemia itech tlali de Galilea, mach okinekia nemis itech altepetl de Judea, porke ompa sikimeh judíojteh okinekiah kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero kemi yowalajsia inmilwiu n judíojteh non itoka ilwitl de n akákalteh, ");
INSERT INTO nplNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ikniwah n Jesús okilijkeh: —Amo ximokawa nika, xio kan tlali de Judea, ijkó motlamachtijkawah, kitaskeh tlan tikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porke akin kineki makixmatikah, mach kichiwa itla san ichtaka. Yej moneki xikinchiwa milagros inmixpa nochteh n tlakah para ijkó nochteh makitakah tlan tikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ikniwah n Jesús ijkó okiliayah, porke nion yejwah amo okineltokayah. ");
INSERT INTO nplNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yika Jesús okinmili: —Ayamó walajsi noora para nias ompa, pero nomejwah san tlan oras weletis nonyaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","N tlaltikpaktlakah mach weletis nomechkokoliskeh, pero Ne nechkokoliah, porke Ne nikinmilia yejwah kichiwah tlan amo kuali. ");
INSERT INTO nplNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nomejwah xitlejkokah ilwitl. Ne amo nitlejkos porke ayamó walajsi noora. ");
INSERT INTO nplNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ye ijkó okinmili iwa omoka Galilea. ");
INSERT INTO nplNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Satepa, ikniwah n Jesús otlejkokeh ilwitl. Ye noiwa otlejkok pero san ichtaka. ");
INSERT INTO nplNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Itech ilwitl de Jerusalén, n tlayakankeh judíojteh okitemoayah n Jesús iwa omotlajtlaniayah: —¿Kan ik nentinemi non tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iwa miakeh omoichtakatlapowiayah de Ye. Sikimeh okijtoayah: “Jesús, ye kuali tlakatl.” Pero oksikimeh okijtoayah: “Amó, porke san kinkajkayawa n tlakah.” ");
INSERT INTO nplNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero amaka omixewiaya tlajtos de Ye inmiixpa n tlayakankeh judíojteh, porke okinmawiliayah. ");
INSERT INTO nplNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ijkuak yoyaya tlajko ilwitl, Jesús otlejkok kan Weyi Tiopa iwa opé tlamachtia. ");
INSERT INTO nplNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","N tlayakankeh judíojteh san omotlajtlachialtiayah iwa okijtoayah: —¿Kenomi nin tlakatl satlawel kimati miak, iwa amo omixtlamachti? ");
INSERT INTO nplNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús okinnankili: —Notemachtilis amo Ne noaxka, yej de Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Akin kineki kichiwas tlan Dios kimonekiltia, kajsikamatis kox notemachtilis walewatok de Dios, noso nikijtoa san tlan Ne nikijtoa. ");
INSERT INTO nplNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Akin tlajtoa san tlan ye itlajtol, kichiwa san para makiyektenewakah n tlakah. Pero Ne nikneki nikweyijkachiwas Akin onechaltítlanki, yika nikijtoa tlan milák iwa ayik nitlakajkayawa. ");
INSERT INTO nplNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","'Moisés onomechmák n tlanawátili, iwa nion se de nomejwah amo kichiwa tlan kijtoa non tlanawátili. ¿Tleka kiné nonkinekih nonnechmiktiskeh? ");
INSERT INTO nplNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","N tlakah okinankilijkeh: —Te tikpia se demonio; ¿akin kineki mitsmiktis? ");
INSERT INTO nplNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús okinnankili: —Se kuali tekitl onikchi itech sábado iwa nochteh nomejwah nonmotlajtlachaltiah. ");
INSERT INTO nplNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés onomechnawati ximosirkunsidarokah, pero non tlanawátili amo walewatok de Moisés, yej de nomowejkatatawah, iwa nomejwah nonkisirkunsidaroah se konetl maya mayeto sábado ijkuak amo para nontekitiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ijkó kiné, nomejwah nonkitlakitah itlanawatil Moisés, iwa nonkisirkunsidaroah se konetl maski mayeto sábado, porke ijkuakó ochikometik de otlákatki, ¿tleka kiné nonkualanih nowa por onikpajti se tlakatl itech sábado? ");
INSERT INTO nplNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amo san nima xiktlajtlakoltikah se tlakatl san por ijkó nonkimoliah, yej xiktlajtlakoltikah kemi moneki. ");
INSERT INTO nplNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ijkuakó sikimeh tlakah de Jerusalén okimoliayah: —¿Amo nin tlakatl kitemojtinemih para kimiktiskeh? ");
INSERT INTO nplNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Xikitakah!, tlajtojtok teixpa iwa amitla kiliah ¿chamo totlayakanwah yokajsikamatkeh nin tlakatl Ye n Cristo? ");
INSERT INTO nplNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero tejwah kuali tikmatih kan walewatok nin tlakatl. Pero ijkuak wits n Cristo, amaka kimatis de kan wits. ");
INSERT INTO nplNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús otlamachtijtoka itech Weyi Tiopa, iwa ijkuak okikak tlan okijtoayah, okijto chikawak: —¡Nomejwah nonkijtoah nonnechixmatih iwa nonkimatih de kan niwalewatok! Pero amo oniwala san por Ne oniknek, yej onechaltítlanki Akin nomejwah amo nonkixmatih. Ye yekmilajka. ");
INSERT INTO nplNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne nikixmati porke inawak oniwala, iwa Ye onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ijkuakó n tlayakankeh judíojteh okinekiah kikitskiskeh n Jesús. Pero amaka omixewi okikitski, porke ayamó oajsia iora para kikitskiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero miakeh okineltokakeh, iwa okijtoayah: —Ijkuak wits n Cristo, ¿kox kinchiwas okachi wejweyi milagros ke nin tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","N fariseos okikakeh tlan okijtoayah n tlakah de Jesús, yika omotlatlalwijkeh iwa n tiopixkeh non tlayakantokeh, iwa okintitlankeh non otlamokuitlawiayah kan Weyi Tiopa makikitskitih n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ijkuakó Jesús okijto: —Ne niyetos nomowah sa kanaj kech tonati, tlamis oksepa nimokopas inawak Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nomejwah nonnechtemoskeh, pero amo nonnechajsiskeh, porke mach nonweletiskeh nonyaskeh kan Ne nias. ");
INSERT INTO nplNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ijkuakó n tlayakankeh judíojteh omotlajtlaniayah: —¿Kan ik yas nin tlakatl, kan amo weletis tikajsiskeh? ¿Chamo kinmachtitih n israelitas non xitintokeh itech tlali de Grecia, noso innewiah n tlakah de Grecia kinmachtiti? ");
INSERT INTO nplNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tlan kijtosneki: “Nonnechtemoskeh pero mach nonnechajsiskeh, porke amo weletis nonyaskeh kan Ne nio”? ");
INSERT INTO nplNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Itech iksemi tonati, de non weyi ilwitl, Jesús omóketski iwa ika chikawak tlájtoli okijto: —Tla aka amiki, mawiki nonawak iwa maatli. ");
INSERT INTO nplNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kemi kijtoa itlajkuilol Dios, akin nechneltokas, itech iyolo mextos atl non kitemaka yolílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús otlajtojtoka de n Espíritu non kiseliskiah akimeh kineltokaskiah. Pero n Espíritu ayamó owaltemoaya porke Jesús ayamó okiseliaya weyílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ijkuakó sikimeh ijkuak okinkakeh ninteh tlájtolteh, okijtojkeh: —De milajka, nin tlakatl Ye n profeta. ");
INSERT INTO nplNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iwa oksikimeh okijtoayah: —Ye ni n Cristo. Pero oksikimeh okijtoayah: —¿De Galilea weletis wits n Cristo? ");
INSERT INTO nplNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Itlajkuilol Dios kijtoa Cristo walewatos de n Rey David, de Belén kan ochantitoka n David. ");
INSERT INTO nplNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ijkó, n tlakah omoxexelojkeh porke sikimeh amo okineltokayah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sikimeh okinekiah kikitskiskeh, pero amaka omixewi okikitski. ");
INSERT INTO nplNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","N tlamokuitlawijkeh de n Weyi Tiopa, oyajkeh innawak n fariseos iwa innawak tiopixkeh non tlayakantokeh, iwa ninteh okintlajtlanijkeh: —¿Tleka amo ononkualikakeh? ");
INSERT INTO nplNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","N tlamokuitlawijkeh otlanankilijkeh: —¡Nion se tlakatl ayik ijkó tlajtoa kemi nin tlakatl! ");
INSERT INTO nplNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ijkuakó n fariseos okinmilijkeh: —¿Noiwa nomejwah ononkimokawilijkeh manomechkajkayawa? ");
INSERT INTO nplNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Kox aka totlanawati noso aka fariseo okineltokak non tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Akimeh kineltokah non tlakatl, amo kixmati itlanawatil Moisés, yika Dios kintlaijyowíltis. ");
INSERT INTO nplNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo tewa iwan fariseos, akin se yúali okitato n Jesús, okinmili: ");
INSERT INTO nplNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Totlanawatilis amo techkawilia matiktlajtlakoltikah se tlakatl, tla amo achto tikkakih tlan ika kiteiliah. ");
INSERT INTO nplNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ijkuakó okinankilijkeh: —¿Te noiwa de Galilea? Xikmoyekmachti itlajkuilol Dios iwa tikitas itech Galilea ayik kistika nion se profeta. ");
INSERT INTO nplNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Iwa nochteh oyayajkeh inchajcha. ");
INSERT INTO nplNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús oyá kan olivostepetl. ");
INSERT INTO nplNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ijkuak owaltláneski, oksepa oyá kan Weyi Tiopa. Omijkuanijkeh inawak, iwa Ye omotlali iwa opé kinmachtia. ");
INSERT INTO nplNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ijkuak Jesús otlamachtijtoka, n tlamachtijkeh de itlanawatil Moisés iwa n fariseos okualikilijkeh se siwatl non okajsitoh iwan ok se tlakatl non amo iokich itech tlajtlákoli. Yejwah okiketsatoh tlatlajkotiah, ");
INSERT INTO nplNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","iwa okilijkeh n Jesús: —Tlamachti, nin siwatl otikajsitoh itech tlajtlákoli. ");
INSERT INTO nplNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Itlanawatil Moisés tlanawatia matikinmiktikah ika tetl akimeh ijkó kichiwah. Tejwatsi, ¿tlan tikijtoa? ");
INSERT INTO nplNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yejwah ijkó okilijkeh para kitaskeh tlan kichiwas, iwa ijkó kipiaskeh tlan ika kiteiliskeh. Ijkuakó Jesús omotolo iwa opé tlajkuiloa ixko tlali ika imajpil. ");
INSERT INTO nplNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero kemi okachi okitlatlajtlaniayah, Ye omoyékketski iwa okijto: —Tla aka de nomejwah amo kipia tlajtlákoli, ye achto makimotla ika tetl. ");
INSERT INTO nplNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús oksepa omotolo iwa ok otlajkuilo ixko tlali. ");
INSERT INTO nplNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Keman okikakeh tlan Jesús okinmili, se por se oyayajtiajkeh. Achto oyayajkeh non okachi ya wewemeh, iwa ijkuak nochteh yoyayajkeh, sa Jesús omoka iselti iwan siwatl. ");
INSERT INTO nplNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ijkuakó, Jesús omoyékketski iwa kemi ayakmaka okitak, okitlajtlani n siwatl: —Siwatl, ¿kanin kateh non omitsteiliayah? ¿Amaka omitstlajtlakolti? ");
INSERT INTO nplNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","N siwatl okili: —Nion se de yejwah Noteko. Ijkuakó Jesús okili: —Nion Ne omitstlajtdlakolti. Xio, iwa ayakmó oksepa xitlajtlakolchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús oksepa okintlapowi iwa okinmili: —Ne nitláwili itech nin tlaltíkpaktli. Akin wits nonawak, kipias n tláwili non kimakas nemílistli iwa ayik nemis kan tleyua. ");
INSERT INTO nplNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","N fariseos okilijkeh: —San Te monewia timotenewa akin te, yika, tlan tikijtoa mach itla ipati. ");
INSERT INTO nplNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús okinnankili: —Maya Ne nonewia nimotenewa Akin Ne, tlan nomechilia milák, porke Ne nikmatok kan oniwalewak iwa kan nio. Pero nomejwah amo nonkimatih kan oniwalewak nion kan nio. ");
INSERT INTO nplNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nomejwah nontetlajtlakoltiah kemi kichiwah n tlaltikpaktlakah. Ne amaka niktlajtlakoltia. ");
INSERT INTO nplNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero tla Ne nitetlajtlakoltia, nikchiwa ika tlan milák, porke amo san Ne noselti nitetlajtlakoltia, yej Ne iwan Notajtsi Dios akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Itech nomotlanawatil ijkuilitok, sanwel kiseliskeh intlajtol ome iwa amo san se. ");
INSERT INTO nplNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","San Ne nonewia nimotenewa akin Ne, iwa Notajtsi Dios Akin onechaltítlanki, noiwa nechteixmatiltia akin Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yejwah okitlajtlanijkeh: —¿Kanin kajki Mota? Jesús okinnankili: —Nomejwah amo nonnechixmatih, nion nonkixmatih Notajtsi, tla nomejwah nonnechixmatiskiah, noiwa nonkixmatiskiah Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ninteh tlájtolteh Jesús okimijto ijkuak otlamachtijtoka itech n Weyi Tiopa kan ik okatka n kaxajtomij. Pero amaka okikitski porke ayamó oajsia n tonati para kikitskiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús oksepa okinmili: —Ne nias, iwa nonnechtemoskeh, pero nonmikiskeh itech nomotlajtlakolwah. Yika, kan Ne nias, amo weletis nonyaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ijkuakó n tlayakankeh judíojteh okijtojkeh: —¿Chamo kineki momiktis, yika kijtoa kan Ye yas, tejwah mach weletis tiaskeh? ");
INSERT INTO nplNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ijkuakó Jesús okinmili: —Nomejwah nonteaxkawah itech nin tlaltíkpaktli, pero Ne niwalewatok de ilwikak. Nomejwah non tlaltikpaktlakah, pero Ne amó. ");
INSERT INTO nplNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yika onomechili nonmikiskeh itech nomotlajtlakolwah. Porke tla nomejwah amo nonnechneltokah kox Ne Ni Cristo, nonmikiskeh itech nomotlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ijkuakó oksepa okitlajtlanijkeh: —¿Akin te? Jesús okinnankili: —Ne yonomechili Akin Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nikpia miak tlájtoli tlan nomechilis iwa miak tlan ika nomechtlajtlakoltis, pero Akin onechaltítlanki kijtoa tlan milák, iwa tlan Ne nikinmilia n tlaltikpaktlakah ye tlan onikkak, okijto. ");
INSERT INTO nplNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yejwah amo okajsikamatkeh Jesús okintlapowiaya de Itajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yika Jesús okinmili: —Ijkuak nonnechajkokuiskeh, Ne non onimochi ni tlakatl, ijkuakó nonkajsikamatiskeh Ne Ni Cristo, iwa amitla nikchiwa san tlan Ne nikneki. Ne sanwel nikijtoa tlan Notajtsi Dios onechmachti. ");
INSERT INTO nplNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porke Akin onechaltítlanki kajki nowa. Amo kema nechkawa noselti, porke nochipa nikchiwa tlan Ye kipaktia. ");
INSERT INTO nplNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ijkuak Jesús ijkó okinmili miakeh okineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ijkuakó Jesús okinmili n judíojteh non okineltokakeh: —Tla nomejwah nochipa nonkitlakitaskeh notlajtol, milák nonyetoskeh notlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Iwa nonkixmatiskeh tlan milák, iwa tlan milák nomechmakixtis. ");
INSERT INTO nplNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yejwah okinankilijkeh: —Tejwah tiwalewatokeh de Abraham, iwa ayik otikatkah titlanemakteh, ¿kenijki Te tikijtoa techmakixtis? ");
INSERT INTO nplNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús okinankili: —De milajka, de milajka nomechilia, nochteh akimeh kichiwa tlajtlákoli kijtosneki n tlajtlákoli kinnawatijtok kemi se tekowa. ");
INSERT INTO nplNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Se esklavo amo nochipa mokawas ichan iteko. Pero se tekone nochipa yetos mowa. ");
INSERT INTO nplNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ijkó kiné, tla Ikone Dios nomechmakixtis, nomejwah de milajka nonmomakixtiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kuali nikmatok nomejwah nonwalewatokeh de Abraham. Pero nonkinekih nonnechmiktiskeh porke amo nonkiseliah notlajtol itech nomoyolo. ");
INSERT INTO nplNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tlan onikitak inawak Notajtsi, ye nikijtoa. Iwa nomejwah tlan ononkikakeh de nomota nonkichiwah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yejwah okilijkeh: —¡Tejwah titepilwah de Abraham! Jesús okinmili: —Tla de milajka nonyetoskiah ipilwah Abraham, nonkichiwaskiah tlan Ye okichi. ");
INSERT INTO nplNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero maya yonomechili tlan milák, tlan Dios onechititi, nomejwah nonkinekih nonnechmiktiskeh. ¡Abraham ayik ijkó okichi! ");
INSERT INTO nplNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nomejwah nonkichiwah tlan kichiwa nomota. Yejwah okinankilijkeh: —Tejwah amo tiichtakakokoneh, sanwel se totata tikpiah, iwa Ye Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús okinnankili: —Tla de milajka Dios yaskia Nomotajtsi, nomejwah nonnechtlasojtlaskiah, porke Ne oniwala de Dios itech nin tlaltíkpaktli. Amo oniwala san por Ne oniknek, yej Dios onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tleka amo nonweletih nonkajsikamatih tlan nomechilia? Porke amo nonkinekih nonkiseliskeh notlajtol. ");
INSERT INTO nplNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nomejwah nomota n diablo, nomejwah ipilwah, iwa nonkichiwah tlan ye kiwelita. N diablo ye se temikti desde ipewaya n tlaltíkpaktli iwa ayik kijtoa tlan milák. Porke ye amo kixmati tlan milák, iwa ijkuak tlajtoa, tlakajkayawa porke ye non iteki. Iwa ye n teta de nochteh non tlakajkayawah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero kemi Ne nikijtoa tlan milák, yika nomejwah mach nonnechneltokah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Akin de nomejwah weletis kijtos ke nikpia itla tlajtlákoli? Iwa tla Ne nikijtoa tlan milák, ¿tleka amo nonnechneltokah? ");
INSERT INTO nplNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Akimeh tepilwah de Dios, kikakih itlajtol Dios. Pero kemi nomejwah amo nontepilwah de Dios, mach nonnechkakih. ");
INSERT INTO nplNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ijkuakó n tlayakankeh judíojteh okilijkeh: —Yompa tlan tejwah tikijtoah, te de Samaria iwa tikpixtok se amokuali espíritu. ");
INSERT INTO nplNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús okinnankili: —Ne amo nikpia se demonio. Ne sanwel nikweyilia Notajtsi, pero nomejwah nonnechmawistetepewah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne mach niktemoa manechweyilikah. Pero onka se Akin kimonekiltia manechweyilikah, iwa Ye Akin teixkomakah. ");
INSERT INTO nplNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","De milajka, de milajka nomechilia, akin kitlakita notlajtol, ayik mikis. ");
INSERT INTO nplNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ijkuakó n tlayakankeh judíojteh okinankilijkeh: —Axa kuali tikmatih te tikpia se demonio. Abraham iwa nochteh n profetas omikkeh, iwa te tikijtoa: “akin kitlakita notlajtol, ayik mikis.” ");
INSERT INTO nplNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mach te okachi tiweyijkatitok ke Totata Abraham? Ye noiwa omikki iwa n profetas noiwa. ¿Akin te timomachilia? ");
INSERT INTO nplNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús okinnankili: —Tla san Ne nimoweyijkachiwa, noweyijkachiwalis amitla ipati. Pero Akin nechweyijkachiwa, Ye Notajtsi, Akin nomejwah nonkijtoah Nomodios. ");
INSERT INTO nplNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero nomejwah mach nonkixmatih. Ne de milajka nikixmati, iwa tla nikijtoskia amo nikixmati, nixolopijtiskia kemi nomejwah. Pero Ne kema nikixmati, iwa nikchiwa tlan Ye nechnawatia. ");
INSERT INTO nplNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nomotata Abraham, opaki ijkuak okima niwalaskia, iwa ika itlaneltokalis onechitak iwa opakmik. ");
INSERT INTO nplNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ijkuakó n tlayakankeh judíojteh okilijkeh n Jesús: —Ayamó tikpia ome póali iwa n májtlaktli xiwitl, ¿iwa tikijtoa otikitak Abraham? ");
INSERT INTO nplNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús okinnankili: —De milajka, de milajka nomechilia: ¡Ijkuak Abraham ayamó otlakatia, Ne yonikatka! ");
INSERT INTO nplNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ijkuakó yejwah okinmonankeh temeh para kimojmotlaskeh n Jesús. Pero Ye okinmotlaatili, iwa opanok intlajkotiah, iwa okiski de kan Weyi Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ijkuak Jesús opanotiaya itech se ojtli, okitak se tlakatl non amo otlachiaya desde otlákatki. ");
INSERT INTO nplNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iwa itlamachtijkawah okitlajtlanijkeh: —Tlamachti, ¿tleka ijkó otlákatki nin tlakatl? ¿Akin otlajtlakolchi, itajwah, noso ye inewia? ");
INSERT INTO nplNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús otlanankili: —Amo por ye otlajtlakolchi nion por itajwah, yej ijkó otlákatki para mamota ítech, tlan Dios weletis kichiwas. ");
INSERT INTO nplNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iwa axa kemi ok tlanestok, nikpia niktekitilis Akin onechaltítlanki, porke ajsiki n yúali ijkuak ayakmaka weleti tekiti. ");
INSERT INTO nplNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Axa, kemi Ne ok nika itech nin tlaltíkpaktli, Ne nitláwili itech n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ijkuak Jesús ijkó okijto, ochijchak ipan tlali, iwa okichijchi siki sokitl. Okinxawili itech ixtololowah n kókoxki, ");
INSERT INTO nplNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","iwa okili: —Ximoixpajpakati kan tanke de Siloé. Siloé kijtosneki Tlatitlánili. N tlakatl non amo otlachiaya omoixpajpakato, iwa ijkuak owalmokopato, yotlachiaya. ");
INSERT INTO nplNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ijkuakó non okixmatiah iwa akimeh okimatiah amo otlachiaya okijtojkeh: —¿Amo ye ni non omijtlaniaya? ");
INSERT INTO nplNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sikimeh okijtoayah: —Ye ni n tlakatl. Oksikimeh okijtoayah: —Nesi ijkó tlachixtok, pero amo ye. Pero inewia okimiliaya: —Ejé, ye ne. ");
INSERT INTO nplNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ijkuakó okitlajtlanijkeh: —¿Kenijki ya weleti titlachia? ");
INSERT INTO nplNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ye okinnankili: —Neká tlakatl non Itoka Jesús, okichijchi siki sokitl, onechxawili kan noixtololowah iwa onechili: “Ximoixpajpakati kan tanke de Siloé.” Ne onia iwa ijkuak yonimoixpajpak, oniwaltláchixki. ");
INSERT INTO nplNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iwa oksepa okitlajtlanijkeh: —¿Kanin kajki non tlakatl? Ye okinmili: —Mach nikmati. ");
INSERT INTO nplNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ijkuakó n tlakatl non amo otlachiaya okiwikakeh innawak n fariseos. ");
INSERT INTO nplNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Porke ijkuak Jesús okichijchi sokitl iwa okintlapoli ixtololowah n tlakatl, okatka sábado ijkuak yejwah mosewiah. ");
INSERT INTO nplNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ijkuakó n fariseos oksepa okitlajtlanijkeh kenomi otláchixki, iwa ye okinnankili: —Onechxawili sokitl itech noixtololowah, onimoixpajpak, iwa axa ya nitlachia. ");
INSERT INTO nplNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ijkuakó sikimeh fariseos okilijkeh: —Akin ijkó okichi amo walewatok de Dios, porke amo kitlakita n sábado ijkuak moneki se mamosewi. Pero oksikimeh okijtoayah: —¿Kenijki weletis se tlajtlakolchi ijkó kichiwas? N tlakah omoxexelojkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ijkuakó oksepa okitlajtlanijkeh n tlakatl non amo otlachiaya: —¿Iwa te, tlan tikijtoa de neká tlakatl non omitsmák motlachialis? Ye otlanankili: —Ne nikijtoa Ye se profeta. ");
INSERT INTO nplNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","N tlayakankeh judíojteh mach okineltokayah kox milák amo otlachiaya. Ijkuakó okinnotskeh intajwah, ");
INSERT INTO nplNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","iwa okintlajtlanijkeh: —¿Ye ni nomotelpoch non nomejwah nonkijtoah amo otlachiaya ijkuak otlákatki? ¿Iwa axa kenomi ya tlachia? ");
INSERT INTO nplNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","N tetajmeh otlanankilijkeh: —Ye totelpoch, iwa kuali tikmatokeh amo otlachiaya ijkuak otlákatki. ");
INSERT INTO nplNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero axa, amo tikmatih kenijki ya weleti tlachia iwa amo tikmati akin okintlapoli ixtololowah. Inewia xiktlajtlanikah, ye ya tlakatl iwa weletis nomechilis. ");
INSERT INTO nplNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","N tetajmeh ijkó otlanankilijkeh porke okinmawiliayah n tlayakankeh judíojteh. Porke n tlayakankeh judíojteh yomotlatlalwijkeh ayakmó kinkawiliskiah makalakikah kan sinagoga akimeh kijtoskiah Jesús Ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yika itajwah okijtojkeh: “Ye inewia xiktlajtlanikah porke ya tlakatl.” ");
INSERT INTO nplNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ijkuakó n tlayakankeh judíojteh oksepa okinotskeh n tlakatl non achto amo otlachiaya, iwa okilijkeh: —Techili tlan milák ixpa n Dios, tejwah tikmatokeh non tlakatl, tlajtlakolchi. ");
INSERT INTO nplNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ijkuakó n tlakatl non yotlachiaya okinnankili: —Ne mach nikmati kox tlajtlakolchi noso amó. Sanwel nikmatok, achto amo onitlachiaya iwa axa ya nitlachia. ");
INSERT INTO nplNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Iwa oksepa okitlajtlanijkeh: —¿Tlan omitstokti? ¿Kenomi omitsintlapoli moixtololowah? ");
INSERT INTO nplNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ye okinnankili: —Ne yonomechili iwa amo nonnechkakih, ¿tleka nonkinekih oksepa manomechili? ¿Noiwa nomejwah nonkinekih nonyetoskeh itlamachtijkawah? ");
INSERT INTO nplNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ijkuakó yejwah fiero okitenejkeh iwa okilijkeh: —Te yotimochi itlamachtijkau non tlakatl, pero tejwah tiitlamachtijkawah Moisés. ");
INSERT INTO nplNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tejwah tikmatokeh Dios okitlapowi n Moisés. Pero non tlakatl, mach tikmatih kan owala. ");
INSERT INTO nplNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ijkuakó n tlakatl okinnankili: —¡Kenijki! Ye onechintlapoli noixtololowah iwa nomejwah amo nonkimatih kan owala. ");
INSERT INTO nplNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kuali tikmatih Dios amo kinkaki n tlajtlakolejkeh. Ye sanwel kinkaki akimeh kiweyijkachiwah iwa kichiwah tlan Ye kimonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mach ayik tikkakih aka tlakatl makitlachialti se akin amo tlachia desde otlákatki. ");
INSERT INTO nplNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tla nin tlakatl amo walewaskia de Dios, amitla weletiskia kichiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yejwah okilijkeh: —Te otitlákatki ika miak tlajtlákoli, ¿iwa axa tikneki techmachtis? Ijkuakó okwalkixtijkeh de kan sinagoga. ");
INSERT INTO nplNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús okima n tlakatl non okimák itlachialis okwalkixtijkeh de kan sinagoga, iwa ijkuak okinamik okili: —¿Te tikneltoka Ikone Dios? ");
INSERT INTO nplNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ye okinankili: —Tejwatsi, techili akin ye iwa nikneltokas. ");
INSERT INTO nplNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús okinankili: —Te yotikitak, iwa Ye Akin íwa timotlapowijtok. ");
INSERT INTO nplNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ijkuakó n tlakatl omotlankuáketski inawak Jesús iwa okili: —Nimitsneltoka, Tejwatsi Noteko. ");
INSERT INTO nplNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Otlanki Jesús okili: —Ne oniwala itech nin tlaltíkpaktli para nikinmilis kox kuali noso amokuali tlan kichiwah n tlaltikpaktlakah, iwa non amo tlachiah matlachiakah iwa non tlachiah amo matlachiakah. ");
INSERT INTO nplNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ijkuakó sikimeh fariseos non ompa okatkah, ijkuak ijkó okikakeh okitlajtlanijkeh: —¿Kijtosneki tejwah noiwa amo titlachiah? ");
INSERT INTO nplNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús okinnankili: —Tla nomejwah milák amo nontlachiaskiah, amo nonkipiaskiah tlajtlákoli. Pero kemi nomejwah nonkijtoah kuali nontlachiah, yika nonmokawah itech nomotlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","'De milajka, de milajka nomechilia, akin amo kalaki kan ik ikalte n ichkakorral iwa san tsekuini, noni se ichtek. ");
INSERT INTO nplNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero akin kalaki kan ik inkalte n ichkameh, ye intlájpixki iwa ye kinmokuitlawia. ");
INSERT INTO nplNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","N kaltentlamokuitlawi kitlatlapolia n tlájpixki, iwa iichkawah kitenkakih. Ye kinnotsa iichkawah ika intoka, iwa kinkixtia. ");
INSERT INTO nplNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Iwa ijkuak yokinkixti nochteh iichkawah, kinyakana. Iwa iichkawah yawih ikuitlapa porke kitenkakih. ");
INSERT INTO nplNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero se non amo kixmati mach iwan yawi, yej kicholiliskeh porke amo kitenkakih se akin amo kixmatih. ");
INSERT INTO nplNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús okinmili nin tlapoálistli, pero yejwah mach okajsikamatkeh tlan okinekia makajsikamatikah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ijkuakó Jesús oksepa okinmili: —De milajka, de milajka nomechilia: Ne n kaltentli kan ik kalakih n ichkameh. ");
INSERT INTO nplNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nochteh akimeh owalajkeh achto de Ne, okatkah ichtekeh iwa tekajkayajkeh. Pero n ichkameh mach okintenkakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne n kaltentli, akin kalakis itech non kaltentli non Ne nonewia, momakixtis. Kalakis iwa kisas iwa kajsis tlan kikuas. ");
INSERT INTO nplNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","'N ichtek sanwel wits para tlachtekis, para temiktis iwa teixpolos. Pero Ne oniwala para nochteh n tlakah makipiakah yolílistli, iwa non yolílistli mamomiakili itech inyolo. ");
INSERT INTO nplNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ne nikuali tlájpixki. Se kuali tlájpixki kinmokuitlawia iichkawah, maya makimiktikah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero se akin san tetlajpialia iwa amo iaxkawah n ichkameh, ijkuak kita wits n koyotl kinkakajtewa n ichkameh iwa choloa. Ijkuakó n koyotl kinkitskia sikimeh, iwa oksikimeh kinxijxitinia. ");
INSERT INTO nplNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ijkuakó non tetlajpialia choloa porke amo kintekipachoa n ichkameh sanwel itlaxtlawil. ");
INSERT INTO nplNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","'Ne kuali ni tlájpixki, iwa nikinmixmati akimeh noichkawah, iwa yejwah nechixmatih. ");
INSERT INTO nplNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ijkó kemi Notajtsi nechixmati iwa Ne nikixmati Notajtsi, iwa niktemaka noyolilis por noichkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noiwa nikimpia oksikimeh ichkameh, non amo kateh ijtik nin korral. Iwa moneki nikualinwikas noiwa. Yejwah nechtenkakiskeh, iwa nochteh yetoskeh sansikah, iwa yetos san se tlájpixki. ");
INSERT INTO nplNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","'Yika Notajtsi nechtlasojtla, porke nonewia niktemaka noyolilis, para ijkó satepa oksepa nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amaka weletis nechkixtilis noyolilis, yej Ne nonewia niktemaka. Ne weletis niktemakas noyolilis, iwa oksepa nikselis. Ye ni tlan onechnawati Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ijkuak n tlayakankeh judíojteh okikakeh nin tlájtoli, oksepa omoxexelojkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sikimeh okijtoayah: —Nin tlakatl kipia se demonio iwa yokuatlapolo. ¿Tleka nonkikakih? ");
INSERT INTO nplNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero oksikimeh okijtoayah: —Akin kipia se demonio mach ijkó tlajtoa. Se tlakatl non kipia se demonio mach weletis kintlapolis ixtololowah non amo tlachiah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Itech sewaya n judíojteh okichiwayah ilwitl porke okilnamikiah nochi xiwitl n tonati ijkuak okiyankuilijkeh n Weyi Tiopa de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iwa Jesús onemia kan Weyi Tiopa, kan ik iportal Salomón. ");
INSERT INTO nplNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ijkuakó n tlayakankeh judíojteh okiyawalojkeh iwa okitlajtlanijkeh: —¿Asta kemania san titlamatoskeh akin te? Sansemi techili tla te ti Cristo. ");
INSERT INTO nplNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús okinnankili: —Ne yonomechili, iwa nomejwah amo nonnechneltokah. Nochi tlan Ne nikchiwa, nikchiwa ika iweletilis itoka Notajtsi iwa kinextia Ne Ni Cristo. ");
INSERT INTO nplNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero nomejwah amo nonnechneltokah porke amo noichkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noichkawah nechtenkakih, iwa Ne nikinmixmati, iwa yejwah witseh nonawak. ");
INSERT INTO nplNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne nikchiwa mayolitokah nochipa, iwa ayik moixpoloskeh, iwa amaka weletis nechinmakixtilis. ");
INSERT INTO nplNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Notajtsi Akin onechinmaktili noichkawah, Ye okachi kipia weletílistli iwa amo onka ok se kemi Ye, iwa amaka weletis kinmakixtilis. ");
INSERT INTO nplNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne iwa Notajtsi tiseititokeh. ");
INSERT INTO nplNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ijkuakó n tlayakankeh judíojteh oksepa okonintilankeh temeh para kimotlaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús okinmili: —Nomoixpa nikchijtiwits miak tlamawísoli ika iweletilis Notajtsi, ¿katlie ika nonkinekih nonnechmojmotlaskeh ika tetl? ");
INSERT INTO nplNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","N tlayakankeh judíojteh okinankilijkeh: —Amo timitsmojmotlaskeh ika tetl por tlan kuali yotikchi, yej por tikixpanawia Dios ika tlan tikijtoa. Te san titlakatl iwa timotenewa ti Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús okinnankili: —Itech nomotlanawatilis ijkí ijkuilitok: “Ne onikijto nomejwah nondiosmeh.” ");
INSERT INTO nplNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tikmatokeh tlan kijtoa itlajkuilol Dios amo weletis se kipatlas; iwa Dios okínnotski diosmeh akimeh okiselijkeh itlajtol. ");
INSERT INTO nplNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iwa tla Dios onechpéjpenki iwa onechaltítlanki itech nin tlaltíkpaktli, ¿kenomi nonkijtoah Ne onikixpanawi porke onikijto Ne Ni Tekone de Dios? ");
INSERT INTO nplNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tla amo nikinchiwa milagros kemi Notajtsi kinchiwa, amo techneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero tla nikinchiwa milagros, amo Ne techneltokakah, yej xikinneltokakah n milagros non nikinchiwa, ijkó nonkitaskeh Notajtsi kajki nowa, iwa Ne nika íwa. ");
INSERT INTO nplNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oksepa okinekiah kikitskiskeh, pero Jesús okincholili. ");
INSERT INTO nplNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ijkuakó Jesús oksepa oyá ik nepa lado de n río Jordán, kan achto n Juan otlakuatekiaya iwa ompa omoka. ");
INSERT INTO nplNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Miakeh oyayah inawak Jesús iwa okijtoayah: —Juan amo okichi nion se milagro, pero nochi tlan okijto de nin tlakatl milák. ");
INSERT INTO nplNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iwa miakeh ompa okineltokakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Itech altepetl de Betania okatka se tlakatl non omokokoaya. Ye itoka Lázaro, iwa ochantitoka iwan iweltiwah María iwa Marta. ");
INSERT INTO nplNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nin María iwelti n Lázaro, ye akin okinxawili ajwiálistli itech ikxiwah n Toteko iwa okinwajwachili ika itsonkal. ");
INSERT INTO nplNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ijkó kiné, iweltiwah n Lázaro otlatitlankeh makilitih n Jesús: —Tejwatsi, motlasojikni Lázaro mokokoa. ");
INSERT INTO nplNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ijkuak Jesús okikak, okijto: —Nin kokólistli amo kimiktis, yej ika noni moteititis iweyijkachiwalis Dios, iwa ika non kokólistli noiwa kiweyijkachiwaskeh Ikone Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús okintlasojtlaya n Marta, María iwa n Lázaro. ");
INSERT INTO nplNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ijkuak okilijkeh Lázaro omokokoaya, Ye ok omoka ome tonati kan okatka. ");
INSERT INTO nplNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Otlanki Jesús okinmili itlamachtijkawah: —Matimokopakah Judea. ");
INSERT INTO nplNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ijkuakó itlamachtijkawah okilijkeh: —Tlamachti, ayamó wejkawa n tlayakankeh judíojteh okinekiah mitsmiktiskeh ika tetl; ¿iwa oksepa tikneki timuikas ompa? ");
INSERT INTO nplNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús okinmili: —Se tonati kipia májtlaktli iwa ome ora. Tla se tlakatl nemis ijkuak tlanestok amo moikxitlanwis, porke kita n tláwili non kajki itech nin tlaltíkpaktli, ");
INSERT INTO nplNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","pero tla se tlakatl nemi de yuak, moikxitlanwia porke n tláwili amo kajki itech. ");
INSERT INTO nplNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Satepa Jesús okinmili: —Totlasoj Lázaro kochtok, iwa Ne nio nikijxititi. ");
INSERT INTO nplNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ijkuakó itlamachtijkawah okilijkeh: —Tejwatsi, tla san kochtok, pajtis. ");
INSERT INTO nplNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús okinekia kimilis Lázaro yomikki, pero itlamachtijkawah okiyejyekoliayah chamo okintlapowijtoka de n kochílistli non tinochteh tikpiah. ");
INSERT INTO nplNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ijkuakó Jesús okinyekili: —Lázaro yomikki. ");
INSERT INTO nplNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Iwa nipaki porke amo ompa onikatka, ijkó nomejwah nontlaneltokaskeh. Tiawih, matikitatih. ");
INSERT INTO nplNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ijkuakó Tomás non okiliayah Kuatsi, okinmili non oksikimeh itlamachtijkawah: —Matiwiah tejwah noiwa, para timikiskeh iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ijkuak Jesús okalakito Betania, Lázaro yokiwikaya nawi tonati tooktok. ");
INSERT INTO nplNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania amo wejka omokawaya de Jerusalén, san kanaj eyi kilómetro. ");
INSERT INTO nplNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Miakeh judíojteh owalajkeh otetlajpaloko ichan Marta iwa n María para kinyolchikawaskeh porke omikki inmikni. ");
INSERT INTO nplNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ijkuak Marta okima Jesús yompa owalaya, okinamikito, pero María omoka itech kali. ");
INSERT INTO nplNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Iwa Marta okili n Jesús: —Noteko, tla nika tiyetoskia, nokni amo mikiskia. ");
INSERT INTO nplNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ne nikmati Dios mitsmakas nochi tlan Te tiktlajtlanilis. ");
INSERT INTO nplNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús okili: —Mokni moyolitis. ");
INSERT INTO nplNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta okili: —Milák, ne nikmati moyolitis ijkuak non yomikeh moyolitiskeh itech n iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ijkuakó Jesús okili: —Ne niktemaka nemílistli iwa yolílistli. Akin nechneltokas maya mamiki, yolitos nochipa. ");
INSERT INTO nplNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Iwa nochteh akimeh yolitokeh iwa nechneltokah ayik mikiskeh. ¿Tikneltoka? ");
INSERT INTO nplNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta okili: —Ejé, Noteko, ne nikneltoka Tejwatsi Ti Cristo Ikone Dios, Akin walaskia itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ijkuak ijkí okijto, Marta oyá san ichtakatsi okinotsato ikni María iwa okili: —N Tlamachti nika moitstika iwa mitsnotsa. ");
INSERT INTO nplNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ijkuak María okikak tlan Marta okili, omoketíkiski iwa okitato n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ayamó okalakia kan altepetl, ok okatka kan Marta okajsito. ");
INSERT INTO nplNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ijkuak n tlayakankeh judíojteh non okatkah itech kali okitakeh kenijki n María omoketíkiski, okikuitlapantokakeh. Okiyejyekoliayah chamo oyaya kichokiliti n Lázaro kan okitookakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ijkuak María okalakito kan okatka n Jesús, omotlankuáketski inawak iwa okili: —Noteko, tla nika tiyetoskia, nokni amo mikiskia. ");
INSERT INTO nplNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ijkuak Jesús okitak n María chokatok, iwa n judíojteh non okikuitlapantokayah noiwa, Jesús oyoltélinki asta oyolpatsiwik. ");
INSERT INTO nplNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iwa okintlajtlani: —¿Kani ononkitookakeh? Yejwah okilijkeh: —Tejwatsi, nika xiwalmuika iwa xikitaki. ");
INSERT INTO nplNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iwa Jesús ochokak. ");
INSERT INTO nplNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","N tlayakankeh judíojteh okijtojkeh: —¡Xikitakah, milák okitlasojtlaya! ");
INSERT INTO nplNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero oksikimeh okijtojkeh: —Tla owéletki okimák itlachialis non amo otlachiaya, ¿amo weletiskia kichiwaskia itla para amo mamiki n Lázaro? ");
INSERT INTO nplNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús oksepa omoyolkoko iwa omijkuani kan okitookakeh n Lázaro. Non miketékochtli okatka ijtik se kúyoktli iwa otentsaktoka ika se tetl. ");
INSERT INTO nplNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús okinmili: —Xikachiwakah n tetl. Marta, iwelti n Lázaro, okili n Jesús: —Noteko, ye ya fiero kistos porke ya kipia nawi tonati tooktok. ");
INSERT INTO nplNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero Jesús okili: —Yonimitsili, tla titlaneltokas tikitas iweyijkachiwalis Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ijkuakó okachijkeh n tetl. Jesús oajkotláchixki ilwikak iwa okijto: —Notajtsi, nimitstlasojkamati porke otechkak. ");
INSERT INTO nplNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne nikmatok nochipa techkaki, iwa ijkí nikijtoa para n tlakah non nika kateh makineltokakah Tejwatsi otechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ijkuak ijkí otlanki okijto, chikawak okitsajtsili: —¡Lázaro, xiwalkisa! ");
INSERT INTO nplNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ijkuakó n miketl owálkiski kikekemelitiwits ika tsótsoli itech ikxiwah iwa itech imawah, iwa oixtsaktiwalaya ika se tsótsoli. Iwa Jesús okinmili: —Xiktojtomakah iwa xikkawilikah mawia. ");
INSERT INTO nplNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Miakeh judíojteh non okiyolchikawatoh n María, ijkuak okitakeh tlan okichi n Jesús, okineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero sikimeh okimitatoh n fariseos iwa okimilijkeh tlan Jesús okichi. ");
INSERT INTO nplNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ijkuakó n tiopixkeh non tlayakantokeh, n fariseos iwa n tekiwajkeh de Sanedrín omoololojkeh iwa okimolijkeh: —¿Tlan tikchiwaskeh? Nin tlakatl kinchijtinemi miakeh milagros. ");
INSERT INTO nplNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tla tikkawiliskeh ijkó makichijtinemi, nochteh pewas kineltokaskeh, iwa n tekiwajkeh de Roma witseh kixixititsakiweh n Weyi Tiopa iwa n nochi topaís. ");
INSERT INTO nplNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ijkuakó seme de yejwah non itoka Caifás, non itech non xiwitl okinnawatiaya n tiopixkeh, okinmili: —Nomejwah amitla nonkimatih, ");
INSERT INTO nplNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","amo nonkajsikamatih okachi kuali mamiki san se tlakatl por tinochteh, iwa amo makipojpolokah nochi topaís. ");
INSERT INTO nplNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ninteh itlajtolwah n Caifás amo inewia okimijto, yej kemi ye okatka weyi tiópixki non xiwitl, Dios okitlajtolti Jesús mikiskia por nochteh. ");
INSERT INTO nplNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iwa amo mikiskia san por n judíojteh, yej noiwa para kinseitilis nochteh ipilwah Dios non sentetl oxitintokah. ");
INSERT INTO nplNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yika desde non tonati opé kitemoliah kenijki kimiktiskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ika noni, Jesús ayakmó omoteititiaya inmixpah n judíojteh, yej oyá kan se altepetl non itoka Efraín non kajki kan ik tlaltejtéyinki, iwa ompa omoka iwa itlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yowalajsitiwalaya n ilwitl de Paskua de n judíojteh. Miakeh okisayah de inmaltépeu iwa otlejkoayah Jerusalén para motlajtlakolchipawaskeh achto de pewas inmilwiu. ");
INSERT INTO nplNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yejwah okixtemojtinemiah n Jesús kan Weyi Tiopa iwa omotlajtlaniayah: —¿Tlan non kimoliah? ¿Wits itech ilwitl noso, amo wits? ");
INSERT INTO nplNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","N fariseos iwa n tiopixkeh non tlayakantokeh otlanawatijkeh tla aka kimatis kan kajki n Jesús, makinmatilti para kikitskiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chikwase tonati achto de pewas n ilwitl de Paskua, Jesús oyá Betania, kan ochantitoka n Lázaro, akin Jesús okiyoliti. ");
INSERT INTO nplNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ompa okichijchijkeh se tlákuali para motlasojkamatiskeh inawak Jesús, Marta okintlatekiliaya, Lázaro oewatoka kan mesa iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ijkuakó María okualík kemi tlajko litro ajwiálistli de nardo non tlawel patio, iwa okinmajwiali ikxiwah n Jesús, otlanki okinwajwachili ika itsonkal. Iwa nochi n kali omoajwiali. ");
INSERT INTO nplNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ijkuakó Judas Iskariote ikone n Simón, seme de itlamachtijkawah akin satepa kitemaktiskia n Jesús, okijto: ");
INSERT INTO nplNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Tleka amo omonamák nin ajwiálistli ika eyi siento denariojtomi, ika tikimpalewiskiah n próbesteh? ");
INSERT INTO nplNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero Judas amo ijkó okijto por milák okinmiknomatiaya n próbesteh, yej porke ye tlachtek, iwa kemi ye okoololoaya n tomi, inewia okichikowiaya. ");
INSERT INTO nplNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ijkuakó Jesús okili: —Xikkawa, ye okitlaatijtoka nin ajwiálistli para n tonati ijkuak nechtookaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","N próbesteh nochipa yetoskeh nomowah, pero Ne amo nochipa niyetos nomowah. ");
INSERT INTO nplNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Miakeh judiojteh okimatkeh Jesús okatka kan altepetl de Betania, iwa oyajkeh. Amo oyajkeh san para kitaskeh n Jesús, yej noiwa para kitaskeh n Lázaro, akin Jesús okiyoliti. ");
INSERT INTO nplNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ijkuakó n tiopixkeh non tlayakantokeh omotlatlalwijkeh noiwa kimiktiskeh n Lázaro. ");
INSERT INTO nplNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porke ijkuak Lázaro omoyoliti, miakeh judíojteh omoixkoyantijkeh de n tiopixkeh non tlayakantokeh iwa okineltokayah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ipan ok se tonati, miakeh tlakah oyajkeh ilwitl de Paskua, iwa okimatkeh Jesús noiwa oyaya ompa Jerusalén itech non ilwitl. ");
INSERT INTO nplNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Okinmatekeh soyameh iwa oyajkeh okinamikitoh n Jesús, iwa otsajtsia chikawak: —¡Hosanna! Ma Dios kitiochiwa Akin okititlankeh matlanawati! ¡Ma Dios kitiochiwa n Rey de Israel! ");
INSERT INTO nplNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús okajsik se burrojtsi iwa ipan otlejkok. Kemi kijtoa itlajkuilol Dios: ");
INSERT INTO nplNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Amo ximawikah akimeh chanchiwah Sión; xikitakah nomorey ya walmuika, tlejkotiwits ipan se burrojtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Itech non tonati itlamachtijkawah mach okajsikamatkeh tlan kijtosneki tlan otlamochi, pero satepa ijkuak Jesús oyá ilwikak, itlamachtijkawah okualilnamikeh yoijkuilitoka nochi tlan Ye panoskia. ");
INSERT INTO nplNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","N tlakah non okatkah iwan Jesús ijkuak okínotski n Lázaro ijtik miketékochtli iwa okiyoliti de kan mikemeh, otetlapowijtinemiah tlan okitakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yika, miakeh okinamikitoh n Jesús, porke okimatkeh okichi non milagro. ");
INSERT INTO nplNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero n fariseos okimoliayah: —Xikitakah, nochteh n tlakah yawih inawak Jesús. Iwa tejwah amitla tiweleti tikchiwah. ");
INSERT INTO nplNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Itech non ilwitl de Paskua noiwa owalajkeh sikimeh tlakah de Grecia akimeh noiwa okiweyijkachiwakoh Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yejwah omijkuanijkeh inawak Felipe non okatka de Betsaida, iwa okitlatlautijkeh: —Tlakatl, tiknekih tikitaskeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe okitlajtoltito n Andrés; iwa san ken ome okitlapowitoh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ijkuakó Jesús okinmili: —Yoajsiko n ora ijkuak nechweyijkachiwaskeh Ne Non onimochi ni tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","De milajka, de milajka nomechilia, tla se kitooka se xínachtli iwa non xínachtli amo miki, non xínachtli mokawas iselti iwa amitla kitemakas. Pero tla non xínachtli miki, kitemakas miak itlakilo. ");
INSERT INTO nplNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Akin amo kitemakas iyolilis nonawak, kipolos ijkuak mikis. Pero akin kitemakas iyolilis nonawak itech nin tlaltíkpaktli amo kipolos yej kipias yolílistli non amayik tlami. ");
INSERT INTO nplNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Akin kinekis nechtekitilis, mawiki nowa, iwa kan Ne niyetos, noiwa ompa yetos. Tla aka nechtekitilia, Notajtsi kiweyijkatlalis. ");
INSERT INTO nplNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","'Axa satlawel nimoyolkokoa, ¿Iwa tlan nikijtos? ¿Mach weletis nikilis: “Notajtsi, techmakixti itech nin tlaijyowílistli”? Amó, mach weletis ijkó nikilis porke saman para ye Ne oniwala. ");
INSERT INTO nplNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Notajtsi, maweyijkachito Motoka. Ijkuakó omokak se tlájtoli de ilwikak: —Yonikweyijkachi iwa oksepa nikweyijkachiwas. ");
INSERT INTO nplNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","N tlakah non ompa okatkah, ijkuak okikakeh n tlájtoli, okijtoayah, otlatékuinki, iwa oksikimeh okijtoayah: —Se ángel okitlapowi. ");
INSERT INTO nplNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ijkuakó Jesús okinmili: —Non tlájtoli amo omokak para Ne manikkaki, yej para nomejwah xikkakikah. ");
INSERT INTO nplNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yoajsiko n tonati ijkuak kintlajtlakoltiskeh n tlaltikpaktlakah, iwa axa kualkixtiskeh akin kinawatia nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iwa ijkuak nechajkokuiskeh itech krus, nochteh nikinyoltilanas para mawikih nonawak. ");
INSERT INTO nplNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ijkó Jesús okinmajsikamatilti kenijki mikiskia. ");
INSERT INTO nplNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","N tlakah okinankilijkeh: —Itlajkuilol Dios kijtoa Cristo nochipa yolitos. ¿Kenijki Te tikijtoa non omochiwako tlakatl moneki makajkokuikah? ¿Akin ye akin omochi tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ijkuakó Jesús okinmili: —San kanaj kech tonati niyetos nomowah. Xinemikah ika notlawil axa ken ok nonweletih, amo kichiwa nomechajsiti n tleyuálistli. Porke akin nemi itech tleyuálistli amo kimati kan ik yawi. ");
INSERT INTO nplNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Axa ken ok nonkipixtokeh n tláwili, xikkawilikah mamoskaltih non tláwili itech nomoyolo, ijkó nonyetoskeh tepilwah de non tláwili. Ijkuak Jesús okimijto ninteh tlájtolteh, oyá okinmotlaatilito. ");
INSERT INTO nplNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maya Jesús okinchi miakeh milagros inmixpah n judíojteh, amo okineltokayah. ");
INSERT INTO nplNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ijkó omochi tlan okijto n profeta Isaías: Noteko, ¿akin okineltokak motlajtol non tejwah otiktematiltijkeh? ¿Akin inawak yomonexti iweletilis n Toteko? ");
INSERT INTO nplNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yejwah mach otlaneltokayah, Isaías noiwa okijto: ");
INSERT INTO nplNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios okintokti ayakmó matlachiakah iwa okinyoltlakuawaltih, para amo matlachiakah ika inmixtololowah nion mateajsikamatikah ika inyolo, nion mamoyolkopakah nonawak, para manikimpajti. ");
INSERT INTO nplNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías ijkí okijto porke okitak iweletilis Cristo, yika otetlapowiaya de Ye. ");
INSERT INTO nplNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Maski ijkó, miakeh judiojteh okineltokakeh n Jesús, iwa asta sikimeh tlayakankeh itech Weyi Tiopa. Pero amo okitenextiayah teixpa porke okinmawiliayah n fariseos, para amo makinkixtikah itech sinagogas. ");
INSERT INTO nplNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Porke yejwah okachi okiwilitayah makinweyilikah n tlakah iwa amo Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ijkuakó Jesús chikawak okijto: —Akin nechneltoka, amo san Ne nechneltoka, yej noiwa kineltoka Notajtsi Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iwa akin nechita, noiwa kita Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne oniwala itech nin tlaltíkpaktli kemi se tláwili, iwa nikintlawilia itech inyolo nochteh akimeh nechneltokah, iwa yejwah amo mamokawakah itech tleyuálistli. ");
INSERT INTO nplNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tla aka kikaki notlajtol iwa amo kitlakita, amo Ne niktlajtlakoltis. Porke Ne amo oniwala onikintlajtlakoltiko n tlaltikpaktlakah, yej onikinmakixtiko. ");
INSERT INTO nplNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Akin nechtlawelita, iwa amo kitlakita notlajtol, ya kipia akin kitlajtlakoltis: N tlájtoli non Ne oniktematilti, ye kitlajtlakoltis itech n iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porke Ne amo onikijto san tlan Ne nonewia onikyejyekoli, yej Notajtsi Akin onechaltítlanki onechnawati tlan moneki nikijtos iwa tlan moneki niktemachtis. ");
INSERT INTO nplNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne nikmatok akimeh kichiwa tlan kijtoa itlanawatil Notajtsi, kinmakas yolílistli non ayik tlami. Yika, tlan Ne nikijtoa, nikijtoa ijkó kemi Notajtsi onechnawati. ");
INSERT INTO nplNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yoajsitiwalaya n ilwitl de Paskua, Jesús yokimatia yoajsia n ora para kikakajtewas nin tlaltíkpaktli iwa yas inawak Itajtsi. Ye nochipa okintlasojtlak iaxkawah non okatkah itech nin tlaltíkpaktli, iwa okintlasojtlak asta n iksemi tonati. ");
INSERT INTO nplNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Non yúali, ijkuak Jesús iwa itlamachtijkawah oyualtlakuajtokah, n diablo yokitlalijka itech iyolo n Judas Iscariote, ipiltsi n Simón, para makitemakti n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús okimatiwalaya Itata yokimaktili nochi para Ye matlanawati, iwa yokimatia Ye owala de Dios iwa oksepa mokopaskia íwa. ");
INSERT INTO nplNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ijkuakó Jesús omóketski de kan mesa, okimokixtili ikapa, iwa omotlajkoilpi ika se tsótsoli. ");
INSERT INTO nplNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ijkuakó okitekak atl itech se xíkali iwa opé kinmikxipajpaka itlamachtijkawah iwa okinmaxotomaya ika n tsótsoli non ika omotlajkoilpijka. ");
INSERT INTO nplNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ijkuak Jesús omijkuani kan Simón Pedro para kimpakilis ikxiwah, Pedro okili: —Noteko, ¿Tejwatsi, techimpakilis nokxiwah? ");
INSERT INTO nplNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús okinankili: —Tlan Ne nikchijtok, te axa amo tikajsikamati, pero satepa tikajsikamatis. ");
INSERT INTO nplNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro okili: —Tejwatsi amayik techimpakilis nokxiwah. Jesús okinankili: —Tla amo nimitsikxipajpakas, amo timopoas nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ijkuakó Simón Pedro okili: —Noteko, tla ijkó, amo sanwel techimpakili nokxiwah, yej noiwa nomawah iwa notsonteko. ");
INSERT INTO nplNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Jesús okili: —Akin sikin omalti, sanwel moneki mamoikxipajpaka, porke ya chipawak. Iwa nomejwah ya nonchipawakeh, maya amo non nochteh. ");
INSERT INTO nplNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús okimatia akin kitemaktiskia, yika okijto: “Amo nochteh nonchipawakeh.” ");
INSERT INTO nplNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ijkuak yotlanki okimikxipajpak itlamachtijkawah, oksepa okimokentili ikapa iwa omotlalito kan mesa, iwa okinmili: —¿Nonkajsikamatih tlan onikchi nomowah? ");
INSERT INTO nplNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nomejwah nonnechnotsah Tlamachti iwa Noteko, iwa kuali tlan nonkijtoah, porke milák, Ne Nomotlamachti iwa Nomoteko. ");
INSERT INTO nplNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iwa tla Ne Nomoteko iwa Nomotlamachti onomechinpakili nomokxiwah, ijkó noiwa moneki ximosepanikxipajpakakah. ");
INSERT INTO nplNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Porke ijkó kemi Ne onikchi moneki no ijkó xikchiwakah. ");
INSERT INTO nplNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","De milajka, de milajka nomechilia se tlakéwale amo okachi weyijkatitok ke iteko. Ijkó noiwa, se tlatitlánili amo okachi weyijkatitok ke akin okitítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tla nonkajsikamatih iwa nonkichiwah tlan nomechilijtok, nonkipiaskeh miak pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Tlan nikijtoa amo para nochteh nomejwah. Ne nikinmixmati inyolo akimeh onikimpéjpenki. Pero nika mochiwas tlan kijtoa n tiotlajkuíloli: “N tlakatl akin nowa tlapaloa, omíxkopki nowa.” ");
INSERT INTO nplNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Axa nomechilia nochi ni, para ijkuak ijkó tlamochiwas, xikneltokakah Ne Ni Cristo. ");
INSERT INTO nplNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","De milajka, de milajka nomechilia: Akin kiselia akin Ne niktitlani, Ne nechselia, iwa akin Ne nechselia, noiwa kiselia Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ijkuak Jesús okimijto ninteh tlájtolteh, saikpanoa oyoltélinki iwa okinyekili: —De milajka, de milajka nomechilia, seme de nomejwah nechtemaktis. ");
INSERT INTO nplNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ijkuakó n itlamachtijkawah opé motlatlajtlatah, porke amo okimatiah akin okitenejtoka. ");
INSERT INTO nplNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Seme de yejwah non Jesús okitlasojtlaya, omonakasiktekak itech Jesús ijkuak otlakuajtokah. ");
INSERT INTO nplNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro okichtakaili n Juan makitlajtlani n Jesús akin okitenejtoka. ");
INSERT INTO nplNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ijkuakó okachi omijkuani inawak Jesús iwa okitlajtlani: —Noteko, ¿akin mitstemaktis? ");
INSERT INTO nplNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús okinankili: —Nikajakis siki paj, iwa akin Ne nikmakas, ye nechtemaktis. Ijkuakó Jesús okajaki n paj iwa okonmák n Judas Iscariote, ipiltsi n Simón. ");
INSERT INTO nplNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ijkuak Judas okikua n paj, n diablo okalak itech iyolo. Ijkuakó Jesús okili: —Tlan tikchiwas sansemi xikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nion se de yejwah, akimeh otlakuajtokah itech mesa okajsikama tleka n Jesús ijkó okili n Judas. ");
INSERT INTO nplNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kemi Judas okipixtoka n tomi, yejwah okiyejyekoliayah chamo Jesús okili makikoati tlan monekis para n ilwitl de Paskua, noso itla makintliokoli n próbesteh. ");
INSERT INTO nplNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ijkuak Judas yokikua n paj non Jesús okonmák, sanima okiski, iwa ya yotleyuak. ");
INSERT INTO nplNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Satepa ijkuak Judas yokiski, Jesús okijto: —Axa moteititia noweyijkachiwalis Ne Akin onimochi ni tlakatl, iwa iweyijkachiwalis Dios motenextia itech tlan Ne nikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tla Ne nikteititis iweyijkachiwalis Dios, ijkuakó Dios noiwa kiteititis noweyijkachiwalis, iwa san nima ijkó kichiwas. ");
INSERT INTO nplNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nopilwah, mach ok wejkawas niyetos nomowah. Nomejwah nonnechtemoskeh. Pero ijkó kemi onikinmili n judíos axa nomejwah nomechilia: Kan Ne nio, nomejwah mach weletis nonyaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ne nomechmaka se yankuik tlanawátili: Ximosepantlasojtlakah, ijkó kemi Ne nomechtlasojtla, ijkó moneki ximosepantlasojtlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tla nomejwah nonmosepantlasojtlah, nochteh n tlaltikpaktlakah nomechitaskeh nomejwah de milajka notlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro okitlajtlani n Jesús: —Tejwatsi, ¿kan timuikas? Jesús okinankili: —Kan Ne nimuikas, axa mach weletis tias nowa. Pero satepa weletis tias nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro okili: —Noteko, ¿tleka axa amo weletis nias mowa? ¡Tla moneki, asta nikmokawilis manechmiktikah por Tejwatsi! ");
INSERT INTO nplNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús okinankili: —¿Timotemaktis nopatka? De milajka, de milajka nimitsilia, achto de tlakuikas n kaxtil, te tikijtos eyi welta amo techixmati. ");
INSERT INTO nplNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","'Amo ximotekipachojtinemikah. Xikneltokakah Dios iwa techneltokakah Ne noiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Icha Notajtsi onka miak lojar kan se chantitos. Tla amo ijkó yetoskia, Ne nomechiliskia. Yika, Ne nio ompa nomechmajmaniliti se lojar. ");
INSERT INTO nplNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Satepa ijkuak yonia iwa yonomechmajmanili non lojar, oksepa niwalmokopas iwa nomechwikas nowa, nonyetoskeh kan Ne niyetos. ");
INSERT INTO nplNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kan Ne nio, nomejwah ya nonkixmatokeh n ojtli. ");
INSERT INTO nplNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ijkuakó Tomás okili: —Noteko, tejwah mach tikmatih kanon timuika, ¿kenomi tikixmatiskeh non ojtli? ");
INSERT INTO nplNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús okinankili: —Ne Ni ojtli nontewika inawak Dios, Ne nomechnonotsa ika milák tlájtoli, iwa Ne Akin kichiwa xiyolitokah. Sanwel akin nechtlakita weletis kalakiti inawak Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tla nomejwah nonnechixmatiskiah, noiwa nonkixmatiskiah Notajtsi, axa ya nonkixmatokeh, porke ya nonkiitiwitseh. ");
INSERT INTO nplNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ijkuakó Felipe okili: —Tejwatsi, techixmatilti Toweyitajtsi iwa ika no, ya kuali. ");
INSERT INTO nplNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús okili: —Felipe, yowejka nika nomowah, ¿iwa ayamó techixmati? Akin yonechitak kijtosneki yokitak Notajtsi. Yika ¿kenijki te tikijtoa manomechixmatilti Notajtsi? ");
INSERT INTO nplNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Amo tikneltoka Ne nika itech Notajtsi iwa Ye kajki notech? Nochi tlan Ne nomechtlapowia, amo notech kisa, yej Notajtsi non kajki notech, kichiwa tlan Ye kimonekiltia. ");
INSERT INTO nplNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Techneltokakah Ne nika iwa Notajtsi, iwa Notajtsi kajki nowa, noso tla amo ijkó, techneltokakah por tlan nikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","De milajka, de milajka nomechilia: Akin nechneltoka, noiwa weletis kichiwas tlan Ne nikchiwa. Iwa weletis kinchiwas okachi weyi, porke Ne nio inawak Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nochi tlan nonkitlajtlaniliskeh Notajtsi ika Notoka, Ne nikchiwas, para makiseli weyílistli Notajtsi por Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tla itla nonkitlajtlaniskeh ika Notoka Ne nikchiwas. ");
INSERT INTO nplNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","'Tla nomejwah nonnechtlasojtlah, xikchiwakah tlan kijtoa notlanawatil. ");
INSERT INTO nplNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iwa Ne niktlatlaujtis Notajtsi manomechtitlanili ok se teyolchika, para nochipa mayeto nomowah. ");
INSERT INTO nplNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","N tlaltikpaktlakah amo weletih kiseliah n Espíritu non techajsikamatiltiah tlan milák porke amo kitah nion kixmatih. Pero nomejwah nonkixmatih porke Ye kajki nomowah iwa nochipa yetos nomowah. ");
INSERT INTO nplNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Amo nomechkawas nonmiknomeh, niwalmokopas iwa nomowah niyetos. ");
INSERT INTO nplNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mach ok wejkawas iwa ayakmó nechitaskeh n tlaltikpaktlakah, pero nomejwah nonnechitaskeh. Porke kemi Ne niyolitok, nomejwah noiwa nonyolitoskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Itech neká tonati nomejwah nonkajsikamatiskeh Ne nika iwa Notajtsi, iwa nomejwah nonkateh nowa, iwa Ne nika nomowah. ");
INSERT INTO nplNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Akin kixmati notlanawatil, iwa kichiwa tlan kijtoa, non tlakatl nechtlasojtla. Iwa akin nechtlasojtla, Notajtsi kitlasojtlas iwa Ne noijkó niktlasojtlas iwa nimoteititis inawak. ");
INSERT INTO nplNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ijkuakó non ok se Judas okitlajtlani: —Noteko ¿tleka timoteixmatiltis tonawak, iwa amo innawak n tlaltikpaktlakah? ");
INSERT INTO nplNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús okinankili: —Akin nechtlasojtla kijtosneki kichiwa tlan nikijtoa. Notajtsi kitlasojtlas, iwa Notajtsi iwa Ne timochantikiweh íwa. ");
INSERT INTO nplNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iwa akin amo nechtlasojtla, amo kitlakita notlajtol. N tlájtoli tlan nomejwah nonkinkaktokeh, mach Ne notlajtol yej itlajtol Notajtsi Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","'Ne onomechili nochi ni ijkuak onikatka nomowah. ");
INSERT INTO nplNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero n teyolchika, Ye n Espíritu Santo Akin Notajtsi kualtitlanis ika Notoka, Ye nochi nomechajsikamatiltis, iwa nomechilnamiktis nochi tlan Ne yonomechili. ");
INSERT INTO nplNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'Noyolsewilis nomechkajtewilia, noyolsewilis nomechmaka. Iwa amo kemi non kitemakah n tlaltikpaktlakah. Amo ximosotlawakah nion ximawikah. ");
INSERT INTO nplNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nomejwah yononkikakeh tlan onikijto, onomechili nias iwa oksepa niwalmokopas para niyetos nomowah. Tla de milajka nonnechtlasojtlaskiah, nompakiskiah ijkuak onomechili nio íwa Notajtsi, porke Notajtsi okachi weyijkatitok ke Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ne achto yonomechili ijkó tlamochiwa, yika ijkuak ijkó tlamochiwas, nomejwah xitlaneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Ayakmó niwejkawas nomechtlapowis, porke yompa wits non kinnawatia n tlakah de nin tlaltíkpaktli. Ye amitla weletis nechtoktis. ");
INSERT INTO nplNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nikchiwas tlan nechnawatia Notajtsi, para ijkó makimatikah n tlaltikpaktlakah, Ne niktlasojtla Notajtsi. 'Ximoketsakah. ");
INSERT INTO nplNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","'Ne n de milajka uvaskuawitl, iwa Notajtsi Ye n uvastékitki. ");
INSERT INTO nplNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tla se nomamayo amo tlaaki, Notajtsi kitsonteki. Pero tla kuali tlaaki kichijchipawa para okachi matlaaki. ");
INSERT INTO nplNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nomejwah yononmochipajkeh, ika notlajtol non Ne yonomechili. ");
INSERT INTO nplNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xiseititokah nowa, kemi Ne niseititok nomowah. Nion se imamayo n uvaskuawitl amo weletis tlaakis tla amo salitos itech itlaktsonyo. Ijkó noiwa, amo weletis nonkitemakaskeh tlakilo tla nomejwah amo nonseititoskeh nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","'Ne niuvaskuawitl iwa nomejwah nomamayowah. Akin salitok nowa iwa Ne íwa, kitemakas miak itlakilo. Porke tla amo nonsalitoskeh nowa, amitla weletis nonkichiwaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Akin amo seititok nowa, kitlamotlaskeh kala iwa wakis kemi imamayowah n uvaskuawitl non kinmoololoah, iwa kintlamotla ijtik tletl iwa ompa tlatlah. ");
INSERT INTO nplNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","'Tla nomejwah nonseititoskeh nowa iwa notlajtol kajki ijtik nomoyolo, xiktlajtlanikah san tlan nonkinekih iwa nomechmakas. ");
INSERT INTO nplNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Notajtsi kiselia weyílistli ijkuak nomejwah nonkitemakah miak nomotlakilo, iwa ijkó mota nomejwah milák notlamachtijkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ne nomechtlasojtla kemi Notajtsi nechtlasojtla, xiyetokah nochipa ika notlasojtlalis. ");
INSERT INTO nplNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tla nonkitlakitah tlan nomechnawatia, nochipa nomechtlasojtlas, ijkó kemi Ne niktlakita tlan nechnawatia Notajtsi, yika Ye nechtlasojtla. ");
INSERT INTO nplNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'Ne nomechilia nochi ni para xipakikah kemi Ne nipaki, iwa ijkó xitentokah ika nopakilis. ");
INSERT INTO nplNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ye ni tlan nomechnawatia: Ximotlasojtlakah non nochteh ijkó kemi Ne nomechtlasojtla. ");
INSERT INTO nplNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Akin motemakas makimiktikah ipatka itlakaikniwah, saikpanoa kintlasojtla. Saikpanoa kintlasojtla itlakaikniwah tla motemakas makimiktikah impatka. ");
INSERT INTO nplNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nomejwah de milajka notlakaikniwah tla nonkichiwah tlan nomechnawatia. ");
INSERT INTO nplNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayakmó nomechnotsas notlakawah, porke se tlakéwali amo kimati tlan kichiwa iteko. Ne nomechnotsas notlakaikniwah, porke yonomechmatilti nochi tlan Notajtsi onechili. ");
INSERT INTO nplNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Nomejwah amo ononnechpejpenkeh, yej Ne onomechpéjpenki, iwa onomechmaktili n tekitl para xiwiah iwa xiktemakakah miak nomotlakilo, iwa nomotlakilo mawejkawa. Ijkó nochi tlan nonkitlajtlaniliskeh Notajtsi ika Notoka, Ye nomechmakas. ");
INSERT INTO nplNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ye ni tlan Ne nomechnawatia: Ximosepantlasojtlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","'Tla n tlaltikpaktlakah nomechkokoliah, xikmatikah Ne achto yonechkokolijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tla nomejwah ok nontlajtlakolchijtinemiskiah kemi kichiwah n tlaltikpaktlakah, yejwah nomechtlasojtlaskiah kemi yejwah motlasojtlah. Pero kemi Ne onomechpéjpenki de intlajko n tlajtlakolchijkeh, yika yejwah nomechtlawelitah porke ayakmó nonkichiwah tlan yejwah kichiwah. ");
INSERT INTO nplNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xikilnamikikah tlan onomechili: “Nion se tlakéwali okachi ke iteko.” Tla Ne onechtotojtokakeh, noiwa nomejwah nomechtotojtokaskeh, iwa tla okitlakitakeh notlajtol, noiwa kitlakitaskeh nomotlajtol. ");
INSERT INTO nplNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nochi ni nomechtoktiskeh por nonnechtlakitah. Porke yejwah amo kixmatih Akin onechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Tla Ne amo niwalaskia iwa nion amo nikintlapowiskia, amo kipiaskiah tlajtlákoli. Pero axa amo weletis kijtoskeh amo kimpiah tlajtlákolteh. ");
INSERT INTO nplNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Porke akin Ne nechkokolia, noiwa kikokolia Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yejwah amo kipiaskiah tlajtlákoli tla Ne amo nikinchiwaskia milagros inmixpa. Pero maya okimitakeh, yejwah nechkokoliah iwa kikokoliah Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ijkí otlamochi para mamochiwa tlan ijkuilitok itech intlanawatil, kan kijtoa: “Onechkokolijkeh san por okinekeh.” ");
INSERT INTO nplNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","'Pero ijkuak wits Akin teyolchikawa, n Espíritu non kitemachtia tlan milajka, non Ne nomechtitlanilis de inawak Notajtsi. Ye nomechtlapowis de Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Iwa nomejwah noiwa nontetlapowiskeh de Ne, porke ononkatkah nowa ijkuak sikinika onikpewalti noteki. ");
INSERT INTO nplNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Ne nomechilia nochi ni para amo xikkawakah nontlaneltokaskeh nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nomechkixtiskeh kan nomosinagogas. Iwa ajsiki tonati ijkuak aka nomechmiktis, kijtos okichi se kuali tekitl inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ijkó kichiwaskeh porke amo okixmatkeh Notajtsi nion Ne. ");
INSERT INTO nplNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ijkí nomechilia para ijkuak ijkó tlamochiwas xikilnamikikah Ne yonomechilijka. ");
INSERT INTO nplNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","'Axa nio inawak Akin onechaltítlanki; ¿iwa nion se de nomejwah nechtlajtlania kan nio? ");
INSERT INTO nplNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ken yonomechili ninteh tlajtolteh axa nonmoyolkokoah. ");
INSERT INTO nplNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero Ne nomechilia tlan milák: Okachi kuali manimuika, porke tla amo nio, Akin teyolchikawa amo weletis wits nomonawak. Pero tla Ne nimuikas, nomechwaltitlanilis Akin teyolchikawa. ");
INSERT INTO nplNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ijkuak Ye wits, kinmajsikamatiltis n tlaltikpaktlakah kateh itech tlajtlákoli. Iwa kenomi weletis yetoskeh kuali inawak Dios. Iwa kinmajsikamatiltis Dios se tonati kijtos akin tlajtlakole iwa akin amó. ");
INSERT INTO nplNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","N Espíritu kinmajsikamatiltis kateh itech tlajtlakole akimeh amo nechneltokah. ");
INSERT INTO nplNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Noiwa kinmajsikamatiltis tlan yekmilawak. Porke Ne nio íwa Notajtsi iwa nomejwah ayakmó nonnechitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kinmajsikamatiltis Dios se tonati kijtos akin tlajtlakole iwa akin amó, porke akin tlanawatijtok itech nin tlaltíkpaktli, yokitlajtlakoltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Nikpia okachi tlan moneki nomechilis, pero axa amo weletis nonkajsikamatiskeh. ");
INSERT INTO nplNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ijkuak wits n Espíritu, Ye nomechmatiltis nochi tlan milák. Porke amo nomechmatiltis san tlan itech kisa, yej nomechmatiltis nochi tlan kikaki. Iwa nomechmatiltis nochi tlan satepa tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","N Espíritu kiteititis nomawistilis, ken kiselis tlan noaxka iwa nomechmatiltis. ");
INSERT INTO nplNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nochi tlan iaxka Notajtsi, noiwa noaxka. Yika onomechili n Espíritu, kiselis tlan noaxka iwa nomechmatiltis. ");
INSERT INTO nplNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","'Ayakmó wejkawas nonnechitaskeh, iwa satepa, oksepa nonnechitaskeh. Porke Ne nimuika inawak Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ijkuakó, sikimeh itlamachtijkawah omotlatlajtlanijkeh: —¿Tlan kijtosneki tlan techilia? Kijtoa sa kanaj kech tonati ayakmó tikitaskeh, iwa amo wejkawas oksepa tikitaskeh, noiwa kijtoa yas inawak Itajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Iwa okimoliayah: ¿tlan kijtosneki ijkuak kijtoa ke ayakmó wejkawas? Mach tikajsikamatih tlan kineki techilis. ");
INSERT INTO nplNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús okajsikama yejwah okinekiah kitlajtlaniskeh tlan kijtosneki tlan okinmili. Ijkuakó okinmili: —¿Nonmotlatlajtlaniah tlan kijtosneki ijkuak onikijto: Ayakmó wejkawas nonnechitaskeh, iwa satepa, oksepa nonnechitaskeh? ");
INSERT INTO nplNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","De milajka, de milajka nomechilia, nomejwah nonchokaskeh iwa nonmoyolkokoskeh, pero n tlaltikpaktlakah pakiskeh. Maya nonmoyolkokoskeh, nomoneyolkokol mokopas pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ijkuak se siwatl ya kipiati ikone, pewa motekipachoa porke yoajsiko ora mokokos. Pero satepa, ijkuak yotlákatki ikone, kilkawa itlaijyowilis iwa paki porke yotlákatki se konetl itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ijkó nomejwah, axa nonmoyolkokoah, pero Ne nomechitas oksepa, iwa nonpakiskeh, iwa non yolpakílistli, amaka weletis nomechkixtilis. ");
INSERT INTO nplNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","'Ijkuak ajsiki non tonati, ayakmitla nonnechtlajtlaniskeh. De milajka, de milajka nomechilia, Notajtsi nomechmakas nochi tlan nonkitlajtlaniliskeh ika Notoka. ");
INSERT INTO nplNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta axa nomejwah amitla nonkitlajtlaniliah ika Notoka. Xiktlajtlanikah ijkó nonkiseliskeh, ijkó nonkipiaskeh miak pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","'Nochi ni yonomechtlapowi ika tlapoálistli, pero ajsiki n tonati ijkuak ayakmó nomechtlapowis ijkó, yej nomechyekajsikamatiltis Akin Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Itech neká tonati nomejwah weletis itla nonkitlajtlaniliskeh Notajtsi ika Notoka. Ayakmó monekis Ne niktlajtlanilis Notajtsi por nomejwah. ");
INSERT INTO nplNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Notajtsi inewia nomechtlasojtla porke nomejwah nonnechtlasojtlah iwa ken nonkineltokah Ne niwalewatok de Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne oníkiski inawak Notajtsi iwa oniwala itech nin tlaltíkpaktli, iwa axa nikkajtewa nin tlaltíkpaktli iwa nimokopas inawak Notajtsi. ");
INSERT INTO nplNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ijkuakó itlamachtijkawah okilijkeh: —Axa kema yotikajsikamatkeh motlajtol, iwa ayakmó techtlapowia ika tlapoálistli. ");
INSERT INTO nplNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Axa ya tikmatih Tejwatsi nochi tikmati, iwa mach ok moneki se mamitstlajtlani itla. Yika tikneltokah Tejwatsi tiwalewatok de Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús okinnankili: —¿Axa kema ya nonnechneltokah? ");
INSERT INTO nplNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya ajsitiwits n ora iwa ayakmó wejkawas, ijkuak nomejwah nonmoxexeloskeh iwa nonyaskeh nomochajcha. Nonnechkajtewaskeh noselti. Pero Ne amo nika noselti, porke Notajtsi kajki nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nochi ni nomechilia, para xikpiakah yolsewílistli. Nomejwah nontlaijyowiskeh itech nin tlaltíkpaktli, pero amo ximosotlawakah porke Ne yoníktlanki akin kinawatia nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ijkuak Jesús otlanki otlajto, oajkotláchixki ilwikak iwa okijto: —Notajtsi, n ora yoajsiko. Xikweyijkatlali Mokone para ijkó Mokone noiwa mamitsweyijkatili. ");
INSERT INTO nplNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tejwatsi otechtlali manikinnawati nochteh n tlaltikpaktlakah, para manikinmaka yolílistli kan ilwikak nochteh akimeh otechinmák. ");
INSERT INTO nplNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tla mitsixmatiskeh sanwel Tejwatsi n de milajka Dios, iwa Cristo Jesús, Akin Tejwatsi otikwaltítlanki, kipiaskeh n yolílistli tlan ayik tlamis. ");
INSERT INTO nplNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Ne yonimitsweyili itech nin tlaltíkpaktli. Iwa yoniktlami n tekitl non otechnawati manikchiwa. ");
INSERT INTO nplNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Axa kiné, Notajtsi, techweyijkatili monawak, ika n weyílistli non onikpiaya monawak desde ijkuak ayamó okatka n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","'Ne yonikinmatilti Akin Tejwatsi akimeh Tejwatsi otikimpéjpenki itech nin tlaltíkpaktli. Yejwah okatkah moaxkawah, pero Tejwatsi otechinmaktili, iwa axa kineltokah motlajtol. ");
INSERT INTO nplNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Axa ya kimatih nochi tlan nikpia Tejwatsi otechmák. ");
INSERT INTO nplNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Porke nochi tlan Tejwatsi otechili, Ne yonikinmili, iwa yejwah yokineltokakeh. Iwa yokajsikamatkeh milák Ne niwalewatok monawak, iwa yokineltokakeh Tejwatsi otechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","'Ne nimitstlatlaujtia por yejwah. Amo nimitstlatlaujtia por oksikimeh tlaltikpaktlakah, yej por akimeh Tejwatsi otechinmák, porke moaxkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nochi tlan noaxka, noiwa moaxka, iwa tlan moaxka, noiwa noaxka, iwa noweyijkachiwalis monextia intech. ");
INSERT INTO nplNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Ne ayakmó niyetos itech nin tlaltíkpaktli porke ya nio mowa, pero yejwah ok mokawah itech nin tlaltíkpaktli. Noweyitajtsi, xikinmokuitlawi ika moweletilis non otechinmák, para mayekseititokah kemi Tejwatsi iwa Ne tiseititokeh. ");
INSERT INTO nplNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ijkuak Ne onikatka inwah itech nin tlaltíkpaktli, Ne onikinmokuitlawiaya ika moweletilis akimeh otechinmák, iwa onikimpalewiaya. Iwa nion se de yejwah omoixpolo, sanwel akin yomoixpolojka para mamochiwa tlan kijtoa itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","'Pero axa ya nio mowa, iwa nikijtoa nin tlájtoli ijkuak ok nika itech nin tlaltíkpaktli, para yejwah makipiakah miak pakílistli itech inyolo ijkó kemi Ne nikpia. ");
INSERT INTO nplNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne yonikinmatilti motlajtol notlamachtijkawah, pero n tlaltikpaktlakah kinkokoliah, porke yejwah ayakmó de nin tlaltíkpaktli. Ijkó kemi Ne amo de nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amo nimitstlatlaujtia xikinkixti de itech nin tlaltíkpaktli, yej xikinyekmokuitlawi para amo makinkajkayawa n amokualitlakatl. ");
INSERT INTO nplNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ijkó kemi Ne amo de nin tlaltíkpaktli, yejwah noiwa ayakmó de nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xikinyolchipawa ika motlajtol, motlajtol ye tlan milák. ");
INSERT INTO nplNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ijkó kemi Tejwatsi otechaltítlanki innawak n tlaltikpaktlakah, ijkó noiwa Ne nikintitlani innawak n tlaltikpaktlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ne yoniyéknenki por yejwah, para yejwah noiwa mayeknemikah por motlajtol non milák. ");
INSERT INTO nplNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","'Ne amo nimotlatlaujtia san por notlamachtijkawah, yej noiwa por non satepa tlaneltokaskeh nonawak, ijkuak notlamachtijkawah kitematiltiskeh notlajtol, ");
INSERT INTO nplNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","para maseititokah nochteh, ijkó kemi Tejwatsi iwa Ne tiseititokeh. Iwa yejwah noiwa maseititokah towah, para makitakah n tlaltikpaktlakah Tejwatsi otechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne yonikinmák n weyílistli non Tejwatsi otechmák, para ijkó yejwah maseititokah, ijkó kemi tejwah tiseititokeh. ");
INSERT INTO nplNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne niyetos intech, iwa Tejwatsi tiyetos notech, para ijkó yejwah de milajka maseititokah. Iwa ijkó n tlaltikpaktlakah makimatikah Tejwatsi otechaltítlanki, iwa milák tikintlasojtla ijkó kemi Tejwatsi techtlasojtla. ");
INSERT INTO nplNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'Notajtsi, akimeh Tejwatsi otechinmaktili, nikneki mayetokah nowa kan Ne niyetos, para makitakah momawistilis non otechmák, porke techtlasojtla desde ijkuak ayamó okatka n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Notajtsi yolmilajka, n tlaltikpaktlakah amó omitsixmatkeh. Pero Ne onimitsixma, iwa ninteh non kateh towah okimatkeh Tejwatsi otechaltítlanki. ");
INSERT INTO nplNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne onikinmatilti motoka, iwa ok nikinmatiltijtos, para n tlasojtlálistli non ika techtlasojtla mayeto intech iwa Ne niyetos intech. ");
INSERT INTO nplNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ijkuak Jesús otlanki okimijto ninteh tlájtolteh, okiski iwa itlamachtijkawah iwa oyajkeh ik nepa lado de n barranka de Cedrón. Ompa okatka se werto, Jesús iwa itlamachtijkawah ompa okalakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, akin kitemaktiskia n Jesús, noiwa okixmatia non lojar, porke Jesús iwa itlamachtijkawah miak welta ompa omoololoayah. ");
INSERT INTO nplNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ijkó kiné, Judas okinyakantiwalaya miakeh soldadojteh iwa sikimeh tlamokuitlawijkeh de n Weyi Tiopa. Ninteh okwalintitlankeh n tiopixkeh non tlayakantokeh iwa fariseos. Yejwah okwalinwikayah kuaujmeh non xotlatiwitseh iwa lintérnajteh iwa téposteh. ");
INSERT INTO nplNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús yokimatia nochi tlan mochiwaskia, yika okinyakanamikito iwa okinmili: —¿Akin nonkitemoah? ");
INSERT INTO nplNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yejwah okinankilijkeh: —Tiktemojtiwitseh n Jesús de Nazaret. Ye okinmili: —Ne Ni Jesús. Noiwa ompa omoketoka n Judas non okitemaktijtoka n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ijkuak Jesús okinmili: “Ne Ni Jesús”, yejwah otsinkiskeh iwa oajketiajkeh owetsito ipan tlali. ");
INSERT INTO nplNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ijkuakó Jesús oksepa okintlajtlani: —¿Akin nonkitemoah? Yejwah okilijkeh: —Tiktemoah n Jesús de Nazaret. ");
INSERT INTO nplNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús oksepa okinmili: —Yonomechili Ne Ni Jesús. Tla Ne nonnechtemoah, xikinkawilikah mawiah ninteh. ");
INSERT INTO nplNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ijkó okijto para mamochiwa tlan Jesús okijtojka: “Akimeh Tejwatsi otechinmák, nion se omoixpolo.” ");
INSERT INTO nplNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ijkuakó Pedro okwalkópinki iespada iwa okitekili inakas non iyekma n Malco, itékitki n tiópixki non okachi otlayakantoka. ");
INSERT INTO nplNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús okili n Pedro: —¡Xiktlaati moespada! Notajtsi kineki manikpano nin tlaijyowílistli, moneki ijkó manipano maya tekoko. ");
INSERT INTO nplNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ijkuakó n kapita, iwa isoldadojwah, iwa n soldádojteh non kimokuitlawiah n Weyi Tiopa, okikitskijkeh n Jesús, okimailpijkeh iwa okiwikakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Achto okiwikakeh inawak Anás porke okatka imonta n Caifás. Nin Caifás okatka weyi tiópixki non xiwitl. ");
INSERT INTO nplNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nin Caifás yokintlatlalwijka non de Sanedrín okachi kuali mamiki sanwel se tlakatl, iwa amo nochteh n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro iwa n ok se imomachti san wejka okwaltokayah n Jesús. Non ok se imomachti omoixmatia iwa n weyi tiópixki Anás, yika ye okalak kan okiwikakeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero n Pedro omoka san kaltempa. Yika, non ok se imomachti non omixmatia iwan weyi tiópixki, omotlapowi iwan siwatl non okimokuitlawiaya n kaltentli iwa okili makikalaki n Pedro. ");
INSERT INTO nplNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ijkuakó n siwatl okitlajtlani n Pedro: —¿Amo te noiwa imomachti non tlakatl? Pedro okinankili: —Amó, mach ne. ");
INSERT INTO nplNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","N tlakewalteh iwa n tlamokuitlawijkeh okitlalijkeh se tlékuili porke osewaya, iwa omototonijtokah. Pedro noiwa omijkuani inakastla n tlékuili. ");
INSERT INTO nplNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","N weyi tiópixki Anás, opé kitlatsintokia Jesús akimeh itlamachtijkawah iwa tlan okinmachtiaya. ");
INSERT INTO nplNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús okinankili: —Ne onikintlapowiaya inmixpa nochteh n tlakah. Ne ixmostla onitemachtiaya itech sinagogas iwa kan toweyi Tiopa kan moololoah nochteh n judíojteh, iwa amitla san ichtaka oniktemachti. ");
INSERT INTO nplNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tleka Ne techtlatlajtlania? Xikintlajtlani akimeh onechkakeh, iwa yejwah mamitsilikah tlan onikinmiliaya. Yejwah kuali kimatokeh tlan onikijto. ");
INSERT INTO nplNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ijkuak Jesús ijkí okijto, se non kimokuitlawia de n Weyi Tiopa, okiixtlatsini iwa okili: —¿Ijkó tiknankilia n weyi tiópixki? ");
INSERT INTO nplNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús okinankili: —Tla onikijto itla amokuali, techili. Pero tla onikijto tlan milák, ¿tleka techixtlatsinia? ");
INSERT INTO nplNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ijkuakó Anás okitítlanki n Jesús maijilpiti inawak Caifás n weyi tiópixki. ");
INSERT INTO nplNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro ok omoketoka inakastla n tlékuili iwa ompa okitlajtlanijkeh: —¿Amo te noiwa se de itlamachtijkawah? Pedro mach okimokuiti, iwa okijto: —Amó, mach ne. ");
INSERT INTO nplNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ijkuakó se itlákau n weyi tiópixki non ken okitaya n tlakéwale akin Pedro okinakastsontek, okitlajtlani: —¿Amo te noiwa onimitsitak iwan Ye, kan werto? ");
INSERT INTO nplNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro oksepa okijto amo kixmati, iwa san nima se kaxtil otlakuík. ");
INSERT INTO nplNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ijkuakó okiskeh icha n Caifás iwa okiwikakeh n Jesús ichan Poncio Pilato. Iwa ken yotlanestiwalaya n judíojteh amo okalakeh icha n Pilato para amo moyolijtlakoskeh. Yejwah okinekiah yetoskeh yolchipawakeh ijkuak kikuaskeh n tlákuali de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ijkuakó Pilato owálkiski, iwa okinmili: —¿Tleka nonkiteiliah nin tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yejwah okinankilijkeh: —Tla nin tlakatl amo kichijtinemiskia tlan amokuali, mach timitsmaktiliskiah. ");
INSERT INTO nplNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ijkuakó Pilato okinmili: —Xikwikakah iwa nomejwah xiktlajtlakoltikah kemi kijtoa nomotlanawatil. N tlayakankeh judíojteh okilijkeh: —Nomotlanawatilis amo techkawilia aka matikmiktikah. ");
INSERT INTO nplNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ijkó otlamochi kemi Jesús okijtojka kenomi mikiskia. ");
INSERT INTO nplNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato oksepa okalak kan palasio. Okínotski n Jesús iwa okitlajtlani: —¿Te tirey de judíojteh? ");
INSERT INTO nplNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús okinankili: —¿Tlan techtlajtlania, motech kisa, noso san por oksikimeh omitstlapowijkeh de Ne? ");
INSERT INTO nplNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato okinankili: —¡Ne mach ni judío! Innewiah mokniwah iwa n tiopixkeh non tlayakantokeh nomak omitstemaktijkeh. ¿Tlan otikchi? ");
INSERT INTO nplNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ijkuakó Jesús okinankili: —Notekiwajyo amo kajki itech nin tlaltíkpaktli. Porke tla ijkó yetoskia, notlakawah motekilmakaskiah para amo manechtemaktikah inmak n judíojteh. Pero Ne amo nitlanawatia nika. ");
INSERT INTO nplNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ijkuakó Pilato okili: —Tla ijkó, ¿te tirey? Jesús okinankili: —Ne Ni Rey ijkó kemi te yotikijto. Ne onitlákatki para nietos Ni Rey iwa oniwala itech nin tlaltíkpaktli para niktematiltis tlan milák. Nochteh akimeh kixmatih iwa kijtoah tlan milák, weleti kikakih notlajtol. ");
INSERT INTO nplNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato okitlajtlani: —¿Tlan kijtosneki milák? Ijkuak Pilato ijkó okitlajtlani n Jesús, oksepa okiski okintlapowito n judíojteh, iwa okinmili: —Ne amo nikkajsi nion se tlajtlákoli itech nin tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero nomejwah ya nonkimatokeh trato nikkajkawa seme de nontsaktokeh itech ilwitl de Paskua. ¿Nonkinekih manikkajkawa n Rey de Israel? ");
INSERT INTO nplNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ijkuakó, nochteh otsajtsikeh: —¡Ye amó! ¡Xikkajkawa n Barrabás! Nin Barrabás okatka tlachtek iwa okimpajsoloaya n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ijkuakó Pilato otlanawati makiwitekikah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","N soldadojteh okichijchiwilijkeh se korona ika witstli iwa okitlalilijkeh itech itsonteko, iwa okikentilijkeh se kapa chichiliktik. ");
INSERT INTO nplNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iwa omijkuaniayah inawak Jesús iwa okiliayah: —¡Timitsweyiliah, Rey de judíojteh! Iwa okixtlatsiniayah. ");
INSERT INTO nplNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato oksepa owálkiski iwa okinmili: —Techkakikah, nika onikkixti para xikmatikah amo nikkajsi itech Ye itla amo kuali. ");
INSERT INTO nplNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ijkuak Jesús okiski, okiwikaya ipan itsonteko n korona non okichijchijkeh ika witstli, noiwa okiwikaya n kapa chichiliktik. Ijkuakó Pilato okinmili: —¡Xiktakah, nika kajki n tlakatl! ");
INSERT INTO nplNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ijkuak okitakeh n tiopixkeh non tlayakantokeh iwa n soldadojteh non kimokuitlawiah n Weyi Tiopa, opé tsajtsih: —¡Xikkrusifikaro, xikkrusifikaro! Pilato okinmili: —Xikwikakah nomejwah, iwa xikkrusifikarokah, porke ne amo nikajsi tlan ika niktlajtlakoltis. ");
INSERT INTO nplNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero n tlayakankeh judíojteh okinankilijkeh: —Tejwah tikpiah se tlanawátili, iwa non tlanawátili kijtoa mamiki non tlakatl, porke Ye inewia omotene Ikone Dios. ");
INSERT INTO nplNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ijkuak Pilato okikak tlan okilijkeh, okachi omaujki. ");
INSERT INTO nplNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilato oksepa okalak kan palasio iwa okitlajtlani n Jesús: —¿Te, de kani tiwits? Pero Jesús mach okinankili. ");
INSERT INTO nplNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ijkuakó Pilato okili: —¿Amo technankilis? ¿Mach amo tikmati ne weletis nikimilis mamitskrusifikarokah noso mamitskajkawakah? ");
INSERT INTO nplNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús okinankili: —Mach weletis titlanawatiskia notech tla Dios amo mitsmakaskia non tekiwajyotl. Yika, akin momak onechtemakti, okachi tlajtlakole ke te. ");
INSERT INTO nplNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato okitemoliaya kenijki kikajkawas n Jesús, pero n tlayakankeh judíojteh okachi otsatsajtsiah: —¡Tla tikkajkawas non tlakatl, tikixpanawis n César, porke akin motenewa rey, kijtosneki kikokolia n César! ");
INSERT INTO nplNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ijkuak Pilato okinkak ninteh tlájtolteh, okikixti n Jesús, iwa Pilato omotlali kan tlaixkomaka, itech se lojar non itoka Tlateyotitok non itech tlájtoli hebreo itoka Gábata. ");
INSERT INTO nplNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Non tonati yomotlatlalijtokah para n ilwitl de Paskua, ijkuakó yokatka kemi tlajko tonati, Pilato okinmili n judíojteh: —¡Nikan kajki nomorey! ");
INSERT INTO nplNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iwa yejwah otsajtsikeh: —¡Xikixti! ¡Mamiki! ¡Xikkrusifikaro! Pilato okinmili: —¿Nonkinekih manikkrusifikaro nomorey? Pero n tiopixkeh non tlayakantokeh otlanankilijkeh: —¡Tejwah mach tikpiah ok se rey, sanwel César! ");
INSERT INTO nplNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ijkuakó Pilato okinmaktili n Jesús para makikrusifikarokah, iwa yejwah okiwikakeh. ");
INSERT INTO nplNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ijkuak Jesús okiski de Jerusalén, okimamajtiaya ikrus imilajkayo n lojar non itoka Miketsontekomatl, non itech tlájtoli hebreo omonotsaya Gólgota. ");
INSERT INTO nplNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ompa okikrusifikarojkeh n Jesús iwa n ok ome tlakah ik inajnakastla. ");
INSERT INTO nplNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato okichijchi se tlajkuíloli iwa otlanawati makitlalilikah ik ikuatsontla. N tlajkuíloli okijtoaya: “Jesús de Nazaret, Rey de judíos.” ");
INSERT INTO nplNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Miakeh judíojteh okiamapoah, porke kan okikrusifikarojkeh n Jesús amo wejka de Jerusalén, iwa oijkuilitoka itech tlájtoli hebreo, latín iwa griego. ");
INSERT INTO nplNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yika n tiopixkeh non tlayakantokeh okilijkeh n Pilato: —Amo xikijkuilo “Rey de judíojteh”; yej xikijkuilo “Akin motenewa Rey de judíojteh.” ");
INSERT INTO nplNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato okinnankili: —Tlan yonikijkuilo, yonikijkuilo. ");
INSERT INTO nplNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ijkuak n soldadojteh yokikrusifikarojkeh n Jesús, nawi okinmoxexelilijkeh itlakenwah. Pero kemi imanto oseititoka ");
INSERT INTO nplNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","n soldadojteh okimolijkeh: —Amo matiktsomonikah, yej matikawiltikah, san akin kitlanis. Ijkó omochi tlan oijkuilitoka itech itlajkuilol Dios: “Okinmoxexelilijkeh notlakenwah, iwa okimotlatlanilijkeh nomanto.” Iwa ijkó okichijkeh n soldadojteh. ");
INSERT INTO nplNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iwa inakastla ikrus n Jesús, okatka imamá, iwa iwelti imamá, María isiwa n Cleofas, iwa n María de Magdala. ");
INSERT INTO nplNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ijkuak Jesús okitak imamá inakastla itlamachtijkau Juan, okili imamá: —Siwatl, ompa kajki mokone. ");
INSERT INTO nplNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Otlanki okili n Juan: —Xikita, ompa kajki momamá. Desde ijkuakó itlamachtijkau okiseli icha. ");
INSERT INTO nplNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Satepa, ijkuak Jesús okitak nochi iteki yomochi, iwa para mamochiwa tlan kijtoa itlajkuilol Dios, Ye okijto: —¡Niamiki! ");
INSERT INTO nplNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ompa okatka se tekontsi non okipiaya vinagre. Yejwah okipolakijkeh se esponja itech non vinagre, okitsekojkeh itech se kuawitl de isopo iwa okimakakeh n Jesús makoni. ");
INSERT INTO nplNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ijkuak Jesús okiyeko n vinagre okijto: —¡Nochi yomochi! Omokuatolo iwa omikki. ");
INSERT INTO nplNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Se tonati achto de n ilwitl de Paskua, n judíojteh amo okinekiah mamokawakah n kuerpojteh itech krus itech sábado, porke okatka weyi tonati. Yika okitlatlautijkeh n Pilato makinmetspostekikah akimeh okinkrusifikarojkah, iwa makinmachiwakah. ");
INSERT INTO nplNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ijkuakó n soldadojteh oyajkeh okinmetspostekitoh akimeh okrusifikaritokah inajnakastla n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero ijkuak omijkuanijkeh inawak Jesús, kemi okitakeh yomikki, ayakmó okimetspostekeh. ");
INSERT INTO nplNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero seme de n soldadojteh okikespantsopiti ika se kuawitl yakawitstik, iwa sanima okiski estli iwa atl. ");
INSERT INTO nplNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ne nonewia onikitak nochi ni, iwa tlan nomechmatiltia milák. Nikmatok tlan nikijtoa milák, para nomejwah noiwa xitlaneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nochi ni otlamochi kemi kijtoa itlajkuilol Dios: “Nion se iomio kipostekiliskeh.” ");
INSERT INTO nplNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Noiwa oksika kijtoa: “Kitaskeh akin okikespantsopitijkeh.” ");
INSERT INTO nplNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Satepa, José de Arimatea okitlatlaujtito n Pilato makikawili makiwika ikuerpo Jesús. Nin José okatka imomachti n Jesús san ichtaka porke okinmawiliaya n tiopixkeh judíojteh. N Pilato okikawili n José makiwika n kuerpo. ");
INSERT INTO nplNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Noiwa Nicodemo non se yúali omotlapowito iwan Jesús, okalakito kan okatka ikuerpo Jesús iwa okiwikaya kemi sempóali iwa n májtlaktli (30) kilo ajwiajkayotl non okichijchijkeh ika mirra iwa áloe. ");
INSERT INTO nplNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Okitemowijkeh ikuerpo Jesús iwa okikekemelojkeh ika tsótsolteh non okinmajwialijkeh kemi kichiwah n judíojteh ijkuak okintookayah inmikenwah. ");
INSERT INTO nplNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kan okikrusifikarojkeh n Jesús okatka se werto, iwa itech non werto okatka se yankuik miketékochtli, kan ayamaka okitookayah. ");
INSERT INTO nplNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ompa okitookakeh n Jesús porke n miketékochtli amo wejka okatka de Jerusalén iwa n weyi tonati yowalajsia. ");
INSERT INTO nplNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","N domingo, semi kuinal ijkuak ok otleyuatoka, María de Magdala oyá kan okitookakeh n Jesús. Iwa ijkuak okalakito, okitak yokachijkeh n tetl non okikamatsaktoka n miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ijkuakó omotlelo María iwa oyá kan okatka n Pedro iwa n Juan non Jesús okitlasojtlaya, iwa okinmili: —Yokiwikakeh ikuerpo n Toteko Jesús de kan miketékochtli, iwa amo tikmatih kan okikawatoh. ");
INSERT INTO nplNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro iwa Juan okiskeh iwa oyajkeh okitatoh n miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Sansikah omotleloayah, pero Juan okachi omotlelo ke Pedro iwa achto okalakito kan miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Juan oontláchixki tlaijtik, iwa okimitak n tsótsolteh ompa okatkah, pero mach okalak. ");
INSERT INTO nplNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","San nima okalakiko n Pedro iwa okalaktíwetski kan miketékochtli. Ye noiwa okimitak n tsótsolteh ompa okatkah, ");
INSERT INTO nplNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","iwa n mantajtsótsoli non ika okuakemelitoka n Jesús, ixkoya okatka. ");
INSERT INTO nplNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ijkuakó Juan okalak kan miketékochtli, iwa ijkuak okitak, otlaneltokak. ");
INSERT INTO nplNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Porke achto, ayamó okajsikamatiah itlajkuilol Dios, Jesús moyolitiskia de kan mikemeh. ");
INSERT INTO nplNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ijkuakó imomachtijkawah omokopkeh inchajcha. ");
INSERT INTO nplNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María de Magdala omoka kaltempa chokatok inakastla n miketékochtli. Keman ochokatoka oontláchixki ijtik n miketékochtli, ");
INSERT INTO nplNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","okimitak ome ángelteh ika intlakeh istak, ninteh ángelteh oewatokah kan achto owilantoka ikuerpo Jesús, se ik ikuatsontla iwa ok se ikxitla. ");
INSERT INTO nplNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","N ángelteh okitlajtlanijkeh: —Siwatl, ¿tleka tichoka? Ye okinmili: —Porke okiwikakeh ikuerpo Noteko iwa amo nikmati kan okikawatoh. ");
INSERT INTO nplNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ijkuak ijkó okinmili, omókopki iwa okitak n Jesús ompa moketok, pero amo okixma kox ye n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ijkuakó Jesús okitlajtlani: —Siwatl, ¿tleka tichoka? ¿Akin tiktemoa? María okimoli chamo non tlakatl ye non okimokuitlawiaya n werto, iwa okili: —Tata, tla otikwik ikuerpo, techili kan otikkawato, iwa ne nikwikas. ");
INSERT INTO nplNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ijkuakó Jesús okili: —¡María! Ye omokoptíwetski iwa okili ika tlájtoli hebreo: —¡Raboni! —non tlájtoli kijtosneki Tlamachti. ");
INSERT INTO nplNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús okili: —¡Amo techtsakuili!, porke ayamó nitlejko íwa Notajtsi. Pero xio xikinmiliti nokniwah nitlejkos íwa Notajtsi, Akin noiwa Nomotata, íwa Nodios, akin noiwa Nomodios. ");
INSERT INTO nplNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ijkuakó María de Magdala okinmatiltito n momachtijkeh nik ye okitak Inteko, iwa Ye okinmili nochi ni. ");
INSERT INTO nplNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ijkuak otiotlatik, itlamachtijkawah n Jesús oololitokah iwa omokaltsakeh porke okinmawiliayah n judíojteh. Ijkuakó Jesús okalak iwa omoketsato tlatlajkotia iwa okinmili: —¡Xikpiakah yolsewílistli! ");
INSERT INTO nplNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ijkuak ijkó okinmili, okimititi imawah iwa ikespa. Yejwah opakeh porke oksepa okitakeh Inteko. ");
INSERT INTO nplNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús oksepa okinmili: —¡Xikpiakah yolsewílistli! Kemi Notajtsi onechtítlanki, ijkó Ne nomechtitlani. ");
INSERT INTO nplNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ijkuak ijkí okijto, okinmíjpitski iwa okinmili: —Xikselikah n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Akimeh nonkintlapojpolwiliskeh intlajtlakolwah, mokawaskeh chipawakeh. Pero akimeh amo nonkintlapojpolwiliskeh intlajtlakolwah, mokawaskeh itech tlajtlákoli. ");
INSERT INTO nplNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, seme de n májtlaktli iwa ome itlamachtijkawah, non okiliayah kuatsi, amo ompa okatka iwan oksikimeh itlamachtijkawah ijkuak owala n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Satepa, n oksikimeh imomachtijkawah okilijkeh n Tomás: —Yotikitakeh n Toteko Jesús. Pero Tomás okinmili: —Tla amo nikimitas imawah iwa tla amo nikkalakis nomajpil kan okintsoponilijkeh n klavos, iwa nikkalakis noma ikespa, ayik nikneltokas. ");
INSERT INTO nplNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chikweyi tonati satepa, itlamachtijkawah oksepa okaltsaktokah, iwa Tomás noiwa ompa okatka. Maya n kaltentli otsaktoka, Jesús okalak iwa omóketski tlatlajkotia iwa okinmili: —¡Xikpiakah yolsewílistli! ");
INSERT INTO nplNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Otlanki okili n Tomás: —Nika xiktlali momajpil, iwa xikinmita nomawah. Xikijkuani moma iwa xikkalaki kan nokespa. Iwa sansemi xitlaneltoka. ");
INSERT INTO nplNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ijkuakó Tomás okili: —¡Noteko iwa Nodios! ");
INSERT INTO nplNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús okili: —Tomás, otitlaneltokak porke otechitak. ¡Miak pakílistli kipiaskeh akimeh amo onechitakeh, iwa nechneltokaskeh! ");
INSERT INTO nplNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús okinchi ok miaktikeh milagrojteh inmixpah itlamachtijkawah non amo ijkuilitokeh itech nin amatlajkuíloli. ");
INSERT INTO nplNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero nin tlajkuíloli omoijkuilo para xikneltokakah Jesús Ye n Cristo Ikone Dios. Iwa tla nomejwah nonkineltokaskeh, nonkipiaskeh yolílistli ika Itoka. ");
INSERT INTO nplNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Satepa, Jesús oksepa okinmonextili itlamachtijkawah itempa n lago de Tiberias. Iwa ijkí okinmonextili: ");
INSERT INTO nplNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ompa sansikah okatkah Simón Pedro, Tomás non okiliayah kuatsi, Natanael non de Caná de Galilea, itelpochwah n Zebedeo iwa n ok ome itlamachtijkawah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Iwa Simón Pedro okinmili: —Nio nimichmati. Yejwah okinankilijkeh: —Tejwah noiwa tiawih mowa. Yejwah otlejkokeh itech se barka iwa omichmaatoh, pero non yúali amitla michi okikitskijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ijkuak yotlanestiwalaya, Jesús omoketsato itempa n lago, pero itlamachtijkawah amo okimatiah kox Ye n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ijkuakó okinmili: —Nopilwah, ¿nonkipiah siki michi? Yejwah okinankilijkeh: —Amó. ");
INSERT INTO nplNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ijkuakó Jesús okinmili: —Xikontlamotlakah n michayatl iyekma n barka iwa nonkinmajsiskeh michimeh. Yejwah ijkó okichijkeh, iwa ayakmó oweletiah okikixtiayah n michayatl, porke miaktikeh michimeh okinkitskijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ijkuakó Juan non Jesús okitlasojtlaya okili n Pedro: —¡Ye n Toteko Jesús! Ijkuak Simón Pedro okikak Ye n Jesús, okimotlalili itlakeh porke okatka xipetstik iwa onmotlamotlak ijtik atl. ");
INSERT INTO nplNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","N oksikimeh itlamachtijkawah okalakitoh itempa n atl itech barka sa kitilantiwih n michayatl tentiwits ika michimeh, porke sa kanaj mákuili poali metro okatkah itempa n atl. ");
INSERT INTO nplNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ijkuak okiskeh, okitakeh siki tlekúyoli xotlatok, iwa ikpak okatka michi, iwa paj. ");
INSERT INTO nplNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús okinmili: —Xikualinwikakah sikimeh michimeh non sikin ononkinkixtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro otlejkok kan barka iwa okitilantia asta itempa n lago n michayatl tenti ika se siento iwa n tlajko iwa n eyi (153) wejweyi michimeh. Iwa maya n michimeh okatkah miaktikeh n michayatl amo okojkótonki. ");
INSERT INTO nplNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ijkuakó Jesús okinmili: —Ximotlamajsewikih. Nion se itlamachtijkau omixewi okitlajtlani Akin Ye, porke yokimatiah Ye Jesús. ");
INSERT INTO nplNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Otlanki Jesús owalmijkuani, okónanki n paj iwa okinmajmák itlamachtijkawah, iwa noijkó okichi iwa n michimeh. ");
INSERT INTO nplNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ika ni ya eyi welta okinmonextili itlamachtijkawah satepa de omoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ijkuak yotlankeh omotlamajsewijkeh, Jesús okili n Simón Pedro: —¿Simón ipiltsi n Juan, techtlasojtla okachi ke ninteh? Pedro okinankili: —Noteko Tejwatsi kuali tikmatok nimitsneki. Jesús okili: —Techinmokuitlawili noichkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús oksepa okitlajtlani: —Simón ipiltsi n Juan, ¿techtlasojtla? Pedro okinankili: —Noteko, Tejwatsi kuali tikmatok nimitsneki. Jesús oksepa okili: —Techinmokuitlawili noichkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús okitlajtlani ipan eyi welta: —¿Simón Pedro ipiltsi n Juan, techneki? Pedro omoyolkoko porke Jesús ayakmó okitlajtlani techtlasojtla ipan eyi welta, porke sa iksemi okitlajtlani kox okinekia. Pedro okinankili: —Noteko, Tejwatsi kuali tikmatok nimitsneki. Jesús okili: —Techinmokuitlawili noichkawah. ");
INSERT INTO nplNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","De milajka, de milajka nimitsilia, ijkuak otikatka titélpochtli, te monewia otikonakiaya motlake, iwa otiaya san kan ik te otiknekia. Pero ijkuak tiwewejtis, sa tikinmajkokuis momawah iwa ok se mitstlalilis motlakeh iwa mitswikas kan amo tiknekis tias. ");
INSERT INTO nplNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ijkuak Jesús ijkó okijto, okinekia kajsikamatiltis n Pedro kenijki mikiskia iwa ijkó kiweyiliskia Dios. Satepa okili: —Xiwiki nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ijkuak Pedro owalmókopki okitak okwalintokaya itlamachtijkau akin Jesús okitlasojtlaya. Ye omonakasikték itech ielpa ijkuak okimomajsewijtokah n yualtlákuali de Paskua iwa okitlajtlanijka akin kitemaktiskia. ");
INSERT INTO nplNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ijkuak Pedro okitak itlamachtijkau n Jesús, okitlajtlani: —Noteko, iwa nin tlakatl, ¿tlan mochiwas? ");
INSERT INTO nplNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús okinankili: —Tla Ne nikmonekiltis mamokawa asta ijkuak Ne niwalmokopas, te mach moteki. Te xiwiki nowa. ");
INSERT INTO nplNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ijkuakó non tlájtoli opé momati itech nochteh non okineltokakeh, iwa okijtoayah non imomachtijkau amo mikiskia. Pero Jesús amo okijto amo mikiskia, Ye okijto: “Tla Ne nikmonekiltis mamokawa asta ijkuak Ne niwalmokopas, te mach moteki.” ");
INSERT INTO nplNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ye nin imomachtijkau akin tetlapowia de tlan otlamochi iwa nika okijkuilo. Iwa tejwah kuali tikmatokeh kijtoa tlan milák. ");
INSERT INTO nplNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iwa okachi miak onka tlan okichi n Jesús. Tla mijkuiloskia nochi tlan Ye okichi, n tlajkuílolteh amo akiskiah itech nin tlaltíkpaktli.");
INSERT INTO nplNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Noknitsi Teófilo non saikpanoa tiweyixtok: Itech non sikinika noamatlajkuilol, onikijkuilo nochi tlan Jesús okichi iwa otlamachti desde ijkuak okipewalti iteki, ");
INSERT INTO nplNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta n tonati ijkuak otlejkok ilwikak. Ijkuak ya muikaskia, ika iweletilis n Espíritu Santo okimpéjpenki itlatitlanilwah iwa okinnawatijtewak tlan kichiwaskiah. ");
INSERT INTO nplNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Satepa ijkuak yomoyoliti, Jesús inewia okinmonenextili ipan ome póali tonatijmeh itlatitlanilwah, para makitakah Ye milák yolitok, iwa okintlapowiaya kenijki Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ijkuak okatka iwa itlatitlanilwah, Jesús okinnawati amo mawiah de Jerusalén. Iwa okinmili: —Xikchiakah mamochiwa tlan Notajtsi Dios onomechili, ijkó kemi Ne noiwa yonomechili. ");
INSERT INTO nplNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Milák, Juan otlakuaateki ika atl, pero sa kanaj kech tonati, Dios nomechkuaatekis ika Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Akimeh okatkah iwan Jesús, okitlajtlanijkeh: —Tejwatsi, ¿axa tikinmakixtis n tlaltikpaktlakah de Israel iwa tikinmakas se tlanawati? ");
INSERT INTO nplNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús okinnankili: —Nomejwah mach nomoteki tlan tonati noso kemania Totajtsi Dios kichiwas iteki. Sanwel Ye tlanawatia itech nochi tlan kichiwa. ");
INSERT INTO nplNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ijkuak n Espíritu Santo wits nomotech, nonkiseliskeh weletílistli iwa nonyaskeh nontetlapowitiweh notlajtol itech Jerusalén, Judea, Samaria; iwa itech nochi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ijkuak Jesús yotlanki okinmili nin tlájtoli, yejwah ok okontlajtlatokah, Jesús opé moajkokui iwa okitakeh kenijki okiwikakeh ilwikak. Iwa san nima se mextli okwalmókenki, iwa ayakmó okitakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yejwah okitlajtlatokah n Jesús kenomi otlejkotiaya ilwikak. Ijkuakó ome tlakah non otlakentitokah ika intlakeh istak owalmonextijkeh innakastla. ");
INSERT INTO nplNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yejwah okimilijkeh: —Tlakah de Galilea, ¿tleka ononmokajkeh nontlachixtokeh ilwikak? Nin Jesús Akin okatka nomowah iwa yokiwikakeh ilwikak, oksepa walmokopas ijkó kemi ononkitakeh oyá. ");
INSERT INTO nplNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ijkuakó itlatitlanilwah owaltemokeh de kan olivostepetl onejnentiajkeh sanwel se kilómetro iwa okalakitoh Jerusalén. Intlanawatilis okinkawiliaya n judíojteh manejnemikah san achó itech sábado. ");
INSERT INTO nplNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ijkuak oajsitoh Jerusalén, okalakeh itech kali iwa otlejkokeh kan omokalotiaya. Ompa okatka: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo ipiltsi n Alfeo, Simón n Zelote (Kananista) iwa Judas itelpoch n Jacobo. ");
INSERT INTO nplNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yejwah iwa oksikimeh siwameh omoololoayah nochi tonati iwa motiotsajtsiliskeh. Noiwa ompa okatkah, María imamá n Jesús iwa ikniwah n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Se tonati ompa okatkah kemi chikwase póali (120) tokniwah non okineltokayah Cristo Jesús. Pedro omóketski tlatlajkotia, iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Nokniwah, techkakikah yowejka n rey David okijkuilo tlan okili n Espíritu Santo, tlan Judas kichiwaskia, ijkuak okinyákanki akimeh okikitskijkeh n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas towa okatka, noijki towah otekitia. ");
INSERT INTO nplNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero tikmatokeh ika non tomi non okimakakeh ika tlan amokuali okichi, okiko se tlali. Iwa owetski ika itsonteko iwa otlalaxtsáyanki iwa ochitonkeh ikuitlaxkolwah. ");
INSERT INTO nplNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ijkuak non ochantitokah Jerusalén okimatkeh, non tlali okitlalilijkeh itoka Hacéldama, non itech tlájtoli hebreo kijtosneki: Tlali de estli. ");
INSERT INTO nplNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Porke itech n Salmos ijkí kijtojtok: Icha mamokawa iselti, iwa amaka ompa machanchiwa. Iwa itech ok se Salmo kijtoa: Ok se makonanili iteki. ");
INSERT INTO nplNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","'Nika kateh sikimeh tlakah non otechwikatinenkeh nochipa ijkuak n Toteko Jesús onentinemia towah, ");
INSERT INTO nplNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde ijkuak Juan okikuaateki n Jesús iwa asta ijkuak otlejkok ilwikak. Yika moneki seme de yejwah matechmoseitili, iwa sansikah matitetlapowikah Jesús yomoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ijkuakó okimpejpenkeh ome: José non okinotsayah Barsabás, akin noiwa okiliayah Yolmilajka, iwa Matías. ");
INSERT INTO nplNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iwa ijkí omotiotsajtsilijkeh: —Toteko Dios, Tejwatsi tikmati tlan kipixtokeh itech inyolo nochteh n tlakah. Techajsikamatilti katlie de ninteh ome tlakah yotikmopejpenili, ");
INSERT INTO nplNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para makichiwa n tekitl non Judas okika, porke ye oyá kan inewia okimotlanili. ");
INSERT INTO nplNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ijkuakó okipejpenkeh sawel se, iwa okítlanki Matías, akin san nima non tonati omoseitili iwa oksikimeh májtlaktli iwa n se tlatematiltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ijkuak oajsiko n ilwitl de Pentecostés, nochteh non okineltokakeh n Cristo Jesús okatkah sansikah itech se kali. ");
INSERT INTO nplNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","San nima owaltlatékuinki kan ilwikak, kemi ijkuak tlaxojpitsa se ejekatl chikaktik, iwa omonawaloti ijtik nochi n kali kan yejwah oewatokah. ");
INSERT INTO nplNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ijkuakó okinmonextilijkeh sikimeh kemi nenépilteh milintokeh non omoxexelojkeh impah nochteh. ");
INSERT INTO nplNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iwa nochteh okiselijkeh n Espíritu Santo, iwa opé tlajtoah ika tlatlamanteh tlájtolteh. Iwa okijtoayah tlan n Espíritu Santo okinmiliaya makijtokah. ");
INSERT INTO nplNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Itech nonteh tonatijmeh, ompa Jerusalén okatkah miakeh judíojteh non satlawel okimopantiayah itlanawatil Moisés. Ninteh judíojteh owalajkeh de nochi lado de nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ijkuak okikakeh non tlatekuinílistli, san nima owalmoololojkeh miakeh tlakah, iwa mach ok okimatiah tlan kijtoskeh, porke yejwah opé kikaki kintlapowiah ika intlajtol. ");
INSERT INTO nplNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yejwah satlawel omotlajtlachialtijkeh, iwa okijtojkeh: —¿Amo de Galilea nochteh ninteh non tlajtojtokeh? ");
INSERT INTO nplNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tleka kiné, tikinkakih tlajtoah ika totlajtol non tejwah ipan otitlakatkeh? ");
INSERT INTO nplNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nika kateh sikimeh tlakah de Partia, de Media, de Elam, de Mesopotamia, de Judea, de Capadocia, de Ponto iwa de Asia, ");
INSERT INTO nplNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","de Frigia iwa de Panfilia, de Egipto iwa de tlalmeh de África, non kateh okachi tlayakapa de Cirene. Nika noiwa chantitokeh sikimeh tlakah de Roma. ");
INSERT INTO nplNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Noiwa nika kateh sikimeh tlakah non owalajkeh de Creta iwa de Arabia. Iwa ika tejwah totlajtol tikinkakih kenijki yejwah kimijtoah n milagros non Dios yokinchi. ");
INSERT INTO nplNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nochteh san omotlajtlachialtiayah iwa mach okimatiah tlan kijtoskeh, iwa omotlatlajtlaniayah: —¿Tlan kijtosneki nochi ni? ");
INSERT INTO nplNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero oksikimeh san otepijpinawiayah, iwa okijtoayah: —¡Ninteh tlakah wintitokeh! ");
INSERT INTO nplNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ijkuakó Pedro omóketski iwa n májtlakteh iwa n se tlatematiltijkeh, iwa chikawak opé tlajtoa: —Judíos iwa nochteh akimeh nonchanchijtokeh nika Jerusalén, xikmatikah nochi ni, iwa kuali xikkakikah tlan nomechilis. ");
INSERT INTO nplNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ninteh tlakah amo wintitokeh kemi nomejwah nonkimoliah, porke wel ok kualka, sikin las nueve de kuinal. ");
INSERT INTO nplNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Porke nochi tlan axa panotok, ye noni tlan yowejka okijto n profeta Joel: ");
INSERT INTO nplNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","N Totajtsi Dios kijtoa: Itech sa iksemi tonatijmeh, niktitlanis no Espíritu itech nochteh n tlaltikpaktlakah. Nomopilwah iwa nomochpochwah kijtoskeh tlan tlamochiwas satepa. Nomotelpochwah kinmitaskeh neskayolteh iwa n tetajtsitsinteh tejtemikiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Itech nekateh tonatijmeh niktitlanis no Espíritu itech n tlakah iwa siwameh akimeh tekiti nonawak, iwa tetlapowiskeh tlan satepa tlamochiwas. ");
INSERT INTO nplNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tlakpak kan ilwikak iwa tlatsintla itech tlaltíkpaktli: nikinteititis neskayolteh, estli, tletl iwa méxpoktli. ");
INSERT INTO nplNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","N tonati ayakmó tlawis, iwa n metsi chichilewis kemi estli, achto de maajsiki itonati n Toteko, non tonati yetos weyi iwa mawistik. ");
INSERT INTO nplNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iwa nochteh akimeh kitenewaskeh Itoka n Toteko, Ye kinmakixtis. ");
INSERT INTO nplNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","'Tlakah de Israel, xikkakikah tlan nomechilis: Jesús de Nazaret, Dios okipéjpenki. Nomejwah kuali nonkimatokeh, porke Dios okimák weletílistli para makinchiwa wejweyi neskayolteh nomoixpa, kemi nomejwah kuali nonkimatokeh. ");
INSERT INTO nplNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero nomejwah ononkikitskijkeh iwa ononkitemaktijkeh inmak tlakah tlajtlakolejkeh, iwa yejwah okimiktijkeh ipan krus, ijkó kemi Dios yokimatia iwa okimonekilti ijkó mamochiwa. ");
INSERT INTO nplNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Totajtsi Dios okiyoliti. Ye okitekixtili imak n mikílistli, porke n mikílistli mach owéletki okítlanki. ");
INSERT INTO nplNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","N rey David otlajto de Cristo Jesús ijkuak okijto: Nochipa onikitaya n Toteko noyakapa; amitla weletis nechmojtis, porke ye kajki nomayekma. ");
INSERT INTO nplNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yika niyolpaki, iwa nitlakuika ika pakílistli, iwa maya niwilantos, kuali nikmatok oksepa nimoyolitis. ");
INSERT INTO nplNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porke mach tikkawas noalma kan miktla, nion tikkawas maijtlakawi ikuerpo Mokone yolchipawak. ");
INSERT INTO nplNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Otechimititi n ojmeh non nechwikah kan nochipa niyolitos, iwa tikchiwas satlawel maniyolpaki ijkuak niyetos monawak. ");
INSERT INTO nplNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Nokniwah, kuali tikmatokeh totata rey David omikki iwa okitookakeh, porke asta axa tikmatokeh kan omotook. ");
INSERT INTO nplNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero David okatka profeta, iwa kuali okimatia n Dios okisentlali seme de iixwiwah non walaskia okachi satepa yetoskia n Cristo. Ye mochiwaskia rey kemi okatka n David. ");
INSERT INTO nplNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ijkó, kemi yaskia inewia kontlajtlatok, David okijto Cristo moyolitiskia iwa Dios amo kikawaskia ikuerpo maijtlakawi miktla. ");
INSERT INTO nplNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios okiyoliti n Jesús iwa tinochteh otikitakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ijkó kiné, ik iyekma Totajtsi Dios okiweyijkatlali n Jesús, iwa Jesús okiseli n Espíritu Santo non Itajtsi yokijtojka kitemakas. Iwa axa yotechaltítlanili n Espíritu Santo non axa nonkitah iwa nonkikakih. ");
INSERT INTO nplNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David amo otlejkok ilwikak. Pero inewia okijto: Notajtsi Dios okili Noteko: “Ximoyayanti noyekma, ");
INSERT INTO nplNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta manikintlali non mitskokolia itlampa mokxiwah.” ");
INSERT INTO nplNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","'Tlakah de Israel, kuali xikmatikah, nin Jesús Akin nomejwah ononkikrusifikarojkeh, Dios okiweyijkatlali para mayeto Nomoteko iwa Nomotemakixti. ");
INSERT INTO nplNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ijkuak ijkó okikakeh, nochteh omoyolkokojkeh iwa okitlajtlanijkeh n Pedro iwa n oksikimeh tlatitlanilti: —Tokniwah, ¿tlan moneki matikchiwakah? ");
INSERT INTO nplNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ijkuakó Pedro okinnankili: —Xikilikah Dios manomechtlapojpolwi iwa xiktlakitakah, iwa ximotekawilikah manomechkuaatekikah itech Itoka n Cristo Jesús, ijkó Dios nomechtlapojpolwis de nomotlajtlakolwah iwa nonkiseliskeh n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nin tlájtoli non yowejka omosentlali omochi para nomejwah iwa nomopilwah, noiwa para nochteh akimeh Totajtsi Dios kinekis kinmakixtis itech nochi n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro ok okintlapowiaya n tokniwah íwa ika miak chikawálistli okimiliaya: —¡Ximomakixtikah de n tlaijyowílistli non kiseliskeh akimeh tlajtlakolchijtinemih! ");
INSERT INTO nplNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ijkó kiné, akimeh okikakeh tlan Pedro okinmachti, omokuaatekijkeh; iwa non tonati omoseitilijkeh iwan tokniwah non kineltokah Cristo Jesús kemi eyi mil tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iwa nochteh omochijchikawayah iwa okichiwayah tlan n tlatematiltijkeh okinmachtiayah, omoyekwikayah, omotiotsajtsiliayah iwa omoololoayah para kisepankuaskeh n paj. ");
INSERT INTO nplNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nochteh omotlajtlachialtiayah, porke itlatitlanilwah n Cristo okinchiwayah miakeh milagros iwa okinextiayah tlan amayik omotaya. ");
INSERT INTO nplNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nochteh non okineltokakeh omoyekwikayah, iwa okimosepanxexeliliayah tlan okipiayah. ");
INSERT INTO nplNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Okinemakayah nochi tlan okipiayah, iwa okinxejxeliliayah n tomi akimeh okimpoloaya. ");
INSERT INTO nplNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ixmostla omoololoayah kan Weyi Tiopa, iwa incha okisepankuayah n paj, iwa sansikah omotlamajsewiayah ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Okiweyijkachiwayah Dios, iwa nochteh n tlakah de non altepetl okinyekitayah. Ixmostla omomiakiliayah non okineltokayah akimeh n Toteko Dios okinmakixtijtiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Se tonati, Pedro iwa n Juan oyajkeh kan Weyi Tiopa kemi las tres de tiotlak. Non ora nochteh omotiotsajtsiliayah. ");
INSERT INTO nplNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nochi tonati ompa okatka se tlakatl non amo weleti nejnemi. Okonkawayah kan ikalte n Weyi Tiopa non omonotsaya Kuajkualtsi, iwa ompa okintlajtlaniliaya tomi akimeh ompa okalakiah. ");
INSERT INTO nplNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ijkuak ye non amo weleti nejnemi okitak n Pedro iwa n Juan, yokalaktiayah tiopa, okintlajtlanili tomi. ");
INSERT INTO nplNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ijkuakó Pedro iwa Juan okontlajtlatakeh, iwa Pedro okili n tlakatl: —Techalita. ");
INSERT INTO nplNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","N tlakatl okinyektlajtlatak, porke okimoli chamo kimakaskiah itla. ");
INSERT INTO nplNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Pedro okili: —Amo nikpia oro nion plata, pero tlan nikpixtok nimitsmaka: Itech Itoka n Cristo Jesús de Nazaret, ¡ximoketsa iwa xinejnemi! ");
INSERT INTO nplNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ijkuakó Pedro okontílanki ika imayekma iwa okiketsalti, iwa san nima omoyekmijmilajkeh ikxiomiowah. ");
INSERT INTO nplNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ijkuakó non amo oweletia onejnemia owalmóketski iwa opé nejnemi. Iwa okalak inwah kan Weyi Tiopa, nejnenti iwa ajkotsekuinti iwa okiweyijkachiwaya Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nochteh okitakeh n tlakatl kenijki onejnemia iwa okiweyijkachiwaya Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nochteh okiyekixmatkeh n tlakatl porke nochi tonati omotominijtlaniaya ikaltempa n Weyi Tiopa kan kaltentli non kilia Kuajkualtsi, iwa omotlajtlachialtijkeh por tlan otlamochijkah. ");
INSERT INTO nplNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","N tlakatl non opajtik ayakmó okinkawaya n Pedro nion Juan. Nochteh n tlakah omotlajtlachialtijkeh iwa omotlelojkeh okimitatoh kan korrédor non kiliah Portal de Salomón. ");
INSERT INTO nplNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ijkuak ijkó okitak, Pedro okinmili: —Tlakah de Israel, ¿tleka nonmotlajtlachialtiah? Techsentlajtlatah kemi yetoskia tejwah tonewiah otikpajtijkeh nin tlakatl; noso kemi yetoskia tikualteh titlakah, iwa ika toweletilis otikchijkeh manejnemi. ");
INSERT INTO nplNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Pero amo ijkó kemi non kimoliah; porke Idios Abraham, Isaac, Jacob iwa nochteh totatawah, Ye Akin okipajti n kókoxki iwa okiweyijkatlali Ikone Jesús, Akin nomejwah ononkitemaktijkeh inmak n tekiwajkeh, iwa ijkuak Pilato okinekia kikajkawas, nomejwah mach ononkinekeh. ");
INSERT INTO nplNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ijkuak onomechtlajtlanijkeh kox ononkinekiah makikajkawakah Akin yolchipawak iwa yekmilajka, nomejwah mach ononkinekeh, yej ononkitlajtlankeh makikajkawakah se tlakatl non temikti. ");
INSERT INTO nplNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ijkó nomejwah ononkimiktijkeh Akin weleti kichiwa se mayolito nochipa. Pero Dios okiyoliti, iwa noni tejwah kuali tikmatokeh porke otiktakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nin tlakatl non kajki nomoyakapa, non nomejwah kuali nonkixmatih, Dios okipajti porke titlaneltokah itech iweletilis n Jesús. Iwa por tikneltokah n Jesús, kemi nochteh nomejwah nonweletih nonkitah. ");
INSERT INTO nplNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","'Nokniwah, kuali nikmatok ijkuak nomejwah iwa n tlanawatijkeh ononkimiktijkeh n Jesús, mach ononkimatiah tlan ononkichiwayah. ");
INSERT INTO nplNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ijkó Dios okichi tlan achto yokitematiltijka ika intlajtol iprofetajwah. Nochteh yejwah okijtojkeh Cristo tlaijyowiskia. ");
INSERT INTO nplNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yika, ayakmó xikchiwakah tlajtlákoli iwa xiktlakitakah Dios. Ijkó Ye kilkawas nochi tlan amo kuali ononkichijkeh, iwa nomechmakas yankuik chikawálistli, ");
INSERT INTO nplNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","iwa kualtitlanis n Jesús, Akin yowejka okipéjpenki para mayeto n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero axa, Cristo Jesús ok moneki mayeto ilwikak asta ijkuak Dios tlamis kiyankuilis nochi tlan onka ilwikak iwa ipa n tlaltíkpaktli. Dios ya wejkawitl ijkó okijto ika intlajtol n profetas. ");
INSERT INTO nplNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yika, Moisés okinmili totatawah: “Ijkó kemi n Toteko Dios onechtítlanki nomonawak, noiwa nomechtitlanilis se profeta non kisas de nomejwah. Xikneltokilikah nochi tlan Ye nomechilis. ");
INSERT INTO nplNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Porke akin amo kitlakitas non profeta, ayakmó kikawiliskeh mayeto tewa iwan tlakah de Israel.” ");
INSERT INTO nplNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","'Samuel iwa nochteh n profetas non satepa oneskeh, noiwa otetlapowijkeh tlan tlamochijtok itech ninteh tonatijmeh. ");
INSERT INTO nplNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nomejwah nontepilwah de nekateh profetas; iwa Dios nomechmakas tlan okinkakiti kinmakas totatawah ijkuak okili n Abraham: “Por moxwiwah, Dios kintiochiwas nochteh n tlaltikpaktlakah.” ");
INSERT INTO nplNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ijkuak Dios okiyoliti Ikone, achto onomechtitlanili nomonawak, para manomechtiochiwa, iwa ijkó xikkawakah tlan amokuali nonkichijtinemih. ");
INSERT INTO nplNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro iwa n Juan ok okintlapowijtokah n tlakah. Ijkuakó okalakikoh n tiopixkeh iwa n tlanawati non okinnawatiaya n tlamokuitlawijkeh de kan Weyi Tiopa iwa n saduseos. ");
INSERT INTO nplNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Satlawel okualantiwalayah porke Pedro iwa Juan okinmachtiayah n tlakah, iwa okinmiliayah non yomikkeh moyolitiskeh porke Jesús omoyoliti de kan mikemeh. ");
INSERT INTO nplNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ijkuakó okinkitskijkeh iwa okintsakuatoh, iwa ompa okinkajtejkeh non tonati porke yotleyuatoka. ");
INSERT INTO nplNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero miakeh akimeh okikakeh intlajtol, okineltokakeh Cristo Jesús; iwa san tlakah okatkah kemi mákuili mil. ");
INSERT INTO nplNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ijkuak owalmostlatik, n tlayakankeh judíojteh, n tetajmeh non tlayakantokeh kan Weyi Tiopa iwa n tlamachtijkeh de itlanawatil Moisés, omoololojkeh kan altepetl de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ompa okatka Anás n tiópixki non okachi otlayakantoka. Noiwa ompa okatka Caifás, Juan, Alejandro iwa n oksikimeh ichanejkawah n Anás. ");
INSERT INTO nplNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ijkuakó okwalinnotsatoh n Pedro iwa n Juan iwa okinketskeh tlatlajkotia, iwa okintlajtlanijkeh: —¿Akin onomechmák non tekiwajyotl, noso akin onomechili xikpajtikah nin tlakatl? ");
INSERT INTO nplNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ijkuakó Pedro, non okipixtoka ichikawalis n Espíritu Santo, okinmili: —Wejweyi tekiwajkeh iwa tetajmeh de Israel: ");
INSERT INTO nplNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ijkó kemi nomejwah nontechtlajtlaniah, kenijki otikpajtijkeh n kókoxki, iwa nonkinekih nonkimatiskeh kenomi opajtik. ");
INSERT INTO nplNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tomechmatiltiah inyakapah nochteh n tlakah de Israel para makimatikah nin tlakatl non kajki nomoyakapah, opajtik ika Itoka n Cristo Jesús non de Nazaret, Akin nomejwah ononkimiktijkeh itech krus, iwa Dios okiyoliti de kan mikemeh. ");
INSERT INTO nplNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nin Jesús, Ye n tetl Akin nomejwah nonkalchijchijkeh ononkitlakaltechojkeh, pero nin tetl omochiwako non okachi tetlakxili. ");
INSERT INTO nplNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mach onka ok se tlakatl akin weletis techmakixtis, porke Dios mach otechmák ok se tlakatl itech nin tlaltíkpaktli para inawak matimomakixtikah. ");
INSERT INTO nplNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ijkuak okitakeh kenijki Pedro iwa n Juan mach okimawiliayah tlajtoskeh teixpa, maya amo kanaj omoixtlamachtijkeh, satlawel omotlajtlachialtijkeh. Ijkuakó okajsikamatkeh milák onemiah iwan Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yika amitla oweletkeh okimilijkeh porke n tlakatl non okipajtijkeh ompa inwah omoketoka. ");
INSERT INTO nplNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ijkuakó okwalinkixtijkeh de kan Sanedrín, iwa nochteh n tekiwajkeh ompa omokajkeh para motlapowiskeh tlan kichiwaskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Iwa okimoliayah: —¿Tlan tikchiwaskeh iwa ninteh tlakah? Nochteh non chantitokeh nika Jerusalén kimatih okichijkeh se weyi milagro, iwa amo weletis tikijtoskeh amo milák. ");
INSERT INTO nplNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yika, para ayakmó okachi mamoxitini nin tlájtoli, matikinmomojtikah, para ayakmó matlamachtijtinemikah de Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ijkuakó oksepa okinnotskeh mawalkalakikah iwa okinnawatijkeh ayakmó matetlapowikah nion matlamachtikah de Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedro iwa n Juan ijkí okinnankilijkeh: —Kuali xikyejyekolikah nomejwah, kox kuali inawak Dios tlan nomejwah nontechnawatiah, ¿akin okachi moneki se makitlakita, nomejwah noso Dios? ");
INSERT INTO nplNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mach weletis san tejwah matikpixtokah tlan otiktakeh iwa otikkakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ijkuakó n tekiwajkeh okinmomojtijkeh, pero okinkajkeh mawiah. Amo okajsikeh kenijki kintlaijyowiltiskeh, porke nochteh n tlakah okiweyijkachiwayah Dios por neká tlakatl non opajtik. ");
INSERT INTO nplNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Iwa n tlakatl non opajtik ika non milagro, yokipiaya okachi de ome póali xiwitl. ");
INSERT INTO nplNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Keman okinkajkeh mawiah, Pedro iwa n Juan oyajkeh kan okatkah inmikniwah, iwa okimilijkeh nochi tlan n tetajmeh non tlayakantokeh kan Weyi Tiopa okimilijkah. ");
INSERT INTO nplNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ijkuak yokikakeh nochi tlan okimilijkeh, nochteh omotiotsajtsilijkeh iwa okijtojkeh: —Totajtsi Dios, Tejwatsi otikchijchi n ilwikak, iwa n tlaltíkpaktli, n weyi atl iwa nochi tlan intech onka. ");
INSERT INTO nplNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tejwatsi ika iweletilis n Espíritu Santo iwa ika itlajtol motékitki David, otikijto: ¿Tleka nochteh n tlaltikpaktlakah onewah mopa? ¿Iwa tleka nochteh san tlan kajsih kichiwah? ");
INSERT INTO nplNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","N wejweyi tlanawatijkeh de nin tlaltíkpaktli omoseitilijkeh, iwa n tekiwajkeh de nochteh n altepemeh motlatlalwiskeh iwa onewaskeh ipan Toteko Dios iwa Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Tikmatih milák, Herodes Antipas Primero iwa Poncio Pilato omoseitilijkeh nika Jerusalén iwa sikimeh tlakah non amo judíojteh iwa oksikimeh non milák judíojteh, nochteh omoseitilijkeh iwa oonewakeh ipan Jesús Mokone yolchipawak, Akin Tejwatsi otikpéjpenki. ");
INSERT INTO nplNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ijkuak oonewakeh ipa, yejwah okichijkeh mamochiwa tlan Tejwatsi yotikmolijka iwa otikmonekilti ijkó mamochiwa. ");
INSERT INTO nplNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iwa axa, Toteko Dios, xikita kenijki kinekih techmomojtiskeh, xikchiwa matimoyolchikawakah para matitetlapowikah de motlajtol iwa amitla matechmojti. ");
INSERT INTO nplNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iwa ika moweletilis mapajtikah n kokoxkeh, iwa mamochiwakah milagros iwa mamonextikah wejweyi neskayolteh itech Itoka Cristo Jesús Mokone yolchipawak. ");
INSERT INTO nplNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ijkuak yotlankeh omotiotsajtsilijkeh, san nima otlalólinki kan omoololojkeh. Iwa nochteh okiselijkeh n Espíritu Santo, iwa ika yolchikawálistli otetlapowijtinenkeh de itlajtol Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nochteh non okineltokayah n Cristo Jesús san se intlayejyekolis okipiayah, iwa nochi tlan okichiwayah, sansikah okichiwayah. Amaka okijtoaya san ye iaxka tlan okipiaya, yej okimosepanxejxeliliayah. ");
INSERT INTO nplNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iwa ika miak weletílistli, itlatitlanilwah otetlapowiayah Toteko Jesús oksepa omoyoliti, iwa Dios saikpanoa okintiochiwaya. ");
INSERT INTO nplNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nion seme de yejwah itla okipoloaya, porke nochteh akimeh okimpiayah intlalwah noso inkal, okinnemakayah, ");
INSERT INTO nplNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","iwa okinmaktiliayah n tlatematiltijkeh, iwa yejwah okinxejxeliliayah akimeh okimpoloaya. ");
INSERT INTO nplNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ijkó okichi se tlakatl non itoka José. Nin José otlákatki kan isla de Chipre iwa owalewatoka de Leví; iwa n tlatematiltijkeh okitlalilijkeh itoka Bernabé, non kijtosneki: Teyolchika. ");
INSERT INTO nplNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nin tlakatl okinemák itlal iwa n tomi okinmaktili n tlatematiltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Noiwa ok se tlakatl non itoka Ananías iwa isiwa Safira okinemakakeh intlal. ");
INSERT INTO nplNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iwa nin tlakatl omotlatlalwi iwa isiwa para makimokawikah siki tomi, iwa oksiki okinmaktilitoh n tlatematiltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ijkuakó Pedro okili: —Ananías, ¿tleka otikkawili n satanás makimoaxkati moyolo, iwa mamitstokti xikkajkayawa n Espíritu Santo, iwa otikchikowi n tomi non omitsmakakeh por motlal? ");
INSERT INTO nplNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Mach amo okatka moaxka n tlali? Iwa ijkuak yotiknemák, ¿amo noiwa okatka moaxka n tomi? ¿Tleka kiné otikkawili moyolo matlakajkayawa? Amo otikinkajkaya n tlakah, yej otiknekia tikkajkayawas Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ijkuak Ananías otlanki okinkak ninteh tlájtolteh, omikki. Iwa nochteh akimeh okimatkeh tlan otlamochi, tlawel omomojtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ijkuakó owalajkeh sikimeh telpokameh, okimemelojkeh n miketl iwa okitookatoh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kemi eyi ora satepa, okalakiko isiwa n Ananías, mach okimatia tlan otlamochijka. ");
INSERT INTO nplNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ijkuakó Pedro okitlajtlani: —Techili, ¿Nomejwah ononkinamakakeh n tlali, achó kemi nonkijtoah? N siwatl otlanankili: —Milák, achó ipati. ");
INSERT INTO nplNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro okili: —¿Tleka ononmotlatlalwijkeh para nonkiyejyekoskeh Iespíritu n Toteko Dios? Kaltempa kalaktiwitseh akimeh okitookatoh motlakau, iwa axa te noiwa mitstookatiweh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ijkuakó Safira owetski ikxitla n Pedro iwa omikki. Ijkuak owalkalakeh n telpokameh, okajsikoh n Safira yomikki, okikixtijkeh iwa okitookatoh inakastla iokich. ");
INSERT INTO nplNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nochteh n tlaneltokakeh, iwa akimeh okimatkeh tlan otlamochi, satlawel omomojtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Itlatitlanilwah Jesús okinnextiayah miakeh neskayolteh iwa tlan tetlajtlachialti ompa Jerusalén, iwa nochteh non okineltokayah n Jesús omoololoayah kan korrédor non kiliah Portal de Salomón. ");
INSERT INTO nplNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Iwa n oksikimeh mach omixewiayah moneloskeh inwah, pero nochteh okintlanekiliayah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iwa omomiakiliayah miakeh tlakah iwa siwameh non okineltokayah n Toteko. ");
INSERT INTO nplNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iwa asta okinkixtiayah inkokoxwah itech ojtli, iwa okintlaliayah ipan inkuaujtlapech noso ipan impetl para ijkuak panos n Pedro, maya san ika itlasekawilo makoninmajsi iwa ijkó mapajtikah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Noiwa akimeh ochantitokah itech altepemeh non okiyawalojtokah Jerusalén, okwalinwikayah inkokoxwah iwa akimeh okimpiayah espíritus amokualteh, nochteh opajtiah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ijkuakó n tiópixki non okachi otlayakantoka iwa sikimeh saduseos non iwa okatkah, satlawel oxikojmikeh, ");
INSERT INTO nplNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","iwa okinkitskijkeh n tlatematiltijkeh iwa okintsakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero se yúali iángel n Toteko okitlapo n kaltentli kan otsaktokah, iwa okinkixtih. Iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Xiwiah kan Weyi Tiopa, iwa xikinmatiltikah n tlájtoli non kitemaka temakixtílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Okikakeh, iwa ijkuak owaltláneski oyajkeh kan Weyi Tiopa iwa opé tlamachtiah. Ijkuakó n tetajmeh non tlayakantokeh kan Weyi Tiopa iwa non íwa okatkah, okinnotskeh mamoololokah nochteh non otlanawatiayah kan Weyi Tiopa. Satepa otlatitlankeh makinnotsatih n tlatitlanilteh kan otsaktokah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero ijkuak n tlamokuitlawijkeh okalakitoh kan otsaktokah n tlatematiltijkeh, ayakmó okinmajsitoh. Iwa owalmokoptiwetskeh otlanawatikoh n tlatematiltijkeh ayakmó ompa okatkah, ");
INSERT INTO nplNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","iwa okijtojkeh: —Otikkajsitoh n kaltentli kuali tsaktok, iwa n tlamokuitlawijkeh okiyekmokuitlawijtokah n kaltentli kan otsaktokah n tlatematiltijkeh, pero ijkuak otitlatlapojkeh, amaka otikajsikeh tlaijtik. ");
INSERT INTO nplNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ijkuak okikakeh nochi ni, n tlayákanki de non otlamokuitlawiayah kan Weyi Tiopa iwan tiopixkeh non otlayakantokah, omotlajtlachialtijkeh iwa omotlajtlaniayah tlan okachi tlamochiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ijkuakó okalakiko se tlakatl, iwa okinmili: —N tlakah akimeh nomejwah nonkintemoah kateh kan Weyi Tiopa, iwa kinmachtijtokeh n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ijkuakó n tlayákanki iwa itlamokuitlawilwah, oyajkeh okwalinnotsatoh n tlatematiltijkeh, iwa okwalinwikakeh ika kuali, porke omawiah makinmojmotlakah ika tetl. ");
INSERT INTO nplNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ijkuak okwalinwikakeh, okinketsatoh innawak tekiwajkeh, iwa n tiópixki non okachi otlayakantoka okinmili: ");
INSERT INTO nplNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Tejwah kuali otomechilijkeh ayakmó xitlamachtikah ika itoka non tlakatl. Pero nomejwah amo onontechtlakitakeh, yej itech nochi nin altepetl de Jerusalén yononkiteixmatiltijkeh itlamachtilis non tlakatl. Iwa axa nonkinekih techtlajtlakoltiskeh de imikilis non tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ijkuakó Pedro iwa n oksikimeh tlatematiltijkeh otlanankilijkeh: —Tejwah tikpiah tiktlakitaskeh tlan Dios kijtoa iwa amo tlan kijtoah n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Idios totatawah okiyoliti n Jesús, Ye Akin nomejwah ononkimiktijkeh ijkuak ononkikrusifikarojkeh ipan krus. ");
INSERT INTO nplNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios yokiweyijkachi n Jesús ika iweletilis, iwa okitlali mayeto Tlayákanki iwa Totemakixti. Dios ijkó okichi para nochteh n tlakah de Israel mamoyolpatlakah inawak iwa makintlapojpolwili intlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tejwah otiktakeh iwa otikkakeh tlan tomechtlapowiah sansikah iwa n Espíritu Santo non Dios kinmaka akimeh kitlakitah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ijkuak yejwah okikakeh tlan okijtoayah n tlatematiltijkeh, okualankamikeh iwa yokinekiah kinmiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ompa inwah nonteh tekiwajkeh okatka se tlakatl fariseo non itoka Gamaliel. Ye okatka se tlamachti de itlanawatil Moisés iwa nochteh n tlakah satlawel okitlakitayah. Gamaliel omóketski iwa otlanawati makinkixtikah n tlatematiltijkeh san achitsi. ");
INSERT INTO nplNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Otlanki okinmili non oksikimeh tekiwajkeh: —Tetajmeh de Israel, kuali xikitakah tlan nonkinekih nonkintoktiskeh ninteh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kuali xikilnamikikah nomejwah, kenijki yowejka omonexti se tlakatl non omonotsaya Teudas akin okijtoaya weyijkatitok, iwa okinmoyakanalti kemi nawi siento tlakah. Pero ijkuak okimiktijkeh, nochteh akimeh okinyakanaya ochocholojkeh iwa ompa otlanki nochi. ");
INSERT INTO nplNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Okachi satepa, itech nekateh tonatijmeh ijkuak okinmachotijtokah nochteh n tlakah de Israel, omonexti Judas non owalewatoka de Galilea. Ye okinmotlatlalwili miakeh tlakah, pero noiwa okimiktijkeh; iwa nochteh akimeh okinyakanaya omoxexelojkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ika noni nomechilia, xikinkawakah ninteh tlakah, iwa amo ximokalakikah inwah. Porke tla nin tlamachtílistli noso nin tekitl san yejwah kinekih kichiwaskeh, pojpoliwis. ");
INSERT INTO nplNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero tla iaxka Dios, mach weletis nonkipojpoloskeh. Ximotlachilikah, amo kichiwa nonkixnamikiskeh Dios. Iwa n tlayakankeh okitlakamatkeh n Gamaliel. ");
INSERT INTO nplNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nochteh n tekiwajkeh omoyolsewijkeh ika tlan Gamaliel okinmili. Ijkuakó okinnotsatoh n tlatematiltijkeh, okinwitekeh iwa okinnawatijkeh ayakmó matlamachtikah itech Itoka n Jesús, iwa satepa okinkajkajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","N tlatematiltijkeh owalkiskeh de kan okatkah n tekiwajkeh ika miak pakílistli, porke Dios okinkawili matlaijyowikah iwa makimpijpinawikah por okitenewayah Itoka n Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Iwa nochi tonati itech Weyi Tiopa iwa itech kalmeh, n tlatematiltijkeh otlamachtiayah iwa otetlapowiayah Jesús, Ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Itech nekateh tonatijmeh, kemi okachi omomiakiliayah akimeh okineltokayah itlamachtilis n Cristo Jesús non otlajtoayah griego opé mokuejsoah innawak akimeh otlajtoayah hebreo, porke okijtoayah nochi tonati ijkuak omoxejxeloaya n tlákuali, mach okinyektlakualtiayah n iknosiwameh griegas. ");
INSERT INTO nplNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ijkuakó n májtlaktli iwa ome tlatematiltijkeh okinmoololojkeh nochteh non kineltokah Cristo Jesús, iwa okimilijkeh: —Amo kuali tejwah non tiktematiltiah itlajtol Dios, yej matipewakah matitlatetekakah para matlakuakah. ");
INSERT INTO nplNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ijkó kiné tokniwah, okachi kuali nomejwah xikimpejpenakah chikome tokniwah non kineltokah Cristo Jesús, non mayetokah milajkameh, matentokah de n Espíritu iwa makipiakah kuali intlalnamikilis. Yejwah xikintlalikah makichiwakah non tekitl. ");
INSERT INTO nplNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","'Tejwah tikchijtoskeh toteki; timotiotsajtsiliskeh iwa titetlapowiskeh de itlajtol Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nochteh okiwilitakeh tlan okinmilijkeh makichiwakah. Iwa okipejpenkeh n Esteban, ye satlawel okipiaya tlaneltokálistli iwa otentoka de Espíritu Santo. Noiwa okipejpenkeh n Felipe, Prócoro, Nicanor, Timón, Pármenas iwa Nicolás non owalewatoka de Antioquía. Nin Nicolás, ijkuak ayamó okineltokaya n Cristo, okiseli intlamachtilis n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Otlanki okwalinwikakeh innawak tlatematiltijkeh, iwa yejwah okintlalijkeh inmawah impah nonteh chikome tlakah iwa omotiotsajtsilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Itlajtol Totajtsi Dios opé momati sentetl, iwa ompa Jerusalén okachi omomiakiliayah non kineltokah Cristo Jesús. Asta noiwa miakeh tiopixkeh judíojteh otlaneltokakeh inawak Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban okatka se tlakatl non otentoka ika itlatiochiwalis iwa iweletilis Dios; iwa okinchiwaya wejweyi milagros inmixpa n tlakah non ompa ochantitokah. ");
INSERT INTO nplNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero satepa, sikimeh tlakah non omoololoayah kan se sinagoga non omotokayotiayah Esklavos Libertados, iwa sikimeh tlakah non owalajkeh de Cirene, de Alejandría, de Cilicia iwa de Asia, opé motlatlajtolkopah iwan Esteban. ");
INSERT INTO nplNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero amo oweletiah okitlaniah n Esteban, porke n espíritu okichiwaya matlanankili kemi se akin ixtlamati. ");
INSERT INTO nplNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ijkuakó san ichtaka okintlatlalwijkeh sikimeh tlakah para matlakajkayawakah yejwah okikakeh ijkuak Esteban otlajtojtoka fiero de Moisés iwa de Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ijkó okichijkeh, okimpajsolojkeh nochteh n tlakah non ompa ochantitokah, noiwa n tetajmeh non tlayakantokeh kan Weyi Tiopa iwa non kitemachtiah n tlanawatílistli. Oyajkeh okikitskitoh n Esteban iwa okiwikakeh kan Sanedrín. ");
INSERT INTO nplNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Noiwa okintemojkeh sikimeh tlakah xolópijteh, para matlakajkayawakah iwa makijtokah: —Nin tlakatl nochipa tlajtojtinemi fiero de tochipawak Weyi Tiopa iwa tlan kijtoa itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Otikkakeh okijto Jesús de Nazaret kixixititsas nin tiopa iwa kipatlas nochi tlan towejkatata Moisés otechnawati matikchiwakah. ");
INSERT INTO nplNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iwa nochteh n tekiwajkeh iwa akimeh ompa oewatokah, ijkuak okiixtlajtlatakeh n Esteban okitakeh ixko omotaya kemi ixko se ángel. ");
INSERT INTO nplNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","N tiópixki non okachi otlayakantoka okitlajtlani n Esteban: —¿Milák tlan kijtojtokeh? ");
INSERT INTO nplNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban otlanankili: —Nokniwah iwa tetajmeh, techkakikah, Totajtsi Dios non weyijkatitok okimonextili towejkatata Abraham kan tlali de Mesopotamia, achto de mochantiskia kan tlali de Harán, ");
INSERT INTO nplNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","iwa okili: “Xikkakajtewa motlal iwa nochteh non ken tikinmita, iwa xio kan tlali non Ne nimitsititis.” ");
INSERT INTO nplNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ijkuakó Abraham okikakajte n tlali de Caldea iwa ochanchiwato Harán. Satepa omikki ita, iwa Dios okwalík n Abraham itech nin tlali, kan axa nomejwah nonchantitokeh. ");
INSERT INTO nplNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero amitla okiaxkatili itech nin tlali, nion kan kitlalis se ikxi. Pero Dios okikakiti kiaxkatiliskia, iwa keman Abraham mikiskia n tlali kimokawiskiah ipilwah; maya itech nonteh tonatijmeh Abraham ayamó okimpiaya ipilwah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios noiwa okili, ipilwah chantitoskiah itech oksikimeh tlalmeh kan amo inmaxka, kinnawatijtoskiah iwa tlaijyowijtoskiah nawi siento xiwitl. ");
INSERT INTO nplNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero noiwa Dios okili: “Ne nikintlajtlakoltis n tlakah de non altepetl akimeh kintlaijyowiltiskeh mopilwah, satepa kisaskeh de ompa iwa nechtekichiwiliskeh itech nin tlali.” ");
INSERT INTO nplNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios omoyekka iwan Abraham, iwa Abraham okisentlali inawak Dios kichiwas n sirkunsisión kemi se neskayotl. Yika, ijkuak otlákatki ikone Isaac, ipan chikweyi tonati okisirkunsidaro. Noiwa ijkó okichi Isaac iwa ikone Jacob, iwa Jacob noijkó okichi iwa ipilwah, akimeh oyajkeh tetajmeh de n májtlaktli iwa ome familias de Israel. ");
INSERT INTO nplNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","'Ninteh májtlakteh iwa ome ipilwah n Jacob, okatkah totatawah. Yejwah oxikojmikeh de inmikni José, iwa okinamakakeh para makiwikakah Egipto. Pero Dios okatka iwan José, ");
INSERT INTO nplNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","iwa okipalewi itech nochi tlan otlaijyowiaya. Dios okichi mayeto se ixtlámatki n José iwa okipalewi para ijkó n Faraón rey de Egipto makiyekita. Iwa n rey okitlali n José mayeto non okachi weyi tlanawati de ompa Egipto iwa asta makinawatijto icha. ");
INSERT INTO nplNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","'Ijkuakó owala miak apisotl iwa miak tlaijyowílistli itech nochi n tlali de Egipto iwa de Canaán, iwa totatawah amo okipiayah tlan kikuaskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero ijkuak Jacob okima onka miak trigo kan tlali de Egipto, okintítlanki ompa itelpochwah non okatka totatawah. Ijkuakó sikinika oyajkeh Egipto. ");
INSERT INTO nplNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ijkuak totatawah oksepa oyajkeh Egipto, José omoteixmatilti innawak ikniwah, iwa ijkó n Faraón okima kan owalewatoka n José iwa akimeh ikniwah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Satepa, José otlatítlanki makualikakah ita Jacob iwa nochteh non ken kinmita. Yejwah okatkah eyi póali iwa káxtoli por nochteh. ");
INSERT INTO nplNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ijkó n Jacob otemok ochanchiwato kan tlali de Egipto. Satepa ompa omikki, iwa ompa noiwa omijmikeh nochteh totatawah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Okachi satepa inkuerpojwah okinwikakeh Siquem iwa okintookakeh ijtik miketékochtli non Abraham okinkuilijka ipilwah n Hamor ompa kan tlali de Siquem. ");
INSERT INTO nplNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","'Ijkuak yoajsitiwalaya n tonati para mochiwas tlan Dios yokilijka Abraham, n tokniwah de Israel okachi opé momiakiliah ompa Egipto. ");
INSERT INTO nplNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ijkó otlamochi itech tlali de Egipto asta ijkuak opé tlanawatia ok se rey non amo okixma n José. ");
INSERT INTO nplNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nin rey okinkajkaya n tlakah judíojteh iwa okintlaijyowilti totatawah, asta okintokti makinkakajtewakah inselekkonewah para mamikikah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Itech nonteh tonatijmeh otlákatki Moisés. Dios okitlanekili non konetl, iwa itajwah okiskaltijkeh icha san eyi mestli. ");
INSERT INTO nplNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Iwa keman okikajkawatoh n selekkonetl, ichpoch n Faraón, okiwík icha iwa okiskalti kemi yetoskia ikone. ");
INSERT INTO nplNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Satepa Moisés okixtlamachtijkeh ika nochi tlan egipsios okimatiah, ika noni Moisés okatka se tlakatl non kuali oixtlamatia itech nochi tlan okijtoaya iwa tlan okichiwaya. ");
INSERT INTO nplNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","'Ijkuak Moisés yokipiaya ome póali (40) xiwitl, okintlajpaloto ikniwah n tlakah de Israel. ");
INSERT INTO nplNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ompa okitak se tlakatl egipsio okiwitektoka se israelita, ijkuakó Moisés okipalewi iwa okimikti n egipsio. ");
INSERT INTO nplNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ijkó okichi porke okimoli chamo kajsikamatiskiah n judíojteh Dios okitítlanki para makimpalewi. Pero yejwah mach okajsikamatkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Keman owalmostlatik, Moisés okimitak omotekilmakatokah ome tlakah de Israel, ye okinekia kintlakawaltis, iwa okinmili: “Nomejwah nonmiknimeh; ¿tleka nonmokojkoah?” ");
INSERT INTO nplNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ijkuakó n tlakatl non otlawitektoka okontope n Moisés, iwa okili: “¿Akin omitstlali kemi titekiwa noso kemi titeyolsewi para ximokalaki towah? ");
INSERT INTO nplNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tikneki techmiktis, kemi yala otikmikti n egipsio?” ");
INSERT INTO nplNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ijkuak Moisés okikak tlan okili nin tlakatl, ocholo iwa oyá kan tlali de Madián. Ochanchiwato kan amo ialtépeu iwa ompa okímpixki ome ipilwah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","'Ome póali (40) xiwitl satepa, se tonati Moisés okatka kan amaka chanti, kan tepetl Sinaí iwa ompa okimonextili se ángel itech se tlátsmoli non otlatlatoka. ");
INSERT INTO nplNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ijkuak Moisés okitak non neskayotl, omotlajtlachialti, iwa keman omijkuani okachi tlayakapa, ijkuakó okikak itlajtol n Toteko non okiliaya: ");
INSERT INTO nplNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ne Idios nomotatawah, Ne Idios Abraham, Isaac iwa Jacob.” Moisés opé bibioka iwa mach ok omixewiaya kitlajtlatas n tlátsmoli. ");
INSERT INTO nplNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Iwa Toteko oksepa okitlapowi iwa, okili: “Xikinkixti mokakuah, porke n tlali kan titlaksatok tlatiochíwali. ");
INSERT INTO nplNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ne yonikitak kenomi tlaijyowiah nopilwah akimeh kateh Egipto, Ne yonikinkak kenijki chokah, yika oniwaltemok onikimpalewiko. Axa, xiwiki, porke nimitstitlanis Egipto.” ");
INSERT INTO nplNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","'Maya nomotatawah okitlawelitakeh n Moisés iwa okilijkah: “¿Akin omitsnawati xiyeto totlanawati iwa toteyolsewi?” Dios okitlali n Moisés kemi tekiwa iwa kemi akin kinkixtiskia totatawah de kan tlali de Egipto ika iweletilis n ángel non okimonextili kan tlátsmoli non otlatlatoka. ");
INSERT INTO nplNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ye n Moisés akin okinkixtih totatawah kan tlali de Egipto, iwa Ye okinchi milagros iwa neskayolteh itech non tlali, kan weyi atl non kiliah chichiltik iwa kan amaka chanti, ijkó okichijtínenki itech ome póali (40) xiwitl. ");
INSERT INTO nplNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ye nin Moisés akin okinmili n tlakah de Israel: “Toteko Dios nomechaltitlanilis se profeta non kisas de intech nomokniwah kemi ne onechaltítlanki nomonawak. Xikneltokakah nochi tlan Ye nomechilis.” ");
INSERT INTO nplNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ye nin Moisés, akin noiwa okatka iwa n tlakah de Israel kan amaka chanti. Noiwa ye akin omotlapowi iwa n ángel kan tepetl non itoka Sinaí iwa okinnonotski totatawah. Ye akin okinseli n tlájtolteh non techmachtiah kenijki tiyeknemiskeh iwa otechimpanoltili. ");
INSERT INTO nplNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","'Pero totatawah mach okinekeh okitlakitakeh, yej omoixkopkeh inawak iwa okinekiah mokopaskeh Egipto. ");
INSERT INTO nplNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ijkuakó okilijkeh n Aarón: “Techinchijchiwili sikimeh diosmeh non kinchijchiwah ika inma non matechyakanakah porke amo tikmatih tlan omochi n Moisés non otechkixti de kan tlali de Egipto.” ");
INSERT INTO nplNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ijkuakó okichijchijkeh se “dios” kemi se torojkonetl. Okinmiktijkeh sikimeh yolkameh, okinmanilijkeh iwa opakeh ijkuak okitakeh tlan okichijchijkeh ika inmawah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pero Dios okinkajka makichiwakah tlan yejwah okinekiah, iwa okinka makinweyilikah n tláwilteh non kateh ilwikak. Ijkó kemi ijkuilitok itech ilibro n profeta: Tlakah de Israel, itech nonteh ome póali (40) xiwitl ijkuak ononnentinemiah kan amaka chanti ¿kox Ne ononnechtlamiktilijkeh iwa Ne ononnechtlamanilijkeh? ");
INSERT INTO nplNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amó, yej nomejwah ononkimamajtinemiah itiopantsi n “dios” Moloc, iwa n sítlali de n “dios” Renfán, non san nomejwah ononkinchijchijkeh ika nomomawah. Yika, Ne, nomechkixtis de nomopaís iwa nomechtitlanis okachi tlayakapa de Babilonia. ");
INSERT INTO nplNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","'Ijkuak totatawah onemiah kan amaka chanti, okiwikatinemiah n tabernákulo, iwa ompa ijtik oyayah n temeh patlawakeh non intech oijkuilitoka n tlanawátili. Moisés okichijchi nin tabernákulo ijkó kemi Dios okinawati iwa okinextili makichijchiwa. ");
INSERT INTO nplNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nin tabernákulo noso mantajtiopantsi non Moisés okichijchi okinmaxkatili totatawah, iwa akimeh owalajkeh nika iwan Josué, okualikakeh n tabernákulo ijkuak okintlanilijkeh intlal n oksikimeh altepemeh. Dios okinkixtili intlalwah akimeh nika ochantitokah iwa okinmaxkatili totatawah. Iwa ijkó okatka asta n tonatijmeh ijkuak n rey David onemia. ");
INSERT INTO nplNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios okitiochiwaya n David, iwa ye okinekia kichiwas se Weyi Tiopa kan machantito Idios Jacob. ");
INSERT INTO nplNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero amo David okichijchiwili iweyitiopa, yej Salomón okichijchiwili. ");
INSERT INTO nplNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Maya tikmatokeh Totajtsi Dios amo chantitok ijtik tiopameh non kinmachijchiwah n tlakah. Kemi okijkuilo n profeta Isaías: ");
INSERT INTO nplNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","N ilwikak ye kan niewatok, iwa n tlaltíkpaktli kan nikinsewia nokxiwah. ¿Tlan kali nonkinekih nonnechchijchiwiliskeh nomejwah?, kijtoa n Toteko, ¿noso kan weletis nimosewis? ");
INSERT INTO nplNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Mach amo Ne ika noma onikchijchi nochi tlan onka? ");
INSERT INTO nplNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Iwa Esteban noiwa okinmili n tlayakankeh: —Nomejwah ayik nonkinekih nontetlakitaskeh. Ayik nonkinekih nonkikakiskeh nion nonkinekih nonkichiwaskeh tlan Dios nomechnawatia, ijkó kemi kichiwah akimeh amo kixmatih Dios. Ayik nonmotekawiliah manomechyakana n Espíritu Santo, nomejwah ijkó nonkichiwah kemi okichijkeh nomotatawah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Kox onka se profeta non amo okitlaijyowiltijkeh nomotatawah? Nochteh n profetas akimeh yowejka okitematiltijkeh walaskia neká tlakatl yekmilajka, nomotatawah okimiktijkeh. Iwa axa, nin tlakatl yekmilajka yowitsa, pero nomejwah ononkitemaktijkeh iwa ononkimiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iwa maya Dios okinnawati iangelwah manomechmakakah itlanawatil, nomejwah mach ononkitlakitakeh non tlanawátili. ");
INSERT INTO nplNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ijkuak n tlayakankeh okikakeh tlan okijto n Esteban, okualankamikeh iwa asta omotlannetsoniayah. ");
INSERT INTO nplNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Esteban tentok de Espíritu Santo, oajkotláchixki ilwikak iwa okitak iweyijkachiwalis Dios, noiwa okitak n Jesús moketok ik iyekma n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iwa okijto: —¡Xikitakah! Ne nikita n ilwikak tlapotok, iwa nikita n Jesús Akin omochi tlakatl moketok ik iyekma Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ijkuakó yejwah omonakastsajtsakeh, okojtsajtsikeh iwa nochteh oonewakeh ipan Esteban. ");
INSERT INTO nplNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Okikixtijkeh kala de kan altepetl iwa ompa okimojmotlakeh ika tetl. Iwa akimeh okimojmotlakeh n Esteban, okinkajtejkeh intlakenwah makinmokuitlawilijto se télpochtli non itoka Saulo. ");
INSERT INTO nplNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iwa ijkuak okimojmotlatokah, Esteban omotiotsajtsili iwa okijto: —Noteko Jesús, xikseli noespíritu. ");
INSERT INTO nplNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Omotlankuáketski iwa chikaktik okijto: —¡Noteko, amo xikintlajtlakolti ninteh tlakah! San nima ijkuak otlanki omotiotsajtsili, omikki. ");
INSERT INTO nplNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo okimoli kuali makimiktikah n Esteban. Itech non tonati, non de Jerusalén opé kintotojtokah porke okineltokayah Cristo Jesús. Nochteh ochocholojkeh omotlajtlaatitoh itech tlalmeh de Judea iwa de Samaria, iwa sanwel n tlatematiltijkeh omokajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sikimeh tokniwah non okimopantiayah Dios, okitookakeh n Esteban iwa satlawel okichokilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero Saulo okintotojtokatinemia non okineltokayah n Cristo, okalakia incha iwa okinkixtiaya kintilantiwits n tlakah iwa n siwameh, iwa okintsakuaya. ");
INSERT INTO nplNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Akimeh ocholojkeh de Jerusalén, sentetl kan ik oyayah otetlapowiayah de n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe, oyá kan se altepetl de Samaria iwa ompa opé kintlapowia de Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Miakeh tlakah omoololoayah iwa ika pakílistli okikakiah tlan Felipe okinmiliaya. Okikakiah iwa okimitayah n milagros non ye okinchiwaya. ");
INSERT INTO nplNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Porke miakeh tlakah non okimpiayah espíritus amokualteh opajtiah, iwa ijkuak n espíritus amokualteh okisayah inmijtik nonteh kokoxkeh, chikaktik otsajtsiah. Miakeh koxomeh iwa non amo oweletiah onejnemiah noiwa opajtiah. ");
INSERT INTO nplNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ika noni, nochteh non ochantitokah itech non altepetl okipiayah miak pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ompa Samaria ochantitoka se tlakatl non itoka Simón, ye achto otetlajchiwiaya iwa okinkajkayawaya n tlakah non ompa ochantitokah, iwa nochteh okimiliaya ye weletini. ");
INSERT INTO nplNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Iwa nochteh okikakiah, non okachi tsijtsikitsi asta non okachi ya teta, iwa okijtoayah: —Nin tlakatl kipia iweletilis Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nochteh oyayah inawak, porke ika itetlajchiwilis miak xiwitl okinkajkaya. ");
INSERT INTO nplNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero ijkuak n tlakah de Samaria okineltokakeh tlan Felipe okinmatiltiaya ijkuak ye okintlapowiaya de Cristo Jesús iwa okinmajsikamatiltiaya tlan kijtosneki itlanawatil Dios, miakeh tlakah iwa siwameh omokuaatekiayah. ");
INSERT INTO nplNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Asta inewia n Simón otlaneltokak iwa omokuaateki, iwa opé kiwikatinemi n Felipe iwa satlawel omotlajtlachialtiaya ijkuak okimitaya n wejweyi milagros iwa neskayolteh non Felipe okinchiwaya. ");
INSERT INTO nplNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iwa ijkuak n tlatematiltijkeh non okatkah Jerusalén okimatkeh miakeh tlakah de Samaria yokiselijkeh itlajtol Dios, okititlankeh n Pedro iwa Juan mawiah ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ijkuak Pedro iwa Juan okalakitoh Samaria, omotiotsajtsilijkeh inawak Dios para nochteh n tokniwah de Samaria non kineltokah Cristo Jesús, makiselikah n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porke nion seme de yejwah yokiselijka n Espíritu Santo, porke san ok omokuatekijkah itech Itoka n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ijkuakó Pedro iwa n Juan okintlalijkeh inmawah impah, iwa non kineltokah Cristo Jesús, okiselijkeh n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ijkuak Simón okitak n Espíritu Santo owaltemoaya ijkuak n tlatematiltijkeh okintlaliliayah inmawah impah, okinkakiti kinmakas tomi, ");
INSERT INTO nplNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","iwa okinmili: —Noiwa ne techmakakah non weletílistli, para ijkuak ne nikintlalis nomawah ipan aka noiwa makiseli n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ijkuakó Pedro okili: —Motomi mapojpoliwi mowa, ken tikyejyekolia tlan Dios kitemaka weleti mokoa ika tomi. ");
INSERT INTO nplNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Te amitla tikpia towah nion mitsnamiki tikchiwas nin tekitl, porke moyolo amo chipawak inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ximolnamiki, iwa xiktlatlaujti Dios mamitstlapojpolwi, chamo ijkó mitstlapojpolwilis tlan otikmoli itech moyolo. ");
INSERT INTO nplNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porke nikita moyolo tentok ika miak nexikólistli, iwa n tlajtlákoli mitstakatsojtok. ");
INSERT INTO nplNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ijkuakó Simón otlanankili: —Xiktlatlautikah Dios amitla manechajsi ika tlan ononnechilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ijkuak yotlankeh okinmatiltijkeh itlajtol Toteko, n tlatematiltijkeh omokopkeh Jerusalén. Iwa itech miakeh altepetsitsinteh de Samaria kan ik opanotiayah, otetlapowiayah de n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Satepa se iángel n Toteko okili n Felipe: —Ximoketsa iwa xio kan tlalmeh non kateh ik tlatsintla, xikonana n ojtli non temoa de Jerusalén iwa onkisa Gaza. Ye ni n ojtli non panoa kan tlaltejtéyinki. ");
INSERT INTO nplNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe owalmóketski iwa oyá, iwa itech ojtli okajsito se tlakatl de Etiopía. Nin tlakatl okatka eunuco iwa okatka weyi tekiwa iwa tesorero inawak n reina Kandace akin otlanawatiaya kan tlali de Etiopía. Ye yowalmokopaya de Jerusalén kan okiweyijkachiwato Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nin tlakatl yowalmokopaya kan ialtépeu, oewatotiwalaya ipan ikarreta iwa okiamapoaya se amatlajkuíloli non okijkuilo n profeta Isaías. ");
INSERT INTO nplNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ijkuakó n Espíritu Santo okili n Felipe: —Xikajsiti neká karreta iwa ximonetecho inakastla. ");
INSERT INTO nplNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ijkuak Felipe okajsito n tlakatl etíope, okikak okiamapoaya itlajkuilol n profeta Isaías, iwa okitlajtlani: —¿Tikajsikamati tlan tikamapoa? ");
INSERT INTO nplNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","N tlakatl okinankili: —¿Kenomi nikajsikamatis, tla amaka nechajsikamatiltia? Iwa okitlatlaujti n Felipe matlejko ipan ikarreta iwa mamotlali inakastla. ");
INSERT INTO nplNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iwa ye ni n tlájtoli non okiamapoaya n tekiwa de Etiopía: Kemi se ichkatsi okiwikakeh kan tlamiktilo; iwa ijkó kemi se ichkakonetl amo tsajtsi ijkuak kiximah, ijkó Ye amitla okijto keman okimiktijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Inmixpah nochteh okipijpinawijkeh iwa amaka okitlajtolpalewi; ¿akin weletis techinmititis ipilwah?, porke okimiktijkeh itech nin tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","N etíope okitlajtlani n Felipe: —Nimitstlatlaujtia, techili, ¿de akin tlajtoa n profeta, de ye inewia noso de ok se? ");
INSERT INTO nplNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ijkuakó Felipe opé kitlapowia de non tlajkuíloli n etíope kan okiamapoaya, iwa opé kajsikamatiltia n kualitlájtoli de Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Okalakitoh kan okatka atl, iwa n tekiwa etíope okijto: —Nika onka atl, amaka nechtsakuilia manimokuaateki. ");
INSERT INTO nplNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe okili: —Tla milák titlaneltoka ika nochi moyolo, weletis timokuaatekis. N tlakatl okinankili: —Nikneltoka Cristo Jesús, Ye Ikone n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ijkuakó otlanawati makiketsaltikah n karreta, iwa san ken ome otemokeh ijtik atl, iwa Felipe okikuaateki n tlakatl etíope. ");
INSERT INTO nplNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ijkuak owalkiskeh ijtik atl, Iespíritu n Toteko Dios okiwík n Felipe, iwa n tekiwa etíope ayakmó oksepa okitak; iwa oyá icha ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pero Felipe okalakito kan altepetl de Azoto, iwa opé kitematiltia n kualitlájtoli de Dios itech miakeh altepemeh asta okalakito Cesarea. ");
INSERT INTO nplNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo ok otlamomojtijtinemia iwa okintemojtinemia akimeh kineltokah n Toteko Jesús, porke ye okinekia kinmiktis. Ika noni oyá okitato n tiópixki non okachi otlayakantoka, ");
INSERT INTO nplNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","okitlajtlanilito makinmaka amameh ixmachotitokeh para ika kinteititis kan sinagogas de Damasco. Iwa ika noni makikawilikah makinkitski n tlakah noso siwameh akimeh okitlakitayah n kualitlájtoli para kualinwikas kintsakuaki Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero ijkuak oyaya itech ojtli iwa yoonajsia Damasco, se tláwili non owalaya de ilwikak okualyawalo. ");
INSERT INTO nplNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ijkuakó n Saulo owetsito ixko tlali, iwa okikak se tlájtoli non okiliaya: —Saulo, Saulo, ¿tleka techtotojtokatinemi? ");
INSERT INTO nplNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ijkuakó Saulo otlájtlanki: —¿Akin tejwatsi Noteko? Ye okijto: —Ne Ni Jesús, tleka techtotojtoka. ");
INSERT INTO nplNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ximoketsa iwa xikalaki kan altepetl. Ompa mitsiliskeh tlan tikchiwas. ");
INSERT INTO nplNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","N tlakah non oyayah iwan Saulo, satlawel omomojtijkeh ken okikakeh n tlájtoli pero amaka okitakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sa okikewaltijkeh n Saulo, pero ijkuak okintlapo ixtololowah mach ok otláchixki. Yika, sa okimatilantiayah iwa okiwikakeh Damasco. ");
INSERT INTO nplNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Eyi tonati amo otlachiaya, amitla okikua nion amitla okonik. ");
INSERT INTO nplNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ompa kan altepetl de Damasco ochantitoka se tlakatl non itoka Ananías non okineltokaya Toteko Jesús. N Toteko okimonextili iwa okili: —¡Ananías! Ye okinankili: —Nika nika, Noteko. ");
INSERT INTO nplNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ijkuakó n Toteko okili: —Ximoketsa iwa xio kan ojtli non kiliah Milaktik, iwa ijkuak tiajsiti icha n Judas xitlajtlani kox ompa kajki se tlakatl de Tarso non itoka Saulo. Ye ompa motiotsajtsilijtok, ");
INSERT INTO nplNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ye okimonextili se tlakatl non itoka Ananías, okitak non tlakatl okalakia kan ye kajki iwa ipa okintlaliaya imawah para oksepa matlachia. ");
INSERT INTO nplNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ijkuak Ananías ijkó okikak, okijto: —Noteko, miakeh yonechtlapowijkeh tlan iteki non tlakatl, iwa nochi tlan yokintokti akimeh mitsneltokah, non chantitokeh Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iwa axa yowala nika, ye kualinwika amameh de n tiopixkeh non tlayakantokeh para makinwika makintsakuati nochteh akimeh kitenewah Motoka. ");
INSERT INTO nplNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero n Toteko okili: —Xio kan nimitstitlantok, porke non tlakatl yonikmopejpenili para manechteixmatilti innawak non amo judíojteh iwa inmixpah miakeh tlanawatijkeh, iwa innawak n tlakah de Israel. ");
INSERT INTO nplNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne nikititis kenijki tlaijyowis ijkuak nechteixmatiltis. ");
INSERT INTO nplNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías oyá kan okalotitoka n Saulo, iwa ijkuak okalak okintlali imawah ipan Saulo, iwa okili: —Nokni Saulo, Noteko Jesús, Akin omitsmonextili itech ojtli kan ik otiwalaya, Ye onechaltítlanki para xitlachia oksepa iwa xikseli n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","San nima opé tetepewi de kan ixtololowah n Saulo siki kemi itotominyo n michi, iwa oksepa otláchixki. Ijkuakó Saulo omóketski iwa okikuaatekijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iwa ijkuak yotlakua, oksepa okónanki chikawálistli iwa ompa omoka kech tonati inwah tokniwah de Damasco non kineltokah n Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Satepa, Saulo opé tetlapowia de itlajtol Dios kan sinagogas, iwa okimiliaya Jesús Ye Ikone n Totajtsi Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nochteh akimeh okikakiah san omotlajtlachialtiayah, iwa okijtoayah: —¿Amo ye nin tlakatl non nepa kan altepetl de Jerusalén okintemojtinemia iwa okintlaijyowiltiayah akimeh motiotsajtsiliah ika Itoka n Jesús? ¿Amo ye non owala okinkitskiko n tokniwah para kintemakatih inmak n tiopixkeh non tlayakantokeh? ");
INSERT INTO nplNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero n Saulo okachi omochikawaya iwa okinkuatlapololtiaya n judíojteh non ochantitokah Damasco, iwa okinmatiltiaya Jesús Ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ijkuak opanokeh sikimeh tonatijmeh ");
INSERT INTO nplNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","omotlatlalwijkeh kimiktiskeh n Saulo. Pero n Saulo okima tlan okinekiah kitoktiskeh n judíojteh. Tlajka iwa n yuak okichichiayah kan ik ikaltenwah n altepetl de Damasco para kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero ijkuak yotleyuak, akimeh okineltokayah Cristo Jesús okontlalijkeh n Saulo ijtik se chikiwitl, iwa okitemowijkeh kan ik tepamitl non okiyawalojtoka non altepetl, iwa ocholo. ");
INSERT INTO nplNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ijkuak Saulo okalakito Jerusalén, okinekia moseitilis iwa tokniwah non kineltokah Cristo Jesús. Pero nochteh okimawiliayah porke amo okineltokayah kox ye noiwa yokineltokaya n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero Bernabé okiwík n Saulo innawak n tlatematiltijkeh iwa okintlapowi kenijki n Saulo okitak iwa okitlapowi n Toteko ijkuak owalaya itech ojtli. Noiwa okinmili kenijki ika miak chikawálistli okiteixmatilti itoka n Jesús ijkuak okatka kan altepetl de Damasco. ");
INSERT INTO nplNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ijkó Saulo omoka Jerusalén inwa n tlaneltokakeh, iwa nochipa onemia sentetl iwa otetlapowijtinemiah ika chikawálistli itech itoka n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Noiwa omotlajtolkokopaya iwan judíojteh non otlajtoayah griego, pero yejwah okitemoliayah kenijki kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yika, ijkuak n tokniwah okimatkeh tlan okinekiah kitoktiskeh, okiwikakeh Cesarea, iwa de ompa okititlankeh mawia Tarso. ");
INSERT INTO nplNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ijkuakó non okineltokayah Cristo Jesús okipiayah yolsewílistli itech tlali de Judea, Galilea iwa Samaria. Okachi omoyolchikawayah otlaneltokayah inawak Toteko. Iwa omomiakiliayah ika iweletilis n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ijkuak Pedro oyá okintlajpaloto n tokniwah kan omoololoayah, noiwa oyá okimitato akimeh yokineltokayah Cristo Jesús non ochantitokah Lida. ");
INSERT INTO nplNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa okajsito se tlakatl non itoka Eneas, non yokiwikaya chikweyi xiwitl wilantok ipan ipetl, porke oikximijmiktoka. ");
INSERT INTO nplNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Iwa Pedro okili: —Eneas, Cristo Jesús mitspajtia. Ximewa iwa xikyejyektlali mopetl. Ijkuakó Eneas san nima owalmejtewak. ");
INSERT INTO nplNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iwa nochteh non ochantitokah kan altepetl de Lida iwa Sarón okitakeh opajtik n Eneas, okikajkeh tlan achto okineltokayah iwa okineltokakeh n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Itech nekateh tonatijmeh kan altepetl de Jope ochantitoka se siwatl non okineltokaya n Toteko non itoka Tabita, itech tlájtoli griego mijtoa Dorcas. Non siwatl nochipa okichiwaya tlan kuali iwa okimpalewiaya akimeh amitla okipiayah. ");
INSERT INTO nplNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pero itech nonteh tonatijmeh Dorcas owalmokoko iwa omikki. Satepa de okipakeh ikuerpo n Dorcas, okiwilankeh tlakpak kan se kuarto. ");
INSERT INTO nplNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","N altepetl de Jope iwan altepetl de Lida mach wejka omotayah, yika san nima ijkuak n tokniwah non kineltokah Cristo okimatkeh Pedro okatka Lida, okintitlankeh ome tlakah makilitih: —Xiwiki san nima. ");
INSERT INTO nplNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro omóketski iwa oyá inwah. Iwa ijkuak yoajsito kan altepetl de Jope, okiwikakeh kan kuarto kan okatka n miketl. Nochteh n iknosiwameh, ochokatokah okiyawalojkeh n Pedro iwa okiititijkeh nochteh n kuemeh iwa n kotomeh non Dorcas okinchijchi ijkuak oyolitoka. ");
INSERT INTO nplNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Otlanki n Pedro okinmili makisakah nochteh, ijkuakó omotlankuáketski iwa omotiotsajtsili; otlanki okontlajtlatak n miketl iwa okili: —¡Tabita, ximewa! Ijkuakó okintlapo ixtololowah, iwa ijkuak okitak n Pedro, omotlali. ");
INSERT INTO nplNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro okimakitski iwa okiketsalti. Otlanki okínnotski non kineltokah Cristo Jesús iwa n iknosiwameh, iwa okinmaktili yolitok. ");
INSERT INTO nplNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nin milagro omoma itech nochi altepetl de Jope, iwa miakeh okineltokakeh n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iwa Pedro omoka miakeh tonatijmeh itech non altepetl, icha n Simón non okintekitia kuítlaxteh. ");
INSERT INTO nplNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kan altepetl non itoka Cesarea ochantitoka se tlakatl non itoka Cornelio, ye kapita innawak se siento de soldadojteh non okintokayotiayah Italianos. ");
INSERT INTO nplNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio iwa nochi ichantlakawah okimopantiayah iwa okiweyijkachiwayah Dios. Iwa Ye okitemakaya miak tomi para kimpalewis ikniwah n judíojteh akimeh amitla okipiayah, iwa nochipa omotiotsajtsiliaya inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Se tonati kemi las tres de tiotlak, Cornelio okitak se tlawilnextílistli kemi yaskia se tejtemiktok. Okitak se iángel Totajtsi Dios non owalkalak kan ye okatka, iwa okili: —¡Cornelio! ");
INSERT INTO nplNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio omoka kisentlajtlatok n ángel porke satlawel okimojti, iwa okijto: —¿Tlan tikmonekiltia Noteko? N ángel okili: —Dios okiseli motiotsajtsilis iwa tlan otikchi ijkuak otikimpalewi non amitla kipiah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Axa, xikintitlani sikimeh tlakah kan altepetl de Jope para makinotsatih n Simón, akin noiwa itoka Pedro. ");
INSERT INTO nplNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ye mokalotijtok icha n ok se Simón, non kintekiti kuítlaxteh, iwa chantitok itempa n atl, ye mitsilis tlan tikchiwas. ");
INSERT INTO nplNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ijkuak n ángel oyá, Cornelio okínnotski ome itlakawah iwa se isoldado akin okitlakitaya iwa okimopantiaya Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelio okinmatilti nochi tlan otlamochijka, iwa satepa okintítlanki kan altepetl de Jope. ");
INSERT INTO nplNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ijkuak owalmostlatik kemi tlajko tonati, ijkuak oyayah itech ojtli iwa yoonajsiah Jope, Pedro otlejkok omotiotsajtsilito ikpak kali. ");
INSERT INTO nplNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Non ora oxitlatlatoka iwa okinekia tlakuas. Pero ijkuak okichijchiwilijtokah tlan kikuas, okitak se tlawilnextílistli kemi ijkuak se tejtemiki, ");
INSERT INTO nplNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","iwa okitak n ilwikak omotlapo iwa itla kemi se patlawak manta non oilpitiwalaya ik nawi ipuntajwah, owaltemoaya ixko tlali. ");
INSERT INTO nplNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Itech non manta owalayah miakeh yolkameh de nawi inmikxiwah, yolkameh non motilanah ixko tlali iwa totomeh. ");
INSERT INTO nplNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ijkuakó okikak se tlájtoli non okili: —Ximoketsa Pedro, xitlamikti iwa xitlakua. ");
INSERT INTO nplNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro otlanankili: —Amó, Noteko, porke ayik nikuajtika itla tlan amo chipawak nion itla pitsotik. ");
INSERT INTO nplNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","N tlájtoli oksepa okínotski iwa okili: —Tlan Dios yokichipa, amo xikijto amo chipawak. ");
INSERT INTO nplNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ijkó otlamochi eyi welta, iwa san nima n manta oksepa omókopki ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro omoka san tlakaktok, omokuatlapowijtoka tlan kijtosneki tlan okimonextili. Ijkuakó okalakikoh kan kaltentli itlakawah n Cornelio non otlajtlantiwalayah kan icha n Simón. ");
INSERT INTO nplNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Otlakakalatskeh iwa otlajtlankeh kox ompa okalotitoka se tlakatl non itoka Simón, akin noiwa kinotsah Pedro. ");
INSERT INTO nplNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Iwa kemi Pedro ok omokuatlapowijtoka tlan kijtosneki tlan okimonextili, n Espíritu Santo okili: —Xikkaki, eyi tlakah mitstemoah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ximoketsa, xitemo iwa xio inwah. Amo xikmoli kox tias noso amó, porke Ne onikintítlanki. ");
INSERT INTO nplNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ijkuakó Pedro otemok okinmajsito n tlakah non Cornelio okwalintítlanki, iwa okinmili: —Ye ne akin nomejwah nonkitemoah, ¿tlan nonkimonekiltiah? ");
INSERT INTO nplNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yejwah otlanankilijkeh: —Otechaltítlanki n kapita Cornelio. Ye se tlakatl yekmilajka iwa kitlakita Dios, iwa nochteh n judíojteh kitlakitah iwa kitlasojtlah. Se iángel Dios okili mamitsnotsaki iwa xiwia icha, para makikaki nochi tlan tejwatsi tikilis. ");
INSERT INTO nplNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ijkuakó Pedro okinkalaki ijtik icha iwa okinkaloti non yúali. Keman owalmostlatik Pedro oyá inwah. Sikimeh tokniwah de Jope noiwa oyajkeh inwah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ijkuak owalbiktlatik okalakitoh Cesarea kan Cornelio sa okinchixtoka. Noiwa ompa okatka ichantlakawah iwa oksikimeh tlakah non satlawel íwa omowikaya. ");
INSERT INTO nplNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ijkuak Pedro okalakito, Cornelio okiski okinselito kan kaltentli iwa san nima owalmotlankuáketski iyakapa para kiweyiliskia. ");
INSERT INTO nplNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedro okiketsalti, iwa okili: —Ximoketsa, porke ne noiwa san ni tlakatl kemi te. ");
INSERT INTO nplNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iwa motlapowijtiwih okalakeh sansikah. Ompa ijtik kali Pedro okinmajsito miakeh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ijkuakó Pedro okinmili: —Nomejwah kuali nonkimatokeh itlanawatil Moisés amo techkawilia tejwah akimeh ti judíojteh matimonelokah iwa akimeh amo judíojteh, nion matikalaktinemikah incha. Pero Dios yonechititi amaka manikita kemi yaskia amitla ipati noso amo chipawak inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yika, san nima ijkuak onechilijkeh maniwiki oniwalewak iwa mach onikijto kox amo niweletis niwits. Axa nikneki nikmatis, tleka onontlatitlankeh manechnotsatih. ");
INSERT INTO nplNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ijkuakó Cornelio otlanankili: —Ya kipia nawi tonati, kemi nin ora las tres de tiotlak, ne onimotiotsajtsilijtoka nika nocha, ijkuakó se tlakatl non otsotlania itlakeh, omoketsako noyakapa. ");
INSERT INTO nplNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iwa onechili: “Cornelio, Dios okikak motiotsajtsilis iwa Ye okilnamik kenijki tikimpalewia akimeh amitla kipiah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Axa kiné, xikintitlani motlakawah kan altepetl de Jope makinotsatih n Simón akin noiwa itoka Pedro. Ye kalotitok icha n ok se Simón non kintekiti kuitlaxteh iwa chantitok itempa n atl.” ");
INSERT INTO nplNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yika totokatijkak onikintítlanki notlakawah mamitstemotih, iwa kuali otikchi otiwala. Axa nika tikateh tinochteh ixpa n Totajtsi Dios, iwa tiknekih tikkakiskeh nochi tlan Toteko omitsnawati techiliki. ");
INSERT INTO nplNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ijkuakó Pedro opé tlajtoa iwa okijto: —Axa nikajsikamati, Dios amo kintlasojtla san sikimeh, iwa oksikimeh amó, ");
INSERT INTO nplNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yej itech nochi nin tlaltíkpaktli, Dios kinselia akimeh kitlakitah iwa kichiwah tlan kuali. ");
INSERT INTO nplNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Totajtsi Dios okwaltítlanki Cristo Jesús makinmatiltiki nochteh n tlakah de Israel n kualitlájtoli non kitemakah yolsewílistli, Jesús Ye n Toteko de tejwah tinochteh. ");
INSERT INTO nplNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nomejwah kuali nonkimatokeh nochi tlan opanok kan chantitokeh n judíojteh. Opejki kan tlali de Galilea, ijkuak Juan Bautista otlamachti iwa otlakuaateki. ");
INSERT INTO nplNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nomejwah nonkimatokeh kenijki Dios okimák weletílistli n Jesús de Nazaret ika n Espíritu Santo, iwa kenijki Ye okitechiwilijtinemia tlan kuali iwa okimpajtiaya nochteh akimeh otlaijyowijtinemia imak n diablo. Jesús okichi nochi noni porke Dios okipalewiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Iwa tejwah kuali tikmatokeh nochi tlan Jesús okichi ompa kan tlali de Judea iwa itech Jerusalén. Pero satepa okimiktijkeh ipan se krus. ");
INSERT INTO nplNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iwa ipan eyi tonati, Dios okiyoliti iwa okichi matechmonextili tejwah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Amo okinmonextili nochteh n tlakah, yej sanwel tejwah akimeh Dios achto yotechpejpenka para matiktematiltikah tlan Jesús okichi. Iwa ijkuak Jesús omoyoliti, tejwah otitlakuajkeh iwa otikonikeh íwa. ");
INSERT INTO nplNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Noiwa otechnawati matitetlapowikah iwa matikinmatiltikah n tlakah, Dios okitlali n Jesús kemi teyolsewi innawak non yolitokeh iwa akimeh yomikkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iwa ya wejkawitl, nochteh n profetas yotlajtoayah de Jesús, okijtoayah nochteh akimeh tlaneltokaskiah itech Itoka n Jesús, Dios kintlapojpolwiskia de intlajtlakolwah. ");
INSERT INTO nplNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro ok otlajtojtoka ijkuak n Espíritu Santo owala intech nochteh akimeh okikaktokah tlan okimiliaya. ");
INSERT INTO nplNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iwa n judíojteh non okineltokayah Cristo Jesús non owalajkeh iwan Pedro, san omotlajtlachialtijkeh ijkuak okitakeh Dios noiwa okinmák n Espíritu Santo akimeh amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porke okinkakiah otlajtoayah iwa okiweyijkachiwayah Dios ika oksikimeh tlájtolteh. ");
INSERT INTO nplNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ijkuakó Pedro okinmili: —Ninteh tlakah noiwa yokiselijkeh n Espíritu Santo kemi tejwah, ¿kox onka se akin amo kitekawilis mamokuaatekikah ninteh tlakah? ");
INSERT INTO nplNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iwa san nima Pedro otlanawati makinkuaatekikah itech Itoka n Cristo Jesús. Otlanki yejwah okitlatlautijkeh n Pedro mamokawa kanaj kech tonati inwah. ");
INSERT INTO nplNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","N tlatematiltijkeh iwa n tokniwah non okatkah Judea akimeh okineltokayah n Cristo Jesús okimatkeh noiwa non amo judíojteh yokineltokakeh itlajtol Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iwa ijkuak Pedro omókopki Jerusalén, okajwakeh sikimeh judíojteh non osirkunsidaritokah iwa yokineltokakeh n Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Yejwah okitlajtlanijkeh: —¿Tleka tikalaktinemi incha non amo sirkunsidaritokeh, iwa titlakuajtinemi inwah? ");
INSERT INTO nplNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ijkuakó Pedro opé kintlapowia nochi tlan omochi, iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ne onikatka kan altepetl non itoka Jope, iwa ijkuak onimotiotsajtsilijtoka, opé kemi yaskia nitejtemiktok, onikitak owaltemok de ilwikak kemi se manta patlawak non oilpitiwalaya itech nawi ipuntajwah iwa omotlaliko noyakapa. ");
INSERT INTO nplNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ijkuak oniontláchixki ijtik non manta, onikinmitak sikimeh yolkameh non okimpiayah nawi inmikxiwah, sikimeh yolkameh tekuanimeh, sikimeh non motilanah ixkotlali iwa miakeh totomeh. ");
INSERT INTO nplNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iwa onikak se tlájtoli non onechili: “Ximoketsa Pedro, xitlamikti iwa xitlakua.” ");
INSERT INTO nplNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero Ne onitlanankili: “Amó, Noteko, porke ayik nikuajtika itla tlan amo chipawak nion itla pitsotik.” ");
INSERT INTO nplNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ijkuakó n tlájtoli non onechaltlapowiaya de ilwikak, oksepa onechili: “Tlan Dios yokichipa, amo xikijto amo chipawak.” ");
INSERT INTO nplNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ijkó otlamochi eyi welta, iwa otlanki san ken kajki oksepa otlejkok ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ijkuakó eyi tlakah okalakitoh kan onikalotitoka. Yejwah okwalintitlankeh desde Cesarea para manechtemokih. ");
INSERT INTO nplNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Iwa n Espíritu Santo onechnawati manio inwah, iwa amo manikmoli kox nias noso amó. Noiwa nowa oyajkeh ninteh chikwase n tokniwah non nika kateh. Tinochteh otikalakeh ichan se tlakatl, ");
INSERT INTO nplNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","non otechtlapowi kenijki ompa icha okitak omoketoka se ángel, iwa okili: “Xikintitlani sikimeh tlakah kan altepetl de Jope makinotsatih n Simón, akin noiwa kinotsah Pedro, ");
INSERT INTO nplNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ye mitsilis kenomi nomechtlapojpolwiskeh de nomotlajtlakolwah, te iwa nochi mochantlakawah.” ");
INSERT INTO nplNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Iwa ijkuak opé nikintlapowia, n Espíritu Santo owala intech, ijkó kemi achto owala totech. ");
INSERT INTO nplNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ijkuakó onikilnamik tlan okijto n Toteko: “Milák, Juan otlakuaateki ika atl, pero nomejwah nonmokuaatekiskeh ika n Espíritu Santo.” ");
INSERT INTO nplNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Iwa tla Totajtsi Dios noiwa yejwah okinmák tlan tejwah otechtliokoli ijkuak otikneltokakeh n Toteko Cristo Jesús, ¿akin ne para nikilis Dios amo ijkó makichiwa? ");
INSERT INTO nplNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ijkuak n tokniwah de Jerusalén okikakeh nochi ni tlan Pedro okinmili, omoyolsewijkeh iwa okiweyijkachijkeh Dios, iwa okijtojkeh: —¡Axa tikajsikamatih Dios noiwa kinkawilia mamolnamikikah non amo judíojteh, iwa makipiakah n semijkak yolílistli! ");
INSERT INTO nplNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Non tonati ijkuak okimiktijkeh n Esteban, noiwa opé kintotojtokah akimeh noiwa okineltokayah Cristo Jesús, iwa sikimeh ochocholojkeh Fenicia, Chipre iwa Antioquía. Ompa okinmatiltijkeh itlajtol Dios sanwel n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero sikimeh non otlaneltokayah itech Cristo Jesús okatkah de Chipre iwa de Cirene. Ijkuak okalakikoh kan altepetl de Antioquía noiwa opé kitematiltiah n kualitlájtoli de Dios n tlakah de Grecia. ");
INSERT INTO nplNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Iweletilis n Toteko Dios okatka inwah iwa okimpalewiaya. Miakeh okineltokakeh iwa omoyolpatlayah inawak Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ijkuak n tokniwah de Jerusalén non okineltokayah Cristo Jesús okimatkeh tlan opanotoka kan altepetl de Antioquía, okititlankeh n Bernabé mawia ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ijkuak Bernabé okalakito Antioquía iwa okitak kenijki Dios okintiochijtoka, saikpanoa opakmik. Okinyolchika nochteh, iwa okinmili nochipa makitlakitakah n Toteko ika nochi inyolo. ");
INSERT INTO nplNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé okatka kuali tlakatl, otentoka ika n Espíritu Santo iwa okiyekneltokaya n Toteko. Yika miakeh omoseitiliayah inawak n Toteko. ");
INSERT INTO nplNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Satepa, Bernabé oyá kan altepetl de Tarso okitemoto n Saulo, iwa ijkuak okajsik, okiwík para Antioquía. ");
INSERT INTO nplNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Saulo iwa Bernabé omokajkeh se xiwitl iwan akimeh kineltokah n Cristo Jesús non ompa ochantitokah, iwa miakeh tlakah okinmachtijkeh. Ompa Antioquía opé kintokayotiah cristianos n tokniwah non kineltokah Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Itech nekateh tonatijmeh sikimeh profetas non owalayah de Jerusalén okalakitoh Antioquía. ");
INSERT INTO nplNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iwa seme de yejwah non omonotsaya Ágabo, owalmóketski iwa ika ichikawalis n Espíritu okinmatilti n tokniwah non ompa okatkah walaskia se weyi apisotl itech nochi n tlaltíkpaktli. Iwa milák ijkó otlamochi itech nekateh tonatijmeh ijkuak Claudio okatka weyi tekiwa de Roma. ");
INSERT INTO nplNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ijkuakó n tokniwah de Antioquía akimeh okineltokayah n Cristo Jesús, omotlapowijkeh iwa omokajkeh kimpalewiskeh ika tlan weletis, iwa kintitlaniliskeh n tokniwah non ochantitokah Judea. ");
INSERT INTO nplNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iwa milák okichijkeh. Nochi tlan okoololojkeh, okimakakeh n Bernabé iwa Saulo, iwa yejwah oyajkeh okinmakatoh n tetajmeh non ompa tlayakantokeh. ");
INSERT INTO nplNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Itech nekateh tonatijmeh, n rey Herodes Agripa Primero opé kintotojtoka sikimeh tokniwah non kineltokah Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Otlanawati makimiktikah ika espada n Jacobo, ikni n Juan, ");
INSERT INTO nplNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","iwa kemi okitak okiwilitakeh n judíojteh, noiwa okitsak n Pedro. Ni otlamochi itech ilwitl de Paskua ijkuak mokua n paj non amo kipia levadura. ");
INSERT INTO nplNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ijkuak Herodes okikitski n Pedro, okitsak telpiloya iwa ompa okintlali nanawi soldadojteh para makimokuitlawijtokah. Herodes okimoliaya kikixtis ixpa n tlakah de non altepetl asta mapano n ilwitl de Paskua. ");
INSERT INTO nplNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ijkó kiné, Pedro otsaktoka telpiloya iwa kuali okimokuitlawijtokah, pero akimeh okineltokayah Cristo Jesús nochipa omotiotsajtsiliayah por ye. ");
INSERT INTO nplNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pedro okochtoka iwa oilpitoka ika ome kadenajteh, iwa tlanajnakastla ome soldadojteh. Noiwa oksikimeh soldadojteh okimokuitlawijtokah kaltempa. Non yúali Herodes okimoli kikixtis n Pedro ijkuak tlanesis, iwa kiteixpantis innawak n tlakah de non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ijkuakó ompa kan otsaktoka n Pedro owalmonexti se iángel n Toteko Dios iwa se tláwili okintlawilnextili. N ángel okolini n Pedro kan ikespa, okijxiti iwa okili: —¡Ximejtiwetsi! Ijkuakó n kadenajteh non ika omailpitoka n Pedro, owetskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Iwa n ángel okili: —Ximotlajkoilpi iwa ximokakti. Ijkuak Pedro yomotlajkotelini iwa yomokakti, n ángel oksepa okili: —Xikmokenti mokapa iwa xiwiki nowa. ");
INSERT INTO nplNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro oyá iwan ángel maya amo okimatia kox milák noso amo milák tlan okichiwaya n ángel. Ye okimoliaya chamo san tejtemiktok. ");
INSERT INTO nplNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pero achto okimpanawijkeh sikimeh soldadojteh non ompa otlamokuitlawijtokah, otlanki okimpanawijkeh oksikimeh soldadojteh. Ijkuak okalakitoh kan sawa de tépostli non okatka itempa n ojtli iselti owalmotlapo, iwa ijkuak yonejnenkeh ok se ojtli sansikah, n ángel okikajte iselti n Pedro. ");
INSERT INTO nplNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ijkuakó Pedro okajsikama tlan opanotoka, iwa okijto: —Axa ya nikajsikamati n Toteko Dios, Ye Akin okwaltítlanki iángel, manechpalewiki imak Herodes iwa de nochi tlan judíojteh okinekiah nechtoktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ijkuak kuali yokajsikama milák yokiski de kan otsaktoka, Pedro oyá icha n María, ina n Juan akin noiwa kinotsah Marcos. Ompa okatkah miakeh non omotiotsajtsilijtokah. ");
INSERT INTO nplNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ijkuak Pedro otlakakálatski itech kaltentli non okatka kan patio, se íchpochtli non itoka Rode otlachiato akin otlakakalatoka. ");
INSERT INTO nplNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pero ijkuak okitenkak n Pedro, mach otlatlapo iwa satlawel opaki. Yej omotlelo tlaijtik okimilito, Pedro tlakakalatok itech kaltentli. ");
INSERT INTO nplNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yejwah okilijkeh: —¡San tikuamimiktik! Iwa maya ye okimiliaya milák Pedro okatka itech kaltentli, yejwah okijtoayah: —Mach ye, san iángel. ");
INSERT INTO nplNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro omoka tlakakalatok, iwa ijkuak otlatlapojkeh iwa okitakeh, san omotlajtlachialtijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero Pedro san okimanotski amo matlajtokah. Iwa otlanki opé kintlapowia kenijki Toteko Dios okikixti de kan otsaktoka. Iwa okinmili: —Nochi tlan onomechili, xikmatiltikah n Jacobo iwa n oksikimeh tokniwah. Ijkuakó okiski iwa oyajki oksika. ");
INSERT INTO nplNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ijkuak otláneski, n soldadojteh opé motletleloah iwa mach okimatiah tlan kichiwaskeh porke amo okimatiah kan ik oyá n Pedro. ");
INSERT INTO nplNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes Agripa Primero otlanawati makitemotih n Pedro, pero kemi amo okajsikeh, okintlatsintoki n soldadojteh iwa otlanawati makinmiktikah. Satepa Herodes Agripa Primero okiski de Judea iwa ochanchiwato Cesarea. ");
INSERT INTO nplNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes Agripa Primero okualantoka iwa n tlakah non ochantitokah Tiro iwa Sidón, pero yejwah omotlapowijkeh iwa omoyekkajkeh yaskiah kitatiweh n Herodes para makintlapojpolwi. Yika okimotlatlalwijkeh n Blasto akin okatka tekiwa de n rey, para makintlajtolpalewi inawak Agripa, porke n tlakah de Tiro iwa Sidón okonkuiah tlan kikuaskeh kan ipaís n rey. ");
INSERT INTO nplNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes Agripa Primero okitlali se tonati ijkuak motlapowiskia inwah, iwa ijkuak oajsik non tonati, okinmonaki itlakenwah non kinmonakiah n reyes, omoyayanti iwa opé kintlapowia. ");
INSERT INTO nplNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ijkuakó n tlakah opé tsajtsih: —¡Akin tlajtojtok amo san se tlakatl, yej se dios! ");
INSERT INTO nplNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","San nima ompa kan okatka, se iángel Toteko Dios okichi mamokokojtiwetsi n Herodes Agripa Primero, porke amo okiweyijkachi Dios, ookuiloak iwa omikki. ");
INSERT INTO nplNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero itlajtol Dios okachi omoxitiniaya, iwa sentetl omotetlapowiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ijkuak Bernabé iwa Saulo yokitlamijkeh inteki kan altepetl de Jerusalén, owalmokopkeh Antioquía iwa okualikakeh inwah n Juan akin noiwa itoka Marcos. ");
INSERT INTO nplNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Itech altepetl de Antioquía kan omoololoayah non kineltokah Cristo Jesús, okatkah profetas iwa tlamachtijkeh. Yejwah ninteh: Bernabé, Simón akin okitokayotiayah Tliliwik, Lucio de Cirene, Manaén, non omoskalti iwan Herodes Antipas Primero n tlanawati de Galilea, iwa Saulo. ");
INSERT INTO nplNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Se tonati, ijkuak yejwah omotiotsajtsilijtokah iwa omosaujtokah, n Espíritu Santo okijto: —Techxelilikah n Bernabé iwa Saulo para makichiwakah n tekitl non yonikimpejpenili. ");
INSERT INTO nplNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Satepa, ijkuak yotlankeh omotiotsajtsilijkeh iwa omosaujkeh, okintlalijkeh inmawah impah, iwa okinmakajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Satepa, n Espíritu Santo okintítlanki n Bernabé iwa Saulo, iwa oyajkeh Seleucia, iwa ompa otlejkokeh itech se barko iwa oyajkeh Chipre. ");
INSERT INTO nplNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ijkuak okalakitoh kan altepetl de Salamina non kajki itempa n weyi atl, ompa opé kitematiltiah itlajtol Dios kan insinagogajwah n judíojteh. Juan noiwa oyaya inwah iwa okimpalewiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Onentinenkeh itech nochi n isla iwa okalakitoh kan altepetl de Pafos, ompa okajsitoh se tetlajchiwi israelita non itoka Barjesús akin otlakajkayawaya iwa okijtoaya ye profeta. ");
INSERT INTO nplNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nin tetlajchiwi omowikaya iwan tekiwa Sergio Paulo, akin okatka se tlakatl ixtlamatini. Ye otlanawati makinnotsatih n Bernabé iwa Saulo, porke okinekia kikakis itemachtilis Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero Barjesús n tetlajchiwi, akin noiwa itoka Elimas, omokuejso iwan Bernabé iwa Saulo, porke amo okinekia makineltoka itlajtol Dios n tekiwa Sergio Paulo. ");
INSERT INTO nplNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ijkuakó n Saulo, akin noiwa itoka Pablo, kemi okipixtoka n Espíritu Santo, okisentlajtlatak n tetlajchiwi ");
INSERT INTO nplNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","iwa okili: —¡Tekajkaya, teyolijtlako! ¡Ikone n diablo iwa tetlawelitak de nochi tlan kuali! ¿Asta kemania tikinkawas tikinkajkayajtinemis n tlakah para amo makajsikah n milaktik ojtli de Dios? ");
INSERT INTO nplNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ika noni, n Toteko Dios mitstlaijyowiltis iwa ayakmó weletis titlachias kanaj kech tonati, iwa mach weletis tikitas itlawilnextilis n tonati. San nima n Elimas owalixtlejtlepuyawakeh ixtololowah, iwa sa otlamatemoaya para makimatilanakah ken ayakmó otlachiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ijkuak n tekiwa okitak tlan opanok, okineltokak Toteko, porke okitlajtlachialti itlamachtilis. ");
INSERT INTO nplNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo iwa akimeh oyayah inwah otlejkokeh itech barko, okiskeh de Pafos iwa oyajkeh kan altepetl de Perge kan tlali de Panfilia. Pero Juan Marcos okinkakajte iwa omókopki Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Satepa okiskeh de Perge iwa oyajkeh kan altepetl de Antioquía, non kajki itech tlali de Pisidia. Iwa itech sábado ijkuak mosewia n judíos, okalakeh kan sinagoga iwa ompa omotlajtlalijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Satepa, ijkuak yotlankeh okiamapojkeh itlanawatil Moisés iwa intlajkuilol n profetas, n tlanawatijkeh de non tiopa, okilijkeh se tlakatl non ompa okatka makoninmiliti n Pablo iwa Bernabé ijkí: —Nokniwah, tla nonkipiah itla tlájtoli non ika weletis nonkinyolchikawaskeh akimeh nika kateh, weletis nonkijtoskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ijkuakó Pablo owalmóketski, okinmánotski para san matlakaktokah, iwa okijto: —Xikkakikah tlakah de Israel, iwa nomejwah akimeh nonkitlakitah Dios: ");
INSERT INTO nplNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","N Dios de Israel okimpéjpenki totatawah. Ye okiweyijkatlali topueblo maya amo intlal ompa kan okatkah ijkuak okatkah kan tlali de Egipto. Iwa satepa ika iweletilis okinkixti de ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios okinxikoli nochi tlan yejwah okichiwayah kan amaka chanti kemi ome póali (40) xiwitl, ");
INSERT INTO nplNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","iwa okimpojpolo n tlakah de chikome nasiones non ochantitokah itech tlalmeh de Canaán, iwa nonteh tlalmeh okinmaxkatili totatawah. ");
INSERT INTO nplNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Satepa, kemi nawisiento iwa ome póali iwa májtlaktli (450) xiwitl, Dios okintlali jueses non okinnawatijtokah asta nekateh tonatijmeh ijkuak owala n profeta Samuel. ");
INSERT INTO nplNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ijkuakó yejwah okitlajtlanilijkeh Dios makintlalili se rey para makinnawatijto, iwa Dios okinmák n Saúl akin okinnawatijtoka ome póali (40) xiwitl. Nin Saúl ye ikone n Cis, iwejkaixwi n Benjamín. ");
INSERT INTO nplNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Satepa, Dios okipatlak n Saúl, iwa okitlali n David mayeto inrey, iwa Dios okijto: “Yonikajsik David, ikone n Isaí, se tlakatl akin nechpaktia iwa kichiwas nochi tlan Ne nikneki.” ");
INSERT INTO nplNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Iwa se ixwi non walewatok de David, Ye n Jesús Akin Dios okitítlanki para makinmakixtiki n tlakah de Israel kemi yowejka okijtojka kititlaniskia. ");
INSERT INTO nplNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ijkuak Jesús ayamó owalaya, n Juan okinmatiltiaya itlajtol Dios n tlakah de Israel, iwa okimiliaya mamoyolpatlakah inawak Dios iwa mamokuaatekikah. ");
INSERT INTO nplNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Iwa ijkuak Juan yoyaya mikiti, okijto: “Mach ne akin nomejwah non kimoliah, porke nokuitlapa wits se akin ne amo nimixewia nikaktojtomas.” ");
INSERT INTO nplNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","'Nokniwah, nomejwah akimeh nonwalewatokeh de Abraham, iwa nomejwah akimeh amo non judíojteh pero nonkitlakitah Dios: nomejwah nomechtitlaniliah nin tlájtoli non techmakixtia. ");
INSERT INTO nplNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Porke akimeh ochanchiwayah Jerusalén iwa intlayakanwah mach okimatiah kox Jesús, nion okajsikamatiah intlajtol n profetas maya okiamapoaya itech sinagogas nochi sábado. Yika, ijkuak okimiktijkeh n Jesús, innewiah okichijkeh tlan ya wejkawitl okijtojkeh n profetas. ");
INSERT INTO nplNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iwa maya amo okipiaya itla tlajtlákoli para kimiktiskiah, yejwah okitlajtlanilijkeh n Pilato matlanawati makimiktikah. ");
INSERT INTO nplNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Satepa ijkuak okitoktijkeh n Jesús nochi tlan oijkuilitokah. Okitemowijkeh de kan krus iwa okitookakeh ijtik se miketékochtli. ");
INSERT INTO nplNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero Dios okiyoliti de kan kateh non yomikkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iwa miakeh tonatijmeh Jesús okinmonextili akimeh iwa oyajkeh desde Galilea asta Jerusalén. Iwa axa yejwah tetlapowiah de Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","'Iwa axa, tejwah tomechmatiltijtokeh nin kualitlájtoli non yowejka Dios okinmili totatawah kichiwaskiah. ");
INSERT INTO nplNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Iwa tejwah ken ipilwah totatawah, Dios yotechchiwili tlan yowejka okinsentlalili totatawah ijkuak okiyoliti n Jesús. Kemi ijkuilitok itech non ipan ome Salmo: “Te tinokone; iwa axa Ne onimitsyoliti.” ");
INSERT INTO nplNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios yokijtojka kiyolitiskia de kan kateh non yomikkeh para ikuerpo amo maijtlakawi, ijkó kemi okijto itech itlajkuilol Dios: “Nomechmakas notlatiochiwalis non yowejka onikili n David nikmakaskia.” ");
INSERT INTO nplNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yika noiwa kijtoa itech ok se Salmo: “Amo tikkawas maijtlakawi ikuerpo Mokone yolchipawak.” ");
INSERT INTO nplNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Porke milák matikijtokah, ijkuak David oyolitoka, okimpalewi ikniwah n judíojteh ijkó kemi Dios okinawati, iwa ijkuak omikki omoseitilito iwa itatawah, iwa ikuerpo opajpálanki. ");
INSERT INTO nplNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero neká akin Dios okiyoliti, ikuerpo mach opajpálanki. ");
INSERT INTO nplNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nokniwah, nomejwah nonkipiah nonkimatiskeh sanwel Jesús weletis nomechtlapojpolwis de nomotlajtlakol. ");
INSERT INTO nplNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nochteh akimeh kineltokah n Jesús, Dios kintlapojpolwia, mach kemi itlanawatil Moisés amo owéletki okintlapojpolwi. ");
INSERT INTO nplNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yika, kuali ximotlachilikah, amo kichiwa nomopah wetsiki tlan okijkuilojkeh n profetas, ijkuak okijtojkeh: ");
INSERT INTO nplNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Xikkakikah, nomejwah tepijpinawijkeh, ximotlajtlachialtikah iwa xipoliwikah, porke nikchiwas se weyi neskayotl ijkuak ok nonyolitoskeh, kuajkualtsi yetos iwa mach nonkineltokaskeh maya aka manomechtlapowi tlan onikchi. ");
INSERT INTO nplNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ijkuak Pablo iwa Bernabé okiskeh de insinagoga n judíojteh, sikimeh non amo judíojteh okintlatlaujtijkeh oksepa makintlapowiti de nin tlamachtílistli itech non ok se sábado. ");
INSERT INTO nplNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ijkuak yotlankeh omomachtijkeh iwa yopé kisah de insinagoga, miakeh judíojteh iwa akimeh yokiselijkah intemachtilis n judíojteh, oyajkeh iwan Pablo iwa Bernabé. Iwa yejwah okimiliayah kuali mamoyekketokah itech itlasojtlalis Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ijkuak owalchikometik, ipan sábado, n altepetl de Antioquía omonoki, porke miaktikeh tlakah non ompa ochantitokah owalajkeh okikakikoh itlajtol Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero ijkuak n judíojteh okitakeh miaktikeh n tlakah omoololojkeh, satlawel oxikojmikeh iwa opé kitlajtolkopah n Pablo iwa fiero okitenewayah. ");
INSERT INTO nplNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ijkuakó n Pablo iwan Bernabé, omoyolchikajkeh iwa okimilijkeh: —Omonekia matomechmatiltikah itlajtol Dios achto nomejwah judíojteh. Pero kemi amo nonkinekih nonkiseliskeh, iwa kemi amo nonmomachiliah nonkualteh kemi para nonyolitoskeh nochipa, yika okachi kuali tiawih tikinmatiltitiweh itlajtol Dios akimeh amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porke ijkó otechnawati n Toteko Dios, ijkuak okijto: Onimitstlali kemi se tláwili para tikintlawilis nochteh n tlaltikpaktlakah, iwa sentetl tikimpalewis asta kan tlami n tlaltíkpaktli. ");
INSERT INTO nplNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ijkuak non amo judíojteh, okikakeh tlan Pablo okijto, oyolpakeh miak iwa opé kijtoah kualtsi itlajtol n Toteko. Iwa okineltokakeh Cristo Jesús nochteh akimeh Dios yokimpejpenka para mayolitokah nochipa. ");
INSERT INTO nplNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Iwa ijkó omotetlapowi itlajtol n Toteko itech nochi neká tlali. ");
INSERT INTO nplNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero n judíojteh okintlatlapowijkeh sikimeh siwameh yolmilawakeh non okachi okintlakitayah. Noiwa okintlatlalwijkeh sikimeh tlakah non okachi oweyijkatitokah itech non altepetl para makintotojtokakah n Pablo iwa Bernabé iwa makinkixtikah de ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ijkuakó n tlatematiltijkeh omokxitsejtselojkeh para makitakah amo intlajtlakol tla yejwah amo kiseliah itlajtol Dios, iwa oonewakeh kan altepetl de Iconio. ");
INSERT INTO nplNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero n tokniwah non kineltokah Cristo Jesús oyoltentokah ika miak pakílistli iwa ika n Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ijkuak yokatkah kan altepetl de Iconio, Pablo iwa Bernabé okalakeh sansikah kan insinagoga n judíojteh iwa ika miak weletílistli okintlapowijkeh. Yika, miakeh judíojteh okineltokakeh Cristo Jesús iwa non amo judíojteh noiwa. ");
INSERT INTO nplNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero n judíojteh non amo okineltokayah Cristo Jesús, okintlatlapowijkeh akimeh amo judíojteh para amo makikakikah n Pablo nion Bernabé. ");
INSERT INTO nplNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pero Pablo iwa Bernabé ompa omokajkeh miakeh tonatijmeh iwa otetlapowiayah ika miak yolchikawálistli. Iwa Toteko Dios okinmakaya weletílistli para makinchiwakah milagros iwa wejweyi neskayolteh, iwa ijkó n tlakah makitakah milák tlan yejwah okijtoayah de itlasojtlalis Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero n tlakah non ochantitokah Iconio oxexelitokah, sikimeh okatkah iwan judíojteh iwa oksikimeh iwan tlatematiltijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ijkuakó sikimeh judíojteh iwa non amo judíojteh, omotlatlalwijkeh iwan tekiwajkeh para kinwijwikaltiskeh n tlatematiltijkeh iwa kinmojmotlaskeh ika tetl. ");
INSERT INTO nplNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero ijkuak Pablo iwan Bernabé okimatkeh tlan okinekiah kintoktiskeh, ocholojkeh iwa oyajkeh kan altepetl de Listra iwa Derbe, ninteh altepemeh kateh kan tlali de Licaonia. Iwa itech miakeh oksikimeh altepemeh non ik ompa okatkah, ");
INSERT INTO nplNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","noiwa okitematiltiayah itlajtol Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kan altepetl de Listra okatka se tlakatl non amo oweletia onejnemia. Nin tlakatl ompa oewatoka porke ye ijkó otlákatki, iwa ayik onéjnenki. ");
INSERT INTO nplNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nin tlakatl okikaktoka nochi tlan Pablo okijtoaya, Pablo okiyektlajtlatak iwa okitak non tlakatl milák okineltokaya Dios weletis kipajtis. ");
INSERT INTO nplNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ijkuakó Pablo okili ika chikawak tlájtoli: —Ximoketsa iwa xikinyekmilawa mokxiwah. Iwa non tlakatl san nima owalmoketewak iwa opé nejnemi. ");
INSERT INTO nplNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ijkuak n tlakah de non altepetl okitakeh tlan okichi n Pablo, opé tsajtsih ika intlajtol de Licaonia, iwa okijtoayah: —¡N diosmeh kemi tlakah yowaltemokeh tonawak! ");
INSERT INTO nplNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Iwa okijtoayah Bernabé okatka n dios Júpiter, iwa n Pablo n dios Mercurio, porke ye akin okachi otlajtoaya. ");
INSERT INTO nplNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Itiopa n dios Júpiter okatka inakastla n altepetl de Licaonia, iwa n tiópixki de Júpiter okualinwík torojteh iwa sikimeh koronajteh non okinmajmankeh ika xochitl. Iwa n tiópixki iwa n tlakah de Licaonia okinekiah kinmiktiskeh torojteh para Pablo iwa Bernabé para ika kinweyiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero ijkuak n Bernabé iwa Pablo okitakeh tlan okinekiah kinchiwiliskeh, omotlakentsotsomotskeh, omoxolkopinkeh iwa opanokeh intsalko nonteh tlakah tsajtsitiwih: ");
INSERT INTO nplNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Tlakah! ¿Tleka ijkó nonkichiwah? Tejwah noiwa titlakah de nin tlaltíkpaktli kemi nomejwah. Tejwah nika otiwalajkeh porke tiknekih tomechiliskeh xikkawakah nochi ni tlan amitla nomechpalewis, noiwa otiwalajkeh otomechilikoh xiktlakitakah n Totajtsi Dios non yolitok akin okichijchi n ilwikak, n tlaltíkpaktli, n weyi atl iwa nochi tlan itech onka. ");
INSERT INTO nplNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ya wejkawitl, Dios okinkawili nochteh n tlaltikpaktlakah makichiwakah san tlan yejwah okinekeh. ");
INSERT INTO nplNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero Ye nochipa okimititiaya Akin Cristo ika nochi tlan kuali okinchiwiliaya. Iwa Ye Akin techaltitlanilia n kiawitl iwa kichiwa kuali matlatlaki, noiwa techmaka tlan techpoloa para matikpiakah tlan tikkuaskeh iwa matiyetokah ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero maya nochi noni okimilijkeh, owi oweletkeh okintlakawaltijkeh n tlakah de Licaonia para amo makinmiktilikah torojteh non ika okinekiah kinweyiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ijkuakó okalakikoh sikimeh judíojteh de Antioquía iwa de Iconio. Okintlatlalwijkeh n tlakah de Licaonia, iwa okimojmotlakeh n Pablo ika tetl. Ijkuak yejwah okiyejyekolijkeh yomikki, okitlalxotontiajkeh iwa okikixtijkeh de non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero ijkuak n tokniwah non kineltokah Cristo Jesús okiyawalojkeh n Pablo, ye omóketski iwa oksepa okalak itech altepetl. Iwa ijkuak owalaneski oyá iwa Bernabé kan altepetl de Derbe. ");
INSERT INTO nplNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ijkuak yokitematiltijkeh n kualitlájtoli itech n altepetl de Derbe kan miakeh okineltokakeh n Cristo Jesús, omokopkeh Listra, Iconio iwa Antioquía. ");
INSERT INTO nplNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Iwa itech nekateh altepemeh okinyolchikajkeh akimeh okineltokayah n Cristo Jesús, iwa okimilijkeh makineltokakah nochipa. Noiwa okinmilijkeh tla kixikoskeh n tlaijyowílistli weletis kalakiskeh kan Dios tlanawatia. ");
INSERT INTO nplNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Noiwa okimpejpenkeh sikimeh tlayakankeh makinyakanakah n tokniwah kan moololoah. Ijkuak yomotiotsajtsilijkeh iwa omosaujkeh, okintlalijkeh imak n Toteko. ");
INSERT INTO nplNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Satepa opanokeh kan tlalmeh de Pisidia iwa okalakitoh Panfilia. ");
INSERT INTO nplNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Otetlapowijkeh itlajtol Dios kan altepetl de Perge, iwa satepa oyajkeh Atalía. ");
INSERT INTO nplNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ompa otlejkokeh itech se barko iwa oyajkeh Antioquía kan achto okintlalijkeh imak Dios para ika itlasojtlalis makimpalewi itech non tekitl non axa yotlankeh okichijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ijkuak okalakitoh Antioquía, okinmoololojkeh n tokniwah non kineltokah Cristo Jesús iwa okinmatiltijkeh nochi tlan okichijkeh ika iweletilis Dios, iwa kenijki n Toteko okinyolyamani n tlakah non amo judíojteh para yejwah noiwa makineltokakah n Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo iwa Bernabé omokajkeh ompa miakeh tonatijmeh inwah tokniwah non kineltokah Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Itech nekateh tonatijmeh, sikimeh tlakah non okiskeh de Judea iwa oyajkeh kan altepetl de Antioquía, opé kinmachtiah n tokniwah non amo judíojteh mamosirkunsidarokah kemi Moisés otlanawatijka, tla okinekiah momakixtiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo iwa Bernabé omokualanijtokah chikawak iwa nonteh tlakah. Yika Pablo, Bernabé iwan oksikimeh tokniwah, okimpejpenkeh mawiah Jerusalén mamoyektlapowitih de n sirkunsisión inwah n tlatematiltijkeh iwa n tlayakankeh de n tokniwah de Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","N tokniwah de Antioquía, non kineltokah Cristo Jesús, okintitlankeh mawiah Jerusalén Bernabé iwan Pablo. Ijkuak oyajkeh opanokeh kan ik tlalmeh de Fenicia iwa Samaria. Ompa kan ik oyayah, otetlapowiayah kenomi non amo judíojteh okikajkeh tlan achto okineltokayah iwa yopé kineltokah Dios. Nochteh n tokniwah opakiah ijkuak okikakiah tlan okinmiliayah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ijkuak Pablo iwa Bernabé okalakitoh Jerusalén, okinselijkeh non okineltokayah Cristo Jesús, noiwa n tlatematiltijkeh iwa n tlayakankeh. Iwa yejwah okintlapowijkeh nochi tlan Dios okichi inwah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero sikimeh fariseos non noiwa yokineltokakeh Cristo Jesús, omoketskeh iwa okijtojkeh: —N tlakah non amo judíojteh akimeh noiwa yokineltokakeh Cristo Jesús, moneki mosirkunsidaroskeh. Iwa moneki tikinnawatiskeh makichiwakah tlan kijtoa itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ijkuakó n tlatematiltijkeh iwa n tetajmeh non tlayakantokeh, omoololojkeh para motlapowiskeh tlan kichiwaskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ijkuak yomotlapowijkeh, Pedro owalmóketski iwa okinmili: —Nokniwah, nomejwah kuali nonkimatokeh yowejka Dios onechpéjpenki nomonawak, para manikinmatiltiti n kualitlájtoli akimeh amo judíojteh, iwa ijkó yejwah noiwa matlaneltokakah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Iwa Dios, Akin kimati nochi tlan tikmoliah itech toyolo, noiwa okinmák n Espíritu Santo akimeh amo judíojteh ijkó kemi tejwah achto otechmák. Ika noni otechititi de milajka kinselia. ");
INSERT INTO nplNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios amo otechseli san tejwah iwa yejwah amó, yej san ken tinochteh otechseli. Yika, ijkó kemi tejwah otechyolchipa Dios, noiwa yejwah okinyolchipa porke okineltokakeh Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Axa, ¿tleka amo nonkineltokah tlan Dios okichi? Iwa nonmochijchikawah nonkintoktiah akimeh yokineltokakeh n Cristo Jesús makichiwakah tlan nion tejwah, ¡nion totatawah otiweletkeh otikchijkeh! ");
INSERT INTO nplNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Okachi kuali, tejwah tikneltokah yotimomakixtijkeh porke Jesús miak otechtlasojtlak, noiwa yejwah kineltokah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ijkuakó nochteh san owalmokajkeh para kikakiskeh tlan Bernabé iwa Pablo okintlapowiayah kenijki Dios okinmák weletílistli para makinchiwakah milagros iwa wejweyi neskáyolteh inmixpah non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ijkuak yotlankeh otlajtojkeh, Jacobo okijto: —Nokniwah, techkakikah: ");
INSERT INTO nplNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro yotechtlapowi kenomi otlamochi ijkuak sikinika Dios opé kinnotsa akimeh amo judíojteh. Iwa intech okinmopejpeni sikimeh para mayetokah iaxkawah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tlan Pedro okijto, ijkó okiski tlan okijkuilojkeh n profetas, ijkó kemi kijtoa itech itlajkuilol Dios: ");
INSERT INTO nplNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Satepa de nochi ni, oksepa niwalmokopas iwa nikyekketsas itabernákulo n David non axa wetok; nikyektlalis tlan omoka, iwa oksepa nikajkokuis, ");
INSERT INTO nplNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","para nochteh n tlaltikpaktlakah makitemokah n Toteko: Nochteh yejwah akimeh yokinmatiltijkeh Notoka. ");
INSERT INTO nplNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ijkó kijtoa n Toteko, Akin ya wejkawitl okitematilti tlan axa mochijtok. ");
INSERT INTO nplNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","'Yika ne nikijtoa, amo matikinkuejsokah akimeh amo judíojteh iwa yokikajkeh tlan achto okineltokayah iwa axa ya kitlakitah Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","San matikintlajkuililikah ayakmó makikuakah itla tlan yokinmanilijkeh n diosmeh non kinmachijchiwah. Iwa nion se télpochtli noso íchpochtli mamomekatijtinemi. Ayakmó makikuakah nakatl de n yolkameh non san kintoskamalina, nion makikuakah n tlakuali ika inmesso. ");
INSERT INTO nplNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porke yowejka onkateh akimeh kitemachtiah itlanawatil Moisés, iwa nochi sábado kitemachtijtiwitseh itech nochteh sinagogajteh. ");
INSERT INTO nplNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ijkuakó n tlatematiltijkeh iwa n tetajmeh non kinyakantokeh tokniwah non kineltokah Cristo Jesús, okimpejpenkeh sikimeh inmikniwah para kintitlaniskeh mawiah iwan Pablo iwa Bernabé kan altepetl de Antioquía. Yejwah okipejpenkeh n Judas, akin noiwa itoka Barsabás, iwa Silas; ninteh tlakah okachi otlayakantokah innawak tokniwah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Okinmakakeh se amatlajkuíloli non ijkí okijtoaya: “Tejwah akimeh titlatematiltiah, iwa titetajmeh non tikinyakantokeh tokniwah non kineltokah Cristo Jesús, iwa oksikimeh tokniwah non moololoah towah: Tomechontlajpaloah nomejwah tokniwah non amo judíojteh iwa nochteh akimeh nonchantitokeh Antioquía iwa itech tlalmeh de Siria iwa Cilicia. ");
INSERT INTO nplNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Otikmatkeh sikimeh tlakah non san yejwah omonawatijkeh oyajkeh onomechkuatlapololtitoh ika intlajtolwah. Yejwah onomechilitoh nomejwah monekih nonmosirkunsidaroskeh iwa monekih nonkitlakitaskeh itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yika, yotimotlapowijkeh iwa yotimoyekkajkeh tikimpejpenaskeh sikimeh tokniwah non kineltokah Cristo Jesús. Tikintitlaniskeh manomechitatih sansikah iwa n tokniwah Bernabé iwa Pablo non tikintlasojtlah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yejwah yokitlalijkeh itech inyolo kitematiltiskeh Itoka n Toteko Cristo Jesús maya makinmiktikah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ika noni tomechtitlaniliah n Judas iwa Silas. Yejwah innewiah nomechyekiliskeh nochi tlan tomechtlajkuililijtokeh. ");
INSERT INTO nplNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Porke n Espíritu Santo iwa tejwah noiwa, yotikijtojkeh amitla ok se tomechnawatiskeh xikchiwakah; sanwel ni tlan milák moneki nonkichiwaskeh: ");
INSERT INTO nplNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Amo xikkuakah nakatl non yokinmanilijkeh n diosmeh non kinmachijchiwah. Amo xikkuakah estli nion nakatl de n yolkameh non san okintoskamalinkeh, iwa nion se télpochtli noso íchpochtli mamomekatikah ijkuak ayamó monamiktiah nion mamomekatijtinemikah. Tla nonkichiwaskeh tlan tomechnawatiah, kuali tlan nonkichiwah. Dios manomechtiochiwa.” ");
INSERT INTO nplNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ijkó kiné, oonewakeh akimeh okintitlankeh mawiah Antioquía, iwa san nima ijkuak okalakitoh ompa, okinmoololojkeh n tokniwah non kineltokah Cristo Jesús iwa okinmaktilijkeh nin amatlajkuíloli. ");
INSERT INTO nplNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ijkuak n tokniwah okiamapojkeh tlan okijtoaya n amatlajkuíloli, satlawel opakeh ika tlan okijtoaya non amatlajkuíloli. ");
INSERT INTO nplNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iwa kemi Judas iwa Silas noiwa okatkah profetas, okinyolsewijkeh iwa okinyolchikajkeh n tokniwah ika miak tlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yejwah omokajkeh kech tonati ompa. Iwa ijkuak ya onewaskiah, n tokniwah okinmakajkeh para mamokopakah innawak akimeh okintitlankah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero n Silas okimoli mokawas Antioquía. ");
INSERT INTO nplNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo iwa n Bernabé noiwa omokajkeh Antioquía. Yejwah iwa oksikimeh tokniwah otlamachtiayah iwa otetlapowiayah de itlajtol Toteko. ");
INSERT INTO nplNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kech tonati satepa, Pablo okili n Bernabé: —Oksepa matiwiah matikintlajpalotih n tokniwah non kateh itech nochteh n altepemeh kan yotitetlapowijkeh de itlajtol n Toteko Dios para matikinmitakah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","N Bernabé okinek kiwikas n Juan, akin noiwa omonotsaya Marcos, ");
INSERT INTO nplNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pero Pablo ayakmó okinek kiwikas, porke achto n Juan okinkakajtejka ijkuak okatkah Panfilia iwa amo okinek otekitik inwah. ");
INSERT INTO nplNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iwa kemi amo omoajsikamatkeh, omoxexelojkeh. Bernabé okiwík n Marcos, iwa otlejkok itech se barko iwa oyá Chipre, ");
INSERT INTO nplNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","pero Pablo okipéjpenki n Silas. Iwa keman n tokniwah yomotiotsajtsilijkeh para Dios makinwika ika itlasojtlalis, oonewakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Opanokeh ik tlalmeh de Siria iwa Cilicia. Iwa sentetl kan tokniwah non kineltokah Cristo Jesús omoololoayah, Pablo okinyolchikawaya. ");
INSERT INTO nplNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo iwa Silas okalakitoh kan altepetl de Derbe iwa de Listra, ompa okajsitoh se tokni non okineltokaya Cristo Jesús non itoka Timoteo, itelpoch se siwatl israelita non itoka Eunice non otlaneltokaya, pero ita n Timoteo okatka de Grecia. ");
INSERT INTO nplNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iwa n tokniwah non ochantitokah Listra iwa Iconio kuali otlajtoayah de Timoteo. ");
INSERT INTO nplNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo okinekia kiwikas n Timoteo, pero achto okitokti mamosirkunsidaro para amo makualanikah n judíojteh non ochantitokah itech nonteh tlalmeh, porke nochteh okimatiah ita n Timoteo griego. ");
INSERT INTO nplNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Iwa itech nochteh n altepemeh kan ik opanotiayah, okinmatiltiayah n tokniwah non kineltokah Cristo Jesús tlan n tlatematiltijkeh iwa n tetajmeh non kinyakantokeh n tokniwah akimeh moololoah Jerusalén okijtojkeh mamochiwa. ");
INSERT INTO nplNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iwa ijkó nochteh n tokniwah okachi okineltokayah Cristo Jesús, iwa ixmostla okachi omomiakiliayah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Kemi n Espíritu Santo amo okinkawili matetlapowikah de itlajtol Dios kan tlalmeh de Asia, yika san okimpanawijkeh n altepemeh non kateh itech tlalmeh de Frigia iwa Galacia. ");
INSERT INTO nplNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Iwa ijkuak okalakitoh kan motlalnamikih Misia iwa Bitinia, yejwah okinekiah kalakiskeh itech tlali de Bitinia, pero Iespíritu Jesús mach okinkawili. ");
INSERT INTO nplNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ijkó kiné, san opanotiajkeh ik inakastla n tlali de Misia, asta okalakitoh Troas. ");
INSERT INTO nplNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Non yúali ijkuak yokatkah kan tlali de Troas, Dios okitlapowi n Pablo itech itejtemikilis. Ye okitak iyakapa omoketsako se tlakatl de Macedonia non okitlatlaujtiaya: “Xiompano ik Macedonia iwa techompalewi.” ");
INSERT INTO nplNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ijkuak Pablo okitak non tejtemikílistli, san nima otimotlatlalijkeh para tiaskeh Macedonia, porke kuali otikmatiah Dios otechnotoka matiwiah matikinmatiltitih n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ompa kan altepetl de Troas otitlejkokeh itech se barko iwa otiksenmilajkeh kan ik kajki n isla de Samotracia, iwa ijkuak owaltláneski otikalakitoh Neápolis. ");
INSERT INTO nplNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Satepa otikiskeh de ompa iwa otiajkeh Filipos, se altepetl non okachi weyixtok itech tlalmeh de Macedonia non noiwa inmaxka n romanos. Tejwah ompa otimokajkeh kech tonati. ");
INSERT INTO nplNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Se sábado ijkuak mosewia n judíos, otikiskeh de non altepetl iwa otikalakitoh inakastla n aweyatl, kan nochipa onmotiotsajtsiliayah n judíojteh. Ompa otimotlajtlalijkeh iwa opé tikinmatiltiah itlajtol Dios n siwameh non ompa omoololojkah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Seme de yejwah itoka Lidia. Ye owalewatoka de Tiatira iwa okinamakaya tlakemitl non okachi kuali iwa chichiliktik. Nin siwatl non okiweyijkachiwaya Dios, okikaktoka tlan Pablo okijtoaya. Iwa Toteko okiyolyamani kuali makikaki nochi tlan Pablo okijtoaya. ");
INSERT INTO nplNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Otlanki, nin siwatl iwa nochi ifamilia omokuaatekijkeh. Satepa ye otechtlatlaujti iwa otechili: —Tla nomejwah nonkiyejyekoliah milák ya nikneltoka n Toteko, xiwikih nocha, ompa nomechkalotis. Iwa otechtoktih matimokawakah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Se tonati ijkuak yotiayah kan nochipa otimotiotsajtsiliayah, itech ojtli otiknamikeh se íchpochtli non okipiaya se espíritu non ika okimatia tlan se mochiwaskia. Iwa ika non tekitl non okichijtinemia non íchpochtli, n tekowajkeh okitlaniah miak tomi. ");
INSERT INTO nplNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nin íchpochtli opé yawi kan ik otiayah tejwah iwa Pablo. Chikawak otsajtsitinemia tokuitlapa, iwa okijtoaya: —¡Ninteh tlakah tekitih inawak Dios non okachi weyijkachitok, iwa nomechmatiltiah kenijki nonmomakixtiskeh! ");
INSERT INTO nplNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","N íchpochtli ijkó okichijtínenki miakeh tonatijmeh, pero se tonati n Pablo ayakmó okixiko, owalmókopki iwa okili n amokuali espíritu non okatka ijtik nin íchpochtli: —Ika Itoka n Toteko Cristo Jesús, nimitsnawatia, xikisa de itech. Iwa n amokuali espíritu san nima okikakajte. ");
INSERT INTO nplNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero ijkuak n tekowajkeh de n íchpochtli okitakeh ayakmó kitlaniskiah tomi iwan ye, okikitskijkeh n Pablo iwa Silas iwa okinwikakeh kan portal innawak tekiwajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Okinwikakeh innawak tekiwajkeh iwa okijtojkeh: —Ninteh judíojteh kimpajsolojtinemih nochteh n tlakah non nika chantitokeh. ");
INSERT INTO nplNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iwa tlamachtijtinemih ika ok se tlamachtílistli non tejwah mach tiknekih nion mach weletis tikinchiwaskeh, porke tejwah ti romanos. ");
INSERT INTO nplNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ijkuakó n tlakah de Filipos okualankeh iwa nochteh oonewakeh impah n tlatematiltijkeh. Iwa n tekiwajkeh otlanawatijkeh makintlakentsomonikah iwa makinwitekikah ika tlakotl. ");
INSERT INTO nplNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iwa ijkuak satlawel yokinwitekeh, okintsakuatoh, iwa okinawatijkeh n tetsak kuali makinmokuitlawi. ");
INSERT INTO nplNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iwa ijkuak n tetsak okikak tlan okinawatijkeh, okintsakuato kan okachi tlaijtik, iwa okintlalili inmikxiwah intsalko ome kuaujmeh kojkoyonkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pero ik tlajko yuak, Pablo iwan Silas omotiotsajtsilijtokah iwa okitlakuikilijtokah Dios, iwa n oksikimeh non ompa otsaktokah okinkaktokah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","San nima chikaktik owaltlalólinki asta okintsejtselo n temeh kan otlakxilitoka n telpiloya. Ijkuakó nochteh n kaltemeh owalmotlapojkeh iwa otojtonkeh inkadenajwah non ika oilpitokah n tlakah non ompa otsaktokah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","N tetsak oijsak, iwa ijkuak okimitak n kaltemeh tlajtlapotokeh, okikixti iespada iwa ya momiktiskia, porke okimoli yocholojkeh akimeh ompa otsaktokah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero n Pablo okitsajtsili: —Amo ximokojko, tinochteh nika tikateh. ");
INSERT INTO nplNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ijkuakó n tetsak okitlájtlanki se tláwili, okalaktiwetski bibiokati omotlankuáketsato ikxitla n Pablo iwan Silas. ");
INSERT INTO nplNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Otlanki okwalinkixti iwa okintlajtlani: —Tlakah, ¿tlan moneki nikchiwas para nimomakixtis? ");
INSERT INTO nplNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yejwah okinankilijkeh: —Xikneltoka n Toteko Cristo Jesús iwa mitsmakixtis te, iwa nochi mochantlakawah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iwa Pablo iwa Silas okitlapowijkeh de itlajtol n Totajtsi n tetsak iwa nochteh non inwah ochantitokah. ");
INSERT INTO nplNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Iwa san nima non yúali, n tetsak okimpakili kan okinxojxolejkeh, iwa ye iwa nochi ichantlakawah omokuaatekijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Satepa okinwík icha iwa okintlakualti, iwa ye iwa nochteh non ken kinmitah opaktokah porke okineltokakeh Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ijkuak owaltláneski, n tekiwajkeh okinnawatijkeh n soldadojteh makitatih n tetsak, para makinkajkawa n Pablo iwan Silas. ");
INSERT INTO nplNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ijkuakó n tetsak okili n Pablo: —N tekiwajkeh onechnawatijkeh manomechkajkawa, ya weletis nonyaskeh, xiwiah ika yolsewílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero Pablo okinmili n tlamokuitlawijkeh: —Tejwah tiromanos, otechwitekeh teixpa iwa amo achto otechtlatsintokijkeh, yej otechtsakeh; ¿Iwa axa kinekih techkajkawaskeh san ichtaka? ¡Amó! Mawikih yejwah innewiah matechkixtikih. ");
INSERT INTO nplNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","N soldadojteh okinmatiltitoh n tekiwajkeh. Iwa ninteh omaujkeh ijkuak okimatkeh Pablo iwan Silas noiwa romanos. ");
INSERT INTO nplNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","N tekiwajkeh omotlapojpolwitoh innawak, iwa san nima okinkixtijkeh de kan otsaktokah iwa okintlatlaujtijkeh mawiah de non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ijkuak Pablo iwa n Silas yokiskeh de kan otsaktokah, oyajkeh icha n Lidia. Ijkuak okimitakeh inmikniwah non kineltokah Cristo Jesús okinyolchikajkeh, iwa satepa oyajkeh de ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo iwa Silas opanokeh ik Anfípolis iwa Apolonia, iwa okalakitoh Tesalónica, kan okipiayah se insinagoga n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo, ijkó kemi nochipa okichiwaya, oyá kan sinagoga iwa okintlalnamiktiaya itech nonteh eyi sábado. ");
INSERT INTO nplNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Iwa okinmajsikamatiltiaya Cristo tlaijyowiskia, iwa satepa de mikiskia, moyolitiskia oksepa kemi nestok itech itlajkuilol Dios. Iwa okimiliaya: —Nin Jesús de akin ne nomechtlapowia, Ye n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ijkuakó sikimeh judíojteh okineltokakeh n Cristo Jesús, iwa omoseitilijkeh iwan Pablo iwa n Silas. Noiwa okineltokakeh sikimeh griegojteh non okiweyijkachiwayah Dios. Miakeh siwameh non okachi okintlakitayah itech non altepetl noiwa otlaneltokakeh inawak Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero sikimeh judíojteh non amo okineltokayah itlajtol Dios, oxikojmikeh iwa okintlatlalwijkeh sikimeh tlakah tlajtlakolchijkeh non san okitokatinemiah ojtli para makimpajsolokah n tlakah de non altepetl. Satepa okalakitoh icha n Jasón, okintemojtinemiah n Pablo iwa n Silas, para kinkixtiskeh iwa kintemakaskeh inmak n tlakah de non altepetl. ");
INSERT INTO nplNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero kemi amo okinmajsikeh ompa, okiwikakeh tlaxotonti n Jasón sansikah iwa n oksikimeh tokniwah non kineltokah Cristo Jesús, iwa okimixpantitoh innawak tekiwajkeh, iwa chikaktik otsajtsikeh: —¡Ninteh tlakah, akimeh tekuatlapololtijtinemih itech nochi n tlaltíkpaktli, noiwa yowalajkeh nika! ");
INSERT INTO nplNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iwa Jasón okinkaloti icha. Nochteh yejwah mach kitlakitah itlanawatil n torey César de Roma, porke kijtoah onka ok se rey non yejwah kiliah Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ijkuak nochteh n tlakah iwa n tekiwajkeh de non altepetl okikakeh tlan okijtojkeh nonteh tlakah, okachi omopajsolojkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pero Jasón iwa non oksikimeh tokniwah okitlaxtlajkeh tlan okintlajtlanilijkeh n tekiwajkeh, iwa okinkajkajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Niman non tonati ijkuak otleyuak, n tokniwah non kineltokah Cristo Jesús okintitlankeh n Pablo iwa Silas mawiah kan altepetl de Berea. Iwa san nima ijkuak okalakitoh, oyajkeh kan insinagoga n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ninteh judíojteh okatkah okachi yolyamankeh ke non ochantitokah Tesalónica. Ika miak pakílistli okiselijkeh itlajtol Totajtsi Dios. Ixmostla okiamapoaya itlajkuilol Dios para kitaskeh kox milák tlan Pablo iwa n Silas okimiliayah. ");
INSERT INTO nplNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ijkó miakeh judíojteh okineltokakeh Cristo Jesús, iwa miakeh siwameh iwa tlakah griegos non okachi okintlakitayah itech non altepetl noiwa okineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero ijkuak n judíojteh non ochantitokah Tesalónica okimatkeh Pablo noiwa yotetlapowijtoka de itlajtol Dios kan altepetl de Berea, oyajkeh okimpajsolotoh n tlakah non ompa ochantitokah. ");
INSERT INTO nplNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pero n tokniwah okilitoh n Pablo mawia de ompa iwa makonana n ojtli non onkisa itempa n weyi atl. Pero n Silas iwa Timoteo ok omokajkeh ompa kan altepetl de Berea. ");
INSERT INTO nplNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Akimeh oyajkeh iwa n Pablo, okiwikakeh asta Atenas. Satepa owalmokopkeh de ompa iwa okimilijkeh n Silas iwa n Timoteo, Pablo okinmili san nima mawiah makajsitih ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ijkuak Pablo okichixtoka n Silas iwa n Timoteo kan altepetl de Atenas, saikpanoa omoyolkoko porke okitak itech non altepetl sentetl omokejketokah diostsitsinteh non san kinmachijchiwah. ");
INSERT INTO nplNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iwa ijkó, itech n sinagoga omotlapowiaya iwan judíojteh iwan griegos non okiweyijkachiwayah Dios. Iwa nochi tónati itech tiánkistli okintlapowiaya akimeh ompa omoololoayah. ");
INSERT INTO nplNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sikimeh tlakah ixtlamatkeh non okintokayotiayah epicúreos, iwa n oksikimeh ixtlamatkeh non okintokayotiayah estoicos, opé motlatlajtolkopah iwan Pablo. Sikimeh okimoliayah: —¿Tlan kineki techilis nin tekajkaya? Iwa oksikimeh okijtoayah: —Mati tetlapowijtinemi de oksikimeh diosmeh. Ijkó okimoliayah porke Pablo okinmatiltiaya n kualitlájtoli de Jesús iwa de kenijki oksepa omoyoliti. ");
INSERT INTO nplNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ijkuakó okikitskijkeh iwa okiwikakeh kan lojar non itoka Areópago, kan nochipa omoololoayah, iwa okitlajtlanijkeh: —¿Weletis techyekilis tlan kijtosneki nin yankuik tlamachtílistli non te tikualika? ");
INSERT INTO nplNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tiktematiltia tlan ayik tikkaktikateh. Yika, tiknekih tikmatiskeh tlan kijtosneki nochi noni. ");
INSERT INTO nplNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Yejwah okinekiah kimatiskeh tlan kijtosneki porke nochteh n tlakah de Atenas, iwa akimeh san owalajkeh ochanchiwakoh ompa, mach itla ok se okichiwayah, sanwel okiwilitayah kikakiskeh noso kijtojtinemiskeh itla yankuik tlájtoli. ");
INSERT INTO nplNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ijkuakó Pablo, omoketsato tlatlajkotia kan Areópago, iwa okijto: —Tlakah de Atenas, ne nikita nomejwah nonkinmopantiah nomodiostsitsiwah. ");
INSERT INTO nplNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Porke ijkuak onitlajtlachixtinemia kan nomejwah nonkinweyiliah nomodioswah, onikajsik se artal kan ijkuilitok: “Para n Dios non amo tikixmatih”. Neká akin nomejwah nonkimopantiah maya amo nonkixmatih, Ye n Dios de akin ne nomechtlapowia. ");
INSERT INTO nplNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","'N Dios Akin okichijchi n tlaltíkpaktli iwa nochi tlan itech onka, Ye iaxka n ilwikak iwa n tlaltíkpaktli. Ye amo chanti itech tiopameh non kinmachijchiwah n tlakah, ");
INSERT INTO nplNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nion onka itla tlan weletis kimakaskeh n tlakah, porke Ye amitla kipoloa, Ye Akin kichiwa matiyolitokah, iwa techmaka toijyotilis, iwa nochi tlan onka wits de Ye. ");
INSERT INTO nplNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","'San itech se, Dios okinchijchi nochteh n tlakah para mamochajchantikah ipan nochi n tlaltíkpaktli. Iwa Ye okitlali kech xiwitl yolitoskeh iwa kan kipiah mochantiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dios ijkó okichi, para n tlaltikpaktlakah makitemokah iwa maya san makimatemokah, makajsikah. Maya milák se makijto, Dios amo wejka kajki de tejwah tinochteh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porke itech Dios tikateh, timoliniah iwa tiyolitokeh. Asta sikimeh tlajkuiloanih okijtojkeh: “Tejwah titepilwah de Dios.” ");
INSERT INTO nplNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yika, tla tejwah titepilwah de Dios, amo matikmolikah Dios kemi se tlamachijchiwali non tlakah kichijchiwah de oro, plata, noso tetl kemi yejwah kiyejyekoliah tlachixtok. ");
INSERT INTO nplNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ya wejkawitl, Dios okintlapojpolwi ika tlan okichijtinemiah n tlaltikpaktlakah, porke amo okimatiah tlan amo kuali okichiwayah. Pero axa itech ninteh tonatijmeh, Dios kinnawatia nochteh n tlaltikpaktlakah makikawakah nochi tlan amokuali kilnamiktinemih iwa kichijtinemih iwa san Ye makitlakitakah. ");
INSERT INTO nplNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porke Dios yokitlali se tonati ijkuak tlaixkomakas. Ye kichiwas porke Ye yolmilajka iwa kitlalis n Cristo Jesús makichiwa nin tekitl, akin Ye yowejka okipéjpenki. Iwa tinochteh otikmatkeh Dios yokipéjpenki n Jesús ijkuak okiyoliti. ");
INSERT INTO nplNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pero ijkuak okikakeh non yomikkeh moyolitiskeh, sikimeh san okiwetskakeh iwa oksikimeh okijtoayah: —Ok se tonati timitskakiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ijkuakó Pablo okinkakajte. ");
INSERT INTO nplNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero sikimeh tlakah okineltokakeh itlajtol Dios iwa oyajkeh iwan Pablo. Seme de yejwah itoka Dionisio, akin noiwa okatka tlayákanki kan Areópago, noiwa se siwatl non itoka Dámaris, iwa miakeh oksikimeh. ");
INSERT INTO nplNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Satepa, Pablo okiski de Atenas iwa oyá kan altepetl de Corinto. ");
INSERT INTO nplNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ompa okajsito se israelita non itoka Aquila, non owalewatoka de Ponto. Ijkuakó ayamó okachi owejkawaya, n Aquila iwa isiwa Priscila owalajkeh de Italia porke n rey Claudio otlanawati makisakah de Roma nochteh n judíojteh. Ijkuakó n Pablo oyá okintlajpaloto. ");
INSERT INTO nplNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Iwa kemi Pablo noiwa oweletia okinchijchiwaya manteadojkalmeh kemi yejwah, omoka inwah iwa otekitiah sansikah. ");
INSERT INTO nplNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Iwa nochi sábado ijkuak mosewia n judíos Pablo okintlapowiayah itech sinagoga, iwa miakeh judíojteh iwa griegos okineltokayah itlajtol Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ijkuak Silas iwa Timoteo okalakikoh de Macedonia, Pablo okachi okimosenmák iteki; otetlapowiaya de n kualitlájtoli de Dios iwa okimiliaya Jesús Ye n Cristo akin okichixtokah. ");
INSERT INTO nplNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero n judíojteh okualankeh iwa opé kiwijwikaltiah, ijkuakó n Pablo inmixpa okitsejtselo itlake para makitakah noiwa okualanki iwa okinmili: —Amo notlajtlakol tla amo nonmomakixtiah; ne ayakmó nikpia tlan nikitas. Okachi kuali manomechkawa iwa manio manikinmatiltiti itlajtol Dios non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Okiski de kan sinagoga iwa oyá icha n se tlakatl non itoka Justo, ye okiweyijkachiwaya Dios. Nin tlakatl ochantitoka inakastla n sinagoga. ");
INSERT INTO nplNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Iwa Crispo, se tlayákanki itech sinagoga, okineltokak n Toteko sansikah iwa nochteh ichantlakawah. Noiwa miakeh tlakah de Corinto, ijkuak okikakeh itlajtol Dios, okineltokakeh iwa omokuaatekijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ijkuakó, se yúali n Toteko okili n Pablo itech itejtemikilis: —Amo ximawi, xiktematilti notlajtol iwa ayik ximosotlawa. ");
INSERT INTO nplNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Porke Ne nika mowa iwa amaka weletis itla mitstoktis, porke nikimpia miakeh akimeh nechneltokah itech nin altepetl. ");
INSERT INTO nplNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yika Pablo omoka Corinto, iwa ompa okitematilti itlajtol Dios se xiwitl iwa n tlajko. ");
INSERT INTO nplNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pero itech n tonatijmeh ijkuak Galión gobernador kan tlalmeh de Acaya, n judíojteh omotlatlalwijkeh iwa oonewakeh ipan Pablo. Okiwikakeh inawak tekiwa, ");
INSERT INTO nplNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","iwa okilijkeh n gobernador: —Nin tlakatl kintlatlalwijtinemi nochteh n tlakah makiweyijkachiwakah Dios, pero amo kemi totlanawatilis kijtoa. ");
INSERT INTO nplNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo ya tlajtoskia, ijkuak Galión okinmili n judíojteh: —Techkakikah judíojteh, tla nin tlakatl kichiwaskia itla tlan amokuali noso tla temiktiskia, nika nika para nomechkakis. ");
INSERT INTO nplNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero san tekil nonkipoah tlan nin tlakatl kitemachtia, ika tlájtolteh de tlakah iwa de nomotlanawatilwah, ompa nomejwah xikitakah. Ne amo nikneki niyetos niteyolsewi itech nomotlanawatilwah. ");
INSERT INTO nplNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iwa okwalinkixti de kan jusgado. ");
INSERT INTO nplNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ijkuakó nochteh n griegos okimokitskilijkeh n Sóstenes, tlanawati itech sinagoga, iwa okiwitekeh ompa ixpa n tlanawati Galión. Pero Galión omochi kemi amo okitak. ");
INSERT INTO nplNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo ok omoka Corinto miakeh tonatijmeh. Satepa omomaaka innawak tokniwah non kineltokah Cristo Jesús, iwa oyá kan tlali de Siria sansikah iwan Priscila iwa n Aquila. Ijkuak ya onewaskia de Cencreas, omokúaxinki porke yokitemakaka itlajtol inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ijkuak okalakitoh kan altepetl de Éfeso, Pablo okinkajteh n Priscila iwa Aquila, iwa oyá kan sinagoga, omotlapowito iwan judíojteh non ompa omoololoayah. ");
INSERT INTO nplNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yejwah okitlatlautijkeh n Pablo mamokawa ok kech tonati inwah, pero mach okinek. ");
INSERT INTO nplNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ijkuakó omomaaka inwah iwa okinmili: —Tla Dios kimonekiltia, oksepa niwits nomechontlajpaloki. Iwa oyá de Éfeso itech barko. ");
INSERT INTO nplNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ijkuak okalakito kan altepetl de Cesarea, Pablo otlejkok Jerusalén okintlajpaloto n tokniwah non ompa omoololoayah, iwa satepa oksepa owaltemok kan altepetl de Antioquía. ");
INSERT INTO nplNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Satepa ijkuak yowejka ompa okatka, oksepa okiski iwa opapanotia itech n altepemeh de Galacia iwa Frigia. Iwa okinyolchikajtiaya nochteh n tokniwah. ");
INSERT INTO nplNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Itech nekateh tonatijmeh se israelita non itoka Apolos, non owalaya de se altepetl non itoka Alejandría, oajsiko kan altepetl de Éfeso. Ye okimatia otenonotsaya iwa kuali okixmatia itlajkuilol Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ye kuali okimachtijkeh itlamachtilis Toteko, iwa ijkuak otenonotsaya, kualtsi otetlapowiaya. Okitemachtiaya de Jesús ika miak chikawálistli, maya ye sanwel okixmatia n tlakuaatekílistli non Juan okitemachti. ");
INSERT INTO nplNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos opé tetlapowia ika miak yolchikawálistli. Pero ijkuak n Priscila iwa Aquila okikakeh, okinotskeh iwa okiyekajsikamatiltijkeh itlamachtilis Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Satepa ijkuak Apolos okijto yas kan tlali de Acaya, n tokniwah okiyolchikajkeh mawia ompa, iwa okintitlanilijkeh se amatlajkuíloli n tokniwah non kineltokah Cristo Jesús non okatkah de Acaya para kuali makiselikah n Apolos. Ijkuak okalakito Acaya, okimpalewi miak akimeh Dios ika itlasojtlalis okichi matlaneltokakah itech Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos omonanankiliaya iwan judíojteh non amo okineltokaya Jesús, iwa ika itemachtilis n tiotlajkuíloli okinnextiliaya Jesús okatka n temakixti. ");
INSERT INTO nplNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ijkuak Apolos ok okatka Corinto, Pablo okintlajpalojtiah kan ik altepemeh non kateh okachi tlakpak, asta okalakito kan altepetl de Éfeso. Ompa okinmajsito sikimeh tokniwah non kineltokah Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Iwa okintlajtlani: —¿Ononkiselijkeh n Espíritu Santo ijkuak ononkineltokakeh Cristo Jesús? Yejwah okinankilijkeh: —Ayik tikkaki kox onka Espíritu Santo. ");
INSERT INTO nplNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ijkuakó n Pablo okintlajtlani: —¿Tlan tlakuaatekílistli ononkiselijkeh? Yejwah okinankilijkeh: —N tlakuaatekílistli non Juan okitemachti. ");
INSERT INTO nplNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo okinmili: —Milák, Juan okinmiliaya n tlakah mamokuaatekikah iwa makiteititikah yejwah de milajka okinekiah kikawaskeh tlan amo kuali okichijtinemiah, pero okimiliaya omonekiah kineltokaskeh akin walaskia satepa de ye, kijtosneki makineltokakah n Cristo. ");
INSERT INTO nplNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ijkuak okikakeh tlan Pablo okinmili, omokuaatekijkeh itech Itoka n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Iwa ijkuak Pablo okintlali imawah impah, n Espíritu Santo owala intech iwa opé tlajtoah ika oksikimeh tlájtolteh iwa okitematiltijkeh tlan Dios okimiliaya tlamochiwaskia. ");
INSERT INTO nplNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Yejwah okatkah kemi májtlaktli iwa n ome tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Eyi mestli Pablo oyaya kan se sinagoga. Ye ompa okitematiltiaya itlajtol Dios ika miak yolchikawálistli. Okinnonotsaya n judíojteh noiwa makalakikah kan Dios tlanawatijtok. ");
INSERT INTO nplNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero sikimeh oyoltlakuawakeh iwa mach okineltokakeh itlajtol Dios, yej teixpa otlajtoayah fiero de n kualitlájtoli. Ijkuakó Pablo omoxelo de yejwah, iwa okinwík n tokniwah kan se kali kan momachtilo de se tlakatl non itoka Tirano, iwa ixmostla ompa omotlapowiayah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ome xiwitl otetlapowi de itlajtol Dios, iwa ijkó nochteh non ochantitokah itech tlalmeh de Asia, n judíojteh iwa non amo judíojteh okikakeh itlajtol n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Iwa Pablo okinchiwaya wejweyih milagros ika iweletilis Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Iwa asta sikimeh pañitojteh noso tsótsolteh non Pablo okintelkojka, okinwikiliayah inkokoxwah, iwa ijkuak okintlaliliayah impah, n kokoxkeh opajtiah iwa n espíritus amokualteh okisayah de intech. ");
INSERT INTO nplNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pero sikimeh judíojteh non okinkixtiayah espíritus amokualteh, noiwa okinekiah kinkixtiskeh n espíritus amokualteh ika Itoka n Toteko Jesús, iwa ijkí okimilijkeh n espíritus amokualteh: —¡Ika Itoka n Jesús non Pablo kitematiltia tomechnawatiah, xikisakah! ");
INSERT INTO nplNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ijkó okichiwayah chikome itelpochwah se tlakatl non itoka Esceva, akin okatka se tiópixki israelita non okachi otlayakantoka. ");
INSERT INTO nplNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero ijkuak ijkó okichijkeh, n espíritu amokuali okinnankili: —Nikixmati n Jesús, iwa nikmati akin Pablo; ¿pero akimeh nomejwah? ");
INSERT INTO nplNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Iwa san nima ijkuak ijkó okinmili, n tlakatl non okipixtoka n espíritu amokuali omokajka impah, iwa kemi non amokuali espíritu okatka satlawel chikaktik, nochteh okinwitek iwa sa okicholilijkeh de non kali xipetstikeh iwa sa ejestikeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nochteh non ochantitokah Éfeso, judíojteh iwa amo judíojteh, okimatkeh iwa satlawel omomojtijkeh, iwa okiyektenewayah Itoka n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Noiwa miakeh non okineltokakeh Cristo Jesús owalayah iwa okimokuitiayah tlan amokuali okichiwayah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Noiwa miakeh non otetlajchiwiayah, okwalinwikakeh intlajkuilolwah non intech omomachtiayah para tetlajchiwiskeh iwa teixpa okinchichinojkeh. Iwa ijkuak okiyejyekolijkeh kech impati nonteh tlajkuílolteh, okijtojkeh ome póali iwa n májtlaktli mil (50,000) platajtomi. ");
INSERT INTO nplNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ijkó itlajtol Totajtsi okachi omoxitiniaya iwa okitenextiaya iweletilis. ");
INSERT INTO nplNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Satepa ijkuak nochi ni yopanok, Pablo okitlali itech iyolo yas para Macedonia iwa Acaya iwa asta kalakiti Jerusalén. Noiwa okimoliaya yaskia Roma. ");
INSERT INTO nplNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ijkuakó Pablo okintítlanki ome itlakawah mawiah Macedonia, Timoteo iwa Erasto, porke ye ok mokawaskia kech tonati itech tlalmeh de Asia. ");
INSERT INTO nplNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Itech nekateh tonatijmeh opé mokuakualaniah n tlakah por n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Otlapewalti se tlakatl non itoka Demetrio, non okinmachijchiwaya ika plata tiopantsitsinteh de se diosa non itoka Diana, iwa akimeh otekitiah para Demetrio kuájkuali tomi okitlaniah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio okinmoololo itlakawah iwa oksikimeh tlakah non noiwa okitekitiah n plata, iwa okinmili: —Tlakah, nomejwah kuali nonkimatokeh kuali tiktlanih ika nin tekitl non tejwah tikchiwah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pero ijkó kemi nomejwah nonkitah iwa nonkikakih, nin tlakatl non itoka Pablo kijtojtinemi n diostsitsinteh non san kinmachijchiwah n tlakah, amo milák diosmeh. Iwa miakeh tlakah yokineltokakeh tlan kimilia, iwa amo san non de nika Éfeso, yej noiwa itech nochteh altepemeh non kateh kan tlalmeh de Asia. ");
INSERT INTO nplNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Semi amokuali tlan kichijtinemi, porke weletis tikpoloskeh toteki iwa itiopa n todiosa Diana ayakmó ok kitlakitaskeh. Iwa nin diosa non nochteh n tlakah de Asia iwa de nochi n tlaltíkpaktli kiweyiliah, kipolos iweyilis iwa mach ok kiweyiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ijkuak okikakeh nin tlájtoli, okualankamikeh iwa opé tsajtsih: —¡Matikweyilikah n Diana, todiosa de Éfeso! ");
INSERT INTO nplNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ijkó, n tlakah de non altepetl okualankamikeh. Okikitskijkeh n Gayo iwa Aristarco, ome tlakah de Macedonia non oyayah iwan Pablo, okintlalxotontiajkeh asta kan kali kan yejwah omoololoayah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo okinekia kalakis ompa para kintlapowis n tlakah, pero n tokniwah non kineltokah Cristo Jesús mach okikawilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Noiwa sikimeh tekiwajkeh de Asia non inwah omowikaya n Pablo, otlatitlankeh makilitih n Pablo amo makalaki ompa kan oololitokeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pero ompa kan oololitokah, san de miak okijtoayah, iwa miakeh nion amo okimatiah tleka ompa okatkah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pero sikimeh judíojteh okwalkixtijkeh n Alejandro iwa okiketsatoh tlayakapa. Alejandro okíketski ima para ayakmó matsajtsikah, iwa ijkó weletis motlajtolpalewis inawak nonteh tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero ijkuak n tlakah okimatkeh Alejandro okatka israelita, nochteh otsajtsikeh iwa ijkó otsajtsitokah kemi ome ora: —¡Maweyixto n Diana, todiosa de Éfeso! ");
INSERT INTO nplNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ijkuak n tekiwa non kinmijkuiloa amameh itech non altepetl owéletki okintlakawalti n tlakah de Éfeso, okinmili: —Tlakah de Éfeso, nochteh kimatokeh tejwah tikmokuitlawiah itiopa n Diana noiwa tikmokuitlawiah itlamachijchiwal Diana non owetsiko de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iwa kemi amo onka se akin weletis kijtos amo milák, ayakmó okachi xikualanikah iwa amitla xikchiwakah tla amo nonkimatih tlan nonkichiwah. ");
INSERT INTO nplNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Porke ninteh tlakah non nomejwah ononkualinwikakeh, amitla fiero okitenejkeh de todiosa nion itla okichtekilijkeh kan itiopa. ");
INSERT INTO nplNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tla Demetrio iwa itlakawah kinekih kiteiliskeh aka, yika onkateh tekiwajkeh kan moteiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Iwa tla owijtitok tlan nomejwah nonkitlajtlanih, nonkipiah de nonyaskeh nonmoyektlalitiweh innawak tekiwajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Porke tla amó, ika tlan axa opanok weletis techteiliskeh iwa kijtoskeh tikimpajsolojtinemih n tlakah; iwa amitla tikpiah tlan ika weletis timotlajtolpalewiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Satepa, ijkuak yotlanki okintlapowi, okinmili mawiah nochteh non ompa omoololojkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ijkuak nochteh n tlakah omoyolsewijkeh, Pablo okínnotski n tokniwah non kineltokah Cristo Jesús. Okinyolchika iwa satepa omomaaka inwah iwa oyá Macedonia. ");
INSERT INTO nplNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pablo okintlajpalojtia nochteh n tokniwah non ochantitokah itech nekateh tlalmeh, iwa ika miak tlájtoli okinyolchikajtiaya asta okalakito Grecia. ");
INSERT INTO nplNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ompa omoka eyi mestli, iwa sa okichixtoka tonati para tlejkos itech barko iwa kalakiti kan tlali de Siria, keman okima n judíojteh okinekiah kimiktiskeh, okisentlali oksepa panos ik Macedonia. ");
INSERT INTO nplNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pablo oyaya iwan Sópater de Berea, Aristarco iwa n Segundo non owalewatokah de Tesalónica, Gayo iwa n Timoteo de Derbe, Tíquico iwa n Trófimo non owalewatokah de Asia. ");
INSERT INTO nplNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ninteh tokniwah otlayakankeh iwa otechchiatoh kan altepetl de Troas. ");
INSERT INTO nplNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pero tejwah otikiskeh de Filipos satepa de opanok n ilwitl de Paskua ijkuak mokua n paj non amo kipia levadura, iwa otiajkeh itech barko iwa ipan mákuili tonati otikinmajsitoh Troas. Ompa otimokajkeh chikome tonati. ");
INSERT INTO nplNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","N domingo otimoololojkeh para tiksepankuaskeh n paj, iwa Pablo okinmachtijtoka n tokniwah non kineltokah Cristo Jesús. Iwa kemi Pablo onewaskia ijkuak tlanesiskia, yika okinmachti asta tlajko yuak. ");
INSERT INTO nplNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pablo otechmachtijtoka itech se kuarto non okatka tlakpak. Non kuarto okimpiaya miakeh tláwilteh. ");
INSERT INTO nplNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Se télpochtli non itoka Eutico oewatoka kan bentana. Iwa kemi Pablo owejka otemachtijtoka, n télpochtli okochtlamila iwa owalwetsiko desde ipan eyi piso, iwa ijkuak okajkokuitoh yomikki. ");
INSERT INTO nplNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ijkuakó n Pablo otemok, omoixtlapacho ipan télpochtli okinawajtek iwa okinmili n tokniwah: —Amo ximomojtikah, ye yolitok. ");
INSERT INTO nplNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Otlanki n Pablo oksepa otlejkok kan kuarto, okitlajkotlápanki n paj, iwa okisepankuajkeh iwa oksepa okintlapowi asta otláneski. Iwa satepa oyá. ");
INSERT INTO nplNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","N télpochtli okiwikakeh yolitok, iwa nochteh okachi omoyolchikajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tejwah otitlayakankeh itech barko iwa otikalakitoh kan altepetl de Asón, ompa otiknotikiskeh n Pablo, ijkó kemi otimokajkeh íwa, porke ye okinek nejnemis. ");
INSERT INTO nplNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ijkuak otimajsito iwan Pablo kan altepetl de Asón, otlejkok towah itech barko iwa sansikah otiajkeh para Mitilene. ");
INSERT INTO nplNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Otikiskeh de ompa, iwa ijkuak owalmostlatik otipanokeh inakastla n isla de Quío, iwa itech ok se tonati otikalakitoh kan altepetl de Samos, kan onkalakiah n barkojteh. Otimosewijkeh itech altepetl non itoka Trogilio, iwa ijkuak owalmostlatik otikalakitoh Mileto. ");
INSERT INTO nplNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ijkó otikchijkeh, porke Pablo amo okinek panos ik Éfeso, para amo mokawas miakeh tonatijmeh kan tlalmeh de Asia, porke ye okinekia san nima onajsiskia Jerusalén, para ompa yetos itech tonati de pentecostés. ");
INSERT INTO nplNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ijkuak Pablo yokatka kan altepetl de Mileto, otlatítlanki makinnotsatih n tokniwah de Éfeso non tlayakantokeh non kineltokah Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ijkuak owalajkeh okinmili: —Nomejwah kuali nonkimatokeh kenijki nimoyekwika nomowah desde neká tonati ijkuak onikalakiko nika Asia. ");
INSERT INTO nplNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ne miak yonitekitik inawak Toteko Jesús, iwa itech nochi oniktlakitak. Miak welta onichokak iwa miak onitlaijyowi por tlan onechtoktijkeh n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Amayik onimosotla nomechmatiltis tlan nomechpalewis para nonyeknemiskeh. Iwa teixpa onomechmachti iwa itech nomocha. ");
INSERT INTO nplNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ne nochteh onikinnonotski, n judíojteh iwa non amo judíojteh, nochteh onikinmili ayakmó makichiwakah tlan amo kuali iwa manemikah kemi Dios kimonekiltia iwa makineltokakah Toteko Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iwa axa n Espíritu nechwika Jerusalén, iwa mach nikmati tlan nechchia ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sanwel nikmatok itech nochteh n altepemeh kan ik nio, n Espíritu Santo nechilia sa nechchixtok telpiloya kan nechtsakuaskeh iwa miak tlaijyowílistli nechchiah. ");
INSERT INTO nplNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pero amitla ok se nechtekipachoa, nion manimikki. Ne sanwel niknekiskia nikchiwas nochi tlan Toteko Cristo Jesús onechnawati manikchiwa. Kijtosneki manitetlapowi de n kualitlájtoli non techmatiltia kenijki Dios satlawel techtlasojtla. ");
INSERT INTO nplNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","'Iwa axa kuali nikmatok nion seme de nomejwah, akimeh onomechmatilti tlan Dios kimonekiltia, oksepa nechitas. ");
INSERT INTO nplNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yika nikneki axa nomechilis nik amo notlajtlakol tla aka amo momakixtis. ");
INSERT INTO nplNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Porke ne onomechmatilti nochi tlan Dios kimonekiltia, iwa amitla onomechtlaatili. ");
INSERT INTO nplNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Yika, ximotlachilikah nomejwah iwa xikinyekwikakah nomokniwah non kineltokah Cristo Jesús, porke n Espíritu Santo onomechtlali kemi nontlajpixkeh para xikinyakanakah akimeh kineltokah n Toteko Jesús, non Ye okinko ika iesso. ");
INSERT INTO nplNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Porke kuali nikmatok ijkuak ne nias, witseh sikimeh tlakah xolópijteh kintlajtlamiskeh n tokniwah porke yejwah mokopah kemi kokoyomeh tekuanimeh non kintlajtlamiah n ichkameh. ");
INSERT INTO nplNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Iwa itech nomejwah kisaskeh akimeh kitemachtiskeh tlan amo milák, para kinyakanaskeh akimeh kineltoka Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ijkó kiné, ximotlachilikah, iwa kuali xikilnamikikah itech eyi xiwitl onomechnonotsaya, tlajka iwa n yuak, iwa maya onichokaya ayik onimosotla. ");
INSERT INTO nplNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","'Axa nokniwah, nomechkawa imak Dios iwa imak itlatiochiwaltlajtol non kipia weletílistli para nomechyolchikawas iwa nomechmakas se lojar iwa akimeh omotemakakeh inawak. ");
INSERT INTO nplNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Amaka onikelewili itomi nion itlake, ");
INSERT INTO nplNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","yej kuali nonkimatokeh onitekitik ika ninteh nomawah para nikmotlanilis tlan ika nipanotos, ne iwa akimeh okatkah nowa. ");
INSERT INTO nplNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nochipa onomechititi kenijki moneki nontekitiskeh para nonkimpalewiskeh akimeh amitla kipiah, iwa xikilnamiktokah tlan okijto n Toteko Jesús: “Okachi makipia pakílistli n tlakatl non tlapalewia ika tlan kipia, iwa amo akin kipalewiah.” ");
INSERT INTO nplNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ijkuak ijkó okijto n Pablo, omotlankuáketski iwa omotiotsajtsili iwan nochteh tokniwah de Éfeso. ");
INSERT INTO nplNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nochteh ochokakeh, okinawajtekeh iwa okitennamikeh n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Iwa saikpanoa omoyolkokojkeh porke n Pablo okinmili ayakmó kitaskiah. Satepa okimakawatoh kan barko. ");
INSERT INTO nplNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ijkuak otikinkajtejkeh, otitlejkokeh itech se barko iwa milaktik otiajkeh kan isla de Cos. Ijkuak owalmostlatik otiajkeh kan isla de Rodas, iwa de ompa otikalakitoh kan altepetl de Pátara. ");
INSERT INTO nplNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ompa itech non altepetl otikajsikeh se barko non oyaya para Fenicia, otitlejkokeh itech barko iwa otiajkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ijkuak onejnentoka n barko, otiktakeh n isla de Chipre non otikpanawijkeh ik toopochma iwa otikonmilajkeh para Siria asta otikalakitoh kan altepetl de Tiro ken ompa kitlatemowiliskiah itlamamal n barko. ");
INSERT INTO nplNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ompa otikinmajsikeh sikimeh tokniwah, iwa otimokajkeh inwah chikome tonati. Yejwah okilijkeh n Pablo amo mawia Jerusalén, ijkó kemi okinnejmachti n Espíritu. ");
INSERT INTO nplNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Pero ijkuak owalchikometik otikiskeh de ompa. Nochteh tokniwah non kineltokah Cristo Jesús iwa insiwawah iwa impilwah, otechmakawatoh itempa n weyi atl, iwa ompa otimotlankuaketskeh iwa otimotiotsajtsilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ijkuakó otimonanawajtekeh, iwa otimomakajkeh iwa otitlejkokeh itech barko iwa yejwah omokopkeh incha. ");
INSERT INTO nplNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Satepa otiajkeh okachi tlayakapa iwa otikalakitoh kan altepetl de Tolemaida. Ompa otikintlajpalojkeh n tokniwah iwa otimokajkeh inwah se tonati. ");
INSERT INTO nplNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ijkuak owalmostlatik, otikiskeh de ompa iwa otikalakitoh kan altepetl de Cesarea. De ompa otiajkeh icha n Felipe, non otetlapowiaya n kualitlájtoli de Dios. Ye se de n chikome non okintlamakayah n tokniwah de Jerusalén. Ompa otimokajkeh icha. ");
INSERT INTO nplNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipe okimpiaya nawi ichpochwah non ayamó omonamiktiayah. Yejwah okitematiltiayah tlan okiseliayah de Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yotikatkah kech tonati ompa ijkuak oajsiko de Judea se profeta non itoka Ágabo, ");
INSERT INTO nplNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","non owala otechtlajpaloko. Ye okontílanki n kuítlaxtli non ika omotlajkoilpiaya n Pablo, okimilpi ikxiwah iwa imawah iwa okijto: —N Espíritu Santo kijtoa, nepa kan altepetl de Jerusalén, n judíojteh ijkí kiijilpiskeh n tekowa de nin kuítlaxtli iwa kitemaktiskeh inmak n tlakah non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ijkuak otikkakeh tlan okijto n Ágabo, tejwah iwa non de Cesarea otiktlatlautijkeh n Pablo amo mawia Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pero Pablo otechnankili: —¿Tleka nonchokah iwa nonkichiwah manimoyolkoko? Ne amo nimawi tla nechijilpiskeh noso tla nechmiktiskeh ompa Jerusalén por niktematiltijtinemi Itoka n Toteko Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Iwa kemi amo okinek techkakis, otikkajkeh iwa sa otikijtojkeh: —Mamochiwa tlan Dios kimonekiltis. ");
INSERT INTO nplNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ijkuak yopanokeh kechmeh tonatijmeh, otimotlatlalijkeh iwa otiajkeh Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Iwa oyajkeh towah sikimeh tokniwah de Cesarea, yejwah okwalikayah se tlakatl de Chipre non itoka Nasón, nin tlakatl yowejka okineltokaya n Cristo Jesús iwa ye techkalotiskia icha. ");
INSERT INTO nplNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ijkuak otikalakitoh Jerusalén, n tokniwah non kineltokah Cristo Jesús otechselijkeh ika pakílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ijkuak owalmostlatik, otiajkeh iwan Pablo otiktlajpalotoh n Jacobo, noiwa ompa okatkah nochteh n tokniwah tetajmeh non tlayakantokeh kan omoololoayah. ");
INSERT INTO nplNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo okintlajpalo iwa okintlapowi nochi tlan Dios okichi innawak non amo judíojteh ika iteki non Totajtsi Dios okimaktili. ");
INSERT INTO nplNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ijkuak okikakeh nochi tlan Pablo okintlapowi, okiweyijkachijkeh Dios. Iwa okilijkeh: —Toknitsi Pablo, yotikitak onkateh miaktikeh judíojteh non yotlaneltokakeh, pero nochteh yejwah kijtoah moneki matiktlakitakah itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Iwa yokimilijkeh tejwatsi tikinmachtia nochteh n judíojteh non chantitokeh itech oksikimeh altepemeh, iwa ayakmó makitlakitakah tlan Moisés otlanawati. Noiwa kijtoah te tikinmilia amo makinsirkunsidarokah impilwah nion makichiwakah tlan otechititijkeh totatawah. ");
INSERT INTO nplNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Tlan tikchiwaskeh? Porke n tlakah moololoskeh ijkuak kimatiskeh otiwala. ");
INSERT INTO nplNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Okachi kuali ijkí xikchiwa: Nika kateh towah nawi tlakah akimeh yokitemakakeh intlajtol inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Xikinwika mowah iwa ximochipawati inwah inawak Dios iwa xiktlaxtlawa para makinkuaximakah. Ijkó nochteh kimatiskeh mach milák tlan okintlatlapowijkeh, yej kitaskeh tejwatsi noiwa tiktlakita itlanawatil Moisés. ");
INSERT INTO nplNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pero n tokniwah non kineltokah Cristo Jesús non amo judíojteh, yotikintlajkuililijkeh iwa otikinmilijkeh amo makintekipacho nochi ni, sanwel amo makikuakah nakatl non yokinmanilijkah n diosmeh non kinmachijchiwah, nion estli, nion nakatl de yolkameh non san kintoskapatskah. Iwa amaka non yomonamikti mamomekatijtinemi. ");
INSERT INTO nplNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ijkuakó Pablo okinwík nonteh nawi tlakah, iwa ijkuak owaltláneski sansikah omochipajkeh. Otlanki okalak kan Weyi Tiopa okimilito tlan tonati tlamis mochipawaskeh, iwa kemania kinmiktiskeh n yolkameh para kinmaniliskeh Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Pero ijkuak yokitlamiayah chikome tonati de omochipajtokah, sikimeh judíojteh non owalajkeh de Asia okitakeh n Pablo kan Weyi Tiopa iwa opé kimpajsoloah n tlakah. Okikitskijkeh n Pablo ");
INSERT INTO nplNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","iwa otsajtsikeh: —¡Tlakah de Israel, techpalewikah! Ye nin tlakatl akin sentetl kitemachtijtinemi matikinmixnamikikah itlanawatilwah Moisés, iwa amo matiktlakitakah toweyi Tiopa. Iwa axa noiwa yokinkalakih itech toweyi Tiopa sikimeh griegos, iwa okipochewakoh nin chipawak Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ijkó okijtoayah porke ompa Jerusalén, yokitakah n Pablo iwa Trófimo non owalewatoka de Éfeso; yika okimoliayah Pablo noiwa yokikalakijka kan Weyi Tiopa. ");
INSERT INTO nplNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nochteh n tlakah omopajsolojkeh, iwa owalmoololojtiwetskeh. Ijkuakó okikitskijkeh n Pablo, okitlalxotontiajkeh iwa okikixtijkeh de kan Weyi Tiopa, iwa okintsaktiwetskeh ikaltenwah. ");
INSERT INTO nplNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ya kimiktiskiah n Pablo ijkuak n soldado tlayákanki romano okima nochteh n tlakah de Jerusalén opajsolitokah. ");
INSERT INTO nplNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","San nima n soldado tlayákanki okinmoololo isoldadojwah iwa okintlelochti kan omopajsolojtokah. Ijkuak n tlakah okitakeh n soldado tlayákanki iwa isoldadojwah, okikajkeh n Pablo iwa ayakmó okiwitekeh. ");
INSERT INTO nplNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ijkuak n soldado tlayákanki okalakito, okikitski n Pablo iwa otlanawati makiijilpikah ika ome kadenajteh. San nima n soldado tlayákanki okintlajtlani akin ye iwa tlan okichi. ");
INSERT INTO nplNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kemi nochteh otsajtsiah, n soldado tlayákanki amitla okajsikamatia, yika otlanawati makitsakuatih n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ijkuak okalakitoh kan kitsakuaskiah n Pablo, n soldadojteh sa okikechpanojtiayah porke n tlakah saikpanoa okualantokah. ");
INSERT INTO nplNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Iwa nochteh owaltsajtsitiwalayah inkuitlapa: —¡Mamikki! ");
INSERT INTO nplNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ijkuak ya kikalakiskiah kan kuártel, Pablo okili n soldado tláyakanki: —¿Weletis nimitsontlapowis? N soldado tlayákanki okinankili: —¿Titlajtoa griego? ");
INSERT INTO nplNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ijkuakó n soldado tlayákanki okili: —¿Amo te n egipsio non yowejka otikixnamik n weyi tlanawati, iwa otikinwík nawi mil temiktijkeh kan tlaltejtéyinki? ");
INSERT INTO nplNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo otlanankili: —¡Mach ne! Ne niwalewatok de Israel, iwa onitlákatki kan altepetl de Tarso, non altepetl weyi kijtosneki itech tlali de Cilicia. Pero nimitstlatlaujtia techonkawili manikintlapowi n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","N soldado tlayákanki okikawili matlajto, iwa n Pablo omóketski kan nochteh kitaskiah, iwa ika ima okintlakawaltih n tlakah. Ijkuakó nochteh san owalmokajkeh iwa Pablo opé tlajtoa ika hebreo, iwa okinmili: ");
INSERT INTO nplNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Nokniwah iwa tetajmeh, xikkakikah tlan ika nimotlajtolpalewis nomonawak. ");
INSERT INTO nplNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ijkuak okikakeh okintlapowiaya ika tlájtoli hebreo, san owalmokajkeh. Iwa n Pablo okinmili: ");
INSERT INTO nplNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Ne ni judío. Onitlákatki kan altepetl de Tarso non kajki kan tlali de Cilicia, pero onimoskalti nika Jerusalén, iwa Gamaliel onechixtlamachti itlanawatilwah totatawah. Nochipa nimochijchikawa niktekitilia Dios ika nochi noyolo, ijkó kemi nochteh nomejwah nonkichiwah. ");
INSERT INTO nplNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ya wejkawitl, ne onikintotojtokaya akimeh okitlakitaya itemachtilis n Toteko Jesús, iwa por notlajtlakol miakeh okinmiktijkeh. Ne onikinkitskiaya tlakah iwa siwameh iwa onikintsakuaya. ");
INSERT INTO nplNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","N tiópixki non okachi tlayakantok iwa nochteh n tetajmeh non tlayakantokeh kuali kimatokeh ijkó onikchiwaya. Porke yejwah innewiah onechinmakayah amatlajkuílolteh para manikinkitski n tokniwah judíojteh non chanchiwah Damasco. Yika onia onikintemoto n tlakah non kineltokah Cristo Jesús para nikualinwikas nika Jerusalén para makintlaijyowiltikah. ");
INSERT INTO nplNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","'Se tonati ijkuak oniaya itech ojtli, kemi ik tlajko tonati iwa yononkalakia Damasco, se chikawak tlawilnextílistli non owalaya de ilwikak onechyawalo. ");
INSERT INTO nplNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ijkuakó oniwetsito ixko tlali iwa onikak se tlájtoli non onechiliaya: “Saulo, Saulo, ¿tleka techtotojtoka?” ");
INSERT INTO nplNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ne onitlanankili: “¿Akin Tejwatsi?” Ye onechnankili: “Ne Jesús de Nazaret akin te tiktotojtoka.” ");
INSERT INTO nplNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Non oyayah nowa okitakeh n tláwili iwa omomojtijkeh, pero mach okikakeh n tlájtoli akin onechtlapowiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ijkuakó ne onikili: “¿Tlan nikchiwas, Noteko?” Noteko onechili: “Ximoketsa iwa xio Damasco, ompa mitsiliskeh tlan tikchiwas.” ");
INSERT INTO nplNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Iwa kemi non tláwili onechixmijmikti, ne ayakmó onitlachiaya, yika n tlakah akimeh nowa oyayah sa onechmatilantiajkeh asta otikalakitoh Damasco. ");
INSERT INTO nplNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","'Ompa okatka se tlakatl non itoka Ananías, akin okintlakitaya itlanawatilwah Moisés, iwa nochteh n judíojteh non ochantitokah Damasco okitlakitayah. ");
INSERT INTO nplNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ye owala nonawak iwa onechili: “Nokni Saulo, oksepa xitlachia.” Ijkuakó oniwaltláchixki, iwa onikitak Ananías. ");
INSERT INTO nplNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ijkuakó onechili: “Idios totatawah omitspéjpenki para xikixmati tlan Ye kimonekiltia, para xikita n Yolmilajka iwa xikkakili itlajtol. ");
INSERT INTO nplNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Te tikteixmatiltis innawak nochteh n tlaltikpaktlakah iwa tikinmatiltis nochi tlan otikitak iwa otikkak. ");
INSERT INTO nplNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Iwa axa, ¿tlan tikchia? Ximoketsa, ximokuaateki iwa ximochipawa de motlajtlakolwah, iwa xiktenewa itoka.” ");
INSERT INTO nplNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","'Ijkuak onimókopki Jerusalén, onia onimotiotsajtsilito kan Weyi Tiopa, iwa kemi yaskia nitejtemiktok, ");
INSERT INTO nplNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","onikitak iwa onechiliaya: “Xikistiwetsi de Jerusalén, porke amo kiseliskeh motlajtol ijkuak techteixmatiltis.” ");
INSERT INTO nplNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ijkuakó ne onikili: “Noteko, yejwah kuali kimatokeh ne onikajkalaktinemia itech nochteh n sinagogas iwa onikinwitekia iwa onikintsakuamigya nochteh akimeh omitsneltokayah. ");
INSERT INTO nplNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Iwa ijkuak okimiktijkeh n Esteban akin omitsteixmatiltiaya, ne ompa onikatka, oniktekawili makimiktikah iwa asta onikinmokuitlawili intlakenwah akimeh okimiktijtokah.” ");
INSERT INTO nplNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pero Jesús onechili: “Xio, porke Ne nimitstitlanis wejka, innawak non amo judíojteh.” ");
INSERT INTO nplNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Asta ompa okikakilijkeh itlajtol, otlanki opé tsajtsih: —¡Xikmiktikah non tlakatl! ¡Ayakmó mayolito! ");
INSERT INTO nplNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Satlawel otsajtsiah iwa tlakpak okintlamotlayah intlakenwah iwa miak tlali okitlamotlayah tlakpak. ");
INSERT INTO nplNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","N soldado tlayákanki otlanawati makikalakikah n Pablo kan kuártel. Otlanki otlanawati makiwitekikah para makijto tleka n tlakah satlawel okualaniah iwa fiero okitsajtsiah. ");
INSERT INTO nplNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pero ijkuak kuali yokijilpijkeh iwa yoyayah kiwitekitiweh, Pablo okili n kapita non ompa okatka: —¿Weletis nonkiwitekiskeh se tlakatl romano non ayamó nonkimatih kox milák tlajtlakole noso amó? ");
INSERT INTO nplNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ijkuak n soldado tlayákanki okikak tlan Pablo okijto, totokatijkak okimatiltito n soldado tlanawati iwa okili: —Kuali xikita tlan tikchiwas, nin tlakatl romano. ");
INSERT INTO nplNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ijkuakó n soldado tlayákanki owalmijkuani inawak Pablo iwa okitlajtlani: —¿Milák te tiromano? Pablo okinankili: —Milák. ");
INSERT INTO nplNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ijkuakó n soldadojtlayákanki okili: —Ne oniktlaxtla miak tomi para onimochi ni romano. Iwa n Pablo okinankili: —Ne onitlákatki kan altepetl de Tarso, yika ni romano. ");
INSERT INTO nplNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yika, akimeh kiwitekiskiah n Pablo okikajkeh; iwa ijkuak n soldadojtlayákanki, okima Pablo noiwa romano, omaujki porke yotlanawatijka makiijilpikah. ");
INSERT INTO nplNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ijkuak owalmostlatik, n soldado tlayákanki okinekia kimatis tleka n judíojteh okiteiliayah n Pablo. Otlanawati makintojtomilikah n kadenajteh iwa mamoololokah n tiopixkeh non tlayakantokeh iwa nochteh non de Sanedrín. Ijkuakó okikixti n Pablo iwa okiwikak innawak tlayakankeh judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo okintlajtlatak non de Sanedrín iwa okinmili: —Nokniwah, asta axa ne kuali ninemi ika notlamachilis chipawak inawak Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ijkuakó Ananías n tiópixki non okachi otlayakantoka, okinnawati non okatkah inakastla n Pablo, makikamatlatsinikah. ");
INSERT INTO nplNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pero Pablo okinankili: —¡Íxkoptli, te noiwa Dios mitskamatlatsinis! Tla te nonka tiewatok para techistlakos kemi kijtoa n tlanawátili, ¿tleka kiné tikixpanawia n tlanawátili iwa titlanawatia manechkamatlatsinikah? ");
INSERT INTO nplNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Non ompa okatkah okilijkeh n Pablo: —¿Timixewia ijkó tiknanankilia n weyi tiópixki de Dios? ");
INSERT INTO nplNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo okijto: —Nokniwah, ne mach onikmatia kox ye n tiópixki non okachi otlayakantoka; porke itech itlajkuilol Dios kijtoa: “Ayik fiero tiktenewas se tekiwa itech moaltepeu.” ");
INSERT INTO nplNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ijkuakó Pablo okajsikama sikimeh tekiwajkeh okatkah saduseos iwa oksikimeh fariseos, yika chikaktik okijto: —Nokniwah, ne nifariseo, iwa miakeh nochantlakawah noiwa fariseos; iwa ken nikneltoka non yomikkeh moyolitiskeh, nomejwah nonnechtlajtlakoltiah. ");
INSERT INTO nplNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ijkuak ijkó okijto n Pablo, n fariseos iwa n saduseos opé motlatlajtolwiah, iwa omoxexelojkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porke n saduseos kijtoah non yomikkeh mach moyolitiah. Noiwa kijtoa mach onkateh ángelteh nion espíritus. Pero n fariseos kijtoah nochi ni onka. ");
INSERT INTO nplNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nochteh otsajtsiah; iwa sikimeh tlamachtijkeh de itlanawatil Moisés, non okatkah iwa n fariseos, owalmokeketskeh iwa okijtojkeh: —Nin tlakatl amitla fiero okichi. Chamo milák se ángel noso se espíritu okitlapowi. Tejwah amo para tikixnamikiskeh Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Inkualanilis n fariseos iwa n saduseos omókopki se weyi momakalo. N soldado tlayákanki opé majmawi makikitskikah n Pablo iwa fiero makikojkokah. Yika okínnotski sikimeh isoldadojwah para makitekixtilikah iwa oksepa makiwikakah kan kuártel. ");
INSERT INTO nplNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ipan ok se tonati ijkuak otleyuak, n Toteko Jesús okimonextili n Pablo iwa okili: —Pablo, ximoyolchikawa, porke ijkó kemi otechteixmatilti nika Jerusalén, ijkó techteixmatiltis Roma. ");
INSERT INTO nplNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ipan ok se tonati, sikimeh judíojteh omotlatlalwijkeh kimiktiskeh n Pablo, iwa okisentlalijkeh amo tlakuaskeh nion atliskeh asta makimiktikah. ");
INSERT INTO nplNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Iwa nonteh tlakah non okisentlalijkeh ijkó kichiwaskeh, okatkah okachi de ome póali (40) tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yejwah oyajkeh okinmitatoh n tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh, iwa okinmilijkeh: —Tejwah yotiksentlalijkeh amo titlakuaskeh nion tiatliskeh asta matikmiktikah n Pablo. Iwa tla amó, okachi kuali itla matimochiwakah. ");
INSERT INTO nplNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Axa nomejwah, iwa n oksikimeh tekiwajkeh de n Sanedrín, xiktlajtlanilikah n soldado tlayákanki, mostla manomechwalikili n Pablo. Xikilikah nonkinekih okachi nonkitlatlajtlaniskeh, iwa tejwah sa tikchixtoskeh itech ojtli tikmiktiskeh keman ayamó onkalaki. ");
INSERT INTO nplNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pero itelpoch iwelti n Pablo okima, iwa oyá kan kuártel okimatiltito n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ijkuakó n Pablo okínotski se soldado tlanawati iwa okili: —Xikwika nin télpochtli inawak n soldado tlanawati, porke moneki motlapowis íwa. ");
INSERT INTO nplNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","N soldado tlayákanki okiwík n télpochtli inawak n soldado tlayákanki, iwa okili: —Pablo non tsaktok, onéchnotski iwa onechili manimitsalikili nin télpochtli, porke moneki motlapowis mowa. ");
INSERT INTO nplNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","N soldado okimatílanki n télpochtli, iwa okitlakaltecho iwa okitlajtlani: —¿Tlan tikneki techilis? ");
INSERT INTO nplNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","N télpochtli okili: —N tlayakankeh judíos yomotlatlalwijkeh mitstlajtlaniliskeh mostla xikintitlanili n Pablo innawak non de Sanedrín, yejwah mochiwaskeh kemi kinekih itla kiyektlajtlaniskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pero amo xikinneltoka; porke okachi de ome póali (40) tlakah ichtaka kichiatiweh, iwa okisentlalijkeh amo tlakuaskeh nion atliskeh asta makimiktikah n Pablo, iwa axa sa kichixtokeh tlan tikijtos. ");
INSERT INTO nplNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ijkuakó n soldado tlayákanki, okimaaka n télpochtli iwa okinawati amaka makili tlan okimatilti. ");
INSERT INTO nplNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","N soldado tlayákanki okínnotski ome isoldado tlanawatijkeh iwa okinnawati makintlatlalikah ome siento soldadojteh non san nejnemih, eyi póali iwa n májtlakteh soldadojteh ika inkabayojwah, iwa ome siento non kinwikah teposteh non yakawitstikeh, iwa okinnawati maonewakah Cesarea las nueve de yuak. ");
INSERT INTO nplNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Noiwa otlanawati makipejpechtikah se kabayo para ipa matlejko n Pablo, iwa okinnawati makiyekmokuitlawikah itech ojtli para kiteixpantiskeh kan n weyi tlanawati Félix. ");
INSERT INTO nplNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","N soldado tlayákanki okijkuilili n gobernador Félix se amatlajkuíloli: ");
INSERT INTO nplNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ne Claudio Lisias itech nin amatlajkuíloli nimitsontlajpaloa tejwatsi gobernador Félix: ");
INSERT INTO nplNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","N judíojteh okikitskijkeh nin tlakatl iwa ya kimiktiskiah, pero ijkuak ne onikma ye romano, onikinwík nosoldadojwah iwa oniktekixtilito. ");
INSERT INTO nplNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Iwa kemi oniknekia nikmatis tleka okiteiliayah, onikkuík innawak n tekiwajkeh de Sanedrín, ");
INSERT INTO nplNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","iwa ijkuak onikma okiteiliayah san por intlanawatil, ne onikmoli mach para kimiktiskeh, nion para kitsakuaskeh ika noni. ");
INSERT INTO nplNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pero ne onikma n judíojteh yomotlatlalwijkeh kimiktiskeh, yika nimitsontitlanilia, iwa akimeh kiteiliah noiwa onikinmili mawiah monawak iwa mamitsilikah tleka kiteiliah. Kuali xiyetia iwa ok se tonati timotlajpaloskeh.” ");
INSERT INTO nplNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","N soldadojteh okichijkeh ijkó kemi okinnawatijkeh iwa non yúali okiwikakeh n Pablo kan weyi kuártel non itoka Antípatris. ");
INSERT INTO nplNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ijkuak owalmostlatik, n soldadojteh non san onejnentiayah owalmokopatoh para Jerusalén, iwa non oyayah ipan kabayo okiwikakeh n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ijkuak okalakitoh kan altepetl de Cesarea, okimakakeh n amatlajkuíloli n gobernador Félix noiwa okitemaktijkeh n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ijkuak n gobernador okiamapo n amatlajkuíloli, okitlajtlani n Pablo kan otlákatki, iwa ijkuak okima Pablo otlákatki Cilicia, ");
INSERT INTO nplNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","okili: —Nimitskakis ijkuak witseh akimeh mitsteiliah. Otlanki otlanawati makiyekmokuitlawikah itech ipalasio n Herodes. ");
INSERT INTO nplNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mákuili tonati satepa, n weyi tiópixki Ananías, okalakito kan altepetl de Cesarea iwa n sikimeh tetajmeh non tlayakantokeh iwa se tlajtolpalewi non itoka Tértulo. Ninteh omoteixpantitoh inawak n gobernador Félix para kiteiliskeh n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ijkuak okualikakeh n Pablo, Tértulo opé kiteilia, iwa okili n gobernador Félix: —Satlawel timotlasojkamatih monawak gobernador, porke kuali tikateh, iwa nochi kuali kajki porke saikpanoa tiixtlamati. ");
INSERT INTO nplNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Por nochi tlan tejwatsi sentetl tikchiwa, tejwah tipakih iwa timotlasojkamatih monawak gobernador Félix. ");
INSERT INTO nplNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Iwa kemi amo tiknekih timitsnaktiskeh, timitsontlatlaujtiah xikoninkaki san kanaj kech tlájtolteh. ");
INSERT INTO nplNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tejwah kuali tikmatokeh nin tlakatl se weyi tekokolismák, iwa san kan ik nentinemi kinpajsolojtinemi n judíojteh; iwa kinyayakantinemi sikimeh tlakah non kinmiliah nazarenos. ");
INSERT INTO nplNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Iwa okinekia tlajtlakolchiwas kan Weyi Tiopa, yika tejwah otikkitskijkeh iwa otiknekiah tiktsakuaskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Pero n soldado tlayákanki Lisias omokalaki iwa otechmakixtili n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Iwa trato okinnawati akimeh okiteiliayah mawikih monawak. Axa tejwatsi monewia weletis tikonyolkuitis iwa tikonmatis tleka tikteiliah. ");
INSERT INTO nplNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","N judíojteh non ompa okalakikoh, okijtoayah milák tlan okijtojtoka n Tértulo. ");
INSERT INTO nplNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ijkuakó n gobernador okimanotski n Pablo para matlajto, iwa Pablo okijto: —Ika miak pakílistli nimotlajtolpalewis monawak, porke nikmatok tejwatsi yowejka titekiwajtitok itech nin weyi tlali. ");
INSERT INTO nplNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tejwatsi monewia weletis tikmatis kox milák tlan nimitsonilijtok noso amó, sikin kipia májtlaktli iwa ome tonati oniajsiko nika Jerusalén onikweyijkachiwako Dios. ");
INSERT INTO nplNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mach onechajsikeh nimokualanijtok nion onechajsikeh nikinxexelojtok n tlakah, nion onikimpajsolojtinemia n tlakah ijtik n Weyi Tiopa, noso kan sinagogas, noso oksika. ");
INSERT INTO nplNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ijkó kiné, ninteh tlakah mach weletis mitsnextiliskeh tlan ika nechteiliah. ");
INSERT INTO nplNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Axa, monawak nikmokuitia ne nikmopantia Dios, Idios notatawah ijkó kemi nechnextilia n yankuik ojtli, non yejwah kitokayotiah sekta, porke nikneltoka nochi tlan ijkuilitok itech itlanawatil iwa itech intlajkuilol n profetas. ");
INSERT INTO nplNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ne nikchia inawak Dios tlan yejwah noiwa kichiah, nochteh non yomikkeh moyolitiskeh, akimeh otlájtlakolchijkeh iwa akimeh amó. ");
INSERT INTO nplNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yika, nochipa nikchiwa tlan kuali, para notlamachilis amo manechtlajtlakolti inawak Dios nion innawak n tlakah. ");
INSERT INTO nplNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","'Miak xiwitl oniajtoka wejka itech oksikimeh tlalmeh, iwa ijkuak onimókopki kan nopaís, onia onikimpalewito akimeh amitla kipiah iwa oniktemakato notlatliokolil. ");
INSERT INTO nplNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ne ijkó onikchijtoka ijtik n Weyi Tiopa ijkuak sikimeh judíojteh non owalayah de Asia onechajsitoh ompa. Ijkuakó ne yonimochipajka kemi kijtoa n tlanawátili, iwa mach miakeh ompa okatkah nion aka omopajsoloaya. ");
INSERT INTO nplNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tla itla amokuali onikchi iwa kinekih nechteiliskeh, mawikih akimeh ompa okatkah. ");
INSERT INTO nplNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Iwa tla amó, ninteh akimeh nika kateh makijtokah tlan amokuali onechajxililijkeh ijkuak onimotlajtolpalewijtoka kan Sanedrín. ");
INSERT INTO nplNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Noso chamo nechteilijtokeh porke ijkuak ompa onikatka, inmixpa chikaktik onikijto: “Nomejwah axa nonnechtlajtlakoltiah porke nikneltoka moyolitiskeh non yomikkeh.” ");
INSERT INTO nplNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ijkuak Félix okikak tlan Pablo okijto, iwa ye kuali okimatia tlan kijtosneki n ojtli de Cristo, okika nochi para ok se tonati iwa okinmili: —Ijkuak wits n soldado tlayákanki Lisias nikyektlajtlanis tleka nonkiteiliah, iwa ijkuakó nikitas tlan nikchiwas iwan Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ijkuakó Félix okinawati n soldado tlanawati ok matsakto n Pablo, pero makinkawili non iwa omowikaya makitlajpalokih iwa makimakakih tlan kipolos. ");
INSERT INTO nplNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kech tonati satepa, oksepa owala n gobernador Félix iwa Drusila isiwa, ye israelita. Félix otlanawati makinotsatih n Pablo para makitlapowiki de n kualitlájtoli de Cristo Jesús. ");
INSERT INTO nplNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pablo opé kitlapowia kenijki moneki mayeknemi, iwa kenijki se moyeknawatis. Noiwa okili Dios se tonati techtlaxtlawaltis nochi tlan otikchijkeh, ika noni Félix omomojti iwa okili: —San ika ye. Ijkuak nimajxilis oksepa nitlatitlanis mamitsnotsatih. ");
INSERT INTO nplNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","N gobernador Félix tekil otlatitlania makinotsatih n Pablo para motlapowis íwa, porke okinekia makimaka itla tomi para kikajkawas. ");
INSERT INTO nplNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ome xiwitl ijkó okichijtoka n gobernador Félix asta ijkuak omopatlak iwa okalak n Porcio Festo. Iwa kemi Félix okinekia kuali mokawas iwan judíojteh, okika n Pablo matsakto. ");
INSERT INTO nplNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo owala okiseliko iteki de gobernador, iwa eyi tonati satepa okiski de Cesarea iwa oyá Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ompa n tiopixkeh non tlayakantokeh iwa n tlayakankeh judíojteh oyajkeh inawak n gobernador Festo okiteilitoh n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Iwa okitlatlautijkeh matlanawati makualikakah n Pablo ompa Jerusalén. Ijkí okilijkeh porke omotlatlalwijkeh kimonepachwiskeh n Pablo itech ojtli para kimiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pero Festo okinmili Pablo otsaktoka Cesarea, iwa kech tonati satepa ye yaskia ompa. ");
INSERT INTO nplNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Iwa okinmili: —Yika, akimeh nika nontekiwajkeh xiwiah nowa Cesarea, iwa tla non tlakatl okichi itla amokuali, ompa weletis nonkiteiliskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","N gobernador Festo okatka kan altepetl de Jerusalén san kemi chikweyi noso májtlaktli tonati, iwa omókopki kan altepetl de Cesarea. Ijkuak owalmostlatik omoyayanti kan jusgado, iwa otlanawati makualikilikah n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ijkuak Pablo okalakito ixpa n gobernador, omopachojkeh n judíojteh non owalajkeh de Jerusalén. Opé kiteiliah san de miak, pero mach itla oweletkeh okinextilijkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ijkuakó Pablo, opé motlajtolpalewia ika nin tlájtoli: —Ne mach onikchi itla tlajtlákoli, nion itech intlanawatilwah n judíojteh nion ijtik n Weyi Tiopa. Nion onikixpanawi n rey César. ");
INSERT INTO nplNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pero kemi n gobernador Festo okinekia mokawas kuali iwan judíojteh, okitlajtlani n Pablo: —¿Tikneki tias Jerusalén para ompa nimitstlatsintokis? ");
INSERT INTO nplNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablo otlanankili: —Ya nika ixpa n César kan tlaixkomaka, kan moneki manechtlatsintokikah ika tlan nechteiliah. Tejwatsi kuali tikmatok, amo onikchi itla amokuali innawak n judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Porke tla onikchi itla amokuali iwa moneki manechmiktikah, ¡manechmiktikah! Pero tla san nechtlamamaltijtokeh iwa amo milák niktewikilia, amaka weletis nechtemakas inmak n tlayakankeh judíojteh. Ne nikneki manechwikakah inawak n weyi tlanawati César para ye manechtlatsintoki. ");
INSERT INTO nplNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Satepa ijkuak n gobernador Festo yokintlajtolti non oksikimeh itekiwajkawah, okili n Pablo: —Te otikmotlajtlanili matimitswikakah inawak n César. Tias inawak. ");
INSERT INTO nplNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kech tonati satepa, n rey Agripa Segundo iwa n Berenice oyajkeh Cesarea okitlajpalotoh n gobernador Festo. ");
INSERT INTO nplNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Iwa kemi ompa omokajkeh miakeh tonatijmeh, Festo okitlapowi n rey Agripa tleka otsaktoka n Pablo, iwa okili: —Nika kajki se tlakatl akin Félix okitsaktewak. ");
INSERT INTO nplNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Iwa ijkuak onikatka Jerusalén, n tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh kan Weyi Tiopa okiteilikoh nonawak, iwa onechtlajtlanilijkeh maniktlajtlakolti. ");
INSERT INTO nplNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ne onikinnankili n tlanawatijkeh romanos mach kitekawiliah aka makimiktikah tla ayamó achto motlajtolpalewia innawak akimeh kiteiliah. ");
INSERT INTO nplNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Yika, ijkuak yejwah owalajkeh nika, san nima ipan ok se tonati onimoyayanti kan nitlaixkomaka iwa onitlanawati makualikakah non tlakatl. ");
INSERT INTO nplNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Pero akimeh okiteilikoh n Pablo, mach itla okijtojkeh ika tlan ne onikyejyekoliaya. ");
INSERT INTO nplNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sanwel okiteiliayah de intlamachtilis, iwa de se tlakatl non itoka Jesús, Akin yomikki iwa Pablo kijtoa yolitok. ");
INSERT INTO nplNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Iwa kemi ne amo onikmatia tlan nikchiwas, oniktlajtlani n Pablo kox okinekia yas Jerusalén para ompa makitlatsintokikah. ");
INSERT INTO nplNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pero kemi ye okimotlajtlanili makitlatsintoki n César Augusto, onitlanawati matsakto asta ijkuak weletis niktitlanis inawak n César. ");
INSERT INTO nplNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ijkuakó Agripa okili n Festo: —Ne noiwa niknekiskia nikkakis non tlakatl. Festo okinankili: —Niman mostla weletis tikkakis. ");
INSERT INTO nplNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ijkuak owalmostlatik, Agripa Segundo iwa Berenice okalakikoh kan kiyolwitiskiah n Pablo, okalakeh tlakentitiwitseh ika kuájkuali tlakemitl kemi motlakentiah n wejweyi tlanawatijkeh itech nin tlaltíkpaktli. Noiwa owalajkeh n soldado tlayakankeh iwa n tekiwajkeh de non altepetl. N gobernador Festo otlanawati makualikakah n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ijkuakó n gobernador Festo okijto: —Rey Agripa, iwa nochteh akimeh nika nonkateh, nika kajki n tlakatl akin nomejwah nonkiteiliah. Iwa nika Cesarea iwa Jerusalén, miakeh tlayakankeh judíojteh kiteiliah nonawak, iwa nechtlajtlaniliah manikmikti. ");
INSERT INTO nplNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Pero ne mach itla weyi tlajtlákoli onikajsik kemi para se makimikti, iwa kemi ye inewia okimotlajtlanili makitlatsintoki n César, yika onikmoli niktitlanis inawak. ");
INSERT INTO nplNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Iwa kemi amo nikajsi itla tlan ika weletis niktlajkuililis n César, yika nomechalikilia nin tlakatl, iwa okachi monawak tejwatsi rey Agripa, para tejwatsi xiktlatsintoki iwa ijkó manikpia itla tlan ika niktlajkuililis n César. ");
INSERT INTO nplNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Porke ne nikita amo kuali ka maniktitlani se non tsaktok iwa amo manikteili tleka kiteiliah. ");
INSERT INTO nplNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ijkuakó n rey Agripa okili n Pablo: —Weletis timotlajtolpalewis. Ijkuakó Pablo okajkok ima iwa ijkí opé tlajtoa: ");
INSERT INTO nplNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Niyolpaki miak porke weletis nitlajtos monawak rey Agripa, iwa nimotlajtolpalewis de nochi tlan nechteiliah n tlayakankeh judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Iwa okachi, porke tejwatsi kuali tikmatok nochi tlan tejwah akimeh tijudíojteh ya wejkawitl tikchijtiwitseh, iwa tikmatok tlan techtoktia matimotlatlajtolwikah. Yika nimitsontlatlaujtia xikonkaki nochi tlan nikijtos. ");
INSERT INTO nplNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","'Nochteh n judíojteh kuali kimatokeh kenijki oninenki kan altepetl de Tarso iwa kan altepetl de Jerusalén desde ni chokotsi. ");
INSERT INTO nplNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Yejwah yowejka nechixmatih onikatka nifariseo, iwa onikatka seme de akimeh okachi tikmopantiah totlanawatil. ");
INSERT INTO nplNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Iwa axa nika onechalikakeh nechteiliah. Nechteiliah porke nikneltoka Dios kinyolitis akimeh yomikkeh, kemi Ye okisentlali kichiwas ijkuak okinkakiti totatawah. ");
INSERT INTO nplNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","N tlakah non walewatokeh itech n májtlakteh iwa ome familias de Israel kichiah mamochiwa tlan Dios okinkakiti, yika kiweyijkachiwah iwa tlajka iwa n yuak kimopantiah. Iwa porke ne noiwa nikneltoka tlan yejwah kineltokah, yika axa, tejwatsi rey Agripa, n judíojteh nechteiliah. ");
INSERT INTO nplNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nomejwah nonkineltokah Dios kinyolitia non yomikkeh. ");
INSERT INTO nplNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","'Ya wejkawitl, ne onikmoliaya omonekia manikintlaijyowilti akimeh kineltokah Jesús de Nazaret. ");
INSERT INTO nplNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ijkó onikchi kan altepetl de Jerusalén. Ika intlanekilis n tiopixkeh non tlayakantokeh onikintsak miakeh tlakah non kineltokah Cristo Jesús. Iwa ijkuak okiyejyekoliayah kinmiktiskeh ne onikijto kuali ka. ");
INSERT INTO nplNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Miak welta ne onikintlaijyowiltiaya itech n sinagogas iwa onikintoktiaya makijtokah itla pitsotik de Cristo Jesús. Satlawel onechkualaniayah, yika wejka onikintemojtinemia itech miakeh altepemeh. ");
INSERT INTO nplNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","'Ika intlanekilis n tiopixkeh non tlayakantokeh iwa n tetajmeh non tlayakantokeh, se tonati oniaya nikintemoti n tlakah non kineltokah Jesús kan altepetl de Damasco. ");
INSERT INTO nplNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Pero ik tlajko tonati, ijkuak oniaya itech ojtli onikitak se tláwili non owalaya de kan ilwikak okachi teixmijmikti ke n tonati. Non tláwili onechyawalo, iwa akimeh oyayah nowa noiwa okinyawalo. ");
INSERT INTO nplNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tinochteh otiwewetsitoh ixko tlali, iwa onikak se tlájtoli non onechiliaya ika tlájtoli hebreo: “Saulo, Saulo, ¿tleka techtotojtoka? Monewia timokojkojtok, kemi ijkuak se toro kiteliksa itla yakawitstik iwa san ye inewia mokojkoa.” ");
INSERT INTO nplNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ne oniktlajtlani: “¿Akin tejwatsi Noteko?” Ye onechnankili: “Ne Jesús, akin te tiktotojtoka. ");
INSERT INTO nplNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Pero ximoketsa, porke ne onimitsmonextili para xiyeto notékitki iwa xiktematilti tlan axa yotikitak iwa tlan satepa nimitsnextilijtias. ");
INSERT INTO nplNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ne nimitsmokuitlawis inmak n judíojteh iwa inmak non amo judíojteh, kan axa nimitstitlani ");
INSERT INTO nplNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","para tikinmixtlajtlapos iwa ayakmó manemikah kan tlatleyua yej manemikah kan onka tláwili para ayakmó makinmapixto n satanás, yej makitlakitakah Dios; iwa manechneltokakah, iwa ijkó makiselikah tlapojpolwílistli iwa se tlatliokólili inwah akimeh Dios yokinmopejpenili.” ");
INSERT INTO nplNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","'Ijkó kiné, tejwatsi rey Agripa, ne oniktlakama tlan onechnawati non tlájtoli non onikak de ilwikak. ");
INSERT INTO nplNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Achto onikinmatilti itlajtol Dios akimeh chantitokeh Damasco, otlanki akimeh kateh Jerusalén iwa itech nochi n tlali de Judea. Noiwa non amo judíojteh onikintlalwi makinkawakah intlajtlakolwah iwa makichiwakah tlan kuali inawak Dios, para mamota de milajka omoyolpatlakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yika, n judíojteh onechkitskijkeh kan Weyi Tiopa iwa okinekiah nechmiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Pero ken Dios onechpalewi ya nika nitlanti, nikinmatiltijtiwits itlajtol Dios akimeh weyijkatitokeh iwa non tsitsikitikeh. Ayik itla oksé onikinmili tlamochiwaskia, sanwel tlan okijtojkeh n profetas iwa Moisés, ");
INSERT INTO nplNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Cristo tlaijyowiskia, iwa ijkuak mikiskia, Ye achto moyolitiskia de kan mikemeh, iwa kitematiltiskia itlajtol Dios innawak n judíojteh iwa non amo judíojteh. ");
INSERT INTO nplNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ijkuak Pablo okimijto ninteh tlájtolteh non ika omotlajtolpalewiaya, Festo otsajtsik: —¡Yotikuatlapolo, Pablo! Yotikuatlapolo porke saikpanoa otimoixtlamachti. ");
INSERT INTO nplNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pero Pablo otlanankili: —Tejwatsi gobernador Festo, mach nikuatlapolojtok. Tlan nikijtoa kuali kajki iwa milák. ");
INSERT INTO nplNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nika kajki n rey Agripa, akin kuali kimati tlan nikijtojtok, yika nimixewia nitlajtoa ika yolchikawálistli ixpa, ken kuali nikmatok ye ya kimatok tlan nikijtojtok, porke nochi tlan mochijtiwits, amo san moichtakachijtiwits. ");
INSERT INTO nplNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Rey Agripa, ¿tikneltoka tlan okijtojkeh n profetas? Ne kuali nikmatok tikneltoka. ");
INSERT INTO nplNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","N rey Agripa okinankili: —Sa ika achitsi otikchiwaya manimokopa nicristiano. ");
INSERT INTO nplNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablo okili: —Tla sa ika achitsi noso ika miak, niktlajtlanilia Dios makichiwa tejwatsi noiwa xikneltoka Cristo Jesús. Pero amo san tejwatsi, yej noiwa nochteh akimeh nika nechkaktokeh, mamoyolkopakah kemi ne. Pero amo maikxiilpitokah ika kadena kemi ne. ");
INSERT INTO nplNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ijkuak Pablo okimijto ninteh tlájtolteh, n rey Agripa omóketski iwan Berenice, noiwa Festo iwa nochteh non ompa okatkah, ");
INSERT INTO nplNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","iwa inmixkoya omotlapowitoh. Iwa okimoliayah: —Nin tlakatl amitla fiero okichi kemi para se makimikti, nion amo para tsaktos. ");
INSERT INTO nplNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Iwa Agripa okili n Festo: —Nin tlakatl weletiskia tikkajkawaskiah, tla amo kitlajtlaniskia yas inawak César. ");
INSERT INTO nplNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ijkuak okijtojkeh techtitlaniskeh Italia, Pablo iwa n oksikimeh tlakah non noiwa oikxilpitiayah, okinmaktilijkeh n soldado tlanawati non itoka Julio. Ye okatka kapita de se siento de soldadojteh iaxkawah n César Augusto. ");
INSERT INTO nplNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Otitlejkokeh itech se barko non owalaya de kan puerto de Adramitio iwa ya onewaskia Asia. Noiwa okatka towah Aristarco, se tlakatl de Tesalónica non kajki kan tlali de Macedonia. ");
INSERT INTO nplNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Iwa ijkuak owalmostlatik otikalakitoh kan puerto de Sidón; ompa n soldadojtlanawati Julio opé kiyeknotsa n Pablo iwa okikawili makintlajpaloti non iwa omowikaya para makipalewikah. ");
INSERT INTO nplNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ijkuak otikiskeh de kan puerto de Sidón ipan barko, otikonmilajkeh kan ik isla de Chipre, porke n ejekatl otechixnamiktiwalaya. ");
INSERT INTO nplNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Otitlakotontiajkeh itech weyi atl iwa otipanokeh iyakapa n altepetl de Cilicia iwa Panfilia. Satepa otikalakitoh kan altepetl de Mira non kajki kan tlali de Licia. ");
INSERT INTO nplNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ompa n soldado tlanawati okitak se barko non owalaya de kan altepetl de Alejandría iwa oyaya para Italia, iwa n ye otechnawati matitlejkokah itech non barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Otipanokeh miak tonati ipan weyi atl porke yolik onejnemia n barko, yika satlawel otiwejkajkeh iwa ika miak tlaijyowílistli otikalakitoh iyakapa n altepetl de Gnido. Iwa kemi n ejekatl ok otechixnamiktiwalaya, otikyawalojkeh n isla de Creta iwa otipanokeh iyakapa n altepetl non itoka Salmón. ");
INSERT INTO nplNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Semi owi otiajkeh ik nochi tlátentli asta otikalakitoh kan puerto non kiliah Buenos Puertos. Non puerto mach ok wejka okatka de kan altepetl non itoka Lasea. ");
INSERT INTO nplNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Miakeh tonatijmeh yotinejnentokah itech weyi atl. Yokatka temojti para se yas itech weyi atl, ken yoajsitiwalaya n sewaya, iwa ijkuak osewaya okinmixnamiktiwalaya n ejekatl chikaktik. Noiwa yopanoka n ilwitl de Yom Kippur keman mosawah n judíojteh. Yika, Pablo okintlapowi akimeh ompa oyayah, ");
INSERT INTO nplNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","iwa okinmili: —Tlakah, nikita mach ok weletis tiaskeh okachi itech weyi atl porke weletis itla timochiwaskeh. Iwa amo san tikpoloskeh n barko iwa itlamamal, yej asta tejwah noiwa weletis timikiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Pero n soldado tlanawati okachi okineltokaya n tekowa de n barko iwa akin okinejnemitiaya, iwa amo okikakia tlan okiliaya n Pablo. ");
INSERT INTO nplNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Iwa kemi non puerto amo okatka kuali para se mokawas ompa itech sewaya, miakeh okijtojkeh okachi kuali matikisakah de ompa. Matikyejyekokah chamo tonkalakitiweh Fenice, se puerto de Creta non tlachixtok kan ik kalaki tonati iwa ompa timochiaskiah asta mapano n sewaya. ");
INSERT INTO nplNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Iwa kemi okitakeh opé nejmantsi ejeka ik tlatsintla, okimolijkeh chamo ya weletiskia onewaskiah. Okiskeh de ompa, iwa san ik tlátentli okiyawalojtiajkeh n isla de Creta. ");
INSERT INTO nplNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Iwa ayamó wejka oyayah ijkuak se ejekatl chikaktik kemi se siklón okimomakako n barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","N ejekatl opé kiwika n barko. Iwa kemi ayakmó otiweletkeh otiknejnemitiayah n barko, otikkawilijkeh makiwika n ejekatl. ");
INSERT INTO nplNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Otipanokeh ikuitlapa se isla non itoka Clauda, kan ik ejekatl amo chikawak otlawitekia, iwa ika miak tekitl otiweletkeh otiktlejkoltijkeh n barkajtsi non okitilantiwalaya n barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Satepa ijkuak yokitlejkoltijkeh n barkajtsi, okitlajkoilpijkeh n weyi barko ika miak mekatl; iwa kemi okimawiliayah maixtsoponiti ijtik xali non kiliah Sirte, okintemowilijkeh ilonajwah iwa sa ijkó okikajkeh makiwika n ejekatl. ");
INSERT INTO nplNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Iwa ijkuak owalmostlatik, ok oejekatoka chikaktik, okitlamochilijkeh siki itlamamal n barko ijtik atl; ");
INSERT INTO nplNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","iwa ijkuak obiktlatik, innewiah ika inmawah okintlamotlakeh ijtik weyi atl ilonajwah iwa oksiki tlan okitekitiltiayah itech barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Miakeh tonatijmeh otlamixtentoka iwa amo otiktakeh nion tonati nion sítlalteh, iwa ika neká chikaktik kiawiejekatl non topa owetsia otikmolijkeh timikiskiah. ");
INSERT INTO nplNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kemi ya miak tonati amo otitlakuayah, Pablo omóketski tlatlajkotia iwa okijto: —Tlakah, okachi kuali nonnechkakiskiah iwa amo tikisaskiah de Creta. Ijkó amo titlaijyowiskiah nion nonkipoloskiah itlamamal n barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Pero amo ximosotlawakah, porke maya tikpoloskeh n barko, nion se de nomejwah mikkis. ");
INSERT INTO nplNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Porke nin yúali onechmonextili se iángel Dios, akin niteaxka inawak iwa niktekitilia. ");
INSERT INTO nplNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","N ángel onechili: “Amo ximawi Pablo, porke tikpia de timoteixpantiti inawak n César, iwa por te Dios amo kikawas mamikki nion se non kateh mowah itech nin barko.” ");
INSERT INTO nplNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yika, ximoyolchikawakah tlakah, porke ne nikneltoka Dios, iwa kuali nikmatok Ye kichiwas nochi tlan iángel onechili. ");
INSERT INTO nplNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Pero moneki matechtlamotlati n ejekatl inakastla n isla. ");
INSERT INTO nplNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ijkuak opanokeh májtlaktli iwa nawi tonati, non yúali n ejekatl otechwiwikaya itech weyi atl non itoka Adriático. Iwa kemi ik tlajko yúali akimeh okinejnemitiayah n barko, okimachiliayah ya onajsiah kan onka tlali. ");
INSERT INTO nplNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ijkuakó okitamachijkeh n atl kox ok wejkatla, iwa okipiaya sempóali iwa n káxtoli iwa n se metro (36) tlawejkatla. Okachi tlayakapa oksepa okitamachijkeh iwa okipiaya sempóali iwa n chikome (27) metro tlawejkatla. ");
INSERT INTO nplNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ken okimawiliayah kimomakatiweh itla weyi tetl, okinkajkajkeh nawi wejweyi ganchojteh de tépostli ik ikuitlapa n barko para makitsekokah, iwa sa okichixtokah matlanestiwetsi. ");
INSERT INTO nplNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Pero akimeh okinejnemitiayah n barko okinekiah choloskeh, iwa opé kitemowiah n barkajtsi non okitekitiltiayah ijkuak oapolakia n barko. Yejwah omochijkeh yawih kinkajkawatiweh ijtik n weyi atl n téposteh ik iyakapa n barko para kitsekoskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ijkuakó Pablo okili n soldado tlanawati iwa isoldadojwah: —Tla ninteh tlakah amo mokawah itech barko, nomejwah noiwa nonmikiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ijkuakó n soldadojteh okintekeh n mekameh non ika oilpitoka n barkajtsi iwa okikajkeh makiwika n atl. ");
INSERT INTO nplNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ijkuak yotlatlanestiwalaya, Pablo okinyolchikawaya nochteh matlakuakah, iwa okinmili: —Yokaxtoltik iwa nomejwah amo nonkochtikateh nion itla nonkikuajtikateh. ");
INSERT INTO nplNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nomechtlatlaujtia xitlakuakah para nonkipiaskeh chikawálistli, porke amaka de nomejwah kipolos nion se itsonkal. ");
INSERT INTO nplNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ijkuak ijkí okijto n Pablo, okónanki se paj, omotlasojkama inawak Dios inmixpa n nochteh, okitlajkotlápanki iwa opé kikua. ");
INSERT INTO nplNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","San nima nochteh omoyolchikajkeh iwa opé tlakuah. ");
INSERT INTO nplNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nochteh akimeh otiayah itech barko, otikatkah ome siento iwa n eyi póali iwa n káxtoli iwa n se (276). ");
INSERT INTO nplNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Iwa ijkuak nochteh kuali yoixwikeh, okontlamotlakeh n trigo ijtik atl para maejkautia n barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ijkuak otláneski, n tlakah non okinejnemitiayah n barko mach omixmoskalijkeh kan okatkah, pero okitakeh se weyi imamayo n weyi atl iwa onkalaktoka itech non tlali, iwa ompa okinekiah kijkuaniskeh n barko, porke omotaya okatka miak xali. ");
INSERT INTO nplNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Okintejtekeh n mekameh non ika oilpitokah n téposteh non okitsekojtokah n barko, iwa ompa okinkajkeh ijtik atl. Okinkaxanijkeh n mekameh non ika oilpitoka n timón non kiyakana n barko. Okitlejkoltijkeh ilona n barko para makinejnemiti n ejekatl, satepa n barko opé mijkuania ik tlátentli. ");
INSERT INTO nplNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Pero okalakito kan omoixnamikiah ome ameh, iwa n barko oyakatsoponito ijtik xali iwa ompa omoka, iwa opé xixini ik ikuitlapa, porke n amemélolteh omotlawitekiah chikaktik ipan barko. ");
INSERT INTO nplNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ijkuakó n soldadojteh okinekiah kinmiktiskeh n tlakah non konintsakuaskiah, para amo mamotlamotlakah ijtik atl iwa machocholokah. ");
INSERT INTO nplNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Pero n soldado tlanawati okinekia kipalewis n Pablo, iwa amo okitekawili makinmiktikah, yej okinnawati akimeh oweletiah ajkuiah achto mamokajkawakah ijtik atl para makalakitih tlátentli, ");
INSERT INTO nplNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","iwa akimeh amo oweletiah ajkuih, okinnawati mawiah ipan tablajteh noso ipan kuaujmeh non opostekah de n barko. Iwa ijkó nochteh okalakitoh tlátentli. ");
INSERT INTO nplNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ijkuak yotimomakixtijkeh tinochteh, otechilijkeh non isla itoka Malta. ");
INSERT INTO nplNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Non ompa ochanchiwayah otechyekselijkeh; okixotlaltijkeh se weyi tlékuili, iwa kemi okiaujtoka iwa osewatoka, otechtlalwijkeh matimijkuanikah iyakapa n tlékuili. ");
INSERT INTO nplNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ijkuakó Pablo okoololoto siki kuawitl non yowaki. Pero ijkuak okontlamotlak n kuawitl ijtik tletl, se koatl owalkistewak, iwa omopilo itech ima. ");
INSERT INTO nplNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ijkuak n tlakah non ochantitokah itech non isla okitakeh n koatl pilkatok itech ima n Pablo, okimolijkeh: —Nin tlakatl se temikti, porke maya omomakixti itech weyi atl, mach kikawiliah mayolito. ");
INSERT INTO nplNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pero Pablo omomatsejtselo iwa n koatl owetski ijtik tletl, iwa ye amitla omochi. ");
INSERT INTO nplNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nochteh okichixtokah maposawa ima, noso mawetsi ya miketl. Pero kemi owejka omochixtokah iwa amitla omochiwaya, okipatlakeh intlayejyekolis iwa opé kijtoah Pablo se dios. ");
INSERT INTO nplNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ik ompa okatkah sikimeh tlalmeh non okatkah iaxkawah se tlakatl non itoka Publio. Ye otlanawatiaya itech non isla, iwa eyi tonati otechkaloti icha iwa otechtlakualti. ");
INSERT INTO nplNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ita n Publio owetoka porke okipiaya totonik iwa tsonkuálaktli. Pablo okitlajpaloto n kókoxki, omotiotsajtsili iwa ipa okintlali imawah iwa okipajti. ");
INSERT INTO nplNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Satepa ijkuak ijkó opanok, akimeh ochantitokah itech non isla iwa omokokoayah, owalayah inawak Pablo iwa ye okimpajtiaya. ");
INSERT INTO nplNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Iwa satlawel otechtlakitakeh, iwa ijkuak ya tionewaskiah itech barko, otechmakakeh nochi tlan tikmonekiltiskiah itech ojtli. ");
INSERT INTO nplNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Satepa de otikatkah eyi mestli itech non isla, otitlejkokeh itech se barko non ompa okichixki mapano n sewaya. Non barko owalewatoka de kan altepetl de Alejandría iwa ik iyakapa okipiaya inmixneskayo de Cástor iwa Pólux. ");
INSERT INTO nplNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Satepa otikalakitoh kan altepetl de Siracusa, iwa ompa otimokajkeh eyi tonati, ");
INSERT INTO nplNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","otlanki otiajkeh itech se barko ik nochi tlátentli iwa otikalakitoh kan altepetl de Regio. Ijkuak owalmostlatik, opé ejeka ik tlatsintlawik, iwa ipan ome tonati otikalakitoh kan altepetl de Puteoli. ");
INSERT INTO nplNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ompa otikinmajsitoh sikimeh tokniwah, yejwah otechtlalwijkeh matimokawakah inwah chikome tonati, satepa otikiskeh iwa otiajkeh Roma. ");
INSERT INTO nplNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ijkuak tokniwah non ochantitokah Roma okimatkeh yotiayah para ompa, owalajkeh otechnamikikoh kan tiánkistli de Apio iwa oksikimeh okachi tlayakapa kan kiliah Tres Tabernas. Iwa ijkuak Pablo okimitak, omotlasojkama inawak Dios iwa omoyolchika. ");
INSERT INTO nplNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ijkuak otikalakitoh Roma, Pablo okikawilijkeh mamokalotiti ixkoya iwa se soldado okimokuitlawijtoka. ");
INSERT INTO nplNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Eyi tonati satepa, Pablo otlatítlanki makinnotsatih akimeh otlayakantokah innawak judíojteh ompa Roma. Iwa ijkuak yomoololojkeh okinmili: —Nokniwah, maya amo onikinmixnamik n tokniwah judíojteh, nion onikinmixpanawi intlanawatilwah totatawah, maya ijkó, yejwah onechtemaktijkeh inmak n tlakah de Roma kan Jerusalén. ");
INSERT INTO nplNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ijkuak onechyolkuitijkeh okinekiah nechkajkawaskeh, porke amitla amokuali okajsikeh kemi para nechmiktiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Pero n judíojteh amo okitekawilijkeh, yika onikmotlajtlanili maniwiki inawak n rey César para ye manechtlajtlakolti, pero ne amo oniwala onikinteiliko nokniwah. ");
INSERT INTO nplNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yika, ne onoméchnotski para nomechitas iwa para nimotlapowis nomowah; porke nikneltoka Cristo Jesús yowala, yika ne axa niikxilpitok ika kadena. ");
INSERT INTO nplNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ijkuakó okilijkeh: —Tejwah mach tikselijtikateh nion se amatlajkuíloli non wits de kan altepetl de Judea matlajtojtiwiki de te, nion aka tokni akin nika wits fiero mitstenewa. ");
INSERT INTO nplNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Pero tiknekih tikkakiskeh tlan te tikijtoa, porke tikmatih sentetl n tlakah fiero tlajtoah de nin yankuik tlamachtílistli. ");
INSERT INTO nplNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ijkó kiné, okitlalijkeh se tonati, iwa miakeh tokniwah omoololojkeh kan Pablo omokalotiaya. Iwa desde kualka asta tiótlaki, Pablo okinmatilti kenijki Dios tlanawatia. Iwa okichiwaya makineltokakah n Jesús ika itlanawatil Moisés iwa ika intlajkuilol n profetas. ");
INSERT INTO nplNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Sikimeh okiselijkeh tlan Pablo okijtoaya, pero oksikimeh mach okineltokakeh. ");
INSERT INTO nplNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Iwa kemi amo nochteh okineltokakeh, opé yajyawih. Ijkuakó Pablo okinmili: —Milák tlan n Espíritu Santo okintlapowi totatawah ika itlajtol n profeta Isaías, ijkuak okijto: ");
INSERT INTO nplNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Xio iwa xikinmili nekateh tlakah: Nomejwah nontlakakiskeh pero mach nonkajsikamatiskeh, iwa maya nontlachiaskeh mach itla nonkitaskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Porke ninteh tlakah oyoltlakuawakeh, iwa mach yektlakakih, iwa ixtsaktokeh, para amo matlachiakah ika inmixtololowah, nion matlakakikah ika innakaswah, nion makimachilikah itech inyolo, nion mamoyolpatlakah nonawak, para manikimpajti. ");
INSERT INTO nplNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Axa xikmatikah, nin itemakixtilis Dios pewas kinmatiltiskeh non amo judíojteh, iwa yejwah kikakiskeh. ");
INSERT INTO nplNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ijkuak Pablo ijkó otlajto, n judíojteh okiskeh iwa oyajkeh mokualanijtiwih. ");
INSERT INTO nplNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pablo omoka ome xiwitl ompa Roma itech se kali kan okitlanejtoka, iwa okinseliaya nochteh akimeh okontlajpaloayah. ");
INSERT INTO nplNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Iwa okintlapowiaya kenijki Dios tlanawatia, iwa okinmachtiaya itlajtol Toteko Cristo Jesús. Amayik opinawaya iwa amaka itla okiliaya.");
INSERT INTO nplNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ne Pablo, niktekitilia n Cristo Jesús. Dios onéchnotski iwa onechpéjpenki maniktematilti n kualitlájtoli de Dios. ");
INSERT INTO nplNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nin kualitlájtoli, yowejka Dios okinkakiti itech itlajkuilol, ijkuak iprofetajwah okijkuilojkeh. ");
INSERT INTO nplNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Nin kualitlájtoli kinextia Cristo Jesús otlákatki kemi tejwah titlakatih, iwa walewatok itech rey David. ");
INSERT INTO nplNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Pero ijkuak omoyoliti de kan kateh non yomikkeh, n Espíritu Santo okinmatilti nochteh Cristo milák Ikone n Totajtsi Dios iwa kipia weletílistli. ");
INSERT INTO nplNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Por Cristo Jesús, Dios onechnextili itlasojtlalis iwa onechtítlanki para maniktetlapowi itlajtol, iwa ijkó nochteh n tlaltikpaktlakah makineltokakah iwa makitlakitakah. ");
INSERT INTO nplNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nomejwah noiwa Dios onoméchnotski para x