﻿USE sofia;
DROP TABLE IF EXISTS sofia.npiulb_vpl;
CREATE TABLE npiulb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES npiulb_vpl WRITE;
INSERT INTO npiulb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","आदिमा परमेश्‍वरले आकाशमण्डल र पृथ्वी सृष्‍टि गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी निराकार र शून्य थियो । समुद्रको सतहमाथि अन्धकार थियो । परमेश्‍वरका आत्मा सारा समुद्रमाथि परिभ्रमण गर्दै हुनुहुन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","परमेश्‍वरले भन्‍नुभयो, “उज्यालो होस्,” र त्यहाँ उज्यालो भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेश्‍वरले उज्यालोलाई हेर्नुभयो, र त्यो असल थियो । उहाँले उज्यालोलाई अन्धकारबाट छुट्‍ट्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्‍वरले उज्यालोलाई “दिन”, र अन्धकारलाई “रात” भन्‍नुभयो । साँझ पर्‍यो र बिहान भयो - पहिलो दिन । ");
INSERT INTO npiulb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","परमेश्‍वरले भन्‍नुभयो, “पानीको बिचमा एउटा क्षेत्र होस्, र त्यसले पानीलाई दुई भागमा विभाजन गरोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","परमेश्‍वरले त्यो क्षेत्र बनाएर त्यसमुनि र माथिको पानीलाई विभाजन गर्नुभयो । तब त्यस्तै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्‍वरले त्यस क्षेत्रलाई “आकाश” भन्‍नुभयो । साँझ पर्‍यो र बिहान भयो - दोस्रो दिन । ");
INSERT INTO npiulb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","परमेश्‍वरले भन्‍नुभयो, “आकाशमुनिको जम्मै पानी एक ठाउँमा जम्मा होस्, र ओभानो जमिन देखा परोस् ।” तब त्यस्तै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्‍वरले ओभानो जमिनलाई “पृथ्वी” भन्‍नुभयो, र जम्मा भएको पानीलाई “समुद्र” भन्‍नुभयो । उहाँले हेर्नुभयो, र त्यो असल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","परमेश्‍वरले भन्‍नुभयो, “पृथ्वीले आ-आफ्नो प्रजातिअनुसारको वनस्पति, बिउ हुने बोट-बिरुवाहरू र फलभित्रै बिउ हुने फल-फलाउने रुखहरू उमारोस् ।” तब त्यस्तै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","पृथ्वीले वनस्पति, आ-आफ्नो प्रजातिअनुसारका बिउ हुने बोट-बिरुवाहरू र आफ्नै फलभित्र बिउ हुने फल-फलाउने रुखहरू उमार्‍यो । परमेश्‍वरले हेर्नुभयो, र त्यो असल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","साँझ पर्‍यो र बिहान भयो - तेस्रो दिन । ");
INSERT INTO npiulb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","परमेश्‍वरले भन्‍नुभयो, “दिनलाई रातबाट अलग गर्नको निम्ति आकाशमा ज्योतिहरू होऊन् र तिनीहरू ऋतुहरू, दिनहरू र वर्षहरूका निम्ति चिन्हहरू होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","पृथ्वीमाथि उज्यालो दिनलाई ती आकाशमा ज्योतिहरू होऊन् ।” तब त्यस्तै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","परमेश्‍वरले दुईवटा विशाल ज्योति बनाउनुभयो, ठुलो ज्योतिचाहिँ दिनमाथि प्रभुत्व गर्न, र सानोचाहिँ रातमाथि प्रभुत्व गर्न । उहाँले ताराहरू पनि बनाउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","पृथ्वीमाथि उज्यालो दिन, दिन र रातमाथि प्रभुत्व गर्न, र उज्यालोलाई अन्धकारबाट अलग गर्न ");
INSERT INTO npiulb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","परमेश्‍वरले ती आकाशमा राख्‍नुभयो । परमेश्‍वरले हेर्नुभयो, र त्यो असल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","साँझ पर्‍यो र बिहान भयो - चौथो दिन । ");
INSERT INTO npiulb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","परमेश्‍वरले भन्‍नुभयो, “पानी ठुलो सङ्ख्‍यामा जीवित प्राणीहरूले भरिऊन्, र पृथ्वीमाथि आकाशमा पक्षीहरू उडून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","परमेश्‍वरले विशाल जलचरहरू, र आ-आफ्नो प्रजातिअनुसारको सबै जीवित प्राणी, चलहल गर्ने र पुरै पानीलाई भर्ने प्राणीहरू, र आ-आफ्नो प्रजातिअनुसारको पखेटा भएका सबै पक्षीहरूलाई सृष्‍टि गर्नुभयो । परमेश्‍वरले हेर्नुभयो, र त्यो असल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्‍वरले तिनीहरूलाई यसो भनेर आशिष् दिनुभयो, “फल्दै-फुल्दै र वृद्धि हुँदै जाओ, र समुद्रमा भरिँदै जाओ । पृथ्वीमा पक्षीहरू वृद्धि होऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","साँझ पर्‍यो र बिहान भयो - पाँचौँ दिन । ");
INSERT INTO npiulb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","परमेश्‍वरले भन्‍नुभयो, “पृथ्वीले आ-आफ्नो प्रजातिअनुसारको जीवित प्राणीहरू, पाल्तु पशुहरू, घस्रने जन्तुहरू, र पृथ्वीका जङ्गली जनावरहरू उत्पन्‍न गरोस् ।” तब त्यस्तै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","परमेश्‍वरले पृथ्वीका जङ्गली जनावरहरू, पाल्तु पशुहरू, जमिनमा घस्रने सबै जन्तुहरूलाई तिनीहरूकै आ-आफ्नै प्रजातिअनुसार बनाउनुभयो । उहाँले हेर्नुभयो, र त्यो असल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","परमेश्‍वरले भन्‍नुभयो, “मानिसलाई हाम्रो स्वरूपमा, हाम्रो प्रतिरूपमा बनाऔँ । तिनीहरूले समुद्रका माछाहरू, आकाशका पक्षीहरू, पाल्तु पशुहरू, सारा पृथ्वी, र पृथ्वीमा घस्रने सबै जन्तुहरूमाथि अधिकार गरून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","परमेश्‍वरले मानिसलाई आफ्नै स्वरूपमा सृष्‍टि गर्नुभयो । उहाँले तिनलाई आफ्नै प्रतिरूपमा सृष्‍टि गर्नुभयो । नर र नारी गरी उहाँले तिनीहरूलाई सृष्‍टि गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्‍वरले तिनीहरूलाई आशिष्‍्‍ दिनुभयो र भन्‍नुभयो,“फल्दै-फुल्दै र वृद्धि हुँदै जाओ । पृथ्वीमा भरिँदै जाओ, र त्यसलाई आफ्नो वशमा राख । समुद्रका माछाहरू, आकाशका पक्षीहरू, र पृथ्वीमा चलहल गर्ने सबै जीवित प्राणीहरूमाथि अधिकार गर ।” ");
INSERT INTO npiulb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","परमेश्‍वरले भन्‍नुभयो, “हेर, मैले पृथ्वीका बिउ हुने हरेक बोट-बिरुवाहरू, र फलभित्रै बिउ हुने हरेक फल-फलाउने रुखहरू तिमीहरूलाई दिएको छु । ती तिमीहरूका निम्ति आहारा हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","पृथ्वीका हरेक जङ्गली जनवारहरू, आकाशका हरेक पक्षीहरू, र सबै घस्रने जन्तुहरू, र जीवन भएका हरेक प्राणीलाई मैले आहाराको निम्ति सबै हरिया बोट-बिरुवाहरू दिएको छु ।” तब त्यस्तै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","परमेश्‍वरले आफूले बनाउनुभएका सबै कुरा हेर्नुभयो । त्यो ज्यादै असल थियो । साँझ पर्‍यो र बिहान भयो - छैटौँ दिन । ");
INSERT INTO npiulb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","सारा आकाशमण्डल र पृथ्वी, र तिनमा भएका सबै जीवित प्राणीहरूको सृष्‍टि पुरा भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","सातौँ दिनसम्ममा परमेश्‍वरले आफूले गर्नुभएको कामलाई पुरा गर्नुभयो ।यसैकारण उहाँले सातौँ दिनमा सबै कामबाट विश्राम लिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","परमेश्‍वरले सातौँ दिनलाई आशिष्‍्‍ दिनुभयो र त्यसलाई पवित्र तुल्याउनुभयो, किनभने आफ्नो सृष्‍टिमा गर्नुभएका सबै कामबाट यसै दिनमा उहाँले विश्राम लिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","परमप्रभु परमेश्‍वरले आकाश र पृथ्वीलाई सृष्‍टि गर्नुभएको समयमा भएका घटनाक्रमहरूको वृत्तान्त यही थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","पृथ्वीको भूमिमा अझै कुनै वनस्पति थिएन, र कुनै बिरुवा पनि उम्रेको थिएन, किनभने परमप्रभु परमेश्‍वरले पृथ्वीमा पानी वर्साउनुभएको थिएन, र भूमिमा खेती गर्नको निम्ति त्यहाँ कुनै मानिस थिएन । ");
INSERT INTO npiulb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","तर पृथ्वीबाट माथि आएको कुइरोले जम्मै भूमिको सतहलाई भिजाउने गर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","परमप्रभु परमेश्‍वरले भूमिको माटोबाट मानिस बनाउनुभयो, र त्यसको नाखबाट जीवनको सास फुकिदिनुभयो, र मानिस जीवित प्राणी भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","परमप्रभु परमेश्‍वरले अदनको पूर्वतिर एउटा बगैँचा लगाउनुभयो, र उहाँले बनाउनुभएको मानिसलाई त्यहीँ राख्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","हेर्नमा राम्रो र खानको निम्ति असल फल भएको सबै रुखलाई परमप्रभु परमेश्‍वरले भूमिबाट उमार्नुभयो । बगैँचाको बिचमा भएको जीवनको रुख, अनि असल र खराबको ज्ञान दिने रुख पनि उहाँले उमार्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बगैँचालाई भिजाउन अदनबाट एउटा नदी निस्केको थियो । त्यहाँबाट त्यो छुट्टिएर चारवटा नदी बनेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिलो नदीको नाम पीशोन हो । यो त्यही नदी हो जुन हवीलाको सारा भूमिमा बग्दछ, जहाँ सुन पाइन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","त्यस भूमिको सुन असल छ । त्यहाँ खोटो र आनिक्स पत्थर पनि छन् । ");
INSERT INTO npiulb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दोस्रो नदीको नाम गीहोन हो । योचाहिँ कूशको सारा भूमिमा बग्दछ । ");
INSERT INTO npiulb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तेस्रो नदीको नाम टाइग्रिस हो, जुन अश्शूरको पूर्वबाट बग्दछ । चौथो नदी यूफ्रेटिस हो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","परमप्रभु परमेश्‍वरले मानिसलाई अदनको बगैँचामा लगी त्यहाँ खेतीपाती गर्न र त्यसको हेरचाह गर्न राख्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","परमप्रभु परमेश्‍वरले यसो भनी आज्ञा गर्नुभयो, “बगैँचाको सबै रुखबाट खान तँलाई स्वतन्‍त्रता छ । ");
INSERT INTO npiulb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","तर असल र खराबको ज्ञान दिने रुखबाट तैँले नखानू, किनभने जुन दिन तैँले त्यो फल खान्छस्, तँ निश्‍चय नै मर्नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","त्यसपछि परमप्रभु परमेश्‍वरले भन्‍नुभयो, “मानिस एकलो रहन असल छैन । म त्यसको लागि एउटा सुहाउने सहयोगी बनाउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","परमप्रभु परमेश्‍वरले भूमिबाट सबै पशुहरू र आकाशका सबै पक्षीहरू बनाउनुभयो । त्यसपछि मानिसले ती सबैलाई के नामले बोलाउँदो रहेछ भनेर उहाँले ती त्यसको अगि ल्याउनुभयो । हरेक जीवित प्राणीलाई मानिसले जे-जे नामले बोलायो, त्यही-त्यही नै हरेकको नाम भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","मानिसले सबै पाल्तु पशु, आकाशका सबै पक्षीहरू, र सबै जङ्गली जनावरहरूलाई नाम दियो । तर मानिसको निम्ति त्यहाँ कुनै सुहाउँदो सहयोगी पाइएन । ");
INSERT INTO npiulb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","परमप्रभु परमेश्‍वरले मानिसलाई गहिरो निद्रामा पार्नुभयो, यसैकारण मानिस निदायो । परमप्रभु परमेश्‍वरले त्यसका करङहरूमध्ये एउटा झिक्‍नुभयो र करङ झिकेको ठाउँमा मासु भरिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","परमप्रभु परमेश्‍वरले मानिसबाट झिक्‍नुभएको करङबाट एउटी स्‍त्री बनाउनुभयो र तिनलाई मानिसकहाँ ल्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","मानिसले भन्यो, “यिनी त मेरा हाडहरूको हाड र मासुको मासु हुन् । यिनलाई ‘नारी’ भनिनेछ, किनभने यिनी नरबाट झिकिएकी थिइन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","त्यसैकारण मानिसले आफ्ना बुबा र आमालाई छोड्नेछ, त्यो आफ्नी पत्‍नीसँग एक हुनेछ, र तिनीहरू एउटै शरीर हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","मानिस र त्यसकी पत्‍नी दुवै नाङ्‍गै थिए, तर तिनीहरू लजाउँदैन थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","परमप्रभु परमेश्‍वरले बनाउनुभएका सबै जङ्गली पशुहरूमध्ये सर्पचाहिँ बढी धूर्त थियो । त्यसले स्‍त्रीलाई भन्यो, “के परमेश्‍वरले साँच्‍चै नै तिमीहरूलाई बगैँचाको कुनै रुखको फल नखानू भनी भन्‍नुभएको छ?” ");
INSERT INTO npiulb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","स्‍त्रीले सर्पलाई भनिन्, “हामीले बगैँचाका रुखहरूका सबै फल खान सक्छौँ, ");
INSERT INTO npiulb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","तर बगैँचाको बिचमा भएको रुखको फलको विषयमा भने, परमेश्‍वरले भन्‍नुभएको छ, ‘तिमीहरूले त्यो नखानू, न त तिमीहरूले त्यो छुनू, नत्रता तिमीहरू मर्नेछौ ।’” ");
INSERT INTO npiulb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","सर्पले स्‍त्रीलाई भन्यो, “निश्‍चय नै तिमीहरू मर्नेछैनौ । ");
INSERT INTO npiulb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","किनभने परमेश्‍वर जान्‍नुहुन्छ, कि जुन दिन तिमीहरू त्यो खान्छौ तिमीहरूका आँखा खुल्नेछन्, र असल र खराबको ज्ञान पाएर तिमीहरू परमेश्‍वरजस्तै हुनेछौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","जब स्‍त्रीले त्यो रुखको फल खानमा असल, र हेर्नमा रहरलाग्दो, अनि बुद्धि प्राप्‍त गर्नलाई त्यसको चाह गर्नुपर्ने रहेछ भनेर देखिन्, तिनले त्यसका केही फलहरू टिपिन् र खाइन् । त्यसपछि तिनले केही आफूसँगै भएका आफ्ना पतिलाई पनि दिइन्, र उनले पनि त्यो खाए । ");
INSERT INTO npiulb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब तिनीहरू दुवैका आँखा खुले, र तिनीहरू नाङ्‍गै रहेछन् भनेर थाहा पाए । तिनीहरूले अञ्‍जीरका पातहरू गाँसेर आफ्ना निम्ति वस्‍त्र बनाए । ");
INSERT INTO npiulb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","अनि साँझपख जब तिनीहरूले परमप्रभु परमेश्‍वर बगैँचामा हिँडिरहनुभएको आवाज सुने, तब मानिस र उनकी पत्‍नी बगैँचाका रुखहरूबिच परमप्रभु परमेश्‍वरको नजरबाट लुके। ");
INSERT INTO npiulb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","परमप्रभु परमेश्‍वरले मानिसलाई बोलाउनुभयो, “तँ कहाँ छस्?” ");
INSERT INTO npiulb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","मानिसले भन्यो, “मैले बगैँचामा तपाईंको आवाज सुनेँ, र म डराएँ किनकि म नाङ्‍गै थिएँ । यसैकारण म लुकेँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","परमेश्‍वरले भन्‍नुभयो, “तँ नाङ्‍गै थिइस् भनेर तँलाई कसले भन्यो ? के मैले तँलाई नखानू भनेर आज्ञा गरेको रुखको फल तैँले खाइस् ?” ");
INSERT INTO npiulb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","मानिसले भन्यो, “तपाईंले मसँगै रहनलाई दिनुभएको स्‍त्रीले मलाई त्यस रुखको फल दिई, र मैले त्यो खाएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","परमप्रभु परमेश्‍वरले स्‍त्रीलाई भन्‍नुभयो, “तैँले यो के गरिस्?” स्‍त्रीले भनिन्, “सर्पले मलाई छल गर्‍यो, र मैले खाएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","परमप्रभु परमेश्‍वरले सर्पलाई भन्‍नुभयो, “तैँले यसो गरेको हुनाले सबै पाल्तु पशुहरू र जङ्गली जनावरहरूमा केवल तँ श्रापित हुनेछस् । तँ तेरो पेटद्वारा हिँड्नेछस्, र तेरो जीवनभरि नै तैँले माटो खानेछस् । ");
INSERT INTO npiulb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","तेरो र स्‍त्रीबिच, अनि तेरो सन्तान र स्‍त्रीको सन्तानबिच म दुश्मनी हालिदिनेछु । त्यसले तेरो शिर कुल्चनेछ, र तैँले त्यसको कुर्कुच्‍चा डस्‍नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","उहाँले स्‍त्रीलाई भन्‍नुभयो, “म तेरो प्रसव-वेदना ज्यादै बढाइदिनेछु; तैँले पीडामा नै बालक जन्माउनेछस् । तेरो इच्छा तेरो पतिको लागि हुनेछ, तर त्यसले तँलाई आफ्नो अधीनमा राख्‍नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","आदमलाई उहाँले भन्‍नुभयो, “तैँले तेरी पत्‍नीको कुरा सुनेको, र मैले तँलाई नखानू भनेको रुखको फल तैँले खाएको हुनाले, तेरो कारण यो भूमि श्रापित भएको छ । तेरो जीवनभरि नै तैँले यस भूमिमाथि कडा परिश्रम गरेर खानेछस् । ");
INSERT INTO npiulb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","त्यसले तेरो निम्ति काँढा र सिउँडीहरू उमार्नेछ, र तैँले खेतका बिरुवाहरू खानेछस् । ");
INSERT INTO npiulb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तँ माटोमा नफर्कुन्जेल, तैँले आफ्नो परिश्रमको पसिना बगाएर भोजन खानेछस्, किनकि तँ माटैबाट निकालिएको थिइस् । तँ माटै होस्, र माटोमा नै फर्किजानेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","मानिसले आफ्नी पत्‍नीको नाम हव्‍वा राख्‍यो किनकि तिनी सबै जीवित प्राणीकी आमा हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","परमप्रभु परमेश्‍वरले आदम र उनकी पत्‍नीका निम्ति छालाका लुगा बनाई तिनीहरूलाई पहिराइदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","परमप्रभु परमेश्‍वरले भन्‍नुभयो, “असल र खराबको ज्ञान पाएर मानिस हामीजस्तै भएको छ । यसैकारण अब त्यसलाई आफ्नो हात पसारेर जीवनको रुखको फल खान दिनुहुँदैन नत्रता त्यो सधैँभरि जीवित रहला ।” ");
INSERT INTO npiulb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","त्यसैकारण जुन भूमिबाट त्यो निकालिएको थियो त्यही भूमिमा खेतीपाती गर्न परमप्रभु परमेश्‍वरले त्यसलाई अदनको बगैँचाबाट निकालिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","परमेश्‍वरले मानिसलाई बगैँचाबाट निकालिदिनुभएपछि जीवनको रुखतर्फको मार्गमा पहरा दिन उहाँले अदनको बगैँचाको पूर्वमा करूबहरू र चारैदिशातर्फ घुमिरहने ज्वालामय तरवार राखिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","मानिसलेआफ्नी पत्‍नीसित सहवास गरे । अनि तिनी गर्भवती भइन् र कयिनलाई जन्माइन् । तिनले भनिन्, “मैले परमप्रभुको सहायताले एक पुरुष जन्माएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","अनि तिनले तिनको भाइ हाबिललाई जन्माइन् । हाबिल गोठालो भए, तर कयिन खेती गर्ने भए । ");
INSERT INTO npiulb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","समय बित्दै जाँदा कयिनले तिनको जमिनको उब्जनीबाट केही परमप्रभुकहाँ भेटीको रूपमा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबिलको हकमा तिनले बगालका पहिले जन्मेकाहरू र केही बोसे भागहरू ल्याए । परमप्रभुले हाबिल र तिनका भेटीलाई ग्रहण गर्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","तर कयिन र तिनका भेटीहरूलाई उहाँले ग्रहण गर्नुभएन । यसैले कयिन साह्रै रिसाए र तिनले रिस देखाए । ");
INSERT INTO npiulb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","परमप्रभुले कयिनलाई भन्‍नुभयो, “तँ किन रिसाउँछस् र तैँले किन रिस देखाउँछस् ? ");
INSERT INTO npiulb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","यदि तैँले जे ठीक छ सो गरिस् भने, के तँलाई ग्रहण गरिनेछैन र? तर यदि तैले जे ठीक छ सो गर्दैनस भने त पाप तेरो ढोकैमा ढुक्छ र तँलाई अधिन गर्न इच्छा गर्छ, तर तैँले अधिन गर्नैपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","कयिनले आफ्ना भाइ हाबिललाई भने । अनि तिनीहरू खेतमा हुँदा कयिननले आफ्‍ना भाइ हाबिलमाथि आक्रमण गरे र तिनलाई मारे । ");
INSERT INTO npiulb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","अनि परमप्रभुले कयिनलाई भन्‍नुभयो, “तेरो भाइ हाबिल कहाँ छ?” तिनले भने, “मलाई थाहा छैन । के म मेरो भाइको गोठालो हुँ र?” ");
INSERT INTO npiulb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","परमप्रभुले भन्‍नुभयो, “तैँले यो के गरिस्? तेरो भाइको रगतले जमिनबाट मलाई पुकारिरहेको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","अब तँ जमिबाट श्रापित हुन्छस् जसले तेरो हातबाट बगेको तेरो भाइको रगत ग्रहण गर्न मुख उघारेको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","आज उप्रान्त तैँले खेती गर्दा यसले यसको सामर्थ्य (फल) दिनेछैन । तँ भगुवा र आवारा हुनेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","कयिनले परमप्रभुलाई भने, “मेरो दण्ड मैले सहन सक्‍नेभन्दा धेरै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","वास्तवमा, आज तपाईंले मलाई यस जग्‍गाबाट धपाउनुभएको छ र म तपाईंको नजरबाट लुक्‍नेछु । म पृथ्वीमा भगुवा र आवारा हुनेछु र जसले भेट्टाउँछ त्यसले मलाई मार्नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","परमप्रभुले तिनलाई भन्‍नुभयो, “यदि कसैले कयिनलाई मार्छ भने, त्यसमाथि सात गुणा बदला लिइनेछ ।” अनि परमप्रभुले कयिनमाथि चिन्ह लगाउनुभयो, ताकि तिनलाई जसले भेट्टाए पनि आक्रमण नगरोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","यसैले कयिन परमप्रभुको उपस्थितिबाट गए र अदनको पूर्वतिर नोदको मुलुकमा बसोवास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","कयिनले आफ्नी पत्‍नीसँग सहवास गरे, र तिनी गर्भवती भइन् । तिनले हनोकलाई जन्माइन् । तिनले एउटा सहर बनाए, र यसको नाउँ आफ्नो छोराकै नाउँमा राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोकबाट ईराद जन्मिए । ईराद महूयाएलका पिता बने । महूयाएल मतुशाएलका पिता बने । मतुशाएल लेमेखका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेखले दुइ जना पत्‍नीहरू ल्याए । एउटीको नाउँ आदा र अर्कीको नाउँ सिल्ला थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाले याबाललाई जन्माइन् । तिनी पालमा बस्‍नेहरू र पशु पालन गर्नेहरूका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","तिनको भाइको नाउँ यूबाल थियो । तिनी वीणा र बाँसुरी बजाउनेहरूका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्लाको हकमा, तिनले तुबल-कयिन अर्थात् काँसो र फलामका काम गर्नेहरूलाई जन्माइन् । तुबल-कयिनकी बहिनी नामा थिइन् । लेमेखले तिनकी पत्‍नीहरूलाई भने, “ ");
INSERT INTO npiulb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेखका पत्‍नीहरू आदा र सिल्ला मेरो कुरा सुन; मैले जे भन्छु सो सुन । मलाई चोट पुर्‍याउने मनिसलाई अर्थात् मलाई घायल बनाउने जवानलाई मैले मारेको छु । ");
INSERT INTO npiulb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","यदि कयिनको बदला सात गुणा लिइन्छ भने लेमेखको बदला सतहत्तर गुणा लिइनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदमले तिनको पत्‍नीसँग फेरि सहवास गरे र तिनले अर्को छोरा जन्माइन् । तिनले त्यसको नाउँ शेत राखिन् र भनिन्, “कयिनले मारेका हाबिलको सट्टामा परमेश्‍वरले मलाई अर्को छोरा दिनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेतको एउटा छोरा भयो तिनले तिनको नाउँ एनोश राखे । त्यस बेलादेखि मानसिहरूले परमेश्‍वरको नाउँ पुकार्न सुरु गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदमका सन्तानहरूका विवरण यही हो । परमेश्‍वरले मानिसलाई सृष्‍टि गर्नुहुँदा उहाँले तिनलाई आफ्नै स्वरूपमा सृष्‍टि गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","उहाँले तिनीहरूलाई नर र नारी सृष्‍टि गर्नुभयो । उहाँले तिनीहरूलाई सृष्‍टि गर्नु हुँदा, तिनीहरूलाई आशिष् दिनुभयो र तिनीहरूलाई मानवजाति नाउँ दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदम १३० वर्षको हुँदा तिनी आफ्‍नै स्वरूपमा जन्मेका छोरोको बुबा भए, र तिनले उनको नाउँ शेत राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","आदम शेतको बुबा भएपछि, तिनी आठ सय वर्ष बाँचे । तिनी अझ अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","आदम ९३० वर्ष बाँचे अनि तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेत १०५ वर्षको हुँदा तिनी एनोशको बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","तिनी एनोशको बुबा भएपछि, तिनी ८०७ वर्ष बाँचे र अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","शेत ९१२ वर्ष बाँचे र तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","एनोश ९० वर्षको हुँदा, तिनी केनानका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","तिनी केनानको बुबा भएपछि, एनोश ८१५ वर्ष बाँचे । तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","एनोश ९०५ वर्ष बाँचे र तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान ७० वर्षको हुँदा, तिनी महलालेलको बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","तिनी महलालेलका बुबा भएपछि, केनान ८४० वर्ष बाँचे । तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","केनान ९१० वर्ष बाँचे र तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महलालेल ६५ वर्षको हुँदा, तिनी येरेदको बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","तिनी येरेदका बुबा भएपछि, तिनी ८३० वर्ष बाँचे । तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","महलालेल ८९५ वर्ष बाँचे र तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","येरेद १६२ वर्षको हुँदा, तिनी हनोकका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","तिनी हनोकको बुबा भएपछि येरेद ८०० वर्ष बाँचे । तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","येरेद ९६२ बाँचे र तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोक ६५ वर्षको हुँदा, तिनी मतूशेलहको बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","हनोक मतूशेलहको बुबा भएपछि तिनी ३०० वर्षसम्म परमेश्‍वरसँगै हिँडे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्‍वरसँगै हिँडे, र तिनी गए, किनकि परमेश्‍वरले तिनलाई लानुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मतूशेलह १८७ वर्षको हुँदा, तिनी लेमेकको बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","तिनी लेमेकको बुबा भएपछि, मतूशेलह ७८२ वर्ष बाँचे । तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मतूशेलह ९६९ वर्ष बाँचे अनि तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लेमेक १८२ वर्षको हुँदा, तिनी एउटा छोरोको बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","तिनले उनलाई यसो भन्दै नोआ नाउँ राखे, “यसले हामीलाई हाम्रा काम र हाम्रा हातका पिडादायी श्रमबाट विश्राम दिनेछ, जुन परमप्रभुले जमिनलाई सराप दिनुभएको कारण हामीले गर्नैपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","लेमेक नोआको बुबा भएपछि ५९५ वर्ष बाँचे । तिनी अरू धेरै छोराहरू र छोरीहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लेमेक ७७७ वर्ष बाँचे, अनि तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोआ ५०० वर्ष बाँचेपछि, तिनी शेम, हाम र येपेतका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","मानिसहरूको संख्या पृथ्वीमा वृद्धि हुँदैजाँदा र तिनीहरूका छोरीहरू जन्‍मे, ");
INSERT INTO npiulb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","परमेश्‍वरका छोराहरूले मानव-जातिका छोरीहरूलाई आकर्षक (राम्री) देखे । तिनीहरूले तिनीहरूमध्ये कसैलाई आफैले चुनेको पत्‍नी ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","परमप्रभुले भन्‍नुभयो, “मेरो आत्मा मानव-जातिमा सदासर्वदा रहनेछैन, किनभने तिनीहरू शरीर हुन् । तिनीहरू १२० वर्ष बाँच्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ती दिनहरूमा र पछि पनि पृथ्वीमा ठुला कदका मानिसहरू (राक्षस) थिए । जब परमेश्‍वरका छोराहरूले मानिसका छोरीहरूसँग विवाह गरे, तिनीहरूका छोराछोरीहरू जन्मे । यिनीहरू उहिलेका शक्तिशाली अर्थात् प्रख्यात मानिसहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","पृथ्वीका मानिसहरूको दुष्‍टता बढी भएको र तिनीहरूका हृदयका विचारको हरेक भावना निरन्तर खराबै मात्र भएको परमप्रभुले देख्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","पृथ्वीमा मानव-जातिलाई बनाउनुभएकोमा परमप्रभुले पछुतो मान्‍नुभयो, र यसले उहाँलाई दुःखित तुल्यायो । ");
INSERT INTO npiulb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","यसैले परमप्रभुले भन्‍नुभयो, “मैले सृष्‍टि गरेका मानव-जातिलाई पृथ्वीको सतहबाट नामेट पार्नेछु; मानव-जाति र ठुला-ठुला जनावरहरू, घस्रने जन्तुहरू र आकाशमा उड्ने पक्षीहरू सबैलाई नमाेट पार्नेछु, किनकि तिनीहरूलाई बनाएकोमा म दुःखित छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","तर नोआले परमप्रभुको निगाह पाए । ");
INSERT INTO npiulb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","यिनीहरू नोआ बारेका घटनाहरू थिए । नोआ तिनका समयमा मानिसहरूमा धर्मी र दोषरहित मानिस थिए । नोआ परमेश्‍वरसँग हिँडे । ");
INSERT INTO npiulb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नोआ शेम, हाम र येपेत तिन छोराहरूका बुबा भए । ");
INSERT INTO npiulb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","परमेश्‍वरको दृष्‍टिमा पृथ्वी भ्रष्‍ट भएको र हिंसाले भरिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","परमेश्‍वरले पृथ्वीलाई देख्‍नुभयो; हेर, यो त भ्रष्‍ट थियो, किनकि पृथ्वीका सबै मानिसहरूका मार्ग भ्रष्‍ट भएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","परमेश्‍वरले नोआलाई भन्‍नुभयो, “यो सबै प्राणीको अन्त गर्ने समय आएको म देख्‍न सक्छु, किनभने पृथ्वी तिनीहरूको हिंसाले भरिएको छ । वास्तवमा, मैले तिनीहरूलाई पृथ्वीसँगै नष्‍ट पार्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","तैँले आफ्नो निम्ति गोपेर काठको एउटा जहाज बनाउनू । जहाजभित्र कोठाहरू बनाउनू र त्यसलाई भित्र-बाहिर अलकत्र लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","तैँले यसलाई यसरी बनाउनुः यसको लम्बाइ एक सय चालिस मिटर, चौडाइ तेईस मिटर र यसको उच्‍चाइ चौध मिटरको होस् । ");
INSERT INTO npiulb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जहाजको छानो बनाउनू र यसलाई टुप्पोमा एक पट्टी एक हात छोडेर सिद्ध्याउनू । जहाजको एकपट्टी ढोका राख्‍नू र पहिलो, दोस्रो र तेस्रो तला बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","सुन, जीवनको सास हुने आकाशमुनिका सबै प्राणीलाई सर्वनाश पार्न मैले पृथ्वीमा जलप्रलय ल्याउन लागेको छु । पृथ्वीमा भएको सबै प्राणी मर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","तर तँसँग म मेरो करार स्थापित गर्नेछु । तँ, तेरा छोराहरू, तेरी पत्‍नी र तेरा छोराहरूका पत्‍नीहरू जहाजभित्र आउनेछौ । ");
INSERT INTO npiulb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","हरेक जीवित प्रणीमध्ये ठुला जनावरहरू र ");
INSERT INTO npiulb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","पृथ्वीमाथि घस्रने जन्‍तुहरूलाई जीवित राख्‍न भाले र पोथी गरी दुइ-दुइ वटा जहाजभित्र ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","खानलाई र भण्डरण गर्नलाई सबै किसिमका खानेकुराहरू जम्‍मा गर्नू, जुन तेरो र तिनीहरूका निम्‍ति आहारा हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","यसैले नोआले यो गरे । तिनले परमेश्‍वरले आज्ञा गर्नुभएबमोजिम गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","परमप्रभुले नोआलाई भन्‍नुभयो, “तँ र तेरा सबै जहान जहाजभित्र आओ । किनकि मेरो सामु यो पुस्तामा मैले तँलाई धर्मी देखेको छु । ");
INSERT INTO npiulb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","हरेक जातका शुद्ध पशुबाट तैँले आफूसित सात भाले र सात पोथी ल्याउनू । अशुद्ध पशुहरूबाट चाहिँ तैँले दुईवटा अर्थात् भाले र पोथी ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अनि आकाशका पक्षीहरूबाट तिनीहरूको जातिलाई पृथ्वीको सतहमा जीवित राख्‍न सात जोडी भाले र पोथी ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","किनकि अबको सात दिनमा म चालिस दिन र चालिस रात पृथ्‍वीमा पानी बर्साउनेछु । मैले बनाएको हरेक जीवित प्राणीलाई म पृथ्वीको सतहबाट नष्‍ट गर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","परमप्रभुले आज्ञा गर्नुभएझैँ नोआले सबै गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","पृथ्वीमा जलप्रलय हुँदा नोआ छ सय वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","जलप्रलयको पानीको कारणले नोआ, तिनका छोराहरू, तिनकी पत्‍नी र तिनका बुहारीहरू सँगसँगै जहाजभित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुद्ध र अशुद्ध पशुहरू, पक्षीहरू र भुइँमा घस्रने हरेक प्राणी, परमेश्‍वरले नोआलाई आज्ञा गर्नुभएझैँ ");
INSERT INTO npiulb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","भाले र पोथी गरी जोडी-जोडी नोआकहाँ आए र जहाजभित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","सात दिनपछि पृथ्वीमा जलप्रलयको पानी पर्न लाग्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोआको जीवनको छ सय वर्षको दोस्रो महिनाको सत्रौँ दिनमा विशाल अगाधका मूलहरू फुटे र आकाशका झ्यालहरू खुले । ");
INSERT INTO npiulb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","चालिस दिन र चालिस रातसम्म पृथ्वीमा पानी परिरह्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","त्यही दिनमा नोआ, तिनका छोराहरू शेम, हाम र येपेत अनि तिनकी पत्‍नी र तिनका तिन जना बुहारी जहाजभित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","हरेक जङ्गली जनावरको जात-जातअनुसार, हरेक पाल्तु पशुको जात-जातअनुसार, भुइँमा घस्रने हरेक घस्रने जन्तुको जात-जातअनुसार र पखेटा भएको हरेक पक्षीको जात-जातअनुसार सँगसँगै तिनीहरू जहाजभित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","जीवनको सास हुने सबै प्राणीका जोडी-जोडी नोआकहाँ आएर जहाजभित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","भित्र प्रवेश गरेका प्राणीहरू सबैका भाले र पोथी थिए । परमेश्‍वरले आज्ञा दिनुभएझैँ तिनीहरू भित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","त्यसपछि परमप्रभुले ढोका बन्द गरिदिनुभयो । अनि पृथ्वीमा चालिस दिनसम्म जलप्रलय भयो र पानीले जहाजलाई जमिनबाट माथि उचाल्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानीले सारा पृथ्वीलाई पूर्ण रूपमा ढाक्यो अनि जहाज पानीको सतहमाथि तैरियो । ");
INSERT INTO npiulb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","आकाशमुनिका सबै अग्‍ला-अग्‍ला पर्वतहरूलाई ढाक्‍ने गरी पृथ्वीमा पानी चौपट्टै भरियो । ");
INSERT INTO npiulb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी पर्वतहरूको टुप्पोमा सात मिटर माथिसम्म आयो । ");
INSERT INTO npiulb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पक्षीहरू, पालिने पशुहरू, जङ्गली जनावरहरू, जमिनमा ठुलो सङ्ख्यामा बसोबास गर्ने सबै प्राणी र सबै मानव-जाति जो पृथ्वीमा चलहल गर्थे, ती सबै मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","जमिनमा बस्‍ने सबै जीवित प्राणी जसले आ-आफ्ना नाकबाट जीवनको सास फेर्थे, ती सबै मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","यसरी, मानव-जातिदेखि ठुला जनावरहरू र घस्रने जन्तुसम्म पृथ्वीको सतहमा भएको हरेक प्राणीसाथै आकाशका चराचुरुङ्गीहरू मासिए । तिनीहरू सबै नै पृथ्वीबाट नष्‍ट गरिए । नोआ र तिनीसित जहाजमा हुनेहरू मात्र बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","एक सय पचास दिनसम्म पृथ्वीमा पानी घटेन । ");
INSERT INTO npiulb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","परमेश्‍वरले नोआ, तिनीसित जहाजमा भएका सबै जङ्गली पशुहरू र सबै पालिने पशुहरूलाई सम्झनुभयो । परमेश्‍वरले पृथ्वीमा बतास चलाइदिनुभयो, र पानी घट्न थाल्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","अगाधका मूलहरू र स्वर्गका झ्यालहरू बन्द गरिए, अनि पानी पर्न रोकियो । ");
INSERT INTO npiulb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","जलप्रलयको पानी पृथ्वीमा बिस्तारै घट्यो, र एक सय पचास दिनपछि पानी निकै घट्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","सातौँ महिनाको सत्रौँ दिनमा जहाज आरारातका पर्वतहरूमा अडियो । ");
INSERT INTO npiulb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","दसौँ महिनासम्म पानी निरन्तर घटिरह्‍यो । त्यही महिनाको पहिलो दिनमा पर्वतहरूका टाकुराहरू देखा परे । ");
INSERT INTO npiulb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","चालिस दिनपछि नोआले आफूले बनाएको जहाजको झ्याल खोले । ");
INSERT INTO npiulb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","तिनले एउटा कागलाई उडाइदिए र जमिनको पानी नसुकुञ्‍जेलसम्म त्यो यताउता उडिरह्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","त्यसपछि जमिनको सतहबाट पानी घटेको छ कि छैन भनेर हेर्न तिनले एउटा ढुकुरलाई पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","तर ढुकुरले आफ्नो खुट्टा राख्‍ने ठाउँ कतै पाएन, र त्यो जहाजमा नै तिनीकहाँ फर्क्यो किनकि पानीले अझै पनि पुरै जमिनलाई ढाकिरहेको थियो । तिनले आफ्नो हात पसारेर त्यसलाई समाती जहाजभित्र ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","अरू सात दिन पर्खेर तिनले फेरि जहाजबाट त्यस ढुकुरलाई पठाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","साँझमा त्यो ढुकुर तिनीकहाँ फर्क्यो । हेर! त्यसको चुच्‍चोमा भर्खरै टिपिएको ताजा भद्राक्षको पात थियो । त्यसैले, पानी जमिनबाट घटेछ भनी नोआले थाहा पाए । ");
INSERT INTO npiulb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","अरू सात दिन पर्खेर तिनले फेरि त्यस ढुकुरलाई पठाइदिए । त्यो फेरि फर्केर तिनीकहाँ आएन । ");
INSERT INTO npiulb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोआको छ सय एक वर्षको पहिलो महिनाको पहिलो दिनमा जमिनबाट पानी सुक्यो । नोआले जहाजको छत खोलेर बाहिर हेरे र तिनको सुक्खा भूमि देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दोस्रो महिनाको सत्ताइसौँ दिनमा जमिन सुक्खा भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","परमेश्‍वरले नोआलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तँ, तेरी पत्‍नी, तेरा छोराहरू र तेरा बुहारीहरू जहाजबाट निस्केर आओ । ");
INSERT INTO npiulb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","तँसित भएका सबै जीवित प्राणीहरू अर्थात् पक्षीहरू, पशुहरू, पृथ्वीको सतहमा हरेक घस्रने प्राणीलाई तँसँगै बाहिर लिएर आइज ताकि तिनीहरू पृथ्वीमा पशस्त मात्रामा फल्दै-फुल्दै, वृद्धि हुँदै र भरिँदै जाऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","त्यसैले नोआ आफ्ना छोराहरू, आफ्नी पत्‍नी र आफ्ना बुहारीहरूसँगै बाहिर निस्के । ");
INSERT INTO npiulb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","हरेक जीवित प्राणी, हरेक घस्रने जन्तु, हरेक पक्षी र पृथ्वीमा चलहल गर्ने हरेक प्राणी तिनीहरूका आ-आफ्ना जात-जातअनुसार जहाजबाट बाहिर निस्के । ");
INSERT INTO npiulb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","नोआले परमप्रभुको निम्ति एउटा वेदी बनाए । तिनले शुद्ध पशुहरू र शुद्ध पक्षीहरूमध्ये केहीलाई लिई वेदीमा होमबलि चढाए । ");
INSERT INTO npiulb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","परमप्रभुले यसको सुगन्ध लिनुभएपछि आफ्नो मनमा भन्‍नुभयो, “मानव-जातिको ह्रदयको मनसाय बाल्यावस्थादेखि नै दुष्‍ट हुने भए तापनि म उसको कारणले गर्दा फेरि भूमिलाई श्राप दिनेछैनँ, न त मैले अहिले गरेजस्तै फेरि हरेक जीवित प्राणीलाई सर्वनाश गर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","पृथ्वी रहुञ्‍जेलसम्म बिउ छर्ने र कटनी गर्ने समय, जाडो र गर्मी, ग्रीष्‍म र हिउँद अनि दिन र रातको अन्त्य हुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","त्यसपछि परमेश्‍वरले नोआ र तिनका छोराहरूलाई आशिष् दिनुभयो र भन्‍नुभयो, “फल्‍दै-फुल्दै, वृद्धि हुँदै र पृथ्वीमा भरिँदै जाओ । ");
INSERT INTO npiulb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","जमिनमा चलहल गर्ने हरेक जीवित प्राणी, आकाशका हरेक पक्षी, जमिनमा घस्रने हरेक जन्तु र समुद्रका सबै माछामाथि तिमीहरूको डर र त्रास रहनेछ । ती तिमीहरूका हातमा सुम्पिएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","हरेक चलहल गर्ने प्राणी तिमीहरूका निम्ति भोजन हुनेछन् । मैले तिमीहरूलाई हरिया वनस्पतिहरू दिएजस्तै अब म तिमीहरूलाई सबै थोक दिन्छु । ");
INSERT INTO npiulb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","तर तिमीहरूले मासु त्यसको प्राण दिने रगतसमेत नखाओ । ");
INSERT INTO npiulb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","तर तिमीहरूको प्राण दिने रगतको साटो म लेखा लिनेछु । हरेक पशुबाट म प्राणको साटो लिनेछु । आफ्नो भाइको हत्या गर्ने हरेक मानिसको हातबाट म त्यस मानिसको प्राणको साटो लिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","जसले मानिसको रगत बगाउँछ मानिसद्वारा नै त्यसको रगत बगाइनेछ, किनकि परमेश्‍वरले मानिसलाई आफ्नै स्वरूपमा बनाउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","तिमीहरूचाहिँ पृथ्वीमा फल्दै-फुल्दै, वृद्धि हुँदै, फैलँदै जाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","त्यसपछि परमेश्‍वरले नोआ र तिनका छोराहरूलाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“मेरो कुरा सुन! तिमीहरू र तिमीहरूपछि आउने तिमीहरूका सन्तानहरू, तिमीहरूसँगै भएका हरेक जीवित प्राणी अर्थात् ");
INSERT INTO npiulb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","पक्षीहरू, पालिने पशुहरू र जहाजबाट बाहिर आउनेदेखि पृथ्वीमा भएका हरेक जीवित प्राणीसित म मेरो करार स्थापित गर्दै छु । ");
INSERT INTO npiulb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","जलप्रलयको पानीद्वारा फेरि सबै प्राणी नष्‍ट गरिनेछैनन् भनी म मेरो करार तिमीहरूसित स्थापित गर्दछु । पृथ्वीलाई सर्वनाश गर्ने जलप्रलय फेरि कहिल्यै आउनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","परमेश्‍वरले भन्‍नुभयो, “पुस्तौँको निम्ति मेरो र तिमीहरूसाथै हरेक जीवित प्राणीसित मैले जुन करार बाँध्दै छु, त्यसको चिन्ह यही हुन्छ ");
INSERT INTO npiulb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","कि मैले बादलमा इन्द्रेणी राखेको छु, र यो मेरो र पृथ्वीको बिचमा करारको चिन्ह हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","मैले पृथ्वीमाथि बादल फिँजाउँदा जब इन्द्रेणी देखा पर्छ ");
INSERT INTO npiulb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तब म मेरो करारलाई सम्झनेछु जुन करार मेरो र तिमीहरूसाथै हरेक जीवित प्राणीको बिचमा बाँधिएको छ । जलप्रलयले फेरि कहिल्यै सबै प्राणीलाई सर्वनाश गर्नेछैन । ");
INSERT INTO npiulb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","परमेश्‍वर र पृथ्वीमा रहेका सबै जीवित प्राणीबिच बाँधिएको नित्य रहिरहने कराको सम्झना गर्नलाई म बादलमा देखा पर्ने इन्द्रेणीलाई हेर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","तब परमेश्‍वरले नोआलाई भन्‍नुभयो, “मेरो र पृथ्वीमा भएका सबै जीवित प्राणीको बिचमा मैले स्थापित गरेको करारको चिन्ह यही हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","जहाजबाट बाहिर निस्केर आएका नोआका छोराहरू शेम, हाम र येपेत थिए । हाम कनानका पिता थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","यी तिन जना नोआका छोराहरू थिए, र यिनीहरूबाट नै समस्त पृथ्वी भरियो । ");
INSERT INTO npiulb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोआ किसान हुन लागे, र तिनले दाखबारी लगाए । ");
INSERT INTO npiulb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","दाखमद्य पिएर तिनी मात्तिए । तिनी आफ्नो पालमा नाङ्गै पल्टिरहेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","तब कनानका पिता हामले आफ्ना पिताको नाङ्गोपन देखे र बाहिर आएर दुवै दाजुलाई बताइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","त्यसैले, शेम र येपेतले एउटा लबेदा लिएर त्यसलाई काँधमा हाले अनि पछिल्तिर सर्दै गएर तिनीहरूका पिताको नाङ्गोपन ढाकिदिए । तिनीहरूको अनुहार अर्कोपट्टि फर्केकाले तिनीहरूले आफ्ना पिताको नाङ्गोपन देखेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","नोआ आफ्नो मद्यको लतबाट उठेपछि तिनका कान्छा छोराले तिनलाई के गरेका थिए भनी तिनलाई थाहा भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","त्यसैले तिनले भने, “श्रापित होस् कनान । त्यो आफ्ना दाजुहरूका कमाराहरूका पनि कमारा होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","तिनले यसो पनि भने, “शेमका परमेश्‍वर यहोवे धन्यका होऊन्, र कनान त्यसको कमारो होस् । ");
INSERT INTO npiulb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्‍वरले येपेतको क्षेत्र वृद्धि गर्नुभएको होस् र त्यसले शेमका पालहरूमा बास गरून् । कनान त्यसका कमारा होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जलप्रलयपछि नोआ तिन सय पचास वर्ष बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","नोआको जम्मा उमेर नौ सय पचास वर्ष भयो, अनि तिनी मरे ");
INSERT INTO npiulb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","यिनीहरू नोआका सन्तानहरू थिए, अर्थात्, शेम, हाम, र येपेत । जलप्रलयपछि तिनीहरूका छोराहरू जन्मे । ");
INSERT INTO npiulb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","गोमेर, मागोग, मादे, यावान, तूबल, मेशेक र तीरास येपेतका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","अशकनज, रीपत र तोगर्मा गोमेरका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","एलीशाह, तर्शीश, कित्तीम र रोदानीम यावानका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","यिनीहरूबाट नै समुद्रतटवासी छुट्टिए र तिनीहरू आफ्‍नो जातिअनुरूप आ-आफ्‍नो भाषाअनुसार तिनीहरूको भूमितिर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","कूश, मिश्रइम, पूत र कनान हामका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","सेबा, हवीला, सब्ता, रामाह र सब्तका कूशका छोराहरू थिए । शेबा र ददान रामाहका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश निम्रोदका पिता बने, जो पृथ्वीमाथिका पहिलो विजेता थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","तिनी परमप्रभुको सामु शक्तिशाली शिकारी बने । त्यसैले यसो भनियो, “परमप्रभुको सामु निम्रोदजस्तै शक्‍तिशाली सिकारी ।” ");
INSERT INTO npiulb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","तिनका राज्यहरूका सुरुका केन्द्रहरू शिनारको मुलुकका बाबेल, अक्‍कद र कल्नेह थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","तिनी त्यो भूमिबाट बाहिर अश्शूरतित गए, र निनवे, रहोबोत-इर, कालह, ");
INSERT INTO npiulb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","र निनवे र कालह बिचमा पर्ने रेसेन निर्माण गरे । यो एउटा ठुलो सहर थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिश्रइम लूदी, अनामी, लहाबी, नप्‍तूही ");
INSERT INTO npiulb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पत्रुसी, कस्लूही (जसबाट पलिश्तीहरू आए) र कप्‍तोरीहरूका पुर्खा बने । ");
INSERT INTO npiulb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान सीदोन अर्थात् तिनका जेठो छोरो, हित्ती, ");
INSERT INTO npiulb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, एमोरी, ");
INSERT INTO npiulb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","गिर्गाशी, हिव्वी, अरकी, सिनी, ");
INSERT INTO npiulb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, समारी र हमातीहरूका पुर्खा भए । त्यसपछि कनानीहरूका वंशहरू फैलिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनानीहरूको सिमाना सीदोनदेखि गरार जाने बाटोतिर गाजासम्म, र सदोम, गमोरा, अदमा र सबोयीम जाने बाटोतिर भएर लाशासम्म नै थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","तिनीहरूका वंशहरू र भाषाहरूअनुसार तिनीहरूको भूमि र देशमा हामका छोराहरू यिनीहरू नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","येपेतका दाजु शेमका पनि छोराहरू भए । शेम एबेरका सबै सन्तानहरूका पुर्खा थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","एलाम, अश्‍शूर, अर्पक्षद, लूद र अराम शेमका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ऊज, हुल, गेतेर र मेशेक अरामका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षेद शेलहका पिता बने र शेलह एबेरका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेरका दुई जना छोरा भए । एक जना छोराको नाउँ पेलेग थियो, किनभने तिनको समयमा पृथ्वी विभाजित भयो । तिनको भाइको नाउँ योक्तान थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्तान अल्मोदद, शेलेप, हसर्मवित, येरह, ");
INSERT INTO npiulb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोरम, ऊजाल, दिक्ला, ");
INSERT INTO npiulb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबमाएल, शेबा, ");
INSERT INTO npiulb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला योबाबका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","तिनीहरूका क्षेत्र मेशादेखि सपरा जाने बाटो, पूर्वका पहाडसम्म थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","तिनीहरूका वंशहरू र भाषाहरूअनुसार तिनीहरूका मुलुकहरू, जातिहरूअनुसार शेमका छोराहरू यिनीहरू नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","तिनीहरूका वंशावलीहरू र जातिहरूअनुसार नोआका छोराहरूका वंशहरू यिनै थिए । यी जातिहरूबाट नै जातिहरू छुट्टिए र जलप्रलयपछि पृथ्वीभरि गए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","अहिले सारा पृत्वीमा एउटै भाषा थियो र शब्दहरू पनि उही थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","तिनीहरू पूर्वतिर जाँदा, तिनीहरूले शिनारको भूमिमा एउटा मैदान भेट्टाए र तिनीहरू त्यही बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तिनीहरूले आपसमा भने, “आओ, ईंटहरू बनाऔँ र तिनीहरूलाई राम्ररी पलौँ ।” तिनीहरूसँग ढुङ्गाको सट्टामा ईंट थियो र हिलोको सट्टामा अलकत्रा थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","तिनीहरूले भने, “आओ, हाम्रो निम्ति एउटा सहर बनाऔँ र आकाश नै छुने एउटा धरहरा निर्माण गर्‍यौँ अनि नाउँ कमाऔँ । यदि हामीले यसो गरनौँ भने हामी सारा पृथ्वीभरि छरपष्‍ट हुनेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","यसैले परमप्रभु परमेश्‍वर आदमका सन्तानहरूले निर्माण गरेका त्यो सहर र धरहरा हेर्न तल आउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","परमेप्रभुले भन्‍नुभयो, “हेर, तिनीहरू एउटै भाषामा एउटै मानिसझैँ छन् अनि तिनीहरूले यसो गर्न सुरु गरिरहेका छन् । तिनीहरूले गर्न चाहेको कुनै पनि कुरा तिनीहरूको निम्ति असम्भव हुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","आओ, हामी तल जाऔँ र तिनीहरूका भाषा खलबलाइ दिऔँ, ताकि तिनीहरू एउटाले भनेको अर्काले बुझ्‍न सकून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","यसैले परमप्रभुले तिनीहरूलाई सारा पृथ्वीभरि छरपष्‍ट पार्नुभयो र तिनीहरूले त्यो सहर निर्माण गर्न छोडे । ");
INSERT INTO npiulb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","यसकारण, यसको नाउँ बाबेल राखियो, किनभने परमप्रभुले त्यहाँ सारा पृथ्वीको भाषा खलबलाउनुभयो अनि त्यहाँबाट नै परमप्रभुले तिनीहरूलाई सारा पृथ्वीभरि छरपष्‍ट पा्र्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","यिनीहरू शेमका सन्तानहरू थिए । जलप्रलयको दुई वर्षपछि शेम सय वर्षको हुँदा तिनी अर्पक्षेदका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","शेम अर्पक्षेदका पिता भएपछि तिनी पाँच सय वर्षसम्म बाँचे । तिनका अरू छोराहरू र छोरीहरू पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अर्पक्षद पैँतीस वर्षको हुँदा तिनी शेलहका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","अर्पक्षद शेलहका पिता भएपछो तिनी ४०३ वर्ष बाँचे । तिनका अरू छोराहरू र छोरीहरू पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","शेलह तीस वर्षका हुँदा तिनी एबेरला पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","शेलह एबेरका पिता भएपछि तिनी ४०३ वर्ष बाँचे । तिनी अरू छोराहरू र छोरीहरूका पिता पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबेर तीस वर्षको हुँदा तिनी पेलेगका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेगका पिता भएपछि एबेर ४३० वर्ष बाँचे । तिनी अरू छोराहरू र छोरीहरूका पिता पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेग तीस वर्षको हुँदा तिनी रऊका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रऊका पिता भएपछि पेलेग २०९ वर्ष बाँचे । तिनी अरू छोराहरू र छोरीहरूका पिता पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊ बत्तीस वर्षको हुँदा तिनी सरूगका पिता भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूगका पिता भएपछि रऊ २०७ वर्ष बाँचे । तिनी अरू छोराहरू र छोरीहरूका पिता पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूग तीस वर्षको हुँदा तिनी नाहोरका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोरका पिता भएपछि सरूग दुई सय वर्ष बाँचे । तिनी अरू छोराहरू र छोरीहरूका पिता पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोर उनन्तीस वर्षको हुँदा तिनी तेरहका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरहको पिता बनेपछि नाहोर ११९ वर्ष बाँचे । तिनी अरू छोराहरू र छोरीहरूका पिता पनि भए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह सत्तरी वर्षको हुँदा तिनी अब्राम, नाहोर र हारानका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहका सन्तानहरू यिनीहरू थिए । तेरहस अब्राम, नाहोर र हारानका पिता भए अनि हारान लोतका पिता बने । ");
INSERT INTO npiulb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान तिनको पिता तेरहसको सामु नै तिनको जन्म थलो अर्थात् कल्दीहरूको ऊरमा मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम र नाहोरले विवाह गरे र पत्‍नि ल्याए । अब्रामकी पत्‍निको नाउँ साराई थियो र नाहोरकी पत्‍निको नाउँ मिल्का थियो, तिनी हारानको छोरी थिइन् अनि हारान मिल्का र यिस्काका पिता थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","सारा बाँझी थिइन्; तिनको कुनै बालबच्‍चाहरू थिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरहले तिनका छोरो अब्राम, हारानाका छोरो लोत र तिनकी बुहारी साराई अर्थात् तिनका छोरो अब्रामको पत्‍निलाई लिए र कनानतिर जान तिनीहरू कल्दीहरूको ऊरतिर गए । तर तिनीहरू हारानमा आए र त्यहाँ नै बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह २०५ वर्ष बाँचे र तिनी हारानमा नै मरे । ");
INSERT INTO npiulb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","परमप्रभुले अब्रामलाई भन्‍नुभयो, “तेरो देश, तेरा नातेदारहरू र तेरो पिताको घरानाबाट मैले तँलाई देखाउने मुलुकतिर जा । ");
INSERT INTO npiulb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","म तँलाई ठुलो जाति बनाउनेछु, म तँलाई आशिष् दिनेछु, तेरो नाउँ महान् हुनेछ र तँ आशिष् हुनेछस् । ");
INSERT INTO npiulb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","तँलाई आशिष् दिनेलाई म आशिष् दिनेछु, तर तँलाई अनादर गर्नेलाई म सराप दिनेछु । तँद्वारा नै पृथ्वीका सबै परिवारहरूले आशिष् पाउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","यसैले परमप्रभुले भन्‍नुभएबमोजिम अब्राम गए र लोत पनि तिनीसँगै गए । हारान छोडेर जाँदा अब्राम पचहत्तर वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्रामले तिनकी पत्‍नी साराई, तिनका भतिजा लोत, तिनीहरूले हारानमा जम्‍मा गरेका सम्पत्ति र प्राप्‍त गरेका मानिसहरू सबै लगे । तिनीहरू कनानको भूमिमा जानलाई हिँडे र कनानको भूमिमा आइपुगे । ");
INSERT INTO npiulb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम त्यो भूमि हुँदै शकेममा भएको मोरेको फलाँटको रुखसम्म गए । त्यस बेला त्यो भूमिमा कनानीहरू बस्थे । ");
INSERT INTO npiulb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","परमप्रभु अब्रामकहाँ देखा पर्नुभयो र भन्‍नुभयो, “यो भूमि म तेरा सन्तानहरूलाई दिनेछु ।” यसैले अब्रामले तिनीकहाँ देखा पर्नुहुने परमप्रभुको निम्ति एउटा वेदी बनाए । ");
INSERT INTO npiulb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","त्यहाँबाट तिनी बेथेलको पूर्वतिरको देशतिर गए, जहाँ तिनले बेथेललाई पश्‍चिमतिर र ऐलाई पूर्वतिर पारेर तिनको पाल टाँगे । त्यहाँ तिनले एउटा वेदी बनाए र परमप्रभुको नाउँको पुकारा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","अनि अब्राम यात्रा गर्दै नेगेवतिर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","त्यो भूमिमा अनिकाल लागेको थियो, यसैले अब्राम बस्‍नलाई मिश्रतिर झरे (गए), किनकि त्यो भूमिमा निकै अनिकाल लागेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","तिनी मिश्र प्रवेश गर्न लाग्दा, तिनले आफ्‍नी पत्‍नी साराईलाई भने, “हेर, तिमी कति सुन्दरी स्‍त्री छौ भनी म जान्दछु । ");
INSERT INTO npiulb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","मिश्रीहरूले तिमीलाई देख्‍दा 'यो यसकी पत्‍नी हो' भन्‍ने छन् र तिनीहरूले मलाई मार्ने छन्, तर तिनीहरूले तिमीलाईचाहिँ जीवितै राख्‍नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","यसैले तिमी मेरी बहिनी हौ भनी तिमीले भन, ताकि तिम्रो खातिर मेरो भलो होस् र तिम्रो खातिर मेरो जीवन बाँचोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","मिश्र प्रवेश गर्न लग्दा साराई अति सुन्दरी थिइन् भनी मिश्रीहरूले देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","फारोका अधिकारीहरूले तिनलाई देखे र फारोको सामु तिनको प्रशंसा गरे र ती स्‍त्रीलाई फारोको घरानामा लगियो । ");
INSERT INTO npiulb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फारोले तिनको खातिर अब्रामलाई राम्रो व्यवहार गरे र तिनलाई गोरु, गधाहरू, नोकरीहरू, गधैनीहरू र ऊँटहरू दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","अनि परमप्रभुले अब्रामकी पत्‍नी साराईको कारण फारो र तिनको परिवारमाथि ठुलो विपत्ति ल्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","फारोले अब्रामलाई बोलाए र भने, “तिमीले मलाई यो के गरेको? तिनी तिम्रो पत्‍नी थिइन् भनी मलाई किन बताएनौ? ");
INSERT INTO npiulb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","'तिनी मेरी बहिनी हुन्' भनी तिमीले किन मलाई भन्यौ? त्यसैले मैले तिनलाई मेरी पत्‍नी बनाउन मैले लगेँ । यसकारण, तिम्रो पत्‍नी यहीँ छिन् । तिनलाई लेऊ र आफ्‍नो बाटो लाग । ");
INSERT INTO npiulb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","अनि फारोले तिनको बारेमा आफ्‍ना मानिसहरूलाई आदेश दिए र तिनीहरूले तिनलाई तिनकी पत्‍नी र तिनीसँग भएका सबै थोकसहित पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अब्राम, तिनकी पत्‍नी र तिनीसँग भएका सबै थोक लिएर मिश्रबाट माथि नेगेवतिर गए । लोत पनि तिनीसँगै गए । ");
INSERT INTO npiulb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम पशुहरू, चाँदी र सुनमा धेरै धनाढ्य थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","तिनी नेगेवबाट बेथेतिर गइरहे, जहाँ पहिले तिनको पाल थियो, त्यो बेथेल र ऐको बिचमा थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","तिनी आफूले पहिले नै बनाएका वेदी भएको ठाउँमा गए । यहाँ तिनले परमप्रभुको नाउँको पुकारा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","अब्रामसँगै यात्रा गरिरहेका लोतका पनि भेडाबाख्रा र गाईवस्तुहरूका बथान र पालहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","तिनीहरू दुवै नजिकै रहनलाई जमिनले धान्‍न सकेन, किनभने तिनीहरूका सम्पत्ति अत्यधिक थियो, यसैले तिनीहरू सँगै बस्‍न सकेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अब्राम र लोतका गाईवस्‍तुहरू र भेडाबाख्राका गोठालाहरूबिच झगडा भयो । त्यस बेला त्यहाँ कनानीहरू र परिज्‍जीहरू बस्दथे । ");
INSERT INTO npiulb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","यसैले अब्रामले लोतलाई भने, “तिम्रो र मेरा गोठालाहरूबिच झगडा नहोस्, आखिर हामी त परिवार नै हौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","के सारा भूमि तिम्रो सामु नै छैन र? तिमी जाऊ र मबाट अलग होऊ । यदि तिमी बायाँतरि गयौ भने म दायाँतिर जानेछु । वा यदि तिमी दाहिनेतिर गयौ भनौ म देब्रेतिर जानेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","यसैले, लोतले वरिपरि हेरे, र यर्दनको बेँसीचाहिँ परमप्रभुको बगैँचाजस्तै, मिश्रदेशजस्तै सोअरसम्म नै सबैतिर पानीले राम्ररी भिजेको थियो । यो परमप्रभुले सदोम र गमोरा सर्वनाश गर्न अघिको कुरा थियो ।) ");
INSERT INTO npiulb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","यसैले लोतले आफ्‍नो निम्ति यर्दनको बेँसी चुने र पूर्वतिर लागे अनि नातेदारहरू आपसमा छुटे । ");
INSERT INTO npiulb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनानको भूमिमा नै बसे, र लोत मैदानका सहरहरूमा बसे । तिनले आफ्‍ना पालहरू सदोमसम्‍म नै टाँगेर बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोमका मानिसहरू परमप्रभु विरुद्धमा दुष्‍ट पापीहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोत तिनीबाट अलग भएपछि परमप्रभुले अब्रामलाई भन्‍नुभयो, “तँ उभिएको ठाउँदेखि उत्तर, दक्षिण, पूर्व र पश्‍चिमतिर हेर् । ");
INSERT INTO npiulb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","तैँले देखेका यी सबै भूमि, म तँलाई र तेरा सन्तानहरूलाई सदाको निम्ति दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","म तेरा सन्तानहरूलाई पृथ्वीका धुलो जत्तिकै प्रशस्‍त बनाउनेछु, यसैले कसैले पृथ्वीको धूलोलाई गन्‍न सक्छ भने मात्र तेरा सन्तानहरूलाई गन्‍न सक्‍नेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","उठ्, भूमिको चारैतिर हिँड्, किनकि यो म तँलाई दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","यसैले अब्रामले आफ्नो पाल उठाए र मम्रेका फलाँटका रूखहरू नजिकै बसोबास गरे, जुन हेब्रोन थियो र त्यहाँ परमप्रभुको निम्ति एउटा वेदी निर्माण गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","यो अम्रापेल, एल्लासारका राजा अर्योक र एलाममा राजा कदोर्लाओमेर र गोयीमका राजा तिदालको समयमा भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","तिनीहरूले सदोमका राजा बेरा, गमोराका राजा बिर्शा, अद्‍माका राजा शिनाब, सबोयिमका राजा शेमेबेर र बेला (अर्थात् सोअरका) विरुद्ध युद्ध गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","यी पछिल्ला पाँच जना राजाहरू सिद्दीम अर्थात् मृत सागरको बेँसीमा भेला भए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","तिनीहरूले बाह्र वर्षसम्म कदर्लाओमेरको सेवा गरे तर तेह्रौँ वर्षमा तिनीहरूले विद्रोह गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","अनि चौधौँ वर्षमा, कदोर्लाओमेर र तिनीसित भएका राजाहरू आए र अस्तेरोत-केर्णेममा रपाईहरूलाई, हाममा जूजीहरूलाई, शावेकिर्यातैममा एमीहरूलाई, ");
INSERT INTO npiulb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","र होरीहरूलाई सेइरको पहाडी देशमा मरुभूमि नजिक रहेको ‍एल-पारानसम्म आक्रमण गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","त्यपछि तिनीहरू फर्के | र एन-मिशपातमा (अर्थात् कादेशमा) आए अनि अमालेकीहरूका सबै देशहरू र हासेसोन-तामारमा बस्‍ने एमोरीहरूलाई पराजीत गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","त्यसपछि सदोमका राजा, गमोराका राजा, अदमाका राजा, सबोयिमका राजा र बेला (अर्थात् सोअरका) राजा निस्के अनि सिद्दीमको बेँसीमा युद्धको निम्ति तयार भए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","एलामका राजा कदोर्लाओमेर, गोयीमका राजा तिदाल, शिनारका राजा अम्रापेल, एल्लासारका राजा अर्योक; पाँच राजाका विरिद्ध चार राजा । ");
INSERT INTO npiulb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीमको बेँसी अलकत्राको धापले भरिएको थियो, र सदोम र गमोराका राजाहरू भागे, तिनीहरू त्यसमा खसे । बाँकी रहेकाहरू पहाडतिर भागे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","यसैले राजाहरू सदोम र गमोराका सबै मालसामानहरू, तिनीहरूका रासनहरू लगे र आफ्नो बाटो लागे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","|जब तिनीहरू गए, | तिनीहरूले अब्रामका भाइका छोरा लोतलाई पनि तिनका सबै मालसामानसँगै लगे, जो सदोममा बसोबास गरिरहेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","उम्केर आएका एक जानले हिब्रू अब्रामलाई भने । तिनी एश्कोल र अनेरका भाइ मम्रेका फलाँटका रूखहरू नजिक बसिरहेका थिए, तिनीहरू सबै अब्रामका मित्रहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्रामले तिनका नातेदारलाई शत्रुहरूले कब्जा गरेको कुरा सुने, तिनले आफ्‍ना घरमा नै जन्मेका तालिम प्राप्‍त ३१८ जना मानिसहरू लिएर तिनले तिनीहरूलाई दानसम्म नै खेदे । ");
INSERT INTO npiulb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","तिनले आफ्‍ना मानिसहरूलाई राती तिनीहरू विरुद्ध समूह-समूहमा विभाजन गरे र तिनीहरूलाई आक्रमण गरे अनि तिनीहरूलाई होबासम्म खेदे, जुन दमस्कसको उत्तर पर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","| तिनले आफ्‍ना सबै सम्पत्तिहरू पनि फिर्ता ल्याए र तिनका नातेदार र तिनका मालसामानहरू साथै महिलाहरू र अन्य मानिसहरू पनि ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","अब्रामले कदोर्लाओमेर र तिनीसँग भएका राजाहरूलाई पराजित गरेर फर्केपछि, सदोमका राजा तिनलाई भेट्न शावेको (अर्थात् राजाको उपत्यका) उपत्यकामा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","शालेमका राजा मल्कीसेदेकले रोटी र दाखमद्य लिएर आए । तिनी सर्वोच्‍चका पूजाहारी थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","तिनले उनलाई यसो भन्दै आशोष्‌ दिए, “स्वर्ग र पृथ्वी सृष्‍टि गर्नु हुने परमेश्‍वरले अब्रामलाई आशिष् दिनुभएको होस् । ");
INSERT INTO npiulb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","सर्वोच्‍च परमेश्‍वर धन्यको हौऊन्, जसले तिम्रा शत्रुहरूलाई तिम्रा हातमा सुम्पनुभएको छ ।” तब अब्रामले तिनका सबै थोकको दशांश उनलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सदोमका राजाले अब्रामलाई भने, “मानिसहरू मलाई देऊ र सबै मालसामानहरू आफैले लैजाऊ । ");
INSERT INTO npiulb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्रामले सदोमका राजालाई भने, “मैले सर्वोच्‍च परमेश्‍वर, स्वर्ग र पृथ्वीका सृष्‍टिकर्ता परमप्रभुमा शपथ खाएको छु, ");
INSERT INTO npiulb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","मैले तपाईंबाट एउटा धागोम जुत्ताको फित्ता वा कुनै पनि कुरा लिनेछैन, ताकि 'मैले अब्रामलाई धनी बनाएको छु' भनी तपाईंले कहिल्यै भन्‍न सक्‍नुहुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","मैले जवान मानिसहरूले खाएका र मसँग गएका मानिसहरूका भाग बाहेक कुनै कुरा लिनेछैन । आनेर, एश्‍कोल र मम्रेले आफ्‍ना भाग लेऊन् । ");
INSERT INTO npiulb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","यी सबै कुराहरू भएपछि दर्शनमा अब्रामकहाँ यसो भन्‍ने परमप्रभुको वचन आयो, “अब्राम, नडराऊ । म नै तेरो ढाल तेरो धेरै महान् इनाम हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्रामले भने, “हे परमप्रभु, तपाईंले मलाई के दिनुहुन्छ र?, किनभने म सनतानविहीन रहिरहेको छु र मेरो गरको उत्तराधिकार दमस्कसको एलीएजर हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्रामले भने, “हे्र्नुहोस्, तपाईंले मलाई कुनै पनि सन्तान नदिनुभएको हुनाले मेरो घरको भण्डारे नै मेरो उत्तराधिकार हुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","हेर्नुहोस्, त्यसपछि यसो भन्‍ने परमप्रभुको वचन तिनीकहाँ आयो, “यो मानिस तेरो उत्तराधिकार हुनेछैन; तर तेरै शरीरबाट जन्मिने नै तेरो उत्तराधिकारी हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","अनि उहाँले तिनलाई बाहिर ल्याउनुभयो र भन्‍नुभयो, “आकाशतिर हेर् र ताराहरूलाई गन्, यदि तैले तिनीहरूलाई गन्‍न सक्‍छस् भने ।” अनि उहाँले तिनलाई भन्‍नुभयो, “तेरा सन्तानहरू पनि यस्तै हुनेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","तिनले परमप्रभुमा विश्‍वास गरे र उहाँले यसलाई तिनको धार्मिकताको रूपमा गन्‍नुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","उहाँले तिनलाई भन्‍नुभयो, “म परमप्रभु हुँ, जसले यो भूमि तँलाई दिन कल्दीहरूका ऊरबाट निकालेर ल्यायो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","तिनले उहाँलाई भने, “हे परमप्रभु परमेश्‍वर, मैले यो प्राप्‍त गर्नेछु भनी मैले कसरी थाहा पाउने नि?” ");
INSERT INTO npiulb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","तब उहाँले तिनलाई भन्‍नुभयो, “मलाई तिन वर्षको एउटा कोरली, तिन वर्षको बाख्राको एउटा पाठी, तिन वर्षको एउटा थुमा, एउटा ढुकुर र एउटा परेवा लेऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","तिनले ती सबै उहाँकहाँ ल्याए र तिनीहरूलाई दुई-दुई फ्याक गरेर काटे अनि हरेक फ्याकलाई आमनेसामने गरी राखे, तर पक्षीहरूलाईचाहिँ तिनले दुई फ्याक पारेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","शिकारी चराहरू सिनोहरूमाथि झम्टिँदा अब्रामले तिनीहरूलाई धपाए । ");
INSERT INTO npiulb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","घाम डुब्‍न लाग्दा अब्राम अब्राम मस्‍न निद्रामा परे र हेर, तिनलाई गाढा र डरलाग्दो अन्धकारले छोप्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","त्यपछि परमप्रभुले तिनलाई भन्‍नुभयो, “तेरा सन्तानहरू तिनीहरूको आफ्नो नभएको (अर्काको) मुलुकमा प्रवासी हुनेछन् र तिनीहरूलाई चार सय वर्षसम्‍म दास बनाइ‍नेछन् र अत्याचार गरिनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","तिनीहरूले सेवा गरेको देशको मैले न्यान गर्नेछु र त्यसपछि तिनीहरू प्रशस्‍त धन-सम्पत्तिहरूसहित निस्केर आउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तर तँचाहिँ तेरा पिता-पूर्खाहरूकहाँ शान्तिमा जानेछस् र तँलाई वृद्धवस्थामा दफन गरिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","तिनीहरू चौथो पुस्तामा फेरि यहाँ आउनेछन्, किनकि एमोरीहरूको अधर्मको सिमा अझै पुगेको छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","सूर्य अस्ताउँदा र साँझ पर्दा, हेर, धूवाँ आइरहेको मकल र बलिरहेको आगोको ज्वाला ती फ्याकहरूका बिच भएर गयो । ");
INSERT INTO npiulb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","त्यसै दिन परमप्रभुले यसो भनेर अब्रामसँग करार बाँध्‍नुभयो, “म तेरा सन्तानहरूलाई यसैद्वारा यो भूमि दिन्छु, जुन मिश्रादेखि महानदी अर्थात् युफ्रेटिससम्म छ- ");
INSERT INTO npiulb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","केनीहरू, कनज्‍जीहरू, कदोनीहरू, ");
INSERT INTO npiulb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्तीहरू, परिज्‍जीहरू, रपाईहरू, ");
INSERT INTO npiulb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरीहरू, कनानीहरू, गिर्गाशीहरू र यबूसीहरूलाई दिन्छु । ");
INSERT INTO npiulb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब अब्रामकी पत्‍नी साराईले तिनको निम्ति कुनै सन्तान जन्माएकी थिइनन्, तर तिनकी हागार नाम गरेकी एउटी मिश्री कमारी थिई । ");
INSERT INTO npiulb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","त्यसैले साराईले अब्रामलाई भनिन्, “हेर्नुहोस्, परमप्रभुले मलाई कुनै सन्तान दिनुभएको छैन । जानुहोस् मेरी कमारीसँग सुत्‍नुहोस् । सायद त्यसद्वारा मैले सन्तान प्राप्‍त गर्नेछु।” अब्रामले साराईको कुरा माने । ");
INSERT INTO npiulb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्राम कनानमा बसेको दश वर्षपछि साराईले आफ्नी मिश्री कमारी हागारलाई अब्राहमकी पत्‍नी हुनलाई दिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","त्यसैले अब्रामले हागारसँग सम्बन्ध राखे र त्यो गर्भवती भई । जब त्यसले आफू गर्भवती भएको थाहा पाई, त्यसले आफ्नी मालिक्‍नीलाई अपमानको दृष्‍टिले हेर्न थाली । ");
INSERT INTO npiulb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","त्यसपछि साराइले अब्रामलाई भनिन्, “ममाथि भएको यो खराबी तपाईंको कारणले हो । मैले मेरी कमारी तपाईंको अँगालोमा दिएँ, अनि जब त्यसले आफू गर्भवती भएको चाल पाई, त्यसको दृष्‍टिमा म तुच्छ भएँ । परमेश्‍वरले तपाईं र मेरो बिचमा इन्साफ गरून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","तर अब्राहमले साराइलाई भने, “हेर, तिम्री कमारी तिम्रै शक्तिमा छे, तिमीलाई जे उत्तम लाग्छ त्यही गर ।” त्यसैले साराईले त्यससँग कठोर व्यवहार गरिन्, अनि त्यो तिनीदेखि भागी । ");
INSERT INTO npiulb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","परमप्रभुका दूतले त्यसलाई मरुभूमिमा भएको पानीको मूल नजिकै भेट्टाए । त्यो मूल शूरतिर जाने बाटोमा पर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","तिनले सोधे, “साराईकी कमारी हागार, तँ कहाँबाट आइस् र कहाँ जाँदै छेस्?” त्यसले जवाफ दिई, “म मेरी मालिक्‍नी साराईदेखि भाग्दै छु।” ");
INSERT INTO npiulb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","परमप्रभुका दूतले त्यसलाई भने, “फर्केर तेरी मालिक्‍नीकहाँ जा र तिनको अधिकारमा समर्पित भएर बस्।” ");
INSERT INTO npiulb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","त्यसपछि परमप्रभुका दूतले त्यसलाई भने, “म तेरा सन्तानहरूलाई औधी बढाउनेछु, कि तिनीहरू गन्‍न नै नसकिने गरी धेरै हुनेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","परमेश्‍वरका दूतले यो पनि भने, “हेर्, तँ गर्भवती भएकी छेस् र एउटा छोरो जन्माउनेछेस्, र तैँले त्यसको नाम इश्‍माएल राख्‍नेछेस् किनकि परमप्रभुले तेरो दुःख सुन्‍नुभएको छ । मानिसहरूमा त्यो एउटा जङ्‍गली गधाझैँ हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","त्यो हरेक मानिसको विरुद्धमा खडा हुनेछ, र हरेक मानिस त्यसको विरूद्धमा लाग्‍नेछ, र आफ्ना सबै दाजुभाइहरूबाट अलग बस्‍नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","त्यसपछि त्यसले आफूसँग बात गर्नुहुने परमेश्‍वरका दूतलाई यो नाउँ दिई, “तपाईं मलाई देख्‍नुहुने परमप्रभु हुनुहुन्छ,” किनकि त्यसले भनी, “के उहाँले मलाई देखिसकेपछि पनि म उहाँलाई साँच्‍चै देखिरहन्छु?” ");
INSERT INTO npiulb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","त्यसैले त्यस इनारको नाउँ बेअर-लहै-रोइ राखियो, जुन कादेश र बेरेदको बिचमा पर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागारले अब्रामको छोरो जन्माई, अनि हागारले जन्माएको छोरोको नाम अब्रामले इश्माएल राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारले अब्रामको निम्ति छोरो जन्माउँदा अब्राम छयासी वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम उनान्सय वर्षको हुँदा परमप्रभु तिनीकहाँ देखा पर्नुभयो र तिनलाई भन्‍नुभयो, “म सर्वशक्‍तिमान् परमेश्‍वर हुँ । मेरो सामु आज्ञाकारी भएर हिँड्, र निर्दोष हो । ");
INSERT INTO npiulb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","त्यसपछि मेरो र तेरो बिचको आफ्नो करार म पक्‍का गर्नेछु, र तँलाई अत्यन्तै वृद्धि गराउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","अब्राम घोप्‍टो परे अनि परमेश्‍वरले तिनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“निश्‍चय नै मेरो करार तँसँगै छ । तँ धेरै जातिहरूका पिता बन्‍नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","तेरो नाम अब्राम हुनेछैन, तर अब्राहाम हुनेछ । किनकि म तँलाई धेरै जातिका पिता हुनलाई नियुक्‍त गर्छु । ");
INSERT INTO npiulb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","म तँलाई अत्यन्तै फल्दो-फुल्दो तुल्याउनेछु, र तँबाट धेरै जातिहरू बनाउनेछु । तँबाट राजाहरू उत्‍पन्‍न हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","तँ र तँपछिका तेरा सन्तानका परमेश्‍वर हुनलाई तेरो र मेरो र तँपछिका तेरा सन्‍तानको बिचमा नित्य रहिरहने करार म स्थापित गर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","तँ बसेको देश अर्थात् सारा कनान तँ र तँपछि आउने तेरा सन्तानलाई सधैँको निम्ति अधिकारको रूपमा दिनेछु, र म तिनीहरूका परमेश्‍वर हुनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","त्यसपछि परमेश्‍वरले अब्राहामलाई भन्‍नुभयो, “तैँलेचाहिँ मेरो करार पालन गर्नुपर्छ, तँ र तँपछिका तेरा सन्तानहरूले तिनीहरूका पुस्तौँसम्म । ");
INSERT INTO npiulb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","यो मेरो र तेरो र तँपछि आउने तेरा सन्‍तानहरूका बिचमा भएको तिमीहरूले पालन गर्नुपर्ने मेरो करार होः तिमीहरूका बिचमा भएका हरेक पुरुषको खतना हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तिमीहरूको खलडीको खतना हुनुपर्छ । मेरो र तिमीहरूको बिचको करारको चिन्ह यही हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","तिमीहरूका पुस्तौँसम्म तिमीहरूमा आठ दिन पुगेका हरेक पुरुषको खतना गरिनुपर्छ । यसमा तेरो घरमा जन्मेका र तेरो सन्‍तान नभए पनि विदेशीबाट दाम हालेर किनेका व्यक्‍ति पनि पर्दछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","तेरो घरमा जन्मेका र तेरो पैसाले किनेका सबैको खतना हुनैपर्छ । यसरी मेरो करार तिमीहरूको शरीरमा नित्य रहिरहने करार हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","खलडीको खतना नगरिएको पुरुष उसका मानिसहरूबाट बहिष्कार गरिनेछ । त्यसले मेरो करार भङ्‍ग गरेको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","पमेश्‍वरले अब्राहामलाई भन्‍नुभयो, “तेरी पत्‍नी साराईलाई चाहिँ अबदेखि साराई भनेर नबोलाउनू । तर त्यसको नाउँ सारा हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","म त्यसलाई आशिष् दिनेछु, र त्यसद्वारा म तँलाई एउटा छोरो दिनेछु । म त्यसलाई आशिष् दिनेछु, र त्यो जाति-जातिहरूकी आमा हुनेछे । जाति-जातिहरूका राजाहरू त्यसबाट उत्पन्‍न हुनेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","त्यसपछि अब्राहाम घोप्‍टो परेर हाँसे, अनि मनमनै यसो भने, “के सय वर्षको मानिसबाट सन्तान जन्मन सक्छ र? नब्बे वर्ष पुगेकी साराले कसरी सन्तान जन्माउन सक्छिन् र?” ");
INSERT INTO npiulb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अब्राहामले परमेश्‍वरलाई भने, “इश्माएल नै तपाईंको आशिष्‍्‌मा बाँचिरहे त हुन्छ!” ");
INSERT INTO npiulb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","परमेश्‍वरले भन्‍नुभयो, “होइन, तर तेरी पत्‍नी साराले तेरो निम्ति एउटा छोरो जन्माउनेछे, र तैँले त्यसको नाउँ इसहाक राख्‍नू । नित्य रहिरहने करारको रूपमा म त्यससित र त्यसपछि आउने त्यसका सन्तानसित मेरो करार स्थापित गर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","इश्माएको विषयमा मैले तेरो बिन्ति सुनेँ । हेर्, म त्यसलाई आशिष् दिनेछु, र त्यसलाई फल्दो‍-फुल्दो बनाएर प्रशस्त गरी त्यसको वृद्धि गर्नेछु । त्यो बाह्र जातिका अगुवाहरूका पिता हुनेछ, र त्यसलाई म ठुलो जाति बनाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","तर मेरो करार त म इसहाकसँग स्थापित गर्नेछु, जसलाई साराले अर्को वर्ष यही समयमा तँबाट जन्माउनेछे ।” ");
INSERT INTO npiulb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","तिनीसँग कुरा गरिसक्‍नुभएपछि परमेश्‍वर अब्राहामदेखि छुट्टिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","त्यसपछि अब्राहामले आफ्नो छोरो इश्माएल, र आफ्‍नो घरमा जन्मेका, र दाम हालेर किनेका सबै, परमेश्‍वरले भन्‍‍नुभएबमोजिम त्यसै दिन आफ्नो घरका सबै पुरुषहरूका खलडीको खतना गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","तिनको खलडीको खतना गर्दा अब्राहाम उनान्सय वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","तिनको छोरो इश्माएलचाहिँ आफ्नो खलडीको खतना गर्दा तेह्र वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम र इश्माएलको खतना एकै दिनमा भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","तिनको घरमा जन्मेका र विदेशीबाट किनिएका सबै पुरुषहरूको खतना तिनको खतनासँगसँगै भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","दिउँसोको गर्मीमा मम्रेका फलाँटका रुखहरूछेउमा भएको आफ्‍नो पालको ढोकामा अब्राहाम बसेको बेला परमप्रभु तिनीकहाँ देखा पर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","तिनले आफ्‍ना आँखा उठाएर हेरे, र तिनले आफ्‍नो सामु तिन जना मानिस उभिरहेका देखे । उनीहरूलाई देखेपछि तिनी पालको ढोकाबाट भेट गर्नलाई दौडेर गए, र भुइँसम्‍म निहुरेर दण्‍डवत्‌ गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","तिनले भने, “प्रभु, यदि तपाईंको नजरमा मैले निगाह पाएको छु भने, आफ्‍नो दासलाई छोडेर नजानुहोस्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","केही पानी ल्‍याउन दिनुहोस्, र तपाईंहरू आफ्‍ना गोडा धुनुहोस्, र यही रुखमुनि आराम गर्नुहोस्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","मलाई केही रोटी ल्‍याउन दिनुहोस्, ताकि तपाईंहरूको थकाइ मरोस् । त्यसपछि तपाईंहरू आफ्नो बाटो जान सक्‍नुहुन्छ, किनभने तपाईंहरू आफ्‍नो दासकहाँ आउनुभएको छ ।” उनीहरूले भने, “तिमीले भनेअनुसार गर ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","तब अब्राहाम तुरुन्तै पालमा साराकहाँ गएर भने, “चाँडो पाँच पाथी मसिनो पिठो ल्याई मुछेर रोटी बनाऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","अब्राहाम बथानतिर दौडेर गए, र एउटा कलिलो र असल बाछो लिएर नोकरलाई दिए, र त्‍यसलाई हतारमा तयार गर्न लागे । ");
INSERT INTO npiulb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","तिनले दही, दूध र त्‍यो तयार गरिएको बाछाको मासु लगेर उनीहरूका सामु टक्र्याए । उनीहरूले खाँदा तिनी उनीहरूकै नजिक रूखमुनि उभिए । ");
INSERT INTO npiulb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","उनीहरूले तिनलाई सोधे, “तेरी पत्‍नी सारा कहाँ छे?” तिनले जवाफ दिए, “त्यहीँ पालमा छिन्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","परमप्रभुले भन्‍नुभयो, “आउँदो साल यही समयमा म निश्‍चय नै तँकहाँ फर्किआउनेछु, र हेर्, तेरी पत्‍नी साराले एक जना छोरो जन्‍माउनेछे ।” साराले चाहिँ उहाँको पछिल्तिर भएको ढोकाबाट यो कुरो सुनिरहेकी थिइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम र सारा वृद्ध थिए र तिनीहरूको उमेर ढल्किसकेको थियो । साराको बच्‍चा जन्माउने उमेर बितिसकेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","यसकारण सारा मनमनै यसो भन्‍दै हाँसिन्, “म वृद्ध भइसकेकी छु, र मेरा स्वामी पनि वृद्ध भइसक्‍नुभएको छ, के मैले सुख पाउँछु र?” ");
INSERT INTO npiulb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब परमप्रभुले अब्राहामलाई भन्‍नुभयो, “‘बुढेसकालमा मैले छोराछोरी पाउँछु र भनेर सारा किन हाँसी’? ");
INSERT INTO npiulb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","परमप्रभुको निम्‍ति कुनै कुरो कठिन छ र? अर्को साल मैले तोकेको समयमा म तँकहाँ फर्किआउनेछु । अर्को वर्ष यही समयमा साराको एक जना छोरा हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","त्यसपछि साराले इन्कार गर्दै यसो भनिन्, “म हाँसिनँ ।” किनभने तिनी डराइन्‌ । तर उहाँले जवाफ दिनुभयो, “होइन, तँ हाँसेकै होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","तब ती पुरुषहरू उठे र सदोमतिर तल हेरे । अब्राहाम अलि परसम्‍म उनीहरूलाई बिदा गर्न गए । ");
INSERT INTO npiulb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","तर परमप्रभुले भन्‍नुभयो, “मैले गर्न लागेको काम के अब्राहामबाट लुकाएर राखूँ? ");
INSERT INTO npiulb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहामबाट एउटा ठुलो र शक्तिशाली जाति बन्‍नेछ, र त्‍यसद्वारा नै पृथ्‍वीका सबै जातिहरूले आशिष्‌ पाउनेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","किनभने मैले त्‍यसलाई आफ्‍ना छोराछोरीहरू र घरानालाई धर्म र न्‍याय गरेर परमप्रभुको मार्ग पालन गर्नलाई आज्ञा देओस्‌ भनेर छानेको छु, ताकि परमप्रभुले अब्राहामलाई भन्‍नुभएको कुरा पुरा गर्नुभएको होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","तब परमप्रभुले भन्‍नुभयो, “सदोम र गमोराको विरुद्धमा उठेको आवाज धेरै ठुलो, र तिनीहरूका पाप साह्रै गम्भीर भएको कारण ");
INSERT INTO npiulb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","मकहाँ आएको त्यसको विरुद्धको आवाजअनुसार तिनीहरूले गरेका छन् कि छैनन् भन्‍ने कुरा हेर्नलाई म तल जानेछु । होइन रहेछ भने मलाई थाहा हुनेछ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","यसकारण ती पुरुषहरू त्‍यहाँबाट सदोमतिर गए, तर अब्राहामचाहिँ परमप्रभुको सामु उभिरहे । ");
INSERT INTO npiulb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्राहामले नजिक गएर भने, ‘के तपाईंले धर्मीहरूलाई पनि दुष्‍टहरूसँगै नष्‍ट गर्नुहुनेछ? ");
INSERT INTO npiulb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","सायद त्‍यस सहरमा पचास धर्मी जन छन् होला । के त्‍यसमा भएका पचास धर्मी जनका निम्‍ति त्‍यस सहरलाई नजोगाएर नष्‍ट पार्नुहुनेछ र? ");
INSERT INTO npiulb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","धर्मीलाई पनि दुष्‍टलाई जस्तै व्यवहार गरेर दुष्‍टका साथमा धर्मी जनलाई मार्ने काम तपाईंबाट टाढा रहोस् । यस्तो कुरा तपाईंबाट टाढा रहोस्! सारा पृथ्‍वीका न्‍यायकर्ताले न्यायोचित काम गर्नुहुन्‍न र? ");
INSERT INTO npiulb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","परमप्रभुले भन्‍नुभयो, “सदोम सहरभित्र पचास धर्मी जन पाएँ भने म तिनीहरूका खातिर सारा सहरलाई छोड़िदिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहामले जवाफ दिएर भने, “हेर्नुहोस्, म केवल माटो र खरानी मात्र भएर पनि परमप्रभुसँग कुरा गर्न आँट गरेको छु । ");
INSERT INTO npiulb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","यदि त्यहाँ पाँच कम पचास जना धर्मी जन रहेछन्‌ भने? केवल पाँच मात्र घटी भएको कारण तपाईं सारा सहरलाई नै नाश गर्नुहुनेछ?” त्यसपछि उहाँले भन्‍नुभयो, “यदि मैले त्‍यहाँ पैँतालीस पाएँ भने म त्‍यो नाश गर्नेछैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","तिनले फेरि उहाँसँग बोल्दै भने, “यदि त्‍यहाँ चालीस रहेछन्‌ भने?” उहाँले भन्‍नुभयो, “चालीस जनाका खातिर पनि म त्‍यसो गर्नेछैनँ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तिनले भने, “परमप्रभु रिसानी नहोस् ताकि म अझै बोल्न सकूँ । यदि त्‍यहाँ तिस जना पाइए भने?” उहाँले भन्‍नुभयो, “त्‍यहाँ तिस जना नै पाएँ भने पनि म त्‍यसो गर्नेछैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","तिनले भने, “हेर्नुहोस्, मैले परमप्रभुसँग कुरा गर्ने आँट गरेको छु । बिस जना पाइए भने?” उहाँले भन्‍नुभयो, “बिस जनाका खातिर पनि म त्यसलाई नाश गर्नेछैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","तिनले भने, “परमप्रभु रिसानी नहोस्‌। अब अन्तिम एक पल्ट बोल्‍नेछु । सायद त्‍यहाँ दस जना पाइन्छन् होला?” उहाँले भन्‍नुभयो, “दश जनाका खातिर पनि म त्‍यो नाश गर्नेछैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","अब्राहामसित कुरा गरिसक्‍ने बित्तिकै परमप्रभु गइहाल्‍नुभयो, र अब्राहामचाहिँ आफ्‍नो घर फर्के । ");
INSERT INTO npiulb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","साँझमा लोत सदोमको मूल ढोकामा बसिरहेका बेला दुई स्वर्गदूतहरू सदोममा आए । उनीहरूलाई देखेपछि लोत भेट गर्न उठे, र आफ्नो मुहारलाई भुइँसम्मै निहुराएर दण्डवत् गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","तिनले भने “मेरा मालिक, म बिन्ती गर्दछु, कि आफ्नो दासको घरभित्र आउनुहोस्, आजको रात यहीँ बिताउनुहोस्, र आफ्ना पाउ धुनुहोस् । त्यसपछि बिहान सबेरै उठेर तपाईंहरू आफ्नो बाटो लाग्‍न सक्‍नुहुन्छ ।” उनीहरूले जवाफ दिए, “होइन, हामी सहरको चोकमा नै रात बिताउनेछौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","तर तिनले उनीहरूलाई ज्यादै आग्रह गरे, त्यसैकारण उनीहरू तिनीसँगै घरभित्र प्रवेश गरे । तिनले भोजनमा खमिर नराखेको रोटी तयार गरे, र उनीहरूले खाए । ");
INSERT INTO npiulb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","तर उनीहरू सुत्‍नअगि सदोम सहरका सबै युवा र जवान, र सहरका सबै भागबाट सबै मानिसहरू आएर त्यस घरलाई घेरे । ");
INSERT INTO npiulb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","तिनीहरूले लोतलाई बोलाएर भने, “साँझ तिमीकहाँ आएका मानिसहरू कहाँ छन्? उनीहरूलाई बाहिर हामीकहाँ ल्याऊ, ताकि हामी तिनीहरूसँग सुत्‍न सकौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","यसैकारण लोत ढोकाबाट बाहिर मानिसहरूकहाँ निस्‍के र आफू निस्‍केपछि ढोका थुनिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","तिनले भने, “मेरा भाइहरू, म बिन्ती गर्दछु, यस्तो दुष्‍ट काम नगर्नुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","हेर्नुहोस्, मेरा दुई छोरी छन् जो कुनै मानिससँग सुतेका छैनन् । म बिन्ती गर्दछु, मेरा छोरीहरूलाई तपाईंहरूकहाँ ल्याउन दिनुहोस्, र तपाईंहरूको नजरमा जे असल लाग्छ तिनीहरूसँग त्यही गर्नुहोस् । केवल यी मानिसहरूलाई केही नगर्नुहोस्, किनभने उनीहरू मेरो छतको छायामुनि आएका पाहुना हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","तिनीहरूले भने, “पछि हट्!” तिनीहरूले यसो पनि भने, “यो यहाँ परदेशी भएर बस्‍न आएको थियो, र अहिले हाम्रो न्यायकर्ता भएको छ! अब हामी तिनीहरूलाई भन्दा तँलाई नराम्रो व्यवहार गर्नेछौँ ।” तिनीहरूले ती मानिसहरू र लोतको विरुद्धमा दबाब दिए, र ढोका भत्‍काउनको निम्ति नजिक आए । ");
INSERT INTO npiulb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","तर ती मानिसहरूले आफ्ना हात निकालेर लोतलाई तिनीहरूसँगै घरभित्र ताने र ढोका बन्द गरिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","त्यसपछि लोतका पाहुनाहरूले घरको ढोकाबाहिर भएका मानिसहरू, जवान र वृद्ध दुवैलाई प्रहार गरी अन्धा बनाइदिए, र तिनीहरू ढोका खोज्‍ने प्रयास गर्दा-गर्दै थाके । ");
INSERT INTO npiulb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","त्यसपछि ती मानिसहरूले लोतलाई भने, “के तिमीकहाँ अरू कोही छन्? जुवाइँ, छोराहरू, छोरीहरू, र यस सहरमा तिम्रा जो कोही छन्, सबैलाई यस सहरबाट बाहिर लैजाऊ । ");
INSERT INTO npiulb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","किनभने हामीले यो ठाउँलाई नष्‍ट गर्न लागेका छौँ, किनभने परमप्रभुको अगि यस सहरको विरुद्धमा दोषहरू यति ठुला भएका छन्, कि उहाँले हामीलाई यस सहरलाई नष्‍ट पार्न पठाउनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","लोत बाहिर गए, र तिनले आफ्ना छोरीहरूलाई विवाह गर्न प्रतिज्ञा गरेका जुवाइँहरूसँग यसो भने, “छिट्टै, यस ठाउँबाट निस्किहाल, किनभने परमप्रभुले यस सहरलाई नष्‍ट पार्न लाग्‍नुभएको छ ।” तर तिनका जुवाइँहरूलाई तिनले ठट्टा गरेझैँ लाग्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","जब झिसमिसे बिहान भयो, ती स्वर्गदूतहरूले लोतलाई यसो भने, “जाऊ, यहाँ भएका तिम्री पत्‍नी र तिम्रा छोरीहरूलाई लैजाऊ, र यस सहरको दण्डमा तिमी नष्‍ट हुनेछैनौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","तर तिनले अलमल गर्न थाले । त्यसैकारण ती मानिसहरूले लोत, तिनकी पत्‍नी, र तिनका दुई छोरीका हातहरू समाते, किनभने परमप्रभु तिनीप्रति दयालु हुनुहुन्थ्यो । उनीहरूले तिनीहरू सबैलाई बाहिर निकाले, र सहरबाहिर पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","जब उनीहरूले तिनीहरूलाई बाहिर निकाले, ती मानिसहरूमध्ये एकजनाले भने, “आफ्नो प्राण बचाउनको निम्ति भाग! पछाडि फर्की नहेर, वा कतै समतल ठाउँमा नबस । पहाडहरूतिर भाग र तिमीहरू नष्‍ट हुनेछैनौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लोतले तिनीहरूलाई भने, “होइन, मेरा मालिकहरू! ");
INSERT INTO npiulb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","तपाईंका दृष्‍टिमा तपाईंको दासले कृपा पाएको छ, र मेरो प्राण बचाउनको निम्ति ममाथि तपाईंहरूले ठुलो दया देखाउनुभएको छ, तर म पहाडहरूतिर भाग्‍न सक्दिनँ, किनभने ममाथि विपत्ति आइलाग्‍नेछ र म मर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","हेर्नुहोस्, त्यहाँको सहर भाग्‍नको निम्ति नजिक छ, र त्यो सानो पनि छ । कृपया, मलाई त्यहाँ भाग्‍न दिनुहोस् (के त्यो सानोचाहिँ होइन र?), र मेरो जीवन बच्‍नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","उनले तिनलाई भने, “ठिक छ, म तिम्रो यो अनुरोध पनि पुरा गर्नेछु र तिमीले उल्लेख गरेको त्यस सहर म नष्‍ट गर्दिनँ । ");
INSERT INTO npiulb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","छिटो गर! त्यहाँ भाग, किनभने तिमी त्यहाँ नपुगेसम्म म केही गर्न सक्दिनँ ।” यसैकारण त्यस सहरलाई सोअर भनियो । ");
INSERT INTO npiulb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लोत सोहर पुग्‍दा घाम उदाइसकेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","त्यसपछि परमप्रभुले सदोम र गमोरामाथि आकाशबाट गन्धक र आगो बर्साउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","उहाँले ती सहरहरू, सबै समतल भूमि, र ती सहरहरूका बासिन्दाहरू, र भूमिमा उब्जेका सबै बिरुवाहरूलाई नष्‍ट पार्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","तर लोतकी पत्‍नीले पछाडि फर्केर हेरिन्, जो तिनको पछि-पछि थिइन्, र तिनी नुनको ढिक्‍का बनिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","अब्राहाम बिहान सबेरै उठे र तिनी परमप्रभुको सामु उभिएको ठाउँमा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","उनले सदोम र गमोरातर्फ र सबै समतल भूमिमा हेरे । उनले त्यस भूमिबाट भट्टीको धुवाँझैँ माथितिर धुवाँ आइरहेको देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","परमेश्‍वरले समतल भूमिका सहरहरूलाई नष्‍ट गर्नुभएपछि, उहाँले अब्राहामलाई सम्झनुभयो । उहाँले लोतले बसोबास गरेका सहरहरूलाई नष्‍ट गर्नुहुँदा, लोतलाई त्यस विनाशको माझबाट बाहिर निकाल्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","तर लोत आफ्ना दुई छोरीसँग सोअरबाट पहाडहरूमा बसोबास गर्न गए, किनभने तिनी सोअरमा बस्‍न डराए । यसैकारण, तिनी र तिनका दुई छोरीहरू एउटा गुफामा बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","जेठीले कान्छीलाई भनिन्, “हाम्रा बुबा वृद्ध भएका छन्, र सारा संसारको रीतिअनुसार हामीसँग सुत्‍ने कहीँ पनि कोही मानिस छैन । ");
INSERT INTO npiulb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","आऊ, हाम्रो बुबालाई मद्य पिउन लगाऔँ, अनि हाम्रो बुबाको वंशलाई बिस्तार गर्न हामी उहाँसँग सुतौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","यसैकारण त्यस रात तिनीहरूले आफ्ना बुबालाई मद्य पिउन लगाए । त्यसपछि जेठीचाहिँ भित्र गइन् र आफ्ना बुबासँग सुतिन्; तिनी कहिले सुतिन् र कहिले उठिन् भन्‍ने उनलाई पत्तो नै भएन । ");
INSERT INTO npiulb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","अर्को दिन जेठीले कान्छीलाई भनिन्, “सुन, गएको रात म मेरो बुबासँग सुतेँ । आजको रातमा पनि उहाँलाई मद्य पिउन लगाऔँ, र हाम्रो बुबाको वंश विस्तार गर्नको निम्ति तिमी गएर उहाँसँग सुत ।” ");
INSERT INTO npiulb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","यसैकारण, तिनीहरूले आफ्ना बुबालाई त्यस रात पनि मद्य पिउन लगाए, र कान्छीचाहिँ गएर उनीसँग सुतिन् । तिनी कहिले सुतिन् र कहिले उठिन् भन्‍ने उनलाई पत्तो नै भएन । ");
INSERT INTO npiulb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","यसरी लोतका दुवै छोरीहरू आफ्ना बुबाबाट गर्भवती भइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","जेठीले एउटा छोरो जन्माइन्, र त्यसको नाउँ मोआब राखिन् । वर्तमान समयका मोआबीहरूका पुर्खा उनी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","कान्छी छोरीले पनि एउटा छोरा जन्माइन्, र त्यसको नाउँ बेन-अमी राखिन् । वर्तमान समयका अम्मोनीहरूका पुर्खा उनी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","अब्राहाम त्यहाँबाट नेगेवको भूमितर्फ गए, र कादेश र शूरको बिचमा बसे । उनी गरारमा बसोबास गर्ने एक परदेशी थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अब्राहामले आफ्नी पत्‍नी साराको बारेमा यस्तो भनेका थिए, “यिनी मेरी बहिनी हुन् ।” यसैकारण गरारका राजा अबीमेलेकले सारालाई मानिसहरू पठाई आफूकहाँ ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","तर परमप्रभु राती अबीमेलेकको सपनामा आउनुभयो, र तिनलाई भन्‍नुभयो, “सुन्, तैँले आफ्नो साथमा ल्याएको स्‍त्रीको कारण तँ श्रापित भएको छस्, किनभने त्यो अरू कसैकी पत्‍नी हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","अबीमेलेक तिनको नजिक गएका थिएनन् र उनले भने, “परमप्रभु के तपाईंले धार्मिक जातिलाई पनि मार्नुहुन्छ र? ");
INSERT INTO npiulb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","के त्यो आफैँले मलाई ‘यिनी मेरी बहिनी हुन्’ भनेर भनेको थिएन र? त्यस स्‍त्रीले पनि, ‘तिनी मेरा दाजु हुन्’ भनेर भनेकी थिई । मेरो हृदयको इमान्दारी र मेरा निर्दोष हातद्वारा मैले यो गेरको हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","त्यसपछि परमप्रभुले तिनलाई सपनामा भन्‍नुभयो, “हो, यो मलाई पनि थाहा छ, कि तैँले आफ्नो हृदयको इमान्दारीमा यो गरिस्, र मैले नै तँलाई मेरो विरूद्ध पाप गर्नबाट बचाएँ । यसैकारण मैले तँलाई त्यस स्‍त्रीलाई छुन दिइनँ । ");
INSERT INTO npiulb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","यसैकारण, त्यस मानिसकी पत्‍नीलाई फर्काइदे, किनभने त्यो एउटा अगमवक्ता हो । त्यसले तेरो निम्ति प्रार्थना गर्नेछ, र तँ बाँच्‍नेछस् । तर यदि तैँले त्यसलाई फर्काइनस् भने, यो थाहा गर्, कि तँ र तेरा सबै निश्‍चय नै मर्नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","अबीमेलेक बिहानै उठे र आफ्ना सबै नोकरहरूलाई बोलाए । तिनले यी सबै कुरा ती मानिसहरूलाई बताए, र तिनीहरू धेरै डराए । ");
INSERT INTO npiulb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","त्यसपछि अबीमेलेकले अब्राहामलाई बोलाएर भने, “तिमीले यो हामीलाई के गर्‍यौ? मैले तिम्रो विरुद्धमा के पाप गरेको थिएँ जसको कारण तिमीले ममाथि र मेरो राज्यमाथि यति ठुलो पाप ल्यायौ? तिमीले मसित गर्न नहुने काम गर्‍यौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","अबीमेलेकले अब्राहामलाई भने, “के कुराले तिमीलाई यस्तो काम गर्न लगायो?” ");
INSERT INTO npiulb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहामले भने, “किनभने यस ठाउँमा निश्‍चय नै परमप्रभुको कुनै भय छैन र तिनीहरूले मलाई मेरी पत्‍नीको कारणले मार्नेछन् भनी मैले विचार गरेँ । ");
INSERT INTO npiulb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","हुन त यिनी मेरो बुबाकी छोरी मेरी बहिनी हुन्, तर यिनी मेरी आमाकी छोरी होइनन्, र यिनी मेरी पत्‍नी भइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","जब परमप्रभुले मलाई मेरो बुबाको घर त्यागेर एक ठाउँदेखि अर्को ठाउँ यात्रा गर्न लगाउनुभयो, मैले तिनलाई भनेँ, ‘तिमी मेरी पत्‍नी भएकी कारणले हामी जाने हरेक ठाउँमा, मेरो विषयमा “उनी मेरा दाजु हुन्” भन्‍ने बताएर तिमीले मेरो निम्ति विश्‍वसनीयता देखाउनू ।’” ");
INSERT INTO npiulb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","त्यसपछि अबीमेलेकले अब्राहामलाई भेडाहरू, गोरुहरू, र कमारा-कमारीहरू दिए । तिनले अब्राहामकी पत्‍नी सारालाई पनि उनीकहाँ फर्काइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अबीमेलेकले भने, “हेर, मेरो भूमि तिम्रै अगि छ । जहाँ तिमीलाई मनपर्छ त्यहीँ बस ।” ");
INSERT INTO npiulb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","सारालाई तिनले भने, “हेर, मैले तिम्रो दाजुलाई चाँदीका हजार सिक्‍काहरू दिएको छु । तिमीसँग भएका सबैका आँखामा तिम्रो विरुद्धमा भएका सबै दोष ढाक्‍न मैले यो गरेको हुँ, र सबैको अगि तिमीलाई पूर्ण रूपमा सही ठहराएको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","त्यसपछि अब्राहामले परमप्रभुसँग प्रार्थना गरे, र उहाँले अबीमेलेक, तिनकी पत्‍नी, र तिनका कमारीहरूलाई निको पार्नुभयो र तिनीहरूले छोरीछोरी जन्माउन सके । ");
INSERT INTO npiulb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","किनभने अब्राहामकी पत्‍नी साराको कारण अबीमेलेकको घरानाका सबै स्‍त्रीलाई परमप्रभुले बाँझी बनाउनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","आफूले भन्‍नुभएअनुसार परमप्रभुले सारालाई ध्यान दिनुभयो, र आफूले प्रतिज्ञा गर्नुभएझैँ उहाँले साराको निम्ति गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा गर्भवती भइन् र अब्राहामको वृद्ध अवस्थामा परमप्रभुले उनलाई भन्‍नुभएकै समयमा उनको निम्ति एउटा छोरो जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","आफू र साराबाट जन्मेको आफ्नो छोरोको नाउँ अब्राहामले इसहाक राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","परमप्रभुले आज्ञा गर्नुभएझैँ आफ्नो छोरो आठ दिनको हुँदा अब्राहामले तिनको खतना गरिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","आफ्नो छोरो जन्मिँदा अब्राहाम सय वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","साराले भनिन्, “परमप्रभुले मलाई हाँसो दिनुभएको छ; सुन्‍नेहरू हरेक मसँगै हाँस्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","तिनले फेरि भनिन्, “साराले छोराछोरी हेरचाह गर्नेछे भनेर अब्राहामलाई कसले भन्‍नेथियो र, तर उनको वृद्ध अवस्थामा मैले उनको निम्ति एउटा छोरो जन्माएकी छु!” ");
INSERT INTO npiulb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","त्यो बालक बढ्दै गयो र त्यसले दूध खान छोड्यो, र इसहाकले दूध खान छोडेको दिन अब्राहामले एउटा ठुलो भोजको आयोजना गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","मिश्री हागारले अब्राहामबाट जन्माएकी छोरोले ठट्टा गरिरहेको साराले देखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","त्यसैकारण तिनले अब्राहामलाई भनिन्, “त्यस कमारी स्‍त्री र त्यसको छोरोलाई बाहिर निकालिदिनुहोस्, किनकि त्यस कमारी स्‍त्रीको छोरो मेरो छोरो इसहाकसँगै उत्तराधिकारी बन्‍नेछैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","आफ्नो छोरोको कारण यो कुरा अब्राहामको निम्ति धेरै दुःखदायी थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तर परमप्रभुले अब्राहामलाई भन्‍नुभयो, “त्यो केटो र तेरी कमारी स्‍त्रीको निम्ति दुःख नमान् । यस विषयमा साराले तँलाई भनेकी सबै कुराहरू तैँले सुन्, किनकि इसहाकद्वारा नै तेरा वंशहरूको नाम रहनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","त्यस कमारी स्‍त्रीको छोरोबाट पनि म एउटा जाति तयार गर्नेछु किनकि त्यो तेरै वंश हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","अब्राहाम सबेरै उठे, अनि रोटी र पानीको एउटा मशक लिएर हागारको काँधमा राखिदिए । उनले बालकलाई तिनकै साथमा दिएर पठाए । तिनी त्यहाँबाट गइन् र बेर्शेबाको उजाड-स्थानमा भौँतारिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जब मशकको पानी सक्‍कियो, तिनले बालकलाई एउटा पोथ्रोमुनि छोडिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","त्यसपछि तिनी त्यस बालकबाट केही दुरी (करिब एउटा काँडले पार गर्ने दुरी) मा गएर बसिन् र भनिन्, “मैले यस बालकको मृत्यु हेर्न नपरोस् ।” त्यस बालकबाट केही दुरीमा बसेर तिनले आफ्नो सोर उचालिन् र रोइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमप्रभुले त्यस बालकको सोर सुन्‍नुभयो, र स्वर्गबाट परमप्रभुको एउटा दूतले हागारलाई बोलाएर भने, “हागार, तिमीलाई के कुराले सताइरहेको छ? नडराऊ, किनकि त्यस बालक भएको ठाउँबाट त्यसको सोर परमप्रभुले सुन्‍नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","उठ, त्यस बालकलाई उठाऊ, र त्यसलाई उत्साहित गराऊ, किनभने म त्यसबाट एउटा महान् जाति खडा गर्नेछु । ” ");
INSERT INTO npiulb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","त्यसपछि परमप्रभुले तिनका आँखा खोलिदिनुभयो, र तिनले पानीको एउटा कुवा देखिन् । तिनी गएर त्यस मशकमा पानी भरिन्, अनि बालकलाई पानी दिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","परमप्रभु त्यस बालकसँग हुनुहुन्थ्यो, र ऊ बढ्दै गयो । ऊ उजाड-स्थानमै बस्थ्यो र एउटा धनुर्धारी बन्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ऊ पारानको उजाड-स्थानमा बस्दा, उसकी आमाले उसको निम्ति मिश्रबाट एउटा पत्‍नी ल्याइदिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","त्यस समय अबीमेलेक र तिनका सेनापति पीकोलले अब्राहामलाई यसो भने, “तिमीले गर्ने सबै कुरामा परमप्रभु तिमीसँगै हुनुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","यसैकारण अब मसँग यहाँ परमप्रभुको सामु प्रतिज्ञा गर, कि तिमीले म, मेरा सन्तति र मेरा उत्तराधिकारीहरूसँग कुनै छल गर्नेछैनौ । मैले तिमीलाई प्रतिज्ञामा जस्तो विश्‍वसनीयता देखाएँ तिमीले पनि त्यस्तै विश्‍वसनीयता म, र तिमी बसोबास गर्दै आएको यस भूमिप्रति देखाउनू ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहामले भने, “म प्रतिज्ञा गर्दछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","अब्राहामले अबीमेलेकसँग तिनका नोकरहरूले उनीबाट खोसेका पानीको कुवाको विषयमा पनि गुनासो गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमेलेकले भने, “यो काम कसले गर्‍यो मलाई थाहा भएन । तिमीले यस विषयमा मलाई पहिले नै भनेनौ, र मैले यसबारे आजसम्म केही सुनेको छैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","यसैकारण अब्राहामले भेडाहरू र गाई-गोरुहरू अबीमेलेकलाई दिए, र तिनीहरूले प्रतिज्ञा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","त्यसपछि आफ्नो बगालबाट अब्राहामले सातवटा पाठी छुट्‍ट्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमेलेकले अब्राहामलाई भने, “तिमीले छुट्ट्याएर राखेको यी सात पाठीको अर्थ के हो?” ");
INSERT INTO npiulb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","तिनले जवाफ दिए, “यो कुवा मैले खनेको हुँ भनी साक्षी होस् भनेर यी सात पाठी तपाईंले मेरा हातबाट प्राप्‍त गर्नुहुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","यसैकारण उनले त्यस ठाउँलाई बेर्शेबा भने किनभने तिनीहरू दुवैले प्रतिज्ञा गरेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","तिनीहरूले बेर्शेबामा प्रतिज्ञा गरे, र त्यसपछि अबीमेलेक र सेनापति पीकोल पलिश्तीहरूको भूमिमा फर्के । ");
INSERT INTO npiulb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामले बेर्शेबामा एउटा झ्याउको बोट रोपे । त्यसपछि उनले अनन्तका परमेश्‍वरको आराधना गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहाम धेरै दिन पलिश्तीहरूको भूमिमा परदेशी भएर नै रहे । ");
INSERT INTO npiulb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","यी कुराहरूपछि परमेश्‍वरले अब्राहामको जाँच गर्नुभयो । उहाँले तिनलाई भन्‍नुभयो, “ए अब्राहाम!” अब्राहमले भने, “म यहीँ छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","त्यसपछि परमेश्‍वरले भन्‍नुभयो, “तैँले माया गर्ने तेरो छोरो इसहाकलाई लिएर मोरीयाहको देशमा जा । त्यहाँको कुनै एक डाँडामा त्यसलाई होमबलि गर्‌, जुन म तँलाई बताउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","त्यसैले अब्राहाम बिहानै उठेर गधामा काठी कसे, अनि आफ्‍ना दुई जवान मानिसहरू र आफ्‍नो छोरो इसहाकलाई साथमा लिए । उनले होमबलिको निम्‍ति दाउरा चिरे, त्यसपछि परमेश्‍वरले तिनलाई भन्‍नुभएको ठाउँतर्फ यात्रा सुरु गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तेस्रो दिन अब्राहामले माथि हेरे र टाढा त्‍यो ठाउँ देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","अब्राहामले आफ्‍ना जवान मानिसहरूलाई भने, “तिमीहरू गधासँग यहीँ बस, अनि म र यो केटो त्यहाँ जानेछौँ । हामी पूजा गर्नेछौँ र तिमीहरूकहाँ फेरि फर्केर आउनेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","त्यसपछि अब्राहामले होमबलिको निम्ति दाउरा लिए र आफ्‍नो छोरो इसहाकलाई बोकाए । उनले आगो र छुरी आफ्‍नो हातमा लिए अनि ती दुवै जना सँगसँगै गए । ");
INSERT INTO npiulb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाकले आफ्‍ना पिता अब्राहामलाई भने, “बुबा,” अनि तिनले भने, “म यहीँ छु, मेरो छोरा ।” त्‍यसले भन्‍यो, “आगो र दाउरा त यहाँ छन्, तर होमबलिको लागि थुमाचाहिँ खोइ?” ");
INSERT INTO npiulb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहामले भने, “मेरो छोरा, परमेश्‍वरले नै होमबलिको निम्‍ति थुमा जुटाइदिनुहुनेछ ।” अनि ती दुवै सँगसँगै गए । ");
INSERT INTO npiulb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","परमेश्‍वरले तिनलाई भन्‍नुभएको ठाउँमा पुगेपछि अब्राहामले त्‍यहाँ एउटा वेदी बनाएर दाउरा राखे । त्‍यसपछि तिनले आफ्‍नो छोरो इसहाकलाई बाँधेर वेदीमा दाउरामाथि राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","अब्राहामले आफ्‍नो छोरालाई मार्न छुरी उठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","त्यसपछि परमप्रभुका एक जना दूतले स्‍वर्गबाट तिनलाई भने, “ए अब्राहाम, अब्राहाम!” तिनले भने, “म यहीँ छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","उनले भने, “तेरो हात त्‍यस केटामाथि नउठा, न त त्‍यसलाई केही गर, आफ्‍नो एक मात्र छोरालाई पनि मबाट तैंले रोकेर राखिनस्‌ भन्‍ने देखेर तैँले परमेश्‍वरको भय मान्दोरहेछस् भनी मैले अब थाहा पाएँ ");
INSERT INTO npiulb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","।” अब्राहामले माथितिर हेरे र एउटा भेडा झाडीमा सीङ अल्‍झेर फसेको देखे । अब्राहामले गएर त्‍यस भेडालाई ल्‍याए, र तिनका छोराको सट्टामा त्‍यसैलाई होमबलि चढाए । ");
INSERT INTO npiulb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","यसकारण अब्राहामले त्‍यस ठाउँको नाउँ “परमप्रभुले जुटाउनुहुन्‍छ” राखे, र “परमप्रभुको डाँडामा जुटाइनेछ” भनी आजसम्म पनि भनिन्‍छ । ");
INSERT INTO npiulb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","परमप्रभुका दूतले दोस्रो पल्‍ट स्‍वर्गबाट अब्राहामलाई बोलाएर भने, ");
INSERT INTO npiulb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","यो परमप्रभुको घोषणा हो, “मैले आफ्‍नै नाउँमा शपथ खाएको छु, कि तैंले यो काम गरेकोले र तेरो छोरो, अर्थात्‌ तेरो एउटै छोरालाई पनि मबाट नरोकेकोले ");
INSERT INTO npiulb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","म निश्‍चय नै तँलाई आशिष्‌ दिनेछु र म तेरा सन्‍तानको वृद्धि गरेर आकाशका तारा र समुद्र किनारका बालुवासरह तुल्‍याउनेछु । तेरा सन्‍तानले आफ्‍ना शत्रुहरूका ढोकाहरू पार गर्नेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","तेरा सन्‍तानद्वारा पृथ्‍वीका सबै जातिहरू आशिषित्् हुनेछन्, किनकि तैंले मेरो वचन पालन गरिस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","त्‍यसैले अब्राहाम आफ्‍ना जवान मानिसहरूकहाँ फर्केर आए, र तिनीहरू बेर्शेबासम्‍म सँगसँगै गए, अनि उनी बेर्शेबामा बसोबास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","यी कुराहरू भएको केही समयपछि “मिल्‍काले पनि तपाईंका भाइ नाहोरबाट छोराहरू जन्‍माइन्‌” भन्‍ने कुरा अब्राहामले सुने । ");
INSERT INTO npiulb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","तिनीहरू जेठो ऊज, त्‍यसको भाइ बूज, र आरामका पिता कमूएल, ");
INSERT INTO npiulb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","र केसेद, हजो, पिलदाश, यिदलाप र बतूएल थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बतूएल रिबेकाका पिता भए । अब्राहामका भाइ नाहोरबाट मिल्‍काले जन्माएका आठ छोराहररू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","यीबाहेक रूमा नाउँ भएकी तिनकी भित्रिनीले पनि तेबह, गहम, तहस र माकालाई जन्‍माई । ");
INSERT INTO npiulb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एक सय सत्ताइस वर्ष बाँचिन्‌ । साराका जीवनमा वर्षहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","सारा कनान देशको किर्यत-अर्बा अर्थात्‌ हेब्रोनमा मरिन्‌ । अब्राहामले साराको निम्‍ति शोक र विलाप गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","त्यसपछि अब्राहाम आफ्नी पत्‍नीको लाश भएको ठाउँबाट उठे, र हेतका छोराहरूलाई यसो भने, ");
INSERT INTO npiulb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“म तपाईंहरूका बिचमा एक प्रवासी हुँ । मसँग भएको लाशलाई गाड्‌न चिहानको लागि तपाईंहरूसँग भएको कुनै जमिन मलाई दिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हेतका छोराहरूले अब्राहामलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“मालिक, हाम्रा कुरा सुन्‍नुहोस् । तपाईं हाम्रो बिचमा परमेश्‍वरका राजकुमार हुनुहुन्छ । हाम्रा चिहानमध्‍ये सबैभन्‍दा असलचाहिँ छानेर लाश गाड्‌नुहोस्‌ । तपाईंले लाशलाई गाड्नुहोस्, हामीमध्‍ये कसैले पनि आफ्‍नो चिहान तपाईंलाई दिन इन्‍कार गर्नेछैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तब अब्राहामले उठेर त्यस देशका मानिसहरू अर्थात् हेतका छोराहरूका अगि निहुरेर दण्‍डवत्‌ गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","तिनले तिनीहरूलाई यसो भने, “यदि मैले यो लाश गाड्न तपाईंहरूलाई मन्‍जुर छ भने मेरो कुरो सुन्‍नुहोस् र सोहोरका छोरा एप्रोनसित मेरो निम्‍ति बिन्‍ती गरिदिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","उनका खेतको छेउमा भएको आफ्‍नो मक्‍पेलाको ओडार मलाई बेच्‍न भनिदिनुहोस् । उनले त्यो जमिन पुरा दाममा गाड्ने ठाउँको निम्ति सार्वजनिक रूपमा मलाई बेचून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","त्‍यस बेला एप्रोन हेतका छोराहरूका माझमा बसिरहेका थिए, र जति जना उनका सहरको प्रवेशद्वारको अगाडि आएका थिए, ती सबैले सुन्‍ने गरी हित्ती एप्रोनले अब्राहामलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“होइन, मेरा प्रभु, मेरो कुरा सुन्‍नुहोस्‌ । म तपाईंलाई त्‍यो खेत र त्‍यसमा भएको ओडार पनि दिन्‍छु । मेरा मानिसहरूका छोराहरूकै सामुन्‍ने म त्‍यो तपाईंलाई दिन्‍छु। म तपाईंलाई लाश गाड्नको निम्ति त्यो दिन्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","अब्राहामले फेरि त्‍यस देशका मानिसहरूलाई दण्‍डवत्‌ गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","अनि तिनले त्‍यस ठाउँका मानिसहरूले सुन्‍ने गरी एप्रोनलाई भने, “तर यदि तपाईंको मन्‍जुरी भए मेरो कुरा सुन्‍नुहोस् । म त्‍यस जग्‍गाको मोल तिर्नेछु । मबाट पैसा लिनुहोस्, र म त्यहाँ लाश गाड्नेछु ");
INSERT INTO npiulb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","।” एप्रोनले अब्राहामलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मेरा प्रभु, मेरो कुरा सुन्‍नुहोस्‌ । जग्‍गाको मोल चाँदीका चार सय सिक्‍का हो, तर मेरो र तपाईंको बीचमा त्‍यो के हो र? लाशलाई गाड्‌नुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहामले एप्रोनको कुरा माने र तिनले एप्रोनलाई हेतका छोराहरूका सामुन्‍ने उनले भने जस्तै व्‍यापारीहरूमा प्रचलित तौलबमोजिम चाँदीका चार सय सिक्‍का जोखेर उनलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","यसरी मक्‍पेलामा मम्रेनेरको एप्रोनको खेत र त्‍यसभित्र भएका ओडार र रूखहरूसमेत एप्रोनले ");
INSERT INTO npiulb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","त्‍यस सहरका ढोकाको अगाडि आएकाहरू हेतका छोराहरू सबैका सामु अब्राहामको अधिकारमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","त्‍यसपछि अब्राहामले आफ्‍नी पत्‍नी सारालाई कनान देशमा मम्रेनेरको, अर्थात्‌ हेब्रोनमा भएको मक्‍पेलाक खेतको ओडारमा गाडे । ");
INSERT INTO npiulb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","यसरी त्‍यो खेत र त्‍यसमा भएको ओडारसमेत हित्तीहरूका तर्फबाट चिहानको रूपमा अब्राहामको अधिकारमा भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम दिन धेरै खाएर बुढा भइसकेका थिए र परमप्रभुले तिनलाई सबै कुरामा आशिष्‌ दिनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहामले आफ्‍नो घरको सबै भन्दा पुरानो र तिनीसँग भएका सबै कुराहरूका अख्‍तियार गर्ने प्रमुख नोकरलाई भने, “तेरो हात मेरो तिघ्रामुनि राख्‌ ");
INSERT INTO npiulb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","अनि तैँले अहिले म बसेको ठाउँका कनानीका छोरीहरूमध्‍ये कसैलाई पनि मेरो छोरोकी पत्‍नीको रूपमा ल्याइदिने छैनस् भनी म तँलाई स्‍वर्ग र पृथ्‍वीका परमप्रभु परमेश्‍वरको यो शपथ खान लाउँछु । ");
INSERT INTO npiulb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","तर तैँले मेरो देशमा मेरै कुटुम्‍बकहाँ गएर मेरो छोरा इसहाकको लागि एउटी पत्‍नी ल्‍याउनेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","त्यस नोकरले तिनलाई भन्यो, “यदि त्‍यो स्‍त्री मेरो पछि लागेर यस देशमा आउने इच्‍छा गरिन भने मैले के गर्ने? के मैले तपाईंका छोरालाई जुन देशबाट तपाईं आउनुभयो त्‍यहीँ नै लैजाने?” ");
INSERT INTO npiulb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहामले त्‍यसलाई भने, “तैँले मेरो छोरालाई त्‍यहाँ फर्काएर नलानू ! ");
INSERT INTO npiulb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","मलाई मेरा पिताको घर र मेरो जन्‍मभूमिबाट यहाँ ल्‍याउनुहुने स्‍वर्ग र पृथ्‍वीका परमप्रभु परमेश्‍वरले शपथ खाई मसँग यसो भनेर प्रतिज्ञा गर्नुभएको छ, ‘तेरा सन्‍तानलाई म यो देश दिनेछु,’ उहाँले नै आफ्‍ना दूत तेरो अगिअगि पठाउनुहुनेछ, र तैँले मेरो छोराको लागि त्‍यहाँबाट एउटी पत्‍नी ल्‍याउनेछस् । ");
INSERT INTO npiulb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","त्‍यो केटी तेरो पछि आउन इच्‍छा गरिन भने तँ मेरो यो शपथबाट मुक्‍त हुनेछस् । केवल तैँले मेरो छोरालाई चाहिँ त्‍यहाँ फर्काएर नलैजानू ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","त्यसैले त्‍यस नोकरले आफ्‍ना मालिक अब्राहामको तिघ्रामुनि हात राखेर यस विषयमा तिनीसित शपथ खायो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","आफ्‍ना मालिकका दशवटा ऊँट लिएर त्यो नोकर बिदा भयो । त्यसले आफ्ना मालिकबाट सबै किसिमका सौगात पनि लिएर गयो । ऊ बिदा भएर अराम-नाहारैमतिर नाहोरको सहरमा गयो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","त्यसले ऊँटहरूलाई सहरको बाहिर इनारको नजिकै घुँडा टेक्‍न लगायो । त्यो साँझपख स्‍त्रीहरू पानी भर्न आउने बेला थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","अनि त्यसले प्रार्थना गर्‍यो, “हे परमप्रभु मेरा मालिकका परमेश्‍वर, आज मलाई मेरो काममा सफल गराएर मेरा मालिक अब्राहामलाई आफ्‍नो दया देखाउनुहोस्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","हेर्नुहोस्, म यो इनारनेर उभिरहेको छु, र सहरका मानिसहरूका छोरीहरू पानी भर्नलाई आउँदै छन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","यसैले यसो होस्‌: जुन कन्‍यालाई म ‘तिम्रो गाग्रो मतिर पानी पिउनलाई ढल्‍काइदेऊ’ भनुँला, र जसले मलाई ‘खानुहोस्, म तपाईंका ऊँटहरूलाई पनि खुवाइदिन्‍छु’ भन्‍छिन्, तिनलाई नै तपाईंले आफ्‍ना दास इसहाकको निम्‍ति रोज्‍नुभएको होस्‌ । तपाईंले मेरा मालिकलाई करारको दया देखाउनुभएको रहेछ भन्‍ने म त्‍यसैबाट थाहा पाउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","त्‍यसले यो भनिसकेको पनि थिएन, रिबेका काँधमा गाग्रो राखेर आइन्‌ । तिनी अब्राहामका भाइ नाहोरकी पत्‍नी मिल्‍काको छोरो बतूएलकी छोरी थिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ती जवान स्‍त्री अत्‍यन्‍त सुन्‍दरी र कुमारी थिइन् । तिनको कुनै मानिससित पनि सहवास भएको थिएन । इनारमा ओर्लेर तिनले गाग्रोमा पानी भरिन्‌ र उक्‍लेर आइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तब त्‍यो नोकर तिनलाई भेट गर्न दगुर्‍यो र भन्‍यो, “कृपया तिम्रो गाग्रोबाट मलाई अलिकता पानी पिउन देऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","तिनले “हजूर, पिउनुहोस्‌” भनेर तुरुन्‍तै गाग्रो झारिन्, र आफ्‍नो हातमा गाग्रो राखेर त्‍यसलाई पानी पियाइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","त्‍यसलाई पिउन दिइसकेपछि तिनले भनिन्, “तपाईंका ऊँटहरूका निम्‍ति पनि तिनीहरूले पिई नसकुञ्‍जेल म पानी उघाएर दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","तब तिनले झट्टै आफ्‍नो गाग्रोको पानी डुँडमा खन्‍याएर फेरि पानी उघाउन इनारतिर दौडेर गइन्, र तिनले सबै ऊँटहरूका निम्‍ति पनि पानी उघाइदिइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","त्‍यो मानिसचाहिँ परमप्रभुले आफ्‍नो यात्रा सफल गरिदिनुभएको हो कि होइन भनी थाहा पाउनलाई चुप लागेर तिनलाई हेरिरह्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ऊँटहरूले पानी खाइसकेपछि त्‍यस मानिसले छ ग्राम तौलका सुनको एउटा नत्‍थ र एक सय ग्राम जति तौलका सुनका बालाहरू झिकेर ");
INSERT INTO npiulb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","भन्‍यो, “तिमी कसकी छोरी हौ? कृपया मलाई भन, के तिम्रा बुबाको घरमा रात गुजार्नको निम्ति हाम्रो निम्ति ठाउँ छ?” ");
INSERT INTO npiulb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","तिनले त्‍यसलाई भनिन्, “म नाहोरबाट मिल्‍काले जन्‍माएका बतूएलकी छोरी हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","तिनले त्‍यसलाई अझै भनिन्, “हामीसँग दाना र पराल प्रशस्‍त छन्, र रात गुजार्नलााई कोठा पनि छन्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब त्‍यस मानिसले आफ्‍नो शिर निहुराएर परमप्रभुको आराधना गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","त्यसले भन्यो, “परमप्रभु, मेरा मालिक अब्राहामका परमेश्‍वर धन्‍यका हुनुहुन्‍छ, जसले मेरा मालिकप्रतिको करारको दया र विश्‍वस्‍तता त्‍याग्‍नुभएको छैन । परमप्रभुले नै मलाई डोर्‍याएर मेरा मालिकका कुटुम्‍बको घरमा ल्‍याइदिनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब ती कन्‍या गइन् र आफ्‍नी आमाका परिवारलाई सबै कुरा बताइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबेकाका लाबान नाउँ भएका एक जना दाजु थिए । लाबान दौडेर बाहिर बाटोमा इनारनेर भएका त्‍यस मानिसतिर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","जब उनले आफ्‍नी बहिनीको नाकमा नत्‍थ र हातमा बाला देखे र “त्‍यस मानिसले मलाई यसो भन्‍यो” भन्‍ने कुरा आफ्‍नी बहिनीबाट सुने, तब उनी त्‍यस मानिसकहाँ गए, त्यो मानिस इनारको छेउमा ऊँटहरूका नजिकै उभिइरहेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","त्यसपछि लाबानले भने, “हे परमप्रभुका आशीर्वादी जन, आउनुहोस्‌ । किन बाहिरै उभिरहनुहुन्‍छ? मैले तपाईंको निम्‍ति घर र ऊँटहरूका लागि ठाउँ तयार पारिराखेको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","तब त्‍यो मानिस घरमा गयो र ऊँटहरूका भारीहरू झार्‍यो । उँटहरूलाई पराल र दाना दिइयो, अनि त्यस मानिस र त्‍यससित हुने मानिसहरूका निम्‍ति खुट्टा धुने पानी पनि दिइयो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तिनीहरूले त्‍यसको सामु खानेकुरा पनि राखिदिए, तर त्‍यसले भन्‍यो, “जबसम्‍म मेरो समाचार म भन्‍दिनँ तबसम्‍म म केही खान्‍नँ ।” तब लाबानले भने, “ल, भन्‍नुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","त्‍यसले भन्‍यो, “म अब्राहामको एक नोकर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","परमप्रभुले मेरा मालिकलाई धेरै आशिष्‌ दिनुभएको छ र तिनी एक ठुला मानिस भएका छन्‌ । उहाँले तिनलाई बगालहरू र बथानहरू, सुनचाँदी, दास-दासी, ऊँटहरू र गधाहरू दिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","मेरा मालिककी पत्‍नी साराले बुढेसकालमा तिनको निम्‍ति एक जना छोरो जन्माइन्, र उनैलाई तिनले आफ्‍ना सबै कुरा दिएका छन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","मेरो मालिकले मलाई यसो भनेर शपथ खान लाएका छन्, ‘तैँले मेरो छोराको लागि म अहिले बसेको देशका कनानीहरूका छोरीहरूमध्‍ये कुनै पनि विवाह गर्नलाई नल्‍याउनू । ");
INSERT INTO npiulb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","बरु, तैँले मेरा पिताका परिवार र मेरा कुटुम्बहरूकहाँ गएर मेरो छोराको निम्ति पत्‍नी ल्याउनू ।' ");
INSERT INTO npiulb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","मैले मेरो मालिकलाई भनेँ, 'सायद त्‍यो स्‍त्री मेरो साथमा आउन मान्दिन होला?' ");
INSERT INTO npiulb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","तिनले मलाई भने, ‘जुन परमप्रभुको सामुन्‍ने म हिँड्‌छु, उहाँले नै आफ्‍ना दूत तँसित पठाउनुहुनेछ, र तेरो कार्य सफल हुनेछ, ताकि तैैँले मेरो कुटुम्‍ब र मेरा पिताको घरबाट मेरो छोराको लागि एउटी पत्‍नी ल्‍याउनेछस्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तर तँ मेरो कुटुम्‍बकहाँ पुगिस् र तिनीहरूले तिनलाई दिएनन् भने तँ मेरो यस शपथबाट छुट्‌नेछस्‌ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","यसैले आज इनारमा आइपुगेर मैले यसो भनेँ, 'हे परमप्रभु, मेरा मालिक अब्राहामका परमेश्‍वर, मेरो यात्रा सफल गराइदिने तपाईंको इच्छा भए, ");
INSERT INTO npiulb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","म इनारको छेउमा उभिरहेछु, पानी भर्नलाई आउने स्‍त्रीलाई मैले 'तिम्रो गाग्रोबाट मलाई अलिकता पानी पिउन देऊ,' भन्‍दा ");
INSERT INTO npiulb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","तिनले मलाई “खानुहोस्, र म तपाईंका ऊँटहरूलाई पनि पानी उघाइदिनेछु,” भनिन् भने, मेरा मालिकका छोराको लागि परमप्रभुले ठहराउनुभएको स्‍त्री त्यही होस् । ");
INSERT INTO npiulb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“मैले यी कुरा मनमनै भनिसक्‍न अगि नै, हेर्नुहोस्, रिबेका काँधमा आफ्‍नो गाग्रो बोकेर आइन्, र इनारमा ओर्लेर पानी उघाइन्‌ । मैले तिनलाई भनेँ, ‘कृपया मलाई पानी पिउन देऊ ।’ ");
INSERT INTO npiulb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“तिनले तुरुन्‍तै आफ्‍नो काँधबाट गाग्रो झारेर भनिन्, ‘पिउनुहोस् र म तपाईंका ऊँटहरूका निम्‍ति पनि पानी पिउन दिनेछु ।’ तब मैले पानी पिएँ, र तिनले मेरा ऊँटहरूलाई पनि पानी पिउन दिइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“मैले तिनलाई ‘तिमी कसकी छोरी हौ?’ भनी सोधेँ । “तिनले भनिन्, ‘नाहोर र मिल्‍काका छोरा बतूएलकी छोरी हुँ ।’ तब मैले तिनको नाकमा नत्‍थ र हातमा बालाहरू लगाइदिएँ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","अनि मैले आफ्‍नो शिर निहुराएर परमप्रभुको आराधना गरेँ, र मेरा मालिक अब्राहामका परमप्रभु परमेश्‍वरलाई धन्‍यको भनेँ, जसले मेरा मालिककै भाइकी नातिनी तिनका छोराको निम्‍ति पत्ता लगाउन मलाई ठिक बाटोमा डोर्‍याउनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","अब तपाईंहरू मेरा मालिकसँग करारको विश्‍वासयोग्‍यता र भरोसायोग्य व्‍यवहार गर्नुहुन्‍छ भने मलाई भन्‍नुहोस्‌ । होइन भने पनि मलाई भन्‍नुहोस्, र म दाहिने-देब्रे जता हुन्‍छ लागुँला ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तब लाबान र बतूएलले जवाफ दिए, “यो कुरा परमप्रभुबाट नै हुन आएको हो । हामी तपाईंलाई खराब अथवा असल केही भन्‍न सक्‍दैनौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","हेर्नुस्, रिबेका तपाईँको सामुन्‍ने छे । त्‍यसलाई लिएर जानुस्, र परमप्रभुले भन्‍नुभएजस्‍तै गरी त्यो तपाईंका मालिकका छोराकी पत्‍नी होस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","तिनीहरूका कुरा सुनेपछि अब्राहामको नोकरले भूइँमा निहुरेर परमप्रभुलाई दण्‍डवत्‌ गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","तब त्‍यसले सुन र चाँदीका गहनाहरू र लुगाहरू ल्‍याएर रिबेकालाई दियो । त्‍यसले तिनका दाजु र आमालाई पनि मूल्‍यवान्‌ उपहारहरू दियो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","तब त्‍यो र त्‍यसका साथमा भएका मानिसहरूले खाए र पिए । तिनीहरूले त्‍यो रात त्‍यहीँ बिताए अनि बिहान उठेपछि त्‍यसले भन्‍यो, “मेरा मालिककहाँ जान अब मलाई बिदा दिनुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबेकाका दाजु र आमाले भने, “कन्‍यालाई कम्तीमा पनि दस दिन यहीँ हामीसँग रहन दिनुहोस्‌ । त्‍यसपछि तिनी गए हुन्‍छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","तर त्‍यसले तिनीहरूलाई भन्‍यो, “परमप्रभुले मेरो यात्रा सफल गराउनुभएको हुनाले मलाई नअलमल्‍याउनुहोस्‌ । मलाई जान दिनुहोस्, र म मेरा मालिककहाँ जानेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तिनीहरूले भने, “हामी कन्‍यालाई बोलाउँछौँ र तिनलाई सोध्छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","अनि तिनीहरूले रिबेकालाई डाकेर सोधे, “के तिमी यस मानिसको साथमा जान्‍छ्यौ?” तिनले भनिन्, “म जान्‍छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","यसैकारण तिनीहरूले आफ्‍नी बहिनी रिबेकालाई तिनकी सेविकासँगै अब्राहामको नोकर र त्‍यसका मानिसहरूका साथमा पठाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","तिनीहरूले रिबेकालाई आशिष्‌ दिएर भने, “हे हाम्री बहिनी, तिमी हजारौँ हजारका आमा होऊ, र तिम्रा सन्‍तानले तिनीहरूसँग दुश्‍मनी गर्नेहरूका सहरका प्रवेशद्वारहरू कब्‍जा गरून्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रिबेका उठिन् र तिनका सहेलीहरूसँग ऊँटहरूमा चढेर त्‍यस मानिसको पछि लागिन् । यसरी रिबेकालाई लिएर त्‍यो नोकर आफ्‍नो बाटो लाग्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","अब इसहाक नेगेवमा बसोबास गरिरहेका थिए, उनी बेअर-लहै-रोइबाट भर्खरै आएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","इसहाक साँझपख एकाग्रताका निम्ति बाहिर निस्‍केका थिए । उनले आँखा उठाएर हेर्दा ऊँटहरू आइरहेका देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबेकाले पनि आँखा उठाएर हेर्दा इसहाकलाई देखिन्, र ऊँटबाट ओर्लिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","तिनले नोकरलाई भनिन्, “हामीलाई भेट्‌न बाहिर हिँड्‌दै आउने मानिस को हुन्‌?” त्‍यस नोकरले भन्‍यो, “उनी त मेरा मालिक हुन्‌ ।” तब रिबेकाले घुम्‍टो हालेर आफ्‍नो अनुहार छोपिन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","त्‍यसपछि आफूले गरेका सबै काम त्‍यस नोकरले इसहाकलाई बतायो । ");
INSERT INTO npiulb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","इसहाकले रिबेकालाई आफ्‍नी आमा साराको पालमा लगे, र विवाह गरे । अनि तिनी उनकी पत्‍नी भइन्, र उनले तिनलाई प्रेम गरे । यसरी आफ्‍नी आमाको मृत्‍युपछि इसहाकले सान्‍त्‍वना पाए ।' ");
INSERT INTO npiulb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामले अर्की एउटी पत्‍नी विवाह गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","तिनको नाउँ कतूरा थियो । तिनले अब्राहामबाट जिम्रान, योक्षान, मदान, मिद्यान, यिशबाक र शूहलाई जन्‍माइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान शेबा र ददानका पिता भए । अश्‍शूरी, लतूशी र लऊम्‍मीहरू ददानका सन्‍तान थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यानका छोराहरूचाहिँ एपा, एपेर, हानोक, अबीदा र एल्‍दा थिए । यी सबै कतूराका सन्‍तान थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहामले आफूसँग भएका सबै थोक इसहाकलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","तर आफू जीवित छँदै तिनका उपपत्‍नीपट्टिका छोराहरूलाई उनले उपहारहरू दिए, र आफ्‍ना छोरा इसहाकबाट छुट्‍याएर तिनीहरूलाई पूर्व देशतिर पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम जम्‍मा एक सय पचहत्तर वर्षसम्‍म बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहाम पुरा जीवन जिएर बुढ़ेसकालमा मरे, र आफ्‍ना मरेका पिता-पुर्खाहरूसँग मिल्‍न गए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","तिनका छोराहरू इसहाक र इश्‍माएलले तिनलाई हित्ती सोहोरको छोरा एप्रोनको खेतमा भएको मम्रेनजिकको मक्‍पेलाको ओडारमा गाडे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","त्‍यो खेत अब्राहामले हेतका छोराहरूबाट किनेका थिए । अब्राहाम आफ्‍नी पत्‍नी सारासित त्‍यहीँ नै गाडिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहामको मृत्‍युपछि परमेश्‍वरले तिनका छोरा इसहाकलाई आशिष्‌ दिनुभयो, र इसहाक बेअर-लहै-रोइ नजिकै बसोबास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","साराकी कमारी मिश्री हागारपट्टिबाट जन्‍मेको अब्राहामको छोरो इश्‍माएलका सन्तान यिनै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","जन्‍म क्रमको सूचीअनुसार इश्‍माएलका छोराहरूका नाउँ यी नै थिएः इश्‍माएलको जेठो छोरो नबायोत, केदार, अदबेल, ");
INSERT INTO npiulb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिब्‍साम, मिश्‍मा, दुमा, मस्‍सा, ");
INSERT INTO npiulb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश र केदमा । ");
INSERT INTO npiulb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्‍माएलका छोराहरू यी नै थिए । तिनीहरूका बस्‍ती र छाउनीहरूअनुसार ती बाह्र कुलनायकका नाउँ यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्‍माएलको जम्‍मा उमेर एक सय सैँतिस वर्ष हुँदा तिनको मृत्‍यु भयो र तिनी आफ्‍ना पिता-पुर्खाहरूसँगै मिल्‍न गए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","तिनीहरूको बसोबास मिश्रको सिमानानजिक भएको अश्‍शूर देशतिर पर्ने हवीलादेखि शूरसम्‍म थियो । तिनीहरू एक-अर्काको शत्रुतामा बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामका छोरा इसहाकको वृत्तान्‍त यही हो । अब्राहाम इसहाकका पिता भए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","पद्दन-आरामका अरामी बतूएलकी छोरी अरामी लाबानकी बहिनी रिबेकासँग विवाह गर्दा इसहाक जम्मा चालिस वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","तिनी बाँझी भएकी हुनाले इसहाकले आफ्‍नी पत्‍नीको निम्‍ति परमप्रभुसँग प्रार्थना गरे । परमप्रभुले तिनको प्रार्थना सुन्‍नुभयो, र तिनकी पत्‍नी रिबेका गर्भवती भइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","तिनको गर्भमा भएका बालकहरू एक-अर्कासँग लड्न लागे, र तिनले भनिन् “मलाई किन यस्‍तो भयो?” तिनले यसको बारेमा परमप्रभुसँग सोधिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","परमप्रभुले तिनलाई भन्‍नुभयो, “तेरो कोखमा दुई जाति छन्, तेरो गर्भदेखि नै दुई जाति छुट्टिनेछन् । एक जाति अर्कोभन्‍दा बलवान्‌ हुनेछ, र जेठाले कान्‍छाको सेवा गर्नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","तिनको सुत्‍केरी हुने बेला आउँदा तिनको कोखमा जुम्‍ल्‍याहा थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","जेठोचाहिँ शरीरभरि रौँको लुगा लगाएजस्‍तै रातो वर्णको जन्‍म्‍यो । तिनीहरूले त्‍यसको नाउँ एसाव राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","त्‍यसपछि त्‍यसको भाइ बाहिर निस्क्यो । त्यसको हातले एसावको कुर्कुच्‍चा समातिरहेको थियो । त्‍यसको नाउँ याकूब राखियो । इसाहककी पत्‍नीले तिनीहरूलाई जन्‍माउँदा तिनी साठी वर्ष पुगेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","बालकहरू बढे, र एसावचाहिँ सिपालु सिकारी र मैदानमा डुलिहिँड्‌ने मानिस भए, र याकूबचाहिँ पालमा बसिरहने शान्‍त स्‍वभावका मानिस भए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाकले एसावलाई माया गर्थे, किनभने उनले शिकार गरेर ल्‍याएको मासु तिनले खान पाउँथे । तर रिबेकाले चाहिँ याकूबलाई माया गर्थिन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","याकूबले सुरुवा पकाए । एसाव मैदानबाट आए, र उनी भोकले कमजोर भएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","एसावले याकूबलाई भने, “कृपया, मलाई त्‍यो रातो सुरुवा खान देऊ, म थकित छु ।” यसैकारण उनलाई एदोम भनियो । ");
INSERT INTO npiulb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकूबले भने, “पहिले तपाईंको ज्‍येष्‍ठ-अधिकार मलाई बेच्‍नुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसावले भने, “हेर, म त मर्नै आँटेको छु । मलाई त्‍यो ज्‍येष्‍ठ-अधिकारको के काम?” ");
INSERT INTO npiulb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकूबले भने, “पहिले मसँग शपथ खानुहोस् ।” तब एसावले शपथ खाए, र यसरी उनले आफ्‍नो ज्‍येष्‍ठ-अधिकार याकूबलाई बेचे । ");
INSERT INTO npiulb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","याकूबले एसावलाई रोटी र दालको सुरुवा दिए । एसावले खानपान गरे अनि उठेर आफ्‍नो बाटो लागे । यसरी एसावले आफ्‍नो ज्‍येष्‍ठ-अधिकारलाई लत्त्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","अब्राहामको समयमा परेको पहिलो अनिकालबाहेक त्‍यस देशमा अर्को अनिकाल पनि पर्‍यो । इसहाक पलिश्‍तीहरूका राजा अबीमेलेककहाँ गरार देशमा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","तिनीकहाँ देखा परेर परमप्रभुले भन्‍नुभयो, “तल मिश्रमा नजा, मैले तँलाई बसोबास गर् भनेकै ठाउँमा बस्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","यही ठाउँमा बसोबास गर्, र म तँसँग रहनेछु, र तँलाई आशिष्‌ दिनेछु, किनकि म यी देशहरू तँ र तेरा सन्तानलाई दिनेछु, अनि तेरो बुबा अब्राहामसँग मैले शपथ खाएर दिएको प्रतिज्ञा म पुरा गर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","तेरा सन्‍तानलाई आकाशका ताराहरूझैँ बढाउनेछु, र तिनीहरूलाई यी सबै देश दिनेछु । संसारका सबै जातिहरूले तेरै सन्‍तानहरूद्वारा आशिष्‌ पाउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","अब्राहामले मेरो वचन पालन गरेको र मैले दिएका आदेशहरू, मेरा आज्ञाहरू, मेरा नियमहरू र मेरा विधिविधानहरूको पालन गरेको हुनाले म यो गर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","यसैकारण इसहाक गरारमा नै बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","त्‍यस ठाउँका मानिसहरूले तिनकी पत्‍नीको विषयमा सोधपुछ गर्दा तिनले “तिनी मेरी बहिनी हुन्‌” भने । किनकि तिनले यस्तो सोचे, “रिबेकालाई प्राप्‍त गर्नको लागि यस ठाउँका मानिसहरूले मलाई मार्नेछन्, किनकी तिनी धेरै सुन्दरी छिन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","इसहाक त्‍यहाँ बसेको धेरै दिनपछि पलिश्‍तीहरूका राजा अबीमेलेकले झ्‍यालबाट हेर्न पुगे । इसहाक आफ्‍नी पत्‍नी रिबेकासँग प्रेम-क्रीडा गरिरहेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","अबीमेलेकले इसहाकलाई आफूकहाँ बोलाएर भने, “हेर, तिनी पक्‍कै पनि तिम्री पत्‍नी हुन् । किन तिमीले ‘तिनी मेरी बहिनी हुन्‌’ भन्‍यौ?” इसहाकले उनलाई भने, “किनभने तिनलाई प्राप्‍त गर्नको निम्ति कसैले मार्लान्‌ भन्‍ने मैले सोचें ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेकले भने, “तिमीले हामीसँग यो के गरेको? कुनै मानिसले तिम्री पत्‍नीसित सजिलै नराम्रो कर्म गर्ने थियो, र तिमीले हामीमाथि दोष ल्‍याउने थियौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","यसकारण अबीमेलेकले सबै मानिसहरूलाई चेताउनी दिएर भने, “यी मानिस अथवा यिनकी पत्‍नीलाई छुने जुनसुकै मानिसलाई पनि निश्‍चय नै मृत्‍युदण्‍ड हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकले त्यस देशमा बालीनाली लगाए, र त्‍यही साल सय गुणा कटनी गरे । किनभने परमेश्‍वरले तिनलाई आशिष्‌ दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","तिनी धनी भए, र अत्‍यन्‍तै धनाढ्य नहुञ्‍जेलसम्म झनझन बढेर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","तिनका धेरै भेडाबाख्रा, गाईवस्तु र ठुलो परिवार भयो । यसैकारण पलिश्‍तीहरूले तिनको डाह गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","तिनका पिता अब्राहामको पालोमा उनका नोकरहरूले खनेका सबै इनारहरू पलिश्‍तीहरूले ढुङ्गा-माटोले पुरेर रोकिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","त्‍यसपछि अबीमेलेकले इसहाकलाई भने, “हामीहरूबाट अब तिमी गइहाल, किनभने तिमी हामीभन्दा ज्‍यादै शक्तिशाली छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","त्यसैले इसहाक त्‍यहाँबाट निस्‍केर गए अनि गरारको बेँसीमा आफ्‍नो पाल टाँगेर बसोबास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","तिनले आफ्‍ना पिताका पालोमा तिनीहरूले खनेका इनारहरू फेरि खने । अब्राहामको मृत्‍युपछि पलिश्‍तीहरूले ती रोकिदिएका थिए । अनि तिनले ती इनारहरूलाई आफ्‍ना पिताले राखेकै नाउँ राखिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाकका नोकरहरूले बेँसीमा खन्‍दा बगिरहेको पानीको मूल भेट्टाए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तर गरारका गोठालाहरूले इसहाकका गोठालाहरूसँग झगडा गरेर भने “यो पानी हाम्रो हो ।” यसकारण इसहाकले त्‍यस इनारको नाउँ एसेक राखे, किनभने तिनीहरूले उनीसँग झगडा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","तब तिनीहरूले अर्को इनार खने, र त्‍यसमा पनि तिनीहरूले झगडा गरे । यसकारण तिनले त्‍यसको नाउँ सित्‍ना राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तिनी त्यो ठाउँ छोडेर गए अनि तिनले अर्को इनार खने, तर तिनीहरूले त्‍यसमा चाहिँ झगडा गरेनन् । यसकारण तिनले त्‍यसको नाउँ रहोबोत राखेर यसो भने, “अब परमप्रभुले हामी निम्ति बस्‍ने ठाउँ दिनुभएको छ, र हामी यस ठाउँमा फल्‍दो-फुल्‍दो हुनेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","त्‍यसपछि इसहाक बेर्शेबामा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","परमप्रभु त्‍यही रात तिनीकहाँ देखा पर्नुभयो अनि भन्‍नुभयो, “म तेरो पिता अब्राहामका परमेश्‍वर हुँ । नडरा, किनभने म तँसँग छु र म तँलाई आशिष्‌ दिनेछु । अनि मेरो दास अब्राहामको खातिर म तेरा सन्‍तानको वृद्धि गराउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","इसहाकले त्‍यहाँ एउटा वेदी बनाएर परमप्रभुका नाउँको पुकारा गरे । तिनले आफ्‍नो पाल त्‍यहीँ नै टाँगे, र तिनका नोकरहरूले त्यहाँ एउटा इनार खने । ");
INSERT INTO npiulb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","एक दिन अबीमेलेक आफ्‍ना मित्र अहुज्‍जत र आफ्‍नो फौजका सेनापति पीकोललाई साथमा लिएर गरारबाट तिनीकहाँ आए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाकले तिनीहरूलाई भने, “घृणा गरेर तपाईंहरूले आफ्नो बिचबाट मलाई निकाल्‍नुभयो, अनि तपाईंहरू अहिले किन मकहाँ आउँदै ");
INSERT INTO npiulb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","हुनुहुन्छ?” त्यसपछि तिनीहरूले भने, “हामीले प्रस्टै देख्‍यौँ कि परमप्रभु तपाईंसँग हुनुहुन्‍छ । यसैले हाम्रा बिचमा, अर्थात्‌ तपाईं र हाम्रा बिचमा एउटा सम्‍झौता होस्‌ भन्‍ने हामीले निर्णय गर्‍यौँ, ");
INSERT INTO npiulb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ताकि जसरी हामीले तपाईंको कुनै हानी गरेनौँ र तपाईंसँग राम्रो व्यवहार गर्‍यौँ अनि तपाईंलाई शान्तिमा पठायौँ । त्यसरी नै तपाईंले पनि हाम्रो कुनै हानि गर्नुहुनेछैन । तपाईं साँच्‍चै नै परमप्रभुबाट आशिषित् हुनुहुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","त्यसैले इसहाकले तिनीहरूका निम्‍ति भोज तयार गरे, र तिनीहरूले खाए र पिए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","तिनीहरू बिहान सबेरै उठे र आपसमा शपथ खाए । अनि इसहाकले तिनीहरूलाई बिदा दिए, र तिनीहरूले उनलाई शान्‍तिमा छाडेर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","त्‍यही दिन इसहाकका नोकरहरू आएर तिनीहरूले खनेका इनारको विषयमा तिनलाई बताए । तिनीहरूले भने, “हामीले पानी भेट्टाएका छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तिनले त्‍यस इनारको नाउँ शिबा राखे, यसकारण त्‍यस सहरको नाउँ आजसम्‍म पनि बेर्शेबा नै छ । ");
INSERT INTO npiulb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","चालिस वर्षको हुँदा एसावले हित्ती बेरीकी छोरी यहूदीत र हित्ती एलोनकी छोरी बासमतलाई विवाह गरी ल्‍याए । ");
INSERT INTO npiulb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","तिनीहरूले इसहाक र रिबेकाको जीवनमा दुःख ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","जब इसहाक वृद्ध भए र तिनका आँखा कमजोर भएर देख्‍न नसक्‍ने भए, तब तिनले आफ्‍ना जेठा छोरा एसावलाई बोलाएर भने, “ए मेरो छोरो ।” उनले तिनलाई जवाफ दिए, “हजुर, म यहीँ छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","तिनले भने, “हेर्, म वृद्ध भएँ । मेरो मर्ने दिनको बारेमा मलाई थाहा छैन । ");
INSERT INTO npiulb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","अब तेरा हतियारहरू, अर्थात्‌ तेरो ठोक्रो र धनु लिएर मैदानमा जा, र मेरो निम्‍ति सिकार गर् । ");
INSERT INTO npiulb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मलाई मनपर्ने स्‍वादिष्‍ठ तरकारी बनाई मकहाँ ले ताकि यो खाएर मेरो मृत्‍युअगि म तँलाई आशिष्‌ दिऊँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","इसहाकले आफ्नो छोरो एसावसँग कुरा गरेको रिबेकाले सुनिन् । एसाव शिकार मारेर ल्‍याउन मैदानमा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रिबेकाले आफ्‍ना छोरा याकूबलाई भनिन्, “हेर्, तेरा पिताले तेरो दाजु एसावसँग यसो भनेर कुरा गरेको मैले सुनेँ । ");
INSERT INTO npiulb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘सिकार मारेर मकहाँ ले र मलाई मनपर्ने स्‍वादिष्‍ठ तरकारी बना ताकि यो खाएर मेरो मृत्‍युअगि परमप्रभुको सामुन्‍ने तँलाई आशिष्‌ दिन सकूँ ।’ ");
INSERT INTO npiulb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","यसकारण यसकारण ए मेरो छोरो, मैले तँलाई दिएका आज्ञा मान् । ");
INSERT INTO npiulb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","बथानमा गएर दुईवटा असल पाठा लिएर आइज, र म तेरा बुबालाई मनपर्ने स्‍वादिष्‍ठ तरकारी बनाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","अनि तैंले त्‍यो तेरा बुबाकहाँ लैजा, ताकि तिनले यो खाएर आफ्‍नो मृत्‍युअगि तँलाई आशिष्‌ देऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूबले आफ्‍नी आमा रिबेकालाई भने, “हेर्नुहोस्, मेरा दाजु एसाव रौँ नै रौँ भएका मानिस हुन्‌, र मचाहिँ रौँ नभएको छु । ");
INSERT INTO npiulb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","सायद मेरा पिताले मलाई छाम्‍नुहुनेछ, र उहाँको सामु म छली देखिनेछु । मैले ममाथि आशिष्‌ होइन, सराप ल्याउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","तिनकी आमाले तिनलाई भनिन्, “हे मेरो छोरो, जुनसुकै सराप भए पनि त्यो ममाथि नै परोस्‌ । केवल मेरो कुरा मान्, र गएर ती मकहाँ ले ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","तब तिनी गएर ती पाठा ल्‍याए र आमालाई दिए, र तिनकी आमाले याकूबका बुबालाई मनपर्ने स्‍वादिष्‍ठ तरकारी तयार गरिन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","रिबेकाले घरमा भएका आफ्‍ना जेठो छोरो एसावका असल लुगाहरू झिकेर आफ्नो कान्‍छा छोरो याकूबलाई लगाइदिइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","बाख्राका पाठाका छालाहरू तिनले याकूबका हात र घाँटीका रौँ नभएका भागमा लगाइदिइन्, ");
INSERT INTO npiulb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","अनि आफूले तयार पारेका स्‍वादिष्‍ठ तरकारी र रोटी आफ्‍ना छोरा याकूबका हातमा दिइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","याकूबले आफ्‍ना पिताकहाँ गएर भने, “बुबा ।” इसहाकले भने, “हँ, तँ को होस्‌?” ");
INSERT INTO npiulb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूबले आफ्‍ना पितालाई भने, “म तपाईंको जेठो छोरो एसाव हुँ । तपाईंले मलाई भनेबमोजिम मैले गरेको छु । अब उठेर बस्‍नुहोस्, र मैले ल्‍याएको सिकारको मासु खानुहोस्, र मलाई आशिष्‌ दिनुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाकले आफ्‍ना छोरालाई भने, “मेरो छोरो, कसरी तैँले यति चाँडै त्‍यो भेट्टाउन सकिस्‌?” तिनले भने, “परमप्रभु तपाईंका परमेश्‍वरले यसलाई मकहाँ ल्याउनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","इसहाकले याकूबलाई भने, “मेरो छोरो, नजिकै आइज, तँ मेरो छोरो एसाव होस्‌ कि होइनस्‌ म छामेर थाहा पाउन सकूँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याकूब आफ्‍ना पिताको नजिकै गए, र इसहाकले तिनलाई छामेर भने, “सोर त याकूबको हो, तर हातहरू त एसावकै हुन्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","तिनका हातहरू तिनका दाजु एसावकै हातजस्‍ता रौँ नै रौँ भएका हुनाले इसहाकले तिनलाई चिनेनन्‌, त्यसैले इसहाकले तिनलाई आशिष्‌ दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","इसहाकले सोधे, “के तँ साँच्‍चै मेरो छोरो एसाव नै होस्‌?” याकूबले जवाफ दिए, “म एसाव नै हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब इसहाकले भने, “तैँले शिकार गरेको मासु यहाँ ले, र म खानेछु, र तँलाई आशिष्‌ दिऊँ ।” याकूबले त्‍यो मासु आफ्‍ना पिताकहाँ ल्‍याए । उनले खाए र याकूबले दाखमद्य पनि लगिदिए, र उनले पिए । ");
INSERT INTO npiulb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब तिनका पिता इसहाकले तिनलाई भने, “ मेरो छोरो, मेरो नजिकै आएर मलाई मलाई चुम्बन गर् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","याकूब नजिक गएर आफ्‍ना पितालाई चुम्बन गरे । अनि इसहाकले तिनका लुगाहरूको गन्‍ध सुँघेर यसो भनी आशिष्‌ दिए, “हेर, मेरो छोराको बास्‍ना, परमप्रभुले आशिष्‌ दिनुभएको खेतको बास्‍नाजस्‍तै छ । ");
INSERT INTO npiulb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्‍वरले तँलाई आकाशको शीत र पृथ्‍वीको प्रचुरता अनि धेरै दाखमद्य र अन्‍न देऊन् । ");
INSERT INTO npiulb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","मानिसहरूले तेरो सेवा गरून्‌ र जाति-जातिहरूले तँलाई दण्‍डवत्‌ गरून्‌ । तेरा दाजुभाइहरूको मालिक बन्, र तेरी आमाका छोराहरूले तँलाई दण्‍डवत्‌ गरून्‌ । तँलाई सराप्‍नेहरू सबै श्रापित होऊन्, र तँलाई आशिष्‌ दिनेहरू सबैले आशिष्‌ पाऊन्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकले आशिष्‌ दिइसक्‍ने बित्तिकै याकूब आफ्‍ना पिता इसहाकको उपस्थितिबाट निस्‍केर गएका मात्र थिए, उनका उनका दाजु एसाव शिकार खेलेर आइपुगे । ");
INSERT INTO npiulb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","उनले पनि स्‍वादिष्‍ठ तरकारी तयार गरेर आफ्‍ना पिताकहाँ ल्‍याए । उनले आफ्‍नो पितालाई भने, “बुबा, उठेर आफ्‍नो छोराले ल्‍याएको सिकार खानुहोस्, र मलाई आशिष्‌ दिनुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","उनका पिता इसहाकले उनलाई सोधे, “तँ को होस्‌?” उनले उत्तर दिए, “म तपाईंको जेठो छोरो एसाव हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","इसहाक बेसरी कामे र भने, “त्यसो भए सिकार मारेर यहाँ मकहाँ ल्‍याउने त्यो को थियो? तँ आउन अगि नै मैले त्‍यो सबै खाएर त्‍यसलाई आशिष्‌ दिइसकेँ । वास्तवमा, त्‍योचाहिँ आशीर्वादी हुनेछ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","जब एसावले आफ्‍ना पिता इसहाकका कुरा सुने तब उनी अत्‍यन्‍तै विह्वल भई चर्को सोरले रोए र आफ्‍ना पितालाई भने, “हे मेरा बुबा, मलाई पनि आशिष्‌ दिनुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाकले भने, “तेरो भाइ छल गरेर आयो, र तैंले पाउने आशिष्‌ लग्यो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसावले भने, “त्‍यसको नाउँ याकूब राखिएको के ठिकै होइन? किनभने त्‍यसले मलाई दुई पल्‍ट ठग्यो । त्‍यसले मेरो ज्‍येष्‍ठ-अधिकार हर्‍यो, र अहिले मैले पाउने आशिष्‌ पनि लग्‍यो ।” उनले फेरि भने, “के तपाईंले मेरो निम्‍ति एउटै आशिष्‌ पनि जगेडा राख्‍नुभएको छैन?” ");
INSERT INTO npiulb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकले एसावलाई जवाफ दिए, “हेर्, मैले त्‍यसलाई तेरो मालिक तुल्‍याइसकेँ । र त्‍यसका सबै दाजुभाइहरूलाई मैले त्‍यसका दास तुल्‍याएँ । अन्‍न र दाखमद्यले मैले त्‍यसलाई तृप्‍त पारेको छु । अब तेरो निम्‍ति म के गर्न सक्‍छु र, छोरो?” ");
INSERT INTO npiulb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसावले आफ्‍ना पितालाई भने, “तपाईंसित मेरो निम्ति एउटै मात्र आशिष्‌ छैन र मेरा बुबा? मलाई पनि त आशिष्‌ दिनुहोस्‌ ।” एसाव डाँको छोडेर रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","उनका पिता इसहाकले जवाफ दिएर भने, “हेर्, तँ बस्‍ने जमिन पृथ्‍वीको प्रशस्‍तताबाट बाहिरै हुनेछ, आकाशको शीतबाट बाहिर । ");
INSERT INTO npiulb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तैंले आफ्‍नो तरवारको बलले जीविका चलाउनेछस् र तैंले तेरो भाइको सेवा गर्नेछस्‌ । तर जब तैंले विद्रोह गर्नेछस्, तब त्‍यसको जुवा तेरो काँधबाट हल्‍लाएर फ्‍याँक्‍नेछस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","आफ्‍ना पिताले याकूबलाई दिएको त्‍यस आशिष्‌ले गर्दा एसावले तिनलाई घृणा गर्न लागे । एसावले हृदयमा भने, “मेरा पिताको शोकको बेला नजिकै छ । त्‍यसपछि म मेरो भाइ याकूबलाई मार्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","तिनका जेठा छोरा एसावको यो कुरा रिबेकालाई सुनाइयो । यसकारण रिबेकाले आफ्‍ना कान्‍छा छोरा याकूबलाई बोलाएर भनिन्, “हेर्, तेरो दाजु एसावले तँलाई मार्ने विचार गरेर आफ्‍नो चित्त बुझाएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","यसकारण मेरो छोरो, मैले भनेको कुरा मान्‌ र हारानमा मेरा दाजु लाबानकहाँ भागेर जा । ");
INSERT INTO npiulb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","तँप्रति तेरो दाजुको रिस नमरुञ्‍जेल केही दिन त्‍यहाँ उनीसँग बस्‌ र ");
INSERT INTO npiulb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","तैंले त्यसमाथि गरेको काम बिर्सन्छ । त्यसपछि म तँलाई त्‍यहाँबाट लिन पठाउनेछु । मैले एकै दिनमा तिमीहरू दुवै जनालाई किन गुमाउने?” ");
INSERT INTO npiulb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","रिबेकाले इसहाकलाई भनिन्, “यहाँका हित्ती स्‍त्रीहरूको कारण मेरो जीवनै हैरान भइसक्‍यो । यदि याकूबले यस देशका स्‍त्रीहरूजस्तै हित्तीका छोरीहरूमध्‍ये एउटीलाई विवाह गर्‍यो भने मेरो लागि मेरो जीवनको के फाइदा हुन्‍छ र?” ");
INSERT INTO npiulb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसहाकले याकूबलाई बोलाएर आशीर्वाद दिए, र यसो भनेर आज्ञा गरे, “तैँले कनानी स्‍त्रीहरूबाट आफ्नो निम्ति पत्‍नी नलिनू । ");
INSERT INTO npiulb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","पद्दन-आराममा तेरी आमाका बुबा बतूएलको घरमा गएर त्‍यहीँबाट तेरा मामा लाबानका छोरीहरूमध्‍ये एउटीलाई विवाह गर्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वशक्तिमान्‌ परमेश्‍वरले तँलाई आशिष्‌ देऊन्; तँलाई फल्‍दो-फुल्‍दो गराएर तेरो वृद्धि गराऊन्, ताकि तँ मानिसहरूको एक समूह बन्‍न सक्‍नेछस् । ");
INSERT INTO npiulb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","उहाँले तँलाई र तँ पछिका तेरा सन्‍तानहरूलाई अब्राहामले पाएको आशिष्‌ देऊन्, ताकि परमेश्‍वरले अब्राहामलाई दिनुभएको तँ बसेको देशमा तेरै अधिकार होस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","यसरी इसहाकले याकूबलाई पठाए । तिनी पद्दन-आराममा एसाव र याकूबकी आमा रिबेकाका दाजु अरामी बतूएलका छोरा लाबानकहाँ गए । ");
INSERT INTO npiulb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","अब इसहाकले याकूबलाई आशीर्वाद दिएर पत्‍नी ल्‍याउन त्‍यहाँबाट पद्दन-आराममा पठाएको देखे । याकूबले तिनलाई आशीर्वाद दिएर यस्तो आज्ञा दिएको पनि उनले देखे “तैँले कनानी स्‍त्रीहरूबाट आफ्नो निम्ति पत्‍नी नलिनू ।” ");
INSERT INTO npiulb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","याकूबले आफ्ना बाबुआमाको आज्ञा मानेर पद्दन-आरामतर्फ गएको पनि एसावले देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","कनानी स्‍त्रीहरू आफ्ना बुबालाई मनपर्दैन रहेछ भन्‍ने एसावले थाहा पाए । ");
INSERT INTO npiulb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","तब एसाव इश्‍माएलकहाँ गए, र उनका आफ्‍ना पत्‍नीहरूबाहेक अब्राहामका छोरा इश्‍माएलकी छोरी र नबायोतकी बहिनी महलतलाई आफ्‍नी पत्‍नीको रूपमा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब बेर्शेबा छोडेर हारानतिर लागे । ");
INSERT INTO npiulb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","कुनै एउटा ठाउँमा पुगेपछि सूर्य अस्‍ताएको हुनाले तिनी त्‍यस रात त्‍यहीँ बास बसे । त्‍यस ठाउँमा भएका ढुङ्गाहरूमध्येबाट एउटा लिएर आफ्‍नो सिरान बनाई त्‍यही ठाउँमा सुत्‍नलाई पल्‍टे । ");
INSERT INTO npiulb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","तिनले पृथ्वीमा खडा गरिएको एउटा भर्‍याङको सपना देखे । त्‍यसको टुप्‍पाचाहिँ आकाशसम्‍मै पुगेको रहेछ र परमेश्‍वरका दूतहरू त्‍यसमा उक्‍लने र ओर्लने गर्दा रहेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","परमप्रभुले त्‍यसमाथि उभिएर याकूबलाई भन्‍नुभयो, “म परमप्रभु, तेरा पिता अब्राहामका परमेश्‍वर र इसहाकका परमेश्‍वर हुँ । जुन भूमिमा तँ ढल्‍किरहेको छस्‌ त्‍यो म तँलाई र तेरा सन्‍तानहरूलाई दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तेरा सन्‍तान पृथ्‍वीको धुलोसरह हुनेछन्‌ । तँ पश्‍चिम, पूर्व, उत्तर र दक्षिणतिर फैलिएर जानेछस्‌ । तँ र तेरा सन्‍तानहरूद्वारा नै पृथ्‍वीका सबै मानिसहरू आशिषित्् हुनेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","हेर्, म तँसँग छु र तँ जहाँसुकै गए तापनि म तेरो रक्षा गर्नेछु । म फेरि तँलाई यस ठाउँमा फर्काएर ल्‍याउनेछु । किनकि मैले तँलाई प्रतिज्ञा गरेका कुरा पुरा नगरुञ्‍जेल म तँलाई छोड्‌नेछैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब याकूबले निद्राबाट ब्‍युँझेर भने, “निश्‍चय नै परमप्रभु यस ठाउँमा हुनुहुँदोरहेछ, र मलाई यो थाहा थिएन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","तिनले डराएर भने, “यो ठाउँ कस्‍तो भययोग्‍य रहेछ । यो त परमेश्‍वरको घरबाहेक अरू केही होइन । यो त स्‍वर्गको ढोका हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याकूब बिहान सबेरै उठे, र आफूले सिरान बनाएको ढुङ्गा लिए । त्यसलाई खामोजस्‍तै गरी खडा गरेर त्‍यसको टुप्‍पामा तेल खन्‍याए । ");
INSERT INTO npiulb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","तिनले त्‍यस ठाउँको नाउँ बेथेल राखे । पहिले त्‍यस ठाउँको नाउँ लूज थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","तब याकूबले यसो भनेर भाकल गरे, “यदि परमेश्‍वर मेरो साथमा रहनुभयो, मेरो यात्रामा मलाई रक्षा गर्नुभयो, मलाई खानलाई रोटी र लाउनलाई वस्‍त्र दिनुभयो ");
INSERT INTO npiulb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","भने म कुशलपूर्वक फेरि मेरा बुबाको घरमा फर्कन्छु, अनि परमप्रभु नै मेरा परमेश्‍वर हुनुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","त्यसपछि मैले खामो बनाएको यो ढुङ्गाचाहिँ पवित्र ढुङ्गा हुनेछ । तपाईंले मलाई दिनुभए जति सबै थोकको दशांश म तपाईंलाई अवश्‍य चढाउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","तब याकूब आफ्‍नो बाटो लागे र पूर्वका मानिसहरूको देशमा पुगे । ");
INSERT INTO npiulb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","तिनले हेर्दा मैदानमा एउटा इनार देखे, र त्‍यसको नजिक भेडाका तिनवटा बगाल बसिरहेका थिए । किनकि त्‍यही इनारबाट तिनीहरूले बगाललाई पानी खुवाउँथे, र इनारको मुख ढाक्‍ने ढुङ्गा ठुलो थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","सबै बगालहरू त्‍यहाँ जम्‍मा भएपछि गोठालाहरूले इनारको मुखबाट ढुङ्गा गुडाएर भेडाहरूलाई पानी खान दिन्‍थे । त्‍यसपछि तिनीहरूले त्यो ढुङ्गालाई इनारको मुखमा फेरि पहिलेकै ठाउँमा राखिदिन्‍थे । ");
INSERT INTO npiulb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकूबले तिनीहरूलाई भने, “हे मेरा भाइ हो, तिमीहरू कहाँका हौ?” तिनीहरूले भने, “हामी हारानका हौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","उनले तिनीहरूलाई भने, “तिमीहरू नाहोरका छोरो लाबानलाई चिन्‍छौ?” तिनीहरूले भने, “हामी तिनलाई चिन्‍छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","उनले तिनीहरूलाई सोधे, “के उहाँ सन्‍चै हुनुहुन्‍छ?” तिनीहरूले भने, “उहाँ सन्‍चै हुनुहुन्‍छ, र हेर्नुहोस्, उहाँकी छोरी राहेल भेडाहरू लिएर आउँदै छिन्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकूबले भने,“ हेर, मध्य दिन भएको छ । भेडा-बाख्राहरूलाई जम्‍मा गर्ने बेला भएको छैन । भेडाहरूलाई पानी खुवाएर जाओ र तिनीहरूलाई चर्न देओ । ");
INSERT INTO npiulb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","तिनीहरूले भने, “सबै बगालहरू जम्‍मा नभई हामी तिनीहरूलाई पानी खुवाउन सक्दैनौँ । त्यसपछि यी मानिसहरूले इनारको मुखको ढुङ्गो हटाउनेछन्, अनि हामी भेडाहरूलाई पानी खुवाउनेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकूब तिनीहरूसँग कुरा गरिरहेकै बेला , राहेल आफ्‍ना बुबाका भेडाहरू लिएर त्‍यहाँ आइपुगिन्, किनकि तिनले भेडाहरू चराउँदै थिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जब याकूबले आफ्‍ना मामा लाबानकी छोरी राहेल र लाबानका भेडाहरू देखे, याकूबले नजिक आएर इनारको मुखको ढुङ्गा गुडाए, अनि आफ्‍ना मामा लाबानका भेडाहरूलाई पानी खुवाए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकूबले राहेललाई चुम्बन गरे र डाको छोडेर रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकूबले राहेललाई आफू तिनका बाबुको नातेदार र रिबेकाको छोरा भएको कुरा बताए । तब राहेल दौडेर गइन्‌ र आफ्‍ना बाबुलाई यो कुरा बताइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","आफ्‍ना भानिज याकूब आएको समाचार पाउने बित्तिकै लाबान तिनलाई भेट्‌नलाई दौडेर गएर तिनलाई अँगालो हालेर चुम्‍बन गरे, अनि तिनलाई आफ्‍नो घरमा ल्‍याए । याकूबले लाबानलाई सबै कुरा बताइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","लाबानले तिनलाई भने, “वास्‍तवमा तिमी मेरो हाड र मासु हौ ।” त्यसपछि याकूब तिनीसँग करिब एक महिना बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","त्यसपछि लाबानले याकूबलाई भने, “मेरा नातेदार हुँदैमा तिमीले सित्तैँमा मेरो सेवा गर्नुपर्छ र? तिम्रो ज्‍याला कति हो मलाई भन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानका दुई जना छोरी थिए । जेठीको नाउँ लेआ र कान्‍छीको नाउँ राहेल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआका आँखा धमिला थिए, तर राहेलचाहिँ शारीरिक रूपमा सुडौल र हेर्नमा सुन्‍दरी थिइन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूबले राहेललाई प्रेम गरे, त्यसैले तिनले भने, “तपाईंकी कान्‍छी छोरी राहेलको निम्‍ति म सात वर्षसम्‍म तपाईंको सेवा गर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबानले भने, “त्‍यसलाई अर्को मानिसलाई दिनुभन्दा त तिमीलाई दिनु नै असल हो । मसँगै बस ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","यसकारण याकूबले राहेलको निम्‍ति सात वर्षसम्‍म सेवा गरे । राहेलप्रति तिनको प्रेमको कारण तिनलाई त्‍यो समय तिनलाई थोरै दिनजस्‍तो लाग्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","त्‍यसपछि याकूबले लाबानलाई भने, “मैले सेवा गर्ने दिनहरू पुरा भएको हुनाले मलाई मेरी पत्‍नी दिनुहोस् ताकि म तिनीसँग विवाह गर्न सकूँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","तब लाबानले त्‍यस ठाउँका सबै मानिसहरू जम्‍मा गरेर भोज दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","साँझमा उनले आफ्‍नी छोरी लेआलाई याकूबकहाँ ल्‍याइदिए, र याकूबले तिनीसँग सहवास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबानले आफ्‍नी कमारी जिल्‍पालाई आफ्‍नी छोरी लेआकी कमारी हुनलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","याकूबले बिहान हेर्दा त लेआ पो रहिछन्‌ । तिनले लाबानलाई भने, “तपाईंले मप्रति यो के गर्नुभएको? मैले राहेलको निम्‍ति सेवा गरेको होइन र? त्यसो भए तपाईंले किन मसित छल गर्नुभयो?” ");
INSERT INTO npiulb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबानले भने, “जेठीको भन्‍दा कान्‍छीको विवाह अगि गर्ने रीति हामीकहाँ छैन । ");
INSERT INTO npiulb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","यो छोरीसँग एक साता पुरा गर, र अर्को सात वर्ष मेरो सेवाको सट्टामा म तिमीलाई अर्की पनि दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकूबले त्‍यसै गरे, र लेआसँग एक साता पुरा गरे । तब लाबानले आफ्‍नी छोरी राहेललाई पनि याकूबकी पत्‍नीको रूपमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबानले आफ्‍नी कमारी बिल्‍हालाई आफ्‍नी छोरी राहेलकी कमारी हुनलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","त्यसैले याकूबले राहेलसँग पनि सहवास गरे, तर तिनले लेआलाई भन्‍दा राहेललाई बढी प्रेम गर्थे । यसकारण याकूबले थप सात साल लाबानको सेवा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","लेआलाई प्रेम नगरिएको परमप्रभुले देख्‍नुभयो, त्यसैले उहाँले तिनको कोख खोलिदिनुभयो । तर राहेलका सन्तान भएका थिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआले गर्भवती भएर एक छोरो जन्माइन्, र तिनले यसो भनेर त्‍यसको नाम रूबेन राखिन् । “साँच्‍ची नै परमप्रभुले मेरो दु:ख देख्‍नुभएको छ, अब त मेरा पतिले निश्‍चय नै मलाई प्रेम गर्नुहुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","तिनी फेरि गर्भवती भइन् र अर्को छोरा जन्‍माइन्‌ । तिनले भनिन्, “म प्रेमविहीन छु भनी परमेश्‍वरले सुन्‍नुभएको हुनाले उहाँले मलाई यो छोरा पनि दिनुभयो,” र तिनले त्‍यसको नाउँ शिमियोन राखिन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","तिनी फेरि गर्भवती भइन्‌ र एक जना छोरो जन्‍माइन् । तिनले भनिन्, “अब त मेरा पति मप्रति आकर्षित हुनुहुनेछ, किनभने मैले उहाँको निम्‍ति तिन जना छोरा पाइसकेँ ।” यसकारण त्‍यसको नाउँ लेवी राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","तिनी फेरि गर्भवती भएर छोरो पाइन्‌ र भनिन्, “यस पाली त म परमप्रभुको प्रशंसा गर्नेछु ।” यसैले त्‍यसको नाउँ यहूदा राखियो । त्‍यसपछि तिनले जन्‍माउन छोडिन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","आफूले याकूबबाट कुनै सन्तान नजन्माएको देखेर राहेलले आफ्नी दिदीको डाह गरिन् । उनले याकूबलाई भनिन्, “मलाई सन्तान दिनुहोस्, नत्रभने म मर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","राहेलमाथि याकूबको क्रोध दन्कियो । तिनले भने, “के तिमीलाई सन्तान दिनबाट रोक्‍नु हुने म परमेश्‍वरको स्थानमा छु र? ");
INSERT INTO npiulb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","उनले भनिन्, “हेर्नुहोस्, मेरी कमारी बिल्हा यहीँ छे । त्योसित सहवास गर्नुहोस् ताकि त्यसले मेरो निम्ति सन्तान जन्माउन सकोस्, र त्यसद्वारा मसित सन्तान हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","त्यसैले उनले आफ्नी कमारी बिल्हा याकूबकी पत्‍नी हुनलाई दिइन्, र याकूब त्यससित सुते । ");
INSERT INTO npiulb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिल्हा गर्भवती भई र त्यसले याकूबको निम्ति एउटा छोरो जन्माई । ");
INSERT INTO npiulb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","त्यसपछि राहेलले भनिन्, “परमेश्‍वरले मेरो पक्षमा न्याय गर्नुभएको छ । उहाँले मेरो प्रार्थना सुन्‍नुभई मलाई एउटा छोरो दिनुभएको छ ।” त्यसैले उनले त्यसको नाउँ दान राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेलकी कमारी बिल्हा फेरि गर्भवती भई र त्यसले याकूबको निम्ति दोस्रो छोरो जन्माई । ");
INSERT INTO npiulb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","राहेलले भनिन्, “निकै सङ्घर्ष गरेर मैले मेरी दिदीमाथि जित हासिल गरेको छु ।” उनले त्यसको नाउँ नप्‍ताली राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","आफूले बच्‍ची जन्माउन छोडेकी देखेर उनले आफ्नी कमारी जिल्पा याकूबकी पत्‍नी हुनलाई दिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","लेआकी कमारी जिल्पाले याकूबको निम्ति एउटा छोरो जन्माई । ");
INSERT INTO npiulb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लेआले भनिन्, “भाग्यमानी!” त्यसैले उनले त्यसको नाउँ गाद राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","त्यसपछि लेआकी कमारी जिल्पाले दोस्रो छोरो जन्माई । ");
INSERT INTO npiulb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","लेआले भनिन्, “म सुखी छु । किनकि स्‍त्रीहरूले मलाई सुखी भन्‍ने छन् ।” त्यसैले उनले त्यसको नाउँ आशेर राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहुँ कटनी गर्ने समयमा रूबेन खेतमा गए, र तिनले विशाखमूलहरू भेट्टाएर ती आफ्नी आमा लेआकहाँ लिएर आए । त्यसपछि राहेलले लेआलाई भनिन्, “तिम्रो छोराका केही विशाखमूलहरू मलाई देऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लेआले उनलाई भनिन्, “के तिमीले मेरा पति मबाट लैजानु सामान्य विषय हो र? अब तिमी मेरो छोराका विशाखमूलहरू पनि लिन चाहन्छ्यौ? राहेलले भनिन्, “त्यसो भए, तिम्रो छोराका विशाखमूलहरूको सट्टामा आज राति तिनी तिमीसितै सुत्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","साँझमा याकूब खेतबाट आए । लेआ तिनलाई भेट्न गइन् र भनिन्, “आज राती तपाईं मसित सुत्‍नुपर्छ किनकि मैले तपाईंलाई मेरो छोराका विशाखमूलहरू दिएर भाडामा लिएको छु ।” त्यसैले त्यस रात याकूब उनीसित सुते । ");
INSERT INTO npiulb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्‍वरले लेआको पुकारा सुन्‍नुभयो, र उनी गर्भवती भएर याकूबको निम्ति पाँचौँ छोरो जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लेआले भनिन्, “परमेश्‍वरले मेरो ज्याला दिनुभएको छ किनभने मैले मेरी कमारी मेरा पतिलाई दिएँ ।” उनले त्यसको नाउँ इस्साखार राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लेआ फेरि गर्भवती भइन् र उनले याकूबको निम्ति छैटौँ छोरो जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","लेआले भनिन्, “परमेश्‍वरले मलाई अनमोल उपहार दिनुभएको छ । अब मेरा पतिले मलाई इज्‍जत गर्नुहुनेछ किनभने मैले उहाँका निम्ति छवटा छोरा जन्माएँ ।” उनले त्यसको नाउँ जबूलून राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","त्यसपछि उनले एउटी छोरी जन्माइन् र त्यसको नाउँ दीना राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","परमेश्‍वरले राहेललाई याद गर्नुभयो र उनको पुकारा सुन्‍नुभयो । उहाँले उनको गर्भ खोलिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","उनी गर्भवती भइन् र एउटा छोरो जन्माइन् । उनले भनिन्, “परमेश्‍वरले मेरो लाज हटाइदिनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","उनले यसो भन्दै त्यसको नाउँ योसेफ राखिन्, “परमप्रभुले मलाई अर्को छोरो दिनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","राहेलले योसेफलाई जन्माएपछि याकूबले लाबानलाई भने, “मलाई बिदा दिनुहोस्, ताकि म मेरो आफ्नै घर र मेरो देशमा जान सकूँ । ");
INSERT INTO npiulb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मलाई मेरा पत्‍नीहरू र मेरा छोराछोरीहरू दिनुहोस् जसको निम्ति मैले तपाईंको सेवा गरेको छु । मलाई जान दिनुहोस् किनकि मैले तपाईंको सेवा गरेको त तपाईंलाई थाहै छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबानले तिनलाई भने, “मैले तिम्रो दृष्‍टिमा निगाह पाएको छु भने पर्ख, किनभने पूर्वलक्षणको प्रयोगद्वारा मैले थाहा पाएको छु, कि तिम्रो कारणले गर्दा परमप्रभुले मलाई आशिष् दिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","त्यसपछि तिनले भने, “तिम्रो ज्याला कति भयो, मलाई भन । म तिरिदिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूबले लाबानलाई भने, “मैले तपाईंको कस्तो सेवा गरेको छु र तपाईंका गाईबस्तु कसरी सप्रेका छन् भनी तपाईं जान्‍नुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","म आउनुअगि तपाईंसित थोरै मात्र थियो तर अहिले प्रचुर मात्रामा वृद्धि भएका छन् । मैले जहाँसुकै काम गरे तापनि परमप्रभुले तपाईंलाई आशिष् दिनुभएको छ । अब मेरो आफ्नै घरानाको निम्तिचाहिँ मैले कहिले बन्दोवस्त गर्ने?” ");
INSERT INTO npiulb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","त्यसैले लाबानले भने, “म तिमीलाई के दिऊँ?” याकूबले भने, “तपाईंले मलाई केही पनि दिनुपर्दैन । तपाईंले मलाई केही दिनुभयो भने मैले फेरि तपाईंको बगाललाई खुवाउनुपर्ने हुन्छ र यसको हेरचाह गर्नुपर्ने हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","आज मलाई तपाईंको बगालबाट थुमाहरूका बिचमा हरेक थोप्ले, हरेक पेटारे र हरेक कालो अनि बाख्राहरूका बिचमा पनि हरेक थोप्ले र पेटारे छुट्‌ट्याउन दिनुहोस् । यी मेरा ज्याला हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","तपाईं मेरा ज्यालाको हिसाब गर्न आउनुहुँदा पछि मेरो सत्यनिष्‍ठा‌ले नै मेरो गवाही दिनेछ । बाख्राहरूका बिचमा थोप्ले र पेटारे नभएको अनि थुमाहरूका बिचमा कालो नभएको मध्ये कुनै फेला पारियो भने ती मैले चोरेको ठहरिनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबानले भने, “हुन्छ । तिम्रो वचनअनुसार नै होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","त्यस दिन लाबानले थोप्ले र पेटारे बाख्राहरू अनि सेतो दाग भएका सबै थोप्ले र पेटारे बाख्रीहरू अनि थुमाहरूका बिचमा भएका सबै काला थुमाहरू छुट्‌ट्याए र ती आफ्ना छोराहरूलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","लाबानले तिनी र याकूबको बिचमा तिन दिनको यात्राको अन्तर पनि राखे । त्यसैले याकूबले लाबानका बाँकी बगालहरू चराइरहे । ");
INSERT INTO npiulb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","याकूबले ताजा लहरे-पीपल, हाडे बदाम र चिनारका रुखका भर्खरै काटिएका हाँगाहरू लिए, र तिनमा सेतो धर्का बनाउनलाई बोक्राहरू ताछे । ");
INSERT INTO npiulb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","त्यसपछि तिनले बगालहरूको सामु रहेका ती ताछिएका हाँगाहरू पानी पिउन आउने डूँडको सामु राखे । पानी पिउन आउँदा तिनीहरू गर्भवती भए । ");
INSERT INTO npiulb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ती बगालहरू हाँगाहरूका सामुन्‍ने मिसिने भएकाले तिनीहरूले पाठापाठी पनि त्यस्तै छिर्केमिर्के, पेटारे र थोप्ले ब्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूबले यी थुमाहरूलाई छुट्‌ट्याए, तर बाँकी बगाललाई चाहिँ छिर्केमिर्के जनावरहरूतिर फर्काएर राखे अनि सबै काला थुमालाई चाहिँ लाबानको बगालमा राखिदिए । त्यसपछि तिनले आफ्नो बगाललाई चाहिँ अलग गरे र लाबानको बगालसित मिसाएनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","बलिया भेडाहरू मिसिँदा याकूबले बगालहरूका सामुन्‍ने डूँडमा ती हाँगाहरू राखिदिन्थे ताकि तिनीहरू हाँगाहरूकै बिचमा गर्भवती होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","तर बगालमा भएका कमजोर जनावरहरू आउँदा तिनले तिनीहरूको सामु हाँगाहरू राख्दैनथ्ये । यसरी कमजोर जनावरहरू लाबानका भए र बलियाहरू याकूबका भए । ");
INSERT INTO npiulb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","याकूबले ज्यादै उन्‍नति गरे । तिनका ठुला-ठुला बगालहरू, नोकर-चाकरहरू ऊँटहरू र गधाहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","याकूबले लाबानका छोराहरूले यसो भनेका सुने, “हाम्रा पिताका सबै थोक याकूबले लिएका छन्, र हाम्रा पिताका सम्पत्तिबाट नै तिनले यी सबै सम्पत्ति पाएका हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","याकूबले लाबानको व्यवहार देखे । याकूबप्रति लाबानको मनसाय परिवर्तन भइसकेको याकूबले देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","तब परमप्रभुले याकूबलाई भन्‍नुभयो, “तेरा पुर्खाहरू र तेरा आफन्तहरूको देशमा फर्केर जा, र म तँसित हुनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","याकूबले राहेल र लेआलाई आफ्नो बगालको खेतमा बोलाउन पठाए, ");
INSERT INTO npiulb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","र तिनीहरूलाई भने, “मप्रतिको तिमीहरूका पिताको मनसाय परिवर्तन भएको म देख्छु, तर मेरा पिताका परमेश्‍वर मसित हुनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","मेरो सारा शक्ति लगाएर मैले तिमीहरूका पिताको सेवा गरेको कुरा त तिमीहरूलाई थाहै छ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तिमीहरूका पिताले मलाई ठगेका छन्, र मेरो ज्याला दस पटक बद्लेका छन्, तर परमेश्‍वरले तिनलाई मेरो हानि गर्न दिनुभएको छैन । ");
INSERT INTO npiulb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","'थोप्ले जनावरहरू तिम्रो ज्याला हुनेछ' भनी तिनले भन्दा सबै बगालले थोप्ले पाठा-पाठी नै जन्माए । 'पेटारेहरू तिम्रो ज्याला हुनेछ' भनी तिनले भन्दा सारा बगालले पेटारे पाठा-पाठीहरू नै जन्माए । ");
INSERT INTO npiulb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यसरी परमेश्‍वरले तिमीहरूका पिताका गाईबस्तु मलाई दिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","एक पटक बगाल मिसिने समयमा मैले सपनामा बोकाहरू बगालमा सँगसँगै भएको देखेँ । बोकाहरू छिर्केमिर्के, पेटारे र थोप्ले थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","सपनामा परमेश्‍वरका दूतले मलाई भने, 'हे याकूब!' मैले जवाफ दिएँ, “हजुर, म यहाँ छु ।' ");
INSERT INTO npiulb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","उहाँले भन्‍नुभयो, 'तेरा आँखा उठाएर सबै बोका बगालमाथि चढिरहेको हेर् । तिनीहरू छिर्केमिर्के, पेटारे र थोप्ले छन् किनकि लाबानले तँलाई गरेको हरेक कुरा मैले देखेको छु । ");
INSERT INTO npiulb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","म बेथेलको परमेश्‍वर हुँ जहाँ तैँले खामोलाई अभिषेक गरिस् र मसित भाकल गरिस् । अब उठ् र यस देश छाडेर तेरो जन्मभूमिमा फर्कि' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","राहेल र लेआले तिनलाई जवाफ दिएर भने, “के हाम्रा पिताको घरमा हाम्रा निम्ति हकको कुनै भाग छ र? के उहाँले हामीलाई विदेशीहरूलाई जस्तै व्यवहार गर्नुभएको छैन र? ");
INSERT INTO npiulb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","किनकि उहाँले हामीलाई बेच्नुभएको छ, र हाम्रो रुपियाँ-पैसा पूर्ण रूपमा सखाप पार्नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","हाम्रा पिताबाट परमेश्‍वरले लैजानुभएका सबै सम्पत्ति अब हाम्रा र हाम्रा छोराछोरीहरूका भएका छन् । त्यसो भए, अब परमेश्‍वरले तपाईंलाई जे भन्‍नुभएको छ, सो गर्नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","त्यसपछि याकूब उठे, र तिनले आफ्ना छोराहरू र पत्‍नीहरूलाई ऊँटहरूमाथि राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","तिनले पद्दन-आराममा आफूले प्राप्‍त गरेका आफ्ना सबै गाईबस्तु र सबै सम्पत्तिलाई आफ्नो अगिअगि पठाए । त्यसपछि तिनी कनान देशमा आफ्ना पिता इसहाककहाँ जान निस्के । ");
INSERT INTO npiulb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","लाबान आफ्ना भेडाहरूको ऊन कत्रन जाँदा राहेलले आफ्ना पिताका घर-देवताहरू चोरिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","अरामी लाबानलाई थाहा नदिई घर छाडेकाले याकूबले तिनलाई पनि छल गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","आफूसित भएका सबै थोक लिएर तिनी भागे, र छिट्टै महानदी पार गरेर गिलादको पहाडी देशतर्फ अगाडि बढे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","याकूब भागेको कुरा लाबानलाई तेस्रो दिनमा बताइयो । ");
INSERT INTO npiulb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","त्यसैले तिनले आफूसित आफ्ना आफन्तहरू लिई सात दिनसम्म तिनको पिछा गरे । लाबानले गिलादको पहाडी देशमा तिनलाई भेट्टाए । ");
INSERT INTO npiulb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","राती सपनामा परमेश्‍वर अरामी लाबानकहाँ देखा पर्नुभई तिनलाई भन्‍नुभयो, “तैँले याकूबसित असल वा खराब कुनै कुरो नभन्‍न होसियार हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबानले याकूबलाई भेट्टाउँदा याकूब त्यस पहाडी देशमा पाल टाँगेर बसेका थिए । गिलादको पहाडी देशमा लाबान पनि आफ्ना आफन्तहरूसँगै पाल टाँगेर बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबानले याकूबलाई भने, “तिमीले मेरा छोरीहरूलाई युद्धका कैदीहरूलाई जस्तै गरी लगेर मलाई छल गरी यो के गरेको? ");
INSERT INTO npiulb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","किन तिमीले मलाई नबताईकन सुटुक्‍क भागेर धोका दियौ? गीत गाउँदै वीणा र खैँजडी बजाउँदै उत्सवको साथमा मैले तिमीलाई बिदा गर्ने थिएँ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तिमीले मेरा नातिहरू र छोरीहरूलाई बिदाइको चुम्बन गर्ने अनुमति पनि दिएनौ । तिमीले मूर्खतापूर्वक काम गर्‍यौ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","तिमीलाई हानि गर्ने शक्ति मसित छ, तर तिम्रा परमेश्‍वर गत रात मसित यसो भन्दै बोल्नुभयो, 'तैँले याकूबसित असल वा खराब कुनै कुरो नभन्‍न होसियार हो ।' ");
INSERT INTO npiulb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","अब तिमीले आफ्ना पिताको घरमा फर्कने चाहना गरेकाले तिमी आइसकेका छौ । तर तिमीले मेरा घर-देवताहरू किन चोरी गर्‍यौ? ");
INSERT INTO npiulb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूबले लाबानलाई जवाफ दिई भने, “तपाईंले आफ्ना छोरीहरू मबाट जबरजस्ती खोसेर लैजानुहुने थियो भनी मैले ठानेकाले म डराएको थिएँ । त्यसैले म सुटुक्‍क भागेँ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","तपाईंका घर-देवताहरू जोसुकैले चोरेको भए तापनि अबदेखि त्यो बाँच्नेछैन । हाम्रा आफन्तहरूको उपस्थितिमा तपाईंसित भएको कुनै थोक मसित छ भने चिनेर लैजानुहोस् ।” राहेलले ती चोरेकी थिइन् भनी याकूबलाई थाहा थिएन । ");
INSERT INTO npiulb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","लाबान याकूब र लेआको पालसाथै दुई जना कमारीका पालभित्र गए, तर तिनले ती घर-देवताहरू पाएनन् । तिनी लेआको पालबाट बाहिर आई राहेलको पालभित्र पसे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेलले ती घर-देवताहरू ल्याएकी थिइन् र तिनलाई ऊँटको काठीमा लुकाएकी थिइन् । उनी तीमाथि बसेकी थिइन् । लाबानले पुरै पालमा खोजी गरे तापनि ती पाएनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","उनले आफ्ना पितालाई भनिन्, “हजुर मसित नरिसाउनुहोला । म महिनावरी भएकीले म तपाईंको सामु उठ्न सक्दिनँ ।” त्यसैले तिनले खोजी गरे तापनि ती घर-देवताहरू भेट्टाएनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","याकूब रिसाए र तिनले लाबानलाई हप्काए, “मेरो दोष के हो? मेरो पाप के हो जसको लागि तपाईंले मेरो यसरी पिछा गर्नुभयो? ");
INSERT INTO npiulb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तपाईंले मेरा सबै मालसामानको खोजी गरिसक्‍नुभयो । के तपाईंले कुनै आफ्ना घरेलु सामानहरू फेला पार्नुभयो? पाउनुभएको छ भने ती हाम्रा आफन्तहरूको सामु राखिदिनुहोस् ताकि तिनीहरूले हामी दुईको बिचमा न्याय गरून् । ");
INSERT INTO npiulb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","बिस वर्षसम्म म तपाईंसँगै थिएँ । तपाईंका भेडीहरू र बाख्रीहरूका गर्भ कहिल्यै तुहिएन, न त मैले तपाईंका बगालबाट भेडाहरू खाएँ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जङ्गली जनावरहरूले फहराएकाहरूलाई मैले तपाईंकहाँ ल्याउन्‍नथेँ । बरु, मैले त्यसको क्षतिपूर्ति तिर्थें । दिनमा चोरी भएर होस् वा रातमा चोरी भएर होस्, तपाईंले मलाई सधैँ हराएको हरेक पशुको मोल तिराउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मेरो हालत यस्तो थियो, कि दिउँसो गर्मीले मलाई पोल्थ्यो भने राती चिसोले ठिर्‍याउँथ्यो । मलाई निद्रा लाग्दैनथ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","यी बिस वर्ष म तपाईंको घरमा रहेँ । तपाईंका दुई छोरीका लागि मैले चौध वर्ष तपाईंको सेवा गरेँ, र बगालको लागि छ वर्ष सेवा गरेँ । तपाईंले दस पटक मेरो ज्याला बद्लनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","मेरा पिताका परमेश्‍वर जो अब्राहामका परमेश्‍वर र इसहाकका भय हुनुहुन्छ, उहाँ मसित नहुनुभएको भए निश्‍चय नै तपाईंले मलाई रित्तै हात पठाउनुहुने थियो । परमेश्‍वरले ममाथिको थिचोमिचो र मैले गरेको कडा परिश्रम देख्‍नुभएको छ । त्यसैले उहाँले गत रात तपाईंलाई हप्काउनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबानले याकूबलाई जवाफ दिई भने, “यी छोरीहरू मेरै छोरीहरू हुन्; यी नातिनातिनाहरू मेरै नातिनातिनाहरू हुन् र यी बगालहरू मेरै बगालहरू हुन् । तिमीले देखेका यी सबै मेरै हुन् । तर आज यी मेरा छोरीहरू र तिनीहरूले जन्माएका छोराछोरीहरूलाई म के नै गर्न सक्छु र? ");
INSERT INTO npiulb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","त्यसैले अब तिमी र मेरो बिचमा एउटा करार बाँधौँ अनि यही करार तिमी र मेरो बिचको गवाही होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","त्यसकारण याकूबले एउटा ढुङ्गो लिएर त्यसलाई खामोको रूपमा खडा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","याकूबले आफ्ना आफन्तहरूलाई भने, “ढुङ्गाहरू जम्मा गर ।” तिनीहरूले ढुङ्गाहरूको थुप्रो लगाए । त्यसपछि तिनीहरूले त्यही थुप्रोनेर खानपान गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबानले त्यसको नाउँ यगर-सहदूता राखे, तर याकूबले त्यसलाई गलेद भने । ");
INSERT INTO npiulb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबानले भने, “आज यो थुप्रो तिमी र मेरो बिचमा गवाहीको रूपमा खडा छ । त्यसकारण यसको नाउँ गलेद राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","यसलाई मिस्पा पनि भनिन्छ किनभने लाबानले यसो भनेका थिए, “हामी एक-अर्काको दृष्‍टिबाट अलग हुँदा परमप्रभुले तिमी र मेरो हेरचाह गरून् । ");
INSERT INTO npiulb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","तिमीले मेरा छोरीहरूलाई दुर्व्यवहार गर्‍यौ वा तिमीले मेरा छोरीहरूबाहेक अन्य पत्‍नीहरू ल्यायौ भने हामीसित कोही नभए तापनि परमेश्‍वर तिम्रो र मेरो बिचमा गवाही हुनुहुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबानले याकूबलाई भने, “तिम्रो र मेरो बिचमा मैले खडा गरेको यो थुप्रो र यो खामोलाई हेर । ");
INSERT INTO npiulb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","तिम्रो हानि गर्नलाई म यो पार गरेर तिमीकहाँ आउनेछैनँ र मेरो हानि गर्नलाई तिमी यो पार गरेर मकहाँ आउनेछैनौ भन्‍नाका लागि यो थुप्रो र यो खामो गवाहीको रूपमा खडा छन् । ");
INSERT INTO npiulb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहामका परमेश्‍वर, नाहोरका परमेश्‍वर र तिनीहरूका पिताका परमेश्‍वरले हाम्रो बिचमा न्याय गरून् । याकूबले आफ्ना पिता इसहाकको भयलाई साक्षी मानी शपथ खाए । ");
INSERT INTO npiulb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","याकूबले त्यस पहाडमा बलिदान चढाए र आफ्ना आफन्तहरूलाई खानपानको लागि बोलाए । तिनीहरूले खानपान गरे, अनि पुरै रात त्यही पहाडमा बिताए । ");
INSERT INTO npiulb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","लाबान बिहान सबेरै उठे । तिनले आफ्ना नातिहरू, आफ्ना छोरीहरूलाई चुम्बन गरी आशिष् दिए । त्यसपछि लाबान बिदा भई घर फर्के । ");
INSERT INTO npiulb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब पनि आफ्नो बाटो लागे, र परमेश्‍वरका दूतहरूले तिनीसित भेट गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","याकूबले तिनीहरूलाई देखेपछि तिनले भने, “यो त परमेश्‍वरको शिविर हो ।” त्यसैले तिनले त्यस ठाउँको नाउँ महनोम राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकूबले एदोमको क्षेत्रमा पर्ने सेइर देशमा आफ्ना दाजु एसावकहाँ आफूभन्दा अगिअगि सन्देशवाहकहरू पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","तिनले तिनीहरूलाई यसो भनी आज्ञा दिए, “तिमीहरूले मेरा मालिक एसावलाई यसो भन्‍नेछौः तपाईंका दास याकूब यसो भन्छन्, 'म लाबानसित बस्दै आएकोले अहिलेसम्म आउन ढिलो भएको हो । ");
INSERT INTO npiulb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","मेरा गोरुहरू, गधाहरू, बगालहरू, कमारा-कमारीहरू छन् । तपाईंको दृष्‍टिमा मैले निगाह पाउन सकूँ भनी मैले मेरा मालिकलाई यो खबर पठाएको छु' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","याकूबकहाँ फर्की सन्देशवाहकहरूले यसो भने, “हामी तपाईंका दाजु एसावकहाँ गयौँ । उहाँ चार सय जना मानिससहित तपाईंलाई भेट्न आउँदै हुनुहुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","तब याकूब ज्यादै भयभीत भए र आत्तिए । त्यसैले तिनले आफूसित भएका मानिसहरू, बगालहरू, बथानहरू र ऊँटहरूलाई दल-दल गरी दुई भागमा विभाजन गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","तिनले भने, “एसावले आएर एउटा दललाई अाक्रमण गरे भने बाँकी रहेको दल भाग्‍नेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","याकूबले भने, “मेरा पिता अब्राहामका परमेश्‍वर, मेरा पिता इसहाकका परमेश्‍वर यहोवेले मलाई भन्‍नुभयो, 'तेरो देश र तेरो कुटुम्बकहाँ फर्केर जा, म तेरो उन्‍नति गराउनेछु ।' ");
INSERT INTO npiulb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तपाईंका दासको निम्ति तपाईंले गर्नुभएका करारको विश्‍वासयोग्यता र भरोसाका सबै कार्यको निम्ति म योग्यको छैनँ । किनकि यही लौरो लिएर मात्र मैले यर्दन तरेँ, र अहिले मेरा दुईवटा दल छन् । ");
INSERT INTO npiulb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","कृपया, मलाई मेरा दाजु एसावको हातबाट छुटकारा दिनुहोस् किनकि तिनी आएर मलगायत मेरी पत्‍नीहरू र छोराछोरीहरूलाई आक्रमण गर्छन् कि भनेर म तिनीदेखि डराएको छु । ");
INSERT INTO npiulb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तर तपाईंले भन्‍नुभयो, 'निश्‍चय नै, म तेरो उन्‍नति गराउनेछु । म तेरा सन्तानहरूलाई गन्‍नै नसकिने गरी समुद्रको बालुवासरह तुल्याउनेछु' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","त्यस रात याकूब त्यहीँ बसे । आफ्ना दाजु एसावलाई उपहारस्वरूप दिनलाई तिनले आफूसित भएका केही थोकहरू अलग गरे जुन यिनै थिएः ");
INSERT INTO npiulb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","दुई सयवटा बाख्री, बिसवटा बोका, ");
INSERT INTO npiulb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तिसवटा दुध दिने ऊँट र तिनीहरूका बच्‍चा, चालिसवटा गाई र दसवटा साँढे, बिसवटा गधैनी र दसवटा गधा । ");
INSERT INTO npiulb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","तिनले बथान-बथान गरी यी सबै आफ्ना कमाराहरूको जिम्मा लगाइदिए । तिनले तिनीहरूलाई भने, “मेरो अगिअगि जाओ र हरेक बथानको बिचमा खाली ठाउँ राख ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","तिनले पहिलो कमारोलाई यसो भन्दै निर्देशन दिए, “मेरा दाजु एसावले तँलाई भेटेर 'तँ कसको होस्? तँ कहाँ जाँदै छस्? तेरो अगिअगि आएका यी पशुहरू कसका हुन्? भनेर सोधे भने ");
INSERT INTO npiulb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तैँले यसो भन्, 'यी तपाईंका दास याकूबका हुन् । यी मेरा मालिक याकूबलाई उपहारस्वरूप पठाइएका हुन् । हेर्नुहोस्, उहाँ पनि हाम्रो पछिपछि आउँदै हुनुहुन्छ' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","दोस्रो दल, तेस्रो दल अनि बगालहरूको पछिपछि लाग्‍ने सबै मानिसलाई पनि याकूबले निर्देशन दिए । तिनले भने, “तिमीहरूले एसावलाई भेट्दा उही कुरो भन्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","तिमीहरूले यसो पनि भन्‍नू, 'तपाईंका दास याकूब हाम्रो पछिपछि आउँदै हुनुहुन्छ' ।” किनकि तिनले यस्तो सोचे, “मैले मेरो अगिअगि पठाएका उपहारहरूले म तिनलाई खुसी पार्नेछु । त्यसपछि मैले तिनलाई भेट्दा सायद तिनले मलाई स्वीकार गर्नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","त्यसैले उपहारहरू तिनको अगिअगि पठाइए । तिनी आफैचाहिँ त्यस रात शिविरमा नै बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","रातमा याकूब निद्राबाट ब्युँझे । आफ्ना दुई पत्‍नी, तिनीहरूका कमारीहरू र एघार जना छोरा लिएर तिनी प्रस्थान गरे । तिनले तिनीहरूलाई यब्बोक खोला पारि पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","यसरी तिनले आफ्ना सबै सम्पत्ति खोला पारि पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","याकूब एक्लै रहे, र एक जना मानिसले तिनीसित सूर्योदय नभएसम्म कुस्ती खेले । ");
INSERT INTO npiulb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ती मानिसले याकूबलाई जित्‍न नसक्‍ने देखेपछि तिनले याकूबको कम्मरको खोक्रो भागमा प्रहार गरे । याकूब तिनीसित कुस्ती खेल्दा तिनको कम्मरको गेडी फुस्क्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ती मानिसले भने, “मलाई जान देऊ किनकि उज्यालो हुँदै छ ।” याकूबले भने, “तपाईंले मलाई आशिष् नदिउञ्‍जेलसम्म म तपाईंलाई जान दिन्‍नँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ती मानिसले तिनलाई भने, “तिम्रो नाउँ के हो?” याकूबले जवाफ दिए, “याकूब ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ती मानिसले भने, “अबदेखि उसो तिम्रो नाउँ याकूब नभई इस्राएल हुनेछ । किनकि तिमीले परमेश्‍वर र मानिसहरूसित कुस्ती खेली जित हासिल गरेका छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याकूबले तिनलाई सोधे, “कृपया, मलाई तपाईंको नाउँ बताइदिनुहोस् ।” तिनले भने, “किन तिमी मेरो नाउँ सोध्छौ?” त्यसपछि त्यहाँ तिनले याकूबलाई आशिष् दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","याकूबले त्यस ठाउँको नाउँ पनीएल राखे किनकि तिनले भने, “मैले परमेश्‍वरलाई आमने-सामने देखेर पनि मेरो ज्यान जोगिएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","याकूबले पनीएल पार गर्दा सूर्योदय भइसकेको थियो । तिनको कम्मरको कारणले गर्दा तिनी खोच्याएर हिँड्दै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","यसैकारण आजको दिनसम्म इस्राएलका मानिसहरूले कम्मरको नसा खाँदैनन् किनकि ती मानिसले याकूबको कम्मरको गेडी फुस्काउँदा ती नसाहरूमा चोट पुर्‍याएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूबले माथि हेर्दा एसाव आउँदै थिए, र तिनीसित चार सय मानिस थिए । तिनले आफ्ना छोराछोरीहरूलाई लेआ, राहेल र दुई जना कमारीको बिचमा विभाजन गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","तब तिनले कमारीहरू र तिनीहरूका छोराछोरीहरूलाई अग्रपङ्क्तिमा राखे; त्यसपछि लेआ र उनका छोराछोरीहरू अनि अन्त्यमा राहेल र योसेफलाई राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","तिनी आफैचाहिँ तिनीहरूभन्दा अगिअगि गए । तिनी आफ्ना दाजुको नजिक नआउञ्‍जेलसम्म तिनले सात पटक भुइँमा शिर निहुर्‍याउँदै गए । ");
INSERT INTO npiulb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","एसाव याकूबलाई भेट्न दौडिए; अङ्गालो हाले; अङ्कमाल गरे र चुम्बन गरे । त्यसपछि तिनीहरू रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसावले हेर्दा तिनले स्‍त्रीहरू र केटाकेटीहरूलाई देखे । तिनले भने, “तिमीसँगै आएका यी मानिसहरू को हुन्?” याकूबले भने, “तपाईंका दासलाई परमेश्‍वरले अनुग्रहसाथ दिनुभएका छोराछोरीहरू हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","त्यसपछि आ-आफ्ना छोराछोरीहरू लिएर कमारीहरू आएर एसावलाई ढोग गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","अनि लेआ र उनका छोराछोरीहरू आएर ढोग गरे । अन्त्यमा योसेफ र राहेल आएर ढोग गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसावले भने, “मैले भेटेका यी सबै दलको अर्थ के हो?” याकूबले जवाफ दिए, “मेरा मालिकको दृष्‍टिमा निगाह प्राप्‍त गर्नलाई हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसावले भने, “मेरा भाइ, मसित प्रशस्त छ । तिम्रो जे हो, ती आफैसित राख ।” ");
INSERT INTO npiulb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूबले भने, “त्यसो होइन । मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने मेरो हातबाट उपहार ग्रहण गर्नुहोस् । किनभने मैले तपाईंको मुहार देखेको छु, र यो परमेश्‍वरको मुहार देखेजस्तै भएको छ र तपाईंले मलाई ग्रहण गर्नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","कृपया, तपाईंको लागि ल्याइएको यो उपहारलाई ग्रहण गर्नुहोस् किनभने परमेश्‍वरले मसित अनुग्रहसाथ व्यवहार गर्नुभएको छ, र मसित प्रशस्तै छ ।” यसरी याकूबले बिन्ती गरेपछि एसावले त्यसलाई स्वीकार गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","तब एसावले भने, “हामी आफ्नो बाटो लागौँ । म तिम्रो अगिअगि जानेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकूबले तिनलाई भने, “मेरा मालिकलाई थाहै छ, कि यी केटाकेटीहरू सानै छन् र यी गाईबस्तुहरूले दुध चुसाउँदै छन् । तिनीहरूलाई एकै दिन मात्र बेसरी धपाइयो भने ती सबै मर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","यसैले मेरा मालिक आफ्ना दासभन्दा अगिअगि जानुहोस् भनी म बिन्ती गर्दछु । सेइरमा मेरा मालिककहाँ नआइपुगुञ्‍जेलसम्म म गाईबस्तुको चाल र केटाकेटीहरूको चालमा निकै बिस्तारै हिँड्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसावले भने, “म तिमीसित भएका केही मानिसहरूसित मेरा केही मानिसहरू छाडिदिन्छु ।” तर याकूबले भने, “किन त्यसो गर्ने?” मेरा मालिकको दृष्‍टिमा मैले निगाह पाए त भइहाल्यो नि ।” ");
INSERT INTO npiulb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","त्यसैले त्यही दिन एसाव सेइरतर्फ फर्कन आफ्नो बाटो लागे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकूब सुक्‍कोततर्फ लागे । त्यहाँ तिनले डेरा हाले र आफ्ना गाईबस्तुहरूका निम्ति छाप्रा हाले । त्यसकारण त्यस ठाउँको नाउँ सुक्‍कोत राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकूब पद्दन-आरामबाट आउँदा तिनी शकेमको सहरमा सुरक्षितसाथ आइपुगे जुन ठाउँ कनान देशमा पर्छ । तिनले सहरनजिकै पाल टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","त्यसपछि तिनले एक सय चाँदीका सिक्‍कामा शकेमका पिता हमोरका छोराहरूबाट एउटा जग्गा किने र त्यहीँ नै आफ्नो पाल टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","त्यहाँ तिनले एउटा वेदी बनाए र त्यसको नाउँ एल-एलोह-एस्राएल राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","अब लेआले याकूबको निम्ति जन्माएकी छोरी दीना त्यस देशका युवतीहरूसित भेट गर्न गइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","त्यस देशका रजौटा हिव्वी हमोरको छोरा शकेमले उनलाई देखी उनलाई प्रकेर लगे र उनीसित सहवास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","तिनी याकूबकी छोरी दीनासित मोहित भएका थिए । तिनले यी युवतीलाई प्रेम गरी स्‍नेहपूर्वक बोले । ");
INSERT INTO npiulb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","शकेमले आफ्ना पिता हमोरलाई यसो भने, “मेरी पत्‍नी हुनलाई ती युवती मलाई ल्याइदिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","अब याकूबले आफ्नी छोरी दीनालाई शकेमले अशुद्ध पारेको कुरा सुने । तिनका छोराहरू खेतमा गाईबस्तु चराउन गएका थिए । त्यसैले तिनीहरू नफर्कुञ्‍जेल याकूब चुप लागेर बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","शकेमका पिता हमोर याकूबसित कुराकानी गर्न गए । ");
INSERT INTO npiulb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","याकूबका छोराहरू खेतबाट फर्कंदा तिनीहरूले यस विषयबारे सुने । तिनीहरूलाई चोट पुगेको थियो । याकूबकी छोरीमाथि जबरजस्ती सहवास गरेर तिनले इस्राएलको बेइज्‍जत गरेकाले तिनीहरू ज्यादै रिसाए । किनकि यस्तो कुरो गरिनुहुँदैनथ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोरले तिनीहरूलाई भने, “मेरो छोरो शकेमले तपाईंकी छोरी दीनालाई माया गर्छन् । कृपया, उनलाई तिनकी पत्‍नी हुन दिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","हामीसित अन्तरजातीय विवाह गर्नुहोस् । तपाईंका छोरीहरू हामीलाई दिनुहोस् र हाम्री छोरीहरू तपाईंहरूले लैजानुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तपाईंहरू हामीसितै बस्‍नुहोस् । तपाईंहरूलाई बसोबास गरी व्यापार गर्न र सम्पत्ति आर्जन गर्न यो देश खुला हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शकेमले उनका पिता र उनका दाजुहरूलाई भने, “मलाई तपाईंहरूले निगाह गर्नुहोस्, र तपाईंहरूले मलाई जे भन्‍नुहुन्छ, म त्यही दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","तपाईंहरूलाई इच्छा लागेमुताबिक जतिसुकै दाइजो र उपहार माग्‍नुुहोस् म ती दिनेछु, तर मलाई यी युवती पत्‍नी तुल्याउनलाई दिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","शकेमले दीनालाई अशुद्ध तुल्याएकाले याकूबका छोराहरूले शकेम र तिनका पिता हमोरलाई छलपूर्वक जवाफ दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","तिनीहरूले उनीहरूलाई भने, “हामी यस्तो कुरा गर्न सक्दैनौँ । खतना नगरेको कुनै पनि व्यक्तिलाई हामी हाम्री बहिनी दिन सक्दैनौँ । किनकि त्यसो गर्दा हाम्रो बेइज्‍जत हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","यो सर्तमा मात्रै हामी तपाईंहरूसित सहमत हुनेछौः हामीजस्तै तपाईंहरूको हरेक पुरुषको खतना हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब हामी हाम्रा छोरीहरू तपाईंहरूलाई दिनेछौँ र तपाईंहरूका छोरीहरू हामी लिनेछौँ अनि हामी तपाईंहरूसित बसी एउटै जाति हुनेछौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","तर तपाईंहरूले हाम्रो कुरा सुनेर खतना गर्नुभएन भने हामी हाम्री बहिनी लिएर जानेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","तिनीहरूको कुराले हमोर र तिनका छोरा शकेमलाई खुसी तुल्यायो । ");
INSERT INTO npiulb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","यिनीहरूले भनेका कुरा गर्न ती युवकले ढिला गरेनन् किनकि तिनी याकूबकी छोरीसित मोहित भएका थिए, र तिनी आफ्ना पिताको घरानामा सबैभन्दा इज्‍जतदार व्यक्ति थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","हमोर र तिनका छोरा शकेम तिनीहरूको सहरको द्वारमा गएर सहरका मानिसहरूलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“यी मानिसहरू शान्तिप्रिय छन् । त्यसैले यिनीहरू हामीसितै बसोबास गरी व्यापार गरून् किनकि वास्तवमा हाम्रो देश तिनीहरूका लागि पनि ज्यादै ठुलो छ । तिनीहरूका छोरीहरूलाई पत्‍नी बनाउनलाई लिऔँ र तिनीहरूलाई हाम्रा छोरीहरू दिऔँ । ");
INSERT INTO npiulb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","यो सर्तमा मात्रै ती मानिसहरू हामीसित बसी एउटै जाति हुन सहमत छन्: तिनीहरूजस्तै हाम्रो हरेक पुरुषको खतना हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","के तिनीहरूका सबै गाईबस्तु र सम्पत्ति अर्थात् जनावरहरू हाम्रा हुनेछैनन् र? त्यसैले तिनीहरूसित सहमत होऔँ र तिनीहरू हामीसित बसून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","सहरका सबै मानिसले हमोर र तिनका छोरा शकेमको कुरा माने, अनि हरेक पुरुषको खतना गरियो । ");
INSERT INTO npiulb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तेस्रो दिनमा तिनीहरू अझै दर्दमा हुँदा याकूबका दुई जना छोरा शिमियोन र लेवी (दीनाका दाजुहरू) ले आ-आफ्नो तरवार लिई आफ्नो सुरक्षामा ढुक्‍क रहेको सहरमाथि आक्रमण गरी सबै पुरुषलाई मारे । ");
INSERT INTO npiulb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","तिनीहरूले तरवारले हमोर र तिनका छोरा शकेमलाई मारे । तिनीहरूले दीनालाई शकेमको घरबाट लिएर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूबका अन्य छोराहरू मरेकाहरूकहाँ आई सहरलाई लुटे किनकि ती मानिसहरूले तिनीहरूकी बहिनीलाई अशुद्ध बनाएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","तिनीहरूले उनीहरूका बगालहरू, बथानहरू, गधाहरू, सबै सम्पत्ति र सहरमा भएको हरेक थोक लिएर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","तिनीहरूका सबै केटाकेटी र पत्‍नीहरूलाई तिनीहरूले कैद गरे । घरहरूभित्र भएको हरेक थोक पनि तिनीहरूले कब्जा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","याकूबले शिमियोन र लेवीलाई भने, “यस देशका बासिन्दाहरू अर्थात् कनानीहरू र परिज्‍जीहरूका सामु मलाई अप्रिय तुल्याएर तिमीहरूले ममाथि सङ्कष्‍ट ल्याएका छौ । मेरा मानिसहरू थोरै छन् तिनीहरू एकै ठाउँमा जम्मा भई ममाथि आक्रमण गरे भने म र मेरो घराना नष्‍ट हुनेछौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","तर शिमियोन र लेवीले भने, “के शकेमले हाम्री बहिनीलाई वेश्यालाई जस्तै व्यवहार गर्नहुन्छ?” ");
INSERT INTO npiulb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","परमेश्‍वरले याकूबलाई भन्‍नुभयो, “उठेर बेथेलमा जा, र त्यहीँ बस् । तँ तेरा दाजु एसावबाट भाग्दा तँकहाँ देखा पर्नुहुने परमेश्‍वरको निम्ति एउटा वेदी बना ।” ");
INSERT INTO npiulb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","त्यसपछि याकूबले तिनको घराना र तिनीसित भएका सबैलाई भने, “तिमीहरूका बिचमा भएका विदेशी देवताहरू हटाइदेओ, र आफू-आफूलाई शुद्ध पारेर लुगाहरू फेर । ");
INSERT INTO npiulb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","अनि हामी यहाँबाट प्रस्थान गरी माथि बेथेलमा जाऔँ । त्यहाँ म परमेश्‍वरको लागि एउटा वेदी बनाउनेछु जसले मेरो दुःखमा मलाई जवाफ दिनुभयो र म जहाँ गए पनि उहाँ मसित हुनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","त्यसैले तिनीहरूले आ-आफ्ना हातमा भएका सबै विदेशी देवता र तिनीहरूका कानमा लगाएका कुण्डलहरू याकूबलाई दिए । याकूबले ");
INSERT INTO npiulb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","तिनलाई शकेमको नजिकै रहेको फलाँटको रुखमुनि गाडे । तिनीहरू यात्रा गर्दै अगाडि बढ्दा परमेश्‍वरले तिनीहरूका वरिपरिका सहरहरूमा त्रास फैलाइदिनुभयो । त्यसैले ती मानिसहरूले याकूबका छोराहरूलाई लखेटेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब तिनीसित भएका सबै मानिससित लूज अर्थात् बेथेलमा आइपुगे जुन कनान देशमा पर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","त्यहाँ तिनले एउटा वेदी बनाए, र त्यसको नाउँ एल-बेथेल राखे किनकि तिनी आफ्ना दाजुबाट भाग्दा त्यहाँ परमेश्‍वरले आफैलाई तिनीकहाँ प्रकट गराउनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","त्यहाँ रिबेकाकी धाई दबोरा मरी । त्यसलाई बेथेलनेरको फलाँटको रुखमुनि गाडियो । त्यसैले यसको नाउँ अल्लोन-बकुत राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकूब पद्दन-आरामबाट आउँदा परमेश्‍वर फेरि तिनीकहाँ प्रकट हुनुभई तिनलाई आशिष् दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्‍वरले तिनलाई भन्‍नुभयो, “तेरो नाउँ याकूब हो, तर अबदेखि तेरो नाउँ याकूब भनिनेछैन । तेरो नाउँ इस्राएल हुनेछ ।” त्यसैले परमेश्‍वरले तिनको नाउँ इस्राएल राखिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","परमेश्‍वरले तिनलाई भन्‍नुभयो, “म सर्वशक्तिमान् परमेश्‍वर हुँ । फल्दै-फुल्दै वृद्धि हुँदै जा । तँबाट एउटा जाति र जाति-जातिहरूको समूह उदय हुनेछ, अनि तेरा सन्तानहरूका बिचमा राजाहरू हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","मैले अब्राहाम र इसहाकलाई दिएको देश म तँलाई दिनेछु । तँपछि उदय हुने तेरा सन्तानहरूलाई पनि म यो देश दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","तिनीसित कुराकानी गर्नुभएको ठाउँबाट परमेश्‍वर जानुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","परमेश्‍वर तिनीसित कुराकानी गर्नुभएको ठाउँमा याकूबले ढुङ्गाको एउटा वेदी खडा गरे । तिनले त्यसमाथि अर्घ-बलि चढाएर तेल खन्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","परमेश्‍वर तिनीसित बोल्नुभएको त्यस ठाउँलाई याकूबले बेथेल नाउँ दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","तिनीहरू बेथेलबाट प्रस्थान गरे । तिनीहरू एप्रात आइपुग्‍न अलिकति दुरी बाँकी छँदा नै राहेललाई सुत्केरी व्यथा लाग्यो । उनलाई ज्यादै पीडा भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","उनी अत्यधिक पीडामा हुँदा सुँडेनीले उनलाई भनी, “भयभीत नहुनुहोस् किनकि अब तपाईंले अर्को छोरो जन्माउनुहुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","उनको प्राण जाने बेलामा उनी चिच्‍च्याउँदै गर्दा उनले त्यसको नाउँ बेन-ओनी राखिन्, तर त्यसका पिताले त्यसलाई बेन्यामीन नाउँ दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","राहेल मरिन् र एप्राता (अर्थात् बेथलेहेम) जाने बाटोमा उनलाई गाडियो । ");
INSERT INTO npiulb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याकूबले उनको चिहानमा एउटा खामो खडा गरे । आजको दिनसम्म यो राहेलको चिहानको चिन्हको रूपमा खडा छ । ");
INSERT INTO npiulb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","इस्राएल अगि बढे र तिनले बगालको धरहराभन्दा पर आफ्नो पाल टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","इस्राएल त्यस देशमा बसिरहँदा रूबेन आफ्ना पिताकी भित्रिनी बिल्हासित सुते, र इस्राएलले यस विषयमा सुने । याकूबका बार्‍ह जना छोरा थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","याकूबले लेआबाट जन्माएका छोराहरू यिनै थिएः जेठो रूबेन, त्यसपछि शिमियोन, लेवी, यहूदा, इस्साखार र जबूलून । ");
INSERT INTO npiulb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलतर्फका छोराहरू यिनै थिएः योसेफ र बेन्यामीन । ");
INSERT INTO npiulb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलकी कमारी बिल्हातर्फका छोराहरू यिनै थिएः दान र नप्‍ताली । ");
INSERT INTO npiulb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआकी कमारी जिल्पातर्फका छोराहरू यिनै थिएः गाद र आशेर । यी सबै याकूबले पद्दन-आराममा जन्माएका छोराहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकूब किर्यत-अर्बा (जुन हेब्रोन हो) मा आफ्ना पिता इसहाककहाँ आए जहाँ अब्राहाम र इसहाक बसोबास गरेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक एक सय असी वर्षसम्म बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","इसहाकले आफ्नो अन्तिम सास फेरे र तिनको मृत्यु भयो अनि तिनी आफ्ना पुर्खाहरूसित मिल्न गए । तिनी पुरा बुढेसकालसम्म बाँचेका थिए । तिनका छोराहरू एसाव र याकूबले तिनलाई गाडे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव (जसलाई एदोम पनि भनिन्थ्यो) का वंशहरू यसप्रकार थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावले कनानीहरूबाट आफ्ना पत्‍नीहरू ल्याए । उनका पत्‍नीहरू यसप्रकार थिएः हित्ती एलोनकी छोरी आदा; हिव्‍वी सिबोनकी नातिनी र अनाकी छोरी ओहोलीबामा; ");
INSERT INTO npiulb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","र इश्‍माएलकी छोरी नबायोतकी बहिनी बासमत । ");
INSERT INTO npiulb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदाले एसावबाट एलीपजलाई जन्माइन्, र बासमतले रूएललाई जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ओहोलीबामाले येऊश, यालाम र कोरहलाई जन्माइन् । कनान देशमा जन्मेका एसावका छोराहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसावले आफ्ना पत्‍नीहरू, छोराछोरीहरू, र आफ्ना घरानाका सबै सदस्यहरू, आफ्ना पाल्तु पशुहरू, अनि कनान देशमा उनले प्राप्‍त गरेका सबै सम्पत्तिहरू लिएर आफ्नो भाइ याकूबबाट अलग्‍गै अर्को देशमा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","तिनीहरू सँगै बस्‍नको निम्ति तिनीहरूका सम्पत्ति ज्यादै धेरै भएकाले उनले यसो गरे । तिनीहरूका पाल्तु पशुहरूका कारण तिनीहरू बसिरहेका ठाउँले तिनीहरूलाई धान्‍न सकेन । ");
INSERT INTO npiulb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","यसैकारण एसाव (जसलाई एदोम पनि भनिन्छ) सेइरको पहाडी देशमा बसोबास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेइरको पहाडी देशमा एदोमीहरूका पूर्वज अर्थात् एसावका वंशहरू यसप्रकार थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावका छोराहरूका नाम यिनै थिएः एसावकी पत्‍नी आदाका छोरा एलीपज; एसावकी पत्‍नी बासमतका छोरा रूएल । ");
INSERT INTO npiulb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपजका छोराहरू तेमान, ओमार, सपो, गाताम, र कनज थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसावका छोरा एलीपजकी उपपत्‍नी तीम्‍नले अमालेकलाई जन्माइन् । एसावकी पत्‍नी आदाका नातिहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएलका छोराहरू यस प्रकार थिए: नहत, जेरह, शम्मा र मिज्‍जा । एसावकी पत्‍नी बासमतका नातिहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसावकी पत्‍नी, अनाकी छोरी र सिबोनकी नातिनी ओहोलीबामाका छोराहरू यी नै थिए । तिनले एसावबाट येऊश, यालाम र कोरह जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसावका वंशहरूमा नजिकका घरानाहरू यिनै थिए: एसावका जेठा छोरा एलीपजका छोराहरूः तेमान, ओमार, सपो, कनज, ");
INSERT INTO npiulb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम र अमालेक । एदोम देशमा एलीपजबाट जन्मेका नजिकका घरानाहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावका छोरा रूएलका नजिकका घरानाहरू यिनै थिएः नहत, जेरह, शम्मा र मिज्‍जा । एदोम देशमा रूएलबाट जन्मेका नजिकका घरानाहरू यी नै थिए । ती एसावकी पत्‍नी बासमतका नातिहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसावकी पत्‍नी ओहोलीबामाबाट जन्मेका नजिकका घरानाहरू यी नै थिएः येऊश, यालाम र कोरह । अनाकी छोरी एसावकी पत्‍नी ओहोलीबामाबाट जन्मेका नजिकका घरानाहरू यी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसावका छोराहरू यी नै थिए, र तिनीहरूका नजिकका घरानाहरू यी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","होरी सेइरका छोराहरू यी नै थिएः लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO npiulb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर र दीशान जो त्यस देशका बासिन्दाहरू थिए । एदोमको देशमा सेइरबाट जन्मेका बासिन्दा होरीहरूका नजिकका घरानाहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतानका छोराहरू होरी र हेमान थिए, र तीम्‍न लोतानकी बहिनी थिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालका छोराहरू यिनै थिएः अल्बान, मानहत, एबाल, शपो र ओनाम । ");
INSERT INTO npiulb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनका छोराहरू यिनै थिएः अय्‍या र अना । आफ्ना बुबा सिबोनका गधाहरू चराउँदै गर्दा मरुभूमिमा तातो पानीको मूल भेट्टाउने अना यिनी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाका छोराछोरीहरू यी थिएः दीशोन र अनाकी छोरी ओहोलीबामा । ");
INSERT INTO npiulb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोनका छोराहरू यी थिएः हेमदान, एश्‍बान, यित्रान र करान । ");
INSERT INTO npiulb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेरका छोराहरू यी थिएः बिल्हान, जावान र अकान । ");
INSERT INTO npiulb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशानका छोराहरू यी थिएः ऊज र आरान । ");
INSERT INTO npiulb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरीहरूका नजिकका घरानाहरू यी थिए: लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO npiulb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एसेर र दीशान । सेइर देशमा तिनीहरूका नजिकका घरानाहरूको सूचीअनुसारका होरीहरूका नजिकका घरानाहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इस्राएलीहरूमाथि कुनै राजाले शासन गर्नुअगि एदोम देशमा राज्य गर्ने राजाहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बओरका छोरा बेलाले एदोममा राज्य गरे, र उनको सहरको नाम दिन्हावा थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेलाको मृत्युपछि बोज्रामा बसोबास गर्ने जेरहका छोरा योबाबले उनको स्थानमा राज्य गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाबको मृत्युपछि तेमानीहरूको देशमा बसोबास गर्ने हुशामले उनको स्थानमा राज्य गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हुशामको मृत्युपछि बददका छोरा हददले उनको स्थानमा राज्य गरे जसले मोआब देशमा मिद्यानीहरूलाई परास्त गरेका थिए । उनको सहरको नाम अवीत थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हददको मृत्युपछि मस्रेकामा बसोबास गर्ने सम्लाले उनको स्थानमा राज्य गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","सम्लाको मृत्युपछि यूफ्रेटिस नदीको किनारमा रहेको रहोबोतमा बसोबास गर्ने शौलले उनको स्थानमा राज्य गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौलको मृत्युपछि, अक्बोरका छोरा बाल-हानानले उनको स्थानमा राज्य गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अक्बोरका छोरा बाल-हानानको मृत्युपछि हदरले उनको स्थानमा राज्य गरे । उनको सहरको नाम पाऊ थियो । उनकी पत्‍नीको नाम महेतबेल थियो । तिनी मत्रेदकी छोरी र मे-जाहाबकी नातिनी थिइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसावका वंशहरूबाट तिनीहरूका नजिकका घराना र क्षेत्रहरू, र तिनीहरूका नामहरूअनुसार नजिकका घरानाहरूका मुखियाहरूका नाम यी थिएः तीम्‍न, अल्वा, यतेत, ");
INSERT INTO npiulb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा, एलाह, पीनोन, ");
INSERT INTO npiulb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज, तेमान, मिब्सार, ");
INSERT INTO npiulb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल र ईराम । तिनीहरूका देशमा तिनीहरूका बसोबासअनुसारका एदोमका नजिकका घरानाका मुखियाहरू यी नै थिए । एदोमीहरूका पिता एसाव यिनी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब आफ्ना बुबा बसोबास गर्दै आएका कनान देशमा बस्दथे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकूबका विषयमा भएका घटनाहरूका वृत्तान्त यिनै थिए । सत्र वर्षका जवान योसेफ आफ्ना दाजुहरूसँग भेडाबाख्राहरूका बगाल हेर्दै थिए । उनी आफ्ना बुबाका उपपत्‍नीहरू बिल्हा र जिल्पाका छोराहरूसँग थिए । योसेफले आफ्ना बुबाकहाँ तिनीहरूका विषयमा खराब खबर ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएलले आफ्ना सबै छोराहरूमध्ये योसेफलाई धेरै माया गर्दथे किनभने उनी तिनका बुढेसकालका छोरा थिए । तिनले उनको निम्ति एउटा सुन्दर वस्‍त्र बनाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","उनका दाजुहरूले तिनीहरूका बुबाले उनलाई सबै दाजुभाइहरूभन्दा धेरै माया गरेका देखे । तिनीहरूले योसेफलाई घृणा गर्थे र उनीसँग राम्ररी बोल्दैनथे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","योसेफले एउटा सपना देखे जसको विषयमा उनले आफ्ना दाजुहरूलाई बताए । त्यसपछि तिनीहरूले उनलाई झनै धेरै घृणा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","उनले तिनीहरूलाई भने, “कृपया मैले देखेको सपनालाई सुन्‍नुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हामी खेतमा अन्‍नका बिटाहरू बाँधिरहेका थियौँ अनि मेरो बिटाचाहिँ ठाडो भई उठ्यो, र तपाईंहरूका बिटाहरू मेरो बिटाको वरिपरि आई त्यसलाई दण्डवत् गरे । ” ");
INSERT INTO npiulb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","उनका दाजुहरूले उनलाई भने, “के तैँले साँच्‍चै हामीमाथि शासन गर्नेछस्? के साँच्‍चै हामीमाथि तैँले अधिकार गर्नेछस्?” उनका सपना र उनले भनेका कुराहरूका कारण तिनीहरूले उनलाई झनै धेरै घृणा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","उनले अर्को एउटा सपना देखे जसको विषयमा उनले आफ्ना दाजुहरूलाई बताए । उनले भने, “हेर्नुहोस्, मैले अर्को सपना देखेँः सूर्य, चन्द्र र एघारवटा ताराले मलाई दण्डवत् गरे ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","आफ्ना दाजुहरूलाई झैँ उनले यो कुरा आफ्ना बुबालाई पनि बताए, तर उनका बुबाले उनलाई हप्‍काए । तिनले उनलाई भने, “तिमीले देखेको यो सपना के हो? के तिम्री आमा र म अनि तिम्रा सबै दाजुहरूले साँच्‍चै तिम्रोअगि भुइँसम्मै झुकेर दण्डवत् गर्नेछन्?” ");
INSERT INTO npiulb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","उनका दाजुहरूले उनको ईर्ष्‍या गर्न लागे, तर उनका बुबाले यो विषयलाई आफ्नो मनमा नै राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","उनका दाजुहरू आफ्ना बुबाका भेडाबाख्राहरूका बगाललाई चराउन शकेममा गएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","इस्राएलले योसेफलाई भने, “के तिम्रा दाजुहरू शकेममा भेडाबाख्राहरूका बगाल चराइरहेका छैनन् र? आऊ, र म तिमीलाई तिनीहरूकहाँ पठाउनेछु ।” योसेफले तिनलाई भने, “म तयार छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","तिनले उनलाई भने, “अहिले नै जाऊ र तिम्रा दाजुहरू र बगाल ठिकै छन् कि छैनन् हेर, र मकहाँ खबर ल्याऊ ।” यसैकारण याकूबले उनलाई हेब्रोनको बेँसीबाट बाहिर शकेममा पठाए, अनि उनी त्यहाँ गए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","एक जना मानिसले योसेफलाई भेट्टाए । योसेफ खेतमा डुलिरहेका थिए । त्यस मानिसले उनलाई सोधे, “तिमी के खोजिरहेका छौ?” ");
INSERT INTO npiulb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","योसेफले भने, “म मेरा दाजुहरूलाई खोजिरहेको छु । उहाँहरूले बगाल कहाँ चराउँदै हुनुहुन्छ कृपया मलाई बताउनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","त्यस मानिसले भने, “तिनीहरू यस ठाउँबाट गइसके, तर मैले तिनीहरूले यसो भनेका सुनेको थिएँ, ‘हामी दोतानतिर जाऔँ ।’” योसेफ आफ्ना दाजुहरूका पछिपछि गए र तिनीहरूलाई दोतानमा भेट्टाए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","तिनीहरूले उनलाई टाढैबाट आइरहेको देखे, र उनी तिनीहरूका नजिक आइपुग्‍नअगि नै तिनीहरूले उनलाई मार्ने मतो गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","उनका दाजुहरूले एक-अर्कासँग भने, “हेर, त्यो स्वप्‍न-दर्शी आउँदै छ । ");
INSERT INTO npiulb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","अब, हामी त्यसलाई मारौँ र त्यसलाई यी खाडलहरूमध्ये एउटामा फालिदिऔँ । हामी यस्तो भनिदिउँला, ‘कुनै जङ्गली जनावरले त्यसलाई खाएछ ।’ अनि त्यसका सपनाहरू के हुनेछन् भनेर हामी हेर्नेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","रूबेनले यो सुने र उनलाई तिनीहरूका हातबाट बचाए । उनले भने, “हामी त्यसको प्राण नलिऔँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","तिनीहरूका हातबाट बचाई आफ्ना बुबाकहाँ ल्याउने योजना राखी रूबेनले तिनीहरूलाई भने, “रगत नबगाऔँ । मरुभूमिको खाडलमा त्यसलाई फ्याँकिदेओ, तर त्यसमाथि हात नउठाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","जब योसेफ दाजुहरूकहाँ आइपुगे, तिनीहरूले उनको त्यो सुन्दर वस्‍त्र च्यातिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","तिनीहरूले उनलाई पक्रेर खाडलमा फ्याँकिदिए । त्यो खाडलमा पानी थिएन र त्यो सुक्‍खा थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","तिनीहरू भोजन गर्न बसे । तिनीहरूले आफ्ना आँखा उठाएर हेरे, र गिलादबाट ऊँटहरूमा मसलाहरू, लेप र मुर्र लिएर आइरहेको इश्माएलीहरूको एउटा यात्री दललाई देखे । तिनीहरू ती सरसामान लिएर मिश्रतर्फ यात्रा गर्दै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","यहूदाले आफ्ना दाजुभाइहरूलाई भने, “हामीले आफ्नो भाइलाई मारेर त्यसको रगत लुकाएर हामीलाई के फाइदा? ");
INSERT INTO npiulb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","आओ, त्यसलाई यी इश्माएलीहरूलाई बेचिदिऔँ र त्यसमाथि हात नउठाऔँ । किनकि त्यो हाम्रै रगत, हाम्रै भाइ हो ।” उनका दाजुभाइहरूले उनको कुरा सुने । ");
INSERT INTO npiulb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","मिद्यानी व्यापारीहरू त्यहाँबाट भएर गए । योसेफका दाजुहरूले उनलाई माथि उठाए र त्यस खाडलबाट बाहिर निकाले । तिनीहरूले योसेफलाई इश्माएलीहरूका हातमा चाँदीका बिस सिक्‍कामा बेचिदिए । ती इश्माएलीहरूले योसेफलाई मिश्रमा लगे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","पछि रूबेन त्यस खाडलमा फर्केर गए, तर योसेफ भने खाडलमा थिएनन् । उनले आफ्ना लुगाहरू च्याते । ");
INSERT INTO npiulb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","उनी आफ्ना दाजुभाइहरूकहाँ फर्के र भने, “त्यो केटो त त्यहाँ छैन! अब म कहाँ जाऊँ?” ");
INSERT INTO npiulb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","तिनीहरूले एउटा बोका मारे अनि त्यसपछि योसेफको वस्‍त्र लिएर त्यसलाई रगतमा चोपे। ");
INSERT INTO npiulb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","त्यस वस्‍त्रलाई तिनीहरूले आफ्ना बुबाकहाँ ल्याएर भने, “हामीले यो भेट्टायौँ । कृपया यो तपाईंको छोराको लुगा हो कि होइन हेर्नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","याकूबले आफ्ना छोराको लुगा चिने र भने, “यो त मेरो छोराको लुगा हो । उसलाई जङ्गली जनावरले खाएछ । योसेफलाई पक्‍कै पनि त्यसले टुक्रा-टुक्रा पार्‍यो होला ।” ");
INSERT INTO npiulb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","याकूबले आफ्ना वस्‍त्र च्याते र आफ्नो कम्मरमा भाङ्‍ग्रा लगाए । तिनले आफ्ना छोराको निम्ति धेरै दिनसम्म शोक गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","तिनका सबै छोराछोरीहरू तिनलाई सान्त्वना दिन तिनको नजिक आए, तर तिनले त्यो इन्कार गरे । तिनले भने, “म मेरो छोराको निम्ति शोक गर्दै चिहानमा पुग्‍नेछु ।” उनका बुबा उनको निम्ति रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","मिद्यानीहरूले उनलाई मिश्रमा फारोका एक अधिकृत अर्थात् अङ्गरक्षकहरूका कप्‍तान पोतीफरका हातमा बेचिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","त्यस समयमा यहूदा आफ्ना दाजुभाइहरूलाई छोडेर हीरा नाउँ भएको कुनै एउटा अदुल्लामवासीकहाँ बस्दथे । ");
INSERT INTO npiulb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","त्यहाँ उनले एउटा कनानी मानिसकी छोरीलाई भेटे जसको नाम शूआ थियो । उनले तिनीसँग विवाह गरे र सहवास गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","तिनी गर्भवती भइन् र एउटा छोरो जन्माइन् । त्यसको नाउँ एर् राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","तिनी फेरि गर्भवती भइन् र अर्को छोरो जन्माइन् । तिनले त्यसको नाउँ ओनान राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","तिनले फेरि अर्को छोरो जन्माइन् र त्यसको नाउँ शेलह राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाले आफ्नो जेठो छोरा एर‍्को निम्ति एउटी पत्‍नी ल्याइदिए । तिनको नाउँ तामार थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","तर यहूदाको जेठो छोरो एर् परमप्रभुको दृष्‍टिमा दुष्‍ट थियो । यसैकारण परमप्रभुले त्यसको प्राण लिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","यहूदाले ओनानलाई भने, “तँ आफ्नो दाजुकी पत्‍नीसँग सहवास गर्। आफ्नी भाउजूप्रति देवरको कर्तव्य पूरा गर्, र आफ्नो दाजुको निम्ति एउटा बालक हुर्का ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","त्यो बालक आफ्नो हुनेछैन भनेर ओनानलाई थाहा थियो । आफ्नो दाजुकी पत्‍नीसँग सहवास गर्दा दाजुको कुनै सन्तान नहोस् भनेर उसले आफ्नो वीर्य भुइँमा पतन गर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","उसले जे गर्‍यो त्यो परमप्रभुको दृष्‍टिमा खराब थियो । परमप्रभुले त्यसको पनि प्राण लिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","त्यसपछि यहूदाले आफ्नी बुहारी तामारलाई भने, “मेरो छोरो शेलह ठुलो नभएसम्म तिम्रा बुबाकै घरमा विधवा नै भएर बस ।” किनभने अरू दाजुहरूझैँ शेलह पनि मर्छ कि भनेर उनी डराए । त्यसैकारण तामार तिनका बुबाकै घरमा बसिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","त्यसको धेरै समयपछि शूआकी छोरी यहूदाकी पत्‍नीको मृत्यु भयो । यहूदाले शोक गरिसकेपछि उनी र उनका मित्र अदुल्लामवासी हीराका साथ आफ्ना भेडा कत्रनेहरूकहाँ तिम्‍नामा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","तामारलाई यसो भनियो, “हेर, तिम्रा ससुरा आफ्ना भेडा कत्रन तिम्‍ना जाँदै हुनुहुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तिनले विधवाको वस्‍त्र फुकालिन्, घुम्टोले आफ्नो टाउको र अनुहार ढाकिन् र अरूहरूले तिनलाई नचिनून् भनेर आफैँलाई कपडाले ढाकिन् । तिनी तिम्‍नाको बाटोमा रहेको एनैमको द्वारमा बसिन् । किनकि शेलह ठुलो भइसकेका तर तिनलाई उनकी पत्‍नी हुनलाई नदिइएको तिनले देखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जब यहूदाले तिनलाई देखे तिनले आफ्नो अनुहार ढाकेकी हुनाले तिनलाई एउटा वेश्या ठाने । ");
INSERT INTO npiulb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","तिनी आफ्नी बुहारी हुन् भन्‍ने थाहा नभएर उनी तिनीकहाँ सडकको किनारमा गए र भने, “आऊ, मलाई तिमीसँग सुत्‍न देऊ” अनि तिनले भनिन्, “तपाईं मसँग सुत्‍नका लागि मलाई के दिनुहुन्छ?” ");
INSERT INTO npiulb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","उनले भने, “म तिम्रो निम्ति बगालबाट एउटा पाठो दिनेछु ।” तिनले भनिन्, “के तपाईंले त्यो मकहाँ नपठाउन्जेल केही बन्धक राख्‍नुहुनेछ?” ");
INSERT INTO npiulb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","उनले भने, “म तिमीलाई बन्धकको रूपमा के दिऊँ?” तिनले जवाफ दिइन्, “तपाईंको छाप, त्यसको डोरी, र तपाईंको हातमा भएको त्यो लौरो ।” उनले ती सबै तिनलाई दिए र तिनीसँग सुते, अनि तिनी उनीद्वारा गर्भवती भइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","त्यसपछि तिनी उठेर गइहालिन् । तिनले आफ्नो घुम्टो हटाएर विधवाको वस्‍त्र लगाइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदाले ती स्‍त्रीका हातबाट बन्धकमा रहेका सामान प्राप्‍त गर्न आफ्ना मित्र अदुल्लामवासीसँग एउटा पाठो पठाए, तर उनले तिनलाई भेट्टाएनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","त्यसपछि त्यस अदुल्लामवासीले त्यहाँका मानिसहरूलाई सोधे, “मन्दिरमा सेवा गर्ने त्यो वेश्या कहाँ गई जो सडक नजिक एनैममा थिई?” तिनीहरूले भने, “मन्दिरमा सेवा गर्ने कोही वेश्या यहाँ छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","उनी यहूदाकहाँ फर्के र भने, “मैले त्यसलाई भेट्टाइनँ । र त्यस ठाउँका मानिसहरूले पनि भने, ‘मन्दिरमा सेवा गर्ने कोही वेश्या यहाँ छैन’ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यहूदाले भने, “त्यसले नै ती सामानहरू राखोस्, र हामी शर्ममा पर्नेछैनौँ । मैले त यो पाठो पठाएकै हो, तर तिमीले त्यसलाई भेट्टाएनौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","त्यसको करिब तिन महिनापछि यहूदालाई भनियो, “तपाईंकी बुहारी तामारले वेश्याकर्म गरेकी छे, र त्यो गर्भवती भएकी छे । ” यहूदाले भने, “त्यसलाई मकहाँ ल्याओ र त्यसलाई जलाइयोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","जब तिनलाई ल्याइँदै थियो, तिनले आफ्नो ससुरालाई एउटा सन्देश पठाए, “यी सामानहरू जसका हुन् म त्यही मानिसद्वारा गर्भवती भएकी हुँ ।” तिनले भनिन्, “यो छाप, त्यसको डोरी र यो लौरो कसका हुन् कृपया पत्ता लगाइदिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाले ती सामानहरू चिने र भने, “मैले यिनलाई मेरो छोरो शेलहकी पत्‍नी हुन नदिएको हुनाले यिनी मभन्दा पनि धेरै धर्मी छिन्, ।” त्यसपछि उनी कहिल्यै तिनीसँग सुतेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","तिनको बच्‍चा जन्माउने समय भयो । तिनको गर्भमा जुम्ल्याहा थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","तिनले बच्‍चा जन्माइरहँदा एउटाले आफ्नो हात बाहिर निकाल्यो, र सुँडेनीले एउटा गाढा रातो धागो लिएर त्यसको हातमा बाँधिदिएर भनी, “योचाहिँ पहिले बाहिर आयो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","तर त्यसपछि त्यसले आफ्नो हात भित्र लग्यो, र त्यसको भाइ पहिला बाहिर निस्कियो । सुँडेनीले अचम्म मानेर भनी, “यो कसरी पहिला बाहिर आयो!” यसैकारण त्यसको नाउँ फारेस राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","त्यसपछि हातमा गाढा रातो धागो भएको त्यसको दाजु बाहिर आयो, र त्यसको नाउँ जेरह राखियो । ");
INSERT INTO npiulb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","योसेफलाई मिश्रमा लगियो । अङ्गरक्षकहरूका एक मिश्री कप्‍तान फारोका अधिकारी पोतीफरले उनलाई इश्माएलीहरूबाट किने । ");
INSERT INTO npiulb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","परमप्रभु योसेफसँग हुनुहुन्थ्यो र उनी एक समृद्ध मानिस भए । उनी आफ्ना मिश्री मालिकका घरमा बस्थे । ");
INSERT INTO npiulb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","परमप्रभु उनीसँग हुनुहुन्छ र उनले गर्ने सबै काममा उनलाई समृद्धि मिल्छ भन्‍ने कुरा उनको मालिकले देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","योसेफले तिनको कृपादृष्‍टि पाए । उनले पोतीफरको सेवा गरे । पोतीफरले योसेफलाई आफ्नो घर र तिनको स्वामित्वमा रहेका सबै कुरामाथि अधिकार दिए, र ती उनको जिम्मामा लगाए । ");
INSERT INTO npiulb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","तिनको घर र तिनको स्वामित्वमा रहेका सबै कुरामाथि योसेफलाई अधिकार दिएपछि योसेफको कारण परमप्रभुले त्यस मिश्रीको घरलाई आशिषित् गर्नुभयो । पोतीफरको घर र खेतमा भएका सबै कुरामाथि परमप्रभुको आशिष् रह्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","पोतीफरले आफ्ना सबै कुरा योसेफको जिम्मामा दिए । तिनले आफूले खाने भोजनबाहेक अरू कुनै कुराको विषयमा पनि चिन्ता लिनु पर्दैनथ्यो । योसेफ सुन्दर र आकर्षक थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","योसेफका मालिककी पत्‍नीले उनीप्रति चाहना राखिन् । तिनले भनिन्, “मसँग सुत ।” ");
INSERT INTO npiulb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","उनले इन्कार गरेर आफ्ना मालिककी पत्‍नीलाई यसो भने, “हेर्नुहोस्, मेरा मालिकले यस घरमा म के गर्छु भन्‍ने कुराप्रति कुनै चिन्ता गर्नुहुन्‍न, र उहाँका सबै कुरा उहाँले मेरै जिम्मामा दिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","मभन्दा ठुलो यस घरमा कोही छैन । उहाँले तपाईंबाहेक सबै कुरा मलाई दिनुभएको छ, किनभने तपाईं उहाँकी पत्‍नी हुनुहुन्छ । यसैकारण मैले कसरी यस्तो दुष्‍ट काम गरी परमेश्‍वरको विरुद्ध पाप गर्न सक्छु?” ");
INSERT INTO npiulb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","तिनले योसेफसँग दिनहुँ कुरा गरिन्, तर उनी तिनीसँग सुत्‍न वा तिनको नजिक जान इन्कार गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन उनी आफ्ना काम गर्न घरभित्र प्रवेश गरे । घरभित्र कोही पनि मानिस थिएन । ");
INSERT INTO npiulb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तिनले उनको लुगा समातिन् र भनिन्, “मसँग सुत ।” उनले आफ्ना लुगा तिनकै हातमा छोडेर बाहिर भागे । ");
INSERT INTO npiulb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जब योसेफ आफ्ना लुगा छोडेर बाहिर भागेका तिनले देखिन्, ");
INSERT INTO npiulb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तिनले आफ्ना घरका मानिसहरूलाई बोलाएर भनिन्, “हेर, पोतीफरले हाम्रो बेइज्‍जत गर्न एउटा हिब्रूलाई ल्याउनुभएको छ । त्यो मकहाँ सुत्‍न भनेर आयो, अनि म चिच्याएँ । ");
INSERT INTO npiulb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जब त्यसले म चिच्‍याएकी सुन्यो, त्यसले आफ्ना लुगा मकहाँ छोडेर बाहिर भाग्यो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","तिनको मालिक घर नआउन्जेलसम्म तिनले त्यो लुगा आफ्नै साथमा राखिन् । ");
INSERT INTO npiulb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तिनले उनलाई यसरी वर्णन गरिन्, “तपाईंले हाम्रो निम्ति ल्याउनुभएको त्यो हिब्रू नोकर मेरो बेइज्‍जत गर्न मकहाँ आयो । ");
INSERT INTO npiulb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","जब म चिच्‍याएँ, त्यसले आफ्ना लुगा मकहाँ छोडेर बाहिर भाग्यो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","आफ्नो नोकरले आफ्नी पत्‍नीलाई गरेको व्यवहार आफ्नी पत्‍नीबाट सुनेपछि तिनी रिसले चुर भए । ");
INSERT INTO npiulb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफका मालिकले उनलाई झ्यालखानामा राखे जहाँ राजाका कैदीहरू राखिन्थे । उनी त्यही झ्यालखानामा थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","तर परमप्रभु योसेफसँग हुनुहुन्थ्यो र आफ्ना करारप्रति उहाँ भरोसायोग्य रहनुभयो । झ्यालखानाका हाकिमको नजरमा उहाँले उनलाई कृपादृष्‍टि दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","झ्यालखानाका हाकिमले झ्यालखानाका सबै कैदीहरू योसेफको जिम्मामा दिए । तिनीहरूले गर्ने काममाथि योसेफकै निगरानी हुन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","उनको जिम्मामा भएका कुनै कुरामा त्यस झ्यालखानाका हाकिम चिन्तित हुँदैन थिए, किनभने परमप्रभु उनीसँग हुनुहुन्थ्यो । उनले जे गर्थे, परमप्रभुले समृद्धि प्रदान गर्नुहुन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","मिश्रका राजाका पियाउने र पकाउनेले आफ्ना मालिकको विरुद्ध काम गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","आफ्ना यी दुई अधिकार प्राप्‍त मुख्‍य पियाउने र पकाउनेसँग फारो क्रोधित भए । ");
INSERT INTO npiulb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","उनले तिनीहरूलाई अङ्गरक्षकहरूका कप्‍तानको घरमा कैदमा राखे, जहाँ योसेफलाई पनि राखिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","अङ्गरक्षकहरूका कप्‍तानले योसेफलाई तिनीहरूको सेवा गर्ने जिम्मा दिए । तिनीहरू त्यस झ्यालखानामा केही समयसम्म रहे । ");
INSERT INTO npiulb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ती झ्यालखानामा भएका मिश्रका राजाका पकाउने र पियाउने दुवैले एकै रात आ-आफ्नै सपना देखे, र ती दुवै सपनाका आ-आफ्नै अर्थ थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","योसेफ बिहान तिनीहरूकहाँ आए र तिनीहरूलाई उदास देखे । ");
INSERT INTO npiulb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","उनले आफ्ना मालिकका घरमा भएको झ्यालखानामा उनीसँगै भएका फारोका अधिकारीहरूलाई भने, “तपाईंहरू आज किन यति धेरै उदास देखिनुहुन्छ?” ");
INSERT INTO npiulb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","तिनीहरूले उनलाई भने, “हामी दुवैले एउटा सपना देखेका छौँ र कसैले पनि त्यसको अर्थ खोल्न सकेको छैन ।” योसेफले तिनीहरूलाई भने, “के सबै अर्थहरू परमेश्‍वरका नै होइनन् र? कृपया, मलाई ती बताउनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","मुख्य पियाउनेले योसेफलाई आफ्नो सपना भने । तिनले उनलाई भने, “मेरो सपनामा मेरोअगि एउटा दाखको बोट थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","त्यस दाखको बोटमा तिनवटा हाँगा थिए । जब त्यसमा टुसा पलायो , त्यसमा फूलहरू निस्किए र दाखका झुप्‍पाहरू पाके । ");
INSERT INTO npiulb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","फारोको कचौरा मेरो हातमा थियो । मैले ती दाख लिएँ र फारोको कचौरामा निचरेँ, र त्यस कचौरालाई फारोका हातमा टक्र्याएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","योसेफले तिनलाई भने, “यसको अर्थ यस्तो छ । तिनवटा हाँगा भनेको तिन दिन हो । ");
INSERT INTO npiulb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तिन दिनभित्र फारोले तपाईंको शिर उच्‍च पार्नुहुनेछ र तपाईंलाई तपाईंको काममा पुनर्स्थापित गर्नुहुनेछ । तपाईं फारोका पियाउने हुनुहुँदाजस्तै तपाईंले फारोको कचौरालाई उहाँका हातमा टक्र्याउनुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","तर तपाईंको भलो हुँदा मलाई सम्झनुहोस्, र कृपया ममाथि दया देखाउनुहोस् । मेरो विषयमा फारोलाई बताएर मलाई यस झ्यालखानाबाट बाहिर निकालिदिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","किनकि मलाई वास्तवमा हिब्रूहरूका देशबाट अपहरण गरी ल्याइएको थियो । यहाँ पनि यस झ्यालखानामा राखिनुपर्ने कुनै काम मैले गरेको छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","जब मुख्य पकाउनेले सपनाको अर्थ असल भएको देखे, उनले योसेफलाई भने, “मैले पनि एउटा सपना देखेको थिएँ । रोटीका तिनवटा टोकरी मेरो टाउकोमाथि थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सबैभन्दा माथिको टोकरीमा फारोका निम्ति सबै किसिमका पकाइएका खाने कुरा थिए, तर चराहरूले मेरो टाउकोमाथिको टोकरीबाट ती खाइदिए ।” ");
INSERT INTO npiulb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","योसेफले जवाफ दिए, “यसको अर्थ यस्तो छ । तिनवटा टोकरी भनेको तिन दिन हो । ");
INSERT INTO npiulb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","तिन दिनभित्र फारोले तपाईंको शिर उठाएर तपाईंलाई रुखमा झुण्ड्याइदिनुहुनेछ । चराहरूले तपाईंको मासु खानेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","त्यसपछिको तेस्रो दिन फारोको जन्म दिन थियो । तिनले आफ्ना सबै नोकरहरूका निम्ति भोजको आयोजना गरे । आफ्ना नोकरहरूका माझमा तिनले मुख्य पियाउने र मुख्य पकाउनेलाई उभ्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","तिनले मुख्य पियाउनेलाई उनको जिम्मेवारीमा पुनर्स्थापित गरिदिए, र उनले फेरि फारोका हातमा कचौरा टक्र्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","तर योसेफले तिनीहरूलाई अर्थ बताएझैँ फारोले मुख्य पकाउनेलाई झुण्ड्याइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","मुख्य पियाउनेले भने योसेफलाई सम्झेनन्, तर उनलाई बिर्सिहाले । ");
INSERT INTO npiulb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","दुई वर्षको अन्त्यमा फारोले एउटा सपना देखे । तिनी नील नदीको किनारमा उभिए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","नील नदीबाट सातवटा सप्रेका र मोटा-मोटा गाई निस्केर आए, अनि तिनीहरू नर्कटको झाडीमा चरे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","नील नदीबाट अरू सातवटा नसप्रेका र दुब्ला-दुब्ला गाई निस्केर आए । तिनीहरू नदीको किनारमा उभिरहेका पहिलेका गाईहरूसँगै उभिए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","त्यसपछि नसप्रेका र दुब्ला-दुब्ला गाईहरूले सातवटा सप्रेका र मोटा-मोटा गाईलाई खाइदिए । अनि फारो ब्युँझे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","तिनी फेरि सुते र अर्को सपना देखे । सातवटा भरिला र असल अनाजका बाला एउटै डाँठमा उम्रे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","त्यसपछि सेप्रा र पूर्वीय बतासद्वारा ओइलाइएका अरू सातवटा अन्‍नका बाला तिनीहरू पछि पलाए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","सेप्रा बालाहरूले ती सातवटा भरिला र असल बालालाई खाइदिए । फारो ब्युँझे, र यो त सपना पो रहेछ भनी तिनलाई थाहा भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","बिहान तिनको आत्मा बेचैन भयो । तिनले मिश्रका सबै जादुगर र बुद्धिमान् मानिसहरूलाई बोलाउन पठाए । फारोले तिनीहरूलाई आफ्ना सपनाहरू बताए, तर फारोलाई सपनाहरूको अर्थ खोल्न सक्‍ने त्यहाँ कोही भएन । ");
INSERT INTO npiulb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","त्यसपछि मुख्य पियाउनेले फारोलाई भने, “आज म मेरो दोषको बारेमा सोच्दै छु । ");
INSERT INTO npiulb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","फारो आफ्ना नोकरहरूसित रिसाउनु भई मलाई र मुख्य पकाउनेलाई अङ्गरक्षकका कप्‍तानको कैदखानामा राख्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","तिनी र मैले एउटै रात सपना देख्यौँ । हामीले आ-आफ्नो अर्थ भएका सपना देख्यौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","त्यहाँ हामीसित एक जना जवान हिब्रू मानिस थियो जो अङ्गरक्षकका कप्‍तानको नोकर थियो । हामीले त्यसलाई हाम्रा सपनाहरू बताएपछि त्यसले अर्थ खोलिदियो । त्यसले हामीलाई आ-आफ्ना सपनाअनुसार अर्थ खोलिदियो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","त्यसले हामीलाई अर्थ खोलिदिएअनुसार नै हुन आयो । फारोले मलाई मेरो पदमा पुनर्स्थापना गरिदिनुभयो, तर अर्को मानिसलाई झुण्ड्याइयो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","त्यसपछि फारोले योसेफलाई डाक्‍न पठाए । तिनीहरूले तिनलाई चाँडै नै झ्यालखानाबाट निकालेर ल्याए । तिनले दारी खौरेपछि लुगाहरू बद्लेर फारोकहाँ आए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फारोले योसेफलाई भने, “मैले एउटा सपना देखेँ, तर यसको अर्थ खोल्ने कोही भएन । तर तिमीले सपना सुन्यौ भने यसको अर्थ खोल्न सक्छौ भनी मैले तिम्रो बारेमा सुनेको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफले फारोलाई जवाफ दिए, “ममा यस्तो खुबी त छैन, तर परमेश्‍वरले फारोलाई निगाहसाथ जवाफ दिनुहुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","फारोले योसेफलाई बताए, “मेरो सपनामा म नील नदीको किनारमा उभिएँ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","नील नदीबाट सातवटा सप्रेका र मोटा-मोटा गाई निस्केर आए, अनि तिनीहरू नर्कटको झाडीमा चरे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","नील नदीबाट अरू सातवटा कमजोर, नसप्रेका र दुब्ला-दुब्ला गाई निस्केर आए । मैले पुरै मिश्रभरि तीजस्ता नसप्रेका गाईहरू कहिल्यै देखेको छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","त्यसपछि नसप्रेका र दुब्ला-दुब्ला गाईहरूले सातवटा मोटा-मोटा गाईलाई खाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","तिनीहरूले ती गाईहरूलाई खाइसकेपछि तिनीहरू खाएका जस्ता देखिँदैनथे किनकि तिनीहरू पहिलेजस्तै अझै पनि नसप्रेका देखिन्थे । त्यसपछि मेरो निद्रा खुल्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","मेरो अर्को सपनामा मैले सातवटा भरिला र असल अनाजका बाला एउटै डाँठमा उम्रिरहेका देखेँ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","त्यसपछि सुकेका, सेप्रा र पूर्वीय बतासद्वारा ओइलाइएका अरू सातवटा अन्‍नका बाला तिनीहरू पछि पलाउन थाले । ");
INSERT INTO npiulb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","सेप्रा बालाहरूले ती सातवटा भरिला र असल बालालाई खाइदिए । मैले जादुगरहरूलाई यी सपनाहरू बताएँ, तर मलाई तिनको अर्थ खोलिदिने कोही भएन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","योसेफले फारोलाई भने, “फारोका सपनाहरू एउटै हुन् । परमेश्‍वरले गर्न लाग्‍नुभएको कुरा उहाँले फारोलाई प्रकट गराउनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","सातवटा असल गाई र सातवटा असल बाला सात वर्ष हुन् । सपनाहरू एउटै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","तीपछि आएका सातवटा दुब्ला-दुब्ला र नसप्रेका गाई सात वर्ष हुन्, र पूर्वीय बतासद्वारा ओइल्याइएका सातवटा बाला अनिकालका सात वर्ष हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","मैले फारोलाई बताएको कुरा यही नै हो । परमेश्‍वरले गर्न लाग्‍नुभएको कुरा उहाँले फारोलाई प्रकट गराउनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","हेर्नुहोस्, मिश्रदेशभरि ठुलो सहकालको सात वर्ष हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","त्यसपछि सात वर्षको अनिकाल पर्नेछ, र मिश्रभरि त्यस सात वर्षको सहकालको सम्झना हुनेछैन, अनि अनिकाले देशलाई सखाप पार्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","देशमा पछि आउने अनिकालको कारणले गर्दा सहकाललाई सम्झनेछैन किनकि यो अति नै भयानक हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","फारोलाई सपना दोहोर्‍याइनुको कारणचाहिँ यही हो, कि परमेश्‍वरले यो विषयलाई पक्‍का गर्नुभएको छ, र उहाँले चाँडै यसो गर्नुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","अब फारोले कुशल र बुद्धिमान् मानिसको खोजी गरी तिनलाई मिश्र देशको जिम्मेवारी दिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","फारोले देशमाथि अधिकारीहरू नियुक्त गर्नुभएको होस् र तिनीहरूले सहकालका सात वर्षमा मिश्रका अनाजहरूको पाँचौँ हिस्सा उठाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","सहरहरूमा खानाका लागि तिनीहरूले आउँदै गरेका यी असल वर्षहरूका सबै अनाज जम्मा गरून् । तिनीहरूले यसको सञ्चय गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","मिश्रमा आउने सात वर्षको अनिकालको अवधिमा यी अनाज वितरण गरिनुपर्छ । यसरी अनिकालद्वारा देश सखाप हुनेछैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","फारो र तिनका सबै कामदारको दृष्‍टिमा यो सल्लाह राम्रो थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","फारोले आफ्ना कामदारहरूलाई भने, “यिनीजस्तै परमेश्‍वरको आत्मा भएको अर्को कुनचाहिँ मानिस हामी पाउन सक्छौँ र?” ");
INSERT INTO npiulb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","त्यसैले फारोले योसेफलाई भने, “परमेश्‍वरले तिमीलाई यी सबै देखाउनुभएकोले तिमीजस्तै कुशल र बुद्धिमान् अरू कोही छैन । ");
INSERT INTO npiulb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","तिमी नै मेरो घरको अधिकारी हुनेछौ र तिम्रो वचनअनुसार नै मेरा सबै मानिस चल्नेछन् । सिंहासनमा मात्रै म तिमीभन्दा ठुलो हुनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","फारोले योसेफलाई भने, “हेर, मैले तिमीलाई मिश्र देशभरिको अधिकारी तुल्याएको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","फारोले आफ्नो औँलाबाट छाप-औँठी फुकाली योसेफको औँलामा लगाइदिए । तिनले योसेफलाई सुन्दर मलमलको लुगा पहिराइदिए र तिनको गलामा सुनको सिक्री लगाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","फारोले तिनलाई आफूसित भएको दोस्रो दर्जाको रथमा सवार गराए । मानिसहरू यसो भन्दै तिनको सामु चिच्‍च्याए, “घुँडा टेकेर झुक ।” फारोले तिनलाई सारा मिश्रको अधिकारी तुल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फारोले योसेफलाई भने, “म फारो हुँ, र तिमीबाहेक अरू कसैले मिश्र देशमा आफ्नो इच्छाअनुसार कुनै काम गर्न पाउनेछैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारोले योसेफको नाउँ “सापनत-पानेह” राखिदिए । तिनले योसेफलाई पुजारी पोतीपेराकी छोरी आसनतसित विवाह गराइदिए । योसेफ मिश्र देशभरि जान्थे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","मिश्रका राष्‍ट्रप्रमुख फारोको सामु उभिँदा योसेफ तिस वर्षका थिए । योसेफ फारोको उपस्थितिबाट गई सारा मिश्र देशभरि चाहार्थे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सहकालका सात वर्षमा जमिनले प्रचुर मात्रामा उब्जनी गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","तिनले सात वर्षमा मिश्र देशका सबै अनाज सङ्कलन गरी त्यसलाई सहरहरूमा राखे । तिनले हरेक सहरमा वरिपरिका खेतहरूबाट अनाज थन्क्याएर राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","योसेफले अन्‍नको भण्डारण समुद्रको बालुवासरह गरे । अन्‍न यति धेरै थियो कि तिनले हिसाब राख्‍नै छाडिदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अनिकालका वर्षहरू सुरु हुनुभन्दा अगि योसेफले ओनका पुजारी पोतीपेराकी छोरी आसनतबाट दुई जना छोरा जन्माइसकेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","योसेफले आफ्नो जेठो छोरोलाई मनश्शे नाउँ दिएका थिए किनकि तिनले भने, “परमेश्‍वरले मेरा र मेरा पिताका घरानाका सबै कष्‍ट बिर्सन लगाउनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","तिनले दोस्रो छोरोको नाउँ एफ्राइम राखे किनकि तिनले भने, “परमेश्‍वरले मेरो कष्‍टलको देशमा मेरो फलिफाप गराउनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिश्र देशको सात वर्षको सहकालको अन्त्य भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","योसेफले भनेजस्तै गरी सात वर्षको अनिकालको थालनी भयो । सबै देशहरूमा अनिकाल परेको थियो तर मिश्र देशमा भने अनाज थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","सारा मिश्र अनिकालले तडपिँदा जनताहरूले अनाजको लागि फारोलाई पुकारे । फारोले सबै मिश्रीहरूलाई भने, “योसेफकहाँ जाओ र तिनले भनेझैँ गर ।” ");
INSERT INTO npiulb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","अनिकालले पुरै देशलाई ढाकेको थियो । योसेफले सबै भण्डारणहरू खुला गरी मिश्रीहरूलाई अनाज बेचे । मिश्र देशमा अनिकाल अति भयानक थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","सारा संसारमा भयानक अनिकाल परेकोले सबै देशका मानिसहरू योसेफबाट अनाज किन्‍न मिश्रमा आउँदै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","अब मिश्रमा अनाज पाइँदोरहेछ भनी याकूबलाई थाहा भयो । तिनले आफ्ना छोराहरूलाई भने, “तिमीहरू किन एक-अर्कालाई हेर्छौ?” ");
INSERT INTO npiulb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","तिनले भने, “मिश्रमा अनाज छ भनी मैले सुनेको छु । हामी जीवित रहनको लागि तल गएर हाम्रो लागि अनाज किन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","योसेफका दस जना दाजु मिश्रमा अनाज किन्‍नका लागि गए । ");
INSERT INTO npiulb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","तर याकूबले योसेफका भाइ बेन्यामीनलाई तिनका दाजुहरूसँगै पठाएनन् किनकि तिनीमाथि कुनै हानि आइपर्ला कि भनी तिनी डराए । ");
INSERT INTO npiulb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","किन्‍न आउनेहरूमध्ये इस्राएलका छोराहरू पनि थिए किनकि कनान देशमा पनि अनिकाल परेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","योसेफ मिश्रका अधिपति थिए । तिनले देशका सबै मानिसलाई अनाज बेच्थे । योसेफका दाजुहरू आए, र तिनीहरूले भुइँसम्मै निहुरेर तिनलाई ढोग गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफले आफ्ना दाजुहरूलाई देखेर चिने, तर तिनले नचिनेका जस्तै गरी तिनीहरूसित कडासँग बोले । तिनले तिनीहरूलाई भने, “तिमीहरू कहाँबाट आएका हौ?” तिनीहरूले भने, “अनाज किन्‍नका लागि कनान देशबाट आएका हौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफले आफ्ना दाजुहरूलाई चिने, तर तिनीहरूले भने तिनलाई चिनेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","त्यसपछि योसेफले तिनीहरूको बारेमा आफूले देखेका सपनाहरू सम्झे र तिनीहरूलाई भने, “तिमीहरू जासुस हौ । तिमीहरू यो देशका असुरक्षित भागहरू हेर्न आएका हौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","तिनीहरूले तिनलाई भने, “त्यसो होइन, हजुर । तपाईंका दासहरू अनाज किन्‍न आएका हुन् । हामी सबै एउटै मानिसका छोराहरू हौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हामी इमानदार मानिसहरू हौँ । हामी तपाईंका दासहरू जासुस होइनौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","तिनले तिनीहरूलाई भने, “तिमीहरू यो देशका असुरक्षित भागहरू हेर्न आएका हौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","तिनीहरूले भने, “हामी तपाईंका दासहरू बार्‍ह जना दाजुभाइ छौँ र हामी कनान देशका एउटै मानिसका छोराहरू हौँ । हेर्नुहोस्, कान्छोचाहिँ अहिले हाम्रा पितासित छन् र एक जना भाइचाहिँ अब जिउँदो छैनन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","योसेफले तिनीहरूलाई भने, “त्यसैले मैले तिमीहरूलाई भनेँ कि तिमीहरू जासुस हौ । ");
INSERT INTO npiulb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","यसैद्वारा तिमीहरूको जाँच हुनेछ । फारोको शपथ खाएर म भन्दछु कि तिमीहरूका कान्छा भाइ यहाँ नआउञ्‍जेलसम्म तिमीहरू यहाँबाट जान पाउनेछैनौ । ");
INSERT INTO npiulb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तिमीहरूमध्ये कोही एक जना गएर तिनलाई लिएर आऊ । तिमीहरूको वचन सत्य छ कि छैन भनेर जाँच गर्नको लागि तिमीहरू झ्यालखानामा हालिन्छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","तिनले तिनीहरू सबैलाई तिन दिनसम्म कैदखानामा राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तेस्रो दिनमा याकूबले तिनीहरूलाई भने, “यसो गर, र तिमीहरू बाँच्नेछौ किनकि म परमेश्‍वरदेखि डराउँछु । ");
INSERT INTO npiulb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","तिमीहरू इमानदार मानिस हौ भने एक जनालाई यही झ्यालखानामा छोड, र तिमीहरूचाहिँ जाओ । तिमीहरूका परिवारहरूका लागि आफूसित अनाज पनि लिएर जाओ । ");
INSERT INTO npiulb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","तिमीहरूका कान्छा भाइ मकहाँ लिएर आओ र तिमीहरूको कुरा साँचो ठहरिनेछ अनि तिमीहरू मर्नेछैनौ ।” त्यसैले तिनीहरूले त्यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","तिनीहरूले एक-अर्कालाई भने, “हाम्रा भाइको सम्बन्धमा हामी साँच्‍चै दोषी छौँ किनकि तिनले हामीसित बिन्ती गर्दा तिनको व्याकुलता हामीले देख्यौँ तापनि हामीले तिनको कुरा सुनेनौँ । त्यसैले यो व्याकुलता हामीमाथि आइपरेको हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेनले तिनीहरूलाई जवाफ दिए, “'त्यस केटोको विरुद्धमा पाप नगर' भनेर के मैले तिमीहरूलाई भनेको थिइनँ र? तर तिमीहरूले मेरो कुरा सुनेनौँ । अब हामीले त्यसको रगतको बदला भोग्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","योसेफले तिनीहरूका कुरा बुझे भनी तिनीहरूले थाहा पाएनन् किनकि तिनीहरूका बिचमा अर्थ खोल्ने व्यक्ति थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तिनी तिनीहरूबाट एकातिर गई रोए । तिनीहरूकहाँ फर्केर आई तिनले तिनीहरूसित कुराकानी गरे । तिनले तिनीहरूका बिचबाट शिमियोनलाई लिएर तिनीहरूकै आँखाका सामु तिनलाई बाँधे । ");
INSERT INTO npiulb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","त्यसपछि योसेफले आफ्ना दाजुहरूका झोलाहरू अनाजले भरी हरेकको रुपियाँ-पैसा उसकै बोराभित्र हाल्न र यात्राको लागि सरसामानको बन्दोवस्त गरिदिन आफ्ना नोकरहरूलाई आज्ञा गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","आफ्ना गधाहरूमा अनाज लादेर तिनका दाजुहरू त्यहाँबाट प्रस्थान गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","विश्राम स्थलमा आफ्नो गधालाई दाना दिनलाई बोरा खोल्दा एक जनाले आफ्नो रुपियाँ-पैसा देखे । यो तिनको बोराको मुखैमा थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तिनले आफ्ना दाजुभाइहरुलाई भने, “मेरो रुपियाँ-पैसा त फिर्ता गरिएको रहेछ । हेर त, यो त मेरै बोराभित्र छ ।” तिनीहरूको हंसले ठाउँ छाड्यो । तिनीहरू डरले काम्दै यसो भने, “परमेश्‍वरले यो हामीलाई के गर्नुभएको?” ");
INSERT INTO npiulb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","तिनीहरू कनानमा आफ्ना पिता याकूबकहाँ फर्केर तिनीहरूमाथि आइपरेका सबै कुरा बताइदिए । तिनीहरूले भने, ");
INSERT INTO npiulb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“त्यस देशका मालिकले हामीसित कठोरतापूर्वक बोले र हामी त्यहाँ जासुस भएर गएका थियौँ भनी ठाने । ");
INSERT INTO npiulb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","हामीले तिनलाई भन्यौँ, 'हामी इमानदार मानिसहरू हौँ । हामी जासुस होइनौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हामी बार्‍ह जना दाजुभाइ छौँ, र एउटै पिताका छोराहरू हौँ । एक जना अब जीवित छैन र कान्छोचाहिँ अहिले कनानमा हाम्रा पितासितै छन् ।' ");
INSERT INTO npiulb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","त्यस देशका मालिकले हामीलाई भने, 'यसैद्वारा तिमीहरू इमानदार मानिस हौ कि होइनौ भनेर म थाहा पाउनेछु । तिमीहरूमध्ये एक जना यहीँ बस, अनिकालको कारणले गर्दा तिमीहरूका परिवारहरूका लागि अनाज लिएर आफ्नो बाटो लाग । ");
INSERT INTO npiulb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","तिमीहरूका कान्छो भाइ मकहाँ लिएर आओ । तब तिमीहरू जासुस नभई इमानदार मानिस रहेछौ भनी मैले थाहा पाउनेछु । त्यसपछि म तिमीहरूका दाजुलाई छाडिदिनेछु र तिमीहरू यस देशमा व्यापार गरेर बस' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","तिनीहरूले आफ्ना बोराहरू खोल्दा हरेकको बोराभित्र चाँदीको पोको रहेछ । तिनीहरू र तिनीहरूका पिताले चाँदीको पोको देखेपछि तिनीहरू डराए । तिनीहरूका पिता ");
INSERT INTO npiulb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","याकूबले तिनीहरूलाई भने, “तिमीहरूले मबाट मेरा सन्तानहरू खोसेर मलाई शोकित तुल्याएका छौ । योसेफ अब जीवित छैन, शिमियोन पनि छैन र तिमीहरूले बेन्यामीन पनि मबाट लैजानेछौ । यी सबै कुरा मेरो विरुद्धमा छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रूबनले आफ्ना पितालाई यसो भने, “मैले बेन्यामीन तपाईंकहाँ फर्काएर ल्याइनँ भने तपाईंले मेरा दुई छोरालाई मार्न सक्‍नुहुन्छ । तिनलाई मेरो जिम्मामा सुम्पिदिनुस्, र म तिनलाई फेरि तपाईंकहाँ ल्याउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","याकूबले भने, “मेरो छोरो तिमीहरूसितै तल जानेछैन । किनकि तिनका दाजु मरिसके र तिनी एक्लै छन् । तिमीहरू जाने बाटोमा तिनीमाथि कुनै खतरा आइपर्‍यो भने तिमीहरूले मेरो फुलेको कपाललाई शोकसँगै पातालमा पुर्‍याउनेछौ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","देशमा अति भयानक अनिकाल परेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","तिनीहरूले मिश्रबाट ल्याएका अनाज खाइसकेपछि तिनीहरूका पिताले तिनीहरूलाई भने, “फेरि हाम्रो लागि अन्‍न किन्‍नलाई जाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","यहूदाले भने, “ती मानिसले हामीलाई गम्भीरतापूर्वक चेताउनी दिएका छन्, 'तिमीहरूले आफ्ना भाइलाई सँगै ल्याएनौ भने तिमीहरूले मेरो मुहार हेर्नेछैनौ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","तपाईंले हाम्रा भाइलाई हामिसितै पठाउनुभयो भने हामी तल झरेर तपाईंका लागि अन्‍न किन्‍नेछौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","तर तपाईंले तिनलाई पठाउनुभएन भने हामी तल जाँदैनौँ । किनभने ती मानिसले हामीलाई भनेका छन् 'तिमीहरूले आफ्ना भाइलाई सँगै ल्याएनौ भने तिमीहरूले मेरो मुहार हेर्नेछैनौ' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएलले भने, “तिमीहरूको अर्को भाइ थियो भनी ती मानिसलाई बताएर तिमीहरूले किन ममाथि सङ्कष्‍ट ल्यायौ?” ");
INSERT INTO npiulb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","तिनीहरूले भने, “ती मानिसले हामी र हाम्रो परिवारको बारेमा सबै कुरा सोधपुछ गरे । तिनले भने, 'के तपाईंका पिता अझै जीवितै हुनुहुन्छ? के तिमीहरूको अर्को भाइ छ?' हामीले तिनका प्रश्‍नहरूको जवाफ मात्र दिएका हौँ । तिनले 'तिमीहरूका भाइलाई पनि सँगै लिएर आओ' भन्छन् भनी हामीले कसरी जान्‍न सक्थ्यौँ र? ");
INSERT INTO npiulb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","यहूदाले आफ्ना पिता इस्राएललाई भने, “केटोलाई मसितै पठाउनुहोस् । तपाईं, हामी र हाम्रा छोराछोरीहरू बाँच्न सकून् भनी हामी उठेर गइहाल्नेछौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","म तिनको जमानी हुनेछु । तपाईंले मसित लेखा लिनुहुनेछ । मैले तिनलाई तपाईंकहाँ फर्काएर तपाईंको सामु ल्याइनँ भने म सदाको लागि त्यसको दोषी हुनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","किनकि हामीले ढिला नगरेका भए निश्‍चय नै अहिलेसम्म त हामी दोस्रो पटक यहाँ फर्किसकेका हुने थियौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तिनीहरूका पिता इस्राएलले तिनीहरूलाई भने, “त्यसो हो भने, अब यसो गर । तिमीहरूका झोलाहरूमा यस देशमा सबैभन्दा उत्तम उब्जनीहरू हाल । ती मानिसलाई यी उपहारहरू लिएर जाओः सुगन्धित लेप, मह, मसला र मूर्र, पेस्ता र हाडे-बदाम । ");
INSERT INTO npiulb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","तिमीहरूले दुई गुणा रुपियाँ-पैसा पनि लिएर जाओ । तिमीहरूका बोरा खोल्दा मुखमा फेला परेका रुपियाँ-पैसा पनि सँगै लिएर जाओ । सायद त्यो भुल थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","तिमीहरूका भाइलाई पनि सँगै लैजाओ । उठेर फेरि ती मानिसकहाँ जाओ । ");
INSERT INTO npiulb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","सर्वशक्तिमान् परमेश्‍वरले ती मानिसको सामु तिमीहरूलाई कृपा देखाऊन् ताकि तिनले तिमीहरूका अर्का दाजु र बेन्यामीनलाई छुटकारा दिऊन् । मेरा सन्तानहरूको कारणले म शोकित हुनैपर्छ भने म हुँला ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ती मानिसहरूले उपहार, दुई गुणा रुपियाँ-पैसा र बेन्यामीनलाई लिए, र तिनीहरू उठेर मिश्रतर्फ झरे, अनि योसेफको सामु हाजिर भए । ");
INSERT INTO npiulb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","योसेफले तिनीहरूसँगै बेन्यामीनलाई देखेपछि तिनले आफ्नो घरको भण्डारेलाई भने, “ती मानिसहरूलाई घरभित्र ल्याओ, र एउटा पशु काटेर भोज तयार पार किनकि दिउँसो यी मानिसहरूले मसँगै खानेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","त्यस भण्डारले योसेफले भनेजस्तो गर्‍यो । त्यसले ती मानिसहरूलाई योसेफको घरभित्र ल्यायो । ");
INSERT INTO npiulb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ती मानिसहरू योसेफको घरमा लगिएकाले तिनीहरू डराए । तिनीहरूले भने, “पहिलो पटक हाम्रा बोराहरूमा फर्काइएको रुपियाँ-पैसाको कारण हामीलाई यहाँ ल्याइएको हो । तिनले हाम्रो विरुद्धमा मौका खोजेका हुन सक्छन् । तिनले हामीलाई गिरफ्तार गरी दास बनाउन सक्छन्, हाम्रा गधाहरू लैजान सक्छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","तिनीहरू योसेफको घरको भण्डारेकहाँ गए, र घरको ढोकामा तिनीहरूले उसलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“हजुर, हामी पहिलो पटक अन्‍न किन्‍न आयौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","हामी विश्राम स्थलमा पुग्यौँ, अनि बोराहरू खोल्दा हरेकको रुपियाँ-पैसा हरेकको बोराको मुखैमा थियो । त्यहाँ हाम्रा सबै रुपियाँ-पैसा थिए । हामीले ती हामीसँगै ल्याएका छौँ । अन्‍न किन्‍नलाई हामीले थप रुपियाँ-पैसा पनि ल्याएका छौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","हाम्रा रुपियाँ-पैसा हाम्रा बोराहरूमा कसले राखिदियो भनी हामीलाई थाहा छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","भण्डारेले भन्यो, “तपाईंहरूलाई शान्ति होस् । नडराउनुहोस् । तपाईंका परमेश्‍वर र तपाईंका पिताका परमेश्‍वरले नै तपाईंका बोराहरूमा तपाईंहरूको रुपियाँ-पैसा हालिदिएको हुनुपर्छ । मैले तपाईंहरूको रुपियाँ-पैसा त पाएकै थिएँ ।” त्यसपछि भण्डारेले शिमियोनलाई तिनीहरूकहाँ ल्यायो । ");
INSERT INTO npiulb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","भण्डारेले ती मानिसहरूलाई योसेफको घरभित्र लग्यो । त्यसले पानी दियो, र तिनीहरूले आ-आफ्ना गोडा धोए । त्यसले तिनीहरूका गधाहरूलाई पनि दानापानी दियो । ");
INSERT INTO npiulb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","तिनीहरूले दिउँसो योसेफको आगमनको लागि उपहारहरू तयार पारिराखे, किनकि तिनीहरूले त्यहाँ सँगसँगै खाने थिए भनी तिनीहरूले सुनेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ घरमा आउँदा तिनीहरूले आफ्ना हातमा भएका उपहारहरू घरभित्र ल्याए, र भुइँसम्मै निहुरेर तिनलाई ढोग गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","तिनले तिनीहरूको भलाकुसारीको बारेमा सोधपुछ गरे, “तपाईंहरूले बताउनुभएका तपाईंहरूका वृद्ध पिता सञ्चै हुनुहुन्छ? के तिनी अझै जीवितै छन्?” ");
INSERT INTO npiulb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","तिनीहरूले भने, “तपाईंका दास हाम्रा पिता सञ्चै हुनुहुन्छ । उहाँ अझै जीवितै हुनुहुन्छ ।” तिनीहरू भुइँमा लमतन्‍न परेर तिनलाई ढोग गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","तिनले आफ्ना आँखा उठाउँदा तिनले आफ्नी आमाका छोरा आफ्ना भाइ बेन्यामीनलाई देखेपछि तिनले भने, “तिमीहरूले मलाई बताएको तिमीहरूका कान्छा भाइ यिनै हुन्?” त्यसपछि तिनले भने, “मेरा छोरा, तिमीमाथि परमेश्‍वर अनुग्रही हुनुभएको होस्!” ");
INSERT INTO npiulb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","योसेफ कोठाबाट बाहिर जान हतारिए किनकि तिनी आफ्ना भाइको बारेमा स्‍नेहले भरिएका थिए । तिनले रुने ठाउँ खोजे । तिनी आफ्नो कोठाभित्र पसी रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","आफ्नो मुख धोई तिनी बाहिर आए । आफूलाई नियन्त्रण गर्दै तिनले भने, “खाना ल्याओ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","नोकरहरूले योसेफको लागि छुट्टै र तिनका दाजुहरूका लागि छुट्टै खाना पस्के । मिश्रीहरूले छुट्टै खाना खाए किनकि तिनीहरूले हिब्रूहरूसित खान सक्दैनथे। त्यसो गर्नु मिश्रीहरूका लागि अत्यन्तै घृणित कुरो थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","दाजुहरू योसेफका सामु बसे । तिनीहरू जेठादेखि कान्छासम्म मिलेर बसेका थिए । तिनीहरू सबै सँगसँगै छक्‍क परेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","आफ्नो सामु पस्किएको खानाको केही भाग योसेफले तिनीहरूकहाँ पठाए । तर बेन्यामीनको भागचाहिँ अरू कुनै दाजुहरूको भन्दा पाँच गुणा बेसी थियो । तिनीहरूले पिए र तिनीहरू तिनीसँगै खुसी भए । ");
INSERT INTO npiulb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","योसेफले तिनको घरको भण्डारेलाई आज्ञा दिए, “ती मानिसहरूले लैजान सक्‍नेजति अनाज तिनीहरूका बोराहरूमा भरिदेऊ, र हरेकको बोराको मुखमा हरेकको रुपियाँ-पैसा पनि हालिदेऊ । ");
INSERT INTO npiulb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","कान्छोको बोराको मुखमा मेरो चाँदीको कचौरा र तिनले अनाजको लागि ल्याएको रुपियाँ-पैसा पनि हालिदेऊ ।” भण्डारेले योसेफले भनेझैँ गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","बिहान भएपछि ती मानिसहरू आ-आफ्ना गधाहरूसँगै पठाइए । ");
INSERT INTO npiulb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","तिनीहरू सहरबाट केही पर पुग्दा योसेफले आफ्नो भण्डारेलाई भने, “उठ, र ती मानिसहरूको पिछा गर । तिनीहरूलाई भेट्टाएपछि यसो भन्‍नू, 'किन तिमीहरूले भलाइको सट्टा खराबी गर्‍यौ? ");
INSERT INTO npiulb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","के यो त्यही कचौरा होइन जसबाट मेरा मालिकले पिउनुहुन्छ र शकून-अपशकूनको लागि प्रयोग गर्नुहुन्छ? तपाईंहरूले जे गर्नुभएको छ त्यो खराब छ' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","भण्डारेले तिनीहरूलाई भेट्टायो, र तिनहरूलाई ती वचनहरू भन्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","तिनीहरूले त्यसलाई भने, “किन मेरा मालिकले यस्ता कुराहरू गर्नुहुन्छ? तपाईंका दासहरूले कहिल्यै यस्तो कुरा गर्न सक्दैनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","हामीले हाम्रा बोराहरूका मुखमा फेला पारेका रुपियाँ-पैसा त हामीले कनान देशबाट फेरि तपाईंकहाँ फर्काएर ल्यायौँ । तब कसरी हामीले हाम्रा मालिकको घरबाट चाँदी वा सुन चोर्न सक्छौँ? ");
INSERT INTO npiulb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","तपाईंको कुनै पनि दाससित त्यो कचौरा फेला पारियो भने त्यो मारियोस्, र हामी आफै पनि तपाईंका दास हुनेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","भण्डारेले भन्यो, “अब तपाईंहरूकै वचनअनुसार नै होस् । जससित त्यो कचौरा पाइन्छ, त्यो मेरो दास बनोस्, र अरूहरू निर्दोष हुनेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","त्यसपछि हरेक मानिसले हतार-हतारमा आ-आफ्नो बोरा भुइँमा झारी तिनीहरूले आ-आफ्ना बोरा खोल्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","भण्डारेले खोजी गर्‍यो । त्यसले जेठोबाट सुरु गरेर कान्छोमा टुङ्ग्यायो, अनि त्यो कचौरा बेन्यामीनको बोरामा फेला पारियो । ");
INSERT INTO npiulb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","त्यसपछि तिनीहरूले आफ्ना लुगा च्याते । हरेकले आ-आफ्नो गधा लादेर तिनीहरू सहर फर्के । ");
INSERT INTO npiulb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा र तिनका दाजुभाइहरू योसेफको घरमा फर्के । तिनी अझै पनि त्यहीँ नै थिए र तिनीहरूले भुइँसम्मै निहुरेर तिनलाई ढोग गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफले तिनीहरूलाई भने, “तिमीहरूले यो के गरेको? मजस्तो मानिसले शकून-अपशकून गर्छ भनी के तिमीहरूलाई थाहा छैन?” ");
INSERT INTO npiulb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदाले भने, “मेरा मालिकलाई हामी के भनौँ? हामी के बोलौँ? वा हामीले आफूलाई कसरी सफाइ दिऔँ? परमेश्‍वरले तपाईंका दासहरूको अपराध पत्ता लगाउनुभएको छ । हेर्नुहोस्, हामी मेरा मालिकहरूका दास हुन्छौँ– हामी र त्यो व्यक्ति जसको हातमा त्यो कचौरा फेला पर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","योसेफले भने, “मबाट यस्तो कहिल्यै हुनेछैन । त्यो मानिस जसको हातमा कचौरा फेरा पारियो, त्यो मात्रै मेरो दास हुनेछ । तर तिमीहरूचाहिँ शान्तिसित आफ्ना पिताकहाँ जाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","त्यसपछि यहूदा योसेफको नजिक आएर भने, “मेरा मालिक, बिन्ती छ, कि हजुरको दासलाई एउटा वचन बोल्न दिनुहोस् किनकि तपाईं फारोसमान हुनुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मेरा मालिकले आफ्ना दासहरूलाई यसो भनी सोध्‍नुभयो, 'के तिमीहरूका पिता वा भाइ छ?' ");
INSERT INTO npiulb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","हामीले हजुरलाई भन्यौँ, 'हाम्रा वृद्ध पिता हुनुहुन्छ, र उहाँले बुढेसकालमा जन्माउनुभएको उहाँको एउटा छोरो पनि छ । तर तिनका दाजु मरिसके, र तिनकी आमापट्टिबाट तिनी मात्रै बाँकी छन्, र तिनका पिताले तिनलाई माया गर्नुहुन्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","त्यसपछि तपाईंले आफ्ना दासहरूलाई भन्‍नुभयो, 'तिनलाई लिएर आओ ताकि मैले तिनलाई देख्‍न सकूँ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","त्यसपछि हामीले हजुरलाई भन्यौँ, 'ठिटोले आफ्ना पितालाई छाड्न सक्दैनन् । किनकि तिनले आफ्ना पितालाई छाड्नुपर्‍यो भने तिनका पिता मर्नेछन् ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","तब तपाईंले आफ्ना दासहरूलाई भन्‍नुभयो, तिमीहरूको कान्छो छोरो तिमीहरूसँगै नआएसम्म तिमीहरूले मेरो अनुहार हेर्नेछैनौ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","त्यसपछि हामी तपाईंका दास मेरा पिताकहाँ जाँदा हामीले उहाँलाई तपाईंका वचनहरू सुनायौँ । ");
INSERT INTO npiulb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","हाम्रा पिताले भन्‍नुभयो, 'फेरि गएर हाम्रा लागि अनाज किन ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","त्यसपछि हामीले भन्यौँ, 'हामी तल जान सक्दैनौँ । हाम्रो कान्छो भाइ हामीसित गयो भने मात्र हामी तल जान सक्छौँ किनकि कान्छो भाइ हामीसित नगएसम्म हामीले ती मानिसको अनुहार हेर्न सक्दैनौँ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","तपाईंका दास मेरा पिताले हामीलाई भन्‍नुभयो, 'मेरी पत्‍नीले मेरा लागि दुई जना छोरा जन्माएकी कुरा त तिमीहरूलाई थाहै छ । ");
INSERT INTO npiulb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","एउटाले मलाई छाडेर गइसकेपछि मैले भनेँ, 'निश्‍चय नै, त्यसलाई धुजाधुजा पारिएको छ, र त्यस बेलादेखि मैले त्यसलाई देखेको छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अब तिमीहरूले यसलाई पनि मबाट लिएर गयौ र यसमाथि कुनै हानि आइपर्‍यो भने तिमीहरूले मेरो फुलेको कपाललाई शोकमै पातालमा पुर्‍याउने‍छौ ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","त्यसकारण म हजुरका दास मेरा पिताकहाँ पुग्दा ती ठिटा मसित छैनन् भने उहाँको जीवन ती ठिटाको जीवनमा जोडिएकाले ");
INSERT INTO npiulb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","उहाँले मेरो साथमा ती ठिटालाई नदेख्‍नुहुँदा उहाँ मर्नुहुनेछ । तपाईंका दासहरूले हाम्रा पिताको फुलेको कपाललाई शोकमै पातलामा पुर्‍याउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","किनकि तपाईंका दास मेरा पिताको अगि म ती ठिटाको जमानी बसेको छु, र भनेको छु, 'मैले तिनलाई तपाईंकहाँ ल्याइनँ भने म मेरा पिताको सामु सदाको लागि दोषी ठहरिनेछु ।' ");
INSERT INTO npiulb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","त्यसकारण ती ठिटाको साटोमा तपाईंका दासलाई नै हजुरको दासको रूपमा बस्‍न दिनुहोस्, र ती ठिटालाई तिनका दाजुहरूसँगै जान दिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","किनकि ठिटालाई नलिईकन म कसरी मेरा पिताकहाँ जान सक्छु र? मेरा पितामाथि आइपर्ने खराबी हेर्नदेखि म डराएको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","त्यसपछि आफूनेर उभिएका सबै दासहरूका सामुन्‍ने योसेफले आफूलाई नियन्त्रण गर्न सकेनन् । तिनले उच्‍च सोरमा भने, “हरेक व्यक्ति यहाँबाट जाऊ ।” त्यसैले योसेफले आफैलाई आफ्ना दाजुहरूकहाँ चिनाउँदा योसेफको नजिकै कोही उभिएको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","तिनी यति ठुलो सोर निकालेर रोए कि मिश्रीहरूले मात्र नभई फारोको परिवारले पनि सुने । ");
INSERT INTO npiulb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","योसेफले आफ्ना दाजुहरूलाई भने, “म योसेफ हुँ । के मेरा पिता अझै जीवितै हुनुहुन्छ?” तिनका दाजुहरूले तिनलाई जवाफ दिन सकेनन् किनकि तिनीहरू तिनको उपस्थितिमा स्तब्ध भएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","त्यसपछि योसेफले आफ्ना दाजुहरूलाई भने, “बिन्ती छ, मेरो नजिक आओ ।” तिनीहरू नजिक आए । तिनले भने, “म तिमीहरूका भाइ योसेफ हुँ जसलाई तिमीहरूले मिश्रमा बेचेका थियौ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","तिमीहरूले मलाई बेचेकोमा अपसोस नमान वा आफैमाथि रिस नगर किनकि जीवन बचाउन परमेश्‍वरले मलाई तिमीहरूभन्दा पहिले यहाँ पठाउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","यी दुई वर्ष यो देशमा अनिकाल परिसकेको छ, र अझै पाँच वर्ष न हलो जोतिनेछ न कटनी गरिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","पृथ्वीमा एउटा बाँकी भागको रूपमा राखी ठुलो छुटकाराद्वारा तिमीहरूको जीवन बचाउन परमेश्‍वरले मलाई तिमीहरूभन्दा पहिले यहाँ पठाउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","त्यसैले तिमीहरूले नभई परमेश्‍वरले नै मलाई यहाँ पठाउनुभएको हो, र उहाँले मलाई फारोका पिता, तिनका सबै घरानाका मालिक र सारा मिश्र देशका शासक तुल्याउनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","हतार-हतार मेरा पिताकहाँ गएर उहाँलाई यसो भन, “तपाईंका छोरा योसेफ यसो भन्छन्, 'परमेश्‍वरले मलाई सारा मिश्रको मालिक बनाउनुभएको छ । मकहाँ आउन विलम्ब नगर्नुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तपाईं गोशेन प्रदेशमा बस्‍नुहुनेछ, र तपाईं, तपाईंका छोराछोरीहरू, तपाईंका नातिनातिनाहरू, तपाईंका बगालहरू, तपाईंका बथानहरू र तपाईंसित भएका सबै मेरो नजिकै हुनुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","म त्यहाँ तपाईंको बन्दोवस्त गर्नेछु किनकि अनिकालका पाँच वर्ष अझै बाँकी छन्, नत्रता तपाईं, तपाईंको घराना र तपाईंसित भएका सबै दरिद्रतामा जानेछन्' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","तिमीहरूसित बोल्ने म योसेफ नै हुँ भनी तिमीहरूका आँखाले देखेका छौ र मेरा भाइ बेन्यामीनले पनि देखेका छन् । ");
INSERT INTO npiulb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मैले मिश्रमा हासिल गरेको इज्‍जत र मैले प्राप्‍त गरेका सबै थोकको विषयमा तिमीहरूले मेरा पितालाई बताउनू । हतारसँग गएर मेरा पितालाई ल्याओ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तिनी आफ्ना भाइ बेन्यामीनसित अँगालो हालेर रोए, अनि बेन्यामीन पनि अँगालो हालेर रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","तिनले आफ्ना सबै दाजुहरूलाई चुम्बन गरे र तिनीहरूसँगै रोए । त्यसपछि तिनका दाजुहरूले तिनीसित कुराकानी गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","“योसेफका दाजुहरू आएका छन्” भन्‍ने खबर फारोको घरमा पुग्यो । यसले फारो र तिनका कामदारहरूलाई निकै खुसी पार्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फारोले योसेफलाई भने, “तिम्रा दाजुहरूलाई यसो गर्न भन, 'आ-आफ्ना पशुहरू लदाएर कनान देशमा जाओ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","तिमीहरूका पिता र घरानाहरूलाई लिएर मकहाँ आओ । म तिमीहरूलाई मिश्रको असल ठाउँ दिनेछु, र तिमीहरूले यस देशका स्वादिष्‍ट मासु खानेछौ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","अब तिमीहरूलाई आज्ञा दिइएको छ । तिमीहरूलाई यसो भन्‍ने आज्ञा पनि दिइएको छ, 'तिमीहरूका छोराछोरी र तिमीहरूका पत्‍नीहरूका लागि मिश्र देशका गाडाहरू लिएर जाओ । तिमीहरूका पितालाई लिएर आओ । ");
INSERT INTO npiulb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","तिमीहरूका धन-सम्पत्तिको बारेमा चिन्ता नमान किनकि मिश्र देशका सबै असल-असल थोकहरू तिमीहरूकै हुन्' ।” ");
INSERT INTO npiulb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्राएलका छोराहरूले त्यसै गरे । फारोको आज्ञामुताबिक योसेफले तिनीहरूलाई गाडाहरूसाथै यात्राका लागि मालसामानहरू दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","तिनले तिनीहरू सबैलाई नयाँ लुगाहरू पनि दिए, तर बेन्यामीनलाई भने तिनले तिन सय चाँदीका टुक्रा र पाँच जोर लुगा दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","आफ्ना पिताका लागि तिनले यी थोकहरू पठाएः मिश्रका असल-अलस थोकहरू लादिएका दसवटा गधा; अनाज, रोटी र आफ्ना पिताको यात्राका लागि आवश्यक खाद्यपदार्थहरूले लादिएका दसवटा गधैनी । ");
INSERT INTO npiulb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","तिनले आफ्ना दाजुहरूलाई पठाए र तिनीहरू त्यहाँबाट प्रस्थान गरे । तिनले तिनीहरूलाई भने, “तिमीहरू बाटोमा झगडा नगर ।” ");
INSERT INTO npiulb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","तिनीहरू मिश्रबाट यात्रा गरी कनान देशमा आफ्ना पिताकहाँ आए । ");
INSERT INTO npiulb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","तिनीहरूले तिनलाई भने, “योसेफ अझै जीवितै छन्, र तिनी सारा मिश्र देशभरिको शासक भएका छन् ।” योसेफको बारेमा तिनीहरूले भनेका कुरा विश्‍वास गर्न नसकेर तिनी बेहोस भए । ");
INSERT INTO npiulb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","योसेफले तिनीहरूलाई भनेका सबै कुरा तिनले याकूबलाई बताइदिए । याकूबले आफूलाई लैजान योसेफले पठाएका गाडाहरू देखेपछि तिनीहरूका पिता याकूबको होस फर्क्यो । ");
INSERT INTO npiulb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","इस्राएलले भने, “अब पुग्यो । मेरो छोरो योसेफ अझै जीवित छ । म मर्नुअगि गएर त्यसलाई हेर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","इस्राएल आफूसँग भएका सबै थोक लिएर हिँडे र बेर्शेबा गए । त्यहाँ तिनले आफ्‍ना बुबा इसहाकका परमेश्‍वरको निम्‍ति बलिदान चढाए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","राती दर्शनमा परमेश्‍वर इस्राएलसँग यसो भन्दै बोल्‍नुभयो “याकूब, याकूब ।” तिनले भने, “म यहीँ छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","उहाँले भन्‍नुभयो, “म परमेश्‍वर हुँ, तेरा बुबाका परमेश्‍वर । मिश्रमा जान नडरा, किनकि त्‍यहाँ म तँबाट एउटा ठुलो जाति बनाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","म तँसँग मिश्रमा जानेछु, र म तँलाई निश्‍चय नै फेरि फर्काइ ल्‍याउनेछु, अनि योसेफकै हातले तेरा आँखा छोपिदिनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","त्‍यसपछि याकूब बेर्शेबाबाट हिँडे । इस्राएलका छोराहरूले आफ्‍ना बुबा याकूब, आफ्‍ना बालबच्‍चा र आफ्‍ना परिवारहरूलाई फारोले तिनलाई ल्‍याउन पठाएका गाडाहरूमा चढाएर लगे । ");
INSERT INTO npiulb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","तिनीहरूले आफ्‍ना गाईबस्‍तु र कनान देशमा जम्‍मा गरेका मालसामानहरूसँगै लगे । याकूब र तिनका जम्‍मै सन्तान मिश्रमा गए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याकूबले आफ्‍ना छोराहरू, नातिहरू, छोरीहरू र नातिनीहरू, तिनका सबै सन्‍तानलाई आफूसँगै मिश्रमा लगे । ");
INSERT INTO npiulb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","मिश्रमा जाने इस्राएलका छोराहरू, अर्थात्‌ याकूब र तिनका सन्‍तानहरूका नाउँ यी नै थिएः याकूबका जेठा छोरा रूबेन । ");
INSERT INTO npiulb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेनका छोराहरू: हानोक, पल्‍लु, हेस्रोन र कर्मी; ");
INSERT INTO npiulb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमियोनका छोराहरू: यमूएल, यामीन, ओहद, याकीन, सोहोर र कनानी पत्‍नीतर्फका छोरा शौल; ");
INSERT INTO npiulb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीका छोराहरू: गेर्शोन, कहात र मरारी । ");
INSERT INTO npiulb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाका छोराहरू: एर्, ओनान, शेलह, फारेस र जेरह (तर एर्‌ र ओनानचाहिँ कनान देशमै मरे) । फारेसका छोराहरू हेस्रोन र हामूल थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्‍साखारका छोराहरू तोला, पुवा, याशूब र शिम्रोन थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलूनका छोराहरू सेरेद, एलोन र यहलेल थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","यिनीहरूचाहिँ याकूबबाट लेआले पद्दन-आराममा जन्‍माएका छोराहरू, तिनकी छोरी दीनासमेत हुन्‌ । लेआबाट याकूबका छोराछोरी जम्‍मा तेत्तिस जना थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादका छोराहरू सेफोन, हाग्‍यी, शूनी, यसबोन, एरी, अरोदी र अरेली थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेरका छोराहरू यिम्‍ना, यिश्‍वा, यिश्‍वी र बरीआ थिए । तिनीहरूकी बहिनी सेरह थिइन्‌ । बरीआका छोराहरू हेबेर र मल्‍कीएल थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","लाबानले आफ्‍नी छोरी लेआलाई दिएकी कमारी जिल्‍पापट्टिका याकूबका छोराछोरी यी नै थिए । तिनले याकूबको निम्ति जम्‍मा सोह्र जना छोरा जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकूबकी पत्‍नी राहेलका छोराहरू योसेफ र बेन्‍यामीन थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ओनका पुजारी पोतीपेराकी छोरी आसनततर्फबाट मिश्रमा जन्‍मेका योसेफका छोराहरू मनश्‍शे र एफ्राइम थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बेन्‍यामीनका छोराहरू बेला, बेकेर, अश्‍बेल, गेरा, नामान, एही, रोश, मुप्‍पीम, हुप्‍पीम र आर्द थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेलबाट जन्‍मेका याकूबका छोराहरू यी नै थिए । यिनीहरू जम्‍मा चौध जना थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दानका छोरा हुशीम थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्‍तालीका छोराहरू यहसेल, गुनी, येसेर, र शिल्‍लेम थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","लाबानले आफ्‍नी छोरी राहेललाई दिएको कमारी बिल्‍हाले याकूबबाट जन्‍माएका सात जना छोरा यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकूबका साथमा मिश्रमा गएका तिनका बुहारीहरूबाहेक आफ्‍ना सन्‍तान जम्‍मा छयसट्ठी जना थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","मिश्रमा जन्‍मेका योसेफका दुई जना छोरासमेत गरेर मिश्रमा जाने याकूबका परिवारका सदस्यहरू जम्‍मा सत्तरी जना थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","गोशेनमा तिनलाई भेट्‌न आइदेऊन् भनी याकूबले यहूदालाई योसेफकहाँ खबर दिन आफ्‍नो अगि पठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","योसेफले आफ्‍नो रथ तयार गर्न लगाए र गोशेनसम्‍म आफ्‍ना बुबा इस्राएललाई भेट गर्न आए । योसेफले आफ्ना बुबालाई देखे, र बुबालाई अँगालो हालेर धेरै बेरसम्‍म रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","इस्राएलले योसेफलाई भने, “अब मलाई मर्न देओ, किनकि मैले तेरो मुख देखेँ र तँ जीवितै रहेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","योसेफले आफ्‍ना दाजुभाइहरू र आफ्‍ना बुबाका परिवारहरूलाई भने, “अब म गएर फारोलाई यसो भनेर खबर दिनेछु, ‘कनान देशका मेरा दाजुभाइहरू र मेरा बुबाका घरानाहरू मकहाँ आएका छन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","उनीहरू सबै गाईबस्‍तु पाल्‍ने भएकाले गोठाला हुन्‌ । उनीहरूले आफ्‍ना सबै बगाल, बथान, र उनीहरूसँग भएका सबै थोक लिएर आएका छन्‌ ।’ ");
INSERT INTO npiulb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फारोले तपाईंहरूलाई बोलाएर ‘तिमीहरूका कामधन्‍दा के हो?’ भनी सोध्‍छन्, ");
INSERT INTO npiulb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तब तपाईंहरूले यसो भन्‍नुपर्छ, ‘हजुरका दासहरू हामी बाबु-छोराहरू हाम्रा युवावस्थादेखि अहिलेसम्‍म गाईबस्‍तु पाल्‍दै आएका छौँ ।’ तपाईंहरूले यसो गर्नुभयो भने तपाईंहरूले गोशेनमा बसोबास गर्न पाउनुहुनेछ, किनभने हरेक गोठालोचाहिँ मिश्रीहरूको लागि घृणाको पात्र हो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","तब भित्र गएर योसेफले फारोलाई भने, “मेरा बुबा र दाजुभाइहरू, उनका बगाल र बथानहरू र उनीहरूका सबै थोक लिएर कनानबाट आएका छन्‌ । हेर्नुहोस्, अहिले उनीहरू गोशेन प्रदेशमा छन्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","तिनले आफ्‍ना दाजुहरूमध्‍येबाट पाँच जनालाई लिएर फारोलाई चिनाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फारोले तिनका दाजुभाइहरूलाई सोधे, “तिमीहरूको कामधन्‍धा के हो?” उनीहरूले फारोलाई भने, “हामी हजुरका दासहरू हाम्रा पिता-पुर्खादेखि नै गोठाला हौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","त्यसपछि उनीहरूले फारोलाई भने, “हामी यस देशमा अस्थायी बसोबास गर्न आएका छौँ । कनान देशमा घोर अनिकाल परेको हुनाले हजुरका दासहरूका बगालहरूको निम्ति चरन छैन । त्यसैले अब बिन्‍ती छ, हामी हजूरका दासहरूलाई गोशेन प्रदेशमा बसोबास गर्ने अनुमति दिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","त्यसपछि फारोले योसेफलाई भने, “तिम्रा बुबा र तिम्रा दाजुभाइहरू तिमीकहाँ आएका छन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","मिश्रदेश तिम्रै अगि छ । देशको सबैभन्‍दा असल ठाउँ गोशेन प्रदेशमा नै तिम्रा बुबा र तिम्रा दाजुभाइहरूलाई बस्‍ने बन्दोबस्त गर । उनीहरूमध्‍ये सक्षम मानिसहरूलाई गाईबस्‍तुहरूको जिम्मा देऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब योसेफले आफ्‍ना बुबा याकूबलाई पनि फारोकहाँ हाजिर गराए । याकूबले फारोलाई आशीर्वाद दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","फारोले याकूबलाई सोधे, “तपाईंको उमेर कति भयो?” ");
INSERT INTO npiulb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूबले फारोलाई भने, “मेरो प्रवासी जीवनको उमेर एक सय तिस वर्ष भयो । मेरो यस जीवनका वर्षहरू थोरै र दु:खमय भएका छन् । मेरो उमेर मेरा पिता-पुर्खाहरूको जति पुगेकै छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","त्यसपछि याकूबले फारोलाई आशीर्वाद दिए, र तिनको उपस्‍थितिबाट निस्‍केर गए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","तब योसेफले आफ्‍ना बुबा र दाजुभाइहरूलाई बसोबास गराए । फारोको हुकुमअनुसार तिनले मिश्रमा भएको सबैभन्‍दा असल ठाउँ, अर्थात्‌ रामसेस भन्‍ने इलाकाको एउटा क्षेत्र उनीहरूलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफले आफ्‍ना बुबा, दाजुभाइहरू र आफ्‍ना बुबाका परिवारका सबैलाई उनीहरूका आस्रित परिवारको सङ्ख्याअनुसार खानेकुरा उपलब्ध गराए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","घोर अनिकालको कारण पुरै देशमा कुनै खानेकुरा थिएन । अनिकालद्वारा मिश्र र कनान दुवै देश कमजोर भए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिश्र र कनान देशका बासिन्दाहरूलाई बेचेका अन्‍नबाट प्राप्‍त सबै रुपियाँ योसेफले जम्‍मा गरे । त्यसपछि योसेफले त्यो रुपियाँ फारोको महलमा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब मिश्र र कनानमा भएका सबै आफ्‍ना रुपियाँ-पैसा खर्च भयो, सबै मिश्रीहरू यसो भन्दै योसेफकहाँ आए, “हामीलाई अन्‍न दिनुहोस्‌ । हाम्रो रुपियाँ-पैसा सकिएको कारण तपाईंका आँखाको सामुन्‍ने हामी किन मरौँ?” ");
INSERT INTO npiulb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","योसेफले तिनीहरूलाई भने, “यदि तिमीहरूका रुपियाँ-पैसा सिद्धिए भने गाईबस्‍तु ल्‍याओ र तिमीहरूका गाईबस्‍तुका सट्टामा म तिमीहरूलाई अन्‍न दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","यसकारण तिनीहरूले आफ्‍ना गाईबस्‍तुहरू योसेफकहाँ ल्‍याए । योसेफले तिनीहरूका घोडा, भेडाबाख्रा, गाईबस्‍तु, गधाका सट्टामा तिनीहरूलाई खानेकुरा दिए । त्‍यस साल गाईबस्‍तुका सट्टामा तिनीहरूलाई तिनले अन्‍न खुवाए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","त्‍यो साल बितेपछि अर्को साल आएर तिनीहरूले योसेफलाई भने, “हामी हाम्रा मालिकदेखि केही कुरा पनि लुकाउँदैनौँ कि हाम्रा रुपियाँ-पैसा सबै सकिए र गाईबस्‍तुका बथान पनि सबै मालिककै भएका छन् । अब हजुरको आँखाको सामुन्‍ने हामीसँग हाम्रै जिउ र जग्‍गाजमिनबाहेक अरू केही छैन । ");
INSERT INTO npiulb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","हामी र हाम्रा जमिन हजूरका आँखाको सामुन्‍ने किन नष्‍ट हुने? अन्‍नको साटोमा हामी र हाम्रो जमिनलाई किन्‍नुहोस्, र हामी आफ्‍ना जग्‍गाजमिनसमेत फारोका कमारा-कमारी हुनेछौँ । हामीलाई बिउ दिनुहोस्, ताकि हामी जीवित हुन सकौँ र हाम्रा जग्‍गाजमिन पनि उजाड नहोऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","यसरी योसेफले मिश्रका सबै जग्‍गाजमिन फारोको निम्‍ति किने । अनिकाल धेरै भएको हुनाले हरेक मिश्रीले आफ्‍ना जग्‍गाजमिन बेच्यो । यसरी जग्‍गाजमिन फारोको भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","मिश्रको एक छेउदेखि अर्को छेउसम्‍मका सबै मानिसहरूलाई तिनले कमारा बनाए । ");
INSERT INTO npiulb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","पुजारीहरूका जग्‍गाजमिन मात्र तिनले किनेनन्, किनभने पुजारीहरूलाई फारोबाट भत्ता दिइएको थियो । फारोले दिएकै हिस्‍साबाट तिनीहरूले खान्‍थे । त्‍यसकारण तिनीहरूले चाहिँ आफ्‍ना जग्‍गाजमिन बेचेनन् । ");
INSERT INTO npiulb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","योसेफले जनताहरूलाई भने, “हेर, आज मैले फारोको निम्‍ति तिमीहरूका जग्‍गाजमिन र तिमीहरूलाई पनि किनेको छु । अब तिमीहरूका निम्‍ति बिउ यहाँ छ, र तिमीहरूले जमिनमा बिउ छर । ");
INSERT INTO npiulb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","तर फसलको बेलामा उब्‍जनीको पाँचौँ हिस्‍सा तिमीहरूले फारोलाई दिनुपर्छ । चार हिस्‍साचाहिँ खेतीलाई बिउको निम्‍ति र तिमीहरू, तिमीहरूका परिवार र तिमीहरूका बालबच्‍चाको खानाको निम्‍ति तिमीहरूको आफ्‍नै हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","तिनीहरूले भने, “हजूरले हाम्रो प्राण बचाइदिनुभएको छ । हजुरको निगाह हामीमाथि रहोस्‌ । हामी फारोका कमारा हुनेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","यसैले मिश्र देशमा योसेफले उब्‍जनीको पाँचौँ हिस्‍सा फारोको हुन्‍छ भन्‍ने कुरा समेटिएको जग्‍गाजमिनको विषयमा एउटा ऐन बनाए, जुन आजसम्‍म प्रचलित छ । पुजारीहरूका जग्‍गाजमिन मात्र फारोको भएन । ");
INSERT INTO npiulb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","त्यसैले इस्राएल मिश्रको गोशेनमा बसोबास गरे । तिनका मानिसहरूले त्‍यहाँका जग्‍गाजमिन आफ्‍नो अधिकारमा लिए । तिनीहरूको फलिफाप भएर सङ्ख्या अत्यन्तै वृद्धि भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकूब मिश्रमा सत्र वर्ष बसे । यसरी याकूबको जम्‍मा उमेर एक सय सतचालिस वर्ष भयो । ");
INSERT INTO npiulb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इस्राएलको मर्ने बेला आयो, तिनले आफ्‍ना छोरा योसेफलाई बोलाएर भने, “यदि मैले तेरो निगाह पाएको छु भने तेरो हात मेरो तिघ्रामुनि राखेर मप्रति तेरो विश्‍वासयोग्यता र भरोसा देखा । कृपा गरेर मलाई मिश्रदेशमा नगाड्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","म मेरा पिता-पुर्खाहरूसँग सुत्दा मलाई मिश्रबाट बोकेर लगी उनीहरूकै चिहानमा गाडिदे ।” योसेफले भने, “तपाईंले भन्‍नुभएबमोजिम म गर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","इस्राएलले भने, “मसँग शपथ खा ।” अनि योसेफले शपथ खाए । तब इस्राएल आफ्‍नो पलङ्गको सिरानमा घोप्‍टो परे । ");
INSERT INTO npiulb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","यी कुराहरू भएको केही समयपछि “हेर्नुहोस्, हजुरका पिता बिरामी हुनुहुन्‍छ” भनेर कसैले योसेफलाई खबर दियो । यसकारण तिनले आफ्‍ना दुई छोरा मनश्‍शे र एफ्राइमलाई आफ्‍नो साथमा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","जब “हेर्नुहोस्, तपाईंका छोरा योसेफ तपाईंलाई भेट गर्न आएका छन्‌” भन्‍ने खबर कसैले याकूबलाई सुनायो, इस्राएल आफै बल गरेर पलङ्गमा बसे । ");
INSERT INTO npiulb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकूबले योसेफलाई भने, “सर्वशक्तिमान्‌ परमेश्‍वर कनान देशको लूजमा मकहाँ देखा पर्नुभयो । उहाँले मलाई आशीर्वाद दिनुभयो ");
INSERT INTO npiulb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","र भन्‍नुभयो, 'हेर, म तँलाई फल्‍दो-फुल्‍दो बनाउनेछु, र तेरो वृद्धि गराउनेछु । तँबाट म जातिहरूको समूह उत्‍पन्‍न गर्नेछु । म यो देश अनन्‍त अधिकारको रूपमा तेरा सन्‍तानलाई दिनेछु ।’ ");
INSERT INTO npiulb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","अब म मिश्रमा आउनअगि मिश्रमा जन्‍मेका तेरा यी दुई जना छोराहरू मेरै हुन्‌ । रूबेन र शिमियोनझैँ एफ्राइम र मनश्‍शे मेरै हुनेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","तिनीहरूभन्‍दा पछि जन्‍मेका सन्‍तानहरूचाहिँ तेरा हुनेछन्‌ । यिनीहरूका नाम पनि यिनका दाजुभाइहरूले पाउने हकमा सूचीबद्ध गरिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","म पद्दन-आरामबाट आउँदा एप्रातमा पुग्‍न अझ केही टाढा छँदै कनान देशमा राहेल मरिन् । मैले तिनलाई एप्रात अर्थात्‌ बेथलेहेम जाने बाटोमा गाडेँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","योसेफका छोराहरूलाई देखेर इस्राएलले भने, “यिनीहरू को हुन्‌?” ");
INSERT INTO npiulb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफले आफ्‍ना बुबालाई भने, “यिनीहरू परमेश्‍वरले मलाई यहाँ दिनुभएका मेरा छोराहरू हुन्‌ ।” इस्राएलले भने, “तिनीहरूलाई मकहाँ ले, ताकि म तिनीहरूलाई आशीर्वाद दिऊँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","त्‍यस बेला तिनको उमेरले गर्दा इस्राएलका आँखा धमिला भइसकेका थिए, त्यसैले तिनले देख्‍न सकेनन् । यसकारण योसेफले तिनीहरूलाई तिनको नजिक लगिदिए, अनि तिनले तिनीहरूलाई म्‍वाइँ खाएर अँगालो हाले । ");
INSERT INTO npiulb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","इस्राएलले योसेफलाई भने, “मैले त तेरो मुख फेरि देख्‍न पाउँला भनी ठानेकै थिइनँ, तर मलाई परमेश्‍वरले तेरा सन्‍तान पनि देख्‍न दिनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","तब योसेफले तिनीहरूलाई इस्राएलका घुँडाको बिचबाट हटाए, र तिनले भुइँमा घोप्‍टेर दण्डवत् गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","योसेफले ती दुवैलाई लिएर एफ्राइमलाई आफ्‍नो दाहिनेपट्टि र इस्राएलको देब्रेपट्टि, र मनश्‍शेलाई आफ्‍नो देब्रेपट्टि र इस्राएलको दाहिनेपट्टि पर्ने गरी इस्राएलको नजिक ल्‍याए । ");
INSERT INTO npiulb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","इस्राएलले आफ्‍नो दाहिने हात पसारेर कान्‍छा एफ्राइमको टाउकोमा र आफ्‍नो देब्रे हात मनश्‍शेको टाउकोमा राखे । मनश्शे जेठा भएकाले तिनले आफ्नो एउटा हात अर्को हातमाथि खप्ट्याए । ");
INSERT INTO npiulb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","इस्राएलले योसेफलाई आशीर्वाद दिएर भने, “जुन परमेश्‍वरको सामुन्‍ने मेरा पिता अब्राहाम र इसहाक हिँडे, जुन परमेश्‍वरले मेरो जीवनभरि आजसम्‍म मेरो वास्ता गर्नुभएको छ, ");
INSERT INTO npiulb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ती स्‍वर्गदूत, जसले मलाई सबै खराबीबाट जोगाउनुभएको छ, उहाँले नै यी बालकहरूलाई आशीर्वाद देऊन् । मेरो र मेरा पिता अब्राहाम र इसहाकका नाउँ यिनीहरूमा बोलाइयोस् । पृथ्‍वीमा यिनीहरू अधिक सङ्ख्यामा बढून् ।” ");
INSERT INTO npiulb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब योसेफले तिनका बुबाले आफ्‍ना दाहिने हात एफ्राइमको टाउकोमा राखेको देखे, यो उनलाई मन परेन । तिनले एफ्राइमको टाउकोबाट मनश्‍शेको टाउकोमा राख्‍न भनी तिनका बुबाको हात उठाए । ");
INSERT INTO npiulb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफले आफ्ना बुबालाई भने, “हे मेरा बुबा, यसो होइन, किनकि जेठोचाहिँ यो हो । तपाईंको दाहिने हात यसको शिरमाथि राखिदिनुहोस्‌ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","तर तिनका बुबाले अस्‍वीकार गरी भने, “मलाई थाहा छ, मेरो छोरो, मलाई थाहा छ । यसको पनि एउटा वंश हुनेछ, र यो पनि महान् हुनेछ । तापनि यसको भाइचाहिँ योभन्‍दा महान्‌ हुनेछ, र त्‍यसका सन्‍तान जाति-जातिहरूको एक समूह हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","इस्राएलले तिनीहरूलाई त्‍यस दिन यसो भनेर आशीर्वाद दिए, “इस्राएलका मानिसहरूले तिमीहरूका नाउँ लिएर यस्‍तो आशीर्वाद दिनेछन्, ‘परमेश्‍वरले तँलाई एफ्राइम र मनश्‍शेजस्‍तै बनाऊन्‌’।” यसरी तिनले मनश्‍शेभन्‍दा एफ्राइमलाई नै अगाडि राखे । ");
INSERT INTO npiulb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","इस्राएलले योसेफलाई भने, “हेर्, म मर्न लागेको छु, तर परमेश्‍वर तिमीहरूका साथमा हुनुहुनेछ, र तिमीहरूलाई फेरि तिमीहरूका पिता-पुर्खाहरूको देशमा फर्काएर लैजानुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","त्‍यसबाहेक तेरा दाजुभाइहरूभन्‍दा तँमाथि भएकोले मैले आफ्‍नो तरवार र धनुको बलले एमोरीहरूबाट लिएको पहाडको पाखा म तँलाई दिन्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकूबले आफ्‍ना छोराहरूलाई बोलाएर भनेः “तिमीहरू यहाँ जम्‍मा होओ, ताकि भविष्यमा तिमीहरूमाथि के आइपर्नेछ सो म तिमीहरूलाई भनूँ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","हे याकूबका छोरा हो, जम्‍मा भएर सुन, तिमीहरूका बुबा इस्राएलका कुरा सुन । ");
INSERT INTO npiulb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","रूबेन, तँ मेरो जेठो छोरो होस्, मेरो शक्ति र मेरो बलको सुरु, गौरव र शक्तिमा उत्कृष्‍ट । ");
INSERT INTO npiulb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","बग्‍ने पानीजस्‍तो चञ्‍चल, तेरो प्रतिष्‍ठा रहनेछैन, किनभने तँ तेरा बुबाको ओछ्यानमा चढिस् । अनि त्यसलाई अशुद्ध पारिस्‌; तँ मेरो पलङ्गमा चढ़िस्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शिमियोन र लेवी दाजुभाइ हुन् । हिंसाका हतियार नै तिनीहरूका तरवार हुन् । ");
INSERT INTO npiulb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ए मेरो प्राण, तिनीहरूको सभामा नआइज, तिनीहरूको बैठकमा नबस् किनकि मेरो हृदयमा त्यसको निम्ति अत्यन्तै श्रद्धा छ । किनकि तिनीहरूलेआफ्‍नो रिसमा मानिसहरूलाई मारे । तिनीहरूले आफ्नो आनन्दको निम्ति गोरुहरूका ढोडनसा काटेका छन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","तिनीहरूको रिस श्रापित् होस्, किनभने त्‍यो भयानक छ, र तिनीहरूको क्रोध पनि श्रापित् होस् किनकि त्‍यो निष्‍ठुर छ । तिनीहरूलाई म याकूबमा विभाजन गर्नेछु, इस्राएलमा तितरबितर पार्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ए यहूदा, तेरा दाजुभाइहरूले तेरो प्रशंसा गर्नेछन् । तेरा हात तेरा शत्रुहरूका गर्दनमा हुनेछन् । तेरा बुबाका छोराहरू तेरो सामुन्‍ने निहुरिनेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा सिंहको डमरु हो । ए मेरो छोरो, तँ तेरो शिकारभन्दा उच्‍च भएको छस् । त्यो निहुरियो, सिंह र सिंहनीझैँ झुक्यो । कसले त्‍यसलाई उठाउने आँट गर्छ? ");
INSERT INTO npiulb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाको हातबाट राजदण्‍ड हट्‌नेछैन, न त राज्‍य चलाउनेको लाठी त्‍यसका खुट्टाका बिचबाट हट्‌नेछ, जबसम्‍म त्‍यसका मालिक आउँदैनन्‌ । जातिहरूले उहाँको आज्ञा मान्‍नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","त्‍यसको गधालाई दाखको बोटमा, र गधाको बछेड़ोलाई चाहिँ उत्तम जातको हाँगामा बाँधेर त्‍यसले आफ्‍ना लुगाहरू दाखमद्यमा, आफ्‍ना पोशाक अङ्‌गुरको रसमा धुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","त्‍यसका आँखा दाखमद्यजस्तै गाढा, र त्‍यसका दाँत दुधजस्ता सेता हुनेछन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबूलून समुद्रको किनारमा बस्‍नेछ । जहाजहरूका निम्‍ति त्‍यो बन्‍दरगाह हुनेछ, र त्‍यसको सिमाना सीदोनसम्‍म हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इस्‍साखार दुई भारीहरूका बिचमा लेटिरहने बलियो गधा हो । ");
INSERT INTO npiulb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","जसले असल विश्रामको ठाउँ असल र रमाइलो देश देख्छ । त्‍यसले भारी बोक्‍नलाई आफ्‍नो काँध झुकाउनेछ, र काम गर्ने नोकर बन्‍नेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","इस्राएलका कुलमध्‍ये एउटा कुल भएर दानले आफ्‍ना मानिसहरूको न्‍याय गर्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान बाटोको छेउमा भएको एउटा सर्प, अर्थात् घोडाको कुर्कुच्‍चा डस्‍ने विषालु सर्प हुनेछ र त्‍यसको घोडचढी पछिल्‍तिर लोट्‌छ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","हे परमप्रभु, म तपाईंको उद्धारको प्रतीक्षा गर्छु । ");
INSERT INTO npiulb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","गादमाथि आक्रमण गर्नेले त्यसलाई आक्रमण गर्नेछ, तर त्‍यसले तिनीहरूको कुर्कुच्‍चामा आक्रमण गर्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेरको अनाज प्रशस्त हुनेछ, र त्‍यसले राजकीय खाना उपलब्ध गराउनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नप्‍ताली सुन्दर पाठापाठी पाउने फुकाइएकी मुडुली-मृग हो । ");
INSERT INTO npiulb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","योसेफ एउटा फलवन्त लहरा हो, पानीको मूलनेर भएको फल दिने लहरा, जसका हाँगाहरू पर्खालमाथि फैलिन्‍छन्‌ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुर्धारीहरूले त्‍यसलाई आक्रमण गर्नेछन् र त्‍यसमाथि काँड चलाउनेछन्, र त्यसलाई सताउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तापनि त्‍यसको धनु स्थिर रहनेछ, र याकूबका शक्तिशाली परमेश्‍वरका हातको कारण र ती गोठाला अर्थात् इस्राएलको चट्टानद्वारा त्‍यसका हातहरू सिपालु हुनेछन्, ती गोठाला, इस्राएलको चट्टानद्वारा । ");
INSERT INTO npiulb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","तेरा बुबाका परमेश्‍वरले तँलाई सहायता गर्नुहुन्‍छ, र सर्वशक्तिमान् परमेश्‍वरले माथि स्‍वर्गका आशिष्‌हरू, तल अगाधका आशिष्‌हरू, अनि स्‍तन र गर्भका आशिष्‌हरूले आशिषित्् तुल्याउनुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तेरा बुबाका आशीर्वादहरू प्राचीन पहाडहरूका आशीर्वादभन्‍दा महान् छन् वा प्राचीन डाँडाहरूका वाञ्छनीय कुरा हुन्छन् । ती सबै योसेफको शिरमा होऊन्, त्‍यसका दाजुभाइहरूमध्‍येका प्रधानको शिरमा पनि । ");
INSERT INTO npiulb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बेन्‍यामीन एउटा भोको ब्‍वाँसो हो । बिहान त्यसले शिकार खान्‍छ, र बेलुकीचाहिँ त्‍यसले लुट बाँड्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","यी इस्राएलका बाह्र कुल हुन्‌ । आफ्‍ना बुबाले तिनीहरूलाई आशीर्वाद दिँदा भनेका कुरा यही हो । प्रत्‍येकलाई तिनले सुहाउँदो आशीर्वाद दिए । ");
INSERT INTO npiulb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब तिनले तिनीहरूलाई यो आज्ञा दिएर यसो भने “म त मेरा मानिसहरूकहाँ मिल्‍न जान लागेको छु । हित्ती एप्रोनको खेतमा भएको ओडारमा मेरा पिता-पुर्खाहरूका साथमा मलाई गाड, ");
INSERT INTO npiulb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","अर्थात्‌ कनान देशमा मम्रेनेरको मक्‍पेलाको खेतमा भएको ओडार, जुन अब्राहामले हित्ती एप्रोनको हातबाट खेतसमेत चिहान बनाउनलाई किनेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","उनीहरूले अब्राहाम र तिनकी पत्‍नी सारालाई त्यहीँ गाडे । त्‍यहीँ नै उनीहरूले इसहाक र तिनकी पत्‍नी रिबेकालाई पनि गाडे । त्‍यहीँ नै मैले लेआलाई गाडेँ । ");
INSERT INTO npiulb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","त्‍यो खेत र त्‍यहाँ भएको ओडार हित्तीहरूको हातबाट किनिएको थियो ।” ");
INSERT INTO npiulb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","छोराहरूलाई यो आज्ञा दिइसकेपछि याकूबले आफ्‍ना खुट्टा ओछ्यानमा पसारेर आफ्‍नो प्राण त्‍यागे, र आफ्‍ना पिता-पुर्खाहरूसँग मिल्‍न गए । ");
INSERT INTO npiulb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","तब योसेफ यति व्याकुल भए कि तिनी आफ्‍ना बुबाको अनुहारमाथि घोप्‍टो परेर रोए, र तिनलाई चुम्बन गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","तब योसेफले आफ्‍नो सेवामा हुने वैद्यहरूलाई आफ्‍ना पिताको लाशमा सुगन्‍धित लेप दल्न लगाए । यसकारण ती वैद्यहरूले इस्राएलको लाशमा सुगन्‍धित लेप दले । ");
INSERT INTO npiulb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","यसको निम्‍ति चालिस दिन लागेको थियो, किनकि सुगन्‍धित लेप लगाउँदा लाग्‍ने पुरा समय यति नै थियो । तिनको निम्‍ति मिश्रीहरूले सत्तरी दिन शोक मनाए । ");
INSERT INTO npiulb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","शोक मनाउने दिन बितेपछि योसेफले फारोका भारदारहरूसँग यसरी कुरा गरे, “यदि ममाथि तपाईंहरूको निगाह छ भने कृपा गरी यो मेरो कुरा फारोकहाँ लगिदिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","मेरा बुबाले मलाई यसो भनेर शपथ खान लाउनुभयो: ‘म मर्न लागेको छु । कनान देशमा म आफैले खनेर बनाएको मेरो चिहानमा मलाई गाड्‌नू । तैँले मलाई त्यहीँ गाड्नेछस् ।’ यसकारण गएर मेरा बुबालाई त्‍यहीँ गाड्न दिनुहोस्, र त्यसपछि म फर्केर आउनेछु।” ");
INSERT INTO npiulb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फारोले जवाफ दिए, “तिमीलाई उनले शपथ खान लाएबमोजिम गएर तिम्रा बुबालाई गाड ।” ");
INSERT INTO npiulb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","योसेफ आफ्‍ना बुबालाई गाड्‌न गए । तिनका साथमा फारोका सारा अधिकारीहरू, उनका भारदारहरू र मिश्रका सबै मुख्‍य मानिसहरू, साथै ");
INSERT INTO npiulb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","योसेफका परिवारका सबै र तिनका दाजुभाइहरू र तिनका बुबाका परिवारका सबै गए । तर तिनीहरूका बालबच्‍चा, तिनीहरूका बगाल र बथानहरू गोशेन प्रदेशमा नै छोडिए । ");
INSERT INTO npiulb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","तिनका साथमा रथहरू र घोडचढीहरू पनि गए । त्‍यो एउटा ठुलो मानिसहरूको समूह थियो । ");
INSERT INTO npiulb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब तिनीहरू यर्दननेरको आतादको खलामा आइपुगे, तब तिनीहरूले साह्रै अफसोस गरेर रुवाबासी गरे । अनि त्‍यहाँ योसेफले सात दिनसम्‍म आफ्‍ना बुबाको निम्‍ति शोक गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","त्‍यस देशका बासिन्‍दा कनानीहरूले आतादको खलामा गरेको शोक देखेर भने, “यो त मिश्रीहरूको निम्ति ठुलो शोकको बेला रहेछ ।” यसकारण यर्दननेरको त्‍यस ठाउँको नाउँ हाबिल-मिश्रइम राखियो । त्‍यो यर्दन पारिपट्टि छ । ");
INSERT INTO npiulb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","यसरी याकूबले तिनीहरूलाई आज्ञा गरेबमोजिम छोराहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","तिनका छोराहरूले तिनलाई कनानसम्‍मै पुर्‍याए, र हित्ती एप्रोनसँग खेतसहित अब्राहामले चिहान बनाउनलाई किनेको ओडार, अर्थात्‌ मम्रेनेरको मक्‍पेलाको खेतमा भएको ओडारमा तिनलाई गाडे । ");
INSERT INTO npiulb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","आफ्‍ना बुबालाई गाडिसकेपछि आफ्‍ना दाजुभाइहरू र आफ्‍ना बुबालाई गाड्‌न तिनीसँग गएका सबैका साथमा योसेफ मिश्रमा फर्के । ");
INSERT INTO npiulb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","बुबाको मृत्‍यु भएको देखेर योसेफका दाजुभाइहरूले आपसमा भने, “शायद अब योसेफले हामीसँग दुश्‍मनी गरेर हामीले तिनलाई गरेका सबै खराबीको बदला लिए भने?” ");
INSERT INTO npiulb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","यसैकारण उनीहरूले यसो भनेर योसेफकहाँ खबर पठाए, “मर्नुभन्‍दा अगि तपाईंका बुबाले यस्‍तो आज्ञा दिनुभएको थियो ");
INSERT INTO npiulb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘तिमीहरूले योसेफलाई यसो भन, कृपा गरी तिम्रा दाजुहरूले तिमीसँग खराबी गरेकामा तिम्रा दाजुहरूका अपराध क्षमा गर’ ।” “अब बिन्‍ती छ, कृपा गरी तपाईंका बुबाका परमेश्‍वरका दासहरूलाई क्षमा गर्नुहोस्‌ ।” उनीहरूले यति भनेपछि योसेफ रोए । ");
INSERT INTO npiulb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","तिनका दाजुहरू पनि आएर तिनका सामुन्‍ने घोप्‍टो परे । तिनीहरूले भने, “हेर्नुहोस्, हामी तपाईंका दास हौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","तर योसेफले उनीहरूलाई भने, “नडराउनुहोस् । के म परमेश्‍वरको स्‍थानमा छु र? ");
INSERT INTO npiulb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तपाईंहरूले मेरो विरुद्धमा हानि गर्ने विचार गर्नुभयो, तर परमेश्‍वरले त्यसैद्वारा भलाइ गर्ने विचार गर्नुभयो, धेरै मानिसहरूलाई बचाउनको निम्ति, जुन तपाईंहरूले आज देख्‍नुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","यसकारण नडराउनुहोस्, तपाईंहरू र तपाईंहरूका बालबच्‍चालाई चाहिने कुराको बन्दोबस्त म गर्नेछु ।” यसरी तिनले उनीहरूलाई ढाडस दिए र तिनीहरूसँग विनम्रतासँग बोले । ");
INSERT INTO npiulb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ तिनका बुबाका परिवारहरूसँगै मिश्रमा बसे । तिनी एक सय दस वर्ष बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","योसेफले एफ्राइमको पनातिसम्‍म पनि देखे । तिनले मनश्‍शेका छोरा माकीरका भर्खर जन्‍मेका बालबच्‍चा पनि देखे, र तिनीहरू योसेफकै घुँडामा राखिए । ");
INSERT INTO npiulb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","तब योसेफले आफ्‍ना दाजुभाइहरूलाई भने, “मेरो मर्ने बेला भयो, तर परमेश्‍वर अवश्यनै तिमीहरूकहाँ आउनुहुनेछ, र उहाँले अब्राहाम, इसहाक र याकूबसित शपथ खाएर प्रतिज्ञा गर्नुभएको देशमा यस देशबाट तिमीहरूलाई निकालेर लैजानुहुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","अनि योसेफले इस्राएलका मानिसहरूलाई शपथ खान लगाए । उनले भने, “परमेश्‍वर अवश्यनै तिमीहरूकहाँ आउनुहुनेछ। त्‍यो बेला तिमीहरूले मेरा अस्‍थिहरू यहाँबाट लैजानू ।” ");
INSERT INTO npiulb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","यसरी योसेफ एक सय दस वर्षको भएर मरे, र उनीहरूले तिनको लाश सुगन्‍धित लेप दलेर बाकसमा हालेर मिश्रमा नै राखे ।");
INSERT INTO npiulb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकूबसँगै मिश्रमा आउने इस्राएलका छोराहरूका नाउँ यी नै हुन्: ");
INSERT INTO npiulb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमियोन, लेवी र यहूदा, ");
INSERT INTO npiulb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, जबूलून, र बेन्यामीन, ");
INSERT INTO npiulb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्‍ताली, गाद र आशेर । ");
INSERT INTO npiulb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकूबका जम्मा सन्तानको सङ्ख्या सत्तरी जना थियो । योसेफ पहिले नै मिश्रमा थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","त्यसपछि योसेफ, तिनका सबै दाजुहरू र त्यो सबै पुस्ता मरे । ");
INSERT INTO npiulb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","इस्राएलीहरू फल्दै-फुल्दै र सङ्ख्यामा अत्यधिक बढ्दै गए, अनि तिनीहरू शक्तिशाली भए र तिनीहरूद्वारा देश भरियो । ");
INSERT INTO npiulb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","त्यसपछि योसेफको बारेमा थाहा नपाउने नयाँ राजाले शासन गर्न थाले । ");
INSERT INTO npiulb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","तिनले आफ्ना मानिसहरूलाई भने, “हेर, इस्राएलीहरू सङ्ख्यामा हामीभन्दा बढी भएका छन् र तिनीहरू हामीभन्दा शक्तिशाली भएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","आओ, तिनीहरूसित बुद्धिमानीपूर्वक काम गरौँ नत्रभने तिनीहरूको सङ्ख्या वृद्धि भइरहनेछ । युद्ध भयो भने तिनीहरू हाम्रा शत्रुहरूसित मिल्न गई हाम्रै विरुद्धमा लड्नेछन् र देश छाडेर जानेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","त्यसैले तिनीहरूलाई कठोर काम लगाएर तिनीहरूमाथि थिचोमिचो गर्न तिनीहरूले नाइकेहरू खटाए । इस्राएलीहरूले पिताम र रामसेस नामक भण्डारका सहरहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","तर जति मिश्रीहरूले इस्राएलीहरूमाथि थिचोमिचो गरे त्यति नै तिनीहरूको सङ्ख्या बढ्दै गएर तिनीहरू फैलन थाले । त्यसैले मिश्रीहरू इस्राएलीहरूसित डराउन थाले । ");
INSERT INTO npiulb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","मिश्रीहरूले इस्राएलीहरूलाई निर्दयतापूर्वक काममा लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","मिश्रीहरूले मसला र इँटको कामसाथै खेतका कठिन कामहरू गर्न लगाएर तिनीहरूका जीवनै खल्लो बनाइदिए । तिनीहरूले लगाएका कामहरू कठिन थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","तब मिश्रका राजाले शिप्रा र पूआ नाम गरेका हिब्रू सुँडिनीहरूलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“हिब्रू स्‍त्रीहरूले बच्‍चा जन्माउने बेलामा तिमीहरूले तिनीहरूको हेरचाह गर्दा अवलोकन गर । छोरो रहेछ भने तिमीहरूले त्यसलाई मार । ");
INSERT INTO npiulb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","तर छोरी रहेछ भने त्यसलाई जीवितै राख ।” तर सुँडिनीहरू परेमश्‍वरदेखि डराउँथे । त्यसैले तिनीहरूले मिश्रका राजाले आज्ञा दिएबमोजिम गरेनन्, बरु तिनीहरूले छोराहरूलाई पनि जीवितै राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","मिश्रका राजाले तिनीहरूलाई बोलाएर भने, “तिमीहरूले किन यसो गरेर छोराहरूलाई पनि जीवितै राखेका छ्यौ?” ");
INSERT INTO npiulb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ती सुँडिनीहरूले फारोलाई जवाफ दिए, “हिब्रू स्‍त्रीहरू मिश्री स्‍त्रीहरूजस्ता छैनन् । तिनीहरू हट्टाकट्टा छन् र सुँडिनी पुग्‍नुभन्दा पहिले नै तिनीहरूले बच्‍चा जन्माइसकेका हुन्छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","परमेश्‍वरले यी सुँडिनीहरूलाई जोगाउनुभयो । इस्राएलीहरू सङ्ख्यामा बढ्दै गए र तिनीहरू शक्तिशाली भए । ");
INSERT INTO npiulb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","सुँडिनीहरू परमेश्‍वरदेखि डराएकाले उहाँले तिनीहरूलाई परिवार दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","फारोले आफ्ना सबै मानिसलाई आज्ञा दिए, “जन्मेको हरेक छोरोलाई तिमीहरूले नदीमा फ्याँक्‍नू, तर छोरीलाई भने जीवितै राख्‍नू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","अब लेवीको कुलका एक जना पुरुषले लेवीकै कुलकी एक जना स्‍त्रीसित विवाह गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ती स्‍त्री गर्भवती भइन् र एउटा छोरो जन्माइन् । तिनी स्वस्थ बालक भएको देखेर उनले तिनलाई तिन महिनासम्म लुकाइन् । ");
INSERT INTO npiulb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","तर उनले लुकाउन नसकेपछि उनले कुशको एउटा टोकरी बनाएर त्यसलाई तारपीन र अलकत्राले लिपिन् । त्यसपछि उनले बच्‍चालाई त्यसभित्र राखिन् र नदीको किनारनेर नर्कटको झाडीमा भएको पानीमा राखिदिइन् । ");
INSERT INTO npiulb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","बालकलाई के हुनेथियो भनी हेर्न तिनकी दिदीचाहिँ अलि टाढामा उभिन् । फारोकी छोरी नदीमा नुहाउन ओर्लिन् । ");
INSERT INTO npiulb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","उनका सहेलीहरूचाहिँ नदीतटमा टहल्न लागे । उनले नर्कटहरूका बिचमा एउटा टोकरी देखिन् र आफ्नी एक जना सहेलीलाई त्यो लिन पठाइन् । ");
INSERT INTO npiulb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","उनले त्यसलाई खोलेर हेर्दा बच्‍चा देखिन् । बच्‍चा रुँदै थियो । उनमा बच्‍चाप्रति दया जाग्यो र उनले भनिन्, “यो पक्‍कै पनि हिब्रूहरूको बच्‍चा हुनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तब बालककी दिदीले फारोकी छोरीलाई भनिन्, “बच्‍चालाई दूध खुवाउन तपाईंको लागि म गएर एक हिब्रू स्‍त्रीलाई फेला पारेर ल्याऊँ?” ");
INSERT INTO npiulb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फारोकी छोरीले उनलाई भनिन्, “जाऊ ।” त्यसैले ती युवती गएर आमालाई बोलाएर ल्याइन् । ");
INSERT INTO npiulb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फारोकी छोरीले बच्‍चाकी आमालाई भनिन्, “यो बच्‍चालाई लिएर जाऊ र मेरो खातिर दूध खुवाऊ र म तिम्रो ज्याला दिनेछु ।” त्यसैले आमाले बच्‍चालाई लिएर दूध खुवाउने गरिन् । ");
INSERT INTO npiulb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","बालक हुर्कंदै गएपछि उनले तिनलाई फारोकी छोरीकहाँ ल्याइन् र तिनी उनको छोरा भए । उनले तिनलाई मोशा नाउँ राखे र भने, “किनकि मैले यिनलाई पानीबाट निकालेँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जब मोशा हुर्के तिनी आफ्नो जातिकहाँ गए र तिनीहरूको कठिन कामलाई अवलोकन गरे । मोशाको आफ्नै जातिको कुनै एउटा मानिसलाई एउटा मिश्रीले हिर्काइरहेको तिनले देखे । ");
INSERT INTO npiulb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","तिनले दायाँबायाँ हेरे र कोही नदेखेपछि त्यस मिश्रीलाई मारेर त्यसको लाशलाई बालुवामुनि पुरिदिए । ");
INSERT INTO npiulb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","अर्को दिन पनि तिनी बाहिर निस्के र दुई जना हिब्रू एक-अर्कामा झगडा गरिरहेका देखे । तिनले गल्ती गर्नेचाहिँलाई भने, “तिमी आफ्नै साथीलाई किन हिर्काउँदै छौ?” ");
INSERT INTO npiulb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","तर त्यस मानिसले भन्यो, “कसले तिमीलाई हाम्रो अगुवा र न्यायकर्ता बनायो? त्यस मिश्रीलाई मारेजस्तै के तिमी मलाई पनि मार्न खोज्दै छौ?” तब मोशा डराएर भने, “निश्‍चय नै, मैले गरेको कुरा अरूहरूले थाहा पाउन लागेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","फारोले यस विषयमा सुनेपछि तिनले मोशालाई मार्न खोजे । तर मोशा फारोदेखि भागेर मिद्यान देशमा गए र त्यहाँ तिनी कुवानेर बसे । ");
INSERT INTO npiulb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","अब मिद्यानका पूजाहारीका सात छोरी थिए । तिनीहरू आएर पानी भरे र तिनीहरूका पिताका भेडा-बाख्रालाई पानी खुवाउन डुँड भरे । ");
INSERT INTO npiulb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","गोठालाहरू आएर तिनीहरूलाई धपाउन खोज्दा मोशाले ती युवतीहरूको मदत गरे । त्यसपछि तिनले तिनीहरूका भेडा-बाख्राहरूलाई पनि पानी खुवाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब ती केटीहरू आफ्ना पिता रूएलकहाँ गए तब तिनले सोधे, “आज तिमीहरू किन यति चाँडै घर आएका छौ?” ");
INSERT INTO npiulb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","तिनीहरूले भने, “एक जना मिश्रीले हामीलाई गोठालाहरूबाट छुटकारा दिए । तिनले हाम्रो निम्ति पानी तान्‍नुका साथै भेडा-बाख्राहरूलाई पनि पानी खुवाइदिए ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","तिनले आफ्ना छोरीहरूलाई भने, “त्यसो भए, तिनी कहाँ छन् त? किन तिमीहरूले ती मानिसलाई छाड्यौ?” तिनलाई डाक ताकि तिनले हामीसितै खाना खान सकून् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मोशा ती मानिससित बस्‍न राजी भए जसले तिनलाई आफ्नी छोरी सिप्पोरा विवाहको लागि दिए । ");
INSERT INTO npiulb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","उनले एउटा छोरो जन्माइन् र मोशाले त्यसको नाउँ गेर्शोम राखे । तिनले भने, “म विदेशी भूमिमा प्रवासी भएको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","धेरै समय बितेपछि मिश्रका राजा मरे । इस्राएलीहरूले दासत्वको कठिनाइको कारणले चित्कार गरे । तिनीहरूले मदतको लागि पुकारा गरे र तिनीहरूको दासत्वको कारण तिनीहरूको पुकारा परमेश्‍वरकहाँ पुग्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्‍वरले तिनीहरूको क्रन्दन सुन्‍नुभएपछि उहाँले अब्राहाम, इसहाक र याकूबसित बाँध्‍नुभएको करार सम्झनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","परमेश्‍वरले इस्राएलीहरूलाई देख्‍नुभयो, र तिनीहरूको अवस्था बुझ्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","अब मोशा अझै पनि आफ्ना ससुरा मिद्यानका पूजाहारी यित्रोका भेडा-बाख्रा चराउँदै थिए । तिनले भेडा-बाख्रालाई उजाड-स्थानको परसम्म लगी परमेश्‍वरको पर्वत होरेबसम्म लगे । ");
INSERT INTO npiulb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","त्यहाँ परमप्रभुका दूत जलिरहेको पोथ्रामा तिनीकहाँ देखा परे । मोशाले हेर्दा त्यो पोथ्रा जलिरहेको थियो तर भस्म भएको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","मोशाले भने, “म एकातिर गएर यो गजबको दृश्य किन भस्म भएको रहेनछ भनी हेर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब तिनी हेर्नलाई एकातिर गएको परमप्रभुले देख्‍नुभयो तब उहाँले पोथ्राबाट तिनलाई भन्‍नुभयो, “मोशा, ए मोशा ।” तिनले भने, “म यहीँ छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","परमेश्‍वरले भन्‍नुभयो, “अझ नजिक नआइज । तेरो खुट्टाबाट तेरो जुत्ता फुकाल् किनकि तँ उभिएको भूमि मेरो लागि अलग गरिएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","उहाँले थप्‍नुभयो, “म तेरा पिता अब्राहाम, इसहाक र याकूबका परमेश्‍वर हुँ ।” त्यसपछि मोशाले आफ्नो अनुहार ढाके किनकि तिनी परमेश्‍वरलाई हेर्न डराएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","परमप्रभुले भन्‍नुभयो, “निश्‍चय नै मिश्रमा भएका मेरा मानिसहरूको दुःखकष्‍ट मैले देखेको छु । तिनीहरूका नाइकेहरूको कारणले तिनीहरूको रुवाइ मैले सुनेको छु किनकि मलाई तिनीहरूको दुःखकष्‍ट थाहा छ । ");
INSERT INTO npiulb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","तिनीहरूलाई मिश्रीहरूको शक्तिबाट छुटकारा दिलाई असल, विशाल अनि दूध र मह बग्‍ने देशमा लैजान म ओर्लिआएको छु । त्यो कनानी, हित्ती, एमोरी, परिज्‍जी, हिव्वी र यबूसीहरूको देश हो । ");
INSERT INTO npiulb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","अब इस्राएलका मानिसहरूको रुवाइ मकहाँ आइपुगेको छ । यसको अतिरिक्त, मिश्रीहरूद्वारा तिनीहरूमाथि गरिएको थिचोमिचोलाई पनि मैले देखेको छु । ");
INSERT INTO npiulb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","अब म तँलाई फारोकहाँ पठाउनेछु ताकि तैँले मेरा मानिस इस्राएलीहरूलाई मिश्रबाट निकालेर लैजान सक् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","तर मोशाले परमेश्‍वरलाई भने, “फारोकहाँ गई मिश्रबाट इस्राएलीहरूलाई निकालेर ल्याउने म को हुँ र?” ");
INSERT INTO npiulb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्‍वरले जवाफ दिनुभयो, “निश्‍चय नै म तँसित हुनेछु । मैले तँलाई पठाएको हुँ भन्‍नाका लागि चिन्हचाहिँ यो हुनेछ । तैँले ती मानिसहरूलाई मिश्रबाट बाहिर ल्याएपछि तैँले यही पर्वतमा मेरो आराधना गर्नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मोशाले परमेश्‍वरलाई भने, “म इस्राएलीहरूकहाँ गई 'तिमीहरूका पिता-पुर्खाका परमेश्‍वरले मलाई तिमीहरूकहाँ पठाउनुभएको छ' भन्दा तिनीहरूले 'उहाँको नाउँ के हो' भनी सोधे भने मैले तिनीहरूलाई के जवाफ दिने?” ");
INSERT INTO npiulb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्‍वरले मोशालाई भन्‍नुभयो, “म हुँ जो म हुँ ।” उहाँले भन्‍नुभयो, “ तैँले इस्राएलीहरूलाई यसो भन्‍नू, 'म हुँ भन्‍नेले मलाई तिमीहरूकहाँ पठाउनुभएको छ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्‍वरले मोशालाई यसो पनि भन्‍नुभयो, “तैँले इस्राएलीहरूलाई यसो भन्‍नैपर्छ, 'तिमीहरूका पिता-पुर्खाका परमेश्‍वर अर्थात् अब्राहामका परमेश्‍वर, इसहाकका परमेश्‍वर र याकूबका परमेश्‍वरले मलाई तिमीहरूकहाँ पठाउनुभएको हो । मेरो नाउँ सदासर्वादको लागि यही हो र यही नाउँद्वारा पुस्तौँसम्म मेरो सम्झना गरिनेछ ।' ");
INSERT INTO npiulb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","गएर इस्राएलका धर्म-गुरुहरूलाई भेला गर् । तिनीहरूलाई यसो भन्‍नू, 'तिमीहरूका पिता-पुर्खाका परमेश्‍वर अर्थात् अब्राहाम, इसहाक र याकूबका परमेश्‍वर मकहाँ देखा परी भन्‍नुभयो, “मैले वास्तवमै तिमीहरूलाई अवलोकन गरेको छु र तिमीहरूलाई मिश्रमा के गरिएको छ भनी देखेको छु । ");
INSERT INTO npiulb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","तिमीहरूले मिश्रमा भोगेको थिचोमिचोबाट मुक्त गरी दूध र मह बग्‍ने देश अर्थात् कनानी, हित्ती, एमोरी, परिज्‍जी, हिव्वी र यबूसीहरूको देशमा लैजाने मैले प्रतिज्ञा गरेको छु” ।' ");
INSERT INTO npiulb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","तिनीहरूले तेरो कुरा सुन्‍नेछन् । तँ र इस्राएलका धर्म-गुरुहरू मिश्रका राजाकहाँ गई त्यसलाई यसो भन्‍नू, 'हिब्रूहरूका परमप्रभुले हामीलाई भेट्नुभएको छ । अब हामी तिन दिनको यात्रा गरी उजाड-स्थानमा जाऔँ ताकि हाम्रा परमप्रभु परमेश्‍वरलाई हामीले बलिदान चढाउन सकौँ ।' ");
INSERT INTO npiulb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","तर राजा बाध्य नपारिएसम्म त्यसले तिमीहरूलाई जान दिनेछैन भनी मलाई थाहा छ । ");
INSERT INTO npiulb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","म मेरो हात फैलाई मैले मिश्रीहरूका बिचमा गर्ने सबै आश्‍चर्यकर्मले तिनीहरूलाई आक्रमण गर्नेछु । त्यसपछि त्यसले तिमीहरूलाई जान दिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","म यस जातिमाथि मिश्रहरूलाई निगाह गर्न लगाउनेछु ताकि तिमीहरू जाँदा रित्तो हात जान नपरोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","हरेक स्‍त्रीले आ-आफ्ना मिश्री छिमेकीहरू र तिनीहरूका घरहरूमा बस्‍ने कुनै पनि स्‍त्रीहरूबाट सुन र चाँदीका गरगहनाहरूसाथै लत्ता कपडाहरू माग्‍नेछ । तिमीहरूले ती आ-आफ्ना छोराछोरीहरूलाई लगाइदिनेछौ । यसरी तिमीहरूले मिश्रीहरूलाई लुट्नेछौ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मोशाले जवाफ दिए, “तर तिनीहरूले विश्‍वास गरेनन् वा मेरो कुरा नसुनी 'परमप्रभु तिमीकहाँ देखा पर्नुभएको होइन' भनेमा के गर्ने नि?” ");
INSERT INTO npiulb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","परमप्रभुले तिनलाई भन्‍नुभयो, “तेरो हातमा के छ?” मोशाले भने, “लट्ठी ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","परमप्रभुले भन्‍नुभयो, “त्यसलाई भुइँमा फाल् ।” मोशाले त्यसलाई भुइँमा फाले र त्यो सर्प भयो । मोशा दौडेर भागे । ");
INSERT INTO npiulb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","परमप्रभुले मोशालाई भन्‍नुभयो, “तेरो हात पसारेर त्यसको पुच्छर समात् ।” त्यसैले तिनले आफ्नो हात पसारेर त्यस सर्पलाई समाते । त्यो फेरि तिनको हातमा लट्ठी भयो । ");
INSERT INTO npiulb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“तिनीहरूका पिता-पुर्खाका परमप्रभु परमेश्‍वर अर्थात् अब्राहामका परमेश्‍वर, इसहाकका परमेश्‍वर र याकूबका परमेश्‍वर तँकहाँ देखा पर्नुभएको थियो भनी तिनीहरूले विश्‍वास गरून् भन्‍नाका लागि यो चिन्ह हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","परमप्रभुले तिनलाई यसो पनि भन्‍नुभयो, “अब तेरो हात आफ्नो खास्टोभित्र राख् ।” त्यसैले मोशाले आफ्नो हात खास्टोभित्र राखे । तिनले बाहिर निकाल्दा तिनको हातमा हिउँजस्तै सेतो कुष्‍ठरोग लागेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","परमप्रभुले भन्‍नुभयो, “फेरि तेरो हात खास्टोभित्र राख् ।” त्यसैले मोशाले आफ्नो हात खास्टोभित्र राखे र तिनले हात बाहिर निकाल्दा त्यो तिनको शरीरको अरू मासुजस्तै स्वस्थ भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","परमप्रभुले भन्‍नुभयो, “तिनीहरूले मेरो शक्तिको पहिलो चिन्हलाई ध्यान दिएनन् वा विश्‍वास गरेनन् भने तिनीहरूले दोस्रो चिन्हलाई विश्‍वास गर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","तिनीहरूले मेरो शक्तिका यी दुईवटै चिन्हलाई पनि विश्‍वास गरेनन् वा तेरो कुरा सुनेनन् भने नदीबाट थोरै पानी लिएर जा र त्यसलाई सुक्खा भूमिमा खन्या । तैँले लिएर जाने पानी सुक्खा भूमिमा रगत बन्‍नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","तब मोशाले परमप्रभुलाई भने, “हे प्रभु, म बोल्नमा सिपालु छैनँ, न पहिले थिएँ न त तपाईं आफ्ना दाससित बोल्नुभएपछि नै । म बोल्न र जिब्रो चलाउनमा सुस्त छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","परमप्रभुले तिनलाई भन्‍नुभयो, “मानिसको मुख बनाउने को हो? मानिसलाई गुँगो वा बैरो वा दृष्‍टिविहीन बनाउने को हो? के म परमप्रभुले नै होइनँ र? ");
INSERT INTO npiulb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","त्यसैले अब जा र म तेरो मुखमा भएर के भन्‍ने भनी तँलाई सिकाउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","तर मोशाले भने, “हे प्रभु, तपाईंले इच्छा गर्नुभएको अरू कसैलाई पठाउनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब परमप्रभु मोशासित रिसाउनुभयो र भन्‍नुभयो, “तेरो दाजु लेवी हारून छैन र? त्यसले राम्ररी बोल्न सक्छ भनी मलाई थाहा छ । यसको अतिरिक्त, त्यो तँलाई भेट्न आउँदै छ र त्यसले तँलाई देख्दा त्यो ह्रदयमा खुसी हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तँ त्योसित कुरा गर् र त्यसले भन्‍नुपर्ने कुरा त्यसलाई बताइदे । म तिमीहरू दुवैसित हुनेछु र के गर्ने भनी म तिमीहरू दुवैलाई देखाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","त्यसले तेरो लागि मानिसहरूसित बोल्नेछ । त्यो तेरो प्रवक्ता हुनेछ र तँ त्यसको लागि मजस्तै परमेश्‍वर हुनेछस् । ");
INSERT INTO npiulb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","तैँले तेरो हातमा यो लट्ठी लैजा । यसले तैँले चिन्हहरू गर्नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","त्यसैले मोशा आफ्ना ससुरा यित्रोकहाँ गई तिनलाई भने, “मलाई मिश्रमा भएका मेरा आफन्तहरू जीवितै छन् कि छैनन् भनी हेर्न फर्केर जान दिनुहोस् ।” यित्रोले मोशालाई भने, “शान्तिसित जाऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","परमप्रभुले मिद्यानमा मोशालाई भन्‍नुभयो, “फर्केर मिश्रमा जा किनकि तेरो जीवन लिन खोज्नेहरू सबै मरिसकेका छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","आफ्नी पत्‍नी र आफ्ना छोराहरू गधामा चढाएर मोशा बाटो लागे । तिनी मिश्र देशमा फर्के र तिनले परमेश्‍वरको लट्ठी आफूसँगै लगेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","परमप्रभुले मोशालाई भन्‍नुभयो, “तँ मिश्रमा फर्केर जाँदा मैले तेरो शक्तिमा राखिदिएका सबै अचम्मका कामहरू तैँले फारोको सामु गरेर देखा । तर म त्यसको ह्रदय कठोर पार्नेछु र त्यसले मानिसहरूलाई जान दिनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तैँले फारोलाई यसो भन्‍नू, “परमप्रभु यसो भन्‍नुहुन्छ, 'इस्राएल मेरो जेठो छोरो हो, ");
INSERT INTO npiulb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","र म तँलाई भन्दछु, 'मेरो छोरोलाई जान दे ताकि त्यसले मेरो आराधना गरोस् ।' तर तैँले त्यसलाई जान दिन इन्कार गरेकोले निश्‍चय नै म तेरो जेठो छोरोलाई मार्नेछु' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","अब बाटोमा बास बस्‍ने ठाउँमा तिनीहरू रोकिँदा परमप्रभुले मोशालाई भेटी तिनलाई मार्न खोज्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","त्यसपछि सिप्पोराले चकमके कर्द लिई आफ्नो छोरोको खलडी काटेर त्यसलाई मोशाको खुट्टामा छुवाइन् । ");
INSERT INTO npiulb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","तब उनले भनिन्, “निश्‍चय नै तपाईं रगतद्वारा मेरो दुलहा हुनुहुन्छ ।” त्यसैले परमप्रभुले तिनलाई एक्लै छाडिदिनुभयो । यो खतनाको कारणले “तपाईं मेरो दुलहा हुनुहुन्छ” भनी उनले भनिन् । ");
INSERT INTO npiulb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","परमप्रभुले हारूनलाई भन्‍नुभयो, “उजाड-स्थानमा मोशालाई भेट्न जा ।” हारून गए र तिनले मोशालाई परमेश्‍वरको पर्वतमा भेटी चुम्बन गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","परमप्रभुले मोशालाई भनेर पठाउनुभएका सबै कुरा र देखाउनू भनी आज्ञा गर्नुभएका सबै चिन्हको बारेमा मोशाले हारूनलाई बताए । ");
INSERT INTO npiulb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","तब मोशा र हारून गएर इस्राएलीहरूका सबै धर्म-गुरुलाई भेला गराए । ");
INSERT INTO npiulb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","परमप्रभुले मोशालाई भन्‍नुभएका सबै कुरा हारूनले बताए । तिनले परमप्रभुको शक्तिका चिन्हहरू पनि मानिसहरूका सामु गरेर देखाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","मानिसहरूले विश्‍वास गरे । परमप्रभुले इस्राएलीहरूको वास्ता गर्नुहुन्छ र उहाँले तिनीहरूमाथि गरिएको थिचोमिचो देख्‍नुभएको छ भनी जब तिनीहरूले सुने, तिनीहरूले आ-आफ्ना शिर झुकाई उहाँको आराधना गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","यी कुराहरूपछि मोशा र हारून फारोकहाँ गएर भने, “इस्राएलका परमप्रभु यसो भन्‍नुहुन्छ, 'उजाड-स्थानमा चाड मनाउनलाई मेरा मानिसहरूलाई जान दे' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फारोले भने, “परमप्रभु को हुनुहुन्छ? उहाँको कुरा सुनेर मैले इस्राएललाई किन जान दिने? म परमप्रभुलाई चिन्दिनँ, र म इस्राएललाई जान दिन्‍नँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तिनीहरूले भने, “हिब्रूहरूका परमेश्‍वरले हामीलाई भेट्नुभएको छ । तिन दिनको यात्रा गरी उजाड-स्थानमा गई परमप्रभु हाम्रा परमेश्‍वरको निम्ति बलिदान चढाउन दिनुहोस् ताकि उहाँले हामीलाई विपत्ति वा तरवारले नाश नगर्नुभएको होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","तर मिश्रका राजाले तिनीहरूलाई भने, “ए मोशा र हारून हो, तिमीहरू मानिसहरूका काममा किन अवरोध गर्छौ? तिमीहरूका काममा जाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","तिनले यसो पनि भने, “अहिले हाम्रो देशमा धेरै मानिस छन्, र तिमीहरू तिनीहरूलाई काम गर्नबाट रोक्दै छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","त्यही दिन फारोले मानिसका नाइकेहरू र मजदुरहरूलाई यस्तो हुकुम दिए, ");
INSERT INTO npiulb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“पहिलेझैँ तिमीहरूले मानिसहरूलाई इँट बनाउन पराल नदेओ । तिनीहरू आफै गएर तिनीहरूका निम्ति पराल जम्मा गरून् । ");
INSERT INTO npiulb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तरै पनि तिमीहरूले तिनीहरूबाट पहिले जत्तिकै इँटको सङ्ख्या माग्‍नू । त्योभन्दा कम स्वीकार नगर किनकि तिनीहरू अल्छे भएका छन् । त्यसैले तिनीहरू यसो भन्दै कराउँछन्, 'हाम्रा परमेश्‍वरकहाँ गएर बलिदान चढाउन हामीलाई अनुमति दिनुहोस् ।' ");
INSERT INTO npiulb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","यी मानिसहरूलाई कामको बोझ बढाइदेओ ताकि तिनीहरू यसमा लागिराखेर छली वचनहरूतर्फ ध्यान नदिऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","त्यसैले मानिसका नाइकेहरू र मजदुरहरू बाहिर गई तिनीहरूले मानिसहरूलाई भने, “फारो यसो भन्‍नुहुन्छ, 'अबदेखि उसो म तिमीहरूलाई पराल दिन्‍नँ । ");
INSERT INTO npiulb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","जहाँ-जहाँ पराल पाइन्छ तिमीहरू आफै गएर ल्याओ, तर तिमीहरूको कामको बोझ भने घटाइनेछैन' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","त्यसैले मानिसहरू परालका टुक्राटाक्री बटुल्न मिश्रभरि छरिए । ");
INSERT INTO npiulb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","नाइकेहरूले तिनीहरूलाई यसो भनिरहे, “तिमीहरूलाई पराल दिँदा जस्तै गरी तिमीहरूको काम सक ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","फारोका नाइकेहरूले इस्राएली नाइकेहरूलाई पिटे । यी तिनै मानिसहरू थिए जसलाई कामदारहरूको रेखदेख गर्न राखिएको थियो । नाइकेहरूले यसो भनेर सोधिरहे, “तिमीहरूले विगतमा गरेझैँ हिजोआज किन चाहेजति इँटहरू बनाइरहेका छैनौ?” ");
INSERT INTO npiulb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","त्यसैले इस्राएली नाइकेहरू फारोकहाँ आएर बिन्ती गरे, “तपाईंले हजुरका दासहरूलाई किन यस्‍तो व्यवहार गर्दै हुनुहुन्छ? ");
INSERT INTO npiulb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","हजुरका दासहरूलाई पराल नदिएको भए तापनि तिनीहरू हामीलाई यसो भन्दै छन्, 'इँटहरू बनाओ ।' अब हामी हजुरका दासहरूलाई पिटिन पनि थालिएको छ । तर यो त हजुरका आफ्नै मानिसहरूको दोष हो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","तर फारोले भने, “तिमीहरू अल्छे छौ । तिमीहरू अल्छे छौ । तिमीहरू भन्छौ, 'परमप्रभुलाई बलिदान चढाउन हामीलाई जान अनुमति दिनुहोस् ।' ");
INSERT INTO npiulb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","त्यसैले काममा फर्केर जाओ । तिमीहरूलाई अब उसो पराल दिइनेछैन, तरै पनि तिमीहरूले उही सङ्ख्यामा इँटहरू बनाउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“तिमीहरूले दैनिक उत्पादन गर्ने इँटहरूको सङ्ख्या कम हुनुहुँदैन” भनी इस्राएली नाइकेहरूलाई बताइँदा तिनीहरू कष्‍टमा भएको तिनीहरूले देखे । ");
INSERT INTO npiulb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","तिनीहरूले फारोकहाँबाट फर्केपछि मोशा र हारूनलाई भेटे जो दरबारबाहिर उभिरहेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","तिनीहरूले मोशा र हारूनलाई भने, “परमप्रभुले तपाईंहरूलाई हेरी दण्ड दिनुभएको होस् किनकि तपाईंहरूले हामीलाई फारो र उहाँका दासहरूको दृष्‍टिमा तिरस्कृत तुल्याउनुभएको छ । हामीलाई मार्न तपाईंहरूले तिनीहरूका हातमा तरवार थमाइदिनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मोशा परमप्रभुकहाँ गई भने, “हे प्रभु, तपाईंले किन यो जातिमा कष्‍ट ल्याउनुभएको? तपाईंले पहिले मलाई किन दरबारमा पठाउनुभयो? ");
INSERT INTO npiulb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","तपाईंको नाउँमा म फारोसित बोल्न आएदेखि तिनले यस जातिलाई कष्‍ट ल्याएका छन्, र तपाईंले अझै पनि आफ्नो जातिलाई मुक्त गर्नुभएको छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, “अब म फारोलाई जे गर्नेछु, त्यो तैँले देख्‍नेछस् । मेरो शक्तिशाली हातको कारणले गर्दा त्यसले तिनीहरूलाई जान दिएको तैँले देख्‍नेछस् । मेरो शक्तिशाली हातको कारणले गर्दा त्यसले तिनीहरूलाई आफ्नो देशबाट बाहिर निकाल्नेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्‍वर मोशासित बोल्नुभयो र भन्‍नुभयो, “म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","म सर्वशक्तिमान् परमेश्‍वरको रूपमा अब्राहाम, इसहाक र याकूबकहाँ देखा परेँ । तर मेरो नाउँ परमप्रभुको रूपमा म तिनीहरूकहाँ चिनाएको थिइनँ । ");
INSERT INTO npiulb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","तिनीहरूलाई कनान देश दिनलाई मैले तिनीहरूसित मेरो करार पनि बाँधेँ । यो त्यही देश हो जहाँ तिनीहरू प्रवासी भएर यताउता चाहारे । ");
INSERT INTO npiulb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","अनि मिश्रीहरूले दासत्वमा राखेका इस्राएलीहरूको क्रन्दनलाई मैले सुनेको छु, र मैले मेरो करारको सम्झना गरेको छु । ");
INSERT INTO npiulb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","त्यसकारण, इस्राएलीहरूलाई यसो भन्, 'म परमप्रभु हुँ । म तिमीहरूलाई मिश्रीहरूको दासत्वबाट निकाली तिनीहरूको शक्तिबाट मुक्त गराउनेछु । मेरो शक्ति देखाएर र इन्साफका शक्तिशाली कामहरू गरेर म तिमीहरूलाई छुटकारा दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","म तिमीहरूलाई मेरै जाति हुनलाई ग्रहण गर्नेछु, र म तिमीहरूका परमेश्‍वर हुनेछु । तिमीहरूलाई मिश्रीहरूको दासत्वबाट निकालेर ल्याउने म तिमीहरूका परमप्रभु परमेश्‍वर हुँ भनी तिमीहरूले जान्‍नेछौ । ");
INSERT INTO npiulb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","मैले अब्राहाम, इसहाक र याकूबलाई दिने प्रतिज्ञा गरेको देशमा म तिमीहरूलाई ल्याउनेछु । म यो तिमीहरूलाई सम्पत्तिको रूपमा दिनेछु । म परमप्रभु हुँ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मोशाले इस्राएलीहरूलाई यो कुरा बताउँदा तिनीहरूको कठोर दासत्वको कारणले उब्जेको तिनीहरूको निरुत्साहले गर्दा तिनीहरूले तिनको कुरा सुनेनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“इस्राएलका मानिसहरूलाई त्यसको देशबाट जान दे भनी मिश्रका राजा फारोलाई बताइदे ।” ");
INSERT INTO npiulb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","मोशाले परमप्रभुलाई भने, “इस्राएलीहरूले त मेरो कुरा सुनेका छैनन् भने फारोले किन सुन्‍ने किनकि म बोल्नमा सिपालु छैनँ?” ");
INSERT INTO npiulb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","परमप्रभु मोशा र हारूनसित बोल्नुभयो । इस्राएलीहरूलाई मिश्र देशबाट बाहिर ल्याउन उहाँले मिश्रका राजा फारोलाई बताउनू भनी तिनीहरूलाई आज्ञा दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","तिनीहरूका पिताका परिवारहरूका मुख्य-मुख्य मानिसहरू यिनै थिएः इस्राएलका जेठो छोरो रूबेनका छोराहरू हानोक, पल्लु, हेस्रोन र कर्मी थिए । रूबेनका वंशहरू यिनै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमियोनका छोराहरू यमूएल, यामीन, ओहद, याकीन, सोहोर र कनानी स्‍त्रीका छोरा शौल थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवीका छोराहरूका नाउँ तिनका पुस्ताअनुसार निम्‍न लिखित छः तिनीहरू गेर्शोन, कहात र मरारी थिए । लेवी १३७ वर्षसम्म बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोनका छोराहरू लिब्‍नी र शिमी थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहातका छोराहरू अम्राम, यिसहार, हेब्रोन र उज्‍जीएल थिए । कहात १३३ वर्षसम्म बाँचे । ");
INSERT INTO npiulb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारीका छोराहरू महली र मूशी थिए । लेवीका वंशहरू तिनीहरूका पुस्ताअनुसार यिनै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामले आफ्नी फुपू योकेबेदलाई विवाह गरे । उनले मोशा र हारूनलाई जन्माइन् । अम्राम १३७ वर्षसम्म बाँचे र त्यसपछि तिनी मरे । ");
INSERT INTO npiulb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहारका छोराहरू कोरह, नेपेग र जिक्री थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्‍जीएलका छोराहरू मीशाएल, एलसाफान र सिथ्री थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारूनले अम्मीनादाबकी छोरी नहशोनकी बहिनी एलीशेबालाई विवाह गरे । तिनीबाट उनले नादाब, अबीहू, एलाजार र ईतामारलाई जन्माइन् । ");
INSERT INTO npiulb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहका छोराहरू अस्सीर, एल्काना र अबिआसाप थिए । कोरहका वंशहरू यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारूनका छोरा एलाजारले पतुएलकी छोरीहरूमध्ये एक जनासित विवाह गरे । तिनीबाट उनले पीनहासलाई जन्माइन् । लेवीहरूका परिवारका मुख्य-मुख्य मानिसहरू तिनीहरूका वंशहरूअनुसार यी नै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","यी दुई तिनै हारून र मोशा थिए जसलाई परमप्रभुले भन्‍नुभयो, “इस्राएलीहरूका योद्धाहरूको दल-दलद्वारा तिनीहरूलाई मिश्र देशबाट बाहिर ल्याउनू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","इस्राएलीहरूलाई मिश्रबाट बाहिर ल्याउन अनुमति दिइयोस् भनी हारून र मोशाले मिश्रका राजा फारोलाई भने । यी तिनै मोशा र हारून थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","परमप्रभु मिश्र देशमा मोशासित बोल्नुहुँदा ");
INSERT INTO npiulb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","उहाँले भन्‍नुभयो, “म परमप्रभु हुँ । मैले तँलाई भन्‍ने हरेक कुरो मिश्रका राजा फारोलाई भन्‍नू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","तर मोशाले भने, “म बोल्नमा सिपालु नभएकोले फारोले किन मेरो कुरा सुन्लान् र?” ");
INSERT INTO npiulb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, “हेर्, मैले तँलाई फारोको निम्ति ईश्‍वरजस्तै बनाएको छु । तेरो दाजु हारून तेरो अगमवक्ता हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","मैले तँलाई आज्ञा गरेको हरेक कुरो तैँले भन्‍नू । फारोको देशबाट इस्राएलका मानिसहरूलाई जान दिइयोस् भन्‍नाका लागि तेरो दाजु हारूनले फारोसित बोल्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","तर म फारोको ह्रदय कठोर पार्नेछु, र मिश्र देशमा मेरो शक्तिमा धेरै चिन्हहरू, अचम्मका कामहरू देखाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तर फारोले तेरो कुरा सुन्‍नेछैन । त्यसैले म मेरो हात मिश्रमाथि पसारी ठुला-ठुला दण्डका क्रियाकलापहरूद्वारा मेरा योद्धाहरू, मेरो जाति र इस्राएलका सन्तानहरूलाई मिश्रदेशबाट निकालेर ल्याउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","मैले मिश्रमाथि मेरो हात पसारेर इस्राएलीहरूलाई तिनीहरूका बिचबाट ल्याएपछि म नै परमप्रभु हुँ भनी मिश्रीहरूले जान्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","परमप्रभुले आज्ञा गर्नुभएझैँ मोशा र हारूनले गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","फारोसित कुरा गर्दा मोशा असी वर्षका थिए भने हारून त्रियासी वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फारोले तिमीहरूलाई 'आश्‍चर्यकर्म गर्' भन्दा तैँले हारूनलाई भन्‍नू, 'तपाईंको लट्ठी लिएर त्यसलाई फारोको सामुन्‍ने फ्याँक्‍नुहोस् अनि त्यो सर्प बन्‍नेछ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","तब मोशा र हारून फारोकहाँ गए, र परमप्रभुले आज्ञा गर्नुभएझैँ तिनीहरूले गरे । हारूनले फारो र तिनका अधिकारीहरूका सामु आफ्नो लट्ठी फ्याँके र त्यो सर्प भयो । ");
INSERT INTO npiulb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब फारोले आफ्ना बुद्धिमानी मानिस र टुनामुना गर्नेहरूलाई डाके । तिनीहरूका जादुद्वारा तिनीहरूले पनि उही कुरो गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","हरेक मानिसले आ-आफ्नो लट्ठी फ्याँके र ती लट्ठीहरू सर्प बने । तर हारूनको लट्ठीले तिनीहरूका सर्पहरूलाई निलिदियो । ");
INSERT INTO npiulb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","फारोको ह्रदय कठोर पारियो, र परमप्रभुले पहिले भन्‍नुभएझैँ तिनले उनीहरूका कुरा सुनेनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","परमप्रभुले मोशालाई भन्‍नुभयो, “फारोको ह्रदय कठोर छ, त्यसले मानिसहरूलाई जान दिन इन्कार गर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","फारो नदीतिर जाने बेलामा बिहानै त्यसकहाँ जा । त्यसलाई भेट्न नदीको तटमा उभेर बस् र सर्प बनेको लट्ठी तेरो हातमा लिएर जा । ");
INSERT INTO npiulb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","त्यसलाई भन्, 'हिब्रूहरूका परमेश्‍वर परमप्रभुले मलाई तपाईंकहाँ यसो भनेर पठाउनुभएको छ, 'मेरो जातिलाई जान दे ताकि तिनीहरू उजाड-स्थानमा गएर मेरो आराधना गर्न सकून् । तैँले अहिलेसम्म मानेको छैनस् ।' ");
INSERT INTO npiulb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","परमप्रभु यसो भन्‍नुहुन्छ, 'यसद्वारा म परमप्रभु हुँ भनी तैँले थाहा पाउनेछस् । मेरो हातमा भएको यस लट्ठीले म नील नदीको पानीलाई प्रहार गर्नेछु र नदी रगतमा परिणत हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","नदीमा भएका माछाहरू मर्नेछन्, र नदी गन्हाउनेछ । मिश्रीहरूले नदीबाट पानी पिउन सक्‍नेछैनन् ।' ");
INSERT INTO npiulb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","तब परमप्रभुले मोशालाई भन्‍नुभयो, “हारूनलाई भन्, 'तेरो लट्ठी लिई मिश्रका पानी, नदीहरू, खोलाहरू, तालहरू र पोखरीहरूमा तेरो हात पसार् र ती पानी रगत बन्‍नेछन् । यसो गर् ताकि मिश्र देशभरि जताततै रगत होस्, यहाँसम्म कि काठ र ढुङ्गाहरूका भाँडाकुँडाहरूमा पनि रगत होस्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","परमप्रभुले आज्ञा गर्नुभएझैँ मोशा र हारूनले गरे । हारूनले लट्ठी उठाएर फारो र तिनका अधिकारीहरूका सामुन्‍ने त्यसलाई नदीमा पसारे । सबै पानी रगतमा परिणत भए । ");
INSERT INTO npiulb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नदीका माछाहरू मरे र पानी गन्हाउन थाल्यो । मिश्रीहरूले नदीको पानी पिउन सकेनन्, र मिश्र देशैभरि जताततै रगतै-रगत थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तर मिश्रका जादुगरहरूले पनि आफ्नो जादुद्वारा त्यसै गरे । त्यसकारण परमप्रभुले भन्‍नुभएझैँ फारोको ह्रदय कठोर भयो र तिनले मोशा र हारूनको कुरा सुनेनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","तब फारो फर्केर आफ्नो घर गए । तिनले यसमा ध्यान पनि दिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","सबै मिश्रीले पिउने पानीको लागि नदीको वरिपरि खने, तर तिनीहरूले नदीकै पानी भने पिउन सकेनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","परमप्रभुले नदीमा आक्रण गर्नुभएको सात दिन भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, “फारोकहाँ गएर त्यसलाई भन्, 'परमप्रभु यसो भन्‍नुहुन्छः मेरो आराधना गर्नलाई मेरा मानिसहरूलाई जान दे । ");
INSERT INTO npiulb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","तैँले तिनीहरूलाई जान दिन इन्कार गरिस् भने म तेरो सारा देशलाई भ्यागुताले सताउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नदी भ्यागुताहरूले भरिनेछ । तिनीहरू तेरो घर, सुत्‍ने कोठा र तेरो ओछ्यानमा आउनेछन् । तिनीहरू तेरा मानिसहरू, तेरा चुलाहरू र पिठो मुछ्ने आह्रीहरूमा आउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","भ्यागुताहरूले तँलाई, तेरा मानिसहरू र तेरा सबै अधिकारीलाई आक्रमण गर्नेछन्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","परमप्रभुले मोशालाई भन्‍नुभयो, “हारूनलाई भन्, 'तपाईंको लट्ठी लिएर नदीहरू, खोलाहरू र तालहरूमा तपाईंको हात पसारी मिश्र देशमा भ्यागुताहरू ल्याउनुहोस्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","हारूनले मिश्रका पानीमा आफ्नो हात पसारे र भ्यागुताहरू आएर मिश्र देशलाई ढाके । ");
INSERT INTO npiulb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","तर जादुगरहरूले पनि त्यसै गरे । तिनीहरूले पनि मिश्र देशभरि भ्यागुताहरू ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","तब फारोले मोशा र हारूनलाई बोलाउन पठाए र भने, “म र मेरा मानिसहरूबाट भ्यागुताहरू लैजाऊन् भनी परमप्रभुलाई बिन्ती चढाओ । तब म उहाँलाई बलिदान चढाउन तेरा मानिसहरूलाई जान दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशाले फारोलाई भने, “तपाईं, तपाईंका अधिकारीहरू र तपाईंका मानिसहरूका लागि मैले कहिले बिन्ती गर्ने भनी तपाईंले मलाई आज्ञा दिन सक्‍नुहुन्छ ताकि तपाईं र तपाईंका घरहरूबाट भ्यागुताहरूलाई हटाई ती नदीमा मात्र हुन सकून् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फारोले भने, “भोलि ।” मोशाले भने, “तपाईंले भन्‍नुभएझैँ होस् अनि परमप्रभु हाम्रा परमेश्‍वरजस्तै कोही रहेनछ भनी तपाईंले थाहा पाउनुभएको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","भ्यागुताहरू तपाईं, तपाईंका घरहरू, तपाईंका अधिकारीहरू र तपाईंका मानिसहरूबाट जानेछन् । ती नदीमा मात्र बस्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मोशा र हारून फारोकहाँबाट गए । तब परमप्रभुले फारोकहाँ ल्याउनुभएका भ्यागुताहरूको बारेमा मोशाले उहाँलाई पुकारा गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","मोशाले बिन्ती गरेजस्तै परमप्रभुले गर्नुभयो अर्थात् भ्यागुताहरू घरहरू, चोकहरू र खेतहरूमा मरे । ");
INSERT INTO npiulb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","मानिसहरूले तिनलाई जम्मा गरी थुप्रो लगाए र ती गन्हाउन लागे । ");
INSERT INTO npiulb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","तर शान्त भएको देखेपछि परमप्रभुले भन्‍नुभएझैँ फारोले आफ्नो ह्रदय कठोर पारे अनि मोशा र हारूनको कुरा सुनेनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","परमप्रभुले मोशालाई भन्‍नुभयो, “हारूनलाई भन्, 'तपाईंको लट्ठी पसारेर जमिनको धुलोमा प्रहार गर्नुहोस् ताकि यो मिश्र देशभरि भुसुना बनोस्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","तिनीहरूले त्यसै गरे । हारूनले लट्ठी लिएर आफ्नो हात पसारे । तिनले जमिनको धुलोमा प्रहार गरे । भुसुनाहरू मानिस र पशुहरूमा आए । सारा मिश्र देशभरि जमिनको धुलो भुसुनै-भुसुना भए । ");
INSERT INTO npiulb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","जादुगरहरूले पनि तिनीहरूका जादुद्वारा भुसुनाहरू ल्याउन खोजे तर तिनीहरूले सकेनन् । मानिस र पशुहरूमा भुसुनाहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","तब जादुगरहरूले फारोलाई भने, “यसमा परमेश्‍वरको हात छ ।” तर फारोको ह्रदय कठोर भयो र तिनले तिनीहरूका कुरा सुनेनन् । परमप्रभुले भन्‍नुभएझैँ भयो । ");
INSERT INTO npiulb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","परमप्रभुले मोशालाई भन्‍नुभयो, “बिहान सबेरै उठेर फारो नदीतिर जान लाग्दा त्यसको अगि खडा भएर भन्, 'परमप्रभु यसो भन्‍नुहुन्छः मलाई आराधना चढाउनलाई मेरा मानिसहरूलाई जान दे । ");
INSERT INTO npiulb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","तैँले मेरा मानिसहरूलाई जान दिइनस् भने म तँ, तेरा अधिकारीहरू, तेरा मानिसहरू र तेरा घरहरूमा हुलका हुल झिँगाहरू पठाउनेछु । मिश्रीहरूका घरहरू मात्र नभएर तिनीहरू खडा हुने जमिन पनि झिँगाहरूले भरिनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","तर त्यस दिन म मेरा मानिसहरू बसिरहेका गोशेन प्रदेशलाई चाहिँ फरक तरिकाले व्यवहार गर्नेछु ताकि त्यहाँ झिँगाहरू नहोऊन् । यो देशमा म परमप्रभु हुँ भनी तैँले जानोस् भनी यसो हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","मेरा मानिसहरू र तेरा मानिसहरूका बिचमा म भिन्‍नता ल्याउनेछु । भोलि मेरो शक्तिको यो चिन्ह हुनेछ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","परमप्रभुले त्यसै गर्नुभयो । फारोका घरहरू र तिनका अधिकारीहरूका घरहरूमा हुलका हुल झिँगाहरू आए । मिश्र देशभरि झिँगाहारूले देशलाई सखाप पारे । ");
INSERT INTO npiulb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","फारोले मोशा र हारूनलाई बोलाउन पठाए र भने, “हाम्रो आफ्नै देशमा गएर तिमीहरूका परमेश्‍वरलाई बलिदान चढाउन जाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मोशाले भने, “हामीलाई त्यसो गर्न ठिक हुँदैन किनकि हामीले परमप्रभु हाम्रा परमेश्‍वरलाई चढाउने बलिदान मिश्रीहरूको भन्दा बेग्लै हुनेछ । हामीले मिश्रीहरूलाई घिनलाग्‍ने बलि तिनीहरूकै आँखाको सामुन्‍ने चढायौँ भने के तिनीहरूले हामीमाथि ढुङ्गा बर्साउँदैनन् र? ");
INSERT INTO npiulb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","परमप्रभु हाम्रा परमेश्‍वरले हामीलाई आज्ञा दिनुभएझैँ उहाँलाई बलिदान गर्न हामी तिन दिनको यात्रा गरी उजाड-स्थानमा जानैपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फारोले भने, “परमप्रभु तिमीहरूका परमेश्‍वरलाई उजाड-स्थानमा बलिदान चढाउन जान दिन म अनुमति दिनेछु । तिमीहरू धेरै टाढा भने जानुहुँदैन । मेरो लागि प्रार्थना चढाऊ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशाले भने, “म यहाँबाट जानेबित्तिकै हजुर फारो र हजुरका अधिकारीहरूसाथै मानिसहरूबाट झिँगाका हुलहरू भोलि नै हटून् भनी बिन्ती गर्नेछु । तर परमप्रभुलाई बलिदान चढाउन जान नदिई हाम्रा मानिसहरूलाई तपाईंले छल गर्नुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","मोशा फारोकहाँबाट गए र परमप्रभुलाई बिन्ती चढाए । ");
INSERT INTO npiulb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","मोशाले अनुरोध गरेअनुसार परमप्रभुले गर्नुभयो, र उहाँले फारो, तिनका अधिकारीहरू र तिनका मानिसहरूबाट झिँगाका हुलहरूलाई हटाइदिनुभयो । एउटै पनि बाँकी रहेन । ");
INSERT INTO npiulb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","तर फारोले यस पटक पनि आफ्नो ह्रदय कठोर पारे र तिनले मानिसहरूलाई जान दिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, “फारोकहाँ गएर भन्, 'हिब्रूहरूका परमप्रभु यसो भन्‍नुहुन्छः मेरो आराधना गर्नलाई मेरो मानिसहरूलाई जान दे । ");
INSERT INTO npiulb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","तैँले तिनीहरूलाई जान दिन इन्कार गरिस् र तिनीहरूलाई अझै पनि रोकिस् भने ");
INSERT INTO npiulb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","परमप्रभुको हात खेतहरू, घोडाहरू, गधाहरू, ऊँटहरू, गाईवस्तुहरू र भेडा-बाख्राहरूमाथि पर्नेछ र यसले डरलाग्दो रोग उत्पन्‍न गराउनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","परमप्रभुले इस्राएलका गाईवस्तु र मिश्रका गाईवस्तु छुट्‌ट्याउनेहुनेछ र इस्राएलीहरूको कुनै पनि गाईवस्तु मर्नेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","परमप्रभुले समय निधो गरिसक्‍नुभएको छ । उहाँले भन्‍नुभएको छ, “भोलि यस देशमा म यो काम गर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","परमप्रभुले अर्को दिन त्यही गर्नुभयो । मिश्रका सबै गाईवस्तु मरे, तर इस्राएलीहरूका पशुहरू भने जीवितै रहे, एउटै पनि मरेन । ");
INSERT INTO npiulb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोले अनुसन्धान गर्दा इस्राएलीहरूका एउटै पनि पशु नमेरोको पाए । तर तिनको ह्रदय हठी भयो, त्यसैले तिनले मानिसहरूलाई जान दिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","तब परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, “भट्टीबाट मुट्ठीभर खरानी लेओ । तँ मोशाले फारोले हेरिरहँदा त्यस खरानीलाई आकाशमा फ्याँक्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ती मिश्र देशभरि मसिनो धुलो बन्‍नेछन् । तिनले मिश्र देशका सबै मानिस र पशुहरूमा फोका र खटिरा ल्याउनेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","त्यसैले मोशा र हारूनले भट्टीबाट खरानी लिएर फारोको सामुन्‍ने खडा भए । त्यसपछि मोशाले खरानीलाई हावामा फ्याँके । खरानीले मानिस र पशुहरूमा फोका र खटिरा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","फोकाको कारणले जादुगरहरूले मोशाको विरोध गर्न सकेनन् । किनकि फोका सबै मिश्रीमाथि आइपरेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","परमप्रभुले फारोको ह्रदय कठोर पारिदिनुभयो । त्यसैले फारोले मोशा र हारूनको कुरा सुनेनन् । फारोले मोशाको कुरा सुन्‍नेथिएन भनी परमप्रभुले भन्‍नुभएझैँ भयो । ");
INSERT INTO npiulb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, “बिहान सबेरै उठेर फारोको सामुन्‍ने खडा हो र त्यसलाई भन्, 'हिब्रूहरूका परमप्रभु परमेश्‍वर यसो भन्‍नुहुन्छः मेरो आराधना गर्न मेरा मानिसहरूलाई जान दे । ");
INSERT INTO npiulb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","किनकि यो पटक तँ, तेरा अधिकारीहरू र तेरा मानिसहरूमाथि म मेरा सबै विपत्ति ल्याउनेछु । सारा पृथ्वीमा मजस्तो कोही रहेनछ भनी तैँले जान् भनी म यसो गर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","यति बेलासम्म त मैले मेरो हात पसारेर तँ र तेरा मानिसहरूलाई रोगले आक्रमण गरेको भए तँ यस धरतीबाट मटिनेथिइस् । ");
INSERT INTO npiulb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","मेरो नाउँ सारा पृथ्वीभरि घोषणा हुन सकोस् भनेर मेरो शक्ति देखाउनलाई मैले तँलाई जीवित रहने अनुमति दिएँ । ");
INSERT INTO npiulb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","मेरा मानिसहरूलाई जान नदिएर तैँले अझै पनि आफूलाई उचालिरहेको छस् । ");
INSERT INTO npiulb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","सुन्! भोलि यसै बेलातिर म निकै शक्तिशाली असिना बर्साउनेछु जुन मिश्र सुरु भएदेखि आजको दिनसम्म बर्सिएको छैन । ");
INSERT INTO npiulb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","अब मानिसहरू पठाएर तेरा खेतहरूमा भएका तेरा गाईवस्तु र हरेक जे-जति छन् तिनलाई सुरक्षित स्थानमा जम्मा गर् । खेतमा भएका र घरमा नल्याइएका हरेक मानिस र पशुमाथि असिना बर्सनेछ र तिनीहरू मर्नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","परमप्रभुको सन्देशमा विश्‍वास गर्ने फारोका अधिकारीहरूले दासदासीहरू र गाईवस्तुहरूलाई घरहरूमा हुल्न हतार गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","तर परमप्रभुको सन्देशलाई गम्भीरतापूर्वक नलिनेहरूले तिनीहरूका दासदासीहरू र गाईवस्तुहरूलाई खेतहरूमा छाडिदिए । ");
INSERT INTO npiulb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","तब परमप्रभुले मोशालाई भन्‍नुभयो, “तेरो हात आकाशमाथि पसार् ताकि मिश्र देशमा असिना बर्सोस् । ती मिश्र देशभरिका मानिसहरू, पशुहरू खेतमा भएका सबै बोट-बिरुवामा बर्सून् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","मोशाले आफ्नो लट्ठी आकाशतिर पसारे र परमप्रभुले जमिनमा गर्जन, असिना र बिजुली पठाइदिनुभयो । उहाँले मिश्र देशमा असिना बर्साइदिनुभयो । बिजुलीसँगै असिना मिसिएर आएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","यो यति डरलाग्दो थियो कि मिश्र राज्य भएदेखि त्यस देशमा यस्तो कहिल्यै भएको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","मिश्र देशभरि असिनाले खेतमा भएका हरेक कुरासाथै मानिस र पशुहरू दुवैलाई प्रहार गर्‍यो । यसले खेतहरूमा भएको हरेक बोट-बिरुवालाई प्रहार गर्नुका साथै हरेक रुख भाँचिदियो । ");
INSERT INTO npiulb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","इस्राएलीहरू बसेको गोशेन प्रदेशमा मात्र असिना परेको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","त्यसपछि फारोले मोशा र हारूनलाई बोलाउन मानिसहरू पठाए । तिनले तिनीहरूलाई भने, “यस पटक मैले पाप गरेको छु । परमप्रभु धर्मी हुनुहुन्छ अनि म र मेरा मानिसहरू दुष्‍ट छौँ । ");
INSERT INTO npiulb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","परमप्रभुलाई बिन्ती चढाऊ किनकि शक्‍तिशाली गर्जन र असिना अति भएका छन् । म तिमीहरूलाई जान दिनेछु र अब उसो तिमीहरू यहाँ बस्‍नुपर्नेछैन ।” ");
INSERT INTO npiulb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशाले तिनलाई भने, “मैले सहर छाड्ने बित्तिकै म मेरो हात परमप्रभुतिर फैलाउनेछु । गर्जन रोकिनेछ र अब उसो असिना पर्नेछैन । यसरी पृथ्वी परमप्रभुको हो रहेछ भनी तपाईंले थाहा पाउनुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तर तपाईं र तपाईंका अधिकारीहरूको सवालमा तपाईंहरूले वास्तवमा परमप्रभुलाई आदर गर्नुहुन्‍न भनी म जान्दछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","अब सनपाट र जौ नष्‍ट भए किनकि जौमा बाला लागेको थियो र सनपाटचाहिँ फुलिसकेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","तर गहुँ र कठियागहुँलाई हानि भएन किनकि ती पछि पाक्छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","जब मोशाले फारो र सहरलाई छाडे तिनले आफ्ना हात परमप्रभुतिर फैलाए । गर्जन र असिना रोकिए अनि पानी पर्न छाड्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","वर्षा, असिना र गर्जन रोकिएको देखेपछि फारोले फेरि पाप गरे र तिनले आफ्नो ह्रदय कठोर पारे र तिनका अधिकारीहरूले पनि त्यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","फारोको ह्रदय कठोर भयो । त्यसैले तिनले इस्राएलका मानिसहरूलाई जान दिएनन् । फारोले यसै गर्नेथिए भनी परमप्रभुले मोशालाई भन्‍नुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, “फारोकहाँ जा किनकि मैले त्यसको र त्यसका अधिकारीहरूका ह्रदय कठोर बनाइदिएको छु । तिनीहरूका बिचमा मेरो शक्तिका यी चिन्हहरू देखाउनलाई मैले यसो गरेको हुँ । ");
INSERT INTO npiulb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","मैले गरेका कुराहरू, मैले मिश्रलाई कसरी कठोरतापूर्वक व्यवहार गरेँ र तिनीहरूका बिचमा मेरो शक्तिका विभिन्‍न चिन्हहरू कसरी देखाएँ भनी तैँले तेरा छोराछोरीहरू र नातिनातिनाहरूलाई बताउनेछस् भनेर पनि मैले यसो गरेको हुँ । यसरी म परमप्रभु हुँ भनी तैँले जान्‍नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","त्यसैले मोशा र हारून फारोकहाँ गए र भने, “हिब्रूहरूका परमप्रभु परमेश्‍वर यसो भन्‍नुहुन्छः मेरो सामु आफैलाई विनम्र पार्न कहिलेसम्म अस्वीकार गर्छस्? मेरो आराधना गर्न मेरा मानिसहरूलाई जान दे । ");
INSERT INTO npiulb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","तैँले मेरा मानिसहरूलाई जान दिन इन्कार गरिस् भने सुन्, भोलि म तेरो देशमा सलहहरू ल्याउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","कसैले जमिनलाई देख्‍न नसक्‍ने गरी तिनीहरूले भुइँलाई ढाक्‍नेछन् । असिनाबाट बचेर रहेका कुनै पनि चिज तिनीहरूले खाइदिनेछन् । खेतमा उम्रने हरेक रुखलाई पनि तिनीहरूले खाइदिनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","तिनीहरू तेरा, तेरा सबै अधिकारीसाथै सबै मिश्रीका घरहरूमा भरिनेछन् । यस्तो तिमीहरूका बुबा र हजुर बुबाहरूले पृथ्वीको स्थापना भएदेखि आजको दिनसम्म कहिल्यै देखेका छैनन्' ।” त्यसपछि मोशा फारोकहाँबाट निस्केर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोका अधिकारीहरूले तिनलाई भने, “कहिलेसम्म यो मानिसले हामीलाई धम्की दिने? तिनीहरूका परमप्रभु परमेश्‍वरलाई आराधना गर्न इस्राएलीहरूलाई जान दिनुहोस् । मिश्र नष्‍ट भएको के हजुरले देख्‍नुभएको छैन र?” ");
INSERT INTO npiulb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","मोशा र हारून फेरि पनि फारोकहाँ ल्याइए । फारोले तिनीहरूलाई भने, “तिमीहरूका परमप्रभु परमेश्‍वरको आराधना गर्न जाओ । तर जानेहरूचाहिँ को-को हुनेछन्?” ");
INSERT INTO npiulb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशाले भने, “हामी हाम्रा छोराछोरीहरू, बुढाबुढीहरू लिएर जानेछौँ । हामीले हाम्रा गाईवस्तु र भेडा-बाख्राहरू लिएर जानेछौँ किनकि हामीले परमप्रभुको निम्ति चाड मनाउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फारोले तिनीहरूलाई भने, “मैले तिमीहरू र तिमीहरूका सन्तानहरूलाई जान दिएँ भने वास्तवमा परमप्रभु तिमीहरूसँगै होऊन् । हेर, तिमीहरूको मनमा कुनै दुष्‍टता छ । ");
INSERT INTO npiulb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","तिमीहरूमा बिचमा भएका पुरुषहरू मात्र गएर परमप्रभुको आराधना गरून् किनकि तिमीहरूले चाहेको यही नै हो ।” त्यसपछि मोशा र हारूनलाई फारोको उपस्थितिबाट हटाइयो । ");
INSERT INTO npiulb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","तब परमप्रभुले मोशालाई भन्‍नुभयो, “सलहहरू मिश्र देशमा आऊन् भनी तेरो हात पसार् । असिनाको आक्रमणबाट बाँकी रहेका मिश्र देशका हरेक थोकमाथि तिनीहरूले आक्रमण गरून् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मोशाले आफ्नो लट्ठी मिश्र देशमाथि पसारे अनि परमप्रभुले दिनरात समस्त देशमा पूर्वीय बतास चलाइदिनुभयो । बिहान हुँदा पूर्वीय बतासले सलहहरू ल्याएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","सलहहरू मिश्र देशभरि गए र यसका सबै भू-भागमा हुल-हुल भएर बसे । त्यस देशमा सलहहरूको यस्तो हुल कहिल्यै देखा परेको थिएन र यसपछि पनि यस्तो कहिल्यै हुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","पुरै अन्धकार हुने गरी तिनीहरूले पुरै देशको सतहलाई ढाके । असिनाले नष्‍ट गरेर छाडेका रुखहरूका सबै फल र खेतका सबै बोट-बिरुवा तिनीहरूले खाइदिए । मिश्र देशभरि कुनै जीवित हरियो बिरुवा बाँकी रहेन न त खेतमा नै कुनै रुख-बिरुवा बाँकी रह्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","त्यसपछि फारोले झट्टै मोशा र हारूनलाई डाक्‍न पठाए र भने, “मैले तिमीहरूका परमेश्‍वर र तिमीहरूको विरुद्धमा पाप गरेको छु । ");
INSERT INTO npiulb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अब यस पल्ट मेरो पाप क्षमा गरिदेऊ र मबाट यस मृत्युलाई लगियोस् भनी तिमीहरूका परमप्रभु परमेश्‍वरसित बिन्ती चढाइदेओ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","त्यसैले मोशा फारोकहाँबाट गए र परमप्रभुलाई बिन्ती चढाए । ");
INSERT INTO npiulb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","परमप्रभुले निकै शक्तिशाली पश्‍चिमी बतास चलाइदिनुभयो जसले सलहहरूलाई उडाई लाल समुद्रमा लग्यो । मिश्रका इलाकाभित्र एउटै पनि सलह रहेन । ");
INSERT INTO npiulb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तर परमप्रभुले फारोको ह्रदय कठोर बनाइदिनुभयो र तिनले इस्राएलीहरूलाई जान दिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, “आकाशतिर तेरो हात पसार् अनि मिश्र देशभरि महसुस गर्न सकिने अन्धकार होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","मोशाले आफ्नो हात आकाशतिर पसारे र मिश्र देशभरि तिन दिनसम्म निस्पट्ट अन्धकार छायो । ");
INSERT INTO npiulb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","कसैले कसैलाई देख्‍न सक्दैनथ्यो । तिन दिनसम्म कोही पनि आफ्नो घरबाहिर निस्केन । तर सबै इस्राएली बसेको ठाउँमा भने उज्यालै थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","फारोले मोशालाई बोलाउन पठाए र भने, “गएर परमप्रभुको आराधना गर । तिमीहरूका परिवारहरू पनि तिमीहरूसँगै जान सक्‍नेछन्, तर तिमीहरूका गाईवस्तु र भेडा-बाख्राहरूलाई भने यहीँ छाड ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","तर मोशाले भने, “हाम्रा परमप्रभु परमेश्‍वरलाई बलिदान चढाउन तपाईंले हामीलाई बलिदान र होमबलिको निम्ति पशुहरू पनि दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","हाम्रा गाईवस्तु पनि हामीसितै जानुपर्छ । तिनीहरूका खुर पनि छोडिनुहुँदैन किनकि हाम्रा परमप्रभु परमेश्‍वरको आराधना गर्न हामीले तिनलाई लैजानैपर्छ । किनकि हामी त्यहाँ नपुगेसम्म हामीले परमप्रभुलाई के-के चढाएर आराधना गर्ने भनी हामीलाई थाहा हुँदैन ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","तर परमप्रभुले फारोको ह्रदय कठोर पारिदिनुभयो र तिनले तिनीहरूलाई जान दिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फारोले मोशालाई भने, “मबाट जाऊ! एउटा कुराको बारेमा होसियार होऊ । अबदेखि मेरो सामु देख नपर किनकि मेरो अनुहार देखेको दिनमा तिमी मर्नेछौ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशाले भने, “तपाईंले भन्‍नुभएझैँ होस् । म फेरि तपाईंको अनुहार हेर्नेछैनँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, “फारो र मिश्रमा मैले ल्याउने एउटा विपत्ति अझै पनि बाँकी छ । त्यसपछि त्यसले तिमीहरूलाई यहाँबाट जान दिनेछ । अन्त्यमा त्यसले तिमीहरूलाई जान दिँदा त्यसले तिमीहरूलाई पूर्ण रूपमा निकालिदिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","हरेक पुरुष र स्‍त्रीले तिनीहरूका छिमेकीहरूबाट चाँदी र सरसामानहरू माग्‍न तिनीहरूलाई निर्देशन दे ।” ");
INSERT INTO npiulb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","अब परमप्रभुले मिश्रीहरूलाई इस्राएलीहरूलाई खुसी तुल्याउन उत्सुक बनाइदिनुभयो । यसको अतिरिक्त, यी मानिस मोशा फारोका अधिकारीहरू र मिश्रका मानिसहरूका दृष्‍टिमा प्रभावशाली बने । ");
INSERT INTO npiulb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मोशाले भने, “परमप्रभु यसो भन्‍नुहुन्छः मध्यराततिर म मिश्र भएर जानेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","मिश्र देशमा सिंहासनमा बस्‍ने फारोको जेठो छोरोदेखि लिएर जाँतो पिँध्‍ने दासीको जेठो छोरोसम्म र गाईवस्तुका सबै पहिले जन्मेकाहरू मर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","त्यसपछि मिश्र देशमा पहिले कहिल्यै नसुनिएको र फेरि पछि कहिल्यै नसुनिने ठुलो रुवाबासी हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","तर इस्राएलका मानिस र पशुको विरुद्धमा भने एउटा कुकुर पनि भुक्‍नेछैन । यसरी मैले मिश्रीहरू र इस्राएलीहरूलाई फरक तरिकाले व्यवहार गर्दै छु भनी तैँले जान्‍नेछस् । ");
INSERT INTO npiulb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","फारोका सबै अधिकारी मकहाँ आई मेरो सामु निहुरिनेछन् । तिनीहरूले भन्‍नेछन्, 'तपाईंको पछि लाग्‍ने सबै मानिस जाऊन् ।' त्यसपछि म जानेछु ।” तब तिनी फारोकहाँबाट अति क्रोधित भएर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","परमप्रभुले मोशालाई भन्‍नुभयो, “फारोले तेरो कुरा सुन्‍नेछैन । मैले मिश्र देशमा धेरै अचम्मका कामहरू गर्न सकूँ भनेर यसो भएको हो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशा र हारूनले फारोको सामु यी सबै अचम्मका काम गरे । तर परमप्रभुले फारोको ह्रदय कठोर पारिदिनुभयो र तिनले आफ्नो देशबाट इस्राएलका मानिसहरूलाई जान दिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","परमप्रभु मिश्र देशमा मोशा र हारूनसित बोल्नुभयो । उहाँले भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“तिमीहरूका लागि यो महिनाहरूको सुरु हुनेछ । यो महिना तिमीहरूका लागि वर्षको पहिलो महिन हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएलको समुदायलाई भन्, 'यो महिनाको दसौँ दिनमा हरेक परिवारले हरेक घरानाको लागि एउटा-एउटा पाठो ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","एउटा पाठोको लागि घराना ज्यादै सानो भएमा त्यो घराना र नजिकैको छिमेकी मिलेर एउटा थुमा वा पाठो ल्याउनुपर्छ जुन ती मानिसहरूको सङ्ख्याको लागि पर्याप्‍त हुनेछ । हरेकलाई खानको लागि यो पर्याप्‍त हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","त्यसैले सबैलाई खुवाउन तिनीहरूले पर्याप्‍त मासु तयार गर्नुपर्छ । तिमीहरूको थुमा वा पाठो खोटरहित हुनुपर्छ र यो एक वर्षको हुनुपर्छ । तिमीहरूले भेडा वा बाख्राहरूबाट त्यो लिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","तिमीहरूले यसलाई त्यो महिनाको चौधौँ दिनसम्म राख्‍नुपर्छ । त्यसपछि इस्राएलको सारा समुदायले यी पशुहरूलाई साँझमा मार्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","जुन-जुन घरमा त्यो मासु खाइन्छ, त्यहाँ तिमीहरूले केही रगत लिई घरको ढोकाको चौकोसका दुईपट्टिका खम्बाहरू र माथिल्लो भागमा लगाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","त्यस रात तिमीहरूले आगोमा पोलेर त्यो मासु खानू । तितो सागसित खमिर नहालेको रोटीसितै तिमीहरूले त्यो खानू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","काँचो वा पानीमा उमालेर नखाओ । बरु, यसको टाउको, यसका खुट्टा र भित्री भागहरूसमेत आगोमा पोलेर खाओ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","बिहानसम्ममा कुनै पनि भाग नउबार्नू । बिहानसम्म केही उब्रियो भने त्यसलाई जलाइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","पटुका कसेर, खुट्टामा जुत्ता लगाएर र हातमा लट्ठी बोकेर तिमीहरूले खानू । तिमीहरूले हतारसँग खानुपर्छ । यो परमप्रभुको निस्तार-चाड हो । ");
INSERT INTO npiulb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","परमप्रभु भन्‍नुहुन्छः म त्यस रात मिश्र देश भएर जानेछु र मिश्र देशका मानिस र गाईवस्तुका सबै पहिले जन्मेकाहरूलाई आक्रमण गर्नेछु । म मिश्रका सबै देवी-देवतालाई दण्ड दिनेछु । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","म तिमीहरूकहाँ आउँदा रगत तिमीहरूको घरमा चिन्ह हुनेछ । मैले रगत देखेपछि मैले मिश्र देशमा आक्रमण गर्दा तिमीहरूलाई छाडिदिनेछु । यो विपत्तिले तिमीहरूलाई नाश गर्नेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","यो दिन तिमीहरूका लागि सम्झनाको दिन हुनेछ र यसलाई तिमीहरूले परमप्रभुको निम्ति चाडको रूपमा मान्‍नू । तिमीहरूको पुस्तौँसम्म रहिरहने विधिको रूपमा यसलाई तिमीहरूले सधैँ मान्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","सात दिनसम्म तिमीहरूले खमिर नहालेको रोटी खानू । पहिलो दिनमा तिमीहरूले आ-आफ्ना घरहरूबाट खमिर हटाउनू । पहिलो दिनदेखि सातौँ दिनसम्म खमिर हालेको रोटी खाने मान्छे जोसुकैलाई पनि तिमीहरूले इस्राएलबाट बहिष्कार गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहिलो दिनमा मेरो लागि अलग गरिएको समुदाय भेला होस् र सातौँ दिनमा पनि यस्तै भेला होस् । यी दिनमा कुनै पनि काम गरिनेछैन । तिमीहरूले केवल खानको लागि पकाउने काम गर्नू । तिमीहरूले गर्न सक्‍ने काम यही मात्र हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","तिमीहरूले यो अखमिरी रोटीको चाड मान्‍नैपर्छ किनकि यही दिनमा नै मैले तिमीहरूका सशत्र मानिसहरूलाई दल-दल गरी मिश्र देशबाट ल्याएको हुनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","तिमीहरूले यसलाई पुस्तौँसम्म मान्‍नू । यो तिमीहरूका निम्ति सधैँ एउटा विधि हुनेछ । वर्षको पहिलो महिनाको चौधौँ दिनको साँझदेखि त्यस महिनाको एक्‍काइसौँ दिनको साँझसम्म तिमीहरूले अखमिरी रोटी खानू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","यी सात दिनमा तिमीहरूका घरहरूमा कुनै खमिर पाइनुहुँदैन । खमिर हालेको रोटी खाने जोसुकै इस्राएलको समुदायबाट बहिष्कृत हुनेछ, चाहे त्यो व्यक्ति विदेशी होस् या तिमीहरूकै देशमा जन्मेको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","खमिरबाट बनेको कुनै पनि थोक तिमीहरूले नखानू । तिमीहरू जहाँ बसे तापनि तिमीहरूले खमिर नहालेको रोटी मात्र खानू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मोशाले इस्राएलका सबै धर्म-गुरुलाई बोलाउन पठाएर भने, “गएर आ-आफ्नो परिवारको लागि पर्याप्‍त हुने गरी थुमा वा पाठो छनौट गरेर त्यसलाई निस्तार-चाडको लागि मार । ");
INSERT INTO npiulb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","त्यसपछि हिसपको झुप्पा लिई भाँडोभित्र भएको रगतमा चोप । ढोकाको माथिल्लो भाग र दुईवटै चौकोसमा त्यसलाई छ्याप्‍नू । बिहान नभएसम्म कोही पनि आफ्नो घरको ढोकाबाहिर नजानू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","किनकि मिश्रीहरूलाई प्रहार गर्न परमप्रभु यो देश भएर जानुहुनेछ । जब उहाँले ढोकाको माथिल्लो भाग र दुईवटै चौकोसमा रगत देख्‍नुहुनेछ तब उहाँले तिमीहरूको ढोकालाई छाडिदिनुहुनेछ र विनाश गर्नेलाई तिमीहरूलाई प्रहार गर्न तिमीहरूका घरहरूमा आउन अनुमति दिनुहुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","तिमीहरूले यस घटनालाई मान्‍नुपर्छ । यो तिमीहरू र तिमीहरूका सन्तानको लागि सदाको निम्ति एउटा विधि हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","परमप्रभुले तिमीहरूलाई प्रतिज्ञा गर्नुभएझैँ उहाँले तिमीहरूलाई दिनुहुने देशमा तिमीहरू प्रवेश गर्दा तिमीहरूले यो आराधनाको कामलाई मान्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","तिमीहरूका छोराछोरीहरूले 'यो आराधनाको कामको अर्थ के हो?' भनी सोध्दा ");
INSERT INTO npiulb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तिमीहरूले जवाफ दिनू, “यो परमप्रभुको निस्तार-चाडको बलिदान हो किनकि परमप्रभुले मिश्रमा मिश्रीहरूलाई प्रहार गर्नुहुँदा इस्राएलीहरूका घरलाई छाडिदिनुभएको थियो । उहाँले हाम्रा घरानाहरूलाई मुक्त गरिदिनुभयो' ।” त्यसपछि मानिसहरूले शिर निहुराई परमप्रभुको आराधना गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","इस्राएलीहरू गए र परमप्रभुले मोशा र हारूनलाई आज्ञा गर्नुभएझैँ तिनीहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मध्यरातमा परमप्रभुले मिश्र देशमा सिंहासनमा बस्‍ने फारोको जेठो छोरोदेखि लिएर झ्यालखानामा बस्‍ने व्यक्तिको जेठो छोरोसम्म र गाईवस्तुका सबै पहिले जन्मेकाहरूलाई प्रहार गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","फारो, तिनका सबै अधिकारी र सबै मिश्रीहरू रातमा उठे । मिश्रमा ठुलो रुवाबासी भएको थियो किनकि मान्छे नमेरको कुनै घर थिएन । ");
INSERT INTO npiulb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","रातमा फारोले मोशा र हारूनलाई बोलाउन पठाए र भने, “उठ, तिमी र इस्राएलीहरू मेरा मानिसहरूका बिचबाट निस्केर जाओ । तिमीहरूले चाहेजस्तै गएर परमप्रभुको आराधना चढाओ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","तिमीहरूले भनेजस्तै तिमीहरूका गाईवस्तु र भेडा-बाख्राहरू लिएर जाओ र मलाई पनि आशिष् देओ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","तिनीहरूलाई बाहिर पठाउन मिश्रीहरू निकै हतारमा थिए किनकि तिनीहरूले भने, “हामी सबै मर्नेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","त्यसैले मानिसहरूले खमिर नमिसाइएको मुछेको पिठोको डल्लो लिए । तिनीहरूका मुछ्ने आह्रीहरू पहिले तिनीहरूका लुगा र तिनीहरूका कुममा बाँधिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","अब इस्राएलका मानिसहरूले मोशाले भनेझैँ गरे । तिनीहरूले मिश्रीहरूबाट चाँदी, सुनका वस्तुहरूसाथै लुगाहरू मागे । ");
INSERT INTO npiulb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","परमप्रभुले मिश्रीहरूलाई इस्राएलीहरूलाई खुसी तुल्याउन उत्सुक तुल्याइदिनुभएको थियो । त्यसैले इस्राएलीहरूले जे मागे तापनि मिश्रीहरूले दिए । यसरी इस्राएलीहरूले मिश्रीहरूलाई लुटे । ");
INSERT INTO npiulb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएलीहरूले रामसेसबाट सुक्‍कोतमा यात्रा गरे । स्‍त्री र केटाकेटीहरूबाहेक पैदल हिँड्ने तिनीहरूको सङ्ख्या करिब ६,००,००० थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","तिनीहरूका साथमा अन्य धेरै मानिस अनि गाईवस्तु र भेडा-बाख्रा पनि थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","तिनीहरूले मिश्रबाट ल्याएका पिठोको डल्लोबाट अखमिरी रोटी बनाए । यो खमिरविनाको थियो किनकि तिनीहरू मिश्रबाट धपाइएका थिए र खाना तयार गर्न तिनीहरूको लागि समय थिएन । ");
INSERT INTO npiulb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएलीहरू मिश्रमा ४३० वर्षसम्म बसेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","४३० वर्षको अन्तिम दिनमा परमप्रभुका सबै सशस्‍त्र दलहरू मिश्र देशबाट बाहिरिए । ");
INSERT INTO npiulb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","यो जागा रहनुपर्ने रात थियो किनकि परमप्रभुले तिनीहरूलाई मिश्र देशबाट रातमा बाहिर निकालेर ल्याउनुभएको थियो । यो इस्राएलीहरूको पुस्तौँसम्म तिनीहरूले पालन गर्नुपर्ने परमप्रभुको रात थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, “निस्तार-चाडको नियम यस्तो छः यसमा कुनै पनि परदेशीले भाग नलिओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","तर दाम तिरेर किनिएको हरेक इस्राएली दासको खतना गरिएपछि त्यसले यो खान सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","विदेशीहरू र भाडामा लिइएका नोकरहरूले यो खानाको कुनै पनि भाग नखानू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","एउटै घरमा यसलाई खाइनुपर्छ । तिमीहरूले घरबाट कुनै पनि खाना बाहिर नलैजानू र यसको कुनै पनि हड्‍डी नभाँच्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएलका सारा समुदायले यसको पालन गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","कुनै परदेशी तिमीहरूका बिचमा बसेको छ र त्यसले परमप्रभुको निम्ति निस्तार-चाड मान्‍न चाहन्छ भने त्यसका सबै पुरुष नातेदारहरूको खतना गरिनुपर्छ । त्यसपछि मात्र त्यसले यो चाड मान्‍न पाउँछ । त्यो देशमै जन्मेका मानिसहरूजस्तै एक हुनेछ । तर बेखतने व्यक्तिले यसबाट खान पाउनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","स्वदेशी र तिमीहरूका बिचमा बसोबास गर्ने परदेशी दुवैलाई उही नियम लागु हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","त्यसैले परमप्रभुले मोशा र हारूनलाई आज्ञा गर्नुभएझैँ सबै इस्राएलीले त्यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ठिक त्यही दिन परमप्रभुले तिनीहरूका सशस्‍त्र दलहरूलाई मिश्र देशबाट बाहिर निकालेर ल्याउनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इस्राएलीहरूमध्येका मानिस र पशुहरू दुवैबाट पहिले जन्मेका सबै नरलाई मेरो निम्ति अलग गर् । पहिले जन्मेकाहरू मेरा हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मोशाले मानिसहरूलाई भने, “आजको दिन सम्झना राख । आजकै दिन परमप्रभुको शक्तिशाली हातद्वारा तिमीहरू मिश्रको दासत्वबाट यस ठाउँमा ल्याइएका छौ । खमिर हालेको कुनै पनि रोटी खाइनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","तिमीहरू आबीब महिनाको आजकै दिनमा मिश्रबाट बाहिर जाँदै छौ । ");
INSERT INTO npiulb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","परमप्रभुले तिमीहरूलाई कनानी, हित्ती, एमोरी, हिव्वी र यबूसीहरूको दूध र मह बग्‍ने देशमा लैजानुहुँदा तिमीहरूले यही महिनामा आराधनाको यो चाड मान्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिनसम्म तिमीहरूले खमिर नहालेको रोटी खानू । सातौँ दिनमा परमप्रभुको निम्ति चाड हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","सात दिनसम्म खमिर नहालेको रोटी खानू । खमिर हालेको रोटी तिमीहरूका बिचमा नदेखियोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","त्यस दिन तिमीहरूले आ-आफ्ना छोराछोरीहरूलाई भन्‍नू, 'म मिश्रबाट बाहिर आउँदा परमप्रभुले मेरो निम्ति जे गर्नुभएको थियो, त्यसैको खातिर मैले यसो गरेको हुँ ।' ");
INSERT INTO npiulb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","यो तिमीहरूका निम्ति हातमा र तिमीहरूको निधारमा सम्झना गराउने कुरो हुनेछ । परमप्रभुको शक्तिशाली हातले तिमीहरूलाई मिश्रबाट बाहिर ल्याएकोले तिमीहरूको मुखमा यो उहाँको विधि हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","त्यसकारण वर्षैपिच्छे तिमीहरूले तोकिएको समयमा यो विधिको पालन गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","परमप्रभुले तिमीहरू र तिमीहरूका पिता-पुर्खाहरूसित शपथ खानुभएझैँ उहाँले तिमीहरूलाई कनानीहरूको देशमा पुर्‍याई त्यो देश तिमीहरूलाई दिनुहुँदा ");
INSERT INTO npiulb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तिमीहरूले हरेकको गर्भको पहिले फल परमप्रभुको निम्ति अलग गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","गधाको हरेक पहिलो फललाई एउटा पाठोद्वारा छुटाउनू । त्यो छुटाएनौ भने त्यसको घाँटी निमोठिदिनू । तर तिमीहरूका सबै छोराका बिचमा पहिलो फललाई तिमीहरूले छुटाउनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","'यसको मतलब के हो?' भनी पछि तिमीहरूको छोरोले सोध्दा तिमीहरूले यसो भन्‍नू, 'परमप्रभुले शक्तिशाली हातद्वारा हामीलाई मिश्रको दासत्वबाट निकालेर ल्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","हठी भएर फारोले हामीलाई जान दिन इन्कार गर्दा परमप्रभुले मिश्र देशमा मानिस र पशु दुवैका सबै पहिले जन्मेकाहरूलाई मार्नुभयो । त्यसकारण म हरेक पशुको पहिले जन्मेको नरलाई परमप्रभुको निम्ति बलिदान चढाउँछु, र मेरा छोराहरूमध्ये जेठोलाई छुटाउँछु ।' ");
INSERT INTO npiulb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यो तिमीहरूको हात र तिमीहरूको निधारमा सम्झना दिलाउने कुरो हुनेछ किनकि परमप्रभुको शक्तिशाली हातद्वारा उहाँले हामीलाई मिश्रबाट बाहिर ल्याउनुभएको थियो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फारोले मानिसहरूलाई जान दिएपछि परमेश्‍वरले तिनीहरूलाई पलिश्तीको देशको बाटो नजिकै भए तापनि त्यहाँबाट भएर अगुवाइ गर्नुभएन । किनकि उहाँले भन्‍नुभयो, “तिनीहरूले लडाइँ देखेर तिनीहरूको मन बद्ली तिनीहरू मिश्रमा नै फर्केर जान सक्छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","त्यसैले परमेश्‍वरले ती मानिसहरूलाई उजाड-स्थानको बाटो भएर लाल समुद्रतिर लैजानुभयो । इस्राएलीहरू युद्धको लागि सशस्‍त्र भई मिश्र देशबाट अगि बढे । ");
INSERT INTO npiulb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशाले योसेफको अस्थि आफूसितै लगे किनकि योसेफले इस्राएलीहरूलाई यसरी गम्भीरतापूर्वक शपथ खान लगाएका थिए, “निश्‍चय नै परमेश्‍वरले तिमीहरूलाई छुटकारा दिनुहुनेछ र तिमीहरूले मेरो अस्थि आफूसितै लैजानू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इस्राएलीहरू सुक्‍कोतबाट यात्रा गरी उजाड-स्थानको नजिकै एथाममा आइपुगे र त्यहाँ तिनीहरूले पाल टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","परमप्रभु दिनमा बादलको खाँबो बनी तिनीहरूको अगिअगि जानुहुन्थ्यो । रातमा आगोको खाँबो बनी उहाँले तिनीहरूलाई ज्योति दिनुहुन्थ्यो । यसरी तिनीहरू दिन र रातमा यात्रा गर्न सक्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","परमप्रभुले दिनमा बादलको खाँबो र रातमा आगोको खाँबो मानिसहरूबाट हटाउनुभएन । ");
INSERT INTO npiulb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलीहरू फर्केर मिग्दोल र समुद्रको बिचमा बाल-सेफोनको अगाडि पी-हहीरोतका सामु पाल टाँगेर बसून् । तिमीहरूले पी-हहीरोतको सामुन्‍ने समुद्रनेर पाल टाँग्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","फारोले इस्राएलीहरूको बारेमा भन्‍नेछन्, “तिनीहरू देशमा भौतारिहरहेका छन् । उजाड-स्थानले तिनीहरूलाई थुनिदिएको छ ।' ");
INSERT INTO npiulb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","म फारोको ह्रदय कठोर बनाउनेछु र त्यसले तिमीहरूको पिछा गर्नेछ । फारो र त्यसका सबै सेनाको कारणले गर्दा मैले आदर पाउनेछु । म नै परमप्रभु हुँ भनी मिश्रीहरूले जान्‍नेछन् ।” इस्राएलीहरूलाई आज्ञा गरिएझैँ तिनीहरूले पाल टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","इस्राएलीहरू भागे भनी जब मिश्रका राजालाई बताइयो फारो र तिनका अधिकारीहरूको मन इस्राएलीहरूको विरुद्धमा फर्कियो । तिनीहरूले भने, “हामीले के गर्‍यौँ? हामीले इस्राएललाई हाम्रो सेवा गर्नबाट छाडिदिएछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","तब फारोले आफ्ना रथहरू तयार पारे र आफ्नो सेना लिएर अगाडि बढे । ");
INSERT INTO npiulb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","तिनले छ सयवटा रोजाइका रथसाथै मिश्रका अन्य सबै रथहरू र तीमाथि अधिकृतहरूलाई लिएर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","परमप्रभुले मिश्रका राजा फारोको ह्रदय कठोर पारिदिनुभएको थियो । त्यसैले राजाले इस्राएलीहरूको पिछा गरे । इस्राएलीहरू विजयका साथ गइसकेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","तर मिश्रीहरूले आफ्ना सबै घोडा, रथ, घोडचढी र सेना लिएर तिनीहरूको पिछा गरे । तिनीहरूले इस्राएलीहरूलाई बाल-सेफोनको अगाडि पी-हहीरोतनेर पाल टाँगेर बसिरहेको भेट्टाए । ");
INSERT INTO npiulb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","जब फारो नजिक आइपुगे इस्राएलीहरूले माथि हेरे र तिनीहरू छक्‍क परे । मिश्रीहरू तिनीहरूको पिछा गर्दै अगाडि बढ्दै थिए । इस्राएलीहरू अत्यन्तै डराए । तिनीहरूले परमप्रभुलाई पुकारे । ");
INSERT INTO npiulb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","तिनीहरूले मोशालाई भने, “के मिश्रमा चिहान नभएकोले तपाईंले हामीलाई यस उजाड-स्थानमा मर्न ल्याएउनुभएको हो? मिश्रबाट बाहिर निकाली किन तपाईंले हामीसित यसरी व्यवहार गर्नुभएको? ");
INSERT INTO npiulb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","के मिश्रमा छँदा नै हामीले यसको भनेका थिएनौँ र? हामीले तपाईंलाई भन्यौँ, 'मिश्रीहरूका निम्ति काम गर्न हामीलाई एक्लै छाडिदिनुहोस् ।' उजाड-स्थानमा मर्नुभन्दा त तिनीहरूकै निम्ति काम गर्नु असल हुनेथियो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशाले मानिसहरूलाई भने, “नडराओ । स्थिर रहो, र आज परमप्रभुले तिमीहरूलाई दिनुहुने छुटकारालाई हेर । किनकि आज तिमीहरूले देखेका यी मिश्रीहरूलाई तिमीहरूले फेरि कहिल्यै देख्‍नेछैनौ । ");
INSERT INTO npiulb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","परमप्रभु तिमीहरूका पक्षमा लड्नुहुनेछ । तिमीहरू केवल स्थिर भएर बस ।” ");
INSERT INTO npiulb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब परमप्रभुले मोशालाई भन्‍नुभयो, “ए मोशा, किन तँ मेरो पुकार गर्दै छस्? इस्राएलीहरूलाई अगाडि बढ्न आज्ञा दे । ");
INSERT INTO npiulb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","तेरो लट्ठी उठाएर तेरो हात समुद्रतिर पसार् र यसलाई दुई भागमा विभाजन गर् ताकि इस्राएलका मानिसहरू सुक्खा भूमिबाट हिँडेर जान सकून् । ");
INSERT INTO npiulb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मिश्रीहरू तिमीहरूका पिछा गरून् भनेर म तिनीहरूका ह्रदय कठोर पारिदिनेछु भन्‍ने कुरामा सचेत हो । फारो र त्यसका सबै सेना, त्यसका रथहरू र त्यसका घोडचढीहरूको कारणले मैले आदर पाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","तब फारो र त्यसका सबै सेना, त्यसका रथहरू र त्यसका घोडचढीहरूको कारणले मैले आदर पाउँदा म नै परमप्रभु हुँ भनी तिनीहरूले जान्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","इस्राएलीहरूको अगिअगि गएका परमेश्‍वरका दूत त्यहाँबाट तिनीहरूका पछिल्तिर सरे । मिश्रको छाउनी र इस्राएलको छाउनीको बिचमा बादल आएर बस्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","यो मिश्रीहरूको लागि अन्धकार बादल थियो जब कि यसले इस्राएलीहरूलाई रातमा प्रकाश दिन्थ्यो । तिनीहरू रातभरि एक-अर्काको नजिक आएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मोशाले समुद्रतिर आफ्नो हात पसारे । परमप्रभुले रातभरि सबैभन्दा शक्तिशाली पूर्वीय बतास चलाइदिनुभयो र समुद्रलाई सुक्खा भूमिमा परिणत गराइदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","इस्राएलीहरू समुद्रको बिचबाट ओबानो भूमिबाट गए । पानीले तिनीहरूको दायाँ र बायाँ खम्बाको रूपमा काम गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","मिश्रीहरूले तिनीहरूको पिछा गरिरहे । फारोका सबै घोडा, रथ र घोडचढीहरू समुद्रको बिचमा तिनीहरूको पछिपछि लागे । ");
INSERT INTO npiulb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","तर बिहानी पखतिर परमप्रभुले आगो र बादलको खाँबोबाट मिश्री सेनालाई हेर्नुभयो । उहाँले मिश्रीहरूका बिचमा अलमल गराइदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","तिनीहरूका रथका पाङ्ग्राहरू फुस्काइदिनुभयो र घोडचढीहरूलाई अगाडि बढ्न मुश्किल भयो । त्यसैले मिश्रीहरूले भने, “हामी इस्राएलबाट भागौँ किनकि परमप्रभु नै तिनीहरूको पक्षमा रही हाम्रो विरुद्धमा लड्दै हुनुहुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","परमप्रभुले मोशालाई भन्‍नुभयो, “पानी मिश्रीहरू, तिनीहरूका रथहरू र तिनीहरूका घोडचढीहरूमाथि आओस् भनेर तेरो हात समुद्रमाथि पसार् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","त्यसैले मोशाले आफ्नो हात समुद्रमाथि पसारे र बिहान हुँदा यो आफ्नो सामान्य मार्गमा आयो । मिश्रीहरू समुद्रमा भागे, र परमप्रभुले मिश्रीहरूलाई समुद्रको बिचमा फ्याँकिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पानी फर्केर आयो र इस्राएलीहरूको पिछा गर्ने फारोका रथ, घोडचढी र तिनका पुरै सेनालाई पानीले ढाकिदियो । कोही पनि बाँचेन । ");
INSERT INTO npiulb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","तर इस्राएलीहरू समुद्रको बिचमा ओबानो भूमिबाट हिँडेर गए । पानी तिनीहरूको दायाँ र बायाँ पर्खालको रूपमा खडा रह्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","यसरी त्यस दिन परमप्रभुले इस्राएललाई मिश्रीहरूको हातबाट बचाउनुभयो, र इस्राएलले समुद्री तटमा मिश्रीहरूका लाशहरू देखे । ");
INSERT INTO npiulb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","परमप्रभुले मिश्रीहरूको विरुद्धमा प्रयोग गर्नुभएको महान् शक्तिलाई जब इस्राएलले देख्यो मानिसहरूले परमप्रभुको आदर गरे, र तिनीहरूले परमप्रभु र उहाँका दास मोशामाथि भरोसा गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मोशा र इस्राएलका मानिसहरूले परमप्रभुको निम्ति यो गीत गाए । तिनीहरूले भने, “म परमप्रभुको निम्ति गाउनेछु किनकि उहाँले महिमामा विजय हासिल गर्नुभएको छ । घोडा र यसको सवारलाई उहाँले समुद्रमा फालिदिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","परमप्रभु मेरो शक्ति र गीत हुनुहुन्छ, र उहाँ मेरा उद्धार हुनुभएको छ । उहाँ मेरा परमेश्‍वर हुनुहुन्छ, र म उहाँको प्रशंसा गर्नेछु । उहाँ मेरा पिता-पुर्खाका परमेश्‍वर हुनुहुन्छ र म उहाँलाई उचाल्छु । ");
INSERT INTO npiulb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमप्रभु मेरा योद्धा हुनुहुन्छ, उहाँको नाउँ परमप्रभु हो । ");
INSERT INTO npiulb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","उहाँले फारोका रथहरू र सेनालाई समुद्रमा फालिदिनुभएको छ । फारोका छानिएका अधिकृतहरू लाल समुद्रमा डुबे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहिराइले तिनीहरूलाई छोप्यो । तिनीहरू पत्थरजस्तै गहिराइमा डुबे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे परमप्रभु, तपाईंको दाहिने बाहुली शक्तिमा महिमित छ । हे परमप्रभु, तपाईंको दाहिने बाहुलीले शत्रुलाई चकनाचुर पारिदिएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","महान् गौरवमा तपाईंले तपाईंको विरुद्धमा उठ्नेहरूलाई तल झारिदिनुभयो । तपाईंले आफ्नो क्रोध पठाउनुभयो । यसले तिनीहरूलाई ठोसालाई झैँ भस्म पार्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तपाईंको नाकको सासले पानीको थुप्रो लाग्यो । बगिरहेको पानी स्थिर भई उभियो । गहिरो पानी समुद्रको मुटुमा जम्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रुले भन्यो, 'म पिछा गर्नेछु; म जित्‍नेछु; म लुटका मालहरू बाँड्नेछु । मेरो इच्छा तिनमा तृप्‍त हुनेछ । म मेरो तरवार थुत्‍नेछु । मेरा हातले तिनीहरूलाई नष्‍ट पार्नेछन् ।' ");
INSERT INTO npiulb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तर तपाईंले आफ्नो बतास चलाइदिनुभयो, र समुद्रले तिनलाई ढाक्यो । तिनीहरू उर्लंदो भेलमा सिसाजस्तै डुबे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे परमप्रभु, देवहरूका बिचमा तपाईंजस्तो को छ र? पवित्रतामा तपाईं वैभवशाली, प्रशंसामा आदरणीय, आश्‍चर्यकर्म गर्नुहुने तपाईंजस्तै को छ र? ");
INSERT INTO npiulb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तपाईंले आफ्नो दाहिले बाहुली पसार्नुभयो, र पृथ्वीले तिनीहरूलाई निल्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तपाईंको करारको बफादारीमा तपाईंले आफूले छुटकारा दिनुभएका मानिसहरूलाई डोर्‍याउनुभएको छ । तपाईंको शक्तिमा तपाईंले तिनीहरूलाई तपाईंको पवित्र वासस्थानमा डोर्‍याउनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","जाति-जातिहरूले सुन्‍नेछन्, र तिनीहरू थरथर काँप्‍नेछन् । त्रासले पलिश्तीहरूका बासिन्दाहरूलाई पक्रनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","तब एदोमका मुखियाहरू डराउनेछन् । मोआबका सिपाहीहरू हल्लिनेछन् । कनानका सबै बासिन्दा पग्लनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","आतङ्क र त्रास उनीहरूमाथि पर्नेछन् । हे परमप्रभु, तपाईंका मानिसहरू पार नहोउञ्‍जेल र तपाईंले छुटकारा दिनुभएका मानिसहरू पार नहोउञ्‍जेल तपाईंको पाखुराको शक्तिको कारणले तिनीहरू पत्थरझैँ अचल रहनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तपाईंले तिनीहरूलाई ल्याउनुहुनेछ, र तिनीहरूलाई तपाईंको उत्तराधिकारको पर्वतमा रोप्‍नुहुनेछ । हे परमप्रभु, यो त्यो ठाउँ हो जहाँ तपाईंले आफ्नो बासस्थान बनाउनुभयो, हे हाम्रा प्रभु जुन पवित्रस्थानलाई तपाईंका हातले बनाएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","परमप्रभुले सदासर्वदा शासन गर्नुहुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","किनकि फारोका घोडाहरू तिनीहरूका रथहरू र घोडचढीहरूसँगै समुद्रमा पुगे । परमप्रभुले तिनीहरूमाथि फेरि समुद्रको पानी फर्काएर ल्याउनुभयो । तर इस्राएलीहरू समुद्रको बिचमा ओबानो भूमिबाट हिँडेर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","हारूनकी दिदी अगमवादिनी मिरियमले खैँजडी लिइन्, र सबै स्‍त्रीले पनि खैँजडी लिँदै उनीसँगै नाचे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरियमले तिनीहरूका निम्ति गाइन्, “परमप्रभुको निम्ति गाओ किनकि उहाँले महिमामा विजय हासिल गर्नुभएको छ । घोडा र यसको सवारलाई उहाँले समुद्रमा फालिदिनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","तब मोशाले इस्राएललाई लाल समुद्रबाट अगाडि लगे । तिनीहरू शूरको उजाड-स्थानमा लागे । तिन दिनसम्म तिनीहरूले उजाड-स्थानमा यात्रा गरे र पानी पाएनन् ");
INSERT INTO npiulb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","। त्यसपछि तिनीहरू मारा भन्‍ने ठाउँमा आइपुगे, तर त्यहाँको पानी तितो भएकोले तिनीहरूले पिउन सकेनन् । त्यसैले तिनीहरूले त्यस ठाउँको नाउँ मारा राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","त्यसकारण मानिसहरूले “हामीले के पिउने?” भनी मोशालाई गनगन गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मोशाले परमप्रभुलाई पुकारा गरे, र उहाँले तिनलाई एउटा बिरुवा देखाइदिनुभयो । मोशाले त्यसलाई पानीमा हाल्दा पानी पिउनलाई मिठो भयो । त्यहीँ नै परमप्रभुले तिनीहरूलाई कडा विधि दिनुभयो, त्यहाँ नै उहाँले तिनीहरूको जाँच गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","उहाँले भन्‍नुभयो, “तिमीहरूले तिमीहरूका परमप्रभु परमेश्‍वरको आवाजलाई होसियारीपूर्वक सुन्यौ, र उहाँको दृष्‍टिमा जे ठिक छ त्यही गर्‍यौ, र तिमीहरूले उहाँका आज्ञाहरूमा ध्यान दियौ र उहाँका विधिहरू पालन गर्‍यौ भने मैले मिश्रीहरूमाथि ल्याएको कुनै पनि विपत्ति तिमीहरूमाथि ल्याउनेछैनँ किनकि म चङ्गाइ गर्ने परमेश्‍वर हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब मानिसहरू एलीममा आइपुगे जहाँ पानीका बार्‍हवटा मुल र सत्तरीवटा खजुरका रुख थिए । तिनीहरूले पानी नजिकै पाल टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","मानिसहरूले एलीमबाट यात्रा थाले र मिश्र देशबाट प्रस्थान गरेको दोस्रो महिनाको पन्ध्रौँ दिनमा इस्राएलीहरूका सारा समुदाय एलीम र सीनै पर्वतको बिचमा पर्ने सीनको उजाड-स्थानमा आइपुगे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","उजाड-स्थानमा इस्राएलीहरूका सारा समुदायले मोशा र हारूनको विरुद्धमा गनगन गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इस्राएलीहरूले तिनीहरूलाई भने, “हामी मासुको भाँडानेर बसेर अघाउञ्‍जेल रोटी खाइरहँदा मिश्र देशमा नै परमप्रभुको हातद्वारा मरेको भए हुनेथियो । किनकि तपाईंहरूले हाम्रो पुरै समुदायलाई भोकले मार्न हामीलाई उजाड-स्थानमा ल्याउनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब परमप्रभुले मोशालाई भन्‍नुभयो, “म तिमीहरूका निम्ति स्वर्गबाट रोटी बर्साउनेछु । तिनीहरू मेरो विधि मान्छन् वा मान्दैनन् भनी जाँच गर्न हरेक दिन एक दिनको भाग जम्मा गर्न मानिसहरू बाहिर जानेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","छैटौँ दिनमा तिनीहरूले पहिले हरेक दिनमा बटुल्ने भन्दा दुई गुणा बटुल्नेछन्, र तिनीहरूले त्यसलाई भित्र ल्याएर पकाउनेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","तब मोशा र हारूनले इस्राएलका सबै मानिसलाई भने, “मिश्र देशबाट तिमीहरूलाई निकालेर ल्याउनुहुने परमप्रभु नै हुनुहुन्छ भनी साँझमा तिमीहरूले थाहा पाउनेछौ । ");
INSERT INTO npiulb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","बिहान तिमीहरूले परमप्रभुको महिमा देख्‍नेछौ किनकि तिमीहरूले उहाँको विरुद्धमा गरेको गनगन उहाँले सुन्‍नुभएको छ । हाम्रो विरुद्धमा गनगन गर्ने तिमीहरूका लागि हामी को हौँ र? ");
INSERT INTO npiulb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मोशाले यसो पनि भने, “तिमीहरूले उहाँको विरुद्धमा गरेको गनगन उहाँले सुन्‍नुभएकोले उहाँले तिमीहरूलाई साँझमा मासु र बिहान रोटी अघाउञ्‍जेल दिनुहुँदा तिमीहरूले यो जान्‍नेछौ । हारून र म को हौँ र? तिमीहरूको गनगन हाम्रा विरुद्धमा नभई परमप्रभुको विरुद्धमा हो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","मोशाले हारूनलाई भने, “इस्राएलका सारा समुदायलाई भन्‍नुहोस्, 'परमप्रभुको नजिक आओ किनकि उहाँले तिमीहरूको गनगन सुन्‍नुभएको छ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","हारून इस्राएलको सारा समुदायसित बोल्दा तिनीहरूले उजाड-स्थानतिर हेरे र परमप्रभुको महिमा बादलमा देखियो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैले इस्राएलका मानिसहरूको गनगन सुनेको छु । तिनीहरूलाई भन्, 'साँझमा तिमीहरूले मासु खानेछौ, र बिहानचाहिँ तिमीहरूले अघाउञ्‍जेल रोटी खानेछौ । तब म नै तिमीहरूका परमप्रभु परमेश्‍वर हुँ भनी तिमीहरूले जान्‍नेछौ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","साँझमा बट्टाई चराहरू आएर तिनीहरूको छाउनी नै ढाकिदिए । बिहान छाउनीको वरिपरि शीत परेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","शीत सुकेपछि जमिनमा देखा परेको तुसारोझैँ स-साना डल्लाहरू उजाड-स्थानको सतहमा थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","इस्राएलका मानिसहरूले यसलाई देखेपछि तिनीहरूले एक-अर्कालाई भने, “यो के हो?” यो के थियो भनी तिनीहरूलाई थाहा थिएन । मोशाले तिनीहरूलाई भने, “यो परमप्रभुले तिमीहरूलाई खानलाई दिनुभएको रोटी हो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","परमप्रभुले दिनुभएको आज्ञा यस्तो छः तिमीहरू हरेकले आफूलाई चाहिने बटुल अर्थात् तिमीहरूका मानिसहरूको सङ्ख्याअनुसार हरेकलाई एक-एक ओमेर बटुल । तिमीहरूको पालमा बस्‍ने हरेक व्यक्तिलाई पर्याप्‍त हुने गरी बटुल' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्राएलका मानिसहरूले त्यसै गरे । कसैले धेरै बटुले भने कसैले थोरै । ");
INSERT INTO npiulb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","तिनीहरूले ओमेरले नाप्दा धेरै बटुल्नेहरूको बढ्ता भएन र कम बटुल्नेहरूलाई पनि अपुग भएन । हरेक व्यक्तिले आफ्नो आवश्यकताअनुसार बटुल्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","तब मोशाले तिनीहरूलाई भने, “बिहानसम्म तिमीहरू कसैले पनि यसबाट नउबार ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तर तिनीहरूले मोशाको कुरा मानेनन् । कसैले बिहानसम्म अलिकति उबारे, तर त्यसमा किरा लागेर त्यो गन्हायो । त्यसपछि मोशा तिनीहरूसित रिसाए । ");
INSERT INTO npiulb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","तिनीहरूले बिहानैपिच्छे बटुल्थे । हरेकले त्यस दिनलाई पुग्‍ने बटुल्थ्यो । घाम चर्केपछि त्यो पग्लन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","छैटौँ दिनमा तिनीहरूले दुई गुणा रोटी बटुले अर्थात् हरेकको लागि दुई ओमेर बटुले । समुदायका सारा धर्म-गुरुहरू आएर मोशालाई यो कुरा बताए । ");
INSERT INTO npiulb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","तिनले तिनीहरूलाई भने, “परमप्रभुले यसो भन्‍नुभएको छः भोलि विश्रामको दिन हो अर्थात् परमप्रभुको दृष्‍टिमा पवित्र शबाथ हो । तिमीहरू जे पकाउन चाहन्छौ, सो पकाओ र जे उमाल्न चाहन्छौ, सो उमाल । उब्रेको जति सबै बिहानसम्म आफ्नो लागि राख्‍नू' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","त्यसैले तिनीहरूले मोशाले निर्देशन दिएजस्तै यसलाई बिहानसम्म राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मोशाले भने, “त्यो खाना आज खाओ किनकि आजको दिन परमप्रभुको निम्ति अलग गरिएको शबाथ हो । आज तिमीहरूले यो खाना जमिनमा पाउनेछैनौ । ");
INSERT INTO npiulb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छ दिनसम्म तिमीहरूले यो बटुल्नेछौ, तर सातौँ दिनचाहिँ शबाथ हो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","सातौँ दिनमा त्यहाँ मन्‍न हुनेछैन ।” सातौँ दिनमा पनि केही मानिसहरू मन्‍न बटुल्न गए, तर तिनीहरूले केही पाएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब परमप्रभुले मोशालाई भन्‍नुभयो, “कहिलेसम्म तिमीहरू मेरा आज्ञा र विधिहरू मान्‍नलाई इन्कार गर्छौ? ");
INSERT INTO npiulb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","परमप्रभुले तिमीहरूलाई शबाथ दिनुभएको छ । त्यसैले छैटौँ दिनमा उहाँले तिमीहरूलाई दुई दिनको लागि रोटी दिँदै हुनुहुन्छ । हरेक आ-आफ्नै ठाउँमा बस्‍नू । सातौँ दिनमा कोही पनि आफ्नो ठाउँबाट बाहिर नजानू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","त्यसैले मानिसहरूले सातौँ दिनमा विश्राम गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएलका मानिसहरूले त्यस खानालाई “मन्‍न” भने । यो धनियाँको गेडाजस्तो सेतो थियो र यसको स्वाद महमा बनाइएको बाबरजस्तो थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशाले भने, “परमप्रभुले दिनुभएको आज्ञा यही होः एक ओमेर मन्‍न तिमीहरूको पुस्तौँसम्मको लागि राख ताकि तिमीहरूका सन्तानहरूले मैले तिमीहरूलाई मिश्र देशबाट निकालेर ल्याएपछि उजाड-स्थानमा खुवाएको यो रोटी देख्‍न सकून्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","मोशाले हारूनलाई भने, “एउटा भाँडोभित्र एक ओमेर मन्‍न हाल्नुहोस् । पुस्तौँसम्म यसलाई परमप्रभुको सामु सुरक्षित राख्‍नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ हारूनले यसलाई करारको सन्दुकको छेउमा राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएलीहरू मानिसहरू बसोबास गरेको भूमिमा नआउञ्‍जेलसम्म तिनीहरूले चालिस वर्षसम्म मन्‍न खाइरहे । तिनीहरू कनान देशका सिमानाहरूमा नआउञ्‍जेलम्म यो खाइरहे । ");
INSERT INTO npiulb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","एक ओमेर आधा पाथी हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","परमप्रभुको निर्देशन मानी इस्राएलीहरूको सारा समुदाय सीनको उजाड-स्थानबाट यात्रा गरे । तिनीहरूले रपीदीममा छाउनी हाले, तर त्यहाँ मानिसहरूलाई पिउन पानी थिएन । ");
INSERT INTO npiulb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","त्यसैले मानिसहरूले तिनीहरूको अवस्थाको निम्ति मोशालाई दोष लगाए र भने, “हामीलाई पिउन पानी दिनुहोस् ।” मोशाले भने, “तिमीहरू किन मसित झगडा गर्छौ? तिमीहरू किन परमप्रभुको जाँच गर्छौ?” ");
INSERT INTO npiulb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","मानिसहरू तिर्खाएका थिए । त्यसैले तिनीहरूले मोशाको विरुद्धमा गनगन गरे । तिनीहरूले भने, “तपाईंले हामीलाई मिश्रबाट किन निकालेर ल्याउनुभएको? हामी, हाम्रा छोराछोरी र हाम्रा गाईवस्तुलाई तिर्खाले मार्नलाई?” ");
INSERT INTO npiulb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मोशाले परमप्रभुलाई पुकारा गरे, “यी मानिसहरूलाई मैले के गर्ने? तिनीहरू मलाई ढुङ्गा हान्‍न झण्डै तयार छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","परमप्रभुले मोशालाई भन्‍नुभयो, “मानिसहरूभन्दा अगाडि जा, र इस्राएलका केही धर्म-गुरुहरूलाई पनि आफूसँगै लैजा । तैँले नदीमा प्रहार गरेको लट्ठी पनि सँगै लिएर जा । ");
INSERT INTO npiulb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","म होरेब पर्वतमा चट्टानमा तेरो सामु खडा हुनेछु, र तैँले चट्टानलाई हिर्का । मानिसहरूलाई पिउन चट्टानबाट पानी निस्केर आउनेछ ।” तब मोशाले इस्राएलका धर्म-गुरुहरूको दृष्‍टिमा त्यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","इस्राएलीहरूको गनगन र “परमप्रभु हाम्रा बिचमा हुनुहुन्छ कि हुनुहुन्‍न?” भनी तिनीहरूले प्रभुको जाँच गरेकाले तिनले त्यस ठाउँको नाउँ मस्साह र मेरीबा राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","तब रपीदीममा अमालेक जातिका सेना आएर इस्राएललाई आक्रमण गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","त्यसैले मोशाले यहोशूलाई भने, “केही मानिसहरू छानेर जाऊ र अमालेकीहरूसित युद्ध गर । भोलि म परमेश्‍वरको लट्ठी मेरो हातमा लिएर पर्वतको टुप्पोमा उभिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","त्यसैले मोशाको आज्ञामुताबिक यहोशू अमालेकीहरूको विरुद्धमा लडे जब कि मोशा, हारून र हूरचाहिँ पर्वतको टुप्पोमा उक्ले । ");
INSERT INTO npiulb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","मोशाले आफ्ना हात माथि उठाउँदा इस्राएलले जित्थो भने तिनले आफ्ना हात तल झार्दा अमालेकीहरूले जित्‍न थाल्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","मोशाका हात थाक्दा हारून र हूरले एउटा ढुङ्गा ल्याएर तीमुनि राखिदिन्थे । त्यसै बेला हारून एकापट्टि र हूर अर्कोपट्टि बसेर तिनका हात माथि उठाउँथे । सूर्यास्त नहोउञ्‍जेलसम्म मोशाका हात थामिए । ");
INSERT INTO npiulb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","अनि यहोशूले अमालेकीहरूलाई तरवारले पराजित गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","परमप्रभुले मोशालाई भन्‍नुभयो, “यो कुरा एउटा पुस्तकमा लेख् र त्यो यहोशूलाई बताइदे किनकि म अमालेकीहरूको स्मृति आकाशमुनिबाट पूर्ण रूपमा नामेट पारिदिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","तब मोशाले त्यहाँ एउटा वेदी बनाए र त्यसको नाउँ “परमप्रभु मेरो झण्डा हुनुहुन्छ” राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","तिनले भने, “पुस्तादेखि पुस्तासम्म परमप्रभु नै अमालेकीहरूसित लड्नुभएको होस् भनेर उहाँको सिंहासनतिर हात उचालिएको थियो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मिद्यानका पुजारी मोशाका ससुरा यित्रोले मोशा र तिनको जाति इस्राएललाई परमेश्‍वरले गर्नुभएका सबै कुरा सुने । परमप्रभुले इस्राएललाई मिश्रबाट ल्याउनुभएको थियो भनी तिनले सुने । ");
INSERT INTO npiulb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशाले आफ्नी पत्‍नीलाई माइत पठाएपछि तिनका ससुरा यित्रोले सिप्पोरा ");
INSERT INTO npiulb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","र उनका दुई जना छोरालाई लिए । पहिलो छोरोको नाउँ गेर्शोम थियो किनकि मोशाले भने, “म परदेशी भूमिमा परदेशी भएर बसेको थिएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अर्को छोरोको नाउँ एलीएजर थियो किनकि मोशाले भनेका थिए, “मेरा पिता-पुर्खाहरूका परमेश्‍वर मेरो सहयोग हुनुहुन्थ्यो । उहाँले मलाई फारोको तरवारबाट छुटकारा दिनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मोशाका ससुरा यित्रो मोशाका छोराहरू र मोशाकी पत्‍नी लिएर उजाड-स्थानमा मोशाकहाँ आए जहाँ तिनले परमेश्‍वरको पर्वतमा छाउनी हालेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","तिनले मोशालाई भने, “तिम्री पत्‍नी र तिम्रा दुई छोरा लिएर म तिम्रो ससुरा यित्रो आउँदै छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","मोशा आफ्ना ससुरालाई भेट्न गए अनि ढोगेर तिनलाई चुम्बन गरे । तिनीहरूले एक-अर्काका हालखबर सोधपुछ गरे अनि पालभित्र प्रवेश गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","परमप्रभुले इस्राएलको खातिर फारो र मिश्रीहरूलाई गर्नुभएको सबै कुरा अनि बाटोमा तिनीहरूले झेलेका सबै कठिनाइको बाबजुत पनि परमप्रभुले कसरी तिनीहरूलाई छुटकारा दिनुभयो भन्‍ने विषयमा आफ्ना ससुरा यित्रोलाई बताए । ");
INSERT INTO npiulb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","परमप्रभुले इस्राएलको निम्ति गर्नुभएका सबै असल कुरा सुनेर यित्रो रमाए किनकि उहाँले तिनीहरूलाई मिश्रीहरूको हातबाट छुटकारा दिनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रोले भने, “परमप्रभुको स्तुति होस् किनकि उहाँले तिमीहरूलाई फारो र मिश्रीहरूको हातबाट छुटकारा दिनुभएको छ, र मिश्रीहरूको हातबाट उद्धार गर्नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मलाई थाहा भयो कि परमप्रभु अरू सबै देवभन्दा महान् हुनुहुँदोरहेछ किनकि मिश्रीहरूले इस्राएलीहरूलाई अभिमानपूर्वक व्यवहार गर्दा परमेश्‍वरले आफ्नो जातिलाई छुटकारा दिनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","मोशाका ससुरा यित्रोले परमेश्‍वरको लागि होमबलि र बलिदानहरू ल्याए । हारून र इस्राएलका सबै धर्म-गुरु मोशाका ससुरासितै भोजन खान परमेश्‍वरको अगि उपस्थित भए । ");
INSERT INTO npiulb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","अर्को दिन मोशा मानिसहरूको इन्साफ गर्न बसे । मानिसहरू बिहानदेखि बेलुकासम्म तिनको वरिपरि खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मोशाले आफ्ना मानिसहरूका निम्ति गरेका सबै कुरा तिनका ससुराले देखेपछि तिनले भने, “तिमीले मानिसहरूसित गरिरहेको यो के हो? किन तिमी एक्लै बस्छौ? किन मानिसहरू बिहानदेखि बेलुकासम्म तिम्रो वरिपरि झुम्मिन्छन्?” ");
INSERT INTO npiulb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशाले आफ्ना ससुरालाई भने, “परमेश्‍वरको निर्देशन खोज्न मानिसहरू मकहाँ आउँछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","तिनीहरूका बिचमा विवाद हुँदा तिनीहरू मकहाँ आउँछन् । म एक-अर्काको बिचमा न्याय गरिदिन्छु अनि तिनीहरूलाई परमेश्‍वरका नियम र विधिहरू सिकाइदिन्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मोशाका ससुराले तिनलाई भने, “तिमीले गरिरहेको काम त्यति राम्रो होइन । ");
INSERT INTO npiulb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","निश्‍चय नै तिमी र तिमीसित भएका तिम्रा मानिसहरू थाक्‍नेछन् । यो तिमीले बोक्‍नै नसक्‍ने बोझ हो । तिमी आफैले मात्र यो गर्न सक्दैनौ । ");
INSERT INTO npiulb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","मेरो कुरा सुन । म तिमीलाई सल्लाह दिनेछु, र परमेश्‍वर तिमीसित हुनुभएको होस् किनकि तिमी परमेश्‍वरको निम्ति मानिसहरूका प्रतिनिधि हौ र तिमीले नै तिनीहरूका झगडाहरूलाई उहाँकहाँ लैजान्छौ । ");
INSERT INTO npiulb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तिमीले तिनीहरूलाई उहाँका विधि-विधानहरू सिकाउनू । कसरी हिँड्ने र के गर्ने भनी तिमीले तिनीहरूलाई देखाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","त्यस बाहेक, मानिसहरूका बिचबाट तिमीले योग्य मानिसहरूलाई छान जो परमेश्‍वरलाई आदर गर्ने, अन्यायलाई घृणा गर्ने सत्य मानिसहरू होऊन् । तिमीले तिनीहरूलाई हजार, सय, पचास र दसको समूहको रेखदेख गर्ने मानिसहरूको रूपमा जिम्मा दिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","तिनीहरूले हर समय मानिसहरूका मुद्दाहरूका न्याय गर्नेछन्, तर कठिन मुद्दाहरूचाहिँ तिनीहरूले तिमीकहाँ ल्याउनेछन् । स-साना मुद्दाहरू तिनीहरू आफैले न्याय गर्न सक्छन् । यसरी तिमीलाई सजिलो हुनेछ र तिनीहरूले तिम्रो बोझ बोक्‍नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","तिमीले यसो गर्‍यौ र परमेश्‍वरले तिमीलाई यसै गर्न आज्ञा दिनुभयो भने तिमीले सहन सक्‍नेछौ र पुरै समुदाय सन्तुष्‍ट भएर आ-आफ्ना घर जान सक्‍नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","त्यसैले मोशाले आफ्ना ससुराका कुरा माने र तिनले भनेअनुसार गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मोशाले सबै इस्राएलबाट योग्य मानिसहरू छाने र तिनीहरूलाई हजार, सय, पचास र दसको समूहमा नाइकेहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","सामान्य परिस्थितिहरूलाई तिनीहरूले न्याय गर्थे । कठिन मुद्दाहरूचाहिँ तिनीहरूले मोशाकहाँ ल्याउँथे, तर स-साना मुद्दाहरूलाई भने तिनीहरू आफैले न्याय गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","तब मोशाले आफ्ना ससुरालाई बिदाइ गरे र यित्रो आफ्नै देशमा फर्के । ");
INSERT INTO npiulb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएलका मानिसहरू मिश्र देशबाट निस्केको तिन महिना बितेपछि ठिक त्यही दिनमा तिनीहरू सीनैको उजाड-स्थानमा आइपुगे । ");
INSERT INTO npiulb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","तिनीहरू रपीदीमबाट सीनैको उजाड-स्थानमा आइपुगेपछि तिनीहरूले पर्वतको सामुन्‍ने उजाड-स्थानमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","मोशा परमेश्‍वरकहाँ माथि उक्लेर गए । परमप्रभुले पर्वतबाट तिनलाई भन्‍नुभयो, “तैँले याकूबको घराना अर्थात् इस्राएलका मानिसहरूलाई यसो भन्‍नूः ");
INSERT INTO npiulb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","मैले मिश्रीहरूलाई के गरेँ, र मैले कसरी तिमीहरूलाई गरुडको पखेटामा बोकेर मकहाँ ल्याएँ भनी तिमीहरूले देखेका छौ । ");
INSERT INTO npiulb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","अब तिमीहरूले आज्ञाकारितापूर्वक मेरो कुरा सुन्यौ र मेरो करार पालन गर्‍यौ भने सबै जातिमध्ये तिमीहरूचाहिँ मेरो विशेष सम्पत्ति हुनेछौ किनकि सबै पृथ्वी मेरै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तिमीहरू मेरा लागि पुजारीहरूका राज्य र पवित्र जाति हुनेछौ । तैँले यी वचनहरू इस्राएलका मानिसहरूलाई बताउनू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मोशा ओर्लेर आई मानिसहरूका धर्म-गुरुहरूलाई बोलाउन पठाए । परमप्रभुले तिनलाई भन्‍नुभएका सबै वचन तिनले तिनीहरूका सामु राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","सबै मानिसले सँगसँगै जवाफ दिए, “परमप्रभुले भन्‍नुभएका सबै कुरा हामी गर्नेछौँ ।” तब मानिसहरूका वचन परमप्रभुलाई भन्‍न मोशा आए । ");
INSERT INTO npiulb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","परमप्रभुले मोशालाई भन्‍नुभयो, “म तँसित बोल्दा तँलाई मानिसहरूले सदाको लागि विश्‍वास गरून् भन्‍ने हेतुले म बाक्लो बादलमा तँकहाँ आउनेछु” । तब मोशाले मानिसहरूका वचन परमप्रभुलाई बताए । ");
INSERT INTO npiulb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","परमप्रभुले मोशालाई भन्‍नुभयो, “मानिसहरूकहाँ जा । आज र भोलि तैँले तिनीहरूलाई मेरो लागि अलग गर् र तिनीहरूका आ-आफ्ना लुगाहरू धुन लगा । ");
INSERT INTO npiulb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","तेस्रो दिनमा तयार भएर बस् किनकि तेस्रो दिनमा परमप्रभु सीनै पर्वतमा ओर्लिआउनुहुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","तैँले मानिसहरूका लागि पर्वतको वरिपरि सिमाना लगाउनू । तिनीहरूलाई भन्‍नू, 'तिमीहरू पर्वतमा उक्लेर नजाओ वा यसको सिमानालाई नछोओ । जसले पर्वतलाई छुन्छ त्यो निश्‍चय नै मारिनेछ ।' ");
INSERT INTO npiulb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","यस्तो व्यक्तिलाई कसैको हातले छुनुहुँदैन । बरु, उसलाई निश्‍चय नै ढुङ्गाले वा काँडले हानेर मारिनुपर्छ । चाहे त्यो मानिस होस् वा पशु त्यसलाई मारिनैपर्छ । जब तुरही लामो समयसम्म बज्छ तिनीहरू पर्वतको फेदीमा आउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","तब मोशा पर्वतबाट झरेर मानिसहरूकहाँ गए । तिनले मानिसहरूलाई परमप्रभुको निम्ति अलग गरे र तिनीहरूले आ-आफ्ना लुगाहरू धोए । ");
INSERT INTO npiulb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","तिनले मानिसहरूलाई भने, “तेस्रो दिनमा तयार होओ । सहवास नगर ।” ");
INSERT INTO npiulb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तेस्रो दिनमा जब बिहान भयो गर्जन सुनियो र बिजुली चम्क्यो अनि पर्वतमा एउटा बाक्लो बादल देखा पर्‍यो र तुरहीको ठुलो आवाज आयो । छाउनीमा भएका सबै मानिस थरथर काँपे । ");
INSERT INTO npiulb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","परमेश्‍वरलाई भेट्न मोशाले मानिसहरूलाई छाउनी बाहिर ल्याए, र तिनीहरू पर्वतको फेदीमा खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीनै पर्वत पुरै धुवाँले भरिएको थियो किनकि परमप्रभु आगो र धुवाँमा यसमा ओर्लनुभएको थियो । भट्टीको धुवाँजस्तै गरी धुवाँ माथि गयो, र पुरै पर्वत बेस्सरी हल्लियो । ");
INSERT INTO npiulb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","जब तुरहीको आवाज झनझन चर्को हुँदै गयो मोशा बोल्न लागे र परमप्रभुले तिनलाई सुन्‍ने गरी जवाफ दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","परमप्रभु सीनै पर्वतको टुप्पोमा ओर्लनुभयो, र उहाँले मोशालाई टुप्पोमा बोलाउनुभयो । त्यसैले मोशा माथि उक्ले । ");
INSERT INTO npiulb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","परमप्रभुले मोशालाई भन्‍नुभयो, “तल ओर्लेर गएर मानिसहरूलाई होसियार गरा नत्रता तिनीहरूले सिमाना नाघेमा धेरै जना नष्‍ट हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","मेरो नजिक आउने पुजारीहरूले पनि आ-आफूलाई शुद्ध तुल्याऊन्, मेरो आगमनको लागि तिनीहरू तयार रहून् ताकि मैले तिनीहरूलाई प्रहार गर्न नपरोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशाले परमप्रभुलाई भने, “मानिसहरू सीनै पर्वतमा आउन सक्दैनन् किनकि तपाईंले हामीलाई यसरी आज्ञा दिनुभएको छः पर्वतको वरिपरि सिमाना लगाउनू र त्यो परमप्रभुको लागि अलग गर्नू' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","परमप्रभुले तिनलाई भन्‍नुभयो, “जा, तँ आफै पर्वतबाट तल ओर्लेर जा, तँसँगै हारूलाई मकहाँ लिएर आइज । तर मकहाँ आउन पुजारीहरू र मानिसहरूले सिमाना ननाघून् नत्रता मैले तिनीहरूलाई प्रहार गर्नेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","त्यसैले मोशा मानिसहरूकहाँ तल ओर्लेर गई तिनीहरूलाई यी कुरा बताइदिए । ");
INSERT INTO npiulb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","परमेश्‍वरले यी सबै वचन बोल्नुभयोः ");
INSERT INTO npiulb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“म परमप्रभु तिमीहरूका परमेश्‍वर हुँ जसले तिमीहरूलाई मिश्र देश अर्थात् दासत्वको घरबाट निकालेर ल्याएँ । ");
INSERT INTO npiulb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","मेरो अगि अरू कुनै देवी-देवता नमान्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","आफ्नो निम्ति खोपेर माथि स्वर्गमा वा तल पृथ्वीमा वा पानीमुनि भएको कुनै पनि थोकको प्रतिमूर्ति नबनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तिनीहरूको अगि ननिहरनू वा तिनीहरूको पूजा नगर्नू किनकि म परमप्रभु तिमीहरूका परमेश्‍वर डाही परमेश्‍वर हुँ । म मलाई घृणा गर्ने पिता-पुर्खाहरूको दुष्‍टताको दण्ड तिनीहरूका सन्तानहरूको तेस्रो र चौथो पुस्तासम्म दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","तर मलाई प्रेम गर्ने र मेरा आज्ञाहरू पालन गर्ने हजारौँ पुस्तासम्म म मेरो करारको विश्‍वसनीयता देखाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","परमप्रभु तिमीहरूका परमेश्‍वरको नाउँ व्यर्थमा नलिनू किनकि मेरो नाउँ व्यर्थमा लिने जोसुकैलाई पनि म निरपराध छोड्नेछैनँ । ");
INSERT INTO npiulb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","मेरो लागि शबाथ अलग गर्नुपर्छ भनी याद राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","तिमीहरूले छ दिनसम्म परिश्रम गर्नुपर्छ र काम गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","तर सातौँचाहिँ दिन परमप्रभु तिमीहरूका परमेश्‍वरको शबाथ हो । यस दिनमा तिमीहरूले, तिमीहरूका छोराछोरी वा तिमीहरूका कमारा-कमारी वा तिमीहरूका गाईवस्तु वा तिमीहरूको द्वारभित्र भएका परदेशीले कुनै काम नगरोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","किनकि छ दिनमा परमप्रभुले स्वर्ग र पृथ्वी, समुद्र र तिनमा भएका सबै थोक बनाउनुभयो अनि सातौँ दिनमा चाहिँ उहाँले विश्राम लिनुभयो । त्यसकारण परमप्रभुले शबाथ-दिनलाई आशिष् दिनुभयो र यसलाई पवित्र तुल्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","आफ्ना बुबा र आमालाई आदर गर्नू ताकि परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूलाई दिन लाग्‍नुभएको देशमा तिमीहरूको आयु लामो होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","कसैको हत्या नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","कसैसित व्यभिचार नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","कसैबाट केही नचोर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","आफ्नो छिमेकीको विरुद्धमा झुटो गवाही नदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","आफ्नो छिमेकीको घरको लालच नगर्नू; आफ्नो छिमेकीकी पत्‍नीको लालच नगर्नू; आफ्नो छिमेकीको कमारा, कमारी, गोरु, गधा वा कुनै पनि थोकको लालच नगर्नू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","सबै मानिसले गर्जनको आवाज सुने र बिजुली चम्केको देखे अनि तुरहीको आवाज सुने र पर्वतबाट धुवा उठिरहेको देखे । मानिसहरूले यो देख्दा तिनीहरू थरथर काँपे र टाढै बसे । ");
INSERT INTO npiulb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","तिनीहरूले मोशालाई भने, “हामीसित कुरा गर्नुहोस् र हामी तपाईंको कुरा सुन्‍नेछौँ । तर परमेश्‍वर हामीसित नबोल्नुभएको होस् नत्रता हामी मर्नेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मोशाले मानिसहरूलाई भने, “नडराओ किनकि तिमीहरूमा उहाँको डर होस् र तिमीहरूले पाप नगरून् भनी तिमीहरूलाई जाँच गर्न परमेश्‍वर ओर्लनुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","त्यसैले मानिसहरू टाढै खडा रहे, अनि मोशा परमेश्‍वर हुनुभएको बाक्लो बादलको नजिक गए । ");
INSERT INTO npiulb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","परमप्रभुले मोशालाई भन्‍नुभयो, “तैँले इस्राएलीहरूलाई यसो भन्‍नूः मैले स्वर्गबाट तिमीहरूसित कुराकानी गरेको तिमीहरू आफैले देखेका छौ । ");
INSERT INTO npiulb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तिमीहरूले मबाहेक सुन वा चाँदीको कुनै पनि देवी-देवता नबनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","मेरो निम्ति माटोको वेदी बनाउनू, र त्यहाँ तिमीहरूले होमबलि, मेलबलि, भेडा र गोरुहरू बलिदान गर्नू । मेरो नाउँको आदर गरिने हरेक ठाउँमा म तिमीहरूकहाँ आएर तिमीहरूलाई आशिष् दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","तिमीहरूले मेरो निम्ति ढुङ्गाको वेदी बनायौ भने तिमीहरूले कुँदेको ढुङ्गाबाट नबनाउनू किनकि तिमीहरूले त्यसमा सामग्रीहरूको प्रयोग गर्दा तिमीहरूले यसलाई अशुद्ध तुल्याउनेछौ । ");
INSERT INTO npiulb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","तिमीहरूको नग्‍नता नदेखियोस् भनेर खुट्‌किलाहरू बनाएर मेरो वेदीमा नउक्लनू । ");
INSERT INTO npiulb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“अब तैँले तिनीहरूका सामु राख्‍ने आदेशहरू यी नै हुन्: ");
INSERT INTO npiulb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","तिमीहरूले हिब्रू कमारा किन्यौ भने त्यसले छ वर्षसम्म सेवा गर्नुपर्छ, र सातौँ वर्षमा केही नतिरी त्यो मुक्त हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","त्यो एक्लै आएको हो भने त्यो एक्लै जाओस् । त्यो विवाहित हो भने त्यो आफ्नी पत्‍नीसँगै जाओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","त्यसका मालिकले त्यसलाई पत्‍नी दिएका भए र त्यसले पतिको निम्ति छोराछोरीहरू जन्माएकी भए पत्‍नी र त्यसका छोराछोरीहरू मालिकको हुनेछन्, तर पतिचाहिँ मुक्त हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","तर कमाराले सफासँग “म मेरा मालिक, मेरी पत्‍नी र मेरा छोराछोरीलाई प्रेम गर्छु; म मुक्त भएर जान्‍नँ” ");
INSERT INTO npiulb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","भन्यो भने त्यसका मालिकले त्यसलाई परमेश्‍वरको सामु ल्याउनुपर्छ । मालिकले त्यसलाई ढोका वा ढोकाको सङ्घारमा ल्याई त्यसको कान सुतारोले छेडिदिनुपर्छ । तब त्यस कमाराले जीवनभर मालिकको सेवा गर्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","कुनै मानिसले आफ्नी छोरीलाई कमारीको रूपमा बेच्यो भने कमाराहरूजस्तै त्यो मुक्त भएर जानुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","त्यसले आफ्ना मालिकलाई खुसी पारिन भने त्यसलाई मोल तिरेर छुटाइयोस् । त्यसलाई परदेशीकहाँ बेच्ने अधिकार मालिकलाई हुँदैन । मालिकले त्यसलाई छलपूर्वक व्यवहार गरेकोले त्योसित त्यस्तो अधिकार हुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","मालिकले त्यसलाई आफ्नो छोरोकी पत्‍नी हुन दियो भने त्यसलाई आफ्नी छोरीलाई जस्तै व्यवहार गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","त्यसले आफ्नो लागि अर्की पत्‍नी ल्यायो भने त्यसले खानेकुरा, लुगाफाटा वा त्यसका वैवाहिक अधिकारहरू पुरा गर्नबाट नचुकोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","तर त्यसले पत्‍नीलाई यी तिनवटा कुरा उपलब्ध गराएन भने दाम नतिरीकनै त्यो मुक्त भएर जान सक्छे । ");
INSERT INTO npiulb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","कसैले कुनै मानिसलाई मर्ने गरी हिर्कायो भने त्यसलाई निश्‍चय नै मारिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","त्यसले जानाजानी यसो नगरी भवितव्य पर्न गएको रहेछ भने म त्यो भागेर जान सक्‍ने ठाउँ तोकिदिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","कुनै मानिसले जानाजानी आफ्नो छिमेकीलाई आक्रमण गरी धूर्त योजनामुताबिक मार्‍यो भने त्यो परमेश्‍वरको वेदीमा भए तापनि त्यसलाई मार्नलाई लगियोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","आफ्नो बुबा वा आमालाई हिर्काउने जोसुकै पनि निश्‍चय नै मारिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","जसले कुनै व्यक्तिलाई अपहरण गरी त्यसले उसलाई बेच्यो वा पक्रिँदा त्यसकै हातमा फेला पर्‍यो भने अपहरणकारीलाई मारिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","आफ्नो बुबा वा आमालाई सराप्‍ने जोसुकै पनि निश्‍चय नै मारिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","मानिसहरू एक-अर्कासित झगडा गर्दा एउटाले अर्कोलाई ढुङ्गाले वा मुक्‍काले हिर्कायो र त्यो व्यक्ति नमरी ओछ्यान पर्‍यो ");
INSERT INTO npiulb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","र त्यो फेरि उठेर आफ्नो लट्ठीको सहायताले यताउता हिँड्न सक्यो भने हिर्काउनेले त्यसको समयको हर्जाना तिर्नुपर्छ । त्यसले ऊ पूर्ण निको नभएसम्म सबै खर्च पनि दिनुपर्छ । तर त्यो मानिस हत्याको दोषी भने हुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","कुनै मानिसले आफ्नो कमारा वा कमारीलाई लट्ठीले हिर्काउँदा मुक्‍का लागेर मर्‍यो भने त्यस मानिसलाई निश्‍चय नै दण्ड दिइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","तर त्यो एक-दुई दिनसम्म बाँच्यो भने मालिकलाई दण्ड दिइनुहुँदैन किनकि उसले नोकरको क्षति भोग्‍नेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","मानिसहरू सँगसँगै झगडा गर्दा गर्भवती महिलालाई हानि पुगी त्यसको बच्‍चा तुहियो तर त्यो आफैलाई कुनै चोट लागेन भने त्यस स्‍त्रीको पतिले मागेबमोजिम दोषी मानिसलाई हर्जाना तिराइनुपर्छ, र न्यायकर्ताहरूले तोकेबमोजिम त्यसले तिर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","तर गम्भीर चोट लागेको रहेछ भने त्यस मानिसलाई प्राणको सट्टा प्राण ");
INSERT INTO npiulb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","आँखाको सट्टा आँखा, दाँतको सट्टा दाँत, हातको सट्टा हात, खुट्टाको सट्टा खुट्टा ");
INSERT INTO npiulb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","डामको सट्टा डाम, चोटको सट्टा चोट र कुटाइको सट्टा कुटाइ मिलोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","कुनै मानिसले आफ्नो कमारा वा कमारीको आँखामा हिर्काएर त्यसलाई नष्‍ट गरिदियो भने उसले आँखाको साटो त्यसलाई स्वतन्त्र भएर जान दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","उसले आफ्नो कमारा वा कमारीको दाँत निकालिदियो भने उसले दाँतको साटो त्यसलाई स्वतन्त्र भएर जान दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","कुनै गोरुले पुरुष वा स्‍त्रीलाई सिङले हानेर मार्‍यो भने त्यसलाई ढुङ्गाले हानेर मारिनुपर्छ, र त्यसको मासु खाइनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","तर गोरुको मालिकचाहिँ निर्दोष होस् । तर गोरुको विगतमा हान्‍ने बानी थियो र त्यसको मालिकलाई यसबारे चेताउनी दिँदा पनि उसले बाँधेर राखेको रहेनछ र गोरुले पुरुष वा महिलालाई मार्‍यो भने त्यसलाई ढुङ्गाले हानेर मारिनैपर्छ र त्यसको मालिकलाई पनि मारिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","त्यसको जीवनको लागि कुनै मूल्य माग गरिएको छ भने मागेजति मालिकले दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","गोरुले कुनै मानिसको छोरो वा छोरीलाई हानेको छ भने त्यसको मालिकले नियमअनुसार तिर्नुपर्ने हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","गोरुले कमारा वा कमारीलाई हान्यो भने त्यसको मालिकले चाँदीको तिस सिक्‍का देओस् र गोरुलाई चाहिँ ढुङ्गाले हानेर मारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","कुनै मानिसले खाडललाई उदाङ्गै राख्यो वा त्यसले खाडल खनेर त्यसलाई ढाकेन र त्यसभित्र गोरु वा गधा खस्यो भने ");
INSERT INTO npiulb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","खाडल खन्‍नेले हर्जाना तिर्नुपर्छ । त्यसले मृत पशुको मालिकलाई रुपियाँ तिर्नपर्छ र त्यो मरेको पशु त्यसको हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","एउटा मान्छेको गोरुले अर्को मान्छेको गोरुलाई चोट पुर्‍याएर त्यो मर्‍यो भने त्यसले जिउँदो गोरुलाई बेची तिनीहरूले त्यसको मूल्य बाँडफाँड गर्नुपर्छ र तिनीहरूले मरेको गोरुलाई पनि बाँडफाँड गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","तर त्यस गोरुको विगतमा पनि हान्‍ने बानी रहेछ र त्यसको मालिकले त्यसलाई बाँधेर राखेको रहेनछ भनी थाहा हुन आयो उसले गोरुको सट्टा गोरु तिर्नुपर्छ अनि मरेको पशु त्यसको मालिकको हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","कुनै मानिसले गोरु वा भेडा चोरेर त्यसलाई मार्‍यो वा बेच्यो भने त्यसले एउटा गोरुको सट्टा पाँचवटा गोरु र एउटा भेडाको सट्टा चारवटा भेडा देओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","घर फोर्दै गर्दा चोरलाई भेट्टाइयो र त्यसलाई प्रहार गर्दा त्‍यो मर्‍यो भने त्यसलाई हिर्काउने हत्याको दोषी हुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","तर त्यसले घर फोर्नुअगि घाम झुल्किसकेको रहेछ भने त्यसलाई मार्ने व्यक्‍तिलाई हत्याको दोष लाग्‍नेछ । चोरले नोक्सानी भरिदिनुपर्छ । त्योसँग केही छैन भने त्यसको चोरीको लागि त्यसलाई बेचिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","चोरिएको पशु अर्थात् चाहे त्यो गोरु होस् वा गधा होस् वा भेडा होस्, त्योसँगै जिउँदै पाइयो भने त्यसले दुई गुणा फिर्ता दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","कुनै मानिसले खेत वा दाखबारीमा आफ्ना गाईवस्तु चराउँदा त्यसले बाँधेन र पशु अर्को मानिसको खेतमा चर्न पुग्यो भने त्यसले आफ्नो सबैभन्दा असल खेत वा दाखबारीबाट नोक्सानी तिर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","आगलागी भई काँडामा फैलन पुगी त्यसले अन्‍नको बिटा वा मकैको बिटा वा खेतलाई भस्म पार्‍यो भने आगो लगाउनेले क्षतिपूर्ति तिरिदिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","कुनै मानिसले आफ्नो छिमेकीलाई सुरक्षाको खातिर रुपियाँ-पैसा वा सामान राख्‍न दिँदा त्यस मानिसको घरबाट त्यो चोरी भयो र चोर फेला पारियो भने चोरले दुई गुणा तिर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","तर चोरलाई फेला पारिएन भने घरको मालिकको छिमेकीको सम्पत्तिमाथि उसकै हात छ या छैन भनी जाँच गर्न त्यो न्यायकर्ताहरूको सामु आउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","कुनै पनि विवादको बारेमा अथवा गोरु, गधा, भेडा, लुगाफाटा वा कुनै पनि हराएको वस्तुको विषयमा कसैले “यो मेरो हो” भन्यो भने दुवै पक्षका दाबीलाई न्यायकर्ताहरूको सामु ल्याइनुपर्छ । न्याकर्ताहरूले जसलाई दोषी पाउँछन् त्यसले आफ्नो छिमेकीलाई दुई गुणा तिरोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","कुनै मानिसले आफ्नो छिमेकीलाई गधा, गोरु, भेडा वा कुनै पशु राख्‍नलाई दिँदा त्यो मर्‍यो वा त्यसलाई चोट लाग्यो वा कसैले नदेखीकन त्यसलाई भगाइयो भने ");
INSERT INTO npiulb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","आफ्नो छिमेकीको सम्पत्तिमा आफ्नो हात छैन भनी दुवै जनाले परमप्रभुको सामु शपथ खानुपर्छ । सम्पत्तिको मालिकले यसलाई स्वीकार गर्नैपर्छ र अर्कोले क्षतिपूर्ति तिर्नुपर्दैन । ");
INSERT INTO npiulb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","तर त्यसबाट यो चोरी भएको हो भने त्यसले यसको लागि मालिकलाई क्षतिपूर्ति तिर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","पशुलाई टुक्राटुक्रा पारिएको छ भने अर्को मानिसले साक्षीको रूपमा त्यो पशु ल्याओस् । टुक्राटुक्रा पारिएको कारण त्यसले क्षतिपूर्ति दिनुपर्दैन । ");
INSERT INTO npiulb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","कुनै मानिसले आफ्नो छिमेकीबाट पशु पैँचो लिँदा मालिकको उपस्थितिविना त्यसलाई चोट लाग्यो वा त्यो मर्‍यो भने अर्को मानिसले क्षतिपूर्ति दिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","तर मालिक पनि उपस्थित थियो भने अर्को मानिसले तिर्नुपर्दैन । पशुलाई भाडामा लिइएको थियो भने ज्यालाको लागि लाग्‍ने रकमले क्षतिपूर्ति तिरिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","कुनै पुरुषले मगनी नभएकी कन्या केटीलाई फकाएर त्यससित सुत्यो भने त्यसले दुलहीको रकम दिएर त्यसलाई आफ्नी पत्‍नी बनाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","केटीको बुबाले केटी त्यसलाई दिन पूर्ण रूपमा अस्वीकार गर्‍यो भने त्यसले कन्या केटीहरूको दुलहीको सम्पत्ति बराबरको रकम तिर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","तिमीहरूले टुनामुना गर्नेलाई जीवित नराख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","पशुसित सुत्‍ने जोसुकै पनि मारिनैपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","परमप्रभुबाहेक अन्य कुनै देवी-देवतालाई बलिदान चढाउनेलाई पूर्ण रूपमा नष्‍ट गरिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","तिमीहरूले परदेशीको बिगार गर्नुहुँदैन वा त्यसलाई थिचोमिचो गर्नुहुँदैन किनकि तिमीहरू पनि मिश्र देशमा परदेशीहरू थियौ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","विधवा वा अनाथलाई दुर्व्यवहार नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","तिनीहरूलाई सतायौ र तिनीहरूले मेरो पुकारा गरे भने म निश्‍चय नै तिनीहरूको पुकारा सुन्‍नेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","मेरो क्रोध दन्कनेछ र म तिमीहरूलाई तरवारले मार्नेछु । तिमीहरूका पत्‍नीहरू विधवा बन्‍नेछन्, र तिमीहरूका छोराछोरीहरू अनाथ बन्‍नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","मेरा मानिसहरूका बिचमा भएका गरिबहरूलाई तिमीहरूले ऋण दियौ भने तिमीहरू उसको लागि साहुकारजस्ता नहोओ वा त्यसबाट ब्याज असुल नगर । ");
INSERT INTO npiulb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","तिमीहरूले छिमेकीको खास्टो बन्धकी राख्यौ भने सूर्यास्तअगि नै तिमीहरूले त्यो फिर्ता गरिदिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","किनकि त्यसको ओढ्ने त्यही मात्र हो । यो त्यसको शरीरको लागि त्यसको खास्टो हो । योबाहेक त्यो केमा सुत्‍न सक्छ र? त्यसले मेरो पुकारा गर्दा म सुन्‍नेछु किनकि म दयालु छु । ");
INSERT INTO npiulb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","परमेश्‍वरको विरुद्धमा ईश्‍वर-निन्दा नगर न त तिमीहरूका मानिसहरूको शासकलाई सराप । ");
INSERT INTO npiulb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","तिमीहरूको कटनी वा दाखबारीबाट भेटी चढाउन विलम्ब नगर । तिमीहरूका छोराहरूका जेठोचाहिँ मलाई दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","त्यस्तै गरी तिमीहरूका गोरु र भेडाहरूलाई पनि यसै गर । सात दिनसिम्म तिनीहरू आ-आफ्ना माउसित बस्‍न सक्छन् तर आठौँ दिनमा चाहिँ तिमीहरूले ती मलाई देओ । ");
INSERT INTO npiulb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","तिमीहरू मेरा लागि अलग गरिएका जाति हौ । त्यसैले खेतमा पशुद्वारा फहराएको मासु तिमीहरूले नखानू । बरु, त्यो कुकुरहरूलाई फालिदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","कसैको बारेमा झुटा गवाही नदेओ । बेइमानी गवाही दिने दुष्‍ट मानिससित नमिल । ");
INSERT INTO npiulb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","खराबी गर्न भिडको पछि नलाग, न त न्यायलाई बङ्ग्याउन भिडको पक्ष लेओ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","गरिब मानिसको मुद्दामा उसको पक्षपात नगर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","आफ्नो शत्रुको गोरु वा गधा बिच्केर जाँदै गरेको देख्यौ भने त्यसलाई फर्काएर त्यसकहाँ ल्याइदेओ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","तिमीहरूलाई घृणा गर्ने कुनै व्यक्तिको गधा भारीले थिचिएर भुइँमा लडेको देख्यौ भने त्यसलाई त्यत्तिकै नछोड । गधासँगै मदत गर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","मुद्दा मामिलामा गरिबहरूको न्याय हरण नगर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झुटा गवाही दिन अरूहरूसित नमिल, र निर्दोष वा धर्मीहरूलाई नमार किनकि म दुष्‍टहरूलाई कहिल्यै निर्दोष ठहराउनेछैनँ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","कहिल्यै घुस नलेओ किनकि घुसले देख्‍नेहरूलाई अन्धो तुल्याइदिन्छ र इमानदार मानिसहरूका वचनलाई बङ्ग्याइदिन्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","परदेशीलाई थिचोमिचो नगर किनकि तिमीहरू मिश्र देशमा परदेशी भएर बाँचेकाले परदेशीको जीवन कस्तो हुन्छ भनी तिमीहरू जान्दछौ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","छ वर्षसम्म तिमीहरूले आ-आफ्ना जमिनमा बिउ रोपी फसल जम्मा गर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","तर सातौँ वर्षमा चाहिँ हलो नजोती त्यसलाई बाँझै छाडिदेओ ताकि तिमीहरूका बिचमा भएका गरिब मानिसहरूले खान सकून् । तिनीहरूले छाडेका जङ्गली जनावरहरूले खानेछन् । तिमीहरूका दाखबारी र भद्राक्षबारीलाई पनि त्यसै गर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","छ दिनसम्म आफ्नो काम गर, तर सातौँ दिनमा चाहिँ विश्राम गर । तिमीहरूका गोरु र गधाले पनि विश्राम पाउन सकून् भनेर यसो गर अनि तिमीहरूका कमारीको छोरो र परदेशीले पनि ताजा महसुस गर्न सकून् भनेर यस गर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","मैले तिमीहरूलाई भनेका हरेक कुरामा ध्यान देओ । अरू देवी-देवताहरूको चर्चा नगर, न त तिमीहरूका मुखबाट तिनीहरूको नाउँ नै सुनियोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","मेरो निम्ति चाड मान्‍न हरेक वर्ष तिन पटक यात्रा गर । ");
INSERT INTO npiulb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","तिमीहरूले अखमिरी रोटीको चाड मान्‍नू । मैले आज्ञा गरेझैँ तिमीहरूले सात दिनसम्म अखमिरी रोटी खानू । त्यस बेला तिमीहरू आबीब महिनामा मेरो सामु देखा पर्नू जुन यही उद्देश्यको लागि तयार पारिएको हो । तिमीहरू यही महिनामा मिश्रबाट बाहिर निस्केर आयौ । तर तिमीहरू खाली हात मेरो सामु देखा नपर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","तिमीहरूले आफ्ना खेतहरूमा बिउ छर्दा तिमीहरूको परिश्रमको अगौटे फलको सम्झनामा कटनीको चाड मान्‍नू । खेतहरूबाट तिमीहरूले अन्‍न बटुल्दा वर्षको अन्त्यमा तिमीहरूले अन्‍न भित्र्याउने चाड मनाओ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","तिमीहरूका सबै पुरुष हरेक वर्ष तिन पटक परमप्रभुको सामु देखा पर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","मलाई चढाउने बलिको रगत खमिर हालेको रोटीसितै नचढाओ । मेरा चाडहरूमा चढाइने बलिदानहरूको बोसो रातभरि रहेर बिहानसम्म रहनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","तिमीहरूले मेरो घर अर्थात् परमप्रभु तिमीहरूका परमेश्‍वरको घरमा अगौटे फलहरूमध्ये सबैभन्दा असलचाहिँ ल्याउनू । बाख्राको पाठो त्यसको माउको दूधमा नपकाओ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","बाटोमा तिमीहरूको सुरक्षा दिन र मैले तिमीहरूका निम्ति तयार पारिराखेको ठाउँमा तिमीहरूलाई ल्याउन म तिमीहरूका अगिअगि एउटा दूत पठाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","तिनको कुरा सुनी तिनको आज्ञा पालन गर । तिनलाई नचिढ्याओ किनकि तिनले तिमीहरूका अपराधहरू क्षमा दिनेछैनन् । तिनैमा मेरो नाउँ छ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","तिमीहरूले वास्तवमै तिनका आज्ञा मान्यौ र मैले भनेका हरेक कुरा गर्‍यौ भने म तिमीहरूका शत्रुहरूका शत्रु हुनेछु र तिमीहरूका वैरीहरूका वैरी हुनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","मेरा दूत तिमीहरूका अगिअगि जानेछन् र तिनले तिमीहरूलाई एमोरी, हित्ती, परिज्‍जी, कनानी, हिव्वी र यबूसीहरूकहाँ ल्याउनेछन् । म तिनीहरूलाई नष्‍ट गर्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","तिमीहरू तिनीहरूका देवी-देवताहरूको सामु ननिहरनू, तिनीहरूको पूजा नगर्नू न त तिनीहरूले गरेजस्तै गर्नू । बरु तिमीहरूले तिनीहरूलाई बिलकुलै नाश गरिदिनू र तिनीहरूका ढुङ्गाका मूर्तिहरूलाई टुक्राटुक्रा पारिदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तिमीहरूले परमप्रभु तिमीहरूका परमेश्‍वरको आराधना गर्नू, अनि उहाँले तिमीहरूका अन्‍न र पानीमा आशिष् दिनुहुनेछ । म तिमीहरूका बिचबाट रोग हटाइदिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तिमीहरूको देशमा कुनै पनि स्‍त्री बाँझी हुनेछैन न त कसैको गर्भ तुहिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","म तिमीहरूलाई दीर्घायु दिनेछु । तिमीहरू अगाडि बढ्ने देशमा म मेरो डर अगिअगि पठाउनेछु । म तिमीहरूले भेट्ने सबै मानिसलाई मार्नेछु । म तिमीहरूका सबै शत्रुलाई तिमीहरूको डरको कारणले भगाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","म तिमीहरूका अगिअगि अरिङ्गालहरू पठाउनेछु जसले हिव्वी, कनानी र हित्तीहरूलाई तिमीहरूभन्दा अगाडि नै धपाउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","म तिनीहरूलाई एकै वर्षमा तिमीहरूको सामुन्‍नेबाट धपाउनेछैनँ, नत्रता देश उजाड हुनेछ र जङ्गली जनावरहरू तिमीहरूका निम्ति अत्यधिक हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","बरु, तिमीहरूको वृद्धि भई तिमीहरू देशमा नभरिएसम्म म तिनीहरूलाई तिमीहरूकै सामु अलिअलि गरेर धपाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","नर्कटहरूको समुद्रदेखि पलिश्तिहरूको समुद्रसम्म र उजाड-स्थानदेखि यूफ्रेटिस नदीसम्म म तिमीहरूका सिमाना तोकिदिनेछु । त्यस देशका बासिन्दाहरूमाथि म तिमीहरूलाई विजय दिनेछु । तिमीहरूले तिमीहरूकै सामु तिनीहरूलाई धपाउनेछौ । ");
INSERT INTO npiulb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तिनीहरूसित वा तिनीहरूका देवी-देवताहरूसित करार नबाँध्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","तिनीहरू तिमीहरूको देशमा बस्‍नुहुँदैन नत्रता तिनीहरूले तिमीहरूलाई मेरो विरुद्धमा पाप गर्न लगाउनेछन् । तिमीहरूले तिनीहरूका देवी-देवताहरूलाई पुजा गर्‍यौ भने निश्‍चय नै यो तिमीहरूका लागि पासो हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, “तँ, हारून, नादाब, अबीहू र इस्राएलका सत्तरी जना धर्म-गुरु मकहाँ उक्लेर आओ र केही दूरी राखेर मेरो आराधना गर । ");
INSERT INTO npiulb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","मोशा मात्र मेरो नजिक आउन सक्छ । अरूहरू मेरो नजिक नआउनू न त मानिसहरू नै तिनीहरूसित आउनू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मोशा गएर परमप्रभुका वचनहरू र विधिविधानहरू मानिसहरूलाई सुनाइदिए । सबै मानिसले एकै सोरमा भने, “परमप्रभुले भन्‍नुभएका सबै वचन हामी पालन गर्नेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तब मोशाले परमप्रभुका सबै वचन लेखे । बिहान सबेरै उठेर मोशाले पर्वतको फेदीमा एउटा वेदी बनाए र इस्राएलका बाह्र कुलको प्रतिनिधित्व हुने गरी बाह्रवटा ढुङ्गाका वेदी बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तिनले परमप्रभुका निम्ति केही इस्राएली जवानहरूलाई गोरुको होमबलि र मेलबलि चढाउन पठाए । ");
INSERT INTO npiulb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशाले आधा रगत लिएर त्यसलाई कचौरामा हाले । तिनले बाँकी आधा रगत भने वेदीमा छर्के । ");
INSERT INTO npiulb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","तिनले करारको पुस्तक लिएर मानिसहरूले सुन्‍ने गरी चर्को सोरमा पढे । तिनीहरूले भने, “परमप्रभुले भन्‍नुभएका सबै कुरा हामी पालन गर्नेछौँ । हामी आज्ञाकारी बन्‍नेछौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मोशाले रगत लिएर त्यसलाई मानिसहरूमाथि छर्के । तिनले भने, “यी सबै वचनसहित तिमीहरूलाई यो प्रतिज्ञा दिएर यो परमप्रभुले तिमीहरूसित बाँध्‍नुभएको करारको रगत हो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मोशा, हारून, नादाब, अबीहू र इस्राएलका सत्तरी जना धर्म-गुरु पर्वतमाथि उक्लेर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","तिनीहरूले इस्राएलका परमेश्‍वरलाई देखे । उहाँको पाउमुनि आकाशजस्तै सफा नीरबाट निर्मित बाटो थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","परमेश्‍वरले इस्राएली अगुवाहरूमाथि आफ्नो हात उठाउनुभएन । तिनीहरूले परमेश्‍वरलाई देखे अनि तिनीहरूले खाए र पिए । ");
INSERT INTO npiulb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","परमप्रभुले मोशालाई भन्‍नुभयो, “माथि पर्तवमा मकहाँ उक्लेर आइज र यहाँ बस् । म तँलाई व्यवस्था र आज्ञाहरू लेखिएका शिला-पाटीहरू दिनेछु अनि तैँले तिनीहरूलाई सिका ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","त्यसैले मोशा आफ्ना सहयोगी यहोशूसँगै परमेश्‍वरको पर्वतमा उक्लेर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मोशाले धर्म-गुरुहरूलाई भनेका थिए, “यहीँ बस्‍नुहोस् र हामी तपाईंहरूकहाँ नआउञ्‍जेलसम्म पर्खेर बस्‍नुहोस् । हारून र हूर तपाईंहरूसितै छन् । कसैको केही वादविवाद भएमा तिनीहरूकहाँ जानू ।” ");
INSERT INTO npiulb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","त्यसैले मोशा पर्वतमा उक्लेर गए, अनि बादलले पर्वतलाई ढाक्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","परमप्रभुको महिमा सीनै पर्वतमा आएर बस्यो, र बादलले छ दिनसम्म यसलाई ढाक्यो । सातौँ दिनमा उहाँले बादलभित्रबाट मोशालाई डाक्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएलीहरूको दृष्‍टिमा पर्वतको टुप्पोमा परमप्रभुको महिमाको प्रकटीकरण भस्म गर्ने आगोझैँ देखा पर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मोशा बादलभित्र प्रवेश गरी पर्वतमा उक्ले । तिनी चालिस दिन चालिस रातसम्म पर्वतमा रहे । ");
INSERT INTO npiulb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“राजीखुसीबाट प्रेरित भई हरेक व्यक्तिले मेरो लागि भेटी ल्याओस् भनी इस्राएलीहरूलाई भन् । तैँले यी भेटीहरू मेरो लागि ग्रहण गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","तैँले तिनीहरूबाट प्राप्‍त गर्नुपर्ने भेटीहरू यिनै हुन्: सुन, चाँदी, र काँसा ");
INSERT INTO npiulb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","निलो, बैजनी र रातो ऊन, मलमलको कपडा, बाख्राको भुत्ला ");
INSERT INTO npiulb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","रातो रङले रङ्गाएका भेडाका छाला र सीलका छालाहरू, बबुल काठ, ");
INSERT INTO npiulb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","पवित्रस्थानका बत्तीहरूका निम्ति तेल, अभिषेक गर्नका लागि मसला र सुगन्धित धूप, एपोद र छाती-पातामा जड्नका लागि ");
INSERT INTO npiulb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","आनिक्स र अन्य बहुमूल्य रत्‍नहरू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","म तिनीहरूका बिचमा बस्‍न सकूँ भनेर तिनीहरूले मेरो निम्ति एउटा पवित्रस्थान बनाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","मैले तँलाई देखाउने नमुनामुताबिक तैँले पवित्र वासस्थान र यसका सबै सामानहरू बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","तिनीहरूले बबुल काठको सन्दुक बनाऊन् । यसको लमाइ साँढे दुई हात, चौडाइ साँढे एक हात र उचाइ साँढे एक हातको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","यसको निम्ति सुनका चारवटा मुन्द्रा झुण्ड्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","एकापट्टि दुईवटा र अर्कोपट्टि दुईवटा गरी तिनलाई सन्दुकको चारवटा खुट्टामा लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","तैँले बबुल काठका डन्डाहरू बनाएर तिनलाई सुनले मोहोर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","सन्दुकलाई बोक्‍नलाई त्यसको दुवैपट्टिका किनारामा भएका मुन्द्राहरूमा ती डन्डाहरू घुसाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","डन्डाहरू सन्दुकका मुन्द्राहरूमा रहनुपर्छ । तिनलाई त्यसबाट झिकिनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","तैँले सन्दुकभित्र मैले तँलाई दिने करारका विधिविधानहरू राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","तैँले निखुर सुनको एउटा प्रायश्‍चित्तको ढकनी बनाउनू । यसको लमाइ साँढे दुई हात र चौडाइ साँढे एक हातको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","तैँले प्रायश्‍चित्तको ढकनीको दुई किनारामा राख्‍न पिटिएको सुनका दुईवटा करूब बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","प्रायश्‍चित्तको ढकनीको एउटा किनारामा एउटा करूब र अर्को किनारामा अर्को करूब राख्‍नू । ती दुईवटा करूब र प्रायश्‍चित्तको ढकनी एउटै सुनको टुक्राबाट बनाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","करूबहरूले आ-आफ्ना पखेटा मास्तिर फैलाऊन् र प्रायश्‍चित्तको ढकनीलाई छाया पारून् । करूबहरू एक-अर्काको आमनेसामने होऊन् र तिनीहरूले प्रायश्‍चित्तको ढकनीतर्फ हेरून् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","तैँले प्रायश्‍चित्तको ढकनीलाई सन्दुकको माथिपट्टि राख्‍नू, र मैले तँलाई दिने करारका विधिविधानहरू सन्दुकभित्र राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","यही सन्दुकमा म तँसित भेट्नेछु । प्रायश्‍चित्तको ढकनीमाथिबाट म तँसित बोल्नेछु । गवाहीको सन्दुकको माथि भएका दुईवटा करूबको बिचबाट मैले इस्राएलीहरूलाई दिने सबै आज्ञा तँलाई दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","तैँले बबुल काठको एउटा टेबुल बनाउनू । यसको लमाइ दुई हात, चौडाइ एक हात र उचाइ साँढे एक हातको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","तैँले यसलाई निखुर सुनले मोहर्नू र यसको चारैतिर सुनको बिट लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","त्यसको चारैतिर चार अङ्गुल चौडा भएको घेरो बनाउनू र घेरोको वरिपरि सुनको बिट लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","टेबुलको लागि सुनका चारवटा मुन्द्रा बनाउनू र ती मुन्द्राहरूलाई चार खुट्टा भएका चारवटै कुनामा लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","टेबुललाई बोक्‍नलाई डन्डाहरूका लागि ठाउँ हुन ती मुन्द्राहरू घेरोको छेउमा होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","टेबुललाई तीसँगै बोक्‍न सकियोस् भनी बबुल काठबाट डन्डाहरू बनाउनू र ");
INSERT INTO npiulb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","तिनलाई सुनले मोहर्नू अर्घबलिहरू चढाउन प्रयोग हुने थाल, चम्चा, करुवा र कचौराहरू बनाउनू । तैँले ती सबै निखुर सुनको बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","तैँले टेबुलमा मेरो सामु नियमित रूपमा उपस्थितिको रोटी राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","पिटेको निखुर सुनबाट एउटा सामदान बनाउनू । आधार र बिँडसहित यसलाई बनाउनू । यसका कचौराहरू, कोपिला र फुलहरू सबै नै एउटै टुक्राबाट बनाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","यसको एकापट्टिबाट तिनवटा हाँगा र अर्कोपट्टिबाट तिनवटा हाँगा गरी जम्मा छवटा हाँगा बाहिरतिर निस्केका होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","पहिलो हाँगामा हाडेबदामका फुलजस्ता तिनवटा कचौरासाथै कोपिला र फुल होऊन् । त्यस्तै अर्को हाँगामा पनि हाडेबदामका फुलजस्ता तिनवटा कचौरासाथै कोपिला र फुल होऊन् । सामदानबाट बाहिर निस्कने सबै छवटा हाँगामा उस्तै होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","सामदान र बिचको बिँडमा हाडेबदामका फुलजस्ता चारवटा कचौरा आ-आफ्नै कोपिला र फूलसमेत होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","एउटै टुक्राको रूपमा पहिलो जोडी हाँगामुनि एउटा कोपिला र एउटै टुक्राको रूपमा दोस्रो जोडी हाँगामुनि एउटा कोपिला होस् । त्यसै गरी, एउटै टुक्राको रूपमा तेस्रो जोडी हाँगामुनि एउटा कोपिला होस् । सामदानबाट बाहिर निस्केका सबै छवटै हाँगा उस्तै होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","तिनीहरूका कोपिला र हाँगाहरू सबै पिटेको निखुर सुनको एउटा टुक्राबाट बनेका होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","तैँले सामदान र यसका सातवटा बत्ती बनाउनू, र यसबाट उज्यालो दिन ती बत्तीहरू बालिराख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","चिम्टा र तिनीहरूका मोसोदानीहरू निखुर सुनबाट बनाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","सामदान र यसका सबै पात्र बनाउन करिब चौँतिस किलोग्राम निखुर सुनको प्रयोग गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","तँलाई पर्वतमा देखाएको नमुनाबमोजिम ती बनाउन नभुल्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","तैँले मसिनो सुती कपडा, निलो, बैजनी र रातो ऊन करूबहरूको रचनासहित दसवटा पर्दा भएको पवित्र वासस्थान बनाउनू । यो ज्यादै सिपालु शिल्पकारको काम हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हरेक पर्दाको लमाइ अट्ठाइस हात र चौडाइ चार हातको होस् । सबै पर्दा उही आकारको हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाँचवटा पर्दालाई एक-अर्कासित गाँस्‍नू, र अन्य पाँचवटा पर्दालाई एक-अर्कासित गाँस्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","पहिलो गाँसिएको भागको बाहिरी छेउमा निलो सुर्काउनी बनाउनू । त्यसै गरी, दोस्रो गाँसिएको भागको बाहिरी छेउमा पनि निलो सुर्काउनी बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","पहिलो पर्दामा पचासवटा सुर्काउनी बनाउनू, र दोस्रो गाँसिएको भागको पर्दामा पनि पचासवटा सुर्काउनी बनाउनू । ती सुर्काउनीहरू आमनेसामने हुने गरी बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","सुनका पचासवटा अङ्कुसे बनाई पवित्र वासस्थान एउटै हुने गरी ती पर्दाहरूलाई अङ्कुसेहरूसित जोड्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","पवित्र वासस्थानमाथि राखिने पालको निम्ति बाख्राका भुत्लाका पर्दाहरू बनाउनू । एघारवटा यस्ता पर्दा बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","हरेक पर्दाको लमाइ तिस हात र चौडाइ चार हातको होस् । एघारवटै पर्दाको नाप उही होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","पाँचवटा पर्दालाई एक-अर्कामा जोड्नू र बाँकी छवटालाई एक-अर्कामा जोड्नू । छैटौँ पर्दालाई चाहिँ पालको अगाडिपट्टि दोब्बर गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","पहिलो गाँसिएको भागको एकापट्टिको छेउमा पचासवटा सुर्काउनी बनाउनू, र दोस्रो गाँसिएको भागको एकापट्टिको छेउमा पचासवटा सुर्काउनी बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","पचासवटा काँसाका अङ्कुसे बनाई तिनलाई सुर्काउनीहरूमा लगाउनू । त्यसपछि एउटै बनाउन पाललाई सँगसँगै जोड्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","पालको बाँकी रहेको आधा भाग अर्थात् पालका पर्दाहरूबाट झुण्डिरहको आधा भागलाई पवित्र वासस्थानको पछिल्तिर झुण्ड्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","एकापट्टि एक हात लामो र अर्कोपट्टि एक हात लामो पर्दा हुनुपर्छ । पवित्र वासस्थानलाई ढाक्‍न त्यसको दुवैपट्टि पालका पर्दाहरूको बाँकी भाग झुण्डिरहून् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","रातो रङले रङ्ग्याएका भेडाका छालाबाट पवित्र वासस्थानलाई ढाक्‍ने बनाउनू, र त्यसको माथि मसिनो छालाको ढकनी होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","पवित्र वासस्थानको लागि बबुल काठबाट ठाडा फल्याकहरू बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","हरेक फल्याकको लमाइ दस हात र चौडाइ साँढे एक हातको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","फल्याकहरूलाई एक-अर्कासित जोड्न हरेक फल्याकमा दुईवटा काठका चोसा होऊन् । पवित्र वासस्थानका सबै फल्याक यसरी नै बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पवित्र वासस्थानको लागि फल्याकहरू बनाउँदा दक्षिणपट्टिको लागि बिसवटा फल्याक बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ती बिसवटा फल्याकको मुन्तिर राख्‍न चाँदीका चालिसवटा आधार बनाउनू । पहिलो फल्याकको मुन्तिर दुईवटा आधार र अन्य फल्याकहरूको मुन्तिर पनि दुई-दुईवटा आधार बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","पवित्र वासस्थानको दोस्रो भाग अर्थात् उत्तरपट्टिको लागि बिसवटा फल्याक ");
INSERT INTO npiulb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","र तिनका चालिसवटा आधार बनाउनू । पहिलो फल्याकको मुन्तिर दुईवटा आधार अनि दोस्रोको मुन्तिर दुईवटा आधार र बाँकीको निम्ति पनि यसरी नै बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","पवित्र वासस्थानको पछाडिपट्टि अर्थात् पश्‍चिमपट्टि छवटा फल्याक बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","पवित्र वासस्थानको पछाडिका कुनाहरूमा दुईवटा फल्याक बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","यी फल्याकहरू तल छुट्टिएका होऊन् तर माथि भने जोडिएका होऊन् । दुवै कुनाका लागि यही किसिमले बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","चाँदीका आधारहरू भएका आठवटा फल्याक बनाउनू । पहिलो फल्याकमुनि दुईवटा आधार, अर्को फल्याकमुनि दुईवटा आधार एवम् रितले जम्माजम्मी सोह्रवटा आधार होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","तैँले बबुल काठका बारहरू बनाउनू । पवित्र वासस्थानका एकापट्टिका फल्याकहरूका निम्ति पाँचवटा बार, ");
INSERT INTO npiulb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","पवित्र वासस्थानका अर्कोपट्टिका फल्याकहरूका निम्ति पाँचवटा बार र पवित्र वासस्थानको पश्‍चिमपट्टिका फल्याकहरूका निम्ति पाँचवटा बार बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","फल्याकहरूका बिचमा भएको बारचाहिँ एक छेउदेखि अर्को छेउसम्म पुगोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","तैँले फल्याकहरूलाई सुनले मोहोर्नू । बारहरूलाई अल्झाउन सुनका मुन्द्राहरू बनाउनू, र बारहरूलाई पनि सुनले मोहोर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","तँलाई पर्वतमा देखाइएको नमुनाबमोजिम पवित्र वासस्थान खडा गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","निलो, बैजनी, रातो ऊन र मसिनो सुती कपडाबाट करूबहरूको रचनासमेत भएको एउटा पर्दा बनाउनू । यो सिपालु शिल्कारको काम होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","सुनले मोहोरिएको बबुल काठको चारवटा खम्बामा यस पर्दालाई झुण्ड्याउनू । यी खम्बाहरूमा सुनका अङ्कुसेहरू हुनुपर्छ जसमा चारवटा चाँदीका आधार राखिएका होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","पर्दालाई अङ्कुसेमुनि झुण्ड्याउनू, र गवाहीको सन्दुकलाई यसभित्र ल्याउनू । यो पर्दाले पवित्रस्थानलाई महा-पवित्रस्थानबाट अलग गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","प्रायश्‍चित्तको ढकनीलाई गवाहीको सन्दुकमाथि राख्‍नू जसलाई महा-पवित्रस्थानमा राखिन्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","पर्दाबाहिर टेबुललाई उत्तरपट्टि राख्‍नू । पवित्र वासस्थानको दक्षिणपट्टि टेबुलको सामुन्‍ने सामदान राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","पालको प्रवेशद्वारमा एउटा पर्दा बनाउनू । यो निलो, बैजनी, रातो सामग्री, मसिनो गरी बाटेको सुती कपडा र बुट्टा भर्नेको काम भएको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","यस पर्दाको लागि बबुल काठको पाँचवटा खम्बा बनाई तिनलाई सुनले मोहोर्नू । तिनका अङ्कुसे सुनका होऊन् र तिनका लागि काँसाका पाँचवटा आधार होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","तैँले पाँच हात लामो र पाँच हात चौडा भएको बबुल काठको एउटा वेदी बनाउनू । वेदी वर्गाकार हुनुपर्छ र यसको उचाइ तिन हातको हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","त्यसका चारवटै कुनामा गोरुको सिङजस्तो आकार बनाउनू । वेदी र त्यसका सिङहरू एउटै टुक्राबाट बनाउनू, र तिनलाई काँसाले मोहोर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","वेदीको लागि तैँले यी सामग्रीहरू बनाउनूः खरानी उठाउने भाँडाहरू, बेल्चाहरू, बाटाहरू, मासु उठाउने काँटाहरू र आगो राख्‍ने पात्रहरू । यी सबै भाँडाकुँडा काँसाको बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","वेदीको लागि काँसाको जालीको एउटा झिँजा बनाउनू । जालीमाथि ");
INSERT INTO npiulb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","चारै कुनामा काँसाका चारवटा मुन्द्रा लगाउनू । जाली वेदीको बिचसम्मै पुग्‍ने गरी यसलाई वेदीको मुनिपट्टिको बिटमुनि राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदीको लागि बबुल काठका डन्डाहरू बनाउनू, र तिनलाई काँसाले मोहोर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","डन्डाहरूलाई मुन्द्रामा हाल्नू र त्यसलाई उठाउँदा ती डन्डा वेदीका दुवैतिर होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","फल्याकबाट निर्मित वेदी खोक्रो बनाउनू । तँलाई पर्वतमा देखाइएबमोजिम तैँले यसलाई बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","पवित्र वासस्थानको लागि चोक बनाउनू । चोकको दक्षिणपट्टि मसिनो गरी बाटेको सुती कपडाका पर्दाहरू राख्‍नू जसका लमाइ एक सय हात होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","तिनका खम्बाहरू बिसवटा र आधार पनि बिसवटै काँसाका होऊन् । खम्बामा अङ्कुसेहरू र चाँदीका फित्ताहरू होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","त्यसै गरी, उत्तरपट्टि एक सय हात लामो पर्दाहरू होऊन्, अनि तिनका खम्बाहरू बिसवटा र आधारहरू पनि बिसवटा काँसाका होऊन् अनि अङ्कुसेहरू चाँदीका फित्ताहरू पनि गाँसिऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","चोकको पश्‍चिमपट्टि पचास हात लामो पर्दा राख्‍नू । दसवटा खम्बा र दसवटा आधार राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","चोकको पूर्वपट्टि पचास हात होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","प्रवेशद्वारको एकापट्टिको निम्ति पन्ध्र हातका पर्दाहरू होऊन् । तिनका तिनवटा खम्बा र तिनवटै आधार होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अर्कोपट्टि पनि पन्ध्र हातका पर्दाहरू होऊन् । तिनका पनि तिनवटा खम्बा र तिनवटै आधार होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","चोकको द्वारमा राखिने पर्दा बिस हातको होस् । यो पर्दा निलो, बैजनी, रातो धागो र मसिनो गरी बाटेको सुती कपडाको होस् र यो बुट्टा हाल्नेको काम होस् । यसका चारवटा खम्बा र चारवटा आधार होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","चोकका सबै खम्बाका लागि चाँदीका फित्ता, चाँदीकै अङ्कुसे र काँसाका आधारहरू होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","चोकको लमाइ एक सय हात र चौडाइ पचास हातको होस् । यसका पर्दाहरूको उचाइ पाँच हातको होस् । ती पर्दाहरू मसिनो गरी बाटेको सुती कपडाका होऊन् र तिनका आधारहरूचाहिँ काँसाका होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पवित्र वासस्थानमा प्रयोग गरिने सबै सामग्रीसाथै पाल र चोकका सबै किलाहरू काँसाबाट बनेका होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","तैँले इस्राएलका मानिसहरूलाई दियाको निम्ति पेलिएको भद्राक्षको शुद्ध तेल ल्याउन आज्ञा दे ताकि दियाहरू निरन्तर बलिरहून् । ");
INSERT INTO npiulb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","भेट हुने पालमा गवाहीको सन्दुक राखिने पवित्र वासस्थानको पर्दाको अगाडिपट्टि हारून र तिनका छोराहरूले परमप्रभुको सामु साँझदेखि बिहानसम्म दियाहरू बालिरहून् । इस्राएलका मानिसहरूका पुस्तौँसम्म यो रहिरहिने विधि होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","इस्राएलीहरूमध्ये तेरा दाजु हरून र तिनका छोराहरू नादाब, अबीहू, एलाजार र ईतामारले पुजारी भएर मेरो सेवा गर्नलाई तिनीहरूलाई तँकहाँ बोलाएर ले । ");
INSERT INTO npiulb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","तैँले तेरा दाजु हारूनको निम्ति मेरो लागि अलग गरिएका पोशाकहरू लगाउनू । यी पोशाकहरू तिनको गौरव र शोभाको निम्ति हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","मैले बुद्धिको आत्माले भरिपूर्ण पारेका सबै बुद्धिमान् मानिसहरूलाई तैँले भन्‍नू कि तिनीहरूले हारूनका निम्ति पोशाकहरू बनाऊन् जसले तिनलाई मेरो पुजारी भएर सेवा गर्न अलग गरून् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","तिनीहरूले बनाउनुपर्ने पोशाकहरू छाती-पाता, एपोद, अलखा, बुनेको लबेदा, फेटा र पटुका हुन् । तिनीहरूले यी पोशाकहरू बनाऊन् जसले तेरा दाजु हारून र त्यसका छोराहरूलाई मेरो निम्ति अलग गरून् ताकि तिनीहरूले पुजारी भएर मेरो सेवा गर्न सकून् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","शिल्पकारहरूले सुती कपडा, सुन, निलो, बैजनी र रातो धागो प्रयोग गरून् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","तिनीहरूले सुन, निलो, बैजनी र रातो ऊन अनि मसिनो गरी बाटेको सुती कपडाबाट एपोद बनाऊन् । यो सिपालु शिल्पकारको काम होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","यो गाँस्‍नलाई त्यसको दुवै छेउमा गाँसेका दुईवटा काँधे-बन्धन होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","यसको निकै राम्रोसँग बुनिएको कमरपेटी एपोदजस्तै हुनुपर्छ । मसिनो गरी बाटेको सुती कपडा, सुन, निलो, बैजनी र रातो धागोबाट एपोदकै टुक्राबाट यसलाई बनाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","दुईवटा आनिक्स पत्थरलाई लिएर तिनमा इस्राएलका बाह्र जना छोराका नाउँ खोप्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","छोराहरूको जन्मअनुसार एउटा पत्थरमा छ जनाका नाउँ र अर्को पत्थरमा छ जनाका नाउँ खोप्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","छापमा खोप्‍ने शिल्पकारले झैँ तैँले यो दुईवटा पत्थरमा इस्राएलका बाह्र जना छोराका नाउँ खोप्‍नू । ती पत्थर सुनका रत्‍न जडिने मणिघरमा जड्न लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","परमप्रभुलाई इस्राएलका छोराहरूको सम्झना दिलाउन ती दुईवटा पत्थरलाई एपोदका काँधे-बन्धनमा लगाउनू । उहाँलाई सम्झना दिलाउन हारूनले परमप्रभुको सामु तिनीहरूका नाउँलाई बोकेर लैजानेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","तैँले सुनका मणिघरहरू ");
INSERT INTO npiulb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","र डोरीजस्ता बाटेका निखुर सुनका दुईवटा सिक्री बनाउनू, र ती सिक्रीहरूलाई मणिघरहरूमा लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","निर्णय गर्नलाई एउटा छाती-पाता बनाउनू । एपोदको बनावटजस्तै यो पनि सिपालु शिल्पकारको काम होस् । सुन, निलो, बैजनी र रातो ऊन र सुतीको कपडाबाट यसलाई बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","यो वर्गाकार र दोब्बर पट्ट्याइएको हुनुपर्छ । यसको लमाइ र चौडाइ एक-एक बित्ताको होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","तैँले यसमा बहुमूल्य पत्थरका चारवटा लहर गरी मणीहरू राख्‍नू । पहिलो लहरमा मानिक, पुष्पराज र बेरूज राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दोस्रो लहरमा फिरोजा, नीर र पन्‍ना राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तेस्रो लहरमा नीलमणि, हाकिक र कटेला राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथो लहरमा पीतमणि, आनिक्स र बिल्लौर राख्‍नू । ती सुनका मणिघरहरूमा जडिऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ती मणिहरू इस्राएलका बाह्र छोराका नाउँअनुसार क्रमैसँग होऊन् । छाप-औँठीमा खोपेजस्तै हरेक नाउँले बाह्र कुलका हरेक कुलको प्रतिनिधित्व गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","छाती-पातामा डोरीजस्तो बाटेको निखुर सुनका सिक्रीहरू बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","छाती-पाताको लागि सुनका दुईवटा मुन्द्री बनाउनू र तिनलाई छाती-पाताका दुईवटै किनारामा लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","सुनका दुईवटा सिक्रीलाई छाती-पाताका किनाराहरूमा लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","बाटेका दुईवटा सिक्रीका अर्का दुईवटा छेउलाई दुवै मणिघरमा जोड्नू । त्यसपछि ती दुईवटालाई एपोदको काँधे-बन्धनको अगाडिपट्टि लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","सुनका दुईवटा मुन्द्री बनाउनू, र भित्रपट्टिको बिटको छेउमा तिनलाई छाती-पाताका अर्का दुईवटा कुनामा लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","तैँले थप दुईवटा सुनका मुन्द्री बनाउनू, र तिनलाई एपोदको अगाटिपट्टि दुवै काँधे-बन्धनका मुनिबाट र एपोदको निकै राम्ररी बुनेको कमरपेटीमाथिको सिउनीनेर लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","छाती-पाता त्यसका मुन्द्रीहरूद्वारा एपोदका मुन्द्रीहरूमा निलो फित्ताले कमरपेटीमा बाँध्‍नू ताकि त्यो बुनिएको एपोददेखि सर्न नपाओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","हारून पवित्रस्थानमा जाँदा त्यसले परमप्रभुको सामु निरन्तर सम्झनाको निम्ति आफ्नो छातीमा निर्णय गर्न राखिने छाती-पातामा इस्राएलका मानिसहरूका नाउँ बोकोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","निर्णय गर्नलाई छाती-पातामा ऊरीम र तुम्मीम राख्‍नू ताकि हारून परमप्रभुको सामु जाँदा ती त्यसको छातीमा होस् । यसरी हारूनले इस्राएलका मानिसहरूका लागि निर्णय गर्ने माध्यमलाई परमप्रभुको सामु सधैँ आफूसितै बोकोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","तैँले एपोदको अलखा पूर्ण रूपमा निलो कपडाको बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","यसको बिचमा टाउको छिराउने प्वाल बनाउनू । नच्यातियोस् भन्‍नाका लागि कठालोको प्वालजस्तै बुनेको बिट होस् । यो जुलाहाको काम होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","तलको फेरोको चारैतिर निलो, बैजनी र रातो धागोका दारिमहरू बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","तिनको वरिपरि बिच-बिचमा सुनका घण्टीहरू बनाउनू । अलखाको फेरोको चारैतिर सुनका घण्टीहरू र दारिमहरू होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारूनले सेवा गर्दा त्यसले अलखा लगाओस् ताकि त्यो पवित्रस्थानमा परमप्रभुको सामु जाँदा र त्यहाँबाट आउँदा यसको आवाज सुनियोस् । त्यो नमरोस् भन्‍नाका लागि यसो गरिएको हो । ");
INSERT INTO npiulb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","तैँले निखुर सुनको एउटा पाता बनाउनू, र यसमा छापमा खोपेजस्तै गरी “परमप्रभुको निम्ति पवित्र” भनी खोप्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","यस पातालाई निलो फित्ताले फेटाको अगाडिपट्टि बाँध्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","यसलाई हारूनको निधारमा राख्‍नू । इस्राएलीहरूले परमप्रभुको निम्ति अलग गर्ने पवित्र उपहारका भेटीहरूको दोष हारूनले सधैँ बोकोस् । परमप्रभुले तिनीहरूका उपहारहरू ग्रहण गरून् भन्‍नाका लागि फेटा सधैँ त्यसको निधारमा होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","तैँले मसिनो सुती कपडाबाट लबेदा बनाउनू, र फेटा पनि सुती कपडाबाट नै बनाउनू । पटुकाचाहिँ बुट्टा हाल्नेद्वारा बनाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","हारूनका छोराहरूका गौरव र शोभाका लागि लबेदा, पटुका र फेटाहरू बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","तैँले तेरा दाजु हारून र त्यसका छोराहरूलाई यी पोशाकहरू पहिराइदिनू । पुजारी भएर मेरो सेवा गरून् भनेर तैँले तिनीहरूलाई अभिषेक गर्नू, नियुक्त गर्नू र मेरो निम्ति अलग गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","तिनीहरूका नग्‍नता ढाक्‍नलाई सुतीका भित्री पोशाकहरू बनाउनू जसले तिनीहरूको कम्मरदेखि जाँघसम्म ढाकून् । ");
INSERT INTO npiulb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","हारून र त्यसका छोराहरू पवित्रस्थानमा सेवा गर्नका लागि वेदीमा जाँदा वा भेट हुने पालमा प्रवेश गर्दा तिनीहरूले यी पोशाकहरू लगाऊन् । तिनीहरू दोषी ठहरिएर नमरून् भन्‍नाका लागि तिनीहरूले यी लगाउनैपर्छ । हारून र त्यसपछि त्यसका सन्तानहरूका लागि यो स्थायी विधि हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","तिनीहरूले पुजारी भएर मेरो सेवा गरून् भनेर तिनीहरूलाई मेरो लागि अलग गर्न तैँले गर्नुपर्ने काम यही हो । एउटा बाछा र दुईवटा निष्खोट भेडा लिएर आइज । ");
INSERT INTO npiulb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","अखमिरी रोटी र खमिर नहाली तेलमा मुछेको फुरौला अनि तेल दलेको खमिरविनाको बाबर पनि लिएर आइज । ");
INSERT INTO npiulb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","बाबरहरू मसिनो गहुँको पिठोको प्रयोग गरी बनाउनू । तिनीहरूलाई एउटा टोकरीमा हालेर साँढे र दुईवटा भेडासँगै ती ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","तैँले भेट हुने पालको प्रवेशद्वारमा हारून र त्यसका छोराहरूलाई उपस्थित गरा । हारून र त्यसका छोराहरूलाई पानीले नुहाइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","आफूसित पोशाकहरू लैजा र हारूनलाई लबेदा, एपोदको अलखा, एपोद, छाती-पाता अनि राम्ररी बुनेको एपोदको कमरपेटी लगाइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","त्यसको शिरमा फेटा लगाइदिनू, र फेटामाथि पवित्र मुकुट पहिराइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","त्यसपछि अभिषेक गर्ने तेल लिएर जा अनि त्यसको शिरमा खन्याइदिएर त्यसलाई अभिषेक गर् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","त्यसका छोराहरूलाई ल्याएर तिनीहरूलाई लबेदाहरू लगाइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","हारून र त्यसका छोराहरूलाई पटुका र फेटाहरू लगाइदिनू । पुजारी पद तिनीहरूका लागि सदाको विधि हो । यसरी तैँले हारून र त्यसका छोराहरूलाई मेरो सेवा गर्न अभिषेक गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","तिमीहरू सबैले भेट हुने पालको सामु बाछो ल्याउनू, अनि हारून र त्यसका छोराहरूले त्यसको टाउकोमाथि हात राख्‍नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तैँले भेट हुने पालको प्रवेशद्वारमा परमप्रभुको सामु त्यस बाछोलाई मार्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","बाछोको थोरै रगत लिएर तेरो औँलाले वेदीका सिङहरूमा छर्की, अनि बाँकी रगत वेदीको आधारमा खन्याइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","आन्द्रा-भुँडी ढाक्‍ने सबै बोसो र कलेजो ढाक्‍ने मासु अनि दुईवटा मिर्गोलासाथै तिनमा भएका बोसोसमेत लिएर ती सबैलाई वेदीमा जलाइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","तर बाछोको मासु, यसको छाला र गोबरचाहिँ छाउनीबाहिर लगेर जलाइदिनू । यो पापबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","तैँले एउटा भेडा पनि लिनू अनि हारून र त्यसका छोराहरूले त्यसको टाउकोमाथि आ-आफ्ना हात राखून् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","भेडालाई मारेर त्यसको रगत वेदीका चारैतिर छर्कनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","त्यस भेडालाई टुक्रा-टुक्रा पारेर त्यसका आन्द्राभुँडी र खुट्टाहरूलाई धुनू अनि ती आन्द्राभुँडी, त्यसका टुक्राहरू र टाउकोसमेत ");
INSERT INTO npiulb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","वेदीमा राखिदिनू । त्यसपछि सिङ्गै भेडालाई जलाउनू । यो परमप्रभुलाई आगोद्वारा चढाइने मिठो बास्‍ना भएको होमबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","त्यसपछि तैँले अर्को भेडा लिनू, अनि हारून र त्यसका छोराहरूले त्यसको टाउकोमाथि आ-आफ्ना हात राखून् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","अनि तैँले भेडालाई मारेर त्यसको थोरै रगत लिई हारूनको दाहिने कान, त्यसका छोराहरूका दाहिने कानहरू, तिनीहरूका दाहिने हातका बुढी औँला र तिनीहरूका खुट्टाका बुढी औँलामा लगाइदिनू । त्यसपछि रगत वेदीको हरेक किनाराको वरिपरि छर्किदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","तैँले वेदीमा भएको थोरै रगत र थोरै अभिषेक गर्ने तेल लिएर त्यसलाई हारून र त्यसका पोशाकहरू अनि त्यसका छोराहरू र तिनीहरूका पोशाकहरूमा छर्किदे । तब हारून र त्यसका पोशाकहरू, त्यसका छोराहरूसाथै त्यसका छोराहरूका पोशाकहरू मेरो लागि अलग गरिनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","तैँले भेडाको बोसो, बोसे पुच्छर, आन्द्रभुँडी ढाक्‍ने बोसो, कलेजोको मासु, दुईवटा मिर्गौला र तिनमा भएका बोसो अनि दाहिने साँप्रो लिनू किनकि यो भेडा मेरो लागि पुजारीको अर्पणको लागि हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","परमप्रभुको सामु भएको खमिर नहालेको रोटीको टोकरीबाट एउटा रोटी, तेलमा पोलेको एउटा फुरौला र एउटा बाबर लिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","तैँले यी सबै हारूनका हात र त्यसका छोराहरूका हातमा राखिदिनू अनि परमप्रभुको सामु डोलाइने बलिको लागि मेरो सामु डोलाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","त्यसपछि तिनीहरूका हातबाट खाना लिएर होमबलिसँगै वेदीमा तिनलाई जलाइदिनू । यसले मलाई मिठो बास्‍ना दिनेछ । यो मेरो लागि आगोद्वारा चढाइने बलि हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","हारूनको अर्पणको भेडाको ह्याकुलो लिएर यसलाई परमप्रभुको सामु डोलाइने बलिको रूपमा डोलाउनू, र योचाहिँ तेरो भाग हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","तैँले हारून र त्यसका छोराहरूका निम्ति दिइएको डोलाइने बलिको ह्याकुलो र साँप्रो मेरो लागि अलग गर् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","यो हारून र त्यसका छोराहरूका लागि अनन्तको विधि हुनेछ । इस्राएलका मानिसहरूले तिनीहरूका मेलबलिबाट परमप्रभुलाई दिनुपर्ने भाग यही हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","हारूनपछि त्यसका पवित्र पोशाकहरू त्यसका छोराहरूका लागि सुरक्षित राख्‍नू । तिनीहरू तिनमा अभिषेक गरिएर तिनीहरूलाई मेरो निम्ति नियुक्त गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","हारूनपछि त्यसका छोराहरूमध्ये पुजारी हुनेचाहिँ पवित्रस्थानमा मेरो सेवा गर्न भेट हुने पालमा आउँदा त्यसले सात दिनसम्म ती पोशाकहरू लगाओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","मेरो निम्ति पुजारीहरूको नियुक्ति गर्दा तैँले भेडा लिई त्यसको मासुलाई पवित्रस्थानमा उमाल्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","हारून र त्यसका छोराहरूले भेट हुने पालको प्रवेशद्वारमा भेडाको मासु र टोकरीमा भएको रोटी खाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","मेरो निम्ति अलग गर्नका निम्ति तिनीहरूलाई प्रायश्‍चित्त गर्न र नियुक्त गर्न तिनीहरूलाई दिइएका मासु, रोटी तिनीहरूले खाऊन् । त्यो खाना कसैले नखाओस् किनकि त्यो मेरो निम्ति अर्पण गरिएको र मलाई छुट्ट्याइएको खाना हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","अर्पण बलिको कुनै पनि खाना वा रोटी भोलिपल्ट बिहानसम्म रह्‍यो भने त्यसलाई जलाइदिनू । यो मेरो लागि अलग गरिएकोले यसलाई खानुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","यसरी मैले तँलाई आज्ञा गरेका सबै कुराबमोजिम हारून र त्यसका छोराहरूलाई गर्नू । तैँले सात दिन लगाएर तिनीहरूलाई तयार पार्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","हरेक दिन प्रायश्‍चित्तको लागि तैँले एउटा बाछो पापबलिको रूपमा चढाउनू । वेदीको लागि प्रायश्‍चित्त गरेर तैँले यसलाई शुद्ध पार्नू, र यसलाई मेरो लागि अलग गर्न यसलाई अभिषेक गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिन लगाएर वेदीको लागि प्रायश्‍चित्त गर्नू अनि त्यसलाई परमप्रभुको निम्ति अलग गर्नू । तब वेदी मेरो लागि पूर्ण रूपमा पवित्र हुनेछ । वेदीलाई छुने जुनसुकै कुरो परमप्रभुको लागि पवित्र हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","तैँले हरेक दिन वेदीमा नियमित रूपमा एक-वर्षे दुईवटा थुमा चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एउटा थुमा बिहान चढाइनुपर्छ भने अर्को बेलुका । ");
INSERT INTO npiulb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","पहिलो थुमासँगै एक लिटर पेलेको भद्राक्षको तेलमा मुछेको आधा पाथी मसिनो पिठो र अर्घबलिको रूपमा एक लिटर दाखमद्य चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","तैँले दोस्रो थुमा बेलुकी चढाउनू । बिहानजस्तै अन्‍नबलि र अर्घबलि पनि चढाउनू । यी कुराहरूले मेरो लागि मिठो बास्‍ना ल्याउनेछन् । यो मेरो लागि आगोद्वारा चढाइने बलि हो । ");
INSERT INTO npiulb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","मैले तिमीहरूसित बातचित गर्ने परमप्रभुको सामु भेट हुने पालको प्रवेशद्वारमा तिमीहरूका पुस्ता-पुस्तासम्म यी नियमित होमबलिहरू होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","म इस्राएलीहरूसित त्यहीँ नै भेट गर्नेछु । मेरो महिमाद्वारा पाल मेरो लागि अलग गरिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","म भेट हुने पाल र मेरो लागि मात्र प्रयोग हुने वेदीलाई पवित्र पार्नेछु । पुजारी भएर मेरो सेवा गर्नका निम्ति हारून र त्यसका छोराहरूलाई पनि म पवित्र पार्नेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","म इस्राएलीहरूका बिचमा बस्‍नेछु र तिनीहरूका परमेश्‍वर हुनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","म तिनीहरूका बिचमा बस्‍न सकूँ भनेर तिनीहरूलाई मिश्र देशबाट बाहिर ल्याउने परमप्रभु तिनीहरूका परमेश्‍वर हुँ भनी तिनीहरूले जान्‍नेछन् । म परमप्रभु तिनीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","तैँले धूप बाल्नलाई बबुल काठबाट एउटा वेदी बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","यसको लमाइ एक हात र चौडाइ एक हातको होस् । यो वर्गाकार हुनुपर्छ र यसको उचाइ दुई हातको हुनुपर्छ । यसका सिङहरू त्यही एउटै टुक्रा काठबाट बनाइएका होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","धूप वेदीको माथिल्लो भाग, यसका किनाराहरू र सिङहरू सबै नै निखुर सुनले मोहोरिऊन् । यसको चारैतिर सुनको बिट लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","यसको बिटमुनि वेदीका दुवै पाटामा सुनका दुईवटा मुन्द्रा बनाएर त्यसका दुवैतिर लगाउनू, र बोक्‍ने डन्डाहरूका लागि ती मुन्द्राचाहिँ घर होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","डन्डाहरू बबुल काठबाट बनाएर तिनलाई सुनले मोहोर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","तैँले धुपको वेदीलाई गवाहीको सन्दुकनेर भएको पर्दाको सामुन्‍ने राख्‍नू । यो मैले तँलाई भेट्ने गवाहीको सन्दुकमाथि राखिएको प्रायश्‍चित्तको ढकनीको सामु हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","हारूनले हरेक बिहान सुगन्धित धूप बाल्नू । त्यसले दियाहरूको रेखदेख गर्दा यसलाई बाल्नू, ");
INSERT INTO npiulb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","र पुस्ता-पुस्तासम्म परमप्रभुको सामु नियमित रूपमा धूप बलिरहोस् भनेर हारूनले हरेक साँझमा दियाहरू बाल्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","तर त्यस धूपको वेदीमा तैँले अरू किसिमका धूप नबाल्नू, न त कुनै होमबलि वा अन्‍नबलि चढाउनू । यसमाथि कुनै अर्घबलि नचढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","वर्षको एक चोटि हारूनले यसका सिङहरूमा प्रायश्‍चित्त गरोस् । पापबलिको रगतले पुस्ता-पुस्तासम्म त्यसले वर्षको एक चोटि प्रायश्‍चित्त गर्नेछ । यो परमप्रभुको निम्ति अति पवित्र छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“तैँले इस्राएलीहरूको जनगणना लिँदा हरेक व्यक्तिले परमप्रभुको निम्ति आफ्नो जीवनको मोल तिरोस् । तैँले तिनीहरूको गणना गरिसकेपछि यसो गर्नू ताकि जनगणना गर्दा तिनीहरूका बिचमा कुनै विपत्ति नआओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","जनगणनामा गन्ती भएको हरेकले पवित्रस्थानको शेकेलको नापअनुसार चाँदीको आधा शेकेल तिरोस् (एक शेकेल बराबर बिस गेरा हुन्छ) । यो आधा शेकेल परमप्रभुको निम्ति भेटी हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","बिस वर्षभन्दा माथिको गन्ती हुने हरेकले मलाई यो भेटी दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","मानिसहरूले आ-आफ्ना जीवनको प्रायश्‍चित्तको लागि मलाई यो भेटी दिँदा धनीहरूले आधा शेकेलभन्दा बढी नदेऊन् न त गरिबहरूले कम देऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","तैँले इस्राएलीहरूबाट यो प्रायश्‍चित्तको पैसा लिएर यसलाई भेट हुने पालको कामको लागि छुट्ट्याउनुपर्छ । यो इस्राएलीहरूका जीवनको निम्ति प्रायश्‍चित्त गर्न मेरो सामु तिनीहरूको सम्झना होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“तैँले धुनलाई काँसाको एउटा ठुलो बाटा बना । यो भेट हुने पाल र वेदीको बिचमा होस् र यसमा पानी राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून र त्यसका छोराहरूले यो पानीले तिनीहरूका हात र खुट्टा धोऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","तिनीहरू आगोद्वारा चढाइने बलि लिएर मेरो सेवा गर्न भेट हुने पालमा जाँदा वा वेदीको नजिक जाँदा तिनीहरू नमरून् भनेर तिनीहरूले पानीले धुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","तिनीहरू नमरून् भनेर तिनीहरूले आ-आफ्ना हातगोडा धोऊन् । हारून र त्यसका मानिसहरूका पुस्ता-पुस्ताका लागि यो एउटा स्थायी विधि हो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“तैँले यी असल-असल मसलाहरू अर्थात् ५०० शेकेल तरल मूर्र, २५० शेकेल बास्‍ना आउने दालचिनी, २५० शेकेल बास्‍ना आउने बोझो, ");
INSERT INTO npiulb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","५०० शेकेल तेजपात– सबैको नाप पवित्रस्थानको हिसाबले– र एक हीन भद्राक्षको तेल लिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","तैँले यी सामग्रीहरूबाट अभिषेक गर्ने पवित्र तेल अर्थात् सुगन्धित मसला बनाउनू । यो मेरो लागि सुरक्षित अभिषेक गर्ने पवित्र तेल हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","तैँले यस तेलले भेट हुने पालसाथै गवाहीको सन्दुक, ");
INSERT INTO npiulb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","टेबुल र यसका सबै भाँडाकुँडा, सामदान र यसका सामान, धूपको वेदी, ");
INSERT INTO npiulb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होमबलि चढाउने वेदीलगायत यसका सबै सामान र धुनलाई प्रयोग गरिने बाटालाई अभिषेक गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ती मेरो लागि पवित्र होऊन् भनेर तिनलाई मेरो लागि अलग गर्नू । तिनलाई छुने कुनै पनि कुरो पनि पवित्र हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","हारून र त्यसका छोराहरूले पुजारी भएर मेरो सेवा गरून् भनेर तैँले तिनीहरूलाई मेरो निम्त अलग गर् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","तैँले इस्राएलीहरूलाई भन्‍नू, “तिमीहरूका मानिसहरूका पुस्ता-पुस्तासम्म यो परमप्रभुको निम्ति अलग गरिएको अभिषेक गर्ने तेल होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यसलाई मानिसको छालामा दल्नुहुँदैन, न त उही सुत्र प्रयोग गरेर यस्तो तेल बनाउनुहुन्छ किनकि यो परमप्रभुको निम्ति अलग गरिएको हो । तैँले यसलाई यसरी नै हेर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जसले यस्तो अत्तर बनाउँछ वा जसले अरू कसैको शरीरमा यसलाई लगाइदिन्छ त्यो व्यक्ति तिमीहरूको जातिबाट बहिष्कृत हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","परमप्रभुले मोशालाई भन्‍नुभयो, “बराबरी परिमाणमा शुद्ध सेतो-धूपसहित खोटो, सेखलेट र हिङजस्तै चोपजस्ता सुगन्धित मसलाहरू लिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","नुन मिसिएको शुद्ध र पवित्र हुने गरी धूपको रूपमा अत्तर बनाउनेले जस्तै गरी त्यसलाई बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","तैँले यसलाई मसिनो गरी पिस्‍नू । यसको थोरै भागलाई मैले तँसित भेट गर्ने भेट हुने पालमा राखिने गवाहीको सन्दुकको सामुन्‍ने राख्‍नू । तैँले यसलाई मेरो लागि अति पवित्र ठान्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","तैँले बनाउने यो धूपजस्तै उही सुत्र प्रयोग गरेर आफ्नो लागि अर्को कुनै धूप नबनाउनू । यो मेरो लागि अति पवित्र होस् । ");
INSERT INTO npiulb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","अत्तरको रूपमा प्रयोग गर्न जसले योजस्तै कुनै धूप बनाउँछ, त्यो आफ्नो जातिबाट बहिष्कृत हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“हेर्, मैले यहूदाको कुलबाट हूरको नाति, ऊरीको छोरो बजलेललाई डाकेको छु । ");
INSERT INTO npiulb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","सबै किसिमका कारीगरीको काम गर्नका लागि त्यसलाई बुद्धि, समझशक्ति, ज्ञान दिन मेरा आत्माले भरिपूर्ण पारेको छु । ");
INSERT INTO npiulb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","त्यसले सुन, चाँदी, काँसाका कलापूर्ण रचनाहरू बनाउनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","सबै किसिमका कारीगरीका काम गर्न त्यसले पत्थर काट्ने, जड्ने र काठ खोप्‍ने गर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","त्योबाहेक मैले दानको कुलबाट अहीसामाकको छोरो ओहोलीआबलाई नियुक्त गरेको छु । मैले तिनीहरूलाई आज्ञा गरेमुताबिक तिनीहरूले बनाउन सकून् भनेर सबै बुद्धिमानीहरूका ह्रदयमा मैले सिप हालिदिएको छु । तिनीहरूले बनाउने सामग्रीहरू यिनै हुन्: ");
INSERT INTO npiulb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","भेट हुने पाल, गवाहीको सन्दुक, सन्दुकमाथि राखिने प्रायश्‍चित्तको ढकनी, पालका सबै सरसामान अर्थात् ");
INSERT INTO npiulb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","टेबुल र यसका भाँडाकुँडाहरू, शुद्ध सामदानसहित यसका सबै सामान, धूपको वेदी, ");
INSERT INTO npiulb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमबलिको लागि वेदीसहित यसका सबै सामान र आधार भएको ठुलो बाटा । ");
INSERT INTO npiulb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","यसमा राम्ररी बुनेको पोशाकहरू अर्थात् हारून पुजारी र त्यसका छोराहरूका निम्ति पवित्र पोशाकहरू पनि पर्छन् । पुजारी भएर मेरो सेवा गरून् भनेर तिनीहरू मेरो लागि अलग गरिएका हुन् । ");
INSERT INTO npiulb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","पवित्रस्थानको लागि अभिषेक गर्ने तेल र सुगन्धित धूप पनि यसमा पर्छन् । मैले तँलाई आज्ञा गरेबमोजिम यी कारीगारहरूले यी सबै थोक बनाऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","तब परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इस्राएलीहरूलाई भन्, 'तिमीहरूले निश्‍चय नै परमप्रभुको शबाथ-दिन मान्‍नू किनकि तिमीहरूका मानिसहरूका पुस्ता-पुस्तासम्म यो तिमीहरू र मेरो बिचमा एउटा चिन्ह हुनेछ ताकि तिमीहरूलाई मेरो निम्ति अलग गर्ने परमप्रभु म नै हुँ भनी तिमीहरूले जान्‍नेछौ । ");
INSERT INTO npiulb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","त्यसैले तिमीहरूले शबाथ मान्‍नू किनभने यो मेरो लागि अलग गरिएको तिमीहरूद्वारा मान्‍नुपर्ने पवित्र दिन हो । यसलाई अशुद्ध गर्ने कुनै पनि व्यक्ति निश्‍चय नै मारिनेछ । जसले शबाथमा काम गर्छ, त्यो व्यक्ति निश्‍चय नै आफ्नो जातिबाट बहिष्कृत हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छ दिनसम्म काम गर्नू, तर सातौँचाहिँ दिन परमप्रभुको सामु पूर्ण विश्रामको पवित्र शबाथ हुनेछ । शबाथ-दिनमा काम गर्ने जोसुकै पनि निश्‍चय मारिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","त्यसकारण, इस्राएलीहरूले शबाथलाई मान्‍नैपर्छ । एउटा स्थायी विधिको रूपमा तिनीहरूका पुस्तौँ-पुस्तासम्म तिनीहरूले यसको पालना गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","शबाथ सधैँ म परमप्रभु र इस्राएलीहरूका बिचमा एउटा चिन्ह हुनेछ किनकि छ दिनमा परमप्रभुले स्वर्ग र पृथ्वी बनाउनुभयो अनि सातौँ दिनमा चाहिँ उहाँले कामबाट विश्राम लिनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","सिनै पर्वतमा परमप्रभु मोशासित बोलिसक्‍नुभएपछि उहाँले तिनलाई आफ्नै हातले लेखेका करारका दुईवटा शिला-पाटी दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब मानिसहरूले मोशा पर्वतबाट आउन ढिलाइ गरेको देखे तिनीहरू हारूनको वरिपरि भेला भई तिनलाई भने, “हाम्रो अगिअगि जाने एउटा मूर्ति बनाऔँ । हामीलाई मिश्र देशबाट बाहिर ल्याउने मोशालाई के भयो हामी जान्दैनौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","त्यसैले हारूनले तिनीहरूलाई भने, “तिमीहरूका पत्‍नीहरू र छोराछोरीहरूका कानमा भएका सुनका कुण्डलहरू फुकाली मकहाँ लेओ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","सबै मानिसले तिनीहरूका कानमा लगाएका कुण्डलहरू फुकाली हारूनकहाँ ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","तिनले तिनीहरूबाट पाएको सुनलाई हतियारले खोपेर बाछाको एउटा मूर्ति बनाए । तब मानिसहरूले भने, “हे इस्राएल हो, मिश्रबाट तिमीहरूलाई बाहिर निकालेर ल्याउने देव यिनै हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","हारूनले यो देखेपछि तिनले बाछाको सामु एउटा वेदी बनाए र यस्तो घोषणा गरे, “भोलि परमप्रभुको आदरको लागि एउटा चाड हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","भोलिपल्ट मानिसहरू सबेरै उठे र तिनीहरूले होमबलि र मेलबलि चढाए । तब तिनीहरू खान र पिउनलाई बसे अनि मोजमा डुब्‍न लागे । ");
INSERT INTO npiulb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब परमप्रभुले मोशालाई भन्‍नुभयो, “चाँडै तल ओर्ली, किनकि तैँले मिश्र देशबाट बाहिर ल्याएका मानिसहरूले आफैलाई भ्रष्‍ट पारिसकेका छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","मैले आज्ञा गरेको मार्गबाट तिनीहरू चाँडै नै विचलित भएका छन् । तिनीहरूले आफ्ना लागि गाईको मूर्ति बनाएर यसको पूजा गरेका छन् र बलिदान चढाएका छन् । तिनीहरूले भनेका छन् 'हे इस्राएल हो, मिश्र देशबाट तिमीहरूलाई बाहिर ल्याउने देव यिनै हुन्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","तब परमप्रभुले मोशालाई भन्‍नुभयो, “मैले यो जातिलाई देखेको छु । हेर्, तिनीहरू हठी मानिसहरू हुन् । ");
INSERT INTO npiulb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","अब मलाई रोक्‍ने कोसिस नगर् । मेरो क्रोध तिनीहरूको विरुद्धमा दन्कनेछ । त्यसैले म तिनीहरूलाई नष्‍ट गर्नेछु । तब म तँबाट नै एउटा ठुलो जाति बनाउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तर मोशाले परमप्रभु तिनका परमेश्‍वरलाई शान्त पार्न खोजे । तिनले भने, “हे परमप्रभु, आफ्नो ठुलो सामर्थ्य र शक्तिशाली हातले मिश्र देशबाट तपाईंले बाहिर ल्याउनुभएका यी मानिसहरूको विरुद्ध तपाईंको क्रोध किन दन्किने? ");
INSERT INTO npiulb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","मिश्रीहरूले किन यसो भन्‍ने, 'तिनीहरूलाई पर्वतमा लगेर मार्न र पृथ्वीको सतहबाट नष्‍ट गर्न उहाँले तिनीहरूलाई दुष्‍ट मनसाय लिएर बाहिर निकाल्नुभयो?' आफ्नो क्रोधलाई शान्त पार्नुहोस् र यो जातिलाई दण्ड दिनबाट मन बद्लनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तपाईंका दासहरू अब्राहाम, इसहाक र इस्राएललाई सम्झनुहोस् जसलाई तपाईंले आफ्नै खातिर यसो भनेर शपथ खानुभएको थियो, 'म तिमीहरूका सन्तानहरूलाई आकाशको ताराजत्तिकै बढाउनेछु र मैले तिमीहरूका सन्तानहरूलाई दिने भनेका यी सबै देश दिनेछु । तिनीहरूले सदाको लागि यसको अधिकार गर्नेछन्' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब आफ्नो जातिलाई हानि गर्नदेखि परमप्रभुले आफ्नो मन बद्लनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मोशा फर्केर आफ्ना हातमा करारका दुईवटा शिला-पाटी लिएर पर्वतबाट तल ओर्ले । शिला-पाटीहरूका अगाडि र पछाडि दुवैपट्टि लेखिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ती शिला-पाटीहरू परमेश्‍वरका आफ्नै काम थिए, र त्यो उहाँले नै खोपेर लेख्‍नुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","यहोशूले मानिसहरू चिच्‍च्याइरहेको आवाज सुनेपछि तिनले मोशालाई भने, “छाउनीमा त लडाइँको आवाज पो सुनिँदै छ त ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","तर मोशाले भने, “यो विजेताको आवाज होइन, न त पराजितहरूको आवाज हो, तर म त गीत गाइरहेको आवाज सुन्दै छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","जब मोशा छाउनी नजिक आइपुगे तिनले बाछो र मानिसहरू नाचिरहेका देखे । तिनी बेसरी रिसाए । तिनले आफ्ना हातबाट ती शिला-पाटीहरू फालिदिए, पर्वतको फेदीमा नै फुटाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तिनले मानिसहरूले बनाएका त्यस बाछोलाई लिएर जलाइदिए अनि धुलोपिठो बनाएर पानीमा छरिदिए, अनि तिनले इस्राएलका मानिसहरूलाई त्यो पिउन लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","तब मोशाले हारूनलाई भने, “यी मानिसहरूले तपाईंलाई के गरे जसले गर्दा तपाईंले तिनीहरूमाथि यति ठुलो पाप ल्याउनुभयो?” ");
INSERT INTO npiulb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारूनले भने, “मेरा मालिक, ममाथि हजुरको क्रोध नदन्कियोस् । तपाईं त यी मानिसहरूलाई जान्‍नुहुन्छ कि तिनीहरू खराबी गर्न उद्यत छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","तिनीहरूले मलाई भने, 'हाम्रो अगिअगि जाने एउटा देव बनाऊ । हामीलाई मिश्र देशबाट बाहिर निकालेर ल्याउने मोशालाई के भयो हामी जान्दैनौँ ।' ");
INSERT INTO npiulb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","तब मैले तिनीहरूलाई भनेँ, 'जो-जोसँग सुन छ, तिनीहरूले फुकालून् ।' तिनीहरूले मलाई सुन दिए र मैले त्यसलाई आगोमा फाल्दा यही बाछो बनेर आयो ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मानिसहरू छाडा भइसकेका थिए भनी मोशाले देखे (किनकि हारूनले तिनीहरूका शत्रुहरूका सामु हाँसोको पात्र हुन दिएर तिनीहरूलाई अनियन्त्रित हुन छाडिदिएका थिए) । ");
INSERT INTO npiulb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","तब मोशा छाउनीको प्रवेशद्वारमा खडा भएर भने, “जो-जो परमप्रभुपट्टि छन्, तिनीहरू मकहाँ आओ ।” सबै लेवी तिनको वरिपरि भेला भए । ");
INSERT INTO npiulb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","तिनले तिनीहरूलाई भने, “परमप्रभु इस्राएलका परमेश्‍वर यसो भन्‍नुहुन्छ, 'हरेकले आ-आफ्नो तरवार भिरेर छाउनीको एक छेउदेखि अर्को छेउसम्म ढोका-ढोकासम्म गएर हरेकले आफ्ना भाइ, आफ्ना मित्र र छिमेकीलाई मार' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मोशाले आज्ञा गरेमुताबिक लेवीहरूले गरे । त्यस दिन करिब तिन हजार मानिस मरे । ");
INSERT INTO npiulb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","मोशाले लेवीहरूलाई भने, “आज तिमीहरू परमप्रभुको सेवामा राखिएका छौ किनकि आज परमप्रभुले तिमीहरूलाई आशिष् देऊन् भनेर तिमीहरू हरेकले आ-आफ्ना छोरा र भाइको विरुद्धमा कारबाही गरेका छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","भोलिपल्ट मोशाले मानिसहरूलाई भने, “तिमीहरूले भयङ्कर ठुलो पाप गरेका छौ । अब म परमप्रभुकहाँ उक्लेर जानेछु । सायद मैले तिमीहरूको पापको लागि प्रायश्‍चित्त गर्न सक्छु कि ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","मोशा परमप्रभुकहाँ फर्केर आए र भने, “हाय! यी मानिसहरूले ठुलो पाप गरेका छन् र तिनीहरूले सुनको मूर्ति बनाएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","तर अब तिनीहरूका पाप क्षमा गरिदिनुहोस् । क्षमा गर्नुहुन्‍न भनेता तपाईंले लेख्‍नुभएको पुस्तकबाट मेरो नाउँ मेटिदिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","परमप्रभुले मोशालाई भन्‍नुभयो, “जसले मेरो विरुद्धमा पाप गरेको छ, म मेरो पुस्तकबाट त्यसकै नाउँ मेटिदिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब, गएर मैले तँलाई भनेको स्थानमा यी मानिसहरूलाई अगुवाइ गरेर लैजा । हेर्, मेरा दूत तेरो अगिअगि जानेछन् । तर त्यस दिन तिनीहरूका पापका लागि म तिनीहरूलाई दण्ड दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","हारूनले बनाएको बाछोको कारण परमप्रभुले मानिसहरूमाथि विपत्ति ल्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","तब परमप्रभुले मोशालाई भन्‍नुभयो, “मिश्र देशबाट तैँले ल्याएका मानिसहरूसँगै यहाँबाट जा । त्यो देशमा जा जसको विषयमा 'म तेरा सन्तानहरूलाई यो दिनेछु' भनी अब्राहाम, इसहाक, र याकूबसित मैले शपथ खाएको थिएँ । ");
INSERT INTO npiulb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","म तेरो अगिअगि एउटा दूत पठाउनेछु, र कनानी, एमोरी, हित्ती, परिज्‍जी, हिव्वी र यबूसीहरूलाई म त्यहाँबाट धपाउनेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दूध र मह बग्‍ने त्यस देशमा जा तर मचाहिँ तिमीहरूसँग जानेछैनँ किनकि तिमीहरू हठी मानिसहरू हौ । मैले तिमीहरूलाई बाटैमा नाश गर्न पनि सक्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","जब मानिसहरूले यी भयभीत तुल्याउने वचनहरू सुने तिनीहरूले विलाप गरे र कसैले पनि गरगहना लगाएन । ");
INSERT INTO npiulb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","परमप्रभुले मोशालाई भन्‍नुभयो, “इस्राएलीहरूलाई भन्, 'तिमीहरू हठी मानिसहरू हौ । म तिमीहरूका बिचमा एकै क्षण मात्र गएँ भने पनि मैले तिमीहरूलाई नष्‍ट गर्न सक्छु । त्यसैले, तिमीहरूले आ-आफ्ना गरगहना फुकाल ताकि तिमीहरूलाई के गर्ने भनी मैले निधो गर्न सकूँ' ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","त्यसैले होरेब पर्वतदेखि इस्राएलीहरूले गरगहना लगाएनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मोशाले पाल लिएर छाउनीभन्दा अलि पर त्यसलाई टाँगे । तिनले यसलाई भेट हुने पाल भने । परमप्रभुलाई कुनै पनि थोकको लागि बिन्ती चढाउन चाहने हरेक व्यक्ति छाउनीबाहिर यही भेट हुने पालमा जान्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","मोशा पालमा जाँदा सबै मानिस तिनीहरूको पालको प्रवेशद्वारमा खडा हुन्थे र मोशा भित्र प्रवेश नगरुञ्‍जेलसम्म तिनलाई हेर्ने गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मोशा पालभित्र प्रवेश गर्दा बादलको खाँबो तल झरी पालको प्रवेशद्वारमा अडिन्थ्यो, अनि परमप्रभु मोशासित बोल्नुहुन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","कुनै पनि बेला पालको प्रवेशद्वारमा सबै मानिसले बादलको खाँबो देख्दा हरेक व्यक्ति आ-आफ्नो पालको प्रवेशद्वारमा खडा भई त्यसले उहाँको आराधना गर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","एउटा मानिस आफ्नो साथीसित बोलेजस्तै परमप्रभु आमनेसामने मोशासित बोल्नुहुन्थ्यो । तब मोशा छाउनीमा फर्कन्थे तर तिनका जवान दास अर्थात् नूनका छोरा यहोशूचाहिँ पालमै बस्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशाले परमप्रभुलाई भने, “हेर्नुहोस्, तपाईं मलाई भन्दै हुनुहुन्छ, 'यी मानिसहरूलाई यात्रामा लिएर जा,' तर तपाईंले मसँगै कसलाई पठाउनुहुनेछ भनी बताउनुभएको छैन । तपाईंले भन्‍नुभएको छ, 'म तँलाई नामद्वारै चिन्छु, र तैँले मेरो दृष्‍टिमा निगाह पाएको छस् ।' ");
INSERT INTO npiulb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","अब मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने मलाई तपाईंका मार्गहरू देखाउनुहोस् ताकि तपाईंलाई जान्‍न सकूँ र तपाईंको दृष्‍टिमा निगाह पाइरहन सकूँ । यो जाति तपाईंका मानिसहरू हुन् भनी याद गर्नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","परमप्रभुले जवाफ दिनुभयो, “मेरो आफ्नै उपस्थिति तँसँगै जानेछ, र म तँलाई विश्राम दिनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मोशाले उहाँलाई भने, “तपाईंको उपस्थिति मसँगै जाँदैन भने हामीलाई यहाँबाट नलैजानुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","किनकि नत्रता म र मेरा मानिसहरूले तपाईंको दृष्‍टिमा निगाह पाएका छौँ भनी हामीले कसरी थाहा पाउने? पृथ्वीको सतहमा भएका सबै जातिभन्दा तपाईंको जाति र म अलग छु भनेर थाहा पाउने कुरो भनेको तपाईं हामीसँग गएर मात्र हुने होइन र?” ");
INSERT INTO npiulb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","परमप्रभुले मोशालाई भन्‍नुभयो, “तैँले अनुरोध गरेको यस कुरालाई पनि म मान्‍नेछु किनकि तैँले मेरो दृष्‍टिमा निगाह पाएको छस्, र म तँलाई नामले नै चिन्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","मोशाले भने, “कृपया, मलाई तपाईंको महिमा देखाइदिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","परमप्रभुले भन्‍नुभयो, “म तेरै सामु मेरा सबै भलाइ देखाउनेछु, र तेरै सामु मेरो नाउँ 'परमप्रभु' हो भनी घोषणा गर्नेछु । जससित म अनुग्रही हुन चाहन्छु, त्यससित म अनुग्रही हुनेछु, र जसलाई म कृपा देखाउन चाहन्छु, म त्यसलाई कृपा देखाउनेछु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","तर परप्रभुले भन्‍नुभयो, “तैँले मेरो अनुहार देख्‍न सक्दैनस् किनकि मेरो अनुहार देखेर कोही पनि जीवित रहन सक्दैन ।” ");
INSERT INTO npiulb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","परमप्रभुले भन्‍नुभयो, “हेर्, मेरो छेउमा एउटा ठाउँ छ । तँ यो चट्टानमा खडा हो । ");
INSERT INTO npiulb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","मेरो महिमा त्यहाँबाट भएर जाँदा म तँलाई चट्टानको धाँदोमा राख्‍नेछु र म त्यहाँबाट नगएसम्म तँलाई मेरा हातले ढाकिराख्‍नेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","त्यसपछि म मेरो हात निकाल्नेछु, र तैँले मेरो पिठिउँ देख्‍नेछस्, तर मेरो अनुहारचाहिँ देख्‍नेछैनस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, “पहिलेका जस्तै ढुङ्गाका दुईवटा पाटी काटेर ले । तैँले फुटाएका पहिलेका पाटीहरूमा मैले लेखेका वचनहरू म यी शिला-पाटीहरूमा लेख्‍नेछु । ");
INSERT INTO npiulb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","बिहानसम्म तयार हो, र सीनै पर्वतमा उक्लेर आइज र पर्वतको टाकुरमा मेरो सामु देखा पर् । ");
INSERT INTO npiulb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तँसँग अरू कोही नआओस् । पर्वतको कुनै पनि भागमा कोही पनि नदेखियोस् । पर्वतको सामु कुनै भेडा-बाख्रा वा गाईवस्तु नचरोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","त्यसैले मोशाले पहिलेजस्तै ढुङ्गाका दुईवटा पाटी काटे, र तिनी बिहानै उठेर सीनै पर्वतमा उक्ले जस्तो परमप्रभुले तिनलाई आज्ञा ");
INSERT INTO npiulb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","गर्नुभएको थियो । मोशाले शिला-पाटीहरू आफ्ना हातमा लिएर गए । परमप्रभु बादलमा ओर्लनुभयो, र त्यहाँ मोशासित खडा हुनुभयो अनि उहाँले “परमप्रभु” नाउँको घोषणा गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","परमप्रभु तिनको सामु भएर जानुभयो र घोषणा गर्नुभयो, “परमप्रभु, परमप्रभु, परमेश्‍वर करुणामय र अनुग्रही, रिस गर्नमा ढिलो अनि करारको विश्‍वसनीयतामा प्रचुर र भरोसायोग्य हुनुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","उहाँले हजारौँ पुस्तासम्म आफ्नो करार राख्‍नुहुन्छ, अधर्म, अपराध र पापको क्षमा दिनुहुन्छ । तर उहाँले दोषीलाई कुनै किसिमले छाड्नुहुनेछैन । उहाँले पिता-पुर्खाहरूका दण्ड तिनीहरूका छोराछोरीहरू र नातिनातिनाहरू अनि तेस्रो र चौथो पुस्तासम्म दिनुहुन्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","मोशाले झट्टै भुइँतिर आफ्नो शिर झुकाएर आराधना गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","तब तिनले भने, “हे प्रभु, अब मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने हाम्रा बिचमा भएर जानुहोस् किनकि यो जाति हठी छ । हाम्रा पाप र अधर्म क्षमा गरिदिनुहोस् र हामीलाई तपाईंको उत्तराधिकारको रूपमा स्वीकार गर्नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","परमप्रभुले भन्‍नुभयो, “हेर्, मैले करार बाँध्‍न लागेको छु । तेरा सबै मानिसका सामु म यस्ता आश्‍चर्यका कामहरू गर्नेछु जुन सारा पृथ्वीमा कुनै पनि जातिमा गरिएको छैन । तिमीहरूका बिचमा भएका सबै मानिसले मेरा कार्यहरू देख्‍नेछन् किनकि तँसित मैले गर्न खोजिरहेको कुरो डरलाग्दो छ । ");
INSERT INTO npiulb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","आज मैले आज्ञा गरेको कुरा पालन गर् । तेरो सामु मैले एमोरी, कनानी, हित्ती, परिज्‍जी, हिव्वी र यबूसीहरूलाई धपाउन लाग्दै छु । ");
INSERT INTO npiulb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","तँ गइरहेको देशका बासिन्दाहरूसित कुनै किसिमको करार नबाँध्‍न सावधन बस् नत्रता तिनीहरू तिमीहरूका बिचमा पासो बन्‍नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","बरु, तैँले तिनीहरूका वेदीहरू भत्काइदिनू, तिनीहरूका ढुङ्गाका खम्बाहरू टुक्रा-टुक्रा पारिदिनू र तिनीहरूका अशेरा देवीका मूर्तिहरूलाई काटेर ढालिदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","किनकि तिमीहरूले म परमप्रभुबाहेक कुनै देवी-देवतालाई नपुज्नू । म डाह गर्ने परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","त्यसैले त्यस देशका बासिन्दाहरूसित करार नबाँध्‍न होसियार हो किनकि तिनीहरूका देवी-देवताहरूका लागि तिनीहरूले वेश्या-वृत्ति गर्छन् र तिनीहरूले बलि गर्छन् । तब तिनीहरूमध्ये एउटाले तिमीहरूलाई निमन्त्रणा गर्नेछ अनि तिमीहरूले त्यसको बलिदान खानेछौ, अनि तिनीहरूका केही छोरीहरू आफ्ना छोराहरूका लागि ल्याउनेछौ ");
INSERT INTO npiulb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","अनि तिनीहरूका छोरीहरूले तिनीहरूका देवी-देवताहरूका निम्ति आफैलाई वेश्या-वृत्तिमा लगाउनेछन् अनि तिनीहरूले तिमीहरूका छोराहरूलाई पनि तिनीहरूका देवी-देवताहरूका निम्ति वेश्या-वृत्तिमा लैजानेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","तिमीहरूले आफ्ना ढलौटे मूर्तिहरू नबनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","तिमीहरूले अखमिरी रोटीको चाड मान्‍नू । मैले तिमीहरूलाई आज्ञा दिएबमोजिम आबीब महिनाको तोकिएको समयमा सात दिनसम्म खमिर नहालेको रोटी खानू किनकि आबीब महिनामै तिमीहरू मिश्रबाट बाहिर आयौ । ");
INSERT INTO npiulb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","सबै पहिला जन्मेकाहरू मेरा हुन् । तिमीहरूका गाईवस्तु, गोरु, भेडाका हरेक नर मेरा हुन् । ");
INSERT INTO npiulb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गधाको पहिलो जन्मेको बछेडोलाई थुमा दिएर छुटाउनू, तर त्यसलाई छुटाएनौ भने त्यसको घाँटी भाँचिदिनू । तिमीहरूका सबै जेठा छोराहरूलाई केही दिएर छुटाउनू । कोही पनि मेरो सामु रित्तो हात नआओस् । ");
INSERT INTO npiulb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","तिमीहरूले छ दिनसम्म काम गर्न सक्छौ, तर सातौँ दिनमा चाहिँ विश्राम गर्नू । हलो जोत्‍ने र कटनी गर्ने समयमा पनि विश्राम गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","गहुँको फसलको पहिलो उब्जनीसँगै साताहरूको चाड मान्‍नू, र वर्षको अन्त्यमा अन्‍न भित्र्याउने चाड मान्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","वर्षको तिन पटक तिमीहरूका सबै पुरुष परमप्रभु इस्राएलका परमेश्‍वरको सामु देखा पर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","किनकि म तिमीहरूका सामु जाति-जातिहरूलाई धपाउनेछु र तिमीहरूका सिमाना बढाइदिनेछु । तिमीहरू वर्षमा तिन पटक परमप्रभु तिमीहरूका परमेश्‍वरको सामु देखा पर्न जाँदा कसैले पनि आफ्नो अधिकारको रूपमा तिमीहरूको देश कब्जा गर्ने इच्छा गर्नेछैन । ");
INSERT INTO npiulb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","खमिरसहित मेरो बलिदानको रगत नचढाउनू, न त निस्तार-चाडमा चढाइने बलिको कुनै भाग बिहानसम्म उब्रोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","तिमीहरूले आ-आफ्ना खेतहरूबाट सबैभन्दा असल अगौटे फलहरू मेरो घरमा ल्याउनू । बाख्राको पाठो त्यसको माउको दूधमा नपकाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","परमप्रभुले मोशालाई भन्‍नुभयो, “यी कुराहरू लेख् किनकि यी वचनअनुसार नै मैले तँ र इस्राएलसित करार बाँधेको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशा परमप्रभुसित त्यहाँ चालिस दिन र चालिस रातसम्म बसे । तिनले न कुनै खाना खाए न पानी पिए । तिनले करारका वचनहरू अर्थात् दस आज्ञा शिला-पाटीहरूमा लेखे । ");
INSERT INTO npiulb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","मोशा आफ्ना हातमा करारका आज्ञाहरू लिखित दुईवटा शिला-पाटी लिएर पर्वतबाट तल ओर्लंदा र तिनी परमेश्‍वरसित बोल्दा तिनको अनुहारको छाला चम्कँदै थियो भनी तिनलाई थाहै भएन । ");
INSERT INTO npiulb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारून र इस्राएलीहरूले मोशालाई देखे तिनको अनुहार चम्कँदै थियो, र तिनीहरू तिनको नजिक आउन डराए । ");
INSERT INTO npiulb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","तर मोशाले तिनीहरूलाई डाके, अनि हारूनसाथै समुदायका सबै अगुवा तिनीकहाँ आए । तब मोशा तिनीहरूसित बोले । ");
INSERT INTO npiulb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","यसपछि इस्राएलका सबै मानिस मोशाकहाँ आए, अनि परमप्रभुले सीनै पर्वतमा तिनलाई बताउनुभएका सबै आज्ञा तिनले मानिसहरूलाई बताए । ");
INSERT INTO npiulb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","तिनीहरूसित बोलिसकेपछि मोशाले आफ्नो अनुहारमा घुम्टो हाले । ");
INSERT INTO npiulb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","मोशा परमप्रभुको सामु उहाँसित बोल्न जाँदा तिनी बाहिर नआउञ्‍जेलसम्म तिनले घुम्टो उघार्थे । तिनी बाहिर आउँदा तिनलाई बताउन आज्ञा गरिएको कुरा तिनले इस्राएलीहरूलाई बताउँथे । ");
INSERT INTO npiulb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएलीहरूले मोशाको अनुहार चम्किरहेको देख्दा तिनी परमप्रभुसित बोल्नलाई भित्र नगएसम्म तिनले फेरि आफ्नो अनुहारमा घुम्टो हाल्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशाले इस्राएलका सारा समुदायलाई भेला गरी तिनीहरूलाई भने, “परमप्रभुले तिमीहरूलाई गर्नू भनी आज्ञा दिनुभएका कुराहरू यी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छ दिनसम्म काम गर्न सकिन्छ, तर सातौँचाहिँ दिन तिमीहरूका लागि पवित्र दिन हो । यो परमप्रभुको निम्ति पूर्ण विश्राम गर्ने शबाथ-दिन हो । त्यस दिन जसले काम गर्छ, त्यो मारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","शबाथ-दिनमा तिमीहरूका घरमा आगो नबलोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशाले इस्राएलीहरूका सारा समुदायलाई यसो भने, “परमप्रभुले आज्ञा दिनुभएको कुरा यही नै हो । ");
INSERT INTO npiulb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","इच्छुक ह्रदय भएका सबैले परमप्रभुका निम्ति यी भेटीहरू ल्याऊन्: सुन, चाँदी, काँसा, ");
INSERT INTO npiulb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","निलो, बैजनी र रातो ऊन अनि मसिनो सुती कपडा, बाख्राको भुत्ला, ");
INSERT INTO npiulb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","रातो रङ्गाइएको भेडाको छाला र सीलको छाला, बबुल काठ, ");
INSERT INTO npiulb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","पवित्रस्थानका दियाहरूका लागि तेल, अभिषेक गर्ने तेलका लागि मसला र सुगन्धित धूप, एपोद र छाती-पाताको लागि ");
INSERT INTO npiulb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","आनिक्ससाथै अन्य बहुमूल्य रत्‍नहरू । ");
INSERT INTO npiulb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","तिमीहरूका बिचमा भएका हरेक सिपालु व्यक्ति आएर परमप्रभुले आज्ञा दिनुभएका हरेक कुरा बनाओस्: ");
INSERT INTO npiulb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","पवित्रस्थान र यसको पाल, यसको छत, यसका अङ्कुसेहरू, फल्याकहरू, बारहरू, खम्बाहरू ");
INSERT INTO npiulb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","र आधारहरू, सन्दुक र यसका डन्डाहरू, प्रायश्‍चित्तको ढकनी र यसलाई ढाक्‍ने पर्दा । ");
INSERT INTO npiulb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","तिनीहरूले टेबुल र यसका डन्डाहरू, यसका सबै भाँडाकुँडाहरू र उपस्थितिको रोटी, ");
INSERT INTO npiulb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","बत्तीका निम्ति सामदान, यसका सामग्रीहरू, दियाहरू र दियाका लागि तेल, ");
INSERT INTO npiulb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूपको वेदी र यसका डन्डाहरू, अभिषेक गर्ने तेल र सुगन्धित धूप, पवित्र वासस्थानको प्रवेशद्वारको पर्दा, ");
INSERT INTO npiulb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमबलिको वेदी र यसका काँसाका जालीसाथै डन्डाहरू अनि भाँडाकुँडाहरू, आधार भएको ठुलो बाटा बनाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","तिनीहरूले चोकको लागि पर्दा र यसका डन्डासाथै आधारहरू अनि चोकको प्रवेशद्वारको लागि पर्दा, ");
INSERT INTO npiulb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","र पवित्र वासस्थान र चोकको लागि पालका किलाहरूसाथै तिनीहरूका डोरीहरू ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","तिनीहरूले पवित्रस्थानमा सेवा गर्ने राम्ररी बुनेका पोशाकहरू, हारून पुजारी र तिनका छोराहरूले पुजारी भएर सेवा गर्दा लगाउने पवित्र पोशाकहरू ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब इस्राएलका सबै कुल मोशाको उपस्थितिबाट बिदा भएर गए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","जस-जसका ह्रदय प्रेरणाले भरिए र आत्माद्वारा इच्छुक भए तिनीहरू आएर पवित्र वासस्थानको रचना, यसमा प्रयोग हुने सेवाका सबै सामग्री र पवित्र पोशाकहरूको लागि परमप्रभुको निम्ति भेटी ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","इच्छुक ह्रदय भएका पुरुष र स्‍त्रीहरू सबै जना आए । तिनीहरूले पीन, कुण्डल, औँठी र सिङ्गारका सरसामानहरूसाथै सबै किसिमका सुनका गरगहनाहरू ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","तिनीहरू सबैले परमप्रभुको लागि डोलाइने बलिको रूपमा सुनका भेटीहरू टक्र्याए । जो-जोसँग निलो, बैजनी वा रातो ऊन, मसिनो सुती कपडा, बाख्राको भुत्ला, रातो रङ्ग्याइएको भेडाको छाला वा सीलका छालाहरू थिए, तिनीहरूले ती ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","चाँदी वा काँसाको भेटी ल्याउने हरेकले परमप्रभुको लागि भेटी ल्यायो र काममा प्रयोग हुन सक्‍ने कुनै किसिमको बबुल काठ भएकोले त्यसलाई ल्यायो । ");
INSERT INTO npiulb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","हरेक सिपालु स्‍त्रीले आफ्ना हातले ऊन कातेर आफूले कातेको निलो, बैजनी वा रातो ऊन वा मसिनो सुती कपडा ल्याई । ");
INSERT INTO npiulb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","जो-जो स्‍त्रीका ह्रदय प्रेरणाले भरिए र जससित सिप थियो, तिनीहरूले बाख्राका भुत्ला काते । ");
INSERT INTO npiulb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","एपोद र छाती-पातामा जड्नका लागि अगुवाहरूले आनिक्ससाथै अन्य बहुमूल्य रत्‍नहरू ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","तिनीहरूले मसला र बत्तीहरूका लागि तेल, अभिषेक गर्ने तेल अनि सुगन्धित धूप ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","इस्राएलीहरूले परमप्रभुको निम्ति स्वैच्छिक भेटी ल्याए । हरेक स्‍त्री र पुरुष जस-जसको ह्रदय इच्छुक थियो, तिनीहरूले परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएका सबै सरसामान ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","मोशाले इस्राएलीहरूलाई भने, “हेर, परमप्रभुले यहूदाको कुलबाट हूरका नाति, ऊरीका छोरा बजलेललाई डाक्‍नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","उहाँले सबै किसिमका कारीगरीको काम गर्नका लागि त्यसलाई बुद्धि, समझशक्ति, ज्ञान दिन उहाँका आत्माले भरिपूर्ण पार्नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","तिनले सुन, चाँदी, काँसाका कलापूर्ण रचनाहरू बनाउनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","सबै किसिमका कारीगरीका काम गर्न तिनले पत्थर काट्ने, जड्ने र काठ खोप्‍ने गर्छन् । ");
INSERT INTO npiulb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","तिनले र दानको कुलका अहीसामाकका छोरा ओहोलीआबले अरूहरूलाई सिकाऊन् भनेर उहाँले यो तिनको ह्रदयमा राखिदिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","तिनीहरूले सबै किसिमका शिल्पकारी, खोप्‍ने, चित्र बनाउने काम, निलो, बैजनी, रातो ऊन र मसिनो सुती कपडा र जुलहाको काम गरून् भनेर उहाँले तिनीहरूलाई सिपले भरिपूर्ण पार्नुभएको छ । सबै किसिमका काममा तिनीहरू शिल्पकारी र कलापूर्ण रचनाकारहरू हुन् । ");
INSERT INTO npiulb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","यसैले बजलेल, ओहोलीआब र परमप्रभुले पवित्रस्थान बनाउने काम गर्न ज्ञान र दक्षता दिनुभएको हरेक सिपालु व्यक्‍तिले उहाँको आज्ञामुताबिक काम गरून् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","मोशाले बजलेल, ओहोलीआब र हरेक सिपालु व्यक्ति जसको मनमा उहाँको काम गर्न परमप्रभुले सिप दिनुभएको थियो र जसको ह्रदयमा उहाँले प्रेरणा दिनुभएको थियो, ती सबैलाई बोलाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","पवित्रस्थान निर्माणको लागि इस्राएलीहरूले ल्याएका सबै भेटी तिनीहरूले मोशाबाट प्राप्‍त गरे । मानिसहरूले अझै पनि राजीखुसीले हरेक बिहान भेटीहरू ल्याउँदै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","त्यसैले पवित्रस्थानमा काम गरिरहेका सबै निपुण मानिस काम छाडेर आए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","शिल्पकारहरूले मोशालाई भने, “परमप्रभुले हामीलाई गर्न भनी आज्ञा गर्नुभएको कामको लागि मानिसहरूले चाहिएभन्दा पनि बढ्ता ल्याउँदै छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","त्यसैले पवित्रस्थानको निर्माणको लागि कसैले पनि अरू भेटीहरू नल्याउनू भनी मोशाले छाउनीमा आज्ञा दिए । तब मानिहरूले यी भेटीहरू ल्याउन छाडे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","सबै कामको लागि तिनीहरूसित चाहिनेभन्दा बढी सामग्रीहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","त्यसैले तिनीहरूका बिचमा भएका सबै शिल्पकारले मसिनो सुती कपडा अनि निलो, बैजनी, रातो ऊनबाट दसवटा पर्दा भएको करूबहरूको रचनासहित पवित्र वासस्थानको निर्माण गरे । यो ज्यादै निपुण शिल्पकार बजलेलको काम थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","हरेक पर्दाको लमाइ अट्ठाइस हात र चौडाइ चार हातको थियो । सबै पर्दा उही आकारका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","बजलेलले पाँचवटा पर्दा एक-अर्कामा गाँसे र बाँकी पाँचवटालाई पनि एक-अर्कामा गाँसे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","पहिले गाँसिएको पर्दाको पल्लो पर्दाको छेउमा तिनले निलो सुर्काउनी बनाए, र दोस्रो गाँसिएको पर्दाको छेउमा पनि तिनले त्यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","तिनले पहिलो पर्दामा पचासवटा सुर्काउनी बनाए, र अर्को गाँसिएको भागको पल्लो पर्दामा पनि पचासवटा सुर्काउनी बनाए । ती सुर्काउनीहरू एक-अर्काका आमनेसामने थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","तिनले पवित्र वासस्थान एउटै होस् भनेर सुनका पचासवटा अङ्कुसे बनाए, र तिनलाई पर्दाका दुई भाग एक-अर्कासित जोडे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","पवित्र वासस्थान ढाक्‍ने पालको निम्ति बजलेलले बाख्राका भुत्लाका पर्दाहरू बनाए । तिनले यस्ता खालका पर्दाहरू एघारवटा बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","हरेक पर्दाको लमाइ तिस हात र चौडाइ चार हातको थियो । सबै एघारवटै पर्दाको आकार उही थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","तिनले पाँचवटा पर्दा एक-अर्कासित जोडे र बाँकी छवटा पर्दा एक-अर्कासित जोडे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","तिनले पहिलो गाँसिएको भागको पल्लो पर्दाको छेउमा पचासवटा सुर्काउनी बनाए, र दोस्रो गाँसिएको भागको पल्लो पर्दाको छेउमा पनि पचासवटा सुर्काउनी बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","पाललाई जोडेर एउटै बनाउन बजलेलले काँसाका पचासवटा अङ्कुसे बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","तिनले पवित्र वासस्थानलाई ढाक्‍न रातो रङले रङ्ग्याएका भेडाका छालाहरूको एउटा छत बनाए, र त्यसमाथि राख्‍न मसिनो छालाको अर्को छत बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","बजलेलले पवित्र वासस्थानको निम्ति बबुल काठबाट ठाडा-ठाडा फल्याकहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","हरेक फल्याकको लमाइ दस हात र चौडाइ साँढे एक हातको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","फल्याकहरूलाई एक-अर्कासित जोड्न हरेकमा दुई-दुईवटा काठका चोसा थिए । तिनले पवित्र वासस्थानका सबै फल्याकमा यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","तिनले पवित्र वासस्थानको लागि यसरी नै सबै फल्याक बनाए । तिनले दक्षिणपट्टिको लागि बिसवटा फल्याक बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","बजलेलले ती बिसवटा फल्याकको मुनिपट्टि राख्‍न चाँदीका चालिसवटा आधार बनाए । फल्याकहरूलाई सँगै जोड्न हरेक फल्याकको मुन्तिर दुईवटा आधार थिए, अरू सबै फल्याकको मुन्तिर पनि दुई-दुईवटा आधार थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","पवित्र वासस्थानको दोस्रोपट्टि अर्थात् उत्तरपट्टि तिनले बिसवटा फल्याक र तिनको लागि ");
INSERT INTO npiulb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","चाँदीका चालिसवटा आधार बनाए । पहिलो फल्याकको मुनिपट्टि दुईवटा आधार थिए, अनि अर्को फल्याकको मुनिपट्टि दुईवटा आधार थिए एवम् रितले सबै फल्याकमुनि दुई-दुईवटा आधार थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","पवित्र वासस्थानको पछाडि अर्थात् पश्‍चिमपट्टि बजलेलले छवटा फल्याक बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","पवित्र वासस्थानको पछाडिका कुनाहरूमा तिनले दुईवटा फल्याक बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ती दुई कुनाका फल्याकहरू तल छुट्टिएका थिए भने माथि दोब्बर खप्टिएका थिए । तिनले दुईवटा कुनाका लागि दुईवटा फल्याक यसरी नै बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","चाँदीका आधारसहित जम्माजम्मी आठवटा फल्याक थिए । जम्माजम्मी सोह्रवटा आधार थिए । एउटा फल्याकको मुनिपट्टि दुईवटा आधार, अर्को फल्याकको मुनिपट्टि दुईवटा आधार, एवम् रितले हरेक फल्याक मुनिपट्टि दुई-दुईवटा आधार थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","बजलेलले बबुल काठका बारहरू बनाए । तिनले पवित्र वासस्थानको एकापट्टिका फल्याकहरूका लागि पाँचवटा, ");
INSERT INTO npiulb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","र अर्कोपट्टिका फल्याकहरूका लागि पाँचवटा अनि पवित्र वासस्थानको पछाडिपट्टि अर्थात् पश्‍चिमपट्टिको लागि पाँचवटा बार बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","तिनले फल्याकहरूका बिचमा हुने बारचाहिँ एक छेउबाट अर्को छेउसम्म पुग्‍ने गरी बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","तिनले फल्याकहरूलाई सुनले मोहोरे । तिनले बारहरू पक्रनका निम्ति सुनका मुन्द्राहरू बनाए, र बारहरूलाई सुनले मोहोरे । ");
INSERT INTO npiulb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","बजलेलले निलो, बैजनी र रातो ऊन अनि मसिनो सुती कपडाबाट करूबहरूको रचनामा पर्दाहरू बनाए । यो निपुण शिल्पकारको काम थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","तिनले पर्दाहरूका लागि बबुल काठका चारवटा खम्बा बनाए, र तिनलाई सुनले मोहोरे । तिनले खम्बाहरूका लागि अङ्कुसेहरू पनि बनाए, र तिनका निम्ति चाँदीका चारवटा आधार बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","तिनले पालको प्रवेशद्वारको लागि एउटा पर्दा बनाए । यो निलो, बैजनी, रातो ऊन, मसिनो सुती कपडाबाट बनाइएको थियो । यो बुट्टा भर्नेको काम थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","तिनले पर्दाका पाँचवटा खम्बा तिनका अङ्कुसेहरूसमेत बनाए । तिनले तिनीहरूका टुप्पा र फित्ता सुनले मोहोर । तिनीहरूका पाँचवटा आधारचाहिँ काँसाका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बजलेलले बबुल काठबाट सन्दुक बनाए । यसको लमाइ साँढे दुई हात र चौडाइ साँढे एक हातको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","तिनले यसलाई भित्र र बाहिर निखुर सुनले मोहोरे अनि यसको चारैतिर सुनको बिट लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","तिनले दुईवटा मुन्द्रा एकातिर र दुईवटा मुन्द्रा अर्कोतिर गरी त्यसको चारवटा खुट्टामा चारवटा मुन्द्रा हाले । ");
INSERT INTO npiulb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","तिनले बबुलका डन्डाहरू बनाएर तिनलाई सुनले मोहोरे । ");
INSERT INTO npiulb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","तिनले सन्दुकलाई बोक्‍न ती डन्डाहरू त्यसका दुवैतिर भएका मुन्द्राहरूमा हाले । ");
INSERT INTO npiulb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","तिनले निखुर सुनबाट प्रायश्‍चित्तको ढकनी बनाए । यसको लमाइ साँढे दुई हात र चौडाइ साँढे एक हातको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","बजलेलले प्रायश्‍चित्तको ढकनीको दुवै छेउका लागि पिटेको सुनका दुईवटा करूब बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","एउटा करूब प्रायश्‍चित्तको ढकनीको एउटा छेउमा अर्को करूब अर्को छेउको लागि थिए । ती करूबहरू प्रायश्‍चित्तको ढकनीकै टुक्राबाट बनाइएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","करूबहरूले आ-आफ्ना पखेटाहरू माथितिर फैलाएका थिए, र प्रायश्‍चित्तको ढकनीलाई छाया पारेका थिए । करूबहरू आमनेसामने थिए, र तिनीहरूले प्रायश्‍चित्तको ढकनीतर्फ हेरेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बजलेलले बबुल काठबाट टेबुल बनाए । यसको लमाइ दुई हात, चौडाइ एक हात र उचाइ साँढे एक हात थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","तिनले यसलाई निखुर सुनले मोहोरे र यसको चारैतिर सुनको बिट लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","तिनले यसको चारैतिर चार अङ्गुल चौडा भएको एउटा घेरो बनाए, र यसको चारैतिर सुनको बिट लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","तिनले टेबुलको निम्ति ढालेर चारवटा मुन्द्रा बनाए, र ती मुन्द्राहरूलाई चारवटा खुट्टाका चारवटा कुनामा लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","टेबुललाई बोक्‍न ती मुन्द्राहरू डन्डाहरूका लागि ठाउँ हुनलाई घेरोको छेउमा थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","तिनले टेबुल बोक्‍नलाई बबुल काठबाट डन्डाहरू बनाए, र तिनलाई सुनले मोहोरे । ");
INSERT INTO npiulb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","तिनले भेटीहरू चढाउन प्रयोग हुने टेबुलमा राखिने थाल, चम्चा, कचौरा र करुबहरूजस्ता सामग्रीहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","तिनले यी सबै निखुर सुनले बनाए । तिनले पिटेको निखुर सुनबाट सामदान बनाए । तिनले यसको आधार र डन्डा हुने गरी सामदानलाई बनाए । यसका कचौरा, कोपिला र फुलहरू सबै एउटै टुक्राबाट बनाइएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","यसको एकापट्टिबाट तिनवटा हाँगा र अर्कोपट्टिबाट तिनवटा हाँगा गरी छवटा हाँगा बाहिरतिर निस्केका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","पहिलो हाँगामा हाडे-बदामका फुलजस्ता तिनवटा कचौरा, कोपिला र फुलहरू थिए, अनि अर्को हाँगामा पनि हाडे-बदामका फुलजस्ता तिनवटा कचौरा, कोपिला र फुलहरू थिए । सामदानबाट बाहिरतिर निस्केका छवटै हाँगा उस्तै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","सामदानको बिचको डन्डामा हाडे-बदाममा चारवटा कचौरा, आ-आफ्ना कोपिला र फुलहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","सामदानबाट निस्केका छवटा हाँगामध्ये पहिलो जोडी हाँगामुनि एउटा कोपिला, दोस्रो जोडी हाँगामुनि दोस्रो कोपिला र तेस्रो जोडी हाँगामुनि तेस्रो कोपिला थियो । सामदानबाट बाहिरतिर निस्केका सबै छवटै हाँगामा उस्तै थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","तिनीहरूका कोपिला र हाँगाहरू सबै एउटै निखुर सुनको टुक्रा पिटेर बनाइएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","बजलेलले सामदान, यसका सातवटा दिया, यसको चिम्टा र मोसोदानी निखुर सुनबाट बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","तिनले सामदान र यसका सबै सामान करिब चौँतिस किलोग्राम सुनबाट बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","बजलेलले बबुल काठबाट धूपको वेदी बनाए । यसको लमाइ एक हात र चौडाइ एक हातको थियो । यो वर्गाकार थियो र यसको चौडाइ दुई हातको थियो । यसका सिङहरू एउटै टुक्राबाट बनाइएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","तिनले धूपको वेदी, यसको माथिल्लो भाग, यसका किनाराहरू र सिङहरूलाई निखुर सुनले मोहोरे । तिनले यसको चारैतिर निखुर सुनको बिट पनि लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","बोक्‍ने डन्डाहरूका लागि घर हुनलाई तिनले त्यसको बिटमुनि वेदीका दुवैपट्टि सुनका दुईवटा मुन्द्रा बनाएर त्यसका दुईतिर लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","तिनले बबुल काठका डन्डाहरू बनाएर तिनलाई सुनले मोहोरे । ");
INSERT INTO npiulb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","तिनले अभिषेक गर्ने पवित्र तेल अत्तर बनाउनेले जस्तै सुगन्धित शुद्ध धूप बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","बजलेलले होमबलिको लागि बबुल काठबाट वेदी बनाए । यसको लमाइ पाँच हात र चौडाइ पाँच हातको थियो । यो वर्गाकार थियो र यसको उचाइ तिन हातको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","तिनले यसका चारवटा कुनाबाट गोरुका जस्तै सिङहरू बाहिर निकाले । ती सिङहरू र वेदी एउटै टुक्राबाट बनाइएका थिए र तिनले यसलाई काँसाले मोहोरे । ");
INSERT INTO npiulb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","तिनले वेदीका लागि चाहिने सबै सामग्री अर्थात् खरानी उठाउने भाँडाकुँडाहरू, बेल्चाहरू, बाटाहरू, मासु तान्‍ने काँटाहरू आगो राख्‍ने पात्रहरू बनाए । तिनले यी सबै सामग्री काँसाबाट बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","तिनले वेदीको निम्ति त्यसको मुन्तिर चारैपट्टि बिटमुनि त्यसको बिचसम्मै पुग्‍ने काँसाका जालीको एउटा झिँजा बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","तिनले काँसाको झिँजाको चारवटा कुनामा डन्डाहरूको घर हुनलाई चारवटा मुन्द्रा ढाले । ");
INSERT INTO npiulb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","बजलेलले बबुल काठका डन्डाहरू बनाए र तिनलाई काँसाले मोहोरे । ");
INSERT INTO npiulb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","यसलाई बोक्‍नलाई तिनले ती डन्डाहरू वेदीका किनाराका मुन्द्राहरूमा हाले । तिनले ती फल्याकहरूबाट खोक्रो बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","बजलेलले काँसाको ठुलो बाटा र काँसाकै खुट्टा बनाए । भेट हुने पालको प्रवेशद्वारमा सेवा गर्ने स्‍त्रीहरूका ऐनाबाट तिनले बाटा बनाएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","तिनले चोक पनि बनाए । चोकको दक्षिणपट्टिका पर्दाहरू मसिनो सुती कपडाका थिए जुन एक सय हातका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","तिनका खम्बाहरू बिसवटा र आधारहरू पनि काँसाका बिसवटै थिए । खम्बाका अङ्कुसेहरू र तिनका फित्ताहरूचाहिँ चाँदीका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","त्यसै गरी, उत्तरपट्टि सय हात लामा पर्दाहरू थिए । तिनका खम्बाहरू बिसवटा र तिनका आधारहरू पनि बिसवटै थिए र ती काँसाका थिए । तर खम्बाहरूका अङ्कुसे र फित्ताहरूचाहिँ चाँदीका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","पश्‍चिमपट्टिका पर्दाहरू पचास हात लामा थिए । तिनका दसवटा खम्बा र आधार थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","तिनका अङ्कुसे र फित्ताहरूचाहिँ चाँदीका थिए । चोकको पूर्वपट्टिको लमाइ पचास हात थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","प्रवेशद्वारको एकापट्टिका लागि पन्ध्र हात लामा पर्दाहरू थिए । तिनका तिनवटा खम्बा र तिनवटा आधार थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","चोकको प्रवेशद्वारको अर्कोपट्टि पनि पन्ध्र हात लामा पर्दाहरू थिए र तिनका तिनवटा खम्बा र तिनवटा आधार थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","चोकको वरिपरिका सबै पर्दा मसिनो सुती कपडाका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खम्बाहरूका आधारहरू काँसाका थिए । अङ्कुसे र फित्ताहरूचाहिँ चाँदीका थिए अनि तिनका टुप्पाहरूचाहिँ चाँदीका थिए । चोकका सबै फित्ता चाँदीले मोहोरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","चोकको मुल ढोकाको पर्दा बिस हात लामो थियो । पर्दा निलो, बैजनी र रातो सुती कपडा, मसिनो गरी बाटेको सुती कपडाबाट बनाइएको थियो र यसको लमाइ बिस हात थियो । चोकका पर्दाहरूजस्तै यसको लमाइ बिस हात र चौडाइ पाँच हातको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","यसका चारवटा काँसाका आधार र चाँदीका अङ्कुसेहरू थिए । तिनका टुप्पाका ढकनी र फित्ताहरू चाँदीका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पवित्र वासस्थान र चोकका लागि पालका सबै किला काँसाका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","यो पवित्र वासस्थानको मण्डप अर्थात् करारका आदेशहरूको पवित्र वासस्थान थियो जसलाई मोशाको आज्ञामुताबिक बनाइएको थियो । यो हारून पुजारीका छोरा ईतामारको निर्देशनअनुसार लेवीहरूको काम थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","यहूदाको कुलबाट हुरका नाति, ऊरीका छोरा बजलेलले परमप्रभुले मोशालाई आज्ञा गर्नुभएअनुसार हरेक थोक बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","दानको कुलबाट अहीसामाकका छोरा ओहोलीआबले खोप्‍ने र सिपालु शिल्पकारले जस्तै अनि बुट्टा भर्नेले जस्तै निलो, बैजनी, रातो ऊनसाथै मसिनो सुती कपडामा बजलेलसँगै काम गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्रस्थानसित सम्बन्धित सबै काममा यस परियोजनाको लागि प्रयोग भएका सबै सुन डोलाइने बलिबाट जम्मा भएका पवित्र वासस्थानको शेकेलको नापबमोजिम २९ तोडा र ७३० शेकेल थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","समुदायले दिएको चाँदी पवित्र वासस्थानको शेकेलअनुसार १०० तोडा र १,७७४ शेकेल थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","यो भनेको पवित्र वासस्थानको शेकेलअनुसार एक जना मान्छे बराबर एक बेका अर्थात् आधा शेकेल थियो । जनगणनामा गनिएका बिस वर्षभन्दा माथिका मानिसहरूको जम्मा सङ्ख्या ६,०३, ५५० थियो र यसैको आधारमा हरेक व्यक्तिको तथ्याङ्क निकालिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","हरेक आधारको निम्ति एक तोडा ढालेर पवित्र वासस्थानका आधारहरू र पर्दाका आधारहरूका लागि एक सय चाँदी तोडा ढालिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","बाँकी रहेको १,७७५ शेकेल चाँदीले बजलेले भाँडाकुँडाहरूका लागि अङ्कुसे बनाई तिनका टुप्पाहरूलाई मोहोरेर तिनका निम्ति फित्ताहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","डोलाइने बलिबाट आएको काँसा सत्तरी तोडा र २,४०० शेकेल थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","तिनले यसबाट भेट हुने पालको प्रवेशद्वारका आधारहरू, काँसाको वेदी, यसको लागि काँसाको झिँजा र वेदीका लागि आवश्यक सबै सामग्री, ");
INSERT INTO npiulb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","चोकका लागि आधारहरू, चोक प्रवेशको निम्ति आधारहरू, पवित्र वासस्थान र चोकका लागि सबै पालका किलाहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","तिनीहरूले निलो, बैजनी र रातो ऊनबाट पवित्रस्थानमा सेवा गर्नका लागि राम्ररी बुनेका पोशाकहरू बनाए । परप्रभुले मोशालाई आज्ञा दिनुभएअनुसार तिनीहरूले पवित्रस्थानको लागि हारूनका पोशाकहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","बजलेलले सुन, निलो, बैजनी, रातो ऊन र मसिनो गरी बाटेको सुती कपडाबाट एपोद बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","तिनीहरूले सुन पिटेर पातला पाताहरू काटेर तारहरू बनाए । ती निलो, बैजनी, रातो ऊन र मसिनो सुती कपडामा लगाउनलाई थिए र यो निपुण शिल्पकारको काम थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","तिनीहरूले एपोदको लागि दुई छेउमा गाँसेका काँधे-बन्धनहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","यसको राम्ररी बुनेको कमरपेटी एपोदजस्तै थियो । यसलाई एपोदकै टुक्राबाट बनाइएको थियो र यो मसिनो गरी बाटेको सुती कपडा, सुन, निलो, बैजनी र रातो ऊनबाट बनाइएको थियो, जस्तो परमप्रभुले मोशालाई आज्ञा दिनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","तिनीहरूले सुनका मणिघरहरूमा आनिक्स रत्‍नहरू जडे, र छापमा खोपिएजस्तै तिनीहरूले इस्राएलका बाह्र छोराका नाउँ खोपे । ");
INSERT INTO npiulb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ बजलेलले तिनलाई एपोदको काँधे-बन्धनहरूमा इस्राएलका बाह्र छोराका निम्ति सम्झनाको रत्‍न हुनलाई ती लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","तिनले एपोदजस्तै छाती-पाता बनाए जुन सिपालु शिल्पकारको काम थियो । तिनले यसलाई सुन, निलो, बैजनी, रातो ऊन र मसिनो सुती कपडाबाट बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","यो वर्गाकार थियो । तिनीहरूले यसलाई दोब्बर पट्ट्याए । यो एक बित्ता लामो र एक बित्ता चौडा थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","तिनीहरूले यसलाई चार लहर गरी मणिहरू जडे । पहिलो लहर मानिक, पुष्पराज र बेरूजको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दोस्रो लहर फिरोजा, नीर र पन्‍नाको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तेस्रो लहर नीलमणि, हाकिक र कटेलाको थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","चौथो लहर पीतमणि, आनिक्स र बिल्लौरको थियो । ती सुनका मणिघरहरूमा जडिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ती मणिहरू इस्राएलका बाह्र छोराका नाउँअनुसार क्रमैसँग राखिएका थिए । छाप-औँठीमा खोपेजस्तै हरेक नाउँले बाह्र कुलका हरेक कुलको प्रतिनिधित्व गर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","तिनीहरूले छाती-पातामा डोरीजस्तो बाटेको निखुर सुनका सिक्रीहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","तिनीहरूले छाती-पाताको लागि सुनका दुईवटा मुन्द्री बनाए र तिनलाई छाती-पाताका दुईवटै किनारामा लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तिनीहरूले सुनका दुईवटा सिक्रीलाई छाती-पाताका किनाराहरूमा लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","तिनीहरूले बाटेका दुईवटा सिक्रीका अर्का दुईवटा छेउलाई दुवै मणिघरमा जोडे । त्यसपछि तिनीहरूले ती दुईवटालाई एपोदको काँधे-बन्धनको अगाडिपट्टि लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","तिनीहरूले सुनका दुईवटा मुन्द्री बनाए, र भित्रपट्टिको बिँडको छेउमा तिनलाई छाती-पाताका अर्का दुईवटा कुनामा लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","तिनीहरूले थप दुईवटा सुनका मुन्द्री बनाए, र तिनलाई एपोदको अगाडिपट्टि दुवै काँधे-बन्धनका मुनिबाट र एपोदको निकै राम्ररी बुनेको कमरपेटीमाथिको सिउनीनेर लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","तिनीहरूले छाती-पाता त्यसका मुन्द्रीहरूद्वारा एपोदका मुन्द्रीहरूमा निलो फित्ताले कमरपेटीमा बाँधे ताकि त्यो बुनिएको एपोददेखि सर्न नपाओस् । परमप्रभुले मोशालाई आज्ञा गर्नुभएबमोजिम तिनीहरूले बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","बजलेलले एपोदको अलखा पूर्ण रूपमा निलो रङको बुनेको कपडाबाट बनाए । यो जुलाहाको काम थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","यसको बिचमा टाउको छिराउने प्वाल थियो । नच्यातियोस् भन्‍नाका लागि यसमा कठालोको प्वालजस्तै बुनेको बिट थियो । ");
INSERT INTO npiulb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","तिनीहरूले तलको फेरोको चारैतिर निलो, बैजनी, रातो धागो र मसिनो सुती कपडाका दारिमहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","तिनीहरूले निखुर सुनका घण्टीहरू बनाए, र तलको फेरोमा वरिपरि दारिमका बिच-बिचमा तिनीहरूले ती लगाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","तिनीहरूले हारूनले भित्र सेवा गर्दा लगाउने अलखाको छेउ-छेउमा एउटा घण्टी र एउटा दारिम अनि एउटा घण्टी र एउटा दारिम लगाए । परमप्रभुले मोशालाई आज्ञा गर्नुभएअनुसार तिनीहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","तिनीहरूले हारून र तिनका छोराहरूका लागि मसिनो सुती कपडाका लबेदाहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","तिनीहरूले मसिनो सुती कपडाको फेटा, सुती कपडाका अन्य फेटाहरू, सुती कपडाका भित्री वस्‍त्रहरू, ");
INSERT INTO npiulb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","सुती कपडा र निलो, बैजनी, रातो धागोको पटुका बनाए । यो बुट्टा भर्नेको काम थियो । परमप्रभुले मोशालाई आज्ञा गर्नुभएअनुसार तिनीहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","तिनीहरूले निखुर सुनको पवित्र मुकुटको पाता बनाए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","तिनीहरूले यसलाई छाप-औँठीमा झैँ “परमप्रभुको निम्ति पवित्र” भनेर खोपे । तिनीहरूले फेटाको माथिपट्टि निलो फित्ता बाँधे । परमप्रभुले आज्ञा गर्नुभएअनुसार तिनीहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","यसरी पवित्र वासस्थान अर्थात् भेट हुने पालको काम सकियो । इस्राएलका मानिसहरूले सबै कुरा गरे । परमप्रभुले मोशालाई भन्‍नुभएका सबै आज्ञालाई तिनीहरूले पछ्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तिनीहरूले पवित्र वासस्थान, पाल र यसका सबै सरसामान अर्थात् यसका अङ्कुसेहरू, फल्याकहरू, बारहरू, खम्बाहरू र आधारहरू, रातो ");
INSERT INTO npiulb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","रङले रङ्ग्याइएका भेडाका छालाहरूको छत, सीलको छालाको छत र ढाक्‍ने पर्दा, ");
INSERT INTO npiulb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","गवाहीको सन्दुकसाथै डन्डाहरू र प्रायश्‍चित्तको ढकनी ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","तिनीहरूले टेबुल, यसका सबै भाँडाकुँडा र उपस्थितिको रोटी, ");
INSERT INTO npiulb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","निखुर सुनको सामदान र लहरै राखिने यसका दियाहरू, यसका सबै सामान र दियाहरूका लागि तेल, ");
INSERT INTO npiulb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सुनको वेदी, अभिषेक गर्ने तेल र सुगन्धित धूप, पवित्र वासस्थानको प्रवेशद्वारको पर्दा, ");
INSERT INTO npiulb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","काँसाको वेदी र काँसाको झिँजा र यसका डन्डाहरू र भाँडाकुँडा र ठुलो बाटा र यसको खुट्टा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","तिनीहरूले चोकका लागि यसका खम्बाहरू र आधारहरू अनि चोकको प्रवेशद्वारको लागि पर्दा, यसका डोरीहरू र पालका किलाहरू अनि पवित्र वासस्थान अर्थात् भेट हुने पालको सेवाको लागि सबै सरसामान ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","तिनीहरूले पवित्रस्थानमा सेवा गर्नको लागि बुनेका मसिनो सुती कपडाका पोशाकहरू, पुजारी भएर सेवा गर्न हारून र तिनका छोराहरूका लागि पवित्र पोशाकहरू ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","यसरी इस्राएलका मानिसहरूले परमप्रभुले मोशालाई आज्ञा दिनुभएमुताबिक सबै काम गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मोशाले सबै कामको जाँच गर्दा तिनीहरूले गरेका पाए । परमप्रभुले आज्ञा गर्नुभएअनुसार तिनीहरूले गरे । तब मोशाले तिनीहरूलाई आशिष् दिए । ");
INSERT INTO npiulb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","तब परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“नयाँ वर्षको पहिलो महिनाको पहिलो दिनमा तैँले पवित्र वासस्थान अर्थात् भेट हुने पाल खडा गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","तैँले यसभित्र गवाहीको सन्दुक राख्‍नू, र यसलाई पर्दाले छेक्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","तैँले टेबुललाई भित्र ल्याएर यसमाथि राखिने थोकहरू मिलाएर राख्‍नू । त्यसपछि तैँले सामदान भित्र ल्याएर दियाहरू मिलाउनू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","तैँले गवाहीको सन्दुकको सामुन्‍ने सुनको धूपको वेदी राख्‍नू, र पवित्र वासस्थानको प्रवेशद्वारमा पर्दा राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","तैँले पवित्र वासस्थान अर्थात् भेट हुने पालको प्रवेशद्वारको सामुन्‍ने होमबलिको लागि वेदी राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","तैँले भेट हुने पाल र वेदीका बिचमा ठुलो बाटा राख्‍नू र त्यसभित्र पानी हाल्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","चोकको वरिपरि घेरा हाली यसको प्रवेशद्वारमा पर्दा झुण्ड्याउनू । तैँले अभिषेक गर्ने तेल लिई पवित्र वासस्थान र यसभित्र भएको हरेक थोकलाई अभिषेक गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","तैँले यसलाई र यसका सबै सरसामान मेरो लागि अलग गर्नू । तब यो पवित्र हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","तैँले होमबलिको निम्ति वेदी र यसका सबै भाँडाकुँडालाई अभिषेक गर्नू । तैँले वेदी मेरो निम्ति अलग गर्नू र त्यो मेरो लागि अति पवित्र हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","तैँले काँसाको बाटा र यसको खुट्टा अभिषेक गरेर यसलाई मेरो लागि अलग गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","तैँले हारून र त्यसका छोराहरूलाई भेट हुने पालको प्रवेशद्वारमा ल्याई तिनीहरूलाई पानीले नुहाइदिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","मेरो लागि अलग गरिएका पोशाकहरू तैँले हारूनलाई लगाइदिनू र त्यसले पुजारी बनेर मेरो सेवा गरोस् भनेर त्यसलाई अभिषेक गरी मेरो निम्ति अलग गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","त्यसका छोराहरूलाई ल्याई तिनीहरूलाई लबेदा पहिराइदिनू । ");
INSERT INTO npiulb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","पुजारी बनेर तिनीहरूले मेरो सेवा गरून् भनेर तैँले तिनीहरूका पितालाई जस्तै तिनीहरूलाई अभिषेक गर्नू । तिनीहरूको अभिषेकले पुस्ता-पुस्तासम्म तिनीहरूलाई स्थायी पुजारीको पद प्रदान गर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मोशाले त्यसै गरे । परमप्रभुले आज्ञा गर्नुभएअनुसार तिनले गरे । तिनले यी सबै गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","यसरी दोस्रो वर्षको पहिलो महिनाको पहिलो दिनमा पवित्र वासस्थान खडा भयो । ");
INSERT INTO npiulb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मोशाले पवित्र वासस्थान खडा गरे, यसका आधारहरू ठाउँमा राखे, यसका फल्याकहरू खडा गरे, यसका बारहरू जोडे र यसका डन्डाहरू र खम्बाहरू खडा गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","परमप्रभुले आज्ञा गर्नुभएअनुसार तिनले पवित्र वासस्थानमाथि पाल फिँजाएर त्यसमाथि छत राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","तिनले करारका आज्ञाहरूलाई लिई तिनले सन्दुकभित्र हाले । तिनले ");
INSERT INTO npiulb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","सन्दुकमा डन्डाहरू हालेर त्यसमाथि प्रायश्‍चित्तको ढकनी राखे । तिनले सन्दुकलाई पवित्र वासस्थानमा ल्याए । परमप्रभुले आज्ञा गर्नुभएअनुसार तिनले गवाहीको सन्दुकलाई छेक्‍ने पर्दा टाँगे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","तिनले पर्दाको बाहिरपट्टि भेट हुने पाल अर्थात् पवित्र वासस्थानको उत्तरपट्टि टेबुल राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","परमप्रभुले तिनलाई आज्ञा गर्नुभएअनुसार तिनले परमप्रभुको सामु टेबुलमा रोटी मिलाएर राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","तिनले भेट हुने पाल अर्थात् पवित्र वासस्थानको दक्षिणपट्टि टेबुलको सामु सामदान राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","परमप्रभुले तिनलाई आज्ञा गर्नुभएअनुसार तिनले परमप्रभुको सामु दियाहरू बाले । ");
INSERT INTO npiulb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","तिनले भेट हुने पालभित्र पर्दाको सामुन्‍ने सुनको धूपको वेदी राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","परमप्रभुले तिनलाई आज्ञा गर्नुभएअनुसार तिनले यसमाथि सुगन्धित धूप बाले । ");
INSERT INTO npiulb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","तिनले पवित्र वासस्थानको प्रवेशद्वारमा पर्दा झुण्ड्याए । ");
INSERT INTO npiulb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","तिनले भेट हुने पाल अर्थात् पवित्र वासस्थानको प्रवेशद्वारमा होमबलिको वेदी राखे । परमप्रभुले आज्ञा गर्नुभएअनुसार तिनले यहीँ नै होमबलि र अन्‍नबलि चढाए । ");
INSERT INTO npiulb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","तिनले भेट हुने पाल र यस वेदीको बिचमा बाटा राखी त्यसमा धुनलाई पानी राखे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मोशा, हारून र तिनका छोराहरूले बाटाको पानीबाट तिनीहरूका हात-खुट्टा धुने गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","तिनीहरू भेट हुने पालभित्र प्रवेश गर्दा र वेदीमा जाँदा तिनीहरूले धुने गर्थे । परमप्रभुले मोशालाई आज्ञा गर्नुभएअनुसार तिनीहरूले आ-आफूलाई धुने गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","मोशाले पवित्र वासस्थान र वेदीको वरिपरि चोक खडा गरे । तिनले चोकको प्रवेशद्वारमा पर्दा राखे । यसरी मोशाले काम पुरा गरे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब बादलले भेट हुने पाललाई ढाक्यो, अनि परमप्रभुको महिमाले पवित्र वासस्थान भरियो । ");
INSERT INTO npiulb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","भेट हुने पालमाथि बादल आएर बसेकोले र परमप्रभुको महिमाले पवित्र वासस्थान भरिएकोले मोशा यसभित्र प्रवेश गर्न सकेनन् । ");
INSERT INTO npiulb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","पवित्र वासस्थानबाट बादल उठाइँदा इस्राएलका मानिसहरू आफ्नो बाटो लाग्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","तर पवित्र वासस्थानबाट बादल नउठ्दा मानिसहरूले यात्रा गर्दैनथे । बादल नउठेसम्म तिनीहरू बसिरहन्थे । ");
INSERT INTO npiulb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","किनकि इस्राएलका मानिसहरूका सबै यात्राभरि तिनीहरूले देख्‍ने गरी दिनमा परमप्रभुको बादल र रातमा उहाँको आगो पवित्र वासस्थानमाथि हुन्थ्यो ।");
INSERT INTO npiulb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","परमप्रभुले मोशालाई भेट हुने पालबाट बोलाएर यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएलका मानिसहरूलाई यस्तो भन्‍नू, ‘तिमीहरूका बिचबाट कसैले परमप्रभुको निम्ति बलि ल्याउँदा गाई-गोरुको बथान वा भेडा-बाख्राका बगालबाट पशु ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","यदि त्यसको बलि गाई-गोरुको होमबलि हो भने, त्यसले निष्‍खोट गोरु ल्याओस् । परमप्रभुको अगि ग्रहणयोग्‍य होस् भनेर त्यसले त्यो भेट हुने पालको प्रवेशद्वारमा चढाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","त्यसले आफ्नो हात त्यस होमबलिको टाउकोमाथि राखोस्, र त्यसपछि त्यसको खातिर त्यो प्रायश्‍चित्तको रूपमा ग्रहण हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","त्यसपछि त्यसले त्यो गोरुलाई परमप्रभुको अगि मारोस् । हारूनका छोराहरू अर्थात् पुजारीहरूले त्यसको रगत भेट हुने पालको प्रवेशद्वारमा रहेको वेदीमा चढाई छर्कून् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","तब त्यसले त्यो होमबलिको छाला काढेर त्यसलाई टुक्रा-टुक्रा गरी काटोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","अनि पुजारी हारूनका छोराहरूले वेदीमाथि आगो लगाऊन् र त्यस आगोमा दाउराहरू राखून् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","हारूनका छोराहरू, अर्थात् पुजारीहरूले वेदीको दाउरामाथिको आगोमा ती टुक्राहरू, टाउको र बोसो मिलाएर राखून् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","तर त्यसका भित्री भागहरू र खुट्‍टाहरूलाई त्यसले पानीले धोओस् । त्यसपछि पुजारीले वेदीमा भएका सबै कुराहरूलाई होमबलिको रूपमा जलाऊन् । त्यसले मेरो निम्ति मिठो सुगन्ध निकाल्‍ने छ; त्यो मेरो निम्ति चढाइएको होमबलि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","यदि त्यसको होमबलि भेडाहरू वा बाख्राहरूमध्येबाट हो भने, त्यसले एउटा निष्‍खोट भाले चढाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","त्यसले त्यो परमप्रभुको अगि वेदीको उत्तर पट्‍टिको भागमा मारोस् । हारूनका छोराहरू, अर्थात् पुजारीहरूले त्यसको रगत वेदीको वरिपरि छर्कून् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","त्यसपछि त्यसले त्यो टुक्रा-टुक्रा गरी काटोस्, र पुजारीले त्यसको टाउको र बोसोलाई वेदीको दाउरामाथिको आगोमा मिलाएर राखोस्, ");
INSERT INTO npiulb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","तर त्यसका आन्द्राभुँडी र खुट्‍टाहरूलाई भने त्यसले पानीले धोओस् । त्यसपछि पुजारीले ती सबै चढाओस्, र वेदीमा जलाओस् । यो होमबलि हो, र यसले परमप्रभुको निम्ति मिठो सुगन्ध दिने छ; यो उहाँलाई चढाइएको होमबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","यदि परमप्रभुको निम्ति त्यसको बलि पक्षीहरूको होमबलि हो भने, त्यसले एउटा ढुकुर वा परेवाको बचेरा ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पुजारीले त्यो वेदीमा ल्याओस्, त्यसको टाउको निमोठेर चुँडाओस्, र त्यसलाई वेदीमा जलाओस् । त्यसपछि त्यसको रगत वेदीको छेउमा बहाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","त्यसले त्यसका आन्द्राभुँडीलाई त्यसका मलसहित बाहिर निकाली वेदीको पूर्वपट्‍टि खरानी राखिने ठाउँमा फ्याँकोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","त्यसले पखेटाबाट त्यसलाई च्यातोस्, तर त्यसले त्यसलाई दुई टुक्रा नगरोस् । त्यसपछि पुजारीले त्यो वेदीको दाउरामाथिको आगोमा जलाओस् । यो एउटा होमबलि हुने छ, र यसले परमप्रभुको निम्ति मिठो सुगन्ध दिने छ; यो नै आगोबाट चढाइएको बलि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","कसैले परमप्रभुको निम्ति अन्‍नबलि ल्याउँदा, त्यसको बलि मसिनो पिठोको होस्, र त्यसले त्यसमा तेल खन्याओस् र त्यसमा धूप हालोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","त्यसले त्यो भेटी हारूनका छोराहरू, अर्थात् पुजारीहरूकहाँ लगोस्, र त्यहाँ तेल र धूपसहित त्यस मसिनो पिठोबाट पुजारीले एक मुट्ठी निकालोस् । त्यसपछि बलिको रूपमा पुजारीले त्यसलाई जलाओस् । त्यसले परमप्रभुको निम्ति मिठो सुगन्ध दिने छ; यो उहाँको निम्ति आगोद्वारा गरिएको बलि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अन्‍नबलिबाट जे बाँकी रहन्छ त्यो हारून र तिनका छोराहरूको हुने छ । परमप्रभुको निम्ति आगोबाट गरिएका बलिहरूमध्ये यो अति पवित्र हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","चुलोमा पकाइएको अखमिरी अन्‍नबलि चढाउँदा, त्यो तेल मिसाइएको मसिनो पिठोको नरम रोटी होस्, वा त्यो तेल लगाइएको अखमिरी कडा रोटी होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","यदि तिमीहरूको अन्‍नबलि च्याप्टो फलामको तावामा पकाइएको हो भने, त्यो तेल मिसाइएको अखमिरी मसिनो पिठोको होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","त्यसलाई टुक्रा-टुक्रा पार्नू र त्यसमा तेल खन्याउनू । यो अन्‍नबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","यदि तिमीहरूको अन्‍नबलि तावामा पकाइएको हो भने, त्यो मसिनो पिठो र तेलबाट बनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","यी कुराहरूले बनाइएको अन्‍नबलि तिमीहरूले परमप्रभुकहाँ ल्याउनू, र त्यो पुजारीकहाँ लगियोस्, अनि त्यसले त्यो वेदीमा लैजाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","त्यसपछि पुजारीले त्यस अन्‍नबलिबाट केही झिकेर वेदीमा जलाओस् । यो आगोद्वारा गरिएको बलि हुने छ, र यसले परमप्रभुको निम्ति मिठो सुगन्ध दिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्‍नबलिबाट बाँकी रहेका सबै हारून र त्यसका छोराहरूको हुने छ । आगोद्वारा परमप्रभुलाई चढाइएका बलिहरूमध्ये यो परमप्रभुको निम्ति अति पवित्र हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","तिमीहरूले परमप्रभुलाई चढाउने कुनै पनि अन्‍नबलि खमिरद्वारा बनाइनुहुँदैन, किनभने परमप्रभुको निम्ति आगोद्वारा गरिएको बलिमा खमिर वा मह नजलाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तिमीहरूले ती परमप्रभुलाई पहिलो फलहरूको भेटीको रूपमा चढाउनू, तर वेदीमा मिठो सुगन्ध दिनलाई ती प्रयोग नहोऊन् । ");
INSERT INTO npiulb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तिमीहरूले आफ्ना सबै अन्‍नबलिहरूमा नून मिसाउनू । आफ्नो अन्‍नबलिमा आफ्ना परमेश्‍वरको प्रतिज्ञाको नून कहिल्यै नछुटाउनू । आफ्ना सबै भेटीहरूमा तिमीहरूले नून चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","परमप्रभुलाई पहिलो फलहरूको अन्‍नबलि चढाउँदा, आगोमा सेकाइएको र पिसिएको ताजा अन्‍न चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","त्यसपछि त्यसमा तेल र धूप राख्‍नू । यो अन्‍नबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","त्यसपछि पुजारीले पिसिएको अन्‍न, तेल र धूपबाट केही जलाओस् । यो परमप्रभुको निम्ति आगोद्वारा गरिएको बलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","यदि कसैले गाई-गोरुको बथानबाट कुनै पशुको मेलबलिको भेटी चढाउँछ भने, त्यसले परमप्रभुको अगि निष्‍खोट साँढे वा गाई चढाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","त्यसले बलिको टाउकोमा आफ्नो हात राखोस् र त्यसलाई भेट हुने पालको प्रवेशद्वारमा नै मारोस् । त्यसपछि हारूनका छोराहरू अर्थात् पुजारीहरूले त्यसको रगत वेदीको वरिपरि छर्कून् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","त्यस मानिसले परमप्रभुको अगि आगोद्वारा मेलबलि चढाओस् । भित्री भागहरू र दुईवटा मृगौलालाई ढाक्‍ने वा तीसँगै जोडिएको, ");
INSERT INTO npiulb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","र कम्मरसँगै भएको बोसो, र कलेजोको भागलाई मृगौलासमेत त्यसले निकालोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","हारूनका छोराहरूले त्यो वेदीको दाउरामाथिको आगोमा होलबलिसँगै जलाओस् । यसले परमप्रभुको निम्ति मिठो सुगन्ध निकाल्‍ने छ; यो उहाँको निम्ति आगोद्वारा गरिएको बलि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","यदि परमप्रभुको निम्ति कुनै मानिसको मेलबलि भेडा-बाख्राको बगालबाट हो भने, त्यसले निष्‍खोट भाले वा पोथी चढाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","यदि त्यसले बलिको निम्ति थुमा चढाउँछ भने, त्यसले त्यो परमप्रभुको अगि चढाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","त्यसले बलिको टाउकोमाथि आफ्नो हात राखोस् र भेट हुने पालको सामु मारोस् । त्यसपछि हारूनका छोराहरूले त्यसको रगत वेदीको वरिपरि छर्कून् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","त्यस मानिसले मेलबलिलाई परमप्रभुको निम्ति होमबलिझैँ चढाओस् । मेरुदण्डको तल्लो भागको सम्पूर्ण बोसो र आन्द्राभुँडीलाई ढाक्‍ने र तीसँगै भएको जम्मै बोसो, ");
INSERT INTO npiulb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","र दुईवटा मृगौला र कम्मरसँगै भएको बोसो, र कलेजोको भागलाई मृगौलाहरूसँगै त्यसले निकालोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","त्यसपछि पुजारीले परमप्रभुको निम्ति भोजनको होमबलिझैँ वेदीमा ती सबै जलाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","यदि कुनै मानिसको बलि बाख्रा हो भने, त्यसले त्यो परमप्रभुकहाँ चढाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","त्यसले आफ्नो हात त्यस बाख्राको टाउकोमाथि राखोस् र भेट हुने पालको सामु मारोस् । त्यसपछि हारूनका छोराहरूले त्यसको रगत वेदीको वरिपरि छर्कून् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","त्यस मानिसले आगोद्वारा चढाइएको आफ्नो बलिलाई परमप्रभुकहाँ ल्याओस् । त्यसले भित्री भागहरूलाई ढाक्‍ने र तीसँगै भएको बोसोलाई निकालोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","त्यसले दुईवटा मृगौला, तीसँगै भएको बोसो र कम्मरसँगै भएको बोसोलाई कलेजोको भागसँगै निकालोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","पुजारीले भोजनको होमबलिझैँ ती सबै वेदीमा मिठो सुगन्ध निकाल्‍नको निम्ति जलाओस् । सबै बोसोचाहिँ परमप्रभुको हो । ");
INSERT INTO npiulb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","तैँले आफ्नो घर बनाउने हरेक ठाउँमा र तेरा मानिसहरूको पुस्तौँ-पुस्तामा यो सदाको निम्ति एउटा विधि होस्, र तैँले बोसो र रगत नखानू ।’” ");
INSERT INTO npiulb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","परमप्रभु मोशासँग यसो भनेर बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएलका मानिसहरूलाई यस्तो भन्‍नू, ‘यदि परमप्रभुले नगर्नू भनी आज्ञा गर्नुभएका कार्यहरू गरेर कसैले अजानमा पाप गर्छ, र यदि त्यसले निषेध गरिएको कुनै काम गर्छ भने, तल भनिएझैँ गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","यदि मानिसहरूमा दोष ल्याउने गरी मुख्‍य पुजारीले पाप गर्दछ भने, आफूले गरेको पापको निम्ति त्यसले परमप्रभुको अगि पापबलिको रूपमा एउटा निष्‍खोट साँढे ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","त्यसले त्यो साँढेलाई परमप्रभुको अगि भेट हुने पालको प्रवेशद्वारमा ल्याओस्, त्यसको टाउकोमाथि आफ्नो हात राखोस्, र त्यस साँढेलाई परमप्रभुको अगि मारोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","अभिषिक्‍त पुजारीले त्यस साँढेको रगत लिएर भेट हुने पालमा लगोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","त्यस पुजारीले आफ्नो औँलालाई रगतमा चोपेर परमप्रभुको अगि सबैभन्दा पवित्र स्थानको पर्दाअगाडि सात पटक छर्कोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","त्यसपछि पुजारीले परमप्रभुको अगि सुगन्धित धूपको वेदीमा भएका सिङहरूमा केही रगत लगाओस्, र त्यसले साँढेको बाँकी रगत भेट हुने पालको प्रवेशद्वारमा भएको वेदीको मुनि होमबलिको निम्ति खन्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","पापबलिको साँढेको जम्मै बोसो, र भित्री भागहरूलाई ढाक्‍ने र तीसँगै जोडिएको बोसो त्यसले झिकोस्, ");
INSERT INTO npiulb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","दुईवटा मृगौला र त्यसमा भएको बोसो, कम्मरमा भएको बोसो, र कलेजोको भागलाई त्यसले झिकोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","मेलबलिको बलिदानको साँढेबाट झैँ त्यसले त्यो सबै झिकोस् । त्यसपछि पुजारीले होमबलिको निम्ति यी सबै भागलाई वेदीमा जलाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","साँढेको छाला र बाँकी मासु, त्यसको टाउको, खुट्‍टाहरू, भित्री भागहरू र त्यसको गोबर, ");
INSERT INTO npiulb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","र साँढेका अरू बाँकी सबै भागहरूलाई त्यसले छाउनीभन्दा बाहिरको ठाउँमा लगोस् जुन ठाउँ तिनीहरूले मेरो निम्ति शुद्ध बनाएका छन् र जहाँ तिनीहरूले खरानी खन्याउँछन्; ती भागहरूलाई तिनीहरूले त्यहाँ दाउरामा जलाऊन् । तिनीहरूले जहाँ खरानी खन्याउँछन्, त्यहीँ नै ती भागहरू जलाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","यदि इस्राएलको जम्मै समुदायले पाप गर्न नचाहँदा-नचाहँदै पाप गर्दछ भने, र तिनीहरूले पाप गरेका छन् र परमप्रभुले नगर्नू भनी आज्ञा गर्नुभएका कुनै कार्यहरू तिनीहरूले गरेका छन् भन्‍ने विषयमा त्यो समुदाय अजान छ, र तिनीहरू दोषी छन् भने, ");
INSERT INTO npiulb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","तिनीहरूले गरेका पाप प्रकट भएपछि त्यस समुदायले पापबलिको निम्ति एउटा साँढे चढाओस् र त्यसलाई भेट हुने पालको अगाडि ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","त्यस समुदायका एल्डरहरूले परमप्रभुको अगि त्यस साँढेको टाउकोमाथि आफ्ना हातहरू राखून्, र त्यसलाई परमप्रभुको अगि मारून् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","अभिषिक्‍त पुजारीले साँढेको केही रगत भेट हुने पालमा ल्याओस्, ");
INSERT INTO npiulb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","र पुजारीले आफ्नो औँला त्यस रगतमा चोपेर परमप्रभुको अगि पर्दाको सामु सात पटक छर्कोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","परमप्रभुको सामु रहेको भेट हुने पालको वेदीमा त्यसले केही रगत खन्याओस्, र सबै रगत त्यसले भेट हुने पालको प्रवेशद्वारमा रहेको वेदीमुनि होमबलिको निम्ति खन्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","त्यसले त्यसबाट सबै बोसो झिकोस् र त्यसलाई वेदीमा जलाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","त्यसले त्यस साँढेलाई गर्नुपर्ने यस्तै नै हो । पापबलिको साँढेलाई त्यसले जे गरेको थियो, यस साँढेलाई पनि त्यस्तै गरोस्, र पुजारीले मानिसहरूका निम्ति प्रायश्‍चित्त गर्ने छ, र तिनीहरूलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","त्यसले साँढेलाई छाउनीको बाहिर लगोस् र पहिलो साँढेलाई झैँ त्यसले त्यो जलाओस् । यो नै समुदायको निम्ति पापबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","शासन गर्ने कोहीले उसका परमप्रभु परमेश्‍वरले नगर्नू भनी आज्ञा गर्नुभएका कुराहरूमध्ये कुनै गरी अजानमा पाप गर्दछ, र त्यो दोषी ठहरियो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","त्यसले गरेको पाप उसलाई प्रकट गरिँदा, त्यसले बलिको निम्ति निष्‍खोट बोको ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","त्यसले त्यस बोकोको टाउकोमाथि आफ्नो हात राखोस् र परमप्रभुको अगि होमबलिलाई मार्ने स्थानमा त्यसलाई मारोस् । यो पापबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","पुजारीले आफ्नो औँलाले पापबलिको रगत लिएर होमबलिको वेदीका सिङहरूमा लगाओस्, र होमबलिको वेदीको फेदमा त्यसले त्यसको रगत खन्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","मेलबलिको बोसोझैँ त्यसले जम्मै बोसो वेदीमा जलाओस् । त्यस शासकको पापको निम्ति पुजारीले प्रायश्‍चित्त गर्ने छ, र त्यस शासकलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","यदि आम मानिसमध्ये कसैले परमप्रभुले उसलाई नगर्नू भनी आज्ञा गर्नुभएका कुराहरूमध्ये कुनै गरी अजानमा पाप गर्दछ, ");
INSERT INTO npiulb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","र त्यसले गरेको पाप उसलाई प्रकट गरिँदा त्यसले आफ्नो दोष स्वीकार्छ भने, त्यसले आफूले गरेको पापको निम्ति एउटा निष्‍खोट बाख्री बलिको लागि ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","त्यसले त्यस पापबलिको टाउकोमाथि आफ्नो हात राखोस् र होमबलिकै स्थानमा त्यस पापबलिलाई मारोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","पुजारीले केही रगत आफ्नो औँलामा लिएर होमबलिको वेदीका सिङहरूमा लगाओस् । बाँकी रगतचाहिँ त्यसले वेदीको फेदमा खन्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","मेलबलिबाट झैँ त्यसले जम्मै बोसोलाई काटी झिकोस् । परमप्रभुको निम्ति मिठो सुगन्ध दिनको निम्ति पुजारीले त्यो वेदीमा जलाओस् । पुजारीले त्यस मानिसको निम्ति प्रायश्‍चित्त गर्ने छ, र उसलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","यदि त्यस मानिसले पापबलिको निम्ति भेडाको बच्‍चा ल्याउँछ भने, त्यसले एउटा निष्‍खोट पाठी ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","त्यसले आफ्नो हात त्यस पापबलिको टाउकोमाथि राखोस् र होमबलिलाई मार्ने स्थानमा त्यसलाई पापबलिको निम्ति मारोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","पुजारीले पापबलिको केही रगत आफ्नो औँलामा लिएर होमबलिको वेदीका सिङहरूमा लगाओस्, र त्यसको जम्मै रगत त्यसले वेदीको फेदमा खन्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","मेलबलिको निम्ति चढाइएको भेडाको बच्‍चाको बोसोझैँ त्यसले जम्मै बोसो काटी झिकोस्, र पुजारीले परमप्रभुको वेदीमाथिको होमबलिमा त्यो जलाओस् । पुजारीले त्यस मानिसले गरेको पापको निम्ति प्रायश्‍चित्त गर्ने छ, र त्यस मानिसलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","यदि कसैले आफूले देखेको वा सुनेको कुनै कुराको साक्षी भएर पनि त्यस कुराको गवाही दिनुपर्ने अवस्थामा गवाही नदिएको कारणले पाप गर्दछ भने, त्यो दोषी हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","वा परमेश्‍वरले अशुद्ध ठहराउनुभएको कुनै कुरा कसैले छोयो भने, चाहे त्यो कुनै अशुद्ध वन-पशु, पाल्तु पशु वा घस्रने पशुको मृत शरीर होस्, त्यसले त्यो अजानमा छोएको भए तापनि त्यो अशुद्ध र दोषी हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","वा त्यसले कसैको अशुद्धता छोयो भने, चाहे त्यो अशुद्धता जेसुकै होस्, र त्यसबारे त्यो अजान छ भने, त्यसबारे त्यसलाई थाहा भएपछि त्यो दोषी हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","वा कसैले खराब वा असल गर्न आफ्नो मुखबाट विचारै नगरेर किरिया हाल्छ भने, त्यसले जेसुकैको किरिया हालेको भए तापनि, यदि त्यसबारे त्यो अजान छ भने, त्यसबारे त्यसलाई थाहा भएपछि त्यो यी सबै कुराहरूमा दोषी हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","यी कुराहरूमा कोही दोषी ठहरिएपछि त्यसले जेसुकै पाप गरेको भए तापनि त्यसले त्यो स्वीकार गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","त्यसपछि त्यसले आफूले गरेको पापको निम्ति परमप्रभुकहाँ दोषबलिको रूपमा बगालबाट पोथी पशु, पाठी वा बाख्री पापबलिको निम्ति ल्याओस्, र त्यसको पापको निम्ति पुजारीले प्रायश्‍चित्त गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","यदि त्यससँग पाठी किन्‍ने औकात छैन भने, त्यसले आफ्नो पापको निम्ति परमप्रभुकहाँ दोषबलिको रूपमा दुईवटा ढुकुर वा दुईवटा परेवाका बच्‍चा ल्याओस्, एउटाचाहिँ पापबलिको निम्ति र अर्को होमबलिको निम्ति । ");
INSERT INTO npiulb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","त्यसले त्यो पुजारीकहाँ ल्याओस्, जसले पहिला एउटालाई पापबलिको निम्ति अर्पण गर्ने छ । त्यसले त्यसको घाँटीबाट त्यसको टाउको निमोठोस्, तर त्यसको शरीरबाट त्यसलाई पूर्ण रूपमा नछुटाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","त्यसपछि त्यसले पापबलिको केही रगत वेदीको वरिपरि छर्कोस्, र बाँकी रगतचाहिँ वेदीको फेदमा खन्याओस् । योचाहिँ पापबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","त्यसपछि निर्देशनहरूमा वर्णन गरिएअनुसार त्यसले दोस्रो चरोलाई होमबलिको रूपमा अर्पण गरोस्, र त्यसले गरेको पापको निम्ति पुजारीले प्रायश्‍चित्त गर्ने छ, र त्यस मानिसलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","तर यदि त्यससँग दुई ढुकुर वा दुई परेवाका बच्‍चा किन्‍ने औकात छैन भने, त्यसले आफ्नो पापको निम्ति बलिको रूपमा आधा पाथी मसिनो पिठोको पापबलि ल्याओस् । त्यो पापबलि भएको कारण त्यसले त्यसमा तेल वा धूप नराखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","त्यसले त्यो पुजारीकहाँ ल्याओस्, र पुजारीले त्यसबाट एक मुट्ठी चिन्हको रूपमा लिएर परमप्रभुको निम्ति वेदीमा आगोको बलिमाथि जलाओस् । यो पापबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","त्यस मानिसले गरेका सबै पापको निम्ति पुजारीले प्रायश्‍चित्त गर्ने छ, र त्यस मानिसलाई क्षमा हुने छ । अन्‍नबलिमा झैँ भेटीबाट बाँकी रहेको जति सबै पुजारीको हुने छ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","अनि परमप्रभु मोशासँग यसो भनेर बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“यदि कसैले अजानमा परमप्रभुका कुराहरूको सम्बन्धमा पाप गर्दछ र अविश्‍वासपूर्वक काम गर्दछ भने, त्यसले परमप्रभुकहाँ आफ्नो दोषबलि ल्याओस् । यो बलिचाहिँ दोषबलिको रूपमा बगालको निष्‍खोट भेडा होस्; जसको मूल्य पवित्रस्थानको चाँदीको शेकेल बराबरको हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","जे पवित्र छ त्यसको विरुद्ध गरेको पापको कारण त्यसले परमप्रभुलाई प्रसन्‍न तुल्याउनुपर्छ, र त्यसमा पाँचौँ भाग थपेर पुजारीलाई दिनुपर्छ । त्यसपछि दोषबलिको त्यो भेडा लिएर पुजारीले त्यस मानिसको निम्ति प्रायश्‍चित्त गर्ने छ, र त्यसलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","परमप्रभुले नगर्नू भनी आज्ञा गर्नुभएको कुनै कुरा कसैले गर्दछ भने, त्यसबारे त्यो अजान भए तापनि, त्यो दोषी हुने छ र आफ्नो दोषको भार त्यसले आफैँ बोक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","त्यसले बगालबाट प्रचलित मूल्य बराबरको एउटा निष्‍खोट भेडा पुजारीकहाँ दोषबलिको रूपमा ल्याओस् । त्यसले अजानमा गरेको पापको निम्ति पुजारीले प्रायश्‍चित्त गर्ने छ, र त्यसलाई क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यो दोषबलि हो, र त्यो निश्‍चय नै परमप्रभुको अगि दोषी छ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","परमप्रभु यसो भनेर मोशासँग बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“यदि कसैले विश्‍वासमा कायम भएको कुनै कुरा, वा वास्ता गर्नका निम्ति भनेर उसलाई राख्‍न दिइएको वा चोरी भएको कुनै कुराको विषयमा परमप्रभुको विरुद्ध पाप गर्दछ र विश्‍वासहीन कार्य गर्दछ, वा आफ्नो छिमेकीमाथि त्यसले अत्याचार गर्दछ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","वा आफ्नो छिमेकीको कुनै हराएको कुरा त्यसले पाएर त्यसबारे झुटो बोल्छ, वा झुटो किरिया हाल्छ, वा मानिसहरूले पाप गर्ने यी कार्यहरूजस्तो कुनै गर्दछ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","र यदि त्यसले पाप गरेको छ र त्यो दोषी ठहरियो भने, त्यसले चोरी गरेर वा अत्याचार गरेर लिएको, वा त्यसको जिम्मामा भएको, वा हराएर त्यसले पाएको सबै फिर्ता गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","साथै, त्यसले कुनै विषयमा झुटो किरिया हालेको भए, त्यो दोषी ठहरिएको दिनमा त्यसले त्यो पूर्ण रूपमा फिर्ता गरोस्, र त्यसको मूल्यको पाँचौँ भाग थपेर त्यसको मालिकलाई दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","त्यसपछि त्यसले परमप्रभुको अगि बगालबाट प्रचलित मूल्य बराबरको एउटा निष्‍खोट भेडा दोषबलि ल्याओस् र पुजारीलाई दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","पुजारीले परमप्रभुको अगि त्यसको निम्ति प्रायश्‍चित्त गर्ने छ, र त्यसले जेसुकै गरेर दोषी भएको भए तापनि त्यसलाई क्षमा हुने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","अनि परमप्रभु यसो भनेर मोशासँग बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून र त्यसका छोराहरूलाई यसो भनेर आज्ञा गर्नू, ‘होमबलिको विधि यस्तो रहेको छः होमबलि रातभर र बिहानसम्मै वेदीको चुल्होमाथि रहोस्, र वेदीको आगो बलिरहोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","पुजारीले आफ्ना सूतीका पोशाकहरू र भित्री वस्‍त्रहरू पहिरिने छ । होमबलि पूर्ण रूपमा आगोमा जलिसकेपछि त्यसबाट निस्केको खरानी त्यसले लिने छ, र त्यस खरानीलाई वेदीको छेउमा राख्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","त्यसले आफ्ना वस्‍त्रहरू फुकाल्‍ने छ र छाउनीभन्दा बाहिर शुद्ध स्थानमा खरानी लैजानको निम्ति अर्को वस्‍त्र पहिरिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदीको आगोलाई भने बालिराख्‍नू । त्यो ननिभोस्, र पुजारीले हरेक बिहान त्यसमा दाउरा बालोस् । त्यसले आवश्‍यक भएअनुसार त्यसमा होमबलिलाई मिलाएर राख्‍ने छ, र मेलबलिको बोसोलाई त्यसमा जलाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीमा आगो निरन्तर बालिराख्‍नू । त्यो ननिभोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","अन्‍नबलिको विधि यस्तो रहेको छ । परमप्रभुको अगि वेदीको सामु हारूनका छोराहरूले त्यो अर्पण गरून् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","अन्‍नबलिको पिठो, तेल र धूपबाट पुजारीले एक मुट्ठी चिन्हको रूपमा लिएर मिठो सुगन्ध दिनको निम्ति वेदीमा जलाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","हारून र उसका छोराहरूले त्यस भेटीबाट बाँकी रहेका सबै खाऊन् । त्यो सबै खमिर नराखीकन कुनै एउटा पवित्र स्थानमा खाइनुपर्छ । तिनीहरूले त्यो भेट हुने पालको चोकमा खाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","त्यो खमिर राखेर पकाउनुहुँदैन । आगोद्वारा गरिने मेरा बलिहरूबाट तिनीहरूको भाग हुनलाई मैले त्यो दिएको छु । पापबलि र दोषबलिझैँ यो अति पवित्र छ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","तेरा मानिसहरूको पुस्तामा सधैँ, हारूनको वंशबाटको कुनै पुरुषले आगोबाट परमप्रभुको निम्ति चढाइएको बलिबाट आफ्नो हिस्साको रूपमा त्यो खान सक्‍ने छ । जसले ती छुन्छ त्यो पवित्र हुने छ ।’” ");
INSERT INTO npiulb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","यसैकारण परमप्रभु मोशासँग यसो भनेर फेरि बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“हारून र त्यसका छोराहरूले हरेक छोराको अभिषेक गर्ने दिनमा परमप्रभुलाई अर्पण गर्ने बलि यस प्रकार रहेको छः नियमित अन्‍नबलिझैँ आधा पाथी मसिनो पिठो, आधाचाहिँ बिहान र आधा साँझ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","त्यसलाई पकाउने भाँडामा तेलसँग मिसाएर बनाइयोस् । त्यो भिजेपछि भित्र ल्याउनू । त्यो पाकेपछि अन्‍नबलिलाई टुक्रा गरी परमप्रभुको निम्ति मिठो सुगन्ध दिनको निम्ति अर्पण गरियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","प्रधान पुजारीका छोराहरूमध्ये हुनेवाला प्रधान पुजारीले त्यो अर्पण गरोस् । सधैँ आज्ञा गरिएझैँ ती सबै परमप्रभुको निम्ति जलाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","पुजारीका सबै अन्‍नबलि पूर्ण रूपमा जलाइयोस् । त्यो खानुहुँदैन ।” ");
INSERT INTO npiulb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","परमप्रभु मोशासँग यसो भनेर फेरि बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून र त्यसका छोराहरूलाई यसो भन्, ‘पापबलिको विधि यस्तो रहेको छः परमप्रभुको अगि होमबलिलाई जुन ठाउँमा मरिन्छ पापबलिलाई पनि त्यहीँ मार्नू । यो अति पवित्र हो । ");
INSERT INTO npiulb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","पापको निम्ति अर्पण गर्ने पुजारीले नै त्यो खाओस् । भेट हुने पालको चोकको कुनै एउटा पवित्र स्थानमा त्यो खाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","त्यसको मासु छुने सबै कुरा पवित्र हुने छ, र यदि कुनै वस्‍त्रमा रगतको छिट्का लागेको भए त्यस छिट्का लागेको ठाउँलाई पवित्र स्थानमा धुनू । ");
INSERT INTO npiulb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","तर त्यो उमाल्‍न प्रयोग गरिएको माटोको भाँडालाई भने फुटाउनू । यदि त्यो काँसाको भाँडामा उमालिएको भए, त्यसलाई माँझेर सफा पानीले धुनू । ");
INSERT INTO npiulb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","पुजारीहरूमध्ये जुनसुकै पुरुषले त्यसबाट खान सक्छ किनभने त्यो अति पवित्र हो । ");
INSERT INTO npiulb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","तर पवित्र स्थानमा प्रायश्‍चित्त गर्नको निम्ति भेट हुने पालभित्र ल्याइएको कुनै पनि पापबलिको रगत भने नखानू । त्यो जलाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","दोषबलिको विधि यस्तो रहेको छ । यो अति पवित्र हो । ");
INSERT INTO npiulb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","दोषबलिलाई मार्ने स्थानमा नै तिनीहरूले त्यो मारून्, र वेदी वरिपरिको सबै ठाउँमा त्यसको रगत छर्कून् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","त्यसभित्र भएका सबै बोसो अर्पण गरिने छः अर्थात् बोसे पुच्छर, भित्री अङ्गहरू ढाक्‍ने बोसो, ");
INSERT INTO npiulb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दुवै मृगौला र तिनलाई ढाक्‍ने बोसो, कम्मरनेरको बोसो, र मृगौलासँगै कलेजोलाई ढाक्‍ने बोसो सबै झिक्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पुजारीले आगोद्वारा चढाइने बलिको रूपमा यी सबै भागहरूलाई वेदीमा जलाओस् । यो दोषबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","पुजारीहरूमध्ये सबै पुरुषले यस बलिबाट केही भाग खान सक्छन् । यो कुनै पवित्र ठाउँमा खानू किनभने यो अति पवित्र हो । ");
INSERT INTO npiulb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","पापबलि पनि दोषबलिजस्तै हो । यी दुवैका एउटै विधि छन् । तिनीहरूका निम्ति प्रायश्‍चित्त गर्ने पुजारीकै ती हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","अरूको होमबलिलाई अर्पण गर्ने पुजारीले त्यस होमबलिको छाला आफ्नो निम्ति राख्‍न सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","चुलोमा बनाइएका सबै अन्‍नबलि र ताइताप्‍के वा ताउमा पकाइएका सबै बलि अर्पण गर्ने पुजारीकै हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","सुक्‍खा वा तेलसँग मिसाइएका सबै अन्‍नबलि समान रूपमा हारूनका वंशको हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","परमप्रभुलाई मानिसहरूले अर्पण गर्ने मेलबलिको भेटीको विधि यस्तो रहेको छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","यदि कसैले त्यो धन्यवाद दिनको निम्ति अर्पण गर्दछ भने, त्यसले त्यो खमिर नराखी तेलमा मिसाएर बनाइएको रोटी, खमिर नराखी माथिबाट तेल लगाइएको रोटी, र मसिनो पिठोलाई तेलमा मिसाएर बनाइएको रोटीको भेटीद्वारा अर्पण गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","साथै, धन्यवाद दिनको निम्ति, आफ्नो मेलबलिसित त्यसले खमिर राखेर बनाइएको रोटी पनि अर्पण गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","परमप्रभुको निम्ति अर्पण गरिएको भेटीस्वरूप यी बलिहरूका हरेक प्रकारबाट एउटा-एउटा त्यसले अर्पण गरोस् । यो भेटी मेलबलिको रगतलाई वेदीमा छर्कने पुजारीकै हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","धन्यवाद दिनको निम्ति मेलबलि अर्पण गर्ने मानिसले आफ्नो बलिदानको मासु बलिकै दिनमा खानू । त्यसबाट कत्ति पनि अर्को बिहानीको निम्ति त्यसले नछोडोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","तर यदि त्यसको भेटी प्रतिज्ञाको निम्ति बलिदान भएमा, त्यसले बलिदानलाई अर्पण गर्ने दिनमा नै त्यो खाइयोस्, तर त्यसबाट बाँकी रहेको जति अर्को दिन खान सकिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","तर तेस्रो दिनसम्म बलिदानको जे जति मासु बाँकी रहन्छ, त्योचाहिँ जलाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","यदि कसैको मेलबलिको मासु तेस्रो दिनमा खाइयो भने, त्यो स्वीकारिने छैन, न त त्यो अर्पण गर्नेको निम्ति अर्पण गरिएको गनिने छ । यो अति घृणित कुरो हो, र यो खाने मानिसले आफ्नो पापको दोष बोकिरहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","कुनै पनि अशुद्ध कुरा छोएको मासु नखानू । त्यो जलाइयोस् । अरू मासुचाहिँ जुन शुद्ध छ, त्यसले खाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","तर यदि परमप्रभुको मेलबलिको भेटीबाट कुनै अशुद्ध मानिसले खान्छ भने, त्यो व्यक्‍ति आफ्ना मानिसहरूबाट बहिष्‍कार गरियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","यदि कसैले कुनै अशुद्ध कुरा जस्तै कुनै मानिस वा अशुद्ध पशु, वा कुनै अशुद्ध र तुच्छ वस्तुको अशुद्धतालाई छोएर परमप्रभुको मेलबलिको भेटीको मासु खायो भने, त्यो व्यक्‍ति आफ्ना मानिसहरूबाट बहिष्‍कार गरियोस् ।’” ");
INSERT INTO npiulb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","अनि परमप्रभु यसो भनेर मोशासँग बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलका मानिसहरूलाई यस्तो भन्, ‘तिमीहरूले कुनै गोरु, वा भेडा वा बोकोको बोसो नखानू । ");
INSERT INTO npiulb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","बलिको रूपमा अर्पण नगरी मरेको पशुको बोसो, वा वन-पशुहरूले मारेको पशुको बोसो अरू कामको निम्ति प्रयोग गर्न मिल्छ, तर निश्‍चय नै त्यो नखानू । ");
INSERT INTO npiulb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","परमप्रभुको निम्ति आगोद्वारा चढाइने बलिको निम्ति मानिसहरूद्वारा अर्पण गर्न बाँकी पशुको बोसो जसले खान्छ, त्यो व्यक्‍ति आफ्ना मानिसहरूबाट बहिष्‍कार गरियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","तिमीहरूका घरहरूमा कुनै पक्षी वा पशुको रगत नखानू । ");
INSERT INTO npiulb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जसले रगत खान्छ, त्यो आफ्ना मानिसहरूबाट बहिष्‍कार गरियोस् ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","परमप्रभु मोशासँग यसरी बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलका मानिसहरूलाई यस्तो भन्, ‘परमप्रभुलाई मेलबलिको भेटी अर्पण गर्ने मानिसले आफ्नो बलिदानको भाग परमप्रभुकहाँ ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","आगोद्वारा परमप्रभुलाई अर्पण गरिने बलिदानचाहिँ त्यस मानिसको आफ्नै हातबाट ल्याइयोस् । त्यसले बलिको छातीसित त्यसको बोसो पनि ल्याओस्, र छातीचाहिँ परमप्रभुको अगि डोलाइने बलिको रूपमा डोलाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","पुजारीले बोसोलाई वेदीमा जलाओस्, तर छातीचाहिँ हारून र त्यसका वंशको हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","तैँले पुजारीलाई तेरा मेलबलिहरूबाट बलिदानको रूपमा दाहिने फिला भेटी दिनू । ");
INSERT INTO npiulb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारूनका सन्तानहरूमध्ये मेलबलिहरूको रगत र बोसोलाई अर्पण गर्ने पुजारीले बलिदानबाट दाहिने फिला हिस्साको रूपमा लिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","किनभने मैले इस्राएलका मानिसहरूबाट डोलाइने बलिको छाती र योगदानको रूपमा फिला लिएको छु, र ती पुजारी हारून र त्यसका छोराहरूलाई सदाको निम्ति हिस्सास्वरूप दिइएको छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","पुजारीको कार्यमा परमप्रभुको निम्ति सेवा पुर्‍याउनलाई हारून र त्यसका सन्तानलाई मोशाले अर्पण गरेको दिनमा परमप्रभुको निम्ति आगोद्वारा चढाइएको बलिदानबाट तिनीहरूका निम्ति हिस्सा यही नै हो । ");
INSERT INTO npiulb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","परमप्रभुले पुजारीहरूलाई अभिषेक गर्नुभएको दिनमा इस्राएलका मानिसहरूबाट तिनीहरूलाई दिनको निम्ति उहाँले आज्ञा गर्नुभएको हिस्सा यही नै हो । सबै पुस्ताहरूमा यो तिनीहरूकै हिस्सा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","होमबलि, अन्‍नबलि, पापबलि, दोषबलि, अभिषेकको बलि र मेलबलिका विधि यी नै हुन्, ");
INSERT INTO npiulb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जुन परमप्रभुले सीनैको मरुभूमिमा इस्राएलका मानिसहरूलाई आफ्ना बलिदानहरू परमप्रभुलाई अर्पण गर्नू भनी आज्ञा दिनुभएको दिनमा सीनै पर्वतमा मोशालाई आज्ञा गर्नुभयो’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","परमप्रभुले मोशालाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून र त्यसका छोराहरूलाई वस्‍त्रहरू र अभिषेक गर्ने तेल, पापबलिको साँढे, दुईवटा भेडा र अखमिरी रोटीको डालोसहित ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","भेट हुने पालको प्रवेशद्वारमा सबै समुदायलाई भेला गर्नू ।” ");
INSERT INTO npiulb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ उनले गरे, र सबै समुदाय भेट हुने पालको प्रवेशद्वारमा भेला भए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","अनि मोशाले समुदायलाई भने, “परमप्रभुले गर्नू भनेर आज्ञा गर्नुभएको यही नै हो ।” ");
INSERT INTO npiulb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","मोशाले हारून र तिनका छोराहरूलाई ल्याएर पानीले धोए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","उनले हारूनलाई दौरा लगाइदिए र तिनको कम्मरमा फिता लगाइदिए, अनि तिनलाई लबेदा पहिराइदिएर एपोद लगाइदिए, र असल प्रकारले बुनिएको पटुकाले एपोद कसे अनि बाँधिदिए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","उनले तिनलाई छाती-पाता लगाइदिए, र छाती-पातामा ऊरीम र तुम्मीम राखिदिए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","उनले तिनको शिरमा फेटा लगाइदिए, र परमप्रभुले उनलाई आज्ञा गर्नुभएझैँ त्यस फेटाको अगाडिपट्टि सुनको पाता, अर्थात् पवित्र मुकुट लगाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मोशाले अभिषेक गर्ने तेल लिएर पवित्र वासस्थान र त्यसमा भएका सबै कुरालाई अभिषेक गरे र परमप्रभुको निम्ति ती अलग गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","उनले सात पटक वेदीमा तेल छर्के, अनि वेदी र त्यसका सबै भाँडाकुँडाहरू, धुने बाटा र त्यसको फेदसमेत परमप्रभुको निम्ति अलग गर्नलाई अभिषेक गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","उनले केही अभिषेक गर्ने तेल हारूनको शिरमा खन्याए र तिनलाई पनि परमप्रभुको निम्ति अलग गर्नलाई अभिषेक गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","मोशाले हारूनका छोराहरूलाई ल्याएर दौरा पहिराइदिए । परमप्रभुले उनलाई आज्ञा गर्नुभएअनुसार उनले तिनीहरूका कम्मरमा फिता लगाइदिए र तिनीहरूका शिरमा सुतीको कपडाको फेटा बेरिदिए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","मोशाले पापबलिको साँढे ल्याए, अनि हारून र तिनका छोराहरूले आफ्ना हात त्यस पापबलिको साँढेको टाउकोमाथि राखे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","उनले त्यो मारे, र रगत लिएर आफ्नो औँलाले वेदीका सिङहरूमा लगाए, अनि वेदीलाई पवित्र गराएर वेदीको फेदमा रगत खन्याए, र त्यसको निम्ति प्रायश्‍चित्त गर्नलाई वेदीलाई परमप्रभुको निम्ति अलग गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मोशाले भित्री भागहरूमा भएका सबै बोसो, कलेजोलाई ढाक्‍ने भाग, दुवै मृगौला र तिनका बोसो लिए र ती सबै वेदीमा जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","तर परमप्रभुले उनलाई आज्ञा गर्नुभएझैँ उनले त्यो साँढे, त्यसको छाला, त्यसको मासु, र गोबरलाई छाउनीबाहिर जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","मोशाले होमबलिको निम्ति भेडालाई अर्पण गरे, अनि हारून र तिनका छोराहरूले आफ्ना हात त्यस भेडाको शिरमा राखे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","उनले त्यो मारे र त्यसको रगतलाई वेदीको सबैतिर छर्के । ");
INSERT INTO npiulb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","उनले त्यस भेडालाई टुक्रा-टुक्रा गरी काटे र त्यसको टाउको, ती टुक्राहरू र बोसोलाई जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","उनले त्यसका भित्री भागहरू र खुट्टाहरूलाई पानीले पखाले, र पुरै भेडालाई वेदीमा जलाए । त्यो होमबलि थियो र परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ त्यसले परमप्रभुको निम्ति आगोद्वारा चढाइने बलिदानस्वरूप मिठो सुगन्ध दियो । ");
INSERT INTO npiulb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","अनि मोशाले अर्को भेडा, अर्थात् पवित्रीकरणको भेडा पनि अर्पण गरे, अनि हारून र तिनका छोराहरूले आफ्ना हात त्यस भेडाको शिरमा राखे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","हारूनले त्यो मारे, र मोशाले त्यसको केही रगत लिएर हारूनको दाहिने कानको टुप्‍पो, दाहिने हातको बुढी औँला, र दाहिने खुट्टाको बुढी औँलामा लगाइदिए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","उनले हारूनका छोराहरूलाई ल्याए, र तिनीहरूका दाहिने कानको टुप्‍पो, दाहिने हातको बुढी औँला र दाहिने खुट्टाको बुढी औँलामा केही रगत लगाइदिए । त्यसपछि मोशाले त्यसको रगत वेदीको सबैतिर छर्के । ");
INSERT INTO npiulb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","उनले बोसो, बोसे-पुच्छर, भित्री भागहरूमा भएका सबै बोसो, कलेजोलाई ढाक्‍ने भाग, दुवै मृगौला र त्यसको बोसो, र दाहिने फिला लिए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","परमप्रभुको सामु भएको अखमिरी रोटीको डालोबाट उनले एउटा अखमिरी रोटी, एउटा तेल मिसाइएको रोटी र एउटा पापड लिएर बोसो र दाहिने फिलामा राखे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","उनले ती सबै हारून र तिनका छोराहरूका हातमा राखे र डोलाइने बलिस्वरूप परमप्रभुको अगि डोलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","त्यसपछि मोशाले ती सबै तिनीहरूका हातबाट लिए र होमबलिको निम्ति वेदीमा जलाए । मिठो सुगन्ध दिने अभिषेकको बलि यही थियो । ");
INSERT INTO npiulb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मोशाले रोटी लिए र परमप्रभुको निम्ति डोलाइने बलिको रूपमा डोलाए । परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ पुजारी-अर्पणको भेडा मोशाकै भाग थियो । ");
INSERT INTO npiulb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","मोशाले वेदीमा भएको केही अभिषेक गर्ने तेल र रगत लिए, अनि हारून, तिनका वस्‍त्र, तिनका छोराहरू र तिनीसँगै तिनका छोराहरूका वस्‍त्रमा छर्किदिए । यसरी उनले हारून र तिनका वस्‍त्र, र तिनका छोराहरू र तिनीहरूका वस्‍त्र सबै परमप्रभुको निम्ति अलग गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","यसैकारण मोशाले हारून र तिनका छोराहरूलाई भने, “भेट हुने पालको प्रवेशद्वारमा मासुलाई उमाल्नू, र मैले ‘हारून र तिनका छोराहरूले खाऊन्’ भनेर आज्ञा गरेझैँ अभिषेकको डालोमा भएको रोटीसहित त्यसलाई त्यहीँ खाओ । ");
INSERT INTO npiulb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","मासु र रोटीबाट जे बाँकी हुन्छ त्यसलाई जलाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","तिमीहरूको अर्पणको काम पुरा नभएसम्म अर्थात् सात दिनसम्म भेट हुने पालको प्रवेशद्वारभन्दा बाहिर नजानू । किनभने परमप्रभुले तिमीहरूलाई सात दिनसम्म अभिषेक गर्नुहुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","आजको दिनमा जे गरियो, त्यो तिमीहरूको प्रायश्‍चित्तको निम्ति परमप्रभुले आज्ञा गर्नुभएको हो । ");
INSERT INTO npiulb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","तिमीहरू भेट हुने पालको प्रवेशद्वारमा सात दिनसम्म दिन र रात बस्‍नू, र परमप्रभुको आज्ञा मान्‍नू, अनि तिमीहरू मर्ने छैनौ, किनभने मलाई यस्तै आज्ञा भएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","यसैकारण हारून र तिनका छोराहरूले परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएका सबै कुरा गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठौँ दिनमा मोशाले हारून, तिनका छोराहरू र इस्राएलका धर्म-गुरुहरूलाई बोलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","उनले हारूनलाई भने, “पापबलिको निम्ति बगालबाट एउटा बाछो, र होमबलिको निम्ति एउटा निष्‍खोट भेडा लिएर परमप्रभुको अगि अर्पण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","इस्राएलका मानिसहरूलाई यसो भन्‍नू, ‘पापबलिको निम्ति एउटा बोको र होमबलिको निम्ति एक-एक वर्षको निष्‍खोट बाछो र भेडाको बच्‍चा लिनू, ");
INSERT INTO npiulb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","र परमप्रभुको अगि बलिदानको निम्ति मेलबलिस्वरूप एउटा साँढे र एउटा भेडा, र तेल मिसाइएको अन्‍नबलि लिनू, किनभने आज परमप्रभु तिमीहरूकहाँ देखा पर्नुहुने छ ।’” ");
INSERT INTO npiulb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","यसैकारण मोशाले भनेअनुसार तिनीहरूले सबै कुरा भेट हुने पालमा ल्याए, र इस्राएलका सबै समुदाय परमप्रभुको सामु आई खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","अनि मोशाले भने, “परमप्रभुको महिमा तिमीहरूको सामु प्रकट होस् भनेर उहाँले तिमीहरूलाई आज्ञा गर्नुभएका कुरा यी नै हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मोशाले हारूनलाई भने, “परमप्रभुले आज्ञा गर्नुभएझैँ वेदीको नजिक आऊ र आफ्नो पापबलि र होमबलि अर्पण गर, र आफ्नै निम्ति र मानिसहरूका निम्ति प्रायश्‍चित्त गर, र मानिसहरूका निम्ति प्रायश्‍चित्तस्वरूप बलिदानलाई अर्पण गर ।” ");
INSERT INTO npiulb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","यसैकारण हारून वेदीको नजिक गए अनि आफ्नै निम्ति पापबलिको बाछो मारे । ");
INSERT INTO npiulb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","हारूनका छोराहरूले तिनको सामु रगत टक्र्याए, अनि तिनले आफ्नो औँलालाई रगतमा चोपेर वेदीका सिङहरूमा लगाए, र त्यसपछि तिनले रगतलाई वेदीको फेदमा खन्याए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","तर परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ तिनले बोसो, मृगौलाहरू, र कलेजोलाई ढाक्‍ने भागलाई पापबलिस्वरूप वेदीमा जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","मासु र छाला भने छाउनीभन्दा बाहिर जलाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","हारूनले होमबलिलाई जलाए, र तिनका छोराहरूले तिनलाई रगत दिए र तिनले त्यो रगतलाई वेदीको सबैतिर छर्के । ");
INSERT INTO npiulb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","तिनीहरूले होमबलिलाई टुक्रा-टुक्रा गरी टाउकोसमेत तिनलाई दिए र तिनले ती सबै वेदीमा जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","तिनले भित्री भागहरू र खुट्टाहरूलाई धोए र ती सबैलाई वेदीको होमबलिमाथि जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","हारूनले मानिसहरूका बलिदानको भेटीस्वरूप एउटा बोको अर्पण गरे, र तिनीहरूका पापको निम्ति बलिदानको रूपमा त्यसलाई लिएर मारे; तिनले पहिलो बोकोलाई गरेझैँ यसलाई पनि पापको निम्ति बलिदान गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","परमप्रभुले आज्ञा गर्नुभएझैँ तिनले होमबलिलाई अर्पण गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","तिनले अन्‍नबलि अर्पण गरेपछि त्यसबाट एक मुट्ठी लिए अनि त्यही बिहानीको होमबलिसँगै त्यसलाई वेदीमा जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","तिनले त्यो साँढे र मानिसहरूको निम्ति चढाइने मेलबलिको भेडालाई पनि मारे । हारूनका छोराहरूले तिनलाई रगत दिए, र तिनले त्यो वेदीको सबैतिर छर्के । ");
INSERT INTO npiulb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","तर तिनीहरूले त्यस साँढे र भेडाको बोसो, बोसे-पुच्छर, भित्री भागहरूलाई ढाक्‍ने बोसो, मृगौलाहरू, र कलेजोलाई ढाक्‍ने भागलाई काटी निकाले । ");
INSERT INTO npiulb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","आफूले काटेर निकालेका भागलाई लिएर तिनीहरूले छातीमा राखे, अनि हारूनले बोसोलाई वेदीमा जलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","मोशाले आज्ञा गरेझैँ हारूनले छाती र दाहिने फिलालाई परमप्रभुको अगि डोलाइने बलिझैँ डोलाए । ");
INSERT INTO npiulb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","त्यसपछि हारूनले आफ्ना हात मानिसहरूतर्फ उठाएर तिनीहरूलाई आशिष् दिए, अनि पापबलि, होमबलि र मेलबलि अर्पण गर्ने स्थानबाट तिनी तल झरे । ");
INSERT INTO npiulb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","मोशा र हारून भेट हुने पालभित्र पसेर बाहिर आए अनि मानिसहरूलाई आशिष् दिए, अनि परमप्रभुको महिमा सबै मानिसहरूको सामु प्रकट भयो । ");
INSERT INTO npiulb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","परमप्रभुबाट आगो बाहिर निस्‍कियो र वेदीको होमबलि र बोसोलाई भस्‍म पारिदियो । जब सारा मानिसहरूले यो देखे, तिनीहरू उच्‍च सोरमा कराए र आफ्नो शिर निहुराए । ");
INSERT INTO npiulb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","हारूनका छोराहरू नादाब र अबीहू दुवैले हारूनको धुपौरो लिए र त्यसमा आगो र धूप राखे । अनि तिनीहरूले परमप्रभुले आज्ञा नगर्नुभएको आगो उहाँको सामु अर्पण गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","यसैकारण परमप्रभुको सामुबाट आगो निस्‍कियो र तिनीहरूलाई भष्‍म गरिदियो, र तिनीहरू परमप्रभुको सामु मरे । ");
INSERT INTO npiulb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","अनि मोशाले हारूनलाई भने, “परमप्रभुले भन्‍नुभएको कुरा यही हो, ‘मेरो नजिक आउनेहरू सबैलाई म मेरो पवित्रता प्रकट गर्ने छु । म सबै मानिसहरूका सामु महिमित हुने छु ।’” हारूनले केही बोलेनन् । ");
INSERT INTO npiulb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मोशाले हारूनका काका उज्‍जीएलका छोराहरू मीशाएल र एलसाफानलाई बोलाएर भने, “यहाँ आओ र पवित्र वासस्थानबाट आफ्ना भाइहरूलाई निकालेर छाउनीभन्दा बाहिर लैजाओ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","यसैकारण मोशाले आज्ञा गरेझैँ तिनीहरू पुजारीकै दौरा लगाएर नजिक आए र तिनीहरूलाई छाउनीबाट बाहिर लगे । ");
INSERT INTO npiulb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","त्यसपछि मोशाले हारून र तिनका छोराहरू एलाजार र ईतामारलाई यसो भने, “तिमीहरूको शिरको केश नफुकाल, र आफ्ना वस्‍त्रहरू नच्यात, अनि तिमीहरू मर्ने छैनौ, र परमप्रभु सबै समुदायसँग क्रोधित हुनुहुने छैन । तर आफ्ना नातेदारहरू अर्थात् समस्त इस्राएलको घरानालाई परमप्रभुको आगोले भष्‍म गरेकाहरूका निम्ति विलाप गर्न देओ । ");
INSERT INTO npiulb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","तिमीहरूमाथि परमप्रभुका अभिषेकको तेल भएको हुनाले तिमीहरू भेट हुने पालको प्रवेशद्वारभन्दा बाहिर नजानू, नत्रता तिमीहरू मर्ने छौ ।” यसैकारण मोशाले आज्ञा गरेझैँ तिनीहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","परमप्रभु यसो भनेर हारूनसँग बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“तँ र तँसँगै भएका तेरा छोराहरू भेट हुने पालभित्र जाँदा मदिरा वा कुनै कडा मद्य नपिउनू, नत्रता तिमीहरू मर्ने छौ । पवित्र र साधारण, अनि अशुद्ध र शुद्धबिच भेद गराउनको निम्ति, ");
INSERT INTO npiulb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","तिमीहरूका सारा वंशमा यो सदाको निम्ति एउटा विधि होस्, ");
INSERT INTO npiulb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ताकि मोशाद्वारा परमप्रभुले आज्ञा गर्नुभएका सबै विधिविधानहरू तिमीहरूले इस्राएलका मानिसहरूलाई सिकाउन सक ।” ");
INSERT INTO npiulb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मोशाले हारून र तिनका बाँकी छोराहरू एलाजार र ईतामारलाई भने, “परमप्रभुको सामु आगोद्वारा गरिएको बलिदानबाट बाँकी अन्‍नबलि लिएर वेदीको छेउमा खमिर नराखी खाओ, किनभने यो अति पवित्र छ । ");
INSERT INTO npiulb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","तिमीहरूले त्यो पवित्र स्थानमा खाओ, किनभने परमप्रभुलाई आगोद्वारा चढाइएका बलिदानहरूबाट यो तेरो र तेरा छोराहरूको भाग हो, किनकि तिमीहरूलाई यो कुरा बताउन मलाई आज्ञा भएको छ । ");
INSERT INTO npiulb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","डोलाइएको छाती र परमप्रभुलाई अर्पण गरिएको फिला परमप्रभुलाई ग्रहणयोग्‍य हुने शुद्ध ठाउँमा तिमीहरूले खानू । ती भागहरू तँ र तेरा छोराछोरीहरूले खानू, किनकि इस्राएलका मानिसहरूका मेलबलिका भेटीहरूबाट ती तँ र तेरा छोराहरूको भागमा दिइएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","तिमीहरूले अर्पण गरिएको फिला र डोलाइएको छाती, आगोद्वारा चढाइने बोसोको बलिसँगै परमप्रभुको सामु डोलाइनको निम्ति ल्याउनू । परमप्रभुले आज्ञा गर्नुभएझैँ ती सदाको निम्ति तेरो र तेरा छोराहरूको भाग हुने छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","त्यसपछि मोशाले पापबलिको बोकोको बारेमा सोधे, र त्यो जलाइएको रहेछ भनेर उनले थाहा पाए । यसैकारण हारूनका बाँकी रहेका छोराहरू एलाजार र ईतामारसँग उनी रिसाएर यसो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तिमीहरूले त्यो पापबलिलाई पवित्र वासस्थानको क्षेत्रमा किन खाएनौ, किनकि त्यो अति पवित्र हो, र समुदायको पाप हटाउन र उहाँको सामु तिनीहरूका निम्ति प्रायश्‍चित्त गर्नका लागि परमप्रभुले त्यो तिमीहरूलाई दिनुभएको होइन र? ");
INSERT INTO npiulb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","हेर, त्यसको रगत यस पवित्र वासस्थानमा ल्याइएको थिएन, यसैकारण मैले आज्ञा गरेझैँ तिमीहरूले निश्‍चय नै त्यो पवित्र वासस्थानको क्षेत्रमा खानुपर्ने थियो ।” ");
INSERT INTO npiulb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","त्यसपछि हारूनले मोशालाई जवाफ दिए, “हेर्नुहोस्, तिनीहरूले आज परमप्रभुको अगि पापबलि र होमबलि अर्पण गरे, अनि आज मलाई यस्तो हुन आयो । यदि मैले त्यो पापबलि खाएको भए, के त्यो परमप्रभुलाई मनपर्दो हुने थियो?” ");
INSERT INTO npiulb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मोशाले यो सुने, उनी सन्तुष्‍ट भए । ");
INSERT INTO npiulb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","परमप्रभु मोशा र हारूनसँग यसरी बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलका मानिसहरूलाई यसो भन्‍नू, ‘पृथ्‍वीमा भएका सबै पशुहरूमध्ये तिमीहरूले खान मिल्‍ने जीवित प्राणीहरू यी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","चिरिएको खुर भएको र उग्राएर चबाउने सबै पशु तिमीहरूले खान मिल्‍छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","तर, उग्राएर चबाउने वा चिरिएको खुर मात्र भएको पशुचाहिँ तिमीहरूले नखानू, जस्तै ऊँट, किनभने त्यसले उग्राएर चबाउँछ तर त्यसको खुर चिरिएको हुँदैन । यसकारण त्यो तिमीहरूका निम्ति अशुद्ध हो । ");
INSERT INTO npiulb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","अनि शापन किनभने त्यसले उग्राएर चबाउँछ तर त्यसको खुर चिरिएको हुँदैन । त्यो तिमीहरूका निम्ति अशुद्ध हो । ");
INSERT INTO npiulb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","अनि खरायो तिमीहरूका निम्ति अशुद्ध हो किनभने त्यसले उग्राएर चबाउँछ तर त्यसको खुर चिरिएको हुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अनि सुँगुरको खुर चिरिएको भए तापनि त्यसले उग्राएर चबाउँदैन । यसैकारण त्यो तिमीहरूका निम्ति अशुद्ध हो । ");
INSERT INTO npiulb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","तिमीहरूले यी कुनै पशुको मासु नखानू, न त तिनीहरूको सिनु छुनू । यी तिमीहरूका निम्ति अशुद्ध हुन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","पानीमा पाइने प्राणीहरूमा सागर वा नदीहरूमा पाइने पखेटा र कत्‍ला भएका सबै तिमीहरूले खान मिल्‍छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","तर सागर वा नदीहरूका सबै जीवित प्राणीहरू र पानीमा हिँड्ने र पानीमा पाइने सबै जीवित प्राणीहरू जसका पखेटा र कत्‍ला हुँदैनन्, ती तिमीहरूले घृणा गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ती घृणित भएका हुनाले, तिमीहरूले तिनका मासु नखानू, र तिनका सिनुलाई पनि घृणा गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","पानीमा पाइने प्राणी जसका पखेटा र कत्‍ला हुँदैनन्, ती तिमीहरूद्वारा घृणित होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","तिमीहरूले घृणा गर्नुपर्ने र खान नहुने पक्षीहरू यी हुन्ः गरुड, गिद्ध, ");
INSERT INTO npiulb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","चील, सबै प्रकारका बेसारो, ");
INSERT INTO npiulb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","सबै प्रकारका काग, ");
INSERT INTO npiulb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","सुतुरमुर्ग र हुचील, समुद्रीचरो, र सबै प्रकारका बाज । ");
INSERT INTO npiulb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","तिमीहरूले यी पक्षीहरूलाई पनि घृणा गर्नू, सानो र ठुलो लाटोकोसेरो, जलकाग, ");
INSERT INTO npiulb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","राजहंस र धनेस, माछा खाने चील, ");
INSERT INTO npiulb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, सबै प्रकारका बकुल्‍ला, फाप्रेचरो र चमेरो । ");
INSERT INTO npiulb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","चार खुट्‍टाले हिँड्ने पखेटा भएका सबै किराहरू तिमीहरूका निम्ति घृणित हुन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","तर उड्ने किराहरूमा चार खुट्‍टाले हिँड्ने र जमिनमा उफ्रनको निम्ति खुट्‍टामा जोर्नीहरू भएकाहरूचाहिँ तिमीहरूले खान मिल्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","तिमीहरूले कुनै पनि प्रकारका सलह, खुइले-सलह, किथ्रो, वा फटेङ्ग्रो पनि खान मिल्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","तर चार खुट्‍टा भएका सबै उड्ने किराहरूचाहिँ तिमीहरूद्वारा घृणित होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","यदि तिमीहरूले यीमध्ये कुनैको सिनुलाई छोयौ भने तिमीहरू साँझसम्म अशुद्ध हुने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","जसले तीमध्ये कसैको सिनु बोक्‍छ, उसले आफ्ना लुगा धोओस् र साँझसम्मै त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","हरेक पशु जसको खुर पुरै चिरिएको छैन वा जसले उग्राएर चबाउँदैन, त्यो तिमीहरूका निम्ति अशुद्ध हुन्छ । ती छुने सबै अशुद्ध हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","चार खुट्‍टाले हिँड्ने पशुहरूमध्ये आफ्ना पन्‍जाले हिँड्नेचाहिँ तिमीहरूका निम्ति अशुद्ध हुन्छन् । त्यस्तो सिनु छुने जो कोही साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","त्यस्तो सिनु बोक्‍ने जो कोहीले आफ्ना लुगाहरू धोओस् र साँझसम्म त्यो अशुद्ध रहोस् । यी पशुहरू तिमीहरूका निम्ति अशुद्ध हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","जमिनमा घस्रने पशुहरूमा यी प्राणीहरू तिमीहरूका निम्ति अशुद्ध हुने छन्ः न्याउरीमूसो, मूसो, सबै थरीका ठुलो छेपारो, ");
INSERT INTO npiulb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","गोहोरो, सालक, भालेमुङ्‍रो, बालुवाको छेपारो, र रङ्ग बदल्‍ने छेपारो । ");
INSERT INTO npiulb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","घस्रने पशुहरूमा यी सबै तिमीहरूका निम्ति अशुद्ध हुने छन् । ती मरेपछि ती छुने सबै साँझसम्म अशुद्ध हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","तिनीहरूमध्ये कोही मरेर केही कुरामाथि पर्‍यो भने, त्यो वस्तु काठ, कपडा, छाला, वा भाङ्‍रो, जे सुकैबाट बनेको भए तापनि त्यो अशुद्ध हुने छ । त्यो जे भए तापनि र त्यो जे सुकैको निम्ति प्रयोग हुने भए तापनि, त्यो पानीमा डुबाइनुपर्छ, र त्यो साँझसम्म अशुद्ध रहने छ । त्यसपछि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","यदि कुनै माटोको भाँडोमा कुनै अशुद्ध प्राणी पर्‍यो भने, त्यस भाँडोमा भएको जेसुकै अशुद्ध हुने छ, र तिमीहरूले त्यो भाँडोलाई नष्‍ट गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","कुनै खान मिल्‍ने कुरामा त्यस्तो भाँडोको पानी पर्‍यो भने त्यो अशुद्ध हुन्छ । त्यस भाँडोको कुनै पनि पिउने तरल पदार्थ अशुद्ध हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","जुन कुरामाथि तिनीहरूको सिनु खस्‍छ, त्यो वस्तु भट्‍टी वा सानो चुलो जे भए तापनि त्यसलाई टुक्रा-टुक्रा गरिनुपर्छ । ती अशुद्ध हुन् र तिमीहरूका निम्ति ती अशुद्ध रहून् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","जरुवा वा दहको पानी शुद्ध रहने छ; तर तिनीहरूको सिनु छुने सबै अशुद्ध हुन्छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","यदि तिनीहरूको सिनुको कुनै भाग छरिने बिउमा पर्‍यो भने, ती बिउहरू भने शुद्ध नै रहन्छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","तर यदि बिउमा पानी राखिएको भए, र तिनीहरूको सिनुको कुनै भाग तीमाथि पर्‍यो भने, ती तिमीहरूका निम्ति अशुद्ध हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","तिमीहरूले खाने गरेका कुनै पशु मर्‍यो भने, त्यसको सिनु छुने कोही पनि साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","त्यस्तो सिनु खाने जो कोहीले आफ्ना लुगाहरू धुनुपर्छ र त्यो साँझसम्म अशुद्ध रहने छ । त्यस्तो सिनुबाट केही लिने जो कोहीले आफ्ना लुगाहरू धोओस् र त्यो साँझसम्म अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","जमिनमा घस्रने सबै प्राणी घृणित हुनुपर्छ । ती नखानू । ");
INSERT INTO npiulb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","आफ्नो पेटले हिँड्ने, वा सबै चार खुट्‍टा प्रयोग गरी हिँड्ने, वा धेरै खुट्‍टा भएका जुनसुकै जमिनमा घस्रेर हिँड्ने प्राणी तिमीहरूले नखानू, किनकि ती घृणित हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","कुनै पनि घस्रने प्राणीबाट तिमीहरू अशुद्ध नहुनू; आफूलाई अपवित्र बनाउने गरी तीबाट तिमीहरू अशुद्ध नहुनू । ");
INSERT INTO npiulb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","किनभने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । म पवित्र भएको कारण तिमीहरूले आफैलाई पवित्र राख्‍नुपर्छ, र यसैकारण तिमीहरू पवित्र होओ । जमिनमा घस्रने कुनै पनि प्राणीबाट तिमीहरूले आफैलाई अपवित्र नबनाओ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","किनभने तिमीहरूका परमेश्‍वर हुनलाई तिमीहरूलाई मिश्र देशबाट बाहिर ल्याउने परमप्रभु म नै हुँ । यसैकारण म पवित्र भएको हुनाले तिमीहरू पवित्र होओ । ");
INSERT INTO npiulb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","सबै पशु, पक्षी, पानीमा चलहल गर्ने सबै जीवित प्राणी, र जमिनमा घस्रने सबै प्राणीसम्बन्धी विधि यी नै हुन्, ");
INSERT INTO npiulb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","जसका बिचमा अशुद्ध र शुद्ध, र खान मिल्‍ने र नमिल्‍ने प्राणीहरू भनेर छुट्ट्‍याउन जरुरी छ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलका मानिसहरूलाई यसो भन्‍नू, ‘यदि कुनै स्‍त्री गर्भवती भएर त्यसले छोरो जन्माई भने, त्यसको रजस्‍वलाका दिनहरूझैँ त्यो सात दिनसम्म अशुद्ध रहने छे । ");
INSERT INTO npiulb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठौँ दिनमा चाहिँ त्यस बालकको खलडीको खतना गरिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","त्यसपछि त्यस स्‍त्रीको रक्‍तस्रावको शुद्धिकरण तेत्तिस दिनसम्म जारी रहने छ । त्यसको शुद्धिकरणको समय पुरा नभएसम्म त्यसले कुनै पवित्र कुरा छुनुहुँदैन वा पवित्र स्थानमा आउनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","तर यदि त्यसले छोरी जन्माई भने, त्यसको रजस्‍वलाको समयमा झैँ त्यो दुई हप्‍तासम्म अशुद्ध रहने छे । त्यसपछि त्यसको शुद्धिकरण छैसट्ठी दिनसम्मै जारी रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","त्यसको शुद्धिकरणको समय पुरा भएपछि छोराको निम्ति होस् वा छोरीको निम्ति होस्, त्यसले पुजारीकहाँ भेट हुने पालको प्रवेशद्वारमा होमबलिको निम्ति एउटा एक वर्षे भेडाको बच्‍चा, र पाप बलिको निम्ति एउटा परेवाको बचेरो वा ढुकुर ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","त्यसपछि पुजारीले त्यो परमप्रभुको अगि चढाएर त्यस स्‍त्रीको निम्ति प्रायश्‍चित्त गर्ने छ, र त्यो आफ्नो रक्‍तस्रावबाट शुद्ध हुने छे । छोरा वा छोरी जन्माउने स्‍त्रीको निम्ति विधि यही नै हो । ");
INSERT INTO npiulb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","यदि त्यस स्‍त्रीको भेडाको बच्‍चा ल्याउने क्षमता छैन भने, त्यसले होमबलिको निम्ति एउटा र पापबलिको निम्ति एउटा गरेर दुईवटा ढुकुर वा परेवाका दुईवटा वचेरा ल्याओस्, र पुजारीले त्यसको निम्ति प्रायश्‍चित्त गर्ने छ अनि त्यो शुद्ध हुने छे’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","परमप्रभुले मोशा र हारूनलाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“यदि कसैको शरीरको छाला सुनिएर फुल्‍यो वा त्यसमा खटिरा वा उज्‍ज्‍वल दाग आयो, र त्यो सङ्क्रमित भएर त्यसको शरीरमा छालाको रोग आयो भने, त्यसलाई प्रधान पुजारी अर्थात् हारून वा त्यसका पुजारी छोराहरूकहाँ ल्याइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","त्यसपछि पुजारीले त्यसको शरीरमा आएको छालाको रोगको जाँच गर्ने छ । यदि रोग लागेको ठाउँको रौँ सेतो भएको छ, र त्यो रोग छालामा गहिरो भएको छ भने, त्यो सरुवा रोग हो । पुजारीले त्यसलाई हेरेपछि उसले त्यसलाई अशुद्ध भनेर घोषणा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","यदि त्यसको छालामा भएको उज्‍ज्‍वल दाग सेतो छ, र त्यो छालामा गहिरो देखिँदैन, र त्यो रोग लागेको ठाउँको रौँ सेतो भएको छैन भने, रोग लागेको मानिसलाई पुजारीले सात दिनसम्‍म अलग्‍गै राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातौँ दिनमा पुजारीले त्यो रोग खराब भएको छ वा छैन र छालामा फैलिएको छ वा छैन भनेर जाँच्‍ने छ । यदि फैलिएको छैन भने पुजारीले त्यसलाई अझै सात दिनसम्‍म अलग्‍गै राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","पुजारीले फेरि सातौँ दिनमा त्यो रोगमा केही सुधार भएको छ वा छैन र छालामा पर-परसम्‍म फैलिएको छ वा छैन भनेर त्यसको जाँच गर्ने छ । यदि फैलिएको छैन भने पुजारीले त्यसलाई शुद्ध घोषणा गर्ने छ । त्यो एउटा डाबर मात्र हो । त्यसले आफ्ना लुगाहरू धोओस्, अनि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","तर त्यसले आफैलाई पुजारीकहाँ देखाइसकेपछि यदि त्यो डाबर छालामा फैलियो भने, त्यसले फेरि आफूलाई पुजारीकहाँ देखाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","त्यो डाबर छालामा अझै परसम्‍म फैलिएको छ वा छैन भनेर पुजारीले जाँच गर्ने छ । यदि त्यो फैलिएको छ भने, पुजारीले त्यसलाई अशुद्ध घोषणा गर्ने छ । त्यो सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","यदि कसैलाई सरुवा रोग लागेको छ भने, त्यसलाई पुजारीकहाँ लगिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","पुजारीले छालामा कुनै भाग सेतो भएर फुलेको छ वा छैन, रौँ सेतो भएको छ वा छैन, वा फुलेको ठाउँमा कुनै आलो मासु पलाएको छ वा छैन भनेर त्यसको जाँच गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","यदि छ भने, त्यो धेरै पुरानो छालाको रोग हो, र पुजारीले त्यसलाई अशुद्ध घोषणा गरोस् । त्यो पहिले नै अशुद्ध भएको कारणले पुजारीले त्यसलाई अलग्‍गै राख्‍ने छैन । ");
INSERT INTO npiulb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","यदि पुजारीले हेर्दा त्यसको रोग छालाभरि फैलिएर त्यसको शिरदेखि पाउसम्‍मै पुगेको रहेछ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","त्यो रोगले त्यसका सबै शरीर ढाकेको छ वा छैन भनेर उसले त्यसलाई जाँचोस् । यदि छ भने, त्यो रोग भएको मानिसलाई पुजारीले शुद्ध घोषणा गरोस् । यदि त्यो पुरै सेतो भएको छ भने, त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","तर यदि त्यसमा आलो मासु देखा पर्‍यो भने, त्यो अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","पुजारीले त्यो आलो मासुलाई हेरेर त्यस मानिसलाई अशुद्ध घोषणा गरोस् किनभने आलो मासु अशुद्ध हो । त्यो एउटा सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","तर आलो मासु फेरि सेतो भयो भने, त्यो मानिस पुजारीकहाँ जाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","छाला सेतो भएको छ वा छैन भनेर पुजारीले त्यसको जाँच गर्ने छ । यदि छ भने पुजारीले त्यस मानिसलाई शुद्ध भनी घोषणा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","यदि कसैको छालामा कुनै फोका आयो र त्यो निको भयो, ");
INSERT INTO npiulb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","र त्यस फोकाको ठाउँमा सुनिएर त्यो सेतो भयो वा त्यहाँ रातो-सेतो उज्‍ज्‍वल दाग आयो भने, त्यो पुजारीलाई देखाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","त्यो छालामा गहिरो छ वा छैन र त्यसको रौँ सेतो भएको छ वा छैन भनेर पुजारीले त्यसको जाँच गर्ने छ । यदि त्यस्तो भएको छ भने पुजारीले त्यस मानिसलाई अशुद्ध घोषणा गरोस् । फोका भएको ठाउँमा नै त्यो आएको हो भने त्यो एउटा सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","तर पुजारीले जाँच गर्दा त्यसमा कुनै सेतो रौँ छैन भने, र त्यो छालामा गहिरो छैन तर बिलाउँदै गएको छ भने, पुजारीले त्यस मानिसलाई सात दिनसम्‍म अलग्‍गै राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","यदि त्यो छालामा पर-पर फैलियो भने, पुजारीले त्यसलाई अशुद्ध घोषणा गरोस् । त्यो एउटा सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","तर यदि त्यो सेतो दाग आफ्‍नै ठाउँमा रह्‍यो र त्यो फैलिएन भने, त्यो त्यस फोकाको दाग मात्र हो, र पुजारीले त्यस मानिसलाई शुद्ध घोषणा गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","यदि छालामा पोलेर घाउ भयो र त्यसको आलो मासुमा रातो-सेतो वा सेतो दाग भयो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","पुजारीले त्यस दागमा पलाएको रौँ सेतो भएको छ वा छैन, र त्यो छालामा गहिरो भएको छ वा छैन भनेर जाँच गर्ने छ । यदि त्यो पोलेको घाउ फुटेको छ भने, पुजारीले त्यसलाई अशुद्ध घोषणा गरोस् । त्यो एउटा सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","तर पुजारीले त्यो जाँच गर्दा त्यस दाग भएको ठाउँमा कुनै सेतो रौँ नभएको, र त्यो छालामा नफैलिएको तर बिलाउँदै गएको पायो भने, पुजारीले त्यसलाई सात दिनसम्‍म अलग्‍गै राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातौँ दिनमा पुजारीले त्यसको जाँच गरोस् । यदि त्यो छालामा पर-परसम्‍म फैलिएको छ भने पुजारीले त्यसलाई अशुद्ध घोषणा गरोस् । त्यो एउटा सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","तर यदि त्यो दाग आफ्‍नै ठाउँमा रह्‍यो र छालामा त्यो फैलिएको छैन र बिलाउँदै गएको छ भने, त्यो पोलेको घाउ फुलेको मात्र हो, र पुजारीले त्यसलाई शुद्ध घोषणा गरोस्, किनभने त्यो पोलेको घाउको दाग मात्र हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","यदि कुनै पुरुष वा स्‍त्रीको टाउको वा चिउँडोमा सरुवा रोग लागेको छ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","पुजारीले त्यो रोग छालामा गहिरो भएको छ वा छैन, र त्यसमा कुनै पहेँलो, मसिनो रौँ छ वा छैन भनेर त्यस रोगको जाँच गर्ने छ । यदि त्यहाँ छ भने, पुजारीले त्यसलाई अशुद्ध घोषणा गरोस् । त्यो टाउको वा चिउँडोको चिलाउने सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","पुजारीले त्यो चिलाउने रोगको जाँच गर्दा त्यो छालामा गहिरो नभएको, र त्यसमा कालो रौँ नपलाएको देख्‍यो भने, पुजारीले त्यो चिलाउने रोग लागेको मानिसलाई सात दिनसम्‍म अलग्‍गै राख्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातौँ दिनमा पुजारीले त्यो रोग फैलिएको छ वा छैन भनेर जाँच गर्ने छ । यदि त्यहाँ पहेँलो रौँ छैन, र त्यो रोग छालाभन्‍दा गहिरो छैन भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","त्यो रोग लागेको ठाउँलाई छोडेर त्यसको रौँ खौरियोस्, र त्यो चिलाउने रोग लागेको मानिसलाई पुजारीले अर्को सात दिनसम्‍म अलग्‍गै राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातौँ दिनमा पुजारीले त्यो रोग छालामा फैलिन रोकिएको छ वा छैन भनेर जाँच गर्ने छ । यदि त्यो छालाभन्दा गहिरो भएको छैन भने पुजारीले त्यसलाई शुद्ध घोषणा गरोस् । त्यो मानिसले आफ्ना लुगाहरू धुने छ, अनि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","तर पुजारीले त्यसलाई शुद्ध घोषणा गरिसकेपछि त्यो चिलाउने रोग छालामा पर-परसम्‍म फैलियो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","पुजारीले फेरि त्यसको जाँच गर्नुपर्छ । यदि त्यो रोग छालामा फैलिएको छ भने, पुजारीले पहेँलो रौँ छ वा छैन भनेर हेर्नुपर्दैन । त्यो मानिस अशुद्ध हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","तर यदि त्यो चिलाउने रोग फैलिन रोकिएको र त्यस ठाउँमा कालो रौँ पलाएको पुजारीले देख्‍यो भने, त्यो रोग निको भएको हो । त्यो मानिस शुद्ध हुन्छ, र पुजारीले त्यसलाई शुद्ध घोषणा गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","यदि कुनै पुरुष वा स्‍त्रीको शरीरमा सेता दागहरू छन् भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","पुजारीले ती दागहरू फिक्‍का सेता छन् वा छैनन् भनेर त्यस मानिसको जाँच गरोस्, जुन छालामा निस्‍केका डाबर मात्र हुन् । त्यो मानिस शुद्ध छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","यदि कुनै मानिसको केश झरेको छ, र त्यो तालु खुइले भएको छ भने पनि त्यो शुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","यदि त्यसको शिरको अगिल्‍लो भागको केश झरेको छ, र यदि त्यसको निधार खुइलेको छ भने, त्यो शुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","तर यदि त्यसको खुइलेको शिर वा निधारमा रातो-सेतो खटिरा आएको छ भने, त्यो फुटेर निस्‍केको सरुवा रोग हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","त्यसपछि पुजारीले त्यस मानिसको खुइलेको शिर वा निधारको सुनिएर फुलेको ठाउँलाई छालाको सरुवा रोगझैँ छ कि छैन भनेर जाँच गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","यदि त्यो त्यस्तै छ भने, त्यसलाई सरुवा रोग लागेको छ, र त्यो अशुद्ध हुने छ । त्यसको शिरमा रोग भएको कारण पुजारीले त्यसलाई अशुद्ध घोषणा गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","सरुवा रोग लागेको मानिसले झुत्रो लुगा लगाओस्, त्यसले आफ्ना कपाल खुला छोडोस्, र आफ्नो अनुहारलाई नाकसम्‍म ढाकेर त्यसले सोर निकालेर ‘अशुद्ध, अशुद्ध’ भनोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","त्यसमा त्यो सरुवा रोग भइन्जेलसम्‍म त्यो अशुद्ध रहने छ । फैलिन सक्‍ने रोगद्वारा त्यो अशुद्ध भएको कारण, त्यो एक्‍लै बस्‍नुपर्छ । त्यो छाउनीभन्दा बाहिर बस्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","यदि कुनै लुगामा ढुसी परेको छ भने, चाहे त्यो ऊनी होस् वा सुती, ");
INSERT INTO npiulb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","वा बुनिएको वा ऊनी वा सुती, वा छाला र छालाबाट बनेको कुनै कुराद्वारा बुनिएको होस्, ");
INSERT INTO npiulb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","यदि त्यो लुगा, छाला, बुनिएको वा सिलाइएको वस्‍तु, छालाद्वारा बनेको कुनै वस्‍तुमा हरियो वा रातो दाग छ भने त्यो फैलिने ढुसी हो, र त्यो पुजारीलाई देखाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","पुजारीले त्यो ढुसी भएको वस्‍तुलाई जाँचोस्, र ढुसी भएको जुनसुकै वस्‍तुलाई सात दिनसम्‍म अलग्‍गै राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","पुजारीले सातौँ दिनमा त्यो ढुसीलाई फेरि जाँचोस् । यदि त्यो त्यस लुगामा, वा ऊनी वा सुतीबाट बुनिएको वा सिलाइएको कुनै वस्‍तुमा, वा छाला वा छाला प्रयोग गरिएको कुनै वस्तुमा फैलिएको छ भने, त्यो हानि गर्ने ढुसी हो, र त्यो वस्तु अशुद्ध हो । ");
INSERT INTO npiulb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","त्यसले त्यो लुगा, ऊनी वा सुतीबाट बुनिएको वा सिलाइएको, वा छाला वा छालाबाट बनाइएको कुनै वस्तु, वा हानि गर्ने ढुसी भेटिएको जुनसुकै वस्‍तुलाई जलाओस्, किनभने त्यसले रोग लाग्‍न सक्छ । त्यो वस्‍तु पूर्ण रूपमा जलाइनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","पुजारीले त्यो वस्‍तुलाई जाँच्‍दा त्यो लुगा वा ऊनी वा सुतीबाट बुनिएको वा सिलाइएको वस्‍तु, वा छालाका वस्‍तुहरूमा ढुसी फैलिएको छैन भने, ");
INSERT INTO npiulb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","त्यो ढुसी फेला परेको वस्‍तुलाई पुजारीले धुनू भनी आज्ञा गर्ने छ, र उसले त्यो अझै सात दिनसम्‍म अलग्‍गै राख्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ढुसी लागेको वस्‍तुलाई धोइसकेपछि पुजारीले त्यसको जाँच गर्ने छ । त्यो ढुसी नफैलिएको भए तापनि त्यसले आफ्‍नो रङ्ग परिवर्तन गरेन भने, त्यो अशुद्ध हुने छ । ढुसी वस्‍तुको जुन ठाउँमा लागेको भए तापनि तैँले त्यसलाई जलाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","पुजारीले त्यो वस्‍तुको जाँच गर्दा त्यसलाई धोइएपछि यदि ढुसी फिका भयो भने, तैँले ढुसी लागेको भागलाई लुगा वा छाला, वा बुनिएको वा सिलाइएको वस्‍तुबाट च्‍यात्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","यदि त्यो लुगामा, चाहे त्यो बुनिएको वा सिलाइएको वा छालाबाट बनेको वस्‍तु होस्, अझै पनि ढुसी देखियो र त्यो फैलिँदै छ भने, ढुसी भएको जुनसुकै वस्‍तुलाई तैँले जलाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","त्यो लुगा वा ऊनी वा सुतीबाट बुनिएको वा सिलाइएको जुनसुकै वस्‍तु, वा छाला वा छालाबाट बनेको कुनै वस्‍तुलाई धोएपछि यदि ढुसी हरायो भने, त्यो वस्‍तुलाई अर्को एक पटक धुनू, र त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","कुनै ऊनी वा सुतीको लुगा, ऊनी वा सुतीबाट बुनिएको कुनै वस्‍तु, वा छाला वा छालाबाट बनेको कुनै वस्‍तुको ढुसीसम्बन्धी विधि यी नै हुन्, जसअनुसार तिमीहरूले त्यसलाई शुद्ध वा अशुद्ध भनी घोषणा गर्न सक्छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","परमप्रभु मोशासँग यसरी बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“रोग लागेको मानिसको शुद्धिकरणको दिनको निम्ति विधि यी नै हुन् । त्यसलाई पुजारीकहाँ लगिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","छालाको सरुवा रोग निको भएको छ वा छैन भनेर हेरेर त्यस मानिसलाई जाँच्‍नको निम्ति पुजारी छाउनीभन्दा बाहिर जाने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","त्यसपछि कोही शुद्ध हुनको निम्ति दुई जीवित, शुद्ध चराहरू, देवदारुको काठ, सिन्दुरे रङ्गको धागो, र हिसप ल्याउनू भनी पुजारीले आज्ञा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","पुजारीले माटोको भाँडामा भएको ताजा पानीमाथि दुई चराहरूमध्ये एउटालाई मार्नू भनी आज्ञा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","पुजारीले त्यसपछि जीवित चरा र देवदारुको काठ, र सिन्दुरे रङ्गको धागो र हिसप लिने छ, र यी सबैलाई ताजा पानीमाथि मारिएको चराको रगतमा चोप्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","त्यसपछि पुजारीले यस पानीलाई रोगबाट शुद्धिकरण गरिनुपर्ने मानिसमाथि सात पटक छर्कने छ, र त्यसलाई शुद्ध घोषणा गर्ने छ । त्यसपछि पुजारीले जीवित चरालाई भने खुला ठाउँमा छोडिदिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","शुद्धिकरण भइरहेको मानिसले आफ्‍ना लुगाहरू धुने छ, आफ्‍नो सबै कपाल खौरने छ, र पानीले नुहाउने छ, र त्यो शुद्ध हुने छ । त्यसपछि त्यो छाउनीभित्र आओस्, तर त्यो सात दिनसम्‍म आफ्नो पालभन्दा बाहिरै बसोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातौँ दिनमा त्यसले आफ्नो शिरको कपाल, र आफ्‍नो दाह्री र आँखीभुइँ खौरोस् । त्यसले आफ्‍नो सबै कपाल खौरोस्, र आफ्‍ना लुगाहरू धोओस् र पानीले नुहाओस्, अनि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","आठौँ दिनमा त्यसले दुईवटा निष्‍खोट भेडाका पाठा, एउटा निष्‍खोट एक वर्षे भेडाको पाठी, र अन्‍नबलिको निम्ति तेलसँग मुछिएको डेढ पाथी मसिनो पिठो, र आधा माना तेल ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","शुद्ध गर्ने पुजारीले शुद्ध गरिनुपर्ने मानिसलाई ती सर-सामानहरूसँगै परमप्रभुको अगि भेट हुने पालको प्रवेशद्वारमा खडा गराओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","पुजारीले दुईवटा भेडाका पाठामध्ये एउटा लिने छ र आधा माना तेलसँगै दोषबलि अर्पण गर्ने छ, र परमप्रभुको अगि डोलाइने बलिको रूपमा उसले त्यो डोलाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","उसले त्यो भेडाको पाठोलाई पवित्रस्थानमा पापबलिहरू र होमबलिहरू मारिने ठाउँमा मारोस्, किनभने पापबलि र दोषबलि पुजारीको भागको हो, कारण त्यो अति पवित्र हो । ");
INSERT INTO npiulb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","पुजारीले दोषबलिको केही रगत लिने छ र शुद्ध गरिनुपर्ने मानिसको दाहिने कानको टुप्‍पोमा, दाहिने हातको बुढी औँलामा, र दाहिने खुट्‍टाको बुढी औँलामा लगाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","पुजारीले मानाबाट तेल लिएर आफ्नै देब्रे हातको हत्‍केलामा खन्‍याउने छ र ");
INSERT INTO npiulb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","र आफ्नो देब्रे हातमा भएको तेलमा आफ्नो दाहिने औँला चोपेर परमप्रभुको अगि केही तेल सात पल्‍ट छर्कने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","पुजारीले आफ्नो हातमा बाँकी रहेको तेललाई शुद्ध गरिनुपर्ने मानिसको दाहिने कानको टुप्‍पो, दाहिने हातको बुढी औँला, र दाहिने खुट्‍टाको बुढी औँलामा लगाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","अनि पुजारीले आफ्नो हातमा बाँकी रहेको तेलचाहिँ शुद्ध गरिनुपर्ने मानिसको शिरमा खन्याउने छ, र पुजारीले परमप्रभुको अगि त्यो मानिसको निम्ति प्रायश्‍चित्त गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","अनि पुजारीले पापबलिलाई अर्पण गर्ने छ र आफ्नो अशुद्धताको कारण शुद्ध गरिनुपर्ने मानिसको निम्ति प्रायश्‍चित्त गर्ने छ, र पछि उसले होमबलिलाई मार्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","त्यसपछि पुजारीले होमबलि र अन्‍नबलिलाई वेदीमा अर्पण गर्ने छ । पुजारीले त्यस मानिसको निम्ति प्रायश्‍चित्त गर्ने छ, अनि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","तर यदि त्यो मानिस गरिब छ, र यी बलिदानहरू ल्याउने त्यसको औकात छैन भने, त्यसले एउटा भेडाको पाठोलाई डोलाइनको निम्ति दोषबलिको रूपमा आफ्नै निम्ति प्रायश्‍चित्त गर्नलाई ल्याओस्, र अन्‍नबलिको निम्ति तेलमा मुछिएको आधा पाथी मसिनो पिठो, र आधा माना तेल, ");
INSERT INTO npiulb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","र आफूले ल्याउन सक्‍ने जति दुईवटा ढुकुर वा परेवाका दुई बचेरा ल्याओस् । एउटा चराचाहिँ पापबलि हुने छ र अर्कोचाहिँ होमबलि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","आठौँ दिनमा त्यसले यी सबै आफ्नो शुद्धिकरणको निम्ति पुजारीकहाँ परमप्रभुको अगि भेट हुने पालको प्रवेशद्वारमा ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","पुजारीले बलिदानको निम्ति भेडाको बच्‍चा लिने छ, र त्यससँगै उसले आधा माना जैतूनको तेल लिने छ, र उसले ती माथि उठाएर परमप्रभुको अगि अर्पण गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","उसले दोषबलिको निम्ति भेडाको बच्‍चालाई मार्ने छ, र दोषबलिको केही रगत लिएर शुद्ध गरिनुपर्ने मानिसको दाहिने कानको टुप्‍पो, दाहिने हातको बुढी औँला, र दाहिने खुट्‍टाको बुढी औँलामा लगाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","त्यसपछि पुजारीले केही तेल आफ्नो देब्रे हातको हत्‍केलामा खन्‍याउने छ, ");
INSERT INTO npiulb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","र उसले आफ्नो दाहिने हातको औँलाले आफ्नो देब्रे हातमा भएको तेलबाट केही परमप्रभुको अगि सात पटकसम्‍म छर्कने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","त्यसपछि पुजारीले आफ्नो हातमा भएको तेलबाट केही लिएर दोषबलिको रगत जहाँ-जहाँ लगाएको थियो अर्थात् शुद्ध गरिनुपर्ने मानिसको दाहिने कानको टुप्‍पो, दाहिने हातको बुढी औँला, र दाहिने खुट्‍टाको बुढी औँलामा लगाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","परमप्रभुको अगि शुद्ध गरिनुपर्ने मानिसको निम्ति प्रायश्‍चित्त गर्नलाई उसले आफ्नो हातमा भएको बाँकी तेल त्यस मानिसको शिरमा लगाइदिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","उसले ढुकुरहरूमध्ये वा परेवाका बचेराहरूमध्ये एउटालाई आफ्नो क्षमताअनुसार अर्पण गरोस्- ");
INSERT INTO npiulb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","अन्‍नबलिसँगै उसले एउटाचाहिँ पापबलि र अर्को होमबलिको निम्ति अर्पण गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","छालामा सरुवा रोग भएको मानिस जसले आफ्नो शुद्धिकरणको निम्ति आवश्‍यक बलि ल्याउन सक्‍दैन, त्यसको निम्ति विधि यी नै हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","परमप्रभुले मोशा र हारूनलाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“मैले तिमीहरूलाई अधिकार गर्न दिएको कनान देशमा पुगेपछि तिमीहरूको अधिकार हुने त्यस देशमा यदि मैले तिमीहरूका घरमा फैलिने ढुसी पठाएँ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","घरको मालिकले आएर पुजारीलाई त्यसबारे बताओस् । त्यसले भनोस् ‘मैले मेरो घरमा ढुसीजस्तै केही देखेको छु ।’ ");
INSERT INTO npiulb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","त्यसपछि पुजारीले त्यहाँ गएर ढुसी छ वा छैन भनेर हेर्नुभन्दा अगि तिनीहरूले त्यो घर खाली गर्नू भनेर उसले आज्ञा गर्ने छ, ता कि घरमा भएको कुनै पनि कुरा अशुद्ध नहोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","घरका पर्खालहरूमा ढुसी आएको छ वा छैन र त्यसले पर्खालका सतहहरूमा हरियो वा रातो रेखाहरू बनाएको छ वा छैन भनेर उसले जाँच गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","यदि घरमा ढुसी आएको छ भने, पुजारी घरबाट बाहिर जाने छ र घरको ढोका सात दिनसम्‍म बन्‍द गरिदिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","सातौँ दिनमा पुजारी फर्कने छ र घरका पर्खालहरूमा ढुसी फैलिएको छ वा छैन भनेर जाँच गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","यदि फैलिएको छ भने, पुजारीले ढुसी देखा परेका ढुङ्गाहरूलाई झिकेर सहरभन्दा बाहिर कुनै एउटा अशुद्ध स्थानमा फ्याँक्‍न आज्ञा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","घरका सबै भित्री पर्खालहरू खुर्कनुपर्ने छ, र खुर्किएर निकालिएको फोहोर वस्‍तुलाई सहरबाट बाहिर लगेर कुनै अशुद्ध स्थानमा फ्याँक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","तिनीहरूले अरू ढुङ्गाहरू लिएर ती झिकिएका ढुङ्गाहरूका स्थानमा राखून् र घरका पर्खालहरू पोत्‍नको निम्ति नयाँ माटो प्रयोग गरून् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ढुङ्गाहरू निकालिएको र पर्खाल खुर्किएर पोतिएको घरमा फेरि ढुसी देखा पर्‍यो र त्यो फैलियो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","पुजारी आएर घरमा ढुसी फैलिएको छ वा छैन भनेर जाँच गर्ने छ । यदि त्यो फैलिएको छ भने, त्यो हानि गर्ने ढुसी हो र त्यो घर अशुद्ध हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","त्यो घर भत्‍काइयोस् । त्यस घरका ढुङ्गाहरू, काठहरू र पोतिएको माटो सबै सहरभन्दा बाहिर कुनै अशुद्ध स्थानमा लगियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","साथै, त्यो घर बन्‍द गरिएको बेला त्यहाँ प्रवेश गर्ने मानिस साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","त्यस घरमा सुतेका वा खाएका जोसुकैले आफ्ना लुगाहरू धोऊन् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","घरलाई पोतिसकेपछि त्यहाँ ढुसी फैलिएको छ वा छैन भनेर पुजारी त्यस घरभित्र जाँच्‍नको निम्ति जाँदा यदि ढुसी बिलाइसकेको रहेछ भने, उसले त्यो घरलाई शुद्ध घोषणा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","त्यसपछि पुजारीले घरलाई शुद्ध गर्नको निम्ति दुईवटा चरा, देवदारुको काठ, सिन्दुरे रङ्गको धागो र हिसप लिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","उसले माटोको भाँडाको ताजा पानीमाथि एउटा चरालाई मार्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","उसले देवदारुको काठ, हिसप, सिन्दुरे रङ्गको धागो, र जीवित चरा लिएर ती सबैलाई मारिएको चराको रगत र ताजा पानीमा चोप्‍ने छ र घरमा सात पटक छर्कने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","उसले त्यो घरलाई चराको रगत र ताजा पनि, जीवित चरा, देवदारुको काठ, हिसप र सिन्दुरे रङ्गको धागोले शुद्ध गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","तर उसले जीवित चरालाई भने सहरबाट बाहिर खुला मैदानहरूमा जान दिने छ । यसरी उसले त्यो घरको निम्ति प्रायश्‍चित्त गरोस्, र त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","सबै प्रकारका सरुवा रोगहरू र त्यस्ता रोग ल्याउने वस्‍तुहरू र चिलाउने रोग, ");
INSERT INTO npiulb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","लुगा र घरभित्रको ढुसी, ");
INSERT INTO npiulb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","सुनिएर फुलेको ठाउँ, डाबर, र उज्‍ज्‍वल दागलाई, ");
INSERT INTO npiulb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ती कुन बेला अशुद्ध छन् र कुन बेला शुद्ध छन् भनेर निर्धारण गर्नका निम्ति विधि यी नै हुन् । छालाका सरुवा रोगहरू र ढुसीको निम्ति विधि यी नै हुन् ।” ");
INSERT INTO npiulb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","परमप्रभुले मोशा र हारूनलाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलका मानिसहरूलाई यस्तो भन्‍नू, ‘कुनै मानिसको शरीरबाट सङ्क्रमित तरल पदार्थ बग्‍दछ भने, त्यो अशुद्ध हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","त्यसको अशुद्धता त्यो सङ्क्रमित तरलको कारणले हो । त्यसको शरीरबाट तरल बग्‍ने भए तापनि वा त्यो बग्‍न बन्द भए तापनि, त्यो अशुद्ध हो । ");
INSERT INTO npiulb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","त्यो पल्‍टिने सबै ओछ्‍यान अशुद्ध हुने छ, र त्यो बस्‍ने हरेक कुरा अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","त्यसको ओछ्‍यानलाई छुने जो कोहीले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, र साँझसम्‍म त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","सङ्क्रमित तरल बग्‍ने रोग लागेको मानिस बसेको कुनै कुरामा कोही बस्‍दछ भने, त्यो मानिसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, र साँझसम्‍म त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","सङ्क्रमित तरल बग्‍ने रोग लागेको मानिसको शरीर छुने मानिसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, र साँझसम्‍म त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","यस्तो सङ्क्रमित तरल बग्‍ने रोग लागेको मानिसले कुनै शुद्ध मानिसलाई थुक्‍यो भने, त्यो मानिसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, र साँझसम्‍म त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","त्यस्तो रोग लागेको मानिस बस्‍ने काठी अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","त्यस मानिसको मुनि भएको कुनै कुरा छुने जो कोही साँझसम्‍म अशुद्ध हुने छ, र ती कुराहरू बोक्‍ने जो कोहीले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, र साँझसम्‍म त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","त्यस्तो रोग लागेको मानिसले आफ्ना हात पानीले नपखालिकन कसैलाई छुन्‍छ भने, त्यसरी छोइएको मानिसले आफ्ना लुगाहरू धोओस्, र पानीले नुहाओस्, र साँझसम्‍म त्यो अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","त्यो रोग लागेको मानिसले छोएका सबै माटाका भाँडा फुटाइयोस्, र काठका भाँडा पानीले पखालियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","त्यस्तो रोग लागेको मानिस रोगबाट शुद्ध भएपछि आफ्नो शुद्धताको निम्ति त्यसले सात दिन गनोस्; त्यसपछि त्यसले आफ्ना लुगा धोओस् र आफ्नो शरीर बगिरहेको पानीले नुहाओस् । त्यसपछि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठौँ दिनमा त्यसले दुईवटा ढुकुर वा परेवाका दुई बचेराहरू लिओस् र परमप्रभुको अगि भेट हुने पालको प्रवेशद्वारमा आओस् । त्यहाँ त्यसले ती चराहरू पुजारीलाई दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","पुजारीले तीमध्ये एउटा पापबलि र अर्को होमबलिको रूपमा अर्पण गर्ने छ, र त्यसको रोगको निम्ति परमप्रभुको अगि प्रायश्‍चित्त गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","यदि कुनै मानिसको वीर्यपात भयो भने, त्यसले आफ्नो पुरै शरीर पानीले नुहाओस्, र त्यो साँझसम्‍म अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","वीर्य भएको सबै लुगा वा छाला पानीले धोइयोस्, र त्यो साँझसम्‍म अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","यदि कुनै पुरुष र स्‍त्री सँगै सुते र त्यस स्‍त्रीभित्र वीर्य स्‍खलन भयो भने, तिनीहरू दुवै पानीले नुहाऊन् र तिनीहरू साँझसम्‍म अशुद्ध रहने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","कुनै स्‍त्रीको महिनावारी भयो भने, त्यसको अशुद्धता सात दिनसम्‍म रहने छ, र त्यस स्‍त्रीलाई छुने मानिस साँझसम्‍म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","त्यसको महिनावारीको समयमा त्यो पल्‍टिने सबै कुरा अशुद्ध हुने छ, र त्यो बस्‍ने सबै कुरा अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","त्यसको ओछ्‍यान छुने मानिसले आफ्ना लुगाहरू धोओस्, पानीले नुहाओस् र त्यो मानिस साँझसम्‍म अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","त्यो बस्‍ने जुनसुकै कुरा छुने मानिसले आफ्ना लुगाहरू धोओस्, पानीले नुहाओस् र त्यो मानिस साँझसम्‍म अशुद्ध रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","चाहे त्यो त्यस स्‍त्रीको ओछ्‍यान होस् वा त्यो बस्‍ने कुनै कुरा, यदि कुनै मानिसले त्यो छुन्छ भने, त्यो साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","यदि कुनै मानिस त्यस स्‍त्रीसँग सुत्‍यो, र त्यसबाट बहने अशुद्ध कुरोले त्यसलाई छोयो भने, त्यो सात दिनसम्म अशुद्ध हुने छ । त्यो पल्‍टिने हरेक ओछ्‍यान अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","यदि कुनै स्‍त्रीको आफ्नो रजस्‍वलाको समयभन्दा फरक समयमा धेरै दिनसम्म रगत बग्‍यो भने, वा त्यसको रजस्‍वलाको समयभन्दा लामो समयसम्म रगत बग्‍यो भने, त्यसको अशुद्धता बगिरहने यी सबै दिनमा त्यो आफ्नो महिनावारीको समयसरह नै हुने छे । त्यो अशुद्ध हुने छे । ");
INSERT INTO npiulb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","रगत बग्‍ने समयमा त्यो पल्‍टिने सबै ओछ्‍यान त्यसको निम्ति रजस्‍वलाको बेलाझैँ हुने छ, र त्यो बस्‍ने सबै कुरा रजस्‍वलाको अशुद्धताझैँ अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","यी कुराहरूमध्ये कुनैलाई छुने जो कोही अशुद्ध हुने छ । त्यसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, अनि त्यो साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","तर यदि त्यो स्‍त्री आफ्नो रगत बगाइबाट शुद्ध भई भने, त्यसले सात दिन गनोस् र त्यसपछि त्यो शुद्ध हुने छे । ");
INSERT INTO npiulb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठौँ दिनमा त्यसले आफूसँग दुईवटा ढुकुर र परेवाका दुईवटा बचेरा लिएर भेट हुने पालको प्रवेशद्वारमा पुजारीकहाँ ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","पुजारीले एउटा चरोलाई पापबलिझैँ र अर्कोलाई होमबलिझैँ अर्पण गर्ने छ, र त्यसको अशुद्ध रगत बगाइको निम्ति परमप्रभुको अगि प्रायश्‍चित्त गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","यसरी तिमीहरूले इस्राएलका मानिसहरूलाई तिनीहरूका अशुद्धताबाट अलग गर्नू, ताकि म तिनीहरूका माझमा बस्‍ने पवित्र स्थानलाई तिनीहरूले अपवित्र गरेर तिनीहरू नमरून् । ");
INSERT INTO npiulb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","तरल बग्‍ने समस्या भएको जो कोही, वीर्यपातको समस्या भएर अशुद्ध भएको पुरुष, ");
INSERT INTO npiulb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","रजस्‍वलाको महिनावारी भएकी स्‍त्री, तरल बग्‍ने समस्या भएको पुरुष वा स्‍त्री, र अशुद्ध स्‍त्रीसँग सुत्‍ने पुरुष सबैका निम्ति विधिविधान यी नै हुन् ।’” ");
INSERT INTO npiulb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","हारूनका दुई छोरा परमप्रभुको अगि गएका कारण तिनीहरूको मृत्‍यु भएपछि परमप्रभु मोशासँग बोल्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","परमप्रभुले मोशालाई भन्‍नुभयो, “तेरा दाजु हारूनलाई मनपरी समयमा सन्दूकमाथिको प्रायश्‍चित्त-आसनको अगि पर्दाभित्रको महा-पवित्र स्थानमा नआओस् भन् । त्यसले त्यस्तो गरे त्यो मर्ने छ, किनभने प्रायश्‍चित्त-आसनमाथि बादलमा म प्रकट हुने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","यसैकारण हारून महा-पवित्र स्थानभित्र यसरी प्रवेश गरोस् । त्यसले पापबलिको रूपमा एउटा साँढे र होमबलिको निम्ति एउटा भेडा लिएर आओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","त्यसले सूतीको पवित्र दौरा, र सूतीको भित्री वस्‍त्र पहिरोस्, र सूतीको पटुका र सूतीको फेटा लगाओस् । यी पवित्र पोशाक हुन् । त्यसले आफ्‍नो शरीर पानीले नुहाएर यी पोशाक लगाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","त्यसले इस्राएलका मानिसहरूको समुदायबाट पापबलिको रूपमा दुईवटा बोका र होमबलिको रूपमा एउटा भेडा लेओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","अनि हारूनले साँढेलाई पापबलिको रूपमा अर्पण गरोस्, जुन त्यो आफै र आफ्‍नो परिवारको लागि प्रायश्‍चित्त गर्नका निम्ति हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","त्यसपछि त्यसले दुईवटा बोका लिएर भेट हुने पालको प्रवेशद्वारमा परमप्रभुको अगि तयार गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अनि हारूनले ती दुई बोकाका निम्ति चिट्ठा हालोस्, एउटा चिट्ठाचाहिँ परमप्रभुको निम्ति अर्पण गर्नलाई, र अर्कोचाहिँ छोडिने बोकाको निम्ति । ");
INSERT INTO npiulb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","चिट्ठामा परमप्रभुको भागमा परेको बोकालाई हारूनले पापबलिको निम्ति अर्पण गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","तर छोडिनको निम्ति चिट्ठा परेको बोकालाईचाहिँ उजाड-स्थानमा छोडेर प्रायश्‍चित्त गर्नको निम्ति परमप्रभुको अगि जीवितै ल्याइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","त्यसपछि हारूनले आफ्‍नै निम्ति साँढेलाई पापबलिको रूपमा अर्पण गरोस् । त्यसले आफ्नो र आफ्नो परिवारको निम्ति प्रायश्‍चित्त गरोस्, र यसैकारण आफ्नै निम्ति पापबलिको रूपमा त्यसले साँढेलाई मारोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","हारूनले वेदीबाट आगोका फिलिङ्गाहरूले भरिएको एउटा धुपौरो र आफ्ना हातमा मसिनो गरी पिसिएको सुगन्धित धुप लिएर पर्दाभित्र परमप्रभुको सामु ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","त्यहाँ त्यसले परमप्रभुको सामु भएको आगोमा धुप राखोस् ताकि करारको सन्दुकमाथिको प्रायश्‍चित्त-आसनलाई त्यस धुपबाट निस्‍केको बादलले ढाकोस् । त्यो नमरोस् भनेर त्यसले यो गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","अनि त्यसले साँढेको केही रगत लिएर प्रायश्‍चित्त-आसनको सामु आफ्नो औँलाले छर्कोस् । त्यसले प्रायश्‍चित्त-आसनको सामु औँलाले सात पटक रगत छर्कोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","त्यसपछि त्यसले मानिसहरूका निम्ति पापबलिको बोकालाई मारोस् र त्यसको रगत पर्दाभित्र ल्याओस् । त्यसले त्यहाँ साँढेको रगतलाई जे गरेको थियो, बोकाको रगतलाई पनि त्यस्‍तै गरोस्, अर्थात् त्यसले त्यो रगत प्रायश्‍चित्त-आसनमाथि र त्यसपछि प्रायश्‍चित्त-आसनको सामु छर्कोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","इस्राएलका मानिसहरूका अशुद्ध कामहरू, तिनीहरूको विद्रोह र तिनीहरूका सारा पापको कारण पवित्रस्थानको निम्ति त्यसले प्रायश्‍चित्त गरोस् । त्यसले यो भेट हुने पालको निम्ति पनि गरोस्, जहाँ तिनीहरूका अशुद्ध कामहरूका बिचमा परमप्रभु तिनीहरू माझमा बास गर्नुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","हारून महा-पवित्र स्थानमा प्रायश्‍चित्त गर्नको निम्ति प्रवेश गरेपछि त्यसले आफ्नो, आफ्नो परिवार र इस्राएलका सबै समुदायको निम्ति प्रायश्‍चित्त गर्न सकेर बाहिर नआएसम्म कोही पनि भेट हुने पालभित्र नपसोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","परमप्रभुको सामु भएको वेदीको नजिक त्यो जाओस् र त्यसको निम्ति प्रायश्‍चित्त गरोस्, र साँढे र बोकाको केही रगत लिएर त्यसले वेदीका सिङहरूका चारैतिर लगाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","त्यसले त्यसलाई शुद्ध गर्न र इस्राएलका मानिसहरूका अशुद्ध कामहरूबाट टाढा गरी परमप्रभुको निम्ति अलग्‍ग गर्नलाई त्यसमाथि आफ्नो औँलाले केही रगत सात पटक छर्कोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","त्यसले महा-पवित्र स्थान, भेट हुने पाल र वेदीको निम्ति प्रायश्‍चित्त गरेर सक्‍काएपछि त्यसको जिउँदो बोका अर्पण गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","हारूनले आफ्ना दुवै हात त्यस जिउँदो बोकाको शिरमा राखोस् र त्यसमाथि इस्राएलका मानिसहरूका सबै दुष्‍टता, तिनीहरूका सबै विद्रोह, र सबै पापलाई मानिलिओस् । त्यसपछि त्यसले त्यस बोकाको शिरमाथि त्यो पाप राखोस् र त्यस बोकालाई उजाड-स्थानतर्फ डोर्‍याउन तयार भएको मानिसको जिम्मामा दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","त्यस बोकाले मानिसहरूका सबै दुष्‍टतालाई आफूमाथि बोकी एउटा एकान्‍त ठाउँमा जाओस् । उता उजाड-स्थानमा त्यस मानिसले त्यो बोकालाई छोडिदिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","त्यसपछि हारून फर्केर भेट हुने पालमा जाओस् र महा-पवित्र स्थानमा जानुअगि त्यसले लगाएका सूतीका लुगाहरू फुकालोस्, र ती लुगाहरूलाई त्यहीँ नै छोडोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","त्यसले कुनै पवित्र स्थानमा आफ्नो शरीर पानीले नुहाओस्, र आफ्ना साधारण लुगा लगाओस्, र त्यसपछि त्यो गएर आफ्ना मानिसहरूका निम्ति होमबलि अर्पण गरोस् अनि यसरी आफ्नो र मानिसहरूका निम्ति प्रायश्‍चित्त गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","त्यसले वेदीमा पापबलिको बोसोलाई जलाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","छोडिने बोकालाई जान दिने मानिसले आफ्ना लुगाहरू र आफ्नो शरीर पानीले धोओस्, र त्यसपछि त्यो छाउनीभित्र फर्कन सक्‍छ । ");
INSERT INTO npiulb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","पापबलिको निम्ति साँढे र बोका, जसको रगत पवित्र स्थानमा प्रायश्‍चित्त गर्नका निम्ति ल्याइएको थियो, ती दुवैलाई छाउनीभन्दा बाहिर लगिओस् । त्यहाँ तिनीहरूले त्यसका छाला, मासु र गोबर जलाउने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ती भागहरू जलाउने मानिसले आफ्ना लुगाहरू धोओस् र आफ्नो शरीर पानीले नुहाओस्, र त्यसपछि त्यो छाउनीभित्र आउन मिल्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","यो तिमीहरूका निम्ति सधैँ एउटा विधि बनोस्, कि सातौँ महिनाको दसौँ दिनमा, तिमीहरूका बिचमा जन्मेको वा तिमीहरूका बिचमा बास गर्ने परदेशी सबैले आफैलाई नम्र बनाओस् र कुनै काम नगरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","किनभने तिमीहरूका सबै पापबाट तिमीहरूलाई शुद्ध गर्नका निम्ति यस दिनमा तिमीहरूका खातिर प्रायश्‍चित्त गरिने छ, यसैकारण तिमीहरू परमप्रभुको अगि शुद्ध हुने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यो तिमीहरूका निम्ति विश्रामको विधिपूर्ण शबाथ हो, र तिमीहरूले आफैलाई नम्र बनाउनुपर्छ र कुनै काम गर्नुहुँदैन । यो तिमीहरूका बिचमा सधैँ एउटा विधि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","आफ्नो पिताको स्थानमा प्रधान पुजारी हुनको निम्ति अभिषेक भएको र नियुक्‍त भएको प्रधान पुजारीले यसरी प्रायश्‍चित्त गरोस् र पवित्र लुगाहरू, अर्थात् सूतीका लुगाहरू लगाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","त्यसले महा-पवित्र स्थान, भेट हुने पाल, वेदी, पुजारीहरू र समुदायका सबै मानिसहरूका निम्ति प्रायश्‍चित्त गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","इस्राएलका मानिसहरूका सबै पापका कारण यो सधैँका लागि तिमीहरूले तिनीहरूका निम्ति वर्षमा एक पटक प्रायश्‍चित्त गर्ने विधि होस् ।” परमप्रभुले मोशालाई आज्ञा गर्नुभएअनुसार नै यो भयो । ");
INSERT INTO npiulb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून, त्यसका छोराहरू र इस्राएलका सारा मानिसहरूलाई परमप्रभुले आज्ञा गर्नुभएका कुराहरू भन्ः ");
INSERT INTO npiulb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","‘यदि इस्राएलको कुनै मानिसले बलिदानको निम्ति भनेर छाउनीभित्र वा बाहिर साँढे, भेडाको बच्‍चा वा बोका मार्दछ, ");
INSERT INTO npiulb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","तर यदि त्यसले त्यो भेट हुने पालको प्रवेशद्वारमा परमप्रभुको पवित्र स्थानअगि बलिदानको रूपमा अर्पण गर्न ल्याउँदैन भने, त्यस रक्‍तपातको कारण त्यो दोषी हुने छ । त्यसले रगत बगाएको छ र त्यो मानिस आफ्ना मानिसहरूका बिचबाट बहिष्‍कृत होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","इस्राएलका मानिसहरूले आफ्ना बलिदानहरूलाई बाहिर खुला ठाउँमा नभएर भेट हुने पालको प्रवेशद्वारमा परमप्रभुकहाँ ल्याऊन्, र परमप्रभुको निम्ति मेलबलिको रूपमा अर्पण गरिनको निम्ति तिनीहरूले त्यो पुजारीकहाँ ल्याऊन् भनेर यो आज्ञा दिइएको हो । ");
INSERT INTO npiulb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","भेट हुने पालको प्रवेशद्वारमा पुजारीले परमप्रभुको वेदीमा रगत छर्कने छ, र परमप्रभुको निम्ति मिठो सुगन्ध दिनको निम्ति उसले बोसो जलाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","अबदेखि तिनीहरूले बाख्राका मूर्तिहरूलाई आफ्ना बलिदानहरू अर्पण नगरून्, जसका निम्ति तिनीहरू वेश्याहरूझैँ व्यवहार गर्दछन् । तिनीहरूका मानिसहरूको समस्‍त पुस्‍तामा यो सधैँको निम्ति विधि हुने छ ।’ ");
INSERT INTO npiulb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","तैँले तिनीहरूलाई भन्‍नू, ‘इस्राएलको कुनै मानिस वा तिनीहरूका माझमा बसोबास गर्ने कोही परदेशी, जसले होमबलि वा कुनै बलिदान अर्पण गर्दछ, ");
INSERT INTO npiulb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","र त्यसलाई परमप्रभुकहाँ अर्पण गरिनलाई भेट हुने पालको प्रवेशद्वारमा ल्याउँदैन भने, त्यो मानिस आफ्ना मानिसहरूबाट बहिष्‍कृत होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","यदि इस्राएलका घरानाको कुनै मानिस, वा तिनीहरूका माझमा बसोबास गर्ने कोही परदेशीले रगत खायो भने, म त्यो रगत खाने मानिसको विरुद्ध हुने छु र म त्यसलाई त्यसका मानिसहरूबाट बहिष्‍कृत गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","किनभने हरेक जीवधारीको प्राण त्यसको रगतमा हुन्छ । तिमीहरूले आफ्ना प्राणको निम्ति प्रायश्‍चित्त गर्नलाई मैले त्यसको रगत तिमीहरूलाई दिएको छु, किनभने रगतले नै जीवनको प्रायश्‍चित्त गर्दछ । ");
INSERT INTO npiulb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","त्यसैकारण इस्राएलका मानिसहरू वा तिनीहरूका माझमा बसोबास गर्ने कोही परदेशीले पनि रगत नखाऊन् भनेर मैले तिनीहरूलाई आज्ञा गरेको हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","इस्राएलको कुनै मानिस, वा तिनीहरूका माझमा बसोबास गर्ने कोही परदेशीले कुनै खान मिल्‍ने पशु वा पक्षीको शिकार गरी त्यसलाई मार्दछ भने, त्यो मानिसले त्यसको रगत निथारेर माटोले ढाकिदिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","किनभने हरेक जीवधारीको प्राण त्यसको रगतमा हुन्छ । त्यसैकारण मैले इस्राएलका मानिसहरूलाई भनेँ, “कुनै पनि प्राणीको रगत तिमीहरूले नखानू, किनभने हरेक प्राणीको जीवन त्यसको रगतमा हुन्छ । जसले त्यो खान्छ, त्यो बहिष्‍कृत होस् ।” ");
INSERT INTO npiulb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","कुनै मानिस जसले मरिसकेको वा जङ्गली जनावरले फहराएको पशु खान्छ, त्यो मानिस स्थानीय वा तिमीहरूका माझमा बसोबास गर्ने परदेशी जो भए तापनि, त्यसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्, र त्यो साँझसम्म अशुद्ध हुने छ । त्यसपछि त्यो शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","तर यदि त्यसले आफ्ना लुगाहरू धुँदैन वा आफ्नो शरीर नुहाउँदैन भने, त्यसले आफ्नो दोष बोकिरहोस् ।’” ");
INSERT INTO npiulb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएलका मानिसहरूलाई यसो भन्, ‘म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तिमीहरू पहिले बसोबास गर्ने मिश्रका मानिसहरूले त्यहाँ जे गर्थे ती तिमीहरूले नगर्नू । मैले तिमीहरूलाई लैजान लागेको देश अर्थात् कनानका मानिसहरूले त्यहाँ जे गर्थे ती तिमीहरूले नगर्नू । तिमीहरूले तिनीहरूका रीतिरिवाजहरू नपछ्‍याउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","मेरो व्यवस्था तिमीहरूले पालन गर्नू, र मेरा आज्ञाहरू मान्‍नू, र तीअनुसार तिमीहरू हिँड्नू, किनभने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","यसैकारण तिमीहरूले मेरा आज्ञाहरू मान्‍नू र मेरा व्यवस्था पालन गर्नू । ती पालन गर्ने मानिस तीद्वारा नै बाँच्‍दछ । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","आफ्नो नजिकको नातेदारसँग सुतेर कसैले पनि आफ्नो नग्‍नता नदेखाओस् । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","आफ्नी आमासँग सुतेर आफ्ना बुबाको अनादार नगर्नू । त्यो तेरी आमा हो! तैँले त्यसलाई अनादर नगर् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","आफ्ना बुबाकी कुनै पत्‍नीसँग पनि नसुत् । त्यस्तो काम गरेर आफ्ना बुबाको अनादर नगर् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","आफ्नी कुनै दिदी-बहिनीसँग नसुत्, चाहे त्यो तेरो बुबाकी छोरी वा आमाकी छोरी होस्, चाहे त्यो तेरो घरमा वा घरबाट टाढा हुर्काइएकी होस् । आफ्नी दिदी-बहिनीसँग नसुत् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","आफ्नो छोरा वा छोरीको छोरीसँग नसुत् । त्यो तेरो निम्ति शर्मको कुरा हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","आफ्ना बुबाकी पत्‍नीकी छोरीसँग नसुत्, जो तेरो बुबाबाट जन्मेकी थिई । त्यो तेरो बहिनी हो, र तँ त्योसँग नसुत् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","आफ्ना बुबाकी दिदी-बहिनीसँग नसुत् । त्यो तेरो बुबाको नजिकको नातेदार हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","आफ्नी आमाकी दिदी-बहिनीसँग नसुत् । त्यो तेरी आमाको नजिकको नातेदार हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","आफ्ना बुबाको दाजु वा भाइकी पत्‍नीसँग सुतेर त्यसको अनादर नगर् । त्यस्तो कामको निम्ति त्यसको नजिक नजा, त्यो तेरी काकी हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","आफ्नी बुहारीसँग नसुत् । त्यो तेरो छोरोकी पत्‍नी हो, त्योसँग नसुत् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","आफ्नो दाजु वा भाइकी पत्‍नीसँग नसुत् । यस्तो काम गरेर त्यसको अनादर नगर् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","कुनै स्‍त्री र त्यसकी छोरी दुवैसँग नसुत्, वा त्यसको छोराकी छोरीसँग वा त्यसकी छोरीकी छोरीसँग नसुत् । तिनीहरू त्यस स्‍त्रीका नजिकका नातेदार हुन् र तिनीहरूसँग सुत्‍नु दुष्‍टता हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","आफ्नी पत्‍नीकी दिदी वा बहिनीलाई विवाह नगर् र आफ्नो पहिलेकी पत्‍नी जीवितै हुँदासम्‍म त्यसकी दिदी वा बहिनीसँग नसुत् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","कुनै स्‍त्रीको रजस्‍वलाको समयमा त्योसँग सहवास नगर् । त्यो समयमा त्यो अशुद्ध हुन्छे । ");
INSERT INTO npiulb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","आफ्नो छिमेकीकी पत्‍नीसँग नसुत् र यसरी आफैलाई अशुद्ध नबना । ");
INSERT INTO npiulb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","आफ्ना छोराछोरीहरूलाई मोलोखको निम्ति बलि गर्नलाई तिनीहरूलाई आगोमा नहाल्नू, किनभने तिमीहरूले यसो गरेर आफ्ना परमेश्‍वरको नाउँलाई अपवित्र नबनाउनू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","स्‍त्रीसँगझैँ गरी अरू पुरुषहरूसँग नसुत्‍नू । यो दुष्‍टता हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","कुनै पशुसँग सहवास गरेर आफैलाई अशुद्ध नबनाउनू । कुनै पनि स्‍त्री कुनै पशुसँग नसुत्‍नू । यो अस्वाभाविक दुराचरण हो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","यस्ता कामहरू गरेर आफैलाई अपवित्र नबनाउनू, किनभने जुन जातिहरूलाई मैले तिमीहरूका सामुबाट निकाल्दै छु ती यी सबै कारणले अपवित्र भएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","तिनीहरूको भूमि अपवित्र भयो, र यसैकारण मैले तिनीहरूका पापको दण्ड दिएँ, र त्यस भूमिले त्यसका बासिन्दाहरूलाई उकेलेर निकालिदियो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","यसैकारण, तिमीहरूले मेरा आज्ञाहरू र विधिहरू पालन गर्नू, र इस्राएलका स्वदेशी वा तिमीहरूका बिचमा बसोबास गर्ने परदेशी जोकोहीले कुनै पनि यस्ता घृणास्‍पद काम नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","तिमीहरूभन्दा अगि यस भूमिमा बसोबास गर्ने मानिसहरूले यस्तै दुष्‍ट काम गरे, र यसैकारण सारा देश नै अपवित्र भयो । ");
INSERT INTO npiulb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","तिमीहरूका अपवित्रताका कारण तिमीहरूभन्दा अगिका मानिसहरूलाई झैँ त्यस भूमिले तिमीहरूलाई पनि उकेलेर बाहिर ननिकालोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","तिमीहरूमध्ये जो कोहीले यस्ता घृणास्पद कामहरू गर्दछन् भने, तिनीहरू आफ्ना मानिसहरूबाट बहिष्‍कृत हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","तिमीहरूभन्दा अगि यहाँ अभ्यास हुने गरेका कुनै यस्ता घृणास्‍पद रीतिरिवाजहरूलाई तिमीहरूले अभ्यास नगरेर मेरो आज्ञा पालन गर्नू अनि यसरी तिमीहरूले यस्ता कामले आफैलाई अपवित्र बनाउने छैनौ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ इस्राएलका मानिसहरूको सबै समुदायलाई भन्, ‘म परमप्रभु तिमीहरूका परमेश्‍वर पवित्र भएको कारण तिमीहरू पवित्र होओ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","हरेकले आफ्ना आमा र बुबालाई आदर गर्नू, र मेरो शबाथ पालन गर्नू । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","मूल्यहीन मूर्तिहरूलाई नपछ्‍याओ, न त आफ्नै निम्ति धातुका ईश्‍वरहरू बनाओ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","तिमीहरूले परमप्रभुलाई मेलबलि अर्पण गर्दा तिमीहरू स्वीकारिनको निम्ति त्यो अर्पण गर । ");
INSERT INTO npiulb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","तिमीहरूले अर्पण गर्ने दिनमा वा अर्को दिनमा नै त्यो खाइयोस् । तेस्रो दिनसम्म केही बाँकी रह्‍यो भने, त्यो आगोद्वारा जलाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","यदि त्यो तेस्रो दिनमा खाइयो भने, त्यो मासु अशुद्ध हो; त्यसलाई ग्रहण गरिनुहुँदैन, ");
INSERT INTO npiulb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","र त्यो जसले खान्छ त्यसले आफ्नो दोष बोकिरहने छ किनभने परमप्रभुको निम्ति जे पवित्र छ त्यो त्यसले अशुद्ध गरेको छ, र त्यो मानिस आफ्ना मानिसहरूबाट बहिष्‍कृत होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","तिमीहरूले आफ्ना जमिनको कटनी गर्दा पूर्ण रूपमा आफ्ना जमिनको कुना-कुनाहरूमा कटनी नगर्नू, न त आफ्ना फसल सबै बटुल्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","आफ्नो दाखबारीबाट सबै दाख तिमीहरूले नबटुल्‍नू, न त आफ्ना दाखबारीमा खसेका दाख बटुल्‍नू । तिमीहरूले ती गरिब र परदेशीहरूका निम्ति छोडिदिनू । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","चोरी नगर्नू । झुटो नबोल्नू । एक-अर्कालाई धोका नदिनू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","मेरो नामको झुटो शपथ खाएर तिमीहरूका परमेश्‍वरको नाउँलाई अशुद्ध नतुल्याउनू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","आफ्नो छिमेकीमाथि दमन नगर्नू वा उसलाई नलुट्‍नू । ज्यालामा काम गर्ने नोकरको पारिश्रमिक रातभर र बिहानसम्म तिमीहरूसँग नरहोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","बहिरोलाई सराप नदिनू वा अन्धाको अगाडि ठेस लाग्‍ने कुरो नराख्‍नू । बरु, तिमीहरूले आफ्ना परमेश्‍वरको भय मान्‍नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","झुटो न्याय नगर्नू । कोही गरिब भएको कारण र कोही महत्त्वपूर्ण भएको कारण तिमीहरूले कसैप्रति पक्षपात नगर्नू । बरु, आफ्नो छिमेकीको सही न्याय गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","आफ्ना मानिसहरूका बिचमा निन्‍दा फैलाउँदै नहिँड्नू, तर आफ्नो छिमेकीको प्राण बचाउने कोसिस गर्नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","आफ्नो हृदयमा आफ्नो भाइको निम्ति घृणा नराख्‍नू । आफ्नो छिमेकीसँगै पाप नगर्नको निम्ति उसलाई इमानदार भएर हप्‍काउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","बदला नलिनू वा आफ्ना मानिसहरूका विरुद्धमा कुनै इख नराख्‍नू, बरु आफ्नो छिमेकीलाई आफैलाई झैँ प्रेम गर्नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","तिमीहरूले मेरा आज्ञाहरू मान्‍नू । आफ्‍ना पशुहरूलाई अर्कै प्रजातिका पशुसँग मिलन नगराओ । आफ्नो खेतमा दुई प्रकारका बिउहरू नछर । दुई प्रकारको सामग्री मिसिएको कपडा नलगाओ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","मगनी भएको तर मोल नतिरिएको वा स्वतन्त्र नगराइएको कमारी स्‍त्रीसँग सुत्‍नेलाई दण्ड दिइयोस् । तिनीहरूलाई मृत्युदण्ड नदिनू किनभने त्यो मुक्‍त थिई । ");
INSERT INTO npiulb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","त्यस मानिसले भेट हुने पालको प्रवेशद्वारमा परमप्रभुकहाँ एउटा भेडा दोषबलिको रूपमा ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","त्यसपछि पुजारीले त्यस मानिसको लागि त्यसले गरेको पापको खातिर परमप्रभुको अगि दोषबलिको निम्ति त्यस भेडाद्वारा प्रायश्‍चित्त गर्ने छ । अनि त्यसले गरेको पाप क्षमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","तिमीहरूले जमिनमा हर प्रकारका रुखहरूलाई फलको निम्ति लगाएपछि तिनीहरूले उत्पादन गरेका फललाई खानको निम्ति मनाही गरिएको मान्‍नू । ती फल तेरो निम्ति खानलाई तिन वर्षसम्म मनाही हुने छ । त्यो नखानू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","तर चौथो वर्षमा सबै फल परमप्रभुको निम्ति प्रशंसाको बलिदानझैँ पवित्र हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","पाँचौँ वर्षमा रुखहरूले अझै बढी उत्पादन गरून् भनेर पर्खिसकेपछि तिमीहरू फल खान सक्‍छौ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","कुनै मासुमा रगत बाँकी छ भने त्यो नखानू । भविष्‍यबारे जान्‍न आत्माहरूसँग सल्लाह नलिनू, र अरूहरूलाई अलौकिक शक्‍तिहरूद्वारा नियन्त्रण गर्ने प्रयास नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","तिमीहरूका कन्‍चेटको कपाल नखुर्कनू वा दाह्रीका कुना-कुना नकाट्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","मरेको मानिसको निम्ति आफ्नो शरीर नकाट्‍नू वा आफ्नो शरीरमा खोपेर कुनै छाप नबनाउनू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","आफ्नी छोरीलाई वेश्‍या बनाएर त्यसको अपमान नगर्नू, नत्रता सारा देश वेश्‍यागमनतिर लाग्‍ला र देश दुष्‍टताले भरिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","तिमीहरूले मेरो शबाथ मान्‍नू र मेरो पवित्र स्थानको आदर गर्नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","मरेकाहरू वा आत्माहरूसँग बोल्‍नेहरूलाई नपछ्‍याओ । तिनीहरूको खोजी नगर, नत्रता तिनीहरूले तिमीहरूलाई अशुद्ध पार्ने छन् । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","फुलेका केश भएकाहरूका उपस्थितिमा खडा होओ र वृद्ध मानिसको उपस्थितिलाई आदर गर । तिमीहरूका परमेश्‍वरको भय मान । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","तिमीहरूका देशमा कुनै परदेशी बस्‍दछ भने, त्यसलाई कुनै हानि नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","तिमीहरूसँग बसोबास गर्ने परदेशी तिमीहरूका निम्ति तिमीहरूसँगै बसोबास गर्ने इस्राएलमै जन्‍मेको मानिसझैँ होस्, र त्यसलाई आफैलाई झैँ प्रेम गर्नू, किनभने तिमीहरू पनि मिश्र देशमा परदेशी नै थियौ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","लम्बाइ, तौल र सङ्ख्या नाप्‍दा छल नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","तिमीहरूले ठिक-ठिक तराजु र ढक, र ठिक-ठिक नाप र तौलहरू प्रयोग गर्नू । तिमीहरूलाई मिश्र देशबाट बाहिर ल्याउने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","तिमीहरूले मेरा सबै आज्ञाहरू र मेरा सबै विधिविधानहरू मान्‍नू र तीअनुसार चल्‍नू । म परमप्रभु हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएलका मानिसहरूलाई भन्, ‘इस्राएलका मानिसहरू, वा इस्राएलमा बसोबास गर्ने परदेशीहरूमध्ये कसैले आफ्ना छोराछोरी मोलोखलाई चढाउँछ भने, त्यो मारिनुपर्छ । त्यहाँका मानिसहरूले त्यसलाई ढुङ्गाले हानून् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","त्यसले आफ्नो बालक मोलोखलाई दिएर मेरो पवित्र ठाउँ र पवित्र नाउँ अशुद्ध बनाएको हुनाले म त्यसको विरुद्ध खडा हुने छु र त्यसका मानिसहरूका बिचबाट त्यसलाई बहिष्कार गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","यदि त्यो मानिसले आफ्ना छोराछोरीमध्ये कोही मोलोखलाई चढाउँदा त्यस भूमिका मानिसहरूले आफ्ना आँखा बन्द गरे, र त्यसलाई मृत्युदण्ड दिएनन् भने, ");
INSERT INTO npiulb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","त्यस मानिस र त्यसको वंशको विरुद्ध म आफै खडा हुने छु, र त्यसलाई र मोलोखसँग वेश्‍यागमन गर्ने सबैलाई बहिष्‍कृत गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","मरेकाहरू वा आत्माहरूसँग बोलेर आफैलाई वेश्‍यासरह तुल्‍याउनेहरूलाई पछ्‍याउने मानिसको विरुद्ध म खडा हुने छु र त्यसका मानिसहरूका बिचबाट त्यसलाई बहिष्‍कार गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","त्यसैले आफैलाई अर्पण गर र पवित्र होओ, किनभने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । १ ");
INSERT INTO npiulb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","तिमीहरूले मेरा आज्ञाहरू मानेर ती पालन गर्नू । तिमीहरूलाई पवित्र बनाउने परमप्रभु म नै हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","आफ्नी आमा वा आफ्नो बुबालाई सराप दिने सबै मारिनुपर्छ । त्यसले आफ्नो बुबा वा आफ्नी आमालाई सरापेको हुनाले त्यो दोषी हुन्छ र त्यो मर्न योग्‍यको हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","अर्कै पुरुषको पत्‍नीसँग व्यभिचार गर्ने मानिस अर्थात् आफ्नो छिमेकीकी पत्‍नीसँग व्यभिचार गर्ने त्यो व्यभिचारी मानिस, र व्याभिचारिणी दुवैलाई मारिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","आफ्नो बुबाकी पत्‍नीसँग सुत्‍ने मानिसले आफ्नो बुबाको नग्‍नतालाई प्रकट गर्दछ । त्यो छोरा र त्यसको बुबाकी पत्‍नी दुवै मारिनुपर्छ । तिनीहरूको रगत तिनीहरू आफैमाथि पर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","यदि कोही मानिस आफ्नी बुहारीसँग सुत्‍यो भने, तिनीहरू दुवै मारिनुपर्छ । तिनीहरूले दुराचरण गरेका हुनाले तिनीहरू दोषी हुन्छन् र तिनीहरू मर्न योग्‍यका हुन्छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","कोही पुरुष स्‍त्रीसँग झैँ गरी अर्को पुरुषसँग सुत्‍यो भने, तिनीहरू दुवैले घृणास्पद काम गरेका छन् । तिनीहरू मारिनैपर्छ । तिनीहरू दोषी हुन्छन् र तिनीहरू मर्न योग्‍यका हुन्छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","कोही पुरुषले कुनै स्‍त्री र त्यसकी आमा दुवैलाई विवाह गर्‍यो भने, यो दुष्‍टता हो । त्यो पुरुष र ती दुवै स्‍त्री जलाइनुपर्छ ताकि तिमीहरूका बिचमा कुनै दुष्‍टता नहोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","कोही पुरुषले पशुसँग सहवास गरेमा त्यो मारिनैपर्छ, र तिमीहरूले त्यो पशुलाई पनि मार्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","कोही स्‍त्री पशुसँग सहवास गर्नलाई त्यसको नजिक गई भने, तिमीहरूले त्यस स्‍त्री र पशु दुवैलाई मार्नू । तिनीहरू निश्‍चय नै मारिनैपर्छ । तिनीहरू दोषी हुन्छन् र मर्न योग्‍यका हुन्छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","कोही पुरुषले आफ्नी दिदी-बहिनी, वा आफ्नो बुबा वा आमाकी छोरीसँग सुतेर त्यसको नग्‍नता प्रकट गर्दछ, र त्यसले त्यस पुरुषको नग्‍नता देख्‍दछे भने, यो शर्मको कुरा हो । त्यो आफ्नी दिदी-बहिनीसँग सुतेको कारण तिनीहरू आफ्ना मानिसहरूको उपस्थितिबाट बहिष्‍कृत गरिनुपर्छ । त्यसले आफ्नो दोष बोकिरहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","कोही पुरुष स्‍त्रीको रजस्‍वलाको समयमा त्योसँग सुत्‍यो भने, त्यसले त्यसको रगतको मूल देखाउँदछ । ती पुरुष र स्‍त्री दुवै आफ्ना मानिसहरूबाट बहिष्‍कृत गरिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","आफ्नो बुबा वा आमाकी दिदी-बहिनीसँग नसुत्, किनभने तैँले त्यसो गरेर आफ्नो नजिकको नाताको अपमान गर्ने छस् । तैँले आफ्नो दोष आफै बोक्‍ने छस् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","कोही पुरुष आफ्नी काकीसँग सुत्यो भने, त्यसले आफ्नो काकाको अपमान गर्दछ । तिनीहरूले आ-आफ्नो पापको भार उठाउने छन्, र तिनीहरू निसन्तान नै मर्ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","कोही मानिसले आफ्नो दाजु वा भाइ जीवितै हुँदा त्यसकी पत्‍नीलाई बिहे गर्‍यो भने, त्यो अपमानजनक हो । त्यसले आफ्नो दाजु वा भाइलाई अनादर गर्दछ, र तिनीहरूले आफ्ना आमाबुबाबाट उत्तराधिकारको रूपमा प्राप्‍त गरेका सबै सम्पत्ति तिनीहरूका छोराछोरीबाट म खोसिदिने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","त्यसैकारण तिमीहरूले मेरा सबै विधिविधानहरू र आज्ञाहरू पालन गर्नू । यी तिमीहरूले पालन गर्नू ताकि तिमीहरूलाई बसोबास गर्नको निम्ति मैले लैजान लागेको भूमिले तिमीहरूलाई नउकेलोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","तिमीहरूका सामुबाट मैले निष्‍कासन गरेका जातिहरूका रीतिरिवाजहरूमा तिमीहरू नहिँड्नू, किनभने तिनीहरूले यी सबै कुरा गरे, र मैले तिनीहरूलाई घृणा गरेँ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","मैले तिमीहरूलाई भनेँ, “तिमीहरूले तिनीहरूका भूमि उत्तराधिकारमा पाउने छौ । दूध र मह बगिरहने देश म तिमीहरूको अधिकारमा दिने छु । अरू मानिसहरूबाट तिमीहरूलाई अलग गर्ने परमप्रभु तिमीहरूका परमेश्‍वर म नै हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","यसैकारण तिमीहरूले शुद्ध र अशुद्ध पशु, अनि शुद्ध र अशुद्ध पक्षीबिच भेद राख्‍नू । मैले तिमीहरूका निम्ति अशुद्ध भनेर छुट्‍ट्याएको अशुद्ध पशु वा पक्षी वा जमिनमा घस्रने प्राणीद्वारा आफैलाई अशुद्ध नबनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तिमीहरू पवित्र होओ, किनभने म परमप्रभु पवित्र छु, र मैले तिमीहरूलाई अरू मानिसहरूबाट अलग गरेको छु, किनभने तिमीहरू मेरा हौ । ");
INSERT INTO npiulb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","मरेकाहरू वा आत्माहरूसँग बोल्‍ने पुरुष वा स्‍त्री मारिनुपर्छ । मानिसहरूले तिनीहरूलाई ढुङ्गाले हानून् । तिनीहरू दोषी छन् र मर्न योग्‍यका छन् ।’” 20:7 १ धेरै वर्तमान संस्करणमा यस्तो छः ... किनभने म, परमप्रभु तिमीहरूका परमेश्‍वर पवित्र छु । ");
INSERT INTO npiulb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, “पुजारीहरू अर्थात् हारूनका छोराहरूलाई यसो भन्, ‘आफ्ना मानिसहरूका बिचमा मर्नेहरूका निम्ति तिमीहरूमध्ये कोहीले पनि आफूलाई अशुद्ध नबनाउनू, ");
INSERT INTO npiulb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","तर त्यसका नजिकका नातेदारहरू अर्थात् त्यसकी आमा, त्यसको बुबा, छोरा, त्यसकी छोरी, त्यसको दाजु वा भाइ, ");
INSERT INTO npiulb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","वा त्यसमा आश्रित त्यसकी कन्या दिदी वा बहिनी जसको पति छैन, यी सबैका निम्ति त्यसले आफैलाई अशुद्ध बनाउन सक्‍छ । ");
INSERT INTO npiulb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","तर त्यसले आफ्ना अरू नातेदारहरूका निम्ति आफैलाई अशुद्ध नबनाओस् र आफैलाई अपवित्र नबनाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","पुजारीहरूले आफ्नो शिर नखौरून् वा तिनीहरूका दाह्रीका कुना-कुना नकाटून्, न त तिनीहरूले आफ्ना शरीरहरू काटून् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","तिनीहरू आफ्ना परमेश्‍वरका निम्ति पवित्र रहून्, र तिनीहरूका परमेश्‍वरका नाउँको अपमान नगरून्, किनभने पुजारीहरूले परमप्रभुका भोजनको बलिदान अर्थात् तिनीहरूका परमेश्‍वरको भोजन अर्पण गर्दछन् । यसैकारण पुजारीहरू पवित्र रहून् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","तिनीहरू आफ्ना परमेश्‍वरका निम्ति अलग गरिएका हुनाले तिनीहरूले त्यस्ती स्‍त्रीलाई विवाह नगरून् जो एउटी वेश्‍या हो र जो अपवित्र छे, र तिनीहरूले आफ्नो पतिबाट विच्‍छेद भएकी स्‍त्रीलाई विवाह नगरून् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","तैँले त्यसलाई अलग राख्‍नू, किनभने परमप्रभुलाई रोटी चढाउने त्यो नै हो । त्यो तेरो निम्ति पवित्र हुनुपर्छ, किनभने, तँलाई पवित्र तुल्‍याउने म परमप्रभु पवित्र छु । ");
INSERT INTO npiulb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","पुजारीकी छोरी जो वेश्‍या भएर आफैलाई अपवित्र बनाउछे, त्यसले आफ्नो बुबाको अपमान गर्छे । त्यो जलाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","आफ्ना दाजुभाइहरूका बिचमा प्रधान पुजारी भएको मानिस जसको शिरमा अभिषेकको तेल खन्‍याइएको छ, र प्रधान पुजारीको विशेष पोशाक लगाउनको निम्ति अर्पण गरी पवित्र गरिएको छ, त्यसले आफ्नो केश खुला नछोडोस् वा आफ्ना लुगाहरू नच्यातोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","आफ्नो बुबा वा आफ्नी आमा जो भए तापनि लाश भएको ठाउँमा त्यो नजाओस् र आफैलाई अपवित्र नबनाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","त्यो प्रधान पुजारी पवित्र स्थानबाट बाहिर ननिस्कोस् र त्यसले आफ्नो परमेश्‍वरको पवित्र स्थानलाई अशुद्ध नबनाओस्, किनभने त्यो आफ्नो परमेश्‍वरको अभिषेक गर्ने तेलद्वारा प्रधान पुजारीको रूपमा अर्पण गरिएको छ । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","प्रधान पुजारीले आफ्नी पत्‍नीको रूपमा कन्या केटी बिहे गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","त्यसले विधवा, विच्‍छेद भएकी स्‍त्री, वा वेश्‍या बिहे नगरोस् । यस्ता स्‍त्रीहरूलाई त्यसले बिहे नगरोस् । त्यसले आफ्नै मानिसहरूबाट एउटा कन्या केटी नै बिहे गरोस्, ");
INSERT INTO npiulb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ताकि त्यसले आफ्ना मानिसहरूका बिचमा आफ्ना छोराछोरीहरूलाई अशुद्ध नबनाओस्, किनभने त्यसलाई पवित्र बनाउने परमप्रभु म नै हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारूनलाई यसो भन्, ‘तेरा सारा वंशहरूभित्र तेरा उत्तराधिकारीहरूमा कुनै शारीरिक खोट छ भने, त्यसले आफ्नो परमेश्‍वरलाई भोजन अर्पण गर्न नजिक नआओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","शारीरिक खोट भएको मानिस परमप्रभुको नजिक नआओस्, जस्तै दृष्‍टिविहीन वा हिँड्न नसक्‍ने मानिस, विरूपित वा आकार विकृत भएको मानिस, ");
INSERT INTO npiulb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","हात वा खुट्टा बाँङ्गिएको मानिस, ");
INSERT INTO npiulb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","पछाडि ढाडमा मासुको डल्‍ला पलाएको मानिस, वा धेरै पातलो वा होचो मानिस, वा आँखामा खोट भएको मानिस, वा रोग लागेको, घाउ भएको, चर्मरोग लागेको, वा अन्डाकोष पिसिएको मानिस । ");
INSERT INTO npiulb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","पुजारी हारूनका उत्तराधिकारीहरूका बिचबाट शारीरिक खोट भएको कोही मानिस पनि परमप्रभुको निम्ति होमबलि अर्पण गर्नलाई नजिक नआओस् । शारीरिक खोट भएको मानिस आफ्नो परमप्रभुको रोटी अर्पण गर्न नजिक नआओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","परमेश्‍वरको अति पवित्र वा पवित्र भोजनबाट त्यसले खान मिल्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","तर, त्यो पर्दाभित्र प्रवेश नगरोस्, न त वेदीको नजिक आओस्, किनभने त्यसमा शारीरिक खोट छ, र त्यसले मेरो पवित्र स्थानलाई अशुद्ध नबनाओस्, किनभने तिनीहरूलाई पवित्र बनाउने परमप्रभु मै हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","यसैले मोशाले यी वचनहरू हारून, तिनका छोराहरू र इस्राएलका सारा मानिसहरूलाई सुनाए । ");
INSERT INTO npiulb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून र त्यसका छोराहरूलाई भन् कि इस्राएलका मानिसहरूले मेरो निम्ति अलग गरेका पवित्र कुराहरूबाट तिनीहरू टाढा रहून् । तिनीहरूले मेरो पवित्र नामलाई अपवित्र नबनाऊन् । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","तिनीहरूलाई भन्, ‘तिमीहरूका सारा वंशहरूभित्र तिमीहरूका कुनै उत्तराधिकारीहरूमध्ये कोही अशुद्ध भएको बेला परमप्रभुका निम्ति इस्राएलका मानिसहरूले अलग गरेका पवित्र कुराहरूको नजिक गयो भने, त्यो मेरो नजिकबाट बहिष्‍कृत होस् । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","हारूनका उत्तराधिकारीहरूमध्ये जसलाई छालाको सरुवा रोग लागेको छ, वा जसको शरीरबाट कुनै सङ्क्रामक कुरा बगिरहेको छ भने, त्यो शुद्ध नभएसम्म त्यसले परमप्रभुकहाँ अर्पण गरिएको बलिदानबाट केही पनि खानुहुँदैन । मरेको मानिस, वा वीर्यपात भइरहेको मानिसजस्तो अशुद्ध कुरालाई छुने, ");
INSERT INTO npiulb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","वा अशुद्ध बनाउने घस्रने पशु, वा अशुद्ध बनाउने कुनै मानिसलाई छुने, त्यो जस्तो किसिमको अशुद्धता भए तापनि, ");
INSERT INTO npiulb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","र कुनै अशुद्ध कुरालाई छुने पुजारी साँझसम्म अशुद्ध हुन्छ । त्यसले आफ्नो शरीर पानीले ननुहाएसम्म कुनै पवित्र कुरा नखाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","घाम अस्ताएपछि त्यो शुद्ध हुने छ । घाम अस्ताएपछि त्यसले पवित्र कुराहरूबाट खान मिल्छ, किनभने त्यो त्यसकै भोजन हो । ");
INSERT INTO npiulb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","मरेको वा वन पशुद्वारा मारिएको कुनै कुरा त्यसले नखाओस् । त्यसबाट त्यो अशुद्ध हुन्छ । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","पुजारीहरूले मेरा निर्देशनहरू पालन गरून्, नत्रता तिनीहरू पापको दोषी हुने छन् र मलाई अपवित्र तुल्याएको कारण तिनीहरू मर्न सक्छन् । तिनीहरूलाई पवित्र बनाउने परमप्रभु म नै हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","पुजारीको परिवारमा कुनै बाहिरको मान्छे, पुजारीका पाहुनाहरू वा त्यसका ज्यालामा काम गर्ने नोकरहरू कसैले पनि पवित्र कुरा नखाऊन् । ");
INSERT INTO npiulb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","तर पुजारीले आफ्नै पैसाले किनेको दासले परमप्रभुका निम्ति अलग गरिएका कुराहरूबाट खान सक्छ । पुजारीका परिवारका सदस्यहरू र त्यसको घरमा जन्मेका दासहरूले पनि त्योसँगै ती कुराहरूबाट खान सक्‍ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","यदि पुजारीकी छोरीले पुजारीसँग बिहे नगरेर कोही अरूसँग बिहे गर्‍यो भने त्यसले अर्पण गरिएका पवित्र बलिदानहरूबाट नखाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","तर पुजारीकी छोरी विधवा, वा विच्‍छेद भएकी स्‍त्री हो, र त्यसको बालबच्‍चा छैन, र त्यो आफ्नो जवानीमा झैँ आफ्नै बुबाको घरमा बसोबास गर्न फर्की भने, त्यसले आफ्नो बुबाको भोजनबाट खान सक्छे । तर पुजारीको परिवारको सदस्य नभएको कसैले पनि पुजारीको भोजनबाट नखाओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","यदि कुनै मानिसले थाहा नपाई पवित्र भोजनबाट खायो भने, त्यसले त्यसको निम्ति पुजारीलाई दाम तिरोस्; त्यसले त्यसमा पाँचौँ भाग थपेर पुजारीलाई फिर्ता गरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","डोलाएर परमप्रभुलाई अर्पण गरिएका पवित्र कुराहरूलाई इस्राएलका मानिसहरूले अपवित्र नगरून्, ");
INSERT INTO npiulb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","नत्रता तिनीहरूले पाप बोक्‍ने छन् र पवित्र भोजन खाएको कारण तिनीहरू दोषी हुने छन्, किनभने तिनीहरूलाई पवित्र बनाउने परमप्रभु म नै हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून र त्यसका छोराहरू, र इस्राएलका सारा मानिसहरूलाई यसो भन्, ‘कुनै इस्राएली, वा इस्राएलमा बसोबास गर्ने परदेशीले बलिदान अर्पण गर्दा चाहे त्यो कुनै भाकल पुरा गर्न होस्, वा त्यो स्वेच्‍छा भेटी होस्, वा तिनीहरूले परमप्रभुलाई होमबलि अर्पण गर्दा, ");
INSERT INTO npiulb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","तिनीहरूले गाई-गोरू, भेडा, वा बाख्राहरूमध्ये निष्‍खोट भाले अर्पण गरोस्, अनि त्यो स्वीकारिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","तर खोट भएको कुनै कुरा पनि अर्पण नगर्नू । म त्यो तिमीहरूबाट स्वीकार्ने छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","कसैले आफ्नो भाकल पुरा गर्न, वा स्वेच्‍छा भेटीस्वरूप बथान वा बगालबाट परमप्रभुको निम्ति मेलबलि चढाउँछ भने, त्यो निष्‍खोट होस्, अनि त्यो स्वीकारिने छ । त्यो पशुमा कुनै पनि खोट हुनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","अन्धा, चोट भएका, अङ्गभङ्ग भएका, मूसा वा पाकेको घाउ भएका, वा चिलाउने रोग भएका पशु तिमीहरूले अर्पण नगर्नू । तिमीहरूले परमप्रभुको निम्ति वेदीमा होमबलिद्वारा यी अर्पण नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","अङ्गभङ्ग भएको वा सानो साँढे वा भेडाचाहिँ तिमीहरूले स्वेच्‍छा भेटीस्वरूप अर्पण गर्न सक्छौ, तर भाकलको निम्ति त्यसको भेटी ग्रहण हुने छैन । ");
INSERT INTO npiulb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","चोट लागेका, कुच्‍च्याइएका, चिरिएका, वा काटिएका अण्डकोष भएका पशु परमप्रभुलाई अर्पण नगर्नू । तिमीहरूको देशैभरि त्यस्तो नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","परदेशीको हातबाट तिमीहरूका परमेश्‍वरको भोजन अर्पण नगर्नू । अङ्गभङ्ग भएका वा खोट भएका पशुहरू, तिमीहरूका निम्ति ग्रहण हुने छैनन्’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“बाछा वा भेडा वा बाख्रा जन्मिँदा त्यो त्यसको माउसँग सात दिन रहोस् । आठौँ दिनबाट परमप्रभुको निम्ति होमबलि अर्पण गर्नलाई त्यो स्वीकारिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","गाई वा भेडीलाई एकै दिनमा त्यसको बच्‍चासमेत नमार्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","तिमीहरूले परमप्रभुलाई धन्यवादको बलि अर्पण गर्दा तिमीहरूले त्यो स्वीकारयोग्‍य तरिकामा बलि गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","त्यसलाई त्यो बलि गरिएकै दिनमा खानू । अर्को बिहानीसम्म त्यसको केही भाग पनि नछोड्‍नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","यसैकारण तिमीहरूले मेरा आज्ञा मान्‍नू र तीअनुसार हिँड्नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","तिमीहरूले मेरो पवित्र नाउँलाई अपवित्र नतुल्याउनू । इस्राएलका मानिसहरूले म पवित्र छु भन्‍ने कुरा स्वीकारून् । तिमीहरूलाई पवित्र बनाउने परमप्रभु म नै हुँ, ");
INSERT INTO npiulb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","र मैले नै तिमीहरूका परमेश्‍वर हुनको निम्ति तिमीहरूलाई मिश्र देशबाट बाहिर ल्याएँ । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलका मानिसहरूलाई भन्, ‘परमप्रभुका निम्ति तोकिएका चाडहरू यी नै हुन्, जसलाई तिमीहरूले पवित्र सभाको रूपमा घोषणा गर्नू । यी मेरा नियमित चाडहरू हुन् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","तिमीहरू छ दिनसम्म काम गर्न सक्छौ, तर सातौँ दिनचाहिँ पूर्ण विश्रामको शबाथ अर्थात् पवित्र सभा हो । तिमीहरू बसोबास गर्ने कुनै पनि ठाउँमा काम नगर्नू किनभने त्यो परमप्रभुको निम्ति शबाथ हो । ");
INSERT INTO npiulb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","परमप्रभुका निम्ति तोकिएका चाडहरू यी नै हुन्, पवित्र सभाहरू जसलाई तिमीहरूले तिनीहरूका तोकिएका समयमा घोषणा गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","पहिलो महिनाको चौधौँ दिनको साँझ परमप्रभुको निस्तार-चाड हो । ");
INSERT INTO npiulb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","सोही महिनाको पन्ध्रौँ दिन परमप्रभुको निम्ति अखमिरी रोटीको चाड हो । सात दिनसम्म तिमीहरूले अखमिरी रोटी खानू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","पहिलो दिनलाई तिमीहरूले भेला हुनको निम्ति छुट्‍ट्याउनू, र त्यस दिन तिमीहरूका कुनै पनि दैनिक काम नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","तिमीहरूले सात दिनसम्म परमप्रभुको निम्ति भोजनको भेटी अर्पण गर्ने छौ । सातौँ दिनचाहिँ परमप्रभुको निम्ति अलग गरिएको सभाको दिन हो, र त्यस दिन तिमीहरूले आफ्ना कुनै पनि दैनिक काम नगर्नू’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","परमप्रभु मोशासँग यसरी बोल्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलका मानिसहरूलाई यसो भन्, ‘मैले तिमीहरूलाई दिन लागेको देशमा तिमीहरू पुगेर त्यहाँ फसलको कटनी गरेपछि तिमीहरूले बालीको पहिलो फलको एक बिटा पुजारीकहाँ ल्याउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","त्यसले त्यो बालीको बिटालाई परमप्रभुको अगि डोलाउने छ र तिमीहरूका निम्ति त्यो स्वीकारियोस् भनेर त्यसले त्यो उहाँलाई अर्पण गर्ने छ । शबाथपछिको दिनमा पुजारीले त्यो डोलाएर मलाई अर्पण गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","बालीको बिटालाई डोलाएर मलाई अर्पण गर्ने दिनमा एक वर्षको निष्‍खोट थुमा होमबलिको रूपमा परमप्रभुलाई चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","अन्‍नबलिचाहिँ परमप्रभुको निम्ति मिठो सुगन्ध दिनको निम्ति होमबलिको रूपमा तेलसँग मुछिएको एक पाथी मसिनो पिठो होस्, र अर्घबलिचाहिँ एक लिटर दाखमद्य होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","यो बलि तिमीहरूले आफ्नो परमेश्‍वरकहाँ नल्याउने दिनसम्म तिमीहरूले रोटी, भुटेको अन्‍न वा हरियो अनाज केही नखानू । तिमीहरू बसोबास गर्ने हरेक ठाउँमा तिमीहरूका मानिसहरूको सबै वंशमा यो सदाको निम्ति विधि होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","शबाथ दिन अर्थात् डोलाउने बलिको रूपमा तिमीहरूले बालीको बिटा ल्याएको दिनपछि पुरै सात हप्‍ता गन्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातौँ शबाथको पचास दिन तिमीहरूले गन्‍नू । त्यसपछि तिमीहरूले परमप्रभुलाई नयाँ अन्‍नको बलि चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तिमीहरूका घरहरूबाट एक पाथी पिठोबाट बनेका दुईवटा रोटी ल्याउनू । त्यो मसिनो पिठो खमिर राखेर बनाइयोस् । ती परमप्रभुको निम्ति पहिलो फलको डोलाइने बलि हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","रोटीसँगै तिमीहरूले एक वर्षे निष्‍खोट सातवटा थुमा, एउटा साँढेको बच्‍चा, र दुईवटा भेडा अर्पण गर्नू । तिनीहरूको अन्‍नबलि र अर्घबलिसँगै ती परमप्रभुको निम्ति मिठो सुगन्ध दिने होमबलि होऊन् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","तिमीहरूले पापबलिको निम्ति एउटा बोका, र मेलबलिको निम्ति एक वर्षे दुईवटा थुमा बलिदानको निम्ति अर्पण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","पहिलो फलको रोटीसँगै परमप्रभुको निम्ति पुजारीले ती डोलाओस्, र दुईवटा थुमासँगै ती बलिदानस्वरूप अर्पण गरोस् । ती पुजारीको निम्ति परमप्रभुलाई अर्पण गरिएको पवित्र बलिदान हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","त्यही दिन तिमीहरूले घोषणा गर्नू । त्यहाँ पवित्र सभा हुने छ, र तिमीहरूले गर्ने दैनिक काम नगर्नू । तिमीहरू बसोबास गर्ने सबै ठाउँमा तिमीहरूको वंशमा यो सदाको निम्ति विधि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","तिमीहरूले आफ्नो भूमिको फसल कटनी गर्दा आफ्ना भूमिको कुना-कुनामा कटनी नगर्नू, र आफ्नो फसलको शिला-बाला नबटुल्‍नू । ती तिमीहरूले गरिब र परदेशीका निम्ति छोडिदिनू । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलका मानिसहरूलाई भन्, ‘सातौँ महिनाको पहिलो दिन तिमीहरूका निम्ति पवित्र विश्रामको दिन हुने छ, र त्यो दिन तुरही फुकेर सम्झना गरिने छ र पवित्र सभा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","तिमीहरूले आफ्ना दैनिक काम नगर्नू, र तिमीहरूले परमप्रभुका निम्ति आगोद्वारा बलि अर्पण गर्नू’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","अनि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“सातौँ महिनाको दसौँ दिन प्रायश्‍चित्तको दिन हो । त्यस बेला एउटा पवित्र सभा होस्, र तिमीहरूले आफैलाई नम्र बनाएर परमप्रभुको निम्ति आगोद्वारा बलि अर्पण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","त्यस दिन तिमीहरूले काम नगर्नू, किनभने परमप्रभु तिमीहरूका परमेश्‍वरको अगि आफ्नै निम्ति प्रायश्‍चित्त गर्नलाई त्यो दिन प्रायश्‍चित्तको दिन हो । ");
INSERT INTO npiulb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","त्यस दिन आफैलाई नम्र नबनाउने मानिस आफ्ना मानिसहरूबाट बहिष्‍कृत होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","त्यस दिन कुनै पनि काम गर्ने मानिसलाई म परमप्रभुले नै त्यसका मानिसहरूका बिचमा नष्‍ट गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तिमीहरूले त्यस दिन कुनै पनि प्रकारको काम नगर्नू । तिमीहरू बसोबास गर्ने सबै ठाउँमा तिमीहरूका मानिसहरूका सबै वंशमा सदाको निम्ति यो विधि बनोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यो दिन तिमीहरूका निम्ति पवित्र विश्रामको शबाथ होस्, र त्यस महिनाको नवौँ दिनको साँझ तिमीहरूले आफैलाई नम्र बनाउनू । अर्को दिनको साँझसम्म तिमीहरूले शबाथ मान्‍नू ।” ");
INSERT INTO npiulb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलका मानिसहरूलाई भन्, ‘सातौँ महिनाको पन्ध्रौँ दिन परमप्रभुको निम्ति छाप्रो-बासको चाड हुने छ । त्यो सात दिनसम्म रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिलो दिनमा पवित्र सभा होस् । तिमीहरूले आफ्ना दैनिक काम नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","सात दिनसम्म परमप्रभुलाई आगोद्वारा बलिदान अर्पण गर्नू । आठौँ दिनमा पवित्र सभा होस्, र तिमीहरूले परमप्रभुको निम्ति आगोद्वारा बलिदान अर्पण गर्नू । यो एउटा पवित्र सभा हो, र तिमीहरूले आफ्ना दैनिक काम नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","यी परमप्रभुका निम्ति तोकिएका चाडहरू हुन्, जसलाई तिमीहरूले आगोद्वारा गरिने बलिदान, होमबलि र अन्‍नबलि, बलिदानहरू र अर्घबलिहरू आ-आफ्नै दिनमा अर्पण गर्नको निम्ति पवित्र सभाहरू भनेर घोषणा गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","परमप्रभुका निम्ति शबाथ, र तिमीहरूले परमप्रभुलाई दिने तिमीहरूका उपहारहरू, तिमीहरूका भाकलहरू, र तिमीहरूका सबै स्वेच्छा भेटीहरू बाहेक यी चाडहरू हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","छाप्रो-बासको चाडको सम्बन्धमा, सातौँ महिनाको पन्ध्रौँ दिनमा तिमीहरूले भूमिबाट फसल बटुलिसकेपछि तिमीहरूले परमप्रभुको यो चाडलाई सात दिनसम्म मान्‍नू । पहिलो दिन पवित्र विश्राम हुने छ, र आठौँ दिन पनि पवित्र विश्राम हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिलो दिनमा तिमीहरूले रुखहरूबाट उत्तम फल, खजुरका हाँगाहरू, र धेरै पात भएका हाँगाहरू, र लहरे-पीपलका हाँगाहरू लिनू, र सात दिनसम्म परमप्रभु तिमीहरूका परमेश्‍वरको सामु आनन्द मनाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","हरेक वर्ष सात दिनसम्म तिमीहरूले परमप्रभुको निम्ति यो चाड मनाउनू । तिमीहरू बसोबास गर्ने सबै ठाउँमा तिमीहरूका मानिसहरूका सबै वंशमा सदाको निम्ति यो एउटा विधि होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तिमीहरू सात दिनसम्म स-साना छाप्रोमा बस्‍नू । इस्राएलमा जन्मेका सबै जना सात दिनसम्म स-साना छाप्रोमा बसून्, ");
INSERT INTO npiulb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ताकि तिमीहरूका वंशले पुस्तौँ-पुस्तासम्म यो जानून्, कि मैले इस्राएलका मानिसहरूलाई मिश्र देशबाट बाहिर ल्याउँदा तिनीहरूलाई कसरी यी स-साना छाप्राहरूमा बस्‍न लगाएँ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","यसरी मोशाले परमप्रभुका निम्ति तोकिएका चाडहरूबारे इस्राएलका मानिसहरूलाई घोषणा गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलका मानिसहरूलाई बत्तीमा प्रयोग गरिनको निम्ति जैतूनलाई पिसेर शुद्ध तेल ल्याउनू भनेर भन्, ताकि बत्ती निरन्तर बलिरहोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","भेट हुने पालमा गवाही पर्दादेखि बाहिर परमप्रभुको सामु हारूनले साँझदेखि बिहानसम्म त्यो बत्ती बालिराखोस् । तिमीहरूका मानिसहरूको सारा वंशमा सदाको निम्ति यो एउटा विधि बनोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","प्रधान पुजारीले शुद्ध सुनको पानसमा भएका बत्तीहरू बालिराखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","तैँले मसिनो पिठो लिएर बाह्रवटा रोटी बनाउनू । हरेक रोटीमा एक पाथी पिठो होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","त्यसपछि परमप्रभुको अगि शुद्ध सुनको टेबुलमाथि छ-छवटा गरी ती दुई ताँतीमा राख्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","रोटीहरूका दुवै ताँतीमा सम्झनाको भेटीस्वरूप शुद्ध धूप राख्‍नू । यही धूप परमप्रभुको निम्ति होमबलि हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","हरेक शबाथ दिनमा अनन्तको करारको चिन्हस्वरूप इस्राएलका मानिसहरूको खातिर प्रधान पुजारीले परमप्रभुको अगि त्यो रोटी राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","यो भेटी हारून र त्यसका छोराहरूका निम्ति हुने छ, र तिनीहरूले त्यो कुनै पवित्र ठाउँमा खाऊन्, किनभने त्यो परमप्रभुका निम्ति होमबलिको भेटीको भाग हो ।” ");
INSERT INTO npiulb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","एउटी इस्राएली स्‍त्रीको छोरा जसको बुबा एक मिश्री थियो, त्यो इस्राएलका मनिसहरूका बिचमा गयो । छाउनीमा त्यस इस्राएली स्‍त्रीको छोरा एउटा इस्राएली पुरुषसँग झगडा गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","इस्राएली स्‍त्रीको छोराले परमप्रभुको नाउँको निन्दा गर्‍यो र परमेश्‍वरलाई सराप्‍यो । यसैकारण मानिसहरूले त्यसलाई मोशाकहाँ ल्याए । त्यसकी आमाको नाम शलोमीत थियो जो दानका कुलको दिब्रीकी छोरी थिई । ");
INSERT INTO npiulb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","परमप्रभु आफैले तिनीहरूलाई आफ्नो इच्‍छा नबताउनुभएसम्म तिनीहरूले त्यसलाई बन्दी बनाएर राखे । ");
INSERT INTO npiulb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“परमेश्‍वरलाई सरापेको मानिसलाई छाउनीबाट बाहिर निकाल् । त्यसको कुरा सुनेका सबैले आफ्ना हात त्यसको टाउकोमाथि राखून्, र त्यसपछि जम्‍मै समुदायले त्यसलाई ढुङ्गाले हानून् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","इस्राएलका मानिसहरूलाई तैँले यसरी सम्झाउनू, ‘आफ्ना परमेश्‍वरलाई सराप्‍नेले आफ्नो दोष आफै बोकोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","परमप्रभुको नाउँको निन्दा गर्ने मानिस मारियोस् । त्यो इस्राएलमा जन्मेको स्वदेशी वा परदेशी जो भए तापनि जम्मै समुदायले त्यसलाई ढुङ्गाले हानून् । परमप्रभुको नाउँको निन्दा गर्ने मानिस निश्‍चय नै मारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","यदि कसैले कोही अर्को मानिसलाई हिर्काएर मार्‍यो भने, त्यो निश्‍चय नै मारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","यदि कसैले अर्काको पशुलाई हानेर मार्‍यो भने, त्यसले प्राणको साटो प्राण नै भर्ना दिओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","यदि कसैले आफ्नो छिमेकीलाई घाइते बनायो भने, त्यसले आफ्नो छिमेकीलाई जे गरेको थियो त्यसलाई पनि त्यही गरियोस्, ");
INSERT INTO npiulb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","चोटको साटो चोट, आँखाको साटो आँखा, दाँतको साटो दाँत । त्यसले अर्को मानिसलाई घाइते बनाएको कारण त्यसलाई पनि त्यस्तै गरियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","जसले कुनै पशुलाई मार्छ त्यसले त्यसको भर्ना तिरोस्, र जसले अर्को मानिसलाई मार्छ त्यो मारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","परदेशी र स्वदेशमै जन्मिएको इस्राएली दुवैका निम्ति नियम एउटै होस्, किनभने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","यसैकारण मोशाले इस्राएलका मानिसहरूलाई यी कुरा बताए, र ती मानिसहरूले परमप्रभुलाई सरापेको मानिसलाई छाउनीबाट बाहिर निकाले । तिनीहरूले त्यसलाई ढुङ्गाले हाने । इस्राएलका मानिसहरूले परमप्रभुले मोशालाई दिनुभएको आज्ञाको पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","परमप्रभुले मोशालाई सीनै पर्वतमा भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलका मानिसहरूलाई भन्, ‘मैले तिमीहरूलाई दिने देशमा पुगेपछि परमप्रभुको निम्ति भूमिले पनि शबाथ मानोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","तिमीहरूले छ वर्षसम्म आफ्नो भूमिमा बाली लगाउनू, र छ वर्षसम्म आफ्नो दाखबारी छिँवल्‍नू र फसल बटुल्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","तर सातौँ वर्षमा परमप्रभुको निम्ति भूमिले पनि पवित्र शबाथ मानोस् । आफ्नो भूमिमा बाली नलगाउनू वा आफ्नो दाखबारी नछिँवल्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","आफै उम्रेको फसल वा नछिँवलेको बोटबाट दाखको कटनी नगर्नू । योचाहिँ भूमिको निम्ति एक वर्षका लागि पवित्र विश्राम होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","शबाथको वर्षमा खन-जोत नगरिएको भूमिले जे उब्जाउँछ त्यो नै तिमीहरूका निम्ति भोजन हुने छ । तिमीहरू, तिमीहरूका कमारा-कमारीहरू, तिमीहरूले ज्यालामा काममा लगाएका नोकरहरू र तिमीहरूसँग बसोबास गर्ने परदेशीहरूले ती भोजन बटुल्‍न सक्छन्, ");
INSERT INTO npiulb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","र तिमीहरूका गाईवस्तु, र जङ्गली पशुहरूले पनि भूमिले जे उब्जाउँछ त्यही खाने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","तिमीहरूले आफ्नो लागि सात शबाथका वर्षहरू अर्थात् सात गुणा सात वर्ष गरी उनन्‍चास वर्ष गन्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","त्यसपछि सातौँ महिनाको दसौँ दिनमा तिमीहरूले सबै ठाउँमा ठुलो आवाजमा तुरही बजाउनू । प्रायश्‍चित्तको दिनमा तिमीहरूले आफ्ना सारा भूमिभरि तुरही बजाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","तिमीहरूले पचासौँ वर्ष परमप्रभुका निम्ति अलग गर्नू र सारा भूमिमा सबै बासिन्दाहरूबिच स्वतन्त्रताको घोषणा गर्नू । यो तिमीहरूका निम्ति पुनर्स्थापनाको वर्ष होस्, जुन वर्ष सम्पत्ति र दास तिनीहरूका परिवारहरूमा फिर्ता गरिने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","पचासौँ वर्ष तिमीहरूका निम्ति पुनर्स्थापनाको वर्ष हुने छ । तिमीहरूले बाली नलगाउनू र कटनी पनि नगर्नू । आफै उम्रेका, र नछिँवलेका बोटहरूका दाखहरू तिमीहरूले खानू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","यो पुनर्स्थापनाको वर्ष भएको हुनाले यो तिमीहरूका निम्ति पवित्र हुने छ । भूमिमा आफै उम्रेका कुराहरू तिमीहरूले खानू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","पुनर्स्थापनाको वर्षमा सबैलाई आफ्नै जग्‍गाजमिनमा फर्काउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","तिमीहरूले आफ्नो छिमेकीलाई आफ्नो जग्‍गा बेच्‍दा वा आफ्नो छिमेकीबाट जग्‍गा किन्दा तिमीहरूले एक-अर्कालाई धोका नदिनू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","आफ्नो छिमेकीबाट जग्‍गा किन्दा अर्को पुनर्स्थापनाको वर्षसम्ममा कटनी गर्न सकिने वर्षहरू र बालीहरूलाई ध्यानमा राख्‍नू । जग्‍गा बेच्‍न लागेका तिमीहरूका छिमेकीले पनि यो कुरा ध्यानमा राखोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","अर्को पुनर्स्थापनाको वर्षसम्म जति धेरै वर्ष बाँकी रहन्छ त्यति नै जग्‍गाको मूल्य बढी हुने छ, र अर्को पुनर्स्थापनाको वर्षसम्म जति थोरै वर्ष बाँकी रहन्छ त्यति नै जग्‍गाको मूल्य कम हुने छ, किनभने नयाँ मालिकको निम्ति कटनीको सङ्ख्या अर्को पुनर्स्थापनाको वर्ष आउन बाँकी वर्षहरूमा आधारित हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","तिमीहरूले एक-अर्कालाई धोका नदिनू, बरु तिमीहरूले आफ्ना परमेश्‍वरको मान गर्नू, किनभने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","यसैले तिमीहरूले मेरा आज्ञाहरू मान्‍नू, मेरा नियमहरू पालन गर्नू र तीअनुसार चल्‍नू । अनि तिमीहरू आफ्नो देशमा सुरक्षित भई जिउने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","भूमिले आफ्नो उब्जनी दिने छ, र तिमीहरूले प्रशस्‍त मात्रामा खाने छौ र त्यहाँ सुरक्षित भएर जिउने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","तिमीहरूले भनौला, “सातौँ वर्षमा हामीले के खाने छौँ? हेर्नुहोस्, हामीले न त बाली लगाउन सक्छौँ, न फसल कटनी गर्न सक्छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","छैटौँ वर्षमा तिमीहरूमाथि म मेरो आशिष् बर्साउने छु, र भूमिले तिन वर्षसम्म पुग्‍ने फसल उब्जाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","आठौँ वर्षमा तिमीहरूले बाली लगाउने छौ र तिमीहरूले अगिल्लो वर्षको उब्जनी र भण्डार गरिएको उब्जनीबाट नै खानू । नवौँ वर्षको कटनी गरिएको फसल नआउँदासम्म अगिल्ला वर्षहरूमा भण्डार गरिएका उब्जनीहरूबाट तिमीहरूले खान सक्‍ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","कोही नयाँ स्थायी मालिकलाई भूमि नबेच्‍नू, किनभने त्यो भूमि मेरो हो । तिमीहरू सबै परदेशीहरू हौ र मेरो भूमिका अस्थायी बासिन्दाहरू हौ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","तिमीहरूले हासिल गरेका सबै जग्‍गाको निम्ति छुटकाराको अधिकार दिनू; तिमीहरूले जुन परिवारबाट जग्‍गा किन्यौ त्यही परिवारलाई त्यो जग्‍गा किन्‍ने मौका दिनू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","यदि तिमीहरूको कोही सङ्गी-इस्राएली गरिब भयो र त्यसले गरिबीको कारण आफ्नो केही सम्पत्ति बेच्‍यो भने, त्यसको सबैभन्दा नजिकको नातेदार आएर त्यसले तिमीहरूलाई बेचेको सम्पत्ति पुनः किन्‍न सक्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","यदि त्यो सम्पत्तिलाई फुकाउनको निम्ति त्यसको कुनै नातेदार छैन, तर त्यो फेरि धनाढ्य भयो र त्यो फुकाउने क्षमता त्योसँग भयो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","त्यसले त्यो जग्‍गा बेचेपछि बितेका वर्षहरू गनोस् र त्यसले जुन मानिसलाई त्यो जग्‍गा बेचेको थियो त्यसलाई बाँकी रकम तिरोस् । त्यसपछि त्यो आफ्नै जग्‍गाजमिनमा फर्कन सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","तर यदि त्यसले आफ्नो लागि त्यो जग्‍गा फिर्ता लिन सकेन भने, त्यसले बेचेको जग्‍गा पुनर्स्थापनाको वर्षसम्म जग्‍गा किन्‍ने मानिसको स्वामित्वमा हुने छ । पुनर्स्थापनाको वर्षको अन्त्यमा जग्‍गा बेच्‍ने मानिसकहाँ नै त्यो जग्‍गा फर्काइन्छ, र त्यसको जग्‍गाधनी आफ्नै जग्‍गाजमिनमा फर्कने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","यदि कुनै मानिसले पर्खाल लगाएको सहरभित्र घर बेच्‍छ भने, त्यसले त्यो बेचेको एक वर्षभित्र त्यो फेरि किन्‍न सक्‍ने छ । एक वर्षसम्म त्योसँग छुटकाराको अधिकार हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","यदि एक वर्षसम्म त्यसले त्यो घर फुकाउन सकेन भने, पर्खाल लगाएको सहरभित्रको घर, खरिद गर्ने मानिस र त्यसका वंशको स्थायी सम्पत्ति हुने छ । त्यो पुनर्स्थापनाको वर्षमा फिर्ता गर्नुपर्दैन । ");
INSERT INTO npiulb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","तर गाउँका घरहरू जसका वरिपरि कुनै पर्खाल छैन, त्यसलाई जग्‍गासरह मानिने छ । ती फुकाउन सकिने छ, र पुनर्स्थापनाको वर्षमा ती फिर्ता गर्नुपर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","तथापि, लेवीहरूले आफ्ना सहरहरूमा आफ्नो अधिकार गरेका घरहरू भने जुनसुकै समयमा पनि फुकाउन सकिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","यदि लेवीहरूमध्ये कसैले आफूले बेचेको घर फुकाएन भने, सहरमा बेचिएको घर पुनर्स्थापनाको वर्षमा फिर्ता गरिनुपर्ने छ, किनभने इस्राएलका मानिसहरूमध्ये लेवीहरूका सहरहरूभित्र भएका घरहरू तिनीहरूको सम्पत्ति हो । ");
INSERT INTO npiulb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","तर तिनीहरूका सहरहरू वरिपरि भएका भूमिहरू नबेच्‍नू किनभने ती लेवीहरूका स्थायी सम्पत्ति हुन् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","यदि तिमीहरूका सङ्गी-नागरिक गरिब भएर आफ्नो हेरचाह गर्न सकेन भने, तिमीहरूले जसरी कुनै परदेशीलाई वा तिमीहरूका बिचमा कतै बाहिरबाट आएर बसोबास गरेका मानिसहरूलाई सहयोग गर्छौ, त्यसरी नै त्यसलाई सहयोग गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","त्यसलाई ब्याज नलगाउनू वा त्यसबाट कुनै किसिमको फाइदा नलिनू, आफ्ना परमेश्‍वरको आदर गर्नू ताकि तेरो भाइ तँसँगै बसोबास गर्न सकोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तिमीहरूले त्यसलाई ब्याजमा ऋण नदिनू, न त नाफा कमाउनको निम्ति आफ्नो भोजन त्यसलाई बेच्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","तिमीहरूलाई कनान देश दिन र तिमीहरूका परमेश्‍वर हुनको निम्ति तिमीहरूलाई मिश्र देशबाट निकालेर ल्याउने परमप्रभु तिमीहरूका परमेश्‍वर म नै हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","यदि तिमीहरूको सङ्गी-नागरिक गरिब भयो र त्यसले आफैलाई तिमीहरूकहाँ बेच्‍यो भने, त्यसलाई दासलाई झैँ काममा नलगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","त्यसलाई ज्यालामा राखिएको नोकरझैँ व्यवहार गर्नू । तिमीहरूका बिचमा अस्थायी रूपमा बसोबास गर्ने मानिसझैँ त्यो हुने छ । पुनर्स्थापनाको वर्षसम्म त्यसले तिमीहरूको सेवा गर्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","त्यसपछि त्यो र त्यसका छोराछोरीहरू तिमीहरूबाट पर आफ्नै परिवार र आफ्नै पिताको सम्पत्तिमा फर्किजाने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","किनभने तिनीहरू मेरा नोकरहरू हुन् जसलाई मैले मिश्रदेशबाट बाहिर ल्याएँ । तिनीहरू दासहरूझैँ बेचिने छैनन् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तिमीहरूले त्यसमाथि कठोर रूपमा शासन नगर्नू, तर तिमीहरूले आफ्नो परमेश्‍वरको मान गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","तिमीहरूका वरिपरि बसोबास गर्ने जातिहरूबाट दास-दासीहरू तिमीहरूले प्राप्‍त गर्न सक्‍यौ भने, तिमीहरूले तिनीहरूबाट दासहरू किन्‍न सक्‍ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तिमीहरूका बिचमा बसोबास गर्ने परदेशीहरूबाट, तिमीहरूसँग भएका तिनीहरूका परिवारहरूबाट, र तिमीहरूको भूमिमा जन्मेका तिनीहरूका छोराछोरीहरूबाट पनि तिमीहरूले दासहरू किन्‍न सक्छौ । तिनीहरू तिमीहरूको सम्पत्ति बन्‍न सक्छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तिमीहरूले त्यस्ता दासहरूलाई आफ्ना छोराछोरीहरूका निम्ति तिमीहरूपछि सम्पत्तिको रूपमा प्राप्‍त गर्न र सारा जीवनभर तिनीहरूलाई दास बनाउन उत्तराधिकारको रूपमा दिन सक्छौ, तर इस्राएलका मानिसहरूका बिचमा आफ्ना भाइहरूलाई तिमीहरूले कठोर रूपमा शासन नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","यदि कुनै परदेशी वा तिमीहरूका बिचमा अस्थायी रूपमा बसोबास गर्ने मानिस धनी भयो, र तिमीहरूमध्येको कुनै एउटा सङ्गी-इस्राएली गरिब भएर त्यसले आफैलाई त्यो परदेशी वा त्यस परदेशीको परिवारमा कसैकहाँ आफैलाई बेच्‍यो भने, ");
INSERT INTO npiulb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तिमीहरूको सङ्गी-इस्राएली किनिसकेपछि त्यसलाई पुनः किनेर फुकाउन सकिने छ । परिवारमा कसैले त्यसलाई छुटकारा दिन सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","त्यस मानिसको काका, वा काकाको छोरा, वा त्यसको परिवारको कोही नजिकको नातेदारले त्यसलाई छुटाउन सक्‍ने छ । वा त्यो धनाढ्य भएको छ भने, त्यसले आफैलाई छुटाउन सक्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","त्यसलाई किनेको मानिससँग त्यसले मोल-तोल गरोस्, र त्यसले आफैलाई त्यो खरिद गर्ने मानिसकहाँ बेचेको वर्षदेखि पुनर्स्थापनाको वर्षसम्म कति वर्ष हुने रहेछ भनेर तिनीहरूले गनून् । त्यसलाई किन्‍ने मानिसकहाँ त्यसले जति वर्ष काम गरिरहने छ, ती वर्षहरूका निम्ति कुनै ज्यालामा राखिने नोकरलाई तिरिने दरलाई ध्यानमा राखी त्यसको छुटकाराको मोल तय गरियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","पुनर्स्थापनाको वर्ष आउन अझै धेरै वर्ष बाँकी छ भने, ती वर्षहरूका आधारमा आफ्नो छुटकाराको रकम तिरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","यदि पुनर्स्थापनाको वर्ष आउन थोरै मात्र समय रहेको छ भने, पुनर्स्थापनाको वर्ष आउनअगि बाँकी रहेका वर्षहरू त्यसलाई खरिद गर्नेसँग त्यसले मोल-तोल गरोस्, र ती वर्षहरूअनुसार त्यसले आफ्नो छुटकाराको निम्ति तिरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","वर्ष-वर्षको निम्ति ज्यालामा लगाइएको मानिसझैँ त्यससँग व्यवहार गर्नू । त्यसलाई कठोरतासाथ व्यवहार नगर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","यी तरिकाहरूबाट त्यसको छुटकारा हुन सकेन भने, त्यो र त्यसका छोराछोरीहरूले पुनर्स्थापनाको वर्षसम्म सेवा गरून् । ");
INSERT INTO npiulb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","मेरो निम्ति इस्राएलका मनिसहरू नोकरहरू हुन् । यिनीहरू मेरा नोकरहरू हुन् जसलाई मैले मिश्र देशबाट बाहिर निकालेर ल्याएँ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“तिमीहरूले मूर्तिहरू नबनाउनू, र आफ्नो निम्ति कुनै खोपिएको मूर्ति वा प्रतिमूर्ति खडा नगर्नू, र आफ्नो भूमिमा खोपिएको ढुङ्गाको प्रतिमूर्ति बनाएर त्यसलाई दण्डवत् नगर्नू, किनभने म परमप्रभु तिमीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","तिमीहरूले मेरो शबाथ मान्‍नू र मेरो पवित्रस्थानको आदर गर्नू । म परमप्रभु हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","यदि तिमीहरू मेरा नियमहरूअनुसार हिँड्यौ र मेरा आज्ञाहरू पालन गरेर तीअनुसार चल्यौ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","म तिमीहरूलाई ठिक मौसममा झरी दिने छु, र भूमिले आफ्नो उब्जनी दिने छ, र भूमिका रुखहरूले आफ्ना फल दिने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","दाख बटुल्‍ने समयसम्मै तिमीहरूले दाइँ गर्ने छौ, र रोपाइँको समयसम्मै दाख बटुल्‍ने छौ । तिमीहरूले भरपेट रोटी खाने छौ र भूमिमा तिमीहरूले जहाँ आफ्नो घर बसाल्छौ त्यहाँ सुरक्षितसाथ जिउने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","म देशमा शान्ति ल्याउने छु, र तिमीहरू कुनै डरविना नै निदाउने छौ । म तिमीहरूका देशबाट हिंसक पशुहरूलाई हटाइदिने छु, र तिमीहरूका देशमा तरवार प्रहार हुने छैन । ");
INSERT INTO npiulb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तिमीहरूले आफ्ना दुश्मनहरूलाई लखेट्‍ने छौ, र तिमीहरूको तरवारको प्रहारले तिमीहरूकै अगि तिनीहरू लड्‍ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तिमीहरूका पाँच जनाले सयलाई, र सयले हजार जनालाई लखेट्‍ने छन्, र तिमीहरूको तरवारको प्रहारले तिमीहरूका दुश्मनहरू तिमीहरूकै अगि लड्‍ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","म तिमीहरूमाथि कृपादृष्‍टि लगाउने छु र तिमीहरूलाई फलवन्‍त बनाएर तिमीहरूको सङ्ख्या वृद्धि गर्ने छु । म मेरो करार तिमीहरूसँग स्थापना गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तिमीहरूले लामो समयसम्म भण्डार गरेको खाने कुरा खाने छौ । तिमीहरूले भण्डार गरेको खाने कुरा बाहिर निकालेर नयाँ फसलको निम्ति ठाउँ तयार गर्ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","म मेरो वेदी तिमीहरूकै बिचमा राख्‍ने छु, र म तिमीहरूलाई घृणा गर्ने छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","म तिमीहरूका बिचमा हिँड्‍डुल गर्ने छु, र म तिमीहरूका परमेश्‍वर हुने छु, र तिमीहरू मेरा मानिसहरू हुने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","तिमीहरू मिश्रमा दास भइनरहोस् भनेर त्यस देशबाट तिमीहरूलाई निकालेर बाहिर ल्याउने परमप्रभु तिमीहरूका परमेश्‍वर म नै हुँ । मैले तिमीहरूका जुवाका काठहरू भत्‍काइदिएको छु र तिमीहरूलाई ठाडो भएर हिँड्ने तुल्याएको छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","तर तिमीहरूले मेरा कुरा सुनेनौ, र मेरा यी सबै आज्ञाहरू मानेनौ, ");
INSERT INTO npiulb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","र मेरा विधि र नियमहरूलाई घृणा गरेर इन्‍कार गर्‍यौ, र मेरा सबै आज्ञाहरू पालन नगरेर मेरो करारलाई तोड्‍यौ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","म तिमीहरूका बिचमा आतङ्क फैलाउने छु, आँखालाई नष्‍ट गर्ने र प्राणलाई शिथिल गराउने रोगहरू र ज्वरोहरू पठाउने छु । तिमीहरूले छरेका बिउ व्यर्थ हुने छन्, किनभने तिमीहरूका शत्रुहरूले त्यसको उब्जनी खाने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","म मेरो मुहार तिमीहरूबाट फर्काउने छु, र तिमीहरूका शत्रुले तिमीहरूलाई पराजय गर्ने छन् । तिमीहरूलाई घृणा गर्ने मानिसहरूले तिमीहरूमाथि शासन गर्ने छन्, र कसैले तिमीहरूलाई नखेदे तापनि तिमीहरू भाग्‍ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","यी सबैपछि पनि तिमीहरूले मेरो कुरा सुनेनौ भने, म तिमीहरूका पापभन्दा सात गुणा बढी सजाय तिमीहरूलाई दिने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","आफ्नो शक्‍तिमाथिको तिमीहरूको घमण्डलाई म तोडिदिने छु । तिमीहरूमाथिको आकाशलाई फलामझैँ र तिमीहरूको भूमिलाई काँसोझैँ बनाउने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तिमीहरूको मेहनत व्यर्थ हुने छ, किनभने तिमीहरूको भूमिले आफ्नो फसल दिने छैन, र तिमीहरूका भूमिका रुखहरूले आफ्ना उब्जनी दिने छैनन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","यदि तिमीहरू मेरो विरुद्ध भयौ र मेरो कुरा सुनेनौ भने, तिमीहरूका पापहरूको बदलामा म सात गुणा विपत्ति ल्याउने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","म तिमीहरूकहाँ डर लाग्‍दा पशुहरू पठाउने छु, र तिनीहरूले तिमीहरूका छोराछोरीहरू चोरी लैजाने छन्, र तिमीहरूका गाईवस्तुलाई नष्‍ट गर्ने छन्, र तिमीहरूको सङ्ख्यामा कमि ल्याउने छन् । यसरी तिमीहरूका मार्गहरू विराना हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","यी कुराहरू हुँदाहुँदै पनि तिमीहरूले मेरा सुधारहरूलाई स्वीकारेनौ र मेरो विरुद्धमा हिँड्न छोडेनौ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","म तिमीहरूका विरुद्ध हुने छु, र तिमीहरूका पापका कारण म तिमीहरूलाई सात गुणा दण्ड दिने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","म तिमीहरूमाथि तरवार प्रहार गर्ने छु र तिमीहरूले करार भङ्ग गरेको कारण त्यस तरवारले बदला लिने छ । तिमीहरू आफ्ना सहरहरूमा भेला गराइने छौ, र तिमीहरूका बिचमा मैले एउटा रोग पठाउने छु, र तिमीहरूका दुश्‍मनका हातमा तिमीहरूलाई सुम्‍पने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जब म तिमीहरूका भोजनको आपूर्ति रोकिदिने छु, दस जना स्‍त्रीले एउटै भाँडोमा तिमीहरूका निम्ति रोटी बनाउने छन्, र वजनअनुसार तिनीहरूले तिमीहरूका रोटी वितरण गर्ने छन् । तिमीहरूले खाने त छौ, तर तृप्‍त हुने छैनौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","यी कुराहरू हुँदाहुँदै पनि तिमीहरूले मेरो कुरा सुनेनौ र मेरो विरुद्ध हिँडिरह्‍यौ भने, ");
INSERT INTO npiulb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","म क्रोधित हुने छु र तिमीहरूको विरुद्ध हुने छु, र तिमीहरूका पापभन्दा सात गुणा बढी दण्ड म दिने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तिमीहरूले आफ्ना छोराछोरीहरूका मासु खाने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","म तिमीहरूका डाँडाका थानहरू नाश गर्ने छु, तिमीहरूका धूपका वेदीहरू भत्‍काइदिने छु, र तिमीहरूका लाशहरू तिमीहरूका मृत मूर्तिहरूमाथि फालिदिने छु, र म तिमीहरूलाई तिरस्कार गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","म तिमीहरूका सहरहरूलाई भग्‍नावशेषमा परिणत गरिदिने छु र तिमीहरूका पवित्र स्थलहरू नष्‍ट गरिदिने छु । म तिमीहरूका बलिदानहरूका सुगन्धबाट प्रसन्‍न हुने छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","म तिमीहरूका देशलाई ध्वस्त पारिदिने छु । त्यहाँ बस्‍ने तिमीहरूका दुश्‍मनहरूले त्यस्तो विनाश देखेर आश्‍चर्यचकित हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","म तिमीहरूलाई जाति-जातिहरूका बिचमा तितरबितर पारिदिने छु, र मेरो तरवार निकालेर तिमीहरूको पछि लाग्‍ने छु । तिमीहरूको देश त्यागिने छ र तिमीहरूका सहरहरू विनाश हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","त्यो देश जबसम्म त्यागिएको हुन्छ र जबसम्म तिमीहरू दुश्‍मनको भूमिमा हुन्छौ, तबसम्म त्यो देशले शबाथ मनाउने छ । त्यस समयसम्म देशले विश्राम गर्ने छ र आफ्नो शबाथ मनाउने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","त्यो जबसम्म त्यागिएको हुन्छ, त्यो विश्राममा हुन्छ । तिमीहरू त्यहाँ बसोबास गर्दा तिमीहरूका शबाथसँगै त्यसले यस्तो विश्राम पाएको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","तिमीहरूका दुश्‍मनका देशमा छोडिएकाहरूका हृदयहरूमा यस्तो डर हालिदिने छु, कि हावाले पात हल्‍लाउँदा आउने आवाजले तिमीहरूलाई झस्‍काउने छ, र तिमीहरू तरवारबाट टाढा भागेझैँ दौडने छौ । कसैले तिमीहरूलाई नखेदेको भए पनि तिमीहरू लड्‍ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","कसैले नखेदेको भए तापनि तिमीहरू तरवारबाट टाढा भागेझैँ भाग्‍ने छौ र एक-अर्कासँग ठोकिने छौ । तिमीहरूसँग आफ्ना दुश्‍मनहरूको अगाडि उभिने तागत हुने छैन । ");
INSERT INTO npiulb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तिमीहरू जाति-जातिहरूका बिचमा नष्‍ट हुने छौ, र तिमीहरूका दुश्‍मनको भूमिले तिमीहरूलाई निल्‍ने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","तिमीहरूमध्ये बाँकी रहेकाहरू तिमीहरूका दुश्‍मनको देशमा आफ्ना पाप र आफ्ना पुर्खाहरूको पापका कारण खतम हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","तर यदि तिनीहरूले आफ्ना र आफ्ना पुर्खाहरूका पाप, मप्रति विश्‍वासहीन भएर गरेका विद्रोह, र मेरो विरुद्धको हिँडाइलाई स्वीकारे भने- ");
INSERT INTO npiulb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","जसले गर्दा म तिनीहरूको विरुद्ध भएँ र तिनीहरूलाई मैले तिनीहरूका दुश्‍मनको देशमा ल्याएँ- र यदि तिनीहरूका कठोर कठोर हृदय नम्र भए, अनि तिनीहरूले आफ्ना पापका कारण दण्डहरू स्वीकारे भने, ");
INSERT INTO npiulb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","मैले याकूब, इसहाक र अब्राहामसँग गरेको मेरो करारको सम्झना गर्ने छु, र त्यो देशलाई पनि सम्झने छु । ");
INSERT INTO npiulb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","त्यो देश तिनीहरूद्वारा त्यागिने छ, र यसैकारण त्यो त्यागिएको समयमा त्यसले शबाथ मनाउने छ । तिनीहरू आफैले मेरा आज्ञाहरू इन्‍कार गरेका र मेरा नियमहरूलाई घृणा गरेका हुनाले तिनीहरूले आफ्ना पापको दण्ड पाउने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","यी सबै कुरा हुँदाहुँदै पनि तिनीहरू आफ्ना दुश्‍मनको भूमिमा हुँदा म तिनीहरूलाई इन्‍कार गर्ने छैनँ, न त तिनीहरूलाई पूर्ण रूपमा नष्‍ट गर्न र तिनीहरूसँगको मेरो करारबाट टाढा हुनको निम्ति तिनीहरूलाई घृणा गर्ने छु, किनभने म परमप्रभु तिनीहरूका परमेश्‍वर हुँ । ");
INSERT INTO npiulb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","तर तिनीहरूका खातिर मैले तिनीहरूका पुर्खाहरूसँग बाँधेको करारको सम्झना म गर्ने छु, जुन पुर्खाहरूलाई म तिनीहरूका परमेश्‍वर हुन सकूँ भनेर मैले मिश्र देशबाट बाहिर ल्याएँ । म परमप्रभु हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","परमप्रभुले सीनै पर्वतमा मोशाद्वारा उहाँ र इस्राएलका मानिसहरूका बिचमा दिनुभएका आज्ञाहरू, विधिहरू र नियमहरू यी नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलका मानिसहरूलाई भन्, ‘यदि कसैले परमप्रभुलाई विशेष प्रतिज्ञा गर्दछ भने, त्यसको मूल्य यसरी निर्धारण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","बिसदेखि साठी वर्षसम्मको पुरुषको लागि पवित्रस्थानका शेकेलबमोजिम चाँदीका पचास शेकेल मूल्य तोकिदिनू । ");
INSERT INTO npiulb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","सोही उमेरको स्‍त्रीको निम्ति भने मूल्य तिस शेकेल होस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पाँच वर्षदेखि बिस वर्षसम्मको पुरुषको लागि मूल्य बिस शेकेल र स्‍त्रीको लागि दस शेकेल निर्धारण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक महिनादेखि पाँच वर्षसम्मको पुरुषको लागि मूल्य पाँच शेकेल र स्‍त्रीको लागि तिन शेकेल निर्धारण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठी वर्षमाथिको पुरुषको लागि मूल्य पन्ध्र शेकेल र स्‍त्रीको लागि दस शेकेल निर्धारण गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","तर प्रतिज्ञा गर्ने मानिसले तोकिएको मूल्य तिर्न सकेन भने, त्यो मानिस पुजारीकहाँ प्रकट गरियोस्, र पुजारीले भाकल गर्ने मानिसको क्षमताअनुसार मूल्य निर्धारण गरिदिने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","यदि कसैले परमप्रभुको निम्ति कुनै पशु बलिदान गर्न चाहन्छ, र यदि उहाँले त्यो स्वीकार्नुभयो भने, त्यो पशु त्यसको निम्ति छुटाइने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","त्यो मानिसले त्यस पशुलाई नसाटोस्, असललाई खराबको निम्ति र खराबलाई असलको निम्ति । यदि त्यसले एउटालाई अर्कोको निम्ति साटेमा त्यो र जसको निम्ति त्यो साटिएको थियो, दुवै नै पवित्र हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","तथापि, यदि त्यस मानिसले परमप्रभुलाई दिन्छु भनी प्रतिज्ञा गरेको पशु अशुद्ध छ र परमप्रभुले त्यो स्वीकार्नुभएन भने, त्यस मानिसले पशुलाई पुजारीकहाँ ल्याओस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","पुजारीले बजार-मूल्यअनुसार त्यसको मूल्य निर्धारण गरोस् । पुजारीले त्यस पशुको मूल्य जति निर्धारण गर्दछ, त्यो नै त्यसको मूल्य हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","यदि त्यसको मालिकले त्यसलाई छुटाउन चाह्‍यो भने, त्यसले त्यसको छुटकाराको मूल्यमा पाँचौँ भाग थपोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","जब कुनै मानिसले आफ्नो घर परमप्रभुको निम्ति पवित्र उपहारको रूपमा अलग गर्दछ भने, पुजारीले त्यो असल छ वा छैन भनेर हेरी त्यसको मूल्य निर्धारण गरोस् । पुजारीले त्यसको मूल्य जति निर्धारण गर्दछ, त्यति नै त्यसको मूल्य हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","तर आफ्नो घरलाई परमप्रभुको निम्ति अलग गर्ने मालिकले त्यो छुटाउन चाहेमा त्यसले त्यसको छुटकाराको मूल्यमा पाँचौँ भाग थपोस् र त्यो त्यसकै हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","यदि कुनै मानिसले आफ्नो केही जमिन परमप्रभुको निम्ति अलग गर्दछ भने, त्यो जमिनमा छर्न सकिने बिउको परिमाणअनुसार त्यसको मूल्य निर्धारण हुन्छ । एक मुरी जौको मूल्य चाँदीका बिस शेकेल बराबर हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि त्यसले त्यो जमिन पुनर्स्थापनाको वर्षमा अलग गर्दछ भने, त्यसको मूल्य तोकिएबमोजिम हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","तर त्यसले आफ्नो जमिन पुनर्स्थापनाको वर्षपछि अलग गर्दछ भने, पुजारीले अर्को पुनर्स्थापनाको वर्ष आउनलाई बाँकी भएका वर्षहरूका आधारमा त्यो जमिनको मूल्य तय गरोस्, र मूल्य निर्धारण गर्दा त्यसको मूल्य घटाइयोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","यदि त्यो जमिन अलग गर्ने मानिसले त्यो छुटाउन चाहेमा त्यसले त्यसको मूल्यमा पाँचौँ भाग थपोस्, र त्यो त्यसको हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","तर यदि त्यसले त्यो जमिनलाई छुटाएन, वा त्यसले त्यो जमिन कुनै अर्को मानिसलाई बेचेको भए, त्यो अब फेरि छुटाउन मिल्दैन । ");
INSERT INTO npiulb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","त्यो भूमि पुनर्स्थापनाको वर्षमा स्वतन्त्र हुँदा परमप्रभुको निम्ति पूर्ण रूपमा दिइएको जमिनझैँ त्यो परमप्रभुको निम्ति पवित्र उपहार हुने छ । त्यो पुजारीको हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","यदि कुनै मानिसले आफूले किनेको जमिन परमप्रभुको निम्ति अलग गर्दछ, तर त्यो जमिन त्यसको परिवारको जमिनको भाग होइन भने, ");
INSERT INTO npiulb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","पुजारीले पुनर्स्थापनाको वर्षसम्म त्यसको मूल्य कति हुन्छ त्यो निर्धारण गरोस्, र त्यो मानिसले त्यस दिन परमप्रभुको निम्ति पवित्र उपहारको रूपमा त्यसको मूल्य तिरोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","पुनर्स्थापनाको वर्षमा त्यो जमिन जसबाट किनिएको थियो अर्थात् त्यस जमिनको मालिककहाँ नै फिर्ता जाने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","सबै मूल्याङ्कन पवित्रस्थानको शेकेलको वजनको आधारमा गरियोस् । बिस गेरा एक शेकेल बराबर हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","पशुहरूमा पहिलो जन्मनेलाई कसैले पनि अलग नगर्नू, किनभने पहिलो जन्मने पहिलैबाट परमप्रभुकै हो । चाहे त्यो साँढे होस् वा भेडा, त्यो परमप्रभुको हो । ");
INSERT INTO npiulb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","यदि त्यो अशुद्ध पशु हो भने, त्यसको मूल्यमा पाँचौँ भाग थपेर त्यसको मालिकले त्यो किन्‍न सक्‍ने छ । यदि त्यो पशुको छुटकारा भएन भने, तोकिएको मूल्यमा त्यो बेचियोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","तर कुनै मानिसले आफूसँग भएका सबै सम्पत्तिबाट परमप्रभुलाई अर्पण गरेको कुरा, चाहे त्यो मानिस वा पशु, वा आफ्नो पारिवारिक जमिन जेसुकै भए पनि त्यो बेचिनु वा छुटाउनुहुँदैन । अर्पण गरिएको सबै कुरा परमप्रभुको निम्ति पवित्र हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","नाशको निम्ति अर्पण गरिएको मानिसको निम्ति कुनै मोल नतिर्नू । त्यो मानिस मारिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","भूमिको सबै दशांश, चाहे भूमिमा उब्जेका अन्‍न वा रुखहरूका फल जे भए पनि त्यो परमप्रभुकै हो । त्यो परमप्रभुको निम्ति पवित्र हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","यदि कसैले आफ्नो दशांश छुटाउँछ भने, त्यसले त्यसको मूल्यमा पाँचौँ भाग थपोस् । ");
INSERT INTO npiulb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","बथान वा बागल, वा गोठालोको लौरोमुनिबाट जाने हरेक पशुको दस भागमा एक भाग परमप्रभुको निम्ति अलग गरिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","गोठालोले असल वा खराब पशु नछुटाओस्, र त्यसले एउटाको निम्ति अर्को नबद्‍लोस् । यदि त्यसले त्यो परिवर्तन गरेमा त्यो र जसको निम्ति त्यो बद्‌लिएको थियो, दुवै नै पवित्र हुने छन् । त्यो छुटाउन सकिने छैन’ ।” ");
INSERT INTO npiulb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","परमप्रभुले सीनै पर्वतमा इस्राएलका मानिसहरूका निम्ति दिनुभएका आज्ञाहरू यी नै हुन् ।");
INSERT INTO npiulb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","सीनैको मरुभूमिमा भेट हुने पालमा परमप्रभु मोशासँग बोल्नुभयो । यो इस्राएलका मानिसहरू मिश्र देशबाट निस्की आएका दोस्रो वर्षको दोस्रो महिनाको पहिलो दिनमा भएको थियो । परमप्रभुले भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“इस्राएलको हरेक कुलको सबै पुरुषहरूको तिनीहरूका पुर्खाहरूका परिवार-परिवारअनुसार जनगणना गर् । तिनीहरूका नाउँअनुसार गन् । हरेक पुरुषको गणना गर्, ");
INSERT INTO npiulb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","जो बिस वर्ष वा त्यसभन्दा माथिका छन् । इस्राएलको निम्ति सिपाहीको रूपमा लड्न सक्‍ने सबैलाई गन् । तैँले र हारूनले तिनीहरूका सशस्‍त्र समूह-समूहअनुसार पुरुषहरूको सङ्ख्याको अभिलेख राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","हरेक कुलको एक जना पुरुषले अर्थात् वंशको मुखियाले आफ्नो वंशको अगुवाको रूपमा तिमीहरूसँग सेवा गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","हरेक अगुवाले तिनको वंशको निम्ति लड्ने पुरुषहरूको नेतृत्व गर्नुपर्छ । तिमीहरूसँगै रहेर लड्ने अगुवाहरूका नाउँहरू यिनै हुन्ः रूबेनको कुलबाट शदेऊरको छोरो एलीसूर; शिमियोनको ");
INSERT INTO npiulb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","कुलबाट सुरीशद्दैको छोरो शलूमीएल । ");
INSERT INTO npiulb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदाको कुलबाट अम्मीनादाबको छोरो नहशोन; ");
INSERT INTO npiulb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साखारको कुलबाट सूआरको छोरो नतनेल; ");
INSERT INTO npiulb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलूनको कुलबाट हेलोनको छोरो एलीआब; ");
INSERT INTO npiulb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफको छोरो एफ्राइमको कुलबाट अम्मीहूदको छोरो एलीशामा; मनश्शेको कुलबाट पदासूरको छोरो गमलिएल; ");
INSERT INTO npiulb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बेन्यामीनको कुलबाट गिदेओनीको छोरो अबीदान; ");
INSERT INTO npiulb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दानको कुलबाट अम्मीसद्दैको छोरो अहिएजेर; ");
INSERT INTO npiulb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेरको कुलबाट ओक्रानको छोरो पगीएल; ");
INSERT INTO npiulb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गातको कुलबाट दूएलको छोरो एल्यासाप; ");
INSERT INTO npiulb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नप्‍तालीको कुलबाट एनानको छोरो अहीरा ।” ");
INSERT INTO npiulb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","मानिसहरूबाट चुनिएका पुरुषहरूका नाउँहरू यिनै थिए । तिनीहरूले आ-आफ्ना पुर्खाहरूका कुलको नेतृत्व गरे । तिनीहरू इस्राएलका कुलहरूका अगुवाहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","नाउँअनुसार अभिलेख राखिएका यी पुरुषहरूलाई मोशा र हारूनले लिए, र ");
INSERT INTO npiulb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","यी मानिसहरूसँगै एस्राएलका सबै मानिस दोस्रो महिनाको पहिलो दिनमा भेला भए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","त्यसपछि बिस वर्ष र त्यसभन्दा माथिका सबै पुरुषले आ-आफ्ना पुर्ख्यौली पहिचान गरे । तिनीहरूले आफू जन्मिएको कुल र परिवारहरूको नाउँ उल्लेख गर्नुपर्थ्यो । त्यसपछि मोशाले सीनैको मरुभूमिमा परमप्रभुले आज्ञा गर्नुभएअनुसार तिनीहरूका सङ्ख्याहरूको अभिलेख राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएलका जेठा छोरो रूबेनका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूका अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रूबनेको कुलबाट तिनीहरू ४६,५०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमियोनका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूका अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमियोनका कुलबाट तिनीहरू ५९,३०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गादका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गादको कुलबाट तिनीहरू ४५,६५० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदाका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदाको कुलबाट तिनीहरू ७४,६०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साखारका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साखारको कुलबाट ५४,४०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलूनका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबूलूनको कुलबाट तिनीहरू ५७,४०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफका छोरा एफ्राइमका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एफ्राइमको कुलबाट तिनीहरू ४०,५०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्‍शेका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शेको कुलबाट तिनीहरू ३२,२०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बेन्यामीनका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बेन्यामीनको कुलबाट तिनीहरू ३५,४०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दानका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दानको कुलबाट तिनीहरू ६२,७०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेरका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेरको कुलबाट तिनीहरू ४१,५०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नप्‍तालीका सन्तानहरूबाट तिनीहरूका पुर्खाहरूका आ-आफ्ना कुलहरू र परिवारहरूको अभिलेखबाट लडाइँमा जान सक्‍ने बिस वर्ष वा त्यसभन्दा माथिका सबै पुरुषहरू गनिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नप्‍तालीको कुलबाट तिनीहरू ५३,४०० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मोशा र हारूनले यी पुरुषहरूलाई इस्राएलका बाह्र कुललाई नेतृत्व गर्ने बाह्र पुरुषसँगै गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","यसैले लडाइँमा जान सक्‍ने बिस वर्ष र त्यसभन्दा माथिका इस्राएलका सबै पुरुषहरूको हरेकको आ-आफ्ना परिवार-परिवारअनुसार गन्ती गरियो । ");
INSERT INTO npiulb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","तिनीहरू ६,०३,५५० पुरुष थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","तर लेवीका सन्तानहरूको गन्ती ");
INSERT INTO npiulb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","गरिएन, किनभने परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“तैँले लेवीको कुललाई नगन्‍नू वा इस्राएलका कुल मानिसहरूमा नगाभ्नू । ");
INSERT INTO npiulb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","बरु, लेवीहरूलाई पवित्र वासस्थानको करारका विधिहरूको हेरचाह गर्न र पवित्र वासस्थानका सबै सरसामान र यसमा भएका सबै कुराको हेरचाह गर्न नियुक्‍त गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","पवित्र वासस्थान अर्को ठाउँमा सार्नुपर्दा यसलाई लेवीहरूले उठाउनुपर्छ । पवित्र वासस्थान खडा गर्नुपर्दा लेवीहरूले नै खडा गर्नुपर्छ । पवित्र वासस्थानको नजिक आउने कुनै पनि अपरिचित व्यक्‍तिलाई मार्नू । ");
INSERT INTO npiulb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएलका मानिसहरूले आ-आफ्ना पालहरू टाँग्दा हरेकले तिनीहरूका सशस्‍त्र समुहको झण्डाको नजिकै टाँग्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","तथापि, लेवीहरूले तिनीहरूका पाल करारका विधिका पवित्र वासस्थान वरिपरि टाँग्‍नुपर्छ, ताकि इस्राएलका मानिसहरूमाथि मेरो रिस नपरोस् । लेवीहरूले करारका विधिहरूको पवित्र वासस्थानको हेरचाह गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","इस्राएलका मानिसहरूले यी सबै कुरा गरे । परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएको सबै थोक तिनीहरूले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","परमप्रभु फेरि पनि मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“हरेक इस्राएलीले आ-आफ्ना पुर्खाहरूको घरानाअनुसार आ-आफ्नो झन्डाको वरिपरि छाउनी लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","तिनीहरूले भेट हुने पालको वरिपरि छाउनी लगाऊन् । भेट हुने पालको पूर्वतिर अर्थात् घाम झुल्कनेतिर छाउनी लगाउनेहरू यहूदाको दल होस् र तिनीहरूले आफ्नो झन्डामुनि छाउनी लगाऊन् । अम्मीनादाबको छोरो नहशोन यहूदाका मानिसको अगुवा होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","यहूदाका मानिसहरूको सङ्ख्या ७४,६०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","इस्साखारको कुलले यहूदापछि छाउनी लगाउनू । सूआरका छोरो नतनेलले इस्साखारको फौजको नेतृत्व गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","तिनको दलमा भएकाहरूको सङ्ख्या ५४,४०० पुरुष छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","जबूलूनको कुलले इस्साखारपछि छाउनी लगाउनू । हेलोनका छोरा एलीआबले जबूलूनको फौजको नेतृत्व गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","तिनको दलमा भएकाहरूको सङ्ख्या ५७,४०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदाको छाउनीको कुल सङ्ख्या १,८६,४०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","तिनीहरू अग्रस्थानमा हिँड्नेछन् । दक्षिणपट्टि रूबेनको छाउनी तिनीहरूको झन्डामुनि हुनेछ । रूबेनको छाउनीको अगुवा शदेऊरका छोरा एलीसूर होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","तिनको दलमा हुनेको सङ्ख्या ४६,५०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","शिमियोनले रूबेनपछि छाउनी लगाओस् । शिमियोनका मानिसहरूको अगुवा सूरीशद्दैका छोरा शलूमीएल होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","तिनको दलमा हुनेहरूको सङ्ख्या ५९,३०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","त्यसपछि गादको कुल हुन्छ । गादका मानिसहरूको अगुवा दूएलका छोरा एल्यासाप होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","तिनको दलमा हुनेहरूको सङ्ख्या ४५,६५० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","आ-आफ्नो दलअनुसार खटाइएका रूबेनको छाउनीका सबै मानिसहरू १,५१,४५० छन् । तिनीहरू दोस्रो लश्करमा हिँड्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","त्यसपछि सबै छाउनीका बिचमा लेवीहरूसँगै छाउनीबाट भेट हुने पाल जानुपर्छ । तिनीहरू छाउनीबाट गएबमोजिम नै छाउनीमा आउनुपर्छ । हरेक मानिस आफ्नो झन्डामुनि आफ्‍नै स्थानमा हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","एफ्राइमको छाउनीका दलहरू आफ्‍नै झन्डामुनि हुन्छन् । एफ्राइमको मानिसहरूको अगुवा अम्मीहूदका छोरा एलीशामा होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","तिनको दलमा हुनेहरूको सङ्ख्या ४०,५०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","तिनीहरूपछि मनश्‍शेको कुल हुन्छ । मनश्‍शेको अगुवा पदासूरका छोरा गमलिएल होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","तिनको दलमा हुनेहरूको सङ्ख्या ३२,२०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","त्यपछि बेन्यामीनको कुल हुनेछ । बेन्यामीनको अगुवा गिदेओनीका छोरा अबीदान होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","तिनको दलमा भएकाहरूको सङ्ख्या ३५,४०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राइमको छाउनीका गन्ती गरिएका सबैको सङ्ख्या १,०८,१०० छ । तिनीहरू तेस्रो लश्करमा हिँड्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तरमा दानको छाउनीको दल हुनेछ । दानका मानिसहरूका अगुवा अम्मीशद्दैका छोरा अहीएजेर होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","तिनको दलमा भएकाहरूको सङ्ख्या ६२,७०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","दानको छाउनीपछि आशेरको कुलका मानिसहरू हुनेछन् । आशेरको अगुवा ओक्रानको छोरा पगीएल होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","तिनको दलमा भएकाहरूको सङ्ख्या ४१,५०० छ । त्यपछि नप्‍तालीको कुल हुनेछ । नप्‍तालीको अगुवा एनानका छोरा अहीरा होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","तिनको दलमा भएकाहरूको सङ्ख्या ५३,४०० छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","दानको छाउनीमा हुनेहरूका सबै सङ्ख्या १,५७,६०० छ । ");
INSERT INTO npiulb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","तिनीहरू छाउनीबाट तिनीहरूको झन्डामुनि अन्तिममा जानेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","आ-आफ्नो परिवार-परिवारअनुसार गन्ती गरिएका इस्राएलीहरू यिनै हुन् । आ-आफ्नो दलअनुसार तिनीहरूको छाउनीमा गणना गरिएकाहरू ६,०३,५५० छन् । , ");
INSERT INTO npiulb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","तर मोशा र हारूनले लेवीहरूलाई इस्राएलका मानिसहरूमा गन्ती गरेनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","यो परमप्रभुले आज्ञा गर्नुभएबमोजिम गरिएको थियो । इस्राएलीका मानिसहरूले परमप्रभुले आज्ञा गर्नुभएका सबै कुरा गरे । तिनीहरूले आ-आफ्नो झन्डाअनुसार छाउनी लगाए । तिनीहरू आ-आफ्ना पुर्खाहरूको परिवार-परिवारअनुसार आ-आफ्नो छाउनीबाट निस्कन्थे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","यो परमप्रभु सीनै पर्वतमाथि मोशासँग बोल्नुहुँदा हारून र मोशाका सन्तानहरूको इतिहास हो । ");
INSERT INTO npiulb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारूनका छोराका नाउँहरू यिनै हुन्: जेठा नादाब, अबीहू, एलाजार र ईतामार थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","हारून पुजारीका छोराहरूका नाउँहरू यिनै हुन् जसलाई पुजारीको रूपमा अभिषेक गरिएको थियो र पुजारीको रूपमा सेवा गर्न नियुक्‍त गरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","तर नादाब र अबीहूले सीनै पर्वतमा अस्वीकार्य आगो परमप्रभुलाई चढाउँदा तिनीहरू उहाँको सामु मरे । नादाब र अबीहूका कुनै छोराछोरी थिएन । यसैले एलाजार र ईतामारले तिनीहरूका बुबा हारूनसँग पुजारीको रूपमा सेवा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवीको कुललाई ले र तिनीहरूले पुजारी हारूनलाई सहायता गर्नको निम्ति तिनीहरूलाई तिनीकहाँ प्रस्तुत गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","तिनीहरूले भेट हुने पालको सामु हारून र सारा समुदायको तर्फबाट दायित्वहरू पुरा गर्नुपर्छ । तिनीहरूले पवित्र वासस्थानमा सेवा गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","तिनीहरूले भेट हुने पालका सबै सरसामानको हेरचाह गर्नुपर्छ र तिनीहरूले पवित्र वासस्थानको सेवा वहन गर्न इस्राएलका कुलहरूलाई सहायता गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","तैँले लेवीहरू हारून र तिनका छोराहरूलाई दिनुपर्छ । इस्राएलका मानिसहरूलाई सेवा गर्न तिनलाई सहायता गर्न तिनीहरूलाई पूर्ण रूपमा सुम्पिएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","तैँले हारून र तिनका छोराहरूलाई पुजारीको रूपमा नियुक्‍त गर्नुपर्छ र नजिक आउने कुनै पनि मानिसलाई मार्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“हेर्, मैले लेवीहरूलाई इस्राएलका मानिसहरूबाट लिएको छु । मैले यो इस्राएलका मानिसहरूका जेठा छोराहरूको सट्टा लिएको छु । लेवीहरू मेरा हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","पहिले जन्मेका सबै मेरा हुन् । मैले मिश्र देशमा पहिले जन्मेकाहरूलाई आक्रमण गरेको दिन नै इस्राएलका मानिस र पशुहरू दुवैको पहिले जन्मेका सबैलाई मेरो निम्ति अलग गरेँ । तिनीहरू मेरा हुन् । म परमप्रभु हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","परमप्रभुले सीनैको मरुभूमिमा मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवीका हरेक कुल र परिवार-परिवारअनुसार गन्ती गर् । एक महिना र त्यसभन्दा माथिका सबै पुरुषको गन्ती गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","मोशाले परमप्रभुको वचनअनुसार उहाँले आज्ञा गर्नुभएबमोजिम तिनीहरूको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवीका छोराहरूका नाउँहरू गेर्शोन, कहात र मरारी थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेर्शोनका छोराहरूबाटका वंशहरू लिब्‍नी र शिमी थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहातका छोराहरूबाटका वंशहरू अम्राम, यिसहार, हिब्रोन र उज्‍जीएल थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारीका छोराहरूबाटका वंशहरू महली र मूशी थिए । कुल-कुलअनुसारका लेवीका कुलहरू यिनै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","लिब्‍नी र शिमीका कुलहरू गेर्शोनबाट आउँछ । गेर्शोनीहरूका कुलहरू यिनै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","एक महिना र त्यसभन्दा माथिका गनिएका सबै पुरुष जम्मा ७,५०० थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्शोनीहरूका कुलहरूले पवित्र वासस्थानको पश्‍चिमपट्टि छाउनी लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","लाएलका छोरा एल्यासापले गेर्शोनीहरूका कुलहरूको नेतृत्व गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","गेर्शोनको परिवारले पवित्र वासस्थानलगायत भेट हुने पालको हेरचाह गर्नुपर्छ । तिनीहरूले पाल, यसको छत र भेट हुने पालको प्रवेश-द्वारको रूपमा प्रयोग गरिएको पर्दाको देखरेख गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","तिनीहरूले चोकका पर्दाहरू अनि पवित्र वासस्थान र वेदी वरिपरिका पर्दाहरूको देखरेख गर्नुपर्छ । तिनीहरूले भेट हुने पाल र यसमा भएका सबै थोकको देखरेख गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","यिनीहरू कहातका कुलहरू हुन्ः अम्रामीहरूका कुल, इसहारीहरूका कुल, हेब्रोनीहरूका कुल र उज्‍जीएलीहरूका कुल । यिनीहरू कहाती कुलका हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","परमप्रभुका सरसामानहरूको देखरेख गर्न एक महिना र त्यसभन्दा माथिका गन्ती गरिएका पुरुषहरू ८,६०० थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहातका कुलहरूले पवित्र वासस्थानको दक्षिणतिर छाउनी लगाउनू । ");
INSERT INTO npiulb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","उज्‍जीएलका छोरा एलीजापानले कहातीहरूका कुलहरूको नेतृत्व गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","तिनीहरूले सन्दूक, टेबुल, सामदान, वेदीहरू, तिनीहरूका सेवामा प्रयोग गरिने पवित्र थोकहरू, पर्दा र यससम्बन्धी सबै कामको देखरेख गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","पुजारी हारूनका छोरा एलाजारले लेवीहरूको नेतृत्व गर्ने पुरुषहरूको नेतृत्व गर्नुपर्छ । तिनले पवित्र स्थानको देखरेख गर्ने पुरुषहरूको पर्यवेक्षण गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मरारीबाट दुईवटा कुल आएका छन्ः महलीहरूका कुल र मूशीहरूका कुल । यी कुलहरू मरारीबाट आएका हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","एक महिना र त्यसभन्दा माथिका गनिएका पुरुषहरू ६,२०० थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","अबीहेलका छोरा सूरीएलले मरारी कुलको नेतृत्व गर्नुपर्छ । तिनीहरूले पवित्र वासस्थानको उत्तरतिर छाउनी लाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारीका सन्तानहरूले पवित्र वासस्थानका फल्याकहरू, बारहरू, खामाहरू, आधारहरू, सबै सरसमान र तिनीहरूसँग सम्बन्धित सबै थोक, साथै ");
INSERT INTO npiulb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","चोकका वरिपरिका खामाहरू, आधारहरू, किलाहरू र सोरीहरूको देखरेख गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मोशा, हारून र तिनका छोराहरूले पवित्र वासस्थानको पूर्वतिर अर्थात् घाम झुल्कनेतिर छाउनी लगाउनुर्छ । तिनीहरू पवित्र स्थानको कर्तव्यहरू र इस्राएलका मानिसहरूका कर्तव्यहरू पुरा गर्न उत्तरदायी छन् । यसको नजिक आउने अन्य कुनै पनि व्यक्‍ति मारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","परमप्रभुले आज्ञा गर्नुभएझैँ मोशा र हारूनले लेवीका कुल एक महिना र त्यसभन्दा माथिका सबै पुरुषको गन्ती गरे । तिनीहरूले बाइस हजार पुरुषहरू गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","परमप्रभुले मोशालाई भन्‍नुभयो, “एक महिना र त्यसभन्दा माथिका इस्राएलका मानिसहरूका सबै पहिले जन्मेका पुरुषहरूको गन्ती गर् । तिनीहरूका नाउँको सूची बना । ");
INSERT INTO npiulb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","म परमप्रभु हुँ, तैँले मेरो निम्ति लेवीहरूलाई इस्राएलका मानिसहरूको पहिले जन्मेकाहरूको सट्टामा र इस्राएलका सन्तानहरूका गाईवस्तुहरूका पहिले जन्मेकाहरूको सट्टामा लेवीहरूका गाईवस्तुहरूलाई लिनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","परमप्रभुले आज्ञा गर्नुभएअनुसार मोशाले इस्राएलका सबै जेठा-जेठाको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","तिनले एक महिना र त्यसभन्दा माथिका सबै जेठा छोराहरूको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","तिनले गन्ती गरेका पुरुषको सङ्ख्या २२,२७३ थियो । फेरि, परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएलका मानिसहरूका पहिले जन्मेकाहरूको सट्टामा लेवीहरूलाई ले र मानिसहरूका गाईवस्तुहरूका सट्टामा लेवीहरूका गाईवस्तुहरूलाई ले । ");
INSERT INTO npiulb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","म परमप्रभु हुँ, लेवीहरू मेरा हुन् । लेवीहरूको सङ्ख्याभन्दा बढी भएका २७३ जना पहिले जन्मेकाहरूका हरेकको निम्ति तैँले पाँच-पाँच शेकेल लिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","तैँले तेरो मापदण्डको रूपमा पवित्र स्थानको शेकेल नै प्रयोग गर्नुपर्छ । एक शकेलको बिस गेरा हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","त्यो छुटकाराको मूल्य तैँले हारून र तिनका छोराहरूलाई दिनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","यसैले लेवीहरूद्वारा छुटकारा पाएका सङ्ख्याभन्दा धेरै भएकाहरूबाट मोशाले छुटकाराको मूल्य जम्मा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","मोशाले इस्राएलको पहिले जन्मेकाहरूबाट पैसा उठाए । तिनले पवित्र स्थनाको शेकेलअनुसार १,३६५ शेकेल उठाए । ");
INSERT INTO npiulb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","मोशाले त्यो छुटकाराको मूल्य हारून र तिनका छोराहरूलाई दिए । परमप्रभुले उहाँको वचनद्वारा आज्ञा गर्नुभएबमोजिम मोशाले सबै थोक गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवीहरूबाट कहातका पुरुष सन्तानहरूको आ-आफ्ना वंशहरू र परिवार-परिवारअनुसार गन्ती गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","तिसदेखि पचास वर्षसम्मका पुरुषहरूको गन्ती गर् । यी मानिसहरू भेट हुने पालमा सेवा गर्ने दलमा सहभागी हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","कहातका सन्तानहरूले भेट हुने पालको निम्ति मेरो निम्ति राखिएका अति पवित्र थोकहरूको देखरेख गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","छाउनी सार्न तयारी हुँदा हारून र तिनका छोराहरू भित्र जानुपर्छ, अति पवित्र स्थानलाई पवित्र स्थानबाट छुट्‌ट्याउने पर्दा झिक्‍नुपर्छ र गवाहीको सन्दूकलाई त्यसैले ढाक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","तिनीहरूले सन्दूकलाई सीलको छालाले ढाक्‍नुपर्छ । तिनीहरूले यसमाथि निलो कपडाले ढाक्‍नुपर्छ । तिनीहरूले यसलाई बोक्‍न डन्डीहरू हाल्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","तिनीहरूले उपस्थितिको रोटीको टेबुललाई एउटा निलो कपडाले ढाक्‍नुपर्छ । यसमाथि तिनीहरूले थालहरू, धुपौराहरू, बाटाहरू र अर्घ-बलिका कचौराहरू राख्‍नुपर्छ । टेबुलमाथि रोटी सदैव हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","तिनीहरूले यिनीहरूलाई रातो रङको कपडाले र फेरि सीलको छालाले ढाक्‍नुपर्छ । टेबुललाई बोक्‍न डन्डीहरू हाल्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","तिनीहरूले सामदानसाथै यसका बत्तीहरू, चिम्टाहरू, मोसोदानीहरू र बत्तीका निम्ति तेलका सबै भाँडालाई निलो कपडाले ढाक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","तिनीहरूले सामदान र यसका सबै सरसामानलाई सीलको छालाले ढाक्‍नुपर्छ र तिनीहरूले यसलाई बोक्‍ने भारमाथि राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","तिनहरूले सुनको वेदीलाई निलो कपडाले ढाक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","तिनीहरूले यसलाई सीलको छालाले ढाक्‍नुपर्छ र बोक्‍नलाई डन्डीहरू हाल्नुपर्छ । तिनीहरूले पवित्र स्थानका सबै कामका सामानहरूलाई लिएर निलो कपडाले बेर्नुपर्छ । तिनीहरूले यसलाई सीलको छालाले ढाक्‍नुपर्छ र सामानहरूलाई बोक्‍ने भारमाथि राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","तिनीहरूले वेदीबाट खरानी हटाउनुपर्छ र वेदीलाई बैजनी रङको कपडाले ढाक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","तिनीहरूले वेदीको सेवामा प्रयोग गर्ने सबै सामानलाई बोक्‍ने भारमाथि राख्‍नुपर्छ । यिनीहरू आगो राख्‍ने पात्रहरू, काँटाहरू, बेल्चाहरू, बाटाहरू र वेदीका अन्य सबै सामान हुन् । तिनीहरूले वेदीलाई सीलको छालाले ढाक्‍नुपर्छ अनि बोक्‍नलाई डन्डीहरू हाल्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","जब हारून र तिनका छोराहरूले पवित्र स्थान र यसका सबै सामानलाई ढाकी सक्छन् अनि छाउनी अगाडि बढ्छ त्यसपछि कहातका सन्तानहरू पवित्र स्थान बोक्‍न आउनुपर्छ । यदि तिनीहरूले पवित्र सामानहरू छोए भने तिनीहरू मारिऊन् । भेट हुने पालका सामानहरू बोक्‍ने काम कहातका सन्तानहरूको हो । ");
INSERT INTO npiulb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","पुजारी हारूनका छोरा एलाजारले बत्तीको लागि तेल, सुगन्धित धूप, नियमित अन्‍नबलि, अभिषेक गर्ने तेलको देखरेख गरून् । तिनले सारा पवित्र वासस्थान र यसमा भएका सबै थोक अर्थात् पवित्र स्थान र यसका सामानाहरूको देखरेख गरून् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“कहाती वंशलाई लेवीहरूबाट बहिस्कृत हुन नदेओ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","तिनीहरूको सुरक्षा गर ताकि तिनीहरूले यसो गर्दा तिनीहरू नमरून् । तिनीहरू अति पवित्र स्थानको नजिक जाँदा ");
INSERT INTO npiulb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","तिनीहरू पवित्र स्थान हेर्न एक क्षणको निम्ति पनि जानुहुँदैन नत्रता तिनीहरू मारिनेछन् । हारून र तिनका छोराहरूले हरेक कहातीलाई त्यसको काम अर्थात् त्यसको विशेष कामहरू तोक्‍नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","परमप्रभु फेरि मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेर्शोनका सन्तानहरूको आ-आफ्ना कुल र पुर्खाका परिवार-परिवारअनुसार गन्ती गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","तिसदेखि पचास वर्ष भएकाहरूको गन्ती गर् । भेट हुने पालको सेवा गर्न सहभागी हुन सक्‍ने दलको गन्ती गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","गेर्शोनीहरूले सेवा गर्दा र तिनीहरूले बोक्दा यो काम गेर्शोनी कुलको काम हो । तिनीहरूले पवित्र वासस्थानका पर्दाहरू, भेट हुने पाल, त्यसको छत, यसमाथिको सीलको छालाको छत र भेट हुने पालको प्रवेश-द्वारका पर्दाहरू बोक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","तिनीहरूले चोकका पर्दाहरू, पवित्र वासस्थान र वेदी नजिक भएका चोकको प्रवेश-द्वारका पर्दाहरू, ");
INSERT INTO npiulb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","तिनीहरूका डोरीहरू र तिनीहरूका सेवाको निम्ति सबै सामान बोक्‍नुपर्छ । यिनीहरूसँग सम्बन्धित सबै थोक तिनीहरूले गर्नुपर्छ । हारून ");
INSERT INTO npiulb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","र तिनका छोराहरूले गेर्शोनका सन्तानहरूले ओसारपसार गर्दा र तिनीहरूका सबै सेवामा निर्देशन दिनुपर्छ । तैँले तिनीहरूका सबै दायित्व निर्धारण गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","यो भेट हुने पालको निम्ति गेर्शोनका सन्तानहरूका कुलहरूको काम हो । पुजारी हारूनका छोरा ईतामारले तिनीहरूको कामको नेतृत्व गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","तैँले आ-आफ्ना कुलअनुसार मरारीका सन्तानहरूको गन्ती गर्, र तिनीहरूलाई आ-आफ्ना परिवार-परिवारअनुसार, ");
INSERT INTO npiulb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","तिस वर्षदेखि पचास वर्षसम्मकालाई मिला । भेट हुने पालको सेवा गर्ने र त्यस दलमा सहभागी हुने सबैको गन्ती गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","यो भेट हुने पालको निम्ति तिनीहरूका सबै दायित्व र तिनीहरूका सेवाका काम हो । तिनीहरूले पवित्र वासस्थानका फल्याकहरू, ");
INSERT INTO npiulb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","यसका बारहरू, खामाहरू र आधारहरू, साथै पवित्र वासस्थान वरिपरिका चोकका खामाहरू, तिनीहरूका आधारहरू, कीलाहरू, डोरीहरू तिनका सबै सरसामानको देखरेख गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","तिनीहरूले बोक्‍नुपर्ने सामानहरूको नाउँसहित सूची बना । मरारीका सन्तानहरूले पुजारी हारूनका छोरा ईतामारको निर्देशनमा भेट हुने पालको निम्ति तिनीहरूले गर्नुपर्ने काम यही हो ।” ");
INSERT INTO npiulb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोशा, हारून र समुदायका अगुवाहरूले कहातीहरूका सन्तानहरूको पुर्खाका आ-आफ्ना परिवारअनुसार गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","तिनीहरूले तिस वर्षदेखि पचास वर्षसम्म पुगेकाहरूको गन्ती गरे । तिनीहरूले भेट हुने पालमा सेवा गर्ने दलमा सहभागी हुने सबैको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","तिनीहरूले तिनीहरूका कुलअनुसार २,७५० जना पुरुषको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","मोशा र हारूनले भेट हुने पालमा सेवा गर्ने कहातीहरूका कुल-कुल र परिवार-परिवारअनुसार सबै पुरुषको गन्ती गरे । यसो गर्दा तिनीहरूले परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएको कुरा पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेर्शोनका सन्तानहरूलाई आ-आफ्ना कुल र पुर्खाका परिवारअनुसार, भेट हुने पालको सेवा गर्न दलमा सहभागी हुन सक्‍ने ");
INSERT INTO npiulb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","तिसदेखि पचास वर्षसम्मका सबैको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","आ-आफ्ना कुल र तिनीहरूका पुर्खाका परिवारअनुसार गन्ती गरेका पुरुषहरूको सङ्ख्या २,६३९ थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","मोशा र हारूनले गेर्शोनका सन्तानहरूको गन्ती गरे, जसले भेट हुने पालमा सेवा गर्थे । यसो गर्दा तिनीहरूले परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएको कुरा पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारीका सन्तानहरूलाई आ-आफ्ना कुल र तिनीहरूका पुर्खाका परिवारअनुसार, ");
INSERT INTO npiulb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","तिसदेखि पचास वर्षसम्मका सबैको गन्ती गरियो जो भेट हुने पालमा सेवा गर्न दलमा सहभागी हुन्थे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","आ-आफ्ना कुल र तिनीहरूका पुर्खाका परिवारअनुसार गन्ती गरिएका पुरुषहरूको सङ्ख्या ३,२०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","मोशा र हारूनले मरारीका सन्तानहरूका सबै पुरुषको गन्ती गरे । यसो गर्दा तिनीहरूले परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएको कुरा पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","यसैले मोशा, हारून र इस्राएलका अगुवाले सबै लेवीहरूलाई आ-आफ्ना कुल र तिनीहरूका पुर्खाका ");
INSERT INTO npiulb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","परिवारअनुसार तिस वर्षदेखि पचास वर्ष पुगेकाहरूको गन्ती गरे । तिनीहरूले पवित्र वासस्थानमा सेवा गर्ने र भेट हुने पालका सामानहरूको देखरेख गर्ने र बोक्‍न सक्‍ने सबैको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","तिनीहरूले ८,५८० पुरुषको गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","परमप्रभुको आज्ञामा मोशाले सबै पुरुषलाई त्यसलाई खटाइएको कामको किसिमअनुसार गन्ती गरे । तिनले हरेक पुरुषलाई तिनले वहन गर्ने दायित्वको किसिमअनुसार गन्ती गरे । यसो गर्दा तिनीहरूले परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएको कुरा पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“छालाको सरुवा रोग भएका सबै, धातुको रोग भएका सबै, लास छोएर अशुद्ध भएका सबैलाई छाउनी बाहिर पठाउन इस्राएलका मानिसहरूलाई आज्ञा दे । ");
INSERT INTO npiulb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","पुरुष होस् वा महिला, तैँले तिनीहरूलाई छाउनी बाहिर पठाउनुपर्छ । तिनीहरूले छाउनीलाई अशुद्ध तुल्याउनुहुँदैन, किनभने म यसमा बास गर्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","इस्राएलका मानिसहरूले यसै गरे । परमप्रभुले मोशाद्वारा आज्ञा गर्नुभएअनुसार तिनीहरूले तिनीहरूलाई छाउनी बाहिर पठाए । फेरि ");
INSERT INTO npiulb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएलका मानिसहरूलाई भन् । जब पुरुष वा महिलाले मानिसहरूले आपसमा गर्ने यस्ता कुनै पाप गर्छन् र मप्रति बेइमान हुन्छ, त्यो व्यक्‍ति दोषी हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","त्यसपछि त्यसले आफूले गरेको पाप स्वीकार गर्नुपर्छ । त्यसले आफू चुकेको मूल्य चुक्‍ता गर्नुपर्छ र पाँचौँ हिस्सा थप्‍नुपर्छ । यो त्यसले आघात पुर्‍याएको व्यक्‍तिकहाँ ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","तर यदि अपमानमा परेको व्यक्‍तिको कुनै नजिकको नातेदार छैन भने, त्यसले आफ्नो प्रायश्‍चित्तको निम्ति एउटा थुमासँगै त्यसको दोषको निम्ति पुजारीद्वारा मूल्य मलाई तिर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","इस्राएलका मानिहरूका सबै भेटी र इस्राएलका मानिसहरूले पुजारीलाई ल्याएका र अलग गरेका थोकहरू त्यसको हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","हरेक व्यक्तिका भेटीहरू पुजारीको निम्ति हुनेछ; यदि कसैले पुजारीलाई कुनै थोक दिन्छ भने, यो त्यसको हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","फेरि, परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएलका मानिसहरूलाई भन् । 'कुनै मानिसकी पत्‍नी बहकिन्छे र आफ्नो पतिको विरुद्ध पाप गर्छे । ");
INSERT INTO npiulb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","त्यसपछि अर्को पुरुष त्यससँग सुत्छे । त्यस अवस्थामा त्यो अशुद्ध हुन्छे । ");
INSERT INTO npiulb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","त्यसका पतिले यो नदेखे तापनि वा थाहा नै नपाए तापनि र त्यो कार्य गर्दा कसैले नपक्रे तापनि र त्यसको विरुद्ध कोही नभए तापनि, त्यसकी पत्‍नी अशुद्ध भएकी छे भन्‍ने डाहको आत्माले थाहा देला । तथापि पत्‍नी अशुद्ध नभएको हुँदा पनि डाहको गलत विचार आउन सक्ला । ");
INSERT INTO npiulb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","यस अवस्थामा त्यो मानिसले आफ्नी पत्‍नीलाई पुजारीकहाँ ल्याउनुपर्छ । पतिले त्यसको तर्फबाट आवश्यक पर्ने बलिदान अर्थात् आधा पाथी जौको पिठो ल्याउनुपर्छ । उसले यसमा तेल हाल्नुहुँदैन र कुनै सुगन्धित मसला हाल्नुहुँदैन, किनभने यो डाहको अन्‍नबलि अर्थात् अपराध याद दिलाउनेको चढाइएको अन्‍नबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","पुजारीले त्यस स्‍त्रीलाई नजिक ल्याउनुपर्छ र त्यसलाई परमप्रभुको सामु राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","पुजारीले पवित्र पानीको भाँडो लिनुपर्छ र पवित्र वासस्थानको भुइँबाट धूलो लिनुपर्छ । त्यसले त्यो धूलोलाई त्यो पानीमा हाल्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","पुजारीले त्यो महिलालाई परमप्रभुको सामु खडा गर्नेछ र त्यसले त्यो महिलाका कपाल फुलाइदिनेछ । त्यसले त्यो सम्झनाको अन्‍नबलिलाई त्यसको हातमा राख्‍नेछ, जुन सन्देहको अन्‍नबलि हो । ");
INSERT INTO npiulb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","पुजारीले श्राप ल्याउन सक्‍ने तितो पानीलाई त्यसको हातमा राख्‍नेछ । पुजारीले त्यस महिलालाई शपथ खान लगाओस् र त्यसलाई यसो भनोस्, 'यदि अरू कुनै पुरुषले तँसँग यौन सम्बन्ध राखेको छैन भने र यदि तँ बरालिएर गएको छैनस् र अपराध गरेको छैन भने, तँ श्राप ल्याउने यो तितो पानीबाट मुक्‍त हुनेछस् । ");
INSERT INTO npiulb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","तर यदि पतिको अधीनमा भएकी तँ बरालिएकी छस्, यदि तँ अशुद्ध भएकी छस् र यदि अरू कुनै पुरुष तँसँग सुतेको छ भने, ");
INSERT INTO npiulb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(पुजारीले त्यो महिलामाथि श्राप ल्याउन सक्‍ने शपथ खान लगाउनुपर्छ र त्यसले महिलालाई भनिरहोस्) 'परमप्रभुले तँलाई श्रापित तुल्याउनुभएको होस् जुन तेरा मानिसहरूलाई देखाइनेछ । यदि परप्रभुले तेरो जाँघ सुक्‍ने तुल्याउनुभयो र तेरो पेट सुनिने तुल्याउनुभयो भने, यसै होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","श्राप ल्याउने यो पानी तेरो पेटभित्र जानेछ र तेरो पेट सुनिनेछ र तेरो जाँघ सुक्‍ने छ । त्यो महिलाले 'हो, म दोषी छु भने यस्तै होस्' भनी जवाफ दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","पुजारीले यी श्रापहरूलाई मुट्ठोमा लेख्‍नुपर्छ, र ती लेखिएका श्रापहरूलाई त्यो तितो पानीमा धुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","पुजारीले श्राप ल्याउने त्यो तितो पानी त्यो महिलालाई पिउन लगाउनुपर्छ । त्यो पानी त्यसभित्र जाने छ र तितो तुल्याउनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","पुजारीले महिलाको हातबाट डाहको अन्‍नबलि लिनुपर्छ । उसले परप्रभुको सामु अन्‍नबलिलाई डोलाउनुपर्छ र यसलाई वेदीमा ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","पुजारीले अन्‍नबलिबाट एक मुट्ठी लिएर यसलाई वेदीमा जलाउनुपर्छ । त्यसपछि त्यसले महिलालाई त्यो तितो पानी पिउन दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","त्यसले त्यसलाई पानी पिउन दिँदा त्यसले आफ्नो पति विरुद्ध पाप गरेकोले यदि त्यो अशुद्ध भएकी छे भने, त्यो श्राप ल्याउने पानी त्यसभित्र जानेछ र तितो तुल्याउनेछ । त्यसको पेट फुलिनेछ र त्यसको जाँघ सुक्‍नेछ । त्यो महिला आफ्ना मानिसहरूबिच श्रापित हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","तर यदि महिला अशुद्ध भएकी छैन भने र त्यो शुद्ध छे भने, त्यो स्वतन्त्र हुने छे । त्यसले बालक जन्माउन सक्‍ने छे । ");
INSERT INTO npiulb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","डाहको नियम यही हो । आफ्नो पतिबाट बरालिने र अशुद्ध हुने महिलाको नियम यही हो । ");
INSERT INTO npiulb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","आफ्नी पत्‍नीप्रति डाही हुँदा डाहको आत्मा भएको पुरुषको निम्ति नियम यही हो । उसले महिलालाई परमप्रभुको सामु ल्याउनुपर्छ र पुजारी डाहको व्यवस्थाले वर्णन गरेका सबै थोक गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","पुरुष आफ्‍नी पत्‍नीलाई पुजारीकहाँ ल्याएको दोषबाट मुक्‍त हुनेछ । महिलाले त्यसको कुनै पनि दोष भोग्‍नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इस्राएलका मानिसहरूलाई भन् । 'जब कुनै पुरुष वा महिलाले आफूलाई परमप्रभुको निम्ति नाजिरीको विशेष भाकलले अलग गर्छ, ");
INSERT INTO npiulb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","त्यसले आफूलाई दाखमद्य र कडा मद्यबाट अलग राख्‍नुपर्छ । त्यसले दाखमद्य वा कडा मद्यबाट बनाइएको सिर्का पिउनुहुँदैन । त्यसले कुनै किसिमको दाखरस पिउनुहुँदैन अथवा ताजा वा सुकाएको दाख खानुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","त्यसले आफूलाई मेरो निम्ति अलग गरेका सबै दिनमा त्यसले दाखको बोक्राबाट बनाइएका सबै थोकलगायत दाखबाट बनाइएका कुनै पनि कुरा खानुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","अलग हुने त्यसको समय अवधिभर परमप्रभुप्रति अलग रहने त्यसको भाकल पुरा नभएसम्म त्यसको शिरमा कुनै किसिमको छुरा प्रयोग गर्नुहुँदैन । त्यो परमप्रभुको निम्ति अलग हुनुपर्छ । त्यसले कपाललाई आफ्नो शिरमा लामो हुन दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","त्यसले आफूलाई परमप्रभुको निम्ति अलग राखेको पुरै समयभरि त्यो मुर्दाको नजिक आउनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","आफ्नै बुबा, आमा, दाजुभाइ, दिदीबहिनी मरे भने पनि त्यसले तिनीहरूका निम्ति पनि आफूलाई अशुद्ध पार्नुहुँदैन । सबैले त्यसको कपाल देख्‍न सक्‍नेजस्तै यो त्यसले आफूलाई परमेश्‍वरप्रति अलग गरेको कारणले हो । ");
INSERT INTO npiulb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","त्यो अलग रहेको पुरै समयभरि त्यो पवित्र अर्थात् परमप्रभुको निम्ति आरक्षित हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","यदि कोही त्यसको सामु अचानक मर्छ र त्यसले अर्पण गरेको शिरलाई अशुद्ध बनायो भने, त्यसपछि त्यसले शुद्धिकरणको दिनमा आफ्नो कपाल खौरनुपर्छ, त्यसले यसलाई सातौँ दिनमा खौरनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","त्यसले आठौँ दिनमा दुईवटा परेवा वा दुईवटा परेवाका बचेरा भेट हुने पालको प्रवेश-द्वारमा पुजारीकहाँ ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","पुजारीले एउटा चरालाई पापबलिको रूपमा र अर्कोलाई होमबलिको रूपमा चढाउनुपर्छ । यिनीहरूले त्यसको पापको प्रायश्‍चित्त गर्ने छन्, किनभने मुर्दाको नजिक परेर त्यसले पाप गर्‍यो । त्यसले त्यस दिन आफ्नो शिर शुद्ध पार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","त्यसले आफ्नो शुद्धिकरणको दिनको निम्ति परमप्रभुको निम्ति आफूलाई अलग गर्नुपर्छ । त्यसले एक वर्षे थुमालाई दोषबलिको रूपमा ल्याउनुपर्छ । त्यसले आफूलाई अशुद्ध पारेका दिनहरू गन्‍नुहुँदैन, किनभने त्यसले अशुद्ध पार्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","नाजिरीको अलग हुने समय पुरा हुनेको निम्ति नाजिरीको नियम यही हो । त्यसलाई भेट हुने पालको प्रवेश-द्वारमा ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","त्यसले आफ्नो बलि परमप्रभुलाई चढाउनुपर्छ । त्यसले एक वर्षको खोटरहित एउटा थुमालाई होमबलिको रूपमा चढाउनुपर्छ । त्यसले एक वर्षको खोटरहित पाठीलाई पापबलिको रूपमा चढाउनुपर्छ । त्यसले एउटा खोटरहित थुमालाई मेलबलिको रूपमा ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","त्यसले तिनीहरूका अन्‍नबलि र अर्घबलिसँगै एक डालो अखमिरी रोटी, तेलले मिसाएको फुरौलाहरू, तेल दलेको अखमिरी बाबरहरू ल्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","पुजारीले तिनीहरूलाई परप्रभुको सामु चढाउनुपर्छ । त्यसले आफ्ना पापबलि र होमबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","अखमिरी रोटीको डालोसँगै त्यसले थुमालाई बलि अर्थात् मेलबलिको रूपमा चढाउनुपर्छ । पुजारीले अन्‍नबलि र अर्घबलि पनि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","नाजिरीले आफू अलग रहेको सङ्केत गर्न भेट हुने पालको प्रवेश-द्वारमा आफ्नो शिर खौरनुपर्छ । त्यसले आफ्नो शिरको कपाल लिएर मेल बलिको आगोमा जलाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","पुजारीले थुमाको उमालेको कुम, अखमिरी रोटीको डालोबाट एउटा रोटी र अखमिरी बाबर लिनुपर्छ । त्यसले तिनीहरूलाई आफू अलग रेहेको सङ्केत गर्ने कपाल खौरेको नाजिरीका हातमा राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","पुजारीले तिनीहरूलाई डोलाइएको ह्याकुलो र पुजारीलाई दिइएको साप्रोसँगै पुजारीको निम्ति पवित्र हिस्सा परमप्रभुको सामु बलिको रूपमा डोलाउनुपर्छ । त्यसपछि नाजिरीले दाखमद्य पिउन सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","नाजिरीको निम्ति नियम यही हो जसले आफू अलग हुनको निम्ति परमप्रभुको निम्ति आफ्नो बलिदानको भाकल गर्छ । त्यसले अरू जे दिन पनि, त्यसले भाकल गरेका कर्तव्यहरू अर्थात् नाजिरीको निम्ति नियमद्वारा दर्शाइएको प्रतिज्ञा पालन गर्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","फेरि परमप्रभुले मोशालाई बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून र त्यसका छोराहरूलाई भन् । 'तिमीहरूले इस्राएलका मानिसहरूलाई यसरी आशिष् दिनुपर्छ । तिमीहरूले तिनीहरूलाई यसो भन्‍नुपर्छ, ");
INSERT INTO npiulb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","'परप्रभुले तिमीहरूलाई आशिष् दिनुभएको होस् र रक्षा गर्नुभएको होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","परमप्रभुले उहाँको मुहार तिमीहरूमाथि चम्काउनुभएको होस् र तिमीहरूप्रति कृपालु हुनुभएको होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","परमप्रभुले तिमीहरूमाथि कृपादृष्‍टिले हेर्नुभएको होस् र तिमीहरूलाई शान्ति दिनुभएको होस् ।' ");
INSERT INTO npiulb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","तिनीहरूले इस्राएलका मानिसहरूलाई मेरो नाउँ यसरी दिनुपर्छ । अनि म तिनीहरूलाई आशिष् दिनेछु । ");
INSERT INTO npiulb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","मोशाले पवित्र वासस्थान पुरा गरेका दिन तिनले यसलाई यसका सबै सरसामानसँगै परमप्रभुको निम्ति अलग गरे । तिनले यसका भाँडाकुँडाहरूलाई पनि त्यसै गरे । तिनले तिनीहरूलाई पनि अभिषेक गरे र परप्रभुको निम्ति अर्पण गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","त्यस दिन इस्राएलका अगुवाहरू, तिनीहरूका आ-आफ्ना पुर्खाहरूका परिवारका मुखियाहरूले बलिदानहरू चढाए । यी मानिसहरू कुलका प्रमुखहरू थिए । तिनीहरूले पुरुषहरूको जनगणनाको देखरेख गरेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","तिनीहरूले आफ्‍ना बलिदानहरू परमप्रभुको सामु ल्याए । तिनीहरूले छोपिएका छवटा गाडा र बाह्रवटा गोरु ल्याए । तिनीहरूले दुई-दुई जना अगुवाको निम्ति एउटा गाडा र हरेक अगुवाले एउटा-एउटा गोरु ल्याए । तिनीहरूले यी थोकहरूलाई पवित्र वासस्थानको सामु चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“तिनीहरूले चढाएका बलिहरू स्वीकार गर् र तिनीहरूलाई भेट हुने पालको कामको निम्ति प्रयोग गर् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","मोशाले गाडाहरू र गोरुहरू लिएर तिनले ती लेवीहरूलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","तिनले दुईवटा गाडा र चारवटा गोरु तिनीहरूका कामलाई आवश्यक पर्ने हुनाले गेर्शोनका सन्तानहरूलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","तिनले चारवटा गाडा र आठवटा गोरु पुजारी हारूनका छोरा ईतामारको देखरेखमा भएका मरारीहरूका सन्तानहरूलाई दिए । यो तिनीहरूका कामलाई आवश्‍यक पर्ने भएकोले तिनले यसो गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","तर तिनले कहातका सन्तानहरूलाई ती कुनै पनि कुरा दिएनन्, किनभने तिनीहरूका कामहरू परमप्रभुसँग सम्बन्धित थियो जसलाई तिनीहरूले आ-आफ्ना काँधहरूमाथि बोक्‍नुपर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","मोशाले वेदीलाई अभिषेक गरेका दिन अगुवाहरूले वेदीको अर्पणको निम्ति आ-आफ्ना सामानहरू चढाए । अगुवाहरूले वेदीको सामु भेटीहरू चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","परमप्रभुले मोशालाई भन्‍नुभयो, “हरेक अगुवाले वेदीको समर्पणको निम्ति आ-आफ्नो दिनमा आ-आफ्नो भेटीहरू चढाउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","पहिलो दिनमा, यहूदाको कुलका अम्मीनादाबका छोरा नहशोनले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो अम्मीनादाबका छोरा नहशोनको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दोस्रो दिनमा इस्साखारका अगुवा सूआरका छोरा नतनेलले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो सूआरका छोरा नतनेलको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तेस्रो दिनमा जबूलूनका सन्तानहरूका अगुवा हेलोनका छोरा एलीआबले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो हेलोनका छोरा एलीआबको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथो दिनमा, रूबेनका सन्तानहरूका अगुवा शदेऊरका छोरा एलीसूरले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो शदेऊरका छोरा एलीसूरको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पाँचौ दिनमा, शिमियोनका सन्तानहरूका अगुवा सूरीशद्दैका छोरा शलूमीएलले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो सूरीशद्दैका छोरा शलूमीएलको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","छैठौँ दिनमा गादका सन्तानहरूका अगुवा दूएलका छोरा एल्यासापले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो दूएलका छोरा एल्यासापको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातौँ दिनमा एफ्राइमका सन्तानहरूका अगुवा अम्मीहूदका छोरा एलीशामाले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो अम्मीहूदका छोरा एलीशामाको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठौँ दिनमा मनेश्‍शेका सन्तानहरूका अगुवा पदासूरका छोरा गमलिएलले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो पदासूरका छोरा गमलिएलको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नवौँ दिनमा बेन्यामीनका सन्तानहरूका अगुवा गिदेओनीका छोरा अबीदानले आफ्नो भेटी चढाए । चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","यो गिदेओनीका छोरा अबीदानको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दसौँ दिनमा दानका सन्तानहरूको अगुवा अम्मीशद्दैका छोरा अहीएजेरले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो अम्मीशद्दैका छोरा अहीएजेरको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","एघारौँ दिनमा आशेरका सन्तानहरूका अुगवा ओक्रानका छोरा पगीएलले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए ");
INSERT INTO npiulb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","। तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो अम्मीनादाबका छोरा नहशोनको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बाह्रौँ दिनमा नप्‍तालीका सन्तानहरूका अगुवा एनानका छोरा अहीराले आफ्नो भेटी चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","तिनको भेटी पवित्र स्थानको तौलको मापदण्डअनुसार एक सय तिस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौल भएको एउटा चाँदीको बाटा थियो । यी दुवै नै अन्‍नबलिको निम्‍ति तेलमा मुछेको पिठोले भरिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","तिनले दस शेकेल तौलको धूपले भरिएको एउटा सुनको धुपौरो दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","तिनले होमबलिको रूपमा एउटा बाछो, एउटा भेडा र एउटा एक वर्षे थुमा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","तिनले पापबलिको रूपमा एउटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","तिनले दुईवटा गोरु, पाँचवटा भेडा, पाँचवटा बाख्रा र एक वर्षे पाँचवटा थुमा दिए । यो इनानका छोरा अहीराको भेटी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","मोशाले वेदी अभिषेक गरेका दिन इस्राएलका अगुवाहरूले यी सबै थोक चढाए । तिनीहरूले बाह्रवटा चाँदीका थाल, बाह्रवटा बाटार बाह्रवटा सुनका धुपौरा चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","हरेक चाँदीको थाल एक सय तिस शेकेल तौलको र हरेक बाटा सत्तरी शेकेल तौलको थियो । चाँदीका सबै भाँडाकुँडाको तौल पवित्र स्थानको शेकेलको तौलको मापदण्डअनुसार २,४०० शेकेल थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","धूपले भरिएका हरेक सुनका धुपौराहरूको तौल पवित्र स्थानको मापदण्डअनुसार दस शेकेलको थियो । सबै सुनका धुपौराहरूको तौल एक सय बिस शेकेल थियो । ती सबै जनावरहरू अर्थात् बाह्रवटा गोरु, बाह्रवटा भेडा, बाह्रवटा एक वर्षे थुमालाई होमबलिको निम्ति अलग गरियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","तिनीहरूले आ-आफ्ना अन्‍नबलि चढाए । तिनीहरूले पापबलिको रूपमा बाह्रवटा बाख्रा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","तिनीहरूका सबै गाईवस्तुबाट तिनीहरूले चौबिसवटा साँढे, साठीवटा भेडा, साठीवटा बाख्रा, साठीवटा एक वर्षे थुमालाई मेलबलिको निम्ति बलिदानको रूपमा दिए । यो वेदीलाई अभिषेक गरेपछि वेदीको समर्पणको निम्ति थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जब मोशा परमप्रभुसँग कुरा गर्न भेट हुने पालभित्र गए, तिनले उहाँको बलिरहेको आवाज सुने । परमप्रभु दुईवटा करूबको बिचबाट गवाहीको सन्दूकमाथि रहेको कृपा-आसनमाथिबाट तिनीसित बोल्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारूनलाई भन् । 'तैँले सातवटा बत्ती बाल्दा तिनीहरूले सामदानको अघिल्तिर प्रकाश दिनुपर्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","हारूनले यसै गरे । परमप्रभुले आज्ञा गर्नुभएझैँ हारूनले सामदान अघिल्तिर प्रकाश दिनलाई बत्तीहरू बाले । ");
INSERT INTO npiulb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","सामदान यस किसिमले बनाइएको थियो र परमप्रभुले मोशालाई यसको निम्ति नमुना देखाउनुभयो । यो आधारदेखि टुप्‍पोसम्म फूलजस्ता कचौरालाई पिटेको सुनको हुनुपर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","फेरि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“लेवीहरूलाई इस्राएलका मानिसहरूबाट ले र तिनीहरूलाई शुद्ध पार् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","तिनीहरूलाई शुद्ध पार्न यसो गर्ः तिनीहरूमाथि प्रायश्‍चित्तको पानी छर्किदे । तिनीहरूको पुरै शरीर, तिनीहरूको लुगा धुन लगा र यसरी तिनीहरूलाई शुद्ध पार् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","त्यसपछि तिनीहरूलाई एउटा बाछो र तेलले मुछेको मसिनो पिठोको अन्‍नबलि ल्याउन लगा । तिनीहरूले पापबलिको रूपमा अर्को एउटा बाछो पनि ल्याऊन् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","तैँले लेवीहरूलाई भेट हुने पालको अघि ल्यानेछस् र इस्राएलका मानिसहरूको सारा समुदाय भेला हुनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","तैँले लेवीहरूलाई परमप्रभुको सामु ल्याउँदा इस्राएलका मानिसहरूले आफ्नो हात लेवीहरूमाथि राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","हारूनले लेवीहरूलाई इस्राएलका मानिसहरूको तर्फबाट डोलाइने बलिको रूपमा चढाउनुपर्छ, ताकि तिनीहरूले परमप्रभुको सेवाको काम गरून् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","लेवीहरूले साँढेहरूमाथि तिनीहरूका हात राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","तैँले लेवीहरूका प्रायश्‍चित्तको निम्ति एउटा साँढेलाई पापबलिको रूपमा र अर्कोलाई होमबलिको रूपमा चढाउनुपर्छ । तैँले लेवीहरूलाई हारून र त्यसका छोराहरूको सामु ले र तिनीहरूलाई डोलाइने बलिको रूपमा चढा । ");
INSERT INTO npiulb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","१तैँले लेवीहरूलाई इस्राएलका मानिसहरूबाट यसरी अलग गर् । लेवीहरू मेरा हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","त्यसपछि लेवीहरू भेट हुने पालमा सेवा गर्न जानुपर्छ । तैँले तिनीहरूलाई शुद्ध पार्नुपर्छ । तैँले तिनीहरूलाई डोलाइने बलिको रूपमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","यसो गर्, किनभने तिनीहरू इस्राएलका मानिसहरूबाट पूर्ण रूपमा मेरा हुन् । तिनीहरूले गर्भ खोल्ने इस्राएलका सबै सन्तानका पहिले जन्मेका हरेक पुरुष बालकको स्थान लिनेछन् । मैले लेवीहरूलाई आफ्नै निम्ति लिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएलका मानिसहरूको पशु र मानिस दुवैबाट पहिले जन्मेकाहरू सबै मेरा हुन् । मैले मिश्र देशमा तिनीहरूका सबै पहिले जन्मेकाहरूलाई लिएको दिन नै मैले तिनीहरूलाई आफ्नै निम्ति अलग गरेँ । ");
INSERT INTO npiulb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","मैले लेवीहरूलाई इस्राएलका मानिसहरूबाट सबै पहिले जन्मेकाहरूको सट्टामा लिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","मैले लेवीहरूलाई हारून र त्यसका छोराहरूलाई उपहारको रूपमा दिएको छु । मैले तिनीहरूलाई इस्राएलका मानिसहरूबाट भेट हुने पालमा इस्राएलका मानिसहरूको काम गर्नलाई लिएको छु । मैले तिनीहरूलाई इस्राएलका मानिसहरूका निम्ति प्रायश्‍चित्त गर्नलाई दिएको छु, ताकि तिनीहरू पवित्र स्थानको नजिक आउँदा मानिसहरूमाथि कुनै विपत्ति नआओस् । ");
INSERT INTO npiulb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","मोशा, हारून र इस्राएलका मानिसहरूका सारा समुदायले लेवीसँगै यो गरे । परमप्रभुले लेवीबारे मोशालाई आज्ञा दिनुभएबमोजिम तिनीहरूले सबै थोक गरे । इस्राएलका मानिसहरूले तिनीहरूसँग यसै गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवीहरूले आफैलाई शुद्ध पारे र आ-आफ्ना लुगाहरू धोए, अनि हारूनले तिनीहरूलाई परमप्रभुको निम्ति डोलाइने बलिको रूपमा चढाए र तिनले तिनीहरूलाई शुद्ध पार्न तिनीहरूको निम्ति प्रायश्‍चित्त गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","त्यसपछि लेवीहरू हारून र तिनका छोराहरूको अधीनमा रहेर तिनीहरूको काम गर्न भेट हुने पालभित्र गए । यो परमप्रभुले लेवीहरूको बारेमा मोशालाई आज्ञा गर्नुभएअनुसार थियो । तिनीहरूले सबै लेवीलाई यसो गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“यो सबै पच्‍चिस वर्ष र त्यसभन्दा माथिका लेवीहरूका निम्ति हो । तिनीहरू भेट हुने पालमा सेवा गर्न दलमा सहभागी हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","तिनीहरू पचास वर्षको भएपछि यसरी सेवा गर्न छोड्नुपर्छ । त्यस उमेरमा तिनीहरूले सेवा गर्नुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","तिनीहरूले भेट हुने पालमा सेवा गरिरहने तिनीहरूका भाइहरूलाई सहायता गर्न सक्छन्, तर तिनीहरूले सेवा गर्नुहुँदैन । तैँले लेवीहरूलाई यी कुराहरूमा निर्देशन दिनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","तिनीहरू मिश्र देशबाट आएका दोस्रो वर्षको पहिलो महिनामा सीनै मरुभूमिमा परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएलका मानिसहरूले निस्तार-चाड यसको निर्धारित समयमा नै मानून् । ");
INSERT INTO npiulb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","यो महिनाको चौधौँ दिनको साँझ, तिमीहरूले निस्तार-चाडलाई यसको निर्धारित समयमा नै मान्‍नू । तिमीहरूले यसलाई पालन गर्नुपर्छ, यससँग सम्बन्धित सबै आदेशहरू पालन गर्नुपर्छ र सबै नियमहरू अनुसरण गर्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","यसैले मोशाले इस्राएलका मानिसहरूले निस्तार-चाडलाई मान्‍नुपर्छ भनी तिनीहरूलाई बताए । ");
INSERT INTO npiulb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","तिनीहरूले सीनैको मरुभूमिमा पहिलो महिनाको चौधौँ दिनको साँझमा निस्तार-चाड मनाए । परमप्रभुले मोशालाई आज्ञा गर्नुभएका सबै कुरा इस्राएलका मानिसहरूले पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","मुर्दा छोएको कारण केही मानिसहरू अशुद्ध भएका थिए । तिनीहरूले त्यस दिन निस्तार-चाड मान्‍न सकेनन् । तिनीहरू त्यसै दिन मोशा र हारूनकहाँ गए । ");
INSERT INTO npiulb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ती मानिसहरूले मोशालाई भने, “हामी मुर्दा छोएको कारण अशुद्ध भएका छौँ । इस्राएलका मानिसहरूमाझ निर्धारित समयमा नै परमप्रभुलाई बलिदान चढाउनबाट हामीलाई किन वञ्‍चित गर्नुहुन्छ ?” ");
INSERT INTO npiulb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशाले तिनीहरूलाई भने, “पर्ख, परमप्रभुले तिमीहरूबारे के भन्‍नुहुन्छ, म सुन्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएलका मानिसहरूलाई भन् । 'यदि तिमीहरूमध्ये कोही मुर्दा छोएको कारण अशुद्ध छ वा लामो यात्रामा छ भने, त्यसले परमप्रभुको निस्तार-चाड अझै मान्‍न सक्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","तिनीहरूले दोस्रो महिनाको चौधौँ दिनको साँझ निस्तार-चाड मान्‍नेछन् । तिनीहरूले निस्तार-चाडको थुमालाई अखमिरी रोटी र तितो सागसँग खानुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","तिनीहरूले यसलाई बिहानसम्म राख्‍नुहुँदैन वा यसका हाडहरू भाँच्‍नुहुँदैन । तिनीहरूले निस्तार-चाडका सबै नियम पालन गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","तर कुनै व्यक्‍ति शुद्ध छ र यात्रामा छैन, अनि निस्तार-चाड मान्दैन भने परमप्रभुले आज्ञा गर्नुभएको निर्धारित समयमा त्यसले बलिदान नचढाएकोले त्यसलाई त्यसका मानिसहरूबाट बहिष्कार गर्नुपर्छ । त्यस मानिसले आफ्नो पाप भोग्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","यदि कुनै विदेशी तिमीहरूसँग बसोबास गर्छ र परमप्रभुको आदरमा निस्तार-चाड मान्‍छ भने, त्यसले यसलाई पालन गर्नुपर्छ र निस्तार-चाडका सबै नियम पालन गरेर उहाँले आज्ञा गर्नुभएका सबै थोक गर्नुपर्छ र यसको निम्ति सबै नियम पालन गर्नुपर्छ । विदेशी र स्वदेशी सबैको निम्ति उही नियम हुनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","पवित्र वासस्थान खडा गरेको दिन पवित्र वासस्थान अर्थात् करारको आदेशको पाललाई बादलले ढाक्यो । साँझमा बादल पवित्र वासस्थानमाथि थियो । यो बिहानसम्म आगोजस्तो देखियो । ");
INSERT INTO npiulb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","यो यसरी नै रहिरह्यो । बादलले पवित्र वासस्थान ढाक्यो र राती आगोजस्तो देखा पर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जब-जब बादल पालबाट हट्थ्यो, इस्राएलका मानिसहरू आफ्नो यात्राको निम्ति अघि बढ्थे । जहाँ-जहाँ बादल रोकिन्थ्यो, त्यहाँ मानिसहरूले छाउनी लगाउँथे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","इस्राएलका मानिसहरू परमप्रभुको आज्ञामा नै यात्रा गर्थे र उहाँकै आज्ञामा छाउनी लगाउँथे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","बादल पवित्र वासस्थानमाथि रहँदा तिनीहरू रोकिन्थे, तिनीहरू छाउनीमा बस्थे । बादल पवित्र वासस्थानमाथि धेरै दिनसम्म रहँदा इस्राएलका मानिसहरूले परमप्रभुको आज्ञा पालन गर्थे र यात्रा गर्दैनथे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कहिले काहीँ बादल पवित्र वासस्थानमाथि केही दिन मात्र रहन्थ्यो । त्यस अवस्थामा तिनीहरूले परमप्रभुको आज्ञा पालन गर्थे । तिनीहरूले छाउनी लगाउँथे र उहाँको आज्ञामा फेरि यात्रा गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कहिले काहीँ बादल छाउनीमा साँझदेखि बिहानसम्म मात्र रहन्थ्यो । बिहान बादल हट्दा तिनीहरूले यात्रा गर्थे । यदि बादल एक दिन वा एक रातको निम्ति मात्र रहेमा, बादल हट्दा मात्र तिनीहरूले यात्रा गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","बादल पवित्र वासस्थानमाथि दुई दिनको, एक महिना वा एक वर्षको निम्ति वा जति समयसम्म रहे पनि इस्राएलका मानिसहरू छाउनीमा रहन्थे र यात्रा गर्दैनथे । तर जब-जब बदल हट्थ्यो, तिनीहरूले यात्रा गर्थे । ");
INSERT INTO npiulb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","तिनीहरूले परमप्रभुको आज्ञामा नै छाउनी लगाउँथे र तिनीहरूले उहाँको आज्ञामा नै यात्रा गर्थे । मोशाद्वारा दिइएको परमप्रभुको आज्ञा तिनीहरूले पालन गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“चाँदीका दुईवटा तुरही बना । चाँदीलाई पिटेर तिनीहरूलाई बना । तैँले तुरहीलाई समुदायलाई भेला हुन बोलाउन र तिनीहरूका छाउनी सार्न समुदायलाई बोलाउन प्रयोग गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","भेट हुने पालको प्रवेश-द्वारमा तेरो अघि भेला हुन समुदायलाई बोलाउन पुजारीले तुरहीहरू फुक्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","यदि पुजारीले एउटा मात्र तुरही फुक्यो भने, अगुवाहरू अर्थात् इस्राएलका कुलका प्रमुखहरू तँकहाँ आउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","तैँले ठुलो आवाजमा सङ्केत दिँदा पूर्वतिरका छाउनीहरूले आफ्नो यात्रा सुरु गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","दोस्रो पटक ठुलो आवाजमा सङ्केत गर्दा दक्षिणतिरका छाउनीहरूले तिनीहरूको यात्रा सुरु गर्नुपर्छ । तिनीहरूका यात्राको निम्ति तिनीहरूले ठुलो आवाजमा सङ्केत दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","समुदाय सँगै भेला हुँदा तुरही फुक, तर ठुलो आवाजमा होइन । ");
INSERT INTO npiulb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","हारूनका छोराहरू अर्थात् पुजारीहरूले तुरही फुक्‍नुपर्छ । यो तिमीहरूलाई मानिसहरूका पुस्तौँ-पुस्तासम्म सदैवको निम्ति नियम हुनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","तिमीहरूलाई अत्याचार गर्ने शत्रुको विरुद्ध आफ्नो मुलुकमा तिमीहरू युद्ध गर्न जाँदा, तिमीहरूले तुरहीसँगै जनाउँ-ध्वनि दिनुपर्छ । म परमप्रभु तिमीहरूका परमेश्‍वरले सम्झने छु र तिनीहरूलाई तिमीहरूका शत्रुहरूबाट बचाउने छु । ");
INSERT INTO npiulb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","साथै नियमित चाड र महिनाको सुरुवात दुवै किसिमको उत्सवको समयमा, तिमीहरूले आफ्नो होमबलि र मेलबलि चढाउँदा तुरही बजाउनुपर्छ । यिनीहरूले म परमप्रभु तिमीहरूका परमेश्‍वरलाई याद दिलाउने छन् । म तिमीहरूका परमप्रभु परमेश्‍वर हुँ ।” दोस्रो वर्षको ");
INSERT INTO npiulb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","दोस्रो महिनाको बिसौँ दिनमा करारका आदेशहरूका पवित्र वासस्थानबाट हट्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","त्यसपछि इस्राएलका मानिसहरू सीनैको मरुभूमिबाट आफ्नो यात्रामा लागे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","बादल पारानको मरुभूमिमा रोकियो । मोशाद्वारा दिइएको परमप्रभुको आज्ञा पालन गरेर तिनीहरूले पहिलो यात्रा गरे । यहूदाका सन्तानहरूका झन्डामुनिका छाउनीले आ-आफ्ना फौज लिएर पहिलो लश्करमा हिँडे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","यहूदाको फौजको नेतृत्व अम्मीनादाबका छोरा नहशोनले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","इस्साखारका सन्तानहरूका फौजको नेतृत्व सूआरका छोरा नतनेलले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","जबूलूनका सन्तानहरूका फौजको नेतृत्व हेलोनका छोरा एलीआबले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","पवित्र वासस्थानको देखरेख गर्ने गेर्शोन र मरारीका सन्तानहरूले पवित्र वासस्थान उठाए र आफ्नो यात्रामा हिँडे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","फेरि, रूबेनको छाउनीको झन्डामुनिका फौजले यात्रा सुरु गरे । रूबेनको फौजको नेतृत्व शदेऊरका छोरा एलीसूरले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","शिमोयोनका सन्तानहरूका फौजको नेतृत्व सूरीशद्दैका छोरा शलूमीएलले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","गादका सन्तानहरूका फौजको नेतृत्व दूएलका छोरा एल्यासापले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","कहातीहरू हिँडे । तिनीहरूले पवित्र स्थानका पवित्र सामानहरू बोके । अरूहरूले कहातीहरू अर्को छाउनीमा नआइपुग्दै पवित्र वासस्थान खडा गर्थे । त्यसपछि एफ्राइमका सन्तानहरूका झन्डामुनिका फौज हिँडे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","एफ्राइमको फौजको नेतृत्व अम्मीहूदका छोरा एलीशामा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","मनश्‍शेका सन्तानहरूका फौजको नेतृत्व पदासूरका छोरा गमलिएलले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","बेन्यामीनका सन्तानहरूका कुलको फौजको नेतृत्व गिदेओनीका छोरा अबीदानले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","दानको सन्तानहरूका झन्डामुनि छाउनी लगाएका फौज अन्तिममा हिँडे । दानको फौजको नेतृत्व अम्मीशद्दैका छोरा अहीएजेरले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","आशेरका सन्तानहरूका कुलको फौजको नेतृत्व ओक्रानका छोरा पगीएलले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","नप्‍तालीका सन्तानहरूका कुलको फौजको नेतृत्व एनानका छोरा अहीराले गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","इस्राएलका मानिसहरूका फौजले यसरी आफ्नो यात्रा सुरु गर्‍यो । मोशाले मिद्यानी रूएलका छोरा होबाबसँग कुरा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","रूएल मोशाका ससुरा थिए । मोशाले होबाबसँग कुरा गरे र भने, “हामी परमप्रभुले भन्‍नुभएको ठाउँतिर यात्रा गरिरहेका छौँ । परमप्रभुले भन्‍नुभयो, 'म यो तिमीहरूलाई दिने छु ।' हामीसँगै आउनुहोस् र हामीले तपाईंलाई असल गर्ने छौँ । परमप्रभुले इस्राएलको निम्ति असल गर्ने प्रतिज्ञा गर्नुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","तर होबाबले मोशालाई भने, “म तिमीहरूसँग जाँदिनँ । म मेरो आफ्नै मुलुकतिर र मेरा आफ्नै मानिसहरूकहाँ जाने छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","त्यसपछि मोशाले जवाफ दिए, “कृपया, हामीलाई नछोड्नुहोस् । मरुभूमिमा कसरी छाउनी लगाउने भनी तपाईंलाई थाहा छ । तपाईंले हाम्रो हेरचाह गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","यदि तपाईं हामीसँग जानुभयो भने परमप्रभुले हामीलाई असल गर्नुभएझैँ हामी तपाईंको निम्ति असल नै गर्नेछौँ ।” तिनीहरूले परमप्रभुको पर्वतबाट तिन दिनसम्म यात्रा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","तिनीहरूको निम्ति विश्राम गर्ने ठाउँ पत्ता लगाउन परमप्रभुको करारको सन्दूक तिन दिनसम्म तिनीहरूको अघि-अघि लगियो । ");
INSERT INTO npiulb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","तिनीहरूले यात्रा गर्दा परमप्रभुको बादल दिनमा तिनीहरूसँग थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","जब-जब सन्दूक उठाइन्थ्यो मोशाले यसो भन्थे, “हे परमप्रभु, उठ्नुहोस् । तपाईंका शत्रुहरूलाई तितरबितर पार्नुहोस् । तपाईंलाई घृणा गर्नेहरूलाई तपाईंदेखि भाग्‍न लगाउनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","जब-जब सन्दूक रोकिन्थ्यो, मोशाले यसो भन्थे, “हे परमप्रभु, हजारौँ हजार इस्राएलतिर फर्कनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","यस बेला परमप्रभुले सुन्‍ने गरी मानिसहरूले तिनीहरूका कष्‍टबारे गनगन गरे । परमप्रभुले मानिसहरूको गनगन सुन्‍नुभयो र रिसाउनुभयो । परमप्रभुबाट आगो दन्कियो र यसका किनाराका केही छाउनीहरू जले । ");
INSERT INTO npiulb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","अनि मानिसहरूले मोशासँग बिन्ती गरे । यसैले मोशाले परमप्रभुसँग प्रार्थना गरे, र आगो रोकियो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","त्यस ठाउँको नाउँ तबेरा राखियो, किनभने परमप्रभुको आगो मानिसहरूमाझ दन्कियो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","केही विदेशीहरू इस्राएलका सन्तानहरूसँग छाउनीमा बस्‍न थाले । तिनीहरूले मिठो खानेकुरा खाने इच्छा गरे । अनि इस्राएलका मानिसहरू रुन थाले र भने, “हामीलाई कसले मासु खान दिन्छ ?” ");
INSERT INTO npiulb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हामीले मिश्रमा खुलमखुला खाएका माछा, काँक्रा, खरबूजा, कन्दहरू, प्याज र लसुन सम्झन्छौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","अहिले हाम्रो भोक नै हराइसकेको छ, किनभने हामी देख्‍ने जत्ति सबै थोक मन्‍न मात्र हो ।” ");
INSERT INTO npiulb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्‍न धनियाँको बिउजस्तो थियो । यो हेर्दा खोटोजस्तो देखिन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","मानिसहरू वरिपरि जान्थे र यसलाई बटुल्थे । तिनीहरूले यसलाई पिँध्थे, ओखलीमा कुट्थे, भाँडामा उमाल्थे र यसलाई फुरौला बनाउँथे । यो ताजा जैतूनको तेलको स्वादको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","छाउनीमा राती शीत पर्दा मन्‍न पनि झर्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","मानिसहरू आ-आफ्ना परिवारमा रोएको मोशाले सुने र सबै मानिस आ-आफ्ना पालको ढोका थिए । परमप्रभु साह्रै क्रोधित हुनुभयो र तिनीहरूको गनगन मोशाको दृष्‍टिमा गलत थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशाले परमप्रभुलाई भने, “तपाईंको दासलाई किन यति नराम्रो व्यावहार गर्नुभएको ? तपाईं किन मसँग खुसी हुनुहुन्‍न ? तपाईंले मलाई यी सबै मानिसको बोझ बोकाउनुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","के यी मानिसहरूलाई मैले गर्भधारण गरेको थिएँ ? के तिनीहरूलाई मैले जन्माएको थिएँ अनि 'तिनीहरूलाई बुबाले बालकलाई आफ्नो छातीमा टाँसेर बोकेझैँ बोक्' भन्‍नुहुन्छ ? के मैले तिनीहरूलाई तपाईंले तिनीहरूका पुर्खाहरूलाई दिन्छु भनी प्रतिज्ञा गर्नुभएको मुलुक दिन त्यहाँसम्म नै बोक्‍नुपर्ने? ");
INSERT INTO npiulb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","यी सबै मानिसलाई खुवाउन मैले मासु कहाँ पाउन सक्छु ? तिनीहरू 'हामीलाई मासु खान दिनुहोस्' भन्‍दै मेरो सामु रोइरहेका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","यी सबै मानिसलाई म एक्लै बोक्‍न सक्दिनँ । तिनीहरू मेरो निम्ति अति धेरै भएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","तपाईंले मसँग यस्तो व्यवहार गरिरहनुभएको हुनाले यदि मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने मलाई अहिले नै मार्नुहोस्, मैले मेरो बिजोग देख्‍नु नपरोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","परमप्रभुले मोशालाई भन्‍नुभयो, “इस्राएलका सत्तरी जना धर्म-गुरु मकहाँ ले । तिनीहरू सबै धर्म-गुरु र मानिसहरूका अधिकृतहरू होऊन् । तिनीहरूलाई भेट हुने पालमा तँसँगै खडा हुनलाई ले । ");
INSERT INTO npiulb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","म ओर्ली आउनेछु र तँसँग कुरा गर्नेछु । तँसँग भ‍एको केही आत्मा लिएर यसलाई म तिनीहरूमाथि राख्‍नेछु । तिनीहरूले मानिसहरूका बोझ तँसँगै बहन गर्नेछन् । यसलाई तँ एक्लैले बोक्‍नुपर्नेछैन । ");
INSERT INTO npiulb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","मानिसहरूलाई भन्, 'भोलिको निम्ति आफैलाई शुद्ध पार र तिमीहरूले साँच्‍चै मासु खानेछौ, किनकि तिमीहरू रोएका छौ र परमप्रभुले सुन्‍नुभएको छ । तिमीहरूले भन्यौ, “हामीलाई कसले मासु खान दिन्छ ? हामीलाई मिश्र देश नै असल थियो ।” यसकारण, परमप्रभुले तिमीहरूलाई मासु दिनुहुनेछ र तिमीहरूले यसलाई खानेछौ । ");
INSERT INTO npiulb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तिमीहरूले मासु एक दिन, दुई दिन, पाँच दिन, दस दिन वा बिस दिन मात्र खानेछेनौ, ");
INSERT INTO npiulb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","तर तिमीहरूले तिमीहरूको नाक लागूञ्‍जेलसम्म पुरै महिनाभरि नै मासु खानेछौ । यो तिमीहरूलाई दिगमिग हुनेछ, किनभने तिमीहरूले परमप्रभुलाई इन्कार गरेका छौ, जो तिमीहरू माझ हुनुहुन्छ । तिमीहरू उहाँको सामु रोएका छौ । तिमीहरूले भन्यौ, “हामीले मिश्र देश किन छाड्यौँ ?” ");
INSERT INTO npiulb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","त्यसपछि मोशाले भने, “म छ लाख मानिससँग छु, र तपाईंले भन्‍नुभएको छ, 'मैले तिनीहरूलाई पुरै एक महिना मासु खान दिनेछु ।' ");
INSERT INTO npiulb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","के तिनीहरूलाई तृप्‍त पार्न हामीले भेडा-बाख्राहरू र गाईवस्तुहरू काट्नु त ? के तिनीहरूलाई तृप्‍त पार्न हामीले समुद्रका सबै माछाहरू पक्रने ?” ");
INSERT INTO npiulb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","परमप्रभुले मोशालाई भन्‍नुभयो, “के मेरो बहुली छोटो भएको छ ? मेरो वचन सत्य हो वा होइन भनी अब तैँले देख्‍नेछस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","मोशा बाहिर गए र परमप्रभुको वचन बोले । तिनले मानिसका सत्तरी जना धर्म-गुरुलाई भेला गरे र तिनीहरूलाई पालको वरिपरि राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","परमप्रभु बादलमा तल आउनुभयो र मोशासँग बोल्नुभयो । परमप्रभुले मोशासँग भएको केही आत्मा लिनुभयो र यसलाई सत्तरी जना धर्म-गुरुमाथि राखिदिनुभयो । तिनीहरूमाथि आत्मा आउनुभएपछि तिनीहरूले अगमवाणी गरे, तर त्यस बेला मात्र र फेरि अगमवाणी गरेनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","एल्दाद र मेदाद नाउँ गरेका दुई जना छाउनीमा नै बसे । आत्मा तिनीहरूमाथि पनि आउनुभयो । सूचीमा तिनीहरूका नाउँ पनि उल्लेख गरिएको थियो, तर तिनीहरू पालमा गएका थिएनन् । तथापि तिनीहरूले छाउनीमा नै अगमवाणी गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","छाउनीमा भएका एक जना जवान दौडेर गएर मोशालाई भने, “एल्दाद र मेदादले छाउनीमा नै अगमवाणी गरिरहेका छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","मोशाका सहायक, तिनका चुनिएका एक जना अर्थात् नूनका छोरा यहोशूले मोशालाई भने, “मालिक, तिनीहरूलाई रोक्‍नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","मोशाले तिनलाई भने, “के तिमी मेरो खातिर डाही हुन्छौ ? परमप्रभुले उहाँका सबै मानिसमाथि उहाँको आत्मा राखेर तिनीहरू अगमवक्‍ताहरू भए कति राम्रो हुन्थ्यो !” ");
INSERT INTO npiulb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","मोशा र इस्राएलका धर्म-गुरुहरू छाउनीमा फर्केर गए । ");
INSERT INTO npiulb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","त्यसपछि परमप्रभुबाट बतास आयो र समुद्रबाट बट्टाई चराहरू ल्यायो । तिनीहरू छाउनी नजिक वरिपरि एक दिनको बाटोभरि झरे । बट्टाई चराहरूले लगभग एक मिटर जत्ति बाक्लो हुने गरी जमिनलाई नै ढाके । ");
INSERT INTO npiulb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","मानिसहरू त्यस दिनभरि, रातभरि र अर्को दिनभरि बट्टाई चराहरू बटुल्नमा व्यस्त भए । कसैले पनि पच्‍चिस मुरीभन्दा कम बटुलेन । तिनीहरूले छाउनीभरि बट्टाई चराहरू फिँजाए । ");
INSERT INTO npiulb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","मासु तिनीहरूको मुखमा हुँदा नै, तिनीहरूले यसलाई चपाइरहँदा नै, परमप्रभु तिनीहरूसँग क्रोधित हुनुभयो । उहाँले मानिसहरूलाई भयङ्कर रोगले प्रहार गर्नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","त्यस ठाउँको नाउँ किब्रोथ-हत्तावा राखियो, किनभने मासुको लालसा गर्ने मानिसहरूलाई तिनीहरूले त्यहाँ गाडे । ");
INSERT INTO npiulb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किब्रोथ-हत्तावाबाट मानिसहरू हसेरोततिर गए, जहाँ तिनीहरू बसे । ");
INSERT INTO npiulb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मोशाले विवाह गरेका कूशी महिलाको कारण हारून र मिरियम मोशाको विरुद्धमा बोले । ");
INSERT INTO npiulb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","तिनीहरूले भने, “के परमप्रभु मोशासँग मात्र बोल्नुभएको छ र ? के उहाँ हामीसँगचाहिँ बोल्नुभएको छैन र ?” तिनीहरूले भनेका कुरा परमप्रभुले सुन्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","मोशा साह्रै नम्र मानिस थिए, तिनी संसारका सबैभन्दा नम्र थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","त्यसै बेला परमप्रभु मोशा, हारून र मिरियमसित बोल्नुभयो, “तिमीहरू तिनै जना भेट हुने पालमा आओ ।” त्यसैले तिनै जना बाहिर आए । ");
INSERT INTO npiulb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","अनि परमप्रभु बादलको खामोमा ओर्लेर आउनुभयो । उहाँ पालको प्रवेश-द्वारमा खडा हुनुभयो अनि हारून र मिरियमलाई बोलाउनुभयो । तिनीहरू दुवै अगि आए । ");
INSERT INTO npiulb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","परमप्रभुले भन्‍नुभयो, “मेरो वचन सुन । मेरो अगमवक्‍ता तिमीहरूसँग हुँदा म आफैलाई त्यससँग दर्शनमा प्रकट गर्नेछु र त्यससँग सपनामा कुरा गर्छु । ");
INSERT INTO npiulb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","मेरो दास मोशा त्यस्‍तो होइन । त्यो मेरा सबै घरानामा विश्‍वासयोग्य छ । ");
INSERT INTO npiulb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","म मोशासँग दर्शन वा अड्कोमा होइन प्रत्यक्ष रूपमा बोल्छु । त्यसले मेरो रूप देख्छ । यसैले तिमीहरूलाई मेरो दास मोशा विरुद्ध बोल्न किन डर लागेन ?” ");
INSERT INTO npiulb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","परमप्रभुको क्रोध तिनीहरू विरुद्ध दन्कियो, र उहाँ तिनीहरूबाट जानुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","बादल पालमाथिबाट हट्यो र मिरियम अचानक कुष्‍ठरोगी भइन् । तिनी हिउँजस्तै सेतो भइन् । हारून मिरियमतिर फर्कंदा तिनले तिनलाई कुष्‍ठ रोग लागेको देखे । ");
INSERT INTO npiulb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","हारूनले मोशालाई भने, “हे मेरा मालिक, बिन्ती छ यो पाप हाम्रो विरुद्ध नलिनुहोस् । हामीले मूर्खतापूर्वक बोलेका छौँ र हामीले पाप गरेका छौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","बिन्ती छ, तिनी आफ्नो आमाको गर्भबाट निस्कँदा नै आधा मासु कुहेको मृत जन्मेकोजस्तो नहोऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","यसैले मोशाले परमप्रभुलाई पुकारे, “हे परमेश्‍वर, बिन्ती छ, उनलाई निको पारिदिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","परमप्रभुले मोशालाई भन्‍नुभयो, “यदि त्यसको बुबाले त्यसलाई अनुहारमा थुकेको भए, त्यो सात दिनसम्म अपमानित हुन्थ्यो । त्यसलाई छाउनी बाहिर लगेर थुन् । त्यसपछि त्यसलाई फेरि ले ।” ");
INSERT INTO npiulb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","यसैले मिरियमलाई छाउनीबाहिर सात दिनसम्म थुनियो । तिनी छाउनीमा नफर्केसम्म मानिसहरूले यात्रा गरेनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","त्यसपछि, मानिसहरू हसेरोतबाट यात्रा गरेर पारानको मरुभूमिमा छाउनी लगाए । ");
INSERT INTO npiulb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“केही मानिसहरूलाई कनानको भूमिको जाँच गर्न पठा, जुन मैले इस्राएलका मानिसहरूलाई दिएको छु । तिनीहरूका पुर्खाका हरेक कुलबाट एक-एक जना पठा । ती हरेक तिनीहरूका अगुवा हुनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","मोशाले तिनीहरूलाई पारानको मरुभूमिबाट पठाए, ताकि तिनीहरूले परमप्रभुको आज्ञा पालन गरून् । तिनीहरू सबै इस्राएलका मानिसहरूका अगुवाहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","तिनीहरूका नाउँ यिनै हुन्ः रूबेनको कुलबाट जक्‍कूरका छोरा शम्मूअ; ");
INSERT INTO npiulb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमियोनका कुलबाट होरीका छोरा शाफात; ");
INSERT INTO npiulb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदाको कुलबाट यपुन्‍नेका छोरा कालेब; ");
INSERT INTO npiulb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साखारको कुलबाट योसेफका छोरा यिगाल; ");
INSERT INTO npiulb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राइमको कुलबाट, नूनका छोरा होशिया; ");
INSERT INTO npiulb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बेन्यामीनको कुलबाट, रफूका छोरा पलती; ");
INSERT INTO npiulb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलूनको कुलबाट सोदीका छोरा गद्दीएल; ");
INSERT INTO npiulb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","योसेफको कुलबाट (अर्थात् मनेश्‍शेको कुलबाट) सूसीका छोरा गेद्दी; ");
INSERT INTO npiulb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दानको कुलबाट गमल्लीका छोरा अम्मीएल; ");
INSERT INTO npiulb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेरको कुलबाट मिखाएलका छोरा सतूर; ");
INSERT INTO npiulb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नप्‍तालीको कुलबाट वोफ्सीका छोरा नहबी ");
INSERT INTO npiulb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गादको कुलबाट माकीका छोरा गूएल । ");
INSERT INTO npiulb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मोशाले भूमिको जाँच गर्न पठाएका मानिसहरूका नाउँ यिनै थिए । मोशाले नूनका छोरा होशियालाई यहोशू नाउँ राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","मोशाले तिनीहरूलाई कनानको भूमि जाँचबुझ गर्न पठाए । तिनले तिनीहरूलाई भने, “नेगेवबाट प्रवेश गर र पहाडी मुलुकतिर जाओ । ");
INSERT INTO npiulb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","यो कस्तो छ भनी भूमिको जाँचबुझ गर । ");
INSERT INTO npiulb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","त्यहाँ बस्‍ने मानिसहरूलाई हेर, तिनीहरू बलिया वा कमजोर छन् वा तिनीहरू धेरै छन् वा थोरै छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","तिनीहरू बसोबास गरेका भूमि कस्तो छ, हेर । यो असल वा खराब छ ? सहरहरू कस्ता छन् ? तिनीहरू छाउनी वा किल्ला भएको सहरहरूमा छन् ? भूमि कस्तो छ । अन्‍न उमार्न असल छ वा छैन, रुखहरू छन् वा छैनन् । साहसी होओ र त्यो भूमिको उत्पादनको नमुना लिएर आओ ।” त्यस बेला पहिलो दाख पाक्‍ने समय थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","यसैले ती मानिसहरू गए र जीनको मरुभूमिदेखि लेबो-हमात नजिकको रेहोबसम्मको भूमिको जाँचबुझ गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","तिनीहरू नेगेवबाट उक्लेर हेब्रोनमा आइपुगे । त्यहाँ अनाकका सन्तानहरू अहीमान, शेशै र तल्मै थिए । होब्रोन मिश्रको सोअनभन्दा सात वर्ष पहिले निर्माण गरिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","जब तिनीहरू एश्कोलको बेँसीमा पुगे, तिनीहरूले दाखको झुप्पासहितको हाँगा काटे । तिनीहरूले यसलाई घोचामा राखेर दुई जनाले बोके । तिनीहरूले अनार र नेभारा पनि ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","इस्राएलका मानिसहरूले त्यहाँ दाखको झुप्पा काटेकाले त्यस ठाउँलाई एश्कोलको बेँसी नाउँ राखियो । ");
INSERT INTO npiulb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालिस दिनपछि तिनीहरू भूमिको जाँचबुझ गरेर फर्के । ");
INSERT INTO npiulb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","तिनीहरू मोशा, हारून र इस्राएलका सारा समुदायकहाँ पारानको मरुभूमिमा भएको कादेशमा फर्केर आए । तिनीहरूले तिनीहरूलाई र सारा समुदायलाई खबर ल्याए र भूमिको उत्पादन तिनीहरूलाई देखाए । ");
INSERT INTO npiulb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","तिनीहरूले मोशालाई भने, “तपाईंले पठाउनुभएको मुलुकमा हामी पुग्यौँ । यसमा साँच्‍चै दुध र मह बग्दोरहेछ । यसका केही उत्पादनहरू यहाँ छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","तथापि, त्यहाँ बसोबास गर्ने मानिसहरू बलिया छन् । सहरमा किल्ला हालिएका छन् र ती धेरै ठुला छन् । हामीले अनाकका सन्तानहरूलाई पनि देख्यौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","नेगेवमा अमालेकीहरू बसोसबास गर्छन् । हित्ती, यबूसी, र एमोरी पहाडी मुलुकमा बस्छन् । कनानीहरू समुद्र किनारा र यर्दन नदीको तीरमा बस्छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","अनि यहोशूले मोशाको सामु मानिसहरूलाई चुपचाप बनाए र भने, “जाऔँ र भूमिलाई कब्जा गरौँ, किनभने हामीले यसलाई निश्‍चय पनि जित्‍नेछौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","तर तिनीसँग गएका अरू मानिसहरूले भने, “हामीले तिनीहरूलाई आक्रमण गर्न सक्दैनौँ, किनभने तिनीहरू हामीभन्दा बलिया छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","यसैले तिनीहरूले जाँचबुझ गरेका मुलुकबारे इस्राएलका मानिसहरू माझ निरुत्साहित पार्ने खबर फिँजाए । तिनीहरूले भने, “हामीले हेरेका मुलकले त आफ्नै बासिन्दाहरूलाई निल्दोरहेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हामीले त्यहाँ देखेका सबै मानिस अग्ला कदका छन् । हामीले त्यहाँ दैत्यहरू अर्थात् अनाकका सन्तानहरू देख्यौँ जो दैत्यहरूबाट आएका थिए । तिनीहरूसँग तुलना गर्दा हामी हाम्रो नजरमा फट्याङ्ग्राजस्ता थियौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","त्यस रात सारा समुदाय ठुलो आवाज निकालेर रोए । ");
INSERT INTO npiulb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","इस्राएलका सबै मानिसले मोशा र हारूनको आलोचना गरे । सारा समुदायले तिनीहरूलाई भने, “हामी मिश्र देशमा नै मरेको भए पनि हुन्थ्यो अथवा यही मरुभूमिमा नै मरेको भए नि हुन्थ्यो ! ");
INSERT INTO npiulb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","तरवारद्वारा मर्नलाई परमप्रभुले हामीलाई किन यो भूमिमा ल्याउनुभयो ? हाम्रा पत्‍नीहरू र साना छोराछोरीहरू हताहत हुनेछन् । के हामी मिश्रमा मर्नु नै असल हुँदैनथ्यो र ? ");
INSERT INTO npiulb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","तिनीहरूले आपसमा भने, “अर्को अगुवा चुनौँ र मिश्रतिर फर्कौं ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","अनि मोशा र हारून इस्राएलका मानिसहरूका समुदायका सबै भेलाको सामु घोप्टो परे । ");
INSERT INTO npiulb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","त्यो भूमिको जाँचबुझ गर्न पठाइएकामध्ये केहीमा नूनका छोरा यहोशू र यपुन्‍नेका छोरा कालेबले आफ्नो लुगा च्याते । ");
INSERT INTO npiulb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","तिनीहरूले इस्राएलका मानिसहरूका सबै समुदायलाई भने, “हामीले घुमेका र जाँचबुझ गरेका मुलुक धेरै राम्रो छ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","यदि परपप्रभु हामीसँग प्रसन्‍न हुनुहुन्छ भने, उहाँले हामीलाई यो भूमिमा लानुहुनेछ र यो हामीलाई दिनुहुनेछ । भूमिमा दूध र मह बग्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","तर परमप्रभुको विरुद्धमा विद्रोह नगर्नुहोस्, र त्यो भूमिका मानिसहरूसँग नडराउनुहोस्, किनभने तिनीहरू हाम्रा रोटी हुन् । तिनीहरूका सुरक्षा तिनीहरूबाट हटाइनेछ, किनभने परमप्रभु हामीसँग हुनुहुन्छ । तिनीहरूसँग नडराओ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","अनि सारा समुदायले तिनीहरूलाई ढुङ्गाले हान्‍ने मतो गरे । तर भेट हुने पालमा इस्राएलका सबै मानिसकहाँ परमप्रभुको महिमा देखा पर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","परमप्रभुले मोशालाई भन्‍नुभयो, “यी मानिसहरूले मलाई कहिलेसम्म तिरस्कार गर्ने ? मैले तिनीहरूका माझ गरेका मेरो शक्‍तिका चिन्हहरूका बाबजुद पनि तिनीहरू कहिलेसम्म ममा भरोसा गर्न चुक्छन् ? ");
INSERT INTO npiulb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","म तिनीहरूलाई विपत्तिले प्रहार गर्नेछु र विनाश गर्नेछु अनि तेरो आफ्नै कुलबाट एउटा जाति बनाउनेछु जुन तिनीहरूभन्दा महान् र शक्‍तिशाली हुनेछ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मोशाले परपप्रभुलाई भने, “यदि तपाईंले यसो गर्नुभयो भने, मिश्रीहरूले यसबारे सुन्‍नेछन्, किनभने तपाईंले यिनीहरूलाई तिनीहरूको शक्‍तिबाट छुटकारा दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","तिनीहरूले यो भूमिका मानिसहरूलाई भन्‍नेछन् । तपाईं परमप्रभु तिनीहरूसँग हुनुहुन्छ भन्‍ने तिनीहरूले सुनेका छन्, किनभने तपाईंलाई आमनेसामने देखिएको छ । तपाईंको बादल हाम्रा मानिसहरूमाथि खडा छ । तपाईं दिनमा बादलको खामो भएर र रातमा आगोको खामो भएर तिनीहरूको अघिअघि जानुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","यदि तपाईंले यी मानिसहरूलाई एक जना मानिसलाई झैँ मार्नुभयो भने, तपाईंको प्रसिद्धि सुन्‍ने जातिहरू बोल्नेछन् र भन्‍नेछन्, ");
INSERT INTO npiulb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'परमप्रभुले तिनीहरूलाई दिन्छु भनी प्रतिज्ञा गर्नुभएको मुलुकमा यी मानिसहरूलाई लान नसक्‍नुभएको हुनाले उहाँले तिनीहरूलाई मरुभूमिमा नै मार्नुभयो ।' ");
INSERT INTO npiulb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","म बिन्ती गर्छु, कि तपाईंको महाशक्‍ति प्रयोग गर्नुहोस् । किनभने तपाईंले भन्‍नुभएको छ, ");
INSERT INTO npiulb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","'परमप्रभु रिसाउनमा धिमा र विश्‍वनीयताको करारमा प्रशस्‍त हुनुहुन्छ । उहाँले अपराध र अधर्महरू क्षमा गर्नुहुन्छ । उहाँले तिनीहरूका सन्तानहरूमाथि तेस्रो र चौथो पुस्तासम्म पुर्खाहरूका दण्ड ल्याउनुहुँदा उहाँले दोषीहरूलाई कुनै पनि हालतमा साफ पार्नुहुन्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","म तपाईंसँग बिन्ती गर्छु, कि तपाईंले यी मानिसहरूलाई तिनीहरू मिश्रमा हुँदादेखि अहिलेसम्म सदैव क्षमा गर्नुभएझैँ तपाईंको करारको विश्‍वसनीयताको महान्‌ताको कारण यी मानिसहरूका पाप क्षमा गर्नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","परपप्रभुले भन्‍नुभयो, “मैले तिनीहरूलाई तेरो बिन्तीअनुसार क्षमा गरेको छु, ");
INSERT INTO npiulb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","तर जस्तो म जीवित छु र पृथ्वी मेरो महिमाले ढाकिनेछ, मेरो महिमा र ");
INSERT INTO npiulb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","शक्‍तिका चिन्हहरू देख्‍ने ती सबै मानिस जसलाई मैले मिश्र देश र मरुभूमिमा गरेँ, तिनीहरूले मलाई दस पटकसम्म परीक्षा गरेका छन् र मेरो आवाज सुनेका छैनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","यसैले तिनीहरूले निश्‍चय नै त्यो भूमि देख्‍नेछैनन् जसबाट मैले तिनीहरूका पुर्खाहरूसित शपथ खाएँ । तिनीहरूमध्ये मलाई घृणा गर्ने कसैले पनि यो देख्‍नेछैन, ");
INSERT INTO npiulb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","मेरो दास कालेबबाहेक, किनभने ऊसँग अर्कै आत्मा थियो । त्यसले मलाई पूर्ण रूपमा अनुसरण गरेको छ; म त्यसलाई त्यो जाँचबुझ गर्न गएको भूमिमा ल्याउनेछु । त्यसका सन्तानहरूले अधिकार गर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(त्यस बेला बेँसीमा अमालेकीहरू र कनानीहरू बस्थे ।) भोलि फर्की र नर्कटको समुद्र (लाल समुद्र) को बाटो हुँदै मरुभूमितिर जा ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“मेरो आलोचना गर्ने यो दुष्‍ट समुदायलाई मैले कहिलेसम्म सहने ? इस्राएलका मानिसहरूले मेरो विरुद्ध गरेका गनगन मैले सुनेको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","तिनीहरूलाई भन्, 'जस्तो म जीवित छु,' परमप्रभु भन्‍नुहुन्छ, 'जस्तो तिमीहरूले मैले सुन्‍ने गरी भनेका छौ, मैले तिमीहरूलाई त्यस्तै गर्नेछुः ");
INSERT INTO npiulb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","मेरो विरुद्ध गनगन गर्ने तिमीहरू सबै, जनगणनामा गन्ती गरिएका तिमीहरू, बिस वर्ष र त्यसभन्दा माथिका मानिसहरू पूरै तिमीहरूका मृत शरीरहरू मरुभूमिमा पड्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","यपुन्‍नेका छोरा लालेब र नूनका छोरा यहोशूबाहेक तिमीहरू कोही पनि निश्‍चय नै तिमीहरूको वासस्थान बनाउने प्रतिज्ञा गरेको मुलुकमा जानेछैनौ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","हताहत हुन्छन् भनेका तिमीहरूका स-साना बालबच्‍चाहरूलाई मैले त्यो भूमिमा लानेछु । तिमीहरूले तिरस्कार गरेका भूमि तिनीहरूले उपभोग गर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","तिमीहरूको सवालमा तिमीहरूका मृत शरीरहरू यही मरुभूमिमा पडिरहनेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तिमीहरूका सन्तानहरू मरुभूमिमा चालिस वर्षसम्म गोठालाहरू हुनेछन् । मरुभूमिमा तिमीहरूका लाशहरू अन्त नभएसम्म तिनीहरूले तिमीहरूका विद्रोहका कार्यहरूका नतिजाहरू भोग्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","तिमीहरूले त्यो भूमिको जाँचबुझ गर्न लगाएका दिनहरूको सङ्ख्या अर्थात् चालिस दिनजस्तै, तिमीहरूले आफ्नो पापको नतिजाहरू चालिस वर्षसम्म अर्थात् एक दिनको एक वर्ष भोग्‍नुपर्छ र मेरो विरोध गर्नु कस्तो हुन्छ भनी तिमीहरूले थाहा पाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","म परमप्रभुले बोलेको हुँ । मेरो विरुद्ध खडा हुने यो सबै दुष्‍ट समुदायमाथि म निश्‍चय नै यो गर्नेछु । तिनीहरू पूर्ण रूपमा नष्‍ट हुनेछन् र तिनीहरू यहीँ मर्नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","यसैले मोशाले भूमिको जासूस गर्न पठाएकाहरू जो फर्के र जसले भूमिबारे खराब खबर फैलाएर मोशा विरुद्ध सारा समुदायलाई गनगन गर्न लगाउने मानिसहरू थिए अर्थात् ");
INSERT INTO npiulb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","भूमिबारे खराब खबर ल्याउने यी मानिसहरूलाई प्रहार गरियो र तिनीहरू परमप्रभुको सामु महामारीले मरे । ");
INSERT INTO npiulb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","भूमिको जासूस गर्न गएकाहरूमध्ये नूनका छोरा यहोशू र यपुन्‍नेका छोरा कालेब मात्र जीवित रहे । ");
INSERT INTO npiulb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जब मोशाले इस्राएलका मानिसलाई यी कुराहरू बताए, तिनीहरूले गम्भीर रूपमा विलाप गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","तिनीहरू बिहान सबेरै उठे र पहाडको चुचुरोमा गए, र भने, “हेर, हामी यहाँ छौँ, र हामी परमप्रभुले प्रतिज्ञा गर्नुभएको ठाउँतिर जानेछौँ, किनभने हामीले पाप गरेका छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","तर मोशाले भने, “तिमीहरू परमप्रभुको आज्ञा किन तोड्छौ ? तिमीहरू सफल हुनेछेनौ । ");
INSERT INTO npiulb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","नजाओ, किनभने तिमीहरूलाई तिमीहरूका शत्रुहरूबाट पराजित हुनलाई बचाउन परमप्रभु तिमीहरूसँग हुनुहुन्‍न । ");
INSERT INTO npiulb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","त्यहाँ अमालेकीहरू र कनानीहरू छन्, र तिमीहरू तरवारद्वारा मर्नेछौ, किनभने तिमीहरू परमप्रभुलाई अनुसरण गर्नबाट तर्किएका छौ । यसैले उहाँ तिमीहरूसँग हुनुहुनेछैन ।” ");
INSERT INTO npiulb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","तर तिनीहरूले पहाडी देशतिर जाने दम्भ गरे; तथापि, न त मोशा न त परमप्रभुको सन्दूकले छाउनी छोडे । ");
INSERT INTO npiulb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","त्यसपछि अमालेकीहरू ओर्लेर आए, र कनानीहरू पनि जो ती पहाडहरूमा बस्थे । तिनीहरूले इस्राएलीहरूलाई आक्रमण गरे र तिनीहरूलाई होर्मासम्म नै खेदेर पराजित गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएलका मानिसहरूलाई भन्, 'जब तिमीहरू परमप्रभुले तिमीहरूलाई दिनुहुने भूमिमा बस्‍न जानेछौ, कि होमबलि कि भाकल पुरा गर्ने स्वैच्छा बलि कि ");
INSERT INTO npiulb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","तिमीहरूको चाडमा बलिदान गाईवस्तु वा भेडा-बाख्राबाट परमप्रभुको निम्ति प्रसन्‍न पार्ने सुगन्धित बास्‍नाको निम्ति तिमीहरूले परमप्रभुको निम्ति आगोद्वारा चढाइने बलिदान तयार पर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","तिमीहरूले परमप्रभुको निम्ति एक लिटर तेलमा मुछेको आधा पाथी पिठोको अन्‍नबलिसाथै होमबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","तिमीहरूले होमबलि वा बलिदानको निम्ति हरेक थुमाको निम्ति एक लिटर दाखमद्य पनि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","यदि तिमीहरूले थुमा चढाइरहेका छौ भने, तिमीहरूले डेढ लिटर तेलमा मुछेको आधा पाथी पिठोलाई अन्‍नबलिको रूपमा तयार पार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","अर्घबलिको निम्ति तिमीहरूले डेढ लिटर दाखमद्य तयार पार्नुपर्छ । यसले परमप्रभुको निम्ति सुगन्धित बास्‍ना दिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","जब तिमीहरूले होमबलि वा भाकल पुरा गर्न बलिदानको रूपमा वा परमप्रभुको निम्ति मेलबलिको रूपमा साँढे तयार पार्छौ, ");
INSERT INTO npiulb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तिमीहरूले साँढेसँगै दुई लिटर तेलमा मुछेको डेढ पाथी मसिनो पिठो अन्‍नबलिको रूपमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","तिमीहरूले परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति आगोद्वारा चढाइने बलिको रूपमा दुई लिटर दाखमद्यको अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","हरेक साँढे, थुमा र भेडा वा बाख्राको निम्ति यसो गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","तिमीहरूले तयार पार्ने र चढाउने बलिदान यहाँ उल्लेख गरेजस्तै गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","कसैले परमप्रभुलाई प्रसन्‍न तुल्याउने सुगन्धको निम्ति आगोद्वारा चढाइने बलिदान ल्याउँदा स्वदेशी इस्राएलीहरू सबैले यी कुराहरू यसबमोजिम गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","यदि विदेशी तिमीहरूसँग बसोबास गरेको छ भने वा तिमीहरूका मानिसहरूको पुस्तौँसम्म तिमीहरूसँग बसोबास गर्न सक्छ, त्यसले परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति आगोद्वारा चढाइने बलिदान चढाउनुपर्छ । त्यसले पनि तिमीहरूले गरेझैँ नै गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","समुदायको निम्ति र तिमीहरूसँग बस्‍ने परदेशीको निम्ति एउटै नियम हुनुपर्छ, तिमीहरूका मानिसहरूका पुस्तौँ-पुस्तासम्मको स्थायी नियम हुनुपर्छ । तिमीहरूमाझ बस्‍ने परदेशी पनि तिमीहरूजस्तै हुनुपर्छ । परमप्रभुको सामु त्यसले तिमीहरूले जस्तै गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तिमीहरू र तिमीहरू माझ बस्‍ने परदेशीलाई एउटै नियम र आदेश लागु हुनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","फेरि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएलका मानिसहरूलाई भन्, 'जब तिमीहरू मैले लैजाने भूमिमा आउँछौ, ");
INSERT INTO npiulb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","जब तिमीहरूले त्यस भूमिमा उत्पादन भएको खानेकुरा खान्छौ, तिमीहरूले बलिदान चढाउनुपर्छ र मेरो निम्ति यसलाई चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","आफ्नो मुछेको पहिलो पिठोबाट खलाबाट नै उठाइएको बलिदानको रूपमा यसलाई उठाउन एउटा रोटी चढाउनुपर्छ । तिमीहरूले यसलाई यसरी उठाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","तिमीहरूले तिमीहरूका मानिसहरूका पुस्तौँ-पुस्तासम्म पहिले आफ्नो मुछेको पिठोबाट उठाइएको बलिदानको रूपमा मलाई चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","मैले मोशासँग बोलेका यी सबै आज्ञा तिमीहरूले पालन नगर्दा तिमीहरूले कहिले काहीँ नचाहेर पनि पाप गर्नेछौ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","मैले तिमीहरूलाई आज्ञाहरू दिन सुरु गरेको दिनदेखि नै र तिमीहरूका मानिसहरूका पुस्तौँ-पुस्तासम्म मोशाद्वारा मैले आज्ञा गरेका सबै आज्ञाहरू पालन गर्नू । ");
INSERT INTO npiulb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","समुदायले थाहा नपाई अजानमा गरेको पापको सवालमा परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति समुदायले एउटा साँढे होमबलिको रूपमा चढाउनुपर्छ । यहीसँगै आज्ञा गरेजस्तै अन्‍नबलि र अर्घबलिसाथै पापबलिको रूपमा बाख्रालाई पनि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","पुजारीले सारा समुदायको निम्ति प्रायश्‍चित्त गर्नुपर्छ । तिनीहरूलाई क्षमा दिइनेछ, किनभने पाप गल्ति थियो । तिनीहरूले तिनीहरूको बलिदान अर्थात् आगोद्वारा चढाइने बलिदान ल्याएका छन् । तिनीहरूले आफ्नो गल्तिको निम्ति पापबलि ल्याएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","अनि इस्राएलका मानिसहरूका सबै समुदायलाई क्षमा दिइनेछ र तिनीहरूसँग बस्‍ने परदेशीलाई पनि क्षमा दिइनेछ, किनभने सबै मानिसहरूले अजानमा नै पाप गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","यदि कुनै मानिसले अजानमा पाप गर्छ भने, त्यसले एक वर्षे बाख्रीलाई पापबलिको रूपमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","अजानमा पाप गर्ने व्यक्‍तिको निम्ति पुजारीले प्रायश्‍चित्त गर्नुपर्छ । प्रायश्‍चित्त गरेपछि त्यस मानिसलाई क्षमा गरिनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","अजानमा पाप गर्ने स्वदेशी इस्राएली मानिस र तिमीहरू माझ बसोबास गरेको परदेशीको निम्ति एउटै नियम हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","तर अवज्ञामा कुनै पनि कुरा गर्ने व्यक्‍ति स्वदेशी भए पनि परदेशी भए पनि त्यसले मेरो ईश्‍वर-निन्दा गर्छ । त्यसलाई आफ्‍ना मानिसहरूबाट बहिष्कार गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","किनभने त्यसले मेरो वचनलाई घृणा गरेको छ, त्यो व्यक्‍तिलाई पूर्ण रूपमा बिलकुलै बहिष्कार गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","त्यसको पाप त्यसैमाथि पर्नेछ ।” इस्राएलका मानिसहरू मरुभूमिमा हुँदा तिनीहरूले शबाथ दिनमा दाउरा बटुलिरहेको मानिस भेट्टाए । ");
INSERT INTO npiulb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","त्यसलाई भेट्टाउनेहरूले त्यसलाई मोशा, हारून र सारा समुदायकहाँ ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","तिनीहरूले त्यसलाई थुनामा राखे, किनभने त्यसलाई के गर्नुपर्छ भनी निधो गरिएको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","परमप्रभु मोशासँग बोल्नुभयो, “त्यो मानिस निश्‍चय नै मर्नुपर्छ । सबै समुदायले त्यसलाई छाउनी बाहिर लगेर ढुङ्गाले हान्‍नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","यसैले सबै समुदायले त्यसलाई छाउनी बाहिर ल्याए र परमप्रभुले मोशालाई आज्ञा गर्नुभएअनुसार ढुङ्गाले हानेर मारे । ");
INSERT INTO npiulb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","फेरि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएलका सन्तानहरूलाई भन् र आफ्नो लुगाको किनाराहरूमा झुन्डाउन र तिनीहरू सबैलाई निलो धागोले किनारामा झुन्डाउन झुम्का बनाउन तिनीहरूलाई आज्ञा गर् । ");
INSERT INTO npiulb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","तिनीहरूले यो तिनीहरूका मानिसहरूका पुस्तौँ-पुस्तासम्म गर्नुपर्छ । यो तिमीहरूले यसलाई हेर्दा बहन गर्नुपर्ने मेरा सबै आज्ञा याद दिलाउने विशेष कुरा हुने छ, ताकि तिमीहरूले आफ्नै हृदय र आफ्नै आँखामा हेरेर आफैलाई भ्रष्‍ट नतुल्याओ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","यसो गर् ताकि तिमीहरूले मेरा आज्ञाहरू याद गर्नेछौ र पालन गर्नेछौ अनि तिमीहरू पवित्र अर्थात् तिमीहरूका परमेश्‍वर मेरो निम्ति आरक्षित हुनेछौ । ");
INSERT INTO npiulb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","म परमप्रभु तिमीहरूका परमेश्‍वर हुँ, जसले तिमीहरूका परमेश्‍वर हुनलाई मिश्र देशबाट ल्याएँ । म परमप्रभु तिमीहरूका परमेश्‍वर हुँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","लेवीका पनाति, कहातका नाति, यिसहारका छोरा कोरहसाथै रूबेनका कुलका एलीआबका छोराहरू दातान र अबीराम अनि पेलेथका छोराले केही मानिसहरू भेला गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","तिनीहरू, इस्राएलका मानिसहरूका अन्य मानिसहरूसँगै दुई सय पचास समुदायका अगुवाहरू जो नाम चलेका सदस्यहरू थिए, मोशाको विरुद्धा खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","तिनीहरू मोशा र हारूनको सामना गर्न आफै भेला भए । तिनीहरूले उनीहरूलाई भने, “तपाईंहरूले अति गर्नुभयो! सबै समुदाय, तिनीहरूमध्ये हरेकलाई नै अलग गरिएको छ र परमप्रभु तिनीहरूसँग छन् । किन आफैलाई परमप्रभुको समुदायभन्दा माथि उठाउनुहुन्छ ?” ");
INSERT INTO npiulb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जब मोशाले त्यो सुने, तिनी घोप्टो परे । ");
INSERT INTO npiulb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","तिनले कोरह र उनका साथमा भएकाहरूलाई भने, “को उहाँका हुन् र कसलाई उहाँको निम्ति अलग गरिएको छ भनी परमप्रभुले बिहान देखाउनुहुने छ । त्यस व्‍यक्‍तिलाई उहाँले उहाँको नजिक ल्याउनुहुने छ । उहाँले चुन्‍नुभएकोलाई आफैले आफ्नो नजिक ल्याउनुहुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","कोरह र तिम्रा सबै समूहले यो गर । धुपौराहरू लेओ । ");
INSERT INTO npiulb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","भोलि त्यसमा परमप्रभुको सामु धूप र आगो राख । परमप्रभुले चुन्‍नुहुने मानिसलाई उहाँको निम्ति अलग गरिनेछ । तिमी लेवीका सन्तानहरू अति धेरै भएका छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","फेरि मोशाले कोरहलाई भने, “सुन, तिमी लेवीका सन्तानहरूः ");
INSERT INTO npiulb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","के परमप्रभुको पवित्र वासस्थानमा काम गर्न र समुदायको सेवा गर्न तिनीहरूको सामु खडा हुन इस्राएलको समुदायबाट तिमीहरूलाई छुट्ट्याएको तिमीहरूको निम्ति सानो कुरा हो ? ");
INSERT INTO npiulb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","उहाँले तिमीहरू र तिमीहरूका सबै दाजुभाइ, लेवीका सन्तानहरूलाई तिमीहरूसँगै नजिक ल्याउनुभएको छ, अझै तिमीहरूले पुजारी पद पनि खोजिरहेका छौ ! ");
INSERT INTO npiulb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","यसैले तिमी र तिमीहरूका सबै समूह सँगसँगै भेला भएका छौ । त्यसैले तिमीहरूले किन हारूनको बारेमा गनगन गरिरहेका छौ, जसले परमप्रभुको आज्ञा पालन गर्छन् ? ");
INSERT INTO npiulb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","त्यसपछि मोशाले दातान र अबीराम, एलीआबका छोराहरूलाई बोलाए । तर तिनीहरूले भने, “हामी आउँदैनौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","के हामीलाई दूध र मह बग्‍ने मुलुकबाट यो मरुभूमिमा मार्नलाई ल्याउनु मामुलि कुरा हो ? अब तपाईं आफै हाम्रो शासक हुन चाहन्छ ! ");
INSERT INTO npiulb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","यसको अतिरिक्‍त, तपाईंले हामीलाई दूध र मह बग्‍ने मुलुकमा ल्याउनुभएको छैन अथवा हामीलाई खेत र दाखबारीहरू उत्तराधिकारको रूपमा दिनुभएको छैन । के अब हामीलाई खोक्रो प्रतिज्ञाले अन्धा बनाउन चाहनुहुन्छ ? हामी तपाईंकहाँ आउँदैनौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","मोशा साह्रै रिसाए र परमप्रभुलाई भने, “तिनीहरूको भेटीको कदर नगर्नुहोस् । मैले तिनीहरूबाट एउटा गधा पनि लिएको छैनँ, र मैले तिनीहरू कसैलाई पनि हानि पुर्‍याएको छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","मोशाले कोरहलाई भने, “भोलि तिमी र तिम्रा सबै दल अर्थात् तिमी, तिनीहरू र हारून परमप्रभुको सामु जानुपर्छ । तिमीहरू हरेकले आ-आफ्ना धुपौरा लिनुपर्छ र यसमा धूप राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","अनि हरेकले आ-आफ्ना दुई सय पचासवटा धुपौरा परमप्रभुको सामु ल्याउनुपर्छ । तिमी र हारूनले पनि आ-आफ्ना धुपौरा ल्याउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","यसैले हरेकले आ-आफ्ना धुपौरा लिए, यसमा आगो राखे, यसमा धूप राखे र मोशा र हारूनसँगै भेट हुने पालको प्रवेश-द्वारमा खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","कोरहले सारा समुदायलाई मोशा र हारूनको विरुद्धमा भेट हुने पालको प्रवेश-द्वारमा भेला पारे र परमप्रभुको महिमा सारा समुदायकहाँ देखा पर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","परमप्रभु मोशा र हारूनसँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“यस समुदायबाट अलग होओ , ताकि म तिनीहरूलाई तत्कालै विनाश गर्न सकौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","मोशा र हारून घोप्‍टो परे र भने, “हे परमेश्‍वर, सारा मानव-जातिको आत्माका परमेश्‍वर, एक जनाले पाप गर्दा, के तपाईं सबै समुदायसँग रिसाउनुहुन्छ ?” ");
INSERT INTO npiulb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","परमप्रभुले मोशालाई जवाफ दिनुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“समुदायलाई भन् । 'कोरह, दातान र अबीरामका पालहरूबाट पर जाओ' भन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","अनि मोशा खडा भए र दातान र अबीरामको पालमा गए; इस्राएलका धर्म-गुरुहरू तिनको पछि-पछि गए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","तिनले समुदायलाई यसो भने, “यी दुष्‍टहरूका पालहरूबाट हट र तिनीहरूको कुनै पनि कुरा नछोओ नत्रता तिनीहरूका सबै पापद्वारा नष्‍ट हुनेछौ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","यसैले कोरह, दातान र अबीरामका पाल वरिपरिका समुदायले तिनीहरूलाई छोडे । दातान र अबीराम तिनीहरूका पत्‍नीहरू, छोराहरू र स-साना बालबालिकाहरूसहित तिनीहरूका पालको प्रवेश-द्वारमा खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","मोशाले भने, “यसैद्वारा यी सबै थोक गर्न मलाई परमप्रभुले पठाउनुभएको छ भन्‍ने तिमीहरूले जान्‍नेछौ, किनभने मैले तिनीहरू मेरो आफ्नै इच्छामा गरेको छैन । ");
INSERT INTO npiulb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","यदि यी मानिसहरू सामान्य रूपमा हुने स्वाभाविक मृत्युद्वारा मर्छन् भने, मलाई परमप्रभुले पठाउनुभएको होइन । ");
INSERT INTO npiulb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","तर यदि परमप्रभुले कुनै नयाँ कुरा सृजना गर्नुहुन्छ, धर्तीले आफ्नो मुख उघार्छ र तिनीहरूसाथै तिनीहरूका सबै थोकलाई निल्छ, र तिनीहरू जिउँदै चिहानभित्र जान्छन् भने, यी मानिसहरूले परमप्रभुलाई तिरस्कार गरेका छन् भनी तिमीहरूले बुझ्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","मोशाले यी कुराहरू भनी सिद्ध्याउने बित्तिकै ती मानिसहरूमुनिको जमिन फाट्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","धर्तीले यसको मुख उघार्‍यो अनि तिनीहरूका परिवारहरू र कोरहसँग भएका सबै मानिसहरूसाथै तिनीहरूका सबै थोकलाई निल्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","यसैले तिनीहरू र तिनीहरूसँग भएका सबै थोक जिउँदै चिहानभित्र लगिए । धर्ती तिनीहरूमाथि बन्द भयो, र तिनीहरू समुदायबाट नष्‍ट भए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","तिनीहरूका वरिपरि भएका इस्राएलीहरू चिच्‍च्याउँदै भागे । तिनीहरू, “धर्तीले हामीलाई पनि निल्ने भो!” भन्‍दै चिच्‍च्याए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","अनि परमप्रभुबाट आगोको ज्वाला निस्क्यो र धूप बालेका २५० जना मानिसलाई नष्‍ट गर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","फेरि परमप्रभु मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“पुजारी हारूनका छोरा एलाजारलाई भन् र त्यसले धुपौराहरूलाई आगोबाट निकालोस्, किनभने धुपौराहरू मेरा निम्ति अलग गरिएका छन् । त्यसले बलिरहेका आगोका फिलुङ्गाहरूलाई छरोस् । ");
INSERT INTO npiulb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","आफ्नो पापको कारण जीवन गुमाउनेहरूको धुपौराहरू ले । तिनीहरूलाई पिटेर वेदीलाई मोहर्ने पाताहरू बनाइयोस् । ती मानिसहरूले तिनीहरूलाई मेरो निम्ति अर्पण गरे । यसैले तिनीहरूलाई मेरो निम्ति अलग गर । तिनीहरू इस्राएलका मानिसहरूका निम्ति मेरो उपस्थितिको चिन्ह हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","पुजारी एलाजारले आगोले नष्‍ट भएका मानिसहरूले प्रयोग गरेका काँसाका धुपौराहरू लिए र ");
INSERT INTO npiulb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","इस्राएलका मानिसहरूलाई याद दिलाउने कुरा हुनलाई तिनीहरूलाई पिटेर वेदी मोहर्ने बनाइयो, परमप्रभुको सामु धूप बाल्न ताकि हारूनका सन्तान बाहिर कोही पनि नआओस् र परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ तिनीहरू कोरह र तिनका समूहजस्ता नहोऊन् । ");
INSERT INTO npiulb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","तर अर्को बिहान इस्राएलका सबै मानिसको समुदायले मोशा र हारून विरुद्ध गनगन गरे । तिनीहरूले भने, “तिमीहरूले परमप्रभुका मानिसहरूलाई मारेका छौ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","समुदाय मोशा र हारूनको विरुद्ध भेला हुँदा तिनीहरूले भेट हुने पालतिर हेरे अनि हेर! यसलाई बादलले ढाकिरहेको थियो । परमप्रभुका महिमा देखा पर्‍यो, ");
INSERT INTO npiulb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","र मोशा र हारून भेट हुने पालको अघि आए । ");
INSERT INTO npiulb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","अनि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“यो समुदायबाट गइहाल् ताकि मैले तिनीहरूलाई अहिलै नष्‍ट पार्न सकौँ ।” अनि मोशा र हारून जमिनमा घोप्टो परे । ");
INSERT INTO npiulb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","मोशाले हारूनलाई भने, “धुपौरा लिनुहोस्, वेदीबाट यसमा आगो हाल्नुहोस्, यसमा धूप हाल्नुहोस्, यसलाई समुदायकहाँ छिटो लानुहोस् र तिनीहरूका निम्ति प्रायश्‍चित्त गर्नुहोस्, किनभने परमप्रभुको क्रोध आइरहेको छ । विपत्ति सुरु भएको छ । ");
INSERT INTO npiulb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","यसैले हारूले मोशाले अह्राएबमोजिम गरे । तिनी समुदायको बिचमा दौडेर गए । विपत्ति मानिसहरूबिच फैलिन थालेको थियो, यसैले तिनले धूप राखे र मानिसहरूका निम्ति प्रायश्‍चित्त गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","हारून जीवित र मृतकहरूका बिचमा खडा भए । यसरी विपत्ति रोकियो । ");
INSERT INTO npiulb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","कोरहको विषयमा पनि मरेका अतिरिक्‍त विपत्तिमा मर्नेहरूको सङ्ख्या १४,७०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","हारून भेट हुने पालको प्रवेश-द्वारमा मोशाकहाँ फर्केर आए र विपत्ति रोकियो । ");
INSERT INTO npiulb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएलका मानिसहरूलाई भन् र तिनीहरूबाट हरेक कुलको निम्ति एउटा-एउटा गरी बाह्रवटा लहुरो ले । हरेक मानिसको लहुरोमा आ-आफ्नो नाउँ लेख् । ");
INSERT INTO npiulb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवीको लहुरोमा तैँले हारूनको नाउँ लेख्‍नुपर्छ । आ-आफ्नो कुलबाट हरेक अगुवाको निम्ति एउटा लहुरो हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","तैँले ती लहुरोहरूलाई करारको गवाही-पाटीको सामु भेट हुने पालमा राख्‍नुपर्छ, जहाँ मैले तँलाई भेट्छु । ");
INSERT INTO npiulb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","मैले चुनेको मानिसको लहुरो टुसाउनेछ । म इस्राएलका मानिसको गनगन बन्द गराउनेछु, जुन तेरो विरुद्ध भइरहेको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","यसैले मोशाले मानिसहरूलाई भने । सबै कुलनायकले हरेक अगुवाको निम्ति एउटा लहुरो दिए । कुलहरूबाट छानेर बाह्रवटा लहुरो तिनलाई दिइयो । तिनीहरूका माझमा हारूनको लहुरो पनि थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","त्यसपछि मोशाले लहुरोहरूलाई गवाही-पाटीको पालमा परमप्रभुको सामु राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","अर्को दिन मोशा गवाही-पाटी भएको पालमा गए, हेर! लेवी कुलका हारूनको लहुरोमा कोपिला लागेको रहेछ । यसमा कोपिला लगेको थियो, फूल फुलेको थियो र हाडे-बदाम पाकेको थियो ! ");
INSERT INTO npiulb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","मोशाले ती सबै लहुरालाई इस्राएलका मानिसको सामु ल्याए र सबैले आ-आफ्नो लहुरो लिए । ");
INSERT INTO npiulb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","परमप्रभुले मोशालाई भन्‍नुभयो, “हारूनको लहुरो गवाही-पाटीको सामु राख् । यसलाई विद्रोह गर्ने मानिसहरूको विरुद्ध दोषको चिन्हको रूपमा राख् । यसरी तैँले मेरो विरुद्ध तिनीहरूको गनगन अन्त गर्नेछस् नत्रता तिनीहरू मर्नेछन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","मोशाले परमप्रभुले आज्ञा गर्नुभएबमोजिम गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इस्राएलका मानिसहरूले मोशालाई भने, “यहाँ हामी मर्नेभयौँ ! हामी सबै नष्‍ट हुनेभयौ ! ");
INSERT INTO npiulb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","परमप्रभुको पवित्र वासस्थान नजिक आउने हरेक मर्ने छ । के हामी पनि मर्नुपर्छ ?” ");
INSERT INTO npiulb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","परमप्रभुले हारूनलाई भन्‍नुभयो, “तँ, तेरा छोराहरू र तेरा वंशकाहरू पवित्र स्थान विरुद्ध गरिने सबै पापका निम्ति जिम्मेवार हुनेछौ । तर पुजारीको पदमा कसैले गरेको सबै पापको निम्ति तँ र तेरा छोराहरू मात्र जिम्मेवार हुनेछौ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","लेवी कुलका अर्थात् तेरा पुर्खाका वंशका तेरा सङ्गी सदस्यहरूको सवालमा, तिनीहरूलाई तँसँगै ले अनि तँ र तेरा छोराहरूले गवाही-पाटीको पालको सम्मुख सेवा गर्दा तिनीहरू सहभागी होऊन् र तिमीहरूलाई सहायता गरून् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","तिनीहरूले तेरो र सारा पालको सेवा गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","तथापि, तिनीहरू पवित्र स्थान वा वेदीसँग सम्बन्धित कुनै थोकको नजिक आउनुहुँदैन नत्रता तिनीहरू र तँ मर्नेछौ । तिनीहरू पालसँग सम्बन्धित सबै किसिमका कामकाजको निम्ति तिमीहरूसँग सहभागी हुनुपर्छ र भेट हुने पालको देखरेख गर्नुपर्छ । कुनै पनि परदेशी तिमीहरूको नजिक आउनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","पवित्र स्थान र वेदीको निम्ति तैँले जिम्मा लिनुपर्छ, ताकि इस्राएलका मानिसहरूमाथि मेरो क्रोध फेरि नआओस् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","हेर्, लेवीहरूका तेरा सङ्गी सदस्यहरूलाई इस्राएलका सन्तानहरूबाट म आफैले चुनेको छु । तिनीहरू भेट हुने पालसँग सम्बन्धित काम गर्न मलाई दिइएका तेरो निम्ति उपहार हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","तर वेदी र पर्दाभित्र भएका सबै थोकसित सम्बन्धि पुजारीको काम तँ र तेरा छोराहरूले मात्र गर्न सक्छस् । ती दायित्वहरू तँ आफैले पुरा गर्नुपर्छ । पुजारीको पद मैले तँलाई उपहारको रूपमा दिइरहेको छु । नजिक आउने कुनै पनि परदेशीलाई मार्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","परप्रभुले हारूनलाई भन्‍नुभयो, “हेर्, मलाई चढाइने बलिदानहरू र इस्राएलका मानिसहरूले मलाई दिने पवित्र भेटीहरू सम्भाल्ने जिम्मा मैले तँलाई दिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","मैले यी बलिहरू तँलाई र तेरा छोराहरूलाई अनवरत हिस्साको रूपमा दिएको छु । आगोमा जलाउनबाट बचेका यी थोकहरू तेरा हुने छन् । हरेक अन्‍नबलि, पापबलि र दोषबलिजस्ता तिनीहरूका हरेक बलिबाट तिनीहरू तँलाई र तेरा छोराहरूलाई अलग गरिएका हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","यी बलिहरू अति पवित्र छन् । हरेक पुरुषले यो खानुपर्छ, किनभने तिनीहरू तिमीहरूका निम्ति पवित्र छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","इस्राएलका मानिसहरूका डोलाइने बलिको रूपमा तिनीहरूका सबै उपहारबाट अलग गरिएका यी सबै बलि तेरा हुने छन् । मैले ती तँलाई, तेरा छोराहरू र तेरा छोरीहरूका निम्ति तिमीहरूको सदाको निम्ति अंशको रूपमा दिएको छु । तेरा परिवारका विधिवत् रूपमा शुद्ध हुने सबैले यी बलिहरूबाट खान सक्छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","मानिसहरूले मलाई दिने तेल, नयाँ दाखमद्य र अन्‍नको उत्तम भाग, पहिलो फल यी सबै मैले तँलाई दिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","तिनीहरूले मकहाँ ल्याउने तिनीहरूका भूमिको पहिलो पाकेको फल तेरो हुने छ । तेरा परिवारका शुद्ध हुने सबैले यी थोकहरूबाट खान सक्छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","इस्राएलमा अर्पण गरिएका सबै थोक तेरा हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","मानिसहरूले परमप्रभुलाई अर्पण गर्ने मानिस र पशु दुवैका गर्भ खोल्ने पहिलो जन्मेकाहरू सबै तेरै हुने छन् । तथापि, मानिसहरूले जेठा छोरालाई किनेर फिर्ता लिनुपर्छ र तिनीहरूले अशुद्ध पशुहरूका पहिलो जन्मेकाहरूलाई किनेर फिर्ता गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","मानिसहरूले किनेर फिर्ता लिनुपर्नेहरूलाई एक महिनाको भएपछि किनेर फिर्ता गर्नुपर्छ । त्यसपछि मानिसहरूले पवित्र स्थानको शेकेलको तौलको मापदण्डअनुसार पाँच शेकेल तिरेर फिर्ता लिन सक्छन् । बिस गेराको एक शेकेल हुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","तर गाईको पहिले जन्‍मेको बाछो वा भेडा वा बाख्राको पहिले जन्मेको पाठोलाई तिमीहरूले किनेर फिर्ता लिनुहुँदैन; ती मेरो निम्ति अलग गरिएका छन् । तिनीहरूका रगत वेदीमाथि छर्कनुपर्छ र तिनीहरूका बोसो आगोद्वारा चढाइएको परमप्रभुलाई मनपर्ने सुगन्धित बलिको जलाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","तिनीहरूका मासु तेरो हुने छ । डोलाइएको ह्याकुलो र दाहिने साँप्रोझैँ तिनीहरूका मासु तेरो हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","इस्राएलका मानिसहरूले परमप्रभुलाई चढाएका सबै पवित्र बलि निरन्तरको अंशको रूपमा मैले तँलाई, तेरा छोराहरू र छोरीहरूलाई दिएको छु । यो तेरो र तेरा सन्तानहरू दुवैको निम्ति परमप्रभुको सामु अनन्तको बाध्यकारी करार अर्थात् नूनको अनन्त करार हो ।” ");
INSERT INTO npiulb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","परमप्रभुले हारूनलाई भन्‍नुभयो, “मानिसहरूको जग्गा-जमिनमा तेरो कुनै उत्तराधिकार हुनेछैन, न त मानिसहरूको सम्पत्तिमा कुनै हिस्सा हुने छ । इस्राएलका मानिसहरूमा म नै तेरो हिस्सा र उत्तराधिकार हुँ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","हेर्, लेवीका सन्तानहरूले भेट हुने पालमा काम गरे बापत मैले तिनीहरूलाई इस्राएलका दशांश सेवाको सट्टामा दिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","आज उप्रान्त इस्राएलका मानिसहरू भेट हुने पालको नजिक आउनुहुँदैन, नत्रता तिनीहरू यो पापको निम्ति जिम्मेवार हुने छन् र मर्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","लेवीहरूले भेट हुने पालसँग सम्बन्धित कामहरू गर्नुपर्छ । यससँग सम्बन्धित कुनै पापको जिम्मेवार तिनीहरू हुने छन् । यो तिमीहरूका मानिसहरूका पुस्तौँ-पुस्तासम्मको स्थायी नियम हुने छ । इस्राएलका मानिसहरूका माझ तिनीहरूको कुनै उत्तराधिकार हुनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","मेरो निम्ति योगदानको रूपमा तिनीहरूले चढाएका इस्राएलका मानिसहरूको दशांश मैले लेवीहरूलाई तिनीहरूको उत्तराधिकारको रूपमा दिएको छु । यसैले मैले तिनीहरूलाई यसो भनेँ, 'इस्राएलका मानिसहरूमाझ तिनीहरूको कुनै उत्तराधिकार हुनुहुँदैन ।” ");
INSERT INTO npiulb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“तिमीहरूले इस्राएलका मानिसहरूबाट दशांश प्राप्‍त गर्दा जुन मैले तिमीहरूको उत्तराधिकार हुनको निम्ति दिएको छु, तिमीहरूले यसबाट दशांशको दशांश परमप्रभुलाई दिनेछौ' भनी तैँले लेवीहरूलाई भन्‍नुपर्छ' ।” ");
INSERT INTO npiulb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","तिमीहरूका हिस्सालाई खलाबाट ल्याइएको अन्‍न वा कोलबाट ल्याइएको दाखमद्यको रूपमा लिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","यसैले तिमीहरूले पनि इस्राएलका मानिसहरूबाट प्राप्‍त गरेका दशांशहरूबाट परमप्रभुको निम्ति योग दिनुपर्छ । तिमीहरूले त्यसबाट पुजारी हारूनलाई त्यसको हिस्सा दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","तिमीहरूले प्राप्‍त गरेका सबै उपहारबाट तिमीहरूले परमप्रभुलाई हरेक हिस्सा दिनुपर्छ । यो तिमीहरूलाई दिइएको उत्तम र अति पवित्र थोकहरूबाट दिनुपर्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","यसकारण, 'जब तिमीहरूले यसको उत्तम हिस्सा दिन्छौ, लेवीहरूको निम्ति यो खलाबाट ल्याइएको अन्‍न र कोलबाट ल्याइएको दाखमद्यको रूपमा गनिन्छ' भनी तैँले तिनीहरूलाई भन् । ");
INSERT INTO npiulb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","बाँकी तेरा उपहारहरू तिमीहरू र तिमीहरूका परिवारले कुनै पनि ठाउँमा खान सक्छौ, किनभने यो भेट हुने पालमा तिमीहरूको कामको सट्टामा दिइएको ज्याला हो । ");
INSERT INTO npiulb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","यदि तिमीहरूले प्राप्‍‍त गरेका थोकहरूबाट यसको उत्तम हिस्सा परमप्रभुलाई चढाएका छौ भने, यो खाएर र पिएर तिमीहरूमाथि कुनै दोष आइपर्नेछैन । तर तिमीहरूले इस्राएलका मानिसहरूका पवित्र बलिहरूलाई अपवित्र तुल्याउनुहुँदैन नत्रता तिमीहरू मर्नेछौ' ।” ");
INSERT INTO npiulb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“मैले तिमीहरूलाई आज्ञा गरिरहेको नियम, विधि यही होः इस्राएलका मानिसहरूले निष्खोट वा दाखरहित रातो कोरली ल्याउनुपर्छ भनी तिनीहरूलाई भन् जसको काँधमा कहिल्यै जुवा परेको हुनुहुन्‍न । ");
INSERT INTO npiulb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","त्यो कोरली पुजारी एलाजारलाई दिनू । त्यसले यसलाई छाउनीबाहिर ल्याउनुपर्छ र कसैले यसलाई त्यसको सामु मार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","पुजारी एलाजारले यसको केही रगत त्यसको औँलाले लिएर भेट हुने पालको अघिल्तिर सात पटक छर्कनू । ");
INSERT INTO npiulb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","अर्को पुजारीले उसैको सामु त्यो कोरलीलाई जनाउनुपर्छ । त्यसले यसको छाला, मासु, रगत र गोबरलाई जलाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","पुजारीले देवदारुको काठ, हिसप र गाढा रातो रङको ऊन लिनुपर्छ र यी सबैलाई जलिरेहेको कोरलीमाथि फाल्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","त्यसपछि त्यसले आफ्‍नो लुगा धुनुपर्छ र नुहाउनुपर्छ । अनि त्यो छाउनीभित्र आउन सक्छ, जहाँ त्यो साँझसम्म अशुद्ध रहनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","कोरली जलाउने व्यक्‍तिले आफ्नो लुगा पानीले धुनुपर्छ र नुहाउनुपर्छ । त्यो साँझसम्म अशुद्ध रहनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","कोही शुद्ध मानिसले त्यो कोरलीको खरानीलाई उठाउनुपर्छ र त्यसलाई छाउनीबाहिर शुद्ध ठाउँमा राख्‍नुपर्छ । यो खरानी इस्राएलका मानिसको सामुदायको निम्ति राख्‍नुपर्छ । तिनीहरूले त्यो खरानीलाई तिनीहरूको पापबाट शुद्धिकरणको निम्ति पानीमा मिसाउनेछन्, किनभने त्यो खरानी पापबलिबाट लिइएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","त्यो कोरलीको खरानी बटुल्ने व्यक्‍तिले आफ्नो लुगा धुनुपर्छ । त्यो साँझसम्म अशुद्ध रहनेछ । यो इस्राएलका मानिस र तिनीहरूसँग बसोबास गर्ने परदेशीको निम्ति स्थायी नियम हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","कुनै पनि मृत शरीर छुने व्यक्‍ति सात दिनसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","यस्तो व्यक्‍तिले तेस्रो र सातौँ दिनमा आफूलाई शुद्धिकरण गर्नुपर्छ । अनि त्यो शुद्ध हुने छ । तर यदि त्यसले आफैलाई तेस्रो दिनमा शुद्ध पार्दैन भने, त्यो सातौँ दिनमा शुद्ध हुनेछैन । ");
INSERT INTO npiulb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","जसले मरेको व्यक्‍ति छुन्‍छ अर्थात् मरेको मानिसको शरीर छुन्‍छ, र आफूलाई शुद्ध पार्दैन, त्यो व्यक्‍तिले परमप्रभुको पवित्र वासस्थान अवित्र तुल्याउँछ । त्यो व्यक्‍तिलाई इस्राएलबाट बहिष्कार गर्नुपर्छ, किनभने अशुद्धताको पानी त्यसमाथि छर्किएको थिएन । त्यो अशुद्ध रहेनछ; त्यसको अशुद्धता त्यसमाथि रहनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","यो मानिस पालमा मर्दाको निम्ति नियम हो । पालभित्र पस्‍ने सबै र पहिले नै पालभित्र रहेका सबै सात दिनसम्म अशुद्ध हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","नछोपिएका सबै भाँडा अशुद्ध हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","त्यसै गरी, पालबाहिर तरवारले मारिएको, कुनै अरू मृत शरीर, मानिसको हड्‍डी वा चिहान छुने मानिस सात दिनसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","अशुद्ध व्‍यक्‍तिको निम्ति यसो गर्नूः जलाइएको पापबलिबाट केही खरानी लिनू र ताजा पानीसँग भाँडामा मिसाउनू । ");
INSERT INTO npiulb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","कोही शुद्ध मानिसले हिसप लिनुपर्छ, यसलाई पानीमा डुबाउनुपर्छ र हड्‍डी, मारिएको व्यक्‍ति, मृत व्यक्‍ति वा चिहान छुने व्यक्‍तिहरू, पालभित्र भएका भाँडाहरूमाथि छर्कनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","तेस्रो र सातौँ दिनमा शुद्ध व्यक्‍तिले अशुद्ध व्यक्‍तिमाथि छर्कनुपर्छ । अशुद्ध व्यक्‍तिले सातौँ दिनमा आफैलाई शुद्ध पार्नुपर्छ । त्यसले आफ्नो लुगा धुनुपर्छ र नुहाउनुपर्छ । त्यो साँझमा शुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","तर आफूलाई शुद्धिकरण गर्न इन्कार गर्ने, अशुद्ध रहने व्यक्‍तिलाई समुदायबाट बहिस्कार गर्नुपर्छ, किनभने त्यसले परमप्रभुको पवित्र स्थानलाई अशुद्ध तुल्यायो । अशुद्धताको निम्ति पानी त्यसमाथि छर्किएको छैन; त्यो अशुद्ध रहनेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","यो यी परिस्थितिसम्बन्धी निरन्तरको नियम हुने छ । अशुद्धताको निम्ति पानी छर्कने व्यक्‍तिले आफ्‍नो लुगा धुनुपर्छ । अशुद्धताको निम्ति पानी छुने व्यक्‍ति साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","अशुद्ध व्यक्‍तिले छोएको सबै कुरा अशुद्ध हुने छन् । यसलाई छुने व्यक्‍ति पनि साँझसम्म अशुद्ध हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","यसैले इस्राएलका सारा समुदाय पहिलो महिनामा जीनको मरुभूमिमा गए; तिनीहरू कादेशमा बसे । ");
INSERT INTO npiulb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","त्यहाँ मिरियम मरिन् र तिनलाई त्यहीँ गाडियो । समुदायको निम्ति त्यहाँ पानी थिएन, त्यसैले तिनीहरू मोशा र हारूनको विरुद्ध भेला भए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","मानिसहरूले मोशा विरुद्ध गनगन गरे । तिनीहरूले भने, “हाम्रा सङ्गी इस्राएलीहरू परमप्रभुको सामु मर्दा हामी पनि मरेका भए राम्रो हुन्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","परमप्रभुको समुदाय, हामी र हाम्रा पशुहरू मर्नलाई किन यहाँ ल्याउनुभएको ? ");
INSERT INTO npiulb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","यो डरलाग्‍दो ठाउँमा ल्याउन हामीलाई किन मिश्रबाट आउन लगाउनुभयो ? यहाँ बिउ, नेभारा, दाख वा अनार केही पनि छैन र पिउने पानी पनि छैन ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","यसैले मोशा र हारून समुदायको सामु गए । तिनीहरू भेट हुने पालको प्रवेश-द्वारमा गए र घोप्टो परे । त्यहाँ परमप्रभुको उज्‍ज्वल महिमा देखा पर्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“लहुरो ले र समुदाय, तँ र तेरा दाजु हारूनलाई भेला गर् । तिनीहरूको नजरकै सामुन्‍ने चट्टानलाई भन् र पानी निकाल्न यसलाई आज्ञा दे । तैँले त्यो चट्टानबाट तिनीहरूका निम्ति पानी निकाल्ने छस् र तैँले यो तिनीहरूलाई र तिनीहरूका गाईवस्तुहरूलाई दिनू ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","परमप्रभुले मोशालाई आज्ञा गर्नुभएजस्तै मोशाले परमप्रभुको सामुबाट लहुरो लिए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","अनि मोशा र हारूनले चट्टानको सामु मानिसहरू भेला पारे । मोशाले तिनीहरूलाई भने, “अब हे बागीहरू हो, सुन । के हामीले तिमीहरूलाई यो चट्टानबाट पानी निकाल्नपर्छ ? ");
INSERT INTO npiulb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","अनि मोशाले आफ्नो हात उठाएर चट्टानलाई दुई पटक हिर्काए, र पानी निस्क्यो । समुदाय र तिनीहरूका गाईवस्तुहरूले पानी पिए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, “तिमीहरूले इस्राएलका मानिसहरूको नजरमा मलाई पवित्र जनको रूपमा आदर नगरेकाले वा मलाई भरोसा नगरेकाले तिमीहरूले यो समुदायलाई मैले तिनीहरूलाई दिन्छु भनेको भूमिमा ल्याउनेछैनौ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","यो ठाउँलाई मेरीबाको पानी भनियो, किनभने इस्राएलका मानिसहरूले त्यहाँ परमप्रभुसँग झगडा गरेका थिए, र उहाँले आफैलाई पवित्र जनको रूपमा प्रकट गर्नुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशाले कादेशबाट एदोमको राजाकहाँ समाचारवाहकहरू पठाएः तपाईंको भाइ इस्राएलले भन्छ, “हामीमाथि आइपरेका सबै कठिनाइ तपाईं जान्‍नुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","हाम्रा पुर्खाहरू मिश्रमा गए र मिश्रमा नै लामो समयसम्म बसेको तपाईंलाई थाहा छ । मिश्रीहरूले हामी र हाम्रा पुर्खाहरूलाई रुखो व्यवहार गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","जब हामीले परमप्रभुलाई पुकार्‍यौँ, उहाँले हाम्रो आवाज सुन्‍नुभयो, र एउटा स्वर्गदूत पठाउनुभयो अनि हामीलाई मिश्रबाट ल्याउनुभयो । हे्र्नुहोस्, हामी तपाईंको देशको सिमानामा पर्ने सहर कादेशमा छौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","हामीलाई तपाईंको भूमिको बाटो भएर जान दिनुहोस् भनी म बिन्ती गर्दछु । हामी खेत वा दाखबारीतिर पस्दैनौँ, न त हामी तपाईंका ईनारहरूको पानी पिउँछौँ । हामीले तपाईंको देशको सिमाना नकाटेसम्म दायाँ वा बायाँ लाग्‍ने छैनौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","तर एदोमको राजाले तिनलाई जवाफ दिए, “तिमीहरू यो मुलुक भएर जान सक्दैनौ । तिमीहरू आयौ भने, म तरवार लिएर आक्रमण गर्न आउने छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","अनि इस्राएलका मानिसहरूले तिनलाई भने, “हामी राजमर्ग भएर मात्र जाने छौँ । यदि हामी र हाम्रा गाईवस्तुहरूले पानी पिए भने हामी यसको मूल्य तिर्ने छौँ । कुनै कुरा नगरी हामीलाई पैदल जान मात्र दिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","तर एदोमका राजाले जवाफ दिए, “तिमीहरू जान सक्दैनौँ ।” यसैले एदोमको राजा ठुलो फौजसहित इस्राएलको विरुद्ध लड्न आए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोमका राजाले इस्राएललाई आफ्नो सिमाना भएर जान दिन इन्कार गरे । यसैले इस्राएल एदोमको भूमिबाट तर्किएर गए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","मानिसहरू कादेशबाट हिँडे । इस्राएलका मानिसहरू अर्थात् सारा समुदाय होर पर्वतमा आए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","एदोमको सिमानामा पर्ने होर पर्वतमा परमप्रभुले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून आफ्‍ना मानिसहरूकहाँ जानुपर्छ, किनभने मैले इस्राएललाई दिएको भूमिमा त्यो प्रवेश गर्ने छैन । यो तिमीहरू दुवैले मेरीबाको पानीमा मेरो विरुद्ध विद्रोह गरेकाले गर्दा हो । ");
INSERT INTO npiulb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","हारून र त्यसका छोरा एलाजारलाई होर पर्वतमाथि ले । ");
INSERT INTO npiulb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","हारूनको पुजारीको पोशाक फुकाल् र त्यो एलाजारलाई लगाइदे । हारून मर्नुपर्छ र आफ्ना मानिसहरूसँग मिल्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मोशाले परमप्रभुले आज्ञा गर्नुभएबमोजिम गरे । तिनीहरू सारा समुदायको सामुबाट होर पर्वतमाथि गए । ");
INSERT INTO npiulb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मोशाले हारूनको पुजारीको पोशाक फुकाले र त्यो तिनका छोरा एलाजारलाई लगाइदिए । पर्वतको चुचुरोमाथि हारून मरे । अनि मोशा र एलाजार तल ओर्ले । ");
INSERT INTO npiulb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","जब हारून मरेका सारा समुदायले देखे, तब सारा जाति हारूनको निम्ति तिस दिनसम्म रोए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","जब नेगेवमा बस्‍ने आरादका कनानी राजाले इस्राएल अटारीमको बाटो भएर यात्रा गरिरहेको थियो भन्‍ने सुने, तिनले इस्राएलसँग लडाइँ लडे र केहीलाई बन्दी बनाए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","इस्राएलले परमप्रभुसँग भाकल गरेर भने, “यदि तपाईंले हामीलाई यी मानिसहरूमाथि वजय दिनुभयो भने, हामी तिनीहरूका सहरहरूलाई पूर्ण रूपमा नष्‍ट पार्ने छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","परमप्रभुले इस्राएलको आवाज सुन्‍नुभयो र उहाँले कनानीहरूमाथि विजय दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","तिनीहरूले तिनीहरूलाई र तिनीहरूका सहरलाई पूर्ण रूपमा नष्‍ट गरे । त्यस ठाउँको नाउँ होर्मा राखियो । तिनीहरूले एदोमको भूमिलाई फेरो मारेर नर्कटको समुद्रको बाटो हुँदै होर पर्वतबाट गए । बाटोमा मानिसहरू अति निरुत्साहित भए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","मानिसहरू परमेश्‍वर र मोशा विरुद्ध बोले, “मरुभूमिमा मर्न तपाईंले हामीलाई मिश्रबाट किन ल्याउनुभयो ? यहाँ रोटी छैन, पानी पनि छैन अनि यो घृणास्पद खाना हामी घृणा गर्छौं ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","परमप्रभुले मानिसहरू माझ विषालु सर्पहरू पठाइदिनुभयो । सर्पहरूले मानिसहरूलाई डसे, र धेरै मानिसहरू मरे । ");
INSERT INTO npiulb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","मानिसहरू मोशाकहाँ आएर भने, “हामीले पाप गरेका छौँ, किनभने हामीले परमप्रभु र तपाईंको विरुद्ध बोलेका छौँ । सर्पहरूलाई हामीबाट हटाउनलाई उहाँसँग बिन्ती गर्नुहोस् ।” यसैले मोशाले मानिसहरूका निम्ति प्रार्थना गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","परमप्रभुले मोशालाई भन्‍नुभयो, “एउटा सर्प बना र यसलाई खामामा झुण्ड्या । सर्पले डसेकाहरू ज-जसले यसलाई हेर्छन् तिनीहरू सबै बाँच्ने छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","यसैले मोशाले काँसाको एउटा सर्प बनाए र त्यसलाई खामामा झुण्ड्याए । जब सर्पले कसैलाई डस्थ्यो, त्यसले काँसाको सर्पमा हरेमा त्यो बाँच्थ्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","त्यसपछि मानिसहरूले यात्रा गरे र ओबोतमा छाउनी लगाए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","तिनीहरू ओबोतबाट गए र मोआबको पूर्वतिर पर्ने इये-अबारीमको मरुभूमिमा छाउनी लगाए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","तिनीहरू त्यहाँबाट यात्रा गरे र जेरेदको बेँसीमा छाउनी लगाए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","तिनीहरूले त्यहाँबाट यात्रा गरे र अर्नोन खोलाको पारिपट्टि छाउनी लगाए, जुन मरुभूमिमा छ र एमोरीहरूको सिमानसम्म नै फैलिएको छ । अर्नोन खोलाले मोआब र एमोरीहरूबिच सिमानाको काम गर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","त्यसैले परमप्रभुको युद्धको पुस्तकमा यस्तो लेखिएको छ, “सूपाको वाहेब र अर्ननोनका बेँसीहरू, ");
INSERT INTO npiulb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","बेँसीका ओह्रालाहरू, जो आरको सहरतिर लाग्छन् र मोआबको सिमानसम्म पुग्छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","तिनीहरूले त्यहाँबाट बेओरसम्म यात्रा गरे । त्यो इनारमा परमप्रभुले मोशालाई भन्‍नुभयो, “मानिसहरूलाई भेला गर् र म तिनीहरूलाई पानी दिन्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","त्यसपछि इस्राएलले यो गीत गायो, “इनारको मूल फुटेर निस्क्यो ! यसको गीत गाओ, ");
INSERT INTO npiulb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","हाम्रा अगुवाहरूले खनेका इनारबारे मानिसहरूका भारदारहरूले खनेका इनार, राजदण्ड र लहुराले खनेका इनार ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","अनि तिनीहरू मरुभूमिबाट मत्तानातिर यात्रा गरे । मत्तानाबाट तिनीहरूले नहलीएलतिर यात्रा गरे र नहलीएलबाट बमोततिर, ");
INSERT INTO npiulb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","र बमोतबाट मोआबको मैदानको बेसीँतिर यात्रा गरे । त्यहाँबाट नै पिसगा पर्वतको चुचुरोको फेदीमा मरुभूमी देखिन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","त्यसपछि इस्राएलले एमोरी राजा सीहोनकहाँ यसो भन्‍दै समाचावाहक पठाए, ");
INSERT INTO npiulb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हामीलाई तपाईंको मुलुक भएर जान दिनुहोस् । हामी खेत वा दाखबारी कतै पस्‍ने छैनौँ । हामी तपाईंका इनाहरूबाट पानी पिउने छैनौँ । हामी तपाईंको सिमाना पार नगरेसम्म राजमार्ग भएर मात्र यात्रा गर्छौं ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","तर राजा सीहोनले तिनीहरूको सिमाना भएर जान इस्राएललाई अनुमति दिएनन् । बरु, सीहोनले तिनका सबै फौज जम्मा गरे र इस्राएललाई मरुभूमिमा आक्रमण गरे । तिनी यहाँसम्म आए, जहाँ तिनले इस्राएलसँग युद्ध गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","इस्राएलले सीहोनको फौजलाई तरवारले आक्रमण गरे र अर्नोनदेखि यब्बोक नदीसम्म साथै अम्मोनका मानिसहरूको भूमिसम्म कब्जा गरे । अम्‍मोनका मानिसहरूको सिमाना किल्लाबन्दी गरिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इस्राएलले हेश्बोन र यसका सबै गाउँसहित एमोरी सहरहरू कब्जा गरे र तिनीहरू सबैमा बसोबास गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेश्बोन एमोरी राजा सीहोनको सहर थियो, जसले मोआबका पहिलेको राजासँग युद्ध गरेका थिए । सीहोनले अर्नोन नदीसम्म उनको देश कब्जा गरेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","यसकारण यसो भनिन्छ, “हेश्बोनमा आओ । सीहोनको सहरको पुनर्निर्माण गरियोस् र फेरि स्थापित होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","हेश्बोनबाट आगोको ज्वाला दन्क्यो, सीहोनको सहरबाट एउटा आगोको ज्वाला जसले मोआबको आरलाई र अर्नोनको उच्‍च स्थलहरूलाई भस्म पार्‍यो । ");
INSERT INTO npiulb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","हे मोआब, तँलाई धिक्‍कार छ! हे कमोशको प्रजा, तँ नष्‍ट भएको छस् । त्यसले आफ्ना छोराहरूलाई भगुवाहरू बनायो र त्यसका छोरीहरूलाई एमोरीहरूका राजा सीहोनको कैदी बनायो । ");
INSERT INTO npiulb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","तर हामीले सीहोनलाई जितेका छौँ । हेश्बोन दीबोनसम्म नै नष्‍ट भएको छ । हामीले तिनीहरूलाई मेदबासम्म पुग्‍ने नोपासम्म नै पारजित गरेका छौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","त्यसैले इस्राएल एमोरीहरूका मुलुकमा बस्‍न थाल्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","अनि मोशाले याजेरको भेद लिन मानिसहरू पठाए । तिनीहरूले यसका गाउँहरू कब्जा गरे र त्यहाँ भएका एमोरीहरूलाई धपाए । ");
INSERT INTO npiulb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","त्यसपछि तिनीहरू फर्के र बाशानको बाटोतिर उक्ले । बाशानका राजा ओग तिनीहरू विरुद्ध निस्के, तिनी र तिनका फौजले एद्रईमा तिनीहरूसँग लडे । ");
INSERT INTO npiulb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, “त्यसँग नडरा, किनभने मैले त्यसलाई, त्यसका सबै फौज र त्यसको भूमि तँलाई दिएको छु । त्यसलाई पनि हेश्बोनमा बस्‍ने एमोरी राजा सीहोनलाई गरेझैँ गर् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","त्यसैले तिनीहरूले कुनै पनि मानिस जीवित नरहुञ्‍जेल उनी, उनका छोराहरू र उनका सबै फौजलाई मारे । अनि तिनीहरूले उनको भूमि कब्‍जा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","इस्राएलका मानिसहरूले यर्दन नदीको पारिपट्टि यरीहो नजिक मोआबको मैदानमा छाउनी नलगाएसम्म यात्रा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","सिप्‍पोरका छोरा बालाकले इस्राएलले एमोरीहरूलाई के गरेका थिए सो देखेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","मोआब ती मानिसहरूसँग साह्रै डराएका थिए, किनभने तिनीहरू धेरै थिए र मोआब इस्राएलका मानिसहरूका त्रासमा थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआबका राजाले मिद्यानका धर्म-गुरुहरूलाई भने, “यो भिडले गोरुले मैदानको घाँस खाएजस्तै हाम्रो वरिपरि भएका सबै थोक खाइदिने छन् ।” यस बेला सिप्‍पोरका छोरा बालाक मोआबका राजा थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","तिनले यूफ्रेटिस नदी नजिकै पतोरमा आफ्नै जाति र मानिसहरूसँग बसेका बओरका छोरा बालामकहाँ समाचारवाहकहरूलाई पठाए । तिनले उनलाई निमन्त्रणा दिए र भने, “हेर्नुहोस्, मिश्रबाट एउटा जाति आएको छ । तिनीहरूले धर्ती नै ढाकेका छन् र अहिले तिनीहरू मेरो छेवैमा छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","त्यसैले तपाईं आउनुहोस् र मेरो निम्ति यस जातिलाई सराप दिनुहोस्, किनभने तिनीहरू मेरो निम्ति ज्यादै बलिया भएका छन् । सायद त्यसपछि मैलै तिनीहरूलाई आक्रमण गर्न र मेरो भूमिबाट लखेट्न सक्छु । तपाईंले जसलाई आशिष् दिनुहुन्छ, त्यो आशिषित्् हुने छ र तपाईंले जसलाई सराप दिनुहुन्छ, त्यो श्रापित हुने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","त्यसैले मोआब र मिद्यानका धर्म-गुरुहरू जोखनाको निम्ति दक्षिणा लिएर गए । तिनीहरू बालामकहाँ आए र बालाकको खबर उनलाई भने । ");
INSERT INTO npiulb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बालामले तिनीहरूलाई भने, “आज राती यहाँ बस्‍नुहोस् । परमप्रभुले जे भन्‍नुहुन्छ सो तपाईंलाई बताउने छु ।” त्यसैले मोआबका अगुवाहरू त्यस रात बालामसँगै बसे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेश्‍वर बालामकहाँ आउनुभयो र भन्‍नुभयो, “तँकहाँ आउने यी मानिसहरू को हुन् ?” ");
INSERT INTO npiulb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बालामले परमेश्‍वरलाई जवाफ दिए, “सिप्‍पोरका छोरा मोआबका राजा बालाकले तिनीहरूलाई मकहाँ पठाएका छन् । तिनले भने, ");
INSERT INTO npiulb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“हेर्नुहोस्, मिश्रबाट आएका मानिसहरूले मेरो भूमि ढाकेका छन् । अब आउनुहोस् र तिनीहरूलाई सराप दिनुहोस् । सायद म तिनीहरूसँग लड्न सक्छु र तिनीहरूलाई लखेट्न सक्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","परमेश्‍वरले बालामलाई जवाफ दिनुभयो, “तँ तिनीहरूसँग जानुहुँदैन । तैँले इस्राएलका मानिसहरूलाई सराप दिनुहुँदैन, किनभने तिनीहरू आशिषित्् भएका छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","बालाम बिहानै उठेर बालाकका अगुवाहरूलाई भने, “तपाईंको देशमा नै फर्केर जानुहोस्, किनभने परमप्रभुले मलाई तपाईंहरूसँग जान दिन इन्कार गर्नुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","त्यसैले मोआबका अगुवाहरू त्यहाँबाट हिँडे र बालाककहाँ फर्केर गए । तिनीहरूले भने, “बालामले हामीसँग आउन इन्कार गरे ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","बालाकले पहिलेका समूहका भन्दा धेरै प्रतिष्‍ठित अगुवाहरूलाई फेरि पठाए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","तिनीहरू बालामकहाँ आए र तिनलाई भने, “सिप्‍पोरका छोरा बालाक भन्‍नुहुन्छ, 'बिन्ती छ, तपाईंलाई मकहाँ आउन कुनै कुराले नरोकोस्, ");
INSERT INTO npiulb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","किनभने मैले तपाईंलाई अत्यधिक राम्रो दक्षिणा दिनेछु र ठुलो इज्‍जत गर्नेछु र तपाईंले जे गर्न भन्‍नुहुन्छ सो म गर्नेछु । त्यसैले आउनुहोस् र यी मानिसहरूलाई सराप दिनुहोस्' ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","बालामले जवाफ दिए र बालाकका मानिसहरूलाई भने, “बालाकले मलाई सुन र चाँदीले भरिएको तिनको दरबार नै दिए पनि म परमप्रभु मेरा परमेश्‍वरको वचनभन्दा बाहिर जान सक्दिनँ अनि उहाँले भन्‍नुभएको भन्दा कम वा बढी गर्न सक्दिनँ । ");
INSERT INTO npiulb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","कृपया आज राती पनि यहीँ पर्खनुहोस्, ताकि परमप्रभुले मलाई के भन्‍नुहुन्छ सो म जान्‍न सकूँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","परमेश्‍वर राती बालामकहाँ आउनुभयो र तिनलाई भन्‍नुभयो, “यी मानिसहरू तँलाई डाक्‍न आएका हुनाले उठ् र तँ तिनीहरूसँग जा । तर मैले भनेको कुरा मात्र गर् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","बालम बिहान उठे र तिनका गधामा काठी कसे र मोआबका अगुवाहरूसँगै गए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","तर तिनी गएकाले परमेश्‍वरको क्रोध दन्क्यो । परमप्रभुका स्वर्गदूतले गधामा सवार बालामप्रति कोही वैरीको रूपमा बाटोमा प्रस्तुत भए । बालामका दुई जना नोकर तिनीसँगै थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","गधाले तरवार थुतेर हातमा लिई बाटोमा उभिरहेका स्वर्गदूत देख्यो । गधा बाटोबाट तर्किएर खेततिर लाग्यो । बालामले गधालाई बाटोमा ल्याउन त्यसलाई कुटे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","त्यसपछि परमप्रभुको दूत दाहिने र देब्रेपट्टि पर्खाल भएको दाखबारी बिचको बटोको साँघुरो ठाउँमा गएर उभिए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","गधाले फेरि पनि परमप्रभुको दूतलाई देख्यो । त्यो पर्खालमा सेपिँदै गयो र बालामको खुट्टालाई पर्खालामा चेपिदियो । बालामले त्यसलाई फेरि पनि पिटे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","त्यसपछि परमप्रभुका दूत अझै अगाडि साँघुरो ठाउँमा गएर उभिए, जहाँ यता-उता कतै फर्कने ठाउँ थिएन । ");
INSERT INTO npiulb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","गधाले परमप्रभुको दूतलाई देख्यो र त्यो बालामको मुनि थचक्‍क बस्यो । बालाम रिसले आगो भए र तिनले गधालाई आफ्नो लहुरोले पिटे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","त्यसपछि परमप्रभुले गधाको मुख खोलिदिनुभयो, त्यसैले त्यो बोल्न सक्यो । त्यसले बालामलाई भन्यो, “मैले तपाईंलाई के गरेको छु र तपाईंले मलाई तिन पटक पिट्नुभएको ?” ");
INSERT INTO npiulb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बालामले गधालाई भने, “तैँले मसँग यति मूर्खतापूर्ण व्यवहार गरिस् । मेरो हातमा तरवार भएको भए हुन्थ्यो । यदि मेरो हातमा तरवार भएको भए, मैले तँलाई मारिसक्‍ने थिएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गधाले बालामलाई भन्यो, “के म तपाईंले आजको दिनसम्म र आफ्नो जीवनकालभरि चढ्नुभएको गधा होइन र ? के यसअघि कहिल्यै तपाईंसँग यसो गर्ने मेरो बानी थियो र ?” बालामले जवाफ दिए, “थिएन ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तब परमप्रभुले बालामको आँखा खोलिदिनुभयो र तिनले परमप्रभुको दूत तरवार थुतेर हातमा लिएर उभिएरहेका देखे । बालामले आफ्नो शिर निहुराए र मुख अँध्यारो बनाए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","परमप्रभुका दूतले तिनलाई भने, “तैँले तेरो गधालाई किन तिन-तिन पटकसम्म कुटिस् ? हेर्, म तेरो शत्रुको रूपमा आएको छु, किनभने तेरा कार्यहरू मेरो नजरमा दुष्‍ट भएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","गधाले मलाई देखेर तिन-तिन पटकसम्म मबाट तर्क्यो । यदि त्यो मबाट नतर्केको भए, निश्‍चय नै मैले तँलाई मार्नेथिएँ र त्यसलाई छोड्नेथिएँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बालामले परमप्रभुका दूतलाई भने, “मैले पाप गरेको छु । तपाईं बाटोमा मेरो विरुद्ध खडा हुनुभएको छ भन्‍ने मैले थाहा पाइनँ । त्यसैले यदि तपाईंलाई मन पर्दैन भने, म फर्कने छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","तर परमप्रभुका दूतले बालामलाई भने, “यी मानिसहरूसँग जा । तर तैँले म जे भन्‍छु सो मात्र भन्‍नुपर्छ ।” त्यसैले बालाम बालाकका अगुवाहरूसँग गए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बालाम आएका थिए भन्‍ने बालाकले सुने, उनी तिनलाई भेट्न मोआबको सहर अर्नोनमा भेट्न गए, जुन सिमाना पर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाकले बालामलाई भने, “के मैले तपाईंलाई डाक्‍न मानिसहरू तपाईंकहाँ पठाइनँ र ? तपाईं मकहाँ किन आउनुभएन ? के म तपाईंलाई आदर गर्न सक्षम छैन र ?” ");
INSERT INTO npiulb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","त्यसपछि बालामले बालाकलाई जवाफ दिए, “हेर्नुहोस्, म तपाईंकहाँ आएको छु । के मसँग कुनै कुरा भन्‍ने शक्ति छ र? मैले त परमेश्‍वरले मेरो मुखमा जे हालिदिनुहुन्छ त्यही मात्र भन्‍न सक्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","बालाम बालाकसँग गए र तिनीहरू किर्यत-हुसोतमा आइपुगे । ");
INSERT INTO npiulb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","त्यसपछि बालाकले गोरुहरू र भेडाहरू बलि चढाए अनि तिनले केही मासु बालाम र तिनीसँग भएका अगुवाहरूलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","बिहान बालाकले बालामलाई बालको उच्‍च स्थानमा लगे । त्यहाँबाट बालामले इस्राएलीहरूलाई तिनीहरूको छाउनीमा थोरै मात्र देख्‍न सक्थे । ");
INSERT INTO npiulb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बालामले बालाकलाई भने, “यहाँ मेरो निम्ति सातवटा वेदी निर्माण गर्नुहोस्, र सातवटा साँढे र सातवटा भेडा तयार पार्नुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालाकले बालामले भनेजस्तै गरे । अनि बालाक र बालामले हरेक वेदीमा एउटा-एउटा साँढे र भेडा बलि चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","अनि बालामले बालाकलाई भने, “तपाईं आफ्‍नो बलिदानको छेउमा खडा हुनुहोस् र म जाने छु । सायद परमप्रभु मलाई भेट्न आउनुहुने छ । उहाँले मलाई जे देखाउनुहुन्छ, सो म गर्ने छु ।” त्यसैले तिनी कुनै रुख नभएको पहडाको चुचुरोतिर गए । ");
INSERT INTO npiulb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","तिनी पहाडको टुप्पोमा हुँदा परमेश्‍वरले तिनलाई भेट्नुभयो र बालामले उहाँलाई भने, “मैले सातवटा वेदी बनाएको छु र मैले हरेक वेदीमा एउटा-एउटा साँढे र भेडा बलि चढाएको छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","परमप्रभुले बालामको मुखमा वचन हालिदिनुभयो र भन्‍नुभयो, “बालाककहाँ फर्केर जा र त्यसलाई भन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","त्यसैले बालाम बालाककहाँ फर्के, जो आफ्‍नो बलिदानको छेउमा उभिरहेका थिए र मोआबका सबै अगुवा तिनीसँग थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","बालामले अगमवाणी कहन थाले र भने, “मोआबका राजा बालाकले मलाई पूर्वका पहाडहरूबाट अर्थात् अरामबाट ल्याएका छन् । तिनले भने, 'आउनुहोस् मेरो निम्ति याकूबलाई सराप दिनुहोस् ।' 'आउनुहोस्, इस्राएललाई धम्की दिनुहोस् ।' ");
INSERT INTO npiulb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","परमेश्‍वरले नै सराप नदिनुभएकालाई मैले कसरी सराप दिन सक्छु ? परमप्रभुले नै विरोध नगर्नुभएकाहरूलाई मैले कसरी विरोध गर्न सक्छु ? ");
INSERT INTO npiulb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","म तिनलाई पहाडको चुचुरोबाट देख्छु; म तिनलाई पहाडबाट हेर्छु । हेर्नुहोस्, एक्लै बस्‍ने मानिसहरू र आफूलाई साधारण जातिको रूपमा ठान्दैनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकूबको धूलोलाई वा इस्राएलको एक चौथाइलाई मात्र पनि कसले गन्‍न सक्छ ? मेरो मरण धार्मिक व्यक्‍तिको जस्तो होस् र मेरो जीवन त्यसको जस्तै होस् !” ");
INSERT INTO npiulb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बालाकले बालामलाई भने, “तपाईंले मलाई के गर्नुभएको ? मेरा शत्रुहरूलाई सराप दिनुहोस् भनी मैले तपाईंलाई ल्याएँ, तर हे्र्नुहोस्, तपाईंले त तिनीहरूलाई आशिष् दिनुभयो ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बालामले जवाफ दिए र भने, “के परमप्रभुले मेरो मुखमा जे हाल्नुहुन्छ सो मात्र भन्‍न म सावधान हुनुपर्दैन र ?” ");
INSERT INTO npiulb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","बालाकले तिनलाई भने, “कृपया मसँग अर्को ठाउँमा आउनुहोस् जहाँबाट तपाईंले तिनीहरूलाई देख्‍न सक्‍नुहुन्छ । तपाईंले तिनीहरूलाई नजिकको मात्र देख्‍नुहुने छ, तर तिनीहरू सबैलाई देख्‍नुहुने छैन । तपाईंले तिनीहरूलाई त्यहाँबाट सराप दिनुहुने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","त्यसैले तिनले बालामलाई सोफीमको मैदानमा भएको पिसगाको टाकुरामा लगे, र अरू सातवटा वेदी बनाए । तिनले हरेकमा एउटा-एउटा साँढे र भेडा बलि चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","त्यसपछि बालामले बालाकलाई भने, “यहीँ नै तपाईंको बलिदानको छेउमा उभिनुहोस्, म परमप्रभुलाई भेट्न जान्छु ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","त्यसैले परमप्रभुले बालामलाई भेट्नुभयो र तिनको मुखमा सन्देश हालिदिनुभयो । तिनले भने, “बालाककहाँ जा र तिनलाई मेरो सन्देश दे ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","बालाम तिनीकहाँ फर्केर आए र तिनी आफ्नो होमबलिको छेउमा उभिरहेका थिए र मोआबका अगुवाहरू तिनीसँग थिए । अनि बालाकले तिनलाई भने, “परमप्रभुले के भन्‍नुभयो ?” ");
INSERT INTO npiulb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","बालामले अगमवाणी गर्न थाले, “उठ् बालाक र सुन् । हे सिप्पोरका छोरा मेरो कुरा सुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्‍वर मानिस वा मानव हुनुहुन्‍न कि उहाँले ढाँट्नुपरोस्, उहाँले आफ्नो मन बदल्नुपरोस् । के उहाँले पुरा नगर्ने गरी कुनै कुरा प्रतिज्ञा गर्नुभएको छ ? के उहाँले कुनै गर्छु भनेर पुरा गर्नुभएको छैन र ? ");
INSERT INTO npiulb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","हेर्नुहोस्, आशिष् दिने आज्ञा मलाई दिइएको छ । परमेश्‍वरले आशिष् दिनुभएको छ र म यसलाई उल्टाउन सक्दिनँ । ");
INSERT INTO npiulb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","उहाँले याकूबसँग कुनै कठिनाइ वा इस्राएलमा कुनै कष्‍ट देख्‍नुभएको छैन । परमप्रभु तिनीहरूका परमेश्‍वर तिनीहरूसँग हुनुहुन्छ र तिनीहरूका राजाको जय-ध्वनि तिनीहरूमाझ छ । ");
INSERT INTO npiulb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्‍वरले तिनीहरूलाई जङ्गली गोरुको जस्तै शक्‍तिले मिश्रबाट ल्याउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकूब विरुद्ध कुनै टुनामुनाले काम गर्दैन र इस्राएललाई कुनै जोखनाले हानि पुर्‍याउँदैन । बरु, याकूब र इस्राएलबारे यसो भन्‍नुपर्छ, 'हेर, परमेश्‍वरले के गर्नुभएको छ !' ");
INSERT INTO npiulb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","हेर, मानिसहरू सिंहनीजस्तै उठ्छन्, सिंहजस्तै उठ्छन् र आक्रमण गर्छन् । त्यो आफ्नो सिकारलाई नखाएसम्म र त्यसले मारेको सिकारको रगत नपिएसम्म आराम गर्दैन ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","त्यसपछि बालाकले बालामलाई भने, “तिनीहरूलाई सराप नदिनुहोस् वा आशिष् पनि नदिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","तर बालामले जवाफ दिए र भने, “के परमप्रभुले भन्‍नलाई बताउनुभएको कुरा मात्र मैले भन्‍नुपर्छ भनी मैले भनेको थिइनँ र ?” ");
INSERT INTO npiulb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","त्यसैले बालाकले बालामलाई जावाफ दिए, “अब आउनुहोस्, म तपाईंलाई अर्को ठाउँमा लैजान्छु । सायद त्यहाँबाट मेरो निम्ति तिनीहरूलाई सराप दिन परमेश्‍वरले इच्छा गर्नुहुने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","त्यसैले बालाकले बालामलाई पोरको टाकुरामा लगे, जहाँबाट तल मरुभूमि देखिन्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बालामले बालाकलाई भने, “यहाँ सातवटा वेदी बनाउनुहोस् अनि सातवटा साँढे र भेडा तयार पार्नुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बालाकले बालामले भनेबमोजिम गरे; तिनले हरेक वेदीमा एउटा-एउटा साँढे र भेडा बलि चढाए । ");
INSERT INTO npiulb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","परमप्रभुले इस्राएललाई आशिष् दिन नै रुचाउनुहुन्छ भन्‍ने जब बालामले देखे, तिनी अरू बेलाझैँ टुनामुना गर्नलाई गएनन् । बरु, तिनले मरुभूमितिर हेरे । ");
INSERT INTO npiulb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","तिनले आँखा खोलेर इस्राएल कुल-कुल गरी आ-आफ्नो छाउनीमा देखे र परमेश्‍वरका आत्मा तिनीमाथि आयो । ");
INSERT INTO npiulb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","तिनले यो अगमवाणी पाए र भने, “बओरका छोरा बालाम बोल्न लाग्दै छ, जुन मानिसका आँखा खुला छन्, त्यसका वाणी । ");
INSERT INTO npiulb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","तिनले परमप्रभुको वचन सुन्छ र बोल्छ । त्यसले सर्वशक्‍तिमान्‌बाट दर्शन प्राप्‍त गर्छ, जसको सामु त्यसले आँखा खुला राखेर दण्डवत् गर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","हे याकूब, तिम्रा पालहरू र तिमी बस्‍ने ठाउँ कति सुन्दर छन् ! ");
INSERT INTO npiulb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","तिनीहरू उपत्यकाझैँ, नदी किनारको बगैँचाझैँ, परमप्रभुले रोप्‍नुभएको एलवाहरूजस्तै र पानी छेउका देवदारुजस्तै फैलिएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","तिनीहरूका गाग्राहरूबाट पानी बग्छ र तिनीहरूका बिउहरू सुसिंचित छन् । तिनीहरूका राजा अगागभन्दा उच्‍च छन् र तिनीहरूका राज्यलाई आदर गरिने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","परमेश्‍वरले तिनलाई मिश्रबाट जङ्गली साँढेको जस्तै सामर्थ्यमा ल्याउनुहुन्छ । तिनले त्यसको विरुद्ध लड्ने जातिहरूलाई निल्छन् । तिनले तिनीहरूका हड्‍डीहरूलाई टुक्रा-टुक्रा पार्ने छन् । तिनले तिनीहरूलाई आफ्ना वाणहरूले हान्छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","तिनले सिंह, सिंहनीझै ढुक्छन् । तिनलाई उठाउने कसको आँट छ र ? तिनलाई आशिष् दिने सबै आशिषित्् होऊन्; तिनलाई सराप दिने सबै श्रापित होऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","बालाकको क्रोध बालामप्रति उर्लियो र तिनले आफ्ना हात ठटाए । बालाकले बालामलाई भने, “मैले मेरा शत्रुहरूलाई सराप दिन तपाईंलाई बोलाएँ, तर तपाईंले तिनीहरूलाई तिन पटकसम्म आशिष् दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","त्यसैले अहिले नै गइहाल्नुहोस् । मैले तपाईंलाई भव्य इनाम दिन्छु भनेको थिएँ, तर परमप्रभुले तपाईंलाई इनाम पाउनबाट वञ्‍चित गर्नुभएको छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","त्यसपछि बालामले बालाकलाई जवाफ दिए, “तपाईंले मकहाँ पठाउनुभएका सन्देशवाहकहरूलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","'बालाकलाई चाँदी र सुनले भरिएको तिनको दरबार नै दिए पनि, म परमप्रभुको बाहिर मैले चाहेको असल वा खराब कुनै पनि कुरा गर्न सक्दिनँ । म परमप्रभुले मलाई भन्‍नुहुने कुरा मात्र बताउन सक्छु ।' के मैले तिनीहरूलाई यो कुरा भनेको थिइनँ र ? ");
INSERT INTO npiulb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","त्यसैले अब म मेरा मानिसहरूकहाँ फर्केर जाने छु । तर यी मानिसहरूले तपाईंका मानिसहरूलाई आगामी दिनहरूमा के गर्ने छन् पहिले तपाईंलाई चेताउनी दिन दिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","बालामले अगमवाणी गर्न थाले, “बओरका छोरा बालाम भन्छ, त्यो मानिस जसको आँखा खुला छन्, त्यसको वाणी । ");
INSERT INTO npiulb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","यो परमेश्‍वरको वचन सुन्‍नेको व्यक्‍तिको अगमवाणी हो, जससँग सर्वोच्‍चको ज्ञान छ, जससँग सर्वशक्‍तिमान्‌बाट आएको दर्शन छ, जसले उहाँको सामु खुला आँखाले दण्डवत् गर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","म उहाँलाई देख्‍छु, तर उहाँ अहिले यहाँ हुनुहुन्‍न । म उहाँलाई हेर्छु, तर उहाँ नजिक हुनुहुन्‍न । याकूबबाट एउटा तारा निस्की आउने छ र इस्राएलबाट राजदण्डको उदय हुने छ । तिनले मोआबका अगुवाहरूलाई चकनाचुर पार्ने छन् र शेथका सबै सन्तानलाई नष्‍ट पार्नेछन् । ");
INSERT INTO npiulb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","त्यसपछि एदोम इस्राएलको सम्पत्ति बन्‍ने छ र सेइर इस्राएलको अधीनमा हुने छ इस्राएलका शत्रुहरू जसलाई इस्राएलले बलले जित्‍नेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकूबबाट एउटा राजा आउने छ जसले शासन गर्ने छ र तिनले तिनीहरूका सहरहरूका बाँचेकाहरूलाई नष्‍ट पार्ने छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","त्यसपछि बालामले अमालेकतिर हेरे र अगमवाणी गर्न थाले, “अमालेक एक पटक जातिहरूमध्ये सबैभन्दा ठुलो थियो, तर त्यसको अन्त विनाश हुने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","अनि बालामले केनीहरूतिर हेरे र अगमवाणी गर्न थाले, “तिमीहरू बस्‍ने ठाउँ बलियो छ र तिमीहरूका गुँड चट्टान हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तथापि अश्शूरले तिमीहरूलाई कैद गरेर लाँदा तिमीहरू आगोले नष्‍ट हुने छौ । ");
INSERT INTO npiulb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","बालामले तिनको अन्तिम अगमवाणी भने, “धिक्‍कार! परमेश्‍वरले यसो गर्नुहुँदा कोचाँहि बाँच्‍छ ? ");
INSERT INTO npiulb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तीमको समुद्री तटबाट जहाजहरू आउने छन्; तिनीहरूले अश्शूरलाई आक्रमण गर्नेछन् र एबेरमाथि विजय हासिल गर्ने छन्, तर तिनीहरू अन्त पनि विनाशमा नै हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","त्यसपछि बालाम उठे र हिँडे । तिनी आफ्नै घरतिर फर्के र बालाक पनि गए । ");
INSERT INTO npiulb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएल सित्तीमम बसे र पुरुषहरूले मोआबका स्‍त्रीहरूसँग व्यभिचार गर्न थाले, ");
INSERT INTO npiulb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","किनभने मोआबीहरूले उनीहरूका देवताहरूलाई बलिदान चढाउन मानिसहरूलाई बोलाएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","इस्राएलका मानिसहरूले पोरको बाललाई पुज्‍न थाले, र परमप्रभुको क्रोध इस्राएल विरुद्ध दन्कियो । ");
INSERT INTO npiulb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","परमप्रभुले मोशालाई भन्‍नुभयो, “मानिसहरूका अगुवा सबैलाई मार् तिनीहरूलाई चर्को घाममा मेरो सामु झुन्डा, ताकि मेरो भयङ्कर क्रोध इस्राएलबाट हटेर जाओस् । ");
INSERT INTO npiulb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","त्यसैले मोशाले इस्राएलका अगुवाहरूलाई भने, “पोरको बालको पूजामा सहभागी हुने सबैलाई मार्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","अनि इस्राएलका मानिसहरूमध्ये एक जना आयो र मिद्यानी महिलालाई त्यसको परिवारका सदस्यहरू माझ ल्यायो । यो घटना मोशा र इस्राएलका सबै समुदाय भेट हुने पालको सामु रोइरहँदा भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जब पुजारी हारूनका नाति एलाजारका छोरा पीनहासले त्यो देखे, तिनी समुदायको बिचबाट उठेर गए अनि हातमा भाला लिए । ");
INSERT INTO npiulb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","तिनी त्यो इस्राएली पुरुषको पछि-पछि पालभित्र गए र तिनीहरूले इस्राएली पुरुष र महिला दुवैलाई भालाले रोपे । त्यसैले परमेश्‍वरले इस्राएलका मानिसहरूमाथि पठाउनुभएको विपत्ति रोकियो । ");
INSERT INTO npiulb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","त्यो विपत्तिद्वारा मर्नेहरूको सङ्ख्या चौबिस हजार थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“पुजारी हारूनका नाति एलाजारका छोरा पीनहासले इस्राएलका मानिसहरूबाट मेरो क्रोधलाई टारेको छ, किनभने तिनी तिनीहरू माझ मेरो जोसले जोसिला भएका थिए । त्यसैले मैले इस्राएलका मानिसहरूलाई मेरो क्रोधमा विनाश गरिनँ । ");
INSERT INTO npiulb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","यसकारण परमप्रभु भन्‍नुहुन्छ, “म मेरो शान्तिको करार पीनहासलाई दिँदै छु । ");
INSERT INTO npiulb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","त्यो र त्यसपछिका त्यसका सन्तानहरूका निम्ति पुजारीको पद अनन्‍तको करार हुने छ, किनभने त्यो मेरो अर्थात् त्यसको परमेश्‍वरको निम्ति जोसिलो भयो । मिद्यानी महिलासँगै मारिएको ");
INSERT INTO npiulb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","इस्राएली पुरुषको नाउँ शिमियोनको कुलका अगुवा सालूका छोरा जिम्री थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","त्यो मारिएको मिद्यानी महिलाको नाउँ सूरकी छोरी कोजबी थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","त्यसैले परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानीहरूलाई शत्रुहरूलाई झैँ व्यवहार गर् र तिनीहरूलाई आक्रमण गर्, ");
INSERT INTO npiulb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","किनभने तिनीहरूले तिनीहरूका छलद्वारा शत्रुहरूलाई झैँ व्यवहार गरे । तिनीहरूले पोरको र पोरको विषयमा आएको विपत्तिको दिनमा मारिएकी तिनीहरूकी बहिनी कोजबीको सन्दर्भमा तिमीहरूलाई दुष्‍टतातिर लगे । ");
INSERT INTO npiulb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","विपत्तिपछि परमप्रभुले मोशा र पुजारी हारूनका छोरा एलाजारलाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“इस्राएलका सारा समुदायलाई तिनीहरूका पुर्खाहरूका कुल-कुलअनुसार बिस वर्ष र त्यसभन्दा माथिका इस्राएलका निम्ति युद्धमा जान सक्‍ने सबैको गन्ती गर ।” ");
INSERT INTO npiulb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","त्यसैले मोशा र पुजारी एलाजारले यर्दन नजिकैको मोआबको मैदान यरीहोमा तिनीहरूलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“परमप्रभुले मोशा र इस्राएलका मानिसहरूलाई आज्ञा गर्नुभएअनुसार बिस वर्ष र त्यसभन्दा माथिका मिश्रबाट आएका मानिसहरूको गन्ती गर ।” ");
INSERT INTO npiulb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","रूबेन इस्राएलका जेठा छोरा थिए । तिनको छोरा हानोकबाट हानोकीहरूको वंश आयो । पल्लुबाट पल्लुईहरूको वंश आयो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोनबाट हेस्रोनीहरूको वंश आयो । कर्मीबाट कर्मीहरूको वंश आयो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","यिनीहरू रूबेनका कुलहरू थिए, जसको सङ्ख्या ४३,७३० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","एलीआब पल्लुका छोरा थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","एलीआबका छोराहरू नमूएल, दातान र अबीराम थिए । मोशा र हारूनलाई चुनौती दिँदा अनि परमप्रभुको विरुद्धमा विद्रोह गर्दा कोरहको पछि लाग्‍ने दातान र अबीराम यिनै थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","कोरहलाई पछ्याउने सबै मर्दा पृथ्वीले मुख बायो र तिनीहरूलाई निल्यो । त्यस बेला २५० जना आगोले भस्म भए, जो चेताउनीका सङ्केत भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","तर कोरहका वंश मरेनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमियोनका सन्तानहरू यिनै थिएः नमूएलबाट नमूएलीहरूको वंश, यामीनबाट यामिनीहरूको वंश, याकीनबाट याकीनीहरूको वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरहबाट जेरहातीहरूको वंश, शौलबाट शौलीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","यिनीहरू शिमियोनका सन्तानहरूका कुलहरू थिए, जसको सङ्ख्या २२,२०० थियो । यिनीहरू ");
INSERT INTO npiulb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","दानका सन्तानहरूका कुलहरू थिएः सेफोनबाट सेफोनीहरूका वंश, हाग्यीबाट हाग्यीहरूको वंश, शूनीबाट शूनीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनीबाट ओजनीहरूको वंश, एरीबाट एरीहरूको वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोदबाट अरोदीहरूको वंश, अरेलीबाट अरेलीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","यिनीहरू दानका सन्तानहरूका कुलहरू थिए, जसको सङ्ख्या ४०,५०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","एर् र ओनान यहूदाका छोराहरू थिए, तर यिनीहरू कनानको भूमिमा नै मरे । ");
INSERT INTO npiulb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदाका अन्य सन्तानहरूका कुलहरू यिनै थिएः शेलहबाट शेलानीहरूको वंश, फारेसबाट फारेसीहरूको वंश, जेरहबाट जेहातीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","फारेसका सन्तानहरू यिनै थिएः हेस्रोनबाट हेस्रोनीहरूको वंश, हामूलबाट हामूलीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यिनीहरू यहूदाका सन्तानहरूका कुलहरू थिए, जसको सङ्ख्या ७६,५०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","यिनीहरू इस्साखारका सन्तानहरूका कुलहरू थिएः तोलाबाट तोलाहीहरूको वंश, पुवाबाट पुवातीहरूको वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूबबाट याशूबीहरूको वंश, शिम्रोनबाट शिम्रनीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","यिनीहरू इस्साखारका कुलहरू थिए, जसको सङ्ख्या ६४,३०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","यिनीहरू जबूलूनका सन्तानहरूका कुलहरू थिएः सेरेदबाट सेरेदीहरूको वंश, एलोनबाट एलोनीहरूको वंश, यहलेलबाट यहेलेलीको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","यिनीहरू जबूलूनका कुलहरू थिए, जसको सङ्ख्या ६०,५०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","योसेफका सन्तानहरूका कुलहरू मनश्‍शे र एफ्राइम थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","यिनीहरू मनश्‍शेका सन्तानहरू थिएः माकीरबाट माकीरीहरूको वंश (माकीर गिलादका बुबा थिए), ");
INSERT INTO npiulb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलादबाट गिलादीहरूका वंश भए । यिनीहरू गिलादका सन्तानहरू थिएः ईएजेरबाट ऐएजेरीहरूका वंश, हेलेकबाट हेलेकीहरूका वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रीएलबाट अस्रीएलीहरूका वंश, शकेमबाट शकेमीहरूका वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शमीदाबाट शमीदीहरूका वंश, हेपेरबाट हेपेरहरूका वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","हेपेरका छोरा सलोफादका छोराहरू थिएनन्, तर छोरीहरू मात्र थिए । तिनका छोरीहरूका नाउँ महला, नोआह, होग्‍ला, मिल्का र तिर्सा थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","यिनीहरू मनश्‍शेका कुलहरू थिए, जसको सङ्ख्या ५२,७०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","यिनीहरू एफ्राइमका सन्तानहरूका कुलहरू थिएः शूतेलहबाट शूतेलहीहरूका वंश, बेकेरबाट बेकेरीहरूका वंश, तहनबाट तहनीहरूका वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","शूतेलहका सन्तानहरू, एरानबाट एरानीहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","यिनीहरू एफ्राइमका सन्तानहरूका कुलहरू थिए, जसको सङ्ख्या ३२,५०० थियो । यिनीहरू आ-आफ्ना कुलअनुसार गन्ती गरिएका योसेफका सन्तानहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","यिनीहरू बेन्यामीनका सन्तानहरूका कुलहरू थिएः बेलाबाट बेलाहीहरूका वंश, अश्बेलबाट अश्बेलीहरूका वंश, अहीरामबाट अहीरामीहरूका वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शूपामबाट शूपामीहरूको वंश, हूपामबाट हूपामीहरूका वंश भए । आर्द र नामान ");
INSERT INTO npiulb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बेलाका छोराहरू थिए । आर्दबाट आर्दीहरूका वंश, नामानबाट नामानीहरूका वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","यिनीहरू बेन्यामीनका सन्तानहरूका कुलहरू थिए । तिनीहरूको सङ्ख्या ४५,६०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","शूहामबाट आएका शूहामीहरूका वंश नै दानका सन्तानहरूका कुलहरू थिए । यिनीहरू दानका सन्तानका कुलहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","शूहामीहरूका सबै कुलको सङ्ख्या ६४,४०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेरका सन्तानहरूका कुलहरू यिनै थिएः यिम्‍नाबाट यिम्‍नीहरूका वंश, यिश्‍वीबाट यिश्‍वीहरूका वंश, बरीआबाट बरीआतीहरूका वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","बरीआका सन्तानहरू यिनै थिएः हेबेरबाट हेबेरीहरूका वंश, मल्कीएलबाट मल्कीएलीहरूका वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेरकी छोरीको नाउँ सेरह थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","यिनीहरू आशेरका सन्तानहरूका कुलहरू थिए, जसको सङ्ख्या ५३,४०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","यिनीहरू नप्‍तालीका सन्तानहरूका वंशहरू थिएः यहसीलबाट यहसीलीहरूका वंश, गुनीबाट गुनीहरूका वंश, ");
INSERT INTO npiulb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेरबाट येसेरीहरूका वंश, शिल्लेमबाट शिल्लेमीहरूको वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","यिनीहरू नप्‍तालीका सन्तानहरूका वंशहरू थिए, जसको सङ्ख्या ४५,४०० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस्राएलका मानिसहरूका गनिएका पुरुषहरूका पुरा सङ्ख्या ६,०१,७३० थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","परमप्रभु मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“यो भूमि तिनीहरूका आ-आफ्ना नाउँको सङ्ख्याअनुसार यी मानिसहरू माझ उत्तराधिकारको रूपमा बाँड्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ठुलो कुललाई ठुलो अंश दिनुपर्छ र सानो कुललाई सानो अंश दिनुपर्छ । हरेक कुललाई गनिएका पुरुषहरूको सङ्ख्याअनुसार एक‍-एक अंश दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","तथापि, भूमिलाई चिट्ठा हालेर बाँड्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","आ-आफ्ना कुललाई बाँडिदिएअनुसार तिनीहरूले भूमि पाउनुपर्छ । तिनीहरूलाई चिट्ठाद्वारा बाँडिदिएअनुसार ठुला र साना कुलहरूलाई आ-आफ्ना अंश भाग लगाउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","वंश-वंशअनुसार गन्ती गरिएका लेवीका वंश यिनै थिएः गेर्शोनबाट गेर्शोनीहरूका वंश, कहातबाट कहातीहरूका वंश, मरारीबाट मरारीहरूका वंश भए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","यिनीहरू लेवीका वंशहरू थिएः लिब्‍नीहरूका वंश, हेब्रोनीहरूका वंश, महलीहरूका वंश, मूशीहरूका वंश, कोरहीहरूका वंश । कहात अम्रामका पूर्खा थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","लेवी कुलका सन्तान अम्रामकी पत्‍नीको नाउँ योकेबेद थियो, जो मिश्रमा लेवी कुलमा जन्मेकी थिइन् । तिनीबाट अम्रामका छोराछोरीहरू हारून, मोशा र तिनीहरूका दिदी मिरियम जन्मे । ");
INSERT INTO npiulb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","हारूनबाट नादाब र अबीहू, एलाजार र ईतामार जन्मे । ");
INSERT INTO npiulb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","नदाब र अबीहूले परमप्रभुको सामु अस्वीकार्य आगो चढाउँदा तिनीहरू मरे । ");
INSERT INTO npiulb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","तिनीहरू माझ एक महिना र त्यसभन्दा माथिका गन्ती गरिएका पुरुषहरूको सङ्ख्या तेइस हजार थियो । तर तिनीहरूलाई इस्राएलका सन्तानहरूमाझ गन्ती गरिएन, किनभने तिनीहरूलाई इस्राएलका मानिसहरूमाझ कुनै अंश दिइएको थिएन । ");
INSERT INTO npiulb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मोशा र पुजारी एलाजारले गन्ती गरेकाहरू यिनीहरू नै थिए । तिनीहरूले इस्राएलका मानिसहरूलाई यरीहोपारि यर्दन नजिकै मोआबको मैदानमा गन्ती गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","तर यिनीहरूमा मोशा र पुजारी हारूनले सीनैको मरुभूमिमा गन्ती गरेका इस्राएलका सन्तानहरू कुनै पनि थिएनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","किनभने ती मानिसहरू सबै मरूभूमीमा नै मर्नेथिए भनी परमप्रभुले भन्‍नुभएको थियो । तिनीहरूमा यपुन्‍नेका छोरा कालेब र नूनका छोरा यहोशूबाहेक कोही पनि बाँकी रहेनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","योसेफका छोरा मनश्शेका कुलका, मनश्शेका छोरा माकीर, माकीरका छोरा गिलेद, गिलेदका छोरा हेपेर, हेपेरका छोरा सलोफादका छोरीहरू मोशाकहाँ आए । तिनका छोरीहरूका नाउँ यिनै थिएः महला, नोआह, होग्‍ला, मिल्का र तिर्सा । ");
INSERT INTO npiulb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","तिनीहरू भेट हुने पालको प्रवेश-द्वारमा मोशा, पुजारी एलाजार, अगुवाहरू र सारा समुदायको सामु खडा भए । ");
INSERT INTO npiulb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","तिनीहरूले भने, “हाम्रा बुबा मरुभूमिमा मरे । तिनी परमप्रभुको विरुद्धमा विद्रोह गर्ने कोरहको दलमा थिएनन् । तिनी आफ्नै पापको कारण मरे र तिनका कुनै छोराहरू छैनन् । ");
INSERT INTO npiulb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","तिनका छोराहरू नभएकै कारण हाम्रा बुबाको नाउँ तिनका कुलका सदस्यहरूको बिचबाट किन निर्मूल गर्ने ? हामीहरूलाई हाम्रा बुबाका नातेदारहरूमाझ जग्‍गा दिनुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","त्यसैले मोशाले तिनीहरूको विषयलाई परमप्रभुकहाँ ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलोफादका छोरीहरूले ठिकै भनिरहेका छन् । तैँले तिनीहरूलाई तिनीहरूका बुबाका नातेदारहरूमाझ उत्तराधिकारको रूपमा अंश दिनुपर्छ र तिनीहरूका बुबाको उत्तराधिकार तिनीहरूकै स्वामित्वमा रहोस् भनी तैँले निश्‍चय गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","तैँले इस्राएलका मानिसहरूलाई भन्, 'यदि कुनै मानिस मर्छ र त्यसको छोरा छैन भने, तिमीहरूले त्यसको सम्पत्ति त्यसकी छोरीलाई दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","यदि त्यसकी छोरी छैन भने, तिमीहरूले त्यसको अंश त्यसको आफ्नो भाइलाई दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","यदि त्यसको भाइ छैन भने, तिमीहरूले त्यसको अंश त्यसका बुबाका भाइहरूलाई दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","यदि त्यसका बुबाका भाइहरू छैनन् भने, तिमीहरूले त्यसको अंश त्यसको कुलको सबैभन्दा नजिकको नातेदारलाई दिनुपर्छ । त्यसले त्यो आफ्नो निम्ति ग्रहण गर्नुपर्छ । यो परमप्रभुले मलाई आज्ञा गर्नुभएअनुसार इस्राएलका मानिसहरूका निम्ति आदेशद्वारा स्थापित गरिएको नियम हुने छ' ।” ");
INSERT INTO npiulb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","परमप्रभुले मोशालाई भन्‍नुभयो, “अबारीम पर्वतमाथि जा र मैले इस्राएलका मानिसहरूलाई दिएको भूमिलाई हेर् । ");
INSERT INTO npiulb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","तैँले यसलाई हेरेपछि तँ पनि तेरा दाजु हारूनजस्तै तेरा मानिसहरूकहाँ जानुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","तिमीहरू दुवै जनाले सीनको मरुभूमिमा मेरो आज्ञा विरुद्ध विद्रोह गरेको हुनाले यस्तो हुने छ । त्यहाँ चट्टानबाट पानी बगेर निस्कँदा तिमीहरूका रिसमा तिमीहरूले सारा समुदायको नजरमा पवित्र जनको रूपमा मलाई आदर गर्न चुक्यौ ।” यो घटना सीनको मरूभूमिको कादेशको मेरीबाको पानीमा भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","त्यसपछि मोशाले परमप्रभुलाई भने, ");
INSERT INTO npiulb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“हे सबै मानव-जातिका आत्माका परमप्रभु परमेश्‍वर, समुदायमाथि एक जना मानिस नियुक्‍त गर्नुहोस्, ");
INSERT INTO npiulb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","एउटा यस्तो मानिस जो तिनीहरूको अघिअघि बाहिर जाओस् र भित्र आओस् अनि तिनीहरूलाई बाहिर जाँदा र भित्र आउँदा नेतृत्व गरोस्, ताकि तपाईंका समुदाय गोठालोविनाका भेडाहरूजस्ता नहोऊन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","परमप्रभुले मोशालाई भन्‍नुभयो, “नूनका छोरा यहोशूलाई ले, एउटा मानिस जसमा मेरो आत्मा छ र त्यसमाथि तेरो हात राख् । ");
INSERT INTO npiulb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","त्यसलाई पुजारी एलाजार र सबै समुदाय सामु राख् र तिनीहरूको सामुन्‍ने नै तिनीहरूलाई नेतृत्व गर्न त्यसलाई आज्ञा दे । ");
INSERT INTO npiulb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","तैँले तेरो केही अधिकार त्यसलाई दिनुपर्छ, ताकि इस्राएलका मानिसहरूका सबै समुदायले तिनको आज्ञा पालन गरून् । ");
INSERT INTO npiulb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","त्यो ऊरीमको निर्णयद्वारा आफ्नो निम्ति मेरो इच्छा खोज्न पुजारी एलाजारको सामु जाने छ । त्यो र इस्राएलका सबै मानिस अर्थात् सारा समुदाय त्यसको आज्ञामा नै बाहिर जाने छन् र भित्र आउने छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","त्यसैले मोशाले परमप्रभुले तिनलाई आज्ञा गर्नुभएबमोजिम गरे । तिनले यहोशूलाई लिए र पुजारी एलाजार र सारा समुदायको सामु राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","तिनले उनीमाथि आफ्ना हात राखे र परमप्रभुले तिनलाई आज्ञा गर्नुभएझैँ नेतृत्व गर्न उनलाई आज्ञा दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएलका मानिसहरूलाई आज्ञा गर् र तिनीहरूलाई भन्, 'तिमीहरूले मेरो निम्ति सुगन्धित बास्‍ना दिने आगोद्वारा चढाइने बलिहरू तोकिएको समयमा मलाई चढाउनुपर्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","तैँले तिनीहरूलाई भन्‍नुपर्छ, 'तिमीहरूले परमप्रभुलाई आगोद्वारा चढाउने बलिदान यही होः नियमित होमबलिको रूपमा एक वर्षे निष्खोट थुमाहरू हरेक दिन दुई-दुईवटा । ");
INSERT INTO npiulb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","तिमीहरूले एउटा थुमालाई बिहान चढाउनुपर्छ र अर्को थुमालाई साँझमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","तिमीहरूले एक लिटर कुटेको भद्राक्षको तेलमा मुछेको आधा पाथी मसिनो पिठोलाई होमबलिको रूपमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","यो परमप्रभुलाई सुगन्धित बास्‍नाको निम्ति आगोद्वारा चढाइने नियमित होमबलि थियो, जुन सीनै पर्वतमा आज्ञा गरिएको थियो । यसैसँगको अर्घबलि एउटा थुमाको निम्ति एक लिटर मद्य होस् । ");
INSERT INTO npiulb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","तिमीहरूले परमप्रभुलाई कडा मद्यको अर्घबलि पवित्र स्थानमा खन्याउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","तिमीहरूले अर्को थुमालाई बिहान चढाइएको एउटा थुमालाई झैँ साँझमा अन्‍नबलिसँगै चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","शबाथको दिन तिमीहरूले निष्खोट एक वर्षे दुईवटा थुमा, तेलमा मुछेको एक पाथी मसिनो पिठो अन्‍नबलिको रूपमा चढाउनुपर्छ र यससँग अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","यो नियमित होमबलि र यससँगको अन्‍नबलिको अतिरिक्‍त हरेक शबाथको निम्ति होमबलि हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","हरेक महिनाको सुरुमा तिमीहरूले परमप्रभुलाई अन्‍नबलि चढाउनुपर्छ । तिमीहरूले दुईवटा साँढे, एउटा भेडा र एक वर्षे निष्खोट सातवटा थुमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","तिमीहरूले हरेक साँढेको निम्ति तेलमा मुछेको डेढ पाथी मसिनो पिठो अन्‍नबलिको रूपमा र एउटा भेडाको निम्ति तेलमा मुछेको एक पाथी मसिनो पिठो अन्‍नबलिको रूपमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","तिमीहरूले हरेक भेडाको निम्ति तेलमा मुछेको आधा पाथी मसिनो पिठो चढाउनुपर्छ । यो परमप्रभुलाई सुगन्धित बास्‍न दिने आगोद्वारा चढाइने बलि अर्थात् होमबलि हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","मानिसहरूका अर्घबलि साँढेको निम्ति दुई लिटर दाखमद्य, भेडाको निम्ति डेढ लिटर दाखमद्य, थुमाको निम्ति एक लिटर दाखमद्य हुनुपर्छ । यो वर्षभरि हरेक महिनाको निम्ति होमबलि हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","एउटा बोका परमप्रभुको निम्ति पापबलिको रूपमा अर्पण गर्नुपर्छ । यो नियमित होमबलि र अर्घबलिको अतिरिक्‍त हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","पहिलो महिनाको चौधौँ दिनमा परमप्रभुको निस्तार-चाड आउँछ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","यो महिनाको पन्ध्रौँ दिनमा एउटा उत्सव मनाउनुपर्छ । सात दिनसम्म अखमिरी रोटी खानुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","पहिलो दिन परमप्रभुको सम्मानमा एउटा पवित्र सभा हुनुपर्छ । तिमीहरूले त्यस दिन कुनै नियमित काम गर्नुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","तथापि, तिमीहरूले आगोद्वारा चढाइने अर्थात् होमबलि चढाउनुपर्छ । तिमीहरूले निष्खोट दुईवटा साँढे, एउटा भेडा र एक वर्षे सातवटा थुमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","साँढेसँगै तिमीहरूले अन्‍नबलिको निम्ति तेलमा मुछेको डेढ पाथी मुछेको मसिनो पिठो र भेडासँग एक पाथी चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","सातवटा हरेक थुमासँग तेलमा मुछेको आधा पाथी मसिनो पिठो चढाउनुपर्छ, ");
INSERT INTO npiulb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","र आफ्नो प्रायश्‍चित्तको निम्ति पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","तिमीहरूले यिनीहरूलाई हरेक बिहान आवश्यक पर्ने होमबलिको अतिरिक्‍त चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","यहाँ उल्लेख गरिएझैँ तिमीहरूले यी दैनिक बलिदानहरू निस्‍तार-चाडको सात दिनसम्म परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति आगोद्वारा चढाइने बलिको भोजन चढाउनुपर्छ । यो नियमित होमबलि र योसँग चढाइने अर्घबलि अतिरिक्‍त चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","तिमीहरूले सातौँ दिनमा परमप्रभुको सम्मानमा पवित्र सभा राख्‍नुपर्छ र तिमीहरूले त्यस दिन कुनै नियमित काम गर्नुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","अगौटे फलको दिनमा तिमीहरूले साताहरूका चाडमा नयाँ अन्‍नबलि चढाउनुपर्छ, तिमीहरूले परमप्रभुको सम्मानमा पवित्र सभा राख्‍नुपर्छ, र तिमीहरूले त्यस दिन कुनै नियमित काम गर्नुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति होमबलि चढाउनुहुँदैन । तिमीहरूले दुईवटा साँढे, एउटा भेडा र सातवटा एक वर्षे थुमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","तिनीहरूसँगै अन्‍नबलि पनि चढाउनूः हरेक साँढेको निम्ति तेलमा मुछेको डेढ पाथी मसिनो पिठो र एउटा भेडाको निम्ति एक पाथी मसिनो पिठो चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","हरेक सातवटा थुमाका निम्ति तेलमा मुछेको आधा पाथी मसिनो पिठो, ");
INSERT INTO npiulb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","र आफ्नो निम्‍ति प्रायश्‍चित्तको निम्ति एउटा बोका चढाउनू । ");
INSERT INTO npiulb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","जब तिमीहरूले तिनीहरूका अर्घबलिसँगै ती निष्खोट पशुहरू बलि चढाउँछौ, यो नियमित होमबलि र अन्‍नबलिको अतिरिक्‍त हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“सातौँ महिनाको पहिलो दिनमा परमप्रभुको सम्मानमा तिमीहरूले एउटा पवित्र सभा राख्‍नुपर्छ । तिमीहरूले त्यस दिन कुनै नियमित काम गर्नुहुँदैन । यो तिमीहरूले तुरही फुक्‍ने दिन हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","तिमीहरूले परमप्रभुको लागि सुगन्धित बास्‍नाको निम्ति होमबलि चढाउनुपर्छ । तिमीहरूले निष्खोट एउटा साँढे, एउटा भेडा र एक वर्षे सातवटा थुमा बलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","तिमीहरूले तिनीहरूलाई तिनीहरूका अन्‍नबलिसँग साँढेको निम्ति तेलमा मुछेको डेढ पाथी मसिनो पिठो, भेडाको निम्ति एक पाथी, ");
INSERT INTO npiulb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","र हरेक सातवटा थुमाको निम्ति आधा पाथी चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","तिमीहरूले आफ्नो प्रायश्‍चित्तको निम्ति पापबलिको रूपमा एउटा बोका बलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","यी बलिहरू तिमीहरूले हरेक महिनाको पहिलो दिनमा चढाउने बलिदानहरूका अतिरिक्‍त सातौँ महिनामा चढाउनूः विशेष होमबलि र यससँगै अन्‍नबलि चढाउनू । यिनीहरू नियमित होमबलि, यसको अन्‍नबलि र यसको अर्घबलिको अतिरिक्‍त हुनुपर्छ । तिमीहरूले यी बलिहरू चढाउँदा तिमीहरूले परमप्रभुलाई आगोद्वारा चढाइने सुगन्धित बास्‍नाको निम्ति आज्ञा गरेको कुरा पालन गर्ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","सातौँ महिनाको दसौँ दिनमा तिमीहरूले परमप्रभुको सम्‍मानमा एउटा पवित्र सभा राख्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","तिमीहरूले कुनै काम नगरी आफैलाई नम्र तुल्याउनुपर्छ । तिमीहरूले परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति होमबलि चढाउनुपर्छ । तिमीहरूले एउटा साँढे, एउटा भेडा र एक वर्षे सातवटा थुमा चढाउनुपर्छ । तिनीहरू हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","तिमीहरूले साँढेको निम्ति तेलमा मुछेको डेढ पाथी मसिनो पिठो, एउटा भेडाको निम्ति एक पाथी, ");
INSERT INTO npiulb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","र सातवटा थुमा हरेकको निम्ति आधा पाथी चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","तिमीहरूले एउटा बोकालाई पापबलिको रूपमा बलि चढाउनुपर्छ । यो नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","सातौँ महिनाको पन्ध्रौँ दिनमा तिमीहरूले परमप्रभुको सम्‍मानमा एउटा पवित्र सभा राख्‍नुपर्छ । तिमीहरूले त्यस दिन कुनै नियमित काम गर्नुहुँदैन, र तिमीहरूले उहाँको निम्ति सात दिनसम्म चाड मनाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","तिमीहरूले परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति आगोद्वारा चढाइएको बलिदान अर्थात् होमबलि चढाउनुपर्छ । तिमीहरूले तेह्रवटा साँढे, दुईवटा भेडा र चौधवटा एक वर्षे थुमाहरू चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । तिमीहरूले ");
INSERT INTO npiulb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","तिनीहरूसँगै हरेक साँढेको निम्ति तेलमा मुछेको डेढ पाथी मसिनो पिठो, दुईवटा भेडाको निम्ति एक पाथी, ");
INSERT INTO npiulb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","र चौधवटा हरेक थुमाको निम्ति आधा पाथी अन्‍नबलिको रूपमा चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","सभाको दोस्रो दिनमा तिमीहरूले बाह्रवटा साँढे, दुईवटा भेडा र एक वर्षे चौधवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","सभाको तेस्रो दिनमा तिमीहरूले एघारवटा साँढे, दुईवटा भेडा र एक वर्षे चौधवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","सभाको चौथो दिनमा तिमीहरूले दसवटा साँढे, दुईवटा भेडा र एक वर्षे चौधवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","सभाको पाँचौ दिनमा तिमीहरूले नौवटा साँढे, दुईवटा भेडा र एक वर्षे चौधवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","सभाको छैठौँ दिनमा तिमीहरूले आठवटा साँढे, दुईवटा भेडा र एक वर्षे चौधवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","सभाको सातौँ दिनमा तिमीहरूले सातवटा साँढे, दुईवटा भेडा र एक वर्षे चौधवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","आठौँ दिनमा तिमीहरूले अर्को गम्भीर सभा राख्‍नुपर्छ । तिमीहरूले कुनै नियमित काम गर्नुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","तिमीहरूले परमप्रभुको निम्ति सुगन्धित बास्‍नाको निम्ति आगोद्वारा चढाइने अर्थात् होमबलि चढाउनुपर्छ । तिमीहरूले एउटा साँढे, एउटा भेडा र सातवटा थुमा चढाउनुपर्छ । ती हरेक निष्खोट हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","तिमीहरूले तिनीहरूसँगै साँढेहरूका निम्ति, भेडाहरूका निम्ति र थुमाहरूका निम्ति आज्ञा गरिएजत्ति सबै अन्‍नबलि र अर्घबलि चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","तिमीहरूले नियमित होमबलि, यसको अन्‍नबलि र तिनीहरूका अर्घबलिको अतिरिक्‍त पापबलिको रूपमा एउटा बोका चढाउनुपर्छ । तिमीहरूका तोकिएको चाडहरूमा तिमीहरूले यी परमप्रभुलाई चढाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","यी तिमीहरूका भाकल र स्वेच्छा बलिहरूको अतिरिक्‍त हुनुपर्छ । तिमीहरूले यिनीहरूलाई तिमीहरूका होमबलि, अन्‍नबलि, अर्घबलि र मेलबलिको रूपमा चढाउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","परमप्रभुले आज्ञा गर्नुभएका सबै कुरा मोशाले इस्राएलका मानिसहरूलाई भने । ");
INSERT INTO npiulb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मोशाले इस्राएलका मानिसहरूका कुलका अगुवाहरूलाई भने, “परमप्रभुले यो आज्ञा गर्नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जब कसैले परमप्रभुसँग भाकल गर्छ वा प्रतिज्ञासँगै आफैलाई शपथले बाँध्‍ने काम गर्छ, त्यसले आफ्नो वचन तोड्नुहुँदैन । त्यसले त्यसको मुखबाट निस्केका सबै कुरा पुरा गर्न त्यसको प्रतिज्ञा पालन गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","आफ्नो बुबाको घरमा बस्‍ने जवान नारीले परमप्रभुको निम्ति भाकल गर्दा र आफैलाई प्रतिज्ञाद्वारा बाँध्दा, ");
INSERT INTO npiulb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","यदि त्यसको बुबाले त्यसले आफूलाई बाँधेको भाकल र प्रतिज्ञा सुन्छ, यदि त्यसले त्यसको प्रतिज्ञालाई उल्टाउन कुनै कुरा भन्‍दैन भने, त्यसका सबै भाकल रहने छन् । त्यसले आफैलाई बाँधेकी हरेक प्रतिज्ञा सबल रहने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","तर यदि त्यसका बुबाले त्यसको भाकल र प्रतिज्ञा सुन्छ र यदि त्यसले त्यसलाई केही भन्‍दैन भने, त्यसले गरेका सबै भाकल र प्रतिज्ञाहरू हराउने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","तथापि, यदि त्यसका बुबाको त्यसले आफैलाई बाँधेकी र गरेकी सबै भाकल र प्रतिज्ञा सुन्छ र त्यसले त्यसै दिन रद्द गर्छ भने, ती रहने छैनन् । परमप्रभुले त्यसलाई क्षमा गर्नुहुने छ, किनभने त्यसका पिताले त्यसको विरोध गरेका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","यदि त्यो भाकल गरेकै बेला त्यसले कुनै पुरुषसँग विवाह गर्छे वा त्यसले आफैलाई बाध्य पार्ने सोच-विचार नै नगरी प्रतिज्ञा गर्छे भने, ती भाकलहरू रहने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","तर यदि त्यसका पतिले सुनेको दिन नै त्यसलाई रोक्छ भने, त्यसले गरेकी भाकलहरू अर्थात् त्यसले आफैलाई बाँधेकी सोचविचार नगरी गरेकी त्यसको मुखको बोलीलाई त्यस रद्द गर्छे । परमप्रभुले त्यसलाई मुक्‍त गर्नुहुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","तर विधवा र पतिसँग छुटिएकाको निम्ति, त्यसले आफैलाई बाँधेकी सबै कुरा त्यो विरुद्ध रहिरहने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","यदि महिलाले आफ्नो पतिको घरमा भाकल गर्छे वा शपथ खाएर आफैलाई बाध्य बनाउँछे भने, ");
INSERT INTO npiulb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","र त्यसको पतिले यो सुन्यो, तर त्यसले त्यसलाई केही भन्दैन र त्यसको विरोध गर्दैन भने, त्यसका सबै भाकल रहनुपर्छ र त्यसका वाचाबन्धनहरू रहनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","तर यदि त्यसका पतिले तिनीहरूको बारेमा सुनेको दिनमा नै तिनीहरूलाई रद्द गर्‍यो भने, त्यसको मुखबाट निस्केका भाकलहरू वा प्रतिज्ञाहरू जे भए पनि रहने छैनन् । त्यसका पतिले तिनीहरूलाई रद्द गरेको छ । परमप्रभुले त्यसलाई मुक्‍त गर्नुहुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","कुनै महिलाले कुनै कुरा इन्कार गर्न आफैलाई बाँधेकी शपथ वा भाकललाई त्यसको पतिले पक्‍का गर्न वा रद्द गर्न सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","तर यदि त्यसले त्यसलाई दिन-दिनै केही भन्दैन भने, त्यसले गरेकी सबै भाकल र बाध्यात्मक प्रतिज्ञाहरूलाई त्यसले पक्‍का गर्छ । त्यसले तिनीहरूलाई पक्‍का गरेको छ, किनभने त्यसले तिनीहरूको बारेमा सुनेको समयमा त्यसले त्यसलाई केही पनि भनेन । ");
INSERT INTO npiulb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","यदि त्यसको पतिले सुनेको लामो समयपछि त्यसकी पत्‍नीको भाकललाई रद्द गर्ने कोसिस गर्‍यो भने त्यसको पापको निम्ति त्यो जिम्मेवार हुने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","पुरुष र त्यसकी पत्‍नी, जवान हुँदा आफ्नो बुबाको परिवारमा रहँदा, बुबा र त्यसकी छोरी बिचको नियमहरू परमप्रभुले घोषणा गर्न मोशालाई आज्ञा गर्नुभएका सबै नियम यिनै नै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मिद्यानीहरूले इस्राएलीहरूलाई जे गरेका थिए, त्यसको निम्ति बद्ला ले । त्यो काम गरेपछि तँ मर्ने छस् र तेरा मानिसहरूसँग मिल्न जाने छस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","त्यसैले मोशाले मानिसहरूलाई भने, “तिमीहरूका केही मानिसहरूलाई सुसज्‍जित पार । ");
INSERT INTO npiulb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","तिनीहरू मिद्यानीहरूको विरुद्ध युद्ध लड्न जाऊन् र यसमाथि परमप्रभुको बद्ला लिऊन् । इस्राएलका हरेक कुलले युद्धको निम्ति एक हजार सिपाही पठाउनुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","त्यसैले इस्राएलका हजारौँ पुरुषमा हरेक कुलबाट एक हजार जना अर्थात् युद्धको निम्ति बाह्र हजार सशस्‍त्र मानिस दिइयो । ");
INSERT INTO npiulb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","त्यसपछि मोशाले तिनीहरूलाई पुजारी एलाजारका छोरा पीनहासको साथमा पवित्र स्थानका केही सरसामानहरू र सङ्केत दिनलाई तिनको स्वामित्वमा तुरहीहरूसहित हरेक कुलबाट एक-एक हजार जना मानिसलाई युद्ध गर्न पठाए । परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ ");
INSERT INTO npiulb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","तिनीहरूले मिद्यनीहरूसँग लडे । ");
INSERT INTO npiulb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","तिनीहरूले सबै मानिसलाई मारे । तिनीहरूले बाँकी मृतकहरूसहित मिद्यानका पाँच जना राजा एवी, रेकेम, सूर, हूर र रेबालाई मारे । ");
INSERT INTO npiulb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएलका फौजले मिद्यानका महिलाहरू, तिनीहरूका बालबच्‍चाहरू, तिनीहरूका सबै गाईवस्तु, तिनीहरूका सबै भेडाबाख्रा र तिनीहरूका सबै मालसामान लगे । तिनीहरूले यिनीहरूलाई लुटको रूपमा लिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","तिनीहरूले उनीहरूका सबै सहर जलाइदिए, जहाँ उनीहरू बसेका थिए र उनीहरूका छाउनीहरू थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","तिनीहरूले मानिसहरू र पशुहरू दुवैलाई लुटको माल र कैदीको रूपमा लिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","तिनीहरूले कैदीहरूलाई, लुटका मालहरू र कब्जा गरेका सामानहरू मोशा, पुजारी एलाजार र इस्राएलका मानिसहरूका समुदायकहाँ ल्याए । तिनीहरूले यिनीहरूलाई मोआबको मैदानमा यरीहो नजिक यर्दनको किनारमा ल्याए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","मोशा, पुजारी एलाजार र समुदायका सबै अगुवा तिनीहरूलाई भेट्न छाउनी बाहिर गए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","तर मोशा लडाइँबाट आएका फौजका अधिकृतहरू, हजार जनाको सेनापति र सय जनाको कप्‍तानहरूसँग रिसाए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशाले तिनीहरूलाई भने, “के तिमीहरूले यी सबै महिलालाई जीवितै राखेको ? ");
INSERT INTO npiulb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","हेर, यिनै महिलाहरूले परमप्रभुका समुदायमाझ विपत्ति फैलिँदा बालामको सल्लाहमा पोरको विषयमा परमप्रभु विरुद्ध पाप गर्न लगाएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","अब सबै स-साना पुरुषहरूलाई मार् र पुरुषसँग सहवास गरेका सबै महिलालाई पनि मार । ");
INSERT INTO npiulb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","तर पुरुषसँग सहवास नगरेका सबै जवान महिलालाई आफ्नो निम्ति लेओ । ");
INSERT INTO npiulb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","तिमीहरू सात दिनसम्म इस्राएलको छाउनीबाहिर छाउनीमा बस्‍नुपर्छ । कसैलाई मारेका र मुर्दालाई छोएका तिमीहरू सबैले तिमीहरू र तिमीहरूका कैदीहरूसहित तेस्रो र सातौँ दिनमा आफैलाई शुद्ध पार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तिमीहरूले हरेक पोशाक र पशुका छाला, बाख्राको रौँ र काठले बनेका सबै मालसामानलाई शुद्ध पार्नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","पुजारी एलाजारले युद्धमा गएका सिपाहीहरूलाई भने, “परमप्रभुले मोशालाई दिनुभएको धर्म-विधि यही होः ");
INSERT INTO npiulb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सुन, चाँदी, काँसा, फलाम, टिन र सिसा, ");
INSERT INTO npiulb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","र आगोले नजल्ने सबै थोकलाई तिमीहरूले आगोमा पोल्नुपर्छ र यो शुद्ध हुने छ । त्यसपछि तिमीहरूले यिनीहरूलाई शुद्ध पार्ने पानीले शुद्ध पार्नुपर्छ । जुन कुरालाई आगोमा जलाउन मिल्दैन, त्यसलाई तिमीहरूले पानीले शुद्ध पार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","तिमीहरूले सातौँ दिनमा तिमीहरूका लुगा धुनुपर्छ र तिमीहरू शुद्ध हुने छौ । त्यसपछि तिमीहरू इस्राएलको छाउनीभित्र आउन सक्छौ । ");
INSERT INTO npiulb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","त्यसपछि परमप्रभुले मोशालाई भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“मानिस र पशुहरू दुवै लुटका मालहरूको रूपमा गन्ती गर् । तँ, पुजारी एलाजार र समुदायका कुल-कुलका अगुवाहरूले लुटका मालहरूलाई ");
INSERT INTO npiulb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","दुई भाग गर्नुपर्छ । यसलाई लडाइँमा जाने सिपाहीहरू र सबै बाँकी समुदायबिच बाँड् । ");
INSERT INTO npiulb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","त्यसपछि लडाइँमा गएका सिपाहीहरूबाट मेरो निम्ति कर लिनू । यो कर मानिस, गाईवस्तु, गधा, भेडा वा बाख्राहरू जे भए पनि हरेक पाँच सयमा एउटा हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","यो कर तिनीहरूका आधा अंशबाट लिनू र यसलाई मेरो निम्ति चढाउन पुजारी एलाजारलाई दिनू । ");
INSERT INTO npiulb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","साथै, इस्राएलका मानिसहरूका आधा भागबाट, मानिस, गाईवस्तु, गधा, भेडा र बाख्राबाट तैँले हरेक पचास वटामा एउटा लिनू । यिनीहरूलाई मेरो पवित्र वासस्थानको हेरचाह गर्ने लेवीहरूलाई दिनू ।” ");
INSERT INTO npiulb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","त्यसैले मोशा र पुजारी एलाजारले परमप्रभुले मोशालाई आज्ञा गर्नुभएबमोजिम गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","सिपाहीहरूले लिएका लुटबाट बाँकी रहेका ६,७५,००० भेडा, ");
INSERT INTO npiulb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","सत्तरी हजार गोरु, ");
INSERT INTO npiulb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","एकसट्ठी हजार गधा, ");
INSERT INTO npiulb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","र पुरुषसँग कहिल्यै सहवास नगरेका तिस हजार महिला थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","सिपाहीहरूका निम्ति राखिएका भेडाहरू ३,३७, ००० थियो । भेडाहरूबाट ");
INSERT INTO npiulb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","परमप्रभुको भाग ६७५ थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","गोरुहरू छत्तिस हजार थिए, जसबाट परमप्रभुको भागमा बहत्तरवटा थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","गधाहरू ३०,५०० थिए, जसबाट परमप्रभुको भाग एकसट्ठीवटा थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","सोह्र हजार महिला थिए, जसबाट परमप्रभुको भाग बत्तिस जना थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","परमप्रभुलाई चढाउने बलि हुनुपर्ने कर मोशाले लिए । परमप्रभुले मोशालाई आज्ञा गर्नुभएझैँ तिनले यसलाई पुजारी एलाजारलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","युद्धमा गएका सिपाहीहरूबाट मोशाले इस्राएलका मानिसहरूका आधा भागको सन्दर्भमा ");
INSERT INTO npiulb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","समुदायको आधा भाग ३,३७,५०० भेडा, ");
INSERT INTO npiulb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","तिस हजार गोरु, ");
INSERT INTO npiulb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","३०,५०० गधा, ");
INSERT INTO npiulb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","र सोह्र हजार महिला थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","इस्राएलका मानिसहरूका आधा भागबाट मोशाले पशु र मानिस दुवैबाट हरेक पचास वटाबाट एउटा लिए । परमप्रभुले मोशालाई आज्ञा गर्नुभएबमोजिम तिनले तिनीहरूलाई परमप्रभुको पवित्र वासस्थानको हेरचाह गर्ने लेवीहरूलाई दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","फौजका अधिकृतहरू, हजारका सेनापतिहरू र पचास जनाका कप्‍तानहरू मोशाकहाँ आए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","तिनीहरूले तिनलाई भने, “तपाईंका दासहरूले हाम्रो स्वामित्वमा भएका सिपाहीहरूको गन्ती गरेका छन् र एक जना पनि हराएको छैन । ");
INSERT INTO npiulb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","हामी हरेकले पाएका सुनका गहनाहरू, बाजू, बाला, छाप औँठी, कुण्डल र सिक्रीहरू परमप्रभुको सामु हाम्रो प्रायश्‍चित्त गर्नको निम्ति परमप्रभुको भेटी ल्याएका छौँ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशा र पुजारी एलाजारले सुन र सबै कलात्मक सरसामान तिनीहरूबाट ग्रहण गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","तिनीहरूले परमप्रभुलाई दिएका, हजारका सेनापतिहरू र सय जनाका कप्‍तानहरूबाट आएका सुनका भेटीहरूको तौल एक सय नब्बे किलोग्राम थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","हरेक सिपाहीले आ-आफ्नो निम्ति लुटका माल लिएका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मोशा र पुजारी एलाजारले हजारका सेनापतिहरू र सयका कप्‍तानहरूबाट सुन लिए । तिनीहरूले यसलाई परमप्रभुको निम्ति इस्राएलका मानिसहरूको याद दिलाउने चिनोको रूपमा भेट हुने पालभित्र लगे । ");
INSERT INTO npiulb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबेन र गादका सन्तानहरूका गाईवस्‍तुहरू धेरै थिए । जब तिनीहरूले याजेर र गिलादको भूमी देखे, त्यो भूमी गाईवस्‍तुहरूको निम्ति असाध्यै राम्रो थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","त्यसैले गाद र रूबेनका सन्तानहरू आए अनि मोशा, पुजारी एलाजार र समुदायका अगुवाहरूसँग कुरा गरे । तिनीहरूले भने, ");
INSERT INTO npiulb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“हामीले सर्वेक्षण गरेका ठाउँहरूका सूची यही होः आतारोत, दीबोन, याजेर, निम्रा, हेश्बोन, एलाले, सबाम, नेबो र बओन । ");
INSERT INTO npiulb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","यी ठाउँहरूलाई परमप्रभुले इस्राएलका समुदायको सामु आक्रमण गर्नुभयो र तिनीहरू गाईवस्‍तुहरूका निम्ति राम्रा ठाउँहरू छन् । हामी तपाईंका दासहरूका गाईवस्‍तुहरू धेरै छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","तिनीहरूले भने, “यदि हामीले तपाईंको नजरमा कृपा पाएका छौँ भने, यो भूमि तपाईंका दासहरू हामीलाई हाम्रो स्वामित्वमा दिइयोस् । हामीलाई यर्दन पारि नलैजानुहोस् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मोशाले गाद र रूबेनका सन्तानहरूलाई जवाफ दिए, “के तिमीहरू बसोवास गर्दा तिमीहरूका दाजुभाइहरूचाहिँ लडाइँमा जाने ? ");
INSERT INTO npiulb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","परमप्रभुले इस्राएलका मानिसहरूलाई दिनुभएको भूमिमा जानबाट तिनीहरूलाई किन निरुत्साहित पार्ने ? मैले कादेश-बर्नेबाट तिमीहरूका बुबाहरूलाई भूमिको जाँचबुझ गर्न पठाउँदा तिनीहरूले त्यही गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तिनीहरू एश्कोलको बेँसीमा गए । ");
INSERT INTO npiulb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","तिनीहरूले भूमिलाई देखे र इस्राएलका मानिसहरूका मनलाई निरुत्साहित बनाए, ताकि परमप्रभुले तिनीहरूलाई दिनुभएको भूमिमा प्रवेश गर्न तिनीहरूले इन्कार गरून् । ");
INSERT INTO npiulb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","परमप्रभुको क्रोध दन्कियो । उहाँले शपथ खानुभयो र भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","'मैले अब्राहाम, इसहाक र याकूबलाई प्रतिज्ञा गरेका भूमिलाई मिश्रबाट आएका बिस वर्षभन्दा माथिका कसैले देख्‍ने छैनन्, किनभने ");
INSERT INTO npiulb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","यपुन्‍नेका छोरा कालेब र नूनका छोरा यहोशूले बाहेक तिनीहरूले मलाई पूर्ण रूपमा अनुसरण गरेका छैनन् । कालेब र यहोशूले मात्र मलाई पूर्ण रूपमा अनुसरण गरेका छन् ।' ");
INSERT INTO npiulb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","त्यसैले परमप्रभुको क्रोध इस्राएल विरुद्ध दन्कियो । उहाँको नजरमा दुष्‍टता गर्ने सबै पुस्ता विनाश नभएसम्म उहाँले तिनीहरूलाई मरुभूमिमा यताउता भौतारिन लगाउनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","हेर, तिमीहरू आफ्ना बुबाहरूको स्थानमा अझ धेरै पापी मानिसहरूझैँ इस्राएलको विरुद्धमा परमप्रभुको क्रोध उराल्न खडा भएका छौ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","यदि तिमीहरू उहाँलाई पछ्याउनबाट तर्कियौ भने, उहाँले इस्राएललाई फेरि पनि मरुभूमिमा नै छोड्नुहुने छ र तिमीहरूले यी सबै मानिसलाई नष्‍ट पार्ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","त्यसैले तिनीहरू मोशाको नजिक आए र भने, “यहाँ हाम्रा गाईवस्‍तुहरूका निम्ति खोर र हाम्रा परिवारहरूका निम्ति सहर बनाउन अनुमति दिनुहोस् । ");
INSERT INTO npiulb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","तथापि, हामी आफैचाहिँ तिनीहरूलाई आ-आफ्नो ठाउँमा नलगेसम्म हामी हतियारसहित इस्राएलको फौजसँग जान्छौँ । तर अझै यस भूमिमा रहेका अन्य मानिसहरूका कारण हाम्रा परिवारहरूचाहिँ किल्लाबन्दी गरिएका सहरहरूमा बस्‍ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","इस्राएलका हरेक मानिसले आ-आफ्नो उत्तराधिकर नपाएसम्म हामी हाम्रो घरतिर फर्कने छैनौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","हामीले तिनीहरूसँग यर्दन पारिपट्टि अंश पाउनेछै नौँ, किनभने हाम्रो अंश यहीँ यर्दनको पूर्वीपट्टि नै छ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","त्यसैले मोशाले तिनीहरूलाई जवाफ दिए, “यदि तिमीहरूले आफूले भनेबमोजिम गर्छौ, तिमीहरू हातहतियारसहित परमप्रभुको सामु युद्ध गर्न जान्छौ भने, ");
INSERT INTO npiulb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","परमप्रभुले उहाँका शत्रुहरूलाई उहाँको सामुबाट नधपाउनुभएसम्म र ");
INSERT INTO npiulb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","उहाँको सामु भूमिलाई कब्जा नगरेसम्म तिमीहरू सबै हातहतियारसहित परमप्रभुको सामु यर्दन पारि तर्नुपर्छ । त्यसपछि तिमीहरू फर्कन सक्छौ । तिमीहरू परमप्रभु र इस्राएलका सामु दोषरहित हुने छौ । यो भूमि परमप्रभुको सामु तिमीहरूको सम्पत्ति हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","तर यदि तिमीहरूले यसो गरेनौ भने, हेर, तिमीहरूले परमप्रभु विरुद्ध पाप गरेका हुने छौ । तिमीहरूका पापले अवश्य नै फेला पार्ने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","तिमीहरूका परिवारहरूका निम्ति सहरहरू र भेडाबाख्राहरूका निम्ति खोर बनाओ; तिमीहरूले जे भनेका छौ सो गर ।” ");
INSERT INTO npiulb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","गाद र रूबेनका सन्तानहरूले मोशालाई भने, “तपाईंका दासहरूले हाम्रा मालिकले आज्ञा गरेअनुसार गर्ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हाम्रा बालबच्‍चाहरू, हाम्रा पत्‍नीहरू, हाम्रा गाईवस्‍तुहरू र हाम्रा सबै भेडाबाख्रा गिलादका सहरहरूमा रहने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","तथापि, हामी तपाईंका दासहरू हाम्रा मालिकले भन्‍नुभएबमोजिम नै लडाइँको निम्त हातहतियारसहित परमप्रभुको सामु पारि जाने छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","त्यसैले मोशाले तिनीहरूको बारेमा पुजारी एलाजार, नूनका छोरा यहोशू र इस्राएलका मानिसहरूका कुल-कुलका अगुवाहरूलाई निर्देशन दिए । ");
INSERT INTO npiulb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मोशाले तिनीहरूलाई भने, “गाद र रूबेनका सन्तानहरू परमप्रभुको सामु लड्न हातहतियारसहित तिमीहरूसँगै यर्दन पारि जाने छन्, र यदि भूमिलाई तिमीहरूको सामु कब्जा गरियो भने, तिमीहरूले तिनीहरूलाई गिलादको भूमि अंशको रूपमा दिनू । ");
INSERT INTO npiulb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","तर यदि तिनीहरू तिमीहरूसँगै हातहतियारसहित पारि गएनन् भने, तिनीहरूले पनि कनानको मुलुकमा नै तिमीहरूमाझ अंश प्राप्‍त गर्ने छन् ।” ");
INSERT INTO npiulb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","त्यसैले गाद र रूबेनका सन्तानहरूले जवाफ दिए, “परमप्रभुले हामी तपाईंका दासहरूलाई भन्‍नुभएबमोजिम हामीले यसै गर्ने छौँ । ");
INSERT INTO npiulb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हामी परमप्रभुको सामु हातहतियारसहित कनानको भूमिमा पारि जानेछौँ, तर हाम्रो स्वामित्वमा रहेको अंश यर्दन वारि हामीसँग रहने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","त्यसैले मोशाले एमोरी राजा सीहोन र बाशानका राजा ओगको राज्य गाद र रूबेनका सन्तानहरूसाथै योसेफका छोरा मनश्शेका आधा कुललाई दिए । तिनले त्यो भूमि तिनीहरूलाई दिए र यसका सिमानासहित सबै सहरहरू, त्यस वरिपरिका भूमिमा भएका सहरहरू भाग लगाए । ");
INSERT INTO npiulb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गादका सन्तानहरूले दीबोन, अतारोत, अरोएर, ");
INSERT INTO npiulb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अत्रोत-शोपान, याजेर, योगबहा, ");
INSERT INTO npiulb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेथ-निम्रा, बेथ-हारान सहरहरूलाई पर्खालले घेरेर भेडाबाख्राहरूका निम्ति खोरहरू बनाए । ");
INSERT INTO npiulb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","रूबेनका सन्तानहरूले हेश्बोन, एलाले, किर्यातैयम, ");
INSERT INTO npiulb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","नेबो, बालमोन, यिनीहरूका नाउँ पछि फेरियो र शिब्मा बनाए । तिनीहरूले पुनर्निर्माण गरेका सहरहरू नाउँ अरू नै राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनश्शेका छोरा माकीरका सन्तानहरू गिलादमा गए र त्यहाँ बसोबास गर्ने एमोरीहरूबाट यसलाई कब्जा गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","त्यसपछि मोशाले मनश्शेका छोरा माकीरलाई गिलाद दिए, र तिनका मानिसहरू त्यहाँ बसोबास गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनश्शेका छोरा याईर गए र यसका नगरहरू कब्जा गरे र तिनीहरूको नाउँ हब्बात-याईर राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","नोबाह गए र केनात र यसका गाउँहरू कब्जा गरे अनि तिनले यसको नाउँ आफ्नै नाउँमा नोबह राखे । ");
INSERT INTO npiulb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","मोशा र हारूनको नेतृत्वमा इस्राएलका मानिसहरूले तिनीहरूका हातहतियारसहितका समूहले मिश्रको भूमि छोडेपछि तिनीहरूको यात्रा विवरण यही हो । ");
INSERT INTO npiulb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","परमप्रभुले आज्ञा गर्नुभएबमोजिम तिनीहरू कहाँबाट कहाँ गए भनी मोशाले लेखे । तिनीहरूका यात्राहरूको नालीबेली यिनै थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","तिनीहरूले पहिलो महिनाको पन्ध्रौँ दिनमा रामसेसबाट यात्रा गरे । निस्तार-चाडपछिको बिहान इस्राएलका मानिसहरूले मिश्रीहरूको सामु नै खुलमखुला मिश्र छोडे । ");
INSERT INTO npiulb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","मिश्रीहरूले तिनीहरूका जेठा छोराहरूको दफन गरिरहँदा यो भएको थियो, जसलाई परमप्रभुले मार्नुभएको थियो, किनभने उहाँले तिनीहरूका देवतालाई पनि दण्ड दिनुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इस्राएलका मानिसहरू रामसेसबाट निस्के र सुक्‍कोतमा छाउनी लगाए । ");
INSERT INTO npiulb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","तिनीहरू सुक्‍कोतबाट हिँडे र मरुभूमिको छेउमा भएको एथाममा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","तिनीहरू एथामबाट हिँडे र पी-हहीरोततिर फर्के, जुन बाल-सेफोनको पारिपट्टि पर्छ, जहाँ तिनीहरूले मोग्दोलको पारिपट्टि छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","त्यसपछि तिनीहरू पी-हहीरोतबाट हिँडे र समुद्रको बिचबाट हुँदै मरुभूमितिर लागे । तिनीहरूले एथामको मरुभूमिमा तिन दिनसम्म यात्रा गरे र मारामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","तिनीहरू माराबाट हिँडे र एलीममा आइपुगे । एलीममा बाह्रवटा पानीका मूल र सत्तरीवटा खजूरका रुख थिए । तिनीहरूले त्यहीँ नै छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","तिनीहरू एलीमबाट हिँडे र लाल समुद्रको किनारमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","तिनीहरू लाल समुद्रबाट हिँडे र सीनको मरुभूमिमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","तिनीहरू सीनको मरुभूमिबाट हिँडे र दोफकामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","तिनीहरू दोफकाबाट हिँडे र आलूशमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","तिनीहरू आलूशबाट हिँडे र रपीदीममा छाउनी हाले, जहाँ मानिसहरूलाई पिउनलाई पानी थिएन । ");
INSERT INTO npiulb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","तिनीहरू रपीदीमबाट हिँडे र सीनैको मरुभूमिमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","तिनीहरू सीनैको मरुभूमिबाट हिँडे र किब्रोथ-हत्तावामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","तिनीहरू किब्रोथ-हत्तावाबाट हिँडे र हसेरोतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","तिनीहरू हसेरोतबाट हिँडे र रित्मामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","तिनीहरू रित्माबाट हिँडे र रिम्मोन-फारेसमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","तिनीहरू रिम्मोन-फारेसबाट हिँडे र लिब्‍नामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","तिनीहरू लिब्‍नाबाट हिँडे र रिस्सामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","तिनीहरू रिस्साबाट हिँडे र केहेलातामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","तिनीहरू केहेलाताबाट हिँडे र शेपेर पर्वतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","तिनीहरू शेपेर पर्वतबाट हिँडे र हरादामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","तिनीहरू हरादाबाट हिँडे र मखेलोतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","तिनीहरू मखेलोपबाट हिँडे र तहतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","तिनीहरू तहतबाट हिँडे र तेरहमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","तिनीहरू तेरहबाट हिँडे र मित्कामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","तिनीहरू मित्काबाट हिँडे र हशमोनामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","तिनीहरू हशमोनाबाट हिँडे र मोसेरोतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","तिनीहरू मोसेरोतबाट हिँडे र बने-याकानमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","तिनीहरू बने-याकानबाट हिँडे र होर-हगिदगादमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","तिनीहरू होर-हगिदगादबाट हिँडे र योतबातामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","तिनीहरू योतबाताबाट हिँडे र अब्रोनामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","तिनीहरू अब्रोनाबाट हिँडे र एस्योन‍-गेबेरमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","तिनीहरू एस्योन‍-गेबेरबाट हिँडे र कादेशमा भएको सीनको मरुभूमिमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","तिनीहरू कादेशबाट हिँडे र एदोमको सिमानामा पर्ने होर पर्वतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","हारून परमप्रभुको आज्ञामा होर पर्वतमाथि गए र इस्राएलका मानिसहरू मिश्रबाट आएका चालिसौँ वर्षको पाँचौँ महिनाको पहिलो दिनमा त्यहाँ तिनको मृत्यु भयो । ");
INSERT INTO npiulb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","हारूनको मृत्यु हुँदा तिनी १२३ वर्षका थिए । ");
INSERT INTO npiulb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","कनानको भूमिको दक्षिणी मरुभूमिमा बस्‍ने अरादका कनानी राजाले इस्राएलका मानिसहरू आइरहेका छन् भन्‍ने सुने । ");
INSERT INTO npiulb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","तिनीहरू होर पर्वतबाट हिँडे र सलमोनामा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","तिनीहरू सलमोनाबाट हिँडे र पूनोनमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","तिनीहरू पूनोनबाट हिँडे र ओबोतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","तिनीहरू ओबोतबाट हिँडे र मोआबको सिमानामा पर्ने इयेअबारीममा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","तिनीहरू इयेअबारीमबाट हिँडे र दीबोनगादमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","तिनीहरू दीबोनगादबाट हिँडे र अल्मोन-दिब्लातैममा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","तिनीहरू अल्मोन-दिब्लातैमबाट हिँडे र नेबोको अगिल्तिर अबारीम पर्वतमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","तिनीहरू अबारीमबाट हिँडे र यरीहोमा यर्दन नजिकैको मोआबको मैदानमा छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","तिनीहरूले यर्दनको किनारमा मोआबको मैदानमा बेथ-यशीमोतदेखि हाबिल-शित्तिमसम्मै छाउनी हाले । ");
INSERT INTO npiulb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","परमप्रभु यरीहोमा यर्दन नदीको किनारमा मोआबको मैदानमा मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएलका मानिसहरूसँग कुरा गर् र तिनीहरूलाई भन्, 'जब तिमीहरू यर्दन तरेर कनानको मुलुकमा जान्छौ, तिमीहरूले तिमीहरूभन्दा अघि बस्‍ने सबै बासिन्दालाई धपाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तिमीहरूले तिनीहरूका सबै कुँदिएका प्रतिमाहरू नष्‍ट गर्नुपर्छ । तिमीहरूले तिनीहरूका ढलौटे मूर्तिहरू र तिनीहरूका उच्‍च स्थानहरू नष्‍ट पार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","तिमीहरूले भूमिलाई कब्जा गर्नुपर्छ र यसमा बसोबास गर्नुपर्छ, किनभने मैले तिमीहरूलाई त्यो भूमि तिमीहरूको स्वामित्वमा दिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","तिमीहरूले भूमिलाई चिट्ठा हालेर कुल-कुलअनुसार अंश बाँड्नुपर्छ । ठुलो कुललाई भूमिको ठुलो अंश दिनुपर्छ र सानो कुललाई भूमिको सानै अंश दिनुपर्छ । कुल-कुलअनुसारको चिट्ठा जहाँ पर्छ, त्यो त्यही कुलको हुने छ । तिमीहरूले भूमिलाई आ-आफ्नो कुलअनुसार बाँड्ने छौ ");
INSERT INTO npiulb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","तर यदि तिमीहरूले तिमीहरूभन्दा अघिका बासिन्दाहरूलाई धपाएनौ भने, तिमीहरूले बस्‍न दिएका मानिसहरू तिमीहरूका आँखाका कसिङ्गरहरू र जीउमा बिझेको काँढाहरूजस्ता हुने छन् । तिनीहरूले तिमीहरू बसोबास गर्ने भूमिलाई कठिन बनाउने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","त्यसपछि मैले ती मानिसहरूलाई जे गर्ने अभिप्राय राखेको छु सो म तिमीहरूलाई पनि गर्ने छु । ");
INSERT INTO npiulb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","परमप्रभु मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इस्राएलका मानिसहरूलाई आज्ञा दे र तिनीहरूलाई भन्, 'जब तिमीहरू कनान देशमा प्रवेश गर्छौ, त्यो देश अर्थात् कनानको भूमि र यसका सिमानाहरू तिमीहरूको स्वामित्वमा हुने छ, ");
INSERT INTO npiulb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","तिमीहरूका दक्षिणी सिमाना सीनको मरुभूमिदेखि एदोमको सिमानासम्म हुने छ । पूर्वतिर दक्षिणी सिमानाको अन्त मृत सागरको दक्षिणी किनारासम्म हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","तिमीहरूको सिमाना दक्षिणबाट अक्रबीमको डाँडा र सीनक मरुभूमि हुँदै जाने छ । त्यहाँबाट यो कादेश-बर्नेतिर रहसर-अद्दर र अज्मोनतिर अघि बढ्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","त्यहाँबाट सिमाना अज्मोनबाट मिश्रको खोलातर्फ लाग्‍ने छ र समुद्रमा अन्त हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","पश्‍चिमी सिमाना भूमध्य सागरको तट हुने छ । यो तिमीहरूको पश्‍चिमी सिमाना हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","तिमीहरूका उत्तरी सिमाना भूमध्य सागरदेखि होर पर्वततिर जाने छ, ");
INSERT INTO npiulb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","त्यसपछि होर पर्वतबाट लेबो-हमातसम्म अनि सदादसम्म हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","अनि सिमाना सिप्रोनतिर अघि बढ्ने छ र हसर‍-एनानमा टुङ्गिनेछ । यो तिमीहरूको उत्तरी सिमाना हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","तिमीहरूले तिमीहरूको पूर्वी सिमाना हसर-एनानदेखि दक्षिणमा सपामसम्म चिनो लगाउनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","पूर्वतिरको सिमाना सपामदेखि तल झरेर ऐनको पूर्वतिर पर्ने रिब्लासम्म जाने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","यो सिमाना किन्‍नरेत समुद्रको पूर्व किनारसम्म अघि बढ्ने छ । त्यो सिमाना यर्दन नदी हुँदै मृत सागरसम्म र मृत सागरको पूर्वी किनाराबट तल झर्ने छ । चारैतिरका सिमानासहितको यो तिमीहरूको देश हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","मोशाले इस्राएलका मानिसहरूलाई आज्ञा गरे र भने, “तिमीहरूले चिट्ठाद्वारा पाउने मुलुक यही हो, जसलाई साँढे नौ कुललाई दिन परमप्रभुले आज्ञा दिनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","रूबेनका सन्तानहरूका कुलले तिनीहरूको कुलअनुसारको सम्पत्तिको अंश, गादका सन्तानहरूका कुलले तिनीहरूका कुलअनुसारको सम्पत्तिको अंश र मनश्शेका आधा कुलले तिनीहरूको भूमि पाएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","अढाइ कुलले तिनीहरूको हिस्सा यरीहोमा यर्दनपारि पूर्वतिर अर्थात् सूर्योदय हुने दिशामा पाएका छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","परमप्रभु मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“तिनीहरूको अंशको निम्ति भूमिको भाग लगाउनेहरूका नाउँ यिनै हुन्ः पुजारी एलाजार र नूनका छोरा यहोशू । ");
INSERT INTO npiulb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","तिनीहरूको वंशको निम्ति भूमि भाग लगाउन तिमीहरूले हरेक कुलबाट एक-एक जना अगुवा छान्‍नुपर्छ ");
INSERT INTO npiulb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ती मानिसहरूका नाउँ यिनै हुन्ः ");
INSERT INTO npiulb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","यहूदाको कुलबाट यपून्‍नेका छोरो कालेब । ");
INSERT INTO npiulb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","शिमियोनको सन्तानहरूको कुलबाट अम्मीहुदका छोरो शेमुएल, ");
INSERT INTO npiulb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","बेन्यामीनको कुलबाट किसलोनका छोरो एलीदाद, दानको सन्तानहरूको कुलबाट एक जना अगुवा योगलीका छोरो बुक्‍की, ");
INSERT INTO npiulb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","योसेफका सन्तानहरू मनश्शेका सन्तानरूका कुलको एक जना अगुवा एपोदका छोरो हन्‍नीएल, ");
INSERT INTO npiulb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","एफ्राइमका सन्तानहरूका कुलबाट एक जना अगुवा शिप्‍तानको छोरो कमूएल, ");
INSERT INTO npiulb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबूलूनका सन्तानक‍हरूका कुलबाट एक जना अगुवा पर्नाकको छोरो एलीजापान, ");
INSERT INTO npiulb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साकारका सन्तानहरूका कुलबाट एक जना अगुवा अजानको छोरो पल्तिएल, ");
INSERT INTO npiulb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेरको सन्ताहरूका कुलबाट एक जना अगुवा शलोमीको छोरो अहीहूद, ");
INSERT INTO npiulb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नप्‍तालीको सन्तानहरूको कुलबाट एक जना अगुवा अम्मीहूदका छोरो पदहेल ।” ");
INSERT INTO npiulb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","परमप्रभुले यी मानिसहरूलाई कनानको भूमि भाग लगाउन र इस्राएलका कुल-कुललाई तिनीहरूको अंश दिन आज्ञा दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","परमप्रभु यरीहोमा यर्दन नजिकको मोआबको मैदानमा मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इस्राएलका मानिसहरूलाई तिनीहरूका आ-आफ्नो भूमिको हिस्साबाट लेवीहरूलाई केही दिन आज्ञा दे । तिनीहरूले उनीहरूलाई बस्‍नको निम्ति सहरहरू र त्यसको वरिपरि खर्क दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","लेवीहरूले बस्‍नलाई यी सहरहरू पाउने छन् । तिनीहरूका गाईवस्तुहरू, भेडा-बाख्राहरू र तिनीहरूका सबै जनावरका निम्ति खर्क हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","तिमीहरूले लेवीहरूलाई दिने सहर वरिपरिका खर्कहरू सहरका पर्खालहरूदेखि बाहिर वरिपरि सबैतिर एक-एक हजार हातसम्म फैलिएको हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","तिमीहरूले सहरको बाहिरबाट पूर्वपट्टि दुई हजार हात, दक्षिणपट्टि दुई हजार हात, पश्‍चिमपट्टि दुई हजार हात र उत्तरपट्टि दुई हजार हात नाप्‍नुपर्छ । यो तिनीहरूका निम्ति खर्कहरू हुने छ । सहरचाहिँ बिचमा हुने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","तिमीहरूले लेवीहरूलाई दिने सहरहरूमध्ये छ वटाले शरण-नगरहरूको काम गर्नुपर्छ । तिमीहरूले दिएका यी ठाउँहरूले कुनै मानिसलाई मार्ने व्यक्‍ति भाग्‍न सक्‍ने ठाउँ हुनुपर्छ । बयालिसवटा सहर पनि दिनू । ");
INSERT INTO npiulb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","तिमीहरूले लेवीहरूलाई दिने सहरहरू जम्‍मा अठचालिसवटा हुने छ । तिमीहरूले तिनीहरूलाई तिनीहरूका खर्कहरूसहित दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","इस्राएलका मानिसहरूको ठुलो कुलसँग धैरै भूमि हुने भएकोले धेरै सहरहरू दिनुपर्छ । साना कुलहरूले कम सहरहरू दिनुपर्छ । हरेक कुलले आफूले प्राप्‍त गरेको हिस्साअनुसार लेवीहरूको निम्ति दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","त्यसपछि परमप्रभु मोशासँग बोल्नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इस्राएलका मानिसहरूसँग कुरा गर् र तिनीहरूलाई भन्, 'जब तिमीहरू यर्दन तरेर कनानको भूमिमा प्रवेश गर्छौ, ");
INSERT INTO npiulb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तिमीहरूले तिमीहरूको निम्ति शरण-नगरको काम गर्ने सहरहरू चुन्‍नुपर्छ, जसमा कसैलाई अजानमा मारेको व्यक्‍ति त्यो ठाउँमा भागेर जान सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","यी सहरहरू बदला लिने व्यक्‍तिबाट बाँच्‍ने तिमीहरूको शरण-नगर हुनुपर्छ, ताकि दोष लगाइएको व्यक्‍ति समुदायको सामु न्यायको लागि खडा हुनअगि नमारियोस् । ");
INSERT INTO npiulb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","तिमीहरूले छवटा सहरलाई शरण-नगरको रूपमा छान्‍नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तिमीहरूले यर्दनपारि तिनवटा सहर र कनानको भूमिमा तिनवटा सहर दिनुपर्छ । ती शरण-नगर हुने छन् । ");
INSERT INTO npiulb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","यी छवटा सहरले इस्राएलका मानिसहरूका निम्ति, परदेशीहरूका निम्ति र तिमीहरूमाझ बसोबास गर्ने जो कोहीको निम्ति एउटा शरणको काम गर्नेछ, जसमा कसैलाई अजानमा मार्ने व्यक्‍ति भागेर जान सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","तर यदि दोष लगाइएको मानिसले पीडितलाई फलामको हतियारले प्रहार गरेको छ भने, र यदि त्यसले आक्रमण गरेको व्यक्‍ति मर्‍यो भने, दोष लगाइएको व्यक्‍ति हत्यारा नै हो । त्यसलाई मार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","यदि दोष लगाइएको मानिसले कसैलाई आफ्नो हातमा भएको ढुङ्गाले कसैलाई मर्ने गरी प्रहार गरेको छ भने, र यदि त्यो व्यक्‍ति मर्‍यो भने, त्यो दोष लगाइएको व्यक्‍ति हत्यारा नै हो । त्यसलाई मार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","यदि दोष लगाइएको व्यक्‍तिले कसैलाई काठको हतियारले प्रहार गरेको छ भने, र यदि त्यो व्यक्‍ति मर्‍यो भने, दोष लगाइएको व्यक्‍ति हत्यारा नै हो । त्यसलाई मार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","रगतको बदला लिने व्यक्‍तिले हत्यारालाई मार्न सक्छ । त्यसले त्यसलाई भेट्दा, रगतको बदला लिने व्यक्‍तिले त्यसलाई मार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","यदि त्यसले ढुकेर बसी कसैलाई प्रहार गर्छ वा घृणा गरेर केही कुराले आक्रमण गर्छ भने र आक्रमण गरिएको व्यक्‍ति मर्छ भने, ");
INSERT INTO npiulb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","वा यदि त्यसले घृणा गरेको व्यक्‍तिलाई आफ्नै हातले प्रहार गर्छ अनि त्यो आक्रमणमा परेको व्यक्‍ति मर्छ भने, त्यसलाई प्रहार गरेको दोष लगाइएको व्यक्‍तिलाई मार्नुपर्छ । त्यो हत्यारा हो । रगतको बदला लिने व्यक्‍तिले त्यसलाई भेट्दा मार्न सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","तर यदि दोष लगाइएको व्यक्‍तिले पूर्वघृणाविना अचानक कुनै कुरा फ्याँक्दा ढुकेर नबसी नै आक्रमणमा परेको व्यक्‍तिलाई लाग्यो भने, ");
INSERT INTO npiulb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","वा यदि त्यसले आक्रमणमा परेका व्यक्‍तिलाई नदेखी ढुङ्गा फ्याँक्दा लाग्छ र मर्छ, अनि आक्रमणमा परेको व्यक्‍ति दोष लगाइएको व्यक्‍तिको शत्रु होइन भने; त्यसले त्यसलाई चोट पुर्‍याउन खोजिरहेको थिएन । तर आक्रमणमा परेको व्यक्‍ति मर्छ भने यसो गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","त्यस अवस्थामा समुदायले दोष लगाइएको व्यक्‍ति र रगतको बदला लिनेबिच यी नियमहरूको आधारमा न्याय गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","समुदायले दोष लगाइएको व्यक्‍तिलाई रगतको बदला लिने व्यक्‍तिको शक्‍तिबाट छुटकारा दिनुपर्छ । समुदायले त्यो दोष लगाइएको व्यक्‍ति पहिले भागेर गएको शरण-नगरमा नै त्यसलाई फर्काउनुपर्छ । त्यो त्यस बेलाको प्रधान पुजारीको मृत्यु नभएसम्म त्यहीँ नै बस्‍नुपर्छ, जसलाई पवित्र तेलले अभिषेक गरिएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","तर यदि दोष लगाइएको व्यक्‍ति कुनै बखत त्यो भागेर गएको सहरको सिमानाबाहिर जान्छ, ");
INSERT INTO npiulb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","र यदि रगतको बदला लिनेले त्यसलाई शरण-नगरको सिमानाबाहिर फेला पार्छ, र यदि त्यसले त्यो दोष लगाइएको व्यक्‍तिलाई मार्छ भने, रगतको बदला लिने व्यक्‍ति हत्याको दोषी हुने छैन । ");
INSERT INTO npiulb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","किनभने त्यो दोष लागेको व्यक्‍ति प्रधान पुजारीको मृत्यु नभएसम्म त्यसको शरण-नगरभित्र नै बस्‍नु पर्थ्यो । प्रधान पुजारीको मृत्युपछि त्यो दोष लागेको व्यक्‍ति आफ्नो सम्पत्ति भएको ठाउँमा फर्केर जान सक्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","यी नियमहरू तिमीहरू बसोबास गर्ने सबै ठाउँमा तिमीहरूका मानिसहरूका पुस्तौँ-पुस्तासम्मको विधिविधान हुनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","कुनै मानिसलाई मार्ने हत्यारालाई साक्षीहरूले दिएको प्रमाणअनुसार मार्नुपर्छ । तर एक जना मात्र साक्षीको प्रमाणमा कुनै पनि व्यक्‍तिलाई मार्नु हुदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","साथै हत्याराको दोषीको निम्ति तिमीहरूले कुनै किसिको छुटकाराको मूल्य स्वीकार गर्नुहुँदैन । त्यसलाई अवश्य नै मार्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","शरण-नगरमा भागेर गएको व्यक्‍तिको निम्ति तिमीहरूले छुटकाराको मूल्य स्वीकार गर्नुहुँदैन । यसरी प्रधान पुजारीको मृत्यु नभएसम्म तिमीहरूले त्यसलाई आफ्नो जायदाद भएको ठाउँमा बसोबास गर्न दिनुहुँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","तिमीहरू बसोबास गरेको भूमिलाई यसरी दूषित नपार, किनभने हत्याराबाटको रगतले भूमिलाई दूषित पार्छ । भूमिमा रगत बगाएपछि यसको निम्ति रगत बगाउने व्यक्‍तिको रगतले बाहेक कुनै किसिमको प्रायश्‍चित्त गर्न सकिँदैन । ");
INSERT INTO npiulb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","त्यसैले तिमीहरू बसोबास गर्ने भूमिलाई तिमीहरूले अशुद्ध पार्नुहुँदैन, किनभने म यसमा बास गर्छु । म परमप्रभु इस्राएलका मानिसहरूमाझ बास गर्छु । ");
INSERT INTO npiulb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","त्यसपछि योसेफका सन्तानहरूका कुलका माकीरका (जो मनश्शेको छोरा थिए) छोरा गिलादको कुलका पुर्खाहरूका अगुवाहरू आए अनि ");
INSERT INTO npiulb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","मोशा र इस्राएलका मानिसहरूका पुर्खाहरूका परिवारहरूको प्रमुखहरूको सामु भने, “परमप्रभुले हाम्रा मालिक तपाईंलाई इस्राएलका मानिसहरूलाई चिट्ठाद्वारा भूमिको हिस्सा दिने आज्ञा दिनुभयो । हाम्रो भाइ सलोफादको हिस्सा तिनका छोरीहरूलाई दिन परमप्रभुले तपाईंलाई आज्ञा गर्नुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","तर यदि तिनका छोरीहरूले इस्राएलका मानिसहरूको अन्य कुलका पुरुषसँग विवाह गरे भने, भूमिको तिनीहरूको हिस्सा हाम्रा पुर्खाहरूको हिस्साबाट हट्ने छ । यो तिनीहरू सहभागी हुने कुलको हिस्सामा थपिने छ । ");
INSERT INTO npiulb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","यस अवस्थामा यो हाम्रो अंशको तोकिएको हिस्साबाट हट्ने छ । त्यस अवस्थामा इस्राएलका मानिसहरूको पुनर्स्थापनाको वर्ष आउँदा तिनीहरूको हिस्सा तिनीहरू जोडिने कुलमा नै गाभिने छ । यसरी तिनीहरूको हिस्सा हाम्रो पुर्खाको कुलको हिस्साबाट लगिने छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","त्यसैले मोशाले परमप्रभुको वचनमा इस्राएलका मानिसहरूलाई आज्ञा दिए, “योसेफका सन्तानहरूका कुलले भनेको कुरा सही हो । ");
INSERT INTO npiulb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","सलोफादका छोरीको बारेमा परमप्रभुले यो आज्ञा दिनुहुन्छ, 'तिनीहरू आफूलाई उत्तम लाग्‍ने मानिससँग विवाह गरून्, तर तिनीहरूले आफ्ना पिताको परिवारभित्र मात्र विवाह गर्नुपर्छ ।' ");
INSERT INTO npiulb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","इस्राएलका मानिसहरूको कुनै पनि अंश एउटा कुलबाट अर्कोमा बद्‍ली गर्नुहुँदैन । इस्राएलका मानिसहरूको हरेक कुलले आ-आफ्नो पुर्खाको कुलको अंशलाई निरन्तरता दिनुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","आफ्नो कुलमा अंश पाउने हेरक महिलाले आफ्नै पिताको कुलको परिवारभित्र मात्र विवाह गर्नुपर्छ, ताकि इस्राएलका मानिस हरेकले आ-आफ्नो पुर्खाहरूबाटको अंश पाओस् । ");
INSERT INTO npiulb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","कुनै पनि हिस्सा एउटा कुलबाट अर्कोमा बद्ली गर्नुहुँदैन । इस्राएलका मानिसको कुलको हरेकले आ-आफ्नो अंश सुरक्षित राख्‍नुपर्छ ।” ");
INSERT INTO npiulb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","त्यसैले सलोफादका छोरीहरूले परमप्रभुले आज्ञा गर्नुभएबमोजिम गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","सलोफादका छोरी महला, तिर्सा, होग्ला, मिल्का र नोआहले मनश्शेका सन्तानहरूसँग विवाह गरे । ");
INSERT INTO npiulb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","तिनीहरूले योसेफका छोरा मनश्शेका सन्तानहरूका कुलहरूमा विवाह गरे । यसरी तिनीहरूको हिस्सा तिनीहरूको पिताको कुलभित्र नै रह्यो । ");
INSERT INTO npiulb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","परमप्रभुले मोशाद्वारा यरीहोमा यर्दन नजिक मोआबको मैदानमा इस्राएलका मानिसहरूलाई दिनुभएका आज्ञाहरू र नियमहरू यिनै हुन् ।");
INSERT INTO npiulb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","यर्दन नदीको बेँसीको मैदानमा सुपको सामुन्‍ने अराबामा पारान, तोफेल, लाबान, हसेरोत र दीसाहाबका बिचमा यर्दनपारिको उजाड-स्थानमा मोशाले सबै इस्राएलीलाई दिएका वचन यिनै हुन् । ");
INSERT INTO npiulb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","होरेबदेखि सेइर पर्वतको बाटो भएर कादेश-बर्नेसम्म पुग्‍न एघार दिन लाग्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","चालिसौँ वर्षको एघारौँ महिनाको पहिलो दिनमा मोशाले इस्राएलका सबै मानिसलाई परमप्रभुले तिनीहरूको बारेमा मोशालाई आज्ञा गर्नुभएका सबै कुरा तिनले तिनीहरूलाई बताइदिए । ");
INSERT INTO npiulb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","हेश्बोनमा बस्‍ने एमोरीहरूका राजा सीहोन र एद्रईको अस्तारोतमा बस्‍ने बाशानका राजा ओगलाई परमप्रभुले आक्रमण गर्नुभएपछि यो भएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","यर्दनपारि मोआब देशमा मोशाले यी निर्देशनहरू दिन थाले, ");
INSERT INTO npiulb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“परमप्रभु हाम्रा परमेश्‍वर यसो भन्दै होरेबमा हामीसित बोल्नुभयो, 'तिमीहरू यस डाँडामा बसेको धेरै भइसकेको छ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","आफ्नो यात्रा सुरु गरी एमोरीहरूको पहाडी देश र त्यसका छेउछाउका सबै ठाउँ अर्थात् यर्दन नदीको बेँसीको मैदान, पहाडी देश, तराई, नेगेव र समुद्रीतटमा कनानीहरूको देश र लेबनान र महानदी यूफ्रेटिससम्म जाओ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","हेर, मैले यो देश तिमीहरूको सामु राखिदिएको छु । परमप्रभुले तिमीहरूका पिता-पुर्खाहरू अर्थात् अब्राहाम, इसहाक र याकूबसित तिनीहरू र तिनीहरूका सन्तानहरूलाई दिने प्रतिज्ञा गर्नुभएको देशमा गएर यसलाई कब्जा गर ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","त्यस बेला मैले तिमीहरूलाई यसो भनेँ, 'म एक्लै तिमीहरूलाई अगुवाइ गर्न सक्दिनँ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूको वृद्धि गराउनुभएको छ, अब हेर आज तिमीहरू आकाशका तारापुञ्‍जजस्तै धेरै भएका छौ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","परमप्रभु तिमीहरूका पिता-पुर्खाका परमेश्‍वरले आफूले प्रतिज्ञा गरेअनुसार तिमीहरूलाई हजारौँ गुणा वृद्धि गरी तिमीहरूलाई आशिष् दिनुभएको होस् । ");
INSERT INTO npiulb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","तर म आफैले मात्र कसरी तिमीहरूका भार, तिमीहरूका बोझ र तिमीहरूका झगडाहरू बोक्‍न सक्छु ? ");
INSERT INTO npiulb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","हरेक कुलबाट बुद्धिमान् मानिसहरू, समझशक्ति भएकाहरू र असल नाम चलेकाहरूलाई छान र म तिनीहरूलाई तिमीहरूका नायक नियुक्त गर्ने छु ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","तिमीहरूले जवाफ दिई मलाई भन्यौ, 'तपाईंले भन्‍नुभएको कुरो हाम्रो निम्ति असल छ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","त्यसैले मैले तिमीहरूका कुलहरूबाट मुख्य मानिसहरू, बुद्धिमान् मानिसहरू, असल नाउँ चलेकाहरूलाई छानी तिनीहरूलाई तिमीहरूका नायक बनाएँ ताकि तिनीहरूले कुल-कुलअनुसार हजार, सय, पचास र दसको रेखदेख गरून् । ");
INSERT INTO npiulb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","त्यस बेला मैले तिमीहरूका न्यायकर्ताहरूलाई यसो भनी आज्ञा दिएँ, 'तिमीहरूका दाजुभाइहरूका बिचमा भएको झगडालाई सुनी कुनै मानिस, भाइ र तिमीहरूका परदेशीको बिचमा धार्मिकतापूर्वक न्याय गर । ");
INSERT INTO npiulb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","झगदा हुँदा कसैको पक्षपात नगर । साना-ठुला दुवैको कुरामा समान रूपमा ध्यान देओ । मानिसको अनुहारदेखि नडराओ किनकि न्याय परमेश्‍वरको हो । तिमीहरूले मिलाउन नसक्‍ने झगडा मकहाँ ल्याओ र म त्यो सुन्‍ने छु ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","तिमीहरूले गर्नुपर्ने सबै कुरा मैले त्यस बेला नै तिमीहरूलाई आज्ञा गरेको थिएँ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","हामी होरेबबाट यात्रा गरी परमप्रभु हाम्रा परमेश्‍वरले हामीलाई आज्ञा गर्नुभएअनुसार तिमीहरूले देखेका विशाल र डरलाग्दो उजाड-स्थानबाट भएर एमोरीहरूको पहाडी देशतर्फ जाने बाटो लाग्यौँ अनि हामी कादेश-बर्ने आइपुग्यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","मैले तिमीहरूलाई भनेँ, 'तिमीहरू एमोरीहरूको पहाडी देशमा आइपुगेका छौ जुन देश परमप्रभु हाम्रा परमेश्‍वरले हामीलाई दिँदै हुनुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","हेर, परमप्रभु तिमीहरूका परमेश्‍वरले यो देश तिमीहरूका सामु राखिदिनुभएको छ । तिमीहरूका पिता-पुर्खाका परमप्रभु परमेश्‍वरले तिमीहरूलाई आज्ञा गर्नुभएअनुसार माथि उक्लेर यसको अधिकार गर । नडराओ, न त निरुत्साहित होओ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","तिमीहरू हरेक मकहाँ आएर भन्यौ, 'हामीभन्दा अगिअगि मानिसहरू पठाऔँ ताकि तिनीहरूले हाम्रो निम्ति त्यस देशको भेद लिई हामीले त्यस देशलाई कसरी आक्रमण गर्नुपर्छ र हामी कुन-कुन सहरमा आइपुग्‍नुपर्ने हो भन्‍ने बारेमा तिनीहरूले बताऊन् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","त्यो सल्लाहले मलाई ज्यादै खुसी पार्‍यो । मैले तिमीहरूमध्ये हरेक कुलबाट एक-एक गरी बाह्र जना मानिस छानेँ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","तिनीहरू पहाडी देशमा गए । तिनीहरू एश्कोलको बेँसीमा पुगी यसको जासुसी गरे । ");
INSERT INTO npiulb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","तिनीहरूले आ-आफ्ना हातमा त्यस देशका केही उत्पादनहरू हामीकहाँ ल्याए । तिनीहरूले हामीकहाँ यस्तो समाचार पनि ल्याए, 'परमप्रभु हाम्रा परमेश्‍वरले हामीलाई दिन लाग्‍नुभएको यो देश असल छ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","तर तिमीहरूले आक्रमण गर्न इन्कार गरी परमप्रभु तिमीहरूका परमेश्‍वरको आज्ञाको विरुद्धमा गयौ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","तिमीहरूका पालहरूमा गनगन गर्दै तिमीहरूले भन्यौ, “परमप्रभुले हामीलाई घृणा गर्नुभएको छ । त्यसैले, एमोरीहरूको हातमा सुम्पी हामीलाई नष्‍ट गर्न उहाँले हामीलाई मिश्र देशबाट बाहिर ल्याउनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","अब हामी कहाँ जाने? हाम्रा दाजुभाइहरूले यसो भनी हामीलाई निराश बनाएका छन्, 'ती मानिसहरू हामीभन्दा ठुला र अग्ला छन् । तिनीहरूका सहरहरू विशाल छन् र आकाशसम्मै पर्खाल लगाइएका छन् । त्यस बाहेक, त्यहाँ हामीले अनाकीहरूका सन्तानहरूलाई पनि देखेका छौँ' ।” ");
INSERT INTO npiulb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","तब मैले तिमीहरूलाई भनेँ, 'भयभीत नहोओ, न त तिनीहरूदेखि डराओ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","तिमीहरूका अगिअगि जानुहुने तिमीहरूका परमप्रभु परमेश्‍वर नै तिमीहरूका पक्षमा लड्नुहुने छ जस्तो तिमीहरूकै आँखाका सामुन्‍ने मिश्रमा तिमीहरूका निम्ति उहाँले गर्नुभएको थियो । ");
INSERT INTO npiulb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","तिमीहरू यस ठाउँमा नआइपुगुञ्‍जेलसम्म बुबाले आफ्नो छोरोलाई बोकेजस्तै उजाड-स्थानसाथै हरेक ठाउँमा परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूलाई बोक्‍नुभएको तिमीहरूले देखेकै छौ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","यस वचनका बाबजुत पनि तिमीहरूले परमप्रभु तिमीहरूका परमेश्‍वरमा विश्‍वास गरेनौ ");
INSERT INTO npiulb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","जो रातमा आगो र दिनमा बादल बनेर तिमीहरूलाई छाउनी बनाउने ठाउँ पत्ता लगाउन तिमीहरूका अगिअगि जानुभयो । ");
INSERT INTO npiulb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","परमप्रभुले तिमीहरूको आवाज सुन्‍नुभयो र उहाँ रिसाउनुभयो । उहाँले शपथ खाएर भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","'निश्‍चय नै यो दुष्‍ट पुस्ताको एउटै मान्छेले पनि मैले तिमीहरूका पिता-पुर्खाहरूलाई दिन्छु भनेको असल देश देख्‍ने छैन । ");
INSERT INTO npiulb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","तर यपुन्‍नेका छोरा कालेबले यो देश देख्‍नेछ । त्यसले पूर्ण रूपमा परमप्रभुलाई पछ्याएकोले म त्यसलाई र त्यसका सन्तानहरूलाई त्यसले पाइला टेकेको यो देश दिने छु ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तिमीहरूका कारणले परमप्रभु मसित पनि रिसाउनुभयो, 'तँ पनि त्यहाँ जाने छैनस् । ");
INSERT INTO npiulb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","मेरो सामु खडा हुने नूनका छोरा यहोशू त्यहाँ जाने छ । त्यसलाई उत्साह दे किनकि त्यसले यस देशको कब्जा गर्न इस्राएललाई अगुवाइ गर्नेछ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","यस बाहेक, तेरा स-साना बालबालिकाहरू जसको विषयमा तैँले तिनीहरू सिकार हुने छन् भनी बताएको थिइस्, जससित आज असल र खराबको ज्ञान छैन, तिनीहरू नै त्यहाँ जाने छन् । तिनीहरूलाई म यो देश दिने छु र तिनीहरूले यसको अधिकार गर्ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","तर तिमीहरू भने फर्केर उजाड-स्थानको बाटो हुँदै नर्कटहरूको समुद्रको दिशातर्फ जाओ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","तब तिमीहरूले मलाई जवाफ दियौ, 'हामीले परमप्रभुको विरुद्धमा पाप गरेका छौँ । हामी माथि उक्लेर लडाइँ गर्ने छौँ, र परमप्रभु हाम्रा परमेश्‍वरले हामीलाई गर्नू भनी आज्ञा दिनुभएका सबै कुरा हामी गर्नेछौँ । तिमीहरूका बिचमा भएका हरेक पुरुषले आ-आफ्नो हतियार उठाएर त्यस पहाडी देशलाई आक्रमण गर्न तयार भयौ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","परमप्रभुले मलाई भन्‍नुभयो, 'तिनीहरूलाई भन्, “आक्रमण नगर्; लडाइँ नगर् किनकि म तिमीहरूसँग हुने छैनँ, र तिमीहरू आफ्ना शत्रुहरूद्वारा पराजित हुने छौ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","मैले तिमीहरूलाई यसरी नै भनेँ, तर तिमीहरूले मेरो कुरा सुनेनौ । तिमीहरू परमप्रभुको आज्ञाको विरुद्धमा गयौ । तिमीहरू हठी भयौ र त्यस पहाडी देशलाई आक्रमण गर्न गयौ । ");
INSERT INTO npiulb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","तर त्यस पहाडी देशमा बस्‍ने एमोरीहरू तिमीहरूको विरुद्धमा आएर तिमीहरूलाई मौरीलाई झैँ लखेटे अनि सेइरदेखि होर्मासम्मै तिमीहरूलाई प्रहार गरे । ");
INSERT INTO npiulb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तिमीहरू फर्केर पमरप्रभुको सामु रोयौ । तर पमरप्रभुले तिमीहरूको रुवाइ सुन्‍नुभएन, न त उहाँले तिमीहरूलाई ध्यानै दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","त्यसैले तिमीहरू कादेशमा धेरै दिनसम्म बस्यौ । तिमीहरूले त्यहाँ पुरै दिनहरू बितायौ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","तब हामी परमप्रभुले मलाई भन्‍नुभएझैँ नर्कटहरूको समुद्रको दिशातर्फ उजाड-स्थानमा यात्रा गर्‍यौँ । हामीले धेरै दिनसम्म सेइर पर्वतको फन्को मार्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","परमप्रभुले मलाई यसो भन्‍नुभयो, ' ");
INSERT INTO npiulb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","तिमीहरू धेरै दिनसम्म यस पर्वतको वरिपरि घुम्दै छौ । अब उत्तरतिर फर्क । ");
INSERT INTO npiulb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","मानिसहरूलाई यसो भनी आज्ञा दे, 'तिमीहरू सेइरमा बस्‍ने एसावका सन्तानहरू अर्थात् तिमीहरूका दाजुभाइहरूको सिमाना पार गरेर जानुपर्छ । तिनीहरू तिमीहरूदेखि डराउने छन् । त्यसकारण सावधान होओ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","तिनीहरूसँग लडाइँ नगर्नू किनकि म तिनीहरूको कुनै पनि देश तिमीहरूलाई दिने छैनँ । पैतलाले टेक्‍ने जत्रो ठाउँ पनि म तिमीहरूलाई दिने छैनँ । किनकि मैले सेइर पर्वत एसावको अधिकारमा दिएको छु । ");
INSERT INTO npiulb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तिमीहरूले खानका लागि पैसा तिरेर तिनीहरूबाट खाना किन्‍नू । तिमीहरूले पिउनका लागि पैसा तिरेर तिनीहरूबाट पानी पनि किन्‍नू । ");
INSERT INTO npiulb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","किनकि परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूलाई तिमीहरूका हातका सबै काममा तिमीहरूलाई आशिष् दिनुभएको छ । यो ठुलो उजाड-स्थानको यात्राभरि उहाँले तिमीहरूको हेरचाह गर्नुभएको छ । यी चालिस वर्ष परमप्रभु तिमीहरूका परमेश्‍वर तिमीहरूसित हुनुभएको छ, र तिमीहरूलाई कुनै कुरोको कमी भएको छैन' ।” ");
INSERT INTO npiulb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","त्यसैले हामी सेइरमा बस्‍ने एसावका सन्तानहरू अर्थात् हाम्रा दाजुभाइहरूका सिमानाहरू भएर गयौँ । यो ठाउँ एलात र एस्योन-गेबेर अनि अराबाट पर पर्छ । तब हामी फर्केर मोआबको उजाड-स्थानको बाटो लाग्यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","परमप्रभुले मलाई भन्‍नुभयो, 'मोआबलाई दुःख नदे, र तिनीहरूसित लडाइँ नगर् । म त्यसको देश तिमीहरूको आफ्नो अधिकार हुनलाई दिन्‍नँ किनभने मैले आर सहरलाई लोतका सन्तानहरूको अधिकार हुनलाई दिएको छु ।' ");
INSERT INTO npiulb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(पहिले त्यहाँ एमीहरू बस्थे जुन जाति पराक्रमी, असङ्ख्य र अनाकीहरूजस्तै अग्ला-अग्ला थिए । ");
INSERT INTO npiulb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","अनाकीहरूझैँ यी मानिसहरू पनि रपाईहरू हुन् भनी ठानिन्छ, तर मोआबीहरूले तिनीहरूलाई एमी भन्थे । ");
INSERT INTO npiulb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","सेइरमा पहिले होरीहरू पनि बस्थे, तर एसावका सन्तानहरूले तिनीहरूलाई धपाए । तिनीहरूले होरीहरूलाई त्यहाँबाट निकाली तिनीहरूको ठाउँमा बसोबास गरे जस्तो परमप्रभुले इस्राएललाई तिनीहरूको अधिकारको रूपमा यो देश दिनुभएको थियो ।) ");
INSERT INTO npiulb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","'अब उठेर जेरेद खोला पारि जाओ ।' त्यसैले हामी जेरेद खोला पारि गयौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","कादेश-बर्नेबाट जेरेद खोला पारिसम्म आउन हामीलाई अठतिस दिन लाग्यो । त्यस बेलासम्म परमप्रभुले शपथ खानुभएझैँ लडाइँको लागि योग्य सबै मानिसको त्यो पुस्ता नष्‍ट भइसकेको थियो । ");
INSERT INTO npiulb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","त्यस बाहेक, तिनीहरूलाई नष्‍ट नपारूञ्‍जेल परमप्रभुको हात त्यो पुस्ताको विरुद्धमा थियो । ");
INSERT INTO npiulb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","जब मानिसहरूका बिचबाट लडाइँको लागि योग्य सबै मानिस मरेर गए, ");
INSERT INTO npiulb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","परमप्रभुले मलाई यसो भन्‍नुभयो, ");
INSERT INTO npiulb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","'आज तिमीहरूले मोआबको सिमाना आर सहरलाई पार गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","तिमीहरू अम्मोनका मानिसहरूको सिमानामा आइपुग्दा तिनीहरूलाई दुःख नदेओ वा तिनीहरूसित लडाइँ नगर । अम्मोनीहरूको कुनै पनि भूमि म तिमीहरूको अधिकारको रूपमा दिन्‍नँ । किनकि मैले यो देश लोतका सन्तानहरूलाई अधिकारको रूपमा दिएको छु ।' ");
INSERT INTO npiulb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(त्यसलाई पनि रपाईहरूको देश ठानिन्थ्यो । त्यहाँ पहिले रपाईहरू बस्थे, तर अम्मोनीहरूले तिनीहरूलाई जमजुम्मीहरू भन्दथे । ");
INSERT INTO npiulb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","तिनीहरू पराक्रमी, असङ्ख्य र अनाकीहरूझैँ अग्ला-अग्ला थिए । तर परमप्रभुले अम्मोनीहरूकै सामुन्‍ने तिनीहरूलाई नष्‍ट गरिदिनुभयो र तिनीहरूले यिनीहरूलाई धपाएर तिनीहरू यिनीहरूको ठाउँमा बसे । ");
INSERT INTO npiulb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","परमप्रभुले सेइरमा बस्‍ने एसावका सन्तानहरूकै सामुन्‍ने होरीहरूलाई नष्‍ट गरी तिनीहरूको ठाउँमा यिनीहरूलाई राख्‍नुहुँदा यिनीहरूका लागि पनि यसै गर्नुभयो । यिनीहरू आजसम्म यहाँ बसोबास गर्दै छन् । ");
INSERT INTO npiulb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","गाजासम्म टाढा गाउँहरूमा बस्‍ने अव्वीहरूलाई कप्‍तोरबाट आएका कप्‍तोरीहरूले नष्‍ट पारी तिनीहरूको ठाउँमा बसोबास गरे ।) ");
INSERT INTO npiulb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","'अब उठेर आफ्ना यात्रा थाल अनि अर्नोनको बेँसी पार गर । हेर, मैले हेश्बोनका राजा एमोरी सीहोन र त्यसको देश तिमीहरूलाई दिएको छु । यसलाई कब्जा गर्न थाल र त्योसित लडाइँ गर । ");
INSERT INTO npiulb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","पुरै आकाशमुनि भएका जाति-जातिहरूमा म तिमीहरूको डर र त्रास हाल्न सुरु गर्ने छु । तिनीहरूले तिमीहरूको बारेमा भएको खबर सुनेर थरथर काम्‍ने छन् अनि तिमीहरूको कारणले विचलित हुने छन् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","मैले कदेमोतको उजाड-स्थानबाट हेश्बोनका राजा सीहोनलाई शान्तिका वचनहरूसहित सन्देशवाकहरू पठाएँ, ");
INSERT INTO npiulb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","'मलाई तपाईंको देश भएर जान दिनुहोस् । म लोकमार्ग भएर जानेछु । म दाहिने र देब्रे लाग्‍ने छैनँ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","खानको लागि तपाईंले मलाई पैसामा खाना बेच्नुहुने छ र पिउनको लागि पैसामा पानी दिनुहुने छ । केवल मलाई तपाईंको देश भएर जान दिनुहोस् ");
INSERT INTO npiulb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","। जसरी सेइरमा बस्‍ने एसावका सन्तानहरू र आर सहरमा बस्‍ने मोआबीहरूले मेरो निम्ति गरेथे त्यसै गरी मैले यर्दन पार गरी परमप्रभु हाम्रा परमेश्‍वरले हामीलाई दिनुहुने देशमा नपुगेसम्म त्यसै गर्नुहोस् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","तर हेश्बोनका राजा सीहोनले हाम्रो कुरा सुनेनन् र हामीलाई तिनको बाटो भएर जान दिएनन् । किनकि परमप्रभु तिमीहरूका परमेश्‍वरले तिनको मन कठोर बनाइदिनुभएको थियो र तिनको हृदय हठी बनाइदिनुभएको थियो ताकि तिमीहरूको शक्तिद्वारा उहाँले तिनलाई पराजित गर्नुभएको होस् जस्तो उहाँले आजको दिनसम्म गर्नुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","परमप्रभुले मलाई भन्‍नुभयो, 'हेर्, मैले तेरै सामुन्‍ने सीहोन र त्यसको देश तँलाई दिन थालेको छु । यस देशमाथि तेरो अधिकार होस् भनेर यसलाई कब्जा गर्न थाल् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","तब सीहोन आफ्ना सबै मानिस लिएर यहसा भन्‍ने ठाउँमा हाम्रो विरुद्धमा लड्न आए । ");
INSERT INTO npiulb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","परमप्रभु हाम्रा परमेश्‍वरले तिनलाई हाम्रो हातमा सुम्पिदिनुभयो र हामीले तिनी, तिनका छोराहरू र तिनका सबै मानिसलाई पराजित गर्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","त्यस बेला हामीले तिनका सबै सहर कब्जा गरी हरेक सहर, पुरुष र स्‍त्रीहरू अनि बालबच्‍चाहरूलाई पूर्ण रूपले नष्‍ट पार्‍यौँ । एउटै पनि बाँचेन । ");
INSERT INTO npiulb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","आफ्ना निम्ति लुटको मालको रूपमा लगेका गाईवस्तु र सहरबाट लुटिएका मालहरू मात्र हामीले लियौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","अर्नोन बेँसीको छेउमा भएको अरोएरदेखि र बेँसीमा भएको सहरदेखि गिलादसम्म हामीले कब्जा गर्न नसक्‍ने कुनै सहर थिएन । परमप्रभु हाम्रा परमेश्‍वरले ती हाम्रा हातमा दिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","केवल अम्मोनका सन्तानहरूको देशसाथै यब्बोक नदीका सबै किनाराका जग्गा अनि पहाडी देशका सहरहरू जहाँ परमप्रभु हाम्रा परमेश्‍वरले जान हामीलाई निषेध गर्नुभयो थियो, त्यहाँ तिमीहरू गएनौ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","तब हामी फर्केर बाशानको बाटोतर्फ लाग्यौँ । बाशानका राजा ओग र तिनका मानिसहरू एद्रईमा हामीलाई आक्रमण गर्न आए । ");
INSERT INTO npiulb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","परमप्रभुले मलाई भन्‍नुभयो, 'त्यसदेखि नडरा । किनकि मैले तँलाई त्यसमाथि विजय दिएको छु, र तेरा सबै मानिस र त्यसको भूमि तेरो नियन्त्रणमा राखिदिएको छु । तैँले हेश्बोनमा बस्‍ने एमोरीहरूका राजा सीहोनलाई गरेजस्तै त्यसलाई गर्ने छस् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","त्यसैले परमप्रभु हाम्रा परमेश्‍वरले हामीलाई बाशानका राजा ओग र तिनका सबै मानिसमाथि विजय दिनुभई हाम्रो नियन्त्रणमा दिनुभयो । हामीले एउटै पनि नछाडि तिनका मानिसहरूलाई मार्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","त्यस बेला हामीले तिनका सबै सहर कब्जा गर्‍यौँ । हामीले बाशानमा अर्गोबको राज्यसाथै ओगको राज्य गरी एउटै पनि नछाडि सबै साठीवटा सहरलाई कब्जा गर्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","यी सबै सहर अग्ला-अग्ला पर्खालले घेरिएका, प्रवेशद्वार र बारहरू भएका सहरहरू थिए । यीबाहेक पर्खाल नलगाइएका धेरै सहरहरू पनि थिए । ");
INSERT INTO npiulb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","हामीले हेश्बोनका राजालई गरेजस्तै तिनीहरूका पुरुष र स्‍त्रीहरूसाथै स-साना बालबच्‍चालाई पूर्ण रूपमा नष्‍ट पार्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","तर सबै गाईवस्तु र सहरका धनमाल भने लुटको मालको रूपमा हामीले लियौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","त्यस बेला हामीले एमोरीहरूका दुई राजाका हातबाट यर्दन पारिको अर्नोनको बेँसीदेखि हेर्मोन डाँडासम्मको देश कब्जा गर्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(हेर्मोनलाई सीदोनीहरूले सिरिओन र एमोरीहरूले सेनीर भन्दछन्) । ");
INSERT INTO npiulb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","हामीले तराईका सबै सहर, सबै गिलाद, सबै बाशान, सलका र एद्रईसम्मका इलाकाहरू अनि बाशानमा भएका ओग राज्यका सबै सहर कब्जा गर्‍यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(रपाईहरूमा केवल बाशानका राजा जीवित रहे । तिनको पलङ्ग फलामको थियो । मानिसहरूको नापअनुसार यो नौ हात लामो र चार हात चौडा थियो । के अम्मोनका सन्तानहरू रब्बामा नै बस्थेनन् र?) ");
INSERT INTO npiulb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","त्यस बेला हामीले अधिकारको रूपमा लिएको देश अर्थात् अर्नोनको बेँसीनेर अरोएरदेखि गिलादको पहाडी देशको आधा भाग र यसका सहरहरू मैले रूबेनीहरू र गादीहरूलाई दिएँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","गिलादको बाँकी भाग र सम्पूर्ण बाशान अर्थात् ओगको राज्य (अर्गोबको सम्पूर्ण राज्य र सम्पूर्ण बाशान) मैले मनश्शेको आधा कुललाई दिएँ । (उही क्षेत्रलाई रपाईहरूको देश भनिन्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनश्शेका सन्तान याईरले गशूरी र माकातीहरूको सिमानासम्म अर्गोबको सारा राज्य कब्जा गरे । तिनले त्यस क्षेत्र र बाशानलाई आफ्नै नाउँद्वारा हब्बात-याईर नाउँ दिए जसलाई आजसम्म उही नामले चिनिन्छ ।) ");
INSERT INTO npiulb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","मैले गिलादचाहिँ माकीरलाई दिएँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","रूबेनीहरू र गादीहरूलाई मैले गिलाददेखि अर्नोन बेँसीसम्म (बेँसीको मध्य भाग त्यस इलाकाको सिमाना थियो) र यब्बोक नदी (जुन अम्मोनीहरूको सिमाना थियो) दिएँ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","यसको अर्को सिमाना किन्‍नरेतदेखि पिसगा टापुको पूर्वपट्टि रहेको भीरमुनि अराबा समुद्र (अर्थात् खारा समुद्र) सम्म अर्थात् यर्दन नदीको बेँसीको मैदान थियो । ");
INSERT INTO npiulb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","त्यस बेला मैले तिमीहरूलाई यसो भनेर आज्ञा दिएँ, 'परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूलाई यो देश अधिकार गर्न दिनुभएको छ । सबै योद्धाहरू इस्राएलका मानिसहरू अर्थात् तिमीहरूका दाजुभाइहरूका सामु हतियार भिरेर जानुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","तर तिमीहरूका पत्‍नीहरू, तिमीहरूका बालबच्‍चाहरू र तिमीहरूका गाईवस्तु (तिमीहरूसित थुप्रै गाईवस्तु छन् भनी मलाई थाहा छ) मैले तिमीहरूलाई दिएका सहरहरूमा बस्‍ने छन् । ");
INSERT INTO npiulb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","परमप्रभुले तिमीहरूलाई झैँ तिमीहरूका दाजुभाइहरूलाई विश्राम नदिनुभएसम्म र परमप्रभुले तिमीहरूलाई दिनुहुने यर्दनपारिको भूमि तिमीहरूलाई अधिकार गर्न नदिनुभएसम्म तिमीहरूले यसो गर्नू । तब मैले तिमीहरूलाई अधिकारमा दिएको देशमा तिमीहरू हरेक फर्केर आउने छौ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","त्यस बेला मैले यहोशूलाई यसो भनेर आज्ञा दिएँ, 'परमप्रभु तिमीहरूका परमेश्‍वरले यी दुई राजालाई गर्नुभएका सबै कुरा तिम्रो आफ्नै आँखाले देखेका छन् । अब तिमीहरू पारि जाँदा सबै राज्यलाई पनि परमप्रभुले उही गर्नुहुने छ । ");
INSERT INTO npiulb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","तिनीहरूदेखि नडराओ किनकि परमप्रभु तिमीहरूका परमेश्‍वर नै तिमीहरूको पक्षमा लड्नुहुने छ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","त्यस बेला मैले परमप्रभुलाई यसो भनेर बिन्ती चढाएँ, ");
INSERT INTO npiulb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","'हे परमप्रभु परमेश्‍वर, तपाईंले आफ्ना दासलाई तपाईंको महान्‌ता र तपाईंको शक्तिशाली हात देखाउन थाल्नुभएको छ किनकि स्वर्ग र पृथ्वीमा त्यस्तो कुनचाहिँ देव छ जसले तपाईंले गर्नुभएका शक्तिशाली कार्यहरू गर्न सक्छ? ");
INSERT INTO npiulb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","म बिन्ती गर्दछु, कि मलाई पारि गएर यर्दनपारिको त्यो देश, असल पहाडी देश र लेबनान पनि देख्‍न दिनुहोस् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","तर तिमीहरूका कारणले परमप्रभु मसित रिसाउनुभयो । उहाँले मेरो कुरा सुन्‍नुभएन । परमप्रभुले मलाई भन्‍नुभयो, 'तेरो लागि यति नै पर्याप्‍त होस् । अबदेखि उसो यस विषयमा मसित नबोल् । ");
INSERT INTO npiulb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगाको टाकुरामा उक्लेर तेरा आँखा पश्‍चिमतिर, उत्तरतिर, दक्षिणतिर र पूर्वतिर लगा । तेरा आँखाले हेर् किनकि तँ यर्दनपारि जान पाउने छैनस् । ");
INSERT INTO npiulb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","बरु, यहोशूलाई निर्देशन दिनू र त्यसलाई उत्साह दिएर बलियो पार्नू किनकि त्यो यो जातिको अगिअगि पारि जाने छ, र त्यसले नै तैँले देखेको यो देश तिनीहरूलाई अधिकार गर्न लाउने छ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","त्यसैले हामी बेथ-पोरको सामुन्‍नेको बेँसीमा बस्यौँ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","अब हे इस्राएली हो, मैले तिमीहरूलाई सिकाउनै लागेका विधिविधानहरूलाई सुन । तिनको पालन गरी तिमीहरू जीवित होऊ र परमप्रभु तिमीहरूका पिता-पुर्खाका परमेश्‍वरले तिमीहरूलाई दिन लाग्‍नुभएको देशमा गएर त्यसलाई अधिकार गर । ");
INSERT INTO npiulb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","मैले तिमीहरूलाई आज्ञा गरेका वचनहरूमा नथप्‍नू न त तीबाट घटाउनू ताकि परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूलाई दिन लाग्‍नुभएका आज्ञाहरू तिमीहरूले पालन गर्न सक । ");
INSERT INTO npiulb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","बाल-पोरको कारणले परमप्रभुले के गर्नुभयो, त्यो तिमीहरूका आँखाले देखेका छन् । पोरको बाल देवतालाई पछ्याउने सबै मानिसलाई परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूकै बिचबाट नष्‍ट पारिदिनुभयो । ");
INSERT INTO npiulb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","तर परमप्रभु तिमीहरूका परमेश्‍वरसित टाँसिनेहरूमध्ये हरेक आज जीवित छ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","हेर, परमप्रभु मेरा परमेश्‍वरले मलाई आज्ञा गर्नुभएझैँ मैले तिमीहरूलाई विधिविधानहरू सिकाएको छु, कि तिमीहरूले अधिकार गर्न लागिरहेको देशमा तिमीहरू प्रवेश गर्दा तिमीहरूले ती पालन गर्नुपर्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","त्यसकारण ती मान र पालन गर । किनकि जाति-जातिहरूको दृष्‍टिमा यो तिमीहरूको बुद्धि र समझशक्ति हुने छ जसले यी सबै विधिविधानको बारेमा सुनेर यसो भन्‍ने छन्, 'निश्यच नै, यो महान् जाति बुद्धिमानी र समझशक्ति भएको जाति रहेछ ।' ");
INSERT INTO npiulb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","किनकि हामीले जहिलेसुकै पुकारा गर्दा हाम्रा परमप्रभु परमेश्‍वर जत्ति नजिक हुनुहुन्छ, त्यति अर्को कुन जातिको ईश्‍वर नजिक छ ? ");
INSERT INTO npiulb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","आज मैले तिमीहरूका सामु राखिरहेको यो व्यवस्थाजस्तै धार्मिक विधिविधान भएको कुनचाहिँ अर्को महान् जाति छ ? ");
INSERT INTO npiulb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","केवल ध्यान देओ र आ-आफूलाई होसियारीपूर्वक पहरा देओ ताकि तिमीहरूका आँखाले देखेका कुराहरू तिमीहरूले नबिर्स र तिमीहरूका जीवनभरि ती तिमीहरूका ह्रदयबाट नजाऊन् । बरु, ती तिमीहरूका छोराछोरीहरू र नातिनातिनाहरूलाई सिकाओ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","होरेबमा तिमीहरू परमप्रभु तिमीहरूका परमेश्‍वरको सामु उभिएको दिनमा परमप्रभुले मलाई यसो भन्‍नुभयो, 'मानिसहरूलाई जम्मा गर् र म तिनीहरूलाई मेरा वचन सुन्‍ने बनाउने छु ताकि यस पृथ्वीमा तिनीहरू बाचुञ्‍जेलसम्म तिनीहरूले मेरो भय मान्‍न सिकून् र तिनीहरूका छोराछोरीहरूलाई सिकाउन सकून् ।' ");
INSERT INTO npiulb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","तिमीहरू पर्वतको फेदको नजिक आएर उभियौ । पर्वतमा आगो दन्केर आकाशको बिचसम्मै पुग्यो, अनि बाक्लो अन्धकार र बादल छायो । ");
INSERT INTO npiulb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","आगोको बिचबाट परमप्रभु तिमीहरूसित बोल्नुभयो । तिमीहरूले बोलिएको वचनको आवाज सुन्यौ तर त्यहाँ तिमीहरूले कुनै स्वरूप देखेनौ । तिमीहरूले आवाज मात्रै सुन्यौ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","उहाँले तिमीहरूलाई तिमीहरूले पालन गर्नुपर्ने उहाँको करार अर्थात् दस आज्ञाको घोषणा गर्नुभयो । उहाँले तिनलाई दुईवटा शिला-पाटीमा लेख्‍नुभयो । ");
INSERT INTO npiulb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","तिमीहरूलाई विधिविधानहरू सिकाउन त्यस बेला परमप्रभुले मलाई आज्ञा दिनुभयो ताकि पारि गएर तिमीहरूले अधिकार गर्न लागिरहेको देशमा ती पालन गर्न सक । ");
INSERT INTO npiulb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","त्यसैले तिमीहरूले आ-आफूलाई ध्यान देओ किनकि त्यस दिन होरेबमा परमप्रभु आगोको बिचबाट तिमीहरूसित बोल्नुहुँदा तिमीहरूले कुनै स्वरूप देखेनौ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","कुनै पुरुष वा स्‍त्रीको स्वरूपमा वा खोपेर कुनै पनि प्रतिमा बनाएर वा ");
INSERT INTO npiulb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","पृथ्वीमा कुनै पशुको स्वरूप वा आकाशमा उड्ने कुनै चराचुरुङ्गी वा ");
INSERT INTO npiulb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","भुइँमा घस्रने कुनै पनि प्राणी वा पृथ्वीमुनि पानीमा भएको कुनै पनि माछाको प्रतिमा बनाएर तिमीहरूले आफूलाई भ्रष्‍ट नपार । ");
INSERT INTO npiulb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","पुरै आकाशमुनि सबै जातिलाई परमप्रभु तिमीहरूका परमेश्‍वरले दिनुभएका सूर्य, चन्द्रमा वा ताराहरूसाथै सबै आकाशीय पिण्डहरू देखेर तिनको पुजा आराधना गर्न आफ्ना आँखा माथि नउठाओ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","तर परमप्रभुले तिमीहरूलाई उहाँको आफ्नै निज सम्पत्ति (जस्तो आज तिमीहरू छौ) बनाउन आगोको भट्टी अर्थात् मिश्रबाट निकालेर ल्याउनुभएको छ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","तिमीहरूका कारणले परमप्रभु मसित रिसाउनुभयो । म यर्दनपारि जान नपाउने र परमप्रभु तिमीहरूका परमेश्‍वरले सम्पत्तिको रूपमा तिमीहरूलाई दिनुहुने देशमा जान नपाउने गरी उहाँले शपथ खानुभयो । ");
INSERT INTO npiulb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","बरु, म यस देशमै मर्नुपर्छ । म यर्दनपारि जान पाउने छैनँ । तर तिमीहरू त्यस असल देशमा गएर त्यसको अधिकार गर्ने छौ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","सावधान बस ताकि परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूसित बाँध्‍नुभएको करार तिमीहरूले नभुल र परमप्रभु तिमीहरूका परमेश्‍वरले तिमीहरूलाई निषेध गर्नुभएको कुनै पनि कुराको प्रतिमूर्ति नबनाओ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","किनकि परमप्रभु तिमीहरूका परमेश्‍वर भस्म पार्ने आगो र डाही परमेश्‍वर हुनुहुन्छ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","तिमीहरूले छोराछोरीहरू र नातिनातिनाहरू जन्माइसकेपछि तिमीहरू लामो समयसम्म त्यस देशमा बस्दा तिमीहरूले आफूलाई भ्रष्‍ट पारी खोपेर कुनै पनि कुराको प्रतिमूर्ति बनाएर परमप्रभु तिमीहरूका परमेश्‍वरको दृष्‍टिमा दुष्‍ट काम गरी उहाँलाई चिढ्यायौ भने म आज स्वर्ग र पृथ्वीलाई तिमीहरूका विरुद्धमा साक्षी राख्दछु, ");
INSERT INTO npiulb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","कि जुन देश अधिकार गर्न तिमीहरू यर्दनपारि जाँदै छौ त्यस देशबाट तिमीहरू चाँडै नै पूर्ण रूपमा नष्‍ट हुने छौ । त्यहाँ तिमीहरू लामो समयसम्म बाँच्ने छैनौ, तर तिमीहरू पूर्ण रूपमा नष्‍ट हुने छौ । ");
INSERT INTO npiulb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","परमप्रभुले तिमीहरूलाई जाति-जातिहरूका बिचमा तितर-बितर पारिदिनुहुने छ, र उहाँले तिमीहरूलाई धपाउनुभएका जातिहरूका