﻿USE sofia;
DROP TABLE IF EXISTS sofia.npioncb_vpl;
CREATE TABLE npioncb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES npioncb_vpl WRITE;
INSERT INTO npioncb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","आदिमा परमेश्‍वरले आकाशमण्डल र पृथ्वी सृष्‍टि गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी आकारविनाको र शून्य थियो। गहिराइको सतहमाथि अन्धकार थियो, र पानीमाथि परमेश्‍वरको आत्मा घुमिरहनुहुन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","अनि परमेश्‍वरले आज्ञा गर्नुभयो, “उज्यालो होस्,” तब उज्यालो भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","अनि परमेश्‍वरले देख्नुभयो, त्यो असल थियो। उहाँले उज्यालो र अँध्यारोलाई अलग गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्‍वरले उज्यालोलाई “दिन” र अँध्यारोलाई “रात” भनेर नाम दिनुभयो। साँझ पर्‍यो र बिहान भयो—पहिलो दिन। ");
INSERT INTO npioncb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","अनि परमेश्‍वरले आज्ञा गर्नुभयो, “पानीलाई पानीबाट अलग गर्नलाई पानीको बीचमा एउटा अन्तर होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","यसरी परमेश्‍वरले एउटा अन्तर बनाउनुभयो। अनि अन्तरमुनिको पानी र अन्तरमाथिको पानीलाई अलग-अलग गर्नुभयो। तब त्यस्तै भइहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्‍वरले अन्तरलाई “आकाश” भनेर नाम दिनुभयो। साँझ पर्‍यो र बिहान भयो—दोस्रो दिन। ");
INSERT INTO npioncb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","त्यसपछि परमेश्‍वरले आज्ञा गर्नुभयो, “आकाशमुनि भएको पानी एक ठाउँमा जम्मा होस् र ओबानो भूमि देखा परोस्।” तब त्यस्तै भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्‍वरले सुक्खा जमिनलाई “भूमि” र जम्मा भएको पानीको भागलाई “समुद्र” भनेर नाम दिनुभयो। अनि परमेश्‍वरले देख्नुभयो, त्यो असल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","तब परमेश्‍वरले आज्ञा गर्नुभयो, “भूमिले वनस्पति, किसिम-किसिमका बिउ हुने बोटबिरुवा र बिउ हुने फल फल्ने रूखहरू पृथ्वीमा उमारोस्।” तब त्यस्तै भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","भूमिले वनस्पति उमार्‍यो: आ-आफ्नै प्रकारअनुसारका बिउ भएका बिरुवा र रूखहरूले आ-आफ्नै प्रकारअनुसार बिउ भएका फलका रूखहरू उमार्‍यो। अनि परमेश्‍वरले देख्नुभयो, त्यो असल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","अनि साँझ पर्‍यो र बिहान भयो—तेस्रो दिन। ");
INSERT INTO npioncb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","तब परमेश्‍वरले आज्ञा गर्नुभयो, “आकाशको अन्तरमा दिन र रात छुट्याउनलाई ज्योतिहरू होऊन्। तिनीहरू ऋतुहरू, दिनहरू र वर्षहरू जनाउने चिन्हहरू होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","अनि पृथ्वीमा प्रकाश दिनलाई आकाशमाथि ज्योतिहरू चम्कून्।” तब त्यस्तै भइहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","परमेश्‍वरले दुई वटा ठूला ज्योतिहरू बनाउनुभयो—ठूलो ज्योति दिनमा प्रभुत्व गर्नलाई र सानो ज्योति रातमा प्रभुत्व गर्नलाई। उहाँले ताराहरू पनि बनाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","परमेश्‍वरले तिनीहरूलाई आकाशको अन्तरमा पृथ्वीमा उज्यालो दिन; ");
INSERT INTO npioncb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","अनि दिन र रातमा प्रभुत्व गर्न; अनि उज्यालो र अँध्यारोलाई अलग-अलग गर्नलाई राख्नुभयो। अनि परमेश्‍वरले देख्नुभयो, त्यो असल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","अनि साँझ पर्‍यो र बिहान भयो—चौथो दिन। ");
INSERT INTO npioncb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","फेरि परमेश्‍वरले आज्ञा गर्नुभयो, “पानी जीवित प्राणीहरूले भरियोस् र पृथ्वीमाथि आकाशको अन्तरमा चाहिँ चराहरू उडून्।” ");
INSERT INTO npioncb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","यसरी परमेश्‍वरले समुद्रका आ-आफ्नै प्रकारका विशाल जलजन्तु र पानीमा झुण्ड-झुण्ड बनाएर पौडने तिनीहरूका आ-आफ्नै प्रकारका जीवित प्राणीहरू, र सबै पखेटा भएका चराहरूलाई आ-आफ्नै किसिमको गरी सृष्‍टि गर्नुभयो। अनि परमेश्‍वरले देख्नुभयो, त्यो असल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्‍वरले तिनीहरू सबैलाई आशिष् दिनुभयो र आज्ञा गर्नुभयो, “फल्दै-फुल्दै अनि संख्यामा वृद्धि हुँदै समुद्रको पानीमा भरिँदै जाओ र चराहरू पृथ्वीमा वृद्धि हुँदै जाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","तब साँझ पर्‍यो र बिहान भयो—पाँचौँ दिन। ");
INSERT INTO npioncb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","फेरि परमेश्‍वरले आज्ञा गर्नुभयो, “पृथ्वीले विभिन्‍न जातका जीवित प्राणीहरू, अर्थात् प्रत्येकका आ-आफ्नै किसिमअनुसार: घरपालुवा जनावरहरू, जमिनमा हलचल गर्ने प्राणीहरू र जङ्गली जनावरहरू उत्पन्‍न गरोस्।” तब त्यस्तै भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","परमेश्‍वरले जङ्गली जनावरहरू, घरपालुवा जनावरहरू र जमिनमा घस्रने सबै प्राणीहरूलाई तिनीहरूका आ-आफ्नै किसिमले बनाउनुभयो। अनि परमेश्‍वरले देख्नुभयो, त्यो असल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","तब परमेश्‍वरले आज्ञा गर्नुभयो, “हामी मानिस जातिलाई हाम्रै स्वरूपमा, हामीजस्तै बनाऔँ। तिनीहरूले समुद्रका माछा, आकाशका चराहरू, घरपालुवा जनावर, सबै जङ्गली पशु, र पृथ्वीमा चलहल गर्ने सबै प्राणीहरूमाथि शासन गरून्।” ");
INSERT INTO npioncb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","यसकारण परमेश्‍वरले मानिस जातिलाई उहाँको आफ्नै स्वरूपमा सृष्‍टि गर्नुभयो, परमेश्‍वरको स्वरूपमा उहाँले तिनीहरूलाई सृष्‍टि गर्नुभयो; पुरुष र स्त्री गरेर उहाँले तिनीहरूलाई सृष्‍टि गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्‍वरले तिनीहरूलाई आशिष् दिनुभयो, र आज्ञा गर्नुभयो, “फल्दै-फुल्दै, वृद्धि हुँदै पृथ्वीमा भरिँदै र त्यसलाई आफ्नो वशमा पार्दैजाओ। समुद्रका माछा, आकाशका चराहरू र जमिनमा हलचल गर्ने प्रत्येक प्राणीहरूमाथि शासन गर।” ");
INSERT INTO npioncb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","तब परमेश्‍वरले तिनीहरूलाई भन्‍नुभयो, “हेर, म तिमीहरूलाई सम्पूर्ण पृथ्वीमा प्रत्येक बिउ भएका बिरुवा र फलमा बिउ भएका प्रत्येक रूख दिन्छु। ती तिमीहरूका भोजनका निम्ति हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","तर पृथ्वीमा भएका सबै पशुहरू र आकाशमा भएका सबै चराहरू र जमिनमा चलहल गर्ने सबै प्राणीहरू—जीवनको सास भएका प्रत्येकका निम्ति—म आहाराको लागि हरियो वनस्पति दिन्छु;” तब त्यस्तै भइहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","आफूले बनाउनुभएका सबै कुरा परमेश्‍वरले हेर्नुभयो र ती अति असल थिए। तब साँझ पर्‍यो र बिहान भयो—छैटौँ दिन। ");
INSERT INTO npioncb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","यसरी आकाशमण्डल, पृथ्वी र तिनमा भएका सबै कुरा बनाइसकिए। ");
INSERT INTO npioncb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","परमेश्‍वरले सातौँ दिन हुँदासम्म आफूले गरिरहनुभएका काम सक्नुभयो; अनि सातौँ दिनमा उहाँले आफ्ना सबै कामबाट विश्राम लिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","अनि परमेश्‍वरले सातौँ दिनलाई आशिष् दिनुभयो र त्यसलाई पवित्र तुल्याउनुभयो; किनकि यही दिन नै उहाँले सृष्‍टि गर्नुभएका सम्पूर्ण कामबाट विश्राम लिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","याहवेह परमेश्‍वरले सृष्‍टि गर्नुभएको आकाशमण्डल र पृथ्वीको विवरण यही नै हो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","जब याहवेह परमेश्‍वरले आकाशमण्डल र पृथ्वी सृष्‍टि गर्नुभयो, त्यस बेला पृथ्वीमा कुनै वनस्पति र कुनै बोटबिरुवा देखा परेका थिएनन्; किनकि याहवेह परमेश्‍वरले पृथ्वीमा पानी पठाउनुभएको थिएन र जमिनमा काम गर्ने कुनै मानिस थिएन। ");
INSERT INTO npioncb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","तर पृथ्वीबाट खोलाहरू निस्केर जमिनको सम्पूर्ण बाहिरी भागलाई भिजाउँथ्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","याहवेह परमेश्‍वरले मानिसलाई जमिनको माटोबाट बनाउनुभयो; अनि तिनको नाकमा जीवनको सास फुकिदिनुभयो। यसरी मानिस जीवित प्राणी बन्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","याहवेह परमेश्‍वरले पूर्वपट्टि भएको अदनमा एउटा बगैँचा लगाउनुभएको थियो; अनि आफूले बनाउनुभएको मानिसलाई उहाँले त्यहाँ राख्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","अनि याहवेह परमेश्‍वरले भूमिबाट सबै किसिमका रूखहरू, अर्थात् हेर्नमा राम्रो र खानलाई असल रूखहरू उमार्नुभयो। अनि बगैँचाको बीचमा जीवनको रूख, साथै असल र खराबको ज्ञान दिने रूख पनि लगाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बगैँचालाई भिजाउनका निम्ति एउटा नदी अदनबाट बहन्थ्यो; त्यो त्यहाँबाट छुट्टिएर चार वटा शाखामा बाँडिएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","पहिलो नदीको नाम पीशोन हो, जो हवीलाको समस्त मुलुक हुँदै बग्दछ, जहाँ सुन पाइन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(त्यस देशको सुन असल हुन्छ। त्यहाँ बास्‍ना आउने खोटो र गोमेद पनि पाइन्छन्।) ");
INSERT INTO npioncb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दोस्रो नदीको नाम गीहोन हो, जो कूशको समस्त मुलुक भएर बग्दछ। ");
INSERT INTO npioncb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तेस्रो नदीको नाम टाइग्रिस हो, जो अश्शूरको पूर्वतिर हुँदै बग्दछ; अनि चौथो नदीचाहिँ यूफ्रेटिस हो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","याहवेह परमेश्‍वरले मानिसलाई लगेर अदनको बगैँचामा काम गर्न र त्यसको हेरचाह गर्नका निम्ति त्यहाँ राख्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","अनि याहवेह परमेश्‍वरले मानिसलाई यसो भनेर आज्ञा दिनुभयो, “यस बगैँचामा भएका कुनै पनि रूखहरूबाट खान तँ स्वतन्त्र छस्; ");
INSERT INTO npioncb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","तर असल र खराबको ज्ञान दिने रूखको फलचाहिँ तैँले खाँदै नखानू! किनकि जुन दिन तैँले त्यो फल खान्छस्, तँ निश्‍चय नै मर्नेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","याहवेह परमेश्‍वरले भन्‍नुभयो, “मानिस एकलो रहन असल छैन। म त्यसको निम्ति एउटा सुहाउँदो सहयोगी बनाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","याहवेह परमेश्‍वरले भूमिबाट सबै जङ्गली जनावर र आकाशका पक्षीहरूलाई बनाउनुभएको थियो। मानिसले तिनीहरूका के-के नाम राख्दो रहेछ भनी हेर्न तिनीहरूलाई तिनीकहाँ ल्याउनुभयो; अनि मानिसले हरेक प्राणीलाई जे-जे भनेर बोलाए, त्यही नै तिनीहरूका नाम रह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","यसरी मानिसले सबै घरपालुवा जनावरहरू, आकाशका पक्षीहरू र सबै जङ्गली जनावरहरूका नाम राखे। तर आदमको लागि कुनै सुहाउँदो सहयोगी पाइएन। ");
INSERT INTO npioncb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","यसकारण याहवेह परमेश्‍वरले मानिसलाई गहिरो निद्रामा पार्नुभयो। जब तिनी निदाइरहेका थिए, तब उहाँले तिनका करङहरूमध्ये एउटा निकालेर त्यस ठाउँलाई मासुले भरिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","अनि याहवेह परमेश्‍वरले मानिसबाट जुन करङ निकाल्नुभएको थियो, त्यही करङबाट एउटी स्त्री बनाउनुभयो र तिनलाई मानिसकहाँ ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","अनि मानिसले भने, “अब यो त मेरै हाडहरूका हाड र मासुको मासु हो; तिनलाई ‘स्त्री’ भनिनेछ, किनकि तिनी मानिसबाट निकालिएकी हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","यसैकारण मानिसले आफ्ना बुबा र आमालाई छोड्छ र आफ्नी पत्नीसित मिलिबस्छ, अनि तिनीहरू एउटै शरीर हुन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","मानिस र तिनकी पत्नी दुवै नाङ्गा थिए, तर तिनीहरू लाज मान्दैनथे। ");
INSERT INTO npioncb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","अब याहवेह परमेश्‍वरले बनाउनुभएका सबै जङ्गली पशुहरूमध्ये सर्प सबैभन्दा बढी धूर्त थियो। त्यसले स्त्रीलाई भन्यो, “के याहवेह परमेश्‍वरले ‘यस बगैँचाको कुनै पनि रूखका फल तिमीहरूले नखानू’ भनी साँच्‍चै भन्‍नुभएको हो?” ");
INSERT INTO npioncb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","तब स्त्रीले सर्पलाई भनिन्, “बगैँचामा भएका रूखहरूका फल हामी खान सक्छौँ, ");
INSERT INTO npioncb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","तर परमेश्‍वरले यो पनि भन्‍नुभएको छ, ‘तिमीहरूले बगैँचाको बीचमा भएको रूखको फल खाँदै नखानू, र तिमीहरूले त्यो नछुनू; नत्रता तिमीहरू मर्नेछौ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तब सर्पले स्त्रीलाई भन्यो, “तिमीहरू कदापि मर्नेछैनौ!” ");
INSERT INTO npioncb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“किनकि परमेश्‍वर जान्‍नुहुन्छ कि जब तिमीहरूले यो खान्छौ, तिमीहरूका आँखा खुल्नेछन्; अनि असल र खराब थाहा पाएर तिमीहरू पनि परमेश्‍वरजस्तै हुनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","जब स्त्रीले त्यस रूखको फल खानका निम्ति असल, हेर्नमा रहरलाग्दो र बुद्धि प्राप्‍त गर्न चाह गर्नुपर्ने रहेछ भनी देखिन्, तब तिनले केही फल टिपेर खाइन्। तब तिनले आफ्ना पतिलाई पनि दिइन्; जो तिनीसँगै थिए, र तिनले पनि खाए। ");
INSERT INTO npioncb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब ती दुवैका आँखा खुले, र आफू नाङ्गा भएका तिनीहरूले थाहा पाए। यसकारण तिनीहरूले ढाक्नका लागि नेभाराका पातहरू गाँसेर आफ्ना निम्ति वस्त्र बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","जब याहवेह परमेश्‍वर दिनको शीतल समयमा बगैँचामा हिँड्दैहुनुहुन्थ्यो, तब मानिस र तिनकी पत्नीले उहाँको सोर सुने, र तिनीहरू याहवेह परमेश्‍वरदेखि बगैँचाका रूखहरूका बीचमा लुके। ");
INSERT INTO npioncb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","तर याहवेह परमेश्‍वरले मानिसलाई, “तँ कहाँ छस्?” भनी बोलाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","तिनले जवाफ दिए, “मैले बगैँचामा तपाईंको सोर सुनेँ, र मलाई डर लाग्यो, किनकि म नाङ्गो थिएँ; त्यसैले म लुकेँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","अनि उहाँले भन्‍नुभयो, “तँ नाङ्गै छस् भनी कसले भन्यो? मैले नखानू भनी आदेश दिएको त्यस रूखबाट तैँले खाइस्?” ");
INSERT INTO npioncb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","आदमले भने, “तपाईंले मसँगै रहन भनी दिनुभएको स्त्रीले त्यस रूखबाट मलाई केही फल दिई, र मैले खाएँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तब याहवेह परमेश्‍वरले स्त्रीलाई भन्‍नुभयो, “तैँले यो के गरिस्?” त्यस स्त्रीले जवाफ दिई, “सर्पले मलाई छल गर्‍यो, र मैले खाएँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","यसकारण याहवेह परमेश्‍वरले सर्पलाई भन्‍नुभयो, “तैँले यसो गरेको कारण, “तँ सबै घरपालुवा जनावरहरू र सबै जङ्गली जनावरहरूमध्ये तैँले ज्यादा श्राप पाउनेछस्! तँ पेटको बलले घस्रनेछस्, तेरो सारा जीवनभरि, तैँले धुलो खानेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","अनि तेरो र स्त्रीको बीचमा, अनि तेरा र स्त्रीका सन्तानको बीचमा म दुश्मनी हालिदिनेछु। त्यसले तेरो शिर कुच्‍च्याउनेछ, अनि तैँले त्यसको कुर्कुच्‍चा डस्‍नेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","स्त्रीलाई उहाँले भन्‍नुभयो, “म तेरो गर्भावस्थाको पीडा ज्यादै बढाइदिनेछु; बडो कष्‍टसाथ तैँले सन्तान जन्माउनेछस्। तेरो चाहना तेरो पतितर्फ नै हुनेछ, र उसले तँमाथि अधिकार जमाउनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","आदमलाई उहाँले भन्‍नुभयो, “किनकि तैँले तेरी पत्नीको कुरा सुनेको र मैले तँलाई ‘खाँदै नखानू भनी आदेश दिएको रूखको फल खाएको हुनाले,’ “तेरो कारणले भूमिमा श्राप परेको छ; तेरो जीवनकालभरि तैँले कष्‍टसाथ परिश्रम गरेर त्यसको फल खानेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","भूमिले तेरा निम्ति काँडा र सिउँडी उमार्नेछ; अनि तैँले खेतबारीका सागपात खानेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","जबसम्म तँ माटोमा फर्किजाँदैनस्, तबसम्म तेरो निधारको पसिनाद्वारा तैँले आफ्नो भोजन खानेछस्; किनकि तँ धुलो होस्, र तँ धुलोमा नै फर्किजानेछस्; किनकि यसैबाट तँ बनाइएको थिइस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदमले आफ्नी पत्नीको नाम हव्वा राखे; किनकि तिनी नै सबै जीवितहरूकी आमा थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","याहवेह परमेश्‍वरले आदम र तिनकी पत्नीका निम्ति छालाको वस्त्र बनाएर पहिर्‍याइदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","अनि याहवेह परमेश्‍वरले भन्‍नुभयो, “मानिस अब हामीजस्तै असल र खराबको ज्ञान जान्‍ने भएको छ। अब उसो त्यसले आफ्नो हात बढाउन नपाओस् र जीवनको रूखबाट टिपेर पनि नखाओस्, र अनन्तसम्म बाँच्न नपाओस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","यसकारण जुन भूमिबाट तिनी बनाइएका थिए, त्यसैको खनजोत गरोस् भनेर याहवेह परमेश्‍वरले तिनलाई अदनको बगैँचाबाट निकालिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","उहाँले मानिसलाई धपाइदिनुभएपछि, अदनको बगैँचाको पूर्वपट्टि जीवनको रूखमा जाने बाटोको रक्षा गर्नलाई करूबहरू अनि चारैतिर चम्किरहने ज्वालामय तरवार राखिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आफ्नी पत्नी हव्वासित आदमको सहवास भयो; अनि तिनी गर्भवती भएर कयिनलाई जन्माइन्, र भनिन्, “याहवेहको सहायताले मैले एक जना पुरुषलाई जन्म दिएकी छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","त्यसपछि तिनले कयिनको भाइ हाबिललाई जन्माइन्। अब हाबिल भेडाबाख्राका गोठाला भए, र कयिनचाहिँ खेतको काम गर्ने भए। ");
INSERT INTO npioncb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","केही समय बितेपछि कयिनले याहवेहलाई भेटी चढाउन आफ्नो उब्जनीबाट केही ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","अनि हाबिलले पनि आफ्ना बगालका पहिले जन्मेका मोटा पाठाहरूबाट केही असल भागहरू ल्याए। याहवेहले हाबिल र तिनको भेटीलाई निगाहको दृष्‍टिले हेर्नुभयो; ");
INSERT INTO npioncb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","तर कयिनलाई र तिनको भेटीलाई चाहिँ निगाहको दृष्‍टिले हेर्नुभएन। यसकारण कयिन रिसले चुर भए, र तिनको मुख अँध्यारो भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","तब याहवेहले कयिनलाई भन्‍नुभयो, “तँ किन रिसाउँछस्? तेरो मुख किन अँध्यारो छ? ");
INSERT INTO npioncb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","तैँले जे ठिक छ, सो गरिस् भने के तँ स्वीकारयोग्य हुँदैनस् र? तर तैँले जे ठिक छ, सो गरिनस् भने पाप तेरो ढोकामा ढुकिबसेको छ; त्यसले तँलाई अधीनमा राख्न खोज्छ, तर तैँले त्यसलाई अधीन गर्नैपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","त्यसपछि कयिनले आफ्नो भाइ हाबिललाई भने, “आइज, हामी बाहिर खेतमा जाऔँ।” अनि जब तिनीहरू खेतमा थिए, तब कयिनले आफ्नो भाइ हाबिलमाथि आक्रमण गरे र तिनलाई मारे। ");
INSERT INTO npioncb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब याहवेहले कयिनलाई सोध्नुभयो, “तेरो भाइ हाबिल कहाँ छ?” तिनले जवाफ दिए, “म जान्दिनँ; के म मेरो भाइको गोठालो हुँ र?” ");
INSERT INTO npioncb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","याहवेहले भन्‍नुभयो, “तैँले यो के गरिस्? सुन! तेरो भाइको रगतको आवाजले भूमिबाट मलाई पुकार्दैछ। ");
INSERT INTO npioncb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","अब तँमाथि श्राप परेको छ, र भूमिबाट धपाइएको छस्, त्यस भूमिले तेरो हातबाट तेरो भाइको रगत लिनलाई आफ्नो मुख खोलेको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जब तैँले भूमिमा खनजोत गर्छस्, अब उसो त्यसले तेरा लागि अन्‍न उमार्नेछैन। तँ पृथ्वीमा एक बेचैन डुलुवा हुनेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","कयिनले याहवेहलाई भने, “मेरो दण्ड मैले सहनै नसक्ने भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","आज तपाईंले मलाई यस ठाउँबाट निकाल्नुहुँदैछ; अनि म तपाईंको उपस्थितिबाट लुकाइनेछु; यस पृथ्वीमा म बेचैन डुलुवा हुनेछु; अनि जसले मलाई भेट्टाउँछ, त्यसले मलाई मार्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","तर याहवेहले तिनलाई भन्‍नुभयो, “यस्तो हुनेछैन, यदि कसैले कयिनलाई मार्‍यो भने त्यसको सात गुणा बढ्ता त्यसले भोग्नेछ।” तब तिनलाई कसैले भेटेर नमारून् भनी याहवेहले कयिनलाई एउटा चिन्ह लगाइदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","यसरी कयिन याहवेहको उपस्थितिबाट गयो, र अदनको पूर्वपट्टिको नोद भन्‍ने ठाउँमा बस्‍न लाग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","आफ्नी पत्नीसित कयिनको सहवास भयो; अनि तिनी गर्भवती भएर हनोकलाई जन्माइन्। तब कयिनले एउटा सहर बनायो, र त्यस सहरको नाम आफ्नो छोराको नामअनुसार हनोक राख्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोकबाट इरादको जन्म भयो, र इरादचाहिँ महूयाएलका पिता भए, र महूयाएलचाहिँ मतूशाएलका पिता भए, र मतूशाएलचाहिँ लेमेकका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेकले दुईटी स्त्रीहरूसित विवाह गरे; एउटीको नाम आदा र अर्कीको नाम सिल्‍ला थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाले याबाललाई जन्माइन्; जोचाहिँ पालहरूमा बस्‍नेहरू र पशुपालन गर्नेहरूका पुर्खा थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","तिनको भाइको नाम यूबाल थियो; जोचाहिँ वीणा र बाँसुरी बजाउनेहरूका पुर्खा थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्‍लाको पनि एउटा तूबल-कयिन नामको छोरा भयो, जसले काँसो र फलामका सबै किसिमका औजार बनाउँथे। तूबल-कयिनकी बहिनी नामा थिईन्। ");
INSERT INTO npioncb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेकले आफ्ना पत्नीहरूलाई भने, “आदा र सिल्‍ला, मेरो कुरा सुन; लेमेककी पत्नी हो, मेरा वचनहरू सुन! मलाई घाइते बनाउने मानिसलाई मैले मारेको छु, मलाई चोट पुर्‍याउने जवान मानिसलाई मैले मारेको छु। ");
INSERT INTO npioncb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","यदि कयिनको साटो सात गुणा हो भने लेमेकको चाहिँ सतहत्तर गुणा हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदमको आफ्नी पत्नीसित फेरि सहवास भयो; अनि तिनले अर्को छोरो जन्माइन्, र त्यसको नाम यसो भन्दै शेत राखिन्, “कयिनले हाबिललाई मारेपछि परमेश्‍वरले मलाई त्यसको सट्टामा अर्को छोरो दिनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेतको पनि एउटा छोरा भयो; अनि तिनले त्यसको नाम एनोश राखे। त्यस बेलादेखि मानिसहरूले याहवेहको नाममा आराधना गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदमको वंशको विवरण यही हो: जब परमेश्‍वरले मानिस जातिलाई सृष्‍टि गर्नुभयो, तब उहाँले तिनलाई परमेश्‍वरको स्वरूपमा बनाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","उहाँले तिनीहरूलाई पुरुष र स्त्री बनाउनुभयो, र तिनीहरूलाई आशिष् दिनुभयो। तिनीहरूको सृष्‍टि हुँदा उहाँले तिनीहरूलाई “मानिस जाति” नाम दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदम 130 वर्षको हुँदा, तिनीजस्तै तिनको आफ्नै स्वरूपमा एउटा छोरा भयो, र तिनले त्यसको नाम शेत राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेतको जन्मपछि आदम 800 वर्षसम्म बाँचे; अनि तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","आदम जम्मा 930 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेतको उमेर 105 वर्षको हुँदा, तिनी एनोशका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","तिनी एनोशका पिता भएपछि शेत 807 वर्ष बाँचे; अनि तिनका अरू छोराछोरी पनि जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","शेत जम्मा 912 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","एनोशको उमेर 90 वर्षको हुँदा, तिनी केनानका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","अनि तिनी केनानका पिता भएपछि, एनोश 815 वर्ष बाँचे; अनि तिनका अरू छोराछोरी भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","एनोश जम्मा 905 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनानको उमेर 70 वर्षको हुँदा, तिनी महलालेलका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","अनि तिनी महलालेलका पिता भएपछि, केनान 840 वर्ष बाँचे; र तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","केनान जम्मा 910 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महलालेलको उमेर 65 वर्षको हुँदा, तिनी येरेदका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","अनि तिनी येरेदका पिता भएपछि, महलालेल 830 बाँचे; अनि तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","महलालेल जम्मा 895 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","येरेदको उमेर 162 वर्षको हुँदा, तिनी हनोकका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","अनि तिनी हनोकका पिता भएपछि येरेद 800 वर्ष बाँचे; अनि तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","येरेद जम्मा 962 वर्षसम्म बाँचे, र तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोकको उमेर 65 वर्षको हुँदा, तिनी मतूशेलहका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","अनि तिनी मतूशेलहका पिता भएपछि हनोक परमेश्‍वरसित 300 वर्ष विश्‍वासयोग्य भएर बाँचे; अनि तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","हनोक जम्मा 365 वर्षसम्म बाँचे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्‍वरसित विश्‍वासयोग्य भएर बाँचे। अनि तिनी अलप भए; किनकि परमेश्‍वरले तिनलाई उठाइलैजानुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मतूशेलहको उमेर 187 वर्षको हुँदा, तिनी लेमेकका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","अनि तिनी लेमेकका पिता भएपछि मतूशेलह 782 वर्ष बाँचे; अनि तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मतूशेलह जम्मा 969 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लेमेकको उमेर 182 वर्षको हुँदा, तिनको एउटा छोरा जन्मियो। ");
INSERT INTO npioncb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","अनि तिनले यसो भनेर त्यसको नाम नोआ राखे, “याहवेहले श्राप दिनुभएको भूमिमा हाम्रा हातले गरेको काम र कष्‍टदायक परिश्रममा यसले हामीलाई सान्त्वना दिनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नोआ जन्मेपछि लेमेक 595 वर्ष बाँचे; अनि तिनका अरू छोराछोरी जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लेमेक जम्मा 777 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोआ 500 वर्ष पुगेपछि तिनी शेम, हाम र येपेतका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","जब पृथ्वीमा मानिसहरूको संख्या बढ्न थाल्यो र तिनीहरूका छोरीहरू जन्मिए; ");
INSERT INTO npioncb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","तब परमेश्‍वरका छोराहरूले मानिसका छोरीहरूलाई राम्री देखे; र तिनीहरूले आ-आफूले चुनेकाहरूसित विवाह गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तब याहवेहले भन्‍नुभयो, “मेरो आत्माले सदाको निम्ति मानिससित विवाद गर्नेछैन; किनकि तिनीहरू मरणशील हुन्; त्यसको आयु एक सय बीस वर्ष हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ती दिनहरूमा पृथ्वीमा नेफिलीमहरू थिए; र त्यसपछि पनि, जब परमेश्‍वरका छोराहरू मानिसहरूका छोरीहरूकहाँ गए; अनि तिनीहरूबाट छोराछोरीहरू जन्मिए। तिनीहरू पुरानो समयका बलिया-बलिया र नाम चलेका पुरुषहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","याहवेहले पृथ्वीमा मानिसहरूको दुष्‍टता ज्यादा बढेको, र तिनीहरूको हृदयको विचार हरबखत दुष्‍टतातिर मात्रै ढल्केको देख्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","पृथ्वीमा मानिसलाई बनाउनुभएकोमा याहवेहले अफसोस गर्नुभयो; र उहाँको हृदय असाध्यै दुःखित भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","यसकारण याहवेहले भन्‍नुभयो, “मैले सृष्‍टि गरेको मानिस जातिलाई—अनि तिनीहरूसँगै जनावरहरू, र आकाशका चराहरू र जमिनमा घस्रने प्राणीहरू, सबैलाई पृथ्वीबाट म नामनिशानै मेटिदिनेछु—किनकि तिनीहरूलाई बनाएकोमा मलाई अफसोस लागेको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","तर नोआले चाहिँ याहवेहको दृष्‍टिमा अनुग्रह प्राप्‍त गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोआ र उनको परिवारको विवरण यही हो: नोआ एक धर्मी मानिस थिए। आफ्नो पुस्ताका मानिसहरूको बीचमा तिनी निर्दोष मानिस थिए। तिनी विश्‍वासयोग्ताका साथ परमेश्‍वरसँग रहन्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नोआका तीन छोराहरू थिए: शेम, हाम र येपेत। ");
INSERT INTO npioncb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","परमेश्‍वरको दृष्‍टिमा पृथ्वी भ्रष्‍ट भएको, र हिंसाले भरिएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","परमेश्‍वरले पृथ्वी अति भ्रष्‍ट भएको देख्नुभयो; किनकि पृथ्वीका सबै मानिसहरू आफ्ना चालहरूमा भ्रष्‍ट भएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","यसकारण परमेश्‍वरले नोआलाई भन्‍नुभयो, “म सबै मानिसहरूको अन्त्य गर्दैछु; किनकि तिनीहरूको कारण पृथ्वी हिंसाले भरिएको छ। म निश्‍चय नै तिनीहरू र पृथ्वीलाई नष्‍ट गर्दैछु। ");
INSERT INTO npioncb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","यसकारण तैँले आफ्नो निम्ति गोपेर काठको एउटा जहाज बनाउनू; अनि त्यसमा कोठाहरू बनाएर त्यसलाई भित्र र बाहिर अलकत्रले लिप्नू। ");
INSERT INTO npioncb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","तैँले त्यसलाई यसरी बनाउनू—त्यो जहाज तीन सय क्यूबिट लामो, पचास क्यूबिट चौडा र तीस क्यूबिट अल्गो होस्। ");
INSERT INTO npioncb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","त्यसको छानो बनाउनू र छानामुनि वरिपरि एक क्यूबिट खुल्‍ला छोड्नु। जहाजको एक छेउमा एउटा ढोका राख्नू र, तल्‍लो, बीचको र माथिल्‍लो तला भएको बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","म आकाशमुनि भएका सम्पूर्ण प्राणीहरू, जीवनको सास हुने प्रत्येक प्राणीलाई नाश गर्नका निम्ति पृथ्वीमा जलप्रलय ल्याउनेछु। पृथ्वीमा भएको प्रत्येक चीज नष्‍ट हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","तर तँसितचाहिँ म मेरो करार स्थापित गर्नेछु; अनि तँ जहाजभित्र पस्‍नेछस्—तँ र तेरा छोराहरू, तेरी पत्नी र तेरा बुहारीहरू पनि। ");
INSERT INTO npioncb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","तँसित जीवित रहनलाई आफूसितै भाले र पोथी गरेर सबै जीवित प्राणीहरूका एक-एक जोडीलाई जहाजभित्र लैजानू। ");
INSERT INTO npioncb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","हरेक प्रकारका चराचुरुङ्गी, हरेक प्रकारका जनावर, र जमिनमा चलहल गर्ने हरेक प्रकारको प्राणीको एक-एक जोडी गरी तँसित जीवित रहनलाई आउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","तैँले आफ्ना निम्ति र तिनीहरूका निम्ति हरेक प्रकारका खानेकुरा लैजा, र जम्मा पारिराख्।” ");
INSERT INTO npioncb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नोआले परमेश्‍वरले तिनलाई आज्ञा गर्नुभएअनुसार सबै गरे, हो, उनले त्यो गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","तब याहवेहले नोआलाई भन्‍नुभयो, “तँ र तेरा सम्पूर्ण परिवार जहाजभित्र जा; किनकि मैले तँलाई यस पुस्तामा धर्मी पाएको छु। ");
INSERT INTO npioncb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","तँसित हरेक प्रकारका शुद्ध पशुबाट भाले र पोथी गरेर सात जोडी, अशुद्ध पशुबाट भाले र पोथी गरेर एक जोडी लिनू; ");
INSERT INTO npioncb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अनि हरेक प्रकारका चराचुरुङ्गीबाट सात जोडी भाले र पोथी गरी लिनू, ताकि तिनीहरूका विभिन्‍न जातिहरू पृथ्वीभरि जीवित रहून्। ");
INSERT INTO npioncb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","अबको सात दिनमा म पृथ्वीमा चालीस दिन र चालीस रात पानी बर्साउनेछु; अनि म पृथ्वीबाट मैले बनाएको प्रत्येक जीवित प्राणीको नामनिशानै मेटिदिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","अनि नोआले याहवेहले तिनलाई आज्ञा गर्नुभएअनुसार सबै गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","पृथ्वीमा जलप्रलय हुँदा नोआ छ सय वर्षका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","अनि जलप्रलयको पानीबाट बाँच्नका निम्ति नोआ अनि तिनका छोराहरू, तिनकी पत्नी र तिनका बुहारीहरू जहाजभित्र पसे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","साथमा शुद्ध र अशुद्ध पशुहरू, चराचुरुङ्गी अनि जमिनमा चलहल गर्ने सबै प्राणीहरूका जोडीहरू, ");
INSERT INTO npioncb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","अर्थात् भाले र पोथी गरी परमेश्‍वरले आज्ञा गर्नुभएझैँ नोआसँगै जहाजभित्र पसे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","अनि सात दिनपछि पृथ्वीमा जलप्रलय भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोआको जीवनको छ सय वर्षको दोस्रो महिनाको सत्रौँ दिनमा पृथ्वीका सबै गहिरा मूलहरू फुटे, र आकाशका पानीका बाँधहरू खोलिए। ");
INSERT INTO npioncb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","अनि पृथ्वीमा चालीस दिन र चालीस रात पानी परिरह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","त्यसै दिन नोआ र तिनका छोराहरू शेम, हाम अनि येपेत, तिनकी पत्नी र तिनका तीन बुहारीहरू जहाजभित्र पसे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","तिनीहरूसित आ-आफ्नै प्रकारका प्रत्येक जङ्गली जनावर, आ-आफ्नै प्रकारका सबै घरपालुवा पशु, आ-आफ्नै प्रकारका जमिनमा घस्रने प्राणी र पखेटा भएका आ-आफ्नै प्रकारका पक्षी थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","जीवनको सास हुने सबै प्राणीहरूका जोडी-जोडी गरी नोआकहाँ जहाजमा आए। ");
INSERT INTO npioncb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","भित्र पसेका प्राणीहरूमध्ये परमेश्‍वरले नोआलाई आज्ञा गर्नुभएअनुसार प्रत्येक जीवित प्राणीका भाले र पोथी थिए। तिनीहरू भित्र पसेपछि याहवेहले ढोका थुनिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","चालीस दिनसम्म पृथ्वीमा जलप्रलय भइरह्‍यो; अनि जब पानी बढ्दैगयो, तब त्यसले जहाजलाई पृथ्वीमाथि उचाल्दै लग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानी बढ्दै गएर पृथ्वी भरिन थाल्यो, र जहाजचाहिँ पानीको सतहमाथि तैरिन थाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पृथ्वीमा पानी झन्-झन् बढ्दैगयो, र आकाशमुनि भएका सबै अग्ला-अग्ला पर्वतहरू डुबे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","पानी बढेर पर्वतहरूभन्दा 15 क्यूबिट माथिसम्म पुग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पृथ्वीमा चलहल गर्ने प्रत्येक जीवित प्राणी—चराचुरुङ्गी, घरपालुवा पशु, जङ्गली जनावर, पृथ्वीमा हुल बाँधेर हिँड्ने हरेक प्रकारका जीवजन्तुहरू र सारा मानिस जातिहरू नष्‍ट भए। ");
INSERT INTO npioncb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ओबानो भूमिमा भएका नाकमा जीवनको सास हुनेहरू सबै थोक नष्‍ट भए। ");
INSERT INTO npioncb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","पृथ्वीमा भएका प्रत्येक जीवित प्राणी; हरेक मानिस, पशु, जमिनमा चलहल गर्ने प्राणी र आकाशका चराहरू सबैको पृथ्वीबाट नामनिशानै मेटियो। नोआ र तिनीसित जहाजभित्र भएकाहरू मात्र जीवित रहे। ");
INSERT INTO npioncb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","पृथ्वी एक सय पचास दिनसम्म जलमग्न भइरह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","तर परमेश्‍वरले नोआ, तिनीसित जहाजभित्र भएका सबै जङ्गली जनावर र घरपालुवा जनावरहरूलाई सम्झनुभयो; त्यसपछि उहाँले पृथ्वीमाथि बतास चलाउनुभयो, र पानी घट्न थाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","अब गहिरा मूलहरू र आकाशका पानीका बाँधहरू बन्द भएका थिए, र आकाशबाट पानी पर्न रोकिएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पृथ्वीबाट पानी लगातार घट्दै जान थाल्यो। एक सय पचासौँ दिनपछि पानी कम भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","त्यसपछि सातौँ महिनाको सत्रौँ दिनमा जहाज अरारात पर्वतमा अडियो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","पानी दशौँ महिनासम्म लगातार घट्दै गयो; अनि दशौँ महिनाको पहिलो दिनमा पर्वतका टाकुराहरू देखिन थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","चालीस दिनपछि नोआले आफूले जहाजमा बनाएको झ्याल खोले; ");
INSERT INTO npioncb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","अनि एउटा कागलाई बाहिर पठाए; त्यो पृथ्वीबाट पानी नसुकेसम्म यताउता उडिरह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","त्यसपछि तिनले पृथ्वीको सतहमा पानी घट्यो कि घटेन भनेर बुझ्न एउटा ढुकुरलाई बाहिर पठाए। ");
INSERT INTO npioncb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","तर पृथ्वीको सतहमा पानी भएकोले त्यस ढुकुरले आफ्नो खुट्टा जमिनमा राख्ने ठाउँ नपाएर तिनीकहाँ जहाजमा नै फर्किआयो। नोआले आफ्नो हात बढाएर ढुकुरलाई पक्रेर जहाजमा आफूकहाँ ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","तिनले अरू सात दिन पर्खे; अनि त्यस ढुकुरलाई फेरि जहाजबाट बाहिर पठाए। ");
INSERT INTO npioncb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","बेलुका जब त्यो ढुकुर तिनी भएको ठाउँमा फर्किआयो; त्यसको चुच्‍चोमा भर्खरै टिपेको भद्राक्षको पात थियो! तब पृथ्वीबाट पानी घटेर गएछ भनी नोआले थाहा पाए। ");
INSERT INTO npioncb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","तिनले अझै अर्को सात दिन पर्खेर ढुकुरलाई फेरि बाहिर पठाए; तर यस पटक त्यो तिनीकहाँ फर्केर आएन। ");
INSERT INTO npioncb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोआको जीवनको छ सय एक वर्षको पहिलो महिनाको पहिलो दिनसम्ममा पृथ्वीबाट पानी सुकिसकेको थियो। तब नोआले जहाजको छाना उघारे, र पृथ्वीको सतह ओबानो भएको देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दोस्रो महिनाको सत्ताइसौँ दिनसम्ममा पृथ्वी पूरै ओबानो भएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेश्‍वरले नोआलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तँ र तेरी पत्नी, र तेरा छोराहरू र तिनीहरूका पत्नीहरूलाई लिएर जहाजबाट निस्की। ");
INSERT INTO npioncb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","तँसित भएका हरेक प्रकारका जीवित प्राणी, पक्षी, जनावर र जमिनमा चलहल गर्ने सबै प्राणीहरूलाई बाहिर निकाल् ताकि तिनीहरू पृथ्वीमा फैलिँदै फल्दै-फुल्दै र संख्यामा वृद्धि हुँदै जाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","यसकारण नोआ, तिनको साथमा छोराहरू, तिनकी पत्नी र बुहारीहरूसित बाहिर निस्केर आए। ");
INSERT INTO npioncb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","जमिनमा घस्रने सबै जनावर, सबै प्राणीहरू र सबै उड्ने पक्षी—पृथ्वीमा हलचल गर्ने सबै जीवहरू तिनीहरूका जोडीअनुसार एकपछि अर्को गर्दै जहाजबाट बाहिर निस्के। ");
INSERT INTO npioncb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","तब नोआले याहवेहको निम्ति एउटा वेदी बनाए, र शुद्ध पशुहरूबाट र शुद्ध पक्षीहरूबाट केही लिएर त्यस वेदीमाथि होमबलि चढाए। ");
INSERT INTO npioncb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","याहवेहले त्यो मिठो बास्‍ना लिनुभयो; अनि आफ्नो मनमनै भन्‍नुभयो: “बाल्यवस्थादेखि नै मानिसको हृदय दुष्‍टतातिर ढल्केको भए तापनि मानिसको कारणले गर्दा म धर्तीलाई अब फेरि कहिल्यै श्राप दिनेछैनँ। अनि जसरी अहिले मैले गरेको छु, अब फेरि सबै जीवित प्राणीलाई म कहिल्यै नाश गर्नेछैनँ। ");
INSERT INTO npioncb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“पृथ्वी रहेसम्म, बिउ छर्ने र कटनीको समय, जाडो र गर्मी, ग्रीष्म ऋतु र शिशिर ऋतु, दिन र रातको अन्त्य कहिल्यै हुनेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","तब परमेश्‍वरले यसो भन्दै नोआ र तिनका छोराहरूलाई आशिष् दिनुभयो, “फल्दै-फुल्दै, संख्यामा वृद्धि हुँदै र पृथ्वीमा भरिँदै जाओ। ");
INSERT INTO npioncb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्वीका सबै पशुहरू र आकाशका सबै चराचुरुङ्गीहरू, जमिनमा चलहल गर्ने प्रत्येक प्राणी, र समुद्रका सबै माछाहरूमाथि तिमीहरूको भय र त्रास रहनेछ; तिनीहरू तिमीहरूका हातमा सुम्पिएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","हरेक जीवित प्राणी तिमीहरूको भोजनको निम्ति हुनेछ। मैले तिमीहरूलाई हरियो सागपात दिएझैँ, अब तिमीहरूलाई सबै थोक दिन्छु। ");
INSERT INTO npioncb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“तर तिमीहरूले मासुसँग रगतचाहिँ नखानू, जसमा त्यसको जीवन हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","तिमीहरूका जीवन अर्थात् रगत लिनेको निश्‍चय नै म लेखा लिनेछु। म हरेक पशुबाट प्राणको लेखा लिनेछु; र हरेक मानिसबाट पनि, अरू मानिसका प्राणको लेखा म लिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“जसले मानिसको रक्तपात गर्छ, मानिसबाटै त्यसको पनि रक्तपात हुनेछ; किनकि परमेश्‍वरले मानिसलाई आफ्नै स्वरूपमा बनाउनुभएको हो। ");
INSERT INTO npioncb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","तर तिमीहरूचाहिँ फल्दै-फुल्दै र संख्यामा वृद्धि हुँदै जानू; र पृथ्वीमा फैलिँदै र यसमा बढ्दै जानू।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","तब परमेश्‍वरले नोआ र तिनीसँग भएका छोराहरूलाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“अब म तिमीहरूसँग र तिमीहरू पछिका सन्तानहरूसँग मेरो करार स्थापित गर्नेछु; ");
INSERT INTO npioncb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","अनि तिमीहरूसित भएको प्रत्येक जीवित प्राणीसित पनि—चाहे त्यो चराचुरुङ्गी होस्, चाहे घरपालुवा वा जङ्गली जनावर होस्; तिमीहरूसित जहाजबाट बाहिर निस्किआएका सबैसित—पृथ्वीका प्रत्येक जीवित प्राणीहरूसित। ");
INSERT INTO npioncb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","म तिमीहरूसित मेरो करार स्थापित गर्नेछु: अब उसो सबै जीवित थोकहरू जलप्रलयको पानीले नाश हुनेछैनन्; पृथ्वीलाई नष्‍ट पार्ने जलप्रलय फेरि हुनेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","अनि परमेश्‍वरले भन्‍नुभयो, “मैले तिमीहरू र तिमीहरूसित भएका प्रत्येक जीवित प्राणी र समस्त भावी पुस्ताहरूका निम्ति स्थापित गरेको करारको चिन्ह यही हो: ");
INSERT INTO npioncb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","म बादलमा मेरो इन्द्रेणी राख्दछु; अनि यही नै मेरो र पृथ्वीको बीचमा बाँधेको करारको चिन्ह हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","जब म पृथ्वीमाथि बादल फैलाउनेछु, अनि बादलमा इन्द्रेणी देखा पर्नेछ; ");
INSERT INTO npioncb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","तब मैले तिमीहरूसित र हरेक किसिमका जीवित प्राणीहरूसित बाँधेको मेरो करार सम्झनेछु। अब उसो सम्पूर्ण जीवित थोक नष्‍ट गर्ने पानीको जलप्रलय कहिल्यै हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","जब बादलमा इन्द्रेणी देखा पर्नेछ, तब परमेश्‍वर र पृथ्वीमा भएका हरेक किसिमका सबै जीवित प्राणीहरूसित गरिएको यो अनन्तको करारलाई म सम्झनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","यसरी परमेश्‍वरले नोआलाई भन्‍नुभयो, “मैले म र पृथ्वीमा भएका सबै जीवितहरूबीच स्थापित गरेको करारको चिन्ह यही नै हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","जहाज बाहिर निस्केर आउने नोआका छोराहरू शेम, हाम र येपेत थिए। (हामचाहिँ कनानका पिता थिए।) ");
INSERT INTO npioncb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नोआका तीन छोराहरू यिनै थिए; अनि यिनीहरूबाट आएका मानिसहरूले नै समस्त पृथ्वी भरियो। ");
INSERT INTO npioncb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोआले खेतीपाती गर्न थाले, उनले एउटा दाखबारी लगाए। ");
INSERT INTO npioncb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","जब तिनले दाखमद्यबाट पिए, तब तिनी मात्तिए, र आफ्नो पालभित्र नाङ्गै सुते। ");
INSERT INTO npioncb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनानका पिता हामले आफ्ना पिताको नग्नता देखे, र बाहिर भएका आफ्ना दुई दाजुभाइलाई बताए। ");
INSERT INTO npioncb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तर शेम र येपेतले आफ्ना काँधमा एउटा लुगा लिए, र पछिल्तिरबाट सर्दै गई आफ्ना पिताको नग्नतालाई ढाकिदिए। तिनीहरूका अनुहार अर्कोपट्टि फर्केका हुनाले तिनीहरूले आफ्ना पिताको नग्नता देखेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नोआको मद्यबाट होश खुल्यो, र तिनले आफ्नो कान्छा छोराले तिनलाई के गरेका थिए, त्यो थाहा पाए; ");
INSERT INTO npioncb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","तब तिनले भने, “कनान श्रापित होस्! त्यो आफ्ना दाजुभाइहरू बीचमा सबैभन्दा तुच्छ दास होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","तिनले यो पनि भने, “शेमका याहवेह परमेश्‍वर धन्यका होऊन्; कनानचाहिँ शेमको कमारा होस्! ");
INSERT INTO npioncb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्‍वरले येपेतको क्षेत्र बढाऊन्; येपेत शेमका पालहरूमा बास गरोस्; अनि कनानचाहिँ येपेतको कमारो होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","जलप्रलयपछि नोआ 350 वर्ष बाँचे। ");
INSERT INTO npioncb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","नोआ जम्मा 950 वर्षसम्म बाँचे; अनि तिनी मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नोआका छोराहरू शेम, हाम र येपेतको विवरण यही हो। जलप्रलयपछि तिनीहरूका आफ्नै छोराहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेतका छोराहरू: गोमेर, मागोग, मादी, यावान, तूबल, मेशेक र तीरास। ");
INSERT INTO npioncb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेरका छोराहरू: अश्कनज, रिपत र तोगर्मा। ");
INSERT INTO npioncb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावानका छोराहरू: एलीशा, तर्शीश, कित्तीम र रोदानीम। ");
INSERT INTO npioncb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(यिनीहरूबाट नै समुद्री तटबासीहरू; तिनीहरूका आ-आफ्नै कुल र प्रत्येकको आफ्नै भाषाअनुसार तिनीहरूका राष्ट्रभित्र विभिन्‍न क्षेत्रहरूमा फैलिए।) ");
INSERT INTO npioncb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामका छोराहरू: कूश, इजिप्ट, पूत र कनान। ");
INSERT INTO npioncb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूशका छोराहरू: सेबा, हवीला, सब्ता, रामाह र सब्तेका। रामाहका छोराहरू: शेबा र ददान। ");
INSERT INTO npioncb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूश निम्रोदका पिता थिए; जो पृथ्वीमा एक शक्तिशाली योद्धा बने। ");
INSERT INTO npioncb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","तिनी याहवेहको सामु एक शक्तिशाली शिकारी थिए; त्यसैकारण यसो भन्‍ने चलन छ, “याहवेहको सामु निम्रोदझैँ, एक शक्तिशाली शिकारी।” ");
INSERT INTO npioncb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","तिनको राज्यका प्रथम केन्द्रहरू बेबिलोन, एरेक, अक्‍काद र कल्नेह हुन्, जुन शिनार देशमा छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","त्यस देशबाट तिनले आफ्नो क्षेत्रफल अश्शूरतिर फैलाए, जहाँ तिनले निनवे, रहोबोत-इर, कालह सहरहरू ");
INSERT INTO npioncb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","अनि निनवे र कालहको बीचमा ठूलो सहर रेसेन बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","इजिप्टचाहिँ यिनीहरूका पिता थिए: लूदीमहरू, अनामीहरू, लहाबीहरू, नप्‍तूहीहरू, ");
INSERT INTO npioncb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पत्रुसीहरू, कस्लूहीहरू (जसबाट पलिश्तीहरू आए), र कप्‍तोरीहरू। ");
INSERT INTO npioncb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनानचाहिँ यिनीहरूका पिता थिए: आफ्ना जेठा छोरा सीदोन र हित्ती, ");
INSERT INTO npioncb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO npioncb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, अरकी, सिनी, ");
INSERT INTO npioncb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, सेमारी र हमातीहरू। पछि कनानीहरूका कुलहरू फैलिए, ");
INSERT INTO npioncb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","अनि कनानीहरूका सिमानाहरू सीदोनदेखि गरारतिर गाजासम्म पुग्यो, अनि त्यहाँबाट सदोम, गमोरा, अदमा, सबोयीम भएर लासासम्म थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","तिनीहरूका कुल र भाषाअनुसार आ-आफ्ना क्षेत्र र राष्ट्रहरूमा रहेका हामका छोराहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेमका छोराहरू जन्मिए, र शेमचाहिँ येपेतका भाइ थिए; शेम नै एबेरका सबै सन्तानका पुर्खा थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेमका छोराहरू: एलाम, अश्शूर, अर्पक्षद, लूद र अराम। ");
INSERT INTO npioncb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अरामका छोराहरू: ऊज, हूल, गेतेर र मेशेक। ");
INSERT INTO npioncb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षद शेलहका पिता थिए, अनि शेलहचाहिँ एबेरका पिता थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेरका दुई छोराहरू जन्मिए: एउटाको नाम पेलेग राखियो; किनकि पृथ्वी तिनकै पालोमा विभाजन भएको थियो। तिनको भाइको नाम योक्तान राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्तान यिनीहरूका पिता थिए: अल्मोदद, शेलेप, हसर्मवेत, येरह, ");
INSERT INTO npioncb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्ला, ");
INSERT INTO npioncb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबीमाएल, शेबा, ");
INSERT INTO npioncb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला र योबाब। यी सबै योक्तानका छोराहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(तिनीहरू बसेको ठाउँ मेशादेखि पूर्वीय पहाडी देशको सपारासम्म फैलिएको थियो।) ");
INSERT INTO npioncb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","तिनीहरूका कुल र भाषाअनुसार आ-आफ्ना क्षेत्र र राष्ट्रहरूमा रहेका शेमका छोराहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","तिनीहरूका आफ्ना राष्ट्रभित्र, तिनीहरूका वंशका घरानाअनुसार नोआका छोराहरूका कुलहरू यिनै हुन्। जलप्रलयपछि पृथ्वीमा यिनीहरूबाट नै विभिन्‍न जातिहरू फैलिँदै गए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","त्यस बेला सारा संसारभरि एउटै भाषा र एकै खालको बोली थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","मानिसहरू जब पूर्वतिर सर्दै गए, तिनीहरूले शिनार देशमा एउटा समथल भूमि भेट्टाए; र त्यहीँ बसोबास गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तिनीहरूले आपसमा भने, “आओ, हामी इँटा बनाऔँ र त्यसलाई पोलेर कडा बनाऔँ।” तिनीहरूले ढुङ्गाको सट्टामा इँटा र मसलाको रूपमा अलकत्रा प्रयोग गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","त्यसपछि तिनीहरूले भने, “आओ, हामी आफ्ना निम्ति एउटा सहर बनाऔँ, र स्वर्गसम्म पुग्ने एउटा धरहरा बनाऔँ; अनि आफ्नो नाम राखौँ, नत्रता हामी सारा पृथ्वीभरि छरपस्ट हुनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","तब मानिसहरूले बनाउँदै गरेका सहर र त्यस धरहरा हेर्न भनी याहवेह तल ओर्लनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","त्यसपछि याहवेहले भन्‍नुभयो, “यी मानिसहरूको बोल्ने एउटै भाषा भएको कारण तिनीहरूले यो काम गर्न थालेका छन्; अब तिनीहरूले जे गर्नका निम्ति योजना बनाएका छन्, तिनीहरूका निम्ति केही पनि असम्भव हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","आओ, हामी तल जाऔँ, र तिनीहरूको भाषा खलबल पारिदिऔँ, ताकि तिनीहरूले एक-अर्काको बोली नबुझून्।” ");
INSERT INTO npioncb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","यसरी याहवेहले तिनीहरूलाई त्यहाँबाट सारा पृथ्वीभरि छरपस्ट पारिदिनुभयो; अनि तिनीहरूले त्यो सहर बनाउने काम अधुरै छोडे। ");
INSERT INTO npioncb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","त्यसकारण त्यस सहरलाई बाबेल भनिन्छ—किनकि यहीँ नै याहवेहले पृथ्वीका सारा मानिसहरूको भाषा खलबल पारिदिनुभएको थियो। तब त्यहाँबाटै याहवेहले तिनीहरूलाई सारा पृथ्वीभरि तितरबितर पारिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेमका वंशको विवरण यही हो: जलप्रलयको दुई वर्षपछि जब शेम 100 वर्ष पुगे, तब तिनी अर्पक्षदका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अनि तिनी अर्पक्षदका पिता भएपछि, शेम 500 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अर्पक्षद 35 वर्ष पुगे, तिनी शेलहका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","अनि तिनी शेलहका पिता भएपछि, अर्पक्षद 403 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू जन्मिए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","जब शेलह 30 वर्ष पुगे, तिनी एबेरका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","अनि तिनी एबेरका पिता भएपछि शेलह 403 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","जब एबेर 34 वर्ष पुगे, तिनी पेलेगका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","अनि तिनी पेलेगका पिता भएपछि एबेर 430 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","जब पेलेग 30 वर्ष पुगे, तिनी रऊका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","अनि तिनी रऊका पिता भएपछि, पेलेग 209 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","जब रऊ 32 वर्ष पुगे, तिनी सरूगका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","अनि तिनी सरूगका पिता भएपछि रऊ 207 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","जब सरूग 30 वर्ष पुगे, तिनी नाहोरका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","अनि तिनी नाहोरका पिता भएपछि सरूग 200 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","जब नाहोर 29 वर्ष पुगे, तिनी तेरहका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","अनि तिनी तेरहका पिता भएपछि नाहोर 119 वर्ष बाँचे; र तिनका अरू छोराछोरीहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","जब तेरह 70 वर्ष पुगे, तिनी अब्राम, नाहोर र हारानका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहका वंशको विवरण यही हो: तेरहचाहिँ अब्राम, नाहोर र हारानका पिता भए; अनि हारान लोतका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","आफ्ना पिता तेरह जीवित छँदै हारान आफू जन्मेको ठाउँ कल्दीहरूको ऊरमा मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम र नाहोर दुवैले विवाह गरे। अब्रामकी पत्नीको नाम साराई थियो; अनि नाहोरकी पत्नीको नाम मिल्का थियो; यिनीचाहिँ हारानकी छोरी थिइन्, जो मिल्का र यिस्का दुवैका पिता थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","अब साराईचाहिँ बाँझी थिइन्; अनि तिनको कुनै सन्तान थिएन। ");
INSERT INTO npioncb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरहले अब्राम, आफ्नो नाति हारानको छोरा लोत र आफ्नी बुहारी साराई, अर्थात् आफ्नो छोरा अब्रामकी पत्नीलाई साथमा लिए; र कनान देशमा जानका निम्ति कल्दीहरूको ऊरबाट निस्के। तर हारानमा आइपुगेपछि तिनीहरू त्यहीँ बसोबास गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह 205 वर्ष बाँचे; अनि तिनी हारानमै मरे। ");
INSERT INTO npioncb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","याहवेहले अब्रामलाई भन्‍नुभयो, “आफ्नो देश, आफ्नो कुटुम्ब र तेरा पिताका घरानालाई छोडिदे; अनि त्यस देशमा जा, जुन म तँलाई देखाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“म तँलाई एउटा महान् जाति बनाउनेछु; अनि म तँलाई आशिष् दिनेछु; तेरो नामलाई महान् तुल्याउनेछु; अनि तँ आशिष्‌को मूल बन्‍नेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","तँलाई आशिष् दिनेहरूलाई म आशिष् दिनेछु; अनि तँलाई श्राप दिनेलाई म श्राप दिनेछु; अनि पृथ्वीका सबै जातिहरूले तँद्वारा नै आशिष् पाउनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","यसकारण याहवेहले अब्रामलाई भन्‍नुभएझैँ तिनी गए; अनि लोत पनि तिनको साथमा गए। अब्राम हारानबाट निस्कँदा पचहत्तर वर्षका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्रामले आफ्नी पत्नी साराई, आफ्नो भतिजो लोत, र तिनीहरूले जम्मा गरेका सबै धनसम्पत्ति र हारानमा प्राप्‍त गरेका मानिसहरूलाई लिए; अनि तिनीहरू सबै कनान देशतिर लागे; अनि तिनीहरू त्यहाँ आइपुगे। ");
INSERT INTO npioncb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम त्यस देशबाट यात्रा गर्दै मोरेको फलाँटको ठूला रूखहरू भएको ठाउँ शेकेमसम्म आइपुगे। त्यस बेला त्यस देशमा कनानीहरू बस्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","तब याहवेह अब्रामकहाँ देखा पर्नुभयो, र तिनलाई भन्‍नुभयो, “यो देश म तेरा सन्तानहरूलाई दिनेछु।” यसकारण तिनले आफूकहाँ देखा पर्नुभएको याहवेहका निम्ति त्यहाँ एउटा वेदी बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","त्यसपछि तिनी त्यहाँबाट बेथेलको पूर्वपट्टिका पहाडहरूतिर गए, र बेथेललाई पश्‍चिम र ऐ सहरलाई पूर्वपट्टि पारेर तिनले आफ्नो पाल टाँगे। त्यहाँ तिनले याहवेहका निम्ति एउटा वेदी बनाए, र याहवेहको नामलाई पुकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","तब अब्राम लगातार यात्रा गर्दै दक्षिणतिर लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","तब त्यस देशमा अनिकाल पर्‍यो; अनिकाल विकराल भएकोले अब्राम केही समयको लागि इजिप्टमा बसोबास गर्न गए। ");
INSERT INTO npioncb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","तिनी जब इजिप्टमा प्रवेश गर्न लागेका थिए, तब तिनले आफ्नी पत्नी साराईलाई भने, “तिमी कति सुन्दरी स्त्री छ्यौ भनी म जान्दछु। ");
INSERT INTO npioncb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","जब इजिप्टियनहरूले तिमीलाई देख्नेछन्, तब तिनीहरूले भन्‍नेछन्, ‘यिनी त त्यसकी पत्नी रहिछिन्।’ तब तिनीहरूले मलाई मार्नेछन्, तर तिमीलाई चाहिँ जीवितै छाड्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","तिमीले तिमी मेरी बहिनी हौ भनी भनिदेऊ; र तिम्रो खातिर मेरो भलाइ हुनेछ, र तिम्रो कारणले गर्दा मेरो जीवन बाँच्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","जब अब्राम इजिप्टमा आए, तब इजिप्टियनहरूले साराईलाई एउटी अति सुन्दरी स्त्री रहेछिन् भनी देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","अनि जब फारोका अधिकारीहरूले तिनलाई देखे, तब तिनीहरूले फारोको सामु तिनको रूपको प्रशंसा गरे; त्यसकारण साराईलाई फारोको महलमा लगियो। ");
INSERT INTO npioncb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","साराईको खातिर फारोले अब्रामसित असल व्यवहार गरे; अनि तिनले अब्रामलाई भेडाबाख्रा, गाईबस्तु, गधा, सेवक-सेविका र ऊँटहरू दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","तर याहवेहले अब्रामकी पत्नी साराईको कारण फारो र तिनको परिवारमा भयानक महामारीहरू पठाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","यसकारण फारोले अब्रामलाई बोलाएर भने, “तिमीले मसित यो के गर्‍यौ? साराई तिम्री पत्नी हुन् भनी तिमीले किन भनेनौ? ");
INSERT INTO npioncb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तिमीले किन ‘तिनी त मेरी बहिनी हुन्’ भनी भन्यौ? त्यसैले त मैले तिनलाई पत्नी तुल्याउनलाई लगेँ। अब हेर, तिम्री पत्नी यहाँ छिन्। तिनलाई लिएर यहाँबाट गइहाल!” ");
INSERT INTO npioncb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","तब फारोले अब्रामको विषयमा आफ्ना मानिसहरूलाई आदेश दिए; अनि तिनीहरूले तिनलाई तिनकी पत्नी र तिनीसित भएका सबै थोकसहित त्यहाँबाट पठाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","यसरी अब्राम आफ्नी पत्नी र आफूसित भएका सबै थोकहरू लिएर इजिप्टबाट दक्षिणतिर गए, र लोत पनि तिनको पछि लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम घरपालुवा पशुहरू, सुन र चाँदीमा प्रशस्त धनवान् भएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","दक्षिणबाट धेरै ठाउँहरूहुँदै तिनी बेथेलमा आइपुगे, अर्थात् बेथेल र ऐको बीच ठाउँमा जहाँ पहिले तिनको पाल टाँगिएको थियो ");
INSERT INTO npioncb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","र त्यहाँ तिनले पहिलो वेदी बनाएका थिए। त्यहाँ अब्रामले याहवेहको नामलाई पुकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","अब्रामसित यात्रा गर्ने लोतका पनि भेडाबाख्रा, गाईबस्तुहरूका बथान र पालहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","तर तिनीहरू एकैसाथ रहनका लागि जमिनले धान्‍न सकेन; किनकि तिनीहरूका सम्पत्तिहरू यति धेरै थिए कि तिनीहरू एकैसाथ रहन सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अनि अब्रामका गोठालाहरू र लोतका गोठालाहरू बीचमा झगडा सुरु भयो। त्यस बेला त्यस देशमा कनानी र परिज्जीहरू पनि बसोबास गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","यसकारण अब्रामले लोतलाई भने, “तिम्रो र मेरो बीचमा, र तिम्रा गोठालाहरू र मेरा गोठालाहरू बीचमा झगडा नहोस्; किनकि हामी नजिकका नातेदार हौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","के सम्पूर्ण देश तिम्रो सामु छैन र? हामी अलग होऔँ। तिमी देब्रेतिर गयौ भने म दाहिनेतिर जानेछु; तिमी दाहिनेतिर गयौ भने म देब्रेतिर जानेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","त्यसपछि लोतले चारैतिर हेरे; सोअरतिरको यर्दनको सबै समथल भूमिलाई याहवेहको बगैँचाझैँ प्रशस्त पानी भएको इजिप्ट देशजस्तै देखे। (योचाहिँ याहवेहले सदोम र गमोरालाई नष्‍ट गर्नु अगिको कुरा थियो।) ");
INSERT INTO npioncb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","यसकारण लोतले आफ्ना निम्ति यर्दनका सबै समथल भूमिलाई चुने; अनि पूर्वतिर लागे। यसरी यी दुई मानिसहरू एक-अर्काबाट अलग भए। ");
INSERT INTO npioncb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान देशमै बसे, र लोतचाहिँ समथल भूमिका सहरहरूमध्ये एउटामा बसे; अनि तिनले सदोमको छेउमा आफ्ना पालहरू टाँगे। ");
INSERT INTO npioncb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोमका मानिसहरू दुष्‍ट थिए, र याहवेहको विरुद्धमा घोर पाप गरिरहन्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","अब्रामबाट लोत छुट्टिएपछि याहवेहले अब्रामलाई भन्‍नुभयो, “तँ जहाँ छस्, त्यहाँबाट उत्तर र दक्षिण, पूर्व र पश्‍चिम चारैतिर हेर्। ");
INSERT INTO npioncb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","तैँले देखेको सबै जमिन तँ र तेरा सन्तानहरूलाई म सदाका निम्ति दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","म तेरा सन्तानहरूलाई पृथ्वीको धुलोझैँ बनाउनेछु, र कसैले धुलो गन्‍न सक्छ भने तेरा सन्तानहरूलाई पनि गन्‍न सक्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","जा, त्यस देशको लम्बाइ र चौडाइ वारपार हिँड्; किनकि यो म तँलाई दिँदैछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","यसकारण अब्रामले आफ्नो पाल सारे, र हेब्रोनमा मम्रेका फलाँटका ठूला रूखहरूको छेउमा गएर बसे; त्यहाँ तिनले याहवेहको निम्ति एउटा वेदी बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","त्यस बेला शिनारका राजा अम्रापेल, एल्‍लासारका राजा अर्योक, एलामका राजा कदोर्लाओमेर अनि गोयीमका राजा तिदाल मिलेर, ");
INSERT INTO npioncb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","सदोमका राजा बेरा, गमोराका राजा बिर्शा, अदमाका राजा शिनाब, सबोयीमका राजा शेमेबेर अनि बेलाका राजा (अर्थात् सोअरका) विरुद्धमा लडाइँ गर्न गए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","यी पछिल्‍ला राजाहरू सबै एक भएर सिद्धीमको बेँसीमा (खारा समुद्रको बेँसीमा) भेला भए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","तिनीहरू बाह्र वर्षसम्म कदोर्लाओमेरका अधीनमा थिए, तर तेह्रौँ वर्षमा तिनीहरूले विद्रोह गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","चौधौँ वर्षमा कदोर्लाओमेर र तिनीसित मिलेका राजाहरूले अस्तेरोत-कर्णेममा रपाईहरूलाई, हाममा जूजीहरूलाई, शावे-किर्यातैममा एमीहरू ");
INSERT INTO npioncb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","र सेइरको पहाडी देशमा भएका होरीतहरूलाई, मरुभूमितिर भएको एल-पारानसम्म परास्त गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","त्यसपछि तिनीहरू फर्केर एन-मिशापात (अर्थात् कादेशमा) गए, र तिनीहरूले अमालेकीहरूका सम्पूर्ण देशका साथै हासेसोन-तामारमा बसोबास गर्ने एमोरीहरूलाई पनि पराजित गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","त्यसपछि सदोमका राजा, गमोराका राजा, अदमाका राजा, सबोयीमका राजा, र बेला (अर्थात् सोअरका) राजा निस्किगए र सिद्धीमको बेँसीमा ");
INSERT INTO npioncb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","एलामका राजा कदोर्लाओमेर, गोयीमका राजा तिदाल, शिनारका राजा अम्रापेल र एल्‍लासारका राजा अर्योकको विरुद्धमा—अर्थात् पाँचका विरुद्धमा चार राजाहरूले युद्धको मोर्चा बाँधे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","अब सिद्धीमको बेँसीचाहिँ अलकत्राको खाल्डाले भरिएको थियो; अनि सदोम र गमोराका राजाहरू भाग्दा कति जना ती खाल्डाहरूमा खसे; अनि बाँकी रहेकाहरूचाहिँ पहाडहरूतिर भागे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ती चार जना राजाहरूले सदोम र गमोराका सबै सामान, र तिनीहरूका सबै खानेकुरा लिएर भागे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","तिनीहरूले सदोममा रहेका अब्रामका भतिजा लोत र तिनका सम्पत्ति पनि लिएर गए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","त्यहाँबाट उम्केको एउटा व्यक्तिले आएर यो कुरा हिब्रू अब्रामलाई बताइदियो। अब्रामचाहिँ आफूसित वाचामा रहेका एश्कोल र आनेरका भाइ एमोरीका मम्रेका ठूला रूखहरूको छेउमा बसोबास गर्दैथिए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्रामले आफ्नो नातेदारलाई कैद गरेर लगेका छन् भनी सुने, तब तिनले आफ्नो घरानामा जन्मेका तीन सय अठार जना तालिम प्राप्‍त मानिसहरूलाई लिए र तिनीहरूलाई दानसम्मै लखेट्दै गए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","रातको समयमा अब्रामले तिनीहरूलाई आक्रमण गरेर परास्त गर्नका लागि आफ्ना मानिसहरूलाई विभाजन गरे, र दमस्कसको उत्तरमा भएको होबासम्म लखेटे। ");
INSERT INTO npioncb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","तिनले सबै मालसामान फिर्ता ल्याए; अनि स्त्रीहरू र अरू मानिसहरूसहित आफ्ना नातेदार लोत र तिनका सम्पत्तिलाई फर्काइल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","अब्रामले कदोर्लाओमेर र तिनलाई साथ दिने अरू राजाहरूलाई जितेर फर्केपछि सदोमका राजा शावेको बेँसीमा (अर्थात् राजाको बेँसीमा) तिनलाई भेट्न आए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","तब शालेमका राजा मल्कीसेदेक रोटी र दाखमद्य लिएर आए। तिनी सर्वोच्‍च परमेश्‍वरका पुजारी थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","अनि तिनले अब्रामलाई यसो भन्दै आशिष् दिए, “सर्वोच्‍च परमेश्‍वर, आकाश र पृथ्वीका सृष्‍टिकर्ताले अब्रामलाई आशिष् देऊन्। ");
INSERT INTO npioncb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","अनि सर्वोच्‍च परमेश्‍वर धन्यका होऊन्, जसले तपाईंका शत्रुहरूलाई तपाईंका हातमा सुम्पिदिनुभयो।” त्यसपछि अब्रामले तिनलाई हरेक कुराको दशांश दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सदोमका राजाले अब्रामलाई भने, “मलाई मानिसहरू दिनुहोस्, र सामानहरू तपाईं आफैँ राख्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","तर अब्रामले सदोमका राजालाई भने, “मैले याहवेह सर्वोच्‍च परमेश्‍वर, आकाश र पृथ्वीका सृष्‍टिकर्तातर्फ आफ्नो हात उचालेर शपथ खाएको छु, ");
INSERT INTO npioncb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","कि म तिम्रो केही कुरो पनि ग्रहण गर्नेछैनँ। एउटा डोरी अथवा जुत्ताको फित्तासम्म पनि लिनेछैनँ। तिमीले ‘मैले अब्रामलाई धनी बनाएँ’ भनेर कहिल्यै भन्‍न पनि सक्नेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","मेरा मानिसहरूले जे खाएका छन्, त्यो बाहेक म केही पनि ग्रहण गर्नेछैनँ; तर मसित जानेहरू—आनेर, एश्कोल र मम्रेले आ-आफ्ना भाग लिऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","त्यसपछि दर्शनमा याहवेहको यो वचन अब्रामकहाँ आयो: “अब्राम, तँ नडरा; म तेरो ढाल हुँ, र तेरो इनाम अत्यन्त ठूलो हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","तर अब्रामले भने, “हे प्रभु याहवेह, तपाईंले मलाई के दिन सक्नुहुन्छ? किनकि म निःसन्तान छु, र मेरो सम्पत्तिको हकदार दमस्कसको एलीएजर नै हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अनि अब्रामले फेरि भने, “तपाईंले मलाई छोराछोरी दिनुभएन; यसकारण मेरै घरानामा जन्मेको सेवक नै मेरो उत्तराधिकारी हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","तब याहवेहको वचन फेरि तिनीकहाँ आयो: “यो मानिस तेरो उत्तराधिकारी हुनेछैन; तर तँबाटै जन्मिएको छोरो तेरो उत्तराधिकारी हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","उहाँले तिनलाई बाहिर लानुभयो र भन्‍नुभयो, “यदि तैँले गन्‍न सक्छस् भने आकाशतिर हेर्, र ताराहरू गन्।” तब उहाँले तिनलाई भन्‍नुभयो, “तेरा सन्तानहरू पनि त्यस्तै हुनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अनि अब्रामले याहवेहमाथि विश्‍वास गरे, र यो उनको निम्ति धार्मिकता गनियो। ");
INSERT INTO npioncb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","उहाँले तिनलाई यो पनि भन्‍नुभयो, “म नै याहवेह हुँ, जसले तँलाई कल्दीहरूको ऊरबाट यो देश सम्पत्तिको रूपमा दिन भनी निकालेर ल्याएँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","तर अब्रामले भने, “हे प्रभु याहवेह, मैले यो सम्पत्तिको रूपमा पाउनेछु भनी म कसरी थाहा पाऊँ?” ");
INSERT INTO npioncb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","यसकारण याहवेहले तिनलाई भन्‍नुभयो, “मकहाँ तीन-तीन वर्षको एउटा कोरली, एउटा पाठी र एउटा भेडा, र साथमा एउटा ढुकुर र एउटा परेवाको बचेरो ले।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्रामले ती सबै उहाँकहाँ ल्याए, तिनीहरूलाई दुई टुक्रा गरी काटे र आधा भागलाई एक-अर्काको विपरीत दिशामा मिलाएर राखे; तर चराहरूलाई चाहिँ तिनले आधा गरी काटेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","तब चील र गिद्धहरू शिकारमाथि झम्टेर आए, तर अब्रामले तिनीहरूलाई धपाए। ");
INSERT INTO npioncb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","जब घाम डुब्दै थियो, अब्राम मस्त निद्रामा परे; अनि डरलाग्दो र घोर अन्धकारले तिनलाई छोप्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब याहवेहले अब्रामलाई भन्‍नुभयो, “तैँले यो निश्‍चय जानिराख् कि तेरा सन्तानहरू चार सय वर्षसम्म अर्काको देशमा प्रवासी हुनेछन् र त्यहाँ तिनीहरूले दास भएर दुर्व्यवहार खप्नुपर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","तर म तिनीहरूले दास-दासी भएर सेवा गरेको देशलाई दण्ड दिनेछु; अनि पछि तिनीहरू त्यहाँबाट धेरै सम्पत्ति लिएर निस्किआउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","तर तँचाहिँ शान्तिसित तेरा पुर्खाहरूकहाँ जानेछस्; अनि तँ पूरा बुढेसकालमा गाडिनेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","चौथो पुस्तामा तेरा सन्तानहरूहरू यहाँ फर्केर आउनेछन्; किनकि एमोरीहरूको अधर्म अहिलेसम्म पूरा भइसकेको छैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","जब घाम अस्तायो र अँध्यारो भयो, र एउटा बलिरहेको आगो भएको धुवाँले भरिएको मकल देखा पर्‍यो, र ती टुक्राहरूका बीचबाट भएर गयो। ");
INSERT INTO npioncb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","त्यसै दिन याहवेहले अब्रामसित एउटा करार बाँध्नुभयो र भन्‍नुभयो, “म तेरा सन्तानहरूलाई यो देश दिनेछु, अर्थात् इजिप्टको नदीदेखि महानदी यूफ्रेटिससम्म— ");
INSERT INTO npioncb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","जुन केनीहरू, कनज्जीहरू, कदोमोनीहरू, ");
INSERT INTO npioncb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्तीहरू, परिज्जीहरू, रपाईहरू, ");
INSERT INTO npioncb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरीहरू, कनानीहरू, गिर्गाशीहरू अनि यबूसीहरूका देशहरू हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्रामकी पत्नी साराईले तिनका निम्ति कुनै सन्तान जन्माइनन्। तर तिनकी हागार नाम भएकी एउटी इजिप्टियन दासी थिइन्; ");
INSERT INTO npioncb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","अनि साराईले अब्रामलाई भनिन्, “याहवेहले मेरो कोख बन्द गरिदिनुभएको छ। यसकारण जानुहोस्, मेरी दासीसित सुत्नुहोस्; सायद त्यसबाट मेरो लागि सन्तान पाउन सक्छु कि।” साराईले जे भनिन्, त्यस कुरामा अब्राम सहमत भए। ");
INSERT INTO npioncb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","यसरी अब्राम कनानमा दश वर्ष बसेपछि तिनकी पत्नी साराईले आफ्नी इजिप्टियन दासी हागारलाई आफ्ना पतिका निम्ति पत्नी हुनलाई दिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","अनि उनी हागारकहाँ गए, र त्यो गर्भवती भई। जब त्यसले आफू गर्भवती भएकी थाहा पाई, तब त्यसले आफ्नी मालिक्नीलाई हेप्न थाली। ");
INSERT INTO npioncb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तब साराईले अब्रामलाई भनिन्, “मैले भोगिरहेको कष्‍टको लागि तपाईं जिम्मेवार हुनुहुन्छ। मैले मेरी दासीलाई तपाईंको अँगालोमा सुम्पेँ; अब त्यसले आफू गर्भवती भएकी थाहा पाएर मलाई हेप्न थालेकी छ। याहवेहले नै तपाईं र मेरो बीचमा न्याय गरिदेऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्रामले भने, “तिम्री दासी तिम्रै हातमा छे। तिमीलाई जे उचित लाग्छ, त्यससित त्यसै गर।” तब साराईले हागारसित दुर्व्यवहार गरिन्; त्यसकारण त्यो साराईबाट भागेर गई। ");
INSERT INTO npioncb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","पछि याहवेहका दूतले हागारलाई उजाडस्थानमा पानीको मूलको छेउमा भेटे; त्यो मूल शूरतिर जाने बाटोको छेउमा थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","अनि उनले भने, “साराईकी दासी हागार, तँ कहाँबाट आइस्, र कहाँ जाँदैछस्?” तब त्यसले भनी, “म मेरी मालिक्नी साराईबाट भाग्दैछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","तब याहवेहका दूतले त्यसलाई भने, “तँ आफ्नी मालिक्नीकहाँ जा, र तिनकै अधीनमा बस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","याहवेहका दूतले फेरि भने, “म तेरा सन्तानहरूलाई यति धेरै बढाउनेछु कि तिनीहरूलाई गन्‍न सकिनेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","याहवेहका दूतले त्यसलाई यो पनि भने: “तँ गर्भवती छस्, र तैँले एउटा छोरा जन्माउनेछस्। तैँले उसको नाम इश्माएल राख्नू; किनकि याहवेहले तेरो कष्‍टको पुकार सुन्‍नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","तेरो छोरा मानिसहरूमा जङ्गली गधाझैँ हुनेछ; उसको हात सबैको विरुद्धमा उठ्नेछ, अनि सबैको हात उसको विरुद्धमा उठ्नेछ; र ऊ आफ्ना दाजुभाइहरूसँग शत्रुतामा बसोबास गर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","हागारले आफूसित बोल्नुहुने याहवेहलाई यो नाम दिई, “तपाईं मलाई देख्नुहुने परमेश्‍वर हुनुहुन्छ,” किनकि त्यसले भनी, “मलाई देख्नुहुनेलाई अब मैले पनि देखेकी छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","त्यसैकारण त्यस कुवालाई बेअर-लहै-रोइ भनियो; जुनचाहिँ कादेश र बेरेदको बीचमा अहिलेसम्म पनि छ। ");
INSERT INTO npioncb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","यसरी हागारले अब्रामका निम्ति एउटा छोरा जन्माई; अनि अब्रामले हागारले जन्माएको आफ्नो छोराको नाम इश्माएल राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारले तिनका लागि इश्माएललाई जन्माउँदा अब्राम छयासी वर्षका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम उनान्सय वर्ष पुग्दा याहवेह तिनीकहाँ प्रकट हुनुभयो र भन्‍नुभयो, “म सर्वशक्तिमान् परमेश्‍वर हुँ; विश्‍वासयोग्य र निर्दोष भएर मेरो अगि हिँड्। ");
INSERT INTO npioncb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","अनि म मेरो करार तेरो र मेरो बीचमा बाँध्नेछु, र तेरा सन्तानहरूलाई अत्यन्तै बढाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","त्यसपछि अब्राम घोप्टो परे; तब परमेश्‍वरले तिनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“हेर्, मेरो करार तँसित यही हुनेछ, तँ धेरै जातिहरूका पिता हुनेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","अब उसो तँलाई अब्राम भनिनेछैन; तर तेरो नाम अब्राहाम हुनेछ; किनकि मैले तँलाई धेरै जातिहरूका पिता तुल्याएको छु। ");
INSERT INTO npioncb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","म तँलाई धेरै फलवन्त बनाउनेछु; अनि तँबाट नै जाति-जातिहरू बनाउनेछु, र तँबाट राजाहरू निस्कनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","म मेरो करारलाई तेरो र मेरो, र तँपछिका तेरा सन्तानहरूको बीचमा आउने पुस्ताका निम्ति अनन्तको करारको रूपमा स्थापित गर्नेछु। अनि म तँ र तँपछि आउने तेरो सन्तानका परमेश्‍वर हुनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","तँ र तेरा पछिका सन्तानहरूलाई अहिले तँ प्रवासी भएर बसेको सम्पूर्ण कनान देश, अनन्तको सम्पत्तिको रूपमा दिनेछु; र म तिनीहरूका परमेश्‍वर हुनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","तब परमेश्‍वरले अब्राहामलाई भन्‍नुभयो, “तेरो विषयमा चाहिँ, तँ र तँपछिका तेरा सन्तानहरूले आउने पुस्तौँ-पुस्तासम्म मेरो करार पालन गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","मेरो र तेरो, साथै तँपछिका तेरा सन्तानहरूसित मेरो करार यही हो, अर्थात् तिमीहरूले पालन गर्नुपर्ने करार: तिमीहरूका प्रत्येक पुरुषको खतना हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तिमीहरूका खलडीको खतना हुनुपर्छ, र योचाहिँ तँसित बाँधिएको मेरो करारको चिन्ह हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","अनि आउने पुस्तौँ-पुस्तासम्म तिमीहरूको बीचमा आठ दिन भएको प्रत्येक पुरुषको खतना हुनैपर्छ। तेरा घरानामा जन्मेका अथवा विदेशीहरूबाट रुपियाँपैसा दिएर किनिएका—जो तेरा आफ्नै सन्तान होइनन्, ");
INSERT INTO npioncb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","चाहे तेरा घरानामा जन्मेका होऊन्, अथवा तेरा रुपियाँपैसाले किनेका होऊन्, तिनीहरू सबैको खतना हुनैपर्छ। तेरो शरीरमा गरिएको मेरो करार अनन्तको करार हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","खतना नगरिएको कुनै पनि पुरुष, जसको शरीरमा खलडीको खतना भएको छैन, त्यो व्यक्ति आफ्ना जातिहरूबाट बहिष्कृत गरिनेछ; किनकि त्यसले मेरो करार भङ्ग गरेको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","परमेश्‍वरले अब्राहामलाई यो पनि भन्‍नुभयो, “तेरी पत्नी साराईको विषयमा चाहिँ, तैँले त्यसलाई अब उसो साराई भनेर नबोलाउनू; तर त्यसको नाम सारा हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","म त्यसलाई आशिष् दिनेछु, र म निश्‍चय तँलाई त्यसबाट एउटा छोरा दिनेछु। म त्यसलाई आशिष् दिनेछु, र त्यो धेरै जातिकी आमा हुनेछे; त्यसबाट जाति-जातिका राजाहरू उत्पन्‍न हुनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","तब अब्राहाम भुइँमा घोप्टो परे; अनि हाँसेर मनमनै भने, “के एक सय वर्ष पुगेको मानिसको पनि छोरा जन्मला र? के नब्बे वर्ष पुगेकी साराले पनि बच्‍चा जन्माउलिन् र?” ");
INSERT INTO npioncb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","अनि अब्राहामले परमेश्‍वरलाई भने, “इश्माएल तपाईंको आशिष्‌मुनि बाँच्छ भने पनि असल हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","तब परमेश्‍वरले भन्‍नुभयो, “तेरी पत्नी साराले तेरो निम्ति एउटा छोरा जन्माउनेछे; र तैँले त्यसको नाम इसहाक राख्नू। म त्यससित र त्यसपछिका सन्तानका निम्ति मेरो करार अनन्तको करारको रूपमा स्थापित गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","अनि इश्माएलको विषयमा चाहिँ मैले तेरो कुरा सुनेको छु; हेर्, म निश्‍चय नै त्यसलाई आशिष् दिनेछु; म त्यसलाई फलवन्त बनाउनेछु; अनि त्यसलाई संख्यामा असाध्यै बढाउनेछु। त्यो बाह्र शासकहरूका पिता हुनेछ, र म त्यसलाई एउटा महान् जाति बनाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","तर मेरो करारचाहिँ म इसहाकसँग नै स्थापित गर्नेछु, जसलाई साराले आउँदो साल यही समयमा तेरो निम्ति जन्माउनेछे।” ");
INSERT INTO npioncb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","परमेश्‍वर अब्राहामसित कुरा गरिसक्नुभएपछि तिनीबाट गइहाल्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","त्यही दिन नै परमेश्‍वरले तिनलाई भन्‍नुभएझैँ, अब्राहामले आफ्नो छोरा इश्माएल र आफ्ना घरानामा जन्मेका सबै, र आफ्नो रुपियाँपैसाले किनेका हरेक पुरुषको खलडीको खतना गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","अब्राहामको खलडीको खतना हुँदा तिनी उनान्सय वर्षका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","अनि तिनको छोरा इश्माएलको खलडीको खतना हुँदा त्यो तेह्र वर्षको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम र तिनको छोरा इश्माएलको खतना पनि त्यही दिनमै गरियो। ");
INSERT INTO npioncb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","अनि अब्राहामसँगै तिनका घरानाका, तिनका घरानामा जन्मेका, अथवा बिदेशीबाट किनिएका प्रत्येक पुरुषको खतना भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","दिउँसोको गर्मीमा मम्रेका ठूला फलाँटका रूखहरू नजिक आफ्नो पालको प्रवेशद्वारमा अब्राहाम बसिरहेका बेला याहवेह तिनीकहाँ देखा पर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अब्राहामले आँखा उठाएर हेरे; र तीन जना मानिसहरूलाई तिनको छेउमा उभिरहेका देखे। जब तिनले उहाँहरूलाई देखे, तब तिनी आफ्नो पालको प्रवेशद्वारबाट उहाँहरूलाई भेट्न भनी दौडेर गए; र भुइँसम्मै घोप्टो परेर दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","तिनले भने, “हे मेरा प्रभु, यदि मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने तपाईंको सेवककहाँ एकछिन नबसी यत्तिकै नगइदिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","मलाई पानी ल्याउन दिनुहोस्, र आफ्ना पाउ धोएर यस रूखमुनि आराम गर्नुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","अब तपाईंहरू आफ्ना सेवककहाँ आउनुभएकोले मलाई केही खानेकुरा ल्याउन दिनुहोस्; अनि तपाईंहरू खानुहोस् र थकाइ मार्नुहोस्, र त्यसपछि आफ्नो बाटो लाग्नुहोला।” उहाँहरूले भने, “हुन्छ, तिमीले भनेझैँ गर।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","यसकारण अब्राहाम हतार-हतार गर्दै पालभित्र साराकहाँ गएर भने, “लौ झट्टै तीन सिया मसिनो पिठो तयार पारी मुछेर केही रोटी बनाऊ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","तब अब्राहाम बगाल भएको ठाउँमा दौडेर गए, र एउटा कलिलो बाछो छानेर आफ्नो सेवकलाई दिए। उसले तुरुन्तै काटकुट गरेर पकायो। ");
INSERT INTO npioncb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","तब तिनले दही, दूध र बाछाको मासु ल्याए, र उहाँहरूका सामु टक्र्याइदिए। अनि उहाँहरूले खाउन्जेल तिनीचाहिँ उहाँहरूकै छेउमा रूखमुनि उभिरहे। ");
INSERT INTO npioncb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","तब उहाँहरूले अब्राहामलाई सोधे “तिम्री पत्नी सारा कहाँ छिन्?” तिनले भने, “त्यहीँ पालभित्र छिन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","उहाँहरूमध्ये एक जनाले भने, “निश्‍चय नै म आउँदो वर्ष यसै समयमा तिमीकहाँ फर्किआउनेछु; तब तिम्री पत्नी साराको साथमा एउटा छोरा हुनेछ।” अब साराले चाहिँ यो कुरा अब्राहामको पछिल्तिर भएको पालको प्रवेशद्वारबाट सुनिरहेकी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम र सारा निकै बुढाबुढी भइसकेका थिए; अनि साराको बच्‍चा जन्माउने उमेर पनि कटिसकेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","यसकारण सारा मनमनै हाँसिन् र भनिन्, “म बुढी भइसकेकी छु, र मेरा पति पनि वृद्ध भइसक्नुभएको छ; अब के मलाई साँच्‍चै यो सुख प्राप्‍त होला?” ");
INSERT INTO npioncb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब याहवेहले अब्राहामलाई भन्‍नुभयो, “म बुढी भइसकेकीले के साँच्‍चै बच्‍चा जन्माउन सकुँली र? भन्दै सारा किन हाँसी? ");
INSERT INTO npioncb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","के याहवेहका निम्ति कुनै कुरा कठिन छ र? म तोकिएको समयमा अर्को वर्ष तिमीकहाँ फर्किआउनेछु, र साराको एउटा छोरा हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","सारा डराइन्, र ढाँट्दै यसो भनिन्, “अहँ, म हाँसिनँ।” तर उहाँले भन्‍नुभयो, “हो, तँ हाँसेकै थिइस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","जब ती मानिसहरू जान तयार भए, तब उनीहरूले तल सदोमतिर हेरे; अनि उनीहरूलाई अलिक परसम्म पुर्‍याउन अब्राहाम पनि सँगै गए। ");
INSERT INTO npioncb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","तब याहवेहले भन्‍नुभयो, “मैले जे गर्न लागेको छु, के म त्यो कुरा अब्राहामबाट लुकाऊँ? ");
INSERT INTO npioncb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","निश्‍चय नै अब्राहामको वंश एउटा महान् र शक्तिशाली राष्ट्र बन्‍नेछ, र पृथ्वीका सबै राष्ट्रहरूले ऊद्वारा नै आशिष् पाउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","किनकि मैले उसलाई चुनेको छु, ताकि उसले आफ्ना छोराछोरी र त्यसपछिका आफ्ना घरानालाई जे ठिक र न्यायसङ्गत छ, सो गर्दै याहवेहको वचनको पालन गर्न आदेश गर्नेछ। त्यसपछि म अब्राहामका निम्ति सबै कुरा पूरा गर्नेछु, जुन मैले प्रतिज्ञा गरेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","तब याहवेहले भन्‍नुभयो, “सदोम र गमोराको विरुद्धमा उठेको आक्रोश अत्यन्तै ठूलो छ; अनि तिनीहरूको कुकर्म अति नै भएकोले, ");
INSERT INTO npioncb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","मकहाँ आएको तिनीहरूको गुनासो सही हो कि होइन भनी हेर्न अब म तल जानेछु। यदि होइन रहेछ भने म थाहा गर्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","यसकारण ती मानिसहरू फर्केर सदोमतिर गए; तर अब्राहामचाहिँ याहवेहकै सामु उभिरहे। ");
INSERT INTO npioncb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्राहाम उहाँको नजिक गएर भने: “के तपाईंले दुष्‍टहरूसँगै धर्मीलाई पनि नाश गर्नुहुन्छ? ");
INSERT INTO npioncb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","यदि त्यस सहरमा पचास जना धर्मी मानिस रहेछन् भने के तपाईंले त्यस सहरलाई साँच्‍चै नाश गर्नुहुनेछ? के ती पचास धर्मी मानिसको खातिर त्यस ठाउँलाई छोडिदिनुहुन्‍न? ");
INSERT INTO npioncb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","तपाईंबाट यस्तो पटक्‍कै नहोस्—धर्मीलाई पापीसँग मार्ने, र धर्मी र पापीलाई एउटै व्यवहार गर्ने काम तपाईंबाट नहोस्! तपाईंबाट यस्तो कदापि नहोस्! के सारा पृथ्वीका न्यायकर्ताले ठिक न्याय गर्नुहुन्‍न र?” ");
INSERT INTO npioncb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","तब याहवेहले भन्‍नुभयो, “यदि मैले सदोम सहरमा पचास जना धर्मी मानिस पाएँ भने म तिनीहरूका खातिर सम्पूर्ण सहरलाई नाश गर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","त्यसपछि अब्राहामले फेरि भने: “हुन त म धुलो र खरानीबाहेक केही होइनँ, तापनि मैले प्रभुसँग बोल्ने साहस गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","यदि त्यस सहरमा पाँच कम पचास जना धर्मी मानिस रहेछन् भने के पाँच जना धर्मी कम भएको कारण तपाईंले सम्पूर्ण सहरलाई नाश गर्नुहुनेछ?” उहाँले भन्‍नुभयो, “यदि मैले पैँतालीस जना पाएँ भने पनि म त्यसलाई नाश गर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","एकपल्ट फेरि तिनले भने, “यदि चालीस जना मात्र पाइए भने नि?” उहाँले भन्‍नुभयो, “चालीस जनाको खातिर पनि म त्यसो गर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तब तिनले भने, “प्रभु, रिसानी माफ पाऊँ, तर म अझै बोल्न पाऊँ। यदि तीस जना मात्र पाइए भने?” उहाँले जवाफ दिनुभयो “यदि तीस जना मात्र पाएँ भने तापनि म त्यसो गर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","अब्राहामले भने, “मैले फेरि प्रभुसित बोल्न साहस गरेको छु; यदि त्यहाँ बीस जना मात्रै पाइए भने नि?” उहाँले भन्‍नुभयो, “बीस जनाको खातिर पनि म त्यसलाई नाश गर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","तब तिनले भने, “प्रभु रिसानी माफ पाऊँ; तर अब एकपल्ट मात्रै बोल्न पाऊँ। यदि दश जना मात्र त्यहाँ पाइए भने?” अनि उहाँले भन्‍नुभयो, “दश जनाको खातिर पनि म त्यसलाई नाश गर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","अब्राहामसित कुरा गरिसक्नुभएपछि याहवेह गइहाल्नुभयो; अनि अब्राहामचाहिँ आफ्नो घरमा फर्के। ");
INSERT INTO npioncb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ती दुई स्वर्गदूतहरू साँझतिर सदोममा आइपुगे; अनि लोतचाहिँ सहरको मूलढोकामा बसिरहेका थिए। जब लोतले तिनीहरूलाई देखे, तब तिनी तिनीहरूलाई भेट्न उठे; अनि भुइँसम्मै घोप्टो परेर दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","अनि तिनले भने, “हे मेरा प्रभुहरू हो, कृपया आफ्नो सेवकको घरमा पाल्नुहोस्। तपाईंहरू आफ्ना पाउ धुनुहोस् र रात यहीँ बिताउनुहोस्; अनि भोलि बिहानै आफ्नो बाटो लाग्नुहोस्।” तर तिनीहरूले भने, “होइन, हामी यहीँ चोकमा रात काट्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","तर लोतले धेरै कर गरिरहे, त्यसैले तिनीहरू लोतसित गए, र तिनको घरभित्र पसे। तिनले तिनीहरूका निम्ति खमिर नमिसाइएको रोटी पकाएर भोजन तयार पारे; अनि तिनीहरूले खाए। ");
INSERT INTO npioncb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","तिनीहरू सुत्नुभन्दा अगि त्यस सदोम सहरका सबै ठाउँहरूबाट जवानदेखि वृद्ध, सबै मानिसहरू हुल बाँधेर आए, र त्यस घरलाई घेरे। ");
INSERT INTO npioncb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","तिनीहरूले लोतलाई बोलाएर भने, “आज राति तिमीकहाँ आएका ती मानिसहरू कहाँ छन्? तिनीहरूलाई हामीकहाँ बाहिर ल्याऊ, र हामी तिनीहरूसित सम्भोग गर्न चाहन्छौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लोत तिनीहरूलाई भेट्न बाहिर निस्के, र तिनले आफ्नो पछिल्तिर भएको ढोका थुनिदिए, ");
INSERT INTO npioncb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","अनि भने, “हे मेरा दाजुभाइहरू हो, म बिन्ती गर्दछु, यस्तो दुष्‍ट काम नगर्नुहोस्! ");
INSERT INTO npioncb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","हेर्नुहोस्, कुनै पनि मानिसले कहिल्यै नछोएका मेरा दुई छोरीहरू छन्। बरु म तिनीहरूलाई तपाईंहरू सामु बाहिर ल्याउँछु, र तपाईंहरूलाई जस्तो इच्छा लाग्छ, तिनीहरूसित त्यस्तै व्यवहार गर्नुहोस्। तर बिन्ती छ, यी मानिसहरूलाई केही नगर्नुहोस्; किनकि तिनीहरू मेरो संरक्षण र छानामुनि आएका मेरा पाहुना हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","तब तिनीहरूले जवाफ दिए, “हाम्रो बाटो छोड्।” अनि तिनीहरूले भने, “यो मानिस परदेशी भई यहाँ रहनको लागि आएको हो, र यो त बडो न्यायकर्ता पो हुन खोज्दैछ! अब हामी यी मानिसहरूसँग भन्दा तिमीसँग खराब व्यवहार गर्नेछौँ।” त्यसपछि तिनीहरूले लोतलाई जोडले ठेल्न थाले, र ढोका भत्काउन अगि बढे। ");
INSERT INTO npioncb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","तर लोतका पाहुनाहरूले हात बढाएर लोतलाई भित्र ताने, र ढोका थुनिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","तब तिनीहरूले त्यस घरको ढोकाबाहिर भएका सानादेखि ठूला सबैलाई अन्धा पारिदिए; त्यसकारण तिनीहरूले ढोका भेट्टाउन सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","त्यसपछि ती दुई मानिसहरूले लोतलाई भने, “के यहाँ तिम्रा अरू पनि कोही छन् कि? जुवाइँहरू, छोराहरू, छोरीहरू, अथवा यस सहरमा तिम्रा आफ्ना जो-जो छन्, तिनीहरू सबैलाई लिएर यहाँबाट गइहाल; ");
INSERT INTO npioncb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","किनकि अब हामी यस ठाउँलाई नाश गर्न लागेका छौँ। किनभने याहवेहको अगि उठेको यहाँका मानिसहरूको विरुद्धमा आएको आरोप यति ठूलो भएको छ कि उहाँले हामीलाई यस ठाउँलाई नाश गर्न पठाउनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","यसकारण लोत बाहिर गए, र आफ्ना छोरीहरूसित मगनी भएका जुवाइँहरूलाई यो कुरा बताए। तिनले भने, “चाँडो गरी यस ठाउँबाट निस्केर जाओ; किनकि याहवेहले यस सहरलाई नाश गर्न लाग्नुभएको छ।” तर तिनका जुवाइँहरूलाई तिनले ठट्टा गरेजस्तो लाग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","झिसमिसे उज्यालो हुन लाग्दा ती दूतहरूले लोतलाई यसो भनेर हतार गराए, “चाँडो गर! यहाँ भएका तिम्री पत्नी र दुई छोरीहरू लिएर गइहाल, नत्रता यस सहरले दण्ड पाउँदा तिमीहरू पनि भस्म हुनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","जब तिनले आनाकानी गरे, तब याहवेह तिनीहरूप्रति कृपालु हुनुभएकोले ती मानिसहरूले तिनकी पत्नी र दुई छोरीहरूका हात समाते, र तिनलाई सुरक्षित सहरबाहिर पुर्‍याए। ");
INSERT INTO npioncb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","तिनीहरूलाई बाहिर निकालेर ल्याउनसाथ ती दुईमध्ये एकले भने, “आफ्नो ज्यान जोगाउनलाई भागिहाल! आफ्नो पछिल्तिर फर्केर नहेर, र समथल भूमिमा कतै नरोकिनू! पहाडहरूतिर भागेर जाऊ, नत्रता तिमीहरू भस्म हुनेछौ!” ");
INSERT INTO npioncb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","तर लोतले तिनीहरूलाई भने, “हे मेरा प्रभुहरू हो, त्यस्तो नहोस्! ");
INSERT INTO npioncb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","तपाईंहरूका सेवकले तपाईंहरूका दृष्‍टिमा निगाह पाएको छ, र मेरो ज्यान जोगाउनमा तपाईंहरूले मलाई ठूलो दया देखाउनुभएको छ। तर म भागेर पहाडतिर जान सक्दिनँ; त्यहाँ पुग्नुभन्दा अगि नै यो प्रकोप ममाथि आइलाग्नेछ, र म मर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","हेर्नुहोस्, त्यतातिर दौडेर पुग्न सकिने एउटा नगर नजिकै छ, र यो सानो छ। मलाई त्यहाँ भागेर जान दिनुहोस्—यो सानो पनि छ, होइन र? तब मेरो ज्यान बाँच्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","अनि तिनले भने, “ठिकै छ, म यो अनुरोधलाई पनि मान्दछु; तिमीले भनेको यस नगरलाई म नाश गर्नेछैनँ। ");
INSERT INTO npioncb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","तर चाँडो गरी त्यहीँ भागेर जाऊ; किनकि तिमी त्यहाँ नपुगुन्जेल म केही गर्न सक्दिनँ।” (त्यसैकारण त्यस नगरलाई सोअर भनियो।) ");
INSERT INTO npioncb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लोत सोअरमा आइपुग्दा त्यस ठाउँमा सूर्य उदाइसकेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","तब याहवेहले स्वर्गबाट गन्धकको आगो सदोम र गमोरामाथि बर्साउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","यसरी उहाँले ती सहरहरू र त्यस सहरहरूका बासिन्दाहरूसमेत, समस्त समथल भूमिहरू र त्यस ठाउँका वनस्पति सबै नाश गरिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","तर लोतकी पत्नीले पछिल्तिर फर्केर हेरिन्, र तिनी नुनको खाँबो भइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","अब्राहाम भोलिपल्ट बिहानै उठे, र त्यस ठाउँमा गए, जहाँ तिनी याहवेहको सामु पहिले उभिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","तिनले सदोम, गमोरा र समथल भूमिका सबै ठाउँतिर हेरे; अनि तिनले भट्टीबाट धुवाँ उठेझैँ, त्यस ठाउँबाट बाक्लो धुवाँको मुस्लो उँभोतिर उठिरहेको देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","यसरी परमेश्‍वरले समथल भूमिका सहरहरू नाश गर्नुभएपछि, उहाँले अब्राहामलाई सम्झनुभयो, तब उहाँले लोत बसिरहेका ती सहरहरूलाई नाश गर्नुभन्दा अगि लोतलाई त्यस ठाउँबाट सकुशल बाहिर निकाल्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लोत र तिनका दुई छोरीहरूले सोअर छोडे, र पहाडी इलाकातिर बसोबास गर्न थाले; किनकि लोत सोअरमा बस्‍न डराउँथे। तिनी र तिनका छोरीहरू एउटा ओडारमा बस्‍न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन जेठी छोरीले कान्छीलाई भनिन्, “हाम्रा बुबा वृद्ध भइसक्नुभएको छ; अनि सारा संसारको रीतिबमोजिम हामीलाई सन्तान दिन कुनै मानिस पृथ्वीमा छैन। ");
INSERT INTO npioncb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","यसैले हामी आफ्ना बुबालाई दाखमद्य पियाऔँ, र वंश जोगाउन उहाँसँग सुतौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","त्यसैले त्यस रात तिनीहरूले आफ्ना बुबालाई मद्य पियाए; अनि जेठीचाहिँ गएर आफ्ना बुबासित सुती। आफ्नी छोरी आफूसँग सुत्न कहिले आई र कतिखेर उठेर गई, सो कुरा तिनलाई पत्तै भएन। ");
INSERT INTO npioncb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","भोलिपल्ट जेठीले आफ्नी बहिनीलाई भनी, “हेर, हिजो राति म आफ्नो बुबासित सुतेँ। आज पनि उहाँलाई मद्य पियाऔँ, र हाम्रो वंश जोगाउन आज रातिचाहिँ तिमी भित्र गएर उहाँसित सुत।” ");
INSERT INTO npioncb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","यसरी त्यस रात पनि तिनीहरूले आफ्ना बुबालाई मद्य पियाए; अनि कान्छी छोरी गएर तिनीसित सुती। अनि आफ्नी कान्छी छोरी आफूसँग सुत्न कतिखेर आई र कतिखेर उठेर गई, सो कुरा तिनलाई पत्तै भएन। ");
INSERT INTO npioncb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","यसरी लोतका दुवै छोरीहरू आफ्ना पिताबाट गर्भवती भए। ");
INSERT INTO npioncb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","जेठी छोरीले एउटा छोरा जन्माई, र उसले त्यस बालकको नाम मोआब राखी; आजका मोआबीहरूका पिता तिनी नै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","कान्छी छोरीले पनि एउटा छोरा जन्माई, र उसले त्यसको नाम बेन-अम्मी राखी; आजका अम्मोनीहरूका पिता तिनी नै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","अब अब्राहाम त्यहाँबाट अगि बढेर दक्षिणका इलाकातिर गए, र कादेश र शूरको बीचमा बसोबास गर्न थाले। तिनी केही समयका लागि गरारमा बसे; ");
INSERT INTO npioncb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अनि त्यहाँ अब्राहामले आफ्नी पत्नी साराको विषयमा, “यिनी मेरी बहिनी हुन्” भने, तब गरारका राजा अबीमेलेकले सारालाई झिकाए र तिनलाई लगे। ");
INSERT INTO npioncb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","तर एक रात सपनामा परमेश्‍वर अबीमेलेककहाँ आउनुभयो, र तिनलाई भन्‍नुभयो, “तैँले ल्याएको त्यस स्त्रीको कारण, तँ मरेतुल्य भएको छस्; त्यो विवाहित स्त्री हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","अबीमेलेक तिनको नजिक गएका पनि थिएनन्; अनि तिनले भने, “प्रभु, के तपाईंले एउटा निर्दोष जातिलाई नष्‍ट गर्नुहुनेछ? ");
INSERT INTO npioncb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","के तिनले मलाई ‘यिनी मेरी बहिनी हुन्’ भनेनन् र? अनि के साराले पनि ‘यिनी मेरा दाजु हुन्’ भनिन र? त्यसैले यो मैले शुद्ध विवेक र शुद्ध हातले नै गरेको हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","तब परमेश्‍वरले सपनामा अबीमेलेकलाई भन्‍नुभयो, “हो, तैँले यो शुद्ध विवेकले गरेको हो भनी म जान्दछु; यसकारण मैले तँलाई मेरो विरुद्धमा पाप गर्नदेखि रोकेँ। यसैकारण मैले तँलाई त्यसलाई छुन दिइनँ। ");
INSERT INTO npioncb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","अब त्यस मानिसकी पत्नी फर्काइदे; किनकि ऊ एउटा अगमवक्ता हो; र उसले तेरो निम्ति प्रार्थना गर्नेछ, र तँ बाँच्नेछस्। तर यदि तैँले सारालाई फर्काइदिइनस् भने यो निश्‍चय जानिराख्, तँ र तेरा जे जति छन्, ती सबै मर्नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","भोलिपल्ट बिहानै अबीमेलेकले आफ्ना सबै कर्मचारीहरूलाई बोलाए, र जे भएको थियो, सो तिनीहरूलाई सबै सुनाए; तब तिनीहरू साह्रै डराए। ");
INSERT INTO npioncb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","तब अबीमेलेकले अब्राहामलाई भित्र बोलाएर भने, “तपाईंले हामीलाई यो के गर्नुभयो? मैले तपाईंको के बिगार गरेँ, र तपाईंले म र मेरो राज्यमाथि यस्तो दोष ल्याउनुभयो? तपाईंले मसँग कहिल्यै गर्नै नहुने कामहरू गर्नुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","अनि अबीमेलेकले फेरि अब्राहामलाई सोधे, “यसो गर्नुको कारण के थियो?” ");
INSERT INTO npioncb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहामले जवाफ दिए, “ ‘यस ठाउँमा पक्‍कै पनि परमेश्‍वरको भय छैन, र मेरी पत्नीको कारण तिनीहरूले मलाई मार्लान् भनी मैले सोचेँ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","यसबाहेक यिनी मेरी साक्खै बहिनी पनि हुन्; अर्थात् मेरा पिताकी छोरी हुन्, तर मेरी आमाकी छोरीचाहिँ होइनन्; अनि यिनी मेरी पत्नी भईन्। ");
INSERT INTO npioncb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","अनि जब परमेश्‍वरले मलाई मेरा पिताको घरानाबाट विदेशीझैँ घुम्नलाई निकाल्नुभयो, तब मैले सारालाई भनेँ, ‘तिमीले यसरी मलाई आफ्नो प्रेम देखाउन सक्छ्यौ: हामी जहाँ गए तापनि मेरो विषयमा “यिनी मेरा दाजु हुन् भन्‍नू।” ’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमेलेकले भेडाबाख्रा, गाईबस्तु र दास-दासीहरू ल्याए, र ती अब्राहामलाई दिए; अनि तिनकी पत्नी सारालाई पुनः तिनीकहाँ फर्काइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अनि अबीमेलेकले भने, “मेरो देश तपाईंको सामु छ; तपाईंलाई जहाँ मन पर्छ, त्यहीँ बस्‍नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","सारालाई तिनले भने, “म तिम्रा दाजुलाई एक हजार शेकेल चाँदी दिँदैछु। योचाहिँ तिमीसित भएका सबैको सामु तिमीप्रति लागेको अभियोगको हर्जानास्वरूप हो; तिमी सम्पूर्ण तवरले सत्य ठहरिएकी छ्यौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","तब अब्राहामले परमेश्‍वरसित प्रार्थना गरे; अनि परमेश्‍वरले अबीमेलेक, तिनकी पत्नी र तिनकी दासीहरूलाई तिनीहरूले फेरि पनि सन्तान जन्माउन सकून् भनी निको पार्नुभयो; ");
INSERT INTO npioncb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","किनकि याहवेहले अब्राहामकी पत्नी साराको कारण अबीमेलेकको घरानाका सबै स्त्रीहरूका कोख बन्द गरिदिनुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","अब याहवेहले भन्‍नुभएझैँ साराप्रति उहाँ अनुग्रही हुनुभयो; अनि याहवेह आफूले प्रतिज्ञा गर्नुभएझैँ साराका निम्ति गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा गर्भवती भइन्, र अब्राहामको वृद्धावस्थामा तिनका निम्ति परमेश्‍वरले प्रतिज्ञा गर्नुभएकै समयमा एउटा छोरा जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","साराले अब्राहामका निम्ति जन्माएकी छोरालाई तिनले इसहाक नाम दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","जब अब्राहामको छोरा इसहाक आठ दिनका भए, तब परमेश्‍वरको आज्ञाअनुसार तिनले उसको खतना गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","आफ्नो छोरा इसहाकको जन्म हुँदा अब्राहाम सय वर्ष पुगेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","साराले भनिन्, “परमेश्‍वरले मलाई हाँस्‍ने तुल्याउनुभएको छ; अनि जजसले मेरो बारेमा यो कुरा सुन्छन्, तिनीहरू पनि सबै मसँगसँगै हाँस्‍नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","अनि तिनले अझ भनिन्, “साराले सन्तानहरूलाई दूध खुवाउनेछिन् भनेर अब्राहामलाई कसले भन्थ्यो होला? र पनि मैले उहाँको वृद्धावस्थामा उहाँका निम्ति एउटा छोरा जन्माएँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","जब बालक इसहाक बढ्दैगयो, तब तिनलाई दूध छुटाइयो; अनि दूध छुटाइएको त्यस दिन अब्राहामले एउटा ठूलो भोज लगाए। ");
INSERT INTO npioncb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","तर अब्राहामका निम्ति इजिप्टियन हागारले जन्माएकी छोराले आफ्नो छोरा इसहाकलाई ठट्टा गरिरहेको साराले देखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","यसकारण तिनले अब्राहामलाई भनिन्, “त्यो दासी र त्यसको छोरालाई निकालिदिनुहोस्; किनकि त्यसको छोरो मेरो छोरो इसहाकसित कहिल्यै उत्तराधिकारी हुन सक्दैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","यस कुराले अब्राहामलाई धेरै दुःखित तुल्यायो; किनकि यो कुरा आफ्नो छोरासित सम्बन्धित थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तर परमेश्‍वरले अब्राहामलाई भन्‍नुभयो, “त्यो बालक र तेरी दासीको विषयमा साराले भनेको कुरामा दुःख नमान्। साराले जे भन्छे, त्यो कुरा सुन्; किनकि इसहाकबाट नै तेरो वंशको नाम रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","म तेरी दासीको छोरालाई पनि एउटा ठूलो जाति बनाउनेछु; किनकि त्यो पनि तेरै सन्तान हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","तब अब्राहाम बिहानै उठे, र हागारलाई केही भोजन र एक मशक पानी दिए। ती सामानहरू हागारका काँधमा राखिदिएर अब्राहामले त्यो र त्यसको बालकलाई पठाइदिए। अनि त्यो त्यहाँबाट निस्केर गई, र बेर्शेबाका मरुभूमिहुँदो भौँतारिन थाली। ");
INSERT INTO npioncb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","जब मशकको पानी सकियो; तब त्यसले आफ्नो छोरालाई एउटा झाडीमुनि राखी। ");
INSERT INTO npioncb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","तब त्यो एक काँड हान्‍ने जतिको दूरीमा गएर बसी, र, “म यो बालक मरेको हेर्न सक्दिनँ” भन्दै जोड-जोडले रुन थाली। ");
INSERT INTO npioncb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","तब परमेश्‍वरले त्यो बालक रोइरहेको सुन्‍नुभयो; अनि याहवेहका दूतले स्वर्गबाट हागारलाई बोलाएर भने, “हागार, के भयो? नडरा; किनकि त्यो बालक जहाँबाट रोइरहेको छ, त्यहीँबाट परमेश्‍वरले त्यसको सोर सुन्‍नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","त्यस बालकलाई उठा, र त्यसको हात पक्री; किनकि म त्यसलाई एउटा ठूलो जाति बनाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","तब परमेश्‍वरले तिनका आँखा खोलिदिनुभयो; अनि त्यसले पानीको एउटा इनार देखी। तब तिनी गई, र मशकमा पानी भरेर त्यस बालकलाई पिउन दिई। ");
INSERT INTO npioncb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","जब त्यो बालक बढ्दैगयो; परमेश्‍वर त्यससित हुनुहुन्थ्यो। त्यो मरुभूमिमा बस्थ्यो; र एउटा धनुर्धारी बन्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","त्यो पारानको मरुभूमिमा बस्थ्यो, तब त्यसकी आमाले इजिप्टबाट त्यसका निम्ति एउटी पत्नी ल्याइदिई। ");
INSERT INTO npioncb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","त्यस बेला अबीमेलेक र तिनका सेनाका सेनापति पीकोलले अब्राहामलाई भने, “तपाईंले गरेका सबै कुराहरूमा परमेश्‍वर तपाईंको साथमा हुनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","अब परमेश्‍वरको सामु मसित शपथ खानुहोस्; तपाईंले मसित र मेरा छोराछोरीहरू अथवा मेरा सन्तानहरूसित झूटो व्यवहार गर्नुहुनेछैन। तर जसरी मैले तपाईंलाई दया देखाएँ, त्यसरी नै तपाईंले पनि मसँग र अहिले तपाईं विदेशी भएर बस्‍नुभएको देशलाई दया देखाउनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहामले भने, “हुन्छ, म यो शपथ खान्छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","तब अब्राहामले अबीमेलेकका सेवकहरूले अब्राहामका सेवकहरूबाट पानीको कुवा खोसेको विषयमा तिनीसित गुनासो पोखे, ");
INSERT INTO npioncb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","तर अबीमेलेकले भने, “यो काम कसले गरेको हो, सो म जान्दिनँ। तपाईंले मलाई भन्‍नुभएन, र आज मात्र मैले यस विषयमा सुनेँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","यसकारण अब्राहामले केही भेडा र गाईबस्तुहरू ल्याएर अबीमेलेकलाई दिए; अनि ती दुवैले करार बाँधे। ");
INSERT INTO npioncb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामले सात वटा भेडाका पाठीहरू बगालबाट अलग पारे, ");
INSERT INTO npioncb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अनि अबीमेलेकले अब्राहामलाई सोधे, “तपाईंले यी सात वटा पाठीहरू अलग राख्नुभएको अर्थ के हो?” ");
INSERT INTO npioncb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","तिनले जवाफ दिए, “यो कुवा मैले खनेको हुँ भन्‍ने प्रमाण होऊन् भनी यी सात वटा पाठीहरू मेरा हातबाट स्वीकार गर्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","यसकारण त्यस ठाउँलाई बेर्शेबा भनियो; किनकि ती दुवैले त्यहाँ शपथ खाएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","बेर्शेबामा करार बाँधेपछि अबीमेलेक र तिनका सेनापति पीकोल पलिश्तीहरूको देशमा फर्के। ");
INSERT INTO npioncb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामले बेर्शेबामा एउटा झ्याउको बोट रोपे, र त्यहाँ तिनले याहवेह अनन्तका परमेश्‍वरको नाममा पुकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अनि अब्राहाम केही समयसम्म पलिश्तीहरूको देशमा बसोबास गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","केही समयपछि परमेश्‍वरले अब्राहामलाई जाँच गर्नुभयो। उहाँले तिनलाई बोलाउनुभयो, “अब्राहाम!” तिनले जवाफ दिए, “हजुर, म यहाँ छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","तब परमेश्‍वरले भन्‍नुभयो, “तैँले माया गरेको, तेरो एक मात्र छोरा, इसहाकलाई लिएर मोरीयाहको भूमिमा जा। म तँलाई जुन डाँडा देखाउनेछु, त्यहाँ त्यसलाई होमबलिको रूपमा चढा।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","भोलिपल्ट बिहानै अब्राहाम उठे, र आफ्नो गधामा काठी कसे। अनि तिनले सेवकहरूमध्ये दुई जनालाई र आफ्नो छोरा इसहाकलाई आफ्नो साथमा लगे। तिनले होमबलिका निम्ति पर्याप्‍त दाउरा काटिसकेपछि परमेश्‍वरले तिनलाई भन्‍नुभएको त्यस ठाउँतिर हिँडे। ");
INSERT INTO npioncb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तेस्रो दिनमा अब्राहामले आँखा उठाएर हेरे, र टाढैबाट त्यस ठाउँलाई देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","तब अब्राहामले आफ्ना सेवकहरूलाई भने, “म र यो केटो अलिक पर जानेछौँ, र तिमीहरूचाहिँ यहीँ गधासँग बस। हामी आराधना गर्नेछौँ, र तिमीहरूकहाँ फर्केर आउनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहामले होमबलिको दाउरा उठाए र आफ्नो छोरा इसहाकलाई त्यो बोक्न लगाए; अनि तिनी आफूले चाहिँ आगो र छुरी बोके। ती दुई जब सँगै जाँदैथिए, ");
INSERT INTO npioncb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","तब इसहाकले आफ्ना बुबा अब्राहामलाई भने, “बुबा!” अब्राहामले जवाफ दिए, “भन्, मेरो छोरा!” इसहाकले भने, “आगो र दाउरा त यहाँ छन्, तर होमबलिका लागि थुमाचाहिँ कहाँ छ त?” ");
INSERT INTO npioncb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहामले जवाफ दिए, “हेर् छोरा, परमेश्‍वरले नै होमबलिको निम्ति थुमा जुटाइदिनुहुनेछ।” त्यसपछि ती दुवै सँगसँगै हिँड्दै अगि बढे। ");
INSERT INTO npioncb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","जब तिनीहरू परमेश्‍वरले भन्‍नुभएको त्यस ठाउँमा आइपुगे, तब अब्राहामले त्यहाँ एउटा वेदी बनाए; र त्यसमाथि दाउरा मिलाएर राखे। अनि तिनले आफ्नो छोरा इसहाकलाई बाँधे, र वेदीमा दाउरामाथि राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","तब अब्राहामले आफ्नो छोरालाई मार्न भनी हात छुरीतिर अगि बढाए। ");
INSERT INTO npioncb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तर स्वर्गबाट याहवेहका दूतले तिनलाई यसो भनेर बोलाए, “अब्राहाम! ए अब्राहाम!” तिनले जवाफ दिए, “हजुर, म यहाँ छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","अनि उनले भने, “त्यस केटामाथि हात नउठा। त्यसलाई केही नगर्। तँ परमेश्‍वरको डर मान्‍ने मानिस रहेछस् भनी अब मलाई थाहा भयो; किनकि आफ्नो एक मात्र छोरालाई बलिदान चढाउनदेखि तँ पछि हटिनस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","तब त्यही समय अब्राहामले नजिकै झाडीमा सिङ अल्झेर बसेको एउटा साँढ-भेडा देखे। त्यसपछि तिनले त्यस भेडालाई ल्याए; अनि त्यसलाई आफ्नो छोराको सट्टामा होमबलिको रूपमा चढाए। ");
INSERT INTO npioncb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","यसकारण अब्राहामले त्यस ठाउँलाई “याहवेह-यिरे” भनेर नाम राखे; अनि आजसम्म “याहवेहको पर्वतमा जुटाइनेछ” भन्‍ने चलन छ। ");
INSERT INTO npioncb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","तब याहवेहका दूतले स्वर्गबाट अब्राहामलाई दोस्रोपल्ट बोलाए, ");
INSERT INTO npioncb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","र भने, “मैले आफ्नै नाममा शपथ खाएको छु, भनी याहवेह घोषणा गर्नुहुन्छ, कि तैँले यो काम गरेको छस्, र तैँले आफ्नो एक मात्र छोरालाई मबाट नरोकेको कारण, ");
INSERT INTO npioncb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","म निश्‍चय तँलाई आशिष् दिनेछु; अनि तेरा सन्तानहरूलाई आकाशका ताराझैँ र समुद्रको किनारका बालुवाजस्तै असंख्य वृद्धि गर्नेछु। तेरा सन्तानहरूले आफ्ना शत्रुहरूका सहरहरू अधिकारमा लिनेछन्; ");
INSERT INTO npioncb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","अनि तेरा सन्तानहरूद्वारा पृथ्वीका सबै राष्ट्रहरूले आशिष् पाउनेछन्; किनकि तैँले मेरो आज्ञापालन गरेको छस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","तब अब्राहाम आफ्ना सेवकहरूकहाँ फर्केर आए; अनि तिनीहरूसँगै बेर्शेबातिर गए, र तिनी बेर्शेबामै बस्‍न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","केही समयपछि अब्राहामकहाँ यस्तो खबर आयो, “मिल्का पनि आमा भइन्; तिनले तपाईंका दाजु नाहोरका निम्ति छोराहरू जन्माएकी छिन्: ");
INSERT INTO npioncb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","जेठोको नाम ऊज र माहिलोको नाम बूज; अनि साहिँलोको नाम कमूएल (अरामका पिता) हो; ");
INSERT INTO npioncb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","अरू छोराहरूका नाम केसेद, हजो, पिलदाश, यिदलाप र बतूएल हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बतूएल रिबेकाका पिता भए। ");
INSERT INTO npioncb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोरकी उपपत्नीको नाम रूमा थियो; तिनले पनि छोराहरू जन्माइन्: तिनीहरूका नाम तेबह, गहम, तहस र माका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एक सय सत्ताइस वर्षसम्म बाँचिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","अनि कनान देशको किर्यत-अर्बामा (अर्थात्, हेब्रोनमा) तिनको मृत्यु भयो। अनि अब्राहाम साराका निम्ति विलाप गर्न र उनका निम्ति शोक गर्नलाई त्यहाँ गए। ");
INSERT INTO npioncb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","अब्राहाम आफ्नी पत्नीको शव भएको ठाउँबाट उठे, र हित्तीहरूलाई भने, ");
INSERT INTO npioncb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“म तपाईंहरूको बीचमा एक विदेशी र प्रवासी हुँ। तपाईंहरूको सानो टुक्रो जमिन चिहानको लागि मलाई बेच्नुहोस्, ताकि मेरो मृतकलाई गाड्न सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","तब हित्तीहरूले अब्राहामलाई भने, ");
INSERT INTO npioncb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“हे प्रभु, हाम्रो कुरा सुन्‍नुहोस्! तपाईं हाम्रो बीचमा परमेश्‍वरका राजकुमार हुनुहुन्छ। त्यसकारण हाम्रा चिहानहरूमध्ये सबैभन्दा असलचाहिँ छानेर त्यहीँ आफ्नो मृतकलाई गाड्नुहोस्। हाम्रो चिहानमा तपाईंको मृतकलाई गाड्न दिन हामी कसैले पनि इन्कार गर्नेछैनौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","तब अब्राहाम उठेर त्यस देशका मानिस, हित्तीहरूको अगि निहुरिए। ");
INSERT INTO npioncb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","अनि तिनले उनीहरूलाई भने, “यदि तपाईंहरूले मेरो पत्नीको शवलाई गाड्न ठाउँ दिने इच्छा गर्नुभएको हो भने मेरो कुरा सुनिदिनुहोस्, र सोहोरको छोरा एप्रोनसित मेरा निम्ति बिन्ती गरिदिनुहोस्, ");
INSERT INTO npioncb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","अनि उनले आफ्नो जमिनको अन्तिममा भएको मक्पेलाको ओडार मलाई बेचून्। तपाईंहरूको बीचमा चलिआएको पूरा मूल्यमा त्यो चिहानको रूपमा मलाई बेचून् भनी उनलाई भनिदिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","सहरको मूलढोकामा हित्तीहरू आएका थिए; अनि हित्तीहरूका बीचमा एप्रोन पनि त्यहीँ बसिरहेका थिए। अनि सबैले सुन्‍ने गरी एप्रोनले अब्राहामलाई जवाफ दिए; ");
INSERT INTO npioncb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","उनले भने, “होइन, मेरा प्रभु, मेरो कुरा सुन्‍नुहोस्; म तपाईंलाई जमिन दिने मात्र होइन, तर त्यसमा भएको ओडारसमेत दिन्छु। त्यो मेरा मानिसहरूको उपस्थितिमा तपाईंलाई दिन्छु। आफ्नो मृतकलाई त्यहीँ गाड्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","फेरि अब्राहाम त्यस देशका मानिसहरूको सामु निहुरिए। ");
INSERT INTO npioncb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","तब तिनले सबैले सुन्‍ने गरी एप्रोनलाई भने, “तपाईंले चाहनुहुन्छ भने मेरो कुरा सुन्‍नुहोस्। म जमिनको मूल्य तिर्नेछु। यो मबाट स्वीकार गर्नुहोस्, र मेरो मृतकलाई त्यहीँ गाड्न सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोनले अब्राहामलाई जवाफ दिए, ");
INSERT INTO npioncb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे मेरा प्रभु, मेरो कुरा सुन्‍नुहोस्; त्यस जमिनको दाम चाँदीको चार सय शेकेल मात्र हो; तर तपाईं र मेरो बीचमा मूल्यको के कुरा र? तपाईं आफ्नो मृतकलाई गाड्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","हित्तीहरूले सुन्‍ने गरी एप्रोनले राखेको शर्त अब्राहामले स्वीकार गरे; अनि त्यस बेलाका व्यापारीहरूका बीचमा चल्ने मुद्राको तौलअनुसार तिनले चाँदीको चार सय शेकेल एप्रोनले तोकेको मूल्यअनुसार चुक्ता गरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","यसरी मम्रेको छेउमा भएको एप्रोनको मक्पेलाको जमिन—अर्थात् जमिन र ओडार दुवै जमिनको सिमानामा भएका सबै रूखहरूलाई ");
INSERT INTO npioncb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","सहरको मूलढोकामा आएका सबै हित्तीहरूको उपस्थितिमा अब्राहामको सम्पत्तिको रूपमा पक्‍का गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","त्यसपछि कनान देशमा भएको मम्रे अर्थात् हेब्रोनको छेउमा भएको मक्पेलामा भएको ओडारमा अब्राहामले आफ्नी पत्नी सारालाई गाडे। ");
INSERT INTO npioncb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","यसरी त्यो जमिन र त्यसमा भएको ओडारलाई चिहानको रूपमा हित्तीहरूद्वारा अब्राहामको नाममा दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम अब धेरै वृद्ध भइसकेका थिए; अनि याहवेहले तिनलाई सबै कुरामा आशिष् दिनुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","तिनले आफ्नो घरानाको आफ्नो सबैभन्दा पुरानो सेवकलाई भने, जसले अब्राहामका सबै कुराको हेरचाह गर्थ्यो, “मेरो तिघ्रामुनि आफ्नो हात राख्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","अनि म तँलाई स्वर्ग र पृथ्वीका याहवेह परमेश्‍वरको नाममा शपथ खान लगाउँछु; अहिले म बसोबास गर्दैआएको कनानीहरूका छोरीहरूमध्येबाट मेरा छोराको निम्ति पत्नी नल्याउनू, ");
INSERT INTO npioncb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","तर तैँले मेरै देश र मेरै कुटुम्बकहाँ गएर मेरो छोरा इसहाकका निम्ति एउटी पत्नी ल्याउनू।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","त्यस सेवकले तिनलाई सोध्यो, “यदि ती स्त्री मसँग यस देशमा आउन राजी भइनन् भने म के गरूँ? के मैले तपाईंको छोरालाई तपाईं जुन देशबाट आउनुभयो, त्यही देशमा फर्काएर लैजानुपर्छ?” ");
INSERT INTO npioncb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहामले भने, “अहँ, हुँदैन। यो पक्‍का गर्, कि तैँले मेरो छोरालाई त्यहाँ फेरि फर्काएर नलैजानू! ");
INSERT INTO npioncb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","मलाई मेरा पिताको घरानाबाट र मेरो जन्मस्थलबाट बाहिर निकालेर ल्याउनुहुने, र मसित बोलेर ‘तेरो सन्तानलाई म यो देश दिनेछु’ भन्दै मसँग शपथमा प्रतिज्ञा गर्नुहुने स्वर्गका परमेश्‍वर, याहवेहले नै तेरो अगि-अगि दूत पठाउनुहुनेछ; अनि तैँले मेरो छोराका निम्ति त्यहीँबाट एउटी पत्नी ल्याउनेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","यदि ती स्त्री तँसित आउन चाहिनन् भने तँ मसित खाएको शपथबाट स्वतन्त्र हुनेछस्। तर याद राख्, मेरो छोरालाई चाहिँ फेरि त्यहाँ फर्काएर नलैजानू।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","यसकारण त्यस सेवकले आफ्ना मालिक अब्राहामको तिघ्रामुनि हात राख्यो, र यस विषयमा तिनीसित शपथ खायो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","तब त्यस सेवकले आफ्ना मालिकका दश वटा ऊँटहरूमा सबै किसिमका असल थोकहरूका सौगात लादेर हिँड्यो। अनि त्यो सेवक अराम-नहरैमतिर गयो, र नाहोर भन्‍ने नगरतिर बाटो लाग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","उसले नगरको बाहिर एउटा इनारको छेउमा आफ्ना ऊँटहरूलाई घुँडा टेकाएर बसायो; साँझ पर्ने बेला भएकोले स्त्रीहरू पानी भर्नका लागि इनारमा आउने बेला भएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","तब त्यसले प्रार्थना गर्‍यो, “हे याहवेह! मेरा मालिक अब्राहामका परमेश्‍वर, मलाई आज सफलता दिनुहोस्, र मेरा मालिक अब्राहाममाथि दया देखाउनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","हेर्नुहोस्, म यस पानीको इनारनेर उभिरहेको छु; अनि यस नगरबासीका छोरीहरू पानी भर्न आउँदैछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","यसकारण यस्तो होस्: जुन केटीलाई ‘तिम्रो गाग्रो मतिर ढल्काइदेऊ, र म पानी पिउन पाऊँ,’ भनेर भनुँला र जसले ‘पिउनुहोस्, र म तपाईंका ऊँटहरूलाई पनि पिउन दिनेछु’ भनी भन्ली, त्यहीचाहिँ तपाईंले आफ्ना सेवक इसहाकका निम्ति चुन्‍नुभएको होस्। यसैबाट तपाईंले मेरा मालिकप्रति दया देखाउनुभएको छ भनी म जान्‍नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","उसले प्रार्थना गरिसक्नुभन्दा पहिल्यै रिबेका आफ्नो काँधमा गाग्रो बोकेर आइपुगिन्, जोचाहिँ अब्राहामका भाइ नाहोरकी पत्नी मिल्काका छोरा बतूएलकी छोरी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","तिनी असाध्यै राम्री थिइन्, र कुनै मानिससँग कहिल्यै पनि सहवास नभएकी कन्या थिइन्। तिनी ओर्लेर इनारमा गइन्, र आफ्नो गाग्रो भरेर फेरि माथि आइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","त्यो सेवक दगुर्दै तिनलाई भेट्न गयो र भन्यो, “कृपया मलाई तिम्रो गाग्रोबाट अलिकति पानी पिउन देऊ।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","अनि तिनले भनिन्, “हुन्छ, पिउनुहोस्, मेरा प्रभु!” अनि तिनले गाग्रोलाई आफ्नो हातमा ओरालिन्, र उसलाई पिउन दिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","उसलाई पिउन दिइसकेपछि तिनले भनिन्, “म तपाईंका ऊँटहरूलाई पनि तिनीहरूले अघाउन्जेल पानी उघाएर दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","यसरी तिनले चाँडो गरी आफ्नो गाग्रोको पानी डुँडमा खन्याइन्, र अझ धेरै पानी उघाउन इनारतिर दगुरिन्; अनि उसका सबै ऊँटहरूको लागि प्रशस्त पानी उघाइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ती सेवकचाहिँ केही नबोली रिबेकालाई हेरिरहे। अनि कतै याहवेहले आफ्नो यात्रा सफल बनाउनुभएको त होइन भन्‍ने कुरा मनन गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","जब ऊँटहरूले पानी पिइसके, तब त्यस मानिसले आधा बेका तौलको सुनको एउटा नत्थ र दश शेकेल तौलको दुई वटा बाला झिक्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","तब उसले सोध्यो, “कृपया मलाई भन, तिमी कसकी छोरी हौ? के तिम्रा बुबाको घरमा हामीलाई बास बस्‍नका निम्ति ठाउँ छ?” ");
INSERT INTO npioncb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","उनले त्यसलाई जवाफ दिइन्, “म मिल्काका छोरा बतूएलकी छोरी हुँ, जसलाई मिल्काले नाहोरका लागि जन्माएकी थिइन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","अनि उनले अझै भनिन्, “हामीसित पर्याप्‍त पराल र दाना छन्, साथै तपाईंलाई बास बस्‍नको लागि ठाउँ पनि छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","तब त्यस मानिसले घोप्टो परेर याहवेहको आराधना गर्‍यो, ");
INSERT INTO npioncb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","र भन्यो, “मेरा मालिक अब्राहामका परमेश्‍वर, याहवेहको प्रशंसा होस्, जसले मेरा मालिकप्रति आफ्नो दया र विश्‍वासयोग्यता त्याग्नुभएको छैन। म बाटोमा छँदै याहवेहले मेरा मालिकका कुटुम्बको घरानातिरको यात्रामा मलाई अगुवाइ गरेर ल्याउनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब रिबेका दगुरेर गइन् र आफ्नी आमाको घरानालाई यी सबै कुराहरू बताइदिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","तिनका लाबान नाम भएका एक जना दाजु थिए; उनले नाकमा नत्थ र आफ्नी बहिनीका हातमा बाला देख्नासाथै, र रिबेकाले त्यस मानिसले उनलाई भनेका कुरा सुन्‍नसाथ लाबान त्यस मानिसलाई भेट्न बाहिर निस्किहाले, र त्यसलाई इनारको छेउमा ऊँटहरूसित उभिरहेका देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","अनि उनले भने, “हे याहवेहका धन्य जन, भित्र आउनुहोस्! तपाईं किन बाहिर उभिरहनुहुन्छ? मैले तपाईंका निम्ति घर र ऊँटहरूका निम्ति ठाउँ तयार पारेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","यसकारण त्यो मानिस लाबानसित घरभित्र गयो; अनि ऊँटहरूबाट भारी उतारियो। ऊँटहरूका निम्ति पराल र दाना दिइयो; अनि लाबानले त्यो मानिस र त्योसँग आएका मानिसहरूका निम्ति गोडा धुन पानी दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","तब त्यसको सामु भोजन राखियो; तर त्यसले भन्यो, “जबसम्म मैले तपाईंहरूलाई भन्‍नुपर्ने कुरा भन्दिनँ, तबसम्म म केही खानेछैनँ।” तब लाबानले भने, “हुन्छ, के कुरा हो, भन्‍नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","यसकारण त्यसले भन्यो, “म अब्राहामको सेवक हुँ। ");
INSERT INTO npioncb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","याहवेहले मेरा मालिकलाई प्रशस्त आशिष् दिनुभएको छ। याहवेहले उहाँलाई भेडाबाख्रा, गाईबस्तु, सुन, चाँदी, सेवक-सेविका, ऊँट र गधाहरू दिनुभएको छ, र उहाँलाई धेरै धनी बनाउनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","मेरा मालिककी पत्नी साराले आफ्नो वृद्धावस्थामा अब्राहामका निम्ति एउटा छोरा जन्माउनुभयो; अनि अब्राहामले उनलाई आफूसित भएका सबै थोक दिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","अनि मेरा मालिकले मलाई शपथ खान लगाएर यसो भन्‍नुभयो, ‘तैँले म बसेको कनानीहरूका छोरीहरूबाट मेरो छोराका निम्ति पत्नी नल्याउनू, ");
INSERT INTO npioncb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","तर मेरा पिताका घरानामा, मेरो आफ्नै वंशमा जानू, र मेरो छोराका लागि एउटी पत्नी ल्याउनू।’ ");
INSERT INTO npioncb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“तब मैले मेरा मालिकलाई सोधेँ, ‘यदि त्यो स्त्री मसँग आउन मानिन भने?’ ");
INSERT INTO npioncb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“तिनले जवाफ दिए, ‘म जुन याहवेहको सामु विश्‍वासयोग्य भएर हिँड्छु, उहाँले नै आफ्ना दूतलाई तँसित पठाउनुहुनेछ र तेरो यात्रा सफल तुल्याउनुहुनेछ; अनि तैँले मेरा आफ्नै वंश र मेरा पिताको घरानाबाट मेरा छोराका निम्ति एउटी पत्नी ल्याउनेछस्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","यदि तँ मेरो वंशकहाँ गइस्, तर तिनलाई माग्दा तिनीहरूले तँलाई दिन मानेनन् भने तँ मेरो शपथबाट स्वतन्त्र हुनेछस्।’ ");
INSERT INTO npioncb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“जब म आज यस इनारमा आइपुगेँ, र मैले भनेँ, ‘हे याहवेह! मेरा मालिक अब्राहामका परमेश्‍वर, तपाईंको इच्छा भएमा दया गरी मेरो यात्रा सफल गराइदिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","हेर्नुहोस्, म यस इनारको छेउमा उभिरहेको छु। अनि यस्तो होस्: यदि कुनै कन्या पानी भर्न आउँदा मैले तिनलाई भनेँ, “कृपया मलाई तिम्रो गाग्रोबाट केही पानी पिउन देऊ,” ");
INSERT INTO npioncb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","अनि यदि उसले मलाई “पिउनुहोस्, र म तपाईंका ऊँटहरूका निम्ति पनि पानी उघाएर दिनेछु,” भन्ली, तब त्यही स्त्री याहवेहले मेरा मालिकका छोराका निम्ति चुन्‍नुभएको होस्।’ ");
INSERT INTO npioncb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“मैले आफ्नो हृदयमा प्रार्थना गरी नसक्दै रिबेका आफ्नो गाग्रो काँधमा बोकेर आइन्। अनि तिनले इनारमा ओर्लेर पानी उघाइन्; तब मैले तिनलाई भनेँ, ‘मलाई अलिकति पानी पिउन देऊ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“उनले तुरुन्तै आफ्नो काँधबाट गाग्रो तल झारिन् र भनिन्, ‘पिउनुहोस्, र म तपाईंका ऊँटहरूलाई पनि पिउन दिनेछु।’ यसकारण मैले पिएँ, र तिनले ऊँटहरूलाई पनि पानी पिउन दिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“मैले उनलाई सोधेँ, ‘तिमी कसकी छोरी हौ?’ “उनले भनिन्, ‘म नाहोरका छोरा बतूएलकी छोरी हुँ, जसलाई मिल्काले जन्म दिनुभयो।’ “तब मैले उनको नाकमा नत्थ र हातमा बालाहरू लगाइदिएँ; ");
INSERT INTO npioncb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","अनि मैले घोप्टो परेर याहवेहलाई आराधना गरेँ। मैले याहवेह, मेरा मालिक अब्राहामका परमेश्‍वरको प्रशंसा गरेँ; जसले मेरा मालिकका छोराका निम्ति आफ्ना भाइकी नातिनी ल्याउनलाई ठिक बाटोमा डोर्‍याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","अब यदि तपाईंले मेरा मालिकप्रति दया र विश्‍वासयोग्यता देखाउनुहुन्छ भने मलाई भन्‍नुहोस्; अथवा हुन्‍न भने पनि मलाई भन्‍नुहोस्, र म कतातिर लाग्नुपर्ने हो भनी जान्‍न सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","तब लाबान र बतूएलले जवाफ दिए, “यो याहवेहबाट नै भएको हो; हामी तपाईंहरूलाई हो अथवा होइन केही भन्‍न सक्दैनौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","रिबेका तपाईंकै सामु छिन्; तिनलाई लिएर जानुहोस्! अनि याहवेहले निर्देशन गर्नुभएझैँ तिनलाई तपाईंका मालिकका छोराकी पत्नी हुन दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","तिनीहरूले भनेका कुरा अब्राहामका सेवकले सुनेपछि त्यसले भुइँमा निहुरिएर याहवेहलाई डण्दवत् गर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","तब त्यस सेवकले सुन, चाँदीका गरगहना र लुगाफाटाहरू निकाल्यो, र रिबेकालाई दियो; त्यसले तिनका दाजु र आमालाई पनि बहुमूल्य उपहारहरू दियो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","तब त्यो र त्योसँग आएका मानिसहरूले खानपिन गरे, र त्यो रात त्यहीँ बास बसे। जब तिनीहरू भोलिपल्ट बिहानै उठे, तब त्यसले भन्यो, “अब मेरा मालिककहाँ जानलाई बिदा दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","तर रिबेकाका दाजु र आमाले भने, “हाम्री छोरीलाई हामीसित दश दिन जति बस्‍न दिनुहोस्; अनि त्यसपछि तिनलाई लैजानुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","तर त्यसले तिनीहरूलाई भन्यो, “अब मलाई रोकेर नराख्नुहोस्; किनकि याहवेहले मेरो यात्रा सफल पार्नुभएको छ। मलाई बिदा दिनुहोस्, र म मेरा मालिककहाँ जान पाऊँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","तब तिनीहरूले भने, “हामी रिबेकालाई बोलाऔँ र यसबारे तिनैलाई सोधौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","तब तिनीहरूले रिबेकालाई बोलाएर सोधे, “के तिमी यस मानिससँग जान्छ्यौ?” उनले भनिन्, “अँ, म जान्छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","यसकारण तिनीहरूले आफ्नी बहिनी रिबेकालाई तिनकी धाईआमासँगै अब्राहामका सेवक र त्यसका मानिसहरूलाई बिदा दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","अनि तिनीहरूले रिबेकालाई आशिष् दिएर भने, “हाम्री बहिनी, तिमी हजारौँ हजारमा बढ्दै जाऊ; तिम्रा सन्तानले आफ्ना शत्रुहरूका सहरहरूमा अधिकार जमाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","तब रिबेका र तिनका सुसारेहरू तयार भए, र ऊँटमाथि चढे; अनि त्यस मानिसको पछि लागे। यसरी त्यस सेवकले रिबेकालाई लिएर गयो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","अब इसहाक बेअर-लहै-रोइबाट आएका थिए; किनकि त्यस बेला तिनी दक्षिणमा बस्दैथिए। ");
INSERT INTO npioncb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एक साँझ इसहाक ध्यान गर्न बाहिर खेतमा गए; अनि तिनले जब आँखा उठाएर हेरे, तब तिनले ऊँटको लस्कर आइरहेका देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबेकाले पनि आँखा उठाएर हेरिन्, र इसहाकलाई देखिन्। तिनी आफ्नो ऊँटबाट ओर्लिन्, ");
INSERT INTO npioncb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","अनि त्यस सेवकलाई सोधिन्, “हामीलाई भेट्न खेतबाट आउँदैगरेका ती मानिस को हुन्?” त्यस सेवकले जवाफ दियो, “उहाँ मेरा मालिक हुनुहुन्छ।” तब उनले घुम्टो हालेर आफ्नो मुहार छोपिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","तब त्यस सेवकले आफूले गरेका सबै कुराहरू इसहाकलाई भनिदियो। ");
INSERT INTO npioncb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","इसहाकले रिबेकालाई आफ्नी आमा साराको पालभित्र लिएर आए; अनि तिनलाई विवाह गरे। यसरी तिनी उनकी पत्नी भइन्; अनि तिनले उनलाई प्रेम गरे। यसरी इसहाकले आफ्नी आमाको मृत्युपछि सान्त्वना पाए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामले अर्की पत्नी पनि ल्याए, जसको नाम कतूरा थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","तिनले अब्राहामका निम्ति जिम्रान, योक्षान, मदान, मिद्यान, यिशबाक र शूहलाई जन्म दिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान शेबा र ददानका पिता थिए; ददानका वशंहरू अश्शूरीम, लतूशी र लऊम्मीहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यानका छोराहरू: एपा, एपेर, हनोक, अबीदा र एल्दा थिए। यी सबै कतूराका सन्तानहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहामले कमाएका सबै थोक इसहाकलाई छोडिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","तर अब्राहामले आफू जीवित छँदै आफ्नी उपपत्नीका छोराहरूलाई उपहारहरू दिएर तिनीहरूलाई आफ्ना पुत्र इसहाकदेखि टाढा पूर्वको देशमा पठाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम एक सय पचहत्तर वर्षसम्म बाँचे। ");
INSERT INTO npioncb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","तब अब्राहाम आफ्नो पूरा बुढेसकालमा, एक वृद्ध मानिस भएर र पूरा आयुमा तिनको मरे; अनि आफ्ना मानिसहरूसित मिल्न गए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","तिनका छोराहरू इसहाक र इश्माएलले तिनलाई हित्ती सोहोरको छोरा एप्रोनको खेतमा, मम्रेको छेउमा भएको मक्पेलाको ओडारमा गाडे; ");
INSERT INTO npioncb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","त्यो खेत अब्राहामले हित्तीहरूबाट किनेका थिए। त्यहाँ अब्राहाम आफ्नी पत्नी सारासँगै गाडिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहामको मृत्युपछि परमेश्‍वरले तिनका छोरा इसहाकलाई आशिष् दिनुभयो; अनि तिनी बेअर-लहै-रोइको नजिक बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","अब्राहामका छोरा इश्माएलको विवरण यही हो, जसलाई साराकी सेविका इजिप्टियन हागारले अब्राहामका निम्ति जन्माएकी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","जन्म क्रमअनुसार इश्माएलका छोराहरूका नाम यिनै हुन्: इश्माएलको जेठो छोरा नबायोत, केदार, अदबील, मिब्साम, ");
INSERT INTO npioncb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दुमा, मस्सा, ");
INSERT INTO npioncb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश र केदमा। ");
INSERT INTO npioncb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्माएलका छोराहरू यिनै हुन्, र बस्ती र छाउनीहरूअनुसार बाह्र कुलका शासकहरूका नाम यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल जम्मा एक सय सैँतीस वर्षसम्म बाँचे; त्यसपछि तिनको मृत्यु भयो, र आफ्ना मानिसहरूसँगै माटोमा मिल्न गए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","तिनका सन्ततिहरू अश्शूरतिरको इजिप्टको पूर्वी सिमाना छेउको हवीलादेखि शूरसम्मका ठाउँहरूमा बसोबास गरे। अनि तिनीहरू आफ्ना सबै दाजुभाइहरूसित दुश्मनी लिएर बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामका छोरा इसहाकको विवरण यही हो। अब्राहाम इसहाकका पिता भए; ");
INSERT INTO npioncb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","अनि पद्दन-अरामका अरामी बतूएलकी छोरी र अरामी लाबानकी बहिनी रिबेकासित विवाह हुँदा इसहाक चालीस वर्षका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","आफ्नी पत्नी बाँझी भएकाले उनको पक्षमा इसहाकले याहवेहसित प्रार्थना गरे। याहवेहले तिनको प्रार्थनाको जवाफ दिनुभयो, र तिनकी पत्नी रिबेका गर्भवती भइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","तिनको गर्भमा बालकहरूले एक-अर्कालाई ठेल्न थाले। “मलाई किन यस्तो भइरहेको छ?” भनी तिनले याहवेहलाई सोध्न गइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","तब याहवेहले तिनलाई भन्‍नुभयो, “तेरो गर्भमा दुई राष्ट्रहरू छन्, अनि तेरो पेटबाट दुई जातिहरू छुट्टिनेछन्; एउटा जाति अर्कोभन्दा बलियो हुनेछ; अनि जेठोले कान्छोको सेवा गर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","जब तिनको जन्माउने समय आयो; तिनको गर्भमा जुम्ल्याह बालकहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहिले निस्कने रातो वर्णको थियो; अनि त्यसको सम्पूर्ण शरीर रौँको वस्त्रझैँ थियो; र तिनीहरूले त्यसको नाम एसाव राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","त्यसपछि उनको भाइ जन्मियो; जसले एसावको कुर्कुच्‍चा समातेको थियो; यसकारण त्यसको नाम याकोब राखियो। रिबेकाले तिनीहरूलाई जन्माउँदा इसहाक साठी वर्ष पुगेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ती बालकहरू बढ्दै गए; अनि एसाव एउटा सिपालु शिकारी, खुला मैदानको मानिस भए; याकोबचाहिँ शान्त स्वभावका थिए, र तिनी पालमै बसिरहन्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाक शिकारको मासु खान रुचाउने हुनाले एसावलाई माया गर्थे; तर रिबेकाले चाहिँ याकोबलाई माया गर्थिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एकपल्ट याकोबले सुरुवा पकाइरहेका बेलामा एसाव खुला मैदानबाट साह्रै भोकाएर आए। ");
INSERT INTO npioncb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","एसावले याकोबलाई भने, “झट्टै मलाई त्यो रातो सुरुवा देऊ! म भोकले मर्नै लागेँ!” (त्यसैकारण तिनलाई एदोम पनि भनिन्थ्यो।) ");
INSERT INTO npioncb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकोबले जवाफ दिए, “पहिले आफ्नो ज्येष्‍ठ अधिकार मलाई बेच।” ");
INSERT INTO npioncb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसावले भने, “हेर, म त मर्नै लागेको छु। अब मेरो निम्ति ज्येष्‍ठ अधिकारको के काम?” ");
INSERT INTO npioncb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","तर याकोबले भने, “पहिले शपथ खाएर मलाई भन।” यसकारण तिनले शपथ खाए, र आफ्नो ज्येष्‍ठ अधिकार याकोबलाई बेचे। ");
INSERT INTO npioncb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याकोबले एसावलाई केही रोटी र दालको सुरुवा दिए। तिनले त्यो खाए, पिए, र उठेर गइहाले। यसरी एसावले आफ्नो ज्येष्‍ठ अधिकारलाई लत्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","अब अब्राहामको समयमा परेको अनिकालबाहेक त्यस देशमा फेरि अर्को अनिकाल पनि पर्‍यो; अनि इसहाक गरारमा भएका पलिश्तीहरूका राजा अबीमेलेककहाँ गए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","याहवेह इसहाककहाँ देखा पर्नुभयो र भन्‍नुभयो, “तल इजिप्टमा नजा; तर मैले तँलाई भनेकै देशमा गएर बस्। ");
INSERT INTO npioncb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","यस देशमा केही समय परदेशी भएर बस्, र म तँसित हुनेछु र तँलाई आशिष् दिनेछु। किनकि म तँलाई र तेरा सन्तानहरूलाई यी सबै देशहरू दिनेछु; र मैले तेरा पिता अब्राहामसित खाएको शपथ पूरा गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","म तेरा सन्तानहरूलाई आकाशमा भएका ताराझैँ असंख्य तुल्याउनेछु; अनि तिनीहरूलाई यी सबै देशहरू दिनेछु; र तेरै सन्तानद्वारा पृथ्वीका सबै जातिले आशिष् पाउनेछन्; ");
INSERT INTO npioncb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","किनकि अब्राहामले मेरो आज्ञापालन गर्‍यो, र मेरा आज्ञाहरू, मेरा उर्दीहरू र मेरा निर्देशनहरू पालन गर्दै मैले चाहेका सबै कुरा गर्‍यो।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","यसकारण इसहाक गरारमै बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","त्यस ठाउँका मानिसहरूले तिनलाई रिबेकाको विषयमा सोधपुछ गर्दा तिनले भने, “यिनी मेरी बहिनी हुन्; किनकि रिबेकाको कारण त्यस ठाउँका मानिसहरूले तिनलाई मार्लान् भन्‍ने सोचेर रिबेकालाई आफ्नी पत्नी भन्‍न तिनी डराए; किनकि रिबेका अत्यन्तै राम्री थिइन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब इसहाक त्यहाँ बसेको धेरै भइसकेको थियो, तब पलिश्तीहरूका राजा अबीमेलेकले झ्यालबाट तल हेरे, र तिनले इसहाकलाई आफ्नी पत्नी रिबेकासित प्रेमलाप गरिरहेका देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","यसकारण अबीमेलेकले इसहाकलाई बोलाएर भने, “यिनी त वास्तवमा तिम्री पत्नी रहिछिन्! मलाई तिमीले किन ‘यिनी मेरी बहिनी हुन्’ भन्यौ?” इसहाकले तिनलाई जवाफ दिए, “किनकि मेरी पत्नीको कारण मैले आफ्नो ज्यान गुमाउन पर्ला कि भनी मैले सोचेँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","तब अबीमेलेकले भने, “तिमीले हामीसँग यो के गर्‍यौ? यी मानिसहरूमध्ये कोही तिम्री पत्नीसित सुतेको भए तिमीले हामीमाथि दोष ल्याउनेथियौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","यसकारण अबीमेलेकले सबै मानिसहरूलाई यसो भनी आदेश दिए: “यी मानिस अथवा यिनकी पत्नीलाई हानि गर्ने व्यक्तिले निश्‍चय नै मृत्युदण्ड पाउनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकले त्यस देशमा अन्‍नबाली लगाए; अनि त्यही वर्ष तिनले सय गुणा कटनी गरे; किनकि याहवेहले तिनलाई आशिष् दिनुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","तिनी धनी भए, र तिनी अति धनाढ्य नहुन्जेल तिनको सम्पत्ति बढिरह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","तिनीसित यति धेरै बगाल, गाईबस्तु र सेवक-सेविकाहरू थिए, कि पलिश्तीहरूले तिनीसित डाह गर्न लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","यसकारण तिनका पिता अब्राहामको समयमा, तिनका पिताका सेवकहरूले खनेका सबै इनारहरू पलिश्तीहरूले माटोले पुरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","तब अबीमेलेकले इसहाकलाई भने, “हामीदेखि टाढा गइहाल; किनकि तिमी हाम्रो निम्ति अति शक्तिशाली भएका छौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","यसकारण इसहाक त्यहाँबाट टाढा सरे र गरारको बेँसीमा पाल टाँगेर त्यहीँ बसोबास गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","इसहाकका पिता अब्राहामको समयमा खनिएका इनारहरू तिनले फेरि खने, जुन अब्राहामको मृत्युपछि पलिश्तीहरूले पुरिदिएका थिए; अनि ती इनारहरूलाई तिनका पिताले दिएकै नामहरू दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाकका सेवकहरूले बेँसीमा खने, र त्यहाँ स्वच्छ पानीको एउटा इनार पत्ता लगाए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तर गरारका गोठालाहरूले इसहाकका गोठालाहरूसित झगडा गरेर भने, “यो पानी हाम्रो हो!” यसकारण तिनले त्यस इनारको नाम एसेक राखे; किनकि तिनीहरूले उनीहरूसित झगडा गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","तब तिनीहरूले अर्को इनार खने, तर तिनीहरूले त्यसका निम्ति पनि झगडा गरे; यसकारण तिनले त्यसको नाम सित्ना राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","तिनी त्यहाँबाट अझ अगि बढे, र अर्को इनार खने; अनि कसैले पनि त्यसका निम्ति झगडा गरेन। तिनले त्यसको नाम यसो भनेर रहोबोत राखे, “अब याहवेहले हामीलाई ठाउँ दिनुभएको छ र हामी यस देशमा उन्‍नति गर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","त्यहाँबाट तिनी बेर्शेबासम्म गए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","त्यस रात याहवेह तिनीकहाँ देखा परेर भन्‍नुभयो, “म तेरा पिता अब्राहामको परमेश्‍वर हुँ। नडरा, किनकि म तँसित छु; म तँलाई आशिष् दिनेछु र मेरा सेवक अब्राहामको खातिर म तेरो सन्तानको संख्या बढाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","इसहाकले त्यहाँ एउटा वेदी बनाए अनि याहवेहको आराधना गरे। त्यहाँ तिनले आफ्नो पाल टाँगे; अनि त्यहाँ तिनका सेवकहरूले एउटा इनार खने। ");
INSERT INTO npioncb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","त्यसै बेला गरारबाट अबीमेलेक आफ्ना व्यक्तिगत सल्‍लाहकार अहुज्जत र आफ्ना सेनाका सेनापति पीकोलसित तिनीकहाँ आए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाकले तिनीहरूलाई सोधे, “तपाईंहरूले मसित दुश्मनी गरेर मलाई धपाउनुभयो। अहिले तपाईंहरू किन मकहाँ आउनुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","तिनीहरूले जवाफ दिए, “तपाईंसित याहवेह हुनुभएको हामीले प्रष्‍टसँग देख्यौँ, र हामीले भन्यौँ, ‘तपाईंसित हाम्रो शपथसहितको वाचा गरिएको सम्झौता हुनुपर्नेथियो—हामी र तपाईंबीच।’ हामी तपाईंसँग एउटा सन्धि गर्न चाहन्छौँ, ");
INSERT INTO npioncb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ताकि हामीले तपाईंलाई हानि नगरी सधैँ तपाईंसित राम्रो व्यवहार गरेर शान्तिसित तपाईंलाई पठाइदिएझैँ, तपाईंले पनि हामीलाई कुनै हानि गर्नुहुनेछैन। अनि अहिले तपाईंले याहवेहद्वारा आशिष् पाउनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","तब इसहाकले तिनीहरूका निम्ति भोज तयार पारे, र तिनीहरूले खाए र पिए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","अर्को दिन बिहानै ती मानिसहरूले एक-अर्कासित शपथ खाए। तब इसहाकले तिनीहरूलाई आफ्नो बाटो लगाइदिए; अनि तिनीहरू शान्तिसित गए। ");
INSERT INTO npioncb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","त्यस दिन इसहाकका सेवकहरूले तिनलाई उनीहरूले खनेको इनारको विषयमा बताए। तिनीहरूले भने, “हामीले पानी भेट्टाएका छौँ!” ");
INSERT INTO npioncb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","तब तिनले त्यसको नाम शिबा राखे। आजसम्म नै त्यस नगरको नाम बेर्शेबा भनिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसाव चालीस वर्षको हुँदा हित्ती बेरीकी छोरी यूदीतलाई र हित्ती एलोनकी छोरी बासमतलाई पनि विवाह गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","तर यी स्त्रीहरू इसहाक र रिबेकाका निम्ति सन्तापको स्रोत भए। ");
INSERT INTO npioncb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक वृद्ध भइसकेका थिए, र तिनका आँखा पनि देख्न नसक्ने गरी कमजोर भए; तब तिनले आफ्ना जेठा छोरा एसावलाई बोलाएर भने, “मेरो छोरा।” तिनले जवाफ दिए, “हजुर, म यहाँ छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाकले भने, “हेर्, म वृद्ध भइसकेको छु; कुन दिन मरिने हो, थाहा छैन। ");
INSERT INTO npioncb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","त्यसैले अब तेरो हतियार—अर्थात् तेरो काँडको ठोक्रो र धनु लिएर खुला खेतमा जा, र मेरो निम्ति एउटा पशु शिकार गरेर ले। ");
INSERT INTO npioncb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मलाई मनपर्ने स्वादिलो भोजन बना, म त्यो खान्छु, र म मर्नुभन्दा अगि तँलाई आशिष् दिन्छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","अब इसहाकले आफ्नो छोरा एसावसित कुरा गर्दैगर्दा रिबेकाले सुनिरहेकी थिइन्; तब एसाव खुला मैदानमा शिकार गरेर ल्याउन भनेर हिँडे। ");
INSERT INTO npioncb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","त्यसपछि रिबेकाले आफ्ना छोरा याकोबलाई भनिन्, “हेर्, तेरा बुबाले तेरा दाजु एसावलाई यसो भन्दै गर्नुभएको मैले सुनेँ, ");
INSERT INTO npioncb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘मेरो लागि शिकार गरेर ले, र मेरो निम्ति स्वादिष्‍ठ भोजन तयार गर्, र म मर्नुभन्दा अगि याहवेहको उपस्थितिमा मेरो आशिष् तँलाई दिन्छु।’ ");
INSERT INTO npioncb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","त्यसैले मेरो छोरा, ध्यानपूर्वक सुन्, र म तँलाई जे भन्छु, सो कुरा गर्! ");
INSERT INTO npioncb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","अब बगाल भएको ठाउँमा जा, र दुई वटा असल पाठा चुनेर ले; ताकि म तेरा बुबाका निम्ति मनपर्ने स्वादिष्‍ठ भोजन बनाइदिन सकूँ। ");
INSERT INTO npioncb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","तब त्यो लगेर तेरा बुबालाई खान दे, र मर्नुभन्दा अगि तिनले आफ्नो आशिष् तँलाई देऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकोबले आफ्नी आमा रिबेकालाई भने, “तर मेरा दाजु एसाव शरीरभरि रौँ नै रौँ भएका मानिस हुन्; अनि मचाहिँ चिल्‍लो छाला भएको मानिस हुँ। ");
INSERT INTO npioncb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","मेरा बुबाले मलाई छाम्नुभयो भने के गर्ने? मैले त उहाँलाई छल गरेजस्तो हुन्छ; तब ममाथि आशिष्‌को साटो श्राप पो आइपर्ला।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","तिनकी आमाले तिनलाई भनिन्, “मेरो छोरा, त्यो श्राप मैमाथि परोस्; म जे भन्छु, तैँले त्यही गर्; जा र ती मेरा निम्ति लिएर आइज।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","त्यसपछि याकोब गए, र ती पाठा आफ्नी आमाकहाँ लिएर आए; अनि उनकी आमाले उनका बुबाले मनपर्ने स्वादिष्‍ठ भोजन तयार पारिदिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","तब रिबेकाले तिनको घरमा भएका आफ्ना जेठा छोरा एसावका राम्रा-राम्रा लुगा ल्याएर आफ्ना कान्छा छोरा याकोबलाई लगाइदिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","तिनले याकोबको हात र घाँटीको चिल्‍लो भागमा पाठाका छालाले ढाकिदिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","तब आफूले तयार पारेको स्वादिष्‍ठ भोजन र रोटी तिनले आफ्नो छोरा याकोबको हातमा दिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","तिनी आफ्ना बुबाकहाँ गएर भने, “बुबा!” तिनले जवाफ दिए, “भन् मेरो छोरा, तँ को होस्?” ");
INSERT INTO npioncb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकोबले आफ्ना बुबालाई भने, “म तपाईंको जेठो छोरा एसाव हुँ। मैले तपाईंले भन्‍नुभएझैँ गरेको छु। कृपया बस्‍नुहोस्, र मैले शिकार गरेर ल्याएको भोजन खानुहोस्; र मलाई आफ्नो आशिष् दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाकले आफ्नो छोरालाई सोधे, “मेरो छोरा, तैँले कसरी यति चाँडो शिकार भेट्टाइस् र?” याकोबले जवाफ दिए, “मलाई तपाईंका याहवेह परमेश्‍वरले नै सफलता दिनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब इसहाकले याकोबलाई भने, “मेरो छोरा, मेरो नजिक आइज, र तँ साँच्‍चै मेरो छोरा एसाव होस् कि होइनस् भनी म तँलाई छामेर जान्‍न सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याकोब आफ्नो बुबा इसहाकको छेवैमा गए; अनि तिनले उनलाई छोएर भने, “सोरचाहिँ याकोबको हो, तर हातहरूचाहिँ एसावकै हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","याकोबका हातहरू तिनका दाजु एसावका हातहरूजस्ता रौँ नै रौँ भएका हुनाले इसहाकले तिनलाई चिनेनन्। तब इसहाक याकोबलाई आशिष् दिन अगि बढे। ");
INSERT INTO npioncb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","इसहाकले तिनलाई सोधे, “के तँ साँच्‍चै मेरो छोरा एसाव नै होस् त?” तिनले जवाफ दिए, “हो, म उही हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब तिनले भने, “मेरो छोरा, मलाई तेरो शिकारबाट खानलाई केही दे, र म तँलाई मेरो आशिष् दिन सकूँ।” अनि याकोबले त्यो तिनीकहाँ ल्याए, र तिनले खाए; अनि उनले केही दाखमद्य पनि ल्याए, र तिनले पिए। ");
INSERT INTO npioncb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","तब उनका बुबा इसहाकले तिनलाई भने, “मेरो छोरा, यता आइज, र मलाई म्वाइँ खा।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","यसकारण याकोब नजिकै गएर आफ्नो बुबालाई म्वाइँ खाए। जब उनको लुगाको बास्‍ना इसहाकले थाहा पाए, तब उनलाई आशिष् दिएर भने, “अहो, मेरो छोराको बास्‍ना त याहवेहले आशिष् दिनुभएको खेतको बास्‍नाझैँ छ। ");
INSERT INTO npioncb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्‍वरले तँलाई आकाशको शीतबाट अनि पृथ्वीको उर्वर जमिनबाट— प्रशस्त अन्‍न र नयाँ दाखमद्य देऊन्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","राष्ट्रहरूले तेरो सेवा गरून्, अनि मानिसहरू तेरो सामु झुकून्। तेरा दाजुभाइहरूमाथि तेरो प्रभुत्व होस्, अनि तेरी आमाका छोराहरू तेरो सामु झुकून्। तँलाई श्राप दिनेहरूले श्राप पाऊन्, र तँलाई आशिष् दिनेहरूले आशिष् पाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकले तिनलाई आशिष् दिइसकेपछि आफ्ना बुबाको उपस्थितिबाट याकोब निस्केका मात्र के थिए, तिनका दाजु एसाव शिकार गरेर भित्र आए। ");
INSERT INTO npioncb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","तिनले पनि केही स्वादिष्‍ठ भोजन तयार पारे; अनि आफ्ना बुबाकहाँ ल्याए। त्यसपछि एसावले भने, “बुबा, कृपया उठेर बस्‍नुहोस्, र मैले शिकार गरेर ल्याएको मासुबाट केही खाएर मलाई आशिष् दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","तब तिनका पिता इसहाकले सोधे, “तँचाहिँ को होस्?” तिनले जवाफ दिए, “म तपाईंको छोरा, तपाईंको जेठा छोरा एसाव हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तब इसहाक जोडसित डरले काँपे, र भने, “त्यसो भए त्योचाहिँ को हो, जसले शिकार गरेर मकहाँ ल्यायो? तँ आउनुभन्दा अगि नै मैले त्यो खाएँ, र त्यसलाई आशिष् दिएँ—अनि निश्‍चय नै त्यसैले त्यो आशिष् पाउनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","जब एसावले आफ्ना बुबाको कुरा सुने, तब तिनी दुःखी भएर डाँको छोडेर रोए, र आफ्ना बुबालाई भने, “बुबा, मलाई पनि आशिष् दिनुहोस्!” ");
INSERT INTO npioncb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","तर तिनले भने, “तेरो भाइले छल गरेर आयो, र तेरो आशिष् लग्यो।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसावले भने, “त्यसको नाम याकोब भनेर ठिकै राखिएको होइन र? त्यसले मलाई छल गरेको यो दोस्रो पटक हो। त्यसले मेरो ज्येष्‍ठ अधिकार लियो; अहिले मैले पाउनुपर्ने आशिष् पनि त्यसैले लग्यो!” तब तिनले सोधे, “के तपाईंले मेरा निम्ति केही आशिष् साँचेर राख्नुभएको छैन र?” ");
INSERT INTO npioncb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकले एसावलाई जवाफ दिए, “हेर् मेरो छोरा, मैले उसलाई तेरो मालिक बनाइसकेँ; अनि उसका सबै आफन्तहरूलाई उसका सेवक बनाइसकेको छु; अनि अन्‍न र दाखमद्यले उसलाई तृप्‍त पारिसकेको छु। यसकारण मेरो छोरा, म तेरा लागि के नै गर्न सक्छु र?” ");
INSERT INTO npioncb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसावले आफ्ना बुबालाई भने, “बुबा, तपाईंसित एउटै मात्र पनि आशिष् होला नि? मलाई पनि आशिष् दिनुहोस् बुबा!” तब तिनी डाँको छोडेर रोए। ");
INSERT INTO npioncb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","अनि उनका पिता इसहाकले उनलाई जवाफ दिए, “तेरो बसोबास पृथ्वीको उर्वर जमिनबाट टाढा; माथि आकाशको शीतदेखि टाढा हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तँ तरवारको भरमा जिउनेछस्, अनि तैँले तेरो भाइको सेवा गर्नेछस्। तर तँ बोझले विचलित भएपछि, तैँले आफ्नो गर्दनबाट त्यसको जुवा भाँचेर फ्याँक्नेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","आफ्ना पिताले याकोबलाई आशिष् दिनुभएको कारण एसावले याकोबसित शत्रुता राखे। अनि तिनले मनमनै भने, “मेरा पिताको मृत्युको शोक नजिक छ, त्यसपछि म मेरो भाइ याकोबलाई मार्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","आफ्नो जेठा छोरा एसावले भनेका कुरा जब रिबेकालाई भनियो, तब तिनले आफ्नो कान्छा छोरा याकोबलाई बोलाइपठाइन्, र तिनलाई भनिन्, “तेरो दाजुले तँलाई मार्ने योजना बनाएर बदला लिन खोज्दैछ। ");
INSERT INTO npioncb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","अब मेरो छोरा, म जे भन्छु त्यो गर्; तँ हारानमा भएका मेरा दाजु लाबानकहाँ भागेर गइहाल्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","तेरो दाजुको रिस नमरुन्जेल तँ केही दिन त्यहीँ बस्। ");
INSERT INTO npioncb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","तैँले तेरा दाजुलाई जे गरेको थिइस्, सो कुरा उसले नबिर्सुन्जेल बस्; अनि उसको रिस मरेपछि तँलाई त्यहाँबाट यता आउनू भनी म खबर पठाउनेछु। एकै दिनमा तिमीहरू दुवैलाई म किन गुमाऊँ?” ");
INSERT INTO npioncb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","तब रिबेकाले इसहाकलाई भनिन्, “म यी हित्ती स्त्रीहरूसित बस्दा-बस्दा वाक्‍क भइसकेकी छु। यदि याकोबले यस ठाउँका स्त्रीहरूबाट अर्थात् यस्ता हित्ती स्त्रीहरूबाट पत्नी ल्यायो भने म बाँचेर केही अर्थ हुँदैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","यसकारण इसहाकले याकोबलाई बोलाएर आशिष् दिए। त्यसपछि उनले यस्तो आज्ञा दिए: “कनानी स्त्रीसँग विवाह नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","तुरुन्तै पद्दन-अराममा तेरी आमाका पिता बतूएलको घरमा गइहाल्, र आफ्ना लागि तेरी आमाका दाजु लाबानका छोरीहरूमध्ये एउटीलाई विवाह गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","सर्वशक्तिमान् परमेश्‍वरले तँलाई आशिष् देऊन्, र तँ जाति-जातिको एक समुदाय नहोउन्जेल तँलाई फलवन्त बनाएर तेरो संख्याको वृद्धि गरून्। ");
INSERT INTO npioncb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","उहाँले तँ र तेरा सन्ततिलाई अब्राहामलाई दिनुभएको आशिष् देऊन्, ताकि अब्राहामलाई परमेश्‍वरले दिनुभएको ठाउँ, जसमा तँ अहिले परदेशी भई बसेको छस्, त्यो भूमि तेरो अधिकारमा होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","तब इसहाकले याकोबलाई बिदा गरे; अनि तिनी पद्दन-अराममा लाबानकहाँ गए। लाबान अरामी बतूएलको छोरा, अर्थात् याकोब र एसावकी आमा रिबेकाका दाजु थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","अब इसहाकले याकोबलाई आशिष् दिएर पद्दन-अरामबाट पत्नी ल्याउनू भनी त्यहाँ पठाएछन्, र तिनलाई आशिष् दिँदा “कुनै कनानी स्त्रीलाई विवाह नगर्नू,” भन्‍ने आज्ञा दिएछन्, ");
INSERT INTO npioncb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","र याकोबले आफ्ना बुबा र आमाको आज्ञापालन गरेर पद्दन-अराममा गएको कुरा एसावले थाहा पाए। ");
INSERT INTO npioncb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","जब तिनका पिता इसहाकलाई कनानी स्त्रीहरू मन पर्दैन रहेछ भनी एसावले थाहा पाए; ");
INSERT INTO npioncb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","तब एसाव इश्माएलकहाँ गए, र आफूसित भएका पत्नीहरूबाहेक तिनले अब्राहामको छोरा इश्माएलकी छोरी, नबायोतकी बहिनी महलतलाई विवाह गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकोब बेर्शेबा छोडेर हारानतर्फ लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","तिनी कुनै एक विशेष ठाउँमा पुगेपछि सूर्य अस्ताइसकेकोले रात कटाउन त्यहीँ रोकिए। त्यस ठाउँमा एउटा ढुङ्गा लिएर त्यसको सिरानी लगाएर सुत्नका लागि तिनी ढल्किए। ");
INSERT INTO npioncb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","अनि तिनले सपना देखे। पृथ्वीमाथि अडिएको एउटा भर्‍याङ, जसको टुप्पोचाहिँ स्वर्गसम्म पुगेको थियो; अनि परमेश्‍वरका दूतहरू त्यसमा उक्लँदै र ओर्लंर्दै गरेका देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","अनि सबैभन्दा माथिचाहिँ याहवेह उभिनुभएको थियो, र उहाँले भन्‍नुभयो: “म याहवेह नै तेरा पिता अब्राहाम र इसहाकका परमेश्‍वर हुँ। तँ ढल्किरहेको यो ठाउँ तँ र तेरा सन्तानहरूलाई म दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तेरा सन्तानहरू पृथ्वीको धुलोझैँ हुनेछन्; अनि तँ पश्‍चिम, पूर्व, उत्तर र दक्षिणतिर फैलिनेछस्। पृथ्वीका सबै जातिले तँ र तेरा सन्तानहरूद्वारा आशिष् पाउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","म तँसँग छु, र तँ जहाँ जान्छस्, तँलाई रक्षा गर्नेछु; अनि तँलाई यस देशमा फर्काएर ल्याउनेछु। मैले तँसित गरेको प्रतिज्ञा पूरा नगरेसम्म म तँलाई छोड्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","जब याकोब निद्राबाट झल्याँस बिउँझे, र तिनले सोचे, “निश्‍चय नै याहवेह यस ठाउँमा हुनुहुँदोरहेछ; अनि मलाई यो थाहै थिएन।” ");
INSERT INTO npioncb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","तब तिनी डराएर भने, “यो ठाउँ कति भययोग्य रहेछ! यो परमेश्‍वरको घरबाहेक अरू केही होइन रहेछ; यो त स्वर्गकै ढोका पो रहेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","भोलिपल्ट बिहानै याकोब उठे, र आफूले सिरानी लगाएको ढुङ्गा लिए; अनि त्यसलाई खाँबोझैँ ठड्याएर टुप्पोमाथि तेल खन्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","तिनले त्यस ठाउँको नाम बेथेल राखे; पहिला त्यस सहरलाई लूज भनिन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","तब याकोबले यसो भनेर भाकल गरे, “यस यात्रामा यदि परमेश्‍वर मेरो साथमा रहनुभयो, मलाई रक्षा गर्नुभयो; मलाई खानलाई भोजन र लाउनलाई लुगा दिनुभयो, ");
INSERT INTO npioncb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","र म मेरा पिताको घरमा सुरक्षित फर्केर आएँ भने याहवेह मेरा परमेश्‍वर हुनुहुनेछ; ");
INSERT INTO npioncb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","अनि मैले खाँबोझैँ ठड्याएको ढुङ्गाचाहिँ परमेश्‍वरको घर हुनेछ, र तपाईंले मलाई दिनुहुने सबै कुराको दशांश म तपाईंलाई दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","तब याकोबले आफ्नो यात्रा जारी गर्दैगए, र पूर्वका जातिहरूको देशमा आए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","तब उनले त्यहाँ खुला मैदानमा एउटा इनार देखे, जसको छेउमा तीन बगाल भेडाबाख्राहरू बसिरहेका थिए। किनकि गोठालाहरूले त्यही इनारबाट आफ्ना बगाललाई पानी पियाउने गर्थे। इनारको मुखमा राखिएको ढुङ्गा ठूलो थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","जब सबै बगालहरू त्यहाँ भेला हुन्थे; गोठालाहरूले इनारको मुखबाट ढुङ्गा हटाइदिन्थे, र भेडाहरूलाई पानी पियाउँथे। त्यसपछि तिनीहरूले त्यस ढुङ्गालाई फेरि गुडाउँदै ल्याएर इनारको मुख छोपिदिन्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकोबले ती गोठालाहरूलाई सोधे, “मेरा भाइहरू हो, तपाईंहरू कुन ठाउँबाट आउनुभएको हो?” तिनीहरूले जवाफ दिए, “हामी हारानबाट आएका हौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","तिनले तिनीहरूलाई भने, “के तपाईंहरू नाहोरका नाति लाबानलाई चिन्‍नुहुन्छ?” तिनीहरूले जवाफ दिए, “हजुर, हामी उहाँलाई चिन्छौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","तब याकोबले तिनीहरूलाई सोधे, “के उहाँ कुशलै हुनुहुन्छ?” तिनीहरूले भने, “ज्यू, उहाँ कुशलै हुनुहुन्छ; हेर्नुहोस्, भेडाहरू लिएर आउँदै गरेकी ती केटी उहाँकै छोरी राहेल हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","तिनले भने, “हेर्नुहोस्, घाम अझसम्म आकाशमाथि नै छ। यतिखेर बगाललाई भेला गराउने समय भएको छैन। भेडाबाख्राहरूलाई पानी पियाउनुहोस्; र फेरि चराउन लानुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","तिनीहरूले भने, “सबै बगाल भेला नभएसम्म इनारको मुखबाट हामी ढुङ्गा हटाउन सक्दैनौँ। त्यसपछि हामी भेडाबाख्राहरूलाई पानी पियाउँछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकोब उनीहरूसित कुरा गर्दैगर्दा राहेल आफ्ना पिताका भेडाहरू लिएर आइपुगिन्; किनकि तिनी भेडा गोठाल्नी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","जब याकोबले आफ्नी आमाका दाजु लाबानकी छोरी राहेल र लाबानका भेडाहरू देखे, तब तिनी गएर इनारको मुखबाट ढुङ्गा हटाएर आफ्ना मामाका भेडाहरूलाई पानी पियाए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","तब याकोबले राहेललाई म्वाइँ खाए, र डाँको छोडेर रुन लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकोबले राहेललाई आफू तिनका पिताका नातेदार र रिबेकाको छोरो हुँ भनेर बताए। त्यसैले राहेल दगुरेर गइन्, र आफ्ना पितालाई भनिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","लाबानले जब आफ्नी बहिनीको छोरा याकोबको विषयमा खबर सुने, तब तिनी उनलाई भेट्न हतारसाथ गए। तिनले उनलाई अङ्कमाल गरे, र म्वाइँ खाए, र तिनलाई घरमा ल्याए; अनि याकोबले तिनलाई त्यहाँ यी सबै कुराहरू भनिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","तब लाबानले भने, “तिमी मेरै मासु र रगत हौ।” याकोब तिनीसित एक महिना बसेपछि, ");
INSERT INTO npioncb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","लाबानले याकोबलाई भने, “हुन त तिमी मेरा नातेदार हौ, तर यसो भन्दैमा तिमीले सित्तैँमा मेरो सेवा गर्नुपर्छ र? तिम्रो ज्याला कति हुनुपर्ने हो, मलाई भन।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानका दुई छोरीहरू थिए; जेठीको नाम लेआ, र कान्छीको नाम राहेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआका आँखा कमजोर थिए, तर राहेलचाहिँ राम्रो बनोट भएकी र सुन्दरी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकोबले राहेललाई प्रेम गर्थे, त्यसैले उनले लाबानलाई भने, “म तपाईंकी कान्छी छोरी राहेलका निम्ति तपाईंसित सात वर्ष सेवा गर्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबानले भने, “मैले यसलाई अरू मानिसलाई दिनुभन्दा त तिमीलाई दिनु नै असल हो। मसित यहीँ बस।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","यसकारण राहेललाई पाउनका लागि याकोबले सात वर्षसम्म सेवा गरे; तर तिनले उनलाई प्रेम गरेको कारण याकोबका लागि ती थोरै दिनजस्तो मात्र लाग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","तब याकोबले लाबानलाई भने, “मलाई मेरी पत्नी दिनुहोस्। मेरो समय पूरा भयो, र म तिनीसँग सहवास गर्न चाहन्छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","यसकारण लाबानले त्यस ठाउँका सबै मानिसहरूलाई एकसाथ बोलाएर भोज दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","तर जब साँझ भयो, तिनले आफ्नी छोरी लेआलाई ल्याएर याकोबलाई दिए। अनि याकोबले तिनीसित सहवास गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","अनि लाबानले आफ्नी दासी जिल्पालाई आफ्नी छोरी लेआकी सेविका हुनलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","जब बिहान भयो, राहेलको सट्टा लेआ पो त्यहाँ रहिछिन्! यसकारण याकोबले लाबानलाई भने, “यो तपाईंले मलाई के गर्नुभयो? के मैले राहेलका निम्ति तपाईंको सेवा गरेको होइनँ र? तपाईंले मलाई किन धोका दिनुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबानले जवाफ दिए, “यहाँ हाम्रो परम्पराअनुसार कान्छीको विवाह जेठीभन्दा पहिले गर्नुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","यस छोरीसित एक साता वैवाहिक उत्सव पूरा गर, र तिमीले अर्को सात वर्ष मेरो सेवा गर; तब तिमीलाई कान्छी छोरी पनि दिनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","अनि याकोबले त्यस्तै गरे। तिनले लेआसित एक हप्‍ता बिताए; अनि लाबानले आफ्नी छोरी राहेललाई तिनकी पत्नी हुनलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","अनि लाबानले आफ्नी सेविका बिल्हालाई आफ्नी छोरी राहेलकी सेविका हुनलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","याकोबले राहेलसित सहवास गरे; अनि तिनले लेआलाई भन्दा राहेललाई बढी प्रेम गरे। अनि तिनले अर्को सात वर्ष लाबानको सेवा गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","जब याहवेहले लेआलाई प्रेम नपाएकी देख्नुभयो, तब उहाँले तिनको कोख खोलिदिनुभयो; तर राहेलचाहिँ बाँझी रहिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआ गर्भवती भइन् र तिनले एउटा छोरा जन्माइन्। तिनले उसको नाम रूबेन राखिन्; किनकि तिनले भनिन्, “योचाहिँ याहवेहले मेरो कष्‍ट देख्नुभएको कारणले हो। निश्‍चय नै मेरा पतिले अब मलाई प्रेम गर्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","तिनी फेरि गर्भवती भइन्, र अर्को छोरा जन्माउँदा तिनले भनिन्, “किनकि मैले प्रेम पाइनँ भनेर याहवेहले सुन्‍नुभएको छ; र उहाँले मलाई यो छोरा पनि दिनुभयो।” यसकारण तिनले त्यसको नाम शिमियोन राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","तिनी फेरि गर्भवती भइन्, र अर्को छोरा जन्माउँदा तिनले भनिन्, “अब यस पटक त मेरा पति मसँगै मिल्न आउनुहुनेछ; किनकि मैले उहाँका निम्ति तीन वटा छोरा पाइसकेँ।” यसकारण त्यसको नाम लेवी राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","तिनी फेरि गर्भवती भइन्, र त्यो छोरा जन्माउँदा तिनले भनिन्, “यस पटक म याहवेहको प्रशंसा गर्नेछु।” यसकारण तिनले त्यसको नाम यहूदा राखिन्। त्यसपछि तिनले छोराछोरी जन्माउन छोडिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","जब राहेलले आफूले याकोबका निम्ति सन्तान जन्माउन नसकेकी देखिन्, तब तिनले आफ्नी दिदीसित डाह गर्न लागिन्। यसकारण तिनले याकोबलाई भनिन्, “मलाई सन्तान दिनुहोस्, नत्रता म मर्नेछु!” ");
INSERT INTO npioncb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","यो सुनेर याकोब राहेलसित रिसाउँदै भने, “तिम्रो कोख बन्द गरिदिने के म परमेश्‍वरको स्थानमा छु र?” ");
INSERT INTO npioncb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","तब तिनले भनिन्, “मेरी सेविका बिल्हा यहीँ छ। त्यसकहाँ जानुहोस्, र त्यसले मेरा निम्ति सन्तान जन्माओस्, र त्यसबाट म पनि एउटा परिवार निर्माण गर्न सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","यसकारण राहेलले आफ्नी सेविका बिल्हालाई याकोबकी पत्नी हुनलाई दिइन्। याकोबले त्यससँग सहवास गरे; ");
INSERT INTO npioncb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","अनि बिल्हा गर्भवती भई, र याकोबका निम्ति एउटा छोरा जन्माई। ");
INSERT INTO npioncb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","तब राहेलले भनिन्, “परमेश्‍वरले न्याय गर्नुभएको छ; उहाँले मेरो बिन्ती सुन्‍नुभएको छ; र मलाई एउटा छोरा दिनुभएको छ।” यसकारण तिनले उसको नाम दान राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेलकी सेविका बिल्हा फेरि गर्भवती भई, र त्यसले याकोबका निम्ति दोस्रो छोरा जन्माई। ");
INSERT INTO npioncb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","तब राहेलले भनिन्, “मेरी दिदीसित मैले ठूलो सङ्घर्ष गरेकी छु, अब मैले जितेकी छु।” यसकारण तिनले उसको नाम नप्‍ताली राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","जब लेआले आफ्नो कोख बन्द भएको देखिन्, तब तिनले आफ्नी सेविका जिल्पालाई लगेर याकोबकी पत्नी हुनका निम्ति दिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","लेआकी सेविका जिल्पाले याकोबका निम्ति एउटा छोरा जन्माई। ");
INSERT INTO npioncb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","तब लेआले भनिन्, “म कत्ति धन्य भएकी छु!” यसकारण तिनले उसको नाम गाद राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लेआकी सेविका जिल्पाले याकोबबाट दोस्रो छोरो जन्माई। ");
INSERT INTO npioncb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","तब लेआले भनिन्, “म कति प्रसन्‍न छु! स्त्रीहरूले मलाई सुखी भन्‍नेछन्।” यसकारण तिनले उसको नाम आशेर राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहुँ काट्ने बेला रूबेन खेततिर गएका थिए; अनि तिनले विशाखमूल भेट्टाए, जुन तिनले आफ्नी आमा लेआकहाँ ल्याए। राहेलले लेआलाई भनिन्, “मलाई तिम्रा छोराले ल्याएका विशाखमूलबाट केही देऊ।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","तर लेआले तिनलाई भनिन्, “तैँले मेरो पतिलाई त लगिस्-लगिस्, अब मेरो छोराले ल्याएका विशाखमूल पनि खोस्छेस्?” राहेलले भनिन्, “ठिकै छ, तेरो छोराको विशाखमूलको सट्टामा आज राति उहाँ तँसित सुत्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","त्यसकारण जब साँझमा याकोब खेतबाट आए; तब लेआ तिनलाई भेट्न गइन् र भनिन्, “तपाईं आज मसँग रात बिताउनैपर्छ। मेरा छोराले ल्याएका विशाखमूल दिएर मैले तपाईंलाई भाडामा लिएकी छु।” यसकारण याकोबले त्यो रात लेआसँग बिताए। ");
INSERT INTO npioncb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्‍वरले लेआको बिन्ती सुन्‍नुभयो; अनि तिनी गर्भवती भएर याकोबका निम्ति पाँचौँ छोरा जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","तब लेआले भनिन्, “मैले मेरी सेविका आफ्नो पतिलाई दिएँ। त्यसैकारण परमेश्‍वरले मलाई प्रतिफल दिनुभएको छ।” यसकारण तिनले उसको नाम इस्साखार राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लेआ फेरि गर्भवती भइन्, र याकोबबाट छैटौँ छोरा जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","तब लेआले भनिन्, “परमेश्‍वरले मलाई एउटा बहुमूल्य उपहार दिनुभएको छ। यस पटक मेरा पतिले मलाई आदर गर्नुहुनेछ; किनकि मैले उहाँका निम्ति छ जना छोरा जन्माएकी छु।” यसकारण तिनले उसको नाम जबूलून राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","केही समयपछि तिनले एउटी छोरी जन्माइन्, र तिनको नाम दीना राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","तब परमेश्‍वरले राहेललाई सम्झनुभयो; उहाँले तिनको बिन्ती सुन्‍नुभयो, र तिनको कोख खोलिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","तिनी गर्भवती भइन् र एउटा छोरा जन्माइन्; तब तिनले भनिन्, “परमेश्‍वरले मेरो अपमान हटाउनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","तिनले उसको नाम योसेफ राखिन्, र भनिन्, “याहवेहले मलाई अर्को छोरा पनि थपिदेऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","राहेलले योसेफलाई जन्माएको केही समयपछि याकोबले लाबानलाई भने, “अब मलाई बिदा दिनुहोस्, र म आफ्नै देशमा फर्केर जान सकूँ। ");
INSERT INTO npioncb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मलाई मेरा पत्नीहरू र सन्तान लैजान दिनुहोस्; जसका लागि मैले तपाईंको सेवा गरेको छु, अब म जान पाऊँ। मैले तपाईंका लागि कति धेरै सेवा गरेको छु, सो तपाईं जान्‍नुहुन्छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","तर लाबानले तिनलाई भने, “यदि मैले तिमीबाट निगाह प्राप्‍त गरेको छु भने दया गरी बसिदेऊ; किनकि मैले जोखनाद्वारा जानेको छु, कि तिमीद्वारा नै याहवेहले मलाई आशिष् दिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","तिनले अझ भने, “तिमीलाई थप कति ज्याला चाहिन्छ भन, बरु म त्यो दिउँला।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकोबले तिनलाई भने, “मैले तपाईंका निम्ति कसरी सेवा गरेको छु, र तपाईंका गाईबस्तुहरू कसरी मेरो रेख-देखमा सप्रेका छन्, सो तपाईं जान्‍नुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","म आउनुभन्दा अगि तपाईंसित थोरै वस्तुभाउ थिए, तर अहिले बढेर धेरै वृद्धि भएको छ; अनि म आएको समयदेखि याहवेहले तपाईंलाई आशिष् दिनुभएको छ। तर अब मैले आफ्नै परिवारका निम्ति चाहिँ कहिले बन्दोबस्त मिलाऊँ?” ");
INSERT INTO npioncb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","अनि तिनले सोधे, “त्यसो भए भन, म तिम्रो लागि के दिऊँ?” याकोबले जवाफ दिए, “मलाई केही दिनुपर्दैन; तर यदि तपाईंले मेरा निम्ति यो एउटा कुरा गर्नुभयो भने म तपाईंको बगाल चराएर त्यसको हेरचाह गरिरहनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","आज मलाई तपाईंका बगालमा गएर टाटेपाटे, थोप्ले भएका भेडाहरू, प्रत्येक कालो रङ्गको भेडाको पाठा, र प्रत्येक थोप्ले र टाटेपाटे बाख्राहरूलाई बगालबाट अलग गर्न दिनुहोस्। यिनीहरू नै मेरा ज्याला हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","अनि जहिले-जहिले तपाईंले मलाई दिनुभएको ज्याला जाँच्नुहुनेछ, भविष्यमा मेरो इमानदारीताले मेरो साक्षी दिनेछ। मसित भएका कुनै पनि टाटेपाटे वा थोप्ले नभएका बाख्रा अथवा कालो रङ्ग नभएको कुनै पनि भेडाको पाठा फेला पर्‍यो भने ती सबै चोरी गरिएको ठहरिनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबानले भने, “हुन्छ, तिमीले भनेझैँ होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","त्यसै दिन लाबानले धर्के अथवा थोप्ले सबै बोकाहरू, र टाटेपाटे अथवा थोप्ला भएका बाख्रीहरू (जिउमा सेता भएका सबै), र सबै काला रङ्गका भेडाका पाठाहरू अलग गरे, र तिनीहरूलाई याकोबका छोराहरूको जिम्मामा दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","अनि तिनले याकोबदेखि तीन दिनको यात्राको दूरी बनाएर बसे; अनि याकोबचाहिँ लाबानका बाँकी बगालहरू हेरचाह गर्दै बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","अनि याकोबले, सल्‍ला, हाडे-बदाम र चिनारका रूखहरूका भर्खर काटिएका हाँगाहरू लिए; अनि त्यसका बोक्रा ताछेर भित्री सेतो काठ देखिने गरी सेता धर्काहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","तब तिनले बोक्रा ताछिएका ती हाँगाहरू सबै पानी पिउने डूँडहरूको छेउमा राखिदिए, ताकि पानी पिउन आउँदा बगालहरूले त्यो देखून्; किनभने त्यहाँ ती बगालहरू मिसिन्थे, ");
INSERT INTO npioncb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","बगालहरू ती हाँगाहरूका सामु मिसिए; अनि तिनीहरूले धर्के, टाटेपाटे र थोप्ले पाठापाठीहरू जन्माए। ");
INSERT INTO npioncb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकोबले बगालका पाठाहरूलाई छुट्याए, तर रहेकोलाई चाहिँ लाबानका धर्के र काला रङ्गका पशुहरूपट्टि फर्काइदिए। यसरी तिनले आफ्ना लागि बेग्लै बगाल बनाए, र तिनीहरूलाई लाबानका पशुहरूसित राखेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जहिले-जहिले बलिया पाठीहरूको मिसिने बेला आउँथ्यो, याकोबले तिनीहरू ती हाँगाहरूको सामु मिसिऊन् भनी ती हाँगाहरूलाई पानीको डुँडमा पशुहरूको सामु राखिदिन्थे, ");
INSERT INTO npioncb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","तर ती बगालहरू कमजोर भएमा तिनले तिनीहरूलाई त्यहाँ राख्दैनथे। यसरी कमजोर पशुहरू लाबानकहाँ र बलियाहरूचाहिँ याकोबकहाँ हुनगए। ");
INSERT INTO npioncb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","यसरी यी मानिस अति सम्पन्‍न भए; अनि तिनका ठूला-ठूला बगाल, सेवक-सेविका, ऊँट र गधाहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","याकोबले लाबानका छोराहरूले यसो भनेका सुने, “याकोबले हाम्रा पिताका सबै थोक हडपेका छन्। हाम्रा पितासँग भएको सम्पत्तिबाट नै उनले यी सबै धन कमाएका हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","अनि लाबानको व्यवहार पनि आफूप्रति पहिलेको जस्तै नभएको याकोबले देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","तब याहवेहले याकोबलाई भन्‍नुभयो, “आफ्ना बुबा र तेरा नातेदारहरूको देशमा फर्किएर जा, र म तँसित हुनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","यसकारण याकोबले आफ्नो बगाल भएको खेतबाट लेआ र राहेललाई बोलाउन पठाए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","तिनले उनीहरूलाई भने, “मैले तिमीहरूका पिताको म प्रतिको व्यवहार पहिलेझैँ नभएको देख्छु; तर मेरा पिताका परमेश्‍वर मेरो साथमा रहनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","मैले तिमीहरूका पिताका निम्ति आफ्नो पूरा शक्तिले भ्याएसम्म सेवा गरेको तिमीहरूले देखेकै छौ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तिमीहरूका पिताले मेरो ज्याला दश-दशपल्ट बदली गरेर मलाई छल्नुभएको छ। तैपनि परमेश्‍वरले तिनलाई मेरो केही हानि गर्न दिनुभएन। ");
INSERT INTO npioncb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","उहाँले ‘टाटेपाटे पशुहरू तिम्रो ज्याला हुनेछन्’ भन्‍नुहुँदा सबै बगालले टाटेपाटे नै बियाउँथे; अनि उहाँले ‘धर्के पशुहरू तिम्रो ज्याला हुनेछन्’ भन्‍नुहुँदा सबै बगालले धर्के नै बियाउँथे। ");
INSERT INTO npioncb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यसरी परमेश्‍वरले तिमीहरूका पिताका गाईबस्तु खोसेर ती मलाई दिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“एक चोटि पशुहरूको प्रजनन्‌को बेला मैले एउटा सपना देखेँ; अनि भेडीबाख्रीहरूसित मिसिने ती बोकाहरू धर्के, टाटेपाटे अथवा थोप्लेहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","तब सपनामा परमेश्‍वरका दूतले मसँग यसो भन्दै बोल्नुभयो, ‘याकोब;’ मैले जवाफ दिएँ, ‘हजुर, म यहाँ छु।’ ");
INSERT INTO npioncb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","अनि उहाँले भन्‍नुभयो, ‘माथि हेर्, बगालसित मिसिने ती बोकाहरू धर्के, टाटेपाटे अथवा थोप्ले छन्; किनकि लाबानले तँप्रति कस्तो व्यवहार गरिरहेको छ, त्यो मैले देखेको छु। ");
INSERT INTO npioncb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","म बेथेलका परमेश्‍वर हुँ, जहाँ तैँले एउटा खाँबोलाई तेलले अभिषेक गरेको थिइस्, र तैँले मसित एउटा प्रतिज्ञा गरेको थिइस्। अब उठ्, यो देशबाट निस्की, र तेरो आफ्नो जन्मस्थलमा फर्किजा।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","अनि लेआ र राहेलले भने, “के हाम्रा पिताको पैतृक सम्पत्तिमा हाम्रो अझ केही अंश छ र? ");
INSERT INTO npioncb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","के उहाँले हामीलाई परदेशीझैँ व्यवहार गर्नुहुन्‍न? उहाँले हामीलाई बेच्नुभएको मात्रै होइन, तर हाम्रा निम्ति दिइएको मूल्य पनि उहाँ आफैँले नै हडपिसक्नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","परमेश्‍वरले हाम्रा पिताबाट लैजानुभएको सबै सम्पत्ति हाम्रा र हाम्रा बालबच्‍चाकै हुन्। यसकारण परमेश्‍वरले तपाईंलाई जे-जे भन्‍नुभएको छ, त्यो गर्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","तब याकोबले आफ्ना बालबच्‍चा र पत्नीहरूलाई ऊँटहरूमा चढाए, ");
INSERT INTO npioncb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","अनि तिनले पद्दन-अराममा कमाएका सबै धनसम्पत्तिसहित आफ्ना सबै गाईबस्तुहरूलाई आफ्नो अगि लगाएर कनान देशमा भएका आफ्ना पिता इसहाककहाँ जानका लागि निस्के। ");
INSERT INTO npioncb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","जब लाबान आफ्ना भेडाहरूका ऊन कत्रन गएका थिए; त्यही बेला राहेलले आफ्ना पिताका घरानाका घर-देवताहरू चोरिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","तब याकोब पनि अरामी लाबानलाई थाहै नदिई सुटुक्‍क हिँडे; आफू भाग्न लागेको कुरा नभनी तिनलाई धोका दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","यसकारण तिनी आफूसित जे जति थिए, ती सबै कुरालाई लिएर भागे; अनि यूफ्रेटिस नदी तरेर तिनी गिलादको पहाडी मुलुकतिर लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तेस्रो दिनमा याकोब भागे भनी जब लाबानलाई सुनाइयो; ");
INSERT INTO npioncb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","तब तिनले आफ्ना आफन्तहरूलाई साथमा लिएर सात दिनसम्म याकोबलाई पछ्याए; अनि तिनीहरूले तिनलाई गिलादको पहाडी मुलुकमा भेट्टाए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","तब परमेश्‍वर राति सपनामा अरामी लाबानकहाँ आएर तिनलाई भन्‍नुभयो, “होशियार बस्, याकोबलाई असल वा खराब केही पनि नभन्‍नू।” ");
INSERT INTO npioncb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबानले याकोबलाई भेट्टाउँदा तिनले गिलादको पहाडी मुलुकमा पाल टाँगेका थिए; अनि लाबान र तिनका आफन्तहरूले पनि त्यहीँनेर पाल टाँगे। ");
INSERT INTO npioncb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","त्यसपछि लाबानले याकोबलाई भने, “तिमीले यस्तो के गर्‍यौ? तिमीले मलाई छलेर मेरा छोरीहरूलाई लडाइँका बन्दीहरूझैँ लिएर गयौ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","तिमी किन सुटुक्‍क भागेर मलाई छल्यौ? तिमीले मलाई भनेको भए, खैँजडी र वीणाको सङ्गीत बजाएर गीत गाउँदै सहर्ष तिमीहरूलाई बिदा गर्नेथिएँ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तिमीले मलाई मेरा नातिनातिना र छोरीहरूलाई बिदाइको म्वाइँ समेत खान दिएनौ। तिमीले यसो गरेर मूर्खता गरेका छौ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","मैले चाहेँ भने तिमीलाई जे पनि गर्न सक्छु, तर हिजो राति तिम्रा पिताका परमेश्‍वरले मलाई भन्‍नुभयो, ‘होशियार बस्, याकोबलाई असल वा खराब केही नभन्‍नू।’ ");
INSERT INTO npioncb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","अब तिमी गइहालेका छौ; किनकि तिमीले आफ्ना पिताको घरमा फर्कने इच्छा धेरै दिनदेखि राखेका थियौ। तर तिमीले मेरा घरानाका देवताहरू किन चोर्‍यौ?” ");
INSERT INTO npioncb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","तब याकोबले लाबानलाई जवाफ दिँदै भने, “कहीँ तपाईंले आफ्ना छोरीहरू बलपूर्वक मबाट खोस्‍नुहोला कि भनी मैले सोचेको हुनाले म डराएर भागेँ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","तर यदि तपाईंले आफ्ना देवताहरू हामीमध्ये कोहीसित भेट्टाउनुभयो भने त्यो बाँच्नेछैन। यसकारण हाम्रा आफन्तहरूका सामु तपाईंको केही सामानहरू छन् भने आफैँ चिन्‍नुहोस्, र लैजानुहोस्।” तर ती देवताहरू राहेलले चोरेकी छन् भनेर याकोबलाई थाहै थिएन। ");
INSERT INTO npioncb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","यसकारण लाबान याकोबको पालभित्र र लेआको पालभित्र, र दुई सेविकाका पालभित्र गए; तर तिनले ती कहीँ भेट्टाएनन्। त्यसपछि तिनी लेआको पालबाट निस्केर राहेलको पालभित्र पसे। ");
INSERT INTO npioncb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","अब राहेलले घर-देवताहरू लिएर तिनलाई आफ्नो ऊँटको काठीभित्र राखेकी थिइन्, र आफूचाहिँ त्यसैमाथि बसेकी थिइन्। अनि लाबानले पालभित्र धुइँधुइँती खोजे, तर कहीँ पनि फेला पार्न सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेलले आफ्ना पितालाई भनिन्, “मेरा मालिक, मसित नरिसाउनुहोस्; म तपाईंको उपस्थितिमा उभिन सक्दिनँ; किनकि म रजस्वलाको समयमा छु।” यसकारण तिनले धुइँधुइँती खोजे, तर आफ्ना ती घर-देवताहरू भेट्टाएनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकोब रिसाए, र लाबानलाई हप्काएर सोधे, “मेरो अपराध के हो? मैले कुन पाप गरेको छु, र तपाईं मेरो खेदो गर्नुहुन्छ? ");
INSERT INTO npioncb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","तपाईंले मेरा सबै सामानहरूमा खानतलासी गर्नुभयो, तर तपाईंको घरानाको कुन सामानचाहिँ भेट्टाउनुभयो त? तपाईं र मेरा आफन्तहरूको सामु ती कुराहरू राख्नुहोस्, र तिनीहरूले नै हामी दुईका बीचमा निर्णय गरिदेऊन्। ");
INSERT INTO npioncb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“यी बीस वर्षदेखि म तपाईंसितै रहेँ। तपाईंका भेडा र बाख्राहरू कहिल्यै तुहिएनन्, न त मैले तपाईंका बगालका भेडाहरू नै खाएँ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जङ्गली जनावरहरूले लुछेर मारिएका पशुहरू मैले तपाईंकहाँ ल्याइनँ; बरु मैले नै त्यसको क्षतीपूर्ति बेहोरेँ। अनि कुनै पशु दिउँसो वा राति चोरिएको होस्, तपाईंले मबाट नै त्यसको क्षतीपूर्ति तिराउनुहुन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","मेरो स्थिति यस्तो थियो: दिउँसो मलाई गर्मीले र रातमा चिसोले धेरै कमजोर बनाएर आँखाबाट निद्रा हराउँथ्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","यसरी नै मैले तपाईंको घरानामा बीस वर्ष बिताएँ। तपाईंका दुई छोरीहरूका निम्ति मैले चौध वर्ष तपाईंको सेवा गरेँ; अनि छ वर्ष तपाईंका भेडाबाख्राहरू चराएँ, तर तपाईंले मेरो ज्याला दश-दशपल्ट बदल्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","मेरा पिताका परमेश्‍वर, अब्राहामका परमेश्‍वर, इसहाकको ‘भय’ मसित नहुनुभएको भए, तपाईंले मलाई निश्‍चय नै रित्तो हात पठाउनुहुनेथियो। तर परमेश्‍वरले मेरो कष्‍ट र मैले गरेको परिश्रम देख्नुभएको छ, त्यसैले हिजो राति उहाँले तपाईंलाई हप्काउनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","त्यसपछि लाबानले याकोबलाई जवाफ दिए, “यी स्त्रीहरू मेरा छोरीहरू हुन्, यिनका छोराछोरीहरू मेरा नातिनातिनाहरू हुन्; अनि यी बगालहरू पनि मेरा बगाल हुन्। तिमीले देखेका यी सबै थोक मेरै हुन्। तर पनि आज यी मेरा छोरीहरू र तिनीहरूले जन्माएका यी छोराछोरीहरूलाई म के गर्न सक्छु र? ");
INSERT INTO npioncb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","अब आऊ, तिमी र म, हामी एउटा करार बाँधौँ; अनि यो हामी बीचमा एउटा साक्षी होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","यसकारण याकोबले एउटा ढुङ्गा लिए, र त्यसलाई खाँबोजस्तो ठड्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","अनि याकोबले आफ्ना नातेदारहरूलाई भने, “अरू केही ढुङ्गाहरू बटुल्नुहोस्।” तब तिनीहरूले ढुङ्गाहरू बटुलेर एउटा थुप्रो बनाए; अनि तिनीहरूले त्यस थुप्रोको नजिक खानपिन गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबानले त्यसलाई यगर-सहदूता भन्‍ने नाम दिए; तर याकोबले चाहिँ गलेद भने। ");
INSERT INTO npioncb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबानले भने, “यो ढुङ्गाको थुप्रो आज तिम्रो र मेरो बीचमा साक्षी हो।” त्यसैकारण त्यसलाई गलेद भनियो। ");
INSERT INTO npioncb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","त्यसलाई मिस्पा पनि भनियो; किनकि तिनले भने, “हामी एक-अर्कादेखि अलग रहे तापनि याहवेहले तिमी र मलाई हेरचाह गरून्। ");
INSERT INTO npioncb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","यदि तिमीले मेरा छोरीहरूप्रति दुर्व्यवहार गर्‍यौ, अथवा मेरा छोरीहरूबाहेक तिमीले अरू पत्नीहरू ल्यायौ भने हामीसँग कोही नभए तापनि तिम्रो र मेरो बीचमा परमेश्‍वर साक्षी हुनुहुन्छ” भन्‍ने कुरा याद राख। ");
INSERT INTO npioncb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","लाबानले याकोबलाई यसो पनि भने, “यो ढुङ्गाको थुप्रो र यस खामोलाई हेर, जसलाई मैले मेरो र तिम्रो बीचमा स्थापित गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","यो थुप्रो र यो खाँबो एउटा साक्षी हुनेछ, ताकि म यस थुप्रोलाई पार गरेर तिमीलाई हानि गर्न जानेछैनँ; अनि तिमी पनि यस थुप्रो र खाँबोलाई पार गरेर मलाई हानि गर्न मेरो ठाउँतिर आउनेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","अब्राहामका परमेश्‍वर र नाहोरका परमेश्‍वर, अर्थात् उनीहरूका पिताका परमेश्‍वरले हाम्रो बीचमा न्याय गरून्।” यसकारण याकोबले आफ्ना पिता इसहाकले मानेको भयको नाममा शपथ खाए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","याकोबले त्यस पहाडी मुलुकमा एउटा बलिदान चढाए, र आफ्ना नातेदारहरूलाई खानपिन गर्न बोलाए। तिनीहरूले खानपिन गरिसकेपछि त्यहीँ रात बिताए। ");
INSERT INTO npioncb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","भोलिपल्ट बिहानै लाबानले आफ्ना नातिनातिना र छोरीहरूलाई म्वाइँ खाए, र तिनीहरूलाई आशिष् दिए। तब तिनी आफ्नो घरतिर फर्के। ");
INSERT INTO npioncb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकोब पनि आफ्नो बाटो लागे; अनि परमेश्‍वरका दूतहरूले तिनलाई भेटे। ");
INSERT INTO npioncb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","जब याकोबले तिनीहरूलाई देखे, तब तिनले भने, “यो त परमेश्‍वरको छाउनी हो!” यसकारण तिनले त्यस ठाउँको नाम महनाइम राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकोबले आफूभन्दा अगाडि एदोम देशको सेइर भन्‍ने ठाउँमा तिनका दाजु एसावकहाँ दूतहरू पठाए। ");
INSERT INTO npioncb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","तिनले तिनीहरूलाई आदेश दिए: “तिमीहरूले मेरा मालिक एसावलाई यसो भन्‍नू: ‘तपाईंको सेवक याकोब भन्छन्, म लाबानसित बस्दैथिएँ र अहिलेसम्म त्यहीँ नै बसेँ। ");
INSERT INTO npioncb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","मसित गाईबस्तु, गधाहरू, भेडा र बाख्राहरू र सेवक-सेविकाहरू छन्। म मेरा मालिककहाँ मैले उहाँको दृष्‍टिमा कृपा पाऊँ भनी यो समाचार पठाउँदैछु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","जब ती दूतहरू याकोबकहाँ फर्के, तब तिनीहरूले भने, “हामी तपाईंका दाजु एसावकहाँ गयौँ, र अहिले उहाँ तपाईंलाई भेट्न यतैतिर आइरहनुभएको छ, र उहाँको साथमा चार सय मानिसहरू छन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","यो खबर सुनेर याकोब अत्यन्तै डराएर आत्तिए; यसकारण याकोबले आफूसित भएका मानिसहरू, साथै बथानहरू, बगालहरू र ऊँटहरूलाई दुई दलमा विभाजन गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","तिनले सोचे, “यदि एसावले आएर एउटा दललाई आक्रमण गरे भने तापनि बाँकी रहेको अर्को दलचाहिँ भाग्न सक्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","त्यसपछि याकोबले प्रार्थना गरे, “हे याहवेह, मेरा पिता अब्राहामका परमेश्‍वर, मेरा पिता इसहाकका परमेश्‍वर, जसले मलाई ‘तँ आफ्नो देश र आफ्ना नातेदारहरूकहाँ जा, र म तेरो उन्‍नति गराउनेछु’ भन्‍नुभयो; ");
INSERT INTO npioncb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तपाईंले आफ्नो सेवकप्रति देखाउनुभएको कृपा र विश्‍वासयोग्यताको योग्यको म छैनँ। मैले यस यर्दन नदीलाई पार गर्दा मसित लहुरोबाहेक केही थिएन; तर अब मसित दुई वटा दल भएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","म बिन्ती गर्छु, मलाई मेरा दाजु एसावको हातबाट बचाउनुहोस्; किनकि तिनी आएर यी आमाहरूलाई र तिनीहरूका छोराछोरीलाई आक्रमण गर्लान् भन्‍ने मलाई डर लागेको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तर तपाईंले भन्‍नुभएको छ, ‘निश्‍चय नै म तेरो उन्‍नति गर्नेछु र तेरा सन्ततिलाई समुद्रको बालुवाझैँ बनाउनेछु, जो गन्‍न सकिनेछैन।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","तिनले त्यो रात त्यहीँ बिताए; त्यसपछि आफूसित भएका थोकबाट तिनले आफ्ना दाजु एसावका निम्ति उपहार छुट्याए: ");
INSERT INTO npioncb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","अर्थात् दुई सय बाख्री, बीस वटा बोका, दुई सय भेडी र बीस वटा भेडा, ");
INSERT INTO npioncb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","तीस वटा दुहुना ऊँट साथमा तिनीहरूका बच्‍चा, चालीस वटा गाई, दश वटा बाछा, बीस वटा गधैनी र दश वटा गधा। ");
INSERT INTO npioncb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","तिनले ती आ-आफ्नै बथानको हिसाबले आफ्ना सेवकहरूका जिम्मामा सुम्पिदिए, र आफ्ना सेवकहरूलाई भने, “मेरो अगि-अगि जाओ, र ती बथानहरूको बीचमा केही दूरी राख।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","तिनले पहिलो बथान लिएर जानेलाई निर्देशन दिँदै भने: “जब मेरा दाजु एसावले तिमीलाई भेटेर ‘तँ कसको मानिस होस्? अनि कहाँ जाँदैछस्? र तेरो अगि-अगि लागेका यी पशुहरूका मालिक को हुन्?’ भनी सोधे भने, ");
INSERT INTO npioncb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तैँले यसो भन्‍नू, ‘यी तपाईंका सेवक याकोबका हुन्। यी मेरा मालिक एसावलाई पठाइएका उपहार हुन्; अनि उहाँ हाम्रो पछि-पछि आउँदैहुनुहुन्छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","अनि बथानहरूका पछि-पछि लागेका दोस्रो, तेस्रो र अरू सबैलाई पनि तिनले निर्देशन दिँदै भने: “एसावलाई भेटेपछि तिमीहरूले पनि त्यसरी नै भन्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","अनि ‘तपाईंका सेवक याकोब हाम्रो पछि-पछि आउँदैहुनुहुन्छ भनेर अवश्य भन्‍नू।’ ” किनकि तिनले सोचेका थिए, “म यी उपहारहरू अगि-अगि पठाएर तिनलाई शान्त तुल्याउनेछु; अनि मैले पछिबाट तिनलाई भेट्दा सायद तिनले मलाई ग्रहण गर्लान्।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","यसरी याकोबले तिनका उपहारहरू अगि-अगि पठाए, तर तिनी आफैँचाहिँ त्यहीँ छाउनीमै रात बिताए। ");
INSERT INTO npioncb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","त्यस रात याकोब उठे, र आफ्ना दुई पत्नी, दुई सेविका अनि एघार छोरालाई लिएर यब्बोक नदी तरे। ");
INSERT INTO npioncb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","याकोबले तिनीहरूलाई नदीपारि पठाए, त्यसपछि तिनले आफूसित भएका अरू सबै कुराहरू पनि पठाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","यसरी याकोब एकलै छोडिए; अनि एक जना मानिसले तिनीसित बिहान उज्यालो नभएसम्म कुश्ती लडिरहे। ");
INSERT INTO npioncb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","जब आफूले याकोबलाई जित्न नसकेको ती मानिसले थाहा पाए, तब तिनले याकोबको कम्मरको जोर्नी छोए; अनि त्यस मानिससित कुश्ती खेल्दा-खेल्दै याकोबको कम्मरको जोर्नी खुस्क्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तब ती मानिसले भने, “उज्यालो हुन लागेको छ, अब मलाई जान देऊ।” तर याकोबले जवाफ दिए, “अहँ हुँदैन, मलाई आशिष् नदिएसम्म म तपाईंलाई जान दिनेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","तब ती मानिसले तिनलाई सोधे, “तिम्रो नाम के हो?” तिनले जवाफ दिए, “याकोब।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तब ती मानिसले भने, “तिम्रो नाम अब उसो याकोब होइन, तर इस्राएल हुनेछ; किनकि तिमीले परमेश्‍वर र मानिसहरूसँग लडाइँ लडेर जितेका छौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","तब याकोबले बिन्ती गरे, “दया गरी मलाई तपाईंको नाम के हो, बताउनुहोस्।” तर तिनले जवाफ दिए, “तिमी किन मेरो नाम सोध्छौ?” तब ती मानिसले त्यहीँ नै याकोबलाई आशिष् दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","यसकारण याकोबले त्यस ठाउँलाई यसो भनेर पनीएल नाम राखे, “किनकि मैले परमेश्‍वरलाई आमने-सामने देखेको छु, र पनि मेरो ज्यान बाँच्यो।” ");
INSERT INTO npioncb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","तिनी पनीएलबाट जाँदा सूर्योदय भइसकेको थियो, र आफ्नो कम्मरको जोर्नी खुस्किएको कारण तिनी खोच्याउँदै हिँड्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","यसकारण तिनको कम्मरको जोर्नीको मूलनसा छोइएको हुनाले आजसम्म पनि इस्राएलीहरू जनावरको कम्मरमा टाँसिएको नसा खाँदैनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकोबले आँखा उठाएर हेर्दा एसावलाई चार सय मानिसहरूसित आइरहेका देखे; अनि तिनले छोराछोरीहरूलाई लेआ, राहेल र दुई सेविकाहरूका बीचमा विभाजन गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","तिनले सबैभन्दा अगि सेविकाहरू र तिनीहरूका छोराछोरीहरूलाई राखे; त्यसपछि लेआ र तिनका छोराछोरीहरूलाई, र राहेल र योसेफलाई सबैभन्दा पछाडि राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","तिनी आफैँचाहिँ सबैभन्दा अगि बढेर आफ्ना दाजुको नजिक आइपुग्दा सातपल्ट भुइँसम्मै निहुरेर दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","तर एसाव याकोबलाई भेट्न दौडेर गए, तिनलाई अँगालो हाले र तिनले म्वाइँ खाए; अनि तिनीहरू दुवै धुरुधुरु रोए। ");
INSERT INTO npioncb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","तब एसावले आँखा उठाएर हेरे, र ती स्त्रीहरू र बालबच्‍चाहरूलाई देखे। तब तिनले सोधे, “तिमीसित भएका यिनीहरू को हुन्?” याकोबले जवाफ दिए, “यिनीहरू परमेश्‍वरले कृपा गर्नुभएर तपाईंको सेवकलाई दिनुभएका छोराछोरीहरू हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","तब ती सेविकाहरू र तिनीहरूका छोराछोरीले पनि नजिक आएर दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","त्यसपछि लेआ र तिनका छोराछोरी आएर दण्डवत् गरे। आखिरमा योसेफ र राहेल पनि आए, र दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसावले सोधे, “मैले भेटेका यी सबै बगाल र बथानको अर्थ के हो?” याकोबले जवाफ दिए, “मेरा मालिक, तपाईंको दृष्‍टिमा मैले निगाह पाउन सकूँ भनेर हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","तर एसावले भने, “मेरो भाइ, मसित प्रशस्त छँदैछ। तिमीसित भएका तिम्रै लागि राख।” ");
INSERT INTO npioncb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकोबले भने, “होइन, यदि मैले तपाईंको दृष्‍टिमा निगाह प्राप्‍त गरेको छु भने कृपया मबाट यो उपहार ग्रहण गर्नुहोस्; किनभने तपाईंले ममाथि यति ठूलो निगाह देखाएर स्वीकार गर्नुभएकोले, तपाईंको दर्शन पाउँदा परमेश्‍वरको दर्शन पाएझैँ भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","तपाईंकहाँ ल्याइएको मेरो उपहार ग्रहण गर्नुहोस्; किनकि परमेश्‍वरको अनुग्रहको कारणले मलाई चाहिएका सबै कुरा छन्।” अनि याकोबले कर गरेको कारण एसावले त्यो ग्रहण गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","तब एसावले भने, “अब हामी आफ्नो बाटो लागौँ; अनि म तिमीसित जानेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","तर याकोबले भने, “मेरा मालिकलाई थाहै छ, यी छोराछोरीहरू कलिला छन्; र मैले बथानहरूका दूध खुवाउने भेडीहरू र गाईहरू र तिनीहरूका बच्‍चाहरूको हेरचाह गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","यसकारण म तपाईंलाई बिन्ती गर्दछु, तपाईं नै मभन्दा अगि जानुहोस्। मचाहिँ मेरा मालिककहाँ सेइरमा नपुगुन्जेल अगाडि भएका बथानहरू, बगालहरू र बालबच्‍चाहरूको चालमा बिस्तारै हिँडेर आउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसावले भने, “त्यसो भए म मेरा केही मानिसहरू तिमीसित छोडिदिनेछु।” याकोबले सोधे, “तर त्यसो गर्नु आवश्यक होला र? मलाई केवल मेरा मालिकको दृष्‍टिमा निगाह पाउन दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","यसकारण त्यही दिन एसाव सेइरतिर फर्कन आफ्नो बाटो लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","तर याकोबचाहिँ सुक्‍कोतमा गए, जहाँ तिनले आफ्नै लागि र आफ्ना गाईबस्तुका लागि छाप्राहरू बनाए। यसैकारण त्यस ठाउँलाई सुक्‍कोत भनियो। ");
INSERT INTO npioncb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकोब पद्दन-अरामबाट आउँदा तिनी कनानको शेकेम सहरमा सुरक्षित आइपुगे, र त्यस सहरको छेवैमा पाल टाँगेर बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","तिनले शेकेमका बुबा हामोरका छोराहरूबाट, एक सय चाँदीका टुक्राहरू तिरेर एक टुक्रा जमिन किने, जहाँ तिनले आफ्नो पाल टाँगे। ");
INSERT INTO npioncb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","अनि तिनले त्यहाँ एउटा वेदी खडा गरे, र त्यसलाई एल-एलोहे-इस्राएल भने। ");
INSERT INTO npioncb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","एक दिन याकोबबाट लेआले जन्माएकी छोरी दीना, त्यस देशका स्त्रीहरूलाई भेट गर्न गइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","जब त्यस इलाकाका शासक हिव्वी हामोरको छोरा शेकेमले तिनलाई देखे, तब तिनले उनलाई लगेर उनको इज्जत लुटे। ");
INSERT INTO npioncb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","तिनको हृदय याकोबकी छोरी दीनाप्रति आकर्षित भयो; तिनले त्यस केटीलाई प्रेम गरे, र उनीसित मिठा-मिठा कुरा गरेर फकाए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","अनि शेकेमले आफ्ना पिता हामोरलाई भने, “त्यस केटीलाई मेरी पत्नी हुनलाई ल्याइदिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","जब याकोबले आफ्नी छोरी दीनालाई अशुद्ध बनाइएको थाहा पाए, त्यस बेला तिनका छोराहरू तिनका गाईबस्तुसित खेतमा थिए; यसकारण तिनीहरू घर नआउन्जेल तिनी चुपचाप रहे। ");
INSERT INTO npioncb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","तब शेकेमका पिता हामोर याकोबसित कुरा गर्न गए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","अब जे भएको थियो, त्यो सुन्‍नेबित्तिकै याकोबका छोराहरू खेतबाट घरमा आएका थिए। तिनीहरू विचलित र क्रुद्ध भए; किनभने शेकेमले याकोबकी छोरीलाई अशुद्ध बनाएर इस्राएलको बेइज्जत गरेका थिए। यस्तो शर्मलाग्दो काम गर्नु कदापि उचित थिएन। ");
INSERT INTO npioncb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","तर हामोरले तिनीहरूलाई भने, “मेरो छोरा शेकेमको हृदय तपाईंकी छोरीमा आकर्षित भएको छ। दया गरी तिनलाई त्यसकी पत्नी हुनलाई दिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","हामीसित अन्तर-विवाह गर्नुहोस्; हामीलाई तपाईंका छोरीहरू दिनुहोस्, र हाम्रा छोरीहरू तपाईंहरूले लानुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","अनि तपाईंहरू हामीबीच बसोबास गर्न सक्नुहुनेछ। यो देश तपाईंहरूका लागि खुला छ। यहीँ बसोबास गर्नुहोस्, व्यापार गर्नुहोस् र सम्पत्ति जोड्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","त्यसपछि शेकेमले दीनाका पिता र तिनका दाजुभाइहरूलाई भने, “मैले तपाईंहरूको दृष्‍टिमा निगाह पाऊँ! अनि तपाईंहरूले जे माग्नुहुन्छ, सो म दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","मैले दुलही र तपाईंहरूकहाँ ल्याउनुपर्ने उपहार जतिसुकै ठूलो भए तापनि मूल्य तोक्नुहोस्। तपाईंहरूले जति माग्नुहुन्छ, सो म तिर्नेछु। केवल त्यो कन्यासँग मलाई विवाह गर्न दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","आफ्नी बहिनी दीना अशुद्ध पारिएकोले शेकेम र तिनका पिता हामोरसित कुरा गर्दा याकोबका छोराहरूले छलपूर्ण जवाफ दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","तिनीहरूले उनीहरूलाई भने, “हामी यस्तो गर्न सक्दैनौँ; खतना नभएका मानिसलाई हामी आफ्नी बहिनी दिन सक्दैनौँ। त्यो हाम्रा निम्ति अपमानजनक हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","हामी केवल एउटै शर्तमा तपाईंहरूसँग मन्जुर हुनेछौँ: अर्थात् तपाईंहरूका सबै पुरुषहरूले खतना गरेर हामीजस्तै हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","तब हामी हाम्रा छोरीहरू दिनेछौँ; अनि आफ्ना लागि तपाईंहरूका छोरीहरू लिनेछौँ। हामी तपाईंहरूबीच बसोबास गर्नेछौँ, तपाईंहरूसित एउटै जाति हुनेछौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","तर यदि तपाईंहरू खतना हुन सहमत हुनुभएन भने हामी हाम्री बहिनीलाई लिएर जानेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","हामोर र तिनका छोरा शेकेमलाई तिनीहरूको प्रस्ताव उचित लाग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","आफ्ना पिताका घरानामा सबैभन्दा बढी सम्मान पाएका यस जवान मानिसले तिनीहरूले भनेबमोजिम गर्नलाई समय खेर फालेनन्; किनकि उनले याकोबकी छोरीलाई खूबै मन पराएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","यसकारण हामोर र तिनका छोरा शेकेम आफ्ना नगरबासीहरूलाई यो कुरा भन्‍नलाई आफ्ना सहरको मूलढोकामा गए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","तिनीहरूले भने, “यी मानिसहरू हामीप्रति मित्रतामा छन्। तिनीहरू हाम्रो देशमा बसून्, र व्यापार गरून्; यस देशमा तिनीहरूका निम्ति प्रशस्त ठाउँहरू छन्। हामीले तिनीहरूका छोरीहरू विवाह गर्न सक्छौँ, र तिनीहरूले हाम्रा छोरीहरू। ");
INSERT INTO npioncb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","तर शर्त यो छ, कि हामीले पनि ती मानिसहरूले जस्तै हाम्रा पुरुषहरूका खतना गर्‍यौँ भने मात्र हामीसित एकै जाति भएर बस्‍न मन्जुर हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","के तिनीहरूका गाईबस्तु, तिनीहरूका सम्पत्ति र तिनीहरूका सबै पशुहरू हाम्रा हुँदैनन् र? यसकारण हामी तिनीहरूको शर्त मानौँ, र तिनीहरू हामीसँग बसोबास गर्नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","सहरका मूलढोकाबाहिर निस्कने सबै मानिसहरू हामोर र तिनका छोरा शेकेमसित सहमत भए; अनि सहरमा भएका प्रत्येक पुरुषको खतना गरियो। ");
INSERT INTO npioncb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिन बितेपछि तिनीहरूलाई कष्‍ट भइरहेकै बेला, याकोबका दुई छोराहरू, शिमियोन र लेवी—दीनाका दाजुहरूले आ-आफ्नो तरवार लिएर कसैले थाहै नपाई सहरमा पसेर आक्रमण गरे, र सबै पुरुषहरूलाई मारे। ");
INSERT INTO npioncb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","तिनीहरूले हामोर र तिनका छोरा शेकेमलाई तरवारले काटेर मारे, र दीनालाई शेकेमको घरबाट लिएर गए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकोबका छोराहरू लासहरू भएका ठाउँमा आए; अनि तिनीहरूकी बहिनीलाई अशुद्ध पारिएको सहरलाई लुटे। ");
INSERT INTO npioncb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","तिनीहरूले उनीहरूका बगाल, बथान, गधाहरू र सहरभित्र अनि खेतहरूमा भएका प्रत्येक कुरा लिएर गए। ");
INSERT INTO npioncb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","तिनीहरूले उनीहरूका सबै धनसम्पत्ति, स्त्रीहरू, छोराछोरी र घरमा भएका प्रत्येक कुराहरू लुटको मालझैँ कब्जा गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तब याकोबले शिमियोन र लेवीलाई भने, “तिमीहरूले यस देशमा बस्‍ने मानिसहरू—कनानी र परिज्जीहरूसित मलाई अप्रिय बनाएर ममाथि सङ्कष्‍ट ल्यायौ। हामी अल्प संख्यामा छौँ। यदि तिनीहरू मेरो विरुद्धमा एकमत भएर मलाई आक्रमण गरे भने म र मेरा घराना नष्‍ट हुनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","तर तिनीहरूले जवाफ दिए, “के त्यसले चाहिँ हाम्री बहिनीलाई एउटी वेश्याझैँ व्यवहार गर्न हुनेथियो त?” ");
INSERT INTO npioncb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","तब परमेश्‍वरले याकोबलाई भन्‍नुभयो, “बेथेल गएर त्यहीँ बसोबास गर्, र तँ तेरा दाजु एसावदेखि भागेको बेला तँकहाँ देखा पर्नुहुने परमेश्‍वरका लागि त्यहाँ एउटा वेदी बना।” ");
INSERT INTO npioncb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","यसकारण याकोबले आफ्नो घराना र आफूसँग भएका सबैलाई भने, “तिमीहरूसँग भएका परदेशी देवताहरू त्याग, र आफूलाई शुद्ध पार, र आफ्ना लुगाहरू फेर। ");
INSERT INTO npioncb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","त्यसपछि आओ र हामी बेथेल जाऔँ, जहाँ म परमेश्‍वरका निम्ति एउटा वेदी बनाउनेछु, जसले मेरो सङ्कटमा मलाई जवाफ दिनुभयो र, म जहाँ-जहाँ गएँ, मेरो साथमा रहनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","यसकारण तिनीहरूले आफूसित भएका सबै विदेशी देवताहरू र आफ्ना कानका कुण्डलहरू याकोबलाई दिए; अनि याकोबले ती शेकेममा भएको फलाँटको रूखमुनि गाडिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","त्यसपछि तिनीहरू त्यहाँबाट हिँडे, र तिनीहरू गएको चारैतिरका नगरहरूमा परमेश्‍वरको त्रास फैलियो। त्यसकारण कसैले पनि याकोबका छोराहरूलाई खेदेन। ");
INSERT INTO npioncb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकोब र तिनीसित भएका सबै मानिसहरू कनानको लूजमा (अर्थात्, बेथेलमा) आए। ");
INSERT INTO npioncb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","त्यहाँ तिनले एउटा वेदी बनाए, र तिनले त्यस ठाउँलाई एल-बेथेल भने; किनकि तिनी आफ्ना दाजुदेखि भागेर जाँदा त्यहीँ नै परमेश्‍वरले आफूलाई तिनीकहाँ प्रकट गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","अब रिबेकाकी धाईआमा दबोराको मृत्यु भयो, र तिनलाई बेथेलबाहिर फलाँटको रूखमुनि गाडियो। यसकारण त्यसको नाम अल्‍लोन-बकुत राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकोब पद्दन-अरामबाट फर्केपछि परमेश्‍वर तिनीकहाँ फेरि देखा पर्नुभयो, र तिनलाई आशिष् दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्‍वरले तिनलाई भन्‍नुभयो, “तेरो नाम याकोब हो; तर अब उसो तँलाई याकोब भनिनेछैन, तर तेरो नाम इस्राएल हुनेछ।” यसरी उहाँले तिनको नाम इस्राएल राख्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","अनि परमेश्‍वरले तिनलाई भन्‍नुभयो, “म सर्वशक्तिमान् परमेश्‍वर हुँ; फल्दै-फुल्दै र संख्यामा वृद्धि हुँदै जानू। तँबाट एउटा राष्ट्र र जाति-जातिहरूको एउटा समुदाय निस्कनेछ; र तेरा सन्तानहरूका बीचबाट राजाहरू निस्कनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","मैले अब्राहाम र इसहाकलाई दिएको देश म तँलाई पनि दिनेछु, र यही देश म तँपछि तेरा सन्तानहरूलाई पनि दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","त्यसपछि परमेश्‍वर आफूले तिनीसित कुरा गर्नुभएको त्यस ठाउँबाट माथि जानुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","याकोबले तिनीसित परमेश्‍वरले कुरा गर्नुभएको ठाउँमा एउटा खाँबो ठड्याए; अनि त्यसमाथि तिनले अर्घबलि चढाए; अनि त्यसमाथि तेल पनि खन्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","परमेश्‍वरले तिनीसित कुरा गर्नुभएको त्यस ठाउँको नाम याकोबले बेथेल राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","त्यसपछि तिनीहरू बेथेलबाट हिँडे। तिनीहरू एप्रातदेखि टाढा छँदै राहेललाई सुत्केरी व्यथा लागेर ज्यादै पीडा भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","अनि तिनलाई सुत्केरी व्यथाले कष्‍ट हुँदा सुँडेनीले तिनलाई भनिन्, “नडराउनुहोस्, किनकि तपाईंले अर्को छोरालाई जन्म दिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","जब तिनी मर्नै लागेकी थिइन्, तिनले अन्तिम सास लिँदैगर्दा, तिनले आफ्नो छोराको नाम बेन-ओनी राखिन्। तर त्यसका बुबाले त्यसको नाम बेन्यामीन राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","यसरी राहेलको मृत्यु भयो, र तिनी एप्रात (अर्थात् बेथलेहेम) जाने बाटोमा गाडिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","तिनको चिहानमाथि याकोबले एउटा खाँबो खडा गरे; अनि त्यो खाँबो राहेलको चिहानको सङ्केतको रूपमा आजसम्म पनि छँदैछ। ");
INSERT INTO npioncb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","इस्राएल अझै अगि बढे, र आफ्नो पाल मिग्दल-एदेरको पारिपट्टि टाँगे। ");
INSERT INTO npioncb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","इस्राएल त्यस प्रान्तमा रहेकै बेला रूबेन आफ्ना बुबाकी उपपत्नी बिल्हासित सुते; अनि इस्राएलले यसको बारेमा सुने। ");
INSERT INTO npioncb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआका छोराहरू: रूबेन, जो याकोबका जेठा छोरा थिए, शिमियोन, लेवी, यहूदा, इस्साखार र जबूलून। ");
INSERT INTO npioncb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलका छोराहरू: योसेफ र बेन्यामीन। ");
INSERT INTO npioncb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलकी सेविका बिल्हाका छोराहरू: दान र नप्‍ताली। ");
INSERT INTO npioncb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआकी सेविका जिल्पाका छोराहरू: गाद र आशेर। ");
INSERT INTO npioncb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकोब किर्यत-अर्बाको (अर्थात्, हेब्रोन) नजिक मम्रेमा आफ्ना पिता इसहाककहाँ आए, जहाँ अब्राहाम र इसहाक बस्थे। ");
INSERT INTO npioncb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक एक सय असी वर्षसम्म बाँचे। ");
INSERT INTO npioncb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","तब इसहाकले आफ्नो पूरा बुढेसकालमा, पूरा आयुमा तिनले अन्तिम सास फेरे, र तिनको मृत्यु भयो; अनि आफ्ना पुर्खाहरूसित मिल्न गए। अनि तिनका छोराहरू एसाव र याकोबले तिनलाई गाडे। ");
INSERT INTO npioncb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसावको (अर्थात् एदोमको) विवरण यही हो। ");
INSERT INTO npioncb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावले कनानी स्त्रीहरूबाट हित्ती एलोनकी छोरी आदा, हिव्वी सिबोनकी नातिनी र अनाकी छोरी ओहोलीबामा, ");
INSERT INTO npioncb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","र नबायोतकी बहिनी इश्माएलकी छोरी बासमतलाई पनि आफ्नी पत्नी तुल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसावको निम्ति आदाले एलीपज, बासमतले रूएल, ");
INSERT INTO npioncb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अनि ओहोलीबामाले येऊश, यालाम र कोरह जन्माइन्। यिनीहरू एसावका छोराहरू थिए, जो कनानमा जन्मेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव आफ्ना पत्नीहरू, छोराहरू, छोरीहरू, आफ्ना घरानाका सदस्यहरूका साथै गाईबस्तु र आफ्ना सबै जनावरहरू र तिनले कनानमा प्राप्‍त गरेका सबै कुराहरू लिएर आफ्नो भाइ याकोबदेखि टाढा अर्कै देशमा गए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","तिनीहरूका धनसम्पत्ति धेरै भएकोले तिनीहरू एकसाथ बस्‍न सकेनन्; तिनीहरूका गाईबस्तुका कारण तिनीहरू बसोबास गरेको देशले दुवैलाई धान्‍न सकेन। ");
INSERT INTO npioncb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","यसकारण एसाव (अर्थात् एदोम) सेइरको पहाडी मुलुकमा बसोबास गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेइरको पहाडी मुलुकमा भएका एदोमीहरूका पुर्खा एसावको विवरण यही हो। ");
INSERT INTO npioncb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावका छोराहरूका नाम यिनै हुन्: एसावकी पत्नी आदाका छोरा एलीपज र एसावकी पत्नी बासमतका छोरा रूएल। ");
INSERT INTO npioncb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपजका छोराहरू: तेमान, ओमार, सपो, गाताम र कनज। ");
INSERT INTO npioncb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसावका छोरा एलीपजकी एउटी उपपत्नी पनि थिइन्; जसको नाम तिम्ना थियो, जसले तिनका निम्ति अमालेकलाई जन्माइन्। यिनीहरू एसावकी पत्नी आदाका नातिहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएलका छोराहरू: नहत, जेरह, शम्मा र मिज्जा। यिनीहरू एसावकी पत्नी बासमतका नातिहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","अनाकी छोरी र सिबोनकी नातिनी, ओहोलीबामाले एसावका निम्ति जन्माएका छोराहरू यिनै हुन्: येऊश, यालाम र कोरह। ");
INSERT INTO npioncb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसावका सन्तानहरूमध्ये मुखियाहरूचाहिँ यिनै हुन्: एसावका जेठा छोरा एलीपजका छोराहरू: तेमान, ओमार, सपो, कनज, ");
INSERT INTO npioncb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम र अमालेक। यिनीहरू नै एदोममा भएका एलीपजका सन्तानका मुखियाहरू थिए; तिनीहरू आदाका नातिहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावका छोरा रूएलका छोराहरू: नहत, जेरह, शम्मा र मिज्जा। यिनीहरू एदोममा भएका रूएलका सन्तानका मुखियाहरू थिए; तिनीहरू एसावकी पत्नी बासमतका नातिहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसावकी पत्नी ओहोलीबामाका छोराहरू: येऊश, यालाम र कोरह। यिनीहरू अनाकी छोरी ओहोलीबामा अर्थात् एसावकी पत्नीबाट आएका सन्तानका मुखियाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","यिनीहरू एसावका (अर्थात् एदोमका) छोराहरू थिए; र यिनीहरू नै तिनीहरूका मुखियाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","त्यस इलाकामा बस्‍ने होरीत सेइरका छोराहरू यिनै थिए: लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO npioncb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, र दीशान। एदोम देशमा सेइरका यी छोराहरू होरीतवंशीका मुखियाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतानका छोराहरू: होरी र होमान। तिम्नाचाहिँ लोतानकी बहिनी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालका छोराहरू: अल्बान, मानहत, एबाल, शपो र ओनाम। ");
INSERT INTO npioncb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनका छोराहरू: अय्या र अना। (यही अना हुन्, जसले आफ्ना पिता सिबोनका गधाहरू चराउँदै गर्दा जङ्गलमा तातो पानीको मूल पत्ता लाएका थिए।) ");
INSERT INTO npioncb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाका सन्तानहरू: दीशोन र अनाकी छोरी ओहोलीबामा। ");
INSERT INTO npioncb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशानका छोराहरू: हेमदान, एश्बान, यित्रान र करान। ");
INSERT INTO npioncb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेरका छोराहरू: बिल्हान, जावान र अकान। ");
INSERT INTO npioncb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशानका छोराहरू: ऊज र अरान। ");
INSERT INTO npioncb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","यिनीहरू होरी जातिका मुखियाहरू थिए: लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO npioncb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एसेर र दीशान। ");
INSERT INTO npioncb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","कुनै इस्राएली राजाले राज्य गर्नुभन्दा अगि एदोममा राज्य गर्ने राजाहरू यिनै थिए: ");
INSERT INTO npioncb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बओरका छोरा बेला एदोमका राजा भए। तिनको सहरको नाम दिन्हावा राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेलाको मृत्युपछि, बोज्रामा बस्‍ने जेरहका छोरा योबाब तिनको ठाउँमा राजा भए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाबको मृत्युपछि, तेमानीहरूको देशमा बस्‍ने हूशाम तिनको ठाउँमा राजा भए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हूशामको मृत्युपछि, मोआबको देशमा मिद्यानलाई जित्ने बेददका छोरा हदद तिनको ठाउँमा राजा भए। तिनको सहरको नाम अवीत राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हददको मृत्युपछि, मस्रेकामा बस्‍ने शम्‍ला तिनको ठाउँमा राजा भए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","शम्‍लाको मृत्युपछि, यूफ्रेटिस नदी नजिकै बस्‍ने रहोबोतका शौल तिनको ठाउँमा राजा भए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौलको मृत्युपछि, अक्बोरका छोरा बाल-हानान तिनको ठाउँमा राजा भए। ");
INSERT INTO npioncb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अक्बोरका छोरा बाल-हानानको मृत्युपछि, हदद तिनको ठाउँमा राजा भए। तिनको सहरको नाम पाऊ राखियो। तिनकी पत्नीको नाम महेतबेल थियो, जो मत्रेदकी छोरी र मेजहाबकी नातिनी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","तिनीहरूका वंश र क्षेत्रअनुसार एसावका सन्तानका मुखियाहरूका नाम यिनै हुन्: तिम्ना, अल्वा, यतेत, ");
INSERT INTO npioncb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा, एलाह, पीनोन, ");
INSERT INTO npioncb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज, तेमान, मिब्सार, ");
INSERT INTO npioncb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल र ईराम। ");
INSERT INTO npioncb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकोब आफ्ना पिता परदेशी बनेर बसेको देश कनानमा बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकोबका वंशको विवरण यही हो। योसेफ सत्र वर्षको जवान हुँदा तिनका दाजुहरूसँग भेडाबाख्राका बगालहरू चराउँथे। एक दिन तिनले आफ्ना पिताका पत्नीहरू बिल्हा र जिल्पाका छोराहरूको खराब व्यवहारको खबर आफ्ना बुबाकहाँ ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएलले योसेफलाई आफ्ना अरू छोराहरूभन्दा धेरै माया गर्थे; किनकि तिनी उनको बुढेसकालमा जन्मेका थिए; अनि तिनले उनका लागि एउटा राम्रो बुट्टेदार लबेदा बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","तिनका दाजुहरूले आफ्ना पिताले तिनलाई उनीहरूलाई भन्दा धेरै माया गरेको देखेर उनीहरूले तिनलाई घृणा गर्थे, र तिनीसँग नरम भएर बोल्दैनथे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","योसेफले एउटा सपना देखे; अनि जब त्यो सपना तिनले आफ्ना दाजुहरूलाई सुनाए, तब उनीहरूले तिनलाई झन् धेरै घृणा गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","तिनले उनीहरूलाई भने, “मैले देखेको सपना सुन्‍नुहोस्: ");
INSERT INTO npioncb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हामी खेतमा अन्‍नका बिटाहरू बाँधिरहेका थियौँ; तब अकस्मात् मेरो बिटा उठेर सीधा खडा भयो; अनि तपाईंहरूका बिटाहरू मेरो बिटाका चारैतिर जम्मा भएर मेरो बिटालाई दण्डवत् गरे।” ");
INSERT INTO npioncb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","यो सुनेर तिनका दाजुहरूले तिनलाई भने, “के तँ हामीमाथि शासन गर्न खोज्दैछस्? के तैँले साँच्‍चै नै हामीमाथि शासन गर्नेछस्?” अनि त्यो सपना र तिनले भनेका कुराको कारण उनीहरूले तिनलाई झन् धेरै घृणा गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","त्यसपछि तिनले अर्को सपना देखे, र तिनले त्यो आफ्ना दाजुहरूलाई सुनाए। तिनले भने, “सुन्‍नुहोस्, मैले अर्को सपना देखेको छु; अनि यस पटक सूर्य, चन्द्र र एघार ताराहरूले मलाई दण्डवत् गरिरहेका थिए।” ");
INSERT INTO npioncb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","जब तिनले आफ्ना दाजुहरूलाई बताएझैँ त्यो सपना आफ्ना पितालाई पनि बताए; तब तिनका पिताले तिनलाई हप्काउँदै भने, “तैँले देखेको यो सपना कस्तो हो? के तेरी आमा र मैले अनि तेरा दाजुहरूले साँच्‍चै आएर तेरो सामु भुइँसम्मै निहुरेर तँलाई दण्डवत् गर्नुपर्ने हो?” ");
INSERT INTO npioncb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","तिनका दाजुहरू तिनीप्रति डाही भए; तर तिनका पिताले चाहिँ यस कुरालाई मनमै राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","अब तिनका दाजुहरू आफ्ना पिताका बगाल चराउन शेकेमको नजिक गएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","अनि इस्राएलले योसेफलाई भने, “तँलाई थाहै छ कि तेरा दाजुहरू शेकेमको नजिक बगालहरू चराउँदैछन्। आइज, म तँलाई उनीहरूकहाँ पठाउँछु।” तिनले भने, “हवस्, म जान्छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","यसकारण इस्राएलले तिनलाई भने, “गएर हेर्, तेरा दाजुहरू र बगालहरू ठिक छन् कि छैनन्, अनि मकहाँ खबर लिएर आइज।” तब उनले तिनलाई हेब्रोनको बेँसीबाट पठाइदिए। जब योसेफ शेकेममा आइपुगे, ");
INSERT INTO npioncb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","एक जना मानिसले तिनलाई खेततिर यताउति घुमिरहेका देखे, र सोधे, “तिमी के खोज्दैछौ?” ");
INSERT INTO npioncb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","तिनले जवाफ दिए, “म मेरा दाजुहरूलाई खोज्दैछु। उनीहरूले बगाल कहाँ चराउँदैछन्, के तपाईं मलाई भन्‍न सक्नुहुन्छ?” ");
INSERT INTO npioncb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ती मानिसले जवाफ दिए, “उनीहरू यहाँबाट गइसके। उनीहरूले हामी ‘दोतानमा जाऊँ’ भन्दै गरेका मैले सुनेको थिएँ।” यसकारण योसेफ आफ्ना दाजुहरूलाई खोज्दै गए, र उनीहरूलाई दोतानको नजिक भेट्टाए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","तर उनीहरूले तिनलाई टाढैबाट देखे, र तिनी उनीहरूकहाँ आइपुग्नुअगि नै तिनको उनीहरूले हत्या गर्ने षड्यन्त्र रचे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","उनीहरूले आपसमा भने, “त्यो स्वप्नदर्शी आउँदैछ!” ");
INSERT INTO npioncb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“अब आओ, हामी त्यसलाई मारेर एउटा खाडलमा फ्याँकिदिऔँ; अनि एउटा डरलाग्दो जनावरले त्यसलाई खाएछ भनेर भनिदिऔँ। तब त्यसका सपनाहरू के हुँदारहेछन्, हेरौँला।” ");
INSERT INTO npioncb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","जब रूबेनले यो कुरा सुने, तब उनले तिनलाई उनीहरूका हातबाट छुटाउने कोसिस गरे। उनले भने, “हामी त्यसको ज्यानचाहिँ नलिऔँ। ");
INSERT INTO npioncb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","रक्तपात नगरौँ। बरु त्यसलाई यहाँ मरुभूमिको यस खाडलमा फ्याँकिदिऔँ; तर त्यसमाथि हातचाहिँ नउठाऔँ।” रूबेनले तिनलाई तिनीहरूका हातबाट छुटाएर तिनलाई आफ्ना पिताकहाँ फर्काएर लगिदिनका लागि यसो भनेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","यसकारण जब योसेफ आफ्ना दाजुहरूकहाँ आइपुगे, तब तिनले लगाएका राम्रा बुट्टेदार भएको लामो लबेदा उनीहरूले फुकालेर खोसे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","अनि उनीहरूले तिनलाई लगेर एउटा खाडलमा फ्याँकिदिए। त्यो खाडल रित्तो थियो; त्यसभित्र पानी थिएन। ");
INSERT INTO npioncb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","जब उनीहरू खान बसे, तब उनीहरूले आँखा उठाएर हेरे; अनि गिलादबाट इश्माएलीहरूका एक दल आइरहेका देखे। तिनीहरूले ऊँटहरूमाथि मसलाहरू, सुगन्धित लेप र मूर्र लादेर इजिप्टमा लाँदैथिए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","यहूदाले आफ्ना दाजुभाइहरूलाई भने, “आफ्ना भाइलाई मारेर त्यसको रगत लुकाएर हामीलाई के फाइदा छ र? ");
INSERT INTO npioncb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","बरु हामी यसलाई यी इश्माएलीहरूलाई बेचिदिऔँ, र यसमाथि हातचाहिँ नहालौँ; आखिर जे भए तापनि यो हाम्रै भाइ, हाम्रै मासु र रगत हो।” अनि उनका दाजुभाइहरू सहमत भए। ");
INSERT INTO npioncb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","यसकारण जब ती मिद्यानी व्यापारीहरू नजिक आइपुगे; तिनका दाजुहरूले योसेफलाई खाडलबाट तानेर माथि निकाले, र तिनलाई चाँदीका बीस शेकेलमा इश्माएलीहरूलाई बेचिदिए; जसले तिनलाई इजिप्टमा लगे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","जब रूबेन खाडलमा फर्केर आए, तब योसेफलाई त्यहाँ नदेख्दा उनले आफ्ना वस्त्रहरू च्याते। ");
INSERT INTO npioncb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","उनी आफ्ना भाइहरूकहाँ गएर भने, “त्यो केटो त त्यहाँ छैन! अब म के गरूँ?” ");
INSERT INTO npioncb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","त्यसपछि उनीहरूले योसेफको लबेदा लिए, र एउटा बाख्रा मारेर त्यो लबेदालाई त्यस रगतमा चोपे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","अनि त्यो राम्रो बुट्टेदार भएको लबेदा फर्काएर उनीहरूले आफ्ना पिताकहाँ लगेर भने, “हेर्नुहोस् त, हामीले यो लबेदा भेट्टाएका छौँ; के यो तपाईंको छोराको हो र?” ");
INSERT INTO npioncb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","तिनले त्यो चिनेर भने, “यो त मेरै छोराको लबेदा हो! कुनै डरलाग्दो जङ्गली पशुले योसेफलाई खाएछ क्यारे। पक्‍कै पनि त्यसलाई खाएर च्यात्तचुत्त पारेछ!” ");
INSERT INTO npioncb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","तब याकोबले आफ्ना वस्त्रहरू च्याते, भाङ्ग्रा ओढे र आफ्नो छोराको लागि धेरै दिनसम्म शोक गरिरहे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","तिनका सबै छोराछोरीहरूले तिनलाई सान्त्वना दिन आए; तर तिनले शान्त हुन मानेनन्। तिनले भने, “होइनँ, म मेरो छोराकहाँ चिहानमा नगएसम्म शोक गरिरहनेछु।” यसरी तिनका पिताले तिनका निम्ति बिलौना गरिरहे। ");
INSERT INTO npioncb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","यही बीचमा ती मिद्यानीहरूले योसेफलाई इजिप्टमा फारोका अधिकारीहरूमध्ये एक जना अङ्गरक्षकका सेनापति पोतिफरलाई बेचिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","त्यस समयमा यहूदा आफ्ना दाजुभाइहरूलाई छोडेर हीरा नाम भएको अदुल्‍लामबासीका एक जना मानिसकहाँ बस्‍नलाई गए। ");
INSERT INTO npioncb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","त्यहाँ यहूदाले शूआ नाम भएको एक कनानी मानिसकी छोरीलाई भेटे। तिनले उनलाई विवाह गरे, र उनीसँग सहवास गरे; ");
INSERT INTO npioncb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","अनि उनी गर्भवती भइन् र एउटा छोरा जन्माइन्; जसको नाम एर् राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","उनी फेरि गर्भवती भइन्, र अर्को छोरा जन्माइन्; अनि त्यसको नाम ओनान राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","उनले अर्को छोरा पनि जन्माइन्; अनि त्यसको नाम शेलह राखिन्। उनले उसलाई तिनी कजीबमा हुँदा जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाले आफ्नो जेठा छोरा, एर्‌का लागि एउटी पत्नी ल्याइदिए, जसको नाम तामार थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","तर यहूदाका जेठा छोरा एर् याहवेहको दृष्‍टिमा दुष्‍ट थिए; यसकारण याहवेहले त्यसको प्राण लिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","तब यहूदाले ओनानलाई भने, “तेरी भाउजूकहाँ जा, र देवरले गर्नुपर्ने कर्तव्य पूरा गर्; अनि तेरा दाजुका निम्ति सन्तान उत्पन्‍न गर्।” ");
INSERT INTO npioncb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","तर ओनानले यो थाहा पाए कि त्यो सन्तान तिनको आफ्नो हुनेछैन; यसकारण जहिले-जहिले तिनी भाउजूकहाँ सुत्न गए, तिनले दाजुको निम्ति सन्तान नहोस् भन्‍नको लागि आफ्नो वीर्यचाहिँ भुइँमा खसाले। ");
INSERT INTO npioncb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","तिनले जे गरे, त्यो याहवेहको दृष्‍टिमा दुष्‍ट थियो; यसकारण उहाँले तिनलाई पनि नष्‍ट गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","त्यसपछि यहूदाले आफ्नी बुहारी तामारलाई भने, “मेरो छोरा शेलह ठूलो नभएसम्म तिमी आफ्ना पिताको घरमा विधवा भई बस।” किनकि तिनका दाजुहरूजस्तै शेलहको पनि मृत्यु होला भनेर तिनले सोचेका थिए। यसकारण तामार आफ्ना पिताको घरमा बस्‍नलाई गइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","धेरै समयपछि शूआकी छोरी, यहूदाकी पत्नी मरिन्। जब यहूदा आफ्नो शोकबाट उत्रिए, तब उनी आफ्ना मित्र अदुल्‍लामबासी हीरासँग तिम्नामा मानिसहरूले उनका भेडाहरूको ऊन कत्रने ठाउँमा गए। ");
INSERT INTO npioncb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","जब तिम्रा ससुरा आफ्ना भेडाहरूको ऊन कत्रनलाई तिम्नातिर आउँदैछन् भनेर तामारलाई बताइयो, ");
INSERT INTO npioncb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तिनले आफ्नो विधवाको पोशाक फुकालिन्, र आफूलाई नचिन्‍ने बनाउनको लागि आफूलाई घुम्टोले छोपिन्, र तिम्ना जाने बाटोमा भएको एनैमको प्रवेशद्वारमा बसिन्; किनकि शेलह ठूलो भइसकेपछि पनि त्यसकी पत्नी हुन नदिइएको तिनले देखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","जब यहूदाले तिनलाई देखे, तिनले अनुहार छोपेकी हुनाले उनले तिनलाई वेश्या भनी ठाने। ");
INSERT INTO npioncb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","आफ्नै बुहारी हो भनी उनले थाहा नपाएर तिनी बाटोको किनारमा गएर तिनलाई भने, “मसँग आऊ, र मलाई तिमीसित सुत्न देऊ।” “तपाईंसँग सुतेँ भने मलाई के दिनुहुन्छ?” तिनले सोधिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","उनले भने, “म मेरा भेडाका बथानबाट तिमीलाई एउटा पाठो पठाइदिनेछु।” तिनले सोधिन्, “तपाईंले त्यो नपठाउन्जेल मलाई बन्धकको रूपमा केही कुरा दिनुहुन्छ?” ");
INSERT INTO npioncb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदाले भने, “म तिमीलाई के बन्धक दिऊँ?” तिनले जवाफ दिइन्, “तपाईंको छाप भएको औँठी, त्यसको डोरी र तपाईंको हातमा भएको त्यो लहुरो राखे हुन्छ।” यसकारण उनले ती कुराहरू तिनलाई दिए, र तिनीसित सुते; अनि उनीद्वारा तिनी गर्भवती भइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","त्यसपछि तिनी आफ्नो घर गइन्, र आफ्नो घुम्टो फुकालेर फेरि आफ्नो विधवाको वस्त्र लगाइन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","त्यसपछि त्यस स्त्रीबाट आफ्नो बन्धक फिर्ता गराउनलाई यहूदाले आफ्नो अदुल्‍लामबासी हिराद्वारा एउटा कलिलो पाठो त्यस स्त्रीकहाँ पठाए, तर उनले तिनलाई भेट्टाउन सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","उनले त्यहाँ बस्‍ने मानिसहरूलाई “एनैम देवस्थानमा बस्‍ने देवदासी कहाँ छे?” भनी सोधे। तिनीहरूले भने, “यहाँ त देवस्थानमा बस्‍ने कुनै देवदासी छैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","यसकारण उनी यहूदाकहाँ फर्किगएर भने, “मैले तिनलाई भेट्टाइनँ। त्यस ठाउँका मानिसहरूले पनि, ‘यहाँ देवस्थानमा बस्‍ने कुनै देवदासी छैन’ भने।” ");
INSERT INTO npioncb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","तब यहूदाले भने, “त्यससित जे छन्, ती आफूसितै राखोस्, नत्रता हामी हाँसोको पात्र हुनेछौँ। जे भए तापनि मैले त्यसलाई यो कलिलो पाठो पठाएकै हुँ, तर तिमीले त्यसलाई भेट्टाएनौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","प्रायः तीन महिनापछि यहूदालाई “तपाईंकी बुहारी तामार वेश्यावृत्तिको दोषी ठहरिएकी छिन्; अनि त्यसको फलस्वरूप तिनी अहिले गर्भवती भएकी छिन्” भनियो। यहूदाले भने, “तिनलाई बाहिर निकाल र जलाएर मारिदेओ!” ");
INSERT INTO npioncb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","तिनलाई जब बाहिर निकाल्न लागे, तब तिनले आफ्ना ससुरालाई एउटा खबर पठाइन्। “यी सामानहरू जसका हुन्, तिनैद्वारा म गर्भवती भएकी हुँ,” तिनले भनिन्। अनि तिनले अझ थपेर भनिन्, “तपाईंले यो छाप-औँठी, डोरी, र लहुरो कसका हुन् भनी चिन्‍न सक्नुहुन्छ कि?” ");
INSERT INTO npioncb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाले ती कुराहरू चिनेर भने, “तिनी त मभन्दा धर्मी रहिछिन्; किनकि मैले तिनलाई आफ्नो छोरो शेलह तिनका पति हुनलाई दिइनँ।” अनि उनी तिनीसित फेरि सुतेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","जब तिनको सुत्केरी हुने समय आयो, तिनका गर्भमा जुम्ल्याहा छोराहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","जब तिनी प्रसव-वेदनामा थिइन्, तीमध्ये एउटाले आफ्नो हात बाहिर निकाल्यो; यसकारण सुँडेनीले एउटा रातो डोरी लिएर त्यसको नाडीमा बाँधिदिइन् र भनिन्, “पहिले निस्केको यही हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","तर जब त्यसले आफ्नो हात फेरि भित्र तान्यो, त्यसको भाइचाहिँ बाहिर निस्क्यो; अनि तिनले भनिन्, “तँ यसरी आउनमा सफल भइस्!” अनि त्यसको नाम पेरेस राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","तब आफ्नो नाडीमा रातो डोरी लिएको त्यसको भाइ बाहिर आयो र त्यसको नाम जेरह राखियो। ");
INSERT INTO npioncb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","अब योसेफलाई तल इजिप्टमा लगिएको थियो। फारोका अधिकारी, अङ्गरक्षकका सेनापति पोतिफर भन्‍ने इजिप्टियनले तिनलाई त्यहाँ लैजाने इश्माएलीहरूबाट किने। ");
INSERT INTO npioncb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","याहवेह योसेफसित हुनुभएकोले तिनको उन्‍नति भयो, र तिनी आफ्ना इजिप्टियन मालिकको घरमा बस्‍न लागे। ");
INSERT INTO npioncb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","जब तिनका मालिकले याहवेह योसेफको साथमा हुनुभएको र तिनले गरेका सबै कुरामा उहाँले आशिष् दिनुभएको देखे, ");
INSERT INTO npioncb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","योसेफले उनको दृष्‍टिमा निगाह पाए, र उनका मुख्य कारिन्दा भए। पोतिफरले तिनलाई आफ्नो घरको जिम्मा दिए र उनीसित भएका सबै कुराहरूमाथि रेखदेख गर्न जिम्मेवारी सुम्पिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","पोतिफरले आफ्नो घरको र आफूसित भएका सबै कुराको जिम्मा योसेफलाई दिएको समयदेखि तिनको कारण याहवेहले त्यहाँका इजिप्टियन घरलाई आशिष् दिनुभयो। याहवेहको आशिष् पोतिफरसित भएका सबै कुराहरूमा, अर्थात् घरभित्र र खेतमा भएका दुवै कुराहरूमाथि थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","यसकारण उनले आफूसित भएका सबै कुराहरू योसेफको रेख-देखमा छोडिदिए; आफूले खाने भोजनबाहेक अरू कुनै कुरामा पनि उनले चिन्ता गरेनन्। योसेफ हट्टाकट्टा र सुन्दर थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","अनि केही समयपछि तिनका मालिककी पत्नीले योसेफलाई मन पराउन थालिन् र भनिन्, “मसँग ओछ्यानमा आऊ!” ");
INSERT INTO npioncb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","तर तिनले अस्वीकार गरे। तिनले आफ्नी मालिक्नीलाई भने, “सबै कुरा मेरो जिम्मामा रहेकोले मेरा मालिकलाई घरको कुनै कुराको पनि चिन्ता छैन। उहाँसित भएका सबै कुरा उहाँले मेरै रेख-देखमा राखिदिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","यस घरमा मभन्दा ठूलो अरू कोही छैन। तपाईं उहाँकी पत्नी हुनुभएकोले, मेरा मालिकले तपाईंबाहेक अरू कुनै कुरा पनि मदेखि अलग राख्नुभएको छैन। त्यसकारण यस्तो दुष्‍ट काम गरेर कसरी परमेश्‍वरको विरुद्धमा म पाप गर्न सक्छु र?” ");
INSERT INTO npioncb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","अनि तिनले दिनदिनै योसेफलाई त्यसो भने तापनि योसेफले तिनीसित सुत्न त परै जाओस्, तिनको नजिक बस्‍न समेत अस्वीकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन योसेफ आफ्नो काम गर्न भनी घरभित्र गए; घरभित्र अरू कोही पनि सेवकहरू थिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","तब तिनले योसेफको लुगा समात्दै, “आऊ, मसँग ओछ्यानमा सुत!” भनिन्, तर आफ्नो लुगा तिनको हातैमा छाडेर तिनी घरबाट बाहिर भागे। ");
INSERT INTO npioncb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","जब योसेफले आफ्नो लुगा तिनकै हातमा छाडेर घरदेखि बाहिर भागेको तिनले देखिन्, ");
INSERT INTO npioncb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","तब तिनले आफ्ना घरका सेवकहरूलाई बोलाएर तिनीहरूलाई भनिन्, “हेर, यस हिब्रूलाई त हाम्रो बेइज्जत गर्न भनेर पो हामीकहाँ ल्याइएको रहेछ! त्यो मसँग सुत्नलाई यहाँ भित्र आयो, र म चिच्याएँ। ");
INSERT INTO npioncb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जब म चिच्याएको त्यसले सुन्यो, तब त्यसले आफ्नो लुगा मेरो छेउमा छोडेर घरबाट बाहिर भाग्यो।” ");
INSERT INTO npioncb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","तिनले त्यो लुगा आफ्ना पति नआउन्जेल आफ्नै साथमा राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","तब तिनले उनलाई यो घटना भनिन्: “तपाईंले ल्याउनुभएको त्यो हिब्रू सेवक मेरो इज्जत लुट्न भनी मकहाँ आयो। ");
INSERT INTO npioncb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","तर म जब सहायताको लागि चिच्याएँ, तब त्यसले आफ्नो लुगा मेरो छेउमा छोडेर घरबाट बाहिर भाग्यो।” ");
INSERT INTO npioncb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","जब उनका मालिकले आफ्नी पत्नीले, “तपाईंको दासले मसँग यस्तो व्यवहार गर्‍यो,” भनेको घटना सुने, तब तिनी रिसले चुर भए। ");
INSERT INTO npioncb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","योसेफका मालिकले तिनलाई राजाका कैदीहरू थुन्‍ने झ्यालखानामा लगेर हालिदिए। तर योसेफ त्यस झ्यालखानामा हुँदा, ");
INSERT INTO npioncb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","याहवेह तिनको साथमा हुनुहुन्थ्यो, र उहाँले तिनीमाथि दया देखाउनुभयो, र झ्यालखानाका हाकिमको दृष्‍टिमा तिनलाई निगाह प्राप्‍त गराइदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","यसकारण झ्यालखानाका हाकिमले योसेफलाई झ्यालखानामा राखिएका सबैमाथि रेखदेख गर्ने जिम्मा दिए; अनि तिनलाई त्यहाँ गरिने सबै कुराहरूका जिम्मेवारी सुम्पिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ती हाकिमले योसेफको जिम्मामा रहेका कुनै कुरामाथि पनि चिन्ता गर्दैनथिए; किनकि याहवेह योसेफसित हुनुहुन्थ्यो, र तिनले गरेका सबै कुरामा उहाँले तिनलाई सफलता दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","केही समयपछि इजिप्टका राजाका मुख्य मद्य टक्र्याउने र मुख्य भान्सेले आफ्ना मालिक इजिप्टका राजाको विरुद्धमा अपराध गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फारो आफ्ना दुई पदाधिकारीहरू अर्थात् मुख्य मद्य टक्र्याउने र मुख्य भान्से दुवैसँग क्रोधित भए। ");
INSERT INTO npioncb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","अनि तिनीहरूलाई अङ्गरक्षकका सेनापतिको घरमा थुनामा राखिदिए, जहाँ योसेफ पनि थुनामा परेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","अङ्गरक्षकका सेनापतिले तिनीहरूलाई पनि योसेफको जिम्मामा सुम्पिदिए, र तिनले उनीहरूको हेरचाह गरे। उनीहरू थुनामा रहेको केही समयपछि, ");
INSERT INTO npioncb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ती दुई मानिसहरू—अर्थात् इजिप्टका राजाका मद्य टक्र्याउने र भान्से, जो झ्यालखानामा परेका थिए, ती दुवैले एकै रातमा आ-आफ्ना सपना देखे, र प्रत्येक सपनाको आ-आफ्नै अर्थ थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","भोलिपल्ट बिहान जब योसेफ उनीहरूकहाँ आए, तिनले उनीहरूलाई उदास देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","यसकारण तिनले आफ्ना मालिकका घरमा आफूसित थुनामा परेका फारोका पदाधिकारीहरूलाई सोधे, “आज तपाईंहरू किन यति उदास हुनुहुन्छ?” ");
INSERT INTO npioncb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","तिनीहरू दुवैले जवाफ दिए, “हामी दुवैले सपना देखेका छौँ, तर यसको अर्थ खोलिदिने कोही पनि छैन।” तब योसेफले तिनीहरूलाई भने, “के सपनाका अर्थहरू परमेश्‍वरबाट खोलिने होइनन् र? मलाई तपाईंहरूका सपनाहरू भन्‍नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","यसकारण मुख्य मद्य टक्र्याउनेले योसेफलाई आफ्नो सपना भने। उनले तिनलाई भने, “मेरो सपनामा मैले मेरो सामु एउटा दाखको बोट देखेँ, ");
INSERT INTO npioncb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","अनि त्यस बोटमा तीन वटा हाँगाहरू थिए। जब त्यसमा टुसा पलाएर फूल फुल्यो, त्यसका झुप्पाहरू पाकेका दाखहरू भए। ");
INSERT INTO npioncb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","फारोको कचौरा मेरो हातमा थियो, मैले दाखहरू लिएँ, र ती दाखहरूलाई फारोको कचौराभित्र निचोरिदिएँ; अनि त्यो कचौरा तिनको हातमा टक्र्याइदिएँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","योसेफले उनलाई भने, “यसको अर्थ यही हो, तीन हाँगाहरू तीन दिन हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तीन दिनभित्र फारोले तपाईंलाई उच्‍च पार्नुहुनेछ, र तपाईंलाई तपाईंको पहिलेकै काममा नियुक्त गर्नुहुनेछ; अनि तपाईं तिनको मद्य टक्र्याउने हुँदा जे गर्नुहुन्थ्यो, त्यसरी नै तपाईंले फारोको कचौरा उहाँको हातमा टक्र्याउनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","तर जब तपाईंसँग सबै कुरा सही हुन्छ, मलाई सम्झनुहोला, र ममाथि दया देखाउनुहोला; फारोलाई मेरो विषयमा भनिदिनुहोस्, र मलाई यस झ्यालखानाबाट बाहिर निकालिदिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","किनकि मलाई हिब्रूहरूको देशबाट बलपूर्वक ल्याइएको हो; अनि यहाँ पनि मैले झ्यालखानामा हालिने कुनै काम गरेको छैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","जब योसेफले मुख्य मद्य टक्र्याउनेको सपनाको अर्थ राम्रो खोलिदिएको मुख्य भान्सेले देखे, उनले योसेफलाई भने, “मैले पनि एउटा सपना देखेँ: मेरो शिरमा रोटीले भरिएका तीन टोकरीहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","माथिल्‍लो टोकरीमा फारोका लागि पकाइएका सबै किसिमका खानेकुराहरू थिए; तर चराहरूले मेरो शिरमा भएको टोकरीबाट खाइरहेका थिए।” ");
INSERT INTO npioncb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","“यसको अर्थ यही हो,” योसेफले भने, “ती तीन टोकरीहरू तीन दिन हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","तीन दिनभित्र फारोले तपाईंको शिर काट्नुहुनेछ, र तपाईंको शरीरलाई एउटा रूखमा झुण्ड्याइदिनुहुनेछ। अनि चराहरूले तपाईंको शरीरलाई खानेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","अब तेस्रो दिनमा फारोको जन्मदिन थियो। अनि उनले आफ्ना सबै पदाधिकारीहरूलाई भोज दिए। उनले आफ्ना पदाधिकारीहरूको उपस्थितिमा आफ्ना मुख्य मद्य टक्र्याउने र मुख्य भान्सेलाई थुनामुक्त गरे: ");
INSERT INTO npioncb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","फारोले मुख्य मद्य टक्र्याउनेलाई पहिलेकै काममा नियुक्त गरे। अनि उनले फेरि फारोको हातमा कचौरा टक्र्याए; ");
INSERT INTO npioncb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","तर योसेफले उनीहरूलाई अर्थ बताएझैँ मुख्य भान्सेलाई फारोले झुन्ड्याइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","तर मुख्य मद्य टक्र्याउनेले योसेफलाई सम्झेनन्; उनले तिनलाई बिर्से। ");
INSERT INTO npioncb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","पूरा दुई वर्ष बितिसकेपछि फारोले एउटा सपना देखे; सपनामा तिनी नील नदीको किनारमा उभिरहेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","अनि नील नदीबाट सात वटा चिल्‍ला र मोटा गाईहरू निस्केर आए, र काँसको घारीमा चर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","त्यसपछि तिनीहरूका पछि-पछि अरू सात वटा कुरूप र दुब्ला गाईहरू नील नदीबाट बाहिर निस्के, र ती पहिलेका गाईहरूसँगै किनारको छेउमा उभिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","अनि ती कुरूप र दुब्ला गाईहरूले ती चिल्‍ला र मोटा गाईहरूलाई खाइदिए। त्यसपछि फारो बिउँझे। ");
INSERT INTO npioncb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","उनी फेरि निदाए, र दोस्रो सपना देखे: अन्‍नका सात वटा भरिला र असल बालाहरू एउटै डाँठमा फलिरहेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","त्यसपछि अन्‍नका अरू सात वटा पातला र पूर्वीय बतासले ओइलाएका बालाहरू निस्के। ");
INSERT INTO npioncb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","अनि ती पातला अन्‍नका बालाहरूले भरिला सात वटा बालाहरूलाई निलिदिए। त्यसपछि फारो बिउँझे; अनि यो त पो सपना रहेछ भनी थाहा पाए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","बिहान उनको मन विचलित भयो; त्यसकारण उनले इजिप्टका सबै जादुगर र ज्ञानी मानिसहरूलाई बोलाए। फारोले तिनीहरूलाई आफ्ना सपनाहरू बताए; तर उनका निम्ति ती सपनाका अर्थ खोलिदिन कसैले पनि सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब त्यस मुख्य मद्य टक्र्याउनेले फारोलाई भने, “आज मलाई मेरो गल्ती याद आएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","एकपल्ट फारो आफ्ना सेवकहरूसँग रिसाउनुभएको थियो। अनि उहाँले मलाई र मुख्य भान्सेलाई अङ्गरक्षकका सेनापतिको घरको झ्यालखानामा थुन्‍नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","हामी दुवैले एकै रात सपना देख्यौँ, र ती प्रत्येक सपनाको आ-आफ्नै अर्थ थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","त्यहाँ हामीसँग एउटा हिब्रू जवान अङ्गरक्षकका सेनापतिका सेवक थिए। हामीले तिनलाई आफ्ना सपनाहरू बतायौँ; अनि तिनले हामीलाई हाम्रा आ-आफ्नो सपनाअनुसारको अर्थ खोलिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","अनि तिनले हामीलाई अर्थ खोलिदिएजस्तै भयो: म आफ्नो काममा फेरि नियुक्त भएँ, तर अर्को मानिसचाहिँ झुन्ड्याइयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","यसकारण फारोले योसेफलाई बोलाउन पठाए; अनि तिनलाई झट्टै झ्यालखानाबाट बाहिर ल्याइयो। अनि तिनले आफ्नो दाह्री खौरे, र आफ्नो वस्त्र फेरेपछि तिनी फारोको सामु आए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फारोले योसेफलाई भने, “मैले एउटा सपना देखेको छु, तर कसैले पनि त्यसको अर्थ खोल्न सकेनन्। तिमीले सपना सुनेपछि त्यसको अर्थ खोल्न सक्छौ भन्‍ने मैले सुनेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफले फारोलाई जवाफ दिए, “यसो गर्न मेरो शक्तिभन्दा बाहिरको कुरा हो,” “तर परमेश्‍वरले नै फारोलाई उहाँले चाहे अनुसारको जवाफ दिनुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","तब फारोले योसेफलाई भने, “मेरो सपनामा म नील नदीको किनारमा उभिरहेको थिएँ; ");
INSERT INTO npioncb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","अनि नील नदीबाट सात वटा चिल्‍ला र मोटा गाईहरू निस्केर आए, र काँसको घारीमा चर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","त्यसपछि तिनीहरूका पछि-पछि अरू सात वटा घिनलाग्दा, कुरूप र अति दुब्ला गाईहरू निस्किआए। मैले इजिप्टमा कुरूप र दुब्ला गाईहरू कहिल्यै देखेको थिइनँ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","अनि दुब्ला र कुरूप गाईहरूले ती पहिले आएका सात वटा मोटा गाईहरूलाई खाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","तर तिनीहरूले ती सात वटालाई खाइसकेपछि पनि तिनीहरूले खाए भनेर कसैले भन्‍न सकेनन्; किनकि तिनीहरू पहिलेजस्तै कुरूप देखिन्थे। त्यसपछि म बिउँझेँ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“मेरो दोस्रो सपनामा मैले अन्‍नका सात वटा भरिला र असल बालाहरू एउटै डाँठमा फलिरहेका देखेँ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","तिनीहरूको पछि ती ओइलाएका, पातला र पूर्वीय बतासले झूल्सेका अन्‍नका सात वटा बालाहरू निस्के। ");
INSERT INTO npioncb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ती पातला अन्‍नका बालाहरूले असल बालाहरूलाई निलिदिए। मैले यो कुरा जादुगरहरूलाई भनेँ, तर मलाई यसको अर्थ खोलिदिन कसैले पनि सकेनन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब योसेफले फारोलाई भने, “हजुरका सपनाहरू एउटै र उस्तै हुन्। परमेश्‍वरले के गर्न लाग्नुभएको छ, सो फारोलाई प्रकाश पारिदिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ती सात वटा मोटा गाईहरू सात वर्ष हुन्, र ती सात वटा भरिला बालाहरूचाहिँ सात वर्ष हुन्; दुवै सपनाको अर्थ एउटै हो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ती पछिबाट आउने सात वटा कुरूप र दुब्ला गाईहरू सात वर्ष हुन्; त्यसै गरी ती पातला र पूर्वीय बतासले ओइलाएका सात वटा बालाहरू: ती अनिकालका सात वर्ष हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“मैले फारोलाई भनेझैँ यो हुनेछ: परमेश्‍वरले जे गर्न लाग्नुभएको छ, सो फारोलाई प्रकाश गरिदिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","इजिप्टभरि सात वर्षसम्म ठूलो सहकाल हुनेछ; ");
INSERT INTO npioncb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","तर त्यसपछि सात वर्षसम्म अनिकालले पछ्याउनेछ। तब इजिप्टमा भएका सबै सहकालहरू बिर्सिइनेछ; अनि अनिकालले देशलाई नाश पार्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","यस्तो घोर अनिकाल हुनेछ, कि देशमा पहिलेको सहकालको स्मरणसमेत रहनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","फारोलाई दिइएको दुई प्रकारका सपनाको कारणचाहिँ यो हो: यो कुरा गर्न परमेश्‍वरले दृढतापूर्वक निर्णय गर्नुभएको छ, र परमेश्‍वरले यो कुरा चाँडै गर्नुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“अब फारोले विवेकी र बुद्धिमान् मानिस खोजेर तिनलाई इजिप्टको जिम्मा दिएर राखून्। ");
INSERT INTO npioncb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ती इजिप्टका सात वर्षका सहकालका समयमा उब्जनीको पाँचौँ भाग बटुल्नका लागि फारोले हाकिमहरू नियुक्त गरून्। ");
INSERT INTO npioncb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","तिनीहरूले यी आउने असल वर्षहरूका सबै अन्‍नहरू जम्मा गरेर सहरहरूमा भोजनका निम्ति प्रयोग गरिनलाई फारोको अख्तियारमा भण्डारण गरून्। ");
INSERT INTO npioncb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","यो अन्‍नचाहिँ इजिप्टमा आउँदैगरेको सात वर्षको अनिकालको समयमा प्रयोग गरिनलाई भण्डारमा जोगाइराख्नुपर्छ, ताकि देश अनिकालले नष्‍ट नहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","त्यो योजना फारो र उनका सबै पदाधिकारीहरूलाई असल लाग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","यसकारण फारोले तिनीहरूलाई सोधे, “के परमेश्‍वरको आत्मा भएका यिनीजस्ता अरू मानिस पाऔँला?” ");
INSERT INTO npioncb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","तब फारोले योसेफलाई भने, “परमेश्‍वरले तिमीलाई यी सबै कुरा प्रकट गरिदिनुभएको कारण तिमीजस्तो विवेकशील र बुद्धिमानी मानिस अरू कोही छैन। ");
INSERT INTO npioncb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","तिमी मेरो राजमहलका हर्ताकर्ता हुनेछौ, र मेरा सबै प्रजा तिम्रो हुकुमको अधीनमा हुनेछन्। सिंहासनको विषयमा मात्र म तिमीभन्दा ठूलो हुनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","यसकारण फारोले योसेफलाई भने, “अबदेखि मैले तिमीलाई सम्पूर्ण इजिप्टको जिम्मेवारी सुम्पेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","तब फारोले आफ्नो औँलाबाट छाप-औँठी झिकेर योसेफका औँलामा लगाइदिए। उनले तिनलाई मलमलको लबेदा पहिर्‍याइदिए; र तिनको गलामा सुनको सिक्री लगाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","उनले तिनलाई आफ्नो दोस्रो दर्जाको अधिकारीको रूपमा रथमा सवार गराए; अनि मानिसहरू उनका अगि-अगि “बाटो छोड्!” भन्दै कराए। यसरी उनले तिनलाई सम्पूर्ण इजिप्ट देशमाथि अख्तियारवाला बनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","तब फारोले योसेफलाई भने, “म फारो हुँ; तर तिम्रो हुकुमविना इजिप्टभरि कसैले पनि हात वा खुट्टा उठाउन पाउनेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारोले योसेफलाई सापनान-पानेह नाम दिए; अनि ओनका पुजारी पोतीफेराकी छोरी आसनतलाई तिनकी पत्नी हुनलाई दिए। अनि योसेफले इजिप्टभरि भ्रमण गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","इजिप्टका राजा फारोको सेवामा प्रवेश गर्दा योसेफ तीस वर्ष पुगेका थिए। अनि योसेफ फारोको उपस्थितिबाट निस्किएर गए, र इजिप्टभरि भ्रमण गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सात वर्षको सहकालमा देशमा प्रशस्त उब्जनी भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","योसेफले ती सात वर्षहरूमा इजिप्टमा प्रशस्त गरी उब्जिएका सबै अन्‍न संकलन गरे, र सहरहरूमा जम्मा गरे। प्रत्येक सहरका छेउछाउका खेतहरूमा भएका उब्जनी तिनले सहरहरूमा थन्क्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","योसेफले समुद्रको बालुवासरह धेरै परिमाणमा अन्‍न जम्मा गरे; त्यो अन्‍न यति धेरै थियो कि नाप्‍न पनि नसकेकोले तिनले त्यसको हिसाब राख्नै छोडिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अनिकालका वर्षहरू आउनुभन्दा अगि ओनका पुजारी पोतीफेराकी छोरी आसनतबाट योसेफका दुई छोराहरू जन्मे। ");
INSERT INTO npioncb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","योसेफले जेठोको नाम मनश्शे राखेर यसो भने, “योचाहिँ परमेश्‍वरले मेरा सबै कष्‍ट र मेरा पिताका सबै घरानालाई बिर्सन दिनुभएको कारणले गर्दा हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","दोस्रो छोराको नाम तिनले एफ्राइम राखेर भने, “योचाहिँ मेरो कष्‍टको देशमा परमेश्‍वरले मलाई फलिफाप गराउनुभएको कारणले गर्दा हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","इजिप्टमा सात वर्षको सहकाल समाप्‍त भयो; ");
INSERT INTO npioncb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","अनि योसेफले भनेझैँ सात वर्षको अनिकाल सुरु भयो। अरू सबै देशहरूमा अनिकाल पर्‍यो, तर इजिप्टभरि चाहिँ भोजन थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब सारा इजिप्टका मानिसहरूले अनिकालको अनुभव गर्न थाले, तब मानिसहरू भोजनका लागि फारोसित बिलौना गर्न लागे। तब फारोले सबै इजिप्टियनहरूलाई भने, “योसेफकहाँ जाओ, र तिनले तिमीहरूलाई जे भन्छन्, त्यही गर।” ");
INSERT INTO npioncb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","यसरी अनिकाल सारा देशभरि फैलियो। योसेफले सम्पूर्ण भण्डारहरू खोलिदिए, र इजिप्टियनहरूलाई अन्‍न बेचे; किनकि इजिप्टभरि नै घोर अनिकाल फैलिएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","अनि सबै देशका मानिसहरू योसेफबाट अन्‍न किन्‍नलाई इजिप्टमा आए; किनकि संसारभरि नै जताततै घोर अनिकाल परेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","जब इजिप्टमा प्रशस्त अन्‍न छ भनी याकोबलाई थाहा भयो, तब उनले आफ्ना छोराहरूलाई भने, “तिमीहरू एक-अर्कालाई किन टुलुटुलु हेरेर बस्छौ?” ");
INSERT INTO npioncb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","उनले भने, “इजिप्टमा अन्‍न छ भनी मैले सुनेको छु। जाओ, गएर अन्‍न किनेर ल्याओ, ताकि हामीहरू जीवितै रहन सकौँ, नत्रता हामी मर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","तब योसेफका दश जना दाजुहरू अन्‍न किन्‍नलाई इजिप्टमा गए। ");
INSERT INTO npioncb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","तर याकोबले योसेफका भाइ बेन्यामीनलाई उनीहरूसित पठाएनन्; किनकि त्यसमाथि कुनै जोखिम आइपर्ला कि भनी तिनी डराए। ");
INSERT INTO npioncb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","यसकारण अन्‍न किन्‍न जानेहरूमा इस्राएलका छोराहरू पनि थिए; किनकि कनानमा पनि अनिकाल परेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","त्यस समय योसेफचाहिँ इजिप्टका राज्यपाल थिए; अनि त्यहाँका सबै मानिसहरूलाई अन्‍न बेच्ने तिनी नै थिए। यसकारण योसेफका दाजुहरू आइपुगे, र उनीहरूले भुइँसम्म निहुरेर तिनलाई दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफले आफ्ना दाजुहरूलाई देख्नासाथै उनीहरूलाई चिने; तर तिनले नचिनेको भान पारेर रुखो सोरमा उनीहरूसित बोले। तिनले सोधे, “तिमीहरू कहाँबाट आएका हौ?” उनीहरूले जवाफ दिए, “हामी कनान देशबाट अन्‍न किन्‍न आएका हौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफले आफ्ना दाजुहरूलाई चिने, तर उनीहरूले चाहिँ तिनलाई चिनेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","अनि तिनले उनीहरूको बारेमा आफूले देखेका सपनाहरू सम्झे, र उनीहरूलाई भने, “पक्‍कै पनि तिमीहरू जासुस हौ! हाम्रो देशको कमजोरी पत्ता लगाउन आएका हौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","उनीहरूले जवाफ दिए, “होइन, हे प्रभु, हामी तपाईंका सेवकहरू अन्‍न किन्‍न आएका हौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हामी सबै एकै मानिसका छोराहरू हौँ। तपाईंका सेवकहरू इमानदार मानिसहरू हौँ, हामी जासुस होइनौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","तिनले उनीहरूलाई भने, “होइन! पक्‍कै पनि तिमीहरू हाम्रो देशका कमजोरी पत्ता लगाउन आएका हौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","तर उनीहरूले जवाफ दिए, “हामी तपाईंका सेवकहरू बाह्र जना दाजुभाइहरू छौँ; कनान देशमा बस्‍ने एकै मानिसका छोराहरू हौँ। कान्छोचाहिँ अहिले हाम्रा पितासित छ, र एउटाचाहिँ मरिसक्यो।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","योसेफले उनीहरूलाई भने, “मैले तिमीहरूलाई भनेझैँ तिमीहरू जासुसहरू हौ! ");
INSERT INTO npioncb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","अनि तिमीहरू यसरी जाँचिनेछौ: फारोको जीवनको शपथ खाएर म भन्छु, तिमीहरूको कान्छो भाइ यहाँ नआएसम्म तिमीहरू यस ठाउँबाट जान पाउनेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तिमीहरूमध्ये एक जनालाई आफ्नो भाइ ल्याउन पठाओ; अनि अरूलाईचाहिँ थुनामा राखिनेछ, ताकि तिमीहरूले भनेको कुरा साँचो हो कि होइन भनेर पत्ता लगाउन सकियोस्। यदि होइन भने फारोको जीवनको शपथ खाएर म भन्छु, तिमीहरू जासुस हौ!” ");
INSERT INTO npioncb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","अनि तिनले उनीहरू सबैलाई तीन दिन थुनामा राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तेस्रो दिनमा योसेफले उनीहरूलाई भने, “म परमेश्‍वरको भय मान्दछु; यदि तिमीहरूले यसो गर्‍यौ भने तिमीहरू बाँच्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","तिमीहरू इमानदार मानिसहरू हौ भने तिमीहरूका दाजुभाइहरूमध्ये एक जना थुनामा रहोस्; अनि अरूचाहिँ अन्‍न लिएर भोकले ग्रस्त भएका तिमीहरूका घरानाकहाँ जाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","तर तिमीहरूले आफ्नो कान्छो भाइलाई मकहाँ ल्याउनुपर्छ, ताकि तिमीहरूका कुराहरू साँचो ठहरियोस् र तिमीहरू मर्न नपरोस्।” तब उनीहरूले त्यसै गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","उनीहरूले आपसमा भने, “साँच्‍चै नै हामीले आफ्नो भाइलाई नराम्रो व्यवहार गरेको कारण दण्ड पाएका हौँ। त्यसले आफ्नो जीवनको निम्ति बिन्ती गर्दा हामीले त्यसलाई कति दुःखित भएको देखेका थियौँ, तर पनि हामीले सुनेनौँ; त्यसैकारण यो विपत्ति हामीमाथि आएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेनले भने, “के मैले तिमीहरूलाई त्यस केटाको विरुद्धमा पाप नगर भनेको थिइनँ? तर तिमीहरूले सुनेनौ! अब त हामीले त्यसको रगतको हिसाब दिनुपर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","योसेफले दोभासेलाई प्रयोग गरेका हुनाले तिनले उनीहरूका कुरा बुझ्दैछन् भनेर उनीहरूले थाहा पाएनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तब तिनी उनीहरूदेखि अलि पर गएर रुन थाले; तर फेरि तिनले आफूलाई सम्हाले र आएर उनीहरूसित कुरा गरे। तिनले शिमियोनलाई उनीहरूकै आँखाको सामु बाँध्न लाए। ");
INSERT INTO npioncb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","योसेफले उनीहरूका बोराहरूमा अन्‍न भर्न र हरेकको बोरामा तिनीहरूका आ-आफ्नै चाँदीका पैसा हालिदिन र यात्राका निम्ति खानेकुराको प्रबन्ध गर्न हुकुम गरे। उनीहरूका निम्ति यी सबै गरिसकेपछि, ");
INSERT INTO npioncb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","उनीहरूले आफ्ना गधाहरूमाथि आफ्ना अन्‍नहरू लादे, र त्यहाँबाट गए। ");
INSERT INTO npioncb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","उनीहरू राति बास बस्‍ने ठाउँमा रोकिएपछि तिनीहरूमध्ये एक जनाले आफ्नो गधालाई खानेकुरा दिनलाई आफ्नो बोरा खोले, तब बोराको मुखैमा आफ्नो पैसा देखे। ");
INSERT INTO npioncb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","तिनले आफ्ना दाजुभाइहरूलाई भने, “मेरो पैसा फर्काइएको रहेछ। हेर, त्यो त मेरो बोरामै छ।” उनीहरू डरले खङ्‌ग्रङ्गै भए, र काँप्दै एक-अर्कालाई हेर्दै भने, “परमेश्‍वरले हामीलाई किन यस्तो गर्नुभएको हो?” ");
INSERT INTO npioncb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","जब उनीहरू कनान देशमा आफ्ना पिता याकोबकहाँ आइपुगे, तब उनीहरूले आफूमाथि जे घटना भएको थियो, ती सबै बताए; ");
INSERT INTO npioncb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","अनि भने, “त्यस देशका मालिकले हामीसित रुखो बोली बोले, र हामी त्यस देशमा जासुसी गर्न गएझैँ व्यवहार गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","तर हामीले तिनलाई भन्यौँ, ‘हामी जासुसहरू होइनौँ; तर इमानदार मानिसहरू हौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हामी बाह्र जना दाजुभाइहरू एकै पिताका छोराहरू हौँ। एउटा भाइ मरिसक्यो, र कान्छोचाहिँ अहिले कनानमा हाम्रा पितासित छ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“तब त्यस देशका मालिकले हामीलाई भने, ‘तिमीहरू इमानदार मानिसहरू हौ भनी म यसरी जान्‍नेछु: तिमीहरूका दाजुभाइहरूमध्ये एक जनालाई यहाँ मसित छोड, र बाँकीचाहिँ भोकले ग्रस्त भएको आफ्ना घरानाका निम्ति अन्‍न लिएर जाओ। ");
INSERT INTO npioncb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","अनि तिमीहरूको कान्छो भाइलाई मकहाँ ल्याओ, र तिमीहरू जासुस होइन रहेछौ, तर इमानदार मानिसहरू रहेछौ भनी म जान्‍नेछु। तब म तिमीहरूको भाइलाई तिमीहरूकहाँ फर्काइदिनेछु, र तिमीहरूले यस देशमा स्वतन्त्र भएर लेनदेन गर्न सक्नेछौ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","उनीहरूले जब आफ्ना बोराहरू खाली गर्दैथिए; हरेकको बोराभित्र आ-आफ्नो पैसाको थैली रहेछ! जब उनीहरूले र उनीहरूका पिताले पैसाको थैलीहरू देखे, तब उनीहरू भयभीत भए। ");
INSERT INTO npioncb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","उनीहरूका पिता याकोबले उनीहरूलाई भने, “तिमीहरूले मलाई मेरा छोराहरूदेखि वञ्चित गरायौ। योसेफ छैन; अनि अब यहाँ शिमियोन पनि छैन। अनि अझै तिमीहरू बेन्यामीनलाई लैजान खोज्दैछौ। यी सबै कुरा मेरा विरुद्धमा छन्!” ");
INSERT INTO npioncb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","तब रूबेनले आफ्ना पितालाई भने, “यदि मैले यसलाई फर्काएर ल्याउन सकिनँ भने तपाईंले मेरा दुवै छोराहरूलाई मारिदिन सक्नुहुन्छ। यसलाई मेरो जिम्मामा छोडिदिनुहोस्, म यसलाई फर्काएर ल्याउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","तर याकोबले भने, “मेरो छोरा तँसित त्यहाँ जानेछैन; यसको दाजु मरेर गयो, अब ऊ एउटा मात्र बाँकी रहेको छ। तिमीहरूसित यात्रामा यदि यसमाथि कुनै जोखिम आइपर्‍यो भने तिमीहरूले मलाई यो सेतै फुलेको अवस्थामा शोकसितै चिहानमा लैजानेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","देशमा अनिकाल अझ भयङ्कर रूपले बढ्दैगयो। ");
INSERT INTO npioncb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","यसकारण जब उनीहरूले इजिप्टबाट ल्याएको अन्‍न खाइसके, तब उनीहरूका पिताले उनीहरूलाई भने, “फेरि जाओ, र हाम्रा लागि केही अन्‍न किनेर ल्याओ।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तर यहूदाले तिनलाई भने, “ती मानिसले हामीलाई गम्भीरतापूर्वक यसरी चेतावनी दिएका छन्, ‘तिमीहरूको भाइ तिमीहरूसित छैन भने तिमीहरूले मेरो अनुहार फेरि देख्नेछैनौ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","तपाईंले हाम्रो भाइलाई हामीसित पठाउनुभयो भने हामी जानेछौँ र तपाईंका लागि अन्‍न किन्‍नेछौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","तर तपाईंले त्यसलाई पठाउनुभएन भने हामी जानेछैनौँ; किनकि ती मानिसले हामीलाई, ‘तिमीहरूको भाइ तिमीहरूसित छैन भने तिमीहरूले मेरो अनुहार फेरि देख्नेछैनौ’ भनेका छन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","अनि इस्राएलले सोधे, “तिमीहरूले ममाथि किन यो विपत्ति ल्यायौ? किन त्यस मानिसलाई तिमीहरूको अर्को भाइ छ भनेर भन्यौ?” ");
INSERT INTO npioncb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","तब उनीहरूले जवाफ दिए, “ती मानिसले हामी र हाम्रा कुटुम्बको विषयमा केरकार गरे। तिनले, ‘के तिमीहरूका पिता अझ जीवितै छन्? के तिमीहरूसित अर्को पनि भाइ छ?’ भनेर सोधे। हामीले उनका प्रश्नहरूको मात्र जवाफ दियौँ। तिनले ‘तिमीहरूका भाइलाई यहाँ ल्याओ’ भनी भन्लान् भनेर हामीले कसरी जान्‍नु?” ");
INSERT INTO npioncb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","तब यहूदाले आफ्ना पिता इस्राएललाई भने, “त्यस केटालाई मसित पठाउनुहोस्, तब हामी झट्टै त्यहाँ जानेछौँ, ताकि तपाईं र हाम्रा बालबच्‍चाहरू भोकभोकै मर्नुपर्नेछैन र बाँच्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","म आफैँ त्यसको सुरक्षाको जमानी बस्‍नेछु; त्यसको लागि तपाईंले मलाई नै जिम्मेवार ठहराउन सक्नुहुन्छ। यदि मैले त्यसलाई तपाईंकहाँ फर्काएर तपाईंको सामु खडा गराउन सकिनँ भने म आफ्नो जीवनभरि तपाईंको अगि दोषी ठहरिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि हामीले ढिलो नगरेका भए अहिले हामी दुईपल्ट गएर फर्किआउन सक्नेथियौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","तब उनीहरूका पिता इस्राएलले उनीहरूलाई भने, “यदि यस्तै हुने हो भने यसो गर: यस देशका केही उत्तम उत्पादनहरू आफ्ना बोराहरूमा राख—अर्थात् अलिकति सुगन्धित लेप र अलिकति मह, केही सुगन्धित मसला, मूर्र, र अलिकति पेस्ता र हाडे-बदामहरू ती मानिसका निम्ति उपहारको रूपमा लिएर जाओ। ");
INSERT INTO npioncb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","तिमीहरूका बोराहरूमा फर्काइदिएका पैसा फर्काउनलाई आफूसित दोबर पैसा लैजाओ। सायद त्यो एउटा भूल थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","तिमीहरूको भाइ पनि लगेर ती मानिसकहाँ झट्टै जाओ। ");
INSERT INTO npioncb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","अनि सर्वशक्तिमान् परमेश्‍वरले ती मानिसको सामु तिमीहरूमाथि दया देखाऊन्, र तिनले तिमीहरूको भाइ सिमियोन र बेन्यामीनलाई तिमीहरूसित फर्केर आउन देऊन्। यदि म शोकमा विक्षिप्‍त हुनुपर्ने हो भने पनि होउँला।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","यसकारण ती मानिसहरूले उपहारहरू, दोबर पैसा र बेन्यामीनलाई पनि लिएर गए। तिनीहरू हतार-हतार इजिप्टतिर हिँडे; अनि योसेफकहाँ आफैँलाई हाजिर गराए। ");
INSERT INTO npioncb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","जब योसेफले उनीहरूसित बेन्यामीनलाई देखे, तब तिनले घरका भण्डारेलाई भने, “यी मानिसहरूलाई मेरो घरमा लैजा, एउटा पशु मारेर भोजन तयार गर्; उनीहरूले दिउँसो मसित खानेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","त्यो मानिसले योसेफले भनेझैँ गर्‍यो, र ती मानिसहरूलाई योसेफको घरमा लग्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","अब ती मानिसहरू आफूलाई योसेफको घरमा लगिएको कारण आत्तिए। उनीहरूले सोचे, “हामीलाई यहाँ ल्याएको चाहिँ पहिलो पटक हाम्रा बोराहरूमा पैसा फर्काएर हालिदिएको कारणले गर्दा हो। तिनले हामीमाथि आक्रमण गर्न र हामीलाई दमन गरी दास तुल्याएर हाम्रा गधाहरू हडप्न चाहन्छन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","यसकारण उनीहरू योसेफका भण्डारेकहाँ गए, र घरभित्रको प्रवेशद्वारमा तिनीसित कुरा गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","उनीहरूले भने, “हाम्रा प्रभु, दया गर्नुहोस्, हामी पहिलो चोटि यहाँ अन्‍न किन्‍न आएका थियौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","तर हामी बास बसेको ठाउँमा राति आफ्ना बोराहरू खोल्दा हाम्रो प्रत्येकको बोराको मुखमा आ-आफ्ना पूरा पैसा राखिएको पायौँ। यसकारण हामीले त्यो पैसा आफूसित फर्काएर ल्याएका छौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","हामीले अन्‍न किन्‍नका लागि अरू पनि धेरै पैसा ल्याएका छौँ। कसले हाम्रो पैसा हाम्रा बोराहरूमा राखिदियो, सो हामी जान्दैनौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","तिनले भने, “ठिकै छ, नडराओ। तिमीहरूका परमेश्‍वर, र तिमीहरूका पिताका परमेश्‍वरले नै तिमीहरूका बोराहरूमा धन राखिदिनुभएको छ। मैले तिमीहरूको पैसा पाएँ।” तब तिनले शिमियोनलाई उनीहरूकहाँ बाहिर ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ती भण्डारेले ती मानिसहरूलाई योसेफको घरमा लग्यो, र उनीहरूलाई खुट्टा धुने पानी दियो; अनि उनीहरूका गधाहरूलाई दानापानी दियो। ");
INSERT INTO npioncb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","दिउँसो उनीहरूले त्यहीँ भोजन गर्नुपर्छ भनी सुनेका हुनाले उनीहरूले योसेफ आउँदा तिनलाई टक्र्याउनका लागि आफ्ना उपहारहरू तयार पारे। ");
INSERT INTO npioncb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","जब योसेफ घरमा आए, तब उनीहरूले आफूले घरभित्र ल्याएका उपहारहरू तिनलाई टक्र्याए, र उनीहरू भुइँसम्मै निहुरेर तिनलाई सामु दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","तिनले उनीहरूका हालखबर सोधेर भने, “तिमीहरूले मलाई तिमीहरूका वृद्ध पिताको बारेमा भनेका थियौ, उनी कस्ता छन्? के उनी अझै जीवितै छन्?” ");
INSERT INTO npioncb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","उनीहरूले जवाफ दिए, “तपाईंका सेवक, हाम्रा पिता अझै जीवितै र कुशल नै हुनुहुन्छ।” अनि उनीहरूले लम्पसार परेर तिनलाई दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","चारैतिर हेरेपछि तिनले आफ्नै आमाका छोरा तिनको भाइ बेन्यामीनलाई देखेर सोधे, “तिमीहरूले मलाई भनेको तिमीहरूको कान्छो भाइ यही हो?” अनि योसेफले भने, “मेरो छोरा, परमेश्‍वर तँप्रति अनुग्रही होऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","आफ्नो भाइलाई देखेर योसेफ अति भावुक भए; अनि आफूलाई थाम्न नसकेर हतारिँदै रुने एकान्त ठाउँ खोज्दै निस्के। अनि तिनी आफ्नो निजी कोठामा पसे, र त्यहाँ रोए। ");
INSERT INTO npioncb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","त्यसपछि तिनले आफ्नो अनुहार धोए, र तिनी बाहिर निस्किआए; अनि आफूलाई सम्हालेर भने, “अब खाना पस्क।” ");
INSERT INTO npioncb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","उनीहरूले योसेफका निम्ति अलग्गै, ती दाजुभाइहरूका निम्ति अलग्गै, र तिनीसित खाने इजिप्टियनहरूका निम्ति छुट्टाछुट्टै भोजन पस्के; हिब्रूहरूसित भोजन गर्नु भनेको इजिप्टियनहरूका लागि घृणित मानिने हुनाले उनीहरूले हिब्रूहरूसित खान मिल्दैनथ्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","अनि ती मानिसहरूलाई योसेफको अगि जेठोदेखि कान्छोसम्म आफ्नो उमेरअनुसार बसाइयो; अनि उनीहरूले चकित भएर एक-अर्कालाई हेरे। ");
INSERT INTO npioncb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","जब उनीहरूलाई योसेफको टेबुलबाट खाना पस्किइयो, बेन्यामीनको भाग अरू सबैको भन्दा पाँच गुणा बढी थियो। यसरी उनीहरूले तिनीसित भोज खाए, पिए र आनन्द मनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","योसेफले आफ्नो घरको भण्डारेलाई यस्तो हुकुम दिए: “यी मानिसहरूका बोराहरूमा उनीहरूले बोक्न सक्ने जति अन्‍नले भरिदे, र प्रत्येकको बोराको मुखमा आ-आफ्ना पैसा राखिदे। ");
INSERT INTO npioncb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","त्यसपछि त्यस कान्छोको बोराको मुखमा चाहिँ त्यसको अन्‍नको पैसासितै मेरो चाँदीको कचौरा पनि राखिदे।” अनि त्यसले योसेफले भनेअनुसार गर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","बिहान भएपछि ती मानिसहरू आफ्ना गधाहरूसितै पठाइए। ");
INSERT INTO npioncb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","जब उनीहरू सहरदेखि केही टाढा मात्र पुगेका थिए, तब योसेफले आफ्ना भण्डारेलाई भने, “झट्टै ती मानिसहरूका पछि-पछि जा; अनि उनीहरूलाई भेटेपछि उनीहरूलाई भन्, ‘भलाइको साटो तिमीहरूले किन खराबी गर्‍यौ? ");
INSERT INTO npioncb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","यही कचौरा होइनँ, जसबाट मेरा मालिकले पिउनुहुन्छ? र जसद्वारा उहाँले जोखना पनि हेर्नुहुन्छ? यो त तिमीहरूले खराब काम गर्‍यौ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","जब त्यसले उनीहरूलाई भेट्टायो, तब त्यसले उनीहरूलाई योसेफले भनेका कुरा दोहोर्‍यायो। ");
INSERT INTO npioncb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","तर उनीहरूले तिनलाई भने, “मेरा मालिक किन यस्तो भन्दै हुनुहुन्छ? यस किसिमका कामहरू तपाईंका सेवकहरूबाट टाढा रहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","हामीले त कनान देशबाट हाम्रा बोराहरूका मुखमा पाइएका पैसासमेत फेरि तपाईंकहाँ फर्काएका थियौँ। यसकारण तपाईंका मालिकको घरबाट कसरी हामीले सुन अथवा चाँदी चोरी गर्थ्यौँ र? ");
INSERT INTO npioncb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","यदि तपाईंका सेवकहरूमध्ये कसैसित पनि त्यो चीज पाइयो भने त्यो मर्नेछ; अनि हामी बाँकीचाहिँ मेरा मालिक, हजुरका दासहरू हुनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","त्यसले भन्यो, “तिमीहरूले भनेअनुसार नै भएको होस्। जससित त्यो पाइनेछ, त्यो मेरो दास हुनेछ; अनि तिमीहरू बाँकीचाहिँ दोषमुक्त हुनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","उनीहरू हरेकले आ-आफ्नो बोरा छिटो-छिटो भुइँमा ओराले, र खोले। ");
INSERT INTO npioncb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","अनि त्यस भण्डारेले जेठोबाट सुरु गरेर कान्छोसम्म सबैको खानतलासी गर्‍यो। अनि त्यो कचौरा बेन्यामीनको बोरामा पाइयो। ");
INSERT INTO npioncb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","यो देखेर उनीहरूले आ-आफ्ना वस्त्र च्याते। तब उनीहरूले आफ्ना गधाहरूमा भारी लादे, र फेरि सहरतिर फर्के। ");
INSERT INTO npioncb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा र तिनका दाजुभाइहरू फर्केर आउँदा योसेफ घरमै थिए। अनि उनीहरू तिनको सामु भुइँमै लम्पसार परे। ");
INSERT INTO npioncb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफले उनीहरूलाई भने, “तिमीहरूले यो के गर्‍यौ? मजस्तो मानिसले जोखनाद्वारा सबै कुरा पत्तो लगाउन सक्छु भनी तिमीहरूलाई थाहा थिएन?” ");
INSERT INTO npioncb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“हे मालिक, हामी हजुरलाई के भन्‍न सक्छौँ र?” यहूदाले जवाफ दिए। “हामी के नै पो भन्‍न सक्छौँ र? हामी कसरी आफूलाई निर्दोष प्रमाणित गर्न सक्छौँ? परमेश्‍वरले तपाईंका दासहरूको अधर्म उघारिदिनुभएको छ। हामी अब मेरा मालिकका सेवकहरू हौँ—अर्थात् हामी सबै, र त्यो पनि, जससित त्यो कचौरा पाइयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","तर योसेफले भने, “यस्तो काम मबाट दूर रहोस्! जुन मानिससित मेरो कचौरा पाइयो, त्यो मात्र मेरो दास हुनेछ। अरूचाहिँ शान्तिसँग आफ्ना पिताकहाँ जाओ।” ");
INSERT INTO npioncb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","तब यहूदाले तिनीकहाँ गएर भने: “मेरा मालिक, तपाईंको सेवकलाई केही बोल्न दिनुहोस्। तपाईं फारोसमान हुनुभए तापनि नरिसाउनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","मेरा मालिकले आफ्ना सेवकहरूलाई ‘तिमीहरूका पिता वा भाइ छन् भनी सोध्नुभयो।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","अनि हामीले, ‘हाम्रा एक जना वृद्ध पिता हुनुहुन्छ, र उहाँको वृद्धावस्थामा जन्मेको सानो छोरा छ, त्यसको दाजु मर्‍यो; अनि ऊचाहिँ त्यसकी आमाको बाँचेको एउटै छोरा हो; र त्यसका पिताले त्यसलाई धेरै माया गर्नुहुन्छ’ भनेर जवाफ दियौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“तब हजुरले आफ्ना सेवकहरूलाई भन्‍नुभयो, ‘उसलाई यहाँ मकहाँ ल्याओ, र म आफैँ उसलाई देख्न पाऊँ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","अनि हामीले हजुरलाई भन्यौँ, ‘त्यस केटोले आफ्ना पितालाई छोड्न सक्दैन। यदि त्यसले आफ्ना पितालाई छोड्यो भने उहाँ मर्नुहुनेछ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","तर तपाईंले आफ्ना सेवकहरूलाई भन्‍नुभयो, ‘तिमीहरूसित आफ्नो कान्छा भाइ यहाँ आएन भने तिमीहरूले मेरो अनुहार फेरि देख्नेछैनौ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","हामी जब तपाईंका सेवक मेरा पिताकहाँ गयौँ, तब हामीले उहाँलाई हजुरले भन्‍नुभएको कुरा भन्यौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“अनि हाम्रा पिताले भन्‍नुभयो, ‘फर्केर जाओ, र अरू केही अन्‍न किन।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","तर हामीले भन्यौँ, ‘हामी जान सक्दैनौँ। हामीसित हाम्रो कान्छो भाइ छ भने मात्र हामी जानेछौँ। हाम्रो कान्छो भाइ हामीसित छैन भने हामी ती मानिसको अनुहार हेर्न पनि पाउनेछैनौँ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“तपाईंको सेवक मेरा पिताले हामीलाई भन्‍नुभयो, ‘मेरी पत्नीले मेरा निम्ति दुई छोराहरू जन्माएकी थिइन् भनेर तिमीहरू जान्दछौ। ");
INSERT INTO npioncb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","तीमध्ये एक जना मलाई छोडेर गयो, र मैले भनेँ, “त्यो निश्‍चय पनि टुक्रा-टुक्रा पारियो होला।” त्यस बेलादेखि मैले त्यसलाई देखेको छैनँ। ");
INSERT INTO npioncb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","तिमीहरूले मबाट यसलाई पनि लग्यौ, र यसमाथि जोखिम आइपर्‍यो भने तिमीहरूले मेरो सेतै फूलेको कपाललाई शोकमै चिहानमा ल्याउनेछौ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“यसकारण अब तपाईंको सेवक मेरा पिताकहाँ जाँदा यो केटो हामीसित छैन भने मेरा पिता, जसको जीवन यस केटोसित घनिष्‍ठ रूपमा बाँधिएको छ, ");
INSERT INTO npioncb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","यस केटालाई नदेख्दा उहाँ मर्नुहुनेछ। तपाईंका सेवकहरूले हाम्रा पिताको सेतै फुलेको कपाललाई शोकमै चिहानमा पुर्‍याउनेछौँ। ");
INSERT INTO npioncb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","तपाईंको सेवकले आफ्नो पिताकहाँ यस केटाको सुरक्षाको जमानी बसेको छ। मैले भनेँ, ‘यदि मैले यसलाई तपाईंकहाँ फर्काएर ल्याइनँ भने म मेरो जीवनभरि मेरा पिताका सामु दोषी हुनेछु!’ ");
INSERT INTO npioncb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“यसर्थ अब दया गरी हे मेरा मालिक, यस केटाको सट्टामा हजुरको सेवक भएर मलाई बस्‍न दिनुहोस्; तर यस केटोलाई आफ्ना दाजुहरूसित फर्कन दिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","यो केटो मेरो साथमा छैन भने म आफ्ना पिताकहाँ कसरी जान सक्छु? होइन! मालिक, मेरा पितामाथि आइपर्ने यस्तो सन्ताप म हेर्न सक्दिनँ!” ");
INSERT INTO npioncb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","तब योसेफले आफ्ना सबै कर्मचारीहरूको सामु आफैँलाई थाम्न सकेनन्; अनि तिनी “सबै जना मेरो उपस्थितिबाट गइहाल!” भनेर चिच्याए। त्यसैले योसेफले आफ्ना दाजुभाइहरूकहाँ आफैँलाई प्रकट गर्दा तिनीसित अरू कोही थिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","अनि तिनी यति डाँको छोडेर रोए, कि इजिप्टियनहरूले पनि सुने, र फारोका परिवारले यो कुरा थाहा पाए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","योसेफले आफ्ना दाजुभाइहरूलाई भने, “म योसेफ हुँ! के मेरा पिता अझै जीवित हुनुहुन्छ?” तर तिनका दाजुभाइहरूले तिनलाई जवाफ दिनै सकेनन्; किनकि उनीहरू तिनको उपस्थितिमा चकित भएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","त्यसपछि योसेफले आफ्ना दाजुभाइहरूलाई भने, “मेरो नजिक आउनुहोस्।” जब उनीहरू आए, तब तिनले भने, “म तपाईंहरूको भाइ योसेफ हुँ, जसलाई तपाईंहरूले इजिप्टमा बेच्नुभएको थियो! ");
INSERT INTO npioncb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अब विचलित नहुनुहोस्, र मलाई यहाँ बेच्नुभएकोमा आफैँसित नरिसाउनुहोस्; किनकि हामी सबैको जीवन बचाउनका लागि नै परमेश्‍वरले मलाई तपाईंहरूभन्दा अगि पठाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","देशमा दुई वर्षदेखि अनिकाल छाएको छ; अनि अब आउने पाँच वर्षहरूमा जोत्ने र कटनी गर्ने काम हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","तर एउटा महान् छुटकाराद्वारा तपाईंहरूका निम्ति पृथ्वीमा एउटा अवशेष जोगाइराख्न र तपाईंहरूका जीवन बचाउनका लागि परमेश्‍वरले मलाई तपाईंहरूको अगि पठाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“यसर्थ मलाई यहाँ पठाउने तपाईंहरू होइन, तर परमेश्‍वर हुनुहुन्छ। उहाँले मलाई फारोका बुबासरह, उहाँको सम्पूर्ण घरानाको मालिक र सम्पूर्ण इजिप्टको शासक बनाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","अब झट्टै मेरा पिताकहाँ फर्किजानुहोस् र यसो भन्‍नुहोस्, ‘तपाईंको छोरो योसेफ यसो भन्छ: परमेश्‍वरले मलाई सम्पूर्ण इजिप्टका मालिक बनाउनुभएको छ। ढिलो नगरी मकहाँ आउनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तपाईंहरू, तपाईंका छोराछोरीहरू र तपाईंका नातिनातिनाहरू, तपाईंका पशुहरूका बगाल र बथान, र तपाईंसित भएका सबै गोशेनको प्रान्तमा मेरो छेवैमा बस्‍नुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","त्यहाँ म तपाईंहरूका निम्ति बन्दोबस्त गरिदिनेछु; किनकि पाँच वर्षको अनिकाल आउन बाँकी नै छ। नत्रता तपाईंसहित तपाईंको परिवार सबै बिचल्‍लीमा पर्नेछन्।’ ");
INSERT INTO npioncb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“हेर्नुहोस्! तपाईंहरूसँग साँच्‍चै नै म बोल्दैछु भनेर तपाईंहरू आफैँले र मेरो भाइ बेन्यामीनले पनि देखेको छ। ");
INSERT INTO npioncb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मेरा पितालाई इजिप्टमा मलाई दिइएको सम्मानको विषयमा तपाईंहरूले देख्नुभएको प्रत्येक कुराको विषयमा भन्‍नुहोस्। अनि मेरा पितालाई झट्ट यहाँ ल्याउनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","तब तिनले आफ्नो भाइ बेन्यामीनलाई अँगालो हाले र धुरुधुरु रोए, र बेन्यामीनले पनि रुँदै तिनलाई अँगालो हाले। ");
INSERT INTO npioncb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","अनि तिनले सबैलाई म्वाइँ खाए, र उनीहरूसित रोए। त्यसपछि तिनका दाजुहरूले पनि तिनीसित कुराकानी गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","योसेफका दाजुभाइहरू आएका छन् भन्‍ने खबर जब फारोको महलमा पुग्यो, तब फारो र तिनका सबै अधिकारीहरू खुशी भए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फारोले योसेफलाई भने, “तिम्रा दाजुभाइहरूलाई यसो गर्नु भन: ‘तिमीहरूका पशुहरूमा भारी लाद, र कनान देशमा फर्क; ");
INSERT INTO npioncb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अनि तिमीहरूका पिता र तिमीहरूका परिवारहरूलाई फर्काएर मकहाँ ल्याओ। म तिमीहरूलाई इजिप्टको सबैभन्दा असल जमिन दिनेछु; र तिमीहरूले यस देशको उत्तम चीजहरू उपभोग गर्न सक्नेछौ।’ ");
INSERT INTO npioncb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“म तिनीहरूलाई यसो गर्नु भन्‍ने आदेश पनि दिन्छु: ‘तिमीहरूका छोराछोरीहरू, पत्नीहरूका लागि इजिप्टबाट केही गाडाहरू लैजाओ, र तिमीहरूका पितालाई यहाँ लिएर आओ। ");
INSERT INTO npioncb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","तिमीहरूका आफ्ना मालसामानको केही चिन्ता नगर; किनकि इजिप्टका सबैभन्दा असल कुराहरू तिमीहरूका हुनेछन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","यसकारण इस्राएलका छोराहरूले त्यसै गरे। फारोले हुकुम दिएझैँ योसेफले तिनीहरूलाई गाडाहरू दिए, र तिनले यात्रामा तिनीहरूलाई चाहिने कुराहरूको प्रबन्ध गरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","उनीहरू प्रत्येकलाई तिनले नयाँ वस्त्र दिए; तर बेन्यामीनलाई तिनले चाँदीका तीन सय शेकेल र पाँच जोर वस्त्र दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","अनि तिनले आफ्ना पितालाई यी कुराहरू पठाइदिए: इजिप्टका सबैभन्दा असल कुराहरूले लादिएका दश वटा गधाहरू र अन्‍न, रोटी र तिनलाई यात्रामा चाहिने अन्य सामग्रीले लादिएका दश वटा गधैनीहरू पठाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","तब तिनले आफ्ना दाजुभाइहरूलाई पठाइदिए; अनि उनीहरू बिदा हुन लाग्दा तिनले उनीहरूलाई भने, “बाटोमा झगडा नगर्नुहोला!” ");
INSERT INTO npioncb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","यसरी उनीहरू इजिप्टदेखि हिँडे, र कनान देशमा आफ्ना पिता याकोबकहाँ आए। ");
INSERT INTO npioncb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","उनीहरूले तिनलाई भने, “योसेफ अझै जीवित छन्! अनि वास्तवमा तिनी समस्त इजिप्टका शासक हुन्।” यो कुरा सुनेर याकोब स्तब्ध भए; तिनले तिनीहरूका कुरा पत्याएनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","तर जब योसेफले उनीहरूलाई भनेका सबै कुराहरू तिनलाई बताइदिए र जब तिनले योसेफले तिनलाई यात्राका लागि पठाएका गाडाहरू देखे, तब उनीहरूका पिता याकोबको होस फर्क्यो। ");
INSERT INTO npioncb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","इस्राएलले भने, “मेरो छोरो योसेफ अझै जीवित छ भन्‍ने मलाई विश्‍वास भयो। म मर्नुभन्दा अगि गएर त्यसलाई भेट्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","यसकारण आफूसित भएका सम्पूर्ण थोकहरू लिएर इस्राएलले यात्रा सुरु गरे; अनि तिनी बेर्शेबा पुगेपछि तिनले आफ्ना पिता इसहाकका परमेश्‍वरका निम्ति बलिदान चढाए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","अनि राति दर्शनमा परमेश्‍वर इस्राएलसँग बोल्नुभयो र भन्‍नुभयो, “याकोब! ए याकोब!” उनले जवाफ दिए, “हजुर, म यहाँ छु!” ");
INSERT INTO npioncb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","उहाँले भन्‍नुभयो, “म याहवेह, तेरा पिताका परमेश्‍वर हुँ। इजिप्टमा जानलाई नडरा; किनकि म त्यहाँ तँलाई एउटा ठूलो राष्ट्र बनाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","म तँसित इजिप्टमा जानेछु, र म निश्‍चय तँलाई फेरि फर्काएर ल्याउनेछु। अनि योसेफले आफ्नै हातले तेरा आँखा बन्द गरिदिनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","तब याकोबले बेर्शेबा छोडे; अनि इस्राएलका छोराहरूले आफ्ना पिता याकोब र उनीहरूका छोराछोरीहरू, उनीहरूका पत्नीहरूलाई फारोले पठाइदिएका गाडाहरूमा बसाए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","यसरी याकोब र उनका सबै सन्तानहरूले आफूसित आफ्ना गाईबस्तु र उनीहरूले कनानमा कमाएका सम्पत्तिहरू लिएर इजिप्टमा गए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याकोबले आफ्ना सबै सन्तान—अर्थात् आफ्ना छोराहरू, नातिहरू, आफ्ना छोरीहरू र नातिनीहरू इजिप्टमा लिएर गए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","इजिप्टमा जाने इस्राएलका छोराहरू (याकोब र उनका सन्तानहरू) का नामहरू यिनै हुन्: याकोबका जेठा छोरा रूबेन। ");
INSERT INTO npioncb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेनका छोराहरू: हानोक, पल्‍लू, हेस्रोन र कर्मी। ");
INSERT INTO npioncb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमियोनका छोराहरू: यमूएल, यामीन, ओहद, याकीन, सोहोर र कनानी स्त्रीतर्फको छोरा शौल। ");
INSERT INTO npioncb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीका छोराहरू: गेर्शोन, कहात र मरारी। ");
INSERT INTO npioncb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाका छोराहरू: एर, ओनान, शेलह, फारेस र जेरह (तर एर र ओनान कनान देशमा नै मरेका थिए)। पेरेसका छोराहरू: हेस्रोन र हामूल। ");
INSERT INTO npioncb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साखारको छोराहरू: तोला, पुवा, याशूब र शिम्रोन। ");
INSERT INTO npioncb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलूनका छोराहरू: सेरेद, एलोन र यहलेल। ");
INSERT INTO npioncb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","यिनीहरूचाहिँ याकोबका निम्ति लेआले पद्दन-अराममा जन्माएका छोराहरू थिए; यसबाहेक उनकी छोरी दीना पनि थिइन्। उनका छोराछोरीहरू जम्मा तेत्तीस जना थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादका छोराहरू: सेफोन, हाग्गी, शूनी, एसबोन, एरी, अरोदी अनि अरेली। ");
INSERT INTO npioncb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेरका छोराहरू: यिम्ना, यिश्‍वा, यिश्‍वी र बेरियाह। उनीहरूकी बहिनी सेरह थिइन्। बरीआका छोराहरू: हेबेर र मल्कीएल। ");
INSERT INTO npioncb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","लाबानले आफ्नी छोरी लेआलाई दिएकी दासी जिल्पापट्टिका याकोबका छोराछोरीहरू यिनै हुन्; यिनीहरू जम्मा सोह्र जना थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकोबकी पत्नी राहेलका छोराहरू: योसेफ र बेन्यामीन। ");
INSERT INTO npioncb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","इजिप्टमा ओनका पुजारी पोतीफेराकी छोरी आसनतद्वारा जन्मेका योसेफका छोराहरू मनश्शे र एफ्राइम थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बेन्यामीनका छोराहरू: बेला, बेकेर, अश्बेल, गेरा, नामान, एही, रोश, मुप्पीम, हुप्पीम र आर्द। ");
INSERT INTO npioncb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेलबाट जन्मेका याकोबका छोराहरू यी हुन्; यिनीहरू जम्मा चौध जना थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दानका छोरा: हुशीम। ");
INSERT INTO npioncb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्‍तालीका छोराहरू: यहसेल, गुनी, येसेर र शिल्‍लेम। ");
INSERT INTO npioncb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","यिनीहरूचाहिँ लाबानले आफ्नी छोरी राहेललाई दिएकी दासी बिल्हापट्टिका याकोबका छोराहरू हुन; यिनीहरू जम्मा सात जना थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","इजिप्टमा याकोबसित जाने उनका सबै आफ्ना सन्तानमा उनका बुहारीहरूबाहेक, उनीहरू छयसट्ठी जना थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","इजिप्टमा जन्मेका योसेफका दुई छोराहरू लगायत, इजिप्टमा गएका याकोबका परिवारमा जम्मा सत्तरी जना थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","अब याकोबले आफू गोशेनमा पुग्न लागेको खबर दिन भनी यहूदालाई आफ्नो अगि योसेफकहाँ पठाए। जब उनीहरू गोशेनको प्रान्तमा आइपुगे; ");
INSERT INTO npioncb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","तब योसेफले आफ्नो रथ तयार पारे, र आफ्ना पिता इस्राएललाई भेट्न गोशेन गए। योसेफ उनको सामु पुग्नसाथ आफ्ना पितालाई अँगालो हालेर धेरै समयसम्म रोइरहे। ");
INSERT INTO npioncb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","इस्राएलले योसेफलाई भने, “म आफैँले तँ अझै जीवितै रहेको देखेको हुनाले अब म शान्तिसित मर्न तयार छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","तब योसेफले आफ्ना दाजुभाइहरू र आफ्ना पिताको घरानालाई भने, “म गएर फारोसित कुरा गर्नेछु, ‘कनान देशमा बसिरहेका मेरा दाजुभाइहरू र मेरा पिताका घराना मकहाँ आएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","यी मानिसहरू गोठालाहरू हुन्, र पशुपालन गर्छन्; अनि उनीहरूले आफ्ना बगाल, बथान र भएभरका सबै कुराहरू लिएर आएका छन्।’ ");
INSERT INTO npioncb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फारोले तपाईंहरूलाई भित्र बोलाएर ‘तिमीहरूका कामकाज के हो?’ भनी सोध्छन्, ");
INSERT INTO npioncb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तपाईंहरूले भन्‍नुहोस्, ‘हाम्रा पुर्खाहरूले गरेझैँ हामी बाल्यकालदेखि नै पशुपालन गर्दैआएका छौँ।’ तब तपाईंहरूलाई गोशेनको प्रान्तमा बसोबास गर्न दिइनेछ; किनकि इजिप्टियनहरूका नजरमा गोठालाहरू घृणित हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","तब योसेफ गए, र फारोलाई भने, “मेरा पिता र मेरा दाजुभाइहरू, उनीहरूसित भएका बगाल र बथान; अनि भएभरका सबै कुराहरू लिएर कनान देशबाट आएका छन्, र अहिले गोशेनमा छन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","तिनले आफ्ना पाँच जना दाजुभाइहरू छानेर उनीहरूलाई फारोकहाँ उपस्थित गराए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फारोले ती दाजुभाइहरूलाई सोधे, “तिमीहरूको पेशा के हो?” उनीहरूले फारोलाई जवाफ दिए, “हामी हजुरका सेवकहरू, हाम्रा पुर्खाहरूझैँ गोठालाहरू हौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","उनीहरूले फारोलाई यो पनि भने, “कनानमा अनिकाल ज्यादै छाएकोले हामी केही समयको लागि यहाँ बस्‍नलाई आएका छौँ; किनकि तपाईंका सेवकहरूका बगाल चराउने ठाउँ छैन। यसकारण, अब दया गरी तपाईंका सेवकहरूलाई गोशेनमा बसोबास गर्न दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","फारोले योसेफलाई भने, “तिम्रा पिता र तिम्रा दाजुभाइहरू तिमीकहाँ आएका छन्, ");
INSERT INTO npioncb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","इजिप्ट देश तिम्रो सामु छ। तिम्रा पिता र तिम्रा दाजुभाइहरूलाई देशको सबैभन्दा उत्तम भागमा बस्‍न देऊ। उनीहरू गोशेनमा बसून्। उनीहरूमध्ये कोही विशेष क्षमता भएका छन् भन्‍ने तिमी जान्दछौ भने उनीहरूलाई मेरा गाईबस्तुको पनि जिम्मा लगाइदेऊ।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब योसेफले आफ्ना पिता याकोबलाई भित्र ल्याए, र उनलाई फारोको सामु उपस्थित गराए। याकोबले फारोलाई आशिष् दिए, ");
INSERT INTO npioncb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","अनि फारोले याकोबलाई सोधे, “तपाईंको उमेर कति भयो?” ");
INSERT INTO npioncb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकोबले फारोलाई भने, “मेरा प्रवासकालका वर्षहरू एक सय तीस हुन्। मेरा वर्षहरू थोरै र कष्‍टपूर्ण रहेका छन्; तर ती मेरा पुर्खाहरूका प्रवासकालका वर्षहरू जति भने होइनन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","तब याकोबले फारोलाई आशिष् दिए, र फारोको उपस्थितिबाट निस्किए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","यसकारण योसेफले आफ्ना पिता र आफ्ना दाजुभाइहरूलाई इजिप्टमा बसोबास गराए; अनि फारोले आदेश दिएअनुसार देशको सबैभन्दा असल भाग अर्थात् रामसेसमा उनीहरूलाई जग्गाजमिन दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफले आफ्ना पिता, आफ्ना दाजुभाइहरू र आफ्ना पिताका सबै घरानालाई उनीहरूका बालबच्‍चाको संख्याअनुसार भोजन जुटाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","घोर अनिकाल परेकोले सम्पूर्ण देशमा भोजन थिएन; इजिप्ट र कनान दुवै अनिकालको कारण ग्रस्त भएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","योसेफले इजिप्ट र कनानका मानिसहरूले अन्‍न किन्दा तिरेका सबै रकम सङ्कलन गरे; अनि तिनले त्यो पैसा फारोको महलमा ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","जब इजिप्ट र कनानका मानिसहरूका रकम सकियो, तब इजिप्टका मानिसहरू सबै जना योसेफकहाँ आएर भने, “हामीलाई भोजन दिनुहोस्। तपाईंको आँखाकै सामु हामी किन मर्नु? हाम्रो सबै रकम सकिए।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","तब योसेफले भने, “यदि तिमीहरूसँग रकम छैन भने गाईबस्तु लिएर आओ। म तिमीहरूका गाईबस्तुको साटोमा अन्‍न दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","यसकारण तिनीहरूले आफ्ना गाईबस्तुहरू योसेफकहाँ ल्याए; अनि तिनले तिनीहरूका घोडा, भेडाबाख्रा, गाईबस्तुहरू र गधाहरूको सट्टामा तिनीहरूलाई अन्‍न दिए। तिनले त्यो वर्षभरि नै तिनीहरूका सबै गाईबस्तुको सट्टामा तिनीहरूलाई अन्‍न दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","जब त्यो वर्ष बित्यो, तब दोस्रो वर्ष उनीहरू योसेफकहाँ आएर भने, “हामी हाम्रा मालिकबाट यो सत्य कुरा लुकाउन सक्दैनौँ। हाम्रो रकम सकिसक्यो; अनि हाम्रा गाईबस्तु पनि तपाईंका भइसकेका छन्। अब हामीसित हाम्रा शरीरहरू र जमिनबाहेक हाम्रा मालिकलाई दिनका लागि केही पनि छैन। ");
INSERT INTO npioncb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","तपाईंका आँखाकै सामु हामी किन नष्‍ट होऔँ? अन्‍नको साटोमा हामी र हाम्रा जमिनहरू किन्‍नुहोस्। हामी आफैँलाई हाम्रा जमिनसहित फारोका दासको रूपमा समर्पित गर्दछौँ। हामीलाई बिउ दिनुहोस्; ताकि हामी बाँचौँ, र नमरौँ। अनि हाम्रो जमिन उजाड नहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","यसकारण योसेफले इजिप्टका सबै जमिनहरू फारोका निम्ति किने। इजिप्टियनहरूका लागि अनिकाल विकराल भएको हुनाले इजिप्टियनहरू हरेकले आफ्ना जमिनहरू बेचे। अनि यसरी ती जमिनहरू फारोका भए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","अनि योसेफले इजिप्टको एक कुनादेखि अर्को कुनासम्मका सबै मानिसहरूलाई दासत्वमा ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","तैपनि तिनले पुजारीहरूका जमिनचाहिँ किनेनन्; किनकि तिनीहरूले फारोबाट तोकिएका भोजनको आफ्नो भाग नियमित पाउँथे। फारोले तिनीहरूलाई दिएका भागबाट तिनीहरूका निम्ति पर्याप्‍त भोजन प्राप्‍त गर्दथे। त्यसैले गर्दा तिनीहरूले आफ्ना जमिन बेचेनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","योसेफले मानिसहरूलाई भने, “अब हेर, आज मैले तिमीहरू र तिमीहरूका जमिनहरू फारोका निम्ति किनेको छु; तिमीहरूका निम्ति यहाँ बिउ छ। यसकारण तिमीहरूले खेतमा उब्जनी लगाउन सक्छौ। ");
INSERT INTO npioncb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","तर फसल भएपछि त्यसको पाँचौँ भाग फारोलाई दिनू। पाँच भागको चार भागचाहिँ खेतको लागि बिउ र तिमीहरू आफ्ना लागि, आफ्ना घराना, र आफ्ना छोराछोरीहरूका लागि भोजनका निम्ति राख्नू।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","तिनीहरूले भने, “हजुरले हाम्रा प्राणको रक्षा गर्नुभएको छ। हजुरको अनुग्रह हामीमाथि रहोस्; हामी फारोका दासत्वमुनि रहनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","यसकारण योसेफले इजिप्टमा जमिनको विषयमा यो कानुन स्थापित गरे, जुन आजसम्म छँदैछ—उब्जनीको पाँचौँ भाग फारोको हुन्छ। केवल पुजारीहरूको जमिन मात्र फारोका भएनन्। ");
INSERT INTO npioncb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","अब इस्राएलीहरू इजिप्टमा गोशेनको प्रान्तमा बसोबास गरे। त्यहाँ तिनीहरूले जग्गाजमिन र सम्पत्ति आर्जन गरे। अनि तिनीहरू फल्दै-फुल्दै गए र संख्यामा धेरै वृद्धि भयो। ");
INSERT INTO npioncb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकोब इजिप्टमा सत्र वर्ष बसे, र उनी जम्मा एक सय सतचालीस वर्षका भए। ");
INSERT INTO npioncb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","जब इस्राएलको मृत्यु नजिक आयो, तब उनले आफ्नो छोरा योसेफलाई बोलाउन पठाए, र उनलाई भने, “यदि मैले तेरो दृष्‍टिमा निगाह पाएको छु भने तेरो हात मेरो तिघ्रामुनि राख्। अनि मलाई दया र विश्‍वासयोग्यता देखाउनेछु भनी प्रतिज्ञा गर्। मलाई इजिप्टमा नगाड्नू, ");
INSERT INTO npioncb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","तर म आफ्ना पितापुर्खाहरूसित मिल्न गएपछि मलाई इजिप्टदेखि बाहिर निकालेर लैजा। अनि तिनीहरू गाडिएको ठाउँमा गाड्नू।” तिनले भने, “म तपाईंले भन्‍नुभएझैँ गर्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","उनले भने, “मसित शपथ खा।” तब योसेफले उनीसित शपथ खाए। अनि इस्राएल आफ्नो लहुरोको टुप्पोमा अडेस लागे र उनले आराधना गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","केही समयपछि “तपाईंका पिता बिरामी हुनुहुन्छ” भनेर योसेफले खबर पाए। यसकारण तिनले आफ्ना दुई छोराहरू मनश्शे र एफ्राइमलाई आफैँसित लिएर गए। ");
INSERT INTO npioncb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","जब याकोबले “तपाईंको छोरा योसेफ आएका छन्” भनी खबर पाए, तब उनी आफैँ बल गरेर खाटमा बसे। ");
INSERT INTO npioncb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकोबले योसेफलाई भने, “सर्वशक्तिमान् परमेश्‍वर कनान देशको लूजमा मसित देखा पर्नुभयो, र मलाई आशिष् दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","अनि उहाँले मलाई भन्‍नुभयो, ‘म तँलाई फलदायक बनाएर तेरो संख्यामा वृद्धि गराउनेछु। म तँलाई जातिहरूको समुदाय बनाउनेछु। अनि म यस देशलाई तँपछि तेरा सन्तानहरूलाई सदाका निम्ति सम्पत्तिको रूपमा दिनेछु।’ ");
INSERT INTO npioncb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“अब म यहाँ आउनुभन्दा पहिले इजिप्टमा जन्मेका तेरा दुई छोराहरू मेरै कहलाइनेछन्। रूबेन र शिमियोन मेरा भएझैँ एफ्राइम र मनश्शे पनि मेरै भनिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","तिनीहरूभन्दा पछि जन्मेका तेरा छोराहरू तेरै हुनेछन्। उनीहरूले पैतृक अधिकारस्वरूप पाएको प्रदेशमा यिनीहरू आफ्ना दाजुभाइहरूकै नामले चिनिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","म पद्दनबाट कनान देशमा फर्कंदै गर्दा हामी एप्राताबाट अलि पर हुँदा नै राहेलको मृत्यु भयो। यसकारण मैले ठूलो शोकसहित तिनलाई त्यहाँ एप्रात (अर्थात् बेथलेहेम) जाने बाटोमा गाडे।” ");
INSERT INTO npioncb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","जब इस्राएलले योसेफका छोराहरूलाई देखे, उनले “यिनीहरू को हुन्?” भनी सोधे। ");
INSERT INTO npioncb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफले आफ्ना पितालाई भने, “यिनीहरू परमेश्‍वरले मलाई यस देशमा दिनुभएको छोराहरू हुन्।” तब इस्राएलले भने, “तिनीहरूलाई मकहाँ ले, र म तिनीहरूलाई आशिष् दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएलका आँखा वृद्धावस्थाको कारण धमिलिएका थिए। अनि उनले राम्ररी देख्न सक्दैनथे। यसकारण योसेफले आफ्ना छोराहरूलाई तिनका नजिक ल्याए; अनि तिनका पिताले तिनीहरूलाई चुम्बन गरे, र अँगालो हाले। ");
INSERT INTO npioncb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","इस्राएलले योसेफलाई भने, “मैले तेरो अनुहार फेरि देख्न पाउँछु भनेर चिताएको पनि थिइनँ; अब परमेश्‍वरले मलाई तेरा सन्तानहरूहरू पनि हेर्न दिनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","तब योसेफले तिनीहरूलाई इस्राएलका काखबाट हटाए, र आफ्नो अनुहार भुइँतिर पारेर दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","अनि योसेफले ती दुवैलाई लिए, एफ्राइमलाई आफ्नो दाहिने हातले समातेर इस्राएलको देब्रेपट्टि, र मनश्शेलाई आफ्नो देब्रे हातले समातेर इस्राएलको दाहिनेपट्टि पारेर तिनका नजिक ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","तर इस्राएलले आफ्नो दाहिने हात बढाएर कान्छा छोरा एफ्राइमको शिरमाथि राखे। अनि आफ्नो देब्रे हात घुमाएर जेठो छोरा मनश्शेको शिरमाथि राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","तब उनले योसेफलाई आशिष् दिएर भने, “जुन परमेश्‍वरको सामु मेरा पिता अब्राहाम र इसहाक विश्‍वासयोग्य भएर हिँडे, जुन परमेश्‍वर मेरो जीवनभरि आजसम्म मेरो गोठालो भएर रहनुभएको छ, ");
INSERT INTO npioncb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ती स्वर्गदूत, जसले मलाई सबै खराबीबाट जोगाउनुभएको छ, उहाँले नै यी बालकहरूलाई आशिष् देऊन्। तिनीहरूद्वारा नै मेरो नाम, र मेरा पिता अब्राहाम र इसहाकको नाम अमर होऊन्; अनि पृथ्वीमा यिनीहरूको संख्या अनगन्ती होस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","जब योसेफले आफ्ना पिताले उनको दाहिने हात एफ्राइमको शिरमा राखेका देखे, तिनी अप्रसन्‍न भए; यसकारण तिनले एफ्राइमको शिरबाट मनश्शेको शिरमाथि सारिदिनलाई आफ्ना पिताको हात समाते। ");
INSERT INTO npioncb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफले उनलाई भने, “होइन, मेरा पिता, योचाहिँ जेठा हो; तपाईंको दाहिने हात यसको शिरमाथि राख्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","तर तिनका पिताले अस्वीकार गरेर भने, “मलाई थाहा छ, मेरा छोरा, मलाई थाहा छ। त्यो पनि एउटा जाति बन्‍नेछ। त्यो पनि महान् हुनेछ। तर त्यसको कान्छो भाइचाहिँ त्योभन्दा महान् बन्‍नेछ। अनि त्यसका सन्तानहरू जातिहरूको एक समूह हुनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","त्यस दिन उनले तिनीहरूलाई आशिष् दिएर भने, “तिमीहरूकै नाममा इस्राएलले यो आशिष् उच्‍चारण गर्नेछ: ‘परमेश्‍वरले तिमीहरूलाई एफ्राइमझैँ र मनश्शेझैँ बनाऊन्।’ ” यसरी उनले एफ्राइमलाई मनश्शेको अगाडि राखे। ");
INSERT INTO npioncb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","तब इस्राएलले योसेफलाई भने, “मेरो मृत्युको समय आएको छ; तर परमेश्‍वर तँसित हुनुहुनेछ र तँलाई आफ्ना पितापुर्खाहरूको देशमा फर्काएर लानुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","म तँलाई तेरा दाजुभाइहरूभन्दा एक भाग बढ्ता पहाडी पाखो दिनेछु, जुन पाखो मैले मेरो तरवार र धनुले एमोरीहरूबाट हात पारेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकोबले आफ्ना छोराहरूलाई बोलाएर भने: “तिमीहरू भेला होओ, र आउँदा दिनहरूमा तिमीहरूलाई के-के हुनेछ, त्यो म भन्‍नेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“याकोबका छोराहरू हो! भेला होओ, र सुन; तिमीहरूका पिता इस्राएलका कुरा सुन। ");
INSERT INTO npioncb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रूबेन, तँ मेरो जेठा छोरा होस्, मेरो शक्ति, मेरो बलको पहिलो चिन्ह, सम्मानमा विशिष्‍ट, र शक्तिमा विशिष्‍ट। ");
INSERT INTO npioncb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तँ पानीझैँ चञ्चल छस्; यसैले तेरो इज्जत रहनेछैन; किनकि तँ आफ्ना पिताको ओछ्यानमा चढिस्, मेरो पलङमा चढिस् र त्यसलाई अशुद्ध पारिस्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमियोन र लेवी दाजुभाइहरू हुन्; तिनीहरूका तरवारहरू हिंसाका हतियारहरू हुन्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","म तिनीहरूको सभामा नपसूँ, म तिनीहरूका परिषद्‌मा सामेल नबनूँ; किनकि तिनीहरूले रिसमा मानिसहरू मारेका छन्। अनि खेलवाड गरेर गोरुहरूका ढोडनसा काटेका छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","तिनीहरूको यति डरलाग्दो रिस, तिनीहरूको निष्‍ठुर क्रोधमाथि श्राप परोस्! म तिनीहरूलाई याकोबमा छरपस्ट पार्नेछु, र इस्राएलमा तितरबितर पार्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“यहूदा, तेरा दाजुभाइहरूले तँलाई प्रशंसा गर्नेछन्; तेरो हात तेरा शत्रुहरूको गर्दनमा हुनेछ; तेरा पिताका छोराहरूले तँलाई दण्डवत् गर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ए यहूदा, तँ सिंहको डमरुजस्तै छस्; मेरो छोरा, तँ शिकारबाट फर्कन्छस्। त्यो सिंहझैँ झुक्दछ, सिंहनीझैँ आराम गर्न लमतन्‍न पर्दछ—कसले उसलाई जगाउने आँट गर्ला? ");
INSERT INTO npioncb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाको हातबाट राजदण्ड हट्नेछैन, न त शासकको लहुरो त्यसका खुट्टाहरूका बीचबाट हट्नेछ, जबसम्म यी जसका हुन्, ती आउँदैनन्, अनि जातिहरू उहाँमा आज्ञाकारी बन्‍नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","त्यसले आफ्नो गधालाई दाखको बोटमा, र त्यसको बछेडोलाई त्यसले उत्तम हाँगामा बाँध्नेछ; त्यसले आफ्नो वस्त्र दाखमद्यमा, र आफ्नो लबेदा दाखको रसमा धुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","त्यसका आँखा दाखमद्यभन्दा गाढा रङ्गका, र त्यसका दाँतहरू दूधभन्दा सेता हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलून समुद्री किनारमा बस्‍नेछ, र ऊ जहाजहरूका लागि बन्दरगाह बन्‍नेछ; त्यसको सिमाना सीदोनतिर फैलिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साखार दुई काठीका बीचमा आराम गर्ने बलियो गधा हो। ");
INSERT INTO npioncb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","जब त्यसले आफू बिसाएको ठाउँ कति असल छ, र आफ्नो देश कति आनन्दपूर्ण छ भनी देख्छ, त्यसले आफ्नो काँध भारी बोक्नको लागि झुकाउनेछ, र कडा परिश्रमको लागि समर्पित हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दानले इस्राएलको एउटा कुलको हैसियतले आफ्ना मानिसहरूलाई न्याय दिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान बाटो छेउको एउटा सर्प, र गोरेटोमा बसेको विषालु सर्प हो, जसले घोडाको कुर्कुच्‍चा डस्छ, र यसमा सवार हुने मानिस पछिल्तिर पछारिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“हे याहवेह, म तपाईंको छुटकारालाई अपेक्षा गर्दछु। ");
INSERT INTO npioncb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“गादलाई आक्रमणकारीहरूको दलले आक्रमण गर्नेछ; तर त्यसले चाहिँ तिनीहरूलाई उल्टो खेदेर तिनीहरूका कुर्कुच्‍चामा आक्रमण गर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेरको भोजन उत्तम हुनेछ; त्यसले राजालाई सुहाउने स्वादिलो भोजन जुटाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नप्‍ताली स्वतन्त्र भएकी मुडुली मृग हो, जसले सुन्दर पाठाहरू बियाउँछे। ");
INSERT INTO npioncb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“योसेफ एउटा फलदायक दाखको बोट हो, पानीको मूलको नजिक भएको फलदायक दाखको बोट, जसका हाँगाहरू पर्खाल नाघेर फैलिन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धनुर्धारीहरूले निर्दयतासाथ त्यसलाई आक्रमण गरे; तिनीहरूले दुश्मनी राखेर त्यसलाई काँडले हाने। ");
INSERT INTO npioncb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तर त्यसको धनु स्थिर रह्‍यो; त्यसका बलिया पाखुराहरू फूर्तिला रहे; त्यो याकोबका सर्वशक्तिमान्‌को हातले गर्दा त्यो गोठाला, इस्राएलका चट्टानले गर्दा भएको थियो; ");
INSERT INTO npioncb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","तेरा पिताका परमेश्‍वर, जसले तँलाई सहायता गर्नुहुन्छ, सर्वशक्तिमान्, जसले तँलाई माथि स्वर्गका आशिष्‌हरू, तल भएको समुद्रका आशिष्‌हरू, स्तन र गर्भका आशिष्‌हरू दिनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","तेरा पिताका आशिष्‌हरू प्राचीन पर्वतहरूका आशिष्‌हरूभन्दा र पुराना पहाडहरूका प्रचुरताहरूभन्दा महान् छन्; यी सबै आशिष्‌हरू योसेफका शिरमा होऊन्; आफ्ना दाजुभाइहरूका बीचमा भएका राजकुमारका आँखीभौँमाथि बसून्। ");
INSERT INTO npioncb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बेन्यामीन साह्रै भोकाएको ब्वाँसो हो; बिहान त्यसले शिकार खान्छ; साँझमा त्यसले लुटको माल बाँड्छ।” ");
INSERT INTO npioncb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","यी सबै इस्राएलका बाह्र कुल हुन्; र यसरी उनीहरूका पिताले उनीहरू प्रत्येकलाई सुहाउँदो आशिष् दिए। ");
INSERT INTO npioncb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब याकोबले उनीहरूलाई यी निर्देशन दिए: “म आफ्ना मानिसहरूसित मिल्न जान लागिरहेको छु। मलाई हित्ती एप्रोनको खेतमा भएको ओडारमा मेरा पितापुर्खाहरूसित गाड्नू, ");
INSERT INTO npioncb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","जुन ओडारचाहिँ कनानमा मम्रेको छेउमा मक्पेलाको खेतमा छ। अनि त्यो ठाउँ अब्राहामले हित्ती एप्रोनबाट चिहान घारीको रूपमा खेतसमेत किनेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","त्यहीँ नै अब्राहाम र तिनकी पत्नी सारा गाडिए; त्यहीँ इसहाक र तिनकी पत्नी रिबेका गाडिए; र त्यहीँ नै मैले लेआलाई गाडेँ। ");
INSERT INTO npioncb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","त्यो जमिन र त्यो ओडार हित्तीहरूबाट किनिएको हो।” ");
INSERT INTO npioncb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","अनि याकोबले आफ्ना छोराहरूलाई निर्देशन दिइसकेपछि उनले आफ्ना खुट्टा पलङमा पसारेर आफ्नो अन्तिम सास फेरे। यसरी उनी आफ्ना मानिससित मिल्न गए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","योसेफ आफ्ना पितालाई अँगालो हालेर धेरै बेर रोए, र उनलाई म्वाइँ खाए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","तब योसेफले आफ्ना सेवामा खटाइएका वैद्यहरूलाई आफ्ना पिता इस्राएलको शरीरमा सुगन्धित लेप लगाउन आदेश दिए। यसकारण ती वैद्यहरूले ");
INSERT INTO npioncb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","चालीस दिन लगाएर सुगन्धित लेप लगाए; किनकि लेप लगाउन त्यति नै समय लाग्थ्यो। अनि इजिप्टियनहरूले उनका निम्ति सत्तरी दिनसम्म शोक मनाए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","शोकका दिनहरू बितेपछि योसेफले फारोका भारदारहरूलाई भने, “यदि मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने फारोसित मेरा लागि बोलिदिनुहोस्। उहाँलाई भन्‍नुहोस्, ");
INSERT INTO npioncb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘मेरा पिताले मलाई शपथ खान लाउनुभयो, र भन्‍नुभयो, “मेरो मृत्यु हुन लागेको छ; मलाई कनान देशमा मैले आफूले बनाएको चिहानमा गाड्नू।” अब मलाई आफ्ना पितालाई गाड्न जान दिनुहोस्; त्यसपछि म फर्कनेछु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फारोले भने, “जाऊ, र तिम्रा पिताले तिमीलाई शपथ खान लगाएझैँ तिनलाई गाड।” ");
INSERT INTO npioncb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","यसकारण योसेफ आफ्ना पितालाई गाड्न गए। फारोका सबै राजकर्मचारीहरू—अर्थात् सभाका प्रधानहरू र इजिप्टका सबै सम्मानित व्यक्तिहरू तिनीसित गए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","यसबाहेक योसेफका घरानाका सबै सदस्यहरू, तिनका दाजुभाइहरू र तिनका पिताका सबै घराना पनि गए। गोशेनमा बालबच्‍चाहरू, बगालहरू र बथानहरू मात्र छोडिए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","रथहरू र घोडसवारहरू पनि तिनीसित गए। त्यो एउटा ठूलो समूह थियो। ");
INSERT INTO npioncb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","जब तिनीहरू यर्दनको छेउमा भएको आतादको खलोमा पुगे, तब तिनीहरूले धेरै बेरसम्म भारी विलाप गरे; अनि त्यहाँ योसेफले आफ्ना पिताको निम्ति सात दिनसम्म शोक गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जब त्यहाँ बस्‍ने कनानीहरूले आतादको खलोमा गरिएको शोक देखे, तिनीहरूले भने, “इजिप्टियनहरूले ठूलो शोक मनाइरहेका छन्।” त्यसैकारण यर्दनको नजिकको त्यस ठाउँलाई हाबिल-मिश्रइम भनिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","यसरी याकोबका छोराहरूले उनले आज्ञा दिएबमोजिम गरे: ");
INSERT INTO npioncb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","तिनीहरूले उनलाई कनानमा पुर्‍याए र मम्रेको छेउमा मक्पेलाको खेतमा भएको ओडारमा गाडे, जुन अब्राहामले हित्ती एप्रोनबाट चिहान घारीको रूपमा खेतसितै किनेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","आफ्ना पितालाई गाडेपछि योसेफ तिनका दाजुभाइहरू र तिनका पितालाई गाड्न गएका अरू सबैसित इजिप्टमा फर्किए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","उनीहरूका पिताको मृत्यु भएको देखेर योसेफका दाजुभाइहरूले भने, “यदि योसेफले हामीले त्यसप्रति गरेका सबै खराबीको साटो मनमा इबी राखेर हामीसँग बदला लियो भने?” ");
INSERT INTO npioncb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","यसकारण उनीहरूले योसेफकहाँ यसो भनेर खबर पठाए, “तपाईंका पिताले आफ्नो मृत्यु हुनुभन्दा अगि यस्तो आदेश दिनुभएको छ: ");
INSERT INTO npioncb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘तिमीहरूले योसेफलाई यसो भन्‍नू: तेरा दाजुभाइहरूले विगतमा तँलाई खराब व्यवहार गरेर तँप्रति गरेका पापहरू र खराबीहरूलाई क्षमा गरिदे भनी म भन्दछु।’ अब दया गरी तपाईंका पिताका परमेश्‍वरका सेवकहरूका पापहरू क्षमा गरिदिनुहोस्।” त्यो खबर तिनीकहाँ पुगेपछि योसेफ रोए। ");
INSERT INTO npioncb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","तब तिनका दाजुभाइहरू तिनीकहाँ आएर तिनको अगि घोप्टो परेर भने, “हामी तपाईंका दासहरू हौँ।” ");
INSERT INTO npioncb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","तर योसेफले उनीहरूलाई भने, “नडराओ; के म परमेश्‍वरको स्थानमा छु र? ");
INSERT INTO npioncb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","तिमीहरूले मलाई हानि गर्ने विचार गर्‍यौ; तर अहिले धेरैको प्राण बाँच्ने जुन काम भइरहेको छ, त्यो काम परमेश्‍वरले भलाइका निम्ति गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","यसकारण अब नडराओ; म तिमीहरू र तिमीहरूका बालबच्‍चाहरूको पालनपोषण गर्नेछु।” अनि तिनले उनीहरूलाई फेरि आश्‍वासन दिए, र उनीहरूसित दयालु भएर कुराकानी गरे। ");
INSERT INTO npioncb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ आफ्ना पिताका सम्पूर्ण परिवारसित इजिप्टमा बसे। तिनी एक सय दश वर्षसम्म बाँचे। ");
INSERT INTO npioncb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","तिनले एफ्राइमका छोराछोरीहरूका तेस्रो पुस्तासम्मलाई देखे। मनश्शेका छोरा माकीरका छोराछोरीहरूलाई पनि तिनले काखमा लिए, जसलाई तिनले आफ्नै ठान्दथे। ");
INSERT INTO npioncb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","तब योसेफले आफ्ना दाजुभाइहरूलाई भने, “मेरो मृत्यु हुन लागेको छ; तर परमेश्‍वर निश्‍चय तिमीहरूलाई सहायता दिन आउनुहुनेछ; र तिमीहरूलाई यस देशबाट उहाँले अब्राहाम, इसहाक र याकोबलाई शपथद्वारा प्रतिज्ञा गर्नुभएको देशमा लैजानुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","अनि योसेफले इस्राएलका छोराहरूलाई शपथ खान लगाएर भने, “परमेश्‍वर निश्‍चय तिमीहरूको सहायताका लागि आउनुहुनेछ, र तिमीहरूले मेरा हड्डीहरू यस ठाउँबाट माथि लैजानू।” ");
INSERT INTO npioncb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","यसरी योसेफको एक सय दश वर्ष उमेर पुगेर मृत्यु भयो। अनि उनीहरूले तिनलाई सुगन्धित लेप लगाएपछि बाकसमा हालेर इजिप्टमा नै राखे।");
INSERT INTO npioncb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकोबसित आ-आफ्नो परिवारसहित इजिप्टमा जाने इस्राएलका छोराहरूका नाम यिनै हुन्: ");
INSERT INTO npioncb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमियोन, लेवी र यहूदा; ");
INSERT INTO npioncb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, जबूलून र बेन्यामीन; ");
INSERT INTO npioncb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान र नप्‍ताली; गाद र आशेर। ");
INSERT INTO npioncb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकोबका सन्तति जम्मा सत्तरी जना थिए; योसेफ अगिबाटै इजिप्टमा थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","त्यसपछि, योसेफ, तिनका दाजुभाइहरू र त्यस पुस्ताका सबै जना मरे। ");
INSERT INTO npioncb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","तर इस्राएलीहरू फलवन्त हुँदै संख्यामा वृद्धि हुँदैगए, यहाँसम्म कि सारा देश तिनीहरूद्वारा भरियो। ");
INSERT INTO npioncb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","तब इजिप्टमा योसेफलाई नचिनेका एक जना नयाँ राजाले शासन गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","उनले आफ्ना प्रजालाई भने, “हेर, इस्राएलीहरू हामीभन्दा संख्यामा धेरै र बलवान् भएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","अब हामीले तिनीहरूसित बुद्धि पुर्‍याएर व्यवहार गर्नुपर्छ; नत्रता तिनीहरू अझ धेरै हुनेछन्, र यदि युद्ध भइहाल्यो भने तिनीहरू हाम्रा शत्रुहरूसित लागेर हाम्रो विरुद्धमा लडाइँ गरी देशलाई छोडिदिनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","यसकारण उनीहरूले तिनीहरूलाई जबरजस्ती कामले लदाएर सताउनको लागि तिनीहरूमाथि हाकिमहरू खटाए; अनि उनीहरूले फारोको निम्ति पिताम र रामसेस भन्‍ने भण्डारका सहरहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","तर तिनीहरू जति-जति सताइन्थे, उति-उति नै तिनीहरूका संख्या बढ्दै गए, र देशमा फिँजिदै गए। यसकारण इजिप्टियनहरू इस्राएलीहरूसित डराउन थाले। ");
INSERT INTO npioncb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","त्यसकारण इजिप्टियनहरूले इस्राएलीहरूलाई कठोरतापूर्वक काममा दलाउन थाले। ");
INSERT INTO npioncb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","उनीहरूले तिनीहरूलाई माटो, इँटा र खेतबारीका सबै किसिमका काम र कठोर परिश्रम गर्न लगाएर तिनीहरूको जीवन नै तितो बनाइदिए; इजिप्टियनहरूले तिनीहरूलाई सबै काममा कठोरतापूर्वक लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","इजिप्टका राजाले शिप्रा र पुवा नाम गरेका हिब्रू सुँडेनीहरूलाई बोलाएर भने, ");
INSERT INTO npioncb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“जब तिमीहरूले हिब्रू स्त्रीहरूलाई बच्‍चा जन्माउन मदत गर्छौ, र जन्माएका हेर्छौ, तब त्यो छोरा हो भने त्यसलाई मारिदिनू; तर छोरी हो भने त्यसलाई चाहिँ नमार्नू।” ");
INSERT INTO npioncb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","तर ती सुँडेनीहरू परमेश्‍वरको डर राख्थे। इजिप्टको राजाको आज्ञाअनुसार तिनीहरूले गरेनन्; तिनीहरूले छोराहरू जन्मिँदा पनि मारेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तब इजिप्टको राजाले ती सुँडेनीहरूलाई बोलाएर सोधे, “तिमीहरूले यस्तो किन गर्‍यौ? तिमीहरूले ती छोराहरूलाई किन जिउँदै छोडिदियौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ती सुँडेनीहरूले फारोलाई जवाफ दिए, “हिब्रू स्त्रीहरू इजिप्टियन स्त्रीहरूजस्ता छैनन्; तिनीहरू बलिया हुन्छन्; अनि सुँडेनीहरू तिनीहरूकहाँ पुग्नुभन्दा पहिल्यै सजिलैसँग बच्‍चा जन्माइसकेका हुन्छन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","यसकारण परमेश्‍वर ती सुँडेनीहरूप्रति कृपालु हुनुभयो; अनि ती इस्राएलीहरू संख्यामा बढ्दै गए, र झन् शक्तिशाली भए। ");
INSERT INTO npioncb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ती सुँडेनीहरू परमेश्‍वरसित डराएका हुनाले उहाँले तिनीहरूलाई आफ्नै परिवारहरू दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","तब फारोले आफ्ना सबै प्रजालाई यसो भन्दै आज्ञा दिए: “जन्मेका हरेक हिब्रू छोरालाई तिमीहरूले नील नदीमा फ्याँकिदिनू, तर प्रत्येक छोरीलाई भने जीवितै छोड्नू।” ");
INSERT INTO npioncb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","लेवी घरानाका एक जना मानिसले एउटी लेवी कुलकी स्त्रीलाई विवाह गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","अनि तिनी गर्भवती भइन् र एउटा छोरो जन्माइन्। जब तिनले त्यस बालकलाई सुन्दर देखिन्, तब तिनले त्यसलाई तीन महिनासम्म लुकाइराखिन्। ");
INSERT INTO npioncb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","तर जब तिनले त्यसलाई अझै लुकाउन सकिनन्, तब तिनले त्यसको निम्ति एउटा काँसको टोकरी ल्याइन् र त्यसलाई लिसाइलो माटो र अलकत्राले लिपिन्। तब तिनले त्यस बालकलाई त्यसमा हालेर नील नदीको किनारमा अग्ला काँसघारीहरूका बीचमा राखिदिइन्। ");
INSERT INTO npioncb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","त्यसलाई के हुन्छ भनी त्यो हेर्नलाई तिनकी दिदी टाढामा उभिरहिन्। ");
INSERT INTO npioncb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","तब फारोकी छोरी नुहाउनलाई नील नदीमा आइन्, र तिनका दासीहरू नदीका किनारतिर हिँड्दैथिए। तिनले काँसघारीहरूका बीचमा टोकरी देखिन्, र आफ्नी दासीलाई त्यो लिन पठाइन्। ");
INSERT INTO npioncb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","जब तिनले खोल्दा त्यस बालकलाई देखिन्; तब त्यो बालक रोइरहेको थियो, र उसप्रति दयाले भरिएर तिनले भनिन्, “यो त कुनै हिब्रूको बालक हो।” ");
INSERT INTO npioncb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","तब बालककी दिदीले फारोकी छोरीलाई भनिन्, “के यस बालकलाई हेरचाह गर्नका निम्ति म गएर हिब्रू स्त्रीहरूमध्ये कुनै एउटी धाईलाई तपाईंको निम्ति बोलाऊँ?” ");
INSERT INTO npioncb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","तब फारोकी छोरीले जवाफ दिइन्, “हुन्छ, जाऊ।” अनि ती केटी गएर त्यस बालककी आमालाई लिएर आई। ");
INSERT INTO npioncb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फारोकी छोरीले तिनलाई भनिन्, “यस बालकलाई लैजाऊ, र मेरा निम्ति दूध खुवाऊ र हेरचाह गर। म तिमीलाई ज्याला दिनेछु।” यसकारण त्यस स्त्रीले बालकलाई लिएर दूध खुवाउने गरिन्। ");
INSERT INTO npioncb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","बालक ठूलो भएपछि तिनले त्यसलाई फारोकी छोरीकहाँ लगिन्, र ऊ तिनको छोरा भयो, र “मैले उसलाई पानीबाट बाहिर निकालेकी हुँ” भन्दै तिनले उसको नाम मोशा राखिन्। ");
INSERT INTO npioncb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","मोशा ठूलो भएपछि एक दिन तिनी आफ्ना मानिसहरूकहाँ गए, र तिनीहरूले कठोर परिश्रम गरेको देखे। तिनले एक जना इजिप्टियनले हिब्रू जातिको एक जनालाई हिर्काइरहेको देखे। ");
INSERT INTO npioncb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","तिनले यताउता हेरे, र कोही पनि नदेखेपछि तिनले त्यस इजिप्टियनलाई मारे, र त्यसलाई बालुवामा पुरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","अर्को दिन तिनी बाहिर निस्के; तब दुई जना हिब्रूहरूलाई झगडा गरिरहेका देखे। तिनले गल्ती गर्नेलाई सोधे, “तिमी किन आफ्नै मान्छेलाई हिर्काउँछौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","तब त्यस मानिसले भन्यो, “तिमीलाई कसले हाम्रो शासक र न्यायकर्ता नियुक्त गर्‍यो? के तिमीले त्यस इजिप्टियनलाई मारेझैँ मलाई पनि मार्ने विचार गर्दैछौ?” तब मोशा डराए, र सोचे, “मैले जे गरेँ, त्यो सबैलाई थाहा भइसक्यो होला!” ");
INSERT INTO npioncb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","जब फारोले यो सुने, तब उनले मोशालाई मार्न खोजे; तर मोशा फारोदेखि भागेर गए, र मिद्यानमा बस्‍न लागे; अनि त्यहाँ तिनी एउटा इनारको छेउमा बसे। ");
INSERT INTO npioncb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यानका एक जना पुजारीका सात जना छोरीहरू थिए। आफ्ना पिताका बगाललाई पानी खुवाउन तिनीहरू इनारमा आए, र पानी उघाउँदै डुँडमा भर्न लागे। ");
INSERT INTO npioncb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तब त्यहाँ केही गोठालाहरू पनि आए र तिनीहरूलाई धपाए; तर मोशा उठे, र तिनीहरूलाई सहायता गरे, र तिनीहरूका बगाललाई पानी पिउन दिए। ");
INSERT INTO npioncb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","जब ती ठिटीहरू आफ्ना पिता रूएलकहाँ फर्किए, तब तिनले तिनीहरूलाई सोधे, “आज तिमीहरू कसरी यति चाँडो फर्कियौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","तिनीहरूले जवाफ दिए, “एक जना इजिप्टियनले हामीलाई गोठालाहरूका हातबाट बचाए। तिनले त हाम्रा निम्ति पानी पनि उघाइदिए, र बगाललाई समेत पानी खुवाए।” ");
INSERT INTO npioncb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","उनले आफ्ना छोरीहरूलाई सोधे, “अनि तिनी कहाँ छन्? तिमीहरूले तिनलाई किन छोडिदियौ? तिनलाई खानलाई निम्तो देऊ।” ");
INSERT INTO npioncb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","त्यसपछि मोशा ती मानिससित बस्‍न राजी भए; र उनले आफ्नी छोरी सिप्पोरालाई मोशासित विवाह गरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्पोराले एउटा छोरा जन्माइन्, र मोशाले “म अर्काको मुलुकमा प्रवासी भएँ” भनेर त्यसको नाम गेर्शोम राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","समय बितेपछि इजिप्टका राजा मरे। आफ्ना दासत्वमा इस्राएलीहरूले सुस्केरा हाले; अनि पुकार गर्न थाले। दासत्वको कारण तिनीहरूले सहायताको लागि गरेको चीत्कार परमेश्‍वरकहाँ पुग्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","तब परमेश्‍वरले तिनीहरूको सुस्केरा सुन्‍नुभयो; अनि उहाँले अब्राहाम, इसहाक र याकोबसित बाँध्नुभएको आफ्नो करार सम्झनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","यसकारण परमेश्‍वरले इस्राएलीहरूमाथि दृष्‍टि लगाउनुभयो, र तिनीहरूको वास्ता गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मोशाले आफ्ना ससुरा मिद्यानका पुजारी यित्रोका भेडाबाख्रा चराउँथे। अनि आफ्नो बगाललाई उजाडस्थानको पल्‍लो छेउतिर लगे; अनि तिनी परमेश्‍वरको पर्वत होरेबमा आए। ");
INSERT INTO npioncb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","त्यहाँ याहवेहका दूत पोथ्राको माझमा जलिरहेको ज्वालाको रूपमा तिनीकहाँ देखा पर्नुभयो। मोशाले देखे, कि त्यो पोथ्रा जलिरहेको थियो; तापनि भस्म भएको थिएन। ");
INSERT INTO npioncb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","अनि मोशाले मनमनै सोचे, “यो अनौठो दृश्य म त्यहीँ गएर हेर्नेछु—त्यो पोथ्रा किन भस्म भएको छैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब याहवेहले तिनले हेर्न गएको देख्नुभयो, तब परमेश्‍वरले त्यस पोथ्राभित्रबाट तिनलाई बोलाएर भन्‍नुभयो, “मोशा! ए मोशा!” अनि मोशाले भने, “हजुर, म यहाँ छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","परमेश्‍वरले भन्‍नुभयो, “यता नजिक नआइज! तेरो जुत्ता फुकाल; किनकि तँ उभिएको ठाउँ पवित्र भूमि हो।” ");
INSERT INTO npioncb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","तब उहाँले भन्‍नुभयो, “म तेरा पितापुर्खाका परमेश्‍वर हुँ; अब्राहामका परमेश्‍वर, इसहाकका परमेश्‍वर र याकोबका परमेश्‍वर।” यो सुनेर मोशाले आफ्नो अनुहार छोपे; किनकि तिनी परमेश्‍वरलाई हेर्न डराए। ");
INSERT INTO npioncb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","याहवेहले भन्‍नुभयो, “मैले इजिप्टमा भएका मेरा प्रजाका कष्‍ट साँच्‍चै देखेको छु। परिश्रममा जोतिएकाहरूलाई यातना दिने ठेकेदारहरूका कारण मैले तिनीहरूको चीत्कार सुनेको छु; र तिनीहरूका दुःखप्रति मेरो वास्ता छ। ");
INSERT INTO npioncb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","यसकारण म तिनीहरूलाई इजिप्टियनहरूका हातबाट छुटाउन, र त्यस देशबाट निकालेर एउटा असल र ठूलो देश, दूध र मह बग्ने, जो कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी र यबूसीहरूको देश हो, त्यहाँ ल्याउनलाई म ओर्लिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","अब इस्राएलीहरूको चीत्कार मेरो सामु आइपुगेको छ; अनि इजिप्टियनहरूले कसरी तिनीहरूलाई सताइरहेका छन्, त्यो मैले देखेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","यसकारण अब जा। म मेरा मानिसहरू अर्थात् इस्राएलीहरूलाई इजिप्टबाट बाहिर ल्याउन तँलाई फारोकहाँ पठाउँदैछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","तर मोशाले परमेश्‍वरलाई भने, “फारोकहाँ गएर इस्राएलीहरूलाई इजिप्टबाट बाहिर निकालेर ल्याउने म को हुँ र?” ");
INSERT INTO npioncb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","तब परमेश्‍वरले भन्‍नुभयो, “म तेरो साथमा हुनेछु। तँलाई पठाउने म नै हुँ भनी देखाउने अद्‌भुत चिन्ह यो हुनेछ: जब तैँले ती मानिसहरूलाई इजिप्टबाट बाहिर निकालेर ल्याउनेछस्, तब तिमीहरूले यस पर्वतमा परमेश्‍वरको आराधना गर्नेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मोशाले परमेश्‍वरलाई भने, “यदि मैले गएर इस्राएलीहरूलाई ‘तिमीहरूका पितापुर्खाहरूका परमेश्‍वरले मलाई तिमीहरूकहाँ पठाउनुभएको हो’ भनुँला, र तिनीहरूले मलाई ‘उहाँको नाम के हो?’ भनी सोध्लान्, तब म तिनीहरूलाई त्यस बेला के भनूँ?” ");
INSERT INTO npioncb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्‍वरले मोशालाई भन्‍नुभयो, “म हुँ, जो म हुँ। तैँले इस्राएलीहरूलाई भन्‍नू: ‘म हुँ भन्‍नेले नै मलाई तिमीहरूकहाँ पठाउनुभएको हो।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्‍वरले मोशालाई यसो पनि भन्‍नुभयो, “इस्राएलीहरूलाई भन्‍नू, ‘तिमीहरूका पितापुर्खाहरूका याहवेह परमेश्‍वर—अब्राहामका परमेश्‍वर, इसहाकका परमेश्‍वर र याकोबका परमेश्‍वरले—मलाई तिमीहरूकहाँ पठाउनुभएको हो।’ “मेरो नाम सदा यही रहन्छ, र सबै पुस्तासम्म मेरो नामको सम्झना यही हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“जा, इस्राएलका प्रधानहरूलाई जम्मा गरेर तिनीहरूलाई भन्, ‘याहवेह तिमीहरूका पितापुर्खाहरूका परमेश्‍वर—अब्राहाम, इसहाक र याकोबका परमेश्‍वर—मकहाँ देखा परेर भन्‍नुभयो: मैले तिमीहरूमाथि दृष्‍टि लगाएको छु र तिनीहरूले तिमीहरूलाई इजिप्टमा के-के गरे, सो देखेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","मैले तिमीहरूलाई इजिप्टको दुःखबाट बाहिर निकालेर कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी र यबूसीहरूको देशमा ल्याउनलाई प्रतिज्ञा गरेको छु—जुन दूध र मह बग्ने देश हो।’ ");
INSERT INTO npioncb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“इस्राएलका प्रधानहरूले तेरो कुरा सुन्‍नेछन्। तब तँ र प्रधानहरू इजिप्टका राजाकहाँ गएर यसो भन्‍नू: ‘याहवेह, हिब्रूहरूका परमेश्‍वरले हामीसित भेट गर्नुभयो। हामीलाई तीन दिनको बाटो उजाडस्थानमा गएर याहवेह हाम्रा परमेश्‍वरकहाँ बलिदान चढाउन जान दिनुहोस्।’ ");
INSERT INTO npioncb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","तर म जान्दछु, शक्तिशाली हातले त्यसलाई बाध्य नगराएसम्म इजिप्टको राजाले तिमीहरूलाई जान दिनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","यसकारण म आफ्नो हात पसारेर इजिप्टियनहरूका बीचमा सबै अद्‌भुत कार्यहरू गरेर तिनीहरूलाई प्रहार गर्नेछु। त्यसपछि त्यसले तिमीहरूलाई जान दिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“म इजिप्टियनहरूलाई यस जातिप्रति कृपा राख्ने बनाउनेछु, र तिमीहरू निस्कँदा खाली हात निस्कनेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","हरेक स्त्रीले आफ्ना छिमेकीसित र उसको घरमा बसेकी कुनै पनि स्त्रीसित सुन र चाँदीका चीजहरू, र लुगाफाटाहरू मागेर ती तिमीहरूका छोराछोरीहरूलाई लगाइदिनेछौ। यसरी तिमीहरूले इजिप्टियनहरूलाई लुट्नेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तब मोशाले जवाफ दिए, “यदि तिनीहरूले मलाई विश्‍वास गरेनन् अथवा मेरा कुरा सुनेनन् र ‘याहवेह तिमीसित देखा पर्नुभएको होइन’ भनेर जवाफ दिए भने के गर्ने?” ");
INSERT INTO npioncb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","तब याहवेहले तिनलाई भन्‍नुभयो, “तेरो हातमा भएको त्यो के हो?” तिनले भने, “एउटा लहुरो।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","याहवेहले भन्‍नुभयो, “त्यसलाई भुइँमा फाल्।” मोशाले त्यसलाई भुइँमा फाले, र त्यो एउटा सर्प भयो, र मोशा डराएर भागे। ");
INSERT INTO npioncb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तब याहवेहले तिनलाई भन्‍नुभयो, “आफ्नो हात पसारेर त्यसको पुच्छरमा समात्।” यसकारण मोशाले हात पसारेर त्यस सर्पलाई समाते, र त्यो तिनको हातमा पहिलेझैँ लहुरो भइगयो। ");
INSERT INTO npioncb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","याहवेहले भन्‍नुभयो, “यो याहवेह तिनीहरूका पितापुर्खाका परमेश्‍वर—अब्राहामका परमेश्‍वर, इसहाकका परमेश्‍वर र याकोबका परमेश्‍वर तिमीकहाँ देखा पर्नुभएको हो भनी तिनीहरूले विश्‍वास गरून् भनेर हो।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","तब याहवेहले भन्‍नुभयो, “तेरो हात तेरो वस्त्रभित्र हाल्।” यसकारण मोशाले आफ्नो हात आफ्नो वस्त्रभित्र हाले; अनि जब तिनले त्यसलाई बाहिर निकाले, तब त्यसमा कुष्‍ठरोग लागेर हिउँझैँ सेतो भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","उहाँले भन्‍नुभयो, “अब त्यसलाई आफ्नो वस्त्रभित्र फेरि हाल्।” यसकारण मोशाले आफ्नो हात फेरि वस्त्रभित्र हाले, र जब तिनले त्यसलाई बाहिर निकाले, त्यो शरीरका अरू भागझैँ सद्दे भइहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तब याहवेहले भन्‍नुभयो, “यदि तिनीहरूले तँलाई विश्‍वास गरेनन् अथवा पहिलो अद्‌भुत चिन्हमा ध्यान दिएनन् भने तिनीहरूले दोस्रोमा विश्‍वास गर्लान्। ");
INSERT INTO npioncb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","तर यदि तिनीहरूले यी दुई अलौकिक चिन्हहरूमाथि विश्‍वास गरेनन्, अथवा तेरो कुरा सुनेनन् भने नील नदीबाट केही पानी लिएर त्यसलाई ओबानो भूमिमा पोखाई दिनू। तैँले नदीबाट लिएको पानी सुक्खा भूमिमा रगत हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","मोशाले याहवेहलाई भने, “माफ गर्नुहोला, हे प्रभु। म बोल्नमा सिपालु छैनँ, न त पहिले म सिपालु थिएँ; न अहिले तपाईं बोल्नुभएपछि म सिपालु भएको छु; किनकि म बोल्नमा र जिब्रो चलाउनमा ढिलो छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","याहवेहले तिनलाई भन्‍नुभयो, “मानिसलाई बोल्ने मुख कसले दियो? त्यसलाई लाटो वा बहिरो, देख्ने वा नेदेख्ने भनी कसले निर्णय गर्छ? के त्यो म याहवेहले नै होइनँ र? ");
INSERT INTO npioncb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अब जा; म तँलाई बोल्न सहायता गर्नेछु, र तैँले भन्‍नुपर्ने कुरा सिकाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","तर मोशाले भने, “हे प्रभु, म तपाईंको दास बिन्ती गर्छु, कृपया अरू कसैलाई पठाउनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब मोशाप्रति याहवेहको क्रोध दन्कियो, र उहाँले भन्‍नुभयो, “लेवी कुलको हारून तेरो दाजु होइन र? ऊ राम्ररी बोल्न सक्छ भनी म जान्दछु। त्यो तँसित भेट गर्न आइरहेको छ; र तँलाई देखेर उसको हृदय प्रसन्‍न हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","तँ उसित बोल्नेछस् र उसको मुखमा शब्द हालिदिनेछस्। म तिमीहरू दुवैलाई बोल्न सहायता गर्नेछु, र के गर्नुपर्छ, सो सिकाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","उसले तेरा निम्ति मानिसहरूसित बोलिदिनेछ, र ऊ तेरो मुखपात्र हुनेछ; अनि तँ उसका निम्ति ईश्‍वरतुल्य हुनेछस्। ");
INSERT INTO npioncb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","तर यो लहुरो तेरो हातमा लिनू, र तैँले यसद्वारा अलौकिक चिन्हहरू देखाउनेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मोशा आफ्ना ससुरा यित्रोकहाँ फर्किगएर उनलाई भने, “मेरा आफ्नै दाजुभाइहरू इजिप्टमा कोही जीवितै छन् कि छैनन् भनेर हेर्न मलाई त्यहाँ जान दिनुहोस्।” यित्रोले भने, “शान्तिसित जाऊ।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","याहवेहले मोशालाई मिद्यानमा भन्‍नुभएको थियो, “इजिप्टमा फर्केर जा; किनकि तँलाई मार्न चाहनेहरू सबै मरिसके।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","यसकारण मोशाले आफ्ना पत्नी र छोराहरू लिएर तिनीहरूलाई गधामाथि चढाए; अनि इजिप्टतिर लागे। अनि तिनले परमेश्‍वरको लहुरो आफ्नो हातमा लिए। ");
INSERT INTO npioncb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","याहवेहले मोशालाई भन्‍नुभयो, “जब तँ इजिप्टमा फर्कनेछस्, तब तैँले सबै अद्‌भुत कार्यहरू, जसका लागि मैले तँलाई शक्ति दिएको छु, फारोको सामु देखाउन नभुल्नू। तर म त्यसको हृदय कठोर पारिदिनेछु, र त्यसले मानिसहरूलाई जान दिनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तब फारोलाई भन्, ‘याहवेह यसो भन्‍नुहुन्छ: इस्राएल मेरो जेठो छोरा हो, ");
INSERT INTO npioncb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","र म तँलाई आदेश दिन्छु, “मेरो छोरालाई जान दे, र त्यसले मेरो आराधना गरोस्।” तर तैँले त्यसलाई जान दिइनस्, यसकारण म तेरो जेठो छोरालाई मार्नेछु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","बाटोको एउटा बास बस्‍ने ठाउँमा याहवेहले मोशालाई भेटेर मार्न खोज्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तर सिप्पोराले एउटा ढुङ्गाको चक्‍कु लिएर आफ्नो छोराको खलडी च्वाट्ट काटेर त्यसले मोशाको खुट्टामा छोइदिइन्। तिनले भनिन्, “तपाईं निश्‍चय मेरा निम्ति रगतको दुलहा हुनुहुन्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","यसकारण याहवेहले तिनलाई छोडिदिनुभयो। (त्यस बेला तिनले खतनालाई दर्शाउँदै “रगतको दुलहा” भनिन्।) ");
INSERT INTO npioncb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","याहवेहले हारूनलाई भन्‍नुभयो, “मोशालाई भेट्न उजाडस्थानमा जा।” यसकारण तिनले मोशालाई परमेश्‍वरको पर्वतमा भेटे, र तिनलाई चुम्बन गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","तब मोशाले तिनलाई याहवेहले जे भन्‍न पठाउनुभएको थियो, त्यो हरेक वचन, र तिनलाई उहाँले गर्नू भनेर हुकुम गर्नुभएका सबै अलौकिक चिन्हहरूको विषयमा हारूनलाई बताए। ");
INSERT INTO npioncb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","मोशा र हारूनले इस्राएलका सबै प्रधानहरूलाई एकै ठाउँमा भेला पारे। ");
INSERT INTO npioncb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","अनि हारूनले तिनीहरूलाई याहवेहले मोशालाई भन्‍नुभएका सबै कुराहरू सुनाइदिए। तिनले मानिसहरूका अगि अलौकिक चिन्हहरू पनि देखाए, ");
INSERT INTO npioncb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","र इस्राएलीहरूले विश्‍वास गरे। अनि तिनीहरूले जब याहवेहले तिनीहरूप्रति वास्ता राख्नुभएको छ, र उहाँले तिनीहरूको कष्‍ट देख्नुभएको छ भनी सुने, तब तिनीहरूले निहुरेर आराधना गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","त्यसपछि मोशा र हारून फारोकहाँ गएर भने, “याहवेह, इस्राएलका परमेश्‍वर यसो भन्‍नुहुन्छ: ‘मेरा मानिसहरूलाई मेरा निम्ति उजाडस्थानमा चाड मनाउनलाई जान दे।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फारोले भने, “याहवेह को हुनुहुन्छ, र म उहाँको हुकुम पालन गरूँ, र इस्राएलीहरूलाई जान दिऊँ? म याहवेहलाई चिन्दिनँ, र इस्राएलीहरूलाई जान पनि दिन्‍नँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तब तिनीहरूले भने, “हिब्रूहरूका परमेश्‍वरले हामीलाई भेट्नुभयो। अब हामीलाई तीन दिनको यात्रा गरी उजाडस्थानमा गएर याहवेह हाम्रा परमेश्‍वरका निम्ति बलिदान चढाउन जान दिनुहोस्, नत्रता उहाँले हामीलाई रूढीले अथवा तरवारले प्रहार गर्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","तब इजिप्टका राजाले तिनीहरूलाई भने, “ए मोशा र हारून, तिमीहरू यी मानिसहरूका काममा किन बाधा गर्छौ? तिमीहरू आफ्ना काममा लाग!” ");
INSERT INTO npioncb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","अनि फारोले भने, “हेर, देशका मानिसहरू अब धेरै भएका छन्, र तिमीहरू तिनीहरूलाई काम गर्नदेखि रोकिरहेका छौ।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","त्यही दिन फारोले यातना दिने ठेकेदारहरू र मानिसहरूका नाइकेहरूलाई यस्तो हुकुम दिए: ");
INSERT INTO npioncb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“अब उसो तिमीहरूले ती मानिसहरूलाई इँटाहरू बनाउनलाई पराल नदिनू; तिनीहरू गएर आफ्ना पराल आफैँले बटुलून्। ");
INSERT INTO npioncb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तर तिनीहरूलाई पहिलेकै संख्यामा इँटाहरू बनाउन भन्‍नू; त्यसको संख्या नघटाउनू। तिनीहरू अल्छे छन्; यसैले तिनीहरू ‘हामीलाई आफ्ना परमेश्‍वरका निम्ति बलिदान चढाउन जान दिनुहोस्’ भनी कराउँदैछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ती मानिसहरूका निम्ति काम अझ कठोर पारिदिनू र तिनीहरूले खुरू-खुरू काम गरेर झूटो कुराहरूतिर ध्यान नदेऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","तब ती यातना दिने ठेकेदारहरू र मानिसहरूका नाइकेहरू गएर मानिसहरूलाई भने, “फारो यसो भन्‍नुहुन्छ: ‘म तिमीहरूलाई अबदेखि पराल दिनेछैनँ। ");
INSERT INTO npioncb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","जाओ अनि जहाँबाट पाउन सकिन्छ, त्यहाँबाट आफ्ना लागि पराल ल्याओ, तर तिमीहरूका कामचाहिँ कदापि घटाइनेछैन।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","यसकारण ती मानिसहरू परालको लागि काम चलाउन टुक्राटाक्रीहरू बटुल्नलाई इजिप्टभरि छरिए। ");
INSERT INTO npioncb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ती यातना दिने ठेकेदारहरूले तिनीहरूलाई यसो भन्दै दबाब दिए, “तिमीहरूसित पराल हुँदा काम गरेझैँ, तिमीहरूबाट प्रतिदिन चाहिएका काम पूरा गर।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","फारोका यातना दिने ठेकेदारहरूबाट नियुक्त गरिएका इस्राएली नाइकेहरूलाई तिनीहरूले पिटे र यसो भन्दै सोधे, “तिमीहरूले हिजो र आज आफ्ना इँटाको परिमाण किन पहिलेझैँ पुर्‍याएनौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","तब इस्राएली नाइकेहरू गएर फारोकहाँ उजुर गरे: “हजुरले आफ्ना सेवकहरूसँग किन यस्तो व्यवहार गर्नुहुन्छ? ");
INSERT INTO npioncb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","हजुरका सेवकहरूलाई पराल दिइँदैन, र पनि हामीलाई ‘इँटा बनाओ’ भनी आज्ञा गरिन्छ। हजुरका सेवकहरू कुटाइ पनि खाँदैछन्, तर अपराध भने हजुरकै मानिसहरूको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फारोले भने, “तिमीहरू अल्छे छौ, अल्छे! यसैकारण तिमीहरू ‘हामीलाई याहवेहका निम्ति बलिदान चढाउन जान दिनुहोस्’ भनिबस्छौ। ");
INSERT INTO npioncb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब फर्केर काममा लाग। तिमीहरूलाई कत्ति पनि पराल दिइनेछैन; तर तिमीहरूले तोकिएको संख्यामा इँटाहरू बनाउनैपर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","जब तिनीहरूलाई तिमीहरूले “प्रतिदिन बनाउनुपर्ने इँटाको संख्या घटाइनेछैन” भनियो, तब इस्राएली नाइकेहरूले तिनीहरू सङ्कटमा परेका थाहा पाए। ");
INSERT INTO npioncb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","त्यसपछि तिनीहरू फारोकहाँबाट निस्के, र तिनीहरूले मोशा र हारून तिनीहरूलाई भेट्न पर्खिरहेका भेटे। ");
INSERT INTO npioncb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","अनि तिनीहरूले भने, “याहवेहले तपाईंहरूमाथि दृष्‍टि गरून् र न्याय देऊन्! तपाईंहरूले हामीलाई फारो र उनका अधिकारीहरूको अगि घृणित बनाउनुभयो, र हामीलाई मार्नका निम्ति तिनीहरूका हातमा तरवार राखिदिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","मोशा फर्केर याहवेहकहाँ गएर भने, “हे प्रभु, तपाईंले यस प्रजामाथि किन सङ्कष्‍ट ल्याइदिनुभयो? के तपाईंले मलाई यसकै लागि पठाउनुभएको हो? ");
INSERT INTO npioncb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","म फारोकहाँ तपाईंको नाममा बोल्न गएकै बेलादेखि तिनले यी प्रजामाथि सङ्कष्‍ट ल्याएका छन्; अनि तपाईंले आफ्नो प्रजालाई छुटकारा दिनुभएको छैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब याहवेहले मोशालाई भन्‍नुभयो, “अब म फारोलाई के गर्नेछु, सो तैँले देख्नेछस्: मेरा शक्तिशाली हातको कारण त्यसले तिनीहरूलाई जान दिनेछ; मेरा शक्तिशाली हातको कारण त्यसले तिनीहरूलाई आफ्नो देशबाट धपाइदिनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्‍वरले मोशालाई यसो पनि भन्‍नुभयो, “म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","म अब्राहाम, इसहाक र याकोबकहाँ सर्वशक्तिमान् परमेश्‍वरको रूपमा देखा परेँ, तर याहवेह मेरो नामले त मैले आफैँलाई तिनीहरूसित परिचित गराइनँ। ");
INSERT INTO npioncb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","मैले तिनीहरू प्रवासी भई बसेको कनान देश तिनीहरूलाई दिनेछु भनी मेरो करार पनि तिनीहरूसित स्थापित गरेँ। ");
INSERT INTO npioncb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","यसबाहेक मैले इजिप्टियनहरूले दास बनाइराखेका इस्राएलीहरूका सुस्केरा सुनेको छु, र मैले आफ्नो करार सम्झेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“यसकारण इस्राएलीहरूलाई भन्: ‘म नै याहवेह हुँ, र म तिमीहरूलाई इजिप्टियनहरूका बोझबाट निकालेर ल्याउनेछु। म तिमीहरूलाई तिनीहरूका दासत्वबाट मुक्त गर्नेछु; अनि म तिमीहरूलाई फैलिएको हात र न्यायको पराक्रमी कामले छुटकारा दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","म तिमीहरूलाई मेरा आफ्नै मानिसहरूझैँ लिनेछु, र म तिमीहरूका परमेश्‍वर हुनेछु। तब म नै तिमीहरूका याहवेह परमेश्‍वर हुँ, जसले तिमीहरूलाई इजिप्टियनहरूका दासत्वको जुवामुनिबाट बाहिर निकालेर ल्याउनुभयो भन्‍ने कुरा तिमीहरूले जान्‍नेछौ; ");
INSERT INTO npioncb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","अनि म तिमीहरूलाई त्यस देशमा ल्याउनेछु, जुन देश मैले अब्राहाम, इसहाक र याकोबलाई दिनेछु भनी हात उचालेर शपथ खाएको थिएँ; म त्यो तिमीहरूलाई सम्पत्तिको रूपमा दिनेछु; म नै याहवेह हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","तब मोशाले इस्राएलीहरूलाई यो कुरा बताइदिए; तर तिनीहरूका निराशा र दासत्वको क्रूरताका कारण तिनीहरूले मोशाको कुरा सुनेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जा, र इजिप्टको राजा फारोलाई इस्राएलीहरूलाई त्यसको देशबाट बाहिर जान देऊ भनी भन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","तर मोशाले याहवेहलाई भने, “यदि इस्राएलीहरूले नै मेरा कुरा सुन्दैनन् भने फारोले झन् मेरो कुरा कसरी सुन्लान्? किनकि म भकभकाउँदै बोल्छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","फेरि याहवेह इस्राएलीहरू र इजिप्टका राजा फारोका विषयमा मोशा र हारूनसँग बोल्नुभयो; अनि उहाँले तिनीहरूलाई इस्राएलीहरूलाई इजिप्टबाट बाहिर लैजान आज्ञा दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","तिनीहरूका परिवारहरूका मुख्य-मुख्य मानिसहरू यिनीहरू नै हुन्: इस्राएलका जेठा छोरा रूबेनका छोराहरू: हानोक र पल्‍लू, हेस्रोन र कर्मी। ");
INSERT INTO npioncb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमियोनका छोराहरू: यमूएल, यामीन, ओहद, याकीन, सोहोर र एउटी कनानी स्त्रीको छोरा, शाऊल। ");
INSERT INTO npioncb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","तिनीहरूका वंशावलीअनुसार लेवीका छोराहरूका नाम यिनै हुन्: गेर्शोन, कहात र मरारी। ");
INSERT INTO npioncb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","वंशअनुसार गेर्शोनका छोराहरू यिनै हुन्: लिब्नी र शिमी। ");
INSERT INTO npioncb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहातका छोराहरू: अम्राम, यिसहार, हेब्रोन र उज्जीएल। (कोहात 133 वर्षसम्म बाँचे।) ");
INSERT INTO npioncb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारीका छोराहरू: महली र मूशी। ");
INSERT INTO npioncb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामले आफ्ना बुबाकी बहिनी योकेबेदलाई विवाह गरे; जसले तिनको निम्ति हारून र मोशालाई जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहारका छोराहरू: कोरह, नेपेग र जिक्री। ");
INSERT INTO npioncb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्जीएलका छोराहरू: मिशाएल, एलसाफान र सिथ्री। ");
INSERT INTO npioncb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारूनले अम्मीनादाबकी छोरी र नहशोनकी बहिनी एलिशेबालाई विवाह गरे; अनि तिनले उनको निम्ति नादाब, अबीहू, एलाजार र ईतामारलाई जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहका छोराहरू: अस्सीर, एल्काना र अबिआसाप। ");
INSERT INTO npioncb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारूनका छोरा एलाजारले पतीएलकी छोरीहरूमध्ये एक जनालाई विवाह गरे; र तिनले उनको लागि पीनहासलाई जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","यी तिनै हारून र मोशा थिए, जसलाई याहवेहले भन्‍नुभयो, “इस्राएलीहरूलाई इजिप्टबाट दल-दल बनाएर बाहिर ल्याउनू।” ");
INSERT INTO npioncb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","इजिप्टका राजा फारोसित इस्राएलीहरूलाई इजिप्टबाट बाहिर ल्याउने विषयमा कुरा गर्नेहरू यी दुई मोशा र हारून नै थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","जब याहवेहले इजिप्टमा मोशासित बोल्नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","अनि उहाँले मोशालाई भन्‍नुभयो, “म नै याहवेह हुँ। मैले तँलाई जे-जे कुरा भन्दछु, ती सबै इजिप्टका राजा फारोलाई भन।” ");
INSERT INTO npioncb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","तर मोशाले याहवेहलाई भने, “म बोल्नमा ढिलो छु; फारोले मेरा कुरा किन सुन्थे होला र?” ");
INSERT INTO npioncb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","तब याहवेहले मोशालाई भन्‍नुभयो, “हेर्, मैले तँलाई फारोको निम्ति ईश्‍वरतुल्य बनाएको छु, र तेरा दाजु हारूनचाहिँ तेरा निम्ति प्रवक्ता हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","मैले तँलाई आज्ञा गरेका प्रत्येक कुरा तैँले भन्‍नू, र तेरा दाजु हारूनले फारोलाई भनून्, कि त्यसले इस्राएलीहरूलाई त्यसको देशबाट बाहिर पठाइदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","तर म फारोको हृदय कठोर पारिदिनेछु, र म इजिप्टमा अलौकिक चिन्हहरू र अद्‌भुत कार्यहरूका संख्या बढाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","तर फारोले तेरो कुरा सुन्‍नेछैन। तब म इजिप्ट देशमाथि मेरो हात पसार्नेछु, र न्यायका शक्तिशाली कार्यहरूद्वारा म मेरा दल, मेरा प्रजा इस्राएलीहरूलाई इजिप्ट देशबाट बाहिर निकालेर ल्याउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","जब म आफ्नो हात इजिप्टको विरुद्धमा पसारेर इस्राएलीहरूलाई तिनीहरूको बीचबाट निकालेर बाहिर ल्याउनेछु, तब इजिप्टियनहरूले म नै याहवेह हुँ भनी जान्‍नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","तब मोशा र हारूनले याहवेहले तिनीहरूलाई आज्ञा दिनुभएझैँ गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","तिनीहरूले फारोसित कुरा गर्दा मोशा असी वर्ष र हारून त्रियासी वर्ष पुगेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“जब फारोले तिमीहरूलाई ‘एउटा आश्‍चर्य कर्म गर’ भन्ला, तब हारूनलाई ‘तपाईंको लहुरो लिएर फारोको सामु भुइँमा फालिदिनुहोस्’ भन्‍नू, तब त्यो एउटा सर्प बन्‍नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","यसकारण मोशा र हारून फारोकहाँ गएर याहवेहले आज्ञा गर्नुभएझैँ गरे। हारूनले फारो र उनका अधिकारीहरूको सामु आफ्नो लहुरो भुइँमा फाले, र त्यो एउटा सर्प बन्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब फारोले बुद्धिमान् मानिसहरू र तन्त्रमन्त्र गर्नेहरूलाई बोलाए; अनि इजिप्टका जादुगरहरूले पनि आफ्ना गुप्‍त कलाद्वारा त्यस्तै कामहरू गरे: ");
INSERT INTO npioncb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","प्रत्येकले आफ्नो लहुरो भुइँमा फाले, र त्यो सर्प भयो। तर हारूनको लहुरोले उनीहरूका लहुरोहरूलाई निलिदियो। ");
INSERT INTO npioncb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","तैपनि फारोको हृदय कठोर भयो, र याहवेहले भन्‍नुभएझैँ, उनले तिनीहरूका कुरा सुनेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब याहवेहले मोशालाई भन्‍नुभयो, “फारोको हृदय कठोर भएको छ; त्यसले मानिसहरूलाई जान दिँदैन। ");
INSERT INTO npioncb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","बिहान फारो नदीमा गएको बेला त्यसकहाँ जा। नील नदीको किनारमा त्यससँग भेट गर्नलाई पर्खिबस्; अनि सर्पमा परिणत भएको त्यो लहुरो हातमा लिएर जा। ");
INSERT INTO npioncb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","तब त्यसलाई भन्, ‘याहवेह हिब्रूहरूका परमेश्‍वरले मलाई तपाईंकहाँ यसो भन्‍न पठाउनुभएको छ: मेरा मानिसहरूलाई उजाडस्थानमा मेरो आराधना गर्नलाई जान दे। तर तपाईंले अहिलेसम्म सुन्‍नुभएको छैन। ");
INSERT INTO npioncb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","याहवेह यसो भन्‍नुहुन्छ: यसद्वारा तैँले म नै याहवेह हुँ भनी जान्‍नेछस्; म मेरो हातमा भएको लहुरोले नील नदीको पानीलाई हिर्काउनेछु, र त्यो रगतमा परिणत हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","नील नदीका माछाहरू मर्नेछन्, र नदीको पानी साह्रै गन्हाउनेछ, र इजिप्टियनहरूले त्यस नदीको पानी पिउन सक्नेछैनन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","याहवेहले मोशालाई भन्‍नुभयो, “हारूनलाई भन्, ‘आफ्नो लहुरो लिएर इजिप्टका पानीहरू—नदीनालाहरू, पोखरीहरू र सबै जलाशयहरूमाथि तेरो हात पसार—तब ती सबै रगत हुनेछन्।’ इजिप्टका सबै ठाउँहरू, यहाँसम्म कि काठका भाँडाहरू र ढुङ्गाका भाँडाहरूमा समेत रगतै-रगत हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","मोशा र हारूनले याहवेहले आज्ञा दिनुभएबमोजिम गरे। तिनले फारो र उनका अधिकारीहरूका उपस्थितिमा आफ्नो लहुरो उठाए, र नील नदीको पानीलाई हिर्काए; अनि सबै पानी रगतमा परिणत भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नील नदीमा भएका माछाहरू मरे, र नदीमा यति नराम्रो गन्ध आउन थाल्यो कि इजिप्टियनहरूले त्यस नदीको पानी पिउन सकेनन्। इजिप्ट देशभरि सबै पानी रगतै-रगत भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","तर इजिप्टका जादुगरहरूले पनि आफ्ना गुप्‍त कलाद्वारा त्यस्तै काम गरे; अनि फारोको हृदय कठोर भयो, र याहवेहले भन्‍नुभएझैँ उनले मोशा र हारूनका कुरा सुनेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","बरु फारो फर्केर आफ्नो महलमा गए, र यस कुरामाथि ध्यानै दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","अनि सारा इजिप्टियनहरूले पिउने पानीको लागि नील नदीको वरिपरि खने; किनकि उनीहरूले नदीको पानी पिउन सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","याहवेहले नील नदीमाथि प्रहार गर्नुभएको सात दिन बितिसकेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","फेरि याहवेहले मोशालाई भन्‍नुभयो, “फारोकहाँ गएर त्यसलाई भन्, ‘याहवेह यसो भन्‍नुहुन्छ: मेरा मानिसहरूलाई जान दे, र तिनीहरूले मेरो आराधना गरून्। ");
INSERT INTO npioncb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","यदि तैँले तिनीहरूलाई जान दिइनस् भने हेर्, म तेरो सारा देशमा भ्यागुताहरू पठाएर विपत्ति ल्याउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील नदी भ्यागुताले भरिनेछ। ती भ्यागुताहरू तेरो महलभित्र, तेरो सुत्ने कोठाभित्र, तेरो खाटमाथि, तेरा अधिकारीहरूका घर-घरमा, तेरा प्रजामाथि, तेरो चुल्हा र पिठो मुछ्ने भाँडाहरूमा उक्लेर आउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ती भ्यागुताहरू तँमाथि, तेरा प्रजामाथि र तेरा सबै अधिकारीहरूमाथि पनि आउनेछन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","तब याहवेहले मोशालाई भन्‍नुभयो, “हारूनलाई भन्, ‘आफ्नो लहुरो लिएर तपाईंको हात नदी, नाला, पोखरीहरूमाथि पसार्नुहोस्, र इजिप्ट देशमा भ्यागुताहरू उक्लेर आऊन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","यसकारण हारूनले इजिप्टका पानीहरूमाथि आफ्नो हात पसारे; अनि भ्यागुताहरू माथि निस्केर आए, र इजिप्ट देशलाई ढाकिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","तर जादुगरहरूले पनि आफ्ना गुप्‍त कलाद्वारा त्यसै गरे; तिनीहरूले पनि इजिप्ट देशमा भ्यागुताहरू ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","तब फारोले मोशा र हारूनलाई बोलाएर भने, “म र मेरा मानिसहरूबाट भ्यागुताहरू हटाऊन् भनी याहवेहसित बिन्ती चढाइदेओ, तब म तिम्रा मानिसहरूलाई याहवेहका निम्ति बलिदान चढाउनलाई जान दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशाले फारोलाई भने, “मैले तपाईंका निम्ति, तपाईंका अधिकारीहरू र तपाईंका प्रजाका निम्ति नील नदीका बाहेक यी भ्यागुताहरू तपाईं र तपाईंका घरहरूबाट मुक्त गरिऊन् भनेर प्रार्थना गरिदिने समय ठहराउने सम्मानचाहिँ म तपाईंलाई नै दिन्छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फारोले भने, “भोलि प्रार्थना गरिदिनुहोला।” मोशाले जवाफ दिए, “तपाईंले भन्‍नुभएझैँ नै हुनेछ, र तपाईंले याहवेह हाम्रा परमेश्‍वरझैँ अरू कोही छैन भन्‍ने जान्‍न सक्नुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","यी भ्यागुताहरूले तपाईं, तपाईंका घरहरू, तपाईंका अधिकारीहरू र तपाईंका मानिसहरूलाई छोड्नेछन्; तर तिनीहरू नील नदीमा मात्र रहनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मोशा र हारून फारोकहाँबाट निस्केर गएपछि मोशाले याहवेहकहाँ उहाँले फारोमाथि ल्याउनुभएका भ्यागुताहरूका निम्ति पुकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","अनि याहवेहले मोशाले मागेअनुसार गरिदिनुभयो; अनि ती भ्यागुताहरू घर, आँगन र खेतहरूमा नै मरे। ");
INSERT INTO npioncb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","तिनीहरूले ती बटुलेर थुप्रो लगाए; र देश नै दुर्गन्धले ढाकियो। ");
INSERT INTO npioncb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","तर जब फारोले सबै शान्त भएको देखे, तब तिनले आफ्नो हृदय कठोर पारे, र याहवेहले भन्‍नुभएझैँ मोशा र हारूनका कुरा सुनेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","फेरि याहवेहले मोशालाई भन्‍नुभयो, “हारूनलाई भन्, ‘तपाईंको लहुरो पसारेर जमिनको धुलोलाई हिर्काउनुहोस्,’ अनि त्यो सारा इजिप्ट देशभरि भुसुनै-भुसुना बन्‍नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","तिनीहरूले त्यसै गरे; जब हारूनले लहुरो उठाएर जमिनका धुलोलाई हिर्काए, तब ती भुसुनाहरू मानिसहरू र पशुहरूमाथि आए। जमिनको सबै धुलो सारा इजिप्ट देशभरि भुसुनाहरू बने। ");
INSERT INTO npioncb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","तर जब ती जादुगरहरूले तिनीहरूका गुप्‍त कलाद्वारा भुसुनाहरू निकाल्न खोजे, तिनीहरूले सकेनन्। अनि ती भुसुनाहरू मानिसहरू र पशुहरूमाथि भइरहे। ");
INSERT INTO npioncb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ती जादुगरहरूले फारोलाई भने, “यो सबै कार्यमा परमेश्‍वरको हात छ।” तर फारोको हृदय याहवेहले भन्‍नुभएझैँ कठोर थियो, र तिनले सुन्‍न मानेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","फेरि याहवेहले मोशालाई भन्‍नुभयो, “बिहानै उठ् र फारो नदीमा जाँदा त्यसलाई भन्, ‘याहवेह यसो भन्‍नुहुन्छ: मेरा मानिसहरूलाई जान दे, र तिनीहरूले मेरो आराधना गरून्। ");
INSERT INTO npioncb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","तैँले मेरा मानिसहरूलाई जान दिइनस् भने म तँमाथि र तेरा अधिकारीहरूमाथि, तेरा मानिसहरूमाथि, र तेरा घरहरूमा हुलका हुल झिँगाहरू पठाउनेछु। इजिप्टियनहरूका घरहरू र तिनीहरू बसेका जमिन पनि झिँगाहरूले भरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘तर त्यस दिन म मेरा मानिसहरू बस्‍ने गोशेनको प्रान्तप्रति बेग्लै किसिमले व्यवहार गर्नेछु; त्यहाँ झिँगाको कुनै हुल हुनेछैन, र तैँले म नै याहवेह, यस देशमा छु भनी जान्‍नेछस्। ");
INSERT INTO npioncb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","म मेरा मानिसहरू र तेरा मानिसहरूको बीचमा भिन्‍नता पार्नेछु। यो अलौकिक चिन्ह भोलि हुनेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अनि याहवेहले त्यसै गर्नुभयो। फारोको महलमा र तिनका अधिकारीहरूका घरहरूभित्र धेरै मात्रामा झिँगाका हुलका हुल खनिए; र इजिप्टको जमिन झिँगाहरूद्वारा नाश भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","तब फारोले मोशा र हारूनलाई बोलाएर भने, “जाओ, र यस देशभित्रै आफ्ना परमेश्‍वरका निम्ति बलिदान चढाओ।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","तर मोशाले भने, “यसो गर्नु उचित नहोला। हामीले याहवेह हाम्रा परमेश्‍वरलाई चढाएको बलिदान इजिप्टियनहरूले घृणा गर्छन्। हामीले तिनीहरूका दृष्‍टिमा घृणित बलिदान चढायौँ भने, के तिनीहरूले हामीलाई ढुङ्गाले हान्‍नेछैनन् र? ");
INSERT INTO npioncb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हामीलाई याहवेह हाम्रा परमेश्‍वरले आज्ञा गर्नुभएझैँ तीन दिनको यात्रा गरेर उजाडस्थानमा गएर उहाँका निम्ति बलिदान चढाउनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फारोले भने, “म तिमीहरूलाई उजाडस्थानमा गएर याहवेह तिमीहरूका परमेश्‍वरका निम्ति बलिदान चढाउन जान दिनेछु; तर धेरै टाढा नजाओ। अब मेरा निम्ति प्रार्थना गरिदेओ।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशाले जवाफ दिए, “म तपाईंबाट जाने बित्तिकै याहवेहसित प्रार्थना गर्नेछु, र भोलि यी सबै झिँगाका हुलहरू तपाईं, तपाईंका अधिकारीहरू र तपाईंका मानिसहरूबाट जानेछन्। तर यी मानिसहरूलाई याहवेहका निम्ति बलिदान चढाउन जान नदिएर फारोले फेरि छलपूर्ण काम नगर्न निश्‍चय गर्नुहोला।” ");
INSERT INTO npioncb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","तब मोशा फारोकहाँबाट गए, र याहवेहलाई प्रार्थना चढाए। ");
INSERT INTO npioncb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","याहवेहले मोशाले मागेअनुसार गरिदिनुभयो: ती झिँगाका हुलहरू फारो, तिनका अधिकारीहरू र तिनका मानिसहरूलाई छोडेर गइहाले; एउटै झिँगा पनि बाँकी रहेन। ");
INSERT INTO npioncb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","तर यस पटक पनि फारोले आफ्नो हृदय कठोर पारे, र मानिसहरूलाई जान दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","फेरि याहवेहले मोशालाई भन्‍नुभयो, “फारोकहाँ गएर त्यसलाई भन्, ‘याहवेह, हिब्रूहरूका परमेश्‍वर यसो भन्‍नुहुन्छ: “मेरा मानिसहरूलाई जान दे, र तिनीहरूले मेरो आराधना गरून्।” ");
INSERT INTO npioncb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","तैँले तिनीहरूलाई जान नदिएर रोकेर राखिस् भने, ");
INSERT INTO npioncb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","याहवेहको हातले तेरा खेतमा भएका पशुहरू—तेरा घोडाहरू, गधाहरू, ऊँटहरू अनि तेरा गाईबस्तुहरू र भेडाबाख्राहरूमाथि डरलाग्दो महामारी ल्याउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","तर याहवेहले इस्राएलका गाईबस्तुहरू र इजिप्टका गाईबस्तुहरूका बीचमा भिन्‍नता ल्याउनुहुनेछ; ताकि इस्राएलीहरूका कुनै पनि पशु नमरोस्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","याहवेहले एउटा निश्‍चित समय ठहर्‍याएर भन्‍नुभयो, “भोलि यो कुरा याहवेहले यस देशमा गर्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","अनि भोलिपल्ट याहवेहले त्यो कुरा गर्नुभयो: इजिप्टका सबै गाईबस्तु मरे, तर इस्राएलीहरूका एउटै पनि पशु मरेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोले यो जाँच गर्न मानिसहरू पठाए; अनि इस्राएलीहरूका एउटै पनि पशु नमरेको थाहा पाए। तर पनि तिनको हृदय कठोर भयो, र तिनले मानिसहरूलाई जान दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","फेरि याहवेहले मोशा र हारूनलाई भन्‍नुभयो, “भट्टीबाट आ-आफ्ना हातमा खरानी लेओ, र मोशाले फारोको उपस्थितिमा त्यो हावामा छरिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","त्यो इजिप्ट देशभरि मसिनो धुलो बन्‍नेछ, र इजिप्ट देशभरिका मानिसहरू र पशुहरूमा पाक्ने खटिरा निस्कनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","तब तिनीहरू भट्टीबाट खरानी लिएर फारोको सामु खडा भए। मोशाले त्यसलाई हावामा छरिदिए; अनि मानिसहरू र पशुहरूमा पाक्ने खटिरा निस्के। ");
INSERT INTO npioncb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ती खटिराहरू जादुगरहरू र सारा इजिप्टियनहरूमाथि भएका कारण ती जादुगरहरू मोशाको सामु खडा हुन सकेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","तर याहवेहले फारोको हृदय कठोर पारिदिनुभयो, र याहवेहले मोशालाई भन्‍नुभएझैँ तिनले मोशा र हारूनका कुरा सुनेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","फेरि याहवेहले मोशालाई भन्‍नुभयो, “बिहान सबेरै उठ्, र फारोलाई भन्, ‘याहवेह, हिब्रूहरूका परमेश्‍वर यसो भन्‍नुहुन्छ: मेरा मानिसहरूलाई जान दे, र तिनीहरूले मेरो आराधना गरून्, ");
INSERT INTO npioncb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","नत्रता यस पटक म मेरो पूरा शक्तिसाथ विपत्तिहरू तँमाथि, तेरा अधिकारीहरू, तेरा मानिसहरूका विरुद्धमा पठाउनेछु; र तिमीहरूले सारा पृथ्वीमा मजस्तो अरू कोही छैन भनी जान्‍नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","किनकि अहिले सम्ममा मैले आफ्नो हात पसारेर तँलाई र तेरा मानिसहरूमाथि विपत्तिले प्रहार गर्न सक्नेथिएँ, जसले पृथ्वीबाट तिमीहरूको नामनिशानै मेटिदिनेथियो। ");
INSERT INTO npioncb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","तर मैले त आफ्नो शक्ति तँलाई देखाऊँ र सारा पृथ्वीमा मेरो नामको घोषणा गरियोस् भन्‍ने उद्देश्यले तँलाई खडा गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तैँले त अझ पनि मेरा मानिसहरूलाई जान नदिनका लागि तिनीहरूको विरुद्धमा आफूलाई खडा गरेको छस्। ");
INSERT INTO npioncb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","यसकारण भोलि यही समयमा म यस्तो भयानक असिना पठाउनेछु; जुन इजिप्ट देश स्थापित भएको समयदेखि अहिलेसम्म कहिल्यै खसेको छैन। ");
INSERT INTO npioncb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","यसकारण तेरा गाईबस्तुहरू, तेरा खेतमा भएका हरेक कुरा सुरक्षित ठाउँमा ल्याउन भनी अहिले हुकुम दे; किनकि भित्र नल्याइएका, र खेतमै रहेका प्रत्येक मानिस र पशुमाथि असिना बर्सनेछ, र ती मर्नेछन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","याहवेहको वचनदेखि डराउने फारोका अधिकारीहरूले आफ्ना सेवकहरू र पशुहरूलाई भित्र ल्याउन हतार गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","तर याहवेहको वचनको अवहेलना गर्नेहरूले आफ्ना सेवक र पशुहरू खेतमै छोडिराखे। ");
INSERT INTO npioncb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","तब याहवेहले मोशालाई भन्‍नुभयो, “तेरो हात आकाशतिर पसार्, र इजिप्ट देशमाथि, मानिसहरूमाथि, पशुहरूमाथि र इजिप्टको खेतमा बढ्दै गरेको प्रत्येक कुरामाथि असिना परोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","जब मोशाले आफ्नो लहुरो आकाशतिर पसारे, तब याहवेहले गर्जन र असिना पठाउनुभयो; अनि बिजुली चम्केर जमिनसम्मै पर्‍यो। यसरी याहवेहले इजिप्टमा असिना बर्साउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","असिना पर्‍यो र बिजुली जताततै चम्क्यो। इजिप्ट एउटा राष्ट्र बनेको दिनदेखि यता यस्तो प्रकारको असिना कहिल्यै परेको थिएन। ");
INSERT INTO npioncb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","समस्त इजिप्टमा असिनाले खेतमा भएका सबै थोक, मानिसहरू र पशुहरू दुवैलाई प्रहार गर्‍यो; यसले खेतमा बढिरहेका सबै घाँसलाई चुट्यो, र प्रत्येक रूखलाई नाङ्गो बनाइदियो। ");
INSERT INTO npioncb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","इस्राएलीहरू बसेका गोशेनको प्रान्तमा मात्र असिना परेको थिएन। ");
INSERT INTO npioncb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","तब फारोले मोशा र हारूनलाई बोलाइपठाए। तिनले उनीहरूलाई भने, “यस पटक मैले पाप गरेको छु। याहवेह धर्मी हुनुहुन्छ; अनि म र मेरा मानिसहरू गलत रहेछौँ। ");
INSERT INTO npioncb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","यो गर्जन र असिना अति भयो भनी याहवेहसित बिन्ती गरिदेओ; म तिमीहरूलाई जान दिनेछु; तिमीहरू अब उसो एकक्षण पनि बस्‍नुपर्नेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशाले जवाफ दिए, “म यस सहरबाट बाहिर निस्केपछि मेरा याहवेहसित बिन्ती गर्दै आफ्ना हात पसार्नेछु। तब गर्जन थामिनेछ, र असिना फेरि पर्नेछैन; र तपाईंले यो पृथ्वी याहवेहकै हो भनी जान्‍नुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तर म जान्दछु, तपाईं र तपाईंका अधिकारीहरू अझ पनि याहवेह परमेश्‍वरको डर मान्‍नुहुन्‍न।” ");
INSERT INTO npioncb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(सनपाटका फूल फुलेका र जौका बाला निस्केका हुनाले ती नष्‍ट भए। ");
INSERT INTO npioncb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","तर गहुँ र कठियागहुँ ढिलो पाक्ने हुनाले नष्‍ट भएनन्।) ");
INSERT INTO npioncb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","तब मोशा फारोकहाँबाट निस्केर सहरबाहिर गए। तिनले आफ्ना हात याहवेहतिर फैलाए; अनि गर्जन र असिना थामिए, र देशमा पानी पर्न छाड्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फारोले पानी, असिना र गर्जन थामिएको देखे, तब तिनले फेरि पाप गरे: तिनी र तिनका अधिकारीहरूले आफ्ना हृदय कठोर गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","तब फारोको हृदय कठोर भयो; याहवेहले मोशाद्वारा भन्‍नुभएझैँ तिनले इस्राएलीहरूलाई जान दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","फेरि याहवेहले मोशालाई भन्‍नुभयो, “फारोकहाँ जा, किनकि मैले त्यसको र त्यसका अधिकारीहरूको हृदय कठोर बनाइदिएको छु, ताकि म तिनीहरूमाथि आफ्ना यी अलौकिक चिन्हहरू गर्न सकूँ; ");
INSERT INTO npioncb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","अनि मैले इजिप्टियनहरूसित कति कडा व्यवहार गरेँ, र मैले कसरी तिनीहरूबीच मेरा अलौकिक चिन्हहरू देखाएँ भनी तिमीहरूले आफ्ना छोराछोरीहरू र नातिनातिनाहरूलाई भन्‍नेछौ, र तिमीहरूले म नै याहवेह हुँ भनी जान्‍नेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","यसकारण मोशा र हारून फारोकहाँ गएर तिनलाई भने, “याहवेह, हिब्रूहरूका परमेश्‍वर, यसो भन्‍नुहुन्छ: ‘मेरो अगि आफूलाई नम्र तुल्याउन तँ कहिलेसम्म अस्वीकार गर्छस्? मेरा मानिसहरूलाई जान दे, र तिनीहरूले मेरो आराधना गरून्। ");
INSERT INTO npioncb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","तैँले तिनीहरूलाई जान दिन अस्वीकार गरिस् भने म भोलि तेरो देशमा सलहहरू ल्याउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","तिनीहरूले जमिनलाई नदेखिने गरी ढाकिदिनेछन्। असिनापछि अलि-अलि जे जति बाँकी रहेका छन्, तिनीहरूले ती सबै अनि तिमीहरूका खेतहरूमा बढ्दै गरेका प्रत्येक रूखलाई खाइदिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","तिनीहरूले तेरा घरहरू, तेरा सबै अधिकारीहरू र सारा इजिप्टियनहरूका घरहरू भरिनेछन्; यस्ता सलहहरू न तेरा पिताले, न त तेरा पुर्खाहरूले नै यस देशमा बसोबास गरेको समयदेखि आजसम्म देखेका छन्।’ ” तब मोशा फर्के, र फारोलाई छोडेर गए। ");
INSERT INTO npioncb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोका अधिकारीहरूले तिनलाई भने, “यो मानिस कहिलेसम्म हाम्रा निम्ति पासो बन्‍ने? यी मानिसहरूलाई जान दिनुहोस्, ताकि याहवेह तिनीहरूका परमेश्‍वरको आराधना गरून्। इजिप्ट नाश भइसक्यो भनेर के तपाईंलाई अझ थाहा छैन र?” ");
INSERT INTO npioncb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","तब मोशा र हारून फारोकहाँ फर्काएर ल्याइए। अनि तिनले उनीहरूलाई भने, “जाओ, गएर याहवेह तिमीहरूका परमेश्‍वरको आराधना गर। तर जानेहरूचाहिँ को-को हुन्?” ");
INSERT INTO npioncb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशाले जवाफ दिए, “हामी आफ्ना साना-ठूलासित, आफ्ना छोराछोरीहरूसित, आफ्ना बगाल र बथान सहित जानेछौँ; किनकि हामीले याहवेहका निम्ति चाड मनाउनुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फारोले भने, “म तिमीहरूलाई तिमीहरूका स्त्रीहरू र छोराछोरीहरूसहित जान दिनेछु, याहवेह तिमीहरूसित होऊन्, तर होशियार होऊ; किनभने तिमीहरूको यसमा दुष्‍टता देखिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","अहँ, त्यसो होइन; तिमीहरू पुरुषहरू मात्र जाओ, र याहवेहको आराधना गर, जसका निम्ति तिमीहरूले बिन्ती गरिरहेका छौ।” तब मोशा र हारून फारोको उपस्थितिबाट निकालिए। ");
INSERT INTO npioncb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","अनि याहवेहले मोशालाई भन्‍नुभयो, “तेरो हात इजिप्टमाथि पसार्, र सलहहरूका हुल यस देशमा आऊन्, र खेतमा बढिरहेका घाँसपात, असिनाबाट बचेको सबै थोक खाइदेऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","तब मोशाले आफ्नो लहुरो इजिप्टमाथि पसारे; अनि याहवेहले देशको चारैतिर दिनभरि र रातभरि पूर्वीय बतास चलाइदिनुभयो। तब बिहान भएपछि पूर्वीय बतासले सलहहरू ल्यायो। ");
INSERT INTO npioncb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","सलहहरूले सम्पूर्ण इजिप्टमाथि आक्रमण गरे, र देशका सबै भागहरूमा धेरै संख्यामा बसे। यसअगि कहिल्यै यति धेरै सलहहरू आएका थिएनन्, न त फेरि त्यो कहिल्यै आउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","तिनीहरूले सम्पूर्ण जमिनलाई कालो हुने गरी ढाकिदिए। तिनीहरूले असिनाले बचेका हरेक वनस्पति र रूखका सबै फलहरू खाइदिए। इजिप्टभरिका रूखहरू अथवा बोटबिरुवाहरूमा हरियो पात केही बाँकी रहेन। ");
INSERT INTO npioncb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","त्यसैले फारोले तुरुन्तै मोशा र हारूनलाई बोलाएर भने, “मैले याहवेह तिमीहरूका परमेश्‍वर र तिमीहरूका विरुद्धमा पाप गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अब फेरि एकपल्ट मेरो पाप क्षमा गरिदेओ, र यो घातक विपत्ति मबाट हटाइदेऊन् भनी याहवेह तिमीहरूका परमेश्‍वरसित बिन्ती गरिदेओ।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","तब मोशा फारोकहाँबाट निस्केर गइहाले र याहवेहलाई बिन्ती चढाए। ");
INSERT INTO npioncb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","अनि याहवेहले बतासलाई ठूलो पश्‍चिमी बतासमा परिणत गरिदिनुभयो, जसले सलहहरूलाई उडाएर लाल समुद्रमा फालिदियो। त्यसपछि इजिप्टमा एउटै सलह पनि रहेन। ");
INSERT INTO npioncb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तर याहवेहले फारोको हृदय कठोर पारिदिनुभयो; र तिनले इस्राएलीहरूलाई जान दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","तब याहवेहले मोशालाई भन्‍नुभयो, “तेरो हात आकाशतिर पसार्, र इजिप्टमाथि अँध्यारो भइजाओस्—छाम्दा पनि थाहा पाउनेजस्तो अन्धकार।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","यसकारण मोशाले आफ्नो हात आकाशतिर पसारे, र इजिप्टभरि तीन दिनसम्म घनघोर अन्धकार भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","तीन दिनसम्म कसैले एक-अर्कालाई देख्न सकेनन्, र आफ्नो ठाउँ छोड्न सकेनन्। तरै पनि इस्राएलीहरूका निम्ति त तिनीहरू बसेको ठाउँहरूमा उज्यालो रह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","तब फारोले मोशालाई बोलाएर भने, “जाऊ, याहवेहको आराधना गर। तिमीहरूका स्त्रीहरू र छोराछोरीहरू पनि तिमीहरूसित जाऊन्; केवल तिमीहरूका बगाल र बथान मात्र यहाँ रहून्।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","तर मोशाले भने, “तपाईंले हामीलाई याहवेह हाम्रा परमेश्‍वरका निम्ति बलिदान र होमबलि चढाउन दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","हाम्रा गाईबस्तुहरू पनि हामीसित जानेछन्, र एउटै खुर समेत छोडिनेछैन; किनकि हामीले तीमध्ये कुनै-कुनै बस्तुभाउ हाम्रा याहवेह परमेश्‍वरलाई चढाउनुपर्छ; जबसम्म हामी त्यहाँ पुग्दैनौँ, तबसम्म हामीले याहवेहलाई के-के चढाएर आराधना गर्नुपर्छ, सो हामीलाई थाहा हुँदैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","तर याहवेहले फारोको हृदय कठोर पारिदिनुभयो; अनि उनले तिनीहरूलाई जान दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फारोले मोशालाई भने, “यहाँबाट गईहाल! अब फेरि मेरो सामु तिमी देखा पर्दै नपर! तिमीले मेरो अनुहार देखेको त्यही दिन तिमी मर्नेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशाले जवाफ दिए, “तपाईंले भन्‍नुभएझैँ म फेरि तपाईंको सामु कहिल्यै देखा पर्नेछैनँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","फेरि याहवेहले मोशालाई भन्‍नुभयो, “म फारो र इजिप्टमाथि अझै एउटा विपत्ति ल्याउनेछु। त्यसपछि त्यसले तिमीहरूलाई जान दिनेछ; जब त्यसले जान दिनेछ, त्यसले तिमीहरूलाई पूर्ण रूपले निकालिदिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","मानिसहरूलाई भन्, कि पुरुष र स्त्री दुवैले आफ्ना छिमेकीहरूसँग चाँदी र सुनका चीजहरू मागून्।” ");
INSERT INTO npioncb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(याहवेहले इजिप्टियनहरूलाई यी मानिसहरूप्रति दयालु बनाउनुभयो; मोशा आफूले पनि फारो र तिनका अधिकारीहरू र मानिसहरूद्वारा अति मान-सम्मान पाएका थिए।) ");
INSERT INTO npioncb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","यसकारण मोशाले भने, “याहवेह यसो भन्‍नुहुन्छ: ‘मध्यराततिर म इजिप्टको बीचबाट भएर जानेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","इजिप्टमा भएका प्रत्येक जेठो छोरा मर्नेछ। सिंहासनमा बस्‍ने फारोको जेठा छोरादेखि लिएर, जाँतो पिँध्ने दासीको जेठा छोरासम्म, र पशुहरूको पनि पहिले जन्मिएका प्रत्येक सबै मर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","इजिप्टभरि चर्को विलाप हुनेछ—जुन पहिले कहिल्यै भएको थिएन, न त फेरि पछि यस्तो विलाप कहिल्यै हुनेछ; ");
INSERT INTO npioncb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","तर इस्राएलीहरूका बीचमा भने कुनै मानिसलाई अथवा पशुलाई एउटा कुकुरले पनि भुक्नेछैन।’ तब तिमीहरूले जान्‍नेछौ कि याहवेहले इजिप्ट र इस्राएलको बीचमा भिन्‍नता राख्नुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","तेरा यी सबै अधिकारीहरू मकहाँ आएर मलाई दण्डवत् गर्दै यसो भन्दै आउनेछन्, ‘तपाईं र तपाईंका पछि लाग्ने मानिसहरू जानुहोस्!’ त्यसपछि म निस्किजानेछु।” तब अत्यन्त क्रोधित भएर मोशा फारोकहाँबाट गइहाले। ");
INSERT INTO npioncb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","याहवेहले मोशालाई भन्‍नुभएको थियो, “इजिप्टमा मेरा अद्‌भुत कार्यहरू बढ्दै जाऊन् भनेर फारोले तेरो कुरा सुन्‍न इन्कार गर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशा र हारूनले फारोको अगि यी सबै अद्‌भुत कार्यहरू गरे, तर याहवेहले फारोको हृदय कठोर पारिदिनुभयो, र तिनले इस्राएलीहरूलाई आफ्नो देशबाट जान दिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","याहवेहले मोशा र हारूनलाई इजिप्टमा भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“यो महिना तिमीहरूका लागि महिनाहरूको सुरु, वर्षको पहिलो महिना हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएलका सम्पूर्ण समुदायलाई प्रत्येक मानिसले यो महिनाको दशौँ दिनमा आफ्ना परिवारको लागि प्रत्येक घरानाअनुसार एउटा थुमा लिनुपर्छ भनी भन्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","कुनै घराना एउटा थुमाको लागि एकदमै सानो छ भने तिनीहरूले मानिसहरूको संख्याको हिसाबले एउटा थुमा आफ्नो नजिकैको छिमेकीसित मिलेर खाऊन्। हरेक मानिसले कति खान सक्छ भन्‍ने हिसाबले थुमा कति चाहिन्छ भनी तैँले निर्णय गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","तैँले रोज्नुपर्ने पशु खोटरहितको एकवर्षे पाठो हुनुपर्छ; अनि तैँले त्यो भेडा अथवा बाख्राबाट लिन सक्नेछस्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","तिनीहरूलाई तिमीहरूले महिनाको चौधौँ दिनसम्म रेखदेख गर्नू, र इस्राएलको समुदायका सबै मानिसहरूले तिनीहरूलाई साँझपख मारून्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","तब तिनीहरूले केही रगत लिएर जुन घरमा तिनीहरूले थुमा खान्छन्, त्यसका चौकसका दुई पट्टिका र माथिल्‍ला भागहरूमा लगाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","त्यही रात तिनीहरूले त्यो मासु आगोमा पोलेर तितो सागसित र खमिर नमिसाइएको रोटीसित खाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","त्यो मासु काँचो अथवा पानीमा पकाएर नखानू, तर त्यसलाई आगोमा पोल्नू—टाउको, खुट्टाहरू अनि भित्री भागहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","त्यसको केही पनि भाग बिहानसम्म नराख्नू; बिहानसम्म केही रह्‍यो भने त्यसलाई जलाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","त्यसलाई तिमीहरूले यसरी खानू: तिमीहरूका पटुका कसेर, खुट्टामा जुत्ता लगाएर र तिमीहरूका लहुरो हातमा लिएर त्यसलाई हतार-हतार खानू; यो याहवेहको निस्तार चाड हो। ");
INSERT INTO npioncb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“त्यही रात म इजिप्टबाट भएर जानेछु अनि मानिसहरू र पशुहरूका प्रत्येक जेठोमाथि प्रहार गर्नेछु, र इजिप्टका सबै देवी-देवताहरूमाथि न्याय ल्याउनेछु; म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","त्यो रगत तिमीहरू बसेका घरहरूमा चिन्ह हुनेछ; अनि जब म रगत देख्नेछु, तब म तिमीहरूलाई छोडेर जानेछु। मैले इजिप्टमाथि प्रहार गर्दा तिमीहरूलाई कुनै पनि नाश गर्ने विपत्तिले छुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“यस दिनलाई तिमीहरूको स्मरणमा राख्नू; अनि आउने पुस्ताका निम्ति तिमीहरूले यसलाई याहवेहका चाडको हिसाबले मान्‍नू—यो सदाको निम्ति एउटा धार्मिक विधि हो। ");
INSERT INTO npioncb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","सात दिनसम्म तिमीहरूले खमिर नमिसाइएको रोटी खानू। पहिलो दिन आफ्ना घरहरूबाट खमिर निकाल्नू; किनकि जसले पहिलो दिनदेखि लिएर सातौँ दिनसम्म खमिर हालेको केही खान्छ, त्यो इस्राएलदेखि बहिष्कृत होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","पहिलो दिन एउटा पवित्र सभा आयोजना गर, र अर्को सभा सातौँ दिनमा गर। प्रत्येकले खानलाई भोजन तयार गर्नुबाहेक यी सबै दिनहरूमा पटक्‍कै काम नगर्नू; भोजन बनाउने काम मात्र तिमीहरू गर्न सक्छौ। ");
INSERT INTO npioncb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“अखमिरी रोटीको चाड मान्‍नू; किनकि यो त्यही दिन हो, जसमा मैले तिमीहरूका दलहरूलाई इजिप्टबाट ल्याएँ। यस दिनलाई भावी पुस्ताका लागि एउटा सदाको धार्मिक विधिस्वरूप मान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","पहिलो महिनाको चौधौँ दिनको साँझदेखि एक्‍काइसौँ दिनको साँझसम्म तिमीहरूले खमिर नमिसाइएको रोटी खानू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिनसम्म तिमीहरूका घरहरूमा खमिर पटक्‍कै नपाइयोस्। अनि जसले खमिर मिसाएर केही कुरा खान्छ, त्यो परदेशी होस् वा स्वदेशमै जन्मेको होस्, त्यसलाई इस्राएलको समुदायबाट बहिष्कार गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","खमिर मिसाएर केही कुरा पनि नखानू। तिमीहरू जहाँ बसे तापनि खमिर नमिसाइएको रोटी नै खानू।” ");
INSERT INTO npioncb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","तब मोशाले इस्राएलका सबै प्रधानहरूलाई बोलाएर तिनीहरूलाई भने, “झट्टै गएर तपाईंहरूका परिवारहरूका निम्ति पशुहरू रोज्नुहोस् र निस्तार चाडको पाठो मार्नुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","हिसपको एउटा झुप्पा लिएर भाँडामा भएको रगतमा चोप्नुहोस्, र केही रगत चौकसका माथिल्‍लो र दुवैतिरका भागमा लगाउनुहोस्। बिहानसम्म आफ्नो घरदेखि कोही पनि बाहिर ननिस्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","जब याहवेह इजिप्टियनहरूलाई प्रहार गर्नलाई यस देशबाट भएर जानुहुनेछ, तब उहाँले चौकसका माथिल्‍ला र दुई छेउका भागहरूमा रगत देख्नुहुनेछ; अनि उहाँले त्यस ढोकालाई नाघेर जानुहुनेछ, र विनाशकर्तालाई नाश गर्न तपाईंहरूका घरमा पस्‍न दिनुहुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“यस निर्देशनलाई तपाईंहरू र तपाईंहरूका सन्तानका लागि एउटा सदाको धार्मिक नियमस्वरूप पालन गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","जब तपाईंहरू याहवेहले प्रतिज्ञा गर्नुभएको देशमा प्रवेश गर्नुहुनेछ, यस उत्सवलाई मान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","अनि जब तपाईंहरूका छोराछोरीहरूले तपाईंहरूलाई ‘तपाईंहरूका निम्ति यस उत्सवको अर्थ के हो?’ भनी सोध्छन्, ");
INSERT INTO npioncb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तब तपाईंहरूले भन्‍नू, ‘यो याहवेहको निम्ति निस्तारको बलिदान हो; उहाँले इजिप्टमा इस्राएलीहरूका घरहरूलाई छोड्नुभयो, र इजिप्टियनहरूलाई प्रहार गर्नुहुँदा हाम्रा परिवारहरूलाई जोगाइराख्नुभयो।’ ” तब मानिसहरूले शिर निहुराएर आराधना गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","इस्राएलीहरूले याहवेहले मोशा र हारूनलाई आज्ञा गर्नुभएबमोजिम नै गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मध्यरातमा याहवेहले सिंहासनमा बस्‍ने फारोको जेठा छोरादेखि लिएर झ्यालखानामा भएको कैदीको जेठा छोरा, र सबै गाईबस्तुहरूका पहिले जन्मेकाहरू समेत, र इजिप्टका पहिले जन्मेकाहरू सबैलाई मार्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","फारो र तिनका सबै अधिकारीहरू र सारा इजिप्टियनहरू राति नै उठे, र इजिप्टमा ठूलो रुवाबासी चल्यो; किनकि त्यहाँ कोही नमरेको कुनै घर थिएन। ");
INSERT INTO npioncb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","रातको समयमा फारोले मोशा र हारूनलाई बोलाइपठाएर भने, “तिमीहरू र सारा इस्राएलीहरू उठ! अनि मेरा मानिसहरूलाई छोडिदेओ! जाओ, र तिमीहरूले बिन्ती गरेझैँ याहवेहको आराधना गर। ");
INSERT INTO npioncb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","तिमीहरूका बगाल र बथान पनि तिमीहरूले भनेझैँ लिएर जाओ; अनि मलाई पनि आशिष् देओ।” ");
INSERT INTO npioncb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","इजिप्टियनहरूले ती मानिसहरूलाई झट्टै देश छोडेर जान भनेर बिन्ती गरे। तिनीहरूले भने, “नत्रता हामी सबै मर्नेछौँ!” ");
INSERT INTO npioncb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","यसकारण मानिसहरूले आफ्ना मुछेको पिठो खमिर हाल्न अगि नै मुछ्ने भाँडामा लुगाले बेह्रेर आफ्ना काँधमा बोके। ");
INSERT INTO npioncb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्राएलीहरूले मोशाले भनेझैँ गरे; अनि इजिप्टियनहरूबाट चाँदी र सुनका सामग्रीहरू अनि लुगाहरू मागे। ");
INSERT INTO npioncb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","याहवेहले मानिसहरूलाई इजिप्टियनहरूको निगाहमा राखिदिनुभयो; र तिनीहरूले उनीहरूले मागेका सबै कुराहरू दिइहाले; यसरी तिनीहरूले इजिप्टियनहरूलाई लुटे। ");
INSERT INTO npioncb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएलीहरूले रामसेसदेखि सुक्‍कोतसम्म यात्रा गरे। स्त्री र बालबालिकाहरू छोडेर, लगभग छ लाख पैदल हिँड्ने मानिसहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","अरू धेरै मानिसहरूका साथसाथै बगाल र बथानसित गाईबस्तुको ठूलो हुल पनि तिनीहरूसित गए। ");
INSERT INTO npioncb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","इजिप्टबाट ल्याएको मुछेको पिठोबाट तिनीहरूले अखमिरी रोटीहरू पकाए। त्यो मुछेको पिठो खमिररहित थियो; किनकि तिनीहरू इजिप्टबाट धपाइएका थिए, र तिनीहरूसित आफ्ना भोजन बनाउने समय पनि थिएन। ");
INSERT INTO npioncb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएलीहरू इजिप्टमा बसेको 430 वर्ष भइसकेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 वर्षको अन्त्यमा त्यही दिन याहवेहको सम्पूर्ण दलहरूले इजिप्ट छोडे। ");
INSERT INTO npioncb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","तिनीहरूलाई इजिप्टबाट बाहिर निकाल्नलाई त्यस रात याहवेहले हेरचाह गर्नुभएको कारण सारा इस्राएलीहरू पनि भावी पुस्तामा याहवेहलाई सम्मान दिनको निम्ति त्यस रात जागा रहनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, “निस्तार चाडका नियमहरू यिनै हुन्: “यसबाट कुनै विदेशीले खानुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","तिमीहरूले किनेका हरेक दासले तिमीहरूले त्यसलाई खतना गरिदिएपछि यसबाट खाओस्, ");
INSERT INTO npioncb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","तर परदेशी र ज्यालादारी नोकरले यसबाट नखाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“त्यो एउटै घरभित्र खाइनुपर्छ; मासुबाट अलिकति पनि घरबाट बाहिर नलैजानू। त्यसको कुनै पनि हड्डी नभाँच्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएलका सम्पूर्ण समुदायले त्यो उत्सव मनाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“तिमीहरूसित बस्‍ने कुनै परदेशीले याहवेहको निस्तार चाडको उत्सव मनाउन चाहन्छ भने त्यसले आफ्ना परिवारका सबै पुरुषहरूको खतना गराउनुपर्छ; तब त्यसले स्वदेशमा जन्मेकाले झैँ त्यसमा भाग लिन सक्छ। खतना नभएको कुनै पुरुषले यसबाट खान पाउनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","तिमीहरूसित बस्‍ने स्वदेशी र विदेशीको लागि यही नियम लाग्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","सारा इस्राएलीहरूले याहवेहले मोशा र हारूनलाई आज्ञा दिनुभएबमोजिम गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","अनि त्यही दिन याहवेहले इस्राएलीहरूलाई इजिप्टबाट तिनीहरूका दलअनुसार बाहिर निकालेर ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“पहिले जन्मेका प्रत्येक पुरुषलाई मेरा निम्ति अर्पण गर। इस्राएलीहरूबीच गर्भको हरेक पहिलो फल मेरो हो—चाहे त्यो मानिस होस् वा पशु।” ");
INSERT INTO npioncb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","तब मोशाले मानिसहरूलाई भने, “यस दिनलाई सम्झना गर, जुन दिन तिमीहरू इजिप्टबाट, दासत्वको देशबाट निस्केर आयौ; किनकि याहवेहले तिमीहरूलाई शक्तिशाली हातले त्यहाँबाट बाहिर निकालेर ल्याउनुभयो। खमिर भएको कुनै कुरा नखाओ। ");
INSERT INTO npioncb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज आबीब महिनामा तिमीहरू निस्कँदैछौ। ");
INSERT INTO npioncb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","जब याहवेहले तिमीहरूलाई कनानीहरू, हित्तीहरू, एमोरीहरू, हिव्वीहरू र यबूसीहरूको देश—उहाँले तिमीहरूका पितापुर्खाहरूलाई दिनेछु भनेर शपथ खानुभएको दूध र मह बग्ने देशमा ल्याउनुहुनेछ, तब तिमीहरूले यही महिनामा यो उत्सव मनाउनुपर्छः ");
INSERT INTO npioncb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","सात दिनसम्म खमिर नमिसाइएको रोटी खानू र सातौँ दिनमा याहवेहका निम्ति चाड मनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ती सात दिनहरूमा अखमिरी रोटी खानू; तिमीहरूका साँधसिमानाभित्र खमिर भएका चीज र खमिर देखिनुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","त्यस दिन तिमीहरूले आफ्ना छोरालाई भन्‍नू, ‘म इजिप्टबाट निस्केर आउँदा याहवेहले मेरो लागि जे गर्नुभयो, त्यसका लागि म यो गर्छु।’ ");
INSERT INTO npioncb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","याहवेहको व्यवस्था तिमीहरूका ओठमा रहोस् भनी यो रीति तिमीहरूको हातमा एउटा चिन्हस्वरूप र तिमीहरूका निधारमा एउटा सम्झना दिलाउने कुरो हुनेछ; किनकि याहवेहले तिमीहरूलाई इजिप्टबाट उहाँको शक्तिशाली हातले निकालेर ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","तिमीहरूले यो रीति वर्षैपिच्छे तोकिएको समयमा पालन गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“उहाँले तिमीहरू र तिमीहरूका पितापुर्खाहरूसित शपथद्वारा प्रतिज्ञा गर्नुभएझैँ याहवेहले तिमीहरूलाई कनानीहरूको देशमा ल्याएर त्यो तिमीहरूलाई दिनुभएपछि, ");
INSERT INTO npioncb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तिमीहरूले प्रत्येक गर्भको पहिलो फल याहवेहलाई दिनुपर्छ। तिमीहरूका पशुहरूका पहिले जन्मेका सबै नरहरू याहवेहकै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","पहिले जन्मेको गधालाई एउटा पाठो दिएर छुटाउनू, तर तिमीहरूले त्यसलाई छुटाएनौ भने त्यसको घाँटी भाँचिदिनू। तिमीहरूका छोराहरूमध्ये जेठालाई छुटाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“भविष्यमा जब तिमीहरूका छोराले ‘यसको अर्थ के हो?’ भनी सोध्नेछ, तब त्यसलाई भन्‍नू, ‘याहवेहले हामीलाई शक्तिशाली हातले दासत्वको देश इजिप्टबाट निकालेर ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","जब फारोले हठी भएर हामीलाई जान दिएनन्, याहवेहले इजिप्टमा मानिस र पशुबाट प्रथम जन्मेका हरेकलाई मार्नुभयो। यसैकारण म प्रत्येक गर्भको प्रथम नरलाई याहवेहका निम्ति बलिदान चढाउँछु, र मेरा पहिला जन्मेका प्रत्येक छोरालाई छुटाउँछु।’ ");
INSERT INTO npioncb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","अनि याहवेहले हामीलाई इजिप्टबाट शक्तिशाली हातले निकालेर ल्याउनुभयो भन्‍ने यो तिमीहरूका हातमा चिन्हस्वरूप र निधारमा सङ्केतस्वरूप हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","जब फारोले ती मानिसहरूलाई जान दिए, याहवेहले तिनीहरूलाई पलिश्तीहरूको देश भएर डोर्‍याउनुभएन; यद्यपि त्यो छोटो थियो। किनकि परमेश्‍वरले भन्‍नुभयो, “तिनीहरूले युद्धको सामना गर्नुपर्‍यो भने तिनीहरूले आफ्ना मन परिवर्तन गरेर इजिप्टतिरै फर्कन सक्छन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","यसकारण परमेश्‍वरले मानिसहरूलाई घुमाएर लाल समुद्रतिर जाने उजाडस्थानको बाटोमा डोर्‍याउनुभयो। इस्राएलीहरू इजिप्टबाट लडाइँको लागि तयारी भएर निस्के। ");
INSERT INTO npioncb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशाले आफूसित योसेफको अस्थि लगे; किनकि योसेफले इस्राएलका छोराहरूलाई शपथ खान लाएका थिए। तिनले भनेका थिए, “परमेश्‍वर निश्‍चय नै तिमीहरूको सहायताका निम्ति आउनुहुनेछ, र तिमीहरूले मेरो अस्थि यस ठाउँबाट आफूसित लैजानुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","सुक्‍कोत छोडेपछि तिनीहरू उजाडस्थानको नजिकै एथाममा पाल टाँगेर बसे। ");
INSERT INTO npioncb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","तिनीहरू दिन र रात यात्रा गर्न सकून् भनेर दिउँसो याहवेह तिनीहरूलाई बाटोमा डोर्‍याउनलाई बादलको खामोमा र राति तिनीहरूलाई प्रकाश दिनलाई आगोको खामोमा तिनीहरूका अगि-अगि जानुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","न त दिउँसो बादलको खामोले, न त राति आगोको खामोले मानिसहरूका अगि-अगि जान कहिल्यै छोड्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलीहरूलाई पछि फर्केर मिग्दोल र समुद्रको बीचमा पी-हहीरोतको छेउमा पाल टाँगेर बस्‍नू भन्। तिनीहरू बाल-सेफोनको ठिक विपरीत समुद्रनिर डेरा हालेर बसून्। ");
INSERT INTO npioncb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","फारोले विचार गर्नेछ, ‘इस्राएलीहरू त उजाडस्थानमा थुनिएर अलमलमा परी देशमा भौँतारिरहेका छन्।’ ");
INSERT INTO npioncb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","अनि म फारोको हृदय कठोर पार्नेछु, र त्यसले तिनीहरूलाई खेद्नेछ। तर म फारो र त्यसका सेनाद्वारा आफ्नो महिमा लिनेछु, र इजिप्टियनहरूले म नै याहवेह हुँ भनी जान्‍नेछन्।” यसकारण इस्राएलीहरूले त्यसै गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","जब इजिप्टका राजालाई ती मानिसहरू भागे भनी बताइयो, फारो अनि तिनका अधिकारीहरूले तिनीहरूको विषयमा आफ्ना मन बदली गरे, र भने, “हामीले यो के गर्‍यौँ? हामीले इस्राएलीहरूलाई जान दिएर तिनीहरूको सेवा गुमायौँ!” ");
INSERT INTO npioncb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","यसकारण तिनले आफ्नो रथ तयार गराए, र आफ्नो सेना आफूसित लिए। ");
INSERT INTO npioncb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","तिनले आफ्ना उत्तम रथहरूमध्ये छ सय वटा लिए, र साथमा इजिप्टका अरू सबै रथहरूमाथि पदाधिकारीहरू सवार गराए। ");
INSERT INTO npioncb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","याहवेहले इजिप्टका राजा फारोको हृदय कठोर पारिदिनुभयो, र तिनले साहससित अगि बढिरहेका इस्राएलीहरूलाई खेदे। ");
INSERT INTO npioncb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","इजिप्टियनहरू—फारोका सबै घोडाहरू, रथहरू, घोडसवारहरू र सेनाले—इस्राएलीहरूलाई खेदे, र बाल-सेफोनको विपरीत पी-हहीरोतको नजिक समुद्रनिर डेरा हालेर बसेको बेलामा तिनीहरूलाई भेटे। ");
INSERT INTO npioncb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","फारो नजिक आइपुग्दा इस्राएलीहरूले आँखा उठाएर हेरे, र इजिप्टियनहरूलाई तिनीहरूको पछि आइरहेका देखे। तिनीहरू साह्रै डराए; अनि याहवेहलाई पुकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","तिनीहरूले मोशालाई भने, “के इजिप्टमा चिहानहरू थिएनन् र तपाईंले हामीलाई यस उजाडस्थानमा मर्न भनी ल्याउनुभयो? हामीलाई इजिप्टबाट यहाँ ल्याएर तपाईंले यो के गर्नुभएको? ");
INSERT INTO npioncb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","के हामीले इजिप्टमा तपाईंलाई ‘हामीलाई त्यसै छोडिदिनुहोस्; हामीलाई इजिप्टियनहरूको सेवा गर्न दिनुहोस्’ भनेका थिएनौँ र? यस उजाडस्थानमा मर्नुभन्दा त हामीलाई इजिप्टियनहरूको सेवा गर्नु असल हुनेथियो।” ");
INSERT INTO npioncb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशाले मानिसहरूलाई जवाफ दिए, “नडराओ, दृढतासाथ खडा रहो। आज याहवेहले तिमीहरूमा ल्याउनुहुने छुटकारा तिमीहरूले देख्नेछौ। तिमीहरूले आज देखेका इजिप्टियनहरूलाई फेरि कहिल्यै देख्नेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","याहवेहले तिमीहरूका पक्षमा युद्ध गर्नुहुनेछ; तिमीहरू केवल शान्त होऊ।” ");
INSERT INTO npioncb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब याहवेहले मोशालाई भन्‍नुभयो, “तिमीहरू किन मेरो पुकार गर्छौ? इस्राएलीहरूलाई अगि बढ्नू भन्। ");
INSERT INTO npioncb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","तेरो लहुरो उठा, र इस्राएलीहरू समुद्र भएर ओबानो जमिनबाट जाऊन् भनेर पानी दुई भाग गर्नलाई तेरो हात पसार्। ");
INSERT INTO npioncb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","म इजिप्टियनहरूको हृदय कठोर पारिदिनेछु, र तिनीहरू उनीहरूको पछि-पछि समुद्रभित्र जानेछन्। अनि म फारो र त्यसका सेनाद्वारा, त्यसका रथहरू र त्यसका घोडसवारहरूद्वारा महिमित हुनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","जब फारो, त्यसका रथहरू र त्यसका घोडसवारहरूद्वारा मेरो महिमा हुनेछ, तब इजिप्टियनहरूले म नै याहवेह हुँ भनी जान्‍नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","त्यसपछि इस्राएली सेनाको अगि-अगि यात्रा गरिरहेका परमेश्‍वरका स्वर्गदूत पछि सरेर तिनीहरूका पछिल्तिर गए। बादलको खामो पनि अगिल्तिरबाट सरेर तिनीहरूका पछिल्तिर उभियो; ");
INSERT INTO npioncb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","अनि इजिप्ट र इस्राएलीहरूका सेनाका बीचमा आयो। रातभरि त्यस बादलले एकातिर अँध्यारो र अर्कोतिर उज्यालो ल्यायो। यसकारण रातभरि एकपट्टिको मानिस अर्कोपट्टि गएन। ");
INSERT INTO npioncb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","तब मोशाले समुद्रमाथि आफ्ना हात पसारे; अनि याहवेहले रातभरि शक्तिशाली पूर्वीय बतास चलाएर समुद्रलाई पछिल्तिर ठेलिदिनुभयो, र त्यसलाई ओबानो जमिनमा परिणत गरिदिनुभयो। पानी दुई भाग भयो, ");
INSERT INTO npioncb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","अनि इस्राएलीहरू समुद्रबीच ओबानो जमिनबाट भएर गए; तिनीहरूका दाहिने र देब्रेतिर पानीको पर्खाल खडा भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ती इजिप्टियनहरूले तिनीहरूलाई खेदे, र फारोका सबै घोडाहरू, रथहरू र घोडसवारहरूले तिनीहरूलाई समुद्रमा पछ्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","मिरमिरे बिहानी याहवेहले आगो र बादलको खामोबाट इजिप्टका सेनालाई तल हेर्नुभयो र तिनीहरूलाई अलमल पारिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","उहाँले तिनीहरूका रथहरूका चक्‍काहरू फुस्काइदिनुभयो, र तिनीहरूलाई कुदाउन कठिन पर्‍यो। अनि इजिप्टियनहरूले भने, “हामी इस्राएलीहरूदेखि भागौँ! याहवेह तिनीहरूको पक्षमा भई हाम्रो विरुद्धमा युद्ध गर्दै हुनुहुन्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","तब याहवेहले मोशालाई भन्‍नुभयो, “पानी फेरि इजिप्टियनहरू, तिनीहरूका रथहरू र घोडसवारहरूमाथि पछिल्तिर फर्केर ओइरियोस् भनेर तेरो हात समुद्रमाथि पसार्।” ");
INSERT INTO npioncb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशाले आफ्ना हात समुद्रमाथि पसारे, र बिहान समुद्र फेरि आफ्नो ठाउँमा सर्‍यो। इजिप्टियनहरू यसको विपरीत भाग्दैथिए; अनि याहवेहले तिनीहरूलाई सोहोरेर समुद्रमा हालिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","पानी फर्केर आयो, र इस्राएलीहरूलाई समुद्रमा पछिबाट लखेट्ने रथहरू र घोडसवारहरू, फारोका सम्पूर्ण सेनालाई ढाकिदियो। तिनीहरूमध्ये एउटै पनि बाँचेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","तर इस्राएलीहरू त तिनीहरूका दाहिने र देब्रेतिर पानीका पर्खाल भएकाले समुद्रबाट ओबानो जमिन भएर गए। ");
INSERT INTO npioncb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","त्यस दिन याहवेहले इस्राएलीहरूलाई इजिप्टियनहरूको हातबाट बचाउनुभयो; अनि इस्राएलीहरूले इजिप्टियनहरूलाई किनारमा मरेर पस्रिरहेका देखे। ");
INSERT INTO npioncb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","जब याहवेहले इजिप्टियनहरूको विरुद्धमा महान् शक्ति देखाउनुभएको इस्राएलीहरूले देखे, तब मानिसहरू याहवेहसित डराए र आफ्नो भरोसा याहवेह र उहाँका सेवक मोशामाथि राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","तब मोशा र इस्राएलीहरूले याहवेहका निम्ति यो गीत गाए: “म याहवेहको निम्ति गाउनेछु; किनकि उहाँ अति नै उच्‍च पारिनुभएको छ। घोडा र त्यसको सवारलाई उहाँले समुद्रमा फालिदिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“याहवेह नै मेरो बल, सुरक्षा र गीत हुनुहुन्छ; उहाँ मेरा मुक्ति हुनुभएको छ। उहाँ मेरा परमेश्‍वर हुनुहुन्छ, र म उहाँको प्रशंसा गर्नेछु; मेरा पिताका परमेश्‍वर, र म उहाँको नामलाई उच्‍च पार्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","याहवेह योद्धा हुनुहुन्छ; उहाँको नाम याहवेह हो। ");
INSERT INTO npioncb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फारोका रथहरू र तिनका सेनालाई उहाँले समुद्रमा फालिदिनुभएको छ। फारोका सर्वोत्तम पदाधिकारीहरू लाल समुद्रमा डुबाइएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहिरा पानीले तिनीहरूलाई छोपिदिएका छन्; तिनीहरू ढुङ्गाझैँ गहिराइमा डुबेका छन्। ");
INSERT INTO npioncb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे याहवेह, तपाईंको दाहिने हात, शक्तिमा गौरवशाली थियो। हे याहवेह, तपाईंको दाहिने हातले, शत्रुलाई चकनाचुर पारेको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“तपाईंका गौरवको महानतामा तपाईंले विरोधीहरूलाई फ्याँकिदिनुभएको छ। तपाईंले आफ्नो क्रोधको ज्वाला पोख्नुभयो; जसले तिनीहरूलाई परालझैँ भस्म पार्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तपाईंका नाकको सासको वेगले पानी एक ठाउँमा थुप्रो लाग्यो, तरङ्गले भरिएका पानीहरू दृढ पर्खालझैँ खडा भए; गहिरो पानी समुद्रको गहिराइमा जमिहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्रुले घमण्ड गर्‍यो, ‘म तिनीहरूलाई खेद्नेछु, म तिनीहरूलाई भेट्नेछु। म लुटिएका सामानहरू बाँड्नेछु; म तिनीहरूलाई निल्नेछु। म आफ्नो तरवार थुत्नेछु, र मेरो हातले तिनीहरूलाई नाश पार्नेछु।’ ");
INSERT INTO npioncb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तर तपाईंले आफ्नो सास फुक्नुभयो; र समुद्रले तिनीहरूलाई ढाकिहाल्यो। तिनीहरू शक्तिशाली पानीमा सिसाझैँ डुबे। ");
INSERT INTO npioncb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे याहवेह, देवी-देवताहरूमा तपाईंजस्तो को छ र? पवित्रतामा अति गौरवशाली, महिमामा भययोग्य, र अद्‌भुत कार्यहरू गर्नुहुने अरू को छ र? ");
INSERT INTO npioncb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“तपाईंले आफ्नो दाहिने हात पसार्नुभयो; अनि पृथ्वीले हाम्रा शत्रुहरूलाई निलिहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तपाईंले आफ्नो अचुक प्रेममा, आफूले छुटाउनुभएका मानिसहरूलाई डोर्‍याउनुहुनेछ। तपाईंको शक्तिमा तपाईंले तिनीहरूलाई आफ्नो पवित्र वासस्थानमा अगुवाइ गर्नुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","जातिहरूले सुन्‍नेछन् र काँप्नेछन्; पलिश्तीहरूलाई वेदनाले पक्रनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोमका अगुवाहरू भयभीत हुनेछन्; मोआबका शक्तिशाली अगुवाहरू काँप्नेछन्; कनानका सारा मानिसहरू बिलाइजानेछन्; ");
INSERT INTO npioncb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","उनीहरूलाई आतङ्क र डरले छोप्नेछ। हे याहवेह, तपाईंका प्रजा पार नहोउन्जेल, तपाईंले किन्‍नुभएका यी प्रजा पार नहोउन्जेल— तपाईंका पाखुराको शक्तिले उनीहरू पत्थरझैँ अचल हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","तपाईंले तिनीहरूलाई भित्र ल्याउनुहुनेछ र तपाईंको आफ्नो उत्तराधिकारको पर्वतमा रोप्नुहुनेछ— हे याहवेह, त्यो ठाउँ, जसलाई तपाईंले आफ्नो लागि वासस्थान बनाउनुभएको छ; त्यो समागम पालमा, हे प्रभु, जसलाई तपाईंका हातहरूले स्थापित गर्नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“याहवेहले सदासर्वदा राज्य गर्नुहुन्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","जब फारोका घोडा, रथ र घोडसवारहरू समुद्रभित्र पसे, तब याहवेहले समुद्रको पानी फर्काएर तिनीहरूमाथि ल्याइदिनुभयो; तर इस्राएलीहरू त समुद्रको बीचबाट ओबानो जमिनमाथि हिँडे। ");
INSERT INTO npioncb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","तब हारूनकी दिदी अगमवादिनी मिरियमले आफ्नो हातमा एउटा खैँजडी लिइन्; अनि अरू स्त्रीहरू पनि खैँजडी लिएर नाच्दै तिनको पछि-पछि लागे। ");
INSERT INTO npioncb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरियमले यसरी गीत गाउन थालिन्: “याहवेहका निम्ति गाओ; किनकि उहाँ अति उच्‍च पारिनुभएको छ। घोडा र त्यसको सवार दुवैलाई उहाँले समुद्रमा फालिदिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","तब मोशाले इस्राएललाई लाल समुद्रबाट लगे, र तिनीहरू शूरको उजाडस्‍थानभित्र पसे। तीन दिनसम्म तिनीहरू उजाडस्थानमा पिउने पानीविना यात्रा गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","जब तिनीहरू मारा आइपुगे, तिनीहरूले त्यहाँको पानी पिउन सकेनन्; किनकि त्यो तितो थियो। (त्यसैकारण त्यस ठाउँलाई मारा भनिन्छ।) ");
INSERT INTO npioncb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","यसकारण मानिसहरू मोशाको विरुद्धमा यसो भन्दै गनगन गर्न थाले, “हामीले के पिऔँ?” ");
INSERT INTO npioncb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","तब मोशाले याहवेहलाई पुकारे; अनि याहवेहले तिनलाई एउटा काठको टुक्रा देखाउनुभयो। जब तिनले त्यसलाई पानीमा फाले, तब त्यो पानी मिठो भयो। त्यहाँ याहवेहले तिनीहरूका निम्ति एउटा नियम र निर्देशन बनाउनुभयो; अनि त्यहीँ नै उहाँले तिनीहरूको जाँच लिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","उहाँले भन्‍नुभयो, “तिमीहरूले याहवेह तिमीहरूका परमेश्‍वरको कुरा ध्यानसित सुन्यौँ र उहाँको दृष्‍टिमा जे ठिक छ, त्यही गर्‍यौ, र तिमीहरूले उहाँका आज्ञाहरूमा ध्यान दियौ, र उहाँका सबै उर्दीहरू पालन गर्‍यौ भने मैले इजिप्टियनहरूमाथि ल्याएका रोगहरू म तिमीहरूमाथि ल्याउनेछैनँ; किनकि तिमीहरूलाई निको पार्ने याहवेह म नै हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","त्यसपछि तिनीहरू एलीममा आइपुगे, जहाँ बाह्र वटा पानीका मूल र सत्तरी वटा खजूरका रूखहरू थिए। तिनीहरूले त्यहीँ पानीको नजिक पाल टाँगे। ");
INSERT INTO npioncb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","इस्राएलीहरूका सारा समुदाय एलीमबाट हिँडे, र सीनैको उजाडस्थानमा आइपुगे। यो एलीम र सीनैको बीचमा थियो। तिनीहरू इजिप्टबाट निस्केर आएको दोस्रो महिनाको पन्ध्रौँ दिन भइसकेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","त्यस उजाडस्थानमा सारा इस्राएलीहरू मोशा र हारूनको विरुद्धमा गनगनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इस्राएलीहरूले तिनीहरूलाई भने, “हामी इजिप्टमै याहवेहका हातद्वारा मरेका भए असल हुनेथियो! त्यस ठाउँमा छँदा हामी मासुका भाँडाको वरिपरि बस्थ्यौँ, र हामीले अघाउन्जेल भोजन खान्थ्यौँ; तर तपाईंले हामीलाई निकालेर यस उजाडस्थानमा यो सारा समुदायलाई भोकभोकै मार्न ल्याउनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","तब याहवेहले मोशालाई भन्‍नुभयो, “म तिमीहरूका लागि स्वर्गबाट रोटी बर्साउनेछु। यी मानिसहरू हरेक दिन बाहिर जाऊन्, र त्यस दिनको भाग बटुलून्; ताकि तिनीहरूले मेरा आज्ञाहरू मान्छन् कि मान्दैनन् भनी म तिनीहरूलाई जाँच्न सकूँ। ");
INSERT INTO npioncb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","छैटौँ दिनमा तिनीहरूले जे भित्र ल्याउनेछन्, त्यसलाई तयार पारून्; र त्यो अरू दिन बटुलेको भन्दा दोबर होस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","यसकारण मोशा र हारूनले सारा इस्राएलीहरूलाई भने, “याहवेहले नै तिमीहरूलाई इजिप्टबाट निकालेर ल्याउनुभएको हो भनी तिमीहरूले बेलुकीपख जान्‍नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","अनि बिहान तिमीहरूले याहवेहको महिमा देख्नेछौ; किनकि तिमीहरूले उहाँको विरुद्धमा गनगनाएको उहाँले सुन्‍नुभएको छ। हामी को हौँ, र तिमीहरू हाम्रो विरुद्धमा गनगनाउँछौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मोशाले यो पनि भने, “जब याहवेहले तिमीहरूलाई बेलुकी खानलाई मासु र बिहानीपख चाहेजति रोटी दिनुहुनेछ, तब त्यसलाई दिनुहुने याहवेह नै हुनुहुन्छ भनी तिमीहरूले जान्‍नेछौ; किनकि तिमीहरूले उहाँको विरुद्धमा गनगनाएको उहाँले सुन्‍नुभएको छ। हामी को हौँ र? तिमीहरू हाम्रो विरुद्धमा होइन, तर परमेश्‍वरको विरुद्धमा गनगनाइरहेका छौ।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","तब मोशाले हारूनलाई भने, “इस्राएलका सारा समुदायलाई भन्‍नुहोस्, ‘याहवेहको सामु आओ; किनकि उहाँले तिमीहरूको गनगन सुन्‍नुभएको छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","हारून सारा इस्राएली समुदायसित बोल्दैगर्दा तिनीहरूले उजाडस्थानतिर हेरे; अनि त्यहाँ याहवेहको महिमा बादलमा देखा पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैले इस्राएलीहरूको गनगन सुनेको छु। तिनीहरूलाई भन्, ‘बेलुकी तिमीहरूले मासु खानेछौ र बिहानचाहिँ तिमीहरू रोटीले अघाउनेछौ। तब म नै याहवेह तिमीहरूका परमेश्‍वर हुँ भनी तिमीहरूले जान्‍नेछौ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","त्यस बेलुकी बट्टाई चराहरू आएर छाउनी नै ढाकिदिए; अनि बिहानचाहिँ छाउनीका चारैतिर शीत पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","शीत सुकेपछि उजाडस्थानभरि मसिना डल्‍लाहरू, तुसारोजस्ता चीजहरू देखा परे। ");
INSERT INTO npioncb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","जब इस्राएलीहरूले त्यो देखे, तब तिनीहरूले आपसमा भने, “यो के हो?” किनकि त्यो के थियो, तिनीहरूलाई थाहा थिएन। अनि मोशाले तिनीहरूलाई भने, “यो याहवेहले तिमीहरूलाई खान भनी दिनुभएको रोटी हो। ");
INSERT INTO npioncb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","याहवेहले यसो भनी आज्ञा दिनुभएको छ: ‘हरेकले आफूलाई चाहिए जति बटुल्नू। तिमीहरूसित पालभित्र भएका हरेक व्यक्तिको निम्ति एक ओमेर लिनू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","मोशाले भनेझैँ इस्राएलीहरूले गरे; अनि कतिले धेरै, कतिले थोरै बटुले। ");
INSERT INTO npioncb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","जब तिनीहरूले त्यसलाई ओमेरले नापे, तब धेरै बटुल्नेको ज्यादा भएन, र थोरै बटुल्नेको पनि कम्ती भएन। तिनीहरू हरेकले आफूलाई जति चाहिन्छ, त्यति नै बटुले। ");
INSERT INTO npioncb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मोशाले तिनीहरूलाई भने, “कसैले पनि यसबाट बाँकी भाग बिहानसम्म नराख्नू।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तैपनि कसै-कसैले मोशाको कुरामा ध्यान दिएनन्; र त्यसबाट केही भाग बिहानसम्म राखे। तर त्यसमा किरा पर्‍यो, र गनाउन थाल्यो। यसकारण मोशा तिनीहरूसित क्रोधित भए। ");
INSERT INTO npioncb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","प्रत्येक बिहान हरेकले आफूलाई चाहिने जति बटुल्थे; अनि घाम छिप्पिएपछि त्यो पग्लिहाल्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","छैटौँ दिनमा भने तिनीहरूले दोबर अर्थात् हरेकका लागि दुई ओमेर बटुले; अनि समुदायका अगुवाहरूले यो कुरा मोशालाई बताइदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","तब तिनले उनीहरूलाई भने, “याहवेहले यसो भनी आज्ञा गर्नुभएको छ: ‘भोलि शब्बाथ दिन, याहवेहका निम्ति समर्पित पवित्र शब्बाथ दिन हो। तिमीहरू जे पकाउन चाहन्छौ, त्यो पकाओ; अनि जे उमाल्न चाहन्छौ, उमाल; अनि जे उब्रिन्छ, त्यो बिहानसम्म राखिछोड।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","यसकारण मोशाले भनेझैँ तिनीहरूले त्यसलाई बिहानसम्म राखे; त्यसमा गन्ध आएन, र त्यसमा किरा पनि परेन। ");
INSERT INTO npioncb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","तब मोशाले भने, “त्यो खानेकुरा आज खाओ; किनकि आज याहवेहका निम्ति समर्पित शब्बाथ दिन हो। तिमीहरूले आज जमिनमा त्यसको केही भाग पनि पाउनेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","छ दिन तिमीहरूले त्यसलाई बटुल्नू, तर सातौँ दिन, अर्थात् शब्बाथ दिनमा चाहिँ केही पनि हुनेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","तैपनि केही मानिसहरू ती बटुल्नलाई सातौँ दिनमा बाहिर गए, तर तिनीहरूले केही भेटेनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब याहवेहले मोशालाई भन्‍नुभयो, “कहिलेसम्म तिमीहरू मेरा आज्ञा र अर्तीहरू पालन गर्न अस्वीकार गर्छौ? ");
INSERT INTO npioncb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","यो कुरा मनमा राख: याहवेहले तिमीहरूका निम्ति शब्बाथ दिन दिनुभएको छ; यसैकारण छैटौँ दिनमा उहाँले तिमीहरूलाई दुई दिनका लागि रोटी दिनुभएको छ। सातौँ दिन तिमीहरू हरेक आ-आफ्नै ठाउँमा बस्‍नू; कोही बाहिर नजानू।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","यसकारण मानिसहरूले सातौँ दिनमा विश्राम गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","अनि इस्राएलका मानिसहरूले त्यस रोटीलाई मन्‍न भनी भने। त्यो धनियाँको बिउजस्तो सेतो देखिन्थ्यो; अनि स्वादचाहिँ मह मिसाएर बनाएको बाबरजस्तो थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशाले भने, “याहवेहले यसो भनी आज्ञा दिनुभएको छ: ‘मैले तिमीहरूलाई इजिप्टबाट निकालेर ल्याउँदा उजाडस्थानमा तिमीहरूलाई कस्तो रोटी खुवाएको थिएँ भनेर पछिका पुस्ताहरूलाई देखाउन भनी एक ओमेर मन्‍न जोगाएर राख्नू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","यसकारण मोशाले हारूनलाई भने, “एउटा भाँडो लिएर त्यसमा एक ओमेर मन्‍न भर्नुहोस्, र त्यसलाई पछि आउने पुस्तौँ-पुस्तासम्म रहोस् भनेर याहवेहको सामु राख्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ, हारूनले त्यस मन्‍नलाई जोगाएर राख्न भनी करारको सन्दुकको सामु राखिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएलीहरूले चालीस वर्षसम्म मन्‍न खाए; तिनीहरू कनान देशसम्म पुगेर बसोबास नगरुन्जेल मन्‍न खाइरहे। ");
INSERT INTO npioncb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(एक ओमेर भनेको एपाको दशौँ भाग हो।) ");
INSERT INTO npioncb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","इस्राएलीहरूका सारा समुदाय याहवेहले आज्ञा गर्नुभएझैँ एक ठाउँदेखि अर्को ठाउँ यात्रा गर्दै जानलाई सीनको उजाडस्थानबाट निस्के। तिनीहरूले रेफिदीममा पाल टाँगे; तर त्यहाँ मानिसहरूका निम्ति पिउनलाई पानी थिएन। ");
INSERT INTO npioncb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","यसकारण तिनीहरूले मोशासित झगडा गरेर भने, “हामीलाई पिउने पानी दिनुहोस्।” मोशाले जवाफ दिए, “तिमीहरू किन मसित झगडा गर्छौ? तिमीहरू किन याहवेहलाई परीक्षा गर्छौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","तर ती मानिसहरू असाध्यै तिर्खाएका थिए; अनि तिनीहरू मोशाको विरुद्धमा गनगनाए। तिनीहरूले भने, “हामी, हाम्रा छोराछोरी र गाईबस्तुहरूलाई तिर्खाले मार्न भनी तपाईंले इजिप्टबाट निकालेर यस डरलाग्दो ठाउँमा किन ल्याउनुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","तब मोशाले याहवेहलाई पुकार गरे, “म यी मानिसहरूलाई के गरूँ? तिनीहरूले मलाई ढुङ्गाले हान्‍नै आँटेका छन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","याहवेहले मोशालाई जवाफ दिनुभयो, “इस्राएलका केही प्रधानहरूलाई साथमा लिएर मानिसहरूका अगि-अगि जा, र जुन लहुरोले तैँले नील नदीलाई हिर्काएको थिइस्, त्यो पनि आफ्नो हातमा लिएर जा। ");
INSERT INTO npioncb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","अनि म होरेबमा भएको चट्टानको छेवैमा तेरो सामु उभिनेछु। तैँले त्यस चट्टानलाई हिर्काऊनू, र त्यसबाट पानीको मूल फुट्नेछ, र मानिसहरूले पिउन सक्नेछन्।” यसकारण मोशाले इस्राएलका प्रधानहरूका आँखाको सामु त्यसै गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","“याहवेह हाम्रा बीचमा हुनुहुन्छ कि हुनुहुन्‍न” भन्‍ने इस्राएलीहरूका झगडाको कारण र तिनीहरूले याहवेहको परीक्षा गरेको कारण त्यस ठाउँको नाम तिनले मस्सा र मेरीबा राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","अमालेकीहरूले आएर रेफिदीममा इस्राएलीहरूमाथि आक्रमण गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","अनि मोशाले यहोशूलाई भने, “हाम्रा मानिसहरूमध्ये केही मानिसलाई चुन र अमालेकीहरूसित लडाइँ गर। भोलि म परमेश्‍वरको लहुरो हातमा लिएर पहाडको टाकुरामा उभिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","यसकारण मोशाले आदेश गरेझैँ यहोशूले अमालेकीहरूसित युद्ध गरे; मोशा, हारून र हूरचाहिँ पहाडको टाकुरामा गए। ");
INSERT INTO npioncb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","मोशाले आफ्ना हातहरू उचालिराख्दा इस्राएलीहरूले जित्थे, तर जब तिनले आफ्ना हातहरू तल झार्थे, तब अमालेकीहरूले जित्थे। ");
INSERT INTO npioncb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","जब मोशाका हातहरू थाके, तब तिनीहरूले एउटा ढुङ्गा लिएर त्यसलाई तिनको मुनि राखिदिए, र तिनी त्यसमाथि बसे। हारून र हूरले सूर्यास्तसम्म तिनका हातहरू स्थिर भइरहून् भनेर एउटाले एकापट्टि र अर्काले अर्र्कापट्टि तिनका हातहरू थामिराखे। ");
INSERT INTO npioncb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","यसरी यहोशूले तरवारद्वारा अमालेकीहरूका सेनालाई पराजित गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब याहवेहले मोशालाई भन्‍नुभयो, “यसलाई सम्झनाका निम्ति एउटा पुस्तकमा लेखिराख्, र यो कुरा यहोशूलाई सुनाइदे; किनकि म अमालेकीहरूको सम्झना धर्तीबाट पूर्ण रूपमा मेटिदिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मोशाले एउटा वेदी बनाए, र त्यसलाई याहवेह निस्सी भने। ");
INSERT INTO npioncb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","तिनले भने, “याहवेहको सिंहासनतिर हातहरू उचालिएकाले याहवेहले पुस्तौँ-पुस्तासम्म अमालेकीहरूका विरुद्धमा लडाइँ गर्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मिद्यानका पुजारी, मोशाका ससुरा यित्रोले मोशा र आफ्नो प्रजा इस्राएलका निम्ति परमेश्‍वरले गर्नुभएका सबै कुरा, र याहवेहले इस्राएलीहरूलाई इजिप्टबाट कसरी बाहिर निकालेर ल्याउनुभएको कुरा सुने। ");
INSERT INTO npioncb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशाले आफ्नी पत्नी सिप्पोरालाई माइत पठाएपछि यित्रोले आफ्नी छोरी सिप्पोरा, ");
INSERT INTO npioncb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","र तिनका दुई जना छोरालाई लिए। मोशाले एउटा छोराको नाम गेर्शोम राखेका थिए; किनकि तिनले “म परदेशमा प्रवासी भएको छु” भनेका थिए; ");
INSERT INTO npioncb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अनि अर्कोचाहिँको नाम एलीएजर राखिएको थियो; किनकि तिनले भने, “मेरा पिताका परमेश्‍वर मेरो सहायक हुनुहुन्छ; उहाँले मलाई फारोको तरवारबाट बचाउनुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मोशाका ससुरा यित्रो तिनका दुई जना छोरा र तिनकी पत्नीसँग उजाडस्थानमा मोशाकहाँ आए, जहाँ तिनले परमेश्‍वरको पर्वत नजिक पाल टाँगेर बसेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","यित्रोले मोशाकहाँ “म, तिम्रो ससुरा यित्रो, तिम्री पत्नी र तिम्रा दुई छोरासित तिमीकहाँ आउँदैछौँ” भनेर खबर पठाएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","यसकारण मोशा आफ्ना ससुरालाई भेट्न बाहिर निस्के, र तिनलाई भेटेर दण्डवत् गरे; अनि म्वाइँ खाए। तिनीहरू एक-अर्कालाई हालखबर सोधेर पालभित्र गए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","इस्राएलीहरूका निम्ति याहवेहले फारो र इजिप्टियनहरूलाई जे-जे गर्नुभएको थियो, ती सबै कुराहरू, साथै बाटोमा तिनीहरूमाथि के कस्ता कष्‍टहरू आइपरेका थिए, र याहवेहले तिनीहरूलाई कसरी छुटाउनुभएको थियो, ती सबै मोशाले आफ्ना ससुरोलाई बताए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","याहवेहले इस्राएलीहरूलाई इजिप्टियनहरूका हातबाट छुटाउन तिनीहरूका निम्ति कस्ता-कस्ता असल कुराहरू गर्नुभएको थियो, ती सुनेर यित्रो खुशी भए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","अनि यित्रोले भने, “याहवेहको प्रशंसा होस्, जसले तिमीहरूलाई इजिप्टियनहरू र फारोका हातबाट छुटाउनुभयो, जसले मानिसहरूलाई इजिप्टियनहरूका हातबाट छुटाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब मलाई थाहा भयो कि याहवेह अरू सबै देवी-देवताहरूभन्दा महान् हुनुहुन्छ; किनकि उहाँले इस्राएलीहरूसित अभिमानी व्यवहार गर्नेलाई यस्तो व्यवहार गर्नुभयो।” ");
INSERT INTO npioncb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब मोशाका ससुरा यित्रोले याहवेहका निम्ति होमबलि र अरू बलिदानहरू ल्याए; अनि हारून र इस्राएलका सबै प्रधानहरू परमेश्‍वरको सामु मोशाका ससुरासित रोटी खान आए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","भोलिपल्ट मोशा मानिसहरूको न्याय गर्नलाई बसे; अनि बिहानदेखि बेलुकासम्म मानिसहरू मोशाको वरिपरि उभिरहे। ");
INSERT INTO npioncb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मोशाले मानिसहरूका लागि गरिरहेका सबै काम देखेपछि तिनका ससुराले भने, “तिमीले मानिसहरूका लागि यो के गरिरहेका छौ? यी मानिसहरू बिहानदेखि बेलुकीसम्म तिम्रो वरिपरि उभिरहन्छन्, तिमी एकलै मात्र किन न्यायकर्ता भएर बसिरहन्छौ?” ");
INSERT INTO npioncb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशाले आफ्ना ससुरालाई भने, “किनकि मानिसहरू परमेश्‍वरको इच्छा खोज्न मकहाँ आउँछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","जब तिनीहरूको बीचमा विवाद हुन्छ, तब त्यसलाई मकहाँ ल्याउँछन्, र मैले दुवै पक्षका बीचमा निर्णय गरेर तिनीहरूलाई परमेश्‍वरको उर्दी र उहाँका व्यवस्थाहरू बताइदिन्छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मोशाका ससुराले तिनलाई भने, “तिमीले जे गर्दैछौ, त्यो ठिक छैन। ");
INSERT INTO npioncb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","पक्‍कै पनि तिमी र तिमीसित हुने यी मानिसहरू एकदम थाक्नेछौ; यो काम तिम्रो निम्ति अति गाह्रो छ; र तिमी एकलैले यो गर्न सक्दैनौ। ");
INSERT INTO npioncb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","अब मेरो कुरा सुन, र म तिमीलाई केही सल्‍लाह दिनेछु, र परमेश्‍वर तिमीसित रहून्। तिमी परमेश्‍वरको सामु मानिसहरूका प्रतिनिधि भएर तिनीहरूका विवादहरू उहाँकहाँ लैजाऊ। ");
INSERT INTO npioncb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तिनीहरूलाई उर्दी र व्यवस्थाहरू सिकाऊ, र तिनीहरूलाई जिउने तरिका र पालना गर्नुपर्ने कर्तव्य देखाइदेऊ। ");
INSERT INTO npioncb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","यसकासाथै यस्ता मानिसहरूलाई चुन, जो सबै मानिसहरूमध्येबाट सक्षम अर्थात् परमेश्‍वरको डर मान्‍ने विश्‍वासयोग्य मानिसहरू जसले बेइमानीसित लाभ लिन घृणा गर्छन्। तिनीहरूलाई हजार-हजार, सय-सय, पचास-पचास र दश-दश जनामाथि अगुवा नियुक्त गर। ");
INSERT INTO npioncb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","हरेक समय मानिसहरूमाथि तिनीहरूले न्यायकर्ता भएर सेवा गरून्; तर तिनीहरूले हरेक गाह्रो मुद्दाचाहिँ तिम्रो सामु ल्याऊन्; साना-साना मुद्दाहरूको निर्णयचाहिँ तिनीहरूले नै गरून्। यसो गर्दा तिम्रो भार हलुका हुनेछ, र तिनीहरूले तिमीसित भार उठाउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","तिमीले यसो गर्‍यौ भने, र परमेश्‍वरले यस्तै आज्ञा दिनुभयो भने तिम्रो भार हलुका हुनेछ, र यी मानिसहरू शान्तिसाथ आफ्नो घरमा फर्कनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मोशाले आफ्ना ससुराको कुरा सुने, र तिनले भनेका हरेक कुरा गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","तब मोशाले इस्राएलबाट सक्षम मानिसहरूलाई चुने, र तिनीहरूलाई मानिसहरूमाथि अगुवा अर्थात् हजार-हजार, सय-सय, दश-दश जनामाथि अधिकारीहरू तुल्याइदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","तिनीहरूले हर समय मानिसहरूमाथि न्यायकर्ताको रूपमा सेवा गर्थे। कठिन मुद्दाहरू तिनीहरूले मोशाकहाँ ल्याउँथे, तर हरेक स-साना मुद्दाहरूको फैसला तिनीहरू आफूले नै गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","तब मोशाले आफ्ना ससुरालाई बिदा गरे; अनि यित्रो आफ्नो देशको बाटो लागे। ");
INSERT INTO npioncb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएलीहरूले इजिप्ट छोडेको तेस्रो महिनाको पहिलो दिन, त्यही दिन तिनीहरू सीनैको उजाडस्थानमा आइपुगे। ");
INSERT INTO npioncb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","इस्राएलीहरू रेफिदीमबाट हिँडेपछि सीनैको उजाडस्थानमा प्रवेश गरे, र तिनीहरूले त्यही पर्वतको सामु उजाडस्थानमा पाल टाँगेर बसे। ");
INSERT INTO npioncb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तब मोशा माथि डाँडामा परमेश्‍वरलाई भेट्न गए; अनि याहवेहले पर्वतबाट तिनलाई भन्‍नुभयो, “तैँले याकोबको घरानालाई भन्‍नुपर्ने र इस्राएलका मानिसहरूलाई बताउनुपर्ने यही हो: ");
INSERT INTO npioncb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘मैले इजिप्टलाई के गरेँ, मैले कसरी तिमीहरूलाई गरुडहरूझैँ पखेटामा उडाएर मकहाँ ल्याएँ, त्यो तिमीहरूले देखेका छौ। ");
INSERT INTO npioncb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","अब यदि तिमीहरूले मैले भनेको कुरा सुन्यौ, र मेरा करारहरू पूर्ण पालन गर्‍यौ भने सबै जातिमध्ये तिमीहरू मेरा निज धन हुनेछौ। सारा पृथ्वी मेरै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तिमीहरू मेरा निम्ति पुजारीहरूको एउटा राज्य र एउटा पवित्र जाति हुनेछौ।’ तैँले इस्राएलीहरूलाई भन्‍नुपर्ने कुराहरू यिनै हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मोशा फर्किएर मानिसहरूका प्रधानहरूलाई बोलाइपठाए, र याहवेहले तिनलाई आज्ञा गर्नुभएका सबै कुराहरू तिनीहरूका सामु राखिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ती सबै मानिसहरूले एकसाथ जवाफ दिए, “याहवेहले भन्‍नुभएका सबै कुराहरू हामी गर्नेछौँ।” यसकारण मोशाले तिनीहरूका जवाफ याहवेहकहाँ आएर सुनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","याहवेहले मोशालाई भन्‍नुभयो, “म बाक्लो बादलमा तँकहाँ आउनेछु; मानिसहरूले म तँसित कुरा गरेको सुनून्, र तिनीहरूले सधैँ आफ्ना भरोसा तँमाथि राखून्।” तब मोशाले याहवेहलाई मानिसहरूले भनेका कुरा भनिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","याहवेहले मोशालाई भन्‍नुभयो, “मानिसहरूकहाँ गएर तिनीहरूलाई आज र भोलि शुद्ध पार्। तिनीहरूले आफ्ना वस्त्र धोऊन्, ");
INSERT INTO npioncb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","अनि तेस्रो दिनको लागि तिनीहरू तयार रहून्; किनकि त्यस दिन याहवेह सबै मानिसहरूका आँखाका सामु सीनै पर्वतमाथि ओर्लिआउनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","पर्वतको चारैतिर मानिसहरूका लागि सिमाना लगाएर तिनीहरूलाई यसो भन्‍नू, ‘होशियार रहो, पर्वतमाथि नचढ्नू र त्यसको फेद पनि नछुनू। जसले यस पर्वतलाई छुन्छ, त्यो निश्‍चय मारिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","त्यसलाई कसैले पनि नछुनू। तर त्यसलाई ढुङ्गाले हानेर अथवा काँडले छेडेर मार्नू। मानिस होस् वा पशु, त्यो जीवित रहनेछैन।’ केवल तुरही फुकेको आवाज सुनेपछि मात्र तिनीहरू पर्वतको नजिक जाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मोशा पर्वतबाट तल मानिसहरूकहाँ ओर्लेर आएपछि तिनले उनीहरूलाई शुद्ध पारे; अनि तिनीहरूले आफ्ना वस्त्रहरू धोए। ");
INSERT INTO npioncb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","तब तिनले मानिसहरूलाई भने, “आफूलाई तेस्रो दिनको लागि तयार पार्नू। यौन सम्बन्धबाट अलग रहनू।” ");
INSERT INTO npioncb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तेस्रो दिनको बिहान गर्जन भयो, बिजुली चम्क्यो र पर्वतमा बाक्लो बादल देखियो; अनि अति चर्को आवाजले तुरही बजेको आवाज सुनियो। छाउनीमा भएका हरेक व्यक्ति थरथर कामे। ");
INSERT INTO npioncb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मोशाले मानिसहरूलाई परमेश्‍वरसित भेट्न छाउनीबाहिर निकालेर ल्याए; अनि तिनीहरू पर्वतको फेदमा उभिए। ");
INSERT INTO npioncb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीनै पर्वत धुवैँधुवाँले भरिएको थियो; किनकि याहवेह त्यहाँ आगोमा भई ओर्लनुभएको थियो। त्यहाँ इँटाभट्टाको धुवाँझैँ मुस्लो उठिरहेको थियो; अनि सम्पूर्ण पर्वत जोडसित काम्यो, ");
INSERT INTO npioncb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","र तुरहीको आवाज झन्-झन् चर्को हुँदैगयो। तब मोशा बोले, र परमेश्‍वरको आवाजले तिनलाई जवाफ दियो। ");
INSERT INTO npioncb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","याहवेह सीनै पर्वतको टाकुरामा ओर्लनुभयो; र मोशालाई पर्वतको टाकुरामा बोलाउनुभयो। यसकारण मोशा माथि गए, ");
INSERT INTO npioncb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","अनि याहवेहले मोशालाई भन्‍नुभयो, “तल गएर मानिसहरूलाई चेतावनी दे, र याहवेहलाई हेर्न भनी तिनीहरू जबरजस्ती नआऊन्, र तिनीहरूमध्ये धेरै नमरून्। ");
INSERT INTO npioncb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","याहवेहको नजिकमा आउने पुजारीहरू समेतले आफूलाई शुद्ध पारून्, नत्रता याहवेहले तिनीहरूलाई नाश गर्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशाले याहवेहलाई भने, “मानिसहरू सीनै पर्वतमाथि आउन सक्दैनन्; किनकि तपाईंले हामीलाई ‘पर्वतका चारैतिर सिमाना लगाएर त्यसलाई पवित्र गरी अलग गर्नू’ भनी चेतावनी दिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","याहवेहले जवाफ दिनुभयो, “तल गएर हारूनलाई तँसित माथि लिएर आइज; तर पुजारीहरू र मानिसहरू याहवेहकहाँ जबरजस्ती गरेर नआऊन्; नत्रता उहाँले तिनीहरूलाई नाश गर्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","यसकारण मोशा तल मानिसहरूकहाँ ओर्लेर गए, र तिनीहरूलाई यी कुरा भनिदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","परमेश्‍वरले यी कुराहरू भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“म नै याहवेह, तेरा परमेश्‍वर हुँ; जसले तँलाई इजिप्टबाट, दासत्वको देशबाट निकालेर ल्याएँ। ");
INSERT INTO npioncb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“मबाहेक तैँले अरू कुनै देवी-देवताहरू नमान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","आफ्ना निम्ति खोपेर माथि आकाशको, तल पृथ्वीको, र पानी मुनिको कुनै पनि वस्तुको कुनै मूर्ति नबनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","तिनीहरूका सामु ननिहुरनू अथवा तिनीहरूको आराधना नगर्नू; किनकि म, याहवेह तेरा परमेश्‍वर, डाह गर्ने परमेश्‍वर हुँ; मलाई घृणा गर्नेहरूका पापको दण्ड तिनीहरूका छोराछोरीका तेस्रो र चौथो पुस्तामाथि दिन्छु; ");
INSERT INTO npioncb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","तर मलाई प्रेम गर्ने र मेरा आज्ञाहरू पालन गर्नेका हजारौँ पुस्तामाथि प्रेम देखाउँछु। ");
INSERT INTO npioncb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","तैँले याहवेह, आफ्ना परमेश्‍वरको नामको गलत प्रयोग नगर्नू; किनकि उहाँको नाम व्यर्थैमा लिनेलाई याहवेहले निर्दोष ठहराउनुहुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","शब्बाथ दिनलाई पवित्र दिनको रूपमा राखेर त्यसको सम्झना गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","छ दिनसम्म तैँले परिश्रम गरेर आफ्ना सबै काम गर्नू; ");
INSERT INTO npioncb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","तर सातौँ दिन याहवेह तेरा परमेश्‍वरका निम्ति शब्बाथ दिन हो। यस दिन तैँले केही काम नगर्नू; न त तैँले, न तेरा छोरा वा छोरीले, न तेरा सेवक वा सेविकाले, न तेरा पशुहरूले, न तेरा सहरभित्र भएका परदेशीले, न त कसैले केही काम गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","किनकि छ दिनमा याहवेहले आकाश, पृथ्वी, समुद्र र त्यसमा भएका सबै थोकहरू बनाउनुभयो, तर सातौँ दिनमा उहाँले विश्राम लिनुभयो। यसकारण याहवेहले शब्बाथ दिनलाई आशिष् दिनुभयो, र त्यसलाई पवित्र तुल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","तैँले आफ्ना बुबा र आफ्नी आमालाई आदर गर्नू, ताकि याहवेह तेरा परमेश्‍वरले तँलाई दिनुहुने देशमा तेरो आयु लामो होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","तैँले मानव हत्या नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","तैँले व्यभिचार नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","तैँले चोरी नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","तैँले आफ्नो छिमेकीको विरुद्धमा झूटो साक्षी नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","तैँले तेरा छिमेकीको घरको लालच नगर्नू। तैँले आफ्नो छिमेकीको पत्नीको लालच नगर्नू, अथवा आफ्नो छिमेकीको सेवक वा सेविका, गोरु वा गधा, अथवा त्यससित भएको कुनै कुराको पनि लालच नगर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","जब सारा मानिसहरूले गर्जन, बिजुली देखे; अनि तुरहीको आवाज सुने, र पर्वत धुवाँले भरिएको देखे, तब तिनीहरू डरले थरथर कामे। तिनीहरू टाढै उभिए, ");
INSERT INTO npioncb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","अनि मोशालाई भने, “हामीसित तपाईं नै बोल्नुहोस्, र हामी सुन्‍नेछौँ। तर परमेश्‍वर हामीसित नबोलून्, नत्रता हामी मर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","अनि मोशाले मानिसहरूलाई भने, “नडराओ, किनकि परमेश्‍वरको डर तिमीहरूमा रहिरहोस्, साथै उहाँले तिमीहरूलाई जाँच गर्न र तिमीहरूले पाप नगर भनेर आउनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","त्यसैले मानिसहरू टाढै उभिरहे। अनि मोशाचाहिँ परमेश्‍वर उपस्थित हुनुभएको त्यस बाक्लो कालो बादलको नजिक गए। ");
INSERT INTO npioncb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब याहवेहले मोशालाई भन्‍नुभयो, “इस्राएलीहरूलाई यसो भन्: ‘मैले तिमीहरूसित स्वर्गबाट बोलेको तिमीहरूले देखेका छौ: ");
INSERT INTO npioncb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","तिमीहरूले मेरो साथमा अरू देवी-देवताहरू नबनाउनू, न त आफ्ना निम्ति चाँदी वा सुनका देवी-देवताहरू नै बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘तिमीहरूले मेरो निम्ति माटोको एउटा वेदी बनाउनू, र त्यसमाथि तिमीहरूका होमबलि, मेलबलि, तिमीहरूका भेडाबाख्राहरू र पशुहरू बलिदान गर्नू। मेरो सम्झना गर्नलाई जुन स्थान म रोज्छु, त्यहाँ म तिमीहरूकहाँ आउनेछु र तिमीहरूलाई आशिष् दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","यदि तिमीहरूले मेरो निम्ति ढुङ्गाको वेदी बनायौ भने कुँदेका ढुङ्गाले नबनाउनू; किनकि तिमीहरूले त्यसमा हतियार प्रयोग गर्दा त्यसलाई अशुद्ध पार्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","अनि तिमीहरूको नग्नता वेदीमा नदेखियोस् भनेर त्यसमा खुड्किला बनाएर नउक्लनू।’ ");
INSERT INTO npioncb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“तैँले तिनीहरूका सामु स्थापना गर्नुपर्ने नियमहरू यिनै हुन्: ");
INSERT INTO npioncb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“तैँले हिब्रू सेवकलाई किनिस् भने उसले छ वर्षसम्म तेरो सेवा गरोस्। तर सातौँ वर्षमा उसले केही नतिरी स्वतन्त्र भएर जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","यदि त्यो एकलै आएको भए, एकलै स्वतन्त्र भएर जाओस्; तर त्यो आउँदा त्यससँग पत्नी पनि थिई भने ऊ पनि त्यससितै जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","यदि उसका मालिकले उसलाई पत्नी दिएको हो भने, र त्यसले छोराछोरी जन्माई भने त्यो स्त्री, र त्यसका छोराछोरी त्यसका मालिकका हुनेछन्; तर त्यो मानिस मात्र स्वतन्त्र भएर जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“तर त्यस सेवकले ‘म मेरा मालिक, आफ्नी पत्नी र छोराछोरीलाई माया गर्छु; अनि स्वतन्त्र भएर जान चाहन्‍नँ’ भनेर घोषणा गर्‍यो भने, ");
INSERT INTO npioncb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","उसका मालिकले उसलाई न्यायकर्ताहरूका सामु लगोस्। तिनले त्यसलाई ढोका अथवा ढोकाको खाँबोमा लगेर त्यसका कान सियोले छेडोस्; तब त्यो जीवनभरिका लागि त्यस मालिकको दास हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“यदि कुनै मानिसले आफ्नी छोरीलाई दासीको रूपमा बेच्छ भने त्यो दासी पुरुष दासहरूझैँ स्वतन्त्र भएर जान पाउनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","यदि त्यसलाई किन्‍ने मालिकलाई त्यसले प्रसन्‍न पार्न सकिन भने तिनले त्यसलाई फेरि किनिनका लागि छाडिदिनुपर्छ। मालिकले त्यससँग विश्‍वास तोडेका कारण त्यसलाई परदेशीको हातमा बेच्ने अधिकार हुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","तिनले त्यसलाई आफ्नो छोराको लागि चुन्छन् भने तिनले त्यसलाई छोरीको अधिकार दिनुपर्छ; ");
INSERT INTO npioncb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","तर त्यसले अर्की पत्नी ल्यायो भने त्यसले जेठीलाई भोजन, लुगाफाटा र वैवाहिक अधिकारदेखि वञ्चित नगरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","यदि त्यसले उसलाई यी तीन कुराहरू दिँदैन भने त्यो कुनै मोल नतिरी स्वतन्त्र भएर जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“कसैले कुनै मानिसलाई हिर्काएर मार्‍यो भने त्यो पनि मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","तरै पनि यदि त्यसले जानाजानी त्यसो गर्दैन, तर परमेश्‍वरले नै त्यसो हुन दिनुभयो भने जुन ठाउँ म तोक्नेछु; त्यो त्यहाँ भागेर जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","तर कुनै मानिसले योजना बनाएर छलपूर्वक अर्को मानिसलाई मार्छ भने त्यसलाई मेरो वेदीबाट लगेर मार्नैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“जसले आफ्ना बुबा वा आमामाथि आक्रमण गर्छ, त्यो मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“जसले कुनै मानिसलाई अपहरण गर्छ वा बिक्री गर्छ, अथवा त्यो पक्राउ पर्दा ऊ त्यससितै रहेको अवस्थामा फेला परियो भने त्यो मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“जसले आफ्ना बुबा वा आमालाई सराप्छ, त्यो मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“यदि मानिसहरू झगडा गर्दा एउटाले अर्कोलाई ढुङ्गा अथवा मुक्‍काले हिर्कायो, र त्यो नमरेर ओछ्यान पर्‍यो, ");
INSERT INTO npioncb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","अनि उठेर आफ्नो लहुरोको सहायताले बाहिर यताउता हिँड्न थाल्यो भने त्यो हिर्काउने मानिस निर्दोष ठहरियोस्; तरै पनि त्यसले घाइते मानिसको खेर गएको समयको क्षतिपूर्ति देओस्, र त्यो पूरा निको नहोउन्जेल त्यसले त्यस मानिसको उपचार गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“कुनै मानिसले आफ्नो दास वा दासीलाई लहुरोले हिर्कायो, र ऊ त्यही कारणले मर्‍यो भने त्यसले दण्ड पाउनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","तर यदि त्यो दास एक दुई दिनमा उठ्यो भने त्यसलाई दण्ड नदिइयोस्; किनकि त्यो दास त्यसकै सम्पत्ति हो। ");
INSERT INTO npioncb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“मानिसहरू झगडा गर्दा कुनै गर्भवती स्त्रीलाई लाग्यो, र त्यसले समय नपुगी नै बच्‍चा जन्माई, तर अरू चोट लागेको छैन भने त्यस कसुरदारले त्यस स्त्रीको पतिले तोकेको र अदालतले अनुमति दिएबमोजिम जरिमाना तिरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","तर यदि गम्भीर चोट लागेको छ भने तिमीहरूले प्राणको सट्टा प्राण लिनू, ");
INSERT INTO npioncb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","आँखाको सट्टा आँखा, दाँतको सट्टा दाँत, हातको सट्टा हात, खुट्टाको सट्टा खुट्टा, ");
INSERT INTO npioncb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","डामको सट्टा डाम, कुटाइको सट्टा कुटाइ र चोटको सट्टा चोट। ");
INSERT INTO npioncb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“यदि कुनै मानिसले आफ्नो दास वा दासीलाई आँखामा हिर्कायो, र आँखा फुट्यो भने त्यसले आँखाको क्षतिपूर्तिस्वरूप त्यसलाई स्वतन्त्र भएर जान देओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","अनि यदि त्यसले आफ्नो दास वा दासीको दाँत हिर्काएर भाँचिदियो भने त्यसको दाँतको क्षतिपूर्तिस्वरूप त्यसलाई स्वतन्त्र भएर जान देओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“यदि कुनै गोरुले कुनै पुरुष वा स्त्रीलाई सिङले हानेर मार्‍यो भने त्यस गोरुलाई ढुङ्गाले हानेर मारियोस्, र त्यसको मासु नखानू। तर त्यस गोरुको मालिक त्यसको जिम्मेवार हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","तर यदि त्यस गोरुको पहिलेदेखि नै हान्‍ने स्वभाव थियो, र त्यसको मालिकलाई चेतावनी दिइएको थियो, तर उसले त्यसलाई बाँधेर राखेन, र त्यसले कुनै पुरुष वा स्त्रीलाई मार्‍यो भने त्यो गोरुलाई ढुङ्गाले हानेर मारियोस्, साथै त्यो मालिक पनि मारिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","तर यदि त्यस गोरुको मालिकबाट छुटकाराको दाम मागियो भने त्यो आफ्नै प्राणको निम्ति तोकिएको रकम तिरेर छुटोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","त्यस गोरुले छोरा वा छोरीलाई सिङले हानेर मार्‍यो भने पनि यही नियम लागू हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","यदि त्यस गोरुले कसैको दास वा दासीलाई हानेर मार्‍यो भने त्यस गोरुको मालिकले दास-दासीको मालिकलाई चाँदीको तीस शेकेल तिरोस्, र त्यो गोरुचाहिँ ढुङ्गाले हानेर मारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“कुनै मानिसले खाडल खनेर खुल्‍लै राख्यो, अथवा खनेर त्यसलाई छोपेन; अनि त्यसभित्र कुनै गोरु अथवा गधा खस्यो भने, ");
INSERT INTO npioncb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","त्यस खाडलको मालिकले त्यस नोक्सानीको साटो रकम तिरोस्। उसले त्यसको मालिकलाई रकम तिरोस्; र त्यो मरेको पशु त्यसैको हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“कुनै मानिसको गोरुले अर्को गोरुलाई हान्यो, र त्यो मर्‍यो भने तिनीहरूले जीवित गोरुलाई बेचून्, र बेचेको रकम र मरेको पशु बराबर बाँडून्। ");
INSERT INTO npioncb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","तथापि त्यस गोरुको पहिलेदेखि नै हान्‍ने बानी छ भनेर जानिएको थियो, तर पनि उसले त्यसलाई बाँधेन भने त्यस मालिकले गोरुको सट्टा गोरु नै देओस्, र मरेको गोरुचाहिँ त्यसैको होस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“यदि कसैले गोरु वा भेडा चोरेर त्यसलाई मार्छ वा बिक्री गर्छ भने त्यसले त्यस गोरुको सट्टा पाँच गोरु र त्यस भेडाको सट्टा चार वटा भेडा देओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“यदि कुनै चोर घर फोर्दै गर्दा फेला पर्‍यो, र त्यसलाई हिर्काउँदा मर्‍यो भने त्यस मानिसको रगतको दोष कसैलाई लाग्नेछैन; ");
INSERT INTO npioncb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","तर यदि यस्तो घटना घाम झुल्केपछि भएको हो भने हिर्काउने मानिसलाई रगतको दोष लाग्नेछ। “चोरले क्षतिपूर्ति तिर्नैपर्छ; तर यदि त्यससित केही छैन भने त्यसले चोरी गरेको बदलामा त्यसैलाई बेचेर मूल्य चुकाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","यदि चोरिएको पशु त्यससित जिउँदै पाइयो भने—चाहे त्यो गोरु अथवा गधा अथवा भेडा जेसुकै होस्—त्यसले दोबर मूल्य फर्काउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“यदि कुनै मानिसले आफ्नो पशु खेतमा अथवा दाखबारीमा चर्न खुला छोडिदियो, र त्यो अर्काको खेतमा गएर चर्‍यो भने त्यसले आफ्नो खेतबारी अथवा दाखबारीको सबैभन्दा असल उब्जनीबाट त्यसको क्षतिपूर्तिस्वरूप दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“यदि कसैले काँडाघारीमा आगो लगाउँदा त्यो फैलिँदै गएर अन्‍न थुपारेर राखेको ठाउँ, खेतको अन्‍न अथवा सम्पूर्ण खेत सखाप गरिदियो भने आगो लगाउने व्यक्ति जो हो, त्यसैले क्षतिपूर्ति तिरिदिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“कुनै मानिसले आफ्नो छिमेकीलाई रकम अथवा सर-सामान सुरक्षापूर्वक राख्नलाई दियो, तर छिमेकीको घरबाट ती कुराहरू चोरी भयो भने र चोर पक्राउ परेको खण्डमा त्यसले दोबर क्षतिपूर्ति तिर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","तर त्यो चोर पक्राउ परेन भने त्यस घरको मालिक नै त्यस मानिसको सम्पत्तिमा हात लगायो कि भनेर निर्णय गरिनका लागि न्यायकर्ताहरूका सामु ल्याइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","गोरु, गधा, भेडा, लुगा अथवा कसैले ‘यो मेरो हो’ भनेका कुनै पनि किसिमको सम्पत्ति कसैकहाँ अवैध रूपमा पाइयो भने यस्ता सबै मुद्दा दुवै पक्षले न्यायकर्ताहरूको सामु ल्याऊन्। जसलाई न्यायकर्ताले दोषी ठहर्‍याउँछन्, त्यसले नै आफ्नो छिमेकीलाई दोबर क्षतिपूर्ति तिरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“यदि कुनै मानिसले गधा, गोरु, भेडा अथवा अरू पशु आफ्नो छिमेकीलाई सुरक्षाको निम्ति राख्न दिएको छ; र त्यो पशुको मृत्यु भयो अथवा त्यसलाई चोट लाग्यो अथवा कसैको ध्यान नपुगेको बेला कसैले लगिदियो भने, ");
INSERT INTO npioncb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","दुई बीचको यो विषय त्यस छिमेकीले अर्को मानिसको सम्पत्तिमा आफ्नो हात लगाएको छैन भनेर याहवेहको सामु शपथ खाएर मिलाउनुपर्छ। त्यस मालिकले त्यो स्वीकार गरोस्, तब त्यसले क्षतिपूर्ति तिर्नुपर्दैन। ");
INSERT INTO npioncb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","तर यदि त्यो पशु त्यही छिमेकीबाट नै चोरिएको हो भने त त्यसले त्यसको धनीलाई क्षतिपूर्ति तिर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","यदि त्यसलाई कुनै जङ्गली जनावरले टुक्रा-टुक्रा पारेको छ भने त्यसले ती बाँकी रहेका अङ्गहरू प्रमाणको लागि ल्याओस्, र त्यसले टुक्रा-टुक्रा पारिएको पशुको मोल तिर्नुपर्दैन। ");
INSERT INTO npioncb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“यदि कुनै मानिसले आफ्नो छिमेकीबाट पशु सापटी लियो, र मालिक नभएको बेलामा त्यसलाई चोट लाग्यो अथवा त्यो मर्‍यो भने त्यसैले नै क्षतिपूर्ति तिर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","तर पशु मालिकसितै छ भने सापटी लानेले त्यसलाई क्षतिपूर्ति तिर्नुपर्दैन। यदि त्यो पशु भाडामा लिइएको थियो भने भाडाको त्यस रकमले त्यसैको नोक्सानी बेहोर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“यदि कुनै मानिसले विवाह गर्नलाई मगनी नभएकी कन्यालाई ललाइ-फकाइ गरी त्यससित कुकर्म गर्‍यो भने त्यसले दुलहीको मूल्य तिर्नुपर्छ; तब त्यो त्यसकी पत्नी हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","यदि त्यसका बुबाले त्यसलाई दिन पटक्‍कै मानेनन् भने कन्याको मोलअनुसार त्यस मानिसले दुलहीको मूल्य तिर्नैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तन्त्रमन्त्र गर्ने स्त्रीलाई जीवित रहन नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“जसले पशुसित कुकर्म गर्छ, त्यो मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“जसले याहवेहबाहेक अरू देवी-देवताहरूलाई बलिदान चढाउँछ, त्यसलाई नाश पारिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“तैँले कुनै प्रवासीसित दुर्व्यवहार नगर्नू अथवा त्यसलाई नसताऊनू; किनकि तिमीहरू पनि इजिप्टमा प्रवासी थियौ। ");
INSERT INTO npioncb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“तिमीहरूले विधवा वा अनाथलाई शोषण नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","यदि तिमीहरूले यसो गर्‍यौ, र तिनीहरूले मेरो पुकार गरे भने म निश्‍चय तिनीहरूका पुकार सुन्‍नेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","अनि मेरो क्रोध दन्कनेछ, र म तिमीहरूलाई तरवारले मार्नेछु; अनि तिमीहरूका पत्नीहरू विधवा हुनेछन् र तिमीहरूका छोराछोरी अनाथ हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“यदि तिमीहरूले अभावमा भएका मेरा मानिसलाई आफूसित भएका रकम ऋण दियौ भने साहुकारजस्ता नहुनू; न त त्यससित ब्याज नै लिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","यदि तिमीहरूले आफ्नो छिमेकीको लुगा बन्धकको रूपमा लिएका छौ भने सूर्यास्त हुनु पहिल्यै त्यो त्यसलाई फर्काइदिनू; ");
INSERT INTO npioncb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","किनकि आफ्नो शरीर ढाक्नलाई त्यससित एक जोर लुगा मात्र छ। तब त्यसले के ओढेर सुत्ला? जब त्यसले मेरो पुकार गर्छ, तब म सुन्‍नेछु; किनकि म दयालु छु। ");
INSERT INTO npioncb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“तैँले ईश्‍वरनिन्दा नगर्नू, न त आफ्ना मानिसहरूका शासकलाई सराप्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“तिमीहरूका ढुकुटी अथवा भाँडोबाट दिनुपर्ने भेटी अर्पण गर्न ढिला नगर्नू। “तिमीहरूले आफ्ना छोराहरूमध्येबाट जेठाचाहिँ मलाई दिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","तिमीहरूका गाईबस्तु र भेडाबाख्राहरूबाट पनि त्यस्तै गर्नू। तिनीहरूलाई आफ्ना आमासित सात दिन बस्‍न देओ; तर आठौँ दिन ती मलाई दिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तिमीहरू मेरा निम्ति पवित्र जाति हौ। यसकारण जङ्गली जन्तुहरूले चिथोरेको पशुको मासु नखानू; त्यसलाई कुकुरहरूका निम्ति फालिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“तैँले झूटो कुरा नफैलाउनू। झूटो साक्षी बनेर दुष्‍ट मानिसलाई नसघाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“तैँले खराबी गर्न भीडको पछि नलाग्नू। मुद्दामा साक्षी दिँदा भीडतिर लागेर न्याय नबिगार्नू; ");
INSERT INTO npioncb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","अनि गरिब भन्दैमा मुद्दामा त्यसलाई पक्षपात नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“तिमीहरूका शत्रुका गोरु अथवा गधा फुस्केको देख्यौ भने त्यसलाई उसकहाँ लगिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","यदि तिमीहरूलाई घृणा गर्नेको गधा भारीमुनि दबिएको देख्यौ भने त्यसलाई त्यत्तिकै नछोड्नू, बरु त्यसलाई सहायता दिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“मुद्दामा आफ्ना गरिब मानिसहरूलाई न्याय गरिदिन इन्कार नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","झूटो अभियोगबाट टाढा बस्‍नू र कुनै निर्दोष अथवा इमानदार व्यक्तिलाई नमार्नू; किनकि म दोषीलाई त्यत्तिकै छोड्नेछैनँ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“घूस स्वीकार नगर्नू; किनकि घूसले आँखा देख्नेहरूलाई अन्धा तुल्याइदिन्छ, र निर्दोषका कुरालाई बङ्ग्याइदिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“प्रवासीलाई अत्याचार नगर्नू; प्रवासी हुँदा कस्तो हुन्छ, त्यो तिमीहरू आफैँलाई थाहा छ; किनकि तिमीहरू इजिप्टमा प्रवासी थियौ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छ वर्षसम्म तिमीहरूले आफ्नो खेती गर्नू, र फसलको कटनी गर्नू, ");
INSERT INTO npioncb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","तर सातौँ वर्षमा खेत नजोत्नू, र प्रयोग नगरी छोडिदिनू। तब तिमीहरूमध्ये गरिबहरूले त्यसबाट भोजन पाऊन्, र तिनीहरूले छोडेका जङ्गली पशुहरूले खाऊन्। तिमीहरूका अङ्‌गुर र जैतुनका बारीलाई पनि त्यसै गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“छ दिनसम्म आफ्ना काम गर्नू, तर सातौँ दिनमा चाहिँ काम नगर्नू, र तिमीहरूका गोरु र गधाले विश्राम पाऊन्, र तिमीहरूका घरमा जन्मेका दास र प्रवासीहरू पनि ताजा होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“मैले तिमीहरूलाई भनेका प्रत्येक कुरा होशियार भई पालन गर्नू। अरू देवी-देवताहरूको नाम नलेओ; तिनीहरूका नाम तिमीहरूको मुखबाट उच्‍चारण नै नहोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“वर्षमा तीनपल्ट तिमीहरूले मेरा निम्ति चाड मनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“अखमिरी रोटीको चाड मनाओ; मैले तिमीहरूलाई आज्ञा दिएझैँ सात दिनसम्म अखमिरी रोटी खाओ। यो तिमीहरूले आबीब महिनाको तोकिएको समयमा गर; किनकि त्यही महिना तिमीहरू इजिप्टबाट निस्केर आएका थियौ। “मकहाँ कोही पनि खाली हात नआओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“तिमीहरूले आफ्ना खेतमा छरेका अन्‍नको पहिलो फलले कटनीको चाड मनाउनू। “वर्षको अन्तमा तिमीहरूले खेतबाट आफ्ना अन्‍न बटुल्दा अन्‍न भित्र्याउने चाड मनाओ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“वर्षमा तीनपल्ट सबै पुरुषहरू सार्वभौम याहवेहकहाँ देखा परून्। ");
INSERT INTO npioncb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“तिमीहरूले मलाई बलिदानको रगतसित खमिर भएको कुनै पनि कुरा नचढाउनू। “मेरा चाडको बलिको बोसोहरू बिहानसम्म रहन नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“तिमीहरूका माटोबाट उब्जेका सबैभन्दा असल पहिलो फल याहवेह तिमीहरूका परमेश्‍वरको घरमा ल्याउनू। “बाख्राको पाठो त्यसको माउको दूधमा नपकाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“हेर, तिमीहरूलाई बाटोमा रक्षा गर्न मैले तयार पारिराखेको ठाउँमा तिमीहरूलाई ल्याउनलाई म एउटा दूत तिमीहरूका अगि-अगि पठाउँदैछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ध्यान दिएर तिनको कुरा सुन, र तिनले भनेका कुरा मान। तिनको विरोध नगर; तिनले तिमीहरूको विद्रोह क्षमा गर्नेछैनन्; किनकि मेरो नाम तिनमा रहेको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","यदि तिमीहरूले तिनले भनेका कुरा ध्यानपूर्वक सुन्यौ र मैले तिमीहरूलाई भनेका सबै गर्‍यौ भने म तिमीहरूका शत्रुहरूका शत्रु बन्‍नेछु; अनि तिमीहरूलाई विरोध गर्नेहरूलाई म विरोध गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","मेरो दूत तिमीहरूका अगि-अगि जानेछन् र तिमीहरूलाई एमोरी, हित्ती, परिज्जी, कनानी, हिव्वी र यबूसीहरूका देशमा ल्याउनेछन्, र म तिनीहरूलाई पूर्ण रूपले नाश गरिदिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","तिनीहरूका देवी-देवताहरूलाई दण्डवत् नगर्नू, तिनीहरूको आराधना नगर्नू अथवा तिनीहरूका रीतिहरूअनुसार नचल्नू। तिमीहरूले ती भत्काइदिनू र तिनीहरूले पवित्र मानेका ढुङ्गाहरू टुक्रा-टुक्रा पारेर भाँचिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","याहवेह तिमीहरूका परमेश्‍वरलाई आराधना गर्नू, र तिमीहरूका अन्‍नपानीमा उहाँको आशिष् रहनेछ। म तिमीहरूका बीचबाट रोगहरू हटाइदिनेछु; ");
INSERT INTO npioncb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","अनि तिमीहरूको देशमा कसैको गर्भ तुहुनेछैन वा कोही बाँझी हुनेछैन। म तिमीहरूलाई पूरा आयु जिउन दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“म तिमीहरूका अगि-अगि मेरो आतङ्क पठाउनेछु, र तिमीहरूले सामना गर्ने प्रत्येक राष्ट्रलाई अलमल पारिदिनेछु। म तिमीहरूका सबै शत्रुहरूलाई पिठिउँ फर्काएर भाग्ने तुल्याउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","म हिव्वी, कनानी र हित्तीहरूलाई तिमीहरूका बाटोदेखि धपाउनको निम्ति तिमीहरूका अगि-अगि अरिङ्गाल पठाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","तर म तिनीहरूलाई एकै वर्षमा धपाउनेछैन, नत्रता देश उजाड हुनेछ, र जङ्गली जनावरहरू तिमीहरूका लागि संख्यामा ज्यादै हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","म तिमीहरू संख्यामा बढेर देशमाथि अधिकार गर्न सक्ने नभएसम्म तिनीहरूलाई तिमीहरूकै सामु अलि-अलि गर्दै धपाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“म तिमीहरूका सिमाना लाल समुद्रदेखि भूमध्य सागरसम्म, र उजाडस्थानदेखि यूफ्रेटिस नदीसम्मै स्थापित गर्नेछु। म त्यस देशमा बसोबास गर्ने मानिसहरूलाई तिमीहरूका हातमा पारिदिनेछु, र तिमीहरूले तिनीहरूलाई आफ्नो सामुबाट धपाउनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","तिनीहरूसित र तिनीहरूका देवी-देवताहरूसित करार नबाँध्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","तिनीहरूलाई तिमीहरूको देशमा बस्‍न नदिनू, नत्रता तिनीहरूले तिमीहरूलाई मेरो विरुद्धमा पाप गर्न लाउनेछन्; किनकि तिनीहरूका देवी-देवताहरूको आराधना तिमीहरूका निम्ति निश्‍चय नै पासो हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","त्यसपछि उहाँले मोशालाई भन्‍नुभयो, “तँ र हारून, नादाब र अबीहू, र इस्राएलका सत्तरी जना प्रधानहरू याहवेहकहाँ माथि उक्लेर आओ। तिमीहरू टाढै रहेर आराधना गर्नू, ");
INSERT INTO npioncb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","तर मोशामात्र याहवेहको नजिक आओस्; अरू कोही पनि नजिक नआऊन्। अनि मानिसहरू पनि ऊसँग माथि उक्लेर नआऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","जब मोशाले गएर मानिसहरूलाई याहवेहका सबै वचन र व्यवस्थाहरू भनिदिए; तब तिनीहरूले एकै सोरले जवाफ दिए, “याहवेहले भन्‍नुभएका सबै कुराहरू हामी गर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","तब मोशाले याहवेहले भन्‍नुभएका प्रत्येक कुराहरू लेखे। तिनी भोलिपल्ट बिहानै उठे र पर्वतको फेदीमा एउटा वेदी बनाए, र इस्राएलका बाह्र कुलको प्रतिनिधित्व गर्नलाई बाह्र वटा ढुङ्गाका खम्बाहरू खडा गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तब तिनले जवान इस्राएली मानिसहरूलाई पठाए, र तिनीहरूले याहवेहका निम्ति होमबलि चढाए, र मेलबलिको रूपमा जवान बहरहरू बलिदान गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशाले आधा रगत लिएर कचौराहरूमा हाले र अर्को आधा भागचाहिँ वेदीमाथि छर्किदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","तब तिनले करारको पुस्तक लिएर मानिसहरूलाई पढेर सुनाए। तिनीहरूले जवाफ दिए, “याहवेहले भन्‍नुभएका सबै कुराहरू हामी गर्नेछौँ; हामी ती पालन गर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मोशाले रगत लिएर मानिसहरूमाथि छर्के, र भने, “यो रगत यी वचनहरूका आधारमा याहवेहले तिमीहरूसित गर्नुभएको करारको रगत हो।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","त्यसपछि मोशा, हारून, नादाब, अबीहू, र इस्राएलका सत्तरी प्रधानहरू माथि उक्लेर गए; ");
INSERT INTO npioncb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","अनि तिनीहरूले इस्राएलका परमेश्‍वरलाई देखे। उहाँको खुट्टामुनि निलो आकाशझैँ सफा नीलमणि थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","तर परमेश्‍वरले इस्राएलका ती अगुवाहरूका विरुद्धमा आफ्नो हात उठाउनुभएन; तिनीहरूले परमेश्‍वरलाई देखे, र तिनीहरूले खानपिन गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","तब याहवेहले मोशालाई भन्‍नुभयो, “मकहाँ पर्वतमा उक्लेर आइज र यहीँ बस्; अनि तिनीहरूको शिक्षाको निम्ति मैले लेखेका व्यवस्था र आज्ञाका ढुङ्गाका पाटीहरू म तँलाई दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","तब मोशा र तिनका सेवक यहोशू उठेर परमेश्‍वरको पर्वतमा गए। ");
INSERT INTO npioncb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मोशाले प्रधानहरूलाई भने, “हामी तपाईंहरूकहाँ नआउन्जेल यहीँ हामीलाई पर्खिबस्‍नुहोस्। हारून र हूर तपाईंहरूसँग छन्; अनि कसैको केही विवाद भए तिनीहरूकहाँ जानू।” ");
INSERT INTO npioncb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","जब मोशा उक्लेर पर्वतमाथि गए, तब बादलले त्यस पर्वतलाई ढाक्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","अनि याहवेहको महिमा सीनै पर्वतमा रह्‍यो। छ दिनसम्म बादलले पर्वतलाई ढाकिरह्‍यो; र सातौँ दिनमा याहवेहले बादलभित्रबाट मोशालाई बोलाउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएलीहरूका निम्ति याहवेहको महिमा पर्वतको टाकुरामा भस्म पार्ने आगोझैँ देखियो। ");
INSERT INTO npioncb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मोशा पर्वतमाथि उक्लँदै गएर बादलभित्र प्रवेश गरे। अनि तिनी पर्वतमाथि चालीस दिन र चालीस रात रहे। ");
INSERT INTO npioncb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएलीहरूलाई मेरो निम्ति भेटी ल्याउनू भन्। मेरो निम्ति हृदयदेखि नै दिने इच्छा गर्ने प्रत्येक मानिसबाट तैँले भेटी ग्रहण गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“तिनीहरूबाट तैँले प्राप्‍त गर्नुपर्ने भेटीहरू यिनै हुन्: “सुन, चाँदी र काँसो; ");
INSERT INTO npioncb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","निलो र बैजनी, रातो धागो र मसिनो सुती कपडा; बाख्राको भुत्ला; ");
INSERT INTO npioncb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","भेडाका रातो रङ्गले रङ्गाएको छालाहरू र सीलका छालाहरू; बबुलका काठ; ");
INSERT INTO npioncb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","बत्तीको निम्ति जैतुनको तेल; अभिषेक गर्नका निम्ति तेल र सुगन्धित धूपका निम्ति मसलाहरू; ");
INSERT INTO npioncb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","अनि एपोद र छाती-पाता जड्नका निम्ति गोमेद र अरू रत्नहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“तब तिनीहरूले मेरा लागि एउटा समागम पाल बनाऊन्, र म तिनीहरूको माझमा बास गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","मैले तँलाई जस्तो नमुना देखाउनेछु, ठिक त्यहीअनुसार समागम पाल र त्यसका सबै सामानहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“तिनीहरूले बबुल काठको साढे दुई क्यूबिट लामो, साढे एक क्यूबिट चौडा र साढे एक क्यूबिट अग्लो सन्दुक बनाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","त्यसलाई भित्र र बाहिर दुवैतिर निखुर सुनले मोहोर्नू, र त्यसको चारैतिर सुनको बिट बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","अनि त्यसका निम्ति सुनका चार वटा मुन्‍द्रा, त्यसका चार खुट्टामा बाँध्नू—दुई मुन्द्राहरू एकापट्टि र दुई वटा अर्कापट्टि। ");
INSERT INTO npioncb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","तब बबुल काठका डण्डाहरू बनाएर तिनलाई सुनले मोहोर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ती डण्डाहरू सन्दुक बोक्नलाई त्यसका दुवैतिर भएका मुन्द्राहरूमा लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ती डण्डाहरू त्यस सन्दुकका मुन्द्राहरूमै रहून्; तिनीहरूलाई ननिकाल्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","त्यस सन्दुकभित्र मैले तँलाई दिने साक्षी पाटी राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“तैँले निखुर सुनको साढे दुई क्यूबिट लामो र साढे एक क्यूबिट चौडा एउटा पाप समाधान-स्थान बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","त्यसपछि पाप समाधान-स्थानको किनारहरूमा पिटिएको सुनका दुई वटा करूबहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एउटा करूब त्यस पाप समाधान-स्थानको एकापट्टि र अर्को करूब अर्कोपट्टि बनाउनू। ती करूबहरू पाप समाधान-स्थानसित एउटै टुक्रा हुने गरी दुवैतिर बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ती करूबहरूका पखेटाहरू पाप समाधान-स्थानलाई ढाक्ने गरी उँभोतिर फर्केका होऊन्। ती करूबहरू पाप समाधान-स्थानतिर हेर्दै एक-अर्कापट्टि फर्केका होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","त्यस पाप समाधान-स्थानलाई सन्दुकको माथिपट्टि राख्नू; अनि मैले तँलाई दिने साक्षी पाटी त्यसभित्र राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","अनि त्यहीँ करारको सन्दुकमाथि भएका दुई करूबहरूको बीचमा भएको पाप समाधान-स्थानमाथि म तँलाई भेट्नेछु; र इस्राएलीहरूका निम्ति मेरा सबै आज्ञाहरू तँलाई दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“तैँले बबुल काठको एउटा टेबुल—दुई क्यूबिट लामो, एक क्यूबिट चौडा र साढे एक क्यूबिट अग्लो बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","त्यसलाई तैँले निखुर सुनले मोहोर्नू, र त्यसका चारैतिर सुनको बिट बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","साथै त्यसका चारैतिर चार औँला चौडाइ भएको घेरा बनाउनू, र त्यसमा सुनको बिट लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","टेबुलको लागि सुनका चार वटा मुन्द्राहरू बनाएर ती चार कुनाहरूमा भएका खुट्टाहरूमा बाँध्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","त्यो टेबुल बोक्नलाई चलाइने डण्डाहरूलाई समातिराख्न ती मुन्द्राहरू घेराका छेवैमा होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","बबुल काठका डण्डाहरू बनाएर त्यसलाई सुनले मोहोर्नू, र तिनीहरूकै सहायताले टेबुल बोक्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","त्यसका थालहरू अनि कचौराहरू, साथै करूवाहरू र भेटी खन्याउने कचौराहरू पनि निखुर सुनको बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","यस टेबुलमाथि उपस्थितिको रोटी मेरो सामु हर समय राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“तैँले निखुर सुनको एउटा सामदान बनाउनू; घनले पिटेर त्यसको आधार र डण्डा बनाउनू; त्यसका फूलजस्ता कचौराहरू, कोपिलाहरू र फूलहरू त्यससित एउटै टुक्राबाट बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","तीन वटा एकपट्टि र तीन वटा अर्कोपट्टि गरेर जम्मा सामदानका दुई छेउमा छ वटा हाँगाहरू निस्केका होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","एउटा हाँगामा कोपिला र फूल भएको बदामको फूलजस्तै आकारका तीन वटा कचौराहरू होऊन्; अर्को हाँगामा तीन वटा र यसै गरी सामदानबाट निस्केका छ वटै हाँगाहरूमा होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","अनि सामदानमा कोपिला र कोपिला भएको बदामको फूलको आकारमा चार वटा कचौराहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","पहिलो कोपिला सामदानबाट निस्केको हाँगाको पहिलो जोडीमुनि होऊन्—दोस्रो कोपिला दोस्रो जोडीमुनि र तेस्रो कोपिला तेस्रो जोडीमुनि गरेर जम्मा छ वटा हाँगाहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ती कोपिलाहरू र हाँगाहरू सामदानसित एउटै टुक्राबाट घनले पिटेको निखुर सुनले बनिएको होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“तब त्यसका सात वटा दियाहरू बनाउनू र त्यसको नजिक ठाउँमा उज्यालो देखियोस् भनेर तिनलाई त्यसमाथि राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","त्यसको सलेदो ठिक गर्ने चिम्टा र मोसोदानी निखुर सुनका होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","सामदान र त्यसका सबै पात्रहरू एक टालेन्ट निखुर सुनको बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ती सबै तँलाई पर्वतमा देखाइएको नमुनाअनुसार बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“तैँले दश वटा मसिनो गरी बाटेका सुती, निलो, बैजनी र रातो धागोका पर्दाबाट दक्ष शिल्पकारद्वारा बनाइएका करूबहरूसहित समागम पाल बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ती सबै पर्दाहरू एकै नापका होऊन्—अट्ठाइस क्यूबिट लामो र चार क्यूबिट चौडा। ");
INSERT INTO npioncb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाँच वटा पर्दाहरू एकसाथ गाँस्‍नू, र अर्को पाँच वटालाई पनि त्यसै गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","पहिलो पाँच पर्दाहरूका किनारै किनारमा निलो रङ्गको सुर्काउनी बनाउनू; अनि अर्को पाँच पर्दाहरूका किनारमा पनि त्यस्तै गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","एउटा समूहका पर्दामा पचास वटा सुर्काउनीहरू बनाउनू; अनि अर्को समूहका पाँच वटा पर्दाहरूका किनारमा पचास वटा सुर्काउनी बनाउनू। ती सुर्काउनीहरू आमने-सामने होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","तब सुनका पचास वटा अङ्कुसेहरू बनाएर तिनीहरूलाई पर्दाहरू एकसाथ बाँध्ने काममा प्रयोग गर्नू र यसरी समागम पाल एउटै इकाई होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“समागम पालमाथिको पालको लागि बाख्राको भुत्लाबाट जम्मा एघार वटा पर्दाहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ती एघारै वटा पर्दाहरू एउटै नापका होऊन्—तीस क्यूबिट लामो र चार क्यूबिट चौडा। ");
INSERT INTO npioncb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","पाँच वटा पर्दाहरू एकसाथ गाँस्‍नू र बाँकी छ वटा पर्दा एकसाथ गाँस्‍नू। पालको अगिल्तिर छैटौँ पर्दालाई दोबर गरी पट्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","पहिलो गाँसिएको समूहको किनारमा पचास वटा सुर्काउनीहरू बनाउनू; अनि अर्को गाँसिएको समूहको पर्दाको किनारमा पनि पचास वटा सुर्काउनीहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","त्यसपछि काँसाका पचास वटा अङ्कुसेहरू बनाएर सुर्काउनीहरूमा लगाउनू र पाललाई एउटै एकाइ बनाउनका लागि कस्‍ने काममा प्रयोग गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","पालका पर्दाहरूको उब्रेको लम्बाइको विषयमा, उब्रेको आधा पर्दा समागम पालको पछिल्तिर झुण्डियोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","पालका पर्दाहरू दुवै छेउतिर एक क्यूबिट लामो होऊन् र उब्रेका भाग समागम पाललाई ढाक्नलाई त्यसका दुवै छेउमा झुण्डिरहून्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","पालको निम्ति भेडाको रातो रङ्गाइएको छालाबाट छत बनाउनू; र त्यसमाथि सीलका छालाहरूबाट छत बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“समागम पालका निम्ति बबुल काठको ठाडो फल्याकहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","प्रत्येक फल्याकको लम्बाइ दश क्यूबिट र चौडाइ डेढ क्यूबिट होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","त्यसमा एक-अर्कामा समानान्तर रहेका दुई वटा चोसाहरू होऊन्। समागम पालका सबै फल्याकहरू यस किसिमले नै बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","समागम पालको दक्षिणपट्टिका लागि बीस वटा फल्याकहरू बनाउनू; ");
INSERT INTO npioncb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","अनि ती फल्याकहरूका मुन्तिर चालीस वटा चाँदीका आधारहरू बनाउनू—एउटा फल्याकको लागि दुई वटा आधारहरू, प्रत्येक चोसाको मुनि एउटा। ");
INSERT INTO npioncb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","अर्कोपट्टि समागम पालको उत्तरपट्टि बीस वटा फल्याकहरू बनाउनू; ");
INSERT INTO npioncb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","अनि प्रत्येक फल्याकको मुनि दुई वटा आधार गरेर चाँदीका चालीस वटा आधारहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","पछिल्तिरको भाग, जो समागम पालको पश्‍चिमतिरको भाग हो, त्यसका लागि छ वटा फल्याकहरू बनाउनू; ");
INSERT INTO npioncb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","अनि अन्तिम भागमा भएका कुनाहरूका लागि दुई वटा फल्याकहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","यी कुनाहरूमा फेददेखि टुप्पोसम्म फल्याकहरू दोबर खप्टिएका होऊन्; अनि एउटै मुन्द्रामा जोडिएका होऊन्; दुवै यस्तै होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","यसरी प्रत्येक फल्याकमुनि दुई वटा गरेर जम्मा आठ वटा फल्याकहरू र चाँदीका सोह्र वटा आधारहरू होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“बबुल काठका बारहरू पनि बनाउनू: समागम पालको एकातिरको फल्याकहरूका लागि पाँच वटा, ");
INSERT INTO npioncb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","अर्कोपट्टिका फल्याकहरूका लागि पाँच वटा बार र समागम पालको पश्‍चिमका अन्तिम भागका फल्याकहरूको लागि पाँच वटा बारहरू लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","बीचको बार फल्याकको बीचमा एक छेउदेखि अर्को छेउसम्म पुगोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","फल्याकहरूलाई सुनले मोहोर्नू, र बारहरू अड्काउनका लागि सुनका मुन्द्राहरू बनाउनू। ती बारहरूलाई पनि सुनले मोहोर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“मैले तँलाई पर्वतमा देखाएको नमुनाअनुसार समागम पाल खडा गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“निलो, बैजनी अनि रातो धागो र मसिनो गरी बाटेको सुती कपडा; अनि दक्ष शिल्पकारद्वारा बनाइएका करूबहरू भएका एउटा पर्दा बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","चाँदीका चार वटा आधारहरूमा खडा भएका र सुनले मोहोरेका बबुल काठका चार वटा खम्बाहरूमा त्यसलाई सुनका अङ्कुसेहरूले झुण्ड्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","पर्दालाई अङ्कुसेले झुण्ड्याएर साक्षी पाटीको सन्दुकलाई पर्दाको पछाडि राख्नू। त्यस पर्दाले पवित्रस्थानलाई महा-पवित्रस्थानबाट अलग गर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","महा-पवित्रस्थानमा साक्षी पाटीको सन्दुकको माथि पाप समाधान-स्थान राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","टेबुललाई पर्दा बाहिर समागम पालको उत्तरतिर राख्नू; र सामदानलाई त्यसको विपरीततिर दक्षिणपट्टि राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“पाल प्रवेशद्वारका लागि निलो, बैजनी, रातो रङ्गको धागो र मसिनो गरी बाटेको सुती कपडाले फूल-बुट्टा भएको एउटा पर्दा बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","त्यस पर्दाका लागि सुनका अङ्कुसेहरू र सुनले मोहोरेका बबुलका पाँच वटा खम्बाहरू बनाउनू; अनि तिनीहरूका लागि काँसाका पाँच वटा आधारहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“तैँले बबुल काठको तीन क्यूबिट अग्लो एउटा वेदी बनाउनू; त्यो पाँच क्यूबिट लामो र पाँच क्यूबिट चौडा भएको वर्गाकार होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","चार कुनामा एक-एक वटा सिङ बनाउनू, ताकि सिङहरू र वेदी एउटै टुक्राको होस्; अनि वेदीलाई काँसोले मोहोर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","त्यसका सबै भाँडाहरू काँसाको बनाउनू—त्यसका खरानी उठाउने भाँडाहरू र त्यसका बेल्चाहरू, पानी छर्कने बाटाहरू, मासुको लागि काँटाहरू र आगो राख्ने पात्रहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","त्यसका लागि काँसोको जालीबाट एउटा झिँजा बनाउनू, र जालीका चारै कुनामा एक-एक वटा काँसाका मुन्द्राहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","त्यसलाई वेदीको मुन्तिर यस प्रकारले लगाउनु कि त्यो वेदीको आधा भागसम्म आओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदीका निम्ति बबुल काठका डण्डाहरू बनाएर तिनीहरूलाई काँसोले मोहोर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ती डण्डाहरूलाई मुन्द्राहरूमा यस्तो किसिमले छिराउनू कि वेदीलाई बोक्दा तिनीहरू वेदीका दुई छेउमा होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","फल्याकहरूसित तैँले त्यसलाई खोक्रो गरी बनाउनू। यो तँलाई पर्वतमा देखाइदिएजस्तै गरी बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“समागम पालको लागि एउटा आँगन बनाउनू। त्यसको दक्षिणी भाग एक सय क्यूबिट लामो बनाउनू र त्यसमा मसिनो गरी बाटेको सुती कपडाको पर्दा बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","त्यस पर्दाका लागि बीस वटा खम्बा र काँसाका बीस वटा आधारहरू बनाउनू; अनि ती खम्बाहरूमा चाँदीका अङ्कुसेहरू र फित्ताहरू हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","उत्तरको भाग पनि एक सय क्यूबिट लामो र त्यसमा पर्दाहरू हुनुपर्छ; अनि ती पर्दाहरूका लागि बीस वटा खम्बाहरू र काँसाका बीस वटा आधारहरू र ती खम्बाहरूमा चाँदीका अङ्कुसे र फित्ताहरू हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“आँगनको पश्‍चिमी भागका पर्दाहरू पचास क्यूबिट चौडा हुनुपर्छ। त्यसमा दश वटा खम्बाहरू र दश वटा आधारहरू हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पूर्वतिर, सूर्योदयतर्फ पनि पचास क्यूबिट चौडा हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","मूलढोकाको एकापट्टिका पर्दाहरू पन्ध्र क्यूबिट लामा हुनुपर्छ; जसका तीन वटा खम्बाहरू र तीन वटा आधारहरू हुनुपर्छ, ");
INSERT INTO npioncb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अनि तीन वटा खम्बाहरू र तीन वटा आधार भएका पन्ध्र क्यूबिट लामा पर्दाहरू अर्कोतिर होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“आँगनको प्रवेशद्वारका लागि चार वटा खम्बाहरू र चार वटा आधारहरू भएका, निलो, बैजनी, रातो रङ्गको धागो र मसिनो बाटेको सुती कपडामा बुट्टा भर्नेको शिल्पकारी भएको बीस क्यूबिट लामो एउटा पर्दा बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आँगनको चारैतिरका सबै खाँबाहरूमा चाँदीका अङ्कुसे र फित्ता र काँसाका आधारहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आँगन एक सय क्यूबिट लामो र पचास क्यूबिट चौडा हुनुपर्छ; त्यसमा काँसाका आधार भएका मसिनो बाटेका सुती कपडाका छ क्यूबिट अग्ला पर्दाहरू हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","समागम पालको सेवामा प्रयोग गरिने सबै सामानहरू, पालका किलाहरू, आँगनका किलाहरू लगायत सबै, चाहे तिनीहरूका काम जेसुकै होस्, ती काँसाका हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“इस्राएलीहरूलाई आज्ञा दिनू, कि तिनीहरूले उज्यालोका निम्ति पेलेको जैतुनको शुद्ध तेल ल्याऊन्, र दियाहरू निरन्तर बलिरहून्। ");
INSERT INTO npioncb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","भेट हुने पालमा, साक्षी पाटीको सामु भएको पर्दा बाहिर हारून र त्यसका छोराहरूले याहवेहको सामु साँझदेखि बिहानसम्मै दियाहरू बलिरहने बनाउनुपर्छ। यो इस्राएलीहरूका बीचमा आउने पुस्ताहरूका निम्ति सदा रहिरहने विधि हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“इस्राएलीहरूका बीचबाट तेरा दाजु हारून र त्यसका छोराहरू नादाब, अबीहू, एलाजार अनि ईतामार पुजारी भई मेरो सेवा गर्न भनेर तँकहाँ बोला। ");
INSERT INTO npioncb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","तेरा दाजु हारूनलाई मर्यादा र सम्मान दिनलाई त्यसका निम्ति पवित्र पोशाकहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","मैले यस्ता कामका लागि बुद्धि दिएका सबै दक्ष मानिसहरूलाई भन् कि तिनीहरूले हारूनलाई पुजारी भई मेरो सेवा गर्न नियुक्त गर्नका लागि पोशाकहरू बनाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","तिनीहरूले बनाउनुपर्ने पोशाकहरू यिनै हुन्: छाती-पाता, एपोद, अलखा, बुनेको कुर्ता, फेटा र पटुका। तिनीहरूले यी पवित्र पोशाकहरू तेरा दाजु हारून र त्यसका छोराहरूका निम्ति पुजारी भई मेरो सेवा गर्नका लागि बनाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","तिनीहरूले सुन, निलो, बैजनी र रातो धागो अनि मसिनो सुती कपडा चलाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“एपोदचाहिँ सुन, निलो, बैजनी र रातो धागोका अनि मसिनो बाटेको सुती कपडाका सिपालु शिल्पकारको काम भएको बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","त्यसमा दुई कुनामा जोडिएका अनि बाँध्न सकिने काँधका दुई वटा टुक्राहरू हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","त्यसको सिपालु गरी बुनेको पटुका अनि एपोदसित एउटै भएको, र त्यो सुन अनि निलो, बैजनी र रातो धागो अनि मसिनोसित बाटेको सुती कपडाले बनिएको हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“दुई वटा गोमेद पत्थर लिएर त्यसमा इस्राएलका छोराहरूका नाम खोप्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ती तिनीहरूका जन्मअनुसार एउटा पत्थरमा छ वटा नामहरू र अर्कोमा बाँकी रहेका नामहरू खोप्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","इस्राएलका छोराहरूका नाम ती दुई पत्थरहरूमा शिल्पकारले जसरी छाप खोप्छ, त्यसरी नै खोप्नू। त्यसपछि ती पत्थरहरूलाई सुनका मणिघरमा राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","तिनीहरूलाई इस्राएलका छोराहरूका निम्ति सम्झना गराउने पत्थरझैँ एपोदका काँधे-जोर्नीहरूमा कसिदिनू। हारूनले ती नामहरू सम्झनाझैँ याहवेहको सामु आफ्नो काँधमा बोक्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","सुनका मणिघर बनाउनू ");
INSERT INTO npioncb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","र निखुर सुनका डोरीझैँ बाटेका दुई वटा सिक्रीहरू बनाएर ती सिक्रीहरूलाई सुनका मणिघरमा जोड्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“न्याय गर्नका लागि एउटा छाती-पाता दक्ष शिल्पकारद्वारा बनाउनू। त्यसलाई एपोदझैँ सुनको, निलो, बैजनी र रातो धागो अनि मसिनो गरी बाटेको सुती कपडाको बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","त्यो एक बित्ता लामो र एक बित्ता चौडा, वर्गाकार, दोबर पट्याइएर बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","त्यसपछि त्यसमा चार पङ्‌क्ति बहुमूल्य पत्थरहरू जोड्नू। पहिलो पङ्‌क्तिमा माणिक, पुष्पराज र पन्‍ना; ");
INSERT INTO npioncb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दोस्रो पङ्‌क्तिमा फिरोजा, नीलमणि र हीरा; ");
INSERT INTO npioncb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तेस्रो पङ्‌क्तिमा धूम्रकान्त, सूर्यकान्त र नीलमणि; ");
INSERT INTO npioncb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","र चौथो पङ्‌क्तिमा फिरोज, गोमेद र स्फटिक लगाउनू। अनि ती सुनको मणिघरहरूमा जड्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","बाह्र पत्थरहरूमा इस्राएलका बाह्र कुलहरू जनाउन प्रत्येकमा छापमा खोपेझैँ एक-एक गरी इस्राएलका छोराहरूका नाम हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“छाती-पाताको निम्ति डोरीजस्तो निखुर सुनको बाटेका सिक्रीहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","त्यसका लागि सुनका दुई वटा मुन्द्राहरू बनाएर छाती-पाताको दुई किनारमा बाँध्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","सुनका ती दुई सिक्रीहरूलाई छाती-पाताको किनारका मुन्द्रीमा बाँध्नू, ");
INSERT INTO npioncb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","अनि सिक्रीका अरू छेउहरूलाई अगिल्तिर भएको एपोदका काँधे-जोर्नीहरूका अगाडिपट्टि मिलाएर दुवैलाई सुनका मणिघरहरूमा बाँध्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","सुनका दुई वटा मुन्‍द्रा बनाएर एपोदको अर्का दुई भित्री किनारमा भएको छाती-पाताको अर्का छेउहरूमा लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","सुनका अझ अरू दुई वटा मुन्द्रीहरू बनाएर एपोदको अगाडिपट्टि पटुकाको ठिक माथि जोडिएको भागको नजिक, काँधे टुक्राको फेदमा लगाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","छाती-पाताका मुन्द्राहरूलाई, छाती-पाता एपोदबाट नहल्‍लिओस् भनेर त्यसलाई कम्मरको पटुकासित जोडेर एपोदको मुन्द्रीसित निलो डोरीले बाँध्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“जहिले-जहिले हारून पवित्रस्थानमा प्रवेश गर्नेछ, त्यसले याहवेहको सामु सधैँको सम्झनाको रूपमा इस्राएलका छोराहरूका नाम आफ्नो हृदयमा निर्णयको छाती-पातामा राख्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","जहिले-जहिले हारून याहवेहको उपस्थितिमा पस्‍नेछ, ऊरीम र तुम्मीम पनि त्यसको हृदयमा रहोस् भनेर तिनलाई पनि छाती-पातामा लगाउनू। यसरी हारूनले इस्राएलीहरूको निर्णय लिने साधनलाई याहवेहको सामु सधैँ आफ्नो हृदयमाथि बोक्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एपोदको अलखा सबै निलो कपडाको बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","त्यसको बीचमा टाउको छिराउनको लागि खुला भाग राख्नू। त्यो नफाटोस् भनेर त्यस खुला भागको चारैतिर बुनेको बिट होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","लबेदाको बिटको चारैतिर बीच-बीचमा सुनको घण्टी राखेर निलो, बैजनी र रातो धागोका दारिमहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","सुनका घण्टीहरू र दारिमहरू एउटाको पछि अर्को गरेर लबेदाको बिटको चारैतिर होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारूनले सेवा गर्दा त्यो लगाउनैपर्छ। ऊ याहवेहको उपस्थितिमा पवित्रस्थानभित्र पस्दा र बाहिर निस्कँदा, ती घण्टीहरूका आवाज सुनियोस् र हारून नमरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“तैँले निखुर सुनको एउटा पाता बनाएर औँठीको छापमा खोप्नूः याहवेहका निम्ति पवित्र। ");
INSERT INTO npioncb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","त्यसलाई फेटामा लगाउनको लागि त्यसमा निलो डोरी कस्‍नू। यो टोपीको अगिल्तिर होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","यो हारूनको निधारमा हुनेछ, र इस्राएलीहरूले जुनसुकै भेटी चढाए पनि तिनीहरूले पवित्र भेटीहरू चढाएको काममा रहेको दोष हारूनले बोक्नेछ। तिनीहरू याहवेहकहाँ ग्रहणयोग्य होऊन् भनेर त्यो सधैँ हारूनको निधारमा रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“लबेदा मसिनो सुती कपडाले बुन्‍नू र टोपी मसिनो सुती कपडाको बनाउनू। पटुका बुट्टा भर्नेले गरेको काम हुनुपर्दछ। ");
INSERT INTO npioncb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","हारूनका छोराहरूका निम्ति तिनीहरूलाई मर्यादा र सम्मान दिनलाई लबेदा, पटुका र टोपी बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","तैँले आफ्ना दाजु हारून र त्यसका छोराहरूलाई यी वस्त्रहरू लगाइदिएपछि तिनीहरूलाई अभिषेक गरी नियुक्त गर्नू। तिनीहरूले पुजारी भई मेरो सेवा गरून् भनेर तिनीहरूलाई अर्पण गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“शरीर ढाक्नलाई कम्मरदेखि जाँघसम्म पुग्ने सुतीका भित्री पोशाकहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","हारून र त्यसका छोराहरू जहिले-जहिले समागम पालभित्र पस्छन् अथवा पवित्रस्थानमा सेवा गर्न वेदीको छेउमा जान्छन्, ती लगाऊन्, ताकि तिनीहरू दोष लागेर नमरून्। “यो हारून र त्यसका सन्ततिका निम्ति सधैँ रहिरहने धार्मिक विधि हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“तिनीहरूले पुजारी भई मेरो सेवा गरून् भनेर तिनीहरूलाई यसरी अर्पण गर्नू: एउटा बहर र दुई वटा निष्खोट भेडाहरू ल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","अनि गहुँको मसिनो पिठोबाट खमिर नमिसाइएको रोटी र जैतुन तेल मिसाइएको अखमिरी बाबर र तेल छर्केको पातलो अखमिरी रोटी बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","तिनीहरूलाई एउटा टोकरीमा हाल्नू, र त्यो बहर र दुई वटा भेडाहरूसहित ल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","त्यसपछि हारून र तिनका छोराहरूलाई भेट हुने पालको प्रवेशद्वारमा ल्याउनु र तिनीहरूलाई पानीले नुहाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","पोशाकहरू लिएर हारूनलाई लबेदा, एपोदको पोशाक, एपोद र छाती-पाता लगाइदिनू। निपूर्णतासित बुट्टा काढेको पटुकाले त्यसको शरीरमा एपोद बाँधिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","त्यसको शिरमा फेटा लगाएर त्यसमा पवित्र मुकुट लगाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","त्यसपछि अभिषेक गर्ने तेल लिएर त्यसको शिरमा त्यो खन्याएर त्यसलाई अभिषेक गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","अनि त्यसका छोराहरूलाई ल्याएर तिनीहरूलाई लबेदा पहिर्‍याइदिनू, ");
INSERT INTO npioncb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","र तिनीहरूलाई शिरमा फेटा लगाइदिनू। त्यसपछि हारून र त्यसका छोराहरूलाई पटुका बाँधिदिनू। सदाको धार्मिक विधिद्वारा पुजारी पद तिनीहरूकै हुनेछ। “यसरी तैँले हारून र त्यसका छोराहरूलाई अभिषेक गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“त्यस बहरलाई भेट हुने पालको सामु ल्याउनू; अनि हारून र त्यसका छोराहरूले त्यसमाथि आफ्ना हात राख्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","बहरलाई याहवेहको उपस्थितिमा भेट हुने पालको प्रवेशद्वारमा बलि चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","त्यस बहरको रगतबाट केही लिएर त्यसलाई तेरो औँलाले वेदीका सिङहरूमाथि लगाउनू, र बाँकी रहेको रगत वेदीको जगमा खन्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","त्यसपछि भित्री अङ्गहरूका वरिपरि भएका सबै बोसो, कलेजोलाई छोप्ने जालो, र दुवै मिर्गौलाहरू र त्यसमाथि भएका बोसोसमेत लिएर वेदीमाथि जलाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","तर बहरको मासु, त्यसको छाला र त्यसको गोबर छाउनी बाहिर जलाउनू। यो पाप शुद्धीकरण बलि हो। ");
INSERT INTO npioncb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ती दुई बोकाहरूमध्ये एउटा बोका लिनू, र हारून र त्यसका छोराहरूले त्यसको शिरमाथि हात राख्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","भेडालाई मार्नू र त्यसको रगत लिएर त्यसलाई वेदीको चारैतिर भित्तामा छर्कनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","त्यस भेडालाई टुक्रा-टुक्रा गरी काटेर त्यसका भित्री भागहरू र खुट्टाहरू धुनू, र तिनीहरूलाई टाउको र अरू टुक्राहरूसित राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","त्यसपछि सम्पूर्ण भेडालाई वेदीमा जलाउनू। योचाहिँ याहवेहलाई मनपर्दो मिठो बास्‍ना भएको आगोद्वारा चढाइएको होमबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“तैँले अर्को भेडा लिनू, हारून र त्यसका छोराहरूले त्यसको शिरमा हात राख्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","त्यस भेडालाई मार्नू, त्यसबाट केही रगत लिएर हारून र त्यसका छोराहरूका दाहिने कानका लोतीमा, तिनीहरूका दाहिने हातका बूढी औँलामा, र दाहिने खुट्टाका बूढी औँलामा लगाउनू। त्यसपछि वेदीका चारै भित्तामा रगत छर्कनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","त्यसपछि वेदीको केही रगत र केही अभिषेक गर्ने तेल लिएर त्यसलाई हारून र त्यसका पोशाकहरूमा, त्यसका छोराहरू र तिनीहरूका पोशाकहरूमा छर्कनू। त्यसपछि त्यो, त्यसका छोराहरू र तिनीहरू सबैका पोशाकहरूसमेत पवित्र हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“त्यस भेडाबाट बोसो, बोसे पुच्छर, भित्री भागहरूलाई छोप्ने बोसो, कलेजो बाहिरको जाली, दुवै मिर्गौलाहरू र तिनीहरूमाथिका बोसोसमेत र दाहिने फिला लिनू। (यो भेडा अर्पणका लागि हो।) ");
INSERT INTO npioncb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","याहवेहको सामु राखिएको टोकरीको खमिर नमिसाइएको रोटीबाट एउटा, र तेलमा पोलेको एउटा बाबर अनि एउटा फुलौरो लिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","यी सबैलाई हारून र त्यसका छोराहरूका हातमा विशेष भेटीको रूपमा उचालिनका लागि याहवेहको सामु ल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","त्यसपछि ती सबैलाई उनीहरूका हातबाट लिएर होमबलिका निम्ति याहवेहका लागि मनपर्दो बास्‍नाका निम्ति आगोद्वारा चढाइएको भेटीका साथमा वेदीमाथि जलाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","अनि तैँले हारूनको निम्ति हुने अर्पणका निम्ति भेडाको ह्‍याकुला लिनू, र त्यसलाई विशेष भेटीको रूपमा उचालिनका निम्ति याहवेहको सामु ल्याउनू, र त्यो तेरो भाग हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“अर्पण गर्ने भेडाका ती भागहरू, जुन हारून र त्यसका छोराहरूका भाग हुन्, ती अर्पण गर्नू: डोलाएको ह्‍याकुला र उचालिएको फिला। ");
INSERT INTO npioncb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","त्यो इस्राएलीहरूका तर्फबाट हारून र त्यसका छोराहरूका निम्ति नियमित भाग हो। यो इस्राएलीहरूले आफ्ना मेलबलिबाट याहवेहलाई चढाउनुपर्ने भाग हो। ");
INSERT INTO npioncb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारूनका पवित्र पोशाकहरू त्यसका सन्ततिहरूका निम्ति हुनेछन्; ताकि तिनीहरू तिनै पोशाकहरूमा अभिषेक र अर्पण होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","त्यसको पछि पुजारीको उत्तराधिकारी हुने छोराले पवित्रस्थानमा सेवा गर्न समागम पालमा आउँदा ती लुगाहरू सात दिनसम्म लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“अर्पणको बोका लिएर त्यसको मासु एउटा पवित्र ठाउँमा पकाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","समागम पालको प्रवेशद्वारमा हारून र त्यसका छोराहरूले त्यस भेडाको मासु र टोकरीमा भएको रोटी खाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","तिनीहरूले आफ्ना अभिषेक र अर्पणका लागि प्रायश्‍चित गरिएका ती भेटीहरू खाऊन्, तर अरू कसैले पनि ती नखाओस्; किनकि ती पवित्र हुन्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","यदि अर्पणको बोकाको मासुको केही भाग अथवा केही रोटी बिहानसम्म उब्रियो भने त्यसलाई जलाइदिनू। त्यो खान हुँदैन; किनकि त्यो पवित्र छ। ");
INSERT INTO npioncb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“तँलाई मैले दिएको आज्ञाबमोजिम हारून र त्यसका छोराहरूलाई सात दिन लगाएर नियुक्त गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","प्रायश्‍चित गर्नका लागि प्रत्येक दिन पाप शुद्धीकरण बलिको रूपमा एउटा बहर बलिदान गर्नू। प्रायश्‍चित गरेर वेदीलाई शुद्ध गर्नू; त्यसलाई पवित्र गर्नका लागि अभिषेक गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिनसम्म वेदीको लागि प्रायश्‍चित गर्नू र त्यसलाई पवित्र पार्नू, तब वेदी महा-पवित्र हुनेछ; अनि त्यसलाई छुने जेसुकै पनि पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“तैँले वेदीमा प्रत्येक दिन नियमित रूपले चढाउनुपर्ने कुराहरू यिनै हुन्: एकवर्षे दुई वटा थुमाहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","एउटा थुमा बिहान र अर्को थुमा साँझमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","पहिलो थुमाको साथमा एपाको दशौँ भाग मसिनो पिठोसित पेलिएको जैतुनको चौथाइ हिन तेल मिसाएर अनि अर्घबलिको रूपमा चौथाइ हिन दाखमद्य चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","अर्को थुमालाई पनि साँझमा बिहानजस्तै अन्‍नबलि र अर्घबलिका साथमा चढाउनू—जुन याहवेहलाई मनपर्दो बास्‍नाको रूपमा आगोद्वारा चढाइएको बलि होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“आउने पुस्ताका लागि यो होमबलि भेट हुने समागम पालको प्रवेशद्वारमा याहवेहका निम्ति नियमित रूपले चढाइयोस्। त्यहाँ म तँलाई भेट्नेछु, र तँसित बोल्नेछु; ");
INSERT INTO npioncb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","त्यहाँ म इस्राएलीहरूसित पनि भेट गर्नेछु, र त्यो ठाउँ मेरो महिमाले पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“यसरी म समागम पाललाई र वेदीलाई पवित्र पार्नेछु; अनि मेरो निम्ति पुजारी भई सेवा गर्नलाई हारून र त्यसका छोराहरूलाई पवित्र गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","तब म इस्राएलीहरूका बीचमा बास गर्नेछु र तिनीहरूका परमेश्‍वर हुनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","म तिनीहरूबीच बास गरूँ भनेर तिनीहरूलाई इजिप्टबाट निकालेर ल्याउने म याहवेह नै तिनीहरूका परमेश्‍वर हुँ भनी तिनीहरूले जान्‍नेछन्। म याहवेह नै तिनीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“तैँले धूप बाल्नलाई बबुल काठको एउटा वेदी बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","त्यो वर्गाकार होस्। त्यो एक क्यूबिट लामो, एक क्यूबिट चौडा, र दुई क्यूबिट उचाइ होस्। त्यसका सिङहरू त्यससित एउटै टुक्राको होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","त्यसको टुप्पो र सबै भित्ताहरू र सिङहरूलाई निखुर सुनले मोहोर्नू; अनि त्यसको चारैतिर सुनको बिट बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","वेदीलाई बोक्ने डण्डाहरू अड्काउनलाई बिटको मुन्तिर दुवैतिर दुई वटा मुन्द्राहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ती डण्डाहरू बबुल काठका बनाउनू र तिनीहरूलाई सुनले मोहोर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","वेदीलाई साक्षी पाटीको सन्दुकको अगिल्तिर भएको पर्दाको सामु राख्नू। साक्षी पाटीको माथि रहेको पाप समाधान-स्थानको सामु, जहाँ म तँसित भेट गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“हारूनले प्रत्येक बिहान बत्तीहरू मिलाउँदा वेदीमा सुगन्धित धूप जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","त्यसले साँझमा बत्तीहरू बाल्दा फेरि धूप जलाओस् र आउने पुस्ताहरूका लागि याहवेहको सामु धूप नियमित रूपले जल्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","त्यस वेदीमा अरू कुनै किसिमका धूप अथवा होमबलि अथवा अन्‍नबलि नचढाउनू र त्यसमाथि कुनै अर्घबलि पनि नचढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारूनले वर्षमा एकपल्ट सिङहरूमा प्रायश्‍चित गर्नेछ। यो वार्षिक प्रायश्‍चित आउने पुस्ता-पुस्ताका लागि प्रायश्‍चितको पाप शुद्धीकरण बलिको रगतसित गरिनुपर्छ। याहवेहका निम्ति यो अति पवित्र हो।” ");
INSERT INTO npioncb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“जब तैँले इस्राएलीहरूको गन्ती लिनलाई तिनीहरूको जनगणना गर्नेछस्, तब प्रत्येकले आफ्नो गन्तीको समयमा त्यसको प्राणका लागि याहवेहलाई छुटकाराको मोल तिरोस्। तब तैँले तिनीहरूलाई गन्ती गर्दा तिनीहरूमाथि कुनै विपत्ति आउनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","हरेक जो गन्ती भइसकेकाहरूपट्टि पार गरेर जान्छ, त्यसले पवित्रस्थानको शेकेलको हिसाबले आधा शेकेल दिनुपर्नेछ (एक शेकेल बराबर बीस गेरा हुन्छ)। त्यो आधा शेकेल याहवेहका निम्ति भेटी हो। ");
INSERT INTO npioncb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","बीस वर्ष र त्योभन्दा बढी उमेर पुगेका जति जना गनिन्छन्, सबैले याहवेहका निम्ति भेटी देऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","तिमीहरूले आफ्नो प्रायश्‍चितका लागि याहवेहलाई भेटी चढाउँदा धनीहरूले आधा शेकेलभन्दा बढी र गरिबहरूले त्योभन्दा कम नदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्राएलीहरूबाट प्रायश्‍चितको रकम लिएर त्यसलाई भेट हुने पालको सेवाका निम्ति प्रयोग गर्नू। तिमीहरूले आफ्नो प्राणको प्रायश्‍चित गर्दा याहवेहको सामु इस्राएलीहरूका निम्ति यो एउटा सम्झनास्वरूप हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","तब याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“धुनको लागि काँसोको खुट्टा भएको काँसोका धुने बाटा बनाउनू। त्यसलाई समागम पाल र वेदीको बीचमा राखेर त्यसमा पानी भर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून र त्यसका छोराहरूले त्यसमा भएको पानीले आफ्ना हातगोडा धोऊन्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जब तिनीहरू समागम पालभित्र पस्छन्, तब हातगोडा धोएर मात्र पसून्, ताकि तिनीहरू नमरून्। साथै, जब तिनीहरू वेदीनेर सेवा गर्नलाई याहवेहका निम्ति अग्निबलि जलाउनलाई आउँछन्, ");
INSERT INTO npioncb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","तब तिनीहरूले पानीले हातगोडा धोऊन्, र तिनीहरू नमरून्। यो हारून र त्यसका सन्ततिका निम्ति तिनीहरूका पुस्ता-पुस्तासम्मका निम्ति अनन्तको धार्मिक विधि होस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","तब याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“निम्न लिखित असल मसाला लिनू: पाँच सय शेकेल तरल मूर्र, त्यसको आधा अथवा दुई सय पचास शेकेल बास्‍ना आउने दालचिनी, दुई सय पचास शेकेल सुगन्धित बोझो, ");
INSERT INTO npioncb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","पाँच सय शेकेल तेजपात। सबै समागम पालको शेकेलको हिसाबले, र एक हिन जैतुनको तेल। ");
INSERT INTO npioncb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","यी सबैबाट अभिषेकको पवित्र तेल बनाउनू, र बनाउने सिपालु व्यक्तिले बनाएको बास्‍नायुक्त होस्। त्यो अभिषेक गर्ने पवित्र तेल हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","तब त्यस तेललाई समागम पाल, साक्षीको सन्दुक, ");
INSERT INTO npioncb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","टेबुल र त्यसमा भएका सम्पूर्ण सामग्रीहरू, सामदान र त्यसका अरू उपकरणहरू, धूपको वेदी, ");
INSERT INTO npioncb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","अनि होमबलिको वेदी र त्यसका सबै भाँडाहरू र बाटा, र त्यसलाई उभ्याउने चीजसमेत सबैलाई अभिषेक गर्नलाई प्रयोग गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","तैँले यी सबै कुराहरू पवित्र गर्नू, र तिनीहरू अति पवित्र हुनेछन्। जेसुकैले तिनीहरूलाई छोए तापनि त्यो पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“हारून र त्यसका छोराहरूलाई अभिषेक गरेर पवित्र गर्नू, र तिनीहरूले पुजारी भई मेरो सेवा गरून्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएलीहरूलाई भन्, ‘यो आउने पुस्ताहरूका लागि मेरो पवित्र अभिषेकको तेल होस्। ");
INSERT INTO npioncb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यसलाई अरू कुनै मानिसहरूका शरीरहरूमा नखन्याउनू र यही तरिकाले कुनै तेल नबनाउनू। यो पवित्र हो, र तैँले यसलाई पवित्र ठान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","जसले यस्तै सुगन्धित तेल बनाउँछ र जसले यसलाई पुजारीबाहेक अरूमाथि लगाउँछ, त्यसलाई आफ्ना मानिसहरूबाट बहिष्कार गरिनुपर्छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","तब याहवेहले मोशालाई भन्‍नुभयो, “सुगन्धित मसलाहरू—कुन्द, धूप, नखी र सालधूप—अनि शुद्ध मूर्र सबै एकै परिमाणमा लिनू, ");
INSERT INTO npioncb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","अनि अत्तर बनाउनमा सिपालु व्यक्तिद्वारा सुगन्धित धूप बनाउनू। त्यसमा नुन हाल्नुपर्छ, र त्यो शुद्ध र पवित्र हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","त्यसको केही भाग पिँधेर पिठो बनाउनू, र त्यसलाई समागम पालको साक्षी पाटीको सामु राख्नू, जहाँ म तँलाई भेट्नेछु। यो तेरा निम्ति अति पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","यस तरिकाले तिमीहरूले आफ्नो निम्ति कुनै धूप नबनाउनू; यसलाई याहवेहका निम्ति पवित्र ठान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","जसले यस सुगन्धको आनन्द लिनलाई यस्तो बनाउँछ, त्यसलाई आफ्ना मानिसहरूबाट बहिष्कार गरिनुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","तब याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“हेर्, मैले यहूदा कुलको हूरको नाति ऊरीको छोरा बजलेललाई चुनेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","अनि मैले त्यसलाई मेरो आत्मा, बुद्धि, समझ, ज्ञान र कारिगरीका सबै दक्षताले भरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","त्यसले सुन, चाँदी र काँसोका कामहरू, ");
INSERT INTO npioncb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","पत्थर काटेर जड्ने काम, काठको काम, र सबै किसिमका कारिगरी गर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","यसबाहेक त्यसलाई सघाउन भनी मैले दानको कुलको अहीसामाकको छोरा ओहोलीआबलाई नियुक्त गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“समागम पाल, साक्षी पाटीको सन्दुक, र त्यसमाथि भएको पाप समाधान-स्थान, र पालका अरू सबै सामग्रीहरू— ");
INSERT INTO npioncb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","टेबुल र त्यसका सामग्रीहरू, निखुर सुनको सामदान र त्यसका सबै सामग्रीहरू, धूपको वेदी, ");
INSERT INTO npioncb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमबलिको वेदी र त्यसका सबै पात्रहरू, काँसोका बाटा र त्यसलाई उभ्याउने सामानहरू— ");
INSERT INTO npioncb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","बुनेका पोशाकहरू पनि, हारून पुजारीका पवित्र पोशाकहरू, पुजारी भई सेवा गर्दा लगाउने तिनका छोराहरूका पोशाकहरू, ");
INSERT INTO npioncb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेक गर्ने तेल र पवित्रस्थानको लागि सुगन्धित धूप। ");
INSERT INTO npioncb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","तब याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इस्राएलीहरूलाई भन्, ‘तिमीहरूले मेरो शब्बाथ दिन पालन गर्नू। आउने पुस्ताहरूका लागि मेरो र तिमीहरू बीचको चिन्ह यो हुनेछ, ताकि तिमीहरूले जान्‍नेछौ कि म याहवेह हुँ, जसले तिमीहरूलाई पवित्र बनाउँछु। ");
INSERT INTO npioncb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘शब्बाथ दिन मान्‍नू; किनकि यो दिन तिमीहरूका लागि पवित्र छ। जसले यसलाई अपवित्र पार्छ, त्यो मारिनुपर्छ; जसले यस दिनमा काम गर्छ, त्यसलाई मानिसहरूबाट बहिष्कार गरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","छ दिनसम्म काम गरिनुपर्छ, तर सातौँ दिनचाहिँ शब्बाथ दिन हो, जुन याहवेहका निम्ति पवित्र छ। जसले शब्बाथ दिनमा काम गर्छ, त्यो मारिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएलीहरूले शब्बाथ दिनलाई आउने पुस्ताहरूका लागि सधैँको करारको रूपमा मनाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","मेरो र इस्राएलीहरूको बीचमा यो अनन्तका लागि चिन्ह हुनेछ; किनकि याहवेहले छ दिनमा आकाश र पृथ्वी बनाउनुभयो; अनि सातौँ दिनमा उहाँले काम गर्नुभएन, तर आरामले विश्राम लिनुभयो।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","परमेश्‍वरले मोशासित सीनै पर्वतमा कुरा गरिसक्नुभएपछि उहाँका आफ्ना औँलाले लेखेका दुई वटा साक्षीका ढुङ्गा पाटीहरू उनलाई दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","जब मानिसहरूले मोशा पर्वतबाट आउन ढिलो गरेका देखे, तब तिनीहरू हारूनका वरिपरि भेला भएर भने, “उठ्नुहोस्, हाम्रा अगि-अगि जानलाई हाम्रा निम्ति देवी-देवताहरू बनाउनुहोस्। हामीलाई इजिप्टबाट बाहिर निकालेर ल्याउने यी मोशालाई के भयो, हामी जान्दैनौँ।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारूनले तिनीहरूलाई जवाफ दिए, “तिमीहरूका पत्नीहरू र तिमीहरूका छोराछोरीहरूले लगाइराखेका कानका सुनका कुण्डलहरू फुकालेर मकहाँ ल्याओ।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","यसकारण सबै मानिसहरूले आफ्ना कुण्डलहरू फुकालेर हारूनकहाँ ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","तिनीहरूले दिएका ती चीजहरू हारूनले लिए, र त्यसलाई ढालेर हतियारले खोपेर त्यसबाट एउटा बाछाको मूर्ति बनाए। तब तिनीहरूले भने, “हे इस्राएल, तँलाई इजिप्टबाट निकालेर ल्याउने देवता यिनै हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","जब हारूनले यो देखे, तिनले त्यस बाछाको सामु एउटा वेदी बनाएर घोषणा गरे, “भोलि याहवेहका निम्ति एउटा चाड हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","यसकारण भोलिपल्ट मानिसहरूले बिहानै उठेर होमबलि चढाए र मेलबलि पनि ल्याए। त्यसपछि तिनीहरू खानपिन गर्न बसे, र मोज गर्न उठे। ");
INSERT INTO npioncb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब याहवेहले मोशालाई भन्‍नुभयो, “तल ओर्ली; किनकि तैँले इजिप्टबाट निकालेर ल्याएका तेरा मानिसहरू भ्रष्‍ट भएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","मैले तिनीहरूलाई दिएका आज्ञाहरूबाट तिनीहरू चाँडै अर्कोतिर लागेका छन्; र तिनीहरूले आफ्ना लागि ढालिएको एउटा बाछाको रूपमा मूर्ति बनाएका छन्। तिनीहरूले त्यसलाई ढोगेर बलिहरू चढाएर भनेका छन्, ‘हे इस्राएल, तँलाई इजिप्टबाट निकालेर ल्याउने तेरा देवता यिनै हुन्।’ ");
INSERT INTO npioncb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“याहवेहले मोशालाई भन्‍नुभयो, ‘मैले यी मानिसहरूलाई देखेको छु; यिनीहरू हठी मानिसहरू हुन्।’ ");
INSERT INTO npioncb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","अब मलाई नरोक्, र मेरो क्रोध यिनीहरूका विरुद्धमा दन्कियोस्, र म यिनीहरूलाई भस्म पार्नेछु। तब म तँबाट नै एउटा महान् जाति बनाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तर मोशाले याहवेह आफ्ना परमेश्‍वरबाट कृपा मागेर भने, “हे याहवेह, तपाईंले महान् शक्ति र सामर्थी हातले इजिप्टबाट ल्याउनुभएको आफ्नो जातिको विरुद्धमा तपाईंको क्रोध किन यति साह्रो दन्केको छ? ");
INSERT INTO npioncb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","‘उहाँले तिनीहरूलाई पहाडी ठाउँहरूमा मारेर यस पृथ्वीबाट तिनीहरूको नामनिशानै मेटिदिने नराम्रो विचार लिएर तिनीहरूलाई निकालेर ल्याउनुभयो,’ भनेर इजिप्टियनहरूले किन भन्‍न पाऊन्? तपाईंको भयानक क्रोध त्याग्नुहोस्; शान्त हुनुहोस्, र आफ्ना जातिमाथि विपत्ति नल्याउनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","तपाईंका सेवकहरू अब्राहाम, इसहाक र याकोबलाई सम्झनुहोस्, जसलाई तपाईंले यसो भनी आफ्नै नाममा शपथ खानुभएको थियो: ‘म तेरा सन्ततिलाई आकाशका ताराहरूझैँ धेरै बनाउनेछु, र मैले तिनीहरूसित प्रतिज्ञा गरेको देश दिनेछु; अनि त्यो अनन्तसम्मका लागि तिनीहरूको उत्तराधिकार हुनेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","तब याहवेह शान्त हुनुभयो, र आफूले चेतावनी दिनुभएको विपत्ति आफ्ना मानिसहरूमाथि ल्याउनुभएन। ");
INSERT INTO npioncb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","मोशा फर्के, र करारका ती दुई ढुङ्गाका पाटीहरू लिएर पर्वतदेखि तल ओर्ले। ती अगाडि र पछाडि, दुवैतिर खोपिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ती पाटीहरू परमेश्‍वरका काम थिए; त्यो लेखोट पाटीहरूमा खोपिएको परमेश्‍वरको लेखोट थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","यहोशूले मानिसहरू चिच्याएको हल्‍ला सुनेर मोशालाई भने, “तल छाउनीमा लडाइँको आवाज सुनिँदैछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मोशाले जवाफ दिए: “यो सोर न त जित्नेहरूको हो, न हार्नेहरूको हो; म त गाउनेहरूको आवाज पो सुन्दैछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","जब मोशा छाउनीमा पुगेर बाछाको मूर्ति र नाच देखे, तब तिनी रिसले आगो भए; अनि तिनले ती पाटीहरूलाई आफ्ना हातबाट फ्याँकिदिएर पर्वतको फेदीमा टुक्रा-टुक्रा पारेर फुटाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तिनले उनीहरूले बनाएको बाछा लिएर त्यसलाई आगोमा जलाइदिए, अनि त्यसलाई धुलोपिठो पारिदिए, र त्यसलाई पानीमा छरिदिए; अनि इस्राएलीहरूलाई त्यो पिउन लाए। ");
INSERT INTO npioncb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","अनि मोशाले हारूनलाई भने, “यी मानिसहरूले तपाईंलाई के गरे, र तपाईंले तिनीहरूलाई यति ठूलो पाप गर्न लाउनुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारूनले जवाफ दिए, “मेरा प्रभु, नरिसाउनुहोस्। यी मानिसहरू दुष्‍टतातिर कतिसम्म झुकेका छन्, त्यो तपाईं जान्‍नुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","तिनीहरूले मलाई भने, ‘हाम्रो अगि-अगि जानलाई हाम्रा निम्ति देवी-देवताहरू बनाउनुहोस्। हामीलाई इजिप्टबाट बाहिर निकालेर ल्याउने यी मोशाको विषयमा तिनलाई के भयो हामी जान्दैनौँ।’ ");
INSERT INTO npioncb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","यसकारण मैले तिनीहरूलाई यसो भनेँ, ‘जस-जससित केही सुनका गहना छन्, त्यो फुकालून्।’ तब तिनीहरूले त्यो सुन मलाई दिए; मैले त्यसलाई आगोमा फालिदिएँ, र यसबाट यो बाछा निस्केर आयो।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशाले मानिसहरू असभ्य भइरहेका, र हारूनले तिनीहरूलाई अधीनबाहिर जान दिएर तिनीहरूका शत्रुको निम्ति हाँसोको पात्र बनेका देखे। ");
INSERT INTO npioncb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","यसकारण मोशा छाउनीको प्रवेशद्वारमा उभिएर भने, “जो-जो याहवेहको पक्षमा छ, मकहाँ आओस्।” अनि सबै लेवीहरू तिनीकहाँ भेला भए। ");
INSERT INTO npioncb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","तब तिनले उनीहरूलाई भने, “याहवेह, इस्राएलका परमेश्‍वर यसो भन्‍नुहुन्छ: ‘प्रत्येक मानिसले तरवार भिर्नू। छाउनीको अगि र पछि एक छेउदेखि अर्को छेउसम्म प्रत्येकले आफ्नो दाजुभाइ, मित्र र छिमेकीलाई मार्दै जानू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","लेवीहरूले मोशाले हुकुम दिएझैँ गरे; अनि त्यस दिन प्राय: तीन हजार मानिसहरू मरे। ");
INSERT INTO npioncb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","तब मोशाले भने, “आज तिमीहरू याहवेहका निम्ति अलग गरिएका छौ; किनकि तिमीहरू आफ्नै छोराहरू र दाजुभाइहरूका विरुद्धमा भयौ; अनि उहाँले आजको दिन तिमीहरूलाई आशिष् दिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","भोलिपल्ट मोशाले मानिसहरूलाई भने, “तिमीहरूले ठूलो पाप गरेका छौ। तर अब म याहवेहकहाँ माथि जानेछु; सायद म तिमीहरूका पापको प्रायश्‍चित गर्न सक्छु कि।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","यसकारण मोशा फर्केर याहवेहकहाँ गएर भने, “हाय, यी मानिसहरूले कति ठूलो पाप गरेका छन्! तिनीहरूले आफ्ना निम्ति सुनका देवता बनाएका छन्। ");
INSERT INTO npioncb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","तर अब तिनीहरूका पाप क्षमा गरिदिनुहोस्। यदि गरिदिनुभएन भने त तपाईंले लेख्नुभएको पुस्तकबाट मेरो नामनिशानै मेटिदिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","याहवेहले मोशालाई जवाफ दिनुभयो, “जसले मेरो विरुद्ध पाप गरेको छ, त्यसलाई म मेरो पुस्तकबाट मेटाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","अब जा, मानिसहरूलाई मैले भनेको ठाउँमा डोर्‍याएर लैजा, र मेरा दूत तेरो अगि-अगि जानेछन्। तरै पनि जब मैले दण्ड दिने समय आउँछ, म तिनीहरूका पापको निम्ति तिनीहरूलाई दण्ड दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","अनि तिनीहरूले हारूनले बनाएका बाछालाई जे गरेका थिए, त्यसैको कारण याहवेहले मानिसहरूलाई रूढीले मार्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","तब याहवेहले मोशालाई भन्‍नुभयो, “तँ र तैँले इजिप्टबाट निकालेर ल्याएका मानिसहरू यस ठाउँलाई छोडेर मैले अब्राहाम, इसहाक र याकोबलाई शपथद्वारा ‘म यो तिमीहरूका सन्तानहरूलाई दिनेछु’ भनेको देशमा जानू। ");
INSERT INTO npioncb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","म एउटा दूतलाई तिमीहरूको अगि-अगि पठाउनेछु; अनि कनानी, एमोरी, हित्ती, परिज्जी, हिव्वी र यबूसीहरूलाई धपाइदिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दूध र मह बग्ने देशमा जाओ। तर म तिमीहरूसित जानेछैनँ; किनकि तिमीहरू हठी मानिसहरू भएका हुनाले सायद म तिमीहरूलाई बाटैमा नाश गरुँला।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","जब मानिसहरूले यस्तो पीडादायक कुरा सुने, तब तिनीहरूले शोक गर्न थाले; अनि कसैले पनि कुनै गहना लगाएनन्। ");
INSERT INTO npioncb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","किनकि याहवेहले मोशालाई भन्‍नुभएको थियो, “इस्राएलीहरूलाई यसो भन्, ‘तिमीहरू हठी मानिसहरू हौ। यदि म केही समयको लागि मात्र पनि तिमीहरूसित जानुपर्‍यो भने म तिमीहरूलाई भस्म पार्नेछु। अब तिमीहरूका आफ्ना गहनाहरू फुकाल र तिमीहरूलाई के गर्नुपर्छ, सो म निर्णय गर्नेछु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","यसकारण इस्राएलीहरूले होरेब पर्वतमा आफ्ना सबै गहनाहरू फुकाले। ");
INSERT INTO npioncb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","अब मोशाले एउटा पाल लिएर त्यसलाई “समागम पाल” भनेर छाउनीदेखि केही टाढासम्म टाँग्ने गर्थे। याहवेहसित भेट गर्न चाहने जोसुकै पनि छाउनीबाहिर भएको समागम पालमा जान्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","अनि जहिले-जहिले मोशा बाहिर पालमा निस्कन्थे, तब सबै मानिसहरू मोशा पालभित्र नपसुन्जेल आफ्ना पालहरूका प्रवेश द्वारहरूमा हेर्दै उभिरहन्थे। ");
INSERT INTO npioncb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","जब मोशा पालभित्र पस्थे, याहवेह तिनीसित बोल्नुहुँदा बादलको खामो ओर्लेर पालको ढोकामा खडा रहन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","जब-जब मानिसहरू बादलको खामो पालको ढोकामा खडा भएको देख्थे; तिनीहरू आ-आफ्ना पालको ढोकामा उभिएर आराधना गर्दथे। ");
INSERT INTO npioncb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","कुनै मानिस आफ्नो मित्रसित बोलेझैँ याहवेह मोशासित आमने-सामने बोल्नुहुन्थ्यो। त्यसपछि मोशा छाउनीमा फर्कन्थे, तर तिनको जवान सहायक नूनका छोरा यहोशूले पाल छाड्दैनथे। ");
INSERT INTO npioncb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशाले याहवेहलाई भने, “तपाईंले मलाई ‘यी मानिसहरूलाई डोर्‍याउनू,’ भन्दै आउनुभएको छ; तर तपाईंले मसित कसलाई पठाउनुहुनेछ, त्यो भन्‍नुभएको छैन। तपाईंले भन्‍नुभएको छ, ‘म त तँलाई तेरो नामले नै चिन्छु, र तँमाथि मेरो निगाह परेको छ।’ ");
INSERT INTO npioncb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","यदि तपाईं मसित प्रसन्‍न हुनुहुन्छ भने मलाई तपाईंका मार्ग सिकाउनुहोस्, र म तपाईंलाई चिन्‍न सकूँ; अनि तपाईंको निगाह पाइरहन सकूँ। स्मरण रहोस्, यो जाति तपाईंकै मानिसहरू हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","याहवेहले जवाफ दिनुभयो, “मेरो उपस्थिति तँसित जानेछ; अनि म तँलाई विश्राम दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","तब मोशाले उहाँलाई भने, “यदि तपाईंको उपस्थिति हाम्रो साथमा जाँदैन भने त हामीलाई यहाँबाट नलैजानुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","तपाईं हामीसित नगएसम्म म र तपाईंका यी मानिसहरूले तपाईंको निगाह पाएका छौँ भनेर हामीले कसरी जान्‍ने? अरू के कुराले म र तपाईंका मानिसहरू पृथ्वीका सारा मानिसहरूदेखि भिन्‍नै ठहरिन्छौँ?” ");
INSERT INTO npioncb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","तब याहवेहले मोशालाई भन्‍नुभयो, “तैँले भनेकै कुरा म गर्नेछु; किनकि तैँले मेरो दृष्‍टिमा निगाह पाएको छस्; र मैले तँलाई तेरो नामले चिनेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","तब मोशाले भने, “अब मलाई तपाईंको महिमा देखाउनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","याहवेहले भन्‍नुभयो, “म तेरै सामु मेरो सारा भलाइ देखाउनेछु; र तेरै सामु याहवेह नामको घोषणा गर्नेछु। जसलाई म कृपा गर्न चाहन्छु, त्यसलाई म कृपा गर्नेछु। जसलाई म दया देखाउन चाहन्छु, त्यसलाई म दया देखाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","उहाँले भन्‍नुभयो, “तर तैँले मेरो अनुहार हेर्न सक्दैनस्; किनकि मेरो अनुहार हेरेर कुनै मानिस जीवित रहन सक्दैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","त्यसपछि याहवेहले भन्‍नुभयो, “मेरो छेउमा एउटा ठाउँ छ, जहाँ तँ चट्टानमाथि खडा हुन सक्छस्। ");
INSERT INTO npioncb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","जब मेरो महिमा त्यहाँबाट भएर जान्छ; म तँलाई चट्टानको धाँदोमा राख्नेछु; अनि म नगइन्जेल तँलाई आफ्नो हातले छोपिराख्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","त्यसपछि म आफ्नो हात हटाउनेछु, र तैँले मेरो पिठिउँ देख्नेछस्; तर मेरो अनुहारचाहिँ देखिनेछैन।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","याहवेहले मोशालाई भन्‍नुभयो, “पहिलेको जस्तै ढुङ्गाका दुई वटा पाटीहरू काट्, र म तिनीहरूमा तैँले फुटाएको पहिलो पाटीहरूमा भएकै शब्दहरू लेखिदिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","बिहान तयार भएर सीनै पर्वतमा उक्लिआइज। पर्वतको टाकुरामा आफूलाई मकहाँ हाजिर गर्। ");
INSERT INTO npioncb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","पर्वतमा तँसित कोही पनि नआओस्; अथवा पर्वतका कुनै ठाउँमा देखा पनि नपरोस्; कुनै बगाल र बथान पनि पर्वतको सामु नचरोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","यसकारण मोशाले पहिलेको जस्तै ढुङ्गाका दुई वटा पाटीहरू काटेर निकाले, र याहवेहले आज्ञा दिनुभएझैँ बिहानै सीनै पवर्तमा उक्ले। तिनले ढुङ्गाका दुई वटा पाटीहरू आफ्ना हातमा बोके। ");
INSERT INTO npioncb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","तब याहवेह बादलमा तल ओर्लिनुभयो, र त्यहाँ तिनीसित उभिनुभयो; अनि आफ्नो नाम याहवेह भनी घोषणा गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","उहाँ मोशाको सामु यसो भनेर घोषणा गर्दै जानुभयो, “याहवेह, याहवेह, दयालु र अनुग्रही परमेश्‍वर, रिस गर्नमा ढिलो, प्रेम र विश्‍वासयोग्यताले भरिपूर्ण हुनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","उहाँले हजारौँसित प्रेम कायम राख्नुहुन्छ; अनि दुष्‍टता, विद्रोह र पापलाई क्षमा गर्नुहुन्छ। तरै पनि उहाँले दोषीलाई दण्ड नदिई छाड्नुहुन्‍न। पितापुर्खाका दुष्‍टताको दण्ड तिनीहरूका सन्तान, नातिनातिना र तेस्रो अनि चौथो पुस्तासम्म दिनुहुन्छ।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तब मोशाले तुरुन्तै भुइँसम्मै निहुरेर परमेश्‍वरलाई आराधना गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","तिनले भने, “हे प्रभु, यदि मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने तपाईं नै हामीसित हिँड्नुहोस्। यो एउटा हठी जाति भए तापनि हाम्रा दुष्‍टता र पाप क्षमा गरिदिनुहोस्; अनि हामीलाई आफ्नो निज सम्पत्तिको रूपमा लिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","तब याहवेहले भन्‍नुभयो: “म तँसित एउटा करार बाँध्दछु। म तेरा सबै मानिसहरूको सामु यस संसारमा भएका कुनै जातिको बीचमा कहिल्यै पनि नगरिएका अद्‌भुत कार्यहरू गर्नेछु। तँ जुन मानिसहरूसित बस्दछस्, तिनीहरूले म याहवेहले कस्तो महान् काम तिमीहरूका निम्ति गर्नेछु, त्यो देख्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","म तँलाई आज जे आज्ञा दिन्छु, त्यो पालन गर्नू। म तेरो सामु एमोरीहरू, कनानीहरू, हित्तीहरू, परिज्जीहरू, हिव्वीहरू र यबूसीहरूलाई धपाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","तिमीहरू जाने देशमा बस्‍नेहरूसित होशियार हुनू र सम्झौता नगर्नू, नत्रता तिमीहरूका निम्ति तिनीहरू पासो हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","तिनीहरूका वेदीहरू भत्काइदिनू, तिनीहरूका चोखा पत्थरहरू चकनाचुर पारिदिनू र तिनीहरूका अशेराको खाँबो काटेर ढालिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","अरू कुनै देवी-देवताको आराधना नगर्नू; किनकि याहवेह, जसको नाम डाही हो, डाह गर्ने परमेश्‍वर हुनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“त्यस देशमा बस्‍नेहरूसित होशियार हुनू र करार नबाँध्नू; किनकि तिनीहरूले आफ्ना देवी-देवताहरूका अगि व्यभिचार गर्दा र तिनीहरूका लागि बलिदान चढाउँदा तिमीहरूलाई निम्तो दिनेछन्; अनि तिमीहरूले तिनीहरूका बलिदानबाट खानेछौ। ");
INSERT INTO npioncb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","अनि जब तिमीहरूले तिनीहरूका छोरीहरूलाई आफ्ना छोराहरूका निम्ति पत्नी बनाउन रोज्नेछौ, र ती छोरीहरूले आफ्ना देवी-देवताहरूसित व्यभिचार गर्नेछन्; तब तिनीहरूले तिमीहरूका छोराहरूलाई त्यसै गर्न डोर्‍याउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“तिमीहरूले आफ्ना निम्ति मूर्तिहरू नबनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमिरी रोटीको चाड मनाउनू। सात दिनसम्म मैले तिमीहरूलाई आज्ञा दिएझैँ, खमिर नमिसाइएको रोटी खानू। यो आबीब महिनाको तोकिएको समयमा गर्नू; किनकि तिमीहरू त्यही महिनामा इजिप्टबाट निस्केर आएका हौ। ");
INSERT INTO npioncb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“प्रत्येक गर्भको पहिलो फल मेरो हो। तिमीहरूका पशुका सबै भाले, गाईबस्तुका र भेडाबाख्राका पहिले जन्मेका मेरै हुन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","गधैनीको पहिले जन्मेको बछेडालाई पाठो दिएर छुटाउनू; तर तिमीहरूले छुटाएनौ भने त्यसको गर्दन भाँचिदिनू। तिमीहरूका सबै जेठा छोराहरूलाई छुटाउनू। “मेरो सामु कोही खाली हात देखा नपरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“छ दिनसम्म काम गर्नू, तर सातौँ दिनमा विश्राम गर्नू; जोत्ने र कटनी गर्ने समयमा पनि विश्राम गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“गहुँको कटनीबाट पहिलो फल लिएर साताहरूका चाड मनाउनू, र वर्षको अन्तमा अन्‍न भित्र्याउने चाड मनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","वर्षमा तीनपल्ट तेरा सबै पुरुषहरू सार्वभौम याहवेह, इस्राएलका परमेश्‍वरको सामु देखा परून्। ");
INSERT INTO npioncb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","म तिमीहरूका सामु जातिहरूलाई धपाइदिनेछु, र तिमीहरूका सिमाना फैलाइदिनेछु; अनि वर्षमा तीनपल्ट तिमीहरू याहवेह तिमीहरूका परमेश्‍वरको सामु देखा पर्न जाँदा कसैले पनि तिमीहरूका जमिनको लोभ गर्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“तिमीहरूले मलाई बलिदानको रगतसित खमिर भएको कुनै पनि कुरा नचढाउनू, र निस्तार चाडको बलिबाट कुनै पनि भाग बिहानसम्म रहन नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“तिमीहरूका माटोबाट उब्जेका सबैभन्दा असल पहिलो फल याहवेह तिमीहरूका परमेश्‍वरको घरमा ल्याउनू। “बाख्राको पाठो त्यसको माउको दूधमा नपकाउनू।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो, “यी कुराहरू लेख्; किनकि यिनै कुराअनुसार मैले तँ र इस्राएलसँग करार बाँधेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशा त्यहाँ रोटी नखाई र पानी नपिई याहवेहसित चालीस दिन र चालीस रातसम्म रहे। तिनले ती साक्षी पाटीहरूमा त्यस करारका वचन अर्थात् दश आज्ञाहरू लेखे। ");
INSERT INTO npioncb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","जब मोशा सीनै पर्वतबाट आफ्ना हातहरूमा साक्षी पाटीहरू लिएर तल ओर्ले, तब याहवेहसित तिनले कुरा गरेकोले आफ्नो अनुहार चम्कँदैछ भन्‍ने तिनलाई थाहा भएन। ");
INSERT INTO npioncb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","जब हारून र सबै इस्राएलीहरूले मोशालाई देखे, तिनको अनुहार चम्किरहेको थियो; अनि तिनीहरू उनको नजिक आउन डराए। ");
INSERT INTO npioncb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","तर मोशाले तिनीहरूलाई बोलाए। अनि हारून र समुदायका सबै अगुवाहरू तिनीकहाँ फर्केर आए; र तिनले उनीहरूसित कुरा गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","त्यसपछि सबै इस्राएलीहरू तिनको नजिक आए; अनि तिनले तिनीहरू सबैलाई याहवेहले तिनलाई सीनै पर्वतमा दिनुभएका सबै आज्ञाहरू दिए। ");
INSERT INTO npioncb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","मोशाले तिनीहरूसित कुरा गरिसकेपछि तिनले आफ्नो अनुहारमाथि घुम्टो लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","तर जब मोशा याहवेहसित कुरा गर्न उहाँको उपस्थितिमा जान्थे, आफू बाहिर ननिस्कुन्जेल घुम्टो उतार्थे। अनि तिनी बाहिर आएर तिनले के आज्ञा पाए, सो इस्राएलीहरूलाई सुनाइदिँदा ");
INSERT INTO npioncb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएलीहरूले तिनको अनुहार चम्केको देख्थे। याहवेहसित कुरा गर्न भित्र नगएसम्म मोशाले फेरि आफ्नो अनुहारमाथि त्यो घुम्टो लगाउँथे। ");
INSERT INTO npioncb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशाले इस्राएलीहरूका सारा समुदायलाई भेला गरेर भने, “याहवेहले तिमीहरूलाई यी कुराहरू पालना गर्न आज्ञा दिनुभएको छ: ");
INSERT INTO npioncb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","छ दिनसम्म काम गर्नू, तर सातौँ दिनचाहिँ तिमीहरूका लागि पवित्र शब्बाथ दिन, याहवेहका निम्ति विश्रामको दिन हुनेछ। जसले यस दिनमा काम गर्दछ, त्यो मारिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","शब्बाथ दिनमा तिमीहरू कसैको घरमा आगोसमेत नसल्काउनू।” ");
INSERT INTO npioncb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशाले इस्राएलका सारा समुदायलाई भने, “याहवेहले गर्नुभएको आज्ञा यही हो: ");
INSERT INTO npioncb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","याहवेहका निम्ति भेटी ल्याओ। याहवेहका निम्ति भेटी ल्याउन चाहने हरेकले यी कुराहरू ल्याउनू: “सुन, चाँदी र काँसो; ");
INSERT INTO npioncb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","निलो, बैजनी र रातो धागो र मसिनो सुती कपडा; बाख्राको भुत्ला; ");
INSERT INTO npioncb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","भेडाका रातो रङ्गाएको छालाहरू र सीलका छालाहरू; बबुलका काठ; ");
INSERT INTO npioncb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","बत्तीको निम्ति जैतुनको तेल; अभिषेक गर्नका निम्ति तेल र सुगन्धित धूपका निम्ति मसलाहरू; ");
INSERT INTO npioncb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","अनि एपोद र छाती-पाता जड्नका निम्ति गोमेद र अरू रत्नहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तिमीहरूमध्ये सबै निपूर्ण कारिगरहरू आएर याहवेहले आज्ञा गर्नुभएअनुसार सम्पूर्ण कुराहरू बनाउनुपर्छ: ");
INSERT INTO npioncb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“समागम पाल, पालको छत, अङ्कुसेहरू, फल्याकहरू, बारहरू, खाँबाहरू र आधारहरू; ");
INSERT INTO npioncb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","डण्डाहरूसहित करारको सन्दुक र पाप समाधान-स्थान; ");
INSERT INTO npioncb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","टेबुल, त्यसका डण्डाहरूसहित र त्यसका सबै सामानहरू, र उपस्थितिको रोटी; ");
INSERT INTO npioncb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","सरसामानहरूसहित बत्तीको निम्ति सामदान, प्रकाशको निम्ति जैतुनको तेल; ");
INSERT INTO npioncb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूपको निम्ति वेदी र त्यसका डण्डाहरू, अभिषेक गर्ने तेल र सुगन्धित धूप; समागम पालको प्रवेशद्वारमा लगाइने पर्दा; ");
INSERT INTO npioncb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमबलिको निम्ति वेदी, काँसोको जाली, त्यसका डण्डाहरू र सबै सामानहरू; काँसोका बाटा त्यसका खुट्टासहित; ");
INSERT INTO npioncb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","आँगनका पर्दाहरू त्यसका खाँबाहरू र आधारहरूसमेत, र आँगनको मूलढोकाको निम्ति पर्दा; ");
INSERT INTO npioncb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","समागम पाल र आँगनका निम्ति किलाहरू र तिनीहरूका डोरीहरू; ");
INSERT INTO npioncb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्रस्थानमा सेवाका निम्ति बुनिएका पोशाकहरू—पुजारी हारूनका निम्ति पवित्र पोशाकहरू, र तिनका छोराहरूका निम्ति पोशाकहरू जब तिनीहरू पुजारी भएर सेवा गर्छन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","त्यसपछि इस्राएलका सारा समुदाय मोशाको सामुबाट बिदा भए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","जसका हृदय उत्साहित भए र दिने इच्छा गरे; तिनीहरूले समागम पाल, त्यसको सेवाको सबै काम र पवित्र पोशाकहरूका निम्ति याहवेहको सामु भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","इच्छुक हुने हरेक पुरुष र स्त्रीले सबै प्रकारका सुनका गहना ल्याए—पिन, कुण्डल, औँठी र सिङ्गारका सामानहरू। तिनीहरू हरेकले आफ्ना सुन विशेष भेटीको रूपमा उचालिनको निम्ति याहवेहलाई चढाए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","जससँग निलो, बैजनी, रातो धागो, मसिनो सुती कपडा, बाख्राका भुत्ला, भेडाका रातो रङ्गाएका छाला वा सीलका छालाहरू थिए, ती सबै ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","तिनीहरू, जसले चाँदी वा काँसो दिन सक्थे, तिनीहरूले ती भेटीको रूपमा याहवेहको सामु ल्याए; अनि जससँग सेवाको कामका निम्ति बबुल काठ थियो, त्यो तिनीहरूले ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","सिपले योग्य स्त्रीहरूले आफ्नो हातले तयार पारेका निलो, बैजनी, रातो धागो र मसिनो सुतीका वस्त्र ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","अनि सिपले योग्य र इच्छुक स्त्रीहरूले बाख्राका भुत्ला काते। ");
INSERT INTO npioncb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","अगुवाहरूले एपोदमा र छाती-पातामा जड्नका लागि गोमेद पत्थरहरू र अरू रत्नहरू ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","तिनीहरूले बत्तीको निम्ति जैतुनको तेल, अभिषेक गर्ने तेल र सुगन्धित धूपका निम्ति मसला ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","इस्राएलका सबै पुरुष र स्त्रीहरू, जसले याहवेहको निम्ति भेटी चढाउने इच्छा राखे; याहवेहले मोशाद्वारा आज्ञा गर्नुभएको सबै कामका निम्ति तिनीहरूले याहवेहकहाँ आफ्नो स्वेच्छा-भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तब मोशाले इस्राएलीहरूलाई भने, “हेर, याहवेहले यहूदाका कुल, हूरका नाति, ऊरीका छोरा बजलेललाई चुन्‍नुभएको छ; ");
INSERT INTO npioncb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","अनि उहाँले तिनलाई आफ्नो आत्मा, बुद्धि, समझ, ज्ञान र कारिगरीका सबै दक्षताले भर्नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","उहाँले तिनलाई सुन, चाँदी, काँसोमा कलापूर्ण आकार कोर्ने, ");
INSERT INTO npioncb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","कलापूर्ण तरिकाले हरेक प्रकारका पत्थर काटेर जड्ने काम, र काठमा खोप्ने सिप दिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","याहवेहले तिनलाई र दानका कुलका अहीसामाकका छोरा, ओहोलीआबलाई अरूलाई सिकाउन सक्ने क्षमता दिनुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","उहाँले तिनीहरूलाई हरेक प्रकारका शिल्पकारी, चित्र बनाउने काम, निलो, बैजनी, रातो धागो र मसिनो सुती कपडामा बुट्टा भर्ने अनि बुन्‍ने कारिगरले जानेका सबै काम गर्ने बुद्धिले भरिपूर्ण पार्नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","यसकारण बजलेल, ओहोलीआब र हरेक दक्ष मानिस, जसलाई याहवेहले पवित्रस्थान निर्माण गर्ने काममा दक्षता र क्षमता दिनुभएको छ, तिनीहरू सबैले याहवेहले आज्ञा दिनुभएअनुसार काम गरून्।” ");
INSERT INTO npioncb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","तब मोशाले बजलेल, ओहोलीआब अनि याहवेहले काम गर्न क्षमता दिनुभएका र इच्छुक हरेक दक्ष मानिसलाई बोलाइपठाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","तिनीहरूले पवित्रस्थान निर्माणका लागि इस्राएलीहरूले दिएका सबै भेटी मोशाबाट प्राप्‍त गरे। अनि मानिसहरूले हरेक बिहान स्वेच्छिक भेटीहरू ल्याउने गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","तब पवित्रस्थानमा काम गर्ने सबै दक्ष कामदारहरूले आ-आफ्ना काम छोडे, ");
INSERT INTO npioncb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","अनि मोशालाई भने, “याहवेहले आज्ञा गर्नुभएको भन्दा धेरै सरसामानहरू मानिसहरूले ल्याएका छन्।” ");
INSERT INTO npioncb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","त्यसपछि मोशाले आदेश गरे, र छाउनीभरि नै सन्देश पठाए: “अब कुनै पुरुष वा स्त्रीले पवित्रस्थानको भेटीका लागि अरू केही नल्याउनू।” यसकारण मानिसहरूले अरू भेटी ल्याउन छोडे। ");
INSERT INTO npioncb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","किनकि तिनीहरूले ल्याएका भेटीहरू सबै काम सम्पन्‍न गर्न चाहिएभन्दा धेरै भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","कामदारहरूमध्ये दक्ष भएकाहरूले दश वटा पर्दाले समागम पाल बनाए। ती पर्दाहरू मसिनो गरी बाटिएका सुती कपडाका निलो, बैजनी र रातो धागोका, र तिनमा दक्ष शिल्पकारद्वारा बनाइएका करूबहरूसहित समागम पाल थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","सबै पर्दाहरू एउटै नापका थिए—अट्ठाइस क्यूबिट लम्बाइ र चार क्यूबिट चौडाइ। ");
INSERT INTO npioncb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","तिनीहरूले ती पाँच वटा पर्दाहरू एक-अर्कासित जोडे। ");
INSERT INTO npioncb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","त्यसपछि तिनीहरूले पहिलो जोडिएको पर्दाको अन्तिम किनारमा निलो कपडाको सुर्काउनी बनाए। अनि दोस्रो किनारमा जोडिएको भागको अर्को पर्दाको अन्तिम किनारमा पनि पहिलेको जस्तै गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","तिनीहरूले एउटा भागको पर्दामा पचास वटा सुर्काउनी पनि बनाए। अर्को पर्दाको भागको अन्तिम किनारमा पचास वटा सुर्काउनी बनाए। ती सुर्काउनीहरू एक-अर्काका विपरीत थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","त्यसपछि तिनीहरूले ती पर्दाहरू एक-आपसमा जोड्नलाई सुनका पचास वटा अङ्कुसेहरू बनाए। यसरी समागम पाल एउटै भयो। ");
INSERT INTO npioncb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","समागम पालमाथिको पालको लागि तिनीहरूले बाख्राको भुत्लाबाट एघार वटा पर्दाहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","सबै एघार वटा पर्दाहरू एउटै नापका थिए—तीस क्यूबिट लम्बाइ र चार क्यूबिट चौडाइ। ");
INSERT INTO npioncb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","तिनीहरूले पाँच वटा पर्दाहरू जोडेर एउटा भाग र छ वटा पर्दाहरूका जोडेर अर्को भाग बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","त्यसपछि तिनीहरूले पहिलो गाँसिएको समूहको किनारमा पचास वटा सुर्काउनीहरू बनाए; अनि अर्को गाँसिएको समूहको पर्दाको किनारमा पनि पचास वटा सुर्काउनीहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ती दुवै पर्दालाई जोडेर एक-आपसमा एउटै बनाउन तिनीहरूले काँसोका पचास वटा अङ्कुसेहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","त्यसपछि तिनीहरूले पालको निम्ति भेडाको रातो रङ्गाइएको छालाबाट छत बनाए; र त्यसमाथि सीलका छालाहरूबाट छत बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","तिनीहरूले समागम पालका निम्ति बबुल काठको ठाडो फल्याकहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","प्रत्येक फल्याकका लम्बाइ दश क्यूबिट र चौडाइ डेढ क्यूबिट थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","त्यसमा एक-अर्कामा समानान्तर रहेका दुई वटा चोसाहरू थिए। समागम पालका सबै फल्याकहरू यस किसिमले नै बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","तिनीहरूले समागम पालको दक्षिणपट्टिका लागि बीस वटा फल्याकहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","अनि ती फल्याकहरूका मुन्तिर चालीस वटा चाँदीका आधारहरू बनाए—एउटा फल्याकको लागि दुई वटा आधारहरू, प्रत्येक चोसाको मुनि एउटा। ");
INSERT INTO npioncb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","अर्कोपट्टि, समागम पालको उत्तरपट्टि बीस वटा फल्याकहरू, ");
INSERT INTO npioncb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","अनि तिनको निम्ति दुई वटा आधार गरेर तिनीहरूले चाँदीका चालीस वटा आधारहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","तिनीहरूले पछिल्तिरको भाग, जो समागम पालको पश्‍चिमतिरको भाग हो, त्यसका लागि छ वटा फल्याकहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","अनि अन्तिम भागमा भएका समागम पालका कुनाहरूका लागि दुई वटा फल्याकहरू बनाइए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ती कुनाका दुई फल्याकहरू तलदेखि माथिसम्म दोबर खप्टिएका र माथिल्‍लो भागमा कुनाका फल्याकहरू एउटै मुन्द्रामा जोडिएका थिए। ती दुवै एकै किसिमले बनेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","यसरी त्यहाँ पछाडिपट्टि आठ वटा फल्याकहरू र एउटाको मुन्तिर दुई वटा गरी चाँदीका सोह्र वटा आधारहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","तिनीहरूले बबुल काठका बारहरू र समागम पालको एकापट्टि पाँच वटा फल्याकहरू पनि बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","अनि अर्कोपट्टिका फल्याकहरूका लागि पाँच वटा बार र समागम पालको पश्‍चिमका अन्तिम भागका फल्याकहरूको लागि पाँच वटा बारहरू लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","तिनीहरूले फल्याकहरूको बीचमा पर्ने बारचाहिँ एक छेउदेखि अर्को छेउसम्म पुग्ने बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","तिनीहरूले सबै फल्याकहरू सुनले मोहोरे, र बारहरू पक्रनका लागि सुनका मुन्द्राहरू बनाए। ती बारहरू पनि सुनले नै मोहोरे। ");
INSERT INTO npioncb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","तिनीहरूले निलो, बैजनी, रातो धागो र मसिनो गरी बाटेको सुती कपडाको एउटा पर्दा बनाए; जसमा निपूर्ण शिल्पकारद्वारा बनाइएका करूबहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","तिनीहरूले त्यसका लागि बबुल काठका चार वटा खाँबाहरू बनाए; अनि तिनलाई सुनले मोहोरे। तिनीहरूले सुनका अङ्कुसेहरू बनाए; र चाँदीका चार वटा आधारहरू ढाले। ");
INSERT INTO npioncb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","तिनीहरूले पाल प्रवेशद्वारका लागि निलो, बैजनी, रातो रङ्गको धागो र मसिनो गरी बाटेको सुती कपडाले शिल्पकारको शिल्पकारी भएको एउटा पर्दा बनाए; ");
INSERT INTO npioncb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","अनि तिनीहरूले पाँच वटा खाँबाहरूसहित अङ्कुसेहरू पनि बनाए। तिनीहरूले खाँबोका टुप्पाहरू र तिनका फित्ताहरू सुनले मोहोरे, र तिनका पाँच वटा काँसोका आधारहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बजलेलले बबुल काठको सन्दुक बनाए। त्यसको लम्बाइ साढे दुई क्यूबिट, चौडाइ साढे एक क्यूबिट, र उचाइ साढे एक क्यूबिट थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","तिनले त्यसको भित्री र बाहिरी भाग निखुर सुनले मोहोरे; अनि त्यसको वरिपरि सुनको बिट बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","तिनले त्यसका निम्ति सुनका चार वटा मुन्द्राहरू ढाले, र ती त्यसका चार वटा खुट्टामा लगाइदिए; दुई वटा मुन्‍द्रा एकापट्टि र दुई वटा अर्कापट्टि। ");
INSERT INTO npioncb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","तब तिनले बबुल काठका डण्डाहरू बनाएर ती सुनले मोहोरे। ");
INSERT INTO npioncb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ती डण्डाहरू सन्दुकको दुवैपट्टि भएका मुन्द्राहरूमा बोक्नका निम्ति हाले। ");
INSERT INTO npioncb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","तिनले निखुर सुनको पाप समाधान-स्थान बनाए; जसको लम्बाइ साढे दुई क्यूबिट र चौडाइ साढे एक क्यूबिट थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","त्यसपछि तिनले पाप समाधान-स्थानको किनारहरूमा पिटिएको सुनका दुई वटा करूबहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","तिनले एउटा करूब एक किनारमा, र अर्को करूब अर्को किनारमा बनाए। ती दुवै करूबहरू पाप समाधान-स्थानसित एउटै टुक्राले बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ती करूबहरूले आफ्ना पखेटाहरू माथिपट्टि फैलाएर पाप समाधान-स्थानमा छाया पारेका थिए। तिनीहरूका मुखचाहिँ एक-अर्कापट्टि, पाप समाधान-स्थानतिर फर्किएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बजलेलले बबुल काठको एउटा टेबुल बनाए; जसको लम्बाइ दुई क्यूबिट, चौडाइ एक क्यूबिट र उचाइ साढे एक क्यूबिट थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","तब तिनले त्यसलाई निखुर सुनले मोहोरे र चारैपट्टि सुनको बिट बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","तिनले त्यसका चारैतिर चार औँला चौडाइ भएको घेरा बनाए; अनि घेराको सबै भागमा सुनको बिट लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","तिनले टेबुलको लागि सुनका चार वटा मुन्द्राहरू बनाएर ती चार कुनाहरूमा भएका खुट्टाहरूमा बाँधे। ");
INSERT INTO npioncb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","त्यो टेबुल बोक्नलाई चलाइने डण्डाहरूलाई समातिराख्न ती मुन्द्राहरू घेराका छेवैमा राखिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","तिनले टेबुल बोक्नलाई ती डण्डीहरू बबुल काठका बनाए र त्यसलाई सुनले मोहोरे। ");
INSERT INTO npioncb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","अनि तिनले टेबुलका निम्ति थालहरू, धुपौराहरू, कचौराहरू र अर्घबलि चढाउनका निम्ति यसका भाँडाहरू सबै निखुर सुनको बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","तिनले निखुर सुनको सामदान बनाए। त्यसका आधार र डण्डा, फूलजस्ता कचौराहरू, कोपिला र फूलहरू एउटै टुक्राबाट पिटेर बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","तीन वटा एकपट्टि र तीन वटा अर्कोपट्टि गरेर जम्मा सामदानका दुई छेउमा छ वटा हाँगाहरू निस्केका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","एउटा हाँगामा कोपिला र फूल भएको बदामको फूलजस्तै आकारका तीन वटा कचौराहरू; अर्को हाँगामा तीन वटा र यसै गरी सामदानबाट निस्केका छ वटै हाँगाहरूमा थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","अनि सामदानमा कोपिला र कोपिला भएको बदामको फूलको आकारमा चार वटा कचौराहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","पहिलो कोपिला सामदानबाट निस्केको हाँगाको पहिलो जोडीमुनि थिए—दोस्रो कोपिला दोस्रो जोडीमुनि र तेस्रो कोपिला तेस्रो जोडीमुनि गरेर जम्मा छ वटा हाँगाहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ती कोपिलाहरू र हाँगाहरू सामदानसित एउटै टुक्राबाट घनले पिटेको निखुर सुनले बनिएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","तिनले सात वटा दियाहरू बनाए; तिनका चिम्टा र मोसोदानी निखुर सुनका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","सामदान र त्यसका सरसामानहरूका निम्ति तिनले एक टालेन्ट निखुर सुन लिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","तिनले धूप बाल्नलाई बबुल काठको एउटा वेदी बनाए। त्यो वर्गाकार थियो; जसको लम्बाइ एक क्यूबिट, चौडाइ एक क्यूबिट र उचाइ दुई क्यूबिट थियो। त्यसका सिङहरू पनि एउटै टुक्राबाट बनेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","तिनले त्यसका टुप्पो र सबै भित्ताहरू र सिङहरूलाई निखुर सुनले मोहोरे; अनि त्यसको चारैतिर सुनको बिट बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","त्यसलाई बोक्नका निम्ति तिनले त्यसको बिटमुनि र त्यसको दुई विपरीत भागमा डण्डाहरू बस्‍ने घरका निम्ति सुनका दुई वटा मुन्द्राहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","तिनले बबुल काठका डण्डाहरू बनाए र त्यसलाई सुनले मोहोरे। ");
INSERT INTO npioncb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","तिनले अभिषेक गर्ने पवित्र तेल र अत्तर बनाउनेले झैँ सुगन्धित शुद्ध धूप पनि बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","बजलेलले होमबलिको निम्ति बबुल काठको वेदी बनाए। त्यो वर्गाकार थियो; त्यसको लम्बाइ पाँच क्यूबिट, चौडाइ पाँच क्यूबिट र उचाइ तीन क्यूबिट थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","तिनले त्यसका चार कुनामा सिङहरू बनाए; ती सिङहरू र वेदी एउटै टुक्राबाट बनेका थिए; अनि वेदीलाई काँसोले मोहोरे। ");
INSERT INTO npioncb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","तिनले वेदीका सबै सरसामानहरू, भाँडाहरू, बेल्चाहरू, छर्कने बाटाहरू, मासु उठाउने काँटाहरू र आगो राख्ने भाँडाहरू काँसोका बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","तब तिनले वेदीको निम्ति एउटा काँसोको जाली बनाए, जुन वेदीको तलबाट आधा भागसम्म आउँदथ्यो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","डण्डाहरू राख्नका निम्ति तिनले काँसोका चार वटा मुन्द्राहरू बनाएर चारै कुनामा राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","बबुल काठका डण्डाहरू बनाए, र तिनलाई तिनले काँसोले मोहोरे। ");
INSERT INTO npioncb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","तिनले ती डण्डाहरूलाई वेदी बोक्नका निम्ति त्यसका दुवै तर्फका किनारका मुन्द्राहरूमा हाले। फल्याकहरूबाट तिनले त्यस वेदीलाई खोक्रो बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","तिनले समागम पालको ढोकामा सेवा गर्ने स्त्रीहरूका ऐनाबाट काँसोका धुने बाटा र आसन बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","त्यसपछि तिनले आँगन बनाए। त्यसको दक्षिण भागपट्टिको लम्बाइ एक सय क्यूबिट र पर्दाचाहिँ मसिनो गरी बाटेको सुती कपडाको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","त्यसका खाँबाहरू बीस वटा र काँसाका आधारहरू पनि बीस वटा नै थिए; खाँबोका अङ्कुसेहरू र फित्ताहरू चाँदीका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","आँगनको उत्तरपट्टिको निम्ति एक सय क्यूबिट लामा पर्दाहरू र बीस वटा खाँबाहरू, र काँसोका आधारहरू पनि बीस वटा नै थिए। त्यसका अङ्कुसेहरू र फित्ताहरू चाँदीका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","पश्‍चिमपट्टि पचास क्यूबिट चौडा पर्दाहरू थिए; त्यसका खाँबाहरू र आधारहरू पनि दश-दश वटा थिए। खम्बाहरूका अङ्कुसे र फित्ताहरू चाँदीका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","पूर्व वा सूर्योदयतर्फ पनि पचास क्यूबिट चौडा थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","मूलढोकाको एकापट्टिका पर्दाहरू पन्ध्र क्यूबिट लामा थिए; जसका तीन वटा खाँबाहरू र तीन वटा आधारहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","आँगनको मूलढोकाको अर्कापट्टि पन्ध्र क्यूबिट लामा पर्दाहरू थिए; तीन वटा खाँबाहरू र तीन वटा आधारहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आँगनका चारैपट्टिका सबै पर्दाहरू मसिनो गरी बाटिएका सुती कपडाका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खाँबाका आधारहरू काँसोका थिए। यसका अङ्कुसेहरू र फित्ताहरूचाहिँ चाँदीले बनाइएका र टुप्पाहरू चाँदीले नै मोहोरिएका थिए। आँगनका सबै खाँबाहरूमा चाँदीका फित्ताहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आँगनको मूलढोकाको पर्दामा बुट्टा हाल्नेको काम, जसलाई निलो, बैजनी र रातो रङ्गको मसिनो सुतीले बुनेको कपडाले बनाइएको थियो। यसको लम्बाइ बीस क्यूबिट र आँगनको पर्दाझैँ पाँच क्यूबिट उचाइ थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","त्यसका खाँबाहरू चार वटा र काँसोका आधारहरू चार वटा थिए। त्यसका अङ्कुसेहरू र फित्ताहरू चाँदीले बनेका थिए; अनि टुप्पाहरू चाँदीले मोहोरिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","समागम पाल र चारैतिर आँगनका किलाहरू काँसाका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","मोशाका आज्ञाअनुसार पुजारी हारूनका छोरा ईतामारद्वारा लेवीहरूले समागम पाल, करारको पाल, जुनचाहिँ समागम पाल हो, बनाउनका निम्ति प्रयोग गरेका सरसामानहरूको वर्णन यही हो: ");
INSERT INTO npioncb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(यहूदा कुलका हूरका नाति, ऊरीका छोरा बजलेलले याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार सबै कुराहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","उनको साथमा दान कुलका अहीसामाकका छोरा ओहोलीआब थिए। तिनी एक शिल्पकार तथा चित्रहरू बनाउने र निलो, बैजनी, रातो रङ्गका धागो र मसिनो सुती कपडामा बुट्टा भर्ने काममा निपूर्ण थिए।) ");
INSERT INTO npioncb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्र वासस्थान बनाउन विशेष भेटीको रूपमा अर्पण भएका सबै भेटीको सुन पवित्र वासस्थानको सेकेलको हिसाबअनुसार 29 टालेन्ट र 730 सेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","सारा समुदायमा गणना भएको मानिसहरूका चाँदी पवित्र वासस्थानको हिसाबअनुसार 100 टालेन्ट र 1,775 सेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","बीस वर्ष र त्यसभन्दा बढी उमेर समूहका 6,03,550 पुरुषहरूमध्ये प्रत्येकबाट पवित्र वासस्थानको शेकेलको हिसाबले आधा सेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","100 टालेन्ट चाँदी पवित्र वासस्थान र पर्दाको आधारहरू ढाल्न प्रयोग भयो; सबै आधारहरूमा 100 टालेन्ट थियो—प्रत्येक आधारका निम्ति एक टालेन्ट। ");
INSERT INTO npioncb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","तिनले चाँदीका 1,775 सेकेललाई खाँबोका निम्ति अङ्कुसेहरू बनाउन र तिनका टुप्पाहरू मोहोर्न फित्ताहरू बनाए र प्रयोग गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","विशेष भेटीको रूपमा अर्पण गरिएका काँसोका भेटी 70 टालेन्ट र 2,400 सेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ती काँसोबाट तिनले भेट हुने पालका ढोकाका आधारहरू, काँसोका वेदी, जाली र त्यसका सबै सरसामानहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","आँगनका चारैपट्टिका आधारहरू, मूलढोकाका आधारहरू, समागम पालका र आँगनका चारैतिरका सबै किलाहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","तिनीहरूले पवित्रस्थानका सेवाका निम्ति निलो, बैजनी र रातो धागोले बुनेका पोशाकहरू बनाए। याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनीहरूले हारूनका निम्ति पनि पवित्र पोशाकहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","तिनीहरूले एपोदचाहिँ सुन, निलो, बैजनी, रातो रङ्गको धागो र मसिनो गरी बाटेको सुती कपडाको बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","तिनीहरूले सुनलाई पिटेर पातलो पाताबाट स-साना डोरीहरू बनाए; अनि त्यसलाई निलो, बैजनी, रातो रङ्गको धागो र मसिनो सुती कपडामा जडे, जुनचाहिँ निपूर्ण कारिगरको हातको काम थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","एपोदका निम्ति तिनीहरूले दुई वटा काँधे-जोर्नीहरू बनाए; अनि त्यसलाई बाँध्नका निम्ति त्यसका छेउमा लगाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","याहवेहले मोशालाई आज्ञा गर्नुभएबमोजिम सिपालु गरी बुनेको पटुका एपोदसँग एकै प्रकारका सामग्रीहरूबाट बनिएको थियो: सुन, निलो, बैजनी, रातो रङ्गको धागो र मसिनो गरी बाटेको सुती कपडाको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","तिनीहरूले आनिक्स पत्थरहरू सुनका मणिघरहरूमा जडे, र छापमा झैँ इस्राएलका छोराहरूका नाम त्यसमा खोपे। ");
INSERT INTO npioncb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनीहरूले ती पत्थरहरू सम्झनाका निम्ति इस्राएलका छोराहरूका एपोदका काँधे-जोर्नीहरूमा लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","सिपले निपूर्ण मानिसलेझैँ तिनीहरूले छाती-पाता बनाए। सुन, निलो, बैजनी, रातो रङ्गको धागो र मसिनो गरी बाटेको सुती कपडाबाट तिनीहरूले त्यो एपोदजस्तै बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","त्यो वर्गाकार, एक बित्ता लामो र एक बित्ता चौडा, अनि दोबारेर पट्ट्याइएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","तब तिनीहरूले त्यसका चार पङ्‌क्तिमा बहुमूल्य पत्थरहरू जडे। पहिलो पङ्‌क्तिमा माणिक, पुष्पराज र पन्‍ना; ");
INSERT INTO npioncb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दोस्रो पङ्‌क्तिमा फिरोजा, नीलमणि र हीरा; ");
INSERT INTO npioncb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तेस्रो पङ्‌क्तिमा धूम्रकान्त, सूर्यकान्त र नीलमणि; ");
INSERT INTO npioncb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","अनि चौथो पङ्‌क्तिमा फिरोज, गोमेद र स्फटिक थिए। ती सुनको मणिघरहरूमा जडिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","बाह्र पत्थरहरूमा इस्राएलका बाह्र कुलहरू जनाउन प्रत्येकमा छापमा खोपेझैँ एक-एक गरी इस्राएलका छोराहरूका नाम थिए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","छाती-पाताको निम्ति तिनीहरूले डोरीजस्तो बाटेको निखुर सुनका सिक्रीहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","तिनीहरूले सुनका दुई वटा मणिघरहरू र दुई वटा मुन्द्राहरू बनाए; अनि ती दुवै मुन्द्राहरूलाई छाती-पाताको दुई कुनामा लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तिनीहरूले बनाएका ती सुनका दुई सिक्रीहरूलाई छाती-पाताको कुनामा भएका मुन्द्राहरूमा लगाए, ");
INSERT INTO npioncb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","अनि सिक्रीका अरू छेउहरूलाई अगिल्तिर भएको एपोदका काँधे-जोर्नीहरूका अगाडिपट्टि मिलाएर दुवैलाई सुनका मणिघरहरूमा लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","तिनीहरूले सुनका दुई वटा मुन्‍द्रा बनाएर छाती-पाताको अर्को दुई किनारमा एपोदको भित्री भागमा लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","तब तिनीहरूले सुनका अरू दुई वटा मुन्द्राहरू बनाए, र दुवै काँधे-जोर्नीहरूका मुनि एपोदको अगाडिपट्टि पटुकाको ठिक माथि सिउनीनिर लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनीहरूले छाती-पाताका मुन्द्राहरूलाई निलो धागोले बाँधे, ताकि त्यो एपोदबाट सर्न नसकोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","तिनीहरूले एपोदको अलखा सबै निलो रङ्गले बुनेको कपडाको बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","त्यसको बीचमा कठालोको प्वालजस्तो अलखाको प्वाल बनाए, र वरिपरि बिट बुनिदिए, ताकि त्यो नफाटोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","त्यसको तल्‍लो फेरोमा तिनीहरूले निलो, बैजनी, र रातो धागो र मसिनो गरी बाटेको सुती कपडाको दारिमहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","तिनीहरूले निखुर सुनका घण्टीहरू बनाए, र ती अलखाको फेरोको वरिपरि र दारिमहरूको बीचमा लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनीहरूले सेवा गर्दा लगाउनका निम्ति ती सुनका घण्टीहरू अलखाको फेरो र दारिमहरूको वरिपरि लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","तिनीहरूले हारून र तिनका छोराहरूका निम्ति मसिनो सुती कपडाका लवेदाहरू ");
INSERT INTO npioncb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","अनि मसिनो सुती कपडाका फेटा, टोपीहरू र सुती कपडाकै भित्री वस्त्रहरू पनि बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","त्यसै गरी याहवेहले मोशालाई आज्ञा गर्नुभएबमोजिम तिनीहरूले शिल्पकारीले झैँ मसिनो गरी बाटेको सुतीको कपडा, निलो, बैजनी र रातो रङ्गको बुट्टेदार भएको पटुका बनाए। ");
INSERT INTO npioncb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","तिनीहरूले पाता, अर्थात् निखुर सुनले पवित्र मुकुट बनाए, र छापको खोपझैँ यी कुरा खोपे: याहवेहका निम्ति पवित्र। ");
INSERT INTO npioncb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","तब याहवेहले मोशालाई आज्ञा गर्नुभएबमोजिम तिनीहरूले त्यस पातालाई निलो डोरीले फेटामा लगाउनलाई बाँधे। ");
INSERT INTO npioncb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","यसरी भेट हुने पाल, अर्थात् समागम पालको सम्पूर्ण कार्य सकियो। याहवेहले मोशालाई जस्तो आज्ञा गर्नुभएको थियो, त्यस्तै इस्राएलीहरूले गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तब तिनीहरूले मोशाकहाँ समागम पाल ल्याए: पाल र त्यसका सबै सरसामानहरू, त्यसका अङ्कुसेहरू, फल्याकहरू, तेर्सो बारहरू, खाँबाहरू र आधारहरू; ");
INSERT INTO npioncb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","रातो रङ्गले रङ्गाएका भेडाका छालाहरू र पर्दाहरू ढाक्नका निम्ति सीलका छालाहरू, छेक्ने पर्दा; ");
INSERT INTO npioncb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","करारको सन्दुक, त्यसका डण्डाहरू र पाप समाधान-स्थान; ");
INSERT INTO npioncb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","टेबुल र त्यसका सबै सरसामानहरू र उपस्थितिको रोटी; ");
INSERT INTO npioncb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","निखुर सुनको सामदान, त्यसका दियाहरू, सबै सरसामानहरू अनि प्रकाशको निम्ति जैतुनको तेल; ");
INSERT INTO npioncb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","सुनको वेदी, अभिषेक गर्ने तेल, सुगन्धित धूप र पालको ढोकाको निम्ति पर्दा; ");
INSERT INTO npioncb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","काँसोका वेदी, त्यसको जाली, डण्डाहरू र सबै सामानहरू; हात धुने बाटा र त्यसका आसन; ");
INSERT INTO npioncb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","आँगनका पर्दाहरू, त्यसका खाँबाहरू, त्यसका आधारहरू र आँगनको ढोकाको निम्ति पर्दाहरू; आँगनका निम्ति डोरीहरू र किलाहरू; समागम पालको भेट हुने पालको निम्ति सबै सरसामानहरू; ");
INSERT INTO npioncb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","अनि पवित्रस्थानमा सेवाको निम्ति बुनिएका पोशाकहरू, पुजारी हारूनका निम्ति पवित्र पोशाकहरू र पुजारीकै पदमा रही सेवा गर्नका निम्ति हारूनका छोराहरूका पोशाकहरू। ");
INSERT INTO npioncb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार इस्राएलीहरूले सबै काम गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मोशाले सबै काम हेरे; अनि ती काम याहवेहले आज्ञा गर्नुभएअनुसार थिए। त्यसकारण मोशाले तिनीहरूलाई आशिष् दिए। ");
INSERT INTO npioncb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","तब याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“महिनाको पहिलो दिन समागम पालको भेट हुने पाल खडा गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","त्यसमा करारको सन्दुक राखेर त्यसलाई पर्दाले ढाक्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","टेबुल भित्र ल्याउनू र त्यसका सबै सरसामानहरू त्यसमाथि राख्नू। त्यसपछि सामदान भित्र ल्याउनू र दियाहरू मिलाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","करारको सन्दुकको अगाडिपट्टि धूपको निम्ति सुनको वेदी राख्नू; अनि समागम पालको ढोकामा पर्दा लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“समागम पालको भेट हुने पाल अगाडिपट्टि होमबलिको वेदी राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","भेट हुने पाल र वेदीको बीचमा बाटामा पानी भरेर राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","यसको वरिपरि आँगन बनाउनू, र यसको ढोकामा पर्दा लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“अभिषेक गर्ने तेलले समागम पाल र त्यहाँ भएका सबै सरसामानहरूलाई अभिषेक गर्नू, त्यसलाई र त्यसका सबै सरसामानहरूलाई नै शुद्ध गर्नू, र त्यो पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","त्यसपछि होमबलिको वेदी र त्यसको सबै सरसामानहरूलाई अभिषेक गर्नू, र त्यो महा-पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","पानीको बाटा र त्यसको खुट्टालाई अभिषेक गरी शुद्ध गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“हारून र तिनका छोराहरूलाई भेट हुने पालको ढोकामा ल्याउनू, र तिनीहरूलाई पानीले धुनू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","अनि हारूनलाई पवित्र पोशाक पहिर्‍याएर अभिषेक गर्नू र शुद्ध गर्नू; ताकि त्यसले पुजारी भई मेरो सेवा गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","त्यसका छोराहरूलाई ल्याउनू, र लबेदा पहिर्‍याइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","तिनीहरूका पितालाई अभिषेक गरेजस्तै तैँले तिनीहरूलाई पनि अभिषेक गर्नू, ताकि तिनीहरूले पुजारी भई मेरो सेवा गरून्। अनि तिनीहरूको अभिषेक एक पुजारी भई तिनीहरूका पुस्तामा निरन्तर रहनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार नै तिनले त्यो गरे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","यसरी दोस्रो वर्षको पहिलो महिनाको, पहिलो दिनमा समागम पाल खडा गरियो। ");
INSERT INTO npioncb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","जब मोशाले समागम पाल खडा गरे, तिनले त्यसका आधारहरू र फल्याकहरू खडा गरी बारहरू लगाए, र त्यसका खाँबाहरू गाडे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","त्यसपछि याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार तिनले समागम पालमाथि पाल फैलाएर त्यसको माथिपट्टि छत लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","तिनले साक्षी पाटी ल्याई त्यसलाई सन्दुकभित्र राखे, र त्यसमा डण्डाहरू राखे, र सन्दुकमाथि पाप समाधान-स्थान राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","त्यसपछि तिनले त्यो सन्दुकलाई समागम पालभित्र ल्याए, र त्यसलाई पर्दाले ढाकिदिए; जस्तो याहवेहले मोशालाई आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","मोशाले भेट हुने पालमा समागम पालको उत्तरपट्टिको पर्दाको बाहिरपट्टि टेबुल राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","याहवेहले तिनलाई आज्ञा गर्नुभएअनुसार तिनले याहवेहको सामु टेबुलमा रोटी सजाएर राखे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","मोशाले भेट हुने पालभित्र समागम पालको दक्षिणतर्फको भागमा टेबुलको विपरीत सामदान राखे; ");
INSERT INTO npioncb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","अनि याहवेहले आज्ञा गर्नुभएअनुसार तिनले याहवेहको सामु दियाहरू बाले। ");
INSERT INTO npioncb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","भेट हुने पालको पर्दाको सामु मोशाले सुनको वेदी बनाए; ");
INSERT INTO npioncb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","अनि याहवेहले तिनलाई आज्ञा गर्नुभएअनुसार तिनले सुगन्धित धूप बाले। ");
INSERT INTO npioncb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","त्यसपछि तिनले समागम पालको ढोकामा पर्दा लगाए। ");
INSERT INTO npioncb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार तिनले समागम पालको भेट हुने पालको ढोकाको नजिक वेदी बनाएर होमबलि र अन्‍नबलि चढाए। ");
INSERT INTO npioncb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","तिनले समागम पाल र वेदीको बीचमा बाटा राखेर धुनलाई त्यसमा पानी भरे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","अनि मोशा, हारून र तिनका छोराहरूले त्यसबाट आ-आफ्ना हातहरू र खुट्टाहरू धोए। ");
INSERT INTO npioncb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","तिनीहरू जहिले-जहिले भेट हुने पाल, अर्थात् वेदीको नजिक आउँथे, तब तिनीहरूले आ-आफ्ना हातहरू र खुट्टाहरू धुने गर्दथे; जस्तो याहवेहले मोशालाई आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","त्यसपछि मोशाले याहवेहले आज्ञा गर्नुभएअनुसार वेदी खडा गरे र आँगनको ढोकामा पर्दा लगाए। यसरी मोशाले काम सिद्ध्याए। ");
INSERT INTO npioncb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","तब भेट हुने पाललाई बादलले ढाक्यो, र समागम पाल याहवेहको महिमाले भरियो। ");
INSERT INTO npioncb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मोशाचाहिँ भेट हुने पालभित्र पस्‍न सकेनन्; किनकि बादल त्यसमाथि बसिरह्‍यो र याहवेहको महिमाले समागम पाल भरियो। ");
INSERT INTO npioncb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","इस्राएलीहरूका सबै यात्राभरि जहिले-जहिले त्यो बादल समागम पालबाट उठ्थ्यो, तब तिनीहरू अगाडि बढ्थे; ");
INSERT INTO npioncb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","तर यदि बादल उठेर गएन भने नउठेको त्यस दिनसम्म तिनीहरू हिँड्दैनथे। ");
INSERT INTO npioncb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","यसरी सारा इस्राएलीहरूले तिनीहरूका सबै यात्राभरि समागम पालमाथि दिनमा याहवेहको बादल र राति बादलमा आगो देख्थे।");
INSERT INTO npioncb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","याहवेहले मोशालाई बोलाउनुभयो, र समागम पालबाट तिनीसित कुरा गर्नुभयो। उहाँले भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएलीहरूसित कुरा गरेर तिनीहरूलाई भन्: ‘तिमीहरूमध्ये कसैले याहवेहका निम्ति पशु भेटीको रूपमा ल्याउँदा तिमीहरूको भेटी गाईबस्तुका बथान अथवा भेडाबाख्राका बगालबाट ल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘यदि त्यस बथानबाट होमबलि हो भने त्यसले निष्खोट नर पशु चढाओस्। त्यसले त्यो समागम पालको प्रवेशद्वारमा ल्याओस्, र त्यो याहवेहका निम्ति ग्रहणयोग्य हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","त्यसले त्यस होमबलिको शिरमाथि आफ्नो हात राखोस्; र त्यो त्यसको प्रायश्‍चितका लागि त्यसको पक्षमा ग्रहणयोग्य हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","त्यसले त्यस बाछालाई याहवेहको सामु मारोस्। अनि हारूनका पुजारी छोराहरूले रगत ल्याएर त्यसलाई समागम पालको प्रवेशद्वारमा वेदीको सबैतिर भित्तामा छर्कून्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","त्यसले होमबलिको छाला काढेर त्यसलाई टुक्रा-टुक्रा पारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","पुजारी हारूनका छोराहरूले वेदीमा दाउराहरू मिलाएर आगो लगाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","त्यसपछि हारूनका पुजारी छोराहरूले टाउको र बोसोसमेत ती टुक्राहरूलाई वेदीमा जलिरहेका दाउरामाथि मिलाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","त्यस मानिसले भित्री भागहरू र खुट्टाहरू पानीले धोओस्; अनि पुजारीले ती सबै वेदीमाथि जलाओस्। यो होमबलि याहवेहलाई मनपर्ने बास्‍नाको अग्निबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘यदि त्यसको होमबलि भेडाबाख्राहरूबाट हो भने त्यसले निष्खोट नर पशु चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","त्यसले वेदीको उत्तरपट्टि याहवेहको सामु त्यसलाई मारोस्; अनि हारूनका पुजारी छोराहरूले त्यसको रगत वेदीका सबै भित्ताहरूमा छर्कून्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","त्यस मानिसले यसलाई टुक्रा-टुक्रा पारोस्। अनि पुजारीले तिनीहरूलाई शिर र बोसोसमेत वेदीमाथि जलिरहेको दाउरामाथि मिलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","त्यस मानिसले भित्री भागहरू र खुट्टाहरू पानीले धोओस्; अनि पुजारीले ती सबै ल्याएर वेदीमाथि जलाओस्। यो होमबलि याहवेहलाई मनपर्ने बास्‍नाको अग्निबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘याहवेहका निम्ति होमबलि पक्षीहरूबाटको हो भने त्यसले ढुकुर वा परेवाका बचेराहरू चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पुजारीले त्यसलाई वेदीमा ल्याएर शिर निमोठेर वेदीमाथि जलाओस्; र त्यसका रगत वेदीका किनारमा निथारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","त्यसले आन्द्राभुँडी र त्यसभित्र भएका सबै फोहर निकालेर वेदीको पूर्वपट्टि खरानी भएको ठाउँमा फ्याँकोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","त्यसले त्यसलाई नटुक्राइकन पखेटाको बीचमा चिरोस्। अनि पुजारीले त्यसलाई वेदीमाथि बलिरहेको दाउरामाथि जलाओस्। यो होमबलि याहवेहलाई मनपर्ने बास्‍नाको अग्निबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘कसैले याहवेहका निम्ति अन्‍नबलि ल्याउँछ भने त्यसको भेटी मसिनो पिठोको होस्। त्यसले त्यसमाथि जैतुन तेल खन्याओस्, र त्यसमा धूप हालोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","अनि त्यसलाई हारूनका पुजारी छोराहरूकहाँ ल्याओस्। पुजारीले एक मुठी मसिनो पिठो र तेल सबै धूपसित लिएर त्यसलाई सम्झनास्वरूप वेदीमा जलाउनेछ। यो अग्निबलि हो—याहवेहलाई मनपर्ने बास्‍ना। ");
INSERT INTO npioncb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अन्‍नबलिको बाँकी भाग हारून र त्यसका छोराहरूको हो। यो याहवेहका निम्ति अग्निबलिहरूमा सबैभन्दा पवित्र भाग हो। ");
INSERT INTO npioncb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘तिमीहरूले चुलोमा पकाएको अन्‍नबलि ल्यायौ भने यो मसिनो पिठोका खमिर नमिसाइएको र तेल मिसाइएका फुरौलाहरू अथवा तेल दलेका अखमिरी बाबर होस्। ");
INSERT INTO npioncb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","यदि तिमीहरूका अन्‍नबलि तावामा पकाएको हो भने त्यो खमिर नमिसाइएको र जैतुन तेल मिसाइएको पिठोबाट बनिएको होस्। ");
INSERT INTO npioncb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","त्यसलाई टुक्रा-टुक्रा पारेर त्यसमाथि तेल खन्याउनू; त्यो अन्‍नबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","तिमीहरूका अन्‍नबलि ताप्केमाथि पकाएको हो भने त्यो मसिनो पिठो र जैतुन तेलबाट बनाइएको होस्। ");
INSERT INTO npioncb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","यी कुराहरूले बनिएको अन्‍नबलि याहवेहकहाँ ल्याउनू; र त्यो पुजारीलाई दिनू, जसले त्यसलाई वेदीमा लानेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","त्यस पुजारीले अन्‍नबलिबाट सम्झनाको भाग निकालेर याहवेहलाई मनपर्ने बास्‍नाझैँ अग्निबलिको रूपमा वेदीमाथि जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्‍नबलिको बाँकी भाग हारून र त्यसका छोराहरूको हो। यो याहवेहका निम्ति अग्निबलिहरूमा सबैभन्दा पवित्र भाग हो। ");
INSERT INTO npioncb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘तिमीहरूले याहवेहकहाँ ल्याउने प्रत्येक अन्‍नबलि खमिर नहाली बनाइएको होस्। किनकि याहवेहकहाँ चढाइने अग्निबलिमा तिमीहरूले कुनै खमिर अथवा मह नजलाऊनू। ");
INSERT INTO npioncb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तिमीहरूले ती याहवेहकहाँ अगौटे फलका बलिको रूपमा ल्याउन सक्छौ, तर तिनीहरूलाई वेदीमा मनपर्ने बास्‍नाको रूपमा नचढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तिमीहरूका सबै अन्‍नबलिहरूमा नुन मोल्नू। तिमीहरूका परमेश्‍वरको करारको नुनलाई तिमीहरूका अन्‍नबलिदेखि अलग नराख्नू। तिमीहरूका सबै बलिहरूमा नुन चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘याहवेहका निम्ति अगौटे फलहरूको अन्‍नबलि चढाउने इच्छा भएमा आफ्ना अगौटे फलहरूका अन्‍नबलिका निम्ति पिँधेका र आगोमा पिल्स्याएका ताजा अन्‍नका बालाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","त्यसमा तेल हाल्नू र धूप राख्नू; यो अन्‍नबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","पिँधेको अन्‍न र तेल सम्झनाको भाग सबै धूपसित याहवेहका निम्ति अग्निबलिको रूपमा पुजारीले जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘यदि कसैले मेलबलि चढाउँछ भने, र यसको निम्ति बलि बथानबाट भाले वा पोथी पशु चढाउँछ भने त्यसले याहवेहको सामु निष्खोट पशु चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","त्यसले आफ्नो बलिको शिरमाथि आफ्नो हात राखेर त्यसलाई समागम पालको प्रवेशद्वारमा मारोस्। त्यसपछि हारूनका पुजारी छोराहरूले वेदीको चारैतिर रगत छर्कून्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","त्यसले मेलबलिबाट याहवेहका निम्ति अग्निबलि चढाओस्। आन्द्राभुँडी ढाक्ने बोसो र आन्द्रामाथिको बोसो सबै ल्याओस्, ");
INSERT INTO npioncb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","कम्मरनिरका दुवै मिर्गौला र ती नजिकको बोसो, कलेजोलाई छोपेको बोसो, जसलाई मिर्गौलाहरूसितै निकाल्नु। ");
INSERT INTO npioncb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","त्यसपछि हारूनका छोराहरूले त्यसलाई वेदीमा होमबलिमाथि बल्दैगरेको दाउरामाथि जलाओस्। यो याहवेहलाई मनपर्ने बास्‍नाको अग्निबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘यदि त्यसले याहवेहका निम्ति बगालबाट मेलबलिको रूपमा एउटा पशु चढाउँछ भने त्यसले निष्खोट भाले वा पोथी चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","त्यसले बलिको लागि थुमा चढाउँछ भने याहवेहको सामु यस प्रकारले चढाओस्ः ");
INSERT INTO npioncb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","त्यसले बलिको शिरमाथि आफ्नो हात राखेर त्यसलाई समागम पालको सामु मारोस्; हारूनका छोराहरूले त्यसको रगत वेदीका चारैतिर छर्कून्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","मेलबलिबाट त्यसले याहवेहका निम्ति अग्निबलि ल्याओस्: त्यसको बोसो, ढाडको छेउदेखि काटेको बोसे पुच्छरको सम्पूर्ण भाग, भित्री भागहरूलाई छोप्ने सबै बोसो र त्यससित जोडिएका बोसो, ");
INSERT INTO npioncb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","कम्मरनिरको दुवै मिर्गौलासमेत त्यसका बोसो, र कलेजो छोप्ने भाग, जसलाई त्यसले मिर्गौलाहरूबाट छुट्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","पुजारीले यी सबैलाई वेदीमा अग्निबलिको रूपमा याहवेहका निम्ति जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘यदि त्यसको बलिचाहिँ बाख्रा हो भने त्यसले यो याहवेहको सामु चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","त्यसले आफ्नो हात त्यसको टाउकोमाथि राखेर त्यसलाई समागम पालको सामु मारोस्। त्यसपछि हारूनका छोराहरूले त्यसको रगत वेदीको चारैतिर छर्कून्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","त्यसले जे थोक चढाउँछ, त्यो भेटी याहवेहलाई अग्निबलिको रूपमा चढाओस्: भित्री अङ्गहरू र त्यससित गाँसिएका भागहरूलाई छोप्ने सबै बोसो, ");
INSERT INTO npioncb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","कम्मरनिरको दुवै मिर्गौलासमेत त्यसका बोसो, र कलेजो छोप्ने भाग, जसलाई त्यसले मिर्गौलाहरूबाट छुट्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","पुजारीले तिनलाई अग्निबलिको रूपमा मनपर्ने बास्‍नाको रूपमा वेदीमा जलाओस्। सबै बोसो याहवेहकै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘तिमीहरू जहाँ बसे तापनि आउने पुस्ताका लागि यो एउटा सधैँभरि रहिरहने विधि हो: तिमीहरूले कुनै बोसो अथवा रगत नखानू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएलीहरूलाई यसो भन्: ‘जब कसैले अनजानमा पाप गर्छ र याहवेहका आज्ञाअनुसार निषेध गरिएको काम गर्छ भने— ");
INSERT INTO npioncb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘यदि प्रधान पुजारीले पाप गर्छ र मानिसहरूमाथि दोष ल्याउँछ भने त्यसले आफूले गरेको पापका निम्ति पाप शुद्धीकरण बलिको रूपमा याहवेहकहाँ एउटा बाछा ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","त्यसले त्यस बाछालाई समागम पालको प्रवेशद्वारमा याहवेहको सामु प्रस्तुत गरोस्। त्यसले आफ्नो हात त्यसको शिरमाथि राखेर त्यसलाई याहवेहको सामु मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","त्यसपछि प्रधान पुजारीले बाछाको रगतबाट केही लिएर त्यसलाई समागम पालभित्र ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","त्यसले आफ्नो औँला रगतमा चोपेर त्यसबाट केही समागम पालको पर्दाको सामु याहवेहको अगिल्तिर सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","त्यसपछि पुजारीले केही रगत समागम पालमा याहवेहको सामु भएको सुगन्धित धूपको वेदीका सिङहरूमाथि लगाओस्। उब्रेको रगतलाई चाहिँ त्यसले समागम पालको प्रवेशद्वारमा भएको होमबलिको वेदीको फेदमा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","त्यसले पाप शुद्धीकरण बलिको बाछाबाट सबै बोसो झिकोस्; भित्री भाग र त्यससित गाँसिएको भागलाई छोप्ने बोसो, ");
INSERT INTO npioncb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","कम्मरनिर भएको बोसो, र दुवै मिर्गौलासमेत कलेजोलाई छोप्ने भागहरू त्यसले मिर्गौलाहरूसितै, ");
INSERT INTO npioncb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","मेलबलिका निम्ति बलिदान गरिएको गोरुबाट बोसो निकालेझैँ निकालोस्। त्यसपछि पुजारीले तिनलाई होमबलिको वेदीमाथि जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","तर त्यस बाछाको छाला, त्यसका सबै मासु, टाउको, खुट्टाहरू, भित्री भागहरू र गोबर— ");
INSERT INTO npioncb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","अर्थात् बाछाको सबै उब्रेका भागहरू त्यसले छाउनीको बाहिर शुद्ध गरिएको ठाउँमा खरानी फ्याँक्ने ठाउँमा लैजाओस्। अनि त्यसलाई खरानीको थुप्रोमाथि दाउराको आगोमा जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘यदि इस्राएलीहरूका सारा समुदायले अनजानमा पाप गर्छन्, र याहवेहका आज्ञाहरूमध्ये निषेध गरिएका कुनै काम गर्छन् भने त्यो समुदाय अज्ञानी भए तापनि तिनीहरू दोषी हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","जब आफूले गरेका पाप तिनीहरूलाई थाहा हुन्छ, तब समुदायले पाप शुद्धीकरण बलिस्वरूप एउटा बाछा ल्याएर समागम पालको सामु लिएर आऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","समुदायका प्रधानहरूले याहवेहको सामु बाछाको शिरमाथि आफ्ना हातहरू राखेपछि त्यो बाछा याहवेहको सामु मारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","त्यसपछि प्रधान पुजारीले त्यस बाछाको केही रगत लिएर समागम पालभित्र ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","त्यसले आफ्नो औँला रगतमा चोपेर याहवेहको अगि पर्दाको सामु सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","त्यसले केही रगत समागम पालमा याहवेहको सामु भएको वेदीका सिङहरूमा लगाओस्। बाँकी रहेको रगत त्यसले समागम पालको प्रवेशद्वारमा भएको होमबलिको वेदीको फेदमा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","त्यसले सबै बोसो त्यसबाट निकालोस् र त्यसलाई वेदीमाथि जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","अनि त्यस बाछालाई पाप शुद्धीकरण बलिको बाछालाई गरेझैँ गरोस्। यसरी पुजारीले तिनीहरूका निम्ति प्रायश्‍चित गरून्; अनि तिनीहरूलाई क्षमा गरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","त्यसपछि त्यसले बाछालाई छाउनीको बाहिर लैजाओस्, र त्यसलाई पहिलो बाछालाई जस्तै जलाओस्। यो समुदायका निम्ति पाप शुद्धीकरण बलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘जब कुनै अगुवाले अनजानमा पाप गर्छ, र याहवेह आफ्नो परमेश्‍वरका आज्ञाहरूमध्ये निषेध गरेको कुनै काम गर्छ, त्यो दोषी हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","जब त्यसले गरेको पाप त्यसलाई प्रकट गराइन्छ, तब त्यसले बलिको रूपमा एउटा निष्खोट बोका ल्याउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","त्यसले बोकाको शिरमाथि आफ्नो हात राखोस्, र त्यसलाई याहवेहको सामु होमबलि मारिने ठाउँमा मार्नुपर्छ। यो पाप शुद्धीकरण बलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","त्यसपछि पुजारीले पाप शुद्धीकरण बलिको रगतबाट आफ्नो औँलाले केही लिएर होमबलिको वेदीका सिङहरूमा लगाओस् र बाँकी रहेको रगत वेदीको फेदमा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","त्यसले सबै बोसो आफूले मेलबलिलाई गरेझैँ वेदीमाथि जलाओस्। यसरी पुजारीले त्यस मानिसको पापको प्रायश्‍चित गर्नेछ, र त्यसले क्षमा पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘समुदायको कसैले अनजानमा पाप गर्छ, र याहवेहका आज्ञाहरूमध्ये निषेध गरेको कुनै काम गर्छ भने त्यो दोषी हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","जब त्यसलाई आफूले गरेको पाप प्रकट गराइन्छ, तब त्यसले आफ्नो पापका निम्ति बलिस्वरूप एउटा निष्खोट पाठी ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","त्यसले त्यस पाप शुद्धीकरण बलिको शिरमाथि आफ्नो हात राखेर त्यसलाई होमबलि चढाउने ठाउँमा मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","त्यसपछि पुजारीले आफ्नो औँलाले त्यसबाट केही रगत लिएर होमबलिको वेदीका सिङहरूमा लगाओस्, र बाँकी रहेको रगत वेदीको फेदमा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","मेलबलिबाट बोसो निकालेझैँ त्यसले सबै बोसो झिकोस्। अनि पुजारीले त्यसलाई याहवेहलाई मनपर्ने बास्‍नाको रूपमा वेदीमाथि जलाओस्। यसरी पुजारीले त्यसका निम्ति प्रायश्‍चित गर्नेछ, र त्यसले क्षमा पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘यदि त्यसले आफ्नो पाप शुद्धीकरण बलिको रूपमा एउटा भेडाको पाठी ल्याउँछ भने त्यसले निष्खोट पाठी ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","त्यसको शिरमाथि त्यसले आफ्नो हात राखोस् र त्यसलाई पाप शुद्धीकरण बलिको रूपमा होमबलि मारिने ठाउँमा मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","त्यसपछि पुजारीले आफ्नो औँलाले पाप शुद्धीकरण बलिको रगतबाट केही लिएर होमबलिको वेदीका सिङहरूमा लगाओस्। अनि बाँकी रहेको रगत वेदीको फेदमा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","मेलबलिको भेडाको पाठोबाट बोसो निकालेझैँ त्यसले सबै बोसो झिकोस्। अनि पुजारीले त्यसलाई याहवेहलाई होमबलिको रूपमा चढाइने बलिको रूपमा वेदीमाथिको टुप्पोमा जलाओस्। यस किसिमले पुजारीले त्यसको लागि त्यसले गरेको पापको प्रायश्‍चित गर्नेछ, र त्यसले क्षमा पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘यदि कुनै व्यक्तिले यस्तो किसिमको पाप गर्‍यो, कि साक्षी भईकन पनि आफूले देखेको र जानेको विषयमा जनसाधारण अगि बोल्नुपर्दा पनि त्यस मानिसले केही बोलेन भने त्यो त्यसको लागि जिम्मेवार ठहराइनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘यदि कसैले कुनै अशुद्ध कुरा—वन पशु, गाईबस्तुका वा जमिनमा हिँड्‍डुल गर्ने जन्तुहरूका लास आफ्नो अज्ञानतामा छोयो भने त्यो विधिपूर्वक अशुद्ध हुँदछ र त्यो दोषी ठहरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","अथवा त्यसले अशुद्ध मानिसलाई छोयो (त्यसलाई अशुद्ध तुल्याउने कुनै पनि कुरा आफ्नो अज्ञानतामै छोयो) भने, र त्यसलाई त्यो थाहा भयो भने त्यो दोषी ठहरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","अथवा कसैले असल वा खराब केही गर्छु भनेर सोचविचारै नगरी शपथ खायो वा असावधानी भएर कुनै कुरामा शपथ खायो भने, र त्यसलाई त्यसको बारेमा ज्ञानै भएन, तर पनि जब त्यसले त्यो कुरालाई महसुस गर्छ, तब त्यो दोषी ठहरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","यीमध्ये कुनै कुरामा कोही दोषी छ भने त्यसले कुन कुरामा पाप गरेको छ, त्यो पाप स्वीकार गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","अनि त्यसले गरेको पापका दण्डस्वरूप याहवेहकहाँ बगालबाट पाप शुद्धीकरण बलिका लागि भेडाको पाठी वा बाख्राको पाठी ल्याओस्। अनि पुजारीले त्यसले गरेको पापको लागि त्यसका निम्ति प्रायश्‍चित गर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘यदि त्यो थुमा ल्याउन आर्थिक रूपमा असक्षम छ भने कलिला दुई वटा ढुकुर वा परेवाहरू याहवेहको सामु ल्याओस्—एउटा पाप शुद्धीकरण बलिका निम्ति र अर्को होमबलिका निम्ति। ");
INSERT INTO npioncb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","त्यसले ती पुजारीकहाँ ल्याओस्, जसले पहिला एउटालाई पाप शुद्धीकरण बलिका निम्ति चढाउनेछ। त्यसले त्यसको शिरलाई नचुँडाइकन घाँटी निमोठोस्, ");
INSERT INTO npioncb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","अनि त्यसको केही रगत पाप शुद्धीकरण बलिको रूपमा वेदीको छेउमा छर्कोस्। बाँकी रहेको रगत वेदीको फेदमा खन्याओस्। यो पाप शुद्धीकरण बलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","त्यसपछि पुजारीले अर्कोलाई चाहिँ होमबलिस्वरूप तोकिएको विधिअनुसार चढाओस्। अनि त्यसले गरेको पापको लागि त्यसका निम्ति प्रायश्‍चित गरोस्, र त्यसले क्षमा पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘तर त्यो दुई वटा कलिला ढुकुर वा परेवा ल्याउन पनि आर्थिक रूपमा असक्षम छ भने त्यसले आफ्नो पापका लागि पाप शुद्धीकरण बलिस्वरूप एपाको दशौँ भाग मसिनो पिठो ल्याओस्। त्यो पाप शुद्धीकरण बलि भएको हुनाले त्यसले त्यसमा जैतुनको तेल र धूप नराखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","त्यसले त्यो पुजारीकहाँ ल्याओस्, जसले त्यसबाट सम्झनाको भागका निम्ति एक मुठी लिएर याहवेहका निम्ति अग्निबलिको वेदीमाथि जलाओस्। यो पाप शुद्धीकरण बलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","यस किसिमले पुजारीले त्यसका निम्ति यी पापहरूमध्ये कुनै पनि पापको लागि प्रायश्‍चित गर्नेछ, र त्यसले क्षमा पाउनेछ। यसको बाँकी भाग अन्‍नबलिको समान पुजारीको हुनेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","फेरि याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“जब कसैले आज्ञा उल्‍लङ्घन गरेर अनजानमा याहवेहका पवित्र कुराहरूमा पाप गर्छ, त्यसले याहवेहकहाँ पवित्रस्थानको शेकेलअनुसार चाँदीको उचित मूल्य बराबरको एउटा निष्खोट भेडा आफ्नो बगालबाट दण्डस्वरूप ल्याओस्; यो दोषबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","त्यसले पवित्र चीजहरूको विषयमा जुन कुरा पूरा गर्न सकेन, त्यसको निम्ति त्यसले हर्जाना तिरोस्। त्यसले त्यस मूल्यमा यसको पाँचौँ भाग थपेर पुजारीलाई देओस्, जसले दोषबलिको रूपमा भेडा लिएर त्यसका निम्ति प्रायश्‍चित गर्नेछ, र त्यसले क्षमा पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“यदि कसैले पाप गर्छ, र याहवेहका आज्ञाहरूमध्ये कुनै पनि निषेध गरेको काम अनजानमा गर्छ भने त्यो दोषी हो, र त्यो दण्डको योग्य ठहरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","त्यसले दोषबलिस्वरूप आफ्नो बगालबाट निष्खोट र उचित मूल्यको एउटा बोका पुजारीकहाँ ल्याओस्। यस प्रकार त्यसले अनजानमा गरेको अपराधका लागि पुजारीले प्रायश्‍चित गर्नेछ, र त्यसले क्षमा पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यो दोषबलि हो, त्यसले याहवेहको विरुद्धमा गरेको अपराधको त्यो दोषी छ।” ");
INSERT INTO npioncb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“यदि कसैले छिमेकीले सुम्पेको केही सामान त्यसलाई अथवा त्यसको जिम्मामा राखेको कुनै सामान चोरी भएको छ भने वा आफ्नो छिमेकीलाई ठगेर पाप गर्छ भने, र याहवेहप्रति विश्‍वासघाती बन्छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","अथवा त्यसले कुनै हराएको सम्पत्ति पाएर त्यस विषयमा झूटो बोल्छ, अथवा झूटो शपथ खान्छ भने, अथवा मानिसहरूले गर्नेजस्ता पाप गर्छ भने; ");
INSERT INTO npioncb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","जब त्यसले यसरी पाप गर्छ, र त्यो दोषी भएको आभास गर्छ; त्यसले चोरेको अथवा लुटेको सामान अथवा त्यसलाई सुम्पेको सामान अथवा हराएको सामान त्यसले भेट्टाएको छ, ");
INSERT INTO npioncb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","अथवा जुनसुकै कुरा, जसको बारेमा त्यसले झूटो शपथ खाएको छ; त्यसले यी सबै कुरा यिनीहरूमा पाँचौँ भाग थपेर पूरा फर्काइदिनुपर्छ। त्यसले दोषबलि चढाउने दिनमा, त्यो सामान जसको हो, उसैलाई दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","अनि दण्डस्वरूप त्यसले पुजारीकहाँ आफ्नो दोषबलि याहवेहका लागि आफ्नो बगालबाट निष्खोट र उचित मूल्यको एउटा भेडा ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","यसरी पुजारीले याहवेहको सामु त्यसका निम्ति प्रायश्‍चित गर्नेछ। अनि आफूलाई दोषी ठहराउने कामबाट त्यसलाई क्षमा मिल्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून र त्यसका छोराहरूलाई यो आज्ञा दिनू: ‘होमबलिका नियमहरू यिनै हुन्: होमबलि दाउरामाथि रातभरि वेदीको आगो बल्ने स्थानमा बिहानसम्मै रहिरहोस् र वेदीमा आगो बलिरहोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","त्यसपछि पुजारीले आफ्ना सुतीका पोशाकहरू र भित्री सुती पोशाकहरू शरीरमा लगाओस्, र वेदीमा आगोले जलाएको होमबलिको खरानी निकालेर वेदीको छेउमा राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","तब त्यसले यी वस्त्र फुकालेर अर्को वस्त्र लगाएर छाउनीदेखि बाहिर एउटा चोखो ठाउँमा त्यो खरानी बोकेर लैजाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदीमाथिको आगो जलिरहोस्; र त्यो निभ्न नपाओस्। हरेक बिहान पुजारीले त्यसमा दाउरा थपेर होमबलिलाई आगोमाथि मिलाओस् र त्यसमाथि मेलबलिको बोसो जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीमाथि आगो निरन्तर जलिरहोस्; त्यो कहिल्यै ननिभोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘अन्‍नबलिका नियमहरू यिनै हुन्: हारूनका छोराहरूले त्यसलाई याहवेहको सामु वेदीको अगिल्तिर ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","पुजारीले एक मुठी मसिनो पिठो र केही जैतुनको तेल, र सबै धूपहरू त्यस अन्‍नबलिमाथि लिएर सम्झनाको भाग याहवेहलाई मनपर्ने बास्‍नाको रूपमा वेदीमाथि जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","बाँकी रहेको भाग हारून र त्यसका छोराहरूले खानेछन्। तर त्यो खमिरविना पवित्रस्थानमा समागम पालको आँगनमा खाइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","त्यसलाई खमिरसित पकाइनुहुँदैन। त्यो म याहवेहलाई अग्निबलिको रूपमा चढाइएका भेटीहरूबाट तिनीहरूको भागस्वरूप मैले तिनीहरूलाई दिएको छु। पाप शुद्धीकरण बलि र दोषबलिझैँ त्यो अति पवित्र छ। ");
INSERT INTO npioncb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","हारूनका सन्ततिमध्ये कुनै पनि पुरुषले त्यो खान सक्छ। याहवेहलाई अग्निबलिको रूपमा चढाइएका बलिहरूबाट त्यो तिनीहरूका आउने पुस्ताहरूका निम्ति नियमित भाग हो। जजसले यी बलिहरूलाई छुन्छन्, तिनीहरू पवित्र हुनेछन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“हारून र तिनका छोराहरू अभिषेक भएका दिन तिनीहरूले यी भेटी याहवेहकहाँ ल्याऊन्। मसिनो पिठो एपाको दशौँ भाग नियमित अन्‍नबलिको रूपमा बिहान आधा र बेलुका आधा। ");
INSERT INTO npioncb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","त्यसलाई तेलसँग ताप्केमा तयार पारेर राम्रो गरी मिसाएर ल्याउनू। त्यो अन्‍नबलि टुक्रा-टुक्रा गरी भाँचेर याहवेहलाई मनपर्ने बास्‍नाको रूपमा प्रस्तुत गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","जुन छोराले पछि प्रधान पुजारीको रूपमा कार्यभार सम्हाल्नेछ, त्यसैले त्यो तयार गरोस्। त्यो याहवेहको नियमित भाग हो, र त्यसलाई पूरा जलाइओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","पुजारीको हरेक अन्‍नबलि सबै जलाइओस्, यो खानुहुँदैन।” ");
INSERT INTO npioncb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून र त्यसका छोराहरूलाई यसो भन्: ‘पाप शुद्धीकरण बलिका नियमहरू यिनै हुन्: पाप शुद्धीकरण बलिलाई होमबलि मारिएको ठाउँमा याहवेहको सामु मारियोस्, त्यो अति पवित्र हो। ");
INSERT INTO npioncb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जुन पुजारीले त्यो चढाउनेछ, त्यसले नै त्यो खानेछ। त्यसलाई पवित्रस्थानमा समागम पालको आँगनमा खाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जुन कुरोले यो मासुलाई छुन्छ, त्यो पवित्र हुनेछ। अनि रगतबाट केही छिर्का कुनै लुगामा पर्‍यो भने तिमीहरूले त्यसलाई कुनै पवित्र ठाउँमा धुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","मासु पकाएको माटोको भाँडा फुटाइनुपर्छ। तर यदि त्यसलाई काँसोको भाँडामा पकाइएको हो भने त्यो भाँडालाई राम्ररी माझेर पानीमा पखाल्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","पुजारीका परिवारको कुनै पनि पुरुषले त्यो खान सक्छ, त्यो अति पवित्र हो। ");
INSERT INTO npioncb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","तर कुनै पाप शुद्धीकरण बलिको रगत पवित्र ठाउँमा प्रायश्‍चितका लागि समागम पालभित्र ल्याइयो भने त्यसलाई खानुहुँदैन। यसलाई आगोमा जलाइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘दोषबलिका नियमहरू यिनै हुन्, जो अति पवित्र छ: ");
INSERT INTO npioncb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","दोषबलिलाई होमबलि मारिएको ठाउँमा मारियोस्। अनि त्यसको रगत वेदीको चारैतिर छर्कियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","त्यसका सबै बोसो चढाइनुपर्छ। बोसे पुच्छर र भित्री भागलाई छोप्ने बोसो, ");
INSERT INTO npioncb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","कम्मरनिरका दुवै मिर्गौला र ती नजिकको बोसो, कलेजोलाई छोपेको बोसो, जसलाई मिर्गौलाहरूसितै निकाल्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पुजारीले तिनलाई याहवेहका निम्ति अग्निबलिको रूपमा वेदीमाथि जलाऊन्, यो दोषबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","पुजारीको परिवारको कुनै पनि पुरुषले त्यो खान सक्छ। तर त्यसलाई पवित्रस्थानमा खाइयोस्; यो अति पवित्र छ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘दोषबलिका नियमहरू पाप शुद्धीकरण बलि समान हुन्: तिनका निम्ति एउटै व्यवस्था छ। जुन पुजारीले त्यो चढाएर प्रायश्‍चित गर्छ, त्यो त्यसैको हो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","कसैका निम्ति होमबलि चढाउने पुजारीले त्यसको छाला आफ्नै निम्ति राख्न सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","चुलोमा पकाइएका अथवा ताप्के वा तावामा पकाइएका हरेक अन्‍नबलि त्यसलाई चढाउने पुजारीको हो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","जैतुन तेलसँग मिसाइएको अथवा सुक्खा हरेक अन्‍नबलि हारूनका सबै छोराहरूका निम्ति बराबर भाग हो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘याहवेहका निम्ति चढाइने मेलबलिका नियमहरू यिनै हुन्: ");
INSERT INTO npioncb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘यदि यसलाई धन्यवाद दिनलाई चढाएको हो भने त्यसले आफ्नो धन्यवाद बलिको साथमा अखमिरी, जैतुन तेल मिसाएर पकाइएको बाक्लो रोटी, अखमिरी, तेल दलेर बनाइएको पातलो रोटी र मसिनो पिठो राम्रो गरी मुछेर तेल मिसाएको फुरौला चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","त्यसले आफ्नो धन्यवादको मेलबलिसित खमिर मिसाएको बाबरको रोटी भेटी चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","त्यसले हरेक किसिमका रोटी एक-एक गरी भेटीको रूपमा याहवेहका निम्ति स्वेच्छा भेटीस्वरूप ल्याओस्। यो मेलबलिको रगत छर्कने पुजारीको हो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","धन्यवादको मेलबलिको मासु त्यसलाई चढाइएको दिनमै खाइयोस्। त्यसले यसको केही भाग पनि बिहानसम्म नराखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘तर यदि त्यसको भेटी भाकलको अथवा स्वेच्छा-भेटी हो भने त्यो बलिदान यसलाई चढाइएकै दिन खाइयोस्। तर केही उब्रियो भने भोलिपल्ट खान सकिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","तेस्रो दिनसम्म उब्रेका बलिदानको मासु जलाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","यदि कसैले मेलबलिको मासु उब्रेको तेस्रो दिनमा खायो भने त्यो ग्रहणयोग्य हुनेछैन। त्यो अशुद्ध भएकोले त्यसलाई चढाउनेले त्यो चढाएको मान्यता पाउनेछैन। यसलाई खाने व्यक्ति दोषी ठहरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘विधिपूर्वक अशुद्ध कुरालाई छोएको मासु खान हुँदैन, त्यो जलाइयोस्। अरू मासुचाहिँ विधिपूर्वक शुद्ध भएकाहरूले खान सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","तर कुनै अशुद्ध व्यक्तिले मेलबलिबाट याहवेहको भाग खायो भने त्यसलाई त्यसका मानिसहरूबाट बहिष्कार गरियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","यदि कसैले कुनै अशुद्ध कुरा छोयो भने चाहे त्यो मानिसको अशुद्धता अथवा अशुद्ध पशु वा कुनै घृणित कुरो होस्, त्यसले याहवेहका मेलबलिको भाग खायो भने त्यस व्यक्तिलाई समाजबाट बहिष्कार गरियोस्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलीहरूलाई यसो भन्: ‘कुनै गाईबस्तु, भेडा अथवा बोकाको बोसो नखानू। ");
INSERT INTO npioncb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","प्राकृतिक रूपमा मरेको अथवा वन पशुहरूद्वारा मारिएको पशु भेट्टाइयो भने त्यसको बोसोलाई अरू काममा लगाउन सकिन्छ। तर तिमीहरूले चाहिँ त्यो खाँदै नखानू। ");
INSERT INTO npioncb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","जुन पशुबाट याहवेहका निम्ति अग्निबलि चढाइएको छ, त्यसको बोसो खाने व्यक्ति आफ्ना मानिसहरूबाट बहिष्कार गरियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","तिमीहरू जहाँ बसे तापनि चराचुरुङ्गी अथवा पशुको रगत नखानू। ");
INSERT INTO npioncb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","जुन व्यक्तिले रगत खान्छ, त्यसलाई त्यसका मानिसहरूबाट बहिष्कार गरियोस्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलीहरूलाई यसो भन्: ‘जसले याहवेहका निम्ति मेलबलि ल्याउँछ, त्यसले यसको केही भाग याहवेहका निम्ति आफ्नो बलिदानस्वरूप ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","त्यसले याहवेहका निम्ति अग्निबलिको भेटी आफ्नै हातले ल्याओस्। त्यसले बोसो ह्‍याकुलोसितै ल्याओस्; अनि त्यस ह्‍याकुलोलाई विशेष भेटीको रूपमा याहवेहको सामु उचालिओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","पुजारीले बोसो वेदीमाथि जलाओस्; तर ह्‍याकुलोचाहिँ हारून र त्यसका छोराहरूको हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","दाहिने फिलाचाहिँ तिमीहरूले आफ्नो मेलबलिबाट स्वेच्छा भेटीको रूपमा पुजारीलाई दिनू। ");
INSERT INTO npioncb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारूनको जुन छोराले मेलबलिको रगत र बोसो चढाउँछ, त्यो दाहिने फिलाको हकदार हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","मैले इस्राएलीहरूको मेलबलिबाट विशेष भेटीको रूपमा उचालिएको ह्‍याकुला र चढाएको फिला लिएर ती हारून पुजारी र त्यसका छोराहरूलाई इस्राएलीहरूबाट नियमित भागस्वरूप दिएको छु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","याहवेहकहाँ अग्निबलिको भेटीको भाग यही हो, जुन पुजारी भई सेवा गर्नलाई हारून र त्यसका छोराहरूलाई प्रस्तुत गरिएको दिन तिनीहरूका निम्ति भाग लगाइएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","तिनीहरू अभिषेक भएको दिन याहवेहले इस्राएलीहरूलाई पुस्तौँसम्म आफ्नो नियमित भाग तिनीहरूलाई दिनू भनी आज्ञा दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","यसकारण होमबलि, अन्‍नबलि, पाप शुद्धीकरण बलि, दोषबलि, अर्पणबलि, भेटी र मेलबलिका नियमहरू यिनै हुन्, ");
INSERT INTO npioncb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जुन याहवेहले मोशालाई सीनै पर्वतमा दिनुभएको थियो; त्यही दिन सीनैको मरुभूमिमा याहवेहले इस्राएलीहरूलाई उहाँका निम्ति भेटी ल्याउने आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून र त्यसका छोराहरूलाई, तिनीहरूका पोशाकहरू, अभिषेक गर्ने तेल, पाप शुद्धीकरण बलिका निम्ति साँढे, दुई वटा भेडाहरू र खमिर नमिसाइएको रोटी भएका डालो लिएर आइज। ");
INSERT INTO npioncb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","अनि सारा समुदायलाई समागम पालको प्रवेशद्वारमा भेला गर्।” ");
INSERT INTO npioncb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","तब याहवेहले आज्ञा गर्नुभएझैँ मोशाले गरे। अनि समागम पालको प्रवेशद्वारमा समुदाय भेला भयो। ");
INSERT INTO npioncb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मोशाले समुदायलाई भने, “याहवेहले यसो गर्नू भन्‍ने आज्ञा दिनुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","तब मोशाले हारून र तिनका छोराहरूलाई अगाडि ल्याएर पानीले नुहाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","तिनले हारूनलाई अलखा लगाइदिए। पटुका बाँधिदिए, र तिनलाई लबेदा लगाएर एपोदको पोशाक पहिर्‍याइदिए। तिनले उनमा कुशल शिल्पकारद्वारा तयार गरिएको पटुकाले एपोद पनि बाँधिदिए। यसरी त्यो तिनमा कसियो। ");
INSERT INTO npioncb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","तिनले उनीमाथि छाती-पाता लगाएर त्यसमा ऊरीम र तुम्मीम लगाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","त्यसपछि तिनले हारूनको शिरमा फेटा लगाइदिए। अनि याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनले सुनको पाता र पवित्र मुकुट त्यसको सामु लगाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","त्यसपछि मोशाले अभिषेक गर्ने तेल लिएर समागम पाल र त्यसभित्र भएका प्रत्येक चीजलाई अर्पण गरे; र सबै कुराहरूलाई पवित्र गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","तिनले वेदी र त्यसका सबै भाँडाकुँडा, बाटा र त्यसको खम्बालाई अर्पण गर्नलाई अभिषेक गर्दै केही तेल वेदीमाथि सात चोटि छर्के। ");
INSERT INTO npioncb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","तिनले अभिषेक गर्ने तेलबाट केही लिएर हारूनलाई पवित्र गरे, र अभिषेक गर्नका लागि तिनको शिरमाथि खन्याए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","त्यसपछि तिनले हारूनका छोराहरूलाई अगाडि ल्याएर लबेदा लगाइदिए। पटुका बाँधिदिए, र याहवेहले मोशालाई आज्ञा दिनुभएझैँ तिनीहरूको शिरमा फेटा बाँधिदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","त्यसपछि तिनले पाप शुद्धीकरण बलिको बाछा अगाडि ल्याए। अनि हारून र तिनका छोराहरूले त्यसको शिरमाथि हात राखे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","मोशाले त्यस बाछालाई मारे। अनि केही रगत लिएर वेदीलाई शुद्ध पार्नलाई आफ्ना औँलाले वेदीका सबै सिङहरूमाथि छर्के। तिनले उब्रेको रगत वेदीको फेदमा खन्याइदिए। यसरी तिनले प्रायश्‍चित गर्नलाई वेदीलाई अर्पण गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मोशाले भित्री भागका चारैतिरका बोसो, कलेजोलाई छोप्ने आवरण, दुवै मिर्गौला र बोसोसमेत लिए। अनि ती सबैलाई वेदीमाथि जलाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","तर बाछालाई त्यसको छाला, मासु र गोबरसमेत जसरी याहवेहले मोशालाई आज्ञा गर्नुभएको थियो, त्यसरी नै तिनले छाउनीबाहिर जलाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","त्यसपछि तिनले होमबलिको निम्ति भेडा प्रस्तुत गरे। अनि हारून र तिनका छोराहरूले त्यसको शिरमाथि आफ्ना हात राखे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","तब मोशाले त्यस भेडालाई मारे; अनि त्यो रगत वेदीको चारैतिर भित्तामा छर्के। ");
INSERT INTO npioncb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","मोशाले भेडालाई टुक्रा-टुक्रा पारी काटे; अनि टाउको, टुक्राहरू र बोसो जलाए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","मोशाले भित्री भागहरू र खुट्टाहरू पानीले पखाले; अनि त्यो याहवेहका निम्ति आगोद्वारा चढाइएको मिठो बास्‍नाको होमबलिस्वरूप तिनले सिङ्गै भेडा वेदीमा जलाए; जसरी याहवेहले मोशालाई आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","त्यसपछि तिनले अर्को भेडा, अर्थात् अर्पणको भेडालाई प्रस्तुत गरे; अनि हारून र तिनका छोराहरूले त्यसको शिरमाथि आफ्ना हात राखे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","मोशाले भेडालाई मारे; अनि त्यसको रगतबाट केही लिएर त्यसलाई हारूनको दाहिने कानको लोतीमा, तिनको दाहिने हातको बूढी औँलामा र तिनको दाहिने खुट्टाको बूढी औँलामा लगाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मोशाले हारूनका छोराहरूलाई पनि अगाडि ल्याए। केही रगत लिएर तिनीहरूका दाहिने कानका लोतीहरूमा, तिनीहरूका दाहिने हातका बूढी औँलाहरूमा र तिनीहरूका दाहिने खुट्टाका बूढी औँलाहरूमा लगाइदिए। त्यसपछि तिनले वेदीका चारैतिर रगत छर्किदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","त्यसपछि बोसो, बोसे पुच्छर, भित्री भागका वरिपरि भएका बोसो, चारैतिरका बोसो, कलेजोको आवरण, बोसोसमेतका दुवै मिर्गौला र दाहिने फिला लिए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","त्यसपछि तिनले याहवेहको सामु राखिएको खमिर नमिसाइएको रोटीको टोकरीबाट एउटा बाक्लो रोटी र जैतुन तेल मिसाएर बनाएको एउटा बाक्लो रोटी र एउटा पातलो रोटी लिएर तिनले ती बोसोको भाग र दाहिने फिलामा हाले। ");
INSERT INTO npioncb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","तिनले ती सबै हारून र तिनका छोराहरूका हातमा राखे; अनि उनीहरूले यसलाई विशेष भेटीको रूपमा याहवेहको सामु उचाले र अर्पण गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","त्यसपछि मोशाले ती कुराहरू तिनीहरूका हातबाट लिएर वेदीमाथि भएको होमबलिको टुप्पोमा अर्पणबलिको भेटीस्वरूप याहवेहका निम्ति आगोद्वारा चढाइएको मनपर्ने बास्‍नाझैँ उहाँलाई चढाए। ");
INSERT INTO npioncb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","मोशाले ह्‍याकुला लिए, जुनचाहिँ अर्पण गरिएको भेडाबाट उनको भाग थियो। अनि यसलाई विशेष भेटीको रूपमा याहवेहको सामु उचाले र अर्पण गरे; जसरी याहवेहले मोशालाई आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","त्यसपछि मोशाले अभिषेक गर्ने तेलबाट केही तेल र वेदीबाट केही रगत लिए, र ती हारून र तिनका पोशाकहरूमाथि अनि तिनका छोराहरू र तिनीहरूका पोशाकहरूमाथि छर्के। यसरी तिनले हारूनलाई उनका पोशाकहरू, उनका छोराहरू र उनीहरूका पोशाकहरूसमेत पवित्र गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","त्यसपछि मोशाले हारून र उनका छोराहरूलाई भने, “समागम पालको प्रवेशद्वारमा मासु पकाएर तिमीहरूले यो खानू। मैले आज्ञा दिएझैँ तिमीहरूले त्यहाँ अर्पणबलिको डालोको रोटीसित खानू। ");
INSERT INTO npioncb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","त्यसपछि उब्रेका मासु र रोटी त्यसलाई जलाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","तिमीहरूको अर्पण सात दिनसम्म हुने हुनाले तिमीहरूको अर्पण समाप्‍त नहोउन्जेल समागम पालको प्रवेशद्वारलाई सात दिनसम्म नछोड्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","आज जे गरिएको छ, त्यो तिमीहरूको प्रायश्‍चित गर्नका लागि याहवेहले आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","तिमीहरू समागम पालको प्रवेशद्वारमा सात दिनसम्म दिउँसो र राति बस्‍नू। याहवेहले चाहेझैँ गर्नू; अनि तिमीहरू मर्नेछैनौ। किनकि मलाई यही आज्ञा भएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","यसकारण हारून र तिनका छोराहरूले याहवेहले मोशाद्वारा आज्ञा गर्नुभएझैँ सबै कार्य गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठौँ दिनमा मोशाले हारून र तिनका छोराहरू अनि इस्राएलका प्रधानहरूलाई बोलाए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","तिनले हारूनलाई भने, “आफ्नो पाप शुद्धीकरण बलिका निम्ति एउटा निष्खोट बाछा र होमबलिका निम्ति एउटा निष्खोट भेडा ल्याऊनू। अनि तिनीहरूलाई याहवेहको सामु प्रस्तुत गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","त्यसपछि इस्राएलीहरूलाई भन्‍नू: ‘पाप शुद्धीकरण बलिका निम्ति एउटा बोका, होमबलिका निम्ति एउटा बाछा र एउटा थुमा ल्याउनू—दुवै एक वर्ष र निष्खोट भएको। ");
INSERT INTO npioncb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अनि मेलबलिका निम्ति एउटा गोरु र एउटा भेडा जैतुन तेलसँग मिसाएको अन्‍नबलिको साथमा याहवेहको सामु बलिदान गर्न ल्याउनू; किनकि आज याहवेह तिमीहरूकहाँ देखा पर्नुहुनेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","तिनीहरूले मोशाले आज्ञा गरेका चीजहरू समागम पालको सामु लगे। अनि सारा समुदाय नजिक आएर याहवेहको सामु उभिए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","तब मोशाले भने, “याहवेहको महिमा तिमीहरूकहाँ देखा परोस् भनेर तिमीहरूले के गर्नुपर्छ भनी याहवेहले आज्ञा दिनुभएको यही हो।” ");
INSERT INTO npioncb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मोशाले हारूनलाई भने, “वेदीमा आउनुहोस्, र आफ्नो पाप शुद्धीकरण बलि र होमबलि चढाउनुहोस्। अनि आफ्नो र मानिसहरूका निम्ति प्रायश्‍चित गर्नुहोस्; जुन भेटी मानिसहरूका निम्ति हो, त्यसलाई चढाउनुहोस्। अनि याहवेहले आज्ञा गर्नुभएझैँ तिनीहरूका निम्ति प्रायश्‍चित गर्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","यसकारण हारून वेदीको छेउमा आए, र आफ्नै निम्ति पाप शुद्धीकरण बलिस्वरूप बाछालाई मारे। ");
INSERT INTO npioncb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","हारूनका छोराहरूले उनीकहाँ रगत ल्याए। तिनले आफ्नो औँला रगतमा चोपेर त्यसलाई वेदीका सिङहरूमा लगाए। उब्रेको रगत तिनले वेदीको फेदमा खन्याइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","वेदीमाथि तिनले पाप शुद्धीकरण बलिबाट बोसो, मिर्गौलाहरू र कलेजोको आवरण, याहवेहले मोशालाई आज्ञा गर्नुभएझैँ जलाए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","मासु र छाला तिनले छाउनीबाहिर आगोमा जलाए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","तब हारूनले होमबलिको लागि पशु मारे। अनि उनका छोराहरूले तिनीकहाँ रगत ल्याइदिए। तिनले त्यसलाई वेदीका चारैतिर छर्के। ");
INSERT INTO npioncb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","हारूनका छोराहरूले तिनलाई होमबलिको टुक्राहरूका साथमा टाउकोसमेत दिए। तिनले ती वेदीमाथि जलाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","तिनले भित्री भागहरू र खुट्टाहरू धोएर वेदीमाथि भएको होमबलिको टुप्पोमा राखेर जलाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","त्यसपछि हारूनले मानिसहरूका निम्ति बलि ल्याएर तिनीहरूका पाप शुद्धीकरण बलिको बोका मारे; अनि पहिलेको जस्तै पाप शुद्धीकरण बलिका लागि त्यो चढाए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","तिनले होमबलि ल्याएर विधिपूर्वक त्यो चढाए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","त्यसपछि तिनले अन्‍नबलि पनि ल्याए। त्यसबाट एक मुठी लिएर बिहानको होमबलिसँगै त्यसलाई पनि वेदीमाथि चढाए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","तिनले मानिसहरूका निम्ति मेलबलिस्वरूप गोरु र भेडालाई मारे। हारूनका छोराहरूले तिनलाई रगत दिए। अनि तिनले त्यसलाई वेदीका चारैतिर भित्ताहरूमा छर्के। ");
INSERT INTO npioncb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","तर गोरु र भेडाका बोसोका भागहरू, बोसे पुच्छर, बोसोको पत्र, मिर्गौलाहरू र कलेजोको आवरण; ");
INSERT INTO npioncb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","तिनीहरूले ह्‍याकुलाहरूमाथि राखे। अनि त्यसपछि हारूनले बोसोलाई वेदीमाथि जलाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","हारूनले ह्‍याकुलाहरू र दाहिने फिला मोशाले आज्ञा दिएझैँ विशेष भेटीको रूपमा याहवेहको सामु उचाले र अर्पण गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तब हारूनले आफ्ना हात मानिसहरूतिर उठाएर तिनीहरूलाई आशिष् दिए। यसरी पाप शुद्धीकरण बलि, होमबलि र मेलबलि चढाएर तिनी तल ओर्ले। ");
INSERT INTO npioncb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","त्यसपछि मोशा र हारून समागम पालभित्र गए। जब तिनीहरू बाहिर निस्के, तब तिनीहरूले मानिसहरूलाई आशिष् दिए। तब याहवेहको महिमा सबै मानिसहरूकहाँ देखा पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","याहवेहको उपस्थितिबाट आगो निस्केर आयो। अनि वेदीमाथि भएको होमबलि र बोसोको भागलाई भस्म पारिदियो। जब सबै मानिसहरूले त्यो देखे, तब तिनीहरू हर्षले चिच्याए, र घोप्टो परेर लोटे। ");
INSERT INTO npioncb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","हारूनका छोराहरू नादाब र अबीहूले धुपौरो लिएर त्यसमा आगो हाले, र त्यसमाथि धूप थपे। यसरी तिनीहरूले याहवेहको आज्ञा विपरीत अनाधिकृत आगो याहवेहको सामु चढाए। ");
INSERT INTO npioncb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","यसकारण याहवेहको उपस्थितिबाट आगो निस्केर आयो र तिनीहरूलाई भस्म पार्‍यो। अनि तिनीहरू याहवेहको सामु मरे। ");
INSERT INTO npioncb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","तब मोशाले हारूनलाई भने, “याहवेहले भन्‍नुभएको कुरा यही हो: “ ‘मेरो नजिक आउनेहरूमा म आफूलाई पवित्र देखाउनेछु; अनि सबै मानिसहरूका सामु म सम्मानित हुनेछु।’ ” हारून चुपचाप बसे। ");
INSERT INTO npioncb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मोशाले हारूनका काका उज्जीएलका छोराहरू मिशाएल र एलसाफानलाई बोलाइपठाए, र तिनीहरूलाई भने, “यहाँ आओ! तिमीहरूका भाइहरूलाई बोकेर छाउनीबाहिर पवित्रस्थानको सामुबाट टाढा लैजाओ।” ");
INSERT INTO npioncb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","यसकारण तिनीहरू आए। तिनीहरूलाई लबेदा लगाएकै अवस्थामा मोशाले हुकुम गरेझैँ छाउनीबाहिर बोकेर लगे। ");
INSERT INTO npioncb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","त्यसपछि मोशाले हारून र तिनका छोराहरू एलाजार र ईतामारलाई भने, “तिमीहरूका केश खुल्‍ला नछोड्नू र आफ्ना लुगा नच्यात्नू; नत्रता तिमीहरू मर्नेछौ। अनि याहवेह सारा समुदायमाथि रिसाउनुहुनेछ। तर तिमीहरूका आफन्तहरू, इस्राएलका सारा घरानाले याहवेहले आगोद्वारा नष्‍ट गर्नुभएकाहरूका निम्ति विलाप गरून्। ");
INSERT INTO npioncb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","समागम पालको प्रवेशद्वारबाट कतै नजानू, नत्रता तिमीहरू मर्नेछौ। किनकि याहवेहको अभिषेकको तेल तिमीहरूमाथि छ।” यसकारण तिनीहरूले मोशाले आदेश गरेझैँ गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","त्यसपछि याहवेहले हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“तँ र तेरा छोराहरूले समागम पालभित्र पस्दा मद्य अथवा मातिने चीज मिसाएको कुरा नपिउनू; नत्रता तिमीहरू मर्नेछौ। यो भावी पुस्तासम्मका लागि सदा रहिरहने विधि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","तिमीहरूले पवित्र र अपवित्र, अशुद्ध र शुद्धको बीचमा भिन्‍नता राख्न सक। ");
INSERT INTO npioncb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अनि याहवेहले मोशाद्वारा दिनुभएका सबै आदेशहरू तैँले इस्राएलीहरूलाई सिकाउनुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मोशाले हारून र तिनका बाँकी रहेका छोराहरू, एलाजार र ईतामारलाई भने, “याहवेहका निम्ति आगोद्वारा चढाइएको अन्‍नबलिबाट उब्रेको भाग, जो खमिरविनाको छ, यसलाई लिएर वेदीको छेउमा खानू; किनकि यो अति पवित्र छ। ");
INSERT INTO npioncb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","यसलाई एउटा पवित्रस्थानमा खानू; किनकि यो याहवेहलाई आगोद्वारा चढाइएको भेटी तिमीहरू र तिमीहरूका छोराहरूको भाग हो; किनकि मलाई यस्तै आज्ञा भएको छ। ");
INSERT INTO npioncb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","तर तिमीहरू र तिमीहरूका छोराछोरीहरूले विशेष भेटीको रूपमा उचालिएको र अर्पण गरिएको ह्‍याकुला र चढाइएको फिला खान सक्छौ। यिनलाई विधिपूर्वक शुद्ध पारिएको ठाउँमा खानू। तिमीहरू र तिमीहरूका सन्तानलाई इस्राएलीहरूका मेलबलिहरूबाट तिमीहरूका भागको रूपमा दिइएको हो। ");
INSERT INTO npioncb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","चढाइएको फिला र विशेष भेटीको रूपमा उचालिएको र अर्पण गरिएको ह्‍याकुला भेटीस्वरूप याहवेहको सामु आगोद्वारा चढाइएको बोसोको भागसित ल्याउनुपर्छ। याहवेहले आज्ञा गर्नुभएझैँ यी कुराहरू तिमीहरू र तिमीहरूका सन्तानको नियमित भाग हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","जब मोशाले पाप शुद्धीकरण बलिको बोकाको विषयमा सोधखोज गरे, र त्यसलाई जलाइसकेको थाहा पाए, तब हारूनका बाँकी रहेका छोराहरू एलाजार र ईतामारसित तिनी रिसाएर सोधे, ");
INSERT INTO npioncb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तिमीहरूले पाप शुद्धीकरण बलिलाई पवित्रस्थानमा किन खाएनौ? यो अति पवित्र हो। यो तिमीहरूलाई याहवेहको सामु समुदायका निम्ति प्रायश्‍चित गरेर तिनीहरूको दोष हटाउनका निम्ति दिइएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","त्यसको रगत पवित्रस्थानभित्र नलगिएको कारण मैले तिमीहरूलाई आज्ञा दिएझैँ तिमीहरूले त्यस बोकालाई पवित्रस्थानमा खानुपर्थ्यो।” ");
INSERT INTO npioncb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","हारूनले मोशालाई जवाफ दिए, “आज तिनीहरूले आफ्ना पाप शुद्धीकरण बलि र होमबलि याहवेहको सामु चढाए। तर यस्ता कुराहरू ममाथि आइपरे। मैले आज त्यो पाप शुद्धीकरण बलि खाएको भए के याहवेह मसित प्रसन्‍न हुनुहुनेथियो?” ");
INSERT INTO npioncb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","तब मोशाले यो कुरा सुनेपछि सन्तुष्‍ट भए। ");
INSERT INTO npioncb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलीहरूलाई भन्: ‘जमिनमाथि रहने सबै पशुहरूमध्ये तिमीहरूले खान हुने यिनीहरू हुन्: ");
INSERT INTO npioncb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","खुर अलग भएका, चिरिएका र उग्राउने जुनसुकै पशु पनि तिमीहरूले खान सक्छौ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘कतिपय पशुहरू, जसले उग्राउँछन् अथवा खुर मात्र चिरिएका हुन्छन्, तर ती नखानू। ऊँट, जसले उग्राउँछ, तर त्यसको खुर चिरिएको हुँदैन। त्यो तिमीहरूका लागि अशुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","भिर खरायो, जसले उग्राउँछ, तर त्यसको खुर चिरिएको हुँदैन; त्यो तिमीहरूका निम्ति अशुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","खरायो, जसले उग्राउँछ, तर त्यसको खुर चिरिएको हुँदैन; त्यो तिमीहरूका निम्ति अशुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अनि सुँगुर, त्यसको खुर पूरा चिरिएको भए तापनि त्यसले उग्राउँदैन। त्यो तिमीहरूका निम्ति अशुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","तिमीहरूले ती अशुद्ध जनावरहरूका मासु खानुहुँदैन। अनि त्यसको सिनो पनि छुनुहुँदैन। ती तिमीहरूका लागि अशुद्ध छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘समुद्र र खोलाहरूमा बस्‍ने जन्तुहरूमध्ये पखेटा र कत्ला भएका जुनसुकै जन्तु तिमीहरूले खान सक्छौ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","तर समुद्र र खोलाहरूमा बस्‍ने सबै जन्तुहरू, जसका पखेटा र कत्ला छैनन्—चाहे समूहमा बस्‍नेहरू होऊन्, वा पानीका अरू जन्तु होऊन्—तिमीहरूका निम्ति घृणित कुरा हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ती तिमीहरूका लागि घृणित भएकाले तिमीहरूले तिनीहरूका मासु नखानू। तिनीहरूका सिनोलाई घृणित ठान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","पानीमा बस्‍ने जुनसुकै जीवजन्तु, जसको पखेटा र कत्ला हुँदैन, त्यो तिमीहरूका लागि घृणित हो। ");
INSERT INTO npioncb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘यी चराचुरुङ्गी घृणित हुनाले तिमीहरूले यी नखानू—गरुड, गिद्ध, कालो गिद्ध; ");
INSERT INTO npioncb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","रातो चील, सबै थरीका कालो चील, ");
INSERT INTO npioncb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","सबै किसिमका काग; ");
INSERT INTO npioncb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ठूलो उल्‍लु, छोटो काने उल्‍लु, समुद्री चरो, सबै किसिमका बाज; ");
INSERT INTO npioncb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","सानो उल्‍लु, समुद्री बाज, विशाल उल्‍लु; ");
INSERT INTO npioncb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","सेतो उल्‍लु, मरुभूमिको उल्‍लु, माछा खाने चील; ");
INSERT INTO npioncb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, सबै किसिमका बकुल्‍ला, फाप्रेचरो र चमेरो। ");
INSERT INTO npioncb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘चारै खुट्टाले हिँड्ने र उड्ने सबै किराहरू तिमीहरूका निम्ति घृणित हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","तरै पनि केही पखेटा भएका जीवहरू, जो चार खुट्टाले हिँड्छन्, ती तिमीहरूले खान सक्छौ—जोर्नीहरूसहित भुइँमा उफ्रि हिँड्नका लागि खुट्टा भएका। ");
INSERT INTO npioncb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","यिनीहरूमध्ये तिमीहरूले सबै किसिमका सलह, खुइले सलह, किथ्रो वा फट्याङ्ग्रा खान सक्छौ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","तर पखेटा भएका अरू सबै जीवहरू, जसका चार खुट्टाहरू छन्, ती तिमीहरूले घृणित ठान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘यिनीहरूको कारणले गर्दा तिमीहरूले आफूलाई अशुद्ध पार्छौ; जसले यिनीहरूको सिनो छुन्छ, त्यो साँझसम्म अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","जसले तिनीहरूको सिनो उठाउँछ, त्यसले आफ्नो लुगा धुनुपर्छ, र त्यो साँझसम्म अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘प्रत्येक जीवजन्तु, जसको खुर चिरिएको छ, तर पूर्ण रूपमा फारिएको छैन, अथवा जसले उग्राउँदैन, त्यो तिमीहरूका लागि अशुद्ध हो। यिनीहरूमध्येका कुनैको सिनो जसले छुन्छ, त्यो अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","चार खुट्टाले हिँड्ने सबै जीवजन्तुहरूमध्ये, जसले आफ्ना पन्जाले टेकेर हिँड्छन्, ती तिमीहरूका लागि अशुद्ध छन्। जसले तिनको सिनो छुन्छ, त्यो साँझसम्म अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","जसले तिनीहरूको सिनो उठाउँछ, त्यसले आफ्नो लुगा धुनुपर्छ। अनि त्यो साँझसम्म अशुद्ध हुनेछ। यी जनावरहरू तिमीहरूका निम्ति अशुद्ध छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘जमिनमा हिँड्‍डुल गर्ने जीवहरूमा यी तिमीहरूका निम्ति अशुद्ध छन्—न्याउरीमुसो, मुसा, सबै किसिमका ठूलो छेपारो; ");
INSERT INTO npioncb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","छेपारो, गोहोरो, माउसुली, भालेमुङ्ग्रो, र रङ्ग बदल्ने छेपारो। ");
INSERT INTO npioncb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","जमिनमा हिँड्‍डुल गर्ने यी सबै जीवजन्तु तिमीहरूका लागि अशुद्ध छन्। यी मरेकालाई जसले छुन्छ, त्यो साँझसम्म अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","जब तीमध्ये कुनै एउटा मर्छ, र कुनै चीजमाथि खस्छ भने त्यो चीज जुनसुकै काममा प्रयोग हुने भए तापनि चाहे त्यो काठबाट बनिएको होस्, अथवा लुगा, छाला अथवा भाङ्ग्रा होस्, त्यो अशुद्ध हुनेछ। त्यसलाई पानीमा हाल्नू। त्यो साँझसम्म अशुद्ध रहनेछ; त्यसपछि त्यो शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","तीमध्ये एउटा माटोको भाँडाभित्र खस्यो भने त्यसमा भएका प्रत्येक चीज अशुद्ध हुनेछ। अनि तिमीहरूले त्यो भाँडा फोरिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","कुनै खाने कुरामा त्यस भाँडाको पानी परेको छ भने त्यो अशुद्ध हुनेछ। अनि त्यसबाट पिउने कुनै पनि तरल पदार्थ अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","जुनसुकै कुरोमाथि तिनीहरूमध्ये एउटाको सिनो खस्यो भने त्यो अशुद्ध हुन्छ। चुल्हो अथवा पकाउने भाँडालाई फुटाउनुपर्छ। ती अशुद्ध हुन्छ, र तिमीहरूले तिनीहरूलाई अशुद्ध ठहराउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","तरै पनि खोला अथवा पानी जम्मा गर्ने कुण्ड शुद्ध रहनेछ। तर यस्ता कुनै पनि सिनो छुने व्यक्ति अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","कुनै रोप्नुपर्ने बिउहरूमाथि सिनो खस्यो भने ती शुद्ध नै रहन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","तर त्यस बिउमा पानी हालिएको छ, र त्यसमाथि सिनो खस्यो भने त्यो, तिमीहरूका लागि अशुद्ध हो। ");
INSERT INTO npioncb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘तिमीहरूले खान हुने कुनै पशु मर्‍यो र कसैले त्यसको सिनो छुन्छ भने त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","कसैले सिनोबाट केही खान्छ भने त्यसले आफ्नो लुगा धुनुपर्छ। अनि त्यो साँझसम्म अशुद्ध हुनेछ। कसैले सिनो उठाउँछ भने त्यसले आफ्नो लुगा धुनुपर्छ; र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘जमिनमा घस्रने प्रत्येक जन्तु घृणित हो; त्यसलाई नखानू। ");
INSERT INTO npioncb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","जमिनमा घस्रने जुनसुकै प्राणी, चाहे त्यो पेटको भरले घस्रने होस्, अथवा चार खुट्टाले अथवा धेरै खुट्टाहरूले घस्रने होस्, तिमीहरूले नखानू: तिनीहरू घृणित हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","तिमीहरूले यस्ता कुनै प्राणीद्वारा आफूलाई अशुद्ध नपार्नू। तिमीहरूले आफूलाई तिनीहरूको कारण अथवा तिनीहरूद्वारा अशुद्ध नपार्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","म याहवेह नै तिमीहरूका परमेश्‍वर हुँ; तिमीहरूले आफूलाई शुद्ध पार। अनि पवित्र होओ; किनकि म पवित्र छु। जमिनमा घस्रने कुनै प्राणीद्वारा आफूलाई अशुद्ध नपार। ");
INSERT INTO npioncb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","तिमीहरूका परमेश्‍वर हुनलाई इजिप्टबाट बाहिर निकालेर ल्याउने म नै याहवेह हुँ। यसकारण पवित्र होओ; किनकि म पवित्र छु। ");
INSERT INTO npioncb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘पशुहरू, चराचुरुङ्गीहरू, पानीमा बस्‍ने प्रत्येक जीवित प्राणी र जमिनमा घस्रने प्रत्येक प्राणीको विषयमा नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","तिमीहरूले अशुद्ध र शुद्धको बीचमा, खान हुने र खान नहुने जीवित प्राणीको बीचमा भिन्‍नता राख्नुपर्छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलीहरूलाई भन्: ‘जुन स्त्रीले गर्भवती भएर छोरा जन्माउँछे, त्यो आफ्नो रजस्वलाको समयमा अशुद्ध रहेझैँ सात दिनसम्म विधिपूर्वक अशुद्ध रहनेछे। ");
INSERT INTO npioncb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","आठौँ दिनमा त्यस बालकको खलडीको खतना गरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","त्यसपछि आफ्नो रक्तस्राव शुद्ध हुनको लागि त्यस स्त्रीले तेत्तीस दिनसम्म पर्खनुपर्छ। त्यसले कुनै पवित्र कुरा नछोओस्, अथवा आफ्नो शुद्धीकरणको समय पूरा नहोउन्जेल पवित्रस्थानमा नजाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","त्यसले छोरी जन्माई भने आफ्नो रजस्वलाको समयमा झैँ त्यो दुई हप्‍तासम्म अशुद्ध हुनेछे। त्यसपछि आफ्नो रक्तस्रावबाट शुद्ध हुनको लागि त्यसले छयसट्ठी दिनसम्म पर्खनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘आफ्नो छोरा अथवा छोरीका लागि त्यसका शुद्धीकरणका दिनहरू पूरा भएपछि त्यसले भेट हुने पालको प्रवेशद्वारमा पुजारीकहाँ होमबलिका निम्ति एकवर्षे थुमा र पाप शुद्धीकरण बलिका निम्ति एउटा कलिलो परेवा अथवा ढुकुर ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","त्यसले ती बलिलाई याहवेहको सामु आफ्नो प्रायश्‍चितको निम्ति चढाउनुपर्छ। त्यसपछि त्यो आफ्नो रक्तस्रावबाट शुद्ध हुनेछे। “ ‘कुनै स्त्रीले छोरा वा छोरी जन्माएको विषयमा नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","यदि त्यस स्त्रीसँग थुमा किनेर ल्याउने रकम छैन भने त्यसले एक जोर ढुकुर अथवा परेवाका दुई वटा बचेरा, एउटा होमबलिका निम्ति र अर्को पाप शुद्धीकरण बलिका निम्ति ल्याओस्। यस किसिमले पुजारीले त्यसका निम्ति प्रायश्‍चित गर्नेछ, र त्यो शुद्ध हुनेछे।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“जब कुनै मानिसको छाला सुनियो, अथवा त्यसमा फुस्रो दाद देखियो; अथवा चहकिलो दाग देखा पर्‍यो, र छालामा कुष्‍ठरोगको संक्रमण भयो भने त्यसलाई पुजारी हारून अथवा उसका पुजारी छोराहरूमध्ये एक जनाकहाँ ल्याइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","त्यस पुजारीले त्यसको छालाको घाउ हेरोस्। यदि त्यस घाउको रौँ सेतो भएको छ, र त्यो घाउ छालाभन्दा गहिरो देखिन्छ भने त्यो कुष्‍ठरोगको संक्रमण हो। पुजारीले त्यसलाई जाँचेपछि त्यसले उसलाई विधिपूर्वक अशुद्ध भनी घोषणा गरोस्! ");
INSERT INTO npioncb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","त्यसको छालाको दाग सेतो छ, तर छालाभन्दा गहिरो देखिँदैन र त्यसमा भएको रौँ सेतो भएको छैन भने पुजारीले त्यस्ता रोग लागेको व्यक्तिलाई सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","सातौँ दिनमा पुजारीले त्यसलाई जाँच गर्दा, त्यो घाउ बदली नभएको अथवा छालामा फैलिएको देखिएन भने त्यसले उसलाई अर्को सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","सातौँ दिनमा पुजारीले त्यसलाई फेरि जाँच गर्दा त्यो घाउ मत्थर भएको छ, तर छालामा फैलिएको छैन भने पुजारीले त्यसलाई शुद्ध भनी घोषणा गरोस्! त्यो एउटा दाग मात्र हो। त्यस मानिसले आफ्ना लुगाहरू धोओस्, तब त्यो शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","तर शुद्ध ठहरिनलाई त्यसले आफूलाई पुजारीकहाँ देखाइसकेपछि यदि त्यो खस्रोपन छालामा फैलिएको छ भने त्यो फेरि पुजारीको सामु देखा पर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","पुजारीले त्यसलाई जाँच गर्दा, त्यो दाग छालामा फैलिएको छ भने उसले त्यसलाई अशुद्ध भनी घोषणा गरोस्; यो कुष्‍ठरोग हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“जब कुनै मानिसलाई कुष्‍ठरोगको संक्रमण छ भने त्यसलाई पुजारीकहाँ ल्याइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","पुजारीले त्यसलाई जाँच गर्दा, यदि छाला सुनिएर सेतो भएको छ, र त्यस ठाउँको रौँ पनि सेतो भएको छ, र यसमा आलो घाउ छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","त्यो छालाको एउटा दीर्घकालीन रोग हो। पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्! अनि त्यसलाई अलग्गै नराखोस्। किनकि त्यो पहिलेबाटै अशुद्ध भइसकेको छ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“यदि त्यो कुष्‍ठरोग त्यस रोगीको सम्पूर्ण छालामा शिरदेखि खुट्टासम्म ढाकेर फैलिएको पुजारीले देख्न सक्छ भने ");
INSERT INTO npioncb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","पुजारीले त्यसलाई जाँच गर्दा, कुष्‍ठरोगले त्यसको सम्पूर्ण शरीर ढाकेको छ भने उसले त्यस व्यक्तिलाई शुद्ध भनी घोषणा गरोस्! त्यो सम्पूर्ण सेतो भइसकेकोले त्यो शुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","तर त्यसमा आलो घाउ देखा पर्‍यो भने त्यो अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","पुजारीले आलो घाउ देखेपछि त्यसलाई अशुद्ध भनी घोषणा गरोस्। यो आलो मासु अशुद्ध हो; त्यो कुष्‍ठरोग हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","त्यो आलो घाउ बदलिएर सेतो भयो भने त्यो मानिस पुजारीकहाँ जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","पुजारीले त्यसलाई जाँच गर्दा, घाउहरू सेता भएका छन् भने पुजारीले त्यस रोगीलाई शुद्ध भनी घोषणा गरोस्; तब त्यो शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“कसैको छालामा पिलो निस्केर निको भयो, ");
INSERT INTO npioncb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","र पिलो भएको ठाउँमा सेतो सुनिएको अथवा रातो-सेतो किसिमको दाग देखा पर्‍यो भने त्यो मानिस पुजारीकहाँ जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","पुजारीले त्यो जाँच गरोस्। अनि त्यो छालाभन्दा गहिरो देखा पर्‍यो र त्यसका रौँहरू सेता भएका छन् भने पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्। त्यो कुष्‍ठरोगको संक्रमण हो, जुन त्यो पिलो भएको ठाउँमा उब्जिएको हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","तर पुजारीले त्यसलाई जाँच गर्दा, यदि त्यसमा सेता रौँ छैनन्, र छालाभन्दा गहिरो छैन, तर मत्थर भएको छ भने पुजारीले त्यसलाई सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","छालामा त्यो फैलिएको छ भने पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्। त्यो कुष्‍ठरोग संक्रमण हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","तर दाग बदली भएको छ, र फैलिएको छैन भने त्यो पिलोबाट भएको एउटा दाग मात्र हो। पुजारीले त्यसलाई शुद्ध भनी घोषणा गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“कसैको छाला जलेको छ, र रातो-सेतो किसिमको अथवा सेतो दाग जलेको ठाउँको आलो मासुमा देखियो भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","पुजारीले त्यस ठाउँलाई जाँच गरोस्। अनि त्यसका रौँहरू सेता भएका छन्, र त्यो छालाभन्दा गहिरो देखिन्छ भने त्यो जलेको ठाउँबाट निस्केको कुष्‍ठरोग संक्रमण हो। पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्। त्यो कुष्‍ठरोगको संक्रमण हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","तर पुजारीले त्यसलाई जाँच गर्दा, त्यस ठाउँमा सेता रौँहरू छैनन्, र त्यो छालाभन्दा गहिरो छैन, तर त्यो मत्थर भएको छ भने पुजारीले त्यसलाई सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","सातौँ दिनमा जाँच गर्दा, त्यो रोग छालामा फैलिएको छ भने पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्। यो कुष्‍ठरोगको संक्रमण हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","तरै पनि यदि त्यो दाग बदलिएको छैन, र छालामा फैलिएको छैन; तर मत्थर भएको छ भने त्यो जलेको कारणले सुनिएको हो। अनि पुजारीले त्यसलाई शुद्ध भनी घोषणा गरोस्। त्यो केवल जलेको घाउबाट भएको दाग हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“कुनै पुरुष अथवा स्त्रीको शिरमा अथवा च्यापुमा घाउ छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","पुजारीले त्यस घाउलाई जाँच गर्दा, त्यो छालाभन्दा गहिरो देखिन्छ, र त्यसमा भएका रौँहरू पहेँला र पातला छन् भने पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्। त्यो टाउको तथा चिउँडोको लुतो हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","तर यदि पुजारीले यस्ता किसिमको घाउ जाँच गर्दा, त्यो छालाभन्दा गहिरो देखिँदैन। साथै त्यसमा कुनै काला रौँहरू छैनन् भने पुजारीले त्यस व्यक्तिलाई सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातौँ दिनमा पुजारीले त्यस घाउलाई जाँच गर्दा, यदि त्यो लुतो फैलिएको छैन, र त्यसमा कुनै पहेँला रौँहरू छैनन्, र त्यो छालाभन्दा गहिरो देखिँदैन भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","त्यो घाउ भएको ठाउँलाई छोडेर त्यसले आफ्नो शिर खौरोस्, चिउँडो होइन। अनि पुजारीले त्यसलाई अर्को सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातौँ दिनमा पुजारीले त्यस लुतोलाई जाँच गर्दा, यदि त्यो छालामा फैलिएको छैन, र त्यो छालाभन्दा गहिरो छैन भने पुजारीले त्यसलाई शुद्ध भनी घोषणा गरोस्। त्यसले आफ्नो लुगा धोओस्, र त्यो विधिपूर्वक शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","तर त्यो शुद्ध ठहरिएपछि पनि त्यो लुतो छालामा फैलियो भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","पुजारीले त्यसलाई जाँच गर्दा, यदि लुतो छालामा फैलिएको छ भने पुजारीलाई पहेँला रौँ हेर्न आवश्यक छैन; त्यो व्यक्ति अशुद्ध हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","तरै पनि उसको जाँचअनुसार त्यो बदलिएको छैन, र त्यसमा काला रौँ उम्रेका छन् भने त्यो लुतो निको भएको छ; त्यो शुद्ध हो, र पुजारीले त्यसलाई शुद्ध भनी घोषणा गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“कुनै पुरुष अथवा स्त्रीको छालामा सेतो दाग हुँदा, ");
INSERT INTO npioncb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","पुजारीले तिनीहरूलाई जाँच गर्दा, यदि ती दागहरू हल्का सेता छन् भने त्यो हानि नगर्ने छालारोग हो, जुन छालामा उब्जिएको छ; त्यो मानिस शुद्ध हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“कुनै मानिसको कपाल पूरै झरेर शिर खुइलेको छ भने त्यो शुद्ध नै हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","त्यसको कपाल त्यसको टाउकाको अगिल्तिर खुइलिएकोले, त्यसको निधार खुइलिएको छ भने त्यो शुद्ध हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","तर त्यसको तालु अथवा खुइलिएको निधारमा रातो-सेतो किसिमको घाउ छ भने त्यो त्यसको शिर अथवा निधारबाट उब्जिएको कुष्‍ठरोग संक्रमण हो। ");
INSERT INTO npioncb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","पुजारीले त्यसलाई जाँचोस्, र त्यसका शिर अथवा निधारमा भएको त्यसको सुनिएको घाउ कुष्‍ठरोगझैँ रातो-सेतो किसिमको छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","त्यो मानिस कुष्‍ठरोगी र अशुद्ध हो। त्यसको शिरमा भएको घाउको कारण पुजारीले त्यसलाई अशुद्ध भनी घोषणा गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“यस्तो रोगको संक्रमित व्यक्तिले च्यातिएको लुगा लगाउनुपर्छ। त्यसको कपाल नकोरिएको हुनुपर्छ। त्यसले आफ्नो अनुहारको तल्‍लो भाग छोपेर ‘अशुद्ध! अशुद्ध!’ भनी कराओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","त्यो संक्रमण त्यसमा रहेसम्म, त्यो अशुद्ध रहनेछ। त्यो एकलै बस्‍नुपर्छ; त्यो छाउनीदेखि बाहिर बसोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“कुनै लुगा ढुसी परेको छ—चाहे त्यो ऊनी होस्, अथवा सुती, ");
INSERT INTO npioncb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ऊनका अथवा कपासका तुनेर वा बुनेर बनाइएका सामग्री, छालाका वा छालाले बनिएका कुनै चीज— ");
INSERT INTO npioncb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","यदि लुगा, छाला अथवा तुनेका वा बुनेका सामग्री अथवा छालाका कुनै सामग्रीमा भएका दूषित कुरा हरियो किसिमको अथवा रातो किसिमको छ भने त्यो फैलँदै गरेको ढुसी हो। अनि त्यसलाई पुजारीकहाँ देखाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","पुजारीले त्यस ढुसीलाई जाँच गर्दा, त्यो दाग लागेको चीजलाई सात दिनसम्म अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","सातौँ दिनमा उसले त्यो जाँच गर्दा, यदि त्यो ढुसी लुगामा अथवा तुनेका वा बुनेका कुरोमा वा कुनै काममा प्रयोग गरिने छालामा फैलिएको छ भने त्यो खतरनाक ढुसी हो; अनि त्यो चीज अशुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","त्यसले ढुसी परेका लुगा अथवा तुनेका अथवा बुनेका ऊनी वा सुती सामग्री अथवा छालाका कुनै पनि चीजलाई जलाइदेओस्। किनकि त्यो कुहाउने ढुसी हुनाले, त्यो चीज जलाइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“तर यदि पुजारीले जाँच गर्दा ढुसी तुनेका वा बुनेका लुगामा अथवा छालाका चीजमा फैलिएको छैन भने, ");
INSERT INTO npioncb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","उसले त्यो ढुसी परेको चीजलाई धुने आज्ञा देओस्। त्यसपछि त्यसलाई अर्को सात दिनसम्म त्यसले अलग्गै राखोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","त्यो संक्रमित लुगालाई धोइएपछि पुजारीले त्यसलाई पुनः जाँचोस्। अनि ढुसी फैलिएको छैन र त्यसको रूप बदलिएको छैन भने त्यो अशुद्ध हो। ढुसीले भित्री वा बाहिरी भाग असर पारेको भए तापनि त्यसलाई आगोले जलाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","यदि पुजारीले त्यसलाई जाँच गर्दा त्यो लुगा धोइएपछि ढुसी हराउँदैगएको छ भने त्यसले त्यो फोहोर लागेको भागलाई त्यस लुगा वा छाला अथवा बुनेका चीजबाट च्यातिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","तर यदि ढुसी लुगामा वा तुनेको अथवा बुनेका चीजमा अथवा छालाको चीजमा फेरि देखा पर्‍यो भने त्यो फैलिरहेको छ। अनि ढुसी परेको जुनसुकै कुरा पनि आगोद्वारा जलाइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","धोएर ढुसीरहित बनाइएका लुगा, तुनेका वा बुनेका चीज वा छालाका कुनै चीजलाई फेरि धोइयोस्, र त्यो शुद्ध हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ऊनी अथवा सुती लुगाहरू, तुनेका वा बुनेका चीजहरू अथवा छालाका कुनै चीजलाई ढुसीले दूषित पारेको विषयमा शुद्ध अथवा अशुद्ध भनी ठहराउनलाई यिनै विधिहरू हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“कुष्‍ठरोग लागेका मानिसलाई विधिपूर्वक शुद्ध गर्ने नियमहरू यिनै हुन्; जब तिनीहरूलाई पुजारीकहाँ ल्याइन्छः ");
INSERT INTO npioncb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","तिनीहरूलाई जाँच गर्न पुजारी छाउनीबाहिर जाओस्। यदि ती मानिसहरू आफ्ना कुष्‍ठरोगबाट निको भएका छन् भने, ");
INSERT INTO npioncb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","पुजारीले दुई वटा शुद्ध जिउँदा पक्षीहरू, केही देवदारुका दाउरा, सिन्दूरे रङ्गको धागो र हिसप, शुद्ध हुन चाहनेका निम्ति ल्याउने आदेश देऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","त्यसपछि पुजारीले ती दुई पक्षीहरूमध्ये एउटालाई माटोको भाँडामा भएको ताजा पानीमाथि मार्ने आदेश देऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","त्यसपछि त्यसले जीवित पक्षीलाई लिएर त्यसलाई देवदारुका दाउरा, सिन्दूरे रङ्गको धागो र हिसपसित ताजा पानीमाथि मारिएको पक्षीको रगतमा चोपोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","त्यसले त्यस कुष्‍ठरोगबाट शुद्ध हुनुपर्ने व्यक्तिलाई सात चोटि छर्केर त्यसलाई शुद्ध भनी घोषित गरोस्। त्यसपछि त्यसले जीवित पक्षीलाई खुला मैदानमा छोडिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“शुद्ध हुनुपर्ने त्यस मानिसले आफ्ना लुगा धोओस्। आफ्ना सबै कपाल खौरोस् र पानीले नुहाओस्। त्यसपछि त्यो शुद्ध हुनेछ। त्यसपछि त्यो छाउनीभित्र पस्‍न सक्छ। तर त्यो सात दिनसम्म आफ्नो पालको बाहिर बस्‍नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातौँ दिनमा त्यसले आफ्नो शिर, आफ्नो दाह्री आफ्ना आँखीभौँहरू, र सबै रौँहरू खौरोस्। त्यसले आफ्नो लुगा धोओस्, र पानीले नुहाओस्। अनि त्यो विधिपूर्वक शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठौँ दिनमा त्यसले भेडाका दुई वटा पाठाहरू र एउटी पाठी, सबै एकवर्षे र निष्खोट अनि अन्‍नबलिका निम्ति मसिनो पिठो जैतुन तेलसँग मिसाएको एपाको दश भागको तीन भाग र एक लोग तेल ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","त्यसलाई शुद्ध घोषणा गर्ने पुजारीले शुद्ध हुनुपर्ने व्यक्ति र भेटी दुवैलाई याहवेहको सामु भेट हुने पालको प्रवेशद्वारमा प्रस्तुत गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“तब पुजारीले त्यो तेलसमेत भेडाका पाठाहरूमध्ये एउटालाई लिएर दोषबलिस्वरूप चढाओस्। विशेष भेटीको रूपमा उचालिनका लागि याहवेहलाई चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","त्यसले त्यस भेडालाई पवित्रस्थानमा पाप शुद्धीकरण बलि र होमबलि मारिने ठाउँमा मारोस्। पाप शुद्धीकरण बलिझैँ दोषबलि पुजारीको हो; त्यो अति पवित्र छ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","पुजारीले दोषबलिको रगतबाट केही लिएर शुद्ध हुनपर्ने व्यक्तिको दाहिने कानको लोतीमा, त्यसको दाहिने बूढी औँलामा र त्यसको दाहिने खुट्टाको बूढी औँलामा लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","त्यसपछि पुजारीले केही तेल लिएर आफ्नै देब्रे हातको हत्केलामा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","पुजारीले उसको हत्केलामा भएको तेलमा आफ्नो दाहिने हातको औँला चोपोस्। अनि आफ्नो औँलाले त्यसबाट केही याहवेहको सामु सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","पुजारीले आफ्नो हत्केलामा उब्रेको तेलबाट केही तेल शुद्ध हुनपर्ने व्यक्तिको दाहिने कानको लोतीमा, त्यसको दाहिने हातको बूढी औँलामा र त्यसको दाहिने खुट्टाको बूढी औँलामा दोषबलिको रगतको माथिल्‍लोपट्टि छर्किदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","पुजारीको हत्केलाको बाँकी तेल उसले शुद्ध हुनपर्नेको शिरमा लगाएर त्यसका निम्ति याहवेहको सामु प्रायश्‍चित गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“त्यसपछि पुजारीले पाप शुद्धीकरण बलि चढाएर आफ्नो अशुद्धिबाट शुद्ध हुनुपर्नेका निम्ति प्रायश्‍चित गरोस्। त्यसपछि पुजारीले होमबलि चढाइने पशु मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","अनि त्यसलाई पुजारीले अन्‍नबलिसँग वेदीमा चढाओस्, र त्यसका लागि प्रायश्‍चित गरोस्, तब त्यो शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“तर यदि त्यो गरिब छ, र यी चीजहरू ल्याउन सक्दैन भने त्यसले आफ्ना निम्ति प्रायश्‍चित गर्न विशेष भेटीको रूपमा दोषबलिस्वरूप एउटा भेडाको पाठा, र साथमा अन्‍नबलिका लागि जैतुन तेल मिसाइएको एपाको दश भागको एक भाग मसिनो पिठो र एक लोग तेल ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","त्यसले ल्याउन सक्छ भने दुई वटा ढुकुर अथवा दुई वटा कलिला परेवा एउटा पाप शुद्धीकरण बलिको निम्ति र अर्को होमबलिको निम्ति ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“आठौँ दिनमा त्यसले ती कुराहरू आफ्नो शुद्धीकरणका निम्ति पुजारीकहाँ भेट हुने पालको प्रवेशद्वारमा याहवेहको सामु ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","पुजारीले दोषबलिको निम्ति ल्याइएको भेडा एक लोग तेलसँग लिएर विशेष भेटीको रूपमा उचालिनको लागि याहवेहको सामु अर्पण गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","त्यसले भेडालाई दोषबलिको निम्ति मारोस्। अनि त्यसको केही रगत लिएर शुद्ध हुनुपर्ने व्यक्तिको दाहिने कानको लोतीमा, त्यसको दाहिने हातको बूढी औँलामा र त्यसको दाहिने खुट्टाको बूढी औँलामा लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","पुजारीले तेलबाट केही आफ्नो देब्रे हातको हत्केलामा खन्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","अनि आफ्नो दाहिने हातको औँलाले आफ्नो हत्केलाबाट केही तेल याहवेहको सामु सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","त्यसको हत्केलाको केही तेल त्यसले दोषबलिको रगत लगाएका ठाउँहरूमा लगाओस्, अर्थात् शुद्ध हुनुपर्नेको दाहिने कानको लोतीमा, त्यसको दाहिने हातको बूढी औँलामा र त्यसको दाहिने खुट्टाको बूढी औँलामा लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","पुजारीले आफ्नो हत्केलामा बाँकी रहेको तेल शुद्ध हुनपर्ने व्यक्तिको शिरमा याहवेहको सामु त्यसको प्रायश्‍चित गर्नका निम्ति लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","त्यसपछि त्यसले आफ्नो आर्थिक क्षमताअनुसार ढुकुरहरू अथवा कलिला परेवाहरू बलि चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","एउटा पाप शुद्धीकरण बलिस्वरूप र अर्को होमबलिस्वरूप अन्‍नबलिसँग चढाओस्। यस किसिमले पुजारीले त्यस शुद्ध हुनुपर्ने व्यक्तिको पक्षमा याहवेहको सामु प्रायश्‍चित गर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","कुष्‍ठरोगको संक्रमण लागेको मानिस र आफ्नो शुद्धीकरणका निम्ति नियमित भेटीहरू चढाउने आर्थिक रूपमा असक्षम मानिसका निम्ति नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब मैले तिमीहरूलाई अधिकारको रूपमा दिन लागेको कनान देशमा तिमीहरू प्रवेश गरौला, र त्यस देशको एउटा घरमा मैले फैलिने ढुसी लाग्न दिएँ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","त्यस घरको मालिकले गएर पुजारीलाई ‘मेरो घरमा ढुसी भएजस्तै केही देखेको छु’ भनोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","त्यस घरमा ढुसी जाँच गर्न जानुअगि पुजारीले त्यस घरलाई खाली गर्ने आदेश देओस्; ताकि त्यस घरभित्र भएका कुनै चीज पनि अशुद्ध भनी घोषित नहोस्। त्यसपछि पुजारी त्यो घर जाँच गर्न भित्र जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","त्यसले भित्तातिर ढुसीलाई जाँचोस्। यदि त्यहाँ हरियो किसिमका अथवा रातो किसिमका दागहरू भित्ताको सतहभन्दा गहिरा देखा पर्छन् भने, ");
INSERT INTO npioncb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","पुजारी त्यस घरको ढोका छेउबाट बाहिर गएर त्यसलाई सात दिनसम्म बन्द गरिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","सातौँ दिनमा पुजारी त्यस घरलाई जाँच्नलाई फर्कोस्। यदि ढुसी भित्तामा फैलिएको छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","त्यसले दूषित भएका ढुङ्गाहरू भित्ताबाट उक्‍काएर नगर बाहिरको अशुद्ध ठाउँमा फ्याँकिदिन आदेश गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","त्यसले घरका सबै भित्ताहरू खुर्किन र खुर्किएका सामग्रीहरू नगरबाहिर कुनै अशुद्ध ठाउँमा थुपार्न लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","त्यसपछि तिनीहरूले ती खाली ठाउँहरू भर्नलाई अरू ढुङ्गाहरू लिऊन्, र नयाँ माटो ल्याएर घर लिपून्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“यदि ढुङ्गाहरू उक्‍काइसकेपछि त्यो घर खुर्किएर लिपिसकेपछि पनि ढुसी फेरि देखा पर्‍यो भने, ");
INSERT INTO npioncb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","पुजारीले गएर त्यसलाई जाँचोस्; अनि त्यस घरमा ढुसी फैलिएको छ भने त्यो एउटा गम्भीर ढुसी हो, र त्यो घर अशुद्ध छ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","त्यो भत्काइनुपर्छ, अर्थात् त्यसका ढुङ्गाहरू, काठहरू र सबै लेपहरू भत्काएर नगरबाहिर कुनै अशुद्ध ठाउँमा लगियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“त्यो घर बन्द भएको बेला जो त्यसभित्र पस्छ, त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","त्यस घरभित्र सुत्ने अथवा खाना खानेले आफ्नो लुगा धोओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“तर यदि पुजारीले त्यसलाई जाँच्न आउँदा त्यस घरलाई लिपेपछि ढुसी फैलिएको छैन भने त्यसले घरलाई शुद्ध भनी घोषणा गरोस्; किनकि त्यो ढुसी गइसकेको छ। ");
INSERT INTO npioncb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","त्यस घरलाई शुद्ध पार्नलाई त्यसले दुई वटा पक्षीहरू, देवदारुका केही काठ, सिन्दूरे रङ्गको धागो र हिसप ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","त्यसले दुईमध्ये एउटा पक्षीलाई माटोको भाँडामा भएको ताजा पानीमाथि मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","त्यसपछि त्यसले देवदारुको काठ, हिसप, सिन्दूरे रङ्गको धागो, जिउँदो पक्षीलाई लिएर तिनीहरूलाई त्यस पक्षीको रगत र ताजा पानीमा चोपलोस्। अनि घरलाई सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","त्यस घरलाई त्यस पक्षीको रगत, ताजा पानी, जीवित पक्षी, देवदारुका काठ, हिसप र सिन्दूरे रङ्गको धागोले शुद्ध पारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","त्यसपछि त्यसले त्यस जीवित पक्षीलाई नगरबाहिर खुला मैदानमा छोडिदेओस्। यस किसिमले पुजारी त्यस घरका निम्ति प्रायश्‍चित गर्नेछ, र त्यो शुद्ध हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","कुनै पनि प्रकारको कुष्‍ठरोगका लागि, लुतोको लागि, ");
INSERT INTO npioncb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","लुगामा अथवा घरमा भएको ढुसीका लागि, ");
INSERT INTO npioncb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","अनि सुनिएको, खस्रो र चहकिलो दागका लागि, ");
INSERT INTO npioncb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","कुनै कुरालाई अशुद्ध वा शुद्ध ठहराउनका लागि नियमहरू यिनै हुन्। कुष्‍ठरोग संक्रमण र ढुसीका निम्ति नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलीहरूसित कुरा गरेर तिनीहरूलाई भन्: ‘यदि कुनै मानिसको शरीरबाट धातु बग्छ भने त्यो धातु अशुद्ध हो। ");
INSERT INTO npioncb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","चाहे त्यो त्यसको शरीरबाट बहिरह्‍यो अथवा थामिए तापनि त्यसले उसलाई अशुद्ध बनाउँछ। त्यसको धातुस्रावले त्यसलाई यसरी अशुद्ध बनाउँछ: ");
INSERT INTO npioncb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘धातुस्राव बगेको मानिस सुतेको ओछ्यान अशुद्ध हुनेछ। अनि त्यो मानिस बस्‍ने हरेक थोक अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","जसले त्यसको ओछ्यान छुन्छ, त्यसले आफ्ना लुगाहरू धोओस्, र पानीले नुहाओस्। अनि त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","धातुस्राव भएको मानिस बसेको कुनै पनि ठाउँमा जो बस्छ, त्यसले आफ्ना लुगाहरू धोओस्। पानीले नुहाओस्, र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘धातुस्राव बग्ने मानिसलाई जसले छुन्छ, त्यसले आफ्ना लुगाहरू धोओस्, र पानीले नुहाओस्। अनि त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘यदि धातुस्राव बग्ने मानिसले कुनै शुद्ध मानिसलाई थुक्यो भने त्यस मानिसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्; अनि त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘त्यो मानिस सवार हुँदा बसेको प्रत्येक चीज अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","अनि जसले त्यसको मुन्तिर भएको जुनसुकै कुरालाई पनि छुन्छ, त्यो साँझसम्म अशुद्ध रहनेछ। जसले ती कुराहरू उठाउँछ, त्यसले आफ्ना लुगाहरू धोओस्। अनि पानीले नुहाओस्; र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘धातुस्राव बग्ने मानिसले आफ्नो हात पानीले नधोई कुनै मानिसलाई छोयो भने त्यसले आफ्ना लुगाहरू धोओस्। अनि पानीले नुहाओस्; र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘त्यस मानिसले माटोको कुनै भाँडा छोयो भने त्यो फुटाइयोस्। अनि काठको भाँडा हो भने त्यसलाई पानीले पखालियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘कुनै मानिस धातुस्रावबाट शुद्ध पारियो भने त्यसले आफ्नो शुद्धीकरणका लागि सात दिन गनोस्। त्यसले आफ्ना लुगा धोओस् र ताजा पानीले नुहाओस्, तब त्यो शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठौँ दिनमा त्यसले दुई वटा ढुकुरहरू अथवा दुई वटा कलिला परेवाहरू लिएर याहवेहको सामु भेट हुने पालको प्रवेशद्वारमा आओस्, र ती पुजारीलाई देओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","पुजारीले तिनीहरूलाई चढाओस्। एउटालाई पाप शुद्धीकरण बलिका लागि र अर्को होमबलिका लागि। यस प्रकार पुजारीले त्यस मानिसको धातुस्रावको कारण याहवेहको सामु प्रायश्‍चित गर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘कुनै मानिसको वीर्य आफैँ निस्क्यो भने त्यसले आफ्नो सम्पूर्ण शरीर पानीले नुहाओस्; र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","कुनै लुगा अथवा छालामा वीर्य लागेको छ भने त्यसलाई पानीले धोइयोस्। अनि त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","कुनै पुरुषले स्त्रीसित सम्भोग गरेपछि दुवैले पानीले नुहाऊन्। अनि तिनीहरू साँझसम्म अशुद्ध रहनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘कुनै स्त्रीको नियमित रजस्वला भएको छ भने त्यसको रजस्वलाको अशुद्धता सात दिनसम्म रहनेछ। अनि त्यसलाई छुने जो कोही पनि साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘आफ्नो रजस्वलाको समयमा जे-जेमाथि त्यो सुत्छे वा बस्छे; त्यो अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","जसले त्यसको ओछ्यान छुन्छ, त्यो अशुद्ध हुनेछ। त्यसले आफ्ना लुगाहरू धोओस् र पानीले नुहाओस्। अनि त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","जसले त्यो बसेको चीज छुन्छ, त्यसले आफ्ना लुगा धोओस्। अनि पानीले नुहाओस्, र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","त्यो बसेको ओछ्यान होस् अथवा कुनै पनि वस्तु होस्, त्यसलाई कसैले छोयो भने त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘यदि कुनै पुरुषले साँच्‍चै त्यससित सम्भोग गर्‍यो, र त्यसको रजस्वलाको रगतले त्यसलाई छोयो भने त्यो सात दिनसम्म अशुद्ध रहनेछ। त्यो सुतेको जुनसुकै ओछ्यान पनि अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘यदि कुनै स्त्रीको आफ्नो रजस्वलाको समयबाहेक अर्को समयमा धेरै दिनसम्म रगत बगिरह्‍यो अथवा आफ्नो रजस्वला नथामिएर रगत बगिरह्‍यो भने त्यसको रजस्वलाको समयमा झैँ रगत बगिरहुन्जेल त्यो अशुद्ध हुनेछे। ");
INSERT INTO npioncb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","त्यसको रक्तस्राव भएको समयमा त्यसको रजस्वलाको समयमा झैँ त्यो सुतेको जुनसुकै ओछ्यान पनि अशुद्ध हुनेछ। अनि त्यसको रजस्वलाको समयमा झैँ त्यो जे-जेमाथि बस्छे, त्यो पनि अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","जसले ती चीजहरूलाई छुन्छ, त्यो अशुद्ध हुनेछ। त्यसले आफ्ना लुगा धोओस्। अनि पानीले नुहाओस्, र त्यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘आफ्नो रक्तस्राव बन्द भएपछि त्यसले सात दिन गनोस्। अनि त्यसपछि त्यो शुद्ध हुनेछे। ");
INSERT INTO npioncb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","आठौँ दिनमा त्यसले दुई वटा ढुकुरहरू अथवा दुई वटा कलिला परेवाहरू लिएर ती भेट हुने पालको प्रवेशद्वारमा पुजारीकहाँ ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","पुजारीले तीमध्ये एउटालाई पाप शुद्धीकरण बलिको रूपमा र अर्कोलाई होमबलिको रूपमा बलिदान गरोस्। यसरी पुजारीले त्यसका निम्ति त्यसको स्रावका अशुद्धिको लागि याहवेहको सामु प्रायश्‍चित गर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘तिमीहरूले इस्राएलीहरूलाई अशुद्ध तुल्याउने कुराहरूदेखि अलग्गै राख्नू; ताकि तिनीहरूबीच भएको मेरो वासस्थानलाई अपवित्र तुल्याइएको कारण तिनीहरू आफ्ना अशुद्धतामा मर्नेछैनन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","कुनै मानिसको धातुस्रावको निम्ति वीर्य स्खलन भएको कारण कोही अशुद्ध भएको निम्ति, ");
INSERT INTO npioncb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","मासिक रजस्वलामा भएकी स्त्रीका निम्ति, र कुनै पुरुषको वीर्य स्खलन अथवा स्त्रीका रक्तस्रावको निम्ति र विधिपूर्वक अशुद्ध रहेकी स्त्रीसित सम्भोग गर्ने पुरुषका निम्ति नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","हारूनका दुई छोराहरू याहवेहको नजिक जाँदा मृत्यु भएपछि याहवेह मोशासित बोल्नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","याहवेहले मोशालाई भन्‍नुभयो: “तेरो दाजु हारूनलाई भन्, त्यसलाई मन लागेको जुनसुकै बेला सन्दुकमाथि भएको पाप समाधान-स्थानको सामु पर्दाको पछाडिको महा-पवित्रस्थानमा नआओस्, नत्रता त्यो मर्नेछ। किनकि पाप समाधान-स्थानमाथि म बादलमा देखा पर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“हारूनले महा-पवित्रस्थानमा यसरी प्रवेश गर्नुपर्छ: त्यसले पाप शुद्धीकरण बलिका लागि एउटा बाछा र होमबलिका निम्ति एउटा भेडा लिएर आओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","त्यसले पवित्र सुती लबेदा र भित्री पोशाकहरू लगाओस्। त्यसले आफ्नो चारैतिर सुती पटुका बाँधोस्, र सुती फेटा लगाओस्। यी पोशाकहरू पवित्र हुन्। यसैकारण त्यसले आफूलाई पानीले नुहाएर मात्र ती लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","त्यसले इस्राएली समुदायबाट पाप शुद्धीकरण बलिका निम्ति दुई वटा बोकाहरू र होमबलिका निम्ति एउटा भेडा ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“त्यसपछि हारूनले आफ्नो पाप शुद्धीकरण बलिका निम्ति साँढे चढाओस्। अनि त्यसले आफ्नो र आफ्ना घरानाका निम्ति प्रायश्‍चित गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","त्यसपछि त्यसले ती दुई बोकाहरू लिएर याहवेहको सामु भेट हुने पालको प्रवेशद्वारमा प्रस्तुत गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अनि हारूनले ती दुई बोकाहरूका लागि चिट्ठा हालोस्—एउटा चिट्ठा याहवेहका निम्ति र अर्को छाडा छोडिने बोकाको निम्ति। ");
INSERT INTO npioncb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","हारूनले याहवेहको निम्ति चिट्ठा परेको बोका ल्याएर त्यसलाई पाप शुद्धीकरण बलिको रूपमा चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","तर छाडा छोडिने बोकाको निम्ति चिट्ठा परेको बोकालाई छाडा बनिनको निम्ति मरुभूमिमा पठाएर प्रायश्‍चित गर्नलाई जिउँदै याहवेहको सामु प्रस्तुत गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“हारूनले आफ्नो पाप शुद्धीकरण बलिको साँढे ल्याओस्। अनि आफू र आफ्ना घरानाका निम्ति प्रायश्‍चित गरोस्। अनि त्यसले आफ्नो पाप शुद्धीकरण बलिका निम्ति त्यस साँढेलाई मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","त्यसले वेदीबाट बल्दैगरेको कोइलाले भरिएको धुपौरो र दुई मुठी मसिनो गरी पिँधेको सुगन्धित धूप याहवेहको सामु ल्याएर ती पर्दाको पछाडिपट्टि लैजाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","त्यसले याहवेहको सामु आगोमा धूप हालोस्। अनि धूपको धुवाँले साक्षी पाटीमाथि भएको पाप समाधान-स्थानलाई ढाकिदिनेछ, र त्यो मर्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","त्यसले त्यस साँढेको रगतबाट केही लिएर आफ्नो औँलाले पाप समाधान-स्थानको सामु छर्कोस्। अनि त्यसले त्यसको केही भाग औँलाले पाप समाधान-स्थानको अगिल्तिर सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“त्यसपछि त्यसले मानिसहरूका निम्ति पाप शुद्धीकरण बलिको बोकालाई मारोस्। अनि त्यसको रगत पर्दाको पछिल्तिर लगेर त्यसलाई साँढेको रगतलाई गरेझैँ गरोस्, अर्थात् पाप समाधान-स्थानको सामु त्यसले बोकाको रगतलाई साँढेको रगतमाथि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","यसरी त्यसले इस्राएलीहरूका जस्तोसुकै पाप भए तापनि तिनीहरूका अशुद्धता र विद्रोहको लागि महा-पवित्रस्थानका निम्ति प्रायश्‍चित गर्नेछ। त्यसले भेट हुने पालको निम्ति पनि त्यस्तै गर्नुपर्छ, जुन तिनीहरूको माझ छाउनीमा भएको अशुद्धताको बीचमा छ। ");
INSERT INTO npioncb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","हारून महा-पवित्रस्थानभित्र प्रायश्‍चित गर्न गएको बेलादेखि त्यसले आफू, आफ्ना घराना र इस्राएलका सारा समुदायका निम्ति प्रायश्‍चित गरेर बाहिर नआएसम्म कोही पनि भेट हुने पालभित्र हुनुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“त्यसपछि त्यो निस्केर याहवेहको सामु भएको वेदीमा आओस्। अनि त्यसको निम्ति प्रायश्‍चित गरोस्। त्यसले साँढेको रगत र बोकाको रगतबाट केही लिएर त्यसलाई वेदीका सिङहरूमाथि लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","त्यसले केही रगत आफ्नो औँलाले त्यसमाथि सात चोटि छर्कोस्, र त्यसलाई शुद्ध पारोस्। अनि त्यसलाई इस्राएलीहरूको अशुद्धताबाट पवित्र गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“हारूनले महा-पवित्रस्थान, भेट हुने पाल र वेदीका निम्ति प्रायश्‍चित गरिसकेपछि त्यसले जिउँदो बोका ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","त्यसले दुवै हात त्यस जिउँदो बोकाको शिरमाथि राखेर त्यसमाथि इस्राएलका सबै दुष्‍टता र विद्रोह—तिनीहरूका सबै पाप स्वीकार गरोस्। अनि ती त्यस बोकाको टाउकोमाथि राखिदेओस्। त्यसले त्यस बोकालाई त्यस कामको लागि खटाइएको मानिसको जिम्मामा टाढा मरुभूमिमा पठाइदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","त्यस बोकाले तिनीहरूका सारा पाप निर्जन ठाउँमा बोकेर लैजानेछ। अनि त्यस मानिसले त्यस बोकालाई उजाडस्थानमा छोडिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“त्यसपछि हारून भेट हुने पालभित्र जाओस्, र त्यसले महा-पवित्रस्थानभित्र जानुअगि लगाएका सुती पोशाकहरू फुकाएर तिनलाई त्यहीँ छोडिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","त्यसले आफूलाई एउटा पवित्र ठाउँमा पानीले नुहाओस्। अनि आफ्नो नियमित पोशाक लगाओस्। त्यसपछि बाहिर निस्केर त्यसले आफू र मानिसहरूका निम्ति प्रायश्‍चित गर्नलाई, आफ्नै निम्ति होमबलि र मानिसहरूका निम्ति होमबलि चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","त्यसले पाप शुद्धीकरण बलिको बोसो पनि वेदीमाथि जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“त्यस बोकालाई छाडा छोडिदिने मानिसले आफ्ना लुगाहरू धोएर आफूलाई पानीले नुहाओस्। त्यसपछि त्यो छाउनीभित्र आओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","प्रायश्‍चितको लागि महा-पवित्रस्थानभित्र जसको रगत ल्याइएको थियो; पाप शुद्धीकरण बलिको त्यो साँढे र बोकालाई छाउनीबाहिर लगेर तिनीहरूका छाला, मासु र गोबर जलाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","तिनीहरूलाई जलाउने मानिसले आफ्ना लुगा धोएर पानीले नुहाओस्; र त्यसपछि त्यो छाउनीभित्र आओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“तिमीहरूका लागि यो एउटा रहिरहने विधि ठहरियोस्ः सातौँ महिनाको दशौँ दिनमा तिमीहरूले आफैँलाई इन्कार गर्नू। अनि तिमीहरूले चाहे घरमा जन्मेको होस् अथवा तिमीहरूका बीचमा बस्‍ने परदेशी होस्, कसैले पनि कुनै किसिमको काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","किनकि यही दिन तिमीहरूलाई शुद्ध पार्नलाई तिमीहरूका निम्ति प्रायश्‍चित गरिनेछ। त्यसपछि तिमीहरू याहवेहको सामु तिमीहरूका सबै पापहरूबाट शुद्ध हुनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","यो शब्बाथ विश्रामको दिन हो; अनि तिमीहरूले आफूलाई इन्कार गर्नू, यो एउटा रहिरहने विधि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","प्रधान पुजारीको रूपमा आफ्नो बुबाको सट्टामा अभिषेक भई नियुक्त भएका पुजारीले प्रायश्‍चित गर्नुपर्छ। उसले पवित्र सुती कपडा लगाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","अनि महा-पवित्रस्थानको निम्ति, भेट हुने पाल र वेदीको निम्ति; अनि सबै पुजारीहरू र समुदायका सबै सदस्यहरूका निम्ति प्रायश्‍चित गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“यो तिमीहरूका निम्ति रहिरहने विधि होस्: इस्राएलीहरूका सबै पापहरूका निम्ति वर्षमा एकपल्ट प्रायश्‍चित गरियोस्।” अनि याहवेहले आज्ञा गर्नुभएबमोजिम नै मोशाले गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून, त्यसका छोराहरू र सारा इस्राएलीहरूसित कुरा गर्, र तिनीहरूलाई भन्: ‘याहवेहले यस्तो आज्ञा दिनुभएको छ: ");
INSERT INTO npioncb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","कुनै इस्राएलीले गोरु, थुमा अथवा बाख्रालाई छाउनीभित्र वा बाहिर बलिदान गर्छ र याहवेहको समागम पाल सामु उहाँलाई दानस्वरूप प्रस्तुत गर्नलाई भेट हुने पालको प्रवेशद्वारमा तिनीहरूलाई ल्याउँदैन, ");
INSERT INTO npioncb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","अनि याहवेहको भेट हुने पाल सामु उहाँलाई बलिस्वरूप चढाउनलाई समागम पालको प्रवेशद्वारमा ल्याउँदैन भने त्यो मानिस रक्तपातको दोषी ठहरिनेछ। त्यसले रगत बगाएकोले त्यो आफ्ना मानिसहरूदेखि अलग गरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","यो आज्ञा यस हेतुले दिइएको हो कि इस्राएलीहरूले आफ्ना बलिदान खुल्‍ला मैदानमा चढाउँछन्, जुन अबदेखि याहवेहका सामु चढाऊन्। तिनीहरूले पुजारीकहाँ भेट हुने पालको प्रवेशद्वारमा ल्याएर याहवेहकहाँ मेलबलिको रूपमा चढाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","पुजारीले त्यो रगत भेट हुने पालको प्रवेशद्वारमा याहवेहको वेदीमाथि छर्कोस्। अनि बोसोलाई याहवेहलाई मनपर्ने बास्‍नास्वरूप जलाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","तिनीहरूले अब उसो बाख्रारूपी मूर्तिहरूलाई बलिदान नचढाऊन्, जससँग तिनीहरू व्यभिचार गर्छन्; तिनीहरू र तिनीहरूका पुस्तौँ-पुस्ताका निम्ति यो रहिरहने विधि होस्।’ ");
INSERT INTO npioncb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“तिनीहरूलाई भन्: ‘कुनै इस्राएली अथवा तिनीहरूसित बस्‍ने कुनै परदेशी, जसले होमबलि अथवा बलिदान चढाउँछ, ");
INSERT INTO npioncb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","अनि त्यसलाई याहवेहका निम्ति बलिदान गर्नलाई भेट हुने पालको प्रवेशद्वारमा ल्याउँदैन भने त्यो मानिसलाई आफ्ना मानिसहरूबाट बहिष्कार गरियोस्।’ ");
INSERT INTO npioncb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘इस्राएलीहरू वा तिनीहरूसित बस्‍ने कुनै पनि परदेशी, जसले रगत खान्छ, म त्यो रगत खानेको विरोध गर्छु। अनि म त्यसलाई त्यसका मानिसहरूदेखि बहिष्कार गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","किनकि शरीरको प्राण त्यसको रगतमा हुन्छ। अनि मैले त्यो वेदीमा तिमीहरू आफ्नै प्रायश्‍चित गर्नु भनेर तिमीहरूलाई दिएको छु। रगतद्वारा नै कसैको प्राणको निम्ति प्रायश्‍चित गरिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","यसकारण म इस्राएलीहरूलाई भन्छु, “तिमीहरू कसैले पनि रगत नखानू, न त तिमीहरूबीच बसोबास गर्ने कुनै परदेशीले नै रगत खाओस्।” ");
INSERT INTO npioncb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘कुनै इस्राएली अथवा तिमीहरूबीच बसोबास गर्ने कुनै परदेशीले खान हुने कुनै पशु वा पक्षीको शिकार गर्‍यो भने त्यसले रगत निथारेर माटोले पुरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","किनकि हरेक शरीरको प्राण त्यसको रगत हो। यसकारण मैले इस्राएलीहरूलाई भनेको छु, “तिमीहरूले कुनै प्राणीको पनि रगत नखानू; किनकि शरीरको प्राण त्यसको रगत हो। त्यो खाने सबैलाई बहिष्कार गरिनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘स्वदेशमा जन्मेको अथवा परदेशमा, जसले आफैँ मरेर भेट्टाएको अथवा जङ्गली पशुहरूद्वारा फहराइएको जेसुकै पनि खान्छ भने त्यसले आफ्ना लुगाहरू धोओस्, पानीले नुहाओस्। अनि त्यो साँझसम्म विधिपूर्वक अशुद्ध हुनेछ। त्यसपछि त्यो शुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","तर यदि त्यसले आफ्ना लुगाहरू धोएन र नुहाएन भने त्यसलाई यसको परिणामको जिम्मेवार ठहराइनेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएलीहरूसित कुरा गरेर तिनीहरूलाई भन्: ‘म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","तिमीहरूले प्रवास गरेको इजिप्टियनहरूले गरेका कामहरूझैँ नगर। अब म तिमीहरूलाई कनान देशमा लैजाँदैछु। यसकारण त्यहाँका मानिसहरूले गर्ने कामहरूझैँ नगर। तिनीहरूका विधि-विधानहरूलाई नपछ्याऊ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तिमीहरूले मेरा विधि-विधानहरू पालन गर्नू। अनि मेरा उर्दीहरू होशियारीसाथ पालन गर्नू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","मेरा उर्दी र आज्ञाहरू पालन गर्नू। किनकि ती पालन गर्ने मानिस त्यसैद्वारा जिउनेछ; म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘तिमीहरूमध्ये कसैले पनि आफ्नो नजिकको नातेदारसँग सहवास नगर्नू; म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘आफ्नी आमासित सहवास गरेर आफ्ना बुबाको अपमान नगर्नू। त्यो तेरी आमा हो; त्यससित यस्तो सम्बन्ध नराख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘तैँले आफ्नो बुबाको पत्नीसित सहवास नगर्नू; त्यसो गर्नाले तैँले आफ्ना बुबाको अपमान गर्छस्। ");
INSERT INTO npioncb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘आफ्नी बहिनीसित अर्थात् आफ्ना बुबाको छोरी वा आमाकी छोरी, चाहे त्यो एउटै घरमा वा कहीँकतै जन्मेकी होस्, त्यससित सहवास नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘आफ्नो छोराको छोरीसित अथवा आफ्नी छोरीकी छोरीसित सहवास नगर्नू; त्यसले तेरो अपमान हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘आफ्नी सौतेनी आमापट्टिबाट तेरा बुबाद्वारा जन्मिएकी छोरीसित सहवास नगर्नू; त्यो तेरी बहिनी हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘आफ्ना बुबाको दिदीबहिनीसित सहवास नगर्नू; त्यो तेरा बुबाका नजिकको नातेदार हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘आफ्नी आमाकी दिदीबहिनीसित सहवास नगर्नू; किनकि त्यो तेरी आमाकी नजिकको नातेदार हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘आफ्ना बुबाको भाइकी पत्नीकहाँ सहवासको लागि गएर काकाको अपमान नगर्नू; त्यो तेरी काकी हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘आफ्नी बुहारीसित सहवास नगर्नू। त्यो तेरो छोराकी पत्नी हो; त्यससित यस्तो सम्बन्ध नराख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘आफ्नो भाउजूसित सहवास नगर्नू; त्यसले तेरो दाजुको अपमान हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘कुनै स्त्री र त्यसकी छोरी दुवैसित सहवास नगर्नू। त्यसका छोराकी छोरीसित अथवा त्यसकी छोरीकी छोरीसित सहवास नगर्नू; ती नजिकका नातेदार हुन्। त्यो त दुष्‍टता हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘आफ्नी पत्नीको जीवनकालमा त्यसकी दिदी वा बहिनीलाई सौता ल्याएर सहवास नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘कुनै स्त्रीको रजस्वलाको अशुद्धिमा त्यस स्त्रीकहाँ सहवासको लागि नजानू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘आफ्नो छिमेकीको पत्नीसित सहवास गरेर आफूलाई अपवित्र नबनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘आफ्ना सन्तानलाई मोलेखको निम्ति बलिदान गर्न नदिनू। किनकि तिमीहरूले आफ्ना परमेश्‍वरको नाम अपवित्र तुल्याउनु हुँदैन। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘स्त्रीहरूसँगझैँ पुरुषसँग सहवास नगर्नू; त्यो त घृणित कार्य हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘कुनै पशुसित सहवास गरेर आफूलाई त्यससित अपवित्र नतुल्याउनू। कुनै स्त्रीले पनि सहवासका निम्ति पशुकहाँ नजानू; त्यो त अस्वभाविक भ्रष्‍टता हो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘तिमीहरूले यी कुराहरूमध्ये कुनैमा पनि आफूलाई अपवित्र नतुल्याउनू। किनकि तिमीहरूको सामु म जुन जातिहरूलाई बाहिर धपाउँदैछु, तिनीहरू यस्तै किसिमले आफूलाई अपवित्र बनाए। ");
INSERT INTO npioncb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","त्यो देशसमेत अपवित्र भयो। यसकारण मैले तिनीहरूका पापका निम्ति तिनीहरूलाई दण्ड दिएँ। अनि त्यस देशले आफ्ना देशवासीहरूलाई ओकलेर फालिदियो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","तर तिमीहरूले मेरा उर्दी र आज्ञाहरू पालन गर्नू। स्वदेशमा जन्मेका अथवा तिमीहरूसित बस्‍ने परदेशीहरूले यस्ता घिनलाग्दा कुनै पनि काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","किनकि यी घिनलाग्दा काम तिमीहरूभन्दा अगि त्यस ठाउँमा बस्‍ने मानिसहरूले गरेका थिए, र देश अपवित्र भयो। ");
INSERT INTO npioncb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","अनि यदि तिमीहरूले देशलाई अपवित्र तुल्यायौ भने त्यसले तिमीहरूभन्दा पहिलेका जातिहरूलाई ओकलेर फालिदिएझैँ, तिमीहरूलाई पनि ओकलेर फालिदिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘यदि कसैले यीमध्ये कुनै घृणित काम गर्‍यो भने त्यो आफ्ना मानिसहरूबाट बहिष्कार गरियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","मैले राखेका विधिहरू पूरा गर्नू। अनि तिमीहरू आउनुभन्दा पहिले गरिएका घिनलाग्दा रीतिको अनुसरण नगर्नू। तिमीहरूले त्यस्ता कुराहरूसित आफूलाई अपवित्र नतुल्याउनू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएलका सारा समुदायसित कुरा गरेर तिनीहरूलाई भन्: ‘तिमीहरू पवित्र होओ; किनकि म याहवेह तिमीहरूका परमेश्‍वर पवित्र छु। ");
INSERT INTO npioncb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘तिमीहरू प्रत्येकले आफ्ना आमाबुबालाई आदर गर्नू, र तिमीहरूले मेरा शब्बाथ दिनहरूलाई पालन गर्नू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘मूर्तिहरूतिर नफर्कनू वा धातुका आफ्ना निम्ति देवताहरू नबनाउनू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘तिमीहरूले याहवेहको निम्ति आफ्ना मेलबलि चढाउँदा यस किसिमले चढाओ, कि त्यो तिमीहरूका पक्षमा ग्रहणयोग्य होस्। ");
INSERT INTO npioncb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","त्यसलाई तिमीहरूद्वारा चढाएकै दिन अथवा भोलिपल्ट खाइयोस्। तेस्रो दिनसम्म केही थोक बाँकी रह्‍यो भने त्यो जलाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","यदि त्यसबाट केही तेस्रो दिनमा खाइयो भने त्यो अशुद्ध हो; त्यो ग्रहण हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","त्यसलाई जसले खान्छ, त्यो जिम्मेवार हुनेछ। किनकि त्यसले जुन कुरा याहवेहको निम्ति पवित्र छ, त्यसलाई अपवित्र तुल्याएको छ। त्यो मानिस आफ्नो समुदायबाट बहिष्कार गरियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘तिमीहरूले आफ्नो जमिनबाट कटनी गर्दा त्यसको किनारसम्मै नकाट्नू, अथवा तिमीहरूका कटनीको सिलाबाला नबटुल्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","तिमीहरू आफ्नो दाखबारीमा दोस्रोपल्ट नजानू, अथवा झरेका अङ्‌गुर नटिप्नू। ती गरिबहरू र परदेशीहरूका निम्ति छोडिदिनू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘तिमीहरूले चोरी नगर्नू। “ ‘तिमीहरूले झूट नबोल्नू। “ ‘तिमीहरू एक-अर्कालाई धोका नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘तिमीहरूले मेरो नाममा झूटो शपथ खाएर आफ्ना परमेश्‍वरको नाम अपवित्र नतुल्याउनू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘तिमीहरूले आफ्ना छिमेकीलाई शोषण नगर्नू, अथवा नलुट्नू। “ ‘तिमीहरूका ज्यालादारी मानिसको ज्याला रातभरि रोकेर नराख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘तिमीहरूले सुन्‍न नसक्नेलाई नसराप्नू, अथवा दृष्‍टिविहीनको सामु ठेस लाग्ने कुरा नराख्नू; तर आफ्ना परमेश्‍वरको डर मान्‍नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘तिमीहरूले न्याय नबिगार्नू। गरिबलाई पक्षपात नगर्नू; अनि धनीलाई विशेष कृपा नदेखाउनू। तर आफ्ना छिमेकीको न्याय ठिकसित गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘आफ्ना मानिसहरूका बीचमा निन्दा नफैलाउनू। “ ‘आफ्ना छिमेकीको जीवन खतरामा पर्ने किसिमका कुनै पनि काम नगर्नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘तिमीहरूका दाजुभाइलाई आफ्नो हृदयमा घृणा नगर्नू। बरु आफ्नो छिमेकीलाई खुल्‍लमखुल्‍ला हप्काउनू, ताकि त्यसको दोषमा तिमीहरूको कुनै भाग नहोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘आफ्ना मानिसहरूका विरुद्धमा बदला नलिनू, अथवा डाह नगर्नू; तर आफ्ना छिमेकीलाई आफूलाई झैँ प्रेम गर्नू; म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘मेरा उर्दीहरू पालन गर्नू। “ ‘बेग्ला-बेग्लै जातिका पशुहरूलाई मेल नगराउनू। “ ‘आफ्नो जमिनमा दुई किसिमका बिउहरू नलगाउनू। “ ‘दुई किसिमका सामग्रीहरूले बनिएको वस्त्र नलगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘मगनी भएकी, तर छुटकारा नपाएकी तथा स्वतन्त्र नभएकी कमारीसित कसैले सहवास गर्‍यो भने तिनीहरूलाई सजाय दिइयोस्। तिनीहरूलाई मार्नुचाहिँ हुँदैन। किनभने त्यो फुक्‍का भएकी थिइन। ");
INSERT INTO npioncb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","तर त्यस मानिसले याहवेहका निम्ति दोषबलिस्वरूप भेट हुने पालको प्रवेशद्वारमा एउटा भेडा ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","त्यो भेडालाई लिएर पुजारीले त्यसको निम्ति त्यसले गरेको पापका लागि याहवेहको सामु प्रायश्‍चित गरोस्; अनि त्यसको पाप क्षमा गरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘जब तिमीहरू त्यस देशमा प्रवेश गर्छौ, तब त्यहाँ कुनै किसिमका फलको रूख रोपेपछि त्यसको फललाई खान नहुने ठान्‍नू। तीन वर्षसम्म तिमीहरूले त्यसलाई खान नहुने ठान्‍नू; त्यो खानुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथो वर्षमा त्यसका सबै फलहरू पवित्र र याहवेहका निम्ति प्रशंसाको भेटी हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तर पाँचौँ वर्षमा त्यसको फल खान सकिन्छ। यस प्रकार तिमीहरूका फसलको वृद्धि हुनेछ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘कुनै मासु रगत भएको अवस्थामा नखानू। “ ‘तिमीहरूले जोखना हेर्ने र साइत हेर्ने कामहरू नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘तिमीहरूले आफ्नो कन्चटको कपाल नकाट्नू, न त आफ्नो दाह्रीका किनारहरू छाँट्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘तिमीहरूले मरेकाहरूका निम्ति आफ्ना शरीरलाई नकाट्नू, अथवा आफूमाथि खोपेर छापहरू नबनाउनू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘तिमीहरूले आफ्ना छोरीहरूलाई वेश्या बनाएर तिनीहरूको स्तर नघटाइदिनू; नत्रता देश नै वेश्यावृत्तिमा लागेर दुष्‍टताले भरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘मेरा शब्बाथ दिनहरू पालन गर्नू, र मेरो पवित्रस्थानलाई आदर गर्नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘तन्त्रमन्त्र गर्नेहरूतिर ध्यान नदिनू, न त तिनीहरूलाई खोज्नू। किनकि तिनीहरूद्वारा तिमीहरू अपवित्र तुल्याइनेछौ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘बुढापाकाहरूका सम्मानमा उठ्नू र वृद्धहरूप्रति आदर देखाउनू। अनि तिमीहरूका परमेश्‍वरको भय मान्‍नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘जब कुनै परदेशी तिमीहरूको देशमा तिमीहरूसित बसोबास गर्छ, तब त्यससित नराम्रो व्यवहार नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","तिमीहरूसित बस्‍ने परदेशीलाई स्वदेशमा जन्मेकालाई झैँ व्यवहार गर्नुपर्छ। त्यसलाई आफूलाई झैँ प्रेम गर्नू। किनकि तिमीहरू पनि इजिप्टमा परदेशी थियौ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘तिमीहरूले नाप्दा, जोख्दा र भर्दा छल नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ठिक तराजु, ठिक ढक, ठिक एपा र ठिक हिन चलाउनू। तिमीहरूलाई इजिप्टबाट निकालेर ल्याउने म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘तिमीहरूले मेरा सबै उर्दी र मेरा सबै व्यवस्थाहरू मान्‍नू; र ती पालन गर्नू। म नै याहवेह हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएलीहरूलाई भन्: ‘आफ्ना छोराछोरीहरू मोलेखलाई चढाउने कुनै इस्राएली अथवा इस्राएलमा बस्‍ने कुनै पनि परदेशी मारिनुपर्छ। समुदायका मानिसहरूले त्यसलाई ढुङ्गाले हानून्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","म आफ्नो अनुहार त्यस मानिसको विरुद्धमा पार्नेछु। अनि म त्यसलाई त्यसका मानिसहरूबाट बहिष्कार गर्नेछु; किनकि त्यसले आफ्ना छोराछोरीहरू मोलेखलाई दिएर मेरो पवित्रस्थान बिटुलो पारेको छ। अनि मेरो पवित्र नामलाई अपवित्र तुल्याएको छ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","यदि समुदायका मानिसहरूले कुनै मानिसले आफ्ना छोराछोरीहरू मोलेख देवतालाई बलि चढाउँदा नदेखेझैँ गरे, र त्यसलाई मारेनन् भने, ");
INSERT INTO npioncb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","म आफ्नो अनुहार त्यस मानिस र त्यसको परिवारको विरुद्धमा पार्नेछु। अनि म त्यसलाई र आफैँलाई मोलेखसित व्यभिचार गर्न त्यसको पछि-पछि लाग्ने सबैलाई तिनीहरूका मानिसदेखि बहिष्कार गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘जो व्यक्ति जोखना हेर्नेहरू र तन्त्रमन्त्र गर्नेहरूका पछि लागेर आफैँलाई वेश्यावृत्तिमा लगाउँछ, त्यसदेखि म आफ्नो अनुहार लुकाउनेछु। अनि म त्यसलाई त्यसका मानिसहरूको बीचबाट बहिष्कार गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘यसकारण आफैँलाई अर्पण गरेर पवित्र होओ। किनकि म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","मेरा उर्दीहरू पालन गर्नू; अनि तिनैलाई अनुसरण गर्नू। तिमीहरूलाई पवित्र पार्ने याहवेह म नै हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘यदि कसैले आफ्ना बुबालाई अथवा आमालाई सराप्छ भने त्यो मारियोस्। किनकि त्यसले आफ्नो बुबा वा आमालाई सरापेको छ; अनि त्यसको रगत त्यसकै शिरमाथि परोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘यदि कुनै मानिसले आफ्नो छिमेकीको पत्नीसित व्यभिचार गर्छ भने त्यो व्यभिचारी र व्यभिचारिणी दुवै मारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘यदि कुनै मानिसले आफ्नो बुबाको पत्नीसित सहवास गर्‍यो भने त्यसले आफ्नो बुबाको अपमान गरेको छ। त्यो मानिस र स्त्री दुवै मारियोस्। तिनीहरूका रगत तिनीहरूकै आफ्नै शिरमाथि परोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘यदि कुनै मानिसले आफ्नी बुहारीसित सहवास गर्‍यो भने ती दुवै मारिऊन्। तिनीहरूले जे गरेका छन्, त्यो अभद्र व्यवहार हो। तिनीहरूका रगत तिनीहरूकै शिरमाथि परोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘यदि कुनै मानिसले स्त्रीसँग सहवास गरेझैँ कुनै पुरुषसित सहवास गर्‍यो भने त्यो घृणित काम हो; तिनीहरू मारिनैपर्छ। तिनीहरूको अपराध तिनीहरूकै शिरमाथि परोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘यदि कुनै मानिसले आमा र छोरी दुवैलाई विवाह गर्छ भने त्यो दुष्‍टता हो। त्यसलाई ती दुवैसँग आगोमा जलाइनुपर्छ, ताकि तिमीहरूका बीचमा कुनै दुष्‍टता नरहोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘यदि कुनै मानिसले पशुसित सहवास गरेको छ भने त्यो मारियोस्। अनि तिमीहरूले त्यस पशुलाई पनि मार्नैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘यदि कुनै स्त्री सहवासको निम्ति कुनै पशुकहाँ जान्छे भने त्यो स्त्री र पशु दुवै मारिनैपर्छ। निश्‍चय नै तिनीहरू मारिनैपर्छ। तिनीहरूका रगत तिनीहरूकै शिरमाथि परोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘यदि कुनै मानिसले आफ्नी बहिनी अर्थात् आफ्नो बुबा वा आमाकी छोरीलाई विवाह गर्छ र त्यससित सहवास गर्छ भने त्यो अपराध हो। त्यो आफ्ना मानिसहरूका दृष्‍टिमा बहिष्कृत हुनैपर्छ। त्यसले आफ्नी बहिनीको अपमान गरेको छ, र त्यो जिम्मेवार ठहराइनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘यदि कुनै मानिसले स्त्रीसित त्यसको रजस्वलाको समयमा सहवास गर्‍यो भने त्यसले उसको रक्तस्रावको मूललाई उदाङ्गो बनाएको छ। अनि त्यसले पनि त्यो खोलिदिएकी छे। ती दुवै आफ्ना मानिसहरूबाट बहिष्कृत हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘आफ्नी आमाकी अथवा बुबाकी दिदीबहिनीसित सहवास नगर्नू। किनकि त्यसद्वारा आफ्नो नजिकको नातेदारको अपमान हुनेछ। तिमीहरू दुवै त्यसको जिम्मेवार हुनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘यदि कुनै मानिसले आफ्नी काकी अथवा ठूली आमासित सहवास गर्‍यो भने त्यसले काका अथवा ठूलो बुबाको अपमान गर्छ। तिनीहरू त्यस पापको जिम्मेवार हुनेछन्; र तिनीहरू निःसन्तान भई मर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘यदि कुनै मानिसले आफ्नो दाजु वा भाइकी पत्नीलाई विवाह गर्‍यो भने त्यो अशुद्ध काम हो। त्यसले आफ्ना दाजुभाइको अपमान गरेको छ। तिनीहरू निःसन्तान हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘मेरा सबै उर्दीहरू र नियमहरू पालन गरेर त्यसको अनुसरण गर्नू, ताकि मैले तिमीहरूलाई बसोबास गर्न जुन ठाउँमा लैजाँदैछु, त्यसले तिमीहरूलाई नत्यागोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","मैले तिमीहरूको सामुबाट धपाइदिन लागेको जातिहरूका रीतिअनुसार नचल्नू। यसैकारण मैले तिनीहरूलाई घृणा गरेँ। ");
INSERT INTO npioncb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","तर मैले तिमीहरूलाई भनेको छु, “तिमीहरूले तिनीहरूको देश अधिकार गर्न पाउनेछौ। म त्यसलाई अर्थात् दूध र मह बग्ने देशलाई अधिकारस्वरूप तिमीहरूलाई दिनेछु।” म याहवेह नै तिमीहरूका परमेश्‍वर हुँ, जसले तिमीहरूलाई अरू जातिहरूबाट अलग गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘यसकारण तिमीहरूले शुद्ध र अशुद्ध पशुहरूको बीचमा अनि शुद्ध र अशुद्ध पक्षीहरूको बीचमा भिन्‍नता राख्नुपर्छ। जमिनमा हिँड्ने र मैले तिमीहरूका निम्ति अशुद्ध भनी अलग गरेको जुनसुकै पशु अथवा पक्षी—केही कुराद्वारा तिमीहरूले आफूलाई अशुद्ध नतुल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","तिमीहरू पवित्र हुनैपर्छ। किनकि म याहवेह पवित्र छु। मैले तिमीहरूलाई मेरा आफ्नै बनाउनलाई अरू जातिहरूबाट अलग पारेको छु। ");
INSERT INTO npioncb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘तिमीहरूका बीचमा भएको कुनै पुरुष अथवा स्त्रीले तन्त्रमन्त्र गर्नेझैँ मध्यस्थको अथवा तन्त्रमन्त्रको काम गर्‍यो भने त्यो मारिनैपर्छ। तिमीहरूले तिनीहरूलाई ढुङ्गाले हिर्काएर मार्नू। तिनीहरूको रगत तिनीहरूका आफ्नै शिरमाथि परोस्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","याहवेहले मोशालाई भन्‍नुभयो, “हारूनका पुजारी छोराहरूलाई यसो भन्: ‘आफ्ना मानिसहरूबाट कसैको मृत्यु हुँदा पुजारीले आफूलाई अशुद्ध नतुल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","तर आफ्नो साक्खै अर्थात् आफ्ना आमाबुबा, आफ्ना छोराछोरी, दाजुभाइ, ");
INSERT INTO npioncb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","अथवा आफ्नी साक्खै कन्या दिदीबहिनीका निम्ति त्यसले आफूलाई अशुद्ध तुल्याउन सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","वैवाहिक सम्बन्धद्वारा भएका आफन्तहरूका निम्ति त्यसले आफूलाई अशुद्ध बनाएर त्यो अपवित्र नबनोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘पुजारीहरूले आफ्ना शिर र दाह्रीका किनार नखौरून्, र आफ्ना शरीरमा चोट नपारून्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","आफ्ना परमेश्‍वरका निम्ति तिनीहरू पवित्र रहून्, र आफ्ना परमेश्‍वरको नाम अपवित्र नपारून्। किनकि तिनीहरूले याहवेहका निम्ति आगोद्वारा चढाइएको बलि, आफ्ना परमेश्‍वरको भोजन चढाउने गर्दछन्। यसकारण तिनीहरू पवित्र रहून्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘तिनीहरूले वेश्यावृत्तिको कारण अपवित्र भएकी अथवा पतिद्वारा त्यागिएकी स्त्रीहरूलाई विवाह नगरून्। किनकि पुजारीहरू आफ्ना परमेश्‍वरका निम्ति पवित्र हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","तिमीहरूले पुजारीहरूलाई पवित्र मान्‍नू। किनकि तिनीहरूले आफ्ना परमेश्‍वरको भोजन चढाउने गर्दछन्। तिनीहरू तिमीहरूका निम्ति पवित्र रहून्। किनकि तिमीहरूलाई पवित्र पार्ने म याहवेह पवित्र छु। ");
INSERT INTO npioncb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘यदि कुनै पुजारीकी छोरीले वेश्या भएर आफूलाई अपवित्र तुल्याउँछे भने त्यसले आफ्ना बुबालाई कलङ्कित पार्छे; त्यसलाई आगोमा जलाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘आफ्ना दाजुभाइहरूमध्ये आफ्नो शिरमाथि अभिषेकको तेल खन्याइएको छ, र पुजारीका पोशाकहरू लगाउन नियुक्त भएको प्रधान पुजारीले आफ्नो केश खुला नछोडोस्, र आफ्ना लुगा नच्यातोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","कुनै मुर्दा भएको ठाउँमा त्यो नपसोस्। त्यसले आफ्ना बुबाआमाकै निम्ति पनि आफूलाई अशुद्ध नपारोस्; ");
INSERT INTO npioncb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","न त त्यसले पवित्रस्थानलाई छोडोस्, अथवा त्यसलाई दूषित पारोस्। किनकि परमेश्‍वरको अभिषेकको तेलले त्यसलाई अर्पण गरिएको छ। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘त्यसले विवाह गर्ने स्त्री कन्या हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","त्यसले विधवा, त्यागिएकी स्त्री अथवा वेश्यावृत्तिद्वारा कलङ्कित स्त्रीलाई विवाह गर्नुहुँदैन। तर केवल आफ्नै जातिबाटको कन्यालाई मात्र विवाह गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","त्यसले आफ्ना जातिबीच आफ्ना सन्तानलाई अपवित्र नतुल्याओस्। त्यसलाई पवित्र तुल्याउने याहवेह म नै हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारूनलाई भन्: ‘भावी पुस्ताका निम्ति तेरो सन्तानबाट खोट भएको कुनै व्यक्ति पनि आफ्नो परमेश्‍वरको भोजन चढाउनलाई नजिक नआओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","यस्ता खोट भएका कुनै मानिस पनि नजिक नआओस्: दृष्‍टिविहीन, लङ्गडा, रूप बिग्रेको वा कुरूप; ");
INSERT INTO npioncb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","अपाङ्ग खुट्टा वा हात भएको मानिस, ");
INSERT INTO npioncb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुप्रो वा पुड्को वा आँखामा खोट भएको, छालामा आलो घाउ भएको वा अण्डकोष बिग्रेको। ");
INSERT INTO npioncb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","पुजारी हारूनको सन्तानमा कुनै पनि खोट भएको व्यक्ति याहवेहलाई आगोद्वारा चढाइने बलि चढाउन नजिक नआओस्। त्यसमा खोट हुनाले आफ्नो परमेश्‍वरको भोजन चढाउन नजिक नआओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","तर त्यसले आफ्नो परमेश्‍वरको महा-पवित्र र पवित्र दुवै भोजन खान सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","त्यसमा खोट भएको हुनाले त्यो मेरो पवित्रस्थानलाई दूषित पार्नलाई पर्दानिर अथवा वेदीको नजिक नआओस्। तिनीहरूलाई पवित्र पार्ने याहवेह म नै हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","यसकारण मोशाले हारून र उनका छोराहरूलाई अनि सारा इस्राएलीहरूलाई यी कुरा सुनाए। ");
INSERT INTO npioncb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून र त्यसका छोराहरूलाई इस्राएलीहरूले मलाई अर्पण गरेका पवित्र बलिहरूप्रति आदरपूर्वक व्यवहार गर्न भन्‍नू। अनि तिनीहरूले मेरो नाम अपवित्र नतुल्याऊन्। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“तिनीहरूलाई भन्: ‘पुस्तौँ-पुस्तासम्मका लागि यदि तिमीहरूका सन्तानमा कोही अशुद्ध छ, र पनि त्यो इस्राएलीहरूले याहवेहकहाँ चढाएका पवित्र भेटीहरूको नजिक आउँछ भने त्यस मानिसलाई मेरो उपस्थितिबाट अलग गर्नुपर्छ। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘यदि हारूनको कुनै सन्तानको सरुवा छालारोग अथवा वीर्यपतन भएको छ भने शुद्ध नभएसम्म त्यसले पवित्र भेटीबाट नखाओस्। त्यसले लासद्वारा अथवा वीर्यपतन भएको कसैद्वारा अशुद्ध पारिएको केही छोयो भने पनि त्यो अशुद्ध हुनेछ, ");
INSERT INTO npioncb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","अथवा त्यसले आफूलाई अशुद्ध पार्ने कुनै घस्रने जीवजन्तु छोयो भने अथवा त्यसलाई अशुद्ध पार्ने जस्तोसुकै अशुद्धता भएको कुनै मानिसलाई छोयो भने तापनि त्यो अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","जसले यी कुरामध्ये कुनै कुरा छोएको छ, साँझसम्म त्यो अशुद्ध रहनेछ। त्यसले आफूलाई पानीले ननुहाएसम्म कुनै पनि पवित्र भेटीहरू नखाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","घाम डुबेपछि त्यो शुद्ध हुनेछ। अनि त्यसले पवित्र भेटीहरू खान सक्छ; किनकि ती त्यसकै भोजन हो। ");
INSERT INTO npioncb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","त्यसले मरेर भेट्टाइएको कुनै कुरा अथवा पशुले फहराएको केही खाएर त्यसबाट अशुद्ध नहोस्। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘पुजारीहरूले मेरो सेवा यस प्रकारले गरून् कि तिनीहरूले यसलाई घृणा गरेको कारण तिनीहरू दोषी भएर नमरून्। तिनीहरूलाई पवित्र तुल्याउने याहवेह म नै हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘पुजारीको परिवार बाहिरको मानिस कसैले पनि पवित्र भेटीहरू नखाओस्; न त पुजारीको पाहुना अथवा ज्यालादारी मजदुरले त्यो खाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","तर यदि कुनै पुजारीले आफ्नै पैसाले कुनै दास किन्यो, अथवा दासहरू त्यसको घरानामै जन्मेका हुन् भने ती दासहरूले त्यसको भोजन खान सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","यदि कुनै पुजारीकी छोरीले पुजारीसँग नगरी अरूसँगै विवाह गरेकी छे भने त्यसले पवित्र भेटीको भाग नखाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","तर यदि कुनै पुजारीकी छोरी विधवा भएकी अथवा त्यागिएकी छ, र त्यो सन्तानविहीन छे, र त्यो आफ्नो बुबाको घरमा बसेकी छे भने त्यसले आफ्ना बुबाको भोजन खान सक्छे। तरै पनि अधिकार नपाएको कुनै व्यक्तिले भने त्यसबाट केही खान सक्दैन। ");
INSERT INTO npioncb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘यदि कसैले भूलले पवित्र भेटी खाएमा त्यसले पुजारीलाई ती भेटीहरूका हर्जाना देओस्, र त्यसमाथि त्यसको मूल्यको पाँचौँ भाग थपेर देओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","इस्राएलीहरूले याहवेहलाई चढाएका पवित्र भेटीहरू पुजारीहरूले अपवित्र नपारून्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","तिनीहरूलाई खान दिएर अनि अपवित्र पारेर दण्ड भोग्नुपर्ने दोष तिनीहरूमाथि नल्याओस्। तिनीहरूलाई पवित्र तुल्याउने याहवेह म नै हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून, त्यसका छोराहरू र सारा इस्राएलीहरूसित कुरा गरेर तिनीहरूलाई भन्: ‘तिमीहरूमध्ये कोही, अर्थात् कुनै इस्राएली अथवा इस्राएलमा बस्‍ने परदेशीले भाकल पूरा गर्नलाई अथवा स्वेच्छापूर्वक भेटीस्वरूप याहवेहका निम्ति होमबलिका लागि कुनै भेटी चढाउँछ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","तिमीहरूले गाईबस्तुबाट, भेडा अथवा बाख्राबाट निष्खोट पाठा तिमीहरूको पक्षमा त्यो ग्रहणयोग्य होस् भनेर चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","खोट भएका कुनै पनि पशु नल्याउनू। किनकि त्यो तिमीहरूका पक्षमा ग्रहणयोग्य हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","यदि कसैले आफ्नो विशेष भाकल पूरा गर्नलाई अथवा स्वेच्छापूर्वक मेलबलिस्वरूप याहवेहकहाँ बथान अथवा बगालबाट ल्याउँछ भने ग्रहणयोग्य हुनलाई त्यो पूर्ण र खोटरहित होस्। ");
INSERT INTO npioncb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","याहवेहकहाँ आँखा नेदेख्ने, चोट लागेको अथवा अङ्ग-भङ्ग भएको, छालारोगी, कुहिएको, घाउ भएको अथवा आलो घाउ भएकाहरू नचढाउनू। यस्ता कुनैलाई पनि याहवेहकहाँ आगोद्वारा चढाइने बलिदानस्वरूप वेदीमाथि नराख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","तरै पनि तिमीहरूले स्वेच्छापूर्वक भेटीस्वरूप अङ्ग-भङ्ग भएको र चोट लागेको गोरु अथवा भेडा चढाउन सक्छौ। तर भाकल पूरा गर्ने विषयमा त्यो ग्रहण हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","तिमीहरूले याहवेहकहाँ अण्डकोषमा चोट लागेको, थेप्चिएको, च्यात्तिएको अथवा काटिएको पशु चढाउनुहुँदैन। तिमीहरूले आफ्नै देशमा यस्तो गर्नुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","अनि तिमीहरूले यस्ता पशुहरू परदेशीको हातबाट ग्रहण गरेर तिनीहरूलाई आफ्ना परमेश्‍वरको भोजनस्वरूप नचढाउनू। ती तिमीहरूका पक्षमा ग्रहण गरिनेछैनन्; किनकि ती कुरूप र दोषसहित छन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“एउटा बाछा, थुमा अथवा बाख्रा जन्मँदा, त्यो त्यसकी आमासित सात दिनसम्म रहनुपर्छ। आठौँ दिनदेखि उसो त्यो याहवेहका निम्ति आगोद्वारा चढाइएको भेटीस्वरूप ग्रहण हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","गाई अथवा भेडा र तिनीहरूका बच्‍चाहरू, दुवैलाई एकै दिन नमार्नू! ");
INSERT INTO npioncb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“तिमीहरूले आफ्ना धन्यवादको भेटी याहवेहका निम्ति बलिदान गर्दा त्यो तिमीहरूका पक्षमा ग्रहणयोग्य हुने गरी बलि चढाओ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","त्यो त्यही दिन खाइहाल्नू; त्यसको कुनै पनि कुरा बिहानसम्म नराख्नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“मेरा आज्ञाहरू पालन गर्नू, र त्यसअनुसार चल्नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","मेरो पवित्र नामलाई अपवित्र नतुल्याउनू। म पवित्र छु भनी इस्राएलीहरूले स्वीकार गर्नैपर्छ। तिमीहरूलाई पवित्र तुल्याउने याहवेह म नै हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","अनि तिमीहरूका परमेश्‍वर हुनलाई तिमीहरूलाई इजिप्टबाट निकालेर ल्याउने म नै हुँ; म नै याहवेह हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलीहरूसित कुरा गरेर तिनीहरूलाई भन्: ‘मेरा तोकिएका चाडहरू, याहवेहका तोकिएका चाडहरू यिनै हुन्, जसलाई तिमीहरूले पवित्र सभाहरू भनी घोषणा गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘छ दिनसम्म तिमीहरूले काम गर्नू, तर सातौँ दिन शब्बाथ विश्रामको दिन, पवित्र दिन हो। त्यस दिन तिमीहरूले कुनै काम नगर्नू। तिमीहरू जहाँ बसे तापनि यो दिन याहवेहका निम्ति शब्बाथ हो।’ ");
INSERT INTO npioncb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘याहवेहका तोकिएका चाडहरू यिनै हुन्, पवित्र सभाहरू, जसलाई तिमीहरूले तिनीहरूका तोकिएको समयमा घोषणा गर्नू: ");
INSERT INTO npioncb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","याहवेहको निस्तार पहिलो महिनाको चौधौँ दिनको साँझमा सुरु हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","त्यस महिनाको पन्ध्रौँ दिनमा याहवेहका निम्ति अखमिरी रोटीको चाड सुरु हुन्छ। सात दिनसम्म तिमीहरूले अखमिरी रोटी खानू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","यस चाडको पहिलो दिन एउटा पवित्र सभा होस्; त्यस दिन तिमीहरूले आफ्नो दैनिक काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","सात दिनसम्म याहवेहलाई अग्निबलि चढाउनू। अनि सातौँ दिनमा एउटा पवित्र सभा राख्नू। त्यस दिन कुनै दैनिक काम नगर्नू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलीहरूसित कुरा गरेर तिनीहरूलाई भन्: ‘जब तिमीहरू मैले दिन लागेको देशमा प्रवेश गर्छौ र त्यहाँ बाली कटनी गर्छौ; तब तिमीहरूले कटनी गरेका पहिलो अन्‍नको एक बिटा पुजारीकहाँ ल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","उसले त्यो बिटा याहवेहको सामु उचालेर अर्पण गरोस्, ताकि त्यो तिमीहरूको पक्षमा ग्रहण होस्। पुजारीले त्यसलाई शब्बाथ दिनको भोलिपल्ट विशेष भेटीको रूपमा अर्पण गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","तिमीहरूले बिटा उचालेर अर्पण गरिने दिन याहवेहका निम्ति एउटा निष्खोट एकवर्षे थुमा होमबलिस्वरूप चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","त्यससित एपाको दशौँ भागको दुई भाग मसिनो पिठो जैतुन तेलसँग मिसाएर अग्निबलि याहवेहलाई मनपर्ने बास्‍ना हुने गरी र एक हिन दाखमद्य अर्घबलिस्वरूप चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","यी बलिहरू आफ्ना परमेश्‍वरकहाँ नल्याएसम्म तिमीहरूले कुनै रोटी, भुटेको अन्‍न अथवा नयाँ अन्‍न नखानू। तिमीहरू जहाँ बसे तापनि यो भावी पुस्ताका लागि एउटा सधैँ रहिरहने विधि हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘शब्बाथ दिनको भोलिपल्ट अर्थात् तिमीहरूले विशेष भेटीको बिटा ल्याएको दिनदेखि पूरा सात हप्‍ता गन्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातौँ शब्बाथ दिनको भोलिपल्टसम्म पचास दिन गन्‍नू; अनि नयाँ अन्‍नबलि याहवेहकहाँ चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","तिमीहरू जहाँ भए तापनि आ-आफ्नो घरबाट चढाउने भेटीको रूपमा दुई वटा रोटीहरू ल्याउनू। यी रोटीहरू एपाको दश भागको दुई भाग मसिनो पिठो प्रयोग गरेर बनाउनू। यी रोटीहरू खमिर हालेर बनाउनू। अनि कटनी गरेको पहिलो फल बलिस्वरूप विशेष भेटीको रूपमा चढाइनका लागि याहवेहकहाँ ल्याउनू ");
INSERT INTO npioncb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","त्यस रोटीसित भेडाका निष्खोट एकवर्षे सात वटा पाठा, एउटा बाछा र दुई वटा भेडा ल्याउनू। ती तिनीहरूका अन्‍नबलि र अर्घबलिसहित अग्निबलिको रूपमा याहवेहका निम्ति मिठो बास्‍नाको होमबलि हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","त्यसपछि पाप शुद्धीकरण बलिका निम्ति एउटा बोका र मेलबलिका निम्ति भेडाका एकवर्षे दुई वटा पाठाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","पुजारीले ती दुई भेडालाई अगौटे फलको रोटीसित विशेष भेटीको रूपमा अर्पण गरिनका लागि उचालोस्। पुजारीका निम्ति ती याहवेहकहाँ पवित्र बलि हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","त्यही दिन तैँले एउटा पवित्र सभाको घोषणा गर्नू; तर दैनिक काम नगर्नू। तिमीहरू जहाँ बसे तापनि पुस्तौँ-पुस्ताका लागि यो एउटा सधैँ रहिरहने विधि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘तिमीहरूले आफ्नो जमिनको फसल कटनी गर्दा जमिनको किनारसम्म नकाट्नू, अथवा आफ्नो कटनीको सिलाबाला नबटुल्नू। ती गरिबहरू र परदेशीहरूका निम्ति छोडिदिनू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलीहरूलाई भन्: ‘सातौँ महिनाको पहिलो दिन तिमीहरूका निम्ति शब्बाथ विश्रामको दिन हुनुपर्छ। तुरही फुकेर सम्झनाका निम्ति एक पवित्र सभा हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","नियमित काम नगर्नू, तर आगोद्वारा चढाइने भेटी याहवेहकहाँ चढाउनू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“यस सातौँ महिनाको दशौँ दिन प्रायश्‍चितको दिन हो। एउटा पवित्र सभा बोलाउनू र आफूलाई इन्कार गर्नू; अनि याहवेहकहाँ अग्निबलि चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","त्यस दिन कुनै काम नगर्नू। किनकि त्यो याहवेह तिमीहरूका परमेश्‍वरको सामु तिमीहरूका निम्ति प्रायश्‍चित गरिने प्रायश्‍चितको दिन हो। ");
INSERT INTO npioncb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","त्यस दिन आफूलाई इन्कार नगर्नेलाई आफ्ना मानिसहरूबाट बहिष्कार गरियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","त्यस दिन कुनै पनि काम गर्नेलाई म त्यसका मानिसहरूबाट नाश गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","तिमीहरूले कुनै काम नगर्नू। तिमीहरू जहाँ बसे तापनि भावी पुस्ताका लागि यो सधैँभरि रहिरहने एक विधि हो। ");
INSERT INTO npioncb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यो तिमीहरूका निम्ति शब्बाथ विश्रामको दिन हो। अनि तिमीहरूले आफूलाई इन्कार गर्नू। महिनाको नवौँ दिनको साँझदेखि भोलिपल्टको साँझसम्म तिमीहरूले आफ्ना शब्बाथ पालन गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलीहरूलाई भन्: ‘सातौँ महिनाको पन्ध्रौँ दिनमा याहवेहको छाप्रोबासको चाड सुरु हुन्छ र यो सात दिनसम्म रहन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","पहिलो दिन पवित्र सभा हो। त्यस दिन दैनिक काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","सात दिनसम्म याहवेहकहाँ अग्निबलि चढाउनू। आठौँ दिनमा एउटा पवित्र सभा राख्नू। अनि याहवेहकहाँ अग्निबलि चढाउनू। यो समाप्‍तिको विशेष सभा हो। यस दिन दैनिक काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘याहवेहका तोकिएका चाडहरू यिनै हुन्, जसलाई तिमीहरूले याहवेहकहाँ आगोद्वारा चढाइने बलि—होमबलि र अन्‍नबलि र प्रतिदिन चढाइनुपर्ने बलिदानहरू र अर्घबलिहरू ल्याउनका लागि पवित्र सभा भनी घोषणा गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","यी बलिहरू याहवेहका शब्बाथ दिनका भेटीहरू, तिमीहरूका उपहारहरू, तिमीहरूका भाकलका भेटीहरू अनि तिमीहरूले याहवेहलाई दिने स्वेच्छा-भेटीहरू बाहेकका हुन्।) ");
INSERT INTO npioncb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘यसकारण सातौँ महिनाको पन्ध्रौँ दिन तिमीहरूले जमिनको बाली बटुलिसकेपछि याहवेहका निम्ति सात दिनसम्म चाड मनाउनू। पहिलो दिन शब्बाथ विश्रामको दिन हो। अनि आठौँ दिन पनि शब्बाथ विश्रामदिन हो। ");
INSERT INTO npioncb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिलो दिन तिमीहरूले विशाल रूखका हाँगाहरू—खजूरका रूखबाट धेरै पात हुने रूखहरू र लहरे पीपलको रूखबाट याहवेह तिमीहरूका परमेश्‍वरका सामु सात दिनसम्म आनन्द मनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","यो उत्सव तिमीहरूले याहवेहका निम्ति सात दिनसम्म हरेक वर्ष मनाउनू। भावी पुस्ताका निम्ति यो सदाकालका लागि एक विधि हो। यसलाई तिमीहरूले सातौँ महिनामा मनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","तिमीहरू सात दिनसम्म पालहरूमा बस्‍नू: स्वदेशमा जन्मेका सबै इस्राएलीहरू पालहरूमा बस्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","अनि तिमीहरूका सन्तानले जान्‍नेछन्, कि मैले इस्राएलीहरूलाई इजिप्टबाट निकालेर ल्याउँदा तिनीहरूलाई पालमा बस्‍न लगाएको थिएँ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","यसकारण मोशाले इस्राएलीहरूलाई याहवेहका तोकिएका चाडहरू घोषणा गरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलीहरूलाई आज्ञा दिनू, कि तिनीहरूले उज्यालोका निम्ति पेलेको जैतुनको शुद्ध तेल ल्याऊन्, र दियाहरू निरन्तर बलिरहून्। ");
INSERT INTO npioncb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","समागम पालमा गवाही पर्दाको बाहिर हारूनले साँझदेखि बिहानसम्मै लगातार याहवेहको सामु बत्तीहरूको रेखदेख गरिरहोस्। यो भावी पुस्ताका लागि सदा रहिरहने विधि हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","याहवेहको सामु निखुर सुनको पानसमा बत्तीहरूको रेखदेख लगातार भइरहनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“प्रत्येक रोटीको लागि एपाको दश भागको दुई भाग प्रयोग गरेर मसिनो पिठोको बाह्र वटा रोटीहरू पकाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","तिनीहरूलाई एक लहरमा छ वटा गरेर दुई लहरमा, याहवेहका सामु निखुर सुनको टेबुलमा मिलाएर राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","याहवेहकहाँ अग्निबलि हुन दिनलाई र रोटीको प्रतिनिधित्व गर्नलाई सम्झनाको भागस्वरूप प्रत्येक लहरमा केही शुद्ध धूप बाल्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","यी रोटीलाई इस्राएलीहरूको पक्षबाट सदाको करारस्वरूप याहवेहका सामु हरेक शब्बाथ दिनमा नियमित रूपले राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","त्यो हारून र त्यसका छोराहरूका निम्ति हुनेछ, तिनीहरूले त्यसलाई पवित्र ठाउँमा खाऊन्। किनभने यो याहवेहका निम्ति आगोद्वारा चढाइएको बलिबाट तिनीहरूका नियमित अति पवित्र भाग हो।” ");
INSERT INTO npioncb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","अब एउटी इस्राएली आमा र इजिप्टियन बुबाको छोरा इस्राएलीहरूको बीचमा गयो। अनि त्यस इस्राएली स्त्रीको छोरा र इस्राएलीहरू बीचको छाउनीमा झगडा सुरु भयो। ");
INSERT INTO npioncb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","इस्राएली स्त्रीको छोराले सरापेर याहवेहको निन्दा गर्‍यो। त्यसकारण तिनीहरूले त्यसलाई मोशाकहाँ ल्याए। (त्यसकी आमाको नाम शलोमीत थियो, जो दान कुलको दिब्रीकी छोरी थिइन्।) ");
INSERT INTO npioncb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","याहवेहको इच्छा स्पष्‍ट नभएसम्म तिनीहरूले त्यसलाई थुनामा राखे। ");
INSERT INTO npioncb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“यस ईश्‍वर निन्दकलाई छाउनीबाहिर लैजानू। त्यसले बोलेका सुन्‍नेहरू सबैले त्यसको शिरमाथि हात राखून्। अनि सारा समुदायले त्यसलाई ढुङ्गाले हानून्। ");
INSERT INTO npioncb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","इस्राएलीहरूलाई भन्: ‘यदि कसैले परमेश्‍वरलाई सराप्छ भने त्यो पापको जिम्मेवार ठहरिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","यदि कसैले याहवेहको नामको निन्दा गर्छ भने त्यो मारियोस्। सारा समुदायले त्यसलाई ढुङ्गाले हानून्। चाहे परदेशी होस् वा स्वदेशमा जन्मेको होस्। कसैले याहवेहको नामको निन्दा गर्‍यो भने त्यो मारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘यदि कसैले मानिसको हत्या गर्‍यो भने त्यो मारिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","जसले कसैको पशुलाई मार्छ भने त्यसले हर्जाना तिर्नुपर्छ—प्राणको साटो प्राण। ");
INSERT INTO npioncb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","यदि कसैले आफ्नो छिमेकीलाई चोट पार्‍यो भने त्यसले उसलाई जे गरेको छ, त्यसलाई पनि त्यसै गरियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","हाड भाँचिदिएको सट्टा हाड; आँखाको सट्टा आँखा; दाँतको सट्टा दाँत। जसरी त्यसले अरूलाई चोट पारेको छ, त्यसरी नै त्यस मानिसलाई पनि चोट पारिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","जसले कुनै पशु मार्छ, त्यसले हर्जाना तिर्नुपर्छ; तर जसले मानिस मार्छ, त्यो मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","परदेशी वा स्वदेशी मानिसका निम्ति तिमीहरूको एउटै कानुन हुनुपर्छ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","त्यसपछि मोशाले इस्राएलीहरूसित कुरा गरे, र तिनीहरूले त्यस ईश्‍वर निन्दकलाई छाउनीबाहिर लगे, र ढुङ्गाले हिर्काए। याहवेहले मोशालाई आज्ञा गर्नुभएझैँ इस्राएलीहरूले गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","याहवेहले मोशालाई सीनै पर्वतमा भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलीहरूसित कुरा गर्, र तिनीहरूलाई भन्: ‘मैले तिमीहरूलाई दिन लागेको देशमा जब तिमीहरू प्रवेश गर्छौ, तब त्यस देशले पनि याहवेहका निम्ति शब्बाथ दिन पालन गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","छ वर्ष तिमीहरूका जमिन रोप्नू, र दाखबारी छिँवल्नु; अनि अन्‍नबाली बटुल्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","तर सातौँ वर्षमा त्यस जमिनले शब्बाथ विश्रामको दिन—याहवेहका निम्ति शब्बाथ पाओस्। जमिनमा बिउ छर्ने काम र दाखबारी छिँवल्ने काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","त्यसमा आफैँ उब्जेका कुराहरूको कटनी नगर्नू, अथवा तिमीहरूले स्याहार नगरेका अङ्‌गुरको कटनी नगर्नू। त्यस जमिनले विश्राम वर्ष पाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","शब्बाथको वर्षमा जमिनले जे उब्जाउँछ, त्यो तिमीहरूका आफ्नै लागि, तिमीहरूका सेवक-सेविका, र ज्यालादारी मजदुर र तिमीहरूसित केही समयका लागि बसोबास गर्ने प्रवासीहरू; ");
INSERT INTO npioncb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","साथसाथै तिमीहरूका गाईबस्तु र तिमीहरूका जमिनमा भएका जङ्गली पशुहरूका निम्ति भोजन हुनेछ। जमिनले जे उब्जाउँछ, त्यो खाए हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘सात शब्बाथ वर्षहरू गन्‍नू—सात गुणा सात वर्षहरू; ताकि यी सात शब्बाथ वर्षहरू उनन्चास वर्ष होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","त्यसपछि सातौँ महिनाको दशौँ दिन चारैतिर तुरही फुक्न लगाउनू। प्रायश्‍चितको दिन तिमीहरूको सारा देशभरि तुरही फुक्न लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","पचासौँ वर्षलाई पवित्र मानेर देशभरिका बासिन्दाहरूलाई स्वतन्त्रताको घोषणा गर्नू। यो तिमीहरूका निम्ति उत्सव वर्ष हुनेछ। प्रत्येक आफ्नो पैतृक सम्पत्तितिर र आफ्नो परिवारमा फर्किजान सक्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","पचासौँ वर्ष तिमीहरूका निम्ति उत्सव वर्ष हुनेछ। त्यस वर्ष बिउ नछर्नू। अनि आफैँ उब्जेका फसलको कटनी नगर्नू वा हेरचाह नगरिएका अङ्‌गुरको कटनी नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","किनकि यो उत्सव वर्ष हो; तिमीहरूका निम्ति यो पवित्र हुनुपर्छ; जमिनबाट सीधै ल्याइएको मात्र खानू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘त्यस उत्सव वर्षमा हरेक मानिस आफ्नै पैतृक सम्पत्तितिर फर्केर जानुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘यदि तिमीहरूले आफ्नै देशवासीहरूमध्ये कसैलाई आफ्नो जमिन बेच्यौ, अथवा त्यसबाट किन्यौ भने आपसमा फाइदा नउठाऊनू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","पचासौँ वर्षको पछिका वर्षहरू हिसाब गरेर तिमीहरूले आफ्ना मानिससित किन्‍नू; र बाँकी वर्षको उब्जनीको हिसाब गरेर त्यसले तिमीहरूलाई बेचोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","यदि वर्षहरू धेरै छन् भने तिमीहरूले दाम बढाउनू। अनि वर्षहरू थोरै छन् भने तिमीहरूले दाम घटाउनू; किनकि त्यसले जे बेच्दैछ, त्यो बालीको उब्जनीका वर्षहरूको संख्याअनुसार बेचेको हो। ");
INSERT INTO npioncb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","एक-आपसमा फाइदा नउठाऊनू; तर आफ्ना परमेश्‍वरको डर मान्‍नू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘मेरा उर्दीहरू मान्‍नू र मेरा व्यवस्थाहरू होशियारीसाथ पालन गर्नू; तब तिमीहरू यस देशमा सुरक्षित रहनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","तब देशले प्रशस्त फल दिनेछ, र तिमीहरू पर्याप्‍त खानेछौ। अनि त्यसमा सुरक्षित भएर रहनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","तिमीहरूले सोध्न सक्छौ, “यदि हामीले रोपेनौँ र अन्‍नको कटनी गरेनौँ भने सातौँ वर्षमा हामीले के खाने त?” ");
INSERT INTO npioncb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","छैटौँ वर्षमा म यस्तो आशिष् पठाउनेछु, कि जमिनले तीन वर्षसम्म पुग्ने प्रशस्त उब्जनी दिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","तिमीहरूले आठौँ वर्षमा रोप्दा पुरानै अन्‍न खानेछौ, र नवौँ वर्षको कटनी नभएसम्म त्यसबाट खाइरहनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘जमिन सधैँको निम्ति बेच्नुहुँदैन। किनकि जमिन मेरो हो र तिमीहरू परदेशी र प्रवासीहरू मात्र हौ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","तिमीहरूले अधिकार गरेको देशभरि जमिनको छुटकाराको मोलको प्रबन्ध गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘यदि तिमीहरूका देशवासीहरूमध्ये कोही गरिब भएर जग्गाजमिन बेचेको छ भने, र त्यसको सबैभन्दा नजिकको नातेदारले आएर आफ्नो नातेदारले जे बेचेको छ, त्यसलाई छुटाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","तरै पनि कुनै मानिसको त्यसलाई आफ्ना निम्ति छुटाइदिने नातेदार छैन, र त्यसले आफूले उन्‍नति गरेर त्यसलाई छुटाउने पर्याप्‍त साधन जुटायो भने, ");
INSERT INTO npioncb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","त्यसले आफूले बेचेको समयदेखिका वर्षहरूको मूल्य ठहराओस्। अनि जुन मानिसलाई त्यो बेचिएको छ, त्यसलाई बाँकी रकम फर्काइदेओस्; तब त्यो आफ्नो सम्पत्तितिर फर्केर जान सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","तर यदि त्यसले उसलाई तिर्ने साधन जुटाउन सकेन भने पचासौँ वर्षको उत्सवसम्म किन्‍ने मानिसकै हातमा त्यो जमिन रहनेछ। अनि पचासौँ वर्षको उत्सवमा त्यो फिर्ता गरियोस्। त्यसपछि त्यो मानिसचाहिँ आफ्नो सम्पत्तिमा फर्केर जान सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘कसैले पर्खाल लगाएको सहरभित्र भएको आफ्नो घर बेच्यो भने बेचेको एक वर्षभित्र त्यो छुटाउन पाउनेछ। त्यसलाई यो अधिकार पूरा एक वर्षसम्म हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","यदि पूरा एक वर्षभित्र त्यो छुटाउन सकिएन भने किन्‍ने र त्यसका भावी सन्तानका निम्ति त्यो पर्खाल सहरभित्र भएको घर स्थायी सम्पत्ति बनोस्। पचासौँ वर्षको उत्सवमा पनि त्यो फिर्ता हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","तर पर्खालले नघेरिएका गाउँका घरहरूचाहिँ खुला जमिनसरह ठान्‍नू। ती छुटाउन सकिन्छ, र पचासौँ वर्षको उत्सवमा फिर्ता गरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘लेवीहरूका अधिकारका आफ्नै नगरहरूमा भएका घरहरूचाहिँ तिनीहरूले जुनसुकै बेला पनि छुटाउन सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","यसरी लेवीहरूका सम्पत्ति तिनीहरूका अधीनमा भएको सहरमा भएको बेचिएको घर फिर्ता लिन सकिन्छ। अनि त्यो पचासौँ वर्षको उत्सवमा फर्काइनुपर्छ; किनकि लेवीका सहरहरूमा भएका घरहरू इस्राएलीहरू बीचमा तिनीहरूका सम्पत्ति हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","तर तिनीहरूका सहरहरूमा भएका खर्क नबेचियोस्; त्यो तिनीहरूको स्थायी सम्पत्ति हो। ");
INSERT INTO npioncb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘यदि तिमीहरूका देशवासीहरूमध्ये कोही गरिब भएको छ, र त्यसले तिमीहरूबीच आफ्नो जीविका निर्वाह गर्न असमर्थ भयो भने तिमीहरूले परदेशी र अपरिचितलाई जसरी सहायता गर्नेथियौ, त्यसरी नै तिनीहरूलाई पनि सहायता गर्नू। अनि ती तिमीहरूसित बसिरहन पाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","तिनीहरूबाट कुनै किसिमको ब्याज वा लाभ नलिनू। तर आफ्ना परमेश्‍वरको डर मान्‍नू; र तिमीहरूका दाजुभाइ तिमीहरूसित बसोबास गर्न पाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","तिमीहरूले तिनीहरूलाई ब्याजमा ऋण नदिनू, अथवा नाफा गरेर तिनीहरूलाई भोजन नबेच्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","म याहवेह नै तिमीहरूका परमेश्‍वर हुँ; जसले तिमीहरूलाई कनान देश दिन र तिमीहरूका परमेश्‍वर हुनलाई तिमीहरूलाई इजिप्टबाट निकालेर ल्याएँ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘यदि तिमीहरूका इस्राएली दाजुभाइ गरिब भएर आफूलाई तिमीहरूका हातमा बेचे भने तिनीहरूलाई दासझैँ काममा नलगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","तिनीहरू ज्यालामा काम गर्ने नोकर अथवा प्रवासीजस्तै भएर तिमीसँग बसून्। अनि पचासौँ वर्षको उत्सवसम्म तिमीहरूसँग बसी तिनीहरूले तिमीहरूका काम गरून्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","त्यसपछि तिनीहरू र तिनीहरूका छोराछोरीहरूलाई छाडिदिनुपर्छ। अनि तिनीहरू आफ्नै घराना र तिनीहरूका पितापुर्खाहरूका सम्पत्तितिर जाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","इस्राएलीहरू इजिप्टबाट ल्याएका मेरै सेवकहरू हुन्; तिनीहरू दासहरूझैँ बेचिनुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तिनीहरूमाथि निर्ममतापूर्वक शासन नगर्नू, तर तिमीहरूका परमेश्‍वरको डर मान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘तिमीहरूका सेवक-सेविकाहरू तिमीहरूका चारैतिरका राष्ट्रहरूबाट किन्‍न सक्छौ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तिमीहरूका बीचमा अस्थायी बास बसेका परदेशी र तिमीहरूका देशमा जन्मेका तिनीहरूका परिवारका सदस्यहरूलाई पनि किन्‍न सक्छौ। अनि तिनीहरू तिमीहरूका सम्पत्ति हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तिमीहरूले तिनीहरूलाई आफ्ना छोराछोरीहरूका निम्ति पैतृक अधिकारस्वरूप इच्छापत्र गरेर दिन सक्छौ। अनि तिनीहरूलाई जीवन पर्यान्त कमारा-कमारी बनाउन सक्छौ। तर तिमीहरूले आफ्ना सङ्गी इस्राएलीहरूलाई निर्ममतापूर्वक व्यवहार नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘यदि तिमीहरूका बीचमा भएको परदेशी धनी भयो भने, र तिमीहरूका देशवासीमध्ये कोही गरिब भएर तिनीहरूले आफूलाई तिमीहरूका बीचमा भएको परदेशी अथवा त्यस परदेशीको आफन्तको हातमा बेच्यो भने, ");
INSERT INTO npioncb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","तिनीहरूले आफूलाई बेचेपछि छुटकाराको अधिकार आफूसँग राखेका हुन्छन्। तिनीहरूका कुनै आफन्तले तिनीहरूलाई छुटाउन सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","काका अथवा दाजुभाइ पर्ने अथवा त्यसका घरानाका कुनै रगतको साइनो पर्नेले त्यसलाई छुटाउन सक्छ। अथवा यदि त्यसले उन्‍नति गर्‍यो भने आफैँलाई छुटाउन सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","त्यसले र त्यसलाई किन्‍नेले तिनीहरूले आफूलाई बेचेको समयदेखि पचासौँ वर्षको उत्सवसम्म गनून्। त्यसको छुटकाराको मूल्य त्यतिका वर्षहरूसम्म एक ज्यालादार मानिसलाई दिइने दरको आधारमा हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","यदि अझ धेरै वर्ष रहेको छ भने तिनीहरूले आफ्नो छुटकाराका लागि आफ्नो मूल्यको ठूलो भाग तिर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","यदि पचासौँ वर्षको उत्सव आउन केही वर्ष मात्र रहेको छ भने त्यसले त्यो गनोस्। अनि आफ्नो छुटकाराको मोल त्यस किसिमले नै तिरोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","त्यसलाई हरेक वर्ष ज्यालामा लिएको मानिसझैँ ठानियोस्। त्यसका मालिकले त्यसलाई निर्दयतापूर्वक व्यवहार नगरोस् भनी तिमीहरूले याद राख्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘यदि त्यसको छुटकारा यी कुनै पनि तरिकाले भएन भने त्यो र त्यसका छोराछोरीहरूको छुटकारा पचासौँ वर्षको उत्सवमा हुनुपर्छ; ");
INSERT INTO npioncb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","किनकि इस्राएलीहरू मेरा सेवकहरू हुन्। तिनीहरू मेरा सेवकहरू हुन्, जसलाई मैले इजिप्टबाट निकालेर ल्याएँ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘तिमीहरूले मूर्तिहरू नबनाउनू, अथवा कुनै आकृति अथवा चोखो ढुङ्गा आफ्नो निम्ति खडा नगर्नू। अनि तिमीहरूका देशमा ढुङ्गा खोपेर त्यसलाई राखेर दण्डवत् नगर्नू। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘मेरा शब्बाथहरू पालन गर्नू, र मेरो पवित्रस्थानलाई आदर गर्नू। म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘यदि तिमीहरू मेरा उर्दीअनुसार चल्यौ र मेरा आज्ञाहरू होशियारीसाथ पालन गर्‍यौ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","म तिमीहरूलाई ठिक समय वर्षा पठाउनेछु, र जमिनले उब्जनी दिनेछ। अनि खेतका रूखहरूले फल फलाउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","अङ्‌गुरको कटनीसम्म तिमीहरू दाइँ गरिरहेका हुनेछौ; र बिउ छर्ने समयसम्म तिमीहरूले अङ्‌गुर टिपिरहेका हुनेछौ। अनि तिमीहरूले आफूले पेटभरि भोजन खानेछौ; र आफ्नो देशमा सुरक्षित रहनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘म देशमा शान्ति दिनेछु; र तिमीहरू डरविना सुत्नेछौ। म देशबाट हिँस्रक पशुहरू हटाइदिनेछु र तिमीहरूको देशमा तरवार चल्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","तिमीहरूले आफ्ना शत्रुहरूलाई खेद्नेछौ; र तिनीहरू तिमीहरूका सामु तरवारद्वारा ढालिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तिमीहरूका पाँच जनाले एक सय जनालाई लखेट्नेछन्; र तिमीहरूका एक सयले दश हजारलाई लखेट्नेछ। अनि तिमीहरूका शत्रुहरू तिमीहरूका सामु तरवारद्वारा ढालिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘म तिमीहरूलाई निगाहको दृष्‍टिले हेर्नेछु, र तिमीहरूलाई फलदायक बनाउनेछु। अनि तिमीहरूको संख्या वृद्धि गर्नेछु। मैले तिमीहरूसित गरेको करार पूरा गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तिमीहरूले बितेको वर्षको उब्जनी खाइरहेका हुँदा नै त्यसलाई पर सारेर नयाँ उब्जनीको निम्ति ठाउँ बनाउनुपर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","म आफ्नो वासस्थान तिमीहरूबीच राख्नेछु; र म तिमीहरूलाई घृणा गर्नेछैनँ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","म तिमीहरूको बीचमा हिँड्‍डुल गर्नेछु, र तिमीहरूका परमेश्‍वर हुनेछु। अनि तिमीहरू मेरा प्रजा हुनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","म याहवेह नै तिमीहरूका परमेश्‍वर हुँ। तिमीहरू इजिप्टियनहरूका दास हुन नपरोस् भनेर मैले तिमीहरूलाई इजिप्टबाट निकालेर ल्याएँ। मैले तिमीहरूका जुवाका काठ भाँचेर तिमीहरूलाई शिर ठाडो पारेर हिँड्न योग्यको तुल्याएको छु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘तर यदि तिमीहरूले मेरा कुरा सुनेनौ र यी सबै आज्ञापालन गरेनौ, ");
INSERT INTO npioncb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","अनि यदि तिमीहरूले मेरा उर्दीहरू इन्कार गर्‍यौ र मेरा आज्ञाहरूलाई घृणा गर्‍यौ, र मेरा आज्ञाअनुसार चल्न असफल भयौ र यसरी मेरा करार भङ्ग गर्‍यौ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","म तिमीहरूमा अचानक आतङ्क, निको नहुने रोगहरू र ज्वरो फैलाउनेछु; जसले तिमीहरूका दृष्‍टिलाई नष्‍ट गरिदिनेछन्। अनि तिमीहरूका प्राणलाई शिथिल पार्नेछन्। तिमीहरू व्यर्थैमा रोप्नेछौ; किनकि ती तिमीहरूका शत्रुहरूले खानेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","म आफ्नो अनुहार तिमीहरूका विरुद्धमा पार्नेछु। अनि तिमीहरू आफ्ना शत्रुहरूद्वारा पराजित हुनेछौ। तिमीहरूलाई घृणा गर्नेहरूले तिमीहरूमाथि शासन गर्नेछन्। कसैले नखेदे तापनि तिमीहरू भाग्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘यी सबै कुराहरू भइसकेपछि पनि यदि तिमीहरूले मेरा कुरा सुनेनौ भने म तिमीहरूलाई आफ्ना पापको लागि सात गुणा बढी दण्ड दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","म तिमीहरूका हठीपूर्ण अभिमान चुर पार्नेछु। अनि तिमीहरूमाथि भएको आकाशलाई फलामझैँ र तिमीहरूमुनि भएको जमिनलाई काँसोझैँ बनाउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तिमीहरूले व्यर्थमा परिश्रम गर्नेछौ; किनकि तिमीहरूका माटोले त्यसको उब्जनी दिनेछैन, न त तिमीहरूका जमिनका रूखहरूले आफ्नो फल दिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘यदि तिमीहरू मेरो विरोधी भइरह्‍यौ र मेरो कुरा सुन्‍न इन्कार गर्‍यौ भने म तिमीहरूका पापको योग्य तिमीहरूका कष्‍टहरू सात गुणा बढी बढाइदिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","म तिमीहरूका विरुद्धमा जङ्गली जनावरहरू पठाइदिनेछु; जसले तिमीहरूका सन्तानलाई खानेछन्। अनि तिमीहरूका गाईबस्तुहरूलाई सखाप पार्नेछन्। तिमीहरूको संख्या यति थोरै पार्नेछन् कि तिमीहरूका बाटा सुनसान हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘यी सबै भइसकेपछि पनि यदि तिमीहरूले मेरो सुधारलाई ग्रहण गरेनौ र मेरो विरोधी भइरह्‍यौ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","म आफैँ तिमीहरूका विरुद्धमा हुनेछु। अनि तिमीहरूलाई आफ्ना पापको निम्ति सात गुणा बढी कष्‍ट दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","म तिमीहरूमाथि तरवार ल्याउनेछु, र मेरो करार भङ्ग गरेको बदला लिनेछु। जब तिमीहरू आ-आफ्ना सहरमा जम्मा हुनेछौ, म त्यहाँ तिमीहरूका बीचमा महामारी पठाउनेछु। अनि तिमीहरू आफ्ना शत्रुहरूका हातमा पर्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","जब म तिमीहरूका भोजन आपूर्तिलाई बन्द गरिदिनेछु, तब एउटै घरको चुलोमा दश घरका स्त्रीहरूले रोटी पकाउनेछन्, र नापी-नापी थोरै मात्रामा भाग लगाउनेछन्। तिमीहरूले खान त खानेछौ, तर तृप्‍त हुनेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘यदि यी सबै भएर पनि तिमीहरूले मेरा कुरा सुनेनौ, तर मेरो विरोधी भइरह्‍यौ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","म आफ्नो क्रोधमा तिमीहरूको विरोधमा हुनेछु। अनि म आफैँ तिमीहरूका पापहरूका लागि सात गुणा बढी दण्ड दिनेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तिमीहरूले आफ्नै छोराहरूका मासु खानेछौ र आफ्नै छोरीहरूका मासु खानेछौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","म तिमीहरूका अग्ला देवस्थानहरू भत्काउनेछु। तिमीहरूका धूपका वेदीहरू ढालिदिनेछु; अनि तिमीहरूका मृत शरीरलाई तिमीहरूका निर्जीव मूर्तिहरूमाथि थुप्रो लगाइदिनेछु। अनि म तिमीहरूलाई अति घृणा गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","म तिमीहरूका सहरहरूलाई उजाड पार्नेछु, र तिमीहरूका पवित्रस्थानहरूलाई शून्य पारिदिनेछु। अनि तिमीहरूले चढाएका बलिदानहरूका बास्‍नाले मलाई प्रसन्‍न पार्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","म देशलाई उजाड पारिदिनेछु; र त्यहाँ बस्‍ने तिमीहरूका शत्रुहरू पनि छक्‍क पर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","मचाहिँ तिमीहरूलाई जाति-जातिहरूका बीचमा तितरबितर पारिदिनेछु। अनि नाङ्गो तरवार लिएर तिमीहरूलाई खेद्नेछु। तिमीहरूको देश सुनसान र तिमीहरूका सहरहरू उजाड हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","तब देशले त्यसका शब्बाथ वर्षहरू त्यस उजाड रहेको समयभरि र तिमीहरू आफ्ना शत्रुका देशमा हुँदाखेरि उपभोग गर्नेछ; तब देशले बिसाएर आफ्नो शब्बाथहरूका आनन्द लिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","आफू उजाड रहेको समयभरि देशले तिमीहरू त्यसमा बस्दा नपाएको शब्बाथ पाउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘तिमीहरूमध्ये शत्रुको देशमा छोडिएका मानिसको हृदय म यति कमजोर पारिदिनेछु कि पात खसेको आवाज सुन्दा समेत तिनीहरू शत्रुबाट खेदिएझैँ भाग्नेछन्। शत्रुहरूका तरवारबाट भागेझैँ तिनीहरू भाग्नेछन्। कसैले नखेदे तापनि तिनीहरू लोट्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","कसैले नखेदे तापनि तिनीहरू तरवारदेखि भागेझैँ एक-अर्कामाथि ठक्‍कर खाएर लोट्नेछन्। यसरी तिमीहरू आफ्ना शत्रुहरूका सामु खडा हुन सक्नेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तिमीहरू जातिहरूका बीचमा पतन हुनेछौ। तिमीहरूका शत्रुहरूका देशले तिमीहरूलाई निल्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","बाँकी रहेकाहरूचाहिँ शत्रुहरूका देशमा आफ्नै र आफ्ना पुर्खाहरूका अधर्मले गर्दा नष्‍ट भएर जानेछन्। ");
INSERT INTO npioncb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘तर यदि तिनीहरूले आफ्नै र आफ्ना पितापुर्खाका पाप, अर्थात् मेरो विरुद्धमा तिनीहरूले गरेका विश्‍वासघात र मप्रति देखाएका शत्रुताको व्यवहार स्वीकार गरे भने, ");
INSERT INTO npioncb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","जसले गर्दा म तिनीहरूप्रति शत्रु भएँ; अनि मैले तिनीहरूलाई तिनीहरूका शत्रुहरूका देशमा पठाएँ। यदि आफ्ना खतना नभएको हृदय नम्र तुल्याई आफ्ना पापका लागि सजाय भोगे भने, ");
INSERT INTO npioncb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","याकोबसँग गरेको मेरो करार, इसहाकसँग गरेको मेरो करार र अब्राहामसँग गरेको मेरो करार, र म त्यस देशलाई पनि सम्झनेछु। ");
INSERT INTO npioncb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","किनकि देश तिनीहरूद्वारा त्यागिनेछ। तिनीहरू नभएकाले देश उजाड भएको बेला त्यसले आफ्ना शब्बाथहरू उपभोग गर्नेछ। तिनीहरूले आफ्ना पापहरूका मूल्य चुकाउनुपर्नेछ; किनकि तिनीहरूले मेरा व्यवस्थाहरूलाई तिरस्कार गरे, र मेरा उर्दीहरूलाई घृणा गरे। ");
INSERT INTO npioncb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","तर यी सबै भएर पनि तिनीहरू आफ्ना शत्रुहरूका देशमा हुँदा तिनीहरूसित मैले गरेको करार भङ्ग गरेर तिनीहरूलाई सम्पूर्ण तवरले नष्‍ट गर्ने हिसाबले म तिनीहरूलाई तिरस्कार गर्नेछैनँ; अनि घृणा गर्नेछैनँ। म याहवेह नै तिनीहरूका परमेश्‍वर हुँ। ");
INSERT INTO npioncb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","तर म तिनीहरूका खातिर तिनीहरूका पुर्खाहरूसित बाँधेको करारलाई सम्झनेछु; जसलाई मैले जातिहरूका दृष्‍टिमा तिनीहरूका परमेश्‍वर हुनलाई इजिप्टबाट निकालेर ल्याएँ। म नै याहवेह हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","याहवेहले सीनै पर्वतमा मोशाद्वारा आफ्नै र इस्राएलीहरूको बीचमा स्थापित गर्नुभएका उर्दीहरू, व्यवस्थाहरू र नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलीहरूसित कुरा गर्, र तिनीहरूलाई भन्: ‘यदि कसैले विशेष भाकल गरेर याहवेहका निम्ति मानिसलाई अर्पण गर्ने कुरामा त्यसको मोल बराबरको केही दिन्छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","बीस वर्षदेखि साठी वर्षसम्मका पुरुषको पवित्रस्थानको शेकेल बमोजिम चाँदीका पचास शेकेल तोक्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","यदि त्यो स्त्री हो भने त्यसको मोल तीस शेकेल तोक्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","यदि पाँचदेखि बीस वर्षसम्मका छन् भने पुरुषका लागि मोल बीस शेकेल र स्त्रीको दश शेकेल तोक्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","त्यो व्यक्ति एक महिनादेखि पाँच वर्षसम्मको हो भने बालकको मोल चाँदीको पाँच शेकेल र बालिकाको चाँदीको तीन शेकेल तोक्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","यदि त्यो व्यक्ति साठी वर्षका र त्योभन्दा बढी उमेर पुगेको छ भने पुरुषको मोल पन्ध्र शेकेल र स्त्रीका लागि दश शेकेल तोक्नू। ");
INSERT INTO npioncb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","तोकिएको मोल तिर्नका लागि यदि कोही भाकल गर्ने अति गरिब छ भने त्यसले अर्पण गरिएको व्यक्तिलाई पुजारीकहाँ ल्याओस्; जसले त्यसका निम्ति भाकल गर्ने मानिसले तिर्नसक्ने हिसाबले मोल तोकिदिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘यदि तिनीहरूले भाकल गरेको पशु भेटीको रूपमा याहवेहकहाँ ग्रहणयोग्य छ भने याहवेहलाई दिइएको यस्तो पशु पवित्र हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","तिनीहरूले असलको साटो खराब अथवा खराबको साटो असल गरी त्यसलाई नसाटून्। यदि तिनीहरूले एउटा पशुको साटो अर्को दिन चाहन्छन् भने ती दुवै पशु पवित्र हुन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","यदि तिनीहरूले भाकल गरेको पशु अशुद्ध हो, र याहवेहका निम्ति बलि दिन ग्रहणयोग्य छैन भने त्यो पशु पुजारीकहाँ ल्याइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","पुजारीले त्यो असल छ कि खराब छ भनी जाँच गर्नेछ। त्यसपछि पुजारीले जति मोल तोक्नेछ, त्यसको मोल त्यति नै हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","यदि त्यसको मालिकले त्यसलाई छुटाउन चाहन्छ भने त्यसले तोकेको मोलमा पाँचौँ भाग थपिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘कसैले याहवेहलाई आफ्नो घर अर्पण गर्छ भने पुजारीले त्यो घर असल छ कि छैन, सो हेरेर त्यसको मोल तोकिदेऊन्। पुजारीले जति तोक्छन्, त्यसको मोल त्यति नै हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","यदि आफ्नो घर अर्पण गर्ने मानिसले त्यसलाई छुटाउन चाहन्छ भने त्यसले त्यसमा तोकेको मोलको पाँचौँ भाग थप्नुपर्छ, र त्यो घर फेरि त्यसको हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘यदि कुनै मानिसले आफ्नो पारिवारिक जमिनको केही भाग याहवेहकहाँ अर्पण गर्छ भने त्यसको मोल त्यसका लागि चाहिने बिउको परिमाणको आधारमा तोकिनुपर्छ—एक होमेर जौको पचास शेकेल चाँदी। ");
INSERT INTO npioncb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि त्यसले आफ्नो जमिन पचासौँ वर्षको उत्सवमा अर्पण गर्छ भने तोकिएको मोल नै रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","तर यदि त्यसले आफ्नो जमिन पचासौँ वर्षको उत्सवपछि अर्पण गर्छ भने अर्को पचासौँ वर्षको उत्सव आइपुग्न जति वर्षहरू बाँकी छन्, त्यो पुजारीले हिसाब गर्नुपर्छ। अनि तोकिएको मोल कम हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","यदि आफ्नो जमिन अर्पण गर्ने मानिसले त्यसलाई छुटाउने इच्छा गर्छ भने त्यसले त्यसको मोलमा पाँचौँ भाग थप्नुपर्छ। अनि त्यो जमिन फेरि उसैको हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","तर यदि त्यसले त्यस जमिनलाई छुटाउँदैन भने अथवा त्यसले त्यो कसैलाई बेचिसकेको छ भने त्यो कहिल्यै पनि छुटाउन सक्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","पचासौँ वर्षको उत्सवमा जमिन छुटाइयो भने त्यो याहवेहकहाँ समर्पित जमिनझैँ पवित्र हुनेछ। अनि त्यो पुजारीहरूकै सम्पत्ति हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘यदि कुनै मानिसले आफ्नो परिवारको भाग होइन, तर आफूले किनेको जमिन याहवेहकहाँ अर्पण गर्छ भने, ");
INSERT INTO npioncb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","पुजारीले पचासौँ वर्षको उत्सवको हिसाब गरेर त्यसको जति मोल तोक्छन्, त्यसले याहवेहका निम्ति पवित्र ठानेर त्यही दिन देओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","पचासौँ वर्षको उत्सवमा त्यो जमिन जसबाट त्यसले किनेको थियो, त्यसलाई फर्काइदिनेछ, अर्थात् त्यो जमिन जसको थियो, त्यसैलाई फिर्ता जाओस्। ");
INSERT INTO npioncb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","प्रत्येक मोल पवित्रस्थानको शेकेलअनुसार, अर्थात् बीस गेराको एक शेकेलको हिसाबले तोकिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘तरै पनि कसैले कुनै पशुको पहिलो सन्तान अर्पण नगरोस्; किनकि पहिलो सन्तान पहिल्यैबाट याहवेहको हो। चाहे त्यो गोरु होस्, अथवा भेडा, त्यो याहवेहकै हो। ");
INSERT INTO npioncb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","यदि त्यो कुनै अशुद्ध पशु हो भने त्यसले यसलाई तोकिएको मोलमा अझ पाँचौँ भाग थपेर फिर्ता गरेर किनोस्। यदि त्यसले यसलाई छुटाउँदैन भने त्यो त्यसको तोकिएको मोलअनुसार बेचियोस्। ");
INSERT INTO npioncb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘तर कसैले पनि आफूसित भएको आफ्नै कुरा, चाहे त्यो मानिस होस्, अथवा पशु अथवा परिवारको जमिन होस्, त्यो याहवेहकहाँ अर्पण गरिएको छ भने त्यसलाई नबेचियोस्, अथवा नछुटाइयोस्। यसरी अर्पण गरिएका प्रत्येक कुरा याहवेहकहाँ अति पवित्र हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘नाशका निम्ति अर्पण गरिएको कुनै मानिसलाई पनि मोल तिरेर नछुटाउनू; त्यो मारिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘जमिनबाट आएको प्रत्येक कुरा, चाहे त्यो माटोबाट होस्, अथवा रूखको फलको होस्, त्यसको दशांश याहवेहको हो; त्यो याहवेहका निम्ति पवित्र हो। ");
INSERT INTO npioncb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","यदि कुनै मानिसले आफ्ना दशांश छुटाउन चाहन्छ भने त्यसले त्यसमा त्यसको पाँचौँ भाग थप्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","बथान र बगालका सम्पूर्ण दशांश—गोठालोको लहुरोमुनिबाट छिरेर जाने प्रत्येक दशौँ पशु—याहवेहका निम्ति पवित्र हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","कसैले असललाई खराबीबाट नछुटाओस्, अथवा साटासाट नगरोस्। यदि साट्यो भने त्यो पशु र साट्ने पशु दुवै पवित्र हुन्छन्, ती नछुटाइयोस्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","याहवेहले सीनै पर्वतमा इस्राएलीहरूका निम्ति मोशालाई दिनुभएका आज्ञाहरू यिनै हुन्।");
INSERT INTO npioncb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएलीहरू इजिप्टबाट निस्किएर आएको दोस्रो वर्षको दोस्रो महिनाको पहिलो दिनमा, सीनैको उजाडस्थानमा भेट हुने पालमा याहवेह मोशासँग बोल्नुभयो र उहाँले भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“सारा इस्राएलीहरूको समुदायलाई तिनीहरूका वंश र परिवारअनुसार हरेकको नामअनुसार एक-एक गरी सूची बनाएर जनगणना गर्। ");
INSERT INTO npioncb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","तैँले र हारूनले तिनीहरूका दलअनुसार बीस वर्ष अथवा त्यसभन्दा माथिका लडाइँमा जान सक्ने सबै पुरुषहरूलाई गन्ती गर्नुपर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","हरेक कुलबाट एक-एक जना, प्रत्येक परिवारको एक-एक जना मुखियाले तिमीहरूलाई सहयोग गरून्।” ");
INSERT INTO npioncb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","तिमीहरूलाई सहयोग गर्ने पुरुषहरूका नाम यिनै हुन्: “रूबेनको कुलबाट शदेऊरको छोरा एलिसूर; ");
INSERT INTO npioncb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमियोनको कुलबाट सूरीशद्दैको छोरा शलूमीएल; ");
INSERT INTO npioncb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदाको कुलबाट अम्मीनादाबको छोरा नहशोन; ");
INSERT INTO npioncb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साखारको कुलबाट सूआरको छोरा नथनिएल; ");
INSERT INTO npioncb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलूनको कुलबाट हेलोनको छोरा एलिआब; ");
INSERT INTO npioncb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफका छोराहरूबाट: अर्थात् एफ्राइमको कुलबाट अम्मीहूदको छोरा एलिशामा; मनश्शेको कुलबाट पदासूरको छोरा गमलिएल; ");
INSERT INTO npioncb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बेन्यामीनको कुलबाट गिदोनीको छोरा अबीदान; ");
INSERT INTO npioncb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दानको कुलबाट अम्मीशद्दैको छोरा अहीएजेर; ");
INSERT INTO npioncb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेरको कुलबाट ओक्रानको छोरा पगीएल; ");
INSERT INTO npioncb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गादको कुलबाट देउएलको छोरो एल्यासाप; ");
INSERT INTO npioncb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नप्‍तालीको कुलबाट एनानको छोरा अहीरा।” ");
INSERT INTO npioncb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","यी पुरुषहरू समुदायबाट नियुक्त भएका थिए; तिनीहरू कुलका पुर्ख्यौली अगुवाहरू थिए। तिनीहरू इस्राएली वंशहरूका मुखियाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","माथि नाम उल्‍लेख गरिएका यी पुरुषहरूलाई मोशा र हारूनले लिए; ");
INSERT INTO npioncb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","र तिनीहरूले दोस्रो महिनाको पहिलो दिनमा सारा समुदायलाई एकसाथ भेला गराए। ती मानिसहरूले आफ्ना वंश र परिवारअनुसार आफ्ना पुर्ख्यौली सूची दर्ता गराए। बीस वर्ष अर्थात् त्यसभन्दा धेरै उमेर भएका मानिसहरू एक-एक गरी तिनीहरूका नामअनुसार दर्ता गराए। ");
INSERT INTO npioncb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार मोशाले सीनैको उजाडस्थानमा तिनीहरूको जनगणना गरे: ");
INSERT INTO npioncb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएलको जेठा छोरा रूबेनको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूको नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रूबेनको कुलको संख्या 46,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमियोनको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमियोन कुलको संख्या 59,300 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गादको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गाद कुलको संख्या 45,650 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदाको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदा कुलको संख्या 74,600 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्साखारको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साखारको कुलको संख्या 74,600 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलूनको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबूलून कुलको संख्या 57,400 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफका छोराहरूबाट: एफ्राइमका कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एफ्राइम कुलको 40,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्शेको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शे कुलको संख्या 32,200 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बेन्यामीनको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बेन्यामीन कुलको संख्या 35,400 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दानको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दान कुलको संख्या 62,700 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेरको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेर कुलको संख्या 41,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नप्‍तालीको कुलबाट: बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती हुनसक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार तिनीहरूका नाम एक-एक गरी दर्ता गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नप्‍ताली कुलको संख्या 53,400 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मोशा, हारून र इस्राएलका बाह्र जना अगुवाहरू हरेकले आफ्ना परिवारको प्रतिनिधित्व गरी गन्ती गरेका पुरुषहरू यिनै थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","बीस वर्ष पुगेका र त्योभन्दा धेरै उमेरका सेनामा भर्ती भई सेवा गर्न सक्ने सबै पुरुषहरूलाई तिनीहरूका वंश र परिवारअनुसार इस्राएलीहरूको गणना गरियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","तिनीहरूका जम्मा संख्या 6,03,550 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","लेवीहरूको पुर्ख्यौली कुललाई चाहिँ अरू कुलहरूसँग गनिएन। ");
INSERT INTO npioncb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","याहवेहले मोशालाई भन्‍नुभएको थियो: ");
INSERT INTO npioncb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“तैँले लेवीहरूको कुललाई गन्ती नगर्नू अर्थात् गणनामा अरू इस्राएलीहरूसँग सामेल नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","त्यसको सट्टामा लेवीहरूको कुललाई साक्षी पाटीको समागम पालको जिम्मेवारी दिनू; अर्थात् त्यसमा भएका सबै सरसामानहरू र हरेक कुराहरूमाथि जिम्मावाल नियुक्त गर्नू। तिनीहरूले समागम पाल र त्यसका सबै सरसामानहरू बोकून्; तिनीहरूले त्यसको रेखदेख गरून्, र त्यसको चारैतिर छाउनी हालेर बसून्। ");
INSERT INTO npioncb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","जब समागम पाललाई सार्नुपर्ने हुन्छ, तब लेवीहरूले त्यसलाई तल झारून्, र त्यो समागम पाल नयाँ ठाउँमा खडा गर्दा लेवीहरूले नै खडा गरून्। यदि कुनै व्यक्ति त्यसको नजिक गयो भने त्यो मारिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएलीहरूले आफ्नो दलअनुसार पाल टाँगून्। हरेकले आ-आफ्ना झण्डामुनि छाउनीहरू खडा गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","तर लेवीहरूले चाहिँ इस्राएली समुदायमाथि मेरो क्रोध नपरोस् भनेर समागम पालको साक्षी पाटीको वरिपरि आफ्ना पालहरू खडा गरून्। लेवीहरूचाहिँ समागम पालको साक्षी पाटीको हेरचाहका लागि जिम्मेवार रहनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","इस्राएलीहरूले यी सबै कुराहरू याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार सबै गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","याहवेहले मोशा र हारूनलाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएलीहरू प्रत्येकले भेट हुने पालको वरिपरि, त्यसदेखि केही दूरी राखेर तिनीहरूका पारिवारिक निसानाको झण्डामुनि आ-आफ्ना छाउनी बनाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","पूर्व दिशापट्टि, सूर्योदय हुने दिशातिर: यहूदाका कुलहरूले तिनीहरूका झण्डामुनि छाउनी बनाऊन्। अम्मीनादाबको छोरा नहशोन, यहूदा कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","उसको दलको संख्या 74,600 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","इस्साखारको कुलले यहूदाको छेउमा छाउनी बनाऊन्। सूआरको छोरा नथनिएल, इस्साखार कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","उसको दलको संख्या 54,400 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","जबूलूनका कुल इस्साखारको छेउमा बस्‍नेछ। हेलोनको छोरा एलिआब, जबूलून कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","उसको दलको संख्या 57,400 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदाको छाउनीमा तिनीहरूका दलअनुसार राखिएका पुरुषहरूको संख्या 1,86,400 हो। तिनीहरू अरू कुलहरूभन्दा पहिला जानेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","दक्षिण दिशामा: रूबेनका दलहरू आफ्ना कुलका झण्डामुनि छाउनीमा रहनेछन्। शदेऊरको छोरा एलिसूर, रूबेनका कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","उसको दलको संख्या 46,500 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","तिनीहरूपछि शिमियोनको कुलले छाउनी लगाउनेछ। सूरीशद्दैको छोरो शलूमीएल, शिमियोन कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","उसको दलको संख्या 59,300 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","त्यसपछि गादको कुल हुनेछ। देउएलका छोरा एल्यासाप, गाद कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","तिनको दलको संख्या 45,650 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रूबेनको छाउनीमा राखिएका सबै मानिसहरूका संख्या तिनीहरूका दलअनुसार 1,51,450 हो। यिनीहरू दोस्रो लहरमा हिँड्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","त्यसपछि भेट हुने पाल र लेवीहरूका छाउनी, छाउनीहरूका बीचबाट भएर जानेछन्। तिनीहरू आ-आफ्ना छाउनीमा जसरी बस्छन्, त्यही प्रकारले तिनीहरू हरेक आ-आफ्नै पङ्‌क्तिमा आ-आफ्नै झण्डामुनि हिँड्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","पश्‍चिम दिशातिर: एफ्राइमको छाउनीका दलहरू आफ्ना झण्डामुनि हुनेछन्। अम्मीहूदका छोरा एलिशामा, एफ्राइम कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","उसको दलको संख्या 40,500 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","त्यसपछि मनश्शेको कुल रहनेछ। पदासूरको छोरो गमलिएल, मनश्शे कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","उसको दलको संख्या 32,200 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","त्यसपछि बेन्यामीनको कुल रहनेछ। गिदोनीका छोरा अबीदान बेन्यामीन कुलका मानिसहरूको अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","उसको दलको संख्या 35,400 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राइमको छाउनीमा राखिएका सबै मानिसहरूको संख्या तिनीहरूका दलअनुसार 1,08,100 हो। तिनीहरूको दल तेस्रो लहरमा हिँड्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तर दिशातिर: दानको छाउनीका दलहरू आफ्ना झण्डामुनि हुनेछन्। अम्मीशद्दैका छोरा अहीएजेर, दान कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","उसको दलको संख्या 62,700 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","त्यस पछिको छाउनी आशेरको कुलको हुनेछ। ओक्रानकोका छोरा पगीएल, आशेर कुलका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","उसको दलको संख्या 41,500 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","त्यसपछि नाप्‍ताली कुलको दल हुनेछ। एनानको छोरो अहीरा, नप्‍तालीका मानिसहरूका अगुवा होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","उसको दलको संख्या 53,400 हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दानको छाउनीमा राखिएका सबै मानिसहरूका संख्या 1,57,600 हो। तिनीहरू आफ्ना झण्डामुनि सबैभन्दा पछि हिँड्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","यिनै इस्राएलीहरू तिनीहरूका परिवारअनुसार गनिएका हुन्। छाउनीहरूमा भएका सबै मानिसहरू तिनीहरूका दलअनुसार सबैको संख्या 6,03,550 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ, लेवीहरूलाई अरू इस्राएलीहरूसँग गन्ती गरिएका थिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","यसरी याहवेहले मोशालाई आज्ञा गर्नुभएझैँ इस्राएलीहरूले गरे; यसरी तिनीहरूले तिनीहरूका झण्डामुनि छाउनी हाले। अनि त्यसरी नै तिनीहरू हरेक आ-आफ्नै वंश र परिवारसँग हिँडे। ");
INSERT INTO npioncb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","याहवेह मोशासँग सीनै पर्वतमा बोल्नुभएको समयमा, मोशा र हारूनका परिवारको विवरण यही हो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारूनका चार छोराहरूका नाम: जेठा नादाब र अबीहू, त्यसपछि एलाजार र ईतामार थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","पुजारी पदका निम्ति सेवा गर्नलाई अभिषेक गरिएका पुजारी हारूनका छोराहरूका नामहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","सीनैको उजाडस्थानमा याहवेहले निषेध गर्नुभएको आगोमा उहाँको अगि भेटी चढाउँदा याहवेहको सामु नादाब र अबीहूको मृत्यु भयो। तिनीहरूका छोराहरू थिएनन्; त्यसकारण एलाजार र ईतामारले आफ्ना बुबा हारूनको जीवनकालभरि पुजारीको रूपमा सेवा गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवीको कुललाई पुजारी हारूनको अगि नियुक्त गर्, र तिनीहरूले उसलाई सहायता गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","तिनीहरूले भेट हुने पालमा समागम पालको काम गर्दै हारून र सारा समुदायका निम्ति जिम्मेवारी पूरा गर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","तिनीहरूले भेट हुने पालका सबै सरसामानहरूको रेखदेख गरून्। समागम पालको काम गर्दै इस्राएलीहरूप्रतिको दायित्व पूरा गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","लेवीका मानिसहरू हारून र उसका छोराहरूलाई सुम्पिदिनू। तिनीहरूले सम्पूर्ण इस्राएलीहरूको तर्फबाट पूर्ण रूपले हारूनलाई सुम्पनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","हारून र उसका छोराहरूलाई पुजारीको काम गर्नलाई नियुक्त गर्नू; अरू जो कोही पवित्रस्थानको नजिक जान्छ, त्यो मारिनुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","याहवेहले मोशालाई यो कुरा पनि भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“मैले इस्राएलीहरूबाट हरेक इस्राएली स्त्रीहरूको जेठा छोराहरूको सट्टामा लेवीहरूलाई लिएको छु। लेवीहरू मेरा हुन्; ");
INSERT INTO npioncb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","किनकि सबै पहिले जन्मनेहरू मेरा हुन्। जब मैले इजिप्टमा सबै जेठाहरूलाई प्रहार गरेँ, तब मैले इस्राएलका चाहे मानिसको होस् या पशुको होस्, पहिले जन्मेकाहरूलाई मेरा निम्ति अलग गरेँ। अनि तिनीहरू मेरा हुन्; म नै याहवेह हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","याहवेहले सीनैको उजाडस्थानमा मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवीहरूलाई तिनीहरूका परिवार र वंशअनुसार गन्ती गर्। एक महिना र त्यसभन्दा बढी उमेरका हरेक पुरुषहरूलाई गन्ती गर्।” ");
INSERT INTO npioncb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","याहवेहले वचनद्वारा आज्ञा गर्नुभएअनुसार मोशाले तिनीहरूलाई गन्ती गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवीका छोराहरूका नामहरू यिनै थिए: गेर्शोन, कहात र मरारी। ");
INSERT INTO npioncb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेर्शोनको वंशका नामहरू यिनै थिए: लिब्नी र शिमी। ");
INSERT INTO npioncb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहातको वंशकाहरू: अम्राम, यिसहार, हेब्रोन र उज्जीएल। ");
INSERT INTO npioncb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारीको वंशकाहरू: महली र मूशी। ");
INSERT INTO npioncb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेर्शोनीबाट लिब्नी र शिमीहरूका वंश; गेर्शोनका वंशहरू यिनै थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","एक महिना र त्यसभन्दा बढी उमेरका गन्ती गरिएका सबै पुरुषहरूको संख्या 7,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्शोनी वंशकाहरूले पश्‍चिमपट्टि समागम पालको पछिल्तिर छाउनी लगाउनुपर्ने थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","लाएलको छोरो एल्यासाप गेर्शोनीका परिवारहरूका अगुवा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","गेर्शोनीहरूको जिम्मेवारी, भेट हुने पालमा समागम पाल र पालका आवरणहरू, भेट हुने पालको प्रवेशद्वारमा भएका पर्दाहरूको रेखदेख गर्नेथियो; ");
INSERT INTO npioncb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","चोकका पर्दाहरू, समागम पाल, वेदी र चोकको चारैतिरका प्रवेशद्वारमा भएका पर्दाहरू र डोरीहरू, अर्थात् तिनीहरूमा प्रयोग हुने हरेक कुराहरूका हेरचाह गर्ने जिम्मेवारी थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","कहात वंशकाहरू, अम्रामी यिसहारी, हेब्रोनी र उज्जीएलीहरू थिए; यिनीहरू कहाती वंशका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","एक महिना र त्यसभन्दा बढी उमेरका सबै पुरुषहरूको संख्या 8,600 थियो। कहातीहरू पवित्रस्थानको हेरचाह गर्ने जिम्मेवार व्यक्तिहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहाती वंशकाहरूले समागम पालको दक्षिणपट्टि छाउनी लगाउनुपर्ने थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","उज्जीएलको छोरो एलीशापान, कहातीका परिवारहरूका अगुवा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","तिनीहरू पवित्रस्थानमा सेवा गर्दा चलाउने सामानहरू; सन्दुक, टेबुल, पानस, वेदीहरू, पर्दा र अरू प्रयोग गरिने हरेक कुराहरूका हेरचाह गर्ने जिम्मेवार व्यक्तिहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","लेवीहरूका प्रमुख अगुवा पुजारी हारूनका छोरा एलाजार थिए। तिनी पवित्रस्थानको हेरचाह गर्नेहरूमाथि अगुवा नियुक्त भएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मरारीबाट महली र मूशीका वंशहरू थिए; यिनीहरू मरारी वंशका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","एक महिना र त्यसभन्दा बढी उमेरका गन्ती गरिएका सबै पुरुषहरूको संख्या 6,200 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","अबीहेलका छोरा सूरीएल मरारीका परिवारहरूका अगुवा थिए। तिनीहरूले समागम पालको उत्तरपट्टि छाउनी लगाउनुपर्ने थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","यी मरारीहरू समागम पालका चौकसहरू, त्यसका बारहरू, खाँबाहरू, आधारहरू, त्यसका सबै सरसामानहरू र त्यसमा प्रयोगमा आउने हरेक कुराहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","साथसाथै चोकका चारैतिरका खम्बाहरू, तिनीहरूका आधारहरूसँग पालका किलाहरू र डोरीहरूको हेरचाह गर्न नियुक्त भएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मोशा, हारून र तिनका छोराहरूले चाहिँ समागम पालको पूर्वपट्टि सूर्योदयतिर भेट हुने पालको सामु छाउनी लगाउनुपर्ने थियो। तिनीहरू इस्राएलीहरूको तर्फबाट पवित्रस्थानको हेरचाह गर्ने जिम्मेवार व्यक्तिहरू थिए। पवित्र वासस्थानको नजिक, जो कोही जान्थ्यो, त्यो व्यक्ति मारिनुपर्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","याहवेहको आज्ञाअनुसार मोशा र हारूनले गन्ती गरेका लेवीहरू, तिनीहरूका वंशअनुसार एक महिना र त्यसभन्दा बढी उमेरका हरेक पुरुषहरूको संख्या 22,000 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","याहवेहले मोशालाई भन्‍नुभयो, “एक महिना र त्यसभन्दा बढी उमेरका इस्राएलीहरूका सबै पहिले जन्मेका पुरुषहरूलाई गनेर तिनीहरूका नामको सूची बनाऊनू। ");
INSERT INTO npioncb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","इस्राएलीहरूका पहिले जन्मेकाहरूको सट्टा लेवीहरूलाई र इस्राएलीहरूका पहिले जन्मेका गाईबस्तुको सट्टा लेवीहरूका गाईबस्तुलाई मेरा निम्ति लिनू; म नै याहवेह हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","यसकारण याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार इस्राएलीहरूका सबै जेठा छोराहरूको गन्ती गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","एक महिना र त्यसभन्दा बढी उमेरका जेठा पुरुषहरूको नामअनुसार दर्ता गरिएकाहरूको संख्या 22,273 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","याहवेहले मोशालाई यो पनि भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएलीहरूका सबै जेठाहरूको सट्टामा लेवीहरूलाई र तिनीहरूका गाईबस्तुको सट्टामा लेवीहरूका गाईबस्तुहरूलाई ल्याऊनू। लेवीहरू मेरा होऊन्; म नै याहवेह हुँ। ");
INSERT INTO npioncb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","लेवीहरूको संख्याभन्दा बढी भएका 273 जना इस्राएलीहरूका जेठा छोराहरूका छुटकाराका निम्ति, ");
INSERT INTO npioncb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","प्रत्येक जेठो छोराका निम्ति पाँच शेकेल मूल्य लिनू, अर्थात् पवित्रस्थानको शेकेलबमोजिम बीस गेरा अथवा एक शेकेल बराबर बीस गेरा हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","अनि थप गरिएका इस्राएलीहरूका छुटकाराको मोलचाहिँ तैँले हारून र त्यसका छोराहरूलाई दिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","यसकारण मोशाले लेवीहरूद्वारा छुटकारा पाएका इस्राएलीहरूको संख्याभन्दा धेरै भएका जेठाहरूको छुटकाराको मूल्य जम्मा गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","इस्राएलीहरूका जेठा छोराहरूबाट तिनले पवित्रस्थानको शेकेलबमोजिम 1,365 शेकेल ओजनको चाँदी बटुले। ");
INSERT INTO npioncb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","मोशाले याहवेहको वचनअनुसार त्यो छुटकाराको मूल्य तिनलाई आज्ञा गर्नुभएझैँ गरी हारून र तिनका छोराहरूलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","याहवेहले मोशा र हारूनलाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवीहरूमा कहातीहरूको घरानाबाट तिनीहरूका वंश र परिवारअनुसार गन्ती गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","भेट हुने पालमा सेवा गर्न आउने तीस वर्षदेखि पचास वर्षसम्मका पुरुषहरू सबैलाई गन्ती गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","भेट हुने पालमा कहातीहरूले गर्नुपर्ने काम यही हो: महा-पवित्र चीजहरूको हेरचाह गर्नुपर्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","जब छाउनी सार्नुपर्ने हुन्छ, तब हारून र उसका छोराहरू भित्र गएर छेक्ने पर्दा तल झारून् र साक्षी पाटीको सन्दुकलाई ढाकून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","त्यसपछि तिनीहरूले पर्दालाई नरम छालाले ढाकेर त्यसमाथि पूरै निलो लुगा फिँजाइदेऊन्, र त्यसका डण्डाहरू ठिक ठाउँमा राखिदेऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","उपस्थितिको रोटीको टेबुलमाथि तिनीहरूले निलो लुगा ओछ्याएर त्यसमाथि थालहरू, भाँडाहरू, बाटाहरू र अर्घबलिका कचौराहरू राखून्; सधैँ रहिरहनुपर्ने रोटी त्यहाँ टेबुलमाथि हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","टेबुलमा भएका कुराहरूमाथि तिनीहरूले एउटा रातो रङ्गको कपडा ओछ्याऊन्, र त्यसलाई नरम छालाले ढाकेर त्यसका डण्डाहरू ठिक ठाउँमा राखिदेऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","तिनीहरूले एउटा निलो लुगा लिएर उज्यालोका निम्ति राखिएको पानसलाई त्यसका बत्तीहरूसँग, त्यसका सलेदो काट्ने चिम्टाहरू, मोसोदानी र जैतुनको तेलका भाँडाहरूसमेत छोपेर राखून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","त्यसपछि तिनीहरूले त्यसका सरसामानहरूलाई नरम छालाले बेह्रेर बोक्ने डण्डामाथि राखून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","सुनको वेदीमाथि तिनीहरूले एउटा निलो कपडा फिँजाएर त्यसलाई नरम छालाले छोपिदेऊन् र त्यसका डण्डाहरूलाई ठिक ठाउँमा राखिदेऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","तिनीहरूले पवित्र वासस्थानमा सेवा गर्दा प्रयोग गरिने सबै सामानहरू लिएर र निलो रङ्गको कपडाले बेह्रेर नरम छालाले छोपेर तिनीहरूलाई बोक्ने डण्डामा राखून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","तिनीहरूले काँसोको वेदीबाट खरानी निकालून्, र त्यसमाथि एउटा बैजनी कपडा ओछ्याऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","त्यसपछि तिनीहरूले बैजनी कपडामाथि वेदीमा सेवा गर्दा प्रयोग गरिने सबै भाँडाहरूका साथमा तावाहरू, मासु तान्‍ने काँटाहरू, बेल्चाहरू र पानी छर्कने बाटाहरू राखिदेऊन्। त्यसमाथि तिनीहरूले नरम छालाले ढाकेर छोपून् र बोक्ने डण्डाहरू ठिक ठाउँमा राखून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","हारून र त्यसका छोराहरूले पवित्र सरसामानहरू र सबै पवित्र चीजहरूलाई छोपिसकेपछि, जब छाउनी अगि सार्न तयार हुन्छ, तब ती बोक्नलाई कहातीहरू मात्र आऊन् र बोकून्। तर तिनीहरूले पवित्र कुराहरूलाई नछोऊन्, नत्रता तिनीहरू मर्नेछन्। कहातीहरूले मात्र भेट हुने पालमा भएका सबै कुराहरू बोकून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“पुजारी हारूनको छोरा एलाजारको जिम्मामा बत्तीको निम्ति तेल, सुगन्धित धूप, नियमित अन्‍नबलि र अभिषेकको तेल रहनेछ। सम्पूर्ण समागम पाल र त्यसमा भएका हरेक कुराहरूसहित, यसका पवित्र सरसामानहरू र चीजहरू उसको जिम्मामा रहनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“कहातीका कुलहरूलाई लेवीका वंशहरूबाट नाश हुन नदेओ। ");
INSERT INTO npioncb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","तिनीहरू महा-पवित्र कुराहरूको नजिक आउँदा नमरून्, तर जीवित रहून्; त्यसैले तिनीहरूका निम्ति यो कुरा गर्नुपर्छ: हारून र त्यसका छोराहरू पवित्रस्थानभित्र जाऊन्, र प्रत्येक मानिसलाई त्यसको काम र त्यसले के बोक्नुपर्छ, त्यो जिम्मेवारी सुम्पिदेऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","तर कहातीहरू पवित्र कुराहरू हेर्नका लागि एकैछिनको निम्ति भए तापनि भित्र नजाऊन्, नत्रता तिनीहरू मर्नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेर्शोनीहरूको पनि तिनीहरूका परिवार र वंशअनुसार जनगणना गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","भेट हुने पालमा सेवाको काम गर्न आउने, तीस वर्षदेखि पचास वर्षसम्म उमेर पुगेकाहरू सबै मानिसहरूका गन्ती गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","गेर्शोनी वंशकाहरूले बोक्नुपर्ने र अरू गर्नुपर्ने सेवा यही हो: ");
INSERT INTO npioncb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","“तिनीहरूले समागम पालका पर्दाहरू, भेट हुने पाल, त्यसको छोप्ने र त्यसको बाहिरी ढाक्ने नरम छाला, भेट हुने पालको प्रवेशद्वारका पर्दाहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","समागम पाल र वेदीका चारैतिरका चोकका पर्दाहरू, चोकको ढोकाको पर्दा, डोरीहरू र पालको सेवामा प्रयोग गरिने सबै सरसामानहरू बोकून्। यी सबै कुराहरूबाट हुनुपर्ने सबै सेवाका कामहरू गेर्शोनीहरूले गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","तिनीहरूका सबै सेवाहरू, चाहे बोक्ने काम, अर्थात् गर्नुपर्ने अरू कामहरू हारून र त्यसका छोराहरूको निर्देशनमा गेर्शोनीहरूले गर्नुपर्छ। तैँले तिनीहरूले बोक्ने सबै कुराहरू तिनीहरूको जिम्मामा लगाइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","भेट हुने पालमा गेर्शोनी वंशकाहरूले गर्नुपर्ने सेवा यही हो। तिनीहरूका कर्तव्यहरू पुजारी हारूनको छोरा ईतामारको निर्देशनमा होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“मरारीहरूलाई तिनीहरूका वंश र परिवारअनुसार गन्ती गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","भेट हुने पालमा सेवा गर्न आउने तीस वर्षदेखि पचास वर्षसम्म उमेर भएका सबै मानिसहरूको गन्ती गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","भेट हुने पालमा तिनीहरूको कर्तव्य यही हो: तिनीहरूले समागम पालका चौकसहरू, त्यसका कोठे बारहरू, खम्बाहरू र आधारहरू बोकून्; ");
INSERT INTO npioncb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","अनि चोकका चारैतिरका खम्बाहरू त्यसका आधारहरूका साथमा, पालका किलाहरू, डोरीहरू, सबै सामानहरू र त्यसमा प्रयोग गरिने सबै कुराहरू बोकून्। हरेक मानिसलाई उनीहरूले बोक्नुपर्ने कुराहरू तोकिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","मरारी वंशकाहरूले भेट हुने पालमा हारून पुजारीको छोरा ईतामारको निर्देशनमा सेवा गर्दा गर्नुपर्ने जिम्मेवारी यही हो।” ");
INSERT INTO npioncb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोशा, हारून र समुदायका अगुवाहरूले कहातीहरूलाई तिनीहरूका वंश र परिवारहरूको आधारमा गन्ती गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","भेट हुने पालमा सेवा गर्न आउने तीस वर्षदेखि पचास वर्षसम्म उमेर भएका सबै मानिसहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","तिनीहरूका वंशअनुसार गनिएकाहरू 2,750 थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","भेट हुने पालमा सेवा गर्ने कहाती वंशहरूको जम्मा संख्या यही थियो। याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार मोशा र हारूनले तिनीहरूका गन्ती गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेर्शोनीहरू, तिनीहरूका वंश र परिवारअनुसार गनिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","भेट हुने पालको कामका निम्ति सेवा गर्न आएकाहरू, जो तीस वर्षदेखि पचास वर्ष उमेर भएका सबै मानिसहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","तिनका वंश र परिवारअनुसार गनिएकाहरू 2,630 थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","भेट हुने पालको काममा सेवा गर्ने सबै गेर्शोनीहरूका परिवारको पूरा संख्या यही थियो। याहवेहको आज्ञाअनुसार मोशा र हारूनले तिनीहरूलाई गनेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारीहरू तिनीहरूका वंश र परिवारअनुसार गनिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","भेट हुने पालको काममा सेवा गर्न आउने तीस वर्षदेखि पचास वर्ष उमेरका सबै मानिसहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","तिनीहरूका वंशअनुसार गनिएकाहरू 3,200 थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","मरारी वंशकाहरूको जम्मा संख्या यही थियो। याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार मोशा र हारूनले तिनीहरूको गन्ती गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","यसरी मोशा, हारून र इस्राएलीहरूका अगुवाहरूले सबै लेवीहरूलाई वंश र परिवारअनुसार गन्ती गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","भेट हुने पाल बोक्ने र सेवाको काम गर्न आउने तीस वर्षदेखि माथि पचास वर्ष उमेरसम्मका सबै मानिसहरूका ");
INSERT INTO npioncb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","संख्या 8,580 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार हरेकलाई तिनीहरूको काम र के बोक्नुपर्ने हो, त्यो जिम्मेवारी सुम्पिदिएका थिए। यसरी याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार गन्ती गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“यदि कसैको छालाको सरुवा रोग अर्थात् कुनै किसिमको धातुको रोग छ, अर्थात् मृत शरीर छोएको कारणले विधिगत रूपमा अशुद्ध छ भने त्यो मानिसलाई छाउनीबाट बाहिर निकालिदिनू भनी इस्राएलीहरूलाई आज्ञा दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","तिनीहरू पुरुष अथवा स्त्री जोसुकै भए तापनि तिनीहरूलाई छाउनीबाट बाहिर निकालिदिनू; ताकि तिनीहरूले आफ्ना छाउनीलाई अशुद्ध नपारून्, जहाँ म बास गर्दछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","इस्राएलीहरूले त्यसै गरे। तिनीहरूलाई छाउनीबाट बाहिर निकालिदिए। याहवेहले मोशालाई निर्देशन गर्नुभएझैँ तिनीहरूले गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएलका मानिसहरूलाई भन्: याहवेहप्रतिको विश्‍वासलाई तोडेर यदि कुनै पुरुष अर्थात् स्त्रीले कसैसँग कुनै प्रकारको गलत व्यवहार गर्छ र त्यो व्यक्ति दोषी छ भने, ");
INSERT INTO npioncb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","तिनीहरूले आफूले गरेको पाप मानिलिनुपर्छ। तिनीहरूले गरेका आफ्ना अपराधको लागि पूर्ण हर्जाना तिर्नुपर्छ। त्यसमा पाँचौँ भाग थपेर त्यसले दुर्व्यवहार गरेको व्यक्तिलाई दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","तर यदि त्यसले गरेको अपराधको लागि हर्जाना दिनलाई त्यस मानिसको नजिकको कुनै नातेदार छैन भने त्यो हर्जाना याहवेहको हुनेछ। अनि त्यो हर्जानाचाहिँ त्यस दोषीको प्रायश्‍चितको निम्ति बलि चढाइने भेडासँग पुजारीलाई दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","इस्राएलीहरूले पुजारीकहाँ ल्याएका सबै पवित्र भेटीहरू पुजारीकै हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","हरेक मानिसका पवित्र थोकहरू तिनीहरूका आफ्नै हुन्। तर तिनीहरूले पुजारीलाई जे दिन्छन्, त्यो पुजारीकै हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","इस्राएलका मानिसहरूलाई भन्: “यदि कुनै मानिसकी पत्नी बरालिएर त्यसले आफ्नो पतिलाई विश्‍वासघात गरी, ");
INSERT INTO npioncb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","र यसरी त्यसले अर्को मानिससँग शारीरिक सम्बन्ध राखेर पतिसँग अविश्‍वासयोग्य भई, तर त्यसको पतिले थाहा पाएन। अनि त्यसको अशुद्धता गुप्‍तमै रहेको छ भने (त्यस स्त्रीको विरुद्धमा कुनै साक्षी छैन, र कुकर्म गर्दागर्दै रङ्गेहात पक्राऊ पनि परेको छैन भने), ");
INSERT INTO npioncb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","तर त्यसको पतिलाई डाहको भावना जागेकोले त्यसकी पत्नी अशुद्ध छ भन्‍ने शङ्का गर्‍यो भने—अर्थात् यदि त्यसले डाहको कारण त्यसकी पत्नी अशुद्ध नभए तापनि शङ्का गर्‍यो भने, ");
INSERT INTO npioncb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","त्यसले आफ्नी पत्नीलाई पुजारीकहाँ लैजाओस्। त्यसले पत्नीका निम्ति एपाको दशौँ भाग जौको मसिनो पिठोको भेटी पनि ल्याओस्। त्यसले पिठोमा जैतुनको तेल नखन्याओस् र सुगन्ध पनि नहालोस्। किनभने त्यो डाहको निम्ति अन्‍नबलि अर्थात् अधर्म सम्झना गराउने बलि हो। ");
INSERT INTO npioncb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘पुजारीले त्यस स्त्रीलाई ल्याओस् र याहवेहको सामु खडा हुन लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","त्यसपछि पुजारीले माटोको भाँडामा केही पवित्र पानी लेओस् र समागम पालको भुइँबाट केही धुलो त्यसमा हालोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","पुजारीले त्यस स्त्रीलाई याहवेहको सामु खडा गराएपछि पुजारीले स्त्रीको केश खोलिदेओस्। अनि स्त्रीको हातमा सम्झनाको भेटी अर्थात् डाहको अन्‍नबलि राखिदेओस्। पुजारीले चाहिँ श्राप ल्याउने तितो पानी आफैँले हातमा लेओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","त्यसपछि पुजारीले त्यस स्त्रीलाई शपथ खान लगाओस् र स्त्रीलाई भनोस्, “यदि अरू कुनै मानिस तँसित सुतेको छैन; र तेरो विवाह तेरो पतिसित भएपछि तँ बरालिएर अशुद्ध भएकी छैनस् भने श्राप ल्याउने यस तितो पानीले तँलाई हानि नगरोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","तर यदि तैँले आफ्नो पतिसित विवाह भएपछि तँ बरालिएर आफ्नो पतिबाहेक अर्को मानिससँग यौन सम्बन्ध राखेर तैँले आफूलाई अशुद्ध पारेकी छस् भने”, ");
INSERT INTO npioncb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","पुजारीले त्यस स्त्रीलाई यसरी श्रापको शपथ खुवाओस्, “याहवेहले तेरो कोख बाँझो गराएर र तेरो पेट फुल्न दिएर उहाँले तँलाई तेरा मानिसहरूका बीचमा सरापको कारण तुल्याऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","श्राप ल्याउने यो पानी तेरो शरीरभित्र पसोस् र तेरो पेट सुनियोस्; अनि तेरो कोख बाँझो होस्।” “ ‘त्यसपछि त्यस स्त्रीले, “आमेन, यस्तै होस्” भनोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘पुजारीले यी श्रापहरू एउटा चर्मपत्रमा लेखेर त्यस तितो पानीमा त्यसलाई पखालिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","पुजारीले श्राप ल्याउने त्यो पानी त्यस स्त्रीलाई पिउन देओस्। यदि त्यो दोषी भएमा त्यस पानी त्यसभित्र पसेर कठोर पीडा दिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","पुजारीले स्त्रीको हातबाट डाहको अन्‍नबलि लिएर त्यसलाई याहवेहको सामु उचालोस् र त्यो वेदीमा ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","त्यसपछि पुजारीले त्यस अन्‍नबलिबाट एक मुठी अन्‍न सम्झनाको भेटीको रूपमा लिएर त्यसलाई वेदीमा जलाओस्। त्यसपछि पुजारीले त्यस स्त्रीलाई त्यो पानी पिउन लगाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","यदि त्यस स्त्रीले आफ्नो पतिप्रति विश्‍वासयोग्य नभई आफूलाई अशुद्ध पारेकी छे भने यस्तो परिणाम ल्याउनेछ: जब त्यस स्त्रीलाई श्राप ल्याउने त्यो पानी पिउन दिइन्छ, तब पानी त्यसभित्र पसेर तितो भई कठोर पीडा ल्याउनेछ। त्यसको पेट सुनिनेछ र त्यसको कोख बाँझो हुनेछ। अनि त्यो आफ्ना मानिसहरूका बीचमा श्राप लागेको हुनेछे। ");
INSERT INTO npioncb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","तर यदि त्यसले आफूलाई अशुद्ध पारेकी छैन र शुद्ध छे भने त्यो आफ्नो दोषबाट मुक्त भएर छोराछोरीहरू जन्माउन सक्ने हुनेछे। ");
INSERT INTO npioncb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘यसकारण जब कुनै स्त्रीले आफ्नो पतिसित विवाह भइसकेपछि बरालिएर आफूलाई अशुद्ध पार्छे भने डाहको नियम यही हो, ");
INSERT INTO npioncb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","अर्थात् जब कुनै मानिसमा आफ्नी पत्नीप्रति शङ्का गरेर डाहको भावना आउँछ भने डाहको नियम यही हो। पुजारीले त्यस स्त्रीलाई याहवेहको सामु खडा गराउनुपर्छ। अनि त्यस स्त्रीमाथि यो सम्पूर्ण नियम लागू गरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","तब त्यस मानिसलाई केही दोष लाग्नेछैन, तर त्यो स्त्रीले चाहिँ आफ्नो अधर्मको दण्ड भोग्नेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इस्राएली मानिसहरूलाई यसो भन्: ‘यदि कुनै पुरुष वा स्त्रीले विशेष भाकल गर्न चाहन्छ, अर्थात् आफू नाजिरीको रूपमा याहवेहका निम्ति समर्पित हुने भाकल गर्छ भने, ");
INSERT INTO npioncb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","तिनीहरूले आफूलाई दाखमद्य र अरू मद्यबाट अलग राख्नुपर्छ। अनि दाखमद्य वा कुनै मद्यबाट बनिएको सिर्का पिउनुहुँदैन। तिनीहरूले दाखमद्य पिउनुहुँदैन, अर्थात् अङ्‌गुर र किसमिस पनि खानुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","जबसम्म तिनीहरू नाजिरी रहने भाकलमा समर्पित हुन्छन्, तबसम्म तिनीहरूले दाखको बोटबाट पाइने कुनै पनि कुरा, अर्थात् अङ्‌गुरको बीयाँ वा छिल्का केही पनि खानुहुँदैन। ");
INSERT INTO npioncb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘नाजिरी रहने भाकल गरेको अवधिभरि तिनीहरूका शिरमा छुरा प्रयोग गरिनुहुन्‍न। याहवेहका निम्ति नाजिरी रहने भाकल समाप्‍त नभएसम्म त्यो पवित्र रहोस्। तिनीहरूले आफ्नो कपाललाई बढेर लामो हुन दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘याहवेहका निम्ति नाजिरी रहने समय अवधिभरि त्यो कुनै लासको नजिक नजाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","तिनीहरूको आफ्नै बुबाआमा अथवा दाजुभाइ अथवा दिदीबहिनी मर्दासमेत तिनीहरूका कारण तिनीहरूले आफूलाई विधिगत रूपमा अशुद्ध पार्नुहुँदैन। किनकि परमेश्‍वरका निम्ति तिनीहरू नाजिरी भएको चिन्ह तिनीहरूको शिरमा हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","तिनीहरू नाजिरीको निम्ति समर्पित गरिएको समय अवधिभरिका लागि याहवेहका निम्ति पवित्र हुन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘यदि कोही मानिस नाजिरीको सामु अचानक मर्‍यो भने त्यसको समर्पणको चिन्ह कपाल हो, त्यो अशुद्ध हुन्छ। त्यसैले तिनीहरूले आफ्नो शुद्धीकरणको दिनमा अर्थात् सातौँ दिनमा आफ्नो कपाल खौरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","त्यसपछि आठौँ दिनमा चाहिँ तिनीहरूले दुई वटा ढुकुर अथवा परेवाका दुई वटा बचेराहरू पुजारीकहाँ भेट हुने पालको प्रवेशद्वारमा ल्याउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","नाजिरीले लासको नजिक गएर पाप गरेको हुनाले पुजारीले त्यस पापका निम्ति प्रायश्‍चित गर्नलाई तीबाट एउटा पाप शुद्धीकरण बलि र अर्कोचाहिँ होमबलि चढाओस्। अनि त्यही दिन तिनीहरूले आफ्नो शिरलाई फेरि याहवेहका निम्ति नाजिरी हुनलाई पवित्र पारून्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","तिनीहरूले आफूलाई याहवेहका लागि फेरि त्यही समय अवधिसम्मका लागि अर्पण गर्नुपर्छ। अनि दोषबलिका निम्ति एकवर्षे भेडा ल्याउनुपर्छ। ती बितेका दिनहरूको गन्ती हुनेछैन। किनभने तिनीहरूको नाजिरी रहेको अवधि अशुद्ध भयो। ");
INSERT INTO npioncb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘नाजिरीको लागि तिनीहरूको अलग रहने समयअवधि पूरा भएपछिको नियम यही हो। तिनीहरूलाई भेट हुने पालको प्रवेशद्वारमा ल्याउनू; ");
INSERT INTO npioncb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","र त्यहाँ तिनीहरूले याहवेहका निम्ति आफ्ना भेटीहरू ल्याऊन्: अर्थात् होमबलिका निम्ति एक वर्षको निष्खोट भेडाको पाठो, पाप शुद्धीकरण बलिका निम्ति भेडाको एकवर्षे निष्खोट पाठी, मेलबलिका निम्ति एउटा निष्खोट बोका ल्याऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","यसकासाथै तिनीहरूका अन्‍नबलिहरू, अर्घबलिहरू, मसिनो पिठो र खमिर नमिसाई बनाइएको एक डालो रोटीहरू, साथै जैतुन तेलमा मिसाएर बनाएका मसिनो पिठोको बाक्ला रोटीहरू र जैतुन तेल दलेका पातला रोटीहरू ल्याऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘तब पुजारीले याहवेहको सामु ती सबै थोकहरू प्रस्तुत गरोस्; अनि पाप शुद्धीकरण बलि र होमबलि चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","पुजारीले याहवेहका सामु अखमिरी रोटीको डालो प्रस्तुत गरोस्। अनि अन्‍नबलि र अर्घबलिको साथै मेलबलिको रूपमा भेडा बलिदान चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘त्यसपछि भेट हुने पालको प्रवेशद्वारमा नाजिरीले आफूले समर्पण गरेको आफ्नो केश खौरिनुपर्छ। तिनीहरूले केश लिएर त्यसलाई मेलबलिको मुन्तिर भएको आगोमा हालिदिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘नाजिरीले तिनीहरूको समर्पण गरिएको केश खौरिसकेपछि पुजारीले तिनीहरूको हातमा भेडाको उसिनेको काँध र डालोबाट अखमिरी नहालेको बाक्लो रोटी र पातलो रोटी दुवै राखिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","त्यसपछि पुजारीले ती थोकहरूलाई विशेष भेटीको रूपमा याहवेहको सामु उचालोस्। ती थोकहरू पवित्र छन्; र ती पुजारीका हुन्छन्। उचालिएको ह्‍याकुला र चढाइएको फिला ती पुजारीका हुन्। त्यसपछि नाजिरीले दाखमद्य पिउन सक्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘नाजिरीहरूले दिन सक्ने अरू कुराबाहेक तिनीहरूले आफूलाई याहवेहका निम्ति समर्पण गरेअनुसार, तिनीहरूले भाकल गरेको भेटीको विषयमा तिनीहरूका लागि नियम यही हो। नाजिरीको नियमअनुसार तिनीहरूले गरेको भाकल पूरा गर्नैपर्छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून र त्यसका छोराहरूलाई यसो भन्, ‘तिमीहरूले इस्राएलीहरूलाई आशीर्वाद दिँदा यसो भन्‍नू: ");
INSERT INTO npioncb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “याहवेहले तिमीहरूलाई आशिष् देऊन्, र तिमीहरूलाई रक्षा गरून्; ");
INSERT INTO npioncb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","याहवेहले आफ्नो मुहार तिमीहरूमाथि चम्काऊन्, र तिमीहरूप्रति अनुग्रही होऊन्; ");
INSERT INTO npioncb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","याहवेहले आफ्नो मुहार तिमीहरूतिर फर्काऊन्, र तिमीहरूलाई शान्ति देऊन्।” ’ ");
INSERT INTO npioncb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“यसरी तिनीहरूले मेरो नाम इस्राएलीहरूमा कायम राखून्। अनि म तिनीहरूलाई आशिष् दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जब मोशाले समागम पाल खडा गरिसिद्ध्याए, तब तिनले त्यो स्थान र त्यसमा भएका सबै सरसामानहरूलाई अभिषेक गरेर पवित्र तुल्याए। तिनले वेदी र त्यसमा भएका सबै भाँडाहरूलाई पनि अभिषेक गरेर पवित्र तुल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","त्यसपछि इस्राएलका अगुवाहरू, परिवारहरूका छानिएका कुल नायकहरूले भेटीहरू चढाए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","तिनीहरूले याहवेहको सामु आफ्ना उपहारस्वरूप छ वटा छोपिएका गाडाहरू र बाह्र वटा गोरुहरू; हरेक एक अगुवाबाट एउटा गोरु र दुई अगुवाहरूबाट एउटा गाडाको हिसाबमा ल्याए। तिनीहरूले ती सबै थोकहरू समागम पालको सामु प्रस्तुत गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ती उपहारहरूलाई भेट हुने पालको काममा प्रयोग गर्नका निम्ति तिनीहरूबाट ग्रहण गर्। ती हरेक मानिसको काममा चाहिएअनुसार लेवीहरूलाई दे।” ");
INSERT INTO npioncb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","यसकारण मोशाले ती गाडाहरू र गोरुहरू लिएर लेवीहरूलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","गेर्शोनीहरूलाई तिनीहरूको कामको खाँचोअनुसार पुजारीले दुई वटा गाडाहरू र चार वटा गोरुहरू दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","अनि मरारीहरूलाई तिनीहरूको कामको खाँचोअनुसार चार वटा गाडाहरू र आठ वटा गोरुहरू दिए। यी सबै कामहरू पुजारी हारूनको छोरा ईतामारको निर्देशनमा भए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","तर मोशाले कहातीहरूलाई केही पनि दिएनन्। किनकि तिनीहरूको जिम्मामा पवित्र कुराहरू आफ्ना काँधमा बोक्नुपर्ने थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","जब वेदीको अभिषेक गरियो, तब अगुवाहरूले तिनीहरूका भेटीहरू समर्पणताका लागि ल्याए। अनि ती भेटीहरूलाई वेदीको सामु प्रस्तुत गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","किनकि याहवेहले मोशालाई भन्‍नुभएको थियो, “वेदीको समर्पणताको निम्ति हरेक दिन एक-एक जना अगुवाले आ-आफ्नो भेटी ल्याऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","पहिलो दिन आफ्नो भेटी लिएर आउनेचाहिँ यहूदाको कुलको अम्मीनादाबको छोरा नहशोन थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","नहशोनको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौल भएको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा जैतुनको तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","धूपले भरिएको, दश शेकेल तौलको एउटा सुनको कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एक वर्षको थुमा ल्याए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","र मेलबलिको रूपमा बलिदान चढाउनलाई दुई वटा गोरु र पाँच वटा भेडा, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दोस्रो दिन इस्साखारका अगुवा सूआरका छोरा नथनिएलले आफ्ना भेटीहरू ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","नथनिएलको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको छर्कने बाटा र थाल; त्यस बाटा र थाल दुवैमा अन्‍नबलिको रूपमा जैतुनको तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","धूपले भरिएको दश शेकेल तौलको एउटा सुनको कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा ल्याए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पाप शुद्धीकरण बलिका निम्ति एउटा बोका ल्याए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","र मेलबलिको रूपमा चढाउनलाई दुई वटा गोरु, पाँच वटा भेडा, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू ल्याएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तेस्रो दिन जबूलूनका मानिसहरूका अगुवा हेलोनका छोरा एलिआबले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","एलिआबको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","धूपले भरिएको, दश शेकेल तौलको एउटा सुनको कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","र मेलबलि चढाउनका निम्ति दुई वटा गोरु, पाँच वटा भेडा, पाँच वटा बोकाहरू, पाँच वटा एकवर्षे थुमाहरू ल्याएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथो दिन रूबेनका मानिसहरूका अगुवा, शदेऊरका छोरा एलिसूरले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","एलिसूरको भेटी यही थियो: अर्थात् पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","धूपले भरिएको, दश शेकेल तौलको एउटा सुनको कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","र मेलबलि चढाउनका निम्ति दुई वटा गोरु, पाँच वटा भेडा, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू ल्याएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पाँचौँ दिन शिमियोनका मानिसहरूका अगुवा सूरीशद्दैका छोरो शलूमीएलले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","शलूमीएलको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","र मेलबलि चढाउनका निम्ति दुई वटा गोरु, पाँच वटा भेडा, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","छैटौँ दिन गादका मानिसहरूका अगुवा देउएलका छोरा एल्यासापले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","एल्यासापको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","र मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातौँ दिन एफ्राइमका मानिसहरूका अगुवा अम्मीहूदका छोरा एलिशामाले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","एलिशामाको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","र मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठौँ दिन मनश्शेका मानिसहरूका अगुवा पदासूरका छोरा गमलिएलले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","तिनको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा जैतुनको तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","र मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नवौँ दिन बेन्यामीनका मानिसहरूका अगुवा गिदोनीका छोरा अबीदानले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","अबीदानको भेटी यही थियो: अर्थात् पवित्रस्थानको शेकेलको तौलअनुसार एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","र मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दशौँ दिन दानका मानिसहरूका अगुवा अम्मीशद्दैका छोरा अहीएजेरले आफ्नो भेटी लिएर आए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","अहीएजेरको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार, एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","अनि मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","एघाह्रौ दिन आशेरका मानिसहरूका अगुवा ओक्रानका छोरा पगीएलले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","पगीएलको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार, एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएका थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","धूपले भरिएको दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","र मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बाह्रौँ दिनमा नप्‍तालीका मानिसहरूका अगुवा एनानका छोरा अहीराले आफ्नो भेटी ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","अहीराको भेटी यही थियो: पवित्रस्थानको शेकेलको तौलअनुसार, एक सय तीस शेकेल तौलको चाँदीको एउटा थाल र सत्तरी शेकेल तौलको चाँदीको एउटा छर्कने बाटा; त्यस थाल र बाटा दुवैमा अन्‍नबलिको रूपमा तेल मिसाएको मसिनो पिठोले भरिएकाको थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","धूपले भरिएको, दश शेकेल तौलको सुनको एउटा कचौरा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होमबलिका निम्ति एउटा बहर, एउटा भेडा र एउटा एकवर्षे थुमा; ");
INSERT INTO npioncb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पाप शुद्धीकरण बलिका निम्ति एउटा बोका; ");
INSERT INTO npioncb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","र मेलबलि चढाउनका निम्ति दुई वटा गोरुहरू, पाँच वटा भेडाहरू, पाँच वटा बोकाहरू र पाँच वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","वेदीको अभिषेक हुँदा इस्राएली अगुवाहरूको समर्पणको भेटी यही थियो: चाँदीका बाह्र वटा थालहरू, चाँदीका बाह्र वटा छर्कने बाटाहरू र सुनका बाह्र वटा कचौराहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","पवित्रस्थानको तौलको शेकेलअनुसार, चाँदीको प्रत्येक थालको तौल एक सय तीस शेकेल र चाँदीका प्रत्येक छर्कने बाटाको तौल सत्तरी शेकेल थियो। चाँदीका थाल-बाटाहरूको जम्मा तौल पवित्रस्थानको शेकेलअनुसार, दुई हजार चार सय शेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","धूपले भरिएका सुनका बाह्र वटा कचौराहरूको तौल पवित्रस्थानको तौलको शेकेलअनुसार प्रत्येक दश शेकेल थियो। सुनका कचौराहरूको जम्मा तौल एक सय बीस शेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होमबलिका निम्ति ल्याइएका पशुहरूको जम्मा संख्या, बाह्र वटा बहरहरू, बाह्र वटा भेडाहरू, बाह्र वटा एकवर्षे थुमाहरू थिए; जसको साथमा तिनीहरूको अन्‍नबलि पनि थियो। पाप शुद्धीकरण बलिका निम्ति बाह्र वटा बोकाहरू प्रयोग गरिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","मेलबलिका निम्ति चढाइएका पशुहरूको जम्मा संख्या, चौबीस वटा गोरुहरू, साठी वटा भेडाहरू, साठी वटा बोकाहरू र साठी वटा एकवर्षे थुमाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","जब मोशा याहवेहसँग कुरा गर्न भेट हुने पालभित्र पसे, तब तिनले साक्षी पाटीको सन्दुकमा भएको पाप समाधान-स्थानमाथि भएका दुई करूबहरूका बीचबाट तिनीसँग बोलिरहेको आवाज सुने। यसरी याहवेह मोशासँग बोल्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारूनलाई भन्, ‘जब तैँले सात वटा बत्तीहरू बाल्नलाई तयार गर्छस्, ती सातै वटा बत्तीहरूले सामदानको अगिल्तिरको ठाउँमा प्रकाश देऊन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","अनि हारूनले त्यसै गरे। याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार सामदानको अगिल्तिर प्रकाश दिने गरी तिनले बत्तीहरू तयार गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","सामदान यसरी बनिएको थियो: त्यसको फेददेखि फूलहरूसम्म पिटिएको सुनले बनिएको थियो। त्यो सामदान याहवेहले मोशालाई देखाउनुभएको नमुनाजस्तै बनाइएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“लेवीहरूलाई अरू सबै इस्राएलीहरूबाट अलग गर्, र तिनीहरूलाई विधिपूर्वक शुद्ध पार्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","तिनीहरूलाई शुद्ध पार्नका निम्ति तैँले यसो गर्नू: तिनीहरूमाथि शुद्धीकरणको पानी छर्कनू। त्यसपछि तिनीहरूले शरीरका रौँहरू पूरा खौरिऊन्। अनि तिनीहरूका कपडाहरू धोऊन्। यसरी तिनीहरूले आफूलाई शुद्ध पार्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","तिनीहरूलाई जैतुनको तेल मिसाएको मसिनो पिठोको अन्‍नबलिसँग एउटा बहर ल्याउन लगाउनू। अनि तैँले पाप शुद्धीकरण बलिका निम्ति अर्को दोस्रो बहर लिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","लेवीहरूलाई भेट हुने पालको अगाडि ल्याउनू, र सारा इस्राएली समुदायलाई भेला पार्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","तैँले लेवीहरूलाई याहवेहको सामु ल्याउनू। अनि इस्राएलीहरूले लेवीहरूमाथि आफ्ना हात राखून्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","हारूनले लेवीहरूलाई इस्राएलीहरूको तर्फबाट विशेष भेटीको रूपमा उचालिनका लागि याहवेहको सामु प्रस्तुत गरोस्; ताकि तिनीहरू याहवेहको काम गर्नका लागि तयार होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“लेवीहरूले बहरहरूमाथि आफ्ना हात राखून्। अनि तिनीहरूको पापको प्रायश्‍चितका निम्ति एउटालाई याहवेहका निम्ति पाप शुद्धीकरण बलिको रूपमा र अर्कोलाई चाहिँ होमबलिको रूपमा प्रयोग गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","लेवीहरूलाई हारून र त्यसका छोराहरूका अगाडि उभिन लगा। अनि तिनीहरूलाई विशेष भेटीको रूपमा उचालिनका लागि याहवेहकहाँ प्रस्तुत गर्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","यसरी तैँले लेवीहरूलाई अरू इस्राएलीहरूबाट अलग पार्नू। यसरी लेवीहरू मेरा हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“तैँले लेवीहरूलाई शुद्ध गरेर तिनीहरूलाई विशेष भेटीको रूपमा उचालिनका लागि प्रस्तुत गरून्। अनि भेट हुने पालमा तिनीहरू सेवाको काम गर्न आऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","इस्राएलीहरूको तर्फबाट ती लेवीहरूलाई सम्पूर्ण रूपले मलाई दिइनुपर्छ। तिनीहरूलाई जेठाहरूका सट्टामा, अर्थात् प्रत्येक इस्राएली स्त्रीहरूको पहिलो छोराहरूका सट्टामा मैले तिनीहरूलाई लिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएलमा जन्मेको हरेक जेठो, चाहे त्यो मानिस होस् अथवा पशु, सबै मेरै हुन्। जब मैले इजिप्टमा सबै जेठाहरूमाथि प्रहार गरेँ, तब मैले तिनीहरूलाई मेरा निम्ति अलग गरेँ। ");
INSERT INTO npioncb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","अनि मैले इस्राएलका सबै जेठा छोराहरूका सट्टामा लेवीहरूलाई लिएको छु।” ");
INSERT INTO npioncb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","इस्राएलीहरू पवित्रस्थानको नजिक जाँदा तिनीहरूमाथि कुनै विपत्ति नआओस्। त्यसैले सारा इस्राएलीहरूबाट मैले लेवीहरूलाई सबै इस्राएलीहरूको तर्फबाट भेट हुने पालमा काम गर्न र तिनीहरूका निम्ति पापको प्रायश्‍चित गर्नलाई हारून र त्यसका छोराहरूलाई उपहारको रूपमा दिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","यसकारण मोशा, हारून र सारा इस्राएली समुदायले लेवीहरूलाई त्यही नै गरे, जो याहवेहले मोशालाई आज्ञा गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवीहरूले आफूलाई शुद्ध पारे, र आफ्ना लुगाहरू धोए। त्यसपछि हारूनले तिनीहरूलाई याहवेहको सामु विशेष भेटीको रूपमा उचालिनका लागि प्रस्तुत गरे। अनि तिनीहरूलाई शुद्ध पार्नलाई तिनीहरूका निम्ति प्रायश्‍चित गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","त्यसपछि हारून र तिनका छोराहरूको निर्देशनमा भेट हुने पालमा काम गर्नलाई लेवीहरू आए। इस्राएलीहरूले लेवीहरूसँग याहवेहले मोशालाई आज्ञा दिनुभएअनुसार गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लेवीहरूका लागि यो नियम लागू हुन्छ: पच्‍चीस वर्ष अर्थात् त्योभन्दा बढी उमेरका पुरुषहरूले भेट हुने पालको काममा भाग लिऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","तर पचास वर्ष पुगेपछि चाहिँ तिनीहरूले आफ्ना नियमित सेवाबाट अवकाश प्राप्‍त गरून्; र बाँकी समय काम नगरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","तिनीहरूले आफ्ना दाजुभाइहरूलाई भेट हुने पालमा तिनीहरूका काममा सहायता दिन सक्छन्। तर तिनीहरू आफैँले चाहिँ काम गर्नुहुँदैन। यसकारण तैँले लेवीहरूको उत्तरदायित्व यसरी नै जिम्मा दिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इस्राएलीहरू इजिप्टबाट निस्किआएको दोस्रो वर्षको पहिलो महिनामा याहवेह सीनैको उजाडस्थानमा मोशासँग बोल्नुभयो। उहाँले मोशालाई आज्ञा दिनुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएलीहरूलाई तोकिएको समयमा निस्तार चाड मनाउन लगाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","निस्तार चाडलाई तोकिएको समयमा अर्थात् यसै महिनाको चौधौँ दिनको साँझमा त्यसका सबै नियम र विधिअनुसार मान्‍नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","यसकारण मोशाले इस्राएलीहरूलाई निस्तार चाड मनाउन लगाए। ");
INSERT INTO npioncb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","अनि तिनीहरूले सीनैको उजाडस्थानमा पहिलो महिनाको चौधौँ दिनको साँझमा निस्तार चाड मनाए। याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार नै इस्राएलीहरूले सबै गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","तर तिनीहरूमध्ये कति मानिसले लासलाई छोए। त्यसकारण विधिपूर्वक अशुद्ध भएकाले त्यस दिन निस्तार चाड मनाउन सकेनन्। यसकारण तिनीहरू त्यही दिन मोशा र हारूनकहाँ आए। ");
INSERT INTO npioncb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","अनि तिनीहरूले मोशालाई भने, “हामीले लासलाई छोएको कारण अशुद्ध भएका छौँ; तर तोकिएको समयमा अरू इस्राएलीहरूसँग याहवेहको भेटी चढाउन हामीले किन पाउँदैनौँ?” ");
INSERT INTO npioncb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशाले तिनीहरूलाई जवाफ दिए, “मैले याहवेहबाट तिमीहरूका निम्ति आज्ञा नपाउन्जेल यहीँ पर्खिरहो।” ");
INSERT INTO npioncb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएलीहरूलाई यसो भन्: ‘तिमीहरूमध्ये कोही अथवा तिमीहरूका सन्तान लासलाई छोएको कारण अशुद्ध भयो भने अथवा टाढाको यात्रामा छन् भने पनि तिनीहरूले याहवेहको निस्तार चाड मनाउन सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","तर तिनीहरूले त्यो दोस्रो महिनाको चौधौँ दिनको साँझमा मनाऊन्। तिनीहरूले थुमासँगै अखमिरी रोटी र तिते साग खाऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","तिनीहरूले त्यसको केही अंश पनि बिहानसम्म नराखून्, अर्थात् थुमाको कुनै हड्डी नभाचून्। तिनीहरूले निस्तार चाड मनाउँदा सबै नियमहरू पालन गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","तर यदि कोही विधिपूर्वक शुद्ध छ र यात्रामा पनि गएको छैन भने त्यस मानिसले निस्तार चाड मनाएन भने, र त्यसले तोकिएको समयमा याहवेहको भेटी चढाएन भने त्यसलाई आफ्ना मानिसहरूबाट बहिष्कार गरून्। त्यसले आफ्नो पापको प्रतिफल भोग्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘तिमीहरूसँग बासोबास गर्ने विदेशीले पनि याहवेहको निस्तार चाड मनाउन चाहन्छ भने तिनीहरूले पनि सबै नियम र विधिअनुसार मनाउनुपर्छ। विदेशी होस् वा स्वदेशी, तिमीहरू सबैका निम्ति एउटै नियम लागू हुनैपर्छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","समागम पाल, साक्षी पाटीको पाल स्थापना गरेको दिन बादलले त्यसलाई ढाक्यो। साँझदेखि बिहानसम्म समागम पालमाथिको बादल आगोजस्तै देखिन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","यस्तै निरन्तर भइरह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जहिले-जहिले त्यो बादल समागम पालबाट उठ्थ्यो, तब इस्राएलीहरू प्रस्थान गर्थे। जब बादल अडिन्थ्यो, तब इस्राएलीहरूले पाल टाँग्ने गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","यसरी याहवेहको आज्ञाअनुसार इस्राएलीहरू प्रस्थान गर्थे; र उहाँकै आज्ञामा तिनीहरूले पाल टाँग्ने गर्थे। जबसम्म बादल समागम पालमाथि रहन्थ्यो, तबसम्म तिनीहरू छाउनीमै रहन्थे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","जब समागम पालमाथि बादल लामो समयसम्म रहन्थ्यो, तब इस्राएलीहरूले याहवेहको आज्ञा मान्दथे, र प्रस्थान गर्दैनथे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कहिलेकाहीँ बादल समागम पालमाथि केही दिनका लागि मात्र रहन्थ्यो। याहवेहको आज्ञामा तिनीहरूले पाल टाँग्ने गर्थे, र त्यसपछि उहाँकै आज्ञामा तिनीहरू प्रस्थान गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","कहिलेकाहीँ बादल साँझदेखि बिहानसम्म मात्र रहन्थ्यो। अनि बिहान बादल हटेपछि तिनीहरू प्रस्थान गर्थे। चाहे दिन होस् अथवा रात, जब बादल हट्थ्यो, तब तिनीहरू प्रस्थान गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","चाहे बादल दुई दिन अथवा एक महिना वा एक वर्षसम्म समागम पालमाथि रहिरहोस्, तापनि इस्राएलीहरू प्रस्थान नगरी पालमै बस्दथे। तर जब बादल हट्थ्यो, तब तिनीहरू फेरि प्रस्थान गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","याहवेहको आज्ञामा तिनीहरूले पाल टाँग्थे र याहवेहकै आज्ञामा तिनीहरू प्रस्थान गर्थे। मोशाद्वारा याहवेहले दिनुभएको आज्ञाअनुसार तिनीहरूले उहाँको आदेश पालन गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“पिटिएको चाँदीका दुई वटा तुरही बना। अनि समुदायलाई एकसाथ भेला गराउन र पालबाट प्रस्थान गराउनका लागि तिनलाई प्रयोग गर्। ");
INSERT INTO npioncb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","जब दुवै तुरही फुकिन्छन्, तब सारा इस्राएली समुदाय भेट हुने पालको प्रवेशद्वारमा तँकहाँ भेला होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","यदि एउटै मात्र तुरही फुकियो भने अगुवाहरू, अर्थात् इस्राएली कुलका अगुवाहरू तँकहाँ भेला होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","जब तुरहीको पहिलो आवाज फुकिन्छ, तब पूर्वपट्टिका छाउनीका कुलहरू प्रस्थान गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","जब तुरही दोस्रोपल्ट फुकिन्छ, दक्षिणपट्टिका छाउनीहरूमा भएकाहरू प्रस्थान गरून्। त्यो आवाजचाहिँ प्रस्थान गर्ने सङ्केत हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","समुदायलाई भेला गराउँदा फुक्ने तुरहीको आवाज, पालबाट प्रस्थान हुँदा फुक्ने तुरहीको साङ्केतिक आवाजझैँ नहोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“पुजारी हारूनका छोराहरूले तुरहीहरू फुकून्। यो तिमीहरू र तिमीहरूका भावी पुस्ताहरूका निम्ति अनन्तको विधि हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","जब तिमीहरू आफ्नै देशमा तिमीहरूमाथि अत्याचार गर्ने शत्रुसँग लडाइँ गर्न जान्छौ, तब तुरहीहरू फुक्नू। तब याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूलाई सम्झनुहुनेछ, र शत्रुहरूबाट छुटाउनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","त्यसरी नै तिमीहरूले आनन्द मनाउने समयहरूमा अर्थात् तिमीहरूका तोकिएका चाडहरूमा र औँसीका चाडहरूमा तिमीहरूका होमबलिहरू र मेलबलिहरूको समयमा पनि तिमीहरूले तुरहीहरू फुक्नू। अनि ती याहवेहको सामु तिमीहरूका सम्झनाको निम्ति हुनेछ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","इजिप्टबाट प्रस्थान गरेको दोस्रो वर्षको दोस्रो महिनाको बीसौँ दिनमा, जब साक्षी पाटीको समागम पालबाट बादल हट्यो, ");
INSERT INTO npioncb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","तब इस्राएलीहरू सीनैको मरुभूमिबाट प्रस्थान गरे। अनि पारानको मरुभूमिमा बादल नअडिएसम्म एक ठाउँदेखि अर्को ठाउँमा यात्रा गरिरहे। ");
INSERT INTO npioncb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","याहवेहले मोशाद्वारा दिनुभएको आज्ञाअनुसार तिनीहरूले यो पहिलोपल्ट यात्रा सुरु गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","यहूदाको दल आफ्नो छाउनीबाट आफ्नो झण्डा लिएर पहिले हिँडे। तिनीहरूका अगुवा अम्मीनादाबका छोरा नहशोन थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","इस्साखारको कुलको दल सूआरका छोरा नथनिएलको जिम्मामा थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","अनि जबूलूनको कुलको दल हेलोनका छोरा एलिआबको जिम्मामा थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","त्यसपछि समागम पाल उठाइयो; अनि गेर्शोनी र मरारीहरूले त्यसलाई बोकेर अगि हिँडे। ");
INSERT INTO npioncb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","त्यसपछि रूबेनको छाउनीको दल आफ्नो झण्डामुनि हिँडे। शदेऊरका छोरा एलिसूरचाहिँ यस दलका अगुवा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","शिमियोन कुलको दलको अगुवा सूरीशद्दैका छोरा शलूमीएल थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","अनि गाद कुलको दलको अगुवा, देउएलका छोरा एल्यासाप थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","त्यसपछि कहातीहरूले पवित्र चीजहरू बोकेर हिँडे। तिनीहरू आइपुग्नुभन्दा अगि समागम पाल खडा गरिसक्नुपर्ने थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","त्यसपछि एफ्राइमको छाउनीको दल आफ्नो झण्डा लिएर अगि बढे। अम्मीहूदका छोरा एलिशामा दलका अगुवा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","मनश्शे कुलको दलको अगुवा, पदासूरका छोरा गमलिएल थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","अनि बेन्यामीन कुलको दलमाथिको अगुवा गिदोनीका छोरा अबीदान थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","अन्त्यमा सबै दलहरूका पछाडि दानको कुलको दल रक्षादलको रूपमा आफ्नो झण्डा लिएर अगाडि बढे। अम्मीशद्दैका छोरा अहीएजेर यसका अगुवा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","आशेरको कुलको दलका अगुवा ओक्रानका छोरा पगीएल थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","अनि नप्‍ताली कुलको दलको अगुवा एनानका छोरा अहीएर थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","इस्राएलीहरू प्रस्थान गर्दा हिँड्नुपर्ने पङ्‌क्ति यही थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मोशाले आफ्ना मिद्यानी ससुरा रूएलका छोरा होबाबलाई भने, “हामी त्यस ठाउँमा जाँदैछौँ, जुन ‘म तिमीहरूलाई दिनेछु’ भनी याहवेहले हामीलाई भन्‍नुभएको थियो। तपाईं पनि हामीसँगै आउनुहोस्। हामी तपाईंसँग राम्रो व्यवहार गर्नेछौँ। किनकि याहवेहले इस्राएललाई असल कुराहरूका निम्ति प्रतिज्ञा गर्नुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","तब होबाबले तिनलाई भने, “होइन, म जानेछैनँ। म आफ्नै देश र आफ्नै कुटुम्बकहाँ फर्कनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","तर मोशाले होबाबलाई भने, “बिन्ती छ, दया गरी हामीलाई नछोड्नुहोस्। हामीले उजाडस्थानमा कहाँ पाल टाग्नुपर्छ भनी तपाईं जान्‍नुहुन्छ। अनि तपाईं हाम्रा निम्ति बाटो देखाउने आँखा बन्‍न सक्नुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","यदि तपाईं हामीसँग आउनुभयो भने याहवेहले हामीलाई दिनुहुने सबै असल कुराहरू तपाईंसँग बाँड्‌नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","यसरी तिनीहरू याहवेहको पर्वतबाट हिँडे। अनि तीन दिनसम्म यात्रा गरे। तिनीहरूले कहाँ रोकिनुपर्ने हो, र आराम गर्ने ठाउँ कहाँ हो, सो भेट्टाउनका निम्ति त्यस तीन दिनसम्म याहवेहको करारको सन्दुक बोक्नेहरू तिनीहरूका अगि-अगि गए। ");
INSERT INTO npioncb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","जब तिनीहरू पालबाट दिउँसो अगि बढ्थे, तब याहवेहको बादल तिनीहरूमाथि रहन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","जब करारको सन्दुक बोक्नेहरू अगि बढ्थे, तब मोशाले यसो भन्थे, “हे याहवेह, उठ्नुहोस्! तपाईंका शत्रुहरू छरपस्ट होऊन्; तपाईंका विरोधीहरू तपाईंका सामुबाट भागून्!” ");
INSERT INTO npioncb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","जब करारको सन्दुक बिसाइन्थ्यो, तब मोशाले यसो भन्थे, “हे याहवेह, इस्राएलका गन्ती गर्न नसकिने हजारौँ-हजारकहाँ फर्केर आउनुहोस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","फेरि याहवेहको कानमा पुग्ने गरी ती इस्राएली मानिसहरूले आफ्ना कष्‍टको विषयमा गनगनाउन थाले। जब उहाँले त्यो सुन्‍नुभयो, तब उहाँको क्रोध दन्क्यो। अनि तिनीहरूका बीचमा याहवेहबाट आगो दन्क्यो र छाउनीका केही बाहिरी भागहरूलाई भस्म पारिदियो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","तब मानिसहरूले मोशासित गोहार मागे। तिनले याहवेहसँग बिन्ती गरे। अनि आगो निभ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","यसकारण त्यस ठाउँलाई तबेरा भनियो। किनकि याहवेहबाटको आगो तिनीहरूका बीचमा दन्केको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","इस्राएलीहरूसँग यात्रा गरिरहेका विदेशीहरूले अरू खानेकुराको निम्ति लालसा गर्न थाले। अनि फेरि इस्राएलीहरूले विलौना गर्दै भन्‍न थाले, “यदि हामीसँग खानलाई मासु मात्र भइदिए हुन्थ्यो! ");
INSERT INTO npioncb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हामीले इजिप्टमा सित्तैँमा माछा खान्थ्यौँ। साथै काँक्रा, खरबुजा, कन्दमूल, प्याज र लसुनहरू खाएको सम्झना आउँछ। ");
INSERT INTO npioncb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","तर अब त हाम्रो भोक नै हराएको छ। हामीले यो मन्‍नबाहेक अरू केही देख्न पाएका छैनौँ!” ");
INSERT INTO npioncb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्‍नचाहिँ धनियाँको बिउजस्तो र हेर्दा गोमेदको खोटोजस्तो देखिन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","मानिसहरू त्यसलाई बटुल्न बाहिर जान्थे; र त्यसलाई जाँतोमा पिँध्थे अर्थात् ओखलीमा कुट्थे। तिनीहरूले त्यसलाई भाँडामा पकाउँथे, अथवा रोटी बनाउँथे। अनि त्यसको स्वाद जैतुनको तेलमा पकाएको खानेकुराको जस्तो हुन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","जब राति छाउनीमा शीत झर्थ्यो, तब मन्‍न पनि खस्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","मोशाले हरेक परिवारका मानिसहरू आ-आफ्नो पालको प्रवेशद्वारमा विलाप गरिरहेका सुने। याहवेह असाध्यै क्रोधित हुनुभयो, तब मोशा दुःखित भए। ");
INSERT INTO npioncb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशाले याहवेहलाई सोधे, “तपाईंले आफ्नो सेवकमाथि किन यस्तो दुःख ल्याउनुभयो? किन मैले तपाईंको दृष्‍टिमा अनुग्रह पाएको छैनँ? मैले के गरेर तपाईंलाई अप्रसन्‍न तुल्याएको छु र तपाईंले यी सबै मानिसहरूको भार ममाथि राखिदिनुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","“के मैले यी सबै मानिसहरूलाई गर्भधारण गरेको हुँ र? के मैले तिनीहरूलाई जन्माएको हुँ र? तपाईंले किन मलाई तिनीहरूका पुर्खाहरूसँग शपथ खानुभएको देशमा पुर्‍याउनलाई एउटी धाईआमाले बालकलाई बोकेझैँ, यिनीहरूलाई मेरो अँगालोमा बोक् भन्‍नुहुन्छ? ");
INSERT INTO npioncb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","मैले यी सबै मानिसहरूका निम्ति मासु कहाँबाट ल्याऊँ? यिनीहरू ‘हामीलाई मासु खान देऊ!’ भनेर मसँग बिलौना गरिरहन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","यी मानिसहरूलाई म एकलैले बोक्न सक्दिनँ। यो भार मेरा लागि अति गह्रौँ भएको छ। ");
INSERT INTO npioncb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","यदि तपाईंले मसँग यस्तै व्यवहार गर्नुहुन्छ भने कृपया बिन्ती छ, बरु मलाई मारिदिनुहोस्। यदि मैले तपाईंको दृष्‍टिमा निगाह पाएको छु भने मेरो विनाश म आफैँले हेर्न नपरोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","यो सुनेपछि याहवेहले मोशालाई भन्‍नुभयो: “तैँले इस्राएली मानिसहरूबाट अगुवाहरू र अधिकृतहरू भनी जानिएका सत्तरी जना प्रधानहरूलाई मकहाँ भेला गर्। तिनीहरू भेट हुने पालमा आऊन्, ताकि त्यहाँ तिनीहरू तँसँग खडा होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","अनि म तल ओर्लिआउनेछु, र त्यहाँ तँसँग बोल्नेछु। म तँसँग भएको आत्माको शक्ति लिएर त्यो तिनीहरूमाथि हालिदिनेछु। तिनीहरूले तँसँग भएका मानिसहरूको भार बेहोर्नेछन्, र तँ एकलैले त्यसलाई बोक्नुपर्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“मानिसहरूलाई भन्, ‘भोलि तिमीहरूले मासु खाने तयारीका निम्ति आफूलाई शुद्ध बनाउनू। तिमीहरूको यस्तो गुनासो याहवेहले सुन्‍नुभएको छ, “यदि हामीसित खानलाई मासु मात्र भइदिए त! हामीलाई इजिप्टमा अझ राम्रो थियो!” अब याहवेहले तिमीहरूलाई मासु दिनुहुनेछ, र तिमीहरूले त्यो खानेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तिमीहरूले मासु एक दिन, दुई दिन, पाँच, दश अथवा बीस दिनसम्मलाई मात्र खानेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","तर पूरा एक महिनासम्म नाक लागेर वाक्‍क भइन्जेलसम्म खान पाउनेछौ। किनकि तिमीहरूले आफ्ना बीचमा हुनुभएका याहवेहलाई इन्कार गरेका छौ, र उहाँको सामु “हामीले किन इजिप्ट छोडेर आयौँ होला?” भनी रोएका छौँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","तर मोशाले याहवेहलाई भने, “यहाँ मसँग पैदल हिँड्नेहरू छ लाख पुरुषहरू छन्। अनि तपाईं भन्‍नुहुन्छ, ‘म तिनीहरूलाई एक महिनासम्म मासु खानलाई दिनेछु!’ ");
INSERT INTO npioncb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","के तिनीहरूका लागि बगाल र बथान मारे तापनि तिनीहरूलाई पर्याप्‍त गरी पुग्ला र? के समुद्रमा भएका सबै माछा पक्रिए तापनि तिनीहरूका लागि पर्याप्‍त पुग्ला र?” ");
INSERT INTO npioncb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","याहवेहले मोशालाई जवाफ दिनुभयो, “के याहवेहको हात त्यति छोटो छ? म जे भन्छु, त्यो तिमीहरूका निम्ति साँचो हुन्छ कि हुँदैन, सो अब तैँले देख्नेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","यसकारण मोशा बाहिर गएर याहवेहले भन्‍नुभएको कुरा मानिसहरूलाई भने। मोशाले तिनीहरूका प्रधानहरूमध्ये सत्तरी जनालाई एकसाथ ल्याएर तिनीहरूलाई पालको वरिपरि उभ्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","त्यसपछि याहवेह बादलमा ओर्लिआउनुभयो, र मोशासँग बोल्नुभयो। अनि उहाँले तिनमा भएका आत्माको शक्तिबाट केही लिएर सत्तरी जना प्रधानहरूलाई दिनुभयो। जब आत्मा तिनीहरूमाथि आएर बस्‍नुभयो, तब तिनीहरूले अगमवाणी गरे। तर त्यसपछि भने तिनीहरूले फेरि कहिल्यै त्यसो गरेनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","तर पनि एल्दाद र मेदाद नाम भएका दुई जना मानिसहरूचाहिँ छाउनीमै बसेका थिए। तिनीहरू दुवैका नाम प्रधानहरूका सूचीमा थिए। तिनीहरू बाहिर पालमा गएनन्। तर पनि तिनीहरूमाथि आत्मा बस्‍नुभएको थियो। अनि तिनीहरूले छाउनीमै अगमवाणी गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","तब एक जना जवान दौडेर गयो, र मोशालाई भन्यो, “एल्दाद र मेदादले छाउनीभित्र अगमवाणी गरिरहेका छन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","नूनका छोरा यहोशू, जो युवावस्थादेखि नै मोशाका सहायक थिए, तब तिनले भने, “हे मेरा प्रभु मोशा, तिनीहरूलाई रोक्नुहोस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","तर मोशाले यहोशूलाई जवाफ दिए, “के तिमी मेरो खातिर डाही भएका छौ? याहवेहले आफ्ना आत्मा सबै मानिसहरूमाथि राखिदिनुभएको भए ती सबै अगमवक्ता भइदिए कति असल हुनेथियो!” ");
INSERT INTO npioncb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","त्यसपछि मोशा र इस्राएलका प्रधानहरू पालमा फर्के। ");
INSERT INTO npioncb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","याहवेहबाट बतास निस्केर गयो। अनि समुद्रबाट बट्टाई चराहरू धपाएर ल्यायो। ती चराहरू एक दिनको बाटोजतिको दूरीमा चारैतिर, तिनीहरूका छाउनीको वरिपरि भुइँदेखि दुई क्यूबिट माथिसम्म थुप्रिए। ");
INSERT INTO npioncb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","त्यस दिनभरि, रातभरि र भोलिपल्ट दिनभरि मानिसहरूले बाहिर गएर बट्टाई चराहरू बटुले। कसैले पनि दश ओमेर भन्दा कम्ती बटुलेनन्। त्यसपछि तिनीहरूले ती छाउनीको चारैतिर फिँजाए। ");
INSERT INTO npioncb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","तर मासु तिनीहरूका दाँतको बीचमा छँदै, मासु निल्नुभन्दा अगि नै याहवेहको क्रोध तिनीहरूमाथि दन्क्यो। अनि उहाँले तिनीहरूलाई डरलाग्दो महामारीले प्रहार गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","यसकारण त्यस ठाउँको नाम किब्रोत-हत्तावा राखियो। किनकि त्यहाँ अन्य भोजनको निम्ति अति लालच गर्नेहरूलाई गाडिएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किब्रोत-हत्तावाबाट मानिसहरू यात्रा गरेर हसेरोतमा पुगे। अनि त्यहीँ बसे। ");
INSERT INTO npioncb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मोशाले एउटी कूशी स्त्रीसित विवाह गरेको कारण त्यस कूशी स्त्रीको बारेमा मिरियम र हारूनले मोशाको विरुद्धमा बोल्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","तिनीहरूले भने, “के याहवेह मोशाद्वारा मात्र बोल्नुभएको छ र? के उहाँ हामीद्वारा पनि बोल्नुभएको छैन र?” अनि याहवेहले यो कुरा सुन्‍नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(मोशाचाहिँ अति नै नम्र मानिस थिए। पृथ्वीमा सबैभन्दा नम्र व्यक्ति थिए।) ");
INSERT INTO npioncb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","याहवेहले तुरुन्तै मोशा, हारून र मिरियमलाई भन्‍नुभयो, “तिमीहरू तीन जना बाहिर भेट हुने पालमा आओ।” यसकारण ती तीन जना बाहिर आए। ");
INSERT INTO npioncb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","त्यसपछि याहवेह बादलको खाँबोमा भएर ओर्ली आउनुभयो। उहाँ पालको प्रवेशद्वारमा उभिनुभयो। अनि उहाँले हारून र मिरियमलाई बोलाउनुभयो। जब तिनीहरू दुवै जना अगि आए, ");
INSERT INTO npioncb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","तब उहाँले तिनीहरूलाई भन्‍नुभयो, “मेरो वचन सुन: “यदि याहवेहका अगमवक्ता तिमीहरूसँग थिए भने, म आफूलाई तिनीहरूसँग दर्शनहरूमा प्रकट गर्नेथिएँ; अनि म तिनीहरूसँग सपनामा कुरा गर्नेथिएँ। ");
INSERT INTO npioncb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","तर मेरो सेवक मोशाको विषयमा यस्तो होइन; त्यो त मेरो सारा घरानामा विश्‍वासयोग्य छ। ");
INSERT INTO npioncb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","त्यससँग म आमने-सामने कुरा गर्छु, उखान-टुक्‍कामा होइन। तर स्पष्‍ट गरी बोल्दछु। त्यसले याहवेहको आकृतिलाई देख्दछ। त्यसो भए किन तिमीहरू मेरो सेवक मोशाको विरुद्धमा बोल्न डराएनौ?” ");
INSERT INTO npioncb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","याहवेहको क्रोध तिनीहरूको विरुद्धमा दन्क्यो। अनि उहाँ तिनीहरूबाट गइहाल्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","जब पालमाथिबाट बादल हट्यो, तब मिरियमलाई कुष्‍ठरोग लागेर तिनको छाला हिउँजस्तै सेतो भयो। हारून तिनीतर्फ फर्के, र तिनलाई छालाको रोग भएको देखे। ");
INSERT INTO npioncb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","अनि हारूनले मोशासँग पुकार गरे, “मेरा प्रभु, बिन्ती छ, हामीले मूर्खतापूर्वक गरेको पापको सजाय हामीलाई नदिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","यिनलाई आमाको गर्भमा नै आधा मासु कुहिएर जन्मिएको शिशुजस्तो हुन नदिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","यसकारण मोशाले पुकार गरे, “हे याहवेह परमेश्‍वर, बिन्ती छ, यिनलाई निको पारिदिनुहोस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","याहवेहले मोशालाई जवाफ दिनुभयो, “त्यसका पिताले त्यसको मुखमा थुकिदिएको मात्र भए के त्यो सात दिनसम्म कलङ्कित हुने थिइन? त्यसलाई सात दिनसम्म पालबाहिर राख्नू। त्यसपछि त्यसलाई फर्काएर ल्याउनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","यसकारण मिरियमलाई सात दिनसम्म पालदेखि बाहिर एकान्तमा एकलै राखियो। अनि तिनलाई फर्काएर नल्याएसम्म मानिसहरू अगि बढेनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","त्यसपछि मानिसहरूले हसेरोतलाई छोडे। अनि पारानको मरुभूमिमा छाउनी हालेर बसे। ");
INSERT INTO npioncb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“मैले इस्राएलीहरूलाई दिन लागेको कनान देशको बारेमा जासुसी गर्नलाई केही मानिसहरू पठा। इस्राएलीहरूका पुर्खाहरूका हरेक कुलबाट एक-एक जना अगुवा पठा।” ");
INSERT INTO npioncb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","यसकारण याहवेहको आज्ञाअनुसार मोशाले तिनीहरूलाई पारानको मरुभूमिबाट पठाए। तिनीहरू सबै जना इस्राएलीहरूका अगुवाहरू थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","तिनीहरूका नाम यिनै हुन्: रूबेनको कुलबाट जक्‍कूरका छोरा शम्मूअ; ");
INSERT INTO npioncb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमियोनको कुलबाट होरीका छोरा शापात; ");
INSERT INTO npioncb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदाको कुलबाट यपून्‍नेका छोरा कालेब; ");
INSERT INTO npioncb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साखारको कुलबाट योसेफका छोरा यिगाल; ");
INSERT INTO npioncb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राइमको कुलबाट नूनका छोरा होशे; ");
INSERT INTO npioncb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बेन्यामीनको कुलबाट रफूका छोरा पल्ती; ");
INSERT INTO npioncb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलूनको कुलबाट सोदीका छोरा गद्दीएल; ");
INSERT INTO npioncb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","योसेफको एउटा कुल अर्थात् मनश्शेको कुलबाट सूसीका छोरा गद्दी; ");
INSERT INTO npioncb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दानको कुलबाट गमल्‍लीका छोरा अम्मीएलओ; ");
INSERT INTO npioncb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेरको कुलबाट मिखाएलका छोरा सतूर; ");
INSERT INTO npioncb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नप्‍तालीको कुलबाट वोप्सीका छोरा नहबी; ");
INSERT INTO npioncb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गादको कुलबाट माकीकका छोरा गूएल। ");
INSERT INTO npioncb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मोशाले कनान देशको जासुस गर्न पठाएका मानिसहरूका नाम यिनै हुन्। (मोशाले नूनका छोरा होशियालाई यहोशू नाम दिए।) ");
INSERT INTO npioncb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","मोशाले तिनीहरूलाई कनान देशको बारेमा जासुस गर्न पठाउँदा तिनीहरूलाई भने, “दक्षिणतिर हुँदै अगि बढेर पहाडी मुलुकमा जानू। ");
INSERT INTO npioncb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","त्यो देश कस्तो रहेछ, र त्यहाँ बस्‍ने मानिसहरू बलिया छन् कि कमजोर; थोरै छन् कि धेरै छन्, हेर। ");
INSERT INTO npioncb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","तिनीहरू बस्‍ने देश कस्तो प्रकारको छ? त्यो असल छ कि खराब छ? तिनीहरू बसेका सहरहरू कस्ता प्रकारका छन्? ती पर्खालविनाका छन् कि बलियो किल्‍ला भएका छन्, हेर। ");
INSERT INTO npioncb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","त्यो देशको माटो कस्तो छ? त्यहाँको माटो मलिलो छ कि रुखो छ? त्यहाँ रूखपातहरू छन् कि छैनन्? तिमीहरूले त्यस देशका केही फलफूलहरू ल्याउनलाई सक्दो कोसिस गर।” (त्यो समयचाहिँ अङ्‌गुरको पहिलो फसलको समय थियो।) ");
INSERT INTO npioncb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","यसकारण तिनीहरू उक्लेर गए। अनि जीनको मरुभूमिबाट लेबो हमाततिरको रहोबसम्म त्यस देशको बारेमा जाजुसी गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","तिनीहरू दक्षिणतिर हुँदैगए। अनि अनाकीहरूका सन्तानहरू; अहीमन, शेशै र तल्मै बस्‍ने ठाउँ हेब्रोनमा आइपुगे। (हेब्रोनचाहिँ इजिप्टमा भएको सोअनभन्दा सात वर्ष अगाडि निर्माण गरिएको थियो।) ");
INSERT INTO npioncb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","जब तिनीहरू एश्कोलको बेँसीमा आइपुगे। अनि तिनीहरूले अङ्‌गुरको एउटा मात्र झुप्पा भएको एउटा हाँगा काटे। तिनीहरूमध्ये दुई जनाले त्यसलाई एउटा घोचामा झुन्ड्याएर बोके। साथै, तिनीहरूले केही अनार र नेभाराका फलहरू पनि ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","इस्राएलीहरूले अङ्‌गुरको झुप्पा काटेको कारण त्यस ठाउँलाई एश्कोलको बेँसी भनिन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालीस दिनको अन्त्यमा तिनीहरू त्यस कनान देशको बारेमा जाजुसी गरेर फर्के। ");
INSERT INTO npioncb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","कनान देशको भेद लिन गएकाहरू पारानको मरुभूमिमा भएको कादेशमा मोशा, हारून र इस्राएलीहरूका सारा समुदायकहाँ फर्केर आए। त्यहाँ तिनीहरूले सारा समुदायलाई सम्पूर्ण कुरा बताए। अनि तिनीहरूलाई त्यस देशका फलफूल देखाए। ");
INSERT INTO npioncb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","तिनीहरूले मोशालाई यसरी वर्णन गरे: “तपाईंले हामीलाई पठाउनुभएको देशमा हामी गयौँ। साँच्‍चै त्यो देशमा दूध र मह बग्दो रहेछ! त्यहाँको फल यही हो। ");
INSERT INTO npioncb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","तर त्यस देशमा बस्‍ने मानिसहरू शक्तिशाली छन्। तिनीहरूका सहरहरू धेरै ठूला र पर्खालले घेरिएका छन्। त्यसबाहेक हामीले त्यहाँ अनाकका सन्तति पनि देख्यौँ। ");
INSERT INTO npioncb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","अमालेकीहरू दक्षिणमा बस्दा रहेछन्। हित्तीहरू, यबूसीहरू र एमोरीहरूचाहिँ पहाडी मुलुकमा बस्दा रहेछन्। कनानीहरूचाहिँ समुद्रको नजिक र यर्दन नदीको किनारहुँदो बस्दा रहेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","त्यसपछि कालेबले मोशाको सामु मानिसहरूलाई शान्त गराएर भने, “हामी त्यो देशमा जानुपर्छ, र त्यस देशमाथि अधिकार गर्नुपर्छ। किनकि हामीले निश्‍चय नै विजय हासिल गर्न सक्छौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","तर तिनीसित जासुस गर्न जाने मानिसहरूले भने, “हामीले ती मानिसहरूलाई आक्रमण गर्न सक्दैनौँ; किनकि तिनीहरू हामीहरूभन्दा बलिया छन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","तिनीहरूले जासुसी गरी आएको देशको बारेमा इस्राएलीहरूका बीचमा नकारात्मक कुराहरू फैलाए। तिनीहरूले भने, “हामीले जासुसी गरेर आएको देशले आफ्नै बासिन्दाहरूलाई निल्दोरहेछ। हामीले त्यहाँ देखेका सबै मानिसहरू ठूला-ठूला कदका छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हामीले त्यहाँ नेफिलीमहरूलाई देख्यौँ (अनाकका सन्ततिहरू नेफिलीमहरूबाट आएका हुन्)। हामी आफ्नै दृष्‍टिमा फट्याङ्ग्राझैँ देखिन्थ्यौँ। अनि तिनीहरूले पनि पक्‍कै हामीलाई त्यस्तै ठान्छन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","त्यस रात इस्राएली समुदायका सबै मानिसहरू ठूलो सोरमा कराउँदै जोरसँग रोए। ");
INSERT INTO npioncb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","सबै इस्राएलीहरूले मोशा र हारूनको विरुद्धमा गनगन गर्न थाले। अनि सारा समुदायले तिनीहरूलाई भने, “यदि हामी इजिप्टमै मरेका भए अथवा यही उजाडस्थानमै मरेका भए बरु असल हुनेथियो!” ");
INSERT INTO npioncb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","याहवेहले हामीलाई किन यस देशमा तरवारद्वारा मारिनका निम्ति ल्याउँदै हुनुहुन्छ? हाम्रा पत्नीहरू र बालबच्‍चाहरू लुटको मालजस्तै लगिनेछन्। के हामीलाई इजिप्टमै फर्किजानु असल हुँदैन र? ");
INSERT INTO npioncb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","अनि तिनीहरूले एक-आपसमा भने, “हामी एउटा अगुवा चुनौँ, र इजिप्टमा फर्केर जाऔँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","तब मोशा र हारून त्यहाँ भेला भएका इस्राएलीहरूका सारा समुदायको अगाडि भुइँमा घोप्टो परे। ");
INSERT INTO npioncb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ती मानिसहरूसँग कनान देशको बारेमा जासुसी गर्न जाने नूनका छोरा यहोशू र यपून्‍नेका छोरा कालेबले पनि आफ्ना लुगा च्याते। ");
INSERT INTO npioncb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","अनि सारा इस्राएली समुदायलाई कालेब र यहोशूले भने, “हामीले गएर जासुसी गरेको देश अति उत्तम छ। ");
INSERT INTO npioncb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","यदि याहवेह हामीसँग प्रसन्‍न हुनुभयो भने उहाँले हामीलाई त्यो देश, दूध र मह बग्ने देशमा पुर्‍याउनुहुने छ, र त्यो देश हामीलाई दिनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","तर याहवेहको विरुद्धमा विद्रोहचाहिँ नगर। अनि त्यस देशका मानिसहरूसँग नडराओ; किनकि हामी तिनीहरूलाई सजिलै हराउनेछौँ। तिनीहरूलाई सुरक्षा दिने कोही छैन। तर हामीहरूसँग याहवेह हुनुहुन्छ। त्यसैले तिनीहरूसँग नडराओ।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","तर सारा समुदायले तिनीहरूलाई ढुङ्गाले हिर्काएर मार्ने सल्‍लाह गरे। तब याहवेहको महिमा भेट हुने पालमा सबै इस्राएलीहरूकहाँ देखा पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","याहवेहले मोशालाई भन्‍नुभयो, “यी मानिसहरूले कहिलेसम्म मेरो अनादर गरिरहन्छन्? मैले तिनीहरूको बीचमा गरेका सबै अलौकिक चिन्हहरू देखेर पनि तिनीहरूले ममाथि कहिलेसम्म विश्‍वास गर्न इन्कार गर्छन्? ");
INSERT INTO npioncb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","म तिनीहरूलाई महामारीले प्रहार गर्नेछु र नाश पार्नेछु। तर तँलाईचाहिँ तिनीहरूभन्दा महान् र शक्तिशाली जाति बनाउनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मोशाले याहवेहलाई भने, “इजिप्टियनहरूले यो कुरा सुने भने के भन्लान्? तिनीहरूका बीचबाट आफ्नो शक्तिद्वारा यिनीहरूलाई तपाईंले नै ल्याउनुभएको हो। ");
INSERT INTO npioncb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","अनि तिनीहरूले यो देशका बासिन्दाहरूलाई यो कुरा बताउनेछन्। तपाईं याहवेह यिनीहरूका बीचमा हुनुहुन्छ। तपाईं यिनीहरूसँग आमने-सामने नै देखा पर्नुभएको छ। अनि तपाईंको बादल यिनीहरूमाथि रहन्छ। अनि दिनमा बादलको खाँबो र रातमा आगोको खाँबोमा भएर तपाईं यिनीहरूका अगि-अगि जानुहुन्छ भनेर तिनीहरूले सुनिसकेका छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","यदि तपाईंले यी मानिसहरूलाई एउटै पनि जीवित नराखी नाश गर्नुभयो भने तपाईंको ख्याति सुन्‍ने जातिहरूले भन्‍नेछन्, ");
INSERT INTO npioncb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘याहवेहले शपथ खाएर दिन्छु भनी प्रतिज्ञा गर्नुभएको देशमा यी मानिसहरूलाई ल्याउन सक्नुभएन। त्यसैले उहाँले तिनीहरूलाई उजाडस्थानमा मारिदिनुभयो।’ ");
INSERT INTO npioncb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“अब तपाईंले घोषणा गर्नुभएझैँ प्रभुको शक्ति प्रदर्शन गर्नुहोस्: ");
INSERT INTO npioncb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","याहवेह रिस गर्नमा ढिलो, प्रेममा भरपूर, पाप र विद्रोह क्षमा गर्नुहुने हुनुहुन्छ। तरै पनि उहाँले दोषीलाई दण्ड नदिई छोड्नुहुन्‍न। उहाँले आमाबुबाका पापका दण्ड तिनीहरूका सन्तानहरूमाथि तेस्रो र चौथो पुस्तासम्म दिनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","तपाईंको महान् प्रेमअनुसार यिनीहरूले इजिप्ट छोडेर आएदेखि अहिलेसम्म जसरी तपाईंले क्षमा दिनुभएको छ, त्यसरी नै यी मानिसहरूका पाप क्षमा गरिदिनुहोस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","याहवेहले मोशालाई जवाफ दिनुभयो, “तेरो बिन्तीअनुसार मैले तिनीहरूलाई क्षमा दिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","तरै पनि म जीवित भएझैँ र याहवेहको महिमाले सम्पूर्ण पृथ्वी ढाकिएझैँ, ");
INSERT INTO npioncb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","मेरो महिमा अनि मैले इजिप्टमा र उजाडस्थानमा देखाएका अलौकिक चिन्हहरू देखेका छन्। र पनि मेरो आज्ञापालन नगर्ने र मलाई दशपल्टसम्म जाँच गर्ने एकै जनाले पनि ");
INSERT INTO npioncb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","अर्थात् तिनीहरूमध्ये एउटैले पनि मैले तिनीहरूका पुर्खाहरूलाई शपथ खाएर दिन्छु भनी प्रतिज्ञा गरेको देशलाई कहिल्यै देख्न पाउनेछैनन्। मलाई अनादर गर्ने कुनै पनि व्यक्तिले त्यस देशलाई कहिल्यै देख्न पाउनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","तर मेरो सेवक कालेबमा अर्कै आत्मा छ, र उसले सम्पूर्ण हृदयले मलाई पछ्याएको छ। यसकारण उसले भेद लिएर आएको देशमा म उसलाई पुर्‍याउनेछु। अनि उसका सन्ततिहरूले त्यस देशमा अधिकार गर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","बेँसीहरूमा अमालेकीहरू र कनानीहरू बसोबास गरिरहेका हुनाले भोलि नै तिमीहरू फर्क। अनि लाल समुद्रको बाटो भएर उजाडस्थानतिर लाग।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","याहवेहले मोशा र हारूनलाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“यस दुष्‍ट समुदायले कहिलेसम्म मेरो विरुद्धमा गनगन गरिरहन्छ? मैले यी गनगने इस्राएलीहरूको गुनासो सुनेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","यसकारण तिनीहरूलाई भन्, “याहवेह घोषणा गर्नुहुन्छ, म जीवित भएझैँ तिमीहरूले भनेका कुराहरू मैले सुनेको छु। अनि म तिमीहरूसँग त्यसैअनुसार गर्नेछु। ");
INSERT INTO npioncb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तिमीहरूको मृत शरीर यही उजाडस्थानमा छोडिनेछ। जनगणनाको समयमा गनिएका बीस वर्ष अथवा त्योभन्दा माथिका हरेक मेरो विरुद्धमा गनगन गर्नेहरू मर्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","यपून्‍नेका छोरा कालेब र नूनका छोरा यहोशूबाहेक तिमीहरूमध्ये एउटै पनि मैले शपथ खाएर तिमीहरूलाई दिन लागेको देशमा प्रवेश गर्न पाउनेछैनौ। ");
INSERT INTO npioncb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","तिमीहरूका सन्तानहरू, जसको विषयमा तिमीहरूले लुटको मालजस्तै लगिनेछन् भनेका थियौ, म तिनीहरूलाई तिमीहरूले इन्कार गरेका देशमा आनन्द मनाउन ल्याउनेछु। ");
INSERT INTO npioncb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","तर तिमीहरू, तिमीहरूका मृत शरीरहरूचाहिँ यही उजाडस्थानमा छोडिनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","तिमीहरूमध्ये अन्तिम मानिसको शरीर उजाडस्थानमा मरेर नगएसम्म तिमीहरूका अविश्‍वासको फलस्वरूप तिमीहरूका सन्तानहरू यही उजाडस्थानमा चालीस वर्षसम्म गोठालो भई डुल्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","तिमीहरूले त्यस देशको जाजुसी गर्न चालीस दिन बिताएका थियौ, ‘यसकारण एक दिन बराबर एक वर्ष गरी चालीस वर्षसम्म तिमीहरूले आफ्ना अधर्महरूको फल भोग्नुपर्नेछ। अनि मेरो विरुद्ध खडा हुँदा कस्तो परिणाम भोग्नुपर्नेछ भनी थाहा पाउनेछौ।’ ");
INSERT INTO npioncb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","म याहवेहले नै बोलेको छु। अनि मेरो विरुद्धमा एकसाथ भेला हुने यस दुष्‍ट समुदायलाई म निश्‍चित रूपमा यी कुराहरू गर्नेछु। यही उजाडस्थानमा तिनीहरूको अन्त्य हुनेछ। तिनीहरू यहीँ नाश भएर जानेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","यसरी मोशाले कनान देशको बारेमा जाजुसी गर्न पठाएका मानिसहरू आएर खराब समाचार फैलाएर सारा समुदायलाई मोशाको विरुद्धमा गनगन गर्ने बनाए। ");
INSERT INTO npioncb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ती मानिसहरूले जासुसी गरेर आएको देशको बारेमा खराब समाचार फैलाएका हुनाले याहवेहकै सामु महामारीद्वारा तिनीहरूको मृत्यु भयो। ");
INSERT INTO npioncb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","कनान देशको बारेमा जासुसी गर्न जाने मानिसहरूमध्ये नूनका छोरा यहोशू र यपून्‍नेका छोरा कालेब मात्र जीवित रहे। ");
INSERT INTO npioncb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जब मोशाले सारा इस्राएलीहरूलाई यी कुराहरू बताए; तब तिनीहरू अत्यन्तै दुःखी भई विलौना गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","भोलिपल्ट एकाबिहानै तिनीहरू अग्लो डाँडा भएको ठाउँमा उक्ले, र तिनीहरूले भने, “हामीले पाप गरेका छौँ, तर हामी याहवेहले प्रतिज्ञा गर्नुभएको कनान देशमा जान तयार छौँ!” ");
INSERT INTO npioncb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","तर मोशाले तिनीहरूलाई भने, “तिमीहरू याहवेहको आज्ञा किन भङ्ग गर्दैछौ? यो योजना सफल हुनेछैन! ");
INSERT INTO npioncb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","तिमीहरू माथि नजाओ; किनभने याहवेह तिमीहरूसँग हुनुहुन्‍न। तिमीहरू आफ्ना शत्रुहरूद्वारा पराजित हुनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","त्यहाँ अमालेकीहरू र कनानीहरूले तिमीहरूको सामना गर्नेछन्। किनकि तिमीहरू याहवेहबाट तर्किगएका छौ। उहाँ तिमीहरूसँग हुनुहुनेछैन। अनि तिमीहरू तरवारद्वारा ढालिनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","तरै पनि तिनीहरू हठी भएर पहाडी मुलुकको टुप्पोमा चढे। तर याहवेहको करारको सन्दुक र मोशा पालबाट अगि बढेनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","तब त्यस पहाडी मुलुकमा बस्‍ने अमालेकीहरू र कनानीहरू तल ओर्लिआए। अनि तिनीहरूमाथि आक्रमण गरे, र तिनीहरूलाई तल होर्मासम्मै लखेटे। ");
INSERT INTO npioncb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएलीहरूसँग कुरा गर्, र तिनीहरूलाई भन्: ‘जब तिमीहरू मैले दिएको देशमा बसोबास गर्न पुग्छौ, ");
INSERT INTO npioncb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","तब याहवेहलाई मनपर्दो मिठो बास्‍नाका निम्ति भनेर आफ्नो गाईबस्तुका बथान अथवा भेडाबाख्राका बगालबाट एउटा पशु लिएर त्यसलाई याहवेहका निम्ति तिमीहरूले अग्निबलि चढाउनू—चाहे त्यो होमबलि, विशेष भाकलको बलि, स्वेच्छिक भेटीहरू अथवा चाडमा चढाइने बलिदानहरू हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","तब जसले आफ्नो भेटी ल्याउँछ, त्यसले एक चौथाइ हिन जैतुनको तेल मिसाएको एक एपाको दशौँ भाग मसिनो पिठो मिसाएको अन्‍नबलि याहवेहलाई चढाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","होमबलि अथवा बलिदान चढाउनका निम्ति हरेक थुमासँग अर्घबलिको रूपमा एक चौथाइ हिन दाखमद्य तयार पारोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘एउटा भेडासँग एक हिनको तीस भाग जैतुनको तेलमा एक एपाको बीसौँ भाग मसिनो पिठो मिसाएको अन्‍नबलि, ");
INSERT INTO npioncb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","अनि अर्घबलिको रूपमा एक हिनको तीन भाग दाखमद्य तयार पार्नू। त्यो याहवेहलाई मनपर्दो मिठो बास्‍नाको रूपमा भेटीको रूपमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘जब तैँले विशेष भाकलको निम्ति अथवा याहवेहका निम्ति मेलबलिको रूपमा एउटा बहर तयार पार्नेछस्, ");
INSERT INTO npioncb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","तब त्यस बहरसँग आधा हिन जैतुनको तेल मिसाएको एपाको दश भागको तीन भाग मसिनो पिठोको अन्‍नबलि ल्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","अनि आधा हिन दाखमद्य पनि अर्घबलिको रूपमा ल्याउनू। योचाहिँ याहवेहलाई मनपर्दो मिठो बास्‍नाको रूपमा आगोद्वारा चढाइएको भेटी हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","प्रत्येक बहर अथवा भेडा, थुमा अथवा कलिलो पाठोलाई यसरी नै तयार पार्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","जतिका निम्ति पशुबलि तयार गर्छौ, हरेक बलिका निम्ति यसरी नै तयार गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘स्वदेशमा जन्मने हरेकले याहवेहका निम्ति मनपर्दो मिठो बास्‍नाको रूपमा आगोद्वारा चढाइने बलि चढाउँदा यसरी नै गरोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","किनकि आउने पुस्ताहरूमा पनि तिमीहरूसँग बसोबास गर्ने परदेशी होस्, अथवा जोसुकैले पनि याहवेहलाई मनपर्दो मिठो बास्‍नाको रूपमा आगोद्वारा भेटी चढाउँदा तिनीहरूले पनि ठिक तिमीहरूले गरेजस्तै गरून्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","समुदायमा तिमीहरूका निम्ति र तिमीहरूसँग बसोबास गर्ने परदेशीहरूका निम्ति एउटै नियम लागू हुनेछ। योचाहिँ आउनेवाला पुस्ताका लागि सधैँभरिको विधि हो। याहवेहको सामु तिमीहरू र परदेशीहरू एउटै हौ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","तिमीहरू र तिमीहरूसँग बसोबास गर्ने परदेशीहरू दुवैका निम्ति एउटै नियम र विधिहरू लागू हुनेछन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएली मानिसहरूसँग कुरा गर्, र तिनीहरूलाई भन्: ‘जब तिमीहरू मैले लैजाँदैगरेको देशमा प्रवेश गर्नेछौ, ");
INSERT INTO npioncb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","तब तिमीहरूले त्यस देशको भोजन खाँदा एक भाग भेटीको रूपमा याहवेहलाई चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","तिमीहरूको खलाबाट आएको पहिलो नयाँ फसलको अन्‍नको पिठोबाट बनाएको रोटी भेटीको रूपमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","आउने पुस्ताभरि नै तिमीहरूले याहवेहलाई आफ्नो जमिनको पहिलो बालीको पिठोबाट अगौटे भेटी चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘यदि याहवेहले मोशालाई दिनुभएको आज्ञाहरूलाई अनजानमा तिमीहरूले पूरा गर्न सकेनौ भने ");
INSERT INTO npioncb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","अर्थात् याहवेहले मोशाद्वारा दिनुभएका आज्ञाहरू, उहाँले दिनुभएको दिनदेखि अहिलेसम्म र आउने पुस्ताहरूले पनि यी आज्ञाहरू पालन गर्न चुके भने— ");
INSERT INTO npioncb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","र यदि तिमीहरूले यी समुदायले थाहा नपाई अनजानमा गर्‍यौ भने सारा समुदायले याहवेहका निम्ति मनपर्दो मिठो बास्‍नाको रूपमा होमबलिको निम्ति एउटा बहर, साथै तोकिएको अन्‍नबलि र अर्घबलि अनि पाप शुद्धीकरण बलिको रूपमा एउटा बोका पनि चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","पुजारीले सारा इस्राएली समुदायका निम्ति पापको प्रायश्‍चित गरोस्, र तिनीहरूलाई क्षमा हुनेछ। किनकि त्यो तिनीहरूले अनजानमा गरेको भूल हुनाले याहवेहकहाँ अन्‍नबलि र पाप शुद्धीकरण बलि ल्याएका हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","सारा इस्राएली समुदाय र तिनीहरूसँग बसोबास गर्ने परदेशीहरूले पनि क्षमा पाउनेछन्। किनभने ती सबै मानिसहरूले अनजानमा भूल गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘तर यदि एक जनाले मात्र अनजानमा पाप गर्‍यो भने त्यसले पाप शुद्धीकरण बलिका निम्ति बाख्राको एकवर्षे पाठी ल्याओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","पुजारीले अनजानमा पाप गर्ने त्यस व्यक्तिका निम्ति याहवेहको सामु प्रायश्‍चित गरोस्; र त्यसका निम्ति प्रायश्‍चित भएपछि त्यसलाई क्षमा हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","अनजानमा पाप गर्ने व्यक्ति स्वदेशमा जन्मेको इस्राएली होस्, अथवा तिमीहरूको बीचमा बसोबास गर्ने विदेशी होस्, सबैका निम्ति एउटै नियम लागू हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘तर चाहे स्वदेशमा जन्मेको होस्, अथवा विदेशी होस्, यदि कसैले अनादरपूर्वक जानाजानी पाप गर्‍यो र याहवेहको नामको निन्दा गर्‍यो भने त्यस व्यक्तिलाई इस्राएली समाजबाट बहिष्कार गरिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","किनभने तिनीहरूले याहवेहको वचन तिरस्कार गरे। अनि उहाँका आज्ञाहरू भङ्ग गरेको कारण तिनीहरूलाई निश्‍चय नै बहिष्कार गरिनुपर्छ। तिनीहरूको दोषको दण्ड तिनीहरूमाथि नै पर्नेछ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","इस्राएलीहरू उजाडस्थानमा हुँदा एक जना मानिस विश्रामदिनमा दाउरा बटुलिरहेको भेटियो। ");
INSERT INTO npioncb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","अनि जसले त्यसलाई दाउरा बटुलिरहेको भेट्टाए, तिनीहरूले त्यसलाई मोशा, हारून र सारा समुदायकहाँ ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","अनि त्यसलाई के गर्नुपर्ने हो, स्पष्‍ट थाहा भएन। यसैले तिनीहरूले त्यसलाई थुनामा राखे। ");
INSERT INTO npioncb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","तब याहवेहले मोशालाई भन्‍नुभयो, “त्यो मानिस मर्नैपर्छ। सारा समुदायले त्यसलाई छाउनीबाहिर ढुङ्गाले हानेर मार्नुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","यसकारण समुदायले त्यसलाई छाउनीबाहिर लगेर याहवेहले मोशालाई आज्ञा गर्नुभएअनुसार ढुङ्गाले हानेर मारे। ");
INSERT INTO npioncb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएलीहरूसँग कुरा गर्, र तिनीहरूलाई भन्: ‘आउने पुस्ताभरिका लागि तिमीहरूका वस्त्रहरूका कुनामा निलो धागोको झुम्काहरू बनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","यी झुम्काहरू तिमीहरूले हेर्नलाई होस्, जसद्वारा तिमीहरूले याहवेहका सबै आज्ञाहरू सम्झनेछौ। अनि तिमीहरूका हृदय र आँखाका अभिलाषालाई पछ्याएर पथभ्रष्‍ट नभई उहाँको आज्ञाहरू पालन गर्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","तब तिमीहरूले मेरा सबै आज्ञाहरू पालन गर्नलाई याद गर्नेछौ। अनि तिमीहरू आफ्ना परमेश्‍वरका निम्ति पवित्र हुनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","म याहवेह तिमीहरूका परमेश्‍वर हुँ। मैले तिमीहरूलाई इजिप्टबाट निकालेर ल्याएँ। म याहवेह नै तिमीहरूका परमेश्‍वर हुँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","एक दिन लेवीको छोरा कहात, कहातको छोरा यिसहार, यिसहारको छोरा कोरहले, रूबेनी कुलका एलिआबका छोराहरू दातान र अबीराम अनि पेलेतको छोरा ओनलाई आफ्नो पक्षमा लिए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","अनि मोशाको विरुद्धमा तिनीहरू उठे। तिनीहरूसँग इस्राएली मानिसहरूका समुदायको सभामा नियुक्त गरिएका मान्य 250 जना अगुवाहरू पनि सामेल थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","तिनीहरू मोशा र हारूनको विरोध गर्नलाई एक दल भएर आए, र तिनीहरूलाई भने, “तपाईंहरूले अति नै गर्नुभएको छ! सारा समुदाय र यहाँका हरेक व्यक्ति पवित्र छन्। अनि याहवेह तिनीहरूसँग हुनुहुन्छ। त्यसो भए तपाईंहरूले आफूलाई याहवेहको समुदायभन्दा किन उच्‍च तुल्याउनुहुन्छ?” ");
INSERT INTO npioncb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जब मोशाले यो कुरा सुने, तब तिनी भुइँमा घोप्टो परे। ");
INSERT INTO npioncb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","त्यसपछि मोशाले कोरह र उसका सबै दललाई यसो भने: “भोलि बिहान याहवेहले, जो उहाँको हो, र जो पवित्र छ, उहाँले त्यसलाई आफ्नो नजिक आउन दिनुहुन्छ। उहाँले छान्‍नुभएको मानिसलाई उहाँले आफ्नो नजिक आउन दिनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","हे कोरह, तिमी र तिम्रा समर्थकहरू सबैले यसो गर्नु: धुपौराहरू लिनू, ");
INSERT INTO npioncb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","अनि भोलि याहवेहको सामु बलेको कोइला लिनू र त्यसमा धूप हाल्नू। याहवेहले छान्‍नुहुने मानिसचाहिँ पवित्र व्यक्ति हुनेछ। तिमी लेवीहरूले अति नै गरेका छौ!” ");
INSERT INTO npioncb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मोशाले कोरहलाई यो पनि भने, “हे लेवीहरू हो, अब सुन! ");
INSERT INTO npioncb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","इस्राएलका परमेश्‍वरले तिमीहरूलाई समागम पालमा याहवेहको काम गर्न र समुदायको सेवा गर्न सारा समुदायहरूको सामु खडा हुनको लागि इस्राएलका अरू समुदायबाट तिमीहरूलाई अलग गरी उहाँकै नजिक ल्याउनुभएको छ। के यो कुरा तिमीहरूलाई पर्याप्‍त भएन र? ");
INSERT INTO npioncb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","उहाँले तिमीहरू र तिमीहरूका सङ्गी लेवीहरूलाई आफ्नै नजिक ल्याउनुभएको छ। तर अहिले तिमीहरू पुजारी पद पनि पाउने कोसिस गर्दैछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","तिमी र तिम्रा समर्थकहरू एकमत भएर याहवेहको विरोधी भएका छौ। हारून को हुन्, र तिमीहरू तिनको विरुद्धमा गनगन गर्दछौ?” ");
INSERT INTO npioncb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","त्यसपछि मोशाले एलिआबका छोराहरू दातान र अबीरामलाई बोलाउन पठाए। तर तिनीहरूले भने, “अहँ, हामी आउनेछैनौँ! ");
INSERT INTO npioncb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","के तपाईंले हामीलाई दूध र मह बग्ने देशबाट उजाडस्थानमा मार्नलाई ल्याउनुभएको छ; यत्तिले पनि तपाईंलाई पुगेन? अनि अहिले तपाईं हाम्रा मालिक पनि बन्‍न चाहनुहुन्छ? ");
INSERT INTO npioncb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","अनि अझ तपाईंले हामीलाई दूध र मह बग्ने देशमा ल्याउनुभएको छैन, न त हामीलाई पैतृक सम्पत्तिको रूपमा खेतबारीहरू र दाखबारीहरू नै दिनुभएको छ। के तपाईंले यी मानिसहरूलाई दास बनाउन चाहनुहुन्छ? अहँ, हामी आउनेछैनौँ!” ");
INSERT INTO npioncb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","तब मोशा अत्यन्तै रिसाए, र तिनले याहवेहलाई भने, “तिनीहरूको भेटी ग्रहण नगर्नुहोस्। मैले तिनीहरूबाट एउटा गधासम्म पनि लिएको छैन, न त मैले तिनीहरूलाई कुनै हानि गरेको छु।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","मोशाले कोरहलाई भने, “तिमी र तिम्रा पछि लाग्ने सबै जना भोलि याहवेहको सामु हाजिर हुनू। तिमी, तिम्रा मानिसहरू र हारून पनि आउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","हरेक मानिसले अर्थात् 250 जना सबैले आ-आफ्नो धुपौरो लिनू र त्यसमा धूप बालेर याहवेहको सामु ल्याउनू। तिमीले र हारूनले पनि आफ्ना धुपौराहरू ल्याउनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","यसकारण उनीहरू हरेकले आ-आफ्नो धुपौरो लिएर त्यसमा बलिरहेको कोइला लिए, र त्यसमा धूप बाले। अनि मोशा र हारूनसँग भेट हुने पालको प्रवेशद्वारमा खडा भए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","जब कोरहले तिनीहरूको विरुद्धमा आफ्नो पछि लाग्नेहरूलाई भेट हुने पालको प्रवेशद्वारमा भेला गराए, तब याहवेहको महिमा सारा समुदायको सामु देखा पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“यस समुदायबाट आ-आफूलाई अलग गर, ताकि म तिनीहरूलाई एकैचोटिमा समाप्‍त पार्न सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","तर मोशा र हारून भुइँमा घोप्टो परेर पुकार गरे, “हे परमेश्‍वर, सारा जीवित प्राणीहरूलाई प्राण दिनुहुने परमेश्‍वर, के एउटा मानिसको पापले गर्दा तपाईं सारा समुदायमसँग रिसाउनुहुन्छ?” ");
INSERT INTO npioncb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“सारा समुदायलाई भन्, ‘कोरह, दातान र अबीरामका पालहरूदेखि टाढा हटिजाऊन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मोशा उठेर दातान र अबीराम कहाँ गए। अनि इस्राएलका प्रधानहरू पनि तिनको पछि लागे। ");
INSERT INTO npioncb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","तिनले समुदायलाई चेतावनी दिए, “यी दुष्‍ट मानिसहरूका पालहरूबाट टाढा गइहाल! तिनीहरूका कुनै पनि कुरा नछुनू; नत्रता तिनीहरूका पापको कारण तिमीहरू पनि सखाप पारिनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","यसकारण तिनीहरू कोरह, दातान र अबीरामका पालहरूबाट टाढा हटिगए। कोरह, दातान र अबीरामचाहिँ बाहिर आएर आफ्ना पालका प्रवेशद्वारमा आफ्ना पत्नीहरू र छोराछोरीहरू र नातिनातिनाहरूसँग उभिरहेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","तब मोशाले भने, “याहवेहले यी सबै कुराहरू गर्नु भनी पठाउनुभएको हो; र यो मेरो आफ्नै इच्छाअनुसार गरेको होइन भनी तिमीहरूले यसरी जान्‍नेछौ: ");
INSERT INTO npioncb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","यदि यी मानिसहरूको मृत्यु स्वभाविक तरिकाले भयो, र अरू मानिसहरूले भोगेजस्तै सामान्य अनुभव गरे भने मलाई याहवेहले पठाउनुभएको होइन। ");
INSERT INTO npioncb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","तर यदि याहवेहले पूर्णतया अनौठो कुरा ल्याउनुभयो, र धर्ती फाटेर त्यसले तिनीहरूलाई र तिनीहरूसँग भएका सबैलाई निलिहाल्यो भने, र तिनीहरू जिउँदै पातालभित्रै गए भने यी मानिसहरूले याहवेहलाई तिरस्कार गरेका रहेछन् भनी तिमीहरूले जान्‍नेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","मोशाले यी कुराहरू भनिसक्नसाथ तिनीहरू उभिएको जमिन फाट्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","अनि धर्तीले आफ्नो मुख खोल्यो, र तिनीहरूलाई, तिनीहरूका घरानाहरू र कोरहलाई साथ दिने सबैलाई अनि तिनीहरूका सबै धनसम्पत्ति समेत निलिहाल्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","तिनीहरू आफूले हासिल गरेका सबै थोकसँगै जीवितै पातालभित्र खसे। तिनीहरूमाथि पृथ्वी बन्द भइहाल्यो। तिनीहरू नष्‍ट भए; अनि आफ्ना समुदायबाट लोप भए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","तिनीहरूको चीत्कार सुनेर त्यहाँ तिनीहरूका वरिपरि भएका सबै इस्राएलीहरू “हामीलाई पनि पृथ्वीले निलिहाल्‍ला कि!” भन्दै बेस्सरी चिच्याउँदै भागे। ");
INSERT INTO npioncb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","अनि याहवेहबाट आगो निस्केर आयो र धूपभेटी चढाइरहेका ती 250 जना मानिसहरूलाई पनि भस्म पार्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“पुजारी हारूनको छोरो एलाजारलाई जलिरहेको अवशेषबाट धुपौराहरूलाई निकालेर त्यसमा भएको खरानीलाई केही पर लगेर छर्कनू भन्। किनकि ती धुपौराहरू पवित्र छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","आफ्ना प्राणको साटोमा पाप गर्ने ती मानिसहरूका धुपौराहरू हुन्। ती धुपौराहरूलाई घनले पिटेर वेदीलाई मोहोर्ने पाताहरू बनाउनू। किनकि तिनीहरू याहवेहको सामु ल्याइएका हुनाले ती पवित्र भएका छन्। ती इस्राएलीहरूका निम्ति एउटा चिन्ह होऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","यसकारण पुजारी एलाजारले ती आगोले भस्म हुनेहरूले ल्याएका काँसोका धुपौराहरू बटुले। अनि वेदीलाई मोहोर्नलाई पिटेर पातलो पाताहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","याहवेहले मोशाद्वारा एलाजारलाई आज्ञा गर्नुभएअनुसार गरे। योचाहिँ इस्राएलीहरूलाई याद गराउनका निम्ति थियो। हारूनका सन्तानहरूबाहेक अरू कोही पनि याहवेहको सामु धूप बाल्न नआओस्; नत्रता त्यो कोरह र त्यसलाई पछ्याउनेहरूजस्तै हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","भोलिपल्ट इस्राएलका सारा समुदाय मोशा र हारूनको विरुद्धमा गनगन गर्दै तिनीहरूले भने, “तिमीहरूले याहवेहका मानिसहरूलाई मार्‍यौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","तर जब समुदाय मोशा र हारूनको विरुद्धमा भेला भए; अनि भेट हुने पालतिर फर्के, तब अचानक त्यसलाई बादलले ढाक्यो। अनि याहवेहको महिमा देखा पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","तब मोशा र हारून भेट हुने पालको सामु गए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","अनि याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“तिमीहरू यस समुदायबाट अलग भइहाल, ताकि म एकैचोटिमा यिनीहरूको अन्त्य गर्न सकूँ।” अनि तिनीहरू भुइँमा घोप्टो परे। ");
INSERT INTO npioncb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","त्यसपछि मोशाले हारूनलाई भने, “आफ्नो धुपौरो लिएर त्यसमा धूप बाल्नुहोस्। साथै वेदीबाट बलिरहेको कोइला लिएर समुदायका निम्ति प्रायश्‍चित गर्नलाई झट्टै तिनीहरूकहाँ जानुहोस्। याहवेहको क्रोध खनिएको छ; विपत्ति सुरु भइसकेको छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","यसकारण मोशाले भनेअनुसार हारूनले गरे। अनि दगुरेर समुदायको बीचमा गए। मानिसहरूका बीचमा अगि नै विपत्ति सुरु भइसकेको थियो। तर हारूनले धूप चढाएर तिनीहरूका निम्ति प्रायश्‍चित गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","हारून जीवित र मरिसकेकाहरूका बीचमा खडा भए; तब विपत्ति थामियो। ");
INSERT INTO npioncb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","तर त्यहाँ कोरहको कारण मारिएकाहरूबाहेक 14,700 व्यक्तिहरू पनि यस विपत्तिमा मरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","त्यसपछि हारून भेट हुने पालको प्रवेशद्वारमा मोशाकहाँ फर्केर गए; किनकि विपत्ति थामिसकेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएलीसँग कुरा गर्, र तिनीहरूका पुर्ख्यौली कुलका प्रत्येक अगुवाबाट एक-एक गरी तिनीहरूबाट बाह्र वटा लहुराहरू लिनू। प्रत्येक मानिसको नाम त्यसको लहुरोमा लेख्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवीको लहुरोमा चाहिँ हारूनको नाम लेख्नू। किनकि प्रत्येक पुर्ख्यौली कुलको अगुवाको निम्ति एक-एक वटा लहुरो हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","लहुराहरूलाई भेट हुने पालमा साक्षी पाटीको सन्दुकको सामु राखिदिनू, जहाँ म तँसँग भेट गर्छु। ");
INSERT INTO npioncb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","म जुन मानिसको लहुरोलाई रोज्नेछु, त्यसमा कोपिला लाग्नेछ। अनि तेरो विरुद्धमा इस्राएलीहरूले गर्ने सधैँको गनगनबाट म तँलाई मुक्त गर्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","यसकारण मोशाले इस्राएलीहरूसँग कुरा गरे। अनि तिनीहरूका अगुवाहरूले तिनीहरूका प्रत्येक पुर्ख्यौली कुलबाट एक-एक गरी बाह्र वटा लहुराहरू तिनलाई दिए। तीमध्ये हारूनको पनि एउटा लहुरो थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मोशाले ती लहुराहरू साक्षी पाटीको सन्दुकको पालमा याहवेहको सामु राखिदिए। ");
INSERT INTO npioncb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","भोलिपल्ट मोशा पालभित्र पसे। लेवीको घरानालाई प्रतिनिधित्व गर्ने हारूनको लहुरोमा टुसा पलाएको मात्र थिएन, तर त्यसमा कोपिला लागेर फूल पनि फुलेर हाडे-बदामसमेत फलेको देखे। ");
INSERT INTO npioncb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","त्यसपछि मोशाले ती लहुराहरू याहवेहको उपस्थितिबाट सबै इस्राएलीहरूकहाँ ल्याए। तिनीहरूले ती लहुराहरू हेरे। अनि हरेक अगुवाहरूले आ-आफ्नो लहुरो लिए। ");
INSERT INTO npioncb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो, “हारूनको लहुरो विद्रोहीहरूको चिन्हको रूपमा रहोस् भनी पालमा साक्षी पाटीको सन्दुकको सामु लगेर राखिदे। यसले मेरो विरुद्धमा तिनीहरूको गनगन समाप्‍त गरिदिनेछ। यसकारण तिनीहरू मर्नेछैनन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","याहवेहले मोशालाई आज्ञा दिनुभएअनुसार तिनले गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इस्राएली मानिसहरूले मोशालाई भने, “हामी मर्नेछौँ! हामी नष्‍ट भयौँ; हामी नष्‍ट भयौँ! ");
INSERT INTO npioncb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","याहवेहको समागम पालको नजिक आउने जो कोही पनि मर्नेछ। के हामी सबै जना नष्‍ट होऔँ त?” ");
INSERT INTO npioncb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","याहवेहले हारूनलाई भन्‍नुभयो, “तँ, तेरा छोराहरू र तेरा परिवारले पवित्रस्थान सम्बन्धित गरिएका अपराधहरूको जिम्मेवारी उठाउनुपर्छ। अनि पुजारीगिरी सम्बन्धित गरिएका अपराधहरूको जिम्मेवारी तँ र तेरा छोराहरूले मात्र उठाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","तँ र तेरा छोराहरूले साक्षी पाटीको पालमा सेवा गर्दा तिमीहरूसँग मिलेर तिमीहरूलाई सघाउन भनी तेरा पुर्ख्यौली कुलबाट तेरा नातेदार लेवीहरूलाई लिएर आइज। ");
INSERT INTO npioncb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","तिनीहरूले तँप्रति जिम्मेवार हुनुपर्छ। अनि तिनीहरूले पालका सबै कर्तव्यहरू पूरा गर्नुपर्छ। तर तिनीहरू पवित्रस्थानका सरसामानहरू नजिक अथवा वेदीको नजिक नजाऊन्, नत्रता तिनीहरू र तिमीहरू दुवै मर्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","तिनीहरू तिमीहरूसँग मिलून् र भेट हुने पाल अर्थात् पालका सबै कामहरूका रेख-देखको जिम्मेवारी उठाऊन्। तिमीहरूको नजिक अरू कोही पनि नआऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“पवित्रस्थान र वेदीको रेख-देखको जिम्मेवारी तिमीहरूको हो; ताकि मेरो क्रोध इस्राएलीहरूमाथि फेरि नपरोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","म आफैँले तेरा नातेदार लेवीहरूलाई इस्राएलीहरूका बीचबाट तेरो उपहारको रूपमा छानेको छु। भेट हुने पालको काम गरून् भनेर याहवेहलाई अर्पण गरेको छु। ");
INSERT INTO npioncb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","तर वेदी र पर्दाभित्रका सबै कुराको सम्बन्धमा तँ र तेरा छोराहरूले मात्र पुजारीको रूपमा सेवा गर्नुपर्छ। मैले तँलाई पुजारी पदको सेवा उपहारको रूपमा दिएको छु। तर लेवीहरूबाहेक कोही पवित्रस्थानको नजिक आएमा ऊ मारिनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","त्यसपछि याहवेहले हारूनलाई भन्‍नुभयो, “मलाई चढाइएका भेटीहरूको जिम्मा म आफैँले तँलाई सुम्पेको छु। इस्राएलीहरूले मलाई दिएका सबै पवित्र भेटीहरू मैले तिमीहरूको भाग र नियमित अंशको रूपमा तँ र तेरा छोराहरूलाई दिएको छु।” ");
INSERT INTO npioncb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","आगोबाट छुट्याइएका महा-पवित्र भेटीहरूको भाग तिमीहरूले राख्नू। तिनीहरूले मेरा निम्ति ल्याएका महा-पवित्र भेटीहरू चाहे अन्‍नबलि होस्, अथवा पापबलि अथवा दोषबलि त्यसको भाग होस्; त्यो तँ र तेरा छोराहरूका निम्ति हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ती थोकहरू महा-पवित्र ठानेर खानू। प्रत्येक पुरुषले त्यो खानू। तिमीहरूले त्यसलाई पवित्र ठान्‍नू। ");
INSERT INTO npioncb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“तीबाहेक यो पनि तेरै हो: इस्राएलीहरूले विशेष भेटीहरूको रूपमा उचालिनका लागि अलग गरिएका सबै थोक। म यसलाई तिमीहरूका नियमित अंशको रूपमा तँ, तेरा छोराहरू र छोरीहरूलाई दिन्छु। तेरा घरानाका विधिपूर्वक शुद्ध रहेका हरेकले त्यो खान सक्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“मैले तिनीहरूका कटनीको अगौटेबाट याहवेहलाई चढाएका सबै असल जैतुनको तेल, अति उत्तम नयाँ दाखमद्य र अन्‍न तँलाई दिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","तिनीहरूले याहवेहकहाँ ल्याएका खेतका सबै अगौटे फलहरू तिमीहरूकै हुनेछन्। तेरा घरानाका विधिपूर्वक शुद्ध रहेका हरेकले त्यसलाई खान सक्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“इस्राएलमा याहवेहलाई समर्पित गरिएको हरेक चीज तेरै हो। ");
INSERT INTO npioncb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","मानिसको होस् वा पशुको, हरेक गर्भको पहिलो फल, जो याहवेहलाई चढाइन्छ, त्यो तेरै हो। तर तैँले प्रत्येक पहिले जन्मेको छोरा र अशुद्ध पशुहरूका पहिले जन्मेको प्रत्येक सन्तानलाई मूल्य चुकाएर छुटाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","जब तिनीहरू एक महिनाका हुन्छन्, तब तैँले तिनीहरूलाई पवित्रस्थानको शेकेलअनुसार तोकिएको पाँच चाँदीका शेकेल छुटकाराको मोल तिरेर छुटाउनुपर्छ। जसको तौल बीस गेरा हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“तर तैँले गाई, भेडा अथवा बाख्राका पहिले जन्मेकाहरूलाई मोल तिरेर छुट्ट्याउनुहुँदैन। तिनीहरू पवित्र हुन्। तिनीहरूको रगत वेदीमाथि छर्कनू। तिनीहरूको बोसोचाहिँ आगोद्वारा चढाइने बलिको रूपमा याहवेहलाई मनपर्दो मिठो बास्‍नाको भेटी हुने गरी जलाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","विशेष भेटीको रूपमा उचालिएको ह्‍याकुला र दाहिने फिला तेरा निम्ति भएजस्तै, तिनीहरूका मासु पनि तेरै हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","इस्राएलीहरूले याहवेहलाई चढाएका पवित्र भेटीहरूबाट अलग गरिएका भागहरू म तिमीहरूको नियमित अंशको रूपमा तँ, तेरा छोराहरू र छोरीहरूलाई दिन्छु। यो याहवेहको सामु तँ र तेरा सन्तानहरू दुवैका निम्ति अनन्तको नुनको करार हो।” ");
INSERT INTO npioncb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","याहवेहले हारूनलाई भन्‍नुभयो, “तिनीहरूको देशमा तेरो कुनै पैतृक सम्पत्ति हुनेछैन, न त तिनीहरूबीच तिमीहरूको कुनै भाग नै हुनेछ। इस्राएलीहरूबीच म नै तिमीहरूको भाग र तिमीहरूको पैतृक सम्पत्ति हुँ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“लेवीहरूले भेट हुने पालमा सेवाको काम गरेको साटोमा म तिनीहरूलाई इस्राएलमा तिनीहरूको पैतृक सम्पत्तिको रूपमा सबै दशांश दिन्छु। ");
INSERT INTO npioncb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","अब उसो इस्राएलीहरू भेट हुने पालको नजिक नजाऊन्; नत्रता तिनीहरूले आफ्ना पापको फल भोग्नेछन्, र मर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","लेवीहरूले नै भेट हुने पालमा काम गरून्। अनि तिनीहरूको विरुद्धमा भएका अपराधहरूको जिम्मा तिनीहरूले नै लिऊन्। आउने पुस्ताका निम्ति यो अनन्तको विधि ठहरियोस्। इस्राएलीहरूबीच तिनीहरूले कुनै पैतृक सम्पत्ति पाउनेछैनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","यसको सट्टामा इस्राएलीहरूले याहवेहकहाँ चढाएका दशांशहरू म लेवीहरूलाई तिनीहरूका पैतृक सम्पत्तिको रूपमा दिन्छु। यसकारण मैले तिनीहरूको विषयमा यसो भनेँ: ‘इस्राएलीहरूबीच तिनीहरूले कुनै पैतृक सम्पत्ति पाउनेछैनन्।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लेवीहरूसँग कुरा गर्, र तिनीहरूलाई भन्: ‘तिमीहरूले इस्राएलीहरूबाट आफ्ना पैतृक सम्पत्तिको रूपमा पाएका दशांशबाट तिमीहरूले दशांशको दशांश याहवेहको भेटीको रूपमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","तिमीहरूको बलि खलाबाटको अन्‍न अर्थात् कोलबाटको दाखरसजस्तै गनिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","यस प्रकारले तिमीहरूले इस्राएलीहरूबाट पाएका सबै दशांशबाट तिमीहरूले पनि याहवेहलाई भेटी चढाउनेछौ। यी दशांशहरूबाट तिमीहरूले याहवेहको भाग हारून पुजारीलाई दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","तिमीहरूलाई दिइएका सबै असल र पवित्र कुराहरूबाट याहवेहको भाग चढाउनुपर्छ।’ ");
INSERT INTO npioncb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“लेवीहरूलाई तैँले भन्: ‘जब तिमीहरूले उत्तम भाग चढाउँछौ, तब तिमीहरूको भेटीलाई खलाको अर्थात् दाखको कोलको फसलको रूपमा गनिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","तँ र तेरा घरानाले भेटीबाट रहेका भाग जहाँ भए तापनि खान सक्छौ। किनकि त्यो तिमीहरूले भेट हुने पालमा गरेको कामको ज्याला हो। ");
INSERT INTO npioncb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","त्यसको सर्वोत्तम भाग चढायौ भने दशांश भेटीमा तिमीहरू दोषी हुनेछैनौ। अनि तिमीहरूले इस्राएलीहरूका पवित्र भेटीहरू अशुद्ध पार्नेछैनौ र तिमीहरू मर्नेछैनौ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","याहवेहले मोशा र हारूनलाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“याहवेहले आज्ञा दिनुभएको व्यवस्थाको नियम यही हो: जुवामा कहिल्यै ननारिएको निष्खोट अथवा दागरहित रातो कोरली तँकहाँ ल्याऊन् भनी इस्राएलीहरूलाई भन्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","त्यो कोरली पुजारी एलाजारलाई दिनू। त्यसलाई छाउनीबाहिर लगियोस्, र एलाजारको उपस्थितिमा मारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","त्यसपछि पुजारी एलाजारले त्यसबाट केही रगत आफ्नो औँलामा लिएर भेट हुने पालको अगाडि सात चोटि छर्कोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","एलाजारको सामु त्यो कोरली बाछी अर्थात् त्यसको छाला, मासु, रगत र आन्द्राभुँडी जलाइयोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","पुजारीले देवदारुका केही काठ, हिसप र रातो ऊन लिएर जलिरहेको कोरलीमाथि फ्याकिदेओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","त्यसपछि पुजारीले आफ्ना लुगाहरू धोओस्, र आफ्नो शरीर पानीले नुहाओस्। त्यसपछि पुजारी छाउनीभित्र आओस्। तर साँझसम्म भने विधिपूर्वक ऊ अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","त्यस कोरलीलाई जलाउने मानिसले पनि आफ्नो लुगा धुनुपर्नेछ, र नुहाउनुपर्नेछ; अनि त्यो पनि साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“तब एक जना शुद्ध मानिसले चाहिँ त्यस कोरलीको खरानी बटुलोस्। त्यसलाई चाहिँ छाउनीबाहिर विधिपूर्वक शुद्ध भएको ठाउँमा राखोस्। त्यो इस्राएली समुदायले शुद्ध पार्ने पानी तयार गर्दा प्रयोग गर्नका निम्ति राखोस्। त्यो पापबाट शुद्धीकरणको निम्ति हो। ");
INSERT INTO npioncb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","कोरलीको खरानी बटुल्ने त्यो मानिसले पनि आफ्नो लुगा धुनुपर्नेछ। अनि त्यो पनि साँझसम्म अशुद्ध रहनेछ। इस्राएलीहरू र तिनीहरूसँग बसोबास गर्ने विदेशीहरू दुवैका निम्ति यो सधैँभरिको लागि एउटा नियम हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“कसैले मानिसको लास छोएको छ भने त्यो मानिस सात दिनसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","तिनीहरूले तेस्रो दिन र सातौँ दिनमा आफूलाई पानीले चोख्याऊन्। त्यसपछि तिनीहरू शुद्ध हुनेछन्। तर यदि तिनीहरूले आफूलाई तेस्रो र सातौँ दिनमा पानीले चोख्याएनन् भने तिनीहरू शुद्ध हुनेछैनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","यदि मरेको मानिसको लास छोएपछि तिनीहरूले आफूलाई चोख्याएनन् भने तिनीहरूले याहवेहको समागम पाललाई अशुद्ध तुल्याउँछन्। तिनीहरूलाई इस्राएली समुदायबाट बहिष्कार गरिनुपर्छ। तिनीहरूमाथि शुद्धीकरणको पानी नछर्किएको कारण तिनीहरू अशुद्ध छन्। तिनीहरूको अशुद्धता तिनीहरूमा नै रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“कुनै पनि मानिस पालभित्र मर्‍यो भने यो नियम लागू हुन्छ: त्यस पालभित्र पस्‍ने, र त्यसभित्र हुने जो कोही पनि सात दिनसम्म अशुद्ध हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","अनि पालभित्रका ढकनीविनाको हरेक खुल्‍ला भाँडो अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“खुल्‍ला ठाउँमा तरवारद्वारा मारिएको मानिस वा स्वभाविक रूपले मरेको मानिसलाई जसले छुन्छ, अथवा जसले मानिसको हड्डी अथवा चिहानलाई छुन्छ, त्यो मानिस सात दिनसम्म अशुद्ध रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“त्यस अशुद्ध व्यक्तिका निम्ति पापबलि जलाइएको शुद्धीकरणको भेटीबाट केही खरानी एउटा कलशमा हाल्नू। अनि त्यस खरानीमा ताजा पानी खन्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","त्यसपछि विधिपूर्वक शुद्ध भएको मानिसले हिसप लिएर त्यसलाई पानीमा चोपेर पाल र त्यसमा भएका सबै सरसामानहरू, र त्यहाँ भएका सबै मानिसहरूमाथि छर्कनू। मानिसको हड्डी वा चिहान अर्थात् मारिएको मानिसलाई वा स्वभाविक रूपले मरेको मानिसलाई छुने व्यक्तिलाई पनि त्यसले छर्कनू। ");
INSERT INTO npioncb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","त्यस शुद्ध मानिसले अशुद्ध व्यक्तिहरूलाई तेस्रो र सातौँ दिनमा शुद्ध पानी छर्कोस्। अनि सातौँ दिनमा त्यसले तिनीहरूलाई चोख्याओस्। शुद्ध भइसकेको व्यक्तिले आफ्नो लुगा धुनुपर्छ र पानीले नुहाउनुपर्छ। अनि साँझसम्ममा तिनीहरू शुद्ध हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","तर यदि ती अशुद्ध व्यक्तिहरूले आफूलाई चोख्याउँदैनन् भने तिनीहरूलाई समाजबाट बहिष्कार गरिनुपर्छ। किनभने तिनीहरूले याहवेहको पवित्रस्थानलाई अशुद्ध तुल्याएका छन्। तिनीहरूमाथि शुद्धीकरणको पानी नछर्किएको कारण तिनीहरू अशुद्ध रहन्छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","यो तिनीहरूका निम्ति एउटा सधैँभरिको विधि हो। “शुद्धीकरणको पानी छर्कने मानिसले पनि आफ्ना लुगाहरू धुनुपर्छ। शुद्धीकरणको पानी छुने जोसुकै पनि साँझसम्म अशुद्ध हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","अशुद्ध व्यक्तिले छोएको जुनसुकै कुरा पनि अशुद्ध हुनेछ। त्यसलाई छुने जोसुकै पनि साँझसम्म अशुद्ध हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहिलो महिनामा सारा इस्राएली समुदाय जीनको उजाडस्थानमा आइपुगे; र तिनीहरू कादेशमा बसे। त्यहाँ मिरियमको मृत्यु भयो, र तिनलाई त्यहीँ गाडियो। ");
INSERT INTO npioncb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","तर त्यहाँ मानिसहरूका निम्ति पिउनलाई पानी थिएन। अनि तिनीहरू मोशा र हारूनको विरोधमा भेला भए। ");
INSERT INTO npioncb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","यसकारण तिनीहरूले मोशासित झगडा गरेर भने, “हाम्रा दाजुभाइहरू याहवेहको सामु मर्दा बरु हामी पनि मरिहालेका भए असल हुनेथियो! ");
INSERT INTO npioncb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","याहवेहको समुदायलाई तपाईंहरूले उजाडस्थानमा किन ल्याउनुभयो? हामी र हाम्रा गाईबस्तुहरू मरून् भनेर ल्याउनुभएको हो? ");
INSERT INTO npioncb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","तपाईंले हामीलाई इजिप्टबाट निकालेर यस डरलाग्दो ठाउँमा किन ल्याउनुभयो? यहाँ न अन्‍न, न नेभारा, न अङ्‌गुर अथवा न त अनार नै छ। अनि पिउनलाई पानी पनि छैन!” ");
INSERT INTO npioncb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","मोशा र हारून त्यस समुदायलाई छोडेर भेट हुने पालको प्रवेशद्वारमा गए, र भुइँसम्मै घोप्टो परे। अनि याहवेहको महिमा तिनीहरूकहाँ देखा पर्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“तेरो लहुरो लिएर तँ र तेरा दाजु हारूनले समुदायलाई एकसाथ भेला गराउनू। तिनीहरूको आँखाकै सामु त्यस चट्टानलाई आज्ञा दिनू। तब त्यस चट्टानबाट पानी निस्कनेछ। तैँले समुदायका लागि चट्टानबाट पानी निकाल्नेछस्। अनि तिनीहरू र तिनीहरूका गाईबस्तुहरूले पानी पिउनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","यसकारण मोशाले याहवेहको आज्ञाअनुसार उहाँकै सामु लहुरो लिए। ");
INSERT INTO npioncb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","मोशा र हारूनले समुदायलाई चट्टानको सामु भेला गराए; र मोशाले तिनीहरूलाई भने, “अब सुन, ए विद्रोहीहरूहो, हामीले तिमीहरूका निम्ति के यही चट्टानबाट पानी निकाल्नैपर्ने हो त?” ");
INSERT INTO npioncb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","तब मोशाले आफ्नो हात उचाले र त्यस चट्टानलाई आफ्नो लहुरोले दुई पटक हिर्काए। तब पानीको मूल फुटेर निस्क्यो। अनि समुदाय र तिनीहरूका गाईबस्तुहरूले पिए। ");
INSERT INTO npioncb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","तर याहवेहले मोशा र हारूनलाई भन्‍नुभयो, “इस्राएलीहरूका दृष्‍टिमा मेरो पवित्रता दर्शाउनलाई तिमीहरूले मलाई पूरा विश्‍वास गरेनौँ। यसकारण यस समुदायलाई मद्वारा दिइएको देशमा तिमीहरूले पुर्‍याउन पाउनेछैनौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","यो मेरीबाको चट्टानबाट निकालिएको पानी थियो, जहाँ इस्राएलीहरूले याहवेहसँग झगडा गरेका थिए। अनि त्यहाँ उहाँले तिनीहरूबीच आफूलाई पवित्र प्रमाणित गर्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशाले कादेशबाट एदोमका राजाकहाँ यसो भन्‍नलाई सन्देश वाहकहरू पठाए: “तपाईंका इस्राएली भाइले यसो भन्छन्: हामीमाथि परिआएको सङ्कष्‍ट तपाईं जान्‍नुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","हाम्रा पितापुर्खाहरू इजिप्टमा गएका थिए। हामी त्यहाँ धेरै वर्षसम्म बस्यौँ। इजिप्टियनहरूले हामी र हाम्रा पितापुर्खाहरूलाई दुर्व्यवहार गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","तर जब हामीले याहवेहलाई पुकार गर्‍यौँ, तब उहाँले हाम्रो पुकार सुन्‍नुभयो र एउटा स्वर्गदूत पठाउनुभयो, जसले हामीलाई इजिप्ट देशबाट बाहिर निकालेर ल्याउनुभयो। “अहिले हामी तपाईंको प्रान्तको सिमानामा पर्ने सहर कादेशमा छौँ। ");
INSERT INTO npioncb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","दया गरी हामीलाई तपाईंको देशबाट भएर जान दिनुहोस्। हामी कुनै खेत अथवा दाखबारीबाट भएर जानेछैनौँ, वा कुनै पनि कुवाबाट पानी पिउनेछैनौँ। हामी राजाको मूलबाटो भएर जानेछौँ। तपाईंको प्रान्तबाट पार नभएसम्म हामी दाहिने अथवा देब्रे फर्कनेछैनौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","तर एदोमले जवाफ दिए: “तिमीहरू यहाँबाट भएर जान पाउँदैनौँ। यदि तिमीहरूले त्यसो गर्‍यौ भने हामी तिमीहरूको विरुद्धमा मोर्चा बाँधेर तिमीहरूमाथि तरवारले आक्रमण गर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएलीहरूले जवाफ दिए: “हामी मूलबाटो भएर जानेछौँ। यदि हामी अथवा हाम्रा गाईबस्तुहरूले तपाईंको पानीबाट केही पियौँ भने हामी त्यसको मोल तिर्नेछौँ। हामी केवल पैदल भएर जान चाहन्छौँ—अरू केही पनि होइन।” ");
INSERT INTO npioncb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","एदोमीहरूले फेरि जवाफ दिए: “तिमीहरू हाम्रो देश भएर जान पाउँदैनौँ।” तब एदोम तिनीहरूको विरुद्धमा एउटा ठूलो र शक्तिशाली सेना लिएर निस्क्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोमले तिनीहरूलाई आफ्नो प्रान्तबाट भएर जान नदिएकोले इस्राएलीहरू तिनीहरूबाट फर्केर अर्को बाटो गए। ");
INSERT INTO npioncb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","सारा इस्राएली समुदाय कादेशबाट हिँडेर होर पर्वतमा आइपुगे। ");
INSERT INTO npioncb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","होर पर्वतमा एदोमको सिमानाको छेउमा याहवेहले मोशा र हारूनलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","हारून आफ्ना मानिसहरूकहाँ मिल्नेछ। मैले इस्राएलीहरूलाई दिने देशमा ऊ पस्‍नेछैन। किनकि तिमीहरू दुवैले मेरीबाको पानीमा मेरो आज्ञाको विरुद्धमा काम गरेका थियौ। ");
INSERT INTO npioncb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","हारून र त्यसको छोरो एलाजारलाई होर पर्वतसम्म लैजा। ");
INSERT INTO npioncb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","हारूनको पुजारी पोसाकहरू फुकाल् र ती त्यसको छोरो एलाजारलाई लगाइदे। किनकि हारून आफ्ना मानिसहरूसँग मिल्नेछ। त्यहाँ त्यसको मृत्यु हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","याहवेहले आज्ञा दिनुभएझैँ मोशाले गरे। सारा समुदायको आँखाको सामु तिनीहरू होर पर्वतमा उक्लेर गए। ");
INSERT INTO npioncb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मोशाले हारूनका पुजारी पोसाकहरू फुकाले। अनि ती तिनको छोरो एलाजारलाई लगाइदिए। तब त्यहीँ पर्वतको टाकुरामा हारूनको मृत्यु भयो। त्यसपछि मोशा र एलाजार पर्वतबाट तल ओर्लेर आए। ");
INSERT INTO npioncb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","अनि जब सारा समुदायले हारूनको मृत्युबारे थाहा पाए, तब सम्पूर्ण इस्राएलीहरूले तिनका निम्ति तीस दिनसम्म शोक गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","जब दक्षिणमा बस्‍ने आरादका कनानी राजाले इस्राएलीहरू अतारीम जाने बाटो भएर आउँदैछन् भन्‍ने सुने, तब तिनले इस्राएलीहरूमाथि आक्रमण गरेर केही मानिसहरूलाई पक्रेर बन्दी बनाए। ");
INSERT INTO npioncb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इस्राएलीहरूले याहवेहसँग यस्तो भाकल गरे: “यदि तपाईंले यी मानिसहरूलाई हाम्रो हातमा सुम्पिदिनुभयो भने हामी तिनीहरूका सहरहरू पूर्ण रूपले नष्‍ट पारिदिनेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","याहवेहले इस्राएलीहरूको बिन्ती सुन्‍नुभयो। अनि ती कनानीहरूलाई तिनीहरूका हातमा सुम्पिदिनुभयो। इस्राएलीहरूले एदोमीहरू र तिनीहरूका सहरहरूलाई पूर्ण रूपले नष्‍ट पारिदिए। अनि त्यस ठाउँको नाम होर्मा राखियो। ");
INSERT INTO npioncb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","तिनीहरूले होर पर्वतबाट लाल समुद्रतिरको बाटो भएर एदोमको प्रान्तलाई फेरो मार्दै यात्रा सुरु गरे। तर बाटोमा इस्राएली मानिसहरू अधैर्य भए। ");
INSERT INTO npioncb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","तिनीहरूले परमेश्‍वरको र मोशाको विरुद्धमा यसो भनेर गनगनाउन लागे, “तपाईंले हामीलाई इजिप्टबाट उजाडस्थानमा मर्नलाई किन ल्याउनुभयो? यहाँ खानेकुरा केही छैन; र पानी पनि छैन! अनि यस तुच्छ भोजनले हामी वाक्‍क भइसक्यौँ!” ");
INSERT INTO npioncb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","तब याहवेहले तिनीहरूको बीचमा विषालु सर्पहरू पठाइदिनुभयो। सर्पहरूले मानिसहरूलाई डसे; र धेरै इस्राएलीहरू मरे। ");
INSERT INTO npioncb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ती मानिसहरू मोशाकहाँ आएर बिन्ती गरे, “हामीले याहवेह र तपाईंको विरुद्धमा बोलेर पाप गरेका छौँ। याहवेहले यी सर्पहरू हामीबाट हटाइदेऊन् भनी प्रार्थना गरिदिनुहोस्।” यसकारण मोशाले मानिसहरूका निम्ति प्रार्थना गरिदिए। ");
INSERT INTO npioncb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","याहवेहले मोशालाई भन्‍नुभयो, “एउटा सर्प बनाएर त्यसलाई एउटा खाँबोमा राखिदिनू; तब सर्पले डसेका जो कोहीले काँसोको सर्पलाई हेर्छ, त्यो जीवित रहनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","यसकारण मोशाले एउटा काँसोको सर्प बनाएर त्यसलाई एउटा खाँबोमा राखिदिए। त्यसपछि जब कसैलाई सर्पले डस्थ्यो, तब त्यसले काँसोको सर्पलाई हेर्थ्यो, र त्यो बाँच्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इस्राएलीहरू अगि बढ्दै गए, र ओबोतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","त्यसपछि तिनीहरू ओबोतबाट हिँडे। अनि मोआबको सामु पूर्वतिरको सूर्य उदय हुने ठाउँतिर उजाडस्थानमा भएको इये-अबारीममा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","त्यहाँबाट तिनीहरू अगि बढ्दै गए। अनि जेरेदको बेँसीमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","तिनीहरू त्यहाँबाट पनि हिँडे। अनि एमोरीहरूको प्रान्तसम्म फैलिएको उजाडस्थानस्थित अर्नोनको किनारमा छाउनी हाले। अर्नोनचाहिँ मोआब र एमोरीहरूको बीचमा मोआबको सिमानामा पर्दछ। ");
INSERT INTO npioncb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","त्यसैकारण याहवेहका युद्धहरूको पुस्तकमा यसो लेखिएको छ: “सूपामा भएको याहेब सहर, अर्नोनका बेँसीहरू ");
INSERT INTO npioncb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","र बेँसीका भिरालाहरू, जो आरको सहरतिर लाग्दछन् र मोआबको सिमानासम्म पुगेका छन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","त्यहाँबाट तिनीहरू बेअरको त्यस इनारसम्म अगि बढे, जहाँ याहवेहले मोशालाई भन्‍नुभयो, “मानिसहरूलाई एकसाथ भेला गर्, र म तिनीहरूलाई पानी दिनेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","तब इस्राएलीहरूले यो गीत गाए: “ए इनार, फुटेर निस्की! यसको विषयमा गीत गा, ");
INSERT INTO npioncb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","जसलाई राजकुमारहरूले खनेका थिए, जसलाई कुलिन व्यक्तिहरूले खनेका थिए, जसलाई ती कुलिन व्यक्तिहरूका राजदण्ड र लहुरोले खनेका थिए।” त्यसपछि तिनीहरू उजाडस्थानबाट मत्तानातर्फ अगि बढे, ");
INSERT INTO npioncb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","अनि मत्तानाबाट नहलीएलमा, नहलीएलबाट बामोतमा आइपुगे। ");
INSERT INTO npioncb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","अनि बामोतबाट मोआबको बेँसी पिसगाको टाकुरामा आइपुगे, जहाँबाट उजाडभूमि देख्न सकिन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इस्राएलले एमोरीहरूका राजा सीहोनकहाँ यसो भन्‍नलाई सन्देश वाहकहरू पठाए: ");
INSERT INTO npioncb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हामीलाई तपाईंको देशबाट भएर जान दिनुहोस्। हामी कुनै खेत अथवा दाखबारीतिर फर्कनेछैनौँ अर्थात् कुनै इनारबाट पानी पिउनेछैनौँ। हामी तपाईंको सिमानाबाट भएर पार नभएसम्म राजाको मूलबाटो भएर यात्रा गर्नेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","तर सीहोनले आफ्नो सिमानाबाट भएर इस्राएलीहरूलाई छिरेर जान दिएनन्। तिनले आफ्नो सारा सेनालाई जम्मा गरे। अनि उजाडस्थानमा इस्राएलीहरूका विरुद्धमा मोर्चा बाँधे। जब तिनी यहस सहरमा आइपुगे, तब तिनीहरूले इस्राएलीहरूसँग युद्ध गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","तर इस्राएलीहरूले राजालाई तरवारले मारे। अनि अर्नोनदेखि यब्बोकसम्म तिनको देश कब्जा गरे। तैपनि अम्मोनीहरूको सिमानासम्म मात्र कब्जा गरे; किनभने अम्मोनीहरूको सिमाना बलियो किल्‍ला भएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इस्राएलले एमोरीहरूका सबै सहरहरू कब्जा गरे, र ती सहरहरूमा बसोबास गरे। हेश्बोन र त्यसका छेउछाउका सबै बस्तीहरूमा समेत बसोबास गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेश्बोनचाहिँ एमोरीहरूका राजा सीहोनको सहर थियो, जसले मोआबका अगिल्‍ला राजाको विरुद्धमा युद्ध गरेर तिनको सम्पूर्ण देश अर्नोनसम्मै लिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","त्यसैकारण कविहरूले यसो भन्छन्: “हेश्बोनमा आओ, र यो सहर पुनर्निर्माण होस्; सीहोनको सहर पुनर्स्थापित होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“हेश्बोनबाट आगो निस्केर गयो; सीहोनको सहरबाट एउटा ज्वाला निस्क्यो। यसले मोआबको आर सहरलाई भस्म पार्‍यो। अर्नोनका शिखरमा बस्‍नेहरूलाई भस्म पार्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ए मोआब, धिक्‍कार छ तँलाई! ए कमोशका मानिसहरू नष्‍ट पारिएका छौ! कमोशले आफ्ना छोराहरूलाई भगुवाझैँ, र आफ्नी छोरीहरूलाई कैदीझैँ गरेर एमोरीहरूको राजा सीहोनलाई दिएको छ। ");
INSERT INTO npioncb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“तर हामीले हेश्बोनीहरूलाई जितेका छौँ; हेश्बोनचाहिँ दीबोन सहरसम्मै नष्‍ट पारिएको छ। हामीले तिनीहरूलाई नोपाहसम्मै ध्वंस पारिदिएका छौँ, जुनचाहिँ मेदेबासम्म फैलिएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","यसरी इस्राएलीहरू एमोरीहरूको देशमा बसोबास गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मोशाले याजेरमा जासुस गर्न मानिसहरू पठाएपछि इस्राएलीहरूले त्यसका चारैतिरका बस्तीहरू कब्जा गरे। अनि त्यहाँ भएका एमोरीहरूलाई पनि धपाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","त्यसपछि तिनीहरू फर्केर बाशानतिरको बाटो भएर उक्ले। अनि बाशानका राजा ओग इस्राएलीहरूसँग युद्ध गर्न आफ्ना सारा सेना लिएर एद्रई सहरमा मोर्चा बाँधेर निस्के। ");
INSERT INTO npioncb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","याहवेहले मोशालाई भन्‍नुभयो, “त्यससँग नडरा; किनकि मैले त्यसलाई, त्यसका सबै सेनालाई र त्यसको देशसमेत तेरो हातमा सुम्पिदिएको छु। तैँले त्यसलाई हेश्बोनमा शासन गर्ने एमोरीहरूका राजा सीहोनलाई गरेजस्तै गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","यसकारण इस्राएलीहरूले राजालाई, तिनका छोराहरू र सारा सेनाहरूलाई एउटै पनि मानिस जीवित नरहुन्जेल एकैसाथ मारे। अनि तिनीहरूको देशलाई कब्जा गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","त्यसपछि इस्राएलीहरू यात्रा गर्दै मोआबको मैदानमा पुगे। अनि यरीहोको पारिपट्टि यर्दनको किनारमा छाउनी हालेर बसे। ");
INSERT INTO npioncb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","सिप्पोरका छोरा बालाकले इस्राएलीहरूले एमोरीहरूलाई गरेका सबै कुरा देखेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","अनि इस्राएलीहरूको संख्या धेरै भएकोले मोआबीहरू आतङ्कित भए। साँच्‍चै नै मोआब इस्राएलीहरूको कारण भयभीत भयो। ");
INSERT INTO npioncb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआबीहरूले मिद्यानका प्रधानहरूलाई भने, “यस समुदायले गोरुले चरनको घाँस स्वाहा पारेझैँ, हाम्रा चारैतिर भएका हरेक कुराहरूलाई स्वाहा पार्नेछ।” त्यस समयमा सिप्पोरका छोरा बालाक मोआबका राजा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","तिनले बओरका छोरा बालाम, जो आफ्नो जन्मस्थल यूफ्रेटिस नदीको छेउ पतोरमा बसेका थिए, उनलाई बोलाउन भनी राजदूतहरू पठाए। बालाकले भने: “इजिप्टबाट एउटा जाति निस्केर आएको छ; तिनीहरू पूरा देश नै ढाक्ने गरी मेरै सिमानामा आएर बसेका छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","अब तपाईं आउनुहोस्, र यी मानिसहरूलाई श्राप दिनुहोस्; किनकि तिनीहरू मेरा निम्ति अति नै शक्तिशाली छन्। सायद त्यसपछि भने म तिनीहरूलाई जित्न सकुँला र देशबाट धपाउन सकुँला। किनकि म जान्दछु, तपाईंले जसलाई आशिष् दिनुहुन्छ, तिनीहरूले आशिष् पाउँछन् र जसलाई श्राप दिनुहुन्छ, तिनीहरूले श्राप पाउँछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मोआब र मिद्यानका प्रधानहरू जोखना हेर्नका निम्ति दिइएको रकम लिएर गए। जब तिनीहरू बालामकहाँ आइपुगे, तब तिनीहरूले तिनलाई बालाकले भनेका कुरा भने। ");
INSERT INTO npioncb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बालामले तिनीहरूलाई भने, “आज राति यहीँ बस्‍नुहोस् र याहवेहले मलाई जे जवाफ दिनुहुन्छ, त्यो म तपाईंहरूलाई भन्‍नेछु।” यसकारण मोआबी अधिकारीहरू तिनीसित बास बसे। ");
INSERT INTO npioncb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेश्‍वर बालामकहाँ आउनुभयो र सोध्नुभयो, “तँसँग भएका यी मानिसहरू को हुन्?” ");
INSERT INTO npioncb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बालामले परमेश्‍वरलाई भने, “मोआबको राजा सिप्पोरका छोरा बालाकले यो समाचार पठाएको छ: ");
INSERT INTO npioncb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘इजिप्टबाट एउटा जाति आएर देश नै ढाकेको छ। अब आएर मेरा निम्ति तिनीहरूलाई श्राप दिनुहोस्; तब सायद म तिनीहरूसँग युद्ध गरेर तिनीहरूलाई धपाउन सकुँला।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","तर परमेश्‍वरले बालामलाई भन्‍नुभयो, “तँ तिनीहरूसँग नजानू। तैँले ती मानिसहरूलाई नसराप्नू; किनकि तिनीहरू आशिषित छन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","भोलिपल्ट बिहानै बालाम उठेर बालाकका अधिकारीहरूलाई भने, “तपाईंहरू आफ्नै देशमा फर्किजानुहोस्। किनकि याहवेहले मलाई तपाईंहरूसँग जानलाई अस्वीकार गर्नुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","यसकारण मोआबी अधिकारीहरूले बालाककहाँ फर्किगएर भने, “बालामले हामीसँग आउन अस्वीकार गरे।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","त्यसपछि बालाकले पहिलेको भन्दा बढी र अझ सम्मानित अधिकारीहरू पठाए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","तिनीहरू बालामकहाँ आएर भने: “सिप्पोरका छोरा बालाक यसो भन्‍नुहुन्छ: तपाईंलाई मकहाँ आउनलाई कुनै पनि कुराले नरोकोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","किनकि म तपाईंलाई ठूलो रकम दिनेछु; र तपाईंले जे भन्‍नुहुन्छ, त्यही गर्नेछु। आउनुहोस्, र मेरा निम्ति यी मानिसहरूलाई श्राप दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","तर बालामले तिनीहरूलाई जवाफ दिए, “यदि बालाकले मलाई सुन र चाँदीले भरिएको आफ्नो महल नै दिए तापनि याहवेह मेरा परमेश्‍वरको आज्ञाभन्दा बाहिर ठूलो होस् वा सानो, म कुनै काम गर्न सक्दिनँ। ");
INSERT INTO npioncb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","यसैले आज राति यहीँ बस्‍नुहोस्, ताकि मलाई याहवेहले अरू केही भन्‍नुहुन्छ कि सो पत्ता लगाउन सकूँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","त्यस रात परमेश्‍वर बालामकहाँ आउनुभयो र भन्‍नुभयो, “यी मानिसहरू तँलाई बोलाउन आएको कारण तिनीहरूसँग जान तयार हो, तर तैँलेचाहिँ मैले भनेको मात्र गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","बालाम बिहानै उठे, र आफ्नो गधामा काठी कसे। अनि मोआबका अधिकारीहरूसँग गए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","तर तिनी गएकोमा याहवेह साह्रै रिसाउनुभयो। अनि तिनको विरोध गर्नलाई याहवेहका दूत बाटोमा उभिए। बालाम आफ्नो गधामाथि थिए। अनि तिनका दुई सेवकहरू तिनीसँगै थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","जब त्यस गधाले याहवेहको दूतलाई तरवार हातमा लिएर बाटोमा उभिरहनुभएको देख्यो; तब त्यो बाटो छोडेर खेततिर लाग्यो। तर गधालाई बाटोमा ल्याउनलाई बालामले त्यसलाई पिटे। ");
INSERT INTO npioncb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","तब याहवेहका दुई स्वर्गदूत दाखबारीको बीचमा एउटा साँघुरो बाटोको दुवैतिरको पर्खालमा उभिए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","जब गधाले याहवेहको स्वर्गदूतलाई देख्यो, तब त्यो बालामको खुट्टा चेप्टाउँदै पर्खालमा ढेस्सियो। यसकारण तिनले गधालाई फेरि पिट्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","तब याहवेहको दूत अगि सरे, र दाहिने अथवा देब्रेतिर घुम्ने ठाउँ नै नभएको साँघुरो ठाउँमा उभिए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","जब गधाले याहवेहको दूतलाई देख्यो, तब त्यो भुइँमा थचक्‍क बस्यो। अनि बालाम रिसाए, र गधालाई आफ्नो लहुरोले पिट्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","तब याहवेहले गधाको मुख खोलिदिनुभयो, र त्यसले बालामलाई भन्यो, “मैले तपाईंको के बिगारेको छु, र तपाईंले मलाई यसरी तीनपल्ट चुट्नुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बालामले गधालाई जवाफ दिए, “तैँले मलाई मूर्ख बनाइस्! यदि मेरो हातमा तरवार मात्र भएको भए म तँलाई अहिले नै काट्नेथिएँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","तब गधाले बालामलाई भन्यो, “के तपाईंले आजसम्म चढ्नुभएको तपाईंको आफ्नो गधा म नै होइनँ र? के मैले कहिल्यै तपाईंसँग यस्तो व्यवहार गरेको थिएँ र?” बालामले त्यसलाई भने, “अहँ, गरेको थिइनस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","तब याहवेहले बालामका आँखा खोलिदिनुभयो। अनि तिनले याहवेहको स्वर्गदूतलाई हातमा तरवार लिएर बाटोमा उभिरहनुभएका देखे। यसकारण तिनी भुइँसम्मै घोप्टो परेर दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","याहवेहको स्वर्गदूतले तिनलाई सोधे, “तैँले आफ्नो गधालाई किन यसरी तीनपल्ट हिर्काइस्? म तेरो विरोध गर्न आएको छु। किनकि तेरो चाल मेरो इच्छा विपरीत छ। ");
INSERT INTO npioncb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","यस गधाले मलाई देखेर यसरी तीनपल्ट बाटो तर्क्यो। यदि त्यो नतर्केको भए मैले तँलाई अहिलेसम्म निश्‍चय नै मारिसकेको हुनेथिएँ। अनि त्यसलाई चाहिँ जीवितै छोड्नेथिएँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बालामले याहवेहको स्वर्गदूतलाई भने, “मैले पाप गरेको छु। मलाई रोक्न तपाईं बाटोमा उभिरहनुभएको मैले थाहै पाइनँ। अब यदि तपाईंको दृष्‍टिमा बेठीक छ भने म फर्केर जानेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","याहवेहका स्वर्गदूतले बालामलाई भने, “यी मानिसहरूसँग जा; तर मैले तँलाई भनेको कुरा मात्र भन्‍नू।” यसकारण बालाकका अधिकारीहरूसँग बालाम गए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बालाकले बालाम आउँदैछन् भन्‍ने कुरा सुने, तब तिनी उनलाई आफ्नो प्रान्तको किनारमा अर्नोनको सिमानामा भएको मोआबी सहरमा भेट्नलाई निस्के। ");
INSERT INTO npioncb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाकले बालामलाई भने, “के मैले तपाईंलाई जरुरी सन्देश पठाइनँ र? तर तपाईं मलाई भेट्नलाई किन आउनुभएन? के साँच्‍चै मैले तपाईंलाई इनाम दिन सक्दिनँ जस्तो लाग्यो?” ");
INSERT INTO npioncb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","बालामले जवाफ दिए, “हेर्नुहोस्, अहिले म तपाईंकहाँ आएको छु। तर मलाई जे मन लाग्यो, त्यो भन्‍न सक्दिनँ। मैले त याहवेहले मेरो मुखमा जे हालिदिनुहुन्छ, त्यही मात्र भन्‍नुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","तब बालाम बालाकसँग किर्यत-हुस्सोतको सहरमा गए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","बालाकले गाईबस्तु र भेडाको बलि चढाए। अनि केही बालामलाई र तिनीसँग हुने अधिकारीहरूलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","भोलिपल्ट बिहानै बालाकले बालामलाई बामोत-बालको शिखरमा लगे। अनि त्यहाँबाट तिनले इस्राएलीहरूको छाउनीको बाहिरी भाग देखे। ");
INSERT INTO npioncb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बालामले बालाकलाई भने, “मेरा निम्ति यहाँ सात वटा वेदीहरू बनाउनुहोस्। अनि मेरा निम्ति सात वटा साँढे र सात वटा भेडा तयार पार्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालामले भनेजस्तै बालाकले गरे, र ती दुवै जनाले प्रत्येक वेदीमा एउटा साँढे र एउटा भेडा चढाए। ");
INSERT INTO npioncb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","तब बालामले बालाकलाई भने, “तपाईं यहाँ आफ्नो होमबलिको नजिक उभिनुहोस्। अनि मचाहिँ अलि पर जान्छु। सायद याहवेह मसँग भेट गर्न आउनुहुनेछ। उहाँले मलाई जे प्रकाश गर्नुहुन्छ, म तपाईंलाई भन्‍नेछु।” तब तिनी एउटा उजाड-डाँडातिर गए। ");
INSERT INTO npioncb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","परमेश्‍वरले तिनीसँग भेट गर्नुभयो र बालामले उहाँलाई भने, “मैले सात वटा वेदीहरू तयार गराएँ; र प्रत्येक वेदीमा एउटा साँढे र एउटा भेडा चढाएँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","याहवेहले बालामको मुखमा सन्देश हालिदिनुभयो र भन्‍नुभयो, “बालाककहाँ फर्केर जा, र त्यसलाई यो सन्देश दिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","यसकारण बालाम बालाककहाँ फर्केर गए। अनि मोआबका राजा र सबै अधिकारीहरूसँग आफ्नो होमबलिको छेउमा उभिरहेका भेट्टाए: ");
INSERT INTO npioncb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तब बालामले आफ्नो सन्देश सुरु गरे: “बालाकले मलाई अरामबाट यहाँ ल्याए; मोआबका राजाले पूर्वका पर्वतहरूबाट बोलाए। तिनले भने, ‘आउनुहोस्, र मेरा निम्ति याकोबलाई श्राप दिनुहोस्: आउनुहोस् र इस्राएललाई धिक्‍कार्नुहोस्।’ ");
INSERT INTO npioncb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","परमेश्‍वरले जसलाई श्राप दिनुभएन, तिनीहरूलाई मैले कसरी श्राप दिऊँ? याहवेहले जसलाई धिक्‍कार्नुभएन, मैले कसरी धिक्‍कारूँ? ");
INSERT INTO npioncb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","मैले तिनीहरूलाई चट्टानको शिखरबाट हेरेँ; अग्ला ठाउँहरूबाट मैले तिनीहरूलाई देखेँ। मैले एउटा अलग्गै बस्‍ने जातिलाई देखेँ; तिनीहरूले आफूलाई अरू जातिहरूजस्ता ठान्दैनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकोबको धुलोलाई कसले गन्‍न सक्छ, अथवा इस्राएलको चौथो भाग मात्रैलाई पनि कसले गन्‍न सक्छ? मेरो मृत्यु पनि धर्मी मानिसको मृत्युझैँ होस्! र मेरो जीवनको अन्त्य तिनीहरूको जस्तै होस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","बालाक राजाले बालामलाई भने, “तपाईंले मलाई के गर्नुभयो? मैले तपाईंलाई मेरा शत्रुहरूलाई सराप्नलाई बोलाएको हुँ, तर तपाईंले त केही नगरेर तिनीहरूलाई आशिष् पो दिनुभएको छ!” ");
INSERT INTO npioncb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बालामले जवाफ दिए, “याहवेहले मेरो मुखमा जे दिनुभएको छ, के मैले त्यही बोल्नुपर्दैन र?” ");
INSERT INTO npioncb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","त्यसपछि बालाकले तिनलाई भने, “मसँग अर्को ठाउँमा आउनुहोस्, जहाँबाट तपाईंले तिनीहरूलाई देख्न सक्नुहुन्छ। तपाईंले तिनीहरू सबैलाई होइन, तर तिनीहरूका छाउनीको बाहिरी भाग मात्र देख्न सक्नुहुन्छ। अनि त्यहाँबाट तपाईंले मेरा निम्ति तिनीहरूलाई श्राप दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","यसकारण बालाक राजाले बालामलाई पिसगाको टुप्पोमा सोफिमको मैदानमा लगे, र त्यहाँ तिनले सात वटा वेदीहरू बनाए। अनि प्रत्येक वेदीमा एउटा साँढे र एउटा भेडा चढाए। ");
INSERT INTO npioncb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","बालामले बालाक राजालाई भने, “तपाईं यहाँ आफ्नो होमबलिको नजिक उभिनुहोस्। अनि मचाहिँ उहाँलाई त्यहाँ पर भेट्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","याहवेहले बालामसँग भेट गर्नुभयो, र तिनको मुखमा सन्देश दिएर भन्‍नुभयो, “बालाककहाँ फर्केर जा, र त्यसलाई यो सन्देश दे।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","यसकारण तिनी बालाककहाँ गए। अनि उनलाई मोआबका अधिकारीहरूसँग आफ्नो होमबलिको छेउमा उभिरहेका भेट्टाए। बालाकले तिनलाई सोधे, “याहवेहले के भन्‍नुभयो?” ");
INSERT INTO npioncb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","तब बालामले यसरी आफ्नो सन्देश बोले: “ए बालाक उठ्, र सुन्; ए सिप्पोरका छोरा मेरा कुरा सुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्‍वर मानिसजस्तो हुनुहुन्‍न, उहाँले झूट बोल्नुहुन्‍न; उहाँ कुनै मानिसको पुत्रजस्तो हुनुहुन्‍न, जसले आफ्नो मन बदली गर्नुहुन्छ। के उहाँले बोल्नुभएपछि काम गर्नुहुन्‍न र? के उहाँले प्रतिज्ञा गर्नुभएपछि पूरा गर्नुहुन्‍न र? ");
INSERT INTO npioncb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","मैले आशिष् दिनू भन्‍ने आज्ञा पाएको छु; उहाँले आशिष् दिनुभएको छ, र म यसलाई बदली गर्न सक्दिनँ। ");
INSERT INTO npioncb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“याकोबमा कुनै दुष्‍टता देखिँदैन, इस्राएलमा कुनै विपत्ति देखिँदैन। याहवेह तिनीहरूका परमेश्‍वर तिनीहरूसँग हुनुहन्छ; राजाको विजय-ध्वनि तिनीहरूको बीचमा छ। ");
INSERT INTO npioncb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्‍वरले तिनीहरूलाई इजिप्टबाट निकाल्नुभयो; तिनीहरूसँग जङ्गली साँढेको शक्ति छ। ");
INSERT INTO npioncb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकोबको विरुद्धमा कुनै तन्त्रमन्त्र छैन। इस्राएलको विरुद्धमा कुनै टुनामुनाले काम गर्दैन। अब याकोबको विषयमा र इस्राएलको विषयमा यसो भनिनेछ, ‘परमेश्‍वरले के गर्नुभएको छ, त्यो हेर!’ ");
INSERT INTO npioncb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","यो जाति सिंहनीझैँ उठ्छन्; तिनीहरूले आफूलाई सिंहझैँ उत्तेजित पार्दछन्, जसले आफ्नो शिकार नखाउन्जेल र आफ्नो शिकारको रगत नपिउन्जेल विश्राम लिदैनन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","तब बालाक राजाले बालामलाई भने, “तिनीहरूलाई श्राप नदिनुहोस्, र तिनीहरूलाई आशिष् पनि नदिनुहोस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बालामले बालाकलाई जवाफ दिए, “याहवेहले मलाई जे भन्‍नुहुन्छ, त्यही कुरा भन्‍नुपर्छ भनेर के मैले तपाईंलाई भनेको थिइनँ र?” ");
INSERT INTO npioncb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","त्यसपछि बालाक राजाले बालामलाई भने, “आउनुहोस्, म तपाईंलाई अर्को ठाउँमा लैजानेछु। सायद त्यहाँबाट तपाईंले तिनीहरूलाई मेरा निम्ति सरापेकोमा परमेश्‍वर खुशी हुनुहोला कि।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","अनि बालाकले बालामलाई पोरको टुप्पामा लगे, जहाँबाट उजाडभूमि देखिन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","तब बालामले बालाकलाई भने, “मेरा लागि यहाँ सात वटा वेदीहरू बनाउनुहोस्। अनि मेरा निम्ति सात वटा साँढेहरू र सात वटा भेडाहरू तयार पार्नुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बालामले भनेजस्तै बालाकले गरे। अनि प्रत्येक वेदीमा एउटा साँढे र एउटा भेडा चढाए। ");
INSERT INTO npioncb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","जब बालामले इस्राएललाई आशिष् दिँदा याहवेह प्रसन्‍न हुनुहुन्छ भन्‍ने कुरा थाहा पाए, तब तिनले अरू बेलाजस्तै टुनामुना गरेनन्। तर तिनले आफ्नो अनुहार उजाडस्थानतिर फर्काएर हेरे। ");
INSERT INTO npioncb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","जब तिनले इस्राएलीहरूलाई कुल-कुलअनुसार पाल टाँगेर बसेको देखे; तब परमेश्‍वरका आत्मा बालाममाथि आउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","अनि तिनले आफ्नो सन्देश भन्‍न थाले: “बओरका छोरा बालामको अगमवाणी, उसको अगमवाणी जसको आँखाले स्पष्‍ट गरी देख्छ; ");
INSERT INTO npioncb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","उसको अगमवाणी, जसले परमेश्‍वरको वचन सुन्छ, जसले सर्वशक्तिमान्‌बाट दर्शन देख्छ, जसले झुकेर दण्डवत् गर्दछ, र जसका आँखा खुल्‍ला रहन्छन्: ");
INSERT INTO npioncb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“हे याकोब, तेरा पालहरू, हे इस्राएल, तेरा पवित्र वासस्थानहरू कति सुन्दर छन्! ");
INSERT INTO npioncb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“टाढासम्म फैलिएका बेँसीहरूझैँ, नदीको छेउमा भएका बगैँचाहरूझैँ, याहवेहद्वारा रोपिएका एलवाहरूझैँ, पानीको छेउमा भएका देवदारुहरूझैँ। ");
INSERT INTO npioncb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","तिनीहरूका भाँडाहरूबाट पानी बगेर निस्कनेछ; तिनीहरूका बिउले प्रशस्त पानी पाउनेछन्। “तिनीहरूका राजा अगागभन्दा महान् हुनेछन्; तिनीहरूको राज्य उच्‍च पारिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“परमेश्‍वरले तिनीहरूलाई इजिप्टबाट निकालेर ल्याउनुभयो; तिनीहरूसँग जङ्गली साँढेको शक्ति छ। तिनीहरूले विरोधी राष्ट्रहरूलाई निल्छन्, र तिनीहरूका हड्डीहरू टुक्रा-टुक्रा पार्छन्; तिनीहरूका काँडले तिनीहरूलाई छेड्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","तिनीहरू सिंहजस्तै पल्टिरहेका छन्, र विश्राम गर्दछन्, एउटी सिंहनीजस्तै—कसले तिनीहरूलाई उठाउने आँट गर्ला र? “तिमीहरूलाई आशिष् दिनेहरू आशिषित होस्, र तिमीहरूलाई सराप्नेहरू श्रापित होस्!” ");
INSERT INTO npioncb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","त्यसपछि बालाक राजाको क्रोध बालामप्रति दन्क्यो। तिनले आफ्ना हातहरू एकसाथ ठटाएर बालामलाई भने, “मैले तपाईंलाई मेरा शत्रुहरूलाई सराप्न बोलाएँ, तर तपाईंले तिनीहरूलाई यसरी तीनपल्ट आशिष् दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","अब झट्टै यस ठाउँलाई छोडेर घर गइहाल्नुहोस्! तपाईंलाई ठूलो रकम दिन्छु भनी मैले सोचेको थिएँ। तर याहवेहले तपाईंलाई रकम पाउनबाट रोक्नुभएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बालामले बालाक राजालाई जवाफ दिए, “के तपाईंले पठाउनुभएका सन्देश वाहकहरूलाई मैले भनेको थिइनँ, ");
INSERT INTO npioncb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘यदि बालाकले मलाई सुन र चाँदीले भरिएको आफ्नो महल नै दिनुभए तापनि याहवेहको आज्ञादेखि बाहिर असल वा खराब म आफ्नो तर्फबाट केही गर्न सक्दिनँ। अनि मैले याहवेहले भन्‍नुभएको कुरा मात्र भन्‍नुपर्छ भनेर भनेको थिइनँ र?’ ");
INSERT INTO npioncb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","अब म आफ्नै मानिसहरूकहाँ फर्किजाँदैछु। तर सुन्‍नुहोस्, यी इस्राएली जातिले आउने दिनहरूमा तपाईंका जातिलाई के गर्नेछन्, सो चेतावनी दिन्छु।” ");
INSERT INTO npioncb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","तब बालामले आफ्नो सन्देश भने: “बओरका छोरा बालामको अगमवाणी, उसको अगमवाणी, जसको आँखाले स्पष्‍ट गरी देख्छ; ");
INSERT INTO npioncb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","उसको अगमवाणी, जसले परमेश्‍वरले भन्‍नुभएको वचन सुन्छ, जससँग सर्वशक्तिमान् परमेश्‍वरको ज्ञान छ; जसले सर्वोच्‍चबाट दर्शन देख्छ: जसले झुकेर दण्डवत् गर्छ, र जसका आँखा खुल्‍ला रहन्छन्: ");
INSERT INTO npioncb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“म उहाँलाई देख्छु, तर अहिले होइन; म उहाँलाई हेर्छु, तर नजिकै त होइन। याकोबबाट एउटा तारा निस्कनेछ; इस्राएलबाट एउटा राजदण्ड उठ्नेछ। अनि त्यसले मोआबका निधारहरू र शेतका सबै मानिसहरूका टाउको कुच्याउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोम पराजित हुनेछ; त्यसको शत्रु सेइर पराजित हुनेछ। तर इस्राएलचाहिँ बलियो हुँदै जानेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकोबबाट एउटा शासक निस्कनेछ। अनि त्यसले सहरका बाँचेकाहरूलाई नाश गर्नेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","तब बालामले अमालेकलाई देखेर आफ्नो सन्देश भने: “अमालेक राष्ट्रहरूमा पहिलो थियो, तर तिनीहरूको अन्त्य पूर्ण रूपमा विनाश हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","तब तिनले केनीहरूलाई देखेर आफ्नो सन्देश भने: “तेरो बस्‍ने स्थान सुरक्षित छ; तेरो गुँड चट्टानमा बसालिएको छ; ");
INSERT INTO npioncb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तरै पनि जब अश्शूरले तिमीहरूलाई कैद गरेर लैजान्छन् तिमी केनीहरू नष्‍ट हुनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","तब बालामले सन्देश गरे: “हाय! परमेश्‍वरले यसो गर्नुहुँदा को जीवित रहन सक्छ? ");
INSERT INTO npioncb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","जहाजहरू कित्तीम किनारबाट आउनेछन्; तिनीहरूले अश्शूर र एबेरलाई दमन गर्नेछन्। तर तिनीहरू पनि नष्‍ट हुनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","त्यसपछि बालाम उठे, र आफ्नो घरतिर फर्के। अनि बालाक पनि आफ्नो बाटो लागे। ");
INSERT INTO npioncb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","जब इस्राएलीहरू शित्तीमको बेँसीमा बसे, तब मोआबी स्त्रीहरूसँग अनैतिक यौन सम्बन्ध राख्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ती स्त्रीहरूले आफ्ना देवताहरूका निम्ति बलि चढाउनलाई तिनीहरूलाई निम्तो दिए। ती पुरुषहरूले ती देवताहरूलाई चढाइएको खानेकुरा खाए। अनि ती देवताहरूको सामु दण्डवत् गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","यसरी इस्राएलीहरूले आफैँलाई पोरको बाल-देवताको पूजामा सहभागी गराए। अनि याहवेहको क्रोध तिनीहरूको विरुद्धमा दन्क्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","याहवेहले मोशालाई भन्‍नुभयो, “यी मानिसहरूका सबै अगुवाहरूलाई लगेर मार्नू, र दिउँसोको घाममा याहवेहको सामु झुण्ड्याउनू; ताकि याहवेहको भयानक क्रोध इस्राएलीहरूबाट हटेर जाओस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","अनि मोशाले इस्राएलका न्यायकर्ताहरूलाई भने, “तिमीहरू हरेकले तिमीहरूका मानिसहरू, जसले आफूलाई पोरको बाल-देवताको पूजामा सहभागी गराएका छन्, तिनीहरूलाई मार्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","तब इस्राएलीहरू भेट हुने पालको प्रवेशद्वारमा रोइरहेका अवस्थामा एक जना इस्राएली पुरुषले मोशा र सारा इस्राएली समुदायको आँखाकै सामु एउटी मिद्यानी स्त्रीलाई आफ्नो पालमा ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","जब एलाजारका छोरा, पुजारी हारूनका नाति पीनहासले त्यो देखे, तब तिनी समुदायको माझबाट उठे, र आफ्नो हातमा भाला लिए। ");
INSERT INTO npioncb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","अनि त्यसपछि तिनी इस्राएली पुरुषलाई पछ्याउँदै पालभित्र पसे। तिनले ती दुवै इस्राएली पुरुष र त्यस स्त्रीको भुँडीमा वारपार हुने गरी भाला रोपिदिए। तब इस्राएलीहरूको विरुद्धमा आएको विपत्ति थामियो। ");
INSERT INTO npioncb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","तर त्यस विपत्तिबाट मर्नेहरूको संख्या 24,000 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“पुजारी हारूनको नाति, एलाजारका छोरा पीनहासले इस्राएलीहरूबाट मेरो क्रोध हटाइदियो। किनकि तिनीहरूबीच मेरो आदरका निम्ति त्यो मजस्तै जोशिलो भयो। यसैकारण मैले आफ्नो रिसमा तिनीहरूलाई सर्वनाश गरिनँ। ");
INSERT INTO npioncb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","यसकारण त्यसलाई भन्, म मेरो शान्तिको करार त्यससँग बाँध्दछु। ");
INSERT INTO npioncb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","त्यो र त्यसका सन्तानहरू अनन्तसम्म पुजारीगिरीको करारमा हुनेछन्। किनकि त्यो आफ्नो परमेश्‍वरको आदरका निम्ति जोशिलो भयो र त्यसले इस्राएलीहरूका लागि प्रायश्‍चित गर्‍यो।” ");
INSERT INTO npioncb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","मिद्यानी स्त्रीसँग मारिने इस्राएली पुरुषको नाम जिम्री थियो, जसको पिताका नाम सालू थियो। त्यो शिमियोनीहरूका घरानाका अगुवा थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","अनि त्यो मारिने मिद्यानी स्त्रीको नाम कोज्बी थियो, जो सूरकी छोरी थिई। सूरचाहिँ मिद्यानी घरानाका मुखिया थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानीहरूलाई शत्रुलाई झैँ आक्रमण गर्, र तिनीहरूलाई मार्। ");
INSERT INTO npioncb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","किनभने तिनीहरूले तिमीहरूलाई शत्रुझैँ ठानी छल गरेर पोरमा मिद्यानी अगुवाकी छोरी कोज्बीलाई चलाएर तिमीहरूलाई फसाए। अनि जसको परिणाम स्वरूप विपत्ति आइपर्दा त्यो स्त्रीको मृत्यु भयो।” ");
INSERT INTO npioncb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","विपत्तिपछि याहवेहले मोशा र पुजारी हारूनका छोरा एलाजारलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“सारा इस्राएली समुदायलाई तिनीहरूका परिवारअनुसार, बीस वर्ष र त्यसभन्दा बढी उमेरका इस्राएलका सेनामा सेवा गर्न सक्नेहरूको जनगणना गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","यसकारण यरीहोदेखि पारिपट्टि यर्दन नदीको छेउमा भएको मोआबको मैदानमा मोशा र पुजारी एलाजारले तिनीहरूसँग कुरा गरेर यसो भने, ");
INSERT INTO npioncb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“याहवेहले मोशालाई आज्ञा दिनुभएझैँ बीस वर्ष र त्यसभन्दा बढी उमेरका मानिसहरूको जनगणना गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","इस्राएलका जेठा छोरा रूबेनका सन्तानहरू यिनै हुन्: हानोकबाट हानोकीहरूको वंश; पल्‍लूबाट पल्‍लूईहरूको वंश; ");
INSERT INTO npioncb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोनबाट हेस्रोनीहरूको वंश; कर्मीबाट कर्मीहरूको वंश; ");
INSERT INTO npioncb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","यिनीहरू नै रूबेनी वंशबाट थिए। गन्ती गरिएको संख्या 43,730 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्‍लूका छोरा एलिआब थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","अनि एलिआबका छोराहरू नमूएल, दातान र अबीराम थिए। यी तिनै दातान र अबीराम हुन्, जो समुदायका अधिकारीहरू थिए; जसले कोरहको पछि लागेर याहवेहको विरुद्धमा खडा हुँदै, मोशा र हारूनको विरोध गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","तिनीहरूलाई कोरहसँगै धर्तीले आफ्नो मुख खोलेर निलेको थियो, कोरहको पछि लाग्ने 250 मानिसहरूलाई आगोले भस्म पारेको थियो। अनि त्यो घटना सारा इस्राएलमा चेतावनीको चिन्ह भयो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","तरै पनि कोरहको पूरै वंशचाहिँ लोप भएर गएन। ");
INSERT INTO npioncb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमियोनका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: नमूएलबाट नमूएलीको वंश; यामीनबाट यामीनीको वंश; याकीनबाट याकीनीको वंश; ");
INSERT INTO npioncb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरहबाट जेरहीको वंश; शाऊलबाट शाऊलीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","शिमियोनका घरानाहरू यिनै हुन्: तिनीहरूको संख्या 22,200 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गादका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: सपोनबाट सपोनीहरूको वंश; हाग्गीबाट हाग्गीहरूको वंश; शूनीबाट शूनीहरूको वंश; ");
INSERT INTO npioncb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओज्नीबाट ओज्नीहरूको वंश; एरीबाट एरीहरूको वंश; ");
INSERT INTO npioncb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोदीबाट अरोदीहरूको वंश; अरेलीबाट अरेलीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गादका वंशहरू यिनै हुन्; तिनीहरू संख्या 40,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","एर र ओनान यहूदाका छोराहरू थिए, तर तिनीहरू कनानमै मरे। ");
INSERT INTO npioncb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदाका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: शेलहबाट शेलानीहरूको वंश; पेरेसबाट पेरेसीहरूको वंश; जेरहबाट जेरहीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेसका सन्तानहरू यिनै हुन्: हेस्रोनबाट, हेस्रोनीहरूको वंश; हामूलबाट, हामूलीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यहूदाका वंशहरू यिनै हुन्; तिनीहरूको संख्या 76,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्साखारका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: तोलाबाट तोलाहीहरूको वंश; पुवाहबाट पुवातीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूबबाट याशूबीहरूको वंश; शिम्रोनबाट शिम्रोनीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्साखारका वंशहरू यिनै हुन्; तिनीहरूको संख्या 64,300 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबूलूनका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: सेरेदबाट सेरेदीहरूको वंश; एलोनबाट एलोनीहरूको वंश; यहलेलबाट यहलेलीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","जबूलूनका वंशहरू यिनै हुन्, तिनीहरूको संख्या 60,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","योसेफका कुलबाट मनश्शे र एफ्राइम थिए। तिनीहरूका वंशअनुसार यिनै हुन्: ");
INSERT INTO npioncb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शेका सन्तानहरू: माकीरबाट माकीरीहरूको वंश; (माकीर गिलादका पिता थिए); गिलादबाट गिलादीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलादका सन्तानहरू यिनै थिए: ईएजेरबाट ईएजेरीहरूको वंश; हेलेकबाट हेलेकीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रीएलबाट अस्रीएलीहरूको वंश; शेकेमबाट शेकेमीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शमीदाबाट शमीदीहरूको वंश; हेपेरबाट हेपेरीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(हेपेरको छोरो सलोफादका कुनै छोराहरू थिएनन्। तिनका छोरीहरू मात्र थिए। तिनीहरूका नाम महला, नोआ, होग्ला, मिल्का र तिर्सा थिए।) ");
INSERT INTO npioncb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","मनश्शेका वंशका सन्तानहरू यिनै थिए; तिनीहरूको संख्या 52,700 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एफ्राइमका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: शूतेलहबाट शूतेलहीहरूको वंश; बेकेरबाट बेकेरीहरूको वंश; तहनबाट तहनीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","शूतेलहका सन्तानहरू यिनै थिए: एरानबाट एरेनीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एफ्राइमका वंशहरू यिनै थिए; तिनीहरूको संख्या 32,500 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बेन्यामीनका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: बेलाबाट बेलाहीहरूको वंश; अश्बेलबाट अश्बेलीहरूको वंश; अहीरामबाट अहीरामीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शूपामबाट शू्पामीहरूको वंश; हूफामबाट हूफामीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","आर्द र नामानबाट बेलाका सन्तानहरू यिनै थिए: अर्दबाट अर्दीहरूको वंश; नामानबाट नामानीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","बेन्यामीनका वंशहरू यिनै हुन्, तिनीहरूको संख्या 45,600 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दानका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: शूहामबाट, शूहामीहरूको वंश, ");
INSERT INTO npioncb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","तिनीहरू सबै शूहामी वंशहरू थिए; र तिनीहरूको संख्या 64,400 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेरका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: यिम्नाबाट यिम्नीहरूको वंश; यिश्‍वीबाट यिश्‍वीहरूको वंश; बेरियाहबाट बेरियातीहरूको वंश; ");
INSERT INTO npioncb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","अनि बेरियाहका सन्तानहरूबाट: हेबेरबाट हेबेरीहरूको वंश; मल्कीएलबाट मल्कीएलीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेरकी सेरह नाम भएकी एउटी छोरी थिइन्। ");
INSERT INTO npioncb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","आशेरका वंशहरू यिनै हुन्, तिनीहरूको संख्या 53,400 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नप्‍तालीका सन्तानहरू तिनीहरूका वंशअनुसार यिनै थिए: यहसेलबाट यहसेलीहरूको वंश; गुनीबाट गुनीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेरबाट येसेरीहरूको वंश; शिल्‍लेमबाट शिल्‍लेमीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","नप्‍तालीका वंशहरू यिनै हुन्; तिनीहरूको संख्या 45,400 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस्राएलका सम्पूर्ण मानिसहरूको संख्या 6,01,730 थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“देशचाहिँ पैतृक सम्पत्तिको रूपमा तिनीहरूको नामको संख्याको आधारमा तिनीहरूलाई बाँडिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ठूलो दल हुनेलाई ठूलो भाग र सानो दल हुनेलाई सानै भाग दिनू। सूचीमा भएका संख्याअनुसार हरेकले आफ्नो पैतृक सम्पत्तिको भाग पाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","जमिन निश्‍चित रूपमा चिट्ठा हालेर मात्र बाँड्नू। हरेक दलले पाउने भाग तिनीहरूको पैतृक कुलको नामअनुसार हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","हरेक भाग ठूला र साना दलअनुसार चिट्ठा हालेर बाँडिदिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","तिनीहरूका वंशअनुसार गनिएका लेवीहरू यिनै थिए: गेर्शोनीबाट गेर्शोनीहरूको वंश; कहातबाट कहातीहरूको वंश; मरारीबाट मरारीहरूको वंश। ");
INSERT INTO npioncb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","यिनीहरू पनि लेवी वंशका नै थिए: लिब्नीहरूको वंश, हेब्रोनीहरूको वंश, महलीहरूको वंश, मूशीहरूको वंश, कोरहीहरूको वंश। (कहातचाहिँ अम्रामका पुर्खा थिए, ");
INSERT INTO npioncb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्रामकी पत्नीको नाम योकेबेद थियो, जोचाहिँ लेवीकी छोरी, इजिप्टमा लेवीका घरानामा जन्मेकी थिइन्। तिनले अम्रामबाट हारून, मोशा र तिनीहरूकी दिदी मिरियमलाई जन्माइन्। ");
INSERT INTO npioncb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","हारूनचाहिँ नादाब, अबीहू, एलाजार र ईतामारका पिता थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","तर नादाब र अबीहूको मृत्यु भयो। किनकि तिनीहरूले याहवेहको सामु आज्ञा नगरिएको आगोमा भेटी चढाएका थिए।) ");
INSERT INTO npioncb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","एक महिना र त्यसभन्दा बढी उमेरका लेवी पुरुषहरूको संख्या 23,000 थियो। तिनीहरू अरू इस्राएलीहरूसँग गनिएनन्। किनकि लेवीहरूले अरू इस्राएलीहरूसँग कुनै पैतृक सम्पत्ति पाएनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मोशा र पुजारी एलाजारले, यरीहोको पारिपट्टि यर्दन नदीको छेउमा पर्ने मोआबको मैदानमा गन्ती गरेका इस्राएलीहरू यिनीहरू नै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","यहाँ गन्ती भएकाहरूमा मोशा र पुजारी हारूनले सीनैको उजाडस्थानमा गन्ती गरेका इस्राएलीहरूमध्येका एउटै पनि त्यहाँ थिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","किनकि याहवेहले ती इस्राएलीहरूलाई भन्‍नुभएको थियो: तिनीहरू निश्‍चय नै उजाडस्थानमा मर्नेछन्। अनि तिनीहरूमध्ये यपून्‍नेका छोरा कालेब र नूनका छोरा यहोशूबाहेक एकै जना पनि जीवित रहेनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","सलोफाद योसेफका छोरा मनश्शे वंशका थिए। मनश्शेका छोरा माकीर, माकीरका छोरा गिलाद, गिलादका छोरा हेपेर र हेपेरका छोरा सलोफाद थिए। सलोफादका छोरीहरू महला, नोआ, होग्ला, मिल्का र तिर्सा थिए। तिनीहरू भेट हुने पालको प्रवेशद्वारमा आए। ");
INSERT INTO npioncb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","अनि मोशा, पुजारी एलाजार, अगुवाहरू र सारा समुदायको सामु भेट हुने पालको ढोकामा उभिएर भने, ");
INSERT INTO npioncb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हाम्रा बुबा उजाडस्थानमा मर्नुभयो। उहाँ याहवेहको विरुद्धमा दल बनाउने कोरहसँग हुनुहुन्‍नथ्यो; तर उहाँको आफ्नै पापको कारण मृत्यु भयो। उहाँका कुनै पनि छोराहरू थिएनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","हाम्रा बुबाको छोरा छैन भनेर आफ्नो वंशबाट उहाँको नामलाई किन मेटाउनू? हामीलाई हाम्रा बुबाका आफन्तहरूसँगै अंश दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","यसकारण मोशाले तिनीहरूको मुद्दा याहवेहका सामु ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","अनि याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलोफादका छोरीहरूले जे भनिरहेका छन्, त्यो सही हो। तैँले तिनीहरूलाई निश्‍चय नै तिनीहरूका बुबाका आफन्तहरूका बीचमा पैतृक सम्पत्तिको रूपमा अंश दिनू; र तिनीहरूलाई तिनीहरूका बुबाका उत्तराधिकार बनाइदिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","इस्राएलीहरूलाई भन्, “यदि कुनै मानिस मर्छ, र त्यसको कुनै छोरा छैन भने त्यसको सम्पत्ति त्यसका छोरीलाई नै नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","यदि त्यसको कुनै छोरी पनि छैन भने त्यसको अंश त्यसको दाजुभाइलाई दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","यदि त्यसको दाजुभाइ पनि छैनन् भने त्यसको अंश त्यसको बुबाका दाजुभाइलाई दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","यदि त्यसको बुबाका दाजुभाइ पनि छैनन् भने त्यसको अंश त्यसको वंशमा भएको सबैभन्दा नजिकको आफन्तलाई दिनू; ताकि त्यस अंशमा त्यसको अधिकार होस्। याहवेहले मोशालाई आज्ञा दिनुभएझैँ इस्राएलीहरूका निम्ति यो एउटा लागू गरिने कानुन होस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","याहवेहले मोशालाई भन्‍नुभयो, “अबारीमको पहाडमा उक्लेर जा, र मैले इस्राएलीहरूलाई दिएको देशलाई हेर्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","तैँले त्यो हेरेपछि तँ पनि तेरा दाजु हारूनझैँ आफ्ना मानिसहरूसँग मिल्नेछस्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","किनकि जीनको उजाडस्थानमा पानीको लागि समुदायले विद्रोह गर्दा तिमीहरू दुवैले तिनीहरूका अगि मेरो पवित्रताको आदर गर्नमा मेरो आज्ञापालन गर्नुपर्नेथियो। तर तिमीहरूले गरेनौँ।” (यो जीनको उजाडस्थान कादेशमा भएको मेरीबाको पानीको विषयमा थियो।) ");
INSERT INTO npioncb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मोशाले याहवेहलाई भने, ");
INSERT INTO npioncb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“हे याहवेह, समस्त मानव-जातिलाई जीवन दिनुहुने परमेश्‍वर, यस समुदायमाथि एक जना मानिस नियुक्त गरिदिनुहोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","त्यो मानिस, जो तिनीहरूका सामु बाहिर जाने र भित्र आउने, र तिनीहरूलाई अगुवाइ गरेर बाहिर लैजाओस् र भित्र ल्याओस्; ताकि याहवेहका मानिसहरू गोठालाविनाका भेडाहरूजस्तै नहोऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","यसकारण याहवेहले मोशालाई भन्‍नुभयो, “नूनका छोरा यहोशूलाई लैजा। त्यो मानिसमा नेतृत्वको आत्मा छ र त्यसमाथि तेरो हात राख्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","त्यसलाई पुजारी एलाजार र सारा समुदायको सामु खडा गर्। अनि तिनीहरूको उपस्थितिमा त्यसलाई अगुवाको जिम्मेवारी सुम्पिदे। ");
INSERT INTO npioncb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","तेरो अधिकारको केही भाग त्यसलाई दिनू, र सारा इस्राएली समुदायले त्यसको आज्ञा मान्‍नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","त्यो एलाजार पुजारीको अगि खडा होस्, जसले याहवेहको सामु ऊरीमद्वारा यहोशूका निम्ति निर्णय प्राप्‍त गर्नेछ। यहोशूको आज्ञामा सारा इस्राएली समुदाय बाहिर जानेछन्, र त्यसकै आज्ञामा तिनीहरू भित्र आउनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनले गरे। तिनले यहोशूलाई लगे। अनि तिनलाई पुजारी एलाजार र सारा समुदायको अगि खडा गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","त्यसपछि तिनले आफ्ना हात तिनीमाथि राखे, र याहवेहले मोशाद्वारा आज्ञा दिनुभएजस्तै अगुवाको जिम्मेवारी सुम्पिदिए। ");
INSERT INTO npioncb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","इस्राएलीहरूलाई यो आज्ञा दे, र तिनीहरूलाई भन्: तिमीहरूले मेरा निम्ति तोकिएको समयमा मिठो बास्‍नादार भेटीको रूपमा मेरो अग्निबलि चढाउन नभुल्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","तिनीहरूलाई भन्: तिमीहरूले याहवेहका निम्ति चढाउनुपर्ने अग्निबलिको भेटी यही हो: नियमित रूपमा चढाउने होमबलिका निम्ति निष्खोट दुई वटा एकवर्षे थुमाहरू प्रत्येक दिन चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एउटा थुमा बिहान र अर्को थुमा साँझमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","त्यससँग एक एपाको दशौँ भाग मसिनो पिठोसँग एक चौथाइ हिन पेलिएको जैतुनको तेल पनि मिसाएर चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","याहवेहलाई आगोद्वारा चढाइने मनपर्दो बास्‍नादार अन्‍नबलिको रूपमा सीनै पर्वतमा स्थापित गरिएको नियमित होमबलि यही हो। ");
INSERT INTO npioncb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","त्यससँग चढाइने अर्घबलिचाहिँ प्रत्येक थुमासँग एक चौथाइ हिन दाखमद्य होस्। याहवेहका निम्ति त्यो अर्घबलि पवित्रस्थानमा खन्याउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","साँझमा दोस्रो थुमालाई पनि बिहानको अन्‍नबलि र अर्घबलि तयार गरेजस्तै गरी तयार गर्नू। यो याहवेहलाई चढाइने मनपर्दो बास्‍नादार अग्निबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“शब्बाथ दिनमा जैतुनको तेलसँग मिसाएको एपाको दश भागको दुई भाग मसिनो पिठोसँग दुई वटा एकवर्षे निष्खोट थुमाहरूको अर्घबलि र अन्‍नबलि भेटी चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","योचाहिँ नियमित चढाइने होमबलि र अर्घबलिबाहेक हरेक शब्बाथ दिनमा चढाइने होमबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“प्रत्येक महिनाको पहिलो दिन याहवेहकहाँ होमबलिका लागि दुई वटा साँढे, एउटा भेडा र सात वटा एकवर्षे थुमाहरू चढाउनू। यी सबै पशुहरू निष्खोट हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","प्रत्येक साँढेसँग एपाको दश भागको तीन भाग मसिनो पिठो जैतुनको तेलमा मिसाएको अन्‍नबलि चढाउनुपर्छ। एउटा भेडासँग एपाको दश भागको दुई भाग मसिनो पिठो जैतुनको तेलमा मिसाएको अन्‍नबलि हुनुपर्छ; ");
INSERT INTO npioncb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","अनि प्रत्येक थुमासँग एक एपा मसिनो पिठो जैतुनको तेलसँग मिसाएको अन्‍नबलि हुनुपर्छ। योचाहिँ होमबलिका निम्ति याहवेहलाई मनपर्दो बास्‍नादार आगोद्वारा चढाइने अन्‍नबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","प्रत्येक साँढेसँग लगभग आधा हिन दाखमद्यको अर्घबलि होस्। भेडासँग एक तिहाइ हिन र प्रत्येक थुमासँग एक चौथाइ हिन दाखमद्य होस्। योचाहिँ प्रत्येक वर्षको प्रत्येक औँसीमा चढाउने मासिक होमबलि हो। ");
INSERT INTO npioncb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","अर्घबलिसँग चढाइने नियमित होमबलिबाहेक याहवेहलाई पाप शुद्धीकरण बलिको रूपमा एउटा बोका पनि चढाइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“पहिलो महिनाको चौधौँ दिनमा याहवेहको निस्तार चाड मनाइनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","त्यस महिनाको पन्ध्रौँ दिनमा चाड मनाउनू; सात दिनसम्म अखमिरी रोटी खानू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","यस चाडको पहिलो दिन पवित्र सभा होस्; त्यस दिन तिमीहरूले आफ्ना दैनिक काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","याहवेहलाई अग्निबलि चढाउन दुई वटा बाछाहरू, एउटा भेडा र सात वटा एकवर्षे थुमाहरू, सबै निष्खोट पशुहरू समावेश गर्दै होमबलिको रूपमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","अन्‍नबलिका लागि प्रत्येक साँढेका निम्ति जैतुनको तेलसँग मिसाएको एपाको दश भागको तीन भाग मसिनो पिठो; साँढभेडासँग दश भागको दुई भाग मसिनो पिठो; ");
INSERT INTO npioncb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","र सातै वटा थुमाहरू हरेकसँग दश भागको एक भाग पिठोको अन्‍नबलि तयार गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","त्यसमा पाप शुद्धीकरण बलिको रूपमा एउटा बोका तिमीहरूका प्रायश्‍चितका लागि लिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","बिहानको नियमित होमबलिबाहेक यी सबै बलिहरूलाई चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","यस प्रकारले याहवेहलाई मनपर्दो बास्‍नादार भेटीको रूपमा सात दिनसम्म अग्निबलि प्रत्येक दिन चढाउनू। योचाहिँ नियमित चढाइने होमबलि र अर्घबलिबाहेक चढाउनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","सातौँ दिनमा एउटा पवित्र सभा राख्नू; र त्यस दिन कुनै दैनिक काम नगर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","अगौटे फलको दिनमा, साताहरूका चाडको समयमा जब तिमीहरूले याहवेहलाई नयाँ अन्‍नको भेटी चढाउँछौ, तब पवित्र सभा राख्नू। अनि त्यस दिन कुनै दैनिक काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","दुई वटा बहर, एउटा भेडा र सात वटा एकवर्षे थुमाहरूका होमबलि याहवेहलाई मनपर्दो बास्‍नादार अन्‍नबलिको रूपमा चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","प्रत्येक साँढेसँग अन्‍नबलिका लागि एपाको दश भागको तीन भाग मसिनो पिठो जैतुनको तेलसँग मिसाएको; भेडासँग दश भागको दुई भाग मसिनो पिठो; ");
INSERT INTO npioncb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","र प्रत्येक सात वटा थुमाहरूसँग दश भागको एक भाग मसिनो पिठो चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","तिमीहरूका पापको प्रायश्‍चितका निम्ति एउटा बोका पनि लिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","यी कुराहरू तिनीहरूका अर्घबलिसँग नियमित होमबलि र अन्‍नबलिबाहेक चढाउनू। पशुहरूचाहिँ निश्‍चित रूपमा निष्खोट हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘सातौँ महिनाको पहिलो दिनमा पवित्र सभा राख्नू; र त्यस दिन कुनै नियमित काम नगर्नू। त्यो दिनचाहिँ तिमीहरूका लागि तुरही फुक्ने दिन हो। ");
INSERT INTO npioncb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","याहवेहलाई मनपर्दो बास्‍नादार होमबलिको रूपमा एउटा बहर, एउटा भेडा र सात वटा एकवर्षे थुमाहरू चढाउनू। यी सबै पशुहरू निष्खोट हुनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","साँढेसँग एपाको दश भागको तीन भाग मसिनो पिठोमा जैतुनको तेल मिसाएको अन्‍नबलि चढाउनू; भेडासँग साँढे एपाको दश भागको दुई भाग मसिनो पिठो चढाउनू; ");
INSERT INTO npioncb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","र सात वटा थुमाहरूमा प्रत्येकसँग दश भागको दुई भाग मसिनो पिठो मिसाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","तिमीहरूका पापबलि शुद्धीकरणको निम्ति एउटा बोका सामेल गराएर प्रायश्‍चित गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","यी बलिहरूचाहिँ तोकिएको मासिक र दैनिक होमबलिहरूका साथमा तिनीहरूका अन्‍नबलि र अर्घबलिबाहेक चढाउनू। यिनीहरू याहवेहलाई मनपर्दो बास्‍नादार अग्निबलिहरू हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘सातौँ महिनाको दशौँ दिनमा पवित्र सभा राख्नू। तिमीहरूले आफूलाई विनम्र तुल्याउनू र कुनै पनि काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","याहवेहलाई मनपर्दो बास्‍नादार होमबलिको रूपमा एउटा बहर, एउटा भेडा र सात वटा एकवर्षे थुमाहरू चढाउनू। ती सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","अन्‍नबलिका निम्ति साँढेसँग एपाको दश भागको तीन भाग मसिनो पिठोमा जैतुनको तेल मिसाएर चढाउनू; भेडासँग दश भागको दुई भाग मसिनो पिठो चढाउनू; ");
INSERT INTO npioncb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","र हरेक सात वटा थुमाहरूसँग दश भागको एक भागको हिसाबले अन्‍नबलि चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","त्यसमा प्रायश्‍चितका निम्ति पाप शुद्धीकरण बलि र नियमित होमबलिसँगै अन्‍नबलि र अर्घबलिबाहेक पाप शुद्धीकरण बलिको रूपमा एउटा बोका पनि चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘सातौँ महिनाको पन्ध्रौँ दिन पवित्र सभा राख्नू; र त्यस दिन कुनै नियमित काम नगर्नू। याहवेहका निम्ति सात दिनसम्म चाड मनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","याहवेहलाई मनपर्दो बास्‍नादार भोजनको रूपमा अग्निबलिको साथमा तेह्र वटा बाछाहरू, दुई वटा भेडाहरू र चौध वटा एकवर्षे थुमाहरूको होमबलि चढाउनू। ती सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","तेह्र वटा बाछाहरू प्रत्येकसँग एपाको दश भागको तीन भाग मसिनो पिठो जैतुनको तेल मिसाएको अन्‍नबलि चढाउनू; प्रत्येक दुई भेडासँग दश भागको दुई भाग मसिनो पिठो, ");
INSERT INTO npioncb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","र चौध वटा थुमाहरू प्रत्येकसँग दश भागको एक भाग मसिनो पिठो चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","त्यससँग पाप शुद्धीकरण बलिको रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘उत्सवको दोस्रो दिनमा तिमीहरूले बाह्र वटा बाछा, दुई वटा भेडा र चौध वटा एकवर्षे थुमाहरू चढाउनू, सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछाहरू, भेडाहरू र थुमाहरूसँग चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","त्यससँग पाप शुद्धीकरण बलिका रूपमा एउटा बोका सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘तेस्रो दिनमा तिमीहरूले एघार वटा बाछा, दुई वटा भेडा र चौध वटा एकवर्षे थुमाहरू चढाउनू। यी सबै निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछाहरू, भेडाहरू र थुमाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","त्यससँग पाप शुद्धीकरण बलिका रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘चौथो दिनमा दश वटा बाछा, दुई वटा भेडा र चौध वटा एकवर्षे थुमाहरू चढाउनू। यी सबै निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछाहरू, भेडाहरू र थुमाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","त्यससँग पाप शुद्धीकरण बलिको रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘पाँचौँ दिनमा नौ वटा बाछा, दुई वटा भेडा र चौध वटा एकवर्षे थुमाहरू चढाउनू। ती सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछाहरू, भेडाहरू र थुमाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","त्यससँग पाप शुद्धीकरण बलिका रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘छैटौँ दिनमा आठ वटा बाछा, दुई वटा भेडा र चौध वटा एकवर्षे थुमाहरू चढाउनू। यी सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछाहरू, भेडाहरू र थुमाहरूसँग चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","त्यससँग पाप शुद्धीकरण बलिका रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘सातौँ दिनमा सात वटा बाछा, दुई वटा भेडा र चौध वटा एकवर्षे थुमाहरू चढाउनू। यी सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछाहरू, भेडाहरू र थुमाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","त्यससँग पाप शुद्धीकरण बलिका रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘आठौँ दिन पवित्र सभा राख्नू; र त्यस दिन कुनै नियमित काम नगर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","याहवेहलाई मनमर्दो बास्‍नादार अग्निबलिको साथमा एउटा बाछा, एउटा भेडा र सात वटा एकवर्षे थुमाहरूको होमबलि चढाउनू। यी सबै पशुहरू निष्खोट होऊन्। ");
INSERT INTO npioncb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","तिनीहरूका अन्‍नबलि र अर्घबलि तोकिएका संख्याअनुसार बाछा, भेडा र थुमाहरू चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","त्यससँग पाप शुद्धीकरण बलिका रूपमा एउटा बोका पनि सामेल गर्नू। योचाहिँ नियमित होमबलिसँगको अन्‍नबलि र तिनीहरूका अर्घबलिबाहेक चढाउनू। ");
INSERT INTO npioncb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘तिमीहरूले गरेका भाकल र स्वेच्छा भेटीहरूबाहेक, तिमीहरूका तोकिएका चाडहरूमा याहवेहका निम्ति यी बलिहरू चढाउनू; तिमीहरूका होमबलिहरू, अन्‍नबलिहरू, अर्घबलिहरू र मेलबलिहरू चढाउनू।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","याहवेहले मोशालाई आज्ञा दिनुभएजस्तै, तिनले सबै कुरा इस्राएलीहरूलाई भनिदिए। ");
INSERT INTO npioncb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मोशाले इस्राएलका कुलका मुखियाहरूलाई भने: “याहवेहले यस्तो आज्ञा दिनुभएको छ: ");
INSERT INTO npioncb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","जब कुनै मानिसले याहवेहसँग भाकल गर्छ, अथवा शपथ खाएर आफैँलाई बन्धनमा पार्छ भने त्यसले आफ्नो वचन तोड्नुहुँदैन। तर त्यसले आफूले बोलेको हरेक वचन जसरी भए तापनि पूरा गर्नैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“आफ्नो बुबाको घरमा बसिरहेकी कुनै जवान स्त्रीले याहवेहसँग भाकल गरी, अथवा आफूलाई बन्धनमा बाँधी भने, ");
INSERT INTO npioncb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","र त्यो भाकल वा बन्धन सुनेर पनि उसका बुबा चुपचाप लाग्यो भने ती भाकल वा बन्धन कायम रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","तर यदि उसका बुबाले त्यो भाकल सुनेर मनाही गर्‍यो भने उसले गरेको कुनै पनि भाकल अथवा आफूले गरेको बन्धन कायम रहनेछैन। उसका बुबाले उसलाई मनाही गरेका कारण याहवेहले उसलाई क्षमा गरिदिनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“यदि भाकल गरेपछि उसले विवाह गरी वा सोचविचार नगरी उसका मुखले आफूलाई बन्धनमा पारी भने, ");
INSERT INTO npioncb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","र उसको पतिले त्यो कुरा सुनेर उसलाई केही भनेन भने उसका भाकलहरू वा उसले आफूलाई गरेका बन्धनहरू कायम रहनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","तर उसका पतिले त्यस विषयमा सुनेर उसलाई मनाही गर्‍यो भने उसले गरेको भाकल अथवा उसले नसोची आफूले गरेको प्रतिज्ञा रद्द हुनेछ। अनि याहवेहले त्यस स्त्रीलाई क्षमा गरिदिनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“विधवा अथवा पतिबाट त्यागिएकी स्त्रीले गरेका भाकल वा प्रतिज्ञा उसले पूरा गर्नैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“यदि पतिसँग बसिरहेकी स्त्रीले भाकल गरी वा शपथद्वारा आफूलाई बन्धनमा पारी, ");
INSERT INTO npioncb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","अनि उसको पतिले त्यस विषयमा सुन्यो; तर पनि उसलाई केही भनेन; र उसलाई मनाही गरेन भने उसले गरेका सबै भाकलहरू अथवा आफूले गरेका प्रतिज्ञाहरू कायम रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","तर यदि उसको पतिले त्यस विषयमा सुनेर त्यस कुरालाई रद्द गर्छ भने त्यस स्त्रीको ओठले गरेको कुनै पनि भाकल वा प्रतिज्ञा पूरा गर्नुपर्दैन। उसको पतिले ती रद्द गरिदिएको छ। अनि याहवेहले पनि उसलाई क्षमा गरिदिनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","कुनै पनि स्त्रीले आफूलाई इन्कार गर्नलाई गरेको भाकल वा शपथद्वारा गरिएको प्रतिज्ञालाई उसको पतिले कायम राख्न वा रद्द गर्न सक्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","तर यदि उसको पतिले उसलाई लामो समयसम्म त्यस विषयमा केही भनेन भने त्यस स्त्रीले आफूलाई बाँधेका सबै भाकलहरू अथवा प्रतिज्ञाहरू त्यसले कायम राख्नेछ। त्यसले ती कुराका विषयमा सुनेर पनि उसलाई केही नभनेको कारण भाकल कायम रहनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","तरै पनि यदि त्यसले केही समयपछि ती कुरा सुनेर कुनै कुरालाई रद्द गर्‍यो भने त्यस स्त्रीको दोषको परिणाम उसको पतिले भोग्नुपर्छ।” ");
INSERT INTO npioncb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","पति-पत्नी बीचको सम्बन्ध र बुबा र बुबाको घरमा बसेकी अविवाहित जवान छोरीबीचको सम्बन्धको बारेमा याहवेहले मोशालाई दिनुभएका नियमहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“इस्राएलीहरूका खातिर मिद्यानीहरूसँग बदला लिनू। त्यसपछि तँ आफ्ना मानिसहरूसँग मिल्न जानेछस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","यसकारण मोशाले मानिसहरूलाई भने, “मिद्यानीहरूका विरुद्ध याहवेहको बदलाको लडाइँ लड्नका निम्ति तिमीहरूका केही मानिसहरूलाई हातहतियारले सुसज्जित गराओ। ");
INSERT INTO npioncb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएलीहरूका प्रत्येक कुलबाट एक-एक हजार मानिसहरूलाई लडाइँ गर्न पठाओ।” ");
INSERT INTO npioncb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","यसकारण इस्राएली वंशबाट प्रत्येक बाह्र कुलबाट एक हजारको हिसाबले लडाइँका निम्ति सुसज्जित पारिएका बाह्र हजार मानिसहरू खटाइए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मोशाले तिनीहरूलाई प्रत्येक कुलबाट एक-एक हजारलाई लडाइँमा पठाए। तिनीहरूसँग पुजारी एलाजारका छोरा पीनहास पनि थिए। पीनहासले आफूसँग पवित्रस्थानका सामग्रीहरू र सङ्केत दिनका लागि तुरहीहरू लगे। ");
INSERT INTO npioncb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","याहवेहले मोशालाई आज्ञा गर्नुभएझैँ तिनीहरूले मिद्यानीहरूका विरुद्धमा लडाइँ गरे, र सबै पुरुषहरूलाई मारे। ");
INSERT INTO npioncb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","तिनीहरूका हातबाट मर्नेहरूमध्ये मिद्यानका पाँच राजाहरू अर्थात् एवी, रेकेम, सूर, हूर र रेवा थिए। तिनीहरूले बओरका छोरा बालामलाई पनि तरवारले मारे। ");
INSERT INTO npioncb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएलीहरूले मिद्यानी स्त्रीहरू र तिनीहरूका छोराछोरीहरूलाई बन्दी बनाए र मिद्यानीहरूका बथान, बगाल र सरसामानहरू लुटको मालझैँ लिएर गए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","तिनीहरूले मिद्यानीहरू बसोबास गरेका सबै सहरहरू र छाउनीहरूलाई जलाइदिए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","तिनीहरूले लुटेका र कब्जा गरेका सबै मालसामानहरू, मानिसहरू र पशुहरू सबै लगे। ");
INSERT INTO npioncb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","अनि कैदीहरू, कब्जा गरेका र लुटेका मालसामानहरूलाई मोशा, पुजारी एलाजार र इस्राएली समुदायकहाँ ल्याए। त्यस बेला तिनीहरूको छाउनी यरीहोदेखि पारि यर्दन नदीको किनार मोआबको मैदानमा थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","मोशा, पुजारी एलाजार र समुदायका सबै अगुवाहरू तिनीहरूलाई भेट गर्न छाउनीबाहिर आए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","लडाइँबाट फर्केर आएका सेनाका अधिकृतहरू अर्थात् हजार-हजारमाथि र सय-सयमाथिका सेनापतिहरूसँग मोशा रिसाए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशाले तिनीहरूलाई सोधे, “के तिमीहरूले सबै स्त्रीहरूलाई जीवितै रहन दियौ?” ");
INSERT INTO npioncb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","यी तिनीहरू नै थिए, जसले पोर पर्वतको घटनामा बालामको सल्‍लाह सुनेर इस्राएलीहरूलाई याहवेहको विरुद्धमा तर्केर जान उक्साएका थिए। यसैकारण याहवेहका मानिसहरूलाई विपत्तिले प्रहार गरेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","अब सबै केटाहरूलाई र पुरुषहरूसँग सहवास गरेका हरेक स्त्रीहरूलाई पनि मार। ");
INSERT INTO npioncb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","तर कुनै मानिससँग सहवास नभएका हरेक कन्याहरूलाई चाहिँ तिमीहरूले आफ्ना निम्ति जीवित राख। ");
INSERT INTO npioncb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","यदि जजसले मानिसलाई मारेको छ, अर्थात् मारिएको कसैलाई छोएको छ भने तिमीहरू छाउनीबाहिर सात दिनसम्म बस्‍नुपर्छ। तेस्रो र सातौँ दिनमा तिमीहरूले आफैँलाई र तिमीहरूका कैदीहरूलाई शुद्ध पार्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तिमीहरूले लगाएका हरेक वस्त्र र छालाले अथवा बाख्राको रौँले अथवा काठले बनिएका हरेक कुरालाई शुद्ध पार। ");
INSERT INTO npioncb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","त्यसपछि पुजारी एलाजारले लडाइँमा जाने सेनाहरूलाई भने, “याहवेहले मोशालाई दिनुभएको नियमअनुसार यो आवश्यक छ: ");
INSERT INTO npioncb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सुन, चाँदी, काँसो, फलाम, टिन, सिसा, ");
INSERT INTO npioncb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","र आगोले नष्‍ट नहुने सबै कुरालाई आगोभित्र हालेर निकाल्नू र त्यो शुद्ध हुनेछ। तर त्यसलाई शुद्ध पार्ने पानीले पनि शुद्ध पारिनुपर्छ। अनि आगोले नष्‍ट हुने जुनसुकै थोकलाई चाहिँ पानीद्वारा शुद्ध पार्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","सातौँ दिनमा आफ्ना लुगाहरू धुनू, र तिमीहरू शुद्ध हुनेछौ। त्यसपछि तिमीहरू छाउनीभित्र आउन सक्नेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“तैँले, पुजारी एलाजार र समुदायका मुखियाहरूले कैद गरेर ल्याइएका सबै मानिसहरू र पशुहरू गन्ती गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","लुटिएका मालहरू लडाइँमा जाने सेनाहरू र बाँकी रहेका समुदायको बीचमा बराबरी बाँड्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","लडाइँमा युद्ध गर्ने सेनाहरूबाट याहवेहका सलामीको निम्ति चाहे मानिस होस्, अथवा गाईबस्तु, गधा, भेडा र बाख्राहरू होस्; हरेक कुराको पाँच सयबाट एउटा अलग गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","तिनीहरूबाट उठेको सलामीको आधा भागबाट याहवेहको भेटीको रूपमा पुजारी एलाजारलाई दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","इस्राएलीहरूको आधा भागबाट मानिसहरू, गाईबस्तु, गधा, भेडा, बाख्रा अथवा अरू सबै पशुहरू, त्यसको प्रत्येक पचासबाट एउटा गरेर अलग गर्नू। ती अलग गरिएका कुराहरू याहवेहको समागम पालको रेख-देखको जिम्मामा रहेका लेवीहरूलाई दिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","यसकारण याहवेहले मोशालाई आज्ञा गर्नुभएजस्तै मोशा र पुजारी एलाजारले गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","सेनाहरूले लुटेका सामानहरूमा बाँकी रहेका कुराहरू यही थियो: 6,75,000 भेडाहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 गाईबस्तु, ");
INSERT INTO npioncb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 गधाहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","र कुनै मानिससँग सहवास नगरेका 32,000 स्त्रीहरू। ");
INSERT INTO npioncb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","लडाइँमा युद्ध गर्ने सेनाहरूको आधा भाग यस्तो थियो: 3,37,500 भेडाहरू, ");
INSERT INTO npioncb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","जसमा याहवेहका निम्ति सलामीचाहिँ 675 भेडाहरू थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 गाईबस्तुहरू, जसमा याहवेहका निम्ति सलामीचाहिँ 72 वटा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 गधाहरू थिए, जसमा याहवेहका निम्ति सलामीचाहिँ 61 वटा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 मानिसहरू, जसमा याहवेहका निम्ति सलामीचाहिँ 32 वटा थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","मोशालाई याहवेहले आज्ञा गर्नुभएझैँ याहवेहको भागको सलामी पुजारी एलाजारलाई दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","मोशाले सेनाहरूको भागबाट छुट्याएका इस्राएलीहरूको भागको आधा, ");
INSERT INTO npioncb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","अर्थात् समुदायको आधा भागचाहिँ 3,37,500 भेडा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 गाईबस्तु, ");
INSERT INTO npioncb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 गधा, ");
INSERT INTO npioncb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","र 16,000 मानिस थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","इस्राएलीहरूको आधा भागबाट याहवेहले मोशालाई आज्ञा दिनुभएजस्तै तिनले मानिसहरू र पशुहरूबाट प्रत्येक पचासबाट एक-एक अलग गरे। अनि ती सबै लेवीहरूलाई दिए, जो याहवेहको समागम पालको रेख-देखको जिम्मावाल थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","त्यसपछि सेनाहरूका अधिकृतहरू अर्थात् हजार-हजारमाथि र सय-सयमाथिका सेनापतिहरू मोशाकहाँ गए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","अनि तिनीहरूले मोशालाई भने, “तपाईंका सेवकहरूले हाम्रो जिम्मामा रहेका सेनाहरूलाई गनेका छन्। अनि एक जना पनि हराएको छैन। ");
INSERT INTO npioncb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","यसकारण हामी प्रत्येकले पाएका सुनका चीजहरू अर्थात् बाला, चुरा, छाप-औँठी, कुण्डल र सिक्रीमाला याहवेहको सामु हामीले आफ्ना प्रायश्‍चितको लागि याहवेहका निम्ति भेटीको रूपमा ल्याएका छौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशा र पुजारी एलाजारले तिनीहरूबाट सुन अर्थात् सबै गहनाहरू स्वीकार गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","मोशा र एलाजारले हजार-हजारमाथि र सय-सयमाथिका सेनापतिहरूबाट याहवेहका निम्ति उपहारको रूपमा चढाएका सबै सुनको तौल 16,750 शेकेल थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","हरेक सेनाले लुटको सर-सामान आफ्नै निम्ति लिएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मोशा र पुजारी एलाजारले हजार-हजारका र सय-सयका सेनापतिहरूबाट सुन स्वीकार गरे। अनि त्यसलाई याहवेहको सामु इस्राएलीहरूका निम्ति एउटा सम्झनाको रूपमा भेट हुने पालभित्र ल्याए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबेनीहरू र गादीहरू, जसका धेरै बथान, बगाल भएकाले याजेर र गिलादको देश पशुपालनका निम्ति उपयुक्त देखे। ");
INSERT INTO npioncb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","यसकारण तिनीहरू मोशा, पुजारी एलाजार र समुदायका अगुवाहरूकहाँ आएर भने, ");
INSERT INTO npioncb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","अतारोत, दीबोन, याजेर, निम्रा, हेश्बोन, एलाले, शबाम, नेबो र बओन, ");
INSERT INTO npioncb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","अर्थात् याहवेहले इस्राएलीहरूका अधीनमा पार्नुभएको देश पशुपालनका निम्ति उपयुक्त रहेछ। अनि तपाईंका सेवकहरूसँग धेरै गाईबस्तु छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","तिनीहरूले भने, “यदि हामीले तपाईंहरूको दृष्‍टिमा निगाह पाएका छौँ भने यो भूमि हाम्रो अधिकारको रूपमा तपाईंका सेवकहरूलाई दिनुहोस्। हामीलाई यर्दनपारि जान नलगाउनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मोशाले गादीहरू र रूबेनीहरूलाई भने, “के तिमीहरूका दाजुभाइहरू लडाइँमा जाँदा तिमीहरूचाहिँ यहाँ ढुक्‍क बस्‍न चाहन्छौ? ");
INSERT INTO npioncb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","किन तिमीहरू इस्राएलीहरूलाई याहवेहले यर्दनपारिपट्टि दिनुभएको देशमा जानलाई निराश बनाउँछौ? ");
INSERT INTO npioncb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","जब तिमीहरूका बुबाहरूलाई मैले कादेश-बर्नेबाट त्यस देशलाई हेर्न पठाउँदा तिनीहरूले यस्तै गरेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","जब तिनीहरू एश्कोलको बेँसीसम्म पुगे, र त्यस देशलाई हेरेपछि तिनीहरूले इस्राएलीहरूलाई याहवेहले दिनुभएको देशमा प्रवेश गर्नलाई हतोत्साहित तुल्याएका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","त्यस दिन याहवेह रिसाउनुभयो, र उहाँले यो शपथ खानुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘इजिप्टबाट आएका बीस वर्ष र त्यसभन्दा बढी उमेरका कसैले पनि मैले अब्राहाम, इसहाक र याकोबसँग शपथ खाएर दिन्छु भनी प्रतिज्ञा गरेको देश देख्न पाउनेछैन। किनकि तिनीहरूले मलाई पूर्ण रूपले पछ्याएका छैनन्। ");
INSERT INTO npioncb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","कनज्जी यपून्‍नेका छोरा कालेब र नूनका छोरा यहोशू मात्र पस्‍न पाउनेछन्। किनकि यिनीहरूले चाहिँ पूर्ण हृदयले याहवेहलाई पछ्याए।’ ");
INSERT INTO npioncb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","इस्राएलको विरुद्धमा याहवेह रिसाउनुभयो। अनि उहाँको दृष्‍टिमा दुष्‍ट काम गर्नेहरूको सम्पूर्ण पुस्ता नष्‍ट नहोउन्जेल उहाँले तिनीहरूलाई उजाडस्थानमा चालीस वर्षसम्म भौँतारिन दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“अनि तिमी पापीहरूका सन्तान आफ्ना पितापुर्खाहरूझैँ याहवेहलाई इस्राएलसँग अझ बढी रिस उठाउनलाई खडा भएका छौ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","यदि तिमीहरूले उहाँलाई पछ्याउन छाड्यौ भने उहाँले फेरि यी मानिसहरूलाई उजाडस्थानमा नै छोडिदिनुहुनेछ। अनि तिनीहरूको विनाशको कारण तिमीहरू हुनेछौ।” ");
INSERT INTO npioncb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","तब तिनीहरू मोशाकहाँ आएर भने, “हामी यहाँ आफ्ना बगालका निम्ति गोठ, हाम्रा स्त्रीहरू र छोराछोरीहरूका लागि सहरहरू बनाउन चाहन्छौँ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","तर हामी आफैँचाहिँ इस्राएलीहरूलाई तिनीहरूको ठाउँमा नपुर्‍याएसम्म हातहतियार लिएर तिनीहरूको लागि लडाइँमा जान तयार छौँ। त्यस बेलामा हाम्रा स्त्रीहरू र छोराछोरीहरूचाहिँ यहाँका बासिन्दाहरूबाट जोगिनका लागि बलियो किल्‍ला भएका सहरहरूमा बस्‍नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","प्रत्येक इस्राएलीहरूले तिनीहरूका पैतृक सम्पत्ति नपाएसम्म हामी आफ्ना घरमा फर्कनेछैनौँ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","हामी यर्दनपारि तिनीहरूसँग उत्तराधिकारको कुनै भाग लिनेछैनौँ; किनकि हामीले यर्दनको पूर्वपट्टि उत्तराधिकारको भाग पाइसकेका छौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","तब मोशाले तिनीहरूलाई भने, यदि तिमीहरूले यसो गर्‍यौ भने अर्थात् तिमीहरूले याहवेहको सामु लडाइँका निम्ति हातहतियार भिरेर लडाइँमा जान तयार भयौ भने, ");
INSERT INTO npioncb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","अनि तिमीहरू सबै हातहतियार भिरेर याहवेहले आफ्ना शत्रुहरूलाई आफ्नै सामु धपाएर देश परास्त नगरेसम्म उहाँको सामु यर्दनपारि गयौ भने, ");
INSERT INTO npioncb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","जब याहवेहको सामु देश अधीनमा आउँछ, तब तिमीहरू फर्कन सक्छौ। अनि याहवेह र इस्राएलसँगको तिमीहरूको दायित्वबाट तिमीहरू स्वतन्त्र हुनेछौ। अनि यो देश याहवेहको सामु तिमीहरूको अधिकारमा हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","तर यदि तिमीहरूले आफ्नो वचन पूरा गर्न असफल भयौ भने तिमीहरूले याहवेहको विरुद्धमा पाप गरेका हुनेछौ। अनि तिमीहरूले आफ्ना पापको प्रतिफल निश्‍चय नै भोग्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","आफ्ना स्त्रीहरू र छोराछोरीहरूका निम्ति सहर अनि तिमीहरूका बगालका निम्ति गोठहरू बनाओ। तर तिमीहरूले गरेका प्रतिज्ञा पूरा गर। ");
INSERT INTO npioncb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","गादीहरू र रूबेनीहरूले मोशालाई भने, “हामी तपाईंका सेवकहरूले हाम्रा मालिकले आज्ञा गर्नुभएजस्तै गर्नेछौँ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हाम्रा छोराछोरी र पत्नीहरू, हाम्रा बगालहरू र बथानहरू यहीँ गिलाद सहरमा रहनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","तर तपाईंका सेवकहरू, हाम्रा मालिकको आज्ञाअनुसार लडाइँका लागि हातहतियार भिरेका हरेक मानिसहरू याहवेहको सामु युद्ध गर्न यर्दनपारि जानेछौँ।” ");
INSERT INTO npioncb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","तब मोशाले तिनीहरूको बारेमा पुजारी एलाजारलाई, नूनका छोरा यहोशू र इस्राएली कुलका अगुवाहरूलाई आज्ञा दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मोशाले तिनीहरूलाई भने, “यदि गादीहरू र रूबेनीहरूका हरेक मानिस लडाइँका निम्ति हातहतियार भिरेर याहवेहको सामु तिमीहरूसँग लडाइँ गर्न यर्दनपारि जान्छन् भने, र जब त्यो देश तिमीहरूकै अगि तिमीहरूका अधीनमा आयो भने तिमीहरूले गिलादको मुलुक तिनीहरूलाई पैतृक सम्पत्तिको रूपमा दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","तर यदि तिनीहरू हातहतियार भिरेर तिमीहरूका साथमा लडाइँमा पारि जान इन्कार गरे भने तिनीहरूले तिमीहरूसँगै कनान देशमा आ-आफ्ना सम्पत्तिको भाग पाउनेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","गादीहरू र रूबेनीहरूले जवाफ दिए, “तपाईंका सेवकहरूले याहवेहले भन्‍नुभएजस्तै हामी गर्नेछौँ। ");
INSERT INTO npioncb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हामी याहवेहको सामु हातहतियार भिरेर यर्दनपारि कनानसम्मै जानेछौँ। तर हामीले पाउने अधिकारचाहिँ यर्दनको वारि पूर्वपट्टि नै हुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","त्यसपछि मोशाले गादीहरू, रूबेनीहरू र योसेफका छोरा मनश्शेको आधा कुललाई एमोरीहरूका राजा सीहोनको राज्य र बाशानका राजा ओगको राज्य अर्थात् सम्पूर्ण देश त्यसका सहरहरूसँगै र तिनीहरूका वरिपरिका प्रान्तहरू दिए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गादीहरूले दीबोन, अतारोत, अरोएर, ");
INSERT INTO npioncb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अत्रोत-शोपान, याजेर, योगबहा, ");
INSERT INTO npioncb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेथ-निम्रा र बेथ-हारानहरूलाई सुरक्षित सहरजस्तै बनाए। तिनीहरूका बगालका निम्ति गोठहरू बनाए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","अनि रूबेनीहरूले हेश्बोन, एलाले र किर्यातैम, ");
INSERT INTO npioncb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","साथसाथै नेबो र बाल-मोन (यी नामहरू परिवर्तन भए) र सिब्मा पुनर्निर्माण गरे। तिनीहरूले आफूले पुनर्निर्माण गरेका सहरहरूका नामहरू नयाँ राखे। ");
INSERT INTO npioncb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनश्शेका छोरा माकीरका सन्ततिहरू गिलादमा गए। अनि त्यसलाई कब्जा गरेर त्यहाँ बसोबास गर्ने एमोरीहरूलाई धपाए। ");
INSERT INTO npioncb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","यसकारण मोशाले मनश्शेका सन्तान माकीरीहरूलाई गिलाद दिए। अनि तिनीहरू त्यहाँ बसोबास गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","याईर, मनश्शेको सन्तानले गिलादका केही बस्तीहरू आफ्नो अधीनमा ल्याए। अनि त्यसलाई हव्वोत-याईर नाम राखे। ");
INSERT INTO npioncb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","अनि नोबहले केनात र त्यसका वरिपरिका बस्तीहरू कब्जा गरे। यसकारण ती बस्तीहरूका नाम आफ्नै नामअनुसार नोबह राखे। ");
INSERT INTO npioncb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","मोशा र हारूनको नेतृत्वमा इस्राएलीहरू इजिप्टबाट दल-दलमा निस्केर यात्रा गरेका विवरणहरू यही हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","याहवेहको आदेशमा मोशाले तिनीहरूका यात्राका विवरणहरू लेखे। तिनीहरूले यात्रा गरेका विभिन्‍न ठाउँअनुसारका विवरण यही हो: ");
INSERT INTO npioncb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","इस्राएलीहरूले रामसेसबाट निस्तार चाडको भोलिपल्ट पहिलो महिनाको पन्ध्रौँ दिनमा यात्रा सुरु गरे। सारा इजिप्टियनहरूले हेर्दाहेर्दै तिनीहरूले साहसपूर्वक मोर्चा बाँधेर प्रस्थान गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","त्यस बेला ती इजिप्टियनहरूचाहिँ आफ्ना जेठा छोराहरूका लासलाई गाडिरहेका थिए; जसलाई याहवेहले प्रहार गरी मार्नुभएको थियो। किनकि तिनीहरूका देवताहरूमाथि पनि याहवेहले न्याय ल्याउनुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","रामसेसबाट हिँडेपछि इस्राएलीहरूले सुक्‍कोतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","सुक्‍कोतबाट हिँडेपछि तिनीहरूले उजाडस्थानको किनारमा भएको एथाममा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","तिनीहरू एथाम छोडेर हिँडे, र बाल-सेफोनको पूर्वपट्टि भएको पी-हहीरोतमा फर्किएर गए। अनि मिग्दोलको छेउमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","तिनीहरू पी-हहीरोतबाट हिँडेपछि समुद्रको बीचबाट भएर उजाडस्थानमा गए। तिनीहरू एथामको उजाडस्थानमा तीन दिनसम्म हिँडे। अनि तिनीहरूले मारामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","तिनीहरू माराबाट हिँडेर एलीममा आए, जहाँ बाह्र वटा पानीका मूल र सत्तरी वटा खजूरका रूखहरू थिए। अनि त्यहीँ तिनीहरूले छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","तिनीहरू एलीमबाट हिँडेर लाल समुद्रको नजिक छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","लाल समुद्रबाट हिँडेपछि तिनीहरूले सीनको उजाडस्थानमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","सीनको उजाडस्थानबाट हिँडेपछि तिनीहरूले दोफकामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","दोफकाबाट हिँडेपछि तिनीहरूले आलूशमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","आलूशबाट हिँडेर तिनीहरूले रेफिदीममा छाउनी हाले, जहाँ मानिसहरूका निम्ति पिउनलाई पानी थिएन। ");
INSERT INTO npioncb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","रेफिदीमबाट हिँडेर तिनीहरूले सीनैको उजाडस्थानमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","तिनीहरू सीनैको उजाडस्थानबाट हिँडे, र किब्रोत-हत्तावामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","तिनीहरू किब्रोत-हत्तावाबाट हिँडे, र हसेरोतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","तिनीहरू हसेरोतबाट हिँडे, र रित्मामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","तिनीहरू रित्माबाट हिँडे, र रिम्मोन-पेरेसमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","तिनीहरू रिम्मोन-पेरेसबाट हिँडे, र लिब्नामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","तिनीहरू लिब्नाबाट हिँडे, र रिस्सामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","तिनीहरू रिस्साबाट हिँडे, र केहेलातामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","तिनीहरू केहेलाताबाट हिँडे, र शेपेर पर्वतमा पाल टाँगे। ");
INSERT INTO npioncb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","तिनीहरू शेपेर पर्वतबाट हिँडे, र हरादामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","तिनीहरू हरादाबाट हिँडे, र मखेलोतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","तिनीहरू मखेलोतबाट हिँडे, र तहतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","तिनीहरू तहतबाट हिँडे, र तेरहमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","तिनीहरू तेरहबाट हिँडे, र मित्कामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","तिनीहरू मित्काबाट हिँडे, र हशमोनामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","तिनीहरू हशमोनाबाट हिँडे, र मसेरोतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","तिनीहरू मसेरोतबाट हिँडे, र बेने-याकानमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","तिनीहरू बेने-याकानबाट हिँडे, र होर-होगिदगादमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","तिनीहरू होर-होगिदगादबाट हिँडे, र योतबातामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","तिनीहरू योतबाताबाट हिँडे, र अब्रोनामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","तिनीहरू अब्रोनाबाट हिँडे, र एस्योन-गेबेरमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","तिनीहरू एस्योन-गेबेरबाट हिँडे, र जीनको उजाडस्थानमा भएको कादेशमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","तिनीहरू कादेश-बर्नेबाट हिँडे, र एदोमको सिमाना होर पर्वतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","याहवेहको आज्ञामा पुजारी हारून होर पर्वतमा उक्ले, जहाँ इस्राएलीहरू इजिप्टबाट निस्किआएको चालीसौँ वर्षको पाँचौँ महिनाको पहिलो दिनमा तिनको मृत्यु भयो। ");
INSERT INTO npioncb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","होर पर्वतमा हारूनको मृत्यु हुँदा तिनी एक सय तेईस वर्ष पुगेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","कनान देशको दक्षिणमा बस्‍ने कनानी राजा आरादले इस्राएलीहरू आउँदैछन् भनी सुने। ");
INSERT INTO npioncb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","तिनीहरू होर पर्वतबाट पनि हिँडे, र सलमोनामा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","तिनीहरू सलमोनाबाट हिँडे, र पूनोनमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","तिनीहरू पूनोनबाट हिँडे, र ओबोतमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","तिनीहरू ओबोतबाट हिँडे, र मोआबको सिमानामा भएको इये-अबारीममा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","तिनीहरू इये-अबारीमबाट हिँडे, र दीबोन-गादमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","तिनीहरू दीबोन-गादबाट हिँडे, र अल्मोन दिब्लातैममा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","तिनीहरू अल्मोन दिब्लातैमबाट हिँडे, र नेबोको छेउमा भएको अबारीमको पर्वतहरूमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","तिनीहरू अबारीम पर्वतहरूबाट हिँडे, र यरीहोको पारिपट्टि यर्दन नदीको किनारमा मोआबको मैदानमा छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","त्यहाँ मोआबको मैदानमा तिनीहरूले यर्दन नदीको किनार बेथ-यशीमोतदेखि हाबिल-शीत्तिमसम्म छाउनी हाले। ");
INSERT INTO npioncb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","यरीहोको पारिपट्टि यर्दन नदीको नजिकै मोआबको मैदानमा याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएलीहरूसँग कुरा गर्, र तिनीहरूलाई भन्: ‘जब तिमीहरूले यर्दन पार गरेर कनान देश पुग्छौ, ");
INSERT INTO npioncb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तब तिमीहरूका सामुबाट त्यहाँका सबै बासिन्दाहरूलाई धपाउनू। तिनीहरूले खोपेका प्रतिमाहरू र ढलौटे मूर्तिहरू सबै नष्‍ट गर्नू। अनि तिनीहरूका सबै अल्गा देवस्थानहरू भत्काइदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","त्यस देशलाई कब्जा गर्नू र त्यहीँ बसोबास गर्नू। किनकि मैले त्यो देश तिमीहरूलाई अधिकार गर्नलाई दिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","त्यो देशलाई तिमीहरूका वंशअनुसार चिट्ठा हालेर बाँड्नू। ठूलो दल भएकाहरूलाई ठूला अंश र साना दल भएकाहरूलाई सानै अंश दिनू। तिनीहरूले चिट्ठा हालेर जे पाउँछन्, ती तिनीहरूकै हुनेछन्। त्यस देशलाई तिमीहरूका पुर्ख्यौली कुलअनुसार बाँडिदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘तर यदि तिमीहरूले त्यस देशका बासिन्दाहरूलाई धपाएनौ भने तिमीहरूले बस्‍न दिएका मानिसहरू नै तिमीहरूका आँखामा छेस्का र तिमीहरूका छेउका काँडाजस्तै हुनेछन्। तिमीहरू जहाँ बस्‍नेछौ, त्यस देशमा तिनीहरूले तिमीहरूलाई सताउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","अनि मैले तिनीहरूलाई जे गर्छु भनी सोचेको छु, त्यो म तिनीहरूसँग गर्नेछु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इस्राएलीहरूलाई आज्ञा दिएर यसो भन्: ‘जब तिमीहरू कनान देशमा प्रवेश गर्छौ, तिमीहरूलाई उत्तराधिकारको रूपमा बाँडिने जमिनको सिमाना यस्तो हुनेछ: ");
INSERT INTO npioncb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘तिमीहरूको दक्षिण भागतिर एदोमको सिमानादेखि जीनको उजाडस्थानको केही भागसम्म पर्नेछ। तिमीहरूको दक्षिणी सिमाना पूर्वपट्टि भएको मृत सागरको अन्तिमदेखि सुरु भएर, ");
INSERT INTO npioncb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","अक्रब्बीमको दक्षिणी घाटी पार गरेर जीनतिर बढ्दै गएर कादेश-बर्नेको दक्षिणसम्म पुग्नेछ। त्यसपछि त्यो हसर-अद्दरहुँदै अज्मोनसम्म पुग्नेछ, ");
INSERT INTO npioncb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","जहाँ सिमाना घुमेर इजिप्टको नदीसँग जोडिनेछ; र भूमध्यसागरमा टुङ्गिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","तिमीहरूका पश्‍चिमी सिमाना भूमध्य सागरको किनारसम्म हुनेछ। तिमीहरूको पश्‍चिमपट्टिको सिमाना यही हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","तिमीहरूको उत्तरपट्टिको सिमाना भूमध्य सागरदेखि होर पर्वतसम्म हुनेछ, ");
INSERT INTO npioncb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","र होर पर्वतबाट लेबो-हमातसम्म हुनेछ। अनि तिमीहरूको सिमाना सदादसम्म जानेछ, ");
INSERT INTO npioncb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","र सिप्रोनसम्म गएर हसर-एनानमा टुङ्गिनेछ। तिमीहरूको उत्तरपट्टिको सिमाना यही हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","तिमीहरूको पूर्वपट्टिको सिमाना हसर-एनानबाट सुरु भएर सपामसम्म हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","त्यो सिमाना सपामबाट ऐनको पूर्वी भागमा भएको रिब्लासम्म तल पुग्नेछ। अनि त्यो पूर्वपट्टिको ओरालो हुँदै गालीलको समुद्रसम्म पुग्नेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","त्यसपछि यर्दन नदीको किनारहुँदै तल गएर मृत सागरको सिमानामा टुङ्गिनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","मोशाले इस्राएलीहरूलाई आज्ञा दिए: “यस देशलाई पैतृक सम्पत्तिको रूपमा चिट्ठा हालेर बाँड्नू। याहवेहले यसलाई साढे नौ वटा कुलहरूलाई दिनू भनेर आज्ञा गर्नुभएको छ। ");
INSERT INTO npioncb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","किनकि रूबेन, गाद र मनश्शेको आधा कुलका परिवारहरूले, तिनीहरूका अंश पाइसकेका छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","यी साढे दुई कुलहरूले यरीहोको पारिपट्टि यर्दन नदीको सूर्य उदाउनेतिर तिनीहरूका परिवारअनुसार आ-आफ्ना अधिकार पाइसकेका छन्।” ");
INSERT INTO npioncb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“तिमीहरूका निम्ति पैतृक सम्पत्तिको रूपमा देश बाँडिदिने मानिसहरूका नाम यिनै हुन्: पुजारी एलाजार र नूनका छोरा यहोशू। ");
INSERT INTO npioncb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","अनि तिनीहरूलाई देश बाँडिदिनका निम्ति सहायता गर्नलाई प्रत्येक कुलबाट एक-एक जना अगुवा नियुक्त गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“ती अगुवाहरूका नाम यिनै हुन्: “यहूदाको कुलबाट यपून्‍नेका छोरा कालेब; ");
INSERT INTO npioncb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शिमियोनको कुलबाट अम्मीहूदका छोरा शेमूएल; ");
INSERT INTO npioncb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बेन्यामीनको कुलबाट किसलोनका छोरा एलीदाद; ");
INSERT INTO npioncb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दानको कुलबाट योग्लीका छोरा बुक्‍की अगुवा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","योसेफका छोरा मनश्शेको कुलबाट एपोदका छोरा हन्‍नीएल अगुवा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","योसेफका छोरा एफ्राइमको कुलबाट शिप्‍तानका छोरा कमूएल अगुवा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबूलूनको कुलबाट पर्नाककोका छोरा एलीशापान अगुवा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साखारको कुलबाट अज्जानका छोरा पल्तिएल अगुवा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेरको कुलबाट शलोमीका छोरा अहीदूद अगुवा थिए; ");
INSERT INTO npioncb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नप्‍तालीको कुलबाट अम्मीहूदका छोरा पदहेल अगुवा थिए।” ");
INSERT INTO npioncb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","याहवेहले कनान देशमा इस्राएलीहरूलाई पैतृक सम्पत्तिको भाग बाँडिदिनलाई नियुक्त गर्नुभएका मानिसहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","यरीहोको नजिक यर्दन नदीको किनार मोआबको मैदानमा याहवेहले मोशालाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इस्राएलीहरूले पाउने उत्तराधिकारको भागबाट लेवीहरूलाई बस्‍नको निम्ति सहरहरू दिनू भनेर इस्राएलीहरूलाई आज्ञा दिनू। तिनीहरूलाई सहरहरूका वरिपरि गाईबस्तु चराउने ठाउँ दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","तब तिनीहरूसँग बसोबास गर्न सहरहरू र तिनीहरूका गाईबस्तु, बगाल र पशुहरूका निम्ति खर्कहरू हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“तिमीहरूले लेवीहरूलाई सहरहरूका वरिपरि दिने खर्कहरू सहरको पर्खालदेखि हजार क्यूबिट होस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","सहरबाहिर सहरलाई केन्द्रमा राखेर पूर्वपट्टि दुई हजार क्यूबिट, दक्षिणपट्टि दुई हजार क्यूबिट, पश्‍चिमपट्टि दुई हजार क्यूबिट र उत्तरपट्टि दुई हजार क्यूबिटको नाप होस्। सहरको लागि यही ठाउँ तिनीहरूले खर्कको रूपमा पाउनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“तिमीहरूले लेवीहरूलाई दिने सहरहरूमध्ये छ वटा नगरहरूचाहिँ शरणस्थलका नगरहरू हुनेछन्। त्यहाँ कुनै व्यक्तिलाई कसैले अनजानमा मार्‍यो भने भागेर बच्न सक्छ। तीबाहेक तिनीहरूलाई बयालीस वटा अरू नगरहरू दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","तिमीहरूले लेवीहरूलाई जम्मा अठचालीस वटा नगरहरू र तिनीहरूलाई गाईबस्तु चराउने खर्कहरू दिनुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","तिमीहरूले लेवीहरूलाई नगरहरू दिँदा इस्राएलीहरूले अधिकार गरेका जमिनबाट तिनीहरूका हरेक कुलको संख्याअनुसार होस्: धेरै हुने कुलबाट धेरै नगरहरू, र थोरै हुने कुलबाट थोरै नगरहरू लिएर लेवीहरूलाई दिनू।” ");
INSERT INTO npioncb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","त्यसपछि याहवेहले मोशालाई भन्‍नुभयो: ");
INSERT INTO npioncb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इस्राएलीहरूसँग कुरा गर्, र तिनीहरूलाई भन्: ‘जब तिमीहरू यर्दन तरेर कनानमा पुग्नेछौ, ");
INSERT INTO npioncb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","तब तिमीहरूका शरण-नगरहरूका निम्ति केही सहरहरू छान्‍नू, जहाँ कुनै पनि व्यक्तिले कसैलाई अनजानमा मार्‍यो भने त्यो त्यहाँ भागेर जान सकोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ती ठाउँहरू बदला लिन खोज्नेहरूबाट बच्नका लागि हुनेछन्; ताकि हत्याको आरोप लागेका व्यक्ति समुदायको सामु जाँचबुझ नभई नमारियोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","तिमीहरूले दिने यी छ वटा सहरहरू तिमीहरूकै निम्ति शरण-नगरहरू हुनेछन्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","तीन वटा यर्दन नदीको वारिपट्टि र तीन वटा कनानमा शरण-नगरको रूपमा दिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","यी छ वटा सहरहरू इस्राएलीहरू र तिमीहरूसँग बस्‍ने विदेशीहरूका निम्ति शरणस्थलका ठाउँ हुनेछन्; ताकि कुनै व्यक्तिले कसैलाई अनजानमा मार्‍यो भने त्यहाँ भागेर जान सकोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘यदि कुनै मानिसले कसैलाई फलामको हतियारले हिर्काउँदा त्यो मर्‍यो भने त्यो हत्यारा नै हो। त्यो हत्यारालाई मृत्युदण्ड दिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","अर्थात् कसैको हातमा ढुङ्गा छ, र त्यसले कसैलाई हिर्काउँदा त्यो मर्‍यो भने त्यो हत्यारा हो। त्यो हत्यारालाई मृत्युदण्ड दिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","अर्थात् यदि कसैसँग काठको कुनै चीज छ, र त्यसले कसैलाई हिर्काउँदा त्यो मर्‍यो भने त्यो हत्यारा नै हो। त्यस हत्यारालाई मृत्युदण्ड दिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","रगतको बदला लिने व्यक्तिले त्यस हत्यारालाई मारोस्। त्यसले त्यस हत्यारालाई भेट्नेबित्तिकै मारोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","यदि कुनै मानिसले इर्ष्याको कारण कसैलाई घचेट्यो अथवा जानाजानी त्यसमाथि केही कुरा फ्याँक्यो, र त्यो मर्‍यो भने, ");
INSERT INTO npioncb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","अर्थात् शत्रुताको कारण त्यसले उसलाई हिर्कायो, र त्यो मर्‍यो भने त्यो मानिस हत्यारा हो। त्यसलाई मृत्युदण्ड दिनैपर्छ। रगतको बदला लिनेले त्यस हत्यारालाई भेट्नेबित्तिकै मार्नैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘तर यदि कसैले कसैलाई अनजानमा घचेट्दा मर्‍यो अथवा केही कुरा हानिपठाउँदा लागेर त्यो मर्‍यो भने, ");
INSERT INTO npioncb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","अर्थात् दुश्मनी नभएको र हानि गर्न नचाहेको व्यक्तिले हानेको ढुङ्गाले लागेर कोही मर्‍यो भने, ");
INSERT INTO npioncb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","समुदायले ज्यानमारा र रगतको बदला लिने व्यक्तिको बीचमा यस नियमअनुसार न्याय गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","समुदायले त्यस ज्यानमारालाई रगतको साटो लिनेको हातबाट छुटाएर, त्यो अगि जहाँ भागेको थियो, त्यसलाई त्यही शरण-नगरमा पठाओस्। त्यो ज्यानमारा पवित्र तेलले अभिषेक गरिएको प्रधान पुजारीको मृत्यु नहोउन्जेल त्यहीँ रहोस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘तर यदि त्यो दोषी व्यक्ति कुनै समयमा आफू भागेर गएको शरण-नगरको सिमानादेखि बाहिर गयो भने, ");
INSERT INTO npioncb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","र रगतको बदला लिनेले त्यसलाई बाहिर फेला पारेर त्यसलाई मार्‍यो भने त्यो त्यस हत्याको दोषी हुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","किनभने त्यो दोषी व्यक्ति प्रधान पुजारीको मृत्यु नभएसम्म आफ्नो शरण-नगरमा बस्‍नुपर्थ्यो। अनि प्रधान पुजारीको मृत्यु भएपछि मात्र त्यो आफ्नो घरमा फर्कन सक्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘तिमीहरू जहाँ बसे तापनि तिमीहरू र तिमीहरूका भावी पुस्ताका निम्ति यो नियम लागू हुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘कुनै व्यक्तिले कसैको हत्या गर्‍यो भने त्यसलाई साक्षीहरूको गवाहीद्वारा मात्र मृत्युदण्ड दिनू। तर केवल एक जना साक्षीको गवाहीबाट कसैलाई मृत्युदण्ड नदिनू। ");
INSERT INTO npioncb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘मृत्युदण्ड पाउन लायकको हत्याराको जीवनको छुटकाराको मोल स्वीकार नगर्नू। उसलाई मृत्युदण्ड दिनैपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘शरण-नगरमा भागेर गएको व्यक्तिबाट छुटकाराको मोल स्वीकार नगर्नू; ताकि प्रधान पुजारीको मृत्यु नहोउन्जेल त्यो फर्केर आउन र आफ्नो घरमा बस्‍न नपाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘तिमीहरू बसेको ठाउँलाई दूषित नपार्नू। हत्याले देशलाई दूषित पार्छ, र हत्याराको मृत्युको रगतबाहेक हत्या भएको देशका निम्ति अरू कुनै पनि कुराले प्रायश्‍चित गर्न सकिँदैन। ");
INSERT INTO npioncb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","तिमीहरू बसेको र मैले बास गरेको देशलाई अशुद्ध नपार्नू। किनकि म याहवेह इस्राएलीहरूको बीचमा बास गर्दछु।’ ” ");
INSERT INTO npioncb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","योसेफका सन्तानहरूबाट आएका मनश्शेका छोरा माकीर, माकीरका छोरा गिलाद वंशका परिवारका अगुवाहरू आए। अनि मोशा, अरू अगुवाहरू र इस्राएली परिवारहरूका अगुवाहरूका सामु आए। ");
INSERT INTO npioncb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","अनि तिनीहरूले भने, “जब याहवेहले इस्राएलीहरूलाई पैतृक सम्पत्तिको रूपमा यस देशलाई चिट्ठा हालेर दिनू भनेर मेरा मालिकलाई आज्ञा गर्नुभएको थियो; अनि उहाँले हाम्रा दाजु सलोफादको अधिकार तिनका छोरीहरूलाई दिनू भनेर तपाईंलाई आज्ञा दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","अब मानिलिनुहोस्, यदि तिनीहरूले इस्राएलका अरू कुलका मानिसहरूसँग विवाह गरे भने तिनीहरूका अधिकारको भाग हाम्रा पुर्ख्यौली अधिकारबाट खोसिएर तिनीहरूले विवाह गरेको कुलमा थपिनेछ। यसरी हामीलाई दिइएको अधिकारको केही अंश गुमाउनुपर्ने हुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","जब इस्राएलीहरूका निम्ति पचासौँ उत्सव वर्ष आउँछ, तब तिनीहरूका अधिकारको भाग तिनीहरूले विवाह गरेका कुलमा थपिनेछ। अनि तिनीहरूको पैतृक सम्पत्ति हाम्रा पुर्खाहरूका अधिकारबाट खोसिनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","तब याहवेहको आज्ञामा मोशाले इस्राएलीहरूलाई यो आदेश दिए: “योसेफका सन्ततिका कुलहरूले भनेका कुरा ठिकै हो। ");
INSERT INTO npioncb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","याहवेहले सलोफादका छोरीहरूका निम्ति यस्तो आज्ञा दिनुहुन्छ: तिनीहरूले आफ्ना पिताका पुर्ख्यौली कुलबाट जसलाई पनि आफ्ना राजीखुशीअनुसार विवाह गर्न सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","इस्राएलमा कुनै पैतृक सम्पत्ति एउटा कुलबाट अर्को कुलमा जान पाउँदैन। किनकि प्रत्येक इस्राएलीहरूले तिनीहरूका पुर्खाहरूबाट पाएका पैतृक सम्पत्तिको भाग राख्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","इस्राएलीहरूको कुनै पनि कुलमा उत्तराधिकारको भाग पाउने युवतीले त्यसकै बुबापट्टिको कुलमा विवाह गरोस्। यसरी हरेक इस्राएलीले आफ्नै पैतृक सम्पत्तिको भाग पाओस्। ");
INSERT INTO npioncb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","कुनै पनि पैतृक सम्पत्ति एउटा कुलबाट अर्को कुलमा नजाओस्। तर हरेक इस्राएली आफ्नै पुर्खाका कुलको पैतृक सम्पत्तिमा रहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","यसकारण सलोफादका छोरीहरूले याहवेहले मोशालाई आज्ञा गर्नुभएजस्तै गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","सलोफादका छोरीहरू महला, तिर्सा, होग्ला, मिल्का र नोआहले आफ्नै बुबाका दाजुभाइहरूका छोराहरूसँग विवाह गरे। ");
INSERT INTO npioncb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","तिनीहरूले योसेफका छोरा मनश्शेका सन्ततिहरूका वंशभित्रै विवाह गरे। अनि तिनीहरूका पैतृक सम्पत्तिको भाग तिनीहरूका बुबाकै वंश र कुलमा रह्‍यो। ");
INSERT INTO npioncb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","याहवेहले मोशाद्वारा इस्राएलीहरूलाई, यरीहोदेखि पारिपट्टि यर्दन नदीको किनारमा मोआबको मैदानमा दिनुभएका आज्ञाहरू र नियमहरू यिनै नै हुन्।");
INSERT INTO npioncb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","मोशाले यर्दनको पूर्वको उजाडस्थानमा अर्थात् अराबामा सूपको सामु—पारान एकापट्टि र अर्कोपट्टि तोफेल, लाबान, हसेरोत र दीसाहाबको बीचमा सबै इस्राएलीहरूलाई भनेका वचनहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(सेइर पर्वतको बाटोबाट होरेब पर्वतहुँदै कादेश-बर्नेसम्म जानलाई एघार दिन लाग्छ)। ");
INSERT INTO npioncb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","चालीसौँ वर्षको एघारौँ महिनाको पहिलो दिन याहवेहले इस्राएलीहरूको बारेमा मोशालाई आज्ञा दिनुभएका सबै कुरा तिनले तिनीहरूलाई घोषणा गरे। ");
INSERT INTO npioncb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","योचाहिँ मोशाले हेश्बोनमा राज्य गर्ने एमोरीहरूका राजा सीहोन र अस्तारोतमा राज्य गर्ने बाशानको राजा ओगलाई एद्रईमा जितेपछिको कुरा हो। ");
INSERT INTO npioncb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","यर्दन नदीको पूर्वपट्टि मोआबको प्रान्तमा मोशाले यही व्यवस्था व्याख्या गर्दै भने: ");
INSERT INTO npioncb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","होरेब पर्वतमा याहवेह हाम्रा परमेश्‍वरले हामीलाई भन्‍नुभयो, “तिमीहरू यस पर्वतमा बसेको धेरै समय भइसक्यो। ");
INSERT INTO npioncb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","अब तिमीहरूको छाउनी तोडेर एमोरीहरूको पहाडी मुलुकतिर अगि बढ। अराबाका सबै छिमेकी प्रान्तहरूमा, पर्वतहरूमा, पश्‍चिमका तराईहरूमा, दक्षिणमा र किनारका ठाउँहरूहुँदै, कनानीहरूको देश र लेबनान र महानदी यूफ्रेटिससम्म जाओ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","हेर, मैले यो देश तिमीहरूलाई दिएको छु। मैले तिमीहरूका पुर्खाहरू अब्राहाम, इसहाक, याकोब र तिनीहरूका सन्ततिलाई दिन्छु भनी प्रतिज्ञा गरेको देशमा तिमीहरू गएर अधिकार गर।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","मोशाले भने, “त्यस समय मैले तिमीहरूलाई भनेको थिएँ, म एकलै तिमीहरूको बोझ उठाउन सक्दिनँ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूको संख्यामा वृद्धि गरिदिनुभएको छ। आज तिमीहरू आकाशका ताराहरूझैँ अनगन्ती भएका छौ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","तिमीहरूका पितापुर्खाहरूका परमेश्‍वर याहवेहले प्रतिज्ञा गर्नुभएअनुसार उहाँले तिमीहरूलाई हजार गुणा वृद्धि गरिदेऊन्, र आशिष् देऊन्। ");
INSERT INTO npioncb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","तर म आफैँले मात्र तिमीहरूका समस्याहरू, तिमीहरूका बोझहरू र तिमीहरूका झगडाहरू कसरी झेल्न सक्छु र? ");
INSERT INTO npioncb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","तिमीहरूका कुलहरूबाट केही बुद्धिमान्, समझदार र अनुभवी मानिसहरूलाई रोज। अनि म तिनीहरूलाई तिमीहरूमाथि अगुवा नियुक्त गर्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","तिमीहरूले मलाई जवाफ दियौ, “तपाईंले दिनुभएको प्रस्ताव असल छ।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","यसकारण मैले तिमीहरूका कुलहरूबाट मुख्य व्यक्ति, बुद्धिमान् र अनुभवी मानिसहरूलाई लिएर तिनीहरूलाई हजार-हजार, सय-सय, पचास-पचासमाथि र दश-दशमाथि प्रशासकको रूपमा तिमीहरूमाथि अधिकार गर्नलाई नियुक्त गरेँ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","अनि त्यस बेला मैले तिमीहरूका न्यायकर्ताहरूलाई यसो भनेर जिम्मा दिएको थिएँ, “तिमीहरूका मानिसहरूका बीचका झगडा सुन। चाहे त्यो मुद्दा इस्राएलीहरूका बीचमा होस् अथवा तिनीहरूमध्ये एक जना इस्राएली र अर्कोचाहिँ तिमीहरूसँग बसोबास गर्ने विदेशीको बीचमा होस्। न्याय उचित रूपले गर। ");
INSERT INTO npioncb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","न्याय गर्दा पक्षपात नगर्नू। ठूला र साना दुवैका कुरा तिमीहरूले समान रूपले सुन्‍नू। न्याय परमेश्‍वरबाट भएको हुनाले कुनै मानिससँग नडराउनू। तिमीहरूका निम्ति अति कठिन भएको मुद्दा मकहाँ ल्याउनू। म त्यसको फैसला गर्नेछु।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","अनि मैले त्यस बेला तिमीहरूले गर्नुपर्ने हरेक कुरा तिमीहरूलाई भनेको थिएँ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","त्यसपछि याहवेह हाम्रा परमेश्‍वरले हामीलाई आज्ञा गर्नुभएझैँ, हामी होरेब पर्वतबाट निस्क्यौँ। अनि तिमीहरूले देखेका डरलाग्दो र ठूलो उजाडस्थानबाट भएर हामी एमोरीहरूको पहाडी देशतिर गयौँ। यसरी हामी कादेश-बर्नेमा पुग्यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","तब मैले तिमीहरूलाई भनेँ, “तिमीहरू एमोरीहरूको पहाडी देशमा आइपुगेका छौ, जुन देश याहवेह हाम्रा परमेश्‍वरले हामीलाई दिनुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","हेर, याहवेह तिमीहरूका परमेश्‍वरले यो देश तिमीहरूलाई दिनुभएको छ। याहवेह तिमीहरूका पितापुर्खाहरूका परमेश्‍वरले तिनीहरूलाई भन्‍नुभएझैँ त्यस देशमा तिमीहरू उक्लेर जाओ, र अधिकार गर। तिमीहरू नडराओ; हतोत्साहित नहोओ।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","तब तिमीहरू सबै मकहाँ आएर भन्यौ, “हाम्रा निम्ति त्यस देशको जासुस गर्नलाई हामीले जानुपर्ने बाटो र हामी पुग्ने सहरहरूको बारेमा जानकारी ल्याउनलाई हाम्रा अगि जासुसी गर्ने मानिसहरू पठाऔँ।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","यो कुरो मलाई असल लाग्यो; अनि मैले हरेक कुलबाट एक-एक जना गरी बाह्र जनालाई छानेँ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","तिनीहरू हिँडे, र पहाडी इलाकातिर पुगे। तब तिनीहरू एश्कोलको बेँसीमा आए, र त्यस ठाउँको जासुस गरे। ");
INSERT INTO npioncb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","तिनीहरूले साथमा त्यस देशका केही फलफूल हामीहरूकहाँ ल्याए, र तिनीहरूले जानकारी दिए, “याहवेह हाम्रा परमेश्‍वरले हामीलाई दिनुहुने देश असल रहेछ।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","तर तिमीहरूले अगि जाने इच्छा गरेनौ; तिमीहरूले याहवेह तिमीहरूका परमेश्‍वरको आज्ञाको विरुद्ध विद्रोह गर्‍यौ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","तिमीहरूले आफ्ना पालहरूमा गनगन गर्दै भन्यौ, “याहवेहले हामीलाई घृणा गर्नुहुन्छ। यसैकारण उहाँले हामीलाई एमोरीहरूका हातद्वारा नष्‍ट गर्नलाई इजिप्टबाट निकालेर ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","हामी कहाँ जाऔँ? हाम्रा दाजुभाइहरूले हामीलाई भयभीत बनाएका छन्। तिनीहरू भन्छन्, ‘ती मानिसहरू हामीभन्दा बलिया र अग्ला छन्। त्यहाँका सहरहरू ठूला आकाशसम्म पुग्ने पर्खाल भएका छन्। हामीले त्यहाँ अनाकीहरूलाई पनि देख्यौँ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","तब मैले तिमीहरूलाई भनेँ, “तिमीहरू भयभीत नहोओ; र तिनीहरूसँग नडराओ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","याहवेह तिमीहरूका परमेश्‍वर तिमीहरूका अगि जानुहुनेछ। अनि तिमीहरूका पक्षमा लड्नुहुनेछ; जसरी इजिप्टमा तिमीहरूका निम्ति तिमीहरूकै आँखाको अगि उजाडस्थानमा लड्नुभएको थियो। ");
INSERT INTO npioncb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","अनि तिमीहरू यस ठाउँसम्म नआइपुगुन्जेल याहवेह तिमीहरूका परमेश्‍वरले आफ्ना छोराछोरीलाई बुबाले बोकेझैँ उहाँले बाटोभरि उजाडस्थानमा तिमीहरूलाई कसरी बोक्नुभयो, त्यो तिमीहरूले देख्यौ।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","तर अझ पनि याहवेह तिमीहरूका परमेश्‍वरमाथि तिमीहरूले भरोसा गरेनौ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","उहाँ तिमीहरूले छाउनी बनाउने ठाउँहरू खोज्न र तिमीहरूले हिँड्नुपर्ने बाटो देखाउन राति आगोमा र दिउँसो बादलमा भई तिमीहरूलाई बाटो देखाउन अगि-अगि जानुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","जब तिमीहरूको गनगन याहवेहले सुन्‍नुभयो, तब उहाँ रिसाउनुभयो। अनि उहाँले शपथ लिनुभयो, ");
INSERT INTO npioncb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“मैले तिमीहरूका पितापुर्खाहरूलाई दिन्छु भनी प्रतिज्ञा गरेको असल देशलाई यस दुष्‍ट पुस्ताको एउटै मानिसले पनि देख्नेछैन। ");
INSERT INTO npioncb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","यपून्‍नेको छोरा कालेबचाहिँ अपवाद हो। उसले मात्र त्यो देश देख्नेछ। अनि म त्यसलाई र त्यसका सन्तानलाई त्यसले आफ्नो पाइला टेकेको देश दिनेछु। किनकि त्यसले याहवेहलाई आफ्नो सारा हृदयले पछ्याएको छ।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","तिमीहरूकै कारण याहवेह मसँग पनि रिसाउनुभयो र भन्‍नुभयो, “तँ पनि त्यो देशमा प्रवेश गर्नेछैनस्। ");
INSERT INTO npioncb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","तर तेरो सहायक नूनका छोरा यहोशूले त्यहाँ प्रवेश गर्नेछ। त्यसलाई उत्साह दे। किनकि त्यसले त्यस देशमा अधिकार गर्नलाई इस्राएलीहरूलाई डोर्‍याउनेछ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","अनि तिमीहरूका छोराछोरीहरू, जसलाई कैदमा लगिनेछ भनी तिमीहरू भन्छौ, जो असल र खराब अहिले छुट्याउन सक्दैनन्, तिनीहरू त्यस देशमा प्रवेश गर्नेछन्। म त्यो देश तिनीहरूलाई दिनेछु र तिनीहरूले त्यस देशमा अधिकार गर्नेछन्। ");
INSERT INTO npioncb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","तर तिमीहरूचाहिँ फर्केर लाल समुद्रतिर जाने उजाडस्थानको बाटोतिर लाग।” ");
INSERT INTO npioncb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","तब तिमीहरूले मलाई भन्यौ, “हामीले याहवेहको विरुद्धमा पाप गरेका छौँ। याहवेह हाम्रा परमेश्‍वरले आज्ञा गर्नुभएझैँ हामी अगि जानेछौँ र लडाइँ गर्नेछौँ।” यसरी तिमीहरू हरेकले त्यस पहाडी मुलुकमा उक्लेर जान सजिलो छ भनेर आफ्ना हातहतियारहरू भिर्‍यौ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","तर याहवेहले मलाई भन्‍नुभयो, “तिनीहरूलाई भन्, ‘तिमीहरू लडाइँ गर्न नजाओ; किनकि म तिमीहरूसँग हुनेछैन। तिमीहरू आफ्ना शत्रुहरूद्वारा पराजित हुनेछौ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","यसैकारण मैले तिमीहरूलाई भनेँ, तर तिमीहरूले सुनेनौ। तिमीहरूले याहवेहको आज्ञाको विरोध गर्‍यौ र तिमीहरूको घमण्डमा त्यस पहाडी मुलुकको टुप्पोमा युद्ध गर्न तिमीहरू मोर्चा बाँधेर उक्लियौ। ");
INSERT INTO npioncb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","तब त्यस पहाडी मुलुकमा बस्‍ने एमोरीहरू तिमीहरूको विरुद्धमा निस्किआए। तिनीहरूले तिमीहरूलाई मौरीहरूका हूलले झैँ खेदे, र तिमीहरूलाई सेइरदेखि होर्मासम्मै खेदेर तिमीहरूलाई जिते। ");
INSERT INTO npioncb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","तिमीहरू फर्केर आयौ र याहवेहको सामु रोयौ। तर उहाँले तिमीहरूको रुवाइमा ध्यानै दिनुभएन, र तिमीहरूको पुकार सुन्‍नुभएन। ");
INSERT INTO npioncb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","यसकारण तिमीहरू कादेशमा धेरै दिन बस्यौ—वास्तवमा तिमीहरूले सबै समय त्यहाँ बितायौ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","त्यसपछि हामी फेरि फर्क्यौँ, र याहवेहले मलाई आज्ञा गर्नुभएअनुसार लाल समुद्र जाने बाटो भएर उजाडस्थानतिर लाग्यौँ। धेरै लामो समयसम्म हामी सेइरको पहाडी देशको वरपर भौँतारी हिँड्यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","तब याहवेहले मलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“तिमीहरू यस पहाडी देशको वरपर घुमिरहेको धेरै भयो। अब तिमीहरू उत्तरतर्फ लाग। ");
INSERT INTO npioncb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","मानिसहरूलाई यो आज्ञा दे: ‘तिमीहरू आफ्ना आफन्त एसावका सन्तानका इलाकाबाट भएर जान लागेका छौ, जो सेइरमा बस्छ। तिनीहरू तिमीहरूसँग डराउनेछन्, तर तिमीहरू होशियार रहनू। ");
INSERT INTO npioncb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","तिनीहरूलाई लडाइँ गर्न नउक्साउनू। किनकि म तिमीहरूलाई तिनीहरूका कुनै पनि जमिनको खुट्टा टेक्ने भागधरि दिनेछैनँ। मैले सेइरको पहाडी देश एसावलाई त्यसको आफ्नो अधीनमा हुनलाई दिएको छु। ");
INSERT INTO npioncb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","तिमीहरूले खाएका भोजन र पिएका पानीको लागि तिमीहरूले तिनीहरूलाई मूल्यको रूपमा चाँदी तिर्नुपर्छ।’ ” ");
INSERT INTO npioncb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूका हातका सबै कामहरूमा आशिष् दिनुभएको छ। यस विशाल उजाडस्थानबाट भएर जाने तिमीहरूका यात्रामा उहाँले तिमीहरूलाई हेरचाह गर्नुभएको छ। यी चालीस वर्षहरूमा याहवेह तिमीहरूका परमेश्‍वर तिमीहरूसँग रहनुभएको छ। अनि तिमीहरूलाई कुनै पनि कुराको अभाव भएको छैन। ");
INSERT INTO npioncb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","यसरी हामीले एसावका सन्तानहरू हाम्रा आफन्तहरूलाई पार गर्‍यौँ, जो सेइरमा बस्दछन्। एलात र एस्योन-गेबेरबाट माथि पर्ने अराबाको बाटोबाट हामी फर्केर मोआबको उजाडस्थानको बाटोतिर यात्रा गर्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","तब याहवेहले मलाई भन्‍नुभयो, “मोआबलाई दुःख-कष्‍ट नदिनू, अथवा तिनीहरूलाई लडाइँका निम्ति नउक्साउनू। किनकि म तिमीहरूलाई तिनीहरूका जमिनको कुनै भागसमेत दिनेछैनँ। मैले लोतका सन्ततिलाई आर जमिन अधिकारको रूपमा दिएको छु।” ");
INSERT INTO npioncb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(पहिले त्यहाँ एमी भनिने जातिहरू बस्दथे—अनाकीजस्तै अग्ला, बलिया र असंख्य। ");
INSERT INTO npioncb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","अनाकीहरूजस्तै, तिनीहरूलाई पनि रपाईहरू भनिन्थ्यो। तर मोआबीहरूले तिनीहरूलाई एमीहरू भन्‍ने गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","होरीहरू सेइरमा बस्‍ने गर्दथे। तर एसावका सन्ततिले तिनीहरूलाई धपाए। याहवेहले अधिकार गर्न दिनुभएको देशका मानिसहरूलाई इस्राएलीहरूले नाश पारेझैँ, तिनीहरूले पनि होरवंशीहरूलाई नाश पारे। अनि तिनीहरूका ठाउँमा बसोबास गरेका थिए।) ");
INSERT INTO npioncb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","अनि याहवेहले भन्‍नुभयो, “अब उठ र जेरेदको बेँसी पार गर।” यसकारण हामीले जेरेद बेँसीलाई पार गर्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","हामीले कादेश-बर्ने छोडेको समयदेखि जेरेद बेँसी पार गर्दासम्म अठतीस वर्ष बितिसकेको थियो। त्यस बेलासम्म याहवेहले तिनीहरूसँग शपथ खानुभएझैँ लडाइँ गर्न सक्ने सबै मानिसहरू छाउनीमा नाश भइसकेका थिए। ");
INSERT INTO npioncb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","तिनीहरू छाउनीबाट सम्पूर्ण रूपले नाश नहोउन्जेल याहवेहको हात तिनीहरूको विरुद्धमा थियो। ");
INSERT INTO npioncb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","जब लडाइँ गर्न सक्ने ती मानिसहरूबाट अन्तिम मानिस मरे, ");
INSERT INTO npioncb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","तब याहवेहले मलाई भन्‍नुभयो, ");
INSERT INTO npioncb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“आज तिमीहरूले मोआबको इलाका भएर आरको जमिन पार गर्नुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","जब तिमीहरू अम्मोनीकहाँ आउँछौ, तब तिनीहरूलाई दुःख नदिनू, अथवा लडाइँका लागि नउक्साउनू। किनकि म तिमीहरूलाई अम्मोनीहरूको देशको कुनै पनि भाग अधिकार गर्न दिनेछैनँ। मैले अम्मोन देश लोतका सन्ततिलाई अधिकार गर्न दिएको छु।” ");
INSERT INTO npioncb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(त्यो देश पनि रपाईहरूको देश थियो। तिनीहरू त्यहाँ बस्दथे। तर अम्मोनीहरूले तिनीहरूलाई जमजुम्मीहरू भन्‍ने गर्थे। ");
INSERT INTO npioncb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","तिनीहरू बलिया, असंख्य र अनाकीहरूजस्तै अग्ला थिए। याहवेहले तिनीहरूलाई अम्मोनीहरूको सामुबाट नष्‍ट गरिदिनुभयो। अम्मोनीहरूले तिनीहरूलाई धपाए। अनि तिनीहरूको ठाउँमा बसोबास गर्न थाले। ");
INSERT INTO npioncb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","याहवेहले एसावका सन्ततिलाई पनि त्यसै गर्नुभयो, जो सेइरमा बस्दथे। उहाँले होरीहरूलाई तिनीहरूको सामुबाट नष्‍ट गरिदिनुभयो। एदोमीहरूले तिनीहरूलाई धपाइदिए। तिनीहरू आजसम्म त्यहाँ बसेका छन्। ");
INSERT INTO npioncb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","अनि गाजा सहरसम्म रहेका टाढाका गाउँहरूमा बस्‍ने अव्वीहरूलाई चाहिँ कप्‍तोरबाट आएका कप्‍तोरीहरूले नाश गरे, र तिनीहरूका ठाउँमा बसोबास गरे।) ");
INSERT INTO npioncb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“अब यात्रा सुरु गर, र अर्नोन बेँसी पार गर। हेर, मैले हेश्बोनको राजा एमोरी सीहोन र त्यसको देशलाई तिमीहरूका हातमा दिएको छु। त्यसलाई अधिकार गर्न सुरु गर, र त्यससँग युद्ध गर। ");
INSERT INTO npioncb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","आजको दिनबाट म आकाशमुनि भएका सबै जातिहरूमाथि तिमीहरूको डर र भय हालिदिनेछु। जब तिनीहरूले तिमीहरूको बारेमा सुन्‍नेछन्, तब तिनीहरू डर, भय र तनावले काम्नेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","कदेमोतको उजाडस्थानबाट मैले हेश्बोनको राजा सीहोनकहाँ शान्ति प्रस्तावसहित राजदूतहरूद्वारा यो सन्देश पठाएँ, ");
INSERT INTO npioncb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“हामीलाई तपाईंको देशबाट भएर जान दिनुहोस्। हामी राजमार्गबाट भएर जानेछौँ। हामी दाहिने अथवा देब्रेतिर फर्कनेछैनौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","तपाईंले हामीलाई चाँदीको मूल्यमा खानेकुरा र पिउने पानी बेच्नुहोस्। हामीलाई यस देशबाट पैदल जान अनुमति दिनुहोस्, ");
INSERT INTO npioncb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","जसरी सेइरवासी एसावका सन्तान र आरको जमिनमा बस्‍ने मोआबीहरूले हामीलाई जान दिए; ताकि हामी यर्दन पार गरेर याहवेह हाम्रा परमेश्‍वरले हामीलाई दिनुभएको देशमा पुग्न सकौँ।” ");
INSERT INTO npioncb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","तर हेश्बोनका राजा सीहोनले हामीलाई त्यस देशबाट भएर जान दिएनन्। किनकि याहवेह तिमीहरूका परमेश्‍वरले तिनलाई तिमीहरूको हातमा सुम्पिदिनका लागि तिनको मन कठोर र हृदय अटेरी बनाउनुभएको थियो; जस्तो आज पनि छ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","याहवेहले मलाई भन्‍नुभयो, “हेर्, मैले सीहोन र त्यसको देशलाई तेरो हातमा सुम्पिदिन थालेको छु। अब त्यसलाई आक्रमण गर्न र अधिकार गर्न सुरु गर्।” ");
INSERT INTO npioncb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","जब सीहोन र तिनका सबै सेना यहसाको जमिनमा हामीसँग युद्ध गर्न आए, ");
INSERT INTO npioncb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","तब याहवेह हाम्रा परमेश्‍वरले तिनलाई हाम्रो हातमा सुम्पिदिनुभयो। अनि हामीले तिनलाई, तिनका छोराहरू र सारा सेनाहरूसमेत मार्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","त्यस बेला हामीले तिनका सबै सहरहरू लियौँ। तिनीहरूका मानिसहरू, स्त्रीहरू र छोराछोरीहरू सबैलाई सम्पूर्ण रूपले नष्‍ट गर्‍यौँ। हामीले कसैलाई पनि जीवित छोडेनौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","तर हामीले कब्जा गरेका सहरहरूका गाईबस्तु र लुटको मालसामानचाहिँ आफ्नै लागि लिएर गयौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","अर्नोन बेँसीको छेउमा भएको अरोएरदेखि र बेँसीमा भएको सहरदेखि गिलाद प्रान्तसम्मै भएका कुनै पनि सहर हाम्रा लागि शक्तिशाली थिएनन्। याहवेह हाम्रा परमेश्‍वरले ती सबै देशहरू हामीलाई दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","तर याहवेह हाम्रा परमेश्‍वरको आज्ञाअनुसार तिमीहरूले अम्मोनीहरूका कुनै पनि ठाउँ मिचेनौ, न त यब्बोक नदीका किनारका देश वा पहाडका वरपरका सहरहरूलाई मिच्यौ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","त्यसपछि हामी फर्केर बाशान जाने बाटोतिर उक्ल्यौँ। अनि बाशानका राजा ओग आफ्नो सारा फौज लिएर हामीलाई एद्रईमा युद्ध गर्न निस्किआए। ");
INSERT INTO npioncb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","याहवेहले मलाई भन्‍नुभयो, “त्यससँग नडरा; किनकि मैले त्यसलाई, त्यसका सबै सेनालाई र त्यसको देशसमेत तेरो हातमा सुम्पिदिएको छु। तैँले त्यसलाई हेश्बोनमा शासन गर्ने एमोरीहरूका राजा सीहोनलाई गरेजस्तै गर्नू।” ");
INSERT INTO npioncb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","यसरी याहवेह हाम्रा परमेश्‍वरले बाशानका राजा ओग र तिनका सारा सेनालाई हाम्रा हातमा सुम्पिदिनुभयो। हामीले तिनीहरूलाई एउटै पनि मानिस जीवित नरहुन्जेल मार्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","त्यसै बेला हामीले त्यसका सबै सहरहरू कब्जा गर्‍यौँ। हामीले एउटै पनि सहर नछोडी त्यसका सबै साठी वटा सहरहरू कब्जा गर्‍यौँ। बाशानमा ओगको राज्य अर्गोबको सम्पूर्ण इलाकासमेत कब्जा गर्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ती सबै सहरहरू अग्ला-अग्ला पर्खालहरूले घेरिएका, आग्ला सहितका ढोकाहरू र मूलढोकाहरूले बनाइएका थिए। त्यहाँ पर्खाल नभएका धेरै गाउँहरू पनि थिए। ");
INSERT INTO npioncb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","अनि हामीले हेश्बोनका राजा सीहोनलाई गरेझैँ उनीहरूका सबै सहरहरू, पुरुषहरू, स्त्रीहरू र बालबालिकाहरूलाई सम्पूर्ण रूपले नाश गर्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","तर सहरका सबै गाईबस्तु र लुटका मालसामानचाहिँ हामीले आफ्नै निम्ति लियौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","यसरी त्यस बेला हामीले यी दुई एमोरी राजाहरूबाट यर्दनका पूर्वपट्टि भएको प्रान्त, अर्नोन बेँसीबाट हेर्मोन पर्वतसम्मै अधीनमा पार्‍यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(सीदोनीहरूले हेर्मोन पर्वतलाई सिरिओन र एमोरीहरूले सेनीर भन्दछन्)। ");
INSERT INTO npioncb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","हामीले तराईका सबै सहरहरू, सम्पूर्ण गिलाद, सलेका र एद्रईसम्मका सम्पूर्ण बाशानमा भएका ओगको राज्य अधीनमा लियौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(रपाईहरूमा बाशानका राजा ओग मात्र जीवित रहेका थिए। तिनको चिहान फलामबाट बनिएको थियो। त्यो नौ क्यूबिट लामो, चार क्यूबिट चौडा थियो। यो अझसम्म अम्मोनीहरूको रब्बामा छ।) ");
INSERT INTO npioncb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","त्यस बेला हामीले अधिकार लिएको देशबाट मैले रूबेन र गादका घरानाहरूलाई गिलादको पहाडी मुलुकको आधा भागसँगै त्यसका सहरहरूसमेत गरी अर्नोन बेँसीको छेउमा भएका अरोएरका उत्तरको प्रान्त दिएँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","गिलादको बाँकी रहेको भाग र ओगको राज्य बाशान पनि मैले मनश्शेको कुललाई दिएँ। (बाशानमा अर्गोबका सम्पूर्ण इलाकालाई रपाईहरूको देश भनिन्थ्यो। ");
INSERT INTO npioncb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनश्शेको सन्तान याईरले अर्गोबको समस्त इलाका, गेशूरी र माकातीहरूका सिमानासम्मै कब्जा गरे। बाशान प्रान्तलाई आफ्नै नाम दिए। आजसम्मै बाशानलाई हब्बोत-याईर भनिन्छ)। ");
INSERT INTO npioncb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","अनि मैले गिलादचाहिँ माकीरलाई दिएँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","तर रूबेनी र गादीहरूलाई मैले गिलाददेखि फैलिएर अर्नोन बेँसीसम्म गएको प्रान्त दिएँ (बेँसीको मध्य भागचाहिँ सिमाना थियो) र अम्मोनीहरूको सिमाना यब्बोक नदीसम्मै तिनीहरूलाई दिएँ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","त्यसको पश्‍चिमी सिमानाचाहिँ अराबा थियो, जहाँ यर्दन नदी बग्दथ्यो। किन्‍नरेतदेखि पिसगाको भिरको तल अराबाको समुद्र (अराबा समुद्रको अर्को नाम मृत सागर पनि हो) सम्म थियो। ");
INSERT INTO npioncb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","त्यस समयमा मैले तिमीहरूलाई यसरी आज्ञा दिएँ: “याहवेह तिमीहरूका परमेश्‍वरले यो देश तिमीहरूले अधिकार गर्नु भनी दिनुभएको छ। तर तिमीहरूका सबै बलिया मानिसहरू युद्धका निम्ति हतियार भिरेर तिमीहरूका इस्राएली दाजुभाइहरूको अगि यर्दन नदी पार गरेर जानुपर्छ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","तरै पनि तिमीहरूका पत्नीहरू, तिमीहरूका छोराछोरीहरू र तिमीहरूका गाईबस्तु (तिमीहरूसँग धेरै गाईबस्तु छन् भनी म जान्दछु) चाहिँ मैले दिएको सहरमा बस्‍न सक्छन्। ");
INSERT INTO npioncb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","जबसम्म याहवेहले तिमीहरूलाई दिनुभएजस्तै तिमीहरूका दाजुभाइहरूलाई विश्राम दिनुहुन्‍न, र तिनीहरूले याहवेह तिनीहरूका परमेश्‍वरले तिनीहरूलाई यर्दनपारि दिनुहुने देश प्राप्‍त गर्दैनन्, तिमीहरूले तिनीहरूलाई मदत गर्नुपर्नेछ। त्यसपछि तिमीहरू हरेक मैले तिमीहरूलाई अधिकार गर्न दिएको देशमा फर्केर जान सक्छौ।” ");
INSERT INTO npioncb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","त्यस बेला मैले यहोशूलाई आज्ञा गरेँ: “याहवेह तिमीहरूका परमेश्‍वरले ती दुई राजाहरूलाई के गर्नुभयो, सो तिमीहरू सबैले आफ्नै आँखाले देखेका छौ। तिमीहरू जहाँ गइरहेका छौ, त्यहाँका सबै राज्यहरूलाई पनि याहवेहले त्यसै गर्नुहुनेछ। ");
INSERT INTO npioncb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","तिनीहरूसँग नडराओ; याहवेह तिमीहरूका परमेश्‍वर आफैँ तिमीहरूका निम्ति लड्नुहुनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","अनि मैले त्यस बेला याहवेहसँग यसरी बिन्ती गरे: ");
INSERT INTO npioncb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“हे प्रभु याहवेह, आफ्नो सेवकलाई आफ्नो महानता र आफ्नो शक्ति तपाईंले देखाउन थाल्नुभएको छ। किनकि स्वर्ग वा पृथ्वीमा कुनचाहिँ देव छ, जसले तपाईंले गर्नुभएका शक्तिशाली कार्यहरू र कामहरू गर्न सक्छन्? ");
INSERT INTO npioncb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","मलाई यर्दन नदी पारिको त्यो उत्तम देशमा जान, त्यो सुन्दर पहाडी मुलुक र लेबनानलाई हेर्न दिनुहोस्।” ");
INSERT INTO npioncb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","तर तिमीहरूको कारण याहवेह मसँग रिसाउनुभएको थियो, र उहाँले मेरो कुरा सुन्‍नुभएन। याहवेहले भन्‍नुभयो, “अब भयो, मसँग यस बारेमा फेरि कुरा नगर्। ");
INSERT INTO npioncb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगाको चुचुरोमा चढ्, र पूर्व, पश्‍चिम, उत्तर र दक्षिण चारैतिर हेर्। तैँले त्यस देशलाई आफ्नै आँखाले हेर्। किनकि तैँले यर्दन नदी पार गरेर जान पाउनेछैनस्। ");
INSERT INTO npioncb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","तर यहोशूलाई नियुक्त गर्, र त्यसलाई उत्साह दिएर बलियो बना। किनकि यस जातिलाई त्यसले पारि लैजानेछ र तैँले देख्न लागेको त्यो देश अधिकार गर्न लगाउनेछ।” ");
INSERT INTO npioncb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","यसकारण हामी बेथ-पोरको बेँसीको छेउमा नै बस्यौँ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","अब हे इस्राएलीहरू हो, मैले तिमीहरूलाई सिकाउन लागेका उर्दीहरू र व्यवस्थाहरू सुन। त्यसअनुसार चल्यौ भने तिमीहरू बाँच्नेछौ। अनि याहवेह तिमीहरूका पुर्खाहरूका परमेश्‍वरले तिमीहरूलाई दिनुहुने त्यस देशमा अधिकार गर्न सक्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","मैले तिमीहरूलाई दिएका आज्ञाहरूमा केही नथप्नू, न त त्यसबाट केही घटाउनू। तर मैले तिमीहरूलाई दिएका याहवेह तिमीहरूका परमेश्‍वरका आज्ञाहरू पालन गर्नू। ");
INSERT INTO npioncb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","बाल-पिओरमा याहवेहले के गर्नुभएको थियो, त्यो तिमीहरूले आफ्नै आँखाले देखेका छौ। पिओरमा बालको पछि लाग्ने हरेकलाई तिमीहरूका बीचबाट याहवेह तिमीहरूका परमेश्‍वरले नाश गर्नुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","तर याहवेह तिमीहरूका परमेश्‍वरसँग विश्‍वासयोग्य रहेका जति सबै आजसम्म जीवितै छौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","हेर, मैले याहवेह मेरा परमेश्‍वरले मलाई आज्ञा गर्नुभएझैँ, तिमीहरूलाई उर्दीहरू र व्यवस्थाहरू सिकाएको छु, ताकि तिमीहरूले अधिकार गर्न गइरहेको देशमा तिमीहरूले पालन गर्न सक। ");
INSERT INTO npioncb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","तिमीहरूले ती होसियारीसाथ पालन गर; किनकि ती पालन गर्नाले जाति-जातिहरूले तिमीहरूका बुद्धि र समझशक्ति देख्नेछन्, र तिनीहरूले यी उर्दीहरू सुनेर भन्‍नेछन्, “वास्तवमै यो महान् जाति बुद्धिमान् र समझदार मानिसहरू रहेछन्।” ");
INSERT INTO npioncb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","हामीले प्रार्थना गर्दा याहवेह हाम्रा परमेश्‍वर नजिक हुनुभएजस्तै, अरू कुनचाहिँ जाति यति महान् होला, जसको ईश्‍वर तिनीहरूका नजिक रहन्छ? ");
INSERT INTO npioncb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","अनि मैले आज तिमीहरूलाई दिएका व्यवस्थाहरूजस्तै धार्मिक उर्दीहरू र व्यवस्थाहरू भएका अर्को कुनचाहिँ महान् जाति छ र? ");
INSERT INTO npioncb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","केवल होशियार बस, र आफूलाई नियालेर हेर; ताकि तिमीहरू बाँचुन्जेल तिमीहरूका आँखाले देखेका कुराहरू नबिर्सिऊन् अथवा ती तिमीहरूका हृदयबाट हराएर नजाऊन्। ती आफ्ना छोराछोरीहरू र नातिनातिनाहरूलाई सिकाओ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","तिमीहरू होरेब पर्वतमा याहवेह तिमीहरूका परमेश्‍वरको सामु खडा भएको दिन नबिर्सनू; जुन दिन उहाँले मलाई यसरी भन्‍नुभएको थियो, “समुदायलाई मेरो कुरा सुन्‍न मेरो सामु भेला गर्; ताकि तिनीहरू यस देशमा बाँचुन्जेल मेरो आदर गर्न सिकून्। अनि तिनीहरूले आफ्ना भावी सन्तानहरूलाई पनि सिकाऊन्।” ");
INSERT INTO npioncb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","तिमीहरू नजिक आएर पर्वतको फेदमा उभियौ। त्यस पर्वतमा घोर अन्धकार र कालो बादल घोर अन्धकारसँगै आगोको ज्वाला आकाशसम्मै उठिरहेको थियो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","तब याहवेह तिमीहरूसँग त्यस आगोबाट बोल्नुभयो। तिमीहरूले बोल्दै गरेका शब्दहरूको आवाज सुन्यौ; र कुनै आकृति देखेनौ, तर त्यहाँ आवाज मात्र सुनियो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","उहाँले आफ्नो करार, आफ्ना दश आज्ञाहरू तिमीहरूले पालन गर्नू भनेर तिमीहरूलाई घोषणा गर्नुभयो। त्यसपछि ती आज्ञाहरूलाई ढुङ्गाका दुई वटा पाटीहरूमा लेखिदिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","अनि त्यस बेला याहवेहले मलाई तिमीहरूले यर्दन नदी पार गरेर अधिकार गर्ने देशमा पुगेर पालन गर्न उर्दीहरू र व्यवस्थाहरू सिकाउनू भन्‍ने आज्ञा दिनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","होरेब पर्वतमा याहवेह तिमीहरूसँग आगोबाट कुरा गर्नुभएको दिन तिमीहरूले कुनै आकृति देखेनौ। यसकारण तिमीहरू आफैँ होशियार बस। ");
INSERT INTO npioncb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","यसकारण भ्रष्‍ट भएर आफ्ना निम्ति कुनै प्रकारको प्रतिमूर्ति, पुरुष अथवा स्त्रीको रूपमा, ");
INSERT INTO npioncb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","अथवा पृथ्वीमा भएको कुनै पशुको अथवा आकाशमा उड्ने कुनै चराको, ");
INSERT INTO npioncb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","अथवा जमिनमा हिँड्ने कुनै जन्तुको अथवा पानीमा भएको माछाको प्रतिमूर्ति नबनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","अनि तिमीहरूले आकाशतिर हेर्दा घाम, जुन र ताराहरू सबै शक्तिहरू देख्यौ भने तिनीहरूका अगि ननिहुरनू। अनि याहवेह तिमीहरूका परमेश्‍वरले आकाशमुनि भएका सबै जातिहरूलाई दिनुभएका सबै चीजहरू पूजा गर्नलाई तिमीहरू नलोभिनू। ");
INSERT INTO npioncb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","तर तिमीहरूका निम्ति याहवेहले तिमीहरूलाई अहिले भएजस्तै उहाँको उत्तराधिकारका मानिसहरू बन्‍न तिमीहरूलाई त्यस फलाम पगाल्ने भट्टीजस्तो इजिप्टबाट निकालेर ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","तर तिमीहरूको कारण याहवेह मसँग रिसाउनुभयो। याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूलाई पैतृक अधिकारझैँ दिनुहुने उत्तम देशमा जानलाई मैले यर्दन पार गर्न पाउनेछैन भनी उहाँले शपथ खानुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","म त यसै देशमा मर्नेछु। म यर्दन नदी पार गर्नेछैन; तर तिमीहरू यर्दन पार भएर त्यस उत्तम देशमा अधिकार गर्न लागेका छौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","यसैले याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूसँग गर्नुभएको करार नबिर्सनू। याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूलाई मनाही गर्नुभएको कुनै पनि कुराको प्रतिमूर्ति नबनाउनू। ");
INSERT INTO npioncb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","किनकि याहवेह तिमीहरूका परमेश्‍वर भस्म पार्ने आगो, डाह गर्ने परमेश्‍वर हुनुहुन्छ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","तिमीहरूका छोराछोरी र नातिनातिना जन्मिसकेपछि र त्यस देशमा धेरै समय बसिसकेपछि, अर्थात् यदि तिमीहरू भ्रष्‍ट भएर कुनै किसिमका प्रतिमूर्ति बनायौ र याहवेह तिमीहरूका परमेश्‍वरको दृष्‍टिमा दुष्‍ट काम गरेर उहाँलाई रिस उठायौ भने, ");
INSERT INTO npioncb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","म आज स्वर्ग र पृथ्वीलाई तिमीहरूको विरुद्धमा साक्षी राख्दछु। तिमीहरू अधिकार गर्नलाई यर्दन नदी पार गरेर जान लागेको त्यस देशबाट चाँडै नष्‍ट हुनेछौ। तिमीहरू त्यहाँ लामो समयसम्म बस्‍न पाउनेछैनौ, तर निश्‍चय नै नष्‍ट पारिनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","याहवेहले तिमीहरूलाई जाति-जातिहरूका बीचमा छरपस्ट पार्नुहुनेछ। अनि जुन जाति-जातिहरूका बीचमा तिमीहरूलाई धपाउनुहुनेछ, त्यहाँ तिमीहरू थोरै मात्र जीवित रहनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","त्यहाँ तिमीहरूले मानिसहरूले काठ र ढुङ्गाबाट बनाएका देख्न नसक्ने, सुन्‍न नसक्ने, खान नसक्ने र सुँघ्न नसक्ने देवी-देवताहरूका पूजा गर्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","तर यदि त्यहाँबाट पनि तिमीहरूले याहवेह तिमीहरूका परमेश्‍वरलाई तिमीहरूका सारा हृदयले र सारा प्राणले खोजी गर्‍यौ भने तिमीहरूले उहाँलाई भेट्टाउनेछौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","जब तिमीहरू सङ्कष्‍टमा पर्छौ र यी सबै कुराहरू तिमीहरूमा आइपर्नेछन्, तब आखिरमा तिमीहरू याहवेह तिमीहरूका परमेश्‍वरतिर फर्कनेछौ। अनि उहाँका आज्ञाहरू पालन गर्नेछौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","किनकि याहवेह तिमीहरूका परमेश्‍वर कृपालु परमेश्‍वर हुनुहुन्छ। उहाँले तिमीहरूलाई त्याग्नुहुनेछैन; न त नाश गर्नुहुनेछ अथवा तिमीहरूका पुर्खाहरूसँग शपथद्वारा निश्‍चित गर्नुभएको करार उहाँले बिर्सनुहुनेछैन। ");
INSERT INTO npioncb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","अब पहिलेका दिनहरूको बारेमा तिमीहरूका समयभन्दा धेरै पहिलेका समयको, जुन दिन परमेश्‍वरले पृथ्वीमा मानिसलाई सृष्‍टि गर्नुभयो, त्यस बारेमा सोधिहेर। आकाशका एक छेउदेखि अर्को छेउसम्मका कुराहरू सोधपुछ गरिहेर। के यस्तो महान् कुरा कहिल्यै भएको छ, अथवा के यस्तो कुनै कुरा कहिल्यै सुनिएको छ? ");
INSERT INTO npioncb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","के कुनै अरू मानिसहरूले तिमीहरूले सुनेको जस्तै परमेश्‍वर आगोबाट बोल्नुभएको आवाज सुनेर तिमीहरूजस्तै जीवित रहेका छन्? ");
INSERT INTO npioncb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","याहवेह तिमीहरूका परमेश्‍वरले इजिप्टमा तिमीहरूकै आँखाको सामु गर्नुभएका विपत्तिद्वारा, अलौकिक चिन्हहरूद्वारा, अद्‌भुत कार्यहरूद्वारा, चमत्कारद्वारा, युद्धद्वारा, शक्तिशाली हात र फैलिएको पाखुराद्वारा अथवा महान् र उदेकका कामहरूद्वारा के कुनै देवताले यी कार्यद्वारा अरू जातिहरूबाट आफ्ना निम्ति एउटा जातिलाई कहिल्यै लिएको छ? ");
INSERT INTO npioncb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","याहवेह नै परमेश्‍वर हुनुहुन्छ; उहाँबाहेक अर्को परमेश्‍वर कोही छैन भनी बुझाउनलाई यी सबै कुराहरू तिमीहरूलाई देखाइएका हुन्। ");
INSERT INTO npioncb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","तिमीहरूलाई शिक्षा दिनलाई स्वर्गबाट उहाँले तिमीहरूलाई आफ्नो सोर सुन्‍न लगाउनुभयो। पृथ्वीमा उहाँले तिमीहरूलाई आफ्नो महान् आगो देखाउनुभयो र आगोको बीचबाट तिमीहरूले उहाँका शब्दहरू सुन्यौ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","उहाँले तिमीहरूका पितापुर्खाहरूलाई प्रेम गर्नुभएको कारण तिनीहरूका सन्तानहरूलाई चुन्‍नुभयो। उहाँले तिमीहरूलाई उहाँको उपस्थिति र उहाँको महान् शक्तिद्वारा इजिप्टबाट बाहिर निकालेर ल्याउनुभयो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","उहाँले तिमीहरूभन्दा महान् र शक्तिशाली जातिहरूलाई तिमीहरूकै सामु धपाउन र तिनीहरूको देशमा तिमीहरूलाई ल्याउनुभएको थियो, र त्यो तिमीहरूलाई पैतृक अधिकारको रूपमा दिनलाई यस्तो गर्नुभएको थियो; जुन आजसम्मै तिमीहरूसँग छँदैछ। ");
INSERT INTO npioncb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","माथि स्वर्गमा र तल पृथ्वीमा याहवेह परमेश्‍वर हुनुहुन्छ। उहाँबाहेक अर्को कोही छैन भनी आजको दिन यो कुरा हृदयमा मनन गर, र स्वीकार गर। ");
INSERT INTO npioncb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","मैले आज तिमीहरूलाई दिएका उहाँका उर्दीहरू र आज्ञाहरू पालन गर; ताकि याहवेह तिमीहरूका परमेश्‍वरले तिमीहरूलाई सधैँका निम्ति दिनुभएको देशमा तिमीहरू र तिमीहरूका भावी सन्तानहरूलाई असल होस्। ");
INSERT INTO npioncb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","तब मोशाले यर्दन नदीको पूर्वपट्टि तीन वटा सहरहरू अलग गरे। ");
INSERT INTO npioncb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","यदि कसैले योजना गरेर जानाजानी होइन, तर अनजानमा आफ्नो छिमेकीलाई मारेको छ भने त्यो मानिस ती सहरहरूमा भागेर जाओस्। हत्याराले यी सहरहरूमध्ये कुनै एक सहरमा भागेर आफ्नो प्राण बचाओस्। ");
INSERT INTO npioncb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ती शरणका सहरहरू यिनै थिए: रूबेनीहरूका निम्ति उजाडस्थानको मरुभूमिमा रहेको बेसेर सहर; गादीहरूका निम्ति गिलादमा भएको रामोत सहर र मनश्शेहरूका निम्ति बाशानमा भएको गोलान सहर। ");
INSERT INTO npioncb_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","मोशाले इस्राएलीहरूको सामु राखिदिएको व्यवस्था यही हो। ");
INSERT INTO npioncb_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","तिनीहरू इजिप्टबाट निस्केर आएपछि मोशाले तिनीहरूलाई दिएका नियमहरू, उर्दीहरू र व्यवस्थाहरू यिनै हुन्। ");
INSERT INTO npioncb_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","त्य