﻿USE sofia;
DROP TABLE IF EXISTS sofia.npi2010_vpl;
CREATE TABLE npi2010_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES npi2010_vpl WRITE;
INSERT INTO npi2010_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","आरम्भमा परमेश्वरले आकाश र पृथ्वी सृष्टि गर्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्वी शून्य थियो, पृथ्वीमा केही पनि थिएन। समुद्रलाई अँध्यारोले ढाकेको थियो अनि परमेश्वरको आत्मा पानीमाथि परिभ्रमण गरिरहन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","तब परमेश्वरले भन्नुभयो, “उज्यालो होस्!” अनि उज्यालो चम्कन थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेश्वरले उज्यालो देख्नु भयो अनि त्यसलाई असल मान्नु भयो। तब परमेश्वरले उज्यालो र अँध्यारोलाई छुट्याउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्वरले उज्यालोलाई “दिन” र अँध्यारोलाई “रात” नाउँ दिनु भयो। साँझ पर्यो अनि बिहान भयो। यो पहिलो दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","तब परमेश्वरले भन्नुभयो, “पानीलाई दुइ भाग पार्न त्यहाँ बतास होस्!” ");
INSERT INTO npi2010_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","यसर्थ परमेश्वरले त्यहाँ बतास सृष्टि गर्नुभयो अनि पानी छुट्टियो। केही पानी बतासमाथि रहयो अनि केही पानी बतास मुनि। ");
INSERT INTO npi2010_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्वरले त्यस बतासलाई “आकाश” नाउँ दिनु भयो। साँझ पर्यो अनि बिहान भयो। यो दोस्रो दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","तब परमेश्वरले भन्नुभयो, “आकाश मुनिको पानी एकै ठाउँमा जम्मा होस्, र त्यहाँ सुख्खा भूमि देखियोस्।” अनि त्यस्तै भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","त्यो सुख्खा भूमिलाई परमेश्वरले “पृथ्वी” नाउँ राख्नु भयो। अनि एकै ठाउँमा जम्मा भएको पानीलाई “समुद्र” नाउँ राख्नु भयो। परमेश्वरलाई यस्तो भएकोमा असल लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","तब परमेश्वरले भन्नुभयो, “पृथ्वीमा घाँस, अन्न उत्पन्न गर्ने उद्भिद तथा फल हुने बोटहरु उम्रियोस्। फल-रूखहरुले बीउ भएका फल फलाउने छन्। अनि प्रत्येक रूखले आफ्नै जातिका बीउ उब्जाउनेछ। यी उद्भिदहरू पृथवीमा उम्रिउन्।” अनि यस्तै भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","पृथ्वीमा घाँस र उद्भिदहरू उम्रे अनि अन्नहरू फले। अनि पृथ्वीमा फलभित्र बीउहरु हुने फल फल्ने रुखहरु उम्रिए। प्रत्येक उद्भिदले आफ्नै प्रकारको बीउहरु सिर्जना गरे। अनि परमेश्वरले यिनलाई देखेर असल मान्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","साँझ पर्यो अनि बिहान भयो। यो तेस्रो दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","तब परमेश्वरले भन्नुभयो, “आकाशमा उज्यालो होस्। यी उज्यालाहरुले दिनहरुबाट रातहरुलाई छुट्‌याउनेछन्। यो उज्यालाहरुलाई विशेष चिन्हहरुको निम्ति प्रयोग गरिनेछन् र यिनीहरुले सभाहरु कहिले हुने बताउनेछन्। अनि यिनीहरुलाई दिनहरु र वर्षहरु बताउनमा प्रयोग गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","यी उज्यालाहरु पृथ्वीमा ज्योति चम्काउनको निम्ति आकाशमा रहनेछन्।” अनि यस्तै भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","यसर्थ परमेश्वरले दुईवटा ठूला-ठूला प्रकाश पुञ्जहरु निर्माण गर्नुभयो। दिनमा प्रयोग गर्नको निम्ति परमेश्वरले ठूलो प्रकाश-पुञ्ज बनाउनु भयो अनि रातको निम्ति सानो प्रकाश-पुञ्ज बनाउनु भयो। परमेश्वरले ताराहरु पनि सृष्टि गर्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","पृथ्वीलाई उज्यालो पार्नको निम्ति यी प्रकाश-पुञ्जहरु परमेश्वरले आकाशमा राख्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","यसकारण उहाँले तिनीहरुलाई आकाशमा दिन र रातमाथि शासन गाराउनु भयो। यी प्रकाश पुञ्जहरुले अँध्यारोबाट उज्यालो छुट्याए अनि परमेश्वरलाई यो असल लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","त्यहाँ साँझ पर्यो र फेरि अर्को बिहान भयो। यो चौथो दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","तब परमेश्वरले भन्नुभयो, “पानी धेरै-धेरै प्राणीहरुले भरियोस्।” अनि पृथ्वीमाथि आकाशको फैलावटमा चरा चुरुङ्गीहरु उड्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","यसर्थ परमेश्वरले सामुद्रिक ठूला-ठूला प्राणीहरु र पानीमा पौडिने विभिन्न प्रकारका जीव जन्तुहरु सृष्टि गर्नुभयो। परमेश्वरले आकाशमा उड्ने जाति-जातिका प्राणीहरु सृष्टि गर्नुभयो। पृथ्वीमा जलचर र थलचर विभिन्न प्रकारका प्राणीहरु परमेश्वरले सृष्टि गरी हेर्नु भयो र ती सबै असल लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्वरले यी सबै प्राणीहरुलाई आशीर्वाद दिएर भन्नुभयो, पानीका प्राणीहरुले धेरै बच्चाहरु जन्माएर समुद्र भरियोस् अनि भूमिमा पनि चरा-चुरुङ्गीहरुले धेरै-धेरै बच्चाहरु जन्माएर पृथ्वी भरियोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","त्यहाँ साँझ पर्यो र फेरि अर्कौ बिहान भयो। यो पाँचौ दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","परमेश्वरले भन्नुभयो, “पृथवीले धेरै प्रकारका जीवित चीजहरु बनाओस्। त्यहाँ घरेलु पशुहरु, घस्त्रने जन्तुहरु अनि सबै प्रकारको जङ्गली जनावरहरु रहोस्।” अनि परमेश्वरले इच्छा गर्नु भएझैं नै यी सबै भए। ");
INSERT INTO npi2010_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","यसर्थ परमेश्वरले जङ्गली जनावरहरु, पाल्तू जनावर, सा-साना घस्रने जनावर विभिन्न प्रकारका प्राणीहरु सृष्टि गरेर हेर्दा उहाँलाई राम्रो लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","तब परमेश्वरले भन्नुभयो, “अब हामी मानिस सृष्टि गरौं। हामी मानिस हाम्रै स्वरुप बनाउनेछौं र मानिस हामी जस्तै हुनेछन्। तिनीहरुले जलचर, नभचर, स्थलचरमा ठूला साना अनि घस्रने सबै प्राणीहरुमाथि शासन गर्नैछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","यसर्थ परमेश्वरले आफ्नै प्रतिरूपमा मानिसलाई सृष्टि गर्नुभयो। परमेश्वरले आफ्नै स्वरुपमा मानिसलाई सृष्टि गर्नु भयो। उहाँले पुरुष र स्त्री सृष्टि गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्वरले तिनीहरुलाई आशीर्वाद दिंदै भन्नुभयो, “धेरै सन्तानहरु उत्पति गराऊ र पृथवी भरेर तिनीहरुको हेरचाह गर। समुद्रका माछाहरु, आकाशमा उड्ने चराहरु अनि पृथ्वीमा हिँडडुल गर्ने, सबै प्राणीहरुमाथि शासन गर।” ");
INSERT INTO npi2010_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","परमेश्वरले भन्नुभयो, “म तिमीहरुलाई अन्न हुने उद्भिद र फल फल्ने रूखहरु दिन्छु। ती रुखहरुले आफैं भित्र फेरि उम्रने बीउ भएका फलहरु दिनेछन् र यी अन्न र फलहरु तिमीहरुको निम्ति खाद्य-पदार्थ हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","म फेरि पशुहरुलाई खानका निम्ति हरियो घाँस तथा उद्भिद दिनेछु र पृथ्वीमा भएका प्रत्येक सा-साना घस्रने प्राणीहरु, आकाशमा उड्ने चराहरु अनि पृथ्वीका सबै जनावरहरुले, यी चीजहरु खानेछन्।” अनि यस्तै भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","परमेश्वरले आफूले सृष्टि गरेका प्रत्येक चीजको निरीक्षण गर्नु भयो अनि सबै असल लाग्यो। त्यहाँ साँझ पर्यो र फेरि अर्को बिहान भयो। यो छैटौं दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","यसरी पृथ्वी, आकाश र तिनीहरुभित्र प्रत्येक वस्तुको सृष्टि पूरा भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","परमेश्वरले आफूले गर्दै गरेको काम पूरा गर्नुभयो। यसर्थ, सातौं दिनमा परमेश्वरले आफ्ना कामहरुबाट विश्राम लिनुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","परमेश्वरले सातौं दिनलाई आशीर्वाद दिनुभयो र एउटा पवित्र दिन बनाउनु भयो, परमेश्वरले यस दिनलाई एक विशेष दिन मान्नुभयो कारण त्यस दिन उहाँले संसार सृष्टि गर्ने कार्यबाट विश्राम लिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","आकाश र पृथ्वीको इतिहास यही हो। परमेश्वरले पृथ्वी र आकाश सृष्टि गर्दा भएका घटनाहरुको कुरा यही नै हो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","पृथ्वीमा उद्भिदहरुको उंम्रनु अघिका कुरा यही हुन्। भूमिहरुमा केही पनि उम्रेको थिएन, किनभने परमप्रभुले पृथ्वीमा यतिञ्जेल पानीसम्म वर्षाउँनु भएको थिएन। त्यहाँ उद्भिदहरु हेरचाह गर्नलाई कुनै व्यक्ति पनि थिएन। ");
INSERT INTO npi2010_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","पृथ्वीबाट पानी निस्कियो अनि मैदानमा फैलियो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","तब त्यसपछि परमप्रभु परमेश्वरले भूँईबाट माटो उठाउनु भयो अनि मानिस सृष्टि गर्नु भयो। परमप्रभुले मानिसको नाकबाट सास हालिदिनु भयो र यसलाई जिउँदो बनाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","परमप्रभु परमेश्वरले अदन नाउँ भएको ठाउँमा पूर्वपट्टि एउटा बगैंचा बनाउनु भयो र उहाँले सृष्टि गर्नु भएको मानिसलाई त्यहाँ राख्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","परमेश्वरले भूमिबाट राम्रा-राम्रा रुखहरु अनि खान योग्य फलहरु लाग्ने रुखहरु उमार्नु भयो। उहाँले बगैंचाको बीचमा जीवनको रुख अनि असल र खराबको ज्ञान दिन योग्य रुख पनि रोप्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बगैंचा भिजाउनलाई अदनबाट एउटा नदी बग्यो र पछि त्यो नदी चारवटा शाखाहरुमा विभाजन भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ती शाखाहरुमध्ये पहिलो शाखा नदीको नाउँ पीशोन हो। यो त्यही नदी हो जुन हवीलाको सम्पूर्ण भूमिमा बग्छ र त्यहाँ सुन पाइन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","यस प्रदेशको सुन राम्रो दर्जाको छ। धूप गोमेद र पत्थर पनि पाइन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","दोस्रो नदीको नाउँ गीहोन हो र कूश देशको सम्पूर्ण भूमिमा बग्ने नदी पनि यही हो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","तेस्रो शाखा नदीको नाउँ हिद्‌देकेल हो र यो नदी अश्शूरको पूर्वतिर बग्छ। चौथो शाखा नदीको नाउँ यूफ्रेटिस हो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","तब परमप्रभु परमेश्वरले मानिसलाई लानु भयो अनि बगैंचा खन-जोत अनि हेरचाह गर्न उसलाई राख्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","परमप्रभु परमेश्वरले त्यस मानिसलाई आज्ञा दिनु भयो। परमप्रभु परमेश्वरले भन्नुभयो, “तिमीले कुनै चिन्ता बिना यस बगैंचाको कुनै पनि रुखबाट फलहरु खान सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","तर तिमीले त्यस रुखको कुनै फल खानु हुँदैन जसले असल र खराबको ज्ञान दिन्छ, किनभने जुन दिन तिमी त्यस रुखको फल खान्छौ निश्चयनै त्यस दिन तिमी आफै मर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","तब फेरि परमप्रभु परमेश्वरले भन्नुभयो, “मानिसको लागि एक्लो बस्नु राम्रो होइन। म उसको लागि एकजना सहयोगी बनाउनेछु जो उ जस्तै नै हुनेछे।” ");
INSERT INTO npi2010_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","यसर्थ परमप्रभु परमेश्वरले जमीनका सबै पशुहरु र आकाशमा चरा-चुरूङ्गीहरु सृष्टि गरी तिनीहरुको के के नाउँ राख्दा रहेछन् भनी मानिसकहाँ पठाउनु भयो। अनि मानिसले तिनीहरुलाई जे भने तिनीहरुको त्यही नाउँ रह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","अनि मानिसले पाल्तू गाई वस्तु, आकाशमा उड्ने चरा-चुरुङ्गीहरु र जङ्गली जनावरहरुको नाउँ राख्यो। तर मानिसको निम्ति कुनै सहयोगी साथी पाएन। ");
INSERT INTO npi2010_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","त्यसपछि परमप्रभु परमेश्वरले मानिसलाई गहिरो निंद्रामा सुताउनु भयो। जब त्यो मानिस गहिरो निंद्रामा पर्यो उहाँले एउटा करङ्ग निकालेको ठाउँमा मासुले पुरिदिनुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","त्यस मानिसबाट निकालिएको करङ्गबाट उहाँले एउटी स्त्री मानिस सृष्टि गरी तिनलाई त्यस मानिस कहाँ ल्याउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","तब त्यस मानिसले भने, “आखिरमा म जस्तै अर्को एउटा व्यक्ति उसको हड्डी मेरो हड्डी बाट आयो, अनि उसको शरीर मेरो शरीरबाट आयो। किनभने तिनी एउटा मानिसबाट निकालिएकी हुनाले म तिनलाई ‘स्त्री मानिस’ भन्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","यसकारण, एकजना मानिसले आफ्नो आमा-बाबुलाई छोडेर आफ्नी पत्नीसित सम्बन्ध राख्छ। यसरी दुइजना मानिसहरु एउटै बनिन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","त्यो मानिस र तिनकी पत्नी नाङ्गै भएता पनि तिनीहरु लाज मान्दैन थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","परमप्रभु परमेश्वरले सृष्टि गर्नु भएको सबै जन्तुहरु मध्ये सर्प अत्यन्त धूर्त थियो। सर्पले उसलाई सोध्यो, “ए नारी! के परमेश्वरले बगैंचामा कुनै पनि रुखबाट फल खानु हुँदैन भनी मनाही गर्नु भएको छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","त्यस स्त्रीले सर्पलाई उत्तर दिईन्, “होइन! परमेश्वरले त्यसो भन्नु भएन। हामीले बगैंचामा भएका रुखहरुको फल खान सक्छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","तर परमेश्वरले भन्नुभयो, “तिमीहरुले बर्गैचाको बीचमा भएको रुखको फल खानु हुँदैन, तिमीहरुले छुनु पनि हुँदैन, नत्र तिमीहरु मर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","तर सर्पले स्त्रीलाई भने, “तिमीहरु निश्चय मर्ने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","परमेश्वरले पनि जान्नु हुन्छ जब तिमीहरुले त्यस रुखको फल खान्छौ तिमीहरुको ज्ञान खोलिन्छ अनि तिमीहरु कुन असल कुन खराब जान्ने ज्ञानी भई परमेश्वर जस्तै हुनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","तब त्यो स्त्रीले त्यस रुखको फल हेर्नमा राम्रो र खानमा पनि असल बुझिन् कारण त्यस रुखको फलले ज्ञान दिन्थ्यो त्यस रुखबाट केही फलहरु टिपेर खाई अनि आफूसंग भएको मानिसलाई पनि खान दिई र उसले पनि खायो। ");
INSERT INTO npi2010_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","तब तिनीहरुले केही अनौठो अनुभव गरे। तिनीहरुले देखे तिनीहरु नाङ्गै थिए। यसर्थ तिनीहरुले नेभाराको पात गाँसे अनि आफ्ना निम्ति लुगाहरु बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","जब साँझको हावा बहिरहेको थियो परमप्रभु परमेश्वर बगैंचामा घुमिरहनु हुँदा ती पुरुष र स्त्रीले परमप्रभु परमेश्वरको आवाज चाल पाएर तिनीहरु बगैंचाको रुखहरुमाझ लुके। ");
INSERT INTO npi2010_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","परमप्रभु परमेश्वरले त्यस पुरुष मानिसलाई बोलाउनु भयो अनि सोध्नु भयो, “तिमी कहाँ छौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","तब त्यस पुरुष मानिसले उत्तर दियो, “तपाईको आवाज मैले बगैंचा भित्र चाल पाएँ र म नाङ्गैं रहेको हुँदा डराएँ र म लुकें।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","तब परमप्रभु परमेश्वरले भन्नुभयो, “तिमी नाङ्गैं छौ भनी कसले भन्यो? के तिमीले मैले जुन रुखबाट फल नखानु भनी आज्ञा दिएको थिएँ त्यसैको फल त खाएनौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","त्यस मानिसले भने, “स्त्री जो तपाईंले मसित बस्न दिनु भयो, उसैले मलाई रुखको फल दिईन् अनि मैले खाएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","तब परमप्रभु परमेश्वरले त्यस स्त्री मानिसलाई भन्नुभयो, “तिमीले किन यस्तो काम गर्यौ?” तब त्यस स्त्रीले भनी, “सर्पले मलाई धोका दियो र मैले त्यो फल खाएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","तब परमप्रभु परमेश्वरले सर्पलाई भन्नुभयो, “तैंले यस्तो काम गरेको हुनाले, तँलाई अन्य पशुहरु गाई-वस्तु र अरु सबै जंङ्गली पशुहरुलाईभन्दा अझै ज्यादा श्राप दिनेछु। तैंले तेरो जीवन भरी आफ्नो पेटले घस्रनु र माटो खाएर बस्नु परोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","म तँ र त्यस स्त्रीमाझ शत्रुता सृष्टि गर्नेछु। तेरो सन्तान र त्यस स्त्रीका सन्तानमाझ पनि शत्रुता सृष्टि गर्नेछु जसले गर्दा त्यसका सन्तानहरुले तेरो टाउको किच्याउने छन् अनि तेरा सन्तानहरुले पनि तिनीहरुको कुर्कुचामा डस्ने छन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","त्यसपछि परमप्रभु परमेश्वरले त्यस स्त्रीलाई भन्नुभयो, “जब तिमी गर्भधारण गर्नेछौ त्यस अवस्थामा म तिमीलाई अति कष्ट दिनेछु, र आफ्नो सन्तान जन्माउने बेलामा तिमीले साह्रै नै प्रसव वेदना सहनु पर्नेछ। तिमी आफ्नो पतिको चाहना गर्नेछौ। तर उनले तिमीलाई शासन गर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","त्यसपछि परमप्रभु परमेश्वरले त्यस मानिसलाई भन्नुभयो, “जब तिमीले तिम्री पत्नीको कुरा मानेर मैले नखानु भनी आज्ञा दिएको रुखको फल खायौ, र म तिम्रो कारणले भूमिलाई सराप्ने छु, जुन खाद्यय पदार्थ भूमिबाट तिमीले पाउनेछौ त्यसको निम्ति तिमीले तिम्रो सारा जीवन भरि मेहनत गर्नु पर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","त्यो भूमिले तिम्रो निम्ति जंङ्गली घाँस र काँढाहरु उमार्नेछ, अनि तिमीले जङ्गलमा उम्रेको सागपात खानु पर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","तिमीले आफ्नो आहारको निम्ति आफ्नो अनुहार पसीनाले छ्याप्-छ्याप्ती नहुञ्जेलसम्म मेहनत गर्नु पर्नेछ, मरुञ्जेलसम्म नै तिमीले मेहनत गर्नु पर्नेछ। त्यसपछि तिमी फेरि माटोमा मिल्नेछौ। मैले तिमीलाई बनाउँदा माटोको प्रयोग गेरको थिएँ र जब तिमी मर्ने छौ फेरि माटोमा मिल्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","त्यस आदमले आफ्नी पत्नीको नाउँ हव्वा राख्यो किनभने सबै मानिसहरुकी तिनी आमा हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","परमप्रभु परमेश्वरले पशुको छालाको लुगा बनाउनु भयो र त्यो मानिस र उसकी पत्नीलाई लगाउन दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","परमप्रभु परमेश्वरले भन्नुभयो, “हेर, त्यो मानिस हामी जस्तै भएको छ उनले राम्रो अनि नराम्रो विषयमा जान्दछ र अब जीवनको रुखबाट उनले फल खान सक्छ यदि उनले त्यो फल खायो भने, ऊ सँधैको निम्ति बाँच्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","परमप्रभु परमेश्वरले आदमलाई बलपूर्वक जमीन जोत्नु निकाल्नु भयो जहाँबाट उसलाई सिर्जना गरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","उहाँले मानिसलाई टाढो खेद्नुभयो अनि अदनको बगैंचाको पूर्वतिर प्रवेशद्वारमा उहाँले एक जना स्वर्गदूत अनि एउटा प्रज्वलित तरवार जो जीवनको रुखतिर जाने बाटोको सुरक्षा गर्दै चारैतिर घुमिरहन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आफ्नी पत्नी हव्वासंग आदमको सहवास भयो अनि तिनी गर्भवती भएर एउटा छोरो कयिनलाई जन्माइन। तिनले भनिन, “परमप्रभुको सहायताद्वारा मैले एउटा मानिसलाई जन्म दिएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","तिनले फेरि अर्को छोरो हाबिललाई जन्माइन। हाबिल भेडा गोठालो भयो अनि कयिन खेतीवाला भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","केही समय पश्चात कयिनले भूमिको उब्जनीबाट केही खाने कुरो परमप्रभु कहाँ भेटीस्वरुप चढाउन ल्यायो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबिलले पनि आफ्नो भेडाको बथानबाट पहिले जन्मेको भेडाको उत्तम भाग चढाउन ल्यायो। अनि हाबिलले ल्याएको भेटी परमप्रभुले स्वीकार गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","तर परमप्रभुले कयिन र उनले चढाएको भेटी स्वीकार गर्नु भएन। यसर्थ कयिन साहै रिसायो र दुःखी भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","परमप्रभुले कयिनलाई सोध्नु भयो, “तँ किन रिसाएको छस्? ");
INSERT INTO npi2010_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","तँ किन आफ्नो अनुहार अँध्यारो पार्दछस्? यदि तैंले राम्रो काम गरिस् भने म तलाईं स्वीकार गर्छु अनि तैंले नराम्रो काम गरिस् भने पापले तँलाई एकदमै नियन्त्रण गर्नेछ तर तँ यसको मालिक हुनै पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","कयिनले उसको भाइलाई भने, “हामी खेतमा जाऔं!” अनि तिनीहरु खेतमा गएका थिए, कयिनले उसको भाइलाई आक्रमण गरी तिनलाई मार्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","तब परमप्रभुले कयिनलाई भन्नुभयो, “तेरो भाइ हाबिल कहाँ छ?” तब कयिनले उत्तर दियो, “म जान्दिन, मेरो भाइको हेरचाह गर्ने काम मेरो हो र?” ");
INSERT INTO npi2010_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","त्यसपछि, परमप्रभुले कयिनलाई सोध्नु भयो, “तैंले उसलाई के गरिस्? कारण भूमिबाट उसको रगत मसंग कराउँदैछ। ");
INSERT INTO npi2010_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","तैंले तेरो भाइको हत्या गरिस् र तेरो हातबाट रगत पिउनलाई भूमिले मुख बाही रहेकोछ। यसकारण अब म त्यस भूमिमा नराम्रो कुराहरु हुने बनाइदिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","जब तैंले त्यो भूमिमा केही रोप्छस तेरो निम्ति त्यस भूमिले केही फसल दिने छैन। पृथ्वीमा तेरो एउटा घर पनि हुने छैन, तँ एक ठाउँदेखि अर्को ठाउँ घुमिहिंडने छस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","तब कयिनले परमप्रभुलाई भने, “यो दण्ड चाँहि मैले सहन सक्नेभन्दा धेरै भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","हेर्नुहोस्, आज तपाईंले मलाई जमीनबाट निकालिदिनु भयो अनि म तपाईंको नजरबाट बाहिर रहनु पर्यो, यस पृथ्वीमा घरबेगरको घुमिहिंड्ने हुने भएँ र जसले पनि मलाई भेट्छ मलाई मार्नेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","तब परमप्रभुले उसलाई भन्नुभयो, “यस्तो हुन पाउने छैन! यदि कसैले तलाईं मार्छ भने त्यसलाई म कठोर दण्ड दिनेछु।” तब परमप्रभुले कयिनमाथि यस्तो एउटा चिन्ह लगाउनु भयो जसले गर्दा त्यो देखेपछि कसैले कयिनलाई मार्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","तब कयिन परमप्रभुको सामुन्नेबाट टाढा गएर अदनको पूर्वपट्टि नोद देशमा बस्न थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","कयिनको उसकी पत्नीसित सहवास भयो र तिनी गर्भवती भईन र हनोक नाउँ भएको एउटा छोरा जन्माइन्। अनि कयिनले एउटा शहर बनायो र त्यो शाहरको नाउँ हनोक राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोकको ईराद नाउँको छोरा जन्म्यो। ईरादको एउटा छोरो भयो र उसको नाउँ महूयाएल राखियो। महूयाएलको पनि मतूशाएल नाउँको छोरो भयो अनि मतूशाएलको पनि लेमेक नाउँको छोरो भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेकले दुइवटी स्त्रीहरुसित विवाह गर्यो, तिनीहरुको नाउँ आदा र सिल्ला थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाले याबाल नाउँको छोरोलाई जन्म दिइन्। याबाल पालमा बस्ने र गाई-वस्तुहरु पाल्नेहरुको पुर्खा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","याबालको भाइको नाउँ यूबाल थियो अनि तिनी नै वीणा र बाँसुरी बजाउनेहरु सबैका पुर्खा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्लाले तूबल कयिनलाई जन्माइन् जो सबै प्रकारका पीतल र फलामको हतियारहरु बनाउँथ्यो। तूबल कयिनका बहिनीको नाउँ नामा थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेकले आफ्ना पत्नीहरुलाई भने, “हे आदा र सिल्ला! लेमेकका पत्नीहरु हो, म के भन्छु, सुन। मलाई चोट पुर्याउने मानिसलाई मैले मारें, त्यस जवान केटोले मलाई हिर्कायो मैले उसलाई मारें। ");
INSERT INTO npi2010_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","यदि कयिनलाई मारेकोमा सात गुणा बढी दण्ड भयो भने, लेमेकलाई मारेकोमा सतहत्तर गुणा बढी दण्ड हुनेछ!” ");
INSERT INTO npi2010_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदमको फेरि आफ्नी पत्नीसित सहवास भयो र तिनले फेरि एउटा छोरो जन्माइन् जसको नाउँ सेत राखियो। तिनले भनिन्, “कयिनले हाबिललाई मारेकोले उसको सट्टामा परमेश्वरले मलाई अर्को बालक दिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","सेतको पनि एउटा छोरो भयो जसको नाउँ एनोश थियो। यही समयदेखि मानिसहरुले परमप्रभुलाई विश्वास गर्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदमको परिवारको विषयमा लेखिएको इतिहास यही हो। परमेश्वरले मानिसको सृष्टि गर्दा आफ्नै प्रतिरुपमा मानिसजातिको सृष्टि गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","परमेश्वरले मानिसलाई पुरूष र स्त्री दुई रुपमा सृष्टि गर्नुभयो। जब उहाँले तिनीहरुलाई सृष्टि गर्नुभयो तिनीहरुलाई आशिष दिनु भयो अनि तिनीहरुलाई “मानिस” भन्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","जब आदम 130 वर्षको वृद्ध भएका थिए, तिनको फेरि अर्को एउटा छोरो जन्मियो र उनले छोरोको नाउँ सेत राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","सेतको जन्म भएपछि आदम अझ 800 वर्ष सम्म जीवित रहे अनि उनको अरु पनि छोरा-छोरीहरु भए। ");
INSERT INTO npi2010_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","आदम 930 वर्षसम्म बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","जब सेत 105 वर्षको भए तब उनको एउटा छोरो जन्मियो जसको नाउँ उनले एनोश राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश जन्मेपछि सेत 807 वर्षसम्म जीवित रहे र यो समयमा सेतका अरु छोरा-छोरीहरु जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","यसर्थ सेत जम्मा 912 वर्षसम्म बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","एनोशको उमेर 90 वर्षको भएपछि उनको एउटा छोरो जन्मियो जसको नाउँ केनान राखियो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान जन्मेपछि एनोश 815 वर्ष सम्म बाँचे। यो समयमा एनोशका अरु छोरा-छोरीहरु पनि जन्मे ");
INSERT INTO npi2010_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","यसर्थ एनोश जम्म 905 वर्ष बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान 70 वर्ष पुगेपछि उसको एउटा छोरा जन्मियो, उनले छोरोको नाउँ महलेल राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महलेलले जन्म लिएपछि केनान 840 वर्ष उमेरसम्म बाँचे। त्यस समयमा केनानका आठ छोरा-छोरीहरुले पनि जन्म लिए ");
INSERT INTO npi2010_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","यसर्थ केनान 910 वर्ष सम्म बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","जब महलेल 65 वर्षको भयो उसको एउटा छोरो जन्मियो जसको नाउँ येरेद राखियो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद जन्मेपछि महलेल 830 वर्ष सम्म बाँचे र त्यस अवधिमा उसका धेरै छोरा-छोरीहरु जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","यसर्थ महलेल जम्मा 895 वर्ष सम्म बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","जब येरेद 162 वर्ष पुगे उनको एउटा छोरो जन्मियो जसको नाउँ हनोक राखिय। ");
INSERT INTO npi2010_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक जन्मिएपछि येरेद 800 वर्ष सम्म बाँचे। यस अवधिमा येरेदका अरु छोरा-छोरीहरु भए। ");
INSERT INTO npi2010_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","यसर्थ येरेद जम्मा 962 वर्षसम्म बाँचे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","जब हनोक 65 वर्ष पुगे उनको एउटा छोरो जन्मियो जसको नाउँ मतूशेलह राखियो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूशेलह जन्मेपछि हनोक 300 वर्ष सम्म परमेश्वरको पछि-पछि हिंडिरहे। यस अवधिमा उसको अरु छोरा-छोरीहरु जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","यसर्थ हनोक 365 वर्ष सम्म बाँचे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","एक दिन हनोक परमेश्वरसित हिंडिरहेको समयमा हनोक हराए। परमेश्वरले उसलाई जिउँदै स्वर्ग लानु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","जब मतूशेलह 186 वर्षको थिए उनको एउटा छोरो जन्मियो जसको नाउँ लेमेक राखियो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक जन्मिएपछि मतूशेलह 682 वर्ष सम्म बाँचे। यस अवधि भित्र उनको अन्य छोरा-छोरीहरु पनि जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","यसर्थ मतूशेलह 969 वर्ष सम्म बाँचे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","जब लेमेक 182 वर्षको थिए उनको एउटा छोरा जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","उनले आफ्नो छोरोको नाउँ न्‌ह राखे। उनले भने, “यसले हाम्रो काममा विश्राम दिओस्। परमेश्वरले भूमिलाई श्राप दिनु भएकोले हामी खेतीको लागि कठिन परिश्रम गर्छौ। तर नूहले हामीलाई विश्राम दिनु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","न्‌ह जन्मेपछि लेमेक 595 वर्षसम्म जीवित रहे। त्यस अवधिमा उनका अरु छोरा छोरीहरु जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लेमेक जम्मा 777 वर्षसम्मा बाँचे। ");
INSERT INTO npi2010_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नूह 500 वर्ष पुगेपछि उनको शेम, हाम र येपेत छोराहरु जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","पृथ्वीमा जब मानिसहरुको संख्या बढदै गयो, तिनीहरुले कन्याहरुलाई जन्म दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","परमेश्वरका छोराहरुले ती मानव कन्याहरुलाई मन पराए। यसकारण परमेश्वरका छोराहरुले आफूले रोजेका केही कन्याहरुलाई विवाह गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","तब परमेश्वरले भन्नुभयो, “तिनीहरु मरणशील भएकाले मानव रुपमा लामो समयसम्म बाँच्ने छैनन्। तिनीहरुको आयु केवल 120 वर्षसम्म मात्र हुने छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","यस पृथ्वीमा नपील मानिसहरु त्यस समय र त्यसपछि पनि थिए। परमेश्वरका छोराहरुले जब मनुष्य कन्याहरुसित शारीरिक सम्बन्ध राखे तिनीहरुले परमेश्वरका छोराहरुका नानीहरु जन्माए। तिनीहरु प्राचीन समयबाट नै प्रसिद्ध लडाकुहरु थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","परमप्रभुले देख्नु भयो पृथ्वीका मानिसहरुमा दुष्टता अत्यन्तै धेरै थियो अनि तिनीहरुले मनमा जे चिताउँद थिए सँधै विचारहरु नै दुष्टपूर्ण हुन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","अनि परमप्रभु पृथ्वीमा मनुष्य जाति सृष्टि गरेकोमा दुःखी हुनुभयो। त्यसले परमप्रभुलाई हृदयबाट नै दुःखी तुल्यायो। ");
INSERT INTO npi2010_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","तब परमप्रभुले भन्नुभयो, “पुथ्वीबाट नै यी मानिसहरुलाई म ध्वंश पार्ने छु। म मानिस, घस्रने र अन्य पशुहरु अनि आकाशमा उड्ने चराहरु जे मैले सृष्टि गरें म सबैलाई ध्वंश पार्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","तर न्‌हले परमप्रभुलाई खुशी तुल्याए। ");
INSERT INTO npi2010_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","यो नूहको पारिवारीक इतिहास हो। न्‌ह उसको जीनवनभरि एकजना असल व्यक्ति थिए। नूहले सँधैं परमेश्वरको अनुसरण गर्द थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नूहका तीन छोराहरु शेम, हाम र येपेत नाउँ भएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","परमेश्वरको नजरमा पृथ्वी भ्रष्ट थियो। मानिसहरुले पृथ्वीमा हिंसा ब्याप्त पारेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","परमेश्वरले पृथ्वीमा देख्नु भयो पृथ्वीका मानिसहरुले आफ्नो जीवन भ्रष्ट पारेकोले पृथ्वी नै नष्ट भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","तब परमेश्वरले नूहलाई भन्नुभयो, “मानिसहरुको हिंसाले पृथ्वी भरिएकोले यसमा भएका सबै प्राणीहरुलाई नष्ट पार्न मैले निर्णय लिएँ। यसर्थ पृथ्वीसितै तिनीहरु सबैलाई म झट्टै नष्ट पार्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","तैंले गोपेर काठको एउटा जहाज बनाउनु र त्यसमा कोठाहरु बनाउनु र त्यसको भित्र र बाहिर पट्टी अलकत्राले लिप्नु। ");
INSERT INTO npi2010_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“त्यो जहाज 300 हात लामो, 50 हात चौडा र 30 हात अल्गो बनाउनु र ");
INSERT INTO npi2010_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","त्यसमा छाना लगाउनु। जब छानाको एक हात तल झ्याल बनाउँनु। त्यस जहाजको एकापट्टी एउटा ढोका राख्नु र त्यसमा पहिले, दोस्रो र तेस्रो तला बनाउनु। ");
INSERT INTO npi2010_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“मेरो भागमा म यस धर्तीका सबै प्राणीहरुको सर्वनाश पार्न खतरनाक बाढी ल्याइरहेको छु। सजीव वस्तुहरु मर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","तर म तँसँग एउटा करार गर्नेछु। जहाज भित्र पस्दा तैंले आफूसँग आफ्नो छोराहरु, पत्नी, अनि बुहारीहरु लानु। ");
INSERT INTO npi2010_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","अनि आफूसँग प्रत्येक जोडी जीवित प्राणी जहाज भित्र लानु, ती जीवित प्राणीहरु सबै भाले-पोथीको जोडी होस् र तिनीहरु पनि तिमीहरुसितै बाँचिरहुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","जीवन रक्षाको निम्ति प्रत्येक जातका पशु चरा र घस्रने प्राणीहरु त्यहाँ तिमीहरुसित रहनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","अनि तेरो भागमा सबै प्रकारको खाद्य सामग्री भोजनको लागि जम्मा गर्नु। तेरो र ती सब प्राणीहरुका निम्ति भोजन हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेश्वरको आज्ञा अनुसार नूहले सबै काम पूरा गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","त्यसपछि परमप्रभुले नूहलाई भन्नुभयो, “आफ्नो पुरै परिवारसित जहाजमापस किनभने पृथ्वीमा अहिले जीवित रहेका मानिसहरुमा तँ मात्र असल मानिस छस् भनी मैले देखें। ");
INSERT INTO npi2010_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","सात जोडी, सातवटा भाले र सातवटा पोथी शुद्ध पशुहरु र एक जोडी एउटा भाले र एउटा पोथी अशुद्ध पशु। ");
INSERT INTO npi2010_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अनि सबै जातका चराहरुबाट पनि सातवटा भाले र सातवटा पोथी लिएर जहाजभित्र पसा। यी पशु-चराहरु अरु सबै ध्वंश गरिए पछि यिनीहरुका जातिहरुलाई पृथ्वीमा बचाई राख्नु यी सब तैंले लानु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","अबदेखि सातौं दिनमा म यस पृथ्वीमा चालीस दिन चालीस रात पानी पार्नेछु अनि यस पृथ्वीबाट मैले सृष्टि गरेका सबै जीवित प्राणीहरु ध्वंश पार्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","अनि परमप्रभुबाट भएको आज्ञा नूहले पूर्ण रुपले पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","जब पृथ्वीमा प्रलय आयो न्‌ह 600 वर्ष पुगेका थिए ");
INSERT INTO npi2010_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","प्रलयबाट बाँच्नको निम्ति नूह आफ्नो छोराहरु अनि पत्नी र बुहारीहरु लिएर जहाजभित्र पसे। ");
INSERT INTO npi2010_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","तब प्राणीहरु, नर र नारी, जोडी नूहकहाँ जहाजमा आए। परमेश्वरले आज्ञा गर्नु भए अनुसार धर्तीमा सबै स्वच्छ, अस्वच्छ प्राणीहरु तथा घस्रिने प्राणीहरु आए। ");
INSERT INTO npi2010_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","अनि ठीक सात दिनपछि पृथ्वीमा जल-प्रलयको पानी पर्नलाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नूहको जीवनको 600 वर्षको दोस्रो महीनाको सातौं दिनमा जमीनबाट मूल फुट्‌यो अनि आकाशमा ठूला-ठूला प्वालहरु बनिए। ");
INSERT INTO npi2010_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","अनि पृथ्वीमा मूसलधारे पानी चालीस दिन चालीस रात एकोहोरो परिरह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","त्यही दिन नूह, उसकी पत्नी, छोराहरु शेम, हाम र येपेत अनि बुहारीहरु जहाज भित्र गए। ");
INSERT INTO npi2010_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ती मानिसहरु, प्रत्येक जातका भाले पोथी गरी जोडी जोडी वन पशुहरु, घरमा पालिने पशुहरु, भूँईमा घस्रने जन्तुहरु अनि प्रत्येक जातका चराहरु जहाजमा पसे। ");
INSERT INTO npi2010_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","यी सबै पशु-चराहरु नूहसंगै जहाजमा पसे। सास फेर्ने सबै जीवित प्राणीहरु भाले र पोथीको जोडीको दलमा ती पशु चराहरु जहाजमा आए। ");
INSERT INTO npi2010_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","यी सबै पशुहरु परमेश्वरले नूहलाई दिनु भएको आज्ञा अनुसार जोडी जोडी भएर आए। त्यसपछि परमप्रभुले जहाजको ढोका बन्द गरिदिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","जल प्रलय पृथ्वीमा चालीस दिन चालीस रातसम्म भयो। पानी बढेर जहाजलाई जमीनबाटमाथि उचाल्न थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","पानीको स्तर माथि उठ्‌यो अनि नाव पानीमा तैरिन थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पानी यति साह्रो बढयो अग्लो-अग्लो पहाडहरु पनि पानीले ढाकिए। ");
INSERT INTO npi2010_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","एकोहोरो पानी परिरहेकोले पृथ्वीमा यति धेरै पानी भयो अग्ला पहाडहरु पनि पानीमा बीस फिट डुबे। ");
INSERT INTO npi2010_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","पृथ्वीमा बस्ने सबै पुरुष र स्त्रीहरु घरेलु पशुहरु, र जंङ्गली पशुहरु, पृथ्वीमाथि उड्ने सबै प्राणीहरु अनि सबै सजीव वस्तुहरु जो सुख्खा भूमिमा थिए मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","यसर्थ पृथ्वीको सतहमा रहने मानिसहरु पशुहरु, घस्रिने जन्तुहरु अनि आकाशमा उड्ने प्राणीहरु परमेश्वरले नष्ट पार्नु भयो। यी सब प्राणीहरुलाई पृथ्वीबाट नष्ट गरियो। केवल नूह र उनीसंगै जहाजमा भएका मानिसहरु र अन्य प्राणीहरु मात्र जीवित रहे। ");
INSERT INTO npi2010_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","एक सय पचास दिनसम्म परेको पानी पृथ्वीमाथि बगिरह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","नूह र उनीसित जहाजमा जो मानिस पशु र चराहरु थिए, तिनीहरुलाई परमेश्वरले सम्झनु भयो। परमेश्वरले पृथ्वीमा हावा बहाउनु भयो। र पानी बिस्तारै घट्न थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","आकाशबाट पानी पर्न छोडे पछि भूमि मुनिबाट पनि पानी बग्न छोडयो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","त्यसपछि बिस्तारै जमिनमा पानी घट्न थाल्यो। 150 दिन पुगेपछि पानी घटेको थियो ");
INSERT INTO npi2010_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","अनि सातौं महीनाको सत्रौं दिन अरारात पर्वतमा जहाज अडियो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","यसरी पानी दशौं महीना नपुगुञ्जेलसम्म घटिरह्यो। महीनाको पहिला दिन पर्वतको चुचुराहरु देखिए। ");
INSERT INTO npi2010_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","त्यसपछि चालीसौं दिनको अन्तमा न्‌हले जहाजको ढोका खोलेर एउटा कागलाई उडाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","अनि त्यो काग पृथ्वीमा पानी नसुकुञ्जेलसम्म उडेर जाँदै-फर्कंदै गरिरह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","त्यसपछि उनले फेरि पृथ्वीको सतहमा पानी सुकीसकेको छ वा छैन जान्न जहाजबाट एउटा ढुकुर उडाइ दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","तर त्यस ढुकुरले पृथ्वीमा कतै आफ्नो पाऊ राख्ने ठाउँ पाएन। जमीनमा कतै पाऊ राख्ने ठाउँ नपाएर त्यो ढुकुर फर्केपछि नहुले हात फिंजाएर त्यसलाई समाती जहाजभित्र पसाए। ");
INSERT INTO npi2010_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","नूहले अझै सात दिन पर्खेर फेरि त्यस ढुकुरलाई जहाजबाट बाहिर उडाइदिए, ");
INSERT INTO npi2010_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","अनि त्यो ढुकुर साँझमा फेरि जहाजमा फर्किएर आयो। यस पल्ट नूहले पृथ्वीको सतहबाट पानी सुकेको चाल पाए कारण यस पल्ट त्यस ढुकुरले आफ्नो चुच्चोमा एउटा भद्राक्षको पात चेपेर ल्याएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","त्यसपछि नूहले फेरि सात दिनसम्म पर्खे र त्यही ढुकुरलाई जहाजबाहिर उडाइ दिए तर यस पल्ट त्यो ढुकुर फर्केर नूह भएको जहाजमा आएन। ");
INSERT INTO npi2010_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नूहको उमेरको 601 वर्ष भएको थियो पहिलो महीनाको पहिलो दिन पृथ्वीको सतहमाथि पानी पूर्णरुपले सुक्यो। यसर्थ नूहले जहाजको ढोका खोलेर हेर्दा देख्यो पृथ्वीको सतहमा पानी सुकिसकेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","दोस्रो महीनाको सत्ताईसौं दिनमा पृथ्वीको सतहबाट सम्पूर्ण रूपले पानी सुकेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","तब परमेश्वरले नूहलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“तँ, तेरी पत्नी, तेरा छोराहरु र बुहारीहरु लिएर जहाज बाहिर आइज। ");
INSERT INTO npi2010_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","जहाजमा तँसँग जे जति चराहरु, पाल्तू जनावर, वनका जनावार भूमिमा घस्रने जन्तुहरु ती सब भूमिमा ओह्राल जसले गर्दा तिनीहरुले पृथ्वीमा आफ्नो सन्तान बढाउन्, पशुहरुले तिनीहरुको संख्या पृथ्वीमा बढाउन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","यसर्थ, नूह उनका छोराहरु, उनकी पत्नी तथा बुहारीहरु जहाजबाट बाहिर भूमिमा निस्के। ");
INSERT INTO npi2010_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","आफ्नो-आफ्नो परिवार, प्रत्येक जनावर, घस्रने प्राणीहरु, प्रत्येक चरा जो पनि पृथ्वीमाथि हिंड्डुल गर्छन् तथा आकाशमा उड्छन् ती सबै पृथ्वीमा ओर्लिए। ");
INSERT INTO npi2010_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","त्यसपछि नूहले परम्मप्रभुको निम्ति एउटा वेदी उभ्याए र उनले केही पवित्र पशुहरु र पवित्र चराहरु परमप्रभुको निम्ति वेदीमा होमबलि चढाए। ");
INSERT INTO npi2010_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","परमप्रभुले त्यस बलिदानहरुको बास्ना लिएपछि मनमा भन्नुभयो, “फेरि पृथ्वीलाई कहिल्ये पनि सराप दिने छैन। यसर्थ अब उसो कहिले पनि यस प्रकारका जीवित प्राणीहरुलाई नष्ट पार्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","जहिलेसम्म पृथ्वी रहन्छ, बिउ छर्ने र फसल काट्ने समय, जाडो र गर्मी, ग्रीष्म र शिशिर, दिन अनि रातको कहिल्यै अन्त हुनेछैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","परमेश्वरले नूह र उसका छोराहरुलाई आशीर्वाद दिनुभयो। उहाँले तिनीहरुलाई भन्नुभयो, “तिमीहरुका सन्तानहरुको संख्या यति सम्म बढोस् धर्ती फेरि मानिसहरुले भरियोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","यस पृथ्वीको प्रत्येक पशु, आकाशको प्रत्येक चरा, प्रत्येक जन्तु जो भूइँमा घस्रन्छ र समुद्रका प्रत्येक माछा तिमीसित डराउने छन। तिनीहरु सबै तेरो नियन्त्रणमा बसुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","कुनै पनि गतिशील चीज तेरो आहारको निम्ति होस्, जस्तो मैले पहिले हरियो उद्भिदहरु खाद्यको निम्ति दिएँ अहिले तलाईं प्रत्येक चीज खानको निम्ति दिन्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","जिउँदो पशुहरुको मासुमा जतिञ्जेलसम्म रगत रहन्छ त्यो चाँहि नखानु। ");
INSERT INTO npi2010_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","अब उसो, यदि कुनै सजीवले एकजना मानिसलाई मार्छ भने, यसले त्यसको लागि आफ्नो जीवन दिनु पर्छ। यदि एकजना मानिसलाई अर्को मानिसले मार्छ भने म उसको जीवन लिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“यदि कसैले एउटा मानिसलाई मार्छ त्यसलाई अर्को मानिसले प्राणदण्ड दिनु पर्छ, कारण परमेश्वरले मानिसलाई आफ्नै स्वरुपमा सृष्टि गर्नु भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“अनि तिमीले धेरै सन्तानहरु पाउनेछौ जसले गर्दा तिम्रो जनसंख्या बढ्नेछ अनि धर्ती भर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","तब परमेश्वरले नूह र उनका छोराहरुलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“म तिमी, तिम्रा भावी सन्तान अनि तिमीसित भएको प्रत्येक सजीव वस्तुसित विशेष सम्झौता तयार गर्दै छु। ");
INSERT INTO npi2010_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","म मेरो करार सबै चराहरु अनि पाल्तू पशुहरु अनि पृथ्वीमा भएका सबै जनावरहरुसित जो तिमीहरुसित जहाजभित्र, पृथ्वीको सबै जीवित प्राणीहरुसित गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","तिमीहरुसित म यो करार गर्दैछु अब उसो कहिल्यै पनि जल प्रलयद्वारा प्राणीहरु नष्ट हुने छैनन् अनि अब फेरि पृथ्वीलाई नष्ट पार्न जल-प्रलय कहिल्यै हुनेछैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","अनि परमेश्वरले भन्नुभयो, “यो चाँहि मैले तिमीहरु र तिमीहरुसित भएका प्राणीहरुसित गरेको करारको चिन्ह हो। यो करार पृथ्वीमा तिमीहरुका सन्तान जति पनि जन्मन्छन् सबैसित सधैं रही रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","तिमीहरुसित मैले स्थापित गरेको करारको चिन्ह स्वरुप बादलमा इन्द्रेणी बनिए त्यो इन्द्रेणी म र पृथ्वीको करारको प्रमाण हो। ");
INSERT INTO npi2010_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","जब म पृथ्वीमाथि बादल ल्याउँछु बादलमा इन्द्रेणी देखा पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","म मेरो करार सम्झनेछु ताकि कहिले पनि फेरि बाढीले पृथ्वीका सजीव प्राणीहरुलाई नष्ट गर्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","जब म इन्द्रेणीलाई देख्छु म त्यो करार सधैं सम्झना गर्नेछु म अनि पृथ्वीमा भएको प्रत्येक जीवित प्राणीहरु बिचमा भएको करार सम्झना गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","अनि परमेश्वरले नूहलाई भन्नुभयो, “यही नै म र पृथ्वीमा भएका सबै जीवित प्राणीहरुसित स्थापित गरिएको करारको चिन्ह हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","जहाजबाट निस्केका नूहका छोराहरु शेम, हाम र येपेत थिए (हाम कनानका पिता थिए) ");
INSERT INTO npi2010_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","यी तिनै जना नूहका छोराहरु थिए र यी तीन जनाका सन्तानहरुले नै यो पृथ्वी भरियो। ");
INSERT INTO npi2010_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नूह नै दाखको खेती गर्ने पहिलो खेतीवाला थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","नूहले दाखरस बनाएर पिए अनि माते र उनी पालभित्र सुतिरहे। नूहले कुनै लुगा लगाएका थिएनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनानका बाबु हामले आफ्नो बाबु न्‌हलाई नाङ्गै सुतिरहेको देख्यो र त्यो बाहिर आएर आफ्नो दुवै दाज्यूहरुलाई बाबु नाङ्गै सुतिरहेको कुरो सुनायो। तब शेम र येपेतले एउटा कोट लिएर दुबैजनाको कुममा राखी पछिल्तिरवाट हिंडेर आफ्नो बाबुको नाङ्गो शरीर ढाकिदिए। ");
INSERT INTO npi2010_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","तिनीहरु पछिल्तिर फर्केका थिए र तिनीहरुले बाबुलाई नाङ्गो देखेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","जब नूह मद्य निद्राबाट बिउँझिए उसको कान्छो छोरोले के गरेको थियो थाहा पाए। ");
INSERT INTO npi2010_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","तब नूहले भने, “कनानलाई सराप लागोस्, ऊ आफ्ने दाज्यू-भाइहरुको कमारो हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","तब नूहले भने, “शेमका परमप्रभु परमेश्वर, धन्यका होऊन्। कनान उनको दास बनियोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्वरले येपेतको विकास गराई दिऊन्, अनि येपेत शेमको पालहरुमा बसोस्, अनि कनान उसको कमारा होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","नूह जल प्रलयपछि 350 वर्ष बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","यसर्थ नूह जम्मा 950 वर्ष बाँचे र मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नूहका छोराहरु शेम, हाम र येपेत थिए र यिनीहरुको पारिवारिक इतिहास यही हो। नूहको छोराहरुका धेरै सन्तानहरु भए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेतका छोराहरु थिए गोमेर, मागोग, मादे, यावान, तूबल, मेशेक र तीरास। ");
INSERT INTO npi2010_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेरका छोराहरु थिए अशकनज, रीपत र तोगर्मा ");
INSERT INTO npi2010_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","याबानका छोराहरु थिए-एलीशा, तर्शोश, कित्तीम र दोदानीम। ");
INSERT INTO npi2010_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","तिनीहरुबाटै समुद्रतट वासीहरु फिंजिए। तिनीहरुको देशभित्र आफ्नो भाषा र जाति अनुसार फिंजिए। यी सबै येपेतका छोराहरु थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामका छोराहरु थिए कूश, मिश्र, पूत र कनान। ");
INSERT INTO npi2010_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूशका छोहरु थिए-सबा, हवीला, सबता, रामा र सबतका। रामाका छोराहरु थिए-शबा र ददान। ");
INSERT INTO npi2010_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","निम्रोद कूशको छोरा थियो। निम्रोद ज्यादै शक्तिशाली योद्धा बनिने पहिले मानिस थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","परमप्रभुको महान योद्धा शिकारीहरु मध्ये एकजना थिए। त्यसकारण मानिसहरु निम्रोदसित तुलना गर्छन् अनि भन्दछन्, “यो मानिस परमप्रभुको दृष्टिमा निम्रोद जस्तै राम्रो शिकारी हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","शुरूमा तिनको राज्य शिनारको बाबेल, एरेक, अक्कद र कल्ने थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","यहाँबाट तिनी अश्शूर गए अनि नीनवे, रहोबोतीर र कालह शहरहरु बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","कालह र नीनवे माझ तिनले शहर रेसेन बनाए। ती शहरहरु मध्ये कालह सबै भन्दा ठूलो थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिश्र, लूद, अनाम, लहाब, नप्तूह, ");
INSERT INTO npi2010_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पत्रुस, कसलू अनि कपतोर मानिसहरुका पिता थिए। (पलिश्ती मानिसहरु कसलूका सन्तान थिए।) ");
INSERT INTO npi2010_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनान सीदोनका पिता थिए र त्यो नै कनानका जेठो छोरो थियो। कनान हेत मानिसहरूका पिता थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","कनानबाट हित्ती, यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO npi2010_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिब्बा, अर्कोत र सिनीत मानिसहरु, ");
INSERT INTO npi2010_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, समारी र हमाती मानिसहरु उत्पन्न भए। यसरी कनानका सन्तानहरु संसारका जताततै फिंजिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","कनानी मानिसहरुको भूमिको सिमाना उत्तरमा सीदोनदेखि दक्षिणमा गरारसम्म, पश्चिममा गाजादेखि सदोमसम्म र पूर्वमा गमोरा, अदाम र सबोयीमदेखि लाशासम्म थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ती सब मानिसहरु हामका सन्तान थिए र ती सबै मानिसहरुको आफ्नो-आफ्नो भाषा र आफ्नै भूमि थियो र तिनीहरुको एउटा अलगै राज्य थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","शेम येपेतका जेठा दाज्यू थिए। शेमका सन्तानहरुमा एक जना एबेर सबै हिब्रू मानिसहरुका पिता थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेमका छोराहरु एलाम, अश्शूर, अर्पक्षद, लूद अराम थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अरामका छोराहरु ऊज, हुल, गेतेर अनि मश थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षद शेलहका पिता थिए, शेलह एबेरका पिता थिए थिए, ");
INSERT INTO npi2010_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेर दुइजना छोराहरूका पिता थिए जसमा एकजनाको नाउँ पेलेग थियो। उसलाई पेलेग नाउँ राखिएको कारण उसकै जीवनकालमा पृथ्वी विभक्त भएको थियो। अर्को छोरोको नाउँ योक्तान थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्तान अल्मोदाद, शेलेप, हसर्मवित र येरह, ");
INSERT INTO npi2010_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोराम, ऊजाल, दिक्ला, ");
INSERT INTO npi2010_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबमाएल, शबा, ");
INSERT INTO npi2010_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला अनि योबाबको पिता थिए। यी सबै मानिसहरु योक्तानका छोराहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ती सबै मानिसहरू मेशा र पूर्वमा पहाडी भूमि इलाकामा बसो बास गर्थे। मेशा सापारा भूमितिर पर्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ती मानिसहरु शेमको परिवारका थिए। तिनीहरु आफ्नो वंश, परिवार, भाषा, भूमि र राष्टमा गठित थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नूहका सन्तानको वंश अनुसार तिनीहरुका जातिहरु यी नै थिए। यिनीहरु आफ्ना आफ्ना राष्ट्रमा गठित थिए अनि जल-प्रलय पछि तिनीहरूबाट नै पृथ्वीमा सबै मानिसहरु फिंजिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","यतिबेला समस्त पृथ्वीमा एउटै भाषा थियो अनि थोरै शब्दहरु थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","जब मानिसहरू पूर्वबाट बसाइँ सर्न थाले शिनार देशमा तिनीहरूले समतल भूमि भेटे अनि तिनीहरूले त्यहाँ बसोबास शुरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","तिनीहरू आपसमा कुरा गरे, “हामीले ईंटा बनाउनु पर्छ अनि त्यसलाई कडा बनाउनको लागि आगोमा पोल्नु पर्छ।” यसर्थ तिनीहरुको घर बनाउदा ढुङ्गाको सट्चामा ईंटालाई प्रयोग गरे अनि ईंटा जोड्न माटोको सट्टामा मसला प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","तिनीहरूले भने, “आऊ, हामी आफ्नो निम्ति एउटा शहर बनाऔं अनि एउटा धरहरा बनाऔं जसको शिखर स्वर्ग पुग्छ। हामी प्रख्यात हुनु पर्छ र यसले हामीलाई संगठित राख्नेछ। नत्र हामी संसारभरि छरपष्ट हुनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","परमप्रभु मानिसहरूले बनाउदै गरेको किल्ला र शहर हेर्न तल आउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","तब परमप्रभुले भन्नुभयो, “हेर, तिनीहरू मिलेर एक भएका छन्, तिनीहरूले एउटै भाषा बोल्दैछन्। तिनीहरूले के गर्ने छन् यो एउटा शुरू मात्र हो, अब चाँडै तिनीहरूले के गर्न खोज्छन् त्यही गर्न सक्ने हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","यसर्थ हामी तिनीहरूको माझमा जाऔं र तिनीहरूको भाषामा खलबल पारिदिऔं जसले गर्दा तिनीहरू एक-अर्काले बोलेको भाषा बुझ्‌न नसकून्।” ");
INSERT INTO npi2010_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","यसरी परमप्रभुले तिनीहरूलाई पृथ्वीको सम्पूर्ण सतहभरि छरपष्ट पारिदिनु भयो। यसर्थ उहाँले भवन निर्माणको काम रोकिदिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","त्यसकारण यो शहरको नाउँ बाबेल राखियो। यसप्रकार त्यस ठाउँबाट परमप्रभुले मानिसहरूलाई पृथ्वीको सतहभरि छरपष्ट पार्नु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेमको पारिवारिक इतिहास यही हो। जल प्रलय भएको दुइ वर्षपछि शेम जब एक सय वर्ष पुगेका थिए तिनी अर्पक्षदका पिता भए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अर्पक्षद जन्मेपछि शेम पाँच सय वर्षसम्म बाँचे अनि तिनका अन्य छोरा-छोरीहरू पनि जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","जब अर्पक्षद पैतीस वर्षका भए तिनको एउटा छोरो जन्म्यो जसको नाउँ शेलह थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलह पछि अर्पक्षद चार सय तीन वर्ष सम्म बाँचे अनि त्यस अवधिमा तिनका अन्य छोरा-छोरीहरू पनि भए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","शेलह तीस वर्ष पुगेपछि तिनको एउटा छोरो जन्मियो जसको नाउँ एबेर थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबेर जन्मेपछि शेलह चार सय तीन वर्षसम्म जीवित रहे। त्यस अवधिमा शेलहका अन्य छोरा-छोरीहरू जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबेर चौंतीस वर्षको भएपछि तिनको एउटा पेलेग नाउँका छोरो जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग जन्मेपछि पनि एबेर चार सय तीस वर्षसम्म बाँचे अनि त्यस अवधिमा तिनका अन्य छोरा-छोरीहरू जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेगको उमेर तीस वर्ष पुग्दा तिनको रऊ नाउँका छोरो जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रऊ जन्मेपछि पेलेग अर्को दुइ सय नौ वर्षसम्म बाँचे अनि यस अवधिमा तिनका अरू छोरा-छोरीहरू पनि जन्मिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊको उमेर बत्तीस वर्ष पुग्दा तिनको सरूग नाउँका छोरो जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूगको जन्म पछि रऊ अर्को दुई सय सात वर्षसम्म बाँचे अनि त्यस अवधिमा तिनका अरू छोरा-छोरीहरु पनि जन्मिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूगको उमेर तीस वर्ष पुग्दा तिनको नाहोर नाउँको छोरो जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोर जन्मेपछि पनि सरूग दुइ सय वर्षसम्म बाँचे अनि त्यस अवधिमा तिनका अरू छोरा-छोरीहरू जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोरको उमेर उन्तीस वर्ष पुग्दा तिनको तेरह नाउँको छोरो जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरह जन्मेपछि पनि नाहोर एक सय उन्नाइस वर्षसम्म बाँचे अनि त्यस अवधिमा तिनका अरू छोरा-छोरीहरू जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरहको उमेर सत्तरी वर्ष पुग्दा तिनका अब्राम, नाहोर र हारान नाउँका छोराहरू जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरह परिवारको इतिहास यही हो। तेरह अब्राम, नाहोर र हारानका बुबा थिए। हारान लूतका बुबा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान बाबेलको ऊरमा मरे अनि त्यस समय तिनका बुबा तेरह जीवित नै थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राम र नाहोरले विवाह गरे, अब्रामको पत्नीको नाउँ साराई र नाहोरकी पत्नीको नाउँ मिल्का थियो। मिल्का हारानकी छोरी थिईन र हारान मिल्का र इस्काका बुबा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","साराईबाट कुनै सन्तान भएन कारण ऊ बाँझी थिईन। ");
INSERT INTO npi2010_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरहले आफ्नो छोरो अब्राम, उसको नाति लूत, बुहारी सराई-अब्रामकी पत्नी, लिएर कल्दीहरूको ऊर शहर छाडी कनान देशमा जान हिंडे। तर तिनीहरू हारानसम्म गई त्यही बसो-बास गर्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह दुइ सय पाँच वर्षसम्म बाँचेर हारानमा मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","परमप्रभुले अब्रामलाई भन्नुभयो, “तिम्रो देश र तिम्रा मानिसहरूलाई छोड, र मैले देखाएको देशमा जाऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","म तिमीलाई आशीर्वाद दिनेछु, तिमीबाट महान् राष्ट्र बनाएर प्रसिद्ध बनाउनेछु। तब मानिसहरूले अरूलाई आशीर्वाद दिदाँ तिम्रो नाउँ लिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","म तिमीलाई आशीर्वाद दिने मानिसहरूलाई आशीर्वाद दिनेछु, अनि तिमीलाई सराप दिनेहरूलाई सराप दिनेछु। पृथ्वीमा सबै मानिसहरूलाई आशीर्वाद दिनका लागि म तिम्रो नाउँ प्रयोग गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","यसर्थ अब्रामले परमप्रभुले भन्नु भए अनुसार नै हारान छोडे अनि लूत तिनीसित गए। जब अब्रामले हारान छोडे त्यस समय तिनी पचहत्तर वर्ष पुगेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्रामले आफ्नी पत्नी साराई, उसको भतिजो लूत, आफूसित भएका कमारा-कमारीहरू र हारानमा आफ्नो जे जति थियो लिएर कनान गए। ");
INSERT INTO npi2010_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम कनान देशको शकेमसम्म गए अनि मोरेमा ठूलो रूख भएको ठाउँ सम्म पुगे। त्यस समयमा कनानी मानिसहरू त्यस ठाउँमा बस्थे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","त्यहाँ परमप्रभु अब्रामको अघि प्रकट हुनुभयो अनि भन्नुभयो, “म तेरो सन्तानहरूलाई (अनि अरू कसैलाई पनि होइन) यो भूमि दिनेछु।” अब्रामले त्यस ठाउँमा जहाँ परमप्रभु तिनी अघि प्रकट हुनु भएको थियो। पूजाको निम्ति वेदी बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","त्यसपछि अब्रामले त्यस ठाउँ छाडी बेतेलको पूर्वको पहाडतिर यात्रा गरे अनि तिनले त्यहीं आफ्नो पाल बनाए। त्यस ठाउँबाट बेतेल पश्चिममा थियो र ऐ शहर पूर्वमा पर्थ्यो। तिनले त्यस ठाउँमा परमप्रभुको निम्ति वेदी बनाए अनि परमप्रभुको उपासना गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","तब अब्रामले यहूदाको दक्षिणी मरूभूमि इलाका नेगेबपट्टि आफ्नो यात्रा शुरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","त्यस समय त्यहाँ अनिकाल चलिरहेको थियो। त्यहाँ अनिकाल अत्यन्तै भएकोले तिनी केही समयको निम्ति मिश्र देशतिर लागे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","तिनी मिश्र देशमा पस्न मात्र लागेका थिए, तिनले आफ्नी पत्नी साराईलाई भने, “हेर, म जान्दछु तिमी सुन्दरी नारी छ्यौ। ");
INSERT INTO npi2010_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","जब मिश्र देशीहरूले तिमीलाई देख्नेछन् तिनीहरूले भन्नेछन् त्यो स्त्री मानिस मेरी पत्नी हुनु पर्छ र तिनीहरूले मलाई मार्नेछन्। तर तिमीलाई जीवित राख्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","यसकारण दया गरी तिनीहरूलाई भनी देऊ तिमी मेरी बहिनी हौ, यदि तिमीले यसो भन्यौ भने, त्यो मेरो निम्ति राम्रो हुन सक्छ अनि तिम्रो कारणले म बाँच्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","अब्राम मिश्र देश भित्र पसे अनि त्यहाँका मानिसहरूले साराईलाई सुन्दरी देखे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","केही मिश्र देशी अधिकारीहरूले राजा फिरऊनलाई साराईको सुन्दरताको विषयमा सुनाए। तिनीहरूले साराईलाई फिरऊनकहाँ लगे। ");
INSERT INTO npi2010_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फिरऊनले अब्रामसित राम्रो व्यवहार गरे कारण तिनलाई फिरऊनले साराईको भाइ सम्झे अनि उनले अब्रामलाई भेडा, गाई-वस्तु, गधा तथा पुरूष अनि महिला सेवकहरू र ऊँटहरू पनि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","फिरऊनले अब्रामकी पत्नी साराईलाई राखेकोले परमप्रभुले फिरऊन र उसको परिवारमाथि कष्टदायक रोगहरू पठाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","यसर्थ फिरऊनले अब्रामलाई बोलाएर भने, “तिमीले मेरो निम्ति एकदमै नराम्रो काम गर्यौ तिमीले साराईलाई तिम्री पत्नी भनी बताएनौ। किन? ");
INSERT INTO npi2010_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","तिमीले तिम्री बहिनी भन्यौ। किन तिमीले त्यस्तो कुरा गर्यौ। यसैकारण मैले साराईलाई आफ्नी पत्नी होस् भनेर राखे। तर अब म तिम्री पत्नी तिमीलाई नै फर्काउँछु र उसलाई लिएर तिमी जाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","त्यसपछि फिरऊनले आफ्ना मानिसहरूलाई अब्रामलाई मिश्रदेशबाट बाहिर पठाउने आज्ञा दिए। यसर्थ अब्राम र तिनकी पत्नी तिनीहरूसित भएका सबै मानिसहरू नयाँ अरू कुराहरू लिएर त्यहाँबाट प्रस्थान गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अब्रामले उसकी पत्नी, भतिजो लूत अनि तिनीसंग भएका अन्य सबै वस्तुहरू लिएर नेगेब हुँदै मिश्र देश छोडे। ");
INSERT INTO npi2010_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","यस समय अब्राम निकै धनी थिए कारण तिनीसँग घेरै गाई-वस्तु र घेरै सुन-चाँदीहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","अब्रामले नेगेब पार गरे अनि बेतेल गए अनि त्यो स्थान बेतेल अनि ऐ शहरहरूको बीचमा आइपुगे। ");
INSERT INTO npi2010_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","त्यहाँ पाल बनाएका थिए अनि वेदी पनि बनाएका थिए। यसर्थ अब्रामले त्यहाँ परमप्रभुलाई उपासना गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","त्यस समयमा लूत पनि अब्रामसित यात्रा गरिरहेको थियो अनि तिनीसंग पनि पशुहरू र पालहरू धेरै नै थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","अब्राम र लूतसित यति धेरै पशुहरू र सरसमानहरू भएकाले जग्गाको अभावले तिनीहरूलाई एकैठाउँ संगै बस्न असम्भव भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","त्यसै समयमा त्यस भूमिमा कनानी परिज्जी मानिसहरू पनि बस्थे। अब्राम र लूतका गोठालाहरू एक-अर्कासंग झगडा गर्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","यसर्थ अब्रामले लूतलाई भने, “हामीहरू सबै दाज्यू-भाइहरू हौ, यसर्थ तँ र म अथवा तेरा मानिसहरू र मेरा मानिसहरू भनेर झगडा हुनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","हामी अलग-अलग बसौं र तँ आफ्नो इच्छा अनुसार ठाउँ रोज, यदि तँ देब्रेतिर गइस् भने म दाहिने तिर जानेछु र यदि तँ दाहिनेतिर गइस् भने म देब्रेतिर जानेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लूतले भूमि खोजे अनि यर्दन नदीको बेंसीमा चाँहि पानी प्रशस्त भएको पाए। (यो परमप्रभुले सदोम र गमोरा ध्वंश पार्नु भन्दा अघिको कुरो हो। त्यस समयमा सोअरपट्टी यर्दनको बेंसी परमप्रभुको बगैंचा जस्तै थियो। यो भूमि मिश्रदेशको झैं राम्रो थियो।) ");
INSERT INTO npi2010_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","यसर्थ लूतले आफू बस्नको निम्ति यही भूमि रोजे र ती दुइ व्यक्तिहरू छुट्टीए अनि लूतले पूर्वतिर यात्रा शुरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान भूमिमा रहे भने लूत बेंसीको शहरहरूमाझ बसे। लूत सदोमतिर निकै पर दक्षिणपट्टी गए अनि त्यही आफ्नो पाल बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोमका मानिसहरू परमप्रभुको नजरमा अत्यन्तै दुष्ट थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लूत गएपछि परमप्रभुले अब्रामलाई भन्नुभयो, “आफ्नो वरिपरि हेर, उत्तर, दक्षिण पूर्व, पश्चिमतिर हेर। ");
INSERT INTO npi2010_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","किनभने म तिमीलाई सम्पूर्ण भूमि दिनेछु जो तिम्रो आफ्नो आउँदो पुस्ताकोलागि हुनेछ अनि यो सदाका लागि तिम्रो भूमि हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","म तिम्रो सन्तानहरूलाई पृथ्वीको धूलो जस्तै गन्न नसकिने बनाउनेछु। जसरी पृथ्वीमा धूलो गन्न सकिंदैन अनि त्यसतै प्रकारले तिम्रो सन्तानहरूलाई गन्न सकिने छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","यसर्थ अघि बढ, आफ्नो सम्पूर्ण भूमिमा हिंड किनभने मैले यो तँलाईं दिएको छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","यसरी अब्रामले आफ्नो पालहरू हटाए अनि हेब्रोनमा माम्रे फँलाटका रूखहरु भएकहाँ गए। अब्रामले त्यस ठाउँमा परमप्रभुको आराधना गर्नको लागि एउटा वेदी बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","शिनारका राजा अम्रापेल, एल्लासारका राजा अर्योक, एलामका राजा कदोर्ला ओमेर, तिदाका राजा गोयीम थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","यी सबै मिलेर सदोमका राजा बेरा, गमोराका राजा विर्शा अदमाका राजा शिनाब, सबोयीमका राजा शेमेबेर र बेलाका राजासित युद्ध लडे। (बेलालाई सोअर पनि भनिन्छ)। ");
INSERT INTO npi2010_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","यी सब राजाहरूले आफ्न्ना-आफ्ना सेनाहरू सिद्दीमको बेंसीमा भेला पारे। (वर्तमान खाराको समुद्र नै सिद्दीमको बेंसी हो)। ");
INSERT INTO npi2010_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","यी राजाहरुले राजा कदोर्लाओमेरलाई बाह्र वर्षसम्म सेवा गरेका थिए तर तेह्रौं वर्षमा यी सब राजाहरूले तिनको विरूद्ध विद्रोह गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","यसर्थ राजा कदोर्लाओमेर अरू राजाहरूसित मिले जो उनको समर्थनमा थिए, तिनीहरूसित युद्ध गर्न आए। राजा कदोर्लाओमेर र तिनका सहयोगीहरूले अस्तरो कर्णोममा रपाईलाई पराजित गरे। तिनीहरुले हाममा जूजी मानिसहरू, शावे-किर्यामा एमीमका मानिसहरूलाई परास्त गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","अनि तिनीहरूले सेईर एल्पारान पहाडी इलाकामा बसो-बास गर्ने होरीत मानिसहरुलाई पराजित गरे। (एल्पारान मरूभूमि नजिक छ)। ");
INSERT INTO npi2010_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","त्यसपछि राजा कदोर्लाओमेर एनमिशपात (कादेश) फर्किए अनि हस्सोन्तामारमा बोसो-बास गर्ने अमालेकी अनि अमोरीहरूलाई परास्त गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","त्यस वेला सदोम, गमोरा, अदमा, सबोयीम र बेलाका राजाहरू मिले अनि तिनीहरूको शत्रुसित सिद्दीमको बेंसीमा युद्ध गर्न भनी गए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","तिनीहरूले एलामका राजा कदोर्लाओमेर, गोइमका राजा तिदाल, शिनारका राजा अम्रापेल अनि एल्लासारका राजा अर्योकसित युद्ध लडे। अतः पाँच जना राजाहरूको विरूद्धमा चार जना राजाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दीमको उपत्यकामा धेरै अलकत्राका खाल्डाहरू थिए। सदोम र गमोरका राजाहरू आफ्नो सेनाहरू समेत भागे। धेरै सेनाहरू ती खाल्डाहरूमा परे। तर रहेका सेनाहरू पहाडी अञ्चलतिर भागे। ");
INSERT INTO npi2010_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","शत्रुहरूले सदोम अनि गोमराको सबै सम्पत्ति अनि तिनीहरूको सबै खाद्य पनि लगेर गए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","तिनीहरूले अब्रामको दाज्युको छोरा लूतसंगै उसको सबै सम्पत्ति लगे ");
INSERT INTO npi2010_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","लूतका मानिसहरूमा एकजना जो कैद भएको थिएन र हिबू अब्राम भएको ठाउँमा गएर के भएको थियो वृतान्त दियो। त्यस समय अब्राम एश्कोल र अनेर एमोरीको मम्रेको फलाँटको रूखहरू नजिकै बसेका थिए। तिनीहरूले एक-अर्कामा सहायता गर्नु भनी एउटा सम्झौतामा सही गरेका थिए। अनि तिनीले अब्रामलाई पनि सहायता गर्ने सम्झौता सही गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","जब अब्रामले लूत पक्राउ परेको समाचार पाए तिनले आफ्नो सम्पूर्ण परिवारलाई बोलाए। आफ्नो परिवार भित्रका तीन सय अठ्ठार जना प्रशिक्षित सेनाहरू लिई तिनी दानसम्म शत्रुहरूलाई खेद्‌दै गए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","शत्रुहरूमाथि आक्रमण गर्न तिनले आफ्नो सेनाहरूलाई राती दल दलमा भाग गरी दमीसकसको उत्तर दिशामा पर्ने होबासम्म खेदेर तिनीहरूलाई परास्त पारे। ");
INSERT INTO npi2010_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","अब्रामले आफ्नो भतिजो लूत र उसको सम्पत्ति, स्त्रीहरू र अरू कैदीहरू दुबै फर्काएर ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","कदोर्लाओमेर र तिनीसित मिलेका राजाहरूलाई पराजित गेरपछि अब्राम आफ्नो घर फर्के। जब तिनी घर आए सदोमका राजा तिनलाई भेट्न शाबेको बेंसीमा आए। यस ठाउँलाई ऐले राजाको बेंसी भनिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","शालेमका राजा पनि मल्कीसेदेक रोटी र दाखरस लिएर अब्रामसित भेट्न आए। तिनी सर्वोच्च परमेश्वरको पूजाहारी थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","मल्कीसेदेकले अब्रामलाई आशीर्वाद दिएर भनेः “जुन परमेश्वरले पृथ्वी र र्स्वग बनाउनु भयो, सर्वोच्च परमेश्वरले अब्रामलाई आशीर्वाद दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","अनि हामी सर्वोच्च परमेश्वरलाई धन्यवाद दिन्छौं। परमेश्वरले तिम्रा शत्रुहरूलाई परास्त पार्न तिमीलाई सहायता गर्नु भयो।” अब्रामले आफूले युद्धमा पाएको प्रत्येक चीजको एक-दशांश मल्कीसेदेकलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","तब सदोमका राजाले अब्रामलाई भने, “तिमीले सब चीजहरू आफ्नै निम्ति राख्न सक्छौ। मलाई केवल कैद गरिएका शत्रुहरू फर्काइ देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","तर अब्रामले सदोमका राजालाई भने, “म सर्वोच्च परमप्रभु परमेश्वरसित जसले स्वर्ग र पृथ्वी बनाउनु भयो, प्रतिज्ञा गरेको छु। ");
INSERT INTO npi2010_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","मैले प्रतिज्ञा गरेको छु कुनै पनि चीज जो तिम्रो हो म लिंदिन, यहाँसम्म एक टुक्रा धागो अथवा जुत्ताको फिता पनि म लिंदिन, म तिमीलाई भन्ने मौका दिंदिन, ‘अब्रामलाई मैले धनी बनाए।’ ");
INSERT INTO npi2010_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","म मात्र त्यो ग्रहण गर्नेछु जो ती जवान मानिसहरूले खाए। तर तिमीले ती अन्य मानिसहरूको भाग तिनीहरूलाई नै दिनु पर्छ। हामीले युद्धमा जितेर ल्याएका चीजहरू ग्रहण गर अनि त्यसबाट अनेर, एरकोल र मम्रेलाई तिनीहरूको हिस्सा देऊ। तिनीहरूले मलाई युद्धमा सहायता गरेका थिए।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","यी सब कुराहरू भई सकेपछि अब्रामलाई परमप्रभुबाट दर्शनद्वारा केही संदेशहरू आए। परमप्रभुले भन्नुभयो, “अब्राम तिमी नडराऊ। म तिम्रो ढाल हुँ। तिम्रो इनाम अत्यन्त विशाल हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्रामले भने, “हे परमप्रभु परमेश्वर! हजुरले मलाई के दिनुहुन्छ? यस्तो हजुरले दिंदा मलाई खुशी पार्ने केही छैन। किन? किनभने, मसित छोरा छैन। यसर्थ मेरो घरमा जन्मेको कमारा दमीसकको एलीएजरले मेरो मृत्यु पछाडी मसँग भएका सबै सम्पत्ति पाउँनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","अब्रामले भने, “तपाईंले मलाई एउटा छोरा दिनुभएको छैन, अतः मेरो घरमा जन्मेको कमाराले मेरो जम्मै सम्पत्ति पाउनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","त्यसपछि परमप्रभुले अब्रामसित कुरा गर्नु भयो। परमेश्वरले भन्नुभयो, “तिमीसँग भएको सम्पत्ति त्यो कमारोले पाउँदैन। तिम्रो आफ्नै छोरो जन्मनेछ। अनि तिम्रो सम्पत्तिको उत्तराधिकारी उही तिम्रो छोरो हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","त्यसपछि परमेश्वरले अब्रामलाई बाहिर लानु भयो र भन्नुभयो, “आकाशमा हेर, तिमीले त्यहाँ यति धेरै ताराहरू देख्नेछौ गन्नु सक्तैनौ। भविष्यमा तिम्रा पनि त्यति धेरै सन्तानहरू हुनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अब्रामले परमेश्वरलाई विश्वास गरे अनि परमेश्वरले अब्रामको विश्वासलाई विचार गर्नुभयो कि उसले वास्तवमा के गराउन चाहन्थे। ");
INSERT INTO npi2010_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","परमेश्वरले अब्रामलाई भन्नुभयो, “म उही परमप्रभु हुँ जसले तिमीलाई कल्दीहरूको ऊरबाट ल्यायो। मैले यसो गर्नुको तात्पर्य तिमीलाई यो भूमि दिनु हो, यो भूमि तिमीले ग्रहण गर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","तर अब्रामले भने, “हे परमप्रभु मेरा मालिक, यो भूमि मैले नै पाउनेछु भनी म कसरी थाहा पाउन सक्छु?” ");
INSERT INTO npi2010_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","परमेश्वरले अब्रामलाई भन्नुभयो, “हामी एउटा करार गर्नेछौं। एउटा तीन वर्षको कोरली, त्यसरी नै तीन वर्ष पुगेको बाख्रा अनि तीन वर्ष पुगेको एउटा भेडा ल्याऊ। अनि एउटा ढुक्कुर र एउटा परेवाको बच्चा पनि ल्याऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","परमेश्वरको निम्ति अब्रामले यी सबै कुराहरू ल्याएर यी सबै कुराको बलि चढाई ती सबलाई दुई-दुई टुक्रा पारे। तब अब्रामले प्रत्येक आधा भागलाई अर्को आधा भाग माथि र्तेस्याए। तर तिनले पंक्षीहरूलाई टुक्रा पारेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","पछि, ती पशुको मासु खान ठूला-ठूला पंक्षीहरू उडेर आए तर अब्रामले तिनीहरूलाई धपाए। ");
INSERT INTO npi2010_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","पछि सूर्य अस्ताउन लाग्दा अब्रामलाई साह्रै निन्द्रा लाग्यो। चुक झैं कालो अन्धकारले उसलाई चारै तिरबाट घेर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","तब परमप्रभुले अब्रामलाई भन्नुभयो, “तैंले यो निश्चय जान्नु पर्छ, तिम्रा सन्तानहरू विदेशी हुनेछन्, तिनीहरू त्यस धर्तीमा जानेछन् जो तिनीहरूको होइन, तिनीहरू त्यहाँ कमारा-कमारीको रूपमा चार सय वर्षसम्म सेवा गर्नेछन् अनि तिनीहरूसित धेरै खराब व्यवहार गरिनेछ। चार सय वर्षसम्म तिनीहरूले धेरै दुर्व्यवहार र अन्याय सहनु पर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","म त्यो जाति जसले तिम्रा सन्तानहरूलाई कमारा-कमारी बनाए तिनीहरूको न्याय गर्नेछु अनि जब तिमीपछि आउँने तिम्रा सन्तानहरूले त्यो देश छोडनेछन्, तिनीहरूले आफूसित धेरै राम्रा चीजहरू ल्याउँछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“तर जहाँसम्म तेरो कुरा छ, तँ मनग्गे बाँच्नेछस्। तँ शान्तिपूर्वक मर्नेछस् अनि तँ त्यहीं गाडिनेछस् जहाँ तेरा पिता-पुर्खाहरूलाई गाडिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","चार पुस्तापछि तिम्रा सन्तानहरू यही देशमा फर्केर आउनेछन् र तिनीहरूले एमोरीहरूलाई हराउँनेछन्। यहाँ बस्ने एमोरीहरूलाई सजाय भोग्न लगाउन म ती तिम्रा सन्तानहरूलाई प्रयोगमा ल्याउनेछु। यी सब कुराहरूपछि हुन्छ कारण ती एमोरीहरू अहिले सजाय पाउनुको निम्ति त्यति नराम्रो भई सकेका छैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","जब सूर्य अस्तायो, अत्यन्तै अंन्धकार छायो। बलि चढाई मारिएका पशुहरू दुइ-दुइ टुक्रामा अहिलेसम्म जमीनमा लडिरहेको थिए। त्यही समयमा धुँवाको मुस्लो जसमा बल्दै गरेको ज्वाला थियो ती मारेर टुक्रा पारिएको पशुहरू बीचबाट गए। ");
INSERT INTO npi2010_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","यस प्रकारले त्यसै दिन परमप्रभुले अब्रामसित एउटा सम्झौता गर्नु भयो अनि भन्नुभयो, “तेरा सन्तानहरूका लागि मात्र म यो घरती दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","तिनीहरूलाई म मिश्रको नदीदेखि यूफ्रेटिस महानदीसम्म केनी कदमोनी, कनज्जी, ");
INSERT INTO npi2010_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्जी, रपाई, ");
INSERT INTO npi2010_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरी कनानी, गिर्गाशी तथा यबूसी दिनेछु। यो सम्पूर्ण भूमि मिश्रको नदी अनि यूफ्रेटिस नदीको माझमा पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","साराई अब्रामकी पत्नी थिइन्, तर ती दुइ जनाको कुनै सन्तान भएन। साराईकी एउटी कमारी थिई, जसको नाउँ हागार थियो त्यो मिश्रकी थिई। ");
INSERT INTO npi2010_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","साराईले आफ्नो लोग्नेलाई भनी, “परमप्रभुले मलाई कुनै सन्तान दिनु भएन। यसर्थ मेरी कमारीसित तपाईंले सहवास गर्नुहोस् अनि म त्यस कमारीबाट जन्मेको नानीलाई मेरो आफ्नै नानी मान्नेछु।” अब्रामले आफ्नी पत्नीको सल्लाह माने। ");
INSERT INTO npi2010_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","यो घटना अब्राम कनानमा दशवर्षसम्म बसे पछिको हो। साराईले अब्रामलाई आफ्नो कमारी राख्ने अनुमति दिई हालिन्। (हागार साराईको मिश्र देशकी कमारी थिई) ");
INSERT INTO npi2010_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","हागारले अब्रामको गर्भ धारण गरी। जब उनले चाल पाई उनले गर्भ धारण गरी ऊ घमण्डले फुलिइ अनि अनुभव गरी ऊ साराई उसको मालिकनीभन्दा असल हो। ");
INSERT INTO npi2010_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","तर साराईले अब्रामलाई भनिन्, “मेरी कमारीले मलाई घृणा गर्छे। यसको निम्ति म तपाईंलाई जिम्मावार ठहराउँछु। मैले तपाईंलाई आफ्नी कमारी दिएँ र त्यसले गर्भ धारण गरी। तब उनले आफूलाई म भन्दा असल हुँ भन्ने गर्छे। म चाहन्छु परमप्रभुले हामी दुइ बीच ठीक न्याय गरून्।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","तर अब्रामले साराईलाई भने, “तिमी हागारकी मालिकनी हौ र तिमीले उसलाई जे इच्छा लाग्छ त्यही गर्न सक्छौ।” यसर्थ साराईले हागारलाई सजाय दिई अनि हागार भागी। ");
INSERT INTO npi2010_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","परमप्रभुको र्स्वग दूतले हागारलाई मरूभूमिमा पानीको स्रोतनेर भेटे। त्यो पानीको स्रोत शूर जाने बाटोनिर थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","स्वर्गदूतले हागारलाई भने, “हागार तिमी साराईकी दासी हौ, तिमी किन यहाँ छौ? तिमी कहाँ जाँदैछौ?” हागारले भनी, “म साराईदेखि भाग्दैछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","परमप्रभुका स्वर्गदूतले हागारलाई भने, “साराई तिम्री मालिक्नी हुन, जाऊ फर्केर अनि तिनको आज्ञा पालन गर।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","स्वर्गदूतले पनि भने, “म तिम्रा सन्तानहरू यति सम्म बढाउनेछु तिनीहरूलाई गन्न सकिंदैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","परमप्रभुका दूतले यसो पनि भने, “हागार अहिले तिमी गर्भवती छौ, अनि तिमीले छोरो जन्माउने छौ। तिमीले उसको नाउँ इश्माएल राख्ने छौ, किनभने तिमीलाई कुव्यवहार गरिएको छ जो परमप्रभुले सुन्नु भएको छ र उहाँले तिमीलाई सहायता गर्नु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","इश्माएल स्वतन्त्र र जंङ्गली गधा झैं हुनेछ, ऊ सबैको विरूद्धमा जानेछ, अनि सबै व्यक्तिहरू उसको विरूद्धमा आउनेछन्। ऊ एउटा भूमिबाट अर्को भूमिमा जानेछ, उनले आफ्नो आफन्तहरूको नजिक पाल हाल्नेछ तर तिनीहरूको विरूद्धमा जानेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","परमप्रभुले हागारसित कुरा गर्नु भयो। हागारले परमेश्वरलाई अर्कै नाउँले सम्बोधन गरेर भनिन्, “तपाईं परमेश्वर हुनुहुन्छ जसले मेरो हेरचाह गर्नु हुन्छ।” यसैकारण उनले भनिन्, किनभने उनले विचार गरिन्, “उनले साँच्चै त्यहाँ परमप्रभुलाई देखिन् जसले उसको हेरचाह गर्नु हुदै थियो।” ");
INSERT INTO npi2010_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","यसैले त्यस पानीको स्रोतको नाउँ बेर-लहै-रोइ राखियो। त्यो स्रोत कादेश र बेरेदको बीचमा छ। ");
INSERT INTO npi2010_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागारले अब्रामको छोरो जन्माइन अनि अब्रामले छोरोको नाउँ इश्माएल राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","इश्माएललाई हागारले जन्म दिंदा अब्राम छयासी वर्ष पुगेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","जब अब्राम 99 वर्ष पुगे परमप्रभु तिनी सामु प्रकट हुनुभयो। परमप्रभुले भन्नुभयो, “म सर्वशक्तिमान परमेश्वर हुँ। मसित सही पथ अनुशरण गर। ");
INSERT INTO npi2010_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","यदि तिमीले यसो गर्छौ, म हामीबीच एउटा करार तयार पार्नेछु। म तिम्रा सन्तानहरु व्यापक संख्यामा बढाउनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","तब अब्राम परमेश्वरअघि नतमस्तक भए र परमेश्वरले तिनलाई भन्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“यो हाम्रो करारमा मेरो भाग हो। म तिमीलाई धेरै-धेरै जाति-समूहहरूको पिता बनाउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","तिम्रो नाउँ अब्राम रहने छैन-तिम्रो नाउँ अब्राहाम हुनेछ। म तिमीलाई यो नाउँ राख्दैछु कारण तिमीलाई म धेरै-धेरै जाति-समूहहरुको पिता बनाउँदैछु। ");
INSERT INTO npi2010_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","म तिमीलाई धेरै-धेरै सन्तानहरू दिनेछु। नयाँ राष्ट्र र राजा तिमीबाट नै बनिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","म तिम्रो र मेरो बीचमा एक करार तयार बनाउँछु जुन करार तिम्रा सन्तानहरूको निम्ति पनि हुनेछ। म तिम्रो र तिम्रा सबै सन्तानहरूको परमेश्वर रहनेछु। यो करार संधैको निम्ति रही रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","अनि म तँ र तेरा सन्तानहरूलाई यो भूमि दिनेछु। म तलाईं कनानको सम्पूर्ण भूमि दिनेछु जसमा तँ अहिले विदेशी छस्। म यो भूमि संधैका लागि दिंदैछु अनि तेरो परमेश्वर हुन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","अनि परमेश्वरले अब्राहामलाई भन्नुभयो, “अब, यो चाहिं करारको तिम्रो भाग हो। अनि तिम्रा सन्तानहरूले यो मेरो करार पालन गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","तेरो र मेरो बीचको करार यही हो अनि यो सब तिम्रा सन्तानहरूको निम्ति हो। सबै छोरालाई खतना गराउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","तेरो र मेरो बिचमा भएको करार तैंले पालन गरेको देखाउनका लागी छाला काट्नेछस्। ");
INSERT INTO npi2010_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","जब केटो आठ दिनको हुन्छ, तैंले उसको खतना गर्नु पर्छ। तेरो घरमा जन्मिने कमाराको प्रत्येक केटो अनि विदेशीहरूबाट किनेका सबै पुरूष कमाराहरूलाई पनि खतना गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","यसरी तिम्रो जातिमा जन्मेको प्रत्येक केटाहरूको खतना भएको हुनु पर्छ। प्रत्येक केटाहरूको खतना भएको हुनु पर्छ। प्रत्येक केटो जो तिम्रो जाति-समूहमा जन्मिन्छ र प्रत्येक कमारा जो तिम्रो जाति-समूहमा ल्याइन्छ उसको खतना गरिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","जुन मानिसको खतना गरिंदैन, त्यसलाई बहिस्कृत गरिनु पर्छ किनभने यो मेरो करार हो जसलाई उनले उल्लंघन गरेको छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","परमेश्वरले अब्राहामलाई भन्नुभयो, “म साराईलाई नयाँ नाउँ दिनेछु अनि तिम्री पत्नि साराईको नयाँ नाउँ सारा हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","म उसलाई आशीर्वाद दिनेछु। म उसलाई एउटा छोरा पनि दिनेछु अनि तँ छोराको बुबा हुनेछस्। तिनी धेरै राष्ट्रहरूको आमा हुनेछिन् अनि उबाट धेरै राजाहरू जन्मिनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","परमेश्वरलाई सम्मान दर्शाउन अब्राहाम जमीनतिर मुख गरी घोप्टो भए। तर तिनले हाँस्दै आफैसित भने, “म एक सय वर्षको भएँ, अब म छोरा जन्माउन सक्तिन। अनि सारा पनि नब्बे वर्षकी भई र उनले नानी जन्माउन सक्तिन।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","तब अब्राहामले परमेश्वरलाई भने, “म आशा गर्छु इश्माएल जीवित रही तपाईंको सेवा गर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","परमेश्वरले भन्नुभयो, “होइन! मैले भनी सकें तिम्री पत्नी साराले एउटा छोरो जन्माउनेछिन् जसको नाउँ तिमीले इसहाक राख्नेछौ। म त्यो सित करार गर्नेछु। त्यो करार त्यस्तो हुनेछ उसका सबै सन्तानहरूसित संधैको निम्ति बाँचिरहने छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“तैंसे इश्माएलको कुरा गरिस अनि मैले त्यो सुनें। म उसलाई आशीर्वाद दिन्छु। उसको धेरै सन्तानहरू हुनछन् अनि तिनी बाह्रजना महान राजकुमारहरूको पिता हुनेछन् र तिनको परिवारहरूबाट एउटा महान् राष्ट्र बनिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","मेरो करार इसहाकसित गर्नेछु। इसहाक साराको छोरो हुनेछ। त्यो छोरो अर्को वर्ष यही समयमा जन्मिनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","परमेश्वर अब्राहामसित कुरा गरिसकेपछि स्वर्गमा जानु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","परमेश्वरले अब्राहामलाई सबै पुरूष मानिसहरूको खतना गर्नु भनेको हुनाले तिनले इश्माएल र तिनको घरमा भएका सबै कमाराहरूलाई संगै भेला गराए। अब्राहामले बाहिरबाट किनेर ल्याइएका कमाराहरूलाई पनि संगै भेला गराए। अब्राहामको घरमा भएका सबै पुरूषहरूलाई भेला गराए अनि तिनीहरूको खतना गरियो। अब्राहामले तिनीहरूलाई त्यही दिन खतना गराए जुन दिन परमेश्वरले भन्नु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","जब खतना गरियो अब्राहाम उनन्सय वर्षका र ");
INSERT INTO npi2010_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","तिनको छोरो इश्माएल तेह्र वर्षका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","तिनको छोरो इश्माएल र तिनको एकै दिन खतना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","त्यही दिन अब्राहामको घरमा जन्मेका कमाराहरू र किनेर ल्याइएका कमाराहरूको पनि खतना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","पछि फेरि परमप्रभुले अब्राहामलाई दर्शन दिनु भयो। अब्राहाम मम्रेको फलाँटको रूखको नजिक बस्दै थिए। एकदिन, दिउँसो एकदमै गर्मीको समयमा अब्राहाम पालको ढोकामा बसेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अब्राहामले आँखा उठाएर हेरे र उनले तीन जना पुरूषहरूलाई आफ्नो अगाडि उभिएको देखे। जब तिनले तिनीहरूलाई देखे तिनी तिनीहरूको सामु गए अनि नमस्कार गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","अब्राहामले तिनीहरूलाई भने, “हे मेरा महाशय म हजूरको दाससित केही बेर बस्नु होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","म तपाईंको पाउ धुनको निम्ति पानी लिएर आउँछु। तपाईंहरू रूखमुनि विश्राम गर्नुहोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","म तपाईंहरूको निम्ति केही रोटी ल्याउनेछु र तपाईंहरूको इच्छा अनुसार खान सक्नु हुन्छ। त्यसपछि तपाईंहरू आफ्नो गन्तव्य स्थानतिर प्रस्थान गर्न सक्नु हुन्छ।” तीनैजनाले भने, “यो अति नै असल कुरो हो र तपाईं जस्तो ठीक सम्झनु हुन्छ त्यही गर्नुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","अब्राहाम लगतै पालभित्र पसे र सारालाई भने, “चाडो गरी मिहिन पीठोको तीनवटा रोटी बनाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","तब फेरि अब्राहाम झट्टारिएर गाई-गोरूहरूको बथानतिर गई एउटा खाईलाग्दो असल बाछो ल्याएर झट्टै त्यसलाई मारी भोजन बनाउन नोकरलाई अह्राए। ");
INSERT INTO npi2010_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","अब्राहामले ती तीनै जनालाई मासुको परिकार, केही दही र दूध टक्रायाए। जब तिनीहरू रूखमुनि बसेर खान लागे अब्राहाम तिनीहरूको नजिक त्यही उभिरहे। ");
INSERT INTO npi2010_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ती तीनजना मानिसहरूले अब्राहामलाई सोधे, “तिम्री पत्नी सारा कहाँ छिन्?” अब्राहामले उत्तर दिए, “तिनी भित्र पालमा छिन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","तब परमप्रभुले भन्नुभयो, “म फेरि वसन्त ऋतुमा आउनेछु। त्यस समयमा तिम्री पत्नी साराले छोरो जन्माएकी हुनेछिन्।” साराले पालबाट यी सब कुराहरू सुनिरहेकी थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम र सारा निकै वृद्ध भइसकेका थिए। साराको सन्तान जन्मिने समय बितिसकेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","यसर्थ उनले जे सुनिन त्यो विश्वास गरिनन्। तिनी आफू एक्लै हाँसिन र भनिन्, “म र मेरा पति दुवै वृद्ध भइसकेका छौं मेरो गर्भधारण गर्ने समय बितिसकेको छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","तब परमप्रभुले अब्राहामलाई भन्नुभयो, “किन सारा हाँस्छिन् र भन्छिन् उमेरले गर्दा तिनी गर्भधारण गर्न असमर्थ भएकी छिन। ");
INSERT INTO npi2010_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","के परमप्रभुको निम्ति केही चीज गर्न गाह्रो छ? होइन! जब म वसन्तमा आउनेछु अनि तिम्री पत्नी साराले छोरो जन्माउनेछिन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","तर साराले आफू, “नहाँसेको कुरो भनिन्।” तिनले डराएर त्यसो भनेकी हुन्। तर परमप्रभुले भन्नुभयो, “होइन। तिमीले जे भन्यौ त्यो साँचो होइन। तिमी साँच्चै हाँस्यौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","तब ती मानिसहरू जानका लागि तर्खरमा उठे। तिनीहरूले सदोमतर्फ हेरे अनि त्यही दिशातर्फ हिंडे। अब्राहाम तिनीहरूलाई बाटो देखाउन केही परसम्म गए। ");
INSERT INTO npi2010_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","परमप्रभुले आफैंलाई भन्नुभयो, “के म अब के गर्नेछु अब्राहामलाई भनुँ? ");
INSERT INTO npi2010_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहाम एउटा महान र शक्तिशाली जाति बनिनेछन् अनि पृथ्वीका सबै मानिसहरू तिनको कारणले आशिष पाउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","म अब्राहामसित राम्रो सम्बन्ध राख्न आएकोछु जसले गर्दा उ आफ्ना नानीहरू अनि सन्तानहरूलाई सही र स्वच्छ के हो त्यो गर्न सिकाउन सक्छ ताकि तिनीलाई जे प्रतिज्ञा गरेको छ त्यो हुन दिन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","तब परमप्रभुले भन्नुभयो, “मैले धेरै पल्ट सुनेकोछु सदोम र गमोराका मानिसहरू साह्रै दुष्ट छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","म त्यहाँ जान्छु अनि हेर्छु मानिसहरू जस्तो मैले सुनेकोछु त्यस्तै छन् कि छैनन्। तब म पक्का जान्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","तब ती मानिसहरु फर्के अनि सदोम तर्फ हिंडन थाले। तर अब्राहाम परमप्रभुकोअघि उभिए। ");
INSERT INTO npi2010_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","तब अब्राहामले परमप्रभुतर्फ बढेर सोधे, “परमप्रभु, के दुष्ट मानिसहरूलाई ध्वंश पार्दा धर्मी मानिसहरूलाई पनि ध्वंश पार्नु हुन्छ? ");
INSERT INTO npi2010_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","यदि त्यहाँ पचास धर्मी मानिसहरू छन् भने त्यो शहरलाई नाश गर्नु हुन्छ? ");
INSERT INTO npi2010_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","साँच्ची नै, तपाईंले शहर नष्ट पार्नु हुनेछैन। दुष्ट मानिसहरूलाई सर्वनाश पार्दा ती पचास जना मानिसहरूलाई ध्वंश पार्नु हुँदैन। यदि त्यस्तो भयो भने दुष्ट र राम्रा मानिसहरू एकै हुन्छन दुवै वर्गले सजाय भोग्ने छन् निश्चय ब्रमाण्डका न्यायधिशले जे सही छ त्यही गर्नुहुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","तब परमप्रभुले भन्नुभयो, “यदि मैले सदोममा पचास जना असल मानिसहरू पाएँ भने म सम्पूर्ण शहरलाई माफ गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","तब अब्राहामले भने, “तपाईंको तुलनामा परमप्रभु म धूलो, र खरानी बराबर मात्र हुँ। तर तपाईंलाई विरक्त बनाउदै म एउटा प्रश्न फेरि गर्न पाउँ ");
INSERT INTO npi2010_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","के यदि पाँच जना धर्मी मानिसहरू हराए अनि पैतालीस जना मानिसहरू असल छन भने पनि के ती पाँच जानले गर्दा सारा शहर नाश पार्नुहुन्छ?” परमप्रभुले भन्नुभयो, “यदि मैले पैतालीस जना धर्मी व्यक्तिहरू पाए भने त्यो शहर नाश पार्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","अब्राहामले फेरि भने, “के यदि चालीसजना त्यहाँ असल भेटीए त्यो शहर नष्ट पार्नु हुन्छ?” परमप्रभुले भन्नुभयो, “यदि मैले चालीस जना व्यक्तिहरू असल भेटे त्यो शहर नाश पार्नेछैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","तब अब्राहामले भने, “परमप्रभु दया गरी मसंग नरिसाउनु होस्। मलाई यो जान्न दिनु होस् यदि त्यस शहरमा तीस जना व्यक्तिहरू असल भेटे तपाईं के त्यो शहर नष्ट पार्नु हुन्छ?” परमप्रभुले भननुभयो, “यदि मैले तीस जना व्यक्तिहरू असल भेट त्यो शहर नष्ट पार्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","तब अब्राहामले सोधे, “म मेरा परमप्रभुलाई विरक्तपार्दै फेरि प्रश्न गर्छु, यदि बीस जना मात्र असल मानिसहरू भेटे के गर्नु हुन्छ?” परमप्रभुले उत्तर दिनु भयो, “यदि मैले बीस जना मात्र असल मानिसहरू भेटे म त्यो शहर नष्ट पार्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","तब अब्राहामले भने, “परमप्रभु, दया गरी मसंग नरिसाउनु होला, तर अन्तिम पटक तपाईलाई विरक्त पार्दै फेरि म प्रश्न राख्न चाहन्छु। यदि तपाईंले दश जना मात्र असल मानिसहरू भेटे के गर्नु हुन्छ?” परमप्रभुले भन्नुभयो, “यदि दश जना मात्र पनि असल मानिसहरू भेटे म नाश पार्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","जब परमप्रभुले अब्राहामसित कुरा गरि सक्नु भयो अनि जानु भयो। अनि अब्राहाम आफ्नो घर गए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","साँझमा दुइजना स्वर्गदूतहरू सदोम शहरमा आए। त्यस बेला लूत सदोमको फाटकमा बसिरहेका थिए। लूतले स्वर्गदूतलाई देखेर भेट्न गए। तब लूतले तिनीहरूको सामुन्ने निहुरेर दण्डवत् गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","तिनले भने, “महाशय, कृपा गरी तपाईंहरूको दासको घरमा गई हात पाऊ धोई रात त्यही बिताउनु होस् र बिहान चाँडै उठी आफ्नो स्थानको लागि बाटोतर्फ प्रस्थान गर्नु होस्।” ती स्वर्गदूतहरूले भने, “अहँ हामी बाटोमै रात बिताउनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","तर लूतले तिनीहरूलाई आफ्नो घर लैजान अत्यन्तै बिन्ती गरे, यसर्थ स्वर्गदूतहरू लूतको घरमा गए। तब लूतले स्वर्गदूतहरूको निम्ति खाना तयार गरे अनि खमीर नहालेको रोटी बनाए र तिनीहरूले खाए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","तिनीहरू सुत्न जानुअधि सदोम शहरका सबै मानिसहरू आएर लूतको घर घेरे। ");
INSERT INTO npi2010_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","तिनीहरूले उनलाई बोलाए अनि भने, “राती तिम्रो घरमा आएका दुइ मानिसहरू कहाँ छन्? तिनीहरूलाई बाहिर हामी भएकोमा ल्याऊ जसले गर्दा तिनीहरूसित हामी संभोग गर्न चाहन्छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","तब लूत बाहिर निस्केर घरको ढोका लगाए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","त्यसपछि उनले भने, “हे मेरा साथीहरू, कृपा गरी तिनीहरूसित नराम्रो व्यवहार नगर। ");
INSERT INTO npi2010_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","सुन, कुनै पुरूषसित सहवास नगरेका मेरो दुइ जना छोरीहरू छन्। म तिमीहरूलाई सुम्पिदिनेछु र आफ्नो इच्छा अनुसार जे गर्न मन लाग्छ तिनीहरूसित गर। तर यी मानिसहरू जो मेरो घरमा आएका छन् तिनीहरूलाई केही नगर, तिनीहरूको रक्षा मैले गर्नु नै पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","घेरेका मानिसहरूले भने, “हामीलाई बाटो देऊ! हाम्रो बाटोबाट पर सर।” तब सदोमका ती मानिसहरूले भने, “यी मानिस हाम्रो शहरमा पाहुना भएर आएका हुन् अनि अहिले हाम्रो न्यायाधीश यी को हुन? अब हामी तिमीसित तिनीहरूसित भन्दा अशिष्ट व्यवहार गर्ने छौं।” त्यो भीडले लूतमाथि एकसाथ घचेटेर ढोका भत्काएर खोल्ने चेष्टा गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","तब ती भित्र भएका मानिसहरूले ढोका उघारे र लूतलाई भित्र ताने र ढोका थुने। ");
INSERT INTO npi2010_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","त्यसपछि तिनीहरूले ती बाहिर घर घेरेर बस्ने सबै बूढा-जवानहरूलाई अन्धा बनाइ दिए। तब तिनीहरूले ढोका खोल्न असमर्थ भए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","तब ती भित्र भएका दुइजना मानिसहरूले लूतलाई भने, “तिम्रो घरमा अरू कोही मानिसहरू छन्? तिम्रा ज्वाँईहरू, छोरा-छोरीहरू अनि जो पनि यस शहरमा छन् भने तिनीहरूलाई शहर छोडनु भनीदेऊ, ");
INSERT INTO npi2010_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","शहर छोड, किनभने हामी यसलाई नाश गर्न लागेका छौं। परमप्रभुलाई यो थाह भएकोछ यो शहर दुष्टहरूले भरिएको छ अनि उहाँले हामीलाई यो शहर नाश गर्न पठाउनु भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","तब लूत बाहिर गए अनि आफ्नो ज्वाँईहरूलाई भने, “उठ अनि यो शहर छोडिदेऊ किनभने परमप्रभुले यस शहरलाई नष्ट पार्नु हुँदैछ।” तर उसका ज्वाँईहरूले सोचे उनी ठट्टा गरिरहेका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","अर्को बिहानै उज्यालो हुन लाग्दा ती स्वर्गदूतहरूले लूतलाई चाँडो गर्न लगाए। तिनीहरूले भने, “हेर, यो शहरलाई दण्ड दिइन्छ। यसर्थ तिम्री पत्नी अनि छोरीहरू जो यहाँ छन् तिनीहरूलाई लिएर शहरबाहिर जाऊ। यसो गरे तिमीहरू यो शहरसितै नष्ट हुने छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","तर लूतले शहर छोड्न आनाकानी गरे। उनी दोमनमा परे। यसर्थ दुइजना स्वर्गदूतले उनलाई, उनकी पत्नी र छोरीहरूलाई आफ्नो हातले समाते अनि उनीहरूलाई सुराक्षित ठाउँमा लगे। परमप्रभु लूत अनि उनको परिवारप्रति दयालु हुनुहुन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","यसर्थ ती दुइ स्वर्गदूतहरुले लूत र उनको परिवारलाई शहरदेखि बाहिर पुर्याए। तिनीहरू शहरबाहिर आएपछि एकजना स्वर्गदूतले भने, “अब तिमीहरूले शहरतिर फकेर्र नहेर्नु, जीवन सुरक्षाको निम्ति भाग, अनि कुनै ठाउँमा पनि नथामिनु बेंसीमा कतै पनि नअडिनु। जबसम्म पर्वतमा पुग्दैनौ तिमीहरू भाग यदि थामियौ भने तिमीहरू शहरसितै नष्ट हुनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","तर लूतले ती दुई स्वर्गदूतहरुलाई भने, “महाशयहरू हो, यति टाडासम्म भाग्न मलाई कर नलगाउनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","म तपाईंको दासप्रति तपाईंहरू मेरो बचाऊको निम्ति अत्यन्तै दयालु हुनुहुन्छ। तर म यहाँदेखि पर्वतसम्म भागेर जान सक्तिन। यदि म अत्यन्तै ढिलो भएर पर्वतमा पुग्नु नसकेर केही हुनु गएँ भने? म मर्ने छु। ");
INSERT INTO npi2010_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","हेर्नुहोस्! यस ठाउँको नजिकै एउटा एकदमै सानो शहर छ र मलाई त्यहाँसम्म मात्र जानु दिनुहोस्। म त्यस शहरसम्म भाग्नु सक्छु र सुरक्षित रहन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","स्वर्गदूतले लूतलाई भने, “हेर, म तिमीलाई त्यसो गर्नु दिनेछु। म त्यो शहरलाई नाश पार्दिन। ");
INSERT INTO npi2010_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","तर त्यहाँ छिटो पुग। तिमीहरू त्यस शहर नपुगुञ्जेलसम्म म सदोम नाश पार्न सक्तिन।” (सानो शहर हुनाले यसको नाउँ सोअर हो।) ");
INSERT INTO npi2010_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","घाम झुल्कँदै गर्दा लूत सोअर शहरभित्र पस्दै थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","त्यति बेलै परमप्रभुले सदोम र गमोरालाई नष्ट गर्न शुरू गर्नु भयो। परमप्रभुले आकाशबाट आगो र जल्दै गरेको गन्धक त्यहाँ खसाल्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","यसरी परमप्रभुले ती शहरहरू नष्ट पार्नु भयो। परमप्रभुले समस्त बेंसी उद्भिदहरू र मानिसहरू सबै नष्ट पार्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","जब तिनीहरू भाग्दै थिए, लूतकी पत्नीले पछाडी फर्केर शहरलाई हेरिन्। जब उनले फर्केर हेरिन तिनी नूनको थुप्रोमा परिणत भइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","त्यसै दिन बिहानै अब्राहाम त्यस ठाउँमा गए जहाँ तिनी परमप्रभुको सामुन्ने उभिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","अब्राहामले सदोम र गमोरा शहरहरूतर्फ नजर डुलाएर त्यस बेंसीको सम्पूर्ण भूमिलाई हेरे। त्यो प्रान्तबाट धूवाँको मुस्लो गइरहेको तिनले देखे अनि त्यो तिनलाई भयंकर आगोबाट निस्किएको धूवाँ जस्तो लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","त्यस बेंसीको शहरहरूलाई परमेश्वरले नाश पार्नु भयो। तर परमेश्वरले जब यस्तो गर्नु भयो उहाँले अब्राहामलाई सम्झनु भयो र तिनको भतिजोलाई बचाउँनु भयो। लूत बेंसीको शहरहरूमा बसो-बास गर्दथिए तर शहरहरू नष्ट पार्नुअघि परमेश्वरले त्यहाँबाट बाहिर भगाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लूत सोअरमा बस्न डराए र आफ्नी दुवै छोरीहरू लिएर पर्वतको ओडारमा बस्न गए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","एक दिन उनका जेठी छोरीले आफ्नो बहिनीलाई भनी, “संसारमा कही पनि पुरूष र स्त्रीहरू विवाह गरेर आफ्नो सन्तान उत्पन्न गर्छन। तर हाम्रा पिता बृद्ध भई सकेका छन् अनि यहाँ वरिपरि हामीलाई सन्तान उत्पन्न गर्नका लागि समर्थन गर्ने कोही छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","यसर्थ हामीले हाम्रो पितालाई दाखरस पियाएर मताऊँ र तिनीसित सम्बन्ध गरौं। यसरी हाम्रो परिवारलाई जीवित राख्न आफ्नो पितालाई प्रयोग गर्न सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","त्यस रात यी दुइ दिदी-बहिनीहरूले आफ्नो पितालाई मद्य दिएर पूरा मताए। तब दिदी चाँहि आफ्नो पिताको ओछ्यानमा गई अनि उनीसित सहवास गरी। लूत यति मातेका थिए कति बेला छोरी आई र गई उनलाई थाहा भएन। ");
INSERT INTO npi2010_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","अर्को दिन दिदीले आफ्नी बहिनीलाई भनिन्, “हिजो राती, म हाम्रा पितासित सुतें। आज राती, फेरि उनलाई मताऊँ अनि तिमी उनको ओछ्यानमा जान सक्छौ अनि उनीसित शारीरिक सर्म्पक राख्नसक्छौ। यस प्रकार हामी आफ्नो परिवारलाई निःसन्तान हुनबाट बचाउन सक्छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","त्यस राती ती दुइ बहिनीहरूले आफ्नो पितालाई दाखरस पियाएर मताए अनि सानी चाँहि छोरी उनको ओछ्यानमा गई र सहवास गरी। तर फेरि लूत यति साह्रो मातेका थिए कति बेला को केटी उनको ओछ्यानमा सुत्न आई अनि उठेर गई उनलाई पत्तै भएन। ");
INSERT INTO npi2010_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","लूतका दुबै छोरीहरू गर्भवती भए अनि तिनीहरूका पिता तिनीहरूको नानीहरूका पिता थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","जेठी छोरीले छोरो जन्माई र उसको नाउँ मोआब राखी। मोआब आजका सबै मोआबी मानिसहरूको पिता हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","सानी छोरीले पनि छोरो जन्माई र उसको नाउँ बेनअमी राखी। बेनअमी आजका सबै अम्मोनी मानिसहरूका पिता हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","अब्राहाम त्यस ठाउँ छाडी नेगेब गए। अनि तिनी गरार शहरमा बसे। यो शहर कादेश र शूरको बिचमा पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","जब अब्राहाम गरार गए, तिनले मानिसहरूलाई भने सारा तिनकी बहिनी हुन्। गरारका राजा अबीमेलेकले यो सुने अनि सारालाई पत्नी बनाउनु आफ्ना सेवकहरूलाई लिन पठाए। ");
INSERT INTO npi2010_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","तर एक रात परमेश्वर उनको सपनामा आउनु भयो अनि भन्नुभयो, “हेर, तँ मरे जस्तै नै छस् किनभने जुन स्त्रीलाई तैंले पत्नी बनाएको छस् तिनको पहिले विवाह भएको हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","तर अबीमेलेक अझ सारासित सुतेका थिएनन्। यसर्थ अबीमेलेकले भने, “हे परमप्रभु, म दोषी छैन। के तपाईंले एक निर्दोष व्यक्तिलाई मार्नुहुन्छ? ");
INSERT INTO npi2010_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","अब्राहाम आफैले मलाई भने, ‘ती स्त्री उनकी बहिनी हुन्’ अनि स्त्रीले पनि भनिन्, ‘त्यो मानिस तिनको दाज्यु हुन्।’ यस कारण म पूर्णतः निर्दोष छु अनि जे मैले गरें म दोषी हुने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","त्यसपछि परमेश्वरले अबीमेलेकलाई सपनामा भन्नुभयो, “हो, म जान्दछु तिमी निर्दोष छौ। अनि म यो पनि जान्दछु तिमीलाई थाहा थिएन तिमी के गरिरहेका थियौ। तिमीलाई मैले बचाएँ। मैले तिमीलाई मेरो विरूद्ध पाप गर्न दिइन। त्यो म नै हुँ जसले तिमीलाई त्यस स्त्रीसित सुत्ने अनुमति दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","यसर्थ अब्राहामलाई उसकी पत्नी फर्काइ देऊ। अब्राहाम एक अगमवक्ता हुन्। उनले तिम्रो निम्ति प्रार्थना गर्नेछन् र तिमी जीवित रहनेछौ। तर यदि तिमीले अब्राहामलाई सारा फर्काएनौ भने म प्रतिज्ञा गर्छु तिमी मर्नेछौ। अनि तिम्रा सबै परिवार तिमीसितै मर्नेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","यसर्थ भोलिपल्ट एकाबिहानै अबीमेलेकले आफ्ना सबै सेवकहरूलाई बोलाए अनि तिनीहरूलाई आफ्नो सपनाको विषयमा बताए। उनका सेवकहरू साह्रैनै भयभीत भए। ");
INSERT INTO npi2010_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","त्यसपछि अबीमेलेकले अब्राहामलाई बोलाएर भने, “तिमीले हाम्रो निम्ति किन यस्तो गरेका छौ? मैले तिमीलाई के अनिष्ट गरेको थिएँ? तिमीले मेरो राज्यमा निकै कष्ट ल्यायौ? तिमीले मसित यस्तो नर्गनु पर्ने थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","तिमी किन डराएका हौ? र किन मसित तिमीले यस्तो व्यवहार गर्यौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","तब अब्राहामले भने, “म डराएको थिएँ। मैले सोचे यस भूमिमा कसैले पनि परमेश्वरको डर मान्दैन होला यसर्थ मैले सोचें तिमीहरूले सारालाई पाउनका निम्ति मलाई मार्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","त्यसमाथि, सारा मेरो बहिनी पनि हुन्। तिनी मेरा पिताकी छोरी हुनु तर मेरी आमाकी होइनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","परमेश्वरले मलाई पिताको घरबाट टाडो पठाउनु भयो। उहाँले मलाई धरै अंञ्चलहरूमा भ्रमण गराउनु भयो। यही कारणले मैले सारालाई भने, ‘यसरी नै तिमीले मलाई यो दया गर्न सक्छौ मानिसहरूलाई तिमी मेरी बहिनी हौ भन्नु।’” ");
INSERT INTO npi2010_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","तब अबीमेलेकले बुझे के भएको थियो। यसकारण उनले सारा अब्राहामलाई फर्काइ दिए। अबीमेलेकले अब्राहामलाई भेडा, बाख्रा गाई-गोरू तथा कमारा-कमारीहरू पनि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","अबीमेलेकले भने, “यो मेरो देश हो। तिम्रो वरिपरि हेर, तिमी जहाँ इच्छा गर्छौ त्यही बस्न सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","सारालाई अबीमेलेकले भने, “मैले तिम्रो दाज्यू अब्राहामलाई एक हजार चाँदीको टुक्राहरू दिएकोछु। मैले यो देखाउन दिएको हुँ जो घट्ना भयो त्यसको निम्ति म साह्रै नै दुःखी छु। प्रत्येकले जानून् तिमीले कुनै भूल गरेकी छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","त्यसपछि अब्राहामले परमप्रभुलाई प्रार्थना गरे, अनि परमेश्वरले अबीमेलेक, उसकी पत्नी अनि उनकी कमारीहरू सबैलाई स्वास्थ्य पार्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","किनभने परमप्रभुले अब्राहमकी पत्नी सारासित भएको घटनाले अबीमेलेकको घरमा भएका जम्मै महिलाहरूको गर्भ बन्द गराएर तिनीहरूलाई सन्तान उत्पन्न गर्न अयोग्य बनाइएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","परमप्रभुले सारालाई दया गर्ने प्रतिज्ञा गर्नु भएको थियो। परमप्रभु आफ्नो प्रतिज्ञा अनुसार साराप्रति दयालु हुनुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","सारा गर्भवती भइन अनि तिनले बृद्धाअवस्थामा अब्राहामको निम्ति एउटा छोरा जन्माइन्। ठीक समयमा परमेश्वरले जे वचन दिनु भएको थियो त्यो पुरा भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","साराले तिनको निम्ति एउटा छोरो जन्माएकी थिइन् उसको नाउँ अब्राहामले इसहाक राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","परमेश्वरको आज्ञा अनुसार त्यो बालक आठ दिनको हुँदा अब्राहामले उसको खतना गराए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","अब्राहाम एक सय वर्ष पुग्दा उसको छोरो इसहाक जन्मियो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","अनि साराले भनिन्, “परमेश्वरले मेरो निम्ति हाँसो ल्याउनु भएको छ, प्रत्येक मानिस जसले यो सुन्छ मसँग हाँस्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","कसैले पनि त्यो सोचेको थिएन अब्राहामको बुढेसकालमा साराले तिनलाई एउटा छोरो जन्माउनेछिन्। तर मैले बूढो अब्राहामको निम्ति छोरो जन्माइ दिएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","इसहाक लगातर बढी रह्यो र चाँडै खँदिलो खाना खान शुरू गर्ने भयो। यसर्थ अब्राहामले एउटा ठूलो भोज खुवाए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","एकजना मिश्रकी कमारी हागारले अब्राहामको पहिलो छोरो जन्माएकी थिइन्। सारा दिक्क भइन जब उनले हागारको छोरासित आफ्नो छोरा इसहाकलाई खेल्दै गरेको देखिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","साराले अब्राहामलाई भनी, “त्यो कमारी स्त्री र उसको छोरोलाई खेदि दिनु होस्, तिनीहरूलाई टाढा पठाउनु पर्छ। जब हामी मर्छौ हामीसँग जे छ हाम्रो छोरो इसहाकले पाउनेछ। म चाँहदिन कमारी स्त्रीको छोरो हाम्रा छोरो इसहाकको अंशको हकदार होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","यसले अब्राहामलाई अत्यन्तै दुःखी बनायो र तिनी आफ्नो छोरा इश्माएलको निम्ति चिन्तित भए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तर परमेश्वरले अब्राहामलाई भन्नुभयो, “त्यो केटा र कमारी स्त्रीको विषयमा तिमी चिन्ता नगर। जे साराले चाहन्छे त्यही गर, इसहाक मात्र तिम्रो उत्तराधिकारी हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","तर म तिम्रो कमारी स्त्रीको छोरालाई पनि आशीर्वाद दिनेछु। उ पनि तिम्रो पुत्र हो र उनले पनि आफ्नो परिवारबाट एउटा विशाल राष्ट्र बनाउने छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","अर्को दिन बिहानै अब्राहामले केही खाने कुरा र पानी ल्याए र हागारलाई दिए। हागारले ती कुराहरू लिई अनि आफ्नो छोरा लिएर हिंडी। हागारले त्यो ठाउँ छोडी अनि बेर्शेबाको मरूभूमिमा यता उता घुमी हिंड्न थालिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","केही समयपछि मशकको पानी सिद्धियो र पिउने पानी पनि थिएन। यसर्थ उनले आफ्नो छोरोलाई पोथ्रोमुनि राखिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","तब तिनी गइन् अनि आफ्नो छोरादेखि केही पर बसिन्। तिनले आफैलाई यस्तो भनिन्, म मेरो छोरालाई तिर्खाले मर्दै गरेको देख्न चाहन्न। आफ्नो छोराको मृत्यु शोक सही नसक्नु हुनेवाला थियो, तिनी आफ्नो छोराको लागि नराम्रो घतले रून थालिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्वरले हागारको छोरो रोएको सुन्नु भयो। अनि र्स्वगबाट परमेश्वरका स्वर्गदूत हागार कहाँ आए। उनले सोधे, “हागार तिमीलाई के कष्ट छ? परमेश्वरले बालक रोएको सुन्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","जाऊ, अनि बालकलाई सहायता गर उसको हात समात अनि सगँ-संगै हिंडाऊ। म उसलाई धेरै धेरै मानिसहरूको पिता बनाउनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","परमेश्वरले हागारको आँखा यसरी उघारी दिनु भयो उनले एउटा पानीको कूवा देखिन्। यसर्थ पानीको कूवामा तिनी गइन् अनि पानीको मशक पहिले भरिन् त्यपछि छोरोलाई पानी पिउन दिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","जबसम्म हागारको छोरो ठूलो भएन परमेश्वर ऊसंग नै रहनु भयो। इश्माएल मरूभूमिमा नै बस्यो र त्यहाँ एक शिकारी भयो। उनले तीर चलाउन राम्ररी सिकेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","उसको आमाले मिश्र देशबाट उसको निम्ति एउटी दुलही ल्याई दिइन्। इश्माएल पारान मरूभूमिमा बसो-बास गर्न थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","त्यही समय अबीमेलेक र उसको सेनापतिले अब्राहामसित कुरा गरे। तिनीहरूले अब्राहामलाई भने, “तिमी जे पनि गर्छौ परमेश्वरले तिमीलाई सघाउनु हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","यसर्थ परमेश्वरको नाउँमा मलाई वचन देऊ तिमी म र मेरा नानीहरूसित राम्रो व्यवहार गर्नेछौ। वचन देऊ तिमी, म अनि धर्ती प्रति जहाँ तिमी बाहिरको मानिस जस्तो भएर बसेका छौ दयालु हुने छौ। कसम् पनि खाऊ तिमी म प्रति दयालु हुने छौ जस्तो म तिमीप्रति छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहामले भने, “म शपथ दिन्छु तिमीले मसित जस्तो व्यवहार गरेका छौ त्यही व्यवहार म पनि तिमीसित गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","तब अब्राहामले अबीमेलेकसित नालिश गरे। उनले नालिश गरे कारण अबीमेलेकका नोकरहरूले एउटा पानीको कूवा खोसेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","तर अबीमेलेकले भने, “म जान्दिन कसले यस्तो काम गर्यो, तिमीले यस विषयमा मलाई भनेका थिएनौ, नत्र मैले आज भन्दा पहिला नै थाहा पाएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","यसकारण अब्राहाम र अबीमेलेकले एउटा सम्झौता गरे। यस सम्झौताको चिन्ह स्वरूप अब्राहामले अबीमेलेकलाई केही भेडाहरू र गाई वस्तुहरू दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामले सातवटा पाठी अबीमेलेकअघि राखि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमेलेकले अब्राहामलाई सोधे, “तिमीले यी सातओटा पाठीहरू चाँहि किन अलग्गै राखेका छौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","अब्राहामले भने, “जब तिमीले मबाट यी सातवटा पाठीहरू लिन्छौ तब यो प्रमाण हुन्छ त्यो कूवा मैले खनाएको हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","यसकारण यस घटनापछि त्यस कूवाको नाउँ बर्शेबा भयो। तिनीहरूले यस कूवाको नाउँ यस्तो राखे किन भने यस भूमिमा जहाँ तिनीहरूले एक अर्कालाई वचन दिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","यस प्रकारले अब्राहाम र अबीमेलेकले बर्शेबामा सम्झौता गरेका थिए। त्यसपछि अबीमेलेक अनि उनको सेनापति पलिश्तीहरूको देशतिर फर्किए। ");
INSERT INTO npi2010_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामले बर्शेबामा एक विशेष रूख रोपे। त्यस भूमिमा अब्राहामले परमप्रभु परमेश्वर जो संधै जीवित हुनुहुन्छ उहाँसित प्रार्थना गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अनि अब्राहाम बाहिरको मानिस जस्तो भएर धेरै वर्षसम्म पलिश्तीहरूको देशमा बसे। ");
INSERT INTO npi2010_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ती कुराहरू भइसकेपछि परमेश्वरले अब्राहामको जाँच लिने निर्णय लिनु भयो। परमेश्वरले तिनलाई भन्नुभयो, “अब्राहाम!” अनि अब्राहामले भने, “हजुर!” ");
INSERT INTO npi2010_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","तब परमेश्वरले भन्नुभयो, “मोरीयाह भूमिमा तिम्रो छोरोलाई लैजाऊ। मोरीयामा मेरो निम्ति बलिदान स्वरूप तिम्रो छोरो बलि देऊ। तिम्रो छोरो चाँहि इसहाक हुनु पर्छ तिम्रो एउटा छोरा जुन छोरालाई तिमी बढी माया गर्छौ। त्यहाँको कुनै एउटा पर्वतमा तिम्रो छोरोलाई होमबलि चढाऊ। कुन चाँहि पर्वतमा बलिदान चढाउनु पर्छ त्यो म बताउनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","बिहान अब्राहाम उठे अनि गधामा लगाम कसे। अब्राहामले आफूसंग छोरो इसहाक र दुइ जना नोकरहरू पनि लगे। तिनले बलिको निम्ति दाउरा काटे अनि परमेश्वरले बताउनु भएको ठाउँमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","तीन दिनसम्म यात्रा गरेपछि अब्राहामले माथितिर हेरे अनि तिनीहरू जानु पर्ने ठाउँ देखे। ");
INSERT INTO npi2010_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","त्यसपछि अब्राहामले कमाराहरूलाई भने, “गधासित यही पर्ख। म छोरोसित त्यस ठाउँमा जानेछु, अनि उपासना गर्नेछौ। अनि केही बेरपछि तिमीहरू भएको ठाउँमा हामी फर्कन्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहामले होमबलिको निम्ति दाउरा उठाएर छोरोको काँधमा राखि दिए। तिनले एउटा विशेष काट्ने हतियार र आगो पनि लगे। त्यसपछि अब्राहाम र तिनको छोरो आराधना गरिने ठाउँमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाकले आफ्नो पिता अब्राहामलाई सोध्‌यो, “बुबा!” अब्राहामले उत्तर दिए, “भन, छोरा।” इसहाकले भने, “म दाउरा र आगो देख्छु तर होम बलिको निम्ति दिनु पर्ने थुमाचाँहि कहाँ छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहामले उत्तर दियो, “छोरो परमेश्वर आफैले बलिदानको निम्ति थुमा बन्दोबस्त गरिदिनु हुँदैछ।” यसरी अब्राहाम र तिनको छोरो इसहाकसँगै बलिदिने ठाउँमा पुगे। ");
INSERT INTO npi2010_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","तिनीहरू त्यही निर्दिष्ट जग्गामा पुगे जहाँ परमेश्वरले अह्राउनु भएको थियो। त्यहाँ अब्राहामले वेदी बनाए अनि त्यसपछि वेदी माथि दाउरा राखेर आफ्नो छोरोलाई बाँधी वेदीमाथि राखिएको दाउरामाथि राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","तब तिनले काट्ने हतियार लिएर इसहाकलाई मार्न तत्पर भए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","तर अब्राहामलाई परमप्रभुका स्वर्गदूतले बाधा दिए। र्स्वगबाट स्वर्गदूतले बोलाए अनि भने, “अब्राहाम, अब्राहाम!” अब्राहामले उत्तर दिए, “हजूर।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","स्वर्गदूतले भने, “तिम्रो छोरोलाई नमार। उसलाई कुनै प्रकारको चोट पनि नलागोस्। मैले साँच्चै नै थाहा पाएँ तिमीले परमेश्वरलाई सम्मान गर्छौ अनि उहाँको आज्ञा पालन गर्छौ। तिमीले आफ्नो एक मात्र छोरोलाई मेरो निम्ति मार्न तयार भएको पनि मैले देखें।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","तब अब्राहामले त्यहाँ एउटा थुमा देखे। त्यो भेडाको पाठाको सींङ पोथ्रामा अडकिएको थियो। यसर्थ अब्राहामले त्यो थुमालाई मारे अनि आफ्नो छोराको बलिको सट्टामा त्यसलाई परमेश्वरको बलिदानको रूपमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","यसकारण अब्राहामले त्यस ठाउँको नाउँ, “यहोवा यिरे” राखे। आज पनि मानिसहरूले भन्छन, “यस पर्वतमाथि परमप्रभुलाई देखिन सकिन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","परमप्रभुका स्वर्गदूतले दोस्रो पल्ट अब्राहामलाई बोलाए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ती स्वर्गदूतले भने, “तिमीले मेरो निम्ति आफ्नो छोरो मार्न तत्पर थियौ, यसर्थ तिमीले यस्तो गरेको हुनाले म यो प्रतिज्ञा गर्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","म तिमीलाई साँचो रूपले आशीर्वाद दिन्छु। म तिमीलाई आकाशका ताराहरू भन्दा धेरै सन्तान दिन्छु। तिम्रा मानिसहरू समुद्रको किनारमा भएको बालुवाको कणभन्दा पनि वेशी हुनेछन्। अनि ती तिम्रा मानिसहरू आफ्ना आफ्नो शत्रुहरूका शहरहरू जितेर बस्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","अनि तिम्रा सन्तानहरूले संसारका सबै राष्ट्रहरूले आफ्ना निम्ति आशीर्वादको रूपमा पाउनेछन्। म यसै गर्नेछु किनभने तिमीले मेरा आज्ञाहरू मानेकाछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","त्यसपछि अब्राहाम आफ्नो नोकरहरू भएको ठाउँमा गए। तिनीहरू सबै बर्शेबा फर्के अनि अब्राहाम त्यहाँ धेरै समयसम्म बसे। ");
INSERT INTO npi2010_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","तब अब्राहामले खबर पाए, “उनको भाइ नाहोर र उनकी स्वास्नी मिल्कासित पनि नानीहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","तिनीहरूको जेठो छोराको नाउँ ऊज, माहिलो छोराको नाउँ बूज र साइलोको नाउँ कमूएल थियो। कमूएल आरामका पिता हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","तब त्यहाँ केसेद, हजो, पिलदाश, यिदलाप र बतूएल थिए।” ");
INSERT INTO npi2010_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बतूएल रिबेकाको पिता थिए। मिल्काह यी आठजना छोराहरूकी आमा थिइन्, अनि नाहोर पिता थिए। नाहोर अब्राहामको भाइ थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोरको उसकी नोकर्नी रूमबाट पनि अन्य चार छोराहरू थिए, ती छोराहरू तेबह, गहम, तहस र माका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा एक सय सत्ताईस वर्षसम्म बाँचिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","अनि कनान देशको किर्यतअर्बा (हेब्रोन) शहरमा मरिन्। अब्राहाम आफ्नी पत्नीको मृत्युमा दुःखी भए अनि उनको निम्ति रोए। ");
INSERT INTO npi2010_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","त्यसपछि अब्राहामले आफ्नी मरेकी स्वास्नीलाई छोडेर हित्ती मानिसहरूसित कुरा गर्न गए। ");
INSERT INTO npi2010_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","उनले भने, “म यस प्रदेशको बासिन्दा होइन। यहाँ त म केवल यात्री हुँ यसर्थ मेरी पत्नीको लाश गाडनुको निम्ति कही जग्गा छैन, म अलिकति जग्गा चाहन्छु म त्यो लाश गाडन सकूँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ती हित्ती मानिसहरूले अब्राहामलाई उत्तर दिए, ");
INSERT INTO npi2010_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“महाशय सुन्नु होस्, तपाईं हामीहरूमाझ परमेश्वरका एकजना मानिस हुनुहुन्छ यसर्थ हाम्रो चिहान घारीमा तपाईं जहाँ मन पराउनु हुन्छ त्यहाँ फिक्री नगरी आफ्नो पत्नीको लाश गाड्न सक्नु हुन्छ। तपाईंकी पत्नीको लाश गाडन यहाँ हामी मध्ये कसैले पनि बाधा दिन सक्तैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","अब्राहाम उठे अनि मानिसहरूको सामुन्ने शिर निहुराए। ");
INSERT INTO npi2010_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","तिनले तिनीहरूलाई भने, “यदि तपाईंहरू साँच्चै मेरी पत्नीको लाश गाड्नको निस्ति सहायता गर्नु हुन्छ भने मेरो कुरा सुन्नु होस् र सोअरको छोरो एप्रोनसित मेरो निम्ति कुरा गरिदिनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","उसलाई भन्नु होस् उसको खेतको आखिरमा मक्पेलाको ओडार छ र उनले मलाई त्यो मेरो दाममा चिहान बनाउन दियोस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन तिनीहरू कै बीचमा थियो। उनले अब्राहामलाई उत्तर दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“होइन, महाशय। म तपाईंलाई जमीन दिनेछु। यी सब मानिसहरूकोअघि म तपाईंलाई ओडार दिनेछु जसको फलस्वरूप तपाईंले त्यस जग्गामा आफ्नी पत्नीको लाश गाड्न सक्नु हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","तब अब्राहामले हित्ती मानिसहरूको अघि शिर निहुराए। ");
INSERT INTO npi2010_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ती सबै मानिसहरूको सम्मुख अब्राहामले एप्रोनसित भने, “तर म त खेतको पुरै मोल दिन चाहन्छु। मैले दिएको दाम स्वीकार गर्नु होस्। म मेरा मर्नेहरूलाई त्यहाँ गाड्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोनले अब्राहामलाई उत्तर दियो, ");
INSERT INTO npi2010_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“हे महाशय मेरो कुरा सुन्नु होस्। त्यस जग्गाको दाम त चार सय चाँदीको शेकेल हुन सक्छ जो तपाईं र मेरो निम्ति यो कुनै ठूलो कुरा होइन। तपाईंले आफ्नी पत्नीको मृत देह त्यहाँ गाड्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहामले एप्रोनको कुरा माने अनि हित्ती मानिसहरूको सामुन्ने तिनले चार सय सिक्का चाँदी तौलीएर जमीनको धन्धा गर्ने व्यापारीको हातमा थमाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","यसरी एप्रोनको खेतको मालिक बद्लिएर अब्राहाम बनिए। त्यो जग्गा मम्रेको पूर्व मक्पेलामा थियो र त्यसभित्र भएका ओडार र रूखहरू थिए। शहरका सबै मानिसहरू जो शहरको फाटकमा भेला भएका थिए, तिनीहरूले एप्रोन र अब्राहाम बीच भएको सौदा देखे। ");
INSERT INTO npi2010_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","तब अब्राहामले उनकी पत्नीको मृत शरीरलाई मक्पेलाको चउरमा कनान देशको हेब्रोन (मम्रे) को छेऊमा गुफामा गाडे। ");
INSERT INTO npi2010_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","अब्राहामले त्यो जमीन र ओडार हित्ती मानिसहरूको अघि किने अनि त्यो तिनको कान्‌नी रूपले भयो अनि तिनले त्यो जमीन चिहान घारीको निम्ति प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम दीर्घ जीवन बाँचे अनि अत्यन्तै वृद्धा भएका थिए र त्यो समय भरि तिनले गरेका प्रत्येक कुरालाई परमप्रभुले आशीर्वाद दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहामको सबभन्दा पुरानो अनि प्रमुख सेवक तिनको प्रत्येक चीजको जिम्मेवार थियो। अब्राहामले उसलाई आफू भएको ठाउँमा बोलाए अनि भने, “तेरो हात मेरो तिघ्रामुनि राख। ");
INSERT INTO npi2010_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","अब म चाहन्छु तैंसे मलाई एउटा वचन दे। पृथ्वी अनि स्वर्गका परमप्रभु परमेश्वरको अघि तैंले मलाई वचन दे कनान देशकी कुनै पनि कन्यासित मेरो छोरोको विवाह हुन दिने छैनस्। हामी तिनीहरूको वीचमा बस्छौं तर तैंले कनानी कन्यासित उसलाई विवाह गर्न दिने छैनस्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","तँ तेरो आफ्नै देशमा गएर मेरो छोरो इसहाकको निम्ति एउटी कन्या लिएर आइज।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","त्यस नोकरले अब्राहामलाई भने, “हुन सक्छ कन्याले मसँग यहाँ आउने इच्छा गरिनन् भने के म तपाईंको छोरोलाई मेरो देशमा लैजाउँ?” ");
INSERT INTO npi2010_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहामले उसलाई भने, “होइन, तैंसे मेरो छोरोलाई त्यस देशमा नलैजा। ");
INSERT INTO npi2010_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","परमप्रभु, स्वर्गका परमेश्वरले मलाई मेरो जन्म थलोबाट यस भूमिमा ल्याउनुभयो। त्यो देश मेरो पिता अनि उनको परिवारको निम्ति थियो। तर परमप्रभुले म र मेरो परिवारलाई यो नयाँ भूमि दिने प्रतिज्ञा गर्नु भयो। परमप्रभु आफैले तिमीलाई लिएर जानका लागि एकजना स्वर्गदूत पठाउन् ताकि मेरो छोरोले बेहुली रोज्न सक्छ अनि यहाँ ल्याउँछ। ");
INSERT INTO npi2010_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","तर यदि केटीले तिमीसंग आउन अस्वीकार गर्छे भने तिमी आफ्नो वचन पूरा गर्नका लागि बाध्य हुनु पर्ने छैन। त्यहाँ मेरो छोरालाई न लैजाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","यसर्थ त्यो नोकरले आफ्नो हात आफ्ना मालिक अब्राहामको तिघ्रा मुनि राखेर कसम खाए। ");
INSERT INTO npi2010_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","त्यो नोकरले अब्राहामबाट दशवटा ऊँट लियो अनि ऊ त्यस ठाउँबाट हिंड्‌यो। नोकरले धेरै प्रकारको राम्रा-राम्रा उपहारहरू लिएर गयो। ऊ नाहोरको शहर मेसोपोटामिया गयो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","त्यो नोकर शहर बाहिरको कूवामा गयो जहाँ साँझमा स्त्रीहरू पानी लिन घरबाट बाहिर आउँथे। त्यस नोकरले त्यहाँ ऊँटहरूलाई घुँडा टेकाएर बसायो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","त्यस नोकरले भने, “हे परमप्रभु! तपाईं मेरा मालिक अब्राहामको परमेश्वर हुनुहुन्छ। आज उनको छोरोको निम्ति मलाई एउटी दुलही हासिल गराई दिनु होस्। कृपा गरी मेरा मालिक अब्राहामको निम्ति यति गरिदिनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","म यहाँ पानीको कूवाको छेउमा बस्छु अनि पानी लिनको निम्ति कन्याहरू शहरबाट आइरहेका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","म विशेष एउटा चिन्हको निम्ति हेरिरहनेछु जसद्वारा म जान्न सकूँ कुन चाँहि केटी इसहाकको निम्ति असल हुन सक्छे। यो एउटा विशेष चिन्ह होः म कन्यालाई भन्नेछु ‘दया गरी पानीको गाग्री तल राख म पानी पिउन सकूँ।’ जब त्यस कन्याले भन्‌छिन्, ‘लौ पानी खाऊ, म तपाईंको ऊँटलाई पनि पानी दिन्छु,’ तब मलाई यो पक्का हुन्छ त्यो कन्या इसहाकको निम्ति योग्य छे। यदि यस्तो भयो तपाईंले प्रमाणित गराई दिनु हुन्छ त्यो कन्या इसहाकको निम्ति योग्य हुन्छे अनि म पनि यो सम्झनेछु तपाईंले मेरा मालिक अब्राहामको निम्ति दया गर्नु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","तब नोकरको प्रार्थना शेष हुनअघि नै रिबेका नाउँ भएकी एउटी कन्या त्यहाँ आई। रिबेका बतूएलकी छोरी थिइ। बतूएल अब्राहामको भाइ नाहोर अनि मिल्काको छोरो थियो। रिबेका आफ्नो काँधमा पानीको गाग्रो लिएर कूवामा आएकी थिइन। ");
INSERT INTO npi2010_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","तिनी अत्यन्तै सुन्दरी तरूणी थिइन जो सँग कुनै मानिस सुतेका थिएनन्। तिनी आफ्नो गाग्रीमा पानी भर्न कूवाको नजिक आइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","तब त्यो नोकर त्यस केटी भएकोमा दगुरेर पुग्यो अनि भने, “दया गरी तिम्रो गाग्रीबाट मलाई पानी पिउन देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","रिबेकाले तुरन्तै काँधबाट गाग्री तल राखेर उसलाई पानी पिउन दिइ। उनले भनी, “महाशय, पानी पिउनुहोस्।” उनले त्यस नोकरलाई केही पानी पिउन दिइ शेष मात्र गरेकी थिइ। ");
INSERT INTO npi2010_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","उनले भनी हालीन, “म तपाईंको ऊँटहरूको निम्ति पनि केही पानी दिन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","त्यसपछि रिबेकाले गाग्रीमा रहेको पानी सबै ऊँटहरूको निम्ति पिउन राखिएको द्रोणिकामा खन्याई। तब ऊ पानी ल्याउन कूवामा गई अनि सबै ऊँटहरूलाई पानी खुवाई। ");
INSERT INTO npi2010_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","त्यस नोकरले रिबेकालाई राम्ररी हेर्यो। त्यो निश्चित हुन चाहन्थयो परमप्रभुले उसको प्रार्थना सुन्नुभयो र उसलाई उत्तर दिनु भयो अनि उसको यात्रा सफल पारिदिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ऊँटहरूले पानी खाईसके पछि उनले रिबेकालाई आधा शेकेल तौलको सुनको एउटा नत्थी र दश शेकेल तौलको सुनको दुइवटा बालाहरू पनि दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","त्यस नोकरले उसलाई सोध्यो, “तिम्रा पिता को हुनुहुन्छ? अनि के उहाँको घरमा मेरो दललाई बास बस्ने ठाउँ छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","रिबेकाले उत्तर दिइ, “मेरा बुबा बतूएल हुनुहुन्छ। उहाँ मिल्का र नाहोरका छोरा हुनुहुन्छ। तपाईंका ऊँटहरूको निम्ति पराल र तपाईंको निम्ति बास बस्ने ठाउँ छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","उनले फेरि भनिन्, “हजुर हामीसंग पराल र चारो दुवै अनि तपाईंहरूको लागि सुत्न एउटा कोठा पनि छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","त्यो नोकर निहुरियो अनि परमप्रभुको उपासना गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","त्यसले भने, “परमप्रभु मेरा मालिकका परमेशवर, तपाईं धन्य हुनुहुन्छ। परमप्रभु मेरा मालिकको निम्ति दयालु तथा विश्वस्त हुनु भएको छ। मेरा मालिकको छोरोको निम्ति योग्य केटी भएकोले मलाई परमप्रभुले डोर्याएर ल्याउनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","तब रिबेका दगुरेर गई अनि आफ्नो परिवारलाई यो विषय वृतान्त बताई। ");
INSERT INTO npi2010_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबेकाको दाज्यू थियो। उसको नाउँ लाबान थियो। रिबेकाले त्यस मानिसले भनेको सबै कुरा सुनाई। ");
INSERT INTO npi2010_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","लाबानले उनले भनेको सुनिरहेको थियो अनि जब उनले रिबेकाको नाकमा सुनको नत्थ र हातमा बालाहरू देख्यो ऊ कूवामा दगुर्दै गए। अनि त्यहाँ कूवामा त्यो मानिस आफ्नो ऊँटहरूको नजिक उभिरहेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","लाबानले भने, “महाशय, तपाईं यहाँ बाहिर नउभिनुहोस, तपाईंलाई हाम्रो घरमा स्वागत छ। विश्राम गर्न मैले तपाईंको निम्ति एउटा कोठा र ऊँटहरूलाई बस्ने ठाउँ ठीक पारेकोछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","यसर्थ अब्राहामको सेवक लबनानको घरभित्र गए अनि ऊँटहरूबाट भारी झार्न सघायो। उसले ऊँटहरूका लागि पराल ल्यायो। उनले पानी पनि तयार राख्यो ताकि सेवक अनि मानिसहरू जो उनीसंग थिए आफ्नो गोडा धुन सकुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","लाबानले त्यस नोकरलाई खानु पनि दियो तर उनले खानु मानेन र भने, “म यहाँ किन आएको हुँ, जबसम्म म त्यो बताउँदिन, म खाने छैन।” यसकारण लाबानले भने, “तब हामीलाई भन्नुहोस्, किन आउनु भएको हो?” ");
INSERT INTO npi2010_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","त्यस नोकरले भने, “म अब्राहामको एकजना नोकर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","परमप्रभुले मेरा मालिकलाई धेरै आशीर्वाद दिनुभएको छ। मेरा मालिक महान मानिस हुनु भएकोछ। परमप्रभुले अब्राहामलाई धेरै बगाल बाख्राहरू र धेरै बथान गाई-वस्तु दिनु भएकोछ। अब्राहामको धेरै धेरै ऊँटहरू र गधाहरू छन् दास-दासी र सुन-चाँदीहरू पनि निकै नै छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","सारा मेरा मालिक अब्राहामकी पत्नी थिइन् अनि तिनले वृद्धावस्थामा एउटा छोरो जन्माइन् र मेरा मालिकले उनीसंग भएका प्रत्येक चीज आफ्नो छोरोलाई दिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","मेरा मालिकले मलाई एउटा शपथ गर्न कर लाउनु भयो। मेरो मालिकले मलाई भन्नुभयो, ‘तिमीले मेरो छोरोलाई कनानी केटी विवाह गर्न नदिनु। हामी यद्धपि तिनीहरूकै माझमा बस्छौं तर म छोरोले कनानी केटी विवाह नगरोस भन्ने चाहन्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","यसर्थ तिमी मेरो आफ्नो पिताको भूमिमा जानेछौ र हाम्रो सन्तान भित्रबाट उसको निम्ति एउटी कन्या केटी रोजेर ल्याउने छौ।’ ");
INSERT INTO npi2010_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","मैले मालिकलाई भने, ‘हुन सक्छ कन्या मसित यो देशमा नआउलीन्।’ ");
INSERT INTO npi2010_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","तर मेरा मालिकले मलाई भन्नुभयो, ‘म परमप्रभुको सेवा गर्छु, अनि परमप्रभुले आफ्नो स्वर्गदूत तँसित पठाउनु हुन्छ अनि तँलाईं सहायता गर्नु हुन्छ। मेरो मानिसहरूबीच नै तैंले मेरो छोरोको निम्ति एउटी दुलही पाउनेछस्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","तर मेरो पिताको देशमा मेरा मानिसहरूले यदि मेरो छोरोको निम्ति दुलही दिन अस्वीकार गरे भने तँ यो शपथबाट मुक्त हुनेछस्।’ ");
INSERT INTO npi2010_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“आज मैले यो कूवामा आएर परमप्रभुसित बिन्ती गरें ‘हे परमप्रभु, मेरा मालिकका परमेशवर, दया गरी मेरो यो यात्रा सफल तुल्याइदिनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","यहाँ यस कूवा नजिक उभिएर पानी भर्न आउने केटीलाई पर्खिन्छु। तब म भन्नेछु, “मलाई तपाईंको गाग्रोबाट पानी पिउन दिनु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","योग्य केटीले विशेष प्रकारले उत्तर दिन्‌छे। उनले भन्छे, “यो पानी पिउनु होस-अनि म तपाईंका ऊँटलाई पनि पानी दिन्छु।” त्यस प्रकारले म चाल पाउनेछु परमप्रभुले मेरा मालिकको छोरोको निम्ति रोज्नु भएको दुलही यही केटी हुनु पर्छ।’ ");
INSERT INTO npi2010_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“मेरो प्रार्थना शेष हुनु अघि अचम्म हेर; रेबेका कूवामा पानी भर्न आइन्। कूवामा पानी भर्न आउँदा उनको काँधमा एउटा गाग्री थियो। मैले उनलाई अलिकति पानी मागें। ");
INSERT INTO npi2010_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","उनले झट्टै आफ्नो काँधबाट गाग्रो तल झारिन अनि मलाई पानी दिइन्। तब उसले भनिन्, ‘यो पिउनु होस् अनि तपाईंका ऊँटहरूको निम्ति केही अरू पनि पानी दिनेछु।’ ");
INSERT INTO npi2010_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","त्यसपछि मैले उनलाई सोधें, ‘तिम्रा बाबु को हुन्?’ तिनले भनिन्, ‘मेरा बाबु बतूएल हुन्, मिल्का र नाहोरका छोरा।’ तब मैले उनलाई नत्थी र पाखुरामा लाउने बालाहरू दिएँ। ");
INSERT INTO npi2010_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","मैले मेरो शिर झुकयाएर परमप्रभुलाई धन्यवाद चढाएँ, मैले परमप्रभु मेरा मालिकका परमेशवरलाई धन्यवाद दिएँ। मलाई सोझै मेरा मालिकको भाइकी नातिनीकोमा पुर्याइदिनु भएकोमा मैले परमप्रभुलाई धन्यवाद दिएँ। ");
INSERT INTO npi2010_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","अब भन्नु होस्, के तपाईं मेरा मालिकप्रति कृपालु अनि विश्वासी भई उनका छोरोलाई तपाईंकी छोरी दिनु हुन्छ? अथवा उसलाई तपाईंकी छोरी दिनु हुन्छ? भन्नु होस् मलाई त्यपछि मैले के गर्नु पर्छ म बुझ्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","त्यसपछि लाबान र बतूएलले उत्तर दिए, “हामीले थाहा पायौ यो सब परमप्रभुबाट नै भइरहेकोछ, यसर्थ यसकुरालाई बद्ली गर्ने विषयमा हामी केही पनि भन्न सक्तैनौं। ");
INSERT INTO npi2010_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","रिबेका यहीं छे, यसलाई लिएर जाऊ। उनले तिम्रा मालिकका छोरोसित विवाह गरोस्। परमप्रभु यही चाहनु हुँदोरहेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","जब अब्राहामको नोकरले त्यो सुन्यो ऊ परमप्रभुअघि भूइँमा निहुरियो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","त्यसपछि उनले ल्याएका उपहारहरू रिबेकालाई दियो। उनले राम्रो लुगाहरू र सुन चाँदीका गहनाहरू दियो। उनले रिबेकाको आमा र दाज्यूलाई पनि बहुमूल्य उपहार दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","त्यसपछि त्यो नोकर र ऊसंगै पुगेको मानिसले खाइपिइ गरेर त्यहीं रात बिताए। बिहान मात्र चाँडै उठेर तिनीहरूले भने, “अब हामी मालिककहाँ जानै पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","रिबेकाकी आमा र दाज्यूले भने, “रिबेका हामीसितै केही समयको निम्ति बसोस्। हामीसित त्यो दश दिनसम्म बसोस् र त्यसपछि जान सक्छे।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","तर नोकरले तिनीहरूलाई भने, “मलाई पर्खनु नलाउनु होला। परमप्रभुले मेरो यात्रा सफल पार्नु भएकोछ। मलाई मेरा मालिककहाँ फर्केर जानु दिनुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","रिबेकाको दाज्यू र आमाले भने, “हामी रिबेकालाई बोलाउनेछौ र उनले के गर्न चाहन्छे सोध्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","तिनीहरूले रिबेकालाई बोलाएर भने, “के तँ यी मानिसहरूसंगै अहिले नै जान चाहन्छेस्?” रिबेकाले भनिन्, “अँ, म जान्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","यसकारण तिनीहरूले रिबेकालाई अब्राहामको नोकर अनि उसका साथीहरूसित जान दिए। रिबेकाकी सहेली पनि उसैसंग लागीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","जब तिनीहरू जानु तत्पर भए तब तिनीहरूले भने, “ए हाम्री बहिनी, तिमी हजारौं हजार जनको जननी बन, र तिम्रो सन्तानले शत्रुहरूलाई हराओस्, अनि तिनीहरूको शहरहरू कब्जा गरून्।” ");
INSERT INTO npi2010_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","त्यसपछि रिबेका र उसको सहेलीहरू ऊँटमा चढेर अघि लागे अनि अब्राहामको नोकर र उसको साथीहरू तिनीहरूको पछि लागे। यसरी त्यो नोकरले रिबेकालाई आफूसंगै लिएर घर फर्किन यात्रा शुरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","त्यस बेला इसहाकले बेर-लहै-रोई छोडेर नेगेवमा बस्न शुरू गरेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","एक साँझ इसहाक मैदानमा घूमि रहेको थियो। इसहाकले आँखा उठाएर हेर्यो अनि टाडोमा ऊँटहरू आउँदै गरेको देख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबेकाले नजर घुमाई अनि इसहाकलाई देखी। तब तिनी ऊँटबाट ओर्लिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","उनले नोकरलाई सोधी, “हामीहरूसित भेट गर्न त्यहाँ मैदानमा घूमिरहने जवान केटो को हो?” त्यो नोकरले भने, “यो मेरो मालिकको छोरो हो।” यति सुनेपछि रिबेकाले आफ्नो अनुहार छोपिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","जुन कुराहरू भएका थिए नोकरले इसहाकलाई सबै वृतान्त बतायो। ");
INSERT INTO npi2010_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","तब इसहाकले केटीलाई आफ्नो आमाको पालमा लग्यो। त्यही दिन इसहाकले रिबेकालाई विवाह गर्यो। ऊ रिबेकालाई अत्यन्तै प्रेम गर्थ्यो। यसकारण आफ्नी आमाको मृत्यु पछि उनले धेरै सान्तवना पायो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामले फेरि विवाह गरे अनि तिनकी नयाँ पत्नीको नाउँ कतुरा थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","कतुराले जिम्रान, योक्षान, मदान, मिद्यान, यिशबाक र शूहालाई जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान, शबा अनि ददानका बुबा थिए। ददानका सन्तानहरू, अश्शूरी, लतूशी अनि लऊम्मी हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","एपा, एपेर, हनोक अबीदा अनि एल्दा मिद्यानका छोराहरू थिए। अब्राहाम र कतुराको विवाहबाट यी नानीहरू भए। ");
INSERT INTO npi2010_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","अब्राहामको मृत्यु हुनु अघि नै आफ्नो नोकर्नीहरूका छोराहरूलाई केही उपहारहरू दिए अनि तिनीहरूलाई पूर्बतिर पठाइदिए। तिनीहरूलाई इसहाकदेखि टाढा पठाइदिए। त्यसपछि आफूसँग जे जति थियो अब्राहामले इसहाकलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम एक सय पचहत्तर वर्षसम्म स्वस्थ थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","त्यसपछि तिनी दुर्बल भए अनि मरे। तिनी घेरै वर्षसम्म आनन्दपूर्वक बाँचे। तिनलाई तिनका पुर्खाहरूसितै गाडियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","तिनका छोराहरू इसहाक अनि इश्माएलले तिनलाई मक्पेलाको ओडारमा गाडे। यो ओडार सोअरको छोरो एप्रोनको खेतमा थियो। यो मम्रेको पूर्वमा थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","यो त्यही ओडार थियो जुन अब्राहामले हित्ती मानिसहरूबाट किनेका थिए। अब्राहाम र तिनकी पत्नी सारालाई त्यही ओडारमा गाडे। ");
INSERT INTO npi2010_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहामको मृत्यु भएपछि परमेश्वरले इसहाकलाई आशीर्वाद दिनुभयो अनि तिनी बेर-लहै-रोईमा बसिरहे। ");
INSERT INTO npi2010_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","इश्माएलको परिवारको सूची यही हो। इश्माएल अब्राहाम र हागारको छोरो थिए। हागार साराकी मीश्र देशी कमारी थिइन् ");
INSERT INTO npi2010_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएलका छोराहरूको नाउँ यस प्रकार थियो। पहिलो छोरो नबायोत थियो। त्यसपछि जन्मनेहरूको सूची अनुसार केदार, अबदेल, मिब्साम, ");
INSERT INTO npi2010_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दुमा, मस्सा, ");
INSERT INTO npi2010_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नपीश अनि केदमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","तिनीहरूको पर्खालभित्र र बाहिरको सम्झौता अनुसार यिनीहरू इस्राएलका छोराहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल एक सय सैंतीस वर्षसम्म बाँचे। त्यसपछि उनको मृत्यु भयो। अनि उनलाई उनका आफन्तहरू गाडेको ठाउँमा गाडियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","इश्माएलका सन्तानहरू समस्त मरूभूमिको इलाकामा बसे। यिनीहरूको इलाका हवीलादेखि शूरको नजिक मिश्रको सीमा र यसको पनि अघि अश्शूरको किनारसम्म थियो। तिनीहरू घुमी हिंडे अनि आफ्नो दाज्यू-भाइ, सन्तानहरू र भूमिमाथि आक्रमण गरिरहे। ");
INSERT INTO npi2010_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","इसहाक अब्राहामको छोरो थियो र यो तिनको वृत्तान्त कथा हो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","जब इसहाक चालीस वर्षका भए उनले रिबेका नाउँकी कन्यासित विवाह गरे। रिबेका पद्दन-आराम भनिने ठाउँकी थिइन् अनि अरामी बतूएलकी छोरी र अरामी लाबानकी बहिनी थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","इसहाककी पत्नी रिबेका बाँझी थिई। यसर्थ इसहाकले आफ्नी पत्नीका निम्ति परमप्रभुसित प्रार्थना गरे। परमप्रभुले तिनको प्रार्थना सुन्नु भयो अनि रिबेका गर्भवती भइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","जब रिबेका गर्भवती भइन्, उनले आफ्नो गर्भमा भएको शिशुबाट अत्यन्तै कष्ट सहनु पर्यो। उनको गर्भमा भएको शिशुहरू गर्भभित्रै आपसमा एका-अर्कामा लडाइँ गर्थे। रिबेकाले परमप्रभुसित प्रार्थना गरिन् अनि भनिन्, “मसित यस्तो किन भइरहेकोछ?” ");
INSERT INTO npi2010_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","परमप्रभुले उनलाई भन्नुभयो, “तिम्रो कोखमा दुइवटा राष्ट्रहरू छन्। दुइवटा राष्ट्रका राजाहरू तिमीबाट जन्मनेछन्, र तिनीहरू छुट्टीनेछन्। एउटा छोरो अर्को छोरोभन्दा शाक्तिशाली हुनेछ अनि जेठाले कान्छाको सेवा गर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","अनि जब समय पूरा भयो तब रिबेकाले जुमल्याहा छोरा जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","पहिलो छोरो रातो वर्णको थियो अनि उसको छाला भुत्लाले बनिएको लुगा जस्तो थियो। यसर्थ उसको नाउँ एसाव राखियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","जब दोस्रो छोरो जन्मियो। उनले पहिलो छोरो एसावको कुर्कुच्चा बलियोसित समातेको थियो। यसैले उसको नाउँ याकूब राखियो। एसाव र याकूब जन्मदा इसहाक साठी वर्ष पुगेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","केटाहरू हलहली बढे। एसाव एकजना सिपालु शिकारी भयो अनि ऊ मैदानतिरै बस्न मन पराउँथ्यो। तर याकूब शान्त स्वभावको थियो अनि पाल भित्रै बस्थयो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","इसहाकले एसावलाई मन पराउँथिए अनि उनले मारेको जनवारहरूको मासु खान रूचाउँथिए। तर रिबेकाले याकूवलाई माया गर्थिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","एकदिन एसाव शिकारबाट थाकेर भोकले हत्तु भएर फर्केर आयो। याकूब एक भाँडा सिमी उसिनिरहेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","यसर्थ एसावले याकूबलई भने, “म भोकले दुर्बल भइरहेकोछु। मलाई त्यो केही रातो सिमी खान देऊ।” (यही कारणले मानिसहरूले उसलाई एदोम भन्ने गर्द थिए।) ");
INSERT INTO npi2010_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","तर याकूबले उनलाई भने, “पहिला तिमीले मलाई जेठा छोराको जन्मअधिकार बेच्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसावले भने, “म भोकले मर्न आँटेकोछु। यदि म मरें भने मेरो बाबुको सबै सम्पत्तिले पनि केही सहायता गर्न सक्तैन। यसर्थ म मेरो अंश दिइहाल्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","तर याकूबले भने, “पहिले मलाई वचन दे तैंले मलाई त्यो दिन्छस्।” यसकारण एसावले याकूबलाई वचन दियो। एसावले आफ्नो बाबुको सम्पत्तिको आफ्नो ज्येष्ठ-अधिकार याकूबलाई बेचि दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","तब याकूबले एसावलाई रोटी र भोजन दियो। एसावले खायो, र हिड्‌यो। यस प्रकारले एसावले यो देखायो आफू पहिलो छोरो भएकोमा उसलाई आफ्नो ज्येष्ठ-अधिकारको कुनै पर्वाह छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","एकपल्ट त्यहाँ अनिकाल भयो। यो अनिकाल पनि त्यस्तै प्रकारको थियो जुन अब्राहामको समयमा भएको थियो। यसर्थ इसहाक गरार शहरमा पलिश्ती राजा अबीमेलेककहाँ गए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","परमप्रभुले इसहाकसित कुरा गर्नु भयो। उहाँले इसहाकलाई भन्नुभयो, “मिश्र देश नजाऊ, त्यस ठाउँमा जाऊ जुन म तिमीलाई देखाउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","त्यही देशमा बस तब म तलाईं सहायता गर्नेछु। म तलाईं आशीर्वाद दिनेछु। तेरो परिवार र तँलाईं यो सबै देश दिनेछु। म त्यही गर्नेछु जुन मैले तेरो बाबु अब्राहामलाई वचन दिएको थिएँ। ");
INSERT INTO npi2010_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","म तेरो परिवारलाई आकाशका ताराहरू जस्तै बनाउनेछु। अनि यी सबै भूमिहरू तेरो परिवारहरूलाई दिनेछु? पृथ्वीका सबै राष्ट्रहरूले तेरा सन्तानहरूद्वारा आशीर्वाद पाउँनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","म यस्तो यसैले गरिरहेकोछु किनभने तेरो बाबु अब्राहामले मेरो आज्ञा पालन गरे अनि मैले जे जे भने ती सब गरे। अब्राहामले मेरो आज्ञा, मेरो विधिहरू र मेरो नियमहरूको पालन गरे।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","इसहाक गरारमै बसे। ");
INSERT INTO npi2010_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","इसहाककी पत्नी रिबेका अत्यन्तै सुन्दरी थिइन। त्यस ठाउँका मानिसहरूले इसहाकलाई रिबेकाको विषयमा सोधे। इसहाकले भने, “यो मेरो बहिनी हो।” इसहाकले रिबेकालाई आफ्नो पत्नी हो भन्न डरायो। इसहाक रिबेकालाई पाउँनुको निम्ति मानिसहरूले उसलाई मार्न सक्छन् भनेर डराउँथ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","जब इसहाक त्यहाँ धेरै दिनसम्म बसे तब एक दिन अबीमेलेकले आफ्नो झ्यालबाट हेरे अनि इसहाक रिबेकासित जिस्की रहेको देखे। ");
INSERT INTO npi2010_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","अबीमेलेकले इसहाकलाई बोलाए अनि भने, “यो आइमाई तेरी पत्नी रहेछ, तर तैंले हामीलाई किन तेरो बहिनी हो भनेर भनिस्?” इसहाकले उसलाई भने, “म डराएँ कतै तिमीले उसलाई आफ्नो बनाउनुको निम्ति मलाई मार्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेकले भने, “तिमीले हाम्रो निम्ति नराम्रो काम गर्यौ। हाम्रा कोही पनि मानिस तिम्री पत्नीसित सुत्न सक्थ्यो। तब त्यो मानिस ठूलो पापको दोषी हुने थियो।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","तब अबीमेलेकले सबै मानिसहरूलाई चेतावनी दिए अनि भने, “तिनीहरूले त्यस मानिस र तिनकी पत्नीलाई नोक्सान नपुर्याउनु। यदि कसैले तिनीहरूलाई नोक्सान पुर्याउँछ भने उसलाई निश्चय नै मारिनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकले त्यस भूमिमा खेती गरे अनि त्यस वर्ष धेरै नै फसल उब्जाए। परमप्रभुले उसलाई धेरै आशिष दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","इसहाक धनी भए। उनले त्यस बेलासम्म सम्पत्ति बटुली बसे जब सम्म उसंग धेरैभन्दा धेरै सम्पत्ति भएन। ");
INSERT INTO npi2010_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ऊसित धेरै बगाल अनि हूल गाई बस्तुहरू थिए। कमारा-कमारीहरू पनि उनकोमा घेरै नै थिए। सबै पलिश्तीहरू ऊ सँग आरीस गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","यसैले धेरै वर्ष अघि इसहाकका बाबु अब्राहाम र तिनका नोकरहरूले बनाएका कूवाहरू पलिश्तीहरूले ध्वंश पारिदिए। पलिश्तीहरूले कूवाहरूमा मैला हालेर भरिदिए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","अनि अबीमेलेकले इसहाकलाई भने, “हाम्रो देश छोडी देऊ। तिमी हामी भन्दा धेरै शक्तिशाली भएकाछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","यसर्थ इसहाकले त्यो भूमि छोडिदिए अनि गरारको उपत्यकामा बसे। ");
INSERT INTO npi2010_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","त्यस समयभन्दा धेरै अघि अब्राहामले धेरै कूवाहरू खनाएका थिए। जब अब्राहामको मृत्यु भयो, पलिश्तीहरूले सबै कूवाहरूमा माटो हालेर पुरिदिए। यसर्थ इसहाक त्यहाँ गएर फेरि ती कूवाहरू खानाए अनि उनका बाबु अब्राहामले जे जे नाउँ ती कूवाहरूको राखेका थिए तीनै नाउँ राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाकका नोकरहरूले पनि त्यो सानो नदीको नजिक एउटा कूवा खने। त्यस कूवाबाट पानीको एउटा मूल बग्न थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","तर जो मानिसहरूले गरार बेंसीमा भेडा चराउँथे, तिनीहरूले इसहाकका गोठालासित झगडा गरे। तिनीहरूले भने, “यो पानी हाम्रो हो।” यसर्थ इसहाकले त्यस कूवाको नाउँ एसेक राखे। उनले त्यस कूवाको नाउँ त्यसकारण राखे किनभने त्यही जग्गामा ऊसित ती मानिसहरूले झगडा गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","त्यसपछि इसहाकका नोकरहरूले अझ अर्को एक कूवा खने। त्यस जग्गाका मानिसहरूले पनि त्यस कूवाको निम्ति झगडा गरे। यसर्थ इसहाकले त्यस कूवाको नाउँ पनि सित्ना राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","इसहाक त्यहाँबाट गए अनि फेरि अर्को कूवा खनाए। तर त्यहाँ कूवाको विषयमा कोही पनि झगडा गर्न आएनन्। यसर्थ इसहाकले त्यस कूवाको नाउँ रहोबोत राखे। इसहाकले भने, “अहिले परमप्रभुले हाम्रो निम्ति स्थान पाउनु भएछ। हामी अघि बढनेछौं अनि सफल हुनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","त्यस भूमिबाट इसहाक बेर्शेबा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","त्यस रात परमप्रभुले इसहाकसित कुरा गर्नु भयो। परमप्रभुले भन्नुभयो, “म तेरो बाबु अब्राहामका परमेशवर हुँ। नडरा, म तँसित छु र म तलाईं आशीर्वाद दिनेछु। मेरो दास अब्राहामको कारणले म तेरो परिवारलाई विशाल बनाउनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","यसर्थ त्यस ठाउँमा इसहाकले एउटा वेदी बनाए अनि परमप्रभुको आराधना गरे। इसहाकले त्यहाँ एउटा पाल अनि त्यहाँ उसका नोकरहरूलाई एउटा कूवा पनि खनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","अबीमेलेक इसहाकलाई भेट्न गरारबाट आए। तिनीसंग आफ्नो सल्लाहकार अहुज्जत र सैन्य सेनापनि पीकोललाई पनि ल्याएको थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाकले सोध्यो, “तिमी मलाई भेट्न किन आयौ? तिमी त मसित मैत्री सम्बन्ध राख्दैन थियौ। तिमीले मलाई आफ्नो देश त्याग्नु पनि बाध्य गराएको थियौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","उसले उत्तर दियो, “अब हामीले बुझ्यौं परमप्रभु तिमीसित हुनुहुन्छ। हामी चाहन्छौं तिमीसित हाम्रो एउटा सम्झौता होस्। हामी चाहन्छौं तिमीले हामीलाई एउटा वचन देऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","हामीले तिमीलाई कुनै नोक्सान गरेका थिएनौ र अब तिमीले वचन दिनु पर्छ तिमीले पनि हाम्रो केही नोक्सान गर्ने छैनौ। हामीले तिमीलाई पठायौं तर हामीले शान्तिसितै पठायौं। अब यो निश्चित छ परमप्रभुले तिमीलाई आशीर्वाद दिनु भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","त्यसकाराण इसहाकले तिनीहरुलाई उधुय-भोज दिए। तिनीहरू सबैले खाए अनि पिए। ");
INSERT INTO npi2010_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","अर्को दिन बिहान तिनीहरू प्रत्येक मानिसले कसम खाए अनि त्यसपछि इसहाकले तिनीहरूलाई शान्तिसित विदा दिए अनि तिनीहरू पनि सकुशल फर्के। ");
INSERT INTO npi2010_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","त्यसदिन इसहाकका नोकरहरू आए तिनीहरूले खनेको कूवाहरूको विषयमा बताए। नोकरहरूले भने, “हामीहरूले ती कूवाहरूबाट पानी पियौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","यसकारण इसहाकले त्यसको नाउँ शिबा राखे र अहिले पनि त्यस शहरको नाउँ बेर्शेबा भनिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","जब एसाव चालीस वर्ष पुगे उनले हित्ती स्त्रीहरूसित विवाह गरे। एक जना बेरीकी छोरी यहूदीत थिइन् अर्की एलोनकी छोरी बासमत थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","यी विवाहले इसहाक अनि रिबेकाको मन दुःखले भरिदियो। ");
INSERT INTO npi2010_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक बूढा भइसकेका थिए र उनका आँखा यति कमजोर भएका थिए उनले राम्ररी देख्न सक्तैन थिए। एक दिन आफ्नो जेठा छोरा एसावलाई बोलाएर भने, “हे मेरो छोरा।” एसावले उत्तर दिए, “भन्नु होस्, बाबु।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाकले भने, “हेर, म बूढा भइसकेकोछु। हुन सक्छ अब म चाँडै मर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","अब तँ मेरो निम्ति धनु काँड लिएर शिकार खेल्न जा र एउटा जनावर मारेर। ");
INSERT INTO npi2010_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","मेरो निम्ति स्वादिष्ट भोजन बनाएर मलाई दे, म खान्छु। तब म मर्नुभन्दा पहिले तँलाईं आशीर्वाद दिन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","यसर्थ एसाव शिकार खेल्न गए। जति बेला इसहाकले एसावसँग ती कुराहरू गरे रिबेकाले सुनिरहेकी थिइ। ");
INSERT INTO npi2010_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रिबेकाले आफ्नो छोरो याकूबलाई भनिन्, “सुन्! तेरो बाबु र दाज्यू कुरा गरिहेको मैले सुनें। ");
INSERT INTO npi2010_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","तेरो बाबुले भने, ‘मेरो निम्ति एउटा जनावर मार। मेरो निम्ति भोजन बना र म खानेछु। त्यसपछि म मर्नुभन्दा पहिले तँलाईं आशीर्वाद दिनेछु।’ ");
INSERT INTO npi2010_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","यसर्थ मेरा कुरा सुन छोरो, र म जसो भन्छु त्यसै गर। ");
INSERT INTO npi2010_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","आफ्ना बाख्राहरू भएको ठाउँमा जा र दुइवटा मजाका बाख्राहरू लिएर आइज। म तिनीहरूबाट यस्तो स्वादिष्ठ भोजन तयार पार्नेछु जस्तो तेरो बाबुले मन पराउँछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","त्यसपछि तैंले तेरो बाबुलाई भोजन पुर्याउनु र उनको मृत्युअघि तँलाईं आशीर्वाद दिनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","तर याकूबले आफ्नी आमालाई भने, “मेरा दाज्यू रौं नै रौं भएको मानिस हुन् म तिनी जस्तो रौं नै रौं भएको मानिस होइन। ");
INSERT INTO npi2010_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","यदि मेरा बुबा मलाई छुनु हुन्छ, तब उनीले थाह पाउनेछन्, म एसाव होइन। उनले मलाई आशीर्वाद दिने छैनन्। किनभने मैले उनीसंग हिंड्ने प्रयत्न गरे।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","यसर्थ रिबेकाले उसलाई भनिन्, “यदि केही झमेला उब्जेको खण्डमा म त्यसको दोष स्वीकार्नेछु। मैले भनेको मान अनि गएर दुइवटा छिप्पिएका बाख्राहरू लिएर आइज।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","यसर्थ याकूब बाहिर गए अनि दुइवटा बाख्राहरू समाते अनि आमाकहाँ ल्याए। उनकी आमाले मासुको उसका बुबाले मन पराउने तरकारी पकाइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","त्यसपछि रिबेकाले उसको जेठा छोरोले लगाउन मन पराउँने पोशक ल्याईन्। उनले आफ्नो कान्छो छोरो याकूबलाई त्यो पोशाक लगाउन दिईन्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","रिबेकाले बाख्राको पाठाका छालाहरू याकूबको गाला अनि हातमा वाँधिदिई। ");
INSERT INTO npi2010_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","तब उनले याकूबलाई आफूले पकाएको स्वादिष्ट भोजन अनि पोलेको रोटी दिईन्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","याकूबले आफ्नो बाबुको नजिक गएर भने, “बुबा।” अनि उसको बाबुले सोधे, “के, तँ को होस्?” ");
INSERT INTO npi2010_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूबले आफ्नो बुबालाई भने, “म तपाईंको जेठो छोरो एसाव हुँ। तपाईंले जे भन्नुभयो मैले त्यही गरें। अब उठ्नुहोस् अनि मैले शिकार गरी मारेको मृगको मासुको स्वाद चाख्नु होस् ताकि तपाईंले मलाई आशिष दिनुहुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","तर इसहाकले आफ्नो छोरालाई भने, “तैंले यति चाँडो शिकार खेली कसरी जनावरहरू मारिस्?” याकूबले भने, “किनभने परमप्रभु परमेश्वले मलाई झट्टै नै शिकार फेला पारिदिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","तब इसहाकले याकूबलाई भने, “मेरो छोरो, मेरो छेऊमा आइज त, यदि मैले छोएँ भने म जान्न सक्छु साँच्चै तँ मेरो छोरो एसाव नै होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","यसर्थ याकूब आफ्नो बाबु इसहाक छेऊमा गए। इसहाकले छोए अनि भने, “तेरो आवाज याकूबको जस्तो सुनिन्छ, तर तेरा पाखुराहरू रौले भरिएकोले एसाव जस्तै लाग्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","इसहाकले यो याकूब नै हो भनी चिन्न सकेनन् किनभने उसको पाखुराहरू एसावको झैं थियो। यसर्थ इसहाकले याकूबलाई आशीर्वाद दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","इसहाकले सोधे, “के तँ साँच्चै मेरो छोरो एसाव होस्?” याकूबले उत्तर दिए, “हो, म एसाव नै हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","तब इसहाकले भने, “मलाई खाने कुरो ल्याइदे। म त्यो खानेछु अनि तलाईं आशीर्वाद दिनेछु।” याकूबले इसहाकलाई खान दिए अनि तिनले खाए। त्यसपछि याकूबले तिनलाई केही दाखरस पनि दिए अनि उनले पिए। ");
INSERT INTO npi2010_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","त्यसपछि इसहाकले उनलाई भने, “मेरो छोरो, मेरो नजिके आएर मलाई चुम्बन गर्”। ");
INSERT INTO npi2010_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","तब याकूबले आफ्नो बाबुको नजिक गएर चुम्बन गरे। इसहाकले तिनका लुगाहरूको गन्ध सुँघे र उनलाई आशीर्वाद दिए। इसहाकले भने, “मेरो छोरो परमप्रभुबाट आशीर्वाद पाएको खेतको सुगन्ध झैं होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमप्रभुले तँलाईं धेरै वर्षा दिऊन् जसले गर्दा तँलाईं धेरै अन्न र दाखरसहरू प्राप्त होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","सबै मानिसहरूले तेरो सेवा गरून्। राष्ट्र तेरो अघि झुकोस्। तँ आफ्नो दाज्यू-भाइहरूको शासक हुनेछस्। तेरी आमाका छोराहरू, तँ अघि झुक्नेछन् अनि तेरो आज्ञा पालन गर्नेछन्। “प्रत्येक मानिस जसले तँलाईं सराप दिन्छ उसले सराप पाउँछ, अनि प्रत्येक मानिस जसले तलाईं आशीर्वाद दिन्छ, उसले आशीर्वाद पाउँछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकले याकूबलाई आशीर्वाद दिने काम पूरा गरे। याकूबले आफ्नो बाबु इसहाकलाई छोडेर गएको मात्र थिए एसाव शिकारबाट फर्केर आए। ");
INSERT INTO npi2010_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","एसावले आफ्नो बुबाले मन पराउने परिकारको मासु तयार पारे अनि बुबाकहाँ ल्याए। उनले आफ्नो बुबालाई भने, “बुबा” म तपाईंको छोरो हुँ। उठ्नुहोस् अनि मृगको मासु चाख्नु होस ताकि तपाईं मलाई आशिष दिनु सक्नुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","तर इसहाकले उसलाई सोधे, “तँ को होस्?” उनले उत्तर दिए, “म तपाईंको छोरो एसाव हुँ। तपाईंको जेठो छोरो।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","तब इसहाक छक्क परे र काँपे अनि भने, “त्यो को थियो जसले तँ आउनु भन्दा अघि नै मासु ल्यायो? मैले सबै खाँए अनि त्यसलाई आशीर्वाद दिएँ। अब आशीर्वाद फर्काउन अत्यन्तै ढिलो भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","एसावले आफ्नो बाबुको कुरा सुने। तिनी अत्यन्तै क्रोधित भए अनि दुःखी भए। तिनी चिच्याए अनि बाबुलाई भने, “बुबा, मलाई पनि आशीर्वाद दिनुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाकले भने, “तेरो भाइले मसित ध्रूत्याइँ गर्यो। त्यो आयो अनि तैंले पाउने आशीर्वाद लिएर गयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसावले भने, “उसको नाउँ याकूब हो। यो नाउँ उसको निम्ति उपयुक्त छ। उनले मसित दुइ पल्ट चलाखी गर्यो। उनले मबाट जेठो छोरोको अधिकार खोस्यो अनि अहिले मैले पाउँने आशीर्वाद लग्यो।” त्यसपछि एसावले भने, “मेरो निम्ति केही आशीर्वाद साँच्नु भएको छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकले उत्तर दिए, “छैन, अब एकदमै ढिलो भयो। मैले याकूबलाई तँमाथि शासन गर्ने शाक्ति दिएँ। उसका सबै दाज्यू-भाइहरू उसको नोकर हुनेछन् पनि भनें। अनि मैले उसको निम्ति धेरै अन्न फलोस् अनि दाखरस होस् भनेर आशीर्वाद दिएँ। अब तेरो निम्ति मेरोमा केही छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","तर एसावले आफ्नो बाबुलाई आशीर्वाद मागिरह्यो। “के तपाईंसित खाली एउटै मात्र आशीर्वाद छ, बुबा? बुबा! मलाई पनि आशीर्वाद दिनुहोस्!” एसाव रून थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","तब इसहाकले उनलाई भने, “तँ मलिलो भूमिमा बस्न पाउने छैनस्। तैंले आकाशबाट शीत सम्म पनि पाउने छैनस्। ");
INSERT INTO npi2010_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","तैंले बाँच्नको निम्ति संघर्ष गर्नु पर्छ। अनि तँ आफ्नो भाइको कमारा बनिनेछस्। तर तैंले स्वाधीन हुन युद्ध गर्ने छस्। तैंले उसको नियन्त्रणलाई भत्काउने छस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","यस आशीर्वादको कारणले त्यसपछि एसावले याकूबलाई घृणा गर्न थाले। एसावले मनमा सोचे, “मेरा बाबु अब चाँडै मर्नु हुन्छ, अनि त्यसपछि उनको शोक गर्ने समय आउनेछ, तर त्यसपछि म उसलाई मार्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","एसावको याकूबलाई मार्ने योजना रिबेकाले सुनिन्। उनले याकूबलाई बोलाइन् र भनिन्, “सुन, तेरो दाज्यू एसावले तँलाईं मार्ने षड्‌यन्त्र रचिरहेको छ। ");
INSERT INTO npi2010_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","यसर्थ, छोरो, म जे भन्छु त्यही गर। मेरो दाज्यू लाबान हारानमा छ, तँ त्यहाँ जा अनि लुक। ");
INSERT INTO npi2010_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","त्यहाँ उसित केही समयको निम्ति बस्। जब सम्म दाज्यू रिसाउन छाडदैन त्यतिञ्जेल तँ त्यही बस। ");
INSERT INTO npi2010_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","केही समयपछि तेरो दाज्यूले तैंले उनलाई के गरिस् भुल्नेछ। त्यसपछि तँलाईं लिन म नोकरहरू पठाउनेछु। म एकै दिनमा दुइवटा छोराहरू हराउनु चाँहदिन।” ");
INSERT INTO npi2010_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","तब रिबेकाले इसहाकलाई भनिन्, “तिम्रो छोरो एसावले हित्ती आइमाईहरू विवाह गरेको छ। म यी आइमाईहरूसित विरक्त भइसकेकी छु, कारण यी आइमाईहरू हाम्रा समाजका होइनन्। यदि याकूबले पनि ती आइमाईहरूबाट नै कसैसित विवाह गरे, म पनि मरिहाल्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसहाकले याकूबलाई बोलाए अनि उनलाई आशीर्वाद दिए। त्यसपछि इसहाकले उनलाई आज्ञा दिए। उनले भने, “तैंले कनानी आइमाईहरू विवाह गर्ने छैनस्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","यसर्थ यस ठाउँलाई छाडेर पद्दन-आराममा। तेरी आमाको माइती- घर जा। तेरी आमाको दाज्यू लाबान त्यहाँ बस्छन्। उनको छोरीहरू मध्ये एक जनासित विवाह गर्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","म प्रार्थना गर्छु जसले गर्दा सर्वशक्तिमान परमेश्वले तँलाईं आशीर्वाद दिनु हुनेछ अनि तेरो धेरै सन्तान हुनेछन्। म प्रार्थना गर्छु तँ एउटा महान राष्ट्रको पिता हुनेछस्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","म प्रार्थना गर्छु, परमेश्वले अब्राहामलाई झैं तलाईं अनि तेरा सन्तानलाई आशीर्वाद दिनु हुनेछ। अनि म प्रार्थना गर्छु तँ जहाँ बसेको छस् त्यही भूमि तेरो हुनेछ। परमेश्वले अब्राहमलाई दिनु भएको भूमि त्यही हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","यसर्थ इसहाकले याकूबलाई रिबेकाको दाज्यूको घरमा पठाए। यसर्थ याकूब अरामी बतूएलको छोरो लाबान कहाँ गए। लाबान रिबेकाको दाज्यू थिए। रिबेका एसाव र याकूबकी आमा थिइ। ");
INSERT INTO npi2010_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसावले बुझे उसका बाबु इसहाकले याकूबलाई आशीर्वाद दिए। अनि एसावले बुझे विवाह गर्नको निम्ति याकूबलाई इसहाकले पद्दन-आराम पठाए। एसावले बुझे इसहाकले याकूबलाई कनानी आइमाई विवाह नर्गनु भनी आदेश दिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","अनि एसावले बुझे याकूबले आमा-बाबुको कुरा मानेर पद्दन-आराम गए। ");
INSERT INTO npi2010_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","एसावले बुझे उनका छोराहरूले कनानी आइमाईहरू विवाह गरेको मन पराउँदैनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","एसावकी दुइ पत्नीहरू थिए। तर एसाव इश्माएलकहाँ गए र उनकी छोरी महालथसंग विवाह गरे। इश्माएल अब्राहामका छोरा थिए र महालथ नबायोतकी बहिनी थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब बर्शेबा छोडेर हारानतिर लागे। ");
INSERT INTO npi2010_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","याकूबले आफ्नो यात्रा शुरू गर्दा घाम डुबि सकेको थियो। यसर्थ रात बिताउनको लागि याकूब एउटा ठाउँमा गए। याकूबले त्यहाँ एउटा चिहान देखे अनि सुत्नको लागि त्यसैमा आफ्नो शिर राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","याकूबले सपना देखे। एउटा सिडी पृथ्वीदेखि स्वर्गलोक सम्म पुगेको थियो। याकूबले स्वर्गदूतहरू त्यस सिंडीमा तल र माथि गरिरहेको देखे। ");
INSERT INTO npi2010_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","याकूबले स्वर्गदूतहरूलाई यस लिस्नुमा चढेको र ओर्लेको देखे। उनले परमप्रभुलाई आफ्नो छेऊमा उभिएको देखे। परमप्रभुले भन्नुभयो, “म तिम्रो बाजे अब्राहामको परमेश्वर हुँ। म इसहाकको परमेश्वर हुँ। म तिमीलाई त्यो भूमि दिनेछु जहाँ तिमी सुतिरहेका छौ। म त्यो भूमि तिमी र तिम्रा सन्तानहरूलाई दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","तेरा सन्तानहरू त्यति विघ्न हुनेछन् जति पृथ्वीमा धूलोको कण छ। तिनीहरू पूर्व, पश्चिम, उत्तर अनि दक्षिणतिर फैलिएर बस्नेछन्। पृथ्वीमा बस्ने सबै जातिले तेरा सन्तानहरूको कारण आशीर्वाद पाउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“म तेरो साथमा रहनेछु र तेरो रक्षा गर्नेछु तँ जहाँ गए पनि तँलाईं म यहाँ फर्काएर ल्याउनेछु। म तलाईं त्यसबेलासम्म छोडने छैन जबसम्म तेरो सन्तानहरूलाई म दिएको प्रतिज्ञा मैले पूरा गर्दिन।” ");
INSERT INTO npi2010_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","तब याकूब ब्यूँझेर उठे अनि भने “म जान्दछु परमप्रभु यही ठाउँमा हुनुहुन्छ। तर जबसम्म म सुतेको थिइन तबसम्म मलाई थाहा थिएन परमप्रभु यहाँ हुनुहुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","याकूब डराए। उनले भने, “यो एउटा दुःखदायी ठाउँ हो। यो केही पनि होइन तर अवश्य नै परमेश्वरको घर हो। यो स्वर्गको द्वार हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","अर्को दिन बिहान याकूब चाँडै उठे। उनले त्यस चट्टानलाई उठाए अनि त्यसलाई एक छेऊमा खडा पारेर राखे। तब उनले त्यसमा तेल दले। यस प्रकार उनले त्स चट्टानलाई परमेश्वरलाई स्मरण गराउने स्तम्भ बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","पहिला त्यस ठाउँको नाउँ लूज थियो तर याकूबले त्यसको नाउँ बेतेल राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","तब याकूबले एउटा प्रतिज्ञा गरे। उनले भने, “यदि परमेश्वर मसंगै रहनु भयो अनि म जहाँ जान्छु त्यहाँ मेरो रक्षा गर्नु भयो भने अनि परमेश्वरले मलाई खान भोजन र लगाउन लुगाहरू दिनु भयो भने। ");
INSERT INTO npi2010_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","यदि म आफ्नो बुबाकहाँ सुरक्षित र शान्तिसित फर्किन सकें, यदि परमेश्वरले यी सबै कामहरू मेरो लागि गर्नु भयो भने तब परमप्रभु मेरो परमेश्वर हुनु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","त्यो ठाउँ जहाँ मैले त्यो ढुङ्गा उभ्याएँ परमेश्वरको पवित्र स्थान हुनेछ अनि परमेश्वरले मलाई जे दिनुहुन्छ त्यसको एक दशांश म तपाईंलाई चढाउनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","तब याकूबले आफ्नो यात्रा जारी नै राख्यो। त्यो पूर्व तिरको प्रान्तमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","याकूबले हेर्यो अनि उनले मैदानमा एउटा कूवा देख्यो। त्यहाँ त्यो कूवाको छेउमा तीन बगाल भेडाहरू बसिरहेका थिए। ती भेडाहरूले त्यस कूवामा पानी खान्थे। त्यहाँ एउटा ठूलो ढुङ्गाले त्यो कूवालाई ढाकेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","जब सबै भेडाहरू त्यहाँ भेला हुन्थे गोठालाहरूले त्यो कूवा माथिको ढुङ्गा पल्टाई दिन्थे। त्यसपछि सबै भेडाहरूले पानी खान्थे र फेरि ती गोठालाहरूले त्यो ढुङ्गाले कूवा छोपिदिन्थे। ");
INSERT INTO npi2010_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकूबले त्यस गोठालाहरूलाई भने, “हे मेराभाइ हो, तिमीहरू कहाँका हौ?” तिनीहरूले उत्तर दिए, “हामी हारानका हौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","फेरि याकूबले भने, “के तिमीहरूले नाहोरको लाबानलाई चिन्छौ?” गोठालाहरूले उत्तर दिए, “अँ हामी तिनलाई चिन्छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","तब याकूबले भने, “तिनी कुशलै त होलान्?” तिनीहरूले भने, “तिनी कुशलै छन्। अनि सबै कुराहरू राम्रै छन्। हेर, उनकी छोरी राहेल भेडाहरू लिएर आइरहेकीछिन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकूबले भने, “हेर, अहिले दिउँसो नै छ अनि घाम डुब्नु अझै घेरै समय बाँकी नै छ। अझै, रात पर्छ भनेर तिम्रो लागि भेडाहरू जम्मा गर्ने समय भएको छैन। यसर्थ ती भेडाहरूलाई पानी खान देऊ अनि चर्न मैदानमा जान देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","तर ती भेडा गोठालाहरूले भने, “जबसम्म सबै भेडाहरू भेला हुँदैनन् हामी त्यसो गर्न सक्तैनौं। भेडाहरू भेला भइसकेपछि मात्र हामी कूवाबाट ढुङ्गा पल्टाउँछौं र भेडाहरूले पानी खान्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकूब भेडा गोठालाहरूसित कुरा गरीरहेको बेला नै राहेल आफ्नो बाबुका भेडाहरू लिएर आई। (आफ्नो बाबुका भेडाहरूको हेरचाह गर्ने काम राहेलको थियो।) ");
INSERT INTO npi2010_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","राहेल लाबानको छोरी थिइन्। रिबेका लाबानकी बहिनी अनि याकूबकी आमा थिइन्। जब याकूबले राहेललाई देख्यो, तिनी गए अनि कूवाबाट ढुङ्गा पल्टाएर भेडाहरूलाई पानी खान दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","त्यसपछि उनले राहेललाई चुम्बन गर्यो अनि रोयो। ");
INSERT INTO npi2010_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकूबले उसलाई बतायो त्यो उसको बाबुको परिवारबाट जन्मेको हो। उनले आफूलाई रिबेकाको छोरो भनी चिनायो। यसर्थ राहेल घरतिर दौडिन् अनि आफ्नो बाबुलाई भनिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","लाबानले आफ्नी बहिनीको छोरोको विषयमा सुने। यसर्थ लाबान उसलाई भेट्न हिंड्‌यो। लाबानले उसलाई जोडले अँगाल्यो, चुम्यो अनि घरमा लिएर गए। याकूबले के भएको थियो सम्पूर्ण घटनाको विवरण दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","त्यसपछि लाबानले भने, “यो आश्चर्य हो! तिमी हाम्रो आफ्नै परिवारको रहेछौ।” यसकारण याकूब त्यहाँ एक महिना बस्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","एक दिन लाबानले याकूबलाई भने, “तिमी मेरो घरमा बिना तलब काम गर्न उचित होइन कारण तिमी आफन्त हौ, तर कमारा होइनौ मैले तिमीलाई के दिनु पर्छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानकी दुईवटी छोरीहरू थिए। जेठीको नाउँ लेआ अनि सानी चाँहि राहेल थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआका आँखाहरू सुन्दर थिए तर राहेल मनमोहक र सुन्दरी थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूबले राहेललाई माया गर्दथ्यो। याकूबले लाबानलाई भने, “म सात वर्ष सम्म तपाईंको सेवा गर्छु यदि तपाईंले आफ्नी छोरी राहेलसित मेरो विवाह गर्ने अनुमति दिनु भयो भने।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबानले भने, “अरू मानिससित विवाह गर्नुभन्दा तिमीसितै विवाह गर्नु उसको निम्ति राम्रो हुनेछ। यसर्थ मसित बस।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","याकूबले सात वर्षसम्म लाबानको सेवा गर्यो तर उनले राहेललाई अत्यन्तै माया गरेकोले सात वर्ष समय बिताउन केही गाह्रो परेन। ");
INSERT INTO npi2010_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","सात वर्ष सेवा गरेपछि याकूबले लाबानलाई भने, “राहेललाई मलाई दिनुहोस् म उसलाई विवाह गर्न सकुँ। मैले तपाईंलाई गर्नु पर्ने सेवाको अवधि-शेष भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","यसर्थ त्यस ठाउँको सबै मानिसहरूको लागि लाबानले भोज गराए अनि ");
INSERT INTO npi2010_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","त्यस रात उनकी छोरी लेआ याकूबलाई दिए। याकूब र लेआले त्यस रात सहवास गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(लाबानले आफ्नी कमारी जिल्पालाई आफ्नी छोरी लेआकी कमारीको रूपमा दिए।) ");
INSERT INTO npi2010_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","बिहान याकूबले चाल पायो राती ऊसित सुत्ने स्त्री लेआ थिइन्। याकूबले लाबानलाई भने, “तपाईंले मलाई किन झुक्याउनु भयो। मैले तपाईंको धेरै सेवा गरें जसले गर्दा म राहेललाई विवाह गर्न पाऊँ। तपाईंले मलाई किन झुक्याउनु भयो?” ");
INSERT INTO npi2010_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबानले भने, “हाम्रो देशमा हामी जेठी छोरीको विवाह नभई सानीको विवाह हुन दिंदैनौं। ");
INSERT INTO npi2010_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","विवाह-भोजको हप्ताहभरि उसित बस अनि तिमीलाई राहेलसित पनि विवाह गर्ने अनुमति दिन्छु। तर तिमीले अझै सात वर्ष मेरो सेवा गर्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","यसर्थ याकूबले त्यसै गरे र एक हप्ता पूरा भयो। तब लाबानले आफ्नो छोरी राहेललाई पनि याकूबको पत्नीको रूपमा दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(लाबानले आफ्नी कमारी बिलहालाई आफ्नी छोरी राहेलकी कमारीको रूपमा दिए)। ");
INSERT INTO npi2010_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","यसर्थ याकूबले राहेलसित पनि सहवास गरे अनि उनले लेआलाई भन्दाराहेललाई बढी प्रेम गर्थे उनले लाबानको निम्ति अरू सात साल सेवा गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","परमप्रभुले जान्नु हुन्थयो, याकूबले राहेललाई लेआ भन्दाबेशी माया गर्थे। यसर्थ परमप्रभुले लेआलाई एउटा नानी जन्माउन सक्ने योग्य बनाउनु भयो तर राहेल बाँझी रहिन्। ");
INSERT INTO npi2010_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआले छोरो जन्माई अनि त्यसको नाउँ रूबेन राखीन्। लेआले छोरोको नाउँ यस्तो राखी किनभने उनले भनीन्, “मेरो दुःख परमप्रभुले देख्नु भएको छ। मेरा पतिले मलाई प्रेम गर्दैनन्, यसर्थ, अब हुनुसक्छ उनले मलाई प्रेम गर्नेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","लेआ फेरि गर्भवती भइन् अनि अर्को छोरो जन्माईन्। उनले त्यस छोरोको नाउँ शिमोन राखीन्। लेआले भनीन्, “परमप्रभुले सुन्नु भयो मैले प्रेम पाइन, यसर्थ उहाँले यो छोरो दिनुभयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","लेआ फेरि गर्भवती भई र छोरो जन्माई। उनले यो छोरोको नाउँ लेवी राखी। लेआले भनी, “अब, निश्चय मेरा पतिले मलाई प्रेम गर्नेछन्। मैले तिनलाई तीनवटा छोराहरू दिएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","त्यसपछि लेआले अझ अर्को छोरो जन्माई र उसको नाउँ यहूदा राखी। लेआले चौथो छोरोको नाउँ यहूदा राखीन् कारण उनले भनीन्, “अब म परमप्रभुको प्रशंसा गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","राहेलले अनुभव गरिन् उनले याकूबको निम्ति कुनै नानी जन्माउनु सकेकी थिइन। यसर्थ ऊ आफ्ना दिदीसित डाही भई। यसर्थ राहेलले याकूबलाई भनी, “मलाई नानी दिनु होस् नत्र म मर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","याकूब राहेलसित साह्रै क्रोधित भयो। उनले भन्यो, “म परमेश्वर होइन। परमेश्वर नै एकजना हुनहुन्छ जसले तिमीलाई बाँझी बनाउनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","त्यसपछि राहेलले भनी, “तिमीले मेरी कमारी बिल्हालाई राख्न सक्छौ। त्यससित सहवास गर्नुहोस् अनि उनले मेरो निम्ति नानी जन्माउनेछे। तब उनले गर्दा म आमा हुन सक्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","यसर्थ राहेलले आफ्नी कमारी बिल्हा आफ्नो पतिलाई दिइ। याकूबले त्यस कमारीसित सहवास गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिल्हा गर्भवती भइन् अनि याकूबको निम्ति एउटा छोरो जन्माई। ");
INSERT INTO npi2010_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","राहेलले भनी, “परमेश्वरले मेरो प्रार्थना सुन्नु भयो र उहाँले मलाई एउटा छोरो दिने निर्णय गर्नु भयो।” यसर्थ राहेलले छोरोको नाउँ दान राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","बिल्हा फेरि गर्भवती भइन् अनि याकूबको अर्को छोरो जन्माई। ");
INSERT INTO npi2010_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","राहेलले भनीन्, “मैले मेरी दिदीसित साह्रै कठिन प्रतियोगिता गर्नु पर्यो अनि अन्तमा मैले उसलाई जितें।” यसर्थ उनले त्यस छोरोको नाउँ नप्तालि राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","लेआले थाहा पाइन, उनले नानी पाउन छोडिन। यसर्थ उनले याकूबलाई आफ्नी नोकर्नी जिल्पा दिइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","तब जिल्पाले एउटा छोरो जन्माई। ");
INSERT INTO npi2010_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लेआले भनीन्, “म भाग्यमानी हुँ।” यसर्थ उनले छोरोको नाउँ गाद राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लेआकी कमारी जिल्पाले फेरि अर्को छोरो पाई। ");
INSERT INTO npi2010_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","लेआले भनीन्, “म एकदमै खुशी छु, अब स्त्री जातिहरूले मलाई सुखी भन्नेछन्।” यसर्थ उनले त्यस छोरोको नाउँ आशेर राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहूँको फसल काट्ने समयमा रूबेन खेतमा गए अनि विशेष प्रकारको फूलहरू पायो। उसले ती फूलहरू आफ्नी आमा लेआका लागि ल्यायो। तर राहेलले लेआलाई भनी, “तिम्रो छोरोले ल्याएको केही फूलहरू मलाई देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लेआले भनीन्, “तिमीले पहिले मेरा पतिलाई लगिसकेकी छौ, अब मेरो छोरोको विशेष फूलहरू लिने चेष्टा गरिरहेकी छौ।” तर राहेलले उत्तर दिई, “यदि तिमीले मलाई तिम्रो छोरोले ल्याएको विशेष फूलहरू दियौ भने तिमी आज राती याकूबसित सुत्न सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","त्यस राती याकूब खेतबाट घरमा फर्कियो। लेआले उसलाई देखिन् अनि भेट्न गइन्। उनले भनिन्, “तपाईं आज राती मसित सुत्नु पर्छ। म तपाईंसित सुत्नु पूर्ण तयार भएकी छु। मैले मेरो छोराले ल्याएको फूलहरू राहेललाई दिएकी छु।” यसर्थ याकूब त्यस राती लेआसित सुते। ");
INSERT INTO npi2010_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","तब परमेश्वरले लेआलाई फेरि गर्भवती हुन दिनु भयो, उनले पाँचौं छोरो जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लेआले भनिन्, “परमेश्वरले मलाई इनाम दिनु भएकोछ कारण मैले मेरा पतिलाई आफ्नी कमारी दिएकीछु।” यसर्थ लेआले आफ्नो त्यो छोरोको नाउँ इस्साखार राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लेआ फेरि गर्भवती भइन् अनि छैटौं छोरो जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","लेआले भनिन्, “परमेश्वरले मलाई एकदम अमूल्य उपहार दिनु भयो। अब निश्चय याकूबले मलाई ग्रहण गर्नेछन् कारण उनलाई मैले छवटा छोराहरू जन्माइदिएँ।” यसर्थ उनले त्यस छोरोको नाउँ जबूलून राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","पछि लेआले एउटी छोरी जन्माई अनि त्यस छोरीको नाउँ दीना राखीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","त्यसपछि परमेश्वरले राहेलको प्रार्थना सुन्नु भयो अनि राहेललाई नानीहरू जन्माउनु सम्भव गराई दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","राहेल गर्भवती भई अनि एउटा छोरो जन्माई। राहेलले भनिन्, “परमेश्वरले मेरो अपमान हटाइ दिनुभयो अनि मलाई एउटा छोरो दिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","यसैकारण राहेले उसको नाउँ यूसुफ यसो भन्दै राखीन, “परमेश्वरले मलाई अझै अर्को छोरो दिऊन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","यूसुफ जन्मेपछि याकूबले लाबानलाई भन्यो, “अब मलाई आफ्नै घर फर्की जान दिनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","मेरा नानीहरू र पत्नीहरू दिनु होस, तपाईंको निम्ति चौध वर्षसम्म कठोर सेवा गरेर तिनीहरूलाई पाएको हुँ। तपाईं जान्नु हुन्छ मैले तपाईंको निम्ति राम्रो सेवा गरेकोछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबानले उसलाई भने, “मलाई केही भन्न देऊ। म जान्दछु तिमीले गर्दा नै परमेश्वरले मलाई आशीर्वाद दिनु भएकोछ। ");
INSERT INTO npi2010_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","भन मैले तिमीलाई के दिनु पर्ने अनि म तिमीलाई त्यो दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूबले उत्तर दियो, “तिमीलाई थाहा छ मैले तिम्रो निम्ति कठोर परिश्रम गरेकोछु। मैले हेरचाह गरेकोले तिम्रा पशुहरू पनि बढेका छन् अनि यो असल भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","म आउँदा तिमीसित अलिकति मात्र थियो। तर अहिले घेरै भएका छन्। मैले जे पनि गरे तपाईंको निम्ति, त्यसमा परमप्रभुले आशीर्वाद दिनु भएकोछ। अब आफ्नो निम्ति मैले केही गर्नु पर्ने समय आएको छ र मैले आफ्नो घर बनाउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","लाबानले सोध्यो, “तब मैले तिमीलाई के दिनु पर्ने?” याकूबले उत्तर दियो, “तपाईंले मलाई केही दिनु पर्दैन। मैले गरेको कामको निम्ति तपाईंले मलाई ज्याला देऊ म चाहन्छु खाली यही एउटा कुरा मलाई देऊ। म फर्केर जान्छु अनि तपाईंका भेडाहरूको हेरचाह गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","तर मलाई आज तपाईंका सबै भेडाहरूको माझबाट जान देऊ अनि थोप्ले या सिंगारे प्रत्येक थुमा मलाई लान देऊ, कालो नयाँ बाख्रा अनि प्रत्येक थोप्ले अनि सिंगारे बाख्रा लान देऊ। यही मेरो ज्याला हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","भविष्यमा तपाईंले चाल पाउनु हुनेछ म इमानदार छु। तपाईं मेरो भेडाहरू हेर्न आउन सक्नुहुन्छ। यदि कोही भेडा अथवा बाख्रा थोप्ले अथवा सिंगारे नभए तपाईं जान्न सक्नुहुन्छ ती मैले चोरेको हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबानले उत्तर दिए, “तिम्रो कुरा म मान्छु। तिमीले जे भन्यौ हामी त्यही गर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","अनि यसैकारण त्यस दिन लाबानले सबै टाटेपाटे बाख्रा र बाख्रीहरू ती सबै सेतो टाटा भएका अनि प्रत्येक काला भेडाका पाठाहरू आफ्नो बथानबाट निकाले। उनले आफ्नो छोरोलाई तिनीहरूलाई हेरचाह गर्नु भने। ");
INSERT INTO npi2010_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","यसर्थ छोरो चाँहिले सबै दाग भएका भेडा बाख्राहरू लिएर अर्कै भूमिमा गए। तिनीहरू तीन दिनसम्म यात्रा गरे। याकूब बसे अनि रहेको वस्तुहरूको हेरचाह गरे। तर त्यहाँ थोप्ले तथा कालो भेडा बाख्राहरू कुनै पनि थिएन। ");
INSERT INTO npi2010_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","यसर्थ याकूबले बदाम र पहाडी पिपलका काँचो हाँगाहरू काटेर बोक्रा ताछ्यो जसले गर्दा ती हाँगाहरूमा सेतो धर्काहरू भए। ");
INSERT INTO npi2010_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","याकूबले ती हाँगाहरू पानी भएको ठाउँमा भेडा-बाख्राहरूको अघि राख्यो। जब पशुहरू पानी पिउन आए तब त्यहाँ तिनीहरूले प्रजनन क्रीडा पनि गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","जब ती पशुहरू ती हाँगाहरूको सामुन्ने प्रजनन क्रीडामा लागे तब तिनीहरूले जो पाठाहरू जन्माए कालो, सिंगारे अनि थोप्ले थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूबले ती कालो, सिंगारे अनि थोप्ले पशुहरूलाई अरूबाट बेग्लै राख्यो। उनले यसरी आफ्नो पशुहरू लाबानको पशुहरूबाट बेग्लै गर्यो अनि तिनीहरूलाई लाबानको भेडा बाख्राहरूसित मिसिन दिएन। ");
INSERT INTO npi2010_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","जहिले पनि कुनै स्वास्थ्य भेडाहरू प्रजनन क्रीडामा लाग्थे तब याकूबले ती दागवाला हाँगाहरू तिनीहरूको नजरअघि राखि दिन्थ्यो। ती हाँगाहरूको सामुन्ने ती भेडा बाख्राले प्रजनन् क्रीडा गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","तर जब कमजोर भेडा बाख्राहरू प्रजनन् क्रीडामा लाग्थे तब याकूबले ती हाँगाहरू तिनीहरूको सामुन्नेमा राख्दैनथ्यो। यसरी कमजोर पशुहरूबाट जन्मेका पाठाहरू लाबानको हुन्थे। स्वास्थ्य पशुहरूबाट जन्मेका पाठाहरू सबै याकूबको हुन्थे। ");
INSERT INTO npi2010_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","यसरी याकूब धेरै धनी भयो। उसित धेरै भेडा बाख्रा, धेरै नोकरहरू ऊँट र गधाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","एकदिन याकूबले लाबानको छोराहरू कुरा गरिरहेको सुन्यो। तिनीहरूले भने, “हाम्रा बाबुसित भएको सम्पत्तिहरू याकूबले सबै लग्यो। याकूब धनी मानिस भयो। अनि उनले हाम्रा बाबुको सबै सम्पत्तिहरू लग्यो।” ");
INSERT INTO npi2010_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","याकूबले तब महस्‌स गरे लाबानसित उसको सम्बन्ध निश्चय नै पहिले जस्तो छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","परमप्रभुले याकूबलाई भन्नुभयो, “तिम्रा पुर्खाहरू जहाँ थिए, त्यही तिम्रो भूमिमा जाऊ म तिमीसंग हुनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","यसर्थ याकूबले राहेल र लेआलाई भेडा बाख्राहरू राख्ने खेतमा भेट्नु भन्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","राहेल र लेआलाई याकूबले भने, “मैले थाहा पाएँ तिम्रा बाबु मसित रिसाएका छन्। तिनी मसित संधै पहिले जस्तो राम्रो कुरा गर्दैनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","तिमीहरू दुवैजनालाई थाहा छ तिम्रा बाबुको निम्ति त्यति मेहनत गरें जति मैले गर्न सक्थें। ");
INSERT INTO npi2010_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","तर तिमीहरूका बाबुले मलाई धोका दिए। उनले मेरो ज्याला दश पल्ट बद्ली गरे। तर यी सबै समयमा परमेश्वरले मलाई उनको धोकाबाट बचाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“एक पल्ट लाबानले भने, ‘तिमीले थोप्ले जति सबै बाख्राहरू राख्न सक्छौ, यही तिम्रो ज्याला हुनेछ।’ जब उनले त्यसो भने, तब सबै पशुहरूले सिंगारे पाठाहरू बियाए। यसर्थ ती सबै मेरा थिए। तर लाबानले भने, ‘म थोप्ले बाख्राहरू राख्छु। सबै सिंगारे बाख्राहरू तिमी राख्न सक्छौ। त्यही तिम्रो ज्याला हुनेछ।’ तिनले त्यसो भनेपछि सबै पशुहरूले सिंगारे पाठाहरू बियाए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","यसर्थ परमेश्वरले सबै पशुहरू तिम्रो बाबुबाट लिएर मलाई दिनु भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“पशुहरू जब प्रजनन क्रीडामा थिए मैले एउटा सपना देखें। मैले देखें ती सबै नर पशुहरू जो प्रजनन क्रीडामा लागेका थिए तिनीहरू मात्र थोप्ले र सिंगारे थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","परमेश्वरका स्वर्गदूतले सपनामा मसित कुरा गरे। स्वर्गदूतले भने, ‘याकूब।’ “मैले भनें, ‘हजुर।’ ");
INSERT INTO npi2010_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“त्यो स्वर्गदूतले भने, ‘हेर, खाली थोप्ले र सिंगारे बाख्राहरू मात्र प्रजनन क्रीडामा छन्। म यस्तै गराउँदै छु। लाबान तिमीसित सबै भूल काम गरिरहेका छन्। सबै नयाँ जन्मेका पाठा-पाठीहरू तिम्रा हुन् भनेर म यस्तो गरिरहेको छु। ");
INSERT INTO npi2010_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","म तिमी कहाँ बेतेलमा आउने परमेश्वर हुँ। त्यस ठाउँमा तिमीले एउटा वेदी बनायौ। तिमीले त्यस वेदीमा भद्राक्षको तेलले अभिषेक गर्यौ अनि त्यस ठाउँमा तिमीले मसित भाकल गरेका थियौ। अब म चाहन्छु तिमी आफ्नो भूमि जहाँ तिमी जन्मेका थियो त्यहाँ जान तयार होऊ।’” ");
INSERT INTO npi2010_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","15","राहेल अनि लेआले याकूबलाई उत्तर दिए, “हामीले हाम्रो बुबाबाट उनको मृत्युपछि पाउने केही छैन। उनले हामीसित पराइ जस्तो व्यवहार गरे। उनले हामीलाई तिमीकहाँ बेचिदिए। अनि त्यो बाहेक उनले पैसाको प्रत्येक भाग खर्च गरे जो हाम्रो कारण पाएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","परमेश्वरले हाम्रो बाबुबाट सबै सम्पति लिनु भयो अनि अहिले त्यो हाम्रो र हाम्रो नानीहरूको निम्ति भयो। यसर्थ तिमीले त्यही गर्नु पर्छ, जुन परमेश्वरले गर्नु भन्नु हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","यसर्थ याकूब आफ्नो यात्राको निम्ति तयार भयो। उनले आफ्नो पत्नीहरू र नानीहरूलाई ऊँटमाथि राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","तब तिनीहरूले कनान भूमिमा जहाँ उसको बाबु बस्ने गर्दथिए त्यहाँबाट फर्कनको निम्ति यात्रा शुरू गरे। याकूब आफ्ना सबै पशुहरु तिनीहरूको अघि अघि हिंड्‌यो। पद्दनराममा हुँदा जे जति तिनले हासिल गरेका थिए प्रत्येक चीज उनले लग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","त्यस समय लाबान आफ्नो भेडाहरूको ऊन काट्न गएका थिए। जब ती गएका थिए, राहेल उनको घरमा गइन् अनि आफ्नो बाबुको झुटो देवता चोरेर ल्याईन्। ");
INSERT INTO npi2010_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकूबले अरामी लाबानलाई धोका दिए। उनले आफू जाने कुरो लाबानलाई भनेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","याकूबले आफ्नो जहान परिवार र आफ्ना सबै चीज बीजहरू लग्यो अनि चाँडै हिंड्‌यो। तिनीहरूले यूफ्रेटिस नदी पार गरी गिलादको पहाडी भूमितिर यात्रा गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","तीन दिनपछि मात्र याकूब भागेको कुरा लाबानले थाहा पाए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","यसैकारण लाबानले आफ्ना मानिसहरू भेला गरे अनि याकूबलाई पछ्याउन शुरू गरे। सात दिनपछि लाबानले याकूबलाई गिलादको पहाडी क्षेत्रमा भेटे। ");
INSERT INTO npi2010_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","त्यस रात परमेश्वर लाबानको सपनामा देखा पर्नु भयो। परमेश्वरले भन्नुभयो, “होशियार हुनु, याकूबलाई जे भन्छौ प्रत्येक शब्दको निम्ति होशियार हुनु।” ");
INSERT INTO npi2010_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","अर्को दिन बिहानै लाबानले याकूबलाई पक्रिए। याकूबले पर्वतमाथि आफ्नो पाल लगाएको थियो। यसर्थ लाबान अनि उनका मानिसहरूले पनि गिलादको पहाडी ठाउँमा पाल हाले। ");
INSERT INTO npi2010_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबानले याकूबलाई भने, “मलाई किन धोका दिइस्? मेरो छोरीहरूलाई तैंले लडाइँमा कैदी जस्तो बनाएर किन लगिस्? ");
INSERT INTO npi2010_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","मलाई नभनी किन भागिस्? यदि मलाई भनेको भए म भोज गराउने थिएँ। त्यहाँ नाच गान हुनेथियो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","तैंले मेरा नातिहरूलाई म्वाइँ खान अनि छोरीहरूलाई बिदाइगर्न पनि दिइनस्। यो सब गरेर तँ साह्रै मूर्ख भइस्। ");
INSERT INTO npi2010_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","वास्तवमा तँलाईं चोट पुर्याउने शक्ति मसँग छ, तर हिजो राती तेरो बाबुको परमेश्वर मेरो सपनामा देखा पर्नु भयो। कुनै प्रकारले पनि तँलाईं चोट नपुर्याउनु भनी मलाई चेतावनी दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","म जान्दछु तँ तेरो घर जान चाहन्छस र त्यसकै निम्ति तँ हिंडिस्। तर मेरो घरबाट देवताहरू किन चोरिस्?” ");
INSERT INTO npi2010_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूबले भन्यो, “म डराएको हुनाले तिमीलाई नभनी म हिंडे। मैले सोचे तिमीले तिम्री छोरीहरू मबाट खोस्नेछौ, ");
INSERT INTO npi2010_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","तर मैले तिम्रा देवताहरू चोरेको छैन। यहाँ मसित हुनेहरू जोसित तिम्रो देवताहरू पाइन्छन् त्यस मानिसको हत्या गरिनेछ। तिम्रा मानिसहरू मेरा गवाहीहरू हुनेछन्। तिमीले तिम्रा चीजहरू तलाश गर्न सक्छौ र यदि तिम्रो केही पाइयो भने लान सक्छौ।” (राहेलले लाबानको घरबाट देवताहरू चोरी ल्याएको याकूबलाई थाहा थिएन)। ");
INSERT INTO npi2010_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","लाबान याकूबको छाउनीभित्र गएर खोज-तलाश गरे। उनले पहिले याकूबको अनि लेआको पालको तलाश गरे। त्यसपछि दुइ कमारी आइमाईहरू बसेका पालको तलाश गरे। तर ती पालहरूमा उनले खोजेका देवताहरू पाइएनन्। त्यसपछि लाबान राहेलको पालमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेलले ती देवताहरू ऊँटको जीनमुनि लुकाएकी थिइन् अनि त्यसैमाथि बसेकी थिइन्। लाबानले सम्पूर्ण पाल चहारे र उनले देवताहरू भेट्न सकेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","अनि राहेलले आफ्नो बाबुसित भनिन्, “बुबा मसित नरिसाउनु है, म तपाईंको अघि उभिन असमर्थ छु कारण अहिले मेरो मासिक धर्म चलिरहेको छ।” यसर्थ लाबानले पालमा खोजी गरे तर उनले देवताहरू कही पाएनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","तब याकूब अत्यन्तै क्रोधित भएर भने, “मैले के कसुर गरेको छु? मैले कुन कानून भङ्ग गरेको छु? मलाई खेद्ने र रोक्ने अधिकार तिमीले कसरी पायौ? ");
INSERT INTO npi2010_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","मेरो माल समान जे जति छ, सब तलाश गर्यौ तर कहीं केही पाएनौ, जो तिम्रो हो। यदि तिमीले केही पायौ भने तब मलाई देखाऊ। यहाँ राख मेरा मानिसहरूले देख्न सकून। मेरा मानिसहरूले निर्णय लिन सकून् हामी माझ को सही छ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","मैले बीस वर्ष तिम्रो सेवा गरें। मेरो सेवाकालमा तिम्रो कुनै पनि भेडी र अरू बाख्रीको गर्भपात भएन। अनि मैले तपाईंका भेडोहरूबाट कुनैलाई खाइनँ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जहिले पनि जंङ्गली जनावरले कुनै भेडा अनि बाख्रा खाए, त्यो जंङ्गली जनावारले मारेको भेडा अथवा बाख्रको अवशेष मात्रै तिमीकहाँ कहिल्यै ल्याईन। म सँधै तिमीले मलाई मागेको पूरा दाम तिरें। म दिन रात लुटिएको थिएँ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","दिउँसोको घामले मेरो शक्ति नष्ट गर्यो अनि रातको चिसोले निद्रा लग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","बीस वर्षसम्म कमारा झैं तिम्रो सेवा गरें। पहिलो चौध वर्ष तिम्री दुइवटी छोरीहरूको निम्ति अनि पछिको छ वर्ष तिम्रो वस्तुहरू पाउनको निम्ति खटें। अनि त्यस समयमा तिमीले मेरो ज्याला दश पल्ट हेरफेर गर्यौ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","तर मेरा पुर्खाहरूका परमेश्वर, अब्राहामका परमेश्वर अनि इसहाकको परमेश्वरको डर मसित थियो। यदि परमेश्वर मसित नहुनु भएको भए तिमीले मलाई रित्तो हात फर्काइ दिनेथ्यौ। मैले भोगेको कष्ट परमेश्वरले देख्नु भयो, मैले गरेको काम परमेश्वरले देख्नु भयो, अनि हिजो राती परमेश्वरले प्रमाणित गर्नु भयो कि म सही छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबानले याकूबलाई भने, “यी स्त्रीहरू मेरी छोरीहरू हुन्। यी नानीहरू मेरा हुन्। अनि यी पशुहरू सब मेरा हुन्। यहाँ तिमी जे पनि देख्छौ सबै मेरो हुन्। तर म मेरी छोरीहरू र नानीहरूको विषयमा केही गर्न सक्तिनँ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","यसर्थ म तिमीसित एक सम्झौता गर्न तयार छु। हामीबीच सम्झौता भएको प्रमाणको रूपमा ढुङ्गाको एउटा थुप्रो बनाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","उनले सम्झौता गरेको हो भनी देखाउन याकूबले एउटा ठूलो ढुङ्गा ल्याएर त्यहाँ राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","उनले आफ्नो मानिसहरूलाई केही ढुङ्गाहरू ल्याएर थुपार्न लगायो। तब तिनीहरूले त्यो ढुङ्गाको थुप्रो नजिक बसेर खाए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबानले त्यस ठाउँको नाउँ “यर्गसहदूता” राखे। तर याकूबले त्यस ठाउँको नाउँ गलेद राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबानले याकूबलाई भने, “यो ढुङ्गाको थुप्रोले हामी दुवैलाई हामीबीचको ‘सम्झौता’ सम्झना गराउनमा सहायता गर्नेछ।” यस कारण उसले त्यस ठाँउको नाउँ गलेद राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","लाबानले भने, “हामी एक अर्कामा छुट्टीदा परमेश्वरले हामीलाई हेरून्।” यसकारण त्यस खाँमोको नाउँ मिस्पा राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","त्यपछि लाबानले भने, “यदि मेरी छोरीहरूलाई कतै चोट पार्यौ भने, याद राख, परमेश्वरले तिमीलाई सजाय दिनु हुनेछ। यदि तिमीले अर्की आइमाई विवाह गरे, याद राख परमेश्वरले हेरि रहनु भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","यहाँ यी ढुङ्गाहरू छन् जसले बताउछन् हामीबीच सम्झौता भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ढुङ्गाहरूको थुप्रो र विशेष ढुङ्गाहरूले हामीलाई आफ्नो संन्धि सम्झना गराउन सहायता पुर्याउँछ। तिमीसित लड्न यस ढुङ्गाको पल्लो पटि म कहिल्यै जाने छैन र त्यसरी नै मसित लड्नु तिमी कहिल्यै यो ढुङ्गाबाट यता अघि आउने छैनौं। ");
INSERT INTO npi2010_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","यदि हामीले यो सम्झौता भङ्ग गर्यौं भने अब्राहामका परमेश्वर, नाहोरका परमेश्वर र उनीहरूको पुर्खाहरूका परमेश्वरले हाम्रो न्याय गर्नुहुनेछ।” याकूबका बाबु इसहाकले परमेश्वरलाई “भय” नाउँले बोलाए। यसर्थ याकूबले सम्झौतामा त्यो नाउँ प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","त्यपछि याकूबले एउटा पशु मार्यो र पहाडमा बलिदान स्वरूपमा चढायो अनि उनले आफ्नो पुरूष मानिसहरूलाई भोजमा भाग लिन निम्तो दियो। खाना शेष भएपछि तिनीहरूले त्यस रात त्यही पर्वतमा बिताए। ");
INSERT INTO npi2010_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","अर्को दिन बिहानै लाबानले आफ्नो नाति-नातिनीहरूलाई म्वाइँ खाए अनि छोरीहरूलाई विदा दिए। उनले तिनीहरूलाई आशीर्वाद दिए अनि घरतिर फर्किए। ");
INSERT INTO npi2010_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूबले पनि त्यो ठाउँ छोड्‌यो। जब ऊ यात्रा गरिरहेको थियो उनले परमेश्वरको स्वर्गदूतहरूलाई देख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","जब याकूबले तिनीहरूलाई देख्यो, उसले भन्यो, “यो परमेश्वरको शिविर हो।” यसैकारण उसले त्यस ठाउँको नाउँ महनोम राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकूबको दाज्यू एसाव सईर नाउँको प्रान्तमा बस्दै थियो। त्यो इलाका एदोमको पहाडी भूमिमा थियो। याकूबले एसावकहाँ दूतहरू पठायो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","याकूबले आफ्ना दूतहरूलाई भन्यो, “यी कुराहरू मेरा मालिक एसावलाई भन, ‘तपाईंका सेवक याकूब भन्छन्: म लाबानसँग याति लामो समय सम्म बसिरहेकोछु। ");
INSERT INTO npi2010_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","मसित गाई, गधा, भेडाहरू र नोकर-नोकर्नी छन्। महाशय, तपाईंले हामीलाई ग्रहण गर्नु होस् भनी यो समाचार पठाउँदैछु।’” ");
INSERT INTO npi2010_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ती दूतहरू याकूबकहाँ फर्केर आए अनि भने, “हामी तपाईंका दाज्यू एसावकहाँ गयौं। उनी तपाईंलाई भेट्न चार सय मानिसहरू सहित आउँदैछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","त्यस समाचारले याकूबलाई आतंकित बनायो। उनले आफूसित भएका मानिसहरूलाई दुई भागमा बाँड्यो। उनले गाई-वस्तु, भेडा बाख्राहरू र ऊँटहरू दुई भाग पार्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","याकूबले सोच्यो, “एसाव आएर ध्वंश पारे पनि एक भाग चाँहि भागेर बाँच्न सक्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","याकूबले भने, “हे मेरा पिता अब्राहामका परमेश्वर, मेरा पिता इसहाकका परमेश्वर! परमप्रभु तपाईंले मलाई आफ्नो भूमि र परिवार भएको ठाउँमा जान भन्नुभयो। तपाईंले भन्नुभयो तपाईंले मलाई राम्रो गर्नु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","तपाईं मेरो निम्ति अति दयालु हुनु हुन्छ। अनि तपाईंले मेरो निम्ति धेरै असल कार्यहरू गर्नु भएको छ। म पहिलो चोटी यर्दन नदी पारी यात्रा गर्दा मसँग टेक्ने लट्ठी बाहेक केही थिएन। तर अहिले मसित यति धेरै चीजहरू छन् म ती चीजहरू दुइ भागमा बाँड्न सक्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","म तपाईंसित प्रार्थना गर्छु कृपा गरेर मलाई मेरो दाज्यू एसावबाट बचाउनु होस्। म ऊसित डराएको छु। किनभने ऊ आउँछ अनि मलाई मार्नेछ, उनले नानीहरूको आमा तथा नानीहरू पनि मार्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","तर तपाईं आफैले भन्नुभयो, ‘म निश्चय नै तिम्रो उन्नति गराउने छु अनि तिम्रा सन्तानहरू संख्यामा यति धेरै बनाउने छु तिनीहरू समुद्रको बालुकाका कणभन्दा बढी हुनेछन् अनि तिनीहरूलाई गन्ती गर्न सकिन्न।’” ");
INSERT INTO npi2010_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","अनि याकूबले त्यो रात त्यही बितायो। उनले उसको दाज्यू एसावको निम्ति केही उपहार तयार पार्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","याकूबले दुइ सयवटा बाख्रा, बीसवटा बोका, दुइ सयवटा भेडा, बीसवटा ठूलो भेडा, तीसवटा दुधारू ऊँट माऊहरू बाछाहरू समेत एकतिर छुट्‌यायो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","याकूबले प्रत्येक बथान पशुहरू आफ्नो नोकरहरूलाई दियो। तब उनले नोकरहरूलाई भने, “पशुहरूको प्रत्येक हुललाई छुट्‌याऊ। मभन्दा अघि जाऊ अनि प्रत्येक हुलको बीचमा केही दूरी होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","याकूबले तिनीहरूलाई आदेश दियो। पशुहरूको पहिलो हुलको नोकरलाई उनले भने, “मेरो दाज्यू एसाव जब तेरो अघि आएर सोध्छ, ‘यी कसका पशुहरू हुन्? तँ कहाँ जादैछस्? तँ कसको नोकर होस्?’ ");
INSERT INTO npi2010_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","तैंले उत्तर दिनु ‘यी पशुहरू तपाईंको दास याकूबका हुन्। उनले यी सब पशुहरू आफ्नो मालिक एसावलाई उपहार दिन पठाएका हुन्। याकूब पनि हाम्रोपछि आउँदै हुनुहुन्छ।’” ");
INSERT INTO npi2010_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","याकूबले दोस्रो, तेस्रो नोकरहरू र सबै अरू नोकरहरूलाई पनि यही कुरा गर्नु भनी आज्ञा दियो। उनले भने, “जब तिमीहरूले एसावलाई भेट्छौ तब यही कुरा गर्नु। ");
INSERT INTO npi2010_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","तिमीहरूले भन्ने छौ, ‘यो तपाईंलाई उपहार हो, अनि तपाईंको दास याकूब पनि मानिसहरूको पछि-पछि आउँदैछन्।’” याकूबले सोच्यो, “यदि यी उपहारहरूसंगै मानिसहरूलाई पठाएँ भने हुनसक्छ एसावले मलाई क्षमा गर्ला अनि मलाई स्वीकार गर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","यसकारण उसले पहिला उपहार पठायो अनि ऊ त्यस राती शिविरमा नै बस्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","त्यसपछि राती उठेर उनले त्यो ठाउँ छोड्‌यो। उसले आफूसँग दुइ पत्नी, दुइ कमारी अनि आफ्नो एघारजना छोराहरूलाई लिएर हिंड्‌यो। घाटमा पुगेर याकूबले यब्बोक नदी पार गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","उसले आफ्नो परिवारलाई नदी पारी पठायो अनि ऊसंग भएका प्रत्येक चीज नदी पारी पठायो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","याकूब नदी तर्ने अन्तिम मानिस थियो। तर नदी तर्नुअघि जब याकूब एक्लै थियो, एकजना मानिस आयो अनि ऊसित कुश्ती लड्न थाल्यो। त्यस मानिसले घाम झुल्किञ्जेलसम्म कुश्ती लड्‌यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","त्यस मानिसले थाहा पायो ऊ याकूबलाई जित्नु योग्य छैन। यसैकारण उनले याकूबको नित्मबको खोपिल्टामा हिर्कायो। याकूबको नितम्ब जोर्नीबाट फूस्कियो जब ऊ त्यस मानिससंग कुश्ती लडदै थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","तब त्यस मानिसले याकूबलाई भने, “मलाई जान देऊ। सूर्योदय भइरहेको छ।” तर याकूबले भन्यो, “जबसम्म तिमी मलाई आशीर्वाद दिंदैनौ म तिमीलाई जान दिने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","अनि त्यस मानिसले उसलाई भन्यो, “तिम्रो नाउँ के हो?” अनि याकूबले उत्तर दियो, “मेरो नाउँ याकूब हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","तब त्यो मानिसले भने, “तिम्रो नाउँ याकूब रहने छैन। अब तिम्रो नाउँ ‘इस्राएल’ हुनेछ। म तिमीलाई यो नाउँ दिन्छु किनभने तिमीले परमेश्वर र मानिससित युद्ध गरेका छौ अनि तिनीहरू तिमीलाई जित्न अयोग्य भए।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","तब याकूबले उनलाई सोधे, “दया गरी मलाई तँपाइको नाउँ बताउनु होस्।” तर त्यस मानिसले भने, “तिमीले मेरो नाउँ किन सोध्नु पर्यो?” त्यस बेला त्यस मानिसले याकूबलाई आशीर्वाद दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","यसर्थ याकूबले त्यस ठाउँको नाउँ पनीएल राख्यो। याकूबले भन्यो, “मैले यस ठाउँमा परमेश्वरलाई मुखा-मुख देखेको थिएँ तर अझै मेरो जीवन सुरक्षित थियो।” ");
INSERT INTO npi2010_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","उनले जब त्यो ठाऊँ छोड्यो, सूर्य उदायो। याकूब आफ्नो खुट्टाले गर्दा खोल्च्यङ्ग-खोल्च्यङ्ग गर्दै हिड्दैथ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","यसर्थ आजसम्म पनि इस्राएलका मानिसहरूले कम्मरको जोडनीको मासु खाँदैनन् कारण त्यही मांसपेशी हो जसमा याकूबलाई चोट लागेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूबले हेर्यो अनि एसाव आउँदैगरेको देख्यो। एसाव आइरहेको थियो अनि चार सय मानिसहरू ऊसंग थिए। याकूबले आफ्नो परिवारलाई चार दलमा बाँड्‌यो। लेआ र उसको नानीहरू एउटा दलमा अनि राहेल र यूसुफ अर्को एक दलमा अनि दुइवटी कमारीहरू र तिनीहरूको नानीहरूलाई दुइ दलमा। ");
INSERT INTO npi2010_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","याकूबले कमारीहरू र तिनीहरूका नानीहरूलाई आगाडि राख्यो। त्यसपछि तिनीहरूको पछि उनले लेआ र उसका नानीहरूलाई राख्यो। अनि अन्तमा याकूबले राहेल र यूसुफलाई राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याकूब आफैं तिनीहरूको अगि गए अनि उसको आफ्नो दाज्यूको नजिक नपुगुञ्जेल सम्म सात पल्ट भूइँतिर घोप्ट्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","एसाव उसलाई भेट्न दगुर्यो अनि उसलाई अँगालो हाल्यो। उनले आफ्नो भाइको छातीमा हात राख्यो र उसलाई म्वाइँ खायो अनि तिनीहरू रोए। ");
INSERT INTO npi2010_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","त्यसपछि एसावले हेर्यो अनि स्त्रीहरू र नानीहरूलाई देखेर भने, “तँसित यी को हुन्?” याकूबले भने, “यी नानीहरू परमेश्वरले तिम्रा दासलाई दिनु भएका हो। परमेश्वरले मलाई दया गर्नु भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","त्यसपछि ती दुइ कमारीहरू र नानीहरू एसाव नजिक पुगे अनि उसकोअघि निहुरिए। ");
INSERT INTO npi2010_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","त्यसपछि लेआ र तिनका नानीहरू एसावकहाँ गए अनि तिनलाई निहुरिएर ढोगे। राहेल र यूसुफले पनि त्यसै गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसावले भने, “आउँदा बाटोमा मैले जो मानिसहरू देखें तिनीहरू को हुन? अनि ती सब पशुहरू के को निम्ति हुन्?” याकूबले उत्तर दियो, “तिनीहरू सब तिमीलाई मेरो उपहार हुन जसले गर्दा तिमीले मलाई स्वीकार गर्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","तर एसावले भने, “भाइ, तेंले मलाई केही दिनुपर्दैन कारण मसँग प्रशस्त छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूबले भने, “होइन, म तिमीलाई बिन्ती गर्छु, यदि तिमीले मलाई स्वीकार गर्छौ भने यो मेरो उपहार पनि दया गरी स्वीकार र्गन्‌ पर्छ। तिमीलाई दोस्रो पल्ट देख्न पाउँदा म अत्यन्तै आनन्दित छु। मलाई परमेश्वरले अनुग्रहले मिलाए जस्तै लागेको छ। म अन्यन्तै खुशी छु तिमीले मलाई स्वीकार्यौ। ");
INSERT INTO npi2010_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","यसकारण म बिन्ती गर्छु जो उपहार म दिदैछु त्यो स्वीकार गर। परमेश्वर ममाथि अत्यन्तै दयालु हुनुहुन्छ। मसँग मेरो आवश्यकताभन्दा बेशी छ।” यसरी याकूबले एसावसित उपहार स्वीकार गर्न विन्ती गर्यो। यसकारण एसावले याकूबको उपहार स्वीकार गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","त्यसपछि एसावले भने, “अब तैंले आफ्नो यात्रा जारी राख्न सक्छस र म तँसँगै जानेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","तर याकूबले भने, “तिमीलाई थाहा भयो कि अहिले मेरा नानीहरू एकदमै दुर्बल छन् अनि मैले मेरा भेडाहरू तथा तिनका थुमाहरूको पनि हेरचाह गर्नु पर्छ। यदि मैले तिनीहरूलाई दिउँसो धेरै बेरसम्म हिंडाएँ भने हुन सक्छ ती पशुहरू मर्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","यसकारण तिमीअघि जाऊ र म बिस्तारै-बिस्तारै तिम्रोपछि आउँछु। म पशुहरू अनि तिनीहरूका बच्चाहरू बचाऊँको लागि बिस्तारैसित आउँछु, अनि म अत्यन्तै बिस्तार आउँछु कारण मेरा नानीहरू धेरै नथाकून् म तिमीलाई सेइरमा भेट्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","यसकारण एसावले भने, “तब म मेरा केही साथीहरूलाई तेरो सहायताको निम्ति छोडी दिन्छु।” तर याकूबले भन्यो, “यो तिम्रो विशेष दया हो। तर यसो गर्नु कुनै आवश्यकता छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","यसकारण त्यो दिन एसाव सेइर फर्कियो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","तर याकूब सुक्कोत गए अनि त्यहाँ उनले एउटा घर र पशुहरूको निम्ति सानो खोर बनायो। यही कारणले यस ठाउँको नाउँ सुक्कोत राखियो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","यसर्थ याकूब पद्दन-आरामबाट कनान देशको शेकेमसम्म सुरक्षित यात्रा गरेर आयो। उनले शहरको पूर्वमा आफ्नो पाल हाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","उनले जहाँ आफ्नो पाल हालेको थियो त्यस ठाउँ शकेमको बाबु हमोरको परिवारबाट किनेको थियो। त्यसको निम्ति याकूबले एक सय चाँदीका सिक्का दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","त्यहाँ उसले एउटा वेदी बनायो अनि त्यसको नाउँ “एल इस्राएलका परमेश्वर राख्यो।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","दीना याकूब र लेआकी छोरी थिइन्। एक दिन दीना त्यस देशकी स्त्रीहरू हेर्न बाहिर गइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","त्यस देशका राजा हामोरका छोरा शकेमले दीनालाई देख्यो। उसले उनलाई पक्रेर उनीसित बलात्कार गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","शकेम दीनासित प्रेम गर्न थाल्यो अनि उनीसित विवाह गर्ने इच्छा गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","शकेमले आफ्नो बाबुलाई भने, “दया गरी यस केटीलाई हासिल गर्नु होस् म यससित विवाह गर्नु सकूँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","याकूबले थाहा पायो शकेमले उसकी छोरीसित खुबै नराम्रो व्यवहार गर्यो। तर याकूबका सबै छोराहरू गाई-वस्तुहरूसित मैदानमा थिए। यसर्थ तिनीहरू नफर्कुञ्जेल केही गरेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","त्यस समय शकेमका बाबु हमोर याकूबसित कुरा गर्न गए। ");
INSERT INTO npi2010_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","जब याकूबका छोराहरूले यस बारे सुने तिनीहरू खेतबाट आए। तिनीहरू उत्तेजित भएर धेरै रिसाए किनभने शकेमले यस्तो कामगरेका थियो जो इस्राएलमा गर्नु हुँदैन थियो। शकेमको घृणात्मक कार्य सुनेर सबै दाज्यू-भाइहरू खेतबाट बाहिर निस्किए। ");
INSERT INTO npi2010_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","तर हमोरले ती दाज्यू-भाइहरूसित कुरा गर्यो। उनले भने, “मेरो छोरो शकेमले दीनालाई खुबै चाहन्छ। दया गरी उसलाई विवाह गर्न दिनुहोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","यस विवाहले बुझाउँछ हामीमाझ एउटा विशेष सम्झौता भएको छ। त्यसपछि हाम्रा मानिसहरूले तिमीहरूका छोरीहरू विवाह गर्न सक्छन् अनि त्यसरी नै तिम्रा मानिसहरूले हाम्रा छोरीहरू विवाह गर्न सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","तिमीहरू हामीसितै यसै भूमिमा बस्न सक्छौ। तिमीहरू जमीनको मालिक हुन सक्छौ र स्वतत्र रूपले व्यापार गर्न सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शकेमले पनि याकूब अनि तिनका छोराहरूसित कुरा गर्यो। उनले भने, “दया गरी मलाई ग्रहण गर्नु होस् अनि तपाईहरूले भनेका कुरा म जेपनि गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","यदि तपाईहरूले दीनालाई मसित विवाह गर्न दिनु भयो भने म तपाईहरूले मागेको उपहार दिनेछु। तपाईहरू जे चाहनु हुन्छ त्यही दिनेछु तर मलाई दीनासित विवाह गर्न दिनुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","शकेम र उसको बाबु हमोरसित याकूबका छोराहरूले झुटो बोल्ने निर्णय गरे। तिनीहरू अझै पनि बौलाहा जस्तै थिए किनभने शकेमले आफ्नी बहिनी दीनासित साह्रै घिनलाग्दो कुकर्म गरेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","यसर्थ ती दाज्यू-भाइहरूले शकेमलाई भने, “हामी हाम्री बहिनीसित तिमीलाई विवाहको अनुमति दिन सक्तैनौ कारण तिमी अझसम्म खतना गरिएका छैनौ। हाम्री बहिनीको तिमीसित विवाह गर्नु एउटा भूल कर्म हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","तर हामी हाम्री बहिनीसित विवाह गर्न अनुमति दिन सक्छौ यदि तिमीले यो काम गर्यौ भने तिम्रा शहरका प्रत्येक पुरूषहरू हामी जस्तै खतना गरिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","त्यसपछि तिम्रा पुरूषहरूले हामीहरूका छोरी विवाह गर्न सक्छन् अनि हाम्रा पुरूषहरूले पनि तिमीहरूका छोरीसँग विवाह गर्न सक्छन्। तब हामी एक हुनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","यदि खतना गराउन अस्वीकार गरे दीनालाई हामी लैजानेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","यस सम्झौतामा हमोर र शकेम दुवै खुशी भए। ");
INSERT INTO npi2010_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","दीनाका दाज्यूहरूले भनेको कुरामा शकेम साह्रै खुशी भयो। आफ्नो परिवारमा शकेम अति आदरणीय मानिस थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","हमोर र शकेम शहरको समावेश स्थलमा गए। तिनीहरूले शहरवासीहरूसित कुरा गरे र भने, ");
INSERT INTO npi2010_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“यी मानिसहरू हामीसित मैत्रीपूर्ण छन्, तिनीहरूलाई हामीहरूमाझ बस्न अनि व्यापार गर्न दिऊँ। जहाँसम्म भूमिको कुरा छ, हेर, हामी सबैको लागि यो धेरै नै छ। हामी तिनीहरूकी छोरीहरूलाई हाम्री पत्नीहरू बनाऊँ अनि हाम्री छोरीहरूलाई तिनीहरूका छोराहरूसित विवाह गर्न दिऊँ। ");
INSERT INTO npi2010_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","तर एउटा कुरो छ जो हाम्रा सबै मानिसहरूले मान्नु पर्छ। हाम्रा सबै मानिसहरू इस्राएलीहरू जस्तै खतना गराउनु राजी हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","यदि हामीले यसो गरे तिनीहरूका गाई-वस्तुले गर्दा हामी धनी हुनेछौं। यसर्थ हामीले तिनीहरूसित यस्तो सम्झौता गर्नु पर्छ जसले गर्दा तिनीहरू यहाँ हामीसित बस्न सकुन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","सबै मानिसहरू जसले हमोर र शकेमबाट त्यस समावेश स्थलमा ती कुरा सुने, सबैले माने। अनि सबै मानिसहरूको खतना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","तीन दिन पछि खतना गरिएका मानिसहरूको घाउ भयो। याकूबका दुइजना छोरा, शिमोन अनि लेवीले बुझे तिनीहरू दुर्वल भएका छन्। यसर्थ तिनीहरूले शहरमा गए अनि सबै मानिसहरूलाई मारिदिए। ");
INSERT INTO npi2010_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","दीनाका दाज्यूहरू शिमोन र लेवीले हमोर र उसको छोरो शेकमलाई पनि मारे अनि शेकमको घरबाट दीनालाई निकाले अनि लिएर गए। ");
INSERT INTO npi2010_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूबका छोराहरू शहरमा गए अनि त्यहाँ भएको प्रत्येक चीज चोरे। शकेमले तिनीहरूकी बहिनीमाथि गरेको कुरोले तिनीहरूको अझै रीस मरेको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","गधाहरू तथा शहरमा र खेतमा जे जति थिए प्रत्येक चीज लगे। ");
INSERT INTO npi2010_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ती दाज्यू-भाइहरूले तिनीहरूको पत्नी छोरा-छोरी तथा तिनीहरूसँग भएको प्रत्येक चीज लगे। ");
INSERT INTO npi2010_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","तर याकूबले शिमोन र लेवीलाई भने, “तिमीहरूले मलाई साह्रै कष्ट दियौ। यहाँ सबै मानिसहरूले मलाई घृणा गर्नेछन्। सबै कनानी र परिज्जी मानिसहरू मेरो विरूद्धमा हुनेछन्। हामीहरूको संख्या यहाँ कम्ती छ, यदि यहाँका मानिसहरू हामीसित लड्न भेला भए भने हामीहरू ध्वंश हुनेछौ। अनि मसँग भएका सबै हाम्रा मानिसहरू ध्वंश हुनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","तर ती दाज्यू-भाइहरूले भने, “के तिनीहरूले हाम्री बहिनीलाई वेश्या जस्तै व्यवहार गरून्? अहँ, हाम्री बहिनीलाई त्यस्तो व्यवहार गर्नु तिनीहरूको अन्याय थियो।” ");
INSERT INTO npi2010_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","परमेश्वरले याकूबलाई भन्नु भयो, “बेतेल शहरमा जाऊ, त्यहाँ बस अनि पूजा गर्नलाई त्यहाँ एउटा वेदी बनाऊ। ‘एल’ लाई स्मरण गर, ती परमेश्वर जो तिमी दाज्यू एसावदेखि बाँच्नको लागि भाग्दै थियौ, त्यस समय तिमीलाई परमेश्वरले दर्शन दिनु भएको थियो। तिमीले आराधना गर्नको निम्ति त्यहाँ एउटा वेदी बनाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","यसकारण, याकूबले आफ्नो परिवार तथा आफ्ना सबै सेवकहरूलाई भने, “काठ र धातुले बनिएका जे जति झुटा देवताहरू तिमीहरूसित छन् ती सब नष्ट गरिदेऊ। आफूलाई पवित्र बनाऊ अनि सफा लुगाहरू लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","हामीहरू यो ठाउँ छोडेर बेतेल जानेछौ, अनि त्यहाँ आफ्नो परमेश्वरको निम्ति एउटा वेदी बनाउनेछौ। उहाँ मेरो उही परमेश्वर हुनुहुन्छ जसले मेरो प्रत्येक कष्टमा सहायता गर्नुहुन्छ, अनि म जहाँ जान्छु मसँगै हुनुहुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","यसर्थ मानिसहरूसित भएका झुटा देवताहरू तिनीहरूले सबै याकूबलाई दिए। तिनीहरूले आफ्नो कानमा लगाएका कुण्डलहरू पनि याकूबलाई दिए। याकूबले शकेम नाउँको शहरको नजिक एउटा फलाँटको रूखको नजिक ती सब चीजहरू गाडि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","याकूब र तिनका छोराहरूले त्यो ठाउँ छोडे। त्यस ठाउँका मानिसहरूले तिनीहरूलाई लखेटेर मार्न चाहन्थे। तर तिनीहरूले त्यसो गरेनन् किनभने तिनीहरू परमेश्वरसित आत्यन्तै डराएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","यसर्थ याकूब अनि उसका मानिसहरू लूज पुगे। आज लूजलाई बेतेल भनिन्छ। यो कनान भूमिमा पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","याकूबले त्यहाँ एउटा वेदी बनाएर त्यस ठाउँको नाउँ “एल-बेतेल” राख्यो। याकूबले त्यस ठाउँको नाउँ त्यही रोजे कारण जति बेला ऊ आफ्नो दाज्यू देखि भाग्दै थियो परमेश्वरले त्यहीं दर्शन दिनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","रिबेकाकी धाई दबोराह त्यहाँ मरी, तिनीहरूले त्यसलाई बेतेलमा फलाँटको रूखमुनि गाडे। तिनीहरूले त्यस ठाउँको नाउँ अल्लोन बकुत राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकूब जब पद्दनआरामबाट फर्कियो परमेश्वरले फेरि उसलाई दर्शन दिनु भयो। परमेश्वरले याकूबलाई आशीर्वाद दिनुभयो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्वरले याकूबलाई भन्नुभयो, “तिम्रो नाउँ याकूब हो, तर म तिम्रो नाउँ बद्ली गरी दिनेछु। अब उसो तिमीलाई याकूब भनिने छैन र तिम्रो नयाँ नाउँ इस्राएल हुनेछ।” यसर्थ परमेश्वरले उसको नाउँ इस्राएल राख्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","परमेश्वरले उसलाई भन्नुभयो, “म सर्वशक्तिमान परमेश्वर हुँ अनि म तिमीलाई आशीर्वाद दिन्छु। फल्दै-फुल्दै अनि बढदै जाऊ। तिम्रा सन्तानहरूबाट धेरै राष्ट्र अनि राजाहरू बनिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","मैले अब्राहाम र इसहाकलाई विशेष भूमि दिएँ र अब तिमीलाई त्यो भूमि दिनेछु। अनि त्यो भूमि तिमीपछि आउने तिम्रा सन्तानलाई पनि दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","त्यसपछि परमेश्वर त्यहाँबाट जानु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","त्यस ठाउँमा याकूबले एउटा स्मारक ढुङ्गा राख्यो। उनले दाखरस र तेलले अभिषेक गरी त्यस ढुङ्गालाई पवित्र पार्यो। यो ठाउँ एउटा विशेष ठाउँ भयो किनभने यहाँ परमेश्वरले याकूबसित कुरा गर्नु भएको थियो। याकूबले यस ठाउँको नाउँ बेतेल राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","याकूब अनि उसको दलले बेतेल छोडे। तिनीहरू ठीक एप्रात आई पुग्नअघि राहेल प्रसुति वेदना भोग्न थाली। ");
INSERT INTO npi2010_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","तर यसपल्ट राहेललाई सही नसक्नु वेदना भइरहेको थियो। राहेलकी कमारीले हेरि र भनी “नडराऊ राहेल तिमीले अर्को छोरो जन्माउदैछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","छोरो जन्मदा-जन्मदै राहेल मरी। मृत्युअघि आफ्नो त्यस छोरोको नाउँ तिनले बेन-ओनी राखीन्। तर याकूबले उसको नाउँ बिन्यामीन राख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","राहेललाई एप्रात जाने बाटोमा नै गाडियो। (एप्रात नै बेतलेहेम हो)। ");
INSERT INTO npi2010_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","राहेलको सम्मानमा याकूबले उसको चिहानमाथि एउटा खामो उभ्यायो। त्यो खामो अझ पनि त्यही खडा छ। ");
INSERT INTO npi2010_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","त्यसपछि इस्राएलले आफ्नो यात्रा जारी राख्यो। उनले एदेर स्तम्भकै दक्षिणमा आफ्नो पाल हाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","इस्राएल त्यस ठाउँमा छोटो समयको निम्ति बस्यो। जब ऊ त्यहाँ थियो, रूबेन इस्राएलको सेविका बिल्हासित सुत्यो। इस्राएल यो सुनेर साह्रै क्रोधित भए। याकूब (इस्राएल) का बाह्र जना छोराहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआका छोराहरू हुनः रूबेन (याकूबको पहिलो छोरो), शिमोन, लेवी, यहूदा, इस्साकार अनि जबूलून। ");
INSERT INTO npi2010_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलका छोराहरूः यूसुफ र बिन्यामीन। ");
INSERT INTO npi2010_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलकी कमारी बिल्हाबाट जन्मिएका छोराहरू दान र नप्ताली थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआकी कमारी जिल्पाबाट जन्मिएका छोरीहरू गाद र आशेर थिए। यी तिनका नानीहरू तब जन्मिएका थिए जब तिनी पद्दमआराममा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकूब आफ्ना बुबा इसहाककहाँ किर्यतर्बामा (हेब्रोन) गए। यो त्यही ठाउँ हो जहाँ अब्राहाम र इसहाकले बसो-बास गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक एक सय असी वर्ष बाँचे। ");
INSERT INTO npi2010_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","इसहाक जब मरे तिनीहरू अत्यन्त वृद्ध भएका थिए अनि सम्पूर्ण जीवन उपभोग गरे। उसको छोरा एसाव अनि याकूबले तिनलाई तिनका पिताको ठाउँमै गाडे। ");
INSERT INTO npi2010_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसावको पारिवारिक इतिहास यही हो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावले कनानी स्त्रीहरूसित विवाह गरे। तिनीहरू थिएः हित्ती एलोनकी छोरी आदा, अन्नाकी छोरी ओहोलीबामा अनि हिव्वी सिनीकी नातिनी अनि ");
INSERT INTO npi2010_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","बासमत-इश्माएलकी छोरी अनि नबायोतकी बहिनी। ");
INSERT INTO npi2010_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसाव अनि आदाले एलीपज नाउँको छोरो जन्माए। बासमतले रूएल नाउँको छोरो जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अनि ओहोलीबामाका तीन जना छोराहरू थिएः तिनीहरूको नाउँ-यऊश, यालाम अनि कोरह। तिनीहरू एसावका छोराहरू थिए जो कनान भूमिमा जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","याकूब अनि एसावाका परिवारहरू अत्यन्तै विशाल भए जसले गर्दा कनान भूमिको अन्नले तिमीहरूलाई पुग्न असम्भव भयो। यसर्थ एसावले आफ्नो भाइ याकूबलाई छोडेर धेरै टाढा देशमा गए। एसावले आफ्ना सबै चीजहरू आफूसँग लिएर गए। कनानमा हुँदा उनले यी सब चीजहर प्राप्त गरेको थियो। यसर्थ एसावले आफूसंग पत्नीहरू छोराहरू, छोरीहरू, सबै नोकरहरू, पशुहरू लग्यो। एसाव र याकूबको परिवारहरू यति बढदै गए, तिनीहरूलाई एकै ठाउँमा बस्न असम्भव भयो। त्यस भूमिबाट दुइ परिवारहरूलाई जीवन निर्वाह गर्न मुश्किल थियो। तिनीहरूसित धेरै गाई-वस्तुहरू थिए। एसाव पहाडी भूमि सेइरतिर लागे (एसावको नाउँ एदोम अनि सेइर पनि हो।) ");
INSERT INTO npi2010_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","एसाव एदोमी मानिसहरूका पिता थिए। सेईर एदोमको पहाडी भूमिमा बस्ने एसावका परिवारहरूको नाउँ यी नै हुन्, ");
INSERT INTO npi2010_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसाव र आदाको छोरोको नाउँ एलीपज हो। एसाव र बासमतको छोरोको नाउँ रूएल हो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपजका पाँचजना छोराहरूको नाउँ थियोः तेमान, ओमार, सपो, गोताम अनि कनज। ");
INSERT INTO npi2010_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एलीपजकी पनि एउटी दासी थिइ। उसको नाउँ तिम्ना थियो अनि तिम्ना र एलीपजको अमालेक नाउँका छोरो थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएलका चारजना छोराहरू थिए। तिनीहरूः नहत, जेरह, शम्मा र मिज्जा थिए। यिनीहरू एसावकी पत्नी बासमत पट्टीका नातिहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसावकी साइँली पत्नी सेबोनकी छोरो अन्नाकी छोरी ओहोलीबामा थिइन्। एसाव र ओहोलीबामाकी छोरीहरू यऊश, यालाम र कोरह थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","यी परिवार एसावबाट आएका हुन्। एसावको जेठा छोरो एलीपज थियो। एलीपजबाट यिनीहरू आए-तेमान, गोमार, सपो, कनज, ");
INSERT INTO npi2010_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम अनि अमालेक। ती सबै परिवारिक मुखियाहरू एसावकी पत्नी आदाबाट जन्मेका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावको छोरो रूएल यी परिवारहरूको पहिलो बाबु थियो। नहत, जेरह, शम्मा अनि मिज्जा। ती सब परिवाहरू एसावकी पत्नी बासमतबाट आएका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाव को पत्नी र अनाकी छोरी ओहोलीबामाबाट जन्मेका छोराहरू हुन्-यऊश, यालाम अनि कोरह। ती तीन जना मानिसहरू तिनीहरूको परिवारहरूका बाबु हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","यी मानिसहरू एसाव (एदोम) बाट आएका परिवाका प्रमुखहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","एसावभन्दा अघि एदोममा सेइर नाउँको एक होरी मानिस बस्थ्यो। सेइरका छोराहरू थिए: लोतान, शोबाल, सिओन, अना, ");
INSERT INTO npi2010_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर, दीशान। यी छोराहरू एदोममा सेईबाट आएका छोरी पारिवार मुखियाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतान होरी र हेमानको बाबु थियो। (तिम्ना लोतानकी बहिनी थिई।) ");
INSERT INTO npi2010_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालः अल्बान, मानहत, एबाल, सपो अनि ओनामका बाबु थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनका अय्या र अना नाउँका दुइ छोराहरू थिए। (अना त्यही मानिस थियो जसले पहाडमा आफ्नो बाबुका गधाहरूको हेरचाह गर्दा तातो पानीको मुहान भेट्टाएको थियो।) ");
INSERT INTO npi2010_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","दीशोन र ओहोलीबामाका बाबु अना थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोनका चार छोराहरू हेमदान, एश्बान, यित्रान र करान थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेरका तीन जना छोराहरू बिल्हान, जावान र अकान थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशोनका दुइ छोराहरू ऊज र आरान थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरी परिवाहरूका प्रमुखहरू थिए-लोतान, शोनान, सिबोन, अना, ");
INSERT INTO npi2010_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशान, एसेर, अनि दीशान। जो सेइर भूमिमा बसे तिनीहरूको पारिवारिक प्रमुखहरू ती मानिसहरू नै थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","त्यस समयमा एदोममा राजाहरू थिए। इस्राएल राजा हुनुभन्दा धेरै समयअघि एदोममा राजाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बओरको छोरो बेला राजा थियो जसले एदोममा शासन गर्यो। उनले दिन्हारा शहरमाथि शासन गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","जब बेला मर्यो योबाब राजा भयो। योबाब बोज्रामाको जेरहको छोरो थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","जब योबाब मर्यो, हूशामले शासन गर्यो। हूशाम तेमानी मानिसहरूको देशको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","जब हूशाम मर्यो हददले त्यस इलाकाको शासन गर्यो। हदद बेदादको छोरा थियो (हदद ऊ थियो जसले माओबको भूमिमा मिद्यानीहरूलाई जितेको थियो।) हदद अबीत शहरको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","जब हदद मर्यो सम्लाले देशमा शासन चलायो। सम्ला मसेकामाको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","जब सम्ला मर्यो त्यो इलाकामा शावलले शासन चलायो। शावल फरात नदीको किनारमा रहोबोतको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","जब शावल मर्यो त्यो देशमा बाल्हनानले शासन चलायो। बाल्हनान अकबोरको छोरो थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","जब बाल्हनान मर्यो, हदरले त्यहाँ शासन गर्यो। हदर पाऊ शहरको थियो। हदरकी पत्नीको नाम महेतबेल थियो, तिनी मत्रेदकी छोरी थिइन्। (मेजाहाब मत्रेदको बाबु थियो।) ");
INSERT INTO npi2010_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","एसाव एदोमी परिवारहरूः तिम्ना, अल्वा, यतेत, ओहोलीबामा, एला, पीनोन, कनज, तेमान, मिब्सार, मग्दीएल अनि ईरामको बुबा थियो। यी परिवारहरू प्रत्येक नै त्यस इलाकामा बसो-बास गरे जुन इलाकाको नाउँ र पारिवारको नाउँ एकै थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब रोकियो अनि कनान देशमा बस्न थाल्यो। यो त्यही देश हो जहाँ उसको बाबु बसेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकूबको परिवारको कथा यही हो। यूसुफ सत्र वर्षको युवक थियो। उसको काम भेडा-बाख्रा हेरचाह गर्नु थियो। उनले यो काम आफ्नो दाज्यू-भाइ र जिल्पा र बिल्हाका छोराहरूसित गर्यो। (जिल्पा र बिल्हा उसको बुबाकी उप पत्नीहरू थिए।) यूसुफ आफ्नो बुबालाई उसका दाज्यूहरूले गरेका सबै दुष्टकर्मको विषयमा जानकारी दिने गर्दथ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","इस्राएल बूढो भइसकेपछि यूसुफ जन्मेको थियो। यसकारण इस्राएलले यूसुफलाई अरू छोराहरूलाई भन्दा बढी माया गर्थ्यो। याकूबले आफ्नो छोरोलाई एक विशेष लामो र अत्यन्तै राम्रो कोट दियो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","यूसुफका अरू दाज्यू-भाइहरूले जब यो थाहा पाएँ कि तिनीहरूका बुबा उनीहरूलाई भन्दा बढी यूसुफलाई माया गर्थे। यसैकारण तिनीहरू आफ्नो भाइलाई घृणा गर्थे। तिनीहरू उसित राम्रो प्रकारले कुरा गर्न अप्ठ्यारो गर्द थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","एकपल्ट यूसुफले एउटा विशेष सपना देख्यो। पछि उनले आफ्नो दाज्यू-भाइहरूलाई त्यस सपनाको बारेमा भन्यो। त्यसपछि उसका दाज्यू-भाइहरूले झन् वेशी घृणा गर्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","यूसुफले भने, “मैले एउटा सपना देखें। ");
INSERT INTO npi2010_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","हामीहरू सबै खेतमा काम गर्दैथियौ। हामीहरू सबैले मिलेर गहुँको बिटा बाँध्दै थिर्यो। मैले बाँधेको बिटा अनि तिमीहरूले बाँधेको बिटाहरूले मेरो बिटालाई चारै तिरबाट घेर्यो। त्यसपछि तिमीहरूको बिटाले मेरो बिटालाई निहुरिएर ढोग्यो।” ");
INSERT INTO npi2010_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","यूसुफका दाज्यू-भाइहरूले भने, “के यसको अर्थ, तँ राजा हुन्छस् अनि हामीहरू सबैलाई शासन गर्छस्?” उसको दाज्यू-भाइहरूले ऊ माथि अझै धेरै घृणा गर्न थाले, कारण तिनीहरूको विषयमा उसले सपना देखेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","तब फेरि यूसुफले अर्को सपना देख्यो। यूसुफले यस सपना बारेमा पनि आफ्नो दाज्यू-भाइहरूलाई बतायो। उनले भने, “मैले अर्को सपना देखें। मैले घाम, जुन र एघार नक्षत्रहरूले मलाई ढोग गर्दै गरेको देखें।” ");
INSERT INTO npi2010_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","उनले आफ्नो बाबुलाई पनि त्यस सपना बारे भन्यो। तर उसको बाबुले त्यो सपनाको विषयमा आलोचना गरे। उसका बाबुले भने, “यो कस्तो प्रकारको सपना हो? के तँलाईं विश्वास हुन्छ तेरी आमा, तेरो दाज्यू-भाइहरू अनि म तँलाई ढोग्छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","यूसुफका दाज्यू-भाइहरूले साह्रै ईर्ष्या गरिरहे। तर उसको बाबुले यी विषयमा धेरै गहिरिएर सोचे अनि विचार गरे यो सबको अर्थ के हुन सक्छ? ");
INSERT INTO npi2010_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","एक दिन यूसुफका आफ्ना दाज्यू-भाइहरू आफ्ना बाबुका भेडाहरूको हेरचाह गर्न शकेम गए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","याकूबले यूसुफलाई भने, “शकेम जा! तेरा दाज्यू-भाइहरूले मेरो भेडाहरू हेरचाह गर्दैछन्।” यूसुफले भने, “म जानेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","यूसुफका बाबुले भने, “तेरा दाज्यू-भाइहरू सुरक्षित छन् या छैनन् यसो हेर। फर्की आएर मलाई भन मेरा भेडाहरू राम्रै छन् या छैनन्।” यसर्थ यूसुफका बाबुले उसलाई हेब्रोन बेंसीबाट शकेम पठाए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","शकेममा यूसुफ हरायो। एक जना मानिसले उसलाई खेतमा हिंडिरहेको भेट्टायो। त्यस मानिसले भने, “के खोजिरहेको छस्?” ");
INSERT INTO npi2010_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","यूसुफले उत्तर दियो, “म मेरा दाज्यू-भाइहरू खोज्दैछु। के तिमीले भन्न सक्छौ तिनीहरू भेडाहरूसित कहाँ छन्?” ");
INSERT INTO npi2010_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","त्यस मानिसले भने, “तिनीहरू गईसके। तिनीहरू दोतान जाँदै गरेको कुरा मैले सुने।” यसर्थ यूसुफ उनीहरू गए तिरै गए अनि तिनीहरूलाई दोतानमा भेट्टायो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","यूसुफका दाज्यू-भाइहरूले उसलाई टाढाबाट आउँदै गरेको देखे। उनीहरूले उसलाई मार्ने निश्चय गरेर एउटा योजना बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","उनका दाज्यू-भाइहरूले एक अर्कालाई भने, “हेर, सपनादर्शी यूसुफ आउँदैछ। ");
INSERT INTO npi2010_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","यदि हामीले सक्छौ भने उसलाई अवश्य मार्नु पर्छ। हामीले उसको शरीर एउटा रित्तो कुवामा फ्याँक्नु पर्छ। तब हामी आफ्नो बुबालाई भन्न सक्छौ, जंङ्गली जनावरले उसलाई मार्यो। तब हामी हेरौं उसको सपना के हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","तर रूबेनले यूसुफलाई बचाउन चाहन्थ्यो। रूबेनले भने, “त्यसलाई हामी नमारौं। ");
INSERT INTO npi2010_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","हामी त्यसलाई चोट नलगाई कूवामा हाल्न सक्छौं।” रूबेन उसलाई बचाउन अनि बाबु भएको ठाउँमा फिर्ता पठाउन चाहन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","जब यूसुफ आफ्नो दाज्यूहरू कहाँ पुग्यो, तिनीहरूले उसलाई एक्कासी समाते अनि उसको लामो अनि सुन्दर कोट च्यातच्यूत पारे। ");
INSERT INTO npi2010_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","त्यसपछि तिनीहरूले उसलाई एउटा खाली सुख्खा कूवामा फ्याँकि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","जब यूसुफ कूवाभित्र थियो उसका दाज्यू-भाइहरू खान बसे। तिनीहरूले हेरे अनि एक हुल व्यापारीहरू गिलाददेखि मिश्रतिर यात्रा गर्दै गरेको देखे। तिनीहरूले ऊँटहरूमाथि धेरै प्रकारका मसला र धन-दौलत लाँदै थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","यहूदाले दाज्यू-भाइहरूलाई भने, “हामीले आफ्नो भाइ मारेर त्यसको मृत्यु लुकाएर के पाउँछौ? ");
INSERT INTO npi2010_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","बरू हामीहरूले त्यसलाई ती व्यापारीहरूलाई बेच्दा लाभ हुन्छ। हामीले आफ्नो भाइलाई मारेकोमा दोषी पनि हुँदैनौ।” अरू दाज्यू-भाइहरू सहमत भए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","जब ती मिद्यानी व्यापारीहरू नजिक आए, तिनीहरूले यूसुफलाई कूवाबाट बाहिर निकाले। तिनीहरूले यूसुफलाई बीसवटा चाँदीका टुक्रामा बेचे। ती व्यापारीहरूले यूसुफलाई मिश्र लिएर गए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","यी सब घट्ना हुँदा रूबेन त्यहाँ आफ्नो दाज्यू-भाइहरूसित थिएन। तिनीहरूले यूसुफलाई बेचेको उनले थाहा पाएन। जब रूबेन कूवामा आयो उनले त्यहाँ यूसुफलाई देखेन। शोक प्रकट गरेर उनले आफ्नो लुगाहरू च्यात्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","रूबेनले आफ्ना दाज्यू-भाइहरू भएको ठाउँमा गएर भने, “त्यो केटो कूवाँमा छैन। मैले के गर्नु?” ");
INSERT INTO npi2010_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ती दाज्यू-भाइहरूले एउटा बोका मारे अनि त्यसको रगत त्यो राम्रो लबेदामा लगाए। ");
INSERT INTO npi2010_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","तब तिनीहरूले त्यो लबेदा आफ्नो बाबुलाई देखाए। अनि तिनीहरूले सोधे, “हामीले यो लबेदा पायौं, के यो लबेदा यूसुफको हो?” ");
INSERT INTO npi2010_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","तिनीहरूका बुबाले कोट देखे अनि बुझे, कि यो यूसुफको कोट थियो, तिनीहरूका बुबाले भने, “हो, यो उसको कोट हो। जंङ्गली जनावरले मेरो छोरा यूसुफलाई मारेर खाएको हुनुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","याकूब आफ्नो छोरोको निम्ति यति शोकाकुल भयो उसले आफ्नो लुगाहरू च्यात्यो। तब उनले आफ्नो शोक प्रकट गर्न एक खास प्रकारको लुगा लगायो। याकूबले छोरोको शोक धेरै लामो समयसम्म मनायो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","उसका सबै छोरा-छोरीहरूले तिनलाई सान्त्वना दिने प्रयास गरे। तर याकूब कहिल्यै शोकबाट मुक्त भएन। उनले भने, “मेरो छोरोको निम्ति म नमरूञ्जनेलसम्म शोकमा रहनेछु।” यसर्थ याकूब पुत्र शोकमा परिरह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ती मिद्यानी व्यापारीहरूले मिश्र देशमा यूसुफलाई बेचे। फिरऊनका रक्षकहरूका कप्तान पोतीफरलाई तिनीहरूले यूसुफलाई बेचे। ");
INSERT INTO npi2010_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","त्यस समय यहूदा आफ्नो दाज्यू-भाइहरूलाई छोडी हीरा नाउँको मानिससित बस्न गए। हीरा अद्‌दुलाम शहरको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","यहूदाले त्यहीं कनानी केटीलाई भेट्यो अनि उसलाई विवाह गर्यो। त्यस केटीको बाबुको नाउँ शूआ थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","त्यस कनानी केटीले एउटा छोरो जन्माई। उनले उसको नाउँ एर राखी। ");
INSERT INTO npi2010_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","पछि फेरि अर्को छोरो पाई र उसको नाउँ ओनन राखी। ");
INSERT INTO npi2010_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","पछि फेरि उनले अर्को छोरो जन्माई अनि उसको नाउँ उनले शेलह राखीन्। उसको तेस्रो छोरो जन्मँदा यहूदा कजीबामा थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाले आफ्नो छोरो एरको विवाह गराउँनको निम्ति एउटी केटीलाई रोज्यो। त्यस केटीको नाउँ तामार थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","तर एरले अत्यन्तै नराम्रो काम गर्यो। परमप्रभु ऊसंग प्रसन्न हुनुभएन। यसकारण परमप्रभुले उसलाई मार्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","त्यसपछि यहूदाले एरको भाइ ओनानलाई भने, “जा अनि मरेको दाइको पत्नीसित सुत। तँ उसको लोग्ने जस्तै बनिनु। यदि नानीहरू जन्मे ती तेरो दाइ एरका नानीहरू हुन्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ओनानलाई थाहा थियो तामार र ऊबाट जो नानीहरू हुन्छन् ती सबै उसका हुँदैनन्। ओनानले तामारसित सहवास गर्यो। तर उनले आफ्नो गर्भधारण हुन दिएन। ");
INSERT INTO npi2010_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","यस विषयमा परमप्रभु क्रोधित हुनु भयो। यसकारण परमप्रभुले ओनानलाई पनि मार्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","त्यसपछि आफ्नी बुहारी तामारलाई यहूदाले भन्यो, “तँ आफ्नो बाबुको घर फर्केर जा, त्यही बस अनि तबसम्म विवाह नगर्नु जबसम्म मेरो छोरा शेलह ठूलो हुँदैन।” यहूदालाई डर थियो कतै शेलह पनि उसको दाज्यूहरू झैं मारिन्छ। तामार आफ्नो बाबुको घरमा फर्केर गइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","पछि शूआकी छोरी यहूदाकी पत्नी मरी। यहूदाको शोक समय बितेपछि, त्यो अद्‌दुलामबाट आफ्नो साथी हीरासित तिम्ना गए। भेडाबाट काटिएको ऊन लिन यहूदा तिम्ना गए। ");
INSERT INTO npi2010_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","उसको ससुरा यहूदा भेडाको ऊन लिन तिम्ना गएको कुरा तामारले चाल पाई। ");
INSERT INTO npi2010_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","तामारले संधै विधवाले लगाउने लुगा लाउने गर्द थिइ। यसर्थ उनले भिन्दै केही लुगा लगाई अनि आफ्नो अनुहार पर्दाले छोपी। त्यसपछि तिम्ना शहरको नजिक एनैम जाने बाटोको मुन्तिर बसी। तामारले थाहा पाई यहूदाको छोरो शेलह अब ठूलो भइसकेको छ। तर यहूदाले ऊसित विवाह गर्ने कुनै योजना बनाउने छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","यहूदा त्यही बाटो हिंडेर गए। उनले तामारलाई देख्यो तर त्यो वेश्या हो भनेर सोच्यो। उनले आफ्नो अनुहार वेश्याहरूले जस्तै पर्दाले ढाकेकी थिई। ");
INSERT INTO npi2010_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","यसर्थ यहूदा तिनी भएको ठाउँमा गए अनि भन्यो, “तँसित शारीरिक सम्बन्ध गर्नदे।” यहूदाले थाहा पाएन ऊ आफ्नी बुहारी तामार थिई। उनले भनी, “तिमीले मलाई के दिन्छौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","यहूदाले उत्तर दियो, “म मेरो भेडाको हुलबाट एउटा भेडा पठाइ दिनेछु।” उनले उत्तर दिई, “यसमा म राजी छु। तर तिमीले मलाई भेडा नपठाउञ्जेलसम्म राख्नलाई केही दिनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदाले सोध्यो, “मैले भेडा नपठाउञ्जेलसम्म के बन्धक राख्न चाहन्छौ?” तामारले उत्तर दिई, “तिमीले आफ्नो चिट्ठी पठाउँदा प्रयोग गर्ने मोहर र डोरी देऊ। अनि तिमीले टेक्ने लट्ठी पनी देऊ।” यहूदाले यी सब चीजहरू उसलाई दिएर तामारसित सहवास गरे। तामार गर्भवती भइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","तामार घर गई अनि उनले आफ्नो मुखबाट पर्दा हटाएर फेरि त्यही आफूलाई विधवा देखाउने लुगा पहिरीन्। ");
INSERT INTO npi2010_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","त्यसपछि यहूदाले वेश्यासित प्रतिज्ञा गरे अनुसार हीरालाई एउटा सानो बाख्रा दिएर एनैम पठाए। यहूदाले उसलाई आफ्नो मोहर र लट्ठी फर्काएर ल्याउनुँ भन्यो। तर हीराले तामारलाई भेट्न सकेन। ");
INSERT INTO npi2010_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","हीराले एनैम शहरका केही मानिसहरूलाई सोध्यो, “बाटोको छेऊमा बस्ने वेश्या कहाँ छे?” मानिसहरूले जवाफ दिए, “यहाँ कोही वेश्या थिइन।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","यसर्थ यहूदाको साथी तिनीकहाँ गए र भने, “मैले आइमाईलाई भेट्न सकिन। जब मैले त्यस ठाउँका मानिसहरूलाई सोधें, तिनीहरूले मलाई बताए त्यस ठाउँमा कोही वेश्या थिइन।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यसकारण यहूदाले भने, “त्यसलाई ती चीजहरू राख्न देऊ। म चाँहदिन मानिसहरू ममाथि हाँसुन्। मैले त्यसलाई बाख्रा दिन खोजें तर उसलाई भेटिएन, त्यही नै पर्याप्त छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","प्रायः तीन महीनापछि कसैले यहूदालाई भने, “तिम्रो बुहारीले वेश्याले जस्तै काम गरी। अनि अहिले उ वेश्यावृतिले गर्दा गर्भवती छे।” तब यूहदाले भन्यो, “उसलाई बाहिर निकाल, उसलाई मार अनि उसको शरीर जलाई दे।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","यहूदाका मानिसहरू तामारलाई मार्न गए। तर तामारले आफ्नो ससुरालाई समाचार पठाई। तामारले भनी, “जुन मानिसले मलाई गर्भवती बनायो त्यसैका यी चीजहरू हुन्। तब उनले मोहर, डोरी अनि टेक्ने लट्ठी देखाई। यी चीजहरू हेर यी सब कसका हुन्? यी कसका विशेष मोहर, डोरी र टेक्‌ने लट्ठी हो?” ");
INSERT INTO npi2010_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदाले ती चीजहरू चिन्यो अनि भने, “उनले ठीक भनी। म नै भूलमा थिएँ। मैले आफ्नो प्रतिज्ञा अनुसार उसको विवाह आफ्नो छोरा शेलहसित गर्न दिइनँ।” अनि यहूदा फेरि तिनीसित सुतेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","तामारको सुत्केरी हुने समय आइपुग्यो अनि उनले थाहा पाई जुम्लयाह नानीहरू हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","जुन समयमा उनले नानी जन्माँउदै थिई एउटा नानीको एउटा हात बाहिर निस्कियो। सुँडेनीले त्यो नानीको हातमा रातो धागो बाँधेर भनी, “यो नानी पहिले जन्मन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","तर त्यस नानीले आफ्नो हात फेरि भित्र पसायो। त्यसपछि दोस्रो नानी पहिले जन्मयो। त्यस बखत सुँडेनीले भनी, “तँ नै पहिले बाहिर आउन समर्थ भइस्।” त्यसकारण उनले त्यस नानीको नाउँ पेरेस राखी। ");
INSERT INTO npi2010_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","त्यसपछि अर्को नानी जन्मियो। त्यस नानीको हातमा रातो धागो थियो। उनले त्यस नानीको नाउँ जेरह राखि। ");
INSERT INTO npi2010_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","जुन व्यापारीले यूसुफलाई किन्यो उनले यूसुफलाई मिश्र देशमा लिएर गए। उनले यूसुफलाई फिरऊनको अगंरक्षकहरूको सेनापतिलाई बेचिदियो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","तर परमप्रभुले यूसुफलाई सहायता गर्नु भयो। यूसुफ एउटा सफल मानिस भयो। यूसुफ आफ्नो मिश्री मालिक पोतीफरको घरमा बस्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","पोतीफरले थाहा पायो परमप्रभुले यूसुफलाई सहायता गर्नु भएको छ। उनले यो पनि थाहा पायो यूसुफले जे गर्छ त्यसमा उसलाई सफल पार्न परमप्रभुले सहायता गर्नु भएको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","यसकारण यूसुफलाई पाएर पोतीफर अत्यन्तै खुशी थियो। पोतीफरले उसलाई आफ्नो काम गराउन तथा घरमा व्यवस्था मिलाउने काममा लगायो। पोतीफरको प्रत्येक कुरोमा उसको अधिकार थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","जब यूसुफ पोतीफरको घरमा प्रत्येक चीजको अधिकारी बनियो तब परमप्रभुले पोतीफरको घरमा रहेको प्रत्येक चीजमा आशीर्वाद दिनुभयो। परमप्रभुले यूसुफको कारणले यसो गर्नु भयो अनि पोतीफरको खेतीमा उब्जने प्रत्येक चीजलाई परमप्रभुले आशीर्वाद दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","यसैले पोतीफरले यूसुफलाई आफ्नो घरको प्रत्येक चीजको जिम्मावारी लगायो। पोतीफरले कुनै कुराको चिन्ता गर्दैनथ्यो ऊ खाली आफ्नो भोजनको विषयमा मात्र चिन्ता गर्दथ्यो। यूसुफ अत्यन्तै सुन्दर र राम्रो थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","केही समयपछि यूसुफको मालिककी पत्नीले उसलाई प्रेम गर्न थालीन्। एकदिन उनले भनिन्, “मसँग सुत्।” ");
INSERT INTO npi2010_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","तर यूसुफ मानेन। उनले भने, “मेरो मालिक यस घरको प्रत्येक चीजको निम्ति मलाई विश्वास गर्छन। उनले यस घरको प्रत्येक चीजको लागि मलाई जिम्मावारी दिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","मेरा मालिकले मलाई आफू समान सम्झन्छन्। तर मैले उसकी पत्नीसित सुत्नु हुँदैन। यो उचित होइन। यो परमेश्वरको बिरूद्धमा पाप हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","त्यो स्त्रीले प्रत्येक दिननै यूसुफसित कुरा गर्थी। तर यूसुफले ऊसित सुत्न अस्वीकार गर्दथियो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","एक दिन यूसुफ आफ्नो कामको निम्ति घरभित्र पसेको थियो। त्यस बेला लोग्ने मानिस त्यस घरमा ऊ मात्रै थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","उसका मालिककी पत्नीले यूसुफको लुगा समाती अनि उसलाई भनी, “तिमी मसित ओछ्यानमा आऊ।” तर यूसुफ त्यहाँबाट यति चाँडो भाग्यो कि उसको लुगा मालिककी पत्नीको हातमा नै रह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","त्यस मानिसकि पत्नीले देखी उसको लुगा उसैको हातैमा थियो अनि यूसुफ घरदेखि बाहिर भागेर गए। यसर्थ उनले निश्चय गरी जे भएको थियो त्यस विषयमा झूटो प्रचार गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ऊ बाहिरका मानिसहरूलाई बोलाउन गई। उनले भनी, “हेर, यो हिब्रू कमारा हाम्रो बेइज्जत गर्न यहाँ आएको थियो। ऊ भित्र आयो अनि मसित सुत्ने कोशिश गर्यो, तर म साह्रै चिच्याएँ। ");
INSERT INTO npi2010_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","म चिच्चाएकोले गर्दा त्यो डरायो अनि यहाँबाट भाग्यो। तर उनले आफ्नो कोट मसितै छोडेर गयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","यसकारण उनले आफ्नो लोग्ने घर फर्कुन्जेलसम्म त्यो लुगा आफूसँगै राखी। ");
INSERT INTO npi2010_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","अनि उनले आफ्नो लोग्नेलाई त्यही कथा सुनाई। उनले भनिन, “तिमीले ल्याएको हिब्रू दासले मसित ब्यभिचार गरेर लज्जित पार्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","जब ऊ मकहाँ आयो म चिच्चाएँ अनि त्यो भाग्यो तर त्यसले आफ्नो लुगा छोडेर गयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","जति बेला यूसुफको मालिकले कथा सुने, तिनी साह्रै नै रिसाए। ");
INSERT INTO npi2010_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","त्यहाँ एउटा झ्यालखाना थियो अनि त्यसमा राजाका शत्रुहरूलाई राखिन्थ्यो। पोतीफरले यूसुफलाई त्यही झ्यालखानामा राख्यो अनि यूसुफ त्यही बसिरह्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","तर परमप्रभु यूसुफसित हुनुहुन्थ्यो। उहाँ संधै ऊसंग दयालु हुनुहुन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","उहाँले अरू कैदीहरूको प्रमुख यूसुफलाई बनाए अनि एक रक्षकबाट गरिनु पर्ने प्रत्येक कुरो तिनलाई गर्न लगाए। ");
INSERT INTO npi2010_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","रक्षकहरूका अधिकारीले झ्यालखानको सबै कुराहरूमा यूसुफमाथि विश्वास गर्थे। यस्तो यसकारण हुने भयो कारण परमप्रभुले यूसुफलाई सहायता गर्नुहुन्थ्यो। यूसुफले जे गर्थ्यो परमप्रभुले उसलाई सफल गराउनु हुन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","पछि, फिरऊनका दुइजना नोकरहरूले फिरऊनप्रति केही गल्ती गरे। तिनीहरूमध्ये एकजना फिरऊनका लागि रोटी पकाउने अनि अर्को उनको दाखरस दिने नोकर थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फिरऊन यी रोटी पकाउने र दाखरस सेवा गर्ने मानिसहरूसित क्रोधित भए। ");
INSERT INTO npi2010_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","उनले तिनीहरूलाई फिरउनले यूसुफलाई जस्तै फोतिफरलाई झ्यालखानाम पठाए जसको मुख्य अगंरक्षकको घरमा जहाँ यूसुफ थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","प्रमुखले ती दुइजनालाई यूसुफको हेरचाहमा राखि दिनुभयो। तिनीहरू यस झ्यालखानामा केही दिन थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","एक दिन राती ती दुइजनाले सपना देखे। ती दुइजना नोकरहरू, एकजना रोटी पकाउने र अर्को दाखरस सेवा गराउने मिश्र देशका राजाका नोकरहरू थिए। प्रत्येक कैदीको आ-आफ्नो सपना थियो। अनि प्रत्येक सपनाको अलग्गै अर्थ थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","यूसुफ भोलिपल्ट बिहानै तिनीहरूकहाँ गए। उनले तिनीहरूलाई साह्रै कष्टमा परेको भेट्टाए। ");
INSERT INTO npi2010_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","यूसुफले सोध्यो, “आज तिमीहरू किन चिन्तित देखिन्छौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ती दुइजना मानिसहरूले उत्तर दिए, “हामीले राती सपना देख्यौं तर के सपना देख्यौं बुझ्न सकेनौं। त्यो सपनाको अर्थ हामीलाई बुझाउने अथवा व्याख्या गर्ने मानिस यहाँ कोही पनि छैन।” यूसुफले तिनीहरूलाई भने, “परमेश्वर नै एकजना हुनुहुन्छ जसले सपना बुझाउनु अथवा व्याख्या गर्न सक्नु हुन्छ। यसर्थ म बिन्ती गर्छु मलाई तिमीहरूको सपना बताऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","यसर्थ दाखरस सेवकले यूसुफलाई आफ्नो सपना बतायो। त्यसले भने, “मैले मेरो सपनामा दाखको बोट देखें। ");
INSERT INTO npi2010_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","त्यस बोटमा तीनवटा हाँगाहरू थिए। कोपिला लागेपछि लगत्तै यसका फूलहरू प्रस्फूटित भए अनि पाकेको अगूँरको गुच्छा भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","मैले फिरऊनको प्याला समातेको थिए यसर्थ दाख टिपेर त्यो प्यालामा निचोरेर त्यो प्याला फिरऊनलाई दिएँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","तब यूसुफले उत्तर दियो, “म सपनाको व्याख्या तिमीलाई दिनेछु। ती तीनवटा हाँगाहरूको अर्थ तीन दिन हो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","तीन दिन शेष हुनुअघि फिरऊनले यहाँ आएर तिमीलाई आफ्नो काममा जान अनुमति दिनेछन्। तिमीले त्यही काम गर्नेछौ जुन काम तिमीले फिरऊनसित पहिले गरिरहेका थियौ। ");
INSERT INTO npi2010_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","तर जब तिमी यहाँबाट मुक्ति पाउँछौ मलाई पनि सझना गर्नु। मलाई सहायता अनि मेरो भलाई गर। मेरो विषयमा फिरऊनलाई भन जसले गर्दा म यहाँबाट निस्कन सकुँ। ");
INSERT INTO npi2010_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","मलाई हिब्रूहरूको भूमि, मेरो देशबाट बल प्रयोग गरेर निकालियो। अनि त्यस समयमा मैले कुनै भूल गरेको थिइनँ जसले गर्दा म कैदमा पर्नु पर्ने थियो।” ");
INSERT INTO npi2010_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","त्यस रोटी पकाउनेले थाहा पायो अर्को नोकरको सपना राम्रो थियो। यसर्थ मुख्य रोटी पकाउनेले यूसुफलाई भने, “मैले पनि सपना देखें। मैले सपनामा देखें मेरो टाउको माथि रोटीले भरिएको तीनओटा डालाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","सब भन्दा माथिको डालामा सबै प्रकारको पकाएको भोजन थियो। यो भोजन राजाको निम्ति थियो। तर भोजन चराहरूले खाइरहेका थिए।” ");
INSERT INTO npi2010_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","यूसुफले उत्तर दियो, “सपनाको अर्थ के हुन्छ म बताउने छु। ती तीन डालाहरूको अर्थ तीन दिन हो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","तीन दिनभित्र राजा यहाँ आउनु हुनेछ अनि तिमी कैदबाट मुक्त हुनेछौ। तब राजाले तिम्रो टाउको छिनाउनु हुनेछ अनि तिम्रो शरीर खुट्टामा झुण्ड्याउँनु हुनेछ अनि तिम्रो शरीरको मासु चराहरूले खानेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","तीन दिनपछि फिरऊनको जन्म दिन थियो। फिरऊनले आफ्नो सबै नोकरहरूलाई भोज दिए। भोजमा फिरऊनले मुख्य दाखरस दिने र मुख्य रोटी पकाउने नोकरहरूलाई झ्यालखानाबाट निकाल्ने अनुमति दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","फिरऊनले दाखरस दिने सेवकलाई मुक्त गर्यो अनि उसलाई आफ्नो पुरानो काममा नै लगायो। अनि दाखरस दिने सेवकले फिरऊनको हातमा दाखरसको प्याला राखिदियो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","तर फिरऊनले मुख्य रोटी पकाउनेलाई फाँसी दियो अनि यूसुफले जे जे हुन्छ भनी बताएको थियो त्यही भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","तर मुख्य दाखरस दिने सेवकले यूसुफलाई सहायता गर्न पनि बिर्सियो उसले यूसुफको विषयमा फिरऊनलाई केही पनि भनेन। यूसुफको विषयमा उनले सबै बिर्सियो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","दुइवर्ष पछि फिरऊनले एउटा सपना देख्यो। उनले आफैंलाई नील नदीको किनारमा उभिरहेको सपना देख्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","सपनामा उनले देख्यो सातवटा गाईहरू नदीबाट निस्केर घाँस खाँदै उभिएका थिए। ती गाईहरू हेर्दा राम्रा र स्वस्थ थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","त्यसपछि अझ सातवटा गाईहरू नदीबाट निस्के अनि ती स्वस्थ गाईहरूको नजिकमा नदीको किनारमा उभिए। तर गाईहरू दुब्लो र बिमारी जस्ता थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","आफ्नो सपनामा उनले यी सातवटा रोगी गाईहरूले सातवटा स्वस्थ गाइहरूलाई खाँदै गरेको देख्यो। तब फिरऊन ब्यूँझीयो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","फिरऊन फेरि सुत्यो र सपना देख्यो। उनले सपनामा एउटा अन्नको बोटमा सातवटा बाला लागेको देख्यो। अन्नको बालाहरू मोटा र राम्रा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","अनि पछि अझ सातवटा अन्नहरू भएको उसले देख्यो। तर तिनीहरू पातलो र बाफिलो हावाले सुकेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ती पातला सातवटा अन्नका बालाहरूले ती राम्रा र भरिला अन्नका बालाहरू खाए। त्यसपछि फिरऊन बिउँझीयो अनि सोच्यो त्यो सब एउटै सपना मात्र थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","र अर्को बिहान यी सपनाहरूको विषयमा फिरऊन एकदमै चिन्तित भयो। यसर्थ उनले मिश्र देशका सबै जादूगर अनि सबै ज्ञानी मानिसहरूलाई बोलायो। फिरऊनले ती सबै मानिसहरूलाई आफ्नो ती सपनाहरूको विषयमा बतायो तर कसैले पनि त्यस विषयमा व्याख्या गर्न सकेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","तब त्यो दाखरस पुर्याउने सेवकले यूसुफलाई सम्झिए अनि फिरऊनलाई भने, “आज म मेरो अतीतका भूलहरू सम्झना गराइरहेको छु। ");
INSERT INTO npi2010_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","तपाईं म र रोटी पकाउनेसित दिक्कहुनु भएको थियो अनि हामीलाई प्रमुख रक्षकको घरमा कैदी बनाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","त्यसपछि एक रात उनले र मैले सपना देख्यौं। प्रत्येक सपनाको भिन्दा भिन्दै अर्थ थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","हामीसित झ्यालखानामा एक जना हिब्रू मानिस थियो। त्यो अंगरक्षकहरूको कप्तानको नोकर थियो। उसलाई हामीले आफ्नो सपना बतायौं र ती सपनाहरूको विषयमा उनले हामीलाई व्याख्या गर्यो। हामीलाई उनले प्रत्येक सपनाको अर्थ बतायो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","उसले जे भनेको थियो म झ्यालखानबाट मुक्त हुनेछु अनि मेरो आफ्नै नोकरी पाउनेछु, त्यो सही भयो। उनले त्यो रोटी पकाउने मानिस मर्छ भनेको थियो अनि त्यो मर्यो। यसर्थ उनले जे जे भनेको थियो सत्य भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","यसर्थ यूसुफलाई फिरऊनले झ्यालखानबाट झिकायो र अंग-रक्षकहरूले उसलाई लगत्तै झ्यालखानबाट ल्याए। यूसुफले दाह्री काट्‌यो अनि केही सफा लुगाहरू लगाएर फिरऊनलाई भेट्न गयो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फिरऊनले यूसुफलाई भन्यो, “मैले थाहा पाएँ कसैले तिमीलाई आफ्नो सपना बताए तिमी त्यसको बारेमा व्याख्या दिन सक्छौ अरे। मैले पनि एउटा सपना देखेको छु अनि त्यस सपनाको विषयमा बताउन यहाँ कसैले ब्यख्या गर्न सकेनन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","यूसूफले उत्तर दिए, “म त ब्यारख्या दिन सक्दिनँ तर हुनसक्छ परमेश्वले तिमीलाई सपनाको बिषयमा बताउनु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","त्यसपछि फिरऊनले यूसुफलाई भने, “मेरो सपनामा म नील नदीको किनारमा अभिरहेको थिएँ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","त्यहाँ नदीबाट सातवटा गाईहरू निस्किए अनि किनारमा घाँस खाँदै उभिए। तिनीहरू हेर्दा स्वस्थ र राम्रा देखिने जनावर थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","तब फेरि नदीबाट अरू सातवटा गाईहरू निस्किए तर यी हेर्दा दुर्बल र नराम्रा थिए। सम्पूर्ण मिश्रमा मैले देखेको गाईहरूभन्दा ती गाईहरू नराम्रा थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","त्यसपछि ती दुब्ला र घिनलाग्दा गाईहरूले पहिलेका राम्रा र स्वस्थ गाईहरूलाई खाए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","तर तिनीहरू अझ पनि दुब्ला र नराम्रा देखिए। तर सातवटा गाईहरू खाई सकेपछि पनि तिनीहरू दुब्ला र कुरूप नै देखिन्थे। तिनीहरूलाई हेरेर तिमीलाई भन्न सक्ने थिएनौ ती गाईहरूले सातवटा बलिया बलिया गाईहरू खाए। शुरूमा तिनीहरू जति कुरूप र दुब्ला थिए पछि पनि तिनीहरूलाई त्यसतै देखिन्थे। तब म बिउँझें। ");
INSERT INTO npi2010_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“मेरो फेरि अर्को सपनामा मैले एउटा अन्नको बोटमा सातवटा बालाहरू फल्दै गरेको देखें। ती सातवटा बालाहरू बाक्ला र अन्नले भरिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","अनि पछि अरू सातवटा बालाहरू तिनीहरूपछि पलाए। तर ती पछि पलाएका बालाहरू पातला र गरम हावाले नष्ट भएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","त्यसपछि ती पातला बालाहरूले पहिलेको बाक्ला सातवटा बालाहरूलाई खाए। “मैले ती सपनाहरू मेरो जादूगरहरूलाई भनें तर कसैले पनि ती सपनाहरूको विषयमा व्याख्या गर्न सकेनन्। तिनीहरूको अर्थ के हुन्छ त?” ");
INSERT INTO npi2010_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","तब यूसुफले फिरऊनलाई भन्यो, “ती दुवै सपनाहरू एउटै विषयका हुन्। परमेश्वरले अब चाँडै के घट्न लागेको छ। त्यस विषयमा भनी रहनु भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","दुवै सपनाहरूको अर्थ वास्तविक रूपमा एउटै हो। सातवटा राम्रा-राम्रा गाईहरू र सातवटा राम्रा-राम्रा अन्नको बालाहरूको अर्थ राम्रा सात वर्षहरू हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ती सातवटा बिमारी गाईहरू र सातवटा अन्नको पातला बालाहरूले यस इलाकामा सात वर्षसम्म अनिकाल लाग्छ भन्ने बोध हुन्छ। यी खराव सात वर्ष राम्रो सात वर्षपछि आउँछ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","यो ठीक मैले तिमीलाई भने जस्तै नै हो। परमेश्वरले फिरऊनलाई बताउनु भएको छ उहाँ के गर्नु हुँदैछ? ");
INSERT INTO npi2010_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","मिश्र देशमा सात वर्ष प्रचूर अन्न हुने छ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","तर त्यसपछि फेरि सात वर्ष अनिकाल लाग्ने छ। मिश्र देशका मानिसहरूले अतीतमा कति अन्न उब्जनी गरेका थिए बिर्सनेछन्। अन्न र पानीको अभावले देश नष्ट हुने छ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","त्यो अनिकाल त्यति भयंकर हुनेछ मानिसहरूले प्रशस्त खाने कुरा खाँदा कस्तो हुन्छ भूल्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“हे फिरऊन, तपाइले एउटै अर्थ भएका दुइवटा सपना देख्नु भयो। यस्तो यो अर्थ बुझाउनको निम्ति भयो ताकि परमेश्वरले यो निश्चय गराउनु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","यसैकारण, हे फिरऊन, तपाईंले यस्तो बुद्धिमान र ज्ञानी मानिस हेर्नुहोस् अनि उनलाई मिश्र देशको राज्यपाल बनाउनुहोस्। ");
INSERT INTO npi2010_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","तब जनताबाट अन्न उठाउनको निम्ति अरू मानिसहरू छान्नु होस्। प्रत्येक मानिसले असल सात वर्षमा जे जति अन्न उब्जाउँछ, त्यसबाट पाँचौ भाग बुझाओस्। ");
INSERT INTO npi2010_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","तिनीहरूलाई आज्ञा दिनुहोस् जो असल वर्षहरू आउँदैछन् त्यसबेला प्रशस्त अनाजहरू जम्मा गरून्। मानिसहरूलाई घोषणा गरी दिनु होस् ती छानिएकै मानिसलाई शहरहरूमा अनाजहरू जम्मा गर्ने अधिकार होस्। तब तिनीहरूले त्यति समयसम्म अन्न बचाएर राख्नेछन् जबसम्म त्यसको आवश्यक रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","त्यो जम्मा गरिएको अन्न अनिकालको समय मिश्रमा उपयोग हुनेछ, यसर्थ मानिसहरू सात वर्ष अनिकालमा भोकले मर्ने छैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","फिरऊन र तिनका सबै पदाधिकारीहरूलाई यो योजना राम्रो लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","त्यसपछि उनले तिनका सबै पदाधिकारीहरूलाई सोधे, “के परमेश्वरको आत्मा त्यो व्यक्तिभित्र रहेको कुनै व्यक्ति हामी भेट्न सक्छौ? सक्दैनौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","यसर्थ फिरऊनले यूसुफलाई भने, “जब परमेश्वरले तिमीलाई यी सबै कुराहरू बुझ्ने बनाउनु, भयो, यस ठाउँमा तिमी जस्तो ज्ञानी तथा बुद्धिमानी कोही पनि छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","तिमी नै एक जना हौ जो यस देशको राज्यपाल हुन सक्ने अनि मेरा सबै मानिसहरूले तिम्रो कुरा सुन्ने छन् तिमी जे भन्छौ, आज्ञा पालन गर्नेछन्। म मात्र एकजना व्यक्ति हुनेछु जो तिमी देखि माथि रहनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","तब फिरऊनले यूसुफलाई फेरि भने, “मैले तिमीलाई समस्त मिश्र देशको राज्यपाल बनाएको छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","अनि फिरऊनले आफ्नो राजकीय मुकुटको छाप भएको औंठी यूसुफलाई दिए, उसलाई राम्रो रेशमी लुगा लगाई दिए अनि फिरऊनले उसको गलामा सुनको एउटा सिक्री लगाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","जब तिनिहरू रथको परेडमा चढे। फिरऊनले यूसुफलाई आफ्नो रथको पछाडी राखे अनि “यूसुफलाई बाटो देऊ” भन्दै कराउँदै हिँडे त्यसरी फिरऊनले यूसुफलाई सम्पूर्ण मिश्रदेशको राज्यपाल बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","राजा फिरऊनले तिनलाई भने, “म फिरऊन राजा हुँ। तिम्रो अनुमति बिना मिश्र देशको भूमिमा कसैले पनि हात अथवा खुट्टा हाल्न पाउने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","त्यसपछि फिरऊनले उनलाई अर्को नाउँ साप्‌नत-पानेह दिए। फिरऊनले उसको विवाह आसनत नाउँ भएकी आइमाईसित गराए जो ओन शहरका पूजाहारी पोतीफरकी छोरी थिइ। यस प्रकार यूसुफ समस्त मिश्र देशका राज्यपाल भए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","मिश्र देश भरी भ्रमणमा निस्के। जब यूसुफले मिश्रका राजाको सेवा गर्न शुरू गरे। यूसुफ तीस वर्षका हुँदा निस्के अनि सारा मिश्र देशको भ्रमण गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सहकालको सात वर्षको समयसम्म देशमा राम्रो उब्जनी भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","अनि तिनले ती वर्षहरूमा अन्नहरू जोगाएर शहरहरूमा जम्मा गरे। प्रत्येक शहरमा त्यस शहरको वरिपरिको भूमिबाट उब्जिएको अन्न जम्मा गराए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","समुद्रको बालुवाको थुप्रो झैं अन्न यूसुफले थुपारे। तिनले थुपारेको अन्न यति विध्न थियो ओजन गर्न असम्भव थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","यूसुफकी पत्नी आसनत थिइन् अनि तिनी ओन शहरका पूजाहारी पोतीफेराकी छोरी थिइन। अनिकाल लाग्न दुइ वर्ष अघाडि यूसुफ र आसनतका दुइ छोराहरू जन्मे। ");
INSERT INTO npi2010_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","यूसुफले आफ्नो पहिलो छोरोको नाउँ मनश्शे राखे। यूसुफले उसको यस्तो नाउँ राखे कारण उनले भने, “मैले जति कष्ट पाएको थिएँ परमप्रभुले सबै देख्नु भयो र मेरो घरको सम्झना पनि विर्साइ दिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","तिनले आफ्नो दोस्रो छोरोको नाउँ एप्रैम राखे। तिनले उसको नाउँ यस्तो राखेको कारण बताए, “परमेश्वरले मलाई सफल तुल्याउनु भयो, जुन ठाउँमा मैले कष्ट भोगें।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","सात वर्षसम्म मानिसहरूले जति चाहान्थे खाने अन्न पाए तर त्यसपछि ती वर्षहरू बिते। ");
INSERT INTO npi2010_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","अनि यूसुफको भविष्यवाणी अनुसार नै सात वर्षको अनिकाल शुरू भयो। यस देशहरूका सबै अंञ्चलहरुमा खाद्यको अभाव भयो। तर मिश्रमा अन्न प्रचूर थियो। यस्तो भएको कारण यूसुफले अन्न जम्मा गरेर राखेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","जब अनिकाल शुरू भयो मिश्रका मानिसहरूले फिरऊनलाई अन्नको दावी गरे अनि तिनले आफ्नो देशका मानिसहरूलाई भने, “यूसुफकहाँ जाऊ अनि सोध के गर्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","प्रत्येक ठाउँमा अनिकाल चलिरहेको थियो। यसर्थ यूसुफले मानिसहरूलाई गोदामबाट अन्न दिए। तिनले जोगाएर राखेको अन्न मिश्र देशका मानिसहरूलाई बेचे। मिश्र देशमा नै घोर अनिकाल लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","प्रत्येक यूसुफकहाँ अन्न किन्न आए, किनभने अनिकाल सबै ठाउँमा भयंकर थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","कनानमा पनि खराब प्रकारले नै अनिकाल लाग्यो। तर याकूबले मिश्र देशमा अन्न छ भनी थाहा पाए। यसर्थ याकूबले आफ्नो छोराहरूलाई भने, “हामी यहाँ किन केही यसरी बसिरहेका छौं। ");
INSERT INTO npi2010_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","बेच्नको निम्ति मिश्र देशमा अन्न राखिएको छ भनी मैले सुनेको छु। यसर्थ अन्न किन्नको निम्ति हामी त्यहाँ जाऊँ जसले गर्दा हामी आफैंलाई अनिकालबाट बचाउनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","यसर्थ मिश्रमा अन्न किन्न यूसुफका दाजुहरू मध्ये दश जना गए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","याकूबले बिन्यामीनलाई पठाएनन्। (यूसुफका भाइहरूमा बिन्यामीन मात्र आफ्नै भाइ हो।) बिन्यामीनलाई केही नराम्रो होला भनेर याकूब डराए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","कनानमा अनिकाल औधी नै लगेको थियो, मिश्र देशमा अन्न किन्न जानेहरूमा कनानबाट धेरै मानिसहरू थिए। तिनीहरू मध्ये इस्राएलका छोराहरू पनि थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","त्यस समयमा मिश्र देशका प्रशासक यूसुफ थिए। त्यहाँ यूसुफ मात्र एकजना मानिस थिए, जसले मिश्र देशमा मानिसहरूलाई अन्न बेच-बिखन गरिएको निरीक्षण गर्थे। यसर्थ तिनका दाज्यू-भाइहरू तिनीकहाँ आए अनि शिर निहुर्याएर नमस्कार गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","यूसुफले आफ्नो दाज्यू-भाइहरूलाई देखे अनि चिने। तर तिनले आफ्नो दाज्यू-भाइहरूलाई नचिने झैं गरे। तिनले तिनीहरूसित निष्ठूरतापूर्ण शब्दहरूमा कुरा गरे। तिनले भने, “तिमीहरू कहाँबाट आएका हौ?” ती दाज्यू-भाइहरूले उत्तर दिए, “हामी कनान देशबाट आएका हौं। यहाँ हामी अन्न किन्न् आएका हौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","यूसुफले चिने तिनीहरू तिनका दाज्यू-भाइहरू हुन् तर तिनी को हुन् तिनीहरूले चिनेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","यूसुफले आफ्नो दाज्यू-भाइहरूको विषयमा देखेको सपना सम्झे। यूसुफले आफ्नो दाज्यू-भाइहरूलाई भने, “तिमीहरू जासूसहरू हौ, अन्न किन्न आएकाहरू होइनौ। हामी कहाँ दुर्बल छौं त्यो जान्न आएका हौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","तिनीहरूले उत्तर दिए, “हे महाशय तपाईंका सेवकहरू यहाँ खाद्यान्न किन्न मात्र आएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","हामीहरू सबै दाज्यू-भाइहरू हौं, हामी सबैका बाबु एउटै हुन्। हामी ईमानदार मानिसहरू हौं। हामी खाली अन्न किन्न आएका छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","तब यूसुफले तिनीहरूलाई भने, “होइन। हामी कहाँ दुर्बल छौं त्यो जान्न तिमीहरू आएका हौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","अनि तिनीहरूले उत्तर दिए, “होइन, हामी सबै दाज्यू-भाइहरू हौं। हाम्रो परिवारमा हामी बारह्रजना दाज्यू-भाइहरू छौं। हामीहरू सबैको एकजना बुबा हुनुहुन्छ। हाम्रो कान्छो भाइ घरमा बुबासित छ। एकजना भाइ धेरैअघि मर्यो। हामी, तपाईंका दासहरू, कनानको भूमिबाट आएका हौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","तर यूसुफले भने, “होइन। म बुझ्नसक्छु म भूलमा छैन। तिमीहरू जासूसहरू हौ। ");
INSERT INTO npi2010_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","तर म तिमीहरूलाई आफू सत्य भएको प्रमाण गर्ने मौका दिन्छु। म राजा फिरऊनको नाउँमा शपथ खान्छु जबसम्म तिमीहरूको कान्छो भाइ यहाँ आउँदैन त्यतिञ्जेलसम्म तिमीहरूलाई जान दिने छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","तिमीहरू मध्ये एक कान्छो भाइलाई यहाँ म भएकोमा ल्याउन जान दिन्छु अनि अरू दाज्यू-भाइहरूलाई झ्यालखानमा राख्नेछु। तिमीहरूले साँचो कुरो गरेको हो होइन हामी हेर्नेछौं तर म विश्वास गर्छु तिमीहरू जासूसहरू हौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","त्यसपछि यूसुफले तिनीहरूलाई तीन दिनसम्म झ्यालखानमा राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","तीन दिनपछि यूसुफले तिनीहरूलाई भने, “म परमेश्वरको डर मान्ने मानिस हुँ। मैले भनेको मान तब म तिमीहरूलाई बाँच्ने मौका दिन्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","यदि तिमीहरू साँच्चै नै इमानदार मानिसहरू हौ भने, तिमीहरू मध्ये एक भाइ यही झ्यालखानमा रहन सक्छ। अनि अन्य भाइहरू तिमीहरूका मानिसहरूको निम्ति अन्न लिएर फर्किन सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","तर तिमीहरूको कान्छो भाइ लिएर तिमीहरू फर्की आउनै पर्छ। तब मात्र म थाहा पाउने छु तिमीहरूले साँचो बोलिरहेका छौ अनि तिमीहरूले मर्नु पर्ने छैन।” दाज्यू-भाइहरू यसमा सहमत भए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","तिनीहरूले एकार्कामा कुरा गरे, “हामीले हाम्रो भाइ यूसुफलाई नराम्रो कुरा गरेकोले दण्ड भोगिरहेका छौं। उनले भोगेको कष्ट हामीले देख्यौं, उनले आफ्नो बचाऊको निम्ति हामीसित प्रार्थना गर्यो तर हामीले उसको प्रार्थना अस्वीकार गर्यौ। यसर्थ अहिले हामीहरूले कष्ट भोगिरहेका छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","त्यसपछि रूबेनले तिनीहरूलाई भने, “मैले त्यस केटोलाई नराम्रो केही नगर्नु भनी तिमीहरूलाई भनेको थिएँ। तर तिमीहरूले मेरो सल्लाह मानेनौ। यसर्थ अहिले उसको मृत्युको सट्टामा हामी दण्ड भोगिरहेका छौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","आफ्ना दाज्यू-भाइहरूसित कुरा गर्नको निम्ति यूसुफले एकजना अनुवादक राखेका थिए। यसर्थ उनका भाइहरूले तिनीहरूको भाषा बुझे भनी जान्न सकेनन्। तर तिनीहरूले के के कुरा गरे तिनले सुने र बुझे। ");
INSERT INTO npi2010_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","तिनीहरूको कुराले यूसुफ अत्यन्तै दुःखी भए। यसर्थ उनी तिनीहरूबाट अलग भए अनि रोए। केही क्षणपछि यूसुफ तिनीहरू समक्ष गए। उनले शिमोनलाई समाते अनि बाँधे तर अरू दाज्यू भाइहरूले हेरिरहे। ");
INSERT INTO npi2010_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","यूसुफले केही नोकरहरूलाई तिनीहरूका बोरामा अन्न भर्न लगाए। ती दाज्यू-भाइहरूले यूसुफलाई अन्नको दाम दिए। तर यूसुफले तिनीहरूले तिरेको अन्नको पैसा तिनीहरूकै अन्नको बोरामा हालिदिए। त्यसपछि यूसुफले तिनीहरूलाई घर फर्कदा बाटोमा आवश्यक पर्ने चीजहरू दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","यसर्थ ती दाज्यू-भाइहरू अन्नको बोरा गधामा लादेर त्यहाँबाट हिंडे। ");
INSERT INTO npi2010_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","त्यस रात तिनीहरू एक ठाउँमा बास बसे। तिनीहरू मध्ये एकजनाले गधालाई खुवाउँनु आफ्नो थैलो खोल्यो। अनि त्यस थैलोमा उनले तिरेको पैसा पायो। ");
INSERT INTO npi2010_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","उनले आफ्नो दाज्यू-भाइहरूलाई भने, “हेर, मैले अन्नको निम्ति दिएको पैसा यहाँ छ। कसैले मेरो थैलोमा पैसा राखेको हुन सक्छ।” त्यस समय ती दाज्यू-भाइहरूको साहस हरायो अनि डराए। तिनीहरू एक-अर्कातिर फर्किए अनि भने, “परमेश्वर हामीमाथि के गर्नु हुँदैछ?” ");
INSERT INTO npi2010_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","कनानका ती दाज्यू-भाइहरू आफ्ना बाबु याकूबकहाँ पुगे। तिनीहरूले याकूबलाई के भएको थियो प्रत्येक कुरो बताए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","तिनीहरूले भने, “त्यस देशका शासकले हामीसित निष्ठुर शब्दमा कुरा गरे। तिनले हामी जासूस हौ पनि भने। ");
INSERT INTO npi2010_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","तर तिनलाई हामीले भन्यौं हामी जासूस होइनौं, हामी इमानदार मानिसहरू हौं। ");
INSERT INTO npi2010_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","हामीले तिनलाई भन्यौं हामीहरू बाह्र भाइ छौं। हामीले आफ्नो बुबाको विषयमा भन्यौं र यो पनि भन्यौं हाम्रो सब भन्दा कान्छो भाइ कनान देशमा नै छ। ");
INSERT INTO npi2010_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“तब ती प्रशासकले हामीलाई भने, ‘तिमीहरू इमानदार मानिसहरू हौ भनी प्रमाण गर्ने एउटा उपाय छ। तिमीहरू मध्ये एकजनालाई मसित छोड अनि अरू भाइहरू आफ्ना मानिसहरूको निम्ति अन्न लिएर फर्क। ");
INSERT INTO npi2010_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","त्यसपछि तिमीहरूको कान्छो भाइ लिएर मकहाँ आऊ, तब म बुझ्‌ने छु तिमीहरू साँच्चै इमानदार मानिसहरू हौ अथवा हामीलाई नष्ट पार्ने सेनाको पक्षका तिमीहरू एउटा सेनाद्वारा हामीहरूलाई नष्ट पार्नु पठाएका हौ। यदि तिमीहरूले साँचो भनेका रहेछौ र इमानदार ठहरियौ भने आफ्नो भाइ फिर्ता पाउनेछौ। म उसलाई दिनेछु र तिमीहरू पनि हाम्रो देशमा अन्न किन्न स्वतन्त्र हुनेछौ।’” ");
INSERT INTO npi2010_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","त्यसपछि ती दाज्यू-भाइहरूले आ-आफ्नो बोराहरूबाट अन्न बाहिर निकाल्न शुरू गरे अनि प्रत्येकले आफ्नो पैसाको थैलो आफ्नो अन्नको बोरामा पाए। ती दाज्यू-भाइहरू र तिनीहरूका बाबुले पैसा देखे र खुबै डराए। ");
INSERT INTO npi2010_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","याकूबले तिनीहरूलाई भने, “के तिमी मैले मेरा सबै नानीहरू गुमाएको चाहन्छौ? यूसुफ गए, शिमोन पनि गए अनि अहिले तिमी मबाट बिन्यामीनलाई पनि छुट्‌याउन चाहन्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","तर रूबेनले आफ्नो बाबुलाई भने, “बुबा! यदि मैले बिन्यामीनलाई फर्काएर तपाईंकहाँ नल्याए मेरा दुवै छोराहरू मारिदिनु होस्। विश्वास गर्नु होस्, म बिन्यामीनलाई फर्काएर ल्याउँने नै छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","तर याकूबले भने, “म बिन्यामीनलाई तिमीहरूसित जान दिंदिन। उसको दाज्यू मर्यो अनि मेरी पत्नी राहेलबाट जन्मेको छोरो यो मात्र छ। मिश्र देश जाँदा यसलाई बाटोमा केही भए त्यस घटनाले मेरो मृत्युलाई निम्त्याउने छ। एक अति शोकाकुल बूढो मानिसलाई तिमीहरूले चिहानमा गाड्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","त्यस देशमा अनिकालको प्रकोप साह्रै थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","मानिसहरूले मिश्र देशबाट ल्याएको सबै अन्न खाइसके। जब अन्न सकियो, याकूबले आफ्ना छोराहरूलाई भने, “हामीले खानुको निम्ति अझ केही अन्न किन्न मिश्र देश जानु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","तर यहूदाले याकूबलाई भने, “तर त्यस देशको शासकले हामीलाई चेताउनी दिएकाछन्। उनले भने, ‘यदि तिमीहरूले आफ्नो भाइ मकहाँ लिएर आएनौ भने म तिमीहरूसित कुरा गर्ने छैन।’ ");
INSERT INTO npi2010_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","यदि तपाईं बिन्यामीनलाई हामीसित पठउनु हुन्छ भने, मात्र हामीहरू अन्न किन्नु जान सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","तर यदि तपाईं उसलाई पठाउन अस्वीकार गर्नु भयो भने तब हामी जानेछैनौ। त्यस मानिसले बिना बिन्यामीन हामीलाई त्यहाँ जानु होशियारी गराएकाछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएलले भने, “उसलाई तिमीहरूले अर्को पनि भाइ छ भनी किन भन्यौ? तिमीहरूले मेरो निम्ति यस्तो नराम्रो काम किन गर्यौ?” ");
INSERT INTO npi2010_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ती दाज्यू-भाइहरूले जवाफ दिए, “उनले हामी र हाम्रा कुटुम्बका विषय धेरै जान्न खोज्थ्यो र उनले हामीलाई थुप्रै प्रश्नहरू गर्यो। उनले हामीलाई सोध्यो, ‘के तिम्रा दाज्यू-भाइहरू अझ बाँचेका छन्? घरमा अझ कोही भाइहरू छन् छैनन्?’ हामीले खाली उसको प्रश्नहरूको उत्तर मात्र दियौं। हामीले जानेका थिएनौ उनले भाइ लिएर मात्र आइज भन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","त्यसपछि यूहदाले आफ्नो बाबु इस्राएललाई भने, “बिन्यामीन मसित जाओस्। म उसको हेरचाह गर्नेछु। हाम्रो निम्ति अन्न लिनु हामी मिश्र देश जानै पर्छ। यदि हामी गएनौं भनें हाम्रा नानीहरू हामीहरूसंगै मर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","म तिमीलाई विश्वास दिलाउँछु हाम्रो भाइ सुरक्षित रहनेछ। यसको लागि म सम्पूर्ण दायित्व लिने छु। यदि मैले उसलाई फर्काउन सकिन भने तिमीले मलाई सँधैं दोष दिन सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","यदि तपाईं हामीलाई अघाडी नै जान दिएको भए, अहिलेसम्म दुइ चोटी अन्न लिएर आई सक्ने थियौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","त्यसपछि तिनीहरूका बाबु इस्राएलले भने, “यदि यो सही रूपमा नै साँचो हो भने, तब बिन्यामीनलाई तिमीहरूसँगै लिएर जाऊ। तर त्यस शासकको निम्ति केही उपहारहरू लैजाऊ। हामीले आफ्नो भूमिमा उब्जाएका चीजहरूबाट केही लिएर जाऊ। केही सुगन्धित मसला, अलिकती मह, अलिकता, सुगन्धित लेप, मूर्र, पेक्ता, र हाडे-बदाम लिएर जाऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","यसपाली तिमीहरूसँग भएको पैसा भन्दा पनि दुइ गुणा वेशी लिएर जाऊ। हुन सक्छ शासकले भूल गरे होलान, यसर्थ तिमीहरूलाई फर्काई दिएको पैसा पनि लिएर जाऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","बिन्यामीनलाई त्यस मानिसकहाँ लिएर जाऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","म प्रार्थना गर्छु जब तिमी त्यो प्रशासकअघि उभिन्छौ सर्वशक्तिमान परमेश्वरले सहायता गर्नु हुनेछ। म प्रार्थना गर्छु उनले बिन्यामीन र शिमोनलाई सुरक्षित फर्कन दिनेछन। यदि यस्तो भएन भने, म फेरि पुत्र शोकले व्याकुल हुनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","यसर्थ ती दाज्यू-भाइहरूले शासकलाई दिनको निम्ति उपहार लगे। तिनीहरूले पहिलो पाली लगेको भन्दा दोबर रकम पनि लिएर गए। यस पल्ट बिन्यामीन आफ्नो दाज्यूहरूसँग मिश्र देश गए। ");
INSERT INTO npi2010_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","मिश्र देशमा यूसुफले तिनीहरूसँग बिन्यामीनलाई देखे। यूसुफले आफ्ना नोकरलाई भने, “ती मानिसहरूलाई मेरो घरमा लिएर जाऊ। एउटा पशु मार अनि पकाऊ, यिनीहरू आज दिउँसो मसित भोजन खानेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","उसलाई जे भनिएको थियो नोकरले त्यही गर्यो। उनले ती मानिसहरूलाई यूसुफको घरमा ल्यायो। ");
INSERT INTO npi2010_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","जब ती दाज्यू-भाइहरूलाई यूसुफको घरमा लगियो तिनीहरू डराए। तिनीहरूले भने, “अस्तिको पाली हाम्रो बोराहरूमा पैसा हालेर फर्काइएको थियो त्यसैकारण हामीलाई यहाँ ल्याइयो। त्यो तिनीहरूले हाम्रो विरू द्वमा अस्त्र बनाउने छन्। अनि तिनीहरू हाम्रो गधाहरू चोरेर लगी हामीलाई कमारा बनाउनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","यसर्थ ती दाज्यू-भाइहरू यूसुफको घरको नोकरहरूको मुखियाकहाँ गए। ");
INSERT INTO npi2010_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","तिनीहरूले भने, “महाशय, म प्रतिज्ञा गर्छु यो सत्य हो, अस्तिको पाली हामी अन्न किन्न आयौं। ");
INSERT INTO npi2010_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","तर जब हामीहरूले रात बिताउनु पर्ने ठाउँमा आई पुग्यौं, हामीले आफ्नो बोरा खोल्यौं तब बोराको मुखमा नै हामीहरूले तिरेको पुरै रकम पायौं। अहिले हामीले यहाँ ल्याएका छौं। ");
INSERT INTO npi2010_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","अनि अहिले फेरि पनि अन्न किन्नको निम्ति अरू रकम ल्याएका छौं। हामी जान्दैनौ कसले त्यो रकम हाम्रो बोरामा राख्यो।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","तब नोकरले उत्तर दियो, “तिमीहरू शान्तिसित बस। नडराऊ। तिमीहरूका परमेश्वर, तिमीहरूको बाबुका परमेश्वरले नै तिमीहरूको निम्ति बोरामा धन राखिदिएको हुनसक्छ। तिमीहरूले तिरेको रकम मैले पाएकै हुँ।” त्यसपछि त्यस नोकरले तिनीहरू भएको ठाउँमा शिमोनलाई ल्यायो। ");
INSERT INTO npi2010_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","तब उनले तिनीहरूलाई यूसुफको घरमा ल्याए अनि पानी दिए। तिनीहरूले तिनको खुट्टा धोए। उसले तिनीहरूको गधाहरूलाई पनी खुवायो। ");
INSERT INTO npi2010_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","यूसुफले पनि मध्य दिनको भोजन तिनीहरूसित खानेछन् भनी सुनेकोले त्यसपछि तिनीहरूले यूसुफलाई दिइने उपहार तयार राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","यूसुफ घरमा आए अनि दाज्यू-भाइहरूले तिनीहरूसित ल्याएको उपहारहरू तिनलाई दिए। त्यसपछि तिनीहरू तिनको अगाडी भूइँमा निहुरिए। ");
INSERT INTO npi2010_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","यूसुफले तिनीहरूलाई आफ्नो भलोकुशल सोधपूछ गरे। यूसुफले भने, “तिमीहरूले आफ्नो बूढो बाबुको बारेमा बताएका थियौ, तिनी अझै जीवित अनि स्वस्थ हुनुहुन्छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ती दाज्यू-भाइहरूले जवाफ दिए, “ज्यु हजुर, उहाँ जीवित हुनु हुन्छ।” अनि तिनीहरू फेरि यूसुफअघि निहुरिए। ");
INSERT INTO npi2010_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","त्यसपछि यूसुफले आफ्नो भाइ बिन्यामीनलाई देखे। (बिन्यामीन र यूसुफकी एउटै आमा हुन्।) यूसुफले भने, “तिमीहरूले मलाई बताएको कान्छो भाइ यही हो?” त्यसपछि यूसुफले बिन्यामीनलाई भने, “हे बाबू, परमेश्वरले तिमीलाई आशीर्वाद दिनु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","तब यूसुफ हतारिएर कोठा छोडे किनभने तिनी आफ्ना दाज्यू-भाइहरूको मनोभावले व्याकुल भएका थिए अनि रून चाहन्थे। तिनी आफ्नो कोठाभित्र पसे अनि रोए। ");
INSERT INTO npi2010_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","त्यसपछि यूसुफ मुख धोएर बाहिर आए। तिनले आफौंलाई वशमा राखेर भने, “अहिले भोजन गर्ने समय हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","यूसुफले एक्लै एउटा टेबलमासँगै भोजन खाए। उनका भाइहरूले अर्को एउटा टेबलमा भोजन खाए। मिश्र देशबासीहरूले अर्को टेबलमा सँगै भोजन खाए। तिनीहरूको विश्वास थियो हिब्रू मानिसहरूसँगै बसेर खानु राम्रो होइन। ");
INSERT INTO npi2010_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","यूसुफका दाज्यूभाइहरू तिनकै टेबल अघि बसेका थिए। तिनीहरू जेठादेखि कान्छासम्म उमेर अनुसार लहरै बसेका थिए। के भइरहेको छ सबै दाज्यूभाइहरूले एका-अर्कामा आश्चर्यमानी हेरिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","नोकरहरूले यूसुफको टेबलबाट भोजन ल्याएर तिनीहरूलाई दिन्थे। तर ती नोकरहरूले बिन्यामीनलाई अरू दाज्यूभाइहरूलाई भन्दा पाँच गुणा वेशी दिन्थे। ती दाज्यूभाइहरू नअघाउञ्जेलसम्म यूसुफसँगै खाए। ");
INSERT INTO npi2010_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","तब यूसुफले आफ्नो नोकरलाई हुकुम गरे! यूसुफले भने, “यी मानिसहरू बोराहरूमा जति अन्न लिएर जान सक्छन् त्यति धेरै अन्न हालिदेऊ। अनि प्रत्येक मानिसको पैसा उसको अन्नको बोराभित्र हालिदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","कान्छो भाइको थैलोमा पैसा हालिदेऊ। तर उसको थैलोमा मेरो चाँदीको कचौरा पनि हालिदेऊ।” यूसुफको सेवकले उसलाई जस्तो गर्नु भनिएको थियो त्यस्तै गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","अर्कोदिन, एका बिहानै, सबै दाज्यू-भाइहरूलाई तिनीहरूको गधा समेत फर्काई आफ्नो देशतिर पठाइयो। ");
INSERT INTO npi2010_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","जब तिनीहरूले शहर नाघेका थिए यूसुफले आफ्नो नोकरलाई भने, “जाऊ अनि तिनीहरूलाई पछ्याऊ। तिनीहरूलाई रोकेर भन, ‘हामी तिमीहरूसित राम्रो थियौं, तर किन तिमीहरू हाम्रो निम्ति नराम्रो भयौ? मेरा मालिकको चाँदीको कचौरा किन चोर्यौ? ");
INSERT INTO npi2010_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","मेरा मालिकले यसै कचौराबाट पिउँछन् अनि गुप्तकुराहरू जान्नुको लागि यसलाई प्रयोग गर्छन्। तिमीहरूले जे गर्यौ त्यो साँच्चै धेरै नराम्रो हो।’” ");
INSERT INTO npi2010_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","यसर्थ त्यस नोकरले यूसुफको आज्ञा मानी सवारमा चढेर गयो अनि ती दाज्यू-भाइहरूलाई रोक्यो। यूसुफले तिनीहरूलाई जे भन्न लगाएको थिए त्यही उसले भन्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","तर ती दाज्यू-भाइहरूले त्यस नोकरलाई भने, “किन हजूरका, शासकले यी कुराहरू गर्छन्। हामीले त्यस्तो केही गर्दैनौ। ");
INSERT INTO npi2010_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","हामीले अघिल्लो पल्ट हाम्रो बोराहरूमा जुन पैसा पाएका थियौं त्यो पनि फर्काएर ल्यायौं। यसर्थ हामीले तिम्रो मालिकको घरबाट कुनै सुन अथवा चाँदी चोरेका छैनौं। ");
INSERT INTO npi2010_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","यदि त्यो चाँदीको कचौरा हामी मध्ये कसैको थैलामा भेटियो भने त्यो मरोस्। तिमीहरू आफैंले उसलाई मार्न सक्छौ अनि तब हामी तिमीहरूको कमारा हुनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","नोकरले भने, “तिमीहरूले भने झैं गर्नेछौं। तर म मानिसको हत्या गर्दिन। जुन मानिससँग म चाँदीको कचौरा भेट्छु त्यो मानिस मेरो कमारा हुनेछ, तर अरू मानिसहरू स्वतन्त्र भएर जानेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","तब प्रत्येक भाइले आफ्नो थैलो छिटो-छिटो भूइँमा राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","त्यस नोकरले बोराहरू निरीक्षण गर्न थाल्यो। उनले सबभन्दा जेठोबाट शुरू गरेर कान्छोसम्म निरीक्षण गर्यो। उनले बिन्यामीनको बोरामा चाँदीको कचौरा भेट्यो। ");
INSERT INTO npi2010_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ती दाज्यू-भाइहरू अत्यन्तै दुःखी भए। तिनीहरूले आफ्नो दुःख प्रदर्शनगर्न आफ्ना लुगाहरू च्याते। तिनीहरूले बोराहरू आफ्नो-आफ्नो गधमा चढाए र शहरतिर फर्के। ");
INSERT INTO npi2010_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा अनि उसका दाज्यू-भाइहरू यूसुफको घरमा गए। यूसुफ त्यतिञ्जेल त्यही थिए। ती दाज्यू-भाइहरू भूइँमा उनी अघि निहुरिए। ");
INSERT INTO npi2010_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","यूसुफले तिनीहरूलाई भने, “तिमीहरूले किन यस्तो कुरा गर्यो? के तिमीहरूलाई थाह छैन म जस्तो मानिससित अगमवाणी गर्ने अभ्यास अनि यस्तो वस्तु पत्तो लगाउने क्षमता छ?” ");
INSERT INTO npi2010_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदाले भने, “व्याख्या गर्ने कुनै बाटो छैन। हामी दोषी छैनौ भनी साबित गर्ने हामीसित कुनै सबूत नै छैन। परमेश्वरले मात्र दोषी मानिस पत्तो लगाउनु भएको छ। यसर्थ हामी दुवै अनि जसको थैलामा कचौरा भेटियो कमारा कै रूपमा सेवा गर्न तयार छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","तर यूसुफले भने, “म तिमीहरू सबैलाई कमारा बनाउँदिन। त्यही मानिस मात्र कमारा हुनेछ जसले कचौरा चोरी गरेको छ। अरू तिमीहरू शान्तिसितै आफ्ना बाबु भएको भूमिमा जान सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","त्यसपछि यहूदा यूसुफको नजिक गए अनि भने, “महाशय, दया गरी मलाई स्पष्टसित केही भन्न दिनु होस्। दया गरी मसित नरिसाउनु होस्। म जान्दछु तपाईं फिरऊन राजा सरह हुनुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","हामी अघिल्लो पाली यहाँ हुँदा तपाईंले सोधनु भयो, ‘के तिम्रो बाबु अथवा दाज्यू-भाइहरू छन्?’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","हामीले उत्तर दियौं, ‘हाम्रा बाबु हुनुहुन्छ, उहाँ बूढो मानिस हुनुहुन्छ। अनि हाम्रो सानो भाइ पनि छ। हाम्रा बाबुले त्यसलाई खुबै प्रेम गर्नु हुन्छ कारण त्यो उहाँको वृद्ध अवस्थामा जन्मेको हो। त्यस सानो छोराको दाज्यू पनि मर्यो। यसर्थ त्यस आमाबाट जन्मेर बाँचेको छोरो त्यो मात्र हो। हाम्रा बाबुले उसलाई खुबै माया गर्नुहुन्छ।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","तब तिमीले हामीलाई भनेका थियौ, ‘त्यसो भए त्यस भाइलाई मकहाँ लिएर आऊ।’ म उसलाई हेर्न चाहन्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","अनि हामीले तपाईंलाई भनेका थियौं, ‘त्यो भाइ आउन सक्तैन। उनले बाबुलाई छोड्न सक्तैन। यदि उसको बाबुले यसलाई पनि गुमाउनु परे तिनी अत्यन्तै शोकाकुल हुनेछन्। तिनी त्यही शोकमा मर्न पनि सक्छन्।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","तपाईंले भन्नु भएको थियो, ‘तिमीले आफ्नो कान्छो भाइलाई मकहाँ अवश्य ल्याउनु पर्छ, होइन भने तिमीहरूले अन्न पाउँने छैनौ।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","यसर्थ हामी आफ्ना बाबु भएको ठाउँमा गयौं अनि तपाईंले बताउनु भएका कुराहरू सबै उनलाई बतायौं। ");
INSERT INTO npi2010_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“पछि हाम्रा बाबुले भन्नुभयो, ‘हाम्रो निम्ति तिमीहरू फेरि गएर अन्न किन।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","अनि हामीले आफ्नो बाबुलाई भन्यौ, ‘हामी आफ्नो कान्छो भाइ नलिइ जान सक्तैनौ। शासकले भनेका छन् जबसम्म उनी हाम्रा कान्छो भाइलाई देख्दैनन् तबसम्म हामीलाई अन्न बेच्ने छैनन्।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","तब हाम्रा बाबुले हामीलाई भन्नुभयो, ‘तिमीहरूलाई थाहा छ मेरी पत्नी राहेलले मेरो निम्ति दुइवटा छोरा जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","एकजनालाई मैले टाढा पठाएँ अनि जंङ्गली पशुहरूले उसलाई मार्यो। अनि अहिलेसम्म मैले उसलाई देखेको छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","अनि यदि अर्को छोरो पनि तिमीहरूले लगेर यदि उसलाई केही खतरा भए, तब मैले मेरो काल पर्खनु पर्दैन, त्यो मेरो निम्ति मृत्यु नै हुनेछ।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","अब, सोच्नु होस् यदि हामी त्यसलाई नलिई गए के हुन्छ होला। हाम्रा बाबुको जीवनको महत्व पूर्ण अङ्ग नै यही केटो हो। ");
INSERT INTO npi2010_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","यदि हाम्रा बाबुले त्यस केटोलाई हामीसित नदेखे तिनी मर्नेछन् र त्यसमा हामी दोषी हुनेछौं। हामी आफ्ना शोकाकुल बाबुलाई चिहान भित्र पठाउने छौं। ");
INSERT INTO npi2010_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“त्यस केटोको जिम्मादारी मैले लिएँ। मैले मेरो बाबुलाई भनें, ‘यदि मैले त्यस केटोलाई फर्काई ल्याइन भने तपाईंले मलाई सारा जीवनभरि दोष दिन सक्नु हुन्छ।’ ");
INSERT INTO npi2010_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","यसर्थ म तपाईंसित बिन्ती गर्छु, त्यस केटोलाई आफ्नो दाज्यूहरूसित फर्कन दिनु होस्, अनि म बस्छु र तपाईंको कमारो बनिन्छु। ");
INSERT INTO npi2010_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","यदि केटो मसँगै फर्किदैन भने म आफ्नो अनुहार बुबालाई देखाउन सक्दिनँ। यसले के आपत्ति मेरो बुबामाथि आउनेछ, म हेर्न भयभीत छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","यूसूफले अब केही क्षण पनि आफूलाई नियन्त्रणमा राख्नु सकेन। तिनी त्यहाँ भएका सबै मानिसहरूको अघाडी रोए। यूसुफले भने, “प्रत्येकलाई यो ठाउँ छोडी जानु भन।” यसर्थ मानिसले त्यो ठाउँ छोडी दिए। खाली ती दाज्यू-भाइहरू मात्र यूसुफसित बसे। त्यसपछि यूसुफले तिनी को हुन् भने। ");
INSERT INTO npi2010_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","यूसुफ रोइरहे अनि फिरऊनको घरमा भएका जन्मै मिश्र देशीहरूले सुने। ");
INSERT INTO npi2010_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","यूसुफले उनका दाज्यू-भाइहरूलाई भने, “म तिमीहरूका भाइ यूसुफ हुँ। के मेरा बाबु कुशल हुनुहुन्छ?” तर दाज्यू भाइहरूले तिनलाई उत्तर दिएनन्। तिनीहरू अलमल्ल परे अनि घबराएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","यसर्थ यूसुफले आफ्ना दाज्यू-भाइहरूलाई फेरि भने, “मकहाँ आऊ। म बिन्ती गर्छु, तिमीहरू मेरो नजिक आओ” यसर्थ तिनीहरू यूसुफको नजिकमा गए। अनि उनले तिनीहरूलाई भने, “म तिमीहरूको भाइ हुँ। म त्यही भाइ हुँ जसलाई तिमीहरूले मिश्र देशमा कमारोको रूपमा बेचेका थियौ। ");
INSERT INTO npi2010_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","अहिले चिन्ता नगर। तिमीहरू आफैसित आफूले गरेको कार्यको निम्ति नरिसाऊ। मलाई यहाँ ल्याउनमा परमेश्वरको एउटा योजना हो। म यहाँ तिमीहरूको जीवन बचाउनुको निम्ति छु। ");
INSERT INTO npi2010_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","यस भयंकर अनिकाल दुइ वर्षसम्म चल्यो अनि अझै पाँच वर्षसम्म कुनै अन्न-बाली तथा उद्भिदको उब्जाऊ बिना अनिकाल चलिरहने छ। ");
INSERT INTO npi2010_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","यसर्थ तिमीहरूका मानिसहरूलाई बचाउनको निम्ति परमेश्वरले मलाई यस देशमा तिमीहरूभन्दा अगि पठाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","यसर्थ मलाई यहाँ पठाएकोमा तिमीहरूको कुनै दोष छैन। यो परमेश्वरको इच्छा थियो। परमेश्वरले मलाई फिरऊनको बुबा जस्तै बनाउनु भयो। म मिश्रको सम्पूर्ण भूमि अनि फिरऊनको घरको राज्यपाल हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","यूसुफले भने, “चाँडो गर अनि मेरा बाबुकहाँ जाऊ। उनलाई भन उनका छोरो यूसुफले यो समाचार पठाएको छ।” परमेश्वरले मलाई मिश्रदेशको शासक बनाउनु भएको छ। यसर्थ मकहाँ आउनु। अबेर नगरी। अहिले नै आउनु। ");
INSERT INTO npi2010_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","तिमीहरू गोशेनमा मेरो नजिकै बस्न सक्छौ। तिमी, तिमीहरूका बाल-बच्चाहरू, नाति-नातिनाहरू साथै सबै तिम्रा पशुहरूलाई यहाँ स्वागत गरिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","म आउँदो पाँच वर्षसम्म हुने अनिकालमा तिमीहरूको हेरचाह गर्नेछु। यसर्थ तिमीहरू र तिमीहरूका परिवारहरूले आफूसँग भएका कुनै चीज पनि हराउने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","यूसुफले आफ्ना दाज्यू-भाइहरूसित कुरा गरी रहे। उनले भने, “अब तिमीहरू जान्नेछौ म साँच्चै नै यूसुफ हुँ र तिमीहरूको भाइ बिन्यामीनले जान्दछ म यूसुफ नै हुँ। म तिमीहरूको भाइ तिमीहरूसितै बात गरी रहेको छु। ");
INSERT INTO npi2010_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","यसर्थ मेरा बुबालाई मैले मिश्र देशमा पाएको सम्मानको विषयमा भनिदेऊ। तिमीहरूले यहाँ देखेको प्रत्येक कुरा सुनाई देऊ। अब झट्टै जाऊ अनि मेरा बुबालाई यहाँ लिएर आऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","त्यसपछि तिनको भाइ बिन्यामीनसित यूसुफले आलिङ्गन गरे अनि तिनीहरू दुवैजना रून शुरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","त्यसपछि यूसुफले आफ्ना सबै दाज्यू-भाइहरूलाई म्वाइँ खाए अनि तिनीहरूको निम्ति रोए। त्यसपछि उनका दाज्यू-भाइहरू उनीसँग कुरा गर्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","फिरऊनले थाहा पाए यूसुफका दाज्यू-भाइहरू त्यहाँ आएका थिए। फिरऊको राजमहलमा प्रत्येकले यो खबर चाल पाए। फिरऊन र उनका सेवकहरू यो खबर सुनेर खुशी भए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","यसकारण फिरऊनले यूसुफलाई भने, “तिम्रो दाज्यू-भाइहरूलाई भन तिनीहरूलाई जति अन्न चाहिन्छ लिएर कनान देशमा जाऊन। ");
INSERT INTO npi2010_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","आफ्ना दाज्यू भाइहरूलाई भन तिनीहरू आफ्नो बाबु र परिवारहरू लिएर यहाँ मकहाँ आउन्। जीवन निर्वाहको निम्ति म तिनीलाई यहाँको सब भन्दा असल भूमि दिनेछु अनि तिनीहरूले सबभन्दा असल भोजन गर्ने छन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","त्यसपछि फिरऊनले भने, “तिम्रा दाज्यू-भाइहरूलाई यहाँ भएका गाडीहरू मध्ये सबभन्दा असल चाँहि दिनु। तिनीहरूलाई भन ती गाडीहरूमा तिनीहरू कनान गएर आफ्ना बाबु र जहान, छोरा-छोरीहरू लिएर आउनु। ");
INSERT INTO npi2010_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","आफ्ना ती सर-समानहरूको फिक्री नगर जो तिमी आफूसंगै ल्याउन सक्दैनौ किनभने मिश्रका सर्वोत्तम वस्तुहरू तिनीलाई दिइनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","यसर्थ इस्राएलका छोराहरूले यसो गरे। फिरऊनले प्रतिज्ञा गरे झैं यूसुफले तिनीहरूलाई गाडीहरू दिए। तिनीहरूको यात्राको निम्ति प्रशस्त भोजन पनि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","यूसुफले तिनीहरू प्रत्येकलाई सुन्दर लुगाको जोडा दिए। तर बिन्यामीनलाई चाँहि तिनले राम्रो लुगाले बनिएको पाँच जोडा दिए। बिन्यामीनलाई तिनले चाँदीको तीन सय सिक्का पनि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","यूसुफले आफ्ना बाबुको निम्ति उपहारहरू पनि पठाए। तिनले दश गधामा लदाएर मिश्र देशको राम्रा-राम्रा समानहरू पठाइ दिए अनि आफ्ना बाबु लिएर आउनको लागि दशवटा छाउरी गधामा अन्न, रोटी र अरू भोजनहरू पूरा लादेर पठाए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","त्यसपछि यूसुफले आफ्ना दाज्यू-भाइहरूलाई जाने अनुमति दिए। अनि जब तिनीहरू जान लागेका थिए यूसुफले तिनहरूलाई भने, “सरासरी घर जानु बाटोमा कतै लडाइँ नगर्नु।” ");
INSERT INTO npi2010_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","यसर्थ ती दाज्यू-भाइहरू मिश्र देश छोडी तिनीहरूका पिता भएका देश कनानमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","दाज्यू-भाइहरूले उनलाई भने, “बाबु, यूसुफ अझसम्म जीवित छ। अनि त्यो समस्त मिश्र देशको शासक छ।” तिनीहरूका बाबुले के सोच्नु पर्ने केही जानेन। प्रथम त, तिनले आफ्ना छोराहरूको कुरामा विश्वास गरेनन्। ");
INSERT INTO npi2010_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","तर तिनीहरूले उनलाई यूसुफले भनेको प्रत्येक कुरा बताए। अनि यूसुफले आफ्नो बाबुलाई मिश्र देश लिएर आउनु भनी पठाएको गाडीहरू याकूबले देखे। तिनी उत्तेजित र अत्यन्तै खुशी भए। ");
INSERT INTO npi2010_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","इस्राएलले भने, “अब म तिमीहरूलाई विश्वास गर्छु। मेरो छोरो यूसुफ अझ जीवित छ। मेरो मृत्युअघि म उसलाई भेटून जानेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","यसर्थ इस्राएलले मिश्र देशको यात्रा शुरू गरे। पहिला तिनी बर्शेबा गए। त्यहाँ तिनले आफ्नो बुबा इसहाकका परमेश्वरलाई बलि चढाए। उनले परमेश्वरको आराधना गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","त्यस रात परमेश्वर इस्राएलसित सपनामा बोल्नु भयो। परमेश्वरले भन्नुभयो, “याकूब, याकूब।” अनि इस्राएलले उत्तर दिए, “म यहाँ छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","तब परमेश्वरले भन्नुभयो, “म परमेश्वर हुँ, तिम्रा बाबुको परमेश्वर। मिश्रमा जान नडराऊ मिश्रमा म तिमीलाई ठूलो जातिहरू बनाउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","म तिमीसँगै मिश्र जानेछु, तर म आफैंले निश्चय नै मिश्रबाट तिमीलाई फर्काएर ल्याउनेछु। जब तिमी मर्छौ तिम्रो आँखा आफ्नो हातले बंद गरिदिने यूसुफ हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","त्यसपछि याकूबले बेर्शेबा छोडे र मिश्रको यात्रा गरे। उसका छोराहरू, पत्नीहरू र तिनीहरूका सबै नानीहरू मिश्रमा ल्याए। फिरऊनले पठाएको गाडीहरूमा तिनीहरूले यात्रा गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","तिनीहरूसित गाई-वस्तुहरू र मिश्रमा तिनीहरूसित भएका सबै चीजबीजहरू थिए। यसर्थ आफ्नो सबै नानीहरू र परिवारसित मिश्र गए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","तिनीसित तिनका छोरा-छोरीहरू र नाती-नातिनीहरू थिए। तिनका सबै परिवार तिनीसित मिश्रमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","तिनीसित मिश्र जाने छोरा-छोरी तथा परिवार यिनै हुनः रूबेन याकूबका जेठो छोरो थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेनका छोराहरूः हनोक, पल्लु, हेस्रोन अनि कर्मी थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमोनका छोराहरूः यमूएल, यामीन, ओहद, याकीन अनि सोहर र कनानी पनि थिए। (शाओल कनानी पत्नीबाट जन्मेका शिमोनका थिए।) ");
INSERT INTO npi2010_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीका छोराहरूः गेर्शोन, कहात र मरारी थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाका छोराहरूः एर, ओनान, शेला, पेरेस अनि जेरह थिए। (एर र ओनान कनानमा हुँदै मरे।) पेरेसका छोराहरूः हेस्रोन, अनि हामूल थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साकारका छोराहरूः तोला, पुवा, योब र शिम्रोन थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलूनका छोराहरूः सेरेद, एलोन अनि यहलेल थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","रूबेन, शिमोन, लेवी, यहूदा, इस्साकार अनि जबूलून याकूबकी पत्नी लेआबाट जन्मेका छोराहरू थिए। लेआले यी छोराहरू पद्यानआराममा जन्माएकी थिइन्। तिनकी एउटी दीना नाउँ भएकी छोरी पनि थिइन्। यस परिवारमा तेत्तीस जना मानिसहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादका छोराहरूः यिम्ना, यिश्वा, यिश्वी, र बरीआ थिए। तिनीहरूकी बहिनी सेरह, तिनीहरूसित बरीआका हेबेर र मलकियल नाउँ भएका छोराहरू पनि थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","अशेरका छोराहरूः यिम्ना, यिश्वा, यिश्वी र बरीआ थिए। तिनीहरूकी बहिनी सेरह, तिनीहरूसित बरिआका हेवेर र मलकियल नाउँ भएका छोराहरू पनि थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","यी सब याकूबकी पत्नी लेआकी कमारी जिल्पाबाट जन्मिएका थिए। (जिल्पा लाबानले आफ्नी छोरी लेआलाई दिएको कमारी हो।) त्यस परिवारमा सोह्र जना मानिसहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकूबसित उसकी पत्नी राहेलबाट जन्मेको छोरो बिन्यामीन थियो। (यूसुफ पनि राहेलबाट नै जन्मेको हो तर ऊ अघिदेखि नै मिश्र देशमा थियो।) ");
INSERT INTO npi2010_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","मिश्रमाहुँदा यूसुफको दुइवटा छोराहरू जन्मिएः मनश्शे अनि एप्रैम थिए। ओन शहरका एक जना पूजाहारी पोतीफेराकी छोरी आसनतले यूसुफका लागि यी छोराहरू जन्माइन्। ");
INSERT INTO npi2010_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बिन्यामीनका छोराहरूः बेला, बेकेर, अश्बेल, गेरा, नामान, एही शेश, मुप्पीम, हुप्पीम अनि आर्द थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","यिनीहरू याकूबकी पत्नी राहेलबाट जन्मेका छोराहरू थिए। यस परिवारमा चौध जना मानिसहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","हुशीम दानका छोरो थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्तालीका छोराहरूः यहसेल, गुनी, येसेर अनि शिल्लेम थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","याकूब र बिल्हाबाट जन्मेका छोराहरू तिनीहरू नै थिए। (बिल्हा लाबानले आफ्नी छोरी राहेललाई पठाएको कमारी थिइ।) यस परिवारमा सात जना मानिसहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","याकूबका सन्तानहरू जम्मा छयसठ्ठी जना थिए जो तिनीसित मिश्र देश गएका थिए। (यस संख्यामा याकूबका छोरा बुहारीहरू परेका छैनन्।) ");
INSERT INTO npi2010_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","त्यसमा यूसुफका दुइजना छोराहरू पनि थिए जो मिश्र देशमा जन्मेका थिए। यसर्थ मिश्र देशमा याकूब परिवारका मानिसहरू जम्मा सत्तरी जना थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकूबले यूसुफसित कुराकानी गर्न यहूदालाई पहिले पठाए। गोशेन भूमिमा यहूदा यूसुफसित कुरा गर्न गयो। त्यसपछि याकूब र उनका अन्य मानिसहरू त्यस भूमिमा गए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","यूसुफले थाहा पाए तिनका बाबु आउँदै हुनु हुन्छ। यसर्थ यूसुफले इस्राएल तथा तिनका बाबुलाई गोशेनमा भेट्न जान रथ तयार पारे। जब यूसुफले आफ्नो बाबुलाई भेटे र धेरै बेरसम्म आलिंगन गरे र धेरै बेरसम्म रोए। ");
INSERT INTO npi2010_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","तब इस्राएलले यूसुफलाई भने, “अब म शान्तिसित प्राण त्याग्न सक्छु। मैले तेरो मुख देखें अनि बुझें तँ जिउँदै छस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","यूसुफले आफ्नो दाज्यू-भाइ तथा बाबुका अरू परिवारलाई भने, “म जान्छु र फिरऊनलाई तिमीहरू यहाँ आएको कुरा गर्छु। म फिरऊनलाई भन्छु ‘मेरा दाज्यू-भाइ र मेरो बाबुका अरू सन्तानहरूले कनान देश छोडेर यहाँ मकहाँ आएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","यी परिवारहरू गोठालाहरू थिए। तिनीहरूले संधै भेडा र गाई-गोरूहरू पाल्थे। तिनीहरूसित भएका गाई-वास्तुहरू सबै लिएर आएका छन्।’ ");
INSERT INTO npi2010_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","जब फिरऊनले बोलने छन् र तिमीहरूलाई तिनले सोध्ने छन्, ‘तिमीहरूले के काम गर्छौ?’ ");
INSERT INTO npi2010_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","तिमीहरूले उनलाई भन्नु, ‘हामी भेडा गोठालाहरू हौं। जीवनभरि हामी भेडा गोठाला थियौं। अनि हामी भन्दाअघि हाम्रा पुर्खाहरू पनि भेडागोठाला नै थिए।’ तब फिरऊनले तिमीहरूलाई गोशेन भूमिमा बस्ने अनुमति दिनेछन्। मिश्र देशीहरूले गोठालाहरू मन पराउँदैनन्, यसर्थ तिमीहरू गोशोनमा बस्दा राम्रो हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","यूसुफ फिरऊनकहाँ गए अनि भने, “मेरा बाबु, दाज्यू-भाइहरू र सबै तिनीहरूका परिवारहरू कनान देश छाडेर तिनीहरूसित भएका सबै पशुहरू तथा प्रत्येक चीज लिएर यहाँ मकहाँ आएका छन्। अहिले तिनीहरू गोशेन भूमीमा छन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","फिरऊनकहाँ जान यूसुफले अरू आफ्ना पाँच दाज्यू-भाइहरूलाई रोजे। ");
INSERT INTO npi2010_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फिरऊनले ती दाज्यू-भाइहरूलाई भने, “तिमीहरूको काम धन्धा के हो?” तिनीहरूले फिरऊनलाई भने, “हजूर, हामीहरू भेडा गोठालाहरू हौं। अनि हाम्रा अघिका पिता-पुर्खाहरू पनि भेडा गोठालाहरू नै थिए।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","तिनीहरूले फिरऊनलाई भने, “कनान देशमा अनिकालको घोर प्रकोप परेको छ। हाम्रा पशुहरूको निम्ति त्यहाँ कुनै भूमिमा घाँस छैन। यसर्थ हामी यस भूमिमा बस्न भनी आएका छौ र तपाईलाई अनुमतिको निम्ति बिन्ती गर्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","तब फिरऊनले यूसुफलाई भने, “तिम्रा बाबु अनि दाज्यू-भाइहरू तिमी कहाँ आएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","तिनीहरूका लागि बस्ने कुनै ठाउँ मिश्रमा तिमी छान्न सक्छौ। आफ्ना बुबा र भाइहरूको लागि असल ठाउँ छानिदेऊ। गोशेनको भूमिमा तिनीहरूलाई बस्ने अनुमति देऊ। यदि तिनीहरूमध्ये कोही राम्रा गोठाला छन् भनी तिमीलाई थाहा छ भने तिनीहरूलाई मेरा पशुहरू हेर्ने जिम्मा देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","तब यूसुफले आफ्ना बाबु याकूबलाई फिरऊनसित भेट गर्न बोलाए। याकूबले फिरऊनलाई आशीर्वाद दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","अनि फिरऊनले उनलाई भने, “तिम्रो उमेर कति हो?” ");
INSERT INTO npi2010_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूबले फिरऊनलाई भने, “मेरो जीवन छोटो अनि दुःखले भरिएको छ। म केवल एक सय तीस वर्ष पुगेको छु। यो मेरा पुर्खाहरूसित तुलना गर्दा केही होइन जब तिनीहरू यस धर्तीमा बाँचेका थिए।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकूबले फिरऊनलाई आशीर्वाद दिए अनि उनले फिरऊनबाट विदा लिए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","यूसुफले फिरऊनको निर्देशन अनुसार आफ्ना बुबा र दाज्यू-भाइहरूलाई मिश्रको सबै भन्दा मलिलो भूमि रामसेसेमा राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","यूसुफले आफ्ना बाबु, दाज्यू-भाइ तथा तिनीहरूका मानिसहरूलाई चाहिएको खाद्य पदार्थहरू पनि दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","अनिकालको समयले अझ भयंकर रूप धारण गर्यो। त्यस भूमिमा कतै खाद्य वस्तुहरू थिएन। अनिकालको समयले गर्दा मिश्र र कनानको अवस्था सोचनीय भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","त्यस भूमिका मानिसहरूले धेरै भन्दा धेरै अन्न किन्न थाले, यूसुफले रूपियाँ जम्मा गरे अनि फिरऊनको महलमा ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","केही समय पछि मिश्र र कनान देशका मानिसको पैसा सकियो। तिनीहरूले आफ्नो सबै पैसा अन्न किनेरै खर्च गरे। यसर्थ मिश्रका मानिसहरूले यूसुफलाई भने, “हाम्रो पैसा सकियो हामीलाई खाने कुरा दिनुहोस्। यदि हामीले खान पाएनौ भने तपाईंको अघि नै हामी मर्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","तर यूसुफले भने, “तिमीहरूले आफ्नो गाई-वस्तुहरू मलाई देऊ तब म अन्न दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","यसर्थ मानिसहरूले आफ्नो सबै पशुहरूको बदलीमा खाद्यान्न किने। त्यस वर्ष यूसुफले मानिसहरूबाट भेडा, बाख्रा, घोडा र गधा लिए अनि तिनीरूलाई खाद्यान्न दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","तर अर्को वर्ष मानिसहरूसित अन्न किन्ने पैसा तथा पशुहरू केही थिएन। यसर्थ मानिसहरू यूसुफकहाँ गए अनि भने, “तपाईं जान्नु हुन्छ हामीसित पैसा छैन अनि पशुहरू पनि तपाईंकै भए। यसर्थ हामीसित यस घडी हाम्रो जीवन र जग्गा जमीनबाहेक केही छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","अब हामी तपाईंको नजरको सामुनने मर्नेछौं। तर यदि तपाईंले हामीलाई अन्न दिनु भयो भने हामी फिरऊनलाई जमीन दिनेछौ र उनको कमारा कमारी हुनेछौं। हामीलाई अन्नको बीउ दिनोस् त्यसलाई छरेर हामी अन्न उब्जाउन सक्छौं। त्यसो भए हामी मर्दैनौ र बाँच्छौ अनि हाम्रो निम्ति भूमिले फसल फेरि उब्जाउनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","यसर्थ यूसुफले फिरऊनको निम्ति मिश्र देशको सबै भूमि किने। सबै मानिसहरूले यूसुफलाई भूमि बेचे। अनिकाल लागेको हुनाले तिनीहरूले त्यसो गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","जहाँ सम्म साधारण मानिसहरूको कुरा छ, उनले तिनीरूलाई सम्पूर्ण मिश्रका शहरहरूमा घुमफिर गर्ने अनुमति दिए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","पूजाहारीहरूको भूमि मात्र यूसुफले फिरऊनको निम्ति किनेनन्। पूजाहारीहरूले आफ्नो भूमि बेच्न परेन कारण तिनीहरूको कार्यको निम्ति फिरऊनले तिनीहरूलाई पैसा दिन्थे। यसर्थ अन्न किन्दा तिनीहरूले त्यही पैसा खर्च गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","यूसुफले मानिसहरूलाई भने, “मैले फिरऊनका निम्ति तिमीहरूको भूमि ल्याएँ। यसर्थ म तिमीहरूलाई बीउ दिन्छु जसले गर्दा तिमीहरू त्यसलाई खेतमा छर्न सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","“फसल उठाउँदा तिमीहरू उब्जनीको पाँचौ हिस्सा फिरऊनलाई दिनु पर्छ। आफ्नो निम्ति तिमीहरूले अर्को फसलको निम्ति बीउ चार भाग राख्न सक्छौं। आफ्नो खेतमा र अन्न उब्जाउन सक्छौ। अब तिमीहरू आफ्नो परिवार र नानीहरूलाई खुवाउन सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","मानिसहरुले भने, “हामी फिरऊनको कमारा हुन खुशी छौं। कारण तपाईंले हामीलाई हाम्रो जीवन दान दिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","यसर्थ यूसुफले त्यस समयमा एउटा नियम बनाए जुन आजसम्म चलिरहेको छ। त्यस नियमले यसो भन्छ “भूमिबाट उब्जेको प्रत्येक चीजको पाँच भागमा एक भाग चाहि फिरऊनको हो। पूजाहारीहरूले राखेको भूमि मात्र फिरऊनको होइन नत्र मिश्र देशको पुरै भूमि फिरऊनको हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएल मिश्र देशको गोशेन भूमिमा बसे। तिनका परिवारहरू बढेर अति विशाल भयो। तिनीहरूले मिश्रमा भूमि पाए अनि राम्रो जीवन बिताए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकूब मिश्र देशमा सत्र वर्षसम्म बसे। यसर्थ तिनी एक सय सैंतालीस वर्षका भए। ");
INSERT INTO npi2010_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","इस्राएलले आफ्नो मृत्युको समय आयो भनी थाहा पाए। यसर्थ तिनले आफ्नो छोरो यूसुफलाई बोलाएर भने, “यदि तैंले मलाई साँच्चै प्रेम गर्छस् भने आफ्नो हात मेरो तिघ्रामुनि राखेर कसम खा। मलाई वचन दे जे म भन्छु त्यही मान्छु भनेर म प्रति तँ साँचो हो। जब म मर्छु मलाई मिश्र देशमा नगाड। ");
INSERT INTO npi2010_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","मलाई त्यही जग्गामा गाड्नु जहाँ मेरा पिता-पुर्खाहरु गाडिएका छन्। मलाई मिश्रबाट बाहिर लगेर हाम्रा परिवारको चिहान घारीमा गाड्नु।” यूसुफले भने, “तपाईंले जे भन्नु हुन्छ म त्यही गर्छु म वचन दिन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","तब याकूबले भने, “कसम खाऊ।” तब यूसुफले कसम खाए अनि भने उनले त्यही गर्नेछन् जे उनले गर्नु भनि कसम खाए। तब इस्राएल आफ्नो पलङ्गमाथि अडेसिएर शिर निहुराए। ");
INSERT INTO npi2010_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","केही समय पछि यूसुफले थाहा पाए उनका बाबु सिकिस्त बिमार थिए। यसर्थ यूसुफले आफ्ना छोराहरू मनश्शे र एप्रैमलाई लिएर बाबुकहाँ गए। ");
INSERT INTO npi2010_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","जब त्यहाँ यूसुफ पुगे कसैले इस्राएललाई भने, “तिम्रो छोरो यूसुफ तपाईंलाई भेट्न आएका छन्।” इस्राएल खुबै दुर्बल भएका थिए तापनि तिनले आफ्नो ओछ्यानबाट उठेर बस्ने चेष्टा गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","तब इस्राएलले यूसुफलाई भने, “सर्वशक्तिमान परमेश्वरले कनान देशको लूजमा मलाई दर्शन दिनु भयो। परमेश्वरले त्यहाँ मलाई आशीर्वाद दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","परमेश्वरले भन्नुभयो, ‘म तिम्रो एउटा विशाल परिवार बनाउनेछु। म तिमीलाई धेरै नानीहरू दिनेछु अनि तिमी महान व्यक्ति हुने छौ। तिम्रा परिवारले यो भूमिमा संधैको निम्ति अधिकार जमाउनेछन्।’ ");
INSERT INTO npi2010_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","अनि अहिले तिम्रा दुइ छोराहरू छन्। यी छोराहरू म मिश्रमा आउनुभन्दा अघि नै यहाँ जन्मेका हुन्। तिम्रा एप्रैम र मनश्शे छोराहरू मेरो निम्ति रूबेन र शिमोन जस्तै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","यसर्थ यी दुइ भाइ मेरा छोराहरू हुनेछन्। मेरो प्रत्येक चीजमा नै तिनीहरूले अंश पाउनेछन्। तर यदि अब तिम्रा अरू छोराहरू जन्मे, ती तिम्रा छोराहरू हुनेछन्, र तिनीहरू एप्रैम र मनश्शेका छोराहरू झैं भएर भविष्यमा एप्रैम र मनश्शेको सम्पत्तिको हकदार हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","पद्दनआरामबाट यात्रा गेरपछि राहेलको मृत्यु भयो जसले मलाई अत्यन्तै शोकाकुल पार्यो। तिनी कनानमा मरिन् हामीहरू अझै एप्रातपट्टी यात्रा जारी राख्यौ। मैले तिनलाई एप्राततिर जाने बाटो छेउमा गाडें। (एप्रात नै बेतलेहेम हो)” ");
INSERT INTO npi2010_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","तब इस्राएलले यूसुफका छोराहरूलाई देखे। इस्राएलले भने, “यी केटाहरू को हुन्?” ");
INSERT INTO npi2010_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","यूसुफले आफ्नो बाबुलाई भने, “यिनीहरू मेरा छोराहरू हुन। परमेश्वरले यी छोराहरू नै मलाई दिनु भएको हो।” इस्राएलले भने, “ती तिम्रा छोराहरूलाई मकहाँ ल्याऊ, म तिनीहरूलाई आशीर्वाद दिन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल बूढो भइसकेकोले आखाँ राम्रो देख्दैन थिए। यसर्थ यूसुफले ती छोराहरूलाई आफ्ना बाबु नजिक ल्याए। इस्राएलले ती केटाहरूलाई चुम्बन दिंदै अङ्गालो हाले। मनश्शे अनि एप्रैमको लागि आशीर्वाद ");
INSERT INTO npi2010_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","तब इस्राएलले यूसुफलाई भने, “म तँलाई हेर्न पाउँछु भनी कहिल्यै सोचेको थिइन, तर हेर, परमेश्वरले तँ र तेरा छोराहरूसमेत मलाई भेटगराउँनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","यूसुफले ती केटाहरूलाई आफ्ना बाबुको घुँडाबाट हटाए अनि तिनीहरू सबै आफ्नो बाबुअघि निहुरिए। ");
INSERT INTO npi2010_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","यूसुफले एप्रैमलाई दाहिने तिर र मनश्शेलाई आफ्नो देब्रेतिर राखे। (यसरी एप्रैम याकूबको देब्रे र मनश्शे दाहिने पट्टी थिए।) ");
INSERT INTO npi2010_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","तर इस्राएलले हात लम्काएर आफ्नो दाहिने हात सानो नानी एप्रैमको शिरमा राखे। त्यसपछि उनले आफ्नो देब्रे हात ठूलो चाँहि नानी मनश्शेको शिरमा राखे। मनश्शे पहिले जन्मेको र एप्रैमभन्दा जेठो भएता पनि इस्राएलले त्यसको शिरमा देब्रे हात राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","अनि इस्राएलले यूसुफलाई आशीर्वाद दिंदै यसो भने, “मेरो पिता-पुर्खाहरू अब्राहाम र इसहाकले हाम्रा परमेश्वरलाई आराधना गरे, अनि परमेश्वरले नै मेरो जीवन भरि डोर्याउँनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","उहाँ एकजना स्वर्गदूत हुनु हुन्थ्यो जसले मलाई मेरो जीवनका सबै कष्टहरूबाट मुक्त गर्नु भयो। अनि म प्रार्थना गर्छु, उहाँले यी केटाहरूलाई पनि आशीर्वाद दिनु हुनेछ। मेरा अनि मेरो पुर्खाहरू अब्राहाम अनि इसहाकको नाउँ यी केटाहरूले बढाउने छन्। तिनीहरू बढुन अनि बहुसंख्यक मानिसहरूका राष्ट्र होउन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","यूसुफले आफ्ना बाबुले एप्रैमको शिरमा दाहिने हात राखेको देखे र यस मा यूसुफ खुशी भएनन्। उनले इस्राएलको दाहिने हात एप्रैमको शिरबाट हटाएर मनश्शेको शिरमाथि राख्न चाहन्थे, र तिनले आफ्नो बाबुको हात समाते। ");
INSERT INTO npi2010_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","यूसुफले आफ्नो बाबुलाई भने, “तपाईंको दाहिने हात एप्रैमको शिरमा पर्यो तर त्यो राम्रो भएन कारण मनश्शे पहिले जन्मेको हो। यसर्थ तपाईंको दाहिने हात उसको शिरमा राख्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","तर तिनका बुबाले तर्क गर्नुभयो अनि भन्नुभयो, “मेरा छोरा, म जान्दछु। म जान्दछु, मनश्शे जेठो छोरो हो अनि उ महान् हुनेछ। मनश्शे ठूलो परिवारहरूको बुबा पनि हुनेछ। तर कान्छो छोरा जेठाभन्दा अझै महान् हुनेछ। अनि कान्छोका सन्तानहरू बढ्नेछन् अनि देशमा महान् हुनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","यसर्थ इस्राएलले तिनीहरूलाई त्यस दिन आशीर्वाद दिए। उनले भने, “जहिले पनि इस्राएलका मानिसहरूले आशीर्वाद दिंदा, तिमीहरूको नाउँ उच्चारण गर्नेछन्। तिनीहरूले भन्नेछन्, ‘परमेश्वरले तिमीहरूलाई पनि एप्रैम र मनश्शे झैं महान बनाउन्।’” यसरी इस्राएलले एप्रैमलाई मनश्शेभन्दा महान् बनाए। ");
INSERT INTO npi2010_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","तब इस्राएलले यूसुफलाई भने, “हेर, मेरो आन्तिम समय आइसकेको छ। तर परमेश्वरले तिमीलाई सधैं सघाउनु हुनेछ। उहाँले तिमीहरूलाई तिमीहरूको पिता पुर्खाहरूको भूमिमा लैजानु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","जुन कुरो तिम्रा दाज्यू-भाइहरूलाई दिइनँ त्यो तिमीहरूलाई दिएको छु। मैले एमोरीहरूबाट जितेको पहाड तिमीलाई दिन्छु। यस पहाडलाई जित्नको निम्ति मैले तरवार र धनु-काँड चलाएँ, अनि जिते।” ");
INSERT INTO npi2010_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","तब याकूबले सबै छोराहरूलाई बोलाए। उनले भने, “मेरा सबै छोराहरू मकहाँ आऊ। भविष्यमा के हुनेवाला छ म त्यो भन्ने छु। ");
INSERT INTO npi2010_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“हे याकूबका छोराहरू, तिमीहरू सँगै आऊ, अनि तिम्रा बाबु इस्राएलले भनेको सुन। ");
INSERT INTO npi2010_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रूबेन, तँ मेरो जेठो छोरो होस्, तँ मेरो जेठो छोरो साथै मेरो शक्तिको पहिलो प्रमाण होस्। तँमेरा छोराहरू मध्ये सबै भन्दा गौरव शालि, अनि शक्तिशाली हुन्छस्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","तर तेरो महत्वपूर्ण शक्ति बाढीको पानी जस्तै शक्तिशाली थियो तर तैंले त्यसलाई बचाई राख्न सकिनस्। यहीकारण तँ अरू छोराहरूभन्दा महत्वपूर्ण छैनस्। तँ आफ्नो बुबाको ओछ्यानमा चढिस् अनि उनकी एउटी पत्नीसित सुतिस्। तँ मेरो ओछ्यानमा गइस् अनि त्यसलाई भ्रष्ट पारिस्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमोन र लेवी दाज्यू-भाइ हुन्। तिनीहरू आफ्नो तरवार लिएर खेल्न रूचाउँचन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","तिनीहरूको दुष्ट योजनामा म भाग लिनु चाहँदिनँ अनि तिनीहरूको सभामा उपस्थित हुनु चाहँदिन किनभने तिनीहरू आफू रिसाउँदा मानिसहरू मार्छन्। अनि आफ्नो आनन्दका लागि तिनीहरू प्राणीहरूलाई दुःख दिन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","तिनीहरूलाई रिसको सराप परेको छ किनभने यो साह्रै उग्र हुन्छ। जब तिनीहरू रिसले बौलाहा भए, तिनीहरू साह्रै निर्दयी भए। तिनीहरू याकूबको भूमिमा आफ्नो अंश पाउने छैनन्। तिनीहरू याकूबको भूमिमा छरपस्ट हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“हे यहूदा, तेरा दाज्यू-भाइहरूले तेरो प्रशंसा गर्नेछन्। तैंले तेरा शत्रुहरूलाई ध्वंश पार्नेछस्। तेरा दाज्यू-भाइहरू तेरो अघि नतमस्तक हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा तँ सिंह जस्तै छस्। मेरो छोरा, तँ त्यो सिंह जस्तो देखिन्छस् जो आफुले मारेको जनावरमाथि उभिंदा देखिन्छ। तँ जब आराम गर्न ढल्किन्छस तँ सिंह जस्तै देखिन्छस्, अनि कसैले तेरो विरोध गर्ने साहस गर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाको परिवारबाट राजाहरू हुनेछन्। राजत्वको प्रतीक यस परिवारबाट हराउने छैन, जब सम्म एकजना वास्तविक राजा आउनु हुँदैन। तब उनको आज्ञाहरू पालन गर्न र उहाँलाई सेवा पुर्याउनु धेरै मानिसहरू आउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","उनले उसको जवान गधा सबभन्दा असल दाखको बोटमा बाँध्नेछ। सबभन्दा असल अङ्गुरको रसमा उनले आफ्नो लुगाहरू धुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","उसका आँखाहरू मद्यलेगर्दा राता हुनेछन्, र उसका दाँतहरू दूधलेगर्दा सेता छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलून समुद्रको किनारमा बस्नेछ। समुद्रको किनार जहाजहरूको निम्ति सुरक्षित ठाउँ हुनेछ। उसको भूमि सीदोन शहरसम्म विस्तृत रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साखार आफ्नो जीन थैलोको बीचमा आराम गर्न ढल्किएको बलियो गधा जस्तो हो। ");
INSERT INTO npi2010_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ऊ हेर्छ उसको विश्राम गर्ने ठाउँ राम्रो छ। ऊ हेर्छ उसको जग्गा राम्रो छ। त्यसपछि ऊ गह्रुँ भारी बोक्न राजी हुने छ। ऊ कमारा जस्तै खट्न राजी हुने छ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“दानले इस्राएलका अरू कुलहरूले झैं आफ्ना मानिसहरूको न्याय गर्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान बाटोको किनारमा बसेको सर्प झैं हुनेछ। दान बाटो छेउमा सुतिरहेको सर्प झैं भयानक हुनेछ। त्यो सर्पले घोडाको खुट्टामा डस्नेछ, र घोडामाथि सवार हुने भूइँमा लड्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“परमप्रभु, म तपाईंको उद्धारको प्रतीक्षामा पर्खिरहेको छु। ");
INSERT INTO npi2010_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“एक हुल डाकुहरूले गादमाथि आक्रमण गर्नेछन्, तर गादले तिनीहरूलाई धपाउने छ! ");
INSERT INTO npi2010_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेरको भूमिमा राम्रो उब्जनी हुनेछ। त्यसले राजाका लागि उत्तम उपयोगी खाद्य प्रदान गर्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नप्ताली स्वतन्त्र दगुर्ने मृग जस्तै हो। अनि उसका शब्दहरू मृगका पाठा-पाठीहरू भन्दा सुन्दर छन। ");
INSERT INTO npi2010_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“यूसुफ अत्यन्त सफल भएको छ। यूसुफ फलले लादिएको बोट जस्तै वसन्तमा बढने बोट जस्तै अनि यस्तो बोट हो जसका हाँगाहरू भित्तामा चढ्छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","धेरै मानिसहरू तिनको विरोधी भए अनि तिनीसित युद्ध गरे। काँडहरू लिएका मानिसहरू तिनका शत्रु भए, ");
INSERT INTO npi2010_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तर दक्षता र बहादूरी अनि बलियो धनुले गर्दा उसले लडाँई जित्यो। याकूबको परमेश्वर गोठालाबाट साहस र शक्ति प्राप्त गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","आफ्ना बाबुका परमेश्वरबाट उसले शक्ति पाउनेछ। “सर्वशाक्तिमान परमेश्वरले तिमीलाई आशीर्वाद दिऊन, अनि स्वर्गबाट तिमीलाई आशीर्वाद दिऊन, अनि अगाध गहिरो समुद्रबाट तिमीलाई आशीर्वाद दिऊन्। उहाँले तिमीलाई स्तन र गर्भबाट आशीर्वाद दिऊन। ");
INSERT INTO npi2010_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","मैले प्राप्त गरेको आशीर्वादहरू मेरा माता-पिताले प्राप्त गरेको आशीर्वादभन्दा धेरै छन्। ती पुराना पर्वतहरू जस्तै थुपारिएका यूसुफका यस्ता आशीर्वादहरू, उनका दाज्यू-भाइहरू मध्ये राजकुमारको शिरमा परून्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बिन्यामीन एउटा भोकाएको ब्वाँसो जस्तै हो। बिहान ऊ शिकार गर्छ, जनावर मार्छ अनि खान्छ। अनि राती ऊ लुटेका वस्तुहरू भाग लगाउँछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","यिनीहरू इस्राएलका बाह्र कुलहरू थिए। यो नै तिनका बुबाले भन्नु भएको थियो जब उहाँले तिनीहरूलाई आशीर्वाद दिनु भयो। उहाँले प्रत्येकलाई उचित आशीर्वाद दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","तब इस्राएलले तिनीहरूलाई आज्ञा दिए अनि भने, “म मर्न आँटेको छु। मलाई मेरो पिता पुर्खाहरूसँग गाड्नू। म एप्रोन हित्तीको क्षेत्रको ओडारमा गाडिन चाहन्छु जहाँ मेरा पुर्खाहरू गाडिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","कनानमा माम्रेको छेउ मकपेलाको मैदानमा भएको ओडार यही हो। यो त्यो ओडार हो जसलाई मेरा बुबा अब्राहामले एप्रोन हित्तीबाट इलाकासमेत आफ्नो गाड्ने चिहानको लागि किनेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","त्यही ओडार हो जहाँ अब्राहाम र उसको स्वास्नी सारालाई गाडिएको थियो। इसहाक र उसकी स्वास्नी सारालाई गाडिएको थियो। इसहाक र उसकी पत्नी रिबेकालाई पनि त्यस ओडारमा गाडिएको थियो। मैले मेरी पत्नी लेआलाई पनि त्यहाँ गाडेँ। ");
INSERT INTO npi2010_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","त्यो ओडार हित्ती मानिसहरूबाट किनेको भूमि हो।” ");
INSERT INTO npi2010_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","आफ्ना छोराहरूसित कुरा गरिसके पछि याकूबले आफनो खुट्टा ओछ्यानमा राखे अनि अन्तिम सास फेरे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","जब याकूबको मृत्यु भयो यूसुफ खुबै दुःखी भए। तिनले आफ्नो बाबुलाई अँगाले हालेर रूदै म्वाई खाए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","यूसुफले आफ्ना सेवकहरूलाई आफ्नो बाबुको अन्तिम संस्कारको निम्ति तयार पार्न आज्ञा दिए। (ती सेवकहरू वैद्यहरू थिए।) ती वैद्यहरूले याकूबको शरीर अन्तिम संस्कारको निम्ति तयार पारे। तिनीहरूले याकूबको मृत शरीर मिश्र देशवासीहरूका विशेष नियम अनुसार तयार पारे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","मिश्रीहरूले इस्राएलको लागि 70 दिन सम्म शोक गरे। तिनको शरीर तयार गर्ने समय 40 दिन भित्र पूरा भयो। शोकको पूरा समय पछि। यूसुफ फिरऊन कहाँ गए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","सत्तरी दिनपछि शोक समय सकियो र यूसुफले फिरऊनका अधिकारीहरूसंग कुरा गरे। यूसुफले भने, “फिरऊनलाई यो कुरो भनीदिनु। ");
INSERT INTO npi2010_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘मेरा बाबुको मृत्यु हुनअघि, मैले तिनलाई एउटा वचन दिएको थिएँ। मैले प्रतिज्ञा गरेको थिएँ म तिनलाई कनान भूमिमा दफन गर्नेछु। त्यो उनले आफ्नो निम्ति तयार पारेको ओडार हो। यसर्थ मेरा बाबुको अन्तिम संस्कार गर्न मलाई त्यहाँ जानु दिनु होस्। त्यसपछि म तपाईं कहाँ फर्केर आउने छु।’” ");
INSERT INTO npi2010_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फिरऊनले उत्तर दिए, “आफ्नो प्रतिज्ञा पालन गर। जाऊ अनि बाबुको अन्तिम संस्कार गर।” ");
INSERT INTO npi2010_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","यसकारण यूसुफ आफ्नो बाबुको अन्तिम संस्कार गर्न गए। फिरऊनका अधिकारीहरू, फिरऊनका अग्रजहरू अनि मिश्रका अग्रजहरू समस्त यूसुफसित गए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","तिनीसित आफ्ना सबै दाज्यू-भाइहरू अनि तिनका बाबुका समस्त परिवारका मानिसहरू गए। गोशेन भूमिमा खाली नानीहरू र पशुहरू मात्र थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","मानिसहरूको त्यहाँ एउटा विशाल घुइँचो भयो। त्यहाँ रथहरूमा र घोडसवार भएका सिपाहीहरू पनि थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","तिनीहरू यर्दन नदीको पूर्व गोरेन आतादमा गए। तब तिनीहरू यर्दन नदीको पूर्वतिर आतादको खलामा पुगे। तिनीहरूले एउटा ठूलो अनि शोकपूर्ण अन्तिम संस्कार गरे। अनि त्यहाँ यूसुफले सात दिनसम्म आफ्नो बुबाको मृत्यु शोक पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","जब कनान देशका मानिसहरू जो त्यस आताद खलामा थिए, तिनीहरूले भने, “मिश्र देशवासीहरू कति गहिरो शोक पालन गरिरहेका छन्।” यसर्थ तिनीहरूले त्यस भूमिको नाउँ हाबिल-मिश्रइम राखे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","यसर्थ याकूबका छोराहरूले आफ्ना बाबुले जे भनेका थिए त्यही गरे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","तिनीहरूले बुबाको मृत शरीर कनान देशमा ल्याए अनि उसलाई त्यस ओडारमा गाडे जो मकपेला क्षेत्रमा छ अनि जसलाई अब्राहामद्वारा माम्रे नजिक हित्ती, एप्रोनबाट आफ्नो चिहानको लागि उपयोग गर्न किनिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","आफ्नो बुबाको मृत शरीर गाडे पछि यूसुफ सबै मानिसहरूसँगै मिश्र फर्किए जो तिनीसँग गएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","याकूबको मृत्यु पछि यूसुफका दाज्यू-भाइहरू चिन्तित भए। तिनीहरूले धेरै वर्षअघि यूसुफसित गरेको कर्मको निम्ति तिनीहरू डराए। तिनीहरूले भने, “हुन सक्छ, हामीले गरेको कर्मको निम्ति यूसुफले अझसम्म हामीलाई घृणा गर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","यसर्थ उसका दाज्यू-भाइहरूले उसलाई यो संदेश पठाए, “तिम्रो बुबा मर्नु अघि उहाँ आफैले यो संदेश तिमीलाई दिनु भनी हामीलाई भन्नु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","उनले भने, ‘दाज्यू-भाइहरूले तिमीसित गरेको कुकर्मको निम्ति क्षमा दिनु भनी म बिन्ती गर्दछु।’ यसर्थ, यूसुफ, हामीले तिमीसित गरेको कुकर्मको निम्ति दया गरी हामीलाई क्षमा गर। हामी तपाईंका बुबाको परमेश्वरका दासहरू हौं।” त्यस समाचारले यूसुफलाई साह्रै दुःखी तुल्यायो, अनि तिनी खुबै रोए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","तिनका दाज्यू-भाइहरू तिनीकहाँ गए अनि तिनी अघि निहुरिएर भने, “हामी तपाईंका दास हुनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","तब यूसुफले तिनीहरूलाई भने, “नडराओ। म परमेश्वर होइन। तिमीहरूलाई दण्ड दिने मेरो कुनै अधिकार छैन। ");
INSERT INTO npi2010_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","यो सत्य हो तिमीहरूले मेरो विरूद्धमा हानि गर्ने योजना गरेका थियौ। तर वास्तवमा, परमेश्वरले राम्रोको निम्ति योजना बनाउनु भएको थियो। परमेश्वरको योजना अनुसार धेरै मानिसहरूको जीवन बचाउँन मलाई प्रयोग गर्नु थियो। अनि उहाँको योजना जस्तो थियो त्यस्तै भयो। ");
INSERT INTO npi2010_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","यसर्थ तिमीहरू नडराओ। म तिमीहरू र तिमीहरूका नानीहरूको हेरचाह गर्नेछु।” यसरी यूसुफले आफ्ना दाज्यू-भाइहरूलाई राम्रा कुराहरू भने। यसले दाज्यू-भाइहरूले धेरै शान्ति पाए। ");
INSERT INTO npi2010_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","यूसुफ उनको परिवारसित मिश्रमा बसे। यूसुफ एक सय दश वर्ष पुगेर मरे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","यूसुफकै जीवन कालमा एप्रैमको छोरा-छोरी तथा नाता-नातिनीहरू जन्मेका थिए। अनि तिनको छोरो मनश्शेबाट छोरो जन्मियो जसको नाउँ माकीर थियो। यूसुफ माकीरका नानीहरूको मुख हेर्न बाँचिरहे। ");
INSERT INTO npi2010_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","जब यूसुफको मर्ने बेला भएको थियो, उनले आफ्ना दाज्यू-भाइहरूलाई भने, “प्रायः मेरो मृत्युको समय भयो। तर म जान्दछु परमेश्वरले तिमीहरूको हेरचाह गर्नु हुनेछ, अनि यस देशबाट बाहिर लैजानु हुनेछ। परमेश्वरले अब्राहाम, इसहाक र याकूबलाई दिन्छु भनी प्रतिज्ञा गर्नु भएको भूमिमा तिमीहरूलाई लैजानु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","तब यूसुफले मानिसहरूलाई एउटा प्रतिज्ञा गर्नु लगाए। उनले भने, “जब परमेश्वरले तिमीहरूलाई त्यो नयाँ भूमिमा लानु हुनेछ त्यस बेला मेरा अस्थिहरू तिमीहरूसित लिएर जानेछौं भनी प्रतिज्ञा गर।” ");
INSERT INTO npi2010_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","यूसुफ जब एक सय दश वर्ष पुगेपछि तिनको मृत्यु भयो। अन्तिम संस्कारको निम्ति वैद्यहरूले तिनको लाश तयार पारे अनि तिनको शरीरलाई मिश्रमा एउटा कफनमा राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकूबले आफ्ना छोराहरूसित मिश्रदेशतिर यात्रा गरे अनि तिनका प्रत्येक छोरोसित आफ्नो-आफ्नो परिवार थिए। इस्राएलका छोराहरू यिनीहरू नै हुन्, ");
INSERT INTO npi2010_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमोन, लेवी, यहूदा, ");
INSERT INTO npi2010_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साकार, जबूलून, बिन्यामीन, ");
INSERT INTO npi2010_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्ताली, गाद र आशेर। ");
INSERT INTO npi2010_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकूबका आफ्नै परिवारका जम्मा सन्तानहरू सत्तरी जना थिए। यूसुफ याकूबका बाह्रजना छोराहरू मध्ये एकजना थिए (तर तिनी पहिलेदेखि नै मिश्रमा थिए।) ");
INSERT INTO npi2010_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","यूसुफ, उनका दाज्यू-भाइहरू अनि त्यस पुस्ताका सबै मानिसहरूको मृत्यु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","तर इस्राएलका मानिसहरूका धेरै बाल-बच्चाहरू थिए अनि तिनीहरूका सन्तान बढि नै रहे। इस्राएलका मानिसहरू शक्तिशाली भए र इस्राएलीहरूले नै मिश्र देश भरियो। ");
INSERT INTO npi2010_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","तब नयाँ राजाले मिश्रदेशमा शासन गर्न थाले। त्यो राजाले यूसुफलाई चिन्दैन थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","त्यो राजाले आफ्ना मानिसहरूलाई भने, “इस्राएलका मानिसहरूलाई हेर, तिनीहरू विशाल संख्यामा छन् र हामीभन्दा बलिया पनि छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","यी इस्राएलीहरूको संख्या वृद्धिमा अंकुशे लगाउन हामीले केही योजनाहरू बनाउनु पर्छ। यदि हामीसित कसैले लडाइँ गरे यी इस्राएलीहरू शत्रु पक्षपट्टि लाग्न सक्छन्। अनि तिनीहरूले हामीलाई जितेर हामीबाट उम्कन सक्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","मिश्रीहरूले इस्राएलीहरूको जीवन कष्टपूर्ण पार्ने निर्णय गरे। यसर्थ मिश्रीहरूले इस्राएलीहरूमाथि कमारा-स्वामीहरू नियुक्त गरे। ती स्वामीहरूले फिरऊनको निम्ति पिताम र रामसेस शहरहरू बनाउन ती इस्राएलीहरूलाई जोर लगाए। राजाले यी शहरहरू अन्न र अरू चीजहरू राख्न प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","मिश्रीहरूले इस्राएलीहरूलाई कठिन-कठिन कामहरू गर्न लगाउन थाले, तर जति तिनीहरूलाई काममा लगाइन्थ्यो त्यति नै तिनीहरूको संख्या बढथ्यो अनि फैलिन्थे। अनि मिश्रीहरू इस्राएलीहरूसंग अझै डराउन थाले। ");
INSERT INTO npi2010_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","यसर्थ तिनीहरूलाई मिश्रीहरूले अझ कठिन कामहरू गर्न लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","मिश्रीहरूले इस्राएलीहरूको जीवन कठिन बनाइ दिए। मिश्रीहरूले इस्राएलीहरूलाई ईंटा र त्यसको मसला बनाउँने जस्ता कठिन काम गर्न वाध्य गराए। तिनीहरूलाई खेतमा पनि कठिन काम गर्न वाध्य गराए। तिनीहरूलाई खेतमा पनि कठिन कामहरू गर्न जोर दिए। तिनीहरूले गर्ने प्रत्येक काममा नै इस्राएलीहरूलाई सह्रै कठिन अप्ठयारोमा पारे। ");
INSERT INTO npi2010_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","हिब्रू स्त्रीहरूले नानी जन्माउने समयमा हेरचाह गर्ने त्यहाँ दुइजना सुँडेनीहरू थिए। तिनीहरूको नाउँ शिप्रा र पूआ थियो। मिश्रदेशका राजाले ती दुइ सुँडेनीसंग कुरा गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","राजाले तिनीहरूलाई भने, “जब तिमीहरूले एउटा हिब्रू स्त्रीहरूलाई नानी जन्माउनमा सहायता गर्नेछौ, यदि छोरी जन्मिछे भने उसलाई बाँच्न देऊ। तर यदि छोरा जन्मिछ भने तब त्यसलाई अवश्य मारिदेऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","तर ती सुँडेनीहरूले परमेश्वरलाई सम्मान गर्थे। यसकारण तिनीहरूले राजाको हुकुम पालन नगरी, जन्मेका बालकहरूलाई बाँच्न दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","तब राजाले ती सुँडेनीहरूलाई बोलाए र तिनीहरूलाई भने, “तिमीहरूले यस्तो किन गर्यौ? तिमीहरूले बालकहरूलाई किन बाँच्न दियौ? यसो किन गर्यौ?” ");
INSERT INTO npi2010_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","सुँडेनीहरूले फिरऊनलाई उत्तर दिए, “महाराज! हिब्रू स्त्रीहरू मिश्री स्त्रीहरूभन्दा ज्यादै बलिया छन्। हामीहरू तिनीहरूलाई सहायता गर्न पुग्नअघिनै नानी जन्माइसकेका हुन्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","परमेश्वर सुँडेनीहरूसित खुशी हुनुहुन्थ्यो, यसकारण परमेश्वर तिमीहरू प्रति राम्रो हुनुहुन्थ्यो, उहाँले तिनीहरूलाई आफ्नै परिवारहरू बनाउने अनुमति दिनुभयो। हिब्रू मानिसहरूका धैरे नानीहरू हुँदै गए अनि तिनीहरू साह्रै शक्तिशाली भए। ");
INSERT INTO npi2010_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","यसकारण राजा फिरऊनले आफ्ना सबै मानिसहरूलाई आदेश दिए, “सबै बालिकाहरूलाई बाँच्न देऊ। तर जब प्रत्येक पल्ट बालक जन्मन्छ तिमीहरूले उसलाई नील नदीमा अवश्यै फ्याँक्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","एकजना मानिस जो लेवी कुलका थिए, तिनले लेवी कुलकै एउटी आइमाईलाई विवाह गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","त्यो महिला गर्भवती भई अनि छोरा जन्माई। त्यो बालक अत्यन्त सुन्दर थियो। यसर्थ उसकी आमाले उसलाई तीन महीनासम्म लुकाएर राखी। ");
INSERT INTO npi2010_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","जब उनले त्यसलाई अझ लामो समयसम्म लुकाउन सकिन उसले एउटा डालो बनाई अनि त्यसलाई अलकत्राले लिपि कारण यसो गर्दा त्यो पानीमा बग्थ्यो, उसले त्यो बालकलाई डालो भित्र हाली अनि डालो निगालोधारी बीच नील नदीको छेउमा राखी। ");
INSERT INTO npi2010_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","त्यस नानीकी दिदीले बालकलाई के हुँदो रहेछ भनेर हेर्नको निम्ति केही टाढा बसी। ");
INSERT INTO npi2010_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","जब फिरऊनकी छोरी नील नदीमा नुहाउन आइन् तिनकी सेवीकाहरू नील नदीको छेउमा हिंडे, फिरऊनकी छोरीले डालो अग्ला निगालो घारिको बीचमा देखिन्। यसर्थ तिनले त्यो डालो ल्याउन तिनीहरू मध्ये एकजनालाई अह्राइन्। ");
INSERT INTO npi2010_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","राजकुमारीले ती डालो खोलिन् र त्यसभित्र एउटा बालकलाई रोइरहेको पाइन्। बालक रोइरहेकोमा त्यो राजकुमारी दुःखी भइन्। त्यसपछि तिनले थाहा पाइन् कि त्यो बालक कुनै हिब्रूको हो। ");
INSERT INTO npi2010_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","त्यस बालककी दिदीले फिरऊनको छोरीलाई सोधी, “म एउटी हिब्रू आइमाईलाई खोजूँ जसले यो नानीलाई तपाईंको निम्ति स्याहार सुसार गर्न सक्छे?” ");
INSERT INTO npi2010_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फिरऊनकी छोरीले भनी, “हुन्छ, ल्याई देऊ।” यसर्थ त्यो केटी गएर त्यस नानीकी आफ्नै आमालाई लिएर आई। ");
INSERT INTO npi2010_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फिरऊनकी छोरीले नानीकी आमालाई भनी, “यो नानी लैजाऊ अनि यसलाई हेरचाह गर र म तिमीलाई त्यसका निम्ति ज्याला दिनेछु।” तब आइमाईले नानीलाई लगी र उसलाई हेरचाह गरी। ");
INSERT INTO npi2010_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","त्यो नानी हुर्कियो अनि केही समयपछि त्यस आइमाईले राजकुमारीलाई नानी दिई। त्यो राजकुमारीले नानी ग्रहण गरी अनि त्यो नानीलाई उसले पानीबाट तानेर निकालेको हुनाले त्यसको नाउँ मोशा राखी। ");
INSERT INTO npi2010_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","जब मोशा बढेर ठूलो भए, उनी बाहिर गए अनि हिब्रू, आफ्ना मानिसहरूलाई कठिन काम गर्न लगाएको देखे। एक दिन मोशाले एकजना मिश्री मानिसले मोशाको एकजना हिब्रू मानिसलाई हिर्काउँदै गरेको देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","मोशाले चारैतिर हेरे र त्यहाँ कोही अरू मानिसहरू नभएकाले त्यस मिश्री मानिसलाई मारेर बालुवा तल पुरे। ");
INSERT INTO npi2010_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","अर्को दिन दुइ जना हिब्रू मानिसहरूलाई आफ्स्तमा लडाइँ गर्दै गरेको भेटे। तिनीहरू मध्ये एकजनाको कसुर भएको उनले पाए अनि तिनलाई भने, “तिमीले किन आफ्नो छिमेकीलाई नोक्सान पुर्याइरहेकाछौं?” ");
INSERT INTO npi2010_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","त्यस मानिसले उत्तर दियो, “कसले तिमीलाई हाम्रो न्यायकर्ता र शासक बनायो? के तिमीले मलाई पनि मार्न लागिरहेकाछौ जस्तो तिमीले त्यो मिश्री मानिसलाई मारेका थियौ?” तब मोशा डराए। उनले सोचे, “मैले के गरेको थिएँ त्यो थाह पाए छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","मोशाद्वारा हत्या गरेको विषयमा फिरऊनले पनि थाह पाए, अनि उसलाई मार्ने निश्चय गरे। यसकारण मोशाले आफैलाई फिरऊन देखि बाँच्नको निम्ति भागेर मिद्यानमा गए। जब मोशा मिद्यानमा पुगे ऊ कुनै कुवाको नजिक बसे। ");
INSERT INTO npi2010_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","त्यहाँ एक जना मिद्यान पूजाहारी बस्थे जसका सातवटी छोरीहरू थिए। छोरीहरू तिनीहरूका पिताका भेडाहरूका लागि त्यही कुवामा पानी निकाल्न आए। तिनीहरूले डुँडमा पानी भर्ने प्रयास गरिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","तर त्यहाँ केही भेडा गोठालाहरू जो त्यहाँ थिए केटीहरूलाई पछ्याउने चेष्टा गरे। यसकारण मोशाले केटीहरूलाई बंचाए अनि पानी झिके र पशुहरूलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","तब ती केटीहरू तिनीहरूको बाबु रूएलकहाँ गए तिनीहरूका बाबुले तिनीहरूलाई सोधे, “किन आज तिमीहरू यति चाँडै घरमा आएकाछौं?” ");
INSERT INTO npi2010_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","केटीहरूले उत्तर दिए, “हो बाबु, गोठालाहरूले हामीलाई पछ्याउने चेष्टा गरे, तर एकजना मिश्र देशी मानिसले हाम्रो निम्ति पानी ताने र हाम्रा पशुहरूलाई खुवाए।” ");
INSERT INTO npi2010_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","यसकारण रूएलले आफ्नी छोरीहरूलाई भने, “त्यो मानिस कहाँ छ? किन तिमीहरूले उसलाई एक्लै छोड्यौ? उसलाई यहाँ बोलाऊ अनि उसले हामीसंगै खाओस्!” ");
INSERT INTO npi2010_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मोशा रूएलसंग बस्न राजी भए। रूएलले आफ्नी छोरी सिप्पोरासंग मोशाको विवाह गरिदिए। ");
INSERT INTO npi2010_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्पोरा गर्भवती भई अनि एउटा छोरा जन्माइ मोशाले आफ्नो छोरोको नाउँ गेर्शोम राखे किनभने मोशा त्यस भूमिमा अपरिचित थिए जो उनको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","धेरै समय बिते पश्चात् मिश्रका राजाको मृत्यु भयो। तर इस्राएलका मानिसहरू अझै कठोर काम गर्नु बाध्य थिए। यसकारण तिनीहरूले सहायताको निम्ति प्रार्थना गरे अनि तिनीहरूको प्रार्थना परमेश्वरले सुन्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्वरले तिनीहरूको प्रार्थना सुन्नु भयो र उहाँले अब्राहाम, इसहाक अनि याकूबसित गर्नु भएको करार सम्झनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","परमेश्वरले इस्राएलका मानिसहरूको कष्टहरू देख्नु भयो अनि चाँडै तिनीहरूलाई सहायता गर्नु पर्ने उहाँले बुझ्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","त्यस समय मोशा उसको ससूराका भेडाहरूको हेरचाह गर्दैथिए। तिनका ससूरा यित्रो मिद्यानमा पूजाहारी थिए। मोशाले भेडाहरू मरूभूमिको पश्चिमतिर लगे। मोशा होरेब, परमेश्वरको पहाड गए। ");
INSERT INTO npi2010_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","पर्वतमा मोशाले परमप्रभुको दूतलाई एउटा बल्दै गरेको पोथ्रामा देखे। पोथ्रामा आगो जलिरहेको थियो तर पोथ्रा चाँहि भस्म भएको थिएन। उनले हेरे त्यो आगो पोथ्रामा जलि रहेको थियो तर पोथ्रा भस्म भएको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","मोशाले विचार गरे, “किन पोथ्रा आगो द्वारा नाश भएको छैन?” ");
INSERT INTO npi2010_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","जब परमप्रभुले मोशालाई त्यो दृश्य ध्यान पूर्वक हेर्न आएको देख्नुभयो परमप्रभुले पोथ्राबाट यसो भन्दै बोलाउनु भयो, “मोशा! मोशा!” मोशाले उत्तर दिए, “म यहाँ छु।” ");
INSERT INTO npi2010_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","तब परमेश्वरले भन्नुभयो, “नजिक नआऊ। जुन ठाउँमा तिमी उभिरहेका छौ त्यो भूमि पवित्र हो यसर्थ आफ्नो जुत्ता खोल। ");
INSERT INTO npi2010_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","म तिम्रा पिता-पुर्खाहरू अब्राहाम, इसहाक र याकूबको परमेश्वर हुँ।” मोशाले उसको अनुहार छोपे किनभने ऊ परमेश्वर तिर हेर्न डराएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","परमेश्वरले उनलाई भन्नुभयो, “मिश्रमा भएका मेरो मानिसहरूले कष्ट भोगेको मैले देखेको छु। मैले तिनीहरूको शोकपूर्ण प्रार्थनाहरू सुनेको छु, जब तिनीहरूका कमारा मालिकहरूले जबरदस्ती कठिन कामहरू गर्न लगाए। म तिनीहरूको दुःखको कारण पनि जानेकोछु। ");
INSERT INTO npi2010_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","अब म त्यहाँ जान्छु अनि मेरो मानिसहरूलाई मिश्री मानिसहरूबाट बचाउँछु। म तिनीहरूलाई त्यस स्थानबाट निकालेर तिनीहरूले कष्ट भोग्नु नपर्ने स्थानमा लिएर जान्छु। त्यो ठाउँ धेरै-धेरै असल चीजहरूले भरिएको हुनेछ र कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी र यबूसी जस्ता विभिन्न जातिका मानिसहरू बसो-बास गर्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","मैले इस्राएलका मानिसहरूको पुकार सुनेकोछु। मैले देखें मिश्रीहरूले तिनीहरूका निम्ति जीवन कति कठोर बनाइदिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","यसकारण अब म तिमीलाई फिरऊन कहाँ पठाउँछु। जाऊ अनि मेरा मानिस इस्राएलीहरूलाई मिश्रबाट बाहिर ल्याऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","तर मोशाले परमेश्वरलाई भने, “म कुनै एउटा त्यस्तो महान मानिस होइन। म कसरी त्यो मानिस हुन सक्छु जो फिरऊन कहाँ जान सक्छ र इस्राएलीहरूलाई मिश्रबाट बाहिर ल्याउन सक्छ?” ");
INSERT INTO npi2010_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्वरले भन्नुभयो, “तिमीले भलो गर्न सक्छौ किनभने म तिमीसित हुनेछु। यही प्रमाण हुनेछ कि मैले तिमीलाई पठाउँदैछु तिमीले इस्राएलीहरूलाई मिश्रदेशाबाट अगुवाई गरेपछि, तिमी आउनेछौ अनि यही पर्वतमा आराधना गर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","तब मोशाले परमेश्वरलाई भने, “जब म इस्राएलीहरू कहाँ जान्छु अनि तिनीहरूलाई भन्छु, ‘म तिमीहरूका पिता-पुर्खाहरूका परमेश्वरद्वारा पठाइएको हुँ,’ अनि तिनीहरूले तपाईंको नाउँ सोधेमा मैले के भन्नु पर्नेछ?” ");
INSERT INTO npi2010_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","तब परमेश्वरले मोशालाई भन्नुभयो, “‘म जो हुँ त्यही हुँ’ तिनीहरूलाई भनिदेऊ, ‘म हुँ,’ भन्नेले तिमीलाई तिनीहरूकहाँ पठाएको हो।” ");
INSERT INTO npi2010_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्वरले मोशालाई अझ भन्नुभयो, “तिमीले इस्राएलीहरूलाई के भन्नु पर्छ भने, ‘परमप्रभु तिम्रो पिता-पुर्खाहरूका परमेश्वर, अब्राहामका परमेश्वर, इसहाकका परमेश्वर र याकूबका परमेश्वर हुनुहुन्छ। मेरो नाउँ सदैव परमप्रभु रहनेछ। यही रूपमा मानिसहरूले मलाई पुस्तौं-पुस्तासम्म चिन्नेछन्,’ यसैकारण मानिसहरूलाई भन, ‘परमप्रभुले मलाई तिमीहरू कहाँ पठाउनु भएको छ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","परमेश्वरले मोशालाई फेरि भन्नुभयो, “जाऊ अनि इस्राएलका बूढा प्रधानहरूलाई एकत्रित गर अनि तिनीहरूलाई भन, ‘यहोवा, तिमीहरूका पिता-पुर्खाहरूका अब्राहाम, इसहाक अनि याकूबका परमेश्वर मेरोअघि मानिस जस्तै प्रकट हुनुभयो अनि मलाई भन्नु भयो, यहाँ मिश्रमा भोगेका कष्टहरू र शोकहरू उहाँलाई थाह छ र तिमीहरूलाई उहाँ कष्टबाट मुक्त गराउनु चाहनु हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","उहाँले यसो भन्नु भयो तिमीहरूलाई मिश्रबाट बाहिर निकाल्नु हुनेछ, अनि विभिन्न जातिहरूको भूमिमा लानु हुनेछन् जस्तै कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी र यबूसीहरू अनि दूध र मह बगिरहेको भूमिमा पुर्याउनु हुनेछ।’ ");
INSERT INTO npi2010_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ती बूढा-प्रधानहरूले तिमीहरूको कुरा सुन्नेछन्। त्यसपछि तिमी र बूढा-प्रधानहरू मिश्रका राजा कहाँ जानेछौ। तिमीले राजालाई भन्ने छौ, ‘यहोवा हिब्रू मानिसहरूका परमेश्वर हुन्। हाम्रा परमेश्वर हामीकहाँ आउनु भयो अनि हामीलाई तीन दिनसम्म मरूभूमिमा यात्रा गर्न भन्नुभयो। हामीले हाम्रा परमेश्वर यहोवालाई त्यहाँ बलिहरू चढाउनु पर्नेछ।’ ");
INSERT INTO npi2010_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“तर म जान्दछु मिश्रको राजाले तिमीहरूलाई जान दिनु हुँदैन कुनै महाशक्तिले मात्र उहाँलाई जानु दिने बनाउनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","यसर्थ तिनीहरूमाझ म अचम्मका कुराहरू गर्न महाशक्ति प्रयोग गर्नेछु। जब म महाशक्तिको प्रयोग गर्छु राजाले तिनीहरूलाई छोडन बाध्य गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","अनि म मिश्रका मानिसहरूलाई इस्राएली मानिसहरूप्रति दयालु बनाउँनेछु। जब इस्राएलीहरूले मिश्र छाडछन् तिनीहरू रित्तै हात जाने छैनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“हिब्रू महिलाहरूले तिनीहरूका मिश्री छिमेकीहरूसित सुन र चाँदीको चीजहरू अनि लुगाहरू माग्ने छन्। तिमीहरूले ती चीजहरू तिमीहरूका छोरा-छोरीहरूलाई लगाईदिने छौ। यस प्रकार तिमीहरूले मिश्रबाट सम्पत्ति लिएर आउनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","तब मोशाले परमेश्वरलाई भने, “तर इस्राएलीहरूले मलाई विश्वास गर्ने छैनन जब म तिनीहरूलाई भन्छु तपाईंले मलाई पठाउनु भयो। तिनीहरू भन्ने छन्, परमप्रभु तिमीअघि प्रकट भएनन्?” ");
INSERT INTO npi2010_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","तर परमप्रभुले मोशालाई भन्नुभयो, “त्यो तिम्रो हातमा भएको के हो?” मोशाले उत्तर दिए, “यो मेरो हिंड्ने लहुरो हो।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","तब परमेश्वरले मोशालाई भन्नु भयो, “त्यो तिम्रो हिँड्ने लहुरो भूँईंमा फ्याँकि देऊ।” मोशाले आफ्नो लहुरो भूईंमा फ्याँकिदिए पछि अचनाक लहुरो सर्पमा परिणत भयो। मोशा डराए अनि त्यहाँबाट टाढा गए। ");
INSERT INTO npi2010_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","तर परमप्रभुले मोशालाई भन्नुभयो, “अघि बढ र सर्पको पुच्छरमा समात।” मोशा सर्प नजिक पुगे अनि त्यसको पुच्छरमा समाते। जब मोशाले सर्पलाई समाते त्यो फेरि लहुरो नै भइहाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","तब परमप्रभुले मोशालाई भन्नु भयो, “आफ्नो लहुरो तिमीले यसरी नै प्रयोग गर, अनि मानिसहरूले विश्वास गर्नेछन् परमप्रभु तिनीहरूका पिता-पुर्खाहरूको परमेश्वर, अब्राहामको परमेश्वर, इसहाकका परमेश्वर अनि याकूबका परमेश्वर तिम्रोअधि प्रकट हुनु भएको थियो।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, “म तिमीलाई अर्को एउटा प्रमाण दिनेछु। आफ्नो लुगाभित्र हात हाल।” यसर्थ मोशाले लगाएको लुगा खोले अनि आफ्नो हात त्यसभित्र हाले। तब मोशाले उसको हात लुगाबाट बाहिर निकाल्दा उसको हात सेतो हिउँ जस्तो दागै दाग भएको पाए। ");
INSERT INTO npi2010_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","तब परमेश्वरले भन्नुभयो, “अब फेरि तिम्रो हात लुगाभित्र हाल।”यसकारण मोशाले आफ्नो हात लुगाभित्र फेरि हाले मोशाले आफ्नो हात लुगाभित्र हालेर फेरि बाहिर निकाले। त्यो फेरि पहिलैको जस्तो राम्रो भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","तब परमेश्वरले मोशालाई भन्नुभयो, “यदि मानिसहरूले तिमीलाई विश्वास गर्दैन जब तिमी हिंडने लहुरो उपयोग गर्छौ जब तिमी तिनीहरूलाई यो संकेत देखाउँछौ, तिनीहरूले तिमीलाई विश्वास गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","यी दुइ संकेतहरू देखाउँदा पनि तिनीहरूले तिमीहरूलाई आफैं विश्वास गरेनन् भने तिमीले नील नदीबाट केही पानी ल्याऊ। त्यो पानी भूईंमा खंन्याऊ, यसले भूईं छुने वित्तिकै त्यो रगतमा परिवर्त्तन हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","तर मोशाले परमप्रभुलाई भने, “तर परमप्रभु, म तपाईंलाई साँचो भन्दैछु म दक्ष वक्ता होइन। म कहिल्यै राम्रो बोल्ने योग्यको हुन सकेको छैन। अनि अहिले तपाईंसित कुरा गरें पछि पनि म असल वक्ता होइन। तपाईंलाई थाहै छ म ढिलो बोल्छु र उत्कृष्ट शब्दहरू उपयोग गर्दिन।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, “मानिसको मुख कसले बनायो? अनि मानिसलाई कसले बहिरो, बोल्न नसक्ने बनाउन सक्छ? कसले मानिसलाई अन्धो बनाउन सक्छ? कसले मानिसलाई देख्न सक्ने बनाउन सक्छ? त्यो म नै एक हुँ जसले यी सब कर्महरू गर्न सक्छ, म यहोवा हुँ। ");
INSERT INTO npi2010_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","यसकारण, तिमी जाऊ, जब तिमी कुरा गर्छौ म तिमीसित हुनेछ। म तिमीलाई भन्नु पर्ने शब्दहरू दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","तर मोशाले भने, “हे मेरो परमप्रभु! मलाई होइन, अरू कसैलाई पठाउनु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","तब परमप्रभु मोशासित रिसाउनु भयो अनि उसलाई भन्नु भयो, “तिम्रो दाज्यू हारून जो लेवी कुलका हुन्। म हारूनलाई तिम्रो सहायताको निम्ति पठाउनेछु। तिनी कुशल वक्ता हुन्। तिमीलाई भेट्न हारून आउदैछन् र तिमीलाई देखेर तिनी खुशी हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ऊ तिमीसंग फिरऊन कहाँ जानेछ। म तिमीहरूलाई भन्नेछु के भन्नु पर्ने हो। तब तिमीले हारूनलाई भन्नुपर्छ, अनि हारूनले फिरऊनसित बोल्ने सही शब्दहरू चुन्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","तिम्रो दाज्यू हारूनले पनि मानिसहरूसंग बोल्ने छन्। तिमी महान राजा जस्तै झैं हुनेछौ अनि हारून तिम्रा अधिकृत वक्ता बनिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","यसर्थ अब तिमी जाऊ। तिमीसित तिम्रो हिड्ने लहुरो लैजाऊ अनि मैले बताएको संकेतहरू मानिसहरूलाई देखाऊ अनि बुझाऊ म तिमीसंगै छु।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","तब मोशा आफ्नो ससूरा यित्रोकहाँ गए। मोशाले तिनलाई भने, “दया गरी मलाई मिश्र देश फर्किन दिनुहोस्। मेरा मानिसहरू अझै जीवित छन् कि? म भेट्न चाहन्छु।” यित्रोले मोशालाई भन्यो, “अवश्य, तिमी शान्तिसित जान सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","जब, मोशा मिद्यानमा थिए, परमप्रभुले उनलाई भन्नुभयो, “अहिले तिमी मिश्रमा फर्केर जानु सुरक्षित छ। ती मानिसहरू जसले तिमीलाई मार्न चाहन्थे अहिले सबै मरिसकेका छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","यसर्थ मोशाले आफ्नो नानीहरू र पत्नीलाई गधामाथि चढाए अनि मिश्र फर्के। तिनले परमेश्वरको शक्ति भएको आफ्नो लहुरो पनि साथै लगे। ");
INSERT INTO npi2010_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","मिश्र जाँदा बाटोमा, परमप्रभुले मोशालाई भन्नुभयो, “जब तिमी फिरऊनसित कुरा गर्छौ मैले तिमीलाई दिएका सबै शक्तिको चमत्कारहरू सबै सम्झना गर। तर म फिरऊनलाई मानिसहरूलाई जान नदिने अट्टेरी बनाउँछु। ");
INSERT INTO npi2010_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","तब तिमीले फिरऊनलाई भन्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","परमप्रभु भन्नुहुन्छ, ‘इस्राएल मेरो जेठो छोरा हो। अनि जान देऊ र मेरा उपासना गर्न देऊ, नत्र भने उहाँले तिमीहरूको जेठो छोरो मारिदिनु हुनेछ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मिश्रको बाटोमा जाँदा, रात बिताउन मोशा एक ठाउँमा रोकिए। परमप्रभुले तिनलाई त्यस ठाउँमा भेटेर मार्ने इच्छा गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","तर सिप्पोराले ढुङ्गाको छुरीले आफ्नो छोराको खतना गरिदिइन्। उसले छाला निकालेर मोशाको खुट्टा छुइन्। तब तिनले मोशालाई भनिन्, “तिमी मेरो रगत को साइनो भएको लोग्ने हौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","सिप्पोराले यसो भनिन् किनभने उसले आफ्नो छोराको खतना गर्नु थियो यसकारण परमप्रभुले मोशालाई क्षमा गर्नुभयो अनि उसलाई मार्नु भएन। ");
INSERT INTO npi2010_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","परमप्रभुले हारूनसित कुरा गर्नु भएको थियो। परमप्रभुले उसलाई भन्नुभएको थियो, “तिमी मरूभूमिमा जाऊ अनि मोशालाई भेट।” यसर्थ हारून गए अनि परमेश्वरको पर्वतमा मोशालाई भेटे अनि मोशालाई चुम्बन दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","मोशाले हारूनलाई बताए किन परमप्रभुले उसलाई पठाउनु भयो अनि कुन चमत्कारहरू र संकेतहरू प्रमाणको निम्ति तिनले देखाउनु पर्ने थियो ती सबै मोशाले हारूनलाई बताए। ");
INSERT INTO npi2010_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","यसर्थ मोशा र हारून गए अनि तिनीहरूले इस्राएली मानिसहरूका सबै अगुवाहरूलाई भेला गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","त्यसपछि हारूनले मानिसहरूसंग कुरा गरे। उनले परमप्रभुले मोशालाई भनेका सबै कुराहरू तिनीहरूलाई बताईदिए। त्यसपछि मानिसहरूलाई देखाउनाको निम्ति सबै प्रमाणहरू प्रदर्शन गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","मानिसहरूले विश्वास गरे परमप्रभुले नै मोशालाई पठाउनु भएको रहेछ। इस्राएलका मानिसहरूले थाह पाए परमप्रभुले तिनीहरूका दुःख अनि कष्ट बुझ्नु भएको छ अनि तिनीहरूको सहायताका निम्ति आउनु भएको छ। यसर्थ तिनीहरू निहुरिए अनि परमेश्वरको आराधना गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","मानिसहरूसंग कुरा गरेपछि मोशा र हारून फिरऊनकहाँ गए। तिनीहरूले भने, “परमप्रभु इस्राएलीहरूका, परमेश्वर भन्नुहुन्छ, ‘मेरो मानिसहरू भरूभूमिमा जाऊन अनि तिनीहरूले मेरो सम्मानमा भोज मनाउन सकून्।’” ");
INSERT INTO npi2010_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","तर फिरऊनले भने, “परमप्रभु को हुनुहुन्छ? मैले किन उहाँको आज्ञा पालन गर्नु पर्छ? मैले किन इस्राएलीहरूलाई जान दिनु पर्छ? म यो परमप्रभुको हो चिन्दिन, अनि म इस्राएलीहरूलाई जान दिंदिनँ।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","तब हारून र मोशाले भने, “हिब्रूहरूका परमेश्वरले हामीसित कुरा गर्नु भयो। यसर्थ हामीहरूलाई तीन दिनसम्म मरूभूमिमा यात्रा गर्न दिनुहोस् भनी विन्ती गर्छौं। हामी परमप्रभु हाम्रा परमेश्वरलाई त्यहाँ बलि चढाउने छौं। यदि हामीले त्यसो गरेनौं भने उहाँले हामीमाथि रोगहरू लगाउनु हुनेछ अथवा शत्रुहरूद्वारा आक्रमण गराउनु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","तर फिरऊनले तिनीहरूलाई भने, “हारून र मोशा! तिमीहरूले कर्मचारीहरूलाई विरक्त पारिरहेका छौ। तिनीहरूलाई आफ्नो काम गर्न देऊ! जाऊ तिमीहरू आफ्नो काम गर। ");
INSERT INTO npi2010_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","हिब्रूहरू ती मिश्रीहरूभन्दा ज्यादै संख्यामा छन्, अनि तिमीहरू उनीहरूलाई काम गर्नबाट रोक्न चाहन्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","त्यही दिन इस्राएलीहरूको निम्ति कठोर काम दिनु भनी फिरऊनले आदेश दिए। फिरऊनले कमारा मालिकहरू र हिब्रू परिदर्शकहरूलाई भने, ");
INSERT INTO npi2010_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“अहिलेसम्म ईंटा बनाउने कर्मीहरूलाई तिमीहरूले पराल दिइरहेका छौ। अब उसो तिनीहरू आफैले पराल बटुल्नु पर्छ अनि ईंटा बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","तिनीहरूले पहिले झैं त्यति नै संख्या ईंटा बनाउनु पर्छ। तिनीहरू अल्छी भएका छन् अनि त्यसैकारण तिनीहरू यहाँबाट जाने अनुमति मागि रहेका छन् त्यसैले तिनीहरू आफ्नो परमेश्वरलाई बलि चढाउन अनुमति माग्दैछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","यसर्थ तिनीहरूलाई कठोर काम दिएर व्यस्त राख। तिनीहरूले मोशाका झूटा कुराहरू सुन्ने समय पाउने छैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","यसर्थ मिश्र देशका कमारा मालिकहरू र हिब्रू परिदर्शकहरू इस्राएली मानिसहरू कहाँ गए र भने, “तिमीहरूलाई ईंटा बनाउन फिरऊनले पराल नदिने निर्णय लिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","तिमीहरू आफै गएर आफ्नो ईंटा बनाउने पराल खोज। तर तिमीहरूले आफ्नो निम्ति पराल खोजेर पनि ईंटा चाँहि पहिले जति बनाउँथ्यौ त्यति नै संख्यामा बनाउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","यसर्थ ती मानिसहरू पराल बटुल्नलाई मिश्र देशमा प्रत्येक ठाउँमा गए। ");
INSERT INTO npi2010_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","कमारा मालिकहरूले मानिसहरूलाई झन कठोर काममा लगाए। तिनीहरूलाई बलपूर्वक पहिले बनाए जति नै ईंटा बाउने आदेश दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","मिश्री कमारा मालिकहरूले हिब्रू परिदर्शकहरूलाई चुनेर मानिसहरूको कामको निम्ति उत्तरदायी बनाएका थिए। मिश्र कमारा मालिकहरूले ती हिब्रू नायकहरूलाई पिटे अनि तिनीहरूलाई भने, “तिमीहरूले किन पहिले जति ईंटा बनाइरहेका छैनौ, यदि तिमीहरूले त्यति समय बनाउन सकथ्यौ भने अहिले बनाउन सक्छौ?” ");
INSERT INTO npi2010_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","त्यसपछि हिब्रू परिदर्शकहरू फिरऊनकहाँ गए। तिनीहरूले अर्जी गरे। “हामी तपाईंका सेवकहरू हौ, किन हामीसित यस्तो व्यवहार गर्नु हुँदैछ? ");
INSERT INTO npi2010_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","तपाईंले हामीलाई पहिला पराल दिंदै हुनु हुन्थ्यो। तर अहिले आफ्नो आफ्नो निम्ति पराल जम्मा गर्नु पर्छ। तर पहिलेको जति नै ईंटाहरू बनाउन हामीलाई भन्नुहुन्छ। अहिले हामीलाई मालिकहरूले कुट्छन्। तपाईंहरूका मानिसहरू यस्तो गरेर गल्ती गर्दैछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फिरऊनले जवाफ दिए, “तिमीहरू अल्छे छौ र तिमीहरू काम गर्न चाहदैनौ यसकारण तिमीहरू मलाई छोडी दिनु भन्छौ। त्यसैले यहाँको काम छोडेर तिमीहरू आफ्नो परमप्रभुलाई बलि चढाउन खोज्छौ। ");
INSERT INTO npi2010_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","अब तिमीहरू आ-आफ्नो काममा जाऊ तर तिमीहरूलाई पराल दिने छैनौ। र तिमीहरूले अब पनि त्यति नै ईंटाहरू बनाउनु पर्छ जति पहिले बनाउँथ्यौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","हिब्रू परिदर्शकहरूले बुझे तिनीहरूले पहिले जाति ईंटा बनाउन सक्ने छैनन् र तिनीहरू अप्ठेरोमा पर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","जब तिनीहरू फिरऊनलाई भेटेर जाँदैथे तिनीहरूले मोशा र हारूनलाई भेटे। मोशा र हारूनले तिनीहरूलाई पर्खिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","यसैकारण तिनीहरूले मोशा र हारूनलाई भने, “तपाईंहरूले साँच्चे गल्ती गर्नु भयो जब तपाईंहरूले फिरऊनलाई हामीलाई छोडने कुरा गर्नुभयो। परमप्रभुले तपाईंहरूलाई दण्ड दिऊन्। किनभने तपाईंहरूले फिरऊन र उसका अधिकारीहरूलाई हामीसित घिनाउने बनाउनु भयो। तपाईंले तिनीहरूलाई हामीलाई मार्ने निहुँ दिनु भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","तब मोशाले परमप्रभुसित प्रार्थना गर्दै भने, “हे मालिक! तपाईंले आफ्नो मानिसहरूसित किन नराम्रो व्यवहार गर्नु भयो? तपाईंले मलाई यहाँ किन पठाउनु भयो? ");
INSERT INTO npi2010_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","म फिरऊनकहाँ गएँ र तपाईंले जे भन्नु भएको थियो त्यही कुरा गरें। तर त्यस समयदेखि फिरऊन तिनीहरू प्रति अधिक क्रोधित भएका छन् अनि तपाईंले तिनीहरूलाई केही सहायता गर्नु भएन।” ");
INSERT INTO npi2010_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","तब परमप्रभुले मोशालाई भन्नुभयो, “अब तिमीले हेर्नेछौ फिरऊनलाई म के गर्नेछु। म मेरो महाशक्ति उसको विरोधमा चलाउनेछु अनि उसले मेरा मानिसहरूलाई जान दिनेछ। तिनीहरूलाई पठाउनको निम्ति फिरऊन यति व्याकुल हुनेछ कि उ आफैले तिनीहरूलाई जबरजस्ती पठाउनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","तब परमेश्वरले मोशालाई भन्नु भयो, “म परमप्रभु हुँ, ");
INSERT INTO npi2010_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","अब्राहाम, इसहाक र याकूबको अघि प्रकट भएको थिएँ। तिनीहरूले मलाई एल-सदाई भने। तिनीहरूले मेरो नाउँ यहोवा (परमप्रभु) भनी जाने। ");
INSERT INTO npi2010_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","मैले तिनीहरूसित करार बाँधे। मैले तिनीहरूलाई बसो-बास गर्न कनान भूमि दिनेछु भनी प्रतिज्ञा गरें। तिनीहरू त्यस भूमिमा बसे तर त्यो भूमि तिनीहरूको आफ्नै थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","इस्राएलीहरू पीरले कराएको मैले सुनेको छु। म जान्दछु इस्राएलका मानिसहरू मिश्र देशका दास हुन्। अनि म मेरो करार सम्झना गर्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","यसर्थ ती इस्राएलका मानिसहरूलाई भन, ‘म परमप्रभु हुँ, म तिमीहरूलाई मिश्रीहरूद्वारा जबरजस्ती लगाएको कामबाट मुक्त गर्नेछु। म तिमीहरूलाई दासत्वबाट स्वतन्त्र गर्नेछु। म यसलाई मेरो महा शक्ति अनि महान न्यायले पूर्ण गर्ने छु। ");
INSERT INTO npi2010_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","तिमीहरू मेरा मानिसहरू हुनेछौ अनि म तिमीहरूका परमेश्वर हुनेछु। म परमप्रभु तिमीहरूको परमेश्वर हुँ र तिमीहरूलाई मैले मिश्रको मानिसहरूबाट स्वतन्त्र पारेको थाह पाउनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","मैले अब्राहाम, इसहाक, याकूबसित महान प्रतिज्ञा गरेको थिएँ। मैले तिनीहरूलाई एउटा देश दिनेछु भनी वचन दिएको थिए। यसैकारण म तिमीहरूलाई त्यो देशमा लानेछु। म त्यो देश तिमीहरूलाई दिनेछु र त्यो देश तिमीहरूको हुनेछ। म परमप्रभु हुँ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","यसर्थ मोशाले इस्राएलीका मानिसहरूलाई प्रत्येक कुरा भने तर मानिसहरू यति कठोर परिश्रम गरिरहेका थिए तिनीहरूले मोशाका कुरा धैर्यसित सुनेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","तब परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“जाऊ अनि मिश्रको राजा फिरऊनलाई भन इस्राएलका मानिसहरूलाई उसको भूमिमा जान दिनोस्।” ");
INSERT INTO npi2010_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","तर मोशाले उत्तर दिए, “इस्राएली मानिसहरूले मेरा कुरा सुन्दैनन् भने। फिरऊनले मेरो कुरा कसरी सुन्छन्? म एउटा एकदमै अयोग्य वक्ता हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","परमप्रभुले मोशा र हारूनसंग कुरा गर्नुभयो। उहाँले तिनीहरूलाई इस्राएली मानिसहरूसित अनि फिरऊनसंग कुरा गर्ने आज्ञा दिनुभयो। परमप्रभुले तिनीहरूलाई भन्नु भयो, इस्राएलका मानिसहरूलाई मिश्रबाट बाहिर लैजाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इस्राएल कुल समूहका अगुवाहरू यिनीहरू हुन्, इस्राएलीको प्रथम पुत्र रूबेन थिए। रूबेनको छोराहरूः हनोक, पल्लू, हेर्सोन र कर्मी थिए। त्यो रूबेनको परिवार थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमोनका छोराहरू हुन् यमूएल, यामिन, ओहद, याकिन, सोहर र शाऊल। (शाऊल कनानी पत्नीबाट जम्मेका छोरा थिए) यो शिमोनको वंश थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवी एक सय सैतीस वर्ष बाँचे अनि उनका छोराहरू गेर्शोन, कहात र मरारी हुन्। ");
INSERT INTO npi2010_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोनका छोराहरू लिब्नी अनि शिमी थिए। तिनीहरूका पनि आफ्नै परिवारहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहात एक सय तेत्तिस वर्ष बाँचे अनि तिनका छोराहरू हुन अम्राम, यिसहार, हेब्रोन र उज्जीएल। ");
INSERT INTO npi2010_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","महली अनि मूशीहरू मरारीका छोराहरू थिए। यी सबै परिवारहरू लेवीबाट जन्म भएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्राम एक सय सैतीस वर्षसम्म बाँचे। तिनले आफ्नो फूपु (पिताको बहिनी) योकेबेदसित विवाह गरे। अम्राम अनि येकेबेदबाट मोशा र हारून जन्मे अम्राम 137 वर्ष बाँचे। ");
INSERT INTO npi2010_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहारका छोराहरू हुन् कोरह, नेपेग, र जिक्री। ");
INSERT INTO npi2010_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","मीशाएल, एल्सापान अनि सिथ्री उज्जीएलका छोराहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारूनले अम्मीनादाबकी छोरी तथा नहशोनकी बहिनी एलीशेबासित विवाह गरे। हारून र एलीशेबाले नादाब, अबीहू, एलाजार अनि ईतामारलाई जन्म दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहका छोराहरू (कोरहका पिता-पूर्खाहरू) हुन्, अस्सीर, एलकाना र अबिआसाप। ");
INSERT INTO npi2010_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारूनका छोरो एलाजारले पतीएलकी छोरीसित विवाह गरे अनि तिनीबाट पीनहास जन्मे। यी सबै मानिसहरू इस्राएलको छोरो लेवीबाट जन्मेका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","हारून र मोशा यही परिवारका हुन। अनि यी दुई जना नै ती मानिसहरू हुन् जोसित परमेश्वरले कुरा गर्नु भयो, “मेरा मानिसहरूलाई दल दलमा मिश्र बाहिर ल्याउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","हारून र मोशा नै ती मानिसहरू हुन जसले मिश्रका राजा, फिरऊनसित कुरा गरे। तिनीहरूले इस्राएली मानिसहरूलाई मिश्रबाट छोडन फिरऊनलाई भने। ");
INSERT INTO npi2010_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","मिश्र देशमा परमप्रभुले मोशासंग कुरा गर्नुभयो र ");
INSERT INTO npi2010_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","उसलाई भन्नुभयो, “म परमप्रभु हुँ। मैले के तिमीहरूलाई जो भने मिश्रको राजा फिरऊनलाई भन।” ");
INSERT INTO npi2010_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","तर मोशाले उत्तर दिए, “म अकुशल वक्ता हुँ, यसर्थ फिरऊनले मेरा कुरा सुन्ने छैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","परमप्रभुले मोशालाई भन्नु, भयो, “म तिमीसंग हुनेछु, फिरऊनको अघि तिमी एकजना देवता जस्तै हुनेछौ अनि हारून तिम्रो अगमवक्ता हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","तिमीले प्रत्येक चीज हारूनलाई भन जो मैले तिमीलाई आज्ञा गरेको छु। त्यसपछि उसले ती सबै कुराहरू फिरऊनलाई भन्नेछ अनि फिरऊनले इस्राएली मानिसहरूलाई मिश्रबाहिर पठाउँनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","तर फिरऊनलाई म अट्टेरी बनाउनेछु। अनि मिश्रमा म धेरै आश्चर्यकर्मका चिन्हहरू देखाउनेछु अनि मैले भनेका कुरा उसले ग्रहण अझै गर्नेछैन् र ");
INSERT INTO npi2010_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","यसैकारण, म मिश्रलाई दण्ड दिनेछु अनि म मेरा इस्राएली मानिसहरूलाई बाहिर ल्याउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","तब मिश्रीहरूले जान्नेछन म परमप्रभु हुँ, म तिनीहरूको विरोधमा हुनेछु अनि तिनीहरूले जान्ने छन्। तब म आफ्नो मानिसहरूलाई तिनीहरूको देशबाट निकाल्ने छु।” ");
INSERT INTO npi2010_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","परमप्रभुले तिनीहरूलाई भनेका कुराहरू मोशा र हारूनले पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","तिनीहरूले जब फिरऊनसित कुरा गरे त्यस समय मोशा 80 वर्ष र हारून 83 वर्षका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फिरऊनले तिमीलाई केही शक्ति प्रदर्शन गर्नु भन्नेछ। हारूनलाई आफ्नो लहुरो फिरऊनको अघि भूईंमा फ्याँक्नु भन। फिरऊन हेरिरहेको हुन्छ, लट्ठी सर्प हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","यसर्थ मोशा र हारूनले परमप्रभुको आदेश पालन गरेर फिरऊन कहाँ गए। हारूनले फिरऊन र तिनका अधिकारीहरूले हेरेको समयमा आफ्नो लहुरो तल फ्याँकिदिए अनि त्यो लहुरो सर्प भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","तब राजाले त्यहाँका ज्ञानी मानिसहरू तथा जादूवालाहरूलाई बोलाए। ती मानिसहरूले आफ्नो तन्त्र-मंत्र प्रयोग गरे र हारूनले गरे जस्तै गर्न सके। ");
INSERT INTO npi2010_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","तिनीहरूले पनि आफ्नो-आफ्नो लहुरो भुईंमा फ्याँके अनि ती फ्याँकेका लहुरोहरू सर्पमा परिणत भए। तर हारूनको लहुरोले सबै लहुराहरु निली दियो। ");
INSERT INTO npi2010_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","तर फिरऊन अट्टेरी नै बसे अनि मानिसहरूलाई जान दिएनन्। यो त्यस्तो भयो परमप्रभुले जस्तो भन्नु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","तब परमप्रभुले मोशालाई भन्नु भयो, “फिरऊन अट्टेरी गरिरहेकोछ। उसले मानिसहरूलाई जान दिंदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","बिहानै फिरऊन नदीतिर जानेछ। नील नदीको किनारमा उसलाई भेट। त्यो सर्प बनिएको लहुरो लगेर जाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","उसलाई यसो भन, ‘परमप्रभु हिब्रूहरूका परमेश्वरले मलाई तपाईंकहाँ यो भन्नु पठाउनु भएको छ: मेरा मानिसहरूलाई मेरो उपासना गर्न मरूभूमिमा पठाऊ।अहिलेसम्म तपाईंले उहाँको कुरा मान्नु भएको छैन।’ ");
INSERT INTO npi2010_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","यसर्थ परमप्रभु भन्नुहुन्छ, ‘उहाँ परमप्रभु हुनुहुन्छ भनी बुझाउनको निम्ति उहाँले तपाईंलाई केही देखाउनु हुनेछ। म यो मेरो हातको लहुरो नील नदीको पानीमा हिर्काउनेछु र नदी रगतमा परिवर्तन हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","नदीका माछाहरू मर्नेछन् अनि पानी गानाउन थाल्नेछ। तब मिश्रका मानिसहरूले नील नदीको पानी पिउनु सक्ने छैनन्।’” ");
INSERT INTO npi2010_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","परमप्रभुले मोशालाई भन्नु भयो, “हारूनलाई भन् कि उसले आफ्नो हातको लहुरोले मिश्र देशका मानिसहरूले जम्मा गरेको पानीको कुवा, नहर, नदी, ताल प्रत्येक ठाउँमा हिर्काओस् जब उसले त्यसो गर्छ सबै पानी रगतमा परिवर्तन हुनेछ। यहाँसम्म तिनीहरूले काठ र ढुङ्गाको भाँडामा राखेको पानी पनि रगत बनिनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","यसर्थ परमप्रभुले आज्ञा गर्नु भएका सबै कुरा मोशा र हारूनले गरे। हारूनले आफ्नो लहुरो उठाएर नील नदीको पानीमा हिर्काए। उसले यसो फिरऊन र उसका अधिकारीहरूको सामुन्नेमा गरे। यसो गरेपछि नदीको सबै पानी रगतमा परिणत भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","पानीका माछाहरू मर्न थाले अनि नदीको पानीबाट कुहेको गन्ध आउन थाल्यो। यसर्थ मिश्रका मानिसहरूले नदीबाट पानी पिउन सकेनन्। मिश्रमा जता ततै रगत भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","जादूगरहरूले आफ्नो मंत्र प्रयोग गरे अनि तिनीहरूले पनि त्यसै गरे। यसर्थ फिरऊनले मोशा र हारूनको कुरा मान्न अस्वीकार गरे। त्यस्तै भयो जस्तो परमप्रभुले भन्नु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फिरऊन आफ्नो राजमहलमा फर्के। मोशा र हारूनले जे गरे त्यस विषयमा उनले त्यती चासो दिएनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","मिश्र देशका मानिसहरूले नदीको पानी खान सकेनन्। यसकारण तिनीहरू नदीको वरिपरि पिउने पानीका लागि कुवाहरू खन्न लागे। ");
INSERT INTO npi2010_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","परमप्रभुले नील नदीलाई परिणत गरेपछि सात दिन बित्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","तब परमप्रभुले मोशालाई भन्नु भयो, “फिरऊन कहाँ जाऊ र भन, परमप्रभु भन्नुहुन्छ, ‘मेरो मानिसहरूलाई मेरो आराधना गर्न जान दिइयोस्। ");
INSERT INTO npi2010_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","यदि तिमी मेरो मानिसहरूलाई छोडन अस्वीकार गर्छौ, तब म मिश्र देशलाई भ्यागुताहरूले भरिदिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील नदी भ्यागुताले भरिनेछ। भ्यागुताहरू नदीबाट आउने छन् अनि तिमीहरूका घरभित्र पस्नेछन्। तिनीहरूको सुत्ने कोठाहरू र ओछ्यानहरू भरि हुनेछन्। भ्यागुताहरू रोटी बनाउने भाँडाहरू अनि अधिकारीहरूका घरहरूमा भरिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","भ्यागुता तपाईं, तपाईंका मानिसहरू र तपाईंका अधिकारीहरूका वरिपरि हुनेछन।’” ");
INSERT INTO npi2010_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","तब परमप्रभुले मोशालाई भन्नु भयो, “हारूनलाई आफ्नो टेक्ने लहुरो नदीहरू, खोला, पोखरीमाथि राख्न भन भ्यागुताहरू बाहिर जमीनमा निस्कनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","यसर्थ हारूनले आफ्नो लहुरो मिश्र देशको पानीमाथि उठाए अनि ती सब पानीबाट भ्यागुताहरू बाहिर निस्केर मिश्रको भूमिमा भरिन थाले। ");
INSERT INTO npi2010_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","जादूगरहरूले पनि त्यसै गरेर मिश्र देशमा भ्यागुताहरू ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","फिरऊनले मोशा र हारूनलाई बोलाए। फिरऊनले भने, “म र मेरा मानिसहरूबाट भ्यागुताहरू हटाउन भनी परमप्रभुलाई भन, म मानिसहरूलाई आफ्नो परमप्रभु अघिबलि चढाउनु छोडीदिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशाले फिरऊनलाई भने, “भन्नुहोस् भ्यागुताहरू कहिले जावोस्। म तपाईं, तपाईंका मानिसहरू तथा तपाईंका अधिकारीहरूको निम्ति प्रार्थना गर्नेछु। तब भ्यागुताहरूले तपाईंहरू र तपाईंका घर छोडने छन् र नदीमा मात्र रहनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फिरऊनले भने, “भोलिसम्म।” मोशाले भने, “तपाईंले जे भन्नु भयो त्यसै हुनेछ। यसरी तपाईंले जान्नु हुनेछ, त्यहाँ कोही परमप्रभु हाम्रा परमेश्वर जस्तो छैन, ");
INSERT INTO npi2010_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","भ्यागुताहरूले तपाईं र तपाईंका मानिसहरू र अधिकारीहरूलाई छोडेर जानेछन, र भ्यागुताहरू नदीमा मात्र रहनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","मोशा र हारून फिरऊनबाट बिदा लिएर बाहिर निस्के। मोशाले परमप्रभुलाई परमेश्वरले फिरऊनकहाँ पठाएका भ्यागुताको विषयमा चिच्याए र भने। ");
INSERT INTO npi2010_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","अनि मोशाले प्रार्थनामा गरेको माग परमप्रभुले पूरा गरिदिनु भयो। भ्यागुताहरू घर, आँगन र खेतमा मरे। ");
INSERT INTO npi2010_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","मरेका भ्यागुताहरू सडेर पूरा देशमा नै दुर्गन्ध चल्न शुरू भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","फिरऊनले देखे तिनीहरू भ्यागुताहरूबाट मुक्त भए अनि फेरि उनी अट्टेरी भए मोशा र हारूनले जे गर्नु भनेका थिए फिरऊनले गरेनन्। त्यस्तै नै भयो जो परमप्रभुले भने। ");
INSERT INTO npi2010_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","तब परमप्रभुले मोशालाई भन्नुभयो, “हारूनलाई भन उसले आफ्नो लहुरो उठाएर भुँईको धूलोमा हिर्काओस् अनि धूलो मिश्रमा जता ततै जुम्रामा परिणत हनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","तिनीहरूले त्यसै गरे। हारूनले जमीनको धूलोमाथि आफ्नो लहुरोले हिर्काए अनि धूलो मिश्रको जता ततै जुम्रामा परिणत भयो। जुम्रा पशु र मानिसहरूमा सरे। ");
INSERT INTO npi2010_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","यसर्थ जादूगरहरूले आफ्नो छल प्रयोग गरेर त्यसरी नै जुम्राहरू उब्जाउने चेष्टा गरे। तर ती जादूगरहरूले धूलोबाट जूम्राहरू बनाउन सकेनन्। जूम्रा मानिसहरू र जनावरहरूमाथि नै रहे। ");
INSERT INTO npi2010_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","यसर्थ जादूगरहरूले फिरऊनलाई भने यो परमेश्वरको शक्तिले यस्तो भयो। तर फिरऊनले तिनीहरूका कुरा सुन्न मानेनन्। परमप्रभुले जे भन्नु भएको थियो त्यही भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","परमप्रभुले मोशालाई भन्नु भयो, “बिहान उठ अनि फिरऊनकहाँ जाऊ। फिरऊन नदीमा जानेछ। उसलाई भन, परमप्रभु भन्नुहुन्छ, ‘मेरा मानिसहरूलाई मेरो आराधना गर्न जानदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","यदि तपाईंले मेरो मानिसहरूलाई जान दिनु हुन्न भने म झीगाहरू तिमी, तिम्रा अधिकारीहरू र तिम्रा मानिसहरूको विरूद्धमा पठाउनेछु। झींगाहरू तिम्रो र तिम्रा अधिकारीहरूका घरहरूमा जानेछन्। मिश्रका सबै घरहरू झींगाले भरिनेछन्। जमीन पनि झीगाले भरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","तर इस्राएलहरू र मिश्रका मानिसहरूसित एकै प्रकारको व्यवहार गर्दिनँ गोशेनमा जहाँ मेरा मानिसहरू बस्छन् त्यहाँ झींगा हुनेछैनन्। यसप्रकार तिमीले चाल पाउँने छौ कि म परमप्रभु यस भूमिमा छु। ");
INSERT INTO npi2010_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","यसर्थ भोलि म अरूलाई भन्दा मेरो मानिसहरूलाई अलग प्रकारले व्यवहार गर्छु। मेरो प्रमाण त्यही हुनेछ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","त्यसपछि परमप्रभुले जे भन्नु भएको थियो, त्यही भयो। धेरै-धेरै झींगाहरू मिश्रमा आए। फिरऊन र तिनका अधिकारीहरूको घर झींगाले भरिए अनि मिश्र देश भरी नै झींगै-झींगा भए। झीगाहरूले देश नै नष्ट पारिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","त्यसपछि फिरऊनले मोशा र हारूनलाई बोलाएर तिनीहरूलाई भने, “यही भूमिमा तिमीहरूले आफ्नो परमेश्वरलाई बलि चढाओ।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","तर मोशाले भने, “यसो गर्नु ठीक हुँदैन। परमप्रभु हाम्रा परमेश्वरलाई पशु बलिदान चढाउँदा मिश्र देशका मानिसहरूले भयानक कुरा हो भनी सम्झन्छन्। यदि यहाँ हामीले बलिदान चढायौ भने मिश्रदेशका मानिसहरूले देख्नेछन् र तिनीहरूले हामीमाथि ढुङ्गा हिर्काउने छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","हाम्रा परमप्रभु परमेश्वरले आज्ञा गर्नु भए झैं परमप्रभुलाई बलिदान चढाउनु हामीलाई तीन दिन मरूभूमिमा यात्रा गर्नु दिनुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","यसर्थ फिरऊनले भने, “म परमप्रभु तिमीहरूका परमेश्वरलाई बलि चढाउन मरूभूमिमा जान दिनेछु। तर तिमीहरू ज्यादै टाढा जान पाउँने छैनौ अहिले जाऊ अनि मेरो निम्ति प्रार्थना गर।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशाले भने, “म बिदा लिन्छु र भोलिनै तिमी, तिम्रा मानिसहरू र तिम्रा अधिकारीहरूका घरबाट झीगाहरू हटाइ दिनु भनी परमप्रभुसित प्रार्थना गर्नेछु। तिमीले परमप्रभुलाई बलि चढाउनमा मानिसहरूलाई बाधा दिनु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","त्यसपछि मोशाले फिरऊनबाट बिदा लिए अनि परमप्रभुलाई प्रार्थना गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","मोशाले विन्ती गरे जस्तै नै परमप्रभुले गर्नु भयो। परमप्रभुले फिरऊन, उसका अधिकारीहरू र उसका मानिसहरूका घरहरूबाट झीगाहरू हटाइदिनु भयो। झोंगा एउटा रहेन। ");
INSERT INTO npi2010_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","तर फिरऊन फेरि अट्टेरी भए अनि मानिसहरूलाई जान दिएनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","तब परमप्रभुले मोशालाई फिरऊनकहाँ गएर यसो भन, “परमप्रभु, हिब्रू मानिसहरूका परमेश्वर भन्नुहुन्छ, ‘मेरा मानिसहरूलाई मेरो आराधना गर्न जान देऊ।’ ");
INSERT INTO npi2010_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","यदि मेरो मानिसहरूलाई जान दिएनौ र रोकी राख्यौ भने, ");
INSERT INTO npi2010_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","तब परमप्रभुले आफ्नो शक्ति तिम्रा खेतका पशुहरूमाथि प्रयोग गर्नुहुनेछ। तिम्रा सबै घोडाहरू, गधाहरू, ऊँटहरू, गाई वस्तुहरू अनि भेडाहरूमाथि भयानक रोगले ग्रस्त हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","परमप्रभुले इस्राएलीहरूको र मिश्रीहरूका पशुहरूलाई भिन्दा भिन्दै व्यवहार गर्नु हुनेछ। इस्राएलीहरूका कुनै पशु मर्ने छैनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","यस्तो अनिष्ट हुने समय परमप्रभुले तोक्नु भएको छ। परमप्रभुले यस्तो विपत्ति यस भूमिमा भोलि ल्याउनु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","परमप्रभुले जे गर्छु भन्नु भएको थियो त्यसै गर्नु भयो। अर्को दिन बिहान मिश्रका सबै पशुहरू मरे। तर इस्राएलीहरूका एउटा पनि पशु मरेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फिरऊनले आफ्नो मानिस इस्राएलीहरूका कुनै पशु मरे कि मरेन पत्तो लगाउन पठायो। तर इस्राएलीहरूका कुनै पशु मरेनन्। फिरऊन अट्टेरी थियो इस्राएली मानिसहरूलाई उसले जानु दिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, “चुल्हाको खरानी हत्केलाभरी लेऊ। मोशा, फिरऊन अधि त्यो खरानी हावामा उडाईदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","त्यो धूलो बनिन्छ र मिश्रको भूमिमाथि उडनेछ। जब धूलोले गर्दा मिश्रका मानिसहरू र पशुहरूलाई छालामा खटिराहरू निस्कनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","यसर्थ मोशा र हारूनले एउटा भट्टीबाट खरानी लिए अनि फिरऊनको अघि उभिए। मोशाले खरानी हावामा फ्याँकिदिए अनि मानिसहरू तथा पशुहरूको छालामा खटिरा निस्कन थाल्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","मोशाले गरे जस्तो जादूगरहरूले गर्न सकेनन् कारण तिनीहरू पनि यस रोगले ग्रस्त थिए। यस्तो मिश्र देशमा जता-ततै भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","तर परमप्रभुले फिरऊनलाई अट्टेरी नै बनाई राख्नु भयो, यसर्थ मोशा र हारूनका कुरा सुन्न उसले अस्वीकार गर्यो। परमप्रभुले मोशालाई भन्नु जस्तै नै भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","तब परमप्रभुले मोशालाई भन्नुभयो, “बिहान चाँडै उठ अनि फिरऊनकहाँ जाऊ। उसलाई भन, ‘परमप्रभु हिब्रू मानिसहरूका परमेश्वर भन्नुहुन्छ, “मेरा मानिसहरूलाई जान देऊ तिनीहरूले मेरो आराधना गरून।” ");
INSERT INTO npi2010_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","यदि मेरा मानिसहरूलाई यसो गर्न दिएनौ भने म मेरो सम्पूर्ण शक्ति तिमी, तिम्रा मानिसहरू अनि तिम्रा अधिकारीहरूमाथि प्रयोग गर्नेछु। तब तिमीले जान्ने छौ संसारमा म जस्तो परमेश्वर अरू छैन। ");
INSERT INTO npi2010_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","तिमी र तिम्रा मानिसहरूलाई यस भूमिबाट बाहिर ल्याउन म मेरो शक्ति प्रयोग गर्न सक्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","तर मैले तिमीलाई मेरो शक्ति प्रकटको निम्ति राखेको हुँ। यसो गर्दा संसारका मानिसहरूले मेरो विषयमा बुझ्ने छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","तिमी अझै पनि मेरो मानिसहरूको विरोधमा छौ कारण तिमीले अझसम्म मुक्ति दिएका छैनौं। ");
INSERT INTO npi2010_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","यसर्थ भोलि यही समयमा अत्यन्तै नराम्रो असिना पार्नेछु। यस प्रकारको असिना मिश्र एउटा राष्ट्र बनिएदेखि कहिल्यै परेको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","अब, तिमीले आफ्नो पशुहरूलाई सुरक्षित ठाउँमा राख्नुपर्छ। प्रत्येक तिम्रो चीच जो अहिले खेतमा छ, त्यो तिमीले सुरक्षित ठाउँमा राख्नुपर्छ। किन? किनभने मानिस होस् अथवा पशु जे पनि खेतमा हुन्छ त्यसलाई मारिनेछ। तिम्रो घर भित्र नराखिएको कुनै पनि वस्तुमाथि असिना पर्नेछ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","फिरऊनका केही अधिकारीहरू ज-जसले परमप्रभुको वचनलाई आदर गरेका थिए, तिनीहरूले आफ्नो पशुहरू र कमारा-कमारीहरू घरभित्र राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","तर अरू मानिसहरूले परमप्रभुको वचन ध्यान दिएका थिएनन् तिनीहरूका पशुहरू अनि कमारा-कमारीहरू खेतमा नै छोडी दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","परमप्रभुले मोशालाई भननु भयो, “तिम्रो पाखुरा हावामामाथि उठाऊ अनि मिश्रभरी असिना पर्न शुरू हुनेछ। मिश्रमा प्रत्येक मानिस, पशु र उद्भिदमाथि असिना पर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","तब मोशाले आफ्नो लहुरो हावामा उठाए अनि परमप्रभुले बिजुली गर्जन र असिनाहरू मिश्रमाथि पठाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","असिना परिरहेको थियो र संग-संगै बिजुली पनि चम्किरहेको थियो। मिश्र एउटा राष्ट्र भए पछि सब भन्दा बढी असिना परेको यही थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","मिश्रका सबै मानिसहरू, पशु अनि उद्भिद आँधी-बेरीले ध्वंश पार्यो। असिनाले खेतका रूखहरू पनि भाँचिदियो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","असिना नपरेको ठाउँ चाँहि गोशेन मात्र थियो जहाँ इस्राएलका मानिसहरू बस्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","फिरऊनले मोशा र हारूनलाई बोलाए। तिनीहरूलाई भने, “यस पल्ट मैले पाप गरेकोछु। परमप्रभु सही हुनुहुन्छ। म र मेरा मानिसहरू गलत छौं। ");
INSERT INTO npi2010_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","परमेश्वर द्वारा परेको असिना अनि गर्जन एकदमै बेशी भयो। परमेश्वरसित आँधी थाम्नको निम्ति प्रार्थना गर, म तिमीहरूलाई जान दिनेछु। तिमीहरूले यहाँ बस्नु पर्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशाले फिरऊनलाई भने, “जब म शहर छोडछु, म मेरो पाखुरा परमप्रभुसंगको प्रार्थनामा उठाउँनेछु गर्जन र असिना पर्न रोकिनेछ। तब तिमीलाई थाहा हुनेछ परमप्रभु यो भूमिमा हुनुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","तर म जान्दछु तिमी अनि तिम्रा अधिकारीहरू अझै पनि परमप्रभु परमेश्वरसित डराएका छैनौ अनि सम्मान गर्दैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","पातमा बिउहरू लागि सकेको थियो अनि जौमा फूल फूलिसकेको थियो। यसकारण यो उद्भिदहरू नष्ट भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","गहूँ र कठिया गहूँ अरू अन्नहरू भन्दा ढिलो उम्रन्छ यसकारण यो नष्ट भएन। ");
INSERT INTO npi2010_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","मोशाले फिरऊनबाट विदा लिए अनि शहर बाहिर गए। उनले आफ्नो हात प्रार्थनामा उठाए गर्जन र असिना रोकियो अनि त्यसपछि पानी पर्न थामियो। ");
INSERT INTO npi2010_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","जब फिरऊनले असिना पानी अनि गर्जन रोकिएको देखे उनले फेरि परमेश्वरको विरूद्ध पाप गरे, फिरऊन र उसका अधिकारीहरू अट्टेरी भए। ");
INSERT INTO npi2010_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","उनले इस्राएलका मानिसहरूलाई स्वतन्त्रता गर्नु अस्वीकार गरे। परमेश्वरले मोशालाई जे भन्नु भएको थियो त्यो पूरा भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","परमप्रभुले मोशालाई भननु भयो, “फिरऊनकहाँ जाऊ। मैले फिरऊन र उसका अधिकारीहरूलाई जिद्दी बनाएको छु। मैले मेरा शक्तिशाली चमत्कारहरू प्रदर्शन गर्न यसो गरें ");
INSERT INTO npi2010_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","अनि तिमीले आफ्नो छोरा-छोरी तथा नाती नातिनाहरूलाई मैले मिश्रमा प्रदर्शन गरेका शक्तिशाली चमत्कारहरू र अन्य चीजहरू भन्न सक्ने छौ। तब तिमीहरू सबैले जान्नेछौ म परमप्रभु हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","यसर्थ मोशा र हारून फिरऊनकहाँ गए। तिनीहरूले उसलाई भने, “परमप्रभु, हिब्रूहरूका परमेश्वर भन्नुहुन्छ, ‘तिमी कहिलेसम्म मलाई अस्वीकार गर्छौ? मेरो मानिसहरू मेरो आराधना गर्न जाऊन्।’ ");
INSERT INTO npi2010_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","यदि तिमीले मेरा मानिसहरूलाई जान दिएनौ भने भोलि म तिम्रो भूमिमा सलहहरू ल्याइ दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","सलहहरूले जमीन ढाक्नेछन। जमीनमा धेरै सलहहरू हुनेछन्। तिमीले जमीन देख्न सक्ने छैनौ। सलहले खेतका प्रत्येक कुरा अनि रूखहरू खानेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","मिश्रमा भएका सबै घरहरू, तपाईंका कर्मचारी र तपाईंका घर सलहहरूले छोप्नेछन्। त्यहाँ तपाईंका पिता-पुर्खाहरूले देखेको भन्दा अधिक सलहहरू हुनेछन। त्यहाँ यति धेरै सलहरू देखियो की मिश्रदेशमा मानिसहरू बसो-वास गर्न लागे यता त्यति कहिल्यै देखिएका थिएनन्।”त्यसपछि मोशाले फिरऊनबाट विदा लिए। ");
INSERT INTO npi2010_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","त्यसपछि कर्मचारीहरूले फिरऊनलाई सोधे, “कहिलेसम्म हामी यी मानिसहरूको फन्दामा परिरहने छौं? तिनीहरूका परमप्रभु परमेश्वरलाई आराधना गर्न मानिसहरूलाई जान दिनोस्। यदि तपाईंले जान दिनु भएन भने, तपाईंले चाल पाउनुअघि नै मिश्र ध्वंश हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","यसकारण फिरऊनका सेवकहरूले मोशा अनि हारूनलाई फिरऊनकहाँ फर्काएर ल्याए। फिरऊनले तिनीहरूलाई भने, “जाऊ अनि परमप्रभु तिमीहरूका परमेश्वरको आराधना गर। तर साँच्चै को जाँदै छन् मलाई भन?” ");
INSERT INTO npi2010_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशाले उत्तर दिए, “हाम्रा केटा-केटी, बूढा-बूढी जति छन् सबै जानेछन्। हामी हाम्रा छोरा-छोरीहरू, हाम्रा भेडा तथा गाई वस्तुहरू पनि लिएर जानेछौं। हामी सबै जानेछौं कारण परमेश्वरको भोज हामी सबैको निम्ति हो।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फिरऊनले तिनीहरूलाई भने, “मैले तिमीहरू र तिमीहरूको केटा-केटीहरूसमेत जान दिंदा मेरो लागि परमप्रभु साँच्चै नै तिमीहरूसित हुनुपर्छ। तिमीहरूले केही नराम्रो योजनाहरू बनाइरहेका छौ। ");
INSERT INTO npi2010_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","होइन! मात्र तिम्रा मानिसहरू परमप्रभुको आराधना गर्न लान सक्छौ।”अनि फिऊनले मोशा र हारूनलाई पठाए। ");
INSERT INTO npi2010_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","परमप्रभुले मोशालाई भन्नुभयो, “तिम्रो पाखुरा मिश्र देशमाथि उठाऊ र सलह आउनेछन अनि मिश्रको समस्त भूमिमा फैलिनेछन्। असिनाले नष्ट नपारेको सबै उद्भिदहरू सलहले खाईदिने छन।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","यसकारण मोशाले आफ्नो टेक्ने लाठ्ठी मिश्र देशमाथि उठाए अनि परमप्रभुले पूर्वबाट आँधी बेरी पठाउनु भयो। हावा बिहान बेलुका पूरै चलिरहयो। जब बिहान भयो मिश्र भूमिमा हावाले सलह ल्यायो। ");
INSERT INTO npi2010_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","सलहहरू मिश्र देशमा उडेर आए अनि जमीनमा बसे। सलह मिश्रदेशमा यति विध्न आए कि यति विध्न न विगतमा कहिल्यै देखिएका थिए न भविष्यमा नै देखिनेछन। ");
INSERT INTO npi2010_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ती सलहहरूले सबै भूमि ढाके अनि मैदान नै छोपे। असिनाले ध्वंश नपारेको जम्मै फलहरू र उद्भिदहरू सलहले खाए। ");
INSERT INTO npi2010_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","फिरऊनले मोशा र हारूनलाई झट्टै बोलायो फिरऊनले भन्यो, “मैले परमप्रभु तिमीहरूका परमेश्वर र तिमीहरूका विरोधमा पाप गरेको छु। ");
INSERT INTO npi2010_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","अब यस पल्टको निम्ति मेरो पाप क्षमा गरिदेऊ। परमप्रभुलाई ममाथि आइलागेको यो ‘मृत्यु’ (सलहहरू) हटाई दिनु भनी भन।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","मोशाले फिरऊनबाट विदा लिएर परमप्रभुलाई प्रार्थना गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","यसर्थ परमप्रभुले हावाको दिशा फर्काएर पश्चिम तिर गर्नु भयो र यसले सलहहरूलाई मिश्रबाट उडायो अनि निगालोको समुद्रमा पुर्यायो। एउटै पनि सलह मिश्रमा रहेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","तर फेरि परमप्रभुले फिरऊनलाई अट्टेरी बनाइदिनु भयो यसकारण उसले इस्राएली मानिसहरूलाई जान दिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","तब परमप्रभुले मोशालाई भन्नु भयो, “तिम्रो हातमाथि हावामा उठाऊ अनि अँध्यारोले मिश्रलाई ढाक्नेछ। अँध्यारो यति निष्पट्ट हुनेछ तिमीले त्यो अनुभव गर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","मोशाले आफ्नो हात उठायो अनि अन्धकारले मिश्रलाई ढाक्‌यो। त्यो अँध्यारो मिश्रमा तीन दिनसम्म रह्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","त्यहाँ कसैले कसैलाई देख्न सक्तैन थियो। तर जहाँ इस्राएलका मानिसहरू थिए त्यहाँ अंध्यारो भएन। ");
INSERT INTO npi2010_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","फेरि फिरऊनले मोशालाई बोलाए। फिरऊनले भने, “जाऊ अनि परमप्रभुको आराधना गर। आफ्नो छोरा-छोरीहरूसंगै लान सक्छौ, तर तिमीले भेडा र गाई-वस्तुहरू यही छोडर जानु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मोशाले भने, “तपाईंले हामीलाई परमप्रभु हाम्रो परमेश्वरलाई बलिदानहरू अनि होमबलिहरू चढाउनु जानु दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","जब हामी परमप्रभुलाई आराधना गर्न जान्छौ। हामीले हाम्रा पशुहरू पनि लाने छौं। एउटै पनि भाग छाडने छैनौं। परमप्रभुको आराधनामा के कुराहरूको आवश्यक पर्छ, त्यो हामी पनि जान्दैनौं। हामीले आफ्नो आवश्यकता त्यस समयमा मात्र बुझ्नेछौं जति बेला हामी हाम्रो गन्तव्य स्थानमा पुग्छौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","परमप्रभुले फेरि फिरऊनलाई अट्टेरी बनाउनु भयो। यसर्थ तिनीहरूलाई जानु दिनुमा फिरऊनले फेरि पनि अस्वीकार गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","तब फिरऊनले मोशालाई भने, “जाऊ, यहाँबाट। तिमी फेरि कहिलै आउनु पर्दैन यदि तिमी मलाई हेर्न आयौ भने, मर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","तब मोशाले फिरऊनलाई भने, “एउटा विषयमा तिमी सही छौ, कारण म तिमीलाई हेर्न फेरि कहिल्यै आउने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","तब परमप्रभुले मोशालाई भन्नु भयो, “मैले अझ फिरऊन अनि मिश्रमाथि एउटा विपत्ति ल्याउनुपर्छ। त्यसपछि मात्र उसले तिमीहरूलाई मिश्रबाट जान मात्र दिंदैन बलपूर्वक जानु भनी जोर लगाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","तिमीले यो समाचार इस्राएलका मानिसहरूलाई दिनु पर्छ ‘पुरूष अनि स्त्रीहरू! तिमीहरूले आफ्नो-आफ्नो छिमेकीहरूसंग सुन र चाँदीले बनिएका चीजहरू माग्नु पर्छ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","परमप्रभुले मिश्रका मानिसहरूलाई तिमीहरूप्रति दयालु हुनेछ। मिश्री मानिसहरू र फिरऊनका शासकहरूले मोशालाई पहिलेदेखि महान मानिस भनी मान्दछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","मोशाले मानिसहरूलाई भने, “परमप्रभु भन्नुहुन्छ, ‘आज मध्य-रातमा म मिश्र भएर जानेछु, ");
INSERT INTO npi2010_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","अनि प्रत्येक पहिला जन्मेको छोरा, फिरऊनको पहिलो छोरो मिश्रको शासक देखि लिएर जाँतो पिस्ने कमारीको पहिलो छोरोसम्म मिश्रमा मार्नेछ। पहिला जन्मिएका सबै मर्छ जसले मकै पिन्छ। पहिला जन्मेको सबै मानिसहरू अनि पशुहरू मर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिश्रमा दुःखको क्रन्दनहरू हुनेछ त्यहाँ मिश्रमा त्यस्तो दुःखपूर्ण क्रन्दनहरू कहिल्यै भएको थिएन अनि त्यहाँ फेरि कहिल्यै हुने छैन। ");
INSERT INTO npi2010_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","तर कुनै पनि इस्राएली मानिसमाथि यस्तो घटना हुनेछैन। यहाँसम्म कि तिनीहरूलाई कुकुरले पनि भुक्ने छैन। इस्राएली मानिसहरूमा मात्र होइन तिनीहरूका पशुहरूलाई पनि कुनै नोक्सान हुनेछैन। तिमीले जान्ने छौ यस प्रकारले म इस्राएली मानिसहरू अनि मिश्रीहरूमा भिन्दा भिन्दै प्रकारको व्यवहार गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","त्यसपछि मिश्रका सबै पदाधिकारीहरू मेरोअघि निहुरिने छन् र मेरो आराधना गर्नेछन्। तिनीहरूले भन्नेछन्, “जाऊ! तिमीसंगै आफ्नो सबै मानिसहरूलाई लैजाऊ।”तब मोशा रिसाएर म फिरऊनलाई छोडनेछु।’” ");
INSERT INTO npi2010_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","तब परमप्रभुले मोशालाई भन्नु भयो, “फिरऊनले तिम्रो कुरा सुनेको छैन। किन? यसकारण म मिश्रमा आफ्नो महाशक्ति देखाउन सकूँ।” ");
INSERT INTO npi2010_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","त्यसैले गर्दा मोशा र हारूनले फिरऊनअघि धेरै आश्चर्य कर्म गर्न सके। र यसैको निम्ति परमप्रभुले फिरऊनलाई अति अट्टेरी बनाउनु भयो, जसले गर्दा उसले इस्राएलीहरूलाई आफ्नो देशबाट जान दिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","जब तिनीहरू मिश्रमा थिए, परमप्रभुले मोशा र हारूनलाई भन्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“यो महिना नै तिमीहरूको निम्ति वर्षको पहिलो महिना हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","यो आदेश इस्राएलका सारा समुदायका निम्ति हो। यो महिनाको दशौं दिनमा आफ्नो घरका मानिसहरूको निम्ति प्रत्येक मानिसले एउटा थुमा ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","एउटा पाठो खाई सक्नलाई यदि कुनै मानिसको घरमा प्रशस्त मानिसहरू नभए उसले त्यस दिनको भोजमा भाग लिनको निम्ति छिमेकीलाई निम्त्याउनु पर्छ। प्रत्येक मानिसलाई पुग्ने पाठो हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","पाठो एक वर्षको र खोट रहित हुनुपर्छ। पाठो भेडा अथवा बाख्राको जुन भए पनि हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","तिनीहरूले त्यो पाठोलाई महिनाको चौधौं दिनसम्म सावधानीसंग राख्नु पर्छ। त्यस दिन इस्राएली समुदायका मानिसहरूले साँझमा ती पाठाहरू मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","यी पशुहरूको रगत सबै मानिसले जम्मा गर्नुपर्छ। अनि ढोकाका चौखटाहरूमा र घरका जहाँ पाठाहरू खाइन्छन ढोकाहरूमाथि छर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“त्यो राती पाठो आगोमा पोलेर खानु पर्छ। तिमीहरूले तितो जडी-बुट्टी र खमीर बिनाको रोटी खानुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","पाठो काँचो अथवा पानीमा उमालेर खानु हुँदैन। त्यो पाठो सबै आगोमाथि सेकाउनु पर्छ, त्यसको भित्र, टाउको र खुट्टाहरू शरीरबाट नछुट्टाई आगोमाथि सेकाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","बिहानसम्म मासुहरू बाँकि नराख। यदि केही मासुहरू रह्यो भने, त्यसलाई आगोमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“जब तिमीहरू भोजन खान्छौ कतै बाहिर यात्रामा जाँदा जस्तै लुगा लाउनुपर्छ। तिमीहरूका खुट्टामा जुत्ता र हातमा टेक्ने लाठी हुनै पर्छ र हतार-हतार खानु पर्छ। किन? किनभने यो परमप्रभुको निस्तार हो। ");
INSERT INTO npi2010_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“आज राती म मिश्रभित्र पस्नेछु अनि पहिले जन्मेका मानिसहरू र पशुहरूलाई नष्ट गर्नेछु। यस प्रकारले म मिश्रका सबै देवताहरूको न्याय गर्नेछु, म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","तर तिमीहरूका घरमा लगाएका रगत चाँहि एउटा विशेष चिन्ह हुनेछ र म जुन घरमा रगत लगाएको देख्छु त्यसलाई छोडेर जान्छु। म मिश्र देशका मानिसहरूको निम्ति हानिकारक रोग उत्पन्न गर्छु। तर त्यो खराब बिमारले तिमीहरू कसैलाई पनि असर गर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“यसकारण यो एउटा स्मरणीय दिन हुनेछ। अनि तिमीहरूको निम्ति यो एक विशेष पवित्र चाड हुनेछ। तिमीहरूका संन्तानहरूले सदा सर्वदा यो पवित्र चाडलाई परमप्रभुलाई भक्ति गर्ने दिनको रूपमा मान्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","यस चाडमा तिमीहरूले अखमिरी रोटी सात दिनसम्म खाने छौ। यस पवित्र चाडको पहिलो दिन तिमीहरूले आफ्नो-आफ्नो घरबाट समस्त खमीर बाहिर निकाल्ने छौ। यो पवित्र चाडमा सात दिनसम्म कसैले पनि खमीर खाने छैनौ। यदि कसैले खमीर त्यस समयमा खायो भने त्यसलाई अरू इस्राएलीबाट बहिष्कृत गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","यो पवित्र चाडको पहिलो र अन्तिम दिनमा पवित्र सभा हुनेछ। यी दिनमा तिमीहरूले केही पनि काम गर्नु हुँदैन। यी दिनमा तिमीहरूको निम्ति एउटै काम भोजन तयार गर्नु हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","तिमीहरूले यो अखमिरी रोटीको पवित्र चाडलाई सम्झना गर्नु पर्छ, कारण यही दिन मैले तिमीहरूलाई मिश्रबाट दल बनाएर बाहिर ल्याए। तिम्रा सन्तानहरू सबैमा सदा-सर्वदा यो एउटा नियम होस्। ");
INSERT INTO npi2010_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","यसर्थ पहिलो महिनाको चौधौं दिनको साँझ देखि तिमीहरूले खमीर बिनाको रोटी खान शुरू गर्ने छौ। तिमीहरूले खमीर बिनाको रोटी पहिलो महिनाको एक्काईसौं दिनको साँझसम्म खानेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","सात दिनसम्म तिमीहरूका घरमा कुनै खमीर रहनु हुँदैन। कुनै पनि मानिस चाहे त्यो इस्राएली होस अथवा विदेशी यदि तिनीहरूले यस समयमा खमीर खायो भने उसलाई इस्राएलीको समुदायबाटै अलग्ग गराउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","यी पवित्र दिनहरूमा तिनीहरू जता सुकै भए पनि खमीर भएको केही पनि खानुँ हुदैन। तिमीहरूले त्यहि खमीर बिनाको रोटी खानु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","यसर्थ मोशाले सबै बूढा-प्रधानहरूलाई बोलाए। मोशाले तिनीहरूलाई भने, “तिमीहरूका परिवारका निम्ति थुमाहरू ल्याऊ। र निस्तारको निम्ति थुमाहरू मार। ");
INSERT INTO npi2010_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","हिसपको झुप्पा लेऊ अनि रगतले भरिएको भाँडामा डुबाऊ अनि ढोकाको चौकटकोमाथि तथा वरिपरि लगाऊ। बिहान नहुञ्जेल कसैले पनि घर छाडनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","जब परमप्रभु मिश्रमा पहिला जन्मेको छोराहरूलाई मार्न जानुहुनेछ अनि ढोकाका फल्याक अनि खाम्बाहरूमाथि रगत पोतेको देख्नु हुनेछ। तब परमप्रभुले त्यस घरलाई रक्षा गर्नु हुँनेछ। उहाँ ती ढोकाद्वारबाट जाँदा परमप्रभुले विनाशक शक्ति ती घरहरूमा पसेर नाशगर्नबाट रोक्नुहुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","तिमीहरूले यो आदेश याद राख्नुपर्छ। यो नियम सदा-सर्वदा तिम्रा सन्तानहरूको निम्ति हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","तिमीहरू जब परमप्रभुले दिनु भएको भूमिमा जानेछौ तिमीहरूले यो चाड पालन गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","जब तिमीहरूका नानीहरूले तिमीहरूलाई सोध्नेछन्, ‘किन हामी यो चाड मनाउछौं?’ ");
INSERT INTO npi2010_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","तब तिमीहरूले जवाफ दिनेछौ, ‘यो निस्तार चाड परमप्रभुको सम्मानमा मानिएको हो। नानीहरूलाई तिमीहरू भन्नेछौ, जब हामीहरू मिश्रमा थियौं, परमप्रभुले इस्राएलीको घरहरू छोडेर जानु भयो। उहाँले मिश्री मानिसहरूलाई मार्नु भयो अनि हाम्रो रक्षा गर्नुभयो।’” यसकारण अहिले मानिसहरू उहाँलाई निहुरिएर दण्डवत गर्छन् र आराधना गर्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","परमप्रभुले यो आदेश मोशा र हारूनलाई दिनु भएको थियो, यसर्थ इस्राएलीहरूले त्यही गरे जे परमप्रभुले आदेश दिनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","मध्यरातमा मिश्र देशीहरूका पहिले जन्मेका सबै छोराहरू, मिश्रका शासक फिरऊनको पहिलो छोरो देखि झ्यालखानामा सजाय भोग्दै गरेको कैदीको छोरोसम्मलाई मार्नुभयो। पशुहरूमा पनि पहिले जन्मेका सबै मार्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","त्यस रात मिश्रमा प्रत्येक घरको कोही न कोही मरे। फिरऊन, उसका अधिकारीहरू अनि मिश्रका सबै मानिसहरू चिच्याँउदै रोए। ");
INSERT INTO npi2010_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","तब त्यस राती फिरऊनले मोशा र हारूनलाई बोलाए। फिरऊनले तिनीहरूलाई भने, “तयार होऊ अनि हाम्रा मानिसहरूलाई छोडेर जाऊ। तिमी र तिम्रा मानिसहरूले त्यसै गर्न सक्छौ जो तिमी भन्छौ तिमीहरू जाऊ अनि आफ्नो परमप्रभुको आराधना गर। ");
INSERT INTO npi2010_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","तिमीहरूले भने झैं आफ्नो-आफ्नो भेडा तथा गाई-वस्तुहरू लिएरै जाऊ। तिमीहरूले मलाई पनि आशीर्वाद देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिश्र देश वासीहरूले पनि भने, “तिमीहरू चाँडै गइहाल। किन? किनभने, यदि तिमीहरू गएनौ भने हामीहरू सबै मर्न सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","इस्राएली मानिसहरू यति हतारमा थिए तिनीहरूले रोटीमा खमीर मिसाउने समय पाएनन्। यसकारण तिनीहरूले आटा, भाडाहरूमा आफ्नो काँधमाथि बोकेर ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","तब इस्राएलीका मानिसहरूले त्यही गरे जे मोशाले तिनीहरूलाई गर्नु भनेका थिए। तिनीहरूले मिश्र देशका आफ्नो छिमेकीहरूसित लुगा, अनि सुन चाँदीले बनिएको चीजहरू माँगे। ");
INSERT INTO npi2010_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","परमप्रभुले मिश्रका मानिसहरूलाई दयालु बनाई दिनु भयो अनि तिनीहरूले जे मांगे त्यही दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएली मानिसहरूले रामसेसबाट, सुक्कोतसम्म यात्रा गरे। तिनीहरू लगभग 6,00,000 थिए। यस संख्यामा नानीहरूको गन्ति गरिएको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","तिनीहरूसित धेरै भेडा, बाख्रा गाई-वस्तु र अरू चीजहरू थिए। तिनीहरूसित अन्य धेरै थरिका मानिसहरू यात्रा गरिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ती मानिसहरूसंग रोटीमा खमीर मिसाउने समय पनि थिएन अनि तिनीहरूले यात्राको निम्ति कुनै विशेष भोजन तयार पारेका थिएनन्। यसकारण तिनीहरूका साधरण खमीर बिनाको रोटी बाहेक अरू कुनै खाने कुरा थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएली मानिसहरू 430 वर्षसम्म मिश्रमा बसे। ");
INSERT INTO npi2010_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ठीक 430 वर्षपछि परमप्रभुका समस्त सेनाहरू मिश्रबाट गए। ");
INSERT INTO npi2010_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","यसर्थ त्यो विशेष छ। जब परमप्रभुले गरेको मानिसहरूले सम्झने छन्। त्यो रात सबै इस्राएली मानिसहरूको हृदयमा सदा-सर्वदा रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, “यहाँ निस्तारका निम्ति विधिहरू छन् कुनै पनि विदेशीले निस्तार चाडको भोजन खान पाउनेछैन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","तर यदि कुनै मानिसले कमारो किन्छ र त्यसको खतना गराइदिन्छ भने, त्यो कमरोले निस्तारको भोजन खान सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","तर तिमीहरूको माझमा बस्ने कुनै पनि ज्यालाका मजदूर अथवा विदेशीहरूले निस्तारको भोजन खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“प्रत्येक परिवारले एउटा घर भित्र नै भोजन गर्नुपर्छ, कुनै पनि भोजन बाहिर लानु हुँदैन। थुमाको कुनै हड्डी भाँच्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएलका सारा समुदायले यो चाड मनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","यदि कोही मानिस तिमीहरूसित बसो-बासो गर्छ तर त्यो इस्राएली होइन र यो परमप्रभुको निस्तार चाडमा भाग लिन चाहन्छ भने उसको खतना गरिनु नै पर्छ। त्यसपछि त्यो इस्राएली नागरिक बराबर हुन्छ र उसले निस्तार भोजनमा भाग लिन सक्छ। तर यदि उसको खतना गरिएको छैन भने निस्तार भोजनमा भाग लिन सक्तैन। ");
INSERT INTO npi2010_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","खतना नभएको कुनै पनि मानिसहरूले परमप्रभुको भोजनमा भाग लिनु हुँदैन। यो प्रत्येक मानिसहरूको लागि यो सत्य र निष्पक्ष नियम हो त्यो देशी अथवा विदेशमा जन्मेका नागरिक होस् यो नियम प्रत्येकलाई हुनुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","यसर्थ इस्राएलका सारा मानिसहरूले परमप्रभुले मोशा र हारूनलाई दिनु भएका आदेशहरू पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","यस प्रकारले परमप्रभुले इस्राएलका सबै मानिसहरूलाई मिश्र देशबाट बाहिर लिएर जानु भयो। मानिसहरू झुन्ड-झुन्डमा यात्रा गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","त्यसपछि परमप्रभुले मोशालाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“तिमीले इस्राएलमा जन्मेको प्रत्येक पहिले पुरूष शिशु मलाई दिनुपर्छ। त्यसको अर्थ हुन्छ पहिला जन्मेको प्रत्येक बालक अनि पहिला जन्मेको प्रत्येक पाठो मेरो हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","मोशाले मानिसहरूलाई भने, “यस दिनलाई सम्झना गर। तिमीहरू मिश्रमा कमारा-कमारीहरू थियौ। तर आजको दिन परमप्रभुले आफ्नो महाशक्ति प्रयोग गरी तिमीहरूलाई स्वतन्त्र पार्नुभयो। तिमीहरूले खमीर मिसाएको रोटी खानै हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आज, आबीबको महीनामा तिमीहरूले मिश्र छाड्यौ। ");
INSERT INTO npi2010_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","परमप्रभुले तिमीहरूका पिता-पुर्खाहरूलाई विशेष वचन दिनुभएको छ। उहाँले तिमीहरूलाई कनानी, हित्ती, एमोरी, हिव्वी अनि यबूसी मानिसहरूको भूमि दिने प्रतिज्ञा गर्नु भयो। परमप्रभुले तिमीहरूलाई त्यस भूमिमा लानु हुनेछ जहाँ दूध र मह बग्छन्। यसकारण तिमीहरूले यो रीति प्रत्येक वर्ष यही महीनामा पालन गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“सात दिनसम्म तिमीहरूले अखमिरे रोटी खानुपर्छ। सातौं दिनमा तिमीहरूले ठूलो भोज गरेर मनाउँनु पर्छ अनि यस भोजले परमप्रभुप्रति सम्मान जनाउँनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","यसर्थ सात दिनसम्म तिमीहरूले अखमिरे रोटी खानु हुँदैन। तिमीहरूको भूमिमा सात दिनसम्म खमीर हुनुहुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","यस दिन तिमीहरूले आफ्नो नानीहरूलाई भन्नु पर्छ, ‘हामी यो भोज खाँदैछौ किनभने आजको दिन परमप्रभुले हामीहरूलाई मिश्रबाट बाहिर ल्याउनु भएको थियो।’ ");
INSERT INTO npi2010_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“यस पवित्र चाडले तिमीहरूलाई सम्झना गराउने छ यो हातमा बाँधेको धागो आँखाअघि राखिएको चिन्ह जस्तो हुनेछ। यस पवित्र दिनले तिमीहरूलाई परमप्रभुले दिनु भएको उपदेशहरू सम्झना गराउनेछ। यसले तिमीहरूलाई त्यही दिनको सम्झना गराउँछ परमप्रभुले आफ्नो महाशक्ति प्रयोग गरेर तिमीहरूमाथि करूणा गर्नु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","यसकारण प्रत्येक वर्ष यो दिनलाई ठीकसित सम्झना गर। ");
INSERT INTO npi2010_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“परमप्रभुले तिमीहरूलाई त्यस भूमिमा लैजानु हुनेछ जसलाई उहाँले तिमीहरूलाई दिनेछु भनी वचन दिनु भएको थियो। अहिले त्यस भूमिमा कनानी मानिसहरू बस्छन्। तर परमप्रभुले तिमीहरूका पिता-पुर्खाहरूलाई त्यो भूमि तिमीहरूलाई दिन्छु भनी वचन दिनु भएको थियो। परमेश्वरले जब तिमीहरूलाई त्यो भूमि दिनुहुन्छ, ");
INSERT INTO npi2010_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","तिमीहरूले सम्झना गर्नु पर्छ। तिमीहरूले आफ्नो पहिलो छोरो अनि पहिलो उहाँलाई समर्पण गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","तिमीहरूले गधा उद्धार गर्नु एउटा थुमा समर्पण गर्न सक्छौ तर यदि गधा गराउनु सकेनौ भने त्यसलाई गर्दन फुटाएर मार्नु पर्छ। तर पहिले जन्मेको छोरो तिमीहरूले परमप्रभुबाट छुट्‌याएर ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“भविष्यमा तिमीहरूका सन्तानले सोध्न सक्छन् ‘तिमीहरूले यस्तो किन गर्छौ?’ अनि तिमीहरूको उत्तर हुनेछ, ‘हामीहरू मिश्र देशमा कमारा-कमारी थियौं अनि परमप्रभुले उहाँको शक्ति प्रयोग गरी हामीलाई यहाँ ल्याउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","मिश्र देशमा फिरऊनले अट्टेरी गरेर हामीलाई त्यहाँबाट बाहिर पठाउन अस्वीकार गरे। यसर्थ परमप्रभुले त्यहाँ जन्मेका प्रत्येक मानिस र पशुका पहिले जन्मेका छोराहरू तथा बच्चाहरू मारिदिनु भयो। यही कारणले मेरा प्रथम जन्मेका छोरो परमप्रभुबाट उद्धार गर्न प्रथम जन्मेको डाँगो पशु भेटी चढाँउँछु।’ ");
INSERT INTO npi2010_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","यो तिमीहरूको हातमा कसेको धागो जस्तै हो र यो तिमीहरूका आँखाको सामुन्ने राखेको चिन्ह जस्तो हो। यसले हामीलाई सधैं सम्झना गर्न सहायता गर्छ कसरी परमप्रभुले उहाँको महाशक्ति चलाएर हामीहरूलाई मिश्रबाट ल्याउनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फिरऊनले मानिसहरूलाई छोडन लगाए। परमप्रभुले मानिसहरूलाई पलिश्तीहरूको भूमिको बाटो जानु दिनु भएन। समुद्रकोबाटो सब भन्दा छोटो छ तर परमप्रभुले भन्नुभयो, “यदि मानिसहरू त्यो बाटो जान्छन् भने तिनीहरूले लडाइँ गर्नु पर्नेछ। यस्तो हुँदा तिनीहरूको मन विचार बदलन सक्छ अनि मिश्रमा नै फर्किएर जानेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","यसकारण परमप्रभुले तिनीहरूलाई अर्को बाटोबाट समुद्र किनाराहुँदै मरूभुमिको बाटो लानु भयो। इस्राएली मानिसहरू मिश्रबाट बाहिर निस्कदा युद्धको पोशाकमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशाले यूसुफको अस्थिहरू लिएर हिंडे। मर्नु अघि यूसुफले इस्राएलीहरूसंग आफ्नो लागि यस्तो गर्ने प्रतिज्ञा गराएका थिए। यूसुफले भने, “जब परमेश्वर तिमीहरूलाई सुरक्षा दिनु हुन्छ मेरा अस्थिहरूलाई मिश्रदेखि बाहिर लान र्नबिस।” ");
INSERT INTO npi2010_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इस्राएलका मानिसहरूले सुक्कोत छाडे अनि एथाममा छाउनी लगाए। एतामम मरूभूमि नजिक थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","परमप्रभुले दिउँसो अग्लो बादललाई र राती अग्लो आगोको खम्बालाई तिनीहरूलाई बाटो देखाउन प्रयोग गर्नु भयो। आगो तिनीहरूलाई उज्यालो दिन्थ्यो र तिनीहरू राती पनि यात्रा गर्न सक्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","अग्लो बादलको खाँबो दिनमा र आगोको खाँबो रातीमा तिनीहरूसंगै हुन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","तब परमप्रभुले मोशालाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलीहरूलाई पी-हहीरोत फर्की जानु भन। तिनीहरूलाई भन, मिग्दोल अनि समुद्रको बीचमा बालसपोन कै नजिक छाउनी लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","फिरऊनले सोच्नेछ इस्राएलका मानिसहरू मरूभूमिमा हराए छन्। अनि उसले सोच्नेछ मानिसहरूको जाने ठाउँ छैन। ");
INSERT INTO npi2010_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","म फिरऊनलाई अट्टेरी बनाउनेछु अनि उसले तिमीहरूको खेदो गर्नेछ, तर म फिरऊन र उसका सेनाहरूलाई पराजित गराउनेछु। तब मिश्रदेशका मानिसहरूले जान्नेछन् कि म परमप्रभु हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","इस्राएलका मानिसहरू भागे भन्ने समाचार फिरऊनले थाहा पायो। जब फिरऊन र उसका अधिकारीहरूले पनि यो खबर सुने, तिनीहरूले के गरेका थिए त्यस विषयमा आफ्नो विचार बद्ली गरे। फिरऊनले भने, “हामीहरूले किन इस्राएली मानिसहरूलाई तिनीहरूको दासत्वबाट जान दियौं?” ");
INSERT INTO npi2010_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","यसर्थ फिरऊनले आफ्नो रथ ठीक पार्यो अनि आफूसंगै आफ्नो मानिसहरूलाई लियो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","उसले आफ्नो सर्वश्रेष्ठ मानिसहरूमध्ये 600 जना अनि आफ्नो सारा रथहरू लिए। प्रत्येक रथमा एकजना अधिकारी थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","इस्राएलका मानिसहरू निडर साथ बढिरहेका थिए, तर परमप्रभुले फिरऊनलाई अट्टेरी बनाइ दिनु भयो, यसर्थ उसले इस्राएलीहरूलाई खेद्‌यो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","मिश्री फौजसित धेरै घोडा, सेना अनि रथहरू थिए। तिनीहरूले इस्राएलीहरूलाई खेदे र लाल समुद्रको नजिक बालसिपोनमा जहाँ तिनीहरूले छाउनी लगाएका थिए तिनीहरूलाई पक्रे। ");
INSERT INTO npi2010_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","इस्राएलीले फिरऊनलाई उसका मिश्रदेशीहरूसित आउँदै गरेको देखे। तिनीहरू साह्रै डराएका थिए अनि तिनीहरूले परमप्रभुलाई गुहार मागे। ");
INSERT INTO npi2010_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","तिनीहरूले मोशालाई भने, “तिमीले हामीहरूलाई मिश्रबाहिर किन ल्यायौ? मिश्रमा के धेरै चिहानहरू थिएनन्? किन तिमीले हामीलाई मरूभूमिमा मार्न ल्यायौं? ");
INSERT INTO npi2010_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","हामीले मिश्रमा तिमीलाई भनेका थियौं, ‘यस्तो परी आउनेछ। मिश्रमा हामीले भनेका थियौ कि हाम्रो चिन्ता नगर्नु होस्।’ हामीलाई मिश्रमा बस्न दिनुहोस र मिश्र वासीहरूको सेवा गर्न देऊ। यसरी मरूभूमिमा आएर मर्नु भन्दा त त्यही बसी कमारा-कमारी हुनु नै असल थियो।” ");
INSERT INTO npi2010_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","तर मोशाले उत्तर दिए, “नडारऊ तिमीहरू जहाँ छौ यही उभिने काम गर अनि हेर आज परमप्रभुले तिमीहरूलाई बचाउनु हुनेछ। तिमीहरूले यी मिश्रबासीलाई फेरि कहिल्यै देख्ने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","तिमीहरूले केही गर्नु पर्दैन तर स्थिर भएर बस। परमप्रभुले तिमीहरूको निम्ति युद्ध गर्नु हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","तब परमप्रभुले मोशालाई भन्नुभयो, “अहिलेसम्म मसंग तिमी किन कराइरहेका छौ? इस्राएली मानिसहरूलाई अघि बढन शुरू गर्नु भन। ");
INSERT INTO npi2010_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","लाल समुद्रमाथि तिम्रो लाठी उठाऊ अनि समुद्र दुइ भाग हुन्छ, तब मानिसहरू सूखा जमीनमा हिंडेर जानेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","मिश्रदेशका मानिसहरूले तिमीहरूलाई खेदिरहेका छन् किनभने मैले तिनीहरूलाई अट्टेरी बनाएको छु। तर म फिरऊन र उसको घोडा तथा रथहरू भन्दा शक्तिशाली छु भन्ने तिमीलाई देखाउने छु। ");
INSERT INTO npi2010_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","तब मिश्रदेशवासीहरू जान्नेछन् कि म परमप्रभु हुँ। जब म फिरऊन, उसका सेना, घोडाहरू तथा रथहरूलाई पराजित पार्नेछु तब त्यहाँका मानिसहरूले मलाई आदर गर्नेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","तब परमप्रभुका स्वर्गदूत मानिसहरूका पछि लागे। (परमप्रभुका स्वर्गदूत खास गरी मानिसहरूलाई डोर्याउन तिनीहरूका अघि-अघि थिए।) यसकारण बादलको खामो मानिसहरूको अघिबाट सरेर पछाडिपट्टि गयो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","यसरी त्यो बादल इस्राएली अनि मिश्रदेशी मानिसहरूको माझमा उभियो। यसले इस्राएलीहरूलाई उज्यालो दियो अनि मिश्रदेशी मानिसहरूलाई अँध्यारो। अँध्यारोले गर्दा फिरऊनका सेनाहरू इस्राएलीहरूको नजिक आउन सकेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","मोशाले आफ्नो लहुरो लाल समुद्रमाथि उठाए अनि परमप्रभुले पूर्वबाट तेजसित बतास चलाइदिनुभयो। बतास रात भरी नै चलिरह्यो, पूर्वीय बतासले समुद्रलाई सुकाइदियो अनि यसलाई दुइ भाग पारि दियो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","इस्राएलका मानिसहरू सूखा जमीनमाथि हिंडेर समुद्र पार गरे। तिनीहरूको दाहिने र देब्रेपट्टि समुद्रको पानी पर्खाल झै उभिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","फिरऊनका घोडसैनिक अनि रथहरूले इस्राएलीहरूलाई समुद्र बीचमा खेदे। ");
INSERT INTO npi2010_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","एकाबिहानै परमप्रभुले बादल अनि आगोको खाँबोबाट मिश्रका सेनालाई हेर्नु भयो। अनि उहाँले तिनीहरूलाई आक्रमण गर्नु भयो अनि पराजित पार्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","रथका पाङग्राहरू भासिए अनि रथलाई नियन्त्रणमा राख्न कठिन पर्यो। मिश्रदेशका मानिसहरू जोरले कराए, “हामी यहँबाट भागौं, परमप्रभु हाम्रो विरूद्ध इस्राएलका मानिसहरूको पक्षमा लडाइँ गर्नु हुँदैछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","तब परमप्रभुले मोशालाई भन्नु भयो, “समुद्रमाथि तिम्रो लहुरो उठाऊ जसले गर्दा पानी मिश्रहरूका घोडाहरू र रथहरूमाथि फर्केर जाऊन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","यसकारण बिहान उज्यालो हुनअघि मोशाले आफ्नो लहुरो समुद्रमाथि उठाए अनि समुद्र फेरि पानीले भरियो। मिश्रका मानिसहरू त्यहाँबाट भाग्ने चेष्टा गर्दै थिए तर परमप्रभुले तिनीहरूलाई समुद्रमा डुबाएर मारिदिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","त्यसको पानी पहिलाको स्थानमा फर्कियो अनि रथ र घोडाहरू सबैलाई डुबायो। फिरऊनका सम्पूर्ण सेनाहरू जो इस्राएलीहरूलाई खेद्‌दै आएका थिए डुबेर नष्ट भए। तिनीहरू कोही पनि बाँचेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","समुद्रको पानी भाग-भाग भएर इस्राएलीहरूको दाहिने र देब्रेपट्टि उभियो र इस्राएलका मानिसहरू सूखा जमीनमा हिंडेर पारि गए। ");
INSERT INTO npi2010_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","यसरी त्यस दिन परमप्रभुले इस्राएलीहरूलाई बचाउनु भयो र ती मानिसहरूले मिश्री मानिसहरू लाल समुद्रको किनारमा देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","इस्राएलका मानिसहरूले परमप्रभुको महाशक्ति थाह पाए जब उहाँले मिश्रका सेनाहरूलाई परास्त गर्नु भयो। यसकारण मानिसहरू परमप्रभुसित डराए। तिनीहरूले फेरि परमप्रभु र उहाँका सेवक मोशामाथि विश्वास गर्नु थाले। ");
INSERT INTO npi2010_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","त्यसपछि मोशा अनि इस्राएलीहरूले परमप्रभुको निम्ति यो गीत गाउन थालेः “म परमप्रभुको निम्ति गाउनेछु! उहाँले महान कार्य गर्नु भयो। उहाँले घोडाहरू तथा सवारीहरूलाई समुद्रमा फ्याँकि दिनुभयो। ");
INSERT INTO npi2010_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","परमप्रभु मेरो शक्ति हुनुहुन्छ, उहाँले मलाई बचाउनु हुन्छ। परमप्रभु मेरो परमेश्वर हुनुहुन्छ, अनि म उहाँको स्तुति गर्छु। परमप्रभु मेरो पिता-पुर्खाहरूको परमेश्वर हुनुहुन्छ अनि म उहाँको आदर गर्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमप्रभु एउटा योद्धा हुनुहुन्छ, उहाँको नाउँ परमप्रभु हो। ");
INSERT INTO npi2010_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","उहाँले फिरऊनका रथहरू, र सेनालाई समुद्रमा मिल्काई दिनु भयो। फिरऊनका अत्यन्तै असल सैनिकहरू लाल समुद्रमा डुबे। ");
INSERT INTO npi2010_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गहिरो पानीले तिनीहरूलाई डुबायो, अनि तिनीहरू ढुङ्गा झै गहिराईमा भासिए। ");
INSERT INTO npi2010_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“तपाईंको दाहिने बाहुली अद्भूत शक्तिशाली छ। हे परमप्रभु, तपाईंको दाहिने बाहुलीले शत्रुको विनाश गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","आफ्नो महान महिमामा तपाईंले ती मानिसहरूको नाश गर्नु भयो, जसले तपाईंको विरोध गरे। तपाईंको रीसले परालको आगोले झैं तपाईंका शत्रुहरूलाई जलायो। ");
INSERT INTO npi2010_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","तपाईंको नाकबाट निस्केको सासले पानीलाई एक ठाउँमा थुपारी दियो। बगिरहेको पानी पर्खाल झैं उभियो। समुद्रको गहिराइ सतहमा ठोस बनियो। ");
INSERT INTO npi2010_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“शत्रुले भन्यो, ‘म तिनीहरूलाई खेद्नेछु र समात्नेछु, म तिनीहरूको सम्पूर्ण सम्पति लुट्नेछु। म मेरो तरवार निकाल्नेछु र तिनीहरूलाई पराजित गर्नेछु।’ ");
INSERT INTO npi2010_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","तर तपाईंले तिनीहरूमाथि फुकिदिनु भयो अनि तिनीहरू समुद्रमा ढाकिए। तिनीहरू नाप्न नसकिने गहिरो समुद्रमा डुबे। ");
INSERT INTO npi2010_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“के कतै परमप्रभु जस्तो अन्य देवाताहरू छन्? अँह, तपाईं झै अन्य देवता कतै छैनन्- तपाईं आश्चर्यपूर्ण पवित्र हुनुहुन्छ! तपाईं विष्मय पूर्ण शक्तिशाली हुनुहुन्छ! तपाईं अचम्मको काम गर्नुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","तपाईं आफ्नो दाहिने बाहुली तेर्साउनु हुन्छ, अनि पृथ्वीलाई नाश गर्नु हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","तर आफूले बचाएका मानिसहरूलाई तपाईंको दयाले डोर्याउनु हुन्छ। अनि आफ्नो क्षमताले तिनीहरूलाई पवित्र प्रसन्न भूमिमा डोर्याउनु हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“अरू राष्ट्रहरूले यो कथा सुन्ने छन् र तिनीहरू डराउने छन्। पलिश्तीका मानिसहरू डरले काम्ने छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोमका प्रमुखहरू डरले काम्नेछन्, मोआबका प्रमुखहरू डरले काम्नेछन्। कनानीहरूले तिनीहरूको साहस हराउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","जब मानिसहरूले तपाईंको शक्ति चाल पाउँछन् तिनीहरू भयभीत हुनेछन्। जबसम्म तपाईंका मानिसहरू पार हुँदैनन्, तिनीहरू चट्टान जस्ता हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","हे परमप्रभु तपाईंले आफ्नो मानिसहरूलाई आफ्नो पर्वतमा डोर्याउनु हुनेछ। तपाईंले बसोबासो गर्न बनाएको सिंहासनको नजिकमा तिनीहरूलाई तपाईंले बस्न दिनु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“परमप्रभुले सदा-सर्वदाको निम्ति शासन गर्नुहुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","हो, साँच्चै नै यस्तै भयो। फिरऊनका घोडाहरू, घोडसवार र रथहरू सबै समुद्रमा डुबे। अनि परमेश्वरले तिनीहरूमाथि समुद्रको सबै पानी ल्याउनुभयो। इस्राएलीहरू समुद्रको माझबाट सूखा भूमिमा हिंडे। ");
INSERT INTO npi2010_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","त्यसपछि हारूनकी दिदी महिला अगमवादिनी मरियमले खैंजडी समातिन मरियम र अरू स्त्रीहरू गाउन र नाच्न थाले। मरियमले यी शब्दहरू दोहर्याइन। ");
INSERT INTO npi2010_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“परमप्रभुप्रति गीत गाऊ! उहाँले महान कार्य गर्नु भएको छ। उहाँले घोडाहरू र सवारहरूलाई समुद्रमा फ्याँकिदिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","मोशाले इस्राएलीहरूलाई लाल समुद्रदेखि शूरको मरूभूमितिर डोर्याउने गरे। तिनीहरू मरूभूमिमा तीन दिनसम्म यात्रा गरे। तिनीहरूले पिउने पानी कतै भेटेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","तीन दिनपछि ती मानिसहरू मारामा आइपुगे। मारामा पानी त थियो तर पिउँन नसकिने तीतो थियो। (यसकारण मानिसहरूले त्यस ठाउँको नाउँ मारा राखे।) ");
INSERT INTO npi2010_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","मानिसहरू मोशासित गुनासो पोख्न थाले। मानिसहरूले भने, “अब हामीहरूले के पिउने छौं?” ");
INSERT INTO npi2010_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","मोशाले परमप्रभुलाई पुकार गरे। यसर्थ परमप्रभुले तिनलाई एउटा रूख देखाउनु भयो। मोशाले त्यस रूखलाई पानीमा डुबाए अनि पानी पिउने लायकको भयो। त्यस ठाउँमा परमप्रभुले मानिसहरूको परीक्षा लिनु भयो अनि तिनीहरूका निम्ति उहाँले नियम बनाइ दिनु भयो। परमप्रभुले ती मानिसहरूमा विश्वासको पनि परीक्षा गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","परमप्रभुले भन्नु भयो, “तिमीहरूले परमप्रभु तिमीहरूका परमेश्वरको आज्ञा पालन गर्नु पर्छ। उहाँले भन्नु भएको आज्ञाहरू तिमीहरूले मान्नै पर्छ। यदि तिमीहरूले उहाँका आज्ञाहरू पालन गर्यौ र नियमहरू मान्यौ भने मिश्रवासीहरू जस्तै तिमीहरू रोगी हुने छैनौ म परमप्रभु हुँ। म एक जना हुँ जसले तिमीहरूलाई स्वस्थ राख्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","तब मानिसहरू एलीमतिर लागे। एलीममा बाह्रवटा जलस्रोत र सत्तरीवटा खजूरको रूखहरू थिए। यसर्थ मानिसहरूले त्यस पानीको नजिक आफ्नो छाउनी बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","त्यसपछि ती मानिसहरूले एलीमबाट यात्रा शुरू गरेर एलीम र सीन बीचको सीनै मरूभूमिमा आइपुगे। तिनीहरू त्यस स्थानमा मिश्र देश छोडेको दोस्रो महीनाको पन्ध्रौं दिनमा आइपुगे। ");
INSERT INTO npi2010_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","इस्राएलका मानिसहरू फेरि गुनासो गर्न थाले। मानिसहरूले मरूभूमिमा मोशा र हारूनको विरूद्ध गुनासो गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","मानिसहरूले भने, “यदि परमप्रभुले हामीलाई मिश्र देशमा नै मर्न दिनु भएको भए राम्रो हुने थियो त्यहाँ हामीलाई खानलाई प्रशस्त अन्न थियो। जे होस त्यहाँ हाम्रो निम्ति हामीले मागेको प्रशस्त खाने कुरो थियो। हामीलाई आवश्यक परेका सबै खाध्यहरू थिए तर अहिले तिमीहरूले हामीहरूलाई यहाँ मरूभूमिमा ल्यायौ अब हामी भोकैले मर्ने भयौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, “म तिमीहरूको निम्ति खाध्य आकाशबाट झारी दिन्छु। त्यो खाध्य तिमीहरूको निम्ति हुनेछ अनि प्रत्येक दिन मानिसहरू बाहिर जान्छन् र आफूलाई चाहिएको खाध्य बटुलेर ल्याउँछन्। मैले मानिसहरूलाई भनेको कुरो गर्छन् अथवा गर्दैनन् त्यो बुझ्नको निम्ति म त्यसो गर्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","छैटौं दिनमा जब मानिसहरूले तिनीहरूको भोजन तयार गर्छन, तिनीहरूले दुई दिनको निम्ति प्रशस्त पुग्ने भोजन तयार गर्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","तब मोशा र हारूनले सारा इस्राएलीहरूलाई भने, “साँझ सम्ममा तिमीहरूले जान्ने छौ परमप्रभुले नै तिमीहरूलाई मिश्र बाहिर ल्याउनु भएको हो। ");
INSERT INTO npi2010_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","तिमीहरूले परमप्रभुलाई गुनासो पोख्यौ अनि उहाँले त्यो गुनासो सुन्नु भयो। यसकारण भोलि बिहान तिमीहरूले उहाँको महिमा थाह पाउनेछौ। तिमीहरू हामीहरूसंग गन-गन गरिरहन्छौ र हुन सक्छ अब हामीले केही आराम पाउँने छौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","अनि मोशाले भने, “तिमीहरूले गन-गन गरिरहेका छौ र परमप्रभुले पनि तिमीहरूको गुनासो सुन्नु भएको छ। यसर्थ आज राती परमप्रभुले तिमीहरूलाई मासु दिनुहुन्छ अनि बिहान तिमीहरूको आवश्यकता अनुसार रोटी दिनु हुनेछ। तिमीहरूले हारून, र मलाई गन-गन गरिरहेका छौ। हुनु सक्छ अब हामीले केही आराम पाउने छौं। यति बुझ तिमीहरू हारून, र मेरो विरूद्धमा होईन तर परमप्रभुको विरूद्धमा गन-गन गरिरहेका छौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","तब मोशाले हारूनलाई भने, “इस्राएली मानिसहरूसंग कुरा गर अनि तिनीहरूलाई भन, ‘परमप्रभुकहाँ संगै आऊ किनभने उहाँले तिमीहरूको गुनासो सुन्नु भएकोछ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","हारून इस्राएलका मनिसहरूसंग बोले। तिनीहरू सबै एक ठाउँमा भेला भएका थिए। जब हारून कुरा गरिरहेका थिए मानिसहरू फर्के र मरूभूमिमा हेरे। अनि तिनीहरूले परमप्रभुको महिमा बादलमा प्रकट भएको देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“मैले इस्राएलीहरूको गुनासो सुनेको छु। यसर्थ तिनीहरूलाई भन, ‘तिनीहरूले आज रातीमासु खानेछन् र बिहान रोटी खानेछन्। तब तिमीहरूले जान्नेछौ म नै परमप्रभु तिमीहरूको परमेश्वर हुँ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","त्यस रात बट्टाई चराहरू छाउनी वरिपरि आए। बिहान त्यहाँतिर सबै छाउनी वरिपरि शीत पारेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","जब शीत सुक्यो भुइँमा पातलो तुसारोको पलाक जस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","इस्राएलीहरूले यी सबै देखेर एक अर्कामा सोधे, “यो के हो?” तिनीहरूले सोधे किनभने तिनीहरूलाई थाहा थिएन यो के थियो। तब मोशाले तिनीहरूलाई भने, “यो परमप्रभुले तिमीहरूलाई दिनु भएको भोजन हो! ");
INSERT INTO npi2010_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","परमप्रभु भन्नु हुन्छ, ‘प्रत्येक मानिसले उसलाई आवश्यक परे जत्ति भोजन जम्मा गर्नु पर्छ, तिमीहरू प्रत्येकले परिवारको एक मानिसको निम्ति एक-एक ओमेर खाध्य जम्मा गर्नु पर्छ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","तब इस्राएली मानिसहरूले यसै गरे। प्रत्येक मानिसले खाध्य बटुले अनि कतिपय मानिसहरूले अरूले भन्दा वेशी खाध्य कुरा बटुले। ");
INSERT INTO npi2010_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","खाध्य ओजन गर्दा प्रत्येकले वेशी बटुल्ने को थियो पाइयो। तर त्यहाँ प्रशस्त चाहिं थिएन। तिमीहरूमध्ये प्रत्येकले आफू र आफ्नो पारिवारलाई खानु पुग्नें भन्दा बढी बटुलेको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मोशाले तिनीहरूलाई भने, “अर्को दिनको निम्ति खाध्य नजोगाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","तर केही मानिसहरूले मोशाको कुरा सुनेन्। ती मानिसहरूले भोलिपल्टको निम्ति पनि खाध्य जोगाए तर खानामा किरा पर्यो र गनाउन थाल्यो। यसकारण त्यसो गर्ने मानिसहरूसंग रिसाए। ");
INSERT INTO npi2010_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","प्रत्येक दिन बिहान मानिसहरूले आफूलाई चाहिए जति भोजन बटुले। तर जब दिन तातिन्थ्यो हराउँथ्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","छैटौं दिनचाहिं मानिसहरूले दुइ गुणा बढी ओमेर खाध्य बटुले तिनीहरूले प्रत्येकका लागि दुई डाला बटुले। यसर्थ अगुवाहरू आए र मोशालाई यो सबै बताए। ");
INSERT INTO npi2010_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","मोशाले तिनीहरूलाई भने, “परमप्रभुले भन्नु भएको जस्तै नै भयो। यसो भयो कारण भोलि परमप्रभुको सम्मानमा मनाइने विश्रामको दिन हो। तिमीहरूलाई जति आवश्यक पर्छ आज त्यति खाध्य पकाउन सक्छौ तर भोलि बिहानको निम्ति यस खाध्यको रहल राख।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","तब मोशाले भने झैं मानिसहरूले अर्को दिनका निम्ति खाध्य बँचाएर राखे तर त्यो खाध्यमा बिग्रिएन, कुनैमा किरा परेन। ");
INSERT INTO npi2010_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","शनिवारको दिन मोशाले मानिसहरूलाई भने, “आज परमप्रभुलाई सम्मान गर्ने विशेष विश्रामको दिन हो। यसर्थ तिमीहरू कोही पनि बाहिर मैदानमा जाने छैनौ र हिजो बचाएको भोजन खाने छौ। ");
INSERT INTO npi2010_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","तिमीहरूले हप्तामा छः दिनको निम्ति खाध्य बटुल्नु पर्छ अनि सातौं दिन विश्रामको दिन हो यसकरण भूईंमा केही कुनै विशेष खाद्य हुनेछैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","केही मानिसहरू सातौं दिनमा पनि खाद्य बटुल्नु गए तर तिनीहरूले केही पनि पाएनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","तब परमप्रभुले मोशालाई भन्नु भयो, “कहिलेसम्म तिम्रा मानिसहरूले मेरो आज्ञाहरू र उपदेशहरू अस्वीकार गर्छन्? ");
INSERT INTO npi2010_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","हेर, परमप्रभुले तिम्रालागि शनिवारलाई एउटा विश्रामको दिन बनाउनु भयो। अनि छैटौं दिनमा परमप्रभुले तिमीहरूलाई दुइ दिनको निम्ति प्रशस्त खाद्य दिनु हुन्छ। सातौंदिनमा तिमीहरू प्रत्येकले विश्राम लेऊ। तिमीहरू जहाँ छौ त्यहीं बस।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","यसर्थ मानिसहरूले सातौं दिनमा विश्राम गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएलीहरूले त्यस विशेष भोजनलाई “मन्न”e भन्न थाले। मन्न मसिनो धनियाँको बिऊ जस्तो सेतो थियो अनि खाँदा मह मिसाएर बनाएको पात्लो रोटी जस्तै स्वादिलो थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशाले भने, “परमप्रभुले भन्नु भयो, ‘तिमीहरूका सन्तानको निम्ति एक ओमेर खाद्य जोगाएर राख। मैले तिमीहरूलाई मिश्रबाट लिएर आउँदा मरूभूमिमा दिएको खाद्य भनी तिनीहरूले हेर्न सक्छन्।’” ");
INSERT INTO npi2010_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","अनि मोशाले हारूनलाई भने, “एउटा भाँडो ल्याऊ र त्यसमा एक ओमेर मन्न भरेर परमप्रभुकोअधि राख। आफ्नो सन्तानको निम्ति जोगाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","परमप्रभुले मोशालाई आज्ञा गरे जस्तै नै हारूनले गरे। हारूनले मन्नको भाँडा लगे अनि करार सामुने राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएलीहरू 40 वर्षसम्म मन्न खाँदै बसे। तिनीहरूले तबसम्म मन्न खाए जबसम्म तिनीहरू जुन भूमिमा बस्नु थियो त्यहाँ आई पुगेनन्। तिनीहरूले कनान प्रदेश नजिकै नपुगुञ्जेल मन्न खाए। ");
INSERT INTO npi2010_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(प्रायः एक ओमेर अर्थात एपको दशौं भागको भाडोद्वारा तिनीहरूले मन्न जोखे।) ");
INSERT INTO npi2010_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","सीनैको मरूभूमिबाट सबै इस्राएली दलसंगै यात्रा गरे। परमप्रभुको आज्ञा अनुसार तिनीहरू एक ठाउँदेखि अर्को ठाउँ यात्रा गरे। जब तिनीहरू रपीदीम पुगे त्यही छाउनी बनाए। त्यस ठाउँमा मानिसहरूको निम्ति पिउने पानी थिएन। ");
INSERT INTO npi2010_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","यसर्थ तिनीहरू मोशाको विरोधमा कुरा गर्न लागे अनि तिनीहरूले भने, “हामीलाई पिउने पानी देऊ।” मोशाले तिनीहरूलाई भने, “तिमीहरू किन मसित बहस गर्छौ? किन परमप्रभुको परीक्षा लिन्छौ?” ");
INSERT INTO npi2010_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","तर मानिसहरू पानीको निम्ति साह्रै तिर्खाएका थिए, यसर्थ तिनीहरूले लगातर मोशा विरूद्ध गन-गन गरिरहे। मानिसहरूले भने, “किन तिमीले हामीलाई मिश्र देशबाट बाहिरा ल्यायौ? के तिमीले हामी हाम्रा बाल-बच्चा तथा गाई-वतुहरू सबै पानी बिना मरून भनी लिएर आएका हौ?” ");
INSERT INTO npi2010_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","अनि मोशाले परमप्रभुलाई विन्ती गरे, “म यी मानिसहरूसित के गर्न सक्छु? तिनीहरू मलाई मार्न तैयार छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","परमप्रभुले मोशालाई भन्नुभयो, “इस्राएली मानिसहरूअघि जाऊ र तिनीहरूबाट केही बूढाप्रधानहरूलाई तिमीसंगै लैजाऊ। र आफ्नो लहुरो पनि ल्याऊ। त्यो लहुरो त्यही हो जुन तिमीले नील नदीमा हिर्काउनमा प्रयोग गरेका थियौ। ");
INSERT INTO npi2010_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","म तिमीहरूको अघि होरेबमा सिनै पर्वतको चट्टानमाथि म हुनेछु। त्यो लहुरोले चट्टानलाई हिर्काउ अनि त्यो चट्टानबाट पानी निस्कनेछ, तब मानिसहरूले त्यो पानी पिउन सक्छन्।” मोशाले त्यही गरे जुन इस्राएलका बूढा-प्रधानहरूले त्यो देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","मोशाले त्यस ठाउँको नाउँ मरीबा र मस्सा राखे किनभने यो त्यही ठाउँ हो जहाँ इस्राएली मानिसहरूले उनको विरोद्धमा गए अनि परमप्रभुको परीक्षा लिएका थिए। मानिसहरू जान्न चाहन्थे, परमप्रभु तिनीहरूसित हुनुहुन्छ अथवा हुन्न। ");
INSERT INTO npi2010_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","रपीदीममा अमालेकी मानिसहरू आए अनि इस्राएली मानिसहरूसित लडाइँ गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","यसर्थ मोशाले यहोशूलाई भने, “केही मानिसहरूलाई छान र भोलि अमालेकीहरूसित युद्ध गर्न जाऊ। म पर्वतमाथि बसेर तिमीलाई हेर्नेछु। म त्यहाँ परमेश्वरको लहुरो पक्वी रहनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","यहोशूले मोशाको आज्ञा पालन गरे। अर्को दिन उनी अमालेकीहरूसित युद्ध गर्न गए। त्यही समय मोशा, हारून र हूर पर्वतको टाकुरामा गए। ");
INSERT INTO npi2010_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","केही समयमा जब मोशाले आफ्नो हात हावामामाथि उठाउँथे इस्राएलीहरूले युद्धमा जित्थे तर जब मोशा आफ्नो हात तल झार्थे अमालेकीहरूले जित्नु शुरू गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","केही समय पछि मोशाका पाखुरा थाके। मोशासित भएका मानिसहरूले बस्नको निम्ति एउटा ढुङ्गा ल्याए अनि हारून र हूरले मोशाको हात उठाएर राखे। मोशाको एकापट्टि हारून र अर्कोपट्टि हूर थिए। तिनीहरूले मोशाको हातहरू घाम नअस्ताउञ्जेलसम्म माथि उठाई राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","यसरी यहोशू र उसका मानिसहरूले अमालेकीहरूलाई यस युद्धमा परास्त गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","तब परमप्रभुले मोशालाई भन्नु भयो, “यस युद्ध बारे एउटा पुस्तकमा लेख अनि यहोशूलाई भन म अमालेकीहरूलाई सम्पूर्ण रूपले ध्वंश गरिदिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","तब मोशाले त्यहाँ एउटा वेदी बनाए। उनले यसको नाउँ दिए, “परमप्रभु मेरो झण्डा हो।” ");
INSERT INTO npi2010_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","मोशाले भने, “मैले परमप्रभुको सिंहासनतिर हात बढाएको थिएँ। यसकारण परमप्रभुले अमालेकीहरूको विरोधमा लडाइँ गर्नु भयो उहाँ यो सधैं गर्नु हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","मोशाका ससूरा यित्रो मिद्यानका पूजाहारी थिए। यित्रोले इस्राएली मानिसहरूलाई परमेश्वरले धैरे प्रकारले सघाएको सुन्नुभयो यित्रोले इस्राएली मानिसहरूलाई परमप्रभुले मिश्रबाट बाहिर ल्याएको कुरा पनि सुने। ");
INSERT INTO npi2010_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","यसर्थ यित्रो मोशा कहाँ गए, यित्रोले मोशाकी पत्नी सिप्पोराहलाई पनि संगै ल्याए (मोशाले सिप्पोरालाई तिनको घरमा पठाएका थिए) किनभने मोशाले उसलाई घर पठाएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","यित्रोले मोशाका दुइ छोराहरूलाई पनि संगै ल्याए। जेठो छोरोको नाउँ गेर्शोम थियो कारण जति बेला छोरो जन्मेको थियो, मोशाले भने, “म परदेशमा प्रवासी भइ रहें।” ");
INSERT INTO npi2010_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अर्को छोरोको नाउँ एलीएजेर राखियो, किनभने जब ऊ जन्मियो तब मोशाले भने, “मेरो पिता-पुर्खाहरू परमेश्वरले मलाई सहायता गर्नु भयो अनि फिरऊनको तरवारबाट मलाई बचाउनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","यित्रो मोशा कहाँ गए जब मोशाले परमेश्वरको पर्वतमाथि मरूभूमिमा छाउनी बनाएका थिए। यित्रोसित मोशाकी पत्नी र दुइजना छोराहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","यित्रोले मोशाकहाँ समाचार पठाए। यित्रोले भने, “म तिम्रा ससूरा यित्रो हुँ। म तिमी कहाँ तिम्री पत्नी र दुवै छोराहरूलाई लिएर आउँदैछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","यसकारण मोशा आफ्नो ससुरालाई भेट्न गए। मोशा उसकोअघि निहुरिए अनि उसलाई चुम्बन गरे। तिनीहरूले एका-अर्काको स्वस्थको बारेमा सोधपूछ गरे। तिनीहरू मोशाको पालमा गए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मोशाले यित्रोलाई प्रत्येक कुरा भने जे परमप्रभुले इस्राएलीहरूको निम्ति फिरऊन र मिश्रलाई गर्नु भएको थियो। मोशाले यित्रोलाई तिनीहरूले यात्रा गर्दा सामना गर्नु परेको स्थितिहरू पनि बताए। परमप्रभुले इस्राएलीहरूलाई सकंट घडीमा कसरी बचाउनु भयो त्यो पनि मोशाले आफ्नो ससुरालाई बताए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","परमप्रभुले इस्राएलका मानिसहरूका निम्ति गर्नु भएका असल कुराहरू सुनेर यित्रो खुशी भए। मिश्र देशीहरूबाट इस्राएलका मानिसहरूलाई परमप्रभुले मुक्त गर्नु भएकोलागि यित्रो आनन्दित थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रोले भने, “परमप्रभुको स्तुति होस! उहाँले तिमीहरूलाई मिश्रका मानिसहरूबाट स्वतन्त्र गराउनु भयो। परमप्रभुले तिमीहरूलाई फिरऊनबाट बचाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","अब म जान्दछु परमप्रभु सबै देवताहरूभन्दा महान् हुनुहुन्छ। तिनीहरूले सोचे तिनीहरू नियन्त्रणमा थिए तर परमप्रभुले के गर्नु भयो!” ");
INSERT INTO npi2010_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","तब यित्रोले परमेश्वरलाई बलिहरू र भेटी चढाए। तब हारून र इस्राएलका सबै बूढा-प्रधानहरू मोशाका ससूरा यित्रोसित परमेश्वरसंगै भोजन गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","अर्को दिन मोशाको मानिसहरूको न्याय गर्ने काम थियो। मानिसहरू दिनभरी नै मोशाकहाँ आए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मोशाले मानिसहरूको न्याय गरेको यित्रोले देखे। उनले सोधे, “यो तिमी एक्लै किन गरिरहेका छौ? तिमी एक्लै न्यायधीश छौ? अनि किन दिनभरी मानिसहरू तिमीकहाँ आइरहन्छन्?” ");
INSERT INTO npi2010_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","तब मोशाले आफ्नो ससुरालाई भने, “मानिसहरू मकहाँ तिनीहरूका समस्याहरूप्रति परमेश्वरको निर्णय के छ त्यो सोध्न आउँछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","यदि तिनीहरूसित भन्ने कुरो छ भने तिनीहरू मकहाँ आउँछन्। कुन मानिस सही छ म निर्णय गर्छु। यसरी म मानिसहरूलाई परमेश्वरले बताउनु भएको नियम र शिक्षाहरू सिकाउँछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","तर मोशाका ससूराले उसलाई भने, “यस्तो कार्य गर्ने यो सही तरीका होइन। ");
INSERT INTO npi2010_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","एक्लो मानिसको निम्ति यो वेशी काम हो। तिमी एक्लै यी सबै कार्यहरू गर्न सक्तैनौ, तिमी थाक्छौ अनि मानिसहरू पनि थाक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","अब मेरो कुरा सुन। मलाई केही सल्लाह दिनु देऊ, अनि म प्रार्थना गर्छु परमेश्वर तिमीसंग हुनु हुनेछ। तिमीले मानिसहरूका निम्ति परमेश्वरको अघि बोल्नु पर्छ, अनि मानिसहरूका मुद्दाहरू सुन्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","तिमीले परमेश्वरका नियम र विधि विधानहरू मानिसहरूलाई सिकाउनु पर्छ। नियमहरू नभत्काउने चेताउनी देऊ। मानिसहरू कसरी बाँच्नु पर्छ सिकाऊ। तिनीहरूले के गर्नु पर्छ बताऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","तर तिमीले ती मानिसहरू मध्ये कोही मानिसहरू न्यायधीश र अगुवाहरू हुने पनि रोज्नु पर्छ। “जसमाथि भरोसा गर्न सक्छौ त्यस्ता असल मानिसहरूलाई छान जो परमेश्वरको सम्मान मान्छन्। यस्ता मानिसहरूलाई रोज जो पैसामा आफ्नो निर्णय परिवर्त्तन गर्दैनन्। अनि यी मानिसहरूलाई मानिसहरूमाथि शासकहरू नियुक्त गर। एक हजार, एक सय, पचास अनि दश मानिसहरूका समूहहरूका शासकहरू हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","यी अगुवाहरूले मानिसहरूलाई न्याय गरून्। यदि कतै महत्वपूर्ण मामला रहे ती शासकहरू तिमीकहाँ आउन सक्छन्। तर अन्य मामलामा तिनीहरूले नै न्याय दिऊन्। यसरी तिम्रो कार्य भारहरू हल्का हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","यदि तिमीले यी कार्यहरू परमप्रभुको इच्छामा गर्छौ भने तिमी आफ्नो कार्य गर्नमा सफल हुनेछौ। अनि त्यही समयमा मानिसहरू आफ्नो समस्याहरू समाधान भएपछि घर जानु सक्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","यसकारण मोशाले आफ्नो ससुराले भने जस्तै गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","उनले इस्राएलीहरूबाट योग्य मानिसहरू छाने। उनले तिनीहरूलाई अरू मानिसहरूमाझ नायक बनाए। उनले मानिसहरूलाई हजार, एक सय, पचास अनि दसको समूहको शासक बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","यी अगुवाहरूका लागि मानिसहरूको न्यायधीश थिए। मानिसहरू यी अगुवाहरू कहाँ सधैं आफ्नो कुराहरू लिएर आउँथे। ");
INSERT INTO npi2010_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","केही समय पछि मोशाले आफ्नो ससूरा यित्रोलाई विदा दिए र यित्रो फर्केर आफ्नो घर गए। ");
INSERT INTO npi2010_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएलीहरू मिश्र छोडेर बसाइँ सर्दा तेस्रो महिनामा सीनै मरूभूमिमा पुगे। ");
INSERT INTO npi2010_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","तिनीहरू रपीदीमबाट सीनै मरूभूमिमासम्म यात्रा गए र तिनीहरूले आफ्नो छाउनी होरेब पर्वतको नजिकै मरूभूमिमा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","तब मोशा परमेश्वरसित भेट गर्न पर्वतमा चढे। परमप्रभुले मोशासित कुरा गर्नु भयो अनि तिनलाई भन्नु भयो, “यी कुराहरू याकूबको ठूलो परिवारलाई भन, ");
INSERT INTO npi2010_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘तिमीहरुले देख्यौ मैले तिमीहरूलाई मिश्रबाट चील झैं ल्याएँ। ");
INSERT INTO npi2010_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","यसकारण म अहिले तिमीहरूलाई मेरा आज्ञा पालन गर अनि मेरो करार अनुशरण गर भन्छु। यदि तिमीहरूले यसो गर्यौ भने तिमीहरू मेरो आफ्नै मानिसहरू हुनेछौ। सम्पूर्ण संसार मेरो हो। ");
INSERT INTO npi2010_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","तिमीहरू मेरो लागि पूजाहारीहरूको एउटा विशेष राष्ट्र हनेछौ।’ मोशा मैले तिमीलाई भनेका कुरा कुराहरू इस्राएली मानिसहरूलाई अवश्यै भन्नुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","मोशा पर्वतबाट तल आए अनि मानिसका अगुवाहरूलाई बोलाए। मोशाले सबै कुरा तिनीहरूलाई भने जुन परमप्रभुले उनलाई आज्ञा दिनुभएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","सबै मानिसहरू राजी हुँदै भने, “परमप्रभुले जे भन्नु हुन्छ हामी गर्ने छौं।” त्यसपछि मोशा फर्केर परमेश्वरकहाँ पर्वतमाथि गए अनि मानिसहरूले भनेका कुरा मोशाले परमप्रभुलाई भने। ");
INSERT INTO npi2010_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","तब परमप्रभुले मोशालाई भन्नु भयो, “म तिमीकहाँ बाक्लो बादलको रूपमा आउनेंछु। म तिमीसित बोल्नेछु। मैले तिमीसंग कुरा गरेको सबैले सुन्ने छन्। म यसो गर्नेछु जसले गर्दा ती मानिसहरूले तिमीले भनेको कुरा सधैं विश्वास गर्नेछन्।” त्यसपछि मानिसहरूले भनेका सबै कुराहरू मोशाले परमेश्वरलाई भने। ");
INSERT INTO npi2010_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","अनि परमप्रभुले मोशालाई भन्नु भयो, “आज र भोलि तिमीले मानिसहरूलाई एक विशेष सभाको निम्ति तयारी राख्नु पर्छ। मानिसहरूले आफ्नो लुगाहरू धुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","अनि तेस्रो दिन मेरो निम्ति तयार होऊ। तेस्रो दिन परमप्रभु सीनै पर्वतमा आउनु हुनेछ अनि सबै मानिसहरूले मलाई देख्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","तर तिमीले मानिसहरूलाई पर्वतदेखि पर बस्नु भनी भन्नु पर्छ। लाईन लगाऊ ताकि मानिसहरूले लाईन पार नगरून्। यदि कुनै मानिस अथवा पशुले पर्वत स्पर्श गरे त्यो मारिनु पर्छ। त्यसलाई ढुङ्गाले हिर्काएर अथवा काँडले हानेर मार्नु पर्छ। तर त्यसलाई कसैले नछोओस्। तुरही नबजुञ्जेल मानिस पर्खि रहनुपर्छ तब मात्र मानिसहरूमाथि पर्वतमा जान सक्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","यसर्थ मोशा पर्वतबाट तल झरे अनि मानिसहरू भएको ठाउँमा गए। तिनले मानिसहरूलाई विशेष सभाको निम्ति तयार पारे अनि तिनीहरूले आ-आफ्नो लुगा धोए। ");
INSERT INTO npi2010_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","तब मोशाले मानिसहरूलाई भने, “तीन दिनपछि परमेश्वरसित हुने सभाको निम्ति तयार बस। त्यस समयसम्म पुरूषहरूले स्त्रीहरूलाई छुनु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","तेस्रो दिन बिहान बाक्लो बादल पर्वतमा झर्यो। त्यहाँ बिजुलीको चमक देखियो आकाशको गर्जनको साथै तुरहीको एकदमै चर्को आवाज सुनियो। छाउनीमा भएका मानिसहरू डराए। ");
INSERT INTO npi2010_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","तब मोशाले मानिसहरूलाई परमेश्वरसंग भेट् गर्न अगुवाई गरे। तिनीहरू पर्वतको फेदिमा नै उभिए। ");
INSERT INTO npi2010_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","सीनै पर्वत धुवाँले ढाकिएको थियो। पर्वतमाथि निस्केको धुवाँ भट्टीदेखि निस्केको जस्तै थियो। यस्तो भयो किनभने परमप्रभु पर्वतमा आगोमा आउनु भयो। सम्पूर्ण पर्वत पनि जोरसित हल्लियो। ");
INSERT INTO npi2010_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","तुरहीको आवाज झन्-झन् चर्को हुदै गयो। प्रत्येक पल्ट मोशाले परमेश्वरसित बोले परमेश्वरले उसलाई गर्जन जस्तो आवाजमा उत्तर दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","अनि परमप्रभु सीनै पर्वतमा ओर्लिनु भयो। परमप्रभु स्वर्गबाट पर्वतको टाकुरामा आउनु भयो। तब उहाँले मोशालाई पर्वतको टाकुरामाथि बोलाउनु भयो अनि मोशा पर्वतमाथि गए। ");
INSERT INTO npi2010_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","परमप्रभुले मोशालाई भन्नु भयो, “तल झर अनि मानिसहरूलाई मेरो नजिक नआउन र मलाई नहेर्ने चेताउनी देऊ। यदि तिनीहरूले त्यसो गरे धेरै जना मर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","पूजाहारीहरूलाई यो पनि भन जो परमप्रभुको सामुन्ने आउँछन् तिनीहरूले आफैंलाई पवित्र बनाउनु पर्छ। तिनीहरूले त्यसो गर्दैनन् भने तब म तिनीहरूलाई दण्ड दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशाले परमप्रभुलाई भने, “तर मानिसहरू सीनै पर्वतमाथि आउन सक्तैनन्। तपाईं आफैले हामीलाई पवित्र भूमिमा धर्का कोर्नु अनि मानिसहरूलाई नाध्न नदिनु भननु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","परमप्रभुले उसलाई भन्नु भयो, “मानिसहरू कहाँ जाऊ, हारूनलाई भेट अनि आफूसंगै मकहाँ लिएर आऊ, तर पूजाहारी र मानिसहरूलाई मेरो नजिक आउन नदेऊ। यदि तिनीहरू नजिक आए म तिनीहरूलाई दण्ड दिनसक्छु।” ");
INSERT INTO npi2010_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","यसर्थ मोशा तल मानिसहरू भएकहाँ गए र तिनीहरूलाई यी सब कुराहरू बताए। ");
INSERT INTO npi2010_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","तब परमप्रभुले भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“म परमप्रभु तिमीहरूको परमेश्वर हुँ। मैले तिमीहरूलाई मिश्र देशबाट बाहिर ल्याएँ जहाँ तिमीहरू कमारा-कमारीहरू थियौ। ");
INSERT INTO npi2010_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“तिमीहरूले मबाहेक अरू कुनै देवता पूज्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“तिमीहरूले कुनै मूर्ति बनाउनु हुँदैन। कुनै प्रकारको मूर्ति अथवा नक्सा नबनाऊ जो आकाशमा अथवा तल पृथ्वीमाथि, पृथ्वी मुनि पानीमा छ। ");
INSERT INTO npi2010_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","कुनै पनि प्रकारको मूर्ति त्यस्तो प्रतिरूपको पूजा नगर र त्यसको अगाडी ननिहुर। म परमप्रभु तिमीहरूका परमेश्वर हुँ। म मेरा मानिसहरूले अरू देवताहरूको पूजा गरेको घृणा गर्छु। यदि कसैले मलाई घृणा गर्छ भने, तिनीहरूका सन्तानहरू, नाती-नातिनाहरूलाई म तिनीहरूको अपराधका निम्ति जिम्मेवार ठह्राउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","तर म हजारौं पुस्तासम्म ती सन्तानहरूसित दयालु हनेछु जसले मलाई प्रेम गर्छ र मेरो आज्ञाहरू पालन गर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“तिमीहरूले परमप्रभु तिमीहरूको परमेश्वरको नाउँ दुरूपयोग गर्नु हुँदैन। जसले परमप्रभुको नाउँको दुरूपयोग गर्छन् तिनीहरूलाई बाँच्न दिनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“विश्राम दिनलाई एक विशेष दिन भनी मान्नु पर्छ भनी सधैं ध्यानमा राख। ");
INSERT INTO npi2010_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","हप्तामा छ दिन आफ्नो काम गर। ");
INSERT INTO npi2010_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","तर सातौं दिन परमप्रभु तिमीहरूका परमेश्वरको सम्मानमा विश्रामको दिन हो। यसर्थ त्यो दिन कसैले पनि काम गर्नु हुँदैन तिमीहरूका कमारा-कमारीहरू, छोरा-छोरीहरू अनि तिमीहरूका पशुहरू तथा तिमीहरूका शहरहरूमा भएका विदेशीहरूले पनि काम गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","किन? किनभने परमप्रभुले छ दिनमा आकाश, पृथ्वी, समुद्र अनि तिनीहरूमा भएका प्रत्येक चीज सृष्टि गर्नु लगाउनु भयो अनि सातौं दिनमा उहाँले विश्राम लिनु भयो। यस प्रकारले विश्राम दिनलाई परमप्रभुले आशीर्वाद दिनु भयो। त्यस दिनलाई परमप्रभुले विशेष दिन बनाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“तिमीहरूले आफ्नो आमा-बाबुलाई आदर गर्न पर्छ। यसो गर्यौ भने तिमीहरू परमप्रभु तिमीहरूको परमेश्वरद्वारा दिइने भूमिमा धेरै समयसम्म बाँच्न सक्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“तिमीहरूले कसैको हत्या गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“तिमीले व्यभिचार गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“तिमीले कुनै चीज चोरी गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“तिमीले अरूको विषयमा झूटो गवाही दिनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“तिमीहरूले छिमेकीहरूका घर, पत्नी, पुरूष अनि स्त्री, कमारा, कमारीहरू अथवा तिनीहरूको केही चीजहरूको चाहना गर्नु हुँदैन” ");
INSERT INTO npi2010_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","यस समयमा मानिसहरूले बेंसीमा गर्जनहरू सुने अनि पहाडमा आगो देखे। तिनीहरूले तुरहीको आवाज सुने। तिनीहरूले पर्वतबाट धुवाँ निस्केको देखे। मानिसहरू डराए र डरले कामे। तिनीहरू पर्वतदेखि धेरै टाढा उभिएर हेरे। ");
INSERT INTO npi2010_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","तब मानिसहरूले मोशालाई भने, “यदि तपाईं हामीसित कुरा गर्न चाहनु हुन्छ भने हामीहरू तपाईंका कुरा सुन्छौ तर दया गरेर परमेश्वरले हामीसंग कुरा नगरून। यदि त्यस्तो भयो भने, हामी मर्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","तब मोशाले मानिसहरूलाई भने, “नडराऊ, परमेश्वर तिमीहरूलाई जाँच्न आउनु भएकोछ। उहाँ चाहनु हुन्छ तिमीहरूले उहाँको डर मान्नु पर्छ। जसले गर्दा तिमीहरूले पाप गर्ने छैनौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","जब मोशा कालो बादलभित्र गए जहाँ परमेश्वर हुनु हुन्थ्यो मानिसहरू पर्वतदेखि टाढै उभिए। ");
INSERT INTO npi2010_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","तब परमप्रभुले इस्राएली मानिसहरूलाई यी कुराहरू भन्नु भनी मोशालाई भन्नु भयो, “स्वर्गबाट मैले तिमीसित कुरा गरेको तिम्रा मानिसहरूले देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","यसकारण म संग-संगै पूज्नको निम्ति चाँदी अथवा सुनको मूर्तिहरू नबनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“मेरो निम्ति एउटा विशेष वेदी बनाऊ। त्यो वेदी बनाउन माटो प्रयोग गर। यो वेदीमा बलिको रूपमा होमबलि अथवा मेलबलि चढाऊ र त्यसको निम्ति आफ्नो भेडा, गाई तथा बाख्राहरूको उपयोग गर। यो काम तिमीहरूले प्रत्येक ठाउँमा गर जहाँ म तिमीहरूलाई मेरो सम्झना गर भन्छु। तब म आउँछु अनि तिमीहरूलाई आशीर्वाद दिन्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","यदि ढुङ्गाको वेदी बनायौ भने फलामको हतियारले काटेको ढुङ्गाहरू नलगाऊ। तिमीहरूको धातुका हतियारले गर्दा वेदी अपवित्र हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","वेदीसम्म पुग्ने सिंढीहरू नबनाऊ। वेदीसम्म जाने सिंढी बनाएर नउक्लनु किनभने त्यसो गर्दा त्यसमाथि तिमीहरूको नग्नता देखिनेछन।तिमीहरूको शरीर लुगाभित्र तलबाट देखिनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","त्यसपछि परमेश्वरले मोशालाई भन्नुभयो, “तिमीले मानिसहरूलाई दिनु पर्ने अन्य नियमहरू यिनै हुन्; ");
INSERT INTO npi2010_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“यदि तिमीहरूले हिब्रू कमारा-कमारी किन्यौ भने त्यसले तिमीहरूको छ वर्षसम्म मात्र सेवा गर्नेछन्। छः वर्षपछि ती स्वतन्त्र हुनेछन्। ती कमाराले तिमीलाई केही पनि तिर्नु पर्नेछैन। ");
INSERT INTO npi2010_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","यदि त्यो मानिस, तिम्रो कमारा हुनअघि विवाह नगरेको भए पत्नी बिनै स्वतन्त्र हुनेछ। तर यदि त्यो मानिस कमारा हुनुअघि नै विवाह गरेको भए उसले आफू स्वतन्त्र हुँदा पत्नीलाई पनि साथै लिएर जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","यदि कमारा अविवाहित छ भने उसको मालिकले उसलाई विवाह गराई दिन सक्नेछ। अनि त्यसरी विवाह भएपछि त्यसकी पत्नीबाट छोरा-छोरी जन्मे त्यसकी पत्नी तथा छोरा-छोरीहरू मालिकका हुन्छन्। त्यस कमाराले आफ्नो सेवा काल पूरा गरी आफू मात्र स्वतन्त्र भएर जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“तर कमाराले भन्न सक्छ, ‘म आफ्नो मालिकलाई प्रेम गर्छु। म आफ्नी पत्नी र नानीहरूलाई पनि प्रेम गर्छु। यसकारण म स्वतन्त्र हुन मन पराउँदिन।’ ");
INSERT INTO npi2010_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","यदि यस्तो परिस्थिति भए त्यस मालिकले उसलाई न्यायकर्त्ता अघि ल्याएर ढोका अथवा ढोकाको चौकटमा उभ्याउने छ र मालिकले कुनै सियोले उसको कान छेडी दिनेछ। त्यसो गरे पछि त्यो कमारा मालिकको सेवामा जीवन भरी रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“कुनै मानिसले आफ्नी छोरीलाई कमारीको रूपमा बेच्न चाहन्छ भने कमारा स्वतन्त्र हुने नियम उसलाई लागू हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","यदि मालिकले विवाह गर्ने योजनामा कमारी किन्छ तर उसित खुशी हुँदैन भने उसको बाबुलाई त्यो कमारी केटी किन्न दिनुपर्छ। त्यो मालिकले अरूलाई बेच्नु हुँदैन किनभने उसले त्यस कमारीलाई धोका दिएको छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","यदि त्यस मालिकले आफ्नी कमारी छोरोसित विवाह गरिदिने वचन दिए उसले त्यस केटीलाई कमारीलाई जस्तो व्यवहार गर्नु हुदैन तर आफ्नो छोरीलाई जस्तो व्यवहार गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“यदि मालिकले अर्की आइमाई विवाह गरे उसले पहिलेकी पत्नीलाई कम्ती खाना र कम्ती लुगा-फाटा दिनु हुँदैन। उसले उसको पहिलो पत्नीलाई लगातार दाम्पत्य अधिकार अवश्यै दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","मालिकले त्यस आइमाईको निम्ति यी तीन प्रकारको कार्यहरू गर्नै पर्छ। यदि उसले त्यसो नगरे त्यो आइमाईले स्वतन्त्रता पाउनु पर्छ अनि आफ्नो स्वतन्त्रताको निम्ति केही तिर्नु पर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“यदि त्यस मानिसले कसैलाई हिर्काएर मार्छ भने त्यो मानिस पनि मारिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","तर यदि कुनै घटना घट्छ र कुनै मानिसले कसैलाई योजना बिनै मार्छ भने, परमेश्वरको इच्छा अनुसार त्यस्तो भएको हो। म यस्तो जग्गा रोज्छु जहाँ मानिसहरू आफ्नो सुराक्षाको निम्ति भागेर जान सक्छन्। मानिसहरू, त्यस ठाउँमा गएर आफ्नो ज्यान जोगाउन सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","तर यदि कसैले कसैलाई घृणा गरी अथवा रीसमा योजना गरी मार्छ भने त्यो हत्याराले दण्ड भोग्नै पर्छ। त्यसलाई मेरो वेदी देखि टाढा लैजाऊ र मार। ");
INSERT INTO npi2010_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“कुनै मानिसले आफ्नो बाबु अथवा आमालाई चोट पुर्यउँछ भने त्यस मानिसलाई मार्नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“यदि कुनै मानिसले कसैलाई कमारा बनाई बेच्न अथवा आफ्नै कमारा बनाउन चोरी गर्छ भने त्यस मानिसलाई मार्नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“यदि कुनै मानिसले आफ्नो आमा-बाबुलाई सराप्छ भने त्यसलाई मार्नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“मानिलेऊ त्यहाँ दुइजना मानिसहरू झगडा गरिरहेका छन्, अनि एउटाले अर्कोलाई मुड्की र ढुङ्गाले हिर्कायो। अथवा त्यो चोट लागेको मानिस मरेन, तर ओछ्यान लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","यदि चोट लागेको मानिस उठेर लहुरोको भरमा यता उता हिंडछ भने हिर्काउनेले चोट लाग्ने मानिसलाई क्षतिपूर्ति दिनुपर्छ अनि स्वस्थ हुने समयसम्म सहायता गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“कोही मालिकले आफ्नो कमारा-कमारीलाई लट्ठीले कुट्छ अनि यस्तो हिकाईले उसको मृत्यु हुन्छ भने त्यो हत्याराले सजाय पाउनैपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","तर यदि कमारा-कमारी मरेन अनि एकदुइ दिनमा राम्रो भई हाल्यो भने हिर्काउने मानिसलाई सजाय हुँदैन। किन? किनभने कमारा-कमारीको निम्ति उसले दाम तिरेको छ र कमारा कमारी उसका सम्पत्ति हुन्। ");
INSERT INTO npi2010_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“दुइ जना मानिस झगडा गर्न सक्छन् अनि यसरी झगडा गर्दा तिनीहरूले कुनै गर्भवती स्त्रीलाई चोट पुग्न सक्छ। यसरी चोट लागेकाले त्यस गर्भवती स्त्रीले समय नपुगी तुह्यो भने। यदि त्यो स्त्रीलाई अन्य कतै चोट नलागे त्यो दोषी मानिसले दण्ड तिर्नु पर्छ। त्यस स्त्रीको पतिले दण्डको रकम तोक्नेछ। न्यायकर्त्ताहरूले त्यस मानिसलाई डाँडको रकम तय गर्नु मद्दत गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","तर यदि त्यस स्त्रीलाई गहिरो चोट लागे, जसले चोट पुर्याउँछ उसले सजाय भोग्नु पर्नेछ। एउटा जीवनको सट्टामा अर्को जीवन लेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","तिमीले आँखाको सट्टामा आँखा, दाँतको सट्टामा दाँतु, हातको सट्टामा हात, खुट्टामा खुट्टा। ");
INSERT INTO npi2010_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","डामको ठाउँमा डाम, खोस्रेको सट्टामा खोस्रिनु नै अनि चोटको ठाउँमा चोट नै लिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“यदि कसैले आफ्नो कमाराको आँखों फुटाउँछ र ऊ आन्धो हुन्छ भने त्यो कमारा केही नतिरी स्वतन्त्र हुन सक्छ। उसको आँखो नै उसले पाउने स्वतन्त्रता दाम हुन्छ। कमारा-कमारी दुवैको निम्ति एउटै नियम लागू हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","यदि कुनै मालिकले कमारालाई मुखमा हिर्काएर दाँत फुकाली दिन्छ भने त्यस कमाराले कुनै पैसा नतिरी त्यो स्वतन्त्र भएर जान सक्छ। उसको दाँत नै उसले तिर्नु पर्ने दाम हुन्छ। यस्तो परिस्थितिमा पनि कमारा तथा कमारीको निम्ति त्यही नियम लागू हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“यदि कसैको गोरूले कुनै पुरूष अथवा स्त्रीहरूलाई मार्छ भने त्यस गोरूलाई पनि ढुङ्गाले हिर्काएर मार्नु पर्छ। तिमीहरूले त्यो गोरूको मासु खानु हुँदैन तर त्यस गोरूको मालिक निर्दोष हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","त्यस गोरूले पहिले कसैलाई हानेको थियो अनि त्यसको मालिकलाई चेताउनी दिइएको थियो तर उसले गोरूलाई बाँधेन। तब तिमीले गोरू र त्यसको मालिकलाई ढुङ्गाले हिर्काएर मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","तर यदि गोरूले हानेर मारिएको मानिसको परिवारले क्षतिपूर्ती लिन्छ भने त्यो गोरूको मालिकलाई मार्नु हुँदैन। तर उसले क्षतिपूर्ती अवश्यै गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“कुनै मानिसको छोरा अथवा छोरी त्यसरी मारिए पनि त्यही नियम लागू हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","तर यदि गोरूले कुनै कमारा अथवा कमारीलाई मारे गोरूको मालिकले कमारा-कमारीको मालिकलाई तीस शेकेल चाँदी तिर्नु पर्छ अनि गोरूलाई ढुङ्गाले हिर्काएर मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“कुनै मानिसले इनारको ढकनी हटाउन सक्छ अथवा मैदानमा एउटा इनार खन्न सक्छ र त्यसको ढकनी लाउँदैन अनि त्यसभित्र एउटा साँढे अथवा गधा खस्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","इनारको मालिकले पशुको क्षतिपूर्ति तिर्नु पर्छ। क्षतिपूर्ति तिरे पछि त्यो जाकिने पशु त्यसको सम्पत्ति हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“यदि कुनै मानिसको गोरूले अर्का मानिसको गोरू मार्छ भने तिनीहरूले जिउँदो गोरूलाई बेच्नु पर्छ तब तिनीहरूले बेचेको मूल्य र मृत गोरू बराबरी बाढनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","तर यदि कुनै मानिसको गोरूले अरू पशुहरूलाई हान्छ भने यसको मालिकले यसलाई नियंत्रण गर्दैन भने उसको गोरूले हानेको पशुको बदलामा पशु दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“यदि कसैले एउटा गोरू अथवा भेडा चोरेर त्यसलाई मार्छ अथवा बेच्छ भने त्यसले त्यो गोरूको बदलामा पाँचवटा गोरू तिर्नु पर्छ अथवा भेडाको बदलामा पाँचवटा भेडाहरू तिर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","यदि चोरलाई राती चोरी गर्दा भेटाएर कसैले मारिदियो भने त्यसको मृत्युमा कोही जिम्मावारी हुदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","तर घटना दिउँसो घटे त्यो मार्ने मानिसलाई हत्याराको दोष लाग्नेछ। यदि तिरो तिर्ने उसमा क्षमता छैन भने त्यो चोर दण्ड तिर्नको निम्ति कमारा जस्तै बेचिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“तर यदि जुन पशु उसले बेच्छ अझै जिउँदै छ भने उसले तिमीलाई चोरिएको प्रत्येक पशुको सट्टामा दुइ दुइवटा पशुहरू दिनुपर्छ। त्यसमा केही फरक पर्दैन। त्यो पशु गोरू, गधा अथवा भेडा जुन सुकै होस्। ");
INSERT INTO npi2010_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“यदि एक जना मानिस उसका पशुहरूलाई छिमेकीको जमीन अथवा दाख बारीमा चर्न दिए त्यस पशुको मालिकले हर्जना स्वरूप आफ्नो खेतको सबभन्दा राम्रो फसल अथवा दाखरस दिनुपर्छ ");
INSERT INTO npi2010_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“एकजना मानिसले आफ्नो खेतको काँडे पोथ्राहरू जलाउन आगो लाउन सक्छ तर उसले लगाएको आगो बढे त्यसले उसको अन्न-बाली बढिरहेको खेती जल्न सक्छ। यस्तो भएको खण्डमा त्यो आगो लगाउने मानिसले उसले जलाएको चीजको जरीमाना तिर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“कुनै मानिसले आफ्नो चीजवीज अथवा पैसा आफ्नो छिमेकीकहाँ राख्न सक्छ। तर यदि ती चीजहरू तथा पैसा छिमेकीको घरबाट चोरी भए उसले के गर्नु पर्छ? यदि चोर पक्राउ परे, उसले चोरेको भन्दा दुइ गुणा ज्यादा तिर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","तर यदि तिमीले चोरलाई पक्रन सकेनौ घर मालिक न्यायकर्त्ताको सम्मुख जानु पर्छ अनि त्यही मानिसले चोरेको हो होइन न्यायकर्त्ताले निर्णय लिनु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“यदि दुइ जना मानिसमा तिनीहरूका साँढे, गधा, भेडा लुगा अथवा केही चीजहरू हराएकोमा झगडा भए, तिनीहरूले के गर्नु पर्छ? एकजनाले भन्नेछ, ‘यो मेरो हो,’ ती दुवै मानिस न्यायकर्त्तासम्मुख जानु पर्छ अनि न्यायकर्त्ताले तिनीहरूबीच को दोषी हो निर्णय गर्नु हुनेछ। त्यो मानिस जसलाई न्यायकर्त्ताले यही दोषी हो भनी निर्णय भएमा उसले त्यस चीजले मूल्य दोबर तिर्नु पर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“कुनै एकजना मानिसले आफ्नो गधा, गोरू, भेडा अथवा अरू कुनै पशु केही समयको निम्ति आफ्नो छिमेकीलाई हेरचाह गर्न भनी छोडन सक्छ। तर यदि त्यो पशु चोरियो अथवा त्यसलाई चोट लाग्यो अथवा मर्यो अनि कसैले त्यस्तो कसरी भयो देखेन, तिमीहरूले के गर्नु पर्छ? ");
INSERT INTO npi2010_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","त्यो उसले चोरेको होइन भनी छिमेकीले स्पष्टीकरण दिनु पर्छ। यदि उसको कुरो साँचो हो भने उसले त्यो पशु मैले चोरेको होइन भनी परमप्रभु अघि कसम खानु पर्छ, त्यस पशुको मालिकले आफ्नो छिमेकीलाई कसम खुवाउनु पर्छ। अनि त्यो छिमेकीले त्यस नोक्सानको निम्ति मालिकलाई केही तिर्नु पर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","तर यदि त्यो पशु छिमेकीले चोरेको भए उसले पशुको मालिकलाई जरीमाना दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","यदि आफ्नो छिमेकीको पशुलाई जंगली जनावरले मारेको हो भने उसले प्रमाणको निम्ति पशुको शरीर ल्याउनु पर्छ। त्यसरी मारिएको पशुको निम्ति मालिकलाई छिमेकीले केही तिर्नु पर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“एकजना मानिसले उसको छिमेकीबाट एउटा पशु पैंचो लियो अनि मालिक नहुँदा पशुलाई चोट लाग्यो अथवा मर्यो भने, पैंचौ लिने मानिसले अवश्यै पशु साट्न पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","तर यदि त्यो मालिक त्यही पशुसित भए उसको छिमेकीले जरीमाना दिनु पर्दैन। अथवा, त्यस छिमेकीले आफूले काम गराउन भनी त्यो पशु ज्यालामा ल्याएको हो। तर त्यो मर्यो अथवा त्यसलाई चोट लागे उसले केही क्षतिपूर्ति तिर्नु पर्दैन। उसले कामको निम्ति दिएको ज्याला नै त्यो नोक्सानको निम्ति प्रशस्त हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“यदि एकजना मानिसले बागदान नभएकी कन्या केटीलाई प्रलोभनमा पार्छ र त्यससित सुत्छ भने उसले त्यो केटीलाई विवाह गर्न पर्छ। अनि उसले त्यो केटीको बाबुलाई सम्पूर्ण दाइजो दिनु पर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","यदि त्यो केटीको बाबुले त्यस केटीलाई उसित विवाह गर्न नदिए पनि त्यस मानिसले बाबु चाँहिलाई पूरा धन दिनु पर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तिमीहरूले आइमाईलाई तंत्र मंत्र गर्न दिनु हुँदैन। यदि उसले मंत्र-तत्रं गर्छे तब उसलाई मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“यदि कुनै मानिसले पशुसित सम्भोग गर्छ भने त्यस मानिसलाई मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“यदि कुनै मानिसले कुनै अर्कै देवतालाई बलि चढाउँछ भने तब त्यस मानिसलाई सर्वनाश पार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“सम्झना गर विगत समयमा तिमीहरू मिश्र देशमा विदेशी थियौ, यसर्थ तिमीहरूको देशमा जो विदेशी छ उसलाई तिमीहरूले ठग्नु अथवा नोक्सान पुर्याउनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“जुन स्त्रीको लोग्ने छैन अथवा जुन केटा-केटीहरूको आमा-बाबु छैनन तिनीहरूको निम्ति कुनै कुभलो गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","यदि कसैले विधवाहरू अथवा टुहुरा-टुहुरीहरूलाई हानि गर्छ तब मलाई यो थाह हुनेछ अनि तिनीहरूको कष्ट म सुन्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","अनि म तिमीहरूसित रिसाउनेछु अनि तिमीहरूलाई तरवारले मार्नेछु। तब तिमीहरूका पत्नीहरू विधवा र नानीहरू टुहुरा-टुहुरी हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“यदि मेरा मानिसहरूमा कोही गरीब छ र तिमीहरू उसलाई ऋण दिन्छौ भने तिमीले उसलाई पैसाका लागि ब्याज लिनु हुँदैन अनि तिमीले उसलाई ऋण फर्काउन जोर दिनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","कुनै मानिसले ऋण लिंदा आफ्नो कोट बन्धक राख्न सक्छ। तर तिमीले त्यो कोट सूर्यास्त हुनअघि नै फर्काउनु पर्छ ");
INSERT INTO npi2010_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","किनभने त्यो मानिसको आफ्नो शरीर ढाक्ने लुगा केही हुँदैन र राती जाडोले सुत्नु सक्तैन। अनि यदि त्यस मानिसले मलाई पुकारे म उसको पुकार सुन्नेछु। म उसको पुकार सुन्छु कारण म दयालु छु। ");
INSERT INTO npi2010_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“तिमीहरूले तिमीहरूका परमेश्वर अथवा तिमीहरूका शासकहरूलाई सराप्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“बाली उठाउने समयमा तिमीहरूले आफ्नो खेतबारीको पहिलो फसल र दाखरस मलाई चढाउन पर्छ। यसो गर्नमा ढिलो नगर्नु। “तिमीहरूका जेठा छोरा मलाई चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","तिमीहरूले पशुहरूको पहिला जन्मेको बाछो र पाठो मलाई चढाऊ। बाछा अनि पाठो आफ्नो माऊसंग सात दिनसम्म बसून, अनि त्यसलाई आठौं दिनमा मलाई चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“तिमीहरू विशेष मानिसहरू हौ। यसर्थ जंगली जनावरले मारेको पशुको मासु खानु हुँदैन। त्यो कुकुरले खाओस्। ");
INSERT INTO npi2010_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“कसैको विरोधमा झूटो नबोल। यदि तिमी अदालतमा साक्षी छौ भने झूठो बोलेर दुष्ट मानिसहरूलाई सधाउनमा सहमत न होऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“गल्ती कर्म गर्ने मानिसहरूको समूहमा सामेल नहोऊ। यदि तिमीहरूले अदालतमा साक्षी दिनु परे बहुसंख्यकको पक्षमा नलाग। ");
INSERT INTO npi2010_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“मुद्दा मामला लागेको मानिसहरूलाई गरीब भए पनि सहयोग नगर। ");
INSERT INTO npi2010_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“यदि तिमीले तिम्रो शत्रुको हराएको गोरू अथवा गधा भेटायौ भने उसको पशु उसलाई नै फर्काई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“यदि तिमीले देख्यौ तिम्रो शत्रुको गधा गह्रौं भारीको कारणले लड्‌यो तिमीले त्यसलाई उठाएर सहायता गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“गरीब मानिससति न्यायालयमा अन्याय नगर। ");
INSERT INTO npi2010_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“कसैलाई झूटो दोष नलगाऊ। एउटा निर्दोष मानिसको हत्या नगर जसले अन्याय गरेको छ त्यसलाई म निर्दोष मान्दिन। ");
INSERT INTO npi2010_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“घूस स्वीकार नगर, घूसले न्यायलाई अन्धा बनाउन सक्छ अनि निर्दोष मानिसको अधिकारलाई अस्वीकार गर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“विदेशी नागरिकहरूमाथि कहिले पनि अत्याचार नगर। एक समयमा तिमीहरू पनि मिश्र देशमा विदेशी थियौ यसकारण तिमीहरू जान्दछौ एउटा विदेशी कस्तो हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“छ वर्षसम्म आफ्नो जमीनमा बीउ छर, फसल काट। ");
INSERT INTO npi2010_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","तर सातौं वर्षमा त्यो जमीन उपयोग नगरू। त्यस जमीनमा कुनै बिरूवा नरोप, तर यदि त्यहाँ केही चीजहरू आफैं उब्जन्छ भने गरीबहरूलाई खान देऊ। अनि छोडिएको अन्नहरू जनावरहरूलाई खान देऊ। तिम्रा दाखको बगैंचा र भद्राक्षको रूखहरूमाथि पनि त्यसरी नै व्यवहार गर। ");
INSERT INTO npi2010_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“छ दिनसम्म काम गर सातौं दिन विश्रामको दिन हो। यसो गर्दा तिमीहरूका गोरूहरू गधाहरू, कमारा-कमारीहरू अनि विदेशीहरूले पनि विश्राम गर्ने समय पाउँन। ");
INSERT INTO npi2010_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“मैले भनेका सबै काम गर्न निश्चित होऊ। अरू देवताहरूको पूजा नगर। तिमीले तिनीहरूको नाउँ पनि उच्चारण नगर। ");
INSERT INTO npi2010_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“प्रत्येक वर्षको तीन पल्ट तिमीहरूले मेरो निम्ति विशेष चाड आयोजना गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","जब तिमीहरूले अखमिरे रोटीको चाड मनाउँछौ तिमीहरूले मेरा आज्ञाहरू पालन गर्नु पर्छ। त्यस समयमा तिमीहरूले अखमिरे रोटी खानेछौ। यो सात दिनसम्म यस्तै चलिरहन्छ। तिमीहरूले यसो आबीब महीनामा गर्नेछौ किनभने त्यही समयमा जब तिमीहरू मिश्रबाट निस्केर आएका थियौ। त्यो समयमा तिमीहरूले मेरो निम्ति एउटा भेटी ल्याउनु नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“जब प्रत्येक वर्ष तिमीहरूले लगाएको बालीको प्रथम फलहरू उठाउनु शुरू गर्छौ। “तिमीहरूले अन्न भित्र्याउने चाढ मनाउनु पर्छ अनि वर्षको अन्तमा जब बालीको अन्तिम फल उठाउछौ त्यस समय छाप्रोवासको चाड मनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“यसर्थ एक वर्ष भित्र सबै मानिसहरूले परमप्रभु तिमीहरूका मालिक कहाँ तीन पल्ट आउन पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“जब तिमीले पशु मारेर त्यसको रगत बलि चढाउँछौ खमीर मिसाएको रोटी चढाउनु हुँदैन। अनि त्यो बलि चढाएको पशुको मासु खान्छौ भने त्यो एकै दिनमा खाई सक्नु पर्छ। अर्को दिनको निम्ति मासु नराख। ");
INSERT INTO npi2010_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“जब तिमीहरूले पहिलो बाली उठाउँछौ, तिमीहरूले उब्जाउ परमप्रभु आफ्नो परमेश्वरको घरमा ल्याउनु पर्छ। “तिमीहरूले पाठोको मासु खानु हुँदैन जसलाई त्यसकै माउको दूधमा उमालिन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","परमेश्वरले भन्नुभयो, “म तिम्रोअघि एकजना स्वर्गदूत पठाउँदैछु। त्यस स्वर्गदूतले तिमीहरूलाई मैले तयार पारेको ठाउँमा पुग्नमा मद्दत गर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","त्यस स्वर्गदूतले भनेको मान र उसलाई पछ्याऊ। त्यसको विरोध नगर। त्यस स्वर्गदूतले तिमीहरूले गरेको कुनै प्रकारको भूल काम क्षमा गर्ने छैन। मेरो शक्ति उससंग छ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","उसले भनेको प्रत्येक कुरा पालन गर। मैले भनेको प्रत्येक कुरा तिमीले मान्नु पर्छ। यदि तिमीहरूले यी सबै कुरा मान्यौ भने, म तिमीहरूका शत्रुहरूको शत्रु हुनेछु। अनि तिमीहरूको विरोधमा हुने प्रत्येकको म विरोध गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“मेरो स्वर्गदूतले तिमीहरूलाई एमोरीहरू हित्ती, परिज्जी, कनानी, हिब्बी र यबूसीहरूको को विरोद्धमा लिएर जानेछ अनि म तिनीहरूलाई पराजित गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“तिनीहरूका देवताहरूलाई पूजा अथवा ढोग नगर, तिमीहरूले उनीहरूको जीवन शैली ग्रहण नगर। तिमीहरूले तिनीहरूका मूर्तिहरू अनि अ-पवित्र खाम्बाहरू चूर पारिदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","तिमीहरूले परमप्रभु आफ्नो परमेश्वरको आराधना गर्नै पर्छ। यदि तिमीहरूले यसो गरे म प्रशस्त रोटी र पानीको निम्ति तिमीहरूलाई आशीर्वाद दिन्छु। तिमीहरूको सम्पूर्ण रोगहरू हटाई दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","तिमीहरू कसैको पत्नीहरू बाँझी अथवा गर्भपात हुने छैन, अनि म तिमीहरूलाई लामो जीवन दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“म तिमीहरूको अघि मेरो महाशक्ति पठाउनेछु अनि सबै राष्ट्रहरू जहाँ तिमीहरू यात्रा गर्नेछौ भयग्रस्त हुनेछन् अनि म तिनीहरूलाई परास्त पार्नलाई मदत गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","म तिमीहरूको अघि ठूलो सकंट पठाउनेछु र यसले हिव्वी, कनानी र हित्ती मानिसहरूलाई तिमीहरूबाट टाढा भगाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","तर ती मानिसहरूलाई म तिम्रो भूमि एकै वर्षमा छोडन बाध्य गराउने छैन नत्र त्यो भूमि खाली हुनेछ अनि त्यहाँ जंगली जनावरहरू बढेर तिमीहरूलाई नोक्सानमा पार्नेछन। ");
INSERT INTO npi2010_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","जबसम्म तिमीहरूको जनसंख्या प्रचूर मात्रमा बढेर यो भूमि भरिदैन म तिनीहरूलाई बिस्तारै निकाल्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“म तिमीहरूलाई लाल समुद्रदेखि फरात नदीसम्म सबै भूमि दिनेछु। त्यो भूमिको पश्चिम सीमाना पलिस्ती नदी भूमध्य सागर र पूर्व सीमाना अरबको मरूभूमिसम्म हुनेछ। म तिमीलाई त्यहाँका मानिसहरूलाई पराजित गर्ने अनुमति दिनेछु अनि तिमीहरूले तिनीहरूलाई त्यहाँबाट बलपूर्वक जान वाध्य गराउनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“तिमीले ती मानिसहरू अथवा तिनीहरूका देवी-देवताहरूसित कुनै करार गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","तिनीहरूलाई तिम्रो भूमिमा बस्नै नदेऊ। यदि तिमीले तिनीहरूलाई त्यहाँ बस्न दियौ भने तिनीहरूले तिमीहरूलाई जालोभारी गरी मेरो विरोधमा पाप गर्न लगाउने छन। अनि तिमीहरू तिनीहरूका देवी-देवताहरू पूज्न लाग्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","परमेश्वरले मोशालाई भन्नु भयो, “तिमी, हारून, नादाब, अबीहू अनि सत्तरी इस्राएलका जना अरू बूढा-प्रधानहरूसित पर्वतमाथि आउनु पर्छ अनि टाढोबाट मेरो आराधना गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","तब मोशा परमप्रभु सामुन्ने आफैं आउनेछन् तर अन्य मानिसहरू परमप्रभु नजिक जाने छैनन् अनि रहल मानिसहरूले पर्वतमाथिसम्म पनि जानु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मोशाले मानिसहरूलाई परमप्रभुले बताका सबै आदेश र निर्देनशहरू बताए। तब मानिसहरू भने, “परमप्रभुले भन्नु भएका सबै आदेश तथा निर्देशहरू हामी पालन गर्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","अनि मोशाले परमप्रभुका सबै आज्ञाहरू लेखे। अर्को बिहान मोशाले पर्वतको फेदीमा एउटा वेदी बनाए अनि इस्राएलीहरूको बाह्र कुल समूहहरूलाई प्रतिनिधित्व गराउनु बाह्रबटा ढुङ्गाहरू राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","तब मोशाले केही इस्राएली युवकहरूलाई बलिहरू चढाउन पठाए। ती मानिसहरूले परमप्रभुलाई होमबलि र मेलबलिको रूपमा गोरूहरू चढाए। ");
INSERT INTO npi2010_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशाले बलिको आधा रगत जोगाएर कचौरामा राखे। र आधा वेदीमाथि छर्किए। ");
INSERT INTO npi2010_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","मोशाले करारको पुस्तक मानिसहरूका निम्ति पढे अनि मानिसहरूले भने, “परमप्रभुले आदेश गर्नु भएको प्रत्येक चीज हामी गर्ने छौं।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","तब मोशाले बलिको गोरूको रगत भएको कचौरा लिए अनि मानिसहरूमाथि छर्के। उनले भने, “परमप्रभुले तिमीहरूसित विशेष करार गर्नु भएकोछ भनी यस रगतले देखाउँछ। परमेश्वरले बनाउनु भएका नियमहरू यस करारको एउटा अंश हो।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","तब मोशा, हारून, नादाब, अबीहू र 70 जना इस्राएलका बूढा-प्रधानहरू पर्वतमा चढे। ");
INSERT INTO npi2010_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","इस्राएलीहरूले इस्राएलका परमेश्वरलाई केही चीजमाथि जो आकाश जस्तो स्वच्छ नीलम देखियो उभिरहनु भएको देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","इस्राएलीहरूको अगुवाहरूले परमेश्वरलाई देखे तर उहाँले तिनीहरूलाई ध्वंश पार्नु भएन। तिनीहरू सबैले संगै खाए अनि पिए। ");
INSERT INTO npi2010_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","परमप्रभुले, मोशालाई भन्नु भयो, “पर्वतमाथि मकहाँ आऊ। मैले मेरा शिक्षाहरू र नियमहरू ढुङ्गाको पाटीहरूमा लेखेको छु। ती पाटीहरू म तिमीलाई दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","यसकारण मोशा र उसका सहायक यहोशू उठे अनि मोशा परमेश्वरको पर्वतमाथि चढे। ");
INSERT INTO npi2010_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मोशाले बूढा-प्रधानहरूलाई भने, “हामीहरू नफर्कुञ्जेल यही पर्ख। जब म जान्छु, तिमीहरूबीच कसैको झगडा भए हारून र हूर कहाँ लानु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","तब मोशा पर्वतमाथि गए, र पर्वत बादलले ढाकेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","परमप्रभुको महिमा सीनै पर्वतमा आयो। बादलले छ दिनसम्म पर्वतलाई ढाक्यो। सातौं दिनमा परमप्रभुले मोशासंग बादलबाट कुरा गर्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","परमप्रभुको महिमा इस्राएलीहरूको दृष्टिमा पर्वतमाथि जलिरहको आगो झैं प्रकट भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","तब मोशा अझै धेरै बादलभित्र गए। पर्वतमाथि मोशा चालीस दिन र चालीस रात बसे। ");
INSERT INTO npi2010_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","परमप्रभुले मोशालाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“इस्राएलीहरूलाई मेरो निम्ति उपहारहरू ल्याउनु भन। प्रत्येक मानिसले हृदयबाट निश्चय गर्नु पर्छ ऊ मलाई के दिनु चाहन्छ। मेरो निम्ति उपहारहरू ग्रहण गर। ");
INSERT INTO npi2010_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ती मानिसहरूबाट तिमीले ग्रहण गर्नु पर्ने उपहारको सूची यस प्रकार छन् सुन, चाँदी अनि काँसा, ");
INSERT INTO npi2010_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","निलो, बैजनी अनि रातो सुतीको धागो, मलमलको कपडा, बाख्राको भुत्ला। ");
INSERT INTO npi2010_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","रातो रंगले रंगाएको भेडाको छाला अनि नरम चर्म, बबुलको काठ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","बत्तिको निम्ति तेल, अभिषेक तेलको निम्ति मसला, अनि सुगन्धित धूपको लागि मसला। ");
INSERT INTO npi2010_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","अनि एपोद को निम्ति बहमूल्य रत्नहरू र न्यायको थैली।” ");
INSERT INTO npi2010_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","परमेश्वरले अझ भन्नु भयो, “मानिसहरूले मेरो निम्ति पवित्र स्थान बनाउन सक्छन अनि म तिनीहरूमाझ बस्न सक्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","त्यो पवित्र पाल र त्यस भित्रका प्रत्येक चीज कस्तो देखिनु पर्छ म तिमीलाई बताउँछु। प्रत्येक चीज मैले तिमीलाई देखाए जस्तै बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“बबुल काठको एउटा सन्दूक बनाऊ। यो पवित्र सन्दूक दुइ हात आधा लामो अनि एक हात आधा चौंडाइ र एक हात आधा उचाइँको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","यो सन्दूकको भित्र अनि बाहिर शुद्ध सुनले मोहोर्नु पर्छ। सन्दूकको बाहिर वरिपरि सुनको घेरा बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","सुनको चारवटा मुन्द्रीहरू बनाऊ अनि सन्दूकको प्रत्येक सुरमा दुइ दुइवटा मुन्द्रीहरू लगाइदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","बबुल काठको डण्डाहरू बनाऊ अनि तिनीहरूलाई सुनले मोहोरी देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","सन्दूकको दुवैतिरको मुन्द्रीहरूमा डण्डा हाल अनि यिनको सहायताले त्यसलाई बोक। ");
INSERT INTO npi2010_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ती मुन्द्रीहरूबाट डण्डा बाहिर ननिकाल ती डण्डाहरूलाई मुन्द्रीमा नै रहन देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“मैले दिंदै गरेको करार त्यस सन्दूकभित्र राख। ");
INSERT INTO npi2010_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","त्यसपछि दुइ हात आधा लामो अनि एक हात आधा चौढाईको शुद्ध सुनको एउटा ढकनी बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","“अनि मार्तेलले पिटेर सुनलाई दुइवटा करूब दूतहरू बनाऊ। अनि दुवैलाई ढकनीकोमाथि छेउ छेउमा लगाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","एउटा करूब एक छेउमा अनि अर्कोलाई अर्को छेउमा राख। अनि ढकनी र दूतहरू यस्तो यस प्रकारले जोडनु पर्छ तिनीहरू एउटै टुक्राले बनिएको जस्तो होस्। ");
INSERT INTO npi2010_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","करूब दूतहरू एक अर्कापट्टि फर्किएको हुनुपर्छ अनि तिनीहरूका पखेटाहरू ढकनीमाथि फैलिएको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“म तिमीलाई करार पत्र दिन्छु र त्यो तिमीले सन्दूक भित्र ढकनी लगाएर राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","जब म तिमीलाई भेटछु, करारको सन्दूकमाथि राखिएको करूब स्वर्गदूत बीचबाट तिमीसित कुरा गर्नेछु। त्यही स्थानबाट इस्राएली मानिसहरूलाई म आफ्नो आज्ञाहरू दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“दुइ हात आधा लमाई, एक हात आधा चौढाइ, र एक हात आधा उचाइ भएको एउटा बबुल काठको टेबल बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","टेबललाई शुद्ध सुनले मोहोर अनि चारैतिर सुनको बिट लगाएर सुसज्जित गर। ");
INSERT INTO npi2010_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","तब चार औलो फराकिलो घेरा बनाऊ र त्यसको वरिपरि सुनको घेरा लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","त्यसपछि चारवटा सुनको कुण्डलहरू बनाएर टेबलको खुट्टा भएका चार कुनामा राख। ");
INSERT INTO npi2010_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","टेबलको चारै तिर घेरामा मुन्द्रीहरू लगाऊ। मुन्द्रीमा डण्डाहरू लगाऊ अनि यसलाई टेबल बोक्न प्रयोग गर। ");
INSERT INTO npi2010_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","डण्डाहरू बनाउन बबुलको काठ प्रयोग गर अनि त्यसलाई सुनले मोहोर। ती डण्डाहरू टेबल बोक्नमा प्रयोग गर। ");
INSERT INTO npi2010_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","शुद्ध सुनको थाल, धुपौरो, गाग्रो तथा भाँडाहरू बनाऊ। गाग्रो र भाँडाहरू पेय बलिहरू चढाउँदा खन्याउन प्रयोग गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","टेबलमाथि मलाई विशेष रोटी चढाऊ त्यो रोटी संधै त्यहाँ मेरोअघि हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“त्यसपछि तिमीले एउटा सामदान बनाउनु पर्छ। सामदानको डण्डा र आधार अकबरी सुनकै बनाउनु पर्छ। शुद्ध सुनको फूल, फूलका कोपिलाहरू, र पत्रहरू बनाऊ र यी सबैलाई एकै ठाउँमा जोड। ");
INSERT INTO npi2010_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“त्यस सामदानका छःवटा हाँगाहरू हुनुपर्छ एक पट्टि तीनवटा अर्कोपट्टि तीनवटा। ");
INSERT INTO npi2010_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","प्रत्येक हाँगामा तीनवटा फूलहरू हुनु पर्छ। यी फूलहरू, पत्र तथा कोपिलाहरू बदामको फूल जस्तै बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","सामदानमाथि अझ चारवटा फूलका पत्तीहरू बनाऊ। यी फूलहरूका कोपिला र पत्रहरू पनि बदामका फूल जस्तै हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","सामदानमाथि हाँगाहरूको तीन एकको जोडीमा, यी बीचमा यी फूलहरू एक-एकवटा लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","कोपिलाका, पत्रहरू अनि सम्पूर्ण सामदान शुद्ध सुनले बनिएको हुनुपर्छ। यिनीहरू सबै एउटा सुनको टुक्राबाट मार्तोलले पिटेर बनाएको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","तब सामदानमाथि राख्ने सातबटा दियाहरू बनाऊ अनि यिनले अघिल्लो भागको क्षेत्रमा ज्योति दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","चिम्टा र तावाहरू शुद्ध सुनको बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","एक तोडा शुद्ध सुन चलाएर सामदान अनि यसमा चलाउनको निम्ति अरू सहयोगी चीजहरू बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","चीजहरू मैले तिमीलाई पर्वतमाथि देखाएको नमूना जस्तै हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“दशवटा पर्दाले पवित्र पाल बनाउनु पर्छ। यी पर्दाहरू सुती-कपडा, निलो, बैजनी अनि रातो रेशमको लुगाले बनिएको हुनुपर्छ अनि करूब स्वर्गदूतहरूको आकृति पर्दाहरूमा बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","हरेक पर्दा अठाईस हात लामो हुन पर्छ। चार हात चौडाइको हुनुपर्छ अनि सबै पर्दाको नाप बराबरी हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","पाँचवटा पर्दाहरूको एउटा समूह अनि अर्को पाँचवटा पर्दाहरूको अर्को एउटा समूह बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","पहिला समूह पर्दाको किनारमा निलो लुगाको एउटा सुर्काउनी बनाऊ। दोस्रो समूह पर्दाको किनारमा पनि तिमीले त्यसै गर। ");
INSERT INTO npi2010_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","हरेक पर्दाको हरेक किनारमा पचासवटा सुर्काउनीहरू बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","त्यसपछि ती पर्दाहरूसंगै जोडनका लागि पाँचासवटा सुनको मुन्द्रीहरू बनाऊ। दुइवटा समूहको पर्दालाईसंगै जोडेर एउटा पवित्र पाल बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“तब अर्को पाल पवित्र मण्डप ढाक्नका निम्ति बनाऊ। त्यो पाल बाख्राका भुत्लाले बुनेर बनाऊ। पाल एघारवटा पर्दाहरू गाँसेर बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","यी प्रत्येक पर्दाहरू टुक्राका नाप तीस हात लमाइ र चार हात चौडाइ गरी सबै बराबर हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","पहिले पाँचवटा टुक्रा जोडेर एक भाग अनि अरू छःवटा टुक्राहरू जोडेर अर्को भाग तयार पार। छःवटा पर्दालाई पालभित्र प्रवेश द्वारमाथि पट्टाएर राख। ");
INSERT INTO npi2010_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","एक भागको आखिरी किनारमा पचासवटा सुर्काउनी बनाऊ र अर्को भागमा पनि त्यसरी नै पचासवटा सुर्काउनी बनाऊ। यी सुर्काउनीहरूले भाग भाग पर्दाहरूलाई एउटै पाल बनाउँछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","काँसाका पचासवटा मुन्द्रीहरू बनाऊ अनि दुइ समूह पर्दाहरू एउटा एकलो पाललाई जोडनको निम्ति प्रयोग गर। ");
INSERT INTO npi2010_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","यो पाल पहिले बनाइएको पवित्र पाल भन्दा बढी लामो हुन्छ। यसरी यस पालको पर्दाको आधा भागको किनारा पवित्र पालको पछाडी झुण्डिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","यो पालको पर्दा पवित्र पालको वरिपरि अन्तिम किनारमा पनि एक हात झुण्डिएर रहनेछ। यसकारण यस पालले पवित्र पाललाई पूर्ण रूपले ढाक्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","बाहिरबाट ढाक्नलाई अरू दुइवटा पर्दा बनाऊ। दुइवटा पर्दामा एउटा चाँहि भेडाको छालालाई रातो रंग लगाएर बनाऊ र अर्को चाँहि नरम छालाको बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“पवित्र पाल स्थापना गर्नको निम्ति लामो बबुलको काठको फल्याकहरू प्रयोग गर। ");
INSERT INTO npi2010_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","अवश्यै फल्याकहरू दश हात लामा अनि एक हात आधा चौडा हुनै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","एका अर्कोलाई समान्तर गर्नको निम्ति प्रत्येक र जोडी फल्याकहरूलाई एकै साथ जोडनको निम्ति चुकुलहरू प्रयोग गर। ");
INSERT INTO npi2010_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पवित्र पालको दक्षिण पट्टि जोडन बीसवटा फल्याकहरू बनाऊ, ");
INSERT INTO npi2010_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","अनि यी फल्याकलाई सीधा गर्नको निम्ति चालीसवटा चाँदीका आधारहरू बनाऊ। प्रत्येक फल्याकको एउटा आधारमा लगाऊ, दुइवटा आधारहरू एउटा फल्याकमा लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","पवित्र पालको उत्तरी भागमा अझ बीसवटा फल्याकहरू बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","अनि यस फल्याकहरूलाई सिधा बनाउन चालीसवटा चादीको आधारहरू प्रत्येक फल्याकको निम्ति दुइ दुइवटा बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","अझ छवटा फल्याकहरू बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","पवित्र पालको पछिल्लो भागको कुनामा दुइवटा फल्याकहरू बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","कुनाको फल्याकहरू फेदसम्म फैलिएको हुनुपर्छ। टुप्पाको मुन्द्रीहरूमा फल्याकहरूसंगै जोडिएको हुनुपर्छ अनि त्यस्तै प्रकारले फेदको कुनाहरूको निम्ति गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","त्यहाँ पश्चिमी किनारका निम्ति आठवटा फल्याकहरू हुनुपर्छ अनि प्रत्येकलाई दुइवटा गरी जम्मा सोह्रवटा चाँदीका आधारहरूको आवश्यकता पर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“पवित्र पालमाथि पट्टिको पाँचवटा फल्याकको किनार बनाउनमा बबुल काठ प्रयोग गर। ");
INSERT INTO npi2010_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","पवित्र पालको अर्को किनारको फल्याकमाथि पाँचवटा डण्डाहरू बनाउनु पर्छ। अनि पवित्र पालको पश्चिमी किनार फल्याकमाथि पाँचवटा डण्डाहरू बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","माझको डण्डा हरेक फल्याकको मध्य भागबाट एक छेऊ देखि अर्को छेऊसम्म पुगेको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“फल्याकहरू र डण्डाहरू सुनले मोहोरी देऊ अनि सुनको मुन्द्रीहरू बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","मैले तिमीलाई पर्वतमा देखाए बमोजिम नै पवित्र पाल बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“निलो, बैजनी र राता धागाले बटारेको सुती कपडाका पर्दाहरू बनाऊ। यसलाई करूब र्स्वगदूतका नक्साहरूले सुसज्जित पार। ");
INSERT INTO npi2010_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","बबुल काठको चारवटा खम्बाहरू बनाऊ अनि ती खम्बाहरूलाई सुनले मोहोर। प्रत्येक खम्बाको निम्ति सुनको अंकुशेहरू बनाऊ अनि सीधा पार्नका निम्ति चाँदीको आधारहरू बनाऊ। त्यसपछि ती सुनका अंकुसेमा पर्दा झुण्डाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","करारको सन्दूकलाई पर्दाको पछाडी राख। यस पर्दाले पवित्र स्थानलाई महापवित्र स्थानबाट छुट्टाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","महापवित्र स्थानभित्र करारको सन्दूकमाथि ढकनी लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“पर्दाको बाहिर पट्टि तिमीले बनाएको विशेष टेबल राख। यो टेबल पवित्र पालको उत्तरपट्टि हुनुपर्छ। पवित्र पालको दक्षिणपट्टि सामदान यो टेबिलको सोझोमा हुनेगरि राखी देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“निलो, बैजनी र रातो सुतीको धागो बाटेर एउटा पर्दा बनाएर पवित्र पालको प्रवेशद्वार पर्दा बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","यस पर्दामा सुनले बनिएको अंकुसेहरू लगाऊ। अनि बबुलको काठको पाँचवटा खम्बाहरू सुनले बेरेर बनाऊ। यी पाँचवटा खम्बाको निम्ति काँसाका आधारहरू बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“बबुल काठको एउटा वेदी बनाऊ। त्यो वेदी पाँच हात लामो तथा पाँच हात चौडा र तीन हात उचाइ वर्ग आकारमा बनिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","त्यस वेदीको चारैवटा कुनामा एक एकवटा सींग बनाऊ र प्रत्येक सींगगलाई यस्तो प्रकारले जोड कि सबै एउटै टुक्राले बनिएको देखियोस्। तब वेदीलाई काँसाले मोहोरी देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“वेदी सफा गर्न चाहिने सामग्रीहरू करूवा, मासु उठाउने काँटाहरू, तावाहरू कोप्रे भाँडाहरू यी सबै काँसाको बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","वेदीको निम्ति एउटा काँसाको जाली जस्तै कोरेसो बनाऊ। त्यस कोरेसोको चारै कुनामा काँसाको चारवटा कुण्डलहरू लगाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","त्यो कोरेसो चाँहि वेदीको तहको मुनि टँसिएको हुनुपर्छ। अनि वेदीको तल आधा भागसम्म फैलिएको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“वेदीको निम्ति डण्डाहरू बबुल काठको बनाऊ र त्यसलाई काँसाले मोहोर। ");
INSERT INTO npi2010_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","वेदीमा भएका कुण्डलहरूमा दुइतिरबाट यी डण्डाहरू पसाउँनु र वेदी बोक्नु पर्दामा यी डण्डाहरू प्रयोग गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","वेदी बनाउँदा एउटा खाली सन्दूक जस्तो फल्याकबाट बनाउनु पर्छ। त्यो मैले तिमीलाई पर्वतमा देखाए जस्तै हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“पवित्र पालको आँगन हुनपर्छ। एक सय हात लामो एउटा पर्दा लगाएर आँगन बनाऊ यो दक्षिण भागमा हुनुपर्छ। त्यो पर्दा राम्रोसंग बुनेको सुतीको लुगाले बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","र बीसवटा खम्बाहरू बनाऊ अनि ती बीसवटा खम्बाहरूको लागि बीसवटा काँसले बनिएका आधारहरू प्रयोग गर। डण्डाहरूको निम्ति अंकुसे र बन्धनहरू चाँदीको बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","उत्तर तिर पनि एक सय हात लामो पर्दा अनि त्यो पर्दाको निम्ति पनि बीसवटा खम्बाहरूसंग बीसवटा काँसाको आधारहरू हुनुपर्छ। तिनीहरूको निम्ति अंकुशे र बन्धन चाँदीको बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“पवित्र पालको पश्चिम तिरको आँगनमा पचास हात लामो पर्दा होस। त्यस पर्दाको निम्ति दशवटा डण्डाहरू र दशैवटा आधारहरू लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","पवित्र पालको पूर्वपट्टि आँगनमा पनि पचास हात लामो पर्दा लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","एकापट्टि पन्ध्र हात लामो पर्दा हुनुपर्छ अनि त्यसमा तीनवटा खम्बा र तीनैवटा आधारहरू हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","यसको अर्कोपट्टि पनि पन्ध्र हात लामो पर्दा, तीनवटा डण्डा र तीनैवटा आधारहरू हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“आँगनको प्रवेशद्वार ढाक्नको निम्ति बीस हात लामो निलो, बैजनी र रातो धागोले मसिनो बुनेको सुती कपडाको पर्दा लगाऊ। पर्दामा बेलबुट्टा काढेर नक्सा बनाउनु पर्छ। त्यस पर्दाको निम्ति चारवटा डण्डाहरू र चारवटा आधारहरू लगाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","आँगनका चारैतिरका पर्दाहरूको अंकुसे र त्यसलाई अड्याउने सबै खम्बाका आधार पीतलले मोहरेको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","आँगन एक सय हात लामो अनि पचास हात चौडा हुनुपर्छ। आँगन वरिपरिको पर्दाको उचाइ चाँहि पाँच हात हुनुपर्छ। पर्दा मसिनो सुती कपडाको हुनुपर्छ। डण्डा तथा खम्बाको निम्ति लगाइने आधार काँसाको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पवित्र पालमा प्रयोग गरिने सबै आँगन वरिपरिका वस्तुहरू अनि पालका चुकुलहरू अनि आँगन काँसाको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“भद्राक्षको शुद्ध तेल ल्याई निरन्तर दियाहरू बाल्न इस्राएलीहरूलाई आदेश देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","हारून र उसका छोराहरूले दियोहरूको ध्यान राख्नेछन्। तिनीहरू भेट हुने पालको प्रथम कक्षामा जानेछन् अनि यो कक्षा पर्दाको पछाडी बाहिर जसले दुइटा कोठाहरूलाई छुट्याउँछ। तिनीहरूले परमप्रभुको सम्मुख दियोहरू निरन्तर बाली राख्नकालागि प्रत्येक साँझ विहान हेरचाह गर्नेछन्। इस्राएली मानिसहरू तथा तिनीहरूका सन्तानहरूले यो नियमका सदा-सर्वदा पालन गर्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","परमप्रभुले मोशालाई भन्नु भयो, “तिम्रो दाज्यू हारून, उसका छोराहरू नादाब, अबीहू, एलाजार अनि ईतामारलाई इस्राएली मानिसहरूलाई छोडेर तिमी कहाँ आउनु भन। यी मानिसहरू पूजाहारी भएर मेरो सेवा गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“तिम्रो दाज्यू हारूनको निम्ति विशेष पोशाक बनाऊ। यी पोशाकहरूले उसलाई सम्मान र आदर दिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","इस्राएली मानिसहरूमा यस प्रकारको पोशाक बनाउन निपुर्ण मानिसहरू छन्। मैले ती मानिसहरूलाई विशेष ज्ञान दिएकोछु। हारूनको निम्ति ती मानिसहरूलाई पोशाक बनाउनु भन। ती पोशाकहरूले उसलाई पूजाहारी जस्तै सजाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ती मानिसहरूले पोशाक छालाको थैलो एपोद एउटा डोरी, झालर लगाएको डोरी, एउटा फेटा अनि एउटा पेटी बनाउनु पर्छ। ती मानिसहरूले यो पवित्र पोशाकहरू हारून र उसका छोराहरूका निम्ति बनाउनु पर्छ। तब हारून अनि उसका छोराहरू अधिकृत पूजाहारी हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ती मानिसहरूलाई भन यी पोशाकहरू बनाउँदा सुनको धागो, मिहीन वस्त्र र निलो, बैजनी अनि रातो धागो प्रयोग गरून्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“एपोद बनाउँदा ती मानिसहरूले मिहीन वस्त्र, निलो, बैजनी अनि रातो धागो र सुनको धागो प्रयोग गरून्। यो कार्य अत्यन्तै शिपालु मानिसहरूले गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","यी दुवै टुक्राले काँधे बन्धन हुनुपर्छ, एउटाले अर्कोको छेउ जोडिएको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“यी मानिसहरूले एपोदको निम्ति पेटी पनि अत्यन्तै सावधानीसित बनाउनु पर्छ। पेटी पनि तिनीहरूले एपोद बनाउँदा जस्तै सुनको धागो, मसिनो गरी बाटेको सुती कपडा, निलो, बैजनी अनि रातो धागोहरूले बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“गोमेद पत्थरहरू लेऊ र याकूबका बाह्रजना छोराहरूको नाउँ लेख प्रत्येक पत्थरमा छ जनाको नाउँ लेख। ");
INSERT INTO npi2010_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","तिनीहरूको नाउँहरू जन्म क्रम अनुसार सूचित गर। ");
INSERT INTO npi2010_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","इस्राएलीका नाउँहरू रत्नहरूमा खोप। यी कामहरू यस्तै प्रकारले गर्नु पर्छ जसरी शिल्पकारहरूले मोहोरमा नाउँ अनि नक्शा खोप्ने गर्छन्। यसकारण खोपिएका रत्नहरू सुनको पातामा ठोकिएको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","तब यी खोपिएको रत्नहरू एपोदको काँधहरूमाथि लगाई देऊ। जब हारून परमप्रभुको सामुने उभिन्छ, उसले एपोद जहाँ याकूबका छोराहरूले नाउँ खोपेर जोडेको रत्नहरू छन् काँधहरूमाथि लगाउँछ। यी रत्नहरूले परमप्रभुलाई इस्राएलीहरूको विषयमा सम्झना गराउँछ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","सुनका दुइवटा आकारहरू बनाऊ अनि ");
INSERT INTO npi2010_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","शुद्ध सुनका धागोहरू बाटेर दुइवटा साङ्गली बनाऊ र दूई समूहलाई जोडी देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“प्रधान पूजाहारीका निम्ति एपोद बनाउने निपुण शिल्पकारहरूले न्यायको थैली बनाउनु पर्छ। यस्तो थैली बनाउँदा पनि ती शिल्पकारहरूले सुनको धागो, मसिनो गरी बाटेको सुती कपडा अनि निलो, बैजनी र राता धागाहरू प्रयोग गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","न्यायको थैली दोबारेको चारपाटे हुनुपर्छ। त्यो थैली एक बित्ता लामो र एक बित्ता चौडाइको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","न्यायको थैलीमा यी रत्नहरू चार लहरमा जोड। पहिलो लहरमा साडियस, पुष्पराज, र पन्ना, ");
INSERT INTO npi2010_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","दोस्रो लहरमा फिरोजा, नीलम र लालहीराको, ");
INSERT INTO npi2010_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","तेस्रो लहरमा नीलमणि, हाकिक र कटेला र ");
INSERT INTO npi2010_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","चौथो लहरमा पीतमणि, आनिक्स अनि स्फारिक हुनु पर्छ। रत्नहरू सुनको घेरामा राख्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","प्रत्येक रत्नमा इस्राएलको बाह्र वंशहरूमध्ये एक-एकको नाउँ खोपिएको हुनुपर्छ। खोप्ने काम निपुणतासंग गरिएको हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“न्याय थैलीको निम्ति शुद्ध सुनको साङ्गली बनाऊ। यी साङ्गलीहरू डोरी जस्तै बटारिएको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","सुनका दुइवटा मुन्द्रीहरू बनाऊ र तिनीहरूलाई दुइवटा न्याय थैलीको छेऊमा जोडी देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","दुइवटा सुनको डोरीहरू दुइवटा मुन्द्रीहरू न्यायको थैलीमाथि छेउमा जोडी देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","दुवै साङ्गलाहरू मिलाएर एपोदको कुममाथि चौखटमा साङ्गलाको अर्को अन्त बाँध। यसले न्यायको थैलीलाई एपोदको अघि थाम्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","अझै दुइवटा सुनको मुन्द्रीहरू बनाऊ अनि तिनलाई न्यायको थैलीको अर्को दुइ कुनामा राखिदेऊ। यो एपोदको छेऊमा न्यायको थैलीको भित्री भागमा हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","अझै दुइवटा सुनको कुण्डलहरू बनाएर एपोदको अघाडीपट्टिको भागमा काँधको मुनि राख। एपोदको पेटीमाथि सुनका मुन्द्रीहरू लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","न्यायको थैली कुण्डल र एपोदको कुण्डल बाँध्न निलो डोरीको प्रयोग गर। यसरी न्यायको थैली पेटी नजिक रहन्छ र एपोदसित बाँध। ");
INSERT INTO npi2010_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“हारून जब पवित्र स्थानमा जान्छन् उनले आफ्नो छातीमा त्यो न्यायको थैली लगाएको हुनुपर्छ। यसरी इस्राएलाका बाह्र जना छोराहरूको नाउँ हारूनको छातीमाथि परमप्रभुको सम्झनामा सदा-सर्वदा रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ऊरीम र तुम्मीम सँधै त्यो न्यायको थैलीमा राखिएको हुनुपर्छ। हारून जब परमप्रभुको सामुन्ने जान्छन उनको छातीमाथि ती राख्नुपर्छ। यसकारण हारून जब परमप्रभु अघाडी हुन्छन् इस्राएली मानिसहरूलाई न्याय गराइने साधनहरू सबै आफूसित राखिएको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एपोदको निम्ति निलो रंगको लबेदा तिमीले बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","शिरको लागि बीचमा प्वाल बनाऊ अनि प्वालको किनारमा कोटको कलर च्यातिनुबाट बचाउनुलाई बुने झैं सिलाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","पोशाकको फेरो वरिवरि निलो, बैजनी अनि रातो धागोले दारीमहरू बनाऊ र तिनलाई झुण्डाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","सुनको घण्टीहरू दारीमहरू बीच-बीचमा पोशाकको वरिपरि झुण्डाऊ। यसरी पोशाकको किनारमा दारीमहरू अनि एक पछि अर्को गर्दै घण्टीहरू झुण्डाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारून जब पूजाहारी भई सेवा गर्छन् तिनले यो लवेदा लगाएर गर्छन्। हारून जब पवित्र स्थानभित्र जान्छन् र त्यहाँबाट निस्कन्छन घणटीहरू बज्नेछन् अनि यसरी हारून मर्ने छैनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“मानिसहरूले मोहर बनाए झैं शुद्ध सुनको पाता बनाऊ अनि त्यसमा यी शब्दहरू खोप परमप्रभुको निम्ति पवित्र। ");
INSERT INTO npi2010_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","यो फेटामो निलो धागो बाँधिदेऊ। यो सुनको पाता फेटामा अघिल्तिर हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","हारूनले आफ्नो शिरमाथि त्यो लगाउनेछन् अनि यसरी इस्राएली मानिसहरूले परमप्रभुलाई चढाएको पवित्र उपहारको जिम्मावार हुनेछन्। यसकारण हारूनले त्यो सुनको पाता सधैं आफ्नो शिरमा राख्नेछन् जसले गर्दा मानिसहरूले चढाएका सबै उपहारहरू ग्रहण परमप्रभुले गर्नु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“सेतो लबेदा बनाउनलाई मसिनो सुती कपडा प्रयोग गर। फेटा बनाउन मिहीन लुगा प्रयोग गर। पेटीमा बुट्टाहरू सिलाएर बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","हारूनका छोराहरूको निम्ति पनि लबेदा पटुका र फेटाहरू बनाऊ। यी वस्त्रहरूले तिनीहरूलाई सम्मान अनि गौरव प्रदान गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","हारून र तिनका छोराहरूले ती पोशाकहरू लगाएपछि तिनीहरूलाई तेलले अभिषेक गरिदेऊ। यसरी तिनीहरू नियुक्त हुनेछन् अनि पवित्र भएर मेरो निम्ति पूजाहारीहरू झैं सेवा गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“पोशाकहरूको लागि सुती लुगा प्रयोग गर। त्यो पोशाक तिनीहरूले कमरदेखि तिग्रासम्म लगाउँनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","हारून र तिनका छोराहरू जति बेला भेट हुने पालभित्र पस्छन् तिनीहरूले त्यो लुगा लाउनु पर्छ। पूजाहारी भई काम गर्न जुन बेलामा पनि तिनीहरू पवित्र स्थानको वेदी नजिक जान्छन् तिनीहरूले त्यो पोशाक लगाएको हुनुपर्छ। यदि तिनीहरूले ती वस्त्रहरू धारण नगरी त्यसरी भित्र पसे दोषी भई मर्ने छन्। यी सब हारून अनि तिनका भावी सन्तानको निम्ति सदा-सर्वदाका लागि पालन गरिनु पर्ने नियम हुनेछन।” ");
INSERT INTO npi2010_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","त्यसपछि परमप्रभुले मोशालाई भन्नु भयो, “हारून र तिनका छोराहरूले आफू पूजाहारी भई विशेष रूपमा मेरो सेवा कसरी गर्नु पर्छ भनी तिमीले देखाउनको निम्ति के गर्नु पर्छ म तिमीलाई अब भन्नेछु। तिमीले निष्खोट एउटा बाछा र दुइवटा भेडाको पाठाहरू जोगाड गर। ");
INSERT INTO npi2010_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","त्यसपछि खमीर बिनाको गहुँको मिहीन पिठो जोगाड गरी रोटी बनाउनु त्यसमा भद्राक्षको तेल मिसाऊ। अनि त्यस पिठोको पात्लो रोटी बनाएर त्यसमाथि तेल छर्क। ");
INSERT INTO npi2010_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","रोटीहरू डालोमा हाल र यो हारून अनि उसको छोराहरूकहाँ साँढे अनि पाठाहरूसंगै ल्याऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“त्यसपछि हारून र तिनका छोराहरूलाई भेटहुने पालको प्रवेश द्वार अघि ल्याएर नुहाउन लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","हारूनलाई सेतो पोशाक एपोद अनि निलो पोशाक लगाइदेऊ। उसलाई न्यायको थैली अनि एपोद लगाउन लगाऊ। त्यसपछि त्यो सुन्दर पेटी तिनलाई लगाइदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","उसको टाउकोमा फेटा लगाइदेऊ अनि पवित्र मुकुट फेटामाथि राखि देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","हारूनको शिरमा अभिषेक गर्ने तेल छर्किदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“त्यसपछि हारूनका छोराहरूलाई त्यस स्थानमा ल्याऊ। बुनेको सेतो लबेदा तिनीहरूलाई लगाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","त्यसपछि तिनीहरूको कम्मरमा पटुका बाँधिदेऊ। तिनीहरूलाई फेटा कसि देऊ। तब तिनीहरू पूजाहारी बनिन्छन् र आराधना गर्न शुरू गर्छन् अनि त्यही नियम अनुसार जुन नियम सदा-सर्वदाको निम्ति चलिरहन्छ। तिनीहरू पूजाहारी रहन्छन्। यही तरीकाले हारून अनि तिनका छोराहरूलाई तिमीले पूजाहारी बनाउने छौ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“त्यसपछि भेट हुने पालको प्रवेशद्वारमा बाछोलाई ल्याऊ अनि हारून र उसका छोराहरूले बाछोको शिरमाथि तिनीहरूको हात राखून। ");
INSERT INTO npi2010_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","तब बाछोलाई परमप्रभुको सामुन्ने भेट हुने पालको प्रवेशद्वारमा मार। ");
INSERT INTO npi2010_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","बाछाको केही रगत तिम्रो औलामा लैजाऊ अनि यसलाई वेदीको सींङहरूमाथि राख। बाँकी रहेको जम्मै रगत वेदीको फेदमा खन्याइदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","बाछाको आन्द्रा भँडी छोपिएको बोसो कलेजोको भाग बोसो, दुइवटा मिर्गौलाहरू अनि त्यो मिर्गौलाहरूमाथि भएका बोसो सबै उठाऊ अनि वेदीमा जलाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","बाछोको मासु, छाला अनि भुडी ल्याऊ अनि त्यसलाई छाउनी बाहिर जलाई देऊ। यो पाप बलि हो। ");
INSERT INTO npi2010_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“त्यसपछि हारून अनि उसको छोराहरूलाई भेडाहरूमध्ये एउटाको शिरमाथि हातहरू राख्नु भन। ");
INSERT INTO npi2010_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","त्यसपछि त्यो भेडा मारेर त्यसको रगत जम्मा गर। रगतलाई वेदीको वरिपरि छर्किदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","तब भेडालाई टुक्रा-टुक्रा बनाएर सम्पूर्ण रूपले धोऊ अनि खुट्टाहरू पनि धोऊ र यी सबै भेडाको चीजहरू यसको शिरसितै राख। ");
INSERT INTO npi2010_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","तब सम्पूर्ण भेडालाई वेदीमा जलाई देऊ। यसको सुगन्धले परमप्रभुलाई प्रसन्न तुल्याउँछ। अनि त्यस्तो होम बलि जुन हो आगोद्वारा चढाईन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“हारून र तिनका छोराहरूलाई अर्को पाठोको शिरमाथि हात राख्नु भन। ");
INSERT INTO npi2010_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","त्यस भेडालाई मार र त्यसको केही रगत ल्याऊ। हारून र तिनका छोराहरूको दाहिने कानको लोतीमा त्यो रगत लगाइदेऊ। अनि केही रगत तिनीहरूको दाहिने हातको बूढी औंलाहरूमा लगाइदेऊ। र दाहिने खुट्टाको बूढी औंलामाथि केही रगत राख। त्यसपछि रगतलाई वेदीको वरिपरि छर्क। ");
INSERT INTO npi2010_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","त्यसपछि वेदीबाट केही रगत झिकेर अभिषेक गर्ने तेलसित मिलाऊ र हारून र तिनका छोराहरूमाथि छर्किदेऊ। तिनीहरूका पोशाकहरूमाथि पनि छर्किदेऊ। यसले हारून र तिनका छोराहरूले मेरो विशेष रूपले सेवा गर्नेछन् भन्ने बुझाउँछ। अनि यसले तिनीहरूको लुगाहरू पनि विशेष समयमा मात्र प्रयोग गरिन्छ भनी दर्शाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“त्यसपछि भेडाबाट बोसो झिक। पुच्छरको बोसो निकाल आन्द्रा भुँडी छोप्ने बोसो अनि भित्री कलेजो अनि दुवै मिर्गौला अनि तिनीहरूमाथिको बोसो र दाहिने खुट्टा निकाल। ");
INSERT INTO npi2010_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","त्यसपछि एउटा टुक्रा रोटी, एउटा केकको रोटी, तेलमा पकाएको फूलौरो र डालोबाट अखमिरो नभएको पातलो रोटी निकाल जुन चाँहि परमप्रभुको अघि छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ती चीजहरू हारून अनि उनको छोराहरूलाई देऊ। तिनीहरूले यी चीजहरू तिनीहरूको हत्केलामा राखून अनि तिनीहरूलाई परमप्रभुको सामुन्ने उठाउन। ");
INSERT INTO npi2010_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","त्यसपछि हारून र तिनका छोराहरूबाट यी सब चीजहरू लेऊ र वेदीमा पाठोसितै राख। अनि वेदीमा प्रत्येक चीज जलावोस्। यो आगोद्वारा चढाइएको होमबलि हो। यसको सुगन्धले परमप्रभुलाई सन्तुष्ट तुल्याउँछ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“त्यसपछि त्यो पाठोबाट ह्याकुला झिक। (यो त्यही पाठो हो जुन हारूनलाई प्रधान पूजाहारी बनाउँने उत्सवमा उपयोग गरिनेछ।) पाठोको ह्याकुलो परमप्रभु सम्मुख विशेष भेटी स्वरूप समाती राख। पशुको त्यो भाग तिम्रो हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","तब पाठोको त्यो ह्याकुला र खुट्टा समात जुन हारूनलाई प्रधान पूजाहारी बनाउँदा उपयोग गरिएको थियो। त्यस भागहरूलाई पवित्र बनाऊ र तिनीहरू हारून अनि उसको छोराहरूलाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","इस्राएली मानिसहरूले यी अंशहरू हारून र तिनका छोराहरूलाई सधैं दिनेछन्। जहिले पनि इस्राएलीहरूले परमप्रभुलाई चढाएको मेलबलिहरू चढाउँछन् ती बलिका भागहरू पूजाहारीहरूलाई दिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारूनको निम्ति बनाएको विशेष पोशाकहरू उसका सन्तानहरूलाई दिइन्छ जब तिनीहरूलाई पूजाहारी अभिषेक गरिन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","हारून पछि तिनको छोरो प्रधान पूजाहारी हुनेछ। हारूनको त्यस छोराले ती पोशाकहरू सात दिनसम्म लगाउनेछ जब त्यो पवित्र स्थानमा सेवाको निम्ति भेट हुने पालमा आउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“हारूनलाई प्रधान पूजाहारी बनाउँदा उपयोग गरिएको भेडाको मासु पकाऊ। त्यो मासु पवित्र स्थानमा पकाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","त्यसपछि हारून र तिनका छोराहरू भेट हुने पालको ढोका अघि बसेर त्यो मासु र डालोमा भएको रोटी पनि खाने छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","यी चीज तिनीहरू पूजाहारी हुँदा तिनीहरूको प्रायश्चितका निम्ति चढाइएका हुन् अब तिनीहरूले ती उपहारहरू खानु पर्छ। अन्य मानिसहरूले यी उपहारहरू खानु हुँदैन किनभने यी चीजहरू पवित्र हुन्। ");
INSERT INTO npi2010_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","यदि हारूनलाई पूजाहारीको रूपमा अभिषेक गर्दा बलि चढाएका रोटी अथवा मासु बिहानसम्म रहे त्यो जलाउनु पर्छ। अर्को दिन तिमीहरूले त्यो रोटी अथवा मासु खानु हुदैन किनभने तिनीहरू पवित्र छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“तिमीहरूले यी सबै चीजहरू हारून र उसका छोराहरूको निम्ति मैले तिमीहरूलाई आदेश गरे जस्तै गर्नु पर्छ। तिनीहरूका पूजाहारी नियुक्ती को उत्सव लगातार सात दिनसम्म चल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","यी सात दिनसम्म प्रत्येक दिन तिमीहरूले एउटा बाछा बलि चढाउनु पर्छ। यो हारून र उसको छोराहरूको प्रायश्चितका निम्ति हुनेछ। तिमीहरूले एउटा बाछा पनि वेदीको शुद्धताको निम्ति चढाउनु पर्छ। तिमीहरूले शुद्ध भद्राक्षको तेल वेदीमाथि खन्याएर यसलाई पवित्र बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","सात दिनसम्म तिमीहरूले वेदीको लागि प्रायश्चित गर्नेछौ अनि पवित्र पार्नेछौ। त्यस समय वेदी अत्यन्तै पवित्र हुनेछ। कुनै चीजहरूले वेदीलाई छुनेहो भने त्यो पनि पवित्र हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“प्रत्येक दिन तिमीले वेदीमा उपहार चढाउनु नै पर्छ। तिमीले दुइवटा एक वर्षे थुमाबलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","तिमीहरूले पहिलो थुमा बिहान अनि दोस्रो थुमा घाम अस्ताउँदा बलि दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","जब तिमीले पहिलो थुमा बलि दिनेछौ त्यस समय एक दशांश एपाको राम्रो गहूँको पिठोसित भद्राक्षको एक पावा टीन कुटेको तेल अनि एक पावा टीन दाखरसको अर्घबलि बलिमिसाऊ चढाऊ। जब तिमीहरूले साँझमा दोस्रो बलि चढाउँछौ पहिलो थुमालाई बिहान गरे झैं गर बलिको सुगन्धले परमप्रभुलाई खुशी पार्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“तिमीहरूले यी चीजहरू बलिदान स्वरूप परमप्रभुलाई तिमीहरूका सन्तानहरू बाँचुञ्जेलसम्म प्रत्येक दिन जलाउनु पर्छ। भेट हुने पालको प्रवेश द्वारमा यसो गर। यो त्यो स्थान हो जहाँ म परमप्रभुले तिमीहरूलाई भेट्नेछु र तिमीहरूसित कुरा गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","त्यस स्थानमा म इस्राएली मानिसहरूलाई भेट्छु अनि मेरो महिमाले त्यो स्थान सधैं पवित्र बनिरहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“यसर्थ म भेट हुने पाल र वेदी पवित्र पार्नेछु। म हारून र तिनका छोराहरूलाई पनि पवित्र बनाउँनेछु अनि तिनीहरूले मलाई पूजाहारीहरू झैं सेवा गर्न सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","म इस्राएली मानिसहरूको परमेश्वर भई तिनीहरूसंग बस्ने छु। ");
INSERT INTO npi2010_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","तिनीहरूले जान्नेछन् म नै परमप्रभु तिनीहरूका परमप्रभु परमेश्वर हुँ जसले तिनीहरूलाई मिश्र बाहिर निकाले म तिनीहरू माझ वास गर्न सकूँ। म परमप्रभु तिनीहरूको परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","परमेश्वरले मोशालाई भन्नु भयो, “बबुल काठको वेदी बनाऊ। यो वेदी तिमीले धूप बाल्नको निम्ति प्रयोग गर्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","तिमीले त्यो वेदी वर्गाकारमा बनाउनु पर्छ जसको लम्बाइ अनि चौडाइ एक हातको र उचाइँ दुइ हातको रहनेछ। त्यसवेदीको चार कुनामा सींङहरू हुनेछन्। यी सींङहरू वेदीसित एउटै काठले बनिएको जस्तो हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","वेदीमाथिका सबै किनारहरू अनि यसको सींङहरू सुनले मोहोर। वेदीको वरिपरि सुनको एउटा घेरा बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","दुइवटा सुनको मुन्द्रीहरू बनाऊ प्रत्येकलाई वेदीको छेउमा घेरा मुनि जोडी छेऊ वेदी बोक्नको निम्ति यी मुन्द्रीहरूमा लौराहरू लगाइदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","लौराहरू बबुल काठको बनाऊ अनि तिनीहरूलाई सुनले मोहोर। ");
INSERT INTO npi2010_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","वेदीलाई पर्दाहरूअघि राख जसले करारको सन्दूकलाई ढाक्छ र त्यस ढकनीले सन्दूकलाई छोप्छ। त्यो ढकनी त्यही ठाउँ हो जहाँ म तिमीसित भेट गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“प्रत्येक बिहान हारूनले वेदीमा सुगन्धित धूप जलाउन पर्छ। उसको यो कार्य बत्तीहरूको हेरचाह गर्न आउँदा गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","साँझमा पनि जति बेला तिमी बत्तीको हेर्न चाहा गर्न आउँछौ त्यस समयमा उसले सुगन्धित धूप जलाउनु पर्नेछ। यसर्थ परमप्रभुको सामुने तिनीहरूको सन्तान जतिञ्ञेल रहन्छ सदा सर्वदा धूप जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","यस वेदीमा अरू कुनै प्रकारको धूप अथवा होमबलि अन्नबलि अथवा अर्घबलि प्रयोग गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“वर्षमा एकपल्ट हारूनले परमप्रभुलाई एउटा विशेष बलि चढाउनेछ। हारूनले शुद्धिकरण बलिको त्यो रगत प्रयोग गरेर वेदीलाई प्रायश्चित गर्छन्। हारूनले वेदीको सींङहरूमा त्यो रगत चढाउनेछन। त्यो वस्तु परमप्रभुको निम्ति महा पवित्र हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“इस्राएलीहरूको गन्ती गर जसद्वारा तिमीले त्यहाँ कति जन-संख्या छ थाहा पाउनेछौ। हरेकले आफ्नो जीवन बचाउनु परमप्रभुलाई केही भेटी दिनु पर्छ। नत्र तिनीहरूले कष्ट भोग्नु पर्छ जब तिमी उनीहरूको गन्ती गर्छौ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","गन्ती गरिएका प्रत्येक अधिकारिक नापमा आधा शेकेल तिर्नुपर्छ। (एक शेकेल बीस गेराको हुन्छ) यो एउटा बलिदान परमप्रभुको लागि हो। ");
INSERT INTO npi2010_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","गन्ती गरिएकोहरूमा प्रत्येक बीस वर्ष अथवा अधिक उमेर भएकाहरूले यो उपहार चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","बलि धनी र गरीब बीच कुनै भिन्नता बिनै सबैले बराबर तिर्नु पर्छ तर धनीले वेशी र गरीबले कम्ती तिर्नु हुँदैन। यो बलि तिम्रो आफ्नो जीवनको लागि हो। ");
INSERT INTO npi2010_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","उद्धारको पैसा भेट हुने पालको सेवामा प्रयोग गर। यो बलिदानले इस्राएलीहरूलाई सम्झना गराउँछ तिनीहरूका जीवनको निम्ति मोल तिरिएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","परमप्रभुले मोशालाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“काँसाको एउटा भाँडा बनाऊ, त्यसलाई काँसाको आधारमा राख। यो भाँडा भेट हुने पाल र वेदीको बीचमा राखि देऊ अनि हात गोडा धुनको निम्ति यस भित्र पानी भर। ");
INSERT INTO npi2010_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून अनि उनका छोराहरूले तिनीहरूको हातहरू अनि खुट्टाहरू यो पानीले धुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","जब हारून अनि उसका छोराहरू भेट हुने पालभित्र पस्छन् अथवा वेदीको छेउमा आएर परमप्रभुलाई आगोद्वारा बलिदानहरू चढाउँछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","यदि तिनीहरूले हात खुट्टा धोए भने तिनीहरू मर्ने छैनन्। यो नियम हारून र तिनका मानिसहरूको निम्ति भविष्यमा पनि सदा-सर्वदा चलिरहनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“राम्रो मसलाहरू जम्मा गर। 500 शेकेल तरल मूर्र त्यसको आधा (अर्थात 250 शेकेल) मिठो सुगन्धित दालचिनी अनि 250 शेकेल मिठो सुगन्धित काठ, ");
INSERT INTO npi2010_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","अनि 500 शेकेल तेजपात ल्याऊ। एक टीन भद्राक्षको तेल पनि ल्याउनु पर्छ यी सबै चीजहरूको नाप अधिकारिक नाप अनुसार गर। ");
INSERT INTO npi2010_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“यी सबै चीजहरू एक साथ मिलाएर मिठो सुगन्धित पवित्र अभिषेक गर्ने पवित्र तेल बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","यो तेल भेट हुने पाल अनि करारको सन्दूकमाथि छर्क। ");
INSERT INTO npi2010_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","अनि टेबलमाथि, सामदान सबै सामानहरूमाथि अनि सबै सामानहरू अनि धूप वेदीमाथि। ");
INSERT INTO npi2010_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होमबलि चढाउने वेदी र त्यसमाथिको प्रत्येक चीजहरूमा यो तेल हाल। कचौरा अनि यसको आधारमा पनि यो तेल हाल। ");
INSERT INTO npi2010_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","यी सबै चीजहरू महा पवित्र हुनेछन्। यसलाई स्पर्श गर्ने कुनै पनि वस्तु पवित्र हुनपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“हारून अनि उसका छोराहरूलाई यो तेलले अभिषेक गर। तिनीहरू पवित्र हुनेछन अनि पूजाहारीले जस्तै मेरो सेवा गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएलीहरूलाई भन, तिमीहरूका संन्तानहरू रहुञ्जेल सदा-सर्वदा यो मेरो पवित्र अभिषेकको तेल हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","यो पवित्र तेललाई तिमीहरूको शरीरमा साधरण प्रकारले नदल। अरू कुनै तेल यस तरीकाले नबनाऊ। यो तेल पवित्र हो तिमीहरूको निम्ति विशेष तेल मानिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","यदि कुनै मानिसले यो तेल बनाउँछ अनि यो विदेशीलाई दिन्छ जो एउटा पुजाहारी होइन, तब त्यो मानिसलाई उसका मानिसहरूबाट अलग्ग राख्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","त्यसपछि परमप्रभुले मोशालाई भन्नु भयो, “यी सुगन्धित मसलाहरू लेऊः खोटो, कस्तुरी गन्ध, सालधूप अनि शुद्ध धूप। यी सबै मसलाहरूको मात्रा बराबर हुनु आवश्यक छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","सुगन्धित धूप बनाउन यी सबै मसला मिसाऊ र जसरी सुगन्धित तेल बनाएको तरीकामा नै यो धूप पनि बनाउनु पर्छ। शुद्ध र पवित्र पार्नको निम्ति त्यसमा नुन पनि मिलाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","केही धूपहरू पिंदेर एकदमै मसिनो बनाऊ। त्यो धूलोलाई भेट हुने पालभित्र जहाँ म तिमीलाई भेट्छु, करारको सन्दूक छेउमा राख। यो धूपको धूलो मात्र विशेष उद्धेश्यमा प्रयोग गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","यस प्रकारले बनाएको धूपलाई केही उद्धेश्यको निम्ति प्रयोग नगर। तिमीले यसलाई परमप्रभुको निम्ति विशेष तरिकाले प्रयोग गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","कोही मानिसहरूले आफ्नो निम्ति यस प्रकारको विशेष धूप बनाउन खोज्ला र उसले त्यसको सुगन्ध लिन सक्ला, तर यदि कुनै मानिसले त्यसो गरे उसलाई उसको आफन्तहरूबाट छुट्टयाउनै पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","तब परमप्रभुले मोशालाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“यहूदाको परिवारबाट बजलेल ऊरीको छोरा हूरको नातीलाई मेरो निम्ति विशेष काम गर्न चुनेको छु। ");
INSERT INTO npi2010_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","मैले बजलेललाई परमेश्वरको आत्मासित परिपूर्ण पारिदिएको छु अनि उसलाई सबै किसिमको निपुणता, कुशलता, अनि ज्ञानले आशीष दिएको छु। ");
INSERT INTO npi2010_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","उसले सुन, चाँदी अनि काँसाको सुन्दर-सुन्दर वस्तुहरू बनाउन सक्छ किनभने उ एउटा राम्रो शिल्पकार हो। ");
INSERT INTO npi2010_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","बजलेलले सबै प्रकारको कामहरू गर्न सक्छ जस्तै सुनमा कुँद्न पत्थर घेरा लगाउनको निम्ति ढुङ्गा काट्नु अन् सबै उदेश्यको निम्ति काठहरू काट्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","दान कुलका अहीसामको छोरा ओहोलीआबलाई मैले बजलेलको सहयोगीको रूपमा चुनेको छु। मैले दिएको आदेश अनुसार सबै प्रकारका चीजहरू बनाउन सकून् भनेर अन्य सबै कर्मीहरूलाई पनि कार्यक्षमता दिएको छु। ");
INSERT INTO npi2010_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","भेट हुने पाल, कराको सन्दूक, सन्दूकको ढकनी, भेट हुने पालका सबै सामानहरू, ");
INSERT INTO npi2010_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","टेबल अनि त्यसका सबै सामानहरू, सामदान र यसका सबै सामानहरू, धूप जलाउने वेदी, ");
INSERT INTO npi2010_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","होमबलिको निम्ति वेदी र वेदीमा प्रयोग गर्ने सहयोगी कचौराहरू अनि आधारहरू। ");
INSERT INTO npi2010_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","पूजाहारी हारूनको निम्ति विशेष पोशाकहरू, हारूनका छोराहरू जब पूजाहारी भई सेवा गर्छन, तिनीहरूको निम्ति विशेष पोशाकहरू। ");
INSERT INTO npi2010_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेकको निम्ति सुगन्धित तेल अनि सुगन्धित धूप मैले तिमीलाई आज्ञा दिए अनुसार ती कर्मीहरूले यी सबै चीजहरू बनाउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","तब परमप्रभुले मोशालाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“इस्राएली मानिसहरूलाई भन, ‘मेरो विशेष विश्रामको दिनको नियम तिमीहरूले पालन गर्नु पर्छ। तिमीहरूका भावी सन्तानक निम्ति तिमी र म बीचको चिनो यही हुनेछ। यी नियमहरू एउटा नियमहरूले दर्शाउनेछन् कि म परमप्रभुले तिमीहरूलाई मेरा आफ्नो मानिस बनाएको हुँ। ");
INSERT INTO npi2010_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘विश्राम दिनलाई एक विशेष दिनको रूपमा मान। यदि कुनै मानिसले विश्रामलाई अन्य दिन सरह मान्छ त्यो मानिसलाई मार्नु नै पर्छ। यदि कुनै मानिसले विश्रामको दिन काम गर्छ त्यस मानिसलाई उसका आफन्तहरूबाट छुट्ट्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","काम गर्नको निम्ति छः दिन पूरा रहन्छ तर सातौं दिन चाँहि परमप्रभुको निम्ति एकदमै विशेष आरामलिने दिन हुनेछ। कुनै पनि मानिस जसले विश्राम दिनमा काम गर्छ भने त्यस मानिसलाई मृत्यु दण्ड दिइनेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएलीहरूले विश्राम दिनलाई विशेष दिन भनी सम्झना राख्नु पर्छ। यस सम्झौतालाई इस्राएलीहरूले पुस्तौं पुस्तासम्म सदा-सर्वदाको निम्ति पालन गरून्। ");
INSERT INTO npi2010_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","विश्राम दिन म अनि इस्राएलीहरूको बीच एउटा संकेत हो।’” (परमप्रभुले छः दिन काम गर्नु भयो र आकाश र पृथ्वी बनाउनु भयो अनि सातौं दिन उहाँले विश्राम लिनु भयो।) ");
INSERT INTO npi2010_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","यसरी परमप्रभुले मोशासित सीनै पर्वतमा कुरा गरे शेष गर्नु भयो। त्यसपछि उहाँले दुइवटा शिला-पाटीहरूमा आफ्नै औंलाले करार लेखेर मोशालाई दिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मोशा पर्वतबाट तल नओर्लेको धेरै दिन भइसकेको मानिसहरूलाई थाहा भयो। यसर्थ मानिसहरूले हारूनलाई वरिपरि घेरेर भने, “हेर, मोशाले हामीलाई अगुवाई गरी मिश्रबाट बाहिर लिएर आउनु भयो। हामीलाई थाहा छैन तिनलाई के भयो। यसर्थ हाम्रो अगुवाई गर्न हाम्रोलागि केही देवताहरू बनाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","हारूनले तिनीहरूलाई भने, “तिमीहरूकी आफ्नी पत्नीहरू अनि छोरीहरूले कानमा लगाएका सुनको कुण्डलहरू मकहाँ ल्याऊ।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","यसकारण सबै मानिसहरूले कानका सुनको कुण्डलहरू जम्मा गरे अनि हारून कहाँ ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारूनले तिनीहरूबाट सुन लिए, पगालेर यसको एउटा बाछोको मूर्ति बनाए अनि उनले यसलाई सुनले मोहरी दिए। तब मानिसहरूले भने, “हे इस्राएल यिनीहरू तिमीहरूको देवताहरू हो जसले तिमीहरूलाई मिश्र बाहिर ल्याए।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","हारूनले यी सब देखे अनि तिनले बाछाको अघि एउटा वेदी बनाए। त्यसपछि तिनले घोषणा गरे, “परमप्रभुको सम्मानमा भोलि एक विशेष चाड मनाइनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","मानिसहरू बिहान चाँडै उठे पशुहरू मारेर होमबलिहरू चढाए अनि मेलबलिहरू चढाए। मानिसहरू खान तल बसे, तब रमाइलो गर्न उठे। ");
INSERT INTO npi2010_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","तब परमप्रभुले मोशालाई भन्नु भयो, “पर्वतबाट तल ओर्ली हाल। तिमीले मिश्र देशबाट ल्याएका ती तिम्रा मानिसहरूले असाध्यै पाप गरिरहेका छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","तिनीहरूले यति चाडै नियमहरूलाई त्यागे जुन मैले तिनीहरूलाई अनुसरण गर्नु भनी आज्ञा दिएको थिएँ। तिनीहरूले सुन पगालेर एउटा बाछो बनाएका छन् र त्यही बाछोलाई पूजा गर्दैछन् र बलिहरू चढाइरहेका छन्। ती मानिसहरूले भने, ‘हे इस्राएली, यहाँ तिमीहरूका देवताहरू छन् जसले तिमीहरूलाई मिश्रबाहिर ल्याए।’” ");
INSERT INTO npi2010_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","परमप्रभुले मोशालाई भन्नुभयो, “त्यो मैले देखे यी मानिसहरू एकदमै अट्टेरी छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","यसकारण मलाई एक्लो छोडिदेऊ मेरो क्रोध तिनीहरूमाथि उठ्नेछ अनि तिनीहरूलाई ध्वंश गरिदिनेछ। तब म तिम्रा सन्तानलाई एउटा ठूलो जाति बनाउनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","तर मोशाले परमप्रभु उसका परमेश्वरलाई शान्त गराए अनि भने, “हे परमप्रभु तपाईंका आफ्नै मानिसहरूसित चाँडै क्रोधित नहुनुहोस्। तपाईंले यी मानिसहरूलाई मिश्रबाट तपाईंका विशाल अद्भुत शक्ति र बल प्रयोग गरेर बाहिर ल्याउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","यदि तपाईंले तिनीहरूलाई ध्वंश पार्नु भयो भने, ‘मानिसहरूले सोच्ने छन् परमप्रभुले मानिसहरूलाई मिश्र बाहिर लगेको कारण तिनीहरूलाई पर्वतमाथि ध्वंश पार्न मात्र रहेछ।’ यसर्थ तपाईंका आफ्नै मानिसहरूसंग क्रोधित नहुनुहोस्। तपाईंको मन बदली गर्नुहोस् र तपाईंका मानिसहरूलाई नमार्नु होस्। ");
INSERT INTO npi2010_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","अब्राहाम, इसहाक तथा याकूबलाई सम्झना गर्नु होस्, ती मानिसहरूले तपाईंलाई सेवा गरेका थिए अनि तपाईंले एउटा प्रतिज्ञा गर्नुभयो। तपाईंले भन्नु भयो, ‘म तिमीहरूका सन्तानलाई आकाशका ताराहरू भन्दा वेशी बनाउनेछु अनि तिनीहरूलाई सम्पूर्ण भूमि दिनु भयो। यो भूमि तिनीहरूलाई सदाको निम्ति हुनेछ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","यसर्थ परमप्रभुले आफ्नो हृदयलाई कोमल बनाउनु भयो अनि उहाँले के गर्न चाहनु भएको थियो त्यो गर्नु भएन। उहाँले तिनीहरूलाई ध्वंश गर्नु भएन। ");
INSERT INTO npi2010_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","तब मोशा पर्वतबाट तल ओर्लिए। तिनीसित दुवैपट्टि करार लेखिएको दुइवटा शिला-पाटीहरू थियो। यी पाटीहरूमा दुवै पट्टि लेखेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","यी पाटीहरू परमेश्वर आफैंले बनाउनु भयो, अनि यसमाथि आज्ञाहरू लेख्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","जब मोशा पर्वतबाट तलतिर ओर्लिदै थिए यहोशूले मानिसहरूलाई चिंच्याउदै गरेको सुने, यहोशूले मोशालाई भने, “मैले छाउनीभित्र युद्धको ध्वनि सुने।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मोशाले उत्तर दिए, “यो आवाज सेनाहरूको विजय ध्वनि होइन। अनि यो हार्ने सेनाहरूको आवाज पनि होइन। त्यो आवाज जो म सुन्दैछु, त्यो संगीतको स्वर हो।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","मोशा छाउनी नजिक आइपुगे अनि त्यहाँ एउटा बाछो र मानिसहरू नाच्दै गरेको देखे। मोशा एकदमै क्रोधित भए अनि तिनीसित भएको च्याप्टो ढुङ्गाहरू भूँईमा फ्याँके। पर्वतको बेंसीमा ती ढुङ्गाहरू फुटेर टुक्रा-टुक्रा भए। ");
INSERT INTO npi2010_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","तब मोशाले बाछालाई पगाले र यसलाई धूलो पारे। तब उनले धूलोलाई पानीभित्र हाले, उनले त्यो पानी इस्राएलीहरूलाई पिउन कर लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","उसले हारूनलाई भने, “यी मानिसहरूले तिमीलाई के गरे? किन तिनीहरूमाथि तिमीले यस्तो ठूलो पाप ल्यायौ?” ");
INSERT INTO npi2010_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारूनले उत्तर दिए, “हजूर, क्रोधित नहुनु होस्। तपाईंलाई थाहा छ यी मानिसहरू सँधै केही गल्ती गर्न तैयार नै रहन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","यी मानिसहरूले मलाई भने, ‘मोशाले हामीलाई मिश्र देशबाट अगुवाई गर्नु भयो, तर उहाँलाई के भयो हामी जान्दैनौं, यसर्थ हाम्रो अगुवाई गर्न केही देवताहरू बनाऊ।’ ");
INSERT INTO npi2010_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","यसकारण मैले तिनीहरूलाई भनें तिनीहरूको सुन ल्याऊ तिनीहरूले त्यो मलाई दिए। मैले त्यो सुन आगोमा हाले र आगोबाट त्यो बाछो निस्कियो।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशाले देखे हारूनले मानिसहरूलाई नियन्त्रणबाट बाहिर जान दिए, मानिसहरू जंगली जस्तो कुदिरहे अनि तिनीहरूका सबै शत्रुहरूले तिनीहरूको मूर्खको जस्तो व्यवहार देखे। ");
INSERT INTO npi2010_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","यसर्थ मोशा छाउनीको प्रवेशद्वारमा उभिए र भने, “परमप्रभुलाई समर्पण गर्ने जो पनि मेरो वरिपरि भेला हुनुपर्छ। सबै लेवीहरू उनको वरिपरि भेला भए।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","त्यसपछि मोशाले तिनीहरूलाई भने, “परमप्रभु इस्राएलका परमेश्वरले के भन्नु भएको छ म तिमीहरूलाई भन्नेछु ‘प्रत्येकले हातमा तरवार लिएर छाउनीको एक कुनादेखि अर्को कुनासम्म जानुपर्छ। तिमीहरूले आफ्नो दाज्यू-भाइ, साथीहरू, अनि छिमेकीहरूलाई मार्नै पर्छ।’” ");
INSERT INTO npi2010_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","लेवीहरूले मोशाको आज्ञा पालन गरे अनि त्यस दिन लगभग तीन हजार इस्राएलीहरूले ज्यान गुमाए। ");
INSERT INTO npi2010_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","त्यसपछि मोशाले भने, “आज तिमीहरूका छोराहरू अनि दाज्यू-भाइ मारेर आफूलाई परमप्रभुको सेवामा सर्मपण गर्यौ। यसको निम्ति तिमीहरूले आशिष पाउनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","अर्को बिहान मोशाले मानिसहरूलाई भने, “तिमीहरूले असाध्यै ठूलो पाप गर्यौ। अब म परमप्रभुकहाँ जानेछु। हुन सक्छ म तिमीहरूको पापका निम्ति प्रायश्चित गर्नु सक्छु।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","तब, मोशा परमप्रभुकहाँ गए अनि भने, “दया गरी सुन्नु होस्, यी मानिसहरूले सुनको देवता बनाए र साह्रै नराम्रो पाप गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","अब यिनीहरूका पाप क्षमा गरि दिनुहोस्। यदि तिनीहरूलाई क्षमा गर्नु हुँदैन भने तपाईंले लेख्नु भएको पुस्तकबाट मेरो नाउँ निशान मोटाइ दिनुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","तर परमप्रभुले मोशालाई भन्नु भयो, “ज-जसले मेरो विरोधमा पाप गरेकाछन्, म तिनीहरूको नाउँहरू मेरो पुस्तकबाट हटाउने छु। ");
INSERT INTO npi2010_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","यसर्थ तल गएर मैले जहाँ जानु भन्छु त्यहाँ तिनीहरूको अगुवाइ गर। मेरो स्वर्गदूतले तिमीलाई अगुवाई गर्नेछ। जब पाप गर्ने मानिसहरूलाई दण्ड दिने समय आउँछ तिनीहरूलाई दण्ड दिइनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","यसर्थ परमप्रभुले मानिसहरूमाथि डरलाग्दो बिमार खन्याई दिनु भयो। उहाँले यसो गर्नु भयो किनभने हारूनले अगुवाइ गरेका मानिसहरूले एउटा सुनका बाछो बनाएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","तब परमप्रभुले मोशालाई भन्नु भयो, “तिमी र तिम्रा मानिसहरू जसलाई तिमीले मिश्र देशबाट ल्याएका छौ त्यो ठाउँबाट गईहाल। अनि तिमीहरू त्यो भूमिमा जाऊ जुन मैले अब्राहाम, इसहाक र याकूबलाई दिन्छु भनी प्रतिज्ञा गरेको थिएँ। मैले तिनीहरूलाई वचन दिएर भनेको थिएँ, तिमीहरूका भावी सन्तानलाई म त्यो भूमि दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","म एकजना स्वर्गदूतलाई तिम्रो अगुवाइ गर्न पठाउनेछु अनि कनानी, एमोरी, हित्ती, परिज्जी, हिव्वी अनि यबूसीहरूलाई तिनीहरूको भूमि छोडन बाध्य गराउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","यसर्थ तिमीहरू त्यो भूमिमा जाऊ जुन भूमि असल-असल चीजहरूले भरिभराऊ छ। म तिमीहरूसित जाँदिन र यदि म तिमीहरूसित गएँ भने, हुन सक्छ, तिमीहरूलाई म आधा बाटोमा नै ध्वंश पार्नेछु कारण तिमीहरू अत्यन्तै अट्टेरी छौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","मानिसहरू यस्तो दुःख पूर्ण समाचार सुनेर चिन्तित भए। तिनीहरूले गर-गहनाहरू लगाएनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","परमप्रभुले मोशालाई भन्नु भयो, “इस्राएलीहरूलाई भन, ‘तिमीहरू अट्टेरी छौ। यदि म तिमीहरूसंग केही क्षणका निम्ति पनि जानु पर्ने भए म तिमीहरूलाई ध्वंश पार्ने थिएँ। अब तिमीहरूले आफ्नो गहना निकाल अनि म निश्चय गर्ने छु, तिमीहरूलाई के गर्नुपर्ने हो।’” ");
INSERT INTO npi2010_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","यसकारण गहनाहरू होरेब पर्वतमा इस्राएलीहरूले फुकालिदिए। ");
INSERT INTO npi2010_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मोशाले छाउनी केही अघि लगे अनि छाउनी त्यहाँ बसाले अनि त्यसलाई “भेट हुने पाल”नाउँ दिए। कुनै मानिस जसले परमप्रभुबाट केही माग्ने इच्छा गर्छ ऊ भेट हुने पालमा जानु पर्थ्यो जो छाउनी बाहिर थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","जति बेला मोशा पालमा जान्थे, मानिसहरू तिनको आफ्नै पालहरूको ढोकाहरूमा खडा हुन्थे। जबसम्म उनी भेट हुने पालभित्र पस्दैन थिए। तिनीहरूले मोशालाई हेर्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मोशा भेट हुने पालमा जान्थे बादलको लामो स्तम्भ झैं माथिबाट तल आउँथ्यो। त्यो बादलको खामो पालको द्वारमा खडा भई पर्खिरहन्थ्यो यसरी परमप्रभुले मोशासंग कुरा गर्नु हुन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","यसर्थ जब बादलको खम्बालाई मानिसहरूले देख्थे तिनीहरू आफ्नो-आफ्नो पालको द्वारमा गएर परमेश्वरको आराधना गरी निहुरिन्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","यस रीति अनुसार परमप्रभुले मोशासंग साथी जस्तै कुरा गर्नु हुन्थ्यो। परमप्रभसंग कुरा गरिसकेपछि मोशा पालमा फर्कन्थे। तर उसको युवक सहायक नुनको छोरा यहोशू पालभित्र नैं रहन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशाले परमप्रभुलाई भने, “तपाईंले मलाई यी मानिसहरूलाई अगुवाइ गर्ने आदेश दिनु भयो तर यो भन्नु भएन तपाईंले मसंगै कुन मानिस पठाउनु हुन्छ। तपाईंले मलाई भन्नु भयो, ‘म तिमीलाई राम्ररी जान्दछु र म तिमीसित अत्यन्तै खुशी छु।’ ");
INSERT INTO npi2010_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","यदि मैले तपाईंलाई साँच्चै खुशी पारेको भए मलाई तपाईंका तरीकाहरू बताउनु होस्। म तपाईंलाई जान्न चाहन्छु। तब म तपाईंलाई नित्य प्रसन्न पारिराख्छु। स्मरण रहोस् यी सबै मानिसहरू तपाईंका हुन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","परमप्रभुले उत्तर दिनु भयो, “म आफैं तिमीसित जानेछु र तिम्रो अगुवाइ गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","त्यसपछि मोशाले परमप्रभुलाई भने, “यदि तपाईं हामीसित जानुहुन्न भने हामीलाई पनि यस ठाउँबाट नपठाउनुहोस्। ");
INSERT INTO npi2010_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","नत्र हामीहरू कसरी थाहा पाउँछौं तपाईं ती मानिसहरू र मसंग खुशी हुनुहुन्छ। यदि तपाईं हामीसित जानु भएन भने ती मानिसहरूका लागि म र अरू मानिसहरूमा केही भिन्नता रहेन।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","तब परमप्रभुले मोशालाई भन्नुभयो, “तिमीले जो भन्यौ म गर्नेछु। किनभने म तिमीसंग प्रसन्न छु अनि म तिमीलाई राम्रो जान्दछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","त्यसपछि मोशाले भने, “अब दया गरी मलाई तपाईंको महिमा देखाउनुहोस।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","तब परमप्रभुले भन्नुभयो, “म मेरा सबै परिपक्क भलो धर्म तिम्रो अघाडी जानमा लागि गर्नेछु। म ‘यहोवा’ मेरो नाउँ घोषणा गर्ने छु, किनभने म परिपक्क कल्याण कार्य र प्रेम आफूले मन पराएको मानिसअघि देखाउने छु। ");
INSERT INTO npi2010_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","तर तिमीले मेरो अनुहारलाई हेर्न असमर्थ हुनेछौ। कुनै पनि मानिसले मलाई हेर्न सक्दैन अनि जिउँदो रहन सक्दैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","परमप्रभुले भन्नुभयो, “हेर मेरो छेउमा एउटा चट्टान छ अनि तिमी यसमा उभिन सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","मेरो महिमा त्यहाँ जाने छ। म तिमीलाई त्यस चट्टानमा लामो चर्केको ठाउँमा बसाउनेछु। अनि जब म त्यहाँ जान्छु मेरो हातले तिमीलाई छोप्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","त्यसपछि म मेरो हात हटाउनेछु र तिमीले मेरो पछिल्तिरको भाग देख्नेछौ, तर मेरो अनुहार देख्न सक्ने छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","परमप्रभुले मोशालाई भन्नुभयो, “तिमी आफैंले पहिलाको जस्तै दुइवटा चेप्टा ढुङ्गाहरू काट। म त्यही शब्दहरू नयाँ ढुङ्गाहरूमाथि लेख्नेछु मैले जुन पहिले तिमीले धूलो पारेको ढुङ्गामाथि लेखेको थिएँ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","भोलि बिहानै तयार भएर सीनै पर्वतमा म भएकहाँ आऊ। त्यस पर्वतको टाकुरामा मेरोआघि उभिनु। ");
INSERT INTO npi2010_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","तिमीसित कसैलाई पनि आउन नदेऊ। पर्वतको कुनै ठाउँमा कसैलाई देखिनु हुँदैन। पर्वतको बेंसीमा तिमीहरू कसैको गाई, गोरू अथवा भेडाहरू चर्न पाउने छैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","यसकारण अर्को दिन मोशाले दुइवटा चेप्टा ढुङ्गाहरू तयारी बनाए अनि बिहानै उ सीनै पर्वतमाथि चढे। परमप्रभुद्वारा आज्ञा भएका सबै कुरा मोशाले गरे। उनी त्यहाँ ती दुइवटा टुक्रा चेप्टो ढुङ्गा लिएर गए। ");
INSERT INTO npi2010_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","परमप्रभु उनी भएकहाँ तल पर्वतमाथि बादलमा आउनु भयो अनि मोशाको अघि उभिनु भयो। मोशाले परमप्रभुको नाउँको उच्चारण गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","परमप्रभु मोशाको अघि जानु भयो अनि भन्नुभयो, “म यहोवा अनि म परमप्रभु हुँ। म करूणापूर्ण अनि दयालु हुँ। म रिसाउनुमा ढीलो, म प्रेमले परिपूर्ण अनि विश्वास योग्य छु। ");
INSERT INTO npi2010_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","एउटा पुस्तादेखि अर्को पुस्तासम्म परमप्रभुले कृपा देखाउनु हुन्छ। उहाँले मानिसहरूलाई तिनीहरूको दुष्टता, कुकर्म अनि विद्रोहमा क्षमा गर्नुहुन्छ। तर दोषी मानिसलाई दण्ड दिन उहाँ बिर्सिनु हुन्न। तिनीहरूद्वारा गल्ती गरिएको कारण तिनीहरूका छोरा-छोरीहरू, नाति-पनाति, तिनीहरूका सन्तानले तेस्रो अथवा चौथो पुस्तासम्म दुःख भोग्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","तब झट्टै मोशा भुइँमा घोप्टे अनि परमप्रभुको आराधना गरे। तब मोशाले भने, ");
INSERT INTO npi2010_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“हे परमप्रभु यदि तपाईं मसित खुशी हुनुहुन्छ भने हामीसंग हिंड्नु होस्। म जान्दछु यी मानिसहरू अट्टेरी छन् हामीद्वारा कुकर्म गरेकोमा क्षमा गर्नुहोस् अनि हामीलाई तपाईंका आफ्नै मानिसहरू भनी ग्रहण गर्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","तब परमप्रभुले भन्नुभयो, “म यो करार तिम्रा सबै मानिसहरूसंग बनाउन गइरहेछु। म यस्तो आश्चर्यजनक कामहरू गर्नेछु जुन यस पृथ्वीको कुनै भूमिमा अथवा राष्ट्रमा कहिल्यै भएका थिएनन्। तिमीहरू प्रत्येकले देख्नेछन् म परमप्रभु अनि महान सर्वोच्च हुँ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","आज म जुन आज्ञाहरू दिनेछु त्यो पालन गर अनि म एमोरी, कनानी, हित्ती, परिज्जी, हिव्वी अनि यबूसीहरूलाई भूमि छोडन जोड लगाउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","तर होशियार होऊ, कुनै मानिससंग सन्धि नगर जुन भूमिमा तिमीहरू बस्न गइरहेका छौ। यदि तिमीहरूले तिनीहरूसित सन्धि गर्यौ भने तिनीहरूले तिमीहरूलाई नराम्रो कार्य तिर लैजान्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","यसकारण तिनीहरूको वेदीहरू नष्ट गरिदेऊ तिनीहरूका पवित्र खम्बाहरू भत्काइदेऊ अनि तिनीहरूका डण्डाहरू टुक्रा टुक्रा पारिदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","अरू कुनै देवताको आराधना नगर। परमप्रभुको नाउँ एल-कनाह हो डाह गर्ने परमेश्वर। ");
INSERT INTO npi2010_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“होशियार होऊ त्यस ठाउँमा बस्ने मानिसहरूसंग कुनै सन्धि नगर, नत्र तिमीहरूले तिनीहरूका देवताहरूको आराधना र अनि बलिदान दिन शुरू गर्ने छौ। तिनीहरूले तिमीहरूलाई बलिदानका भोजन खानु निम्त्याउने छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","तिमीहरू तिनीहरूको छोरीहरूलाई तिमीहरूको छोराहरूसित विवाह गरिदिन सक्छौ। तर तिनीहरूका छोरीहरू वेश्या झैं झूटो देवताहरूको आराधना गर्छन्। तिम्रा छोराहरूलाई पनि त्यही गर्न लगाउनु सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“मूर्तिहरू नबनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“अखमिरे रोटीको चाड मनाऊ। मैले तिमीहरूलाई आज्ञा दिए अनुसार सात दिनसम्म खमीर बिनाको रोटी खाऊ। यो आबीब महीनामा गर, किनभने त्यो त्यही महीनामा हो जब तिमीहरू मिश्र बाहिर आएका थियौ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“गई वस्तु होस् अथवा भेडा तिनीहरूको पशुहरूबाट पहिले जन्मेको मेरो हो। ");
INSERT INTO npi2010_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","प्रत्येक पहिले जन्मेको गधासित थुमा साट्न सक्छौ। यदि तिमीले थुमासित गधा साटेनौ भने, तिमीले गधाको मण्टो भाँचि दिनुपर्छ। तिमीहरूले मबाट आफ्नो छोराहरूको उद्धार गर्नुपर्छ। कुनै मानिस मेरोअघि बिना भेटी आउनु हुँदैन्। ");
INSERT INTO npi2010_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“तिमीले छ दिन काम गर्नेछौ र सातौं दिन विश्राम लिनु पर्छ। यो विश्राम तिमीहरूले बाली रोप्ने र उठाउने समयमा पनि लिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“साताको चाड पहिलो अन्न बाली उठाऊ र मनाऊ। अन्न भित्र्याउने चाड ऋतुको आखिरमा मनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“वर्षमा तीन पल्ट सबै इस्राएली मानिसहरू र तिनीहरूका छोराहरू परमप्रभु तिनीहरूका स्वामी इस्राएलका परमेश्वरकहाँ जानु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“तिमीहरू जब आफ्नो भूमिमा जानेछौ म तिमीहरूका शत्रुहरूलाई बलपूर्वक भगाईदिनेछु। म तिमीहरूको भूमिको सिमाना विस्तारित गर्नेछु। जब तिमीहरू वर्षमा तीन पल्ट परमप्रभु आफ्नो परमेश्वरको सामुन्ने जान्छौ तिमीहरूको भूमि कसैले पनि लाने चेष्टा गर्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“जब तिमीले मलाई बलिदान चढाउँछौ, रगतसंग कुनै खमीर नचढाऊ। “निस्तार चाडको मासु अर्को बिहानसम्म नराख। ");
INSERT INTO npi2010_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“तिमीहरूको फसलबाट पहिलो अन्नहरू परमप्रभु तिमीहरूका परमेश्वरको घरमा ल्याऊ। “कलिलो पाठीलाई त्यसकी माऊको दूधमा नै पकाउनु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","परमप्रभुले मोशालाई भन्नु भयो, “मैले तिमीलाई भनेका सबै कुराहरू लेख। यी कुराहरू करार हुन्, जुन मैले तिमी र इस्राएलीहरूसंग गरिरहेकोछु।” ");
INSERT INTO npi2010_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","त्यहाँ मोशा चालीस दिन र चालीस रातसम्म परमप्रभुसंग बसे। तिनले न ता केही खाए न ता पिए। मोशाले करारका वचनहरू अर्थात् दश आज्ञाहरू दुइवटा पाटीहरूमा लेखे। ");
INSERT INTO npi2010_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","त्यसपछि मोशा सीनै पर्वतबाट तल आए। उनले आफूसित दुइ शिला-पाटीहरू ल्याए। मोशाले थाह पाएनन् उनको अनुहार चम्किरहेको थियो किनभने उनले परमप्रभुसंग कुरा गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","हारून र इस्राएली मानिसहरूले देखे मोशाको अनुहार चम्किरहेको थियो। तिनीहरू उनको छेउमा जान डराए। ");
INSERT INTO npi2010_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","मोशाले हारून अनि सबै बूढा-प्रधानहरूलाई आफूसित बस्न बोलाए। मोशाले तिनीहरूसंग कुरा गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","त्यसपछि इस्राएलीहरू मोशाको छेउमा आए अनि उनले परमप्रभु द्वारा सीनै पर्वतमाथि दिनु भएका ती आज्ञाहरू तिनीहरूलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","जब तिनले मानिसहरूसित कुरा गरी सके पछि तिनले आफ्नो अनुहार ढाके। ");
INSERT INTO npi2010_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","कुनै पनि समय जब मोशा कुरा गर्नको निम्ति परमप्रभुअघि जान्थे आफ्नो अनुहार नढाकी जान्थे। त्यसपछि मोशा बाहिर आएर परमप्रभुले दिनु भएका आज्ञाहरू इस्राएलका मानिसहरूलाई सुनाउथे। ");
INSERT INTO npi2010_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएली मानिसहरूले मोशाको अनुहार चम्किरहेको देखे। यसकारण अर्को पल्ट परमप्रभुसंग कुरा गर्न नजाउञ्ञेलसम्म मोशाले आफ्नो अनुहार छोपिरहे। ");
INSERT INTO npi2010_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशाले सबै इस्राएलीहरूलाई एक जग्गामा भेला पारे अनि तिनीहरूलाई भने, “परमप्रभुका आज्ञाहरू म तिमीहरूलाई भन्छु। ");
INSERT INTO npi2010_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“काम गर्नको निम्ति छ दिन छ र सातौं दिन तिमीहरूको निम्ति विश्राम गर्ने विशेष दिन हो। सात दिन परमप्रभुलाई समर्पण गरिएको हो। कुनै पनि मानिस जसले विश्राम दिनमा काम गर्छ त्यो मारिनु नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","विश्राम दिनमा तिमीहरूले तिमीहरू बसेको भूमिमा आगो पनि बाल्नु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","इस्राएलका सबै मानिसहरूलाई मोशाले भने, “परमप्रभुले दिनु भएको आज्ञा यही हो। ");
INSERT INTO npi2010_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","परमप्रभुको निम्ति विशेष उपहारहरू भेला गर। तिमीहरू प्रत्येकले के चढाउन चाहन्छौ हृदयले निर्णय गर। त्यसपछि परमप्रभुलाई चढाउन उपहार लिएर आउनु पर्छ। सुन, चाँदी, काँसा, ");
INSERT INTO npi2010_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","निलो, बैजनी अनि रातो धागो र मसिनो सुती कपडा, र बाख्राको भुत्ला, ");
INSERT INTO npi2010_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","तन्काएको बाख्राको छाला, नरम छाला र बबुलको काठ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","दीयोको निम्ति तेल, अभिषेक तेल बनाउनको निम्ति मसला र सुगन्धित धूपको निम्ति मसला। ");
INSERT INTO npi2010_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","गोमेदक-रत्न तथा एपोदमा र न्यायको थैलीमा कुदाउने अरू रत्नहरू ल्याऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“तिमीहरू जो निपुण कर्मीहरू छौ, परमप्रभुले गर्नु भन्नु भएको आज्ञा अनुसरण गरेर सब चीजहरू बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","पवित्र पाल, त्यसको बाहिरी पाल र त्यसलाई आवरणहरू, अंकुसे, बार, खम्बा अनि आधारहरू, ");
INSERT INTO npi2010_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","पवित्र सन्दूक, त्यसका डण्डाहरू अनि आवरण र पर्दा जसले पवित्र सन्दूक राखिने जग्गा ढाक्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","टेबल अनि यसको डण्डाहरू र यसको चीज-बीजहरू जो टेबलमाथि राखिन्छ अनि विशेष रोटी परमप्रभुको अघाडी राखिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","बत्तीको निम्ति सामदान, त्यसले सबै सामग्रीहरूमा प्रकाश दिन्छ, अनि तेल त्यो जलेर प्रकाश दिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धूपको निम्ति वेदी अनि त्यसका डण्डाहरू, अभिषेक गर्ने तेल, अनि सुगन्धित धूप र पवित्र पालको प्रवेशद्वारमा लगाइने पर्दा, ");
INSERT INTO npi2010_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमबलिको निम्ति वेदी अनि काँसाको कोरेसो डण्डाहरू अनि वेदीमा प्रयोग गरिने सबै चीजहरू, काँसाको बटुका र तिनका आधार, ");
INSERT INTO npi2010_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","आँगन वरिपरिको पर्दा। तिनीहरूका डण्डाहरू र आधार जुन आँगनको फाटकमा राखिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","चुकुलहरूले पवित्र पाल अनि आँगनका वरिपरिको पर्दाहरू अडाउनलाई प्रयोग गरिएका चुकुलहरू स्थिर राख्छन् अनि डोरी जसले ती चुकुललाई बाधेर राख्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्र स्थानमा पूजाहारीहरूले विशेष बुनेको लुगा लगाउनु पर्छ। हारून अनि उसका छोराहरूले पूजाहारी भई सेवा गर्दा यी पोशाकहरू लगाउँथे।” ");
INSERT INTO npi2010_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","तब इस्राएली मानिसहरू मोशालाई छोडेर गए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","तिनीहरू जसले परमप्रभुलाई भेटीहरू चढाउन इच्छा गरे तिनीहरूले सबै भेटीहरू ल्याए। ती भेटीहरू भेट हुने पालको काममा अनि विशेष पोशाकको निम्ति प्रयोग गरियो। ");
INSERT INTO npi2010_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","सबै पुरूष र स्त्रीहरू ज-जसले भेटी चढाउनु चाहन्थे सबै प्रकारको सुनका गहनाहरू ल्याए। तिनीहरूले कुण्डल, औंठी र अंकुसेहरू ल्याए। तिनीहरू सबैले परमप्रभुको निम्ति यी भेटीहरू चढाए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","प्रत्येक मानिसहरू जोसित मिहीन सुती अथवा निलो, बैजनी, रातो धागो, मसिनो सुती कपडा थिए, परमप्रभुलाई चढाउन ल्याए। प्रत्येक मानिस जससित बाख्राका भुत्ला अनि सुकाएको बाख्राको छाला अथवा मिहीन छाला थियो ती छालाहरू परमप्रभुलाई चढाउन ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","प्रत्येक जोसंग चाँदी अथवा काँसा थियो परमप्रभुकहाँ विशेष भेटीहरू स्वरूप चढाए। जोसंग बबुलको काठ थियो यो काममा प्रयोग गराउनु ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","प्रत्येक निपुण स्त्रीहरूले मसिनो सुती कपडा, निलो, बैजनी अनि रातो धागो बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ती सबै स्त्रीहरू जो निपुण थिए अनि सहायता गर्न चाहन्थे तिनीहरूले पनि बाख्राको भुत्लाबाट लुगाहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","नायक मानिसहरूले पनि गोमेद अनि र अन्य रत्नहरू ल्याए। यी रत्नहरू एपोद अनि न्याय थैलीमाथि लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","मानिसहरूले मसला र भद्राक्षको तेल पनि ल्याए। ती चीजहरू सुगन्धित धूप, अभिषेक तेल बत्तीको निम्ति तेल प्रयोग गरियो। ");
INSERT INTO npi2010_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","इस्राएलका सारा मानिसहरू जसले भेटी चढाउने इच्छा गर्थे तिनीहरू सबैले परमप्रभुलाई भेटी चढाउने चीजहरू ल्याए। सम्पूर्ण हृदयले आफूलाई इच्छा लागेको चीजहरू चढाए। परमप्रभुले मोशा र इस्राएली मानिसहरूलाई बनाउनु भन्नु भएको चीजहरू बनाउन थालियो। ");
INSERT INTO npi2010_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","तब इस्राएली मानिसहरूलाई मोशाले भने, “हेर, यहूदा कुल समूहका ऊरीका छोरो बजलेललाई परमप्रभुले चुन्नु भयो। (ऊरी हुरका छोरा हुन्।) ");
INSERT INTO npi2010_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","परमप्रभुले बजलेलमा परमेश्वरको आत्मा भर्नु भयो। उहाँले बजलेललाई सब प्रकारको सीप र ज्ञान दिनुभएको छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","उसले सुन, चाँदी अनि पीतलमा कसरी आकार बनाउनु पर्छ जान्दछ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","उसले पत्थर तथा गहनाहरू चाहिए अनुसार कुँद्न सक्छ। उसले काठमा खोप्न अनि काठबाट सबै प्रकारको चीजहरू बनाउन सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","परमप्रभुले बजलेल र ओहोलीआबलाई विशेष सीप दिनु भएकोछ र तिनीहरूले अरू मानिसहरूलाई पनि सिकाउन सक्छन्। (ओहोलीआब दान कुल समूहका अहीसामाकको छोरो हो।) ");
INSERT INTO npi2010_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","परमप्रभुले तिनीहरूलाई काठ र धातुमा। कुँद्ने र बुट्टा बनाउने अनि निलो, बैजनी अनि रातो धागोबाट लुगा अनि मिहीन सुती लुगा बनाउने सीप दिनु भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“यसकारण बजलेल, ओहोलीआब अनि अरू सबै निपुण कर्मीहरूलाई आज्ञा परमप्रभुले दिनुभएको अनुसारका चीज बनाउनु पर्छ। परमप्रभुले पवित्र स्थान बनाउन आवश्यक पर्ने चीज बनाउनु ती निपुण कर्मीहरूलाई सीप दिनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","त्यसपछि मोशाले बजलेल, ओहोलीआब अनि अरू सबै निपुण मानिसहरूलाई बोलाए ज-जसलाई परमप्रभुले विशेष ज्ञान दिनुभएको थियो। ती मानिसहरू पनि आए किनभने तिनीहरूले यो काममा सहायता गर्न चाहन्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","मोशाले तिनीहरूलाई ती सब चीजहरू दिए जो इस्राएली मानिसहरूले परमप्रभुको निम्ति उपहार स्वरूप ल्याएका थिए अनि तिनीहरूले ती सबै चीजहरू पवित्र स्थान निर्माण गर्न प्रयोग गरे। मानिसहरूले प्रत्येक बिहान भेटीहरू ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","आखिरमा ती सबै कर्मीहरूले तिनीहरूले गर्दै गरेको काम रोके। तिनीहरू मोशाकहाँ गए र भने, ");
INSERT INTO npi2010_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“मानिसहरूले उपहारहरू धेरै ल्याए। अहिले हामीसंग परमप्रभुले आज्ञा गर्नु भए अनुसार चीजहरू बनाउन चाहे भन्दा प्रशस्त समानहरू छन्।” ");
INSERT INTO npi2010_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","तब मोशाले पुरै छाउनीमा यो समाचार पठाए, “अब कुनै पनि पुरूष अथवा स्त्रीले पवित्र स्थानका निम्ति केही पनि भेटी ल्याउनु पर्दैन।” यसकारण मानिसहरूले भेटीहरू ल्याउन रोके। ");
INSERT INTO npi2010_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","मानिसहरूले आवश्यक भन्दा बेशी भेटीहरू पठाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","तब निपुण कर्मीहरूले पवित्र पाल निर्माण गर्न शुरू गरे। तिनीहरूले मसिनो सुतीको कपडा अनि निलो, बैजनी अनि रातो धागोहरू बाट दशवटा पर्दाहरू बनाए। तिनीहरूले प्रत्येक पर्दाहरूमाथि करूब स्वर्गदूतको बुट्टा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","त्यहाँ बनिएका प्रत्येक पर्दा एउटै नापको थिए। 28 हात लामो अनि 4 हात चौंडाई भएको। ");
INSERT INTO npi2010_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ती कर्मीहरूले पाँचवटा पर्दाहरूलाई जोडेर एउटा बनाए, अनि तिनीहरूले अर्को पाँचवटा पर्दाहरूलाईसंगै जोडेर अर्को एउटा पर्दा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","पहिलाको पर्दाको अन्तिम किनारमा सुर्काउनी बनाउन तिनीहरूले निलो लुगा प्रयोग गरे। तिनीहरूले अर्को समूहको अन्तिममा पनि त्यसै गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","एक समूहको अन्तिम पर्दामा पचास सुर्काउनी र अर्को समूहको अन्तिम पर्दामा पनि पचास सुर्काउनीहरू थिए। सुर्काउनीहरू एकार्को थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","त्यसपछि तिनीहरूले सुनका पचासवटा अंकुसेहरू ती दुइ पर्दालाई जोडन बनाए अनि यसरी पवित्र पालसंगै जोडिएर एउटै भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","त्यसपछि कर्मीहरूले पवित्र पाल ढाक्नको निम्ति अर्को एउटा पाल बनाए। तिनीहरूले एघारवटा पर्दाहरू बनाउन बाख्राको भुत्ला प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","तीस हात लामो अनि चार हात चौडा सबै पर्दाहरू एउटा नापका बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ती कर्मीहरूले पाँचवटा पर्दा जोडेर एउटा ठूलो र फेरि छ वटा पर्दा जोडेर अर्को समूह बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","एक समूहको आखिरी पर्दीको अन्तिम किनारामा तिनीहरूले पचासवटा प्वालहरू पारे अनि अर्को समूहको अन्तिम किनारामा पनि पचासवटा प्वालहरू पारे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ती दुइ समूहका पर्दाहरू जोडेर एउटा पाल बनाउन तिनीहरूले काँसाको पचासवटा अंकुसे बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","तब तिनीहरूले पवित्र पालको निम्ति अझ दुइवटा आवरणहरू बनाए। एउटा आवरण रातो रंगले रंगाएको भेडाको छालाबाट अनि अरू नरम छालाहरूबाट बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","तब तिनीहरूले बबुल काठको फल्याकहरू पवित्र स्थानलाई सहायता गर्न बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","प्रत्येक फल्याक दश हात लामा अनि एक हात आधा चौडाइको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","प्रत्येक फल्याक बनाउँदा दुइवटा खम्बाहरू एका अर्कोमा बाख्राको भुत्लासित जोडिएका थिए। यी सबै फल्याकहरू पवित्र स्थानको निम्ति थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","पवित्र स्थानको दक्षिण पट्टिको निम्ति तिनीहरूले बीसवटा फल्याकहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","त्यसपछि तिनीहरूले चालीसवटा चाँदीको आधारहरू बनाए तिनीहरूले दुइवटा आधारहरू प्रत्येक फल्याकमा लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","तिनीहरूले पवित्र पालको उत्तर पट्टिको निम्ति पनि बीसवटा फल्याकहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","तिनीहरूले चालीसवटा आधारहरू बनाए, तिनीहरूले दुइवटा आधारहरू प्रत्येक फल्याकमा लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","पवित्र पालको पश्चिम भागको तिनीहरूले अझै छःवटा फल्याकहरू तैयार गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","पवित्र पालको पछिल्तिरको कुनाको निम्ति पनि तिनीहरूले दुइवटा फल्याकहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","अनि यी फल्याकहरू तल सबै संगै जोडिएका थिए। माथिल्लो भागमा कुनाका फल्याकहरू एउटा अंकुसेले जोडिएका थिए। ती कर्मीहरूले अरू कुनाका फल्याकहरू पनि त्यसरी नै जोडेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","यसकारण त्यहाँ जम्मा आठवटा फल्याकहरू अनि प्रत्येक फल्याकको दुइवटा आधारहरू थिए, जम्मा सोह्रवटा चाँदीका आधारहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","कर्मीहरूले बबुलको काठ पवित्र पालको एक पट्टिको फल्याक पाँच पट्टी बनाउन प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","प्रयोग गरे अर्को पट्टिको फल्याकहरूको निम्ति पाँचवटा पट्टीहरू अनि पवित्र पालको पछि पट्टिको फल्याकहरूको पश्चिम पट्टि। ");
INSERT INTO npi2010_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","तिनीहरूले मध्य फल्याकहरूबाट एक कुना देखि अर्को कुनासम्म छिराएर पठाउनलाई बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","तिनीहरूले यी फल्याकहरूलाई सुनले मोहोरे। तब तिनीहरूले पट्टी समात्नको निम्ति मुन्द्राहरू बनाए। तिनीहरूले बारहरूलाई सुनले मोहोरे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","तिनीहरूले महापवित्र स्थानका पर्दाहरू बनाउदा मिहीन निलो सुती लुगा बैजनी र रातो धागो प्रयोग गरे अनि तिनीहरूले मिहीन सूती लुगामाथि करूब स्वर्गदूतको चित्रमा बुट्टा भरे। ");
INSERT INTO npi2010_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","तिनीहरूले बबुल काठको चारवटा खम्बाहरू बनाएर सुनले मोहरे। ती खम्बाहरूका निम्ति सुनको अंकुसेहरू बनाए। तिनीहरूले ती खम्बाहरूको निम्ति चारवटा चाँदीका आधारहरू पनि बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","त्यसपछि पवित्र पालको प्रवेशद्वार ढाक्न तिनीहरूले पर्दा बनाए। यस पर्दाको निम्ति मिहीन सूती अनि निलो, बैजनी अनि रातो धागो प्रयोग गरे र पर्दामा नक्शा सिलाए। ");
INSERT INTO npi2010_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","प्रयोग द्वारमाथि पर्दाको लागि तिनीहरूले पाँचवटा खम्बाहरू तथा अंकुसेहरू बनाएर खम्बाका सुर्काउनीहरू र पर्दाका खाम्बालाई सुनले मोहोरे। ती पाँचवटा खम्बाको लागि तिनीहरूले पाँचवटा आधारहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बजलेलले बबुल काठको पवित्र सन्दूक बनाए। त्यो सन्दूकको लम्बाई दुइ हात आधा, चौडाइ र उचाइ एक हात आधाको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","त्यसको भित्र र बाहिर उसले सुनले मोहोर्यो उसले सन्दूकको वरिपरि सबैमा सुनको घेरा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","सन्दूकको एकपट्टि दुइवटा मुन्द्री लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","उसले बबुल काठका डण्डाहरू बनाए अनि तिनीहरूलाई सुनले मोहोरी दियो। ");
INSERT INTO npi2010_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","उसले डण्डाहरू सन्दूकको दुवै भागमा भएका मुन्द्रीहरू भित्र घुसार्यो। यी डण्डाहरू सन्दूक बोक्न प्रयोग गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","तब सन्दूकको आवरण शुद्ध सुनले बनाए। यो दुइ हात आधा लामो अनि एक हात आधा चौंडाईको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","तब आवरणको प्रत्येक छेउममा बजलेलले करूब स्वर्गदूतको सुनको दुइवटा आकृतिहरू कुँदे। ");
INSERT INTO npi2010_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","उनले एउटा करूब स्वर्गदूतलाई आसनको एक छेउमा राखे, उनले अर्को करूब स्वर्ग दूतलाई आसनको अर्को छेउमा राख्यो, र करूब स्वर्गदूतलाई आसनसित जोडे तिनीहरू एउटै भए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","करूब स्वर्गदूतका पखेंटाहरू आसनमाथि फैलिएका थिए, र तिनीहरूले त्यसलाई ढाकेका थिए। स्वर्गदूतहरू एक-अर्काका सम्मुख आसनभित्र हेरिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बजलेलले बबुल काठबाट एउटा टेबल बनाए। यो टेबलको लम्बाई दुइ हात चौंडाइ एक हात अनि एक हात आधा उँचाई थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","उनले टेबललाई शुद्ध सुनले मोहोरी दिए अनि सुनको घेरा टेबलको वरिपरि बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","उनले टेबलको वरिपरि चार औंलो ठूलो ताक्ता बनायो। उनले फल्याकको वरिपरि सबैतिर सुनले मोहोरी दियो। ");
INSERT INTO npi2010_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","फेरि उनले सुनको चारवटा मुन्द्रीहरू बनाए र त्यस टेबलको चारकुनामा र खुट्टाको छेउमा लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","उनले फल्याकको नजिकै मुन्द्रीहरूलाई जोडे। डण्डाहरू मुन्द्रीहरूभित्र टेबल बोक्न लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","तब उनले बबुल काठको डण्डा बनाए अनि यसलाई सुनले मोहोर्यो। ती डण्डाहरू टेबल बोक्नुमा प्रयोग गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","त्यसपछि उनले टेबलमा प्रयोग गरिने वस्तुहरू थालहरू, धुपौरोहरू, कोपरा पेयबलि चढाउन गाग्री बनाए। यी सबै शुद्ध सुनबाट बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","त्यसपछि उनले सामदान बनाए। उनले शुद्ध सुनलाई मार्तोलले कुटेर सामदानको आधार अनि डण्डा बनाए। तब उनले कोपिला, फूल र पत्र बनाएर एकै ठाँउ जोडे। ");
INSERT INTO npi2010_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","त्यो सामदानको एकापट्टि तीनवटा र अर्को तिर तीनवटा गरी जम्मा छ वटा शाखाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","प्रत्येक शाखामा तीनवटा फूलहरू थिए। यी फूलहरू वदामको फल जस्तै र त्यससित कोपिला र पत्रहरू पनि थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","त्यो सामदानको डण्डामा चारवटा फूलहरू थिए। तिनीहरूको आकार बदामको फूलसित कोपिला अनि पातहरू जस्ता थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","सामदानका दुइ पाटाबाट निकालिएको तीन तीनवटा गरी छःवटा शाखामा फूल, कोपिला र पत्रहरू थिए। ती फूलहरू शाखा निस्किएको ठाउँमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","सबै फूल सामदानका, हागाहरू शुद्ध सुनबाट बनाए। यी सबै भाग एउटै बनाउनलाई संगै जोडिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","उनले सामदानको निम्ति सातवटा दियोहरू बनाए। उनले शुद्ध सुनबाट सलेदो मिलाउने थाली बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","उनले एक तोडा शुद्ध सुनको सामदान अनि सबै सामग्री बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","बजलेलले वेदी बनाउनका लागि बबुल काठका उपयोग गरे। यो वेदी धूप बाल्नमा उपयोग हुन्थ्यो। यो एक हात लामो, एक हात चौडा अनि दुइ हात उँचाईको थियो। यो वेदी वर्गकार थियो। प्रत्येक कुनामा एक-एकवटा गरी यस वेदीमा चावटा सींङहरू थिए। यी सींङहरू एउटै बनाउनलाई वेदीसित जोडिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","उनले सिङहरूमाथि अनि सींङका पाटाहरू शुद्ध सुनर त्यसपछि वेदीको वरिपरि सुन पगालेर घेरा ठोके। ");
INSERT INTO npi2010_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","उनले सुनको दुइवटा मण्डपहरू बनाएर वेदीको दुवै पट्टि मोहोरेको भित्र जोडीदिए। यी मुन्द्रीहरू वेदी उठाएर कतै लाँदा डण्डाहरू घुसार्ने काममा प्रयोग हुन्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","उनले त्यसपछि बबुल काठको डण्डा बनाएर त्यसलाई सुनले मोहोरे। ");
INSERT INTO npi2010_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","त्यसपछि उनले अभिषेक गर्ने पवित्र तेल अनि सुगन्धित शुद्ध धूप बनाए। उनले सबै चीजहरू सुगन्धित अत्तर बनाउनेले झैं बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","त्यसपछि बजलेलले होमबलिको निम्ति बबुल काठको एउटा वेदी बनाए। यो वेदी पाँच हात लामो, पाँच हात चौडा अनि तीन हात अग्लो थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","उनले यस वेदीको चार कुनामा लगाउन चारवटा सींङहरू बनाए। उनले वेदीलाई काँसाले मोहरे। ");
INSERT INTO npi2010_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","त्यसपछि उनले त्यस वेदीमा प्रयोग गरिने हतियारहरू सबै काँसाकै बनाए। उनले भाँडाहरू, करूबहरू, काँटा र तावाहरू सबै काँसाको बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","त्यसपछि उनले वेदीको निम्ति एउटा जाली बनाए अनि यसको मनि उसले किनारा राख्यो। यो वेदीको आधा भागसम्म पुगेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","त्यसपछि उनले डण्डाहरूलाई समात्न चारवटा काँसाको मुन्द्रीहरू बनायो। यी मुन्द्रीहरू चार किनाराहरूमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","उसले वेदी बोक्ने डण्डा बबुल काठका बनाएर त्यसलाई काँसाले मोहरे। ");
INSERT INTO npi2010_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","वेदी बोक्न मुन्द्रीहरूमा डण्डा हाले। वेदी रित्तो सन्दूक झैं खोक्रो फल्याकले बनिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","उनले काँसाको बाटा र त्यसलाई अडाउने आधारहरू बनाए। उनले काँसाको ऐना बनायो जुन ती आइमाईहरूले चढाएका थिए। यी आइमाईहरू भेट हुने पालको प्रवेशद्वारमा सेवा गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","उनले सबै आँगनको वरिपरि पर्दाहरूको पर्खाल बनाए। दक्षिणति एक सय हात लामो पर्दाहरू पर्खाल बनाए। पर्दाहरू मिहीन सुती लुगाको बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","बीसवटा खम्बाहरूले दक्षिण तिरको पर्दाहरूलाई सहारा दिएको थिए। ती खम्बाहरू बीसवटा काँसाका आधारहरूमाथि थिए। खम्बाहरू र पर्दाको डण्डाको निम्ति अंकुसेहरू चाँदीले बनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","आँगनको उत्तर तिर एक सय हात लामो पर्दाहरूको बार जस्तो थियो। त्यहाँ पनि बीसवटा खम्बाहरू र तिनीहरूलाई अड्याउन बीसवटा खम्बाको निम्ति काँसाका आधारहरू थिए। खम्बा र पर्दाको डण्डाको निम्ति अंकुसेहरू चाँदीले बनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","आँगनको पश्चिम तिर पचास हात लामा पर्दाहरूको बार थियो। त्यहाँ दशवटा खम्बाहरू र दशवटा आधारहरू थिए। खम्बाहरू र पर्दाको लागि अंकुसहरू चाँदीका बनाएको थिए ");
INSERT INTO npi2010_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","आँगनको पूर्व पट्टिको लम्बाई पचास हात थियो। आँगनको प्रवेशद्वार यही दिशामा थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","प्रवेशद्वारको एकापट्टि भएको पर्दाको पर्खालको लम्बाई पन्ध्र हात थियो। त्यता पट्टि तीनवटा खम्बा र तीनवटा आधारहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","प्रवेशद्वारको अर्को तिरको पर्खालको लमाई पनि पन्ध्र नै थियो। त्यहाँ पनि तीनवटा खम्बा र तीनवटा आधारहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","आँगन वरिपरि लगाइएका पर्दाहरू मिहीन सुती लुगाले बनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","खम्बाको निम्ति आधारहरू काँसाको बनिएका थिए। अंकुसेहरू र पर्दाका डण्डाहरू चाँदीले बनिएका थिए। खम्बाकोमाथिल्लो भाग चाँदीले मोहोरेको थियो। आँगनमा लगाइएका सबै खम्बाका पर्दामा चाँदीको डण्डाहरू लगाइएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","आँगनको मूलद्वारमा लगाइएका पर्दाहरू मिहीन सुती लुगाले बनिएको र रातो, बैजनी र निलो धागोले बुटा भरेका थिए। पर्दाहरूमा बुट्टा बनाइएको थियो। आँगन वरिपरिका पर्दा बीस हात लामो र पाँच हात अग्ला थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","यो पर्दालाई काँसाको आधारमा उभ्याइएका चारवटा खम्बाहरूमा अंकुसेहरू थियो। खम्बाहरूसित लगाइएको अङकुसेहरू चाँदीका थिए। पर्दाका डण्डाहरू र खम्बाका शिरमा चाँदीले मोहोरिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पवित्र पालको र आँगन वरिपरि लगाइएका पर्दाका कीलाहरू काँसाले बनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","पवित्र पालमा प्रयोग गरिएका सबै चीजहरूको सूची बनाउन मोशाले लेवी मानिसहरूलाई आज्ञा दिए। जस्तै करारको मण्डप हारूनका छोरो ईतामार त्यो सूची बनाउने मानिस थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","यहूदा वंशको नाति अनि ऊरीका छोरो बजलेलले प्रत्येक चीज मोशालाई परमप्रभुले दिनु भएको आज्ञा अनुसार बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","दान वंशको अहीसामाकको छोरो ओहोलीआबले पनि उसलाई सहायता पुर्याए। ओहोलीआब एक शिल्प कर्मी तथा चित्रकार थिए। ऊ पनि मसिनो सुतीको कपडा अनि निलो, बैजनी अनि रातो धागोले बुट्टा बुन्न निपुण थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्र स्थान निर्माण गर्न उनन्तीस तोडा र सात सय तीस शेकेलभन्दा ज्यादा सुन परमप्रभुलाई बलिदानको रूपमा भेटी चढाए। (यो ओजन मन्दिरका अधिकारी अनुसार थियो।) ");
INSERT INTO npi2010_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","सबै गन्ती गरिएका मानिसहरूले लगभग एक सय तोडा अझै एक हजार सात सय पचत्तर शेकेल चाँदीहरू चढाए। (अधिकारीहरू द्वारा गरिएको ओजन) ");
INSERT INTO npi2010_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","त्यहाँ छ लाख तीन हजार पाँच सय पचास जना मानिसहरू (बीस वर्ष अथवा त्यो भन्दा ज्यादा उमेर मानिसहरूको गन्ती गरिएको थियो।) प्रत्येक मानिसले अधिकारीले प्रयोग गरेको ओजन अनुसार आधा शेकेल चाँदी तिर्नु पर्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","परमप्रभुको पवित्र पाल अनि पर्दाहरूको निम्ति एक सय आधारहरू बनाउँदा तिनीहरूले एक सय तोडा चाँदी प्रयोग गरे। तिनीहरूले प्रत्येक आधारको निम्ति एक तोडा चाँदी खर्च गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","थोरैभन्दा थोरै सत्र सय पचहत्तर शेकेल चाँदी पर्दाको निम्ति अंकुसेहरू बनाउन र खाम्बाहरू मोहोर्न प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","अनि सत्तर तोडा अनि दुइ हजार चार सय शेकेल काँसा भन्दा वेशी परमप्रभुका निम्ति चढायो। ");
INSERT INTO npi2010_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","त्यो काँसा भेट हुने पालको प्रवेशद्वारको आधारहरू बनाउनमा प्रयोग गरे। तिनीहरूले पीत्तलको वेदी, काँसाको जाली र वेदीमा चाहिने समानहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","काँसा आँगन वरिपरि र प्रवेश द्वारको पर्दाहरूको निम्ति आधारहरू बनाउन पनि प्रयोग गरे। अनि पवित्र पालको कीलाहरू र आँगन वरिपरिका पर्दाको कीलाहरू बनाउँदा पनि प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","पूजाहारीहरूले पवित्र स्थानमा सेवा गर्दा लगाउने विशेष लुगाहरू बनाउदा ती चित्रकारहरूले निलो, बैजनी अनि राता धागोको प्रयोग गरे। परमप्रभुले मोशालाई आज्ञाहरू दिए अनुसार तिनीहरूले हारूनको निम्ति विशेष लुगाहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","तिनीहरूले एपोद सुनको धागो, मिहीन सुतीको लुगा अनि निलो, बैजनी र रातो धागोले बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","तिनीहरूले सुनलाई पिटेर पातलो च्याप्टो पारे अनि त्यसलाई काटेर धागो बनाए। तिनीहरूले यी धागोलाई दक्षतापूर्वक मसिनो सुतीको लुगा अनि निलो, बैजनी र रातो धागोहरूसित मिलाएर काम गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","तिनीहरूले एपोदको निम्ति काँधको टुक्वाहरू बनाए अनि एपोदको दुइवटा छेऊ बाँधिदिए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","एपोद जस्तै तिनीहरूले यो मिहीन सुती लुगा सुनको धागो, निलो बैजनी अनि रातो धागोले बनाए। तिनीहरूले यसलाई परमेश्वरले मोशालाई आज्ञा दिनु भए अनुसार बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ती शिल्पकारहरूले एपोदको सुनको घेराहरूमा गोमेद पनि लगाए। त्यसका मणिहरूमा तिनीहरूले इस्राएलीहरूको छोराको नाउँ कुँदे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","तिनीहरूले यी मणिहरू एपोदको कुमका टुक्राहरूमा जोडिदिए। यी मणिहरूले परमेश्वरलाई इस्राएलीहरूको सम्झना गराउँछन्। तिनीहरूले त्यही गरे जो परमप्रभुले मोशालाई आज्ञा दिनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","तब तिनीहरूले न्यायको थैली बनाए। एपोद झैं यो निपुणता पूर्वक बनाए। यो सुनको धागो, मसिनो मिहीन सुती लुगा, निलो, बैजनी र रातो धागोले बनाइएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","न्यायको छाती-पाता वर्गादार जेब बनाउन पट्टाएर आधा बनाइएको थियो। यो एक बित्ता लामो अनि एक बित्ता चौढाको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","त्यसपछि कर्मीहरूले न्यायको छाती-पातामाथि सुन्दर रत्नहरूको चार लहर गरी मणि लगाए। पहिलो लहरमा माणिक, पुष्पराज र पन्ना थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","दोस्रो लहरमा नीर लाल हीरा थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","तेस्रो लहरमा धमकान्त, सूर्यकान्त र र्मतिस थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","अनि चौथोमा लहर पिरोज, गोमेद र स्फटिकको थियो। यी मणिहरू सुन कुँदिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","न्यायको छाती-पाता भित्र बाह्रबटा रत्नहरू थिए। त्यहाँ एउटा रत्न इस्राएलीको प्रत्येक वंशका निम्ति थियो। प्रत्येक इस्राएलीको नाउँ एउटा रत्नमाथि खोपिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","न्यायको छाती-पाताको निम्ति कर्मीहरूले शुद्ध सुनका दुइवटा साङ्गली बनाए। ती साँङ्गलीहरू डोरी झैं बटारिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","तिनीहरूले सुनको दुइवटा मुन्द्रीहरू बनाए न्यायको थैली दुइ कुनामा अड्काए। तिनीहरूले सुनको दुइवटा घेराहरू (कुमामाथि एपोदको लागि टुक्राहरू) बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","तिनीहरूले थैलीको कुनाहरूमा सुनको मुन्द्रीहरूबाट साँङ्गली हाले। ");
INSERT INTO npi2010_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","तिनीहरूले सुनको साँङ्गलीको अर्को पट्टिको अन्त कुमको जोडेको घेरा सुनमा लगाए। तिनीहरूले यो एपोदको अघिल्लो भागमा बाँधे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","तिनीहरूले न्यायको छाती-पातामा अन्य दुइ कुनामा अरू दुइवटा सुनको मुन्द्रीहरू जोडे। यो एपोदको छेउमा न्यायको छाती-पाताको किनारा भित्रपट्टि थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","तिनीहरूले सुनका दुइवटा मुन्द्रीहरू एपोदको काँधको टुक्रामा लगाए। यो मुन्द्रीहरू गाँसिने ठाउँको छेउमा पेटीको अलिकतिमाथि थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","त्यसपछि तिनीहरूले न्याय थैलीमाथिको मुन्द्रीहरूदेखि एपोदमाथिको मुन्द्रीहरू बाँध्न निलो डोरी प्रयोग गरे। यसप्रकारले न्याय थैली एपोदसित बलियोसंग बाँधन् सकिन्थ्यो। तिनीहरूले प्रत्येक चीज परमप्रभुले मोशालाई दिनुभएको आज्ञा अनुसार नै गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","त्यसपछि तिनीहरूले एपोदको निम्ति लबेदा बनाए। निपुण शिल्पकारले बुनेको निलो लुगाबाट तिनीहरूले यो लबेदा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","लबेदाको बीचमा तिनीहरूले एउटा दुलो पारे अनि त्यस दुलोको वरिपरि एउटा लुगाको टुक्रा लगाएर सिलाए जसले गर्दा त्यो दुलोको छेऊ नच्यातियोस्। ");
INSERT INTO npi2010_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","तिनीहरूले मसिनो गरी बाटेको सुतीको लुगा अनि निलो, बैजनी अनि राता धागाहरू प्रयोग गरेर सबै लुगाको फेरा वरिपरि दारिमहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","फेरि तिनीहरूले शुद्ध सुनका घण्टीहरू बनाए अनि तिनीहरूले ती घण्टीहरूलाई लुगाको फेरोमा दारिमहरूको बीचमा झुण्डाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","परमप्रभुले मोशालाई दिनु भएको आज्ञा अनुसार नै तिनीहरूले घण्टीहरू अनि दारिमहरू एकपछि अर्को गर्दे पोशाकको फेरोमा वरिपरि झुण्डाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","निपुण शिल्पकारहरूले हारून र तिनका छोराहरूको निम्ति कमेजहरू बुने। यी कमेजहरू मसिनो सुती कपडाबाट बनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ती शिल्पीहरूले मसिनो सुती लुगाले फेटाहरू पनि बनाए। टोपी अनि भित्री लुगाहरू पनि तिनीहरूले मिहीन सुती लुगाबाट बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","जस्तो मोशालाई परमप्रभुले आज्ञा दिनु भएको थियो, तिनीहरूले मसिनो सुतीको लुगा, निलो, बैजनी अनि रातो कातेको धागो लगाएर बुट्टा भरेको पेटी बनाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","तब तिनीहरूले शुद्ध सुनबाट पवित्र मुकुटमा लगाउने पातो बनाए त्यस पातोमाथि यी शब्दहरू खोपे: परमप्रभुको निम्ति पवित्र। ");
INSERT INTO npi2010_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","तिनीहरूले पातोलाई निलो डोरीले बाँधे, तब तिनीहरूले निलो डोरीले फेटामा बाँधे परमप्रभुले मोशालाई आज्ञा दिए जस्तै गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","परमप्रभुले आज्ञाहरू दिनु भए अनुसार नै इस्राएलीहरूले पवित्र पाल, अर्थात् भेट हुने पाल निर्माण समाप्त गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","तब तिनीहरूले समाप्त भएका सबै कुराहरू मोशाकहाँ ल्याए जस्तै पवित्र पाल अनि पालहरू भित्रको सबै चीजहरू अंकुसेहरू, बारहरू, फल्याकहरू र आधार खाम्बाहरू। तिनीहरूले मोशालाई पाल छोप्न रातो रङ्गाले रङ्गाएको भेडाको छालाले बनाएको छत देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","तिनीहरूले मोशालाई बाख्राको सुकेको रातो छालाले बनिएको पाल छोप्ने सील छालाबाट बनाइएको पर्दा देखाए। अनि तिनीहरूले अति पवित्र स्थानको प्रवेशद्वार ढाक्ने पर्दा पनि मोशालाई देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","तिनीहरूले मोशालाई करारको सन्दूक देखाए। तिनीहरूले तिनलाई सन्दूक बोक्ने डण्डाहरू, सन्दूकको कृपा-आसान पनि देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","तिनीहरूले उनलाई टेबल अनि यसको सबै भाँडा बर्तनहरू र विशेष रोटी पनि देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","तिनीहरूले मोशालाई शुद्ध सुनले बनिएको सामदान दियोहरू, सामदानको निम्ति प्रयोग गरिने सबै सामानहरू अनि बत्तीहरू बाल्नको निम्ति तेल देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","तिनीहरूले मोशालाई सुनको वेदी, अभिषेक गर्ने तेल, सुगन्धित धूप पालमा जाने द्वार र ढाक्ने पर्दा पनि देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","तिनीहरूले उनलाई काँसाको वेदी, काँसाको कोरेसो अनि (वेदी बोक्न प्रयोग हुने) डण्डाहरू देखाए। तिनीहरूले उनलाई वेदीमा प्रयोग गरिने प्रत्येक चीजहरू देखाए तिनीहरूले उसलाई हात खुट्टा धुने कचौरा अनि यसको आधार देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","तिनीहरूले मोशालाई आँगनको निम्ति पर्दाहरू, यसको खम्बाहरू, खम्बाको आधारहरू, आँगनको प्रवेशद्वारका निम्ति पर्दा र डोरीहरू, पाल-कीलाहरू अनि पवित्र स्थान जुन भेट हुने पाल हो त्यहाँ चाहिने सबै चीजहरू देखाए। ");
INSERT INTO npi2010_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","त्यस पवित्र क्षेत्रमा सेवा गर्ने पूजाहारीहरूका निम्ति जुन तिनीहरूले बुनेर बनाएका पोशाकहरू थिए ती मोशालाई देखाए। तिनीहरूले हरून उसका छोरीहरूका निम्ति बनाइएका विशेष पोशाकहरू पनि मोशालाई देखाए। ती लुगाहरू तिनीहरूले पूजाहारी भई सेवा गर्दा लाउनु पर्दथ्यो। ");
INSERT INTO npi2010_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","इस्राएली मानिसहरूले प्रत्येक चीज नै परमप्रभुले मोशालाई दिनुभएको आज्ञा अनुसार गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","जब मोशाले प्रत्येक चीजहरू परमप्रभुले आज्ञा गरे अनुसार मानिसहरूले बनाएको देखे, उनले तिनीहरूलाई आशीर्वाद दिए। ");
INSERT INTO npi2010_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","तब परमप्रभु मोशालाई भन्नु हुन्छ, ");
INSERT INTO npi2010_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“पवित्र पाललाई जुन भेट हुने पाल पनि भनिन्छ पहिलो महीनाको पहिलो दिन स्थापना गरिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","पवित्र पालभित्र करारको सन्दूक राखेर त्यसलाई पर्दाले ढाकिदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","त्यसपछि टेबल ल्याऊ र त्यसमाथि राखिनु पर्ने प्रत्येक चीज राख। सामदानलाई पालभित्र ल्याऊ अनि त्यसमा दियोहरू जलाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","धूप चढाउनलाई सुनको वेदीको पालभित्र राख। वेदीलाई करारको सन्दूक अघि राख। तब पवित्र पालको प्रवेशद्वारमा पर्दा लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“तब होम बलिको लागि पवित्र पालको प्रवेशद्वारमा जसलाई भेट हुने पाल पनि भनिन्छ वेदी राख। ");
INSERT INTO npi2010_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","भेट हुने पाल र वेदीको बीचमा बाटा राख। त्यस बाटामा पानी हाल। ");
INSERT INTO npi2010_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","आँगनको वरिपरि पर्दाको पर्खाल लगाऊ। तब आँगनको प्रवेश द्वारको अघि पर्दा लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“अभिषेक गर्ने तेल लिएर पाल तथा त्यसमा भएका प्रत्येक चीजलाई अभिषेक गर। यदि तिमीले ती सबै चीजमा अभिषेक तेलले अभिषेक गरेर तिनीहरू सबैलाई पवित्र पार्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","होमबलिको वेदीमाथि अनि वेदीको निम्ति प्रयोग गरिने सबै चीजहरूमा तेल छर्क। यसले ती सबै चीजहरूलाई पवित्र अनि वेदी अति पवित्र बनाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","बाटा र त्यस मुनिको आधार पवित्र पार्न तिनीहरूमाथि अभिषेक गर। ");
INSERT INTO npi2010_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“हारून र तिनका छोराहरूलाई भेट हुने पालको प्रवेश द्वारमा ल्याएर पानीले नुहाउन लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","त्यसपछि हारूनलाई विशेष लुगा लगाई पवित्र पार्न तेलले अभिषेक गर। त्यसपछि उसले पूजाहारी भई मेरो सेवा गर्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","त्यसपछि उसका छोराहरूलाई लुगा लगई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","छोराहरूलाई पनि बुबालाई गरेकै प्रकारले अभिषेक गरिदेऊ। तब तिनीहरूले पनि पूजाहारी भई मेरो सेवा गर्न सक्छन्। जब तिमी तिनीहरूलाई अभिषेक गर्छौ तब तिनीहरू पूजाहारी हुन्छन्। भविष्यमा पनि त्यो परिवार पूजाहारी नै भइरहनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","परमप्रभुले आज्ञा गर्नु भए अनुसार नै मोशाले प्रत्येक चीज गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","त्यसकारण पवित्र पाल ठीक समयमा स्थापन गरियो। इस्राएलीहरूले मिश्र छोडेको यो दोस्रो वर्षको पहिलो महीनाको पहिलो दिन थियो। ");
INSERT INTO npi2010_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मोशाले पवित्र पाल स्थापित गरे। तिनले पहिले आधारहरू राखे अनि त्यसपछि आधारहरूमाथि फल्याकहरू राखे। तब उसले बार र तक्ताहरू भित्र लगाए अनि खम्बाहरू ठडाए। ");
INSERT INTO npi2010_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","तब मोशाले पवित्र पालमाथि कृपा-आसान राखे परमप्रभुले दिनु भएको आज्ञा अनुसार तिनले यसो गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","मोशाले करार पत्र पवित्र सन्दूकभित्र राखे। मोशाले सन्दूकमाथि डण्डाहरू राखे अनि ढकनीले ढाके। ");
INSERT INTO npi2010_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","तब मोशाले पवित्र सन्दूक पवित्र पालभित्र राखे अनि यसको अघि पर्दा झुण्डाइदिए। यस प्रकारले पर्दा पछाडी करारको सन्दूकलाई तिनले सुरक्षित पारे। तिनले परमप्रभुले दिनु भएको निर्देशन अनुसार गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","तब मोशाले भेट हुने पालमा टेबल राखे। यो तिनले पवित्र सन्दूकको उत्तर तिर राखे। यो तिनले पवित्र पालभित्र पर्दाको अघाडी राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","तब उनले टेबलमाथि परमप्रभुको सामने रोटी राखे। तिनले परमप्रभुले तिनलाई दिनु भएको आज्ञा अनुसार यसो गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","उनले सामदान भेट हुने पालको दक्षिण भागमा टेबलको अघाडी राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","उनले परमप्रभुको अघि दियोहरू बाले। तिनले यी सब कामहरू परमप्रभुले तिनलाई दिनु भएको आज्ञा अनुसार गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","तब तिनले सुनको वेदी भेट हुने पाल भित्र राखे। वेदी पर्दाको अघिललातिर राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","तब तिनले वेदीमा सुगन्धित धूप बाले। उनले यो परमप्रभुले दिनु भएको आज्ञा अनुसार गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","तब मोशाले पवित्र पालको प्रवेश द्वारमा पर्दा लगाए। ");
INSERT INTO npi2010_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","मोशाले होमबलिहरूका निम्ति वेदीलाई पवित्र पालको, (जसलाई भेट हुने पाल पनि भनिन्छ) प्रवेशद्वारमा राखे। उनले वेदीमाथि होमबलि र अन्नबलिहरू चढाए। उनले यो सबै परमप्रभुले आज्ञा गरे अनुसार नै गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","तब मोशाले बाटा भेट हुने पाल र वेदीको माझमा राखे। तिनले बाटामा हात धुनलाई पानी पनि राखे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","मोशा, हारून र तिनका छोराहरूले आफ्नो हात-खुट्टा धुन यो बाटामा प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","तिनीहरू भेट हुने पालमा पस्दा प्रत्येक पल्ट आफ्नो हात-खुट्टा धोए अनि त्यसरी नै तिनीहरू वेदी सामने जाँदा पनि हात-खुट्टा धोए। तिनीहरूले परमप्रभुले आज्ञा गरे अनुसार यसो गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","मोशाले पवित्र पालको आँगन वरिपरि पर्दा लगाए। तिनले आँगनमा वेदी राखे। अनि आँगनको प्रवेशद्वारमा पर्दा लगाए। मोशाले यी सबै काम समाप्त गरे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","भेट हुने पाललाई बादलले ढाक्यो र परमप्रभुको महिमाले पवित्र पाल परिपूर्ण भयो। ");
INSERT INTO npi2010_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","बादल त्यहाँ बसेकोले र पवित्र पालभित्र परमप्रभुको महिमा भरिएकोले मोशा भेट हुने पालभित्र जान सकेनन्। ");
INSERT INTO npi2010_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","जब बादल पवित्र पालबाटमाथि उठ्थ्यो इस्राएलीहरूले आफ्नो यात्रा शुरू गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","तर जब बादल पवित्र पालबाटमाथि उठ्दैनथ्यो भने मानिसहरू हिंड्ने चेष्टा गर्दैनथे। तिनीहरू बादलमाथि नउठुञ्जेलसम्म एकै ठाउँमा बसिरहन्थे। ");
INSERT INTO npi2010_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","यसर्थ दिउँसो पवित्र पालमाथि परमप्रभुको बादल रहन्थ्यो अनि राती बादलमा आगो देखिन्थ्यो। यसर्थ जब यात्रा गर्थे समस्त इस्राएलीहरू बादल देख्न सक्थे। ");
INSERT INTO npi2010_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","परमप्रभुले मोशालाई भेट हुने पालबाट भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएली मानिसहरूलाई भन जब तिनीहरू मध्ये कुनै मानिसले परमप्रभुको निम्ति बलि चढाउँछ भने, त्यो तिनीहरूको आफ्नो गाई-गोरू तथा भेडा-बाख्राहरूको बगालबाट हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“यदि उसले गोरू होमबलि चढाउँछ भने, त्यो निष्खोट बाछो हुनुपर्छ। उसले बाछो भेट हुने पालको ढोकामा चढाउनु पर्छ जसले गर्दा त्यो परमप्रभुलाई ग्रहण योग्य हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","उसले आफ्नो पापको प्रायश्चितको निम्ति मारिन लागेको पशुमाथि आफ्नो हात राख्नु पर्छ। अनि परमप्रभुले त्यस व्यक्तिलाई शुद्ध गराउन होमबलि ग्रहण गर्नुहुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“पछि त्यो बाछो परमप्रभुको सामुन्ने मारोस् तब हारूनका पूजाहारी छोराहरूले भेट हुने पालको ढोका नजिक भएको वेदी वरिपरि त्यसको रगत छर्किउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","तब त्यो बाछो अथवा पशुको छाला काढेर त्यसलाई टुक्रा-टुक्रा पारियोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","तब पूजाहारी हारूनका छोराहरूले वेदीमा दाउराहरू मिलाएर आगो सल्काउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","हारूनका छोराहरू अर्थात पूजाहारीहरूले वेदीमा बलेको आगोमाथि बाछो अथवा पाठोको टाउका टुक्राहरूको बोसो वेदीको आगोको दाउरा माथि मिलाएर राखुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","त्यसपछि पूजाहारीले त्यस पशुको खुट्टाहरू र त्यसको भित्रि भागहरू पानीले पखालोस् र ती सबै पूजाहारीले आगोद्वारा वेदीमा जलाओस् यो आगोद्वारा परमप्रभुलाई मन पर्ने सुगन्धित होमबलि समर्पण गरिएको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“यदि उसको भेटी पशु हो भने, पाठो अथवा थुमा निष्खोट हुनुपर्छ। जब बलिदानहरू चढाउँदा उसले पाठो अथवा बोका चढाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","उसले वेदीको उत्तरपट्टि परमप्रभुको सामुन्ने त्यो काटेर मारोस् अनि पूजाहारी हारूनका छोराहरूले त्यसको रगत वेदीको वरिपरि सबैतिर छर्कून्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","तब त्यो बलि टुक्रा-टुक्रा पारेर काटोस् आन्द्रा-भुँडी र अघि पछिका खुट्टाहरू पखालोस् अनि वेदीको दाउराको आगोमा पूजाहारीहरूले ती टुक्राहरू, बोसो र टाउको जलाओस। ");
INSERT INTO npi2010_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","त्यसपछि उसले आन्द्रा-भुँडी र अघि पछिका खुट्टाहरू पानीले पखालोस् र पूजाहारीहरूले ती सबै आगोमा जलाएर भष्म गरोस्। त्यही बलि परमप्रभुको निम्ति सुगन्धित होमबलि हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“यदि ऊ चरा बलिको रूपमा चढाउँछ भने, त्यो होमबलि ढुकुर अथवा परेवा हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पूजाहारीले त्यो बलि वेदीमा ल्याएर टाउको निमोठेर चुँडाओस् र वेदीमा जलाओस्, अनि त्यस परेवाको रगत वेदी भएको ठाउँमा निकाली देओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","त्यसपछि उसले त्यसको गलामा भएको खाद्य थैली निकालोस् अनि वेदीको पूर्वपट्टि खरानी भएको ठाउँमा फ्याँकोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","त्यसपछि त्यसलाई पूजाहारीले नटुक्राइकन परेवाको बीचबाट चिरोस् अनि पूजाहारीले त्यो बलि वेदीमा राखिएको आगोको दाउरामाथि जलाउन राखोस्। यो पनि परमप्रभुको निम्ति सुगन्धित होमबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“जब कोही मानिस परमप्रभुलाई अन्नबलिको केही बलि चढाउँछ भने त्यो बलि मसिनो पीठोको होस्। त्यसमा तेल खन्याएर पूजाहारीले सुगन्धित धूप हालोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","तब उसले त्यो बलि हारूनका छोराहरूकहाँ ल्याउनु पर्छ अनि पूजाहारीले एक मुट्ठी मसिनो अन्नको पीठो, तेल अनि त्यसबाट धूप झिक्नु पर्छ अनि वेदीमा परमप्रभुलाई चढाउने सम्झना भेटीको रूपमा यसलाई चढाउनु पर्छ। यो आगोद्वारा चढाउने भेटी हो अनि यसको वासनाले परमप्रभुलाई प्रसन्न पार्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","बाँकी रहेको अन्नबलि परमप्रभुको अत्यन्तै पवित्र उपहार स्वरूप हारूनका छोराहरूका निम्ति रहोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“यदि तिमी चुलामा पकाएको अन्नबलि चढाउँछौ भने, तेलमा मुछेको अखमिरी मसिनो पिठोको फुलौरा अथवा तेल हालेको अखमिरी रोटी होस्। ");
INSERT INTO npi2010_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","यदि तिम्रो अन्नबलि तावामा पकाएको अन्नबलि भए त्यो तेलमा मुछेको अखमिरी मसिनो पीठोको होस्। ");
INSERT INTO npi2010_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","त्यो मसिनो गरी पिंधेर टुक्राउ अनि त्यसमा तेल खन्याऊ। त्यही अन्नबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","यदि तिमी अन्न भेटील्याउँछौ जो तावामा भूटिएको छ भने यो तेलसित मिसाइएको मसीनो पीठो हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“जब तिमीले यी कुनै अन्नबलिहरूबाट बनाइएको परिकार ल्याउँछौ त्यो पूजाहारीलाई देऊ र त्यो पूजाहारीले वेदीमा चढाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","पूजाहारीले अन्नभेटीको केही भाग छुट्‌याउनुपर्छ अनि यसलाई स्मरणीय भेटीको रूपमा जलाउनुपर्छ, अनि वेदीमा परमप्रभुलाई सुगन्धित भेटीको रूपमा चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्नबलिबाट रहेको भाग हारून र तिनका छोराहरूको निम्ति हुनुपर्छ। परमप्रभुको निम्ति यो आगोद्वारा चढाएको बलि अति पवित्र हो। ");
INSERT INTO npi2010_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“तिमीले खमीर भएको कुनै पनि अन्नबलि परमप्रभुलाई चढाउनु हुँदैन अथवा महबाट बनिएको परमप्रभुको निम्ति उपहार आगोमा जलाउनु हुँदैन। (यहाँ भनिएको मह हुन सक्छ मौरीको नभई फूलहरूको रस हुनसक्छ।) ");
INSERT INTO npi2010_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","तिमीहरू वर्षको पहिलो बालीबाट खमीर र मह चढाउन सक्छौ, तर त्यो बलि भेटीलाई सुगन्धित भेटीबनाउन जलाउनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","तिमीले प्रत्येक अन्नबलिमा न्‌नहालेर ल्याउनुपर्छ। परमेश्वरसित गरेको न्‌नको करार तिम्रो अन्नबलिबाट हराउनु हुदैन। तिमीले आफ्नो बलि न्‌नसँगै ल्याउँनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“यदि तिमीहरू वर्षको अगौटे बालीबाट परमप्रभुलाई भेटी चढाउँछौ भने तिमीहरू पहिले बालीको ताजा अन्नको अघिल्लो भागलाई पिंधेर अन्न पकाएको भेटी बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","तिमीले त्यसमा तेल अनि सुगन्धित धूप लगाउनुपर्छ। यो अन्नबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","पूजाहारीले परमप्रभुको निम्ति सबै धूपसित पिंधेको अन्नबाट तयार गरेको भेटीको केही भाग तेलसित मिसाएर स्मारकको रूपमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“यदि उसको बलि मेलबलिको निम्ति हो भने गाई-गोरू मध्येको हुनुपर्छ। तर पशु चाही निष्खोट होस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","अनि उसले आफ्नो हात त्यस पशुमाथि राखोस् अनि भेट हुने पालको प्रवेशद्वारमा त्यसलाई मारोस् र पूजाहारी हारूनका छोराहरूले वेदीको वरिपरी त्यसको रगत छर्कोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","आगोद्वारा उसले मेलबलिबाट परमप्रभुको निम्ति खाद्य उपहार स्वरूप आन्द्रा भुँडी ढाक्ने बोसो र आन्द्रामाथि हुने सबै बोसो। ");
INSERT INTO npi2010_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","दुइटै मृगौला र त्यस माथिको बोसो र कम्मर छेउको बोसो अनि मांसपेशीमा भएको बोसो अनि कलेजामाथिको गर्मजाल समेत झिकेर चढाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","तब हारूनका छोराहरूले वेदीको आगोमाथि बोसो होमबलिसित यो जलाओस्। आगोद्वारा चढाइएको यो परमप्रभुको निम्ति सुगन्धित बलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“यदि उसको मेलबलि कै भेटी हो भने आफ्ना भेडा अथवा एउटा आफ्ना बाख्राको बगालहरूबाट हो भने त्यो निष्खोट हुनपर्छ चाहे यो पाठो अथवा पाठी होस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","यदि उसले थुमा बलि चढाउँदैछ भने त्यो परमप्रभुअघि ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","तब उसले आफ्नो हात त्यो बलि दिइने पशुको टाउकोमाथि राखोस् र यसलाई भेट हुने पालको प्रवेशद्वारअघि मारीदिओस्। हारूनका पूजाहारी छोराहरूले त्यसको रगत वेदीको वरीपरि सब ठाउँमा छर्किउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","तब परमप्रभुलाई आगोबाट चढाएको मेलबलिबाट उसले मेरूदण्डबाट सम्पूर्ण पूच्छरको बोसो, पशुको भित्र भागहरूलाई छोपेको बोसो निकाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","दुइवटा मृगौला र त्यस माथिको बोसो कम्मर छेउको निकाल्नु पर्छ। छेउको बोसो अनि मृगौलासहित कलेजा छोप्ने मासु निकालोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","तब पूजाहारीले वेदीमाथि भोजन स्वरूप त्यो जलाओस्। यो परमप्रभुको निम्ति भोजन बलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“यदि उसको बलि एउटा बाख्रा हो भने उसले त्यो परमप्रभुको सामुन्ने चढाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","तब उसले आफ्नो हात त्यसको टाउकोमाथि राखोस् अनि भेट हुने पालको अघि त्यसलाई मारीदिओस्। अनि हारूनका छोराहरू पूजाहारीले वेदीको वरीपरि त्यस बलिको रगत छर्किउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","तब उसले उसको आफ्नो बलिबाट परमप्रभुको निम्ति आगोद्वारा चढाओस्, आन्द्रा-भुँडी छोप्ने बोसो र आन्द्रमाथिको सबै बोसो, ");
INSERT INTO npi2010_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","दुइवटा मिगौला अनि त्यस माथिको बोसो, डँढाल्नु माथिको माँसपेशी, कलेजा माथिको उपांग कलेजासितै झिकेर चढाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","अनि पूजाहारीले सबै बोसो परमप्रभुको निम्ति वेदीमाथि मीठो वासनाको रूपमा जलाउँनुपर्छ। यो परमप्रभुको निम्ति अन्न बलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","यो नियम तिमीहरूका सन्तानहरू रहूञ्जेलसम्म सँधै रहिरहनेछ जुनसुकै ठाउँमा तिमीहरू बस्छौ। तिमीहरूले बोसो खानु हुँदैन अथवा रगत पिउनु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएलका मानिसहरूलाई भन: जब एउटा मानिसले नजान्दा पाप गरे अनि परमप्रभुका आज्ञाहरूमा नगर्नु भनेको कुनै काम गर्छ भने, त्यस मानिसले तलका कुराहरू गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“यदि कुनै अभिषिक्त पूजाहारीले ल्याउछ भने पाप गरेर कर्म गर्छ जसले मानिसहरूमाथि दोष लाग्छ उसले एउटा निष्खोट जवान साँढे उसको पाप प्रायश्चितको निम्ति परमप्रभुलाई चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","अनि उसले साँढेलाई परमप्रभुअघि भेटहुने पालको प्रवेशद्वारमा ल्याउनु पर्छ अनि त्यस साँढेको टाउकोमाथि आफ्नो हात राख्नु पर्छ परमप्रभुअघि त्यसलाई मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","त्यसपछि अभिषिक्त भएको पूजाहारीले बलि चढाइएको साँढेको रगत भेट हुने पालमा ल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","त्यसपछि पूजाहारीले आफ्नो ओंला रगतमा चोबोस् र अति-पवित्रस्थानको पर्दाअघि परमप्रभुको सामुन्ने रगत सात पल्ट छर्कोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","त्यसपछि पूजाहारीले धूपवेदीका सींङहरूमा रगतको केही अंश छर्किनु पर्छ जो भेट हुने पालमा परमप्रभुको सामुन्ने हुन्छ, अनि साँढेका रहल रगत भेटहुनेपालको प्रवेश द्वारको होमबलिको वेदीको आधारमा खान्याऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","अनि उसले पाप बलिको साँढेबाट सबै बोसो निकाल्नु पर्छ। उसले भित्री भागहरूको चारैतिर भएका त्यो बोसो अवश्यै निकाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","दुवै मृगौलाहरू अनि तिनीहरूका बोसो अनि मांशपेशीको तल्लो भागमा भएको बोसो र कलेजोलाई ढाक्ने बोसो, उसले यसलाई मिर्गौलाहरू सितै पापबलिको साँढेबाट निकाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","मेलबलिको साँढेबाट निकालिए जस्तै पापबलिको निम्ति चढाइएको साँढेबाट पनि सबै बोसोहरू निकालोस्। त्यसपछि पूजाहारीले त्यसलाई बलि होमबलिको वेदीमा जलाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","तर साँढेको छाला, त्यसको मासु र टाउको, खुट्टा, आन्द्रा-भुँडी, गोबरसमेत, ");
INSERT INTO npi2010_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","अनि रहल सबै पालबाहिर खरानी थुपार्ने एउटा चोखो ठाउँमा ल्याउन पर्छ अनि दाउराको आगोमाथि त्यहाँ जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“यदि समस्त इस्राएली मानिसहरूले नजान्दा नै भूल गर्छन् अनि तिनीहरूलाई थाहा हुँदैन तिनीहरूले परमप्रभुको कुनै आज्ञा पालन गरेनन् भने, तब तिनीहरू दोषी हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","जब तिनीहरूले परमप्रभुको आज्ञा विरूद्ध गरेको पाप चाल पाउँछन्, पापबलिको निम्ति तिनीहरूले बथानबाट एउटा साँढे बलि दिऊन्। त्यो साँढे तिनीहरूले भेट हुने पाल अगाडी ल्याउनपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","अनि समुदायको मुखियाहरूले साँढेको टाउकोमाथि आफ्नो हात राख्नु पर्छ अनि त्यसलाई परमप्रभुकोअघि मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","तब अभिषिक्त भएका पूजाहारीले साँढेको रगतबाट केही लिएर भेट हुने पालमा ल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","अनि पूजाहारीले आफ्नो औंला त्यस रगतमा डुबाएर परमप्रभु अगाडीको पर्दा सामुन्ने सात पल्ट छर्कियोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","अनि केही रगत वेदीको कुनामा राख्नु पर्छ जो भेट हुने पालमा परमप्रभुको अघि छ अनि रहल रगत होमबलिको वेदीमा अगेनोमा खन्याउनु पर्छ जो भेट हुने पालको प्रवेश हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","अनि उसले सबै बोसो बलिबाट निकालेर वेदीमा जलाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","उसले यो पापबलिलाई जसो गर्छ यसलाई पनि त्यसै गर्नुपर्छ, यसरी नै पूजाहारीले इस्राएली मानिसहरूको निम्ति प्रायाश्चित गराउँछन् अनि तिनीहरूको पाप क्षमा हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","पूजाहारीले साँढेलाई पालको बाहिर ल्याउँनुपर्छ अनि यसलाई जलाउनुपर्छ जस्तो उसले पहिलो साँढेलाई गरेको थियो। सम्पूर्ण समुदायकालागि पापबलि हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“यदि कुनै शासकले अन्जानमा परमप्रभु उसको परमेश्वरका आदेशहरू उल्लंघन गर्छ भेने दोषी हुन्छ, ");
INSERT INTO npi2010_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","अनि पछि आफ्नो दोष पत्ता लगाउँछ, उसले आफ्नो पशुहरूको बथानबाट उपहार स्वरूप भूत्लै भूत्ला भएको निष्खोट बोका ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","तब उसले आफ्नो हात त्यस बोकाको टाउकोमाथि राखोस् अनि होमबलि दिइने ठाउँमा त्यसलाई परमप्रभुकोअघि मारोस् यो शुद्धिकरणको बलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","त्यसपछि पूजाहारीले त्यो पापबलिको केही रगत आफ्नो औंलामा लियोस् र होमबलिको वेदीको कुनामा राखोस् अनि होमबलिको वेदीको आधारमा रगत खन्याओस् ");
INSERT INTO npi2010_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","उसले पाठोको सबै बोसो बलिदान वेदीमा त्यसरी नै जलाउनु पर्छ जसरी मेलबलिको बोसो उसले जलाएको थियो। यस प्रकारले, उसले गरेको पापको निम्ति पूजाहारीले प्रायश्चित गर्नेछ अनि परमेश्वरले उसलाई क्षमा दिनुहुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“यदि समुदायको कुनै मानिसले नजानेर पाप गरे अथवा परमप्रभुले दिनु भएको निषेधाज्ञाको विरोधमा काम गरे त्यो दोषी हुनेछ ");
INSERT INTO npi2010_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","अथवा यदि उसले गरेको पाप आफूले थाहा पाए तब उसले बगालबाट भुत्लै भुत्लो भएको एउटा बाख्राको निष्खोट पाठी ल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","तब आफ्नो पाप बलिको निम्ति उसले त्यस पाठीको टाउकोमा हात राखोस् अनि होमबलि हुने ठाउँमा मारोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","तब पूजाहारीले केही रगत औंलाले लेओस् र होमबलिको वेदीको कुनामा लगाओस् र अरू सबै रगत वेदीको आधारमा खन्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","अनि मेलबलिमा गरिएको बलि झैं उसले त्यस बलिबाट सबै बोसो निकालोस्। पूजाहारीले परमप्रभुको निम्ति मिठो बास्ना दिनकालागि त्यो वेदीमा जलाओस्। यसरी पूजाहारीले त्यस मानिसलाई शुद्ध बनाउँछ अनि त्यसलाई क्षमा गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“यदि कसैले उसको पापबलिको निम्ति भेडा ल्याउँछ भने, तब उसले निष्खोट भेडाको पाठो ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","उसले पापबलिको टाउकोमा आफ्नो हात राख्नु पर्छ अनि यसलाई त्यस ठाउँमा मार्नु पर्छ जहाँ होमबलिकालागि बलिदान गरिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","तब पापबलिबाट, पूजाहारीले आफ्नो औंलामा केही रगत लिनु पर्छ अनि होमबलिको वेदीको सिङहरूमा यसलाई राख्नु पर्छ अनि रहल रगतलाई वेदीको अगेनोमा खन्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","तब उसले मेलबलि सम्पन्न गरिको थियो, पूजाहारीले पाठोबाट निकाल्नु पर्छ अनि परमप्रभुका लागि भेटीको रूपमा यसलाई जलाउँछ। यसरी पूजाहारीद्वारा त्यस मानिसको प्रायश्चित उसको पापको लागि सम्पन्न हुन्छ अनि त्यो मानिस पाप मुक्त हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“यदि कसैले यस्तो प्रकारले पाप गरे जसमा त्यो मानिस आफ्नै आँखाले प्रत्यक्ष देखेको अथवा कानले सुनेको कुरोमा साक्षी भएर पनि भन्दैन भने ऊ त्यस कामको निम्ति पापी हो, अनि उसले त्यस पापको निम्ति सजाय भोग्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“अथवा कोही मानिस अशुद्ध चीज छुन्छ भने जंगली अथवा पाल्तू पशु अथवा उडने प्राणीको मृत देह छुन्छ, तर कुनै कारणवश त्यो उसले बिर्सन्छ भने त्यस कामको निम्ति ऊ दोषी अनि अशुद्ध बनिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“एक जना मानिसले मानिएको अशुद्ध अथवा यस्तो कुनै चीज छुन्छ जसले उसलाई अशुद्ध बनाउँछ तर उसले थाहा पाउँदैन, तर जब त्यस मानिसले यस विषयमा थाहा पाउँछ तब उ दोषी हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“अथवा एकजना मानिसले केही राम्रो अथवा नराम्रो काम गर्ने प्रतिज्ञा गर्छ। उसले विचार अनि आफ्नो प्रतिज्ञा बिर्सन्छ। तर जब पछि उसले आफ्नो प्रतिज्ञाको सम्झना गर्छ, तब उसलाई दोषी ठहराइनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","जब ऊ त्यस्तो कुनै कुरामा दोषी ठहरिन्छ भने, उसले कसरी पाप गर्यो त्यो स्वीकार गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","अनि उसको पाप प्रायश्चितको निम्ति, उसले एउटा जवान भेडा अथवा बाख्राको पाठी उसको बथानबाट एउटा दोषबलि जस्तै परमप्रभु कहाँ ल्याउनु पर्छ। यस प्रकारले पूजाहारीले त्यो मानिसको पापबाट मुक्त गराउनको लागि प्रायश्चित कार्य गर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“यदि उसले आफ्नो दोषबलि चढाउन भेडा अथवा बाख्राको पाठीको व्यवस्था गर्न सक्तैन भने, उसले परमप्रभुलाई दोषबलि चढाउनलाई अथवा पापबाट मुक्त हुन र अर्को होमबलिको निम्ति एक जोडी परेवा अथवा ढुकुर ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","उसले त्यो ढुकुर अथवा परेवाको जोडी पूजाहारीकहाँ ल्याउनुपर्छ र पूजाहारीले एउटा चाँहि पहिले पापबलिको निम्ति चढाओस्। उसले त्यसको घाँटी अँठ्ठाएर टाउको निमोठोस तर त्यसलाई चुँढाई नहालोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","तब उसले पापबलिको केही रगत शुद्धताको निम्ति वेदीको पाटामा छर्कियोस अनि बाँकी रगत वेदीको आधारमा खँन्याई दियोस्। यो पापबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","त्यसपछि पूजाहारीले अर्को चाँहि ढुकुर परेवा नियमानुसार होमबलि चढाओस्। यस्तो प्रकारले पूजाहारीले त्यस पाप गर्ने मानिसलाई उसको पापबाट शुद्ध गराओस् अनि त्यो मानिसले क्षमा पाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“यदि कुनै मानिसले दुईवटा ढुकुरहरू अथवा दुईवटा परेवाहरू किन्न सक्दैन भने। भने तब उसले आफ्नो पापबाट मुक्ति पाउनलाई आठ बटुको मिहिन पीठो चढाउनु पर्छ। उसले पीठोसित तेल मिसाउनु हुदैन अनि कुनै सुगन्धित धूप पनि त्यसमा मिसाउनु हुँदैन किनभने त्यो भेटी पापबलि को हुनको निम्ति हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","उसले त्यो पिठो पूजाहारीकहाँ ल्याओस् अनि पूजाहारीले त्यसबाट सम्झना स्वरूप एक मुठ्ठी पीठो निकालेर परमप्रभुको निम्ति अग्निहोममाथि वेदीमा जलाओस्। यो पापबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","यस प्रकार पूजाहारीले त्यस व्यक्तिलाई उसले गरेको पापबाट क्षमा गराउनेछन्। बाँकी रहेको अन्न चाँहि पूजाहारीको निम्ति अन्नबलि जस्तै हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","तब परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“जब एकजना मानिसले परमप्रभुको पवित्र चीजहरू प्रति नजानेर भूल काम गर्छ, उसले आफ्नो पशुहरूको बथानबाट एउटा निष्खोट भेडा ल्याउनुपर्छ। भेडाको मोल आधिकारिक नाप अनुसार उसको ");
INSERT INTO npi2010_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","पवित्र चीजहरूसित गरेको पापको निम्ति उसले अपराध बीस प्रतिशत जोडेर फिर्ता दिनुपर्छ। अनि दोषबलिको भेडाद्वारा चढाएकोमा पूजाहारीले उसको पापको निम्ति प्रायश्चित गर्नेछ अनि उसलाई पाप क्षमा दिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“जब कुनै व्यक्तिले परमप्रभुले नगर्नु भनेको कामगर्छ तर उसलाई त्यो थाहा हुँदैन, तब पनि त्यो मानिस दोषी हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","तब उसले गरेको पापको ओजन बराबरको मूल्यमा एउटा निष्खोट भेडा पूजाहारीकहाँ दोष बलिको निम्ति ल्याउनुपर्छ। जुन पाप उसले नजानी गरेको थियो पूजाहारीले त्यसले गरेको पापबाट उसलाई क्षमा गराउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","यो एउटा दोषबलि हो, किनभने त्यो मानिस परमप्रभुअघि दोषी भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“जब एकजना मानिस परमप्रभुको विररूद्धमा पाप र विश्वासघात गर्छ अनि आफ्नो छिमेकीलाई धोका दिएर पापकर्म गर्यो कसैले राख्न दिएको कुरा बन्धकमा राखेरको कुरा वा चोरेको कुरा राख्छ अनि छिमेकीसँग झूट बोल्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","अनि यसरी ठगेको अथवा धोका दिएको अथवा अपहरण गरेकोमा आफू निर्दोष हुन झूटो स्वीकार गर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","यदि एउटा व्यक्तिले यसरी यी कुराहरू गर्छ तब त्यो मानिस पापको दोषी हुनेछ। त्यो मानिसले सबै कुराहरू ल्याउनु पर्नेछ जे जति उसले चोरीको थियो, अथवा जे जति उसले ठगेर लगेको छ, अथवा जे जति अर्को मानिसले उसलाई उसको निम्ति समाल्न दिएका थिए अथवा जे जति उसले पायो अनि यस विषयमा झूट बोल्यो। ");
INSERT INTO npi2010_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","जे जति उसले झूट्टा प्रतिज्ञा बनाउँछ। उसले पूरा मोल तिर्नु पर्छ। त्यसले यी सबै थोकहरूमा पाँचौं हिस्सा थपेर फर्काई दिनु पर्नेछ। उसले यो त्यस दिन दिनु पर्छ जहिले ऊ दोषबलि ल्याउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","उसले आफूले गरेको दोषको बराबर परिमाणमा दोषबलि स्वरूप पशुहरूको बथानबाट एउटा निष्खोट भेडा परमप्रभुको निम्ति पूजाहारीकहाँ ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","अनि पूजाहारीले परमप्रभुअघि उसलाई शुद्ध पारिदिनेछन् अनि तिनी कुनै पनि काम गर्दा जो दोषी हुन्छ यस्तो दोषबाट उसलाई मुक्त गर्नेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“यी कुराहरू हारून अनि तिनका छोराहरूलाई आज्ञा दे यो होमबलिको निम्ति विधि हो। होमबलिको बलि वेदीको चुलामा बिहान नहुञ्जेलसम्म रातभरि रहोस् अनि वेदीमा आगो बलिरहोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","पूजाहारीले आफ्नो पोशाक सूती कपडाको लगाओस्, सूतीको सुरूवाल पनि उसले भित्री पट्टि लगाओस् र होमबलिको भेटी वेदीमा जलाउँदा निस्केको खरानी हटाओस् र त्यसलाई वेदीको पछिल्तिर राखोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","पूजाहारीले लगाएको वस्र खोलुन् अनि अर्को लुगा लगाएर खरानीलाई पाल बाहिर पवित्र ठाउँमा लैजाउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","आगो वेदीमाथि लगातार बलिरहन दिनु पर्छ। आगोलाई निभ्न दिनु हुँदैन। पूजाहारीले प्रत्येक बिहान वेदीमा दाउरा हाल्नु पर्छ अनि होमबलि त्यसमाथि मिलाएर राख्नु पर्छ। अनि मैत्रीबलिको बोसो वेदीमा निरन्तर जलिरहनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीमा आगो निरन्तर बलिरहोस्, त्यो निभ्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“अन्नबलिको निम्ति नियम यस्तो छ हारूनका छोराहरूले अन्नबलि वेदीमाथि परमप्रभुको सामुन्ने ल्याउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","पूजाहरीले परमप्रभुलाई स्मारक भेटीको रूपमा चढाउन ल्याएको पीठो र तेलबाट एक मूठ्ठी पीठो सुगन्धित धूपसमेत लिनु पर्छ अनि वेदीमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“रहेको पीठो र तेल चाँहि हारून र उसका छोराहरूले खानु पर्छ। तिनीहरू त्यो पवित्र ठाउँमा खमीर नमिसाई खानु पर्छ। तिनीहरूले त्यो भेट हुने पालको आँगनमा खानुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","त्यो खमीरसित पकाउनु हुँदैन। मैले मलाई दिएको भेटीहरू तिनीहरूको भागको रूपमा तिनीहरूलाई दिएको नै छु। त्यो पाप बलि अनि दोषबलि जस्तै शुद्ध छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","परमप्रभुको अन्नबलिबाट हारूनको पुरूष सन्तानहरू मध्ये कसैले खानु सक्छ। यो नियम तिम्रो सन्तानहरूको निम्ति सँधैको लागि हो। यी भेटीहरू छोएर नै कोही पवित्र हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“यो त्यो बलि हो जसलाई हारून र उसका छोराहरूले परमप्रभुको निम्ति त्यस दिन चढाउनुपर्छ जहिले हारून प्रधान पूजाहारीका रूपमा अभिषिक्त हुन्छन्। नियमित आठ बटुको मिहिन पीठो, यसको आधा विहान चढाउनु पर्छ अनि आधा साँझमा। ");
INSERT INTO npi2010_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","तेल सित तावामा राम्ररी भूटेर बनाओस् यो राम्ररी तेलमा मिसाएर परमप्रभुको निम्ति टुक्रा-टुक्रा पारेर मिठो सुगन्धित अन्नबलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“अनि हारूनका छोरा जो पूजाहारीको रूपमा अभिषिक्त हुन्छन्, तिनले अन्नबलि तयार पार्नुपर्छ। यो सँधैको लागि परमप्रभुको स्थायी नियम हो। यसलाई पूर्ण रूपले जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","पूजाहरीले चढाएको प्रत्येक अन्नबलि सम्पूर्ण रूपले जलाउनु पर्छ यो खानु हुँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून र तिनका छोराहरूलाई भन, यो पाप बलिको नियम हो, जुन ठाउँमा होमबलिको निम्ति परमप्रभुको अघि मारिन्छ, त्यसै ठाउँमा पाप बलिको निम्ति पनि मारिनु पर्छ। यो अत्यन्तै पवित्र हो। ");
INSERT INTO npi2010_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","जुन पूजाहारीले पापबलि चढाउँछ उसले यो खानुपर्छ। यो भेट हुने पालको आँगन पवित्र स्थानमा खानुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","जसले यो पापबलिको मासु छुन्छ, त्यो पवित्र हुन्छ। “यदि यसको रगत लुगाहरूमा कतै छर्कियो भने त्यो पवित्र ठाउँमा धुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","अनि प्रत्येक माटोको भाँडा जसमा पापबलिको मासु पकाइन्छ, त्यो फुटाउनुपर्छ। अनि यदि पाप बलिको मासु धातुले बनिएको भाँडामा पकाएको त्यो माझेर पानीले पखाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“पूजाहारीहरूमा भएका प्रत्येक पुरूषले यो खान सक्छन् र यो अत्यन्त पवित्र हो। ");
INSERT INTO npi2010_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","तर पाप बलिको रगत यदि मानिसहरूलाई पवित्र पार्न भेट हुने पालमा ल्याएको भए त्यो खानु हुँदैन। यो आगोमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“दोषबलिको नियम यही हो। यो अत्यन्तै पवित्र छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","जहाँ सबै होमबलि मारिन्छ त्यही ठाउँमा दोषबलिको पनि त्यही गरियोस्। अनि वेदीको वरीपरि सबैतिर त्यसको रगत छर्कोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“त्यसको सबै बोसो, बोसे पुच्छर, आन्द्रा भुँडी छोप्ने बोसो, ");
INSERT INTO npi2010_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","दुवै मृगौला र त्यसमाथि भएको बोसो, मिगौलासमेत मांशपेशीको तल्लो भागको बोसो अनि कलेजालाई ढाक्ने मासु मृगैला सितै निकाल्नु पर्छ र चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पूजाहारीले ती भागहरूलाई परमप्रभुको निम्ति कै वेदीमा दोषबलिको रूपमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“अनि पूजाहारीको घरका प्रत्येक पुरूष मानिसले त्यो खान सक्छ। यो एकदमै पवित्र हो दोषबलि पवित्र ठाउँमा खानुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","दोषबलि पापबलि जस्तै हो। यी दुवैको निम्ति नियमहरू एउटै छन्। बलि पूजाहरीको हो जसले ऊसित प्रायश्चित गर्छ। अनि यो उसको खाद्य हो। ");
INSERT INTO npi2010_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","जब पूजाहारीले होमबलि चढाउनु हुन्छ, त्यसको छाला पूजाहारी कै हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","अनि प्रत्येक अन्नबलि जो चुलामा पकाएर अथवा तावामा अथवा ताप्केमा पकाएको जुन पूजाहारीले चढाउँछ त्यो उसैको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","तर अर्को अन्नबलि जो तेलमा मिसाएर अथवा सुख्खा बनाइन्छ त्यो बराबरी भागमा हारूनका छोराहरूको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“परमप्रभुलाई अर्पण गरिने मेलबलिका नियम यही हो। यदि त्यो कसैले धन्यवाद स्वरूप चढायो भने, ");
INSERT INTO npi2010_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","उसले उसको धन्यवाद बलिसित खमीर नहाली तेलमा मुछेको रोटी, खमीर नहाली तेल दलेको बाबर रोटी र तेलमा डुबाएको शुद्ध पीठोको फुलौरा चढाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","उसले मेलबलिसित धन्यवादको भेटी खमीर मिसाएको रोटी पनि चढाओस्। यसबाट उसले परमप्रभुलाई प्रत्येक एक एकवटा उपहार चढाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","मेलबलिको रगत जुन पूजाहारीले छर्कन्छ यो बलि उसैको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","धन्यवादको निम्ति मेल बलिको मासु त्यही बलि चढाएकै दिन खाई सक्नुपर्छ। यसको कुनै अंश अर्को बिहान सम्म रहनुहुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“यदि उसको बलि परमप्रभुअघि विशेष भाकल पूरा गर्नु राखिएको अथवा परमप्रभुलाई भेटी चढाएको अर्थ लाग्छ। तब बलिदान त्यही दिन खानुपर्छ जहिले बलि चढाइन्छ अनि रहेको अर्को दिन खानु सकिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","तर यदि केही मासु तेस्रो दिनसम्म रहे आगोमा जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","यदि मेलबलिको मासु तेस्रो दिनमा खाए, त्यो स्वीकृत हुने छैन, त्यो एउटा चढाउनेको निम्ति केही गनिने छैन यो अशुद्ध भएको छ। मानिस दोषी हुनेछ अनि जसले यसलाई खान्छ दण्ड पाउँनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“कुनै अशुद्ध कुरोले छोएको मासु खान हुँदैन। त्यसलाई आगोमा जलाउनु पर्छ। अनि अरू शुद्ध मानिस जति छन् तिनीहरूले मेल बलिबाट मासु खान सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","तर यदि कसैले परमप्रभुको मेलबलिको मासु जब खान्छ तब ऊ अशुद्ध हुन्छ, तिमीले उसलाई उसका मानसिहरूबाट छुट्‌याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“जब कुनै मानिसले कुनै अशुद्ध चीज छुन्छ त्यो अशुद्धता मानिसको अथवा पशुको अथवा अन्य कुनै घृणित चीज होस् र मेलबलिको मासु खाए त्यसलाई त्यसको मानिसहरूबाट अलग गराउनुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएली मानिसहरूलाई भन, तिमीहरूले साँढे, भेडा अथवा बाख्राहरूको बोसो खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","तिमीहरूले आफैं मरेको पशु अथवा जंगली जानवरहरूले मारेको पशु अन्य कुनै काममा लाग्न सक्छ, तर तिमीहरूले खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","परमप्रभुलाई चढाएको पशुको बोसो जुन मानिसले खान्छ उसलाई उसका मानिसहरूबाट अलग्ग गराउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“चराको होस् अथवा पशुको तिमीहरूले आफू बसोबास गर्ने ठाउँमा रगत नखानु। ");
INSERT INTO npi2010_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","यदि कुनै मानिसले बसेको ठाउँमा रगत खान्छ भने उसलाई उसका मानिसहरूबाट अलग गराउनुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलका मानिसहरूलाई भन: जसले मेलबलि चढाउँछ, उसले बलिको निम्ति उपहार आफैं लिएर आउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","परमप्रभुलाई चढाउने भेटी आफ्नो हातमा लिएर परमप्रभुअघि छातीको ह्याकुलो बोसोसमेत डोलाउने बलिको रूपमा चढाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","पूजाहारीले बोसो वेदीमा जलाउनु पर्छ तर हारून र उनका छोराहरूको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","मेलबलिको निम्ति चढाएको बलिको दाहिने फिला चाहि पूजाहारीलाई दिइयोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","हारूनका छोराहरू मध्ये एक जना पूजाहारी जसले आफ्नो भागबाट मेलबलिको रगत र बोसो चढाउँछ। मेलबलिको दाहिने फिला चाँहि पूजाहरीको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","किनभने डोलाइने बलिको ह्याकुलो र मैत्रीबलिको दाहिने तिघ्राको उपहार जो मैले इस्राएलीहरूबाट लिएको थिएँ पूजाहारी हारून र उनका छोराहरूलाई नियमित उपहारको रूपमा दिएको छु।” ");
INSERT INTO npi2010_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","जुन दिन हारून र तिनका छोराहरूलाई परमप्रभुको सेवा गर्न पूजाहारी पदमा नियुक्ति गरियो त्यसै दिनदेखि परमप्रभुको निम्ति आगोमा चढाइएका बलिहरूबाट तिनीहरूको भाग पाउँछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","परमप्रभुले मानिसहरूलाई बलिको तिनीहरूको भाग सदा-सर्वदा पूजाहारीलाई दिनु भन्नु भएकोछ। उहाँले यी आज्ञाहरू त्यस दिन दिनुभयो जब उहाँले तिनीहरूलाई पूजाहारी नियुक्त गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","यिनीहरू नै होमबलि, अन्नबलि, पापबलि, दोषबलि, मैत्रीबलि अनि अपर्णबलिका नियमहरू हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","जुनदिन परमप्रभुले सीनै मरूभूमिमा इस्राएलीहरूलाई उहाँको निम्ति बलि ल्याउने आज्ञा दिनु भयो त्यही दिन परमप्रभुले मोशालाई यी आज्ञाहरू सीनै पर्वतमा दिनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“हारून र उसका छोराहरूलाई तिनीहरूको पूजाहारी पोषक, अभिषेक तेल, पापबलिको साँढे, दुइवटा भेडा र एक डालो अखमिरी रोटीसँग लैजाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","तब तिनीहरूलाई सम्पूर्ण मानिसहरूसंग भेट हुने पालमा लैजाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","यसर्थ परमप्रभुले तिनलाई आज्ञा दिनु भए झैं मोशाले भने। मानिसहरू सबै भेट हुने पालमा सँगै भेला भए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मोशाले मानिसहरूलाई भने, “यो परमप्रभुले आज्ञा दिनु भएको कुरा यही हो।” ");
INSERT INTO npi2010_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","तब मोशाले हारून र तिनका छोराहरूलाई ल्याए अनि पानीले नुहाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","तब मोशाले हारूनलाई बुनेको कमेज पहिराइदिए अनि तिनको कम्मरमा पटुका बाँधिदिए। त्यसपछि हारूनलाई अलखा पहिराए तब मोशाले तिनलाई एपोद बाँधिदिए। मोशाले एपोदलाई अलखामा बाँधिदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","तब उनले हारूनको छातीमा न्यायको छाती पाता लगाइदिए अनि गोजीमा ऊरीम र तुम्मीम राखिदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","परमप्रभुले आज्ञा दिनुभए अनुसार तिनले हारूनलाई टाउकोमा फेटा बाँधिदिए अनि फेटाको अघिल्लो भागमा सुनको पवित्र मुकुट लगाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","मोशाले अभिषेक तेल लिएर पवित्र पालको प्रत्येक ठाउँ र चीजहरूमा छर्किदिए। अनि यसरी तिनले, ती सब चीजहरूलाई पवित्र पारे। ");
INSERT INTO npi2010_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","उनले अभिषेक तेल वेदीमा सात पल्ट छर्किदिए। उनले अभिषेक तेल वेदी अनि भाँड-कुँडाहरू हातमुख धुने भाँडो अनि कचौरा राख्ने ठाउँलाई पवित्र बनाउन छर्किदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","त्यसपछि हारूनलाई शुद्ध पार्न अभिषेक तेलको केही अंश तिनको शिरमा खन्याइ दिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","त्यसपछि मोशाले हारूनका छोराहरूलाई ल्याए र बुनेको कमिज पहिराई पटुका बाँधिदिएर तिनीहरूलाई टोपी लगाइदिए अनि यी सबै मोशाले परमप्रभुको आज्ञा अनुसार गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","यसपछि उनले पापबलिको साँढे ल्याए। हारून र तिनका छोराहरूले त्यस साँढेको टाउकोमाथि आफ्ना-आफ्ना हात राखे, ");
INSERT INTO npi2010_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","अनि मोशाले त्यो साँढेलाई मारेर र केही रगत आफ्नो औंलाहरूमा लिएर वेदीको कुना-कुना सबैतिर दले। यस प्रकार तिनले वेदी पवित्र पारे। अनि बाँकी रहेको रगत वेदीको आधारमा खन्याए। यसरी तिनले प्रायश्चित गर्न वेदी पवित्र बनाए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","मोशाले साँढेको भित्र्यांशको बोसो, कलेजो बोसो, दुइवटा मृगौलाहरू अनि तिनीहरूमाथि भएको बोसो निकाले अनि यी वेदीमा जलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","त्यसपछि तिनले साँढेको अरू बाँकी रहेको छाला, मासु, गोवर तथा अरू भागहरू परमप्रभुको आज्ञा अनुसार पाल बाहिर जलाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","त्यसपछि तिनले होमबलिको निम्ति एउटा भेडा ल्याए अनि हारून अनि तिनका छोराहरूले त्यस भेडाको शिरमाथि तिनीहरूको हात राखे। ");
INSERT INTO npi2010_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","तब मोशाले भेडालाई मारे अनि यसको रगत वेदीको चारैतिर छर्किदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","भेडालाई तिनले टुक्वा-टुक्रा पारेर काटे अनि टाउको, टुक्राएको मासु अनि बोसो आगोमा जलाए। तिनले भेडाको आन्द्रा-भुँडी र खुट्टाहरू पानीले धोए अनि सम्पूर्ण भेडालाई नै वेदीको आगोमाथि राखे। यो सुगन्धित बास्नाको लागि होमबलि थियो। यो परमप्रभुले मोशालाई दिएको आदेश अनुसार आगोद्वारा दिइने होमबलि थियो। ");
INSERT INTO npi2010_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","त्यसपछि तिनले पूजाहारी नियुक्त भएकोमा अर्पण गरिएको अर्को भेडा ल्याए अनि हारून र तिनका छोराहरूले आफ्नो हातहरू त्यस भेडाको टाउकोमाथि राखे। ");
INSERT INTO npi2010_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","त्यसपछि तिनले त्यो भेडालाई मारेर त्यसको रगत हारूनको दाहिने कानको लोतीमा, दाहिने हात र दाहिने खुट्टाको बुढी ओंलाहरूमा लगाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","मोशाले हारूनका छोराहरूलाई अघि ल्याए अनि तिनीहरूको दाहिने कानको लोती दाहिने हातको औंलो र दाहिने खुट्टकाको बुढी औंलाहरूमा राखिदिए अनि रहेको रगत वेदी वरिपरि छर्किदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","तिनले बोसो, बोसे पुच्छर आन्द्राभुँडी छोप्ने सबै बोसो, कलेजो छोप्ने मासु, बोसोसितै दुइवटा मिगौला र दाहिने फिला लिए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","परमप्रभु अघि राखिएको खमीर रहित रोटीको डालोबाट उनले एउटा मोटो अखमीर रोटी, अर्को एउटा अखमीरे रोटी तेल मिसाएको र अखमीरे फुलौरो अनि तिनीहरूलाई बोसो र दाहिने तिघ्रामाथि राखे। ");
INSERT INTO npi2010_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","तब मोशाले ती खाद्यहरू हारून अनि तिनका छोराहरूको हातमा राखिदिए अनि परमप्रभुअघि डोलाउने बलिको रूपमा माथि उठाए। ");
INSERT INTO npi2010_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","तब तिनले तिनीहरूको हातबाट खाद्य लिए अनि होमबलिको वेदीमाथि राखिदिए। यो पूजाहारीहरूको नियुक्ति निम्ति बलिदान थियो। यो एउटा सुगन्धित समुद्रघर भेटी हो जसले परमप्रभुलाई खुशी पार्यो। ");
INSERT INTO npi2010_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","परमप्रभुको आदेश अनुसार परमप्रभुमाथि ह्याकुलो विशेष उपहारको रूपमा हल्लाए। पूजाहारीहरूलाई नियुक्त गर्नका निम्ति यो मोशाको भेडाको भाग थियो। ");
INSERT INTO npi2010_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","तिनले केही अभिषेक गरेको तेल अनि रगत लिए जो वेदीमा थियो अनि त्यसलाई हारून र तिनका छोराहरू र तिनीहरूको लुगाहरूमाथि छर्के। यसरी तिनले हारून र तिनका छोराहरूसहित तिनीहरूका लुगाहरू सितै पवित्र पारे। ");
INSERT INTO npi2010_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","तिनले हारून र तिनका छोराहरूलाई भने, “भेट हुने पालको प्रवेशद्वारमा मासु उसिन र अभिषेक डालोमा भएको रोटीहरूसित खाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","तिमीहरूले खाएर उब्रेको मासु र रोटी आगोमा जलाइ देऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","तिमीहरू पूजाहारी अभिषेक भएको दिनदेखि सात दिनसम्म बाहिर कतै नजानु, अभिषेकको समय सात दिन हो तिमीहरूले सात दिन पूरा नहोउञ्जेल भेट हुने पाल छोड्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","तिमीहरूलाई पूजाहारी पदमा नियुक्ति गराउन पवित्र पार्न परमप्रभुले आज्ञा गर्नु भएको थियो जुन आज गरियो। ");
INSERT INTO npi2010_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","मलाई आज्ञा गरिएको छ तिमीहरू सात दिनसम्म रात-दिन भेट हुने पालको प्रवेशद्वारमा बस्नुपर्छ अनि परमप्रभुको आज्ञा पालन गर्नुपर्छ जसले गर्दा तिमीहरूको मृत्यु हुने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","परमप्रभुले मोशा मार्फत जे जति आज्ञा गर्नु भएको थियो हारून र तिनका छोराहरूले सबै पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","आठौं दिनमा मोशाले हारून, तिनका छोराहरू र इस्राएलका बूढा प्रधानहरूलाई बोलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","हारूनलाई उनले भने, “बगालबाट निष्खोट एउटा बाछा पापबलिको निम्ति अनि होमबलिको निम्ति एउटा निष्खोट भेडा ल्याएर परमप्रभु सम्मुख बलि चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","इस्राएलका मानिसहरूलाई भने, ‘परमप्रभुको अघि पापबलिको निम्ति एउटा बोका, निष्खोट एक वर्ष पुगेको एउटा बाछा अनि होमबलिको निम्ति निष्खोट एउटा एक वर्षको पाठा ल्याऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अनि एउटा थुमा, एउटा साँढे र एउटा भेडा मेलबलिको निम्ति अनि अन्न बलि तेल सित मिसाएका उपहार झैं किन? किनभने आज परमप्रभु तिमीहरूको अघि प्रकट हुनुहुनेछ।’” ");
INSERT INTO npi2010_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","यसर्थ मोशाले आज्ञा दिए अनुसार भेट हुने पालअघि तिनीहरूले चीजहरू ल्‌याए। सम्पूर्ण मानिसहरू परमप्रभुअघि आएर उभिए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","त्यसपछि मोशाले भने, “परमप्रभुले तिमीहरूलाई यस्तो कार्य गर्नु भनी आज्ञा दिनु भएको थियो जसले गर्दा परमप्रभुको महिमा तिमीहरू प्रति झल्कियोस्।” ");
INSERT INTO npi2010_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","त्यसबेला मोशाले हारूनलाई भने, “तिमी वेदीको नजिक जाऊ, तिम्रो पापबलि अनि होमबलि चढाऊ, आफ्नो र मानिसहरूको निम्ति पाप प्रायश्चित गर। परमप्रभुले आज्ञा गर्नु भएको अनुसार मानिसहरूले ल्याएको बलिदानहरू चढाएर तिनीहरूका निम्ति प्रायश्चित गरे।” ");
INSERT INTO npi2010_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","त्यसपछि हारून आफ्नो निम्ति वेदीको नजिक गएर पापबलिको निम्ति बाछो मारे। ");
INSERT INTO npi2010_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","पछि हारूनका छोराहरूले तिनको नजिक त्यसको रगत ल्याए, अनि तिनले आफ्नो औंलोमा रगत लिएर वेदीको कुना कुनामा लगाए अनि बाँकी रगत वेदीको आधारमा खन्याए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","तब परमप्रभुले मोशालाई आदेश गर्ने बित्तिकै हारूनले मृगौला, गर्भजालो, कलेजो ढाक्ने मासु अनि पशुको बोसो वेदीमा जलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","पाल बाहिर हारूनले मासु र छाला आगोमा जलाइदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","त्यसपछि तिनले होमबलि स्वरूप भेडा मारे। हारूनका छोराहरूले तिनलाई रगत दिए अनि वेदीका वरिपरि छर्के। ");
INSERT INTO npi2010_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","अनि हारूनका छोराहरूले पशुका टुक्राहरू अनि यसको टाउको उसलाई दिए। तब हारूनले ती सबै वेदीमा जलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","फेरि तिनले आन्द्रा-भुँडी र खुट्टा पखालेर होमबलिसँगै वेदीमाथि जलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","त्यसपछि तिनले मानिसहरूको निम्ति बलिदान ल्याएर तिनीहरूको पापबलिको बोका मारे अनि पहिला गरे जस्तै पापबलिको निम्ति जलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","त्यसपछि हारूनले होमबलि ल्याए अनि आज्ञानुसार बलि दिए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","तब तिनले अन्नबलि ल्याए अनि त्यसबाट एक मुठ्ठी लिएर बिहानको होमबलिसित वेदीमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","अनि तिनले मानिसहरूको मेलबलिको निम्ति साँढे र भेडा मारे। हारूनका छोराहरूले रगत लिएर तिनलाई दिए अनि तिनले त्यो सबै तिर छर्के। ");
INSERT INTO npi2010_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","अनि साँढे र भेडाको बोसो, आन्द्रा-भुँडी छोप्ने बोसो, मृगौला र कलेजा छोप्ने मासु तिनका छोराहरूले तिनलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","तिनीहरूले ह्याकुलामाथि बोसो राखे अनि तिनले त्यो बोसो वेदीमाथि जलाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","अनि मोशालाई परमप्रभुले दिएको आदेश अनुसार उनले परमप्रभुलाई ह्याकुलो र दाहिने तिघ्रो डोलाउने बलिको रूपमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","तब हारूनले मानिसहरू प्रति हात उठाएर तिनीहरूलाई आशीर्वाद दिए। यसरी पापबलि, होमबलि र मेलबलि चढाई सिध्याए पछि तिनी वेदीबाट तल ओर्लिए। ");
INSERT INTO npi2010_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","त्यसपछि मोशा र तिनी भेट हुने पालमा गए। जब तिनीहरू बाहिर आए तिनीहरूले मानिसहरूलाई आशीर्वाद दिए। तब परमप्रभुको महिमा सबै मानिसहरूमा झल्कियो। ");
INSERT INTO npi2010_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","परमप्रभुको सामुन्नेबाट आगो उत्पन्न भयो अनि वेदी माथिको होमबलि र बोसोलाई खरानी पार्यो। जब सबै मानिसहरूले यो देखे तिनीहरू कराए अनि आ-आफ्ना अनुहार भूइँतिर निहुराए। ");
INSERT INTO npi2010_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","त्यसपछि हारूनका छोराहरू नादाब र अबीहूले परमप्रभुअघि धूप जलाउनको लागी आफ्नो धूपदानीमा आगो प्रयोग गर्दै सल्काए जसकालागि उहाँले तिनीहरूलाई अनुमति दिनु भएको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","यसर्थ परमप्रभुको उपस्थितिबाट आगो निस्कियो र तिनीहरूलाई परमप्रभुको सामुन्ने जलायो। ");
INSERT INTO npi2010_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","त्यसपछि मोशाले हारूनलाई भने, “परमप्रभुले जे भन्नु भएको थियो त्यसको अर्थ यही थियो। ‘पूजाहारीहरू जो मेरो सामुन्ने आउँछन् तिनीहरूद्वारा म सम्मानित हुनुपर्छ अनि सबैकोअघि म पवित्र हुनुपर्छ।’” अनि हारून नबोली बसे। ");
INSERT INTO npi2010_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मोशाले हारूनका काका उज्जीएलका छोराहरू मीशाएल र एलसापानलाई बोलाए अनि भने। उनले तिनीहरूलाई भने, “आऊ अनि आफ्ना काकाको छोराहरूलाई पवित्र स्थानबाट बाहिर पालसम्म लैजाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","यसैले तिनीहरूले उनीहरूलाई पहिरेकै पोषाकमा मोशाको आदेश अनुसार पाल बाहिर उनीहरूलाई उठाएर लगे। ");
INSERT INTO npi2010_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","तब मोशाले हारून र तिनका छोरा एलाजार र ईतामारलाई भने, “तिनीहरूको शिरको कपाल नखौर शोक देखाउनलाई आफ्ना लुगाहरू नच्यात, तब तिमीहरू मर्ने छैनौ, अनि परमप्रभु सबै मानिसहरूको विरूद्धमा क्रोधित हुनुहुने छैन। तर नादाब र अबीहूका लागि जो परमप्रभुद्वारा उत्पन्न गरेको आगोले गर्दा मरे, इस्राएलका सारा बासिन्दाहरू जो तिमीहरूका आफन्त छन् विलाप गर्न सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","भेट हुने पालको प्रवेशद्वार, बाहिर तिमीहरू नजानु नत्र तिमीहरू मर्ने छौ। किनभने परमप्रभुले अभिषेक गरेको तेल तिमीहरूमाथि छ।” यसकारण तिनीहरूलाई मोशाले जे भनेका थिए त्यही गरे। ");
INSERT INTO npi2010_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","त्यसपछि परमप्रभुले हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“जब तिमी र तिम्रा छोराहरू भेट हुने पालभित्र पस्छौ तिमीहरूले दाखरस अथवा मादक वस्तु पिउनु हुदैन नत्र तिमीहरू मर्नेछौ। यो नियम भविष्यका तिम्रा सन्तानहरूको निम्ति सँधै रहोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","किनभने तिमीहरूले कुन पवित्र अनि कुन अपवित्र र कुन शुद्ध अनि कुन अशुद्धमा भेद राख्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अनि परमप्रभुले मोशाद्वारा इस्राएलीहरूलाई दिनुभएको नियमहरू तिनीहरूलाई सिकाउनुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मोशाले हारूनका बाँचेका छोराहरू एलाजार र ईतामरलाई भने, “अन्नबलि लैजाऊ जो रहेको छ यसमा कुनै खमीर नमिसाऊ अनि वेदीको नजिक गएर खाऊ किनभने यो अतिनै पवित्र छ। ");
INSERT INTO npi2010_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","अनि यो तिमीहरूले पवित्र ठाउँमा खानु किनभने यो तिमी अनि तिम्रा छोराहरूको निम्ति परमप्रभुलाई चढाइएको अंश हो। त्यसको लागि मैले आज्ञा दिएकोछु। ");
INSERT INTO npi2010_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“तिमी र तिम्रा छोरा-छोरीहरूले समारोह शुद्ध ठाउँमा बसेर डोलाउने बलिको ह्याकुलो र तिघ्रो खान सक्छौ किनभने तिनीहरू तिमी र तिम्रा छोरा-छोरीहरूको निम्ति इस्राएलका मानिसहरूद्वारा मेलबलिको रूपमा दिइएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","तिनीहरूले डोलाइएको बलिको तिघ्रा र ह्याकुलो अनि बोसो पनि आगोद्वारा चढाउन ल्याउनु पर्छ। यो तिमी र तिम्रा नानीहरूको निम्ति परमप्रभुको आदेश अनुसार सँधैको निम्ति हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","जब मोशाले पापबलिको बोको खोजे तब उनले त्यो पहिले नै पोली सकेको पाए। यसर्थ एलाजार र ईतामार, जो हारूनका बाँचेका छोराहरू हुन, तिनीहरूसित मोशा रिसाए उनले भने, ");
INSERT INTO npi2010_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“तिमीहरूले किन पापबलिको मासु पवित्र स्थनमा बसेर खाएनौ? किनभने त्यो बलि अत्यन्तै पवित्र हो। अनि परमेश्वरले मानिसहरूको दोष निवारणको निम्ति परमप्रभुअघि तिमीहरूलाई दिनुभएको हो। ");
INSERT INTO npi2010_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","तिमीहरूले बोकाको रगत पवित्र स्थलभित्र ल्याएनौ। यसर्थ मैले आदेश अनुसार तिमीहरूले पवित्र स्थान भित्र मासु खाएको हुनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","तब हारूनले मोशालाई भने, “आज कै दिन तिनीहरूले आफ्ना पापबलि र होमबलि परमप्रभुको सामु चढाए तापनि ममाथि यस्ता कुराहरू परिआएका छन्। यदि मैले आज पापबलिको मासु खाएको भए, के यसले परमप्रभुलाई खुशी बनाउने थियो?” ");
INSERT INTO npi2010_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","जब मोशाले यी कुरा सुने, तिनी यो कुरासँग सहमत भए। ");
INSERT INTO npi2010_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलका मानिसहरूलाई भनः पृथ्वीका प्राणीहरूमध्ये तिमीहरू यी प्राणीहरू खान सक्छौः ");
INSERT INTO npi2010_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","तिमीहरू कुनै पनि प्राणी खान सक्छौ जसको खुर चिरिएको हुन्छ अनि जो उग्राउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“तिमीहरूले ऊँट खानु हुँदैन किनभने यो उग्राउँछ तर यसको खुर चिरिएको छैन, भुइँभालु किनभने यो उग्राउँछ तर यसको खुर चिरिएको हुँदैन। खरायो यद्यपि यो उग्राउँछ। यसको खुर चिरिएको हुँदैन किनभने यी अशुद्ध हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अनि सुँगुर-यसको खुर चिरिएको त छ तर यसले उग्राउँदैन, यसर्थ यो तिमीहरूको निम्ति फोहोर तथा अशुद्ध छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","तिमीहरूले यी पशुहरूको मासु नखानु अनि या पशुहरूको सिनु नछुनु। यी पशुहरू तिमीहरूको निम्ति अशुद्ध अनि फोहोर हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“पानीमा हुने सबै प्राणीहरू तिमीहरूले खान सक्छौ, जलचर प्राणीहरूमा जसको पखेटा र कत्ला हुन्छ, चाहे त्यो नदी अथवा समुद्रको, तिमीहरू खान सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","नदी अनि समुद्रका सबै प्राणीहरूमा जसको पखेटा अथवा कत्ला हुँदैन त्यसलाई घृणा गर्नु अनि नखानु। यस्ता पशुहरू तिमीहरूको निम्ति घृणित हुन अनि तिमीहरूले तिनीहरूको मासु खानु हुँदैन तिमीहरूले तिनीहरूको मृत शरीरहरूलाई छुनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","जलचर प्राणीहरू मध्ये जसको पखेटा अनि कत्ला हुँदैन त्यसको मासु खानु तिमीहरूको निम्ति निषेध मान्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“चराहरूमा यी तिमीहरूको निम्ति घृणित हुन् अनि तिमीहरूले यिनीहरूको मासु खानु हुँदैन गरूड, गिद्ध, कालो गिद्ध, ");
INSERT INTO npi2010_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","रातो चील र सबै प्रकारका कालो चील, ");
INSERT INTO npi2010_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","सबै थरीका कागहरू, ");
INSERT INTO npi2010_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ठूलो लाटकोसेरो, कराउने लाटकोसेरो, समुद्री चराहरू र सबै जातका बाजहरू, ");
INSERT INTO npi2010_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","सानो लाटोकोसेरो, पानी काग, भुल्का, ");
INSERT INTO npi2010_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","सेतो लाटोकोसेरो, मरूभूमिमा हुने लाटोकोसेरो, माछा खाने चील, ");
INSERT INTO npi2010_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","सारस, सबै प्रकारको बकुल्ला, फाप्रेचरो र चमेरो। ");
INSERT INTO npi2010_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“तिमीहरूले प्रत्येक पंखेटा भएका किराहरूलाई जो घस्रेर हिंड्छन्, खानमा बारेको सम्झनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","तर तिमीहरूले उफ्रिने जोर्नी भएका खुट्टा हुने पंखेटा भएका किराहरू खान सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","यी किराहरू मध्ये तिमीहरूले खान सक्छौः प्रत्येक प्रकारको सलह, पखेटा सलह; प्रत्येक जातको किथ्रा र फटेङ्ग्रा खानु सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“चार खुट्टे तर पंखेटा भएका प्रत्येक जातका किराहरू तिमीहरूको निम्ति घृणित हुन्छ, यो तिमीहरूले खानु निषेध मान्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","निम्न लिखित प्राणीहरूले तिमीहरूलाई फोहोर अनि अपवित्र पार्छ। कुनै पनि मानिस जसले तिनीहरूको सिनु छुन्छ त्यो साँझसम्म अपवित्र रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","अनि कुनै पनि मानिस जसले सिनु बोक्छ, उसले आफ्नो लुगा धुनुपर्छ अनि साँझसम्म त्यो अपवित्र रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“कुनै प्राणी जसको चिरिएको खुर त छ तर उग्राउँदैन भने त्यो तिमीहरूको निम्ति अपवित्र हो। जसले पनि यसलाई छुन्छ अशुद्ध हुन्छ। चार खुट्टाले हिंड्छ तर पन्जाले टेकेर हिंड्छन् भने त्यस्तो प्रत्येक पशु तिमीहरूको निम्ति अपवित्र हो। कुनै पनि मानिस जसले त्यसलाई छुन्छ त्यो साँझसम्म अपवित्र हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","जसले यस्तो पशुको लाश बोक्छ, साँझसम्म अशुद्ध रहन्छ अनि यसले आफ्नो लुगा धुनुपर्छ। त्यस्ता पशुहरू तिमीहरूको निम्ति अशुद्ध हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“भूँईमा घस्रने प्राणीहरू मध्ये यिनीहरू तिमीहरूको निम्ति अपवित्र हुन्-जस्तै न्याउरीमुसो, मुसो, सबै जातको छेपारोहरू, ");
INSERT INTO npi2010_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","माउसुली, गोहोरो, भालेमुँग्रो, बालुवामा हुने छेपारो अनि रंग बद्लने छेपारो। ");
INSERT INTO npi2010_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","घस्रनेहरूमा यिनीहरू तिमीहरूको निम्ति अशुद्ध हुन्। कसैले यी प्राणीहरूमध्ये कुनैको पनि लाश छोए त्यो मानिस साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“अनि यदि अशुद्ध पशुहरू मध्ये कुनै मर्छ अनि केहि कुरामा पर्छ तब त्यो वस्तु अशुद्ध हुनेछ यो काठ, लुगा, छाला, पाठाको छालाको लुगा (भाङग्रा) अथवा कुनै काम आउने भाँडे किन नहोस्। यदि यस्तो भए, यसलाई पानीमा डुबाउनु पर्छ अनि यो साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","माटोको भाँडामा मरेका यी प्राणीहरूमध्ये कुनै परे त्यो भाडमा रहेको चीज पनि अशुद्ध हुन्छ र त्यो भाँडा फुटाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","यदि त्यो भाँडामा पानी थियो अनि त्यसले अर्को कुनै खाद्य छुन्छ। त्यो अशुद्ध हुनेछ। अनि यदि कुनै पिउने वस्तु त्यस भाँडामा थियो भने त्यो पनि अशुद्ध हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","यदि त्यो मरेको वस्तुको कुनै पनि अंग मात्र केही चीजमा परे त्यो चीज अशुद्ध हुनेछ। यदि त्यो बस्तु चुला अथवा अँगेटी हो भने त्यो भत्काउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“तर यदि कोही पानीको मुहान अथवा कूवाँमा भए त्यो अशुद्ध हुँदैन तर जसले मरेको लाश छुन्छ त्यो चाँहि अशुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","अनि यदि त्यो मृत देह कुनै बीउमाथि झरे त्यो बीउ शुद्ध नै रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","तर यदि ती बीउहरूमाथि पानी हालेको छ र त्यस्तो सिनु पर्यो भने ती बीउहरू तिमीहरूको निम्ति अशुद्ध हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“यदि तिमीहरूका पशुहरूमध्ये कुनै मर्छ जसलाई खानको निम्ति तिमीहरूलाई अनुमति दिइएको छ, तब व्यक्ति जसले यसको मृत शरीरलाई छुन्छ साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","यदि कसैले त्यस मरेको पशुको कुनै भागको मासु खान्छ तब त्यस मानिसले आफ्नो लुगा धुनु पर्छ र साँझसम्म ऊ अशुद्ध रहनेछ। यदि कसैले त्यस्तो पशुहरूको लाश छुन्छ ऊ साँझसम्म अशुद्ध रहनेछ अनि उसले आफ्ना लुगाहरू धुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“अनि प्रत्येक प्राणी जो भुइँमा घस्रन्छ त्यसलाई तिमीले घृणा गर्नैपर्छ अनि तिमीले त्यो खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","कुनै पनि प्राणी जो भुइँमा आफ्नो पेटले सुल्कन्छ अथवा चार अथवा धेरै खुट्टाले घस्रन्छ त्यस्तो प्राणी तिमीहरूले खानु हुँदैन। तिनीहरूलाई घृणा गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","यस्ता घस्रने प्राणीबाट तिमीहरू कुनै पनि परिस्थितिमा अशुद्ध नहुनु। यिनीहरूलाई छोएर अशुद्ध नबन। ");
INSERT INTO npi2010_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","किनभने म परमप्रभु तिमीहरूको परमेश्वर हुँ। तिमीहरूले आफूलाई पवित्र राख्नु पर्छ। तिमीहरू पवित्र होऊ किनभने म पवित्र छु। तिमीहरू भूइँमा प्राणीहरूद्वारा अशुद्ध हुनु हुँदैन ");
INSERT INTO npi2010_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","म परमप्रभु तिमीहरूका परमेश्वर हुँ जसले तिमीहरूलाई मिश्र देशबाट तिमीहरूका परमेश्वर हुनका निम्ति बाहिर ल्याएँ, तिमीहरू पवित्र बन किनभने म पवित्र छु।” ");
INSERT INTO npi2010_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","पशु, पंक्षी, जलचर अनि भूइँमा घस्रने सबै प्राणीहरूका निम्ति विधिहरू यी नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","पवित्र र अपवित्र र पशुहरूमा मासु खानु हुने र नहुने छुट्याउने नियम यी नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलका मानिसहरूलाई भनः “यदि कुनै स्री गर्भवती हुन्छे र एउटा छोरा जन्माउँछे तब ऊ सात दिनसम्म अशुद्ध रहन्छे जस्तो ऊ रजस्वलाको समयमा अशुद्ध हुन्छे। ");
INSERT INTO npi2010_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","अनि आठौं दिनमा नवजात बालकको खतना गरिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","सुत्केरी आइमाईले शुद्धिकरणको निम्ति तैतीस दिनसम्म पर्खनुपर्छ। आइमाईले कुनै पवित्र चीज छुनु हुँदैन तथा पवित्र स्थानतिर जानु हुँदैन जबसम्म उसको शुद्धी हुने दिन पूरा हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","यदि कुनै स्रीले छोरी जन्माइ त्यो स्त्री स्वाभाविक रजस्वलाको दिनमा झैं दुई हप्तासम्म अशुद्ध रहन्छे। अनि उसले आफ्नो रजस्वलाबाट शुद्धीकरणको निम्ति छयसठ्ठी दिनसम्म पर्खनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“शुद्ध हुने दिन शेष भएपछि उसले छोरा पाएकी होस् अथवा छोरी, होमबलिको निम्ति एउटा एक बर्षे थुमा अनि पापबलिको निम्ति परेवाको एउटा बच्चा अथवा ढुकुरको बच्चा उसले पूजाहारी कहाँ भेट हुने पालको प्रवेशद्वारमा ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","त्यसपछि पूजाहारीले उसको बलि परमप्रभुलाई चढाउँछन् र ऊ सुत्केरी आफ्नो रजस्वलाबाट शुद्ध हुन्छे। यो नानी जन्माउँने कुनै पनि स्त्रीको निम्ति विधि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","यदि उसले थुमा चढाउन सक्तिन भने होमबलि र पापबलिको निम्ति एक जोडी परेवाका बचेरा अथवा ढुकुर ल्याउनु पर्छ र पूजाहारीले उसलाई शुद्ध पार्छ अनि ऊ शुद्ध हुन्छे।” ");
INSERT INTO npi2010_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“यदि कुनै मानिसको आफ्नो शरीरको छालामा कुनै वर्णान्तर दाग, विफिरा अथवा कुनै घाउ छ भने त्यसबाट कुनै हानिकारक चर्म रोग हुन सक्ने सम्भावना रहे उसलाई हारून अथवा तिनका पूजाहारी छोराहरू भएको ठाउँमा लैजानु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","पूजाहारीले उसको चर्मरोग जाँच गर्नु पर्छ अनि यदि पूजाहारीले घाउमा भएका रौं फुलेको थाहा पाउनुहुन्छ घाउ छालाभन्दा गहिरो छ तब त्यो हानिकारक चर्मरोग हो। जब पूजाहारीले जाँच सक्नु हुन्छ तब त्यस मानिसलाई अशुद्ध घोषणा गरिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“तर यदि त्यो दाग उसको शरीरको छालामाथि चहकिलो दाग मात्र हो अनि त्यो छालाभन्दा गहिरो छैन अनि रौं पहिल्यै फुलेको छैन तब पूजाहारीहरूले उसलाई सात दिनसम्म अरू मानिसहरूदेखि अलग्गै राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","यदि उसको जाँचमा त्यो घाउमा परिर्वतन नभए, अथवा घाउ नफैलिएको भए, पूजाहारीले त्यस मानिसलाई अरू सात दिन अलग्ग राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","अनि सातों दिनमा पूजाहारीले त्यो घाउलाई एक पल्ट फेरि जाँच गर्नु पर्छ, र यदि त्यो घाउ मत्थर भएको छैन अनि छालाको अरू ठाउँतिर फिंजिएको छैन भने तब पूजाहारीले उसलाई शुद्ध घोषणा गर्नु पर्छ। त्यो केवल खटिरा हो। अनि त्यस मानिसले आफ्नो लुगा धुनु पर्छ अनि ऊ शुद्ध हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“तर यदि त्यस मानिसले पत्तो लगाउँछ पूजाहरीले जाँच गरेपछि उनले घोषणा गर्नुअघि घाउ बढेको छ, तब ऊ फेरि जाँच गराउनकालागि पूजाहारीकहाँ जानु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","अनि यदि पूजाहारीले जाँच गर्दा छालाको घाउ फैलिएको पाए त्यस मानिसलाई पूजाहारीले अशुद्ध ठहराउनेछन्! यो एक हानिकारक रोग हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“यदि कुनै मानिसलाई छालाको सरूवा रोग लागे उसलाई पूजाहारीकहाँ ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","11","यदि पूजाहारीले जाँच गर्दा रोगीको छालामा सेतो सुनिएको पाउनु भयो र त्यसको रौं सेतो भएको र सुनिएको ठाँमा आलो घाउ रहेछ भने, यो धेरै समय सम्म रहने छालाको रोग हो र पूजाहारीले त्यसलाई अशुद्ध ठहराउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“यदि त्यो चर्मरोग शरीर भरी टाउकोदेखि खुट्टासम्म फैलिएको छ भने ");
INSERT INTO npi2010_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","पूजाहारीले जाँच गरेर उसलाई शुद्ध ठहराउन सक्छन् कारण ऊ सेताम्मे भएको हुन्छ र ऊ शुद्ध हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","तर त्यस मानिसमा आलो मासु देखिने बित्तिकै अशुद्ध हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","आलो मासु अशुद्ध हो र पूजाहारीले जाँच गर्ने बित्तिकै त्यो अशुद्ध भनी ठहराउने छन्। त्यो सरूवा रोग हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","17","“अनि फेरि आलो मासु सेतो हुन्छ तब मानिसले पूजाहारीकहाँ अवश्यै जानुपर्छ अनि पूजाहरीले त्यस मानिसलाई जाँच गर्नु पर्छ, यदि आलो मासु सेतो भएको छ, तब पूजाहारीले त्यस मानिसलाई अवश्यै शुद्ध घोषणा गर्नु पर्छ, किनभने त्यो मानिस शुद्ध छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“यदि कसैको छालामा एक प्रकारको फोका छ अनि यो निको भएको छ, तब त्यस ठाउँमा सेतो दाग अथवा रातो-सेतो चहकिलो दाग बनिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","पछि त्यस ठाउँमा सेतो वर्णान्तर रातो सेतो उज्जवल दाग बनिन्छ, तब त्यो मानिस पूजाहारीकहाँ जाओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","जब उसलाई जाँच गर्दा यदि पूजाहारीले फोका छाला भन्दा गहिरो भेट्छन् अनि रौं सेतो भएको छ, पूजाहारीले उसलाई अशुद्ध घोषणा गर्नु पर्छ। यो फोकाबाट निस्केको एउटा हानिकारक चर्मरोग हो ");
INSERT INTO npi2010_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","तर यदि पूजाहारीले सेतो रौं भेट्दैनन् अनि घाउ छालाभन्दा गहिरो छैन तर नरम भएको छ, तब उनले उसलाई अरू मानिसहरूबाट सात दिनसम्म छुट्‌याएर राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","यदि त्यो घाउ छालामा फैलिएको पाए त्यो मानिस अशुद्ध भएको घोषणा गर्नुपर्छ कारण त्यो एक सरूवा रोग हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","तर यदि त्यो रातो दाग त्यही नफैलिरहयो भने त्यो पिलोको दाग मात्र हो र पूजाहारीले त्यस मानिसलाई शुद्ध ठहराउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“अथवा कसैको छाला पोलेर रातो वर्णे मासु भएको छ भने पूजाहारीले जाँच गर्नु पर्छ अथवा पोलेको ठाउँमा सेतो दाग रहे पनि जाँच गर्नुपर्छ यदि पूजाहारीले उज्जवल दागमा रौं सेतो भएको अनि घाउ छालभित्र गाडिन थालेको पाए, ");
INSERT INTO npi2010_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","यो पोलेको घाउबाट फैलिएको हानिकारक रोग हो। तर घाउ सुकेको पाए। त्यस मानिसलाई अरूबाट सात दिनसम्म यो हानिकारक चर्मरोग हुनाले पूजाहारीले अशुद्ध घोषणा गर्नैपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","तर यदि पूजाहारीले जाँच गर्दा त्यो चहकिलो दागमा सेतो रौं भेट्दैनन् र घाउ पनि छालाभन्दा गाडिएको पनि भेट्दैनन्, तर घाउ नरम भएको भेट्छन्, तब उनले मानिसलाई अरूबाट सात दिन लागि छुट्‌याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","त्यसपछि सातौं दिनमा पूजाहारीले रोगीलाई जाँच गरून्, यदि रातो दाग छालामा फैलिएको भए उनले त्यस रोगीलाई अशुद्ध घोषणा गरून् कारण यो एक हानिकारक चर्मरोग हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","तर यदि त्यो रातो दाग आफ्नै स्थानमा रही अरूतिर फैलिएन भने र त्यो नरम रहे, पोलिएको बाट भएको वर्णान्तर हो र पूजाहारीले त्यस मानिसलाई शुद्ध घोषणा गरून् किनभने उसको त्यो पोलिएको घाउबाट बनिएको दाग मात्र हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“यदि कुनै पुरूष अथवा स्त्रीको टाउको अथवा चिउँडोमा सरूवा घाउ निस्केको छ अनि घाउ छालभन्दा गहिरो कपाल पातलो र पहेलो छ, तब पूजाहारीले उसको घाउ जाँच गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","अनि पूजाहारीले घाउ हानिकारक भएको घोषणा गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","पूजाहारीको जाँचमा यदि दाग छालाभन्दा गहिरो छैन अनि त्यहाँ कालो कपाल पाएको छैन भने त्यस मानिसहरूलाई अरूबाट सात दिनसम्म छुट्‌याउन पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","सातौं दिनको दिन पूजाहारीले घाउ जाच्नु पर्छ। यदि घाउ फैलिएको छैन। त्यसमा पहेलो रौं छैन अनि बाहिरी छालाभन्दा दाग गहिरिएको छैन। ");
INSERT INTO npi2010_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","त्यस मानिसले दारी आफैं काटोस्। तर उसले दाग चाँहि नकाटोस्। पूजाहारीले त्यस रोगी मानिसलाई सात दिनको निम्ति फेरि अरू मानिसहरूबाट अलग राखून्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","सातौं दिनको दिन पूजाहारीले उसको दाग जाँचून् अनि यदि उसले त्यो दाग छालामा फैलिएको नभेटे र दाग निस्केको ठाउँको छाला नदबिएको भए पूजाहारीले उसलाई शुद्ध घोषित गरून्। त्यस मानिसले आफ्नो लुगा धोओस् र शुद्ध होओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","तर यदि त्यो मानिस शुद्ध घोषित भए पछि दाग छालामा फैलिए। ");
INSERT INTO npi2010_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","यदि दाग छालमा फिंजिएको छ भने पूजाहारीले उसको जाँच गर्नु पर्छ यदि छालामा दाग फिंजिएको भेट्नेछन्, पहेलो कपालको खोजी गर्ने आवश्यकता छैन। त्यो मानिस अशुद्ध छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","तर यदि दाग निको भएको घाउ देख्दा त्यसमा केही परिवर्त्तन नपाए अनि कालो रौं पलाएको भए त्यो दाग निको भएको हो। त्यो मानिस शुद्ध छ अनि पूजाहारीले त्यस मानिसलाई शुद्ध भनी घोषणा गरून्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“यदि कुनै पुरूष अथवा स्त्रीको शरीरै भरि सेतो दाग भए, ");
INSERT INTO npi2010_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","पूजाहारीले जाँच गर्नु पर्छ र यदि उनी भन्छन् त्यस मानिसको जिउको दाग मात्र धमिलिएको सेतो दाग हो, तब यो एउटा डाबर मात्र हो जो छालामा निस्किएको छ। डाबर हानिकारक हुँदैन। त्यो मानिस शुद्ध छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“जब कुनै मानिसको टाउकोको कपाल झर्छ भने त्यो मानिस खुइले मात्र हो अशुद्ध होइन। ");
INSERT INTO npi2010_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","यदि उसको टाउकोको अगिल्तिर एक भाग खुइलियो भने त्यो मानिस शुद्ध हो, ऊ तालु खुइले मात्र हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","तर उसको खुइलेको तालुमा अथवा निधारमा रातो घाउ निस्कियो भने त्यो हानिकारक चर्मरोग हो जुन उसको शिरबाट फैलिन शुरू गरेको हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","उसलाई पूजाहारीले जाँचून् र यदि त्यसरी जाँच्दा उसको टाउकोमा अथवा निधारमा भएको घाउ हानिकारक चर्मरोग जस्तो देखियो भने, ");
INSERT INTO npi2010_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","त्यो मानिस अशुद्ध हो कारण उसको त्यो घाउ हानिकारक रोग हो। यसर्थ उसको टाउकोमाथि घाउ निस्केकोले पूजाहारीले उसलाई अशुद्ध घोषणा गरून्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“यदि एक जना मानिसलाई हानिकारक चर्मरोग लाग्छ, उसले आफ्नो लुगाहरू च्यात्नु पर्छ अनि शिरको केश छरपस्ट राख्नु पर्छ अनि उसले आफ्नो माथिको ओठ छोपेर ‘अशुद्ध! अशुद्ध’ भन्दै कराउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","त्यो मानिस अशुद्ध रहनेछ जबसम्म उसमा यो रोग रहन्छ। उसले एक्लै बस्नु पर्छ अनि उसले आफ्नो घर शिबिर बाहिर बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“जब कुनै लुगामा, त्यो लुगा ऊनी अथवा सूती जे होस्, ");
INSERT INTO npi2010_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","कुनै बुनेको सूती अथवा ऊनी अथवा छालाको कुनै पनि चीज होस् यदि त्यसमा ढुस्सी पलायो भने र ");
INSERT INTO npi2010_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","पलाएको ठाउँ हरियो अथवा रातो भयो भने, पूजाहारीलाई जाँच गराउनु पर्छ कारण त्यो ढुस्सी फैलिएको हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","पूजाहारीले त्यो ढुस्सी दागलाई हेरून् अनि त्यो दाग भएको चीजलाई सात दिनसम्म अलग्ग राखून्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","सातौं दिनमा फेरि पूजाहारीले त्यस चीजलाई जाँच गरून् र यदि त्यो दाग लुगामा, वा कुनै पनि चीजमाथि (ऊनी-सूती-छाला जे होस्) ढुस्सी फैलिएको पाए त्यो अशुद्ध हो। ");
INSERT INTO npi2010_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","त्यो ढुस्सी लागेको वस्तु चाहे ऊनी, सूती अथवा छाला जे सुकैले बनिएको होस्, यदि त्यसमा ढुस्सी फैलिएको पाए त्यो वस्तु नै आगोमा जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“यदि पूजाहारीले उनको जाँचमा त्यो वस्तु चाहे त्यो सूती, ऊनी अथवा लाले बुनेको सिलाएको जे जस्तो सुकै होस् त्यसमा ढुस्सी फैलिएको नपाए, ");
INSERT INTO npi2010_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","पूजाहारी मानिसहरूलाई त्यो वस्तु धुने आदेश दिऊन् र त्यसलाई अझ सात दिनसम्म अलग्ग राख्न लगाउन। ");
INSERT INTO npi2010_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","लुगा धोएपछि पूजाहारीले त्यसलाई हेर्नु पर्छ अनि यदि ढुसीको दाग बद्ली भएको पाइन्छ अनि फिंजिएको छैन, यो अशुद्ध हुन्छ। यसलाई दुस्सी अघि लागेको होस् अथवा पछि आगोमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“यदि त्यो वस्तु पूजाहारीले जाँच गर्दा त्यो धोएपछि त्यसमा दाग हराएको पाए लुगा चाहे सूती, ऊनी छाला जे सुकैको होस्, दाग भरिको ठाउँ काटेर फ्याँकोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","यदि पूजाहारीको जाँचमा त्यो वस्तु, जे सुकैले, बनिएको किन नहोस्, त्यो दाग फैलिंदै गएको पाए त्यसलाई आगोमा जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","तर यदि धुँदा त्यो दाग लुगाबाट जे सुकैले बनिएको किन नहोस् हराएको पाए, फेरि धुनु पर्छ अनि त्यो शुद्ध हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","लुगा चाहे बुने अथवा सिलाएको होस त्यो चाहे ऊनी, सूती अथवा छाला जे सुकैको किन नहोस् ढुसी लागे शुद्ध अशुद्ध भनी निर्णय गर्ने विधिहरू यी नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“जब एक जना मानिस चर्मरोगबाट निको हुन्छ, उसले शुद्ध हुनको निम्ति यी नियमहरू पालन गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","“पूजाहारीले पाल बाहिर त्यो मानिस भएको ठाउँमा गएर जाँच गरून् अनि त्यो चर्मरोग लागेको मानिस निको भएको पाए पूजाहारीले ");
INSERT INTO npi2010_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","उसलाई शुद्ध गराउनुको निम्ति दुइवटा शुद्ध चरा, एक टुक्वा सल्लाको काठ, अलिकति रातो धागो र हिसप ल्याउने आदेश दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","त्यसपछि पूजाहारीले ती दुइवटा मध्ये एउटा चरालाई माटोको भाँडामा भएको ताजा पानीमाथि मार्ने आज्ञा दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","अर्को जिउँदो चरालाई पूजाहारीले लिएर, सल्लाको काठ, रातो धागो अनि हिसपसित अघिल्लो चराको रगत मिसिएको पानीमा चोबलून्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","अनि चर्म रोग निको पारिनु पर्ने मानिसमाथि त्यो पानी सात पल्ट छर्किउन्। त्यसपछि त्यो मानिस शुद्ध भयो भनी घोषणा गरियोस्। अनि त्यो जीवित चरालाई पूजाहारीले खुल्ला मैदानमा छाडिदिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“तब मानिसले जसलाई शुद्धगराइदै थियो, आफ्नो लुगाहरू धुनु पर्छ कपाल खौरिनु अनि नुहाउनु पर्छ अनि त्यो मानिस शुद्ध हुन्छ। तब मानिस आफ्नो पालभित्र पस्न सक्छ तर सात दिनसम्म पालभित्र पस्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","सातौं दिन उसले आफ्नो कपाल, दाह्री अनी आँखी रौं खौरोस् उसले सबै कपाल खौरोस्, आफ्नो लुगा धुओस् अनि ऊ शुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“आठौं दिनको दिन त्यो चर्मरोग लागेको मानिसले भेडाको दुइवटा निष्खोट पाठो अनि एक वर्षको पाठी जसको कुनै खोट छैन र अन्नबलिको निम्ति तेलमा मुछेको डेढ पाथी मसिनो पिठो र आधा माना तेल ल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","शुद्ध पार्ने पूजाहारीले भेट हुने पालको फाटकमा परमप्रभुअघि चर्म रोग भएको मानिस र उसको भेटीहरू ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","तब पूजाहारीले एउटा पाठो अनि आधा माना तेल ल्याउनु पर्छ अनि परमप्रभुको निम्ति दोषबलिलाई डोलाउने बलिको रूप चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","उनले पापबलि र होमबलि चढाउने पवित्र स्थानमा मार्नु पर्छ किनभने यो दोषबलि पापबलि जस्तै हो। यो पूजाहारीको हो अत्यन्तै पवित्र हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“पूजाहारीले दोषबलिबाट केही रगत लिनु पर्छ र शुद्ध हुने मानिसको दाहिने कानको लोतीमा, दाहिने हातको र दाहिने खुट्टाको बूढी-औंलाहरूमा यसलाई दल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","त्यसपछि पूजाहारीले आधा माना तेल लिएर आफ्नो देब्रेहातको हत्केलामा हालून्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","त्यसपछि पूजाहारीले आफ्नो देब्रे हातको हत्केलामा दाहिने हातको औंला डुबाएर परमप्रभुअघि सात पल्ट छर्किऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","हत्केलामा बाँकी रहेको तेल शुद्ध हुने मानिसको दाहिने कान, उसको दाहिने हातको बूढी औंलामाथि, दाहिने खुट्टाको बूढी औंलामाथि खनाउनु पर्छ जुन ठाउँमा उसले दोषबलिको रगत छर्केको थियो। ");
INSERT INTO npi2010_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","उसको हत्केलामा रहेको तेल त्यो शुद्ध पारिदै गरिएको मानिसको टाउकोमा लगाउनु पर्छ त्यस्तै प्रकारले पूजाहारीले उसलाई परमप्रभुअघि शुद्ध पार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“तब पूजाहारीले पापबलि चढाउनु पर्छ अनि मानिसलाई उसको अशुद्धताबाट शुद्ध गर्नु पर्छ अनि त्यसपछि उनले होमबलि मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","पूजाहारीले होमबलि अनि अन्नबलि वेदीमा चढाएर त्यस मानिसलाई प्रायश्चित गर्नु पर्छ अनि त्यो मानिस शुद्ध हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“तर यदि ऊ गरीब छ अनि त्यसको व्यवस्थामा गर्नु सक्दैन भने तब उसले शुद्ध हुनका लागि एउटा भेडा दोष बलिको रूपमा ल्‌याउनु पर्छ अनि एपाको दश खण्डको एक खण्ड तेल मिसाइएको मिहिन पीठो अनि एक माना जैतुनको तेल अन्न बलिको रूपमा ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","अनि आफूले व्यवस्था गर्न सके अनुसार दुइवटा ढुकुर अथवा परेवाको बच्चा, एउटा पापबलिको निम्ति र अर्को होमबलिको निम्ति ल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“उसको शुद्धताको निम्ति आठौं दिनमा ती सब भेट हुने पालको ढोकामा परमप्रभुको सामुन्ने पूजाहारीकहाँ ल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","तब पूजाहारीले दोषबलिको पाठो र तेल लिएर डोलाउने बलिको रूपमा परमप्रभुअघि हल्लाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","त्यसपछि दोषबलिको निम्ति भेडाको पाठो मारियोस् र त्यसको केही रगत शुद्ध पारिनु पर्ने मानिसको दाहिने कानको लोतीमा, दाहिने हातको र दाहिने खुट्टाको बूढी-औंलाहरूमा लगाऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","अनि पूजाहारीले तेल त्यही देब्रे हातको हत्केलामा खन्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","त्यसपछि पूजाहारीले हत्केलाको तेल दाहिने हातको ओंलाले परमप्रभु अघि सात पल्ट छर्किऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","अनि पूजाहारीले उसको हातमा रहेको केही तेलबाट लिएर त्यो शुद्ध पारिनु पर्ने मानिसको दाहिने कानको लोतीमा, दाहिने हातको बूढी-औंला र दाहिने खुट्टाको बूढीऔंलामा जहाँ दोषबलिको रगत लगाइ दिएको थियो त्यही लगाई दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","पूजाहारीको हत्केलामा बाँकी रहेको तेल शुद्ध पारिनु पर्ने मानिसको शिरमा परमप्रभुअघि उसलाई शुद्ध पार्न लगाई दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“तब जवान ढुकुर अथवा परेवा जे हुन्छ उसले जगेडा गर्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","एउटा पापबलिको निम्ति अनि अर्को होमबलिको निम्ति पूजाहारीले अन्नबलिसित चढाऊन्। यसरी पूजाहारीले त्यो शुद्ध पारिनु पर्ने मानिसलाई परमप्रभुकोअघि प्रायश्चित गराउने छन्।” ");
INSERT INTO npi2010_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","एक जना मानिसहरू चर्म रोगबाट मुक्त भएपछि शुद्ध हुनको निम्ति यी नियमहरू छन्। यी नियमहरू तिनीहरूका लागि हुन जो आफूलाई शुद्ध बनाउनका लागि नियमित बलि चढाउन जगेडा गर्न सक्दैनन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जब मैले तिमीहरूको अधिकारमा दिन लागेको कनान देशमा तिमीहरू पुग्छौ, अनि म तिमीहरूको कुनै घरमा ढुसी पठाउनेछु, ");
INSERT INTO npi2010_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","तब त्यो घरको मालिक आओस् र पूजाहारीलाई भनोस्, ‘मेरो घरमा ढुसी परे जस्तै लाग्छ।’ ");
INSERT INTO npi2010_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“त्यसपछि पूजाहारीले घरमा आफू घर जाँच गर्नुअघि त्यस घरको प्रत्येक चीज बाहिर निकाल्ने आदेश दिऊन् कारण घरको प्रत्येक चीज नै अशुद्ध हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","त्यसपछि पूजाहारी घर जाँच गर्न आऊन् र यदि उनले घरको भित्तामा लागेको ढुसीमा रातो अथवा हरियो टाटो पाए त्यो भित्तामा ढुसीमा गहिरिएको बुझिनेछ र, ");
INSERT INTO npi2010_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","तब पूजाहारीले बाहिर निस्केर सात दिन सम्मको निम्ति घरको ढोका बन्द गरिदिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“पूजाहारीले सात दिनमा फर्केर घर निरीक्षण गर्नु पर्छ। यदि घरको भित्तामा ढुसी फैलिएको पाइन्छ ");
INSERT INTO npi2010_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","पूजाहारीले आदेश दिनुपर्छ, मानिसहरूले त्यस घरको भित्ताको ढुसी लागेको ठाउँको ढुङ्गहरू भत्काउन र ती ढुङ्गाहरू शहर बाहिर लगी कुनै फोहोर ठाउँमा फ्याँकून्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","त्यसपछि पूजाहारीले त्यस घरको भित्ता सबै खुर्किन लगाऊन् र मानिसहरूले खुर्केर निस्केको वस्तु सबै शहरबाहिर कही मैला ठाउँमा फ्याँक्न लगाऊन् र त्यस भित्तामा नयाँ लेप लगाउन आज्ञा दिउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","तिनीहरूले फूटेका ढुङ्गहरूलाई नयाँ ढुङ्गसित फेर्नु पर्छ। घरको मालिकले नयाँ लेप लगाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“एकपल्ट घरको भित्ताका ढुङ्गहरू फ्याँकेर खुर्केर लिउन लगाउँदा पनि यदि त्यस घरको भित्तामा फेरि ढुसी निस्कन्छ भने ");
INSERT INTO npi2010_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","त्यहाँ जाँच गर्न पूजाहारी आऊन् र यदि ढुसी त्यहाँ फैलेर घरको माल-तालहरू नष्ट पार्दैछ भने त्यो घर अशुद्ध हो। ");
INSERT INTO npi2010_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","त्यस घरको ढुङ्गहरू, काठपातहरू निकालेर शहर बाहिर कुनै मैला ठाउँमा फ्याँक्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","यदि कुनै मानिस त्यस्तो निषेधित घरमा पसे त्यो साँझसम्म अशुद्ध हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","यदि कुनै मानिस त्यस घरमा सुते उसले आफ्नो लुगा धुनुपर्छ। यदि कसैले त्यस घरभित्र खाए पनि उसले आफ्नो लुगा धुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पूजाहारी आएर परीक्षण गर्दा त्यस घरमा लिउन लगाई सक्दा ढुसी नफैलिएको पाए, ढुसी हराइसकेको हुँदा पूजाहारीले त्यो घर शुद्ध भएको घोषणा गरून्। किन? किनभने ढुस्सी हटेको छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“अनि घर शुद्ध पार्न पूजाहारीले दुईवटा चराहरू, धूपीको काठ, हिसोफ र रातो धागो लानु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ती दुई चराहरू मध्ये एउटालाई माटोको भाँडामा भएको पानीमाथि उसले मारोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","अनि धूपीको काठ, हिसोफ, रातो धागो र जिउँदो चरा लिएर बग्दै गरेको पानीमाथि मारेको चराको रगतमा चोबेर उसले सात पल्ट घरमा रगत छर्किनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","यी सबै धूपीको काठ, हिसोफ, जिउँदो चरा, रातो धागो द्वारा ऊ घर शुद्ध बनाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","यति गरे पछि त्यो जिउँदो चरालाई उसले मैदानमा खुला छोडिदिओस्। यसरी उसले त्यो घर शुद्ध पार्नेछ र घर पनि शुद्ध हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ती चर्म रोगको निम्ति नियमहरू, ");
INSERT INTO npi2010_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ढुस्सीको निम्ति लुगाको टुक्रामाथि अथवा घर भित्र। ");
INSERT INTO npi2010_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","यो सबै प्रकारको छालाको फोका, सुनीयकोहरूको विषयमा नियमहरू छालामाथि डाब अथवा चहकिलो दाग शुद्ध पार्ने तरीका हो। ");
INSERT INTO npi2010_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","चर्मरोग र ढुस्सीको निम्ति विधी यो नै हो। यी नियमहरूले सिकाउँछ जब चीजहरू शुद्ध हुन्छ, अनि जब चीजहरू अशुद्ध हुन्छ, यी धेरै प्रकारका बीमारहरूको नियमहरू हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","परमप्रभुले मोशा र हारूनलाई भन्नु भयो, ");
INSERT INTO npi2010_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलका मानिसहरूलाई बोलाऊ अनि तिनीहरूलाई भनः यदि कुनै मानिसको प्रमेह हुन्छ भने तब त्यो मानिस अशुद्ध हो। ");
INSERT INTO npi2010_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","यदि उसको प्रमेह थामिन्छ अथवा चलि रहन्छ, ऊ अशुद्ध हुन्छ अनि यो उसको अशुद्धता हो। ");
INSERT INTO npi2010_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ओछ्यानमा यस्तो मानिस सुत्यो भने प्रत्येक कुरामा ऊ अशुद्ध बनिन्छ। प्रत्येक कुरामा ऊ बसे त्यो पनि अशुद्ध बहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","यदि कसैले उसको ओछ्यान छुन्छ भने, ऊ पनि अशुद्ध हुन्छ अनि उसले आफ्नो लुगा धुनु पर्छ अनि पानीमा नुहाउनु पर्छ। साँझसम्म ऊ अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","यदि एकजना मानिस कुनै चीजमाथि बस्छ जसमा स्राव भएको मानिस बसेको थियो, उसले आफ्नो लुगा धुनु पर्छ अनि पानीमा नुहाउनु पर्छ। साँझसम्म ऊ अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","यदि एकजना मानिसले प्रेमह भएको मानिसलाई छुन्छ, उसले आफ्नो लुगा नुहाएपछि धुनु पर्छ अनि ऊ बेलुकीसम्म आफू अशुद्ध रहने छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","यदि यस्तो रोगीले कुनै मानिसलाई थुक्यो भने, उसले पानीमा नुहाएर आफ्नो लुगा धोओस् अनि साँझसम्म अशुद्ध रहने छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","त्यो धातुको रोग लागेको मानिस जसमा चढ्छ त्यो अशुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","कुनै पनि चीज यदि त्यो रोगी तल रहन्छ अनि उसले छुन्छ भने त्यो अशुद्ध बनिन्छ। जो मानिसले त्यो चीज बोके उसले नुहाएर आफ्नो लुगा धुनुपर्छ अनि साँझसम्म त्यो मानिस अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","यदि प्रमेह हुने मानिसले कसैलाई हात नधोइ छुन्छ, तब मानिस जो छुइन्छ यो आशुद्ध हुन्छ अनि त्यस मानिसले आफ्नो लुगा धुनु पर्छ, नुहाउनु पर्छ अनि साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“यदि प्रमेह हुने मानिस माटोको भाँडा छुन्छ, यसलाई फुटाउनु पर्छ अनि काठको भाँडा पानीले पखाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“जब त्यो रोगी निको हुन्छ, उसले आफ्नो शुद्धिको निम्ति सात दिन पर्खियोस्, आफ्नो लुगा धोओस् अनि ताजा पानीले नुहाओस् अनि त्यो शुद्ध हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","आठौं दिन दुइवटा परेवा अथवा ढुकुर लिएर ऊ परमप्रभुअघि आउनु पर्छ अनि ती सबै पूजाहारीलाई भेट हुने पालको प्रवेशद्वारमा दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","पूजाहारीले दुइवटा चराहरू चढाउनु पर्छ। एउटा पाप बलिको निम्ति अनि अर्को होमबलिको निम्ति चढाउनु पर्नेछ। यस तरीकामा, पूजाहारीले प्रमेह हुने मानिसलाई परमप्रभुअघि शुद्ध बनाउने छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“यदि कुनै पुरूषको स्वतः वीर्य पतन भए उसले आफ्नो शरीर पानीमा नुहाओस् अनि ऊ साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","लुगा अथवा छाला जसमा वीर्य झर्छ धुनु पर्छ अनि ऊ बेलुकीसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","यदि कुनै स्त्रीसँग सुतेको बेला पुरूषको वीर्य पतन भए ती दुवैले नुहाऊन् अनि साँझसम्म अशुद्ध रहनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“यदि एकजना स्त्रीको मासिक रजस्वला नियमित छ उसको रजस्वलाको अशुद्धता सात दिनसम्म रहनेछ। यदि कसैले उसलाई छुन्छ, ऊ सात दिनसम्म अशुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","एउटी स्त्रीको रजस्वला भएको समयमा त्यो जुन चीजहरूमा बस्छिन् अनि सुत्छिन् ती सब अशुद्ध हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","कसैले ऊ सुतेको ओछ्यान छोए, त्यसले आफ्नो लुगा धुनुपर्छ, आफूले पनि नुहाउनुपर्छ अनि साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","यदि कुनै मानिसले ऊ बसेको कुनै चीज छोए, उसले आफ्नो लुगा धुनुपर्छ, नुहाउनु पर्छ अनि साँझसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","कसैले त्यो रजस्वाला स्त्री बसेको कुनै चीज छोए उसले आफ्नो लुगा धोओस र साँझसम्म आफैं पनि अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“कुनै स्त्री रजस्वला भएको समय कसैले ऊसित सहवास गरे त्यो पुरूष सात दिनसम्म अशुद्ध हुन्छ। त्यो पुरूष सुतेको प्रत्येक ओछ्यान नै अशुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“कुनै स्त्रीको आफ्नो नियमित समय बाहेक धेरै दिनसम्म रजस्वला भइरहे, अथवा नियमित रजस्वलापछि पनि रगत प्रवाह रहे, नियमित रजस्वला भए, ऊ अशुद्ध हुन्छे। ऊ जब सम्म रजस्वला रहन्छ त्यतिञ्जेलसम्म अशुद्ध रहनेछिन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","मासिक रजस्वलाको समयमा जुन ओछ्यानमा त्यो स्त्री सुतछिन् त्यो ओछ्यान पनि त्यतिञ्जेलसम्म अशुद्ध रहन्छ। उसको मासिक रजस्वला हुँदा अशुद्ध भए, उसले छुन्छिन् त्यो चीज अशुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","मानिससम्म अशुद्ध हुन्छ जसले ती चीजहरू छुन्छ। मानिसले आफ्नो लुगा धुनुपर्छ। अनि पानीमा नुहाएपछि, साँझसम्म अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","त्यस स्त्रीले उसको रजस्वला रोकिएपछि सात दिनसम्म पर्खनुपर्छ। त्यसपछि त्यो स्त्री शुद्ध हुन्छे। ");
INSERT INTO npi2010_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","तब आठौं दिनमा स्त्रीले दुइवटा ढुकुर अथवा परेवा लिनुपर्छ र तिनीहरू पूजाहारीकहाँ भेट हुने पालको प्रवेशद्वारमा लैजानुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","तब पूजाहारीले ती दुइवटा मध्ये एउटालाई पापबलिको निम्ति अनि अर्कोलाई होमबलिको निम्ति चढाउनुपर्छ। यसरी पूजाहारीले उसलाई परमप्रभुको सामुन्ने शुद्ध पार्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“यसर्थ तिमीले इस्राएलका मानिसहरूलाई अशुद्ध भएको विषयमा सतर्क गराउनु पर्छ। यदि तिमी ती मानिसहरूलाई चेताउनी दिंदैनौ भने तिनीहरूले मेरो पवित्र पाललाई अशुद्ध पार्न सक्छन् तब तिनीहरू मर्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","वीर्य पतन भएकाहरूको निम्ति यी नै विधिहरू हुन्। यी विधिहरू वीर्य पतन हुँदा जो अशुद्ध हुन्छन् तिनीहरूको निम्ति पनि हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","अनि यी विधिहरू आफ्नो मासिक रजस्वलाबाट अशुद्ध हुने स्त्रीहरूको निम्ति हुन्। अनि अशुद्ध स्त्रीहरूसँग सुतेर जो मानिसहरू अशुद्ध बनिन्छन् उनको निम्ति यी विधिहरू हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","हारूनका छोराहरू मध्ये दुई जना परमप्रभुलाई धूप चढाउँदै गर्दा मरे। त्यस समयपछि परमप्रभुले मोशालाई भन्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","परमप्रभुले भन्नुभयो, “तेरो दाज्यू हारूनलाई भन। उसलाई सम्झाऊ उसको इच्छा अनुसार जतिबेला चाह्यो त्यतिबेला पर्दा पछाडी महा-पवित्रस्थान जहाँ पवित्र सन्दूक राखिएको छ त्यहाँ कहिले पनि नजाऊन। यस पवित्र सन्दूकमाथि भएको कृपा-आसन छ अनि म त्यो कृपा-आसनमाथि बादलमा दर्शन दिन्छु। यदि हारून त्यस कोठामा गए ऊ मर्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“महापवित्र स्थानभित्र पस्नु भन्दाअघि हारूनले यसै गर्नु पर्छ। हारूनले पापबलिको निम्ति एउटा साँढे र होमबलिको निम्ति एउटा भेडा चढाउँनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","हारूनले आफ्नो सारा शरीर पानीले पखाल्नु पर्छ। तब उसले यी वस्त्रहरू धारण गर्नुपर्छः उसले लिनिनको पवित्र वस्त्र धारण गर्नु पर्छ। उसले लिनिनको भित्री लुगाहरू पनि लगाउनु पर्छ। उसले आफ्नो टाउकोमा लिनिनको फेटा र कम्मरमा लिनिनको पटुका कस्नु पर्छ। यी वस्त्रहरू पवित्र हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“हारूनले दुइवटा पाठाहरू पापबलिको निम्ति लानु पर्छ अनि एउटा भेडी होमबलिको निम्ति इस्राएलका मानिसहरूबाट लिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","तब हारूनले पापबलिको निम्ति साँढे चढाउनु पर्छ। पापबलि ऊ आफ्नै निम्ति हो। हारून आफ्नो परिवार र आफैंई पवित्र पार्नु उसले यसो गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“तब हारूनले दुइवटा बोकाहरू भेट हुने पालको ढोकामा परमप्रभुअघि ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","हारूनले ती दुईवटा बोकाहरू माझ चिठ्ठा लगाउँछ, एउटा परमप्रभुको निम्ति हुन्छ र अर्को मानिसहरूको दोष निवारणको निम्ति छाडा छोडनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“चिठ्ठामा परेको बोकालाई हारूनले पापबलिको निम्ति परमप्रभुलाई चढाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","दोष निवारणको निम्ति चिठ्ठा परेको बोकालाई हारूनले परमप्रभुअघि ल्याई मरूभूमिमा खुला छाडिदिनेछ। यो मानिसहरूलाई शुद्ध बनाउनको लागि हो। ");
INSERT INTO npi2010_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“त्यसपछि हारूनले आफ्नो निम्ति पापबलि का लागि साँढे चढाउँछ, उसले आफ्नो परिवार र आफूलाई पवित्र पार्छ। उसले आफ्नो पापबलिको निम्ति साँढे मार्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","त्यसपछि परमप्रभुको अघि वेदीबाट हारूनले पर्दाको पछि कोठामा कोइला भरेको कराही ल्याउनु पर्छ अनि उसले धुलो पारेर पिंधेको दुई मुठ्ठी सुगन्धित धूप ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","परमप्रभुअघि उसले धूप आगोमा हाल्नु पर्छ। तब धूपको धूवाँले करारमाथि विशेष आवरणको रूपमा ढाक्ने छ। यस प्रकार हारून मर्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ऊ साँढेको केही रगत औंलाले लिन्छ अनि यसलाई विशेष आवरणमाथि छर्कन्छ। उसले आफ्नो औंलोले रगत विशेष आवरणअघि सात पटक छर्कने छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“तब हारूनले मानिसहरूकोलागि पापबलिको बलि दिनेछ। हारूनले पर्दा पछाडीको कोठामा बोकोको रगत ल्याउनु पर्छ। उसले साँढेको रगतले जे गरेको थियो बोकाको रगतले पनि त्यसै गर्नु पर्छ। उसले विशेष आवरणअघि अनि माथि बोकाको रगत छर्कनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","यसरी हारूनले महा पवित्रस्थान शुद्ध पार्ने काम गर्छ। इस्राएलका मानिसहरूलाई शुद्ध पार्न हारूनले यी सब कार्य गर्नु पर्छ। तिनीहरूले धेरै पापहरू गर्छन् र तिनले भेट हुने पालको निम्ति पनि यस्तो कार्यहरू गर्नु पर्छ कारण यो धेरै अशुद्ध मानिसहरूमाझमा छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“हारून महा पवित्र स्थानमा यसलाई अनि मानिसहरूलाई शुद्ध पार्न गएको समयमा भेट हुने पालमा कोही मानिस पनि नहोस्। जबसम्म हारून बाहिर आउँदैन तबसम्म त्यहाँ कोही मानिस नजाऊन्। यसकारण, हारून र उनको परिवार शुद्ध होऊन। अनि इस्राएलका सम्पूर्ण मानिसहरूलाई उनले शुद्ध पार्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","तब हारून बाहिर परमप्रभुकोअघि वेदी समक्ष यसलाई शुद्ध पार्नु जाने छन्। साँढे अनि बोकाको अलिकति रगत लिने छन् अनि वेदीको सबै कूनाहरूमा घस्ने छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","तब उनले ओंलाले वेदीमा सात पल्ट रगत छर्कने छन्। यसरी उहाँ वेदी शुद्ध पार्ने छन् किनभने इस्राएलका मानिसहरूले यसलाई अशुद्ध बनाएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“यसर्थ, हारूनले महा पवित्र स्थान, भेट हुने पाल अनि वेदी शुद्ध पार्नेछन्। त्यसपछि हारूनले परमप्रभुको निम्ति जिउँदो बोका ल्याउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","जिउँदो बोका माथि हात राखेर उसले सबै पापहरू, सबै अपराधहरू अनि इस्राएली मानिसहरूले गरेको सबै भूल कर्महरू स्वीकार गर्नेछन्। यसरी मानिसहरूको सबै पाप बोकामाथि राखेर उसले त्यसलाई मरूभूमिमा जानु छाडिदिने छन्। एकजना मानिस बोकालाई मरूभूमितिर लिएर जान पर्खिरहेको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","यसर्थ बोकाले मानिसहरूको सबै पापहरू एकान्त ठाउँमा बोकेर लैजाने छ। मानिस जसले बोकालाई लिएर जान्छ, उसले यसलाई मरूभूमिमा छोड्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“त्यसपछि हारून भेट हुने पालमा जान्छन् अनि महापवित्र स्थानमा जाँदा लगाएको स्‌तीको लुगाहरू फूकाल्नु पर्छ। उनले ती लुगाहरू त्यही छोड्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","उसले पवित्रस्थानमा आफ्नो शरीर पानीले पखाल्ने छ। तब उसले आफ्नो लुगाहरू लगाउने छ। ऊ बाहिर आउने छ अनि ऊ आफ्नै निम्ति र मानिसहरूको निम्ति होमबलि चढाउने छ। यस तरीकाले ऊ आफैं अनि मानिसहरूको निम्ति उसले प्रयाश्चित बनाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","तब तिनले पापबलिको बोसो वेदीमा जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“मानिस जसले बोका लिएर जान्छ, पानीमा आफ्नो शरीर पखाल्नु पर्छ अनि आफ्नो लुगा धुनु पर्छ। त्यसपछि छाउनी भित्र आउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“पवित्र चीजहरू शुद्ध पार्न महा पवित्रस्थानमा ल्याइएका पापबलिको साँढे र बोकोलाई पाल बाहिर ल्याउनु पर्छ। पूजाहारीले तिनीहरूको छाला, शरीर र गोबर आगोमा जलाउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","त्यसपछि त्यो जलाउने मानिसले आफ्नो लुगा अनि शरीर पानीमा पखाल्नु पर्छ। त्यसपछि तिनी छाउनीमा आउन सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“यो विधि तिमीहरूको निम्ति सदा-सर्वदा चलिरहने छ। सातौं महीनाको दशौं दिन, तिमीहरूले भोजन लिनु हुँदैन। तिमीहरूले कुनै काम गर्नु हुँदैन। तिमीहरूको देशमा बस्ने यात्रीहरू अथवा विदेशीहरू कसैले पनि कुनै काम गर्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","किन? किनभने, यसदिन पूजाहारीले तिमीहरूलाई नुहाई दिनेछन् अनि पवित्र पार्नेछन्। तब तिमीहरू परमप्रभुको सामुन्ने शुद्ध हुनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","त्यो दिन तिमीहरूको महत्वपूर्ण साबात दिन हो। तिमीहरूले कुनै खाद्य खानु हुदैन। यो नियम सधैं चलिरहने छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“यसर्थ प्रधान पूजाहारी हुन अभिषेक भएको मानिसले सब चीजहरू पवित्र पार्ने काम गर्नेछन्। आफ्नो बाबुका उत्तराधिकारी तिनै हुन्। ती पूजाहारीले पवित्र सुती लुगा लगाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","उनले महा-पवित्र स्थान, भेट हुने पाल अनि वेदी शुद्ध पार्नु पर्छ। अनि सबै पूजाहारीहरू र इस्राएलका मानिसहरूलाई शुद्ध पार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","इस्राएलका मानिसहरूलाई शुद्ध पार्ने विधि सदा सर्वदा चलिरहनेछ। तिमीहरूले वर्षमा एक चोटी यी सबै कार्यहरू गर्नु पर्छ। किन? किनभने इस्राएलका मानिसहरूको पाप कर्मले गरेको थिए।” यसर्थ परमप्रभुले मोशालाई दिनुभएको आज्ञा अनुसार तिनीहरूले कामहरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“हारून, तिनका छोराहरू र इस्राएलका समस्त मानिसहरूलाई भन। तिनीहरूलाई भन, परमप्रभुले दिनुभएको आज्ञा यही हो। ");
INSERT INTO npi2010_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","इस्राएलीहरूले एउटा साँढे एउटा पाठो अथवा एउटा बोका पालको बाहिर अथवा भित्र काट्नु सक्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","त्यस मानिसले भेट हुने पालको ढोकामा पशुलाई ल्याउनुपर्छ। उसले पशुको एक भाग परमप्रभुलाई उपहार चढाउनुपर्छ। पशु मारेपछि उसले परमप्रभुलाई उपहार स्वरूप एक भाग चढाउनै पर्छ। यदि उसले परमप्रभुलाई यसको एक भाग उपहार चढाउँदैन भने त्यस मानिसलाई आफ्ना मानिसहरूबाट छुट्‌याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","यो विधि यसकारण बनाइएको हो जसले गर्दा इस्राएलका मानिसहरूले आफ्नो मेलबलि परमप्रभुलाई चढाउन्। तिनीहरूले मैदानमा मारेको पशु परमप्रभुकहाँ भेट हुने पालको ढोकोमा ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","तिनीहरूले पूजाहारीकहाँ ल्याउनु पर्छ र पूजाहारीले ती पशुहरूको रगत भेट हुने पालको ढोकामा परमप्रभुको वेदीमा छर्किनु पर्छ र पशुहरूको बोसो पूजाहारीले वेदीमा जलाओस् जसले गर्दा यसको सुगन्धले परमप्रभुलाई आनन्दित तुल्याओस्। ");
INSERT INTO npi2010_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","अब उसो तिनीहरू ‘बोका मूर्तिहरूलाई’ आफ्नो बलि चढाउने छैनन्। तिनीहरू अरू देवताहरूको पछि लागेका छन्। त्यसरी तिनीहरूले वेश्याहरू सरह आचरण गरे। यी नियमहरू सधैंका लागि चल्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“मानिसहरूलाई भन कोही इस्राएली अथवा तिमीहरूसँग बस्ने कोही विदेशीले होमबलि वा बलिदान चढाउन सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","तर यदि ऊ यो चढाउँछ, तब उसले आफ्नो बलि भेट हुने पालको प्रवेशद्वारमा परमप्रभुसमक्ष उपहारको रूपमा लानु पर्छ। यदि ऊ यसो गर्दैन, उसलाई आफ्ना मानिसहरूबाट छुट्‌याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“इस्राएलीहरू मध्ये कसैले ऊ नागरिक होस् अथवा यात्री विदेशी जो तिमीहरूसंग रगत खान्छ, म उसको विरूद्ध रहनेछु अनि म उसलाई आफ्ना मानिसहरूबाट छुट्याउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","किन? किनभने शरीरको प्राण रगतमा हुन्छ मैले यो तिमीहरूलाई वेदीमा आफूलाई शुद्धपार्न दिएकोछु, कारण रगतले नै मानिसहरूलाई शुद्ध पार्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","यसर्थ म इस्राएलीहरूलाई भन्दछु तिमीहरू मध्ये, कसैले चाहे, स्वदेशी होस् अथवा विदेशी जो तिमीसँग वास गर्छ उसले रगत खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“इस्राएलको कुनै पनि मानिस त्यो नागरिक होस् अथवा विदेशी, जो सुकै होस्, यदि उसले खानु हुने पशु अथवा चरा समाते; उसले त्यसको रगत भूइँमा खन्याएर धुलोले छोपोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","तिनीहरूले किन यस्तो गर्नैपर्छ? किनभने, यदि मासुमा रगत छ, प्राणीमा प्राण अझै विद्यमान छ। यसर्थ म इस्राएलीहरूलाई आदेश दिन्छु तिनीहरूले कुनै मासु खानु हुँदैन जसमा रगत हुन्छ। जुन मानिसले रगत खान्छ, यसलाई छुट्‌याइन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“यदि कुनै मानिसले आफैं मरेको पशुको मासु खान्छ, अथवा अन्य कुनै पशुले मारेको पशुको मासु खान्छ त्यो मानिस साँझसम्म अशुद्ध रहनेछ। त्यो मानिस स्वदेशी होस् अथवा विदेशी, यदि तिमीहरूको माझमा भए उसले आफ्नो लुगाहरू धुनैपर्छ अनि शरीर सम्पूर्ण नुहाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","यदि त्यस मानिसले आफ्नो लुगाहरू धुँदैन अनि शरीर सम्पूर्ण नुहाउदैन भने ऊ पापको दोषी बनिनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","परमप्रभुले मोशालाई भननुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएलीहरूलाई भन म तिमीहरूका परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","बितेका दिनहरूमा तिमीहरू मिश्रदेशमा थियौ मिश्रीहरूले त्यो देशमा गरिरहेका छन्। म तिमीहरूलाई कनान देशमा लैजाँदैछु यसर्थ तिमीहरूले त्यस्तो केही नगर जे त्यस ठाउँमा ती मानिसहरू गर्छन्। तिनीहरूको दस्तुर नमान्नु। ");
INSERT INTO npi2010_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","तिमीहरूले मेरो विधि-विधानहरू मान्नुपर्छ र ती विधानहरूको अनुसरण गर। किन? किनभने, म परमप्रभु तिमीहरूका परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","यसकारण, तिमीहरूले मेरो विधि-विधानहरू पालन गर्नैपर्छ। जुन मानिसले यी विधि-विधानहरू पालन गर्छ, यहाँ तिनीहरू यस द्वारा बाँच्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“तिमीहरूले आफ्नो नजिक को आफन्तहरुसंग सहवास गर्नु हुँदैन। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“तैले तेरी आमासित लैंगिक सम्बन्ध राख्नु हुँदैन। यसले तेरा बुबालाई लाजमर्दो बनाउनेछ। तिनी तेरी आमा हुन् यसकारण तैंले तिनीसंग लैंगिक सम्बन्छ गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","यदि उनी तिम्री आमा नभए पनि तिम्रा बाबुकी स्वास्नी भएकीले तिमीले उनीसित सहवास गर्नु हुँदैन। किन? किनभने त्यो तिम्रा बाबुसित सहवास गरे जस्तै हो। ");
INSERT INTO npi2010_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“बहिनी आमापट्टिको होस् अथवा बाबुपट्टिको अथवा उनी तिम्रै घरमा जन्मिएको होस् अथवा बाहिरबाट नै आएकी होस्, उनीसित तिमीले सहवास गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“तिम्री नातिनी तिम्रै परिवारको एउटा अंश हो यसर्थ तिमीले ऊसँग लैंगिक सम्बन्ध राख्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“तिम्रा बाबु र उनकी स्वास्नीकी छोरी भए ऊ तिम्री बहिनी हो, तिमीले ऊ सित सहवास गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“तिम्रा बुबाकी दिदी-बहिनी उनको नजिककी आफन्त हुन्। यसर्थ तिनीहरूँग तिमीले लैंगिक सम्बन्ध राख्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","तिम्री आमाकी बहिनी-दिदी उनको अति नजिकको सम्बन्धी हुन्, यसर्थ उनीसित तिमीले सहवास गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","तिमीले तिम्रा बुबाका दाज्यू-भाईलाई उनकी स्वास्नीसित लैंगिक सम्बन्ध राखेर अपमान गर्नु हुँदैन किनभने तिनी तिमीहरूकी काकी हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“तिमीले तिम्री बुहारीसित लैंगिक सम्बन्ध राख्नु हुदैन तिनी तिम्रो छोराको स्वास्नी हुन्। तिमीले ऊसित लैंगिक सम्बन्ध राख्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“तिमीले आफ्नो भाउज्यूसित लैंगिक सम्बन्ध राख्नु हुँदैन, कारण यसो गर्छौ भने यो तिमीले आफ्नो दाज्यू भाईसित लैंगिक सम्बन्ध राखेको जस्तो हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“आमा र उसकी छोरीसित तिमीले सहवास नगर। अनि यी आमाकी नातिनी हो चाहे उसको छोराकी छोरी होस्। ऊसित सहवास नगर। नातिनीहरू तिनको नजिकको सम्बन्धी हुन् र तिनीहरूसित सहवास गर्नु हुँदैन। उनीहरूसित सहवास गर्नु गलत हो। ");
INSERT INTO npi2010_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“जब तिम्री स्वास्नी अझै जीवित नै छिन् भने तिमीले उसकी दिदी बहिनीसित सहवास गर्नु हुँदैन, आफ्नी स्वास्नी जीवित रहे उसकी बहिनीलाई बिहे गर्नु हुँदैन कारण ती दिदी-बहिनीमा शत्रुता हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“तिमीले रजस्वला भएको समयमा एकजना स्रीसँग शारिरिक सम्बन्ध राख्न तिनको छेउमा जानु हुदैन किनभने त्यस समयमा तिनी अशुद्ध हुन्छिन्। ");
INSERT INTO npi2010_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“अनि तिमीले आफ्नो छिमेकीकी स्वास्नीसित पनि सहवास गर्नु हुँदैन यसले तिमीलाई अशुद्ध बनाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“तिमीले आफ्नो छोरा-छोरी आगोद्वारा मोलेकलाई नचढाऊ। यदि तिमीले यसो गर्छौ भने यसले बुझाउछ कि तिमीले आफ्ना परमेश्वरको नाउँलाई बदनाम गरिरहेका छौ। म तिम्रो परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“तिमीले स्त्रीसित जस्तै मानिससित सहवास नगर। त्यो घोर पाप हो। ");
INSERT INTO npi2010_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“कुनै पशुसित सम्भोग नगर। यसले तिमीलाई अशुद्ध पार्छ। स्त्री जातिले पनि पशुसित सम्भोग गर्नु हुँदैन कारण यो अस्वाभाविक दुराचार हो। ");
INSERT INTO npi2010_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“तिमीहरू आफैं त्यस्ता अधर्म कर्महरू नगर कारण म त्यस्ता अधर्म कर्म गर्नेहरूलाई तिनीहरूको देशबाट निकाल्दैछु। ");
INSERT INTO npi2010_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","तिनीहरूले आफ्नो भूमिलाई त्यसरी अशुद्ध बनाएको कारण अहिले त्यो भूमिले आफ्ना मानिसहरूलाई उच्छेद गरिरहेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“यसर्थ तिमीहरूले मेरा विधि-विधानहरू मान्नुपर्छ र तिमीहरूले कुनै पनि त्यस्ता अधर्म पाप कर्म गर्नु हुँदैन। यी विधानहरू इस्राएलीहरूका निम्ति हुन्, अनि यी नियमहरू तिमीहरूसँगै त्यहाँ बस्नेहरूका निम्ति पनि हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","त्यो भूमि अशुद्ध भएको छ कारण त्यहाँ पहिलेका बासिन्दाहरूले त्यस्ता घोर पाप कर्महरू गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","यदि तिमीहरूले पनि त्यसै गर्यौ भने ती पहिलेका मानिसहरूलाई जसरी त्यो भूमिले हटाएको थियो तिमीहरूलाई पनि हटाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","यदि कुनै मानिसले त्यस्तो घोर पाप कर्म गरे त्यस मानिसलाई उसको आफन्तहरूबाट अलग गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","अन्य मानिसहरूले त्यस्तो अधर्म पाप कर्म गरेका थिए। तर तिमीहरू मेरो विधि-विधानहरू पालन गरेर बस अनि त्यस्ता अधर्म पाप कर्महरू कुनै पनि नगर। ती पाप कर्महरू गरेर आफैंलाई अशुद्ध नपार, म परमप्रभु तिमीहरूका परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“इस्राएलका सबै मानिसहरूलाई भनः म परमप्रभु तिमीहरूको परमेश्वर हुँ। तिमीहरू सबै पवित्र होऊ, कारण म पवित्र छु। ");
INSERT INTO npi2010_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“तिमीहरू मध्ये प्रत्येकले आफ्नो आमा-बाबुलाई सम्मान गर्नुपर्छ अनि विश्रामको दिन पालन गर्नुपर्छ। म परमप्रभु तिमीहरूको परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“मूर्तिहरूको पूजा नगर अनि आफ्नो निम्ति धातु पगालेर देवताहरूको मूर्तिहरू नबनाऊ। म परमप्रभु तिमीहरूका परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“जब तिमीहरूले परमप्रभुलाई मेलबलि चढाउछौ, तिमीहरूले रीतिपूर्वक त्यो चढाउनुपर्छ जसले गर्दा तिमीहरूले चढाएको परमप्रभुले ग्रहण गरून। ");
INSERT INTO npi2010_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","तिमीले यसलाई त्यही दिन खान सक्छौ जुन दिन तिनीहरू यसकाई चढाउँछौ। अनि अर्को दिन पनि खान सक्छौ। तर यदि कुनै बलि तेस्रो दिनसम्म रहेको छ भने यसलाई आगोमा जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","तेस्रो दिनसम्म रहेको बलि अशुद्ध हुन्छ, यसर्थ त्यो खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","यदि कुनै मानिसले यसलाई खान्छ त्यो मानिस पापको दोषी हुन्छ किनभने उसले परमप्रभुको पवित्र चीजहरूको सम्मान गरेको हुँदैन। त्यस मानिसलाई आफ्ना मानिसहरूबाट छुट्‌याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“जब तिमीहरू बाली उठाउने समय भएपछि आफ्नो बाली काट्छौ, खेतको आखिरी कुनासम्म नकाट अनि उठाउँदा भूँईमा झरेको अन्न नटिप। ");
INSERT INTO npi2010_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","जब तिमीहरू अंङ्गूरको बोटबाट अंङ्गूर टिप्छौ, सबै अंङ्गूर न टिप अथवा झरेको अंङ्गूर नटिप। तिनीहरूको भूमिमा भएका गरीब अनि विदेशीहरू निम्ति छाडी देऊ। म परमप्रभु तिमीहरूको परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“तिमीहरूले चोर्नु हुँदैन, मानिसहरूलाई ठग्नु हुँदैन अनि एकार्कामा झूठो नबोल्नु। ");
INSERT INTO npi2010_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","मेरो नाम लिएर झूटो कसम नखाऊ, यदि त्यसो गर्छौ तिमीहरूले परमेश्वरको नामलाई सम्मान नगरेको बुझिनेछ। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“तिमीहरूले आफ्नो छिमेकीसित नराम्रो काम नगर। उसलाई नलुट। तिमीहरूले कुनै हाजिरामा काम गर्ने मानिसको हाजिरा एक रातभरिको निम्ति पनि नरोक। ");
INSERT INTO npi2010_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“बहिरका मानिसलाई नसराप। अन्धालाई लडाउने हेतुले उसको बाटोमा केही नराख। आफ्ना परमेश्वरको सम्मान गर्नुपर्छ। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“न्याय गर्दा सच्चाइले गर्नुपर्छ। न्याय गर्दा गरीब अथवा दया र धनी भनी सम्मान नगर। आफ्नो छिमेकीसित न्याय गर्दा पनि सच्चाइले न्याय गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","मानिसहरूको विरूद्ध झूठा कुराहरू गरेर नहिंड्। यस्तो कुनै काम नगर् जुन तिम्रो कामले छिमेकी विपदमा पर्न सक्छ। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“तिमीले हृदयबाट आफ्ना इस्राएली मित्रलाई घृणा गर्नु हुँदैन। यदि तिम्रो छिमेकीले केही अनिष्ट गरेको छ भने उसलाई जानकारी देऊ, तिमीहरू उसले गर्दा पापको दोषी हुने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","मानिसहरूले तिमीप्रति गरेका अनिष्ट कामहरू बिर्सिदेऊ। तिम्रा छिमेकीहरूलाई आफूलाई झैं माया गर। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“तिमीहरूले मैले भनेको नियमहरू पालन गर्नैपर्छ। दुई प्रकारका पशुहरू मिसिन नदेऊ। आफ्नो खेतमा दुई प्रकारका बीउ नछर। दुई प्रकारका धागाले बनिएको लुगा नलगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“यदि कुनै मानिसले अर्काकी कमारी जो आफ्नो मालिकबाट छुट्करा पाइसकेकी छैन त्यससँग सहवास गरे तिनीहरू दुईलाई सजाय दिनुपर्छ तर मृत्युदण्ड होइन। किनभने त्यो कमारी आइमाईले आफ्नो मालिकबाट छुटकारा पाइसकेकी थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","त्यस मानिसले आफ्नो दोषबलि परमप्रभुकहाँ भेट हुने पालको ढोकामा ल्याउनुपर्छ। त्यस मानिसले दोषबलिको निम्ति भेडा ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","त्यस मानिसले पाप गरे बापत उसको पाप मोचनको निम्ती पूजाहारीले परमप्रभुअघि भेडा चढाउनेछन् त्यसपछि त्यो मानिस उसले गरेको पापहरूबाट मुक्त हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“भविष्यमा तिमी आफ्नो देशमा जानेछौ र त्यहाँ धेरै फलका बोटहरू खानको निम्ति रोप्नेछौ। तर तीन वर्षसम्म तिमीले ती बोटहरूबाट फल प्रयोग गर्न पाउने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","चौथो वर्षमा फलेका फलहरू परमप्रभुमा प्रशंसाको निम्ती हुनेछन्। यी फलहरू परमप्रभुको निम्ति पवित्र बलि हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","त्यसपछि पाँचौ वर्षमा फलेको फलहरू तिमीहरू खान सक्छौ। यदि तिमीहरूले यसो गर्छौ बोटहरूले धेरै फल फलाउने छन्। म परमप्रभु तिमीहरूको परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“यदि कुनै मासुमा रगत रहेको छ भने तिमीले त्यो मासु खानु हुँदैन। “भविष्यको विषयमा बताउँदा तन्त्र-मन्त्र अथवा जादू प्रयोग नगर। ");
INSERT INTO npi2010_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“तिम्रो अनुहारको छेउमा बढेको कपाल नकाट अनि तिम्रो दाह्रीको छेऊ नछाँट। ");
INSERT INTO npi2010_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","मृत मानिसको सम्झनामा शरीरको मासु नकाट। तिम्रो आफ्नो शरीरमा कुनै छाप नबनाउन्। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“तिम्रो छोरीलाई वेश्या बनाएर अपमान नगर। तिम्रो देशलाई यस्ता पापहरूद्वारा भरिन नदेऊ अनि देशमा मानिसहरूलाई वेश्या हुने अनुमति नदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“तिमीले विश्रामका दिनहरूमा काम नगर। तिमीले मेरो पवित्रस्थानको आदर गर्नुपर्छ। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“तिमीहरू झाँक्री-जादूगर बोक्सी तथा मन्त्र गर्नेतिर नलाग अनि आफैंलाई तिनीहरूबाट अशुद्ध नपार। म तिमीहरूको परमप्रभु परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“बूढा-पाका मानिसहरूलाई उभिएर सम्मान गर जब तिनीहरू तिम्रो एउटा कोठामा अथवा घरभित्र पस्छन्। आफ्ना परमेश्वरको डर अनि सम्मान गर। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“तिमीहरूको आफ्नो देशमा बसोबासो गर्ने विदेशीहरूसित दुर्व्यवहार नगर। विदेशीहरूलाई र देशवासीहरूलाई समान व्यवहार गर, ");
INSERT INTO npi2010_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","तिनीहरूलाई माया गर जस्तो आफूलाई गर्छौ किनभने तिमीहरू पनि मिश्रको भूमिमा विदेशी थियौ। म परमप्रभु तिमीहरूको परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“तिमीले मानिसहरूलाई सच्चाइसँग न्याय गर। जब तिमी केही चीज नाप्छौ अनि तौलिन्छौ निष्पक्षतापूर्वक नाप अनि तौल। ");
INSERT INTO npi2010_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","तिमीसित तौलिन ढक तराजू र नाप, र तौलहरू ठीक हुनुपर्छ। म परमप्रभु तिमीहरूको परमेश्वर हुँ। मैले तिमीहरूलाई मिश्रदेशबाट बाहिर ल्याएँ। ");
INSERT INTO npi2010_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“तिमीहरूले मेरो विधि-विधानहरू सबै जानेर पालन गर्नुपर्छ। म परमप्रभु हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“तिमीले इस्राएलीहरूलाई यी कुराहरू भन्नुपर्छ इस्राएलीहरू मध्ये कोही पनि होस् देशी अथवा विदेशी, तिनीहरू मध्ये कसैले आफ्ना नानीहरूबाट एक जनालाई मिथ्या देवता मोलेकलाई दिन्छ भने उसलाई मार्नैपर्छ। यस देशका मानिसहरूले उसलाई ढुङ्गले हिर्काएर मार्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","म त्यस मानिसको विरोधमा हुनेछु। उसलाई म आफ्ना मानिसहरूबाट छुट्‌याउनेछु। किन? किनभने उसले आफ्ना नानीहरू मोलेकलाई दिन्छ अनि यसरी मेरो पवित्र नामको सम्मान गरेन अनि मेरो पवित्र स्थानलाई अशुद्ध बनाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","जब त्यस मानिसले मोलेकलाई आफ्नो नानी दिन्छ समुदायका मानिसहरूले उसलाई ध्यान दिदैनन् अनि उसलाई मार्दैनन्, ");
INSERT INTO npi2010_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","म त्यस मानिसलाई साथै त्यसको परिवारलाई विरोध गर्नेछु। म तिनलाई तिनको आफ्नै मानसिहरूबाट अलग गर्नेछु। ती सबै मानिसहरू जो मोलेकको पूजा गर्न प्रभावित भएका थिए, म तिमीहरूलाई तिमीहरूको आफ्नै मानिसहरूबाट अलग गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“कुनै मानिस जो सल्लाह लिनु झाँक्री अथवा जादूगर कहाँ जान्छ, उसले मलाई अविश्वास गर्दैन यसर्थ म उसलाई आफ्ना मानिसहरूबाट छुट्‌याउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“तिमी आफैंलाई पवित्र बनाऊ अनि पवित्र भएर बस। किनभने, म परमप्रभु तिमीहरूका परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","मेरा विधिहरू सम्झना गर अनि तिनीहरूलाई अनुसरण गर। म तिमीहरूको परमप्रभु हुँ जसले तिमी सबै मानिसहरूलाई पवित्र बनाउँछु। ");
INSERT INTO npi2010_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“यदि कुनै मानिसले आफ्नो आमा अथवा बाबुलाई सराप दिन्छ भने त्यास मानिसलाई मारिनुपर्छ। जब उसले आफ्नो आमा-बाबुलाई सराप दिएको कारण उसको मृत्युको जिम्मावारी ऊ आफैं हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“यदि कुनै मानिसले आफ्नो छिमेकीकी स्वास्नीसित सहवास गरे ती दुवैलाई मार्नुपर्छ कारण ती दुवैजना व्यभिचारको दोषी हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","यदि कुनै मानिसले आफ्नो बाबुकी स्वास्नी (सौतेनी आमा) सँग सहवास गर्छ भने ती दुवै जनालाई मारिनुनै पर्छ, आफ्नो मृत्युको निम्ति तिनीहरू स्वयं जिम्मेवार हुन्। यो त्यस मानिसले आफ्नै बाबुसित सहवास गरे झैं हो। ");
INSERT INTO npi2010_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“यदि कुनै मानिसले आफ्नो छोरा बुहारीसित सहवास गरे ती दुइजनालाई मार्नैपर्छ। तिनीहरू आफैं तिनीहरूको मृत्युको निम्ति जिम्मेवार छन् कारण तिनीहरूले खुबै अधम व्यभिचार गरेका हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“यदि एकजना मानिसले अर्को पुरूषसँग स्त्रीसँग झैं सहवास गरे, तिनीहरूले भयंकर पाप गरेको बुझिन्छ। तिनीहरूलाई मार्नै पर्छ र तिनीहरू स्वंय आफ्नो मृत्युको निम्ति जिम्मेवार हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“यदि एकजना मानिसले आमा र छोरी दुवैसँग शारिरिक कर्म गर्छ यो व्यभिचार पाप हो। तिमीले मानिसहरूमा यस्तो व्यभिचार हुन दिनु हुँदैन। तिमीले मानिस अनि स्त्री दुवैलाई आगोमा जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“यदि कुनै मानिसले पशुसँग सम्भोग गरे त्यस मानिस र पशुलाई मार्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","यदि कुनै स्त्री पशुसँग सम्भोग गरे त्यस स्त्री र पशुलाई मार्नु र्पछ। तिनीहरू आफ्नो मृत्युको निम्ति आफैं जिम्मेवार हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“यदि कुनै दाज्यूभाई आफ्नी बहिनी अथवा सौतेनी बहिनीसित लैंगिक कर्म गर्छ, यो लाजमर्दो कुरा हो। तिनीहरूलाई जनताअघि दण्ड दिनुपर्छ र आफ्ना मानिसहरूबाट छुट्‌याउनु पर्छ। आफ्नी दिदीबहिनीसित जुन मानिसले शारिरिक कर्म गर्छ उसलाई उसको पापको निम्ति दण्ड दिनैपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“यदि कुनै मानिस रजस्वलाको समयमा स्त्रीसित लैंगिक सम्बन्ध राख्छ भने स्त्रीपुरूष दुवैलाई तिनीहरूका मानिसहरूबाट छुट्‌याउनु पर्छ। तिनको रगतको मूल देखाएर तिमीहरूले पाप गरेका छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“तिमीले आफ्नी फुपु अथवा काकीसित लैंगिक सम्बन्ध राख्नु हुँदैन यो सगोत्र सम्भोग हो र तिम्रो पापको निम्ति तिमीले दण्ड पाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“कुने मानिसले आफ्नो काकाको पत्नीसित लैंगिक सम्बन्ध राख्नु हुँदैन किनभने यसो गर्नु आफ्नो काकासित लैंगिक सम्बन्ध राखे जस्तै हो। तिनीहले पापको लागि दण्ड भोग्नैपर्छ। तिनीहरू अपुताली नै मर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“यदि कुनै पुरूषले आफ्नी भाउज्यू अथवा भाइबुहारी सित सहवास गर्छ भने त्यो अनुचित हो। यो दाज्यूसित सहवास गरे झैं नै हो। तिनीहरू अपुताली रहनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“म तिमीहरूलाई जुन देशमा लाँदैछु त्यहाँ तिमीहरू बस्नेछौ। मेरो विधि-विधानहरू सम्झना गर अनि पालन गर। यदि तिमीहरूले मेरा विधि-विधानहरू पालन गर्छौ भने तिमीहरू त्यस देशबाट निकालिने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","म त्यस देशका अरू मानिसहरूलाई बलपूर्वक बाहिर निकाल्दैछु। किन? किनभने तिनीहरूले त्यस्ता पापहरू गरे। म ती कर्महरू घृणा गर्छु, यसर्थ तिमीहरूले तिनीहरूको जीवन शैली नपछ्याऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","मैले तिमीहरूलाई पहिल्यै भनिसकेको छु म तिमीहरूलाई तिनीहरूको भूमि दिनेछु, अनि यो तिमीहरूको हुनेछ। यो भूमि दूध र महले भरिएको हुनेछ। म परमप्रभु तिमीहरूको परमेश्वर हुँ जसले तिमीहरूलाई अन्य राष्ट्रबाट छुट्टाए। “मैले तिमीहरूसित भिन्दै प्रकारले व्यवहार गरेको छु कारण तिमिहरूलाई मैले मेरो विशेष मानिसहरू बनाएको छु। ");
INSERT INTO npi2010_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","यसर्थ, तिमीहरूले शुद्ध अनि अशुद्ध पशु-पंक्षीहरूलाई भिन्नै प्रकारले व्यवहार गर्नुपर्छ। अशुद्ध पशु चराहरू अनि घस्रिने प्राणीहरू खाएर तिमीहरू आफैंलाई अशुद्ध बनाऊ मैले तिनीहरूलाई तिमीहरू निम्ति अशुद्ध झैं छुट्टाएको छु। ");
INSERT INTO npi2010_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","मैले तिमीहरूलाई मेरा विशेष मानिस बनाउनलाई तिमीहरूलाई पवित्र पारेको छु। यसर्थ तिमीहरू मेरो निम्ति पवित्र रहनुपर्छ। किन? किनभने म परमप्रभु हुँ अनि पवित्र छु। ");
INSERT INTO npi2010_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“एकजना मानिस जो झाँक्री अथवा जादूगर छ उसलाई मार्नु पर्छ। मानिसहरूले तिनीहरूलाई ढुङ्गले हिर्काएर मार्नु पर्छ। तिनीहरूलाई मृत्यु चाहिन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","परमप्रभुले मोशालाई भन्नुभयो, “यी कुराहरू हारूनका छोराहरू पूजाहारीहरूलाई भनः पूजाहारीले लाश छोएर आफैंलाई अशुद्ध पार्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","तर यदि मृतक मानिस उनको साक्खै पर्ने हो भने मात्र उनले लाश छोएर आफूलाई अशुद्ध पार्न सक्छन्। यदि मृतक मानिस उनका आमा अथवा बाबु, उनका छोरा-छोरी, दाज्यू-भाइ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","अथवा अविवाहित दिदी-बहिनी भए तिनले लाश छोएर आफैंलाई अशुद्ध पार्न सक्छन्। (कन्ये दिदी अथवा बहिनी उनको साक्खै मानिन्छ जबसम्म तिनीहरूको बिहे हुँदैन, यसर्थ तिनीहरू मरेको खण्ड पूजाहारीले लाश छोएर आफूलाई अशुद्ध पार्न सक्छन्।) ");
INSERT INTO npi2010_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","तर यदि मरेको मानिस बिहे द्वारा आफन्त पर्छ, पूजाहारीले लाशलाई छोएर त्यसले उ आफूलाई अशुद्ध बनाउन सक्दैनन्। ");
INSERT INTO npi2010_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“पूजाहारीहरूले शोक गर्न आफ्नो केश नखौराउन्, दाह्रीको कुना कुना नकाटुन् अनि शरीरमा कुनै चोट नबनाउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","पूजाहारीहरू आफ्नो परमेश्वरको नाममा सम्मान देखाउनु पर्छ। किन? किनभने तिनीहरूले परमप्रभुको निम्ति आगोद्वारा बलिहरू चढाउँछन जो तिनीहरूको परमेश्वरको निम्ति खाद्य हो। यसर्थ उनीहरू पवित्र रहनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“पूजाहारीले परमेश्वरलाई विशेष रूपले सेवा गर्छ यसकारण तिनीहरू कुनै वेश्या, कुनै अरू मानिससित सहवास गरेकी स्त्री अथवा कुनै मानिसले त्योगेकी स्त्रीसित बिहे नगरून्। ");
INSERT INTO npi2010_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","पूजाहारीलाई पवित्र व्यवहार गरिनु पर्छ। किन? किनभने तिनीहरूले परमेश्वरको निम्ति खाद्य बोक्छन् अनि म पवित्र छु। म परमप्रभु हुँ अनि म तिमीलाई पवित्र बनाउँछु। ");
INSERT INTO npi2010_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“यदि एकजना पूजाहारीकी छोरी वेश्या भई भने उसले आफ्नो सम्मान नष्ट पार्छे, आफ्नो बाबुलाई लाजमर्दो पार्छे, यसर्थ उसालाई आगोमा जलाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“प्रमुख पूजाहारी आफ्नैं दाज्यू-भाइहरूबाट छानिन्छन् अनि उनको टाउकोमा अभिषेक तेल खन्याइन्छ। यसरी उनलाई प्रमुख पूजाहारीको विशेष कार्यको निम्ति छानिन्छ। उनको वस्त्रादि पनि विशेष हुन्छ। यसर्थ उनले मानिसहरूअघि शोक गर्नु हुँदैन। उनले आफ्नो कपाल फुकाउनु हुँदैन अनि लुगा च्यात्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","यदि उनको बुबा अथवा आमा मरेको भए पनि उनी लाशको छेऊमा नजाऊन् र लाश छोएर उनले आफूलाई अशुद्ध नबाऊन्। ");
INSERT INTO npi2010_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","प्रधान पूजाहारी पवित्र स्थानबाहिर जानुहुँदैन, यदि ऊ मलामि जान्छ ऊ अपवित्र हुनेछ। तब उसले पवित्र स्थानलाई अपवित्र बनाउँछ। अभिषेक तेल उनको टाउकोमा खन्याएर उनलाई मानिसहरूबाट छुट्‌याइन्छ हो। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“प्रधान पूजाहारीले कन्ये केटीलाई बिहे गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","प्रमुख पूजाहारीले वेश्या, छुटानाम गरेकी आइमाई र विधवालाई बिहे गर्नु हुँदैन। प्रमुख पूजाहारूरीले आफ्ना मानिसहरुबाट कन्येलाई मात्र बिहे गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","यसरी उनका नानीहरूलाई अरू मानिसहरूले आदर गर्नेछन्। उनको विशेष कार्यको निम्ति म परमप्रभुले उनलाई अग्ग राखेको छु।” ");
INSERT INTO npi2010_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारूनलाई भन; यदि उनका सन्तानहरू मध्ये कसैमा कुनै शारीरिक खोट भए, उसले आफ्नो परमेश्वरलाई खाद्य चढाउने निवेदन गर्नु हुदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","कुनै मानिस जसको केही खोट भएको भए उसले पूजाहारी भएर मलाई सेवा नगरोस् मेरो निम्ति बलिहरू नल्याओस्। यस्ता मानिसहरूले पूजाहारी भएर सेवा गर्न सक्तैनन्, अन्धा मानिसहरू, लङ्गडा मानिसहरू, अनुहारमा नराम्रा दाग भएका मानिसहरू, हात अथवा खुट्टाहरू लामा-लामा भएका मानिसहरू, ");
INSERT INTO npi2010_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","हात अथवा खुट्टा भाँचिएका मानिसहरू, ");
INSERT INTO npi2010_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","कुप्रो पिठिउँ भएको, बाउन्ने, आँखाको रोग भएको, चिलाउने घाउ भएको, लुतो लागेको, संन्धिमा चोटलागेको नपुंसक मानिसहरू। ");
INSERT INTO npi2010_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“हारूनका सन्तानहरूमध्ये विकृति भएकोहुनाले परमप्रभुलाई आगोद्वारा बलिहरू चढाउन सक्दैन अनि उसले आफ्नो परमेश्वरलाई पुर्याउनु सक्दैन। ");
INSERT INTO npi2010_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","त्यो मानिस पूजाहारीको परिवारको एकजना सदस्य भएकोले गर्दा उसले आफ्नो परमेश्वरको दुवै पवित्र अनि महापवित्र खाद्य खानु सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","तर अति पवित्र स्थानमा पर्दाबाट जान सक्तैन अनि वेदीको नजिक पनि जानु सक्तैन। किन? किनभने उसलाई केही खोट लागिको छ र उसले पवित्र स्थानलाई अपवित्र पार्नु हुँदैन। म परमप्रभुले ती स्थानहरू पवित्र पारेको छु।” ");
INSERT INTO npi2010_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","यसर्थ मोशाले यी कुराहरू हारून, उनका छोराहरू अनि इस्राएलका समस्त मानिसहरूलाई भन्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून र त्यसका छोराहरूलाई भनः इस्राएलका मानिसहरूले मलाई जे चढाउँछन ती चीजहरू पवित्र हुन्छन्। ती मेरा हुन् यसकारण तिमी पूजाहारीहरूले यी चीजहरू नचलाउनु। यदि तिमीहरूले आफ्नो लागि ती पवित्र चीजहरू चलायौ भने तब तिमीहरूले मेरो पवित्र नामको आदर नगरेको बुझिन्छ। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","हारून अनि उसका छोराहरूलाई भनिदेऊ। यदि तिमीहरूका सन्तानहरूबाट कसैले यी चीजहरू छुन्छ जब त्यो मानिस अशुद्ध छ। त्यस मानिसलाई छुट्‌याउनु पर्छ। इस्राएलका मानिसहरूले ती चीजहरू मलाई दिएका छन्। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“यदि हारूनका सन्तानहरू मध्ये कसैलाई छालाको डरलाग्दो रोग अथवा धातु स्त्राव रोग छ भने ऊ शुद्ध नहोउञ्जेलसम्म पवित्र खाद्य खान सक्दैन। यो नियम सबै अशुद्ध पूजाहारीहरूको निम्ति हो। पूजाहारीले शुद्ध हुन सक्छ जब ऊ मरेको शरीर छुन्छ अथवा आफ्नो स्राव गराउँछ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","उनले कुनै घस्रने अशुद्ध पशुहरू छोए पनि अशुद्ध हुन सक्छन्। के गर्दा अथवा कसरी कुनै व्यक्ति अशुद्ध भयो त्यो कुनै मुख्य कुरा होइन, तर कुनै पूजाहारीले अशुद्ध मानिसलाई छुँदा नै अशुद्ध भइहाल्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","यी चीजहरू मध्ये कुनैलाई छुइन्छ त्यो मानिस साँझसम्म अशुद्ध रहन्छ। उसले पानीमा ननुहाएसम्म पवित्र खाद्य खानु सक्दैन। ");
INSERT INTO npi2010_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","घाम अस्ताएपछि मात्र उनी पवित्र हुनु सक्छन् अनि पवित्र खाना खानु सक्छन्। किन? किनभने पवित्र खाना उसको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“यदि कुनै पूजाहारीले आफैं मरेको अथवा जंगली जनावरले मारेको पशु भेट्छन् उनले त्यो खानु हुँदैन, यदि खान्छन् उनी अशुद्ध हुन्छन्। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“मैले आदेश गरेअनुसार पूजाहारीले गर्नुपर्छ जसले गर्दा तिनीहरू धेरै सजग बस्नु पर्छ। पवित्र चीजहरू तिनीहरूले गर्दा अपवित्र नहुन्। यदि तिनी सजग हुन्छन् भने, तिनीहरू मर्दैनन्। म परमप्रभुले यही विशेष कर्मको निम्ति तिनीहरूलाई अरू मानिसहरूबाट छुट्‌याएको छु। ");
INSERT INTO npi2010_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","पूजाहारीसित बस्ने पाहुना अथवा ज्यालामा काम गर्न आएको मजदूरले पवित्र भोजन खान हुँदैन, पूजाहारीको परिवारले मात्र पवित्र भोजन खान सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","तर पूजाहारीको घरमा जन्मेका कमारा-कमारी अथवा पूजाहारीले आफ्नैं पैसाले किनेको कमारा-कमारीले पनि पवित्र खाद्यको भाग खान सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","पूजाहारीकी छोरीले अर्को परिवारको मानिससँग पनि बिहे गर्न सक्छे। यदि उसले यसो गर्छे भने उसले बलिबाट निकालिएको पवित्र खाद्य खान सक्दिन। ");
INSERT INTO npi2010_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","पूजाहारीको कुनै छोरी विधवा हुनु सक्छे अथवा उसलाई आफ्नो पतिद्वारा छुट्‌याउन सक्छ अनि यदि तिनीहरूका छोरा-छोरीहरूलाई सहायता गर्ने छैन भने ऊ आफ्नो बुबाको घरमा जान सक्छे। तब उसले आफ्नो बुबाको भागबाट केही अंश पवित्र खाद्य खान सक्छे। पूजाहारीको परिवारले मात्र यो भोजन खान सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“यदि कुनै मानिसले पवित्र थाहा नपाई खान्छ भने उसले त्यसको पाँचौ भाग थपेर पूजाहारीलाई दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“इस्राएलका मानिसहरूले परमप्रभुलाई बलि चढाउन सक्छन् र यी बलिहरू नै पवित्र बनिन्छन्। यसर्थ पूजाहारीहरूले यी पवित्र बलिहरू अपवित्र पार्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","यदि पूजाहारीहरूले यी उपहारहरूलाई पवित्र मान्दैनन्, तिनीहरूले जब यी पवित्र चीजहरू खान्छन् तब आफ्नो पाप अझै थपिरहेका हुन्छन्। तिनीहरूलाई पवित्र तुल्याउने परमप्रभु म नै हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून, उनका छोराहरू र इस्राएलका समस्त मानिसहरूलाई भनः इस्राएलमा बसोबास गर्ने विदेशी होस अथवा देशी, त्यस मानिसको बलि कुनै विशेष बलि होस् अथवा त्यो उसको भाकलको बलि होस्। ");
INSERT INTO npi2010_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","ती उपहारहरू परमेश्वरलाई चढाउन इच्छा गर्ने मानिसले चढाएका हुन्। यसर्थ कुनै खोट भएको बलि तिमीहरूले ग्रहण गर्नु हुँदैन कारण त्यस्तो बलि म ग्रहण गर्दिनँ। साँढे, बाख्रा अथवा भेडा जुन सुकै उपहार होस् तर त्यो पुरूष अनि निष्खोट हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“कुनै व्यक्तिले मेलबलि अथवा परमप्रभुलाई स्वेच्छाले आफ्नो भाकल पूरा गर्न बलि चढाउनु सक्छ, तर त्यो बलि बलियो अनि निष्खोट हुनुपर्छ त्यो साँढे होस् अथवा भेडा। ");
INSERT INTO npi2010_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","तिमीहरूले परमप्रभुको वेदीको आगोमा कुनै प्रकारको रोगी पश उपहार स्वरूपमा चढाउनु हुँदैन। यसर्थ कुनै बलि तिनीहरू परमप्रभुलाई चढाउछौ त्यो अन्धो, लंङ्गडो, अयोग्य अनि चर्मरोग अथवा धातुरोग भोगेको छ भने यस्ता पशुहरू उपहारको रूपमा चढाउनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“कोही समयमा लामो खुट्टा भएको अथवा खुट्टाहरू ठीकसँग नबढेको साँढे अथवा थुमा पनि हुन्छन्, अनि यदि पशुहरूबाट कसैले परमप्रभुलाई विशेष बलि चढाउन चाहे त्यो परमप्रभुले ग्रहण गर्नु हुन्छ। तर यस्तो पशुको बलि कुनै भाकल गरिएको बलि ग्रहण गर्नुहुन्न। ");
INSERT INTO npi2010_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“यस्तो पशु नचढाऊ जसको अण्डाकोष कुच्याएको अथवा काटिएको छ। यस्तो आफ्नो भूमिमा नचढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“यस्ता प्रकारका पशुहरू विदेशीहरूबाट आफ्ना परमेश्वरलाई खाद्यको रूपमा चढाउन न ल्याऊ। किनभने ती पशुहरू घाइते छन् तिनीहरू खोट लागेका छन् अनि ग्रहण योग्य हुँदैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“जब बाछो, अथवा पाठा अथवा सानो बोका जन्मन्छ त्यसको माऊले त्यसलाई आफूसंगै सात दिनसम्म राख्नुपर्छ आनि त्यसपछि आठौं दिन यो परमप्रभुद्वारा आगो बलिको रूपमा स्वीकार गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","तर तिमीले त्यही दिन माऊ र पाठो बलि चढाउनु हुँदैन। यो नियम गाईहरू र भेडाहरूमा पनि लाग हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“यदि तिमी परमप्रभुलाई धन्यवाद बलि चढाउछौ, तिमीले चढाउँन सक्छौ तर त्यो बलि परमेश्वरलाई ग्रहणयोग्य हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","तिमीले त्यो बलि चढाएको पशुको मासु त्यही दिन खाई सक्नुपर्छ भोलि बिहानसम्म बाँकी राख्नु हुँदैन। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“मेरो आज्ञाहरू याद राख अनि पालन गर। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","इस्राएलका मानिसहरूले मलाई विशेष रूपमा स्वीकार गर्नु पर्छ। मेरो नाउँको आदर गर्नु पर्छ। म परमप्रभु हुँ अनि तिमीहरूलाई पवित्र बनाउँछु। ");
INSERT INTO npi2010_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","मैले तिमीहरूलाई मिश्र देशबाट ल्याएँ। म तिमीहरूको परमेश्वर भएको छु। म परमप्रभु हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलका मानिसहरूलाई भन तिमीले परमप्रभुले रोज्नु भएका चाडहरूलाई पवित्र पर्वहरू भनी घोषणा गर। ती विशेष पवित्र दिनहरू यी नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“छ दिनसम्म काम गर, सातौं दिन विश्राम मानिनेछ र त्यस दिन विशेष विश्रामको दिन, एक पवित्र सभाको दिन हुनेछ। त्यस दिन तिमीहरूले कुनै किसिमको काम नगर्नु। तिमीहरूको सब घरमा यस दिनलाई परमप्रभुको विश्राम मानिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“यी सब परमप्रभुद्वारा तोकिएका चाडहरू हुन्, तिमीले यी दिनहरूलाई पवित्र सभा भनी घोषणा गर्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","परमप्रभुको निस्तार पहिलो महीनाको चौधौं दिनको साँझमा शुरू हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“त्यही महीनाको पन्ध्रौं दिन अखमिरी रोटीको चाड हुन्छ। तिमीले सात दिनसम्म अखमिरी रोटी खानेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","यो चाडको पहिलो दिन तिमीले विशेष सभा गर्नेछौ। त्यस दिन काम गर्ने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","सात दिनसम्म तिमीले परमप्रभुलाई आगोद्वारा बलि चढाउन बलिहरू ल्याउनु पर्छ। तब सातौं दिनमा फेरि अर्को विशेष सभा हुन्छ अनि त्यस दिन तिमीले कुनै काम गर्ने छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलका मानिसहरूलाई भन म तिमीहरूलाई जुन देश दिन्छु त्यसमा तिमीहरू जानेछौ अनि त्यहाँ बाली काट्नेछौ। त्यस समयमा तिमीहरूको पहिले बालीको उब्जनीको एक बिटा पूजाहारीकहाँ ल्याउनू। ");
INSERT INTO npi2010_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","पूजाहारीले बिटालाई परमप्रभु अधि डोलाओस् यसकारण तिमीहरूलाई स्वीकार गर्नेछ उसले त्यो विश्राम भोलि पल्ट गर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“जुन दिन तिमीहरूले अन्नको बिटा परमप्रभुको अघि डोलाउने छौ त्यस दिन तिमीहरूले परमप्रभुलाई होमबलि चढाउन एउटा एक वर्षे निष्खोट थुमा ल्याउन्। ");
INSERT INTO npi2010_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","अंडीरको तेलमा मिसाएको सोलह बटुको मसिनो पीठोको अन्नबलि पनि चढाउनुपर्छ। तिमीहरूले पनि चढाउनु पर्छ र तिमीहरूले एक लीटर मद्य चढाएको बलिको बास्नाले परमप्रभुलाई आनन्दित पार्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","तिमीहरूले परमप्रभुलाई नयाँ फसल उपहार नचढाएसम्म तिमीहरूले रोटी, भूटेको अन्न, अथवा ताजा अन्नहरू खानु हुदैन। तिमीहरू जहाँ बसे पनि यी नियमहरू पुस्ता पुस्तासम्म चलि रहनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“परमप्रभुलाई डोलाउने अन्नको बिटा ल्याएको दिनबाट सात हप्ताहरू गन। ");
INSERT INTO npi2010_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","सातौं हप्ताहरू पछिको आइतवार (त्यो पचास दिनपछि) तिमीहरूले परमप्रभुको निम्ति नयाँ अन्नको बलि ल्याउँनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","त्यस दिन तिमीहरूले आफ्नो घरबाट दुइवटा खमीर मिसाएको रोटी ल्याउनु पर्छ खमीर अनि सोह्र बटुको पीठो प्रयोग गरेर यी रोटीहरू पकाऊ। त्यो डोलाउने बलिक लागि हुनेछ त्यो तिम्रो पहिलो उब्जनीबाट परमप्रभुको निम्ति अन्न बलि हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“एउटा साँढे दुइवटा भेडाहरू अनि सातवटा एक वर्षे पाठहरू अन्नबलि अनि अर्घबलिसित चढाउनु पर्नेछ। यी सबै पशुहरू निष्खोट हुनुपर्छ। यी पशुहरू आगोद्वारा जलाइने होमबलि हुनुपर्छ अनि यसको बास्नाले परमप्रभुलाई खुशी पार्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","तिमीहरूले पापबलिको निम्ति एउटा बोका अनि दुइवटा एक वर्षे पाठाहरू पनि मैत्रीबलिको निम्ति चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“पूजाहारीले रोटीले तिनीहरूलाई परमप्रभुको अघि दुइवटा थुमाहरूसित डोलाउने तिनीहरू परमप्रभुको निम्ति पवित्र हुन्छ र ती सबै पूजाहारीको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","तिमीहरूले त्यस दिन केही काम गर्ने हुँदैन अनि एउटा पवित्र सभा बोलाउनेछौ। यो नियम तिमीहरू घरहरूमा तिमीहरूको पुस्तौ-पुस्तासम्म चलि रहने छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“जब तिमीहरू आफ्नो जमीनमा बाली उठाउँछौ खेतको कुना-कुनासम्म नउठाऊ अनि त्यसरी छोडीएको अन्न उठाउनु फर्केर नजाऊ। ती सब गरीबहरू तथा तिमीहरूको जमीन भएर जाने विदेशीहरूको निम्ति छोडी देऊ। म परमप्रभु तिमीहरूका परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलका मानिसहरूलाई भन: सातौं महीनाको पहिलो दिन तिमीहरूको विशेष विश्रामको दिन हुन्छ र मानिसहरूलाई यो पवित्र सभा हो भनी सम्झाउन तुरही बजाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","तिमीहरू सामान्य काम नगर तिमीहरूले आगोद्वारा चढाउने बलि परमप्रभु कहाँ ल्याउँनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“प्रायश्चितको दिन सातौं महीनाको दशौं दिनमा पर्छ। त्यसदिन तिमीहरूले केही खानु हुँदैन अनि तिमीहरूले आगोद्वारा परमप्रभुलाई बलि चढाउनु पर्छ अनि पवित्र सभा गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","त्यस दिन तिमीहरूले केही काम गर्ने छैनौ, किन? किनभने त्यो दिन तिमीहरूको प्रायश्चितको दिन हो। त्यसदिन पूजाहारी परमप्रभुको सामुने जानेछन् र तिमीहरूलाई पवित्र पार्न उत्सव गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“यदि कुनै मानिसले यस दिनमा उपवास बस्न अस्वीकार गरे उसलाई उसका मानिसहरूबाट छुट्‌याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","यदि कुनै मानिसले त्यस दिन केही काम गर्छ म उसलाई उसका मानिसहरूको बीचबाट शेष पार्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","त्यसदिन तिमीहरूले कुनै काम गर्नु हुदैन अनि यो विधि तिमीहरू जहाँ बस्छौ त्यहाँ सधैंको निम्ति चालू रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","यो दिन तिमीहरूको निम्ति एक विशेष विश्रामको दिन हो र तिमीहरूले त्यस दिन केही खाने छैनौ। यो विशेष विश्रामको दिन त्यस महिनाको नवौं दिनको साँझबाट शुरू हुनेछ र भोलिपल्ट साँझसम्म रहनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलका मानिसहरूलाई भनः सातौं महीनाको पन्ध्रौं दिनमा छाप्रो-बासको चाड मनाउनुपर्छ। यो चाड परमप्रभुको निम्ति सात दिनसम्म चली रहनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","कसैले यस चाडको पहिलो दिन केही काम गर्नु हुँदैन जब पवित्र सभा गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","तिमीहरूले परमप्रभुको निम्ति आगोद्वारा सात दिनसम्म बलि ल्याउनु पर्छ अनि आठौं दिन तिमीहरूले अर्को पवित्र सभा गर्ने पर्छ। आगोको बलि परमप्रभुलाई चढाउनु पर्छ, तिनीहरू त्यस केही काम गर्नु हुँदैन अनि यो पवित्र सभा हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“परमप्रभुको विशेष चाडहरू यी नै हुन्। यी दिनहरूमा पवित्र सभाहरू हुनेछन्, तिमीहरूले परमप्रभुलाई आगोबाट बलिहरू चढाउनेछौ। होमबलि, अन्नबलि, अर्धबलिहरू अरू अन्य बलिदानहरू चढाउँनेछौं। ती बलिहरू तिमीहरूले ठीक समयमा चढाउनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","तिमीहरूले चढाउने यी बलिहरू परमप्रभुको विश्राम दिनहरूको स्मरण र विशेष भाकलको निम्ति हो। तिनीहरू केही योग्यको बलिहरू तिमीहरूले परमप्रभुलाई दिन सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“सातौं महीनाको पन्ध्रौं दिन जब तिमीहरू आफ्नो जमीनबाट फसल बटुल्छौ तब सात दिनसम्म परमप्रभुको चाडहरू मनाउनुपर्छ। पहिलो दिन अनि आठौं दिन विशेष विश्रामको दिन हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","पहिलो दिनमा तिमीहरूले फलको बोटहरूबाट राम्रो राम्रो फलहरू बटुल्नु पर्छ अनि खजूरको हाँगाहरू, मोटो पातभएका रूखहरूका हाँगाहरू र खोलाको किनारमा हुने लहरे-पीपलका हाँगाहरू बटुलेर परमप्रभु तिमीहरूका परमेश्वरकोअघि सात दिन आनन्द मनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","प्रत्येक वर्ष तिमीहरूले सात दिनसम्म परमप्रभुको निम्ति यो चाड मनाउनु पर्छ। यो चाड सातों महीनामा मनाइनेछ र यो विधि सधैं चलिरहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","इस्राएलमा जन्मने सबै मानिसहरू सात दिनसम्म ती अस्थायी छाप्रोहरूमा बास बस्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","किन? किनभने तिमीहरूका सन्तानले जान्न पाउँनेछन्। त्यसै कारण जब मैले इस्राएलीहरूलाई मिश्रको भूमि बाहिर ल्याए, मैले तिनीहरूलाई दक्षिण छाप्रोहरूमा बस्न लगाएँ। म परमप्रभु तिमीहरूका परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","यसर्थ मोशाले परमप्रभुलाई सम्मान गरिने सबै चाडहरू इस्राएलका मानिसहरूलाई बताइदिए। ");
INSERT INTO npi2010_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","परमप्रभुले मोशालाई भन्नभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलका मानिसहरूलाई आदेश देऊ तिनीहरूले निरन्तर ज्योतिको निम्ति आफैंले भद्राक्ष पिसेर तयार पारेको शुद्ध तेल ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","परमप्रभुअघि भेट हुने पालमा करार सन्दुकको पर्दा बाहिर साँझबाट बिहान नहुञ्जेलसम्म हारूनले निरन्तर बत्ती जलाऊन्। यो विधि तिमीहरूका सन्तान बाँचुञ्जेलसम्म सधैं चलिरहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","हारूनले परमप्रभुको अघि सुनौलो बत्तीदानमा निरन्तर बत्ती जलाइरहनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“मसिनो पीठोको बाह्रवटा रोटी प्रत्येक रोटीमा सोलह बटुको पीठो प्रयोग गरेर पकाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","परमप्रभुअघि प्रत्येक पंक्तिमा छवटा गरेर सुनको मेचमा रोटी सजाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","प्रत्येक पंक्तिमा शुद्ध सुगन्धित धूप जलाऊ। यसले परमप्रभुलाई आगोद्वारा बलि चढाएको सम्झना गराउन सहायता गर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","प्रत्येक विश्रामको दिन हारूनले परमप्रभुअघि यसरी रोटी राखुन्। इस्राएलका मानिसहरूको निम्ति यो करार सधैंको निम्ति रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","हारून र उनका छोराहरूले पवित्र स्थलमा त्यो रोटी खानेछन्। किन? किनभने त्यो रोटी धेरै पवित्र छ। यो परमप्रभुको निम्ति आगोद्वारा जलाएर चढाइने बलिहरूमा एउटा हो र यो हारूनको निम्ति स्थायी अंश हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","इस्राएली आमा र मिश्री पिताको एकजना छोरा थियो जो इस्राएलमा बस्थ्यो। त्यो मानिस इस्राएलीहरूको माझमा थियो अनि एक दिन उसले अर्को इस्राएलीसित लडाइँ गर्नु शुरू गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","इस्राएली आमाको छोरोले सराप्दै परमप्रभुको नामको नराम्रो कुरा गर्यो अनि मानिसहरूले उसलाई मोशाकहाँ ल्याए। (आमाको नाम शलोमीत थियो अनि तिनी दान कुलकी दिब्रीकी छोरी थिइन्।) ");
INSERT INTO npi2010_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","मानिसहरूले त्यस मानिसलाई कैदी झैं पक्रिए अनि स्पष्ट न्यायको निम्ति परमप्रभुको आज्ञाको लागि पर्खे। ");
INSERT INTO npi2010_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","तब परमप्रभुले मोशालाई भन्नभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“मानिसलाई ल्याऊ जसले शिविरबाहिर सराप्यो। ती जसले उसको सराप सुने तिनीहरूलाई पनि बोलाऊ अनि ती तिनीहरूले आफ्ना हात उसको टाउकोमा राख्नु पर्छ। तब इस्राएलको सम्पूर्ण समुदायले उसमाथि मरूञ्जेसम्म ढुङ्गाले हिर्काउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","तिमीले इस्राएलका मानिसहरूलाई भनः यदि कुनै मानिसले आफ्नो परमेश्वरलाई सराप्छ भने उसलाई दण्ड दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","यदि कुनै मानिसले परमप्रभुको निन्दा गर्छ अथवा सराप्छ इस्राएलको सम्पूर्ण समुदायले उसलाई ढुङ्गाले हिर्काएर मार्नुपर्छ। यदि एउटा विदेशीले निन्दा गर्छ भने उसलाई अवश्यै मार्नु पर्छ जस्तो इस्राएलमा जन्मएको निन्दालाई मार्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“अनि यदि एकजना मानिसले कुनै अर्को मानिसको हत्या गर्छ भने त्यसलाई मार्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","यदि कुनै व्यक्तिले अर्काको पशुलाई मारे त्यसले बदलामा अर्को एउटा पशु दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“अनि यदि कुनै मानिसले अर्को मानिसलाई चोट ल्याउँछ। त्यस मानिसलाई पनि चोट नै पारि दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","हड्डी भाँचेको भए हुड्डी नै भाँची दिनुपर्छ एउटा आँखा फुटाई दिएको भए उसको पनि आँखा नै फुटाइदिन पर्छ र दाँत भाँची दिएको भए त्यसको पनि दाँत नै भाँची दिनुपर्छ। जे जस्तो चोट पारेकोछ त्यसलाई पनि त्यही गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","यदि कसैले कुनै मानिस मारे त्यो मार्ने मानिसलाई पनि मार्नुपर्छ। यदि कसैले अर्को कसैको पशु मारे त्यसले पनि उसको साटोमा एउटा त्यस्तै पशु दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“कानून् विदेशीको निम्ति अनि आफ्नो देशका मानिसहरूको निम्ति साँचो रहनेछ। किन? किनभने म परमप्रभु तिमीहरूको परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","तब मोशाले मानिसहरूलाई यी कुराहरू बताए अनि तिनीहरूले जसले सरापेको थियो त्यस मानिसलाई पाल बाहिर ल्याएर ढुङ्गले हिर्काएर मारे। यसर्थ इस्राएलीहरूले त्यही गरे जो परमप्रभुले मोशालाई आज्ञा दिनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","परमप्रभुले सीनै पर्वतमा मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलका मानिसहरूलाई भन, जब तिमीहरू जमीनमा पुग्छौ, जो म तिमीहरूलाई दिन्छ, त्यस समय तिमीहरूले परमप्रभुको सम्मानमा भूमिलाई विशेष विश्राम दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","छ वर्षसम्म तिमीहरूले बीऊहरू रोप्न सक्छौ अनि छ वर्ष सम्म दाख बगैंचामा कलम काट्न सक्छौ, फलहरू बटुल्न सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","तर सातौं वर्षमा तिमीहरूले जमीनलाई विश्राम दिएर त्यहाँ बीऊहरू छर्ने छैनौ, त्यहाँका बोटहरू छिमोल्ने छैनौं कारण परमप्रभुको सम्मानमा यो विशेष विश्राम हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","उब्जनी उठाइसकेपछि त्यहाँ आफैं उम्रेका बोटहरूबाट अन्न उठाउनु सक्तैनौ अनि नछिमोलेको दाख बोटहरूबाट फल बटुल्न सक्तैनौ। जमीनले एक वर्ष विश्राम पाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“यदि भूमिलाई विश्राम दिएको भएता पनि तिमीहरूको निम्ति अनि तिमीहरूका मानिसहरूको अनि नोकर-नोकरनीहरूको निम्ति दैनिक मजदूरहरू तथा तिमीहरूसंग बस्ने विदेशीहरूको निम्ति प्रशस्त फसल हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","तिमीहरूले घरेलू र अरू पशुहरूको निम्ति पनि त्यहाँ प्रशस्त फसल हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“तिमीहरूले सात वर्ष सात पल्ट गन्नु जसको प्रतिफल 49 वर्ष निस्कन्छ। त्यस समयको अवघिमा त्यहाँ भूमिलाई सात वर्षको निम्ति विश्राम हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","सासौं महीनाको दशौं दिन जुन प्रायश्चितको दिन हुन्छ भेडाको सींगको तुरही बजाउनु। यो सारा देशभरि बजाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","तिमीहरूले पचासौं वर्षलाई विशेष वर्ष रूपमा मनाउनेछौ अनि सारा देशका सबै मानिसहरूको निम्ति स्वतन्त्रताको घोषणा गर्नेछौ, जसलाई जयन्ती उत्सवको रूपमा मनाइनेछ। यस समयमा प्रत्येक मानिसले आफ्नो सम्पत्ति फिर्ता पाउनेछ। प्रत्येक सेवक आफ्नो घरमा फर्किनेछ। आफ्नो घर-जमीनमा जानेछ, आफ्नो परिवार भएकोमा फर्केर जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","तिमीहरूको निम्ति यो पचासौ वर्ष एक विशेष उत्सवको वर्ष हुनेछ। त्यति बेला कुनै पनि बीऊ नछर विजन नलगाऊ, आफैं फलेको अन्न नउठाऊ अनि नछिमोलेको दाखबाट नबटुल। ");
INSERT INTO npi2010_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","यो वर्ष तिमीहरूको निम्ति महोत्सवको वर्ष हो र यो पवित्र समय मान्नु। तिमीहरूले खेतमा उठाएको अन्न खानु। ");
INSERT INTO npi2010_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","जयन्ती वर्षमा प्रत्येक मानिसले आफ्नो सम्पत्ति फिर्ता पाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“जब तिमीहरूले आफ्नो जमीन बेच्दा आफ्ना छिमेकीहरूलाई नठग। उसले पनि तिमीलाई नठगोस् जब तिमी ऊबाट जमीन किन्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","जब तिमी तिमीहरूको छिमेकीको जमीन किन्छौ तब विगत वर्षको उत्सवको संख्यालाई गन र उचित मूल्य गणना गर्नु ती संख्याहरू प्रयोग गर। किन? किनभने तिम्रो छिमेकीले तिमीलाई अर्को (उत्सव) सम्म सही तरीकाले खेती-पाती गर्नको निम्ति बेचेको छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","तिमीले वर्षहरू अनुसार दामको हिसाब गर्नु पर्छ। यदि त्यहाँ धेरै वर्षहरू बाँकी रहे उत्सव दाम ज्यादा हुनु पर्छ। यदि वर्षहरू कम्ति भए दाम कम्ति हुनु पर्छ। किनभने उसले तिमीलाई अन्नहरू संख्याहरू मात्र बेचेका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","एकार्कालाई नठग। आफ्नो परमेश्वरलाई आदर गर। म परमप्रभु तिमीहरूका परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“मेरो विधि-विधानहरू याद राखेर पालन गरे तिमीहरू आफ्नो जमीनमा आराम साथ बस्न सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","अनि जमीनले प्रशस्त बाली उब्जाउनेछ र तिमीहरूसित अन्नको केही कमी नहुँदा तिमीहरू आनन्दले बाँच्नु सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“तर हुन सक्छ तिमीहरूले भन्न सक्छौ, ‘यदि हामीले बीऊ छरेनौ अथवा बाली उठाएनौ भने सातौं वर्षमा खाने हामी सित केही रहँदैन।’ ");
INSERT INTO npi2010_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","चिन्ता नगर! छैटौं वर्षमा म मेरो आशीर्वाद दिने छु जसले गर्दा जमीनले तीन वर्षको निम्ति बाली उब्जाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","जब तिमीहरू आठौं वर्ष बाली लगाउँछौ त्यस समयमा पहिलेको अन्न नै खाइरहेको हुनेछौ। नवौंवर्ष तिमीहरूको बाली पाकी सक्दा पनि तिमी त्यही पुरानो अन्न नै खाँदै गरेका हुनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“भूमि साँच्चै नै मेरो हो यसकारण तिमीहरूले सदाको निम्ति बेच्न सक्तैनौ। तिमीहरू त मेरो जमीनमा मसँग बस्न आएका परदेशी अथवा यात्रीहरू मात्र हौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","मानिसहरूले जमीन बेच्न सक्छन् तर फेरि तिनीहरूको परिवारको सदस्यले त्यो भूमि फिर्ता गर्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","तिमीहरूको देशमा कुनै मानिस एकदमै गरीब हुँदा जमीन बेच्नु सक्छ तर उसको अति नजिकको आफन्त आएर आफ्नो मानिसको निम्ति त्यो भूमि किन्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","कुनै गरीब मानिसलाई उसको जमीन किनी दिने आफन्त नहोला, तर उसको प्रशस्त धन भएको समयमा आफैंले यो जमीन किन्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","त्यो जमीन किन्न उचित मूल्य तिर्न उसले बेचेको वर्षबाट किन्ने समयसम्म कति वर्ष उसले त्यस जमीनमा खेती गर्यो, त्यो गनोस्, र बाँकी रहेको वर्षहरूमा त्यस जमीनबाट कति उब्जनी हुन्छ त्यसको मूल्य तिरेर आफ्नो जमीन किनोस् तब त्यो जमीन फेरि उसको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","तर यदि त्यस मानिसको जमीन किन्न प्रशस्त धन कमाउन नसके अनि जमीनको मूल्य तिर्न नसके महोत्सव वर्षसम्म त्यो जमीन किन्ने मानिस कै भइरहनेछ। तब विशेष महोत्सवको समयमा त्यो जमीन फेरि पुरानो त्यसको मालिकलाई फर्काइनेछ र त्यो जमीन त्यसको सही मालिक कै हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“यदि कुनै मानिसले पर्खाल लगाएको शहरभित्रको घर बेच्छ भने उसले एक वर्षभित्र घर उक्साउने अधिकार पाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","तर यदि त्यो बेच्ने मालिकले बेचेको दिनबाट एक वर्ष भित्रमा फर्काउन नसके त्यो पर्खालको घेराभित्रको घर किन्ने मानिस तथा उसको सन्तानहरूको स्थायी सम्पति हुनेछ। महोत्सवको समयमा त्यो घर पुरानो मालिकलाई फर्काइने छैन। ");
INSERT INTO npi2010_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","तर पर्खालले नघेरिएको जग्गा खुल्ला मैदान सरह रहन्छ र त्यस्तो ठाउँको घर बेचिएको खण्डमा महोत्सवको बेला पहिलेको मालिकले नै त्यो घर पाउँनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“तर लेवीहरूको शहर विषयमाः लेवीहरूसित तिनीहरूको घर फिर्ता पाउने अधिकार छ जो तिनीहरूको शहरहरू भित्र छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","लेवी शहर भित्रको लेवीहरूको घर यदि कुनै मानिसले किनेकी भए पनि महोत्सवको समयमा त्यो घर फेरि पुरानो मालिककोमा फर्केर जान्छ। किन? किनभने लेवी शहर भित्रका घरहरू लेवी परिवारहरू कै हुन्। इस्राएलीहरूले लेवीहरूलाई ती घरहरू दिएका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","लेवी शहरहरूको वरिपरि रहेका खेतहरू तथा चउरहरू बेच्न सक्दैन किनभने ती सब सदाको निम्ति लेवीहरू कै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“तिमीहरूको शहर भित्रैको कोही मानिस यति गरीब हुन सक्छ कि उसले आफैंलाई पनि गुजारा गर्न नसक्ला। यस्तो खण्डमा तिमीहरूले उसलाई परदेशी पाहुनालाई जस्तै तिमीहरूसितै बस्न दिनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","तिमीहरूले उसलाई ऋण दिए सूद-ब्याज वा नाफा नलिन र आफ्नो परमेश्वरको सम्मानमा उसलाई तिमीहरूसित बस्न देऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","उसलाई ऋण दिए सूद नलगाऊ अनि उसलाई खान बेचेको खाद्यमा नाफा नराख। ");
INSERT INTO npi2010_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","म परमप्रभु तिमीहरूको परमेश्वर हुँ। तिमीहरूका परमेश्वर हुनुलाई र कनान देश तिमीहरूलाई दिनु मैले तिमीहरूलाई मिश्रदेशबाट बाहिर ल्याएँ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“तिमीहरूको आफ्नै देशको कुनै मानिस यति गरीब हुनु सक्छ कि उसले आफैंलाई तिमीहरू कसै कहाँ कमारा सरह बेच्न सक्छ तर तिमीहरूले उसलाई कमारालाई झै नखटाऊ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","महोत्सवको समयसम्मलाई उसलाई कुनै परदेशी अथवा मजदूरी गर्न खटाइएको मानिसलाई झैं व्यवहार गर। ");
INSERT INTO npi2010_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","तब ऊ अनि उसका छोरा-छोरीहरू तिमीहरूदेखि मुक्त हुनेछन्। ऊ आफ्नो पूर्खौली सम्पत्तिमा फर्केर आउनु सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","किन? किनभने त्यस्ता मानिसहरू मेरा सेवकहरू हुन। मैले तिनीहरूलाई मिश्रबाट ल्याएँ। तिनीहरूलाई कमाराको रूपमा बोच्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","तिमीहरू तिनीहरूको निम्ति निष्ठुर मालिक हुनुहुँदैन। तिमीहरूले आफ्नो परमेश्वरको डर अनि आदर गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“तिमीहरूको स्री तथा पुरूष कमारी-कमाराहरूका विषयमाः आफ्नो वरिपरिका देशहरूबाट तिमीहरूले कमारा-कमारीहरू पाउन सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","तिमीहरूकै देशमा बसो-बास गर्ने विदेशीहरूबाट पनि बालक-बालिका कमारा-कमारीहरू पाउँन सक्छौ। ती बालक कमारा-कमारीहरू तिमीहरूका हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","तिमीहरूको मृत्युपछि ती विदेशी कमारा-कमारीहरू तिम्रा नानीहरू का हुनेछन् अनि तिनीहरू सधैंको निम्ति तिमीहरूकै हुनेछन्। तिमीहरूले विदेशीहरूलाई कमारा-कमारीहरू बनाउन सक्छौ तर इस्राएली मानिसहरू तिमीहरूको आफन्तहरूप्रति तिमीहरू निष्ठूर मालिक बनिनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“तिमीहरूकहाँ आउने विदेशी अथवा परदेशीहरू धनी पनि हुन सक्छन् अनि तिमीहरूको आफ्नै देशका दाज्यू-भाइहरू अत्यन्तै गरीब भई तिनीहरूको कमारा बनी बिक्री हुन सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","यदि यस्तो भएको खण्डमा त्यस मानिससित फिर्ता किन्ने अधिकार छ। उसलाई उसको दाज्यू-भाइहरू मध्ये कसैले किन्नु सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","अथवा उसको काका-मामा तथा उसको काका-मामाका छोराहरूले अथवा उसको आफ्नै आफन्तका कुनै मानिसले उसलाई किन्न सक्छ। अथवा ऊ आफैंले पनि आफ्नो प्रशस्त धन जोगाड गरे आफैंलाई फेरि किन्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“तिमी कसरी दाम तोक्न सक्छौ? अर्को जयन्ती वर्षसम्म विदेशीलाई उसले बेचेको दिनदेखि वर्षहरू गन। तोक्नको निम्ति त्यस संख्यालाई प्रयोग गर। किन? किनभने उसले सही रूपमा केही वर्षको निम्ति मात्र किनेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","यदि अर्को जयन्ती वर्षको समय आउन अझै निकै वर्ष छ, त्यस मानिसले निकै बेशी दाम तिर्नु पर्छ। तर दाम वर्षको संख्यामा भर पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","अनि फेरि यदि अर्को महोत्सव वर्ष आउँन केही वर्ष मात्र रहे उसले आफ्नो पुरानो दाम भन्दा धेरै कम्ती रकम तिर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","त्यो मानिस त्यसको मालिकसँग एक दैनिक हाजिरमा काम गर्ने मजदूर झैं रहनसक्छ अनि त्यस विदेशी मालिकले ऊसंग दुष्ट व्यवहार नगरोस्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“यदि त्यस मानिसलाई कसैले उक्साएको खण्डमा, त्यो मानिस अर्को महोत्सव वर्षमा स्वतन्त्र उस्कनु सक्छ महोत्सवको वर्षमा उसका नानीहरू पनि स्वतन्त्र बनिनु सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","किन? किनभने, इस्राएलीहरूलाई मिश्र देशमा तिनीहरूको दासत्वबाट उकासेर मेरो आफ्नो दास-दासीहरू बनाउन ल्याएको हुँ। म परमप्रभु तिमीहरूका परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“तिमीहरू आफ्नै निम्ति मूर्ति नबनाऊ आफ्नो भूमिमा ढोग गर्नु, मूर्तिहरू अथवा स्मारक नबनाऊ। किन? किनभने म परमप्रभु तिमीहरूको परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“मेरा विशेष विश्राम दिनहरूलाई याद गर अनि मेरो पवित्र स्थानलाई आदर गर। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“मेरा नियमहरू अनि आज्ञाहरू याद राख अनि तिनीहरूको पालन गर। ");
INSERT INTO npi2010_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","यदि तिमीहरूले यी कुराहरू गर्छौ भने पानी पर्ने समयमा तिमीहरूलाई पानी दिनेछु। जब यस्तो हुन्छ, जमीनले खेती उब्जाउनेछ अनि रूखहरूमा फल लाग्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","तिमीहरूको दाई अंङ्गूर टिप्ने समयसम्म रहनेछ अनि अंङ्गूर टिपाई फसल रोप्ने समयसम्म रहनेछ। तिमीहरू जति चाहन्छौ त्यति खानेछौ अनि आफ्नो भूमिमा सुरक्षित बस्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","म तिमीहरूको देशमा शान्ति दिनेछु र तिमीहरू शान्ति साथ बस्न पाउनेछौ। नोक्सानदायक पशुहरूलाई म तिमीहरूको देशबाट निकालिदिनेछु अनि तिमीहरूलाई धम्काउन अथवा डर देखाउन कोही मानिस आउने छैन कारण कुनै सेना तिमीहरूको देश भएर जान पाउँनेछैन। ");
INSERT INTO npi2010_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“तिमीहरूले आफ्नो शत्रुहरूलाई खेद्नेछौ, र तरवारले मार्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","तिमीहरू पाँच जनाले एक सय जना शुत्रहरूलाई पराजित गर्नेछौ अनि तिमीहरू एक सय जनाले तिमीहरूको दश हजार शत्रुहरूलाई पराजित गर्नेछौ। तिमीहरूले तिमीहरूको शत्रुहरूलाई नाश गर्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“म तिमीहरूलाई दया गर्नेछु र तिमीहरूलाई ठूलो सन्तान पनि धेरै नानीहरू जन्माउने शक्ति दिनेछु। म मेरो करार तिमीहरूसित सही राख्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","तिमीहरूसँग प्रशस्त अन्न रहनेछ र तिमीहरूले नयाँ वर्षको खेती उठाउँदा पनि पुरानो वर्षको अन्न रही रहनाले त्यो पुरानो अन्न तिमीहरूले फ्याँक्नु पर्नेछ नत्र तिमीहरूकोमा नयाँ बाली उठाएर राख्ने स्थल हुने छैन। ");
INSERT INTO npi2010_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","तिमीहरूको माझमा परमप्रभु आएर बस्ने पवित्र जग्गा-पवित्र पाल बसाल्नेछु। म तिमीहरूलाई घृणा गर्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","म तिमीहरूसितै बस्नेछु। म तिमीहरूको परमेश्वर हुनेछु अनि तिमीहरू मेरा मानिसहरू हुनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","म परमप्रभु तिमीहरूको परमेश्वर हुँ। तिमीहरू मिश्र देशमा दास थियौ तर मैले तिमीहरूलाई त्यहाँबाट बाहिर ल्याएँ। तिमीहरू दासत्वको बोझले निहुर्याइएको थियौ तर अब म तिमीहरूको जुवालाई भाँचिदिनेछु अनि म तिमीहरूलाई धर्मीकता सित शिर ठाडो गरी हिड्ने तुल्याउनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“तर यदि तिमीहरूले मेरा ती आज्ञाहरू मान्दैनौ, ");
INSERT INTO npi2010_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","यदि तिमीहरूले मेरो विधिहरू र आज्ञाहरूको अवहेलना गछौ यो मेरो करार भंग गरेको जस्तो हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","यदि तिमीहरूले यसो गर्छौ भने, तब म तिमीहरूमाथि भयंकर कष्टहरू ल्याउनेछु। तिमीहरूमाथि रोग तथा ज्वरो ल्याइदिनेछु। ती रोगहरूले तिम्रा आँखाहरू फुटाइ दिनेछन् अनि तिमीहरूको जीवन अन्त गराइदिनेछ। तिमीहरूले खेती गरे पनि सफल हुने छैनौ, तिमीहरूका शत्रुहरूले तिम्रा अन्न बलीहरू खाइदिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","म तिमीहरूको विरोधमा हुनेछु र तिमीहरूलाई शत्रुले परास्त गर्नेछ। ती शत्रुहरू जसले तिमीहरूलाई घृणा गर्छन् तिमीहरूमाथि शासन गर्नेछन्। तिमीहरू भागिरहने छौ यद्यपि कसैले तिमीहरूलाई खेदेको हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“यति गर्दा पनि तिमीहरूले मलाई नमाने तिमीहरूले गरेको पापको सात गुणा वेशी सजाय दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","अनि तिमीहरूको गर्वको महानगरलाई म भत्काउनेछु। आकाशले तिमीहरूलाई पानी दिनेछैन र त्यसरी नै पृथ्वीले तिमीहरूलाई अन्न दिने छैन। आकाश र पृथ्वी तिमीहरूको निम्ति क्रमश फलाम र काँसा जस्ता हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","तिमीहरूले पूरा मेहनत त गर्छौ तर त्यसबाट केही लाभ हुनेछैन अनि तिमीहरूलाई नत जमीनले अन्न दिनेछ नत रूखहरूले फल दिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“अझ तिमीहरू मेरो विरोध गर्छौ र मैले भनेको मान्दैनौ भने तिमीहरूलाई सात गुणा अधिक हिसाबले हिर्काउनेछु। जति तिमीहरू पाप गर्छौ त्यति नै वेशी तिमीहरूले दण्ड भोग्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","म तिमीहरू विरूद्ध जंगली जनावरहरू पठाउनेछु अनि तिनीहरूलाई तिमीहरूका नानीहरू लैजानेछन्। तिनीहरूले तिमीहरूको पशुहरू मार्नेछन् अनि तिमीहरूका धेरै मानिसहरू मारिनेछन् र बाटाहरू खाली हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“यति हुँदा पनि यदि तिमीहरू चेतेनौ भने अनि मेरो विरोध गरिरह्यौ भने, ");
INSERT INTO npi2010_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","तब म आफैं तिमीहरूको विरूद्ध जानेछु र तिमीहरूको पापहरूको निम्ति सात गुणा दण्ड दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","तिमीहरूले मेरो करार भंङ्ग गर्यौ, यसर्थ म तिमीहरूलाई दण्ड दिन तिमीहरूको विरूद्ध शुत्रहरू ल्याउनेछु। तिमीहरू बचाऊको निम्ति आफ्नो शहरभित्र जानेछौ तर म त्यहाँ रोगहरू फैलाइदिनेछु अनि तिमीहरूका शत्रुहरूले तिमीहरूलाई जित्ने छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","म तिमीहरूको अन्न वितरण विछिन्न बनाउनेछु। दश जना स्रीहरूले एउटै चुल्हामा भान्सा पकाउनेछन्। तिनीहरूले एक-एक जना गरेर रोटी नाप्नेछन्। तिमीहरूले खानेछौ तर तिमीहरू अघाउने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“अझ पनि यदि तिमीहरूले मेरो आदेशहरू मान्न अस्वीकार गर्यौ अनि मेरो विरोधमा रह्यौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","तब म मेरो साँच्चै रीस देखाउनेछु! म तिमीहरूको परमप्रभु, तिमीहरूको पाप परिणामभन्दा सात गुणा वेशी दण्ड दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","तिमीहरू यति साह्रो भोको हुनेछौ कि तिमीहरूले आफ्नै छोरा-छोरीहरूको मासु खानेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","म तिमीहरूको पूजा गर्ने अग्ला स्थलहरू ध्वंश पारि दिनेछु अनि धूपका वेदीहरू भत्काइदिनेछु। म तिमीहरूको लाशहरूलाई तिमीहरूको मूर्तिहरूमाथि लडाइदिने छु। तिमीहरू मबाट एक्दमै घिनलाग्दो भएका छौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","म तिमीहरूको पवित्र स्थलहरू शून्य पारिदिनेछु, म तिमीहरूका शहरहरू ध्वंश पारिदिनेछु अनि म तिमीहरूले चढाएको सुगन्धित बलिहरू ग्रहण गर्दिनें। ");
INSERT INTO npi2010_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","म तिमीहरूको देश खाली पार्नेछु तब तिमीहरूको शत्रुहरू पनि त्यो देखेर छक्क पर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","म तिमीहरूलाई देश विदेशमा छरपुष्ट पार्नेछु र मेरो तरवार निकालेर तिमीहरूलाई शेष गर्नेछु। तिमीहरूको भूमि रित्तिनेछ अनि शहरहरू नाशा हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“तिमीहरूको देश खाली पारेर तिमीहरूलाई शत्रुको देशमा लगिनेछ जसले गर्दा तिमीहरूको देशले पूर्ण आराम पाउनेछ र देशले पनि आरामको समयको आनन्द लिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","जमीन खाली हुनेछ अनि जमीनले विश्राम पाउनेछ जो तिमीहरू त्यहाँ हुँदा यसले पाएको थिएन। ");
INSERT INTO npi2010_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","बाँचेकाहरूले पनि शत्रुको जमीनमा बस्न साहस पाउनेछैन। तिनीहरू प्रत्येक चीजसँग भयभीत रहनेछन् अनि हावाले उढाएको पत्कर झैं यता र उता भागिरहने छन्। तिनीहरू कसैले पछिबाट लखेटे झैं भागिरहने छन् र लड्ने छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","कसैले नखेदे पनि तिनीहरू कसैले तरवारलिएर खेदे झैं भागेर एकअर्कामा ठोकिंदै लड्नेछन्। “तिमीहरू शत्रुहरूको सामुन्ने उभिने साहस पाउने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","तिमीहरू अर्काको देशमा नष्ट हुनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","यसर्थ ती बाँकी बाँचेकाहरू पनि शत्रुहरूको देशमा आफ्नो पापहरूका लागि सडेर जानेछन्। तिनीहरूका पुर्खाहरू जसरी सडेर गए त्यसरी नै तिनीहरू पनि शत्रुहरूको मुलुकमा सडेर शेष हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“तर यदि ती मानिसहरूले आफ्नो पाप, पिता-पुर्खाहरूले गरेको पाप, तिनीहरू मेरो विरोधमा रहेको सत्य र तिनीहरूले विश्वास घात गरेको अधर्म स्वीकार गरे, ");
INSERT INTO npi2010_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","यदि तिनीहरूले म तिनीहरूको शत्रु भएको र शत्रुहरूको देशमा पठाएको सत्य स्वीकारे अनि तिनीहरू मेरो निम्ति विदेशीहरू झैं भए पनि यदि तिनीहरूको दुष्ट हृदयलाई नम्र पारी आफ्नो पापको दण्ड भोग्छन् भने, ");
INSERT INTO npi2010_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","मैले याकूब, इसहाक र अब्राहामसँग गरेको करार र त्यस देशलाई पनि सम्झनेछु। ");
INSERT INTO npi2010_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“जमीन रित्तो रहनेछ र त्यसले विश्रामहरूको आनन्द लिनेछ। ती बाँकी बाँचेकाहरूले तिनीहरूले गरेको पापको दण्ड ग्रहण गर्नेछन्, तिनीहरूले मेरो विधिहरू घृणा गरेको र विधिहरू मान्नु अस्वीकार गरेको कारण नै तिनीहरूले सजाय भोगेको हो भनी बुझे भने, ");
INSERT INTO npi2010_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","तिनीहरूले साँच्चै नै पाप गरेका हुन्। तर यदि मेरो सहायता खोजे म तिनीहरूलाई अस्वीकार गर्ने छैन। तिनीहरूलाई पुरै नष्ट पार्ने छैन, तिनीहरू शत्रुको देशमा बसेका भए पनि तिनीहरूले भनेको कुरा सुन्नेछु कारण म आफ्नो करार विर्सने छैन। किन? किनभने म परमप्रभु तिमीहरूको परमेश्वर हुँ। ");
INSERT INTO npi2010_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","तिनीहरूको निम्ति म तिनीहरूका पिता-पुर्खाहरूसित गरेको करार सम्झनेछु। तिनीहरूका पिता-पुर्खाहरूलाई मैले मिश्रबाट बाहिर ल्याएर म तिनीहरूको परमेश्वर बनिएको सत्य अन्य जातीहरूलाई थाहा छ। म परमप्रभु हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","परमप्रभुले इस्राएलका मानिसहरूलाई दिएको विधि-विधानहरू, नियमहरू र शिक्षाहरू यी नै हुन् र यी विधिहरू नै परमप्रभु अनि इस्राएलका मानिसहरूमाझ भएको करार हो। परमप्रभुले सीनै पर्वतमा यी विधिहरू मोशालाई भन्नुभयो अनि उनले तिनीहरू इस्राएलका मानिसहरूलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलका मानिसहरूलाई भनः कुनै मानिसले विशेष सेवाको निम्ति कुनै मानिस नै चढाउने परमप्रभुसँग भाकल गर्न सक्छ। त्यो मानिसको दाम पूजाहारीले तोकनुपर्छ। किनभने त्यसरी चढाउने मानिसहरूले चढाइएको मानिस फर्काउँदा परमप्रभुलाई दाम तिर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","बीस वर्ष देखि साठ्ठी वर्ष बीच मानिसको मोल चाँदीको पचास शेकेल हुन्छ। तिमी चाँदीका लागि अधिकारिक नाप प्रयोग गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","एउटै उमेर भएकी स्त्रीहरूको मोल तीस शेकल हो। (तिमीहरू चाँदीको निम्ति अधिकारी नाप प्रयोग गर्नुपर्छ।) ");
INSERT INTO npi2010_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","पाँच वर्षदेखि बीस वर्ष पुगेको मानिसको दाम बीस शेकेल चाँदी र यही उमेरकी स्त्रीको दाम दश शेकेल चाँदी। ");
INSERT INTO npi2010_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","एक महीनाबाट पाँच वर्षसम्म पुगेको केटोको दाम पाँच शेकेल चाँदी अनि केटीको दाम तीन शेकेल। ");
INSERT INTO npi2010_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","साठी वर्ष अथवा बढीको पुरूषको दाम पन्ध्र शेकेल र स्त्रीको दाम दश शेकेल चाँदी हुन्छ। (चाँदीको परिणाम सरकारी परिणाम अनुसार हुनुपर्छ।) ");
INSERT INTO npi2010_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“यदि कुनै मानिस एकदमै गरीब भए उसलाई पूजाहारीकहाँ ल्याउनु र त्यस मानिसले कति तिर्नु पर्ने निर्णय गर्नेछन्। बाँचेकाहरू अथवा बाँकी रहेका परमप्रभुको आज्ञा अवहेलना गर्दा परमप्रभुले दिनु भएको दण्डको भोगाइ र बाँचेका मानिसहरू। ");
INSERT INTO npi2010_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“केही पशुहरू परमप्रभुलाई बलि स्वरूप चढाउन सकिन्छ। यदि कुनै मानिसले तिनीहरू मध्ये एउटा पशु ल्याए त्यो पवित्र हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","जुन पशु उसले परमप्रभुलाई चढाउने प्रतिज्ञा गरेको थियो, उसले त्यो पशु अर्को पशुसित साट्नुहुँदैन। राम्रो पशुसित नराम्रो अथवा नराम्रोसँग राम्रो पशु साट्नु हुँदैन। यदि कुनै मानिसले त्यसो गर्छ भने ती दुवै पशुहरू पवित्र हुनेछन् र ती दुबै परमप्रभुको हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“कोही पशुहरू परमप्रभुको निम्ति बलिहरू चढाउँन सकिंदैन यदि कुनै मानिसले त्यस्तो अपवित्र पशु परमप्रभुलाई चढाउन ल्याए, त्यो पूजाहारीकहाँ ल्याउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","त्यो पशु चाहे राम्रो होस् अथवा नराम्रो केही भिन्नता हुँदैन तर दाम पूजाहारीले तोक्नेछ। पूजाहारीले दाम तोकेपछि त्यो पशुको दाम त्यही रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","यदि त्यो मानिस त्यो पशु फर्काउन चाहन्छ, उसले यसको दाममाथि अझै एक पाँचौ अंश थप्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“अब यदि कुनै मानिसले आफ्नो घर परमप्रभुलाई अर्पण गर्न चाहान्छन् भने, पूजाहारीले त्यस घरको दाम तोक्‌नुपर्छ। त्यो घर गत्तिलो होस् अथवा नराम्रो यसमा कुनै भिन्नता रहँदैन, यदि पूजाहारीले मूल्य तोकेपछि त्यही नै पक्का मूल्य हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","यदि त्यस मानिसले त्यो घर फेरि फर्काउन खोजे उसले तोकेको दाममा अझ पाँचौं अशं थप्नुपर्छ र त्यो घर फेरि उसैको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“यदि कुनै मानिसले आफ्नो खेतको एउटा अंश परमप्रभुमा अर्पण गर्छ, तब अर्पिएको जमीनको अंशको दाम बीउको परिमाण अनुसार तोकिनु पर्छ जो जमीनको त्यस आदेशमा छर्न सकिन्छ। एक होमर जौको बीउ जाने जमीनको पचास शेकेल चाँदीको दरले दाम तोक्न सकिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","यदि कुनै मानिस आफ्नो जमीन जयन्ती वर्षमा परमप्रभुलाई चढाउँछ तब यसको दाम पूजाहारीद्वारा तोकिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","तर यदि त्यस दाताले उत्सवपछि जमीन दान गर्छ भने त्यसको दाम पूजाहारीले हिसाब गरेर पक्का दाम तोक्नुपर्छ। अर्को महोत्सव वर्षसम्म कति वर्ष बाँकी रहन्छ त्यही प्रकारले उसले मूल्य तोक्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","यदि त्यही दामले आफ्नो जमीन फर्काउन चाहे तोकिएको दाममा अझ एक पाँचौ अंश थपेर लिओस् तब त्यो जमीन फेरि उसको आफ्नो हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","यदि त्यस दाताले मूल्य चुकाएर आफ्नो जमीन फर्काएन भने त्यो जमीन पूजाहारीको हुन्छ। तर यदि त्यो जमीन अरू कसैले किने फेरि दामाले फर्काउन सक्तैन। ");
INSERT INTO npi2010_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","महोत्सवको वर्षमा जमीन मुक्त गरिदिन्छ। यो परमप्रभुको निम्ति पवित्र भूमि झैं परमप्रभुलाई सम्पूर्ण रूपले अपर्ण गरिएको हुन्छ यो सधैंको निम्ति पूजाहारीको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“यदि कुनै मानिसले, आफ्नो पारिवारिक सम्पत्ति नभई कुनै उसले किनेको जमीन परमप्रभुलाई अर्पण गर्छ भने, ");
INSERT INTO npi2010_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","तब पूजाहारीले त्यो वर्षदेखि महोत्सव वर्षसम्म रहेको वर्षको हिसाबले जमीनको दाम तोकोस्, तब त्यो जमीन परमप्रभुको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","महोत्सव वर्षमा त्यो जमीन फेरि जुन मालिकबाट दाताले किनेको थियो उसैको हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“कुनै चीजको दाम तोकिंदा पवित्रस्थानको प्रशासनद्वारा अधिकारिक नाप अनुसार तोकिनु पर्छ। प्रशासनको विधि अनुसार एक शेकेल बराबर बीस गेराह हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“मानिसहरूले परमप्रभुलाई गाई तथा भेडाहरू पनि विशेष बलिको रूपमा चढाउन सक्छन्। तर यदि चढाइने पशु माऊको प्रथम थुमा अथवा बाछा हो भने त्यो परमप्रभुकै हो। यसर्थ मानिसहरूले ती पशुहरू परमप्रभुलाई विशेष बलि स्वरूप चढाउन सक्तैनन्। ");
INSERT INTO npi2010_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","तर यदि त्यो पहिला जन्मिएको पशु अशुद्ध छ। तब त्यस मानिसले फेरि यसलाई किनेर फर्काउनुपर्छ। पूजाहारीले त्यो पशुको दाम तोक्छ र किन्नेले त्यसमा पाँचौ अंशको एक अंश थपेर किन्नुपर्छ। तर यदि त्यही व्यक्तिले नकिने पूजाहारीले उसले तोकेको दाममा त्यो पशु बेच्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“मानिसहरूले परमप्रभुलाई विशेष उपहारहरू चढाउँछन् र यी उपहारहरू परमप्रभुको हुनेछन्। अनि किन-बेच गर्न सकिंदैन। पारिवारिक सम्पत्तिका यी उपहारहरू मानिस, पशु, जमीन अनि कुनै वस्तु हुन सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","यदि यस्तो विशेष उपहार मानिसको छ भने तब उसले किनेर फिर्ता ल्याउन सक्दैन र त्यसलाई अवश्यै मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“सबै बालीका अन्नहरूबाट दशांश परमप्रभुको हो, यसको अर्थ खेतीको अन्न तथा रूखका फलहरूको, दशांश परमप्रभुको हो। ");
INSERT INTO npi2010_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","यसर्थ यदि कुनै मानिसले त्यो अंश फिर्ता लिनु चाहन्छ भने उसले उसको दशांशको दाममा पाँच भाग अंश दाम थप्नुपर्छ अनि मात्र किन्न सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“मानिसहरूको गाई तथा भेडाहरूबाट प्रत्येक दशौं पशु पूजाहारीले लिन सक्छन् किनभने प्रत्येक दशांश पशु परमप्रभुको हो। ");
INSERT INTO npi2010_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","त्यो छानिएको पशु असल हो अथवा होइन त्यस विषयमा त्यसको मालिकले चिन्ता गर्ने काम छैन। उसले त्यो पशु अर्को एउटासँग साट्न सक्तैन, यसो गरे ती दुइटै पशुहरू परमप्रभुका हुन्छन्। त्यो पशु किनेर फर्काउन सकिंदैन।” ");
INSERT INTO npi2010_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","सीनै पर्वतमा परमप्रभुले मोशालाई इस्राएलका मानिसहरूका निम्ति दिनु भएका आज्ञाहरू यीनै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","सीनै मरूभूमिको भेट हुने पालमा इस्राएलीहरूले मिश्र देश छोडेको दोस्रो वर्षको दोस्रो महीनाको पहिलो दिन मोशासित परमप्रभुले कुरा गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“उहाँले भन्नुभयो, तिनीहरूको परिवार र कुल समूह सहित प्रत्येक व्यक्तिको नाम लेखेर इस्राएली मानिसहरूको गन्ती गर। ");
INSERT INTO npi2010_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","हारून र तिमीले बीस वर्ष र त्यो भन्दा वेशी उमेर भएकाहरू सेनामा जान सक्छन् प्रत्येकको गन्ती गर। ");
INSERT INTO npi2010_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","प्रत्येक कुलका एक एक व्यक्तिले तिमीलाई सहायता गर्नेछन्। प्रत्येक कुलबाट एक जना व्यक्ति अगुवा हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","यी निम्न लिखित व्यक्तिहरूले तिमीलाई सहायता गर्नेछन्: रूबेनको कुलबाट शदेऊरका छोरा एलीसूर ");
INSERT INTO npi2010_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमोनको कुलबाट सूरीशद्दैको छोरो शलूमीएल; ");
INSERT INTO npi2010_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदाको कुलबाट अम्मीनादाबको छोरो नहशोन; ");
INSERT INTO npi2010_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्साकारको कुलबाट सूआरको छोरो नतनेल; ");
INSERT INTO npi2010_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलूनको कुलबाट हेलोनको छोरो एलीआब; ");
INSERT INTO npi2010_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","यूसुफको उत्तराधिकारीहरूबाट; एप्रैमको कुलबाट अम्मीहूदको छोरो एलीशामा मनश्शेको कुलबाट पदासूरको छोरो गमलिएल; ");
INSERT INTO npi2010_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बिन्यामीनको कुलबाट गिदोनीको छोरो अबीदान; ");
INSERT INTO npi2010_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दानको कुलबाट अम्मीशद्दैको छोरो अहीएजेर; ");
INSERT INTO npi2010_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेरको कुलबाट ओक्रानको छोरो पगीएल; ");
INSERT INTO npi2010_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गादको कुलबाट रूएलको छोरो एल्यासाप; ");
INSERT INTO npi2010_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नप्तालीको कुलबाट एनानको छोरो अहीरा।” ");
INSERT INTO npi2010_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","यी सबै मानिसहरू यिनीहरूको कुल समूहका अगुवाहरू थिए र मानिसहरूले नै यिनीहरूलाई आफ्नो आफ्नो कुल समूहका अगुवा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","तब मोशा र हारूनले ती मानिसहरूलाई लिए जसलाई अगुवा बनाएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","दोस्रो महीनाको पहिलो दिन तिनीहरूले सबै समुदायलाई एकै चोटी बोलाएर पुस्ता अनि तिनीहरूको सन्तानहरूको नाम दर्त्ता गरेर बीस र बीस भन्दा वेशी उमेरको प्रत्येक व्यक्तिको सूची तयार गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","परमप्रभुले मोशालाई दिनु भएको आज्ञा अनुसार तिनले मानिसहरूको गन्ती सीनै मरूभूमिमा गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","तिनीहरूले यस्तो प्रकारले संख्या गन्ती गरे इस्राएलको प्रथम जाति रूबेन र तिनको परिवारको गणना गरे। बीस र बीस वर्ष भन्दा वेशी उमेरका व्यक्तिहरू जो सेनामा जान सक्थे तिनीहरूको नामको सूची बनाइयो। तिनीहरूको पिता-पुर्खाको कुल र परिवार अनुसार नाम दर्त्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रूबेनको कुलबाट गन्ती गरिएको संख्या 46,500 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","तिनीहरूले शिमोनको कुलबाट गन्ती गरे-बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार दर्त्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमोनको कुलबाट 59,300 व्यक्तिको गन्ती गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","तिनीहरूले गादको कुलबाट गन्ती गरे बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार दर्त्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गादको कुलबाट 45,650 व्यक्तिको गन्ती गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","तिनीहरूले यहूदाको कुलबाट गन्ती गरे बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार दर्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदाको कुलबाट 74,600 व्यक्तिको गन्ती गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","तिनीहरूले इस्साकारको कुलबाट गन्ती गरे बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार दर्त्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्साकारको कुलबाट 54,400 व्यक्तिको गन्ती गर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","तिनीहरूले जबूलूनको कुलको गन्ती गरे बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार दर्त्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबूलूनको कुलबाट 57,400 व्यक्तिहरूको गन्ती गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","तिनीहरूले एप्रैमको कुल समूहबाट गन्ती गरे। (एप्रैम-यूसुफको छोरो।) बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार दर्त्ता गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एप्रैमको कुलमा गन्ती गरिएको व्यक्तिहरूको सख्या 40,500 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","तिनीहरूले मनश्शे कुलका मानिसहरूको गन्ती गरे। (मनश्शे पनि यूसुफका छोरा थिए।) बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार गणना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्शेको कुलमा गन्ती गरिएको मानिसहरूको संख्या 32,200 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","तिनीहरूले बिन्यामीन कुलका मानिसहरूको गन्ती गरे। बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार गणना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बिन्यामीनको कुलमा गन्ती गरिएका मानिसहरूको संख्या 35,400 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","तिनीहरूले दान कुलका मानिसहरूको गन्ती गरे। बीस वर्ष र उँभोका सबै मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पिता-पुर्खाको कुल र परिवार अनुसार गन्ती गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दानको कुलमा गन्ती गरिएका मानिसहरूको संख्या 62,700 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","तिनीहरूले आशेर कुलका मानिसहरूको गन्ती गरे। बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरू प्रत्येकको नाम पुर्खाको कुल र परिवार अनुसार गणना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेर कुलमा गणना गरिएका मानिसहरूको संख्या 41,500 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नप्ताली कुलका मानिसहरूको तिनीहरूले गणना गरे। बीस वर्ष र उँभोका मानिसहरू जो सेनामा जानु सक्थे तिनीहरू प्रत्येकको नाम पुर्खाको कुल र परिवार अनुसार गणना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नप्ताली कुलमा गणना गरिएको मानिसहरूको संख्या 53,400 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मोशा, हारून र इस्राएलका बाह्र जना अगुवाहरूले यी मानिसहरूको गन्ती गरे। (त्यहाँ प्रत्येक कुल समूहबाट एक जना अगुवा थिए।) ");
INSERT INTO npi2010_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","तिनीहरूले बीस वर्ष र उँभोका मानिसहरू जो सेनामा जान सक्थे तिनीहरूको गन्ती गरे। तिनीहरू प्रत्येकको आफ्नो-आफ्नो परिवार अनुसार गणना गरियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","तिनीहरूको जम्मा संख्या 6,03,550 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","लेवी कुल समूहका परिवारका मानिसहरूको गणना इस्राएलका अन्य मानिसहरूसित गरिएन। ");
INSERT INTO npi2010_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","परमप्रभुले मोशालाई भन्नुभएको थियोः ");
INSERT INTO npi2010_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवीको कुल समूहका मानिसहरूको गणना नगर्नु अथवा तिनीहरूलाई इस्राएलका अरू मानिसहरूसित नमिलाउनु। ");
INSERT INTO npi2010_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","तर तिमीले लेवीहरूलाई करारको पवित्र पाल र यसका सबै वस्तुहरू हेरचाह गर्नुका निम्ति नियुक्त गर्यौ। तिनीहरूले पवित्र पाल र यसका सबै वस्तुहरू बोक्नु पर्छ। अनि तिनीहरूले पवित्र पालको सेवा गर्नुपर्छ र तिनीहरूले उनीहरूको छाउनी यसकै वरिपरि बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","जब तिमीले पवित्र पाल सार्थ्यो लेवीहरूले यसलाई तल झार्नु पर्थ्यो जब तिमीहरू रोकिने छौ, लेवीहरूले यसलाई स्थापित गर्नु पर्थ्यो। कुनै जो विदेशी नजिक आउँछ त्यसलाई मार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएलीहरूले आफ्नो आफ्नो दल समूह भित्र र आफ्नै झण्डाको छेउ छाउमा शिविर बनाऊन्। ");
INSERT INTO npi2010_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","तर लेवीहरूले तिनीहरूका छाउनी पवित्र पालकै वरिपरि लगाउन् र यसलाई रक्षा गर्नु पर्छ ताकि करारको पवित्र पाल सुरक्षित रहोस् र परमेश्वरको रिसको प्रकोप इस्राएली समुदायमाथि नपरोस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","यसरी इस्राएलका मानिसहरूले परमप्रभु द्वारा मोशालाई दिनु भएको सबै आज्ञाहरू पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","मोशा र हारूनलाई परमप्रभुले भन्नुभयोः ");
INSERT INTO npi2010_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएलका मानिसहरू प्रत्येकले शिविर भेट हुने पालको वरिपरि लगाउनु पर्छ अनि प्रत्येक कुल दलको आफ्नो झण्डा हुनुपर्छ र प्रत्येक मानिसले आ-आफ्नो दलको झण्डाको समीप शिविर बनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“यहूदा शिविर दलहरूले पूर्वतिर घाम झुल्कने पट्टि आफ्नो झण्डाको मुन्तिर शिविर हालुन। यहूदा दलका मानिसहरूको अगुवा अम्मीनादाबका छोरा नहशोन हो। ");
INSERT INTO npi2010_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","तिनको दलमा 74,600 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“तिनको समीपमै इस्साकार परिवार दलले शिविर हालुन्। यी मानिसहरूको अगुवा सूआरको छोरो नतनेल हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","उसको दलमा 54,400 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“जबूलून कुल दलले पनि यहूदा दलकै नजीकमा शिविर हालुन्। जबूलूनका मानिसहरूको अगुवा हेलोनको छोरो एलीआब हुन् र, ");
INSERT INTO npi2010_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","तिनको दलमा 57,400 मानिसहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“यहूदाको शिविरमा जम्मा 1,86,400 मानिसहरू खटाइएका छन्। यी सब मानिसहरू तिनीहरूका विभिन्न परिवार दलमा विभक्त भएका छन्। जब मानिसहरू एक ठाँउदेखि अर्को ठाँउ सर्छन् यहूदा दल पहिला सर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“रूबेनको शिविरको झण्डा पवित्र पालको दक्षिणमा रहनेछ। प्रत्येक दलले आफ्नो झण्डा नजिकै शिविर हाल्नेछ। रूबेनका मानिसहरूको अगुवा शदेऊरका छोरो एलीसूर हुन र ");
INSERT INTO npi2010_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","उसको दलमा 46,500 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“शिमोन कुल दलले रूबेन परिवार दलकै नजीक शिविर हाल्नेछ। शिमोनका मानिसहरूको अगुवा सूरीशद्‌दैको छोरो शलूमीएल हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","उसको दलमा 59,300 जना मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“रूबेनको मानिसहरूको नजिकै गादका मानिसहरूले पनि शिविर हाल्नेछन्। रूएलको छोरा एल्यासाप गादका मानिसहरूको अगुवा हो। ");
INSERT INTO npi2010_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","उसको दलमा 45,650 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“त्यहाँ रूबेनको शिविरमा खटिएका जम्मा 1,51,450 जना मानिसहरू छन् र जब मानिसहरू एक ठाँउबाट अर्को ठाउँमा सर्छन रूबेनको शिविर दोस्रो दल हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“लेवीहरूको शिविरसितै अरू शिविरहरूको माझमा भेट हुने पाल पनि जानेछ। तिनीहरूको जसरी आफ्नो आफ्नो झण्डामा शिविरहरू लगाइएको छ सोही क्रममा लश्करमा जान्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“पश्चिम पट्टिको एप्रैमको शिविर तिनीहरूकै झण्डामा हुनेछ। एप्रैमका मानिसहरूको अगुवा अम्मिहूदका छोरो एलीशामा हुन। ");
INSERT INTO npi2010_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","उसको दलमा जम्मा 40,500 जना मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“एप्रैमका कुल दलको शिविरको नजीकै मनश्शे कुल दलको शिविर हुनेछ। यस दलको अगुवा पदासूरको छोरो गमलीएल हुन। ");
INSERT INTO npi2010_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","उसको दलमा 32,200 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“बिन्यामीन कुल दलको शिविर एप्रैमको कुल दलको शिविर नजीकै रहनेछ अनि यस कुल दलको अगुवा गिदोनीको छोरो अबीदान हुन। ");
INSERT INTO npi2010_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","त्यहाँ जम्मा 35,400 जना मानिसहरू उसको दलमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“एप्रैमको शिविरमा खटिएका मानिसहरूको संख्या 1,08,100 छ। जब शिविर हिंडछ तिनीहरू तेस्रो लस्करमा हिड्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“उत्तर तिर भएको दानको शिविरमा भएका मानिसहरू तिनीहरूको आफ्नो झण्डा मुनि रहनेछन् अनि तिनीहरूको अगुवा अम्मीशद्‌दैको छोरो अहीएजर हुन। ");
INSERT INTO npi2010_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","उसको दलमा 62,700 जना मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“दान कुल दलको शिविर नजीकै आशेर कुल दलको शिविर रहन्छ अनि यस कुल दलको अगुवा ओक्रानको छोरो पगीएल हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","त्यहाँ उसको दलमा 41,500 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“अनि आशेर कुल दलको शिविर नजीकै नप्ताली कुल दलको शिविर रहनेछ र तिनीहरूको अगुवा एनानको छोरो अहीरा हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","त्यहाँ उसको दलमा 53,400 मानिसहरू छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“दान परिवार दलमा मानिसहरूको कुल संख्या 1,57,600 छ। तिनीहरू आफ्नो-आफ्नो झण्डा लिएर अन्तिम लस्करमा हिड्नेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","इस्राएलीहरूको परिवार अनुसार गन्ती गरिएको मानिसहरू यिनीहरू नै हुन्। गन्ती गरिए अनुसार यिनीहरूको संख्या 6,03,550 हो। ");
INSERT INTO npi2010_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","परमप्रभुले मोशालाई दिनुभएको आज्ञा अनुसार इस्राएलीहरूसित लेवीहरूको गन्ती गरिएन। ");
INSERT INTO npi2010_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","यसर्थ इस्राएली मानिसहरूले मोशालाई परमप्रभुले दिनुभएको आज्ञा अनुसार प्रत्येक कुरो गरे। यसरी नै तिनीहरूले आफ्नो-आफ्नो झण्डा नजीकै शिविर बनाए अनि त्यसरी नै आफ्नो-आफ्नो वंश र परिवार अनुसार तिनीहरू लस्करमा हिंडे। ");
INSERT INTO npi2010_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","परमप्रभुले सीनै पर्वतमा मोशासंग कुरा गर्नुहुँदा हारून र मोशाको परिवारको विवरण यस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारूनका दुइजना छोराहरू थिए र नादाब तिनको जेठो छोरा थिए। अरू छोराहरूको नाम अबीहू, एलाजार र ईतामार हो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","हारूनका यी छोराहरू तेलले अभिषिक्त परमप्रभुको विशेष सेवाका निम्ति पूजाहारीहरूको रूपमा नियुक्त गरिएका थिए। हारूनका यी छोराहरूलाई परमप्रभुको विशेष सेवामा नियुक्त गरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","नादाब र अबीहू परमप्रभुको सेवामा रहेको समय मै अपवित्र आगो द्वारा बलिचढाएको पापले सीनै मरूभूमिमा मरे। तिनीहरूको कुनै छोरो थिएन, यसकारण एलाजार र ईतामारले पूजाहारीका स्थान लिएर परमप्रभुको सेवामा लागे। तिनीहरूका बाबु हारूनको जीवन कालमा नै यस्तो घटना घट्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी कुलका जम्मै मानिसहरूलाई ल्याऊ अनि पूजाहारी, हारून सामुन्ने हाजिर गराऊ, तिनीहरू सबै हारून पूजाहारीको सहयोगीहरू हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","लेवीहरूले भेट हुने पालमा आराधना गर्दा हारूनलाई र त्यहाँ आराधना गर्नु आउने सबै मानिसहरूलाई सहायता गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","भेट हुने पालको सबै सर-समानहरूको सुरक्षा तिनीहरूले गर्नेछन् अनि त्यस पालभित्रको दायित्वपूर्ण काम गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“लेवीहरू सबै इस्राएलीहरूबाट चुनिएका हुन्। तिनीहरूलाई हारून र तिनका छोराहरूको सहायकहरूको रूपमा दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“हारून र तिनका छोराहरूलाई पूजाहारी रूपमा नियुक्त गर अनि तिनीहरू बाहेक अन्य कुनै पनि व्यक्ति त्यस पवित्रस्थानमा पस्न चेष्टा गरे त्यो अवश्य मारिनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“याद राख, मैले लेवीहरूलाई इस्राएलका पहिले जन्मने मानिसहरूको सट्टामा लिएको छु। यसकारण लेवीहरू मेरा हुन् र इस्राएलका पहिले जन्मने छोराहरू मलाई दिनु पर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","जब तिमीहरू मिश्र देशमा थियौ, मैले मिश्रदेशका मानिसहरूका पहिले जन्मेका सबै नानीहरू मारें अनि मैले इस्राएलीहरूका पहिले जन्मेका नानीलाई मेरो नानीहरू झैं छुट्टाएँ र त्यसरी नै पहिले जन्मेका पशुहरूलाई पनि छुट्याएँ। तिनीहरू सबै मेरो हुन् म परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","सीनै पर्वतमा परमप्रभुले मोशासित फेरि कुरा गर्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवीहरूको कुलमा सबै वंश तथा परिवार समूहहरू गन्ती गर। एक महिना र यो भन्दा वेशी उमेरको सबै पुरूषहरूको गन्ती गर।” ");
INSERT INTO npi2010_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","परमप्रभुको आज्ञा पालन गरी मोशाले सबै लेवी मानिसहरूको गन्ती गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवीका तीनजना छोराहरू थिए र तिनीहरूको नाम यस प्रकार छ गेर्शो, कहात र मरारी। ");
INSERT INTO npi2010_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेर्शोन वशंको नाम हो लिब्नी र सिमी। ");
INSERT INTO npi2010_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहात वंशको नाम अम्राम, यिसहार हेब्रोन र उज्जीएल। ");
INSERT INTO npi2010_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारी वंशहरू हुन महली र मसी। तिनीहरूको पिता-पुर्खाहरू अनुसार लेवीका वंशहरू यिनै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","लिब्नी र सिमीका वंशहरू गेर्शोनका हुन् र तिनीहरू गेर्शोनी वंशका भए। ");
INSERT INTO npi2010_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","एक महिना र अधिकका पुरूष मानिसहरू तिनीहरूका यी दुई परिवार समूहमा सबै 7,500 जना थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्शोनी वंशलाई पवित्र पालको पश्चिम पट्टि शिविर लगाउनु पर्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेर्शोनी वंशका मानिसहरूका अगुवा लाएलको छोरो एल्यासाप थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","भेट हुने पालमा गेर्शोनी मानिसहरूको काम भेट हुने पाल, बाहिरी पाल, छाना र प्रवेशद्वारको पर्दाको हेरचाह गर्नु थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","पवित्र स्थानको आँगनको प्रवेशद्वारको पर्दा आँगनको पर्दा, पर्दाको डोरीहरू र पर्दामा प्रयोग हुने सबै समानहरू तिनीहरूको हेरचाहमा थियो। त्यो आँगन पवित्र स्थान र वेदीको वरिपरि थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","अमामी, यिसहार, हेब्रोन र उज्जीएल परिवार समूहहरू कहात वंशका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","यस परिवार समूह एक महिना र उँभोका पुरूषहरू 8,300 थिए। कहातीहरूलाई पवित्र स्थानमा भएको सर-समानको जिम्मावारी थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहाती परिवार समूहरूको मानिसहरूले पवित्र स्थानको दक्षिण पट्टि तिनीहरूको शिविर टाँगे। ");
INSERT INTO npi2010_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","उज्जीएलको छोरो एलीसापान यी कहाती वंशका मानिसहरूको अगुवा थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","तिनीहरूको कामहरू पवित्र सन्दूक, टेबल, सामदान, वेदीहरू र पवित्र स्थानको पवित्र भाँडाहरू अनि पर्दा र पर्दासंग सम्बन्धित सबै कुराहरूको हेरचाह गर्नु थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","पूजाहारी हारूनको छोरो एलाजार चाँहि लेवीहरूको अगुवाहरूको अगुवा थियो। पवित्र स्थान हेरचाह गर्नेहरू माथि उसको नियन्त्रण थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","महली र मूशी परिवार समूहहरू मरारी वंशका हुन। यस वंशहरूमा एक महिना र, ");
INSERT INTO npi2010_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","यस परिवारमा एक महिना अनि त्यस माथिका सबै पुरूषहरू जम्मा 6,200 जना थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","मरारी परिवार समूहका मानिसहरूको अगुवाले अबीहेलको छोरा सूरीएलले पवित्र पालको उत्तर तिर तिनीहरूका पालहरू लगाए। ");
INSERT INTO npi2010_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारीहरूलाई पवित्र स्थानको आधारहरू, यिनीहरूको बारहरू खम्बाहरू र यिनीहरूको प्रयोगमा आउने सबै सरसामानहरू हेरचाह गर्ने जिम्मावारी थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","वरिपरिको आँगनको खम्बाहरू, कीलाहरू, डोरीहरू, आधारहरू र यस सम्बन्धी प्रयोग गरिने कुराहरू पनि तिनीहरूको जिम्मामा थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","पवित्र स्थानको पूर्व पट्टि भेट हुने पालको सम्मुख घाम झुल्किने पट्टि मोशा, हारून अनि तिनका छोराहरूले शिविर बसाले। इस्राएली मानिसहरूको निम्ति तिनीहरूले पवित्र स्थान इलाकाको सुरक्षा गरिरहेका थिए। कुनै पनि व्यक्ति जो पवित्र स्थानको नजीक आँउथ्यो त्यसलाई मारिन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","परमप्रभुको आज्ञा अनुसार मोशा र हारून द्वार गनिएका एक महिना र उँभोको उमेरका पुरूष लेवीहरूको संख्या जम्मा 22,000 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","परमप्रभुले मोशालाई फेरि भन्नुभयो, “इस्राएली मानिसहरूको पहिले जन्मेका पुरूषहरू जो एक महिना अनि उँभोकाहरूको गन्ती गरी एउटा सूची तयार गर। ");
INSERT INTO npi2010_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","विगतमा मैले भनेको थिएँ कि इस्राएलीहरूका पहिला जन्मेकाहरूलाई म लिनेछु, तर अहिले म, परमप्रभुले इस्राएलीहरूको पहिला जन्मेको सट्टामा लेवीहरूलाई लिनेछु र इस्राएलीहरूको पहिलो पशुहरूको सट्टामा लेवीकहरूकै पहिलो पशुधन लिन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","यसकारण परमप्रभुको आज्ञा अनुसार मोशाले इस्राएलका मानिसहरूको पहिला जन्मेका सबै नानीहरूको गन्ती गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","मोशाले एक महीना र उँभोका सबै पुरूषहरूको गन्ती गरे अनि सूचीमा 22,273 जनाको नाम थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","परमप्रभुले मोशालाई अझ भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएलीहरूको अन्य मानिसहरूको सट्टामा तिमीले लेवीहरूलाई लेऊ र म अरू मानिसहरूका पशुहरूको सट्टामा लेवीहरुको लिनेछु। लेवीहरू मेरो मानिसहरू हुन्। म परमप्रभु हुँ। ");
INSERT INTO npi2010_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","22,000 लेवीहरू छन् तर अन्य परिवारको जेठा छोराहरू 22,273 हुनाले 273 जना लेवीहरू भन्दा वेशी हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","यी 273 जना वेशी भएका पुरूषहरूको निम्ति प्रत्येकको पाँच शेकलको हिसाबले लेऊ। (प्रशासनिक परिमाणमा एक शेकल बराबर बीस गेरा हुन्छ)। इस्राएलीहरूबाट यो चाँदी लेऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","त्यो पैसा हारून र तिनका छोराहरूलाई ती 273 इस्राएलीहरूको सट्टामा देऊ।” ");
INSERT INTO npi2010_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","यसकारण लेवीहरू भन्दा वेशी भएका अन्य मानिसहरूको सट्टामा मोशाले पैसा लिए। ");
INSERT INTO npi2010_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","उसले इस्राएलीहरूको पहिला जन्मेकाबाट 1,365 शेकेल चाँदी (अधिकारीहरूको नाप अनुसार) जम्मा गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","परमप्रभुको आज्ञा अनुसार त्यो पैसा मोशाले हारून र तिनका छोराहरूलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“लेवीहरूको बीचमा कहातीहरूको उनीहरूको वंश तथा परिवार समूहको हिसाबले गन्ती गर। ");
INSERT INTO npi2010_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","भेट हुने पालमा सेवा गर्न आउने मध्ये तीस देखि पचास वर्ष उमेर सम्मका मानिसहरूको गन्ती गर। ");
INSERT INTO npi2010_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","कहातीहरूको काम भेट हुने पालमा सब भन्दा पवित्र चीजहरूको हेरचाहा गर्नु हो। ");
INSERT INTO npi2010_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“जब इस्राएलीहरू नयाँ क्षेत्रमा सर्न तयार हुन्छन्, हारून र तिनका छोराहरूले भेट हुने पाल पर्दा तल झार्नु पर्छ अनि यसले करारको सन्दूकलाई ढाक्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","तिनीहरूलाई यसमाथि नरम छाला लगाइ देऊ अनि छालालाई नीलो लुगासित छोपी देऊ अनि बोक्ने डण्डालाई यसको ठाउँमा राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“तिनीहरूले पवित्र टेबलमाथि निलो रंङ्गको लुगा ओछ्याऊन् अनि त्यसमाथि, रिकावी, धूपौरोहरू, बाटाहरू अनि अर्ध-बलिका कचौराहरू राखून्, अथवा ढुँङ्ग्रा राखिदिऊन्। विषेश रोटी त्यो पवित्र टेबलमा सँधै रहोस्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","तिनीहरूले तिनीहरू माथि रातो लुगा ओछ्याऊन् अनि त्यसमाथि फेरि नरम छालाले यसलाई छोपिदिउन्। बोक्नुको लागि प्रयोग गरिने डण्डाहरू टेबलमा राखुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“तिनीहरूले निलो लुगाले सामदान, यसको बत्तीहरू, बत्तीका सलेदोहरू, मसीदानी अनि जुन भाँडाहरूबाट तेल बत्तीमा लगाइन्छ ती भाडाहरू सबै ढाकिदिनू। ");
INSERT INTO npi2010_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","त्यसपछि त्यो सामदान र यसका सबै समानहरू सील छालाको च्यादरले छोपेर तिनीहरू बोकिने डण्डामा राखुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“तिनीहरूले सुनको वेदीमाथि निलो लुगाले ढाकि दिऊन् र त्यसमाथि नरम छालाको टुक्राले छोपिदिउन् अनि बोकेर ल्याइएका खम्बाहरू ठाउँमा राखुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“पवित्र स्थानमा सेवा गर्दा प्रयोग गरिने वस्तुहरू तिनीहरूले लैजाऊन् र एउटा निलो लुगामाथि नरम छालाको च्यादरले छोपि दिऊन् र तिनीहरूलाई बोकी लैजाने डण्डी माथि राखुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“काँसको वेदीबाट तिनीहरूले खरानी सफा गरून् र त्यसमाथि बैजनी रंगको लुगाले ढाकुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","त्यसपछि तिनीहरूले त्यस वेदीमा आराधना गर्दा प्रयोग गरिने वस्तुहरू जस्तै अँगेटी, काँटाहरू बेल्चाहरू छर्कने बाटाहरू र ती सब काँसाको वेदीमाथि राखुन्। त्यसपछि तिनीहरूले त्यसमाथि नरम छालाले वेदीलाई ढाकुन् र बोक्नुको लागि प्रयोग गरिने डण्डीहरू यसको ठाउँमा राखुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“जब हारून र तिनका छोराहरूले पवित्र सर-सामानहरू छोपिदिन सक्छन् तब कहाती वंशका मानिसहरूले त्यस समानहरू बोक्न शुरू गर्न सक्छन् र यसरी तिनीहरूले पवित्रस्थान स्पर्श गर्ने छैनन् नत्र तिनीहरू मर्नेछन्। भेट हुने पालको सबै सर-समानहरू कहातीहरूले नै बोकुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“पूजाहारी हारूनको छोरो एलाजार वत्तीको तेल, सुगन्धित धूप दैनिक अन्नबलि अनि अभिषेक तेलको निम्ति जिम्मावार रहनेछन्। तिनी भेट हुने पाल र त्यसभित्र भएको प्रत्येक कुराको जिम्मावार रहनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“कहातीहरूलाई लेवीहरूबाट अलग हुन नदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","तिमीहरूले तिनीहरूको निम्ति यस्तो गर ताकि तिनीहरू अति पवित्र स्थान नजीक जाऊन् तर नमरून्। हारून अनि तिनका छोराहरूले कहाती मानिसहरूलाई पवित्र स्थान भित्र गएर तिनीहरूले बोक्नु पर्ने समानहरू सबै देखाइ दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","यदि तिमीहरूले त्यसो गरेनौ भने ती कहाती मानिसहरू भित्र पस्छन् र पवित्र चीजहरू देख्छन् अनि तिनीहरूले केही समयको निम्ति मात्र पनि ती पवित्र चीजहरू हेरे भने तिनीहरू निश्चय मर्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेर्शोनी वंशका सबै मानिसहरूको आफ्नो आफ्नो परिवार र वंश अनुसार गन्ती गर। ");
INSERT INTO npi2010_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","सबै भेट हुने पालमा सेवा गर्न आउने तीस देखि पचास वर्ष उमेरका मानिसहरूको गन्ती गर। ");
INSERT INTO npi2010_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“गेर्शोनी वंशका मानिसहरूले बोक्नु पर्ने र गर्नु पर्ने काम यही हो। ");
INSERT INTO npi2010_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","पवित्र स्थानको पर्दाहरू, भेट हुने पाल, त्यसको छाना र त्यसमाथि रहने नरम छालाको आवरण अनि भेट हुने पालको ढोकाको पर्दा तिमीहरूले बोक्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","पवित्र स्थान वरिपरिको आँगनमा भएका पर्दाहरू, वेदीको पर्दाहरू, आँगनको द्वाराहरूका पर्दाहरू र डोरीहरू तथा पर्दामा लाग्ने सबै सर-समानहरू तिनीहरूले बोकुन्। यी वस्तुहरूका सम्बन्धमा जे कुराहरू पनि गरिन्छ त्यसको निम्ति गेर्शोनीहरू मानिसहरू जिम्मावार थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","गेर्शोनी मानिसहरूले जे पनि गर्छन भारी वोक्ने काम होस् अथवा अन्य काम हारून र तिनका छोराहरूको आदेश अनुसार गर्नेछन् र गेर्शोनी मानिसहरूको काम तिनीहरूले रेख-देख गर्नेछन्। यसर्थ गेर्शोनी मानिसहरूलाई तिनीहरूले काममा खटाऊन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","गेर्शोनी वंशका मानिसहरूले भेट हुने पालमा गर्नु पर्ने काम यिनीहरू नै हुन् र पूजाहारी हारूनको छोरो ईतामारले तिनीहरूको काम रेख-देख गर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","30","“मरारी वंशहरू र परिवारका मानिसहरू ज-जसले भेट हुने पालमा सेवा गरे अनि तीसदेखि पचास वर्ष उमेरका छन् तिनीहरू सबैको गन्ती गर। तिनीहरूले भेट हुने पालको निम्ति विशेष काम गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","भेट हुने पालमा तिनीहरूले यात्राको समयमा गर्नु पर्ने कामहरू यिनै हुन् पवित्र स्थानका फल्याकहरू, त्यसका बारहरू र डण्डीहरू, खम्बाहरू अनि आधारहरू। ");
INSERT INTO npi2010_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","वरिपरिका आँगनका खम्बाहरू र तिनीहरूका आधारहरू, कीलाहरू, डोरीहरू र तिनका सबै सामानहरू र यी सब सामानहरूसित सम्बन्धित सर-सामानहरू तिनीहरूले बोकून्। ");
INSERT INTO npi2010_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","मानिसहरूको सूचि तयार पार्नु र प्रत्येक मानिसले बोक्नु पर्ने के के हो खटाउनु। हारून पूजाहारीका छोरो ईतामारले तिनीहरूको काम रेख-देख गर्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोशा, हारून अनि इस्राएली मानिसहरूका प्रधानहरूले कहाती मानिसहरूको गन्ती गरे। तिनीहरूले तिनीहरूको वंशहरू र परिवार समूहहरूको गन्ती गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","तिनीहरूले तीसदेखि पचाससम्म उमेर भएका मानीसहरू जसले भेट हुने पालमा काम गरेका थिए तिनीहरूको गन्ती गरे। यी मानिसहरूलाई भेट हुने पालमा विशेष कामहरू दिइएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","कहाती परिवार समूहमा 2,750 मानिसहरू थिए अनि तिनीहरू भेट हुने पालमा विशेष सेवाको निम्ति लायक थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","यसर्थ यी कहाती वंशका मानिसहरूलाई भेट हुने पालमा विशेष कामहरूको निम्ति खटाइयो। परमप्रभुले मोशालाई भन्नु भए अनुसार मोशा र हारूनले गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","39","गेर्शोनी मानिसहरूमा पनि तीसदेखि पचास वर्ष उमेर भएका र भेट हुने पालमा काम गरेकाहरूको गन्ती गरिएको थियो। यी मानिसहरूलाई भेट हुने पालमा विशेष कामको निम्ति खटाइएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","यस परिवार समूहमा 2,630 मानिसहरू गनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","यी सबै मानिसहरू भेट हुने पालमा सेवारत थिए जसलाई परमप्रभुले दिनु भएको आज्ञा अनुसार मोशा र हारूनले गन्ती गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारीहरू आफ्नो आफ्नो वंश तथा परिवार अनुसार गनिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","तीसदेखि पचास वर्ष उमेर भएका जो भेट हुने पालको सेवामा लागेका थिए तिनीहरूको गन्ती भएको थियो अनि तिनीहरूलाई भेट हुने पालमा विशेष सेवाको निम्ति खटाइएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","मेरारी परिवार समूहमा 3,200 मानिसहरू भेट हुने पालमा विशेष सेवाको निम्ति लायक थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","यसर्थ यी मरारी परिवार समुहका मानिसहरूलाई भेट हुने पालमा विशेष कामको निम्ती खटाइयो। मोशा र हारूनले मोशालाई परमप्रभुले भन्नुभए अनुसार यसो गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","यसर्थ, मोशा, हारून र इस्राएली मानिसहरूका नायकहरूले लेवी मानिसहरूका प्रत्येक वंश र प्रत्येक परिवार समूहको मानिसहरूको गन्ती गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","तीसदेखि पचास वर्ष उमेर भएका र भेट हुने पालमा काम गरेका सबै मानिसहरूको तिनीहरूले गन्ती गरे। तिनीहरूलाई भेट हुने पालमा विशेष कामको निम्ति खटाइयो। तिनीहरूले यात्रा गर्दा भेट हुने पाल बोक्ने काम गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","तिनीहरूको कुल संख्या 8,480 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","परमप्रभुको आज्ञा अनुसार नै मोशाले प्रत्येक मानिसको गन्ती गरेका थिए। प्रत्येक मानिसलाई उसले के बोक्नु पर्थ्यो उसलाई भनिएको थियो। यो परमप्रभुले भन्नुभए जस्तै गरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इस्राएलका मानिसहरूलाई आज्ञा देऊ कि यदि कसैलाई चर्मरोग अथवा धातु रोग सरेको छ, यदि कोही स्त्री मासिकधर्ममा छ, यदि कसैले मृतशरीरलाई छोएर अपवित्र छ भने त्यस्तो व्यक्तिहरूलाई छाउनीबाट बाहिर निकाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","म छाउनीमा तिमीहरूको बीचमा छु, यसकारण तिनीहरू चाहे पुरूषहरू अथवा स्त्रीहरू हुन् तिनीहरूलाई छाउनीबाट निकाली देऊ ताकि तिमीहरूले म बस्ने ठाँउलाई अपवित्र बनाउने छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","यसर्थ इस्राएलका मानिसहरूले परमेश्वरको आज्ञा पालन गरी त्यस्ता मानिसहरूलाई शिविर बाहिर पठाई दिए। परमप्रभुले मोशालाई भन्नुभए अनुसार तिनीहरूले गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“यो कुरा इस्राएलका मानिसहरूलाई भन एकजना व्यक्तिले अर्को व्यक्तिमाथि नराम्रो काम गरिरहेको हुन्छ। (जब कसैले अर्को कसैमाथि अन्याय गर्छ तब उसले परमेश्वरसित पाप गरिरहेको हुन्छ।) त्यो व्यक्ति दोषी हो। ");
INSERT INTO npi2010_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","त्यसकारण उसले गरेको कुकर्म स्वीकार्नु पर्छ अनि उसले लागेका चीजहरूको निम्ति पूरा मोल दिनु पर्छ साथै व्यक्तिको लागि पाँच भागको एक भाग जोडनु पर्छ जसलाई उसले सताए। ");
INSERT INTO npi2010_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","तर यदि त्यो सताएको मर्यो भने अनि उसको कोही आफन्ता छैन भने, क्षतिपूर्तिको मोल परमप्रभुको पूजाहारीलाई दिनु पर्छ। यो व्यक्तिले पूजाहारीलाई प्रायश्चितको निम्ति एउटा साँढे दिनु पर्छ। पूजाहारीले साँढेलाई बलिदान दिएर उसको लागि प्रायश्चित गर्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“मानिसहरूले पूजाहारीलाई चढाएको पवित्र उपहार पूजाहारी कै हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","कुनै पनि व्यक्तिले चढाएको पवित्र उपहार उसैको हुन्छ तर यदि उसले पूजाहारीलाई दिए त्यो पूजाहारीको हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएलका मानिसहरूलाई यी कुराहरू भन: एकजना पुरूषकी पत्नी त्योसंग विश्वासघाती हुन सक्छे। ");
INSERT INTO npi2010_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","तिनले तिनको पतिले चाल नपाई अर्को मानिससित संभोग गर्छे भने। त्यहाँ तिनले दूषित गरेको देखाउनलाई केही साक्षी नहोला अनि तिनका पतिले नजान्ला अनि पत्नीले पनि तिनको पाप प्रकट नर्गलिन्। ");
INSERT INTO npi2010_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","तर तिनले गरेको कुकर्मको शंका तिनका पतिले गर्न सक्छ र उसको मनमा पत्नी प्रति डाह जाग्न सक्छ। उसले उसको पत्नी प्रति शंका गर्न सक्छ अनि ऊ प्रति तिनी दूषित थिइन्। ");
INSERT INTO npi2010_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","त्यस्तो भएको खण्डमा उसले आफ्नी पत्नीलाई पूजाहारीकहाँ लैजाओस् त्यस व्यक्तिले बलिको निम्ति एपाको दशौं हिस्सा जौंको पीठो लानु पर्छ। जौंको पीठो परमप्रभुको निम्ति डाही पतिले चढाएको अन्नबलि हुन्छ। त्यसमा उसले तेल हाल्नु हुँदैन अनि धूप पनि जलाउनु हुँदैन। यो अन्नबलि खाली पत्नीको दोष बाहिर देखाउन मात्र हो। ");
INSERT INTO npi2010_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“तब पूजाहारीले त्यस स्त्रीलाई नजीक ल्याएर परमप्रभु अघि उभ्याउँछ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","तब पूजाहारीले केही पवित्र पानी माटोको भाँडामा हाल्छन् र त्यस पानीमा भेट हुने पालको भूँईको धूलो हाल्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","पूजाहारीले त्यस स्त्रीलाई परमप्रभुको अघाडी उभ्याएर उसको कपालको चुल्ठो खोलेर हातमा अन्नबलि राखिदिन्छन्। यो जौंको पीठो उसको पति डाहीले दिएको हो। त्यही समयमा उसले आफ्नो हातले पवित्र पानी भएको माटोको भाँडा समात्छन। त्यो पवित्र पानीले त्यस स्त्रीमाथि अनिष्ट ल्याँउछ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“अनि पूजाहारीले त्यस स्त्री मानिसलाई कसम खुवाएर भन्छन् ‘यदि कुनै पुरूषले तिमीसित यौन सम्बन्ध नराखेको भए अनि तिमी यस पुरूषसित विवाह गरे पश्चात बिग्रेकी छैनौ भने तब यस कष्ट ल्याउने पानीले तिमीलाई कुनै नोकसान गर्ने छैन। ");
INSERT INTO npi2010_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","तर यस मानिससित विवाह गरे पश्चात पनि तिमी अन्य पुरूषसित अनैतिक सम्बन्ध राखेकी छौ भने तिमी पवित्र होइनौ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","तब पूजाहारीले त्यस स्त्रीलाई श्राप पर्ने कसम खान लाउँछन् र उसले त्यस स्त्री मानिसलाई भन्छन् परमप्रभुले तिमीलाई त्यस्तो श्राप दिऊन् कि जब जब कुनै मानिसले अर्को मानिसलाई सराप्छ उसले भन्नेछ कि जुन भयङ्कर अवस्था त्यस स्त्रीलाई आईलागेको थियो।’ “यही अवस्था तँ माथि पनि आइपरोस्, किनभने तिम्रो अनैतिक कुकृतिले तिम्रो जिउ सुकेर बाँझी हुनेछौ अनि तिम्रो पेट सुनिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","पूजाहारीले भन्नु पर्छ, ‘तिमीले गरेको छौ भने तिमीबाट नानीहरू जन्मने छैन, अनि गर्भ बसी हाले पनि त्यो तुहुनेछ।’ अनि त्यस आइमाईले भन्नुपर्छ, ‘तपाईंले जसो भन्नु हुन्छ म मान्छु। आमेन, आमेन।’ ");
INSERT INTO npi2010_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“तब यो उसको कसम पूजाहारीले चर्ममा अथवा कागजमा लेख्नु पर्छ अनि त्यो तितो पानीले लेखिएको अक्षरहरू मेटिदिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","अनि पूजाहारीले त्यो पानी त्यस स्त्रीलाई पिउन लगाउनु पर्छ र त्यस श्राप पार्ने पानीले त्यस स्त्रीलाई कष्ट दिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“तब पूजाहारीले डाही मानिसको भोजबली स्त्रीको हातहरूबाट यो वेदीमा ल्याउन पर्छ लिएर परमप्रभुको अघि डोलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","पूजाहारीले उसको हातहरू केही अन्नले भरिदिने छ अनि वेदीमाथि लगाउनेछ अनि त्यहाँ जलाउने छ। त्यहाँ पछि स्त्रीलाई पानी पीउन लगाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","जब तिनले उसलाई त्यो पानी पिलाउनेछन् तब यदि त्यो स्त्री आफ्नो पतिसित अविश्वासी रहेकी छे अनि आफू अपवित्र भएकी छे भने त्यस पानीले उसलाई कष्ट गराउनेछ जस्तै त्यसले उसको जिउ सुकिजानेछ अनि पेट फुलिनेछ। त्यो पत्नी आफ्ना मानिसहरू माझमा श्राप परेको जीवन बिताउनेछे। ");
INSERT INTO npi2010_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","तर यदि त्यो स्त्री आफ्नो पतिसित विश्वासघात नगरी पवित्र रहेकी छे भने त्यो स्वभाविक रहन्छे अनि नानीहरू जन्माउन योग्यकै रहन्छे। ");
INSERT INTO npi2010_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“यसर्थ, डाह विषयमा नियम यही हो। जब एक विवाहित स्त्री आफ्नो पुरूषको साथ बसी त्यस्तो अनैतिक क्रीडा गर्छे, ");
INSERT INTO npi2010_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","अथवा आफ्नो पत्नीको चरित्रमाथि कसैलाई शंका लाग्छ भने तब त्यस मानिसले गर्नु पर्ने कुरो यही हो। पूजाहारीले त्यस स्त्रीलाई परमप्रभुको अघि उभिनु लगाई यी सब कामहरू गर्नुपर्छ। कानुन यही हो। ");
INSERT INTO npi2010_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","पुरूष कुनै पापबाट निर्दोष सावित हुन्छ तर स्त्रीले भने आफ्नो पाप कर्मको दण्ड पाँउछे।” ");
INSERT INTO npi2010_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“यी कुरा इस्राएलका मानिसहरूलाई भन यदि कुनै मानिस अथवा स्त्री, केही समयको लागि परमप्रभुको निम्ति नाजिरी भाकल गर्छ भने। ");
INSERT INTO npi2010_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","त्यस व्यक्तिले आफूलाई दाखरस अथवा कुनै मद्यबाट अलग राख्नु पर्छ अथार्त त्यो व्यक्तिले कुनै प्रकारको मद्य अथवा नशालु चीज खानु अथवा पिउनु हुँदैन। अनि त्यस व्यक्तिले कुनै दाखको रस अथवा दाखको रस हालेको केही पनि खानु हुँदैन। त्यस व्यक्तिले ताजा होस अथवा सुकेको, दाख खानु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","जबसम्म व्यक्ति नाजिरी रहन्छ, पुरूष अथवा स्त्रीले दाखहरूको बोक्रा अथवा गेडा सम्म खानु हुदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“त्यस व्यक्तिले आफू नाजिरी भई बसेको समयमा व्यक्तिले उसको केश काट्नु अथवा खौरनु हुँदैन। आफू परमप्रभुको निम्ति अलग भई बसुञ्जेल पवित्र रहनु पर्छ र उसले आफ्नो केश लामो राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“जतिञ्जेल सम्म उसले आफूलाई परमप्रभुका निम्ति नाजिरी रूपमा राख्छ ऊ कुनै मुर्दाको नजिक जानेछैन। ");
INSERT INTO npi2010_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","उसको आफ्नो बाबु-आमा, दाज्यू-भाइ, दिदी-बहिनी जो पनि मरोस् मुर्दाको छेउमा जानु हुँदैन, उसले तिनीहरूको निम्ति आफूलाई अशुद्ध नबनाओस् किनभने आफ्नो परमेश्वरका निम्ति आफैं नाजिरी भएको चिन्ह उसको आफ्नो शिरमा छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","जति दिन सम्म तिनी परमप्रभुको लागि अलग रहन चाहन्छ त्यो व्यक्ति परमप्रभु प्रति पवित्र रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","अनि यदि कोही हठात उसैको नजिकै मर्छ अनि उसलाई अशुद्ध बनाउँछ भने परमप्रभुका निम्ति पालिएको उसको कपाल सातौं दिनमा खौरिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","तब आठौं दिनमा उसले दुइवटा ढुकुरको बच्चा अथवा दुइवटा परेवाको बच्चा भेट हुने पालको प्रवेशद्वारमा ल्याई पूजाहारीलाई दिओस्। ");
INSERT INTO npi2010_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","तब ती दुइवटा ढुकुर अथवा परेवा पूजाहारीले एउटा पापबलिको निम्ति चढाउँछ अनि अर्को होमबलिको निम्ति चढाउँछ। उ मुर्दाको छेउमा भएर गरेको पापको निम्ति उसले त्यसको लागि प्राश्चित गर्नु पर्छ। त्यस दिन त्यस व्यक्तिले फेरि आफ्नो शिर शुद्ध पार्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","अनि फेरि आफूलाई परमप्रभुको निम्ति अलग राख्छ र एउटा एक वर्षको थुमा ल्याएर दोषबलिको निम्ति चढाउँछ। उसको अर्पण गरिएको कपाल अशुद्ध भएको कारण पहिले अलग बसेको समय गन्तीमा नलिई नयाँ शुरू गर्नु पर्छ। पहिले गरेको समयमा मुर्दा स्पर्श गरी अशुद्ध भएको हुनाले उसले यस्तो गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“उसको अलग रहने समय समाप्त भए पछि नाजिरी भेट हुने पालको प्रवेशद्वारमा जानु पर्छ, ");
INSERT INTO npi2010_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","अनि परमप्रभुलाई एउटा उपहार चढाऊ। उसको उपहार यस्तो हुनु पर्छ एउटा एक वर्षे निष्खोट थुमा होमबलिको निम्ति; एउटा एक वर्षे निष्खोट भेडा पापबलिको निम्ति र एउटा निष्खोट भेंडा र एउटा निष्खोट साँढे भेडा मेल बलिको लागि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","एक डालो मिहिन पीठोमा तेल मिसाएर बनाएको अखमिरी रोटी। यी रोटीहरूमा तेल छर्केको हुनु पर्छ। अन्नबलि र अर्घबलि पनि यी उपहारहरूका अशं हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“पूजाहारीले यी सबै चीजहरू परमप्रभुलाई चढाऊन र पापबलि र होमबलि चढाऊन। ");
INSERT INTO npi2010_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","त्यस पछि पूजाहारीले मेलबलिको निम्ति एउटा भेडा अखमिरी रोटीको डालोसितै चढाऊन्। पूजाहारीले आवश्यक अनुसार अन्नबलि र अर्घबलि पनि चढाऊन्। ");
INSERT INTO npi2010_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“अब भेट हुने पालको द्वारमा जाऊ, नाजिरीले उसको केश खौरोस् अनि यसलाई आगोमा जलाओस् जहाँ मेल बलि सेकाउथ्ये। ");
INSERT INTO npi2010_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“पूजाहारीले भेडाको उसिनेको कधं र डालोबाट एउटा रोटी र एउटा फुलौरा नाजिरीको हातमा दिऊन्। ");
INSERT INTO npi2010_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","त्यसपछि पूजाहारीले ती सब उपहारहरू डोलाउने बलिको रूपमा परमप्रभुको अघि डोलाउन्। मेलबलिका निम्ति चढाइएको भेडाको ह्याकुलो र साँप्रो पनि यी सब चीजहरू सहित पूजाहारीको पवित्र भाग हुन्छ। त्यस पछि त्यो नाजरीले यो दाखरस पिउन सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“यी नियमहरू नाजिरीले परिपूर्ण गने शपथ हुन्। त्यस व्यक्तिले यी सब चीजहरू परमप्रभुलाई चढाउनै पर्छ। यदि कसैले यस भन्दा अधिकको भाकल गर्छ भने तब उसले आफ्नो वचन राख्नु नै पर्छ। तर उसले यी नियमहरू नाजिरीको निम्ति राख्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून र उसका छोराहरूलाई भन, तिमीहरूले यस प्रकारले इस्राएलका मानिसहरूलाई आशीर्वाद देऊ। तिनीहरूलाई आशीर्वाद दिदाँ यसो भन्नु, ");
INSERT INTO npi2010_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘परमप्रभुले तिमीहरूलाई आशीर्वाद दिऊन् र रक्षा गरून्। ");
INSERT INTO npi2010_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","परमप्रभुको मुहार (मुखारबिन्द) तिमीहरूमाथि चम्काऊन्, अनि तिमीहरूमाथि अनुग्रह गरून्। ");
INSERT INTO npi2010_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","परमप्रभुले तिमीहरू माथि दया दृष्टि राखुन्, अनि तिमीहरूमा शान्ति दिऊन्।’ ");
INSERT INTO npi2010_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","यस रीतिले जब इस्राएलका मानिसहरूलाई अशीर्वाद दिंदा हारून र उसका छोराले मेरो नाम मानिसहरूमाथि लगाउछन् अनि म तिनीहरूलाई आशीष दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","जब मोशाले पवित्र पाल खडा गरी सके उसले यसलाई अभिषेक द्वारा परमप्रभुमा समर्पण गरे अनि पवित्र पाल, यसको वस्तुहरू, वेदी अनि यससित भएका सबै कुराहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","इस्राएलका मानिसहरूको गन्ती हुदाँ यसका जिम्मावार मानिसहरू परिवार, प्रधानहरू, र कुल नायकहरूले परमप्रभुलाई उपहारहरू चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","तिनीहरूले 12 वटा गोरूहरूले तानेर ल्याएको 6 वटा ढाकिएको गाडाहरू परमप्रभुका निम्ति उपहारहरू ल्याए। प्रत्येक दुईजना अगुवालाई तिनीहरूले एउटा गाडा र प्रत्येक अगुवालाई एउटा साँढे दिए। तिनीहरूले यी उपहारहरू पवित्र पालमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“तिनीहरूबाट यी उपहारहरू ग्रहण गर ताकि यी उपहारहरू भेट हुने पालको काममा चलाउन सकीन्छ। यी सब चीजहरू लेवीहरूले तिनीहरूको कामको सहायतार्थ प्रयोग गर्न सक्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","यसर्थ मोशाले ती गाहरू र गोरूहरू लिएर लेवीहरूलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","मोशाले गेर्शोनीहरूलाई तिनीहरूको कामको निम्ति दुइवटा गाडाहरू र चारवटा गोरूहरू दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","तिनले चारवटा गाडाहरू र आठवटा गोरूहरू पूजाहारी हारूनका छोरा ईतामारको निर्देशनमा काम गर्नलाई मरारीहरूलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","कहातीहरूलाई तिनले केही पनि दिएनन् किनभने तिनीहरूले गर्नु पर्ने सेवा केवल पवित्र सर-सामानहरू काँधमा बोक्नु मात्र थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","जब वेदी अभिषेक गरियो वेदीमा चढाउन प्रधानहरूले उपहारहरू ल्याए। प्रधानहरूले उपहारहरू वेदीमा ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","परमप्रभुले मोशालाई भन्नुभयो, “प्रत्येक दिन एकजना प्रधानहरूले तिनीहरूको उपहार ल्याऊन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","यहूदा कुलका नायक अम्मीनादाबका छोरा नहशोनले पहिलो दिन आफ्नो उपहार चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","तिनको उपहार यस प्रकारको थियोः तिनको उपहारमा पवित्र-स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेलको चाँदीको थाल सत्तरी शेकेल परिमाणको एउटा छर्कनेबाटा यी दुवै भाँडाहरू अन्नबलिको निम्ति तेल हालेको मसिनो पीठोले भरिएको थियो, ");
INSERT INTO npi2010_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","दश शेकेल ओजनको एउटा ठूलो सुनको धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक बर्षे थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पापबलिको निम्ति एउटा बोको। ");
INSERT INTO npi2010_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","अनि मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक वर्षे पाँचवटा थुमा। ");
INSERT INTO npi2010_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","दोस्रो दिन इस्साकारका कुलनायक सूआरको छोरो नतनेलले आफ्नो उपहार ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","तिनले ल्याएको उपहार यस प्रकारको थियो। पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेल चाँदीको थाल, सत्तरी शेकेल चाँदी परिमाणको एउटा भाँडा; यी दुवै भाँडाहरू अन्नबलिको निम्ति तेल हालेको मसिनो पीठोले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","दश शेकेल चाँदीको एउटा ठूलो सुनको धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होमबलिको निम्ति एउटा जवान साढे, एउटा भेडा तथा एउटा एक बर्षे थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","अनि मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक वर्षे पाँचवटा थुमा। सूआरको छोरो नतनेलको उपहार यस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","तेस्रो दिन हेलोनका छोरा जबूलून कुलनायक एलीआबले उपहार चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","तिनले चढाएको उपहार यस प्रकार थियो पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल ओजनको एउटा भाँडा; यी दुवै भाँडाहरू अन्नबलिको तेल हालेको मसिनो पीठोले भरिएका थिए, ");
INSERT INTO npi2010_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","दश शेकेल ओजनको एउटा ठूलो सुनको धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होमबलिको निम्ति एउटा जवान गोरू, एउटा साँढे भेडा अनि एउटा एक वर्षे थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक बर्षे पाँचवटा थुमा। हेलोनको छोरो एलीआबको उपहार यस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","चौथो दिन रूबेन कुल नायक सदेऊरका छोरो एलीसूरले उपहार चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","तिनको उपहार यस प्रकारको थियोः पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल ओजनको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल हालेको मसिनो पीठोले भरिएको थियो, ");
INSERT INTO npi2010_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","दश शेकेल ओजनको एउटा ठूलो सुनको धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एउटा एक वर्षे थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","मेलबलिको निम्ति दुइवटा गोरूहरू, पाँचवटा भेडाहरू, पाँचवटा बोकाहरू अनि एक वर्षे पाँचवटा थूमाहरू। सदेऊरको छोरो एलीसूरको उपहार यस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","पाँचौं दिन सिमोनका कुल नायक सूरीशद्‌दैको छोरो शलूमीएलले उपहार चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","तिनको उपहार यस प्रकारको थियो। पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल ओजनको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल हालेको मसिनो पीठोले भरिएका थिए, ");
INSERT INTO npi2010_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","दश शेकेल ओजनको सुनको एउटा ठूलो धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एउटा एक वर्षे थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पापबलिको निम्ति एउटा वोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक वर्षे पाँचवटा थुमा सूरीशदूदैको छोरो शलूमीएलको उपहार यस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","छैटौं दिन गादका कुलनायक रूएलका छोरो एल्यासापले आफ्नो उपहार चढाए र ");
INSERT INTO npi2010_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","तिनको उपहार यस प्रकारको थियो। पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल ओजन भएको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्केको मसिनो पीठोले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","दश शेकेलको सुनको एउटा ठूलो धूपौरो। यो धूपौरो धूपले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक बर्षे थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","अनि मेल बलिको दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोकाहरू अनि एक वर्षे पाँचवटा थुमा, रूएलको छोरो एल्यासापले चढाएको बलि यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","सातौं दिन एप्रैम वंशको प्रमुख अम्मीहूदको छोरो एलीशामाले उपहार चढाए। तिनले चढाएको उपहार यस प्रकार थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","पवित्र स्थानमा चलाइने परिमाण अनुसार त्यहाँ एक सय तीस शेकेल चाँदीको थाल, सत्तरी शेकेल ओजनको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्केको मसिनो पीठोले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","दश शेकेल सुनको एउटा ठूलो धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक वर्षे थुमा। ");
INSERT INTO npi2010_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पापबलिको निम्ति एउटा वोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","अनि मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक वर्षे पाँचवटा थुमा। अम्मीहूदको छोरो एलीशामाले चढाएको बलि यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","आठौं दिन मनश्शे कुलको नायक पदासूरका छोरो गमलीएलले आफ्नो उपहार चढाए। तिनले चढाएको उपहार यस प्रकारको थियोः ");
INSERT INTO npi2010_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","पवित्र स्थानमा चलाइएको ओजन अनुसार एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल ओजनको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्केको मसिनो पीठोले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","दश शेकेलको सुनको एउटा ठूलो धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक वर्षे एउटा थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","अनि मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक वर्षे पाँचवटा थुमा। पदासूरको छोरो गमलीएलले चढाएको बलि यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","नवौं दिन बिन्यामीन कुलका नायक गिदोनीको छोरो अबीदानले आफ्नो उपहार चढाए। तिनले चढाएको उपहार यस प्रकारको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","पवित्र स्थानमा चलाइएको परिमाण अनुसार त्यहाँ एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल परिमाणको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्केको मसिनो पीठोले भरिएको थियो, ");
INSERT INTO npi2010_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","दश शेकेल ओजन गरिने सुनको एउटा ठूलो धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक बर्षे एउटा थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","अनि मेलबलिको निम्ति दुइवटा गोरूहरू, पाँचवटा भेडाहरू, पाँचवटा बोकाहरू अनि एक वर्षे पाँचवटा थुमाहरू। गिदोनीको छोरो अबीदानले चढाएका बलिहरू यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","दर्शों दिन दान कुलका नायक अम्मीशद्‌दैको छोरो अहीएजेरले आफ्नो उपहार चढाए। तिनले चढाएको उपहार यस प्रकारको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेल ओजन चाँदीको थाल, सत्तरी शेकेल परिमाणको एउटा भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्केको मसिनो पीठोले भरिएको थियो, ");
INSERT INTO npi2010_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","दश शेकेलको सुनको एउटा ठूलो धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होम बलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक बर्षे एउटा थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","अनि मेलबलिको निम्ति दुइवटा गोरू, पाँचवटा भेडा, पाँचवटा बोका अनि एक बर्षे पाँचवटा थुमा। अम्मीशद्‌दैनका छोरो अहीएजेरले चढाएको बलिहरू यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","एघारौं दिन आशेर कुलका नायक ओक्रानका छोरो पगीएलले आफ्नो उपहार चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","उस द्वारा चढाएको उपहार यस प्रकार थियो। पवित्र स्थानमा चलाइएको परिमाण अनुसार एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेलको चाँदीको भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्किएको मसिनो पीठोले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","दश शेकेल ओजनको सुनको एउटा ठुलो धूपौरो। यो धूपौरो सुगन्धले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक बर्षे एउटा थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","अनि मेलबलिको निम्ति दुईवटा गोरूहरू, पाँचवटा भेडाहरू, पाँचवटा बोकाहरू अनि एक बर्षे पाँचवटा थुमाहरू। ओक्रानको छोरो पगीएलले चढाएको बलिहरू यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","बार्हौं दिन नप्ताली कुलका नायक एनानको छोरो अहीराले आफ्नो उपहार चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","तिनले चढाएको उपहार यस प्रकार थियो। पवित्र स्थानमा चलाइएको परिमाण अनुसार त्यहाँ एक सय तीस शेकेलको चाँदीको थाल, सत्तरी शेकेल चाँदीको भाँडा, यी दुवै भाँडाहरू अन्नबलिको तेल छर्किएको मसिनो पीठोले भरिएको थियो, ");
INSERT INTO npi2010_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","दश शेकेल ओजनको सुनको एउटा ठूलो धूपौरो। यो धूपौरो धूपले भरिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होमबलिको निम्ति एउटा जवान साँढे, एउटा भेडा तथा एक वर्षे एउटा थुमा, ");
INSERT INTO npi2010_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पापबलिको निम्ति एउटा बोको, ");
INSERT INTO npi2010_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","अनि मेलबलिको निम्ति दुइवटा गोरूहरू, पाँचवटा भेडाहरू, पाँचवटा बोकाहरू अनि एक बर्षे पाँचवटा थुमाहरू। एनानको छोरा अहीराले चढाएको बलि यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","मोशाले वेदी अभिषेक गरेको समयमा इस्राएली मानिसहरूका कुल नायकहरूले चढाएका उपहार यिनीहरू नै थिए। बाह्रवटा चाँदीको थाल, बाह्रवटा चाँदीको भाडा, बाह्रवटा सुनको ठूलो धूपौरो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","प्रत्येक चाँदीको थालको ओजन एकसय तीस शेकेल अनि प्रत्येक चाँदीको भाँडाको ओजन सत्तरी शेकेल थियो। भाँडा-कुँडाहरूको जम्मै चाँदीको तौल पवित्र स्थानको शेकेलको तौल बमोजिम 2,400 शेकेल थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","पवित्र स्थानमा चलाइएको परिमाण अनुसार, बाह्रवटा सुनको धूपौरोहरूको ओजन एउटाको दश शेकेल गरी जम्मा एक सय बीस शेकेल थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होमबलिको निम्ति चढाइएका पशुहरू जम्मा बाह्रवटा जवान गोरू, बाह्रवटा एक वर्षका पाठा भेडा, तिनीहरूलाई चाहिने अन्नबलि सहित बाह्रवटा थुमाहरू र पापबलिको निम्ति बाह्रवटा बोकाहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","मेलबलिको निम्ति चढाइएको पशुहरूको जम्मा संख्या-चौबिसवटा गोरू, साठीवटा भेडा, साठीवटा बोका र साठीवटा एक वर्षे थुमा थिए। वेदी अभिषेक गरिएको समयमा चढाइएको उपहारहरू यी नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","परमेश्वरसित कुरा गर्न जब मोशा भेट हुने पालभित्र गए, करारको सन्दूकमाथिको कृपा-आसनमा दुईजना करूब स्वर्गदूतहरूको माझबाट परमेश्वरले तिनीसंग बोलिरहेको आवाज सुने। यसरी परमेश्वरले तिनीसित कुरा गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारूनलाई भन जब तिमी बत्तीहरू जलाउँछौ, सातवटा बत्तीहरूले सामदानको अघिको क्षेत्रमा प्रकाश पार्नु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","यसकारण हारूनले यसै गरे। हारूनले बत्तीहरू ठीक ठाँउमा राखेर ठीक दिशा तिर फर्काए ताकि सामदान अघिको क्षेत्रलाई ती बत्तीहरूले उज्जयालो पार्न सकोस्। परमप्रभुले मोशालाई दिनुभएको आज्ञा तिनले पुरा गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","सामदान यस प्रकारले बनिएको थियोः सामदान सुन पिटेर बनाइएको थियो अनि यो यसको बैठकदेखि फूलहरू सम्म पिटिएको थियो। त्यो सामदान त्यही ढाँचामा बनिएको थियो परमप्रभुले जुन मोशालाई देखाउनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“इस्राएलका अरू मानिसहरूबाट लेवीहरूलाई छुट्याऊ अनि ती लेवीहरूलाई शुद्ध पार। ");
INSERT INTO npi2010_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","तिनीहरूलाई शुद्ध पार्नको निम्ति तिमीले यसो गर्नुपर्छ तिनीहरू माथि शुद्धीकरणको पानी छर्किदेऊ र त्यस पानीले तिनीहरूलाई शुद्ध तुल्याउँछ। त्यसपछि तिनीहरूले आफ्नो शरीरको सम्पूर्ण रौं काटुन् अनि आफ्नो लुगाहरू धुऊन् र तिनीहरू यसरी शुद्ध हुन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“तिनीहरूलाई जवान गोरू तिनीहरूको बथानबाट ल्याउन देऊ अनि यसको मसिनो पीठो तेलसित मिसाएको अन्यबली ल्याउन देऊ त्यसपछि तिमीले अर्को एउटा बथानबाट जवान गोरू पापबलिका निम्ति ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","त्यस पछि तिमीले ती लेवीहरूलाई भेट हुने पालको अघि ल्याउनु र इस्राएलको सबै जातिका मानिसहरूलाई भेला गर। ");
INSERT INTO npi2010_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","जब तिमीले लेवीहरूलाई परमप्रभुको अघि ल्याउँछौ इस्राएलको सबै मानिसहरूले तिनीहरू माथि आफ्नो हात राख्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","हारूनले लेवीहरूलाई परमप्रभु अघि इस्राएलका मानिसहरूको विशेष उपहारको रूपमा अर्पण गर्छन् अनि तिनीहरूले परमेश्वरका सेवा गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“लेवीहरूले तिनीहरूको हात बहरको टाउको माथि राख्नुपर्छ र एउटा बहर पापबलिको निम्ति चढाउनु पर्छ र अर्को चाँहि लेवीहरूको प्रायश्चितका निम्ति परमप्रभुलाई होमबलिको निम्ति चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","यसरी पूजाहारी हारून र तिनका छोराहरूको सहायताको निम्ति तिमीले लेवीहरूलाई नियुक्त गर र त्यसपछि लेवीहरूलाई तिमीले परमप्रभुको निम्ति विशेष उपहार स्वरूप चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","तिमीले तिनीहरूलाई इस्राएलका अरू मानिसहरूबाट छुट्टयाउनु पर्छ कारण लेवीहरू मेरा हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“तिमीले तिनीहरूलाई शुद्ध पारेर विशेष उपहार स्वरूप अर्पण गरे पछि तिनीहरू भेट हुने पालमा सेवा गर्न उपयुक्त हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","बिगतमा मैले इस्राएली मानिसहरूलाई तिनीहरूबाट जन्मेका पहिलो पुत्रहरू मलाई दिउन् भनी मागेको थिए। तर अहिले इस्राएली मानिसहरूबाट पहिले जन्मेको छोराहरूको सट्टामा म लेवी मानिसहरूलाई लिइरहेकोछु। इस्राएली मानिसहरूले मलाई लेवी मानिसहरू दिनेछन्। मैले तिनीहरूलाई मेरो लागि लिएको छु। ");
INSERT INTO npi2010_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएलमा जन्मने प्रत्येक जेठो मेरो हुनेछ चाहे त्यो मानिस होस् अथवा पशु, यसमा कुनै फरक पर्दैन। किन? किनभने मिश्र देशमा मैले प्रत्येक जेठो नानी र पशु मारेकोछु, अनि मेरो आफन्त बनाउनको निम्ति प्रत्येक जेठो छोरोलाई रोजें। ");
INSERT INTO npi2010_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","तर अब म तिनीहरूको सट्टामा लेवी मानिसहरू लिन्छु। इस्राएलमा अन्य जातिको परिवारहरूबाट जन्मेका जेठो छोराहरूको सट्टामा म लेवीहरूलाई ग्रहण गर्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","इस्राएलका सबै मानिसहरूबाट मैले लेवी मानिसहरूलाई चुनें अनि हारून र तिनका छोराहरूलाई भेटी स्वरूप दिएँ। तिनीहरूले इस्राएलका सबै मानिसहरूको सेवा गर्छन् जो भेट हुने पालमा आराधनाको निम्ति आउँदथे। तिनीहरूले इस्राएलको सबै मानिसहरूका निम्ति प्रायश्चित गर्नेछन्। तब पवित्र स्थान नजिक आँउदा इस्राएली मानिसहरूका निम्ति कुनै प्रकारको रोग अथवा कष्ट आई पर्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","त्यसकराण, लेवीहरूका विषयमा परमप्रभुको आज्ञासित राजी भएर मोशा, हारून अनि इस्राएलका सबै मानिसहरूले परमप्रभु द्वारा मोशालाई दिएका झैं प्रत्येक कुरा पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवीहरूले नुहाएर तिनीहरूको लुगाहरू धोए, हारूनले तिनीहरूलाई परमप्रभुको अघि विशेष उपहार स्वरूपमा अर्पण गरे अनि लेवीहरूका निम्ति प्रायश्चित गराएर तिनीहरूलाई सफा बनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","त्यसपछि लेवी मानिसहरू भेट हुने पालमा सेवा कार्य गर्न आए। हारून र तिनका छोराहरूले तिनीहरूको हेरचाह गर्थे अनि हारून र तिनका छोराहरू तिनीहरूको कामको जिम्मावारी थिए। परमप्रभुले मोशालाई जस्तो भन्नुभएको थियो हारून र तिनका छोराहरूले त्यसरी नै कार्यहरू गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","त्यपछि परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“यो लेवीहरूको नियम निम्ति हो। प्रत्येक लेवीहरू जो पच्चीस वर्षका अनि माथिका छन्। तिनी सबै भेट हुने पालको सेवामा भाग लिन आउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","तर जब कुनै लेवी मानिस पचास वर्ष भन्दा बेशी उमेरको हुन्छ उसले त्यहाँ फेरि काम गर्नु पर्दैन र उसले भेट हुने पालको सेवा कार्यबाट अवकाश लिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","पचास वर्ष अथवा त्यो भन्दा अधिक उमेरका मानिसहरूले भेट हुने पालको सेवा कार्यमा तिनीहरूका दाज्यू-भाइहरूलाई सहायता गर्नु सक्छन्। तर तिनीहरूले भारी काम गर्नु हुँदैन। यस्तो प्रकारले तिमी लेवीहरूलाई काममा खटाउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इस्राएली मानिसहरूले मिश्र देश छोडेको दोस्रो वर्षको पहिलो महीनामा सीनै पहाडको मरूभूमिमा परमप्रभु मोशासित यसो भन्दै बोल्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“इस्राएलका मानिसहरूले तोकिएको दिन निस्तार चाड मान्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","तिमीहरूले यस चाडलाई यसै महिनाको चौधौं दिनको गोधुली समयमा मान्नु पर्छ। तिमीहरूले सबै नियम र विधि-विधानहरू पालन गरेर यो चाड मनाउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","यसर्थ मोशाले मानिसहरूलाई निस्तार पर्व मनाउन लगाए। ");
INSERT INTO npi2010_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","तिनीहरूले पहिलो महीनाको चौधौं दिन गोधुली वेलामा सीनैको मरूभूमिमा निस्तार चाड मनाए। इस्राएलका मानिसहरूले परमप्रभुले मोशालाई आज्ञा दिनु भए बमोजिम नै मनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","तर केही मानिसहरूले त्यस दिन निस्तार चाड मनाउन सकेनन् कारण तिनीहरूले मान्छेको लाश छुएका थिए। यसर्थ ती मानिसहरू त्यस दिन मोशा तथा हारून भएकहाँ गए। ");
INSERT INTO npi2010_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ती मानिसहरूले मोशालाई भने, “हामीले मान्छेको लाश छोएर अशुद्ध भएको कारण पूजाहारीले हामीलाई तोकिएको समयमा परमप्रभुलाई उपहार चढाउन दिएनन्। यसर्थ हामीले तोकिएको समयमा अरू मानिसहरूसित निस्तार चाड मनाउन सकेनौं र अब हामीले के गर्नु पर्ने हो।” ");
INSERT INTO npi2010_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशाले तिनीहरूलाई भने, “यस विषयमा परमप्रभुले के भन्नु हुनेछ म उहाँलाई सोध्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएलका मानिसहरूलाई यसो भन। यो नियम तिनीहरू र तिनीहरूका भावी सन्तानहरूका निम्ति हो। यदि कसैले एउटा मुर्दालाई छुन्छ अनि अपवित्र हुन्छ अथवा कोही टाडा गएका छन् यस्तो दुवै अवस्थामा पनि उसले यो निस्तार चाढ मनाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","तिनीहरूलाई यो चाड दोस्रो महीनाको चौधौं दिनको गोधुली बेलामा मनाउन देऊ। तिनीहरूले थुमासित अखमीरे रोटी र तीतो साग खानु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","तिनीहरूले चढाएको निस्तारबलि भोलिपल्ट बिहानसम्म त्यसबाट केही बाँकी नराख्‌न् र त्यसको कुनै हड्डी नभाँच्नु। सबै निस्तार चाडको नियम अनुसार तिनीहरूले मानुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","तर यदि कुनै मानिस शुद्ध छ अनि टाडा पनि गएको छैन अनि अझ उसले निस्तार चाड मनाउँदैन भने, रातको समयमा उसले परमप्रभुलाई बलिदान नचढाएको खण्डमा उसलाई उसको मानिसहरूबाट बहिष्कार गर्नु पर्छ। त्यस्तो व्यक्तिले उसको पापको निम्ति दण्ड पाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“यदि कुनै विदेशी तिमीहरूसित स्थायी रूपले बसोबास गरिरहेको छ अनि उसले पनि निस्तार चाड मनाउन चाहन्छ भने उसले मनाउन सक्छ, तर त्यस व्यक्तिले निस्तार चाडको नियम पालन गर्नु पर्छ। त्यो प्रत्येकको निम्ति नियम हो।” ");
INSERT INTO npi2010_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","पवित्र वास स्थान, करारको पाल खडा गरेको दिन परमप्रभुको बादलले त्यसलाई ढाक्यो। पवित्र स्थान माथिको बादल राती आगो जस्तो देखियो। ");
INSERT INTO npi2010_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","सब समय त्यो बादल पवित्र पालमाथि रह्यो र राती चाँहि त्यो बादल आगो जस्तो देखिन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","जब पालमाथिको बादल सर्थ्यो इस्राएली मानिसहरू पनि हिंडथे र जब बादल पालमाथि अडिन्थ्यो ती मानिसहरूले त्यहीं शिविर हाल्थे। ");
INSERT INTO npi2010_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","जब परमप्रभुले आज्ञा गर्नु भयो मानिसहरू हिंडे र जब वहाँले आज्ञा दिनुभयो मानिसहरू हिडन बन्द गरे र तिनीहरूले छाउनी स्थापित गरे। जबसम्म पवित्र पालमाथि बादल रहन्थ्यो मानिसहरू छाउनी भित्र रहन्थे। ");
INSERT INTO npi2010_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","कोही समय बादल पवित्र पालमाथि लामो समयको निम्ति रहन्थ्यो। इस्राएलीहरूले परमप्रभुको आज्ञा पालन गरेर कतै सर्दैन थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","कहिले काही बादल पवित्र पाल माथि केही दिनको लागि रहन्थ्यो। परमप्रभुको आज्ञामा तिनीहरू छाउनी बसाल्थे र परमप्रभुकै आज्ञामा तिनीहरू सर्थे। ");
INSERT INTO npi2010_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","अनि कोही बेला साँझदेखि बिहान सम्मै अडिन्थ्यो, र बिहान बादल सरे पछि तिनीहरू पनि हिडथे। ");
INSERT INTO npi2010_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","दुई दिन, एक महिना अथवा पुरै एक वर्ष बादल पवित्र स्थानको पाल माथि अडिरहे इस्राएलको मानिसहरूको शिविर पनि त्यहीं रहन्थ्यो र कतै सर्दैनथ्यो। तर जब त्यो बादल सर्थ्यो इस्राएलका मानिसहरू पनि यात्रा शुरू गर्थे। ");
INSERT INTO npi2010_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","परमप्रभुको आज्ञा अनुसार तिनीहरूले शिविर हाले अनि परमप्रभुकै आज्ञा अनुसार यात्रा शुरू गरे। मोशाद्वारा तिनीहरूले परमप्रभुको आज्ञा पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","परमप्रभुले मोशालाई भन्नुभयोः ");
INSERT INTO npi2010_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“दुइवटा तुरहीहरू बनाऊ। चाँदी पिटेर तुरहीहरू बनाउनू। यी तुरहीहरू मानिसहरूलाई एक साथ भेला गराउनु तथा कति बेला छाउनीबाट यात्रा शुरू गर्नु पर्ने शंकेतको निम्ति प्रयोग गरिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","यदि दुवै तुरहीहरू लामो तानेर बजाईयो भने सबै मानिसहरू भेट हुने पालको प्रवेशद्वारमा भेला हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","तर जब एउटा मात्र तुरही लामो बजाइन्छ तब केवल कुलनायकहरू मात्र तिमीलाई भेट्न आउनेछन्। ती प्रमुखहरू इस्राएलका बाह्र कुल समूहका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“जब तिमीहरूले तुरही बजाएर जागरन ध्वनी दिन्छौ, पूर्वमा छाउनी बनाउने मानिसहरूले यात्रा शुरू गर्ने छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","जब तिमीहरूले दोस्रो पल्ट तुरहीको सूक्ष्म ध्वनी दिन्छौ दक्षिणका छाउनीमा रहेकाहरूले यात्रा शुरू गर्छन्। तिनीहरूले यात्रा शुरू गराउँदा चेतावनीको तुरही बजाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","तर जब तिमीहरू मानिसहरूलाई भेला गराउँछौ भने तुरही दीर्घ फुक्नु पर्छ तर चेतावनी ध्वनि नदेऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","हारूनका छोराहरू, पूजाहारीहरूले तुरही फुक्नु पर्छ। तिमीहरूको सन्तानको निम्ति यो नियम हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“अनि जब तिमीहरू आफ्नो भूमिमा तिमीहरूलाई आक्रमण गर्ने तिमीहरूको शत्रुको विरूद्धमा युद्ध गर्न जान्छौ, तिमीहरूले चेतावनी दिने तुरही बजाऊ अनि परमप्रभु तिमीहरूका परमेश्वरले तिमीहरू प्रति ध्यान दिनुहुनेछ। अनि उहाँले तिमीहरूको रक्षा गर्नुहुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","तिमीहरूको र्हषको दिन, तिमीहरूको औंसीका चाडहरूका दिन तिमीहरूले होमबलि र मेलबलि चढाउँदा तुरही बजाउनु पर्छ। परमप्रभुको स्मरण गर्नु तिमीहरूको निम्ति यो एउटा विशेष तरिका हुनेछ। म परमप्रभु तिमीहरूका परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","मानिसहरूले मिश्र देश छोडेको दोस्रो वर्षको दोस्रो महीनाको बिसौं दिनमा साक्षीको पवित्र पालबाट बादल सर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","यसकारण इस्राएलका मानिसहरूले सीनै मरूभूमिबाट आफ्नो यात्रा शुरू गरे। यात्रीहरू पारान मरूभूमिमा आइपुग्दा त्यो बादल अडियो। ");
INSERT INTO npi2010_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","यसर्थ मानिसहरूले यात्रा शुरू गरेको यही पहिलो पल्ट थियो। परमप्रभुले मोशालाई दिनुभएको आज्ञा अनुसार तिनीहरूले यात्रा गर्दथे। ");
INSERT INTO npi2010_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","यहूदाको दलको शिविरबाट आफ्नो झण्डा लिएर तीन समूह पहिले गए। अम्मीनादाबको छोरो नहशोनले दलको नेतृत्व गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","इस्साकारको कुलको अगुवाई सूआरका छोरो नतनेलले गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","अनि त्यसपछि जबूलून कुलको दल आए र यस दलहरूका नायक हलोनका छोरो एलीआब थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","त्यसपछि पवित्र पाल उठाइयो अनि गेर्शोनी र मरारी कुलका मानिसहरूले त्यो पाल बोके। यसर्थ यस परिवारका मानिसहरू दोस्रो पक्तिमा आए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","त्यसपछि रूबेन कुलका मानिसहरूले आफ्नो झण्डा लिएर यात्रा शुरू गरे। पहिलो दल रूबेनकै कुलबाट थियो। शेदेऊरको छोरो एलीसूर यस दलहरूको नायक थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","त्यसपछि शिमोन कुलका मानिसहरू थिए। यस दलहरूका नायक सरीशदूदैका छोरो सलूमीएल थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","अनि त्यसपछि गाद कुलका मानिसहरू आए अनि यस दलहरूका नायक रूएलका छोरो एल्यासाप थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","त्यसपछि कहात कुलका मानिसहरू आए। तिनीहरूले पवित्र-स्थान भित्रको समान बोकेका थिए। तिनीहरू यस्तो समयमा आइपुगे कि त्यस समयमा अन्य मानिसहरूले नयाँ शिविरमा पवित्र पाल खडा गरी सकेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","त्यसपछि एप्रैमको शिविरका दलहरू आफ्नो झण्डा लिएर अघि बढे। अम्मीहूदको छोरो एलीशामा दलहरूको नेतृत्वमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","पदासूरका छोरो गमलीएल मनश्शे कुलका दल नायक थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","त्यसपछि गिदोनीका छोरो अबीदान बिन्यामीन दल समूहका नायक थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","अन्तमा दान कुल समूहका मानिसहरू तीन दलहरूमा आफ्नो झण्डा लिएर अघि बढे। यसमा पहिलो दलहरू दान कुलका मानिसहरू थिए। यस दलहरूको नायक अम्मीशद्‌दैका छोरो अहीएजेर थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","त्यसपछि ओक्रानको छोरो पगीएल आशेर कुल समूहका दल नायक थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","त्यसपछि नप्ताली कुल समूहका मानिसहरू अघि आए अनि यस दलहरूको नायक एनानका छोरो अहीरा थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","यसरी नै इस्राएलका मानिसहरू एक ठाँउदेखि अर्को ठाँउ बसाँई सर्दै थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","मोशाले आफ्नो ससुरा रूएल मिद्यानीको छोरो होबाबलाई भने, “परमेश्वरले हामीलाई दिनेछु भनी प्रतिज्ञा गर्नु भएको ठाँउमा हामी जाँदैछौ, हामीसितै आउनुहोस्, हामी तपाईंलाई राम्रो गर्नेछौं। परमप्रभुले इस्राएलका मानिसहरूको निम्ति राम्रो राम्रो चिजहरू दिन्छु भनी प्रतिज्ञा गर्नु भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","तर होबाबले उत्तर दिए, “होइन म तिमीहरूसित जान्न, म आफ्नौं देश र मानिसहरूकहाँ जान्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","तब मोशाले भने, “तपाईंले हामीलाई नछाड्नु होस्। तपाईं हाम्रो पथ प्रदर्शक बन्न सक्नु हुन्छ कारण मरूभूमिको विषयमा हामीले भन्दा बेशी तपाईंले जान्नुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","यदि तपाईं हामीसित हिडनु भए परमप्रभुले हामीलाई दिनु भएको असल चीजहरू बाँड्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","होबाब राजी भए अनि परमप्रभुको पर्वतबाट तिनीहरूले यात्रा शुरू गरे। पूजाहारीले परमप्रभुको करारको सन्दूक लिएर मानिसहरूको अगाडी हिडे। तिनीहरूले पवित्र सन्दूक बोकेर नयाँ शिविर बनाउने ठाँउ खोज्दै तीन दिन सम्म हिडे। ");
INSERT INTO npi2010_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","परमप्रभुको बादल प्रत्येक दिन तिनीहरू माथि नै रहन्थ्यो अनि प्रत्येक बिहान जब तिनीहरू शिविरबाट यात्रा शुरू गर्थे बादलले तिनीहरूलाई अगुवाई गर्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","शिविर सार्नलाई जब मानिसहरूले पवित्र सन्दूक उठाँउथे, मोशाले सँधैं भन्थे, “हे परमप्रभु! उठ्नुहोस्, तपाईंको शत्रुहरू छरपष्ट होउन्। तपाईंका शत्रुहरू तपाईं देखि भागून्।” ");
INSERT INTO npi2010_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","अनि जब पवित्र सन्दूकलाई त्यसको ठाँउमा राखिन्थ्यो, सधैं मोशाले भन्थे, “हे परमप्रभु, इस्राएलका हजारौं-हजारौं मानिसहरू भएको ठाँउमा आउनु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","जब मानिसहरूले परमप्रभु अघि एकदमै गनगनाउन थाले, परमप्रभु त्यो सुनेर उहाँ क्रोधित हुनु भयो र तिनीहरूको विरूद्धमा आगो पठाउनु भयो। अनि त्यस आगोले छाउनीको केही किनाराहरू पनि जलायो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","मानिसहरूले मोशालाई सहायता मागे अनि मोशाले परमप्रभुको प्रार्थना गरेर आगो निभाए। ");
INSERT INTO npi2010_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","यसर्थ मानिसहरूले त्यस ठाँउको नाम तबेरा राखे कारण परमप्रभुबाट उत्पत्ति भएको आगोले तिनीहरू कतिलाई पोलेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","इस्राएलीहरूसंग रहेको विदेशीहरूको एउटा दलले मासु खान साह्रै इच्छा गरे चाडै सबै इस्राएली मानिसहरूले पनि मासुको लागि गनगनाउन थाले। ती मानिसहरूले विलाप गरेर भने, “हामीलाई मासु खानु कसले देला? ");
INSERT INTO npi2010_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","हामीले मिश्रमा हुँदा बिना मूल्य माछा खाएको सम्झना आँउछ। साग-पातहरू, काँक्रा, खरबुजा, हरियो साग सब्जी, प्याज अनि लसूनहरूको सम्झना आँउछ। ");
INSERT INTO npi2010_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","तर अहिले हामीले भोक नै हरायौं। मन्न बाहेक केही खानेकुरा देख्दैनौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","देख्दा मन्न धनिंयाको मसिनो दाना जस्तो हुन्छ र यसको रंग रूखको चोप जस्तो देखिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","मानिसहरूले मन्न बटुलेर ढुङ्गाले पिध्थे र भाँडामा पकाउँथे अथवा यसलाई धूलो पारेर फुरौलो बनाउँथे। यसको स्वाद भद्राक्षको तेलमा पकाएको फुलौरोको जस्तो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","जब राती भूँइ शीतले भिज्छ मन्न भूँईमा झथ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","प्रत्येक परिवारका मानिसहरू आ-आफ्नो पालको प्रवेशद्वारमा बसेर गनगनाई रहेका थिए। यसले परमप्रभुलाई अत्यन्तै रीस उठायो अनि मोशा पनि दुःखीत भए। ");
INSERT INTO npi2010_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशाले परमप्रभुलाई भने, “तपाईंको दासलाई किन कष्ट दिनु भयो? मैले तपाईंलाई किन सन्तुष्ट पार्न सकिन जसले गर्दा यी मानिसहरूको जिम्मावारी म माथि थप्नु भयो? ");
INSERT INTO npi2010_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","के मैले गर्भ धारण गरेर यी मानिसहरूलाई जन्माएको हुँ र? तपाईंले यिनीहरूका पुर्खाहरूसित प्रतिज्ञा गरेर दिन्छु भनेको भूमिमा एउटी रोगी-सेविकाले नानी बोकेर हिंडे झैं यी मानिसहरूलाई छात्तीमा राखेर लैजानु भन्नुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","जब यी मानिसहरू हामीलाई मासु खान दिनु भन्दै मसंग रून्छन्, ‘त मैले यिनीहरूलाई खुवाउने मासु कहाँ पाउनु?’ ");
INSERT INTO npi2010_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","यी मानिसहरूको हेरचाह गर्न म आफै योग्य छैन् कारण ममाथि जिम्मावारी एकदमै बेशी भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","यदि तपाईं मसित यस्तै व्यवहार गर्नुहुन्छ र तपाईंले मलाई मन पराउनु हुन्छ भने बरू मलाई मारिदिनोस ताकि मैले आफ्नै कष्ट भोग्नु पर्दैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","परमप्रभुले मोशालाई भन्नुभयो, “सत्तरी जना बूढा-प्रधानहरूलाई जम्मा गर जसलाई तिमीले बूढा-प्राधानहरू अनि मानिसहरूको अगुवा जस्तै सम्मान गरेका छौ अनि तिनीहरूलाई म भए कहाँ भेट हुने पालमा ल्याऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","अनि म तल आएर त्यहाँ तिमीसंग कुरा गर्नेछु। अनि तिमीमा भएको केही शक्तिको आत्मा लिनेछु र यसलाई तिनीहरूमाथि हाली दिनेछु। अनि तिनीहरूले पनि तिमीहरूसित मानिसहरूलाई डोर्याउने भारहरू लिन सहायता गर्नेछ, ताकि तिमी एक्लै त्यो सबै सहनु पर्दैन। ");
INSERT INTO npi2010_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“अनि मानिसहरूलाई भन तिमीहरूले आफैलाई पवित्र बनाएर राख भोलि तिमीहरूले मासु खानेछौ। ‘हामी मासु खान चाहन्छौ! हाम्रो लागि मिश्रमा नै राम्रो थियो।’ भनी तिमीहरू रोएको परमप्रभुले सुन्नु भएको थियो। यसर्थ अब परमप्रभुले तिमीहरूलाई मासु दिनुहुनेछ र खान सक्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","तिमीहरूले एक दिन, अथवा दुई दिन, अथवा पाँच दिन मात्र होइन दश दिन अथवा बीस दिन भन्दा बढी मासु खानेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","तिमीहरूले महीना भरि मासु खाने छौ। तिमीहरूले मासु खाने छौ जब सम्म तिमीहरू यसको लागि बिमार हुनेछौ। तिमीहरूलाई यस्तो हुनेछ किनभने तिमीहरूले परमप्रभुको विरूद्ध आरोप लगायौ। परमप्रभु तिमीहरूको माझमा रहनुहुन्छ अनि तिमीहरूलाई के आवश्यक छ जान्नु हुन्छ। तर रोयौ अनि उहाँलाई आरोप लगायौ तिमीहरूले भन्यो, ‘हामी किन मिश्रमा सदा रहेनौ?’” ");
INSERT INTO npi2010_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","तब मोशाले भने, “अहिले मसित पैदल हिडने 600,000 मानिसहरू छन् अनि तपाईं भन्नुहुन्छ, ‘म तिनीहरूलाई पुरै एक महीना मासु खान दिन्छु।’ ");
INSERT INTO npi2010_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","के यी सबै भेडा तथा बाख्राको बगाल तथा गाई-गोरूको बथान मार्दा पनि तिनीहरूको निम्ति प्रर्याप्त हुन्छ र? के समुद्रका सबै माछाहरू मारे पनि तिनीहरूको निम्ति प्रर्याप्त हुन्छ र?” ");
INSERT INTO npi2010_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","परमप्रभुले मोशालाई भन्नुभयो, “के परमप्रभुको शक्ति सीमित छ? अब तिमीले देख्नेछौ मैले भनेको कुरो तिमीले पाउनेछौ कि छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","यसकारण मोशा बाहिर आए अनि परमप्रभुले तिनलाई भन्नु भएको कुरा मानिसहरूलाई भने। अनि इस्राएलका बूढा-प्रधानहरूबाट सत्तरी जना भेला पारेर तिनीहरूलाई पालको वरिपरि उभ्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","तब परमप्रभु बादलमा तल आउनु भयो र मोशालाई भन्नुभयो। तब परमप्रभुले केही आत्मा जो मोशा माथि थियो लिएर ती इस्राएलीहरूको 70 जना बूढा प्रधानहरू माथि हालि दिनु भयो तिमीहरूले अगमवाणी बोल्न शुरू गरे। त्यही समय मात्र थियो कि यी मानिसहरूले यस्तो गरे, उनीहरू माथि पवित्र आत्मा आए पछि। ");
INSERT INTO npi2010_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","त्यहाँ छाउनी भित्र दुईजना व्यक्ति एलदाद र मेदाद थिए। तिनीहरूको नाम 70 जना बूढा प्रधानहरूको सूचीमा हालिएको थियो। तर तिनीहरू छाउनी बाहिर गएका थिएनन्। तापनि आत्मा तिनीहरूमाथि पनि आयो र तिनीहरूले अगमवाणी गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","एकजना जवान मानिस मोशा कहाँ दगुर्दै आएर भन्यो, “छाउनीमा एलदाद र मेदादले अगमवाणी गरिरहेका छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","युवावस्थाबाट नै मोशाको सहायक रहेको नूनका छोरो यहोशूले तिनलाई भन्यो, “हे परमप्रभु! तिनीहरूलाई रोक्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","तर मोशाले उसलाई भने, “के तिमी मेरो डाह गर्छौ? म इच्छा गर्छु कि परमप्रभुले उहाँको आत्मा सबै मानिसहरूलाई आफ्नो हुनेछ यसकारण सबै अगमवक्ताहरू हुन सकुन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","त्यसपछि मोशा अनि सबै इस्राएलका बूढा-प्रधानहरू छाउनीमा फर्के। ");
INSERT INTO npi2010_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","परमप्रभुबाट बतास चल्न थाल्यो र समुद्रबाट बट्टाई चराहरू ल्याएर छाउनीको वरिपरि छरिदियो। यसरी ती बट्टाईहरू यति बिघ्न थिए कि तिनीहरू बाटोमा एकजना मानिसले दिन भरिमा हिडी सक्ने लम्बाईमा र जमीनदेखि तीन फुट बाक्लो थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","तिनीहरूले दिन अनि रात भरि बट्टाई चरा बटुले अनि सब भन्दा कम्ती बटुल्नेले पनि पुग नपुग दश होमर बटुल्यो। मानिसहरूले घाममा मासु सुकाउन छाउनी वरिपरि फिंजाए। ");
INSERT INTO npi2010_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","यद्यपि तिनीहरूको दाँतले मासु चपाउँदै थिए र तिनीहरूले यो खाई सक्नु अघि परमप्रभु तिनीहरूसित अतिनै क्रोधित हुनुभयो र परमप्रभुले तिनीहरूमाथि डर लाग्दो हैंजा फैलाइदिनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","यसकारण त्यस ठाँउको नाम किब्रोथ-हत्तावा राखियो किन भने तिनीहरू मासु खान धेरै लालची भएका थिए र हैंजाले तिनीहरू मरे। ");
INSERT INTO npi2010_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","किब्रोथ-हत्तावाबाट हसेरोत तिर लागे जहाँ तिनीहरू बास बसे। ");
INSERT INTO npi2010_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मरियम र हारूनले मोशाको विरूद्धमा आलोचना गरे किनभने तिनले एउटी कूशी महिलासित विवाह गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","तिनीहरूले भने, “के परमप्रभु मोशा मार्फत मात्र बोल्नु भयो र? के उहाँ हामी मार्फत बोल्नु भएन?” परमप्रभुले यो कुरा सुन्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","मोशा अति नै विनम्र मानिस थिए। पृथ्वीमा तिनी कुनै पनि मानिस भन्दा अधिक विनम्र मानिस थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","परमप्रभुले तुरून्तै मोशा, हारून र मरियमलाई बोलाउनु भयो, “तिमीहरू तीनजना भेट हुने पालमा आऊ।” यसकारण ती तीन जना त्यहाँ गए। ");
INSERT INTO npi2010_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","तब परमप्रभु बादलको खम्बामा आउनु भयो र पालको प्रवेशद्वारमा उभिनु भयो, “हारून र मरियम!” बोलाउनु भयो। तब यी दुईजना बाहिरा आए। ");
INSERT INTO npi2010_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","परमप्रभुले भन्नुभयो, “मलाई सुन! जब तिमीहरू माझ अगमवक्ता छन् म, परमप्रभु आफै दर्शनमा उसलाई परिचय दिन सक्छु। म सपनामा त्योसित कुरा गर्न सक्छु। ");
INSERT INTO npi2010_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","तर मोशा त्यस्तो होइन। ऊ मेरो विश्वासी दास हो र मेरो सबै घरानामा उसलाई विश्वास गर्न सक्छु। ");
INSERT INTO npi2010_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","जब म उनीसित बात गर्छु, म आम्ने-साम्ने बात गर्न सक्छु। जे सुकै म सोच्छु उसले जान्नु पर्छ। मैले उसलाई अड्को प्रयोग नगरी भन्न सक्छु। अनि मोशाले परमप्रभुको रूप देख्न सक्छन्। यसकारण तिमीहरू किन मेरो दासको विरूद्धमा बोल्न डराएनौ?” ");
INSERT INTO npi2010_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","परमप्रभु तिनीहरूसित साह्रै क्रोधित हुनुभयो र तिनीहरूलाई त्याग्नु भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","बादल पालबाटमाथि उठ्‌यो। हारूनले मारियमतिर हेरे अनि देखे कि तिनको छाला हिऊँ झैं सेतो भएको थियो अनि त्यो तिनलाई भयंङ्कर चर्म रोग लाग्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","तब हारूनले मोशालाई भने, “महाशय विन्ती छ, हामीले मूर्खतापूर्वक गरेको पाप दया गरी माफ दिनुहोस। ");
INSERT INTO npi2010_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","कृपा गरी गर्भमा कुहेको नानीको झैं उसले आफ्नो छाला गुमाउनु नदिनुहोस्।” (कहिले काही मृत जन्मेको बच्चाको आधा छाला सडेको हुन्छ।) ");
INSERT INTO npi2010_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","यसकारण मोशाले परमप्रभुलाई प्रार्थना गरे, “हे परमेश्वर कृपा गरी उसलाई रोग मुक्त गराइ दिनु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","परमप्रभुले मोशालाई उत्तर दिनुभयो, “यदि तिनको बाबुले तिनको मुखमा थुकिदिए भने, तिनी सात दिन सम्म लज्जित हुनुपर्छ। यसकारण तिनलाई सात दिन सम्म छाउनी बाहिर राख। त्यति समय पछि, तिनी स्वस्थ हुन्छिन। त्यसपछि तिनी छाउनीमा फर्की आउन सक्छिन्?” ");
INSERT INTO npi2010_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","यसर्थ तिनीहरूले मरियमलाई सात दिन सम्म छाउनी बाहिर राखे अनि तिनलाई छाउनीमा फर्काई नल्याए सम्म मानिसहरू त्यस ठाँउबाट कतै गएनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","त्यसपछि मानिसहरूले हसेरोतबाट छाउनी उठाई परान मरूभूमि सम्म यात्रा गरी त्यहीं छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“केही मानिसहरूलाई कनान देशको जासूस गर्नु पठाऊ। त्यही भूमि म इस्राएलका मानिसहरूलाई दिनेछु। बाह्र कुल समूहहरूको प्रत्येक कुलसमूहबाट एकजना नायक पठाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","यसकारण मोशाले परमप्रभुको आज्ञा पालन गरे। पारान मरूभूमिमा मानिसहरू छाउनी हालेर बसेको समय मोशाले यी नायकहरू पठाए। ");
INSERT INTO npi2010_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ती नायकहरूको नाम यी नै हुन्; रूबेनको कुलबाट जक्करको छोरो शम्मू, ");
INSERT INTO npi2010_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमोनको कुलबाट होरीको छोरो साफात, ");
INSERT INTO npi2010_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदाको कुलबाट यपून्नेको छोरो कालेब, ");
INSERT INTO npi2010_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्साकारको कुलबाट यूसुफको छोरो यिगाल, ");
INSERT INTO npi2010_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एप्रैमको कुलबाट नूनको छोरो होशे, ");
INSERT INTO npi2010_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बिन्यामीन कुलबाट रफूको छोरो पलती, ");
INSERT INTO npi2010_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलूनको कुलबाट सोदीको छोरो गद्‌दीएल, ");
INSERT INTO npi2010_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","मनश्शे कुलबाट सूसीको छोरो गद्‌दी, ");
INSERT INTO npi2010_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दानको कुलबाट गमल्लीको छोरो अम्मीएल, ");
INSERT INTO npi2010_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेरको कुलबाट माइकलको छोरो सतूर, ");
INSERT INTO npi2010_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नप्तालीका कुलबाट वोफ्सीको छोरो नहबी, ");
INSERT INTO npi2010_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गादको कुलबाट माकीको छोरो गूएल। ");
INSERT INTO npi2010_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मोशाले भूमि हेर्न र अध्ययन गर्न पठाएको मानिसहरूको नाम यी नै हुन्। मोशाले होशेलाई यहोशू भनी बोलाउँथे। ");
INSERT INTO npi2010_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","यद्यपि तिनीहरूलाई कनान देश जासूस गर्न पठाउँदा मोशाले भन्यो, “तिमीहरू पहाडीतिर जाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","अनि हेर, भूमि हेर्दा कस्तो देखिन्छ। त्यहाँ बस्ने मानिसहरू बलिया छन् अथवा दूर्वल, अथवा कम्ती छन् अथवा ठूलो जन सँख्यामा तिनीहरू बस्ने जग्गा राम्रो छ अथवा खराब, हेर र बुझ। कस्तो शहरमा तिनीहरू बसेका छन्? ");
INSERT INTO npi2010_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","तिनीहरू राम्रो कि नराम्रो छन्? तिनीहरू कस्तो किसिमका शहर भित्र बस्छन्? शहरहरू अत्यन्तै सुरक्षित छन्। तिनीहरू खुल्ला गाउँहरूमा बस्छन् अथवा किल्लाहरूमा बस्छन्? ");
INSERT INTO npi2010_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","हेर जमीन मलिलो छ वा रूखा छ, अनि हेर यदि त्यहाँ रूखहरू छन् कि छैनन्। त्यस भूमिबाट केही फलहरू ल्याउनु जातिसक्दो कोशिस गर।” त्यस समय दाखको प्रथम उलको कटनीको समय थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","यसकारण तिनीहरू सीनको मरूभूमि देखि रहोब द्वारा लेबो हमात तिर चढे अनि त्यस भूमिको जाँज गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","तिनीहरू नेगेवबाट उँभो चढेर अहीमन, शैशै अनि तल्मै हुँदै हेब्रोन पुगे, जहाँ अनाकका सन्तति बस्ने गर्थे। हेब्रोन शहर मिश्रमा सोआना शहर बनिनु भन्दा सात वर्ष अघि बनिएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","त्यस पछि तिनीहरू एश्कोल बेंसीमा आए। तिनीहरूले त्यहाँ एक झुप्पा दाख काटी एउटा घोचोमा दुइजनाले बोकेर ल्याए। तिनीहरूले अनार र नेभारा पनि ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","इस्राएलका मानिसहरूले त्यस ठाँउबाट दाखको झुप्पा काटेको हुनाले त्यस ठाँउको नाम नै एश्कोल बेंसी रह्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","चालीस दिनको अन्तमा तिनीहरू त्यो भूमि बारेमा खोजी गरी फर्के। ");
INSERT INTO npi2010_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","पारान मरूभूमिको कादेश भन्ने ठाँउमा जहाँ मोशा, हारून र सबै इस्राएली मानिसहरूलाई भेला भएर बसेका थिए अनि तिनीहरूको खबर तिनीहरूकहाँ ल्याए अनि तिनीहरूलाई त्यस भूमिको फल देखाए। ");
INSERT INTO npi2010_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","तिनीहरूले मोशालाई भने, “हामीलाई तपाईंले पठाउनु भएको भूमिमा गयौं। साँच्चै नै यो भूमि दूध र मह बगिरहेको भूमि रहेछ। अनि त्यस भूमिबाट हामीले ल्याएको फलहरू यी नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","जो मानिसहरू त्यस भूमिमा बसेकाछन् तिनीहरू बलिया छन् अनि शहरहरू अत्यन्तै विशाल र पर्खालले घेरिएका छन्। त्यहाँ हामीले अनाकको सन्तानहरू अनाकीहरूलाई पनि देख्यौं। ");
INSERT INTO npi2010_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","नेगेव भूमिमा अमालेकीहरूले बसो-बास गरेको पायौं भने पहाडी क्षेत्रमा हित्ती, यबूसी अनि एमोरीहरू, अनि समुद्रको किनार र यर्दन नदीको किनारमा कनानीहरू बसो-बास गर्दा रहेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","त्यसपछि कालेबले मोशाकै नजीक मानिसहरूलाई शान्त गराएर भने, “हामी त्यहाँ तुरून्त जानु पर्छ र यसलाई लिनु पर्छ। किनभने निश्चय नै त्यसमाथि हामीले विजय हासील गर्नेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","तर मानिसहरू जो ऊसित गएका थिए भने, “तिनीहरू माथि आक्रमण गर्नु हामी सक्षम हुने छैनौं किनभने तिनीहरू हामी भन्दा बलिया छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","यसकारण तिनीहरूले त्यस भूमिको विषयमा खोजी गरेर नैराश्यपूर्ण वृतान्त इस्राएली मानिसहरूको निम्ति ल्याएका थिए। तिनीहरूले भने, “त्यस भूमिमा धेरै बलिया बलिया मानिसहरू रहेछन् र त्यस भूमिमा जाने कुनै पनि मानिसहरूलाई तिनीहरूले सजिलै जित्न सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","हामीले त्यहाँ नपीलीहरू अनाकका सन्तान जसबाटलाई देख्यौ र तिनीहरूले हामीलाई मसिनो फट्यांग्राहरूलाई झैं हेरे। साँच्चै तिनीहरूको सामुन्ने हामी फट्यांग्राहरू झैं लाग्थ्यौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","सबै मानिसहरू छाउनीभित्र त्यस रातभरि कराई कराई रोइ रहे। ");
INSERT INTO npi2010_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","इस्राएलका सबै मानिसहरूले मोशा र हारूनको विरूद्धमा गनगनाए। सबै मानिसहरूले तिनीहरूलाई भने, “यदि हामी मिश्रदेशमा नै अर्थात् यो मरूभूमिमा मरेको भए राम्रो हुनेथियो। ");
INSERT INTO npi2010_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","किन परमप्रभुले हामीलाई लडाईमा तरवारले काटी मार्न त्यस भूमिमा लैजानु हुँदैछ? हाम्रा जहान बालबच्चाहरू पनि लूटिने समान झैं लूटमा पक्रा पर्नेछन्। हामीलाई मिश्र देशमा फर्किनु नै असल हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","तिनीहरूले एक अर्कामा भने, “एकजना अगुवा चुनौ र मिश्रदेश फर्कौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","सबै इस्राएली मानिसहरूको सामुन्ने मोशा र हारून भूइँमा घोप्टो परे। ");
INSERT INTO npi2010_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","नूनको छोरो यहोशू र यपून्नेको छोरो कालेब भूमिको जाँच गर्न जानेहरू मध्ये दुईजना थिए तिनीहरूले लुगाहरू च्याते मानिसहरूले गनगन गरेकोमा तिमीहरूको दुःख। ");
INSERT INTO npi2010_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","यहोशू र कालेबले इस्राएलका सम्पूर्ण समुदायलाई भने, “यो भूमि जसलाई हामीले जाँच गर्यौं त्यो धेरै राम्रो भूमि छ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","यदि परमप्रभु हामीसित सन्तुष्ट हुनु भए उहाँको अगुवाईमा हामीलाई त्यस भूमिमा पुर्याउनु हुनेछ अनि त्यो दूध र मह बग्ने भूमि हामीलाई दिनु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","यसर्थ परमप्रभु-विरूद्ध बिलाप नगर, त्यस भूमिका मानिसहरूसित नडराऊ किनभने हामी तिनीहरूलाई सजिलै जित्नेछौं। तिनीहरूको सुरक्षा तिनीहरूबाट हरण गरिएको छ। तर हामीसित भने परमप्रभु हुनुहुन्छ, तिनीहरूसित नडराऊ।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","तर त्यहाँ भएका सबै मानिसहरूले यहोशू र कालेबलाई ढुङ्गाले हिर्काएर मार्ने सल्लाह गरे। त्यसपछि भेट हुने पालमा सबै इस्राएली मानिसहरूको सामुन्ने परमप्रभुको महिमा देखा पर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","परमप्रभुले मोशालाई भन्नुभयो, “यी मानिसहरूले कहिले सम्म मसित घृणीत व्यवहार गर्छन्? यिनीहरूको माझमा मैले यी सबै महान चिन्हहरू देखाई सकेको छु र अब कहिले सम्म तिनीहरूले मलाई अविश्वास गर्छन्? ");
INSERT INTO npi2010_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","तिनीहरू माथि म महामारी ल्याएर ध्वंश पार्छु अनि तिमीद्वारा नै म तिनीहरू भन्दा ठूलो र शक्तिशाली राष्ट्र निर्माण गर्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","तब मोशाले परमप्रभुलाई भने, “मिश्र देशवासीहरूले यदि यो कुरा चाल पाए के भन्लान्? कारण तपाईंले नै यिनीहरूलाई आफ्नो शक्तिको प्रभावले तिनीहरूको माझबाट ल्याउनु भएको हो। ");
INSERT INTO npi2010_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","अनि मिश्रका मानिसहरूले कनानीहरूलाई यस विषयमा भन्नेछन् कारण तिनीहरू जान्दछन् कि तपाईंलाई देखेका छन्। तिनीहरूले यो पनि जान्दछन् कि तपाईं परमप्रभु हुनुहुन्छ र तिनीहरूले जान्दछन् कि मानिसहरूले तपाईंलाई देखेका छन्। तिनीहरूले यो पनि जान्दछन् कि मानिसहरूको अगुवाई गर्ने दिनमा तपाईंले बादलको प्रयोग गर्नु भएको छ भने रातमा आगोको प्रयोग गर्नु भएको छ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","यसर्थ अहिले तपाईंले यी मानिसहरूलाई मार्नु हुँदैन। यदि तपाईंले मार्नु भयो भने तपाईंको शक्तिको बारेमा जान्ने सबै राष्ट्रहरूले भन्नेछन्, ");
INSERT INTO npi2010_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘आफूले शपथ गरेको भूमिमा मानिसहरूलाई ल्याउन नसक्दा परमप्रभुले तिनीहरूलाई मरूभूमिमा मार्नुभयो।’ ");
INSERT INTO npi2010_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“यसर्थ अहिले हे मालिक आफ्नो महामहिमा प्रदर्शन गर्नुहोस्। तपाईंले प्रतिज्ञा गरे झैं देखाउनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","तपाईंले भन्नुभयो, ‘परमप्रभु ढिलो क्रोधित हुनुहुन्छ, परमप्रभु करूणामय हुनुहुन्छ। कानुन् अमान्य गरी जो दोषी बनिन्छ त्यस्ताहरूलाई परमप्रभुले क्षमा दिनुहुन्छ। तर जो दोषी छन् तिनीहरूलाई परमप्रभुले सदैव दण्ड दिनुहुन्छ। परमप्रभुले यस्ता मानिसहरूलाई, तिनीहरूका छोरा-छोरीहरूलाई, तिनीहरूका नाती-नातिनी तथा पनाती पनातिनीहरू सम्मलाई तिनीहरूले गरेको खराब कार्यको निम्ति दण्ड दिनुहुन्छ।’ ");
INSERT INTO npi2010_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","अहिले तपाईंले मानिसहरूलाई आफ्नो महान करूणा देखाउनु होस् र मिश्र देश छोडेर आएको दिनदेखि जसरी क्षमा गर्दै आउनु भएकोछ आज पनि ती मानिसहरूलाई क्षमा गरिदिनु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","परमप्रभुले भन्नुभयो, “तिमीले भने जस्तै म तिनीहरूलाई क्षमा दिनेछु। ");
INSERT INTO npi2010_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","तर म साँचो भन्दछु, जस्तो म जीवित छु र जसरी परमप्रभुको महिमाले पृथ्वी नै भरिन्छ, ");
INSERT INTO npi2010_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ती सबै मानिसहरू मेरो महिमा र मेरा अश्चर्य चिन्हहरू जो मैले मिश्र देशमा देखाएको देखेका छन् अनि दश पल्ट मलाई परीक्षा लिएका छन् र ऐले मेरो कुराहरू मान्दैनन्, यी सब मानिसहरूले मैले तिनीहरूको पुर्खाहरूसित दिन्छु भनी शपथ गरेको भूमि देख्न पाउने छैनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","तर मेरो दास कालेब जसले भिन्दै प्रकारले सोच्छ अनि त्यसले सम्पूर्ण रीतिले मेरो अनुसरण गर्छ म उसलाई त्यो भूमिमा जहाँ ऊ गयो ल्याउनेछु र उसको सन्तानले त्यो भूमि उपभोग गर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","अमालेकीहरू र कनानीहरू त्यही बेंसीमा बसिरहेका छन्। यसर्थ भोलि तिमीहरूले यो ठाउँ छाड्नु नै पर्छ र लाल समुद्र को बाटो भएर तिमीहरू त्यो मरूभूमिमा फर्की जाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“मेरो विरूद्धमा यी दुष्ट मानिसहरूले कहिले सम्म नालिश गरिरहने। इस्राएलका मानिसहरूले मेरो विरूद्धमा लगाएको नालिश मैले सुनेको छु। ");
INSERT INTO npi2010_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","तिनीहरूलाई भनी देऊ, ‘जस्तो म जिवित छु परमप्रभु भन्नुहुन्छ तिमीहरूले परमप्रभुको विरोधमा जे जति भनेका थियौ ती सब पूर्ण गरी दिनेछु। तिमीहरूलाई जे गर्नेछु त्यो यही हो। ");
INSERT INTO npi2010_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","तिमीहरूको बीचमा प्रत्येक व्यक्ति जो बीस वर्ष अथवा वेशी उमेरको छ अनि मेरो मानिस भनी गन्ती भएको थियो, त्यो यही मरूभूमिमा मर्नेछ। तिमीहरूले म परमप्रभुको विरूद्ध नालिश गर्यौ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","यसर्थ तिमीहरू मध्ये त्यो मैले दिन्छु भनी प्रतिज्ञा गरेको भूमिमा कोही पनि पस्न पाउने छैन्। केवल यपून्नेको छोरो कालेब र नूनको छोरो यहोशू त्यो भूमिमा पस्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","तिमीहरूले नालिश गर्यौ कि त्यो नयाँ भूमिमा तिमीहरूका शत्रुहरूले तिमीहरूका नानीहरू खोसेर लैजानेछन्। तर म तिमीहरूलाई भन्छु कि म ती नानीहरू ल्याउनेछु र तिनीहरूले त्यसभूमिमा ती चीजहरू आनन्दले उपभोग गर्नेछन जुन तिमीहरूले अस्वीकार गर्यौ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","तर तिनीहरूको निम्ति तिमीहरू यही मरूभूमिमा नै मर्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘तिमीहरूका नानीहरू मरूभूमिमा चालीस वर्ष सम्म गोठाले भई बस्नेछन्। तिमीहरू म प्रति अविश्वासी हुनाको कारणले ती तिमीहरूका नानीहरूले तिमीहरू मरूभूमिमा सबै जना नमरूञ्जेल सम्म कष्ट भोग्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","त्यो भूमिको खोजीमा मानिसहरूले चालीस दिन लगाएको हुनाले दिनको एक वर्षको हिसाबले तिमीहरूले चालीस वर्ष सम्म कष्ट भोग्ने छौ। तिमीहरूले चाल पाउनेछौ कि म तिमीहरूको विरोधी हुँदा के हुँदो रहेछ।’ ");
INSERT INTO npi2010_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“म परमप्रभुले बोलेको हुँ र म प्रतिज्ञा गर्छु कि यी सब दुष्ट मानिसहरू विरूद्ध यी कुराहरू गर्छु नै। यी मानिसहरू मिलेर मेरो विरोधमा खडा भए, यसर्थ यो मरूभूमिमा यिनीहरू मर्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ती व्यक्तिहरू ज-जसलाई मोशाले भूमि जांच गर्न पठाएका थिए तिनीहरूले भूमिको विषयमा इस्राएली मानिसहरूको निम्ति नराम्रो खबर लिएर आए। यसो गरेर तिनीहरूले सारा समूदायलाई उनको विरूद्धमा गनगन गर्ने बनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ती सबै मानिसहरूलाई मार्न परमप्रभुले महामारी खन्याई दिनुभयो किनभने मानिसहरूमा भ्रम फैलाउने कसुर तिनीहरूको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","तर नूनका छोरो यहोशू र यपून्नेका छोरो कालेब पनि ती भूमि बिषेयमा खोजी गर्न पठाइएका मानिसहरू बीच कै थिए, ती दुईजनालाई परमप्रभुले रक्षा गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","जब मोशाले यी सब कुराहरू इस्राएली मानिसहरूलाई बताइदिए तिनीहरू अत्यन्तै शोकाकुल भए। ");
INSERT INTO npi2010_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","बिहानै उठेर मानिसहरू पाहाडी इलाका तिर उक्लनु थाले। मानिसहरूले भने, “हामीले पाप गरेका छौ। परमप्रभुलाई हामीले अविश्वास गर्यौं, यसर्थ हामी पश्चताप गर्छौं र हामी परमप्रभुले दिन्छु भनी प्रतिज्ञा गर्नु भएको भूमिमा जानेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","तर मोशाले भने, “परमप्रभुको आज्ञा किन पालन गरिरहेका छैनौ? तिमीहरू सफल हुँदैनौ। ");
INSERT INTO npi2010_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","त्यसभूमिमा नजाऊ कारण परमप्रभु तिमीहरूको साथमा हुनुहुन्न र शत्रुहरूले साजिलै तिमीहरू माथि विजय प्राप्त गर्नेछन। ");
INSERT INTO npi2010_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","त्यहाँ अमालेकी र कनानी मानिसहरू तिमीहरूको विरोधमा लडनेछन्, तर तिमीहरूले परमप्रभुलाई छोडी दिएकोले उहाँ तिमीहरूले लडेको लडाँईमा साथ दिनुहुने छैन र तिमीहरू सबै मर्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","तर मानिसहरूले मोशाको कुरामा विश्वास गरेनन् र तिनीहरू पहाडी इलाकातिर गए। तर मोशा र परमप्रभुको करारको सन्दूक ती मानिसहरूसित गएन। ");
INSERT INTO npi2010_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","त्यो पहाडी इलाकामा बस्ने अमालेकी र कनानी मानिसहरू तलतिर उत्रे र ती इस्राएली मानिसहरूमाथि आइलागे। अमालेकी र कनानी मानिसहरूले इस्राएली मानिसहरूलाई सजिलै परास्त पारि तिनीहरू सबैलाई होर्मासम्म खेद्दै लगे। ");
INSERT INTO npi2010_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएलका मानिसहरूलाई भन जब तिमीहरू मैले दिन्छु भनेको भूमिमा पस्छौ, ");
INSERT INTO npi2010_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","तिमीहरूले परमप्रभुलाई आगोद्वारा विशेष बलिदान चढाउनु पर्छ। त्यो विशेष बलिदानको सुगन्धले परमप्रभुलाई आनन्द दिनेछ। तिमीहरूले होमबलि अथवा कुनै पनि बाख्रा, भाकल बलिदानको बलि, विशेष बलि, मेलबलि राजीखुशीको बलि अथवा कुनै चाडको निम्ति विशेष बलिमा गाई-वस्तु र भेडा अथवा बाख्राहरू चढाउनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“एकजना व्यक्तिले उपहार ल्याउँदा उसले परमप्रभुलाई अन्नबलि पनि दिनुपर्छ। बलि चढाउँदा अन्नबलिमा एक चौथाई हीन भद्राक्षको तेल हालेर आठ कप मसिनो पीठो ल्याउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","जब तिमी होमबलि साथमा अर्घबलिको निम्ति थुमा चढाउँछौ एक चौथाई हीन दाखरस पनि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“यदि तिमी भेडा बलि चढाउँछौ भने तिमीले अन्नबलि पनि तयार पार्नु पर्छ। अन्नबलिमा एपाको दश खण्डको दुइ खण्ड मसिनो पीठोमा हीनको तीन खण्डको एक खण्ड भद्राक्षको तेल मिसाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","अनि अर्घबलिको निम्ति हीनको तीन खण्डको एक खण्ड दाखरस राख्नु पर्छ र यसले परमप्रभुलाई मीठो वास्ना दिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“तिमीले यदि आफ्नो होमबलि, वा बलिदान, मेलबलि अथवा कुनै विशेष भाकलको निम्ति एउटा जवान साँढे तयार पार्न सक्छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","त्यस समयमा जवान साँढेसित तिमीले अन्न बलि पनि ल्याउनु पर्छ। अन्न बलि आधा हीन भद्राक्षको तेल मिसाएको एपाको दश खण्डको तीन खण्डको मसिनो पीठो हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","अर्घबलिको निम्ति आधा हीन दाखरस पनि ल्याउनु पर्छ। यो बलि आगोद्वारा चढाइन्छ र यसको सुगन्धले परमप्रभुलाई प्रसन्न पार्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","प्रत्येक साँढे अथवा भेडा अथवा थुमा अथवा बाख्राको पाठो परमप्रभुलाई बलि स्वरूप चढाउँदा यसरी तयार पार्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","यी कुनै आवश्यक छैन कति पशुहरू तिमीहरूले तयार गर्छौ, तर तिमीले यो प्रत्येक को निम्ति गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“इस्राएलका प्रत्येक नागरिकले परमप्रभुलाई प्रसन्न गराउन बलि चढाउँदा यही तरिकाले अगोद्वार चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","यदि तिनीहरू बीचमा बस्ने विदेशीहरूले आगोद्वारा बलि चढाएर परमेश्वरलाई खुशी पार्न चाहन्छ भने, तिमीहरूले तिनीहरूले जस्तै बलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","यही नियमहरू इस्राएलका मानिसहरू र तिनीहरूसित यो देशमा बसो बास गर्ने विदेशीहरू प्रत्येकको निम्ति लागू हुनेछ। यही कानून सदा सर्वदा लागू रहनेछ। तिमी र तिमीहरूसित बसो-बासो गर्ने विदेशीहरू परमप्रभुको उपस्थितीमा एकै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","त्यही नियम र विधि तिमीहरूको निम्ति र विदेशीहरूको निम्ति लगाइन्छ जो तिमीहरूसित बसो-बास गर्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएलका मानिसहरूलाई भनः जब तिमीहरू मैले लैजाँदै गरेको भूमिमा पुग्छौ, ");
INSERT INTO npi2010_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","अनि त्यस भूमिमा उब्जेको खाद्य जब तिमीहरू खान्छौ, तिमीहरूले परमप्रभुलाई बलि चढाउनै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","तिमीहरूको पहिलो हलोबाट तिमीहरूले एउटा रोटी बलि झैं चढाउनु पर्छ। यो तिमीहरूले यस्तै प्रकारले चढाउनु पर्छ जस्तो तिमीहरूको खलाबाट बलिहरू चढाइरहेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","यो नियम सदा-सर्वदाको निम्ति लागू रहनेछ र त्यो डल्लाबाट परमप्रभुको निम्ति प्रथम बलि तिमीहरूले चढाउँनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“अब परमप्रभुले मोशालाई दिनु भएको आज्ञाहरूमा यदि तिमीहरूले कुनै एक आज्ञा पालन गर्न भूल भयो अथवा बिर्स्यौ भने के गर्नुपर्छ? ");
INSERT INTO npi2010_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","मोशा मार्फत परमप्रभुले यी आज्ञाहरू तिमीहरूलाई दिनुभयो। परमप्रभुले यी आज्ञाहरू तिमीहरूलाई दिनु भएकै दिनदेखि यिनीहरू लागू छन्। अनि यी आज्ञाहरू निरन्तर चलिरहनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","यसर्थ यदि तिमीहरूले यी आज्ञाहरू मध्ये कुनै एउटा पालन गर्न भूल्यौ अथवा बिर्स्यौ भने के गर्छौ? यदि यी आज्ञाहरू मध्ये कुनै एउटा आज्ञा इस्राएलका सारा निवासीहरूले पालन गर्नु भूले अथवा बिर्से तब इस्राएलका सारा मानिसहरूले परमप्रभुलाई एउटा जवान साँढे होमबलि चढाउनु पर्छ। अन्नबलि र अर्घबलि पनि चढाउनु बिर्सनु हुँदैन। यो बलिको सुगन्धले परमप्रभुलाई सन्तुष्ट तुल्याउँछ। तिमीहरूले पापबलिको निम्ति एउटा पाठो पनि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“यस प्रकार पूजाहारीले इस्राएलका समस्त मानिसहरूको समुदायलाई प्रायाश्चित बनाउँछ त्यसकारण तिनीहरूलाई क्षमा दिनेछ। किनभने तिनीहरूको पाप इच्छाकृत थिएन। यसकारण यसको लागि तिनीहरूले आफ्नो होमबलि र पापबलि चढाए ता कि परमप्रभुले तिनीहरूलाई क्षमा गरून्। ");
INSERT INTO npi2010_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","त्यहाँ बस्ने सबै इस्राएलीहरू र विदेशीहरूलाई क्षमा गरिन्छ किनभने तिनीहरू सबैले भूल गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“तर यदि एउटाले अञ्जानमा पाप गर्छ भने, एक वर्षको पाठी, पापबलिको बलि झैं चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","यस्तो प्रकारले पूजाहारीले उसको निम्ति प्रायश्चित गराउने छ जसले अञ्जानमा भूल गर्छ क्षमा गरिन्छ। ताकि त्यो व्यक्तिलाई परमप्रभुबाट क्षमा गरिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","इस्राएलीहरूको बीचमा मानिसहरू चाहे इस्राएली नागरिकहरू हो अथवा विदेशी जो भए तापनि नियम सबैको निम्ति एउटा हुन्छ जसले अञ्जानमा भूल गर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“तर यदि कुनै एकजना व्यक्तिले जानी-जानी पाप गर्छ भने ऊ चाहे स्वदेशमा अथवा विदेशमा जन्मेको होस् उसले परमप्रभुलाई अपमान गर्छ र त्यस व्यक्तिलाई उसका मानिसहरूबाट बहिष्कृत गराउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","किनभने त्यो मानिसले देखाउँछ कि उसले उहाँको आज्ञालाई तोडे र परमप्रभुलाई घृणा गरे। अनि त्यो व्यक्ति उसको परिवारबाट बहिष्कार हुनै पर्छ। ऊ पापको दोषी छ र दण्डित हुनै पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","जब इस्राएलका मानिसहरू मरूभूमिमा थिए, तिनीहरूले विश्रामको दिनमा एकजना मानिसले दाउरा बटुल्दै गरेको देखे। ");
INSERT INTO npi2010_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ती मानिसहरू ज-जसले उसलाई दाउरा बटुल्दै गरेको भेट्टाएका थिए तिनीहरूले उसलाई मोशा, हारून र अरू सबै मानिसहरू भएको ठाँउमा ल्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","तिनीहरूले त्यस व्यक्तिलाई त्यहाँ राखे कारण उसलाई के दण्ड दिनु पर्ने जानेका थिएनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","तब परमप्रभुले मोशालाई भन्नुभयो, “त्यो मानिस मर्नु पर्छ। सबै मानिसहरूले उसलाई छाउनी बाहिर ढुङ्गाले हिर्काउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","यसकारण ती मानिसहरूले उसलाई छाउनी बाहिर ल्याए अनि ढुङ्गाले हिर्काएर मारे। परमप्रभुले मोशालाई आज्ञा दिनुभए अनुसार तिनीहरूले गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएलका मानिसहरूसित कुरा गर। तिनीहरूलाई यी कुराहरू भन् आउने पुस्ताहरू भरि तिमीहरूले फुर्काहरू बनाउनु पर्छ अनि तिनीहरूलाई तिमीहरूको लुगाको कुनामा टाँस्नु पर्छ। त्यस पछि तिमीहरूको लुगाको प्रत्येक कुनाको फुर्काहरूमा निलो धागो बाँध। ");
INSERT INTO npi2010_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","यसकारण जब तिमीहरूले फुर्का देख्छौ, तिमीहरूले परमप्रभुको आज्ञा सम्झने छौ र तिनीहरूलाई पच्छ्याउनेछौ अनि तिमीहरू भूल बाटोमा जाने छैनौ, तिमीहरूको आँखा अनि हृदयको लालस पच्छ्यायो, जसले तिनीहरूलाई अविश्वासी बनाउँछ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","तब तिमीहरू परमेश्वरको विशेष ब्यक्तिहरू हुनेछौ कारण तिमीहरूलाई आज्ञाहरू पालन गर्न याद आइरहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","म परमप्रभु तिमीहरूको परमेश्वर हुँ। म नै एक हुँ जसले तिमीहरूलाई मिश्र देशबाट बाहिर निकालेर ल्याँए। तिमीहरूको परमेश्वर हुनुलाई मैले यसो गरें। म परमप्रभु तिमीहरूका परमेश्वर हुँ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","यिसहारको छोरो, कहातको नाति अनि लेवीको पनाति कोरह अनि रूबेन कुलका एलीआबका छोराहरू दातान र अबीराम अनि पेलेतका छोरा ओन अट्टेरी भए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","इस्राएलका 250 मानिसहरू साथमा लिएर मोशाको विरोधमा गए। ती 250 मानिसहरू नाम चलेका तथा नेताहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","तिनीहरू मोशा र हारूनको विरोध गर्न जम्मा भए अनि तिनीहरूलाई भने, “तपाईंहरू हाम्रो अगुवाहरू भएको अब हामीलाई पूरा भयो! सम्पूर्ण समुदाय पवित्र छन् अनि परमप्रभु हाम्रो माझमा हुनुहुन्छ। तपाईंहरू किन आफैंलाई परमप्रभुका अरू मानिसहरू भन्दा उच्चाको सम्झनु हुन्छ?” ");
INSERT INTO npi2010_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","जब मोशाले तिनीहरूको कुरा सुने तिनी घोप्टो परेर भूँईमा निहुरीए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","त्यसपछि मोशाले कोरह र उनका मानिसहरूलाई भने, “भोली बिहान, परमप्रभुले जनाउनु हुनेछ कसलाई हाम्रो अगुवा झैं चुन्नु भएको छ, को पवित्र छ कसलाई उहाँकहाँ नजिक ल्याउनु भएको छ। उहाँ आफैले चुन्नु भएका एकजनालाई उहाँले उहाँको नजिक ल्याउनु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","यसो गर, तिमी कोरह र तिम्रो मानिसहरूले धुपौराहरू लेऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","त्यसमा आगो हालेर भोलि परमप्रभुको अगाडि, धूप हाल। जो कसलाई परमप्रभुले चुन्नुहुन्छ त्यो व्यक्ति पवित्र हो। हामीहरू तिमीहरू लेवीका छोराहरूबाट पूरा भईसकेका छौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","मोशाले पनि कोरहलाई भने, “ए लेवीहरू मेरो कुरा सुन। ");
INSERT INTO npi2010_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","इस्राएलका परमेश्वरले तिमीहरूलाई चुन्नु भएको छ र यसमा तिमीहरू खुशी हुनुपर्छ कि तिमीहरू विशेष मानिसहरू भएकाछौ। इस्राएलका अन्य मानिसहरू भन्दा तिमीहरू बेग्लै हौ। इस्राएलका मानिसहरूलाई आराधनामा सहायता पुर्याउन परमप्रभुले तिमीहरूलाई उहाँको नजीक बनाई पवित्र पालको विशेष काम गराउन राख्नु भएको छ। के यो धेरै होइन? ");
INSERT INTO npi2010_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","परमप्रभुले तिमी लेवीहरू, पूजाहारीहरूलाई सहायता पुर्याउनको निम्ति उहाँको नजीक ल्याउनु भएकोछ। तर अहिले तिमीहरू पूजाहारीहरू हुने कोशिश गरिरहेका छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","तिमीहरूका अनुयायीहरू र तिमीहरू एक साथ मिलेर परमप्रभु विरूद्ध गयौ। के हारूनले केही भूल गरेका छन्? होइन यसर्थ किन तिमीहरू हारूनको बारेमा नालिश गरिरहेका छौ?” ");
INSERT INTO npi2010_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","त्यसपछि मोशाले एलीआबका छोराहरू दातान र अबीरामलाई बोलाउन पठाए। तर ती दुईजना मानिसहरूले भने, “हामी आउने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","हामीहरूलाई दूध र मह बगिरहेको देशबाट तिमीले बाहिर लिएर आयौ। तिमीले हामीलाई मार्नको निम्ति मरूभूमिमा ल्यायौ अनि हामीलाई देखाउन चाहान्छौ कि हामी माथि तिम्रो अधिकार छ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","हामीले तिमीलाई किन पछ्याउनु? तिमीले हामीलाई मह र दूध बगिरहेको भूमिमा लगेनौ साथै परमेश्वरले प्रतिज्ञा गरेको भूमिमा पनि पुराएनौ। तिमीले हामीलाई दाखको खेत पनि दिएनौ। के यी मानिसहरूलाई तिमी धोका दिन्छौ? होइन! हामी आँउदैनौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","यसर्थ मोशा साह्रै क्रोधित भए। उनले परमप्रभुलाई भने, “मैले यिनीहरूलाई केही क्षति पुर्याएको छैन। मैले यिनीहरूबाट एउटा गधा पनि लिएको छैन। परमप्रभु! हजुरले यिनीहरूबाट कुनै बलि ग्रहण नगर्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","त्यसपछि मोशाले कोरहलाई भन्यो, “भोली तिमी र तिम्रा सबै अनुगामीहरू र हारून परमप्रभुको अघि खडा हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","प्रत्येकले आफ्नो-आफ्नो धूपौरो लिएर त्यसमा धूप हाल्नु पर्छ। अनि तिमीहरू प्रत्येकले आफ्नो धूपौरो परमप्रभु अघि ल्याउनु पर्छ। त्यहाँ दुई सय पचासवटा धूपौरो हुनुपर्छ। तिमी कोरह र हारूनले पनि धूपौरो लिनुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","यसर्थ तिनीहरू प्रत्येकले धूपौरो लिएर त्यसमा बलेको कोइला हालेर धूप हाले अनि भेट हुने पालको प्रवेशद्वारमा मोशा र हारून संगै उभिए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","कोरहले सबै आफ्ना मानिसलाई भेला गरेर भेट हुने पालको प्रवेशद्वारमा उभिए। तब परमप्रभुको महिमा सबै मानिसहरू कहाँ प्रगट भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","तब परमप्रभुले मोशा र हारूनलाई भननुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“यी सबै मानिसहरूबाट तिमीहरू अलग होऊ र यिनीहरूलाई म त्यति खेरै ध्वंश पार्नेछु।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","मोशा र हारूनले शिर निहुर्याएर भने, “हे परमेश्वर, तपाईं सबै मानिसको आत्माको परमेश्वर हुनुहुन्छ। जब एक जना मानिसहरूले पाप गर्छ, के तपाईं सम्पूर्ण समुदायसित रिसाउनु हुन्छ?” ");
INSERT INTO npi2010_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","तब परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“कोरह, दातान र अबीरामको पालहरूबाट सम्पूर्ण समुदायलाई पर हट्नु भन।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मोशा उठेर दातान र अबीराम भएकहाँ गए। इस्राएलका सबै बूढा-प्रधानहरूले तिनलाई पछ्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","मोशाले सबै मानिसहरूलाई चेतावनी दिंदै भने, “यी दुष्ट मानिसहरूको पालबाट तिमीहरू निस्केर जाऊ। तिनीहरूको कुनै पनि चीज स्पर्श नगर। यदि तिमीहरूले छोयौ भने तिनीहरूले गरेको पापले तिमीहरू ध्वंश पारिनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","यसकारण मानिसहरू कोरह, दातान र अविरामको पाल छोडेर गए। तब दतान र अबीराम तिनीहरूको पालमा गए। तिनीहरू तिनीहरूको पत्नीहरू र नानीहरू संग छाउनी बाहिर गए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","मोशाले भने, “यी मैले भनेका कुराहरू मेरो आफ्नो मनको विचार होइन, म प्रमाण दिन सक्छु कि परमप्रभुले मलाई यसो भन्नु भनी अह्राउनु भएको हो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","यी यहाँका मानिसहरू मर्नेछन्। तर यदि तिनीहरू साधारण तरिकाले मर्छन्। मानिसहरू सधै मर्ने तरिकाले मर्छ। तब त्यसले देखाउँछ कि परमप्रभुले साँचै नै मलाई पठाउनु भएको होइन्। ");
INSERT INTO npi2010_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","तर यदि परमप्रभुले केही नयाँ कुरो गर्नुहुन्छ, अनि भूँईले मुख बाएर तिनीहरू र तिनीहरूकहाँ भएको सबै चीजहरू सहित तिनीहरू जीवित पुरिन्छन् भने तिमीहरूले जान्नेछौ कि यी मानिसहरूले परमप्रभुको अपमान गरे र उहाँलाई अति क्रोधित बनाए।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","जब मोशाले यी कुराहरू भनी सके, ती मानिसहरू उभिएको धर्ती फाट्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","धर्तीले मुख बाए जस्तै भएर तिनीहरू सबैलाई निल्यो। कोरहको सबै मानिसहरू, तिनीहरूको परिवारहरू अनि तिनीहरूकोमा भएको प्रत्येक चीज धर्तीभित्र भासियो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","सबै ती मानिसहरू जिउँदै खाल्डा भित्र पुरिए। यी सबै तिनीहरूले आफ्नो बनाएका चीजहरू तिनीहरूसंगै पुरिए अनि धर्ती बन्द भयो। अनि तिनीहरू सम्पूर्ण रूपले अल्पिए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","अरू सबै इस्राएलका मानिसहरूले ती मानिसहरू पुरिदै गर्दाको आर्तनाद सुनेर चारैतिर तितर बितर हुँदै भने, “धर्तीले हामीलाई पनि निल्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","त्यसपछि परमप्रभुकहाँबाट आगो निस्केर गई धूप चढाउँदै गरेका 250 मानिसहरूलाई पनि ध्वंश पार्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“पूजाहारी हारूनको छोरो एलाजारलाई भन कि उसले आगोमा रहेको धुपौराहरू हटाओस् र ती पवित्र भईसकेको धुपौराहरूबाट आगो वरिपरि छरी दिओस्। ");
INSERT INTO npi2010_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ती मानिसहरूले मेरो विरोधमा पाप गरेकाले त्यही पापले आफ्नो जीवन गुमाए। तर धुपौराहरू पवित्र छन् कारण तिनीहरू परमप्रभुलाई समर्पण गरिएका हुन्। ती धुपौराहरू पिटेर पाता बनाऊ र वेदी छोप्ने काममा प्रयोग गर। यो इस्राएलका सबै मानिसहरूको निम्ति चेतावनी हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","यसकारण पूजाहारी एलाजारले ती मानिसहरूले ल्याएका काँसाको धुपौराहरू भेला गर्यो। मानिसहरू सबै जलेर खरानी भए तर धुपौराहरू त्यही थिए। तिनले केही मानिसहरूलाई ती काँसको धुपौराहरू पिटेर पाता बनाउन लगाई वेदी ढाक्ने काममा प्रयोग गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","तिनले यो काम मोशा मार्फत पाएको आज्ञा अनुसार गरे। त्यो वेदी ढाक्ने पाता चाँहि इस्राएलको मानिसहरूका निम्ति याद दिलाउने एक चिन्ह हुनेछ कि हारूनको सन्तान बाहेका अन्य कुनै अनाधिकृत मानिसले परमप्रभु अघि धूप जलाउने छैन नत्र कोरह र उसको अनुयायीहरू झैं ऊ मर्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","अर्को दिन इस्राएलका मानिसहरूको सम्पूर्ण समुदाय मोशा र हारूनको विरोधमा गुनासो गरे र भने, “तिमीहरूले परमप्रभुका मानिसहरूलाई मार्यौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","सम्पूर्ण समुदाय मोशा र हारूनको विरोध गर्न भेला हुँदै गर्दा तिनीहरूले भेट हुने पाल तर्फ हेरे अनि देखे कि पाललाई बादलले ढाक्यो र त्यहाँ परमप्रभुको महिमा देखा पर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","तब मोशा र हारून भेट हुने पालको सामुन्ने आए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“यो समुदायबाट तिमीहरू अलग हौ ताकि यिनीहरूलाई म अति शीध्र ध्वंश पार्न सँकु।” यसर्थ मोशा र हारूनले शिर निहुराए। ");
INSERT INTO npi2010_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","त्यसपछि मोशाले हारूनलाई भने, “धूपौरो ल्याऊ र त्यसकहाँ वेदीबाट आगो हालेर धूप हाल। अनि त्यो समुदाय भएकोमा झट्टै गएर तिनीहरूलाई प्रायश्चित गर्नुहोस्। किनभने परमप्रभु क्रोधित हुनु भएको छ र महामारी शुरू भएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","यसर्थ मोशाले भने जस्तै हारूनले धूपौरो लिएर मानिसहरूको बीचमा पसे र चाल पाए कि महामारी शुरू भई सकेको थियो अनि धूपौरोमा धूप हाली मानिसहरूको निम्ति प्राश्चित गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","तिनी जिउँदो र मरेको मानिसहरू बीचमा उभिए अनि महामरी रोकियो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","कोरहको कारणले मर्नेहरूको संख्याको अतिरिक्त त्यहाँ महामारीले मरेकाहरूको संख्या 14,700 पुग्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","त्यसपछि हारून भेट हुने पालमा मोशालाई भेट्न गए। महामारी थामियो। ");
INSERT INTO npi2010_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएलका मानिसहरूलाई भन, तिनीहरूले बाह्र पुर्खाका कुल-कुलबाट बाह्रवटा लौरोहरू ल्याऊन्। प्रत्येक लौरामा आफ्नो नाम लेख। ");
INSERT INTO npi2010_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवी कुलबाट ल्याएको लौरामा हारूनको नाम लेख। बाह्र कुल समूहको प्रत्येक कुल प्रमुख मानिसको निम्ति एउटा लौरो हुनुपर्छ। यी लौरोहरू भेट हुने पालमा करारको सन्दूक अघि राख। त्यो त्यही ठाँउ हो जहाँ म तिमीलाई भेट्छु। ");
INSERT INTO npi2010_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","इमान्दार पूजाहारीको निम्ति म एकजना व्यक्तिलाई चुन्छु। म जसलाई चुन्छु त्यस व्यक्तिलाई तिमीले चिन्न सक्छौ कारण ");
INSERT INTO npi2010_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","उसको लौरोमा नयाँ पालुवाहरू पलाउनेछन्। यस प्रकारले तिम्रो र मेरो विरोध गर्ने मानिसहरूलाई म रोक्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","त्यसपछि मोशाले इस्राएलका मानिसहरूलाई भने अनि तिनीहरूका बाह्र कुल नायकहरू प्रत्येकलाई एउटा-एउटा गरी बाह्रवटा लौरोहरू दिए। हारूनको लौरो पनि अरू लौरोहरूसितै थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मोशाले लौरोहरू करारको सन्दूक राखिएको पालमा परमप्रभुको अगाडी राखे। ");
INSERT INTO npi2010_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","करारको सन्दूक भएको पाल भित्र मोशा अर्को दिन पसे। अनि लेवी कुल समूहका नायक हारूनको लौरोमा पालुवा पलाएको देखे। त्यति मात्र नभई त्यस पालुवाले कोपिला हालेर फूली बदाम पनि फलेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","मोशाले ती सबै लौरोहरू परमप्रभुको अघिबाट सबै मानिसहरूको सामुन्ने ल्याए। प्रत्येक कुल प्रमुखले आफ्नो आफ्नो लौरो चिने। ");
INSERT INTO npi2010_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","तब परमप्रभुले मोशालाई भन्नु भयो, “हारूनको लौरो करारको सन्दूक अघि लगेर राख। यो सधैं मेरो विरोधमा नालिश गरी रहनेहरूको निम्ति चेतावनी हुनेछ र मेरो विरोधमा नालिश गर्न बन्द हुनेछ र मैले तिनीहरूलाई ध्वंश पार्नु पर्दैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","यसर्थ मोशाले परमप्रभुको आज्ञा अनुसार काम गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","तर इस्राएली मानिसहरूले मोशालाई भने, “हामी जान्दछौ कि हामी मर्नेछौ। हामी नष्ट भइसकेका छौं। हामी ध्वंश भयौं। ");
INSERT INTO npi2010_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","प्रत्येक मानिस जो परमप्रभुको पवित्र पाल नजिक जान्छ त्यो मर्छ। के हामी पनि मर्छौं?” ");
INSERT INTO npi2010_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","परमप्रभुले हारूनलाई भन्नुभयो, “अब उसो तिमी, तिम्रा छोराहरू अनि तिम्रा परिवारिक समूहका मानिसहरू पवित्र स्थानमा केही खराबी गरिए जिम्मावारी हुनेछौ। तिमी र तिम्रा छोराहरू पूजाहारीहरू विरूद्ध गरिएको खराबीको निम्ति जिम्मावारी हुनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","तिम्रो परिवार समूहका अन्य लेवी मानिसहरूलाई तिमीसित काम गराउन ल्याऊ। करारको पालमा काम गर्दा तिम्रा छोराहरूलाई तिनीहरूले सहयोग पुर्याउने छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","लेवी कुलमा भएका ती मानिसहरू तिम्रो नियन्त्रणमा रहनेछन्। पालभित्र गरिनु पर्ने भैपरी आँउने कामहरू तिनीहरूले गर्नेछन्। तर पवित्र स्थान अथवा वेदीमा राखिएको कुनै पनि चीजको नजिक तिनीहरू जानु हुँदैन। यदि तिनीहरू गए भने तिनीहरू मर्नेछन् अनि तिमी पनि मर्ने छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","तिनीहरूले तिमीसित भेट गर्नेछन् र तिमीसितै काम गर्ने छन्। भेट हुने पालको रेख देख गर्ने तिनीहरूको काम हुनेछ पाल भित्र गरिने सबै काम तिनीहरूले गर्ने छन्। कोही पनि तिमी जहाँ छौ त्यहाँ आउनु साहस गर्नेछैन। ");
INSERT INTO npi2010_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“तिमीले पवित्र स्थान र वेदीको रक्षकको काम गर्नेछौ ताकि मैले इस्राएलका मानिसहरूसित रिसाउन नपरोस्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","हेर! म आफैले ती तिम्रा दाज्यू-भाइ लेवीहरू इस्राएलका मानिसहरूको बीचबाट लिएकोछु। भेट हुने पालमा काम गर्नको निम्ति ती तिम्रो निम्ति बलि हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","तर तिमी र तिम्रो छोराहरू मात्र पूजाहारीको रूपमा सेवा गर्नलाई अनि वेदीको छेउ र पर्दाभित्र जान अनि म तिमीलाई एउटा उपहार दिंदैछु, त्यो तिम्रो पूजाहारीत्व। तर यदि कुनै व्यक्ति पवित्र स्थानको नजिकमा आयो भने त्यो मारिओस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","तब परमप्रभुले हारूनलाई भन्नुभयो, “इस्राएलका मानिसहरूले मलाई चढाएको सबै पवित्र उपहारहरूको रक्षा गर्नका निम्ति मैले तिमीलाई नियुक्त गरें। मैले तिमी र तिम्रा छोराहरूलाई इस्राएलका मानिसहले चढाएका पवित्र बलिहरू निरन्तर अंशको रूपमा दिएको छु। ");
INSERT INTO npi2010_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","वेदीहरूबाट पाइने वस्तुहरूमा यो सब भन्दा पवित्र वस्तु हो। मानिसहरूले अन्नबलि, पापबलि, दोषबलिहरू ल्याउँछन्। यी बलिहरू महा पवित्र बलिहरूको र नपाकिएको भागबाट तिमीले आफ्नो अंश पाउनेछौ। ती सब तिमी र तिम्रा छोराहरूको हुनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","तिमीहरूले ती चीजहरू महा पवित्र स्थानमा मात्र खानु पर्छ। तिम्रो परिवारको प्रत्येक पुरूषले खान सक्छन् तर तिमीले याद राख्नु पर्छ कि ती चीजहरू अत्यन्तै पवित्र हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“यो पनि तिम्रै हुनेछ कुनै पनि विशेष उपहार इस्राएलका मानिसहरूले मलाई चढाउँछन्, तिमीसित भएका तिम्रा छोरा-छोरीहरू र तिम्रो निम्ति स्थायी अंशको रूपमा दिन्छु। तिम्रो परिवारका प्रत्येक शुद्ध व्याक्तिले त्यो खान सक्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“इस्राएलका मानिसरूको कुनै पनि पहिलो बाली अथवा उब्जनी जस्तै अन्न, भद्राक्षको तेल र दाखरस, जो तिनीहरूले परमप्रभुमा समर्पण गर्छन, म ती सब तिमीलाई दिन्छु। ");
INSERT INTO npi2010_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","तिनीहरूको खेतमा पाकेको कुनै पनि अन्न जो तिनीहरूले परमप्रभुलाई चढाउन ल्याउँछन् त्यो तिम्रो हो र तिम्रो परिवारको कुनै पनि शुद्ध व्याक्तिले त्यो खान सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“इस्राएलमा प्रत्येक चीज जो परमेश्वरलाई पूर्णरूपले समर्पण गरिन्छ त्यो तिम्रो हो। ");
INSERT INTO npi2010_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“प्रत्येक जेठो चाहे व्यक्ति होस अथवा पशु जो आफ्नो आमाको प्रथम गर्भमा आँउछ र परमेश्वरलाई समर्पण गरिन्छ भने त्यो तिम्रो हुनेछ। तर जेठो जन्मेको पशु होस् अथवा मानिस त्यसको तिमीले मोल तिर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","जब नानी एक महीनाको हुँदा तिनीहरूले यसको मोल तिर्नु पर्छ। एक महिनाको नानीहरूको मोल पवित्रस्थानको शेकेल परिमाण अनुसार पाँच सेकेल हुन्छ। एक शेकेल बीस गेराको हुन्छ! ");
INSERT INTO npi2010_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“तर पहिले जन्मेको गाई, भेडा अथवा बाख्राको मोल तिर्नु पर्दैन। यी पशुहरू पवित्र हुन र यिनीहरूको रगत वेदीमा छर्किईन्छ अथवा बोसो पोलिन्छ। यो उपहार आगोमा पोलेर दिइन्छ र यसको सुगन्धले परमप्रभुलाई सन्तुष्ट पार्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","तर यी पशुहरूको मासु भने तिम्रो हुनेछ अनि डोलाइने बलिको ह्याकुलो तिम्रो हुनेछ र अरू बलिको दाहिने साँप्रा पनि तिम्रो हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","मानिसहरूले चढाएको कुनै पनि पवित्र उपहारहरू म, परमप्रभुले तिमीलाई दिनेछु। म तिम्रो छोरा-छोरीहरू र तिमीलाई दिनेछु र यो नियम सदासर्वदाको निम्ति लागू हुनेछ। यो परमप्रभुसित गरिएको करार हो र भङ्ग गर्न सकिंदैन। म यो प्रतिज्ञा तिमी र तिम्रा सन्तानहरूसित गर्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","परमप्रभुले हारूनलाई पनि भन्नुभयो, “तिमीले भूमि पाउनेछैनौं। अनि अरू मानिसहरूले झैं तिमीले त्यहाँ केही आफ्नो बनाउनु पाउने छैनौ। म परमप्रभु नै तिम्रो हुनेछु। प्रतिज्ञा गरिएको अनुसार इस्राएली मानिसहरूले जग्गाजमीनहरू पाउनेछन् तर तिम्रो निम्ति म नै उपहार हुँ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“इस्राएलका मानिसहरूले तिनीहरूसित भएको प्रत्येक चीजको दशांश मलाई दिन्छन्। यसकारण त्यो एक दशांश भाग म लेवीका सन्तानहरूलाई दिन्छु। यो तिनीहरूले भेट हुने पालमा छँदा त्यहाँ काम गरे बापत पारिश्रमिक हो। ");
INSERT INTO npi2010_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","तर अन्य मानिसहरू भेट हुने पालको नजीक जानु हुँदैन। यदि गए तिनीहरू मारिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","लेवी मानिसहरू काम गरिरहेको समयमा भेट हुने पालको विरोधमा कुनै पाप कार्य हुन गए त्यस पापको उत्तरदायी तिनीहरू हुनेछन्। यही नियम सदासर्वदाको निम्ति लागू रहनेछ। मैले अरू मानिसहरूलाई दिन्छु भनी प्रतिज्ञा गरेको भूमि लेवी मानिसहरूले पाउने छैनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","तर तिनीहरू संग भएको प्रत्येक चीजको दशांश इस्राएली मानिसहरूले मलाई चढाउनेछन् र त्यो दशांश म लेवी मानिसहरूलाई दिनेछु। त्यही कारणले लेवी मानिसहरूको विषयमा मैले यस्तो भनेः मैले इस्राएलका मानिसहरूलाई दिन्छु भनी प्रतिज्ञा गरेको भूमि तिनीहरूले पाउने छैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लेवी मानिसहरूसित कुरा गर अनि भन, इस्राएलका मानिसहरूले तिनीहरूसित भएको प्रत्येक चीजको दशांश मलाई दिनेछन् तर त्यसबाट दशांश उपहार स्वरूप परमप्रभुलाई चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","अनि यो दशांश परमप्रभुको उपहार हो, यो तिमीहरूले कोल अथवा खलाबाट चढाएका बलि झैं हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","यस्तै प्रकारले इस्राएली मानिसहरूले तिमीहरूलाई दशांश दिए जस्तै तिमीहरूले पनि परमप्रभुलाई उपहार चढाउनु पर्छ अनि त्यसबाट तिमीहरूले पनि परमप्रभुलाई उपहार दिनु पर्छ अनि यो हारूनलाई दिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","जब इस्राएलका मानिसहरूले तिनीहरूको उपहारहरू परमप्रभुलाई दिन्छन्, तिमीहरूले तिमीहरूमा सबै भन्दा असल अनि महापवित्र परमप्रभुलाई चढाउनु पर्छ कारण त्यो सबै उहाँको हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“मोशा, लेवी मानिसहरूलाई भन जब तिमीहरूले प्रत्येक असल चीज परमप्रभुलाई चढाउँछौ जे इस्राएली मानिसहरूले दिएका थिए, तब यो सम्झिन्छ कि लेवीहरूको आफ्नै अन्न र अर्धबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","त्यसबाट रहेको अंश तिमीहरू र तिमीहरूका परिवारले खानेछन्। यो तिमीहरूले भेट हुने पालमा काम गरे वापत मूल्य हो। ");
INSERT INTO npi2010_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","अनि यदि तिमीहरूले यसको असल सँधै परमप्रभुलाई चढायौ भने तिमीहरू कदापि दोषी हुने छैनौ। तिम्रो आफ्नै निम्ति इस्राएलका मानिसहरू द्वारा चढाएका ती पवित्र उपहारहरूको भाग नलैजाऊ नत्र भने तिमीहरू मर्ने छौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","परमप्रभुले मोशा र हारूनलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“परमप्रभुले दिनु भएको आज्ञाहरूबाट बनिएको नियम यही हो। इस्राएलका मानिसहरूलाई भन कि तिनीहरूले एउटा एकदमै निष्खोट र कहीं दाग नभएको कहिले पनि नजोतिएको रातो गाई ल्याऊन। अनि त्यो गाईले कहिल्यै हलो नजोतेको हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","तिमीहरूले त्यो गाई एलाजारलाई दिनुपर्छ र उसले त्यस गाईलाई छाउनी बाहिर ल्याउँछ। यो उसको अघि मारिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","त्यसपछि एलाजारले उसको औंलाले केही रगत भेट हुने पालको अघिल्तिर सात पल्ट छर्कनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","तब उसको सामुन्ने त्यो गाई जलाउनु पर्छ। यसको छाला, मासु, रगत आन्द्रा-भुँडी सबै जलाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","पूजाहारीले देवदारू काठ, हिसप र केही रातो धागो ल्याएर गाई जल्दै गरेको आगोमा फ्याँक्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","त्यसपछि पूजाहारीले आफ्नो लाउने लुगा धोएर नुहाई धुवाई गरी छाउनीमा जानुपर्छ। तर त्यो पूजाहारी साँझसम्म अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","त्यो गाई पोल्नेले पनि आफ्नो लुगाहरू धोएर नुहाउनु पर्छ, अनि त्यो पनि साँझसम्म अशुद्ध भईरहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“केही शुद्ध मानिसले जलाएको कोरेलीको खरानी बटुलेर छाउनी देखि बाहिर विधिपूर्वक शुद्ध पारिएको ठाँउमा राख्नु पर्छ। खरानी इस्राएलका मानिसहरूलाई सफा गर्नका निम्ति पानीसित राखेका थियो। यो पापबलि हो। ");
INSERT INTO npi2010_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“त्यो खरानी बटुल्ने व्यक्तिले पनि आफ्नो लुगा-फाटा धोएर साँझ सम्म अशुद्ध रहोस्। “इस्राएलका मानिसहरू तथा तिनीहरूको माझमा बस्ने कुनै पनि विदेशीको निम्ति यो अन्तको नियम हो। ");
INSERT INTO npi2010_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","एकजना व्यक्ति जसले मुर्दा छुन्छ त्यो सात दिन सम्म अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","तेस्रो दिनमा त्यो व्यक्तिले आफैंलाई त्यही पानीले शुद्ध पार्ने छ र सातौं दिनमा उ शुद्ध हुनेछ। तर यदि व्यक्तिहरू तिनीहरू आफैं तेस्रो दिनमा शुद्ध भएन भने, तब सातौं दिनमा पनि शुद्ध हुनेछैन। ");
INSERT INTO npi2010_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","यदि कुनै व्यक्तिले मुर्दा छुन्छ र आफैलाई फेरि शुद्ध पार्दैन, त्यसले परमप्रभुको पवित्र पाललाई अशुद्ध पार्छ। यसकारण व्यक्ति इस्राएलबाट काटिदिनेछ। जस्तो पवित्र पानी तिनीहरू माथि छर्केको थिएन यसकारण उसको शरीर अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“यदि कुनै मानिस पाल भित्र मरे भने त्यसको नियम यो हो प्रत्येक जो पाल भित्र बस्ने प्रवेश गर्ने र त्यहाँ प्रत्येक नै अशुद्ध हुनेछ र तिनीहरू सात दिन सम्म अशुद्ध रहन्छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","अनि ढकनी बिनाको प्रत्येक भाँडा अथवा बयम अशुद्ध हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","यदि कसैले खुल्ला मैदानमाथि लडीरहेको मृत शरीरलाई छुन्छ वा लडाँईमा मारिएको कुनै मुर्दा छुन्छ वा मनुष्यको हड्डी चिहानलाई छुन्छ भने, उनी सात दिनसम्म अशुद्ध रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“त्यो अशुद्ध मानिसको निम्ति जलाइएको गाईको खरानी एउटा भाँडामा हाल र त्यसमा बग्दै गरेको पानी यसमा हाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","कुनै शुद्ध मानिसले त्यस पानीमा हिसप चोपेर भाँडाहरू र मानिसहरू माथि छर्किनु पर्छ। अनि कसैले हड्डी अथवा चिहान अथवा एउटा मृत शरीर अथवा एउटा युद्धमा मरेको शरीरलाई छोएर अशुद्ध बनाउँछ। भने, त्यो पानी ऊ माथि छर्कनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“त्यस शुद्ध मानिसले अशुद्ध भएको मानिसमाथि तेस्रो र सातौं दिन छर्किनु पर्छ। यस प्रकार उसले अशुद्ध मानिसहरूलाई सातौं दिनमा शुद्ध बनाउँछ। त्यो अशुद्ध मानिसले लुगा धोओस अनि पानीमा नुहाओस् र साँझ सम्म अशुद्ध रहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“यदि एक जना मानिस जो अशुद्ध भएकहाँ अनि ऊ आफैं शुद्ध हुँदैन भने त्यस व्यक्तिलाई आफ्नो समुदायबाट बहिष्कार गरियोस् किनभने त्यसले परमप्रभुको पवित्र स्थान अशुद्ध पार्यो। शुद्धीकरणको पानी ऊ माथि छर्किएन यसकारण त्यो व्यक्ति अशुद्ध रह्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","तिनीहरूको निम्ति यो नियम अनन्त रूपले लागु भइरहन्छ। जो व्यक्तिले शुद्धीकारणको पानी छर्किन्छ उसले आफ्नो लुगा-फाटा धुनु पर्छ अनि जुन व्यक्तिले शुद्धीकारणको पानी छुन्छ त्यो व्यक्ति साँझ सम्म अशुद्ध भइरहन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","प्रत्येक कुरा त्यो व्यक्तिले छोए अशुद्ध रहन्छ अनि कुनै व्यक्ति जसले त्यसलाई छुन्छ त्यो साँझ सम्म अशुद्ध रहन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","पहिलो महीनामा इस्राएलका मानिसहरू जीन मरूभूमिमा आइपुगे। मानिसहरू कादेशमा बसे अनि त्यही मरियम मरिन् र त्यही ठाउँमा गाडे। ");
INSERT INTO npi2010_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","त्यस ठाँउमा समुदायको निम्ति पानी थिएन यसकारण मानिसहरू मोशा र हारूनलाई आरोप लगाउन भेला भए। ");
INSERT INTO npi2010_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","मानिसहरूले मोशासित झगडा गरेर भने, “जब परमप्रभुको अगाडी हाम्रा दाज्यू-भाईहरू मरे, त्यही समय हामी पनि मर्नु पर्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","तिमीहरूले किन परमप्रभुको मानिसहरूलाई यस मरूभूमिमा ल्यायौ? के हामी र हाम्रो पशुहरूलाई मार्न चहान्छौ? ");
INSERT INTO npi2010_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","अनि किन यस्तो खराब ठाँउमा ल्याउन हामीलाई मिश्र देशदेखि अगुवाई गर्यो? यस ठाँउमा अन्न हुँदैन, नेभारा, दाख अनि अनारहरू पनि हुँदैन। अनि यहाँ पिउनको निम्ति पानी पनि छैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","यसर्थ मोशा र हारून मानिसहरूको समुदायबाट भेट हुने पालको प्रवेशद्वारमा गए। तिनीहरूले तिनीहरूको शिर भूँईमा निहुरयाए अनि परमप्रभुको महिमा तिनीहरू सामुन्ने देखा पर्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“तिमी र तिम्रा दाज्यू हारूनले त्यो लौरो लेऊ र मानिसहरूलाई भेला गर अनि तिनीहरूको सामुन्नेको चट्टानसित बोल। तब चट्टानले तिमीहरूलाई पानी दिनेछ। यसरी मानिसहरू र तिनीहरूको पशुहरूको निम्ति तिमीहरूले चट्टानबाट पानी दिन सक्छौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","यसकारण परमप्रभुले उसलाई आज्ञा दिनु भए बमोजिम मोशाले परमप्रभुको अघिबाट लौरो लिए। ");
INSERT INTO npi2010_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","त्यसपछि मोशा र हारूनले मानिसहरूलाई चट्टानको सामुन्ने भेला गराए। तब मोशाले तिनीहरूलाई भने, “तिमीहरू विद्रोही हो। सुन, के हामीले तिमीहरूको निम्ति यो चट्टानबाट पानी ल्याउनु?” ");
INSERT INTO npi2010_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","तब मोशाले हात उठाएर त्यस चट्टान माथि दुइ पल्ट आफ्नौ लौरोले हिर्काए अनि प्रशस्त पानी बाहिर निस्कयो। मानिसहरू र पशुहरूले पानी पिए। ");
INSERT INTO npi2010_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","त्यसपछि परमप्रभुले मोशा र हारूनलाई भन्नुभयो, “इस्राएलका सबै मानिसहरू यहाँ भेला भएका थिए तर तिमीहरूले म प्रति सम्मान देखाएनौ। तिमीहरूले इस्राएलका मानिसहरूलाई त्यो पानी निक्लने शक्तिको श्रोत म हुँ भन्ने देखाएनौ। तिमीहरूले उनीहरूलाई यो देखाएनौ की तिमीहरूले म माथि भरोसा गर्यौ। यसकारण यी समुदायलाई मैले दिन्छु भनेको भूमिमा लैजान अगुवाई गर्न पाउने छैनौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","यही ठाँउलाई मरीबाको पानी भनिन्छ जहाँ इस्राएलका मानिसहरूले परमप्रभु अघि विद्रोह गरेका थिए अनि परमप्रभुले यहाँ नै इस्राएली मानिसहरूको बीचमा आफू पवित्र हुँ भन्ने देखाउनु भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशाले कादेशबाट एदोमको राजाकहाँ यो समाचार पुर्याउन दूतहरू पठाए। तपाईंको भाई इस्राएलले यसो भन्छ, “हामीमाथि आई परेका आफ्दहरू तपाईंलाई थाहा छ। ");
INSERT INTO npi2010_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","धेरै वर्ष अघि हाम्रा पुर्खाहरू मिश्र देश गएका थिए अनि हामी त्यहाँ धेरै समय सम्म बस्यौं। मिश्र देशका मानिसहरू हामी प्रति निष्ठुर थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","तर हामीले परमप्रभुलाई सहायता माग्यौं। परमप्रभुले हाम्रो बिन्ति सुन्नु भयो र एउटा स्वर्गदूत हामीकहाँ पठाउनु भयो, परमप्रभुले हामीलाई मिश्र देशबाट बाहिर ल्याउनु भएको छ। “अहिले हामी तपाईंको सिमान कादेशमा छौं। ");
INSERT INTO npi2010_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","दया गरी हामीलाई तपाईंको भूमि भएर यात्रा गर्न दिनुहोस्। हामी खेत तथा दाखबारी भएर जानेछैनौं, त्यस ठाँउको कुवाहरूबाट पानी पिउँने छैनौं, हामी केवल राजमार्गमा हिड्नेछौं, कतै दायाँ बाया जाने छैनौं। जब सम्म तपाईंको देशमा यात्रा गर्छौ हामी बाटोमा नै रहनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","तर एदोमका राजाले उत्तर दिए, “हाम्रो देश भएर तिमीहरू यात्रा गर्न पाउँदैनौ। यदि हिड्ने चेष्टा गरे हामी तरबार लिएर तिमीहरूसित लडन आउनेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएलीहरूले उत्तर दिए, “हामी खाली मूलबाटै भएर मात्र जानेछौं। अनि यदि हाम्रा पशुहरूले कुनै पानी पिए त्यसको मोल तिर्नेछौ। हामी खाली तपाईंको देशको बाटोमा हिड्न चाहान्छौं, हाम्रो निम्ति अरू केही चाहिंदैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","तर फेरि एदोमले उत्तर दिए, “हाम्रो देशमा तिमीहरूलाई आउन दिंदैनौं।” तब एदोमले शक्तिशाली धेरै सेनाहरू भेला पारेर इस्राएलका मानिसहरूसित युद्ध गर्न निस्के। ");
INSERT INTO npi2010_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","एदोमले इस्राएलका मानिसहरूलाई आफ्नो भूमिको बाटोबाट यात्रा गर्न दिएनन् तिनीहरू अर्कै बाटो भएर गए। ");
INSERT INTO npi2010_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","इस्राएलका सबै मानिसहरूले कादेशबाट होर पर्वत सम्म यात्रा गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","होर पर्वत एदोमको सिमाना नजिक थियो। परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“अब हारून उसको पुर्खाहरूसित मिल्नेछ। तिमी र हारूनले मरीबाको पानीमा मैले दिएको आज्ञा पालन नगरेकोले मैले इस्राएलका मानिसहरूलाई दिन्छु भनेको भूमिमा तिमीहरू पस्न पाउने छैनौ। ");
INSERT INTO npi2010_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“अब हारून र तिनका छोरो एलाजारलाई होर पर्वतमा लिएर आऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","हारूनको लुगा खोलेर उसको छोरो एलाजारलाई लगाई देऊ। हारून त्यहाँ पर्वतमा मर्छ र आफ्नो पिता-पुर्खाहरूसित मिल्न जान्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","मोशाले परमप्रभुको आज्ञा पालन गरे। मोशा, हारून र एलाजार होर पर्वतमा गए। सबै इस्राएली मानिसहरूले तिनीहरू गएको देखे। ");
INSERT INTO npi2010_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मोशाले हारूनको खास लुगाहरू फुकाइदिएर एलाजारलाई लगाई दिए। त्यसपछि हारून त्यहीं पर्वतमा मरे अनि मोशा र एलाजार पर्वतबाट तल झरे। ");
INSERT INTO npi2010_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","हारून मरेको इस्राएलका सबै मानिसहरूले चाल पाए अनि तीस दिनसम्म शोक पालन गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","आरादाका कनानी राजा नेगेवमा बस्थे। उनले इस्राएली मानिसहरू अटारीमको बाटो भएर आउँदैछन् भन्ने चाल पाए। यसर्थ तिनी गएर इस्राएली मानिसहरू माथि आक्रमण गरे। तिनले केही मानिसहरूलाई पक्राऊ गरेर कैद गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","तब इस्राएलका मानिसहरूले विशेष भाकल गरी परमप्रभुलाई पुकारेः “हे परमप्रभु, दया गरी हामीलाई यी मानिसहरूमाथि विजय गराई दिनुहोस् र हामी तिनीहरूको शहरहरू नष्ट पारी दिनेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","परमप्रभुले इस्राएलीहरूको पुकार मान्नु भयो र कनानीहरूलाई जित्न तिनीहरूलाई सहायता गर्नु भयो। इस्राएलीहरूले तिनीहरू र तिनीहरूका शहर सम्पूर्ण ध्वंश पारे। यसर्थ त्यस ठाँउको नाम होर्मा राखियो। ");
INSERT INTO npi2010_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","इस्राएली मानिसहरू होर पर्वत छोडेर लाल समुद्र जाने बाटोमा हिड्न लागे। तिनीहरूले एदोम देश वरिपरि जानलाई त्यो बाटो गए। तर मानिसहरू धैर्यहीन भईसकेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","मानिसहरूले परमेश्वर र मोशाको विरोधमा कुरा गरे। तिनीहरूले भने, “यो मरूभूमिमा मर्नुको निम्ति किन हामीलाई मिश्र देशबाट ल्याइयो? कारण यहाँ न त पानी छ न रोटी। तुच्छ खाना अथवा रोटी खाँदा खाँदा वाक्क भई सक्यो।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","यसर्थ परमप्रभुले मानिसहरूको माझमा विषालु सर्पहरू पठाईदिनुभयो र तिनीहरूले धेरै मानिसहरूलाई डसेर मार्यो। यसरी इस्राएलका धेरै मानिसहरू मरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","मानिसहरू आएर मोशासंग भने, “हामी जान्दछौं परमप्रभु र तपाईंको विरोधमा बोलेर हामीले पाप गर्यौं। परमप्रभुसित प्रार्थना गरेर यी सर्पहरू फर्काउन लगाईदिनु होस्।” यसकारण मोशाले मानिसहरूको निम्ति प्रार्थना गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","परमप्रभुले मोशालाई भन्नुभयो, “काँसाको एउटा सर्प बनाऊ र खम्बा माथि राख। सर्पबाट डसिएको कुनै व्यक्तिले त्यो खम्बामाथि राखिएको काँसाको सर्पलाई हेर्छ त्यो मर्ने छैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","यसकारण मोशाले परमप्रभुको आज्ञा मानी एउटा काँसाको सर्प बनाई खम्बामाथि राखे। त्यसपछि जब कुनै व्यक्तिलाई सर्पले टोके उसले त्यो खम्बा माथि राखिएको काँसाको सर्पलाई हेर्थ्यो र त्यो बाँच्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इस्राएली मानिसहरूले त्यो ठाँउ छोडे अनि ओबोतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","त्यसपछि तिनीहरूले ओबोतबाट हिंडी मोआबको पूर्वमा रहेको मरूभूमि ऐ अबारीममा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","तिनीहरूले त्यो ठाँउ पनि छाडी जेरोद बेंसीमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","त्यहाँबाट पनि गई अर्नोन नदी पारीको मरूभूमिमा छाउनी हाले। यो नदी एमोरीहरूको सिमानाबाट शुरू हुन्थ्यो। त्यो बेंसीमा मोआब र एमोरीहरू बीचको सिमान थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","यसकारण परमप्रभुको युद्धको पुस्तकमा यी कुरा लेखिएका छन्। “अनि सूपामा वाहेब अनि अर्नोनको बेंसी ");
INSERT INTO npi2010_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","अनि बेंसीहरूको आरको भिरालोहरू वासस्थान पट्टि जो मोआबको सिमानामा अवस्थित छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","इस्राएलका मानिसहरू त्यस ठाँउ छाडेर बेओर तिर गए। यस ठाँउमा कूवा थियो र परमप्रभुले मोशालाई भन्नु भयो, “मानिसहरूलाई भेला गरेर ल्याऊ, म तिनीहरूलाई पानी दिनेछु।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","तब इस्राएलका मानिसहरूले यो गीत गाए। “हे कूवा, पानीसित बग्छ! यस विषयमा गीत गाओ! ");
INSERT INTO npi2010_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","महान व्यक्तिले यो कूवा खने। महान नायकहरूले यो कूवा खने। तिनीहरूले आफ्नो भारदारहरूसँग हिंड्ने लहुरोहरूले यो कूवा खने। यो मरूभूमिमा एउटा उपहार रहेको छ।” यसर्थ मानिसहरूले त्यो कुवाको नाम “मत्ताना” राखे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मानिसहरू मत्तानाबाट नहलीएल गए। त्यसपछि तिनीहरू नहलीएलबाट बामोत गए। ");
INSERT INTO npi2010_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","बामोतबाट मानिसहरू फेरि मोआब बेंसी गए। यस ठाँउमा पिसगा पर्वतको टुप्पो मरूभूमि माथि देखिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इस्राएलले आफ्नो केही मानिसहरू एमोरीहरूका राजा सीहोन कहाँ पठाए। ती मानिसहरूले राजालाई भने, ");
INSERT INTO npi2010_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“हामीहरूलाई तपाईंहरूको देश भएर जान दिनुहोस्। हामी तपाईंको दाखबारीहरू तथा खेतमा पस्ने छैनौ, तपाईंको पोखटीबाट पानी पिउने छैनौं। जब सम्म हामी तपाईंको देशको सिमानामा पुग्दैनौं हामी मूल बाटोमा रहने छौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","तर सीहोनले इस्राएललाई तिनको राज्यको सिमाना भित्रबाट हिड्नु दिएनन् अनि आफ्ना मानिसहरूलाई भेला पारेर इस्राएललाई मरूभूमिमा आक्रमण गर्न आए। तिनी यहससम्म आए अनि इस्राएलीहरूसित लडाँई गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","तर इस्राएलीहरूले तिनलाई तरवारको टुप्पोले घोचेर मारे अनि तिनको भूमि अर्नोन नदीदेखि यब्बोक नदी सम्म कब्जा गरे। तिनीहरूले अम्मोनीहरूको सिमानासम्म मात्र लिएर रोकिए कारण अम्मोनीहरूले आफ्नो सिमाना बलियो गरी सुरक्षा गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","यसकारण इस्राएलले एमोरीहरूको सबै शहरहरू कब्जामा लिएर त्यहीं बस्न शुरू गरे। तिनीहरूले हेशबोन र त्यसको वरिपरिको साना साना शहरहरू पनि आफ्नो अधीनमा लिए। ");
INSERT INTO npi2010_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेशबोन त्यो शहर हो जहाँ अम्मोरीहरूका राजा सीहोन बस्थे। सीहोनले मोओबका राजासित युद्ध गरी तिनको भूमि अर्नोन नदीसम्म कब्जामा लिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","यसैकारण गाइनेहरूले यो गीत गाँउछन्। “तिमीहरू हेशबोन शहरमा आऊ, यो पुर्नस्थापित होस्। सीहोन शहर फेरि बनियोस्। ");
INSERT INTO npi2010_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","किनभने हेशबोन शहरबाट आगो शुरू भयो र एउटा ज्वाला सीहोन शहरबाट शुरू भयो। यसले अर र मोआबलाई ध्वंश पार्यो। यसले अर्नोन माथिका उच्च पर्वतहरू जलायो। ");
INSERT INTO npi2010_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ए मोआब! तँलाई धिक्कार छ। ए कमोशका प्रजाहरू हो तिमीहरू नष्ट भयौ। यसले आफ्नो छोराहरूलाई भगौटे बनाए, छोरीहरूलाई कैद गराए र एमोरीहरूका राजा सीहोनलाई दिएको छ। ");
INSERT INTO npi2010_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","तर हामीले ती एमोरीहरूलाई जितेका छौं। हेशबोन देखि दीबोनसम्मै, ध्वंश भयो, र हामीले मेदेबाको नजीक नोपा सम्म, तिनीहरूको शहरहरू नष्ट पारेका छौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","यसकारण इस्राएलीहरूले एमोरीहरूको भूमि दखल गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मोशाले याजेरको शहरमा खूपियाहरू पठाए। मोशाले यसो गरे पछि इस्राएलीहरूले त्यसका वरिपरिका शहरहरू अधीनमा ल्याए अनि एमोरीहरूलाई लखेटे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","त्यसपछि इस्राएलीहरू बाशानतिर जाने बाटो लागे। बाशानका राजा ओग आफ्नो सेनाहरू लिएर इस्राएलीहरूलाई भेटन अघि बढे अनि एद्रईमा तिनीहरूसित युद्ध गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","तर परमप्रभुले मोशालाई भन्नुभयो, “त्यो राजासित नडराऊ, म तिमीलाई जिताउनेछु। हेशबोनमा बस्ने एमोरीहरूका राजा सीहोनलाई जुन व्यवहार गरेका थियौ ओगसित पनि त्यही गर। उसको सबै सेनाहरू र भूमि अधीनमा पार।” ");
INSERT INTO npi2010_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","यसर्थ इस्राएलीहरूले राजा ओग र उसको सेनाहरूलाई परास्त पारे अनि तिनीहरूले उसको छोराहरू, सेनाहरू तथा उसलाई पनि मारेर उसको भूमि अधीनमा लिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","त्यसपछि इस्राएलीहरूले मोआबको यर्दन मैदानहरूमा यात्रा गरे। यरीहो पारी पट्टि यर्दन नदी नजिकै तिनीहरूले पाल हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","एमोरीहरूलाई इस्राएलीहरूले गरेको व्यवहार सिप्पोरको छोरो बालाकले देखे। ");
INSERT INTO npi2010_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","इस्राएलीहरू धेरै संख्यामा भएकोले मोआब डराएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआबले मिद्यानीका बूढा-प्राधानहरूसित कुरा गरे, “हरियो मैदानमा गोरूले घाँस खाएर नष्ट पारे झैं यी धेरै संख्यामा आएका मानिसहरूले हाम्रा वरिपरि भएको प्रत्येक चीज नष्ट पार्नेछन्।” सिप्पोरको छोरो बालाक त्यस समय मोआबका राजा थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","बालाकले बओरको छोरा बिलामलाई निमन्त्रण गर्न दूतहरू पठाए जो युफ्रेटिस् नदिको नजीकै पातोरमा थिए। तिनीहरूले भने मिश्रबाट एउटा जाति आएका छन् अनि तिनीहरूको छाउनीहरूले सम्पूर्ण भूमि ढाकेको छ। “अहिले तिनीहरूले मेरो विपरीतमा छाउनी बसाएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","यसकारण अब आएर मेरो पक्षमा तिनीहरूलाई सराप्नु होस्, कारण तिनीहरू म भन्दा बलिया छन्। यदि तपाईंले त्यसो गर्नु भए शायद म तिनीहरूलाई परास्त पार्न सक्छु किनभने, मलाई थाहा छ, जसलाई तपाईं आशीर्वाद दिनु हुन्छ, उसलाई आशीर्वाद लाग्छ, र जसलाई तपाईंले सराप्नु हुन्छ उसलाई श्राप लाग्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मोआब र मिद्यानका बूढा-पाकाहरू बिलामसंग कुरा गर्न भनी बाटो लागे। तिनीहरूले भविष्यवाणीको निम्ति आफूसित केही पैसा पनि लिएर गए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","तिनीहरू बिलामकहाँ आएर बालाकले भनेको कुरा सुनाए। त्यसपछि बिलामले तिनीहरूलाई भने, “तिमीहरू आज राती यहीं बस अनि म तिमीहरूलाई परमप्रभुले मलाई जे भन्नुहुन्छ सो बताउँछु।” यसर्थ मोआबले पठाएका मानिसहरू बिलामसित बसे। ");
INSERT INTO npi2010_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","सपनामा परमेश्वरले बिलामलाई दर्शन दिनु भयो र भन्नुभयो, “तिमीसित भएका यी मानिसहरू को हुन्?” ");
INSERT INTO npi2010_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बिलामले परमेश्वरलाई उत्तर दिए, “मोआबका राजा सिप्पोरका छोरा बालाकले मकहाँ दूतहरू पठाएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","उनको सन्देश थियो: हेर्नुहोस् यो जाति मिश्रदेशबाट भएको छ र तिनीहरूको छाउनीले देशलाई ढाकी रहेकोछ। अब आउनु होस् र मेरो पक्षमा तिनीहरूलाई सराप्नु होस। यदि तपाईंले त्यसो गारिदिनु भयो भने सायद म तिनीहरूलाई लँडाईमा जितेर धपाउन सक्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","परमेश्वरले बिलामलाई भन्नुभयो, “तिमी तिनीहरूसित नजाऊ, अनि मानिसहरूलाई नसराप किनभने तिनीहरू म द्वारा अशिषित छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","त्यसकारण बिहानै उठेर बालाकद्वारा पठाएका बुढा-पाकाहरूलाई बिलामले भने, “तपाईंहरूको देशमा फर्केर जानुहोस् परमप्रभुले मलाई तिमीहरूसित जानु अनुमति दिनु भएन।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","यसर्थ मोआबका बूढा-पाकाहरू उठेर बालाककहाँ गएर भने, “बिलामले हामीसित आउनु अस्वीकार गरे।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","एक पल्ट फेरि बालाकले बिलामकहाँ मानिसहरू पठाए। दोस्रो चोटीका बुढा-पाकाहरू पहिलेको भन्दा धेरै ठूला र सम्मानित थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","तिनीहरू गएर बिलामलाई भने, “सिप्पोरको छोरो बालाकको भनाई यस्तो छ: दयागरी तपाईं म भए कहाँ आउन तपाईंले आफैंलाई नरोक्नु होस्। ");
INSERT INTO npi2010_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","किनभने म तपाईंलाई बडो इज्जत साथ सम्मान चढाउनेछु साथै तपाईंले जे भन्नुहुन्छ म मान्नेछु। दया गरी आउनुहोस् र मेरो पक्षमा तिनीहरूलाई सराप्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","तब बिलामले बालाकका मानिसहरूलाई जवाफ दिए, “यदि बालाकले मलाई सुन र चाँदीले भरिएको महल दिए पनि म मेरो परमप्रभु परमेश्वरको आज्ञाचाहे ठूलो वा सानो होस् नष्ट गर्दिनँ। ");
INSERT INTO npi2010_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","यसकारण अरूहरू झैं तिमीहरू पनि आज राती यहि बस्। अनि म हेर्छु परमप्रभुले मलाई केही कुरा भन्नु हुन्छ कि।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","त्यो राती बिलामलाई सपनामा आएर परमेश्वरले भन्नुभयो, “जब यी मानिसहरू तिमीलाई उनीहरूसित लैजान आएका छन्, तिमी उठेर तिनीहरूसित जाऊ, तर म जे भन्छु त्यो मात्र तिमीले गर्नुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","यसकारण बिलामले बिहानै उठेर जीन लगाम कसे। त्यसपछि तिनी ती मोआबबाट आएका बूढा-प्रधानहरू संग गए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","बिलाम गएको देखी परमेश्वर रिसाउनु भयो र उसलाई रोक्न परमप्रभुका स्वर्गदूत बाटोमा उभिए। बिलाम गधामा चढेका थिए अनि तिनका दुईजना सेवकहरू पनि तिनीसित थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","जब गधाले परमप्रभुको स्वर्गदूतलाई हातमा तरवार लिएर बाटोमा उभिरहेको देख्यो त्यसले बाटो छाडेर खेततिर गयो। यसर्थ बिलामले त्यस गधालाई बाटोमा फर्काई ल्याउन हिर्कायो। ");
INSERT INTO npi2010_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","त्यसपछि परमप्रभुका स्वर्गदूत दुवै पट्टि ढुङ्गाको पर्खाल भएको दुइवटा दाखको खेत बीच साँघुरो बाटोमा उभिए, ");
INSERT INTO npi2010_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","जब गधाले परमप्रभुको स्वर्गदूतलाई देख्यो त्यो भित्तमा टाँसियो अनि बिलामको खुट्टा पनि चेप्टाइदियो। यसर्थ बिलामले फेरि त्यसलाई हिर्काए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","त्यसपछि परमप्रभुको स्वर्गदूत अघि बढेर एउटा एकदमै साघुँरो गल्ली जहाँ पसेर दाहिने-देब्रे फर्कन नसकिने ठाँउमा उभिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","परमप्रभुको स्वर्गदूतलाई देखेर गधा थचक्क बस्यो। बिलाम रिसले चुर भएर त्यसलाई आफ्नो लौरोले बेस्सरी हिर्काए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","त्यसपछि परमप्रभुले गधालाई मुख खोल्ने अनुमति दिनुभयो र त्यसले बिलामलाई भन्यो, “मैले तपाईंलाई के गरें ताकि तपाईंले मलाई यस प्रकारले तीन चोटि हिर्काउनु भयो?” ");
INSERT INTO npi2010_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","तब बिलामले गधालाई भने, “तैंले मलाई मूर्ख बनाइस्। यदि मेरो हातमा तरवार हुँदो हो त म तपाईं अहिले मार्ने थिएँ।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गधाले बिलामलाई उत्तर दियो, “के म तपाईंले आफ्नो जीवन भरि आज सम्म चढेको गधा होइन्? के मैले यस्तो अघि कहिले गरेको थिएँ?” बिलामले भने, “होइन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","त्यसपछि परमप्रभुले बिलामको आँखा खोली दिनुभयो अनि तिनले परमप्रभुको स्वर्गदूतलाई नाङ्गो तरवार लिएर बाटोमा उभिरहेको देखे। तब तिनले आफ्नो शिर निहुर्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","तब परमप्रभुको स्वर्गदूतले बिलामलाई भने, “किन तिमीले गधालाई तीन पल्ट हिर्कायौ हेर, म तिमीलाई रोक्नको निम्ति बाहिर आए किनभने तिम्रो यात्रा मेरो आज्ञाको विरूद्धमा छ। ");
INSERT INTO npi2010_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","जब गधाले मलाई देख्यो, त्यो तीन पल्ट मबाट तर्कन खोज्यो। यदि यो मबाट नतर्केको भए यो निश्चय थियो कि म तिमीलाई मार्ने थिएँ, तर गधालाई जिउँदै छाडि दिने थिएँ।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","तब बिलामले परमप्रभुका स्वर्गदूतलाई भने, “मैले पाप गरें कारण मैले जानिन कि तपाईं मलाई रोक्नको निम्ति बाटोमा उभिरहनु भएको थियो। तर यदि मेरो यात्रालाई केही नराम्रो ठान्नु हुन्छ भने म घर फर्कन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","तब परमप्रभुको स्वर्गदूतले बिलामलाई भने, “तिमी यी मानिसहरूसित जाऊ, तर म जे भन्छु तिमी त्यो मात्र बोल। यसकारण बिलाम मोआबबाट आएका बूढा-प्रधानहरूसंग गए।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","जब बालाकले बिलाम आउँदैछ भनेको सुने, ऊ मोआबी देशको शहरको उत्तरी सिमाना अर्नोन नदीको नजिक उसलाई भेट्न गए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाकले बिलामलाई भने, “तपाईं मेरोमा आउनुहोस् भनी निम्तो दिन मैले मानिसहरू पठाएँ? तपाईं किन म भएकहाँ आउनु भएन? के म तपाईंलाई सम्मान गर्न योग्यको छैन?” ");
INSERT INTO npi2010_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","त्यसपछि बिलामले बालाकलाई भने, “हेर। म तिम्रोमा अहिले आएकोछु। म तिमीलाई अहिले नै केही कुरा भन्न सक्छु? म त्यही कुरा मात्र भन्ने छु जो परमप्रभु परमेश्वरले मलाई भन्न लगाउनु हुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","त्यसपछि बिलाम बालाकसित गए। अनि तिनीहरू किर्यत-हुसोतमा आए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","बालाकले गोरूहरू र भेडाहरू बलि चढाए अनि बिलाम र मोआबबाट आएका बूढा-प्राधानहरूलाई निमन्त्रणा गरे र खान दिए जो ऊसित आएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","भोलिपल्ट बिहानै बालाकले बिलामलाई बमोत- बालमा लिएर गए। त्यहाँबाट तिनले इस्राएली मानिसहरूको केही भाग देखे। ");
INSERT INTO npi2010_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बिलामले भने, “यहाँ सातवटा वेदी बनाऊ। अनि सातवटा साँढे र सातवटा भेडा मेरो निम्ति तयार पार।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालाकले बिलामको इच्छा पुरा गरिदियो। ती दुइजनाले एक-एकवटा साँढे र भेडा प्रत्येक वेदिमा बलि चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","त्यसपछि बिलामले बालाकलाई भने, “तिम्रो होमबलिको पछिल्तिर तिमी उभिनु अनि म कही जान्छु। शायद परमप्रभुले मलाई भेट्नु हुन्छ होला। उहाँले मलाई जे देखाउनु हुन्छ म तिमीलाई भन्नेछु।” यसर्थ तिनी एउटा पर्वतको शिखरमा गए। ");
INSERT INTO npi2010_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","परमेश्वर बिलामलाई भेट्न आउनुभयो अनि उनले परमेश्वरलाई भने, “मैले सातवटा वेदी बनाएकोछु र एउटा साँढे र एउटा भेडा बलिको निम्ति प्रत्येक वेदीमा चढाइएको छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","तब परमप्रभुले बिलामलाई उसले के भन्नु पर्ने बताउनु भयो, “बालाककहाँ फर्क र उसलाई यो भन।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","यसर्थ बिलाम बालाककहाँ फर्के। त्यहाँ बलाक आफूले चढाएको बलिको नजिकै अन्य मोआबका मुख्य व्यक्तिहरूसित उभिरहेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","तब बिलामले यी कुराहरू भनेः “बालाक, मोआबका राजाले मलाई यहाँबाट अरामको पूर्वोत्तर पर्वतहरूमा लगे। बालाकले मलाई भने, ‘आऊ मेरो निम्ति याकूबलाई शराप। आऊ इस्राएलका मानिसहरूको विरोधमा बोल।’ ");
INSERT INTO npi2010_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","कसरी म केही कुरालाई सराप्नु, जसलाई परमेश्वरले सरापेको छैन, कसरी म कसैको विरूद्धमा बोल्नु, जसलाई परमप्रभुले विरोध गर्नु भएको छैन्। ");
INSERT INTO npi2010_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","म पर्वतबाट ती मानिसहरूलाई देख्छु, म तिनीहरूतिर अग्लो पर्वतबाट हेर्छु, तिनीहरूले एकान्तमा बस्छन्, तिनीहरू आफैंलाई जातिहरू मध्येको एक जाति भनी सोच्दैनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकूबका मानिसहरूलाई कसले गन्न सक्छन्? तिनीहरूको संख्या धूलोको कण जत्तिकै असंख्य छ। तिनीहरूका चार भागको एक भाग पनि कसैले गन्न सक्तैन। मेरो आत्माले असल मृत्यु पाओस्, मेरो जीवन तिनीहरूको झैं खुशीयालीमा अन्त होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","त्यसपछि बालाकले बिलामलाई भने, “तपाईंले मलाई के गर्नु भयो? मैले तपाईंलाई मेरा शत्रुहरूलाई सराप्न ल्याए तर तपाईंले तिनीहरूलाई आशीर्वाद दिनुभयो।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","बिलामले उत्तर दिए, “म परमप्रभुले भन्नु भएको वचन मात्र बोल्नु होशियार रहनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","त्यसपछि बालाकले उसलाई भने, “तपाईं मसंग यता अर्को ठाँउमा आउनु, जहाँबाट ती मानिसहरूलाई अझ वेशी संख्यामा देख्न सक्नु हुन्छ। तपाईंले तिनीहरू सबैलाई देख्न सक्नुहुन्न खाली एक भाग मात्र देख्न सक्नुहुन्छ। त्यहाँबाट तपाईंले मेरो पक्षमा सराप्नु होस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","तब बालाकले बिलामलाई पिसगा पर्वतको चोटीमा भएको सोफीमको खेतमा लगे अनि त्यहाँ बालाकले सातवटा वेदी बनाई एउटा साँढे र एउटा भेडा प्रत्येक वेदीमा बलि दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","तब बिलामले बालाकलाई भने, “यो वेदी नजिक तिमी बस। म परमेश्वरलाई भेट्न त्यस ठाँउमा जान्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","यसर्थ बिलामलाई परमप्रभुले भेट्नु भयो अनि बिलामले के भन्नु पर्ने बताई दिनुभयो। परमप्रभुले भन्नुभयो, बालाककहाँ जाऊ अनि यसो भन। ");
INSERT INTO npi2010_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","यसकारण बिलाम बालाकभए कहाँ गए। बालाक होमबलि को छेऊमा उभिरहेको थियो उसले अन्य मोआबका बूढा-प्रधानहरूसित बलि चढाए बालाकले सोधे, “परमप्रभुले के भन्नुभयो?” ");
INSERT INTO npi2010_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","बिलामले आगमवाणी दिएः “उठ बालाक अनि म जे भन्छु सुन; सिप्पोरका छोरो, बालाक मेरो कुरा सुन, ");
INSERT INTO npi2010_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्वर मानिस हुनुहुन्न, यसर्थ उहाँ मर्नुहुन्न, परमेश्वर मानव हुनुहुन्न, यसर्थ उहाँको निर्णय परिवर्त्तन हुँदैन। यदि परमप्रभुले भन्नुहुन्छ-केही गर्छु, तब उहाँले गर्नुहुन्छ। यदि परमप्रभुले प्रतिज्ञा गर्नु भए, प्रतिज्ञाको कुरो पूर्ण गर्नुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","परमप्रभुले मलाई भन्नुभयो, ती मानिसहरूलाई आशीर्वाद देऊ, परमप्रभुले तिनीहरूलाई आशीर्वाद दिनु भएकोछ, यसर्थ म त्यो बद्लाउन सक्तिनँ। ");
INSERT INTO npi2010_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","परमेश्वरले याकूबका मानिसहरूमा कुनै त्रुटी पाउनु भएन, इस्राएलका मानिसहरूमा परमेश्वरले पाप देख्नु भएन। परमप्रभु तिनीहरूका परमेश्वर हुनुहुन्छ, अनि उहाँ तिनीहरूको साथ हुनुहुन्छ। ती महान् राजा तिनीहरूसित हुनुहुन्छ! ");
INSERT INTO npi2010_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्वरले ती मानिसहरूलाई मिश्रबाट बाहिर ल्याउनु भयो, तिनीहरू जंगली साँढे झै बलिया छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकूबका मानिसहरूलाई परास्त गर्ने अर्को कुनै शक्ति छैन। कुनै यस्तो उपाए छैन कि इस्राएलका मानिसहरूलाई रोक्न सकोस्। याकूब र इस्राएली मानिसहरूको विषयमा, मानिसहरू भन्दछन्, ‘परमेश्वरको महान सृष्टिलाई हेर!’ ");
INSERT INTO npi2010_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ती मानिसहरू सिंह झैं बलिया छन् सिंह झैं लड्छन्। अनि आफ्नो शत्रुलाई परास्त नपारे सम्म त्यो सिंह विश्राम गर्दैन। अनि त्यो सिंहले विश्राम नै लिंदैन जब सम्म आफ्नो शत्रु ती मानिसहरूको रगत पिउँदैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","बालाकले बिलामलाई भने, “आज देखि, तिमी मानिसहरूलाई आशिष अथवा सराप दिनु हुदैन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बिलामले उत्तर दिए, “मैले तिमीलाई अघि नै भने कि परमप्रभुले जे भन्न लगाउनु हुन्छ म त्यो मात्र भन्छु।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","तब बालाकले बिलामलाई भने, “अब मसंग आउनु होस् अर्को ठाँउमा। हुन सक्छ परमेश्वर खुशी भएर ती मानिसहरूलाई सराप्न अनुमति दिनुहुन्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","यसर्थ बिलामलाई बालाकले पोर पर्वतको चुचुरामा लगे। यहाँबाट मरूभूमि देखिन्थ्यो। ");
INSERT INTO npi2010_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बिलामले भने, “सातवटा वेदी बनाऊ। त्यसपछि वेदीमा बलिको निम्ति सातवटा साँढे र सातवटा भेडाहरू तयार पार।” ");
INSERT INTO npi2010_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बालाकले ठीक पारे अनि वेदीहरूमा ती साँढे र भेडाहरू बलि चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","जब बिलामले चाल पाए कि परमप्रभु इस्राएलीहरूलाई आशीर्वाद दिनमा खुशी हुनुहुन्छ, तिनले आफ्नो जादु टुनाहरू प्रयोग गरेनन, तर तिनी मरूभूमि तिर फर्केर हेरे। ");
INSERT INTO npi2010_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","जब बिलामले मरूभूमि तिर हेरे तिनले इस्राएली मानिसहरूलाई आफ्नो-आफ्नो कुल गरि छाउनीहरूमा बसेको देखे। त्यसपछि परमेश्वरको आत्मा तिनीभित्र आयो। ");
INSERT INTO npi2010_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","अनि बिलामले यो अगमवाणी दिएः “यो समाचार बओरका छोरो बिलामबाट हो। म ती चीजहरूको विषयमा भन्दैछु जो म स्पष्ट देख्छु। ");
INSERT INTO npi2010_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","म यो वाणी परमेश्वरबाट सुन्छु। परमेश्वर सर्वशक्तिमानले जे देखाउनु भयो मैले त्यो देखें। म जो स्पष्ट देख्छु त्यो विनम्र भई भन्छु। ");
INSERT INTO npi2010_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“हे याकूबका मानिसहरू हो तिमीहरूका पालहरू कति सुन्दर छन्। हे इस्राएलका बासिन्दाहरू हो! तिमीहरूका छाउनीहरू कति राम्रा छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","तिमीहरूको पालहरू नदी किनारका बगैंचाहरू जस्तै एकै पंक्तीमा रोपिएका ताड़का रूखहरू फैलिए जस्तै, परमप्रभुले रोप्नु भएको घिउकुमारी जस्तै, पानी नेरको देवदारहरू जस्तै फैलिएका छन्। ");
INSERT INTO npi2010_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","तिनीहरूका बाल्टीहरू पानीले भरिएर पोखिनेछन्, अनि तिनीहरूका बीउहरूले प्रशस्त पानी पाउने छन्। तिनीहरूका राजा अगाग भन्दा ठूलो हुनेछ, अनि तिनीहरूको राज्य बढ्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“परमेश्वरले तिनीहरूलाई मिश्रदेशबाट ल्याउनु भयो, तिनीहरूको निम्ति जंङ्गली साँढेको सींङ जस्तै शक्तिशाली हुनुहुन्छ। ती इस्राएलीहरूले आफ्नो शत्रुहरूलाई निल्नेछन्, र तिनीहरूको हड्डी फुटाएर चूर पर्नेछन्।अनि तिनीहरूलाई आफ्नो बाणहरूले छेड्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","विश्राममा तिनीहरू सिंह झैं सुत्नेछन् अनि सिंह झैं छन्, तिनीहरूलाई कसले बिउँझाउने? तिनीहरूलाई आशीर्वाद दिने आशीषित हुन्छन्, अनि तिनीहरूलाई सराप्ने श्रापित हुन्छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","बिलामसित बालाक रिसाएर हात पक्डिएर, तिनले बिलामलाई भने, “मैले तिमीलाई मेरा शत्रुहरूलाई सराप्न बोलाएको थिएँ तर तिमीले तिनीहरूलाई तीन पल्ट आशीर्वाद दियौ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","अब तिमी झट्टै आफ्नो घरमा जाऊ। मैले भनेको थिंए कि म तिमीलाई ठूलो सम्मान दिनेछु, तर परमप्रभुले तिमीलाई सम्मान पाउनुबाट बञ्चित गराउनु भयो।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बिलामले बालाकलाई भन्यो, “के मैले तिम्रा दूतहरूलाई भनेको थिईनँ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘यदि बालाकले सुन र चाँदीले परिपूर्ण महल दिए पनि म परमप्रभुको आज्ञा विरूद्ध केही गर्दिनँ? म त्यही गर्छु जो परमप्रभुले भन्नुहुन्छ।’ ");
INSERT INTO npi2010_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","अब म आफ्नो घरमा फर्केर जान्छु। तर म तिमीलाई चेतावनी दिन्छु कि यी इस्राएलका मानिसहरूले तिमी र तिम्रा मानिसहरूलाई भविष्यमा के गर्नेछन्, सुन।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","तब बिलामले यी कुराहरू भनेः “यो बओरको छोरो बिलाम जसले आफ्नो आखाँले सफासंग देख्न सक्छ, ");
INSERT INTO npi2010_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","कसले परमेश्वरको वचन सुन्न सक्छ, अनि कसले सर्वउच्च परमेश्वरबाट ज्ञान प्राप्त गर्न सक्छ? सर्वशक्तिमान परमेश्वरले यो कुराहरू देखाउनु भयो त्यो मैले देखें। म नम्रता पूर्वक तपाईंलाई भन्छु के म स्वच्छ देख्दैछु। ");
INSERT INTO npi2010_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“म परमप्रभुलाई देख्न सक्छु, तर अहिले होइन, म उहाँलाई देख्न सक्छु, तर नजीकबाट होइन। एउटा राजा तारा जस्तै याकूबको वंशबाट आउनेछ, इस्राएलका मानिसहरूबाट एक जना शासक जन्मनेछ। मोआबी मानिसहरूको त्यस शासकले टाउको किच्चयाउनुहुनेछ अनि शेतको वंशनै ध्वंश पार्नु हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","इस्राएलको शत्रु सेईरको भूमि इस्राएलको दखलमा हुनेछ, एदोमको भूमि पनि तिनीहरूकै दखलमा रहनेछ जब इस्राएलले बहादुरी देखाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“याकूबको वंशबाट शासक आउनेछ, र त्यस शहरमा बाँचेकाहरूलाई ध्वंश पार्नेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","बिलामले अमालेकी मानिसहरूलाई हेरेर अगमवाणी दिएः “राष्ट्रहरूमा अमालेक सबै भन्दा शक्तिशाली हो। तर ध्वंश हुनेछ अमालेक पनि।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","तब बिलामले कनानी मानिसहरूलाई हेरेर अगमवाणी बोलेः “चट्टानमा बनिएको गुँड जस्तै तिमीहरू सुरक्षित छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तर केनीहरू पनि ध्वंश पारिनेछन् जब अश्शूरले तिमीहरूलाई कैदी बनाउँनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","बिलामले तब फेरि अगमवाणी बोलेः “हाय! को जीवित रहन सक्छ जब परमेश्वरले यस्तो गर्नु हुन्छ? ");
INSERT INTO npi2010_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","जहाजहरू कित्तीमको किनारबाट आउनेछन् र तिनीहरूले अश्शूर र एबरलाई परास्त पार्नेछन्। तर तिनीहरू पनि ध्वंश गराइनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","त्यसपछि बिलाम उठेर घर फर्के अनि बालाक पनि आफ्नो बाटो लागे। ");
INSERT INTO npi2010_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","शित्तीममा जब इस्राएलीहरू बस्दै थिए, त्यति बेला इस्राएली पुरूषहरूले मोआबी स्त्रीहरूसित शारीरिक सम्बन्ध राख्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","मोआबी स्त्रीहरूले तिनीहरूलाई आफ्नो पूजा आजामा भाग लिन बोलाए। यसर्थ तिनीहरूले आफ्नो देवताहरूलाई चढाएको बलिहरू इस्राएली मानिसहरूले खाए अनि ती देव-देवताहरू पूज्न थाले। ");
INSERT INTO npi2010_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","यसरी इस्राएलीहरूले पोरको बाल-देवता पूज्न थाले। यसकारण परमप्रभु तिनीहरूसित क्रोधित हुनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","परमप्रभुले मोशालाई भन्नुभयो, “यो मानिसहरूका सबै नायकहरूलाई बोलाऊ र तिनीहरूलाई परमप्रभु अघि लगेर समान्य जनसाधरणको सामुन्ने झुण्डाई देऊ। त्यस पछि परमप्रभु इस्राएलका मानिसहरूसित रिसाउनु हुनेछैन।” ");
INSERT INTO npi2010_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","मोशाले इस्राएलका न्यायकर्त्तालाई भने, “तिमीहरू प्रत्येकले आफ्नो परिवार समूहमा त्यस्ता व्यक्तिहरू खोज्नु पर्छ जसले मानिसहरूलाई पोरको बाललाई झूटा देवतालाई पूज्न प्रोत्साहन दिए। तब तिमीहरूले त्यस्ता मानिसहरूलाई मार्नुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","जति बेला मोशा अनि इस्राएली समूह भेट हुने पालको प्रवेशद्वारमा भेला भएका थिए त्यति बेला एक इस्राएली पुरूषले एउटी मिद्यानी स्त्रीलाई उसको पालमा ल्यायो। त्यो मोशा तथा अन्य सबै इस्राएली मानिसहरूले देखिरहेका थिए। तिनीहरू रून थाले। ");
INSERT INTO npi2010_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","हारूनको नाति एलाजारका छोरो पीनहासले त्यसरी एउटी स्त्रीलाई पालभित्र लगेको देख्यो। यसर्थ पीनहासले सभा त्यागेर आफ्नो भाला बोकेर। ");
INSERT INTO npi2010_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","त्यस इस्राएली व्यक्तिलाई पछ्याउँदै पालभित्र गयो। त्यसपछि पालभित्रै त्यस स्त्री र इस्राएली पुरूषको शरीरमा भाला रोपी मारी दियो। त्यस बखतमा त्यहाँ इस्राएलीहरू महामारीको प्रकोपमा थिए अनि जब पीनहसले ती दुइजनालाई मार्यो त्यो महामारी थामियो। ");
INSERT INTO npi2010_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","त्यस महामारीको प्रकोपमा 24,000 मानिसहरू मरे। ");
INSERT INTO npi2010_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“एलाजारको छोरो पूजाहारी हारूनको नाति पीनहासले इस्राएलका मानिसहरूलाई मेरो क्रोधबाट बचायो। उसले यो काम गर्यो किनभने ऊ मेरो सम्मानको रक्षा गर्न उत्सुक थियो। यसकारण क्रोधित हुँदा इस्राएलका मानिसहरूलाई मारे। ");
INSERT INTO npi2010_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","यसकारण पीनहासलाई भनिदेऊ, म ऊसित शान्तिको करार राख्नेछु। ");
INSERT INTO npi2010_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","शान्तिको सम्झौता यो होः ऊ अनि उसका आउने भावि सन्तान सदा सर्वदाको निम्ति पूजाहारीहरू भई रहनेछन्। किनभने ऊ मेरो सम्मानको रक्षा गर्न उत्सुक थियो र उसले इस्राएली मानिसहरूलाई प्रायश्चित गरायो।” ");
INSERT INTO npi2010_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","जो व्यक्ति मिद्यानी स्त्रीसित मर्यो। त्यो थियो शिमोन कुल परिवारको प्रमुख सालूको छोरो जिम्री। ");
INSERT INTO npi2010_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","त्यो मर्ने स्त्रीको नाम सूरकी छोरी कोजबी थिई। सूर मिद्यानी वंश घरानाको मुखिया थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानी मानिसहरूसित शत्रु भई तिनीहरूलाई परास्त गर। ");
INSERT INTO npi2010_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","किनभने छल गरेर झूटा देवता पूज्न लगाई, मिद्यानका मुखियाकी छोरी कोजबी जो पोर घटनाको कारणले इस्राएलीहरूमा महामारीले सताएको वखतमा मारिएकी थिई, यसकारण तिमीहरू तिनीहरूको शत्रु बने।” ");
INSERT INTO npi2010_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","त्यो डरलाग्दो महामारी पछि परमप्रभुले मोशा र पूजाहारी हारूनको छोरो एलाजारलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“सम्पूर्ण इस्राएली मानिसहरूको समुदायमा जो बीस वर्ष अथवा वेशी उमेरका छन्। तिनीहरूलाई गन र तिनीहरूलाई लडाँईमा जान उपयुक्त हुने परिवार अनुसार सूची बनाऊ।” ");
INSERT INTO npi2010_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","यसकारण मोशा र पूजाहारी एलाजारले तिनीहरूसित यरीहोको पारी यर्दन नदीको नजिक मोआबको मैदानमा कुरा गरे। तिनीहरूले भने, ");
INSERT INTO npi2010_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“इस्राएलका सबै मानिसहरू जो बीस वर्ष भन्दा माथिको छ सबैको गन्ती गर, परमप्रभुले मोशा र इस्राएलीहरूलाई आज्ञा गर्नु भए जस्तो जो मिश्रबाट बाहिर आए।” ");
INSERT INTO npi2010_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","रूबेन इस्राएलको जेठो छोरो हो। रूबेनका सन्तान यस प्रकारले छन्; हनोकबाट हनोकीहरूको कुलसमूह, पल्लूबाट पल्लूईहरूको कुल समूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हिस्रोनबाट हिस्रोनीहरूको कुलसमूह, कर्मीबाट कर्मीहरूको कुल समूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","रूबेनहरूका कुलका कुलसमूह यिनीहरू नै थिए। मानिसहरूको जन संख्या 43,730 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्लूका छोरो एलीआब थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","एलीआबका छोराहरू नमूएल, दातान र अबीराम थिए। यी तिनै दातान र अबीराम हुन् जसलाई समुदायबाट चुने अनि तिनीहरू नै मोशा र हारूनको विरोधमा गए। जब तिनीहरूले परमप्रभुको विरोध गरे दातान र अबीराम कोरहको अनुयायीहरूको वीचमा थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","अनि पृथ्वी र्चकिएर मुख बायो अनि कोरह र तिनीहरूलाई निल्यो। जब कोरहको अनुयायीहरू मरे अनि जब 250 जना मानिसहरूलाई आगोले भस्म पार्यो मानिसहरूलाई चेतावनीको निम्ति एउटा दृष्टान्त भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","तर कोरहका छोराहरू मरेनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","कुलसमूह अनुसार शिमोनको सन्तानहरू यी नै हुन्; नमूएलबाट नमूएलको कुलसमूह, यामीनबाट यामीनीहरूको कुलसमूह, याकीनबाट याकीनीको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरहबाट जेरहीहरूको कुलसमूह, शाऊलबाट शाऊलहीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","शिमोनहरूका कुलका कुलसमूहहरू यी नै थिए। तिनीहरूमा जम्मा 22,200 मानिसहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","तिनीहरूको कुलसमूह अनुसार गादको कुलसमूह यस प्रकारको थियोः सपोनबाट सपोनीहरूको कुलसमूह, हाग्गैबाट हाग्गैहरूको कुलसमूह, शूनीबाट शूनीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनीबाट ओजनीहरूको कुलसमूह, एरीबाट एरीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोदाबाट अरोदाहरूको कुलसमूह अरेलीबाट अरेलीहरूको कुलसमूह भए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गादाहरूको कुलका कुलसमूहहरू यस प्रकारका थिए र तिनीहरूको जन संख्या 40, 500 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","यहूदाका छोराहरू एर र ओनान थिए र तिनीहरू कनान देशमा मरे। तिनीहरूको कुलसमूह अनुसार यहूदाको सन्तान यस प्रकारको थियोः शेलहबाट शेलानीहरूको कुलसमूह, पेरेसबाट पेरेसीहरूको कुलसमूह, जेरहबाट जेरहातीहरूको कुलसमूह भए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","पेरेसका सन्तानहरू यस प्रकारका थिएः हेस्रोनबाट हेस्रोनीहरूको कुलसमूह, हमूलबाट हामूलीहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यहूदाको कुलका कुलसमूहहरू यही हो र तिनीहरूको जम्मा जन-संख्या 76,500 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","तिनीहरूको कुलसमूह अनुसार इस्साकारको सन्तान यस प्रकारको थियोः तोलाबाट तोलाहीहरूको कुलसमूह, पुव्वाबाट पुव्वाहीहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूबबाट याशूबीहरूको कुलसमूह, हिम्रोनबाट हिम्रोनीहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्साकारको कुलका कुलसमूहहरू यही हो र तिनीहरूको जनसंख्या 64,300 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","तिनीहरूको कुलसमूह अनुसार जबूलूनको सन्तान यस प्रकारको थियोः सेरेदबाट सेरेदीहरूको कुलसमूह, एलोनबाट एलोनीहरूको कुलसमूह, यहलेलबाट यहेलेलीको कुलसमूह भए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","जबूलूनको कुलका कुलसमूहहरू यही हो र तिनीहरूको जनसंख्या 60,500 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","यूसुफका मनश्शे र एप्रैम नाम गरेका दुई जना छोराहरू थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्शेबाट भएका सन्तानहरू यिनीहरू नै हुन् माकीरबाट माकीरी कुलसमूह, (माकीर गिलादका बाबु थिए) गिलादबाट गिलादीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलादबाट भएका सन्तानहरूः ईएजरेबाट ईएजेरीहरूको कुलसमूह, हेलेकबाट हेलेकीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्त्रीएलबाट अस्त्रीलीहरूको कुलसमूह, शेकेमबाट शेकेमीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शमीदाबाट शमीदीहरूको कुलसमूह, हपेरबाट हेपेरीहरूको कुलसमूह ");
INSERT INTO npi2010_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","सलोफाहद हेपेरका छोरो थिए। यिनीबाट कुनै छोरो जन्मेन तर छोरीहरू मात्रै जन्मे। शलोफाहदका छोरीहरू थिए महला, नोआ, होग्लाह, मिल्का अनि तिर्सा। ");
INSERT INTO npi2010_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","मनश्शेको कुलको कुलसमूहहरू यस प्रकारको छ। तिनीहरूको जन संख्या 52,700 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एप्रैमको कुलसमूह यस प्रकार छः शूतेलहबाट शूतेलहीहरूको कुलसमूह, बेकेरबाट बेकेरीहरूको कुलसमूह, तहनबाट तहनीहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","शूतेलहका कुलसमूह यस प्रकारका थिएः एरानबाट एरानीहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एप्रैमको कुलका कुलसमूहहरू यस प्रकार थिए अनि तिनीहरू को जन-संख्या 32,500 थियो। यूसुफको कुल कुलसमूहहरू तिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बिन्यामीनका कुलसमूहहरू यिनीहरू हुन्; बेलाबाट बेलाही कुलसमूह, अशबेलबाट अशबेलिहरूको कुलसमूह, अहीरामबाट अहीरामीहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शूपामबाट शपामीहरूको कुलसमूह हूपामबाट हुपामीहरूको कुलसमूह भए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","अर्द र नामन बेलाका छोराहरू हुन्; अर्दबाट अर्दीहरूको कुलसमूह, नामानबाट नामानीहरूको कुलसमूह भए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","बिन्यामीनको कुलका कुलसमूहहरू यिनीहरू नै थिए। तिनीहरूको जन-संख्या 45,600 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दानका कुलसमूह यिनीहरू हुन्; सूहामबाट शूहामीहरूको कुलसमूह ");
INSERT INTO npi2010_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","दानको कुलका कुलसमूहहरू यिनीहरू नै थिए अनि सबै सूहामीहरूको जन-संख्या 64,400 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेरको कुलसमूहहरू यस प्रकार थिएः यिम्नाहबाट यिम्नानीहरूको कुलसमूह, यिशवी बाट यिश्वीहरूको कुलसमूह, बेरीयहबाट बेरीयाहरूको कुलसमूह, ");
INSERT INTO npi2010_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","बेरीयाहबाट यी परिवारहरू थिएः हेबेरबाट हेबेरीहरूको कुलसमूह, मल्कीएलबाट मल्कीएहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(आशेरको सेरह नाम गरकी छोरी थिई)। ");
INSERT INTO npi2010_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","कुलसमूह अनुसार आशेरकुलका यही कुलसमूहहरू थिए र तिनीहरूको जन-संख्या 53,400 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","कुलसमूह अनुसार नप्तालीबाट यी कुलसमूहहरू थिएः यहसेलबाट यहसेलीहरूको कुलसमूह, गुनीबाट गुनीहरूको कुलसमूह ");
INSERT INTO npi2010_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेरबाट येसेरीहरूको कुलसमूह शिल्लेमबाट शिल्लेमीहरूको कुलसमूह। ");
INSERT INTO npi2010_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","कुलसमूह अनुसार नप्ताली कुलका कुलसमूहहरू यिनीहरू नै थिए अनि यिनीहरूको जन-संख्या 45,400 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","यसर्थ इस्राएली मानिसहरूको जन-संख्या 6,01,730 थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“यी मानिसहरू माझ भूमि वितरण गरिन्छ र तिनीहरूलाई दिइन्छ। यसरी ती सबै गन्तीमा परेका मानिसहरू प्रत्येकले प्रशस्त भूमि पाउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ठूलो परिवारले धेरै र सानो परिवारले कम्ती गरी भूमि पाउनेछन्। तिनीहरूलाई दिइएको भूमि गन्ती गरिएका मानिसहरू बराबर हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","तर कसले कुन इलाका पाउने हो त्यो चिठ्ठा द्वारा निर्णय गरिनेछ अनि आफ्ना पुर्खाका कुल अनुसार नाममा तिनीहरू आफ्नो इलाका निर्धारित हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","प्रत्येक कुल समूहको अंश चिठ्ठा द्वारा निर्धारण गरिनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","कुलसमूह अनुसार गन्ती गरिएका लेवी कुलका कुलसमूहहरू यिनीहरू नै हुन्। गेर्शोनबाट गेर्शोनीहरूको कुलसमूह कहातबाट कहातीहरूको कुलसमूह मरारीबाट मरारीहरूको कुलसमूह भए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेवी कुलको कुलसमूहहरू यी नै हुन्। लिब्नीहरूको कुलसमूह, हेब्रोनीहरूको कुलसमूह, महलीहरूको कुलसमूह, मूशीहरूको कुलसमूह, कोरहीहरूको कुलसमूह। कहात अम्रामका पिता थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्रामकी पत्नीको नाम योकेबेद थियो अनि तिनी लेवी कुलसमूहकी थिइन्। तिनी मिश्रदेशमा लेवी कुलमा जन्मेकी थिइन्। अनि योकेबेल आम्रामका निम्ति, हारून, मोशा र मरियमलाई जन्माईन्। ");
INSERT INTO npi2010_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","हारून नादाब, अबीहू, एलाजार अनि इतामारका पिता थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","तर नादाब र अबीहू परमप्रभुको अघि अनुमति नभएको आगोमा बलि चढाएको कारणले मरे। ");
INSERT INTO npi2010_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","एक महीना र अधिक उमरेका पुरूष गन्दा लेवीहरूको संख्या 23,000 थियो। तिनीहरू मानिसहरूसित गनिएनन कारण तिनीहरूले इस्राएलका मानिसहरूसित भूमिमा अंश पाएनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","यी मानिसहरूको गन्ती मोशा र पूजाहारी एलाजारले गरेका थिए। मोशा र एलाजार पूजाहारीले इस्राएली मानिसहरूको गन्ती यरीहोको पारी यर्दन नदीको किनार मोआबको मैदानमा गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","धेरै दिन अघि सिनै मरूभूमिमा मोशा र हारूनले जुन इस्राएली मानिसहरूको गन्ती गरेका थिए तिनीहरू मरिसके अनि तिनीहरूमा कोही पनि जीवित थिएनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","किन? किनभने तिनीहरू मरूभूमिमा मर्छन भनी परमप्रभुले भन्नु भएको थियो। तिनीहरू मध्ये बाँचेकाहरू हुन् यपुन्नेको छोरो कालेब र नूनको छोरो यहोशू। ");
INSERT INTO npi2010_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","सेलोफादका पाँच जना छोरीहरू थिए, सेलोफा हेपेरको छोरा थिए, हेपेर गिलादका छोरा थिए, गिलाद माकीरका छोरा थिए, माकीर मनश्शेका छोरा थिए र मनश्शे यूसुफका छोरा थिए। तिनीहरूको नाम यस प्रकारको थियोः महला, नोआ होग्ला, मिल्का र तिर्सा। ");
INSERT INTO npi2010_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","तिनीहरू भेट हुने पालमा मोशा, पूजाहारी एलाजार, नायकहरू र सारा इस्राएली समुदायको सामुन्ने उभिएर भने, ");
INSERT INTO npi2010_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“हाम्रा पिता मरूभूमिमा मर्नुभयो। उहाँ कोरहका अनुयायीहरू जो परमप्रभुको विरूद्धमा गए, तिनीहरूसित हुनु हुँदैन थियो। उहाँ पुत्रहीन हुनुहुन्थ्यो र आफ्नै पापले मर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","उहाँको छोरो थिएन भन्दैमा किन उहाँको नाम आफ्नो वंशमा रहँदैन? हामीलाई पनि हाम्रो पिताको दाज्यू-भाईहरूको बराबरमा जमीन दिनुहोस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","यसर्थ मोशाले यो मामिला परमप्रभु अघि राखे। ");
INSERT INTO npi2010_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सेलोफाकी छोरीहरूले गरेको बिन्ति न्यायसंगत छ र तिनीहरूले आफ्नो पिताको दाज्यू-भाईहरूसितै जमीनको अंश पाउनु पर्छ। यसर्थ जुन जमीन तिमीले तिनीहरूको पितालाई दिने थियौ त्यो जमीन तिनीहरूलाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“इस्राएलका मानिसहरूको निम्ति यो नियम बनाएर राख, ‘यदि पुत्रहीन व्यक्ति मरे उसको सबै सम्पत्ति उसकी छोरीहरूले पाउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","उसकी छोरी पनि नभएको खण्ड त्यो सम्पत्ति उसको आफ्नो दाज्यू-भाईले पाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","फेरि यदि उसको दाज्यू-भाई नभएको खण्डमा उसको काका-बडा-बाबुले पाउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","उसको काका-बडा-बाबुहरू पनि नभएको खण्डमा उसको सम्पत्ति आफ्नो साख्खै आफन्तहरूले पाउनेछन्। इस्राएलका मानिसहरूमा यो नियम रहन्छ। यो आज्ञा परमप्रभुले मोशालाई दिनु भएको हो।’” ");
INSERT INTO npi2010_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","त्यस पछि परमप्रभुले मोशालाई भन्नुभयो, “यर्दन नदीको मरूभूमिको पहाडमा जाऊ। त्यहाँ तिमीले मैले इस्राएलका मानिसहरूलाई दिन लागेको भूमि देख्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","त्यो भूमि देखे पछि तिम्रो दाज्यु हारून जस्तै तिमी पनि मर्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","किनभने, सीनैको मरूभूमिमा मानिसहरूले पानीको निम्ति मसंग माग्दा तिमीले मेरो आज्ञा उलघंन गरेका थियौ। तिनीहरूको सामुन्ने तिमीले मलाई सम्मान राखेनौ।” (यो घटना सीनै मरूभूमिमा कादेश नजिकको मरीबाको पानीहरूमा भएको थियो।) ");
INSERT INTO npi2010_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","मोशाले परमप्रभुलाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“परमप्रभु परमेश्वर हुनुहुन्छ जसले मानिसहरूले के सोचिरहेकाछन् चाल पाउनु हुन्छ। हे परमप्रभु, म प्रार्थना गर्छु कि यी मानिसहरूको निम्ति एउटा मानिस अगुवा चुनिदिनु होस्। ");
INSERT INTO npi2010_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","म प्रार्थना गर्छु कि तपाईंले एउटा मानिस अगुवा चुनिदिनु होस् ताकि उसले यी मानिसहरूलाई यस भूमि देखि नयाँ भूमिमा अगुवाई गरेर लानेछ। त्यसो भए परमप्रभुका मानिसहरू गोठाला बिनाका भेंडाहरू जस्ता हुनेछैनन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","त्यसकारण परमप्रभुले मोशालाई भन्नुभयो, “यहोशू नूनको छोरो यी मानिसहरूका नयाँ अगुवा हुनेछन्। ऊसित आत्माको ज्ञान छ तिम्रो हातहरू उसको शिर माथि राखेर उसलाई अगुवा झैं नियुक्त गर। ");
INSERT INTO npi2010_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","तिनलाई पूजाहारी एलाजार अनि सारा मानिसहरूको अघि राख र अगुवा बनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“उसलाई अधिकार देऊ यसकारण इस्राएलका सम्पूर्ण समूदायले उसलाई सुन्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","यदि यहोशूले कुनै विषयमा निर्णय लिनु परे तिनी पूजाहारी एलाजार कहाँ जानेछन् अनि एलाजारले परमप्रभुको उत्तर जान्नको निम्ति ऊरीम प्रयोग गर्नेछन्। त्यस पछि यहोशू र अन्य सबै इस्राएलीहरू परमप्रभुको आज्ञा अनुसार चल्नेछन्। यदि उहाँ भन्नुहुन्छ, ‘तिमीहरू युद्धमा जाऊ,’ तब युद्धमा जानेछन् र यदि तिमीहरू, ‘घरमा जाऊ’ भनि भन्नु हुन्छ भने, तब तिनीहरू घर जानेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","परमप्रभुको आज्ञा अनुसार मोशाले गरे। उनले यहोशूलाई इस्राएलका सारा समुदाय तथा पूजाहारीको सम्मुख उभ्याए। ");
INSERT INTO npi2010_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","त्यसपछि यहोशू माथि मोशाले हात राखे अनि परमप्रभुले तिनलाई दिनु भएको आज्ञा दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएलका मानिसहरूलाई यो आज्ञा देऊ। मेरो बलिहरू ल्याउनु निश्चय होऊ आगो द्वारा चढाइने मेरो भोजन मिठो बासना आउने उपहार सही समयमा चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","अनि तिनीहरूलाई भन: प्रत्येक दिन नियमित रूपमा एक बर्षे दुइवटा निष्खोट थुमाहरू निरन्तर होमबलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","एउटा थुमा बिहान र अर्को एउटा घाम अस्ताइ सकेपछि तर अँध्यारो हुन अघि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","अन्नबलिको निम्ति हीनको एक पावा भद्राक्षको तेलमा मिसाएको एपको दशौं भाग मसिनो पीठो पनि चढाउनु पर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(परमप्रभुको निम्ति मीठो वास्ना आउने बलि नियमित रूपले सीनै पर्वतमा दिन थालिएको हो।) ");
INSERT INTO npi2010_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","“एउटा थुमासित हीनको एक पावा गरेर अर्घबलि पनि दिनुपर्छ। त्यो पेय उपहार चाँहि पवित्र स्थानमा परमप्रभुलाई चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","त्यसपछि गोधूली बेलामा दोस्रो थुमासित अन्न बलि र अर्घबलि परमप्रभुलाई सन्तुष्ट पार्न सुगन्धित वासाना आउने उपहार झैं चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“विश्रामको दिनमा पनि एक वर्षे निष्खोट दुइवटा थुमा, एपको दश खण्डको दुई खण्ड तेलमा मुछेको मसिनो पीठो अर्घबलिसित चढाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","नियमित रूपमा चढाउने गरेको दैनिकबलिसित विश्रामको दिनमा पनि होमबलि गर।” ");
INSERT INTO npi2010_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“प्रत्येक महीनाको पहिलो दिन वथानबाट दुइवटा जवान गोरूहरू, एउटा भेंडा एक वर्ष सातवटा थुमाहरू होमबलिमा तिमीहरूले चढाउनु पर्छ। ती सबै बलिमा चढाइएका पशुहरू एकदमै निष्खोट हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","प्रत्येक साँढेसित तेलले मुछेको एपको दश खण्डको तीन खण्ड मसिनो पीठो अनि प्रत्येक भेडासित तेलले मुछेको एपको दश खण्डको दुई खण्ड अन्नबलिको निम्ति र ");
INSERT INTO npi2010_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","प्रत्येक थुमासित तेलमा मुछेको एपको दश खण्डको एक खण्ड मसिनो पीठो अन्नबलिको निम्ति चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","प्रत्येक गोरूको निम्ति आधा हीन दाखरस, प्रत्येक भेडाको निम्ति हीनको तीन खण्डको एक खण्ड र प्रत्येक थुमाको निम्ति हीनको चार खण्डको एक खण्ड अर्घबलि स्वरूप दाखरस चढाउनु पर्छ। वर्षको प्रत्येक महीनाको हरेक औंसीमा चढाउनु पर्ने होमबलि यही हो। ");
INSERT INTO npi2010_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","होमबलिको अर्घबलि अतिरिक्त तिमीहरूले पापबलिको निम्ति एउटा बोका पनि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“पहिलो महीनाको चौधौं दिन परमप्रभुको निम्ति निस्तार चाड मनाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","त्यही महीनाको पन्ध्रौं दिनमा अखमिरी रोटी सात दिन सम्म खाने शुरू हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","यो चाडको पहिलो दिन एउटा विशेष सभा राखियोस्। त्यसदिन तिमीहरूले केही काम गर्नु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","त्यस समयमा तिमीहरूले परमप्रभुको निम्ति होमबलि चढाउनेछौ, त्यस होमबलिमा दुइवटा बहर एउटा भेंडा र सातवटा एक वर्षे थुमाहरू हुनुपर्छ। तिनीहरू सबै निष्खोट हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","तिनीहरूसित प्रत्येक साँढेसित तेलमा मुछेको एपाको दश खण्डको तीन खण्ड, मसिनो पीठो, भेडासित एपाको दश खण्डको दुई खण्ड मसिनो पीठो, ");
INSERT INTO npi2010_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","र सातवटा थुमाहरूसित प्रत्येकको एपाको दश खण्डको एक खण्ड गरी मसिनो पीठोको अन्नबलि चढउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","तिनीहरूलाई प्रायश्चित गर्नका निम्ति पापबलिको लागी एउटा बाख्रा बलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","तिमीहरूले प्रत्येकदिन बिहान दिने बलिहरूको अतिरिक्त यी बलिहरू चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“यस्तै प्रकारले मिठो सुगन्धीत उपहार परमप्रभुलाई सन्तुष्ट तुल्याउन होमबलि र अन्नबलि चढाउनु पर्छ। बलिहरू मानिसहरूको निम्ति भोजन हुनेछ। यो बलि प्रत्येक दिन चढाइने होमबलि र अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“सातौं दिन तिमीहरूले आफ्नो कुनै कार्य नगर्नु र त्यसदिन एउटा विशेष सभा राख्नु। ");
INSERT INTO npi2010_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“अगौटे फलहरूको दिनहरूमा, सातौ दिनका चाढहरूमा, तिमीहरूले परमप्रभुलाई नयाँ अन्नको बलि चढाउँनुपर्छ त्यस दिन तिमीहरूले एउटा पवित्र सभा बोलाउनुपर्छ। तर त्यसदिन तिमीहरूले कुनै कार्य गर्नुहुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","तिमीहरूले परमप्रभुलाई मिठो सु-गन्धले खुशी पार्नको निम्ति दुइवटा बहर, एउटा भेडा र सातवटा एक वर्षे थुमाहरू होमबलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","प्रत्येक बाछासित तेलमा मुछेको एपाको दश खण्डको तीन खण्ड मसिनो पीठो भेडासित एपाको दश खण्डको दुई खण्ड मसिनो पीठो, ");
INSERT INTO npi2010_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","अनि सातवटा थुमाहरू प्रत्येकको निम्ति एपाको दश खण्डको एक खण्ड मसिनो पीठो अन्नबलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","तिमीहरूको प्रायश्चितको निम्ति एउटा बोको पनि बलि चढाउनु। ");
INSERT INTO npi2010_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","तिमीहरूले नित्य चढाउने होमबलि र अन्नबलि वाहेक यी बलिहरू र अर्घबलि पनि चढाउनु पर्छ। बलि चढाइने पशुहरू एकदमै निष्खोट हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“सातौं महीनाको पहिलोदिन तिमीहरूको निम्ती एउटा विशेष सभा डाकिनु पर्छ। त्यस दिन तिमीहरूले कुनै अरू परिश्रम गर्नु हुँदैन। त्यो दिन तिमीहरूको निम्ति तुरही बजाउने दिन हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","तिमीहरूले एउटा बाछा बथानबाट, एउटा भेडा र सातवटा एक वर्षे थुमाहरू परमप्रभुलाई मिठो सुगन्ध दिने होमबलि चढाउने छौ। यी पशुहरू सबै निष्खोट हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","परमप्रभुलाई अन्नबलिको निम्ति तेलमा मुछेको एपाको दश खण्डको तीन खण्ड मसिनो पीठो साँढेसित, एपाको दश खण्डको दुई खण्ड भेडासित, ");
INSERT INTO npi2010_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","अनि एपाको दश खण्डको एक खण्ड गरी सातवटा थुमाहरूमा प्रत्येक थुमाहरूसित चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","तिमीहरूले एउटा बाख्रा तिम्रो पाप प्रायश्चित गर्नका निम्ति बलि चढाउ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ती औसीको बलिहरू प्रत्येक महिनाको निम्ति चढाइने बलिहरू र तिनीहरूको साथमा चढाइने अन्नबलि, प्रत्येक दिन चढाइने बलिहरू र तिनीहरूको साथमा चढाइने अन्नबलि तथा अर्घबलि देखि वाहेक हुन्। यी बलिहरू नियम रूपमा हुनु पर्छ र यी बलिहरू आगोद्वारा चढाइनु पर्छ र सुगन्धले परमप्रभुलाई आनन्द तुल्याउनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“सातौं महीनाको दशौं दिन त्यहाँ तिमीहरूको निम्ति एउटा विशेष सभा हुनेछ। त्यस दिन तिमीहरू उपवास बस्नु पर्छ अनि कुनै काम गर्नु हुदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","परमप्रभुको निम्ति मगमग सुगन्धित वास्नाको रूपमा एउटा बाछा एउटा भेडा अनि सातवटा एक वर्षे थुमाहरू होमबलिमा चढाइनुपर्छ। ती पशुहरूमा कुनै प्रकारको खोट रहनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","अनि तिमीहरूले त्यो होमबलिको साढेसित तेलमा मुछेको एपाको दश खण्डको तीन खण्ड मसिनो पीठो, भेडासित एपाको दश खण्डको दुई खण्ड तेलमा मुछेको मसिनो पीठो, ");
INSERT INTO npi2010_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","अनि सातवटा थुमाहरूमा प्रत्येकको एपाको दश खण्डको एक खण्ड तेलमा मुछेको मसिनो पीठो चढाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","पापबलिको निम्ति तिमीहरूले एउटा बोका पनि चढाउनुपर्छ। यो बलि चाँहि प्रायश्चित बलिको अतिरिक्त हो र नियमित रूपले चढाएको दैनिक अन्नबलि र अर्घबलिको पनि अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“सातौं महिनाको पन्ध्रौं दिन तिमीहरूले एउटा विशेष सभा राख्नु अनि त्यसदिन कुनै दैनिक काम नगर्नू। परमप्रभुको सम्मानमा सात दिनसम्म उत्सव मनाउनू। ");
INSERT INTO npi2010_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","तिमीहरूले बथानबाट तेह्रवटा बहर गोरू दुइवटा भेडा र एक वर्षे चौधवटा थुमाहरू परमप्रभुको निम्ति मगमग सुगन्धित वास्ना बनाउनलाई होमबलि चढाउनुपर्छ। यी पशुहरू निष्खोट हुनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","यो होमबलिसित एपाको दश खण्डको तीन खण्ड तेलसित मुछेको मसिनो पीठो प्रत्येक जवान साँढेसित एपाको दश खण्डको दुई खण्ड तेलसित मिसिएको मसिनो पीठो प्रत्येक भेडासित ");
INSERT INTO npi2010_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","र प्रत्येक थुमासित एपाको दश खण्डको एक खण्ड तेलसित मुछेको मसिनो पीठो होमबलि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","यसैसित पापबलिको निम्ति एउटा पाठो पनि चढाउनुपर्छ। यो नित्य चढाइने होमबलि र अन्नबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“उत्सवको दोस्रो दिन तिमीहरूले बाह्रवटा बहर गोरू, दुइवटा भेडाहरू र एक वर्षे चौधवटा थुमाहरू बलि चढाउनुपर्छ। यी बलि दिइने पशुहरूमा कुनै खोट नहोस्। ");
INSERT INTO npi2010_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","तिमीहरूले यी साँढे, भेडाहरू तथा थुमाहरूसित यिनीहरूको तोकिएको संख्या अनुसार सही परिमाणको अन्नबलि तथा अर्घबलि पनि चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","तिमीहरूले पापबलिको निम्ति एउटा बोको पनि चढाउनु पर्छ। यो बलि तिमीहरूले चढाउने दैनिकबलि र यससित चढाइने अन्नबलि र अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“उत्सवको तेस्रो दिन तिमीहरूले एघारवटा बहर गोरू, दुइवटा भेडा र चौधवटा एक वर्षे थुमाहरू चढाउनु पर्छ। यी चढाइने पशुहरूमा कुनै प्रकारको खोट हुनुहुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","तिमीहरूले यी बहर, भेडा र थुमाहरू चढाउँदा यिनीहरूको तोकिएको संख्या अनुसार चढाउनु पर्छ र अन्नबलि अर्घबलि पनि सही परिमाणमा चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","पाप बलिको निम्ति एउटा बोको पनि चढाउनु पर्छ। यो बलि तिमीहरूले चढाउने दैनिक बलि र त्यससित चढाइने अन्न बलि तथा अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“उत्सवको चौथो दिन तिमीहरूले दशवटा बहर गोरू, दुइवटा भेडा र चौधवटा एक वर्षे थुमाहरू चढाउनु पर्छ। यी चढाइने पशुहरूमा कुनै प्रकारको खोट हुनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","तिमीहरूले यी बहर गोरू, भेडा र थुमाहरू चढाउँदा यिनीहरूको तोकिएको संख्या अनुसार चढाउँनुपर्छ र अन्नबलि र अर्घबलि पनि सही परिमाणमा चढाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","पापबलिको निम्ति एउटा वोको पनि चढाउनुपर्छ। यो बलि तिमीहरूले चढाउने दैनिक बलि र त्यससित चढाइने अन्नबलि तथा अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“उत्सवको पाँचौदिन तिमीहरूले नौवटा बाछा, दुइवटा भेडा र चौधवटा एक बर्षे थुमाहरू चढाउनु पर्छ। यी चढाइने पशुहरूमा कुनै प्रकारको खोट हुनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","तिमीहरूले यी बाछा, भेडा र थुमाहरू चढाउँदा यिनीहरूको तोकिएको संख्या अनुसार चढाउनु पर्छ र अन्नबलि र अर्घबलि पनि सही परिमाणमा चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","पापबलिको निम्ति एउटा बोका पनि चढाउनु पर्छ। यो बलि तिमीहरूले चढाउने दैनिकबलि र त्यससित चढाइने अन्नबलि तथा अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“उत्सवको छौंटौं दिन तिमीहरूले आठवटा बाछा, दुइवटा भेडा र चौधवटा एक बर्षे थुमाहरू चढाउनु पर्छ। यी बलि चढाइने पशुहरूमा कुनै प्रकारको खोट हुनु हुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","तिमीहरूले यी बाछा, भेडा र थुमाहरू चढाउँदा यिनीहरूको तोकिएको संख्या अनुसार चढाउनु पर्छ र अन्नबलि र अर्घबलि पनि सही परिमाणको चढाउने पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","पापबलिको निम्ति एउटा बोको पनि चढाउनु पर्छ। यो बलि तिमीहरूले चढाउने दैनिक बलि, त्यससित चढाइने अन्नबलि तथा पेयबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“उत्सवको सातौं दिन तिमीहरूले सातवटा बाछा, दुइवटा भेडा र चौधवटा एक वर्षे थुमाहरू चढाउनु पर्छ। यी बलि चढाइने पशुहरू निष्खोट हुनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","तिमीहरूले यी बाछा, भेडा र थुमाहरू चढाउँदा यिनीहरूको तोकिएको संख्या अनुसार चढाउन पर्छ र अन्नबलि र अर्घबलि पनि सही परिमाणको चढाउनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","पाप-बलिको निम्ति एउटा बोको पनि चढाउनु पर्छ। यो बलि तिमीहरूले चढाउने दैनिकबलि, त्यसित चढाइने अन्नबलि तथा अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“उत्सवको आठौं दिनमा एउटा विशेष सभा हुनेछ। त्यस दिन तिमीहरूले परिश्रमको कार्य गर्नुहुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","त्यस दिन तिमीहरूले परमप्रभुलाई मीठो वास्नाले खुशी तुल्याउनको निम्ति एउटा बाछा, एउटा भेडा र सातवटा एक वर्षे थुमाहरू चढाउनु पर्छ। ती बलि चढाइने पशुहरूमा कुनै खोट हुनुहुँदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","यी बाछा, भेडा र थुमाहरू चढाउँदा यिनीहरूको तोकिएको संख्या अनुसार चढाउनु पर्छ र अन्नबलि र अर्घबलि पनि सही परिमाणको चढाउनुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","तिमीहरूले पाप बलिको निम्ति एउटा बोको पनि चढाउनुपर्छ। यो बलि तिमीहरूले चढाउने दैनिकबलि, त्यससित चढाइने अन्नबलि तथा अर्घबलिको अतिरिक्त हो। ");
INSERT INTO npi2010_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“विशेष उत्सवहरूमा होमबलि, अन्नबलि, अर्घबलि तथा मेलबलि तिमीहरूले परमप्रभुलाई चढाउनु पर्छ। यो बलि तिमीहरूले चढाउनु खोजेको कुनै विशेष बलि तथा कुनै भाकल बलिको अतिरिक्त हो।” ");
INSERT INTO npi2010_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","परमप्रभुले मोशालाई आज्ञादिनुभए अनुसार तिनले सबै कुराहरू इस्राएली मानिसहरूलाई बताए। ");
INSERT INTO npi2010_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मोशाले इस्राएलीहरूका कुलनायक व्यक्तिहरूलाई भने परमप्रभुले आज्ञा गर्नु भएको कुराहरू यही हुन्; ");
INSERT INTO npi2010_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“जब एकजना व्यक्तिले परमप्रभुलाई केही चढाउँछु भनी विशेष शपथ गर्छ अथवा परमप्रभुको नाममा केही गर्छु भनी वाचा बन्धन गर्छ भने उसले त्यो शपथ अथवा वाचा बन्धन खेर फाल्नु हुँदैन। उसको मुखबाट निस्केको वचन पुरा गर्नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“तर केही जवान स्त्री तिनको बाबुको घरमा रहँदा नै परमप्रभुलाई केही चढाउँछु भनी विशेष भाकल गरेकी छे अथवा परमप्रभुको नाममा केही गर्छु भनी वाचा बन्धन खाएकी भए। ");
INSERT INTO npi2010_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","र उसको बाबुले सुनेर पनि केही आफ्त्ति नगरे उसले त्यो आफ्नो भाकल अथवा वाचा बन्धन पुरा गर्नैपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","तर यदि तिनका बाबुले यसको बारेमा सुने भने र उनलाई त्यसो गर्नबाट रोके भने, उनले प्रतिज्ञा गरेको कुरा पूरा गर्नु पर्दैन। किनभने उनको बाबुले उनलाई मनाही गरे र परमप्रभुले उनलाई क्षमा दिनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“अनि यदि तिनी एउटा पतिसित विवाह गरेकी छिन् अनि यस्तो केही गर्ने शपथ अथवा प्रतिज्ञा बनाइन् भने। ");
INSERT INTO npi2010_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","अनि यदि तिनका पतिले यस विषयमा सुनेर र तिनलाई रोक्दैनन् भने, तिनले तिनका भाकलहरू अथवा वाचाहरू गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","तर उसको लोग्नेले कुनै दिन चाल पाएर विरोध गरे उसको भाकल अथवा वाचा बन्धन भङ्ग हुन्छ अनि परमप्रभुले पनि उसलाई क्षमा दिनुहुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“विधवा अथवा आफ्नो पतिसित छुटानाम गरेकी स्त्रीले प्रत्येक भाकल वा शपथ पूरा गर्नु नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“तर कुनै विवाह भएकी स्त्रीले आफ्नो पतिको घरमा आएर भाकल गर्छे वा वाचा बन्धन खान्छे ");
INSERT INTO npi2010_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","अनि उसको लोग्नेले चाल पाएर पनि कुनै विरोध नगरे तब उसको सबै शपथ वा वाचा बन्धन पूरा गर्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","तर यदि उसको लोग्नेले चाल पाएर उसले विरोध गरे उसको शपथ वा वाचा बन्धन त्यहीं अवैद्ध हुन्छ। उसको लोग्नेले विरोध गरेकोले परमप्रभुले उसलाई क्षमा गर्नुहुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","पतिले उसकी पत्नीलाई उसको विरोध गरेर भङ्ग पनि गराउनु सक्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","यदि पत्नीले गरेको शपथ वा खाएको वाचा बन्धनको विषय लोग्नेले चाल पाएर पनि त्यस दिन विरोध नगरे त्यस स्त्री आफ्नो शपथ वा वाचा बन्धनको प्रत्येक चीज पूरा गर्नु पर्छ। कारण उसले चाल पाएर पनि विरोध गरेको छैन। ");
INSERT INTO npi2010_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","तर पत्नी गरेको शपथ वा वाचा बन्धन चाल पाएर पतिले भङ्ग गरी दिन्छ भने शपथ वा वाचा बन्धन भङ्ग गरिदिएकोमा उत्तरदायी तिनको लोग्ने हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","लोग्ने-पत्नी तथा विवाह पूर्व आफ्नो आमा-बाबुको घरमा बसेकी जवान केटीको विषयमा परमप्रभुले मोशालाई दिनु भएको नियमहरू यिनीहरू नै हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“मिद्यानीहरूले इस्राएलीहरू माथि गरेको अन्यायमा तिनीहरूलाई दण्ड देऊ। त्यस पछि, मोशा, तिमी तिम्रा पिता-पुर्खाहरूसित मिल्न जानेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","यसर्थ मोशाले मानिसहरूलाई यसो भने, “मिद्यानीहरूसित बद्ला लिन युद्ध गर्नको निम्ति तिमीहरूले आफ्नो मानिसहरूबाट सेनाहरू तयार पार। ");
INSERT INTO npi2010_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएलीहरूको प्रत्येक कुलबाट एक हजार मानिसहरू निकाल्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","इस्राएलीहरूको बाह्र कुलहरूबाट बाह्र हजार सेनाहरू हुनेछन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मोशाले बाह्र हजार इस्राएलीहरू युद्धमा पठाए। तिनले पूजाहारी एलाजारको छोरो पीनहासलाई पनि तिनीहरूसित पठाए। पीनहासले आफूसित पवित्र चीजहरू युद्ध-ध्वनी तथा तुरहीहरू लिएर गए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","परमप्रभुको आज्ञा बमोजिम इस्राएली सेनाहरू मिद्यानी मानिसहरू विरूद्ध लडे। तिनीहरूले त्यस अञ्चलमा भएका प्रत्येक मिद्यानी पुरूषलाई मारे। ");
INSERT INTO npi2010_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","तिनीहरूले एवी, रेकेम, सूर, हूर र रेर्वा गरी पाँच जना मिद्यानी राजाहरू मारिदिएर बोरको छोरो बिलामलाई पनि तिनीहरूले मारे। ");
INSERT INTO npi2010_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएली मानिसहरूले मिद्यानी स्त्रीहरूलाई र बाल-बच्चाहरूलाई कैद गरे अनि तिनीहरूको सबै सम्पत्ति, सबै गाई-वस्तु तथा भेडाहरू पनि लगे। ");
INSERT INTO npi2010_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","तिनीहरूले मिद्यानीहरूको गाँउ-वस्ती तथा शहरहरू पनि जलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","इस्राएलीहरूले तिनीहरूको मानिस तथा पशुहरू मोशा, पूजाहारी एलाजार अनि ");
INSERT INTO npi2010_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","इस्राएली अरू मानिसहरूकहाँ ल्याए। युद्धमा तिनीहरूले जे जति लिए सबै इस्राएलीहरूको छाउनीमा ल्याए। इस्राएली मानिसहरूको छाउनी मोआबको यर्दन बेंसीमा थियो। त्यो यरीहोदेखि पारी यर्दन नदीको पूर्वपट्टि थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","तब मोशा पूजाहारी एलाजार तथा इस्राएली प्रमुख व्यक्तिहरू छाउनीबाट बाहिर ती सेनाहरूलाई भेट्न गए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","मोशा इस्राएली एक हजार सेनाका सेनापति र एक सय सेनाका सेनापतिहरूसित जो युद्धबाट फर्केका थिए अत्यन्तै क्रोधित भएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशाले तिनीहरूलाई भने, “यी स्त्रीहरूलाई तिमीहरूले किन जिउँदो राख्यौ? ");
INSERT INTO npi2010_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","छुट्टानाम भएका स्त्रीहरूले बिलामको उपदेश अनुसार इस्राएलीका मानिसहरूलाई यी स्त्रीहरूले परमप्रभु देखि टाढा गराउन प्रभावित गराएका थिए। यही कारणले मानिसहरूमा विपत्ति पनि आइलागेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","यसकारण ती सबै बालकहरूलाई मार र ती पुरूषहरूसित सहवास भएका सबै स्त्रीहरूलाई मार। ");
INSERT INTO npi2010_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","तर शारीरिक सम्बन्ध नगरेका कन्ये केटीहरूलाई तिमीहरूको निम्ति राख। ");
INSERT INTO npi2010_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","तिमीहरू सात दिन सम्म छाउनी बाहिर रहनु पर्छ। तिमीहरू मध्ये प्रत्येक व्यक्ति अथवा तिमीहरूका कैदीहरू जसले कुनै व्यक्तिलाई मारेको छ अथवा मरेको लाश छोएकोछ उसले आफैंलाई तेस्रो दिन र सातौं दिनमा शुद्ध पार्नुपर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","तिमीहरूले प्रत्येक लुगा, छालाले बनिएको प्रत्येक चीज, बाख्राको भुत्लाले बनिएको प्रत्येक चीज तथा काठले बनिएको प्रत्येक चीज सबै शुद्ध पार्नुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","त्यसपछि पूजाहारी एलाजारले युद्धमा गएका सबै सेनाहरूलाई भने, “परमप्रभुले मोशालाई यस्तो आज्ञा गर्नु भएको छ, ");
INSERT INTO npi2010_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","सुन, चाँदी, काँसो, फलाम, जस्ता र सीसा चीजहरू ");
INSERT INTO npi2010_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","आगोलाई प्रतिरोध गर्ने प्रत्येक कुरालाई आगो प्रयोग गरेर शुद्ध पार्नु पर्छ अनि यसलाई शुद्धीकरणको पानीले शुद्ध गर्नुपर्छ, तब यो शुद्ध हुनेछ। तिमीहरूले प्रत्येक कुरालाई पानीसित अवश्यै शुद्ध गर्नु पर्छ त्यो आगोले प्रतिरोध गर्ने सकिदैन। ");
INSERT INTO npi2010_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","सातौं दिनमा आफ्नो लुगा-फाटाहरू धुनु पर्छ अनि तिमीहरू शुद्ध हुनेछौ। त्यसपछि तिमीहरू छाउनीभित्र पस्नू।” ");
INSERT INTO npi2010_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“पूजाहारी एलाजार सारा समुदायका प्रधानहरू र तिमीले सबै कैदीहरू, पशुहरू र सेनाहरूले युद्धबाट ल्याएका सबै चीजहरू गन। ");
INSERT INTO npi2010_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","तब युद्धमा गएका सेनाहरू र अरू बाँकी इस्राएली मानिसहरू माझ भाग लगाऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","मानिस, गाई-वस्तु, भेडा र गधा यी सब सेनाहरूले युद्धबाट ल्याएका प्रत्येक पाँच सय चीजहरूबाट परमप्रभुको निम्ति एउटा कर हिसाबमा राख। ");
INSERT INTO npi2010_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","तिनीहरूको अशंको आधा अंश यी चीजहरू लिएर परमप्रभुको निम्ति भेटी स्वरूप पूजाहारी एलाजारलाई देऊ। ");
INSERT INTO npi2010_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","प्रत्येक पचास चीजहरूबाट (जो मानिसहरू गाइहरू, गधाहरू, भेडा र अन्य पशुहरूलाई समिलित गर्छ) आधा भाग इस्राएलीहरूलाई दिएकाबाट एउटा लिएर लेवीहरूलाई देऊ जसले परमप्रभुको पवित्र पालको हेर चाह गर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","परमप्रभुले मोशालाई दिनुभएको आज्ञा अनुसार मोशा र पूजाहारी एलाजारले इस्राएली सेनाहरूले युद्धबाट ल्याएका समानहरू वितरण गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","इस्राएली सेनाहरूले युद्धबाट यी पशु र मानिसहरू ल्याएका थिएः भेडा 6,75,000, ");
INSERT INTO npi2010_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","गाई-गोरू 72,000, ");
INSERT INTO npi2010_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","गधा 61,000 अनि ");
INSERT INTO npi2010_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","स्त्रीहरू 32,000 यी स्त्रीहरू हुन् जसले पुरूषसित शारीरिक सम्बन्ध राखेका थिएनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ती सेनाहरू जो युद्धमा गएका थिए तिनीहरूले 3,37,500 भेडाहरू पाए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","तिनीहरूले आफ्नो भागबाट 675 वटा भेडाहरू परमप्रभुलाई चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","तिनीहरूले पाएका 36,000 गाई-गोरूहरूबाट परमप्रभुलाई 72 वटा कर हिसाबमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","तिनीहरूले 30,500 गधाहरू पाए र यसबाट परमप्रभुलाई 61 वटा कर हिसाबमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","तिनीहरूले 16,000 स्त्रीहरू पाए र यसबाट परमप्रभुलाई 31 जना कर हिसाबमा चढाए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","परमप्रभुले मोशालाई भन्नु भए झैं मोशाले यी सब उपहारहरू परमप्रभुको निम्ति पूजाहारी एलाजारलाई दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","युद्धमा गएका सेनाहरूले ल्याएको सम्पत्तिबाट मोशाले बाँडेको इस्राएली मानिसहरूको आधा भाग यस्तो थियोः ");
INSERT INTO npi2010_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","भेडा 3,36,500, ");
INSERT INTO npi2010_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","गाई-गोरू 36,000, ");
INSERT INTO npi2010_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","गधा 30,500, ");
INSERT INTO npi2010_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","स्त्रीहरू 16,000 ");
INSERT INTO npi2010_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","यसरी इस्राएली मानिसहरूको भागमा परेका पशु र मानिसहरूबाट प्रत्येक पचासमा एउटा गरी लिएर मोशाले परमप्रभुको पवित्र पालको रक्षा गर्ने लेवीहरूलाई दिए। परमप्रभुको आज्ञा बमोजिम मोशाले यसो गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","त्यसपछि एक हजार इस्राएली सेनाका कप्तानहरू र एक सय सेनाका कप्तानहरू मोशाकहाँ आए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","तिनीहरूले मोशालाई भने, “हामी तपाईंका सेवकहरूले हाम्रा अधीनमा रहेका सबै सेनाहरू गन्यौ तिनीहरू मध्ये हामीले कसैलाई पनि गुमाएनौं। ");
INSERT INTO npi2010_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","हामीले सुनका चीजहरूः पैरा, बाला, छाप, औंठी, कुण्डल र बाजूहरू त्यो हामीले हाम्रो परमप्रभुलाई उपहार जस्तै परमप्रभूको अघि हाम्रो आफ्नै प्रायश्चितको निम्ति चढायौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशा र एलाजारले तिनीहरूबाट सुनको गहनाहरू थापे। ");
INSERT INTO npi2010_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ती सबै एक हजार सेनाहरूका र एक सय सेनाहरूका कप्तानहरूले चढाएको सुनको ओजन 16,750 शेकेल थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","सेनाहरू मध्ये प्रत्येकले आफ्नो निम्ति केही चीजहरू लिएका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","यसर्थ मोशा र पूजाहारी एलाजारले परमप्रभु अघि इस्राएली मानिसहरूको स्मृति चिन्ह स्वरूप ती सुनको गहनाहरू एक हजार र एक सय सेनाहरूका कप्तानहरूबाट लिएर भेट हुने पालमा राखे। ");
INSERT INTO npi2010_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबेन र गाद वंशका मानिसहरूको धेरै धेरै गाई-वस्तुहरू थिए। यसर्थ जब तिनीहरूले याजेर र गिलादको भूमि देखे तिनीहरूले ती ठाँउहरू पशुपालनको निम्ति उपयुक्त सम्झे। ");
INSERT INTO npi2010_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","यसर्थ रूबेन र गाद कुलका मानिसहरू मोशा, पूजाहारी एलाजार तथा इज्राएली मानिसहरूको प्रधानहरूकहाँ गई भने, ");
INSERT INTO npi2010_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“अतारोत, दीबोन, याजेर, निम्रा, हेसबोन, एलाले, सबाम, नबो अनि बओन ");
INSERT INTO npi2010_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","जुन भूमि परमप्रभुले इस्राएली मानिसहरूको निम्ति जित्नु भएको थियो, ती भूमिहरू पशु पालनको निम्ति उचित रहेकोले र हामी तपाईंको सेवकहरूकहाँ गाई-वस्तु धेरै भएकोले। ");
INSERT INTO npi2010_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","यदि तपाईं हामीसित खुशी हुनुहुन्छ भने ती भूमिहरू हामीलाई दिइयोस्। हामी यर्दन नदी पारी जानु नपरोस्।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मोशाले रूबेनका मानिसहरू र गादका कुल समूहलाई भने, “तिमीहरूका दज्यू-भाइहरू युद्धमा जानु पर्छ। जब तिमीहरू यहाँ सदा सर्वदा बस्दा? ");
INSERT INTO npi2010_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","यर्दन नदी पारी परमप्रभुले तिनीहरूलाई दिन चहानु भएको भूमिमा जानलाई किन तिमीहरू इस्राएली मानिसहरूलाई निरूत्साहित पार्न चेष्टा गरिरहेकाछौ? ");
INSERT INTO npi2010_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","तिमीहरूका बाबुहरूले पनि त्यसै गरेका थिए जति बेला मैले तिनीहरूलाई कादेश-बर्नेबाट त्यो भूमिको जाँच गर्न पठाएको थिएँ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","तिनीहरू एश्कोल बेंसी सम्म पुगे अनि त्यो भूमिको निरीक्षण पनि गरे तर तिनीहरूले इस्राएलका मानिसहरूलाई परमप्रभुले दिनु भएको भूमिमा जान हतोत्साहित बनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","यसर्थ ती मानिसहरूसित परमप्रभु रिसाउनु भयो र शपथ गर्नु भयो कि, ");
INSERT INTO npi2010_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘बीस अनि बीस भन्दा वेशी उमेर पुगेका मानिसहरू जो मिश्रबाट आएका छन् तिनीहरूलाई मैले अब्राहाम, इसहाक र याकूबलाई दिन्छु भनी शपथ गरेको भूमि देख्न पाउने छैनन्। ");
INSERT INTO npi2010_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","किनभने कनज्जी, यपून्नेका छोरो कालेब र नूनको छोरो यहोशू बाहेक तिनीहरू कसैले पनि मलाई पूर्ण रूपले विश्वास गरेनन्। यपून्नेका छोरो कालेब र नूनको छोरो यहोशूले मात्र मलाई विशवास गरे।’ ");
INSERT INTO npi2010_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","“इस्राएली मानिसहरूसित परमप्रभु क्रोधित हुनुभयो र उहाँको नजरमा ती मानिसहरू जसले दुष्टता देखाएका थिए सबै नष्ट नहोउञ्जेल चालीस वर्ष सम्म उहाँले तिनीहरूलाई मरूभूमिमा यता उता डुलाउनु भयो। ");
INSERT INTO npi2010_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","हे पापिष्टका सन्तानहरू हो। तिमीहरू इस्राएली मानिसहरूमाथि परमप्रभुको क्रोध पार्न तिमीहरूले आफ्ना पुर्खाहरूको जग्गा ओगटेका छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","यदि तिमीहरूले उहाँलाई पछ्याउन छाडे इस्राएली मानिसहरूलाई उहाँले यही मरूभूमिमा नै त्याग्नु हुनेछ र तिमीहरूले सबै मानिसहरूलाई ध्वंश पार्नेछौ।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","तर रूबेन र गाद कुलका मानिसहरू मोशाकहाँ गएर भने, “हामी यहाँ आफ्नो गाई वस्तुहरूको निम्ति गोठ तथा जहान बाल-बच्चाहरूको निम्ति शहर तयार पार्छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","तब यहाँ भएका मानिसहरूबाट हाम्रा नानीहरूको बचाऊ हुन्छ। तर हामी अन्य इस्राएली मानिसहरूलाई सर्हषसाथ उनीहरूको भूमिमा पुर्याउन सहायता गर्छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","जबसम्म ती मानिसहरूले आफ्नो-आफ्नो हिस्साको भूमि पूरै दखलमा गर्दैनन तबसम्म हामी आफ्नो घर फर्केर आउने छैनौं। ");
INSERT INTO npi2010_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","यर्दन नदी पारिको जमीन हामी लिने छैनौ कारण हाम्रा जमीन यर्दन नदी वारि पूर्व पट्टि नै हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","तब मोशाले तिनीहरूलाई भने, “यदि तिमीहरू यी सब कामहरू गर्छौ भने यो भूमि तिमीहरूकै हुन्छ। तर तिमीहरूका सेनाहरू परमप्रभु सम्मुख युद्धमा जानै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","तिमीहरूका सेनाहरूले यर्दन नदी पार गरी शत्रुहरूलाई बलपूर्वक त्यो भूमिबाट निकाल्नु नै पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","तिमीहरू त्यति बेला आफ्नो घर फर्कनु सक्छौ जब परमप्रभुले हामीलाई पूरा भूमि लिन सहायता गर्नु हुन्छ। तब परमप्रभु र इस्राएलका मानिसहरूले तिमीहरूलाई दोषी ठराउदैनन्। परमप्रभुले तिमीहरूलाई तिमीहरूको भूमि ग्रहण गर्न दिनु हुन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","तर यदि तिमीहरूले यी कामहर गरेनौ भने तिमीहरू परमप्रभुको इच्छा विरूद्ध पाप गर्नेछौ र तिमीहरू निश्चय जान्दछौ कि तिमीहरूले त्यो पापको निम्ति दण्ड पाउनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","गाई-वस्तुहरूको निम्ति गोठ र बाल-बच्चाहरूको निम्ति शहरहरू बनाऊ, तर याद गर कि तिमीहरूले आफ्नो प्रतिज्ञा पूरा गर्नुपर्छ।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","त्यसपछि रूबेन गाद कुलका मानिसहरूले मोशालाई भने, “हामी तपाईंका सेवक हौं, हजूर हाम्रा मालिक हुनुहुन्छ र हजूरले भन्नु भएको काम हामी निश्चय गर्नेछौं। ");
INSERT INTO npi2010_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","हाम्रा जहान बाल-बच्चाहरू र गाई-वस्तुहरू यही गिलाद शहरमा रहनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","तर हामी हजूरका दासहरू, जस्तो मालिकको हुकुम हुन्छ परमप्रभुको अघिबाट यर्दन नदी पार गरी युद्धमा जानेछौं।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","तब मोशा, पूजाहारी एलाजारले आज्ञा दिए, नूनको छोरो यहोशू अनि इस्राएली मानिसहरूका प्रधानहरूले तिनीहरूलाई आदर गर्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","मोशाले तिनीहरूलाई भने, “गाद र रूबेनका मानिसहरू यर्दन नदी पार गरी परमप्रभुको अघिबाट हिंड्दै युद्धमा जानेछन् र तिमीहरूलाई भूमि दखल गर्नु सहायता गर्नेछन्। अनि तिमीहरूले तिनीहरूलाई गिलादको भूमि तिनीहरूकै भाग पार्न दिनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","तर यदि तिनीहरू तिमीहरूसित युद्धमा गएनन् भने, तिनीहरूले कनान भूमिमा तिमीहरूसित उत्तराधिकार भाग मात्र पाउने छन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","गाद र रूबेनका मानिसहरूले उत्तर दिए, “परमप्रभुबाट जो आज्ञा हुन्छ त्यो पूरा गर्न हामी प्रतिज्ञा गर्छौ। ");
INSERT INTO npi2010_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","हामी यर्दन नदी पार गरी परमप्रभुको अघिबाट हुँदै कनानको भूमिमा जानेछौ। अनि हाम्रो भूभाग यर्दन नदीको पूर्व भाग हुनेछ।” ");
INSERT INTO npi2010_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","यसकारण मोशाले त्यो भूमि गादका मानिसहरू रूबेनका मानिसरू अनि मनश्शेका आधा कुल समूहहरूलाई दिए। (मनश्शे यूसुफका छोरा थिए।) त्यो भूमि एमोरीहरूको राज्य सीहोन र ओगका राज्य, बशानका राजा सम्मिलित हुन्छ। त्यो भूमिमा वरिपरिका सबै शहरहरू सम्मिलित भए। ");
INSERT INTO npi2010_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","गादका मानिसहरूले दीबोन, अतारोत, अरोएर शहरहरू बनाए। ");
INSERT INTO npi2010_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अतारोत-शोपान, याजेर, योगबहा, ");
INSERT INTO npi2010_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेत-निम्रा, अनि बेथारान जुन चाहि सुरक्षित शहरहरू थिए अनि तिनीहरूको झुण्डको निम्ति भेडाको खोरहरू निर्माण गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","रूबेनका कुलले हेशबोन, एलाले, किर्यातैम, ");
INSERT INTO npi2010_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","नबो, बालमोन र सिब्मा यसलाई नयाँ बनाए। तिनीहरूले नेबो र बालमोन नाम परिवर्त्तन गरिदिए अनि तिमीहरूले शहरहरूलाई आफ्नै नाम दिए जुन तिनीहरूले निमार्ण गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनश्शेका छोरो माकीरको वंशका मानिसहरू गिलाद गए। तिनीहरूले एमोरीहरूका शहरहरु जिते र त्यही बसे। ");
INSERT INTO npi2010_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","यसकारण मनश्शेका छोरो माकीरलाई मोशाले गिलाद दिए अनि तिनीहरू त्यही स्थायी भई बसे। ");
INSERT INTO npi2010_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनश्शे कुलका याईर गई त्यहाँका साना साना शहरहरू जिते। तब तिनीहरूले ती शहरहरूको नाम याईरका शहरहरू, स-साना राखे। ");
INSERT INTO npi2010_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","नोबहले केनात र यसका स-साना शहरहरू पराजित गरे उसलाई सबै ठाउँहरूलाई उसको आफ्नै नाम नोबह दिए। ");
INSERT INTO npi2010_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","मोशा र हारूनको नेतृत्वमा दल-दलमा आएका इस्राएलीहरूको यात्रा विवरण यस प्रकारका छन्। तिनीहरूको यात्रा विवरण सहित यिनै जग्गाहरूबाट यात्रा गरेका हुन्। ");
INSERT INTO npi2010_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","मोशाले इस्राएलीहरूको यात्रा विवरण परमप्रभुको इच्छा अनुसार लेखे। ");
INSERT INTO npi2010_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","पहिलो महीनाको पन्ध्रौं दिन तिनीहरूले रामसेसबाट यात्रा शुरू गरे। निस्तार-चाडको पछिल्लो बिहान इस्राएलीहरूले मिश्र देशवासिहरूको सामुन्नेबाट साहसिलो प्रकारले यात्रा गरे। ");
INSERT INTO npi2010_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","त्यस समय मिश्रीहरूले तिनीरूको पहिला जन्मेका छोराहरूलाई गाड्दै थिए जब तिनीहरूलाई र तिनीहरूका देवताहरूलाई परमप्रभुले न्याय गरेका थिए। ");
INSERT INTO npi2010_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इस्राएलका मानिसहरू रामसेसबाट यात्रा गरी सुक्कोत पुगे। ");
INSERT INTO npi2010_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","सुक्कोतबाट तिनीहरूले एताम पुगेर मरूभूमिको किनारमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","तिनीहरूले एतामबाट यात्रा गरेर बाल-सपोनको नजीक पीहहीरोतमा गए। तिनीहरूले मिग्दोल नजीक छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ती यात्रीहरू पीहहीरोतबाट गएर समुद्रको बीचबाट मरूभूमिमा पसे एतामको मरूभूमिमा तीन दिन सम्म यात्रा गरी तिनीहरूले मारामा छाउनी बसाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","तिनीहरूले माराबाट यात्रा गरी एलीम पुगे। त्यहाँ बाह्रवटा पानीको फोहराहरू सत्तरीवटा खजूरको रूखहरू थिए। यसकारण तिनीहरूले त्यही छाउनी बसाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ती मानिसहरूले एलीमबाट यात्रा गरी लाल-समुद्र नजीक छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","तिनीहरूले लाल-समुद्रबाट यात्रा गरी सीन मरूभूमिमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ती मानिसहरूले सीन मरूभूमिबाट यात्रा गरी दोफकामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ती मानिसहरूले दोफकाबाट यात्रा गरी आलूशमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ती मानिसहरूले आलूशबाट यात्री गरी रपीदीममा छाउनी हाले। त्यस ठाँउमा मानिसहरूको निम्ति पिउने पानी थिएन। ");
INSERT INTO npi2010_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ती मानिसहरूले रपीदीमबाट यात्रा गरी सीनै मरूभूमिमा आफ्नो छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ती मानिसहरूले सीनै मरूभूमिबाट यात्रा गरी किब्रोथ-हत्तावामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ती मानिसहरूले किब्रोथ-हत्तावाबाट यात्रा गरी हसेरोतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ती मानिसहरूले हसेरोतबाट यात्रा गरी रित्मामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ती मानिसहरूले रित्माबाट यात्रा गरी रिम्मोन परेशमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ती मानिसहरूले रिम्मोन-परेशबाट यात्रा गरी लिब्नामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ती मानिसहरूले लिब्नाबाट यात्रा गरी रिस्सामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ती मानिसहरूले रिस्साबाट यात्रा गरी केहेलातामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ती मानिसहरूले केहेलाताबाट यात्रा गरी पर्वत शेपेरमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ती मानिसहरूले पर्वत शेपेरबाट यात्रा गरी हरादामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ती मानिसहरूले हरादाबाट यात्रा गरी मखेलोतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ती मानिसहरूले मखेलोतबाट यात्रा गरी तहतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ती मानिसहरूले तहतबाट यात्रा गरी तेरहमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ती मानिसहरूले तेरहबाट यात्रा गरी मित्कामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ती मानिसहरूले मित्काबाट यात्रा गरी हरामोनामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ती मानिसहरूले हरामोनाबाट यात्रा गरी मसेरोतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ती मानिसहरूले मसेरोतबाट यात्रा गरी बनि-याकानमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ती मानिसहरूले बनि-याकानबाट यात्रा गरी होरहगिद-गादमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ती मानिसहरूले होरहगिद-गादबाट यात्रा गरी योतबातामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ती मानिसहरूले योतबाताबाट यात्रा गरी अब्रोनामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ती मानिसहरूले अब्रोनाबाट यात्रा गरी एस्योन-गेबेरमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ती मानिसहरूले एस्योन-गेबेरबाट यात्रा गरी सीन मरूभूमिको कादेशमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ती मानिसहरूले कादेशबाट यात्रा गरी होरमा छाउनी हाले। यो ठाँउ एदोम देशको सिमानाको पर्वत हो। ");
INSERT INTO npi2010_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","परमप्रभुको आज्ञालाई पालन गरेर, पूजाहरूरी हारून होर पर्वत माथि गए अनि त्यहाँ मरे। हारून मरेको दिन पाँचौं महीनाको पहिलो दिन थियो र इस्राएलीहरूले मिश्र छोडको चालीस वर्ष पुगेको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","जब हारूनको मृत्यु होर पर्वतमा भयो तिनको उमेर 123 वर्ष भएको थियो। ");
INSERT INTO npi2010_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","कनान देशको नेगवमा अराद भन्ने एउटा शहर थियो। त्यस ठाँउमा कनानको राजाले इस्राएली मानिसहरू आइरहेको सुने। ");
INSERT INTO npi2010_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ती मानिसहरूले होर पर्वतबाट यात्रा गरी सल-मोनामा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ती मानिसहरूले सल-मोनाबाट यात्रा शुरू गरी पूनोनमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ती मानिसहरूले पूनोनबाट यात्रा गरी ओबोतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ती मानिसहरूले ओबोतबाट यात्रा गरी मोआबका सिमानामा रहेको इय्ये-अबारीममा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ती मानिसहरूले इय्ये-अबारीमबाट यात्रा गरी दीबोन-गादमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ती मानिसहरूले दीबोन-गादबाट यात्रा गरी अल्मोन-दिब्लातैममा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ती मानिसहरूले अल्मोन-दिब्लातैमबाट यात्रा गरी नबोको नजीक अबारीमको पर्वतमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ती मानिसहरूले अबारीमको पर्वतबाट यात्रा गरी यरीहोको पारीको यर्दन नदीको नजीक मोआबको यर्दन बेंसीमा छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","मोआबको मैदानमा ती मानिसहरूले यर्दन नदीको किनार यर्दन बेंसीमा बते-योशी-मातदेखि आबेल-शीत्तिम सम्म छाउनी हाले। ");
INSERT INTO npi2010_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","येरीको पारि यर्दन नदी नजीकै मोआबको मैदानमा परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएलीहरूलाई भन: जब तिमीहरू कनान भूमिमा यर्दन नदी पार गर्छौ, ");
INSERT INTO npi2010_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","तिमीहरूले ती कनानमा बस्नेहरूलाई जबरजस्ती खेदूनु पर्छ। तिमीहरूले तिनीहरूका सबै खोपेर बनाएको मूर्तिहरू र धातुको मूर्तिहरू नष्ट पारिदिनु पर्छ। तिनीहरूको डाँडाका थानहरू सब भत्काइदिनु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","मैले तिमीहरूलाई त्यो भूमि आफ्नो दखलमा राख्न दिएकोले तब तिमीहरूले त्यसमा बसो बास गर्नु पर्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","तिमीहरूको सम्मानित राजवंश अनुसार तिमीहरूका भूमिका भागहरू चिठ्ठा लगाएर लैजाऊ। ठूला भागहरू ठूला परिवारहरूलाई अनि साना भाग साना परिवारहरूलाई देऊ। जहाँ जहाँ चिट्ठा पर्छ त्यही भूमि लेऊ तिनीहरूले तिमीहरूको भाग तिमीहरूको पिता-पूर्खाहरूको परिवार अनुसार पाउँनेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“यदि तिमीहरूले ती त्यहाँका बासिन्दाहरूलाई बलपूर्वक लखेटेनौ भने त्यहाँ रहेकाहरू तिमीहरूको निम्ति तिनीहरू आँखामा विझेको छेस्का अथवा शरीरमा बिझेको काँढा झैं हुनेछ। तिमीहरू बसेको भूमिमा तिनीहरूले तिमीहरूलाई झंझटमा फसाउनेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","तब म तिमीहरूलाई त्यही व्यवहार गर्नेछु जो मैले तिनीहरूसित गुर्छ भनी योजना बनाएकोछु।” ");
INSERT INTO npi2010_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इस्राएलका मानिसहरूलाई यो आदेश देऊः जब तिमीहरू कनान देशमा पस्नेछौ, तिमीहरूलाई दिइएको भूमिको सिमाना यस प्रकार हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","त्यस भूमिको दक्षिण तिर एदोमको नजीक सीन मरूभूमिको केही भाग रहनेछ। त्यस भूमिको दक्षिणी सिमाना खारा समुद्रको पूर्व भागबाट नै शुरू हुनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","यो सिमानाले अक्राबीमको दक्षिणी भाग नाघेर सीन मरूभूमि हुँदै यसको दक्षिण भागको सिमाना कादेश-वर्ने पर्नेछ। यस सिमानाले हसार अदूदार पुगेर आस्मोन नाघ्नेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","सिमाना अस्मोनबाट मिश्र नदी तिर जानेछ र यो भूमध्य समुद्रमा गई टुङ्गिन्छ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","यसको पश्चिमी सिमान भूमध्य समुद्रको किनार हुनेछ र यो तिमीहरूको देशको पश्चिमी सिमाना हो। ");
INSERT INTO npi2010_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","अब आयो तिमीहरूको भूमिको उत्तरी सिमानाः यो सिमाना भूमध्य समुद्र हुँदै होर पर्वतसम्म जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","होर पर्वतबाट उत्तरी सिमाना फैलिएर सोझो लेबो-हमात पुग्नेछ र त्यसपछि यो सदादसम्म फैलिएर जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","तिमीहरूको उत्तरी सिमाना फैलिएर सिप्रोन सम्म गई हसर एनानमा टुङ्गिनेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","तिमीहरूको देशको पूर्वीय सिमाना हसर-एनान देखि शपाम सम्म जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","शपामबाट यो सिमाना ऐनको पूर्व भएर रिब्लासम्म जान्छ र पहाडबाट ओह्रालो हुँदै गालील समुद्रको छेउ सम्म जानेछ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","त्यसपछि सिमाना यर्दन नदी तिर फैलिंदै खारा समुद्रमा अन्त हुनेछ। तिमीहरूको भूमिको वरिपरिका सिमानाहरू यिनै हुन्।” ");
INSERT INTO npi2010_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","यसर्थ मोशाले इस्राएलका मानिसहरूलाई यो आदेश दिए, “तिमीहरूले पाउने भूमि यही नै हो। तिमीहरूले आफ्नो नौं कुलहरू र मनश्शे कुलको आधा समूहहरू गरी साढे नौ कुलहरूमा चिठ्ठा गरेर भूमि वितरण गर्नेछौ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","रूबेन, गाद आफ्नो निम्ति भूमिको हिस्सा लिई सके। ");
INSERT INTO npi2010_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ती अढाई कुलका समूहहरूले यर्दन नदी पूर्व यशीहोको नजीक आफ्नो निम्ति भूमि लिए।” ");
INSERT INTO npi2010_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","त्यसपछि परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“यी मानिसहरू पूजाहारी एलाजार अनि नूनका छोरो यहोशूले तिमीहरूलाई भूमि वितरणमा सहायता गर्नेछन्। ");
INSERT INTO npi2010_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","प्रत्येक कुलसमूहबाट एकजना प्रमुखले पनि भूमि वितरण कार्यमा सहायता गर्ने छ। ");
INSERT INTO npi2010_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ती कुलसमूह नायकहरूको नाम यस प्रकार छः यहूदाको कुलबाट यपून्नेका छोरो कालेब, ");
INSERT INTO npi2010_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","सिमोनको कुलबाट अम्मीहूदको छोरो शेमूएल, ");
INSERT INTO npi2010_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बिन्यामीनको कुलबाट किसलोनको छोरो एलीदाद, ");
INSERT INTO npi2010_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दानको कुलबाट योगीलीको छोरो बुक्की, ");
INSERT INTO npi2010_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","यूसुफको सन्तानहरू, मनश्शे कुलबाट एपोदको छोरो हन्नीयल, ");
INSERT INTO npi2010_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","यूसुफको छोरो एप्रैम कुलबाट सिप्तानको छोरो कमूएल, ");
INSERT INTO npi2010_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबूलून कुलबाट पर्नाकको छोरो एलीशापन, ");
INSERT INTO npi2010_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्साकार कुलबाट अज्जानको छोरो पलतीयल, ");
INSERT INTO npi2010_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेरको कुलबाट शलोमीको छोरो अहीहूद, ");
INSERT INTO npi2010_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नप्तालीको कुलबाट अम्मीहूदका छोरो पदहेल।” ");
INSERT INTO npi2010_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","इस्राएली मानिसहरूलाई भूमि वितरण कार्यमा परमप्रभुले यी मानिसहरूलाई नियुक्त गर्नुभयो। ");
INSERT INTO npi2010_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","येरीहोदेखि पारी मोआबमा यर्दन नदीको नजिकै यर्दन बेंसीमा परमप्रभुले मोशालाई भन्नुभयो, ");
INSERT INTO npi2010_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2",